﻿USE sofia;
DROP TABLE IF EXISTS sofia.sgz_vpl;
CREATE TABLE sgz_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sgz_vpl WRITE;
INSERT INTO sgz_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Minái á ngisán tan kálámul er a páng tili di ái Iesu Karisito má di tangai ngoro minái, tangkabin tili Abaram ák han átik iatung i kabisit Dewit, ngoromin ái Dewit mái Abaram a ngoro diar aru kákán ái Iesu mul. ");
INSERT INTO sgz_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Io, ái Abaram a apáng Aisak, má ái Aisak a apáng Iakop, mái Iakop a apáng Iuda má rang tuán. ");
INSERT INTO sgz_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Io, ái Iuda a apáng Peres mái Sera diar tuán (ái Tamar á mám diar), má ái Peres a apáng Esron, mái Esron a apáng Ram. ");
INSERT INTO sgz_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Io, ái Ram a apáng Aminadap, mái Aminadap a apáng Nason, mái Nason a apáng Salmon. ");
INSERT INTO sgz_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Io, ái Salmon a kila pas Rahap má nat diar ái Boas, má ái Boas a kila pas Rut má nat diar ái Obet, mái Obet a apáng Iesi, ");
INSERT INTO sgz_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","má ái Iesi má a apáng kabisit Dewit. Turpasi tili Dewit er a kabisit ák han átik i pákánbung er tan tám arup til Babilon di talkai matananu Israel ur Babilon, minái mul á ngis di á tan kálámul er a páng tili di ái Iesu Karisito. Ái kabisit Dewit a kila pas Batiseba má nat diar ái Solomon (mái Batiseba a kán wák besang ái Uria). ");
INSERT INTO sgz_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Io, ái Solomon a apáng Rehoboam, má ái Rehoboam a apáng Abia, mái Abia a apáng Asa. ");
INSERT INTO sgz_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Io, ái Asa a apáng Iosepat, má ái Iosepat a apáng Ioram, mái Ioram a apáng Usia. ");
INSERT INTO sgz_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Io, ái Usia a apáng Iotam, má ái Iotam a apáng Ahas, mái Ahas a apáng Esekiá. ");
INSERT INTO sgz_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Io, ái Esekiá a apáng Manase, má ái Manase a apáng Amon, mái Amon a apáng Iosaia. ");
INSERT INTO sgz_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Io, ái Iosaia a apáng Ekoniá má rang tuán i pákánbung er sang tan tám arup til Babilon kandi tu artalka besang ur Babilon suri batbat kalar ái. ");
INSERT INTO sgz_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Má i pákánbung án kamkabat anang Babilon mák han átik suri pákánbung a páng on ái Iesu Karisito, minái mul á ngis di á te kálámul er a páng tili di ái Iesu. Ái Ekoniá a apáng Sietiel, má ái Sietiel a apáng Serubabel. ");
INSERT INTO sgz_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Io, ái Serubabel a apáng Abiut, má ái Abiut a apáng Eliakim, mái Eliakim a apáng Asor. ");
INSERT INTO sgz_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Io, ái Asor a apáng Sadok, má ái Sadok a apáng Akim, mái Akim a apáng Eliut. ");
INSERT INTO sgz_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Io, ái Eliut a apáng Eliaser, má ái Eliaser a apáng Matan, mái Matan a apáng Iakop. ");
INSERT INTO sgz_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Io, ái Iakop má a apáng Iosep er kán pup ái Maria, má ái Maria a mámán ái Iesu er di utngi mai Mesaia. ");
INSERT INTO sgz_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Má ngorer a sángul mai ahat no á ngaul kálámul tangkabin tili Abaram ák han átik i Dewit er kabisit. Má turpasi bul tili Dewit ák han átik i artalka ur Babilon, a sángul mai ahat no mul á ngaul kálámul. Má tilatung i artalka ur Babilon, a sángul mai ahat no mul á ngaul kálámul ák han pang má i bung er a páng on ái Mesaia. ");
INSERT INTO sgz_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ngoro minái a páng ngoi ái Iesu Karisito. Ái Maria mámán ái Iesu, ái Iosep ákte tar kári suri diara kila. Mái sár i pákánbung káp diar te kis tiklik besang, ái Maria ákte mánán ilmi má ngo ákte tián ngorer i rakrakai si Tanián a Pilpil ákte han kis i narsán. ");
INSERT INTO sgz_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ái Iosep a tám nokwan, má ngo a mánán on ngo ái Maria ákte tián má, kápate nem suri na arumrum Maria i mátán matananu. Má ngorer a hol on ái Iosep suri na pásang kila kodong, má kápdate mánán on i tan kálámul. ");
INSERT INTO sgz_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Má ngorer kán tunga holhol besang ái Iosep suri táit er ngo na longoi. Má i libung er a boptin, kesi angelo káián ái Káláu a tapam hut singin i mihmih mák parai singin ngoromin, “Iosep, natun ái Dewit, koion una konngek. Una kila pas Maria suri na kam wák sang. Koion una rumrum suri kán tián kápkabin rakrakai káián Tanián a Pilpil ákte han kis i narsán, má ngorer ák tián má. ");
INSERT INTO sgz_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Na káhái besang i tekesi kalik án káláu má una utngi ngisán mam Iesu, sálán ngo ‘Ái Káláu Tám Araliu’, kápkabin na asengsegeng pasi kán matananu alari kandi sápkin. ");
INSERT INTO sgz_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tan táit ngoromin na tapam hut muswan sang suri long arwat pasi worwor si Káláu er a tari singin tám worwor tus ái Aisaia ngoromin, ");
INSERT INTO sgz_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","‘Kesi tahlik kápate bop be mai kálámul na tián besang má na káhái kalik káláu, má ái sang da utngi mam Emanuel’ (sálán á kuir worwor er ngo ‘Ái Káláu narsá git’).” ");
INSERT INTO sgz_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Má ngo a pán má tili boptin i kábungbung ái Iosep, io a mur on ngorer i angelo ákte bitái suri na longoi ngoi. Má ngorer ái Iosep a kila pas Maria sang, ");
INSERT INTO sgz_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","mái sár kápte be diar bop tiklik. Má namur a káhái kalik án káláu ái Maria, mái Iosep a utngi ngisán mam Iesu. ");
INSERT INTO sgz_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Má ái Iesu a páng i bimán rum á Betilem i balis á Iudáiá i pákánbung ái Erodes a kabisit on iatung. Má i pákánbung erei sang a páng on ái Iesu, tan tám mánán uri mátmátiah di lu mák ilmi akiláng suri. Di mákái kesi mátmátiah má dik mák ilmi, má ngorer di aptur tili kandi malar tepák tilanang i mátán nas, má dik han láklák tangrai dolon sál átik á Ierusalem. ");
INSERT INTO sgz_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Má iatung di lu gálgálta ngoromin, “Aiá á kalik er na kabisit besang káián tan Iudáiá? Kabin gimáte mákái kán mátmátiah a akiláng on anang i kángim malar, má gimáte hut mainái suri gima tari kángim rumrum uri narsán.” ");
INSERT INTO sgz_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Má ngo ái Erodes a longrai arbin ngorer, a lala tabureng i bál suri, má rehei mul á matananu iatung á Ierusalem. ");
INSERT INTO sgz_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Má ngorer ái Erodes a bin talmi tan pakpakta kán tan tám osmapak má tan tám mánán uri nagogon, má a gálta di ngoromin, “Be, Mesaia er di parai, aiá na páng ái?” ");
INSERT INTO sgz_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Má ái rung erei di kosoi ngo, “Mesaia na páng adi Betilem i balis á Iudáiá, kabin ái Miká tám worwor tus a parai worwor si Káláu ngoromin, ");
INSERT INTO sgz_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Má iáu á malar Betilem, u gengen malar sár main i balis á Iudáiá, mái sár kápte ngo iáu malar bia. U tilik támin táit kápkabin na páng besang tili iáu á tekesi kálámul na tátáil, ngorer na lu ololoh i kak matananu Israel.’” ");
INSERT INTO sgz_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Má namur ái Erodes a bin pas kodongnai tan tám mánán er mák gálta di suri bung dáh sang a hut á mátmátiah er. ");
INSERT INTO sgz_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Io, ngo di be nguruk no, ki ái Erodes ák dos pala di ur Betilem mai worwor talas ngoromin, “Erei gama han, gama lain ser kuluk suri kalik. Má pákánbung gamáte ser pasi, ki gama kaleng má gamák parai singing suri inak mánán on, ngorer á iau mul ina han má inak tari kak rumrum uri narsán.” ");
INSERT INTO sgz_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Dik han má ngorer ái Erodes ákte parai si di, má mátmátiah er dikte mákái tungu anang i mátán nas a tur soura mul mák han táilna di. Io, di mákái ngorer má a gas i bál di má di lala laes taladeng sang. Má mátmátiah erei a han kis ásngin arwat mai rum er kalik a kis ái. ");
INSERT INTO sgz_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Má di mákái ngorer má ding kusak uri rum er. Má ngo di mákái kalik mái Maria er mámán, ki dik pur dirtapul má dik rumrum uri narsán kalik. Má namur di long pasi kandi tan artabar ngorer i gol má kabang a lu lain tomtom má bultán kábau a lu tomtom mul, má dik támri kalik mai. ");
INSERT INTO sgz_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Má ngo dikte artabar no, tan tám mánán er di aptur má dik mur i lite sál kaleng uri kandi malar. Kápdite kaleng uri narsán ái Erodes suri da worwor mai, a kápkabin ái Káláu a dos kalar di i mihmih. ");
INSERT INTO sgz_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Má ngo tan tám mánán dikte aptur uri kandi malar alar ditul támán iatung, io kesi angelo káián ái Konom a tapam hut si Iosep i mihmih mák parai singin ngo, “Iosep, una aptur má unák long pas rugar tinán er má gamtulák sangar i táu ur Aigipto. Má gamtula kis iatung pang i bung ina parai singim suri gamtula kaleng, kápkabin ái Erodes na dos palai besang i kán tan tám arup má da ser suri kalik suri up bingi.” ");
INSERT INTO sgz_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Má ngorer ái Iosep a pán mák aptur, ák long pas rugar tinán er má ditulá turpasi láklák i libung erei sang ur Aigipto. ");
INSERT INTO sgz_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ditul támán á hut má adi Aigipto má ditulá kis iatung ák han pang i pákánbung ák mat ái Erodes. Má táit minái a tapam hut muswan suri long arwat pasi worwor si Káláu ákte parai singin tám worwor tus ái Osea ngo, “Iau kilkila pasi natung tili balis á Aigipto.” ");
INSERT INTO sgz_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Má namur ngo ái Erodes ákte mánán tusi ngo tan tám mánán dikte agurái, má ngorer a lala togor. A hol páptai worwor dikte parai singin suri pákánbung dáh a páng on á kalik, má ngorer a mánán ngo a goion kalik be. Io, ngorer a dos palai kán tan tám arup mai arardos ngo da up bingi boh gengen kalik káláu no, ái rung er di asus di be i rang mám di. Di longoi ngorer adi Betilem má tangrai tan malar pátum sár. ");
INSERT INTO sgz_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Má táit minái a tapam hut muswan suri long arwat pasi worwor káián ái Konom er a parai singin tám worwor tus ái Ieremiá ngoromin, ");
INSERT INTO sgz_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Di longrai kaungán te di lala tang adi malar á Rama, má tan wák til Betilem di sum suri rang nat di. Bos wák er di tangsi rang nat di, má kápate arwat suri abálbál di kabin rang nat di dikte mat no.” ");
INSERT INTO sgz_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Namur ákte mat ái Erodes, má kesi angelo káián ái Konom a tapam hut si Iosep adi Aigipto i mihmih er a boptin i libung ");
INSERT INTO sgz_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","mák parai singin ngo, “Iosep, erei má unák long pas rugar tinán erei má gamtuláng kaleng uri balis á Israel. Kápkabin ái Erodes má rang turán er di nem suri up bingi kalik, dikte mat má.” ");
INSERT INTO sgz_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Má ngorer ái Iosep a aptur ák long pas Maria diar tinán, má ditulá kaleng ur Israel. ");
INSERT INTO sgz_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Má ái Arkelaus natun ái Erodes ákte keles kákán má áng kabisit iatung i balis á Iudáiá i pákánbung er. Má ngo ái Iosep a longrai ngorer, a mátut suri ditula han uratung. Mái Káláu sang mul a akeng Iosep i mihmih suri koion ditula kis i balis á Iudáiá, má ngorer ditulá han uri balis á Galiláiá ");
INSERT INTO sgz_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","má ditulá kis iatung i malar á Nasaret. Má táit minái a tapam hut muswan suri long arwat pasi worwor káián tan tám worwor tus ngoromin, “Da utngi Mesaia ngo kakun Nasaret.” ");
INSERT INTO sgz_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Má namur marán á bet ákte rah, ái Ioanes Tám Arsiu a turpasi kán arbin i pokon mau i balis á Iudáiá narsán matananu, mák lu parparai ngoromin, ");
INSERT INTO sgz_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Gama ilang alari kamu sápkin má gamák hol kaleng, kápkabin ngo páput sár má lolsit tilami bát na hut má ái Káláu na kátlán i git.” ");
INSERT INTO sgz_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ái Ioanes, ái á kálámul er a worwor suri ái Aisaia tám worwor tus ngoromin, “Tekes na lu binbin i pokon mau ngo, ‘Aleget i sál si Konom má eran on. Long anokwai sál suri na láklák on!’” ");
INSERT INTO sgz_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Mái Ioanes a sulu mai nihun kamel di hiri, mák reureu mai kápán sipsip. A ani sikiu má midu. ");
INSERT INTO sgz_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Má matananu tili bimán rum á Ierusalem má tili balis no á Iudáiá má tili tan kuir malar i risán dan á Ioridan, di han suri longrai arbin si Ioanes. ");
INSERT INTO sgz_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Má matananu di tunga para aposoi kándi bos sápkin tatalen, mái Ioanes a siu di mai dan á Ioridan. ");
INSERT INTO sgz_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Má tan Parisaio má tan Sadukaio mul di han suri na siu di ái Ioanes. Mái sár ái Ioanes a mánán i kandi angagur ngo da tu siusiu sár má kápdite hol kaleng, má ngorer a parai si di ngoromin, “Á gam á rang natun i kanih sáksák! Sinih a parai si gam ngo gama tu siusiu sár má ngorer gama tur kaplah alari nagogon si Konom erei ngo na hut besang? ");
INSERT INTO sgz_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Gama oboi lain wán i gam suri inngas tar gam ngo gamáte hol kaleng. ");
INSERT INTO sgz_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Koion gama ruruna ngo gamáte tur kaplah alari nagogon si Káláu kabin gam á tan rang kopkom i Abaram. Kápte. Má minái iau para talsai si gam ngoro minái ngo ái Káláu a arwat singin suri na longoi tan hat minái sang suri da rang kopkom i Abaram! ");
INSERT INTO sgz_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Palngat ákte eran pagas suri tárái boh kubau adi káplabin. Kubau erei kápate oboi lain wán, da tár palai má dák sápkai uri kámnah. ");
INSERT INTO sgz_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Á iau, iau siu gam mai dan sár suri inngas tar gam ngo gamáte hol kaleng. Mái sár ngo kes a lala rakrakai sorliu iau, alatung be namur. Má iau rumrum suri ina kusak i kán rum. Ái sang na siu gam mai Tanián a Pilpil má mai kámnah. ");
INSERT INTO sgz_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ái ái koner a top i kán is suri na tárái wit mai. Má namur na tim purwai kotlin wit alari poktuán, má ngorer na dungi kotlin wit i suapok, má boh poktuán wit erei na osoi sár i kámnah káp a tini mat!” ");
INSERT INTO sgz_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","I bet erei, a aptur til Galiláiá ái Iesu mák han sur Ioanes ngo na siwi i dan á Ioridan. ");
INSERT INTO sgz_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","A rumrum ái Ioanes er a mák Iesu iatung má a nem suri na pukdai holhol si Iesu, má ngorer a parai singin ngo, “Be, suri dáh u han ur main i narsang suri ina siu iáu? Kápte a arwat á ngorer. A nokwan ngo á iáu sang una siu iau.” ");
INSERT INTO sgz_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mái sár ái Iesu a parai si Ioanes ngo, “Káksiai, una tu longoi ngorer sár iakte parai singim, má ngorer gitara long arwat pasi riri si Káláu a nem on.” Mái Ioanes a sormángát i worwor si Iesu má ák siwi. ");
INSERT INTO sgz_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Má pákánbung ái Iesu a masar alari dan, bát a ráp má a mákái Tanián ái Káláu a sosih ur on ngoro bun má a kis on, ");
INSERT INTO sgz_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","má kaungán kes tilami bát a parai ngoromin, “Minái á natung muswan, kang Kalik alal. A lala gas i balang mai.” ");
INSERT INTO sgz_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","I pákánbung ái Iesu a masar alari dan á Ioridan, Tanián ái Káláu a lami uri pokon mau suri ái Satan na longoi artohtoh uri narsán. ");
INSERT INTO sgz_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ái Iesu kápate ani tekesi táit arwat mai ahat i sángul á bung, má pasi ák matpám. ");
INSERT INTO sgz_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ngorer ái Satan a turpasi suri tohtoh Iesu mák parai singin ngoromin, “Ngo iáu Natun ái Káláu, ki una dos i bos hat minái suri dák arkeles uri balbal.” ");
INSERT INTO sgz_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mái Iesu a kosoi ngo, “Pinpidan si Káláu a parai ngo, ‘Kápte ngo namnam masik a lu támri liu kán kálámul suri na rakrakai, kápte! Rakrakai uri liu muswan kán kálámul a hut sang tili worwor si Káláu.’” ");
INSERT INTO sgz_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Má namur ái Satan a tohtoh Iesu mul mák lam pasi urami Ierusalem mák aksimi iamuni i kuir ungán rum i rumán osmapak. ");
INSERT INTO sgz_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Mái Satan a parai si Iesu ngoromin, “Ngo iáu Natun ái Káláu, ki una roh tilatung uradi bim. Kabin pinpidan a parai ngoro minái, ‘Ái Káláu na tari palai kán tan angelo má da ololoh timan iáu.’ Má pinpidan a parai mul ngo, ‘Tan angelo da sáng pas iáu mai lim di suri ngorer na mák suski kikim i hat.’” ");
INSERT INTO sgz_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Mái Iesu a kosoi ngoromin, “Pinpidan si Káláu a parai mul ngo, ‘Koion una tohtoh Konom er kam Káláu!’” ");
INSERT INTO sgz_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Má namur ái Satan a tohtoh Iesu mul má a lam pasi uri pungpung a tuan alami sang, má a inngas tari singin á tan balis no on á naul matmatngan pokon turán tan táit imi lolon i di mul. ");
INSERT INTO sgz_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Má namur a parai si Iesu ngo, “Tan táit no min ina tar noi singim. Na kaiam no sár ngo una pur dirtapul má unák lotu uri narsang.” ");
INSERT INTO sgz_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Mái Iesu a kosoi ngo, “Táu alar iau, Satan! Pinpidan si Káláu a parai ngo, ‘Una lotu uri narsán ái Konom kam Káláu, má ái masik sár una para agasi!’” ");
INSERT INTO sgz_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Má ngo ái Satan ákte arahi má kán tan artohtoh uri narsá Iesu, ki ák han pas má alari, má namur tan angelo di hut má dik tangan Iesu. ");
INSERT INTO sgz_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Má namur ngo dikte obop Ioanes i batbat kalar, ái Iesu a longrai ngorer má a aptur mák han ur Galiláiá. ");
INSERT INTO sgz_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kápte a lala kis ák dol á Nasaret ái Iesu, mái sár a han mák lu kis á Kapernaum i bimán rum a kis pátmi dan taliu á Galiláiá i balis káián aru mát er si Sebulon mái Napitali. ");
INSERT INTO sgz_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","A han máng kis á Kapernaum ái Iesu suri ák tapam hut muswan i worwor káián tám worwor tus ái Aisaia er a parai ngo, ");
INSERT INTO sgz_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Tan kálámul tili risán er di kis i kuir bim si Sebulon mái Napitali, má te di kis i risán tilik tas má i balsán dan á Ioridan má Galiláiá, ");
INSERT INTO sgz_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","matananu er di liu i kuron. Mái sár da mákái talas na sol uri tanián i di. Má talas na kaura uri narsá di ái rung di liu i pákpák án minat má nák atalsa di.” ");
INSERT INTO sgz_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Má turpasi i pákánbung erei sang, ái Iesu a tangkabin pasi kán arbin mák parai ngo, “Gama tánlak alari kamu sápkin má gamák hol kaleng, kápkabin páput má lolsit tilami bát suri ái Káláu na kátlán i git!” ");
INSERT INTO sgz_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Má ngo a lu hanhan tangrai risán dan taliu á Galiláiá, ái Iesu a mák rugar tuán er diar soksok isu mai uben iatung i dan erei. Ái Saimon, kesi ngisán ái Petero, mái Enru er tuán, diar aru tám soksok. ");
INSERT INTO sgz_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Mái Iesu a parai si diar ngo, “Gaur lákám, má gaurák mur i iau, má inak atintin gaur suri gaura tám soksok pasi matananu ur káián ái Káláu!” ");
INSERT INTO sgz_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Má ngo diar longrai ngorer, káp melek mul má diar aptur alari kándiar tan uben iatung má diará turpasi mur i Iesu. ");
INSERT INTO sgz_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Má ngo ái Iesu a lu lákláklák iamunang, a mákái aru natun ái Sebedaio, ái Iakobo mái Ioanes, ditul támán leget i kánditul uben iatung i mon. I pákánbung a mák diar ái Iesu, a kilkila pas diar ");
INSERT INTO sgz_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","alar Sebedaio iatung. Má káp melek sár diar aptur má diar má han tiklik mam Iesu. ");
INSERT INTO sgz_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Má ngorer ái Iesu a han mák lu aratintin tangrai boh rumán lotu i balis á Galiláiá no. A arbin mai lain arbin suri lolsit tilami bát, mák asengsegeng i matananu alari kandi toltolom sasam. ");
INSERT INTO sgz_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Má arbin uri Iesu a han arkaliut no i balis er mák han átik á Siria. Má ngo matananu di longrai ngorer, io di hut i narsán mam rung di sasam ngorer i rung a rangrang i kápán páplun i di, mái rung a porta i di á sápkin tanián, mái rung a mat i balsán i di, mái rung mul di gokgok. Mái Iesu a asengsegeng i di no sár. ");
INSERT INTO sgz_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Má ngorer tilik lala matananu taladeng tili tan malar di lu murmur on. Tan malar erei a turpasi til Galiláiá ák han átik á Dekapolis, má til Ierusalem má Iudáiá má tili kesi balsán dan á Ioridan mul. ");
INSERT INTO sgz_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","A mákái tilik lala matananu ái Iesu má a láklák tapam urami kesi pungpung má a sukis pagas ái. Má rang táir di hut má dik sukis i narsán, má tilik matananu er di hut iatung mul. ");
INSERT INTO sgz_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Má ngorer ái Iesu a tangkabin i aratintin uri narsá di mák parai ngoromin, ");
INSERT INTO sgz_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ái rung er di mánán ngo tanián i di a sáhár mák ngangai sur Káláu, di kuluk pala, kabin da kusak uri lolsit tilami bát mái Káláu na kátlán i di. ");
INSERT INTO sgz_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ái rung er di lu tang, di kuluk pala, kabin namur na abálbál di ái Káláu má da kodong. ");
INSERT INTO sgz_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ái rung er di agengen pas di, di kuluk pala, kabin da otoi besang i táit ákte oror pagas mai ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Má di kuluk pala á di onin di sák suri mur i tatalen a nokwan, kabin namur ái Káláu na tangan di suri da mur artálár pasi tatalen erei. ");
INSERT INTO sgz_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Di kuluk pala ái rung er di lu mámnai lite kálámul má tangan di, kabin ái Káláu na mámna di. ");
INSERT INTO sgz_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Di kuluk pala ái rung er a tukes i kandi holhol suri mur i nemnem si Káláu, kabin namur da kis i narsán. ");
INSERT INTO sgz_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ái rung kándi talar suri arabálbál i katbán matananu, di kuluk pala, kabin na utung di ái Káláu ngo rang natun. ");
INSERT INTO sgz_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Di kuluk pala á di ngo matananu di arangrangas i di suri mur i tatalen a nokwan, kabin erár dák mák ilmi ngo dikte kusak uri lolsit si Káláu mái Káláu a kátlán i di. ");
INSERT INTO sgz_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Má gam kuluk pala ngo matananu di lu mikmikwa gam, má ngo di wáng i gam, má ngo di para bengta gam kápkabin sur iau. ");
INSERT INTO sgz_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Gama parmat má gama laes kabin namur kamu arul na pakta ami bát. Rang támin i di dikte longoi ngorer mul mai tan tám worwor tus hirá be.” ");
INSERT INTO sgz_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Mái Iesu a sopasun kán aratintin ngoromin, “Gam sár á matananu gam á tas uri naul matmatngan pokon no. Mái sár ngo tas ákte rah á kán mapak, ngádáh gita amapak kalengnai ngoi? Na tu táit bia sár, má da lu sápka palai uratung i lol malar, má tan kálámul da láklák má dák lu sukai sár. ");
INSERT INTO sgz_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Gam sár á matananu gam á talas suri atalsai naul matmatngan pokon. Ngádáh, di lu longoi malar i iátin pungpung suri na punpunam? Auh, kápte! ");
INSERT INTO sgz_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Má i pákánbung gam oskoi lam, gam boh kári mai kas? Kápte. Gam akai i nián sang suri na atalsai rung er di kis iatung i rum. ");
INSERT INTO sgz_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Má ngorer a kuluk ngo gama ngoro lam sang, má talas er i gam na atalsai matananu suri da mákái tan lain táit gam longoi má ngorer da para agas Káláu er Kák gam imi naul bát.” ");
INSERT INTO sgz_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Mái Iesu a sopasun mul i kán aratintin ngoromin, “Koion gama hol on ngo iau hut main suri ina long palai nagogon si Moses má aratintin káián tan tám worwor tus. Kápte. Iau hut sang suri ina long arwat pasi kandi worwor suri na támin muswan. ");
INSERT INTO sgz_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Gama hol páptai minái. Erei ngo naul bát má naul bim na kis, nagogon mul na kis. Kápte kesi tip ngo kuir nagogon na pah nák han pang i pákánbung erei ngo talar kán nagogon ákte rah. ");
INSERT INTO sgz_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","“Mái koner kápte a taram má mur i te kuir tili nagogon a hol on ngo kápte a pakta, mák atintini matananu mul suri da longoi ngorer, ái kápte na pakta i lolsit ami bát, na tu gengen sár. Mái sár koner a taram má mur i nagogon mák atintini matananu suri da longoi ngorer, ái na kálámul pakta sang i lolsit ami bát. ");
INSERT INTO sgz_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","“Bos Parisaio má bos tám mánán uri nagogon di lu longoi marán tatalen a nokwan kabin a lala ngoi sang i bál di suri mur i nagogon. Má iau parai si gam ngo ái sinih a nem ngo na kusak uri lolsit tilami bát má na káián ái Káláu sang, ki ninsin na lala nokwan sorliwi bos Parisaio má bos tám mánán uri nagogon.” ");
INSERT INTO sgz_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Má ngorer ái Iesu a parai si di mul ngoro minái, “Á gam onin gamáte lu longrai ngo tan kálámul til hirá dikte abitbit di mai kesi nagogon si Káláu er a parai ngo, ‘Koion á up bing kálámul. Mái sár ngo tekesi kálámul a up bingi kesi kálámul, da long pasi kálámul er suri na sámtur i nagogon.’ ");
INSERT INTO sgz_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mái sár iau parai si gam onin ngo togor a sápkin mul, má ngo ái sinih a togor mam tuán, da nagogon on i malar. Mái sinih a ot bilingna tuán, ái koner da long pasi má nák sámtur i mátán tan tám nagogon, má di sang da nagogon on. Mái koner a wáng sáksákna tuán, ái koner na tarwai ái Káláu suri nák áslai rangrangas i kámnah iatung i pokon án hiru áklis. ");
INSERT INTO sgz_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Má ngo á iáu u sámtur iatung i nián osmapak mai kam artabar, má bálsák er i bál ái tuam mam iáu u hol pasi iatung, ");
INSERT INTO sgz_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ngorer koion be una osmapak. Una káksiai be kam artabar iatung, má ngorer unák han besang narsán ái tuam má gaurák arabálbál i gaur tuán be. Io, namur má unáng kaleng má unák artabar uri narsán ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ngo tekesi kálámul a togor mam iáu má a nem ngo na atur iáu i nagogon, i pákánbung gaur iatung besang i malar, una han uri narsán má gaurák anokwai suri ngorer na mák talka iáu uri narsán tám nagogon. Kabin ngo tám nagogon erei, ngo na longrai kamur worwor má namur na tari rangrangas singim, má ngorer tan kuir sulu da obop iáu i batbat kalar. ");
INSERT INTO sgz_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Má a muswan iau parai singim, una kis pagas i batbat kalar pang i bung una hul palai tinákum erei i iáu.” ");
INSERT INTO sgz_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Mái Iesu a sopasun kán aratintin ngoromin, “Gamáte longrai dikte aratintin mai má dik parai mul ngo, ‘Koion á bop tiklik mai wák káián lite kálámul.’ ");
INSERT INTO sgz_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mái sár iau parai si gam onin ngo ái koner a mákái wák máng kon suri ami bál suri ngo diara bop tiklik, wa ákte longoi sápkin sár mai á ngorer. ");
INSERT INTO sgz_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Ngorer ngo matam erei mingim a lam bengta iáu má uk longoi sápkin, ki una bilwak palai má unák sápkai. A kálik sák ngo na bokoh i tekesá kuir tili páplun i iáu, mái sár a lala sák sang ngo na kis i aru matam no má dák buswa iáu uri pokon án hiru áklis. ");
INSERT INTO sgz_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Má ngo limam erei mingim a lam bengta iáu má uk longoi sápkin mai, ki a kuluk una tár kus palai má unák sápkai. A kálik sák ngo na bokoh i kesi limam, mái sár a lala sák sang ngo na kis i aru limam no má ung kusak uri pokon án hiru áklis.” ");
INSERT INTO sgz_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Mái Iesu a sopasun mul i kán aratintin ngoromin, “Má gamáte longrai mul ngo hirá dikte aratintin mai ngoromin. Ngo kesá kálámul a nem suri pásang kila, ki na le i tekesá pákán ram suri pásang pala kán wák má ngorer diará kis arsagil. ");
INSERT INTO sgz_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Mái sár onin iau parai si gam ngoromin. Kálámul a long pala kán wák má wák kápate bop mam tekesi lite, kálámul erei a ngoro a susdo kán wák uri sápkin tatalen, má ái sang a káplabin sápkin a longoi á wák er ngo na han kila pasi lite kálámul. Má kálámul a kila pasi wák erei, ái mul a longoi sápkin.” ");
INSERT INTO sgz_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Mái Iesu a parai mul ngo, “Á gam onin gam mánán ngo tan kálámul til hirá dikte abitbit di mai kesi nagogon si Káláu ngo, ‘Koion una angagur mai tah kusi kam oror uri narsán ái Konom. Ngo ukte oror mai kesi táit una longoi, una long arwat pasi sang.’ ");
INSERT INTO sgz_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mái sár iau parai si gam ngoromin. Koion sang una oror suri adikái kam worwor ngo a támin. Ngorer koion una oror má uk parai ngo, ‘Támin urami bát!’ kabin naul bát ái Káláu a kátlán. ");
INSERT INTO sgz_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Má koion una oror mai naul bim mul kabin a kátlán mul ái Káláu. Koion una oror ur Ierusalem kabin kán bimán rum ái Káláu sang. ");
INSERT INTO sgz_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Má lulum mul koion una oror mai kabin káp kam te rakrakai suri una kelsei tekesi towon nihum suri nák bal ngo nák niár. ");
INSERT INTO sgz_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","“Ái rung di lu oror, di longoi kabin koner si Tám Sápkin ákte atintini marán suri da angagur, má ngorer dik lu oror suri adikái kándi worwor ngo di parai támin. Pasi iak parai si gam ngo koion sang á oror. Gita lu parai worwor a támin sár. Ngo una longoi táit, ki una mángát sár ngo, ‘Áá, ina longoi.’ Má ngo kápte una longoi táit, ki una arkawar sár ngo, ‘Auh, kápte sang.’ Má koion una oror turán kabin a paptauni ái Satan.” ");
INSERT INTO sgz_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Mái Iesu a sopasun kán aratintin mák parai ngo, “Gamáte longrai mul dikte parai ngoromin, ‘Ngo gaur mos i kesá kálámul má ák ubi matam ák sák, ki da long sáksáknai mul i mátán suri kosoi matam er a sák. Má ngo a puh á tekesi ngisam a tut bauri ái koner gaur arup, ki ngisán da tut bauri mul suri kosoi ngorer ákte longoi mam iáu.’ ");
INSERT INTO sgz_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Mái sár onin iau parai si gam ngo koion gama kosoi sápkin di longoi mam gam. Ngo tekesi kálámul na posri parim, una káksiai suri nák posri mul i kesi balsán parim. ");
INSERT INTO sgz_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Má ngo tekesi kálámul na obop iáu uri nagogon suri kesi lusán i iáu ur káián, kái una ruti, una bál tari mul i tekes singin. ");
INSERT INTO sgz_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ngo tekesi kálámul a tari duk i iáu suri una kipi kán kipkip má unák tur on i pokon a artálár mai kesá kilomita, ki á iáu bul una sorliwi á pokon er má unák han tarwai iatung er a artálár mai aru á kilomita. ");
INSERT INTO sgz_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ái sinih a sung iáu suri táit, una tari sár singin. Má ngo tekesá kálámul a sung iáu ngo, ‘Kam is be,’ ngo ‘Kam palngat be,’ ki una bál tari sár singin.” ");
INSERT INTO sgz_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Mái Iesu a sopasun kán aratintin ngoromin mul, “Gamáte longrai dikte aratintin mai má dik parai mul ngo gama mámnai rang tur gam, má ái rung erei di kurtara mam gam, gama mikmikwa di. ");
INSERT INTO sgz_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mái sár onin iau parai si gam ngo gama mámnai kamu tan kurtara, má gama sung Káláu sur di ái rung di lu long sáksákna gam, ");
INSERT INTO sgz_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","suri ngorer gama rang natun ái Kák gam imi naul bát sang. Má ngorer ninsin i gam na ngoro ninsin ái Káláu, kabin ái a longoi nas suri atalsai matananu no, tan tám nokwan má tan tám sápkin mul, má ák tari mul i ráin suri ák hus uri narsán ái rung erei di láklák mur i nagogon mái rung mul di lu tánlak. ");
INSERT INTO sgz_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ngo una mámnai sár i kálámul a lu mámna iáu, suri dáh ái Káláu na supan iáu? Wa tan tám kip takis di lu longoi ngorer mul, di lu mámna pas rung erei di lu mámna di sang! ");
INSERT INTO sgz_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Má ngo u lu worwor pas di sár á rang turam, ái rung di kuluk mam iáu, kam tatalen erei kápte a kuluk taladeng alari tatalen kán matananu no. Wa ái rung di tánlak alar Káláu di lu longoi mul á ngorer. ");
INSERT INTO sgz_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ái Káláu erei Kák gam imi bát a tám armámna, má gam mul gama tám armámna ngorer i Kák gam. Ngorer gama lu mámnai aru matngan kálámul no, rang tur gam má kamu tan kurtara mul.” ");
INSERT INTO sgz_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ái Iesu a sopasun kán aratintin mák parai ngoromin, “A kuluk gama talar mai him án lotu, mái sár koion gama longoi i mátán matananu suri da mák gam má dák para agas gam. Ngo gama longoi matngan tatalen ngorer, ái Kák gam imi naul bát kápnate supan gam suri á ngorer. ");
INSERT INTO sgz_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“A kuluk á artangan uri narsán maris án kálámul, mái sár koion á salarek mai. Tan kálámul di longoi ngorer i mátán matananu i rumán lotu má tangrai sál, di tan tám tuar. Má ngorer di salarek mai suri matananu da mákái má da árngai ngis di sár. A támin muswan ina bit gam ngo ái rung erei dikte otoi sár á kandi arsupan. ");
INSERT INTO sgz_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Má ngorer á iáu u nem i tángni maris án kálámul, una tangan kodongnai suri á iáu masik una mánán i táit u longoi. ");
INSERT INTO sgz_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Má ngorer táit u long kodongnai na uri balam sár. Na mák iáu ái Kakam u long kodongnai ngorer, má na supan iáu suri.” ");
INSERT INTO sgz_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Mái Iesu a sopasun kán aratintin ngoromin, “A kuluk gama sung uri narsán ái Káláu, mái sár koion á salarek mai. Tan kálámul di lu longoi ngorer i mátán matananu di sámtur suri sung i rumán lotu má tangrai sál, di á tan tám tuar. Má ngorer di salarek mai suri matananu da mákái má da árngai ngis di sár. A támin muswan ina bit gam ngo ái rung erei dikte otoi sár á kandi arsupan. ");
INSERT INTO sgz_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","“Mái sár á iáu, i pákánbung ngo una sung, ki una kusak uri kam rum má unák áng kodongna Kakam, ái koner kápate arwat una mákái mai matam. Mái sár ái a mák iáu, má ngorer a lu mákái táit u long kodongnai, má na supan iáu suri. ");
INSERT INTO sgz_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Má gam erei ngo gama sung, koion sang gama talka dolon kamu sung mai worwor bia sár. Ái rung tili risán di lu ngorer kabin di hol on ngo ái Káláu na longra di sang di utngi marán worwor i kandi sung. ");
INSERT INTO sgz_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Koion gama mur i kandi tatalen ái rung erei mai utngi dolon worwor kabin ái Káláu er Kák gam ákte táil i mánán sang on á táit erei gam sáhár suri. ");
INSERT INTO sgz_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Má ngoro minái á worwor gama utngi i pákánbung ngo gama sung: Kák gim imi bát, gim nem ngo matananu no da para aposoi ngo ngisam a pilpil má dák rumrum on. ");
INSERT INTO sgz_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Lolsit kaiam imi bát, gim sung ngo na sangar i hut main i naul bim. Kam nemnem a ian támin ami bát, má gim sung ngo na ian támin mul main i naul bim. ");
INSERT INTO sgz_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Una tabar gim mai ángim balbal i bung onin. ");
INSERT INTO sgz_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Má una hol palai kángim tan sápkin tatalen ngorer gim lu hol palai tan sápkin di lu longoi uri narsá gim. ");
INSERT INTO sgz_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Má una áir kalar gim gima káp pur i pákánbung án artohtoh, ái sár una sáras pas gim tili limán ái Satan. ");
INSERT INTO sgz_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“A támin á ngoromin. Ngo ukte hol palai sápkin dikte longoi uri narsam, ngorer ái Kakam imi bát na hol palai mul i kam tan sápkin. ");
INSERT INTO sgz_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mái sár ngo káp una te hol palai kándi tatalen ái rung er di longoi sápkin uri narsam, ngorer sár ái Káláu Kakam kápnate hol palai kam tan sápkin á iáu.” ");
INSERT INTO sgz_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Mái Iesu a sopasun mul i kán aratintin ngoromin, “A kuluk gama ahal suri holhol sur Káláu, má koion á salarek mai. Tan kálámul di lu longoi ngorer di mák sasam má ngoro di kis án tinang i mátán matananu. Di tan tám tuar, má ngorer di salarek mai suri matananu da mákái má da árngai ngis di sár. A muswan á in iau bit gam on ngo ái rung erei dikte otoi sár á kandi arsupan. “Mái sár á gam koion gama mák rumrum erei ngo gam ahal ngorer i tan tám angagur er. ");
INSERT INTO sgz_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Má iáu ngo u ahal, ki una dalus sang má unák lain siki nihum ");
INSERT INTO sgz_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","suri ngorer kápte kesi kálámul na mánán i iáu ngo u ahal. Ái Káláu masik na mánán, ái koner kápate arwat una mákái mai matam, mái sár a mák iáu, má ngorer a lu mákái táit u long kodongnai má na supan iáu suri.” ");
INSERT INTO sgz_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Mái Iesu a sopasun kán aratintin mul ngoromin, “Koion una tiling konom main i naul bim mai matngan minsik erei na long bengtai i koropos má na lu morot má da tarápái kam rum i tan tám siksikip suri sipki táit iatung i niam. ");
INSERT INTO sgz_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mái sár una lu him suri una tiling konom ami bát mai matngan minsik erei koropos kápte na long bengtai má kápte na morot, iatung i pokon er tan tám siksikip kápdite arwat suri da tarápái rum má dák sipki. ");
INSERT INTO sgz_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kabin kam omobop na kis i pokon erei, ki kam lala nemnem má balam na kis ái mul.” ");
INSERT INTO sgz_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Mái Iesu a parai mul ngo, “Matam ái a ngoro lam uri páplun i iáu. Pákánbung ngo matam a talas, bos kalkuir no i iáu a talas. ");
INSERT INTO sgz_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mái sár ngo pákánbung matam a sák, bos kalkuir no i iáu a kuron. U hol on ngo talas er i iáu a támin. Mái sár ngo kápte, má ngo talas er i iáu a kuron, ki á iáu una káng mai kuron mul.” ");
INSERT INTO sgz_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Mái Iesu a sopasun kán aratintin ngoromin, “Kápte kesá kálámul a arwat ngo na lu toptop singin aru konom no sár. Ngo na longoi ngorer, ki na mámnai kes sár, má na mikmikwai kesi tur diar. Na lu muswan ur singin kes, má kes na lu hol agengen on. Má ngorer ái koner a lala bes mai pirán tabal, kápate arwat ngo na toptop si Káláu mul. ");
INSERT INTO sgz_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Má ngorer ina parai si gam, koion gama konngek suri namnam er a top i kamu liu ngo suri dan gama ngin on. Kabin ngo kamu liu a pakta taladeng alari namnam, má namnam kesi táit sár uri tángni kamu liu. Koion gama konngek suri mermer uri merei kápán páplun i gam, kabin ngo kápán páplun a pakta taladeng alari mermer, má mermer kesi táit sár uri merei kápán páplun. ");
INSERT INTO sgz_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Gama hol pasi tan man kápte di lu himhimna ngo da obop talmi balbal ákte matuk, má káp kándi te rumán balbal mul, mái Kák gam imi bát a tabar di sár. Má gam sang gam tuan kuluk pala i mátán ái Kák gam alari tan man. ");
INSERT INTO sgz_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Be, ngo gama lala konngek suri kamu liu, ngádáh? A arwat suri gama bontai kamu liu mam te bet mul uramunang? Auh, kápate arwat. ");
INSERT INTO sgz_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Má koion gama konngek suri mermer uri merei kápán páplun i gam. Gama hol pasi aun senal ngádáh di liu ngoi. Kápdite himhimna ngo bauti lusán i di. ");
INSERT INTO sgz_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mái sár a muswan á minái iau parai si gam. Tan purpur ngorer i aun senal, sián a tuan kuluk taladeng sorliwi mermer si Solomon er kabisit. ");
INSERT INTO sgz_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Git mánán ngo ái Káláu a ololoh i tan purpur er a kopkom onin má latiu a bokoh sár, ngorer di tár sarai mák marang ki dik osoi i kámnah. Tan tu táit bia sár, mái sár ái Káláu a ololoh i di mai lain mermer. Má ngo ái Káláu a ololoh i tan táit bia ngorer, ngádáh, ái Káláu kápnate ololoh i gam mul? Suri dáh a gengen á kamu ruruna? Ái Káláu a ololoh i gam sár mul mai lusán i gam. ");
INSERT INTO sgz_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Má ngorer koion gama konngek suri táit gama ani má ngo dánih gama nginmi, ngo suri sulu gama oboi. ");
INSERT INTO sgz_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Áá, koion gama ngorer i di ái rung tili risán, ái rung er kápdite ruruna i Káláu má dik lala konngek suri ser pasi á tan táit erei. Mái sár á gam, a mon i Kák gam imi bát a mánán i tan táit gam sáhár suri. ");
INSERT INTO sgz_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Io, ngorer gama mulán atri besang i kamu hol i lolsit si Kák gam má suri gama tám nokwan, má ngorer ái Káláu na tapálsi limán ur si gam má na long arwat i kamu tan sáhár no. ");
INSERT INTO sgz_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Koion á konngek onin suri táit na tapam hut latiu. Tan somsom kus a tapam hut onin uri bung onin sang, má taun ur latiu uri bung latiu sár. Má koion una taun pápta iáu sang mai konngek suri aru bung i kesá bung sár. Koion una hol talmi táit tili lite bung mul uri turán til onin na mák taun pápta iáu.” ");
INSERT INTO sgz_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Mái Iesu a sopasun kán aratintin mul má ák parai ngoromin, “Koion una lu parai ngo turam a longoi sápkin, na káp parai ngorer uri iáu ái Káláu, ");
INSERT INTO sgz_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","kabin matngan nagogon erei u longoi uri turam, ái Káláu na longoi uri iáu mul namur. ");
INSERT INTO sgz_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Suri dáh u lala mákái pektol erei i mátán ái tuam, mái sár kápute áslai má sepen kubau er i matam sang? ");
INSERT INTO sgz_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Iáu nem i parai si tuam ngo, ‘Tuang, inak long palai be pektol er i matam.’ Ái sár koion una parai ngorer si tuam ngo lala sepen kubau a kis i matam sang á iáu. ");
INSERT INTO sgz_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","U tám tuar sang! Una long pala táilnai besang i lala sepen kubau tili matam, má namur ngo una lain mákmák sang, ki erei má unák long palai pektol tili mátán ái tuam. ");
INSERT INTO sgz_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Táit a pilpil káián ái Káláu koion una tari singin pap, na mák aririu kaleng i pap má nák ngas iáu. Táit a tuan kuluk koion una sápkai ur singin tan bor. Ngo una longoi ngorer, tan bor da suka tahni má nák sák.” ");
INSERT INTO sgz_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Mái Iesu a sopasun kán aratintin ngoromin, “Gama sung Káláu suri táit gam sáhár suri má na tari si gam. Gama ser suri táit gam sáhár suri má gama ser pasi. Má ngo gama pinpidir i mátán sál, ái Káláu na pasbat pas gam má nák tangan gam. ");
INSERT INTO sgz_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kabin ái rung di sung, da kebeptai; mái koner a ser, na ser pasi; mái koner a pinpidir, ái Káláu na pasbat i mátán sál pasi. ");
INSERT INTO sgz_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Suri aratámán mul, ngo natum na sung iáu suri balbal, káp una te tabar natum mai hat, kápte sang. Una támri mai balbal sang. ");
INSERT INTO sgz_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ngo natum na sung iáu suri isu, ngádáh? Káp una te támri mai kanih. ");
INSERT INTO sgz_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Á gam tan sápkin kálámul, mái sár gam mánán suri támri rang nat gam mai lain táit. Mái Kák gam imi bát a lala sorliu sang i kán mánán suri artabar, má ngorer ák lu tari tan lain táit si rung erei di sungi. ");
INSERT INTO sgz_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Gama lu longoi mai matananu á matngan tatalen erei gam nem on ngo da longoi mam gam. Erei á sálán muswan á nagogon si Moses má aratintin káián tan tám worwor tus.” ");
INSERT INTO sgz_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Mái Iesu a sopasun mul i kán aratintin ngoromin, “Koion gama kusak i mátán kas a tápál, ái sár gama kusak sang i mátán kas a kidut. Kabin mátán kas a tápál a han uri pokon án hiru áklis, má marán kálámul dikte mur on kabin ngo sál erei a malmu sár. ");
INSERT INTO sgz_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ngorer iau parai si gam ngo gama kusak i mátán kas a kidut. A támin ngo gama láklák i sál a marán i somsom kus on má kápte di marán ái rung di lu mur on, ái sár na lam gam uri liu áklis.” ");
INSERT INTO sgz_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Mái Iesu a parai mul ngo, “Gama ololoh kuluk i gam sang suri tan angagur án tám worwor tus. Ngo gama mák di di han sur gam, ki di han suri araturán ngoro tan sipsip, mái sár imi bál di di ngorer i pap rokoi sang. ");
INSERT INTO sgz_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Má gama mánán ilmi ninsin i di muswan tili matngan tatalen di longoi. A ngorer i kaulbek kápate artálár suri na oboi wán wain ngo wán tawan. ");
INSERT INTO sgz_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Kubau a oboi sápkin wán, kápte ngo ái á lain kubau. Lain kubau a lu oboi lain wán, má káp a tini oboi sápkin wán. Má ngorer mul sápkin kubau a lu oboi sápkin wán, má káp a tini oboi lain wán. ");
INSERT INTO sgz_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kubau erei kápate oboi lain wán, da tár palai má dák sápkai uri kámnah. ");
INSERT INTO sgz_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Má ngorer una mánán ilam di á tan angagur án tám worwor tus suri tatalen di longoi.” ");
INSERT INTO sgz_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Mái Iesu a sopasun kán aratintin mák parai ngo, “Marán kálámul alatung di mur i iau mai ngus di sár ngorer di lu utung iau mai Konom, mái sár kápdite nem suri ina kátlán i di. Á di ái rung erei kápdate sol uri lolsit tilami bát. Mái sár ái rung di mur muswan i nemnem si Kang imi bát, ki á di sang da kusak uri lolsit tilami bát. ");
INSERT INTO sgz_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Má i bung ái Káláu na nagogon i tan kálámul no, marán kálámul da tur má dák parai singing ngo, ‘Konom, kang Káláu, á gim á minái rang tárim. Gim lu arbin mai ngisam uri narsán matananu, má gimá lu tipar palai sápkin tanián mai ngisam, má gimá lu longoi marán akiláng mul mai.’ ");
INSERT INTO sgz_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Io, má iau ina parai si di ái rung erei ngo, ‘Auh, wa kápte iau mánán i gam má kápte ngo gam rang táring. Á gam á tan tám abulbul, má ngorer gama kaplah alar iau!’” ");
INSERT INTO sgz_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Mái Iesu a arahi kán aratintin mák parai ngoromin, “Ái koner a han sur iau má a longra pasi kak worwor má a mur on, ái ina para talsai si gam. Ái a ngoro kálámul a tám mánán erei a longoi kán rum máng kakas mai toros uradi sang i iátin hat er i pálkibán bim. ");
INSERT INTO sgz_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Io, namur a hus i ráin má a tibin i dan má lala kihkih a hut, má atul i táit er ditul tohoi suri suhi rum erei suri na musuh. Mái sár ngo káp sang, kabin ngo rum erei a longoi i iátin hat má ák tur rakrakai. ");
INSERT INTO sgz_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Mái sár ái koner a longrai kak worwor má kápate mur on, ái a ngoro kálámul a ngul erei a longoi kán rum i lol kon má kápate lala kakas mai toros uradi lal. ");
INSERT INTO sgz_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Má namur i pákánbung ngo a hus i ráin má a tibin i dan má lala kihkih a hut mák gunrai rum erei, ki ák musuh má ák lala sák taladeng!” ");
INSERT INTO sgz_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Má ngorer a arahi kán aratintin ái Iesu, má ngo di longrai kán aratintin, di pánsálngát on, ");
INSERT INTO sgz_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","a kabin ngo kán aratintin kápate ngoro aratintin káián bos tám mánán uri nagogon. Kápte. Di longra ilmi ngo kán aratintin a mon i rakrakai on ngorer i kálámul a tarwai ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Má namur, i pákánbung er ái Iesu a sosih tilamuni pungpung, tilik matananu iatung di láklák tiklik mai. ");
INSERT INTO sgz_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Má kesi kálámul iatung a bonta noi kápán páplun i lepra. I pákánbung a mák Iesu, a han mák pur dirtapul i mátán táil ái Iesu mák sungi ngoromin, “Konom, ngo u nem on, u arwat suri ngo una asengsegeng pas iau!” ");
INSERT INTO sgz_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Mái Iesu a longrai ngorer mák sarsara mai limán mák top i páplun kálámul erei má a parai singin ngo, “Iau nem on. Inái ukte sengsegeng má!” Má káp melek sár mul má lepra a bokoh alari kápán páplun kálámul erei mák sengsegeng. ");
INSERT INTO sgz_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Má namur ái Iesu a inau on ngoromin, “Koion una kálik parai singin tekes. Una han má unák para inngas iáu singin tám osmapak, má unák tari singin á kam osmapak ngorer ái Moses a parai, má kam osmapak erei na inngas tari ngo kam sasam ákte rah.” ");
INSERT INTO sgz_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Má ngorer di láklák má dik han hut iatung i malar á Kapernaum ái Iesu di. Má kesi tátáil kán tan tám arup til Rom, ái iatung, má a hut narsán má a lala sung Iesu suri na tángni, má ngorer a parai si Iesu ngo, ");
INSERT INTO sgz_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Konom, kesi tám arardos kaiak a lala sasam, má kápate artálár suri na aptur má.” ");
INSERT INTO sgz_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Mái Iesu a longrai ngorer má a parai singin tátáil erei ngo, “A kuluk. Ina tiklik mam iáu uri kam rum suri inak asengsegeng pasi nák liu kuluk.” ");
INSERT INTO sgz_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","Má tátáil er a parai ngoromin singin, “Konom, á iau á kálámul dikte obop iau i lalin kak pakpakta, má a mon mul i kak rakrakai suri kátlán i tan tám arup di lu kis i lalin i iau. Má ngorer a mon i kak nokwan suri tari palai kes ngo, ‘Han,’ má a han. Má ngo iau bin pasi kes mul ngo, ‘Lákám,’ ki a lu taram i kaungang má a lákám. Má ngo iau dos palai kak tám arardos ngo, ‘Longoi minái,’ ki ák lu longoi sár. Má iau mánán ngo á iáu a mon i kam rakrakai mul suri para palai worwor suri aliu pasi kálámul a sasam suri nák liu. Má, Konom, iau lawa pas iáu. Káp iau te lain kálámul artálár suri ngo una kusak ur main i rum. Ngorer ki una tu para palai kam pinpidan sár, má kak tám arardos na sengsegeng kaleng.” ");
INSERT INTO sgz_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Má ngo ái Iesu a longrai ngorer, a sodar suri. A ilang suri matananu di lu murmur on má ák parai ngoromin, “Mákái! A támin iau parai si gam, káp iau te banai besang i tekesi kálámul ngoro tátáil minái mai ruruna ngoromin, kápte kes til main Israel. ");
INSERT INTO sgz_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","A támin á ngoromin ina bit gam on, ngo i bungun nagogon na marán i kálámul tili risán tili ahat i mátán kihkih no da lákám má dáng kis suri namnam tiklik mam Abaram mái Aisak mái Iakop i lolsit tilami bát a kabin i kándi ruruna i iau. ");
INSERT INTO sgz_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Mái sár marán tili matananu Israel di hol on mul ngo da sukis suri namnam i lolsit tilami bát, mái sár kápte sang, kabin káp kándi te ruruna i iau. Á di da sápka di dák tang má ararat ngis iatung i pokon a tuan kuron.” ");
INSERT INTO sgz_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Má ngorer ái Iesu a parai singin tátáil kán tan tám arup erei ngo, “Una lu hut má, má kam ruruna erei ina long artálár pasi uri narsam.” Má i án pákánbung sang erei, tám arardos káián tátáil erei a sengsegeng sár. ");
INSERT INTO sgz_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Má namur ái Iesu a han kusak uri rum si Petero. Mái mámán ái kán wák ái Petero a bop mai sasam, a lala málmálas. ");
INSERT INTO sgz_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Mái Iesu a han má ák top i limán, má ngorer a bokoh alari i sasam erei má a sengsegeng. Má wák erei a aptur mák leget i te namnam ur áián ái Iesu. ");
INSERT INTO sgz_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Má ngo ákte ronron i bung erei sang, matananu di hut talum iatung. Marán si di a mon i rang tur di sápkin tanián a porta i di, má dik long pas di uri narsá Iesu, mái Iesu ák dos palai tan sápkin tanián alari tan kálámul erei. Mái rung di sasam mul, ái Iesu a aliu pas di no keskeskes má dik sengsegeng má. ");
INSERT INTO sgz_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","A longoi ngorer ái Iesu suri long arwat pasi worwor er ái Aisaia tám worwor tus ákte parai ngo, “Ái sang ákte asengsegeng palai tan sasam alar git!” ");
INSERT INTO sgz_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Má ngo ái Iesu a mákái matananu di iatung kári, má ngorer a parai singin kán kalilik án aratintin ngo, “Git má urada i balsán dan taliu tilada.” ");
INSERT INTO sgz_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Má kesi tám mánán uri nagogon a hut i narsán má a parai si Iesu ngo, “Tám Aratintin, gitar no á iau. Tan pokon no una han ur on, ina mur i iáu.” ");
INSERT INTO sgz_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Mái Iesu a parai singin ngoromin, “Tan pap rokoi a mon i nián i di di lu bop on, má tan man a mon i páhiun i di mul di lu bop on. Mái sár Natun Kálámul, kápte pokon na mangeh ái má oboi lul on. Ngo ái rung di áslai suri mur on, na kápte gut á nián i di mul suri mangeh ái.” ");
INSERT INTO sgz_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Má kesi kalik án aratintin mul a parai si Iesu ngoro minái, “Keskam, Konom. Mulán táit be, una mángát pala iau má inak han suri tahun tata be.” ");
INSERT INTO sgz_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ái Iesu a kosoi kálámul erei ngo, “Suri tahni minat, kandi talar ái rung káp kandi te liu. Má ngo á iáu u nem i liu muswan, ki una mur i iau sang.” ");
INSERT INTO sgz_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Má namur ái Iesu má kán kalilik án aratintin di sa uri mon má dik han. ");
INSERT INTO sgz_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Di lu hanhan tangrai dan taliu, mái Iesu a han bopbop iatung i polgon mon mák boptin. Má namur tilik bát a hut, má pákán nah a aptur má a kusak uri mon má a káng mai dan. ");
INSERT INTO sgz_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Má tan kalilik án aratintin di mákái ngorer má dik mátut, ki dik áplas Iesu má dik parai singin ngo, “Konom, una saras pas git! Gitáng kong má minái!” ");
INSERT INTO sgz_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Mái Iesu a pán mák parai singin kán kalilik ngoromin, “Gam mátut suri dáh? Káp kamu te ruruna?” Má namur a tur kári kihkih má dan mul, má kihkih a aunges má dan a siaroh. ");
INSERT INTO sgz_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Má tan kalilik án aratintin di mákái ngorer má dik sodar suri, má dik worwor arliu i di sang ngoromin, “Matngan kálámul ngádáh á minái kihkih má dan diar taram singin?” ");
INSERT INTO sgz_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Má namur ái Iesu tiklik mai kán kalilik án aratintin di hut i balsán dan taliu tilada, i balis á Gadara. Má aru kálámul iatung sápkin tanián a mon i diar, má diar lala sák taladeng, taba kándiar arup. Diar lu kis tangrai tan mátán hat erei di lu tahni tan buli ái, má tan kálámul di lu mátut suri urup on á pokon er. Má ngo ái Iesu a hut iatung, diar so tilatung i tarang er má diar hut i narsán ái Iesu. ");
INSERT INTO sgz_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Má káp melek má diar má perek ngoromin, “Á iáu Natun ái Káláu, suri dáh u soksok gim? Ukte hut onin suri una arangrangas i gim, be? Mái sár bungán nagogon kápte besang!” ");
INSERT INTO sgz_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Má pokon erei a hut on ái Iesu, a kálik tepák alari pokon erei kesi numán bor di lu namnam iatung on. ");
INSERT INTO sgz_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Má bos sápkin tanián di mákái ngorer má dik lala sung Iesu ngoromin, “Ngo u nem suri long pala gim alari aru kálámul minái, ki una dos i gim má gimák sol uri tan bor imunang.” ");
INSERT INTO sgz_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Mái Iesu a parai narsán tan sápkin tanián ngo, “Ngorer gama so má!” Io, tan sápkin tanián erei di so alari aru kálámul er má ding kusak uri tan bor. Má ngorer má numán bor erei di sangar i rut sosih uradi dan taliu má di no ding kong. ");
INSERT INTO sgz_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tan kálámul di lu ololoh i numán bor erei di mákái ngorer a longoi ái Iesu, má dik rut má dik para sarai arbin tangrai bimán rum erei suri numán bor má táit mul ákte hut i narsán aru kálámul er sápkin tanián a mon i diar. ");
INSERT INTO sgz_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Má ngorer matananu tili bimán rum erei di han suri worwor mam Iesu, má dik sungi suri na han pas tilatung sang i kándi malar. ");
INSERT INTO sgz_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Má ngorer ái Iesu di di sa kaleng uri mon erei sang má di alus kaleng polsai dan taliu á Galiláiá, má dik han masar kaleng á Kapernaum i malar er ái Iesu a lu kiskis ái. ");
INSERT INTO sgz_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Má namur te kálámul di kipi kesi peu mai kibán sang kabin kálámul er kápte a lu láklák. A mákái kándi ruruna ái Iesu, má a parai singin peu ngoro minái, “Koion una mátut, tuang. Kam sápkin tatalen ákte pah alar iáu.” ");
INSERT INTO sgz_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Má tan tám mánán uri nagogon di longrai ngorer má dik turpasi wor arliu i di sang ngoromin, “Ái sinih á kálámul minái a pulus Káláu?” ");
INSERT INTO sgz_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Mái Iesu a mánán i kándi holhol má ák parai si di ngoromin, “Suri dáh a káng i bál gam mai boh sápkin holhol ngorer? ");
INSERT INTO sgz_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Á iau a mon i kak nokwan suri parai singin kálámul erei a peu ngo, ‘Kam tan sápkin tatalen ákte pah,’ kabin ngo iau arwat mul suri parai ngorer singin kálámul er ngo, ‘Una aptur, una kipi kibam má unák láklák!’ ");
INSERT INTO sgz_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Má inái ina inngas tari si gam ngo Natun Kálámul a mon i kán nokwan suri long palai bos sápkin tatalen main i naul bim!” Má ngorer a parai singin peu ngoromin, “Aptur má, unák pusak pasi kibam má unák han uri kam rum!” ");
INSERT INTO sgz_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Má kálámul erei a aptur mák pusak pasi kibán má a kaleng uranang i rum. ");
INSERT INTO sgz_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Má ngo matananu erei di mákái, di lala mátut má dik para agas Káláu suri a tari á matngan rakrakai erei singin kálámul. ");
INSERT INTO sgz_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Mái Iesu a aptur alari malar er mák han. Má ngo a lu lákláklák tangrai sál, a mákái kesi kálámul ngisán ái Mataio, kesi tám kip takis, a sukis pagas iatung i rumán kip takis. Ái Iesu a mákái mák parai singin ngo, “Una mur i iau.” Mái Mataio a longrai ngorer mák aptur má a mur i Iesu. ");
INSERT INTO sgz_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Má namur ái Mataio a longoi lala namnam sur Iesu i kán rum sang. Má ngorer ái Iesu má kán kalilik án aratintin má marán te rung tili rákán him án kip takis má te mul á tan tám abulbul, di no di kis talum suri namnam iatung. ");
INSERT INTO sgz_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Má te Parisaio di mák Iesu ngo a kis tiklik mai tan tám sápkin ngorer, má dik parai singin tan kalilik án aratintin si Iesu ngoromin, “Suri dáh kamu tám aratintin a namnam tiklik mai tan tám kip takis má tan tám abulbul?” ");
INSERT INTO sgz_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Má ngo ái Iesu a longrai, a han máng kos di ngoromin, “Ái rung di lain liu kápdite sáhár sur tekes ngo na aliu di, ái rung di sasam masik sár. ");
INSERT INTO sgz_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Gama han má gamáng kip aratintin tili Buk Tabu suri muswan on á pinpidan min er ái Káláu a parai ngo, ‘Iau nem i gam ngo gama lu armámna uri narsán matananu. Ái a kuluk si diar á osmapak mai ololas.’ Ngorer má iau, káp iau te hut suri kilkila pasi bos tám nokwan, iau hut suri bos tám sápkin.” ");
INSERT INTO sgz_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Má kesi bung kalilik án aratintin si Ioanes Tám Arsiu di han má di gálta Iesu ngo, “Suri dáh gim má tan Parisaio gim lu ahal, mái sár ngo kam kalilik án aratintin á iáu kápte?” ");
INSERT INTO sgz_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ái Iesu a longrai má a kos di ngoromin, “Ngádáh? Ngo da longoi namnam án akila, gam hol on ngo matananu da tinang má da álai namnam i pákánbung er kálámul a hutngin kila a kis tiklik mam di? Kápte! I bung kesi kálámul a kila, di no di namnam tiklik. Má namur da long pasi kálámul er a hutngin kila má nák bokoh alar di. I bung erei da ahal.” ");
INSERT INTO sgz_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Mái Iesu a sopasun kán worwor má a parai ngoromin, “Ngo kes a mon i kán rápán sulu mák nem ngo na mapmap on, kápnate baut arsaktai mapmap a longoi mai hutngin sepen sulu kápte be di gorsai. Ngo na baut arsaktai ngorer, má namur na gorsai, hutngin na hius sang má nák tarápái torahin má na ráp pakta i mátán erei. ");
INSERT INTO sgz_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Má kápte kesá kálámul na urai hutngin suir wain uri torahin átbán dan di longoi mai kápán me. Ngo na longoi ngorer, suir wain erei na sut má na korkor má nák tarápái torahin átbán erei má nák ráp, má suir wain na sal no. Gita totrai hutngin suir wain uri hutngin átbán dan suri diar no diara sut tiklik. Ngorer má suir wain má átbán diar no káp diara te sák.” ");
INSERT INTO sgz_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Má ngo ái Iesu kán tu worwor narsá di be iatung, io kesi kakun Iudáiá a pakpakta án lotu a hut si Iesu iatung má a pur dirtapul i mátán táil mák parai singin ngo, “Iau han suri parai singim ngo inái sár natung tahlik ákte mat, má una lákám unák oboi limam on má nák aptur alari minat má nák liu.” ");
INSERT INTO sgz_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Má ngorer ái Iesu a aptur, má kán kalilik án aratintin mul di tiklik mai má di mur i kálámul erei. ");
INSERT INTO sgz_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Má kesi wák iatung a sasam mai dár arwat mai sángul mai aru á bet. A mákái kalang má dár kápate rah. Má wák erei a láklák namurwa Iesu má a singli nomnobon lusán, ");
INSERT INTO sgz_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","kabin a hol on ami bál ngoromin, “Ngo ina tu singli lusán sár, ina sengsegeng.” ");
INSERT INTO sgz_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Mái Iesu a ilang má a mákái ngorer má ák parai singin ngoromin, “Wákán, koion una mátut. Kam ruruna ákte aliu pas iáu!” Má i án pákánbung sang erei, wák er a sengsegeng sár. ");
INSERT INTO sgz_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Má namur ái Iesu a hut iatung i rum káián pakpakta erei má a mákái di husi tulal, tatalen di lu longoi ami iátin buli, má lala matananu di tang má di lala wakwak. ");
INSERT INTO sgz_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","A mákái ngorer ái Iesu má a parai si di ngo, “Gama so no tilatung i rum! Kalik átlái erei sinih ngo a mat, a boptin sár.” Má di longrai ngorer má dik lala nongnai. ");
INSERT INTO sgz_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mái Iesu a bit rangas uri narsá di ngo da so. Má ngo dikte so no, ái Iesu a kusak urami rum suri kalik átlái er má a top pasi limán, má kalik átlái er a aptur. ");
INSERT INTO sgz_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Má matananu di para sarai arbin uri táit minái, má a han arkaliut i balis no á Galiláiá. ");
INSERT INTO sgz_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Mái Iesu a aptur alari malar erei má a lu hanhan iamunang tangrai sál. Má aru kálámul diar rau diar iatung, diar longrai ngorer má diará lu murmur i Iesu. Má ngorer diará lu binbin suri ngo, “Natun ái Dewit, una mámna giur be!” Mái sár ái Iesu kápte be a bin kos diar. ");
INSERT INTO sgz_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Má namur ái Iesu a hut iatung i kesi malar má a kusak uri kesá rum. Io, ngorer aru rau erei diar mur on má diará hut iatung i narsán ái Iesu. A longrai ngorer diar lu binbin i aru rau er ái Iesu, io ngorer a ilang má a mák diar má a gálta diar ngoromin, “Ngádáh á kamur ruruna? Gaur ruruna i iau ngo arwat ina apán pasi mát gaur?” Má diará kos Iesu ngo, “Áá, Konom, giur ruruna i iáu.” ");
INSERT INTO sgz_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Mái Iesu a taram i diar má a singli mát diar mák parai si diar ngo, “Táit gaur ruruna suri ngo ina longoi mam gaur, ki erei má!” ");
INSERT INTO sgz_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Má ngorer mát diar a pán má diará mákmák sang. Mái Iesu a inau i diar ngo, “Gauráte mákmák kaleng má erei, má koion sang gaura parai singin te kálámul!” ");
INSERT INTO sgz_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mái sár diar aptur pas tilatung alar Iesu, má diará para sarai arbin ur on tangrai kunlán balis no erei. ");
INSERT INTO sgz_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Má ngo aru kálámul erei diar aptur pas má diará han má, ki te kálámul bul di tangnai kesi kálámul narsá Iesu a gap i ngudun kabin sápkin tanián a mon on. ");
INSERT INTO sgz_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Mái Iesu a long palai sápkin tanián alari kálámul erei, má kálámul erei a turpasi worwor kaleng. Má tan kálámul iatung di mák Iesu a long palai sápkin tanián alari kálámul er má dik pángáng suri, má dik parai ngoromin, “Na wa tikai sang! Onin pala sang gitá mákái á matngan táit ngoromin a tapam hut main Israel!” ");
INSERT INTO sgz_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mái sár tan Parisaio di mákái ngorer má dik parai uri Iesu ngo, “Rakrakai erei káián ái Satan. Kabisit káián tan sápkin tanián a tari singin suri ák lu tipar palai tan sápkin tanián mai.” ");
INSERT INTO sgz_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Má namur ái Iesu a han tangrai tan bimán rum má malar mul, mák lu atintini matananu i tan rumán lotu má a lu arbin mai lain arbin suri lolsit tilami bát, mák lu asengsegeng i matananu alari kandi toltolom sasam. ");
INSERT INTO sgz_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Mái Iesu a mákái tilik lala matananu má a mámna di, kabin a mák di di ngoro tan sipsip kápte te kák di mák tabureng i kandi holhol suri kápte tám artangan. ");
INSERT INTO sgz_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Má ngorer ái Iesu a inau i kán tan kalilik án aratintin ngoro minái, “Matananu minái di ngoro balbal i num ákte matuk. Mái sár ngo tan tám him kápdite marán suri il talmi balbal. ");
INSERT INTO sgz_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Má ngorer gama sung Koner a kátlán i num erei suri na tarwa pala te mul i tan tám him suri da dung talmi kán balbal erei ákte matuk i kámniánsit.” ");
INSERT INTO sgz_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Namur ái Iesu a kilkila pasi kán sángul mai aru á kalik án aratintin uri narsán, má a tari nokwan si di suri da tipar palai bos sápkin tanián má dák asengsegeng i tan kálámul alari bos toltolom sasam. ");
INSERT INTO sgz_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Má ngis di á sángul mai aru á bos apostolo er si Iesu a ngoromin: turpasi tili Saimon, kesá ngisán mul ái Petero; mái Enru tuán; mái Iakobo diar tuán ái Ioanes, aru natun ái Sebedaio; ");
INSERT INTO sgz_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","mái Pilip; mái Batolomi; mái Tomas; mái Mataio tám kip takis; mái Iakobo natun ái Alpius; mái Tadius; ");
INSERT INTO sgz_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","mái Saimon, kálámul a tur rakrakai suri da sikra palai kurtara alari Israel; mái Iudas Iskariot, ái koner na agur tar Iesu. ");
INSERT INTO sgz_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Mái Iesu a eran suri na dos palai sángul mai aru á kálámul erei suri da han, má ák inau i di ngoromin, “Koion gama han uri malar kándi ái rung tili risán, má tan malar mul á Samaria koion gama han átik ái. ");
INSERT INTO sgz_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Mái sár gama han nokwan uri malar kándi á matananu Israel, ái rung di ngoro tan sipsip di han benget má kápte kák di. ");
INSERT INTO sgz_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Gama han uri narsá di má gamák arbin talas suri lolsit tilami bát páput sár má na hut mái Káláu na kátlán i git. ");
INSERT INTO sgz_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Gama aliu pas di ái rung di sasam, mái rung er di mat, gama aptur kalengna di alari minat suri dák liu. Mái rung er di sami lepra, gama asengsegeng pas di mul, má gama long palai sápkin tanián er a porta i te kálámul. Rakrakai erei iakte tari si gam er gamáte otoi, kápte gam hul pasi singing. Má ngorer gama araliu sár má koion da hul gam suri. ");
INSERT INTO sgz_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Má i kamu inan erei, koion gama kip te pirán tabal i kamu rat. ");
INSERT INTO sgz_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Má táit án dudung má buk uri tangan gam i láklák, rehei mul, koion gama top on. Má koion gama kip kamu te kelkeles má te bákrai kik gam mul, erei sár gamáte oboi. Gama han suri him i katbán matananu erei, má ngorer a kuluk da tabar gam mai táit gam sáhár suri. ");
INSERT INTO sgz_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Má i pákánbung gama hut iatung i bimán rum ngo malar erei, gama sálah suri kálámul gama mákái ngo kálámul erei a lain ninsin má nák árár pas gam. Ki ái sang gama mur on uri nián, má ngorer gama kis tiklik mai pang i bung er gama aptur alari. ");
INSERT INTO sgz_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Má ngo gama han átik i rum káián kálámul erei má gamá kusak, io gama parai ngo, ‘Matau uri bál gam á gam kis i rum minái!’ ");
INSERT INTO sgz_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ngo ái rung tilatung i rum erei di árár pas gam, ki kamu worwor án arasosah na kis tiklik mam di. Mái sár ngo kápte lain ninas di longoi mam gam, gama kaplah alar di mai kamu worwor án arasosah erei. ");
INSERT INTO sgz_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Io, má ngo te kálámul i malar ngo rum kápte di nem suri árár pas gam ngo da alongra suri worwor gama parai mam di, ki gama aptur alar di iatung i kándi rum, má gamák han alari malar erei má gamák tinra palai rah tili kik gam suri para inngasi ngo kándi sápkin a kis pagas i káil i di sang. ");
INSERT INTO sgz_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Gam mánán á lala rangrangas hirá er a hut i aru malar Sodom má Gomora má diará bam no. Wa a gengen sár á rangrangas erei. A muswan iau parai si gam ngo i bungun nagogon ái Káláu na arangrangas i matananu i malar Sodom má Gomora. Mái sár rangrangas erei kápnate lala pakta ngorer i lala rangrangas taladeng na oboi uri matananu i malar erei kápate tangan gam.” ");
INSERT INTO sgz_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Mái Iesu a sopasun kán worwor uri narsán kán kalilik án aratintin ngoromin, “Erei gama han má, ina tarwa gam ngoro tan sipsip uri katbán tan pap rokoi. Má ngorer koion gama ngul sur di. Gama lain mákmák ngorer i tan tárgau suri gamák lu mák ilam di ngo kamu tan kurtara sang, mái sár gama liu namurwai tatalen a pilpil ngorer i bun i katbán i di. ");
INSERT INTO sgz_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Gama ololoh kuluk i gam. Da tola gam má kabat pas gam, má ngorer da kip gam uri nagogon. Má da lu tas gam i rumán lotu. ");
INSERT INTO sgz_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Má da lu talka ráhra gam uri mátán táil i bos tám nagogon má i mátán táil i bos kabisit kandi ái rung tili risán suri ngisang, má namur gama arbin narsá di. ");
INSERT INTO sgz_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Má ngo da obop gam uri nagogon, koion gama konngek suri worwor ngádáh gama parai. Pákánbung erei na hut sang á worwor gama parai, ");
INSERT INTO sgz_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","kabin pinpidan erei gama parai kápte ngo kamu. Ái Káláu Kák gam na tarwa palai Tanián nák apos tari uri kamu holhol á worwor gama parai, a ngoro Tanián sang á erei a worwor tili gam. ");
INSERT INTO sgz_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“I pákánbung erei, kálámul na kip tar tuán uri minat. Má ngorer mul i aratámán, kákán na kip tari minat uri natun. Mái natun mul na togor i kákán mái mámán má na obop diar uri minat. ");
INSERT INTO sgz_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Matananu no da mikmikwa gam káplabin sur iau. Mái sár kono a tur rakrakai pang i arahrahi, ái Káláu na aliwi sang. ");
INSERT INTO sgz_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Má ngo di abilbilingna gam i malar erei gam han ur on, gama táu bul uri kesá malar. A muswan á minái iau parai si gam ngo káp gama te arah noi besang á balis á Israel mai kamu him, mái Natun Kálámul na tur soura. ");
INSERT INTO sgz_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Má kápte kesi kalik án aratintin a pakta sorliwi kán tám aratintin, má kápte tám toptop a pakta sorliwi kán tátáil. ");
INSERT INTO sgz_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kalik án aratintin na kuluk i bál ngo na ngoro kán tám aratintin. Má toptop, ngo na ngoro kán tátáil, na kuluk i bál sang. Káksiai ngo tám aratintin a kuluk ngo a tám sápkin, matananu di lu hol on ngo kán kalik án aratintin a ngorer i kán tám aratintin sang. Má ngorer iak parai si gam ngoromin. E ngo di lu utung iau mai Belsebul, ki ngorer da utung gam mam te táit a lala sák sorliwi ngis er di utung iau mai.” ");
INSERT INTO sgz_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Mái Iesu a sopasun mul i kán worwor uri narsán kán kalilik án aratintin ngoromin, “Má tan kálámul di kurtara mam gam, koion gama mata di. Táit erei di bohoi, da sakra sarai. Má boh táit no a punpunam, da tur talas. ");
INSERT INTO sgz_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Má ngorer táit iau parai si gam i kuron, gama parai i talas. Má táit mul gam longrai di arasás mai uri talngán kálámul, da bin mai i lol malar. ");
INSERT INTO sgz_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Koion gama bulat sur di ái rung da up bingi kápán páplun i gam sár má kápdite arwat ngo da up bingi tanián i gam. Ái sár gama mata Koner a mon i kán rakrakai suri na up bingi kápán páplun kálámul má tanián mul má nák sápkai uri pokon án hiru áklis. Ái sang á matngan kálámul gama bulat on. ");
INSERT INTO sgz_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Di sirai aru i usir artálár mai kesi gengen pirán tabal sár, be? Ái sár ngo kesi usir a pur mák mat, ái Káláu a talas ur on, wa ákte mángát palai suri ngorer! ");
INSERT INTO sgz_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Má gam, ái Káláu a lala hol pas gam. Wa ákte wás noi á tan towon nih gam er i lul gam. ");
INSERT INTO sgz_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Io, ngorer koion gama bulat kabin gam no sang gam támin muswan i mátán táil ái Káláu alari tan usir.” ");
INSERT INTO sgz_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Mái Iesu a sopasun mul i kán worwor uri narsán kán kalilik án aratintin ngoromin, “Ái koner a para talsa iau singin matananu ngo ái á kaiak, á iau ina longoi mul ngorer, ina para talsai kálámul er i mátán táil i Kakang imi bát ngo ái á kaiak. ");
INSERT INTO sgz_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mái sár ái koner a arkawar pala iau i mátán matananu ngo ái kápte ngo táring, á iau mul ina arkawar palai i mátán táil i Kakang imi bát. ");
INSERT INTO sgz_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Kái gama hol on á gam ngo iau hut mai moloh ur main i naul bim suri na tukes i kamu hol sár. Kápte sang! Kabin te da ruruna i iau má te kápte, ngorer iau hut ngoro is án arup suri gama kis arsagil. ");
INSERT INTO sgz_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Áá, ái kákán na tur kaplah alar natun, mái natun na mos i kákán. Na ngorer mul ái mámán na tur kaplah alar natun tahlik, mái natun tahlik na mos i mámán. Wák na mos mai ián lik, má ngorer nák ru i diar. ");
INSERT INTO sgz_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Mái rung di lu kis i kesá rum, á di da lu kurtara kaleng mam di sang. ");
INSERT INTO sgz_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ái koner kán armámna uri narsá kákán mái mámán a pakta sorliwi kán armámna sur iau, ái kápate arwat suri na kang kalik án aratintin. Mái koner kán armámna uri narsán rang natun a pakta sorliwi kán armámna sur iau, ái mul kápate arwat suri na kang kalik án aratintin. ");
INSERT INTO sgz_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ngo ái koner a nem suri na mur i iau, na puski kán kubau kus sang má nák murmur i iau mai, ngorer na bál tari sang uri lalin i iau má na eran suri na mat ngoro iau. Mái koner kápate longoi ngorer, ái kápate arwat suri na kalik án aratintin kaiak. ");
INSERT INTO sgz_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Má ngorer ngo kálámul a tar kunlai kán liu suri na bes mai tan táit til main i naul bim, ki liu muswan er a kis áklis na bokoh alari. Mái sár ái koner kápate mámnai kán liu mák áslai rangrangas sur iau, ái na atur páptai liu muswan er.” ");
INSERT INTO sgz_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Mái Iesu a arahi kán worwor uri narsán kán kalilik án aratintin ngoromin, “Ái koner a árár pas iáu, kápate árár masikna pas iáu, a árár pas iau mul. Mái koner a árár pas iau ngorer, kápate árár pas iau masik, a árár pas Koner mul a tarwa iau ur mainái. ");
INSERT INTO sgz_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Má ngo kesi kálámul a tám arbin si Káláu má ngorer kesi kálámul ák árár pasi kabin a tám arbin, arul er ái Káláu na supni tám arbin mai, kálámul erei na otoi matngan arsupan erei mul. Mái koner a árár pasi tám arbin si Káláu kabin tám arbin er a lu mur arwat i nemnem si Káláu, ái Káláu na supan diar no mai kesi matngan arsupan sár. ");
INSERT INTO sgz_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Káksiai ngo kálámul a artangan mudán sár ngorer a tari dan a gáwár singin kes tili di á tan rang turang minái kabin ngo turang, a támin muswan ngo ái Káláu na supni kálámul erei.” ");
INSERT INTO sgz_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","A be para noi tan worwor talas ái Iesu uri narsán kán sángul mai aru i kalik án aratintin, io a aptur ái Iesu tilatung i malar er má ák han uri tan malar iatung i balis erei sang, má ák atintini tan kálámul má ák arbin mul. ");
INSERT INTO sgz_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Mái Ioanes Tám Arsiu a kis i batbat kalar i pákánbung erei. A alongra tilatung má a longrai arbin sur Mesaia a longoi tan him, máng kálik ngátngát i kán hol. Má ngorer ái Ioanes a artari suri te kalilik án aratintin káián sang suri da alongra singin. Má te kalilik án aratintin káián di hut singin iatung, má ngorer a dos pala di má di han tapam hut narsá Iesu ");
INSERT INTO sgz_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","má dik parai singin ngo, “Una para talsai si gim be. Á iáu sár ái koner si Ioanes a parai ngo na hut? Kol ngádáh, gima kis nanai besang i tekes alatung be?” ");
INSERT INTO sgz_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Má ngorer ái Iesu a parai si di ngo, “Gama kaleng má gamák bit atalsa Ioanes suri tan táit gamáte mákái má gamáte longrai. ");
INSERT INTO sgz_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ngorer tan rau di mákmák kaleng; má tan rung di peu di láklák; tan lepra di sengsegeng; má tan rung a dik i talngá di, di alongra mul; má ái rung dikte mat, di aptur kaleng; má lain arbin a tapam hut singin tan maris mul. ");
INSERT INTO sgz_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ái koner a mánán tus iau má kápate mikmikwa iau, na kuluk pala. Mái koner kápate mánán tus iau má a hol pala iau, ngádáh na kuluk ngoi?” ");
INSERT INTO sgz_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Má tan kalilik án aratintin si Ioanes erei di aptur pas má dik turpasi láklák kaleng uranang i narsán ái Ioanes. Io, namur ái Iesu a turpasi worwor sur Ioanes uri narsán tilik matananu má a parai si di ngoromin, “I bung er gam han suri longrai arbin si Ioanes iamuni pokon mau, dánih gam han suri gama mákái? Gam han suri mákái táit bia ngorer i aun got a sámtur pagas má kihkih kán tu kihngai suri ák lek uradi ngo uranang? Kápte! ");
INSERT INTO sgz_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Dánih sang gam han suri mákái á gam? Gam han suri mákái kálámul kán mermer a tuan alal? Auh, kápte! Ái rung di lu mermer ngorer, wa di á tan konom sang má di lu kis i rum kán kabisit. ");
INSERT INTO sgz_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Gama parai singing, dánih gam hol on suri gama mákái má? Gam han suri mákái tám worwor tus? Mokol, a támin muswan. Má iau parai si gam ngo gamáte mákái má tám worwor tus, mái koner sang a sorliwi tan tám worwor tus, ");
INSERT INTO sgz_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","kabin ngo ái ái koner Buk Tabu a arbin suri ngoromin, ‘Mákái! Ina tarwai kesá kálámul suri tari kak pinpidan. Ái na táil i iáu, má na eran i matananu suri inan kaiam.’ ");
INSERT INTO sgz_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","A támin muswan iau parai si gam. Ái Ioanes a pakta sorliwi tan kálámul no dikte káh di, mái sár ái koner a gengen i lolsit tilami bát, ái sang a pakta si diar ái Ioanes Tám Arsiu. ");
INSERT INTO sgz_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tangkabin tungu er i pákánbung ái Ioanes Tám Arsiu a arbin mák arsiu ák han pang onin, tan tám ngákngák dikte tohoi suri da tur kári má long sáksáknai lolsit tilami bát. ");
INSERT INTO sgz_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tangkabin hirá ák han pang i bung ái Ioanes a hut, arbin ákte kis i buk án nagogon si Moses má i buk kán tan tám worwor tus, má worwor er a arbin sur Elaisa na hut táil suri eran i sál suri lolsit tilami bát na hut. ");
INSERT INTO sgz_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Má ngo gama kebeptai kandi arbin má gamá ruruna on, ki ngorer gama mák ilmi ngo ái Ioanes Tám Arsiu ákte hut suri kipi nián ái Elaisa, má ngorer a long arwat pasi worwor taru erei. ");
INSERT INTO sgz_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ái koner a nem ngo na talas má na mánán, ki na kis án alongra.” ");
INSERT INTO sgz_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Mái Iesu a sopasun i kán worwor narsán matananu ngoromin, “Ina toh arwat i ngaul matananu onin mai dánih? Di ngoro tan kalilik di sukis má di hom i lol malar. Kesi risán á kalilik di bin ur singin kesá risán, má dik parai si di ngoromin, ");
INSERT INTO sgz_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Á gim minái gim posri kuduh má gimá saksak suri gama mil, mái sár kápgamte nem suri mil! Io, ki gimá ilang suri táit án tinang, má ngorer gimá saki saksak án mihmih tinang, mái sár kápgamte nem suri tang!’ ");
INSERT INTO sgz_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Má ngaul matananu onin di lu ngorer mam giur ái Ioanes Tám Arsiu. I pákánbung ái Ioanes a hut, kápte a lala namnam má kápte a lu ngin i wain mul, má gamá parai ur on ngo, ‘A ngul ái koner, a kis on gut i sápkin tanián!’ ");
INSERT INTO sgz_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Má namur Natun Kálámul a hut, má ái a namnam má a ngin, ki gamá parai bul ur on ngo, ‘Mákái! Tám namnam mat má taba kán ngin mul i wain, má a lu araturán mai bos tám kip takis má tan tám sápkin!’ Io, ái Káláu á polon á hol, má kán sál a támin, má ngorer ngo rung di mur on, di inngas tari ngo sál si Káláu a nokwan má a kuluk.” ");
INSERT INTO sgz_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Má i tan malar er ái Iesu ákte longoi tan akiláng ái tungu, kápdite ilang alari kándi sápkin, má ngorer ái Iesu a wor uri matananu tilatung mák parai uri di ngoromin, ");
INSERT INTO sgz_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Gama tuan sák á gam tara Korasin má tara Betesaida! Gama tuan sák taladeng sang kabin ái Káláu na nagogon i gam á matananu tilatung suri tan akiláng ngo dikte longoi i katbán i gam má kápgamte kis án sum suri. Má ngo dikte han longoi mul á tan akiláng ngorer hirá sang i aru á malar erei Tair má Sidon, wa matananu tilatung da han te oboi akiláng án mokos, má ngorer da sámri mul i kápán páplun i di mai iahiah suri para apos di ngo dikte hol kaleng. ");
INSERT INTO sgz_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","A támin muswan iau parai si gam, i bungun nagogon ái Káláu na tari rangrangas ur Tair má Sidon. Mái sár rangrangas na oboi i gam á matananu Korasin má Betesaida na lala sák taladeng sang. ");
INSERT INTO sgz_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Mái sár á gam á tara Kapernaum bul, gam ngoi ngo gama rakrakai taladeng má pakta sorliwi boh malar no, be? Wa ái sinih a parai si gam? Kápte sang! Ái Káláu na sápka gam uradi tarang án minat kabin kápgamte hol kaleng alari kamu tan sápkin i pákánbung erei gam mákái tan akiláng dikte longoi i katbán i gam. Ngo dikte han longoi mul á tan akiláng ngorer hirá sang i malar á Sodom, wa matananu tilatung da han te hol kaleng má, má ngorer malar erei kápnate sák, na ekesi kis má pang onin! ");
INSERT INTO sgz_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","A támin muswan iau parai si gam, i bungun nagogon ái Káláu na tari rangrangas ur Sodom. Mái sár rangrangas na oboi i gam á matananu Kapernaum na lala sák taladeng sang!” ");
INSERT INTO sgz_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","I pákánbung erei sang, ái Iesu a parai ngoromin, “Io, Tata, á iáu Konom u kátlán i naul bát má naul matmatngan pokon no! Minái iau ot kuluk má para agas iáu, Tata, suri sál erei ukte ilwa pasi ngo una mur on, má ngorer ukte para aposoi si rung kápdite lala mánán á táit er ukte punmai si di ái rung di mánán.” ");
INSERT INTO sgz_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Má namur ái Iesu a parai mul singin matananu ngo, “Ái Kakang ákte tar noi tan táit singing. Ái Káláu masik a mánán muswan i Natun, mái Natun masik a mánán muswan i Káláu er Kákán. Mái rung a ilwa pas di ái Natun, á di mul di arwat suri da mánán muswan i Káláu er Kákán, ngo ái Natun a inngas tari si di. ");
INSERT INTO sgz_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Bos tám mánán uri nagogon dikte taun pápta gam mai marán táit gam lu risgos suri mur on. Gama lákám ur main i narsang má inak pusak pasi kamu kipkip má gamák mangeh. ");
INSERT INTO sgz_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Gama rusan tar gam uri lalin i iau má gamák mánán pasi singing á nemnem si Káláu. Ngo gama longoi ngorer, gamák lain aunges sang, kabin iau lu kuluk mai tan kálámul. ");
INSERT INTO sgz_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Iau parai ngorer si gam kabin aratintin iau atintin gam mai a malmu, má talar ina tari si gam a tu bánbán sár.” ");
INSERT INTO sgz_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Má namur ái Iesu mai kán kalilik án aratintin di láklák tangrai te numán padi i bungán aunges, má kán kalilik án aratintin di matpám. Io, di turpasi suri pulái padi má di parak palai táprákun mai lim di má namur di ani kotlin. ");
INSERT INTO sgz_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Má te Parisaio di mákái má dik gálta Iesu ngo, “Suri dánih kam kalilik án aratintin di longoi ngoro minái má uri nagogon kángit a parai ngo koion á longoi ngorer i bungán aunges?” ");
INSERT INTO sgz_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","A kos di ái Iesu ngoromin, “Ngádáh? Kápgamte wás pasi besang gut suri tatalen ngoromin a longoi ái Dewit i pákánbung a matpám tiklik mai rang turán? ");
INSERT INTO sgz_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","A kusak uri rum si Káláu má a top pasi beret erei di artabar mai uri narsán ái Káláu, má ák ani. Má uri nagogon kángit kápate artálár singin ngo na ani mái rung mul di tiklik mai, arwat sár mai tan tám osmapak masik ngo da ani. ");
INSERT INTO sgz_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mokol, gamáte mánán ngo nagogon a parai suri koion gita him on á bungán aunges. Mái sár gam mánán mul ngo tan tám osmapak tili rumán osmapak di lu lákái nagogon suri talar mai osmapak i bungán aunges. A támin sang, mái sár ái Moses a parai ngo tan tám osmapak kápdite longoi sápkin ngo di longoi ngorer. ");
INSERT INTO sgz_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","“A támin muswan iau parai si gam ngo minái má ákte hut á támin táit er a pakta sorliwi rumán osmapak má torahin nagogon mul, ");
INSERT INTO sgz_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","8","kabin Natun Kálámul a konom ur on á bungán aunges. Kápgamte talas suri worwor si Káláu er a parai ngoromin, ‘Iau nem i gam ngo gama lu armámna uri narsán matananu. Ái a kuluk si diar á osmapak mai ololas.’ Ngo gamáte talas suri worwor min, ki gama mák ilmi ngo kápte di longoi sápkin ái rung minái, má kápte gama wás pala di.” ");
INSERT INTO sgz_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Má namur ái Iesu a láklák alari pokon erei má a kusak uri kandi rumán lotu. ");
INSERT INTO sgz_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Má kesi kálámul iatung a sák i limán. Má te kálámul di iatung di nem suri da atiutiu Iesu, má ngorer di gáltai ngoromin, “Bos nagogon kángit di atintin git suri dánih gita longoi i bungán aunges. A sormángát i git suri gita araliu i bungán aunges ngo kápte?” ");
INSERT INTO sgz_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Mái Iesu a parai uri narsá di ngo, “Be, ngo kes tili gam a mon i kán sipsip mák han pur uri polgon tinkas i bungán aunges, ngádáh? Una tu mákmákái sár, ngo una long pas kalengnai tilatung? A támin muswan una duruk pasi sang tilatung! ");
INSERT INTO sgz_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mái sár kálámul a támin táit alari sipsip! Io, nagogon kángit a sormángát i git suri gita tángni kálámul i bungán aunges.” ");
INSERT INTO sgz_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Má namur ái Iesu a parai singin kálámul erei ngo, “Una anokwai limam!” Má kálámul erei a longrai ngorer má ák anokwai limán má limán áng kuluk kaleng, ák ngorer i kesi limán sang. ");
INSERT INTO sgz_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Má tan Parisaio di mákái ngorer má dik bál mos, má ngorer di nguruk arliu i di sang má ser sál suri dánih má da longoi mam Iesu suri da tari uri minat. ");
INSERT INTO sgz_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Má ngo ákte nuhi ái Iesu ngo da longoi ngorer mai, io a han pas tilatung i malar erei. Má tilik matananu di mur on má di kipi marán kálámul di sasam uri narsán, mái Iesu a aliu pas di no, ");
INSERT INTO sgz_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","má a dos kalar di suri koion da para sarai singin tan lite kálámul. ");
INSERT INTO sgz_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","A tur kári matananu ái Iesu suri ák tapam hut muswan i midán ái Káláu er a parai si Aisaia tám worwor tus ngo, ");
INSERT INTO sgz_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Kálámul minái kang Kalik alal, a gas i balang mai, má ái á kak tám arardos iakte ilwa pasi. Ina asosah on mai Taniang, má ngorer na bit atalsai kak sál a nokwan uri narsán matananu on á naul matmatngan pokon no. ");
INSERT INTO sgz_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Má kálámul minái kápnate salarek mai kán worwor ngo na arngangar mai tan kálámul i malar. ");
INSERT INTO sgz_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Má ái mul kápnate bálsák mam rung erei di bilbiling, ngo na mos pala di ái rung káp kandi te rakrakai. Na sopasun kán him pang i bung ngo ákte suka bámiai sápkin tatalen, má tatalen a nokwan masik a kis. ");
INSERT INTO sgz_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Má kálámul erei sár, matananu on á naul bim da atri kandi ngangai on suri na aliu pas di.” ");
INSERT INTO sgz_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Io, te kálámul bul di tangnai kesi kálámul narsá Iesu kabin kálámul erei sápkin tanián a mon on, má ngorer a rau á mátán mák gap i ngudun. Mái Iesu a long palai sápkin tanián alari, má kálámul erei a turpasi worwor má a mákmák kaleng mul. ");
INSERT INTO sgz_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Má tan kálámul no iatung di pángáng má dik parai ngoro mer, “Be, ngádáh? Ái sár gut ái koner Natun ái Dewit?” ");
INSERT INTO sgz_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Má tan Parisaio di longrai ngorer má dik parai ngo, “Ái Belsebul sár á erei, kabisit káián tan sápkin tanián. Ái sár a tari rakrakai singin suri ák lu tipar palai tan sápkin tanián.” ");
INSERT INTO sgz_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","A mánán i kándi holhol ái Iesu má a parai narsá di ngoromin, “Ngo tekesi mát a mon i tan boh i di má namur da arup arliu i di sang, ngádáh da ngoi? Mát erei na sák, má matananu kápnate kes kaleng i di mul. Má ngo tekesi aratámán da togor má dáng kis arsagil, kápnate mon i kandi rakrakai suri da pam talumna di, má na sák sang á kandi kiskis án aratámán. ");
INSERT INTO sgz_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","“Ái Satan mul a ngorer á kán lolsit. Ngo ái Satan na arup kaleng mai má nák ru on, kápnate tur rakrakai i kán him, má kán him na mat sár. ");
INSERT INTO sgz_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Má gamá parai uri iau ngo iau tipri sápkin tanián mai rakrakai ái Belsebul a tari singing. Má ngo iau tipar palai sápkin tanián mai rakrakai si Belsebul, ki ngádáh? Ái rung tili gam er di lu tipar palai sápkin tanián, di lu longoi mai rakrakai si Belsebul mul? Kápte sang. Má ngorer di sang di inngasi kamu angagur. ");
INSERT INTO sgz_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Mái sár ngo iau tipar palai sápkin tanián mai rakrakai er Tanián ái Káláu a tari singing, ki a támin muswan ngo lolsit si Káláu sang ákte tapam hut, mái Káláu ákte turpasi kátlán i te tili gam erei. ");
INSERT INTO sgz_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ngo kes a nem ngo na kusak i rum káián tám rakrakai ngorer ái Satan suri long sarai kán tan táit, na mulán kápti be tám rakrakai erei, má namur na kusak má nák long sáksáknai kán tan táit. ");
INSERT INTO sgz_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ái koner kápate táring sang, ái a kurtara mam iau. Mái koner kápate tangan iau suri iang talmi, ái a tam sarai matananu alar iau. ");
INSERT INTO sgz_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","A támin muswan iau parai si gam. Tan sápkin tatalen má tan worwor sáksák gam longoi, a arwat ngo ái Káláu na pah palai. Mái sár ngo kálámul na ot bilingnai Tanián a Pilpil, ái Káláu kápnate hol palai. Kán sápkin tatalen na tur áklis. ");
INSERT INTO sgz_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Má ngo tekesá kálámul a ot bilingnai Natun Kálámul, arwat ái Káláu na hol palai sár á erei. Mái sár ái koner a ot bilingnai Tanián a Pilpil, ái Káláu kápnate hol palai til on i liu onin ngo i liu erei namur mul.” ");
INSERT INTO sgz_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Mái Iesu a sopasun kán worwor uri narsán tan Parisaio ngoromin, “Git lu mák ilmi boh kubau tili wán i di. Lain kubau una soi, namur na pakta na oboi lain wán, mái sár sápkin kubau a oboi wán a sák. ");
INSERT INTO sgz_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Gam tan sápkin kálámul gam ngoro tan kanih sáksák! Má ngádáh gama parai lain worwor ngoi kabin gam sápkin kálámul, má tan táit er a káng i bál gam a so má gamá parai mai ngus gam? ");
INSERT INTO sgz_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","A mon i omobop imi bál git no keskeskes. Lain kálámul a apos tari a kuluk imi bál má a oboi lain wán mák longoi lain tatalen. Má ngorer mul á sápkin kálámul. Ái a apos tari sápkin tilami bál má a oboi sápkin wán, ngorer ák longoi sápkin tatalen. ");
INSERT INTO sgz_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","A támin muswan iau parai si gam. I bungun nagogon, keskeskesá kálámul na tin murwai boh kuir worwor ákte utngi er kápate tangan tekes, má na parai mul i kápkabin si Káláu suri dáh ák parai ngorer. ");
INSERT INTO sgz_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Má kam boh worwor sang ái Káláu na nagogon i iáu mai ngo iáu tám nokwan ngo iáu tám sápkin.” ");
INSERT INTO sgz_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Má ngorer te tám mánán uri nagogon má te Parisaio di aptur má dik parai singin ngo, “Tám Aratintin, gim nem i tekesá akiláng una longoi be suri gimák mákái.” ");
INSERT INTO sgz_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Mái Iesu a kos kalengna di ngoromin, “Á gam á ngaul matananu onin gam lala sápkin sang, gam tur kaplah alar Káláu! Gam gálta iau suri ina longoi tekesi akiláng suri gamák mákái ngo ái Káláu a kis i narsang, mái sár kápte kesi akiláng ina longoi narsá gam. Akiláng ákte kis má, má ái sár á akiláng a longoi ái Iona tám worwor tus. ");
INSERT INTO sgz_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ái Iona ákte bop i polgon bál tilik isu pasi atul i pákán nas má atul i pákán libung. Má Natun Kálámul na ngorer mul, na bop i tanglon bim pasi atul i pákán nas má atul i pákán libung. ");
INSERT INTO sgz_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“I bungun nagogon, matananu til Niniwe da aptur má dák atiutiu gam kápkabin á di sang di hol kaleng alari kandi sápkin tatalen i pákánbung di longrai arbin si Iona. Má iau parai si gam ngo kálámul a pakta sorliu Iona minái má ákte hut, má kápgamte alongra singin. ");
INSERT INTO sgz_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Má namur, i bungun nagogon sang, tasim tili mátán kihkih matalames na aptur má nák atiutiwi ngaul matananu onin, kápkabin hirá tasim erei ákte aptur alari kán malar tepák suri longrai tan arabitbit si Solomon. Má iau parai si gam ngo kálámul a pakta sorliu Solomon minái má ákte hut, má kápgamte alongra singin.” ");
INSERT INTO sgz_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Mái Iesu a sopasun kán worwor uri narsá di ngoromin, “I pákánbung ngo sápkin tanián a so alari kálámul, a han tangrai pokon mau mák ser sur te nián suri na mon ái. Má ngo kápate ser pas tekesi nián iatung i pokon erei, ");
INSERT INTO sgz_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ki namur má a tubán parai singin sang ngo, ‘Auh, wa ina kaleng sang má mul uri niang iakte táu alari.’ Io, namur a kaleng i sápkin tanián erei uri torahin nián, má a mákái ngo ákte pilpil má a páhngán, má tan táit iatung i nián ákte kuluk pagas. ");
INSERT INTO sgz_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Io, má sápkin tanián er a mákái ngorer mák han pas mák lam pasi ahit mul i sápkin tanián di lala sápkin sorliwi sang, má di no di kaleng má ding kusak uri kálámul er má dik mon iatung on. Má kálámul erei tungu a kálik sák mai kes sár i sápkin tanián, onin ák lala sák taladeng sang. Má ngaul matananu onin mul da sák ngorer i kálámul erei.” ");
INSERT INTO sgz_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ái Iesu kán tu worwor be narsán matananu iatung, má ái mámán tiklik mai rang tuán di hut má dik lu turtur iatung i risán rum má dik gálta suri. Di nem suri na so ái Iesu má dák worwor mai. ");
INSERT INTO sgz_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Má ngorer kes a parai singin ngo, “Ái mamam má rang tuam di sámtur idi karpala má di nem suri da worwor mam iáu.” ");
INSERT INTO sgz_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Mái Iesu a kosoi ngoromin, “Aiá á mamang, mái sinih á rang tuang?” ");
INSERT INTO sgz_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Mái Iesu a tusi kán kalilik án aratintin mák parai ngo, “Minái ái mang má bos rang tuang. ");
INSERT INTO sgz_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ái koner a mur i holhol si Kakang imi bát, ái á tuang má kukung má mamang.” ");
INSERT INTO sgz_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","I bung sang erei, ái Iesu a so alari rum er má a han uratung i risán dan taliu á Galiláiá mák sukis ái. ");
INSERT INTO sgz_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Má lala matananu di hut iatung i narsán má dik sámtur kauli. Io, ngorer ái Iesu a roh uri kesi mon mák sukis, má matananu di tur pagas iamuni kon. ");
INSERT INTO sgz_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mái Iesu a atintin di mam te pinpidan artálár tilatung i mon má a parai si di ngoromin, “Tám himhimna a tapam hut mák sápra sarai kotlin kubau iatung i rákrák. ");
INSERT INTO sgz_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Má te kotlin kubau a pur iatung i sál má bos man di roh kis má dik tokam pasi. ");
INSERT INTO sgz_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Má te a pur uri bim a kis i hat adi lal, kápte marán bim on, ngorer a kopkom melek. ");
INSERT INTO sgz_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Mái sár nas a ket má a kektai tan kopkobon kubau erei, má a maulur a kabin kápte bim suri nirwán na kip namnam til on, má ngorer ák marang no. ");
INSERT INTO sgz_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Má te kotlin kubau mul a pur uri katbán kaulbek, má kaulbek a pakta mák iaungi má kápate u. ");
INSERT INTO sgz_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Má te a pur uri lain bim má a tikbut má a lain kopkom kuluk má namur a u. A u ngoromin, te atul i sángul má te awon i sángul má te a u arwat mai kesi mar á wán. ");
INSERT INTO sgz_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ái koner a nem ngo na talas má na mánán, ki na kis án alongra!” ");
INSERT INTO sgz_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Má kán kalilik án aratintin ái Iesu di longrai ngorer má namur di han narsán má dik gáltai ngo, “Suri dáh u atintini matananu mai tan worwor artálár ngorer?” ");
INSERT INTO sgz_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Má a kos di ái Iesu ngoro minái, “Tungu a tur punpunam á mánán suri lolsit tilami bát má sál a mur on ái Káláu suri kátlán i git. Má onin ái Káláu ákte tari mánán er si gam á tan kalilik án aratintin. Mái sár tan lite alatung, ái Káláu kápte a tari mánán si di. ");
INSERT INTO sgz_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ngorer ái koner a hol páptai pinpidan káián ái Káláu, ái Káláu na apakta pasi kán pinpidan i bál má na lala mánán. Mái koner kápte a hol páptai kán pinpidan, ái Káláu na pah palai mudán er a kis i kán hol. ");
INSERT INTO sgz_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Má kápkabin iak tari worwor artálár minái narsá di, a kabin di mákái táit mai mát di má kápdite mák ilmi, má di longrai táit mai talngá di má kápdite longra ilmi, má kápdite talas suri. ");
INSERT INTO sgz_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Tan kálámul onin di ngoro tan kálámul i pákánbung a liu on ái Aisaia tám worwor tus er ák parai ái Káláu singin sur di ngoromin, ‘Á di da tu longrai worwor artálár sár, mái sár kápte da talas suri sálán. Má da mákmák má da mákái, mái sár kápte sang da mák ilmi. ");
INSERT INTO sgz_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Bos kálámul minái kápte di nem suri longrai má taram i kak bos worwor. Dikte su bah di uri iau. Má ngorer iakte dung kári talngá di suri kápdate longra pasi dánih iau parai, má iakte apedei mát di suri kápdate mák tusi dánih iau inngasi si di. Ngo kápte da han su bah di uri iau, ki da han tapriu sur iau má inak aliu pas di.’ ");
INSERT INTO sgz_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Mái sár á gam gam kuluk pala kabin gam mákái táit mai mát gam má gamá mák ilmi, má talngá gam a longra ilmi mul. ");
INSERT INTO sgz_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","A támin muswan iau parai si gam ngo marán tan tám worwor tus má tan tám nokwan til hirá di nem suri mákái táit ngorer gamáte mákái, mái sár kápdite mákái. Di nem suri longrai tan táit gam longrai, má kápdite longra te on.” ");
INSERT INTO sgz_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Má ngorer ái Iesu a para talsai uri narsán kalilik án aratintin á sálán worwor artálár suri tám himhimna ngoromin, “Gama alongra má gamáng kip mánán suri sálán á worwor artálár erei. ");
INSERT INTO sgz_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tám himhimna a sápra sarai pinpidan suri lolsit tilami bát. Ngo tekes a longrai pinpidan erei, mái sár kápte a talas suri, ái a ngoro bim erei tangrai sál kotlin kubau a pur ur on. A pur ngorer, mái koner si Tám Sápkin a hut melek mák long palai pinpidan erei i bál má kápate hol páptai. ");
INSERT INTO sgz_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ngorer mul suri te kotlin a pur uri bim a kis i hat adi lal. Bim erei a tur arwat mai kálámul a longrai pinpidan má ák laes melek suri, ");
INSERT INTO sgz_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","mái sár pinpidan kápate lala sisip i nirwán uri bál, má ngorer kápte a tur rakrakai. Má namur ngo arabilbiling a hut má ák áslai rangrangas kabin a lu mur i pinpidan si Káláu, ki ák teken pur melek. ");
INSERT INTO sgz_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Má te kotlin a pur uri katbán kaulbek. Bim erei a arwat mam koner a longrai pinpidan, mái sár holhol suri táit án naul bim má hol apakta i minsik a kusak i bál má ák iaungi pinpidan káián ái Káláu má kápate u. ");
INSERT INTO sgz_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Má te kotlin a pur uri lain bim. Ái sang a arwat mam koner a longra pasi pinpidan má ák talas ur on, má ngorer a u, kes atul i sángul, má kes awon i sángul, má kes mul a mar.” ");
INSERT INTO sgz_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Mái Iesu a sopasun kán worwor mai parai kesi worwor artálár mul uri narsá di ngo, “Lolsit tilami bát a ngorer i kálámul a ilwa pasi tan lain kotlin padi mák soi i kán pokon. ");
INSERT INTO sgz_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mái sár i katbán libung tan kálámul no di boptin, má kesi kálámul a kurtara mai kálámul erei a hut iatung i pokon mák soi ngán i lolon numán padi erei má ngorer ák han alari má. ");
INSERT INTO sgz_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Namur i bung a kopkom mák pakta i tan padi mák turpasi suri oboi wán, io má ngán erei mul a maras tiklik mai padi er. ");
INSERT INTO sgz_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Má namur tan tám arardos káián kálámul er di mákái ngán iatung i num má ngorer dik han bitái kálámul er ngo, ‘Konom, ngádáh a ngoi á ngán máng kopkom turán padi kabin u so masiknai padi sár i kam pokon?’ ");
INSERT INTO sgz_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Má kálámul káián i num er a kokos kaleng mák parai si di ngo, ‘Te kálámul di kurtara mam iau di soi á ngán er.’ Tan tám arardos er di gáltai kálámul er ngo, ‘Ngádáh, gima han má gimák rabut palai ngán tili kam num?’ ");
INSERT INTO sgz_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Má kálámul er a kos kalengna di mák parai ngoromin, ‘Na, koion sang gama longoi ngorer. Erei ngo gama rabut palai ngán, gama káp rabut tikliknai mai padi. ");
INSERT INTO sgz_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Páksiai ngorer nák lu tur pang na matuk i padi. Má ngorer inak parai singin tan kálámul di lu kip talmi balbal suri dák mulán rabut palai ngán er, má ngorer da dut talmi suri da osoi i kámnah, má namur da kip talmi padi má dák oboi i kak boh suapok.’” ");
INSERT INTO sgz_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Mái Iesu a parai kesi worwor artálár mul uri narsá di ngoromin, “Lolsit tilami bát a ngorer i kotlin kali a gengen sár singin boh kotlin kubau. Kesi kálámul a top pasi mák soi i kán num, má namur a kopkom i kotlin kali erei má a lala aun kubau sang alari boh kubau no. Má namur tan man di roh kis on má di longoi páhiun i di iatung i boh rákán má.” ");
INSERT INTO sgz_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ngorer mái Iesu a bali worwor artálár mul ngoromin, “Lolsit tilami bát a ngorer i yis. A long pasi mudán yis i wák mák argemwai turán lala palawa er i lus, má ngorer palawa no iatung i lus a sut pakta.” ");
INSERT INTO sgz_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Tan aratintin no suri lolsit tilami bát, ái Iesu a lu parai mai worwor artálár uri narsán matananu, má kápte a lu aratintin ngo na te tu worwor sár. Kápte. Pinpidan artálár sang a lu parai. ");
INSERT INTO sgz_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","A longoi ngorer ái Iesu suri ák long arwat pasi táit er a parai i kesi tám worwor tus ngo, “Tan táit er a punpunam pagas tangkabin tili akaksim ák han pang onin, ina kip aut noi uri narsán matananu, má ina parai mai worwor artálár uri narsá di.” ");
INSERT INTO sgz_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Má ngo ái Iesu a arahi kán worwor narsán matananu, namur a aptur alar di ák han pas tilatung i pokon erei máng kusak kaleng uri rum. Má kán kalilik án aratintin di mur on má dik han hut i narsán ái Iesu má dik parai singin ngoro minái, “Gim ri suri ngo una bit atalsa gim be i sálán worwor artálár suri ngán er a kopkom i pokon. Dánih á sálán?” ");
INSERT INTO sgz_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ái Iesu a kos di mák parai ngo, “A kuluk. Tan táit i worwor artálár er iakte parai, di arwat mai tan táit ngoromin. Ái koner a soi lain kotlin padi a tur arwat mai Natun Kálámul, ");
INSERT INTO sgz_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","má num a tur arwat mai naul matmatngan pokon, má lain kotlin padi arwat mai matananu káián ái Káláu. Dut ngán a tur arwat mai rung di mur i koner si Tám Sápkin, ");
INSERT INTO sgz_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","má kurtara er a soi ngán a tur arwat mam Satan. Má ngorer mul suri kip talmi balbal a matuk, a tur arwat mai arahrahi naul matmatngan pokon. Mái rung di kip talmi padi, di sang á tan angelo. ");
INSERT INTO sgz_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Má on á worwor artálár er, tan tám him di han dut talmi ngán má dák osoi i kámnah. Io, namur sang i arahrahi, naul matmatngan pokon na ngorer mul. ");
INSERT INTO sgz_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","I pákánbung erei sang, Natun Kálámul na dos palai kán tan angelo má dáng kip talmi tan tám abulbul má tan kálámul erei di lam bengtai te kálámul má dik longoi sápkin. ");
INSERT INTO sgz_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tan angelo da long pasi tan sápkin kálámul er tili katbán lolsit má da buswa di uri pokon án hiru áklis, pokon a málmálas i kámnah on, má iatung má da tang má ararat ngis ái. ");
INSERT INTO sgz_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Má i pákánbung er, bos tám nokwan da ngoro nas a talas iatung i lolsit káián ái Kák di. Ái koner a nem ngo na talas má na mánán, ki na kis án alongra!” ");
INSERT INTO sgz_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Mái Iesu a sopasun kán worwor uri narsán kán kalilik án aratintin ngoromin, “Lolsit tilami bát a ngoro omobop kes a kas tahun punmai i kesá kuir pokon. Má namur kesá kálámul a him i pokon er mák banai. A kas pasi mák lu mákái, má namur a punam kalengnai mul iatung i pokon er. Má kálámul er a lala laes, mák han mák sira noi tan táit káián, má ngorer a kaleng mák hul pasi pokon ur káián suri ngorer omobop er na ur káián.” ");
INSERT INTO sgz_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Má kesi worwor artálár a parai ái Iesu a ngoromin mul, “Kesi kálámul tám hul kelel, ái diar arwat i lolsit tilami bát. Kálámul erei a lu han tangrai malar mák lu ser iatung singin tan kálámul suri kodil mátán kelel má ák lu hul pasi si di. ");
INSERT INTO sgz_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","A bali kaleng mul á kálámul suri hul kelel i kesá pákán mák mákái kesi kodil mátán kelel a tuan alal. Má ngorer a sira noi tan táit káián má a kaleng mák hul pasi ur káián á kodil mátán kelel er.” ");
INSERT INTO sgz_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","A ngoromin mul á worwor artálár ái Iesu a parai, “Uben ái á táit diar arwat i lolsit tilami bát. Ngo tan kálámul di soksok, di asihái kandi uben uri lontas, má ngorer di talkai toltolom isu mai uben ");
INSERT INTO sgz_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","uratung i lol kon má dik sukis suri ilwai isu. Ngorer má isu er a arwat uri ani, di dungi iatung i rat. Má isu er a sák kápte a arwat suri ani, di sápka palai. ");
INSERT INTO sgz_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Má er namur sang i arahrahi naul matmatngan pokon, na ngorer mul narsán matananu no. Tan angelo da han má dák tam purwai matananu uri aru á boh, ki dák long pasi tan sápkin kálámul alari tan kálámul er bos tám nokwan. ");
INSERT INTO sgz_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Má tan sápkin kálámul, tan angelo da buswa di uri pokon án hiru áklis, pokon a málmálas i kámnah on, má iatung má da tang má ararat ngis ái.” ");
INSERT INTO sgz_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ái Iesu kán tu parai tan worwor artálár er uri narsán kán kalilik án aratintin, má ngo a para noi tan worwor er, ki ák gálta di ngoromin, “Be, ngádáh? Gam talas ur on sang á tan worwor artálár erei iakte bit gam on?” Io, má di kos Iesu ngo, “Áá, gimáte mánán on má.” ");
INSERT INTO sgz_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Mái Iesu a kos kalengna di ngoromin, “Ngo kesi tám mánán uri nagogon a kipi aratintin uri lolsit tilami bát, ái a ngorer i kesi konom a mon á hutngin táit má torahin táit mul i kán omobop. Má ngorer i pákánbung a nem on, a arwat suri na han long pasi tili omobop á hutngin táit má torahin mul. Ngorer i tám mánán uri nagogon a arwat suri na kip artangan til on á aru aratintin no, hutngin aratintin má torahin mul.” ");
INSERT INTO sgz_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ái Iesu a be para noi tan worwor artálár erei, má namur a han alari malar er, ");
INSERT INTO sgz_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","má a han uri kán malar sang. Má namur a atintini matananu tilatung ami rumán lotu. Má marán di longrai má di sodar on má di parai ngoromin, “Kálámul min a mánán ngádáh á bos táit minái? Til ái á rakrakai er ák longoi bos akiláng mai? ");
INSERT INTO sgz_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ái koner natun ái tám long rum erei, be? Má natun ái Maria mul, má rang tuán minái narsá git, ái Iakobo mái Iosep mái Saimon mái Iudas. ");
INSERT INTO sgz_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Má rang kukun di minái mul. Má ái, ai a kipi til ái á mánán má rakrakai erei?” ");
INSERT INTO sgz_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Má ngorer ák sák i bál di uri Iesu. Mái Iesu a mákái ngorer má a parai si di ngo, “Tám worwor tus, di lu rumrum on i malar tepák. Ái sár i kán malar muswan má i kán rum sang, kápdite lu rumrum on ái.” ");
INSERT INTO sgz_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Má ngorer kápate long te marán akiláng iatung i malar er kabin kápdite ruruna on. ");
INSERT INTO sgz_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","I pákánbung erei ái Erodes, kabisit til Galiláiá, a longrai arbin sur Iesu ákte arkaliut, ");
INSERT INTO sgz_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","má a parai ngoromin singin kán tan tám arardos, “Kálámul er di parai, wa ái Ioanes sang, er Tám Arsiu. Ákte liu kaleng alari minat, má ngorer ák mon i kán rakrakai suri longoi bos akiláng erei.” ");
INSERT INTO sgz_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Káplabin worwor erei a ngoromin. Tungu sang, ái Ioanes a liu be, a worwor rakrakai uri mátán ái Erodes suri kesi sápkin tatalen a longoi. A parai ngoromin, “Ukte ras pas Erodiá, wák si tuam ái Pilip, má kápate nokwan.” Má ngorer a mos i bál ái Erodes diar mokson. Má namur ái Erodes a lala holhol sur kán wák, má ák tarwai wor ngo da kabat pas Ioanes uri rumán batbat kalar kápkabin sur Erodiá. ");
INSERT INTO sgz_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","A nem ái Erodes suri na up bing Ioanes, mái sár a bulat suri matananu káplabin ngo di ngoi ngo ái Ioanes a tám worwor tus si Káláu. ");
INSERT INTO sgz_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Má namur ái Erodes a longoi kesi tilik lala namnam. A hol pasi bung er a káhái on ái mámán. A longoi lala namnam ngorer má a kilkilai marán kálámul. Má i pákánbung er, natun tahlik ái Erodiá a kusak mák mil. Ái Erodes a mákái ngorer má a lala nem on, ");
INSERT INTO sgz_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","má ngorer a oror mam kukun ur singin tahlik er ngo, “Te táit una sung iau suri, ina tari singim.” ");
INSERT INTO sgz_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Má kalik átlái erei a so suri gátna mámán ngo dánih na sungi, má namur a kusak kaleng narsá Erodes má ák sungi ngoromin, “Iau nem i lul ái Ioanes Tám Arsiu. Una oboi i map má unák tari singing.” ");
INSERT INTO sgz_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mái Erodes a longrai ngorer má a tuan sák i bál suri, ái sár ákte oror i mátán bos kálámul erei má a rumrum suri na tah kusi kán oror, má ngorer a ardos suri da mur sár i nemnem si natun tahlik. ");
INSERT INTO sgz_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","A dos palai kesi tám arup suri tah kusi pogong a Ioanes má náng kipi lul. Má tám arup erei a han má a tah kusi pogong a Ioanes iatung i rumán kamkabat. ");
INSERT INTO sgz_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Má a oboi lul ái Ioanes i kesi map má áng kip tari singin kalik átlái. Má kalik átlái erei a top pasi má ák tari si mámán. ");
INSERT INTO sgz_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Má namur tan kalilik án aratintin káián ái Ioanes di longrai, má dik han má ding kip pasi kápán páplun má dik tahni. Má namur di han uri narsán ái Iesu má dik para talsai singin á táit erei. ");
INSERT INTO sgz_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Má ngo ái Iesu ákte longrai arbin sur Ioanes ngo ákte mat má, ngorer ák roh uri kesi mon má ák han alari malar er uri kesá kuir pokon mau. Má ngo matananu di longrai ngo ái Iesu ákte han má, di aptur alari kandi tan malar má dik láklák tangrai sál namurwa Iesu, má dik han hut iatung i pokon er na han ur ái. ");
INSERT INTO sgz_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Má ngo ái Iesu a tapam hut, ák mákái tilik lala matananu má a mámna di. A roh alari mon má a asengsegeng pasi tan sasam er matananu dikte kip di uri narsán. ");
INSERT INTO sgz_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Io, ákte rahrah má i bung erei, má kán kalilik án aratintin di hut si Iesu má dik parai singin ngoro minái, “Wa nas ákte dorah má, má pokon mau mul á minái! Una dos palai mái matananu sara suri da han uri tan malar iatung páput sár suri da ser namnam ándi.” ");
INSERT INTO sgz_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ái Iesu a longrai ngorer ki ák parai si di ngoromin, “Suri dáh da han? Á gam sang, gama tabar di.” ");
INSERT INTO sgz_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Má tan kalilik án aratintin di kosoi ngoro minái ngo, “Kápate arwat á namnam minái si git. Alim i tigán balbal má aru isu sár.” ");
INSERT INTO sgz_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ái Iesu a longrai mák parai si di ngo, “Gama kipi ur main singing.” ");
INSERT INTO sgz_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mái Iesu a parai ur singin matananu suri da sukis iatung i ur. Má namur ái Iesu a top pasi alim á tigán balbal má aru isu erei, má ák tántán urami bát mák sung kári. Má namur ák tibi balbal má ák tari singin kán kalilik án aratintin suri dik tulsai i matananu sang. ");
INSERT INTO sgz_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","21","Má tan kálámul no iatung di arwat mai alim i arip á káláu, má boh wák má kalilik kápte di wás di. Má matananu di no di namnam má dik mas. Má namur tan kalilik án aratintin dik dungi sángul mai aru i kas áng káng mai namnam er di an tigán. ");
INSERT INTO sgz_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mái Iesu a dos palai kán kalilik án aratintin suri da táil uri risán dan taliu, má ái na tarwa palai besang i matananu ki nák mur. Má kán kalilik án aratintin di sa uri mon má dik han. ");
INSERT INTO sgz_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Má ngo ákte tarwa palai matananu, ái Iesu masik sár a tapam uramuni pungpung suri na sung, mák ronron on iatung. ");
INSERT INTO sgz_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Má bos kalilik án aratintin di iatung i mon, di kis tepák alari kon ada i katbán dan taliu, má bát a lala kihngai mon kabin a hut tilamuda i táil i di. ");
INSERT INTO sgz_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Io, mái pákánbung kok a tang i kuir libung besang, ái Iesu a láklák iamuni kápkápán dan mák hut iatung narsá di. ");
INSERT INTO sgz_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Má ngo tan kalilik di mák pasi a láklák iamuni iátin dan, di ráuráuwas má dik lala wakwak mai mátut má dik parai ngo, “Wai! Tesit á erei!” ");
INSERT INTO sgz_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Mái Iesu a teken bin ur si di ngoromin, “Gama mangan! Koion gama mátut, á iau sár á min.” ");
INSERT INTO sgz_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Mái Petero a aptur mák parai ngo, “Konom, ngo á iáu muswan á erei, ki una parai singing suri inak láklák uratung sur iáu ami kápkápán dan.” ");
INSERT INTO sgz_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Mái Iesu a parai singin ngo, “Má iáu má! Lákám!” Má ngorer ái Petero a roh alari mon mák turpasi láklák ami kápkápán dan tálángna Iesu. ");
INSERT INTO sgz_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Mái sár a ilang ilang ái Petero mák mákái ngo bát a apturi dan ák sák, má ngorer a mátut mák turpasi dom uradi lol dan. Io, má ngorer a bin sur Iesu ngo, “Konom, una tangan iau!” ");
INSERT INTO sgz_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","A sarsara melek ái Iesu má a top pasi limán ái Petero mák parai singin ngoromin, “Ngádáh, káp kam te ruruna? Suri dáh a gáugáu i kam holhol sur iau?” ");
INSERT INTO sgz_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Má ngorer diar sa uri mon, má bát a aunges. ");
INSERT INTO sgz_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Má tan kalilik erei i mon di mákái ngorer ki ding kis dirtapul i mátán táil ái Iesu má dik parai singin ngo, “Támin muswan á iáu Natun ái Káláu!” ");
INSERT INTO sgz_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Má ngo dikte polsai dan taliu ngorer, ki dik han masar á Genasaret. ");
INSERT INTO sgz_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Má tan kálámul tilatung di mák ilam Iesu, má ngorer di artari uri tan kuir balis no alatung má ding kipi bos sasam uratung i narsá Iesu. ");
INSERT INTO sgz_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Má dik sung Iesu suri ngo ái rung di sasam da tu singli sár i nomnobon lusán. Mái rung di singli, di no di sengsegeng. ");
INSERT INTO sgz_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Má tan Parisaio má tan tám mánán uri nagogon tilami Ierusalem di hut narsá Iesu má dik gátnai ngo, ");
INSERT INTO sgz_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Suri dáh kam kalilik án aratintin di hol palai arabitbit káián rang támin i git, ngorer dik namnam má kápdite ililim táil besang?” ");
INSERT INTO sgz_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Mái Iesu a kos di ngoromin, “Má gam, suri dáh gam hol palai arardos káián ái Káláu suri gama murmur i kamu arabitbit sang? ");
INSERT INTO sgz_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ái Káláu a parai ngoromin, ‘Una rumrum i kakam mái mamam.’ Má kes mul, ‘Ngo kálámul a worwor sáksák i kákán mái mámán, da up bingi.’ ");
INSERT INTO sgz_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mái sár gamáte pukdai má gam lu parai ngoromin. A arwat suri kálámul ngo a mon i kán pirán tabal uri tangan kákán mái mámán, má namur ák han uri narsá diar mák parai si diar ngoromin, ‘Pirán tabal minái uri tangan gaur, mái sár ina tari má ur káián ái Káláu.’ Ngo gam mákái ngorer, gam parai ngo kálámul er a sengsegeng alar kákán mái mámán, má kápte má na te tangan diar mul. ");
INSERT INTO sgz_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Gam lu parai ngorer, má ngorer gam hol sirereh i pinpidan si Káláu suri gama murmur i kamu arabitbit sang. ");
INSERT INTO sgz_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Gam á bos tám tuar! Kán pinpidan ái Káláu i buk káián ái Aisaia tám worwor tus ákte para aposoi má á kamu tatalen er ák para ngoromin, ");
INSERT INTO sgz_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Kabinhun erei di rumrum i iau mai kápán ngus di sár, má bál di a tepák alar iau. ");
INSERT INTO sgz_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Di lu arabitbit sár mai nagogon káián rang támin i di má dik parai ngo worwor káián ái Káláu, má ngorer dik omlawai kándi lotu uri narsang.’” ");
INSERT INTO sgz_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Mái Iesu a kilkila pasi matananu mák parai si di ngoromin, “Gama longra pasi worwor minái suri gamák talas ur on. ");
INSERT INTO sgz_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Tan táit tili karpala er a kusak urami ngudun kálámul, kápnate long adurwán on i mátán táil ái Káláu. Kápte. Má táit a han pas tili hol kán kálámul mák so i ngudun, ái a long adurwán on.” ");
INSERT INTO sgz_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Má tan kalilik án aratintin di han narsá Iesu má dik parai singin ngo, “Be, u mánán mul ngo tan Parisaio di kip sáksáknai worwor er u parai uri di mák sák i bál di suri?” ");
INSERT INTO sgz_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Mái Iesu a kos di ngo, “A kuluk, mái Kakang imi bát na rabut pala noi á tan kubau er kápate soi. ");
INSERT INTO sgz_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Koion gama konngek sur di á tan Parisaio, di ngoro kesi rau a lami rang turán. Mái sár kálámul a rau kápnate arwat suri lami turán. Ngo na longoi ngorer, ki diar no diara pur uri tinkas.” ");
INSERT INTO sgz_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Mái Petero a parai si Iesu ngo, “Unák pálás timani worwor erei suri gimák talas ur on.” ");
INSERT INTO sgz_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Mái Iesu a parai ngoromin, “Á gam mul gam ngul besang? ");
INSERT INTO sgz_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Gam mánán ngo namnam erei a kusak i ngudun kálámul a kusak sár uri pagarbal má namur ák pek palai. Ngádáh na adurwán ngoi á kálámul á ngorer? ");
INSERT INTO sgz_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Mái sár táit a lu so pas tili ngudun kálámul, ái sang a lu long adurwán on i mátán ái Káláu kabin a aptur pas tilami kán hol sang. ");
INSERT INTO sgz_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Til ami hol kán kálámul a so i tan sápkin tatalen ngoromin: hol sáksák, up bingi kálámul, bop mai wák káián lite, araturán sáksák, siksikip, angagur uri kes, má para bengtai kálámul. ");
INSERT INTO sgz_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Bos sápkin táit no erei a tapam hut tili hol kán kálámul, má a tubán long adurwán i kálámul sang i mátán táil ái Káláu. Mái sár ngo kálámul a namnam má kápate ililim táil, tatalen er kápnate long adurwán on i mátán ái Káláu.” ");
INSERT INTO sgz_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Má namur ái Iesu a aptur alari malar erei má a han uri balis á Tair má Sidon. ");
INSERT INTO sgz_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Má kesá wák tili malar erei, ái sang á tah Kanan, a han mák sung Iesu ngoromin, “Una mámna iau, Konom, iáu natun ái Dewit. Natung tahlik a kis on i sápkin tanián má kán liu a lala sák!” ");
INSERT INTO sgz_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Mái sár ái Iesu kápate para te worwor mai wák er. Má ngorer kán kalilik án aratintin di han narsán ái Iesu má dik parai singin ngo, “Wák er kán tunga mur i git sang mák lala ororok. Una dos palai má nák lu han!” ");
INSERT INTO sgz_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Mái Iesu a parai ngo, “Káp iau te hut sur rung tili risán. Iakte hut sang mai kak him suri ina han narsá di á matananu Israel di ngoro tan sipsip kápte te kák di.” ");
INSERT INTO sgz_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","A longrai ngorer ái wák erei ki ák han mák pur dirtapul i mátán táil ái Iesu, má ák parai ngo, “Konom, una tangan iau!” ");
INSERT INTO sgz_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Mái Iesu a longrai ngorer mák parai ngoromin, “Da tabar amasi bos kalilik táil, má kápate arwat ngo da kip palai balbal áián bos kalilik suri da támri bos pap mai.” ");
INSERT INTO sgz_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Má wák erei a parai ngo, “A muswan, Konom, ái sár bos pap di lu ani bos mulen namnam a pur tili suh káián kák di.” ");
INSERT INTO sgz_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","A kosoi wák er ái Iesu ngo, “Kam ruruna a pakta taladeng! Má táit u ngangai suri, ina longoi uri narsam.” Má pákánbung er sang, sápkin tanián a han alari tahlik er ki ák sengsegeng má. ");
INSERT INTO sgz_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","A han alari malar er ái Iesu má a láklák tangrai kon i risán dan taliu á Galiláiá, má a tapam uri kesi pungpung mák sukis pagas ái. ");
INSERT INTO sgz_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Marán kálámul di purut iatung i pungpung narsá Iesu mam rung di sasam ngorer i te kálámul di rau, má te kálámul a sák i lim di ngo kik di, má te a gap i ngus di, mái rung di sasam mai toltolom sasam. Má ngorer di obop di iatung narsán ái Iesu má a asengsegeng i di. ");
INSERT INTO sgz_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Má tan kálámul er a gap i ngus di be, di worwor kaleng; mái rung mul a sák i lim di ngo kik di, di kuluk kaleng; mái rung di rau, a talas i mát di ngorer di mákmák mul. Tan kálámul di mákái ngorer má dik pángáng suri, má ngorer dik párngai ngisán ái Káláu káián matananu Israel. ");
INSERT INTO sgz_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Má namur ái Iesu a kilkilai kán kalilik án aratintin uratung i narsán mák parai si di ngo, “Iau lala mámnai matananu minái di kis tiklik mam git arwat mai atul á bung má káp ándi te namnam má. Kápate gas i balang ngo ina dos pala di mai matpám uri kándi bos malar, da káp bámrus hanhan tangra sál.” ");
INSERT INTO sgz_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Má kán kalilik án aratintin di parai si Iesu ngoromin, “Til ái á te balbal á main i pokon bia min suri gita támri lala matananu minái mai?” ");
INSERT INTO sgz_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Mái Iesu a gálta di ngo, “A is á balbal erei?” Má dik mákmák má dik parai ngo, “Ahit sár, má te gengen isu mul.” ");
INSERT INTO sgz_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Mái Iesu a parai singin matananu ngo da sukis iatung i bim, ");
INSERT INTO sgz_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","má namur a kip pasi ahit á balbal má tan isu mák sung kári. Má namur a tibi mák tari singin kán kalilik án aratintin má dik támri matananu mai. ");
INSERT INTO sgz_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","38","Di no di namnam on má dik mas. Má tan káláu no iatung di arwat mai ahat i arip, má boh wák má kalilik kápte di wás di, mái sár kápdite long arwat on ngo da arahi namnam erei. Má kalilik án aratintin si Iesu di kip talmi tigán balbal erei di mas tigán uri ahit i kudut. ");
INSERT INTO sgz_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Má namur ái Iesu a tarwa pala di uri kándi bos malar. Mái Iesu má kán kalilik án aratintin, di sa uri kesá mon má dik han uri balis á Magadan. ");
INSERT INTO sgz_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Má kesi pákán te Parisaio má te Sadukaio di nem suri da tohtoh Iesu, ngorer má dik han uri narsán má dik parai singin ngo na longoi tekesi akiláng tilami bát suri inngasi ngo rakrakai káián ái Káláu a kis i narsán. ");
INSERT INTO sgz_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","A kos di ái Iesu mák parai ngoromin, “Á gam gam lu mákái bát a mirik i rahrah ákte dorah mái nas, ki gamá lu parai ngo, ‘Na lain bung á latiu.’ ");
INSERT INTO sgz_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Má i kábungbung gam mákmák má gamá mákái bát a mirik máng kuron i pokon mai kumlán mehmeh, ki gamá lu parai ngo ráin na hus. Áá, gam mánán sár suri mák ilmi pákánbung ngorer. Mái sár ngádáh, kápgamte arwat suri mák ilmi tan akiláng uri bung onin?” ");
INSERT INTO sgz_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","A bali parai ngoromin mul ái Iesu, “Á gam á ngaul matananu onin gam lala sápkin sang, gam tur kaplah alar Káláu! Gam gálta iau suri ina longoi tekesi akiláng suri gamák mákái ngo ái Káláu a kis narsang, mái sár kápte kesi akiláng ina longoi narsá gam. Akiláng ákte kis má, má ái sár á akiláng a longoi ái Iona tám worwor tus.” Io, ngorer a aptur pas ái Iesu ák han alar di iatung. ");
INSERT INTO sgz_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","I pákánbung di alus kusai dan taliu uranang i kesi balsán ái Iesu di, kán tan kalilik án aratintin di barung, kápdite kip te balbal suri na arwat mai kándi inan. ");
INSERT INTO sgz_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ái Iesu a parai si di ngoromin, “Gama ololoh na káp porta i gam i tatalen káián tan Parisaio má tan Sadukaio. Kándi tatalen erei na káp sinim i gam ngorer i yis a sinim i palawa.” ");
INSERT INTO sgz_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Mái sár kápdite talas ur on má dik argátna arliu i di ngoromin, “Dánih a worwor suri? A kabin káp ángit te namnam, be?” ");
INSERT INTO sgz_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Mái Iesu a mák ilmi uri kandi hol mák parai si di ngoromin, “Suri dáh gam lala worwor arliu i gam suri ngo káp amu te namnam? Ngádáh, káp kamu te ruruna? ");
INSERT INTO sgz_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Má kápgamte talas besang uri iau? Ngádáh, kápgamte lu hol páptai á bung iau tabar amasi alim i arip á kálámul mai alim i balbal má aru i isu? Má gam kipi a is á kudut a káng mai tigán namnam di mas tigán? ");
INSERT INTO sgz_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Má i pákánbung er iau tibi ahit á balbal ur singin matananu di arwat mai ahat i arip á kálámul, gam akángái a is á kudut mai tigán balbal a lu kis? ");
INSERT INTO sgz_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Iau ngo gama ololoh kuluk i gam suri tatalen káián tan Parisaio má tan Sadukaio, kabin tatalen erei a ngoro yis di lu argemwai mai beret suri ák sut. Ngádáh, kápgamte talas be? Káp iau te parai si gam suri namnam.” ");
INSERT INTO sgz_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ki erei má dik talas á tan kalilik án aratintin ngo ái Iesu kápte a akeng i di suri yis erei di oboi i beret, mái sár suri aratintin káián tan Parisaio má tan Sadukaio. ");
INSERT INTO sgz_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Má namur ái Iesu má kán kalilik án aratintin di han hut i balis á Sisaria Pilipoi, má iatung i kuir er ái Iesu a gálta di ngo, “Matananu di lu parai suri Natun Kálámul ngo ái ái sinih?” ");
INSERT INTO sgz_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Má ding kos Iesu ngoro minái, “Te kálámul di parai ngo iáu ái Ioanes Tám Arsiu, má te bul di parai ngo iáu ái Elaisa, má te kálámul sang di parai ngo iáu ái Ieremiá ngo kesi tám worwor tus til hirá.” ");
INSERT INTO sgz_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Namur mul ái Iesu a gáltai kán kalilik án aratintin ngo, “Má á gam sang, gam ngoi ngo iau sinih?” ");
INSERT INTO sgz_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ngorer mái Petero a kos Iesu ngoro minái, “Á iáu á Mesaia, Natun ái Káláu koner a liu áklis.” ");
INSERT INTO sgz_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Mái Iesu a parai singin ngo, “Saimon, natun ái Ioanes, iáu tuan kuluk pala kabin kam mánán sur iau ngorer kápte a hut singin tekesá kálámul a mon i kápán páplun. Kápte sang. Ái Kakang imi bát sang a para aposoi singim. ");
INSERT INTO sgz_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Má ina parai singim, iáu Petero sálán ngo ‘Hat’, má tan kálámul di rang táring ina aksim di ami iátin kábutkis minái, má minat kápate rakrakai arwat suri na suka bámia di. ");
INSERT INTO sgz_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Má iau ina tari singim á ki uri lolsit tilami bát, má ngorer na mon i kam rakrakai suri una tur kári táit main i naul bim mái Káláu na sormángát suri. Má ngorer mul táit una mángát palai main i naul bim, ái Káláu na taram on má na mángát palai mul.” ");
INSERT INTO sgz_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","A rah i kán worwor ngorer ái Iesu, má a tur kári kán kalilik án aratintin ngo koion sang da parai singin tekes ngo ái á Mesaia. ");
INSERT INTO sgz_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","I bung erei sang má, ái Iesu a tangkabin suri worwor talas narsán kán kalilik án aratintin ngo, “Ina han sang urami Ierusalem má inak áslai rangrangas singin bos kálámul pakta má bos pakpakta kán tan tám osmapak má bos tám mánán uri nagogon, má da obop iau uri minat. Má ngo na rah i atul á bung, ina liu kaleng.” ");
INSERT INTO sgz_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Má ngorer ái Petero a talka pas Iesu suri diar masik má ák turpasi wor rakrakai ur on suri matngan worwor erei ái Iesu a parai si di. Mái Petero a parai singin ngo, “Konom, kápte sang a arwat á ngorer! Táit ngorer kápnate hut i narsam!” ");
INSERT INTO sgz_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Mái Iesu a ilang mák tur kalar Petero ngoromin, “Satan, á iáu sár u parai á worwor erei! Una kelkel alar iau! U nem una tur pala iau má inak tutkum i kam pidir! Kápute mánán i káplabin holhol káián ái Káláu. U hol pasi sár i tatalen káián matananu.” ");
INSERT INTO sgz_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Mái Iesu a parai si di á tan kalilik án aratintin iatung ngoromin, “Ngo kono a nem suri na mur i iau, koion sang na murmur i kán hol. Na puski kán kubau kus má nák murmur i iau mai, ngorer na bál tari sang uri lalin i iau má na eran suri na mat ngoro iau. ");
INSERT INTO sgz_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Má ngorer ngo kálámul a tar kunlai kán liu suri na bes mai tan táit til main i naul bim, ki liu muswan er a kis áklis na bokoh alari. Mái sár ái koner kápate mámnai kán liu mák bál tari sang sur iau, ái na atur páptai liu muswan er. ");
INSERT INTO sgz_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ngádáh, a kuluk ngo kálámul na kátlán bos matmatngan táit main i naul bim, má nák omlawa palai kán liu suri? Má dánih á táit ngo na hul kelsei kán liu mai? Kápte sang. ");
INSERT INTO sgz_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Páput sár má Natun Kálámul na hut sosih mul mai talsán minmáir i Kákán, má na hut tiklik mai kán tan angelo. Má na hut sang suri na supni tan kálámul keskeskes mai arsupan er a artálár mai kandi tan tatalen. ");
INSERT INTO sgz_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","A támin muswan iau parai si gam, te tili gam gam sámtur minái, kápdate áslai besang á minat má dák mákái Natun Kálámul na hut suri na kátlán i kán matananu.” ");
INSERT INTO sgz_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Má namur ngo ákte rah i awon á bung, ái Iesu a lam pas Petero mái Iakobo diar tuán ái Ioanes tiklik mai, má dihat má tapam uramuni iátin pungpung suri dihat masik. ");
INSERT INTO sgz_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Má ngo atul i kalik án aratintin erei ditulá mákmák, ái Iesu a arkeles. Aur a talas ngoro talsán nas, má lusán a tuan bal sang mák pilpilpil. ");
INSERT INTO sgz_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Má namur ditul má mák Moses mái Elaisa diar worwor mam Iesu. ");
INSERT INTO sgz_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Má ditul má mákái ngorer, má namur ái Petero a parai si Iesu ngo, “Konom, a kuluk sang ngo git minái. Má ngo u nem on, arwat á iau ina longoi na tul i pálpálih, kes kaiam, má kes káián ái Moses, má kes káián ái Elaisa?” ");
INSERT INTO sgz_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Má kán tunga worwor be ái Petero, má kumlán mehmeh a talas a hut mák ámkuk di, má namur kaungán kes tilami kumlán mehmeh a para ngoromin, “Minái á kang Kalik alal, iau laes suri, má balang a kuluk mai. Gama alongra singin.” ");
INSERT INTO sgz_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Má ditul longrai ngorer má ditul mátut taladeng má ditulá pur dirtapul uradi bim. ");
INSERT INTO sgz_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","A han átik mul ái Iesu narsá ditul mák top i ditul mák parai si ditul ngo, “Gamtul aptur má koion gamtula mátut.” ");
INSERT INTO sgz_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Má ditulá mákmák kalar di, mái sár káp ditul te mák tekes mul, ái Iesu masik sár má iatung dihat no. ");
INSERT INTO sgz_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Má ngo di lu sososih tilamuni pungpung, ái Iesu a tur kalar ditul mák parai ngo, “Koion gamtula parai singin tekes suri táit gamtul mákái nák han pang i pákánbung ngo Natun Kálámul na liu kaleng tili minat.” ");
INSERT INTO sgz_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Má ditulá gátnai ngoromin, “Suri dáh bos tám mánán uri nagogon si Káláu di parai ngo ái Elaisa na hut táil sang, má namur ái Mesaia?” ");
INSERT INTO sgz_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Mái Iesu a parai si di ngoromin, “Támin muswan ngo ái Elaisa na hut táil suri na eran i tan táit no. ");
INSERT INTO sgz_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Má iau parai si gam ngo ái Elaisa ákte hut má, ái sár matananu kápdite mák ilmi má dik long sáksáknai mai kándi sápkin holhol. Má da longoi ngorer mul mai á Natun Kálámul, da long sáksáknai sang.” ");
INSERT INTO sgz_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Má ngorer ditulá talas má ngo ái Iesu kápate worwor mam ditul sur Elaisa muswan. Kápte. A para tusi si ditul ngo ái Ioanes Tám Arsiu, ái sár ái Elaisa er ákte hut má. ");
INSERT INTO sgz_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Má ái Iesu dihat, dihat lu sososih tilamuni pungpung uratung i narsán matananu. Io, má ngorer kesi kálámul a han mák pur dirtapul i mátán táil ái Iesu ");
INSERT INTO sgz_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","mák parai singin ngo, “Konom, una mámnai besang i natung, kang kalik án káláu. A lala sasam mai gokgok, má a lu pur uri kámnah mák lu pur uri dan mul i te pákán. ");
INSERT INTO sgz_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Má ngorer iakte long pasi uri narsán kam kalilik án aratintin ngo da long palai sápkin tanián erei, mái sár kápdite long arwat on.” ");
INSERT INTO sgz_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ái Iesu a longrai worwor erei máng kokos ngoromin, “Á gam er káp kamu te ruruna má kápgamte talas uri táit a kuluk alari táit a sápkin! Na is á bet ina kis tiklik mam gam? Iak ngesmat má, na is á bet mul ina mona gam?” Ngorer mái Iesu a parai si di ngo, “Gama lam pasi kalik ur main.” ");
INSERT INTO sgz_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","A mákái kalik ái Iesu má ngorer a wor uri sápkin tanián mák dos palai alari, má i pákánbung erei sang kalik er a sengsegeng má. ");
INSERT INTO sgz_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Má namur tan kalilik án aratintin di han kodong narsá Iesu má dik gátnai ngo, “Suri dáh á gim kápgimte arwat suri long palai sápkin tanián erei?” ");
INSERT INTO sgz_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Mái Iesu a parai si di ngoromin, “Kápkabin kamu ruruna uri narsán ái Káláu a gengen sár. A muswan iau parai si gam, ngo kamu ruruna na ngorer i kotlin kali, káksiai ngo a tu gengen sár, a arwat sang ngo gama parai singin pungpung min ngo, ‘Hai! Una kakat tilatung má unák han kis mamuda!’ Má pungpung er na longra pasi má na taram i gam. Ngorer kápte kesi táit na rakrakai sorliwi kamu ruruna! ");
INSERT INTO sgz_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Má matngan sápkin tanián minái, sung má ahal masik sár arwat suri tipar palai.” ");
INSERT INTO sgz_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Má ngo ái Iesu má kán kalilik án aratintin di hut talum á Galiláiá, ái Iesu a parai si di ngo, “Da tari Natun Kálámul uri limán bos kálámul ");
INSERT INTO sgz_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","má dák up bingi. Mái sár namur ngo atul á bung ákte rah, na liu kaleng.” Má kalilik án aratintin di longrai ngorer mák tabureng i bál di. ");
INSERT INTO sgz_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Má namur ái Iesu turán kán kalilik án aratintin di hut kaleng i malar á Kapernaum, má ngorer kesi tám kip takis tili rumán osmapak a mák Petero mák gáltai ngo, “Be, Petero, ngádáh suri kam tám aratintin? Na hul takis uri rumán osmapak mul?” ");
INSERT INTO sgz_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Mái Petero a kosoi kálámul erei ngo, “Áá, mokol. Na hul takis sang.” Má namur ngo a kusak uratung i rum ái Petero, ái Iesu a teken sáng pasi mai worwor mák gáltai ngo, “Saimon, dánih u hol on suri á matngan ngoro minái? Di lu kip takis singin tara dáh á tan pakpakta til main i naul bim? Tili narsán rang buh di sang ngo singin tan lite?” ");
INSERT INTO sgz_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Mái Petero a parai si Iesu ngo, “Di lu kip pirán tabal singin tan lite.” Mái Iesu a parai ngoromin, “Io, ngo a ngorer, ki rang buh di káp kandi te kuir on uri hul takis. Má ngorer gitar sengsegeng á gitar suri takis er kabin gitar buhán ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Mái sár da káp sák i bál di uri gitar ái rung tilatung, ngorer una han uradi dan má unák wonwon. Mulán isu una wonoi, ái una long pasi unák tapángni ngudun, ngorer una mákái kesá pirán tabal iatung. Una top pasi pirán tabal er má unák han tari singin tám kip takis má parai singin ngo pirán tabal er kángitar no sár uri takis.” ");
INSERT INTO sgz_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","I bung erei sang, tan kalilik án aratintin si Iesu di han uri narsán má dik gálta pasi mai kesi argálta ngoromin, “Be, ái sinih sang á kálámul a pakta i lolsit tilami bát?” ");
INSERT INTO sgz_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","A long pasi kesi gengen kalik ái Iesu má a atri i katbán i di, ");
INSERT INTO sgz_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","má namur a parai si di ngoromin, “A muswan iau parai si gam, ngo gam nem i sol uri lolsit tilami bát, ngorer gama kelsen kamu holhol má nák ngoro holhol káián gengen kalik. Má ngo kápgamte kelsen kamu holhol, káp gama te kusak sang. ");
INSERT INTO sgz_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mái koner a agengen pasi sang mák ngoro gengen kalik minái, ái a kálámul pakta uri lolsit tilami bát. ");
INSERT INTO sgz_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Ái koner a tángni kesá gengen kalik a ngoro kono minái kabin ngo a mámna iau, kápate tangan masiknai kalik erei, a tangan iau mul.” ");
INSERT INTO sgz_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Mái Iesu a sopasun kán worwor uri narsán kán kalilik án aratintin ngoromin, “Ái rung er di ruruna i iau di ngoro rang natung. Ái koner a lam bengtai kes tili di ái rung di ruruna i iau mák apurái kán ruruna, kálámul er a longoi táit a tuan sák. Ngo da putai tilik lala hat i án pogong á kálámul er má da lápkai urada i lontas náng kong, a gengen rangrangas sár. Má rangrangas er na oboi ái Káláu ur on, ái na lala pakta taladeng kabin a long sáksáknai ruruna káián kesi natun ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Keskam singin matananu on á naul bim kabin di kis i katbán artohtoh. Boh artohtoh er a lu tutkum on i kálámul mák longoi sápkin, a támin na tapam hut sang. Mái sár na tuan sák uri kálámul er a lami kesá kálámul suri ák longoi sápkin. ");
INSERT INTO sgz_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Má ngo kesi limam ngo kesi kikim a lam arong iáu má uk lu longoi sápkin mai, ki a kuluk una tár kusi má lápka palai. A kálik sák ngo una kusak uri liu áklis mai kesi limam masik ngo mai kesi kikim sár. Mái sár a lala sák sang ngo na mon i aru limam ngo aru kikim no má dik buswa iáu uri kámnah a inan áklis. ");
INSERT INTO sgz_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Má ngorer mul mai matam. Ngo u mákmák mai, má kesi matam a lam arong iáu, una bilwak palai má unák lápkai. A kálik sák ngo una kusak uri liu áklis mai kesi matam sár, mái sár a lala sák sang ngo na kis i aru matam no má dák buswa iáu uri kámnah iatung i pokon án hiru áklis. ");
INSERT INTO sgz_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Una mák hol on ngo di tu táit bia sár á tan gengen kalilik minái. Na war á di ái rung er ái Káláu a lala belbelken i di kabin ngo tan angelo di lu tur suri ololoh i di á tan gengen kalilik, di lu ekesi tur áklis i mátán táil ái Kakang imi bát. ");
INSERT INTO sgz_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Má Natun Kálámul ákte hut suri ser pas di ái rung erei di han benget, má suri na aliu pas di mul.” ");
INSERT INTO sgz_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Mái Iesu a sopasun mul i kán worwor uri narsán kán kalilik án aratintin mai worwor artálár ngoromin, “Dánih gam hol on á gam? Ngo kes tili gam á tan kálámul min a mon i kesá mar i kán sipsip, má ngo tekes tili di ák han rong, dánih na longoi á kálámul erei? Kálámul erei na han be alari asiu i sángul mai asiu á sipsip iatung i pungpung er di lu namnam ái, má na han mákmák sur koner a rong. ");
INSERT INTO sgz_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Iau parai si gam ngo kálámul er a be ser pasi sipsip er a rong, a lala gasgas i bál suri, alari asiu i sángul mai asiu er di iatung sang. ");
INSERT INTO sgz_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ái Kakang imi bát a ngorer mul á kán nemnem. Kápte a nem suri tekesi gengen kalik na bokoh.” ");
INSERT INTO sgz_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Mái Iesu a sopasun mul i kán worwor ngoromin, “Ngo ái tuam ákte longoi táit a sápkin uri narsam, una han uri narsán má unák para talsai singin ngo a longoi sápkin. Má gaura tuán para masiknai arliu i gaur sár suri nák nokwan. Má ngo a longra iáu má a mák ilmi ngo ákte longoi sápkin, ngorer á iáu ukte lam kaleng i tuam alari tatalen erei. ");
INSERT INTO sgz_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mái sár ngo kápate alongra singim, ngorer una long pas tekes ngo na ru i kálámul mul suri gamtula han tiklik uri narsán ái tuam má gamtulák worwor mai. Gamtula longoi ngorer suri mur arwat pasi Buk Tabu er a parai ngoromin, ‘Ngo aru á kálámul a tukes on i kándiar worwor uri kálámul er a longoi sápkin, ki ngorer a adikái kándiar worwor ngo a muswan.’ ");
INSERT INTO sgz_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Má ngo kálámul er kápate alongra si gamtul, ngorer gamtula parai singin matananu án lotu suri dák longrai mul á worwor erei. Má namur ngo kápate alongra singin matananu án lotu, io erár gamák gerger palai á kálámul er kabin a tánlak alar Káláu má a tám abulbul mul. ");
INSERT INTO sgz_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Má ngorer ina parai si gam no ngo na mon sang i kamu rakrakai suri gama tur kári táit main i naul bim mái Káláu na sormángát suri. Má ngorer mul táit gama mángát palai main i bim, ái Káláu na taram on má na mángát palai mul. ");
INSERT INTO sgz_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Má inak parai mul si gam, ngo aru tili gam erei til main i bim, ngo diar sung Káláu má diara sormángát suri te matngan táit, ái Kakang imi bát na longoi sang narsá diar. ");
INSERT INTO sgz_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Á iau erei tiklik mam gam ngo gam kis talum i ngisang. Káksiai ngo gaur tara ru ngo gamtul tara tul sár, ngo gam marán sang, ina iatung tiklik mam gam.” ");
INSERT INTO sgz_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Má namur ái Petero a han narsán ái Iesu mák gáltai ngo, “Be, Konom, a is á pákán ina hol palai sápkin er ái tuang a longoi uri narsang? Ahit á pákán sang?” ");
INSERT INTO sgz_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Mái Iesu a parai ngo, “Kápte á ngorer ngo ahit á pákán sár, apong Petero. Wa ahit i sángul mai ahit á pákán er una hol palai, ");
INSERT INTO sgz_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","kápkabin ngo lolsit tilami bát a ngoro minái. A ngorer i kesá kálámul a kabisit. Má kálámul er a hol pasi má ngo na turpasi suri tintinlán i kán tan kálámul di him singin suri anokwai kándi boh tinákum. ");
INSERT INTO sgz_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Má ngo a lu ananokwai tan táit er ngorer, kán tan tátáil di lami kesi tur di a tátáil mul uri narsán pakpakta er. Má kálámul di lami uratung, ái a mon i tinákum si pakpakta erei on. Má kán tinákum a arwat mai kesi sángul á milion pirán tabal. ");
INSERT INTO sgz_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Má ngo tátáil er kápate artálár suri kosoi kán tinákum, ngorer má pakpakta er a artari suri sirai kálámul er tiklik mam kán wák má rang natun má kán tan táit mul. Má pirán tabal da sira pasi tili kálámul má kán tan táit na uri kosoi má i kán tinákum. ");
INSERT INTO sgz_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Má ngo kálámul er a longrai ngorer, a pur dirtapul mák sungi pakpakta erei ngoromin, ‘Konom, arwat una mámna iau be, má namur ina kálik lu koskosoi uri narsam á tan táit no erei.’ ");
INSERT INTO sgz_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Má kálámul pakta a mámnai kálámul er, má ngorer a hol palai kán tinákum má a arsok palai ák han sár. ");
INSERT INTO sgz_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Mái sár ngo kálámul er a han pas alari rum si kálámul pakta er, a han mák banai kesi turán diar lu him tiklik má a gálta pasi ngo, ‘Be, enges má una lu kosoi á kak sángul á pirán tabal er i iáu?’ Má a tolai kálámul er mák pami án pogong. ");
INSERT INTO sgz_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Má kálámul er a pur dirtapul má sungi turán erei ngo, ‘Turang, arwat una mámna iau be, má namur ina kosoi á kam pirán tabal er.’ ");
INSERT INTO sgz_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Mái sár kálámul er kápate longra pasi worwor si turán. A long pasi turán er mák han asoloi i batbat kalar nák han pang i bung na kosoi kán tinákum. ");
INSERT INTO sgz_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Má ngo te tur diar di longrai tatalen ngorer a longoi i kesá tur di uri narsán kes mul, bál di a sák má di han uri narsán kálámul pakta er má dik parai singin á tan táit er. ");
INSERT INTO sgz_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Má kálámul pakta er a longrai arbin, ngorer má a bin pasi kálámul er mák parai singin, ‘Iáu sápkin kálámul. Á iáu u sung iau ngo ina hol palai kam tilik tinákum, má ngorer iak longra pasi kam sung má iak hol palai má. ");
INSERT INTO sgz_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ngorer á iau iau mámna iáu, ki á iáu mul una han longoi ngorer mam turam, una han mámnai sang.’ ");
INSERT INTO sgz_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Má kálámul pakta er a togor, má ngorer a han asoloi kálámul er i batbat kalar suri da oboi rangrangas on nák han pang i bung er na keles palai kán tilik tinákum.” ");
INSERT INTO sgz_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ái Iesu a arahi kán worwor artálár má namur ák parai ngoromin mul, “Mái Kakang imi naul bát na lu longoi ngorer mul mam gam keskeskes. Ngo gama hol palai sápkin ái tuá gam a longoi mam gam, ái Káláu na mámna gam sang. Mái sár ngo kápgamte ekesi hol palai tili bál gam á sápkin er ái tuá gam a longoi uri gam, ái Káláu na arangrangas i gam sang.” ");
INSERT INTO sgz_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","I bung a arahi kán aratintin, ái Iesu a aptur pas ák han alari balis á Galiláiá má a kaleng uri balis á Iudáiá uri balsán dan á Ioridan tilada, ");
INSERT INTO sgz_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","má tilik morongnau di mur on. Mái rung di sasam, ái Iesu a asengsegeng pas di iatung. ");
INSERT INTO sgz_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Má te Parisaio di hut i narsán suri da tohoi má dik gátnai ngoromin, “Ngádáh? A sormángát á kángit nagogon suri ngo kálámul na pásang pala bia i kán wák ngo kápte?” ");
INSERT INTO sgz_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Mái Iesu a kos di ngoromin, “Ngádáh? Kápgamte wásái be ngo hirá sang i akaksim, ái Káláu a longoi káláu má wák? ");
INSERT INTO sgz_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Má a parai ngo, ‘Minái á káplabin kálámul na aptur alar kákán mái mámán má náng kis tiklik mam kán wák. Má diar no diara tukes sár. ");
INSERT INTO sgz_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Má kápnate ru i diar, diara tukes.’ Má ngorer ái Káláu ákte kabat arsakta diar, má koion á tekes na tah kusi kándiar kila.” ");
INSERT INTO sgz_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Má tan Parisaio di parai ngoromin, “Ngo ngorer, ki suri dáh ái Moses a sormángát tari nagogon án pásang kila singin matananu ngorer ngo tekesá kálámul a nem suri pásang kila, ki na siri tekesi pákán ram má nák tari si kán wák, ki nák pásang palai má?” ");
INSERT INTO sgz_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Mái Iesu a kos di ngo, “Ái Moses a tari nagogon erei má a sormángát suri pálás kila kabin a laklak i bál gam. Mái sár hirá i akaksim kápte a ngorer, ái Káláu kápate nem i pásang kila. ");
INSERT INTO sgz_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Má iau parai si gam onin ngoromin, koner a long pala kán wák máng kila pasi lite wák, ái a longoi sápkin ngo kán mulán wák kápate bop mam tekesi lite kálámul.” ");
INSERT INTO sgz_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kán kalilik án aratintin di longrai ngorer má dik parai singin ngoromin, “Ngo tatalen án kila a ngorer i nagogon i katbán káláu má wák er áng kabat pápta diar, ki koion sár á kila!” ");
INSERT INTO sgz_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Mái Iesu a kos di ngoromin, “Aratintin minái suri kila a kuluk, mái sár kápte ngo di no di kebeptai má mur on. Ái Káláu ákte tari rakrakai singin te sár. ");
INSERT INTO sgz_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Má marán kápdite artálár suri kila kabin kápdite arwat suri ararit, káplabin te di káh di ngorer sang má te bul dikte puras di. Má te mul kápdite kila, di álai sang suri tar noi kandi liu uri lolsit tilami bát. Ái koner a talas uri aratintin minái, ki na lain kebeptai sang.” ");
INSERT INTO sgz_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Má te kálámul di lami rang nat di ur si Iesu suri na oboi limán i di má nák sung suri ái Káláu na asosah i di. Mái sár tan kalilik án aratintin di mákái tan kálámul erei má dik tur kalar di suri koion da longoi ngorer. ");
INSERT INTO sgz_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Mái sár ái Iesu a parai ngo, “Gama hol palai boh gengen kalilik ur singing. Koion gama tur kalar di kabin ngo kandi ái rung ngoromin á lolsit tilami bát.” ");
INSERT INTO sgz_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Má ngorer ái Iesu a oboi limán i di má ák asosah i di má namur ák han má. ");
INSERT INTO sgz_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Má kesi kálámul a han uri narsán ái Iesu má a gáltai ngo, “Tám Aratintin, dánih á lain tatalen ina longoi suri inak atur páptai liu áklis?” ");
INSERT INTO sgz_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Mái Iesu a longrai mák parai singin ngo, “Suri dáh u gálta iau suri lain táit? Ái Káláu masik sár a kuluk má kápte kes mul. Ngo u nem i liu áklis, una mur i bos nagogon no.” ");
INSERT INTO sgz_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Má kálámul er a gálta Iesu ngo, “Boh nagogon ngádáh?” Io, mái Iesu a kosoi ngo, “Tan nagogon ngoromin: koion una up bingi tekesi kálámul, má koion una longoi sápkin mai wák káián lite kálámul, má koion una siksikip, má koion una poklah pasi angagur uri tekesá kálámul, ");
INSERT INTO sgz_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","má una rumrum i kakam mái mamam, má una mámna turam ngorer u mámna kalengna iáu sang.” ");
INSERT INTO sgz_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Má kálámul er a longrai mák parai si Iesu ngo, “Iau lu mur arwat pas noi tan nagogon erei, má dánih mul iau sáhár suri?” ");
INSERT INTO sgz_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Má a longrai ngorer ái Iesu má ák parai singin ngoromin, “U nem ngo na kuluk i ninsim arwat suri una atur páptai liu áklis, minái sár á táit una longoi. Una han sira palai kam bos minsik no má una tari pirán tabal singin bos maris. Má ngo una longoi ngorer, na kaiam besang á boh lain minsik imi bát. Má una lákám unák mur i iau.” ");
INSERT INTO sgz_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Má ngo kaukak erei a longrai worwor si Iesu uri narsán, a lala tinang má, kabin marán i kán minsik, má ngorer ák han alar di iatung. ");
INSERT INTO sgz_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Mái Iesu a parai singin kán kalilik án aratintin ngoro minái, “A muswan á minái iau parai si gam. Na tuan rakrakai muswan si di á boh konom suri da kusak uri lolsit tilami bát. ");
INSERT INTO sgz_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Iak te lu bal parai si gam, kamel ngo na sol uri polgon nil án babaut, ái a malmu si diar á kálámul a konom ngo na sol uri lolsit si Káláu.” ");
INSERT INTO sgz_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Má ngo tan kalilik án aratintin di longrai ngorer, di lala sodar má dik gálta Iesu ngoromin, “Ngo ngorer, ki ái sinih sang na liu? Kápte kes sang na kusak!” ");
INSERT INTO sgz_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Mái Iesu a mák di ngorer má a kokos ngo, “Matananu kápdite arwat ngo da aliu pas di sang. Ái sár ái Káláu a arwat, kabin ngo a lu long arwat pasi bos táit no.” ");
INSERT INTO sgz_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Mái Petero a parai si Iesu ngoromin, “Mákái, Konom, gimáte han alari kángim boh táit no má gimá murmur i iáu. Ki dánih má kángim te arsupan á gim?” ");
INSERT INTO sgz_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ái Iesu a parai si di ngo, “A muswan iau parai si gam. Namur i pákánbung ngo ái Káláu ákte ahutngin pasi naul matmatngan pokon, Natun Kálámul na kis i kán kiskis a tuan alal imi naul bát. Io má gam mul gamáte mur i iau, gama kis i sángul mai aru i kiskis án kabisit suri nagogon i sángul mai aru á mát til Israel. ");
INSERT INTO sgz_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Má di no dikte han alari kándi rum ngo rang tuá di ngo rang kuk di, ngo mám di mái kák di ngo rang nat di, má alari kandi tan pokon suri ngisang, da atur páptai marán mul, má liu áklis turán. ");
INSERT INTO sgz_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mái sár marán si di onin i liu minái di konom, namur da gengen. Má marán si di ái rung di gengen onin, i liu namur da pakta.” ");
INSERT INTO sgz_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Mái Iesu a sopasun kán worwor mák parai ngoromin, “Lolsit tilami bát a ngorer i kesi kálámul káián á numán wain, má i ngahwán kábungbung a han suri el pas te kálámul suri him i kán numán wain. ");
INSERT INTO sgz_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Má a nem sang suri hul di mai kesá pirán tabal ngorer i arul uri keskeskesá bung. Io, má tan tám him di mángát, má ngorer ák dos pala di suri him i kán numán wain. ");
INSERT INTO sgz_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Má namur kálámul er a han bul uri nián sirsira i asiu i pákánbung, má a mákái te kálámul kándi tu tur bia sár, ");
INSERT INTO sgz_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","mák parai si di ngo, ‘Gam mul erei gama han him i num kaiak má inak lain supan gam. ");
INSERT INTO sgz_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Io, dik han má suri him. Má i sángul mai aru á pákánbung má i atul á pákánbung mul, a tungai han el pasi tan kálámul suri him. ");
INSERT INTO sgz_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Ákte páput má suri alim á pákánbung má kálámul er a bali han uri nián sirsira má a mákái te kálámul di sámtur pagas iatung. Má a gálta di, ‘Suri dánih gam bibialol sár on á kunlán bung onin?’ ");
INSERT INTO sgz_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Má di kosoi kálámul er ngo, ‘Káplabin kápte kesi kálámul a el pas gim suri him.’ Má kálámul er a parai si di ngo, ‘Io, ngorer gama han him kaiak mul i numán wain.’ ");
INSERT INTO sgz_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Má i rahrah, kálámul er káián á numán wain a parai singin kán tám ololoh ngo, ‘Bin pas rung di him má, má unák hul di. Una tahnga di ngoro minái tákwái mai áwáwat ák han átik i rung er iau mulán long pas di. Má una hul di no keskeskes mai pirán tabal ngorer i arsupan uri kesá bung.’ ");
INSERT INTO sgz_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Má ngorer ái tám ololoh a turpasi hul di keskeskes mai pirán tabal ngorer arsupan uri kesá bung. ");
INSERT INTO sgz_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Má ngo tan kálámul di mulán el pas di di mákái ngo tan kálámul er di hut namur di top i arul arwat mai kesá kunlán bung, ngorer di hol on ngo da hul di sang mai arul pakta. Má ngo tan mulán kálámul di han top pasi kándi arul, dik mákái ngo kándi arsupan a artálár no sár mam rung di el pas namurwa di, ");
INSERT INTO sgz_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","má ngorer di ngurngurngur uri koner a kátlán i num. ");
INSERT INTO sgz_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Dik parai ngoromin, ‘Ái rung minái di mur i him, má gim gimáte lala him má nas a kekta bing gim. Ngádáh a ngoi má kángim arul no ák tukes on?’ ");
INSERT INTO sgz_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Má koner a kátlán i num erei a kos di ngoromin, ‘Rang buhang, káp iau te lawa pas gam! Gam sormángát suri arsupan uri kesá bung ngo na kesi pirán tabal sár. ");
INSERT INTO sgz_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Má erei gamáte kipi kamu arul. Gama lu hut má! Iakte nem suri tari singin kálámul a hut namur ngorer i kak nemnem sang, má ngorer iak tari kesi pirán tabal si gam no keskeskes. ");
INSERT INTO sgz_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","A nokwan suri ina tam purwai kak pirán tabal ngorer iau sang iau nem on. Kol gam bálsák kabin iau tari kes sár á matngan arul si gam no, be?’” ");
INSERT INTO sgz_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Mái Iesu a bontai worwor artálár er mák parai ngo, “Ái rung di konom onin i liu minái, namur da gengen. Mái rung di gengen onin, i liu namur da pakta.” ");
INSERT INTO sgz_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Mái Iesu di di lu hanhan tangrai sál urami Ierusalem, má namur a lam pasi sángul mai aru á kán kalik án aratintin uri risán alari matananu mák para kodongnai si di ngoromin, ");
INSERT INTO sgz_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Longrai, git han má urami Ierusalem á minái. Má ngorer bos pakpakta kán tan tám osmapak má bos tám mánán uri nagogon da top i Natun Kálámul má da nagogon on suri na mat, ");
INSERT INTO sgz_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","má da tari uri limán rung tili risán. Má dák tartar retret singin má dák rapis sáksáknai má dák up bingi. Má ngo na rah i atul á bung, na liu kaleng mul.” ");
INSERT INTO sgz_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Má namur, mámán ái Iakobo mái Ioanes, aru i natun ái Sebedaio, a purut si Iesu tiklik mai aru natun er má a dirtapul mák parai singin ngo, “Konom, inak sung iáu be.” ");
INSERT INTO sgz_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Mái Iesu a mákái ngorer má a gáltai ngo, “Dánih u nem on?” Má a sungi ngoromin, “I pákánbung una hut mai kam lolsit, tekes tili aru natung minái na kis tili balsán mingim má tekes tili balsán káisam.” ");
INSERT INTO sgz_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Mái Iesu a parai si diar tuán ngoromin, “Káp gaur te mánán á táit erei gaur sungi. Ngádáh? Gaur arwat ngo gaura ngin tili kinleh án rangrangas erei ina ngin til on?” Má diará parai singin ngo, “Giur arwat.” ");
INSERT INTO sgz_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Má namur ái Iesu a parai si diar ngo, “A muswan, gaura ngin tili kang kinleh. Ái sár suri kis i minging má káisang, káp ngo kaiak suri ngo ina tari. Káián sang ái Káláu Kakang. Ái na tari si rung er ákte eran páksi nián i di.” ");
INSERT INTO sgz_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Má namur sángul á kalik án aratintin di longrai ngorer ki dik togor i diar tuán. ");
INSERT INTO sgz_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Mái Iesu a mákái ngorer ki áng kilkila pas di uratung i narsán mák parai si di ngoromin, “Gam mánán i bos tátáil kándi ái rung tili risán, di lu kátlán i kándi matananu mai kándi rakrakai. Di lala apakta pas di má dik lu suka bámiai matananu. ");
INSERT INTO sgz_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mái sár á gam, kápte gama ngorer. Ngo tekes tili gam a nem ngo na pakta, na toptop be si gam. ");
INSERT INTO sgz_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Má kálámul a nem ngo na tátáil kamu, na toptop kamu no. ");
INSERT INTO sgz_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","A ngorer i Natun Kálámul, kápate hut suri kátlán i gam. A hut sár suri na toptop káián matananu, má suri sirai kán liu suri hul aliu pasi marán.” ");
INSERT INTO sgz_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Má namur ái Iesu mai kán bos kalilik án aratintin di han pas til Ieriko, má lala matananu di lu murmur i di. ");
INSERT INTO sgz_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Má aru rau diar lu kis iatung i risán sál. I pákánbung diar longrai ngo ái Iesu a láklák sorliu, diar lala bin ngo, “Iesu, á iáu natun ái Dewit! Una mámna giur!” ");
INSERT INTO sgz_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Má matananu di mos kalar diar má di parai si diar ngo diara kis pau. Mái sár diar lala bin sang urami bát ngo, “Konom, Natun ái Dewit, una mámna giur!” ");
INSERT INTO sgz_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Mái Iesu a longrai ngorer má a sámtur, má a kilkila pas diar uri narsán má ák gálta diar ngo, “Dánih gaur nem on ngo ina longoi mam gaur?” ");
INSERT INTO sgz_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Má diar parai ngoromin, “Konom, giur nem ngo una apádái mát giur má giurák mákmák.” ");
INSERT INTO sgz_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Má Iesu a mámna diar mák singli mát diar, má káp melek sár mul má a talas i mát diar, má diará aptur má diará mur i Iesu tangra sál. ");
INSERT INTO sgz_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Di lu hanhan páput ur Ierusalem artálár mai malar á Betepage, má dik hut i pungpung á Oliwa, mái Iesu a dos palai aru kalik án aratintin ");
INSERT INTO sgz_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","mák parai si diar ngoromin, “Gaura han uri malar imudi má gaura kusak on má káp melek mul gaurák mákái kesi gengen dongki di puta páksi tiklik mam mámán. Gaura pálás pasi aru dongki erei má gaurák lam diar ur main singing. ");
INSERT INTO sgz_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Má ngo tekes na gátna gaur ki gaura parai singin ngo, ‘Ái Konom na him mai besang’. Má ngo na longrai ngorer, na mángát melekna palai.” ");
INSERT INTO sgz_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Má táit minái a hut ngo na long arwat pasi worwor kán tám worwor tus er ák parai ngoromin, ");
INSERT INTO sgz_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Gama parai singin tan matananu til Saion ngoromin, ‘Mákái! Erei má ái kamu kabisit a han sur gam. A longoi tatalen án matau erei, má a kis i dongki. A kis i iátin kesi gengen dongki.’” ");
INSERT INTO sgz_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Má ngorer diará han má, má diará longoi ngorer ái Iesu ákte parai si diar. ");
INSERT INTO sgz_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Diar má lami aru dongki erei uri narsá Iesu, má diar má ulát pasi lusán i diar ki diar má pálsi i iátin aru dongki erei, mái Iesu a kis on. ");
INSERT INTO sgz_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Má marán mul di pálsi lusán i di tangra sál, má te di kot pasi pákán báibái má dik pálsi iatung i sál suri ák láklák on i dongki. ");
INSERT INTO sgz_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Má te di lu tátáilnai má te di lu murmur on má di lu wakwakwak ngoromin, “Huihui iá ur si natun ái Dewit! Ái Káláu na kuluk mam Koner a hut mai ngisán! Huihui iá sang urami!” ");
INSERT INTO sgz_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Mái Iesu a hut á Ierusalem, má matananu tilatung a pil i mansin i di má dik gátna ngo, “Ái sinih á kálámul minái?” ");
INSERT INTO sgz_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Má lala matananu er di láklák tiklik mam Iesu tangra sál dik para ngoromin, “Minái á tám worwor tus, ái Iesu til Nasaret i balis á Galiláiá!” ");
INSERT INTO sgz_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Má namur ái Iesu a kusak uri pelbut i rumán osmapak káián ái Káláu mák tipar palai bos kálámul di lu sirsira má bos kálámul di lu huhul iatung. A pukda sarai kándi bos suh ái rung di lu keles pirán tabal má kándi bos nián kis ái rung di lu sira man. ");
INSERT INTO sgz_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Má ák parai ngo, “Dikte le on i Buk Tabu ngoromin, ‘Kak rum da utngi mai rumán sung’, mái sár gamáte pukda pasi suri ák nián him káián bos tám siksikip.” ");
INSERT INTO sgz_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Má tan rung di rau mái rung a sák i kik di di han narsá Iesu urami rumán osmapak má ák aliu di. ");
INSERT INTO sgz_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Bos pakpakta kán tan tám osmapak má bos tám mánán uri nagogon di mákái bos lain táit er a longoi ái Iesu, má tan gengen kalilik dik lu kilkil ami rumán osmapak ngo, “Huihui iá ur si Natun ái Dewit!” Di mákái ngorer má dik mos i Iesu ");
INSERT INTO sgz_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","má ngorer dik gátnai ngo, “Kápute longrai á táit er di parai? Koion da parai ngorer!” Mái Iesu a kos di ngoromin, “Támin muswan iau longrai. Má gam ngádáh? Kápgamte lu longrai á kuir Buk Tabu er ák parai ngo, ‘Ái Káláu ákte atintini tan kalilik má tan goion kalik suri lain parpara agas na so tili ngus di!’” ");
INSERT INTO sgz_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ái Iesu a parai ngorer mák han alar di iatung má a kaleng ur Betani suri bop ái i libung er. ");
INSERT INTO sgz_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ákte arasa má, ki dik so kaleng til Betani urami Ierusalem, mái Iesu a matpám. ");
INSERT INTO sgz_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Má iatung i risán sál kesi aun tawan a tur. Ái Iesu a mákái ngorer mák han suri ngo na ser pas te wán nák ani, má kápte. Kápte be te wán, tu pákán masik. Mái Iesu a mákái ngorer mák parai singin aun tawan ngo, “Turpasi onin káp una te lu u mul!” Má káp melek sár má aun tawan a maulur. ");
INSERT INTO sgz_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tan kalilik án aratintin di mákái ngorer má dik sodar suri, má dik parai ngoromin, “Ngádáh a ngoi á aun tawan erei má káp melek sár mul ák marang?” ");
INSERT INTO sgz_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Mái Iesu a inau i di ngoromin, “Támin muswan iau parai si gam, ngo gama ruruna muswan má kápnate ru i kamu hol, ki gama long artálár pasi minái iakte longoi mai aun tawan erei. Má gama artálár mul suri parai singin pungpung min, ‘Una támrabut má unák han tur ada i lontas,’ má na longoi ngorer sár. ");
INSERT INTO sgz_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Má táit no gam sungi, gama ruruna sár, ki gama atur páptai sang.” ");
INSERT INTO sgz_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Io, má dik lu hanhan tangra sál ki dik hut á Ierusalem, má di kusak urami rumán osmapak, mái Iesu a lu aratintin iatung. Má bos pakpakta kán tan tám osmapak má te kálámul pakta di mákái má dik hut i narsán, má dik gátnai ngo, “Una parai si gim, sinih a dos pala iáu er uk longoi tan táit ngorer, mái sinih a tari nokwan erei singim?” ");
INSERT INTO sgz_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Mái Iesu a kos di ngoromin, “Má iau mul ina gálta gam. Ngo gama kos iau, ki á iau mul ina para koner a tari nokwan singing má iak longoi bos táit er mai. ");
INSERT INTO sgz_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Gam mánán ái Ioanes Tám Arsiu? Sinih a dos palai suri arbin má arsiu? Sinih a tari singin á him erei? Ái Káláu? Ngo a hut sang tili kán holhol sár?” Má dik nguruk arliu i di sang ngoromin, “Ngo gita parai ngo ái Káláu a tarwa Ioanes ur main, ki na parai ngo, ‘Suri dáh kápgamte ruruna i kán pinpidan?’ ");
INSERT INTO sgz_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Má ngo gita parai ngo káián sang ái Ioanes a hut tili kán hol sang, ki matananu da up git kabin di ruruna i Ioanes ngo ái á tám worwor tus káián ái Káláu.” ");
INSERT INTO sgz_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Má ngorer ding kos Iesu ngoromin, “Kápgimte mánán.” Mái Iesu a longrai ngorer mák parai si di ngo, “Á iau mul káp ina te parai si gam ngo ái sinih a tari nokwan singing má iak longoi bos táit minái.” ");
INSERT INTO sgz_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Mái Iesu a sopasun kán worwor singin bos pakpakta kán tan tám osmapak má tan kálámul pakta ngoromin, “Ngádáh má er gam hol on? Kesá kálámul aru i natun, aru káláu, mák han ur si mulán natun mák parai singin ngo, ‘Kauh, una han má unák him ami numán wain onin.’ ");
INSERT INTO sgz_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Mái natun a matai han mák parai si kákán, ‘Auh, iau matai han.’ Mái sár namur a kelsei kán hol má ák han uri numán wain. ");
INSERT INTO sgz_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Má namur kák diar a han uri narsán kalik mur mák parai mul singin ngorer ákte parai singin mulán natun, ngo na han uri numán wain suri him. Kalik mur er a longrai mák mángát suri na han, mái sár kápate han.” ");
INSERT INTO sgz_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Mái Iesu a gálta di ngo, “Sinih tili diar a taram mák longoi táit a parai ái kák diar?” Má ding kos Iesu ngo, “Ái koner mulán.” Má ngorer ái Iesu a ngoi si di ngo, “Támin muswan iau parai si gam, rung di lu kip takis má tan wák án sál da kusak táil i gam i lolsit si Káláu. ");
INSERT INTO sgz_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kabin tungu ái Ioanes Tám Arsiu a hut narsá gam má ák inngas tari si gam á sál a nokwan i mátán ái Káláu ngo gama mur on, mái sár kápgamte ruruna on. Támin, tohtohpas gamáte mákái, ngorer i rung di lu kip takis má tan wák án sál di ruruna on, má gamáte mákái. Mái sár á gam gam tu mákmákái sár má kápgamte hol kaleng má ruruna on.” ");
INSERT INTO sgz_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Mái Iesu a sopasun kán worwor uri narsá di ngoromin, “Gama longrai mul i kesi worwor artálár. Kesi kálámul a soi kesi numán wain mák áir kári mák longoi kesi tilik lus uri suir wain. A longoi mul i kesi rum, rum erei uri mákmák kári numán wain sang. A longoi ngorer ki ák tar páksi singin bos tám himhimna mák han alar di uri malar tepák. ");
INSERT INTO sgz_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Má namur ngo ákte arwat i pákánbung suri lus talmi wán wain, io a dos palai kán tan tám arardos suri kip te risán wán wain tili kán num. ");
INSERT INTO sgz_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Má ngo bos tám himhimna di mákái tan tám arardos erei di hut narsá di, di tola di má dik ubi kes, má kes mul dik sá bingi, má kes bul dik bás bingi mai hat. ");
INSERT INTO sgz_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Má namur kákán num a dos palai kán te tám arardos mul di kálik marán. Io, má bos tám himhimna di mákái tan tám arardos iatung má dik longoi matngan tatalen ngorer mam di mul. ");
INSERT INTO sgz_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Má namur kálámul erei a para ngoromin, ‘Ina dos palai sang i natung suri da rumrum on má kápdate ubi.’ Má ngorer ák dos palai natun. ");
INSERT INTO sgz_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Mái sár bos tám himhimna di mák pasi má dik worwor arliu i di ngoromin, ‘Mákái, erei mái koner na tur kelsen. Gita up bingi suri numán wain na ur kángit.’ ");
INSERT INTO sgz_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Má ngorer di tolai má dik sápka aso palai tilami numán wain má dik up bingi.” ");
INSERT INTO sgz_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Má ngo ái Iesu a arahi puksai worwor artálár erei, ki ák gátna di ngoromin, “Dánih má na longoi á kákán numán wain narsán tan tám himhimna i bung na purut kaleng?” ");
INSERT INTO sgz_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Di longrai ngorer má ding kos Iesu ngo, “Bung na purut kaleng ái kákán numán wain, kápnate mámnai bos tám himhimna er, na up bing di má nák tari numán wain ur singin tan lite tám himhimna di lain kálámul suri da tari risán wán wain singin kákán numán wain i bung na matuk.” ");
INSERT INTO sgz_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Mái Iesu a gátna kalengna di ngoromin, “Ngádáh, kápgamte wásái pinpidan minái tili Buk Tabu er a para ngoromin, ‘Hat erei bos tám long rum di pukpukwai, mái sár ái Káláu a aksimi hat erei suri áng kábutkis si di no á tan hat, má uri mát git a tuan kuluk taladeng.’ ");
INSERT INTO sgz_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Má ngorer iau parai si gam ngo ái Káláu na long palai kán lolsit alar gam má nák tari si rung da him pasi lain wán. ");
INSERT INTO sgz_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Má tara dáh da pur uri iátin hat erei da tu gingin sáksák. Má ngo hat erei na pur uri tekes, na ekesi sá peksai má nák mat.” ");
INSERT INTO sgz_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Má bos pakpakta kán tan tám osmapak má tan Parisaio di longrai ngorer má dik longra ilmi ngo ái Iesu a parai worwor artálár a arwat mam di sang, ");
INSERT INTO sgz_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","má ngorer dik nem suri kabat Iesu. Mái sár kápdite long arwat pasi kabin di bulat suri matananu er di ruruna i Iesu ngo ái á tám worwor tus. ");
INSERT INTO sgz_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Mái Iesu a atintini matananu mul mai worwor artálár mák parai ngo, ");
INSERT INTO sgz_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Lolsit tilami bát a ngorer i kabisit a mian i namnam án kila káián natun. ");
INSERT INTO sgz_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ákte mian no i boh táit ák wat, má ngorer a dos palai kán te tám arardos suri da el pasi tan kálámul suri da lákám má suri namnam. Mái sár kápte di taram má suri han. ");
INSERT INTO sgz_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Io, a bali dos palai te tám arardos káián mai worwor suri da bit rung er ngo, ‘Kak long namnam ákte eran, má bulumakau gimáte up bingi má boh táit ákte eran no. Gam lákám má suri namnam án kila!’ ");
INSERT INTO sgz_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Mái sár ái rung er worwor erei ákte sigil di, di hol sirereh on sár má dik mur sang i kándi tan talar. Kesá kálámul ák han uri kán num, má kesá kálámul bul ák han uri kán rumán sirsira, ");
INSERT INTO sgz_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","má te kálámul dik tolai tan tám arardos má di long bengta di ngorer má dik up bing di. ");
INSERT INTO sgz_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Má kabisit er a longrai worwor suri kán tan tám arardos má a lala togor. Má a dos palai kán boh tám arup dik han má dik up bingi boh kálámul er dikte up bingi boh tám arardos, má dik osoi kándi rum iatung i kándi malar ák bam. ");
INSERT INTO sgz_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Má namur kabisit er a bin pasi kán boh tám arardos mák parai narsá di ngo, ‘Kak long namnam án kila ákte eran má, mái sár tan kálámul iakte bit di, wa tan sápkin kálámul. Kápte di muswan, má ngorer kápdite artálár suri da kusak. ");
INSERT INTO sgz_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Má ngorer inái gama han tangrai sál, má sinih alatung gama banai, á di sár gama el pas di.’ ");
INSERT INTO sgz_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Io, boh tám arardos di han má di tangrai boh sál má dik bitái marán kálámul, tan lain kálámul má tan sápkin kálámul turán, má dik akángái rum. ");
INSERT INTO sgz_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Má kabisit a kusak suri mákái tan kálámul erei, má a mákái kesi kálámul iatung kápate oboi kán lain mermer. ");
INSERT INTO sgz_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Má kabisit a mákái kálámul er mák gáltai ngo, ‘Awái, turang, káp iáu te obop te lain mermer, má ngádáh u kusak ngoi ur main?’ Mái sár án kálámul er kápte worwor on sang. ");
INSERT INTO sgz_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Má namur kabisit er a parai narsán te tám arardos ngo, ‘Gama kápti limán má keken á kálámul minái má gamák buswa aso palai uradi pokon er a tuan kuron. Iatung má na tang má nák ararat ngis ái.’” ");
INSERT INTO sgz_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Mái Iesu a arahi kán worwor mák parai ngoromin, “Ái Káláu a kilkilai marán, mái sár tu án aru a ilwa pasi.” ");
INSERT INTO sgz_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Boh Parisaio di han má dik ngurkai sál arliu i di suri ngo da pidir pas Iesu mam te worwor. ");
INSERT INTO sgz_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Má namur di dos pala te bos Parisaio má te bos kálámul tili kiskis si Erodes má dik han uri narsá Iesu má dik gátnai ngoromin, “Tám Aratintin, gim talas ngo u lu parai támin muswan masik. Káksiái ngo ái sinih alatung a longra iáu, u lu para puri mát di mai muswan. Má kápute lu hol pasi mul ngo sinih á bos kálámul pakta má kandi bos kiskis. Kápte. U lu aratintin sár mai sál si Káláu. ");
INSERT INTO sgz_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Gim nem ngo una bit gim be. A mángát á kángit nagogon ngo gita tar takis ur si Kaisar, ngo kápte?” ");
INSERT INTO sgz_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ái Iesu a mákái má a mánán i kandi nemnem ngo da agur tari, mák parai si di ngo, “Gam á bos tám tuar, gam hol on ngo gama pidir pas iau? ");
INSERT INTO sgz_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Gam kip tekesi pirán tabal er gam lu hul takis mai ur main inak mákái.” Má di kip tari kes ur singin, ");
INSERT INTO sgz_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ki ái Iesu ák gátna di ngo, “Sinih á tantanián má ngisán á minái di le on?” ");
INSERT INTO sgz_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Má ding kos Iesu ngo, “Ái Kaisar.” Mái Iesu ák parai mul si di ngoromin, “A kuluk. Gama tari sang si Kaisar táit káián ái Kaisar, má táit káián ái Káláu gama tari sang si Káláu.” ");
INSERT INTO sgz_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Má di longrai ngorer má dik pángáng suri táit ái Iesu ákte parai uri di. Má dik aptur má dik han pas alari. ");
INSERT INTO sgz_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Má i bung erei sang, te á bos Sadukaio di han suri gálgálta i Iesu, di ái rung er kápdite ruruna ngo kálámul erei a mat na liu kaleng mul i liu namur. Di hut narsá Iesu ngorer má dik parai ngoromin, ");
INSERT INTO sgz_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Tám Aratintin, ái Moses ákte le i nagogon minái ur si gim. Ngo kálámul a mat alar kán wák má kápate kákáh ái kán wák singin, ái tuán na kila pasi bul i kán mokos suri nák mon i natun suri ngisán ái kákán na liu pagas sang. ");
INSERT INTO sgz_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","26","“Tungu ahit i aratuán di main i katbán i gim. Mulán i di a kila, má namur ák mat má kápte te natun be. Má ngorer kono áruán áng kila pasi bul i mokos, má káp melek mul ki ák mat má kápte besang te natun. Má ngorer mul ái kono átuil a mat má kápte natun. Má ngorer ahit no á aratuán er, di kila pasi kes sár á wák, má di no di mat alari má kápate mon i te nat di singin wák er. ");
INSERT INTO sgz_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Má namur má, wák mul a mat. ");
INSERT INTO sgz_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ki namur di no da liu kaleng i liu namur, sinih sang má tili di na kán wák muswan á wák erei, kabin ahit no di kila pasi?” ");
INSERT INTO sgz_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ái Iesu a kos di ngoromin, “A rogorogo i kamu hol kabin kápgamte mánán i worwor tili Buk Tabu má kán rakrakai ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Má er namur matananu da aptur kaleng alari minat, kápdate kila mul, da ngoro boh angelo imi bát. ");
INSERT INTO sgz_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“Gam ruruna ngo rung di mat kápte da liu kaleng. Má gam ruruna ngorer káplabin kápte gam talas suri pinpidan si Káláu er a parai ngo, ");
INSERT INTO sgz_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Iau á Káláu káián ái Abaram má Káláu káián ái Aisak má Káláu káián ái Iakop.’ Git talas ngo sálán kán worwor ái Káláu er ngo káksiai ngo dituláte mat má, ditul liu be má ditulá lu lotu uri narsán ái Káláu. Ái rung er di lu lotu uri narsán ái Káláu, káksiai ngo kápán páplun i di ákte mat, wa di á tan liuán kálámul sang.” ");
INSERT INTO sgz_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Má ngo tan kálámul di longrai kán aratintin er, di lala sodar suri. ");
INSERT INTO sgz_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Má tan Parisaio di longrai ngo ái Iesu ákte tur kári tan Sadukaio, má ngorer dik hut talum. ");
INSERT INTO sgz_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Má kes tili di, a tám mánán uri nagogon, ák han narsá Iesu suri na tohoi mai kesi argátna ngoromin, ");
INSERT INTO sgz_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tám Aratintin, arardos dáh a pakta si di no á bos nagogon?” ");
INSERT INTO sgz_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","38","Mái Iesu a kos kalengnai ngoromin, “Arardos er a pakta á minái. Una mámna Káláu kam Konom mai kunlán balam má mai taniam no má mai kam kunlán hol no. ");
INSERT INTO sgz_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Má áruán arardos er a pakta a ngoromin. Una mámna turam ngorer u mámna kalengna iáu sang. ");
INSERT INTO sgz_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Má tan nagogon no si Moses má bos aratintin kándi tan tám worwor tus a but pas tili aru arardos min.” ");
INSERT INTO sgz_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Io, má tan Parisaio di kis talum mam Iesu, má ái Iesu a gálta di ngoromin, ");
INSERT INTO sgz_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ngádáh má gam hol on sur Mesaia? Sumlahin ái sinih?” Má di kosoi ngo, “Ái Mesaia, ái á natun ái Dewit.” ");
INSERT INTO sgz_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Mái Iesu a parai si di ngo, “Ngo ngorer, ngádáh a ngoi má Tanián a Pilpil a tari sang á mánán si Dewit má ngorer ák utung Mesaia mai Konom? Ái Dewit sang a parai ngoromin, ");
INSERT INTO sgz_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ái Káláu a parai singin kang Konom ngo, “Una kis main i risán minging suri da árnga iáu, má iau ina suka bámiai kam tan kurtara uri lalin kikim má ina arumrum di.” ’ ");
INSERT INTO sgz_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ki ngádáh a ngoi ngo Mesaia a sumlahin ái Dewit má ái sár mul á kán Konom? A kabin ái Dewit a mák ilmi ngo Mesaia ákte kis má i pákánbung er. Ngorer a talas ngo Mesaia a sumlahin ái Dewit, má ái sár á kán Konom mul.” ");
INSERT INTO sgz_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Má kápte kesá kálámul a mánán pas tekesá kuir worwor ngo na kosoi mai. Má turpasi bung erei, kápte kes mul a mangan suri bali gálta Iesu. ");
INSERT INTO sgz_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Namur ái Iesu a atintini matananu má kán tan kalilik án aratintin mul mák para ngoromin si di, ");
INSERT INTO sgz_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Tan tám mánán uri nagogon má tan Parisaio a mon á kandi mánán suri atalsai nagogon si Moses singin matananu. ");
INSERT INTO sgz_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","A kuluk ngo gama mur i tan táit di parai si gam, mái sár koion gama mur on á kandi tatalen di longoi, káplabin ngo á di sang kápdite mur on á táit di arbin mai. ");
INSERT INTO sgz_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Di lu poklah pasi te nagogon mul uri bontai er ákte kis, má dik lu oboi uri káil matananu má ák lala taun di, mái sár kápte di kálik soai lim di ur on suri tangan di mai kándi kipkip. ");
INSERT INTO sgz_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Má bos táit di longoi di lu longoi sang suri matananu dák mákái sár. Tatalen er di mur on ngorer tan kuir worwor án Buk Tabu di kabat lul tengteng mai má ding kápti uri lim di, a kuluk. Ái sár di longoi kuán worwor bul ák pakta suri da mákái i matananu, má ngorer kándi tatalen a sák. Má tatalen er di mur on suri oboi nomnobon lusán i di suri akiláng i kándi hol páptai arardos káián ái Konom, a kuluk. Ái sár di longoi nomnobon bul ák lala dol suri da mákái i matananu, má ngorer kándi tatalen a sák. ");
INSERT INTO sgz_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Má di lu nem suri sukis i tan kiskis táil i rumán lotu, má i bos longsit di lu nem i sukis i kiskis erei matananu da rumrum i di ái. ");
INSERT INTO sgz_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Má di nem ngo matananu da lu árár pas di i pokon án sirsira má da lu utung di ngo ‘Tám Aratintin’. ");
INSERT INTO sgz_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Mái sár koion ngo gama utung gam mai ‘Tám Aratintin’ kápkabin gam aratuán sár, má tukesá Tám Aratintin kamu. ");
INSERT INTO sgz_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Má main i naul bim koion gama utung tekesi kálámul ngo kák gam. Kes masik sár á Kák gam, má a kis imi bát. ");
INSERT INTO sgz_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Má kápdate utung gam ngo gam tan kálámul pakta. Ákte mon á kamu kesi kálámul pakta, ái Mesaia masik sár. ");
INSERT INTO sgz_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ái koner a pakta si gam, na toptop kamu. ");
INSERT INTO sgz_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mái rung di apakta pas di sang, ái Káláu na agengen i di sár. Mái koner a agengen pasi sár, ái Káláu na apakta pasi sang.” ");
INSERT INTO sgz_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Mái Iesu a sopasun kán worwor uri narsá di ngoromin, “Gama tuan sák á gam á tan tám mánán uri nagogon má gam á tan Parisaio, gam tan tám tuar! Gam batbat i mátán sál i lolsit tilami bát da máng kusak on á matananu. Á gam sang kápgamte kusak, mái rung di kákir muswan suri kusak, kápgamte mángát pas di. ");
INSERT INTO sgz_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Gama tuan sák á gam á tan tám mánán uri nagogon má tan Parisaio, gam tan tám tuar! Gam lu agur pasi minsik kán tan mokos, má namur gamá lu angagur mai parai tara dolon sung. Má na lala sorliu á rangrangas ur si gam namur. ");
INSERT INTO sgz_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Gama tuan sák á gam á tan tám mánán uri nagogon má tan Parisaio, gam tan tám tuar! Gam lu polsai lontas má gam lu láklák tangrai bim ur tepák suri totor pasi kálámul suri na tur gam. Má i pákánbung gam long artálár pasi kálámul erei ák ngoro gam, wa ák sorliu gam mul mai sápkin tatalen er gam longoi! Má ngorer na sorliu mul i rangrangas na kipi er namur. ");
INSERT INTO sgz_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Gama tuan sák á gam er gam ngoro tátáil a rau, gamá parai ngoromin, ‘Ngo tekes na oror suri na longoi kesi táit, má na utngi ngisán rumán osmapak suri kápti kán oror erei, ki gamá parai ngo ngisán rumán osmapak kápate rakrakai artálár suri kápti kán oror, má ngorer a tu táit bia sár á kán oror. Mái sár ngo tekes na oror má na utngi tan táit imi sang i rumán osmapak, tan táit er di longoi mai gol, ki gamá parai ngo erár ák dik má i kán oror má ngorer na long muswan on sang.’ ");
INSERT INTO sgz_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Wa gam tilik ngul má a rau i mát gam! Dánih sang a pakta, rumán osmapak ngo tan táit imi rumán osmapak? Ngo táit er kápnate kis i rumán osmapak, na tu táit bia sár. Mái sár rumán osmapak a pilpil, má ngorer a apilpil pasi táit a kis imi. Má ngorer rumán osmapak a pakta i di no á tan táit a kis imi polgon. ");
INSERT INTO sgz_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Má kesi táit mul gam lu parai a ngoromin. Ngo tekes na oror suri na longoi kesi táit má na utngi nián osmapak suri kápti kán oror, ki gamá parai ngo nián osmapak kápate rakrakai artálár suri kápti kán oror, má ngorer a tu táit bia sár á kán oror. Mái sár ngo tekes na oror má na utngi artabar di osmapak mai, ki gamá parai ngo erár ák dik má i kán oror má ngorer na long muswan on sang. ");
INSERT INTO sgz_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Wa gam tan rau er! Dánih sang a pakta, nián osmapak ngo artabar di osmapak mai? Ngo táit er di artabar mai, ngo kápate kis i nián osmapak, na tu táit bia. Mái sár nián osmapak a apilpil pasi artabar er ák pilpil, má ngorer nián osmapak a pakta alari artabar a kis on. ");
INSERT INTO sgz_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","“Ngorer ngo tekes na oror mai nián osmapak, ki a oror no mai nián osmapak sang má tan táit no a kis on. ");
INSERT INTO sgz_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Má ngorer mul ngo tekes na oror mai rumán osmapak, ki a oror sang mai rumán osmapak má mam Koner a lu mon iatung. ");
INSERT INTO sgz_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Má ngoromin mul, ái koner a oror mai naul bát, ki a oror mul mai nián kiskis si Káláu má mam Káláu sang, koner a lu kis ái. ");
INSERT INTO sgz_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Gamáte sák á gam á tan tám mánán uri nagogon má tan Parisaio, gam tan tám tuar! Kabin gam lu mur arwat pasi tan gengen táit no tili nagogon, mái sár tan támin táit muswan, kápgamte lu mur on. Ngorer gam lu tabar Káláu mai risán i kamu tan lobo má kamu tan mánáp mul, mái sár gam matai suri mur i tatalen a arkip má tatalen án armámna uri narsán matananu má suri ruruna i Káláu. A kuluk gamáte mur arwat pasi tan gengen táit i nagogon, má ngádáh á tan támin táit erei? Koion gama hol pala tekes tili di, gama mur i tan támin táit mul. ");
INSERT INTO sgz_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Gam tan rau kabin gam lu kebeptai tan gengen táit suri gama longoi, mái sár nagogon pakta si Káláu, kápgamte lu mur on. A ngoro gam lu long palai lang tili amu dan, mái sár kamel gam lu konam aliwai sár! ");
INSERT INTO sgz_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Gamáte sák á gam á tan tám mánán uri nagogon má tan Parisaio, gam tan tám tuar! Gam ngorer i rung di lu gorsai tan kinleh má kuro tili karpala sár, má dik lu páksiai dur imi polgon. Gam lu long arwat pasi bos tatalen án arapilpil tili karpala suri gama mák nokwan uri mátán matananu, mái sár imi bál gam a káng mai tan sápkin holhol má tatalen án kiu. ");
INSERT INTO sgz_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Gam á tan Parisaio gam rau. Gamáte mánán má i gorsai polgon kamu tan kinleh má kuro. Má ngorer gama lu anokwai mul i bál gam pasi gamák pilpil no i mátán ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Gamáte sák á gam á tan tám mánán uri nagogon má gam á tan Parisaio, gam tan tám tuar! Gam ngoro tan tarang er di lu dungi minat on. A tuan pilpil tili karpala kabin di sámri mai kabang mák tuan bal, mái sár imi polgon a káng mai tuán buli má sangnán minat. ");
INSERT INTO sgz_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","A ngorer sár mul á kamu tan tatalen. Matananu di mák gam ngo gam tám nokwan, mái sár imi nárum i gam a tuan káng mai abulbul má mai tatalen kán tám tuar. ");
INSERT INTO sgz_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Gamáte sák á gam á tan tám mánán uri nagogon má gam mul á tan Parisaio, gam bos tám tuar! Gam lu lain longoi sang á tan nián minat káián tan tám worwor tus, má gamá lu merei tan tarang kán tan kálámul er di tám nokwan. ");
INSERT INTO sgz_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Má gamá lu parai ngo, ‘Ngo gimá han liu tungu er di liu i rang kámpup gim, kápte gima longoi ngorer di longoi mai tan tám worwor tus er di up bing di.’ ");
INSERT INTO sgz_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Gam parai ngorer má ngorer gamá para tus gam sang ngo gam á tan rang buh di ái rung di up bingi tan tám worwor tus. ");
INSERT INTO sgz_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Áá, rang kámpup gam dikte turpasi má i him er! Má gam mul gam han má! Gamák arahi be him er di longoi i rang kámpup gam. ");
INSERT INTO sgz_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Gam tan kanih má gam natun kanih sáksák mul! Ngádáh gama ngoi má gamák elai nagogon án hiru áklis? Wa kápte sang! ");
INSERT INTO sgz_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Má suri gama talas suri rangrangas na pur uri ngaul matananu onin, ngorer ina parai si gam ngoromin. Ina tarwa palai tan hutngin tám worwor tus má tan tám mánán má tan tám aratintin. Te tili di gama up bing di, má te gama bás pápta di iamuni páspáng, má te mul gamák rapis di iatung i kamu bos rumán lotu má gamák tipar sara di tili kamu tan malar. ");
INSERT INTO sgz_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Má ina tarwa palai tan kálámul erei suri wán kamu sápkin tatalen na tur talas má suri rangrangas tili dár di na duk i gam. Má kápte ngo tan kálámul minái sár gama áslai rangrangas suri dár di. Kápte sang! Gama tur i rangrangas mul suri dárán tan tám nokwan no turpasi tili Abel er a mulán hiru ák han pang i Sakaria natun ái Barakia, koner di up bingi iatung i arliwán rumán osmapak má nián osmapak. ");
INSERT INTO sgz_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","A muswan iau parai si gam, rangrangas suri dárán tan tám nokwan er na duk i ngaul matananu onin.” ");
INSERT INTO sgz_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Mái Iesu a parai mul si di ngoromin, “U, tara Ierusalem, ái Káláu ákte dos palai tan tám worwor tus káián ur si gam má gamá up bing di má tan tám arbin mul gamá bás di mai hat. Marán pákán sang iau nem i gam á matananu til Ierusalem suri ina lu pam talum gam ngorer i kok a iang talmi rang natun uri lalin bábán, mái sár á gam kápgamte nem i iau. ");
INSERT INTO sgz_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","A muswan á minái iau parai si gam, kamu malar er gam lu kis ái, na mosrah no. ");
INSERT INTO sgz_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Má iau sang mul ina bokoh alar gam. Káp gama tini mák iau mul pang i bung ngo gama parai ngoromin ngo, ‘Ái Káláu na kuluk mam Koner a hut mai ngisán!’” ");
INSERT INTO sgz_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Má namur ái Iesu a so alari rumán osmapak, má kán tan kalilik án aratintin di parai singin suri na ilang kaleng má nák mákái tan rum on á rumán osmapak. ");
INSERT INTO sgz_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ái Iesu a longrai ngorer má ák parai ngo, “Áá, gam mákái á bos táit imuni? A muswan iau parai si gam ngo kápte kesá hat na lu kis i nián, na pospos no má na purpur ur main i bim. Bos kurtara da hut má dák amosrah noi.” ");
INSERT INTO sgz_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Mái Iesu a tapam urami pungpung á Oliwa mák sukis pagas. Má namur tan kalilik án aratintin di han má dik gátna kodongnai ngoromin, “Awái, Tám Aratintin, unák bit gim be á iáu suri tan táit minái. Enges na hut, má dánih á akiláng gima mákái suri mák ilmi ngo kam purpurut kaleng ur main a páput má suri na rah i kuir pákánbung inái git liu on?” ");
INSERT INTO sgz_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Mái Iesu a parai si di ngoromin, “Gama ololoh kuluk suri koion á tekes na agur gam. ");
INSERT INTO sgz_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kabin marán da hut má da arbin mai ngisang má dák parai ngo, ‘Á iau á Mesaia,’ má da lam bengtai marán. ");
INSERT INTO sgz_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Koion gama ráuráuwas suri kaungán tan táit án arup gama longrai er páput, má koion gama ráuráuwas i arbin suri arup gam longrai iamunang tepák. Tan táit er na hut sang, má kápte besang á arahrahi. ");
INSERT INTO sgz_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Má kesi matananu na aptur má nák arup mai kesi matananu sang. Má bos mát mul ngoi, kesi mát na aptur má nák arup mai kesi mát sang. Marán kunkun má taul itol mul na hut arkaliut i te tan balis. ");
INSERT INTO sgz_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tan táit erei na hut, ái á mátmátán sár á rangrangas ngorer i rangrang a hut singin wák er a eran suri kákáh. ");
INSERT INTO sgz_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Má namur da tola gam má kabat pas gam, má ngorer da kip gam uri rumán batbat kalar má dák up bing gam. Má bos matananu no da mikmikwa gam káplabin sur iau. ");
INSERT INTO sgz_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Má i pákánbung er, marán tili gam na pur i kandi ruruna má dák agur tar te, má dák mikmikwa arliu i di. ");
INSERT INTO sgz_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Má namur marán angagur án tám worwor tus da tapam hut má lam bengtai marán. ");
INSERT INTO sgz_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Sápkin na lala maras taladeng, má ngorer armámna i bál matananu nák gáwár. ");
INSERT INTO sgz_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Mái sár kono a tur rakrakai pang i arahrahi, ái Káláu na aliwi sang. ");
INSERT INTO sgz_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Má mulán, gama lu arbin mai lain arbin suri lolsit tilami bát, suri matananu on á naul matmatngan pokon da talas ur on. Má namur na hut i arahrahi.” ");
INSERT INTO sgz_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Mái Iesu a sopasun kán worwor uri narsán kán kalilik án aratintin ngoromin, “Má gam er gam wásái worwor minái, a kuluk ngo gama talas suri sálán á táit minái ái Daniel tám worwor tus a arbin táil suri. A ngoromin. Namur gama mákái táit a tuan sák na long adurwán rumán osmapak. Táit er na hut má náng kis i pokon er kápate nokwan ngo na kis ái. Mái Káláu na mákái ngorer pasi kápnate kis be i rumán osmapak. ");
INSERT INTO sgz_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Má ngo gam á tan Iudáiá gama mákái táit erei, gama táu uramuni pungpung. ");
INSERT INTO sgz_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ái koner ngo na iatung i lol malar, kápnate kusak mul uri kán rum suri kip kán te táit. Na tu táu sár. ");
INSERT INTO sgz_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Má kálámul erei a him i kán pokon, kápnate kaleng uri kán rum sur kán te bobor. Na tu táu sár. ");
INSERT INTO sgz_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Keskam singin tan wák erei di tián mái rung di kis tinánkak mai goion kalik. ");
INSERT INTO sgz_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Gama sung Káláu suri koion gama táu i taul gáwár ngo i bungán aunges. ");
INSERT INTO sgz_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Lala rangrangas er na hut i pákánbung erei, ái na sorliwi tan rangrangas no turpasi tili tangkabin i akaksim nák han pang onin, má kápte kesi táit mul na ngorer namur. ");
INSERT INTO sgz_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Má ngo na lala dol i pákánbung er, ki da han mat no. Mái sár ái Káláu ákte put aruái á pákánbung. A hol pasi bos tám ruruna er ákte ilwa pas di, ki ák put aruái pákánbung er kabin sur di. ");
INSERT INTO sgz_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Má ngo tekes na parai si gam, ‘Mákái, minái má á Mesaia,’ ngo ‘Ái sang á Mesaia,’ koion gama longra pasi má ruruna on. ");
INSERT INTO sgz_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kabin tan bos angagur án Mesaia má bos angagur án tám worwor tus da hut má da longoi tara akiláng, má matananu da mákái má da pángáng on. Ái rung er da tohoi suri lam bengtai matananu si Káláu er ákte ilwa pas di sang, mái sár káp sang da te arwat. ");
INSERT INTO sgz_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Iakte para noi si gam á bos táit er kápate hut besang. ");
INSERT INTO sgz_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Má ngorer ngo di parai si gam ngo, ‘Alami bos ái Iesu,’ ki koion gama han mákmák suri. Má ngo di parai ngo, ‘Imi rum ái,’ koion gama ruruna on. ");
INSERT INTO sgz_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Má kalkaleng káián Natun Kálámul na ngorer sár i talsán pil a talas tilamunang i kesá kuir armongoh uramudi kesá kuir. ");
INSERT INTO sgz_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Erei ngo gama mákái tan wokwok di roh má dik han roh sukis ái, alatung i pokon er á minatin táit. Na mon mul i akiláng ngorer suri para tusi ngo erei má táit na tapam hut.” ");
INSERT INTO sgz_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Mái Iesu a sopasun mul i kán worwor uri narsán kán kalilik án aratintin ngoromin, “Má namur, ngo ákte rah i pákánbung án rogorogo, mátán nas na kuron, má kalang mul kápnate pos. Tan mátmátiah da lu purpur tilamuni naul bát, má tan táit a mon i rakrakai i di iamuni armongoh, da dikdikdik ngorer i kunkun a gunra di. ");
INSERT INTO sgz_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ki erár da mákái akiláng káián Natun Kálámul na hut iamuni armongoh. Má ngo da mákái ngorer, matananu no on á naul matmatngan pokon da ráuráuwas má dák tang. Má da mákái Natun Kálámul na hut soura tili kumlán mehmeh tiklik mai kán rakrakai má mai tilik minmáir mul. ");
INSERT INTO sgz_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Má taur na lala tang sang, má Natun Kálámul na dos palai kán tan angelo uri ahat i mátán kihkih main i naul bim suri iang talmi tan kálámul er ái Káláu ákte ilwa pas di.” ");
INSERT INTO sgz_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Mái Iesu a parai mul si di ngo, “Gama kip aratintin tili aun rarah. Ngo rarah a oboi hutngin pákán mák oboi mul i sián, ki gita mák ilmi ngo ákte páput má á taul ráin. ");
INSERT INTO sgz_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Má ngorer sár mul, ngo gamáte mákái tan táit erei ákte lu huthut, ki gama mánán ngo Natun Kálámul ákte páput má, erei sár má i mátán kas ái. ");
INSERT INTO sgz_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Támin muswan iau parai si gam, ngaul matananu minái kápdate mat besang má nák tapam hut á tan táit erei. ");
INSERT INTO sgz_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Naul bát má naul bim na bokoh, mái sár kak pinpidan kápnate pah.” ");
INSERT INTO sgz_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Mái Iesu a sopasun i kán worwor mul uri narsá di ngoromin, “Kápte kes a mánán i bung ngo pákánbung na hut i Natun Kálámul on. Boh angelo imi bát kápdite mánán, má Natun sang mul kápate mánán. Ái Kákán masik sár a mánán. ");
INSERT INTO sgz_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Má pákánbung káián Natun Kálámul na ngorer sár i bung hirá ái Noa má rang natun di kusak uri tilik mon. ");
INSERT INTO sgz_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","39","I tan bung til tungu ák pang i bung a tibin mák lámán i naul matmatngan pokon, matananu di lu namnam sár má dik lu ngin má dik lu kila mul, mái sár kápdite mákái táit er na hut. Kandi tu taltaladeng sár pang i bung er ái Noa a kusak uri tilik mon, má ngorer tilik tibin a hut má ák sanra palai matananu má dik bokoh. Má na ngorer mul i bung Natun Kálámul na hut on. ");
INSERT INTO sgz_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","On á bung erei, ngo na ru i kálámul diara him tiklik ami bos, kesá turán na bokoh má kes nák lu kis iatung. ");
INSERT INTO sgz_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Má ngo na ru i wák diara ioh tiklik iatung i kesá goson sár, kesá turán na bokoh má kes masik sár nák lu kis iatung. ");
INSERT INTO sgz_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Má ngorer gama ololoh kuluk kabin kápgamte mánán i pákánbung na hut ái kamu Konom. ");
INSERT INTO sgz_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Gama mánán ngoromin ngo kálámul a mon i kán rum má ákte mánán i kuir libung er na hut on i tám siksikip, io arwat suri na eran monai tám siksikip, má ngorer kán rum kápnate sák. ");
INSERT INTO sgz_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Io, ngorer gam mul gama eran suri Natun Kálámul, kabin na hut sang i pákánbung ngo kápgamte hol on ngo na hut on.” ");
INSERT INTO sgz_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Mái Iesu a sopasun kán worwor uri narsán kán kalilik án aratintin ngoromin, “Pákánbung kálámul pakta a eran suri na han uri lite malar, a ser suri kán tekesi tám arardos na kátlán i kán rum. Má matngan kálámul ngádáh a nem on ái pakpakta erei? A nem i kálámul a tám mánán má a lu muswan suri ololoh i kán rum turán rung di lu kis on, má suri tabar di mai namnam. ");
INSERT INTO sgz_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Namur a kaleng i pakpakta erei má a mákái ngo kán tám arardos erei a long arwat pasi tan táit no kán konom ákte parai singin. Má ngorer a tuan kuluk pala á tám arardos er. ");
INSERT INTO sgz_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","A muswan iau parai si gam, pakpakta erei na mákái ngorer, má nák tari singin kán tám arardos á bos táit no suri kátlán. ");
INSERT INTO sgz_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mái sár ngo tám arardos erei, ngo kápate muswan uri narsán kán konom ngorer, na hol pasi sápkin ami bál má nák parai singin sang ngoromin, ‘Kak pakpakta ákte han tepák má kápnate kaleng melek.’ ");
INSERT INTO sgz_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Má ngorer na turpasi ubi tan toptop sang, má na lala namnam má nák lala ngin i dan rakrakai tiklik mai tan rung di lu ngin. ");
INSERT INTO sgz_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Má namur i tekesi bung má, pakpakta erei na kaleng. Má i pákánbung na kaleng on, kán tám arardos er kápnate mánán on má kápnate eran monai. ");
INSERT INTO sgz_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ngorer má pakpakta na mákái tám arardos er a longoi ngorer má nák mos on, má na lala ubi má na oboi suri na áslai rangrangas tiklik mam rung kápdite lu muswan uri narsán kándi tan konom. Iatung i pokon er di lu tang má dik lu ararat ngis ái. ");
INSERT INTO sgz_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Mái Iesu a sopasun mul i kán worwor mák parai ngoromin, “I bung er, lolsit tilami bát na ngoromin. Bungán arakila kán aramokson ákte hut. Má i libung on, sángul á wák, tan tahlik sang, di kipi kandi tan lam má dik han suri kis monai kálámul na kila na hut mai kán wák má mam rung da han tiklik mam diar i pákánbung da láklák kaleng urami rum káián kálámul suri namnam án kila. Má sángul á tahlik erei di no da tiklik má. ");
INSERT INTO sgz_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Má alim tili sángul á wák er di ngul, má alim di tám mánán. ");
INSERT INTO sgz_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","4","A mon i karasin i kándi tan lam no. Má i rung er di tám mánán di kipi mudán karasin mul uri nanau i di. Mái sár alim á wák er di ngul di kipi kandi tan lam masik sár, má kápte di kip te karasin mul. ");
INSERT INTO sgz_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Mái sár kálámul er a kila kápate hut melek, má tan wák er ngo di suám ki dik boptin má. ");
INSERT INTO sgz_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ákte katbán libung sang má, má dik bin ngo, ‘Er má kálámul a kila! Gam lákám má gamák mákái!’ ");
INSERT INTO sgz_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Má sángul á wák er di pán má dik tinrai kandi tan lam. ");
INSERT INTO sgz_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Má alim á wák er di ngul di tinrai kandi lam má pátum na rah i kandi karasin. Má ngorer dik sungi alim á wák er di tám mánán sur kandi te karasin. ");
INSERT INTO sgz_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Má alim á wák di tám mánán di ruti kandi karasin má dik parai ngo, ‘Kápate arwat mam gam má gim mul á minái. Gam han hul te ur kamu.’ ");
INSERT INTO sgz_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Má ngorer alim á wák er di ngul di han má dik hul karasin. Má pákánbung di han suri hul karasin, kálámul a kila a tapam hut tiklik mai rang turán. Má alim á wák er dikte eran kuluk, di kusak mam di suri long namnam án kila. Má namur mátán sál a batbat. ");
INSERT INTO sgz_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Má namur alim á wák di kaleng má di mákái ngo dikte batbat i mátán sál, io dik lu binbin ngo, ‘Konom, pasbat sur gim!’ ");
INSERT INTO sgz_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mái sár a kos di ngoromin, ‘Auh, wa iau parai muswan, káp iau te mánán i gam.’ ");
INSERT INTO sgz_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Ngorer má gama ololoh kuluk kabin kápgamte mánán i bung má pákánbung er Natun Kálámul na hut on.” ");
INSERT INTO sgz_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Mái Iesu a sopasun mul i kán worwor uri narsán kán kalilik án aratintin ngoromin, “Pákánbung Natun Kálámul na hut a ngorer i kesi kálámul a han uri malar tepák. A bin talmi kán tan tám arardos uri narsán mák tari kán minsik uri lim di suri da ololoh on. ");
INSERT INTO sgz_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Má kálámul er a mánán i kán tan tám arardos no. Má ngorer a tam purwai kán te pirán tabal si di suri nák arwat mai kándi mánán suri da him mai. Kesá kálámul a tari alim i arip á kepwen pirán tabal gol singin, má kes a tari aru i arip singin, má kesá tur ditul a kipi sár i kesi arip. A longoi ngorer mák han pas. ");
INSERT INTO sgz_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ákte han má, má káp melek sár tám arardos er a kipi alim i arip ák han him mai, ki áng kipi mul i alim i arip á kopkobon tili mulán pirán tabal. ");
INSERT INTO sgz_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Má kálámul er a kipi aru i arip a longoi ngorer mul má áng kipi aru mul. ");
INSERT INTO sgz_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mái sár kono a kipi kesá arip sár, a kip pasi pirán tabal er káián kán pakpakta mák han mai. Ák ili bim ngorer mák punmai adi polgon bim na mák rong singin. ");
INSERT INTO sgz_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Namur ákte dol má i pákánbung, kándi tátáil a kaleng, má a nem ngo na anokwai tan pirán tabal er a tari si ditul. ");
INSERT INTO sgz_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Má tám arardos a top i alim i arip a tapam hut mák tari alim mul i arip a him pasi mák parai ngo, ‘Konom, ukte tari alim i arip singing. Má mákái, iau him mai má áng kipi alim i arip mul.’ ");
INSERT INTO sgz_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Má kálámul erei a mákái ngorer mák parai singin tám arardos erei ngo, ‘A kuluk taladeng. Iáu lain tám arardos sang. Ukte muswan suri longoi gengen talar erei, má ngorer ina tari tilik talar singim. Lákám, una kusak má giták laes tiklik.’ ");
INSERT INTO sgz_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Má namur a kusak i tám arardos er a top i aru i arip á kepwen pirán tabal má ák parai singin kabisit er ngo, ‘Mákái, konom, iáu tari aru i arip singing, má min mul á aru i arip iau himna pasi.’ ");
INSERT INTO sgz_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Má kálámul a parai ngo, ‘Kuluk taladeng. Iáu lain tám arardos sang. Ukte muswan suri longoi gengen talar erei, má ngorer ina tari tilik talar singim. Lákám, una kusak má giták laes tiklik.’ ");
INSERT INTO sgz_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","25","“Mái koner a top i kesi arip a hut i narsán mák parai ngoromin, ‘Konom, minái sár á kam pirán tabal. Iau mátut na mák rong i kam pirán má iang kas tahni i bim, kabin iáu tuan songap. Kam tan minsik kápte ngo iáu u lu himna pasi sang. Auh, iáu konom mai tan táit bos lite kálámul di himna pasi.’ ");
INSERT INTO sgz_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Má kálámul a parai singin tám arardos er ngo, ‘Iáu tám merok má iáu sápkin kálámul sang. U mánán ngo iau tuan songap má kak tan minsik kápte ngo iau lu himna pasi sang, ái sár iau konom mai tan táit bos lite di himna pasi. ");
INSERT INTO sgz_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ngorer ki suri dánih kápute oboi kak pirán tabal i rumán pirán tabal? Má ngorer minái má iakte kaleng, ina top kalengnai á pirán tabal er mam te pirán mul urami iátin.’ ");
INSERT INTO sgz_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Má namur a parai singin tan kálámul di sámtur pagas iatung ngo, ‘Gama long pasi alari á pirán tabal erei má gamák tari si koner a top i sángul i arip á pirán tabal. ");
INSERT INTO sgz_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ái koner a atur páptai marán má a lu him mai, na kipi marán mul má kápnate sáhár. Mái sár koner a atur páptai mudán sár, má kápate lu him mai mudán er a top on, namur na bokoh alari á mudán er singin. ");
INSERT INTO sgz_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Má suri tám arardos min kápate him kuluk, gama buswa palai uramudi pokon er a tuan kuron. Iatung i pokon er di lu tang má dik lu ararat ngis ái.’ Má á gam, gama lu him kuluk i pákánbung iau bokoh alar gam gama káp ngorer i tám arardos minái.” ");
INSERT INTO sgz_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Mái Iesu a paptauni kán worwor ngoromin, “Pákánbung na hut i Natun Kálámul, a kabisit sang, má na hut mai minmáir má tan angelo no da tiklik mai. Má na kis i kán kiskis a tuan alal imi naul bát. ");
INSERT INTO sgz_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Má tan matananu án naul matmatngan pokon da hut talum i narsán. Má namur nák purwai matananu ngorer i tám ololoh sipsip a lu tim purwai sipsip alari me. ");
INSERT INTO sgz_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Má tan tám nokwan na obop di uri mingin má tan tám abulbul uri káisán. ");
INSERT INTO sgz_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Na be rah ngorer, ki nák sap mái kabisit nák ngoi singin matananu erei i mingin ngo, ‘Gam lákám á gam, ákte asosah i gam ái Tata! Gam lákám gamák otoi singin á lolsit tilami bát, lolsit er ákte eran páksi sur gam hirá i pákánbung a aksimi naul matmatngan pokon. ");
INSERT INTO sgz_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Gam lákám gamáng kusak kabin i pákánbung ngo iau matpám má, uk tabar iau. Má iau sák suri dan, u tari singing. Iau hut án asir, uk akusak iau i kam rum. ");
INSERT INTO sgz_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Má ngo iau kunsin, uk asulu i iau. Iau sasam, uk ololoh i iau. Má iau kis i rumán batbat kalar, u han mák iau.’ ");
INSERT INTO sgz_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Má tan tám nokwan da longrai ngorer má da gáltai ngo, ‘Konom, anges gim mák iáu ngo u matpám má gimá tabar iáu? Má ngo u sák suri dan má gimá tari? ");
INSERT INTO sgz_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Má anges gim mák iáu ngo iáu asir má gimá long pas iáu, má ngo u kunsin má gimá asulu i iáu? ");
INSERT INTO sgz_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Má anges u sasam má ngo u kis i rumán batbat kalar má gimá han laum iáu?’ ");
INSERT INTO sgz_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Má kabisit na kosoi ngo, ‘A muswan iau parai si gam, i pákánbung gam artabar uri narsán rang buhang er di sáhár, wa kápte gam longoi uri narsá di masik, gam longoi mam iau sang mul á ngorer.’ ");
INSERT INTO sgz_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Má namur nák parai si rung er di kis i káisán ngo, ‘Gam han alar iau, ákte wás pala gam ái Káláu. Gama han uri kámnah a inan áklis er ái Káláu ákte eran on uri Satan má kán tan sápkin angelo. ");
INSERT INTO sgz_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Gam kaplah alar iau káplabin i pákánbung ngo iau matpám, kápgamte tabar iau. Má iau sák suri dan, kápgamte akngim iau. ");
INSERT INTO sgz_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Iau hut án asir, má kápgamte long pas iau uri kamu rum. Má ngo iau kunsin, kápgamte asulu i iau. Má iau sasam má iau kis i batbat kalar, kápgamte mák iau.’ ");
INSERT INTO sgz_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Má tan tám abulbul da kosoi ngoromin, ‘Konom, anges gimáte mák iáu ngo u matpám ngo u sák suri dan ngo u hut án asir ngo u kunsin ngo u sasam ngo u kis i batbat kalar, má kápgimte tangan iáu?’ ");
INSERT INTO sgz_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Má kabisit na kos di ngoromin, ‘A muswan iau parai si gam, i pákánbung gam mákái tan sáhár er má gam matai artangan uri narsá di, a duk i iau mul er, má ngorer kápgamte tangan iau.’” ");
INSERT INTO sgz_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Mái Iesu a arahi kán worwor ngoromin, “Ái rung minái tan tám abulbul, da han uri rangrangas áklis, má tan tám nokwan uri liu áklis sang.” ");
INSERT INTO sgz_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Io, ákte rah má kán aratintin ái Iesu, má namur a parai singin kán bos kalilik án aratintin ngo, ");
INSERT INTO sgz_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Gamáte talas ngo aru sár má bung suri akiláng i bungán longsit án sorliu palai. Má Natun Kálámul da tari uri limán bos kálámul suri da bás páptai uri kubau kus.” ");
INSERT INTO sgz_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Má bos pakpakta kán tan tám osmapak má bos kálámul pakta til Iudáiá di hut talum iatung i rum si Kaiapas tám osmapak táil. ");
INSERT INTO sgz_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Kándi tu ser sál suri da tola kodongna Iesu suri da up bingi. ");
INSERT INTO sgz_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Má ngorer dik parai ngo, “Koion gita tolai i bungun longsit da káp togor i matananu má dák apturi tilik arup.” ");
INSERT INTO sgz_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ái Iesu má kán kalilik án aratintin di han ur Betani má di kusak i rum si Saimon er a sami lepra tungu, má dik namnam. ");
INSERT INTO sgz_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Kándi tu namnam besang, má kesi wák a hut mai átbán wel di longoi mai hat, má wel erei lain wel a tomtom má a pakta sang i mátán. Má wák er a tok puri átbán mák urai wel uri lul ái Iesu. ");
INSERT INTO sgz_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Má tan kalilik án aratintin iatung di mákái ngorer má dik mos má dik parai ngoromin, “Suri dáh a omlawai lain wel erei? ");
INSERT INTO sgz_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Wel erei a arwat suri da sirai pasi lala mámát án pirán tabal suri tángni tan sáhár.” ");
INSERT INTO sgz_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Mái Iesu a longrai ngorer ki ák parai si di ngoromin, “Suri dáh gam soksokoi? Gama káksiai sár. Ái sang a longoi lain táit uri narsang. ");
INSERT INTO sgz_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Tan sáhár di erei narsá gam áklis. Mái sár á iau káp ina te kis áklis narsá gam. ");
INSERT INTO sgz_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Má ái sang a pukri kápán páplun i iau mai wel ngorer a eran i iau suri bung da tahun iau on. ");
INSERT INTO sgz_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Má támin muswan iau parai si gam, i tan malar no i naul matmatngan pokon da arbin mai lain arbin ái, da parai mul i táit erei a longoi i wák min mam iau má da para agasi suri.” ");
INSERT INTO sgz_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Má namur ái Iudas Iskariot, kes tili di á sángul mai aru á kalik án aratintin, a so alar di mák han hut singin tan pakpakta kán tan tám osmapak ");
INSERT INTO sgz_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","má ák parai si di ngo, “Dánih gama tari singing ngo ina tar Iesu ur si gam?” Má dik tari atul i sángul á kepwen pirán tabal siliwa singin. ");
INSERT INTO sgz_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Má ngorer ái Iudas a turpasi ser sál suri na agur tar Iesu ur singin bos kurtara. ");
INSERT INTO sgz_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tatalen kán tan Iudáiá a ngoro minái. I libung táilnai longsit án ani beret káp a tini sut, di lu up bingi tan gengen sipsip suri da ani uri akiláng i longsit án sorliu palai mul. I bung erei sang, kán kalilik án aratintin di gálta Iesu ngo, “Be, ai u nem on ngo gima han ur ái má eran i namnam án sorliu palai?” ");
INSERT INTO sgz_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Má a longrai ngorer ái Iesu má ák parai ngoromin, “Gama han má urami Ierusalem, má gama mákái kálámul er iakte parai si gam má gamák parai singin ngo, ‘Ái Tám Aratintin a parai ngo, “Kak pákánbung ákte hut má, má ina ani namnam án sorliu palai i kam rum tiklik mai kang kalilik án aratintin.” ’” ");
INSERT INTO sgz_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Má tan kalilik án aratintin di longrai ngorer ki dik aptur má dik han ur Ierusalem, má dik longoi ngorer ái Iesu ákte parai si di, má dik eran i namnam án sorliu palai iatung. ");
INSERT INTO sgz_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Má ngo ákte ronron, ái Iesu má kán kalilik án aratintin di hut, má dik sukis suri turpasi namnam. ");
INSERT INTO sgz_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Má kándi tu namnam besang, mái Iesu a parai ngoromin, “Támin muswan iau parai si gam, kes tili gam na agur tar iau.” ");
INSERT INTO sgz_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kán kalilik án aratintin di longrai ngorer, má a sák i bál di, má di keskeskes dik turpasi gáltai ngoromin, “Kápte ngo iau, be?” ");
INSERT INTO sgz_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Mái Iesu a kos di ngo, “Ái koner giur namnam tiklik tili kápán les erei iau namnam til on, ái sár na agur tar iau. ");
INSERT INTO sgz_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","A támin muswan ngo Natun Kálámul na han mur arwat pasi sál suri minat ngorer a parai i pinpidan. Mái sár na tuan sák bul uri kálámul er na agur tari Natun Kálámul! Na han kuluk singin kálámul er ngo káp na han te páng.” ");
INSERT INTO sgz_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Mái Iudas tám arasong er a parai ngo, “Keskam, Tám Aratintin, kápte ngo iau, be?” Mái Iesu a kosoi ngo, “Áá, á iáu sár.” ");
INSERT INTO sgz_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kándi tu namnam be, mái Iesu a long pasi kesi tigán balbal mák sung kári, má namur a tibi mák tari singin kán kalilik án aratintin mák parai mul si di ngoromin, “Gama top pasi má gamák ani. Minái á kápán páplun i iau.” ");
INSERT INTO sgz_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Má namur a long pasi kinleh wain mák sung kári mul, ki ák tari singin kán kalilik án aratintin má a parai ngo, “Gam no gama ngin on. ");
INSERT INTO sgz_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Minái á dárang a adikái kamkabat si Káláu. Na sal suri hul aliu pasi marán má suri pah palai kándi sápkin. ");
INSERT INTO sgz_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Iau parai si gam, káp ina te ngin on mul á suir wain pang i bung erei ina ngin i hutngin wain tiklik mam gam ami lolsit si Tata.” ");
INSERT INTO sgz_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","A rah i kán worwor ái Iesu, má namur di saki kesi saksak ki dik so alari rum má dik han urami pungpung á Oliwa. ");
INSERT INTO sgz_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","I pákánbung kándi tu láklák be tangrai sál, ái Iesu a parai si di ngoromin, “Kamu ruruna na pur i pákán libung in kabin sur iau, ngorer i Buk Tabu a parai ngo, ‘Ái Káláu na up bingi tám ololoh sipsip, má bos sipsip da tam sara.’ ");
INSERT INTO sgz_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Má namur ngo iakte liu kaleng, ina táil i gam ur Galiláiá.” ");
INSERT INTO sgz_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Mái Petero a parai si Iesu ngo, “Káksiai ngo di no na pur i kandi ruruna kabin sur iáu, mái sár á iau kápte.” ");
INSERT INTO sgz_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Mái Iesu a parai si Petero ngoromin, “Támin muswan iau parai singim, inái i libung, i pákánbung kok kápate tang besang, una arkawar pala iau na tul i pákán.” ");
INSERT INTO sgz_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Mái Petero a kos kalengna Iesu ngoromin, “Auh, kápte! Káksiai ngo da long te matngan rangrangas mam iau ngo da up bing iau, má kápte sang ina arkawar pala iáu.” Má bos kalilik án aratintin no di parai ngorer mul. ");
INSERT INTO sgz_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Mái Iesu tiklik mai kán kalilik án aratintin di lu hanhan má dik hut i pokon di utngi ngo Getsemane, mái Iesu a parai si di ngo, “Gam iain, má iau ina han urada inak sung be.” ");
INSERT INTO sgz_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Má ngorer a lam pas Petero mái Iakobo mái Ioanes, aru natun ái Sebedaio, má dihat má han. I pákánbung erei, lala tabureng a hut i narsán ái Iesu ");
INSERT INTO sgz_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","má ák parai si ditul ngo, “Tabureng a káng i balang má páput na baur iau. Gamtul iain má gamtula pán tangan iau.” ");
INSERT INTO sgz_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ái Iesu a kálik láklák iamuda sár, mák pur uramudi bim mák sung ngoromin, “Keskam, Tata, arwat suri ngo una long palai á kinleh án rangrangas má minat alar iau? Mái sár káp una te mur i kak nemnem, una mur on ngorer i kam nemnem sang.” ");
INSERT INTO sgz_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ái Iesu a kaleng má a mák ruktul er ditul boptin, má a parai si Petero ngoromin, “Ngádáh, kápte gamtul arwat suri gamtula pán tangan iau i án mudán pákánbung sár?” ");
INSERT INTO sgz_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Má namur mul a parai si ditul ngo, “Gamtula pán má gamtulák sung suri gama tur rakrakai i pákánbung án artohtoh. Támin, bál gam a nem on, mái sár kápán páplun kápate rakrakai.” ");
INSERT INTO sgz_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Má a han alar ditul mul ái Iesu suri sung má a parai ngoromin, “Kakang, ngo kápate kuluk ngo kinleh án rangrangas min na bokoh alar iau, ki inak ngin on. Iau nem sár i kam nemnem sang.” ");
INSERT INTO sgz_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Má namur a kaleng mul, má ngorer a mákái kán atul i kalik án aratintin ditul boptin kabin a tuan taun i mát ditul. ");
INSERT INTO sgz_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Mái Iesu a han alar ditul i átuil pákán mul suri sung, má a parai sár mul i worwor ngorer ákte parai. ");
INSERT INTO sgz_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Má a kaleng mul mák parai si ditul ngo, “Kamutul tu boptin má aunges be? Pákánbung ákte hut má. Mákái, minái má á Natun Kálámul dák top tari má uri limán bos tám sápkin. ");
INSERT INTO sgz_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Gam kodas, giták lu han má! Mákái, erei mái kálámul na agur tar iau!” ");
INSERT INTO sgz_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ái Iesu kán tu worwor be, mái Iudas, kes tili di á sángul mai aru, a kahra tiklik mai lala matananu di kipi kandi bos papam turán i di. Má bos pakpakta kán tan tám osmapak má bos kálámul pakta dikte dos palai matananu er suri tiklik mam Iudas. ");
INSERT INTO sgz_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Má ái koner a agur tar Iesu ákte para páksi kán akiláng narsán matananu ngoromin, “Kálámul er ina árár pasi mai doroi, ái sár á erei. Gama tolai.” ");
INSERT INTO sgz_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Mái Iudas a hut mák láklák tálángna Iesu mák parai ngo, “Lain libung, Tám Aratintin!” má a doroi. ");
INSERT INTO sgz_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Má ái Iesu a parai ngo, “Na, turang! Longoi be i táit ukte hut suri!” Má matananu di mák Iudas a longoi ngorer, ki dik top i Iesu má dik tolai. ");
INSERT INTO sgz_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Má kes tili di ái rung di tiklik mam Iesu ák taruh pasi kán is mák tárái toptop káián tám osmapak táil uri talngán mák tár kus palai talngán. ");
INSERT INTO sgz_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Mái Iesu a mákái ngorer mák parai singin ngo, “Una dung kalengnai kam is i kuán. Kálámul a lu arup ngorer mai is, wa na mat mul ngorer! ");
INSERT INTO sgz_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ngádáh, kápute mánán ngo á iau iau arwat sár ngo ina sung Tata suri na tangan iau? Ina sungi ngorer má káp melek sár na dos palai marán sorliwi sángul mai aru á boh angelo suri tangan iau. ");
INSERT INTO sgz_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mái sár káp ina te sungi kabin a mon i tan táit a parai i Buk Tabu ngo na hut i pákánbung minái. Má ngo ina sungi ngorer, ki kápnate ian á tan táit erei.” ");
INSERT INTO sgz_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Má ngorer ái Iesu a parai singin matananu er ngo, “Ngádáh, gam hol on ngo á iau kesi tám ngákngák ngorer gamá hut mai kamu bos papam suri gama up iau mai má kabat pas iau? Marán á bung iau lu kis i katbán i gam ami rumán osmapak, má iau lu atintini matananu ái. Má suri dáh kápgamte tola iau i pákánbung er? ");
INSERT INTO sgz_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mái sár tan táit minái a hut suri long arwat pasi worwor erei tan tám worwor tus di le on i Buk Tabu.” Má i pákánbung er bos kalilik án aratintin di no di hol pala Iesu má dik táu alari. ");
INSERT INTO sgz_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mái rung erei di tola Iesu di lami uri narsán ái Kaiapas, tám osmapak táil, uratung i kuir rum kándi tu hut talum ái á bos kálámul pakta má bos tám mánán uri nagogon. ");
INSERT INTO sgz_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Mái Petero a lu murmur su i Iesu má a kusak urami pelbut i rum káián tám osmapak táil. Má a kis tiklik mai bos tám mákmák kalar iatung. A nem ngo na mák tusi táit ngo na hut. ");
INSERT INTO sgz_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Má tan pakpakta kán tan tám osmapak má kunlán kaunsel no di ser sur te kálámul suri da angagur uri Iesu singin kaunsel, má namur kaunsel na oboi rangrangas ur on ngo na mat. ");
INSERT INTO sgz_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Marán tan kálámul di parai te angagur ur on, mái sár kápte kesá worwor a artálár suri da nagogon on mai uri minat. Má namur aru kálámul diar aptur ");
INSERT INTO sgz_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","má diará parai ngoromin, “Giur sang giur longrai kálámul min a parai ngo a arwat ngo na tarápái rumán osmapak káián ái Káláu, má na him pasi atul á bung sár suri long kalengnai nák sámtur.” ");
INSERT INTO sgz_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Io, má tám osmapak táil a aptur mák gátna Iesu ngoromin, “Ngádáh, káp kam te kokos suri tan worwor minái di parai uri iáu?” ");
INSERT INTO sgz_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Mái Iesu a tur pau sár má kápate kokos. Má tám osmapak táil a bali parai singin ngo, “Iau oror kalar iáu mai ngisán ái Káláu koner a liu áklis. Be, á iáu á Mesaia, Natun ái Káláu?” ");
INSERT INTO sgz_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Mái Iesu a kosoi ngo, “Áá, a ngorer sár u parai. Má iau parai si gam no ngoromin. Namur gama mákái Natun Kálámul na kis tili risán mingin ái Káláu Tám Rakrakai Sorsorliu, má na hut mai kumlán mehmeh tilami bát.” ");
INSERT INTO sgz_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Má tám osmapak táil a mos i bál mák tarápái lusán mák parai ngo, “Ákte worwor sáksák má! Suri dánih gita ser sur te kálámul suri para te táit mul? Gamáte longrai er a parai ngo a arwat mam Káláu! ");
INSERT INTO sgz_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Má gam, ngádáh á kamu hol?” Má tan kaunsel má tan tám ololoh mul di parai sang ngo, “Ákte longoi sápkin. A nokwan ngo na mat.” ");
INSERT INTO sgz_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Má di turpasi iapsi má dik ubi, má te di posri ");
INSERT INTO sgz_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","má dik parai singin ngo, “Wái, á iáu á Mesaia? Una utung tusi ngo ái sinih er a up iáu!” ");
INSERT INTO sgz_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Mái Petero a sukis pagas iamudi lol malar. Má kesi tahlik a tám toptop a han má ák mák Petero iatung. Má wák erei a han narsán má a parai singin ngoromin, “Á iáu mul u lu tiklik mam Iesu er kakun Galiláiá.” ");
INSERT INTO sgz_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Mái Petero a arkawar palai mák parai ngo, “Káp iau te talas suri táit er u parai.” ");
INSERT INTO sgz_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Má a han alar di uramudi mátán kas. Má kesi tahlik mul a tám toptop a mák Petero mák parai singin matananu iatung di sámtur pagas ngo, “Kálámul min a lu tiklik mam Iesu er kakun Nasaret.” ");
INSERT INTO sgz_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Mái Petero ákte lu arkawar pala Iesu mul mák parai ngo, “Iau oror mai támin muswan, káp iau te mánán on á kálámul er!” ");
INSERT INTO sgz_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Má namur matananu di sámtur iatung di mul di han uri narsán ái Petero má dik parai singin ngo, “Áá, a muswan á iáu á kes tili di kabin ngo gim longra ilmi kam worwor a ngorer i kaungán matananu til Galiláiá.” ");
INSERT INTO sgz_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mái Petero a longrai ngorer má a turpasi oror mai muswan ngoromin, “Ngo káp iau te parai támin, ái Káláu na arangrangas i iau suri. Káp iau te mánán on á kálámul er.” Io, má káp melek sár má kok a tang, ");
INSERT INTO sgz_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","mái Petero a hol pasi worwor er a parai singin ái Iesu ngo, “I pákánbung kok kápate tang besang, una pua pala iau na tul i pákán.” Ái Petero a hol pasi worwor erei má ák tinang i bál suri, má ngorer a so tilatung mák lala tang. ");
INSERT INTO sgz_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","I kábungbung sang, di worwor talum ái rung erei bos pakpakta kán tan tám osmapak má bos kálámul pakta no. Di worwor talum suri da obop Iesu uri minat. ");
INSERT INTO sgz_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Má di kabat Iesu má dik lami uri narsán ái Pilato, kálámul pakta til Rom, má dik susdo tari uri limán. ");
INSERT INTO sgz_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Má i pákánbung ái Iudas tám arasong a mákái ngo ái Iesu dikte oboi nagogon án minat on, erár ák tinang i bál mák hol kaleng má, má ngorer a kaleng uri narsán bos pakpakta kán tan tám osmapak má boh kálámul pakta. A kipi atul i sángul á pirán tabal suri na tari si di. ");
INSERT INTO sgz_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Mái Iudas a parai ngoromin, “Iakte sák! Iau agur tari kálámul a nokwan erei má nák mat ngorer.” Mái rung er di kosoi ngo, “Dánih gima longoi á gim? Wa uk lu ingai iáu sang má mai, kam talar!” ");
INSERT INTO sgz_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","A be longrai ngorer ái Iudas, ki ák sápka palai pirán tabal sár iatung i rumán osmapak mák sangar i han pas alar di. Ák han sár má ngorer ák bibing mai suk ák mat. ");
INSERT INTO sgz_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tan pakpakta kán tan tám osmapak di kipi pirán tabal má dik parai ngo, “Pirán tabal minái a dur kabin di huli dár mai. Má ngorer kápate artálár uri nagogon kángit ngo da oboi pirán tabal er iatung i nián omobop er i rumán osmapak.” ");
INSERT INTO sgz_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Má namur di kis talum má dik sormángát i pirán tabal erei suri huli kuir bim káián kesi tám long lus. Má kuir bim er di oboi suri tahni tan kálámul tili risán er di mat á Ierusalem. ");
INSERT INTO sgz_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Má ngorer á káplabin suri pokon er dik utngi mai ‘Pokon án Dár’ ák han átik onin sang. ");
INSERT INTO sgz_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Má erei á táit a parai ái Sakaria tám worwor tus a tapam hut muswan ngo, “Di top pasi atul i sángul á pirán tabal, mámát erei rung til Israel dikte mángtai suri huli kálámul er. ");
INSERT INTO sgz_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Má di kipi pirán tabal er má dik huli kuir bim káián tám long lus. Di longoi ngorer ái Konom ákte parai singing.” ");
INSERT INTO sgz_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Mái Iesu a tur i mátán táil i tátáil til Rom, mái Pilato a gátnai ngo, “Be, iáu á kabisit káián tan Iudáiá?” Mái Iesu a kos Pilato ngoromin, “Áá, a ngorer sang ukte parai.” ");
INSERT INTO sgz_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Má bos pakpakta kán tan tám osmapak má boh kálámul pakta, di parai marán táit ur on, mái sár ái Iesu kápate kos di. ");
INSERT INTO sgz_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Má ngorer ái Pilato a bali gálta Iesu ngo, “Ngádáh, kápute longrai á marán má táit erei dikte parai uri iáu?” ");
INSERT INTO sgz_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Mái sár ái Iesu kápte a káling kokos suri tekesá táit er di parai ur on, má ngorer ái Pilato a lala sodar suri. ");
INSERT INTO sgz_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","I tan bungun longsit án sorliu palai, koner a kálámul pakta til Rom a lu mángát palai kesi kálámul tili rumán batbat kalar, ái koner matananu di nem on. ");
INSERT INTO sgz_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","I pákánbung erei, te tám ngákngák di kabat di uri rumán batbat kalar. Má kes tili di ái rung er di lala mánán on, ngisán ái Barabas. ");
INSERT INTO sgz_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Má ngo matananu dikte hut narsán ái Pilato, ki ák gálta di ngo, “Sinih á gam nem on ngo ina pálás palai ur si gam? Ina pálás pala Barabas ngo ina pálás pala Iesu, ái koner di utngi ngo Mesaia?” ");
INSERT INTO sgz_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ái Pilato a parai ngorer kabin a mánán ngo rung erei di bálsák uri Iesu kabin matananu di árngai ngisán, má ngorer dik obop Iesu uri nagogon. ");
INSERT INTO sgz_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Má i pákánbung er a kis ái Pilato i rumán nagogon, kán wák a tar palai kesá pákán ram a le on ngoromin ngo, “Kápte táit a sák a longoi á kálámul er, má koion una long te táit mai kabin nengen i libung iau mihmih sáksák ur on.” ");
INSERT INTO sgz_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mái sár bos pakpakta kán tan tám osmapak má boh kálámul pakta di tari duk i matananu suri ngo da sung Pilato nák pálás pala Barabas, mái Iesu na oboi uri minat. ");
INSERT INTO sgz_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Mái Pilato a bali gálta di ngoromin, “Sinih tili diar gam nem on ngo ina pálás palai ur si gam?” Má di kos Pilato ngo, “Una pálás pala Barabas!” ");
INSERT INTO sgz_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Mái Pilato a gálta di mul ngo, “Dánih má ina longoi mam Iesu er di utngi ngo Mesaia?” Má di no di parai ngo, “Bás páptai uri páspáng!” ");
INSERT INTO sgz_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Mái Pilato a gálta di ngoromin, “Suri dáh gama up bingi? Matngan sápkin ngádáh ákte longoi?” Má matananu di lala wakwak má dik parai ngo, “Bás páptai uri páspáng!” ");
INSERT INTO sgz_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ái Pilato a longrai ngorer mák mákái ngo kápate arwat ngo na tur kári nemnem káián matananu, má páput má na aptur i ororok. Má ngorer a salaptur mák long pasi dan má ák siwi limán i mátán táil i matananu, má ák parai ngo, “Á iau, kápte ngo iau á káplabin á minat káián kálámul minái. Kamu táit sang á er.” ");
INSERT INTO sgz_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Má matananu no di kosoi ngo, “Dárán kálámul min na uri káil i gim má rang nat gim! Á gim sang gim káplabin pasi kán minat.” ");
INSERT INTO sgz_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Má ngorer ái Pilato a pálás pala Barabas ur si di, má a tar Iesu suri dik rapsi á tan tám arup má namur dák bás páptai uri páspáng. ");
INSERT INTO sgz_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Má namur bos tám arup si Pilato di lam pas Iesu má ding kusak tiklik mai uri kesi kuir rum sang má ding kilkila talmi bos tám arup. ");
INSERT INTO sgz_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Má namur di long palai lusán má dik asulu on mai sulu a mirik, ");
INSERT INTO sgz_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","má dik longoi kesi balaparip mai kaulbek má dik oboi i lul, má dik tari kesá kuir kubau i limán mingin. Di longoi mai ngorer i mermer kán kabisit, má dik lu pur dirtapul i mátán táil ái Iesu. Má ngorer di tartar retret singin, má dik árár pasi ngorer i kálámul pakta má dik parai ngoromin, “Huihui iá! Erei má kabisit kándi tan Iudáiá!” ");
INSERT INTO sgz_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Má namur dik lu iapsi má dik long pasi bus má dik boktoi lul mai. ");
INSERT INTO sgz_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Má ngo dikte tartar retret no mai ngorer má, ki dik ulát palai sulu tili kápán páplun ái Iesu má dik asulu kalengnai mai lusán sang. Má namur dik tangna pasi suri da bás páptai má uri páspáng. ");
INSERT INTO sgz_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Má ngo di lu hanhan tangra sál, di banai kesi kálámul ngisán ái Saimon, kakun Sairini, má dik tur páptai má dik tari duk on suri ák puski kán kubau kus ái Iesu. ");
INSERT INTO sgz_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Má ngorer di lam Iesu uri kuir pokon di utngi ngo Golgata, sálán ngo ‘koroson lul’. ");
INSERT INTO sgz_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Má ngo dikte hut á Golgata, di tari suir wain si Iesu erei di ariwai turán te suir kábau er a maptal suri long bingi rangrang. Ái Iesu a tohoi suir wain erei, mái sár a matai má kápate ngin on. ");
INSERT INTO sgz_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Má namur di bás pápta Iesu uri kubau kus má dik hom satu pasi kán tan táit ngorer i kán sulu má lusán ur kandi. ");
INSERT INTO sgz_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","A be rah i tan táit si Iesu er di satu suri, ki ding kis má, má dik tu márásngin on. ");
INSERT INTO sgz_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Má ami iátin lul, di le i worwor er di nagogon on suri ngoromin, “Ái Iesu minái, ái á kabisit kán tan Iudáiá.” ");
INSERT INTO sgz_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Má di bás páptai aru i tám ngákngák tiklik mam Iesu mul, kes tili balsán mingin má kes tili balsán káisán. ");
INSERT INTO sgz_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Má ngorer matananu di sorliu má di mák Iesu uramuni naul kubau kus má di luhluhrai lul di sár ur on, má di ret mai ");
INSERT INTO sgz_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ngoromin, “Wái! Á iáu u parai ngo una tarápái rumán osmapak, má ngo una him pasi atul á bung sár suri long kalengnai! Erei má una aliu pas iáu sang! Ngo iáu Natun ái Káláu, ki unák sosih tilatung i naul páspáng!” ");
INSERT INTO sgz_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Má ngorer mul bos pakpakta kán tan tám osmapak má bos tám mánán uri nagogon má bos kálámul pakta di tartar retret mam Iesu mul má dik parai ngoromin, ");
INSERT INTO sgz_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“A aliu pasi boh lite kálámul, mái sár kápate arwat suri na aliu pasi sang. Onin sang gita mákái má kabisit kán Israel na sosih alari páspáng suri giták ruruna on! ");
INSERT INTO sgz_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kabin a parai ngo a ruruna i Káláu má a ngoi mul ngo ái Natun ái Káláu. Má onin sang gita mákái kán nemnem ái Káláu, ngo na tangan pasi ngo kápte!” ");
INSERT INTO sgz_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Má aru i tám ngákngák di bás pápta diar turán ái Iesu, diar mul diar para bengtai má diará wáng on. ");
INSERT INTO sgz_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Má i sángul mai aru á pákánbung, nas a kuron má a bohoi kunlán balis er, má kuron a pang i atul á pákánbung. ");
INSERT INTO sgz_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Má i atul á pákánbung i rahrah ái Iesu a kilkila ngángra Káláu ngoromin, “Eloi, Eloi, lama sabaktani?” Sálán ngoromin, ‘Káláu, kang Káláu, suri dáh ukte hol pala iau?’ ");
INSERT INTO sgz_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Má te tili di á matananu di sámtur pagas iatung páput, di longrai má dik parai ngo, “Kálámul min a kilkila Elaisa.” ");
INSERT INTO sgz_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Má kes tili di a rut mák long pasi kesi táit ngoro loson lamas, má a dungi uri kinleh suir wain er a maptal mák sosap pasi suir wain. Má a akai táit er i kuir gáh mák sua tari uramuni ngudun suri na ngin on. ");
INSERT INTO sgz_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Má tan kálámul er di parai ngo, “Kái be! Giták mákái be ngo ái Elaisa na hut má na tangan pasi.” ");
INSERT INTO sgz_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Má namur ái Iesu a lala kilkil mul, má ák bál palai tanián mák mat. ");
INSERT INTO sgz_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Má i pákánbung erei sár, tilik sulu ami polgon rumán osmapak a ráp tilami iát uradi lal má ák ru on. Má a hut i tiling kunkun má ák pospos i bos hat. ");
INSERT INTO sgz_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Tan tarang án minat a pasbat má marán tili matananu si Káláu er dikte mat, di liu má dik aptur alari minat. ");
INSERT INTO sgz_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Di han alari kándi tan tarang án minat, má namur ngo ái Iesu ákte liu kaleng, ki dik han urami malar á Ierusalem má marán dik mák di. ");
INSERT INTO sgz_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Má tátáil kán bos tám arup mai tan tám arup mul di sámtur pagas iatung i risán suri ololoh i táit di longoi mam Iesu. Má ngo di mákái tan táit ngorer i kunkun má matngan táit ngádáh a tapam hut, ki dik ráuráuwas má dik pángáng suri, má dik parai ngo, “A támin muswan, kálámul minái, war ái Natun ái Káláu!” ");
INSERT INTO sgz_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Te wák di iatung mul i pokon er, mái sár di kálik tur tepák suri mák Iesu. Tan wák er dikte lu mur i Iesu ami Galiláiá má dik lu tángni, má namur dik mur i Iesu átik á Ierusalem. ");
INSERT INTO sgz_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Má iatung i katbán tan wák erei ái Maria Magadalene, mái Maria mámán ái Iakobo mái Iosep, mái mámán ái aru natun ái Sebedaio mul. ");
INSERT INTO sgz_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ákte páput má suri rahrah i bung erei, má kesi konom til Aramatia, ngisán ái Iosep, a hut. Má ái mul á kesá kálámul a lu mur i Iesu. ");
INSERT INTO sgz_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Má ngo dikte mánán pasi ngo ákte mat mái Iesu, ái Iosep a han mák gálta Pilato suri kápán páplun ái Iesu suri na tahni. Mái Pilato a ardos suri da tari kápán páplun ái Iesu ur si Iosep. ");
INSERT INTO sgz_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Má ngorer ái Iosep a artari suri dik long pasi kápán páplun ái Iesu má dik duri mai hutngin sepen sulu, ");
INSERT INTO sgz_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","má di kipi uri kán tarang án minat sang, mátán hat dikte hutngin ili tili bángbágil hat. Má namur di girwai kesi lala hat má dik batbat kári mátán tarang mai, má dik han má. ");
INSERT INTO sgz_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mái Maria Magadalene má kesi Maria mul diar iatung be má diará kis pátmi mátán hat erei. ");
INSERT INTO sgz_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Má arasa i kábungbung i bungán aunges, bos pakpakta kán tan tám osmapak má tan Parisaio di kis talum mam Pilato ");
INSERT INTO sgz_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","má dik ngoi singin ngo, “Mákái, konom, gim hol páptai ngoromin. I pákánbung kán tu liu be á tám angagur erei, a ngoi ngo na liu kaleng tili minat i átuil bung. ");
INSERT INTO sgz_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Una tari pala te worwor ngo kán tarang án minat da lain mákmák kári sang nák han pang i átuil bung. Má ngorer kán kalilik án aratintin kápdate han má sikip pasi kápán páplun má dák agurái matananu ngo ákte liu kaleng tili minat. Angagur tungu a tuan sák, mái sár ngo da agur pasi matananu mai matngan angagur minái, ki na tuan sák taladeng sang!” ");
INSERT INTO sgz_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ái Pilato a longrai ngorer mák parai si di ngo, “Lam pas te tám arup má gamák han má lain mákmák kári tarang erei.” ");
INSERT INTO sgz_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Má ngorer di aptur má dik han. Dik han gorgor kári tarang er suri kápte kes na tohoi kusak ur on. Má dik obop te tám arup mul suri mákmák kári. ");
INSERT INTO sgz_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Má namur ákte rah i bungán aunges, má i Sade i ngahwán kábungbung sáksák, ái Maria Magadalene mái kesi Maria mul diar han uri mátán hat er di dung Iesu ái. ");
INSERT INTO sgz_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Má káp melek a hut i tiling kunkun, má kesi angelo káián ái Konom a hut sosih tilami bát má ák girwa palai hat mák sukis on. ");
INSERT INTO sgz_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kán mákmák i angelo a talas ngorer i pil má lusán a tuan bal ngoro busbus. ");
INSERT INTO sgz_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tan tám arup di ololoh i tarang di mákái ngorer má dik lala ráuráuwas má dik pur uradi bim ngorer i kálámul ákte mat. ");
INSERT INTO sgz_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Má angelo er a parai singin aru wák ngoromin, “Koion gaura mátut! Iau mánán ngo gaur mákmák sur Iesu er di bás páptai uri kubau kus. ");
INSERT INTO sgz_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Bokoh ái á main. Ákte liu kaleng ngorer sang ákte parai. Gaur lákám gaurák mákái pokon a bopbop on. ");
INSERT INTO sgz_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Má ngorer gaura sangar i han, má gaurák bitái kán kalilik án aratintin ngo ákte liu kaleng alari minat, má na táil i gam urami Galiláiá, má erei á pokon gama mákái ái. Erei sár á worwor talas iakte parai si gaur.” ");
INSERT INTO sgz_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Má diará longrai ngorer, ki diará sangar i han tilatung. Diar mátut, mái sár diar laes mul, má ngorer diar má rut suri parai singin kán bos kalilik án aratintin. ");
INSERT INTO sgz_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Má káp melek sár mái Iesu a bana diar mák parai si diar ngo, “Matau na kis i gaur.” Diar mák Iesu ngorer má diará han sukis dirtapul i mátán táil ái Iesu, má diará top i keken má diará lotu uri narsán. ");
INSERT INTO sgz_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Mái Iesu a parai si diar ngoromin, “Koion gaura mátut. Gaura han narsán rang tuang, kak tan kalilik án aratintin sang, má gaurák parai si di ngo da han ur Galiláiá, má iatung da mák iau ái.” ");
INSERT INTO sgz_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Diar kaleng á aru wák er uri narsán tan kalilik, má tan tám arup di ololoh i tarang án minat di han urami bimán rum á Ierusalem má dik atatir singin bos pakpakta kán tan tám osmapak suri tan táit er ákte tapam hut. ");
INSERT INTO sgz_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Má tan tám osmapak má tan kálámul pakta di ngurkai, má namur dik tari pirán tabal ur singin bos tám arup ");
INSERT INTO sgz_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","má dik parai si di ngoromin, “Gama parai ngo kán tan kalilik án aratintin ái Iesu di hut i libung i pákánbung gam boptin on má dik sikip pasi kápán páplun. ");
INSERT INTO sgz_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Má ngo ái Pilato, kángit kálámul pakta, ngo na longrai ngorer, ki á gim gima anokwai ur singin má kápnate long te táit mam gam.” ");
INSERT INTO sgz_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Má tan tám arup dik top on á pirán tabal er má dik longoi ngorer dikte parai má si di. Má arbin er a bonta noi tan Iudáiá ák han pasi bung onin. ");
INSERT INTO sgz_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Má sángul mai kesá kalik án aratintin di han ur Galiláiá uri pungpung er ái Iesu ákte parai si di, ");
INSERT INTO sgz_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","mái Iesu a arsuar mam di iatung. I pákánbung di mák Iesu, di pur dirtapul má dik lotu uri narsán, ái sár te tili di aru i kándi holhol. ");
INSERT INTO sgz_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Mái Iesu a láklák pátum mák parai si di ngo, “Ái Káláu ákte tari singing á nokwan suri kátlán naul bát má naul bim no. ");
INSERT INTO sgz_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Má ngorer gama han narsán matananu no i naul matmatngan pokon, má gamák lam pas di suri da kalilik án aratintin kaiak, má gamák siu di i ngisán ái Tata má i ngisán ái Natun má i ngisán Tanián a Pilpil. ");
INSERT INTO sgz_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Má gamák atintin di suri da mur noi tan pinpidan erei iakte tari si gam. Má ina tangan gam má kis áklis tiklik mam gam pang i áwáwat i pákánbung.” ");
INSERT INTO sgz_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Minái á turpasi lain arbin sur Iesu Karisito, Natun ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","A tangkabin hirá sang singin kesá tám worwor tus ngisán ái Aisaia, koner a le i worwor si Káláu er a parai ur si Natun ngoromin, “Mákái, ina tarwai kesá kálámul suri na tari kak pinpidan. Ái na táil i iáu. Na eran i matananu suri inan kaiam. ");
INSERT INTO sgz_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Má kálámul er na hut má na lu binbin i pokon mau ngo, ‘Aleget i sál si Konom má eran on. Long anokwai sál suri na láklák on!’” ");
INSERT INTO sgz_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Io má namur marán á bet a rah, ái Ioanes Tám Arsiu a hut ada i pokon mau mák arbin ngoromin, “Gama hol kaleng má gamáng kipi arsiu, má ngorer ái Káláu nák pah palai kamu tan sápkin.” ");
INSERT INTO sgz_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Má matananu tili bimán rum á Ierusalem má tili balis á Iudáiá di han suri longrai arbin si Ioanes. Má matananu di lu para aposoi kándi bos sápkin tatalen, mái Ioanes a siu di mai dan á Ioridan. ");
INSERT INTO sgz_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ái Ioanes a sulu mai nihun kamel di hiri, mák reureu mai kápán sipsip. A ani sikiu má midu. ");
INSERT INTO sgz_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Mái Ioanes a arbin ur singin matananu ngoromin, “Kálámul alatung na murwa pas iau, ái a lala rakrakai sorliu iau. Má iau, iau rumrum suri ina kusak i kán rum. ");
INSERT INTO sgz_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Á iau, iau siu gam mai dan sár. Mái sár kálámul er na siu gam mai Tanián a Pilpil má na mon i gam.” ");
INSERT INTO sgz_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","I bet erei, ái Iesu a hut tilami Nasaret i balis á Galiláiá, mái Ioanes a siu Iesu iatung i dan á Ioridan. ");
INSERT INTO sgz_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Má i pákánbung er ái Iesu a masar alari dan, ák mákmák uramuni bát má ák mákái bát a ráp má Tanián ái Káláu a sosih ngoro bun má a kis on. ");
INSERT INTO sgz_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Má kaungán kes a hut tilamuni bát má a parai ngoromin, “Á iáu á natung, kang Kalik alal. A lala gas i balang mam iáu.” ");
INSERT INTO sgz_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Má káp melek sár mul, Tanián ái Káláu a tarwa melekna Iesu uramuni pokon mau, ");
INSERT INTO sgz_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","má a kis i pokon tan rokoi di kis ái. Ahat i sángul á bung ái Iesu a kis iamuni pokon mau, mái Satan a tohtohoi. Má tan angelo di tapam hut má dik tangan Iesu. ");
INSERT INTO sgz_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Má namur ngo dikte tola tar Ioanes ur si Erodes, ái Iesu a hut i balis á Galiláiá má a arbin mai lain arbin si Káláu. A parai ngoromin, ");
INSERT INTO sgz_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Ákte arwat á bung má páput má matananu da kusak uri lolsit si Káláu má ái Káláu na kátlán i di. Gama hol kaleng má gamák ruruna i lain arbin.” ");
INSERT INTO sgz_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Mái Iesu a lu hanhan tangrai risán dan taliu á Galiláiá. A mák Saimon Petero mái Enru diar tuán, aru tám soksok, diar lu soksok mai uben iamuda i dan taliu. ");
INSERT INTO sgz_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Mái Iesu a parai si diar ngoromin, “Gaur lákám. Gaurák mur i iau má inak atintin gaur suri gaura tám soksok pasi matananu ur káián ái Káláu!” ");
INSERT INTO sgz_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Má káp melek mul má diar aptur alari kándiar uben iatung má diará mur i Iesu. ");
INSERT INTO sgz_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Má ngo a lu lákláklák iamunang tangrai kon, a mákái aru natun ái Sebedaio, ái Iakobo mái Ioanes, diar tuán leget i kándiar uben iatung i mon. ");
INSERT INTO sgz_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","I pákánbung er a mák diar ái Iesu, a kilkila pas diar alar Sebedaio má bos tám him iatung i mon. Má diar má aptur má diará han tiklik mam Iesu. ");
INSERT INTO sgz_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Dikte hut iatung i malar Kapernaum, má i bungán aunges ái Iesu a kusak uri rumán lotu má a turpasi aratintin i katbán matananu. ");
INSERT INTO sgz_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Má di longrai kán aratintin má dik pángáng suri, a kabin ngo kán aratintin kápate ngoro aratintin káián bos tám mánán uri nagogon. Kápte. Di longra ilmi ngo kán aratintin ái Iesu a mon i rakrakai on ngorer i kálámul a tarwai ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Má i pákánbung sang erei, kesi kálámul sápkin tanián a porta on a sol uratung i rumán lotu ");
INSERT INTO sgz_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","mák perek ngoromin, “Iáu Iesu kakun Nasaret, suri dáh u soksok gim? Iau mánán i iáu, iáu Tám Pilpil káián ái Káláu! Ngádáh, ukte hut suri una up sara gim, be?” ");
INSERT INTO sgz_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Mái Iesu a longrai ngorer má ák dos kári sápkin tanián er ngoromin, “Una kis pau, má unák so alari kálámul erei!” ");
INSERT INTO sgz_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Má sápkin tanián a longrai ngorer má ák agokgokoi mák lala wakwak mák táu alari. ");
INSERT INTO sgz_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Má di no di pánsálngát on má dik argátna kaleng i di ngoromin, “Dánih á ngoro inái? Hutngin aratintin, be? Kálámul minái a mon i kán nokwan suri dos palai boh sápkin tanián mul má dik lu taram on.” ");
INSERT INTO sgz_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Má arbin sur Iesu a han arkaliut melek i bos malar á Galiláiá no. ");
INSERT INTO sgz_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Má namur ái Iesu mai kán ahat i kalik án aratintin di so alari rumán lotu má dik lu hanhan iamunang, má ding kusak i rum si Petero mái Enru. ");
INSERT INTO sgz_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Má mámán ái kán wák ái Petero kán tu bop mai sasam. A málmálas. Má dik sangar i worwor mam Iesu suri. ");
INSERT INTO sgz_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Mái Iesu a han narsán mák top pasi limán má a salapturi, má sasam a han alari. Má namur wák erei a han má a eran i namnam ur ándi. ");
INSERT INTO sgz_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","Má i ronron bos matananu di hut talum iatung i mátán sál i rum si Petero. Di kipi marán kálámul di sasam má marán kálámul sápkin tanián a kusak i di. ");
INSERT INTO sgz_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Mái Iesu a aliu pas rung di sasam, má a tipar palai marán sápkin tanián. Má bos sápkin tanián a tur kalar di suri koion da worwor, kabin ngo bos sápkin tanián di mánán on ngo ái Natun ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","I kábungbung sáksák, nas kápate pos be, ái Iesu a pán mák so alari rum uramuda i pokon mau mák sung iatung. ");
INSERT INTO sgz_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Má namur ái Petero má rang turán dihat pán má dihat han ser sur Iesu. ");
INSERT INTO sgz_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Má ngo dikte mák pasi, ki dik bitái ngoromin, “Matananu no di gátna sur iáu.” ");
INSERT INTO sgz_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ái Iesu a longrai ngorer má a kos di ngoromin, “Áá, iau mánán. Mái sár káp iau te hut suri tan kálámul minái masik. Kápte. Ina lu arbin mul ur singin tan lite. Má git má, giták han uri tan lite malar er páput!” ");
INSERT INTO sgz_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Má di lu hanhan uri tan malar á Galiláiá no, má ái Iesu a tipar palai bos sápkin tanián má a arbin i bos rumán lotu mul. ");
INSERT INTO sgz_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kesi kálámul a sami lepra a hut narsá Iesu má a atri pukun keken mák dirtapul mák sung Iesu ngoromin, “Ngo u nem on, u arwat suri ngo una asengsegeng pas iau!” ");
INSERT INTO sgz_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Mái Iesu a longrai ngorer má a mámnai mák sarsara mai limán mák top i páplun kálámul erei, má a parai singin ngo, “Iau nem on. Inái ukte sengsegeng má!” ");
INSERT INTO sgz_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Má lepra a rah melek alari kálámul er mák sengsegeng. ");
INSERT INTO sgz_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Má namur ái Iesu a sangar i tarwa palai mák lala inau on ngoromin, ");
INSERT INTO sgz_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Koion una kálik parai singin tekes. Una han má unák para inngas iáu singin tám osmapak, má unák tari singin á kam osmapak ngorer ái Moses a parai, má kam osmapak erei na inngas tari ngo kam sasam ákte rah.” ");
INSERT INTO sgz_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mái sár kálámul er a lu hanhan má a arbin tangrai bos malar. Má ngorer ái Iesu kápate arwat ngo na kusak iatung i bos malar er káplabin matananu da siuti. Ngorer a lu hanhan tangrai tan pokon mau sár, má matananu tili bos malar di lu murmur on. ");
INSERT INTO sgz_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Má namur ngo ákte rah i te bung, ái Iesu a kaleng mul ur Kapernaum má a kusak i kesi rum, má matananu di longrai ngo ákte kis iatung. ");
INSERT INTO sgz_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Má marán di hut talum má kápte arliwán mul iatung suri da tur on. Iatung i mátán sál kápte. Má kán tu arbin narsá di, ");
INSERT INTO sgz_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","má ahat i kálámul dihat hut mai kesi peu dihat kipi i suh kabin kálámul er kápte a lu láklák. ");
INSERT INTO sgz_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Má di tohoi han pátmi, mái sár lala matananu taladeng di káng iatung. Má ngorer di sa mai uramuni ungán rum er a kis on ái Iesu, má dik pápki kuir ungán rum má dik asihái kálámul er tiklik mai kibán uramudi narsá Iesu. ");
INSERT INTO sgz_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ái Iesu a mák ilmi tan kálámul er ngo di ruruna muswan má ák parai singin peu ngo, “Kauh, ukte pilpil alari kam tan sápkin tatalen.” ");
INSERT INTO sgz_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Má te bos tám mánán uri nagogon si Káláu di kis iatung má di longrai ngorer, má a ngátngát i kándi hol ngoromin, ");
INSERT INTO sgz_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Suri dáh kálámul min a parai ngoromin? A pulus Káláu. Sinih a arwat suri ngo na long palai sápkin tatalen? Ái Káláu masik sár.” ");
INSERT INTO sgz_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mái Iesu a mánán pasi ami kán hol ngo di ngátngát sálán ngorer ami bál di, mák parai si di ngoromin, “Suri dáh gam ngátngát suri bos táit er ami bál gam? ");
INSERT INTO sgz_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Á iau a mon i kak nokwan suri parai singin kálámul erei a peu ngo, ‘Kam tan sápkin tatalen ákte pah,’ kabin ngo iau arwat mul suri parai ngorer singin kálámul er ngo, ‘Una aptur, una kipi kibam má unák láklák!’ ");
INSERT INTO sgz_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Má inái ina inngas tari si gam ngo Natun Kálámul a mon i kán nokwan suri pah palai bos sápkin tatalen main i naul bim!” Má ngorer a parai singin peu ngo, ");
INSERT INTO sgz_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Kauh, iau parai singim ngo una aptur má, unák pusak pasi kibam má unák han uri kam rum!” ");
INSERT INTO sgz_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Má kálámul erei a longrai má ák aptur ák pusak pasi kibán má ák so i mátán matananu no. Má di mákái ngorer ki dik pángáng suri, má dik para agas Káláu ngoromin, “Onin pala sang má gimá mákái matngan ngoromin!” ");
INSERT INTO sgz_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Mái Iesu a kaleng uramuni kon i risán dan taliu, má lala matananu di hut narsán mái Iesu ák abitbit di. ");
INSERT INTO sgz_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Má namur ái Iesu a lu hanhan, má ák mák Lewi natun ái Alpius a kis i rumán kip takis, mák parai singin ngo, “Lákám, unák mur i iau.” Mái Lewi a salaptur pas mák mur i Iesu. ");
INSERT INTO sgz_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Má marán si di á bos tám abulbul má marán rung di lu kip takis, di mur i Iesu. Má i rahrah, di kis suri namnam iatung i rum si Lewi, di no mam Iesu má kán kalilik án aratintin. ");
INSERT INTO sgz_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Má te tám mánán tili tan Parisaio di mákái ngo ái Iesu a namnam tiklik mai bos tám abulbul má bos tám kip takis, má dik han parai singin kán bos kalilik án aratintin ngoromin, “Suri dáh kamu tám aratintin a namnam tiklik mai bos tám long sápkin ngorer?” ");
INSERT INTO sgz_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Mái Iesu a longrai máng kos di ngoromin, “Ái rung di lain liu kápdite sáhár sur tekes ngo na aliu di, ái rung di sasam masik sár. Má iau, káp iau te hut suri ina kilkila pasi bos tám nokwan. Iau hut suri bos tám sápkin.” ");
INSERT INTO sgz_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Má namur tan kalilik án aratintin si Ioanes Tám Arsiu má bos Parisaio di ahal. Má te kálámul di purut si Iesu má dik gáltai ngo, “Suri dáh kalilik án aratintin káián ái Ioanes má bos Parisaio di ahal, má kam kalilik án aratintin kápte?” ");
INSERT INTO sgz_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Mái Iesu a kos di ngoromin, “Ngádáh? Ngo da longoi namnam án akila, u hol on ngo matananu da ahal i pákánbung er kálámul a hutngin kila a kis tiklik mam di? Kápte! I bung kesi kálámul a kila, di no da namnam tiklik. ");
INSERT INTO sgz_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Má namur da long pasi kálámul er a hutngin kila má nák bokoh alar di. I bung erei sang da ahal.” ");
INSERT INTO sgz_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Mái Iesu a sopasun i kán aratintin mák parai ngoromin, “Ngo kes a mon i kán rápán sulu mák nem ngo na mapmap on, kápnate baut arsaktai mapmap a longoi mai hutngin sepen sulu kápte be di gorsai. Ngo na baut arsaktai ngorer, má namur na gorsai, hutngin na hius sang má nák tarápái torahin má na ráp pakta i mátán erei. ");
INSERT INTO sgz_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Má kápte kesá kálámul na toroi hutngin suir wain uri torahin átbán dan di longoi mai kápán me. Ngo na longoi ngorer, suir wain erei na sut má na korkor má nák tarápái torahin átbán erei má nák ráp, má suir wain erei na sal no. Gita totrai hutngin suir wain uri hutngin átbán dan suri diar no diara sut tiklik.” ");
INSERT INTO sgz_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Má namur i kesá bungán aunges, ái Iesu a lu hanhan i katbán numán padi tiklik mai kán bos kalilik án aratintin. Di lu hanhan ngorer má kalilik erei di sak pas te padi má dik ani. ");
INSERT INTO sgz_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Má bos Parisaio di mákái, má namur di parai si Iesu ngoromin, “Suri dánih kam kalilik án aratintin di longoi ngoro minái, má uri nagogon kángit a parai ngo koion á longoi ngorer i bungán aunges?” ");
INSERT INTO sgz_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ái Iesu a kos di ngoromin, “Ngádáh? Kápgamte wásái besang suri táit erei ái Dewit a longoi ngo a matpám, má di mul er di tiklik mai? ");
INSERT INTO sgz_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","I pákánbung er ái Abiatar a tám osmapak táil, mái Dewit a kusak i rum si Káláu má a top pasi beret er di artabar mai uri narsán ái Káláu, má ák ani mák tari mul si rang táir má di mul di ani. Má uri nagogon kángit, beret er a tam arwat mai bos tám osmapak masik sár da ani.” ");
INSERT INTO sgz_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Mái Iesu a parai mul si di ngo, “Ái Káláu kápate oboi bungán aunges uri taun páptai matananu, a oboi uri tangan di. ");
INSERT INTO sgz_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Má ngorer Natun Kálámul ái á konom ur on á bungán aunges.” ");
INSERT INTO sgz_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Mái Iesu a kusak kaleng uri rumán lotu á Kapernaum, má kesá kálámul iatung a mat i kesi limán. ");
INSERT INTO sgz_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Má bos Parisaio di mangwa Iesu iatung. Di nem suri da mák Iesu ngo na aliu pasi kálámul er i bungán aunges ngo kápte. Má ngo na aliu pasi sang, ki ngorer da atiutiu Iesu suri. ");
INSERT INTO sgz_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Mái Iesu a parai singin kálámul erei limán a mat ngo, “Una lákám ur main.” ");
INSERT INTO sgz_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Má a gátnai matananu ngoromin, “Be, bos nagogon kángit, di atintin git suri dánih gita longoi i bungán aunges? Bung uri tángni matananu ngo bung suri longoi sápkin? Kol bung suri aliu pas di di sasam suri da liu kuluk? Kol gita tari bah git uri kálámul suri nák mat?” Má kápte kesá kálámul a kosoi. ");
INSERT INTO sgz_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Mái Iesu a sálsálah aririu i matananu. A mákái bál di a laklak, má a togor mák tang i bál suri tatalen ngorer. Má namur a parai singin kálámul erei ngo, “Una anokwai limam!” Má kálámul erei a longrai ngorer má ák anokwai limán, má limán áng kuluk kaleng. ");
INSERT INTO sgz_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Má bos Parisaio di mákái ngorer ki dik han melek uri narsán rang turán ái Erodes má di worwor talum suri da obop Iesu uri minat. ");
INSERT INTO sgz_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Má namur ái Iesu tiklik mai kán bos kalilik án aratintin di han alari malar á Kapernaum má dik han uri dan taliu á Galiláiá, má marán matananu di mur i di. Matananu erei di han tili atul á balis, Galiláiá má Iudáiá ");
INSERT INTO sgz_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","má Idumia, má tili tilik malar á Ierusalem. Má marán mul tilada i balsán dan á Ioridan má tili bos risán aru malar Tair má Sidon. Dikte longrai arbin suri bos táit ái Iesu a longoi má dik hut singin. ");
INSERT INTO sgz_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","I pákánbung erei marán matananu sang, mái Iesu a parai singin kán kalilik án aratintin suri da eran i mon uramuda i dan taliu má nák sámtur on suri koion á matananu da tur kauli má da káp siuti. ");
INSERT INTO sgz_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","A kabin ái Iesu a aliu pasi marán, mái rung er di sasam di no di arkarsa suri sigil Iesu. ");
INSERT INTO sgz_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Má ngo bos sápkin tanián di mákái, di pur uri mátán táil ái Iesu má dik lu wakwakwak ngoromin, “Iáu Natun ái Káláu!” ");
INSERT INTO sgz_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mái Iesu a wor rakrakai uri bos sápkin tanián, má a tur kalar di ngo koion da para inngasi ngo ái á Natun ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Namur ái Iesu a tapam uramuni pungpung má a kilkila pas di uri narsán ái rung er ákte ilwa pas di. Má ngo dikte hut narsán, ");
INSERT INTO sgz_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","a tus pasi sángul mai aru suri da lu tiklik mai, má na tarwa di suri da tám arbin káián, ");
INSERT INTO sgz_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","má na tari nokwan si di suri dák tipar palai bos sápkin tanián. ");
INSERT INTO sgz_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Mái Iesu a ilwa pasi sángul mai aru ngoromin: turpasi tili Saimon, kesá ngisán mul ái Petero; ");
INSERT INTO sgz_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","mái Iakobo diar tuán ái Ioanes, aru natun ái Sebedaio (di utngi ngis diar ngoromin ‘Pár’, sálán ngo ‘aru tám perek’); ");
INSERT INTO sgz_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","mái Enru; mái Pilip; mái Batolomi; mái Mataio; mái Tomas; mái Iakobo natun ái Alpius; mái Tadius; mái Saimon, kálámul a tur rakrakai suri da sikra palai kurtara alari Israel; ");
INSERT INTO sgz_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","mái Iudas Iskariot, ái koner na agur tar Iesu. ");
INSERT INTO sgz_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Má namur ái Iesu a kaleng uri rum a lu kiskis ái, má matananu di longrai ngo ái Iesu ákte hut iatung má di hut talum mul uri narsá Iesu ngo da longra kán te arbin. Má ngorer ái Iesu má kán kalilik án aratintin kápate arwat ngo da namnam. ");
INSERT INTO sgz_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Má i pákánbung er, rang buhán ái Iesu di longrai ngorer má dik han suri long pasi, kabin di parai ngo a ngul. ");
INSERT INTO sgz_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Má namur te á tan tám mánán uri nagogon di han tilami Ierusalem má dik lala worwor uri Iesu, má dik parai ngoromin, “Belsebul, kabisit káián tan sápkin tanián, a káng i bál má a tari rakrakai singin suri ák lu tipar palai tan sápkin tanián.” ");
INSERT INTO sgz_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Má ái Iesu a longrai má a kilkila talmi matananu uratung pátum suri da longrai pinpidan artálár mák parai si di ngoromin, “Be, ngádáh? Ái Satan a arwat ngo na tipar pala Satan? Kápate arwat. ");
INSERT INTO sgz_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ngorer kesi mát ngo na arup kaleng mai mát erei, ngádáh na tur ngoi? Na ru i di má kándi kis na sák. ");
INSERT INTO sgz_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Má ngorer mul i aramokson diar togor má diara arup, kápnate kuluk i kándiar kis má kápnate mon i kándiar rakrakai suri na kes kaleng i diar. ");
INSERT INTO sgz_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Má ngo ái Satan na arup kaleng mai má nák ru on, kápnate tur rakrakai i kán him, má kán him na mat sár.” ");
INSERT INTO sgz_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Mái Iesu a sopasun kán arabitbit ngoromin, “Ngo kes a nem ngo na kusak i rum káián tám rakrakai ngorer ái Satan suri long sarai kán tan táit, na mulán kápti be tám rakrakai erei, má namur na kusak má nák long sáksáknai kán tan táit.” ");
INSERT INTO sgz_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Mái Iesu a inau i di ngo, “A támin muswan iau parai si gam, tan sápkin tatalen má tan worwor sáksák gam longoi, a arwat ngo ái Káláu na pah palai. ");
INSERT INTO sgz_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mái sár ngo kálámul na ot bilingnai Tanián a Pilpil, ái Káláu kápnate hol palai. Kán sápkin tatalen na tur áklis.” ");
INSERT INTO sgz_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ái Iesu a parai ngorer kabin i pákánbung erei a him mai rakrakai káián Tanián a Pilpil, bos tám mánán erei di mákái má dik parai ngo ái Iesu a káng mai rakrakai si Satan, konom káián bos sápkin tanián. ");
INSERT INTO sgz_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","I bung erei, mámán ái Iesu tiklik mai rang tuán di hut má dik lu turtur iatung i risán rum má dik gálta suri. Di nem suri na so nák mák di. ");
INSERT INTO sgz_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Má matananu er di kis kauli di parai singin ngoromin, “Mákái Konom, merei ái mamam má rang tuam, di idi malar. Di mákmák sur iáu.” ");
INSERT INTO sgz_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Mái Iesu a kos di ngo, “Aiá á mamang, mái sinih á rang tuang?” ");
INSERT INTO sgz_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Mái Iesu a mákmák aririu i matananu iatung i narsán mák para ngoromin, “Minái ái mang má bos rang tuang. ");
INSERT INTO sgz_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ái koner a mur i nemnem si Káláu, ái á tuang má kukung má mamang.” ");
INSERT INTO sgz_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ái Iesu a atintini matananu mul iatung i risán dan taliu á Galiláiá. Má marán di hut kauli, má ngorer ái Iesu a sa uramuni mon iatung i risán kon mák sukis on, má matananu di tur pagas iamuni kon. ");
INSERT INTO sgz_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Mái Iesu a atintin di mai pinpidan artálár tilatung i mon má a parai si di ngoromin, ");
INSERT INTO sgz_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mákái! Tám himhimna a tapam hut mák sápra sarai kotlin kubau iatung i rákrák. ");
INSERT INTO sgz_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Má te kotlin kubau a pur iatung i sál má bos man di roh kis má dik tokam pasi. ");
INSERT INTO sgz_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Má te a pur uri bim a kis i hat adi lal, kápte marán bim on. Ngorer a kopkom melek, ");
INSERT INTO sgz_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","mái sár nas a ket má a kektai tan kopkobon kubau erei, má a maulur a kabin kápte bim suri nirwán na kip namnam til on, má ngorer ák marang no. ");
INSERT INTO sgz_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Má te kotlin kubau mul a pur uri katbán kaulbek, má kaulbek a pakta má a iaungi má kápate u. ");
INSERT INTO sgz_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Má te a pur uri lain bim má a tikbut má a lain kopkom kuluk má namur a u. A u ngoromin, te atul i sángul, má te awon i sángul, má te a u arwat mai kesi mar á wán.” ");
INSERT INTO sgz_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Má a parai si di ngo, “Ái koner a nem ngo na talas má na mánán, ki na kis án alongra!” ");
INSERT INTO sgz_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","I bung erei, ái Iesu a han alari matananu má a kis tiklik mai sángul mai aru i kán kalik ákte ilwa pas di má te tám ruruna mul, má di no di gátnai ngo, “Dánih sang á káplabin á pinpidan artálár erei?” ");
INSERT INTO sgz_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Mái Iesu a parai si di ngoromin, “Tungu a tur punpunam á mánán suri lolsit si Káláu má sál a mur on suri kátlán i git. Má onin ái Káláu ákte tari mánán er si gam. Mái sár tan lite alatung, kándi tu longrai worwor artálár má kápdite talas uri sálán, ");
INSERT INTO sgz_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","suri ngorer da mákmák má kápdate mák ilmi, má da longrai má kápdate longra ilmi, má kápdate talas suri, má na káp má dik hol kaleng mái Káláu na pah palai kándi tan abulbul.” ");
INSERT INTO sgz_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Mái Iesu a sopasun i kán aratintin mák gátna di ngoromin, “Ngo kápgamte mánán i sálán á pinpidan artálár min, ngádáh gama mánán ngoi á bos pinpidan artálár no? ");
INSERT INTO sgz_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tám himhimna a sápra sarai pinpidan si Káláu. ");
INSERT INTO sgz_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Bim erei i sál a pur ur on á kotlin kubau, ái a tur arwat mam rung a pur i pinpidan si Káláu uri bál di, mái Satan a hut melek mák long palai pinpidan er má kápdite hol páptai. ");
INSERT INTO sgz_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ngorer mul suri bim a kis i hat adi lal mák pur ur on á kotlin kubau. Ái a tur arwat mai tan kálámul di longrai arbin má dik laes melek suri. ");
INSERT INTO sgz_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mái sár pinpidan kápate lala sisip i nirwán uri bál di, má ngorer kápte di tur rakrakai. Má namur ngo arabilbiling a hut má dik áslai rangrangas kabin di lu mur i pinpidan si Káláu, ki dik teken pur melek. ");
INSERT INTO sgz_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Má te kotlin a pur uri katbán kaulbek. Matngan bim erei a arwat mam rung di longrai pinpidan, ");
INSERT INTO sgz_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","mái sár holhol suri táit án naul bim má hol apakta i minsik má nemnem suri tan toltolom táit no a kusak i bál di mák iaungi pinpidan káián ái Káláu má kápate u. ");
INSERT INTO sgz_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Má te kotlin a pur uri lain bim. Lain bim a arwat mam rung erei di longra pasi pinpidan má dik mur on, má namur dik u má dik oboi lain wán i di, te atul i sángul, má te awon i sángul, má te mul a mar.” ");
INSERT INTO sgz_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Mái Iesu a parai mul si di ngo, “I pákánbung gam oskoi lam, ngádáh? Gam lu boh kári mai kas ngo gam lu punmai i lalin suh? Kápte. Gam lu akai i nián sang. ");
INSERT INTO sgz_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Io, sálán á kak pinpidan a punpunam onin, má namur na tur talas. Má te sálán kápgamte mánán kuluk, namur gama talas besang ur on. ");
INSERT INTO sgz_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ái koner a nem ngo na talas má na mánán, ki na kis án alongra!” ");
INSERT INTO sgz_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Má a parai si di mul ngo, “Gama hol páptai erei gam longrai. Kálámul er na lala longra pasi worwor si Káláu, ái Káláu na tari marán mánán singin má na apakta pasi kán mánán urami. ");
INSERT INTO sgz_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ngorer ái koner a hol páptai pinpidan káián ái Káláu, ái Káláu na apakta pasi kán pinpidan i bál má na lala mánán. Mái koner kápte a hol páptai kán pinpidan, ái Káláu na pah palai mudán er a kis i kán hol.” ");
INSERT INTO sgz_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Mái Iesu a worwor artálár ngoromin, “Lolsit si Káláu a ngoromin. Kesi kálámul a soi balbal i kán rákrák. ");
INSERT INTO sgz_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Marán i bung a kis palai, má kesi bung má, a han laumái. A mákái mákte kopkom no mák pakta, má kápate mánán ngo ngádáh a apuar pasi ngoi. ");
INSERT INTO sgz_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Bim sang a mon i kán rakrakai suri apakta i namnam ák marán. Kopkobon a táil má namur nirwán, má támin a lu murmur sang. ");
INSERT INTO sgz_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Má ngo wán a matuk, ki ák il pasi i pákánbung án ililur.” ");
INSERT INTO sgz_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Mái Iesu a parai si di mul ngo, “Gita toh arwat pasi lolsit káián ái Káláu mai dánih? Má dánih á pinpidan artálár gita parai ur on? ");
INSERT INTO sgz_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","A arwat mai kotlin kali ngo di soi a gengen. ");
INSERT INTO sgz_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Má namur a kopkom, má ái a pakta i di á bos kubau no, má ák oboi tara rákán arsagil. Má bos man di kis i tan rákán má dik pákpák on má dik páhiuh on.” ");
INSERT INTO sgz_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","34","Mái Iesu a para tari marán pinpidan artálár singin matananu. Kápate arbin mam tekesi worwor, pinpidan artálár sár arwat sang mai mánán kándi matananu, má kápate para te worwor artálár mul na sorliwi kándi mánán. Mái sár i pákánbung kán kalilik án aratintin masik di kis i narsán, a apos tari muswan on si di. ");
INSERT INTO sgz_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","I bung erei sang i ronron, ái Iesu a parai singin kán kalilik án aratintin ngoromin, “Git má urada i risán dan taliu tilada.” ");
INSERT INTO sgz_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Má di sa uri mon er ái Iesu a kis pagas on má dik han alari matananu. Di han ngorer má te mon mul di tiklik mai. ");
INSERT INTO sgz_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Di lu hanhan tangrai dan taliu, mái Iesu a han bopbop iatung i muir mon má a oboi lul i luran mák boptin. Má namur tilik bát a hut, má pákán nah a aptur mák turpasi pitlák uri mon. Má tan kalilik án aratintin di mákái ngorer má dik mátut, má dik áplas Iesu má dik parai singin ngo, “Tám Aratintin, kápute hol pas git? Gita kong!” ");
INSERT INTO sgz_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Mái Iesu a pán mák tur kári kihkih má a parai singin dan ngo, “Una matau!” Má kihkih a aunges má dan a siaroh. ");
INSERT INTO sgz_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Mái Iesu a parai singin kán kalilik ngo, “Gam mátut suri dáh? Káp kamu te ruruna?” ");
INSERT INTO sgz_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Má di lala pángáng má dik worworwor arliu i di sang ngoromin, “Matngan kálámul ngádáh á minái kihkih má dan diar taram singin?” ");
INSERT INTO sgz_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Má namur ái Iesu tiklik mai kán kalilik án aratintin di hut ada i balsán dan taliu tilada, i balis á Gadara, má balis er di utngi mul ngo Dekapolis. ");
INSERT INTO sgz_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ái Iesu a sosih alari mon má a banai kesá kálámul sápkin tanián a porta on. Kálámul erei a lu kis i lár án tahun buli, ");
INSERT INTO sgz_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","má bos tárgun kálámul dikte mat, ái á kán rum a lu bop on. Má kápte kes a arwat suri na kabat páptai kálámul erei. Marán á bung di lu kápti keken má limán mai sen, mái sár a lu tamutái. Kápte kesi kálámul a arwat suri na abálbálái. ");
INSERT INTO sgz_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","I bosbos nas má i libung no, kálámul erei a lu kis iatung i katbán lár má a lu kis i pungpung, má a lu lala wakwak má a lu tártár kalengnai kápán páplun mai sepen hat. ");
INSERT INTO sgz_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Má i pákánbung er a mák pas Iesu tilamudi tepák, ki ák rut melek má a pur dirtapul i mátán táil ái Iesu. ");
INSERT INTO sgz_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ái Iesu a mákái ngorer má a parai singin sápkin tanián a porta i kálámul er ngo, “Sápkin tanián, una táu alari kálámul erei!” Má sápkin tanián a lala kilkil ngoromin, “Iesu, Natun ái Káláu Konom Sorsorliu, suri dáh u soksok iau? Iau lala sung iáu i ngisán ái Káláu suri koion una arangrangas i iau.” ");
INSERT INTO sgz_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Mái Iesu a gátnai ngoromin, “Sinih á ngisam?” Má a kosoi ngo, “Ngisang sang ái Marán, kabin gim tara marán.” ");
INSERT INTO sgz_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Má a lala sung Iesu suri koion na tarwa di ur tepák. ");
INSERT INTO sgz_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Má i pokon er, kesi numán bor di lu namnam iatung i risán pungpung. ");
INSERT INTO sgz_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Má bos sápkin tanián di mákái ngorer má dik tang narsá Iesu suri na tarwa akusak di i bos bor erei. ");
INSERT INTO sgz_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Io, mái Iesu a taram i di má ák long pala di má dik han alari kálámul erei má ding kusak uri bos bor keskeskes. Má tan bor dik ngul má di no di rut sosih uradi dan taliu, má ding kong má dik mat. Má tan bor erei di arwat mai aru i arip á bor. ");
INSERT INTO sgz_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Má tan tám ololoh bor di mákái ngorer má dik táu. Di han má dik para sarai iatung i bimán rum erei má tangrai tan malar mul, má marán kálámul di han suri mákái, ");
INSERT INTO sgz_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","má di hut si Iesu má dik mákái kálámul erei tungu a káng mai sápkin tanián. Di mákái a kis pau má ákte sulu kaleng má ákte hut kaleng mul i kán lain hol. Má ngo di mákái ngorer ki dik lala mátut. ");
INSERT INTO sgz_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Mái rung nengen di mákái táit a longoi ái Iesu mai kálámul minái, di bitái matananu er di hutngin hut suri mákái kálámul er tungu bos sápkin tanián di porta on, má dik bit di suri tan bor mul. ");
INSERT INTO sgz_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Mái rung di mákái kálámul erei, di turpasi sung Iesu suri na han alari kándi malar. ");
INSERT INTO sgz_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Io, má ngorer ái Iesu a sa uri mon ngo na han, má kálámul erei tungu a káng mai sápkin tanián a sung Iesu ngo ái mul na han tiklik mam Iesu má nák mur on. ");
INSERT INTO sgz_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Mái sár ái Iesu kápate sormángát, ki ák parai singin ngo, “Una han uri kam rum narsán rang buham má unák bit di i bos tilik támin táit ái Konom a longoi mam iáu, má ngo ákte mámna iáu.” ");
INSERT INTO sgz_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Má kálámul er a han má a arbin hanhan iatung i balis á Dekapolis uri tilik támin táit ái Iesu a longoi narsán, má matananu di pánsálngát on. ");
INSERT INTO sgz_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Mái Iesu tiklik mai kán kalilik án aratintin di polas kaleng uranang kesá balsán dan taliu, má lala matananu di hut talum narsán iatung i kon. ");
INSERT INTO sgz_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mái Iairus, kesi pakpakta tili rumán lotu i malar er, a tapam hut má a dirtapul i mátán táil ái Iesu ");
INSERT INTO sgz_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","mák lala sungi. Má a parai ngoromin, “Natung tahlik a sángul mai aru sár á kán bet, páput má na mat. Una lákám unák top i natung suri sasam erei nák rah alari má nák sengsegeng kaleng.” ");
INSERT INTO sgz_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Mái Iesu a longrai ngorer má a han tiklik mai kálámul erei. Má marán matananu di mur on má dik siuti. ");
INSERT INTO sgz_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Má kesá wák iatung a sasam mai dár arwat mai sángul mai aru á bet. A mákái kalang má dár kápate rah. ");
INSERT INTO sgz_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Má a rah i kán pirán tabal suri huli tan tám latlat má kápate liu. Kápdite tángni. Di tari rangrangas sár singin má sasam erei a lu pakpakta sár. ");
INSERT INTO sgz_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Má wák er ákte longrai arbin sur Iesu, má ngorer a láklák namurwai i katbán matananu mák singli lusán, ");
INSERT INTO sgz_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","kabin a hol on ngoromin, “Ngo ina tu singli lusán sár, ki inak sengsegeng.” ");
INSERT INTO sgz_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ngorer má wák erei a singli lusán ái Iesu, má káp melek sár dár er a lu sal a ekesi más mák rah, má wák a áslai i kápán páplun ngo kán sasam ákte bokoh. ");
INSERT INTO sgz_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Má i pákánbung a singli lusán ái Iesu á wák erei, ái Iesu a áslai ngo kán te risán rakrakai ákte bokoh, má káp melek mul a tur kaleng i katbán matananu mák gálta ngo, “Sinih er a top i lusán i iau?” ");
INSERT INTO sgz_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Má kán kalilik án aratintin di longrai má dik parai singin ngoromin, “Má suri dáh u gátna ngorer? Kápute mákái matananu erei di káng kalar iáu?” ");
INSERT INTO sgz_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mái Iesu a mákmák aririu i di suri kálámul a longoi ngorer mai. ");
INSERT INTO sgz_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Wák erei a longrai mák lala mátut kabin ái a longoi táit erei, má a han ák pur dirtapul i mátán táil ái Iesu má a para aposoi kán sasam singin. ");
INSERT INTO sgz_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Mái Iesu a mákái ngorer má a parai singin ngo, “Wákán, kam ruruna ákte aliu pas iáu. Una han má na matau i balam. Ukte sengsegeng má alari kam sasam.” ");
INSERT INTO sgz_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ngo a lu worworwor besang, te di hut tilamuni rum káián pakpakta erei má dik parai singin ngo, “Ákte mat mái natum. Má suri dáh ái Tám Aratintin na han suri mákái?” ");
INSERT INTO sgz_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mái Iesu kápate longra pasi kándi arbin. A parai si Iairus ngoromin, “Koion una ráuráuwas. Una ruruna sár.” ");
INSERT INTO sgz_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Mái Iesu a tur kári matananu suri koion da mur on. Ditul sár ái Petero mái Iakobo mái Ioanes tuán ái Iakobo di han tiklik mai. ");
INSERT INTO sgz_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Má namur di han purut iatung i rum káián pakpakta er, mái Iesu a mákái lala matananu kándi tu tang má di lala wakwak. ");
INSERT INTO sgz_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Mái Iesu a kusak mák parai si di ngo, “Gam lala tang suri dáh? Kalik átlái erei sinih ngo a mat, a boptin sár.” ");
INSERT INTO sgz_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Má di longrai ngorer má dik lala nongnai. Mái Iesu a bit rangas uri narsá di ngo da so. Má ngo dikte so no, a long pas kákán mái mámán kalik átlái er má diar tiklik mai, má kán atul i kalik án aratintin mul, má dihat kusak uri rum er kalik átlái a bop ái. ");
INSERT INTO sgz_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Mái Iesu a top i limán kalik átlái er má a parai singin ngo, “Talita kumi!” Sálán á pinpidan erei ngoromin, “Lik, iau parai singim, una aptur!” ");
INSERT INTO sgz_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Má kalik átlái er, a sángul mai aru i kán bet, a aptur melek má a láklák. Mái rung er di mákái di lala pánsálngát on. ");
INSERT INTO sgz_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Má namur ái Iesu a parai si di ngo da támri kalik átlái er nák namnam, má a tur kalar di suri koion da para sarai táit erei. ");
INSERT INTO sgz_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Mái Iesu a han alari malar er má a han uri kán malar sang, má kán kalilik án aratintin di mur on. ");
INSERT INTO sgz_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Má i bungán aunges a aratintin iatung i rumán lotu, má marán di longrai má dik sodar suri, má dik parai ngoromin, “Kálámul min a mánán ngádáh á bos táit minái? Matngan mánán ngádáh á min? Til ái á rakrakai er ák longoi bos akiláng mai? ");
INSERT INTO sgz_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Wa ái ái koner sár a tám long rum, erei natun ái Maria. Má rang tuán minái narsá git, ái Iakobo mái Iosep mái Iudas mái Saimon. Má rang kukun di minái mul.” Má ák sák i bál di ur on, má dik para sáksáknai ngoromin, “Má suri dáh a apakta on?” ");
INSERT INTO sgz_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ái Iesu a longrai má a parai si di ngoromin, “Tám worwor tus, di lu rumrum on i malar tepák. Ái sár i kán malar muswan mái narsán rang buhán má i kán rum sang, kápdite lu rumrum on.” ");
INSERT INTO sgz_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Má ngorer kápate arwat mul ngo na long te marán akiláng iatung i malar er kabin kápdite ruruna. A oboi limán i te sasam sár má dik liu. ");
INSERT INTO sgz_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Má a pánsálngát suri matananu kápdite ruruna on. Io namur má, a lu hanhan má a lu arbin tangrai bos malar. ");
INSERT INTO sgz_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Mái Iesu a kilkila pasi kán sángul mai aru á kalik uratung i narsán mák tarwa rururu i di, má a tari nokwan si di suri da long sarai sápkin tanián. ");
INSERT INTO sgz_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Má a inau i di ngo da top i buk án láklák má bákbákar kek má kesi sulu sár, koion na ru. Má kápdate kip te táit mul uri kándi inan. Koion á balbal, koion á rat, koion á pirán tabal. ");
INSERT INTO sgz_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Má a parai si di ngoromin, “Ngo gama hut i kesá malar má gamáng kusak i kesi rum, gama kis áklis on pang i bung gama han alari malar erei uri lite malar. ");
INSERT INTO sgz_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Má ngo kesi malar kápnate árár pas gam má kápnate longra pasi kamu pinpidan, gama tinra palai rah tili kik gam i pákánbung gama aptur alari malar er. Gama longoi ngorer suri para inngasi ngo kándi sápkin a kis pagas i káil i di sang.” ");
INSERT INTO sgz_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Má ngorer kán kalilik án aratintin di han má dik arbin ur singin matananu ngo da hol kaleng. ");
INSERT INTO sgz_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Má di long palai marán sápkin tanián, má dik oboi mudán wel i lul bos sasam má dik aliu pas di. ");
INSERT INTO sgz_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mái Erodes, kabisit til Galiláiá, a longrai arbin sur Iesu ákte arkaliut. Má te di parai ngoromin sur Iesu, “Ái Ioanes Tám Arsiu ákte liu kaleng alari minat, má ngorer ák mon i kán rakrakai suri longoi bos akiláng erei.” ");
INSERT INTO sgz_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Te di parai ngo Elaisa, má te mul di parai ngo kesá tám worwor tus ngoro bos tám worwor tus til hirá. ");
INSERT INTO sgz_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mái Erodes a longrai má a parai ngoromin, “Ái Ioanes sár er, tungu iau kut kus palai lul. Ákte liu kaleng.” ");
INSERT INTO sgz_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Káplabin worwor erei a ngoromin. Tungu sang, ái Ioanes a liu be, a worwor rakrakai uri mátán ái Erodes suri kesi sápkin tatalen a longoi. A parai ngoromin, “Ukte ras pas Erodiá, wák si tuam ái Pilip, má kápate nokwan.” Má ngorer a mos i bál diar ái Erodes diar mokson. Má namur ái Erodes a lala holhol sur kán wák, má ák tarwai wor ngo da kabat pas Ioanes uri rumán batbat kalar. ");
INSERT INTO sgz_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Io, dikte longoi ngorer, ái sár kán togor ái Erodiá a kis pagas i bál má a nem ngo na up bing Ioanes. A lala nem on ngorer, ái sár kápate arwat ");
INSERT INTO sgz_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","kabin ái Erodes a rumrum i Ioanes má a mánán ngo tám nokwan má tám pilpil, mái Erodes a ololoh on. A gas i bál suri longrai kán arbin, mái sár a lala ngátngát sálán, má ngorer áng kis kálár. ");
INSERT INTO sgz_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Má namur ái Erodiá a ser pasi sál ngoromin. Ái Erodes a longoi kesá tilik lala namnam. A hol pasi bung er a káhái on ái mámán. A longoi lala namnam má a kilkilai marán kálámul. Má di han á tan kálámul kuluk má bos pakpakta kán bos tám arup má bos pakpakta tili balis á Galiláiá. ");
INSERT INTO sgz_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Má i pákánbung er, natun tahlik ái Erodiá a kusak mák mil. Mái Erodes mái rung di namnam tiklik mai, di lala nem on. Má ngorer ái Erodes a parai singin kalik átlái er ngoromin, “Iau nem ngo una sung iau sur kam te arul er iáu nem on ina tari singim!” ");
INSERT INTO sgz_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Má a oror mam kukun ngoromin, “Te táit una sung iau suri, ina tari singim. Má ngo una sung iau sur te risán i kak minsik er iau kátlán, ina tari risán singim.” ");
INSERT INTO sgz_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Má kalik átlái erei a so má a gátna mámán ngo, “Dánih u nem on ngo ina sungi?” Mái mámán a parai singin ngoromin, “Una sungi suri lul ái Ioanes Tám Arsiu.” ");
INSERT INTO sgz_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Má kalik átlái erei a kusak kaleng melek narsá Erodes má a sungi ngoromin, “Iau nem i lul ái Ioanes Tám Arsiu. Inái sár una oboi i map má unák tari singing.” ");
INSERT INTO sgz_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ái Erodes a longrai ngorer mák tuan sák i bál suri, ái sár ákte oror i mátán bos kálámul pakta má a rumrum suri na tah kusi kán oror. ");
INSERT INTO sgz_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Má ngorer a sangar i dos palai kesi tám arup suri tah kusi pogong a Ioanes má náng kipi lul. Má tám arup erei a han má a tah kusi pogong a Ioanes iatung i rumán kamkabat. ");
INSERT INTO sgz_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Má a oboi lul ái Ioanes i kesi map má áng kip tari singin kalik átlái. Má kalik átlái erei a top pasi má ák tari si mámán. ");
INSERT INTO sgz_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Má namur kalilik án aratintin káián ái Ioanes di longrai, má dik han má ding kip pasi kápán páplun má dik tahni i matmat. ");
INSERT INTO sgz_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Má tan apostolo erei, di á sángul mai aru á kalik án aratintin ái Iesu a ilwa pas di, di han arsagil uri tan malar. Má namur di kaleng mul uri narsá Iesu, má dik para talsai singin á bos táit di longoi má pinpidan di tari singin matananu. ");
INSERT INTO sgz_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Má marán matananu di káng narsá Iesu má kán kalilik án aratintin, má kápate arwat ngo da namnam. Má ngorer Iesu a parai si di ngo, “Gam lákám. Giták han uri pokon kápte kálámul on, má giták aunges.” ");
INSERT INTO sgz_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Má di masik di aptur má di han i mon uri pokon kápte kálámul on. ");
INSERT INTO sgz_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Má marán kálámul má wák di mák di di han, di mák ilam di má dik rut talum tili kandi tan malar má dik purut táil iatung i suan ngo ái Iesu na masar on. ");
INSERT INTO sgz_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Má namur ái Iesu a tapam hut mák mákái tilik lala matananu má a mámna di. A mák di di ngoro tan sipsip kápte te kák di, má a lala atintin di uri marán táit. ");
INSERT INTO sgz_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ákte páput má nák dorah i nas, má kán kalilik án aratintin di hut má dik parai si Iesu ngo, “Minái pokon mau má nas ákte páput má na dorah. ");
INSERT INTO sgz_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Una dos pala di uri bos malar suri dák hul namnam ándi.” ");
INSERT INTO sgz_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Mái Iesu a kos di ngoromin, “Á gam sang gama tabar di.” Má dik parai ngoromin, “Wa u tu ret si gim! Ngo na mon i kángit te na ru i mar á pirán tabal, kápnate arwat mul mai lala matananu minái!” ");
INSERT INTO sgz_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Mái Iesu a longrai ngorer má a gátna di mul ngo, “A is á balbal erei di kipi? Gam mákái be.” Di mákái má di kaleng má dik parai singin ngo, “Alim i tigán balbal má aru i isu.” ");
INSERT INTO sgz_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Má a parai singin matananu suri da tam purwa di uri tan huhu má dák sukis iatung i poron ur. Má ngorer matananu dik tam purwa di sang uri tan kiskis, te alim i sángul á kálámul on, má te kiskis kesá mar á kálámul on, má dik sukis má. ");
INSERT INTO sgz_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Má namur ái Iesu a top pasi alim á tigán balbal erei turán aru isu má ák tántán uramuni bát mák sung kári. Io, ák tibi balbal turán isu má ák tari singin kán kalilik án aratintin suri dik tulsai i matananu. ");
INSERT INTO sgz_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ngorer di no di namnam má dik mas. ");
INSERT INTO sgz_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","44","Má tan kálámul no iatung di arwat mai alim i arip á káláu, má boh wák má kalilik kápte di wás di. Má namur tan kalilik án aratintin di dungi sángul mai aru i kas má ding káng mai tan tigán balbal má isu er di an tigán. ");
INSERT INTO sgz_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Má káp melek ái Iesu a dos palai kán kalilik án aratintin suri da táil uri risán dan taliu i malar á Betesaida, má ái na tarwa palai besang i matananu ki nák mur. Má kán kalilik án aratintin di sa uri mon má dik han. ");
INSERT INTO sgz_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Má ngo ákte tarwa palai matananu, ái Iesu a tapam uramuni pungpung suri na sung. ");
INSERT INTO sgz_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Má ngo ákte ronron má, bos kalilik án aratintin di iatung i mon i katbán dan taliu, mái Iesu masik be iatung i pungpung. ");
INSERT INTO sgz_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Mái Iesu a mák di di ngesmat i alus kabin bát a hut tilamuda i táil i di. Io mái pákánbung kok a tang i kuir libung besang, ái Iesu a láklák iamuni kápkápán dan. A láklák ngo na sorliu di, ");
INSERT INTO sgz_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","má ngo di mák pasi, di ráuráuwas má dik lala wakwak. Di hol on ngo tesit. Mái Iesu a teken bin ur si di ngo, “Gama mangan! Koion gama mátut, á iau sár á min.” ");
INSERT INTO sgz_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","Mái Iesu a sa uri mon narsá di má bát a aunges. Má kán kalilik án aratintin di mákái ngorer má dik lala pángáng kabin kándi hol a kuron. Kápdite mák ilmi be i sálán táit ái Iesu a longoi er a támri matananu mai balbal má isu. ");
INSERT INTO sgz_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Má ngo dikte polsai dan taliu má dik hut á Genasaret, ding kabat páptai mon uramuni kon, ");
INSERT INTO sgz_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","má dik han alari. Má matananu tilatung di mák ilam Iesu, ");
INSERT INTO sgz_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","má di tam han arsagil uri bos malar má ding kipi bos sasam mai kim di uratung narsá Iesu. ");
INSERT INTO sgz_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Má ngo a kusak uratung i gengen malar ngo i malar pakta, di oboi bos sasam iatung i kándi nián hut talum má dik sung Iesu ngo da tu singli sár i nomnobon lusán. Mái rung di singli, di no di sengsegeng. ");
INSERT INTO sgz_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Te á bos Parisaio má te á bos tám mánán uri nagogon tilami Ierusalem, di hut talum narsá Iesu. ");
INSERT INTO sgz_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Di mákái ngo te tili di á bos kalilik án aratintin di namnam má kápdite ililim táil, pasi dik hol on á bos Parisaio ngo di longoi sápkin tatalen uri mátán ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Kabin di á bos Parisaio má matananu á Iudáiá no di mur i arabitbit kán rang támin i di ngoromin: kápdite lu namnam ngo kápdite ililim táil ngorer i kandi tatalen. ");
INSERT INTO sgz_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Má ngorer mul ngo di han uri pokon án sirsira ki dáng kaleng, dák mulán siusiu má namur da namnam. Má ngorer mul di mur i tatalen suri gorsa kinleh má kuro má tan táit di longoi uri tutun. ");
INSERT INTO sgz_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Io, tan Parisaio má tan tám mánán erei dikte mákái ngorer má dik gátna Iesu ngoromin, “Ngádáh, kam kalilik án aratintin kápdite mur i arabitbit káián rang támin i git? Di namnam, má kápdite ililim táil besang.” ");
INSERT INTO sgz_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Mái Iesu a kos di ngo, “Kán pinpidan ái Káláu i buk káián ái Aisaia tám worwor tus ákte para táilnai ngo gam á bos tám tuar er ák para ngoromin, ‘Kabinhun erei di rumrum i iau mai kápán ngus di sár, má bál di a tepák alar iau. ");
INSERT INTO sgz_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Di lu arabitbit sár mai nagogon káián rang támin i di má dik parai ngo worwor káián ái Káláu, má ngorer dik omlawai kándi lotu uri narsang.’” ");
INSERT INTO sgz_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mái Iesu a parai mul si di ngoromin, “Gam lala balantahun palai nagogon káián ái Káláu, má gam murmur sár i tatalen matananu di abitbit gam mai.” ");
INSERT INTO sgz_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Má a sopasun kán worwor mul mák parai si di ngo, “Gam lala mánán taladeng i hol palai arardos káián ái Káláu suri gama lu mur i kamu arabitbit. ");
INSERT INTO sgz_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ái Moses a para ngoromin, ‘Una rumrum i kakam mái mamam.’ Má kes mul, ‘Ngo kálámul a worwor sáksák i kákán mái mámán, da up bingi.’ ");
INSERT INTO sgz_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ái sár gamáte pukdai má gam lu parai ngoromin. A arwat suri kálámul a mon i kán pirán tabal uri tangan kákán mái mámán, má namur ák han uri narsá diar mák parai si diar ngoromin, ‘Pirán tabal minái uri tangan gaur, mái sár ina tari má ur káián ái Káláu.’ ");
INSERT INTO sgz_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ngo gam mákái ngorer, gam parai ngo kálámul er a sengsegeng alar kákán mái mámán, má kápte má na te tangan diar mul, kabin ngo pirán tabal er a obop páksi uri tangan diar, ákte tari má ur si Káláu. ");
INSERT INTO sgz_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Gam lu parai ngorer, má i sál sár erei gam hol sirereh i pinpidan si Káláu suri gama lu mur i kamu arabitbit sang. Má gam lu longoi ngorer mai toltolom táit mul.” ");
INSERT INTO sgz_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Mái Iesu a kilkila pasi mul i matananu mák parai si di ngoromin, “Gam no erei gama longra pasi worwor minái suri gamák talas ur on. ");
INSERT INTO sgz_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tan táit tili karpala er a kusak urami bál kálámul, kápnate long adurwán on i mátán táil ái Káláu. Kápte. Má táit a han pas tilami hol kán kálámul, ái a long adurwán on. ");
INSERT INTO sgz_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ái koner a nem ngo na talas má na mánán, ki na kis án alongra!” ");
INSERT INTO sgz_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ái Iesu a parai ngorer má a han alar di, máng kusak i kesi rum tiklik mai kán bos kalilik án aratintin, má namur dik gáltai suri pinpidan artálár erei. ");
INSERT INTO sgz_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Mái Iesu a parai si di ngo, “Á gam mul, gam ngul besang? Kápgamte mánán be ngo namnam erei a kusak i kes kápnate long adurwán on i mátán ái Káláu ");
INSERT INTO sgz_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","kabin kápate kusak urami kán hol. A kusak sár uri pagarbal má namur ák pek palai.” Má ngorer ái Iesu a para talsai ngo namnam no a kuluk sár. ");
INSERT INTO sgz_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Má a parai mul ngoromin, “Táit a lu so pas tilami hol kán kálámul, ái sang a lu long adurwán on i mátán ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kabin tilami hol kán kálámul a so i tan sápkin tatalen ngoromin: hol sáksák, araturán sáksák, siksikip, up bingi kálámul, ");
INSERT INTO sgz_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","bop mai wák káián lite, kon suri táit, bos matngan sápkin tatalen, agurái kálámul, tatalen ngoro pap, bálsák, para bengtai kálámul, hol apakta pasi, tatalen án bau. ");
INSERT INTO sgz_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Bos sápkin tatalen no erei a tapam hut tilami hol kán kálámul, má a tubán long adurwán on sang i mátán táil ái Káláu.” ");
INSERT INTO sgz_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Má namur ái Iesu a aptur alari malar erei, má a han uri balis á Tair má Sidon mák han uri kesi malar mák han kusak i kesi rum. Kápate nem ngo tekes na mánán on, mái sár kápate arwat ngo na punpunam. ");
INSERT INTO sgz_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Má kesá wák tili balis á Siria Ponisia, má ái sang a wák tili risán, a mon i kesi natun tahlik sápkin tanián a kusak on. Má wák erei a longrai ngo ái Iesu a kis i rum er, má a hut melek má a pur dirtapul i mátán táil ái Iesu, má ák sungi ngo na long palai sápkin tanián alari natun. ");
INSERT INTO sgz_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ái sár ái Iesu a mákái ngo wák erei kápte ngo ái á tah Iudáiá, má ngorer a parai singin ngo, “Da tabar amasi bos kalilik táil. Má kápate arwat ngo da kip palai balbal áián bos kalilik suri da támri bos pap mai.” ");
INSERT INTO sgz_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Má wák erei a longrai ngorer mák parai singin ngoromin, “A muswan, konom, ái sár bos pap i lalin suh án namnam, di lu ani bos mulen namnam áián bos kalilik.” ");
INSERT INTO sgz_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Má ngorer ái Iesu a parai singin ngo, “Kabin kam kokos a tuan kuluk, ngorer una kaleng má unák mák natum tahlik. Sápkin tanián ákte han alari má.” ");
INSERT INTO sgz_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Io, má ngorer wák er a kaleng mák mákái natun tahlik ákte liu mák bop matau i kibán. Sápkin tanián ákte han alari. ");
INSERT INTO sgz_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Mái Iesu a han alari balis á Tair má a mur i sál uranang Sidon mák som kus uri balis á Dekapolis, má namur ák han hut i dan taliu á Galiláiá. ");
INSERT INTO sgz_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mái rung tilatung di lam pasi kesi kálámul uri narsá Iesu. Kálámul er káp a tini wor kuluk má talngán a bau, má dik sungi suri na aliu pasi. ");
INSERT INTO sgz_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Mái Iesu a lam pasi kálámul erei suri diar masik, má a asolai kátngán limán i aru talngán. Má namur ái Iesu a kansi kátngán limán má a tokoi kermen kálámul mai. ");
INSERT INTO sgz_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Mái Iesu a tántán urami bát má a mangeh arkul mák parai singin kálámul mai worwor til Iudáiá ngoromin, “Epata”, sálán á pinpidan erei ngo ‘Na talas’. ");
INSERT INTO sgz_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Má talngán má ngudun kálámul erei a pasbat má a alongra kuluk má a talas i kán worwor. ");
INSERT INTO sgz_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Má namur ái Iesu a parai singin matananu ngo, “Koion gama parai singin tekes.” Má a lu balbal tur kalar di, mái sár á di di tungai arbin sara mai. ");
INSERT INTO sgz_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Má dik lala pángáng suri, má dik parai ngoromin, “A long kulukna pasi bos táit no. A timani tan bau suri dik alongra má tan rung a su i kerme di suri dik worwor.” ");
INSERT INTO sgz_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Má namur marán matananu di hut mul i narsá Iesu i pokon bia. Di kis i malar erei, má ándi namnam ákte rah. Mái Iesu a mákái ngorer máng kilkilai kán kalilik án aratintin uratung i narsán mák parai si di ngo, ");
INSERT INTO sgz_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Iau lala mámnai matananu minái di kis tiklik mam git arwat mai atul á bung má káp ándi te namnam má. ");
INSERT INTO sgz_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ngo ina tarwa pala di mai matpám uri kándi bos malar, te da bámbámrus hanhan tangra sál kabin te a tepák i kándi malar.” ");
INSERT INTO sgz_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Má kán kalilik án aratintin di parai si Iesu ngo, “Til ái á te balbal á main i pokon bia min suri gita támri matananu minái mai?” ");
INSERT INTO sgz_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Mái Iesu a gálta di ngoromin, “A is á balbal erei si gam?” Má dik mákmák má dik parai ngo, “Ahit sár.” ");
INSERT INTO sgz_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Mái Iesu a parai singin matananu ngoromin, “Gama kis iatung i bim.” Má namur a kip pasi ahit á balbal mák sung kári, ki ák tibi mák tari singin kán kalilik án aratintin suri dik támri matananu mai. ");
INSERT INTO sgz_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Má a mon mul i te gengen isu iatung, mái Iesu a long pasi mák sung kári, má ák tari singin kán kalilik án aratintin mák parai si di ngo da tulsai i matananu. ");
INSERT INTO sgz_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Di no di namnam on má dik mas. Matananu di hut talum ahat i arip, má kápdite long arwat on ngo da arahi namnam erei. Má kalilik án aratintin si Iesu di kip talmi tigán balbal erei di mas tigán uri ahit i kudut. Má namur ái Iesu a dos pala di uri kándi bos malar. ");
INSERT INTO sgz_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Mái Iesu má kán kalilik án aratintin, di sa uri kesá mon má dik han uri balis á Dalmanuta. ");
INSERT INTO sgz_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Má pákánbung di longrai ngo ái Iesu ákte hut, te bos Parisaio di han gátna pasi má dik parai singin ngo, “Una long tekesá akiláng tilami bát suri inngasi ngo rakrakai káián ái Káláu a kis i narsam.” ");
INSERT INTO sgz_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ái Iesu a longrai má a tuan taun uri kán liu mák mangeh arkul mák parai ngoromin, “Suri dáh matananu minái di nem ngo da mákái matngan táit ngorer? A muswan iau parai si gam, káp ina te long tekesi akiláng suri matananu minái da mákái.” ");
INSERT INTO sgz_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ái Iesu a be parai ngorer ki ák han alar di iatung mák roh kaleng uri mon tiklik mai kán kalilik án aratintin uranang i balsán dan taliu tilanang. ");
INSERT INTO sgz_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","I pákánbung di lu hanhan tangrai dan taliu mai mon, kán tan kalilik án aratintin di barung, kápdite kip te balbal suri na arwat mai kándi inan. Tukes sár á tigán balbal a kis. ");
INSERT INTO sgz_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Mái Iesu a inau i di ngoromin, “Gama ololoh na káp porta i gam i tatalen káián tan Parisaio má si Erodes. Kándi tatalen erei na káp sinim i gam ngorer i yis a sinim i palawa.” ");
INSERT INTO sgz_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Mái sár kápdite talas ur on, má dik argátna arliu i di ngoromin, “Dánih a worwor suri? A kabin káp ángit te namnam, be?” ");
INSERT INTO sgz_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Mái Iesu a mák ilmi uri kándi hol mák parai si di ngoromin, “Suri dáh gam lala worwor suri ngo káp amu te namnam? Kápgamte talas besang uri iau? Bál gam a laklak? ");
INSERT INTO sgz_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mát gam erei kápgamte mákmák ilam mai má talngá gam er kápgamte alongra tus mai? Ngádáh, kápgamte lu hol páptai tan táit gam lu mákái? ");
INSERT INTO sgz_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","I bung iau tabar amasi alim i arip á kálámul mai alim i balbal má aru i isu, gam kipi a is á kudut a káng i tigán namnam di mas tigán?” Má ding kosoi ngo, “Gim oboi sángul mai aru.” ");
INSERT INTO sgz_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Má ák gálta di mul ngoromin, “Má i pákánbung er iau tibi ahit á balbal ur singin matananu di arwat mai ahat i arip á kálámul, gam akángái a is á kudut mai tigán balbal a lu kis?” Di parai singin ngo, “Gim oboi ahit á kudut.” ");
INSERT INTO sgz_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Mái Iesu a parai si di ngo, “Ki ngádáh, kápgamte talas be?” ");
INSERT INTO sgz_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ái Iesu má kán kalilik án aratintin di hut á Betesaida, má te kálámul di kipi kesi kálámul a rau uri narsán ái Iesu má dik sung Iesu ngo na singli. ");
INSERT INTO sgz_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Mái Iesu a top pasi limán mák lam pasi má diará han uri pokon mau alari malar. Má namur ái Iesu a kansi mátán mák oboi limán on mák gáltai ngo, “Ngádáh, u mák te táit á erei?” ");
INSERT INTO sgz_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Má kálámul er a tohoi mákmák mák parai ngo, “Áá, iau mákái tan kálámul ngorer i kubau, mái sár di láklák.” ");
INSERT INTO sgz_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Mái Iesu a oboi mul i limán i mátán kálámul er a rau. Má namur kálámul er a lala mákmák rakrakai mák mákmák kaleng, má ák lain mák noi bos táit. ");
INSERT INTO sgz_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Mái Iesu a wor rakrakai uri narsán mák tur kári ngo koion na kaleng uri malar má arbin i táit a longoi mai. ");
INSERT INTO sgz_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ái Iesu má kán kalilik án aratintin di han má ding kusak i tan malar iatung pátmi Sisaria Pilipoi. Má ngo di lu hanhan tangrai sál, ái Iesu a gátna di ngoromin, “Matananu di lu parai sur iau ngo iau sinih?” ");
INSERT INTO sgz_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Má ding kos Iesu ngo, “Te kálámul di parai ngo iáu ái Ioanes Tám Arsiu, má te bul di parai ngo iáu ái Elaisa, má te kálámul sang di parai ngo iáu kesi tám worwor tus til hirá.” ");
INSERT INTO sgz_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Mái Iesu a longrai di kosoi ngorer má a gátna di mul ngoromin, “Má á gam sang, gam ngoi ngo iau sinih?” Mái Petero a kos Iesu mul ngo, “Á iáu á Mesaia.” ");
INSERT INTO sgz_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Mái Iesu a tur kalar di ngo koion da parai singin tekes. ");
INSERT INTO sgz_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Má a turpasi aratintin mul narsán kán kalilik án aratintin suri bos táit na hut singin má nák long bengtai, mák parai ngoromin, “Natun Kálámul na hiru sang má dák arangrangas on á bos kálámul pakta má bos pakpakta kán tan tám osmapak má bos tám mánán uri nagogon. Da pua palai má da oboi uri minat. Má ngo na rah i atul á bung, na liu kaleng.” ");
INSERT INTO sgz_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Mái Iesu a para apos tari pinpidan erei suri ák talas. Má ngorer ái Petero a talka pas Iesu suri diar masik má ák turpasi worwor rakrakai ur on suri matngan worwor erei ái Iesu a parai si di. ");
INSERT INTO sgz_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Mái Iesu a ilang mák mákái kán kalilik án aratintin mák tur kalar Petero ngoromin, “Satan, á iáu sár u parai á worwor erei! Una kelkel alar iau! Kápute mánán i káplabin holhol káián ái Káláu. U hol pasi sár i tatalen káián matananu.” ");
INSERT INTO sgz_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Má namur ái Iesu a kilkilai matananu má kán kalilik án aratintin suri da longrai kán pinpidan, má ák parai ngoromin, “Ngo kono a nem suri na mur i iau, koion na murmur i kán hol sang. Na puski kán kubau kus má nák murmur i iau sár mai, ngorer na bál tari sang uri lalin i iau má na eran suri na mat ngoro iau. ");
INSERT INTO sgz_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Má ngorer ngo kálámul a tar kunlai kán liu suri na bes mai tan táit til main i naul bim, ki liu muswan er a kis áklis na bokoh alari. Mái sár ái koner kápate mámnai kán liu mák bál tari sang sur iau má suri lain arbin, ái na atur páptai liu muswan er. ");
INSERT INTO sgz_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ngádáh, a kuluk ngo kálámul na kátlán bos matmatngan táit main i naul bim, má nák omlawa palai kán liu suri? ");
INSERT INTO sgz_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Má dánih á táit ngo na hul kelsei kán liu mai? Kápte sang. ");
INSERT INTO sgz_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Onin i naul matmatngan pokon, matananu di abulbul. Di tari bah di uri Káláu má di ilang suri kándi bos sápkin tatalen. Mái koner a rumrum suri arbin talas uri iau má uri kak pinpidan i katbán matananu, namur Natun Kálámul na rumrum mul singin i pákánbung ngo na kaleng tilami bát tiklik mai minmáir i Kákán má mai bos angelo.” ");
INSERT INTO sgz_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ái Iesu a sopasun kán worwor mák parai ngo, “Támin muswan iau parai si gam, te tili gam minái kápdate áslai besang á minat má dák mákái lolsit si Káláu ákte hut má mai rakrakai.” ");
INSERT INTO sgz_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Má namur ngo ákte rah i awon á bung, ái Iesu a lam pas Petero mái Iakobo mái Ioanes tiklik mai, má dihat má tapam uramuni iátin pungpung suri dihat masik. Má ngo atul i kalik án aratintin erei ditulá mákmák, má ditulá mák Iesu a arkeles. ");
INSERT INTO sgz_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Má lusán a tuan pilpilpil mák bal, mák tuan bal sang ngorer kápte kes til main i naul bim a arwat suri gorsai suri nák bal ngorer. ");
INSERT INTO sgz_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Má namur ditul má mák Elaisa mái Moses diar worwor mam Iesu. ");
INSERT INTO sgz_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Má ditul má mákái ngorer má ditulá lala mátut. Má namur ái Petero a parai si Iesu ngo, “Konom, a kuluk sang ngo git minái. Ngádáh, gimtula long te na tul i pálpálih, kes kaiam má kes káián ái Moses má kes káián ái Elaisa?” A parai ngorer ái Petero káplabin ngo kápate hol pas te lain worwor ngo na parai. ");
INSERT INTO sgz_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Má namur kumlán mehmeh a hut mák ámkuk di, má kaungán kes tilami kumlán mehmeh a para ngoromin, “Minái á kang Kalik alal, gama alongra singin.” ");
INSERT INTO sgz_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Má ditul longrai ngorer má ditulá sangar i mákmák kalar di, mái sár káp ditul te mák tekes mul, ái Iesu masik sár iatung dihat. ");
INSERT INTO sgz_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Má ngo di lu sososih tilamuni pungpung, ái Iesu a tur kalar ditul mák parai ngo, “Koion gama parai singin tekes suri táit gamtul mákái nák han pang i pákánbung ngo Natun Kálámul na liu kaleng tili minat.” ");
INSERT INTO sgz_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Má ngorer ditulá bál konmi worwor si Iesu i bál ditul, má ditulá gátna arliu i ditul ngoromin, “Dánih á sálán er ák parai ngo Natun Kálámul na liu kaleng tili minat?” ");
INSERT INTO sgz_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Má namur ditulá gátnai ngoromin, “Suri dáh bos tám mánán uri nagogon si Káláu di parai ngo ái Elaisa na hut táil sang, má namur ái Mesaia?” ");
INSERT INTO sgz_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Mái Iesu a parai si di ngoromin, “Támin muswan ngo ái Elaisa na hut táil suri na eran i tan táit no. Má iau parai si gam ngo ái Elaisa ákte hut má, ái sár matananu di long sáksáknai mai kándi sápkin holhol ngorer a parai i Buk Tabu. Má iau gálta gam ngoromin. Ngo ái Elaisa ákte hut, má ákte eran páksi tan táit no, suri dáh tan tám worwor tus di parai mul suri Natun Kálámul ngo matananu da arangrangas on má da kankansai?” ");
INSERT INTO sgz_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Má namur ái Iesu dihat dihat purut singin lala matananu di tur kauli bos kalilik án aratintin di arkipkip mai worwor mam te tan tám mánán uri nagogon. ");
INSERT INTO sgz_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Matananu erei di mák Iesu a lu hanhan sur di má dik sodar, má dik rut uratung i narsán má dik árár pasi. ");
INSERT INTO sgz_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Mái Iesu a gátna di ngo, “Dánih gam argátna pas suri?” ");
INSERT INTO sgz_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Má kes tili di á matananu erei a kos Iesu ngoromin, “Tám Aratintin, iau lam pasi natung, kang kalik án káláu, ur singim kabin ngo sápkin tanián a porta on má káp a tini wor. ");
INSERT INTO sgz_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Má ngo a hut singin, a lu buswai uradi bim. Má busbus a lu hut tili ngudun mák lu ararat ngis má kápán páplun a lu dos. Má ngorer iau sungi kam kalilik án aratintin ngo da long palai sápkin tanián erei, mái sár kápdite long arwat on.” ");
INSERT INTO sgz_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ái Iesu a longrai worwor erei mák parai si di ngoromin, “Be, kápgamte ruruna? Na is á bet ina kis tiklik mam gam? Iak ngesmat má, na is á bet mul ina mona gam?” Ngorer mái Iesu a parai si di ngo, “Gama lam pasi kalik ur main.” ");
INSERT INTO sgz_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Má di lam pasi kalik er uri narsán. Má ngo sápkin tanián a mák Iesu, ki sápkin tanián ák agokgokoi kalik er má kalik a pur uradi bim, mák apukpukda on mák hut i busbus tili ngudun. ");
INSERT INTO sgz_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Mái Iesu a gátna kákán ngo, “A turpasi anges á sápkin tanián a porta on?” Mái kákán a parai si Iesu ngo, “A turpasi tili goion on sang. ");
INSERT INTO sgz_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Má marán bung sápkin tanián a lu buswai uri kámnah má uri dan suri ngo nák mat. Má iau sung iáu ngo iáu arwat suri una tángni kang kalik, ki una mámna giur má unák tángni.” ");
INSERT INTO sgz_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Mái Iesu a parai singin ngoromin, “Suri dáh iáu parai ngo iau sang iau arwat? Ái koner a ruruna muswan na long arwat pasi bos táit no!” ");
INSERT INTO sgz_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Má kákán a longrai ngorer mák pala sarai kaungán mák parai ngo, “Inái iau ruruna! Una tángni kak páhngán ruruna!” ");
INSERT INTO sgz_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Mái Iesu a mákái ngo marán matananu di hut talum má di arsiut, má ngorer ák sangar i wor rakrakai uri sápkin tanián erei ngoromin, “Á iáu á sápkin tanián u abawi kalik, má u agapi ngudun má talngán mul, má inái iau parai singim, una táu alari kalik er, má káp una te kusak on mul.” ");
INSERT INTO sgz_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Má sápkin tanián erei a longrai mák wakwak mák agokgokoi kalik mák han alari. Má kalik er a ngoro ákte mat, má marán di parai ngo ákte mat. ");
INSERT INTO sgz_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mái sár ái Iesu a top pasi limán mák tángni ák sámtur. ");
INSERT INTO sgz_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Má namur, ngo ái Iesu di di kusak iatung i rum, kán kalilik án aratintin di gátna kodongnai ngoromin, “Suri dáh á gim kápgimte arwat suri long palai sápkin tanián erei?” ");
INSERT INTO sgz_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Mái Iesu a parai si di ngo, “Matngan sápkin tanián minái, sung masik arwat suri tipar palai.” ");
INSERT INTO sgz_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Má namur di han alari malar er, má di urup i katbán á Galiláiá. Mái Iesu kápate nem ngo tekes na mánán on ");
INSERT INTO sgz_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kabin kán tu atintini kán kalilik án aratintin ngoromin, “Da tari Natun Kálámul uri limán bos kálámul má dák up bingi nák mat. Má ngo na rah i atul á bung, na liu kaleng.” ");
INSERT INTO sgz_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Mái sár kápdite talas uri sálán á worwor er, má dik mátut suri da gátnai. ");
INSERT INTO sgz_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Mái Iesu má kán kalilik án aratintin di hut á Kapernaum, má namur ngo dikte kusak uratung i rum, ái Iesu a gátna di ngoromin, “Dánih gam arpua kunán iatung tangrai sál?” ");
INSERT INTO sgz_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ái sár kápdite kosoi kabin di arpua arliu i di iatung i sál suri ngo ái sinih na pakta i di. ");
INSERT INTO sgz_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Mái Iesu a sukis máng kilkila pasi kán kalilik mák parai si di ngoromin, “Ngo tekes a nem ngo na tátáil, minái á sál na mur on. Na agengen pasi sang má na toptop kamu no sár.” ");
INSERT INTO sgz_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Má a talka pasi kesá gengen kalik uratung i katbán i di máng káh pasi, má a parai si di ngoromin, ");
INSERT INTO sgz_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Koner a tángni kesá gengen kalik ngoromin kabin ngo a mámna iau, kápate tangan masiknai kalik erei, a tangan iau mul. Mái koner a tangan iau ngorer, kápate tangan iau masik. A tangan Koner mul a tarwa iau ur main.” ");
INSERT INTO sgz_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Má kándi tu kis iatung i rum er be, mái Ioanes a parai si Iesu ngo, “Tám Aratintin, gim mákái kesá kálámul a lu tipar palai sápkin tanián mai ngisam. Mái sár kápate ngoro gim, kápate lu murmur i iáu. Má ngorer gimá tur kári.” ");
INSERT INTO sgz_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Má Iesu a parai si di ngoromin, “Koion gama tur kári. Ái koner a long te akiláng mai ngisang, namur kápnate utung te sápkin wor uri iau. ");
INSERT INTO sgz_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ái koner kápate sák mam git, ái á tur git. ");
INSERT INTO sgz_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","A muswan á minái iau parai si gam. Ngo gam gam sák suri dan, má tekesá kálámul a tabar gam mai dan kabin gam káián ái Karisito, kálámul er kápnate sáhár suri kán arul.” ");
INSERT INTO sgz_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Mái Iesu a sopasun i kán aratintin mák parai ngoromin, “Ái rung er di ruruna i iau di ngoro rang natung. Ái koner a lam bengtai kes tili di ái rung di ruruna i iau mák apurái kán ruruna, kálámul er a longoi táit a tuan sák. Ngo da putai tilik lala hat i án pogong á kálámul er má da lápkai urada i lontas, a gengen rangrangas sár. Má rangrangas er na oboi ái Káláu ur on, ái na lala pakta taladeng kabin a long sáksáknai ruruna káián kesi natun ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","“Má ngo kesi limam a lam arong iáu má uk lu longoi sápkin mai, ki a kuluk una tár kus palai. A kálik sák ngo una kusak uri liu áklis mai kesi limam masik, mái sár a lala sák sang ngo na mon i aru limam no má unák hiru áklis i kámnah erei kápate lu mat. ");
INSERT INTO sgz_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","“Má ngorer mul suri kikim. Ngo kesi kikim a lam arong iáu má uk teleh alari lain sál, ki a kuluk ngo una tár kus palai. A kálik sák ngo una kusak uri liu áklis mai kesi kikim masik, mái sár a lala sák sang ngo na mon i aru kikim má dik buswa iáu uri pokon án hiru áklis. ");
INSERT INTO sgz_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Má a ngorer mul suri matam. Ngo kesi matam a lam arong iáu, una bilwak palai. A kálik sák ngo una kusak uri lolsit si Káláu mai kesá matam sár, má a lala sák sang ngo na kis i aru matam no má dák buswa iáu uri pokon án hiru áklis. ");
INSERT INTO sgz_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Iatung i pokon erei tan kolol er kápdite lu mat da an di, má kámnah mul er a kurkurem áklis má kápate lu mat. ");
INSERT INTO sgz_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Kámnah na sinim i matananu keskeskes má nák apilpil pas di ngorer i tas a sinim i namnam má ák amapak on. ");
INSERT INTO sgz_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Tas a kuluk, mái sár ngo ákte rah á kán mapak, ngádáh gama amapak kalengnai ngoi? Má ngorer a kuluk ngo tas án araturán na sinim i gam má gamáng kis án ararguna arliu mai bál matau.” ");
INSERT INTO sgz_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ái Iesu a aptur tilanang Kapernaum má a han uradi balis á Iudáiá má a polsai dan uri risán dan á Ioridan tilada. Má matananu di hut singin mul má ák atintin di ngorer sang a lu longoi ngoi. ");
INSERT INTO sgz_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Má te Parisaio di hut narsá Iesu suri da tohoi má dik gátnai ngoromin, “Ngádáh? A sormángát á kángit nagogon suri ngo kálámul na pásang palai kán wák ngo kápte?” ");
INSERT INTO sgz_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Mái Iesu a gátna kalengna di ngo, “Ngádáh á nagogon ái Moses a tari si gam?” ");
INSERT INTO sgz_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Má ding kosoi ngo, “Ái Moses a sormángát tari pákán ram án pálás kila si di. Ngo tekesá kálámul a nem suri pálás kila, na siri pákán ram er má nák tari singin wák má nák long palai.” ");
INSERT INTO sgz_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Mái Iesu a parai si di ngoromin, “Ái Moses a siri nagogon erei kabin a laklak i bál gam. ");
INSERT INTO sgz_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Hirá sang i akaksim, ái Káláu a longoi káláu má wák. ");
INSERT INTO sgz_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Má erei á káplabin kálámul na aptur alar kákán mái mámán má náng kis tiklik mam kán wák. ");
INSERT INTO sgz_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Má diar no diara tukes sár. Kápnate ru i diar, diara tukes. ");
INSERT INTO sgz_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Má ngorer ái Káláu ákte kabat arsakta diar, má koion á tekes na tah kusi kándiar kila.” ");
INSERT INTO sgz_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Mái Iesu má kán kalilik án aratintin di kusak kaleng iatung i rum, má kán kalilik di gátnai suri pinpidan erei. ");
INSERT INTO sgz_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Mái Iesu a parai si di ngoromin, “Ngo kesá kálámul a pala kán wák má a kila pasi lite wák, kálámul erei a long tari sápkin uri narsán kán mulán wák. ");
INSERT INTO sgz_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","A ngorer mul ngo kesá wák a pala kán pup máng kila pasi lite kálámul, ái mul a long tari sápkin uri narsán kán mulán pup.” ");
INSERT INTO sgz_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Má te kálámul di lam tari rang nat di ur si Iesu suri na top i di má nák asosah i di, mái sár kán kalilik án aratintin di tur kári tan kálámul erei. ");
INSERT INTO sgz_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mái Iesu a mákái mák togor mák parai si di ngoromin, “Gama hol palai boh gengen kalilik ur singing. Koion gama tur kalar di kabin ngo kandi ái rung ngoromin á lolsit si Káláu. ");
INSERT INTO sgz_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","A muswan sang iau parai si gam, ái koner a nem ngo na kusak i lolsit si Káláu, na ruruna pasi ngorer i gengen kalik a ruruna i kákán. Ngo kápnate longoi ngorer, ki kápte sang na kusak.” ");
INSERT INTO sgz_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Má a káh pasi bos kalilik keskeskes mák oboi limán i lul di mák asosah i di. ");
INSERT INTO sgz_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Mái Iesu a aptur má a láklák iamudi, má kesá kálámul a rut uri narsán má a dirtapul má a gátnai ngo, “Tám Aratintin, iáu lain kálámul. Dánih ina longoi suri inak atur páptai liu áklis?” ");
INSERT INTO sgz_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Mái Iesu a longrai mák parai singin ngoromin, “Suri dáh u utung iau ngo iau lain kálámul? Ái Káláu masik sár a kuluk má kápte kes mul. ");
INSERT INTO sgz_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","U mánán i nagogon er a parai ngoromin ngo koion una up bing tekes, má koion una longoi sápkin mai wák káián lite kálámul, má koion una siksikip, má koion una poklah pasi angagur uri tekesá kálámul, má koion una agur pasi táit káián lite, má una rumrum i kakam mái mamam.” ");
INSERT INTO sgz_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Má kálámul er a longrai mák parai si Iesu ngo, “Tám Aratintin, turpasi til tungu iau kalik be, iau lu mur arwat pas noi tan nagogon erei ák han pang onin.” ");
INSERT INTO sgz_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Mái Iesu a mákái má a mámnai mák parai singin ngoromin, “Kesi táit sár u sáhár suri. Una han sira palai kam bos minsik no, má unáng kip pasi pirán tabal má unák tari singin bos sáhár, má na kaiam besang á bos lain minsik imi bát. Má una lákám unák mur i iau.” ");
INSERT INTO sgz_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kálámul er a longrai má ák mákmák án tang má a han alar Iesu sang. A sák i bál suri, kabin marán i kán minsik. ");
INSERT INTO sgz_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Mái Iesu a sálsálah aririu i di mák parai singin kán kalilik án aratintin ngoromin, “A tuan rakrakai muswan si di á bos konom suri da kusak i lolsit si Káláu.” ");
INSERT INTO sgz_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Má kán kalilik án aratintin di sodar suri kán pinpidan, má ngorer ái Iesu a parai mul si di ngo, “Kalilik, a tuan rakrakai muswan suri kusak i lolsit si Káláu. ");
INSERT INTO sgz_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamel ngo na sol uri polgon nil án babaut, ái a malmu si diar á kálámul a konom ngo na sol uri lolsit si Káláu.” ");
INSERT INTO sgz_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Má di lala sodar má dik parai singin ngoromin, “Ngo ngorer, ki ái sinih sang na liu? Kápte kes sang na kusak!” ");
INSERT INTO sgz_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Mái Iesu a mák di mák parai ngo, “Matananu kápdite arwat ngo da aliu pas di sang. Ái sár ái Káláu a arwat, kabin ngo ái Káláu a lu long arwat pasi bos táit no.” ");
INSERT INTO sgz_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Mái Petero a turpasi parai si Iesu ngoromin, “Mákái, Konom, gimáte han alari kángim bos táit no má gimá murmur i iáu.” ");
INSERT INTO sgz_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ái Iesu a kos Petero, “A muswan iau parai si gam, ngo kes a hol pas iau mák han mai lain arbin sur iau, má ngorer a han alari kán rum mái tuán mái kukun mái mámán mái kákán ngo rang natun má alari kán pokon, ");
INSERT INTO sgz_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","i liu onin na kipi mul i marán. Na marán i kán rum má rang tuán má rang kukun má rang mámán má rang natun má kán tan pokon. Má támin ngo na áslai mul i rangrangas, má namur na atur páptai liu áklis. ");
INSERT INTO sgz_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mái sár marán si di onin i liu minái di konom, namur da gengen. Má marán si di ái rung di gengen onin, i liu namur da pakta.” ");
INSERT INTO sgz_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Má namur di polas kaleng i dan á Ioridan, má dik murwa pasi sál urami Ierusalem. Má matananu di lu murmur on, di mátut kabin di hol páptai kán worwor ái Iesu suri kán minat. Mái sár ái Iesu a láklák táil i di no. Má kán kalilik án aratintin di mákái ngorer má dik pángáng suri. Mái Iesu a lam pasi kán kalilik án aratintin uri risán alari matananu, má a turpasi parai mul i bos táit na hut singin ami Ierusalem ");
INSERT INTO sgz_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","mák parai si di ngoromin, “Mákái, inái git han urami Ierusalem, má bos pakpakta kán tan tám osmapak má bos tám mánán uri nagogon da top i Natun Kálámul má da nagogon on suri na mat, má da tari uri limán tan tátáil til Rom. ");
INSERT INTO sgz_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Má dák tartar retret singin má dáng kankansai má dák rapis sáksáknai má dák up bingi. Má ngo na rah i atul á bung na liu kaleng mul.” ");
INSERT INTO sgz_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ái Iakobo mái Ioanes, aru i natun ái Sebedaio, diar purut si Iesu má diará parai singin ngo, “Tám Aratintin, giur nem ngo una long tari táit er giura sung iáu suri.” ");
INSERT INTO sgz_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Má a gálta diar ngo, “Dánih gaur nem on?” ");
INSERT INTO sgz_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Má diará sungi ngoromin, “I pákánbung una hut mai minmáir i iáu, tekes tili giur na kis tili balsán mingim má tekes tili balsán káisam.” ");
INSERT INTO sgz_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Mái Iesu a kos diar ngoromin, “Káp gaur te mánán á táit erei gaur sungi. Ngádáh? Gaur arwat ngo gaura ngin tili kinleh án rangrangas erei ina ngin til on? Má gaur arwat mul ngo da siu gaur mai arsiu án minat erei da siu iau mai?” ");
INSERT INTO sgz_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Má diará parai singin ngo, “Giur arwat.” Má namur ái Iesu a parai si diar ngoromin, “A muswan, gaura ngin tili kinleh ina ngin til on, má da siu gaur mai matngan arsiu er da siu iau mai. ");
INSERT INTO sgz_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ái sár suri kis tili balsán minging má tili balsán káisang, káp ngo kaiak suri ngo ina tari. Káián ái Káláu. Ái na tari si rung er ákte eran i nián i di.” ");
INSERT INTO sgz_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Má namur sángul á kalik án aratintin di longrai ngorer ki dik togor i Iakobo mái Ioanes. ");
INSERT INTO sgz_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Mái Iesu a mákái ngorer ki áng kilkila pas di uratung i narsán mák parai si di ngoromin, “Gam mánán i bos tátáil kándi ái rung tili risán, di lu kátlán i kándi matananu mai kándi rakrakai. Di lala apakta pas di, má dik lu suka bámiai matananu. ");
INSERT INTO sgz_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mái sár á gam kápte gama ngorer. Ngo tekes tili gam a nem ngo na pakta, na toptop be si gam. ");
INSERT INTO sgz_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Má kálámul a nem ngo na tátáil kamu, na toptop kamu no. ");
INSERT INTO sgz_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","A ngorer i Natun Kálámul, kápate hut suri kátlán i gam. A hut sár suri na toptop káián matananu, má suri sirai kán liu suri hul aliu pasi marán.” ");
INSERT INTO sgz_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ái Iesu má kán kalilik án aratintin má marán matananu mul di lu hanhan tangra sál má dik tapam hut i malar á Ieriko. Má ngo di sorliu á Ieriko, kesi rau tám sung, ngisán ái Batimaio, natun ái Timeus, a lu kis i risán sál. ");
INSERT INTO sgz_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","A longrai ngo ái Iesu kakun Nasaret a lu hanhan, máng kilkilai ngoromin, “Iesu, iáu natun ái Dewit, una mámna iau!” ");
INSERT INTO sgz_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Má marán kálámul di tur kári suri koion na worwor, mái sár a lala wakwak sang ngo, “Natun ái Dewit, una mámna iau!” ");
INSERT INTO sgz_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Mái Iesu a longrai kálámul er mák sámtur mák parai si di ngo, “Bin pasi urain.” Má di bin pasi rau erei má dik parai singin ngo, “Kái una mátut. Aptur, ákte bin pas iáu!” ");
INSERT INTO sgz_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Má a buswa palai kán bobor mák sangar melek uri narsá Iesu. ");
INSERT INTO sgz_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Mái Iesu a gátnai ngoromin, “Dánih u nem on ngo ina longoi mam iáu?” Má kálámul er a rau a parai singin ngo, “Konom, iau nem ngo ina mákmák.” ");
INSERT INTO sgz_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Mái Iesu a parai singin ngo, “Una han sár, kam ruruna ákte aliu pas iáu.” Má káp melek sár mul mák talas i mátán mák mur i Iesu tangra sál. ");
INSERT INTO sgz_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Di lu hanhan páput ur Ierusalem artálár mai aru malar Betani má Betepage, má dik hut i pungpung Oliwa, mái Iesu a dos palai aru kalik án aratintin ");
INSERT INTO sgz_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","mák parai si diar ngoromin, “Gaura han uri malar imudi má gaura kusak on, má káp melek mul gaurák mákái kesi gengen dongki di puta páksi má kápte kes a kis be on. Gaura pálás pasi dongki erei má gaurák lami ur main. ");
INSERT INTO sgz_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Má ngo tekes na gátna gaur ngoromin, ‘Suri dáh gaur longoi ngorer?’ ki gaura parai singin ngo, ‘Ái Konom na him mai be, má namur na tarwa kalengnai mul ur main.’” ");
INSERT INTO sgz_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Má diar má han, diará mákái dongki a sámtur pagas iatung i sál, má dikte puta páksi i mátsálán kesi rum, má diar má pálás pasi. ");
INSERT INTO sgz_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Má te kálámul iatung di gátna diar ngoromin, “Dánih gaur longoi á ngorer gaurá pálási gengen dongki?” ");
INSERT INTO sgz_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Má diará para ngorer ái Iesu a parai, má dik mángát ngo diara lam pasi dongki. ");
INSERT INTO sgz_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Diar má lami gengen dongki uri narsá Iesu, má diar má ulát pasi lusán i diar, ki diar má pálsi i iátin dongki mái Iesu a kis on. ");
INSERT INTO sgz_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Má marán mul di pálsi lusán i di tangra sál, má te di kot pasi pákán báibái tilatung tangra sál má dik pálsi suri ák láklák on i dongki. ");
INSERT INTO sgz_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Má te di lu tátáilnai má te di lu murmur on, má di lu wakwakwak ngoromin, “Huihui iá! Huihui iá! Ái Káláu na kuluk mam Koner a hut mai ngisán! ");
INSERT INTO sgz_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ái Konom na kuluk mai suri na kátlán i git ngoro kámpup git ái Dewit! Huihui iá sang urami!” ");
INSERT INTO sgz_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Mái Iesu a hut á Ierusalem má a kusak i rumán osmapak má a mákái bos táit no iatung. Má namur a kaleng ur Betani tiklik mai kán kalilik án aratintin kabin ákte páput suri na dorah i nas. ");
INSERT INTO sgz_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ákte arasa má, ki dik so kaleng til Betani urami Ierusalem, mái Iesu a matpám. ");
INSERT INTO sgz_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Má iatung i risán sál kesi aun tawan a tur. Ái Iesu a mákái til tepák ngo a lain lur mák han suri lus pas te wán suri na ani, má kápte. Kápte be te wán, tu pákán masik, kabin ngo kápate arwat i pákánbung be suri ngo na u. ");
INSERT INTO sgz_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Mái Iesu a mákái ngorer mák parai singin tawan erei ngo, “Turpasi onin kápte kes na ani wán i iáu mul!” Má kán kalilik án aratintin di longrai ngorer a parai. ");
INSERT INTO sgz_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Di hut á Ierusalem mái Iesu a kusak uri pelbut i rumán osmapak mák tipar palai bos kálámul di lu sirsira má bos kálámul di lu huhul iatung. A pukda sarai kándi bos suh ái rung di lu keles pirán tabal má kándi bos nián kis ái rung di lu sira man. ");
INSERT INTO sgz_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Mái Iesu a tur kalar di suri koion da urup i katbán rumán osmapak mai kándi minsik. ");
INSERT INTO sgz_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Má a atintin di mák parai ngo, “Dikte le on i Buk Tabu ngoromin, ‘Kak rum da utngi mai rumán sung káián matananu no’, mái sár gamáte pukda pasi ák nián him káián bos tám siksikip.” ");
INSERT INTO sgz_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bos pakpakta kán tan tám osmapak má bos tám mánán uri nagogon di longrai ngorer má dik ser sál suri ngádáh da up bingi ngoi. Di bulat kabin ngo matananu di pángáng má dik laes suri kán aratintin. ");
INSERT INTO sgz_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Má i rahrah, ái Iesu má kán kalilik án aratintin di aptur til Ierusalem má ding kaleng mul ur Betani. ");
INSERT INTO sgz_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Má i kábungbung, di lu hanhan tangra sál má dik mákái aun tawan erei ái Iesu a boroi nabung, ákte maulur no. Pákán ákte maulur má nirwán mul ákte hius, má ngorer tawan er a turpasi marang. ");
INSERT INTO sgz_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Mái Petero a hol pasi worwor si Iesu mák parai singin ngo, “Tám Aratintin, mákái aun tawan erei nabung u boroi. Ákte marang má!” ");
INSERT INTO sgz_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Mái Iesu a longrai ngorer mák inau i di ngoromin, “Gama ruruna i Káláu. ");
INSERT INTO sgz_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Támin muswan iau parai si gam, ngo tekes na parai singin pungpung, ‘Una támrabut má unák pur ada i lontas,’ má na tukes i kán hol má na ruruna tusi táit er a parai ngo na hut, ki na hut sang. Mái sár ngo na ru i kán hol, kápnate long artálár pasi. ");
INSERT INTO sgz_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Má ngorer iau parai si gam, táit no gam sungi, gama ruruna sár ngo gamáte atur páptai, ki gama atur páptai sang. ");
INSERT INTO sgz_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“Pákánbung kes a eran suri sung má ák hol pas te tatalen erei te di longoi mai, na hol palai má, suri ái Kákán imi bát na hol palai kán bos sápkin tatalen mul. ");
INSERT INTO sgz_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Mái sár ngo kápnate hol palai kándi tatalen ái rung er di longoi sápkin uri narsán, ngorer sár ái Kákán imi bát kápnate hol palai kán tan sápkin tatalen.” ");
INSERT INTO sgz_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Io, má dik lu hanhan tangra sál ki dik hut á Ierusalem. Má di kusak urami rumán osmapak, mái Iesu ák lu lákláklák iatung. Má tan pakpakta kán tan tám osmapak má bos tám mánán uri nagogon má te kálámul pakta, di mákái má dik hut i narsán ");
INSERT INTO sgz_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","má dik gátnai ngo, “Una parai si gim, sinih a dos pala iáu er uk longoi tan táit ngorer? Mái sinih a tari nokwan erei singim?” ");
INSERT INTO sgz_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Mái Iesu a kos di ngoromin, “Má iau mul ina gálta gam. Ngo gama kos iau, ki á iau mul ina para koner a tari nokwan singing má iak longoi bos táit er mai. ");
INSERT INTO sgz_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Gam mánán i Ioanes Tám Arsiu? Sinih a dos palai suri arbin má arsiu? Sinih a tari singin á him erei? Ái Káláu? Ngo a hut sang tili kán holhol sár? Gam parai!” ");
INSERT INTO sgz_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Má dik nguruk arliu i di sang ngoromin, “Ngo gita parai ngo ái Káláu a tarwa Ioanes ur main, ki na parai ngo, ‘Suri dáh kápgamte ruruna i kán pinpidan?’ ");
INSERT INTO sgz_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Má ngo gita parai ngo káián sang ái Ioanes a hut tili kán hol sang, ki matananu da up git kabin di ruruna i Ioanes ngo ái á tám worwor tus muswan káián ái Káláu.” ");
INSERT INTO sgz_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Má ngorer ding kos Iesu ngoromin, “Kápgimte mánán.” Mái Iesu a longrai ngorer mák parai si di ngo, “Á iau mul káp ina te parai si gam ngo ái sinih a tari nokwan singing má iak longoi bos táit minái.” ");
INSERT INTO sgz_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Mái Iesu a parai kesi worwor artálár si di ngoromin, “Kesi kálámul a soi kesi numán wain mák áir kári mák longoi kesi lus uri suir wain. A longoi mul i kesi rum, rum erei uri mákmák kári numán wain sang. A longoi ngorer ki ák tar páksi singin bos tám himhimna mák han alar di uri malar tepák. ");
INSERT INTO sgz_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Má namur ngo ákte arwat i pákánbung suri lus talmi wán wain, io a dos palai kán kesi tám arardos suri kip te risán wán wain tili kán num. ");
INSERT INTO sgz_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Má ngo bos tám himhimna di mákái tám arardos erei a hut narsá di, di tolai má dik ubi má dik dos pala kalengnai mai wáin limán. ");
INSERT INTO sgz_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Namur kákán num a dos palai kán kesi tám arardos mul. Io, má bos tám himhimna di sá rápái lul má dik abilbilingnai. ");
INSERT INTO sgz_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Má a dos palai mul i kán kesi tám arardos, má bos tám himhimna di long pasi má dik sá bingi. Di longoi ngorer mai marán, di tu up di sár á te má te di sá bing di. ");
INSERT INTO sgz_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Io, má ngorer kes masik má ák lu kis suri dos palai, arahrahi kálámul, war natun sang kán kalik alal. Má namur kálámul erei a para ngoromin, ‘Ina dos palai sang i natung suri da rumrum on má kápdate ubi.’ Má ngorer ák dos palai natun. ");
INSERT INTO sgz_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Mái sár bos tám himhimna di mák pasi má dik worwor arliu i di ngoromin, ‘Mákái, erei mái koner na tur kelsen. Gita up bingi suri numán wain na ur kángit.’ ");
INSERT INTO sgz_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Má ngorer di tolai má dik up bingi má dik sápka aso palai tilami numán wain.” ");
INSERT INTO sgz_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Má ngo ái Iesu a arahi puksai worwor artálár erei, ki ák gátna di ngoromin, “Dánih má na longoi á kákán numán wain i bung na purut kaleng narsá di? Bung na purut kaleng, na up bingi bos tám himhimna má nák tari numán wain ur singin tan lite. ");
INSERT INTO sgz_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","A muswan ngo gamáte wásái pinpidan minái tili Buk Tabu er a para ngoromin, ‘Hat erei bos tám long rum di pukpukwai, mái sár ái Káláu a aksimi hat erei suri áng kábutkis si di no á tan hat, má uri mát git a tuan kuluk taladeng.’” ");
INSERT INTO sgz_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Má tan tátáil káián matananu Iudáiá di longrai ngorer má dik longra ilmi ngo ái Iesu a parai worwor artálár a arwat mam di sang, má ngorer dik nem suri kabat Iesu. Mái sár kápdite long arwat pasi kabin di bulat suri matananu, má ngorer dik tam han alar Iesu sang. ");
INSERT INTO sgz_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Má namur di dos palai mul i te bos Parisaio má te bos kálámul tili kiskis si Erodes, má dik han uri narsá Iesu suri da tohtohoi mam te argátna. ");
INSERT INTO sgz_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Má di hut narsá Iesu má dik gátnai ngoromin, “Tám Aratintin, gim talas ngo u lu parai támin muswan masik. Káksiái ngo ái sinih alatung a longra iáu, u lu para puri mát di mai muswan. Má kápute lu hol pasi mul ngo sinih á bos kálámul pakta má kandi bos kiskis. Kápte. U lu aratintin sár mai sál si Káláu. Gim nem ngo una bit gim be. A mángát á kángit nagogon ngo gita tar takis ur si Kaisar? Ngádáh, gita tari ur si Kaisar ngo kápte?” ");
INSERT INTO sgz_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ái Iesu a mákái má a mánán i kandi angagur ngo da pidir pasi, mák parai si di ngoromin, “Be, gam ngoi ngo gama pidir pas iau? Gam kip tar tekesi pirán tabal ur main má inak mákái.” ");
INSERT INTO sgz_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Má káp melek mul má di kip tari kes ur singin, ki ái Iesu ák gátna di ngo, “Sinih á tantanián má ngisán á minái di le on?” Má ding kos Iesu ngo, “Ái Kaisar”. ");
INSERT INTO sgz_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Mái Iesu ák parai mul si di ngoromin, “A kuluk, gama tari sang si Kaisar á táit káián ái Kaisar, má táit káián ái Káláu gama tari sang si Káláu.” Má di longrai ngorer má dik pángáng suri táit ái Iesu a parai uri di. ");
INSERT INTO sgz_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Má namur te á bos Sadukaio di han suri gálgálta i Iesu, di ái rung er kápdite ruruna ngo kálámul erei a mat na liu kaleng mul i liu namur. Di hut narsá Iesu ngorer má dik parai ngoromin, ");
INSERT INTO sgz_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tám Aratintin, ái Moses a le i nagogon minái ur si gim. Ngo kálámul a mat alar kán wák má kápate kákáh ái kán wák singin, ái tuán na kila pasi bul i kán mokos suri nák mon i natun suri ngisán ái kákán na liu pagas sang. ");
INSERT INTO sgz_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“Má ahit i aratuán, mulán i di a kila má namur ák mat má kápte te natun be. ");
INSERT INTO sgz_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kono áruán áng kila pasi mul i mokos, má káp melek mul ki ák mat má kápte besang te natun. Má ngorer mul ái kono átuil a mat má kápte natun. ");
INSERT INTO sgz_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Má ngorer ahit no á aratuán er, di kila pasi kes sár á wák, má di no di mat alari má kápate mon i te nat di singin wák er. Má namur má, wák mul ák mat. ");
INSERT INTO sgz_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ki namur di no da liu kaleng i liu namur, sinih sang má tili di na kán wák muswan á wák erei, kabin ahit no di kila pasi?” ");
INSERT INTO sgz_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ái Iesu a kos di ngoromin, “Suri dáh a rogorogo i kamu hol? A kabin kápgamte mánán i worwor tili Buk Tabu má kán rakrakai ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Má er namur matananu da aptur kaleng alari minat, kápdate kila mul, da ngoro boh angelo imi bát. ");
INSERT INTO sgz_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Gam ruruna ngo rung di mat kápte da liu kaleng. Má gam ruruna ngorer káplabin kápte gam talas suri pinpidan a le on ái Moses. A le i worwor a parai singin ái Káláu tili aun kubau a inan má kápate bam. Mái Káláu a parai ngo, ‘Iau á Káláu káián ái Abaram má Káláu káián ái Aisak má Káláu káián ái Iakop.’ Git talas ngo sálán kán worwor ái Káláu er ngo káksiai ngo dituláte mat má, ditul liu be má ditulá lu lotu uri narsán ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ái rung er di lu lotu uri narsán ái Káláu, káksiai ngo kápán páplun i di ákte mat, wa di á tan liuán kálámul sang. Kamu holhol a ger.” ");
INSERT INTO sgz_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Má kesi tám mánán uri nagogon a hut si di má ák longra di di arkipkip mai wor arliu i di, mái Iesu a kos kulukna di. Má ngorer ák han narsá Iesu mai kesi argátna ngoromin, “Arardos dáh a pakta si di no á bos nagogon?” ");
INSERT INTO sgz_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Mái Iesu a kos kalengnai ngoromin, “Arardos er a pakta á minái. Gam á tan Israel gam longrai, ái Káláu erei kángit Konom, ái masik sár á Konom. ");
INSERT INTO sgz_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Una mámna Káláu kam Konom mai kunlán balam má mai taniam no, má mai kam kunlán hol, má mai kam rakrakai no mul. ");
INSERT INTO sgz_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Má áruán arardos erei a pakta á minái, una mámna turam ngorer u mámna kalengna iáu sang. Kápte kesi nagogon mul a pakta sorliwi aru arardos erei.” ");
INSERT INTO sgz_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Má ngorer tám mánán uri nagogon a parai si Iesu ngo, “A muswan, Tám Aratintin. Támin sang er u parai ngo ái Konom ái masik sár á Káláu má kápte kes mul á Káláu. ");
INSERT INTO sgz_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Má gita mámna Káláu mai kunlán bál git má kángit kunlán hol má kángit rakrakai no mul, má gita mámnai tur git ngorer sár git mámna kalengna git sang. Tatalen án mur i aru nagogon erei, ái sang a pakta si diar i tatalen án osmapak má artabar uri narsá Káláu.” ");
INSERT INTO sgz_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ái Iesu a longra ilmi tám mánán erei a kos kuluknai má a para ngoromin singin, “Á iáu ukte páput suri una kusak i lolsit si Káláu.” Má turpasi bung erei, kápte kes mul a mangan suri bali gálta Iesu. ");
INSERT INTO sgz_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Má namur ái Iesu a atintini matananu ami rumán osmapak mák gálta di ngoromin, “Bos tám mánán uri nagogon di parai ngo Mesaia ái á natun ái Dewit, be? Ngádáh a ngoi? ");
INSERT INTO sgz_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Gama mákái worwor si Dewit er Tanián a Pilpil a tari singin. Ái Dewit sang a parai sur Mesaia ngoromin, ‘Ái Káláu a parai singin kang Konom ngo, “Una kis main i risán minging suri da árnga iáu, má iau ina suka bámiai kam tan kurtara uri lalin kikim má ina arumrum di.” ’ ");
INSERT INTO sgz_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ki ngádáh a ngoi ngo Mesaia a sumlahin ái Dewit má ái sár mul á kán Konom? A kabin ái Dewit a mák ilmi ngo Mesaia ákte kis má i pákánbung er. Ngorer a talas ngo Mesaia a sumlahin ái Dewit, má ái sár á kán Konom mul.” Má matananu di longrai kán aratintin ái Iesu ngo a sorliwi aratintin káián bos tám mánán má dik laes suri. ");
INSERT INTO sgz_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Namur ái Iesu a atintini matananu mul mák para ngoromin si di, “Gama mákmák kuluk má ololoh suri bos tám mánán uri nagogon. Di lu laes má inngasi kandi mermer, má di nem ngo matananu da lu árár pas di i pokon án sirsira. ");
INSERT INTO sgz_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Má di lu nem suri sukis i tan kiskis táil i rumán lotu, má i bos longsit di lu nem i sukis i kiskis erei matananu da rumrum i di ái. ");
INSERT INTO sgz_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Di lu agur pasi minsik kán tan mokos, má dik lu longoi dolon sung suri agurái matananu dák mák di ngo di tám nokwan. Na lala sorliu á kándi rangrangas namur!” ");
INSERT INTO sgz_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ái Iesu a han uri kuir rumán osmapak di lu obop pirán tabal ái, mák sukis pagas pátmi, má kán tu mákái matananu di tari pirán tabal uri nián omobop. Bos konom di tari pirán a pakta. ");
INSERT INTO sgz_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Má namur kesi maris án mokos a han mák oboi aru i gengen pirán sár. ");
INSERT INTO sgz_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Mái Iesu a mákái ngorer máng kilkila pasi kán kalilik án aratintin uri narsán mák parai si di ngoromin, “Mákái! A támin muswan iau parai si gam, maris án mokos minái a tari a pakta si di no ái rung di obop pirán tabal main i nián omobop. ");
INSERT INTO sgz_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ái rung di obop pirán tabal main i nián omobop, di tari gengen risán tili kándi tilik omobop má ngorer kápdate sáhár. Mái sár ái koner a maris muswan a tar noi sang i kán pirán tabal erei a mon singin ngo na tángni kán liu.” ");
INSERT INTO sgz_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Má namur ái Iesu tiklik mai kán kalilik án aratintin di so alari rumán osmapak, má kán kesi kalik án aratintin a parai singin ngo, “Tám Aratintin, una mákmák kaleng urami rumán osmapak má unák mákái bos lalain hat má bos lalain rum erei.” ");
INSERT INTO sgz_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Mái Iesu a kosoi ngoromin, “U mákái á bos tilik rum erei? Kápte kesá hat na lu kis i nián, na pospos no má na purpur ur main i bim. Bos kurtara da hut má dák amosrah noi.” ");
INSERT INTO sgz_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Mái Iesu a tapam urami pungpung á Oliwa mák sukis pagas mák mákmák kaleng uradi rumán osmapak. Má namur ái Petero mái Iakobo mái Ioanes mái Enru dihat han narsá Iesu má dik gátna kodongnai ngoromin, ");
INSERT INTO sgz_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Awái, Tám Aratintin, unák bit gim be á iáu suri tan táit minái. Enges na hut, má dánih á akiláng gima mákái suri mák ilmi ngo ákte páput má?” ");
INSERT INTO sgz_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Mái Iesu a parai si di ngoromin, “Gama ololoh kuluk suri koion á tekes na agur gam. ");
INSERT INTO sgz_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Marán da hut má da arbin mai ngisang má dák parai ngo, ‘Á iau á Mesaia,’ má da lam bengtai marán. ");
INSERT INTO sgz_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Koion gama ráuráuwas suri kaungán tan táit án arup gama longrai er páput, má koion gama ráuráuwas i arbin gama longrai suri bos arup iamunang tepák. Tan táit er na hut sang, má kápte besang á arahrahi. ");
INSERT INTO sgz_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Má kesi matananu na aptur má nák arup mai kesi matananu sang. Má bos mát mul ngoi, kesi mát na aptur má nák arup mai kesi mát. Marán kunkun na hut arkaliut i te tan balis, má taul itol na hut mul. Tan táit erei na hut, ái á mátmátán sár á rangrangas ngorer i rangrang a hut singin wák er a eran suri kákáh. ");
INSERT INTO sgz_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Gam sang gama ololoh kuluk. Da tola gam má kabat pas gam, má ngorer da kip gam uri nagogon. Da lu rapis gam i rumán lotu. Gama lu tur i mátán táil i bos tám nagogon má i mátán táil i bos kabisit suri ngisang, má gamák arbin narsá di. ");
INSERT INTO sgz_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Má gama lu arbin táil mai lain arbin ur singin matananu i naul matmatngan pokon, má namur na hut i arahrahi. ");
INSERT INTO sgz_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Má ngo da lu tola gam má kabat gam má da lu kip gam uri nagogon, koion na ngát i kamu hol suri ngo dánih gama parai. I pákánbung er, gama parai worwor erei a soura uri kamu hol, kabin pinpidan erei a soura kápte ngo kamu, káián Tanián a Pilpil. Ái sang na tari si gam. ");
INSERT INTO sgz_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Kálámul na kip tar tuán uri minat. Má ngorer mul i aratámán, kákán na kip tar natun uri minat. Mái natun mul na togor i kákán mái mámán má na obop diar uri minat. ");
INSERT INTO sgz_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Matananu no da mikmikwa gam káplabin sur iau. Mái sár kono a tur rakrakai pang i arahrahi, ái Káláu na aliwi sang. ");
INSERT INTO sgz_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Má gam er gam wásái worwor minái, a kuluk ngo gama talas suri sálán á táit minái ái Daniel tám worwor tus a arbin táil suri. A ngoromin. Namur gama mákái táit a tuan sák na long adurwán rumán osmapak. Táit er na hut má náng kis i pokon er kápate nokwan ngo na kis ái. Mái Káláu na mákái ngorer pasi kápnate kis be i rumán osmapak. Má ngo gam á tan Iudáiá gama mákái táit erei, gama táu uramuni pungpung. ");
INSERT INTO sgz_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ái koner ngo na iatung i lol malar, kápnate kusak mul uri kán rum suri kip kán te táit. Na tu táu sár. ");
INSERT INTO sgz_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Má kálámul erei a him i kán pokon, kápnate kaleng uri kán rum sur kán te bobor. Na tu táu sár. ");
INSERT INTO sgz_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Keskam singin tan wák erei di tián mái rung di kis tinánkak mai goion kalik. ");
INSERT INTO sgz_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Gama sung Káláu suri tan táit erei kápnate hut i taul gáwár. ");
INSERT INTO sgz_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Lala rangrangas er na hut i pákánbung erei, ái na sorliwi tan rangrangas no turpasi tili tangkabin i akaksim, má onin, má kápte kesi táit mul na ngorer namur. ");
INSERT INTO sgz_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Má ngo na lala dol i pákánbung er, ki da han mat no. Mái sár ái Káláu ákte put aruái á pákánbung. A hol pasi bos tám ruruna er ákte ilwa pas di, ki ák put aruái pákánbung er kabin sur di. ");
INSERT INTO sgz_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Má ngo tekes na parai si gam ngo, ‘Mákái, minái má Mesaia’, ngo, ‘Ái sang á Mesaia’, koion gama longra pasi má ruruna on. ");
INSERT INTO sgz_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tan bos angagur án Mesaia má bos angagur án tám worwor tus da hut má da longoi tara akiláng, má matananu da mákái má da pángáng on. Ái rung er da tohoi suri lam bengtai matananu si Káláu er ákte ilwa pas di sang, mái sár káp sang da te arwat. ");
INSERT INTO sgz_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Iakte para noi si gam á bos táit er kápate hut besang, má ngorer gama ololoh kuluk sár!” ");
INSERT INTO sgz_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Mái Iesu a sopasun i kán aratintin mák parai ngoromin, “Má namur, ngo ákte rah i pákánbung án arabilbiling, mátán nas na kuron, má kalang mul kápnate pos. ");
INSERT INTO sgz_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Tan mátmátiah da lu purpur tilamuni naul bát, má tan táit a mon i rakrakai i di iamuni armongoh da dikdikdik ngorer i kunkun a gunra di. ");
INSERT INTO sgz_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Má namur da mákái Natun Kálámul na hut soura tili kumlán mehmeh tiklik mai kán tilik rakrakai má mai minmáir mul. ");
INSERT INTO sgz_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Má na dos palai tan angelo uri ahat i mátán kihkih main i naul bim suri long pasi tan kálámul er ái Káláu ákte ilwa pas di. Tan angelo da han ngorer suri kip talum di tili tan kuir no i naul matmatngan pokon.” ");
INSERT INTO sgz_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Mái Iesu a sopasun mul i kán aratintin mák parai ngoromin, “Gama kip aratintin tili aun rarah. Ngo rarah a oboi hutngin pákán mák oboi mul i sián, ki gita mák ilmi ngo ákte páput má á taul ráin. ");
INSERT INTO sgz_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Má ngorer sár mul, ngo gamáte mákái tan táit erei ákte lu huthut, ki gama mánán ngo Natun Kálámul ákte páput má, erei sár má i mátán kas ái. ");
INSERT INTO sgz_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Támin muswan iau parai si gam, ngaul matananu minái kápdate mat besang má nák tapam hut á tan táit erei. ");
INSERT INTO sgz_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Naul bát má naul bim na bokoh, mái sár kak pinpidan kápnate pah.” ");
INSERT INTO sgz_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Mái Iesu a arahi kán aratintin mák parai ngoromin, “Kápte kes a mánán i bung ngo pákánbung na hut i Natun Kálámul. Bos angelo imi bát kápdite mánán, má Natun sang mul kápate mánán. Ái Kákán masik sár a mánán. ");
INSERT INTO sgz_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Má ngorer gama ololoh kuluk kabin kápgamte mánán i pákánbung na hut. ");
INSERT INTO sgz_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Na ngorer i kálámul a han alari kán rum má ák han uri kesi lite malar, má ák tari kán rum má kán bos táit uri limán i kán bos tám arardos suri da kátlán. A tar páksi him si di á bos tám arardos keskeskes suri da longoi, má a parai singin tám ololoh i mátán sál mul suri mákmák kári mátán sál sang. ");
INSERT INTO sgz_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Má gam gama ngorer i bos tám arardos erei. Gama pán pagas kabin kápgamte mánán anges na kaleng á kákán rum. Na hut i rahrah keleh, ngo na hut i katbán libung gut, ngo na tangtang i kok ngo i kábungbung. ");
INSERT INTO sgz_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Má gama eran ngorer na mák hut asodar i gam gam boptin. ");
INSERT INTO sgz_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Táit minái iau parai si gam, iau parai si gam no á matananu ngo gama pán pagas!” ");
INSERT INTO sgz_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Aru sár má bung suri akiláng i bungán longsit án sorliu palai má beret káp a tini sut, má tan pakpakta kán tan tám osmapak má bos tám mánán uri nagogon, kándi tu ser sál suri da top kodongna Iesu suri dák up bingi. ");
INSERT INTO sgz_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Má ngorer di parai ngo, “Koion gita tolai i bungun longsit da káp togor i matananu má dák apturi tilik arup.” ");
INSERT INTO sgz_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ái Iesu má kán kalilik án aratintin di han ur Betani má di kusak i rum si Saimon er a sami lepra tungu, má dik namnam. Kándi tu namnam besang, má kesi wák a hut mai átbán wel di longoi mai hat. Má wel erei lain wel a tomtom má a pakta sang i mátán. Má wák er a tok puri átbán mák urai wel uri lul ái Iesu. ");
INSERT INTO sgz_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Má te kálámul iatung di mákái ngorer má dik mos má dik worwor kodong arliu i di ngoromin, “Suri dáh a omlawai á lain wel erei? ");
INSERT INTO sgz_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Wel erei a arwat suri da sirai pas te na tul i mar i pirán tabal suri tángni tan sáhár.” Má ngorer di wor rakrakai ur on. ");
INSERT INTO sgz_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mái Iesu a longrai ngorer di parai uri wák er, ki ák parai si di ngoromin, “Suri dáh gam soksokoi? Gama káksiai sár. Ái sang a longoi lain táit uri narsang. ");
INSERT INTO sgz_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Tan sáhár di erei narsá gam áklis. Má ngo na ngoi i bál gam, gama longoi lain ninas ur si di. Mái sár á iau káp ina te kis áklis narsá gam. ");
INSERT INTO sgz_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Marán i táit kápate arwat suri longoi á wák min. Mái sár táit a arwat sang ngo na longoi, ákte long artálár pasi. Ái sang a pukri kápán páplun i iau ngorer a eran i iau suri bung da tahun iau on. ");
INSERT INTO sgz_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Má támin muswan iau parai si gam, i tan malar no i naul matmatngan pokon da arbin mai lain arbin ái, da parai mul i táit erei a longoi i wák min mam iau má da para agasi suri.” ");
INSERT INTO sgz_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Má namur ái Iudas Iskariot, kes tili di á sángul mai aru á kalik án aratintin, a so alar di mák han hut singin tan pakpakta kán tan tám osmapak suri na agur tar Iesu ur si di. ");
INSERT INTO sgz_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Má ngo bos tátáil er di longrai táit ngo na longoi ái Iudas, a gas i bál di má dik oror suri da tar te pirán tabal singin. Má ngorer ái Iudas a turpasi ser sál suri na agur tar Iesu ur singin bos kurtara. ");
INSERT INTO sgz_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Tatalen kán tan Iudáiá a ngoro minái. I libung táilnai longsit án ani beret káp a tini sut, di lu up bingi tan gengen sipsip suri da ani uri akiláng i longsit án sorliu palai mul. I bung erei sang, kán kalilik án aratintin di gálta Iesu ngo, “Be, ai u nem on ngo gima han ur ái má eran i namnam án sorliu palai?” ");
INSERT INTO sgz_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Má a longrai ngorer ái Iesu má a dos palai aru i kán kalik án aratintin mák parai si diar ngoromin, “Gaura han urami Ierusalem, má gaura mákái kesi kálámul a kipi átbán dan na bana gaur. Gaura mur on, ");
INSERT INTO sgz_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","má rum er na kusak ur on, ki gauráng kusak namurwai. Má gaurák parai singin kálámul er káián á rum ngo, ‘Ái Tám Aratintin a nem i mánán i rum dáh na kis on suri ani namnam án sorliu palai tiklik mai kán kalilik án aratintin.’ ");
INSERT INTO sgz_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Má namur, ái sang na lam gaur má nák inngas tari lala rum ami iát erei ákte leget on. Má gaura eran i ángit namnam iatung.” ");
INSERT INTO sgz_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Namur aru kálik án aratintin erei diar aptur má diará han ur Ierusalem má diará han mákái tan táit ngorer ái Iesu a parai si diar, má diará eran i namnam án sorliu palai. ");
INSERT INTO sgz_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Má ngo ákte ronron, ái Iesu má kán kalilik án aratintin di hut, ");
INSERT INTO sgz_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","má dik sukis suri turpasi namnam. Má kándi tu namnam besang, mái Iesu a parai ngoromin, “Támin muswan iau parai si gam, kes tili gam na agur tar iau. Ái sang á kes tili gam er git namnam tiklik onin.” ");
INSERT INTO sgz_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kán kalilik án aratintin di longrai ngorer, má a sák i bál di, má di keskeskes di gáltai ngo, “Kápte ngo iau, be?” ");
INSERT INTO sgz_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Mái Iesu a kos di ngoromin, “Kes tili gam á sángul mai aru, ái koner giur namnam tiklik tili kápán les erei iau namnam til on, ái sár na agur tar iau. ");
INSERT INTO sgz_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","A támin muswan ngo Natun Kálámul na han mur arwat pasi sál suri minat ngorer a parai i pinpidan. Mái sár na tuan sák bul uri kálámul er na agur tari Natun Kálámul! Na han kuluk singin kálámul er ngo káp na han te páng.” ");
INSERT INTO sgz_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kándi tu namnam be, mái Iesu a long pasi kesi tigán balbal mák sung kári. Má namur a tibi mák tari singin kán kalilik án aratintin mák parai mul si di ngoromin, “Gama top pasi. Minái á kápán páplun i iau.” ");
INSERT INTO sgz_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Má namur a long pasi kinleh wain mák sung kári mul mák tari singin kán kalilik án aratintin, má di no di ngin til on. ");
INSERT INTO sgz_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Má namur a parai si di ngo, “Minái á dárang a adikái kamkabat si Káláu. Na sal suri hul aliu pasi marán. ");
INSERT INTO sgz_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Támin muswan iau parai si gam, káp ina te ngin on mul á suir wain nák pang i bung erei ina ngin i hutngin wain ami lolsit si Káláu.” ");
INSERT INTO sgz_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","A rah i kán worwor ái Iesu, má namur di saki kesi saksak ki dik so alari rum má dik han urami pungpung á Oliwa. ");
INSERT INTO sgz_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","I pákánbung kándi tu láklák be tangrai sál, ái Iesu a parai si di ngoromin, “Kamu ruruna na pur besang, ngorer i Buk Tabu a parai ngo, ‘Ái Káláu na up bingi tám ololoh sipsip, má bos sipsip da tam sara.’ ");
INSERT INTO sgz_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Má namur ngo iakte liu kaleng, ina táil i gam ur Galiláiá.” ");
INSERT INTO sgz_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Mái Petero a kos Iesu ngoromin, “Káksiai ngo di no na pur i kandi ruruna, mái sár á iau kápte.” ");
INSERT INTO sgz_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Mái Iesu a parai si Petero ngo, “Támin muswan iau parai singim, inái i libung, i pákánbung kok kápate tang besang i kán áruán tang, una arkawar pala iau na tul i pákán.” ");
INSERT INTO sgz_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ái Petero a kos rakrakai kalengna Iesu ngoromin, “Auh, kápte! Káksiai ngo da long te matngan rangrangas mam iau, ngo da up bing iau, má kápte sang ina arkawar pala iáu.” Má bos kalilik án aratintin no di parai ngorer mul. ");
INSERT INTO sgz_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ái Iesu tiklik mai kán kalilik án aratintin di lu hanhan má dik hut i pokon di utngi ngo Getsemane, mái Iesu a parai si di ngo, “Gam iain, má iau ina han sung be.” ");
INSERT INTO sgz_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Má ngorer a lam pas Petero mái Iakobo mái Ioanes dihat má han. I pákánbung erei, lala tabureng a hut i narsán ái Iesu ");
INSERT INTO sgz_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","má ák parai si ditul ngoromin, “Tabureng a káng i balang má páput na baur iau. Gamtul iain má gamtula pán tangan iau.” ");
INSERT INTO sgz_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Ái Iesu a kálik láklák iamuda sár, mák pur uramudi bim mák sung ngoromin, “Keskam, Tata, arwat suri ngo pákánbung minái una long palai alar iau? Támin, iáu artálár suri long arwat pasi tan táit no, má ngorer iau sung iáu ngo una long palai á kinleh án rangrangas má minat alar iau. Mái sár káp una te mur i kak nemnem, una mur on ngorer i kam nemnem sang.” ");
INSERT INTO sgz_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ái Iesu a kaleng má a mák ruktul er ditul boptin, má a parai si Petero ngoromin, “Saimon, kamutul tu boptin be? Káp gamtul te arwat suri gamtula pán tangan iau i án mudán pákánbung sár?” ");
INSERT INTO sgz_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Má namur mul a parai si ditul ngo, “Gamtula pán má gamtulák sung suri gama tur rakrakai i pákánbung án artohtoh. Támin, bál gam a nem on, mái sár kápán páplun kápate rakrakai.” ");
INSERT INTO sgz_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Má a han alar ditul ái Iesu suri sung, má a parai sár mul i worwor ngorer ákte parai. ");
INSERT INTO sgz_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Má namur a kaleng mul, má ngorer a mákái kán atul i kalik án aratintin ditul boptin kabin a tuan taun i mát ditul. Má káp ditul te mánán i te lain worwor suri ditula parai mam Iesu. ");
INSERT INTO sgz_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Mái Iesu a han alar ditul mul, má namur a kaleng i átuil pákán mák parai si ditul ngo, “Kamu tu boptin má aunges be? Ákte arwat má. Pákánbung ákte hut. Mákái, minái má á Natun Kálámul dák top tari má uri limán bos tám sápkin. ");
INSERT INTO sgz_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Gam kodas, giták lu han má. Mákái, erei mái kálámul na agur tar iau.” ");
INSERT INTO sgz_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ái Iesu kán tu worwor be, mái Iudas, kes tili di á sángul mai aru, a kahra tiklik mai lala matananu di kipi kandi bos papam turán i di. Má bos pakpakta kán tan tám osmapak má bos tám mánán uri nagogon má bos kálámul pakta di dos palai matananu er suri tiklik mam Iudas. ");
INSERT INTO sgz_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Má ái koner a agur tar Iesu ákte para páksi kán akiláng narsán matananu ngoromin, “Kálámul er ina árár pasi mai doroi, ái sár á erei. Gama tolai má gamák mákmák kári urami kaleng i malar.” ");
INSERT INTO sgz_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Mái Iudas a hut mák láklák tálángna Iesu mák parai ngo, “Tám Aratintin!” má a doroi. ");
INSERT INTO sgz_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Má matananu di mák Iudas a longoi ngorer, ki dik top i Iesu má dik tolai. ");
INSERT INTO sgz_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Má kes tili di ái rung di tiklik mam Iesu ák taruh pasi kán is mák tárái toptop káián tám osmapak táil uri talngán mák tár kus palai talngán. ");
INSERT INTO sgz_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Namur ái Iesu a parai si di ngoromin, “Ngádáh, gam hol on ngo á iau kesi tám ngákngák ngorer gamá hut mai kamu bos papam suri gama up iau mai má kabat pas iau? ");
INSERT INTO sgz_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Marán á bung iau lu kis i katbán i gam ami rumán osmapak, má iau lu atintini matananu ái. Má suri dáh kápgamte tola iau i pákánbung er? Na, káksiai má suri gamák long arwat pasi worwor erei a parai i Buk Tabu.” ");
INSERT INTO sgz_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Má bos kalilik án aratintin di hol pala Iesu i pákánbung er má dik táu alari. ");
INSERT INTO sgz_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Má kesi kaukak kán tu mur i Iesu má a sulu mai bobor sár, má namur di tolai, ");
INSERT INTO sgz_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","mái sár a pakla pala di má dik tu top i kán sulu sár, má ái a táu mai kunsin. ");
INSERT INTO sgz_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Má di lam Iesu uri narsán tám osmapak táil, uratung i kuir rum kándi tu hut talum ái i bos pakpakta kán tan tám osmapak má bos kálámul pakta má bos tám mánán uri nagogon. ");
INSERT INTO sgz_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Mái Petero a lu murmur su i Iesu má a kusak urami pelbut i rum káián tám osmapak táil. Má a kis tiklik mai bos tám mákmák kalar iatung i risán kámnah mák manmanir. ");
INSERT INTO sgz_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Má bos pakpakta kán tan tám osmapak má kunlán kaunsel no di ser sur te kálámul suri da parai kandi te worwor uri Iesu ur singin kaunsel má namur kaunsel na oboi rangrangas ur on ngo na mat. Mái sár kápdite ser pas te ");
INSERT INTO sgz_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","kabin marán angagur án worwor di parai uri Iesu, mái sár kápate kes on á kandi worwor. ");
INSERT INTO sgz_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Má te kálámul di aptur má dik parai kandi angagur ngoromin, ");
INSERT INTO sgz_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Gim sang gim longrai a parai ngo na tarápái rumán osmapak erei di longoi mai lim di, má na him pasi atul á bung sár suri atur tekes bul er limán kálámul kápate longoi!” ");
INSERT INTO sgz_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Má káp sang a te arwat á tan worwor erei di parai uri Iesu. ");
INSERT INTO sgz_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Io, má tám osmapak táil a aptur i katbán i di mák gátna Iesu ngoromin, “Ngádáh, káp kam te kokos suri tan worwor minái di parai uri iáu?” ");
INSERT INTO sgz_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mái Iesu a tur pau má kápate kokos. Má tám osmapak táil a bali gáltai ngoromin, “Be, á iáu á Mesaia, natun ái Koner git lu para agasi?” ");
INSERT INTO sgz_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Mái Iesu a kosoi ngo, “Áá, á iau sár. Má gama mákái Natun Kálámul na kis tili risán mingin ái Káláu Tám Rakrakai Sorsorliu, má na hut mai kumlán mehmeh tilami bát.” ");
INSERT INTO sgz_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Má tám osmapak táil a mos i bál mák tarápái lusán mák parai ngo, “Suri dánih gita ser sur te kálámul suri para te táit mul? ");
INSERT INTO sgz_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Gamáte longrai er a parai ngo a arwat mam Káláu! Má gam, ngádáh á kamu hol?” Má tan kaunsel no di sormángát ngo ákte longoi sápkin, má ngorer di tari rangrangas singin suri na mat sang. ");
INSERT INTO sgz_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Má te kálámul di turpasi iapsi má ding kápti aur mai sepen kaen suri kápnate mákmák, ki dik ubi má dik parai singin ngo, “Una utung tusi ngo ái sinih er a up iáu!” Má bos tám arup di long pas Iesu má dik posposar on. ");
INSERT INTO sgz_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Mái Petero a iamudi lal i lol malar. Má kesi tahlik, toptop káián tám osmapak táil, a han ");
INSERT INTO sgz_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","má ák mák Petero kán tu manmanir. Má wák erei a han narsán mák lala mákái, má a parai singin ngo, “Á iáu mul u lu tiklik mam Iesu er kakun Nasaret.” ");
INSERT INTO sgz_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Mái Petero a arkawar palai mák parai ngoromin, “Káp iau te mánán má káp iau te talas suri táit er u parai.” Má a han má a tur kaplah alar di iamudi mátán kas, má namur kok a tang. ");
INSERT INTO sgz_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Má tahlik án toptop erei a bal mák Petero mák parai mul singin matananu iatung di sámtur pagas ngo, “Minái á kes tili di.” ");
INSERT INTO sgz_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mái Petero ákte lu arkawar pala Iesu mul. Má matananu di sámtur iatung di mul di parai si Petero ngo, “Muswan á iáu á kes tili di kabin ngo á iáu á kakun Galiláiá.” ");
INSERT INTO sgz_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Mái sár ái Petero a longrai ngorer má a parai ngoromin, “Iau oror mai muswan. Ngo káp iau te parai támin, ái Káláu na arangrangas i iau suri. Káp iau te mánán on á kálámul er kamu tu parai.” ");
INSERT INTO sgz_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Io, má káp melek sár má kok a tang i kán áruán tang, mái Petero a hol pasi worwor er a parai singin ái Iesu ngo, “I pákánbung kok kápate tang besang i kán áruán tang, una pua pala iau na tul i pákán.” Ái Petero a hol pasi worwor erei má a tinang i bál suri, mák lala tang. ");
INSERT INTO sgz_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","I kábungbung sáksák sang, di worwor talum á tan kaunsel no, á di ái rung erei bos pakpakta kán tan tám osmapak má bos kálámul pakta má bos tám mánán uri nagogon. Di no di worwor talum ngorer, má di kabat Iesu má dik lami uri narsán ái Pilato, kálámul pakta til Rom, má dik sisdo tari uri limán. ");
INSERT INTO sgz_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Mái Pilato á gátnai ngo, “Be, iáu á kabisit káián tan Iudáiá?” Mái Iesu a kos Pilato ngoromin, “Áá, a ngorer sang ukte parai.” ");
INSERT INTO sgz_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Má bos pakpakta kán tan tám osmapak di parai marán táit ur on, ");
INSERT INTO sgz_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","má ngorer ái Pilato a bali gálta Iesu ngo, “Mákái, marán má táit dikte parai uri iáu. Ngádáh, káp kam te kokos suri una kos di mai?” ");
INSERT INTO sgz_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mái sár ái Iesu kápte a káling kokos, má ngorer ái Pilato a pánsálngát suri. ");
INSERT INTO sgz_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","I tan bungun longsit án sorliu palai, ái Pilato a lu mángát palai kesi kálámul tili rumán batbat kalar, ái koner matananu di nem on. ");
INSERT INTO sgz_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","I pákánbung erei, te tám ngákngák dikte kabat di uri rumán batbat kalar. Tan kálámul er di ngákngák i nagogon til Rom má dik up bingi kálámul i kesá ororok. Má kes tili di ái rung er, ngisán ái Barabas. ");
INSERT INTO sgz_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Má matananu di hut narsán ái Pilato má dik sungi suri na longoi ngorer mul sang a lu longoi uri narsá di suri na pálás pala tekes tili rumán batbat kalar. ");
INSERT INTO sgz_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Mái Pilato a gáltai matananu ngoromin, “Gam nem on ngo ina pálás palai ur si gam á kabisit kán tan Iudáiá?” ");
INSERT INTO sgz_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ái Pilato a parai ngorer kabin a mánán ngo bos pakpakta kán tan tám osmapak di bálsák uri Iesu kabin matananu di árngai ngisán, má ngorer tan tátáil er dik obop Iesu uri nagogon. ");
INSERT INTO sgz_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mái sár bos pakpakta kán tan tám osmapak di soksokoi bál matananu suri ngorer ái Pilato nák pálás pala Barabas, mái Iesu káksiai. ");
INSERT INTO sgz_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Mái Pilato a bali gáltai matananu ngo, “Dánih má ina longoi mai kálámul minái er gam utngi ngo a kabisit kán tan Iudáiá?” ");
INSERT INTO sgz_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Má matananu no di kos Pilato ngo, “Bás páptai uri páspáng!” ");
INSERT INTO sgz_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Mái Pilato a gálta di ngoromin, “Suri dáh gama up bingi? Matngan sápkin ngádáh ákte longoi?” Má matananu di lala wakwak má dik parai ngo, “Bás páptai uri páspáng!” ");
INSERT INTO sgz_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ái Pilato a nem suri na abálbálái matananu, má ngorer a pálás pala Barabas ur si di, má a tar Iesu suri dik rapsi á tan tám arup má namur dák bás páptai uri páspáng. ");
INSERT INTO sgz_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Má namur bos tám arup di lam pas Iesu má ding kusak tiklik mai uri kesi kuir rum sang má ding kilkila talmi bos tám arup. ");
INSERT INTO sgz_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Má namur di long palai lusán má dik asulu on mai sulu a kás, má dik longoi kesi balaparip mai kaulbek má dik oboi i lul. ");
INSERT INTO sgz_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Má ngorer di tartar retret singin, má dik árár pasi ngorer i kálámul pakta má dik parai ngoromin, “Huihui iá! Erei má kabisit kándi tan Iudáiá!” ");
INSERT INTO sgz_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Má kándi tu boktoi lul mai bus má dik lu iapsi má dik lu pur dirtapul i mátán táil ái Iesu. ");
INSERT INTO sgz_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Má ngo dikte tartar retret no mai ngorer má, ki dik ulát palai sulu a kás tili kápán páplun ái Iesu má dik asulu kalengnai mai lusán sang. Má namur dik tangna pasi suri da bás páptai má uri páspáng. ");
INSERT INTO sgz_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Má ngo di lu hanhan tangra sál, di banai kesi kálámul ngisán ái Saimon, kakun Sairini, kákán ái Aleksada mái Rupus. Ái Saimon a lu hanhan suri na han urami Ierusalem, mái sár di tur páptai má dik tari duk on suri ák puski kán kubau kus ái Iesu. ");
INSERT INTO sgz_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Má ngorer di lam Iesu uri kuir pokon di utngi ngo Golgata, sálán ngo ‘koroson lul’. ");
INSERT INTO sgz_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Má ngo dikte hut á Golgata, di tari suir wain si Iesu erei di ariwai turán te suir kábau er a maptal suri long bingi rangrang, mái sár ái Iesu a matai má kápate ngin on. ");
INSERT INTO sgz_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Má namur di bás pápta Iesu uri kubau kus i asiu i pákánbung i kábungbung, má dik hom satu pasi kán tan táit ngorer i kán sulu má lusán ur kandi. ");
INSERT INTO sgz_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Má di le i worwor er di nagogon on suri ngoromin, “Kabisit kán tan Iudáiá”. ");
INSERT INTO sgz_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Má di bás páptai aru i tám ngákngák tiklik mam Iesu mul, kes tili balsán mingin má kes tili balsán káisán. ");
INSERT INTO sgz_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Má ngorer di long arwat pasi worwor tili Buk Tabu er a parai ngoromin, “Di wásái turán bos tám sápkin.” ");
INSERT INTO sgz_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Má ngorer matananu di sorliu má dik mák Iesu iamuni naul kubau kus má di luhluhrai lul di sár ur on má di ret mai ngoromin, “Wái! Á iáu u parai ngo una tarápái rumán osmapak, má ngo una him pasi atul á bung sár suri long kalengnai! ");
INSERT INTO sgz_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Erei má una aliu pas iáu sang má unák sosih tilatung i naul páspáng!” ");
INSERT INTO sgz_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Má ngorer mul bos pakpakta kán tan tám osmapak má bos tám mánán uri nagogon di tartar retret mam Iesu mul má dik worwor arliu i di má dik parai ngo, “A aliu pasi boh lite kálámul, mái sár kápate arwat suri na aliu pasi sang. ");
INSERT INTO sgz_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Onin sang gita mákái má á Mesaia má kabisit kán Israel na sosih alari páspáng suri giták ruruna on!” Má aru i tám ngákngák di bás pápta diar turán ái Iesu, diar mul diar ret mai má diará wáng on. ");
INSERT INTO sgz_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Má i sángul mai aru á pákánbung, nas a kuron má a bohoi kunlán balis er, má kuron a pang i atul á pákánbung. ");
INSERT INTO sgz_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Má i atul á pákánbung i rahrah, ái Iesu a kilkila ngángra Káláu ngoromin, “Eloi, Eloi, lama sabaktani?” Sálán ngoromin, ‘Káláu, kang Káláu, suri dáh ukte hol pala iau?’ ");
INSERT INTO sgz_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Má te tili di á matananu di sámtur pagas iatung páput, di longrai má dik parai ngo, “Gama longrai, a kilkila Elaisa.” ");
INSERT INTO sgz_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Má kes tili di a rut mák long pasi kesi táit ngoro loson lamas, má a dungi uri kinleh suir wain er a maptal mák sosap pasi suir wain. Má a akai táit er i kuir gáh mák sua tari uramuni ngudun suri na ngin on. Má namur kálámul er a parai ngo, “Giták mákái be ngo ái Elaisa na hut má nák tángni suri na asosih on tilamuni naul kubau kus.” ");
INSERT INTO sgz_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Má namur ái Iesu a lala kilkil má ák mat. ");
INSERT INTO sgz_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Má tilik sulu ami polgon rumán osmapak a ráp tilami iát uradi lal má ák ru on. ");
INSERT INTO sgz_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Má tátáil kán bos tám arup a sámtur pagas iatung i risán suri ololoh i táit di longoi mam Iesu. Má ngo a mák Iesu ngádáh a mat ngoi, ki ák parai ngo, “A támin muswan, kálámul minái war ái á Natun ái Káláu.” ");
INSERT INTO sgz_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Te wák di iatung mul i pokon er, mái sár di kálik tur tepák suri mák Iesu. Má iatung i katbán tan wák erei ái Salome, mái Maria Magadalene, mái Maria mámán ái Iakobo mái Iosep. ");
INSERT INTO sgz_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kándi tu murmur i Iesu ami Galiláiá má dik tángni. Má te marán wák mul di iatung di mur i Iesu átik á Ierusalem. ");
INSERT INTO sgz_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ákte páput má suri rahrah i bung erei, mái Iosep til Aramatia a hut. Ái á kesá kaunsel má ngorer di mánán on, má a kesi lain kálámul mul, má a kis monai lolsit si Káláu suri na hut. Bungán eran on á bung er suri eran uri bungán aunges. Ái Iosep a hol palai kán mátut má ngorer a han mák gálta Pilato suri kápán páplun ái Iesu suri na tahni. ");
INSERT INTO sgz_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ái Pilato a sodar suri longrai ngo ái Iesu ákte mat, má ngorer a artari suri tátáil kán tan tám arup má ák gáltai ngo, “A támin muswan ngo ái Iesu ákte mat?” ");
INSERT INTO sgz_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mái Pilato a longrai arbin suri minat si Iesu singin tátáil er, ki ák mángát tari kápán páplun ái Iesu ur si Iosep. ");
INSERT INTO sgz_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ái Iosep a han hul pasi kesi sepen sulu má a kaleng mai. A asosih i kápán páplun ái Iesu mák duri mai sepen sulu er, má a kipi uri tarang án minat dikte ili tungu tili bángbágil hat. Má namur di girwai kesi lala hat má dik batbat kári mátán tarang er mai. ");
INSERT INTO sgz_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mái Maria Magadalene mái Maria mámán ái Iosep diar mák páksi pokon di tahun Iesu ái. ");
INSERT INTO sgz_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Má namur ngo ákte rah i bungán aunges, ái Salome mái Maria Magadalene mái Maria mámán ái Iakobo, ditul hul pas te táit a tomtom ngorer i kabang má wel suri ditula han má ditulák pukri kápán páplun ái Iesu mai. ");
INSERT INTO sgz_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Má i Sade i kábungbung sáksák i pákánbung ákte pos i nas, ditul han uri mátán hat er di dung Iesu ái. ");
INSERT INTO sgz_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Má ngo ditul lu hanhan tangrai sál, ki ditulá gátna arliu i ditul ngo, “Ái sinih na girwa palai á hat tili mátán sál ur si git?” ");
INSERT INTO sgz_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Má namur ditul mákmák má ditulá mákái tilik lala hat erei dikte girwa palai má alari mátán hat, má mátán sál ákte pasbat. ");
INSERT INTO sgz_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Má ditulá kusak uri polgon hat er, má iatung ditulá mákái kesi kálámul kaukak a mermer mai lusán a bal, má a kis pagas tili balsán ming ditul, má ditulá sodar on. ");
INSERT INTO sgz_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Má kálámul er a parai si ditul ngoromin, “Dánih gamtul sodar suri? Gamtul mákmák sur Iesu kakun Nasaret er di bás páptai uri kubau kus. Bokoh ái á main, ákte liu kaleng. Gamtul mákái, minái á pokon di oboi on. ");
INSERT INTO sgz_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Gamtula han má, má gamtulák parai si Petero má kán tan kalilik án aratintin ngo na táil i gam urami Galiláiá, má erei á pokon gama mákái ái ngorer ákte parai si gam.” ");
INSERT INTO sgz_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Má ditulá longrai ngorer, ki ditulá so alari mátán hat má ditulá táu, má ditulá ráuráuwas má ngátngát sálán táit ditul mákái. Má káp ditul te worwor mul mam tekes kabin ditul mátut. ");
INSERT INTO sgz_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Mái Iesu a liu kaleng i kábungbung on i mulán bung i wik er, má a mulán tur soura si Maria Magadalene, wák erei a long palai ahit i sápkin tanián alari. ");
INSERT INTO sgz_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ái Maria a han ngorer mák bitái rang turán ái Iesu, rung er kándi tu tang má kis án tinang suri. ");
INSERT INTO sgz_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Má ngo di longrai ngo ái Iesu ákte liu kaleng má ngo ái Maria sang ákte mákái, kápdite ruruna on. ");
INSERT INTO sgz_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Má namur mul ái Iesu a tur soura singin aru tili di er diar láklák tangrai sál, má a mák lite i kápán páplun ái Iesu. ");
INSERT INTO sgz_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Diar mákái ngorer má diará kaleng urami Ierusalem má diará bitái rang turán ái Iesu ngo diaráte mák Iesu, mái sár kápdite ruruna i diar mul. ");
INSERT INTO sgz_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Namur mul ái Iesu a tur soura singin sángul mai kesi kán kalik án aratintin i pákánbung di namnam. Má ák bor di kabin ngo a gáugáu i kandi ruruna má a laklak i bál di, má ngorer kápdite ruruna i táit ái rung erei di parai ngo dikte mák Iesu má ákte liu kaleng. ");
INSERT INTO sgz_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Mái Iesu a parai si di mul ngoromin, “Gama han uri naul matmatngan pokon má gamák arbin mai lain arbin uri narsán matananu no. ");
INSERT INTO sgz_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Koner a ruruna má dik siwi, ái na aliwi ái Káláu. Má ái koner kápate ruruna, na tur i nagogon. ");
INSERT INTO sgz_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ái rung erei di ruruna, da longoi tan akiláng ngorer da tipar palai sápkin tanián mai ngisang; má da worwor mai toltolom hutngin worwor; ");
INSERT INTO sgz_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","má ngo da top i kanih ngo da ngin i dan a mon i wah on, kápnate long sáksáknai kándi liu; má da top i rung er di sasam má da sengsegeng.” ");
INSERT INTO sgz_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ái Iesu a arahi kán worwor uri narsá di á rang turán, má namur ái Káláu a duruk pasi urami naul bát má ák han aksimi i balsán mingin sang. ");
INSERT INTO sgz_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Má tan kalilik án aratintin di han arkaliut mai arbin, mái Konom a him tiklik mam di má a tangan di suri ngorer tan akiláng erei di longoi a para tari singin matananu ngo a támin muswan i worwor di arbin mai. A ngorer sár. ");
INSERT INTO sgz_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Marán dikte long artálár pasi suri sir páptai arbin suri tan táit a tapam hut si gim. ");
INSERT INTO sgz_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Tan táit erei sur Iesu di longrai si di ái rung di mákái mai mát di tili tangkabin muswan, má di lu arbin talas suri. ");
INSERT INTO sgz_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Má iau mul iau ser pasi á tan táit minái uri kán kunlán liu ái Iesu, turpasi tili tangkabin ák pang i arahrahi kán liu, má iak mánán on. Má ngorer iau nem ngo ina tahngai ur singim, Konom Tiopilo, á tan táit erei ákte hut tungu ");
INSERT INTO sgz_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","suri una mánán kuluk i támin muswan i tan boh táit minái ngorer dikte atalsa iáu suri. ");
INSERT INTO sgz_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","I bos bet er ái Erodes a kabisit i balis á Iudáiá, ái Sakaria a tám osmapak iatung tili rákán him án osmapak erei ái Abia a kátlán i di. Kán wák ái Sakaria tili gegen si Aron, má ngisán ái Elisabet. ");
INSERT INTO sgz_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Diar kis má diará lu láklák namurwai nagogon si Káláu, má diará lu long arwat pas noi. ");
INSERT INTO sgz_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mái sár káp kándiar te kalik káplabin ngo ái Elisabet a koros, káp a tini kákáh. Má i pákánbung er ái Sakaria ákte lala pupunkak má, mái kán wák ákte lala wákánkak sang mul. ");
INSERT INTO sgz_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","10","I bung erei, gegen si Abia di lu him i rumán osmapak, má dikte ilwa pas Sakaria suri na osoi lom a tomtom uri narsán ái Káláu, má ngorer a kusak uri rumán osmapak i nián ái Konom suri na osoi lom. Má lala matananu di kis i karpala má kándi tu sung i án pákánbung erei ái Sakaria a osoi lom on. ");
INSERT INTO sgz_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Má i pákánbung erei, kesi angelo si Konom a purut narsá Sakaria má a tur pagas tili balsán mingin i nián osmapak uri osos lom. ");
INSERT INTO sgz_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ái Sakaria a mákái angelo erei má a sodar mák lala ráuráuwas. ");
INSERT INTO sgz_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mái sár angelo a parai singin ngoromin, “Koion una mátut, Sakaria! Ái Káláu ákte longrai á kam sung, má kam wák ái Elisabet na káhái besang i tekesi natum na kalik káláu. Una utngi ngisán mam Ioanes. ");
INSERT INTO sgz_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Na gas i balam má una laes, má kán páng á kalik er na tari gasgas singin marán kálámul. ");
INSERT INTO sgz_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Má kalik erei na kálámul kuluk má na ninir i ngisán i mátán ái Káláu. Kápnate lu ngin i wain ngo te dan rakrakai. Má na tep i kán liu mai Tanián a Pilpil tangkabin tili bál ái mámán sang. ");
INSERT INTO sgz_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Má na lam te marán matananu til Israel dák pukdai kándi liu má dák ilang sur Káláu erei kándi Konom. ");
INSERT INTO sgz_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kalik erei na hut táil i Konom, má rakrakai káián Tanián na mon on ngorer a mon mul i Elaisa hirá, má na láklák namurwai kemen ái Elaisa. Na lu obop arsaktai rang kák di mai rang nat di suri da kepwen kaleng, má na lu pukdai tám abulbul náng kaleng uri sálán holhol a nokwan, má na aleget i matananu suri kán purpurut ái Konom.” ");
INSERT INTO sgz_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ái Sakaria a longrai ngorer má a pánsálngát i worwor er, má a parai singin angelo ngoromin, “Ngádáh ina mánán ngoi á táit minái uri narsang kabin iakte lala pupunkak má, mái kak wák ákte lala wákánkak sang mul?” ");
INSERT INTO sgz_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mái angelo a parai si Sakaria ngo, “Á iau ái Gabiriel á minái, iau lu tur i mátán táil ái Káláu. Ái Káláu sang a tari palai iau má minái iau purut suri para talsai singim á lain arbin a dos pala iau mai. ");
INSERT INTO sgz_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mákái! Káplabin kápute ruruna i kak worwor minái, na gap i ngudum má káp una te worwor nák han pang i bung er tan táit minái na tur apos. Pinpidan kaiak minái na hut muswan i kán pákánbung sang.” ");
INSERT INTO sgz_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Matananu di lala nana Sakaria má di lala holhol ngo dánih má ák lu longoi iatung i rumán osmapak. ");
INSERT INTO sgz_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Má namur a soura má kápate arwat suri na worwor mai matananu, má ngorer dikte mánán on ngo ákte mákái tekesi táit iatung i rumán osmapak. Má kápate para te worwor, a longoi akiláng sár mai limán uri narsá di. ");
INSERT INTO sgz_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Namur má, ákte artálár i kán bungun him iatung i rumán osmapak, mái Sakaria a kaleng má uri kán malar. ");
INSERT INTO sgz_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Má namur i te bung sár, ái Elisabet a tián. Má ákte arwat mai alim i kalang a tián pasi, mái sár kán tu kis besang iatung i rum, káp a tini so uri malar. Má a parai ngoromin ái Elisabet, ");
INSERT INTO sgz_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ái Konom a lala mámna iau má a tangan iau má a tari kalik singing suri ina káhái. Tungu iau koros mák mon i kak rumrum i mátán matananu. Má onin ái Konom ákte pah palai.” ");
INSERT INTO sgz_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","I awon i kalang palai kán tián ái Elisabet, ái Káláu a dos palai kesi angelo ngisán ái Gabiriel uri balis á Galiláiá má uri gengen malar á Nasaret. ");
INSERT INTO sgz_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Angelo a han mai worwor ur singin kesi kalik átlái kápte be a bop mai káláu, ngisán ái Maria. Má kalik átlái erei ákte mon i tar kári suri na kila pasi kesi kalik kaukak ngisán ái Iosep, a gegen si kabisit Dewit. ");
INSERT INTO sgz_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Angelo a han hut i narsán má ák parai singin ngoromin, “Maria, ái Káláu a laes mam iáu má a kis i narsam!” ");
INSERT INTO sgz_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ái Maria a longrai worwor erei a parai á angelo uri narsán, má a rogorogo i kán hol mák hol on ngo, “Matngan pinpidan ngádáh á ngoro minái?” ");
INSERT INTO sgz_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Má angelo a parai singin ngo, “Koion una mátut, Maria, kabin ái Káláu a lain kuluk mam iáu má ákte ilwa pas iáu. ");
INSERT INTO sgz_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Una longrai be, Maria! Una tián besang má unáng káhái kalik án káláu, má una tar ngisán mam Iesu. ");
INSERT INTO sgz_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ái na kálámul pakta da árngai ngisán, má ái mul da tar ngisán ngo Natun ái Káláu Sorsorliu. Ái Káláu er Konom na tari ur singin á kiskis án kabisit si Dewit kámpupun, ");
INSERT INTO sgz_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","má ái mul na kabisit áklis i tan sumlahin ái Iakop, má kán lolsit kápnate pang kus!” ");
INSERT INTO sgz_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ái Maria a longrai ngorer má a parai singin angelo ngo, “Ngádáh sang na hut ngoi uri narsang á ngoromin, kabin káp iau te bop be mam tekesi kálámul?” ");
INSERT INTO sgz_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Má angelo a kosoi ngoromin, “Tanián a Pilpil na sos i iáu, má rakrakai káián ái Káláu Sorsorliu na kis i narsam. Má ngorer kalik er na páng besang, da utngi ngo a pilpil má da utngi mai Natun ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Una hol pas Elisabet er buham, ái koner di lu parai ngo a koros, má ákte lala wákánkak mul. Mái sár onin ákte won má kán kalang a tián mai kalik án káláu. ");
INSERT INTO sgz_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Káplabin kápte kesi táit ngo ái Káláu kápate arwat suri na longoi. Tan boh táit no ái Káláu a artálár suri long arwat pas noi.” ");
INSERT INTO sgz_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ái Maria a longrai ngorer má a parai singin angelo ngo, “Na longoi sár ngorer u parai mam iau ái Konom, kápkabin ngo iau mul iau kán toptop.” A be parai ngorer ái Maria, má angelo a han pas alari. ");
INSERT INTO sgz_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Te bung namur ái Maria a eran má a han suri mák Elisabet. A sangsangar i tapam tangrai sál ái Maria urami balis á Iudáiá imi pungpung, mák han hut iatung i malar si Sakaria ");
INSERT INTO sgz_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","máng kusak uri kán rum mák rahrah pas Elisabet iatung. ");
INSERT INTO sgz_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Má ngo ái Elisabet a longrai worwor si Maria, kalik imi bál ái Elisabet a lala biluk. Má i pákánbung erei sang, Tanián a Pilpil a sos i Elisabet, ");
INSERT INTO sgz_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","mái Elisabet a worwor mai worwor án arasosah má a worwor mai lala kaungán ur si Maria ngoromin, “Ái Káláu a lain kuluk mam iáu, Maria, alari boh wák no! Má na kuluk mul mai kalik er i balam una káhái be! ");
INSERT INTO sgz_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Suri dánih á matngan táit ngoro minái a hut i narsang, ái mámán ái kang Konom a purut suri laum iau? ");
INSERT INTO sgz_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","I pákánbung u han purut mainái má uk parai te worwor, má irngán kam worwor a kusak uri talngang, ki kalik minái i balang a gasgas má a lala biluk. ");
INSERT INTO sgz_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Iáu kuluk pala kápkabin ngo ukte ruruna i kán worwor ái Konom a parai singim ngo na long arwat pasi sang.” ");
INSERT INTO sgz_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Má namur ái Maria bul a parai kán saksak án parpara agas ngoromin, “Balang a árnga Konom, ");
INSERT INTO sgz_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","má taniang a gasgas sur Káláu kak Tám Araliu! ");
INSERT INTO sgz_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Suri dáh, a hol pápta iau má iau kán maris án toptop sár. Má turpasi til onin, bos ngaul matananu no da lu utung iau ngo iau kuluk pala, ");
INSERT INTO sgz_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kápkabin suri lala támin táit ákte longoi mam iau ái Koner a Rakrakai Sorliu. A pilpil i ngisán! ");
INSERT INTO sgz_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Turpasi tungu i akaksim nák han pang i arahrahi, ái rung di lu rumrum on tili keskeskesi ngaul kálámul, a inngasi kán armámna uri narsá di. ");
INSERT INTO sgz_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","A lu longoi tan támin táit a rakrakai mai limán. A lu long sara di ái rung di apakta pas di sang. ");
INSERT INTO sgz_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","A kip asosih i di á tara kabisit tili kándi kiskis, mái sár a apakta pas di ái rung di maris. ");
INSERT INTO sgz_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","A lu akáng di mai lain táit ái rung di sáhár, má a lu dos palai tan konom mai wáin lim di. ");
INSERT INTO sgz_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","A kebeptai sang á oror er a oror mai ur singin rang támin i git, má ur si Abaram, má ur si di á tan sumlahin kalik mur. Má kán oror na kis áklis má kápnate rah! A hol páptai kán oror suri mámnai matananu Israel, má ngorer a tangan di.” ");
INSERT INTO sgz_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ái Maria a arahi kán parpara agas, má namur a kis i narsá Elisabet artálár mai atul i kalang, má namur a elkaleng ur Nasaret. ");
INSERT INTO sgz_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Má namur pákánbung ákte páput ngo ái Elisabet na káhái natun, ngorer a kákáh má a káhái natun kalik káláu. ");
INSERT INTO sgz_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Rang buhán má di no tili malar erei di longrai kalik ákte páng, má di ot kuluk suri armámna káián ái Konom uri narsá Elisabet, má ngorer di lala gasgas má parmat mam Elisabet. ");
INSERT INTO sgz_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kalik ákte liu artálár mai awal i bung, má namur di hut talum suri kut aririu i kalik, má di nem suri tari ngisán kalik mam Sakaria ngo na kipi ngisán sang ái kákán. ");
INSERT INTO sgz_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mái sár ái mámán a parai ngo, “Koion. Ngisán á kalik min ái Ioanes.” ");
INSERT INTO sgz_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Di longrai ngorer má dik parai si mámán ngoromin ngo, “Kápte kesi buh gaur mai matngan ngisán ngorer suri ngo gita utngi kalik mai.” ");
INSERT INTO sgz_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Má namur di worwor mai lim di suri ák mákái ái Sakaria, má di gátnai suri matngan ngis ngádáh ái kákán sang á kalik a nem on ngo na utngi mai á natun. ");
INSERT INTO sgz_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakaria a worwor mai limán uri narsá di iatung sur te pákán ram, má ding kip tari kesá pákán ram, má ák le i ngisán kalik on ngoromin ngo, “Ngisán kalik erei ái Ioanes.” Di mákái ngorer má dik lala sodar. ");
INSERT INTO sgz_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Má káp melek sár mák pasbat mul i ngudun ái Sakaria má a worwor mák para agas Káláu. ");
INSERT INTO sgz_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Má matananu tili malar er di mákái ngorer má dik mátut. Má namur arbin suri tan táit minái a hut pakta má a han arkaliut i balis no á Iudáiá imi pungpung. ");
INSERT INTO sgz_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Mái rung di longrai arbin erei di lala holhol suri, má di gátna ngo, “Matngan dánih na longoi á kalik erei má na matngan kálámul ngádáh?” Di parai ngorer kápkabin ngo rakrakai má ololoh káián Konom a kis tiklik mai. ");
INSERT INTO sgz_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Má Tanián a Pilpil a sos i Sakaria er kákán kalik, má ngorer ái Sakaria a parai kán worwor tus ngoromin, ");
INSERT INTO sgz_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Git no sang gita párnga Káláu er Konom káián matananu Israel, suri ákte hut sosih má ák tangan pasi kán matananu alari kángit kis án kamkabat, má a asengsegeng i git. ");
INSERT INTO sgz_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","A atri kángit Tám Araliu a tikai mingin, kes er tili gegen si Dewit, ");
INSERT INTO sgz_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ngorer ákte para páksi alhirá sang mai ngus di á kán tan tám worwor tus. ");
INSERT INTO sgz_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ákte oror suri na saras pas git tili limán kángit tan boh kurtara má alar rung erei di lu mikmikwa git. ");
INSERT INTO sgz_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","A parai ngo na inngasi armámna si di á rang kámpup i git, má suri na kebepta áklisnai kán kamkabat er ákte parai alhirá sang. ");
INSERT INTO sgz_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ái á oror er a oror pagas mai ur si Abaram, kámpup i git, ");
INSERT INTO sgz_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ngo ái Káláu na saras pas git tili limán kángit tan kurtara. Má ngorer gita sengsegeng suri lotu uri narsán mai bál git a matau má mátut na koion, ");
INSERT INTO sgz_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","má suri gita tám nokwan má tám pilpil i mátán táil ái Káláu i bosbos bung ngo gita liu on. ");
INSERT INTO sgz_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Á iáu, natung, da utung iáu mai tám worwor tus káián ái Káláu Sorsorliu, kabin ngo una láklák táilna Konom má una timani kán sál. ");
INSERT INTO sgz_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ngorer una atintini kán matananu suri da mánán ngo ái Káláu a nem ngo na pah palai kándi sápkin tatalen suri na aliu di ");
INSERT INTO sgz_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","a kabin i kán lala armámna. Má ngorer na tar sosih i kángit Tám Araliu tilami ");
INSERT INTO sgz_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","suri na atalsa rung di liu i kuron má ái rung páput da mat, má na atintin git mul suri láklák i sál a matau.” Ái Sakaria a arahi kán worwor tus má a aunges iatung. ");
INSERT INTO sgz_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Má namur kalik erei a pakta hanhan i kápán páplun, má tanián kalik a maras mul má ák rakrakai má. Mái Ioanes a lu kis i pokon mau ák han pang i bung ngo a tur soura i mátán matananu til Israel. ");
INSERT INTO sgz_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","I bet erei ái Ioanes a páng on, ái Kurinias a kátlán i balis á Siria, má a kis mul i lalin ái Kaisar Augusto, pakpakta til Rom. Mái Kaisar Augusto a tar palai kesi nagogon suri tan matananu no er di kis i lalin Rom, boh wák má tan káláu, ngo da han suri sir páptai ngis di. Má minái a mulán pákán suri le páptai ngis di ngorer. ");
INSERT INTO sgz_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Má ngorer tan matananu no di han suri da le páptai ngis di, ngorer keskeskes na han uri kán malar muswan sang suri da sir páptai ngisán ái. ");
INSERT INTO sgz_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Mái Iosep mul a han suri da sir páptai ngisán. Má ngorer a aptur alari gengen bimán rum á Nasaret i balis á Galiláiá má, uri gengen bimán rum á Betilem i balis á Iudáiá, malar erei ái kabisit Dewit a páng ái. A han uratung ái Iosep a kabin ngo ái a gegen má a kalik mur si Dewit. Má i pákánbung a han ái Iosep, diar no ái Maria, kalik átlái erei ái Iosep ákte tar kári suri diara kila. Mái sár ngo ái Maria ákte tián sang, ");
INSERT INTO sgz_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","má ngo kándiar tunga kis besang á Betilem, ákte arwat i bung suri ái Maria na káhái kalik. ");
INSERT INTO sgz_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Má ngorer a káhái mulán natun, a kalik án káláu, má diar má duri mai sepen kaen má diar má oboi mái kalik i polgon papkim i nián namnam kán tan ololas, a kabin ngo kápte te arlih on á rumán asir, ákte káng má. ");
INSERT INTO sgz_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Iatung i balis erei, te tám ololoh sipsip di pán rákna i libung erei mai ololoh i kandi tan sipsip ada i bos. ");
INSERT INTO sgz_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Má angelo káián ái Káláu a soura narsá di, má talas káián Káláu a atalsa di no sang. Má di lala ráuráuwas má di lala mátut, ");
INSERT INTO sgz_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","mái sár angelo a parai si di ngo, “Koion gama mátut! Gama longrai! Minái iau hut sosih uri narsá gam mai lain arbin suri lala laes na bontai matananu no. ");
INSERT INTO sgz_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Onin i libung, idi bimán rum á Betilem, malar si Dewit sang, kamu Tám Araliu ákte páng–ái Konom er Mesaia, koner a ilwa pasi ái Káláu! ");
INSERT INTO sgz_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Má ngoromin gama mák ilmi ngoi. Gama ser pasi kalik dikte duri mai sepen kaen má dikte oboi i papkim i nián namnam kán tan ololas.” ");
INSERT INTO sgz_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","A be parai ngorer, ki káp melek mul marán angelo di tur soura má dik tur tiklik mai mulán angelo er, má dik parpara agas uri narsán ái Káláu ngoromin, ");
INSERT INTO sgz_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Gita sángwái má gita para agasi ngisán ái Káláu urami sang i naul bát! Má uri naul bim mul, matau ur singin matananu erei a laes ái Káláu sur di.” ");
INSERT INTO sgz_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Má namur bos angelo di kaleng urami bát alar di, má tan tám ololoh sipsip di worwor talum má dik parai ngoromin, “Io, git má. Giták han ur Betilem má giták mákái táit erei ákte tapam hut má ái Káláu ákte inngasi uri narsá git.” ");
INSERT INTO sgz_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ngorer di sangsangar i láklák uradi Betilem, má namur sár di ser pas Maria diar ái Iosep, má di mákái kalik a bopbop pagas i papkim. ");
INSERT INTO sgz_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tan tám ololoh sipsip dikte mák ditul ngorer, má namur di para aposoi lain arbin suri kalik ngorer ái angelo ákte parai si di. ");
INSERT INTO sgz_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mái rung di longrai arbin erei di lala sodar má di pánsálngát i pinpidan erei tan tám ololoh sipsip dikte parai si di. ");
INSERT INTO sgz_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mái sár ái Maria a kebeptai tan táit erei má ák holhol mul namurwai. ");
INSERT INTO sgz_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Má tan tám ololoh sipsip di kaleng urami kándi malar, má di para agas Káláu má dik sángwái ngisán suri tan táit dikte longrai má dikte mákái a ngorer sang i angelo ákte parai si di. ");
INSERT INTO sgz_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Má namur ngo ákte rah i awal á bung má, ákte arwat mul i bung suri ngo da kut aririu i kápán páplun kalik. Má ngorer diar kipi kalik má ding kuti má dik tar ngisán mam Iesu, ngisán erei angelo ákte utung páksi sang si Maria i pákánbung kápate tián be. ");
INSERT INTO sgz_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Iatung i nagogon ái Káláu a tari si Moses, a parai ngoromin, “Ngo wák a mulán bál mai kalik án káláu, ki da utngi kalik er ngo káián ái Káláu.” Tan Iudáiá di lu mur i nagogon erei, má kes mul á nagogon si Káláu di lu mur on a ngoromin. Ngo wák a káhái kalik káláu, ki na rah i ahat i sángul á bung, diar tinán diara han mam te na ru i bun ngo te na ru i maran suri osmapak mai uri narsán ái Káláu suri apilpil pas diar tinán. Io, ákte arwat i pákánbung erei suri arapilpil, diar mokson kipi kalik urami Ierusalem suri para tari kalik i mátán táil ái Káláu suri ditula long arwat pasi nagogon káián ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Má kesi kálámul a lu kis á Ierusalem ngisán ái Simion. Ái a tám nokwan má a lu kebeptai nagogon si Káláu, má a kis nanai arasosah káián matananu Israel ngo na hut. Má Tanián a Pilpil a mon on, ");
INSERT INTO sgz_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","má ákte inngasi singin ngo kápnate mat besang, má na mákái Karisito er Mesaia si Káláu. ");
INSERT INTO sgz_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Má Tanián a mulán lam Simion urami rumán osmapak i bung erei má a kis iatung. Má ngo ái Iosep diar diar káhái kalik er ái Iesu urami rumán osmapak ngorer di lu longoi sang suri long arwat pasi nagogon, ");
INSERT INTO sgz_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ái Simion a mák ditul iatung mák long pasi kalik er uri limán má ák para agas Káláu ngoromin, ");
INSERT INTO sgz_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Konom, minái una pálás palai má i kam toptop má na han mai matau, kabin ukte kebeptai kam oror. ");
INSERT INTO sgz_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Iakte mákái má mai aru i matang sang á kam Tám Araliu, ");
INSERT INTO sgz_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ái koner ukte eran páksi suri matananu no da mákái. ");
INSERT INTO sgz_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ái á talas suri inngas tari kam sál ur si di ái rung tili risán, má da para agasi kam matananu Israel kabin ái á sumlahin i di.” ");
INSERT INTO sgz_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ái Iosep mái Maria diar longrai ngorer má diar pánsálngát i tan pinpidan erei ái Simion a parai sur Iesu. ");
INSERT INTO sgz_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","A worwor án arasosah narsá ditul ái Simion, má namur ák parai si Maria, mámán ái Iesu, ngoromin, “Kalik minái a ilwa pasi ái Káláu, má ái á káplabin marán tili matananu Israel da pur, má marán mul da aptur. Má ái sang á akiláng káián ái Káláu, má marán da arpua ur on, ");
INSERT INTO sgz_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","má tan holhol kodong káián marán matananu na tur soura be. Má á iáu, mámán, una kis án tabureng, má na ngoro lamrut a nokas na soi nitam.” ");
INSERT INTO sgz_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Má kesi wák mul a tapam hut i bung erei sang. Má wák er a lu worwor tus, ngisán ái Ana, natun tahlik ái Panuel, má ái tili gegen erei ái Aser. Ákte kila artálár mai ahit á bet, má namur kán pup a mat alari má áng kis mokos má. Má i pákánbung er ákte lala wákánkak mul, a arwat mai awal i sángul mai ahat i kán bet. Má wák er a lu balbal han uri rumán osmapak suri lotu, mák lu ahal mák lu sung i libung má i nas mul uri narsán ái Konom. ");
INSERT INTO sgz_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ái Ana a tapam hut i bung erei, má a mák ditul támán er má ák parpara agas má ák ot kuluk narsá Káláu. Má namur a lu arbin suri kalik uri narsán rung erei kándi tu mákmák suri pákánbung ngo ái Káláu na kip kalengnai Ierusalem alari kán tan kurtara. ");
INSERT INTO sgz_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Pákánbung dikte arahi kándi him ngorer a para ngoi i nagogon si Konom, ki namur má ditul má kaleng ur Galiláiá, uri kánditul malar á Nasaret. ");
INSERT INTO sgz_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Má kalik er a pakta hanhan má a rakrakai má a káng mai polon á hol, má arasosah si Káláu a kis i narsán kalik. ");
INSERT INTO sgz_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tan bos bet no ái kákán mái mámán ái Iesu diar lu han ur Ierusalem suri akiláng i longsit án sorliu palai. ");
INSERT INTO sgz_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Má namur, i pákánbung sang ngo ái Iesu ákte sángul mai aru i kán bet, ditul han suri kis i longsit án sorliu palai ngorer i kándi tatalen sang. ");
INSERT INTO sgz_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Má i bung ngo ákte rah i longsit, di turpasi má suri láklák kaleng uri kándi malar á Nasaret, mái sár ngo ái Iesu masik a lu kis á Ierusalem. Ái kákán mái mámán káp diar te mánán on ngo ái Iesu a lu kis pala. ");
INSERT INTO sgz_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Diar má hol on ngo ái Iesu ákte láklák táil turán te rang buh di ngo rang tur di. Má ngorer dikte láklák artálár mai kesi kunlán bung, má namur diar má turpasi mákmák suri i katbán matananu erei di tiklik no, ");
INSERT INTO sgz_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","mái sár bokoh ái. Má namur diará kaleng mul suri mákmák ami Ierusalem. ");
INSERT INTO sgz_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","I átuil bung namur, diar má mák pasi má ami rumán osmapak tiklik mai tan tám aratintin, a kis án alongra suri tan worwor di parai má a gálgálta i di mul mam te argálta. ");
INSERT INTO sgz_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Mái rung erei di longrai pinpidan si Iesu, di korantik má di pánsálngát suri a melmelek i kán mánán má suri kán kokos uri narsá di. ");
INSERT INTO sgz_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mái kákán mái mámán diar mák Iesu iatung má diará pángáng, mái mámán a parai singin ngoro minái, “Kauh, suri dánih u longoi matngan tatalen minái mam giur? Giur ái kakam giur lala konngek má giurá ser sur iáu.” ");
INSERT INTO sgz_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Mái Iesu a kos diar ngoro minái má ák parai si diar ngo, “Suri dánih gaur lala ser sur iau? Ngádáh, káp gaur te mánán ngo kak talar ngo ina lu kis i rum si Tata?” ");
INSERT INTO sgz_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Diar longrai ngorer, mái sár ngo káp diar te mánán on á sálán i pinpidan erei ái Iesu a parai si diar. ");
INSERT INTO sgz_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Má ngorer ditul támán má tiklik kaleng ur Nasaret, má a alongra mák lu taram si diar ái Iesu. Mái Maria a kebepta páksi á boh táit er i kán hol. ");
INSERT INTO sgz_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Mái Iesu a pakta hanhan i kápán páplun má kán mánán, má a lu agasgas pasi hol si Káláu má matananu mul. ");
INSERT INTO sgz_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Má namur marán á bet ákte rah, mái Ioanes, natun ái Sakaria, kán tu kis besang i pokon mau, má pinpidan si Káláu a tapam hut singin iatung. I bet erei, ái Taiberius ái á kabisit a nagogon má a kátlán uri tan balis no erei ái Rom a kátlán i di, má ákte kis arwat mai sángul mai ahat i kán bet án nagogon. Má ngorer ái Pontiás Pilato a kátlán i balis á Iudáiá. Mái Erodes a kátlán i balis á Galiláiá. Mái Pilip, tuán ái Erodes, a kátlán i balis á Ituria má Tarakonitis. Mái Lisanias ái mul a kátlán i balis á Abilene. Mái Anas diar ái Kaiapas diar tám osmapak táil on á rumán osmapak ami Ierusalem. ");
INSERT INTO sgz_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Io, worwor káián ái Káláu a tapam hut si Ioanes ngorer, mái Ioanes a láklák tangrai kuir malar no i aru balsán dan á Ioridan má ák arbin má ák parai ngoromin, “Gama hol kaleng má gamáng kipi arsiu, má ngorer ái Káláu nák pah palai kamu tan sápkin.” ");
INSERT INTO sgz_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","A ngorer i tám worwor tus ái Aisaia ákte sir páptai i kán buk ngoromin, “Tekes na lu binbin i pokon mau ngo, ‘Aleget i sál si Konom má eran on. Long anokwai sál suri na láklák on! ");
INSERT INTO sgz_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Boh kostung, da dungi mai bim suri na arwat no. Tan gengen pungpung má tara ukung, na nokwan no. Sál a kalkalis, na nokwan mul. Má sál a lala sák taladeng, da long kuluknai nák lain dalian no. ");
INSERT INTO sgz_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Má matananu no da mákái araliu káián ái Káláu.’” ");
INSERT INTO sgz_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Má marán matananu di purut talum narsá Ioanes suri ngo na siu di. Mái Ioanes a parai si di ngo, “Á gam á rang natun kanih sáksák! Sinih a parai si gam ngo gama tur kaplah alari nagogon si Konom erei ngo na hut besang? ");
INSERT INTO sgz_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Gama oboi lain wán i gam suri inngas tar gam ngo gamáte hol kaleng. Koion gama ruruna ngo gamáte tur kaplah alari nagogon si Káláu kabin gam á tan rang kopkom i Abaram. Kápte. Má minái iau para talsai si gam ngoro minái ngo ái Káláu a arwat singin suri na longoi tan hat minái sang suri da rang kopkom i Abaram! ");
INSERT INTO sgz_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Palngat ákte eran pagas suri tárái boh kubau adi káplabin. Kubau erei kápate oboi lain wán, da tár palai má dák sápkai uri kámnah.” ");
INSERT INTO sgz_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Matananu di longrai ngorer má dik gálta Ioanes ngo, “Má dánih be gima longoi?” ");
INSERT INTO sgz_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Mái Ioanes a kos di ngoromin, “Sinih si gam a mon i aru i lusán, na tari á tekesi lusán singin kálámul erei káp kán te. Sinih a mon i namnam singin, na tabar koner káp án te namnam.” ");
INSERT INTO sgz_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Te rung di lu kip takis di lu hut mul suri na siu di ái Ioanes, má di gáltai ngoro minái, “Tám Aratintin, dánih be gima longoi á gim?” ");
INSERT INTO sgz_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Mái Ioanes a parai si di ngo, “Koion gama agur pas te pirán tabal mul urami iátin erei gam lu kipi. Na tu arwat mai ngorer sár i nagogon.” ");
INSERT INTO sgz_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Te tám arup di gáltai mul ngo, “Má ngádáh á gim? Dánih gima longoi?” Má a parai si di ái Ioanes ngoro minái, “Koion gama amatmatai matananu má gama atiutiu di pasi kándi pirán tabal. Gama ot kuluk suri arul er di tari si gam, má kái gama kon sur te mul.” ");
INSERT INTO sgz_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Má ngangai má ásásla káián matananu a kopkom hanhan, má ngorer di lala pán tirwa Ioanes. Di hol on ngo, “War te ngoi gut ái sár á Mesaia!” ");
INSERT INTO sgz_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Mái Ioanes a mák ilmi kándi hol ngorer má a para talsai si di ngoromin, “Á iau, iau siu gam mai dan sár. Mái sár ngo kes a lala rakrakai sorliu iau, alatung be namur. Má iau rumrum suri ina kusak i kán rum. Ái sang na siu gam mai Tanián a Pilpil má mai kámnah. ");
INSERT INTO sgz_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ái ái koner a top i kán is suri na tárái wit mai. Má namur na tim purwai kotlin wit alari poktuán má ngorer na dungi kotlin wit i suapok, má boh poktuán wit erei na osoi sár i kámnah káp a tini mat!” ");
INSERT INTO sgz_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Má a marán i worwor a inau i di mai ái Ioanes mák arbin mai lain arbin uri narsán matananu. ");
INSERT INTO sgz_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ái Ioanes kápate matai bos kálámul pakta, má ngorer a pua Erodes má a para puri mátán, kápkabin ngo ái Erodes a ras pas Erodiá, kán wák ái tuán, má a long te matngan sápkin tatalen mul. ");
INSERT INTO sgz_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Má namur sár a sopasun kán sápkin tatalen mák obop Ioanes mul i rumán batbat kalar. ");
INSERT INTO sgz_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Má i pákánbung kápate obop Ioanes be i rumán batbat kalar ái Erodes, marán matananu dikte siusiu, mái Iesu mul a han má a siwi ái Ioanes. Má pákánbung ái Iesu kán tu sung besang iatung i dan, bát a ráp ");
INSERT INTO sgz_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","má Tanián a Pilpil a sosih ur on a mák ngoro bun. Má tilami bát, kaungán kes a parai ngoromin, “Á iáu á natung, kang Kalik alal. A lala gas i balang mam iáu.” ");
INSERT INTO sgz_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","I pákánbung a turpasi kán him, ái Iesu a arwat mai atul i sángul á kán bet, má matananu di hol on ngo ái Iesu natun ái Iosep. Ái Iosep natun ái Eli. ");
INSERT INTO sgz_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ái Eli natun ái Matat, mái Matat natun ái Lewi, mái Lewi natun ái Melki, mái Melki natun ái Ianai, mái Ianai natun ái Iosep. ");
INSERT INTO sgz_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Io, ái Iosep natun ái Matatias, mái Matatias natun ái Amos, ái Amos natun ái Nahum, mái Nahum natun ái Esli, mái Esli natun ái Nagai. ");
INSERT INTO sgz_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Io, ái Nagai natun ái Mat, mái Mat natun ái Matatias, ái Matatias natun ái Semein, mái Semein natun ái Iosek, mái Iosek natun ái Ioda. ");
INSERT INTO sgz_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Io, ái Ioda natun ái Ionan, mái Ionan natun ái Resa, ái Resa natun ái Serubabel, mái Serubabel natun ái Sietiel, mái Sietiel natun ái Neri. ");
INSERT INTO sgz_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Io, ái Neri natun ái Melki, mái Melki natun ái Adi, ái Adi natun ái Kosam, mái Kosam natun ái Elmadam, mái Elmadam natun ái Er. ");
INSERT INTO sgz_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Io, ái Er natun ái Iosua, mái Iosua natun ái Eliser, ái Eliser natun ái Orim, mái Orim natun ái Matat, mái Matat natun ái Lewi. ");
INSERT INTO sgz_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Io, ái Lewi natun ái Simion, mái Simion natun ái Iuda, ái Iuda natun ái Iosep, mái Iosep natun ái Ionam, mái Ionam natun ái Eliakim. ");
INSERT INTO sgz_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Io, ái Eliakim natun ái Melea, mái Melea natun ái Mena, ái Mena natun ái Matata, mái Matata natun ái Natan, mái Natan natun ái Dewit. ");
INSERT INTO sgz_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Io, ái Dewit natun ái Iesi, mái Iesi natun ái Obet, ái Obet natun ái Boas, mái Boas natun ái Salmon, mái Salmon natun ái Nason. ");
INSERT INTO sgz_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Io, ái Nason natun ái Aminadap, mái Aminadap natun ái Atmin, mái Atmin natun ái Arni, mái Arni natun ái Esron, mái Esron natun ái Peres, mái Peres natun ái Iuda. ");
INSERT INTO sgz_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Io, ái Iuda natun ái Iakop, mái Iakop natun ái Aisak, mái Aisak natun ái Abaram, mái Abaram natun ái Tera, mái Tera natun ái Nahor, mái Nahor natun ái Seruk. ");
INSERT INTO sgz_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Io, ái Seruk natun ái Reu, mái Reu natun ái Pelek, mái Pelek natun ái Eber, mái Eber natun ái Sela. ");
INSERT INTO sgz_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Io, ái Sela natun ái Kainan, mái Kainan natun ái Arpaksat, mái Arpaksat natun ái Sem, mái Sem natun ái Noa, mái Noa natun ái Lamek. ");
INSERT INTO sgz_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Io, ái Lamek natun ái Metusela, mái Metusela natun ái Enok, mái Enok natun ái Iaret, mái Iaret natun ái Mahalalel, mái Mahalalel natun ái Kenan. ");
INSERT INTO sgz_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Io, ái Kenan natun ái Enos, mái Enos natun ái Set, ái Set natun ái Adam, mái Adam natun ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","I pákánbung ái Iesu a masar alari dan á Ioridan ngo na kaleng uri kán malar, Tanián a Pilpil a akángái mák lami uri pokon mau. ");
INSERT INTO sgz_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Má iatung ái Satan a longoi artohtoh uri narsán arwat mai ahat i sángul á bung. Ái Iesu kápate ani tekesi táit i pákánbung erei, má ngo ákte rah i ahat i sángul á bung erei, a matpám. ");
INSERT INTO sgz_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ngorer ái Satan a parai singin ngoromin, “Ngo iáu Natun ái Káláu, ki una dos i hat minái suri na pukdai uri balbal.” ");
INSERT INTO sgz_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Mái Iesu a kosoi ngoromin, “Pinpidan si Káláu a parai ngo, ‘Kápte ngo namnam masik a lu támri liu kán kálámul suri na rakrakai’.” ");
INSERT INTO sgz_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Má namur ái Satan a tohtoh Iesu mul má a lam pas Iesu uri pokon a tuan alami sang, má a sangar i inngas tari singin á tan balis no on á naul matmatngan pokon. ");
INSERT INTO sgz_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Má namur a parai si Iesu ngo, “Ina tar noi singim á nokwan suri kátlán tan balis no minái, má na kaiam mul á tan táit imi lolon i di. Kabin ngo kaiak no á tan táit erei, má iau arwat suri ina tari singin tekes erei iau nem on. ");
INSERT INTO sgz_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Na kaiam no sár ngo una pur dirtapul má una lotu uri narsang.” ");
INSERT INTO sgz_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Mái Iesu a kosoi ngo, “Pinpidan si Káláu a parai ngo, ‘Una lotu uri narsán ái Konom kam Káláu, má ái masik sár una para agasi.’” ");
INSERT INTO sgz_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Má namur ái Satan a tohtoh Iesu mul mák lam pasi ur Ierusalem mák aksimi iamuni i kuir ungán rum i rumán osmapak. Mái Satan a parai si Iesu ngoromin, “Ngo iáu Natun ái Káláu, una rohman tilatung uradi bim. ");
INSERT INTO sgz_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kabin pinpidan a parai ngoro minái, ‘Ái Káláu na tari palai kán tan angelo má da ololoh timan iáu.’ ");
INSERT INTO sgz_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Má pinpidan a parai mul ngo, ‘Tan angelo da sáng pas iáu mai lim di suri ngorer na mák suski kikim i hat.’” ");
INSERT INTO sgz_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Mái Iesu a kosoi ngoromin, “Pinpidan si Káláu a parai ngo, ‘Koion una tohtoh Konom er kam Káláu.’” ");
INSERT INTO sgz_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Má ngo ái Satan ákte arahi má kán tan artohtoh uri narsá Iesu, ki ák han pas má alari, nana tekesi bung bul. ");
INSERT INTO sgz_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Mái Iesu a kaleng ur Galiláiá, má Tanián a Pilpil a arakrakai on. Má arbin ur on a han tangrai boh kuir malar no. ");
INSERT INTO sgz_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Mái Iesu a atintin di i kándi tan rumán lotu, má matananu no di párngai. ");
INSERT INTO sgz_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ái Iesu a kaleng mul ur Nasaret, uri malar a pakta ái sang, má i bungán aunges a kusak uri rumán lotu a ngorer i kán tatalen sang. Má a sámtur i mátán táil i di suri na wásái pinpidan si Káláu. ");
INSERT INTO sgz_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Má tám ololoh i rum a sara tari singin á buk si tám worwor tus ái Aisaia er a le on. Ái Iesu a top on mák párpárak i buk erei má a párak pasi kuir pinpidan er a parai ngoromin suri Mesaia, ");
INSERT INTO sgz_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Tanián ái Káláu a kis i narsang, kabin ákte ilwa pas iau suri ina arbin mai lain arbin uri narsán ái rung di maris. Ákte dos pala iau suri ina para talsai arasengsegeng uri narsá di ái rung di kis i kamkabat, má uri narsá di ái rung di rau ngo da mákmák kaleng. Má ákte dos pala iau mul suri saras pas rung er tan sápkin kálámul dikte suka bámia di, ");
INSERT INTO sgz_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","má suri arbin talas mai bet án araliu káián ái Konom!” ");
INSERT INTO sgz_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ngo ákte rah i kán worwor, ái Iesu a batbat kaleng i buk mák tar kalengnai singin tám ololoh i rum, má a sukis kaleng. Má matananu no iatung i rumán lotu di paupau alongra suri kán worwor ái Iesu. ");
INSERT INTO sgz_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Mái Iesu a turpasi worwor ur singin matananu má ák parai ngo, “Táit a parai i pinpidan minái gamáte longrai má, ákte tapam hut muswan onin.” ");
INSERT INTO sgz_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Má matananu di longrai kán worwor ngorer má di sormángát ngo ái á lain kálámul, má di lala hol tangrai tan lain worwor a parai si di. Má ngorer dik gálta ngo, “Ái sinih á ngoro minái, natun ái Iosep sár, be?” ");
INSERT INTO sgz_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Mái Iesu a parai si di ngoro minái, “Iau mánán ngo gam hol on má gama parai uri iau á kángit arabitbit erei a parai ngoromin, ‘Ngo u parai ngo iáu á tám latlat, ki una aliu pas iáu sang suri gima mákái ngo kam worwor a támin.’ Má iau mánán mul ngo gama parai uri iau ngo, ‘Kam malar á Nasaret. Má ngorer tan táit er gim longrai u longoi á Kapernaum, ki una longoi mul mainái suri gimák mákái ngo kam worwor a támin.’” ");
INSERT INTO sgz_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ái Iesu a sopasun kán worwor uri narsá di mák parai ngo, “A támin muswan iau parai si gam. Tám worwor tus, di lu rumrum on i malar tepák. Ái sár i kán malar muswan má i kán rum sang, kápdite lu rumrum on ái. ");
INSERT INTO sgz_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","A támin ngo a marán i mokos main Israel i arliwán bung er ái Elaisa a kis on, má ngorer kápte te ráin artálár mai atul i bet má tigán, má taul itol a bontai kunlán balis no á Israel. ");
INSERT INTO sgz_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Mái sár ái Káláu kápate dos pala Elaisa uri narsá di. Kápte. A dos palai ur tepák, suri tángni wák mokos til Sarepat i kuir balis á Sidon. ");
INSERT INTO sgz_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Má ngorer mul marán di sasam mai lepra main Israel i arliwán bung erei tám worwor tus ái Elisa a kis on, mái sár ngo kápte kes tili di a sengsegeng alari lepra. Kápte. Mái sár ái Naman masik, kálámul til tepák, kakun Siria, ái masik a sengsegeng alari lepra.” ");
INSERT INTO sgz_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Má matananu iatung i rumán lotu di longrai ngorer má di no di togor, ");
INSERT INTO sgz_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","má di aptur má di long pala Iesu alari malar á Nasaret, má di talka ráhrai tangrai risán pungpung erei a kis ái i kándi malar suri da sápka Iesu uri hám. ");
INSERT INTO sgz_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mái sár ái Iesu a tu láklák i katbán i di sár má ák han pas alar di. ");
INSERT INTO sgz_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Má ái Iesu a han sosih ur Kapernaum, kesi bimán rum pakta á Galiláiá, má a atintini matananu iatung i rumán lotu i bungán aunges. ");
INSERT INTO sgz_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Má di longrai kán aratintin má dik pángáng suri, a kabin ngo a mon i rakrakai on ngorer i kálámul a tarwai ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Má i pákánbung sang erei, kesi kálámul sápkin tanián a porta on a sol uratung i rumán lotu mák lala perek ngoromin, ");
INSERT INTO sgz_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Iáu Iesu kakun Nasaret, suri dáh u soksok gim? Iau mánán i iáu, iáu Tám Pilpil káián ái Káláu! Ngádáh, ukte hut suri una up sara gim, be?” ");
INSERT INTO sgz_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Mái Iesu a longrai ngorer má ák dos kári sápkin tanián er ngoromin, “Una kis pau má unák so alari kálámul erei!” Má sápkin tanián a longrai ngorer mák buswai kálámul er uradi bim i katbán i di, má a han alari má kápate long bengtai. ");
INSERT INTO sgz_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Má matananu no di pángáng on má di argátna arliu i di ngoromin, “Matngan worwor ngádáh á ngoro minái? Kálámul minái a mon i kán nokwan má rakrakai mul suri dos palai boh sápkin tanián má dik táu!” ");
INSERT INTO sgz_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Má arbin uri Iesu a bonta noi bos malar no i balis erei. ");
INSERT INTO sgz_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ái Iesu a so alari rumán lotu erei má ák han kusak uri rum si Saimon Petero. Mái mámán ái kán wák ái Petero a sasam, a lala málmálas. Má ngorer di worwor mam Iesu suri na tángni. ");
INSERT INTO sgz_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Mái Iesu a han má ák tur i risán kibán má ák dos palai málmálas er alari wák er. Má ngorer a bokoh alari i sasam erei má a sengsegeng, má káp melek sár ák aptur mák leget i te namnam ur ándi. ");
INSERT INTO sgz_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Má ngo ákte ronron i bung erei sang, marán si di a mon i rang tur di di sasam mai toltolom sasam, di long pas di uri narsá Iesu. Má a páptai limán i di no keskeskes má dik sengsegeng má. ");
INSERT INTO sgz_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Má tan sápkin tanián mul di han alari tan kálámul erei má di lala perek ngo, “Á iáu Natun ái Káláu!” Mái Iesu a dos kalar di suri kápdate worwor, kabin di mánán ngo ái á Mesaia. ");
INSERT INTO sgz_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","A saum i ngahwán kábungbung ái Iesu má a han alari malar er uri pokon mau. Má namur matananu di lala ser suri. Má i pákánbung di mák pas Iesu, di tohoi suri long kári suri ngo koion na han alar di. ");
INSERT INTO sgz_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mái sár a parai si di ngo, “A kuluk, mái sár káp iau te hut sur gam masik. Kápte. Ina han sang uri tan lite malar mul suri ina lu arbin mai lain arbin suri lolsit si Káláu.” ");
INSERT INTO sgz_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Má ngorer a han mák lu arbin tangrai boh rumán lotu i balis á Iudáiá. ");
INSERT INTO sgz_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Kesi bung mul ái Iesu a sámtur i risán dan taliu á Genasaret mák arbin. Má i bung erei, matananu di hut talum iatung má dik dung kukut kalar Iesu suri longrai midán ái Káláu erei na aposoi ái Iesu uri narsá di. ");
INSERT INTO sgz_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Mái Iesu a mákái aru i mon di amasar on i tan tám soksok iatung i kon má di han alari suri gorsai kándi tan uben. ");
INSERT INTO sgz_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ái Iesu a mákái ngorer mák roh uri mon si Saimon, mák parai si Saimon suri na sisdoi án mudán alari kon. Mái Saimon a sisdoi mon mam Iesu alari kon, mái Iesu a kis iatung i mon má a atintini matananu. ");
INSERT INTO sgz_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Má namur ngo ákte rah i kán aratintin, ái Iesu a parai si Saimon ngo, “Gama sisdo palai kamu kesi mon erei urada sár i lámán, má gamák asihái kamu uben uradi lámán suri gamáng kip te isu.” ");
INSERT INTO sgz_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Mái Saimon a kosoi ngo, “Tám Aratintin, gimáte lala him i kunlán libung mai sápkai kángim uben má kápgimte up tekesi isu. Mái sár minái u dos pala iau, ki ina mur on má inak asihái uben má gimák tohoi mul sur te isu.” ");
INSERT INTO sgz_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Má ngorer di asihái kándi uben má dik talka pasi lala marán isu, má uben erei ák páput suri ngo na ráp. ");
INSERT INTO sgz_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Má di mákái ngorer má ding kaluh pasi rang tur di mai kesi mon mul suri ngo da lákám má dák tangan di iatung. Má ngorer di hut, má di no di talka pasi uben má dik akángái aru mon erei mai isu tili uben, má a páput ngo diara dom á aru mon erei. ");
INSERT INTO sgz_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Má ngo ái Saimon Petero a mákái táit ngorer, a sukis dirtapul má a agengen pasi kán liu sang i mátán táil ái Iesu mák parai ngo, “Una han alar iau, Konom, kápkabin ngo iau á sápkin kálámul.” ");
INSERT INTO sgz_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","10","Ái Saimon má aru i turán mul, ái Iakobo mái Ioanes, diar aru natun ái Sebedaio, má di no iatung di lala pángáng suri di mákái lala marán isu dikte sokoi mai uben. Mái Iesu a parai si Saimon ngo, “Koion una mátut. Turpasi onin una lu talkai uben suri soksok pasi matananu ur káián ái Káláu!” ");
INSERT INTO sgz_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Má namur ngo dikte talka amasar i aru mon uri kon, ái Saimon mái Iakobo mái Ioanes ditul han alari kándi tan táit no iatung má ditulá turpasi mur i Iesu. ");
INSERT INTO sgz_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Má i kesi bung ái Iesu a iatung i kesá bimán rum, má kesi kálámul iatung a bonta noi kápán páplun i lepra. I pákánbung a mák Iesu, a han mák sukis dirtapul uri mátán táil ái Iesu mák sungi ngo, “Konom, ngo u nem on, u arwat suri ngo una asengsegeng pas iau!” ");
INSERT INTO sgz_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Mái Iesu a longrai ngorer mák sarsara mai limán mák top i páplun kálámul erei, má a parai singin ngoromin, “Iau nem on. Inái ukte sengsegeng má!” Má káp melek sár mul má lepra a bokoh alari kápán páplun kálámul erei. ");
INSERT INTO sgz_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Má namur ái Iesu a inau on ngoromin, “Koion una kálik parai singin tekes. Una han má unák para inngas iáu singin tám osmapak, má unák tari singin á kam osmapak ngorer ái Moses a parai, má kam osmapak erei na inngas tari singin matananu ngo kam sasam ákte rah.” ");
INSERT INTO sgz_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mái sár arbin uri Iesu a han arsagil uri bos malar, má ngorer namur bul matananu di hut talum suri longrai aratintin si Iesu má suri ái Iesu na asengsegeng i di alari kándi boh sasam. ");
INSERT INTO sgz_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mái Iesu a lu han alari matananu i te pákán uri pokon mau mák lu sung iatung. ");
INSERT INTO sgz_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Má kesi bung mul ái Iesu kán tu aratintin be, má te Parisaio má te tan tám aratintin uri nagogon di iatung di longrai. Dikte tapam hut iatung tili tan malar á Galiláiá má Iudáiá má til Ierusalem. Má rakrakai káián ái Káláu a mon i Iesu suri ák aliu pasi boh sasam. ");
INSERT INTO sgz_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Má namur te kálámul di kipi kesi peu mai kibán sang kabin kápate lu láklák, má di tohtoh suri da kusak mai uri rum ngo da oboi i narsá Iesu. ");
INSERT INTO sgz_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Mái sár kápdite arwat suri da kusak mai peu erei urami rum kabin ngo lala matananu taladeng di káng iatung. Má ngorer di kip tapam i peu erei urami iátin rum, má namur dik pápak palai tan sepen hat tilami iátin rum, má dik asihái peu erei mai kibán uradi katbán matananu uri mátán táil ái Iesu. ");
INSERT INTO sgz_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","A mákái kándi ruruna ái Iesu, má a parai singin peu ngoro minái, “Tuang, kam sápkin tatalen ákte pah alar iáu.” ");
INSERT INTO sgz_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Má tan tám mánán uri nagogon má boh Parisaio di longrai ngorer má dik turpasi worwor arliu i di sang ngoromin, “Ái sinih á kálámul minái a pulus Káláu? Kápte kesi kálámul a arwat ngo na pah palai sápkin tatalen, ái Káláu masik sár a artálár!” ");
INSERT INTO sgz_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Mái Iesu a mánán i kándi holhol má ák parai si di ngoromin, “Suri dáh gam argálta ngorer ami bál gam? ");
INSERT INTO sgz_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Á iau a mon i kak nokwan suri parai singin kálámul erei a peu ngo, ‘Kam tan sápkin tatalen ákte pah,’ kabin ngo iau arwat mul suri parai singin kálámul er ngo, ‘Una aptur, una kipi kibam má unák láklák!’ ");
INSERT INTO sgz_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Má inái ina inngas tari si gam ngo Natun Kálámul a mon i kán nokwan suri long palai bos sápkin tatalen main i naul bim!” Má ngorer a parai singin peu ngo, “Kauh, aptur má unák pusak pasi kibam má unák han uri kam rum!” ");
INSERT INTO sgz_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Má káp melek sár má kálámul erei a aptur i mátán matananu mák pusak pasi kibán, má a kaleng uranang i rum mai parpara agas uri narsán ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Di no iatung di pángáng má di lala mátut má dik para agas Káláu, má ngorer di para ngoro minái, “Wa onin pala sang gitá mákái á matngan táit ngoromin!” ");
INSERT INTO sgz_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Má namur ái Iesu a lu hanhan tangrai sál, má a mákái kesi kálámul iatung, ngisán ái Lewi, kesi tám kip takis, a sukis pagas i rumán kip takis. Ái Iesu a mákái mák parai singin ngo, “Una mur i iau.” ");
INSERT INTO sgz_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Mái Lewi a longrai mák aptur támlai boh táit no sang iatung má a mur i Iesu. ");
INSERT INTO sgz_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Má namur ái Lewi a longoi lala namnam sur Iesu i kán rum sang, má marán te rung tili rákán him án kip takis má te mul á kálámul di no di kis suri namnam iatung. ");
INSERT INTO sgz_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Má te Parisaio má kándi tan tám mánán uri nagogon di mák Iesu ngo a kis tiklik mai tan tám sápkin ngorer, má dik wor arkuh mai tan kalilik án aratintin si Iesu ngoromin, “Suri dáh gam namnam má ngin tiklik mai tan tám kip takis má tan tám abulbul ngorer?” ");
INSERT INTO sgz_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Má ngo ái Iesu a longrai, a han má a kos di ngoromin, “Ái rung di lain liu kápdite sáhár sur tekes ngo na aliu di, ái rung di sasam masik sár. ");
INSERT INTO sgz_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Má iau, káp iau te hut suri ina kilkila pasi bos tám nokwan. Iau hut suri kilkila pasi bos tám sápkin suri da hol kaleng.” ");
INSERT INTO sgz_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Má di parai mul si Iesu ngo, “Kalilik án aratintin si Ioanes di lu balbal ahal má sung, má kalilik án aratintin kándi tan Parisaio di lu longoi mul ngorer. Mái sár ngo kam kalilik án aratintin á iáu kápdite lu ahal.” ");
INSERT INTO sgz_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ái Iesu a longrai má a kos di ngoromin, “Ngádáh? Ngo da longoi namnam án akila, u hol on ngo matananu da ahal i pákánbung er kálámul a hutngin kila a kis tiklik mam di? Kápte! I bung kesi kálámul a kila, di no di namnam tiklik. ");
INSERT INTO sgz_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Má namur da long pasi kálámul er a hutngin kila má nák bokoh alar di. I bung erei da ahal.” ");
INSERT INTO sgz_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Mái Iesu a sopasun kán worwor mai kesi worwor artálár mul ngoromin, “Kápte kesi kálámul ngo na taráp pasi sepen kaen tili hutngin kaen suri na mapmap i torahin kaen mai. Ngo na longoi ngorer, ki na ráp sáksák i hutngin kaen, má hutngin sepen kaen erei káp diara te artálár mai torahin kaen. ");
INSERT INTO sgz_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Má kápte kesá kálámul na toroi hutngin suir wain uri torahin átbán dan di longoi mai kápán me. Ngo na longoi ngorer, suir wain erei na sut má na korkor má nák tarápái torahin átbán erei má nák ráp, má suir wain na sal no. ");
INSERT INTO sgz_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Gita totrai hutngin suir wain uri hutngin átbán dan suri diar no diara sut tiklik. ");
INSERT INTO sgz_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","“Má ngorer mul ngo kesi kálámul ákte nginmi torahin suir wain, kápnate nem ngo na han nginmi hutngin suir wain mul, kabin na parai ngo torahin suir wain a namnamin, má hutngin suir wain kápte.” ");
INSERT INTO sgz_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ái Iesu turán kán kalilik án aratintin di láklák tangrai te numán padi i bungán aunges. Má kán kalilik án aratintin di turpasi suri pulái padi, má di parak palai táprákun mai lim di má namur di ani kotlin. ");
INSERT INTO sgz_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Má te Parisaio di mákái má dik gálta ngo, “Suri dánih kam kalilik án aratintin di longoi ngoro minái má uri nagogon kángit a parai ngo koion á longoi ngorer i bungán aunges?” ");
INSERT INTO sgz_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","A kos di ái Iesu ngoromin, “Ngádáh? Kápgamte wás pasi besang gut suri tatalen ngoromin a longoi ái Dewit i pákánbung a matpám tiklik mai rang turán? ");
INSERT INTO sgz_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","A kusak uri rum si Káláu má a top pasi beret erei di artabar mai uri narsán ái Káláu, má a ani, má a tari mul singin rang táir má di mul di ani. Má uri nagogon kángit, beret er a tam arwat mai bos tám osmapak masik sár da ani.” ");
INSERT INTO sgz_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Mái Iesu a sopasun kán worwor mul ngoromin, “Má Natun Kálámul a konom ur on á bungán aunges.” ");
INSERT INTO sgz_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","I kesi bungán aunges mul, ái Iesu a kusak uri rumán lotu má a atintini matananu iatung. Má kesi kálámul iatung a mat i limán er mingin. ");
INSERT INTO sgz_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Má te tám mánán uri nagogon má te Parisaio di mangwa Iesu iatung. Di nem suri da mákái ngo ái Iesu na araliu i bungán aunges, má ngorer da atiutiu Iesu suri. ");
INSERT INTO sgz_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mái sár ngo ái Iesu a mánán i kándi holhol má a parai singin kálámul erei a sák i limán ngo, “Una lákám má unák sámtur main.” Má kálámul erei a aptur má a sámtur iatung. ");
INSERT INTO sgz_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Mái Iesu a parai si di ngoromin, “Ina gálta gam. Bos nagogon kángit, di atintin git suri dánih gita longoi i bungán aunges? Bung uri tángni matananu ngo bung uri longoi sápkin? Kol bung suri aliu pas di di sasam suri da liu kuluk? Kol gita tari bah git uri kálámul suri nák mat?” ");
INSERT INTO sgz_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Má namur a mákmák aririu i di no ái Iesu má a parai singin kálámul erei ngo, “Una anokwai limam!” Má kálámul erei a longrai ngorer má ák anokwai limán, má limán áng kuluk kaleng. ");
INSERT INTO sgz_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Má tan tám mánán uri nagogon má tan Parisaio di mákái ngorer má dik bálsák, má ngorer di nguruk arliu i di sang suri dánih má da longoi mam Iesu. ");
INSERT INTO sgz_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","I bung erei, ái Iesu a tapam urami pungpung suri na sung, má ngorer i kunlán pákán libung no erei kán tu sung uri narsán ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Má ngo ákte arasa má, a kilkilai rung di lu murmur on uri narsán sang má a ilwa pasi sángul mai aru tili di uri kán kalilik án aratintin, má ngorer a utung di mai tan apostolo mul. Má minái á ngis di á sángul mai aru á kalik án aratintin: ");
INSERT INTO sgz_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ái Saimon, koner ái Iesu a tar ngisán mul mam Petero; mái Enru, tuán ái Petero; mái Iakobo; mái Ioanes; mái Pilip; mái Batolomi; ");
INSERT INTO sgz_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","mái Mataio; mái Tomas; mái Iakobo mul natun ái Alpius; mái Saimon, kálámul a tur rakrakai suri da sikra palai kurtara alari Israel; ");
INSERT INTO sgz_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","mái Iudas natun ái Iakobo; mái Iudas Iskariot, ái koner na agur tar Iesu. ");
INSERT INTO sgz_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Má namur ái Iesu a sosih tiklik mai marán rang táir tilamuni pungpung má dik han sámtur iatung i belbelen pokon. Má lala matananu til Iudáiá má Ierusalem má tiladi kon pátmi aru malar á Tair má Sidon, di hut talum no iatung suri longrai kán pinpidan ái Iesu má suri na asengsegeng i di alari kándi toltolom sasam er a porta i di. ");
INSERT INTO sgz_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Mái rung er a lu bal angulngul di i sápkin tanián, di purut mul, má ái Iesu a asengsegeng i di. ");
INSERT INTO sgz_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Má matananu di tohtoh suri sigil Iesu kabin kán rakrakai a asengsegeng i di no sang. ");
INSERT INTO sgz_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Mái Iesu a soklatán má ák lu mákái kán kalilik án aratintin má a parai si di ngoromin, “Gam er gam sáhár on á liu minái, gam kuluk pala, kabin gama kusak uri lolsit si Káláu mái Káláu na kátlán i gam. ");
INSERT INTO sgz_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Má gam kuluk pala á gam onin gam matpám, kabin namur gama lala mas. Á gam gam lu tang, gam kuluk pala, kabin namur gama nong. ");
INSERT INTO sgz_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Má gam kuluk pala mul ngo matananu di lu mikmikwa gam má ngo di lu wás pala gam alar di, má ngo di wáng i gam, má ngo di para bengta gam kápkabin suri Natun Kálámul. ");
INSERT INTO sgz_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Káksiai sár, rang támin i di dikte longoi ngorer mai tan tám worwor tus hirá be. Má ngo di longoi ngorer mam gam mul, gama parmat má gama mil mai laes, kabin namur kamu arul na pakta ami bát. ");
INSERT INTO sgz_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Mái sár á gam erei gam konom onin, gamáte sák, kabin ngo gamáte otoi má i tan táit uri akuluknai bál gam. ");
INSERT INTO sgz_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Má gamáte sák á gam gam mas onin, kabin namur gama matpám besang! Má gam gam lala nong onin, gamáte sák mul, kabin namur na tinang i bál gam má gamák tang. ");
INSERT INTO sgz_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Má gamáte sák á gam ái rung er di lu para agas gam onin, kabin ngo rang támin i di sang dikte para agas di mul á tan angagur án tám worwor tus.” ");
INSERT INTO sgz_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Mái Iesu a sopasun i kán aratintin mák parai ngoromin, “Mái sár ina parai si gam erei gam longra iau ngo gama mámnai kamu tan kurtara. Má ái rung er di mikmikwa gam, gama abálbál pas di. ");
INSERT INTO sgz_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Má gama tari arasosah si di mul ái rung erei di wah i gam. Má ái rung erei di wáng i gam, gama sung Káláu sur di. ");
INSERT INTO sgz_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Má ngo tekesi kálámul na posri parim, una káksiai suri nák posri mul i kesi balsán parim. Má ngo tekesi kálámul na long pasi tekesi lusán i iáu, kái una ruti á kes, una bál tari mul singin. ");
INSERT INTO sgz_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ái rung di sung iáu suri táit, una tari sár si di. Má ngo tekesi kálámul a lu kip bia i kam te dánih tili kam arlih, koion una hustap on suri ngo na tar kalengnai singim. ");
INSERT INTO sgz_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Gama lu longoi mai matananu á matngan tatalen erei gam nem on ngo da longoi mam gam. ");
INSERT INTO sgz_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ngo una mámnai sár i kálámul a lu mámna iáu, suri dáh da para agas iáu? Wa tan tám sápkin di lu longoi ngorer mul, di lu mámna pas rung erei di lu mámna di sang! ");
INSERT INTO sgz_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Má ngo u longoi a kuluk sár mam di ái rung di kuluk mam iáu, suri dáh da para agas iáu? Tan tám sápkin di lu longoi ngorer mul. ");
INSERT INTO sgz_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Má ngo u bál tari kam tekesi táit ur si rung er u hol on ngo da kos kalengnai ur singim, suri dáh da para agas iáu? Tan tám sápkin di lu longoi ngorer mul, di lu bál tari táit singin rang tur di suri ngo namur da kip kalengnai táit nák arwat mai táit erei di mulán tari. ");
INSERT INTO sgz_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Auh, kápate arwat! Gama mámnai kamu tan kurtara má gama lu lain kuluk mam di. Gama bál tari táit má koion gama ngangai suri kip kalengnai. A mon á kamu lala arul a kis mona gam imi. Má main i naul bim, ninsin i gam er na apos tari ngo gam á rang natun ái Káláu Sorsorliu, ái koner a lu kuluk mai tan sápkin kálámul má mam rung er káp di tini ot kuluk mul. ");
INSERT INTO sgz_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Gam mánán ngo ái Káláu erei Kák gam a tám armámna, má ngorer mul á gam gama tám armámna ngorer i Kák gam.” ");
INSERT INTO sgz_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Mái Iesu a sopasun i kán aratintin mul mák parai ngoromin, “Koion gama lu parai ngo tur gam a longoi sápkin, na káp parai ngorer uri gam ái Káláu. Koion gama lu wás palai tur gam, na káp wás pala gam ái Káláu. Gama lu hol palai sápkin di longoi uri narsá gam, mái Káláu na hol palai kamu sápkin mul. ");
INSERT INTO sgz_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Gama lu artabar, mái Káláu na kosoi mai artabar uri narsá gam mul. Na tari lala boh táit si gam má na pusi sang uradi lal má na gungunrai nák sosih, má namur nák dung te mul suri náng káng ungleu má gamák bes mai lala boh táit erei. Ngo gama artabar mai lala boh, ái Káláu na kosoi mai lala boh ur si gam. Má ngo gama artabar mai mudán sár, ki ái Káláu na kos gam mai mudán mul.” ");
INSERT INTO sgz_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Mái Iesu a parai kesi tohtohpas uri narsá di ngoromin, “Kesi rau kápnate arwat suri lami kesi turán. Ngo na longoi ngorer, ki diar no diara pur uri tinkas. ");
INSERT INTO sgz_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Má kápte kesi kalik án aratintin a pakta sorliwi kán tám aratintin, mái sár ngo i bung kalik erei ákte arahi kán aratintin no iatung, erei má na arwat mai kán tám aratintin sang. ");
INSERT INTO sgz_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“U lala mákái pektol erei i mátán ái tuam. Má suri dáh kápute áslai mul i sepen kubau er i matam sang? ");
INSERT INTO sgz_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Iáu nem i parai si tuam ngoromin, ‘Tuang, inak long palai be pektol er i matam.’ Mái sár ngo u parai ngorer má kápute mákái lala sepen kubau a kis i matam sang á iáu, iáu tám tuar sang! Una long pala táilnai besang i lala sepen kubau tili matam, má namur ngo una lain mákmák sang, ki erei má una long palai pektol tili mátán ái tuam.” ");
INSERT INTO sgz_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Mái Iesu a sopasun i kán aratintin mák parai ngoromin, “Kubau a oboi sápkin wán, kápte ngo ái á lain kubau. Lain kubau a lu oboi lain wán, má káp a tini oboi sápkin wán. Má ngorer mul sápkin kubau a lu oboi sápkin wán, má káp a tini oboi lain wán. ");
INSERT INTO sgz_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Git lu mák ilmi boh kubau tili wán i di. Má ngorer kaulbek káp a tini oboi wán tawan ngo wán wain. ");
INSERT INTO sgz_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","A mon i omobop imi bál git no keskeskes, má tili ngudun kálámul a so i matngan táit a kis imi kán omobop. Kálámul a káng mai a kuluk imi bál, a apos tari mai lain worwor má a lu longoi lain tatalen. Má ngorer mul kálámul a káng mai sápkin imi bál, a apos tari mai sápkin worwor mák lu longoi sápkin tatalen.” ");
INSERT INTO sgz_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Mái Iesu a sopasun mul i kán aratintin mák parai ngo, “Suri dánih gam utung iau mai ‘Konom’ má kápgamte taram i táit iau parai ngo gama longoi? ");
INSERT INTO sgz_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Koner a han sur iau má a longra pasi kak worwor má a mur on, ái ina para talsai si gam. ");
INSERT INTO sgz_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","A ngoro kálámul erei a longoi kán rum máng kakas mai toros uradi sang i lal i iátin hat er i pálkibán bim. Io namur, a hus i ráin má a tibin i dan uri rum, má kápate sanrai rum erei kabin ngo rum erei a long timani má a tur rakrakai. ");
INSERT INTO sgz_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mái sár ái koner a longrai kak worwor má kápate mur on, ái a ngoro kálámul erei a longoi kán rum i belbelen pokon má kápate lala kakas mai toros uradi lal. Má namur i pákánbung ngo a hus i ráin má a tibin i dan uri rum, ki ák suhi rum er uradi bim má ák lala sák taladeng!” ");
INSERT INTO sgz_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ngo ákte arahi parai tan táit er ái Iesu uri narsán matananu iatung, io a aptur mák han ur Kapernaum. ");
INSERT INTO sgz_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Má on á malar er kesi tátáil kán tan tám arup, má a mon i kán kesi toptop a lu him narsán, má tátáil er a lala hol apakta on. Má tám toptop erei a lala sasam, má páput suri ngo na mat. ");
INSERT INTO sgz_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Má tátáil erei a longrai arbin sur Iesu, má ngorer a dos palai te kálámul pakta sang káián tan Iudáiá suri han sung Iesu suri na aliu pasi kán toptop. ");
INSERT INTO sgz_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Io, di han hut narsán ái Iesu má di worwor mai má di sung rakrakai ngoromin, “Tátáil minái a nem i kam artangan. Ái á lain kálámul sang artálár suri ngo una tángni. ");
INSERT INTO sgz_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","A lu mámnai kángit matananu, má ái sang ákte tangan gim i longoi kángim rumán lotu. Má ngorer gim sung iáu ngo una tángni.” ");
INSERT INTO sgz_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","8","Io, ái Iesu a taram mák han tiklik mam di. Má di lu hanhan páput sár suri da hut iatung i rum, ngorer má tátáil er a dos palai mul i rang turán ur si Iesu má dik parai ngoromin singin, “Konom, á iau á kálámul dikte obop iau i lalin kak pakpakta, má a mon mul i kak rakrakai suri kátlán i bos tám arup di lu kis i lalin i iau. Má ngorer iau mánán i tari palai kes ngo, ‘Han,’ má a han. Má ngo iau bin pasi kes mul ngo, ‘Lákám,’ má a taram i kaungang má a lákám. Má ngo iau dos palai kak toptop ngo, ‘Longoi minái,’ ki ák lu longoi sang. “Má iau mánán ngo iáu a mon i kam rakrakai mul suri para palai worwor suri aliu pasi kálámul a sasam suri nák liu. Má, Konom, iau lawa pas iáu. Káp iau te lain kálámul artálár suri ngo una kusak main i rum, má iau rumrum mul ngo ina hut singim gitarák worwor. Ngorer ki una tu para palai kam pinpidan sár má kak toptop na sengsegeng kaleng.” ");
INSERT INTO sgz_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Má ngo ái Iesu a longrai ngorer, a sodar suri. A ilang suri matananu di lu murmur on má ák parai ngoromin, “Mákái! A támin iau parai si gam, káp iau te banai besang i tekesi kálámul ngoro tátáil minái mai ruruna ngoromin. Kápte kes til main Israel.” ");
INSERT INTO sgz_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Mái rung a dos pala di i tátáil er, di kaleng má uri kán rum, má di mákái toptop er a sasam ákte sengsegeng má. ");
INSERT INTO sgz_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Namur sár ái Iesu má kán kalilik án aratintin má marán rung mul di tiklik no má di hut iatung i bimán rum á Nain. ");
INSERT INTO sgz_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Má ngo di hut iatung i mátán kas i malar ái Iesu di, di banai matananu tilatung di láklák so mai kesi kálámul ákte mat. Kálámul er ákte mat, natun kesi wák a mokos, má ái á káh kes, má ngorer matananu tili bimán rum er di tiklik mai wák er suri tahtahun. ");
INSERT INTO sgz_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","A mákái wák er ái Konom Iesu má a tinang i bál suri, mák mámnai má a parai singin wák er ngo, “Wákán, koion á tang.” ");
INSERT INTO sgz_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Io, namur tan kálámul er di kipi minat di mák Iesu a láklák tálángna di má ngorer di sámtur. Má ái Iesu a han má ák top i kibán minatin kálámul má ák parai ngo, “Kauh, iau parai singim ngo una salaptur!” ");
INSERT INTO sgz_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Má kálámul er ákte mat a liu kaleng má a salaptur mák sukis, má ngorer a turpasi worwor. Má namur ái Iesu a top pasi limán kálámul er má a ilang sur mámán mák parai ngo, “Minái má á natum.” ");
INSERT INTO sgz_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Matananu no iatung di mákái ngorer má dik lala mátut, má ngorer di para agas Káláu má di ot kuluk uri narsán. Má namur di parai ngoro minái, “Minái rakrakai án tám worwor tus ákte tapam hut uri narsá git, má ái Káláu ákte hut suri tangan pasi kán matananu!” ");
INSERT INTO sgz_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Má namur arbin uri Iesu a han tangrai balis á Galiláiá mái Iudáiá no má i boh balis mul páput. ");
INSERT INTO sgz_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Má kalilik án aratintin si Ioanes Tám Arsiu di mul di longrai arbin sur Iesu, má ngorer dik han bit atalsa Ioanes suri tan táit erei. ");
INSERT INTO sgz_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Má ngorer a long pasi aru i kán kalik án aratintin uri narsán sang má a parai si diar ngo, “Gaura han narsán ái Konom má gaurák gáltai ngoro minái, ‘Á iáu sár ái koner di lu parai ngo na hut? Kol ngádáh, gima kis nanai besang i tekes alatung be?’” ");
INSERT INTO sgz_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Io, má diar aptur má diará han tapam hut narsán ái Iesu má diará parai ngoromin, “Ái Ioanes Tám Arsiu a dos pala giur suri gálta iáu be ngo á iáu sár ái koner di lu parai ngo na hut? Kol ngádáh, gima kis nanai besang i tekes alatung be?” ");
INSERT INTO sgz_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","I arliwán pákánbung er sang, ái Iesu a asengsegeng pasi marán rung di sasam mai toltolom sasam mái rung di bop teken kim mul. Má te mul iatung ákte kusak uri di i tan sápkin tanián, ái Iesu a long palai alar di. Má ái rung di rau, a apádái mát di mul. ");
INSERT INTO sgz_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Má ngorer ái Iesu a parai si diar ngoromin, “Gaura kaleng má gaurák bit atalsa Ioanes suri tan táit gauráte mákái má gauráte longrai. Ngorer tan rau di mákmák kaleng; má tan rung di peu di láklák; mái rung di sasam mai lepra di sengsegeng; má tan rung a dik i talngá di, di alongra mul; má ái rung dikte mat, di aptur kaleng; má lain arbin a tapam hut singin tan maris mul. ");
INSERT INTO sgz_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ái koner a mánán tus iau má kápate mata pala iau, ái na kuluk pala. Mái koner kápate mánán tus iau má ngorer a hol pala iau, ngádáh na kuluk ngoi?” ");
INSERT INTO sgz_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Aru i kalik án aratintin erei diar aptur pas má diará turpasi láklák kaleng uranang i narsán ái Ioanes. Io, namur ái Iesu a turpasi worwor sur Ioanes uri narsán matananu má a parai si di ngoromin, “I bung er gam han suri longrai arbin si Ioanes iamuni pokon mau, dánih gam hol on suri gama mákái? Gam han suri mákái táit bia ngorer i aun got a sámtur pagas má kihkih kán tu kihngai suri ák lek uradi ngo uranang? Kápte! ");
INSERT INTO sgz_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Dánih sang gam han suri mákái á gam? Gam han suri mákái kálámul kán mermer a tuan alal? Auh, kápte! Ái rung di lu mermer ngorer, wa di á tan konom sang má di lu kis i rum kán kabisit. ");
INSERT INTO sgz_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Gama parai singing, dánih gam hol on suri gama mákái má? Gam han suri mákái tám worwor tus? Mokol, a támin muswan. Má iau parai si gam ngo gamáte mákái má tám worwor tus mái koner sang a sorliwi tan tám worwor tus, ");
INSERT INTO sgz_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","kabin ngo ái ái koner Buk Tabu a arbin suri ngoromin, ‘Mákái! Ina tarwai kesá kálámul suri tari kak pinpidan. Ái na táil i iáu, má na eran i matananu suri inan kaiam.’ ");
INSERT INTO sgz_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Má minái iau parai si gam, ái Ioanes a pakta sorliwi tan kálámul no dikte káh di. Mái sár ái koner a gengen i lolsit si Káláu, ái sang a pakta si diar ái Ioanes Tám Arsiu.” ");
INSERT INTO sgz_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Má ngo di longrai ngorer, tan matananu má tan tám kip takis di sormángát ngo sál si Káláu a nokwan má a támin, kabin ngo dikte hol kaleng má namur a siu di ái Ioanes. ");
INSERT INTO sgz_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mái sár bos Parisaio má bos tám mánán uri nagogon dikte hol palai arsiu si Ioanes kabin kápdite hol kaleng, má ngorer di su bah di uri nemnem si Káláu uri narsá di. ");
INSERT INTO sgz_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Mái Iesu a sopasun i kán worwor narsán matananu ngoromin, “Ina toh arwat i ngaul matananu onin mai dánih? Má ngádáh á pinpidan artálár na arwat mam di? ");
INSERT INTO sgz_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Di ngoro tan kalilik di sukis má di hom i lol malar. Kesi risán á kalilik di bin ur singin kes bul á risán, má di parai si di ngoromin, ‘Á gim minái gimá posri kuduh má gimá saksak suri gama mil, mái sár kápgamte nem suri mil! Io, ki gimá ilang suri táit án tinang, má ngorer gimá saki saksak án mihmih tinang, mái sár kápgamte nem suri tang!’ ");
INSERT INTO sgz_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Má ngaul matananu onin di lu ngorer mam giur ái Ioanes Tám Arsiu. I pákánbung ái Ioanes a hut, kápte a lala namnam má kápte a lu ngin i wain mul, má gamá parai ur on ngo, ‘A ngul ái koner, a kis on gut i sápkin tanián!’ ");
INSERT INTO sgz_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Má namur Natun Kálámul a hut, má ái a namnam má a ngin, ki gamá parai bul ur on ngo, ‘Mákái! Tám namnam mat má taba kán ngin mul i wain, má a lu araturán mai bos tám kip takis má tan tám sápkin!’ ");
INSERT INTO sgz_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Io, ái Káláu á polon á hol, má kán sál a támin, má ngorer ngo rung di mur on, di inngas tari ngo sál si Káláu a nokwan má a kuluk.” ");
INSERT INTO sgz_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Má namur kesi Parisaio, ngisán ái Saimon, a long pas Iesu suri diara namnam tiklik. Má ngorer a han ái Iesu má a tapam hut iatung i rum er mák sukis suri namnam. ");
INSERT INTO sgz_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kesi wák tilatung i malar er a wák án sál. Má ngo a longrai ngo ái Iesu a han suri namnam iatung i rum káián Parisaio er, a kipi kesi átbán wel di longoi mai hat, má wel erei a tuan lain tomtom, ");
INSERT INTO sgz_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","má ngorer a hut má a dirtapul kári keken ái Iesu. Má wák erei a tang, má luir mátán a timtim uri keken ái Iesu. Má namur a salus asengsengei luir mátán tili keken ái Iesu mai nihun má a doroi, má a urai wel erei uri keken. ");
INSERT INTO sgz_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Má Parisaio kán rum erei, a mákái ngorer ki ák hol on sang ami bál ngoromin, “Sinih ngo tám worwor tus muswan á minái! Ngo tám worwor tus muswan, ki na han mánán tusi ngo matngan wák ngádáh á minái a singli, má matngan liu mul a lu murmur on.” ");
INSERT INTO sgz_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","A mánán i holhol ami bál Parisaio er ái Iesu má ák parai singin ngo, “Kesi táit ina parai besang singim, apong Saimon.” Mái Saimon a parai singin ngo, “Má iáu parai má, Tám Aratintin.” ");
INSERT INTO sgz_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Má ngorer ái Iesu a turpasi parai worwor artálár ngoromin, “Aru i kálámul diar han suri sungi kesi konom suri na tar te pirán tabal si diar. Io, má konom erei a tari alim i mar á pirán tabal singin kesi tur diar, má kesi tur diar a top i alim i sángul sár á pirán tabal. ");
INSERT INTO sgz_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Mái sár namur, diar no káp diar te arwat suri keles kalengnai pirán tabal er, ki ngorer má konom er a hol palai sár á kándiar tinákum no. Má ngádáh á kam hol, be Saimon? Ái sinih má tili diar na lala hol apakta pasi konom erei?” ");
INSERT INTO sgz_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Mái Saimon a kosoi ngo, “Iau hol on gut ngo ái kono kán tinákum a lala pakta, koner a top i alim i mar á pirán tabal.” Ái Iesu a longrai ngorer má a kosoi ngoromin, “Áá, a nokwan á kam kokos.” ");
INSERT INTO sgz_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Má namur ái Iesu a ilang suri wák erei má a sopasun kán worwor ur si Saimon ngoromin, “Má u mákái á wák minái, be Saimon? Iau hut main i kam rum, apong, má kápte u siwi kiking mam te dan ngorer i kángit tatalen. Mái sár wák minái a siwi kiking mai luir mátán má ák salsi mai nihun suri ák sengseng. ");
INSERT INTO sgz_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","46","Iau hut main má kápute árár pas iau mai doroi paring má ura te wel uri lulung. Mái sár wák minái kápate aunges i doroi aru kiking má ák urai wel a tomtom ur on. ");
INSERT INTO sgz_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kán tilik armámna i wák minái a inngasi ngo kán marán sápkin ákte pah no. Kabin ngo kes a marán i kán sápkin, má namur ái Káláu a pah palai, kálámul er na mon i kán lala armámna uri narsá Káláu. Mái sár ngo ái Káláu a pah palai sápkin káián kes kápate marán i kán sápkin, kálámul er kápnate mon i kán tilik armámna namur, na mon i án mudán sár.” ");
INSERT INTO sgz_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ái Iesu a arahi kán worwor ngorer, má namur a parai singin wák er ngo, “Kam tan sápkin ákte pah alar iáu!” ");
INSERT INTO sgz_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Mái rung di namnam tiklik mam Iesu, di longrai ngorer a parai ái Iesu má di turpasi argálta arliu i di sang ngoro minái, “Ái sinih á kálámul minái be, er ák parai suri ngo a arwat sár suri pah palai sápkin?” ");
INSERT INTO sgz_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mái sár ái Iesu a parai mul singin wák erei ngo, “Kam ruruna ákte saras pas iáu. Una han má, má na matau i balam.” ");
INSERT INTO sgz_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Te bung ur namur, ái Iesu a han tangrai tan bimán rum má malar mul, mák lu arbin mai lain arbin suri lolsit si Káláu, má kán sángul mai aru i kalik án aratintin di tiklik mai, ");
INSERT INTO sgz_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","má marán wák mul di tiklik mam di. Tan wák no erei di lu tangan Iesu má kán kalilik án aratintin mai tan táit tili kándi omobop. Má te tili di á tan wák er, ái Iesu ákte asengsegeng i di alari sasam ngo alari sápkin tanián, ngorer ái Maria Magadalene, koner ái Iesu a dos palai ahit i sápkin tanián alari; mái Susana; mái Ioana, kán wák ái Kusa, tám ololoh uri tan táit si Erodes. ");
INSERT INTO sgz_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","I kesi bung, marán matananu tili bos malar di hut talum narsá Iesu. Má ngo lala matananu dikte hut, ái Iesu a parai worwor artálár uri narsá di ngoromin, ");
INSERT INTO sgz_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Tám himhimna a tapam hut mák sápra sarai kotlin kubau iatung i rákrák. Má ngo kán tu sápra sarai kotlin kubau ngorer, te a pur uri sál má di sukai, má namur tan boh man di roh kis má dik lu tokam pasi. ");
INSERT INTO sgz_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Má te a pur uri bim a mon i hat adi lal, má ngo a tikbut sár ki ák marang melek, kápkabin ngo bim erei a sengseng. ");
INSERT INTO sgz_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Má te mul a pur uri katbán kaulbek, má kaulbek a pakta mák iaungi má kápate u. ");
INSERT INTO sgz_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Má te a pur uri lain bim, má a tikbut má a lain kopkom kuluk má namur a u, má di no di u arwat mai keskeskesi mar.” A be parai ngorer ái Iesu, má namur a sopasun kán worwor ngoromin, “Ái koner a nem ngo na talas má na mánán, ki na kis án alongra!” ");
INSERT INTO sgz_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Má kán kalilik án aratintin di ngátngát sálán worwor si Iesu, má namur di gáltai ngo, “Dánih sang á sálán á worwor artálár erei u parai?” ");
INSERT INTO sgz_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Má a kos di ái Iesu ngoro minái, “Tungu a tur punpunam á mánán suri lolsit si Káláu má sál a mur on suri kátlán i git. Má onin ái Káláu ákte tari mánán er si gam á tan kalilik án aratintin. Mái sár tan lite alatung, kándi tu longrai worwor artálár suri ngorer da mákmák má kápdate mák ilmi, má da longrai má kápdate longra ilmi, má kápdate talas ur on.” ");
INSERT INTO sgz_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Mái Iesu a sopasun i kán worwor ngo, “A ngoromin á sálán á worwor artálár erei. Kotlin kubau erei, ái sang á pinpidan káián ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Bim erei i sál a tur arwat mai rung di longrai pinpidan káián ái Káláu, má namur ái Satan a hut má ák long palai pinpidan tili bál di da káp ruruna sang má ái Káláu na aliu pas di. ");
INSERT INTO sgz_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Má bim er a mon i hat on, a tur arwat mam rung di longrai pinpidan má dik top on mai gasgas. Mái sár pinpidan kápate lala sisip i nirwán uri bál di, má ngorer di ruruna i án mudán pákánbung sár. Má namur ngo artohtoh a hut, ki dik pur. ");
INSERT INTO sgz_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Má kotlin kubau erei a pur uri katbán kaulbek, ái a pur uri rung di longrai, mái sár kándi tu taltaladeng sang. Má namur holhol suri táit án naul bim má hol apakta i minsik má nemnem suri toltolom táit no a iaungi pinpidan káián ái Káláu, má wán i di a tu pail be mák lu rus. ");
INSERT INTO sgz_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Má kotlin kubau erei a pur uri lain bim, ái a pur uri rung di longrai arbin má di hol páptai mai muswan, má dik lu mur on ami bál di. Di longoi ngorer má kápte di puplir, má namur dik lu oboi lain wán i di.” ");
INSERT INTO sgz_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Mái Iesu a parai mul ngoromin, “Kápte kesi kálámul a oskoi lam má ák bor kári talsán mai kuro ngo na oboi lam i lalin suh. Kápte. Na lu akai lam i nián sang suri rung da kusak da mákái talas erei. ");
INSERT INTO sgz_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Io, sálán á kak pinpidan a punpunam onin, má namur na tur talas. Má te sálán kápgamte mánán kuluk, namur gama talas besang ur on. ");
INSERT INTO sgz_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Gama hol páptai erei gam longrai. Ngorer ái koner a hol páptai pinpidan káián ái Káláu, ái Káláu na apakta pasi kán pinpidan i bál. Mái koner kápte a hol páptai kán pinpidan, ái Káláu na pah palai mudán er a hol on ngo a kis i kán hol.” ");
INSERT INTO sgz_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Má namur ái mámán ái Iesu má rang tuán di hut suri mák Iesu, mái sár kápdite artálár suri da han narsán a kápkabin ngo lala matananu. ");
INSERT INTO sgz_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Má ngorer te kálámul di parai singin ngo, “Ái mamam má rang tuam di sámtur idi karpala ngorer di nem suri da mák iáu.” ");
INSERT INTO sgz_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Mái Iesu a parai singin matananu ngoro minái, “Áiá á mamang má sinih á rang tuang? Di ái rung sár erei di longrai pinpidan si Káláu má di murmur on mul.” ");
INSERT INTO sgz_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Má kesi bung mul ái Iesu a parai singin kán kalilik án aratintin ngoromin, “Gita alus kusai dan taliu suri giták han uri kesi balsán.” Io ngorer má, di sa uri mon má dik turpasi han má. ");
INSERT INTO sgz_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Má ngo di lu hanhan tangrai dan taliu, ái Iesu a suám má ák boptin. Má namur lala bát a hut má a husai dan taliu ngorer má ák aptur i pákán nah. Má mon erei ákte tangkabin má suri na káng mai dan, má ngorer di lala ráuráuwas má pátum suri ngo da hiru. ");
INSERT INTO sgz_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Má tan kalilik án aratintin di han narsán ái Iesu má di áplasi, má dik parai singin ngo, “Tám Aratintin, giták hiru má inái!” Mái Iesu a pán mák salaptur melek má a dos kári kihkih má pákán nah mul, má ngorer kihkih má pákán nah diar matau má dan ák siaroh má. ");
INSERT INTO sgz_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Má ngorer ái Iesu a parai si di sang i kán kalilik án aratintin ngoromin, “Be, aiá á kamu ruruna?” Mái sár di pángáng má di mátut, má di worwor arliu i di sang ngo, “Matngan kálámul ngádáh á minái a dos kári kihkih má nahlam má diar má taram on?” ");
INSERT INTO sgz_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Io, di alsai mon erei má dik masar i balis á Gadara i kuir balsán dan taliu á Galiláiá tilada. ");
INSERT INTO sgz_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Io, a masar uratung i kon ái Iesu, má a banai kesi kálámul tilatung i bimán rum erei a mon on i sápkin tanián. Kálámul erei ákte kunsin i dolon pákánbung má kápate lu kis i malar, a lu mon sár tangrai tan mátán hat erei di lu tahni tan kálámul ái. ");
INSERT INTO sgz_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Má i pákánbung a mák Iesu á kálámul erei, wa a lala wakwak sang, ki ák pur dirtapul i mátán táil ái Iesu mák perek ngoromin, “Iesu, Natun ái Káláu Sorsorliu, suri dáh u soksok iau? Iau lala sung iáu suri koion una arangrangas i iau!” ");
INSERT INTO sgz_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Kálámul erei a parai ngorer kápkabin ái Iesu ákte dos palai sápkin tanián suri na so alari sang. Má tungu marán i pákán sang, sápkin tanián a lu balbal abengnai, má ngorer kálámul erei di lu tolai má dik lu kabat páptai aru i limán má aru i keken mai sen. Mái sár a lu tamutái sen, má ngorer ák lu tangnai i sápkin tanián uri tepák i pokon bia. ");
INSERT INTO sgz_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Io, ái Iesu a longrai ngorer a parai, má namur a gáltai ngo, “Ái sinih á ngisam?” Má a kosoi ngo, “Ngisang ái Marán.” A kokos ngorer kabin marán sápkin tanián dikte kusak ur on á kálámul erei. ");
INSERT INTO sgz_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Má tan sápkin tanián di lala sung Iesu sang suri koion na dos pala di uri tinkas án kamkabat. ");
INSERT INTO sgz_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Má kesi numán bor di bilik iatung i balsán pungpung i pokon erei. Má bos sápkin tanián di mákái ngorer má dik lala sung Iesu suri na sormángát pala di suri da kusak uri tan bor, má ngorer ái Iesu a mángta pala di. ");
INSERT INTO sgz_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Io, tan sápkin tanián erei di so alari kálámul er má ding kusak uri tan bor, ngorer má numán bor erei di sangar i rut sosih uradi dan taliu má di no sang di kong. ");
INSERT INTO sgz_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Tan kálámul di lu ololoh i numán bor erei di mákái ngorer a longoi ái Iesu, má dik rut má dik para sarai iatung i bimán rum erei má tangrai tan malar mul. ");
INSERT INTO sgz_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Má namur matananu di han suri mákái táit er ákte tapam hut. Má ngo di tapam hut narsán ái Iesu, di mákái kálámul er dikte so alari i bos sápkin tanián, a sukis iatung pátmi keken ái Iesu, ákte sulu kaleng má ákte hut kaleng mul i kán lain hol. Má ngo di mákái ngorer ki dik lala mátut. ");
INSERT INTO sgz_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Mái rung nengen di mákái táit a longoi ái Iesu, di bitái matananu er di hutngin hut suri mákái kálámul er tungu bos sápkin tanián di porta on, má dik bit di suri ngádáh a aliu pasi ngoi ái Iesu. ");
INSERT INTO sgz_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Má matananu tili balis á Gadara di mákái ngorer má dik sung Iesu suri ngo na aptur alar di má nák han, kabin di lala mátut taladeng. Io, má ngorer ái Iesu má kán kalilik án aratintin di tur tapriu má ding kaleng. Di sa uri mon ngo da han, ");
INSERT INTO sgz_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","mái sár kálámul erei tan sápkin tanián dikte so alari, a hut narsá Iesu mák sungi ngo ái mul na han tiklik mam di. Mái sár ái Iesu a dos pala kalengnai mák parai singin ngoromin, ");
INSERT INTO sgz_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Una kaleng uri kam malar má unák parai bos tilik támin táit ái Káláu a longoi mam iáu.” Má kálámul erei a han tangrai bimán rum no má a arbin suri tilik támin táit ái Iesu a longoi mai. ");
INSERT INTO sgz_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Má ngorer ái Iesu mai kán kalilik án aratintin di kaleng mul uri kesi balsán dan taliu, má matananu kandi tu kis nanai má dik árár pasi. ");
INSERT INTO sgz_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mái Iairus, kesi pakpakta tili rumán lotu i malar er, a tapam hut má a pur dirtapul i mátán táil ái Iesu mák lala sungi suri na han uri kán rum, ");
INSERT INTO sgz_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kabin ái Iairus tukes sár á natun, a kalik átlái, má ákte sángul mai aru i kán bet. Má i pákánbung erei, natun tahlik a sasam má páput suri na mat. Ái Iesu a longrai ngorer má a han tiklik mai kálámul erei. Má marán matananu di mur on má dik siuti. ");
INSERT INTO sgz_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Má kesi wák iatung a sasam mai dár arwat mai sángul mai aru á bet. A mákái kalang má dár kápate rah. Má boh tám latlat kápdite long artálár pasi kán sasam. ");
INSERT INTO sgz_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Má wák erei a láklák namurwa Iesu má a singli nomnobon lusán, má káp melek mul dár a ekesi más mák rah. ");
INSERT INTO sgz_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Má i pákánbung a singli lusán ái Iesu á wák erei, ái Iesu a tur kaleng mák gálta ngo, “Sinih erei ákte sigil iau?” Má matananu di longrai ngorer má dik arkawar, má ngorer ái Petero a parai singin ngoromin, “Tám Aratintin, minái lala matananu di tur kaul iáu.” ");
INSERT INTO sgz_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mái sár ái Iesu a parai ngo, “Kesi kálámul ákte top i iau, kápkabin iakte mánán on ngo risán á kak rakrakai ákte bokoh alar iau.” ");
INSERT INTO sgz_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Má ngo wák erei a mákái ngo ákte tur apos uri mátán matananu, io a ráuráuwas má a han mák pur dirtapul i mátán táil ái Iesu. Má iatung i mátán matananu no, wák erei a para aposoi kán sasam má ngo ákte sengsegeng alari i pákánbung a top i Iesu. ");
INSERT INTO sgz_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Mái Iesu a mákái ngorer má a parai singin ngo, “Wákán, kam ruruna ákte aliu pas iáu. Una han má na matau i balam.” ");
INSERT INTO sgz_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Má kán tu worwor besang ái Iesu iatung, io kesi kálámul a lu him i rum si Iairus a rut pas Iairus mák bitái ngoro minái, “Natum tahlik ákte mat. Má dánih una lawa pasi mul suri ái Tám Aratintin?” ");
INSERT INTO sgz_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Má ngo ái Iesu a longrai ngorer, a parai si Iairus ngo, “Koion una mátut. Una ruruna sár, má natum na liu.” ");
INSERT INTO sgz_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","A be para ngorer ái Iesu, má diar má turpasi láklák, má namur diar purut anang i rum si Iairus. Diará purut ngorer má diar mákái matananu no kándi tu tangsi kalik iatung. Mái Iesu a parai si di ngo, “Koion gama tang. Kalik erei sinih ngo a mat, a boptin sár.” Má di longrai ngorer má di lala nongnai kabin di mánán on ngo kalik átlái er ákte mat sang. Mái Iesu kápate nem i tan lite da kusak. A nem sár i Petero mái Ioanes mái Iakobo ditul masik, má kákán mái mámán ái kalik mul a long pas diar má dihat no dihat kusak urami suri kalik. ");
INSERT INTO sgz_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mái Iesu a top i limán kalik átlái er má a parai singin ngo, “Lik, una aptur!” ");
INSERT INTO sgz_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Má káp melek kalik átlái er a kaleng i tanián mák pán kaleng i mansin má a salaptur melek. Má namur ái Iesu a parai si di ngo da támri kalik er nák namnam. ");
INSERT INTO sgz_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Mái kákán mái mámán diar pángáng, mái sár ái Iesu a tur kalar diar suri koion diara parai singin tekes á táit er a tapam hut. ");
INSERT INTO sgz_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","2","Má kesi bung namur, ái Iesu a bin talmi kán sángul mai aru á kalik án aratintin uri narsán suri na tarwa di dák arbin suri lolsit si Káláu má suri dák araliu. Má ngorer a tari rakrakai má nokwan si di suri tipar palai sápkin tanián má suri aliu pasi tan sasam. ");
INSERT INTO sgz_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Mái Iesu a parai si di ngoro minái, “Erei gama han, koion gama kipi tekesi táit i kamu inan. Koion gama top i buk uri tangan gam i láklák, koion á rat, koion á balbal, koion á pirán tabal, má koion gama kipi kamu te kelkeles. ");
INSERT INTO sgz_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Erei ngo gama kusak uri malar má dik árár pas gam ái, gama ekesi kis iatung i rum erei pang i bung gama han pas alari malar er. ");
INSERT INTO sgz_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Má ngo di tar bah di uri gam, gama aptur pas alari malar erei má gamák tinra palai rah tili kik gam suri para inngasi ngo kándi sápkin a kis pagas i káil i di sang.” ");
INSERT INTO sgz_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Má ngorer di aptur má dik han tangrai tan malar mai arbin uri lain arbin, má di araliu mul i bos kuir no di han ái. ");
INSERT INTO sgz_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","I pákánbung erei ái Erodes a kabisit a kátlán i balis á Galiláiá, má a longrai arbin uri tan táit a longoi ái Iesu, má ngorer a ngátngát sálán tan táit ákte longrai, káplabin i te matananu di parai ngo ái Ioanes Tám Arsiu ákte aptur alari minat. ");
INSERT INTO sgz_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Má te kálámul di parai ngo ái Elaisa ákte tapam hut kaleng. Má te kálámul sang di parai ngo tekes tili di á tan tám worwor tus til hirá ákte liu kaleng. ");
INSERT INTO sgz_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mái sár ái Erodes a parai ngo, “Ái Ioanes Tám Arsiu, iakte artari suri dik tár kusi án pogong. Mái sinih mul á kálámul erei, má matngan kálámul ngádáh a longoi tan táit ngorer má iak longrai arbin ur on?” Má ngorer a tohoi ser sál ái Erodes suri diara mákmák arsuar ái Iesu. ");
INSERT INTO sgz_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Dikte hut kaleng mái tan apostolo erei, di á sángul mai aru á kalik án aratintin ái Iesu a ilwa pas di, má dik para talsai si Iesu á tan táit dikte longoi. Má namur a long pas di ái Iesu, má dik han masik uri bimán rum á Betesaida. ");
INSERT INTO sgz_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Má ngo matananu di longrai ngo dikte han ái Iesu di, io di mur on. Má ngo di hut i narsán, ái Iesu a árár pasi matananu mák abitbit di suri lolsit si Káláu. Mái rung di nem suri na aliu pas di, a asengsegeng i di ái Iesu alari kandi sasam. ");
INSERT INTO sgz_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Io, ákte rahrah má i bung erei, má kán sángul mai aru i kalik án aratintin di hut si Iesu má dik parai singin ngoro minái, “Wa pokon mau á minái! Una dos palai mái matananu sara suri da han uri tan malar má tan páli iatung páput sár suri da ser namnam má ser rum uri bop on.” ");
INSERT INTO sgz_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ái Iesu a longrai ngorer ki ák parai si di ngoromin, “Á gam sang, gama tabar di.” Má tan kalilik án aratintin di kosoi ngoromin, “Kápate arwat á namnam minái si git. Alim i tigán balbal má aru isu sár, kol gima han hul pas te mul ur ándi?” ");
INSERT INTO sgz_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","16","Mái sár ái Iesu a parai si di ngo, “Gama parai singin matananu suri da sukis i tan boh, má na lu arwat mai alim i sángul á kálámul on i keskeskesá boh.” Má ngorer tan kalilik án aratintin di dos i matananu má dik sukis. Má namur ái Iesu a top pasi alim á tigán balbal má aru isu erei má ák tántán urami bát mák sung kári. Má namur ák tibi balbal má isu mul má ák tari singin kán kalilik án aratintin suri dik tulsai i matananu sang. Tan kálámul no iatung di arwat mai alim i arip á káláu, má boh wák má kalilik kápte di wás di. ");
INSERT INTO sgz_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Má matananu di no di namnam má dik mas. Má namur tan kalilik án aratintin dik dungi sángul mai aru i lala rat mai namnam er di an tigán. ");
INSERT INTO sgz_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Má kesi bung mul, ái Iesu masik a sung má kán kalilik án aratintin di tiklik no sár. Io, di turpasi nguruk mái Iesu a gálta di ngo, “Matananu di lu parai sur iau ngo iau sinih?” ");
INSERT INTO sgz_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Má ding kos Iesu ngoro minái, “Te kálámul di parai ngo iáu ái Ioanes Tám Arsiu, má te bul di parai ngo iáu ái Elaisa, má te kálámul sang di parai ngo iáu kesi tám worwor tus til hirá ákte aptur kaleng alari minat.” ");
INSERT INTO sgz_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Namur mul ái Iesu a gáltai kán kalilik án aratintin ngo, “Má á gam sang, gam ngoi ngo iau sinih?” Ngorer mái Petero a kos Iesu ngoro minái, “Á iáu á Karisito, Mesaia káián ái Káláu.” ");
INSERT INTO sgz_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Mái Iesu a lala dos kalar di sang ngo, “Koion sang gama parai singin tekes ngo á iau á Mesaia.” ");
INSERT INTO sgz_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ngorer a sopasun kán worwor mai ngoromin, “Natun Kálámul na áslai rangrangas má da mikmikwai má da oboi uri minat á bos kálámul pakta má bos pakpakta kán tan tám osmapak má bos tám mánán uri nagogon. Má ngo na rah i atul á bung, na liu kaleng.” ");
INSERT INTO sgz_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Má a parai mul si di no iatung ngoromin, “Ngo kono a nem suri na mur i iau, koion sang na murmur i kán hol. Na puski kán kubau kus i bosbos bung no má nák murmur i iau sár mai, ngorer na bál tari sang uri lalin i iau má na eran suri na mat ngoro iau. ");
INSERT INTO sgz_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Má ngorer ngo kálámul a tar kunlai kán liu suri na bes mai tan táit til main i naul bim, ki liu muswan er a kis áklis na bokoh alari. Mái sár ái koner kápate mámnai kán liu mák bál tari sang sur iau, ái na atur páptai liu muswan er. ");
INSERT INTO sgz_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ngádáh, a kuluk ngo kálámul na kátlán bos matmatngan táit main i naul bim, má nák omlawa palai kán liu suri? Kápte sang. ");
INSERT INTO sgz_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mái koner a rumrum suri arbin talas uri iau má uri kak pinpidan, namur Natun Kálámul na rumrum mul singin i pákánbung ngo na kaleng tilami bát tiklik mai minmáir sang má minmáir i Kákán má káián bos angelo. ");
INSERT INTO sgz_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","A támin muswan iau parai si gam, te tili gam gam sámtur minái, kápdate áslai besang á minat má dák mákái lolsit si Káláu ákte hut.” ");
INSERT INTO sgz_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","A rah i kán worwor ái Iesu, má ngorer a aunges be. Má namur arwat mai awal gut á bung ákte rah, ái Iesu a lam pas Petero mái Ioanes mái Iakobo ditulá tiklik mai, má dihat má tapam uramuni pungpung suri sung. ");
INSERT INTO sgz_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","I pákánbung kán tu sung be ái Iesu, a arkeles i mákmák uri aur, má lusán mul a tuan bal mák pilpilpil. ");
INSERT INTO sgz_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Má káp melek sár má aru i kálámul iatung diar má worwor mam Iesu. Aru kálámul erei ái Moses mái Elaisa. ");
INSERT INTO sgz_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Má diar soura mai mermer má talas tilami bát, má ngorer diar worwor mam Iesu suri kán minat ami Ierusalem má ngádáh na long artálár on ngoi á sál er ái Káláu a nem i Iesu suri na longoi. ");
INSERT INTO sgz_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ái Petero mai aru i turán er ditul tiklik mam Iesu, dituláte boptin. Mái sár ngo ditul pán pas, ditulá mák Iesu mai talsán minmáir má aru kálámul erei diar sámtur tiklik mai. ");
INSERT INTO sgz_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Io, namur i pákánbung ngo aru kálámul er diar eran suri han alar Iesu má, ái Petero a parai si Iesu ngo, “Konom, a kuluk sang ngo git minái. Ngádáh, gimtula long te na tul i pálpálih, kes kaiam, má kes káián ái Moses, má kes káián ái Elaisa?” A parai ngorer ái Petero káplabin ngo kápate hol pas te lain worwor ngo na parai. ");
INSERT INTO sgz_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Io, kán tu worwor be ái Petero, má a hut i kumlán mehmeh má ák ámkuk di no, má ngorer atul i kalik án aratintin er ditul lala mátut. ");
INSERT INTO sgz_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Má namur kaungán kes tilami kumlán mehmeh a parai ngoromin, “Minái á kang Kalik, ái koner iakte ilwa pasi. Gama alongra singin!” ");
INSERT INTO sgz_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","I pákánbung ngo a wat i worwor erei, atul i kalik án aratintin ditul mák Iesu masik má iatung, mái Moses mái Elaisa diaráte bokoh má. Má ditul kis pau sár má káp ditul te parai singin tekes á tan táit dituláte mákái, namur sang má ditulá parai. ");
INSERT INTO sgz_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Má arasa uri kábungbung, ái Iesu mai atul i kalik án aratintin di sosih tilamuni pungpung má lala matananu sang di bana Iesu. ");
INSERT INTO sgz_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kesi kálámul a bin tilatung i katbán matananu ngoromin, “Tám Aratintin, iau sung iáu una mákái besang i natung, kang kalik án káláu, war káh kes masik sár. ");
INSERT INTO sgz_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Sápkin tanián a lu abengnai, má káp melek ák lu wakwak mák lu pur kabin a lu dikdikdik, má busbus mul a lu so tili ngudun, má sápkin tanián a lu arangrangas on má kápate lu arlah on sang. ");
INSERT INTO sgz_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Má ngorer iakte sungi kam kalilik án aratintin ngo da long palai sápkin tanián erei, mái sár kápdite long arwat on.” ");
INSERT INTO sgz_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ái Iesu a longrai worwor erei mák parai si di ngoromin, “Be, kápgamte ruruna? Na is á bet ina kis tiklik mam gam? Iak ngesmat má, na is á bet mul ina mona gam?” Ngorer mái Iesu a parai singin kálámul erei ngo, “Long pas natum ur mainái.” ");
INSERT INTO sgz_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Io, má kalik er a láklák, má namur sápkin tanián a agokgokoi mák lápkai uradi bim. Mái Iesu a wor uri sápkin tanián er mák dos palai alari kalik, ngorer má kalik er ák sengsegeng má. Má namur ái Iesu a tar kalengnai kalik ur si kákán. ");
INSERT INTO sgz_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Má matananu di pángáng suri mákái lala rakrakai si Káláu. Má matananu di pánsálngát suri tan lain táit er ái Iesu ákte longoi, má namur ái Iesu a parai singin kán kalilik án aratintin ngo, ");
INSERT INTO sgz_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Gama alongra suri táit minái ina parai si gam, má koion gama balantahni! Da tari Natun Kálámul uri limán bos kálámul suri da nagogon on.” ");
INSERT INTO sgz_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mái sár tan kalilik án aratintin kápdite talas suri sálán á worwor erei a parai ái Iesu si di, kabin sálán a kis punpunam alar di da káp talas ur on, ái sár di mátut suri da gáltai. ");
INSERT INTO sgz_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tan kalilik án aratintin di wor arkuh i di sang suri ngo ái sinih tili di a kálámul pakta. ");
INSERT INTO sgz_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Mái Iesu a mánán i táit kandi tu hol on ami bál di. Io, má a long pasi kesi gengen kalik ái Iesu má a atri i risán sang, ");
INSERT INTO sgz_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","má namur a parai si di ngoromin, “Ái koner a tángni kesá gengen kalik a ngoro kono minái kabin ngo a mámna iau, kápate tangan masiknai kalik erei, a tangan iau mul. Mái koner a tangan iau ngorer, kápte a tangan masikna iau, a tangan Koner mul a dos pala iau ur mainái. Ái koner a agengen on i katbán i gam, ái sang a pakta sorliu i gam no.” ");
INSERT INTO sgz_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ngorer mái Ioanes a kosoi worwor si Iesu ngoro minái, “Tám Aratintin, gim mákái kesi kálámul a tipar palai sápkin tanián mai ngisam, mái sár kápate ngoro gim, kápate lu murmur i iáu. Má ngorer gimá tur kári.” ");
INSERT INTO sgz_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Mái Iesu a parai singin ngo, “Koion gama tur kári. Ái koner kápate sák mam gam, ái á tur gam.” ");
INSERT INTO sgz_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Má namur ákte páput má i pákánbung ngo ái Iesu na tapam urami bát. Mái Iesu a lala ngoi sang i bál suri na han ur Ierusalem, má ngorer di turpasi kandi inan. ");
INSERT INTO sgz_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Má a dos palai te kalilik ái Iesu táilnai uri kesi malar á Samaria suri da eran i nián i di iatung suri da bop ái. ");
INSERT INTO sgz_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mái sár matananu tilatung i malar erei kápdite nem i Iesu, kabin kandi ruruna a lite alari ruruna kandi tan Iudáiá. Má ngo dikte mánán ngo ái Iesu di da han sang ur Ierusalem suri lotu ami, ngorer kápdite nem suri da tangan di. ");
INSERT INTO sgz_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Má aru i kalik án aratintin, ái Iakobo mái Ioanes, diar mákái ngorer mák mos i bál diar. Io, diará sung Iesu ngoro minái, “Konom, ngádáh? U nem i giur suri giura sungi kámnah tilami bát má nák inan i malar minái suri dák mosrah no?” ");
INSERT INTO sgz_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ái Iesu a longrai ngorer má a ilang má a mák diar má a worwor rakrakai uri diar. ");
INSERT INTO sgz_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Má ngorer sár ái Iesu mai kán kalilik án aratintin di han uri lite malar. ");
INSERT INTO sgz_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Io, i pákánbung kandi tu láklák be tangrai sál ái Iesu mai kán kalilik án aratintin, kesi kálámul a parai si Iesu ngo, “Gitar no á iau. Tan pokon no una han ur on, ina mur i iáu.” ");
INSERT INTO sgz_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Mái Iesu a parai singin ngoromin, “Tan pap rokoi a mon i nián i di suri da bop on, má tan man a mon i páhiun i di mul. Mái sár Natun Kálámul, kápte pokon na mangeh ái má oboi lul on. Ngo ái rung di áslai suri da mur i iau, na kápte gut á nián i di mul suri mangeh ái.” ");
INSERT INTO sgz_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","A mákái kesi kálámul bul ái Iesu, mák parai singin ngo, “Lákám, unák mur i iau.” Mái sár kálámul erei a parai si Iesu ngoro minái, “Keskam, Konom. Mulán táit be, una mángát pala iau má inak han suri tahun tata be.” ");
INSERT INTO sgz_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ái Iesu a kosoi kálámul erei ngo, “Tahni minat kandi talar ái rung káp kandi te liu. Má iáu una han má arbin talas suri lolsit si Káláu.” ");
INSERT INTO sgz_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ngorer má kesi kálámul mul a parai si Iesu ngo, “Gitar no á iau. Ina mur i iáu, Konom. Mái sár mulán táit be, una mángát pala iau má inak han lulu be mai rang buhang.” ");
INSERT INTO sgz_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Mái Iesu a parai singin ngoromin, “Ái koner na soso, na mákmák uri pokon erei na atri kán kirau ái suri soso. Má ngo na ilang kaleng ur namur, na soi hat sang má na bul i kán kirau. Má ngorer mul ái koner na lu himhim suri lolsit si Káláu. Ngo na lu ilang kaleng ur namur, kán him kápnate kuluk, má ngorer kápnate long artálár pasi kán talar.” ");
INSERT INTO sgz_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ái Konom Iesu a ilwa pasi mul i ahit i sángul mai aru i kálámul. Má namur a tarwa di a lu rururu suri da táil on uri tan bimán rum má malar erei ái sang ái Iesu na han ur on be. ");
INSERT INTO sgz_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Mái Iesu a inau i di i ahit i sángul mai aru á kálámul erei ngoro minái, “Balbal i num ákte matuk. Mái sár ngo tan tám him kápdite marán suri il talmi balbal. Má ngorer gama sung Koner a kátlán i num erei suri na tarwa pala te mul i tan tám him suri da dung talmi kán balbal erei ákte matuk uri kámniánsit. ");
INSERT INTO sgz_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Erei gama han má, ina tarwa gam ngoro tan sipsip uri lolon tan pap rokoi. ");
INSERT INTO sgz_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","I kamu inan, koion gama top i táit uri dudung ngorer i rat ngo tekes mul á bákbákar kek, ái koner sár gamáte oboi má. Má koion mul ngo gama talsir tangrai sál. ");
INSERT INTO sgz_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Io, erei ngo gama kusak uri tekesi rum, mulán táit gama árár pasi rung di kis i rum erei má gamák parai ngo, ‘Moloh na kis i narsá gam i rum minái.’ ");
INSERT INTO sgz_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Erei ngo tám kis matau a kis iatung, na áslai kamur moloh uri narsán. Mái sár ngo kápte kesá tám kis matau a lu kis iatung i rum erei, kamur moloh na kaleng uri narsá gaur. ");
INSERT INTO sgz_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Gama kis áklis i rum erei má koion gama han alari suri bop i lite rum bul. Má gama ngin má ani namnam erei di tabar gam mai, kabin tan tám him a mon i kandi arsupan suri talar di lu longoi. ");
INSERT INTO sgz_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Io, erei ngo gama han uri malar má dik árár pas gam ái, gama lu longoi ngoromin. Gama ani á namnam erei di tabar gam mai, ");
INSERT INTO sgz_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","má gama asengsegeng i tan sasam iatung i malar erei, má gamák parai si di á matananu iatung ngo, ‘Lolsit si Káláu ákte tapam hut páput uri narsá gam.’ ");
INSERT INTO sgz_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mái sár ngo gama kusak uri malar kápdite árár pas gam ái, gama láklák tangrai sál on á malar erei má gamák lu parai ngoromin singin matananu, ");
INSERT INTO sgz_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Rah tili kamu malar er a patap i kik gim, gimáte tinra palai suri akeng i gam ngo gamáte longoi sápkin tatalen mam gim. Mái sár gama hol páptai sang á minái. Lolsit si Káláu ákte tapam hut páput uri narsá gam!’ Io, ngo gamáte parai ngorer, ki erár gamák han alari á malar erei. ");
INSERT INTO sgz_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Gam mánán á lala rangrangas hirá er a hut i malar á Sodom mák bam no. Wa a gengen sár á rangrangas erei. Má i bungun nagogon, ái Káláu na tari lala rangrangas taladeng uri malar erei kápate tangan gam.” ");
INSERT INTO sgz_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Mái Iesu a sopasun i kán worwor ngoromin, “Gama sák á gam tara Korasin má tara Betesaida. Gama tuan sák taladeng sang kabin ái Káláu na nagogon i gam á matananu tilatung suri tan akiláng ngo dikte longoi i katbán i gam má kápgamte kis án sum suri. Má ngo da han longoi mul á tan akiláng ngorer hirá sang i aru á malar erei Tair má Sidon, wa matananu tilatung da han te oboi akiláng án mokos, má ngorer da sámri mul i kápán páplun i di mai iahiah suri para apos di ngo dikte hol kaleng. ");
INSERT INTO sgz_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","I bungun nagogon ái Káláu na tari rangrangas ur Tair má Sidon. Mái sár rangrangas na tari ur Korasin má Betesaida na lala sák taladeng sang. ");
INSERT INTO sgz_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Mái sár á gam á tara Kapernaum, gam ngoi ngo gama rakrakai taladeng má pakta sorliwi boh malar no, be? Wa kápte sang. Ái Káláu na sápka gam uradi tarang án minat.” ");
INSERT INTO sgz_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Má namur ái Iesu a parai singin ahit i sángul mai aru i kalik án aratintin ngoro minái, “Ái koner a alongra si gam, kápate alongra si gam masik. A alongra singing mul. Mái koner a mikmikwa gam, a mikmikwa iau mul. Mái koner a mikmikwa iau ngorer, a mikmikwa Koner mul a tarwa pala iau ur main.” ");
INSERT INTO sgz_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Má ngorer ái Iesu a tarwa di i ahit i sángul mai aru má dik han. Má namur di kaleng, má di lala laes sang. Ngorer má dik parai si Iesu ngoro minái, “Konom, tan sápkin tanián mul di taram gim i pákánbung gim dos pala di mai ngisam!” ");
INSERT INTO sgz_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Mái Iesu a kosoi kandi worwor ngoromin, “Áá, iau ialial i Satan ngo kán rakrakai ákte rah, má ngorer a pur tilami bát ngoro pil. ");
INSERT INTO sgz_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mákái, iakte tari nokwan si gam arwat suri gama sukai kanih sáksák má mákál má suri gama tur kári kán rakrakai ái Satan, má ngorer kápte kesi táit na arwat suri long bengta gam. ");
INSERT INTO sgz_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mái sár koion gama tu laes bia ngo tan sápkin tanián di taram i gam kabin iakte tari rakrakai suri tipar pala di. Auh, koion gama laes suri á ngorer. Gama lala laes suri ngoromin ngo ngis gam ái Káláu ákte sir páptai imi bát.” ");
INSERT INTO sgz_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","I pákánbung erei sang, Tanián a Pilpil a agasgas pasi bál ái Iesu má a parai ngoromin, “Io, Tata, á iáu Konom u kátlán naul bát má naul matmatngan pokon no! Minái iau ot kuluk má para agas iáu suri sál erei ukte ilwa pasi ngo una mur on, má ngorer ukte para aposoi si rung kápdite lala mánán á táit er ukte punmai si di ái rung di mánán. ");
INSERT INTO sgz_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ái Kakang ákte tar noi tan táit singing. Ái Káláu masik a mánán muswan i Natun, mái Natun masik a mánán muswan i Káláu er Kákán. Mái rung a ilwa pas di ái Natun, á di mul di arwat suri da mánán muswan i Káláu er Kákán ngo ái Natun a inngas tari si di.” ");
INSERT INTO sgz_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Io, namur ái Iesu a ilang ur singin kán kalilik án aratintin mák para kodongnai si di ngoromin, “Di kuluk pala ái rung er dikte mákái tan táit er gamáte mákái má dik talas ur on. ");
INSERT INTO sgz_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Marán tan tám worwor tus má tan kabisit til hirá di nem suri mákái táit ngorer gamáte mákái, mái sár kápdite mákái. Di nem suri longrai tan táit gam longrai, má kápdite longra te on.” ");
INSERT INTO sgz_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Má namur kesi tám mánán uri nagogon a sámtur má a tohtoh suri pidir Iesu. A parai si Iesu ngoromin, “Tám Aratintin, dánih ina longoi suri ina otoi á liu áklis?” ");
INSERT INTO sgz_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Mái Iesu a gálta kalengnai kálámul er ngoro minái, “Nagogon si Káláu dánih a parai, má i bung u wásái dánih u mánán pasi til on?” ");
INSERT INTO sgz_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Má kálámul erei a kosoi worwor si Iesu ngo, “Una mámna Káláu kam Konom mai kunlán balam no, má mai taniam no, má mai kam kunlán rakrakai, má mai kam kunlán holhol no. Má una mámnai mul i turam ngorer u mámna kalengna iáu sang.” ");
INSERT INTO sgz_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Mái Iesu a ngoi singin kálámul erei ngo, “Kam kokos a nokwan. Una longoi ngorer ki unák otoi á liu áklis.” ");
INSERT INTO sgz_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mái sár tám mánán uri nagogon a nem suri inngas tari ngo a nokwan i mátán ái Iesu, má ngorer a bali gálta timani ngoro minái, “Be, ái sinih sang á turang?” ");
INSERT INTO sgz_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Mái Iesu a kosoi mák parai ngo, “Ina puksai kesi soi singim a ngoromin. Kesi bung má, kesi kálámul a aptur til Ierusalem suri han uradi Ieriko, má ngorer a turpasi láklák tangrai sál. Pákánbung ngo ákte láklák dol má, tan tám siksikip di purut singin iatung i sál má dik ubi kálámul er ák mat palpal. Di ulát palai lusán má di kip noi kán tan táit no, má ngorer di táu alari má iatung i sál. ");
INSERT INTO sgz_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Io, kesi kálámul tám osmapak a mur i sál er mul. Má pákánbung a tapam hut iatung i narsán kálámul er, a tu mákmákái sár má kápate tángni. A tu láklák sorliwi sang tili kesi balsán sál mák han sár. ");
INSERT INTO sgz_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","“Ngorer má kesi kálámul bul a han mul i sál er. Kálámul erei tili mát si Lewi, á di á gegen er ái rung di lu him i rumán osmapak sang. A lu hanhan tangrai sál má ngorer a purut iatung i narsán kálámul er. A tu mákmákái sár mul má a láklák sorliwi sang tili kesi balsán sál. ");
INSERT INTO sgz_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Mái sár namur má, kesi kálámul bul a lu hanhan i sál er, ái a kakun Samaria, kes tili di ái rung tan Iudáiá di lu mikmikwa di. A han i kán inan sang má ngo a purut iatung, a mákái kálámul erei ki ák tinang i bál mai mák lala mámnai. ");
INSERT INTO sgz_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Má ngorer ák han uri narsán mák urai wel má wain uri tan manu káián kálámul er má a duri mul. Má namur ák durki kálámul er urami iátin kán ololas má a tangnai mai uri kesi rumán asir, má a ololoh on iatung. ");
INSERT INTO sgz_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","A be kábungbung má, ki kakun Samaria er a long pasi aru i pirán tabal tili kán rat ák tari singin kálámul a kátlán i rumán asir er mák para talsai singin ngoro minái, ‘Una ololoh on be á kálámul minái. Má inak han be ki inang kaleng mul. Má ngo ukte omlawai kam te táit ur on, ki ina keles kalengnai ur singim.’” ");
INSERT INTO sgz_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ái Iesu a arahi kán worwor ki ák gáltai tám mánán er ngoromin, “Tili atul á kálámul erei, u hol on ngo ái sinih i ditul a turán i kálámul er di ubi i tan tám siksikip?” ");
INSERT INTO sgz_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Má tám mánán uri nagogon er a kos Iesu ngo, “Ái koner a mámnai má a tángni.” Má ngorer ái Iesu a parai singin ngo, “Áá, a támin á erei. Má una han má unák longoi ngorer sár mul á iáu.” ");
INSERT INTO sgz_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ngorer mái Iesu má kán kalilik án aratintin di aptur pas má di han i kandi inan sang, má ngorer di purut i kesi malar. Má kesi wák tili malar er ngisán ái Marta a árár pas di má a long pas di uri kán rum. ");
INSERT INTO sgz_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Kesi tuán lik ái Marta, ngisán ái Maria, a aptur mák han sukis i narsán ái Konom má a longrai kán aratintin. ");
INSERT INTO sgz_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mái sár ái Marta a solatabir mai marán talar kán tu longoi, má ngorer a han narsán ái Konom má a parai singin ngo, “Konom, kápute hol i iau má, ngorer ái tuang lik ákte aptur alar iau má iau masik má minái, kak tu talar mai longoi namnam. Káp una te dos palai ur mainái suri nák tangan iau be?” ");
INSERT INTO sgz_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mái sár ái Konom a parai singin ngo, “Marta, iáu lala konngek suri marán talar kam tu longoi be. ");
INSERT INTO sgz_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tukesi táit sár u sáhár suri. Ái Maria ákte ilwa pasi lain táit a kuluk á minái, má kápte kes na kip pasi singin.” ");
INSERT INTO sgz_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kesi bung mul ái Iesu a sung i kesi pokon. Má ngo a rah i kán sung, io kán kesi kalik án aratintin a purut narsán mák parai singin ngo, “Konom, a kuluk be ngo una atintin gim suri sung ngorer ái Ioanes Tám Arsiu a atintini kán kalilik án aratintin ngoi.” ");
INSERT INTO sgz_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Mái Iesu a parai si di ngo, “Ngoro minái á worwor gama utngi i pákánbung ngo gama sung. Káláu, Kák gim, gim nem ngo matananu no da para aposoi ngo ngisam a pilpil má dák rumrum on. Má gim sung ngo lolsit kaiam imi bát na sangar i hut main i naul bim. ");
INSERT INTO sgz_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Una tabar gim mai ángim balbal i bosbos bung no. ");
INSERT INTO sgz_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Má una hol palai kángim tan sápkin tatalen ngorer gim lu hol palai tan sápkin di lu longoi uri narsá gim. Má una áir kalar gim gima káp pur i pákánbung án artohtoh.” ");
INSERT INTO sgz_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Má ngorer ái Iesu a parai singin kán kalilik án aratintin ngoromin, “Kesá turam a hut til tepák i katbán tihlo iatung i kam rum. Má á iáu sang káp am te suri támri, ki uk han ur singin kesá turam bul uk sungi sur te balbal má uk parai ngoromin, ‘Turang, una tabar iau be mam te na tul i tigán balbal ");
INSERT INTO sgz_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","káplabin kesi turang ákte hut tili kán inan má káp ak te suri ina támri mai.’ ");
INSERT INTO sgz_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ngo iáu sungi ngorer, ki na kos iáu ngoromin, ‘Koion á ororok. Ákte batbat má mátán sál, má á iau mai rang natung gimáte boptin. Káp ina te tabar iáu á inái.’ ");
INSERT INTO sgz_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Iau parai singim, páksiai ngo a lain turam, káp sang na te aptur má nák tangan iáu. Mái sár ngo una tungai sungi sang, ki erár nák aptur má nák tángni kam sáhár. ");
INSERT INTO sgz_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Iau parai si gam, gama sung Káláu suri táit gam sáhár suri, má na tari si gam. Gama ser suri táit gam sáhár suri, má gama ser pasi. Má ngo gama pinpidir i mátán sál, ái Káláu na pasbat pas gam má nák tangan gam. ");
INSERT INTO sgz_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kabin ái rung di sung, da kebeptai; mái koner a ser, na ser pasi; mái koner a pinpidir, ái Káláu na pasbat i mátán sál pasi. ");
INSERT INTO sgz_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Suri aratámán mul, ngo natum na sung iáu suri isu, káp una te tabar natum mai kanih, kápte sang. Una támri mai isu sang. ");
INSERT INTO sgz_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Má ngo natum na sung iáu suri pasin kok, ngádáh? Káp una te támri mai mákál. ");
INSERT INTO sgz_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Á gam tan sápkin kálámul, mái sár gam mánán suri támri rang nat gam mai lain táit. Mái Kák gam imi bát a lala sorliu sang i kán mánán suri artabar, má ngorer ák lu tari Tanián a Pilpil si rung erei di sungi.” ");
INSERT INTO sgz_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ái Iesu a banai kesi kálámul sápkin tanián káp a tini wor a kis on, má ngorer kálámul er kápate lu worwor mul. Ái Iesu a mákái kálámul erei má namur a tipar palai sápkin tanián alari. Má ngo sápkin tanián ákte kaplah alari, kálámul erei a worwor kaleng. Má matananu di mákái ngorer má dik pángáng suri. ");
INSERT INTO sgz_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mái sár te tili di di parai ngo, “Ái Belsebul sár á erei, kabisit káián tan sápkin tanián, má ái a tari rakrakai singin má ngorer ák lu tipar palai tan sápkin tanián.” ");
INSERT INTO sgz_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Io, te bul á kálámul di nem suri da toh Iesu, má ngorer di parai singin ngo, “Una long tekesi akiláng tilami bát suri inngasi ngo rakrakai káián ái Káláu a kis i narsam.” ");
INSERT INTO sgz_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mái sár ái Iesu sang a mánán tangrai kándi holhol má ák parai ur si di ngoromin, “Ngo tekesi mát a mon i tan boh i di má namur da arup arliu i di sang, ngádáh da ngoi? Mát erei na sák má matananu kápnate kes kaleng i di mul. Má ngo tekesi aratámán da togor má dáng kis arsagil, kápnate mon i kandi rakrakai suri da pam talumna di, má na sák sang á kandi kiskis án aratámán. ");
INSERT INTO sgz_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","“Ái Satan mul a ngorer á kán lolsit. Ngo ái Satan na arup kaleng mai má nák ru on, kápnate tur rakrakai á kán him, má kán him na mat sár. Má gamá parai uri iau ngo iau tipri tan sápkin tanián mai rakrakai ái Belsebul a tari singing. ");
INSERT INTO sgz_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Má ngo iau dos palai sápkin tanián mai rakrakai si Belsebul, ki ngádáh? Ái rung tili gam er di lu tipar palai sápkin tanián, di lu longoi mai rakrakai si Belsebul mul? Kápte sang. Má ngorer di sang di inngasi kamu angagur. ");
INSERT INTO sgz_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mái sár ngo iau tipar palai sápkin tanián mai rakrakai er ái Káláu a tari singing, ki a támin muswan ngo lolsit si Káláu ákte tapam hut mái Káláu ákte turpasi kátlán i te tili gam erei. ");
INSERT INTO sgz_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ngo kálámul rakrakai a leget i kán tan papam suri ololoh i kán rum, kán tan táit a kis kuluk sár. ");
INSERT INTO sgz_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mái sár ngo kesi kálámul bul a lala rakrakai a hut má a ubi kálámul erei, koner a rakrakai sorliu a long sarai kán tan táit, má namur a long pasi tan papam káián ái kálámul er a ruruna on mák han mai, má namur a tam purwai tan táit er ur singin rang táir. ");
INSERT INTO sgz_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ái koner kápate táring sang, ái a kurtara mam iau. Mái koner kápate tangan iau suri iang talmi, ái a tam sarai matananu alar iau.” ");
INSERT INTO sgz_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Mái Iesu a sopasun i kán aratintin mák parai ngoromin, “I pákánbung ngo sápkin tanián a so alari kálámul, a han tangrai pokon mau mák ser sur te nián suri na mon ái. Má ngo kápate ser pas tekesi nián iatung i pokon erei, ki namur má a para kalengnai singin sang ngo, ‘Auh, wa ina kaleng sang má mul uri niang iakte táu alari.’ ");
INSERT INTO sgz_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Io, namur a kaleng i sápkin tanián erei uri torahin nián, má a mákái ngo ákte pilpil, má tan táit iatung i nián ákte kuluk pagas. ");
INSERT INTO sgz_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Io, má sápkin tanián er a mákái ngorer mák han pas mák lam pasi ahit mul i sápkin tanián di lala sápkin sorliwi sang, má di no di kaleng má ding kusak uri kálámul er má dik mon iatung on. Má kálámul erei tungu a kálik sák mai kes sár i sápkin tanián, onin ák lala sák taladeng sang.” ");
INSERT INTO sgz_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Io, pákánbung a be parai ngorer ái Iesu, ki kesi wák a bin tilatung i katbán matananu má a parai si Iesu ngo, “Wák er a káh iáu má a asus iáu uk pakta, wák er a kuluk pala!” ");
INSERT INTO sgz_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Mái Iesu a parai ngo, “A muswan, mái sár ái rung di longra pasi pinpidan káián ái Káláu má dik murmur on, di tuan kuluk pala taladeng sang!” ");
INSERT INTO sgz_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Má namur marán matananu di hut talum mul má di tur kaul Iesu, má a sopasun worwor narsá di má a parai ngoro minái, “Ngaul matananu onin di lala sápkin sang! Di gálta iau suri ina longoi tekesi akiláng suri dák mákái ngo ái Káláu a kis i narsang, mái sár kápte kesi akiláng ina longoi narsá di. Akiláng ákte kis má, má ái sár á akiláng a longoi ái Iona tám worwor tus. ");
INSERT INTO sgz_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ái Iona er tám worwor tus, ái á akiláng uri narsán matananu á Niniwe. Má ngorer Natun Kálámul bul na akiláng uri narsán ngaul matananu i bung onin. ");
INSERT INTO sgz_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Namur, i bungun nagogon sang, tasim tili mátán kihkih matalames na aptur kaleng má nák atiutiwi ngaul matananu onin, kápkabin hirá tasim erei ákte aptur alari kán malar tepák suri longrai tan lain arabitbit si Solomon. Má iau parai si gam ngo kálámul a pakta sorliu Solomon minái ákte hut má, má kápgamte alongra singin. ");
INSERT INTO sgz_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","I bungun nagogon mul, matananu til Niniwe da aptur kaleng má dák atiutiu gam, kápkabin di sang di hol kaleng palai kandi sápkin tatalen i pákánbung di longrai arbin si Iona. Má iau parai si gam ngo kálámul a pakta sorliu Iona minái ákte hut má, má kápgamte alongra singin.” ");
INSERT INTO sgz_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Mái Iesu a sopasun mul i kán aratintin mák parai ngoromin, “Kápte kesi kálámul a lu oskoi lam mák lu bor kári talsán mai kas ngo na oboi lam i lalin rum. Kápte. Na akai lam i nián sang suri rung da kusak da mákái talas erei. ");
INSERT INTO sgz_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Matam ái a ngoro lam uri páplun i iáu. Pákánbung ngo matam a talas, bos kalkuir no i iáu a talas. Mái sár ngo pákánbung matam a sák, bos kalkuir no i iáu a kuron. ");
INSERT INTO sgz_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Koion una agur iáu sang. U hol on ngo talas er i iáu a támin. Mái sár ngo kápte, má ngo talas er i iáu a kuron, ki á iáu una káng mai kuron mul. Una ololoh kuluk! ");
INSERT INTO sgz_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Má ngo bos kalkuir no i iáu a talas, má kápte mudán kuron on, ki una atur páptai lain talas ngorer i lam a talsa iáu i talsán.” ");
INSERT INTO sgz_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","I pákánbung a arahi worwor ái Iesu, io kesi Parisaio a el pas Iesu suri diara namnam tiklik, má ngorer ái Iesu a han má a kusak uri kán rum i Parisaio má a tu sukis sár suri namnam. ");
INSERT INTO sgz_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Io, ngo kándi tu namnam ngorer, má Parisaio er a mákái ngorer ngo ái Iesu a namnam má kápate ililim táil, má ngorer a sodar suri. ");
INSERT INTO sgz_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mái Konom a mánán i kán hol ngo a sodar á Parisaio erei, má ngorer a parai singin ngoromin, “Á gam á tan Parisaio, gam ngorer i rung di lu gorsai tan kinleh má kuro tili karpala sár, má dik lu páksiai dur imi polgon. Gam lu long arwat pasi bos tatalen án arapilpil tili karpala suri gama mák nokwan uri mátán matananu, mái sár imi bál gam a káng mai tan sápkin holhol má tatalen án kiu. ");
INSERT INTO sgz_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ái Káláu a longoi kápán páplun kálámul má a longoi nárum i kálámul mul. Gam tilik ngul kabin gam hol sár i apilpilái kápán páplun, má kápgamte hol suri nárum i gam er a lala dur mai sápkin. ");
INSERT INTO sgz_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Gam lu artabar uri narsán tan maris kabin a parai á nagogon ngo gama longoi ngorer. Ái sár, a kuluk ngo gama artabar uri narsá di mai pilpil án bál gam. Ngo a pilpil i bál gam ngorer, ki gama mámna muswan i di má gama nem suri tangan di mul. Ngo gama mur i tatalen ngorer, ki a inngasi ngo gamáte pilpil no i mátán ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Á gam á tan Parisaio gamáte sák kabin gam lu mur arwat pasi tan gengen táit no tili nagogon. Mái sár tan támin táit muswan, kápgamte lu mur on. Ngorer gam lu tabar Káláu mai risán i kamu tan lobo má kamu tan mánáp mul, mái sár gam matai suri mur i a nokwan má suri armámna uri narsán ái Káláu. A kuluk gamáte mur arwat pasi tan gengen táit i nagogon, má ngádáh á tan támin táit erei? Koion gama hol pala tekes tili di, gama mur i tan támin táit mul. ");
INSERT INTO sgz_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Á gam á tan Parisaio gamáte sák! Gam lu nem suri sukis i tan kiskis táil i rumán lotu, má suri tan kálámul da lu árár pas gam i pokon án sirsira. ");
INSERT INTO sgz_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Gamáte sák sang á gam! Gam ngorer i tan tarang án minat kápte akiláng on, má ngorer tan kálámul kápdite mákái. Má namur di láklák i iátin tarang erei, má minat er a long adurwán i di. Gam ngorer kabin matananu kápdite mák ilam gam ngo gam káng mai sápkin, pasi gamá ákwas di mai kamu tan sápkin sang.” ");
INSERT INTO sgz_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Má kesi tám mánán uri nagogon a longrai worwor ái Iesu a parai uri tan Parisaio, má ngorer a parai si Iesu ngo, “Tám Aratintin, pákánbung u parai ngorer uri di, wa u para bengta gim mul.” ");
INSERT INTO sgz_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Mái Iesu a kosoi ngo, “Má gam mul á tan tám mánán uri nagogon, gamáte sák! Gam lu poklah pasi te nagogon mul uri bontai er ákte kis, má gamá lu oboi uri káil matananu má ák lala taun di. Mái sár kápte gam kálik soai lim gam ur on suri tangan di mai kándi kipkip. ");
INSERT INTO sgz_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Gamáte sák sang! Gam lu angagur mai lain merei tárgun bos tám worwor tus til hirá, ái rung erei sang rang támin i gam di up bing di. ");
INSERT INTO sgz_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Má ngorer gam apos tari ngo gam sormángát suri tatalen rang támin i gam di longoi mai tan tám worwor tus er. Áá, rang támin i gam di up bing di, má gam onin gam lu longoi boh lalain tarang uri di. ");
INSERT INTO sgz_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Má tatalen erei, ái á kápkabin ái Káláu Tám Mánán a parai ngo, ‘Ina tarwa palai tan tám worwor tus má tan apostolo narsá di á matananu, má da up bing te, má te tili di da arangrangas i di sár.’ ");
INSERT INTO sgz_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Má ngorer ái Káláu na oboi i káil i gam á ngaul matananu onin suri dárán tan tám worwor tus er di up bing di, tangkabin tili akaksim ");
INSERT INTO sgz_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ngorer i Abel er a mulán hiru, mák han pang i Sakaria, koner di up bingi iatung i arliwán nián osmapak má rumán osmapak. Áá, a támin ngo ái Káláu na oboi i káil i gam á ngaul matananu onin suri dár di. ");
INSERT INTO sgz_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Gamáte sák sang á gam á tan tám mánán uri nagogon, kabin gamáte top on á ki suri pasbat i mátán sál suri mánán i Káláu. Mái sár á gam sang kápgamte kusak on suri gama mánán i Káláu, io má gamá tur kalar di mul ái rung di kákir muswan suri da kusak ur on.” ");
INSERT INTO sgz_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ái Iesu a be parai ngorer, má namur a aptur alari rum erei, má tan tám mánán uri nagogon má boh Parisaio di bálsák mam Iesu má dik lu mur on má dik lala gáltai suri marán táit. ");
INSERT INTO sgz_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Di longoi ngorer suri da pidir pas Iesu suri te worwor a sák na parai. ");
INSERT INTO sgz_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Má marán i arip á kálámul di hau talum, má ngorer di arsiut i di sang. Má namur ái Iesu a mulán turpasi worwor ur singin kán kalilik án aratintin ngo, “Gama ololoh na káp porta i gam i tatalen káián tan Parisaio di á tan tám tuar. Kándi tatalen erei na káp sinim i gam ngorer i yis a sinim i palawa. ");
INSERT INTO sgz_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Táit erei di bohoi, da sakra sarai. Má boh táit no a punpunam, da tur i talas. ");
INSERT INTO sgz_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Má ngorer táit u parai i kuron, da longrai i talas. Má táit mul u arasás mai uri talngán kálámul i polgon rum, da bin mai i lol malar. ");
INSERT INTO sgz_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Rang buhang, a muswan á minái iau parai si gam. Koion gama bulat sur di ái rung da up bingi kápán páplun i gam má namur kápdate longoi tekesi táit mul. ");
INSERT INTO sgz_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mái sár ina parai si gam suri ái sinih gama bulat on. Gama bulat i Káláu, koner a mon i kán rakrakai suri up bingi kápán páplun má sápkai kálámul uri pokon án hiru áklis. Ái sang á kálámul gama bulat on. ");
INSERT INTO sgz_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Di sirai alim i unsir artálár mai aru i gengen pirán tabal sár, be? Ái sár ái Káláu kápate ráu pala tekes tili di á tan unsir erei. ");
INSERT INTO sgz_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Má gam, ái Káláu a lala hol pas gam. Wa ákte wás noi á tan towon nih gam er i lul gam. Io, ngorer koion gama bulat kabin gam no sang gam lala támin táit i mátán táil ái Káláu alari tan unsir. ");
INSERT INTO sgz_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“A muswan á minái iau parai si gam. Ái koner a para talsa iau narsán matananu ngo ái á kaiak, Natun Kálámul na longoi mul ngorer, na para talsai kálámul er i mátán táil i boh angelo si Káláu ngo ái á káián. ");
INSERT INTO sgz_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mái sár ái koner a arkawar pala iau i mátán matananu ngo ái kápte ngo táring, Natun Kálámul mul na pua palai i mátán táil i boh angelo si Káláu. ");
INSERT INTO sgz_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Má ngo tekesá kálámul a ot bilingnai Natun Kálámul, arwat ái Káláu na hol palai sár á erei. Mái sár ái koner a ot bilingnai Tanián a Pilpil, ái Káláu kápnate hol palai. ");
INSERT INTO sgz_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Má ngo i pákánbung di top i gam má di talka gam uri rumán lotu ngo uri mátán táil i tan pakpakta suri tur i nagogon, koion gama konngek suri ngádáh gama kokos ngoi ngo worwor ngádáh gama parai. ");
INSERT INTO sgz_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Pákánbung erei sang, Tanián a Pilpil na hut má na apos tari worwor suri gama parai.” ");
INSERT INTO sgz_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Má namur kesi kálámul iatung i katbán matananu a parai si Iesu ngo, “Tám Aratintin, una parai be si tuang suri na purwai i giur á minsik si kák giur.” ");
INSERT INTO sgz_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mái Iesu a kosoi kálámul erei ngo, “Be tuang, wa sinih sang a tari á him singing suri tam purwai minsik si kák gaur i gaur tuán? Káp kak te talar á iau suri longoi ngorer.” ");
INSERT INTO sgz_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Má ngorer a parai mul si di no ái Iesu ngoromin, “Gama ololoh suri koion gama kon suri marán táit ur kamu, kabin minsik kápte ngo a kápkabin á liu muswan.” ");
INSERT INTO sgz_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ngorer má a parai kesi worwor artálár narsán i di ái Iesu ngoromin, “Kesi konom a mon i kán bim, má iatung i kán num ákte lala marán i namnam on. ");
INSERT INTO sgz_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Má konom erei a hol on ami bál ngoromin, ‘Tan rum minái a gengen, kápate arwat ngo ina dung noi tan balbal on. Má dánih má ina longoi? ");
INSERT INTO sgz_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Iakte hol on má, ina taráp palai á tan rum minái a gengen má inak long te rum a pakta, má ngorer inak dung noi tan balbal má kak minsik mul on. ");
INSERT INTO sgz_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Má namur inak parai singing sang ngo, “Una kuluk pala sang á iáu, ukte otoi má tan lain táit arwat mai marán i bet. Una aunges má unák namnam má, má unák ngin, má unák laes má.” ’ ");
INSERT INTO sgz_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Mái sár ái Káláu a parai singin konom erei ngo, ‘Iáu tilik ngul! Onin i libung ina long pasi kam liu alar iáu má unák mat. Io, mái sinih má na otoi á tan táit er ukte obop páksi ur kaiam?’” ");
INSERT INTO sgz_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Mái Iesu a arahi kán worwor ngoromin, “Na ngorer sár uri narsá di ái rung di ungi marán minsik uri kandi konom, mái sár kápdite konom i mátán táil ái Káláu.” ");
INSERT INTO sgz_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Mái Iesu a parai ngoromin narsán kán kalilik án aratintin, “Má ngorer ina parai si gam, koion gama lala hol suri namnam er a top i kamu liu ngo suri mermer uri merei kápán páplun i gam. ");
INSERT INTO sgz_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nárum i gam, ái a lala támin táit suri namnam er a sol uri bál gam. Má ninsin i gam a lala támin táit suri mermer er gam oboi i kápán páplun i gam. ");
INSERT INTO sgz_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Gama hol pasi tan wokwok kápte di lu himhimna ngo da obop talmi balbal ákte matuk, má káp kándi te rumán balbal mul, mái Káláu a tabar di sár. Má gam sang gam tuan kuluk pala i mátán ái Káláu alari tan man. ");
INSERT INTO sgz_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Be, ngo gama lala konngek suri kamu liu, ngádáh? A arwat suri gama bontai kamu liu mam te bet mul uramunang? Auh, kápate arwat. ");
INSERT INTO sgz_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Má ngo kápgamte long arwat pasi gengen táit ngorer, ki suri dáh gam lu konngek suri tan lite táit bul? Auh, koion. ");
INSERT INTO sgz_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Ngorer ki gama hol pasi aun purpur di utngi ngo senal, ngádáh di liu ngoi. Kápdite himhimna ngo long te lusán i di. Mái sár a muswan á minái iau parai si gam. Tan purpur ngorer i aun senal, sián a tuan kuluk sorliu taladeng alari mermer si Solomon er kabisit. ");
INSERT INTO sgz_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Git mánán ngo ái Káláu a ololoh i tan purpur er a kopkom onin, má latiu a bokoh sár ngorer di tár sarai má dik osoi i kámnah. Tan tu táit bia sár, mái sár ái Káláu a ololoh i di mai lain mermer. Má ngo ái Káláu a ololoh i tan táit bia ngorer, ngádáh, ái Káláu kápate ololoh i git mul? Suri dánih a gengen á kamu ruruna? Ái Káláu a ololoh i git sár mul mai lusán i git. ");
INSERT INTO sgz_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Má ngorer koion gama atri kamu hol suri dánih gama ani má ngo dánih gama nginmi. Koion na konngek i kamu hol. ");
INSERT INTO sgz_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Áá, koion gama ngorer i di ái rung tili risán, ái rung er kápdite ruruna i Káláu má dik lala konngek suri ser pasi á tan táit erei. Mái sár á gam, a mon i Kák gam a mánán á tan táit gam sáhár suri. ");
INSERT INTO sgz_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Io, ngorer gama atri kamu hol i lolsit si Káláu, má ái Káláu na tapálsi limán ur si gam má na long arwat i kamu tan sáhár.” ");
INSERT INTO sgz_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Mái Iesu a sopasun i kán aratintin uri narsán kán kalilik mák parai ngoromin, “Má gam á kak tan kalilik erei koion gama mátut! Kápkabin ái Káláu Kák gam ákte agasgas pas gam suri gama kusak i lolsit káián má gamáng kátlán. ");
INSERT INTO sgz_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Má erei gama sira palai kamu minsik má gama támri tan maris mai pirán tabal. Má ngorer kamu omobop ami bát na pakta, má na káng pagas on á matngan kas erei káp a tini morot. Má on á pokon erei, kápate arwat suri tám siksikip na kusak má na sipki, má koropos mul kápnate susi. ");
INSERT INTO sgz_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kabin ngo kam omobop na kis i pokon erei, ki kam lala nemnem má balam na kis ái mul.” ");
INSERT INTO sgz_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Mái Iesu a parai mul si di ngo, “Gama kabat dik i kamu sulu má gama oskoi kamu lam nák talas pagas, má gamák eran suri matngan dánih na purut besang. ");
INSERT INTO sgz_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Gama ngorer i tan toptop di monmon nanai kandi pakpakta suri na kaleng. Pákánbung a kaleng tili long namnam án arakila má ngo a pinpidir, ái rung er dikte eran nanai ngorer má di sangar i pasbat pasi kandi pakpakta. ");
INSERT INTO sgz_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","38","A muswan á minái iau parai si gam. Da tuan kuluk pala sang á tan tám arardos erei ngorer kandi pakpakta a hut narsá di má di pán pagas. Da tuan kuluk pala ái rung erei kandi pakpakta a hut narsá di i katbán tihlo ngo ngorer páput i arasa, má di pán pagas má eran nanai. Má pakpakta erei na mákái ngorer má na kápti kán sulu má na sokoi namnam ur ándi má na tabar di mai. ");
INSERT INTO sgz_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Gama mánán ngoromin ngo kálámul a mon i kán rum má ákte mánán i pákánbung na hut on i tám siksikip, io arwat suri na eran monai tám siksikip, má ngorer kán rum kápnate sák. ");
INSERT INTO sgz_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Io, ngorer gam mul gama eran suri Natun Kálámul, kabin na hut sang i pákánbung ngo kápgamte hol on ngo na hut on.” ");
INSERT INTO sgz_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ngorer mái Petero a parai si Iesu ngo, “Be, Konom, wa u parai á worwor artálár erei uri gim masik ngo uri narsán tan kálámul no?” ");
INSERT INTO sgz_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mái Konom a kosoi ngo, “Pákánbung kálámul pakta a eran suri na han uri lite malar, a ser suri kán tekesi tám arardos na kátlán i kán rum. Má matngan kálámul ngádáh a nem on ái pakpakta erei? A nem i kálámul a tám mánán má a lu muswan suri ololoh i kán rum turán rung di lu kis on, má suri tabar di mai namnam. ");
INSERT INTO sgz_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Namur a kaleng i pakpakta erei má a mákái ngo kán tám arardos erei a long arwat pasi tan táit no kán konom ákte parai singin. Má ngorer a tuan kuluk pala á tám arardos er. ");
INSERT INTO sgz_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","A muswan iau parai si gam. Pakpakta erei na mákái ngorer, má nák tari singin kán tám arardos á bos táit no suri kátlán. ");
INSERT INTO sgz_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mái sár ngo tám arardos erei, ngo kápate muswan uri narsán kán konom, ngorer na hol pasi sápkin ami bál má nák parai singin sang ngoromin, ‘Kak pakpakta ákte han tepák má kápnate kaleng melek.’ Má ngorer na turpasi sák mai tan toptop, na ubi tan káláu má boh wák mul, má na lala namnam má nák lala ngin i dan rakrakai má ngorer na lala bau. ");
INSERT INTO sgz_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ngorer tekesi bung má pakpakta erei na kaleng. Má i pákánbung na kaleng on, kán tám arardos er kápate mánán on má kápnate eran monai. Ngorer má pakpakta na mákái ngorer má nák mos on, má na lala ubi má na oboi suri na áslai rangrangas tiklik mai boh tám abulbul. ");
INSERT INTO sgz_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Io, tám arardos erei a mánán sár i táit a nem on ái kán pakpakta suri na longoi, mái sár kápate eran má kápte a longoi mul, má ngorer na lala ubi ái kán pakpakta. ");
INSERT INTO sgz_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mái sár ngo tekesi tám arardos kápte a mánán i táit a nem i kán pakpakta suri na longoi, mák tu longoi sár i táit kápate kuluk, ái kápnate lala ubi kabin kápte a talas suri táit na longoi. Ái koner ái Káláu a tari a pakta singin, a kuluk ngo na kosoi sang mai a pakta. Mái koner a kipi marán, na kosoi mai marán mul.” ");
INSERT INTO sgz_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Mái Iesu a sopasun i kán worwor mák parai ngoromin, “Iakte tapam hut ur main i naul bim mai kámnah án nagogon si Káláu, má kak lala nemnem sang ngo ákte turpasi inan má, mái sár kápte be. ");
INSERT INTO sgz_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","A mon á rangrangas ina áslai besang, má iau sák sár suri ina arahi má na bokoh alar iau. ");
INSERT INTO sgz_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Gam ngoi á gam ngo iau hut mai moloh ur main i naul bim suri na tukes i kamu hol, be? Kápte sang. Iau hut suri gama kis arsagil. ");
INSERT INTO sgz_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ngorer i aratámán dihat kis i kesá rum sár má namur na ru i di. ");
INSERT INTO sgz_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ngorer ái kákán na tur kaplah alar natun, mái natun na mos i kákán. Na ngorer mul ái mámán na tur kaplah alar natun tahlik, mái natun tahlik na mos i mámán. Wák na mos mai ián lik, má ngorer nák ru i diar.” ");
INSERT INTO sgz_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ngorer mái Iesu a parai singin matananu mul ngoromin, “Ngo gam lu mákái kumlán mehmeh iamudi mátán kihkih i lábur, ki gama lu parai má ngo na hus á ráin á erei, má namur a hus sang á ráin. ");
INSERT INTO sgz_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Má pákánbung gam áslai kihkih a husai tili matalames, ki gama lu parai má ngo na taul nas má erei, ki namur ák taul nas sang. ");
INSERT INTO sgz_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ngádáh, gam mánán i mák ilmi pákánbung ngorer, mái sár kápgamte arwat suri mák ilmi tan akiláng uri pákánbung onin? Wa, gam bos tám tuar!” ");
INSERT INTO sgz_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Mái Iesu a sopasun i kán aratintin narsán matananu mák parai ngoromin, “Má ngádáh, kápgamte arwat suri ololoh kuluk i gam má gamák ilwa pasi sál a nokwan suri gama murmur on? ");
INSERT INTO sgz_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ngo gaur i tekesi kálámul gaur mos kabin ukte long sáksáknai kán tekesi táit má ngorer a nem i obop iáu i nagogon, mulán táit una han uri narsán suri gaura anokwai. Suri ngorer na mák talka iáu uri narsán tám nagogon, kabin ngo tám nagogon erei ngo na longrai kamur worwor má namur na tari rangrangas singim, má ngorer tan kuir sulu da obop iáu i batbat kalar. ");
INSERT INTO sgz_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Má iau parai singim, una kis pagas i batbat kalar pang i bung una hul pala noi tinákum erei i iáu.” ");
INSERT INTO sgz_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","I pákánbung erei sang, matananu di hau talum besang i narsán ái Iesu, má te kálámul di han narsán ái Iesu má di bitái suri te kakun Galiláiá di mat. I bung di osmapak on uri narsán ái Káláu, tan tám arup si Pilato di up bing di má dár di a argemwai turán kandi osmapak. ");
INSERT INTO sgz_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Mái Iesu a kosoi kandi worwor mai argátna ngoromin, “Dánih gam hol on á gam? Kol gam hol on ngo di hiru ngorer kápkabin ngo di lala sápkin kálámul sang alari te kakun Galiláiá? ");
INSERT INTO sgz_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Wa kápte sang! A muswan á minái iau parai si gam ngo gama hol kaleng. Mái sár ngo káp gama te hol kaleng alari kamu sápkin, wa gam no gama hiru ngorer ái rung erei má gamák mat. ");
INSERT INTO sgz_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Mái rung er a pur uri di i rum á Siloam má dik mat, di tara sángul mai awal á kálámul, ngádáh da ngoi? Kol gam hol on ngo a aposoi kandi sápkin tatalen má ngo di sápkin kálámul sang alari tan kálámul di kis á Ierusalem? ");
INSERT INTO sgz_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Wa kápte sang! A muswan á minái iau parai si gam ngo gama hol kaleng. Mái sár ngo káp gama te hol kaleng alari kamu sápkin tatalen, wa gam no gama hiru ngorer ái rung erei má gamák mat.” ");
INSERT INTO sgz_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Mái Iesu a parai worwor artálár minái narsá di á matananu ngoromin, “Kesi kálámul a mon i kán num, má kesi aun tawan káián a tur i lolon kán num erei. Má kálámul er a lu balbal han suri laumái tawan erei suri na lu lus te wán, mái sár kápte te wán, káp a tini u. ");
INSERT INTO sgz_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Má ngorer a parai singin kán tám himhimna ngo, ‘Mákái! Ákte artálár mai atul á bet iau lu balbal han ur mainái suri laumái tawan min sur te wán, má kápte iau lu bana tekesi wán be. Kápte a kuluk suri a tur bia ngorer iatung mák akángái pokon mul. Una tár palai má suri lite kubau na tur iatung.’ ");
INSERT INTO sgz_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mái sár ái tám himhimna a kosoi má parai singin ngo, ‘Káksiai be nák lu tur on á bet minái, má inak ili bim i káplabin má kipi teken bulumakau suri oboi on mul. ");
INSERT INTO sgz_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Má i bet namur, ngo na oboi marán wán má nák lur kuluk, ki na lu tur sang. Má ngo kápte, ki erár má giták tár palai.’” ");
INSERT INTO sgz_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Mái Iesu a aratintin mul i kesá rumán lotu i bungán aunges. ");
INSERT INTO sgz_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Má kesá wák iatung a kusak ur on i sápkin tanián má kán tunga sasam mai ákte artálár mai sángul mai awal á bet. Ngorer kápate arwat suri na takotsai kápán páplun, má a lu luklukus áklis sang. ");
INSERT INTO sgz_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Má ngo ái Iesu a mákái wák er, a bin mák parai singin ngo, “Awái, wákán, ukte sengsegeng má alari kam sasam.” ");
INSERT INTO sgz_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","A be parai ngorer ái Iesu, io a han má a oboi limán i wák er. Má káp melek sár mul wák er a sámtur má a takotsai kápán páplun. Wák er a mákái ngorer má a para agas Káláu. ");
INSERT INTO sgz_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ngorer má kálámul a pakpakta i rumán lotu erei a mák Iesu a aliu pasi wák er i bungán aunges, má ngorer a mos má a wor rakrakai má a parai narsán matananu ngo, “Nagogon a parai ngo awon á bung suri gita him on, má ngorer gama lákám suri da aliu gam i tan bung erei. Mái sár koion sang á araliu on á bungán aunges!” ");
INSERT INTO sgz_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Má ngorer ái Konom a kosoi pakpakta mai ngoromin, “Gam bos tám tuar! Ngo kes tili gam a mon i kán ololas, ngádáh, káp a tini támri on á bungán aunges? Kápte! Na han má nák aso palai, má ngorer na támri má na angimi anang i mátán dan. ");
INSERT INTO sgz_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Má wák minái sumlahin sár ái Abaram, mái Satan ákte kápti mai sasam arwat mai sángul mai awal á bet. Ngádáh, kápate nokwan suri na sengsegeng alari kán sasam min on á bungán aunges?” ");
INSERT INTO sgz_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Má ngorer boh kurtara iatung di longrai ngorer má di lala rumrum sang suri a kos artálár pas di ái Iesu. Mái sár matananu iatung i rumán lotu di lala gasgas suri tan lain táit ái Iesu ákte longoi. ");
INSERT INTO sgz_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Má namur ái Iesu a parai ngoromin, “Ina toh arwat i lolsit si Káláu mai dánih? Má ngádáh á pinpidan artálár ina parai ur on? ");
INSERT INTO sgz_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kán lolsit ái Káláu a ngorer i kotlin kali ngo kesi kálámul a top pasi mák soi i kán num. Má namur a kopkom i kotlin kali erei má a lala aun kubau sang. Má namur tan man di roh kis on má di longoi páhiun i di iatung i boh rákán má.” ");
INSERT INTO sgz_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ngorer mái Iesu a bali gátna mul ngo, “Lolsit káián ái Káláu ina toh arwat on mai dánih? ");
INSERT INTO sgz_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kán lolsit ái Káláu a ngorer i yis. A long pasi yis i wák mák argemwai turán palawa er i lus, má ngorer palawa no iatung i lus a sut pakta.” ");
INSERT INTO sgz_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Mái Iesu a aratintin hanhan tangrai tan bimán rum má tan malar er i kán inan urami Ierusalem. ");
INSERT INTO sgz_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Má ngorer te kálámul di gáltai ngo, “Be Konom, kápnate marán gut á kálámul erei da kusak uri lolsit si Káláu, be?” Mái Iesu a kos di mák parai ngoromin, ");
INSERT INTO sgz_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“A muswan á minái iau parai si gam, mátsálán lolsit si Káláu a kidut sár. Gama lala tohoi suri kusak i mátán sál erei, kabin marán da nem suri kusak on, mái sár kápdate long artálár on. ");
INSERT INTO sgz_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Má kálámul er kán rum erei na salaptur tilatung a sukis pagas ái má nák batbat i mátán sál. I pákánbung erei gama tu sámtur iatung i karpala má gama pinpidir i mátán sál má gama bin ngo, ‘Konom, pasbat pas gim be á iáu!’ Má ngorer na kos gam má nák parai ngo, ‘Wa káp iau te mánán i gam! Aiá gam han til ái?’ ");
INSERT INTO sgz_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Má gama kos kalengnai á gam ngo, ‘Na, wa gim namnam má gimá ngin tiklik mam iáu sár, má u lu aratintin i kángim tan malar.’ ");
INSERT INTO sgz_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mái sár ái na parai si gam ngo, ‘Wa káp iau te mánán i gam! Aiá gam han til ái? Ngorer gama kaplah alar iau, gam no erei gam tan tám abulbul sang.’ ");
INSERT INTO sgz_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Má i pákánbung gam nem suri kusak uri lolsit si Káláu, da tur pala gam suri koion gama kusak. Mái sár gama mák Abaram má, mái Aisak mái Iakobo má tan tám worwor tus no iatung dikte kusak, má gam kápte. Má ngorer gama tang má gamák ararat ngis. ");
INSERT INTO sgz_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Má i pákánbung erei, rung tili risán tili ahat i mátán kihkih no da hut talum sang i lolsit si Káláu má da sukis i niá di keskeskes suri da namnam tiklik. ");
INSERT INTO sgz_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Má te di konom onin, da gengen iatung. Má te di gengen onin, namur da kálámul pakta.” ");
INSERT INTO sgz_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Má te Parisaio di hut narsán ái Iesu i án pákánbung erei sang má di parai singin ngo, “Ái Erodes kán tu ser sur iáu suri na up bing iáu, má ngorer una kelkel besang til mainái má una han uri te pokon tepák.” ");
INSERT INTO sgz_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Mái Iesu a parai singin tan Parisaio ngo, “Gama han má gamák parai kak worwor singin á wak erei tám angagur ngo onin má latiu ina lu longoi him án araliu má ina lu tipar palai sápkin tanián, má i átuil bung sang ina long arwat pasi kak him nák rah. ");
INSERT INTO sgz_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ngorer onin má latiu má iraru ina han sang i kak inan, kabin kápate artálár ngo tám worwor tus na hiru tepák, wa ami sang Ierusalem! ");
INSERT INTO sgz_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","U, keskam, tara Ierusalem! Ái Káláu ákte tarwai tan tám worwor tus káián ur si gam má gamá up bing di, má tan tám arbin mul gamá bás di mai hat. Marán pákán sang iau nem i gam á matananu til Ierusalem suri ina lu pam talum gam ngorer i kok a iang talmi rang natun uri lalin bábán, mái sár á gam kápgamte nem i iau. ");
INSERT INTO sgz_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","A muswan á minái iau parai si gam, kamu malar er gam lu kis ái, na mosrah no. Má á iau sang mul ina bokoh alar gam. Káp gama tini mák iau mul pang i bung ngo gama parai ngoromin ngo, ‘Ái Káláu na kuluk mam Koner a hut mai ngisán!’” ");
INSERT INTO sgz_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Kesi bungán aunges má, kesi Parisaio a pakpakta káián boh Parisaio a long pas Iesu má diar má han uri kán rum suri diara namnam. Má matananu iatung di mangwa Iesu ngo na longoi te táit má dák mákái. ");
INSERT INTO sgz_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Má kesi kálámul a sasam mai aru i limán má aru i keken a sut, má kán lala nemnem suri na asengsegeng on ái Iesu, má ngorer a han uri narsán. ");
INSERT INTO sgz_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Io, mái Iesu a mákái ngorer má a parai singin tan tám mánán uri nagogon má tan Parisaio ngoromin, “Bos nagogon kángit, di atintin git suri dánih gita longoi i bungán aunges. A sormángát i git suri gita araliu i bungán aunges, ngo kápte?” ");
INSERT INTO sgz_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Má tan kálámul di longrai ngorer, mái sár kápdite kosoi. Má ngorer a long pasi kálámul er ái Iesu, a oboi limán on má a asengsegeng on, mái Iesu a tarwa palai uri kán malar. ");
INSERT INTO sgz_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Namur ái Iesu a parai narsá di ngoromin, “Ngo kes tili gam a mon i natun má a pur i kalik er uri tinkas i bungán aunges, dánih na longoi á kákán kalik er? Káksiai ngo bungán aunges, na longoi te matngan sál suri na talka pasi tilatung i polgon tinkas. Má ngorer mul ngo kes tili gam a mon i kán ololas mák pur uri mátán dan i bungán aunges. Ngádáh, kápnate long pas te suk má nák talka pasi alari mátán dan erei?” ");
INSERT INTO sgz_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Mái sár di no iatung kápte di kosoi worwor si Iesu. ");
INSERT INTO sgz_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Mái Iesu a mákái boh asir er di han tiklik no suri namnam iatung i rum káián Parisaio er ngo di ilwa pasi tan lain kiskis káián tan kálámul pakta má di sukis on, má ngorer a parai worwor artálár min uri narsá di no. A parai ngoromin, ");
INSERT INTO sgz_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Pákánbung ngo tekesi kálámul a longoi namnam án akila ngorer má a sik pas iáu suri una han ur on, koion una sangar i kis on á lain kiskis. Na mák hut keleh i tekesá kálámul a pakta i gaur, ");
INSERT INTO sgz_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","má ngorer kálámul er a sik pas gaur no na long pala iáu alari lain kiskis erei má nák long pasi kálámul pakta nák aksimi iatung i lain kiskis er. Má ngorer una lala rumrum sang má una tu sukis má turán tan kálámul iatung namur. ");
INSERT INTO sgz_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Mái sár i pákánbung di long pas iáu, una han sukis iatung tangrai risán suri koner a long pas iáu na han bana iáu iatung má ngorer na parai singim ngo, ‘Wai, tuang, u tu kis sáksák erei á iáu! Lákám ur matung i lain kiskis.’ Má ngorer ái rung gam kis talum i namnam da mákái ngorer má dák rumrum i iáu ngo iáu kálámul pakta. ");
INSERT INTO sgz_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ái rung di apakta pas di sang, ái Káláu na agengen i di sár. Mái koner a agengen pasi sár, ái Káláu na apakta pasi sang.” ");
INSERT INTO sgz_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Mái Iesu a parai si koner a long pasi ngo, “I bung u leget i tilik long namnam, koion una long pasi rang turam ngo rang buham ngo tan konom. Ngo una longoi ngorer, ki da long pas iáu ái rung erei má da kosoi uri narsam á namnam ukte tabar di mai. ");
INSERT INTO sgz_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ngo una longoi lala namnam sang, una long pasi tan maris má tan rau mái rung a sák i kik di suri ani namnam er ukte eran on. ");
INSERT INTO sgz_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kápkabin namnam er kápdite arwat ngo da kosoi uri narsam ái rung erei, má ngorer una tuan kuluk pala. Má ngoromin mul ái Káláu na supan iáu suri i bung namur er tan tám nokwan dikte mat da liu kaleng mul on.” ");
INSERT INTO sgz_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Má kesi kálámul di kis talum no sár mam Iesu i namnam, a longrai worwor a parai ái Iesu mák gas i bál suri, má a parai singin ngo, “Mái rung erei di sukis suri namnam i lolsit káián ái Káláu da tuan kuluk pala!” ");
INSERT INTO sgz_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Má ngorer ái Iesu a parai singin kálámul erei ngo, “Kesi bung kesi konom a nem i longoi lala namnam. Má ngorer a eran i boh táit má a bitái marán kálámul suri. ");
INSERT INTO sgz_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Má ngo ákte eran no má i boh táit iatung, ngorer má konom er a parai singin kán tám arardos suri na han long pasi tan kálámul er ákte sik pas di. Má tám arardos er a han ngorer má a parai si di ngo, ‘Gama lákám má! Ákte eran má boh táit!’ ");
INSERT INTO sgz_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Mái sár di no keskeskes di balbal kalar di mai worwor ngoromin. Mulán kálámul a parai singin tám arardos er ngo, ‘Una parai singin ngoromin, “Káp ina te han má iau, kabin iakte huli kesá kuir bim, má ngorer ina han be suri mákái. Na hol pala iau sár.” ’ ");
INSERT INTO sgz_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Má kes bul á kálámul a parai singin tám arardos er ngo, ‘Una parai singin ngoromin, “Káp ina te han má iau, kabin iakte huli alim i bulumakau uri him, má ngorer ina han be suri tingtinglán i di arwat suri da him kuluk be ngo kápte. Na hol pala iau sár.” ’ ");
INSERT INTO sgz_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Má átuil kálámul a parai singin tám arardos er ngo, ‘Una parai singin ngoromin, “Káp ina te han má iau kápkabin iau hutngin kila sár, má ngorer na hol pala iau be.” ’ ");
INSERT INTO sgz_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Má ngorer tám arardos er a kaleng má a parai boh worwor no singin konom erei. Ngorer má konom erei a lala sák i bál má a parai singin tám arardos er ngo, ‘Una sangar i han sosih uradi be i malar má unák láklák tangrai tan sál. Una long pasi boh maris má tan rau mái rung a sák i lim di má kik di mul suri da lákám má dák namnam.’ ");
INSERT INTO sgz_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Má ngorer kán tám arardos a longra pasi worwor má a han. A han ngorer má a dos palai te tám arardos mul mai worwor erei. Io, di han má di long pasi tan kálámul má namur di kaleng no. Tám arardos er a mákái ngorer má a kusak mák parai singin konom er ngo, ‘Kam worwor, konom, dikte han má mai. Mái sár a wáin besang á rum.’ ");
INSERT INTO sgz_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Má ngorer mul konom er a parai singin kán tám arardos ngo, ‘Una han uri tan kuir sál uranang má uradi má urami bos mul, má una tu hustap pas te kálámul mul suri da lákám má akángái rum min, má giták namnam. ");
INSERT INTO sgz_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Iau parai si gam no ngo ái rung erei iau bit táilna di suri á long namnam minái, kápdate kis tiklik mam git mul.’” ");
INSERT INTO sgz_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Io, namur ái Iesu a han alari malar er má a sopasun kán inan urami Ierusalem, má ngorer tilik lala matananu di tiklik mam Iesu. Má a ilang sur di ái rung er di lu murmur on má a parai ngoromin, ");
INSERT INTO sgz_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ái koner a han uri narsang suri na kalik án aratintin kaiak, ki na longoi ngoromin. Na lala mámna iau sang alari tan kálámul ngorer ái kákán mái mámán mái kán wák má rang natun. Má na mámna iau alari rang tuán má rang kukun mul. Má kápnate mámna kalengnai kán liu sang, na tu mámna iau sár. Ngo kápnate longoi ngorer, ki kápnate kalik án aratintin kaiak. ");
INSERT INTO sgz_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Rung di mur i iau da áslai sang i rangrangas kabin di kaiak. Ái koner kápate bál pasi rangrangas erei, ái kápate arwat suri na kalik án aratintin kaiak. ");
INSERT INTO sgz_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ngo tekesi kálámul tili gam a hol on suri longoi tekesi rum a pakta, mulán táit na longoi na kis án hol suri ngádáh na longoi ngoi, má a is á mámát i pirán tabal na omlawai suri arahi á him erei. ");
INSERT INTO sgz_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mái sár ngo kápate longoi ngorer, má a turpasi longoi rum er mai pálkibán, má namur ngo ákte rah mái pálkibán, koran má na mákái gut ngo kápate arwat suri long arahi, ki na tu lu tur mai pálkibán sár á rum. Má matananu da lu mákái ngorer da lu ret mai má dák lu parai ur on ngo, ");
INSERT INTO sgz_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Keskam bul singim á iáu, u tartar iáu sang suri longoi á lala rum er. Má u arwat sang suri long arahi? Kol a mon sang á kam pirán tabal? Wa u tu lawa iáu!’ ");
INSERT INTO sgz_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ngo aru á kabisit a mon i kándiar tan kálámul án arup. Kesá kabisit a sángul i arip sár á kán kálámul, má kesá kabisit aru i sángul á arip sang á kán kálámul. Io, kabisit a mudán sár i kán kálámul án arup a longrai ngo er má koner a marán i kán kálámul ák lu hanhan má suri diara arup. Ngo a longrai ngorer, ki dánih na longoi? Na mulán kis án hol besang suri na arwat suri na arup mai kabisit er ngo kápte. ");
INSERT INTO sgz_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Má ngo kápte, ki a kuluk ngo na para palai kán worwor uri narsán kabisit er i pákánbung kápate han páput be suri sungi ngo koion diara arup, diara araturán sár. ");
INSERT INTO sgz_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Má ngorer ái koner a nem suri na kalik án aratintin kaiak, ki na hol palai besang á kán minsik, má erár ák arwat suri na kalik án aratintin kaiak. ");
INSERT INTO sgz_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Tas a kuluk, mái sár ngo ákte rah á kán mapak, ngádáh gita amapak kalengnai ngoi? ");
INSERT INTO sgz_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Tas kápate mapak káp kán te talar. Git lu buswai sár. Ái koner a nem ngo na talas má na mánán, ki na kis án alongra sár.” ");
INSERT INTO sgz_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","I kesi bung mul, ái rung di lu kip takis má tan tám abulbul di tapam hut narsán ái Iesu suri longrai. ");
INSERT INTO sgz_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Má boh Parisaio má tan tám mánán uri nagogon di turpasi ngurngurngur uri Iesu, má dik parai ngo, “Kálámul er a lu kuluk sár mai tan tám abulbul má a lu namnam tiklik mam di!” ");
INSERT INTO sgz_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Io, ái Iesu a mánán tusi kandi hol, má ngorer a parai uri narsá di á worwor artálár minái ngoromin, ");
INSERT INTO sgz_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ngo kes tili gam á tan kálámul min a mon i kesá mar i kán sipsip, má ngo tekes tili di ák han rong, dánih na longoi á kálámul erei? Kálámul erei na han be alari asiu i sángul mai asiu á sipsip iatung i poron ur er di lu namnam ái, má na han mákmák sur koner a rong má nák ser pasi. ");
INSERT INTO sgz_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Má kálámul er a be ser pasi sipsip er a rong, a lala gasgas. Má ngorer a top pasi sipsip er má a oboi iatung i káil má a pusak kalengnai uratung i narsán tan sipsip. ");
INSERT INTO sgz_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Io, i pákánbung a kaleng uri malar á kálámul erei, a bin pasi rang turán mák parai si di ngo, ‘Gama gasgas tiklik mam iau kápkabin iakte ser pasi má kak sipsip er a rong!’ ");
INSERT INTO sgz_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Má iau parai si gam ngo a ngorer mul ami bát. Ngo di longrai suri kesá tám abulbul ákte hol kaleng, a tuan sorsorliu sang á laes ami bát suri. Má laes er a tuan pakta taladeng alari laes di áslai suri asiu i sángul mai asiu á kálámul di tám nokwan, má káp kándi te talar suri hol kaleng.” ");
INSERT INTO sgz_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Mái Iesu a sopasun i kán worwor mai worwor artálár ngoromin, “Ngo kesi wák a oboi kán sángul á siliwa i kán rum, má kesá kepwen siliwa a pur iatung i rum mák rong, dánih má na longoi á wák er? Wák er na oskoi be i lam ngorer ki nák tahtah i kán rum, má namur na mákmák kuluk i tan kuir no iatung i kán rum suri pirán tabal nák han pang i pákánbung ngo na ser pasi. ");
INSERT INTO sgz_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Io, i pákánbung er a be ser pasi, wák er a bin talmi rang buhán má rang turán, má a parai si di ngo, ‘Gama gasgas tiklik mam iau kápkabin iakte ser pasi má kepwen siliwa er iau palai!’ ");
INSERT INTO sgz_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","A muswan á minái iau parai si gam, má ami bát na ngorer sár mul. Tan angelo káián ái Káláu da laes sang suri kesá tám abulbul a hol kaleng.” ");
INSERT INTO sgz_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Má ngorer ái Iesu a parai kesi worwor artálár mul ngoromin, “Kesi kálámul iatung a mon i aru natun káláu. ");
INSERT INTO sgz_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Má áruán kalik i diar a parai si kákán ngo, ‘Tata, minsik er kaiam ngo giur tuán a otoi namur i bung una mat on, wa una lu tam purwai má i giur onin, pasi risán er kaiak sang suri inak top on má.’ Io, mái kákán a longrai ngorer má a tam purwai minsik i aru natun. ");
INSERT INTO sgz_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Namurwai te bung a rah, áruán kalik er a sirai risán minsik er pasi pirán tabal ur káián, mák han alari kán malar uri malar tepák. Má iatung i malar er a longlong Tomono mai omlawai kán pirán tabal, ");
INSERT INTO sgz_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","má káp melek ák rah. Namur má taul itol a hut má a bonta noi malar erei, má kalik er a kápte táit mul suri na ani má suri tángni kán kis iatung, má ngorer a tangkabin matpám. ");
INSERT INTO sgz_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kalik er a matpám má, io ngorer a han mák him singin kesi kálámul tili malar erei. Má kálámul er a dos palai kalik er urada i nián bor suri na lu támri kán tan bor. ");
INSERT INTO sgz_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Má kalik er a lala matpám sáksák sang, mái sár kápte kes a lu támri mam te namnam, má ngorer ák lala kon suri namnam án tan bor. ");
INSERT INTO sgz_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Má namur a kaleng i kán hol sur kákán má a parai singin sang ngo, ‘Inang si Tata a marán á kálámul di lu him singin má kápte di lu matpám, di lu mas tigán á namnam er ándi. Má iau natun muswan iak tuan matpám á inái, má pátum ina mat suri ak te. ");
INSERT INTO sgz_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","A kuluk ngo ina aptur má inak lu kaleng, má ina parai si Tata ngoro minái, “Kang, iakte longoi sápkin i mátán ái Káláu má uri narsam mul. ");
INSERT INTO sgz_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Kápate arwat mul suri una utung iau mai natum, ái sár una obop iau má inang kam kesá tám arardos sár.” ’ ");
INSERT INTO sgz_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Io, ngorer má a aptur á kalik er má a turpasi láklák kaleng uranang i narsán ái kákán. Má ngo kalik er a lu hanhan páput sár suri na hut anang i rum si kákán, ái kákán a mák pasi tilatung má a mámnai. Má ngorer a rut ái kákán suri, má a pamar pasi mák doroi. ");
INSERT INTO sgz_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kalik er a mákái ngorer má a parai si kákán ngo, ‘Tata, iakte longoi sápkin i mátán ái Káláu má uri narsam. Má kápte arwat sang suri una utung iau mul ngo iau natum.’ ");
INSERT INTO sgz_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Mái sár ái kákán a long pas natun uri kán rum má a bin pas te tám arardos mák parai si di ngoro minái, ‘Gama sangar suri long pas tekesi lain kaen ur singin nák sulu mai, má tekesi ring gama asolai i kátngán limán, má tekesi bákbákar uri keken. ");
INSERT INTO sgz_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Má gama han gamák long pas tekesá lain bulumakau mul má gamák up bingi má gamák iohoi, má ngorer gita long namnam má giták laes. ");
INSERT INTO sgz_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kápkabin natung minái iau hol on ngo ákte rong má ákte mat, mái sár onin a liu sár má ákte tapam hut kaleng.’ Má ngorer di turpasi namnam má dik laes. ");
INSERT INTO sgz_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Mulán natun á kálámul er ami sang i num kán tu him. Má ngo a kaleng uratung pátum i malar, a longrai kaungán kuduh má saksak má di mil. ");
INSERT INTO sgz_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Má ngorer a bin pasi kesá tám arardos má a gáltai ngo, ‘Be, kaungán dánih á ngoro minái iau longrai?’ ");
INSERT INTO sgz_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Má tám arardos a parai singin ngo, ‘Ái kakam a long namnam. A ardos má dik up bingi lain bulumakau uri kis kalar tuam kabin ákte hut kaleng má a liu kuluk sár.’ ");
INSERT INTO sgz_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Io, mulán natun a longrai ngorer má a mos máng kulkulut suri kusak tiklik mam di. Má ngorer ái kákán sang a so má a parai singin ngo, ‘Kauh, lákám. Kusak má!’ ");
INSERT INTO sgz_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Mái sár kalik er a kos kalengna kákán ngoromin, ‘Tata, mákái! Iau lu him singim ngorer i kesá kam tám arardos sár pasi marán á bet. Má bosbos bung no iau lu taram i iáu má káp iau tini kulkulut. Má dánih ukte tabar iau mai? Kápute tabar iau be mai tekesi án gengen me suri inak long namnam má gimák laes i rang turang. ");
INSERT INTO sgz_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Mái sár ái natum erei ákte omlawai kam tan táit ur singin boh wák án sál. Má i pákánbung a hut kaleng ur main i malar, ki uk up bingi tilik bulumakau erei suri.’ ");
INSERT INTO sgz_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Má ngorer ái kákán a kosoi worwor si natun ngo, ‘Kauh, á iáu gitar lu kis tiklik áklis, má tan táit no er kaiak, na ur kaiam sár. ");
INSERT INTO sgz_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mái sár ngádáh? Kápate arwat suri gita long namnam má giták laes be? A kuluk sár kápkabin ái tuam ákte han benget má a ngoro ákte mat, mái sár onin a liu sár má ákte tapam hut kaleng.’” ");
INSERT INTO sgz_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Má ngorer ái Iesu a parai kesá worwor artálár singin kán kalilik án aratintin ngoromin, “Kesá tiling konom iatung a mon i kán kesá toptop a tám mánán má a lu ololoh i kán tan táit. Mái sár namur konom erei a longrai ngo tám ololoh erei a omlawai tan táit káián konom. ");
INSERT INTO sgz_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Má ngorer konom erei a artari pasi tám ololoh uri narsán má ák gáltai ngo, ‘Be, a muswan á worwor iau longrai uri iáu? Ngorer una inngasi tan mámát i tan táit no er u ololoh on inak mákái, má namur ina long pala iáu má.’ ");
INSERT INTO sgz_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Tám ololoh er a parai singin sang ngo, ‘Pátum má kak pakpakta na long pala iau tili kak him. Ngorer má kápte kes mul na long pas iau má obop iau suri ina tám ololoh káián. Dánih má ina longoi? Káp iau te rakrakai suri tám himhimna, má iau rumrum mul suri sung tangrai sál sur ak te. ");
INSERT INTO sgz_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Iu, wa iakte hol on má táit ina longoi! Ina araturán mam te kálámul suri da lu bin pas iau uri kandi rum er ngo ina rah tili kak him.’ ");
INSERT INTO sgz_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Má namur tám ololoh a bin talmi tan kálámul ái rung er a mon i tinákum káián konom er i di, má a gálta di keskeskes. Má tám ololoh a gáltai mulán kálámul ngo, ‘Á iáu a is á tinákum káián ái kak pakpakta er i iáu?’ ");
INSERT INTO sgz_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Má kálámul er a parai ngo, ‘Kesi mar á átbán wel.’ Ngorer má tám ololoh a parai singin kálámul er ngo, ‘A kuluk. Ina tangan iáu suri longoi á tinákum er. Sukis má. Top on á pákán ram min má una le palai alim i sángul, má alim i sángul sár má kam tinákum na lu kis. Má ngorer una kosoi alim i sángul sár, má alim i sángul páksiai má.’ ");
INSERT INTO sgz_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Namur a gáltai kes bul á kálámul ngo, ‘Má iáu, a is á tinákum i iáu?’ Má kálámul er a parai ngo, ‘Kesi mar á rat padi.’ Ngorer má tám ololoh a kosoi kálámul er ngo, ‘Be, wa kesi mar á rat padi sang á kam tinákum? Minái á kam pákán ram, má una le palai aru i sángul á rat padi, má na wal i sángul sár má rat padi er tinákum i iáu na lu kis, má páksiai má aru i sángul.’ ");
INSERT INTO sgz_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Konom erei a longrai ngorer má a mák ilmi uri toptop er ngo, káksiai ngo kápate muswan, wa a tám holhol tus mul kabin ákte peplai sál ur on suri nák gai on i te táit namur, má ngorer a para agasi. Rung di lala holhol suri liu án naul bim, ngorer ái rung di kis i kuron, di mánán taladeng sang suri tipar tumani kandi liu main i bim. Má kandi mánán ái rung erei suri tan matngan táit ngorer a lala sorliwi mánán kandi ái rung di kis i talas.” ");
INSERT INTO sgz_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Mái Iesu a sopasun kán worwor má a parai ngoro minái, “A muswan á minái iau parai si gam ngoromin. Pákánbung kamu tu liu be main i naul bim, a kuluk gama lu tángni tan sáhár mai kamu minsik pas te rang tur gam dák ruruna i Iesu. Má namur ngo ákte rah má i kamu liu, ki ái rung erei di kis táil i malar er di liu áklis on, da árár pas gam uratung. ");
INSERT INTO sgz_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ái sinih a muswan mai longoi gengen him sár, ái na muswan mul suri longoi tilik him. Má ngorer mul ái koner kápate muswan mai longoi gengen him sár, ái kápnate muswan sang suri longoi him pakta. ");
INSERT INTO sgz_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Má ngorer ngo á gam kápgamte arwat suri kátlán tumani tan táit til main i naul bim, sinih na ruruna i gam suri gama kátlán i tan támin táit káián ái Káláu? Kápte kes. ");
INSERT INTO sgz_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Má ngo gam kápgamte muswan suri ololoh kuluknai táit káián lite kálámul, ái sinih na tabar gam mam te táit mul ur kamu sang suri gamák ololoh on? ");
INSERT INTO sgz_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Kápte kesá toptop a arwat ngo na lu him singin aru konom no sár. Ngo na longoi ngorer, ki na mámnai kes sár, má na mikmikwai kesi tur diar. Na lu muswan ur singin kes, má kes na lu hol agengen on. Má ngorer ái koner a lala bes mai pirán tabal kápate arwat ngo na toptop si Káláu mul.” ");
INSERT INTO sgz_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Tan Parisaio di longrai tan worwor ákte parai ái Iesu, ngorer má di tartar retret si Iesu kápkabin di lala hol suri pirán tabal sár. ");
INSERT INTO sgz_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Mái Iesu a parai uri di ngo, “Á gam gam lu tohoi suri gama mák kuluk ngoro tan tám nokwan uri mátán tan kálámul, mái sár ái Káláu a mánán muswan i bál gam. Má táit gam lala bes mai i matananu, uri mátán ái Káláu a tuan sák. ");
INSERT INTO sgz_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Worwor i nagogon si Moses má káián tan tám worwor tus a kátlán i git tungu mák han pang i pákánbung ái Ioanes Tám Arsiu a hut. Mái sár turpasi i pákánbung erei, hutngin nagogon a kis, wa lain arbin suri lolsit si Káláu, má marán kálámul di lala kákir suri kusak ur on. ");
INSERT INTO sgz_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Naul bát má naul bim na bokoh be, mái sár ngo kápte kesi mudán tip tili nagogon na bokoh. ");
INSERT INTO sgz_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ngo tekesi kálámul a palai kán wák má a kila pasi lite wák, kálámul erei a longoi sápkin. Mái koner a kila pasi wák er ákte long palai ái kán pup, ái mul a longoi sápkin.” ");
INSERT INTO sgz_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Mái Iesu a sopasun i kán aratintin mai kes mul á worwor artálár ngoromin, “Má kesi kálámul a konom a liu i arliwán bung er. Má a lu mermer mai tara lalain sulu sang, má a lu ani lalain namnam i bohboh bung no, má kápte kesi táit a sáhár suri. ");
INSERT INTO sgz_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Má kesi kálámul mul iatung a maris, má kálámul er ngisán ái Lasaro. Kápán páplun ái Lasaro manu a bonta noi, má di lu kipi uratung i mátán kas i kuir malar káián konom er má a lu sukis pagas ái suri sung. ");
INSERT INTO sgz_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ái Lasaro a hol on ngo na lu ani tan tingnán namnam di lu mas tigán má dák lu buswa palai tilatung i rum. Mái Lasaro di oboi iatung, má tan pap di lu salsaliu má ngorer di lu dami kán tan manu mul. ");
INSERT INTO sgz_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Namur má, maris án kálámul er a mat, má tan angelo di long pasi tanián ngorer má dik aksimi i narsán ái Abaram. Io, namur sár kálámul er a konom a mat mul má dik tahni. ");
INSERT INTO sgz_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Má iatung i tarang án minat a kis ái á tanián kálámul er, má a áslai lala rangrangas. Má ngo a tántán, a mák Abaram ur tepák mái Lasaro a kis i narsán ái Abaram. ");
INSERT INTO sgz_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ngorer má tanián kálámul er a bin ngo, ‘Abaram, iáu á támin i iau, una mámna iau! Ák tuan gis iau má rangrangas á minái i kámnah. Una parai si Lasaro suri na kip te dan má una dos palai mai ur mainái, má nák agáwár i kermang án mudán mai dan er na tim tili kátngán limán.’ ");
INSERT INTO sgz_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Mái sár ái Abaram a parai, ‘Kauh, wa u hol páptai sang gut be á kam liu i liu án kápán páplun u tabir sang mai á tan lain táit no, mái Lasaro a otoi sár i tan táit a sák. Mái sár onin ái Lasaro ákte sengsegeng má, má iáu bul una áslai rangrangas. ");
INSERT INTO sgz_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Má kesi táit er i arliwán i git, tilik polon dan. Mái rung di nem i han til mainái si gim uratung sur gam, kápdate long artálár on. Mái rung tilatung si gam kápdite arwat mul suri da han ur main si gim.’ ");
INSERT INTO sgz_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Má tanián konom er a longrai ngorer má a hol pasi rang tuán má a parai ngoromin, ‘Ina sung iáu be, Abaram, ngo una dos kalengna Lasaro be uradi rum si tata ");
INSERT INTO sgz_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","suri alim i tuang di idi. Na han sang ái Lasaro má nák akeng i di suri da káp han mul ur main i malar án rangrangas.’ ");
INSERT INTO sgz_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Mái sár ái Abaram a parai singin tanián konom erei ngoro minái, ‘Nagogon si Moses má worwor káián tan tám worwor tus ákte kis. A kuluk da alongra suri má dák taram on.’ ");
INSERT INTO sgz_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Má tanián konom er a parai mul ngoro minái ngo, ‘Auh, tata Abaram, kápate arwat sang á ngorer ukte parai. Rang tuang kápdate longra pasi sang á erei. Koran má tekes na aptur til main i pokon án minat má ngorer na han uri narsán i di suri akeng i di, ki erár da hol kaleng alari kandi sápkin.’ ");
INSERT INTO sgz_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Mái sár ái Abaram a parai ngo, ‘Na, kápte sang! Erei ngo kápdate alongra suri nagogon si Moses má tan tám worwor tus, ngádáh da hol kaleng ngoi singin á tekes er a aptur tili minat?’” ");
INSERT INTO sgz_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Má namur ái Iesu a worwor mul uri narsán kán kalilik án aratintin mák parai ngoro minái, “Boh artohtoh er a lu tutkum on i kálámul mák longoi sápkin, a támin na tapam hut sang. Mái sár na tuan sák uri kálámul er a lami kesá kálámul suri ák longoi sápkin. ");
INSERT INTO sgz_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ái rung er di ruruna i iau di ngoro rang natung. Ái koner a lam bengtai kes tili di ái rung di ruruna i iau mák apurái kán ruruna, kálámul er a longoi táit a tuan sák. Ngo da putai tilik lala hat i án pogong á kálámul er má da lápkai urada i lontas, a gengen rangrangas sár. Má rangrangas er na oboi ái Káláu ur on, ái na lala pakta taladeng kabin a long sáksáknai ruruna káián kesi natun ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Gama ololoh i gam. “Ngo ái tuam a longoi sápkin uri narsam, una tur kári má parai singin ngo táit a longoi kápate kuluk. Má ngo a hol kaleng, ki una hol palai sár. ");
INSERT INTO sgz_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Má ngo a longoi sápkin narsam marán pákán i kesá bung, má keskeskesi pákán a longoi ngorer má namur a hut narsam mák parai ngo, ‘Keskam, iau longoi ngoromin uri narsam,’ ngo a parai ngorer ki una hol palai sár.” ");
INSERT INTO sgz_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Má boh kalilik án aratintin er, ái rung er namur di utung di mai boh apostolo, di parai singin ngo, “Konom, una tangan gim suri na pakta i kángim ruruna uri narsán ái Káláu.” ");
INSERT INTO sgz_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Mái Konom a kos di ngoro minái, “Ngo kamu ruruna na ngorer i kotlin kali, káksiai ngo a tu gengen sár, a arwat sár ngo gama parai singin kuil min ngo, ‘Hai! Una támrabut má unák han tur ada i lontas!’ Má kuil er na longra pasi má nák tárma gam.” ");
INSERT INTO sgz_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Mái Iesu a sopasun i kán aratintin mák parai ngoromin, “Má ngo tekes tili gam a kálámul pakta má a mon i kán toptop a lu him ada i num ngo a lu ololoh i tan sipsip ami bos, má ngo a kaleng tili him uri malar i rahrah, ngádáh una parai singin ngoi? Káp una te parai singin kam toptop ngo na sangar suri na ani áián suri ái na namnam táil. ");
INSERT INTO sgz_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Auh, kápte sang. Ngoro minái una parai singin kam toptop ngoi, ‘Una tutun be á iáu. Io unáng kelkeles, má namur unák sokoi namnam inak ani má unáng kipi dan inak nginmi, má una kis nana iau. Má ngo iakte namnam no, ngorer á iáu bul una namnam má unák ngin.’ ");
INSERT INTO sgz_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ngádáh, una ot kuluk uri narsán kam toptop er kabin a longoi tan táit ukte dos on suri? Kápte sang! ");
INSERT INTO sgz_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Má gama ngorer sár mul á gam. Namur ngo gamáte long artálár pas noi kamu talar, gama parai arliu i gam ngoro minái, ‘Git á tan toptop má gitáte longoi sár á kángit talar.’” ");
INSERT INTO sgz_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Má a sopasun i kán inan urami Ierusalem ái Iesu, ngorer a tangrai arpangia i aru balis á Samaria má Galiláiá. ");
INSERT INTO sgz_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Má ngo kán tu láklák be suri ngo na kusak i kesá malar er, ái Iesu a banai sángul á lepra. Má ding kálik tur tepák sang ");
INSERT INTO sgz_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","má dik bin ur singin ngoromin, “Iesu, Konom, una mámna gim!” ");
INSERT INTO sgz_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Mái Iesu a mák di má a parai si di ngo, “Gama han má gamák inngasi páplun i gam singin tan tám osmapak suri dák mákái ngo gamáte sengsegeng alari kamu sasam.” Má ngo di longrai ngorer ki dik han pas. Má ngo kándi tu láklák be tangrai sál, lepra a bokoh pas alari páplun i di má dik sengsegeng. ");
INSERT INTO sgz_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Má kesi tur di á tan lepra erei a mákái ngo ákte sengsegeng. I pákánbung er, a ilang kaleng sur Iesu má a lala para agas Káláu urami bát. ");
INSERT INTO sgz_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Má kálámul er a han sukis dirtapul i narsán keken ái Iesu má a ot kuluk uri narsán. Kálámul er, ái a kakun Samaria. ");
INSERT INTO sgz_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","18","Mái Iesu a mákái ngorer má a parai ngoromin, “Di tara sángul á kálámul er iakte asengsegeng pas di, be? Má suri dánih á asir masik minái a kaleng suri ot kuluk uri narsán ái Káláu? Di aiá á asiu á kakun Israel erei?” ");
INSERT INTO sgz_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Mái Iesu a parai singin ngo, “Salaptur má unák lu han. Kam ruruna ákte asengsegeng pas iáu má.” ");
INSERT INTO sgz_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Má kesi bung, te Parisaio di gálta Iesu ngo, “Enges á lolsit káián ái Káláu na tapam hut má náng kátlán i git ái Káláu?” Mái Iesu a kos di ngoro minái, “Lolsit káián ái Káláu kápnate mon te akiláng on suri giták mákái ngo er má na tapam hut. ");
INSERT INTO sgz_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Má kápte kes na parai ngo, ‘Gam mákái, minái mái!’ ngo ‘Erei mái tili munang!’ Kápte sang, kápkabin ngo lolsit si Káláu minái sang i katbán i gam!” ");
INSERT INTO sgz_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Má namur ái Iesu a parai narsán kán kalilik án aratintin mul ngoro minái, “Namur gama nem suri mákái kesi kepwen bung káián Natun Kálámul, mái sár kápte má gama mákái. ");
INSERT INTO sgz_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Má te kálámul alatung da lu parai si gam ngo, ‘Gama mákái, imunang á Natun Kálámul!’ ngo ‘Minái sár ái!’ Mái sár koion gama mur i di á tan kálámul er. ");
INSERT INTO sgz_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Má kalkaleng káián Natun Kálámul i kepwen bung káián sang, na ngorer sár i talsán pil a talas tili kesá kuir armongoh uri kesá kuir, má a atalsai naul bim no. ");
INSERT INTO sgz_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mái sár mulán sang, ái na áslai rangrangas má da mikmikwai i ngaul matananu onin. ");
INSERT INTO sgz_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Má pákánbung káián Natun Kálámul na ngorer sár i bung hirá ái Noa má rang natun di kusak uri tilik mon. ");
INSERT INTO sgz_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Matananu di lu namnam sár má dik lu ngin, má dik lu kila mul. Kandi tu taltaladeng sár pang i bung er ái Noa a kusak uri tilik mon, má ngorer tilik tibin a hut má a up bing noi matananu. ");
INSERT INTO sgz_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","30","Má pákánbung káián Natun Kálámul er na tur soura on, na ngorer sár mul i pákánbung a liu on ái Lot anang i malar á Sodom. Matananu di lu namnam sár má dik lu ngin, má dik lu huhul má sirsira, má dik lu himhimna, má dik lu long rum mul pang i bung ái Lot a táu alari malar er mái Káláu a tarwai kámnah er a pur tilami bát mák up bing noi matananu. ");
INSERT INTO sgz_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ái koner ngo na iatung i lol malar i bung er, kápnate kusak mul uri kán rum suri kip kán te táit iatung. Na tu táu sár. Na ngorer sár mul sur koner a him i kán pokon, kápnate kaleng uri kán rum. Na tu táu sár. ");
INSERT INTO sgz_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Gama hol pasi táit er a hut si kán wák ái Lot! ");
INSERT INTO sgz_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ái koner a tohoi suri na top páptai kán liu til main i naul bim, liu muswan er a kis áklis na bokoh alari. Mái koner kápate mámnai kán liu, ái na atur páptai liu muswan er. ");
INSERT INTO sgz_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“A muswan á minái iau parai si gam. Ngo i libung ngo na kaleng on ái Natun Kálámul, má ngo na ru á kálámul diara boptin tiklik i kesá rum sár, kesá turán na bokoh, má kes nák lu bop iatung. ");
INSERT INTO sgz_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Má ngo i nas, má ngo na ru i wák diara ioh tiklik iatung i kesá goson sár, kesá turán na bokoh, má kes masik sár nák lu kis iatung. ");
INSERT INTO sgz_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Má ngo na ru i kálámul diara him tiklik ami bos, kesá turán na bokoh, má kes nák lu kis iatung.” ");
INSERT INTO sgz_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Má tan kalilik án aratintin di gáltai ngoro minái, “Be, Konom, aiá na tapam hut ái á táit erei?” Mái Iesu a kos di ngoro minái ngo, “Erei ngo gama mákái tan wokwok di roh má dik han roh sukis ái, alatung i pokon er á minatin táit. Na mon mul i akiláng ngorer suri para tusi pokon na tapam hut ái á táit erei.” ");
INSERT INTO sgz_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Kesi bung, ái Iesu a parai worwor artálár minái uri narsán kán kalilik án aratintin suri da lu sung áklis má koion da lu puplir. ");
INSERT INTO sgz_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Mái Iesu a sopasun kán worwor mák parai ngoro minái, “Kesi kálámul a kis i kesá malar. A tám nagogon, mái sár a tánlak i nagogon si Káláu má i worwor káián kálámul mul. ");
INSERT INTO sgz_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Má kesi mokos tilatung i malar erei sár a lu balbal han uri narsán tám nagogon er mák lu sungi ngo, ‘Una tangan iau má una oboi kálámul er giur lu togor suri na anokwa iau má nák hul iau.’ ");
INSERT INTO sgz_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Má tám nagogon er a lu longrai ngorer má kápate lu long tekesi táit suri tángni mokos er. Mái sár kesi pákán má, kálámul er a ngoi singin sang ngo, ‘A támin ngo káp iau te lu longra pasi worwor si Káláu má tan kálámul mul, ");
INSERT INTO sgz_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ái sár ngo mokos minái a lu balbal han uri narsang mák lu som kusa iau. Ngorer ina mákái má inak tángni, na káp balbal kaleng uri narsang má nák amerok i kak hol!’” ");
INSERT INTO sgz_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Má ngorer ái Konom Iesu a sopasun kán worwor mák parai ngoro minái, “Gamáte longrai á worwor káián tám nagogon sáksák erei. ");
INSERT INTO sgz_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ngádáh, ái Káláu kápnate long anokwa di ái rung er ákte long pas di ur káián sang, ái rung er kandi tu tang uri narsán i nas má i libung mul? Ngádáh, na talsir ái Káláu suri tangan di? ");
INSERT INTO sgz_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","A muswan á minái iau parai si gam. Ái Káláu na sangar i tármai kandi sung má nák lu tangan di. Mái sár i pákánbung ngo ái Natun Kálámul na kaleng, ngádáh, na bana te kálámul di ruruna uri narsán ngo kápte?” ");
INSERT INTO sgz_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Mái Iesu a parai mul i worwor artálár minái uri narsán tan kálámul erei di hol sang i di ngo dikte tám nokwan má di hol agengen i tan kálámul, má a parai ngoromin, ");
INSERT INTO sgz_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Kesi pákán aru kálámul diar láklák tapam urami rumán osmapak suri diara sung. Kesá turán a Parisaio, má kes a tám kip takis. ");
INSERT INTO sgz_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ngorer má Parisaio a sámtur má a parai suri sang i kán sung ngoromin, ‘Káláu, iau utung kuluk uri narsam kápkabin á iau káp iau te ngoro tan kálámul, ái rung di lu agur pasi pirán tabal káián lite, má di tan tám longoi sápkin mul, mái rung di lu bop mai wák kán lite. Má iak para agas iáu mul ngo á iau káp iau te ngoro kono mer si tám kip takis. ");
INSERT INTO sgz_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Má iau lu ahal aru i bung on á kesá wik, má iau lu bal artabar uri narsam mai keskeskesá táit tili tan táit iau otoi.’ ");
INSERT INTO sgz_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Mái sár tám kip takis er a kálik tur tepák má kápate saktádái aur urami bát. A tu tur mai rumrum iatung má a tinang i bál, má ngorer a tututi bongbongon mák parai ngo, ‘Káláu, á iau á tám sápkin á minái. Una mámna iau!’” ");
INSERT INTO sgz_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Mái Iesu a parai ngoromin, “A muswan á minái iau parai si gam. Tám kip takis minái a han mai lala taun, mái sár ái Káláu a anokwa pasi. Má ngorer i pákánbung kálámul er a kaleng uri kán rum sang, ákte sengsegeng má. Má Parisaio kápte. Kápkabin ái rung di apakta pas di sang, ái Káláu na agengen i di sár. Mái koner a agengen pasi sár, ái Káláu na apakta pasi sang.” ");
INSERT INTO sgz_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Má te kálámul di lam tari rang nat di uri narsán ái Iesu suri na top i di má nák asosah i di. Mái sár tan kalilik án aratintin di mákái tan kálámul erei má dik tur kalar di suri koion da longoi ngorer. ");
INSERT INTO sgz_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Mái sár ái Iesu a bin pasi tan gengen kalilik uri narsán, mák parai ngo, “Gama hol palai boh gengen kalilik ur singing. Koion gama tur kalar di kabin ngo kandi ái rung ngoromin á lolsit si Káláu. ");
INSERT INTO sgz_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","A muswan iau parai si gam, ái koner a nem ngo na kusak i lolsit si Káláu, na ruruna pasi ngorer i gengen kalik a ruruna i kákán. Ngo kápnate longoi ngorer, ki kápte sang na kusak.” ");
INSERT INTO sgz_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Má kesi pakpakta kandi tan Iudáiá a gálta Iesu ngo, “Tám Aratintin, iáu lain kálámul. Dánih ina longoi suri inak atur páptai liu áklis?” ");
INSERT INTO sgz_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Mái Iesu a longrai mák parai singin ngoromin, “Suri dáh u utung iau ngo iau lain kálámul? Ái Káláu masik sár a kuluk má kápte kes mul. ");
INSERT INTO sgz_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","U mánán i nagogon er a parai ngoromin ngo koion una longoi sápkin mai wák káián lite kálámul, má koion una up bingi tekesi kálámul, má koion una siksikip, má koion una poklah pasi angagur uri tekesá kálámul, má una rumrum i kakam mái mamam.” ");
INSERT INTO sgz_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Má kálámul er a longrai mák parai si Iesu ngo, “Turpasi til tungu iau kalik be, iau lu mur arwat pas noi tan nagogon erei ák han pang onin.” ");
INSERT INTO sgz_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Má a longrai ngorer ái Iesu má a parai singin ngo, “Kesi táit sár u sáhár suri. Una han sira palai kam bos minsik no má una tari pirán tabal singin bos maris. Má ngo una longoi ngorer, na kaiam besang á boh lain minsik imi bát. Má una lákám unák mur i iau.” ");
INSERT INTO sgz_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Má ngo kálámul erei a longrai worwor si Iesu uri narsán, ák lala tinang i bál má, kabin ngo a tilik konom sang. ");
INSERT INTO sgz_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Mái Iesu a mákái ngo kálámul er a tinang i bál mák parai singin ngoro minái, “A tuan rakrakai muswan si di á boh konom suri da kusak uri lolsit si Káláu. ");
INSERT INTO sgz_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kamel ngo na sol uri polgon nil án babaut, ái a malmu si diar á kálámul a konom ngo na sol uri lolsit si Káláu.” ");
INSERT INTO sgz_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Má tan kálámul di longrai ngorer má dik gálta Iesu ngoromin, “Ngo ngorer, ki ái sinih sang na liu? Kápte kes sang na kusak!” ");
INSERT INTO sgz_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Mái Iesu a kos di ngo, “Táit ngo matananu kápte di arwat suri da longoi, ái Káláu a arwat sang suri long arwat pasi.” ");
INSERT INTO sgz_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Mái Petero a parai si Iesu ngoromin, “Mákái, Konom, gimáte han alari kángim boh rum má gimá murmur i iáu.” ");
INSERT INTO sgz_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Mái Iesu a parai si di ngo, “A muswan iau parai si gam ngo kes a han alari kán rum ngo kán wák ngo rang tuán ngo mámán mái kákán ngo rang natun suri lolsit si Káláu, ");
INSERT INTO sgz_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","i liu onin na atur páptai marán mul, má namur na atur páptai liu áklis.” ");
INSERT INTO sgz_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Mái Iesu a lam pasi kán kalilik án aratintin uri risán alari matananu mák parai si di masik ngo, “Mákái, git han má urami Ierusalem á minái, má ngorer na tapam hut muswan má i tan táit erei tan tám worwor tus dikte sir páptai alhirá sang suri Natun Kálámul. ");
INSERT INTO sgz_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ái Natun Kálámul da tari uri limán boh kálámul tili risán ami Ierusalem má da tartar retret singin, má da ot bilingnai má da iapsi páplun, ");
INSERT INTO sgz_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","má ngorer da rapsi má dák up bingi. Má ngo na rah i atul á bung, na liu kaleng mul.” ");
INSERT INTO sgz_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Tan kalilik án aratintin di longrai ngorer, mái sár kápdite talas ur on á tan táit erei. Sálán á tan worwor a punpunam alar di, má kápdite mánán tusi táit ái Iesu a parai. ");
INSERT INTO sgz_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Mái Iesu a lu hanhan pátmi malar á Ieriko má kesi kálámul a rau tám sung a lu kis iatung i risán sál mák lu sungi tan kálámul er di lu láklák pátmi sár. ");
INSERT INTO sgz_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","I pákánbung a longrai irngán matananu di tiklik mam Iesu, ki ák gálta ngo, “Be, wa dánih á ngorer a tapam hut?” ");
INSERT INTO sgz_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Má matananu di parai singin rau erei ngo, “Ái Iesu kakun Nasaret er a láklák sorliu.” ");
INSERT INTO sgz_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Má rau er tám sung a lala bin ngo, “Iesu, á iáu natun ái Dewit! Una mámna iau!” ");
INSERT INTO sgz_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Má te kálámul er di láklák táil i Iesu di tur kári má di parai singin rau er ngo na kis pau. Mái sár a lala bin pakta sang urami bát ngoromin, “Natun ái Dewit, una mámna iau!” ");
INSERT INTO sgz_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Mái Iesu a longrai kálámul er má a sámtur, má a artari suri da lami rau uri narsán. Má ngo rau er a hut i narsán, ái Iesu a gáltai ngo, ");
INSERT INTO sgz_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Dánih u nem on ngo ina longoi mam iáu?” Má kálámul a rau er a kokos ngoromin, “Konom, iau nem sár ngo na talas i matang.” ");
INSERT INTO sgz_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Mái Iesu a parai singin ngo, “Una mákmák sár. Kam ruruna ákte aliu pas iáu.” ");
INSERT INTO sgz_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Má káp melek sár mul má a talas i mátán, má a mur i Iesu tangra sál mai parpara agas uri narsán ái Káláu. Má matananu di mákái ngorer, má di no mul di párnga Káláu. ");
INSERT INTO sgz_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Mái Iesu a kusak uri malar á Ieriko má a tu láklák sorliu sang iamunang. ");
INSERT INTO sgz_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Má kesi kálámul a pakpakta káián gegen him di lu kip takis, a iatung ái, má a konom, má ngisán á kálámul er ái Sakius. ");
INSERT INTO sgz_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Kápate lu mák Iesu be, má kán lala riri sang a nem ngo na mákái, má ngorer a tohoi suri mák Iesu i katbán matananu. Mái sár ái Sakius a kuir kálámul sár má kápate arwat suri na mák Iesu kabin i lala matananu di tur kauli. ");
INSERT INTO sgz_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Má ngorer ái Sakius a rut táilnai matananu i sál er ái Iesu di da láklák on, má a sa uramuni kesá dolon kubau suri na lain mák Iesu. ");
INSERT INTO sgz_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Má ngo ái Iesu a purut iatung i pokon er a tur ái i kubau mák tántán uramuni ngorer, ki ák mák Sakius mák parai singin ngo, “Sakius, una sangar i sosih tilatung kabin ina bop sang i kam rum inái i libung.” ");
INSERT INTO sgz_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Mái Sakius a longrai ngorer má a sangar i sosih tilatung i kubau má a árár pas Iesu, má a long pas Iesu uri kán rum má a kododong i bál suri. ");
INSERT INTO sgz_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Má matananu di mákái ngo ái Sakius a long pas Iesu uri kán rum, ngorer a sák i bál di má di turpasi wor arkuh i di sang má dik parai ngo, “Kálámul min a asir mák han uri rum káián tám sápkin!” ");
INSERT INTO sgz_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Má i pákánbung kándi tu namnam be, ái Sakius a sámtur mák parai si Konom ngo, “Mákái, Konom. Inái iau oror ngo ina tari risán i kak omobop uri narsán boh maris. Má tan kálámul iakte agur pasi kandi pirán tabal tungu, má ina kos kalengnai uri narsá di mai mámát i pirán tabal iau agur pasi mam te mul urami iátin.” ");
INSERT INTO sgz_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Mái Iesu a longrai ngorer má a parai singin ngoromin, “Onin gam er gam lu kis i rum minái, gamáte mák ilmi má araliu káián ái Káláu ákte hut narsá gam, kabin kálámul min a gegen mul si Abaram. ");
INSERT INTO sgz_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Má Natun Kálámul ákte hut suri ser pas di ái rung erei di han benget, má suri na aliu pas di mul.” ");
INSERT INTO sgz_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Má matananu di longrai worwor kán tu parai ái Iesu uri narsán i di. Má ái sang ái Iesu ákte páput má suri na purut ami Ierusalem. Má di á matananu di hol on má ngo lolsit káián ái Káláu na tapam hut sang má, erei ngo ái Iesu na kusak urami Ierusalem. Io, má ngorer ái Iesu a parai worwor artálár uri narsá di á matananu. ");
INSERT INTO sgz_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","A parai ngoromin, “Kesi kálámul tilatung a kálámul pakta má a han uri malar tepák suri da oboi ngis án kabisit on. Má namur na kaleng uri kán balis sang má náng kabisit iatung má na tu kátlán i matananu tilatung i kán balis. ");
INSERT INTO sgz_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Má i pákánbung ngo na han on á kálámul pakta erei, a bin pasi kán sángul á tám arardos uri narsán, má a tari kesá kepwen pirán tabal gol si di keskeskes mák parai si di, ‘Á iau ina lu han má. Má pirán tabal min iau tari si gam, gama lu him mai suri nák pakta pang i bung ina kaleng.’ ");
INSERT INTO sgz_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Má tan kálámul tilatung i kán balis di lala matai kálámul er, má ngorer di dos palai te kálámul namurwai kálámul pakta erei uratung i malar a han ur on má dik parai, ‘Kápte gim nem on á kálámul erei suri na kángim kabisit má na kátlán i gim mul.’ ");
INSERT INTO sgz_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Mái sár kápte di tármai sung káián matananu, má ngorer kálámul pakta erei di oboi áng kabisit má. Má namur a hut kaleng uri kán malar, má ngorer a artari suri kán tan tám arardos iatung er ákte tari pirán tabal si di suri da tapam hut i narsán. A nem suri na mánán pasi ngo a is á pirán tabal dikte him pasi urami iátin i pirán tabal er a tari si di. ");
INSERT INTO sgz_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Má mulán tám arardos a hut i narsán mák parai, ‘Mákái, konom. Iakte him mai á pirán tabal u tari singing má iakte him pasi sángul á pirán tabal mul urami iátin á pirán tabal er u tari.’ ");
INSERT INTO sgz_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Má kabisit erei a mákái ngorer mák parai singin tám arardos erei ngo, ‘A kuluk taladeng. Iáu lain tám arardos sang. Ukte muswan suri longoi gengen talar erei, má ngorer ina tari tilik talar singim. Ina obop iáu má unáng kátlán i sángul á malar.’ ");
INSERT INTO sgz_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Má áruán kálámul a hut i narsán mák parai, ‘Mákái, konom. Iakte him mai á pirán tabal u tari singing má iakte him pasi alim á pirán tabal mul urami iátin á pirán tabal er u tari.’ ");
INSERT INTO sgz_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Má kabisit er a mákái ngorer mák parai singin ngo, ‘A kuluk. Má ngorer á iáu una kátlán i alim á malar.’ ");
INSERT INTO sgz_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Má kes mul á kálámul a hut i narsán mák parai, ‘Konom, minái sár á kam pirán tabal, iau duri mai sepen kaen má iak punmai. ");
INSERT INTO sgz_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Iau mátut na mák rong i kam pirán, kabin iáu tuan songap. Kam tan minsik kápte ngo iáu u lu himna pasi sang. Auh, iáu konom mai tan táit bos lite kálámul di himna pasi.’ ");
INSERT INTO sgz_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Má kabisit a parai singin kálámul er ngo, ‘Iáu sápkin tám arardos sang. Kam worwor er ukte parai, ina ariwa kalengnai uri iáu má nák nagogon i iáu sang! U mánán ngo iau tuan songap má kak tan minsik kápte ngo iau lu himna pasi sang, ái sár iau konom mai tan táit bos lite di himna pasi. ");
INSERT INTO sgz_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ngorer ki suri dánih kápute oboi kak pirán tabal i rumán pirán tabal? Má ngorer minái má iakte kaleng, ina top kalengnai á pirán tabal er mam te pirán tabal mul urami iátin.’ ");
INSERT INTO sgz_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Má namur a parai singin tan kálámul di sámtur pagas iatung ngo, ‘Gama long pasi alari á pirán tabal erei má gamák tari singin tám arardos er a apángái sángul á pirán tabal.’ ");
INSERT INTO sgz_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Mái sár ái rung er di sámtur di longrai ngorer má dik sodar má dik parai singin ngo, ‘Konom, wa ákte top on mái sángul á pirán tabal ái!’ ");
INSERT INTO sgz_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Má kabisit er a kos di ngoromin, ‘Iau parai si gam, ái koner a atur páptai marán má a lu him mai, na kipi marán mul. Mái sár koner a atur páptai mudán sár, má kápate lu him mai mudán er a top on, namur na bokoh alari á mudán er singin. ");
INSERT INTO sgz_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Má tan kálámul er di kurtara mam iau kápdite nem i iau suri ina kabisit kandi, gama long pas di ur main i mátán táil i iau má gamák up bing di.’” ");
INSERT INTO sgz_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Mái Iesu a be para noi worwor artálár erei uri narsán tan kálámul má a aptur alar di. Má namur a lu láklák táil urami suri malar á Ierusalem. ");
INSERT INTO sgz_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Má a lu hanhan pátmi aru i malar er Betani má Betepage iatung i pungpung á Oliwa, mái Iesu a dos palai aru kalik án aratintin ");
INSERT INTO sgz_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","mák parai si diar ngoromin, “Gaura han uramudi malar imudi. Má ngo gaura kusak ur on, káp melek mul gaura mákái kesi gengen dongki di puta páksi má kápte kes a kis be on. Gaura pálás pasi dongki erei má gaurák lami ur main. ");
INSERT INTO sgz_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Má ngo tekes na gálta gaur ngo, ‘Suri dánih gaur ulát pasi dongki erei?’ ki gaura parai singin, ‘A nem on ái Konom suri na him mai be.’” ");
INSERT INTO sgz_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Má ngorer diará han má, má diará mákái tan táit ngorer sár ái Iesu ákte parai si diar. ");
INSERT INTO sgz_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Má ngo diar má lu ulát pasi gengen dongki erei, ái koner káián á dongki a parai si diar ngo, “Suri dánih gaur ulát pasi á gengen dongki erei?” ");
INSERT INTO sgz_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ki diará kokos ngoromin, “A nem on ái Konom suri na him mai be.” ");
INSERT INTO sgz_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ngorer diar má lami dongki erei uri narsán ái Iesu, má diar má ulát pasi lusán i diar ki diar má pálsi i iátin dongki, má ngorer diará tangan Iesu urami iátin dongki erei. ");
INSERT INTO sgz_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Mái Iesu a kis i dongki, má dongki kán tu láklák mam Iesu tangra sál. Má marán di pálsi lusán i di tangrai sál suri na láklák on i dongki, má ngorer di para aposoi kandi rumrum uri narsán ái Iesu. ");
INSERT INTO sgz_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ái Iesu a iatung i sál er a sosih tilamuni pungpung á Oliwa má ákte páput sár suri na kusak ur Ierusalem. Má on á pokon erei, tilik matananu no er di lu murmur on. Di turpasi mái para agas Káláu mai lala kaungán i di suri tara akiláng dikte mákái, ");
INSERT INTO sgz_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","má dik parai ngoro minái, “Ái Káláu na kuluk mai kabisit er a hut mai ngisán ái Konom! Matau urami bát má gita sángwái ngisán ái Káláu urami sang!” ");
INSERT INTO sgz_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Má te Parisaio di iatung i katbán matananu di longrai ngorer má dik parai si Iesu ngo, “Tám Aratintin, una dos kári matananu er di mur i iáu suri koion da para ngorer.” ");
INSERT INTO sgz_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Mái Iesu a kos di ngo, “Iau parai si gam ngoromin. Ngo da kis pau ái rung minái, wa tan hat sang merei da turpasi wakwak má parpara agas uri narsán ái Káláu!” ");
INSERT INTO sgz_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ái Iesu ák lu hanhan pátmi má i bimán rum á Ierusalem. Má ngo a mákái, a tangsi kabin a sák i bál suri, ");
INSERT INTO sgz_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","mák parai ngoromin, “Iau nem ngo iáu, Ierusalem, una han mánán i sálán moloh onin. Mái sár káp una te mákái má sálán á moloh erei, ákte punpunam alar iáu. ");
INSERT INTO sgz_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Na mon i pákánbung da tapam hut i kam tan kurtara má da tur kaul iáu, má da tur kári sál i boh goson no suri kápte kes na táu. ");
INSERT INTO sgz_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Da amosrah i iáu sang, Ierusalem, má da up bing noi tan kálámul di kis i katbán i iáu, ngorer má kápte kesi hat na bop ami iátin kes, da suh pala noi. Tan táit min na tapam hut narsam kabin ukte su bahim ur on má uk matai suri mák ilmi pákánbung er ái Káláu a hut suri aliu iáu!” ");
INSERT INTO sgz_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Mái Iesu a lu hanhan má a hut á Ierusalem máng kusak uri pelbut i rumán osmapak má a turpasi tipar palai bos kálámul di lu sirsira iatung. ");
INSERT INTO sgz_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Má a parai si di ngoromin, “Dikte le on i Buk Tabu ngoromin, ‘Kak rum na rumán sung sang,’ mái sár gamáte pukda pasi suri ák nián him káián bos tám siksikip!” ");
INSERT INTO sgz_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Mái Iesu a aratintin i rumán osmapak i bosbos bung erei. Má bos pakpakta kán tan tám osmapak má tan tám mánán uri nagogon má tan kálámul pakta, di ser sál suri ngádáh da up bingi ngoi. ");
INSERT INTO sgz_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Mái sár kápdite ser pas te sál suri da mur on kápkabin matananu di lala pátir suri longrai worwor si Iesu. ");
INSERT INTO sgz_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Má kesi bung, ái Iesu a atintini matananu iatung i rumán osmapak má ák lu arbin mai lain arbin. Má tan pakpakta kán tan tám osmapak má bos tám mánán uri nagogon má te kálámul pakta, di mákái má dik hut i narsán ");
INSERT INTO sgz_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","má dik gáltai ngo, “Una parai si gim, sinih a dos pala iáu er uk longoi tan táit ngorer? Mái sinih a tari nokwan erei singim?” ");
INSERT INTO sgz_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Mái Iesu a kos di ngoromin, “Má iau mul ina gálta gam má gama parai singing. ");
INSERT INTO sgz_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Gam mánán ái Ioanes Tám Arsiu? Sinih a dos palai suri arbin má arsiu? Sinih a tari singin á him erei? Ái Káláu? Ngo a hut sang tili kán holhol sár?” ");
INSERT INTO sgz_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Má dik nguruk arliu i di sang ngoromin, “Ngo gita parai ngo ái Káláu a tarwa Ioanes ur main, ki na parai ngo, ‘Suri dáh kápgamte ruruna i kán pinpidan?’ ");
INSERT INTO sgz_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Má ngo gita parai ngo káián sang ái Ioanes a hut tili kán hol sang, ki matananu da bás bing git kabin di ruruna i Ioanes ngo ái á tám worwor tus káián ái Káláu.” ");
INSERT INTO sgz_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Má ngorer ding kos Iesu ngoromin, “Kápgimte mánán.” ");
INSERT INTO sgz_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Mái Iesu a longrai ngorer mák parai si di ngo, “Á iau mul káp ina te parai si gam ngo ái sinih a tari nokwan singing má iak longoi bos táit minái.” ");
INSERT INTO sgz_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Mái Iesu a parai kesi worwor artálár narsán tan kálámul ngoromin, “Kesi kálámul a soi kesi numán wain má a tar páksi singin bos tám himhimna mák han alar di suri na lala kis i malar tepák. ");
INSERT INTO sgz_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Má namur ngo ákte arwat i pákánbung suri lus talmi wán wain, io a dos palai kesi tám arardos suri kip te risán wán wain tili kán num. Mái sár bos tám himhimna di mákái tám arardos erei a hut narsá di, má di ubi má dik dos pala kalengnai mai wáin limán. ");
INSERT INTO sgz_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Namur kákán num a dos palai kesi tám arardos mul, mái sár bos tám himhimna di ubi mul má di abilbilingnai sang má di dos kalengnai mai wáin limán. ");
INSERT INTO sgz_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Má a dos palai mul i átuil tám arardos má bos tám himhimna dik up sáksáknai mul ngorer má dik buswa aso palai tili polgon numán wain. ");
INSERT INTO sgz_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Má kálámul er káián á numán wain a parai singin sang ngo, ‘Dánih má ina longoi? Ina dos palai natung, kang kalik alal. Te ngoi gut da rumrum on má kápdate ubi.’ Má ngorer ák dos palai mái natun. ");
INSERT INTO sgz_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Mái sár bos tám himhimna di mákái ngorer ki dik worwor arliu i di ngoromin, ‘Mákái, erei mái natun, ái koner na tur kelsen. Gita up bingi suri numán wain na ur kángit!’ ");
INSERT INTO sgz_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Má ngorer di tolai má dik buswa aso palai tilami numán wain má dik up bingi.” Má ngo ái Iesu a arahi puksai worwor artálár erei, ki ák gálta di ngoromin, “Dánih má na longoi á kálámul er káián á numán wain mai bos tám himhimna? ");
INSERT INTO sgz_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Bung na hut kaleng, na up bingi bos tám himhimna erei má na tari numán wain ur singin te lite tám himhimna bul.” Má ngo tan kálámul di longrai ngorer, ki dik parai si Iesu ngo, “Kápte sang a arwat ngo na ngorer!” ");
INSERT INTO sgz_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Mái Iesu a sálsálah aririu i di má ák gálta di ngoromin, “Gam hol on ngorer sár gam parai, ái sár Buk Tabu a parai lite ngoromin ngo ‘Hat erei bos tám long rum di pukpukwai, mái sár ái Káláu a aksimi hat erei suri áng kábutkis si di no á tan hat.’ ");
INSERT INTO sgz_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Má tara dáh da pur uri iátin hat erei da tu gingin sáksák. Má ngo hat erei na pur uri tekes, na ekesi sá peksai má nák mat.” ");
INSERT INTO sgz_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Má bos tám mánán uri nagogon má bos pakpakta kán tan tám osmapak di mánán tangrai ngo ái Iesu a para tusi worwor artálár er a arwat mam di, má ngorer dik nem suri kabat Iesu i án pákánbung erei sang. Mái sár kápdite long arwat pasi kabin di bulat suri matananu. ");
INSERT INTO sgz_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Má ngorer di mák tangra Iesu suri dánih na longoi. Má dik long pas te kálámul mul má dik hul di suri da pidir pas Iesu suri te worwor a sák na parai, má namur da atatir uri Iesu singin kálámul pakta til Rom suri ngorer da tar Iesu sang uri limán suri nák nagogon on. Má tan kálámul er di hul di, di hut narsá Iesu mai kándi angagur ngo di muswan mai kándi argátna, ");
INSERT INTO sgz_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","má dik parai singin ngoromin, “Tám Aratintin, gim talas ngo iáu lu worwor má aratintin mai támin muswan. Má gim talas mul ngo kápute lu tur i kesi risán masik, má iáu lu atintini matananu mai muswan suri sál si Káláu. ");
INSERT INTO sgz_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Gim nem ngo una bit gim be. A mángát á kángit nagogon ngo gita tar takis ur si Kaisar? Ngádáh, gita tari ur si Kaisar ngo kápte?” ");
INSERT INTO sgz_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Mái sár ái Iesu a mák ilmi ngo da pidir pasi, má ngorer a parai si di ngo, ");
INSERT INTO sgz_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Gam kip tekesi pirán tabal inak mákái. Sinih á tantanián má ngisán á minái di le on?” Má di kos Iesu ngo, “Ái Kaisar.” ");
INSERT INTO sgz_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Mái Iesu a parai mul si di ngoromin, “A kuluk. Gama tari sang si Kaisar táit káián ái Kaisar. Má táit káián ái Káláu, gama tari sang si Káláu.” ");
INSERT INTO sgz_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Má kápdite arwat ngo da pidir pas Iesu i mátán matananu suri tekesi táit a parai. Wa di longrai ngorer a kokos ái Iesu má dik pángáng, má ngorer di tu kis pau sár. ");
INSERT INTO sgz_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Má namur te á bos Sadukaio di han suri gálgálta i Iesu, di ái rung er kápdite ruruna ngo kálámul erei a mat na liu kaleng mul i liu namur. ");
INSERT INTO sgz_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Di hut narsá Iesu ngorer má dik parai ngoromin, “Tám Aratintin, ái Moses a le i nagogon minái ur si gim. Ngo kálámul a mat alar kán wák má kápate kákáh ái kán wák singin, ái tuán na kila pasi bul i kán mokos suri nák mon i natun suri ngisán ái kákán na liu pagas sang. ");
INSERT INTO sgz_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","“Má ahit i aratuán. Mulán i di a kila, má namur ák mat má kápte te natun be. ");
INSERT INTO sgz_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ngorer má áruán i di a kila pasi bul i mokos sár erei, má namur a mat má kápte besang te natun. ");
INSERT INTO sgz_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Má namur átuil i di a ngorer mul. Má ngorer ahit no á aratuán er, di kila pasi kes sár á wák, má di no di mat alari má kápate mon i te nat di singin wák er. ");
INSERT INTO sgz_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Má namur má, wák mul ák mat. ");
INSERT INTO sgz_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ki namur di no da liu kaleng i liu namur, sinih sang má tili di na kán wák muswan á wák erei, kabin ahit no di kila pasi?” ");
INSERT INTO sgz_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ái Iesu a longrai ngorer máng kosoi boh Sadukaio ngoromin, “I liu án naul bim onin tan kálámul má tan wák di lu kila. ");
INSERT INTO sgz_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Mái sár i liu namur, kápte. Ái rung er di nokwan i mátán ái Káláu, da aptur kaleng alari minat má kápdate lu kila ");
INSERT INTO sgz_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","kabin kápdate mat mul. Da liu ngoro boh angelo má da rang natun ái Káláu kabin dikte aptur kaleng tili minat. ");
INSERT INTO sgz_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Gam ruruna ngo rung di mat kápte da liu kaleng. Mái sár ái Moses a para inngasi ngo a mon sang á apaptur kaleng. Gama wásái er i kuir pinpidan a le on ái Moses mák puksai aun kubau a inan má kápate bam. On á kuir erei, ái Moses a utung Káláu ngo ái á Káláu káián ái Abaram má Káláu káián ái Aisak má Káláu káián ái Iakop. Git talas ngo sálán kán worwor er ngo káksiai ngo dituláte mat má, ditul liu be má ditulá lu lotu uri narsán ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ái rung er di lu lotu uri narsán ái Káláu, káksiai ngo kápán páplun i di ákte mat, wa di á tan liuán kálámul sang. Uri mátán ái Káláu, di no di liu pagas.” ");
INSERT INTO sgz_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Má te tám mánán uri nagogon di iatung di parai si Iesu ngo, “Tám Aratintin, kam kokos er a kuluk.” ");
INSERT INTO sgz_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Má di parai ngorer kabin kápte kes mul tili di a mangan suri bali gálta Iesu. ");
INSERT INTO sgz_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Mái Iesu a gálta di ngoromin, “Bos tám mánán uri nagogon di parai ngo Mesaia ái á natun ái Dewit, be? Ngádáh a ngoi? ");
INSERT INTO sgz_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Má kes mul á aratintin, ái Dewit sang a parai sur Karisito iatung i buk án parpara agas ngo, ‘Ái Káláu a parai singin kang Konom ngoromin, “Una kis main i risán minging suri da árnga iáu, ");
INSERT INTO sgz_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","má iau ina suka bámiai kam tan kurtara uri lalin kikim má ina arumrum di.” ’ ");
INSERT INTO sgz_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ki ngádáh a ngoi ngo Mesaia a sumlahin ái Dewit má ái sár mul á kán Konom? A kabin ái Dewit a mák ilmi ngo Mesaia ákte kis má i pákánbung er. Ngorer a talas ngo Mesaia a sumlahin ái Dewit, má ái sár á kán Konom mul.” ");
INSERT INTO sgz_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Má marán matananu di iatung be má dik longra Iesu ák parai ngoromin ur singin kán kalilik án aratintin, ");
INSERT INTO sgz_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Gama ololoh suri tatalen káián bos tám mánán uri nagogon. Di lu parmat mai salsaliu tangrai sál mai kandi mermer a dol suri tan kálámul da lu rumrum i di. Di nem ngo matananu da lu árár pas di i pokon án sirsira, má dik lu nem mul suri sukis i tan kiskis táil i rumán lotu, má i bos longsit dik lu nem i sukis i kiskis erei matananu da rumrum i di ái. ");
INSERT INTO sgz_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Di lu agur pasi minsik kán tan mokos, má dik lu longoi dolon sung suri agurái matananu dák mák di ngo di tám nokwan. Na lala sorliu á kándi rangrangas namur!” ");
INSERT INTO sgz_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ái Iesu a iatung i rumán osmapak i kuir rum er di lu obop pirán tabal ái, má a mákái tan konom di tari kandi artabar uri nián omobop. ");
INSERT INTO sgz_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Má a mákái mul i kesi maris án mokos a han mák oboi aru gengen pirán tabal sár. ");
INSERT INTO sgz_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Má a parai si di ngo, “Mákái! A támin muswan iau parai si gam, maris án mokos minái a tari a pakta si di no ái rung di obop pirán tabal main i nián omobop, ");
INSERT INTO sgz_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","kabin ái rung er di tari gengen risán sár tili kandi tilik omobop má ngorer kápdite sáhár. Mái sár ái koner a maris muswan a tar noi sang i kán pirán tabal erei a mon singin ngo na tángni kán liu.” ");
INSERT INTO sgz_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Má te kálámul iatung di mákái lalain hat dikte longoi rumán osmapak mai má tan táit erei matananu dikte artabar mai uri narsán ái Káláu uri merei rumán osmapak. Di mákái ngorer ki kandi tu parai rumán osmapak ngo a lain mák kuluk. A longrai ngorer ái Iesu mák parai si di ngo, ");
INSERT INTO sgz_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Tan táit imuni kamu tu mákái, kápnate kis ngorer namur. Na hut besang i bung erei ngo tan kurtara da suh pala noi tan hat má da buswa sarai uri bim, má kápte kesi hat na lu kis i nián.” ");
INSERT INTO sgz_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Má tan kalilik án aratintin di gálta Iesu ngo, “Awái, Tám Aratintin, unák bit gim be á iáu suri tan táit minái. Enges na hut, má dánih á akiláng gima mákái suri mák ilmi ngo ákte páput má?” ");
INSERT INTO sgz_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Mái Iesu a parai si di ngoromin, “Gama ololoh kuluk suri koion á tekes na lam bengta gam. Kabin marán da hut má da arbin mai ngisang má dák parai ngo, ‘Á iau á Mesaia!’ má ‘Ákte hut á pákánbung án arahrahi!’ Mái sár koion gama mur i di. ");
INSERT INTO sgz_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Koion gama ráuráuwas erei ngo da bit gam suri arup iamunang tepák má iatung páput mul. Tan táit erei na mulán hut sang, má kápte besang á arahrahi.” ");
INSERT INTO sgz_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Mái Iesu a parai mul ngo, “Kesi matananu na aptur má nák arup mai kesi matananu sang. Má bos mát mul da ngoi, kesi mát na arup mai kesi mát. ");
INSERT INTO sgz_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Na hut i tara kunkun, má taul itol má toltolom sasam mul na hut arkaliut i te tan balis. Má tilami armongoh tara akiláng na hut, má matananu da ngátngát on má nák aráuráuwas i di. ");
INSERT INTO sgz_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Mái sár kápnate hut besang á bos táit erei, má da long sáksákna gam. Da lu tola gam má da lu arangrangas i gam, ngorer da talka gam uri rumán lotu má dák lu nagogon i gam iatung, má da obop gam i batbat kalar mul. Má káplabin sur iau, gama lu tur i nagogon i mátán táil i boh kabisit má boh tám nagogon. ");
INSERT INTO sgz_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","I bung erei gama tur i nagogon, erár má pákánbung gamák para talsai uri narsá di á kamu ruruna uri iau. ");
INSERT INTO sgz_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Má koion gama konngek suri worwor ngádáh gama parai er gama tur i nagogon. ");
INSERT INTO sgz_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kápkabin á iau ina apos tari polon á hol si gam suri matngan wor ngádáh gama parai i pákánbung er, má kamu tan kurtara kápdate arwat ngo da kos gam má puai kamu worwor er. ");
INSERT INTO sgz_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Má da lu agur tar gam mul ái rang kák gam mái rang mám gam má rang buh gam ngo rang tur gam, má dák lu tar gam uri limán bos tám nagogon má da obop te tili gam uri minat. ");
INSERT INTO sgz_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Má matananu no da mikmikwa gam káplabin sur iau. ");
INSERT INTO sgz_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mái sár kamu liu muswan na tur pagas, a ngoro kápte kesi towon nih gam na bokoh. ");
INSERT INTO sgz_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Má kápkabin gama sámtur rakrakai, ngorer gama atur páptai liu muswan sang er a kis áklis.” ");
INSERT INTO sgz_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Mái Iesu a sopasun i kán worwor mák parai ngoromin, “Mái sár namur gama mákái tan kálámul án arup da tur kauli bimán rum á Ierusalem, ki erár gamák mánán ilmi ngo bimán rum á Ierusalem páput má na mosrah no. ");
INSERT INTO sgz_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Má ngo gam tara Iudáiá gama mákái táit erei, ki gama táu uramuni pungpung. Ái koner ngo na iatung i lol malar na tu táu sár. Mái rung di iatung i karpala kápdate kusak mul urami, ");
INSERT INTO sgz_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","kabin bung erei pákánbung án arangrangas. Má on á pákánbung erei ái Káláu na long arwat pas noi tan worwor tus dikte le on suri bung erei. ");
INSERT INTO sgz_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Keskam si di á tan wák erei di tián mái rung di kis tinánkak mai goion kalik. Tilik rogorogo na hut i balis á Israel mái Káláu na tari rangrangas singin kán matananu. ");
INSERT INTO sgz_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ngorer tan kurtara da tár bing te tili di mai kandi tan is án arup, má te da talka di uri tan balis tepák má da batbat kalar di ái. Má tan lite kálámul, rung tili risán, da suka bámiai bimán rum á Ierusalem. Má pákánbung kandi ái rung tili risán na turpasi tilatung nák han pang i bung ái Káláu ákte parai ngo na rah ái i kandi pákánbung.” ");
INSERT INTO sgz_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Mái Iesu a sopasun i kán worwor mák parai ngo, “I bung erei sang, da mákái á tan akiláng na hut soura iamuni armongoh uri nas má kalang má boh mátmátiah. Má main i naul bim, matananu da ngátngát sálán tas er a lala gusgus má tara kaungán pákán nah a pos. ");
INSERT INTO sgz_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Má tan táit a mon i rakrakai i di iamuni armongoh, da dikdikdik ngorer i kunkun a gunra di. Má tan matananu da lu mákái tan táit erei má dák lu mat palpal mai mátut, kabin da hol tusi má ngo tilik sápkin bung na tapam hut i naul bim. ");
INSERT INTO sgz_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Má namur da mákái Natun Kálámul na hut soura tili kumlán mehmeh tiklik mai kán rakrakai má mai tilik minmáir mul. ");
INSERT INTO sgz_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Má ngo gama mákái tan akiláng erei ákte turpasi má, erár gama tántán urami kabin erei mái Káláu a hut suri aliu pas gam.” ");
INSERT INTO sgz_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Mái Iesu a parai kesi worwor artálár uri narsá di ngoromin, “Gama kipi tohtohpas tili rarah má boh kubau mul. ");
INSERT INTO sgz_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ngo gam mákái di oboi hutngin pákán i di, ki erár gamá mák ilmi má ngo taul ráin ákte páput sár. ");
INSERT INTO sgz_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Má ngorer sár mul, ngo gamáte mákái tan táit erei ákte lu huthut, ki gama mánán ngo ákte páput má pákánbung suri na tapam hut á lolsit si Káláu. ");
INSERT INTO sgz_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Támin muswan iau parai si gam, ngaul matananu minái kápdate mat besang má nák tapam hut á tan táit erei. ");
INSERT INTO sgz_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Naul bát má naul bim na bokoh, mái sár kak pinpidan kápnate pah.” ");
INSERT INTO sgz_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Mái Iesu a sopasun i kán aratintin mák parai ngoromin, “Gama ololoh kuluk i gam sang suri koion na taun pápta gam i tan táit til main i naul bim ngorer i talar mai gong kári namnam má dan a rakai, má konngek mul suri tan táit uri tángni liu. Gama ololoh kuluk suri bung káián Natun Kálámul na mák hut asodar i gam ngorer i pidir di banai tangrai bos. ");
INSERT INTO sgz_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kabin bung erei na hut sang singin tan kálámul no di kis i naul bim. ");
INSERT INTO sgz_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mái sár gama ololoh kuluk má gama sung áklis suri na mon i kamu rakrakai arwat suri gama tur atu i pákánbung tan táit erei na tapam hut, má i pákánbung gama sámtur i nagogon i mátán táil ái Natun Kálámul.” ");
INSERT INTO sgz_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","I boh bung erei no, ái Iesu kán tu aratintin ami rumán osmapak. Má ngo a lu rahrah má, ái Iesu a lu láklák kaleng urami pungpung á Oliwa má ák lu bop ái. ");
INSERT INTO sgz_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Má i ngahwán kábungbung sang, marán kálámul di lu saum suri longrai aratintin si Iesu ami rumán osmapak. ");
INSERT INTO sgz_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Má bung suri longsit án ani beret káp a tini sut ákte páput sár má, er di utngi mai longsit án sorliu palai mul. ");
INSERT INTO sgz_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Má boh pakpakta kán tan tám osmapak má tan tám mánán uri nagogon, di tohoi suri ser te sál suri up bing kodongna Iesu suri matananu kápdate mánán on, kabin di matai matananu da mák up di. ");
INSERT INTO sgz_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Io, ái Satan a kusak uri Iudas Iskariot, kes tili di á sángul mai aru á kalik án aratintin. ");
INSERT INTO sgz_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Má namur ái Iudas a so alar Iesu di, mák han hut i narsán boh pakpakta kán tan tám osmapak má tan tátáil káián boh tám arup er di lu mákmák kári rumán osmapak, suri ngádáh na agur tar Iesu ngoi uri narsá di. ");
INSERT INTO sgz_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Má ngo di longrai táit na longoi ái Iudas, a gas i bál di má dik oror suri da tar te pirán tabal singin. ");
INSERT INTO sgz_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Má a sormángát sang ái Iudas suri na agur tar Iesu ur si di, má ngorer a ser sál suri na longoi i pákánbung kápdate mánán on i matananu. ");
INSERT INTO sgz_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","8","Tatalen kán tan Iudáiá a ngoro minái. I libung táilnai longsit án ani beret káp a tini sut, di lu up bingi tan gengen sipsip suri da ani uri akiláng i longsit án sorliu palai. Ngorer má i bung erei sang, ái Iesu a dos pala Petero mái Ioanes mai worwor talas a parai si diar ngoromin, “Gaura han má gaurák eran i ángit namnam suri gita ani uri akiláng i longsit án sorliu palai.” ");
INSERT INTO sgz_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Má diará gálta Iesu ngo, “Be, ai u nem on ngo giura han ur ái má eran i namnam án sorliu palai?” ");
INSERT INTO sgz_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","A longrai ngorer ái Iesu má a parai si diar ngoromin, “Gaura han urami Ierusalem, má kesi kálámul a kipi átbán dan na bana gaur. Gaura mur on uri rum er na kusak ur on má gauráng kusak namurwai. ");
INSERT INTO sgz_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Má gaurák parai singin kálámul er káián á rum ngo, ‘Ái Tám Aratintin a nem i mánán i rum dáh na kis on suri ani namnam án sorliu palai tiklik mai kán kalilik án aratintin.’ ");
INSERT INTO sgz_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Má namur ái sang na lam gaur má nák inngas tari lala rum ami iát erei ákte leget on, má gaura eran i namnam iatung.” ");
INSERT INTO sgz_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Má ngorer aru kalik án aratintin er diar aptur má diará han urami Ierusalem má diará mákái sang á tan táit ngorer ái Iesu ákte parai si diar, má diará eran i namnam án sorliu palai. ");
INSERT INTO sgz_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Má ákte ronron on á bung erei, ái Iesu tiklik mai kán kalilik án aratintin er ák utung di mai tan apostolo, di sukis suri namnam. ");
INSERT INTO sgz_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Má ái Iesu a parai si di ngo, “Kak lala nemnem suri ina ani á namnam án sorliu palai minái tiklik mam gam i pákánbung inái káp iau te áslai besang á rangrangas. ");
INSERT INTO sgz_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Má iak para talsai si gam ngoromin. Minái sár á namnam án sorliu palai iau ani, má káp ina te ani mul nák han pang i bung erei lolsit káián ái Káláu na hut, má kak him na rah no, á him erei longsit án sorliu palai a akiláng on.” ");
INSERT INTO sgz_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Namur ái Iesu a long pasi kinleh wain mák sung kári, má ák parai ngo, “Top pasi kinleh wain min, má gam no keskeskes gama nginmi. ");
INSERT INTO sgz_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Támin muswan iau parai si gam ngo káp ina te ngin on mul á suir wain nák han pang i bung erei lolsit si Káláu na hut.” ");
INSERT INTO sgz_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Namur mul ái Iesu a long pasi kesi tigán balbal mák sung kári, má ák tibi mák tari singin kán kalilik án aratintin má ák parai si di ngoromin, “Minái á kápán páplun i iau, má ái á osmapak uri narsán ái Káláu suri asengsegeng i gam. Turpasi onin, gama lu tibi balbal má gamák lu ani suri ngorer gama lu bálbálsa sur iau.” ");
INSERT INTO sgz_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Má ngo ákte rah mái namnam, ái Iesu a parai ngoromin mul si di suri kinleh wain er a tabar di mai, “Kinleh wain minái a akiláng i hutngin kamkabat káián ái Káláu a kápti mai dárang na sal suri hul aliu pas gam. ");
INSERT INTO sgz_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Má mákái! Ái koner na agur tar iau, minái ái, git namnam tiklik. ");
INSERT INTO sgz_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","A támin muswan ngo Natun Kálámul na han mur arwat pasi sál suri minat ngorer ái Káláu ákte para páksi. Mái sár na tuan sák bul uri kálámul er na agur tari Natun Kálámul!” ");
INSERT INTO sgz_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Má kalilik án aratintin di longrai ngorer a parai ái Iesu má di lala holhol, má ngorer di turpasi nguruk. Má di gálta arliu i di sang ngo ái sinih tili di ngo na longoi ngorer. ");
INSERT INTO sgz_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Má namur tan kalilik án aratintin di turpasi wor arkuh i katbán i di sang suri ngo ái sinih tili di a kálámul pakta kandi. ");
INSERT INTO sgz_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Mái Iesu a parai si di ngo, “Tan kabisit kándi ái rung tili risán di lala apakta pas di sang má dik lu suka bámiai matananu. Mái sár di nem on ngo matananu da lu utung di mai ‘Tan Tám Artangan’ kabin ngo di kaiang pasi ngo di lu tángni matananu. ");
INSERT INTO sgz_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mái sár á gam kápte gama ngorer! Wa gama ngoromin sang. Ái koner a pakpakta i katbán i gam, na ngoro gengen kalik. Mái koner a tátáil, na tám toptop sár. ");
INSERT INTO sgz_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ái sinih a pakta, ái koner a sukis suri namnam ngo tám toptop a han mai namnam suri támri? Wa a muswan, ái koner a sukis, ái a pakta. Mái sár á iau, iau kamu tátáil, iau min i katbán i gam ngoro tám toptop sár. ");
INSERT INTO sgz_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","29","“Ákte tari kán lolsit ái Tata ur singing suri ina kátlán. Má kabin gamáte muswan uri narsang i tan pákánbung án aramikmik má rangrangas, ngorer á iau bul ina tari si gam á nokwan ");
INSERT INTO sgz_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","suri gita namnam má ngin tiklik ami kak lolsit, má suri gama kis i kiskis án kabisit suri nagogon i sángul mai aru á mát til Israel.” ");
INSERT INTO sgz_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Mái Iesu a parai ngo, “Saimon! Gam longrai, ái Káláu ákte sormángát pala Satan suri na isra toh gam ngorer di lu israi pokori ngoi er di raksai. ");
INSERT INTO sgz_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Mái sár iakte sung Káláu sur iáu, Saimon, na mák pur i kam ruruna. Má namur, ngo ukte ilang kaleng má ur singing, ki una lu arakrakai i ruruna káián rang turam.” ");
INSERT INTO sgz_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Mái Petero a kos Iesu ngo, “Auh, Konom, káp ina te totol suri ina han uri batbat kalar mam iáu má suri ngo gitara mat tiklik!” ");
INSERT INTO sgz_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Mái Iesu a parai si Petero ngo, “A muswan iau parai singim. Inái i libung, kok kápnate tang besang, má una arkawar pala iau na tul i pákán má una parai ngo kápte u mánán i iau.” ");
INSERT INTO sgz_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Mái Iesu a gáltai kán tan kalilik án aratintin ngo, “Tungu iau dos pala gam suri arbin talas mai lolsit si Káláu. Pákánbung er kápte gam kip te rat ngo bákbákar kek, be? Ki ngádáh, gam sáhár suri tekesi táit ngo kápte?” Má tan kalilik án aratintin di parai singin ngo, “Kápgimte sáhár sur tekesi táit.” ");
INSERT INTO sgz_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Má ngorer ái Iesu a parai si di ngoromin, “A kuluk. Mái sár inái ái koner a mon i kán rat na top on, mái koner kápte kán is pakta uri arup, na sirai tekesi lusán pas te pirán tabal má nák hul pas tekesi is ur káián. ");
INSERT INTO sgz_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Na longoi ngorer kabin pinpidan tili Buk Tabu di le on sur iau alhirá er di parai ngo, ‘Dikte wásái turán tan tám abulbul’, worwor erei na tapam hut muswan onin. Áá, tan táit no erei tan tám worwor tus dikte sir páptai sur iau na tapam hut!” ");
INSERT INTO sgz_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Má tan kalilik án aratintin di parai singin ngo, “Mákái, Konom. Minái á aru is pakta.” Mái Iesu a kos di ngoromin, “A arwat sár má! Koion gita para te táit mul!” ");
INSERT INTO sgz_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","A rah i kán worwor ái Iesu, má ngorer a aptur má ák so alari rum mák han uramuni pungpung á Oliwa ngorer a lu balbal longoi sang, má tan kalilik án aratintin di tiklik mai. ");
INSERT INTO sgz_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Má ngo dikte hut iatung i pokon er a nem on, ái Iesu a parai si di ngoromin, “Gama sung Káláu suri koion gama pur i pákánbung án artohtoh.” ");
INSERT INTO sgz_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Má ngorer a kálik láklák tepák án mudán alar di ái Iesu, má a pur dirtapul má a sung ngoromin uri narsán ái Káláu, ");
INSERT INTO sgz_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Keskam, Tata, iau sung iáu ngo a ngoi i balam, una long palai á kinleh án arangrangas má minat minái alar iau. Mái sár káp una te mur i kak nemnem, una mur on ngorer i kam nemnem sang.” ");
INSERT INTO sgz_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Má kesi angelo tilami bát a hut si Iesu má a tari rakrakai singin. ");
INSERT INTO sgz_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Mái Iesu a sung rakrakai kabin taun a iaungi kán liu, má ngorer a songsong turán, má kán songsong a sal ngoro lokon dár má a tim uradi bim. ");
INSERT INTO sgz_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Má namur a arahi kán sung ái Iesu, má a láklák kaleng suri kán kalilik án aratintin má a mák di di boptin, kabin a lala tabureng i kandi liu. ");
INSERT INTO sgz_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Mái Iesu a parai si di ngo, “Suri dánih gam boptin? Gama pán má gamák sung suri koion gama pur i pákánbung án artohtoh.” ");
INSERT INTO sgz_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ái Iesu kán tu worwor be mai kán kalilik án aratintin, má i án pákánbung er matananu di hut iatung. Ái Iudas, kes tili di á sángul mai aru á kalik án aratintin, a lam di uratung má ngorer a láklák sur Iesu má a doroi pair. ");
INSERT INTO sgz_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Mái sár ái Iesu a parai singin ngo, “Iudas, ngádáh? Una agur tari Natun Kálámul mai ardor?” ");
INSERT INTO sgz_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Má tan kalilik án aratintin er di iatung mam Iesu di mákái ngo matananu da tola Iesu má, ki dik gálta Iesu ngo, “Ngádáh, Konom, arwat ngo gima up di mai kángim tan is?” ");
INSERT INTO sgz_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Má ngorer kesi kalik án aratintin ák taruh pasi kán is mák tárái toptop káián tám osmapak táil uri talngán mák tár kus palai talngán mingin. ");
INSERT INTO sgz_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","A mákái ngorer ái Iesu má a tur kalar di mák parai ngo, “Koion gama arup! Arwat má!” Io, a sarsara ái Iesu má a top i talngán kálámul er má a ting i dár mák sengsegeng mul. ");
INSERT INTO sgz_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Mái rung di han uratung suri da tola Iesu, di tan pakpakta kán tan tám osmapak má tan tátáil káián rung di lu mákmák kári rumán osmapak má tan kálámul pakta mul. A mák di ái Iesu má a parai si di ngo, “Ngádáh, gam hol on ngo á iau kesi tám ngákngák ngorer gamá hut mai kamu boh papam suri gama up iau mai má kabat pas iau? ");
INSERT INTO sgz_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Marán á bung iau lu kis i katbán i gam ami rumán osmapak, má iau lu atintini matananu ái. Má suri dáh kápgamte tola iau i pákánbung er? Na, káksiai má, kabin rakrakai káián ái koner tili kuron a kátlán i pákánbung minái, má ngorer kamu pákánbung sang á inái suri gama longoi ngorer mam iau.” ");
INSERT INTO sgz_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Má tan kálámul erei di tola Iesu, má dik talkai uri rum káián tám osmapak táil, mái Petero a kálik lu murmur su til namur. ");
INSERT INTO sgz_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Má kámnah dikte oloi iatung i pelbut i rum, má ái Petero a hut iatung má ngorer a han kis tiklik mam rung iatung di kis kauli kámnah. ");
INSERT INTO sgz_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Má kesi tahlik a tám toptop a mákái aur ái Petero uri talsán kámnah. Má wák erei a lala mákái sang má a mák ilmi, má ngorer a parai ngo, “Kálámul minái a lu tiklik mam Iesu!” ");
INSERT INTO sgz_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Mái Petero a arkawar palai má a parai ngoromin, “Wák mer, wa kápte iau mánán on á kálámul er!” ");
INSERT INTO sgz_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Má namur kesi kálámul a mák Petero mák parai singin mul ngo, “Á iáu kes tili di á kalilik án aratintin si Iesu.” Mái sár ái Petero a kosoi kálámul er ngoro minái, “Na, á iau á kápte!” ");
INSERT INTO sgz_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ákte mongmong pala Petero er ákte sukis iatung, má kesi kálámul bul a lala atiutiu Petero ngo, “A muswan, wa kálámul minái a lu tiklik mul mam Iesu kabin ngo ái á kakun Galiláiá!” ");
INSERT INTO sgz_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Mái sár ái Petero a kosoi kálámul er ngoro minái, “Awái, wa kápte iau mánán á táit erei kam tu parai uri iau!” Má kán tu worwor be ái Petero, ki ák tang i kok má. ");
INSERT INTO sgz_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Io, i pákánbung a tang i kok, a ilang ái Konom má a mákmák nokwan sur Petero. Mái Petero a mákái ngorer má a hol pasi worwor er a parai singin ái Konom ngo, “Inái i libung, i pákánbung kápnate tang besang á kok, una arkawar pala iau na tul á pákán.” ");
INSERT INTO sgz_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ái Petero a hol pasi worwor erei má ák tinang i bál suri, má ngorer a so tilatung mák lala tang. ");
INSERT INTO sgz_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Má tan kálámul iatung er dikte tola Iesu, di tartar retret mai má dik rapsi. ");
INSERT INTO sgz_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Namur di kápti mátán mai sepen kaen suri kápnate mákmák, má di gáltai ngo, “Una utung tusi ngo ái sinih er a up iáu!” ");
INSERT INTO sgz_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Má di wor sáksák uri Iesu má dik ot bilingnai mul. ");
INSERT INTO sgz_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Má ngo ákte arasa má i bung erei, tan kálámul pakta di kis i kaunsel, á di á bos pakpakta kán tan tám osmapak má tan tám mánán uri nagogon. Di hut talum má ngorer di lam pas Iesu uratung i narsá di suri da longrai kán te worwor. ");
INSERT INTO sgz_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Di gálta Iesu ngo, “Una parai si gim be. Ngádáh, á iáu á Mesaia?” Mái Iesu a kos di ngoro minái, “Ngo ina parai si gam ngo á iau á Mesaia, káp gama te ruruna i iau. ");
INSERT INTO sgz_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Má ngo ina gálta gam erei, ngádáh? Gama kos artálár pas iau? ");
INSERT INTO sgz_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Má iau parai si gam ngo turpasi onin Natun Kálámul na kis i risán mingin ái Káláu Tám Rakrakai Sorsorliu!” ");
INSERT INTO sgz_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Di longrai ngorer a parai ái Iesu, má di no sang di gáltai ngo, “Ki ngádáh, iáu parai ngo iáu Natun ái Káláu, be?” Má a kos di ngoromin, “Áá, a ngorer sár gam parai.” ");
INSERT INTO sgz_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ngorer má ák mos i bál di má dik parai ngo, “Gitáte longrai sár á kán worwor sáksák a so tili ngudun sang! Má suri dánih gita longra te apapos mul ur on?” ");
INSERT INTO sgz_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Má di no iatung di aptur má di long pas Iesu uri mátán táil ái Pilato, kálámul pakta til Rom, ");
INSERT INTO sgz_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","má di turpasi suri atiutiu Iesu, ngorer má di parai ur on ngoro minái, “Gim top on á kálámul minái má gimá ser pasi ngo a lam bengtai matananu, ngorer má a tur kalar gim suri koion gima tar takis ur singin pakpakta til Rom, má a kaiang pasi mul ngo a Mesaia má kángim kabisit muswan.” ");
INSERT INTO sgz_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ái Pilato a longrai ngorer mák gálta Iesu ngo, “Ngádáh, á iáu á kabisit káián tan Iudáiá?” Mái Iesu a kos Pilato ngoromin, “Áá, a ngorer sang ukte parai.” ");
INSERT INTO sgz_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Io, ái Pilato a parai uri narsán boh pakpakta kán tan tám osmapak má uri narsán lala matananu iatung ngo, “Kálámul minái, káp iau te ser pas te sápkin a long bengtai suri ina nagogon on.” ");
INSERT INTO sgz_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Mái sár matananu di rakrakai sang mai balbal parai ur on ngo, “Ái a arbin i katbán matananu mák soksokoi bál di má di kis sáksák. A tangkabin sang ami Galiláiá ngorer má a han tangrai boh balis á Iudáiá, má onin ákte hut mainái.” ");
INSERT INTO sgz_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ái Pilato a longrai ngorer, ki ák gáltai rung erei di atiutiu Iesu ngo, “Be, kálámul minái a kakun Galiláiá?” ");
INSERT INTO sgz_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ki dik mángát ngo, “Áá, kálámul minái til Galiláiá sang.” Io, ái Pilato a mánán pasi má si rung er ngo ái Iesu tili balis er ái Erodes a kátlán má ái Iesu a kis i lalin nagogon si Erodes. Ái Pilato a mánán ngo ái Erodes ákte han til Galiláiá ur Ierusalem i pákánbung er, má ngorer ái Pilato a ardos má dik lam Iesu uri narsán ái Erodes suri nák longrai sang. ");
INSERT INTO sgz_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ái Erodes ákte longrai arbin sur Iesu má a lala nem mul suri na mák Iesu ngo na long te akiláng. Má ngo ái Erodes a mák Iesu di lami uratung i mátán táil suri na longrai, a lala laes ");
INSERT INTO sgz_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","mák gálta Iesu mai marán argálta, mái sár ái Iesu kápate kosoi. ");
INSERT INTO sgz_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Má tan pakpakta kán tan tám osmapak má tan tám mánán uri nagogon di sámtur uratung táil má di rakai mai atiutiu Iesu. ");
INSERT INTO sgz_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Io, má ngorer ái Erodes má tan tám arup káián di turpasi suri tartar retret mam Iesu má dik ot bilingnai. Má namur di asolai kesi lain lusán uri páplun ái Iesu, mái Erodes a ardos suri da lam kalengna Iesu uri narsán ái Pilato. ");
INSERT INTO sgz_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ái Erodes mái Pilato káp diar te araturán, diar kis án kurtara. Mái sár i bung erei sang, diar turpasi suri araturán tiklik má. ");
INSERT INTO sgz_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ái Iesu dikte tangna kalengnai uratung si Pilato, má ngorer ái Pilato a bin talmi tan pakpakta kán tan tám osmapak má tan kálámul pakta má matananu no mul, ");
INSERT INTO sgz_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","má ák parai si di ngo, “Gam talka kalengnai kálámul minái uri narsang má gamá parai ngo a lam bengtai matananu. Iakte mákmák on á kálámul minái má gam no gamáte longrai. Mái sár kálámul minái gam atiutiwi, á iau káp iau te ser pas tekesi táit ngo ákte long bengtai. ");
INSERT INTO sgz_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Mái Erodes mul kápate ser pas te sápkin táit ákte longoi, má ngorer ák dos kalengnai má ur main si git. Kálámul minái kápate longoi sápkin arwat suri ina oboi uri minat. ");
INSERT INTO sgz_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Má ngorer ina dos i kak tan tám arup dák tasi sár, má namur ina arsok palai nák han.” ");
INSERT INTO sgz_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","I tan bungun longsit án sorliu palai, ái Pilato a lu mángát palai kesi kálámul tili batbat kalar, ái koner matananu di nem on. ");
INSERT INTO sgz_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Má matananu iatung dikte longrai worwor si Pilato er, má ngorer di no di lala bin sang ngo, “Up bingi nák mat ái koner si Iesu! Gim nem i Barabas á gim! Ái á kálámul una aso palai uri narsá gim.” ");
INSERT INTO sgz_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ái Barabas ái á kesá kálámul dikte oboi i batbat kalar kabin a ngákngák i nagogon til Rom má ák up bingi kálámul i kesá ororok ami Ierusalem. ");
INSERT INTO sgz_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ái Pilato a bali bin ur singin matananu suri ngo na asengsegeng i Iesu, ");
INSERT INTO sgz_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","mái sár ngo matananu sang di lala bin kaleng ngo, “Bás páptai! Bás páptai ái koner uri páspáng!” ");
INSERT INTO sgz_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mái Pilato a gálta di i átuil pákán mul ngo, “Suri dáh gama up bingi? Matngan sápkin ngádáh ákte longoi? Káp iau te ser pas te táit a sák ákte long bengtai á kálámul minái suri nák mat! Má ina dos i tan tám arup kaiak dák tasi sár, má namur má ina arsok palai nák han.” ");
INSERT INTO sgz_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Mái sár kaungán matananu a rakai sang mai balbal parai má bin urami ngo ái Iesu da bás páptai i páspáng, má kandi worwor a ian támin. ");
INSERT INTO sgz_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Má ngorer ái Pilato a taram i kandi nemnem má a sormángát pala Iesu suri nák mat. ");
INSERT INTO sgz_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","A pálás pala Barabas, kálámul er di sung pasi, má ái ái koner dikte oboi i batbat kalar suri a up bingi kálámul i katbán ororok. Mái sár ái Iesu, a sormángát tari ái Pilato suri na mat ngorer matananu di nem on. ");
INSERT INTO sgz_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Má ngorer tan tám arup di top pas Iesu má dik tangnai suri da bás páptai uri páspáng. Má ngo di lu hanhan tangrai sál, di banai kesi kálámul ngisán ái Saimon, kakun Sairini. Ái Saimon a lu hanhan suri han urami Ierusalem, mái sár di tur páptai má dik tari duk on suri ák puski kán kubau kus ái Iesu mák mur on mai. ");
INSERT INTO sgz_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Má tilik matananu di lu murmur i Iesu, má te wák tilatung i katbán i di a tinang i bál di sur Iesu má dik tangsi. ");
INSERT INTO sgz_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Mái Iesu a ilang mák lu mákái tan wák mák parai ngoromin, “Boh wák til Ierusalem, koion gama tangis iau, mái sár gama tangis gam sang má rang nat gam. ");
INSERT INTO sgz_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kabin na hut i matngan pákánbung er namur ngo matananu da parai ngo, ‘Di kuluk pala á tan koros má tan tahlik mái rung kápdite asus kalik be!’ ");
INSERT INTO sgz_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","I pákánbung erei má, tan kálámul da parai uri narsán tan ukung má pungpung ngo, ‘Una pur uri gim má unák punam gim! Gima riutais i iáu!’ ");
INSERT INTO sgz_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kuir pámán kábau kápnate inan i kámnah, mái sár kuir kábau a lain marang na mosrah no. Iau ngorer i kuir pámán kábau. Kápte kesi táit a sák iau longoi. Má ngo á iau iau áslai rangrangas, kápnate amosrah i iau. Mái sár rung er kápte di ruruna i iau, da áslai lala rangrangas sang má nák amosrah i di ngorer i kuir kábau a marang.” ");
INSERT INTO sgz_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tan tám arup di long pasi mul i aru tám ngákngák suri da up bing diar tiklik mam Iesu. ");
INSERT INTO sgz_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Má ngorer di hut iatung i kuir pokon di utngi ngo Koroson Lul, má namur di bás pápta Iesu uri kubau kus. Má aru i tám ngákngák mul di bás pápta diar uri aru kubau kus, kes tili mingin má kes tili káisán ái Iesu. ");
INSERT INTO sgz_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Mái Iesu a parai ngo, “Kang, kápdite mák ilmi táit min di longoi mam iau! Una hol palai sár alar di!” Kán sulu má lusán ái Iesu di hom satu pasi iatung ur kandi. ");
INSERT INTO sgz_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Má matananu di sámtur iatung di ialial, má tan tátáil kán tan Iudáiá di tartar retret mam Iesu má dik parai ngoromin, “A liu pasi tan lite kálámul sang. Má ngo ái á Mesaia muswan, ái koner ái Káláu ákte sormángát tari, ki na aliu pasi sang mul má nák sosih tilamuni páspáng!” ");
INSERT INTO sgz_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Má tan tám arup mul di tartar retret mai, má ngorer di tari wain a maptal singin suri nák nginmi, ");
INSERT INTO sgz_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","má dik parai singin ngoromin, “Ngo iáu á kabisit káián tan Iudáiá, ki una aliu pas iáu sang!” ");
INSERT INTO sgz_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Má di le i worwor er di nagogon on suri, má dik bás páptai uri kubau kus ami iátin lul. Worwor er a parai ngoromin, “Kálámul minái ái á kabisit káián tan Iudáiá.” ");
INSERT INTO sgz_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Má kesi tám ngákngák er di bás páptai iatung turán ái Iesu a para te sápkin worwor uri Iesu ngo, “Be, ngo á iáu á Mesaia, suri dáh káp unák aliu pas gitul no má?” ");
INSERT INTO sgz_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mái sár kesá tám ngákngák a tur kári turán er mák parai singin ngo, “Wai, wa kápute lu rumrum i Káláu á iáu? Gitul no minái, gitul áslai kesá rangrangas sár. ");
INSERT INTO sgz_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Má uri gitar a nokwan kápkabin gitar longoi sang á táit ngorer di arangrangas i gitar suri, mái sár kálámul minái kápte. Kápte kesi sápkin a longoi.” ");
INSERT INTO sgz_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Má ngorer a sopasun kán worwor ngoromin, “Iesu, una mámna iau má una hol pas iau erei ngo una turpasi kátlán i kam lolsit.” ");
INSERT INTO sgz_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Mái Iesu a parai singin ngo, “A támin muswan iau parai singim, onin una kis tiklik mam iau ami malar án laes áklis!” ");
INSERT INTO sgz_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Má i sángul mai aru á pákánbung, nas a kuron má a bohoi kunlán balis er, má kuron a pang i atul á pákánbung. Má tilik sepen kaen ami polgon rumán osmapak a ráp ák ru on. ");
INSERT INTO sgz_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Má namur ái Iesu a lala kilkil urami sang mák parai ngoromin, “Kang, iau bál palai taniang uri limam suri una ololoh on!” A parai ngorer ái Iesu mák mat. ");
INSERT INTO sgz_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Má tátáil kán bos tám arup a sámtur pagas iatung i risán. Má ngo a mákái tan táit ngorer a hut, ki ngorer a para agas Káláu mák parai ngo, “A támin muswan, kálámul minái, wa ái a tám nokwan.” ");
INSERT INTO sgz_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Má matananu er dikte hau talum iatung suri ialial di mákái tan táit ngorer a hut, má ngorer di kis án tinang má di turpasi tututi mansin i di tilatung kaleng urami kandi rum. ");
INSERT INTO sgz_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Má tan rang turán ái Iesu mai te wák dikte mur on til Galiláiá, di sámtur til tepák sár suri ialial má dik mákái tan táit erei mul. ");
INSERT INTO sgz_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Má kesi kálámul iatung, ngisán ái Iosep, má ái tili malar á Aramatia i balis á Iudáiá. Má ái á kes tili di á boh kaunsel káián tan Iudáiá, ái sár kápte a sormángát suri táit di longoi i tan rang táir mam Iesu. Má a lain kálámul má tám nokwan má a kis monai lolsit si Káláu suri na hut. ");
INSERT INTO sgz_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Mái Iosep a mánán i Iesu ngo ákte mat má, io ngorer a han uri narsán ái Pilato má a sung pasi páplun ái Iesu suri na tahni. ");
INSERT INTO sgz_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","A mángát ái Pilato sur Iosep ngo na tahun Iesu. Má ngorer a artari ái Iosep suri dik long pasi kápán páplun ái Iesu tili kubau kus ngorer má dik duri mai lain sulu. Má namur di kipi páplun ái Iesu uri tarang án minat dikte ili tungu tili bángbágil hat, má dik dung Iesu ái. Mátán hat er kápte be di dung tekesá kálámul on. ");
INSERT INTO sgz_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Má bungán eran on á bung er suri eran uri bungán aunges. ");
INSERT INTO sgz_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Má tan wák er di tiklik mam Iesu til Galiláiá di han tiklik mam Iosep suri mákái mátán hat er má ngádáh dikte oboi ngoi á kápán páplun ái Iesu iatung. ");
INSERT INTO sgz_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Di mákái mátán hat er di tahun Iesu on á tan wák, ki ding kaleng má ur Ierusalem suri da bop ái, má dik eran mul i tan táit a tomtom ngorer i kabang má wel suri namur da oboi i kápán páplun ái Iesu. Má namur di aunges on á bungán aunges ngorer a parai i nagogon. ");
INSERT INTO sgz_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Má i ngahwán kábungbung sáksák i Sade, tan wák er dikte eran páksi tan táit a tomtom di kipi uratung i mátán hat er di dung Iesu ái. ");
INSERT INTO sgz_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Má ngo di hut iatung, di mákái ngo lala hat dikte dung kári mátán hat er mai, te dikte alimlim palai alari mátsálán tarang er. ");
INSERT INTO sgz_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Má ngorer di sol uratung i polgon hat er ngo da mákmák suri kápán páplun ái Iesu, mái sár ngo bokoh ái iatung. ");
INSERT INTO sgz_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tan wák er di mákái ngorer má dik tu rámásngin pagas. Má káp melek aru i kálámul diar tur soura uri narsá di má lusán i diar a pilpilpil. ");
INSERT INTO sgz_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Má ngo tan wák er di mákái aru kálámul, ki dik lala ráuráuwas má dik pur dirtapul uradi bim. Má aru i kálámul er diar parai si di ngo, “Suri dánih gam ser suri kálámul a liu i malar kándi ái rung dikte mat? ");
INSERT INTO sgz_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Bokoh ái á mainái. Ákte liu kaleng! Gama hol pasi kán worwor er a parai ur si gam ami Galiláiá ngoromin, ");
INSERT INTO sgz_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Da long pasi Natun Kálámul má da tari uri limán boh tám sápkin má da bás páptai uri kubau kus nák mat. Má ngo na rah i atul á bung, na liu kaleng mul.’” ");
INSERT INTO sgz_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Má ngorer tan wák di hol pasi worwor erei. ");
INSERT INTO sgz_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Io, di aptur kaleng tilatung i mátán hat má dik han hut narsán sángul mai kesá kalik án aratintin má rang táir i di iatung, má dik parai narsá di á tan táit dikte mákái. ");
INSERT INTO sgz_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Tan wák er ái Maria Magadalene mái Ioana mái Maria er mámán ái Iakobo, á di tiklik mam te wák mul, di no di parai tan táit min singin tan apostolo. ");
INSERT INTO sgz_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mái sár tan apostolo di hol on ngo tan worwor er di parai i tan wák kápate támin, má kápdite ruruna i di. ");
INSERT INTO sgz_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mái sár ái Petero a salaptur pas ák rut uri mátán hat. A tiktikon má ák tu mákái sár i sulu er di duri kápán páplun ái Iesu mai, má ngorer a kaleng urami rum mák lala ser i kán hol suri táit er. ");
INSERT INTO sgz_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","I bung erei sang, aru tili di er di lu mur i Iesu diar aptur pas má diará han uri kesá malar di utngi ngo Emaus. Artálár mai sángul mai kesá kilomita til Ierusalem ur Emaus, ");
INSERT INTO sgz_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","má diar lu worwor hanhan tangrai sál arliu i diar sang suri tan táit er ákte tapam hut. ");
INSERT INTO sgz_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Má ngo diar nguruk má argálta arliu i diar ngorer, ái Iesu a láklák til namurwa diar, mák sarwa i diar má ditulá tiklik no. ");
INSERT INTO sgz_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Má diará mák Iesu, mái sár mát diar kápate mák ilmi. ");
INSERT INTO sgz_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Mái Iesu a gálta diar ngo, “Be, wa dánih iau longrai er kamur tu wornai tangrai sál er tilamudi?” Má diar tur matau sár kápkabin a tabureng i kándiar hol má a tinang i bál diar má ngorer kápte wor i diar. ");
INSERT INTO sgz_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Má namur kesá tur diar ái rugar er, ngisán ái Kiliopas, a gáltai ngo, “Be, ngádáh, á iáu masik sár gut á kesi kepwen kálámul u kis á Ierusalem er kápute mánán on á tan táit ákte tapam hut i arliwán a is á bung er ákte rah?” ");
INSERT INTO sgz_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Má a gálta diar ái Iesu ngo, “Tan matngan táit ngádáh?” Má diará kosoi má parai singin ngoromin, “Tan táit er di longoi mam Iesu kakun Nasaret. Kálámul er a tám worwor tus muswan, má matananu di mák ilmi ngo bos akiláng a longoi má kán tan aratintin mul a lala rakrakai. Má bos táit a longoi má kán worwor a inngasi ngo ái Káláu ákte sormángát tari. ");
INSERT INTO sgz_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","21","Má kángim ngangai á gim ngo ái Iesu sár má, ái koner ákte hut suri na kip kalengnai matananu Israel tili lalin kángit tan kurtara. Má tan pakpakta kán tan tám osmapak má kángit tan tátáil no di tar Iesu uri nagogon suri da oboi uri minat, má ngorer dik bás páptai uri kubau kus ák mat, má onin átuil bung mai. ");
INSERT INTO sgz_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Má nengen i kábungbung, tan wák er rang táir i gim di han uri mátán hat er di tahun Iesu on. Má ngo di kaleng, di bit gim ngo bokoh má á kápán páplun ái Iesu má kápte di mákái. Má di bit gim mul ngo di mákái tan angelo adi mátán hat. Ái sár tan angelo er di parai ngo ákte aptur alari minat ái Iesu má a liu kaleng, má ngorer gimá lala pánsálngát suri. ");
INSERT INTO sgz_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Má te rang tili gim di longrai ngorer má dik han uri mátán hat má dik mákái ngorer sang i tan wák dikte parai, mái sár ái Iesu kápte di mákái.” ");
INSERT INTO sgz_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Io, a longrai ngorer ái Iesu mák parai ur si diar ngoro minái, “Má káp gam ngul sang! Suri dánih a laklak i bál gam má kápgamte sangar melek suri ruruna i pinpidan káián tan tám worwor tus? ");
INSERT INTO sgz_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Di sang dikte parai ngo ái Káláu ákte obop páksi kán sál ái Mesaia suri na mur on a ngoromin, ngo na mulán áslai besang i rangrangas, má namur na han kusak uri lain minmáir.” ");
INSERT INTO sgz_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Má ngorer ái Iesu a utung timani ur si diar á tan táit dikte sir páptai ur on sang i Buk Tabu, turpasi tili tan buk si Moses ák han pang i tan buk káián tan tám worwor tus. ");
INSERT INTO sgz_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Má ngo dituláte pátum uratung Emaus, i malar er diara han ur on, ái Iesu a tu láklák sorliu sang, ");
INSERT INTO sgz_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","mái sár diará tur kári má diará parai singin ngo, “Be, káp gitula te bop má iáu? Ákte rahrah má erei.” Má a longra pasi kándiar worwor ái Iesu, má ngorer a han kis tiklik mam diar. ");
INSERT INTO sgz_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Má namur ditul kis tiklik suri namnam, má a top pasi balbal ái Iesu mák sung kári, má namur a tibi balbal mák tabar diar mai. ");
INSERT INTO sgz_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Má i pákánbung a longoi ngorer ái Iesu, mát diar a mák ilmi sang ngo ái Iesu á iatung, má káp melek sár ái Iesu a tu bokoh pas uri mát diar. ");
INSERT INTO sgz_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Má ngo diar mákái ngorer, ki diar má parai si diar sang ngo, “Erei gitul láklák tangrai sál, má ami bál gitar a gasgas suri tan kuir Buk Tabu er kán tu utung timani si gitar!” ");
INSERT INTO sgz_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Má i pákánbung er sang, diar aptur tilatung má diará han kaleng urami Ierusalem mul narsá di á sángul mai kesá kalik án aratintin mái rung di no iatung. ");
INSERT INTO sgz_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Diar hut ngorer má diará longrai si di iatung ngo ái Konom ákte aptur kaleng sang má ákte soura uri narsán ái Saimon. ");
INSERT INTO sgz_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Má namur diar má para talsai uri narsá di suri tan táit er ái Iesu a parai si diar tangrai sál, má ngo diaráte mák ilam Iesu er a tibi balbal. ");
INSERT INTO sgz_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Má ngo kándiar tu parai besang i worwor er uri narsá di, ái Iesu a tur soura mák sámtur iatung i katbán i di mák parai ngo, “Matau na kis narsá gam.” ");
INSERT INTO sgz_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Má di mákái ngorer ki dik hol on ngo dikte mákái kesi tesit, má ngorer di lala mátut sang. ");
INSERT INTO sgz_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Mái sár ái Iesu a parai mul si di ngo, “Suri dánih gam mátut má a lala ser i kamu holhol sur iau? ");
INSERT INTO sgz_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Gam lákám má gamák singli kápán páplun i iau, má gamák mákái nián nil minái i láprán limang má kiking suri gamák mák ilam iau ngo á iau muswan sár á minái. Kápte ngo iau tesit. Gam mákái sár ngo a mon á kápán páplun i iau, má tesit kápte.” ");
INSERT INTO sgz_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","A para ngorer ái Iesu, ki ák inngasi limán má keken ur si di. ");
INSERT INTO sgz_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Aru i kandi holhol i pákánbung er. A muswan ngo worwor a parai ái Iesu a agasgas pasi bál di, mái sár di hol on ngo táit er a támin ngo kápte. Má ngorer a ngátngát sang be á kandi holhol. Má ngorer ái Iesu a gálta di ngo, “Be, a mon te namnam alatung gam oboi?” ");
INSERT INTO sgz_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Má ngorer di long pasi kesi mudán isu ákte pim má dik támri mai, ");
INSERT INTO sgz_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","má a long pasi isu er ái Iesu mák ani iatung i mát di. ");
INSERT INTO sgz_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","A namnam no ái Iesu, má namur a parai si di ngo, “Onin ákte tapam hut muswan á tan táit iakte para páksi si gam tungu er git kis tiklik, ngorer suri tan táit sur iau dikte le páptai hirá i nagogon si Moses má i buk kán tan tám worwor tus má iatung mul i buk án parpara agas. Tan táit er a támin!” ");
INSERT INTO sgz_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Má namur ái Iesu a atalsai kandi holhol suri da mánán pasi tan táit dikte le páptai i Buk Tabu, ");
INSERT INTO sgz_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","má ák parai si di ngo, “Erei i Buk Tabu a parai ngoro minái, ‘Na áslai sang i rangrangas be á Mesaia má namur na mat. Má ngo na rah i atul á bung, na liu kaleng sang.’ ");
INSERT INTO sgz_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Má a parai mul ngo gama turpasi til main sang Ierusalem suri arbin mai ngisán uri tan malar no. Gama arbin má gama parai ngo matananu da tánlak alari sápkin ninsin i di má ái Káláu na pah palai kandi sápkin. ");
INSERT INTO sgz_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ngorer gama han uri tan malar no má gamák apapos suri á tan táit minái gamáte mákái.” ");
INSERT INTO sgz_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","A parai ngorer ái Iesu uri narsá di ki ák bali parai mul ngo, “Má á iau sang ina tarwa palai á rakrakai erei ái Kakang ákte oror pagas mai. Gama tunga kis monai sang main Ierusalem nák han arwat sang i bung er na hut sosih i rakrakai tilami má nák asosah i gam.” ");
INSERT INTO sgz_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Má namur ái Iesu a lam pasi rang táir tili bimán rum á Ierusalem má di han ngorer ur Betani. Iatung i pokon erei ái Iesu a sángwái limán ami iátin i di má a asosah i di. ");
INSERT INTO sgz_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Má ngo ái Iesu kán tu asosah i di be iatung, ái Káláu a duruk pasi urami naul bát. ");
INSERT INTO sgz_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Io, dik lotu uri narsán iatung, má namur dik láklák kaleng mai laes ur Ierusalem, ");
INSERT INTO sgz_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","má dik lu balbal han urami rumán osmapak suri kis án parpara agas uri narsán ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Hirá sang kápte be akaksim, ái koner ngisán ái Pinpidan a kis, má ái diar liu tiklik ái Káláu, má ái diar tukes sár ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Má hirá sang kápte be akaksim, ái Pinpidan ákte kis tiklik má mam Káláu. ");
INSERT INTO sgz_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ái Káláu a káplabin á akaksim, má a longoi mai limán ái Pinpidan, má kápte kesi táit a hut bia ngo ái Pinpidan kápate longoi. Tan táit no, ái sang a longoi. ");
INSERT INTO sgz_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ái Pinpidan, ái á káplabin liu. Má liu erei, ái á talas uri atalsai matananu. ");
INSERT INTO sgz_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Má talas a lu talápár i kuron, má kuron kápate rakrakai artálár suri na sorliwi. ");
INSERT INTO sgz_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Má namur ái Káláu a dos palai kesi kálámul ngisán ái Ioanes. ");
INSERT INTO sgz_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ái a hut suri apapos narsán matananu suri á talas er, má ngorer matananu da longrai má dák ruruna on. ");
INSERT INTO sgz_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ái Ioanes kápte ngo ái á talas, ái sár a hut suri apapos suri á talas er. ");
INSERT INTO sgz_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Má talas er, ái á talas muswan sang, má ák hut uri naul matmatngan pokon má ák atalsai matananu no. ");
INSERT INTO sgz_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ái Pinpidan ákte kis i katbán matananu i naul matmatngan pokon er diar aksimi ái Káláu, mái sár matananu kápdite mák tusi ngo ái muswan sár á erei. ");
INSERT INTO sgz_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","A hut uri kán malar muswan sang, mái sár kán matananu kápdite lu árár pasi. ");
INSERT INTO sgz_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Mái sár te tili di, di mák ilmi má dik ruruna on, má ngorer a tari nokwan si di suri da rang natun ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Má kápdite rang natun ái Káláu tili kápán páplun ngorer i kalik a mon i kákán mák páng uri kápán páplun, kápte. Ái Káláu sang a Kák di kabin a aliwi taniá di, má ngorer dik rang natun ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ái koner ngisán ái Pinpidan a tar kápán páplun má ák han kis i katbán i gim. Má gim mákái ngo a káng mai artangan má muswan, má gimá mákái mul i minmáir er a tari ái Kákán si kán Kalik er káh kes. ");
INSERT INTO sgz_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Má ái á kálámul ái Ioanes a parai er ák lu binbin ngoromin, “Minái ái koner iau worwor suri erei iak parai ngo, ‘Ái na hut namurwa iau, mái sár a pakta sorliu iau kabin ákte mulán kis má, má namur iak páng.’” ");
INSERT INTO sgz_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Má kabin i kán tilik artangan, ák lu balbal asosah i git mák lu akulukna git keskeskes. ");
INSERT INTO sgz_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","A ngoromin. Ái Káláu a inngasi kán nagogon si Moses mái Moses a tari singin matananu. Má namur ái Iesu Karisito a hut mák inngasi si git á artangan má muswan káián ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kápte kes a mák Káláu be. Ái Natun, koner káh kes mái koner diar arwat má a kis tiklik mam Kákán, ái sang a inngas tar Káláu singin matananu. ");
INSERT INTO sgz_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Má ida Ierusalem tan tátáil káián matananu Iudáiá di longrai arbin sur Ioanes Tám Arsiu, má ngorer dik dos palai te tám osmapak má te tili gegen si Lewi suri da gátnai ngoromin, “Á iáu ái sinih?” ");
INSERT INTO sgz_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Mái Ioanes kápate kulut suri kos di, mái sár a para talsai si di ngo, “Á iau kápte ngo iau á Mesaia.” ");
INSERT INTO sgz_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Di longrai ngorer má dikte lu bali gáltai ngo, “Má iáu sinih? Iáu ái koner si Elaisa, be?” Mái Ioanes a kos di ngo, “Auh, kápte.” Má dik bali gáltai mul ngo, “Á iáu á tám worwor tus er gim kis monai?” Mái Ioanes a parai ngo, “Kápte.” ");
INSERT INTO sgz_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Má dik gáltai mul ngoromin, “Má parai si gim má, iáu sinih, suri gima kaleng mai kam kokos uri narsán rung di dos pala gim. Una para talsai sang ngo iáu sinih.” ");
INSERT INTO sgz_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ái Ioanes a longrai ngorer má áng kos di mai worwor si Aisaia tám worwor tus ngoromin, “Á iau á kaungán kálámul a lu binbin iamuni pokon mau ngo, ‘Gama long anokwai sál er i bál gam suri nák láklák on ái Konom!’” ");
INSERT INTO sgz_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Má namur ái rung er dikte dos pala di i tan Parisaio, ");
INSERT INTO sgz_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","di gátna Ioanes ngoromin, “Iáu parai ngo kápte iáu Mesaia ngo iáu Elaisa, má kápte ngo iáu á tám worwor tus er gim kis monai. Ngo ngorer, ki suri dáh u lu arsiu?” ");
INSERT INTO sgz_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Mái Ioanes a kos di ngo, “Á iau iau arsiu mai dan sár. Mái sár alatung i katbán i gam, kesá kálámul kápgamte mák ilmi. ");
INSERT INTO sgz_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Kálámul er a murwa pas iau, mái sár ái a pakta i giur, má ngorer iau rumrum suri ina kusak i kán rum.” ");
INSERT INTO sgz_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Má rung er di hut narsá Ioanes má dik argátna mai i pákánbung ái Ioanes a arbin mák arsiu anang Betani i balsán dan á Ioridan tilanang. ");
INSERT INTO sgz_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Má arasa uri kesi bung, ái Ioanes kán tu arbin má arsiu, má namur a mák Iesu a lu lákláklák tilanang uratung i narsán. A mákái ngorer mák parai singin matananu iatung ngo, “Mákái! Erei mái Sipsip ái Káláu a tari suri na pusak pasi sápkin kán naul matmatngan pokon! ");
INSERT INTO sgz_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Minái ái koner iau worwor suri erei iak parai ngo, ‘Ái na hut namurwa iau, mái sár a pakta sorliu iau kabin ákte mulán kis sang, má namur iak páng.’ ");
INSERT INTO sgz_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Iau mánán on ngo matngan kálámul er na hut sang, mái sár káp iau te mánán ngo na kálámul ngádáh. Má iau hut iak arsiu mai dan, má ngorer iak eran i sál suri matananu Israel da mánán ilmi á kálámul er, má na tur talas uri mát di.” ");
INSERT INTO sgz_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Má namur ái Ioanes a apapos mák parai ngoromin, “Iau mákái Tanián a sosih tilami bát ngoro bun, má a roh kis on mák mon on. ");
INSERT INTO sgz_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Má káp iau te mánán besang mul on ngo ái á kálámul er a tarwai ái Káláu. Mái sár ái Káláu sang, koner a dos pala iau suri ina arsiu mai dan, ákte parai singing ngoromin, ‘Una mákái kálámul er Tanián na sosih má náng kis on. Kálámul er, ái ái koner na arsiu mai Tanián a Pilpil.’” ");
INSERT INTO sgz_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Mái Ioanes a bontai kán worwor mák parai ngo, “Iakte mákái má, má ngorer iau parai si gam ngo ái sang á Natun ái Káláu.” ");
INSERT INTO sgz_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Má arasa uri kesi bung bul, ái Ioanes iatung mul mai aru i kán kalik án aratintin. ");
INSERT INTO sgz_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Má a mák Iesu a láklák sorliu iamunang, mái Ioanes a parai ngo, “Erei sár á Sipsip káián ái Káláu!” ");
INSERT INTO sgz_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Má aru kalik án aratintin diar longra Ioanes a parai ngorer, má diar má aptur má mur i Iesu. ");
INSERT INTO sgz_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Mái Iesu a ilang kaleng má ák mák diar diar lu murmur on, mák gálta diar ngoromin, “Dánih gaur mákmák suri?” Diar má kos Iesu ngo, “Rabai, ai u lu kiskis ái á erei?” (Sálán worwor erei ‘Rabai’ ngo ‘Tám Aratintin’.) ");
INSERT INTO sgz_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ái Iesu a kos diar mák parai ngo, “Gaur lákám má gaurák mákái.” Má ngorer ditul má han, má diará mákái pokon a lu kiskis ái, má diará kis tiklik mai pang i ronron sang kabin ákte hat má i pákánbung i rahrah. ");
INSERT INTO sgz_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Má aru kalik er diar longrai táit a parai ái Ioanes sur Iesu má ngorer diará mur i Iesu, kesi tur diar ngisán ái Enru tuán ái Saimon Petero. ");
INSERT INTO sgz_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Má namur, ái Enru a han mák sangar i ser pas tuán, ái Saimon, mák parai singin ngoromin ngo, “Gimáte ser pasi má Mesaia!” (Sálán worwor erei ‘Mesaia’ ngo ‘koner a ilwa pasi ái Káláu’.) ");
INSERT INTO sgz_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Má namur, ái Enru a long pas Saimon uri narsá Iesu. Mái Iesu a mákái mák parai singin ngo, “Á iáu ái Saimon, natun ái Ioanes. Mái sár, Saimon, ina utung iáu mul mam Kepas.” (Kepas a ngorer i kuir wor ‘Petero’, sálán ngo ‘hat kis’.) ");
INSERT INTO sgz_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Má namur arasa uri kesi bung bul, ái Iesu a hol on ngo na han ur Galiláiá. Má ngorer ái Iesu a han mákái kesi kálámul ngisán ái Pilip mák parai singin ngo, “Lákám, una mur i iau!” ");
INSERT INTO sgz_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ái Pilip, ái sang til Betesaida, malar si Enru mái Petero. ");
INSERT INTO sgz_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Mái Pilip a han má ák ser pas turán, ái Nataniel, mák parai singin ngoromin, “Gimáte mákái má kálámul erei ái Moses a worwor talas ur on i buk án nagogon, má tan tám worwor tus mul dikte le suri. Kálámul erei ngisán ái Iesu, kakun Nasaret, natun ái Iosep.” ");
INSERT INTO sgz_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ái Nataniel a longrai ngorer mák gátna Pilip ngo, “Be, ngádáh na ngoi? A arwat ngo tekesi lain táit na hut til Nasaret?” Mái Pilip a kosoi ngo, “Lákám má, unák mákái!” ");
INSERT INTO sgz_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Má diará lu hanhan má, má ngo ái Iesu a mák Nataniel a lu hanhan suri, a parai sur Nataniel ngo, “Kakun Israel muswan á kálámul min! Kápate mánán i angagur!” ");
INSERT INTO sgz_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Mái Nataniel a gátna Iesu ngo, “Ngádáh u mánán i iau ngoi?” Mái Iesu a kosoi ngo, “Iau mák iáu nengen sang kápte be a lam pas iáu ái Pilip. U sámtur pagas i lalin tawan.” ");
INSERT INTO sgz_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ái Nataniel a longrai ngorer mák parai ngoromin, “Tám Aratintin, iáu á Natun ái Káláu, má iáu kabisit káián Israel!” ");
INSERT INTO sgz_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Mái Iesu a parai singin ngo, “Be, iáu ruruna sár kabin iau parai singim ngo iau mák iáu nengen ada i lalin tawan? Na, wa namur una mákái tara támin táit sang na tapam hut!” ");
INSERT INTO sgz_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Má namur ái Iesu a parai si di ngoromin, “A támin muswan sang ngo gama mákái naul bát na pasbat, má tan angelo si Káláu da lu taptapam má dák lu sososih, má Natun Kálámul a ngoro sál tan angelo di lu láklák on.” ");
INSERT INTO sgz_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Má namur ngo ákte rah i aru á bung, di longoi kesi long namnam án arakila i malar á Kana i balis á Galiláiá. Mái mámán ái Iesu a han suri long namnam erei, ");
INSERT INTO sgz_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","mái Iesu má kán kalilik án aratintin di long pas di mul. ");
INSERT INTO sgz_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Má iatung i long namnam, suir wain a teken rah melek. Má ngorer mámán ái Iesu a han mák parai singin ngo, “Ákte rah má suir wain.” ");
INSERT INTO sgz_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ái Iesu a longrai ngorer má a kos kalengna mámán ngoromin, “Wákán, suri dáh u parai singing? Dánih ina longoi mai? Kak pákánbung káp besang a te hut.” ");
INSERT INTO sgz_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mámán ái Iesu a longrai ngorer, ki ák parai singin bos tám arardos ngo, “Gama longoi ngorer sang na parai si gam.” ");
INSERT INTO sgz_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tatalen káián tan Iudáiá a ngoromin. Suri da pilpil i pákánbung di han suri namnam, di lu ililim táil má gorsai kik di, má namur dik namnam. Má ngorer, on á rum erei awon i átbán dan dikte longoi mai hat, má di lu totrai náng káng á kes ák arwat mai kesi mar á lita on. ");
INSERT INTO sgz_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ái Iesu a mákái tan átbán erei ki ák parai singin tan tám arardos ngoromin, “Gama utwai tan átbán minái mai dan.” Má tan tám arardos di tor akángái tan átbán erei. ");
INSERT INTO sgz_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Mái Iesu a parai mul si di ngo, “Gama utwa pas te má tari singin kálámul er a kábái long namnam.” Io, má di utwa pas te dan er ");
INSERT INTO sgz_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ákte arkeles uri wain má dik tari singin kálámul er má a tohoi. Mái sár kálámul erei a kábái long namnam kápate mánán ngo til ái á wain erei. Tan tám arardos masik sár di mánán kabin ngo di sang di utwai á dan. Má kálámul er a namiai suir wain er, má ngorer áng kilkila pasi kálámul er a hutngin kila ");
INSERT INTO sgz_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","mák parai ngoromin singin, “Di lu tar táilnai á suir wain a kuluk, má namur ngo dikte lala ngin, ki erár dik lu tari á suir wain kápate lala kuluk. Má iáu masik ukte longoi á matngan ngoromin. Iáu parai dik tulsa táilnai suir wain er kápate kuluk, má lain suir wain iáu oboi ur namur sang.” ");
INSERT INTO sgz_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Minái kán mulán akiláng ái Iesu, má a longoi i malar á Kana i balis á Galiláiá. Má ngorer ák inngas tari kán rakrakai mai tilik támin táit a longoi, má kán kalilik án aratintin dik ruruna on. ");
INSERT INTO sgz_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Má namur, ái Iesu mái mámán má rang tuán má kán kalilik án aratintin mul di han uradi Kapernaum, má ding kis pas te bung besang ái. ");
INSERT INTO sgz_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Má namur ákte páput i pákánbung suri longsit án sorliu palai káián tan Iudáiá, mái Iesu má kán kalilik án aratintin di han urami Ierusalem. ");
INSERT INTO sgz_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Má iatung i pelbut i rumán osmapak, ái Iesu a mákái tan kálámul di sirsira. Te di sira bulumakau má te di sira sipsip má te di lu sira man. Mái rung di lu keles pirán tabal di kis iatung tangrai kandi tan suh. ");
INSERT INTO sgz_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Mái Iesu a mák di ngorer ki ák mos, má ák long pasi tan kuir suk mák hiri uri kán ihil, má ák tipar palai tan ololas tilatung ngorer i sipsip má bulumakau. Má ák pukda sarai mul i bos suh káián rung di keles pirán tabal, má ák ura sarai pirán tabal. ");
INSERT INTO sgz_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Má namur ák tipar palai matananu erei di sira man mák parai si di ngoromin, “Gama long palai tan táit min til main! Káp gama te longoi kán rum ái Kang uri rumán sirsira!” ");
INSERT INTO sgz_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Io, má kán kalilik án aratintin di longrai worwor erei a parai ái Iesu, ki dik hol pasi pinpidan tili Buk Tabu er a para ngoromin, “Kak rakrakai án nemnem suri kam rum, Káláu, a gis iau.” ");
INSERT INTO sgz_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Má tan tátáil káián matananu Iudáiá di mákái ngorer ki ák mos i bál di, má dik han narsá Iesu má dik gátnai ngoromin, “Matngan akiláng ngádáh una longoi suri inngas tari sang ngo a mon i kam nokwan má ngorer uk longoi tan táit minái?” ");
INSERT INTO sgz_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Mái Iesu a longrai ngorer máng kos di ngoromin, “Ngo gama tarápái rumán osmapak minái, má ngo na rah i atul á bung, ina aptur kalengnai.” ");
INSERT INTO sgz_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Má tan tátáil di longrai ngorer, ki dik parai singin ngoromin, “Na, wa gim him pasi ahat i sángul mai awon á bet suri longoi á rum minái. Má ngádáh á iáu er uk parai ngo u arwat suri aptur kalengnai i atul sár á bung?” ");
INSERT INTO sgz_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Mái sár rumán osmapak er ái Iesu a worwor suri, a parai sang i kápán páplun. ");
INSERT INTO sgz_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Má namur ngo ái Iesu ákte aptur kaleng tili minat, kán kalilik án aratintin di hol pasi pinpidan erei a parai ái Iesu má dik ruruna i Buk Tabu má worwor er ái Iesu a parai. ");
INSERT INTO sgz_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Mái Iesu kán tu kis be ami Ierusalem i pákánbung án longsit án sorliu palai, má a longoi tan akiláng, má marán di mákái má dik ruruna on. ");
INSERT INTO sgz_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Mái sár ái Iesu ákte mánán i di no, má ngorer kápate ruruna i di ngo dikte ruruna muswan ");
INSERT INTO sgz_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","kabin a lala mánán i bál di, má ngorer sinih a arwat ngo na atalsa Iesu suri ninsin matananu? ");
INSERT INTO sgz_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Má kesi kálámul ngisán ái Nikodimo, má ái á kesi kálámul pakta káián tan Iudáiá, má ái sang mul á kesi Parisaio. ");
INSERT INTO sgz_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","I kesi libung, a han narsá Iesu mák parai ngoromin singin, “Tám Aratintin, gim mák ilmi ngo kálámul a lu longoi matngan akiláng er u lu longoi, a kápkabin ái Káláu a kis i narsán. Má ngo ái Káláu kápate kis narsán, kápate arwat suri na longoi. Má ngorer gim mánán ngo ái Káláu a dos pala iáu sang.” ");
INSERT INTO sgz_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Mái Iesu a longrai ngorer ki áng kos kalengna Nikodimo ngoromin, “A támin muswan sang ngo kápte kes a arwat suri na kusak uri lolsit si Káláu ngo kápate bali páng má ák hutngin.” ");
INSERT INTO sgz_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Mái Nikodimo a longrai ngorer má ák rogorogo i kán hol, mák parai ngo, “Ngádáh na bali páng ngoi á kálámul er ákte pakta? Kápate arwat sang suri na kusak uri bál ái mámán má nák bali káhái i áruán pákán.” ");
INSERT INTO sgz_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Mái Iesu a kos kalengnai mul ngoromin, “A támin muswan sang ngo kálámul kápate páng tili dan má tili Tanián mul, kápnate kusak uri lolsit si Káláu. Káp iau te parai ngo una kaleng uri bál ái mamam má unák bali páng mul ngorer. Ngo iau parai ngo una bali páng, a sálán ngo Tanián a Pilpil na ahutngin pasi taniam má ngorer uk páng uri lolsit si Káláu. ");
INSERT INTO sgz_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Kákán mái mámán kálámul, diar tari liu án kápán páplun ur singin kálámul, mái sár káp diar te arwat suri tari liu án tanián ur singin. Tanián ái Káláu masik a arwat suri na aliu pasi tanián kálámul suri nák liu áklis. ");
INSERT INTO sgz_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Be, iáu sodar kabin iau parai singim suri gama bali páng? ");
INSERT INTO sgz_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Una mákái be i kihkih. Sinih a mánán i kihkih er a hut? Kihkih a hut ngorer i kán nemnem sang, má kápte kes a mák muswan on. A tu mákái sár i táit a husai má ák longrai kaungán. Má kápate mákái ai a hut til ái ngo ai a han ur ái. Má Tanián ái Káláu a ngorer mul i kihkih i pákánbung a hut singin matananu má di áslai hutngin kákáh án tanián.” ");
INSERT INTO sgz_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Mái Nikodimo a gátna Iesu ngo, “Be, má ngádáh má na hut ngoi á táit erei?” ");
INSERT INTO sgz_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ái Iesu a longrai ngorer má ák parai singin ngoromin, “Di no di mánán i iáu ngo iáu tám aratintin, má di árngai ngisam ngo iáu lala tám mánán káián matananu Israel! Má ngádáh a ngoi káp iáu te talas ur on á tan táit min? ");
INSERT INTO sgz_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","A támin muswan sang, gim worwor suri táit gim mánán on má parai táit gimáte mák muswan on, mái sár kápte kes tili gam a ruruna i kángim apapos. ");
INSERT INTO sgz_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Iakte tohtohpas mai táit til main i bim suri gama talas uri tan táit tilami bát, mái sár kápte be a talas i kamu hol ur on, má kápte gam ruruna. Má ngorer, ngádáh gama ruruna on ngoi á táit tilami bát sang ina parai si gam? ");
INSERT INTO sgz_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Má sinih til main i naul bim ákte han urami naul bát, má ngorer ák mon i kán mánán suri parai tan táit tilami? Kápte kes. Ái Natun Kálámul masik sár a mánán, má a mon i kán rakrakai kabin ái sang ákte sosih tilami naul bát. ");
INSERT INTO sgz_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nikodimo, u mánán i Moses má matananu Israel i pákánbung di lu hanhan tangrai pokon mau. Ái Moses a longoi tártárwán kanih má áng kabat páptai uri kesi kuir toros, má áng kip tatki ák riuriu. Má ngorer Natun Kálámul da kip tatki má na riuriu ngoi mul, ");
INSERT INTO sgz_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","suri ái koner a ruruna on, káián á liu áklis. ");
INSERT INTO sgz_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Mái Káláu a lala mámnai matananu i naul matmatngan pokon no. Má ngorer ák inngasi kán armámna má ák tarwa palai kán Kalik alal ur main i naul bim, suri ái rung er di ruruna on, kápdate hiru áklis. Kápte. Da atur páptai sang i liu muswan er a kis áklis. ");
INSERT INTO sgz_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Má ngorer mul, ái Káláu kápate tarwai Natun suri nagogon má tari rangrangas ur singin matananu. Kápte. A hut suri na aliu pas di sang alari kandi sápkin. ");
INSERT INTO sgz_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ái koner a ruruna i Natun ái Káláu, kápte te nagogon ur on. Mái sár ái koner kápate ruruna, nagogon ákte tur on má, kabin kápate ruruna i Natun ái Káláu er káh kes. ");
INSERT INTO sgz_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ngoromin á sálán nagogon a oboi ái Káláu uri matananu: talas ákte hut uri naul matmatngan pokon suri atalsai tatalen kán matananu, ái sár matananu di lala nem i kuron má di matai talas, kabin kandi tatalen a sápkin. ");
INSERT INTO sgz_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ái koner a lu longoi sápkin a matai talas, má kápate nem i han uri talas, kabin kápate nem suri talas na atalsai kán tan sápkin tatalen. ");
INSERT INTO sgz_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Mái sár koner a lu longoi lain tatalen, a lu han uri talas suri inngasi ngo ái sang a taram i Káláu.” ");
INSERT INTO sgz_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Má namur ái Iesu má kán kalilik án aratintin di han uradi balis á Iudáiá, má ding kis tiklik pas te bung iatung. Má ái Iesu a lu arsiu mul. ");
INSERT INTO sgz_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","I pákánbung er, ái Ioanes kápte be di oboi i rumán batbat kalar, má ái mul kán tu arsiu á Ainon er páput i malar á Salim, kabin on á pokon erei, marán sang á dan. Má matananu di han ur singin má a siu di. ");
INSERT INTO sgz_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Má kesi kálámul tilatung i balis á Iudáiá a hut mák turpasi arngangar mai kalilik án aratintin si Ioanes suri tatalen án arapilpil. ");
INSERT INTO sgz_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Má ngorer tan kalilik án aratintin er di han uri narsán ái Ioanes má dik parai sur Iesu ngoromin, “Mákái, Tám Aratintin. Kálámul erei git tiklik tilada i balsán dan á Ioridan, má ái ái koner ukte apapos ur on mul, inái a lu arsiu má marán di han uri narsán!” ");
INSERT INTO sgz_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ái Ioanes a longrai ngorer mák parai si di ngoromin, “Sinih da árngai ngisán ngorer ngo ái Káláu kápate mángát palai? Wán i kán him erei a kápkabin ái Káláu ákte tari. ");
INSERT INTO sgz_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Á gam sang gamáte longrai iau parai ngo kápte ngo iau á Mesaia, mái sár ái Káláu ákte dos pala iau táilnai. ");
INSERT INTO sgz_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kálámul a hutngin kila, káián sang ái kán wák. Mái sár turán er a sámtur páput, ái mul a laes i pákánbung a longrai kaungán ái turán er a han suri kila. Má iau ngorer mul. Iau turán ái kálámul a hutngin kila, má ngorer balang ákte káng mai laes má iak parmat i pákánbung onin. ");
INSERT INTO sgz_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ái má kálámul erei na lu pakpakta hanhan, mái sár á iau ina lu sososih má. ");
INSERT INTO sgz_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Koner a han tilami bát, ái a pakta ami iátin tan kálámul no. Mái koner a páng tili naul bim, ái a ngorer i rung tili bim sár má a lu parai táit án naul bim. Mái koner tilami naul bát kápte a ngorer. Ái a pakta i git no. ");
INSERT INTO sgz_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ái koner tilami bát a apapos suri táit ákte mákái má ákte longrai, mái sár kápte di lu ruruna i kán worwor. ");
INSERT INTO sgz_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Má ngo tekes a ruruna i midán, ngorer a para tari ngo imi bál a hol on ngo kán worwor ái Káláu a támin. ");
INSERT INTO sgz_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Koner a tarwa palai ái Káláu a lu parai midán ái Káláu, kabin ái Káláu ákte tar kunlai Tanián singin máng káng on. ");
INSERT INTO sgz_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ái Kákán a mámna Natun má ákte obop noi tan táit uri limán. ");
INSERT INTO sgz_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ái koner a ruruna i Natun ákte atur páptai má á liu muswan er a kis áklis. Mái sár ái koner a tánlak má kápate taram i Natun, ái kápnate áslai liu muswan er. Kápte. A kis pagas i lalin nagogon si Káláu mái Káláu na lu atri rangrangas on.” ");
INSERT INTO sgz_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Má tan Parisaio di longrai ngo marán sang di lu mur i Iesu, má ngorer mámát i di ákte pakta sorliwi mámát i rung di mur i Ioanes. Má di longrai mul ngo ái Iesu a siu di, ");
INSERT INTO sgz_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","mái sár kápate nokwan á er. Ái Iesu sang kápate siu di, kán kalilik án aratintin sár di arsiu. ");
INSERT INTO sgz_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Má namur ái Iesu a longrai worwor er di parai ur on, má ngorer a aptur alari balis á Iudáiá má a kaleng ur Galiláiá. ");
INSERT INTO sgz_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Má i kándi inan erei di láklák tangrai balis á Samaria. ");
INSERT INTO sgz_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Má di lu hanhan tangra sál, má dik tapam hut i malar á Sikar i balis á Samaria. Malar er a kis pátmi kuir bim erei hirá ái Iakop ákte tari ur si natun, ái Iosep, ");
INSERT INTO sgz_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","má mátán dan si Iakop iatung i pokon er. Mái Iesu a merok tili láklák mák sukis pala iatung. Ákte sángul mai aru á pákánbung, ");
INSERT INTO sgz_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","má kán kalilik án aratintin di han alar Iesu iatung suri hul namnam ami malar. Má namur kesi wák til Samaria a han suri ananut. Ái Iesu a mákái wák er a ananut má a sungi ngo, “Ak te dan inak ngin.” ");
INSERT INTO sgz_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Má wák er a kos Iesu ngo, “Suri dáh u sung iau suri dan, má iáu kakun Iudáiá má iau wák til Samaria?” Wák er a parai ngorer kabin ngo tan Iudáiá má tan Samaria kápte di lu ararguna tiklik, má ngorer kápate arwat mul suri ngo ái Iesu na ngin tili átbán káián wák Samaria. ");
INSERT INTO sgz_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Mái Iesu a kosoi wák er ngo, “Kápte u mák ilmi artabar si Káláu má ngo iau kálámul dáh iau sung iáu suri ak te dan. Má ngo ukte han mák ilmi má, ngorer una han sung iau sang suri ina tabar iáu mai matngan dan er a aliwi kálámul.” ");
INSERT INTO sgz_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Má wák erei a parai singin ngo, “Konom, kápte kam te táit án ananut, má dan mul idi tepák. Má aiá una kipi til ái á matngan dan er? ");
INSERT INTO sgz_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ái Iakop kámpup gim a tari si gim á mátán dan minái, ngorer ái má rang natun má kándi tan ololas di ngin til on á mátán dan min. Ngádáh, u pakta sorliu Iakop á iáu?” ");
INSERT INTO sgz_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Mái Iesu a kosoi ngo, “Ái sinih na lu ngin til on á dan min, ái na sák mul suri dan namur. ");
INSERT INTO sgz_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ái sár ái koner na ngin i dan ina tari singin, kápnate sák suri dan mul. Má dan ina tari singin na mátán upup ami bál má na ekesi buak mai dan án liu muswan er a kis áklis.” ");
INSERT INTO sgz_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Má wák er a longrai ngorer mák parai singin ngo, “Konom, una tabar iau mai á dan er suri káp ina te sák mul suri dan, má suri káp ina te lu han mul suri ananut mainái!” ");
INSERT INTO sgz_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Mái Iesu a parai singin ngo, “Han be. Unák long pasi kam pup ur main!” ");
INSERT INTO sgz_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Má wák er a parai si Iesu ngo, “Káp kak te pup á iau!” Mái Iesu a kosoi ngoromin, “A muswan er u parai ngo káp kam te pup ");
INSERT INTO sgz_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","kabin ukte kila pasi alim á kálámul, mái koner gaur kis tiklik onin kápte ngo kam pup muswan. Áá, táit u parai singing a támin.” ");
INSERT INTO sgz_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Má wák er a parai singin ngo, “Konom, iau mák ilmi ngo iáu á tám worwor tus. ");
INSERT INTO sgz_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Rang kámpup gim á tan Samaria di lu lotu uri narsán ái Káláu mamuni pungpung muni. Mái sár gam á tan Iudáiá gam puai má gamá parai ngo ami sang Ierusalem á pokon muswan er gita lu lotu uri narsá Káláu ái.” ");
INSERT INTO sgz_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Mái Iesu a parai singin ngoromin, “Wákán, a támin muswan á táit minái iau parai singim. Namur na hut i pákánbung má kápte kes na lotu narsá Kang i pungpung imuni ngo ami Ierusalem mul. ");
INSERT INTO sgz_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Gam á tan Samaria kápgamte mánán i Káláu, má ngorer kápgamte mánán i táit gam lu lotu ur on. Má gim á tan Iudáiá gim mánán i Koner gim lotu uri narsán kabin a inngasi sál án araliu i narsá gim. ");
INSERT INTO sgz_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mái sár bung er na hut má ákte hut má mul, mái Kák git a nem i matananu suri da lotu muswan uri narsán mai artangan káián Tanián a Pilpil má mai támin. ");
INSERT INTO sgz_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ái Káláu kápte ngo kápán páplun. A tanián sang. Má kabin a tanián, ái rung di lotu muswan uri narsán, di lotu sang tilami bál di mai artangan káián Tanián a Pilpil má mai támin.” ");
INSERT INTO sgz_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Má wák er a parai singin ngo, “Iau mánán ngo Mesaia er má na hut, koner a ilwa pasi ái Káláu. Má i pákánbung na hut, na para aposoi tan táit no si git.” ");
INSERT INTO sgz_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Má ngorer ái Iesu a para talsai singin ngo, “Á iau sár á Mesaia min iau worwor mam iáu.” ");
INSERT INTO sgz_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Má i pákánbung erei sang, kán kalilik án aratintin di kaleng tili hul namnam, má dik mák Iesu a worwor mai wák er má dik sodar. Dik sodar ngorer, mái sár kápte kes a gáltai ngo, “Dánih u nem on?” ngo “Suri dánih u worwor mai wák erei?” ");
INSERT INTO sgz_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Má wák er a han alari kán átbán dan iatung máng kaleng urami malar mák parai singin tan kálámul iatung ngo, ");
INSERT INTO sgz_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Gam lákám! Gamák mákái kálámul er a para noi tan táit iakte lu longoi. Na ái gut á Mesaia?” ");
INSERT INTO sgz_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Má matananu di longrai ngorer má dik han suri mák Iesu. ");
INSERT INTO sgz_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Má i pákánbung erei, kán kalilik án aratintin di tari duk on má dik parai si Iesu ngo, “Tám Aratintin, minái má namnam. Unák an te má!” ");
INSERT INTO sgz_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Mái sár ái a kos di ngo, “A mon á ak namnam er kápgamte mánán on.” ");
INSERT INTO sgz_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Má kalilik án aratintin di longrai ngorer má dik gálta arliu i di sang ngo, “Ákte namnam gut singin tekesi kálámul?” ");
INSERT INTO sgz_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Mái Iesu a parai si di ngo, “Ak namnam a ngoromin. Iau lu taram i nemnem si Koner a tarwa iau má suri arahi kán him a tari singing suri ina longoi. Ngo iau lu longoi ngorer ái Káláu a nem on, a lu arakrakai i iau ngorer i namnam. ");
INSERT INTO sgz_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Kamu arabitbit a ngoromin. Gam lu parai ngo, ‘Gitáte soso má, má na hat á kalang sár má na matuk á balbal.’ Ki iau parai si gam ngoro minái ngo gama sálsálah aririu má gamák mákái tan num, kabin ákte matuk má balbal, má ákte pátum má suri ililur! ");
INSERT INTO sgz_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Kálámul ngo a ili balbal ákte matuk, na mon i kán arsupan. Má balbal kán tu obop talmi, wa ái rung di ruruna suri da kis áklis i liu muswan. Má ngorer, koner a soso mái koner mul a ililur, diar no na gas tiklik i bál diar. ");
INSERT INTO sgz_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Má kesi arabitbit mul ngoromin di lu parai má a támin, ‘Kes a lu soso má kes sang a lu ililur.’ ");
INSERT INTO sgz_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Á gam ngorer. Iakte tarwa gam suri gama il pasi balbal i pokon kápgamte soi. Tan temes dikte himhimna, mái sár onin di bokoh, má gam sang gama kipi wán kándi songsong.” ");
INSERT INTO sgz_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Má marán Samaria i malar erei di ruruna i Iesu kabin i wák er ákte parai sur Iesu ngo, “Kálámul er a para noi tan táit iakte longoi.” ");
INSERT INTO sgz_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Má ngorer ngo dikte hut i narsán, di sung páptai suri na lu kis be tiklik mam di. Má ngorer ái Iesu a kis pasi aru á bung iatung, ");
INSERT INTO sgz_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","má marán mul di longrai midán ái Iesu má dik ruruna on. ");
INSERT INTO sgz_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Má namur dik parai singin wák erei ngoromin, “Tungu gim ruruna kabin i táit er iáu parai. Mái sár onin gim ruruna kabin gim sang gimáte longrai má gimá mák ilmi ngo a támin ngo ái á Tám Araliu káián naul matmatngan pokon.” ");
INSERT INTO sgz_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ákte arahi má aru i bung i kán kis iatung Samaria, ái Iesu má kán kalilik án aratintin di aptur má ding kaleng uranang Galiláiá. ");
INSERT INTO sgz_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Mái Iesu sang a parai ngo, “Tám worwor tus kápte di lu rumrum on i kán malar muswan.” ");
INSERT INTO sgz_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Má ngo a hut á Galiláiá, matananu tilatung di árár pasi kabin á di sang dikte han urami Ierusalem suri longsit án sorliu palai má dik mákái tan táit ái Iesu a longoi i tan bung erei. ");
INSERT INTO sgz_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Má namur ái Iesu a kaleng mul ur Kana i balis er sang á Galiláiá, i malar ákte pukdai dan uri wain on. Má adi Kapernaum kesi kálámul pakta kán kalik a sasam. ");
INSERT INTO sgz_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Má ngo pakpakta erei a longrai ngo ái Iesu ákte han til Iudáiá ur Galiláiá má ngo iatung be ái, ngorer a han uri narsán má ák sungi suri diara han ur Kapernaum má nák aliwi natun, kabin páput má na mat mai sasam. ");
INSERT INTO sgz_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ái Iesu a longrai kán sung mák parai singin ngoromin, “Ngádáh, kápte kes tili gam na ruruna sár i iau? Koran má gamák mákái sang i te tara akiláng gut, ki erár gamák ruruna!” ");
INSERT INTO sgz_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Má pakpakta er a kos Iesu ngo, “Konom, gitar má, na mák mat i natung!” ");
INSERT INTO sgz_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Mái Iesu a parai singin ngo, “Una han má! Kam kalik na liu!” Má kálámul er a ruruna i kán worwor ái Iesu mák han má. ");
INSERT INTO sgz_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Má ngo kán tu tangrai sál uradi Kapernaum, kán tan tám arardos di arsuar pasi mai arbin suri kán kalik má dik parai ngo, “Kam kalik ákte sengsegeng hanhan má kápnate mat!” ");
INSERT INTO sgz_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Má kálámul er a longrai ngorer máng gálta di ngo pákánbung dáh kán kalik a turpasi pánpán kaleng. Má di kosoi ngo, “Málmálas erei a rah alari nabung i nas ngorer i kesá pákánbung.” ");
INSERT INTO sgz_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Má kákán kalik er a hol páptai ngo i pákánbung erei sang ái Iesu ákte parai singin ngo kán kalik na liu. Má ngorer kálámul er a ruruna i Iesu. Má kán aratinán mái rung er di lu kis iatung i kán rum, di ruruna on mul. ");
INSERT INTO sgz_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Má minái á áruán pákán ái Iesu a han til Iudáiá ur Galiláiá má ák longoi akiláng. ");
INSERT INTO sgz_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Má namur ái Iesu di di han mul urami Ierusalem suri kesi longsit káián matananu Iudáiá. ");
INSERT INTO sgz_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Má on á áir kalar ami Ierusalem a mon i mátán sál di utngi mai Mátsálán Sipsip, má iatung pátmi mátán sál kesi mátán dan uri siusiu. Má on á worwor Ebaraio, ngisán mátán dan er ngo ‘Betesada’. Má iatung i risán, a mon i alim á kahkah tan kálámul di lu kis ái. ");
INSERT INTO sgz_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Morongnau á kálámul er di sasam di lu bop pagas iatung i alim á kahkah er, tan rau má tan kálámul a sák i kik di má tan kálámul a mat i páplun i di. Di lu kis monai dan suri na malmaliu ");
INSERT INTO sgz_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","kabin kándi ruruna a ngoromin. Di hol on ngo kesi angelo si Káláu a lu sosih uradi dan i te pákán mák aptur i dan suri ák malmaliu. Má namur mulán kálámul na sosih uri dan, ái na sengsegeng alari sasam erei a porta on. ");
INSERT INTO sgz_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Má kesi kálámul iatung ákte sasam pasi atul i sángul mai awal á bet. ");
INSERT INTO sgz_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ái Iesu a mákái a bop pagas iatung, má ák mánán ilmi ngo ákte sasam pasi dolon pákánbung, má ngorer a gáltai ngoromin, “Awái, turang, u nem on ngo una sengsegeng?” ");
INSERT INTO sgz_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Má kálámul er a kosoi ngo, “Konom, iau nem on, mái sár kápte kes mainái suri na duruk iau má asosih i iau uri dan i bung a malmaliu be. Iau lu kakat suri ina siusiu on, ái sár te lite bul di lu hut táil.” ");
INSERT INTO sgz_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Mái Iesu a parai singin ngoromin, “Una aptur má long pasi kibam má unuk lu han!” ");
INSERT INTO sgz_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Má káp melek mul kálámul er a sengsegeng. Ák long pasi kibán mák láklák má. Má bung erei bungán aunges. ");
INSERT INTO sgz_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Má kálámul er ákte sengsegeng a lu hanhan mai kibán, má tan tátáil káián tan Iudáiá di mákái kálámul er a kipi kibán má ngorer di parai singin ngo, “Bungán aunges onin, má uri nagogon kángit, kápate arwat suri una kipi kibam.” ");
INSERT INTO sgz_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Má kálámul er a parai si di ngo, “Kálámul a asengsegeng pas iau a parai singing ngo ina aptur má ina long pasi kibang má inak lu han má, má ngorer iak taram on.” ");
INSERT INTO sgz_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Má tan tátáil di gáltai ngoromin, “Ái sinih á kálámul er a parai singim suri una longoi ngorer?” ");
INSERT INTO sgz_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mái sár ái koner ákte sengsegeng kápate mánán i Iesu ngo ái ái sinih, kabin ngo ákte han pas má i katbán lala matananu i pokon er. ");
INSERT INTO sgz_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Má namur, ái Iesu a banai kálámul er iatung i rumán osmapak mák parai singin ngo, “Mákái, ukte sengsegeng má! Má ngorer koion mul una bal longoi sápkin na mák hut singim á te táit a lala sák sang.” ");
INSERT INTO sgz_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Má kálámul erei a mák ilam Iesu, má ngorer a han mák parai singin tan tátáil ngo ái Iesu sár er ákte asengsegeng pasi. ");
INSERT INTO sgz_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Má tan tátáil di turpasi para sáksákna Iesu kabin a aliu pasi sasam on á bungán aunges. ");
INSERT INTO sgz_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Mái Iesu a parai si di ngo, “Ái Kakang káp a tini aunges, a lu balbal artangan narsán matananu. Má iau mul ina lu longoi sang i kak him ngorer.” ");
INSERT INTO sgz_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tan tátáil di longrai worwor er a parai ái Iesu mák lala mos i bál di, má ngorer dik rakrakai suri da oboi uri minat. Di mos on kabin ákte tah kusi nagogon uri bungán aunges má kabin ákte parai ngo ái Káláu a kákán sang, má ngorer di hol on ngo a apakta pasi sang ngo diar arwat ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ái Iesu a mánán ilmi kándi hol á tan tátáil, má ngorer a kos di ngoromin, “A támin muswan sang ngo Natun ái Káláu, kápte kesi táit ái masik a lu longoi. A longoi sár ngorer a mák pasi si Kákán. Dánih a longoi ái Kákán, ái Natun a lu longoi mul. ");
INSERT INTO sgz_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ái Kákán a mámna Natun mák inngasi singin á tan táit ái sang a longoi. Má namur na para tari singin á tan tilik támin táit, tan táit er a pakta alari tan táit ákte longoi tungu. Má gam no gama mákái má gamák pángáng on. ");
INSERT INTO sgz_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ái Kákán a lu apturi rung dikte mat mák tari liu si di. Má ngorer mul ái Natun a lu tari liu si rung a nem on ngo da atur páptai liu. ");
INSERT INTO sgz_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Mái Kákán sang kápate lu atur tekesi nagogon kabin ákte tari uri limán ái Natun á rakrakai suri nagogon i kálámul, ");
INSERT INTO sgz_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","suri ngorer matananu no da árngai ngisán ái Natun ngorer di lu árngai ngisán ái Kákán. Mái sinih kápate rumrum i Natun, ngorer di para bengta Kákán, koner a tarwa Natun ur main. ");
INSERT INTO sgz_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“A támin muswan ngo ái sinih a longra pasi kak pinpidan mák ruruna i Koner a tarwa iau, ái ákte atur páptai má á liu muswan er a kis áklis, má káp ina te oboi nagogon on. A ngoro ákte láklák sorliwi minat má ák tangra pasi sál uri liu muswan er. ");
INSERT INTO sgz_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Mái sár ái rung er kápte be di ruruna, a ngoro taniá di a mat pagas. Má a támin muswan ngo bung er na hut má ákte hut má mul, wa bung da longrai kaungán Natun ái Káláu. Má ngo da longra pasi, ki dák liu. ");
INSERT INTO sgz_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ái Kákán sang ái á káplabin liu. Má ngorer mul ái Natun. Ái Kákán ákte tari singin á rakrakai suri ái Natun mul na káplabin liu. ");
INSERT INTO sgz_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Mái Kákán ákte tari si Natun, má ngorer ái Natun a mon i kán nokwan suri kátlán matananu kabin ái á Natun Kálámul. ");
INSERT INTO sgz_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Má koion gama pángáng suri táit min! Er má na hut á bung má di no dikte mat da longrai kaungán ái Natun Kálámul ");
INSERT INTO sgz_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","má da aptur alari tarang. Ái rung di nokwan da aptur kaleng uri liu áklis sang. Mái sár ái rung tan tám ngákngák, di sang da aptur kaleng má da tur i nagogon.” ");
INSERT INTO sgz_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Mái Iesu a sopasun i kán aratintin mák parai ngoromin, “Ngo iau masik sár, káp ina te long tekesi táit. Nagogon iau oboi a ngorer sang ái Káláu a parai singing, má ngorer kak nagogon a nokwan kabin kápte iau mur i kak nemnem, ái sár iau lu longoi ngorer a nem on ái Koner a tarwa iau. ");
INSERT INTO sgz_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Ngo iau apapos sur iau sang, ngorer kak worwor a tu táit bia, má ngádáh gama mánán ngoi ngo a támin! ");
INSERT INTO sgz_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Mái sár kesi kálámul alatung sár a lu para iau, wa Kakang sang, má iau mánán ngo kán apapos sur iau a támin. ");
INSERT INTO sgz_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Ái Ioanes Tám Arsiu mul a para iau. Gam dos palai kamu tan kálámul suri gálta Ioanes, má worwor a aposoi sur iau a támin. ");
INSERT INTO sgz_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Iau parai apapos si Ioanes suri nák tangan gam má suri ái Káláu na sáras pas gam, mái sár á iau káp iau te pámpur tili worwor káián kálámul sár. ");
INSERT INTO sgz_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ái Ioanes a ngoro lam a kurkurem mák talas. Má kán worwor sur iau a atalsa gam, má gamá laes suri longrai kán worwor i án mudán pákánbung sár. ");
INSERT INTO sgz_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Má a mon i kesi táit mul a tur tangan iau, má ái a pakta alari kán apapos ái Ioanes. Tan tilik támin táit er iau lu longoi, ái Kakang ákte tari singing ngo kak talar, má di sang di inngasi ngo a támin ngo ái Káláu ákte tarwa iau. ");
INSERT INTO sgz_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Mái Kakang, koner a tarwa iau, ái mul a aposoi muswan sur iau. Má gam, káp gam tini longrai kaungán ngo mákái aur, ");
INSERT INTO sgz_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","má kápgamte lu kebeptai kán pinpidan iatung i bál gam, kabin kápgamte ruruna i iau á iau ái koner ákte tarwai. ");
INSERT INTO sgz_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Gam lu aratintin i Buk Tabu kabin gam hol on ngo gama ser pasi til on ngo ngádáh gama otoi ngoi á liu áklis. Má tilik támin táit on gamáte mák palai, kabin Buk Tabu a tus iau má a inngasi ngo iau ái sinih. Má kápgamte mák ilmi, ");
INSERT INTO sgz_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","má ngorer gam kulkulut ngo gama mur i iau suri gamák otoi liu. ");
INSERT INTO sgz_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Káp iau te ser suri parpara agas singin kálámul, ");
INSERT INTO sgz_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","mái sár iau mánán i gam ngo gam matngan kálámul ngádáh má kápte armámna ami bál gam sur Káláu. ");
INSERT INTO sgz_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ái Káláu ákte dos pala iau má iakte han, ái sár á gam kápgamte long pas iau. Má ngo tekes alatung na hut má nák lu worworwor ngorer i kán nemnem sang, ái gut gama árár pasi sang má gamák mur on. ");
INSERT INTO sgz_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Gam lala nem suri gama párnga arliu i gam sang i tan kálámul. Mái sár kápgamte nem suri ser pas Káláu er ái masik sár á Káláu, má kápgamte lu tohoi mul suri gama agasgas pasi bál má nák para agas gam. Má ngo kápte gam nem i mur i Káláu, ki ngádáh gama ruruna ngoi i iau? ");
INSERT INTO sgz_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Gam lala ruruna i Moses ngo na tur tangan gam, má gam hol on ngo á iau ina atiutiu gam i narsán ái Kakang. Má kápte a ngorer. Á iau káp ina te atatir uri gam si Kakang. Ái sár ái Moses, koner kamu ngangai a kis on, ái sang na atiutiu gam. ");
INSERT INTO sgz_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Má ngo gamáte ruruna i Moses, gama han ruruna i iau mul, kabin ái a worwor tus sur iau. ");
INSERT INTO sgz_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mái sár ngo kápgamte ruruna i táit a le on ái Moses, ki ngádáh gama ruruna mul ngoi i kak worwor á iau?” ");
INSERT INTO sgz_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Má namur ái Iesu má kán kalilik án aratintin di aptur má dik polsai dan taliu á Galiláiá mai mon (má kesá ngisán mul ngo dan taliu á Taiberias). ");
INSERT INTO sgz_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Má lala matananu di lu báiruruh namurwai kabin dikte mákái tan akiláng a longoi ái Iesu er a aliu pasi tan sasam. ");
INSERT INTO sgz_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Má ngo dikte hut ami kesi balis, ái Iesu a tapam urami kesi pungpung mák sukis pagas tiklik mai kán kalilik. ");
INSERT INTO sgz_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Má páput má i pákánbung suri longsit án sorliu palai káián tan Iudáiá. ");
INSERT INTO sgz_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Mái Iesu a sálsálah aririu má a mákái lala matananu di lu hanhan suri longrai kán worwor, má ngorer a gálta Pilip ngo, “Aiá gita huli ái á balbal artálár suri támri matananu min?” ");
INSERT INTO sgz_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","A parai ngorer suri tohtoh Pilip sár kabin ákte mánán pagas i táit na longoi. ");
INSERT INTO sgz_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Mái Pilip a kos Iesu ngo, “Auh, kápate arwat á pirán tabal! Má ngo kángit pirán tabal na sorliwi te na ru i mar, ki na arwat suri keskeskes tili di da ani mudán sár.” ");
INSERT INTO sgz_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Má kán kes mul á kalik án aratintin, ái Enru tuán ai Saimon Petero, a parai singin ngo, ");
INSERT INTO sgz_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kesi kalik almainái a kipi alim á tigán balbal má aru i isu. Má ngádáh má na artálár ngoi suri lala matananu minái?” ");
INSERT INTO sgz_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ái Iesu a longrai ngorer mák parai singin kán kalilik án aratintin ngo, “Gama parai singin matananu suri da sukis.” Pokon erei lain poron ur, má matananu no dik sukis má. Má tan kálámul no iatung di arwat mai alim i arip á káláu, má boh wák má kalilik kápte di wás pas di. ");
INSERT INTO sgz_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Mái Iesu a top pasi tan tigán balbal mák sung kári. Má namur ák tibi balbal má ák tari singin kán kalilik án aratintin suri dik tulsai i matananu di sukis iatung. Má a longoi ngorer mul mai aru isu. Má di no di namnam má dik mas. ");
INSERT INTO sgz_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Má namur ngo dikte mas má, ái Iesu a parai singin kán kalilik án aratintin ngo, “Gama kip talmi tan tingnán namnam kápdite ani. Koion gita omlawai.” ");
INSERT INTO sgz_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Má ngorer di kip talmi tan tingnán namnam er, má dik dung akángái sángul mai aru á lala rat mai balbal er di an tigán. ");
INSERT INTO sgz_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Má matananu erei di mákái akiláng ái Iesu a longoi má dik parai ngo, “A támin muswan sang ngo tám worwor tus er na hut ur main i naul bim, minái ákte hut!” ");
INSERT INTO sgz_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Mái Iesu a mánán i holhol káián matananu er, di nem ngo da long pasi má dák inar on suri na kabisit. Mái Iesu a matai, má ngorer ák aptur mul, ái masik sang, alar di urami pungpung. ");
INSERT INTO sgz_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Má i rahrah ngo ákte ronron, kán kalilik án aratintin ái Iesu di sosih kaleng uradi dan taliu. ");
INSERT INTO sgz_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Di roh uri mon má dik turpasi alus polsai dan taliu kaleng uradi Kapernaum. Má di iatung besang i lámán i katbán dan má ák libung. Mái Iesu kápte be a hut si di. ");
INSERT INTO sgz_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Má i pákánbung er, tiling kihkih a tur mák turpasi husai dan mák pos i nahlam. ");
INSERT INTO sgz_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Má tan kalilik dikte alus artálár mai alim ngo awon á kilomita, má namur dik mákmák má di mák Iesu a láklák iamuni kápkápán dan, a lu hanhan sur di uratung pátmi mon. Di mákái ngorer má dik ráuráuwas. ");
INSERT INTO sgz_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Mái Iesu a parai si di ngo, “Koion gama mátut, á iau sár á min.” ");
INSERT INTO sgz_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ngorer ák gáu i bál di, má dik long pasi urami polgon mon, má káp melek sár mon a masar iatung i pokon di han ur on. ");
INSERT INTO sgz_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Má matananu erei di ani balbal má isu, di lu kis iatung i balsán dan taliu i pokon di namnam ái, má dik bop iatung. Má arasa uri kábungbung, matananu erei di mánán ilmi ngo tukes sár á mon á iatung, má ngo tan kalilik án aratintin dikte han mai, mái Iesu kápate han tiklik mam di. ");
INSERT INTO sgz_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Má namur tan te lite mon til Taiberias di masar iatung i pokon er, pokon ái Iesu a sung kári namnam ái mák tabar di mai. ");
INSERT INTO sgz_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Má ngorer ngo matananu di mákái ngo a bokoh ái Iesu má kán kalilik án aratintin mul, di roh uri tan mon erei má dik han mai ur Kapernaum suri ser sur Iesu. ");
INSERT INTO sgz_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Má namur ngo matananu dikte hut iatung Kapernaum i balsán dan taliu tiladi, di mákmák sur Iesu, má ngo di ser pasi dik gáltai ngo, “Tám Aratintin, enges u hut main?” ");
INSERT INTO sgz_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Mái Iesu a kos di ngo, “A támin muswan ngo kápgamte mák tusi kak akiláng iau longoi má táit a inngasi. Gam ser sur iau sár kabin gam ani balbal má gamá mas. ");
INSERT INTO sgz_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Koion gama bes mai matngan namnam er na sangin. Ái sár gama bes mai matngan namnam kápnate sangin má ák tari liu áklis. Ái á matngan namnam erei Natun Kálámul na tari si gam, kabin ái Káláu Kákán ákte para tari ngo a sormángát palai.” ");
INSERT INTO sgz_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Matananu di longrai ngorer má dik gáltai ngoromin, “Matngan sál ngádáh gima mur on suri gima longoi ngorer ái Káláu a nem on?” ");
INSERT INTO sgz_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ái Iesu a kos di ngo, “Kápte ngo táit gam sang gama longoi, ái sár táit gama ruruna on. Ái Káláu a nem ngo gama ruruna i iau, koner ái ákte tarwai.” ");
INSERT INTO sgz_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Má ngorer di gáltai mul ngo, “Má matngan akiláng ngádáh una longoi suri gima mákái má gimák ruruna i iáu? Dánih sang una longoi? ");
INSERT INTO sgz_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Hirá rang kámpup i gim di lu ani mana ada i pokon mau, ngorer a parai i Buk Tabu ngo, ‘A tabar di mai namnam, wa balbal tilami bát.’” ");
INSERT INTO sgz_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Mái Iesu a parai si di ngoromin, “A támin muswan á minái. Ái Moses kápate tari balbal tilami bát. Ái Káláu sang ákte tari balbal tilami bát si rang kámpup i gam, mái sár balbal er kápte a támin táit. Támin táit a ngoromin, ngo inái ái Kakang a tari balbal muswan tilami bát. ");
INSERT INTO sgz_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Má balbal er ái Káláu a tari, wa ái koner sang a hut sosih tilami bát má ák tari balbal án liu muswan er a kis áklis uri naul matmatngan pokon.” ");
INSERT INTO sgz_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Má matananu di parai ngo, “Konom, una ekesi tari balbal er si gim.” ");
INSERT INTO sgz_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Má ngorer ái Iesu a para talsai si di ngoromin, “Á iau sár á balbal a tari liu. Ái koner na han sur iau, kápnate lu matpám mul. Mái koner a ruruna i iau, kápnate lu sák mul suri dan. ");
INSERT INTO sgz_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mái sár ngorer iakte parai si gam, gamáte mák iau má kápte gam ruruna. ");
INSERT INTO sgz_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Má tan kálámul erei ái Kakang a tari singing, di no da lákám uri narsang. Mái sinih alatung be na hut i narsang, káp ina te tipar palai, ");
INSERT INTO sgz_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","kabin iakte hut sosih tilami bát suri mur i nemnem si Koner a tarwa iau, má kápte ngo suri ina mur i kak nemnem sang. ");
INSERT INTO sgz_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Má nemnem si Koner a tarwa iau a ngoromin: káp ina te pánpánwai tekes tili di er ái Kakang a tari singing, má di no ina aliu pas di uri liu i arahrahi bung. ");
INSERT INTO sgz_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Má táit a nem on ái Kakang a ngoromin: ngo ái sinih a mák tus Natun mák ruruna on, ái na otoi liu muswan er a kis áklis. Mái rung er ina aliu pas di uri liu i arahrahi bung.” ");
INSERT INTO sgz_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Má tan tátáil káián tan Iudáiá di longrai kán worwor ái Iesu er a parai ngo, “Iau sár á balbal er a hut sosih tilami bát,” má ngorer di tangkabin ngurngurngur ur on ");
INSERT INTO sgz_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","má dik parai ngo, “Kálámul min ái Iesu, natun ái Iosep, be? Git mánán i kákán mái mámán. Má ngorer, suri dáh a parai ngo a hut sosih tilami bát?” ");
INSERT INTO sgz_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Mái Iesu a longrai ngorer mák parai si di ngoromin, “Koion gama ngurngurngur arliu i gam. ");
INSERT INTO sgz_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kápte kes na han sur iau ngo ái masik. Koran mái Kakang na tangnai uri narsang, ki erár na lákám sang. Mái koner a han sur iau, ái ina salaptur pasi uri liu i arahrahi bung. ");
INSERT INTO sgz_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kes tili di á tan tám worwor tus ákte parai ngo, ‘Ái Káláu sang na atintini tan kálámul no.’ Má kálámul dáh ákte kipi aratintin si Káláu Kakang má ákte longra pasi, ái na han sur iau. ");
INSERT INTO sgz_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kápte kes ákte mák Kakang. Á iau masik sár iau han tilami narsán ái Káláu er Kakang, iakte mákái. ");
INSERT INTO sgz_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","A támin muswan sang ngo ái sinih a ruruna i iau, ákte otoi liu muswan er a kis áklis. ");
INSERT INTO sgz_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Á iau sár á balbal a tari liu. ");
INSERT INTO sgz_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","A támin ngo rang kámpup i gam di ani mana ada i pokon mau, mái sár kápdite liu áklis mai. Namur ák han mat i kápán páplun i di. ");
INSERT INTO sgz_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mái sár matngan balbal tilami bát inái iau parai, ái á matngan a artálár mai taniá gam. Má ngo gama ani, kápte gama mat. ");
INSERT INTO sgz_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Á iau sang á balbal a tari liu, má iakte hut sosih tilami bát. Koner na ani balbal minái na liu áklis. Má balbal erei ina tari singin, ái á kápán páplun i iau iau tari suri matananu on á naul matmatngan pokon da liu.” ");
INSERT INTO sgz_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Má tan tátáil káián tan Iudáiá di longrai ngorer má dik turpasi togor má arngangar arliu i di. Dik parai ngo, “Ngádáh na tabar git ngoi mai kápán páplun á kálámul minái?” ");
INSERT INTO sgz_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Mái Iesu a parai si di ngoromin, “A támin muswan á minái. Ngo kápte gama ani kápán páplun Natun Kálámul má ngin i dárán, káp gama te liu muswan. ");
INSERT INTO sgz_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ái sinih a ani kápán páplun i iau má a ngin i dárang, káián sang á liu muswan er a kis áklis, má ina aliu pasi i arahrahi bung. ");
INSERT INTO sgz_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kápán páplun i iau, ái á namnam a támin. Má dárang, ái á dan muswan. ");
INSERT INTO sgz_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Koner a ani kápán páplun i iau má a ngin i dárang, giurá kes má, má ngorer ái a ararguna mam iau má iau lu ararguna mai. ");
INSERT INTO sgz_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ái Kakang, koner á káplabin á liu, ái a tarwa iau, má ái a aliu iau mul. Má ngorer ái sinih a ani páplun i iau, á iau ina aliwi. ");
INSERT INTO sgz_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Io ngorer má, balbal min a hut sosih tilami bát kápate ngorer i balbal erei rang kámpup i gam di ani má kápate aliu di áklis, kápte. Koner a ani balbal min na kis áklis i liu muswan.” ");
INSERT INTO sgz_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ái Iesu a parai ngorer mák arahi kán aratintin. Má kán aratintin minái a parai iatung i rumán lotu á Kapernaum. ");
INSERT INTO sgz_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Mái rung di lu murmur i Iesu di longrai kán worwor er, má marán tili di di arpua arliu i di ngoromin ngo, “Auh, wa pinpidan minái a rangas suri gita top páptai. Kápte kes a arwat suri na kipi á sálán.” ");
INSERT INTO sgz_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Mái sár ái Iesu a mánán tusi ngo rang táir er di arkipkip mai worwor suri, má ngorer a parai si di ngoromin, “Ngádáh, a tabureng i bál gam suri worwor min má gamá nem i arsok suri mur i iau? ");
INSERT INTO sgz_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ngo ngorer, ki dánih gama hol on ngo gama mákái Natun Kálámul na tapam kaleng urami pokon a kis ái á tungu? ");
INSERT INTO sgz_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Kálámul sang, káp kán te rakrakai arwat suri na tari liu singin kálámul. Tanián ái Káláu, ái a tari liu mák aliwi kálámul. Má worwor min iakte parai si gam, a mon i kán rakrakai artálár suri na tangnai Tanián ái Káláu suri na aliu gam. ");
INSERT INTO sgz_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mái sár, te tili gam kápte be di ruruna.” (Má til tungu sang, ái Iesu ákte mánán tusi ngo ái sinih kápnate ruruna on, má ákte mánán mul i koner na agur tari.) ");
INSERT INTO sgz_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Mái Iesu a bontai kán worwor ngo, “Áá, te tili gam kápte be di ruruna. Má ngorer á wán er iak parai si gam, ngo ái Kakang a mángát palai kálámul ngo na mur i iau, ngorer na mur on. Má ngo kápate mángtai ái Kakang, ki ngádáh na mur iau ngoi?” ");
INSERT INTO sgz_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Má rang táir ái Iesu er di longrai kán worwor, má ngorer marán tili di di su kaleng alari, má kápdite lu mur on mul. ");
INSERT INTO sgz_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Má ngorer ái Iesu a parai uri narsán sángul mai aru á kán kalik án aratintin ngo, “Má gam, ngádáh? Gam nem suri gama han mul?” ");
INSERT INTO sgz_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Mái Saimon Petero a kosoi ngoromin, “Konom, gima han uri narsá sinih? Kabin kam pinpidan sár á iáu, ái á sál gima mur on suri gima kis áklis i liu muswan. ");
INSERT INTO sgz_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Gimáte mák tus iáu má gimá ruruna ngo á iáu masik á Tám Pilpil káián ái Káláu ukte hut sosih tilami narsán.” ");
INSERT INTO sgz_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Mái Iesu a parai si di ngo, “Áá, iau ilwa pas gam gam tara sángul mai aru, be? Mái sár, kes tili gam er a sápkin tanián!” ");
INSERT INTO sgz_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Kán worwor ái Iesu minái a para Iudas, natun ái Saimon Iskariot, kabin ái Iudas ái á kes tili sángul mai aru á kán kalilik, mái sár na agur tari. ");
INSERT INTO sgz_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Má namur, ái Iesu a lu hanhan tangra balis á Galiláiá. A matai be ngo na tangrai balis á Iudáiá kabin tan tátáil káián tan Iudáiá di ser sál suri da up bingi. ");
INSERT INTO sgz_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Má longsit án pálpálih káián tan Iudáiá ákte páput má, ");
INSERT INTO sgz_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","má ngorer rang tuán ái Iesu di parai singin ngo, “Una han alari balis min urami balis á Iudáiá suri ngorer rung di lu murmur i iáu, da lu mákái matngan táit er u lu longoi. ");
INSERT INTO sgz_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ngo u nem ngo da árngai ngisam, ki káp una te long kodongnai kam him. Una longoi i mátán matananu i naul matmatngan pokon suri da mánán tus iáu.” ");
INSERT INTO sgz_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Rang tuán di parai ngorer si Iesu, mái sár kápdite ruruna muswan on. ");
INSERT INTO sgz_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ái Iesu a longrai ngorer mák parai si di ngoromin, “Á gam, pákánbung a artálár no suri gama han ur Ierusalem. Mái sár á iau, pákánbung ngo ina han urami, kápte be a hut. ");
INSERT INTO sgz_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Matananu i naul matmatngan pokon da togor i gam suri dánih? Wa kápte! Mái sár á iau, di tungai mikmikwa iau kabin kak tu parai uri di ngo ninsin i di a sák. ");
INSERT INTO sgz_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ngorer á gam, gama han suri á longsit er! Má iau, auh, wa káp ina te han suri, kabin kak pákánbung kápte be a hut.” ");
INSERT INTO sgz_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","A be parai ngorer ái Iesu, má áng kálik lu kiskis be i te bung á Galiláiá. ");
INSERT INTO sgz_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Io, rang tuán ái Iesu dikte han má suri longsit, má namur ái Iesu sang a han mul má a han kodong suri ngorer matananu da káp mák ilmi. ");
INSERT INTO sgz_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Má tan tátáil káián tan Iudáiá di batbatam kursál suri, má dik lu gálgálta ngo, “Aiá á kálámul erei?” ");
INSERT INTO sgz_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Má iatung i katbán matananu, marán di arasás arliu i di sur Iesu. Te di parai ngo, “Lain kálámul sang!” Má te bul di ngo, “Auh, kápte ngo lain kálámul. A lu agur pasi matananu.” ");
INSERT INTO sgz_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Mái sár kápte kesi kálámul a worwor talas sur Iesu. Di no di tu bál konmi kándi hol ur on kabin di matai tan tátáil da káp arangrangas i di. ");
INSERT INTO sgz_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ákte han i katbán á longsit án pálpálih, mái Iesu a hut má a kusak urami rumán osmapak mák turpasi aratintin. ");
INSERT INTO sgz_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Má tan tátáil káián tan Iudáiá di longrai kán aratintin ái Iesu, má dik pánsálngát suri táit a parai má dik parai ngoromin, “Kálámul min, káp kán te tám aratintin er a atintini suri nagogon. Má ngádáh a kipi ngoi á lala mánán er?” ");
INSERT INTO sgz_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Má ngorer ái Iesu a kos di ngoromin, “Kak aratintin kápte ngo kaiak sang, ái sár a tari ái Káláu singing, ái koner a tarwa iau. ");
INSERT INTO sgz_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ái sinih a ngoi i bál suri longoi kán nemnem ái Káláu, ái na mák ilmi mul i kak aratintin ngo aiá a hut til ái. A tari ái Káláu singing, ngo a hut sár tili kak hol masik? ");
INSERT INTO sgz_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kálámul a aratintin mák parai ngo kán aratintin a hut tili kán hol sang, ái a nem suri matananu da párngai ngisán. Mái sár, kálámul a matai ngo da párngai ngisán sang, má a nem suri sángwái ngisán ái koner a dos palai, kálámul er káp a tini angagur. Ái sár a kebeptai worwor si koner a dos palai má ngorer ák parai muswan. ");
INSERT INTO sgz_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ái Moses a tari nagogon si rang kámpup gam, be? Má sinih tili gam a lu taram on? Kápte kes! Má suri dáh gam nem i up iau?” ");
INSERT INTO sgz_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Má matananu di kosoi ngo, “Á iáu, a mon i sápkin tanián i iáu! Sinih er a nem ngo na up iáu?” ");
INSERT INTO sgz_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Mái Iesu a kos di mák parai ngo, “Iau longoi kesi akiláng sár má gam no gam sodar suri. ");
INSERT INTO sgz_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ái Moses a tari nagogon si gam suri gama kut aririu i rang nat gam. Má kápte ngo ái Moses a turpasi tatalen erei, wa rang kámpup i gam sang. Má ngo bung suri kut aririu ngo a arwat mai bungán aunges, gam lu parai ngo, ‘Káksiai ngo bungán aunges, a artálár suri gima longoi mudán him er on, kabin nagogon án kut aririu a pakta si diar i nagogon suri bungán aunges.’ ");
INSERT INTO sgz_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Áá, gam lu parai ngorer, mái sár á iau iau parai ngoromin ngo kut aririu di longoi uri kesi kuir kápán páplun sár, má gam lu longoi i bungán aunges suri gama long artálár pasi nagogon si Moses. Má ngorer, suri dáh gam togor i iau kabin iau aliu pasi kálámul i bungán aunges mák liu i kápán páplun no? ");
INSERT INTO sgz_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Koion gama atiutiwi kálámul suri táit gam mákái mai mát gam sár, ái sár gama mákmák mul uri támin i táit a longoi.” ");
INSERT INTO sgz_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Má te kálámul til Ierusalem sang di gálta ngo, “Kálámul minái gut, á tan tátáil di nem suri ubi, be? ");
INSERT INTO sgz_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Má gam mákái! A lu worwor i narsán matananu má kápte kes tili di a tur kári! Ngádáh, tan tátáil di mánán gut ngo ái á Mesaia? ");
INSERT INTO sgz_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Mái sár ngo ái Mesaia na hut, kápte kes na mánán ngo ai a han til ái. Má kálámul minái, git no git mánán i kán malar.” ");
INSERT INTO sgz_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Mái Iesu kán tu aratintin be iatung i rumán osmapak, má ngorer a parai ngoromin, “Ngádáh, gam mánán muswan i iau má kak malar iau han til on? Káp iau te hut tili kak nemnem sang. Ái Koner a dos pala iau, ái a muswan sang. Á gam kápgamte mánán on. ");
INSERT INTO sgz_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Mái sár á iau iau mánán on kabin iau han tili narsán má ái a dos pala iau.” ");
INSERT INTO sgz_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Mái rung er di longrai ngorer má dik tohoi suri da tola Iesu. Mái sár kápte kes a top on kabin kán pákánbung kápte be a hut. ");
INSERT INTO sgz_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Má marán tili matananu iatung di ruruna on má dik parai ngo, “Ngádáh má suri kálámul minái? Wa Mesaia sang! A támin ngo Mesaia na hut má na longoi tilik him. Má ngádáh, ngo tekesi kálámul bul na hut, ki na sak longoi tan akiláng na sorliwi akiláng a longoi ái konomin? Na kápte sang!” ");
INSERT INTO sgz_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Má tan Parisaio di longrai babaus i matananu di arasás i tan táit er sur Iesu, má ngorer di han narsán bos pakpakta kán tan tám osmapak má dik worwor talum, má ngorer dik dos palai tan tám arup tili rumán osmapak suri da tola Iesu. ");
INSERT INTO sgz_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Mái Iesu a parai ngoromin, “Ina kis mam gam i án mudán pákánbung sár, má namur ina han alar gam uri narsán ái Koner a tarwa iau. ");
INSERT INTO sgz_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Gama lu sálah sur iau, mái sár káp gama te ser pas iau, kabin pokon ina han ur ái, kápte gama han ur on.” ");
INSERT INTO sgz_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Má tan tátáil káián matananu Iudáiá di longrai kuir erei má dik argálta arliu i di sang ngo, “Aiá na han ur ái má káp gita te ser pasi? Na han uramuda singin rung tili risán má nák atintin di, be? ");
INSERT INTO sgz_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","A parai mul ngo gita mákmák suri, má kápte gita ser pasi, má ngo na han uri pokon kápte gita han ur on. Má dánih á sálán á ngorer a parai?” ");
INSERT INTO sgz_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Má i áwáwat i bung suri longsit án pálpálih a lala támin bung sang. Má on á bung er, ái Iesu a kodas mák perek ami bát ngoromin, “Ái sinih a sák suri dan, na lákám uri narsang má nák ngin. ");
INSERT INTO sgz_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","A ngorer a parai i Buk Tabu ngo, ‘Dan a tari liu na sal tili mátán upup imi bál ái koner a ruruna i iau.’” ");
INSERT INTO sgz_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Má worwor min a parai ái Iesu a tur suri Tanián ái Káláu. I pákánbung erei, ái Káláu kápte be a tarwai Tanián kabin kápte be di duruk Iesu suri da bás páptai má namur ái Káláu na long pasi urami narsán sang. Má namur, ngo ái Iesu ákte tapam urami, ki erár ái Káláu ák tarwai Tanián sang ur si rung di ruruna. ");
INSERT INTO sgz_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Má matananu di longrai worwor si Iesu er, má te tili di di parai ngo, “Kálámul min, wa ái á tám worwor tus git kis monai!” ");
INSERT INTO sgz_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Má te di parai ngo, “Ái sár á Mesaia!” Má te bul di parai ngo, “Wa Mesaia er, kápnate hut til Galiláiá! ");
INSERT INTO sgz_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Buk Tabu a parai ngo Mesaia na kalik mur si Dewit er kabisit, má na páng sang á Betilem, kán malar ái Dewit.” ");
INSERT INTO sgz_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Má ngorer holhol káián matananu a lite arsagil sur Iesu. ");
INSERT INTO sgz_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Te di nem suri tolai, mái sár kápte kes a top on. ");
INSERT INTO sgz_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Má tan tám arup tili rumán osmapak di kaleng uri narsán bos pakpakta kán tan tám osmapak má tan Parisaio. Má tan tátáil er di gáltai tan tám arup ngo, “Ngádáh a ngoi kápgamte tangnai ur mainái?” ");
INSERT INTO sgz_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Má tan tám arup di kosoi ngo, “Kápte kes a lu worwor ngoro kálámul erei. Kán aratintin a tuan lite sang.” ");
INSERT INTO sgz_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Má tan Parisaio di parai ngo, “Má gam mul, a agur gam, be? ");
INSERT INTO sgz_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Gamáte longrai tekesi tátáil ngo tekesi Parisaio a ruruna on? Wa kápte sang! ");
INSERT INTO sgz_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Mái sár matananu di lala ngul suri nagogon si Moses, má ngorer ái Káláu na amosrah i di no!” ");
INSERT INTO sgz_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Má kesi Parisaio iatung, ngisán ái Nikodimo, ái koner a han suri mák Iesu á tungu. Mái Nikodimo a parai singin tan tátáil má tan Parisaio erei ngoromin, ");
INSERT INTO sgz_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Uri nagogon kángit, gita mulán longrai kálámul má ser pasi táit ákte longoi. Má ngo ákte longoi sápkin, ki erár gita oboi nagogon on. Má kápate nokwan ngo gita arangrangas on má kápte be git longrai.” ");
INSERT INTO sgz_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Má tan tátáil er di kosoi má dik parai singin ngo, “Awái, á iáu mul til Galiláiá? Na, wa una mák tumani Buk Tabu suri una mánán ngo kápte kesá tám worwor tus na hut til Galiláiá!” ");
INSERT INTO sgz_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Io, má dik arsagil uri kándi tan malar, ");
INSERT INTO sgz_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","mái Iesu a tapam urami pungpung á Oliwa. ");
INSERT INTO sgz_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Má arasa i kábungbung sáksák, ái Iesu a kaleng urami rumán osmapak, má matananu no di hut talum kauli, má ngorer a sukis pagas má a turpasi atintin di. ");
INSERT INTO sgz_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tan tám mánán uri nagogon má tan Parisaio dikte tolai kesi wák. Wák er a ararit mai kálámul kápte ngo kán pup. Di mák diar má dik tolai wák, má namur má di tangnai uri rumán osmapak má dik atri narsán ái Iesu, ");
INSERT INTO sgz_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","má di parai si Iesu ngoromin, “Tám Aratintin, wák minái di tolai i pákánbung diar bop tiklik i kálámul. ");
INSERT INTO sgz_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Má on á nagogon kángit, ái Moses a ardos ngo matngan wák ngoromin da bás bingi mai hat. Má iáu, dánih una parai suri á tatalen ngoromin?” ");
INSERT INTO sgz_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Di parai ngorer suri da pidir pas Iesu, suri ngo da atiutiwi erei ngo na pálás palai wák er. Mái sár ái Iesu kápte be a para te táit, má a kis karokrok mák le iatung i bim mai kátngán limán. ");
INSERT INTO sgz_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Má kándi tu sámtur be iatung má gáltai suri táit er. Má namur ái Iesu a sámtur mák parai si di ngoromin, “A kuluk. Ái sinih tili gam kápate longoi sápkin be, ái sang na buswai mulán hat uri wák min.” ");
INSERT INTO sgz_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Mái Iesu a kis karokrok kaleng mul mák bali le iatung i bim. ");
INSERT INTO sgz_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Má ngo tan tátáil di longrai ngorer, di so keskeskes, turpasi mai tan pupunkak di so táil má tan matkán kálámul di mur. Mái Iesu iatung be, diar masik i wák er a sámtur pagas. ");
INSERT INTO sgz_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Má ngorer ái Iesu a sámtur mák parai singin wák er ngo, “Be, wákán, di ai mái rung er di wás pala iáu? Kápte kes a arangrangas i iáu?” ");
INSERT INTO sgz_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Má wák er a parai ngo, “Kápte kes, Konom. Dikte han no.” Mái Iesu a parai singin ngoromin, “Má iau mul, káp ina te oboi rangrangas i iáu. Una han má, má koion una mur i sápkin ninsim mul.” ");
INSERT INTO sgz_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Mái Iesu a parai si di mul á tan Parisaio ngo, “Á iau á talas uri naul matmatngan pokon. Koner a mur i iau kápnate láklák i kuron, ái sár na atur páptai talas a tari liu.” ");
INSERT INTO sgz_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Má tan Parisaio di parai singin ngo, “Inái má á iáu masik uk para apos iáu, má kápte kes suri atumran i kam worwor. Má ngorer kam worwor a tu táit bia. Má ngádáh gima mánán on ngoi ngo a támin?” ");
INSERT INTO sgz_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Mái Iesu a parai ngoromin, “Kápte sang! Ngo iau masik iau para apos iau, táit iau parai a támin kabin iau mánán i pokon iau han til ái má pokon ina han ur on. Má gam kápgamte mánán i pokon iau han til ái má pokon ina han ur on. ");
INSERT INTO sgz_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kamu nagogon a lu mur i holhol kán kálámul. Má iau, kápte iau lu atur tekes uri nagogon. ");
INSERT INTO sgz_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Mái sár ngo ina han atur tekes ngorer, ki kak nagogon na támin sang kabin kápte ngo iau masik iau longoi. Wa ái Kakang a dos pala iau, má ái giur tiklik giur nagogon. ");
INSERT INTO sgz_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Má kamu nagogon a parai ngo aru kálámul diar mákái táit má diará apapos ur on, má ngo kándiar apapos a tukes on, ki ngorer táit diar parai a támin. ");
INSERT INTO sgz_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Á iau sang iau para apos iau. Mái Kakang, koner a tarwa iau, ái mul a para apos iau.” ");
INSERT INTO sgz_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Má tan Parisaio di longrai ngorer má dik gáltai ngo, “Má aiá ái kakam?” Má ngorer ái Iesu a kos di ngo, “Kápgamte mánán i iau, má kápgamte mánán i Kakang mul. Ngo gam han mánán i iau, ki ngorer gama mánán mul i Kakang.” ");
INSERT INTO sgz_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","A parai tan táit minái ái Iesu i bung a aratintin ami rumán osmapak i kuir rum er a kis ái á nián omobop pirán tabal. Má kápte kes tili di a tolai kabin kán pákánbung kápte be a hut. ");
INSERT INTO sgz_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Mái Iesu a parai mul si di ngo, “Ina lu han alar gam. Gama ser sur iau, mái sár kamu sápkin gama mat mai. Má pokon iau han ur ái, kápgamte arwat suri gama han ur on.” ");
INSERT INTO sgz_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Tan tátáil káián tan Iudáiá di longrai ngorer má dik parai ngo, “A wa kálámul min a parai ngo kápgite arwat suri gita han uri pokon na han ur on. A sálán ngádáh á erei? Na bibing sang ngo dánih?” ");
INSERT INTO sgz_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Mái Iesu a kos di ngoromin, “Kamu malar sang á min i bim, mái sár á iau iau tilami. Gam sang til main i naul bim, má iau kápte ngo iau til main i bim. ");
INSERT INTO sgz_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Má ngorer iak parai si gam ngo kamu sápkin gama mat mai. A támin sang ngo gama mat mai kamu sápkin ngo kápte gam ruruna i iau ngo iau sár ái koner a támin.” ");
INSERT INTO sgz_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Mái rung er di gáltai ngo, “Á iáu ái sinih?” Mái Iesu a kos di ngoromin, “Á iau sár ái koner iakte parai si gam til tungu i tangkabin. ");
INSERT INTO sgz_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Marán táit er a artálár ngo ina parai sur gam, má marán mul á táit a artálár ngo ina nagogon i gam mai. Mái sár á iau masik káp ina te longoi ngorer. Ái Koner a tarwa iau, ái a mánán muswan i táit a támin, má ngorer iau parai singin naul matmatngan pokon i táit iau longrai singin sang.” ");
INSERT INTO sgz_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ái Iesu a worwor ngorer má a para tus Kákán sang, mái sár rung er di longrai, kápdite talas ur on. ");
INSERT INTO sgz_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Má ngorer a parai si di ngoromin, “Namur ngo gama durki Natun Kálámul suri bás páptai, ki erár gamák mánán ngo á iau sár ái koner a támin. Má i pákánbung erei sang, gama mánán tusi mul ngo kápte kesi táit iau long masiknai, ái sár iau parai táit ái Kakang ákte dos pala iau suri ina parai. ");
INSERT INTO sgz_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ái Koner a dos pala iau, giur tiklik áklis. Kápte a bokoh alar iau kabin iau lu long áklisnai matngan táit er a agasgas pasi bál.” ");
INSERT INTO sgz_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ái Iesu a parai ngorer, má marán tili di di longrai ki dik ruruna on. ");
INSERT INTO sgz_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Má ngorer ái Iesu a parai narsán te tan Iudáiá dikte ruruna on ngoromin, “Ngo gam kis pagas i lalin kak aratintin, ngorer gam kalilik án aratintin kaiak muswan, ");
INSERT INTO sgz_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","má gama mánán i támin muswan sur Káláu, má támin sur Káláu er na pálás gam gamák sengsegeng!” ");
INSERT INTO sgz_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Mái rung erei di kosoi ngo, “Á gim, gim rang kopkom i Abaram, má kápte kesá kálámul gim lu toptop singin. Má dánih á sálán er u parai ngo gima sengsegeng?” ");
INSERT INTO sgz_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Mái Iesu a parai si di ngoromin, “A támin muswan ngo ái koner a longoi sápkin, ái a toptop sár káián sápkin. ");
INSERT INTO sgz_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Aratámán kápte di lu wás páptai kándi toptop ngo a kes tili di muswan. Mái sár nat diar, ái a kes tili di áklis á aratámán er kabin a nat diar sang. ");
INSERT INTO sgz_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Má ngo ái Natun na pálás pala gam, ki erár gama sengsegeng muswan! ");
INSERT INTO sgz_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Iau mák ilam gam ngo gam rang kopkom i Abaram, mái sár kápgamte longra pasi kak worwor, má ngorer gam ser sál suri up iau. ");
INSERT INTO sgz_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Á iau iau inngasi tan táit iau mákái imi narsán ái Kakang, mái sár á gam gam mur i tatalen a lu longoi ái kák gam.” ");
INSERT INTO sgz_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Di longrai ngorer má ding kosoi ngo, “Ái Abaram á kák gim!” Mái Iesu a parai si di ngoromin, “Ngo gam rang natun ái Abaram muswan, ngorer gama han longoi matngan tatalen ái sang a lu longoi. ");
INSERT INTO sgz_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Á iau á kálámul iakte arbin narsá gam mai muswan sár er iau longrai si Káláu. Má kápte gam nem suri longrai, gam tu nem sár ngo gama up iau. Ái Abaram kápate lu longoi á ngorer! ");
INSERT INTO sgz_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kápgamte mur i tatalen si Abaram. Gam lu longoi ngorer a longoi ái kák gam!” Má di kos Iesu ngo, “Auh, wa tukes sár á kák gim, ái Káláu sang. Gim aratámán no mam Káláu, má gim á rang natun muswan!” ");
INSERT INTO sgz_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Mái Iesu a parai si di ngoromin, “Má ngo ái Káláu kák gam muswan sang, ki ngorer gama mámna iau kabin iau hut sosih tilami si Káláu má onin iau minái i narsá gam. Káp iau te hut kaiak sár, ái Kakang sang a dos pala iau. ");
INSERT INTO sgz_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Suri dáh kápgamte mánán pasi kak pinpidan? A kabin ngo gam ngákngák suri longra pasi sálán sang. ");
INSERT INTO sgz_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Á gam, gam rang natun i kák gam, ái Satan sang, má gam nem suri mur i nemnem káián ái kák gam. Til tungu i tangkabin a tám up bing kálámul, má a tám angagur mat, káp a tini para muswan i tekesi táit. I pákánbung a worwor, a angagur sár kabin a tu longoi ngorer sang i ninsin. Ái a tám angagur má a kákán angagur mul. ");
INSERT INTO sgz_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Má iau iau lu parai támin. Má pasi á ngorer, kápgamte ruruna i táit iau parai. ");
INSERT INTO sgz_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Kol tekes alatung a arwat suri para apos iau ngo iau longoi sápkin? Má ngo kápte, ki ngorer táit iau parai a támin. Má suri dáh kápgamte ruruna on? ");
INSERT INTO sgz_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ái koner a káián ái Káláu, ái a longra pasi worwor si Káláu. Má gam, kápgamte tili Káláu. Má pasi á ngorer, kápgamte alongra singin.” ");
INSERT INTO sgz_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Má tan Iudáiá erei di parai si Iesu ngo, “Na, wa gim parai támin sang ngo kam aratintin kápate muswan má a mon á sápkin tanián i iáu!” ");
INSERT INTO sgz_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Mái Iesu a kos di ngo, “Kápate mon i sápkin tanián i iau! Iau lu tari rumrum si Kakang, mái sár á gam gam lu arumrum iau. ");
INSERT INTO sgz_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Káp iau te hut suri ina bana te kálámul suri dák rumrum i iau. Mái sár kes er a kis a nem i di ngo da para agas iau, má ái kán nagogon a nokwan. ");
INSERT INTO sgz_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","A támin muswan sang ngo ái sinih a taram pasi kak pinpidan, ái kápnate mat.” ");
INSERT INTO sgz_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Má ngo tan Iudáiá di longrai ngorer, ki dik parai singin ngoromin, “Má inár gim mánán muswan i iáu ngo a mon á sápkin tanián i iáu! Ái Abaram má tan tám worwor tus no dikte mat. Má iáu u parai ngo ái sinih na taram pasi kam pinpidan, ái kápnate mat. ");
INSERT INTO sgz_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Kámpup gim ái Abaram ákte mat. Kol á iáu u pakta sorliu Abaram, be? Má tan tám worwor tus mul dikte mat. Má iáu sinih er u parai ngorer?” ");
INSERT INTO sgz_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Mái Iesu a kos di ngoromin, “Ngo iau sang ina para agas iau, kak parpara agas na tu táit bia. Mái koner a párnga iau, ái Kakang sár. Má ái ái koner gam utngi ngo kamu Káláu. ");
INSERT INTO sgz_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Kápgamte mánán on, mái sár iau mánán on. Ngo ina han parai ngo káp iau te mánán on, ngorer ina tám angagur ngoro gam, kabin iau mánán on sang má iak lu taram i kán pinpidan. ");
INSERT INTO sgz_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Kámpup gam ái Abaram a gasgas i bál suri na mákái kak bungun páng. Má a mákái ngorer mák laes.” ");
INSERT INTO sgz_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Má di parai singin ngo, “Iáu parai ngo ukte mák Abaram. Wa kam bet kápte be alim i sángul. Má ngádáh ukte mák Abaram ngoi?” ");
INSERT INTO sgz_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Mái Iesu a kos di ngo, “A támin muswan sang ngo kápte be a kis ái Abaram, má iau iakte kis má.” ");
INSERT INTO sgz_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Mái rung er di longrai ngorer má dik mos kabin di hol on ngo a pulus Káláu, má ngorer di top pasi tan hat suri ngo da básái mai. Mái sár ái Iesu a punpunam má a han alari rumán osmapak. ");
INSERT INTO sgz_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ái Iesu a láklák tangra sál, má a mákái kesi kálámul ákte rau má i mátán tili bung sang a páng on. ");
INSERT INTO sgz_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Má kán kalilik án aratintin di mul di mákái kálámul er má dik gálta Iesu ngo, “Tám Aratintin, dánih a longoi ák rau á kálámul minái? Kán sápkin tatalen sang, ngo ái kákán mái mámán diar longoi?” ");
INSERT INTO sgz_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Mái Iesu a kos di ngoromin, “Kálámul a rau er, kápte a káplabin i kán sápkin sang ngo sápkin si mámán mái kákán. Ái sár a rau ngorer suri inngasi rakrakai si Káláu er na aliu pasi. ");
INSERT INTO sgz_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Gita longoi sang á him si Koner a tarwa pala iau. Ái a dos pala iau mai kán him, má a nem suri gita longoi i pákánbung kán tu nas be, kabin kuron na hut má kápate artálár suri him mul. ");
INSERT INTO sgz_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","I pákánbung iau main be i naul bim, á iau á talas uri naul matmatngan pokon.” ");
INSERT INTO sgz_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ái Iesu a be parai ngorer, má namur a kis karokrok máng kanus uri bim. A ariwai bim mai kansán er ák ardolat má, má namur a long pasi pen er mák oboi i mátán rau, ");
INSERT INTO sgz_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","má a parai singin ngo, “Una han má unák gorsai arum adi mátán dan á Siloam.” (Má sálán ngisán dan er ngo ‘Dos Palai’.) Má kálámul er a rau a han mák gorsai aur má ák mákmák, má ngorer a kaleng uri kán rum. ");
INSERT INTO sgz_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Má rang turán má te kálámul dikte lu mákái tungu a lu sung, di iatung má di mákái kálámul er má dik gálta arliu i di ngo, “Be, kálámul minái sár a lu kis mák lu sung á tungu?” ");
INSERT INTO sgz_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Má te di parai ngo, “Áá, ái sár.” Má te sang di parai ngo, “Auh, kápte. Kálámul erei a tu mák ngoro ái sár.” Má kálámul erei sang a aptur mák parai ngo, “Áá, wa iau sár á minái.” ");
INSERT INTO sgz_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Mái rung er di longrai ngorer má dik gáltai ngoromin, “Ngádáh a ngoi á matam er ák pán?” ");
INSERT INTO sgz_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Má kálámul er a kos di ngo, “Ái koner si Iesu a longoi pen mák salsi matang mai, má ák parai singing suri ina han ur Siloam suri gorsai arung. Iak han ngorer má iak gorsai arung, má namur iak mákmák.” ");
INSERT INTO sgz_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Má di gáltai ngo, “Ai má kálámul erei?” Ki áng kos di ngoromin, “Siari má, káp iau te mánán on.” ");
INSERT INTO sgz_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Má matananu er di lami kálámul tungu a rau uri narsán tan Parisaio. ");
INSERT INTO sgz_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Má bung erei a bungán aunges sang ái Iesu a longoi pen mák oboi i mátán rau mák apádái mátán. ");
INSERT INTO sgz_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Má ngorer tan Parisaio di gáltai mul suri ngádáh a mákmák ngoi. Má kálámul er a parai si di ngo, “A oboi pen i matang má iak gorsai arung, má iak mákmák má.” ");
INSERT INTO sgz_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Má tan Parisaio di longrai ngorer, má te tili di di parai ngo, “Kálámul er kápte ngo tilami si Káláu kabin a longoi táit i bungán aunges, má ngorer kápate taram i nagogon kángit.” Mái sár te á tan Parisaio di parai ngo, “Auh, kápte a tám sápkin! Ngo kálámul a tám sápkin, kápate artálár suri na longoi matngan akiláng ngoro tan akiláng erei.” Má ngorer kándi hol á tan Parisaio er a lite arsagil sur Iesu. ");
INSERT INTO sgz_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Má ngorer tan Parisaio di bali gáltai kálámul er ngoromin, “Á iáu sang u parai ngo a apádái matam. Má dánih u hol on suri á kálámul erei?” Má kálámul er a parai ngo, “Wa a tám worwor tus sang!” ");
INSERT INTO sgz_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Tan tátáil káián matananu Iudáiá er di longrai táit a parai á kálámul er, mái sár di balbal kalar, má kápdite ruruna ngo kálámul er tungu a rau má onin ákte mákmák má. Má ngorer di artari pasi mámán mái kákán kálámul ");
INSERT INTO sgz_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","má dik gálta diar ngo, “Be, nat gaur á kálámul minái? Má gaur mángát ngo a rau til tungu a páng sang? Má ngo ngorer, ngádáh a ngoi ák mákmák onin?” ");
INSERT INTO sgz_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Mái kákán mái mámán á kálámul er diar parai ngoromin, “Giur mák ilmi ngo nat giur, má a támin ngo i pákánbung a páng a rau. ");
INSERT INTO sgz_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ái sár kápte giur mánán ngo ngádáh a pán ngoi á mátán á inái, má kápte giur mánán ngo sinih a apádái. Ákte kálámul má! Gam gáltai sang á gam! Ái a arwat suri kokos.” ");
INSERT INTO sgz_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Diará parai ngorer kabin diar mátut suri tan tátáil er da ekesi long pala diar alari rumán lotu. Diar mánán ngo tan tátáil káián matananu Iudáiá dikte mángát ngo ái sinih á tekes na aposoi kán hol sang ngo ái Iesu á Mesaia, tan tátáil er da obop palai tili rumán lotu, má kápnate lu lotu tiklik mam di mul. ");
INSERT INTO sgz_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Diar mánán ngorer má diará mátut, má ngorer má, diará parai ngo koion da gálta diar sang. Da gáltai nat diar kabin ái ákte pakta má. ");
INSERT INTO sgz_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Má ngorer tan tátáil di artari suri kálámul na kaleng mul, má dik parai singin ngo, “Una oror narsán ái Káláu ngo u parai támin suri kálámul er a latlat pas iáu, kabin gim mánán ngo ái a tám sápkin.” ");
INSERT INTO sgz_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Má kálámul er a kos di ngo, “Káp iau te mánán on ngo a tám sápkin ngo kápte. Tukes sár á táit iau mánán on. Tungu iau rau, má onin iakte mákmák má!” ");
INSERT INTO sgz_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Má tan Parisaio di bali gáltai ngo, “Dánih a longoi mam iáu er ák pán i matam?” ");
INSERT INTO sgz_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Má kálámul er ák parai si di ngoromin, “Iakte parai sár si gam, má kápgamte nem suri alongra. Gamá nem mul suri gama bal longrai suri dáh?” Má kálámul er a sopasun kán worwor mák ret mam di ngoromin, “Kol, gam nem ngo gama kán kalilik án aratintin gut á gam, be?” ");
INSERT INTO sgz_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tan tátáil er di longrai ngorer má dik lala mos, má ngorer di turpasi para bengtai kálámul er má dik parai ngo, “Á iáu sang una mur on á kálámul imunang! Má gim, gima mur sang i táit a parai ái Moses! ");
INSERT INTO sgz_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Gim mánán sang ngo ái Káláu a worwor ur si Moses. Mái sár, suri kálámul ái kono munang, kápte gim mánán ngo a han til ái!” ");
INSERT INTO sgz_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Má kálámul er a parai mul si di ngoromin, “Má ngádáh a ngoi? Ákte apán pasi matang á kálámul er, má kápgamte mák tusi ai a han til ái? ");
INSERT INTO sgz_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Git mánán ngo ái Káláu káp a tini tármai bos tám long sápkin. Mái sár suri rung er di lu lotu uri narsán má dik lu mur i kán nemnem, ái Káláu a lu longra pas di. ");
INSERT INTO sgz_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Til hirá i akaksim, kápgite lu longrai sur tekesi kálámul a apádái mátán kálámul a páng mai rau. ");
INSERT INTO sgz_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kálámul min a lu longoi matngan akiláng er kabin a hut sosih tilami si Káláu má ái Káláu a kis i narsán. Má ngo ái Káláu kápate kis narsán, kápate arwat suri longoi ngorer.” ");
INSERT INTO sgz_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Má tan tátáil er di kosoi ngo, “Á iáu ukte páng mai sápkin má uk lu pakpakta mai sápkin mul. Kam liu ákte káng mai sápkin sang. Má suri dáh u nem ngo una atintin gim?” Di be parai ngorer uri kálámul er, má namur dik tipar palai má dik long palai alari rumán lotu. ");
INSERT INTO sgz_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Má namur ái Iesu a longrai ngo dikte long palai kálámul er, má ngorer ái Iesu a ser pasi kálámul er má a gáltai ngo, “Má iáu ngádáh, u ruruna i Natun Kálámul?” ");
INSERT INTO sgz_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Má kálámul a kosoi ngoromin, “Má Konom, una parai singing ái sinih á Natun Kálámul suri inak ruruna on!” ");
INSERT INTO sgz_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Mái Iesu a parai singin ngo, “Ái sár ái koner u mákái má ák worwor mam iáu inái.” ");
INSERT INTO sgz_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Má kálámul er a mák ilam Iesu ngorer má a parai singin ngo, “Konom, iau ruruna!” Má namur a pur dirtapul mák lotu uri narsán ái Iesu. ");
INSERT INTO sgz_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Mái Iesu a parai ngoromin, “Iau tapam hut ur main i naul bim suri tut aposoi sápkin káián matananu. Má pasi á ngorer ái rung di rau, na pán i mát di. Mái sár rung er di hol on ngo dik talas, da tungai rau pagas.” ");
INSERT INTO sgz_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Má te Parisaio di iatung narsá diar di longrai ngorer má dik parai si Iesu ngo, “Má kápte sang u para gim er uk parai ngorer!” ");
INSERT INTO sgz_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Mái Iesu a kos di ngoromin, “Ngo gamáte parai ngo gam rau, ngorer káp gama te sámtur i nagogon. Mái sár gam parai ngo a talas i mát gam, ki erei má sálán ngo kamu tan sápkin a kis pagas i káil i gam sang.” ");
INSERT INTO sgz_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Mái Iesu a parai si di ngo, “A támin muswan sang ngoromin. Kesi áir kári sipsip iatung i malar má tan sipsip di lu mon on. Má kesi kálámul a sa tili áir má kápate kusak tili mátán kas. Gama mákái ngorer má gamák mák ilmi ngo kálámul er kápte ngo tám ololoh sipsip muswan, na wa tám siksikip sang a sa kus ngorer kabin a kákir suri na sikip tekesi sipsip. ");
INSERT INTO sgz_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Mái sár ngo gama mákái kálámul a kusak tili mátán kas, ki gama mák ilmi ngo ái á tám ololoh sipsip muswan. ");
INSERT INTO sgz_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Tám ololoh mátán kas a mákái kálámul a tám ololoh sipsip má a pasbat i mátán kas pasi, suri na kusak uri narsán tan sipsip. Má tan sipsip di longra ilmi kaungán kándi tám ololoh er a utung keskeskes i di mai ngis di, má a lam pas di dik so alari áir. ");
INSERT INTO sgz_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Má tám ololoh sipsip er a táilnai kán tan sipsip má dik lu mur on kabin di longra ilmi kaungán. ");
INSERT INTO sgz_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Má ngo tekesi temes, tan sipsip kápdate mur on, ái sár da táu alari kabin kápdite longra ilmi kaungán.” ");
INSERT INTO sgz_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ái Iesu a parai worwor artálár minái narsá di, mái sár kápte di talas suri sálán. ");
INSERT INTO sgz_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Mái Iesu a mákái ngorer mák para talsai si di ngoromin, “A támin muswan iau parai si gam. Á iau á mátán kas án sipsip. ");
INSERT INTO sgz_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Má marán dikte táil i iau má dikte parai ngo di sang á tám ololoh sipsip. Má kápte sang. Di tan tám siksikip sár, má tan sipsip kápdite taram i di. ");
INSERT INTO sgz_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Á iau á mátán kas. Ái sinih a lákám sur iau kápnate hiru, má na kusak má nák so kaleng suri ser namnam. ");
INSERT INTO sgz_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Tám siksikip a hut má sár suri sipki sipsip má suri up bingi má long sáksáknai. Ái sár á iau, iakte hut suri gama liu má suri liu er i gam na lu pakpakta hanhan. ");
INSERT INTO sgz_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Á iau á tám ololoh iau lu belbelken i kak tan sipsip. Lain tám ololoh sipsip a lu eran suri ngo na mat suri kán tan sipsip da mák hiru. ");
INSERT INTO sgz_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mái sár te kálámul a mon i kándi tan sipsip, di lu huli lite kálámul suri ololoh i tan sipsip. Má pákánbung tám ololoh erei ngo a mák pasi pap rokoi a han suri ubi tan sipsip, ki ák lu táu alari tan sipsip má kápte a lu ololoh kulukna di. Má pap rokoi a hut sang mák lu tipar sarai tan sipsip mák lu arat pasi kes tili di. ");
INSERT INTO sgz_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Kálámul er a táu kabin di tu huli sár suri na ololoh i tan sipsip, má tan sipsip er kápte ngo káián sang, má ngorer kápte a lala hol pas di. ");
INSERT INTO sgz_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Á iau á tám ololoh iau lu belbelken i kak tan sipsip. Ái Kakang a mánán i iau, má iau iau mánán i Kakang. Má ngorer mul iau mánán i kak tan sipsip, má di sang di mánán i iau. Má iakte eran suri ina mat sur di da mák hiru. ");
INSERT INTO sgz_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Kak te sipsip mul, kápte di tili numán sipsip minái. Má iau ina lam akusak pas di be. Da longra pasi kaungang, má ngorer da tukes mam rung dikte kusak táil. Má di no da kes sár á numán sipsip, má kes sár á tám ololoh na ololoh i di. ");
INSERT INTO sgz_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ái Kakang a mámna iau kabin iau bál palai kak liu suri ngorer inak top kalengnai mul. ");
INSERT INTO sgz_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kápte kes na long pasi kak liu alar iau, á iau sang iau bál tari. Iau arwat suri tari, má iau arwat mul suri top kalengnai. Ái Kakang ákte dos i iau suri ina longoi ngorer.” ");
INSERT INTO sgz_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Má tan Iudáiá erei di longrai ngorer mák lite arsagil mul i kándi hol kabin suri tan worwor er. ");
INSERT INTO sgz_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Marán di parai ngo, “Kálámul er a ngul sang, a mon i sápkin tanián on! Gam alongra singin suri dáh?” ");
INSERT INTO sgz_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Má te sang di parai ngo, “Auh, kápte. Kálámul a mon i sápkin tanián on kápnate para te táit ngoromin. Má ngádáh má na apádái rau ngoi ngo a mon i sápkin tanián on?” ");
INSERT INTO sgz_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Má namur, ákte taul gáwár má, má pákánbung mul án longsit ami Ierusalem suri akiláng i bung hirá dikte pasbat i rumán osmapak on. ");
INSERT INTO sgz_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ái Iesu a lu lákláklák iatung i rumán osmapak i nián sámtur si Solomon, ");
INSERT INTO sgz_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","má tara Iudáiá di tapam hut singin má dik tur kauli má dik gáltai ngo, “Gim lala kis mona iáu má! Enges una para tar iáu sang? Una parai muswan si gim. Á iáu á Mesaia ngo kápte?” ");
INSERT INTO sgz_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Mái Iesu a kos di ngoromin, “Iakte para tar iau má si gam, mái sár kápgamte ruruna i iau. Iau longoi tan tara támin táit ái Kakang a dos pala iau suri longoi, má tan táit erei a apapos uri iau. ");
INSERT INTO sgz_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Mái sár á gam kápgamte ruruna kabin kápgamte sipsip kaiak. ");
INSERT INTO sgz_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Kak tan sipsip di alongra suri kaungang. Iau mánán i di, má di sang di lu mur i iau. ");
INSERT INTO sgz_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Má iau tari si di á liu muswan er a kis áklis, má kápte da mat. Má kápte kes a arwat suri na ras pas di tili kak ololoh. ");
INSERT INTO sgz_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ái Kakang, koner ákte tari kak tan sipsip singing, ái a pakta sorliwi tan táit no. Má kápte kes a arwat suri na ras pasi kak tan sipsip tili limán ái Kakang. ");
INSERT INTO sgz_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ái Kakang má iau, giur tukes sár.” ");
INSERT INTO sgz_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tan Iudáiá di longrai ngorer má a mos i bál di, má dik long pasi tan hat suri básái. ");
INSERT INTO sgz_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Mái Iesu a parai si di ngo, “Marán i lain táit iakte longoi narsá gam ngorer ái Kakang a dos pala iau suri longoi. Tan lalain táit iau longoi, má kono dáh a sápkin uri mát gam er gamá nem suri up iau?” ");
INSERT INTO sgz_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Má tan Iudáiá di kosoi ngo, “Kápte gim nem suri bás iáu mai hat kabin i tan lain him ukte longoi, kápte. Ái sár gim mos kabin u pulus Káláu. Á iáu kálámul sár, má u hol apakta i iáu sang ngo gaur arwat ái Káláu.” ");
INSERT INTO sgz_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Mái Iesu a kos di ngoromin, “On á kamu nagogon, ái Káláu sang a parai singin tan kálámul ngo, ‘Gam sang gam ngoro Káláu!’ ");
INSERT INTO sgz_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Git mánán ngo táit a parai i Buk Tabu a támin muswan áklis. Má on á kuir Buk Tabu er, ái Káláu a para palai midán sang singin rung er má ák utung di ngo di ngoro Káláu. ");
INSERT INTO sgz_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Má ngo a utung di ngorer má di kálámul sár, ki ngádáh sur iau, á iau ái koner a ilwa pasi ái Káláu mák dos palai ur main i naul matmatngan pokon? Suri dáh gam atiutiu iau ngo iau pulus Káláu erei iau parai ngo iau Natun ái Káláu? ");
INSERT INTO sgz_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ngo á iau káp iau te longoi ngorer ái Kakang a nem on, ki koion gama ruruna i iau. ");
INSERT INTO sgz_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Mái sár ngo iau longoi sang ngorer a nem on, káksiai ngo kápgamte ruruna i iau, ái sár gama ruruna i tan akiláng iau longoi. Gama ruruna i táit iau longoi suri ngorer gama talas muswan ngo ái Kakang má iau, giur tukes sár.” ");
INSERT INTO sgz_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Matananu di longrai ngorer, má kes mul i pákán di tohoi suri tola Iesu, má káp sang. Ái Iesu a tu láklák alar di sár. ");
INSERT INTO sgz_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Mái Iesu má kán kalilik án aratintin di kaleng mul urada i balsán dan á Ioridan tilada uri pokon erei ái Ioanes Tám Arsiu a lu arsiu ái á tungu. Di hut iatung má ding kis. ");
INSERT INTO sgz_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Má marán kálámul di hut narsán, má di lu worwor arliu i di sang ngoromin ngo, “Ái Ioanes kápte a longoi akiláng, mái sár worwor no a parai suri kálámul min a támin.” ");
INSERT INTO sgz_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Má marán kálámul iatung di ruruna i Iesu. ");
INSERT INTO sgz_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Kesi kálámul a sasam ngisán ái Lasaro. Ái Lasaro kukun ái Maria mái Marta, má ditul kis i malar á Betani. Ái Maria ái koner a urai wel a tomtom uri keken ái Konom mák salsi mai nihun. ");
INSERT INTO sgz_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ái Lasaro a sasam ngorer, má aru kukun lik diará tarwa wor urada si Iesu ngoromin, “Konom, ái Lasaro er lain turam a sasam.” ");
INSERT INTO sgz_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Má ngo ái Iesu a longrai ngorer, a parai ngo, “Sasam minái kápte ngo na arahi liu si Lasaro. Ái sár a uri inngasi rakrakai má minmáir i Káláu, má suri minmáir i Natun ái Káláu na tur talas mul.” ");
INSERT INTO sgz_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ái Iesu a lala mámna Marta ditul kukun no, ");
INSERT INTO sgz_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","mái sár ngo a longrai arbin sur Lasaro ngo a sasam, kápate aptur melek suri han. A kis sár iatung pasi aru á bung mul. ");
INSERT INTO sgz_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Má namur a parai singin kán kalilik án aratintin ngo, “Git má, gitáng kaleng urami Iudáiá.” ");
INSERT INTO sgz_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Má tan kalilik án aratintin di kosoi ngoromin ngo, “Tám Aratintin, tungu sár tan tátáil káián tan Iudáiá di nem suri bás iáu. Má suri dáh u nem ngo gita kaleng urami?” ");
INSERT INTO sgz_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Mái Iesu a parai si di ngoromin, “Be, on á kesá pákán nas sángul mai aru á awa sang? Mái sinih a lu láklák i nas, kápate lu tutkum kabin talas a atalsai kán sál. ");
INSERT INTO sgz_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Mái sár ngo na láklák i kuron, ki na tutkum kabin talas a bokoh.” ");
INSERT INTO sgz_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ái Iesu a be parai ngorer, má namur a sopasun kán worwor ngoromin, “Tur git ái Lasaro ákte boptin má, má ina han urami suri ina áplas pasi.” ");
INSERT INTO sgz_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Má tan kalilik án aratintin di parai singin ngo, “Má Konom, ngo a boptin, nákte sengsegeng má.” ");
INSERT INTO sgz_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Sálán worwor si Iesu ngo ái Lasaro a mat, mái sár kalilik án aratintin kápdite talas ur on. Di hol on ngo a tu boptin sár. ");
INSERT INTO sgz_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Má ngorer ái Iesu a para talsai si di ngo, “Ái Lasaro ákte mat má. ");
INSERT INTO sgz_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Mái sár a kuluk ngo káp iau te kis narsán i pákánbung minái suri ngorer kamu ruruna i iau na pakta hanhan. Má git má urami narsán!” ");
INSERT INTO sgz_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Mái Tomas, koner di utngi mul mai Lulu, kes tili di á kalilik án aratintin, a parai singin rang turán ngoromin, “Git má, giták han mai kángit Tám Aratintin suri gita mat tiklik mai mul!” ");
INSERT INTO sgz_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Má ngo ái Iesu a hut iatung, ki ák mánán pasi ngo ái Lasaro ákte mat mákte bop pasi ahat á bung má. ");
INSERT INTO sgz_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Til Betani ur Ierusalem arwat mai atul á kilomita sár, ");
INSERT INTO sgz_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","má ngorer marán Iudáiá dikte hut suri mák Marta diar ái Maria, má suri abálbál diar kabin kuk diar ákte mat. ");
INSERT INTO sgz_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Má i pákánbung er ái Iesu a lu hanhan, ái Marta a longrai ngo er páput ái, má ngorer a han suri banbanah on. Mái Maria kán tu kis sang iatung i rum. ");
INSERT INTO sgz_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ái Marta a bana Iesu mák parai singin ngoromin, “Konom, ngo una han iain, kápnate han mat ái kukung! ");
INSERT INTO sgz_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mái sár iau talas ngo onin, káksiai ngo ákte mat, matngan dánih una sung Káláu suri, ái na tari singim.” ");
INSERT INTO sgz_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ái Iesu a parai si Marta ngo, “Kukum na liu kaleng.” ");
INSERT INTO sgz_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ái Marta a parai ngo, “Iau mánán ngo na aptur kaleng uri liu i arahrahi bung.” ");
INSERT INTO sgz_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Mái Iesu a parai singin ngoromin, “Á iau ái Koner iau lu apturi kálámul tili minat má iau lu tari liu singin. Ái sinih a ruruna i iau, káksiai ngo ákte mat, wa na liu sang. ");
INSERT INTO sgz_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Mái sinih a liu má ák ruruna i iau, kápnate ekesi mat. Tanián sang na liu áklis. Ngádáh, u ruruna on á táit iau parai ngo a támin?” ");
INSERT INTO sgz_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mái Marta a longrai ngorer má áng kosoi ngo, “Áá, Konom, iau ruruna ngo iáu á Mesaia, Natun ái Káláu sang, ái koner ái Káláu a oror pagas mai suri na hut sosih ur main i naul matmatngan pokon.” ");
INSERT INTO sgz_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ái Marta a be parai ngorer, ki áng kaleng urami rum, má a para kodongnai si tuán lik ái Maria ngo, “Ái Tám Aratintin ákte hut má, má ák gálta sur iáu.” ");
INSERT INTO sgz_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ái Maria a longrai ngorer má ák aptur, má a sangar i so suri na bana Iesu. ");
INSERT INTO sgz_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ái Iesu kápte be a hut muswan i malar. A iatung be i pokon ái Marta a banai ái. ");
INSERT INTO sgz_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Má i pákánbung ái Maria a aptur má ák sangar i han alari rum, tan Iudáiá er dikte han suri abálbálái, di hol on ngo a han urami tarang án minat er di obop Lasaro on suri na tang iatung. ");
INSERT INTO sgz_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ái Maria a lu hanhan má ák bana Iesu. A mák Iesu ngorer má ák pur dirtapul uri keken mák parai ngoromin, “Konom, ngo una han iain, kápnate han mat ái kukung!” ");
INSERT INTO sgz_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ái Iesu a mákái ngo a tang ái Maria, mái rung er di tiklik mai di tang mul. A mákái ngorer mák tuan taun i kán liu suri, ");
INSERT INTO sgz_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","má a gálta di ngo, “Aiá á tarang er gam oboi on?” Má di parai singin ngo, “Má lákám, Konom, unák mákái.” ");
INSERT INTO sgz_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ái Iesu a tang. ");
INSERT INTO sgz_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Má tan Iudáiá er di mákái ngorer má dik parai ngo, “Gam mákái, a lala mámna Lasaro sang!” ");
INSERT INTO sgz_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Má te tili di di parai ngoromin, “Kálámul minái ákte apádái mátán rau, be? Má ngorer a artálár mul suri na han aliu pas Lasaro tungu suri kápnate mat.” ");
INSERT INTO sgz_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Mái Iesu a hut ami tarang án minat si Lasaro mák tuan taun i kán liu mul suri. Tarang er a mátán hat sár dikte bor kári mai kesi hat iatung i mátán sál. ");
INSERT INTO sgz_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ái Iesu a mákái ngorer mák ardos ngo, “Gama long palai hat!” Mái Marta, kukun lik á kálámul er ákte mat, a parai si Iesu ngo, “Konom, ákte bop palai ahat i bung má, má ngorer ákte sangin má kápán páplun!” ");
INSERT INTO sgz_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Mái Iesu a parai singin ngoromin, “Ngádáh, káp iau te parai singim be? Ngo una ruruna, ki una mákái rakrakai si Káláu!” ");
INSERT INTO sgz_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Má tan kálámul di long palai hat alari tarang er. Má namur ái Iesu a tántán urami bát mák parai si Káláu ngo, “Iau ot kuluk uri narsam, Tata, ngo u lu longra iau. ");
INSERT INTO sgz_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Iau mánán ngo u lu ekesi alongra singing, mái sár minái iau parai suri rung min suri da ruruna ngo á iáu sang ukte tarwa iau.” ");
INSERT INTO sgz_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ái Iesu a parai ngorer, má namur a lala bin ngoromin, “Lasaro, una so ur main!” ");
INSERT INTO sgz_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mái Lasaro a so tilatung i tarang án minat. Aru i limán má aru i keken dikte duri má ding kápti mai sepen sulu, má aur mul, má tan sepen sulu er a iatung be i páplun. Mái Iesu a parai si di ngo, “Uláti be tan sepen sulu er til on má nák lu han.” ");
INSERT INTO sgz_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Má marán tili di á tan Iudáiá di hut suri mák Maria, di mákái akiláng a longoi ái Iesu má ngorer dik ruruna on. ");
INSERT INTO sgz_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Mái sár te tili di di kaleng ur Ierusalem uri narsán tan Parisaio, má di parai si di suri táit ákte longoi ái Iesu. ");
INSERT INTO sgz_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Má ngorer tan Parisaio má bos pakpakta kán tan tám osmapak di kis talum mai tan kaunsel má dik parai ngo, “Marán akiláng ákte longoi á kálámul min. Má dánih má gita longoi? ");
INSERT INTO sgz_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ngo gita tu mákmákái kálámul er ngorer, marán da ruruna on. Má ngorer nagogon til Rom da hut sang má tarápái kángit rumán osmapak, má da abilbiling i git no á tan Iudáiá!” ");
INSERT INTO sgz_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Má kes tili di á tan tátáil, ái Kaiapas, koner a tám osmapak táil i bet er sang, a sámtur mák parai si di ngo, “Kápgamte mánán kuluk uri táit minái! ");
INSERT INTO sgz_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ngádáh, kápte gam talas ngo tukes sár á kálámul na mat suri matananu da mák hiru no?” ");
INSERT INTO sgz_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kálámul er kápate talas uri táit a parai. A hol on ngo a tu worwor bia sár, ái sár kápte. Ái a tám osmapak táil i bet erei, má ngorer kán worwor er a worwor taru sang, má sálán ngo ái Iesu na mat suri matananu Iudáiá. ");
INSERT INTO sgz_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Má kápte ngo na mat sur di masik. Na mat suri iang talmi matananu si Káláu di tam sara i naul matmatngan pokon. Na mat ngorer má nák iang talum di uri kesi mát sár. ");
INSERT INTO sgz_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Má turpasi bung erei má, tan tátáil káián tan Iudáiá di eran páksi sál da mur on suri up Iesu. ");
INSERT INTO sgz_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Má ngorer ái Iesu kápate lu saliu i mátán matananu Iudáiá. Ái sár a han alari malar erei mák han uri malar á Eparaim a kis pátmi pokon mau. Má a lu kis iatung tiklik mai kán kalilik án aratintin. ");
INSERT INTO sgz_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Má longsit án sorliu palai káián tan Iudáiá ákte páput má. Má marán matananu tili tan malar no di han urami Ierusalem, má di lu longoi tatalen án arapilpil táil suri eran uri longsit er. ");
INSERT INTO sgz_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Má matananu er di lala mákmák sur Iesu. Má ngo di hut talum i rumán osmapak, di gálta arliu i di ngo, “Dánih gam hol on? Na han sang suri longsit ngo kápte?” ");
INSERT INTO sgz_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Má dikte artari má bos pakpakta kán tan tám osmapak má tan Parisaio ngo tekes a mánán ngo aiá a kis ái ái Iesu, na sangar i atatir si di suri ngorer da tolai. ");
INSERT INTO sgz_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Má awon á bung sár má suri longsit án sorliu palai, mái Iesu a kaleng urami Betani i malar si Lasaro, koner a aptur kalengnai alari minat. ");
INSERT INTO sgz_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Má rang turán ái Iesu dikte leget i namnam suri namnam tiklik mai. Ái Lasaro, ái mul a kis iatung suri namnam tiklik mam Iesu, mái Marta mul iatung a tulus di. ");
INSERT INTO sgz_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Kándi tu namnam besang, mái Maria, kukun lik ái Lasaro, a kipi átbán wel a tomtom má a pakta sang i mátán. A urai wel erei uri keken ái Iesu, má namur a salsi keken mai nihun. Má polgon rum a káng mai lain tomtomon wel er. ");
INSERT INTO sgz_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Má kesi kalik án aratintin si Iesu, ái Iudas Iskariot, koner na agur tari, a mákái ngorer mák parai ngo, ");
INSERT INTO sgz_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Má suri dáh á wák minái a longoi ngoromin mai wel erei? Mátán wel er artálár mai arul kán kálámul uri kesá kunlán bet. Arwat suri na sirai pasi pirán tabal, má pirán tabal er da tari singin tan sáhár!” ");
INSERT INTO sgz_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ái Iudas kápate lala hol pasi tan sáhár, ái sár a parai ngorer kabin a tám siksikip sang. Ái a tám ololoh pirán tabal káián ái Iesu má kán kalilik, má i te pákán sang a lu punam sál i te pirán tabal ur káián. ");
INSERT INTO sgz_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Mái Iesu a longrai táit er ái Iudas a parai suri wák er, má a parai ngo, “Káksiai! Wák minái na hol pasi táit a longoi mam iau namur i bung da tahun iau on. ");
INSERT INTO sgz_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tan sáhár di erei narsá gam áklis, mái sár á iau káp ina te kis áklis narsá gam.” ");
INSERT INTO sgz_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Má marán tan Iudáiá dikte longrai ngo ái Iesu a lu kiskis á Betani, má ngorer di han uratung. Di han suri mák Iesu, má di han mul suri mák Lasaro, ái koner a aptur kalengnai ái Iesu tili minat. ");
INSERT INTO sgz_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Má bos pakpakta kán tan tám osmapak di mákái ngorer má dik mánán pasi ngo marán Iudáiá dik su alar di sang má dik ilang sur Iesu kabin i akiláng er a longoi suri aptur kalengna Lasaro. Má ngorer má dik nem suri up bing Lasaro mul. ");
INSERT INTO sgz_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Má arasa uri kesi bung mul, má lala matananu er dikte han ur Ierusalem suri longsit án sorliu palai, di longrai ngo ái Iesu erei mái tangrai sál suri na hut á Ierusalem. ");
INSERT INTO sgz_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Má ngorer di kotoi tan rákán báibái má dik han suri bana Iesu. Dik lu hanhan ngorer má dik lu wakwakwak ngoromin ngo, “Huihui iá! Huihui iá! Ái Káláu na kuluk mam Koner a hut mai ngisán, wa koner a kabisit káián Israel!” ");
INSERT INTO sgz_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Mái Iesu a long pasi gengen dongki má ák sukis on, má a lu hanhan tangrai sál. Má minái a long artálár pasi worwor tili Buk Tabu er a parai ngo, ");
INSERT INTO sgz_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Matananu til Saion, koion gama mátut! Mákái! Erei má ái kamu kabisit, a kis i iátin gengen dongki.” ");
INSERT INTO sgz_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","I pákánbung erei sang, kán kalilik án aratintin di mákái ngorer má kápdite talas suri tan táit erei. Má namur ngo ái Iesu ákte tapam urami, ki erár di mákmák kaleng má dik hol pasi worwor er tili Buk Tabu, má dik mák ilmi mul ngo matananu dikte longoi sang mam Iesu ngorer a parai i Buk Tabu. ");
INSERT INTO sgz_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Má lala matananu er dikte hut suri mák Iesu kabin dikte longrai arbin suri akiláng a longoi er ák aptur kalengna Lasaro alari minat. Ái rung er di iatung tiklik mam Iesu i pákánbung a aptur pas Lasaro, dik lu balbal arbin suri, má ngorer marán di longrai. ");
INSERT INTO sgz_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tan Parisaio di mákái ngorer má dik para kalengnai si di ngo, “Gam mákái má! Káp gita te long te táit sang! Naul matmatngan pokon sang ákte mur i kálámul er!” ");
INSERT INTO sgz_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Má i pákánbung er, te rung tili risán iatung Ierusalem dikte ruruna i Káláu sang má dik lu mur i tatalen káián tan Iudáiá. Di han ur Ierusalem suri lotu tiklik mai tan Iudáiá i pákánbung án longsit. ");
INSERT INTO sgz_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Má di han narsá Pilip, koner til Betesaida i balis á Galiláiá, má dik parai singin ngo, “Ai, kono mer, gim nem suri worwor mam Iesu.” ");
INSERT INTO sgz_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ái Pilip a han mák parai si Enru, má diará han narsá Iesu má diará parai singin. ");
INSERT INTO sgz_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ái Iesu a longrai ngorer, má a kos diar ngoromin, “Pákánbung ákte hut má, má minmáir Natun Kálámul na tur talas. ");
INSERT INTO sgz_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","A támin muswan sang ngoromin. Ngo kesá kotlin padi, má ngo kápte kes a soi, ki ngorer na táit bia. Mái sár ngo di soi uri bim, a marang mák maukut, má ngorer na tikbut namur má nák maras má na oboi marán wán. ");
INSERT INTO sgz_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ái sinih a lala mámnai kán liu sang mák ololoh on, kán liu na bokoh alari. Mái koner kápate lala hol pasi kán liu main i naul bim, kán liu na kelsen bul uri liu muswan er a kis áklis. ");
INSERT INTO sgz_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ái koner a nem suri na him singing má na kak toptop, ái na lu mur i iau suri giura ekesi kis tiklik. Mái koner a him kaiak mák tangan iau, ái Kakang na durki sang.” ");
INSERT INTO sgz_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Mái Iesu a sopasun i kán worwor ngoromin, “A lala tabureng i balang onin, má dánih má ina longoi? Ngádáh, ina parai ngoromin si Kang ngo na long palai pákánbung án rangrangas alar iau? Auh, káp ina te parai ngorer kabin iau hut suri ina áslai pákánbung án rangrangas minái. ");
INSERT INTO sgz_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Kang, una inngas tar iáu singin matananu!” Ái Iesu a be parai ngorer, má namur kaungán kes tilami bát a worwor mák parai ngoromin, “Iakte apos tar iau i iáu tungu, má ina bali longoi mul namur.” ");
INSERT INTO sgz_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Má matananu di sámtur iatung di longrai worwor er, má te tili di di parai ngo, “Dánih erei? Wa pár gut!” Má te bul di ngo, “Na, wa angelo er a worwor mai!” ");
INSERT INTO sgz_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","A longrai ngorer ái Iesu má a parai si di ngoromin, “Worwor er gamáte longrai, kápte ngo na tangan iau, wa uri tangan gam sang. ");
INSERT INTO sgz_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Pákánbung onin sang má, nagogon uri naul matmatngan pokon na hut, má ái Káláu na tipar pala koner onin a kátlán naul matmatngan pokon. ");
INSERT INTO sgz_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Má iau, ngo da duruk pas iau urami alari naul bim, ngorer ina talkai matananu no uri narsang.” ");
INSERT INTO sgz_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Matngan worwor ngoromin ái Iesu a para tusi matngan minat er na áslai. ");
INSERT INTO sgz_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Má matananu di longrai ngorer má ding kosoi ngo, “Kángit nagogon a parai ngo Mesaia na liu áklis. Má ngádáh ngorer uk parai ngo Natun Kálámul da duruk pasi urami? Má Natun Kálámul, ái sinih?” ");
INSERT INTO sgz_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","A longrai ngorer ái Iesu máng kos di ngo, “Talas na iatung i katbán i gam i án mudán pákánbung sár. Ngorer gama láklák hanhan ngo kán tu talas be suri na máng kuron i gam tangra sál, kabin koner a láklák i kuron kápate mánán tusi ai a han ur ái. ");
INSERT INTO sgz_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ngorer ngo kán tu talas be, gama ruruna on suri gama rang natun ái Koner ái á talas muswan.” Io, a para noi worwor er ái Iesu, má a han mák punpunam alar di. ");
INSERT INTO sgz_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ái Iesu ákte longoi marán akiláng narsán matananu, mái sár kápdite ruruna on. ");
INSERT INTO sgz_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Má táit er a long artálár pasi worwor si Aisaia tám worwor tus er a parai ngo, “Konom, sinih ákte ruruna i kángim worwor? Má ái Konom ákte inngasi mingin si sinih?” ");
INSERT INTO sgz_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Má ngorer kápdite artálár suri da ruruna kabin ái Káláu a parai si Aisaia ngoromin mul, ");
INSERT INTO sgz_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Á iau ái Káláu iakte apedei mát di suri dik rau, má mát di kápnate talas. Má iakte alaklak i bál di suri kándi hol mul na kuron. Iau longoi ngorer suri da káp tapriu sur iau má iau ina mák asengsegeng pas di.” ");
INSERT INTO sgz_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ái Aisaia a parai ngoromin kabin ái ákte mák táilnai minmáir i Iesu pasi ák worwor ngorer. ");
INSERT INTO sgz_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Má i pákánbung erei, marán tili tan tátáil káián matananu Iudáiá dikte ruruna i Iesu. Mái sár kápdite para aposoi i mátán matananu kabin di bulat suri tan Parisaio da mák ekesi long pala di tili rumán lotu. ");
INSERT INTO sgz_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kápdite para aposoi kándi ruruna kabin di lala nem i párpárnga káián kálámul sár alari sorsormángát káián ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Má namur ái Iesu a perek ami bát ngoromin, “Ái sinih a ruruna i iau, kápate ruruna masik i iau, mái sár a ruruna mul i Koner a tarwa iau. ");
INSERT INTO sgz_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Mái sinih a mák iau, ái a mák Koner mul a tarwa iau. ");
INSERT INTO sgz_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Iakte kusak ur main i naul matmatngan pokon ngoro talas, má iau atalsai matananu suri kápdate lu kis pagas i kuron ái rung da ruruna i iau. ");
INSERT INTO sgz_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Má ái sinih a longrai kak pinpidan má kápate taram on, á iau káp ina te nagogon i koner. Káp iau te hut suri ina nagogon i matananu on á naul matmatngan pokon, ái sár suri ina aliu pas di. ");
INSERT INTO sgz_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ái koner a pua iau má kápate longra pasi kak pinpidan, a mon á kesá táit na nagogon on, wa kak pinpidan sang! Ái na nagogon i kálámul erei i áwáwat i bung. ");
INSERT INTO sgz_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","A muswan á min kabin táit iau parai kápate hut tili kak hol masik sár. Ái sár ái Kakang er a tarwa iau, ákte dos pala iau má ákte para talsai singing suri worwor sang ina parai. ");
INSERT INTO sgz_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ákte dos i iau ngorer, má iak mánán ngo kán arardos ái Kakang a aliwi matananu suri dák liu áklis. Má táit iau parai, ái á táit ái Tata a bit iau on ngo ina para aposoi narsá gam.” ");
INSERT INTO sgz_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Má longsit án sorliu palai ákte pátum má, mái Iesu a mánán on ngo pákánbung ákte hut má suri na han alari naul matmatngan pokon urami narsán ái Kákán. Ákte ekesi mámna di ái rung káián sang tili naul matmatngan pokon, má a mámna di sang pang i bung a rah i kán liu main i naul bim. ");
INSERT INTO sgz_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ákte ronron má, mái Iesu má kán kalilik án aratintin di sukis suri namnam. Mái Satan nengen sang ákte oboi i hol si Iudas Iskariot, natun ái Saimon, suri na agur tar Iesu. ");
INSERT INTO sgz_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Mái Iesu ákte mánán on ngo ái Kákán ákte obop noi tan táit uri limán, má a mánán ngo ákte han tilami narsá Káláu, má na kaleng urami narsán mul. ");
INSERT INTO sgz_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Má a salaptur pas tilatung i risán suh áng kátsá palai kán bobor, má a long pasi kesi taol máng kápti iatung i nahlán. ");
INSERT INTO sgz_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Má namur a urai dan uri kesi lus, má ák long pasi lus erei, má a turpasi gorsai keken kán kalilik án aratintin mai dan erei, má a salsi kik di ák sengseng mai taol tilatung i nahlán. ");
INSERT INTO sgz_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ái Iesu kán tu longoi ngorer mák han narsá Saimon Petero. Mái Petero a parai singin ngo, “Konom, u hol on ngo una gorsai kiking?” ");
INSERT INTO sgz_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Mái Iesu a kosoi ngo, “Kápute mánán be i táit iau longoi, mái sár namur una talas ur on.” ");
INSERT INTO sgz_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Mái Petero a parai ngo, “Kápte sang! Káp una te gorsai kiking!” Mái Iesu a parai singin ngoromin, “Ngo u matai ngo ina gorsai kikim, ki ngorer káp una te kes tili di má á rang táring.” ");
INSERT INTO sgz_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ái Saimon Petero a longrai ngorer mák parai si Iesu ngoromin, “Ngo ngorer, Konom, kápte ngo kiking masik una gorsai! Wa una gorsai mul i limang má unák siwi lulung!” ");
INSERT INTO sgz_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Mái Iesu a parai ngo, “Ái koner ákte siusiu, ki ákte pilpil no sang, má dánih na siusiu mul suri? Má ngo na láklák tangra sál má namur na kusak, ki erár na gorsai sár i keken. Gam no gam pilpil, ái sár kes tili gam á kápte.” ");
INSERT INTO sgz_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ái Iesu ákte mánán páksi koner na agur tari, má ngorer ák parai ngo, “Gam no gam pilpil, ái sár kes tili gam á kápte.” ");
INSERT INTO sgz_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ái Iesu a gorsa noi keken kán kalilik án aratintin, má ák long pasi kán bobor ák áksá kalengnai, ngorer áng kaleng uri risán suh mák sukis, má a gáltai kán kalilik ngoromin, “Gam talas mul ur on á táit minái iau longoi narsá gam? ");
INSERT INTO sgz_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Gam lu utung iau mai Tám Aratintin má mai Konom, má a nokwan kabin á iau á kamu Tám Aratintin sang má á iau á kamu Konom mul. ");
INSERT INTO sgz_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Á iau kamu Konom má kamu Tám Aratintin, má inái iakte siwi má kik gam. Ngorer gam mul gama gorsa arliu i kik gam. ");
INSERT INTO sgz_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Gamáte mákái má i tohtohpas iau longoi narsá gam, má ngorer gama longoi arliu i gam ngorer á iau iakte longoi mam gam. ");
INSERT INTO sgz_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","A támin muswan sang á minái. Kápte kesi tám arardos a pakta sorliwi kán konom, mái koner a kip worwor kápate pakta singin kálámul a dos palai. ");
INSERT INTO sgz_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Onin gamáte talas suri táit minái iakte parai ngo a támin. Má namur gama kuluk pala ngo gama mur arwat pasi táit er iau parai. ");
INSERT INTO sgz_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Má káp iau te parai táit min uri gam no. Iau mánán i gam ái rung iakte ilwa pas gam. Ái sár kes tili gam na long artálár pasi worwor tili Buk Tabu er a parai ngo, ‘Ái koner giur namnam tiklik, ái ákte ilang alar iau.’ ");
INSERT INTO sgz_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Iau parai táit minái si gam onin kápte be a hut, suri namur ngo ákte hut má, erár gama ruruna i iau ngo iau sár ái Koner a kis áklis. ");
INSERT INTO sgz_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","A támin muswan iau parai si gam. Ái sinih a árár pasi kálámul iau dos palai, ái a árár pas iau mul. Mái koner a árár pas iau, a árár pas Koner sang a tarwa iau.” ");
INSERT INTO sgz_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","A be parai ngorer ái Iesu, má namur a lala tabureng i bál má a para talsai ngoromin, “Támin muswan iau parai si gam, kes tili gam na agur tar iau.” ");
INSERT INTO sgz_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Má tan kalilik án aratintin di longrai ngorer má dik armák arliu i di sang. A ser i kándi hol suri kálámul dáh na longoi ngorer. ");
INSERT INTO sgz_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Má kesi kalik án aratintin, ái koner a lala mámnai ái Iesu, ái a kis pátum Iesu sár. ");
INSERT INTO sgz_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Mái Saimon Petero a kalkaluh ur singin suri na gálta Iesu ngo a para sinih á ngorer. ");
INSERT INTO sgz_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Má ngorer kalik án aratintin er a deng sur Iesu máng gáltai ngo, “Ái sinih be, Konom?” ");
INSERT INTO sgz_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Mái Iesu a parai ngo, “Ái á kálámul ina top pasi tigán balbal má inak dungi main i suir namnam má inak tari singin.” Má ngorer a top pasi kesi tigán balbal má a dungi i suir namnam mák tari si Iudas natun ái Saimon Iskariot. ");
INSERT INTO sgz_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Mái Iudas a top pasi tigán balbal er mák ani, má káp melek sár ái Satan a bonta noi kán kunlán liu. Mái Iesu a parai si Iudas ngo, “Una sangar i longoi táit er u han suri.” ");
INSERT INTO sgz_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Má kápte kesi tur di iatung i rum a talas suri táit ái Iesu a parai si Iudas. ");
INSERT INTO sgz_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ái Iudas a tám ololoh pirán tabal kándi, má ngorer te kalilik án aratintin di hol on ngo ái Iesu ákte dos palai suri na hul te táit er ngo da nem on be uri long namnam, ngo suri na tari mudán pirán tabal singin tan sáhár. ");
INSERT INTO sgz_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ái Iudas a be ani balbal erei, má a sangar i so alar di. Má i pákánbung er ákte libung má. ");
INSERT INTO sgz_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Má ngo ákte so ái Iudas, ái Iesu a parai si di ngoromin, “Onin minmáir Natun Kálámul na tur soura, má táit na longoi ái Natun Kálámul na inngasi mul i minmáir i Káláu. ");
INSERT INTO sgz_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Má táit na longoi ái Natun Kálámul, ngo na inngasi minmáir i Káláu, ki ngorer ái Káláu na sángwái ngisán ái Natun Kálámul suri ngis diar no na sorliu. Má onin sang, ái Káláu na sángwá pasi ngisán ái Natun. ");
INSERT INTO sgz_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Kang kalilik, ina kis mam gam i án mudán pákánbung sár. Gama mákmák sur iau, má na ngorer iakte parai singin tan Iudáiá tungu, má ina parai si gam mul onin ngo ‘Káp gama te han uri pokon ina han ur on.’ ");
INSERT INTO sgz_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Má inái iau tari hutngin arardos si gam ngoromin: gama armámna arliu i gam. Ngorer iakte longoi er iau mámna gam, ki gam bul gama longoi arliu i gam sang keskeskes. ");
INSERT INTO sgz_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ngo gama armámna arliu i gam ngorer, ki ngorer matananu no da mák ilmi ngo gam á rang táring sang.” ");
INSERT INTO sgz_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ái Saimon Petero a hol pasi worwor si Iesu er a parai ngo na han alar di, má ngorer a gáltai ngo, “Ai una han ur ái be, Konom?” Ái Iesu a longrai ngorer mák parai singin ngoromin, “Kápute artálár be suri una mur i iau uri pokon ina han ur ái, mái sár una mur i iau namur.” ");
INSERT INTO sgz_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Mái Petero a parai mul singin ngo, “Konom, suri dáh káp ina te mur i iáu be? Iakte eran suri ina mat sur iáu!” ");
INSERT INTO sgz_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Mái Iesu a kos Petero ngo, “War u parai támin sang ngo una mat sur iau? A támin muswan iau parai singim ngo kok kápnate tang besang, má una arkawar pala iau na tul i pákán.” ");
INSERT INTO sgz_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ái Iesu a parai singin kán kalilik án aratintin ngoromin, “Koion na tabureng i bál gam. Gam ruruna i Káláu, má gama ruruna mul i iau. ");
INSERT INTO sgz_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Marán i rum imi a lu kis ái ái Tata, má ina han urami suri eran páksi kamu tan rum gama lu kis on. Má ngo kápnate ian támin á ngorer iau parai si gam, ki káp ina te han parai. Mái sár a támin muswan, má ngorer iak para talsai si gam. ");
INSERT INTO sgz_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Má ngo iakte han má iakte eran páksi niá gam, namur ina kaleng má inak long pas gam suri gita kis tiklik i pokon ina kis ái. ");
INSERT INTO sgz_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Gam mánán i sál uri malar ina han ur on.” ");
INSERT INTO sgz_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Mái Tomas a longrai ngorer mák parai si Iesu ngo, “Konom, kápte gim mánán i malar er una han ur on. Má ngádáh gima mánán on ngoi á sál gima tangrai?” ");
INSERT INTO sgz_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Mái Iesu a kosoi ngo, “Á iau á sál, má á iau á káplabin á muswan, má á iau á káplabin á liu. Kápte kes na hut i narsán ái Kakang ngo kápate han táil uri narsang. ");
INSERT INTO sgz_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ngo gamáte mánán i iau má gamáte mák tus iau ngo iau sinih, ngorer gama talas mul sur Kakang má gama mánán on. Má turpasi onin, gam mánán on sang má gamáte mákái.” ");
INSERT INTO sgz_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Mái Pilip a parai singin ngo, “Konom, una inngas Kakam si gim gimák mákái, má ngorer náng kodong i bál gim.” ");
INSERT INTO sgz_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ái Iesu a kosoi ngoromin, “Iakte lala kis dol narsá gam, ái sár ngádáh a ngoi er uk parai ngo kápute mánán i iau, be Pilip? Ái sinih ákte mák iau, ái ákte mák Kakang mul. Má ngorer, suri dáh u parai ngo ina inngas Kakang si gam? ");
INSERT INTO sgz_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ngádáh, be Pilip, kápute ruruna be ngo ái Kakang má iau giur tukes sár? Tan pinpidan iakte parai si gam, kápate hut tili kak hol sár. Wa a hut sang si Kakang, koner giur kis tiklik, má i sál sár ngorer ái Kakang a lu longoi kán him ngoi. ");
INSERT INTO sgz_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Gama ruruna i táit iau parai ngo ái Kakang má iau giur tukes sár. Má ngo kápgamte arwat suri gama ruruna i táit iau parai, ki tan akiláng iau longoi na adikái kak worwor má na atalsai kamu hol ngo iau parai támin, má ngorer gama ruruna. ");
INSERT INTO sgz_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“A támin muswan sang in iau parai. Koner a mon i kán ruruna i iau, na longoi matngan akiláng ngorer iakte longoi. Má him na longoi na kálik tápál alari him iau longoi, má na pakta sorliu. Na artálár suri na longoi ngorer kabin á iau ina han má alari naul bim urami narsá Kakang. ");
INSERT INTO sgz_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Má matngan dánih gama sung suri i ngisang sang, ái ina longoi, suri ngorer á iau, ái Natun, ina aposoi minmáir i Kakang. ");
INSERT INTO sgz_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Áá, táit gam sung iau suri i ngisang, ina longoi.” ");
INSERT INTO sgz_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Mái Iesu a sopasun i kán worwor mák parai ngoromin, “Ngo gam mámna iau, ngorer gama mur noi kak tan arardos. ");
INSERT INTO sgz_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ina sung Kakang, má ái na tarwai kesi Tám Artangan bul, má ái na kis tiklik mam gam ekes pala. ");
INSERT INTO sgz_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Má Tám Artangan erei, ái á Tanián a Pilpil, koner a lu inngasi támin sur Káláu. Matananu i naul matmatngan pokon kápdite artálár suri da árár pasi uri bál di, kabin kápte di ilmi má kápdite mánán tusi. Mái sár á gam, gam mánán on kabin a kis tiklik mam gam, má erei i bál gam ái. ");
INSERT INTO sgz_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“I pákánbung ina bokoh alar gam, káp gama te kis án suisui. Ina kaleng mul uri narsá gam. ");
INSERT INTO sgz_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Án mudán pákánbung sár má, má ina bokoh, má matananu i naul matmatngan pokon kápdate mák iau mul. Ái sár á gam sang gama mák iau. Má kabin á iau á liu, ngorer gam sang gama liu. ");
INSERT INTO sgz_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Má i bung erei gama mák iau on mul, gama mánán tusi ngo á iau giur tukes sár ái Kakang, má gama mánán on mul ngo á gam githat tukes sár. ");
INSERT INTO sgz_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ái koner a hol pasi kak tan arardos má a lu taram on, ái ái koner a lu mámna iau. Mái koner a mámna iau, ái Kakang na mámnai sang. Má iau mul ina mámnai má ina hut narsán, má giura ararguna tiklik.” ");
INSERT INTO sgz_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Má kes tili di á tan kalilik, ái Iudas (kápte ngo Iudas Iskariot, kesi Iudas sang), ái a longrai ngorer a parai ái Iesu má a gáltai ngo, “Ngádáh a ngoi ngo una inngas tar iáu si gim masik, má káp una te tur talas i mátán matananu i naul matmatngan pokon suri dák mák iáu?” ");
INSERT INTO sgz_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Mái Iesu a kos Iudas ngo “Koner a mámna iau na mur i kak pinpidan. Ái Kakang na mámna koner a mámna iau, má giur ái Kakang giura hut i narsán má gimtula lu kis tiklik. ");
INSERT INTO sgz_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mái koner kápate mámna iau, ái kápate mur i kak pinpidan. Má kak pinpidan er iau parai má gamá longrai, kápate hut tili kak hol masik, wa kán pinpidan ái Kakang sang, má ákte dos pala iau mai. ");
INSERT INTO sgz_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Iakte parai si gam á táit minái onin git kis tiklik be. ");
INSERT INTO sgz_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Tám Artangan er, wa Tanián a Pilpil sang, ái Kakang na tarwai mai ngisang, má ái na apálsa gam suri gama hol páptai tan táit iakte parai si gam, má na atintin gam mul suri sálán. ");
INSERT INTO sgz_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Á iau ina han alar gam be, má matau imi bál gam na lu kis pagas. Matau erei má i bál gam iau tari si gam, ái a ngorer i matau min i balang. Naul matmatngan pokon a lu tari matau i te pákán, mái sár a lu tari tili karpala sár. Má iau kápte. Iau lu tari matau uri bál gam má ák lu kis áklis, má ngorer kak tatalen án tari matau a lite alari káián naul matmatngan pokon. Koion na tabureng i bál gam má koion á mátut. ");
INSERT INTO sgz_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Iakte parai si gam má gamáte longrai ngo ina han alar gam, má namur ina kaleng mul uri narsá gam. Ngo gama han mámna muswan i iau, ngorer gama laes suri ngo iau han uri narsá Kakang, kabin ái a pakta i giur. ");
INSERT INTO sgz_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Iau parai táit minái si gam onin kápte be a hut, suri namur ngo ákte hut má, ki erár gamák ruruna i kak worwor ngo a támin. ");
INSERT INTO sgz_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Káp ina te worwor mam gam ák dol kabin kálámul a kátlán naul matmatngan pokon, erei má na hut. Ái káp kán te rakrakai suri na kátlán i iau, kápte. ");
INSERT INTO sgz_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ái sár iau lu singli tan táit ngorer a dos i iau suri ái Kakang, má iau longoi ngorer suri matananu on á naul matmatngan pokon da mánán ilmi ngo iau mámna Kakang má iak lu taram on. Má gam lákám, giták aptur má til main!” ");
INSERT INTO sgz_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Mái Iesu a sopasun i kán worwor mul ngoromin, “Iau á sukán wain muswan, mái Kakang a tám himhimna. ");
INSERT INTO sgz_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tám himhimna a lu baur palai tan rákán i iau erei ngo kápate lu oboi wán. Má tan rákán er a lu u, tám himhimna a timani suri ngorer na manglah i aun suk má nák oboi marán wán. ");
INSERT INTO sgz_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Má gam, gamáte pilpil má, kabin suri kak aratintin iakte tari si gam. ");
INSERT INTO sgz_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Gama kes mam iau suri ngorer ina kes mam gam, má gita ararguna tiklik. Ngo rákán suk dikte tár palai tili aun, kápnate u. Mái sár ngo rákán a kis pagas sang tilatung i aun, ngorer na oboi wán. Má gam mul, ngo kápgamte kes mam iau, ngádáh gama oboi wán i gam ngoi? ");
INSERT INTO sgz_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Á iau á suk má gam á tan rákán. Ngo gama kaplah alar iau, ki káp gama te long tekesi táit sang. Ái sár ái koner a kes mam iau má iau kes mai, ái ina tángni má nák oboi marán wán. ");
INSERT INTO sgz_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mái koner kápate kes mam iau, a ngorer i rákán suk dikte baur palai má dik sápkai ák marang. Tan rákán ngorer ákte marang di lu sár talmi má buswai uri kámnah suri dik bam má. ");
INSERT INTO sgz_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Má ngo gama kes mam iau má ngo kak pinpidan na porta pagas i gam, ngorer gama sung Kakang suri dánih gam nem on, má na tabar gam mai. ");
INSERT INTO sgz_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ngo gam káhái marán i wán i gam, má ngo gam para tar gam ngo gam kalilik án aratintin kaiak, ki tan táit erei a mer Kakang mák sángwái ngisán. ");
INSERT INTO sgz_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Kak armámna uri narsá gam a ngorer sang i armámna si Kakang a mámna iau mai. Gama kes mam iau suri kak armámna na kis pagas i gam. ");
INSERT INTO sgz_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Á iau iakte mur noi arardos si Kakang, má kán armámna a kis pagas i iau. Má ngo gam taram i tan arardos kaiak, ngorer kak armámna na kis pagas i gam. ");
INSERT INTO sgz_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Iakte parai bos táit min si gam suri kak laes na kis i gam má na akángái bál gam má gamák parmat sang. ");
INSERT INTO sgz_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Má kak arardos a ngoromin: gama armámna arliu i gam ngorer iau longoi narsá gam. ");
INSERT INTO sgz_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ái koner a mat suri rang turán a inngasi kán lala armámna sur di. Má kápte armámna alatung a pakta sorliwi matngan armámna erei. ");
INSERT INTO sgz_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Má ngo gam taram i táit iau parai si gam, ngorer gamá rang turang sang. ");
INSERT INTO sgz_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Káp ina te utung gam mul mai kak tan tám arardos kabin tám arardos kápate talas suri dánih kán konom a lu longoi. Ái sár iau utung gam mai rang turang kabin iakte pálási si gam á tan táit no iakte longrai si Kakang. ");
INSERT INTO sgz_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Kápte gam ilwa pas iau. Á iau sang iau ilwa pas gam, má iau dos pala gam suri gama han má gama longoi talar iau tari si gam má gamák oboi marán wán i gam, matngan wán er a lu ekesi kis má. Má ngorer gama sung Kakang i ngisang suri dánih gam nem on, má na tabar gam mai. ");
INSERT INTO sgz_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Má ngoromin á kak arardos uri narsá gam: gama armámna arliu i gam.” ");
INSERT INTO sgz_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Mái Iesu a sopasun i kán aratintin mai inau ngoromin, “I pákánbung matananu on á naul matmatngan pokon di lu mikmikwa gam, ki gama hol pasi ngo dikte lu mikmikwa iau táil. ");
INSERT INTO sgz_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","A mon á rákán matananu káián naul matmatngan pokon a tur kaplah alar iau. Má ngo gam tili rákán matananu er, ki ngorer da nem i gam kabin gam ngorer i di sang. Mái sár, kápte gam tili rákán matananu er kabin iakte ilwa pas gam alar di, má kápte ngo gam káián naul matmatngan pokon mul. Má pasi á ngorer, rákán matananu erei di mikmikwa gam. ");
INSERT INTO sgz_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Gama hol páptai ngorer iakte parai si gam ngo, ‘Kápte kesi tám arardos a pakta sorliwi kán konom.’ Te dikte arangrangas i iau, má ngorer da arangrangas i gam mul. Mái rung dikte taram i kak pinpidan, á di sang da taram i táit mul gama parai. ");
INSERT INTO sgz_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ái rung er da arangrangas i gam, da longoi ngorer kabin á gam rang táring, má kabin kápdite mánán i Koner a tarwa iau ur mainái. ");
INSERT INTO sgz_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Ngo káp ina te han hut má worwor narsá di, kápdate han mák ilmi kándi sápkin, má kápnate rumrum i bál di i mátán ái Káláu. Mái sár iakte han má iakte worwor mam di, má ngorer onin kápdite arwat suri parai ngo, ‘Na, wa kápgimte talas sár ngo táit gim longoi a sápkin!’ ");
INSERT INTO sgz_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ái sinih a mikmikwa iau, ái a mikmikwa Kakang mul. ");
INSERT INTO sgz_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Iau longoi tan matngan akiláng ngorer kápte kes a longoi tungu. Má ngo káp ina te han longoi tan akiláng erei, ki kápdate han mák ilmi kándi sápkin má kápnate rumrum i bál di i mátán ái Káláu. Mái sár dikte mákái tan akiláng erei iau longoi, má ngorer di mikmikwa giur no ái Kakang. ");
INSERT INTO sgz_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Má a kuluk, táit minái a hut suri long artálár pasi worwor tili kándi nagogon er a parai ngoromin, ‘Di tu mikmikwa iau, má kápte kápkabin muswan.’ ");
INSERT INTO sgz_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Tám Artangan na hut be, má ái sang á Tanián a tarwai ái Káláu, má a lu aposoi támin sur Káláu. Á iau ina tarwa palai Tám Artangan tilami narsán ái Kakang uratung i narsá gam, má ái na lu ataltalsa gam sur iau. ");
INSERT INTO sgz_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Má gam mul gama lu worwor talas sur iau kabin gamáte lu kis tiklik mam iau til tungu iau turpasi aratintin.” ");
INSERT INTO sgz_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Mái Iesu a sopasun i kán worwor mák parai ngo, “Iakte parai si gam ngoromin suri koion gama arsok i kamu ruruna. ");
INSERT INTO sgz_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Namur da ekesi long pala gam tili rumán lotu, má na hut sang i pákánbung te kálámul da nem suri up bing gam má da hol on ngo di tangan Káláu mai ngorer. ");
INSERT INTO sgz_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Má tan kálámul da longoi tan táit ngorer mam gam kabin kápdite mánán i iau má kápdite mánán i Kakang mul. ");
INSERT INTO sgz_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mái sár iakte parai si gam ngoromin suri namur, ngo na hut i pákánbung má da longoi ngorer mam gam, ki erár gama hol pasi kak worwor minái.” Mái Iesu a sopasun i kán worwor mul mák parai ngoromin, “Káp iau te bit gam on á tan táit minái tungu i tangkabin kabin a mon be i kak pákánbung ina kis tiklik mam gam. ");
INSERT INTO sgz_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Mái sár onin ina han alar gam be urami narsán ái Koner a tarwa iau, ái sár kápte kes tili gam a gálta iau suri ai ina han ur ái. ");
INSERT INTO sgz_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Má inái iakte parai si gam ngorer, má bál gam ákte tinang má. ");
INSERT INTO sgz_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Má iau parai támin muswan si gam á ngoromin ngo a kuluk ngo ina han alar gam be. Ngo káp ina te bokoh, Tám Artangan kápnate hut sur gam. Ái sár ngo ina han alar gam sang, ki a artálár ngo ina tarwa palai Tám Artangan ur main i narsá gam. ");
INSERT INTO sgz_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Má i pákánbung ái Tám Artangan na hut main, a mon i kán talar na lu longoi uri narsán matananu on á naul matmatngan pokon. Na lu para tari si di ngo kándi hol kápate nokwan suri sápkin má suri a nokwan má suri nagogon si Káláu. ");
INSERT INTO sgz_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Di hol on ngo di mánán suri sápkin tatalen, ái sár kándi hol kápate nokwan kabin di sang dikte longoi lala sápkin taladeng er ngo dikte tari bah di ur singing má di tánlak suri da ruruna i iau. ");
INSERT INTO sgz_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Di hol on ngo di mánán suri a nokwan, ái sár kápte. Kándi hol kápate talas kabin di sang di mata iau má di hol on ngo iau tám sápkin. Mái sár ái Káláu a mángát pas iau, má ngorer na long pas iau inak tapam urami narsán, má kápte gama mák iau mul mainái. ");
INSERT INTO sgz_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Má di hol on mul ngo di mánán suri nagogon si Káláu ngo na hut namur. Ái sár kápate nokwan i kándi hol kabin kesi rákán nagogon ákte kis má, mái koner a kátlán naul matmatngan pokon minái ákte tur i nagogon, má ái Káláu ákte atri rangrangas on. ");
INSERT INTO sgz_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Lala marán i táit mul ngo ina parai si gam, mái sár kápgamte arwat be suri gama top on. ");
INSERT INTO sgz_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Mái sár namur, i pákánbung na hut i Tanián, koner a lu aposoi támin sur Káláu, ái sang na aposoi támin uri kamu hol. Má ái kápnate worwor tili kán hol masik sár, kápte. Wa na parai táit a lu longrai si Káláu má tan táit mul er na hut be. ");
INSERT INTO sgz_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Má na sángáu iau kabin na kipi táit iau parai má na bit gam on. ");
INSERT INTO sgz_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tan táit no káián ái Kakang a kaiak no, má ngorer iak parai ngo ái Tanián na kipi táit iau parai má na bit gam on.” ");
INSERT INTO sgz_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Mái Iesu a parai mul ngo, “I án mudán pákánbung sár má káp gama te mák iau. Má namur i án mudán pákánbung mul, ki gamák mák iau kaleng.” ");
INSERT INTO sgz_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tan kalilik án aratintin di longrai erei a parai ái Iesu, má te tili di di ngátngát sálán má dik worwor arliu i di ngoromin, “A parai si git ngo i án mudán pákánbung sár má káp gita te mákái, má namur i án mudán pákánbung mul ki gita mákái sang. Má a parai mul ngo, ‘A kabin ina han urami narsán ái Kakang.’ Suri dáh a parai ngorer? ");
INSERT INTO sgz_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Má dánih á sálán á ngorer a parai ngo ‘i án mudán pákánbung sár’? Kápte git talas suri táit er a parai.” ");
INSERT INTO sgz_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ái Iesu a mánán ngo kán kalilik án aratintin di nem suri gáltai, má ngorer ái sang a parai si di, “Iau parai ngo i án mudán pákánbung sár má káp gama te mák iau. Má namur i án mudán pákánbung mul, má gamák mák iau kaleng. Ái á táit min kamu tunga gálta arliu i gam mai, be? ");
INSERT INTO sgz_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","A támin muswan sang ngo gama tang má gama sum i án pákánbung er, ái sár matananu tili naul matmatngan pokon da laes má dák parmat. Gama konngek má gama tabureng sang, má namur kamu tabureng na arkeles uri gasgas. ");
INSERT INTO sgz_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","A ngorer i wák a tián má páput suri na kákáh. Ái a lala konngek suri kán pákánbung er má na hut, má na áslai rangrang. Mái sár namur, ngo ákte páng á kalik, kápate hol pasi mul á rangrang kabin a gasgas ngo kán kalik ákte páng má. ");
INSERT INTO sgz_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","A ngorer á onin mam gam, gam konngek má gamá tabureng sang. Má namur ina mák gam mul má bál gam na káng mai gasgas. Matngan gasgas erei kápte kes a arwat suri na ras pasi alar gam. ");
INSERT INTO sgz_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Má namur, ngo ákte hut mái bung erei, kápte gama lu gálta iau sur tekesi táit. A támin muswan ngo matngan dánih gama sung suri i ngisang sang, ái Kakang na tari si gam. ");
INSERT INTO sgz_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Til tungu kápte gam lu sung sur te táit i ngisang. Má turpasi onin gama lu sung, mái Kakang na lu artabar uri narsá gam suri ngorer bál gam na gasgas pagas no.” ");
INSERT INTO sgz_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Mái Iesu a sopasun i kán aratintin mák parai ngo, “Til tungu iau lu worwor artálár sár suri tan táit i narsá gam. Mái sár erei má na hut á pákánbung má kápte mul ina worwor artálár, ái sár ina para atalsai si gam sur Kakang. ");
INSERT INTO sgz_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Má namur ngo ákte hut mái bung erei, káp ina te tur i katbán suri ina lu sung Kakang sur gam. Á gam sang má, gama sung Kakang i ngisang ");
INSERT INTO sgz_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","kabin ái sang ái Kakang a mámna gam, má a mámna gam ngorer kabin gam mámna iau má gamá ruruna ngo iau hut sosih tilami si Káláu. ");
INSERT INTO sgz_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Áá, a támin ngo iakte hut sosih ur main i naul matmatngan pokon tilami narsán ái Kakang. Má onin ina kaleng urami narsá Kakang alari naul matmatngan pokon.” ");
INSERT INTO sgz_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Má kán kalilik án aratintin di longrai ngorer má dik parai ngoromin, “Áá, erei má ák talas á kam worwor kabin kápute parai kam pinpidan mai worwor artálár! ");
INSERT INTO sgz_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Má onin gim mánán sang ngo ukte talas suri tan táit no. Kápute lu argálta mam tekes kabin ukte mánán táil i táit na parai. Má gim mákái ngorer má gimá ruruna sang ngo á iáu ukte hut sosih tilami si Káláu.” ");
INSERT INTO sgz_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ái Iesu a longrai kándi worwor er má ák parai si di ngo, “Ngádáh, gamáte ruruna má onin? ");
INSERT INTO sgz_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Bung er na hut má ákte hut má mul ngo gama tam han arsagil alar iau. Keskeskes tili gam na kaleng uri kán malar, má á iau masik ina lu kis. Má kápte ngo ina kis masik muswan, kabin ái Kakang giur no. ");
INSERT INTO sgz_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Iakte parai ngoromin si gam kabin git kes sár, má ngorer matau na kis pagas iatung i bál gam. Main i naul matmatngan pokon, gama lu áslai rangrangas. Mái sár koion gama mátut kabin iakte suka bámiai rakrakai káián naul matmatngan pokon!” ");
INSERT INTO sgz_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ái Iesu a be parai ngorer, má namur a tántán urami bát mák sung Káláu ngoromin, “Kang, pákánbung ákte hut má! Una inngasi be i minmáir i Natum suri ngorer Natum na inngasi minmáir i iáu. ");
INSERT INTO sgz_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kabin á iáu ukte obop Natum ami iátin kálámul no má uk amuswan tari singin suri na kátlán i di, suri ngorer Natum na tari si di ái rung er ukte tari singin á liu muswan er a kis áklis. ");
INSERT INTO sgz_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Má sálán matngan liu ngorer a ngoromin sár: da mánán i iáu, iáu masik sár á Káláu muswan, má da mánán mul i Iesu Karisito, koner ukte tarwai. ");
INSERT INTO sgz_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Kang, iakte arahi má á talar u tari singing má ngorer iau inngasi minmáir i iáu main i bim. ");
INSERT INTO sgz_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Má onin una sángáu iau i narsam, Tata, ngorer u lu longoi tungu kápte be u aksimi naul matmatngan pokon.” ");
INSERT INTO sgz_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Mái Iesu a sopasun i kán sung mák parai ngoromin, “Ái rung er u tari singing tili naul matmatngan pokon, á di, iakte para talsa iáu si di má dik mánán i iáu má. Di kaiam sang, mái sár ukte tar di singing. Dik lu mur i kam pinpidan, ");
INSERT INTO sgz_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","má onin dikte mánán on ngo tan táit no u tari singing a hut muswan tili limam. ");
INSERT INTO sgz_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Midam erei u tari singing, iakte tari si di má dikte top on, má dik talas ngo a támin ngo iau hut sosih tilatung singim, má dik ruruna ngo á iáu sang ukte tarwa iau. ");
INSERT INTO sgz_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Iau sung sur rung er ukte tari singing kabin di kaiam. Mái sár káp iau te sung suri matananu káián naul matmatngan pokon. ");
INSERT INTO sgz_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ái rung no er kaiak, di kaiam mul. Mái rung no er kaiam, di kaiak. Má di lu aposoi minmáir i iau tili ninsi di. ");
INSERT INTO sgz_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Káp ina te kis ák dol main i naul matmatngan pokon, má erei má ina kaleng uri narsam. Mái rung er da lu kis sang main i katbán matananu tili naul matmatngan pokon. U, Kakang iáu Tám Pilpil, iau sung iáu ngoromin sur di sang, suri una mákmák kalar di má una kebepta di mai kam rakrakai sorliu, ái á rakrakai er ukte tari singing. Una longoi ngorer suri da kes sár ngorer i gitar gitar kes sár má. ");
INSERT INTO sgz_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","I pákánbung gim kis tiklik main i bim, iau lu kebepta di mai kam tilik rakrakai er u tari singing. Iau ababah kalar di má kápte kes tili di a rong, ái sár kesá kálámul er kán sál a lam arongoi uri hiru, má ngorer a mur arwat pasi worwor tili Buk Tabu mul. ");
INSERT INTO sgz_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Páput má ina kaleng urami narsam, má kak sung minái iau parai i pákánbung kak tu kis be main i naul matmatngan pokon. Iau sung ngorer suri kak gasgas na kis sang i di má na bonta noi bál di. ");
INSERT INTO sgz_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","“Kam pinpidan iakte tari si di, má ngorer matananu tili naul matmatngan pokon dik mikmikwa di. Di mikmikwa di ngorer kabin di ngoro iau. Á iau kápte ngo kak malar min i bim, má di mul kápdite kes mam rung til main i naul matmatngan pokon. ");
INSERT INTO sgz_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Má kak sung minái, káp iau te sung ngo una top pas di alari naul matmatngan pokon. Ái sár iau sung ngo una ololoh i di, má da riutais i iáu na mák up di ái koner si Tám Sápkin. ");
INSERT INTO sgz_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Á iau kápte ngo kak malar min i bim. Má di ngorer mul, kápdite kes mam di ái rung til main i naul matmatngan pokon. ");
INSERT INTO sgz_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Kam pinpidan a támin muswan, má iau nem ngo una obop timani kam pinpidan suri na him i bál di má nák timan pas di dáng kálámul kaiam sang. ");
INSERT INTO sgz_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Iau dos pala di uri naul matmatngan pokon ngorer sár á iáu ukte dos pala iau. ");
INSERT INTO sgz_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Má inái iau tari kak artabar mam iau uri narsam, má ngorer na tangan di suri di mul da tar noi kándi liu singim má dáng kálámul kaiam muswan.” ");
INSERT INTO sgz_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Mái Iesu a sopasun mul i kán sung ngoromin, “Iakte sung má sur rung er u tari singing, wa kang kalilik án aratintin sang. Má inái iau sung mul sur rung di ruruna i iau kabin dikte longrai apapos káián kang kalilik. ");
INSERT INTO sgz_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Má Tata, ái rung er tan tám ruruna, iau sung ngo da tukes sár mai kesi kepwen hol. Má iau sung mul ngo da kes mam gitar ngorer gitar tukes, á iáu min i iau má iau erei i iáu. Iau nem ngo git no gita tukes má gita ararguna tiklik. Má a kuluk ngo da tukes ngorer suri matananu on á naul matmatngan pokon da mákái ngorer má dák ruruna ngo á iáu ukte tarwa iau. ");
INSERT INTO sgz_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Má matngan minmáir er u tari singing, iakte tari mul si di suri da tukes ngorer i gitar, ");
INSERT INTO sgz_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","wa á iau erei i di má iáu min i iau, suri ngorer da tukes sár. Má matananu on á naul matmatngan pokon da mák tusi ngo á iáu u tarwa iau, má iáu u mámna di ngorer u mámna iau. ");
INSERT INTO sgz_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Kang, á iáu ukte tar di singing, má iau nem i di suri gima kis tiklik i pokon ina kis ái suri da mákái minmáir i iau. Má minmáir erei, á iáu u mámna iau má ngorer uk tari singing hirá kápte be u aksimi naul matmatngan pokon. ");
INSERT INTO sgz_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","U, Kakang iáu Tám Nokwan, tan kálámul tili naul matmatngan pokon kápte di mánán i iáu. Mái sár á iau iau mánán i iáu, má rang táring di mánán ngo á iáu ukte tarwa iau. ");
INSERT INTO sgz_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Iakte inngas iáu si di, má ina lu longoi mul ngorer uramunang sang. Ina lu longoi ngorer suri di sang da lu armámna ngorer sang i iáu u lu mámna iau ngoi, má suri á iau ina kes mam di.” ");
INSERT INTO sgz_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","I pákánbung a arahi kán sung ái Iesu, ái mai kán kalilik án aratintin di aptur má dik láklák polsai polon dan á Kitoron uri kesi balsán uri pokon a mon i numán lowo ái, má ding kusak uri num erei. ");
INSERT INTO sgz_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ái Iudas, koner tám arasong, ái mul a mánán i pokon er kabin marán pákán ái Iesu mai kán kalilik án aratintin di lu hut talum iatung. ");
INSERT INTO sgz_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Má pasi á ngorer, bos pakpakta kán tan tám osmapak má tan Parisaio dik dos palai te tan tám mákmák kalar tili rumán osmapak suri da tiklik mam Iudas, má te bos tám arup til Rom mul di han tiklik mam di. Mái rung er di kipi kándi tan papam má dik top i tan lam má tan dák mul, mái Iudas a lam di uratung i pokon er suri da tola Iesu. ");
INSERT INTO sgz_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ái Iesu a mánán i tan táit no na tapam hut singin, má ngorer ngo a mákái tan kálámul di han suri tola pasi, ngorer a sakpap uramudi táil mák gálta di ngo, “Gam mákmák sur sinih?” ");
INSERT INTO sgz_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Má di kosoi ngo, “Gim mákmák sur Iesu til Nasaret.” Mái Iesu a parai ngo, “Á iau á minái.” Ái Iudas, koner a agur tari, a sámtur iatung tiklik mai tan tám arup. ");
INSERT INTO sgz_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Má i pákánbung ái Iesu a parai ngo, “Á iau á minái,” tan tám arup er di su kaleng alari má dik pur uri bim. ");
INSERT INTO sgz_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Mái Iesu a bali gálta di ngo, “Ái sinih sang gam mákmák suri?” Má di parai ngo, “Ái Iesu til Nasaret.” ");
INSERT INTO sgz_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Má ngorer ái Iesu a parai si di ngo, “Iakte parai sár si gam ngo á iau á minái. Má ngo gam mákmák sur iau, ki gama hol palai rang turang min.” ");
INSERT INTO sgz_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ái Iesu a parai ngorer suri long artálár pasi kán worwor ákte parai ngo, “Kang, kápte kes tili rung er ukte tari singing a rong.” ");
INSERT INTO sgz_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Mái Saimon Petero kápate nem i ngorer di longoi mam Iesu, má ák taruh pasi kán is mák tárái toptop káián tám osmapak táil uri talngán mák tár kus palai talngán mingin. Má ngisán toptop er ái Malkus. ");
INSERT INTO sgz_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Mái Iesu a mákái ngorer mák parai si Petero ngo, “Una dung kalengnai kam is i kuán! Ngádáh, u hol on ngo káp ina te ngin tili kinleh án rangrangas er ái Kakang a tari singing?” ");
INSERT INTO sgz_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Boh tám arup til Rom mai kándi tátáil má tan tám mákmák kári rumán osmapak dikte tola Iesu má di kápti limán, ");
INSERT INTO sgz_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","má dik mulán tangnai uri narsán ái Anas. Ái Anas diar iánán ái Kaiapas kabin ái Kaiapas ákte kila pasi natun tahlik ái Anas. Mái Kaiapas, ái ái koner a tám osmapak táil i bet erei, ");
INSERT INTO sgz_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","má tungu ákte parai singin tan tátáil káián matananu Iudáiá ngo a kuluk ngo tukes sár á kálámul na mat kári matananu da mák hiru no. ");
INSERT INTO sgz_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Mái Saimon Petero diar i kesi kalik án aratintin mul diar mur i Iesu. Má kalik er a lala mánán on ái tám osmapak táil, ngorer a kusak tiklik mam Iesu uri pelbut i rum káián tátáil er, ");
INSERT INTO sgz_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","mái Petero iatung be i risán mátán kas. Má namur, kalik er a kaleng uratung i mátán kas mák worwor mai toptop án wák a sámtur iatung suri na long pas Petero urami polgon pelbut, má ngorer ái Petero a kusak. ");
INSERT INTO sgz_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Má wák er a mák Petero mák parai singin ngo, “Má iáu mul á kesi kalik án aratintin káián kálámul er, be?” Mái Petero a kosoi ngo, “Auh, á iau á kápte.” ");
INSERT INTO sgz_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Libung er a gáwár, má tan toptop má tan tám mákmák kalar dikte oloi kámnah, má kándi tu sámtur kári má manmanir. Mái Petero a láklák sur di uratung má ák manmanir mul. ");
INSERT INTO sgz_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mái Iesu dikte atri iatung i mátán táil ái Anas, tungu a tám osmapak táil. Mái Anas a lu gálta Iesu suri kán tan kalilik án aratintin má suri kán aratintin mul. ");
INSERT INTO sgz_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Mái Iesu a kosoi ngoromin, “Iau lu worwor sara narsán matananu. Má kak aratintin, iau lu aratintin i rumán lotu má ami rumán osmapak i pokon tan matananu no di lu hut talum ái. Káp iau te lu para kodongna tekesi táit. ");
INSERT INTO sgz_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Má suri dáh u gálta iau? Una gálta rung er di lu longra iau. Gálta di be suri dánih iau parai si di. Di mánán i tan táit iakte parai.” ");
INSERT INTO sgz_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Má ngo ái Iesu a parai ngorer, kesi tám mákmák kalar iatung a posri kepsen mák parai singin ngo, “Suri dáh u kokos ngorer narsán tám osmapak táil?” ");
INSERT INTO sgz_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Mái Iesu a kosoi ngoromin, “Ngo iakte utngi te táit a sák, una parai singin matananu no minái suri dák talas. Mái sár ngo iakte parai táit a nokwan, ki suri dáh u posar iau?” ");
INSERT INTO sgz_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ái Anas a longrai ngorer, má namur a dos pala Iesu uri narsán ái Kaiapas, tám osmapak táil. Má limán ái Iesu a kamkabat pagas. ");
INSERT INTO sgz_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Mái Petero kán tu sámtur má manmanir be iatung, má te kálámul iatung mul di parai singin ngo, “Má iáu mul á kesi kalik án aratintin káián kálámul er, be?” Mái Petero a arkawar mák parai ngo, “Na, á iau á kápte!” ");
INSERT INTO sgz_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Má kesi toptop káián tám osmapak táil a iatung mul, má ái a buhán i kálámul erei ái Petero a tár palai talngán. Má toptop er a parai si Petero ngo, “Nengen iau mák iáu u tiklik mai ami numán lowo, be?” ");
INSERT INTO sgz_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Mái Petero a arkawar mul, má káp melek sár kok a tang. ");
INSERT INTO sgz_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","I kábungbung sáksák, tan tám arup di long pas Iesu tili rum si Kaiapas uratung i rum káián ái Pilato, kálámul pakta til Rom. Matananu Iudáiá di ruruna ngoromin. Ngo da kusak uri rum káián kálámul tili risán, ngorer rum erei na long adurwán i di má kápdate artálár suri ani namnam i longsit án sorliu palai. Má ngorer, tan tátáil káián matananu Iudáiá kápdite kusak, ái Iesu masik sár tiklik mai tan tám arup sár. ");
INSERT INTO sgz_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Má ngorer ái Pilato a so tili kán rum uri narsán tan tátáil mák gálta di ngoromin, “Dánih á táit a sák a longoi á kálámul min má gam atiutiwi suri?” ");
INSERT INTO sgz_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Má ding kos Pilato ngo, “Kápate artálár ngo gima tangnai ur main singim ngo kápnate han longoi sápkin.” ");
INSERT INTO sgz_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Mái Pilato a parai si di ngoromin, “Má gam sang gama long pasi má gama atri i kamu nagogon.” Má tan tátáil di parai ngo, “Auh, má kamu nagogon til Rom kápate sormángát i gim suri oboi kálámul uri minat.” ");
INSERT INTO sgz_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Má táit minái a hut suri long arwat pasi worwor si Iesu er a para tusi ngo matngan minat ngádáh na áslai. ");
INSERT INTO sgz_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Mái Pilato a kaleng urami rum má a dos i tan tám arup suri long pas Iesu uri narsán, má ngorer a gáltai ngo, “Be, á iáu á kabisit káián tan Iudáiá?” ");
INSERT INTO sgz_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ái Iesu a kosoi máng gáltai ngo, “Ngádáh? Á iáu sár u tu gálta iau mai á worwor min, ngo te kálámul dikte parai singim sur iau?” ");
INSERT INTO sgz_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Mái Pilato a kosoi mul ngo, “Auh, kápte ngo iau á kakun Iudáiá suri ina mánán on. Na, wa kam matananu sang má kándi bos pakpakta kán tan tám osmapak, di sang di sisdo iáu uri limang má dik parai ngorer singing. Má sápkin táit ngádáh ukte longoi?” ");
INSERT INTO sgz_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Mái Iesu a parai singin ngoromin, “Kápte ngo kak lolsit til main i naul bim. Koran má na han til main i naul bim, tan rang táring da han arwat suri arup kalar iau suri koion tan Iudáiá da obop iau uri kándi nagogon. Áá, kápte ngo kábutkis i kak lolsit til mainái.” ");
INSERT INTO sgz_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ái Pilato a longrai ngorer mák gáltai ngo, “Ki ngorer á iáu á kabisit, be?” Mái Iesu a kosoi ngo, “Á iáu sang u parai ngo iau kabisit. Iau hut ur main i bim má iak páng suri sál minái sár, suri parai pinpidan a támin muswan. Mái koner a lu tiptipar namurwai muswan, ái a lu alongra suri kaungang.” ");
INSERT INTO sgz_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Mái Pilato a gáltai ngoromin, “Má dánih á támin muswan?” Ái Pilato a be parai ngorer, má namur a so kaleng uri narsán tan Iudáiá mák parai si di ngo, “Káp iau te bana te táit a sák a longoi á kálámul min suri arangrangas on. ");
INSERT INTO sgz_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Mái sár uri kamu tatalen i bungun longsit án sorliu palai, iau lu arsok palai ák sengsegeng i tekes tili batbat kalar. Gam nem ngo ina arsok palai á kabisit kán tan Iudáiá? Ngádáh? Na gas i bál gam á ngorer?” ");
INSERT INTO sgz_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Má di lala wakwak á matananu er má dik parai ngo, “Auh, kápte gim nem i kálámul er! Gim nem i Barabas sang!” Ái Barabas er di parai a tám ngákngák. ");
INSERT INTO sgz_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","A longrai ái Pilato ngorer mák ardos suri long pas Iesu má dik tasi. ");
INSERT INTO sgz_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Má tan tám arup di longoi balaparip mai kaulbek má dik oboi i lul ái Iesu. Má namur di long pasi kesi lusán a kás má dik oboi on. ");
INSERT INTO sgz_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Má tan tám arup er di lu ararkeles i han uri narsán ái Iesu má dik lu posri, má dik lu tartar retret mai ngo, “Huihui iá! Erei má kabisit kándi tan Iudáiá!” ");
INSERT INTO sgz_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Má namur ái Pilato a bali so kaleng mul mák parai singin matananu ngo, “Gam longrai! Ina long pasi ur main narsá gam má gamák mákái ngo káp iau te bana te táit a sák a longoi á kálámul min suri arangrangas on.” ");
INSERT INTO sgz_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Má ngorer ái Iesu a so mai balaparip er a sursuru má lusán a kás. Mái Pilato a parai singin matananu ngoromin, “Gam mákái kálámul min!” ");
INSERT INTO sgz_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Má ngo bos pakpakta kán tan tám osmapak má tan tám mákmák kalar di mák Iesu ngorer, di lala wakwak ngo, “Bás páptai! Bás páptai uri kubau kus!” Mái Pilato a parai si di ngo, “Má, gam sang! Gama top pasi má gamák bás páptai! Á iau káp iau te bana te sápkin a longoi arwat suri ina oboi nagogon on.” ");
INSERT INTO sgz_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Má tan Iudáiá er di nem suri parai ngo kándi hol a nokwan, má ngorer di parai si Pilato ngo, “Kesi kángim nagogon a parai ngo a kuluk ngo na mat á kálámul min kabin a kaiang pasi ngo ái á Natun ái Káláu.” ");
INSERT INTO sgz_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Mái Pilato a longra di di parai ngorer mák lala mátut. ");
INSERT INTO sgz_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Má a kusak kaleng urami rum má a gálta Iesu ngo, “Ai u han til ái á iáu?” Mái sár ái Iesu kápate kosoi. ");
INSERT INTO sgz_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ngorer ái Pilato a parai singin ngoromin, “Ngádáh? Kápute nem i para te táit singing? Una hol páptai sang ngo a mon i kak nokwan suri pálás pala iáu unák sengsegeng. Má a mon mul i kak nokwan suri obop iáu suri dák bás pápta iáu.” ");
INSERT INTO sgz_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Mái Iesu a kosoi ngo, “A mon sang i kam nokwan suri longoi ngorer mam iau, má a kabin ái Káláu ákte tari singim. Sápkin á iáu u longoi kápate sák taladeng ngorer i lala sápkin di longoi ái rung er dikte tar iau uri limam.” ");
INSERT INTO sgz_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Má ngo ái Pilato a longrai ngorer, a lala ngoi i bál ngo na ser sál suri pálás pala Iesu. Ái Pilato kán tu holhol be, má namur a longrai matananu di lu wakwakwak. Di matai ngo ái Pilato na pálás Iesu, má ngorer dik bin ngoromin ngo, “Kálámul er a kaiang pasi ngo a kabisit, má ngorer a abulbul i Kaisar kángit kálámul pakta! Má ngo una pálási kálámul erei á iáu, ki á iáu mul kápute turán ái Kaisar!” ");
INSERT INTO sgz_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ái Pilato a longrai worwor káián matananu, má ngorer a artari suri da lam pas Iesu uri risán rum i mátán matananu. Mái Pilato mul a so uratung i kahkah i rum mák sukis i nián nagogon iatung i pokon dikte oboi tan hat pakta on uri pálkibán. Má on á worwor Ebaraio di utngi pokon er mai Gabata. ");
INSERT INTO sgz_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Má i pákánbung er ákte páput má suri sángul mai aru á pákánbung i bungun eran sang suri longsit án sorliu palai. Mái Pilato a parai mul singin matananu ngo, “Minái má kamu kabisit!” ");
INSERT INTO sgz_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Má matananu dikte lu bal kilkil má dik parai ngo, “Ubi! Up bingi! Bás páptai uri kubau kus!” Mái Pilato a gálta di ngoromin, “Ngádáh? Gam nem i iau suri ina bás páptai kamu kabisit?” Má tan pakpakta kán tan tám osmapak di kosoi ngo, “Káp kángim te kabisit á gim, ái Kaisar masik sár!” ");
INSERT INTO sgz_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Má ngorer ái Pilato a sisdo tar Iesu ur si di suri da bás páptai uri kubau kus. ");
INSERT INTO sgz_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Má tan tám arup di lam aso Iesu tili narsán ái Pilato, mái Iesu a pusak pasi kán kubau kus mák han hut mai i pokon da bás páptai ái. Má pokon erei di utngi ngo Koroson Lul, má on á worwor Ebaraio di utngi ngo Golgata. ");
INSERT INTO sgz_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Di bás páptai uri kubau kus iatung i pokon er, má di bás páptai mul i aru i kálámul, kes tili kesi balsán ái Iesu má kes tili kesi balis, mái Iesu iatung i katbán i diar. ");
INSERT INTO sgz_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ái Pilato ákte parai suri dik le i worwor talas mák artari suri dik bás páptai iatung i kubau kus i iátin i lul ái Iesu. Má worwor talas a parai ngoromin ngo, “Ái Iesu til Nasaret, ái á kabisit káián tan Iudáiá”. ");
INSERT INTO sgz_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Worwor talas er di le on mai wor til Ebaraio má mai wor til Rom má mai wor til Girik. Má pokon er di bás pápta Iesu ái, kápate tepák alari bimán rum á Ierusalem, má ngorer marán Iudáiá di saliu iatung má dik wásái worwor er. ");
INSERT INTO sgz_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Má tan pakpakta kán tan tám osmapak di wásái worwor talas erei, má namur dik han narsá Pilato má dik parai singin ngo, “Koion da le on ngo ‘Kabisit káián tan Iudáiá’, ái sár da le on ngo ‘Kálámul min a parai ngo, iau á kabisit káián tan Iudáiá’.” ");
INSERT INTO sgz_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Mái Pilato a longrai ngorer mák parai si di ngo, “Worwor erei iakte le on, na ngorer sang.” ");
INSERT INTO sgz_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","I pákánbung di bás pápta Iesu uri kubau kus, tan tám arup er di tara hat. Dihat má long pasi lusán ái Iesu má tan táit no a oboi, má dihatá obop páksi á lusán erei, má tan táit er di timlai uri ahat á boh, ki keskeskesá tám arup sang a top pasi kesá boh. Má lusán ái Iesu er kápte bauti, a tukes sár á sepen má a kunlán. Má tan tám arup di long pasi, ");
INSERT INTO sgz_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","má dik parai arliu i dihat sang ngo, “Koion gita tarápái. Gita hom satu suri, má tekes tili githat er ngo na sorliu, ái na top on ur káián.” Ki dik longoi ngorer. Má táit erei tan tám arup di longoi a long artálár pasi worwor tili Buk Tabu er a parai ngo “Dik timlai kak tan sulu arliu i di, má lusán i iau di hom satu pasi.” ");
INSERT INTO sgz_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Mái rung di sámtur pátmi kán kubau kus ái Iesu, ngis di minái: ái mámán sang ái Iesu, mái tuán lik, mái Maria kán wák ái Kilopas, mái Maria til Magadalene, ");
INSERT INTO sgz_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","má kesi kán kalik án aratintin, ái koner a lu lala mámnai ái Iesu. Ái Iesu a mák mámán má kalik er a lu mámnai, diar sámtur iatung, má ák parai si mámán ngo, “Wákán, erei má natum.” ");
INSERT INTO sgz_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Má namur a parai singin kalik án aratintin er ngo, “Erei má wák na mamam.” Má turpasi i pákánbung er, kalik án aratintin er a long pas mámán ái Iesu uri kán rum mák ololoh on ngoro mámán sang. ");
INSERT INTO sgz_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ái Iesu a mánán ngo ákte long arahi tan táit no er ái Káláu ákte tarwai suri na longoi. Má namur a parai ngo, “Iau sák suri dan.” A parai ngorer suri long arwat pasi worwor tili Buk Tabu. ");
INSERT INTO sgz_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Má kesi les suir wain iatung a maptal. Má ngo di longrai ngorer a parai ái Iesu, ki kes tili di a long pasi kesi táit ngoro loson lamas má a dungi uri les wain er mák sosap pasi suir, má a akai táit er i kuir gáh mák sua tari uramuni ngudun. ");
INSERT INTO sgz_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Mái Iesu a nginmi suir wain er, má namur a parai ngo, “Ákte rah má!”. Má a dirtapul mák bál palai tanián mák mat. ");
INSERT INTO sgz_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Má bung erei bungán eran suri bungán aunges, má bungán aunges erei ái á bungán longsit án sorliu palai mul, má ngorer bung a lala tam. Má tan tátáil káián tan Iudáiá di matai ngo kápán páplun i atul á kálámul er na iatung sang i atul á kubau kus má nák arasa uri bungán aunges er. Má ngorer di han uri narsán ái Pilato má dik sungi suri na artari má dák bauri kik ditul ditulák mat melek, má ngorer dák asih pala ditul. ");
INSERT INTO sgz_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Má ngorer ái Pilato a artari suri tan tám arup da bauri kik ditul. Má tan tám arup di sá kusi keken mulán kálámul dikte bás páptai tiklik mam Iesu, má namur di sá kusi keken kono áruán mul. ");
INSERT INTO sgz_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Má ngo di hut narsá Iesu suri sá kusi keken, di mákái ngo ákte mat má, má ngorer kápdite bauri keken. ");
INSERT INTO sgz_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ái sár kesi tám arup a soi rusun ái Iesu mai kán lamrut, má káp melek dár má dan a sararap tili rusun. ");
INSERT INTO sgz_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mái koner sang a mákái tan táit minái, ái ákte apapos ur on má kán apapos a támin. Ái sang a mánán ngo a parai támin, má a apapos ngorer suri gama longrai má gamák ruruna. ");
INSERT INTO sgz_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Kápdite bauri keken ngorer suri ák tapam hut muswan i worwor tili Buk Tabu er a parai ngo, “Kápte kesi tuán a puh.” ");
INSERT INTO sgz_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Má kesi kuir wor mul tili Buk Tabu a parai ngoromin, “Tan kálámul sang da mák koner dikte soi.” ");
INSERT INTO sgz_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Má kesi kálámul iatung ngisán ái Iosep, má ái tili malar á Aramatia. Ái Iosep a lu mur i Iesu mul, mái sár kápate parai i mátán matananu tungu kabin a bulat suri tan tátáil da káp arangrangas on. Má ngo dikte mánán pasi ngo ákte mat mái Iesu, ngorer ái Iosep a han mák sung Pilato suri kápán páplun ái Iesu suri na tahni. Mái Pilato a sormángát palai kápán páplun ái Iesu, má ngorer ái Iosep ák han long pasi. ");
INSERT INTO sgz_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Mái Nikodimo, ái koner a han suri mák Iesu i kesá libung, a kipi lala boh táit a tomtom ngorer i bultán kubau má kesi matngan kubau sang. Má boh táit erei a taun artálár mai atul i sángul mai ahat á kilogerem. ");
INSERT INTO sgz_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Má aru kálámul er diar long pasi páplun ái Iesu, má diar duri mai tan sepen sulu turán tan táit a tomtom ngorer i tatalen káián tan Iudáiá suri eran i buli uri tahtahun. ");
INSERT INTO sgz_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","I pokon er a mat on ái Iesu, a mon i kesi poron kubau iatung páput. Má on á poron kubau erei kesi hutngin tarang án minat kápdite tahun tekes on be. ");
INSERT INTO sgz_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Má diar oboi páplun ái Iesu i tarang er kabin a pátum sár, má ákte páput má suri na kuron má nák turpasi bungán aunges káián tan Iudáiá. ");
INSERT INTO sgz_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Má namur i kábungbung sáksák i Sade kán tu kuron be, ái Maria til Magadalene a hut iatung i mátán hat er di dung Iesu ái, má a mákái ngo hat di batbat kári tarang mai ákte tur uri risán mátán tarang. ");
INSERT INTO sgz_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ái Maria a mákái ngorer mák rut kaleng uri narsá Saimon Petero diar ái kalik án aratintin er ái Iesu a lala mámnai, má a parai si diar ngoromin, “Dikte long pasi má páplun ái Konom tili tarang, má kápgite mánán ngo aiá dikte oboi ái!” ");
INSERT INTO sgz_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Mái Petero diar ái kalik er diar longrai ngorer má diará han uri tarang. ");
INSERT INTO sgz_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Diar no diar rut, ái sár kalik án aratintin er a rut sorliu Petero má ák hut táil iatung i tarang. ");
INSERT INTO sgz_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","A parau má ák mákmák uramuni polgon tarang má a mákái tan sepen sulu er di dur Iesu mai, ái sár kápate kusak. ");
INSERT INTO sgz_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ái Saimon Petero a hut namur iatung má a kusak sorsorliu uramuni tarang. A mákái tan sepen sulu iatung ");
INSERT INTO sgz_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","má ák mákái mul i sepen er dikte kápti aur ái Iesu mai. Sepen er kápate kis tiklik mai tan sepen sulu er di duri páplun mai, ái sár kes ákte pipdai mák oboi uri kesi risán sang. ");
INSERT INTO sgz_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Má namur kalik er a hut táil iatung i tarang, ái mul a kusak. A mákái tan táit er má ák ruruna. ");
INSERT INTO sgz_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ái rugar er káp diar te talas be suri kuir Buk Tabu er a parai ngo na aptur kaleng tili minat. ");
INSERT INTO sgz_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Má namur diar kaleng uri rum er diar lu kiskis ái. ");
INSERT INTO sgz_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mái Maria til Magadalene ákte kaleng mul uri tarang má ák tur iatung i risán mák tang. Kán tu tang be má ák parau mák mákmák uramuni polgon tarang ");
INSERT INTO sgz_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","mák mákái aru i angelo iatung. Lusán i diar a bal, má diar kis pagas iatung i polgon tarang i pokon er páplun ái Iesu a bop ái tungu, kes a kis tili lulngán má kes tili karkeken. ");
INSERT INTO sgz_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Má aru angelo er diar gálta Maria ngo, “Wákán, u tang suri dáh?” Má a kos diar ngo, “Dikte long pasi páplun i kang Konom, má káp iau te mánán aiá dikte oboi ái!” ");
INSERT INTO sgz_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","A be parai ngorer ái Maria má ák ilang ák mák Iesu a sámtur iatung, ái sár kápate mák ilmi ngo ái Iesu er. ");
INSERT INTO sgz_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Mái Iesu a gáltai ngo, “Wákán, u tang suri dáh? Ái sinih er u mákmák suri?” Ái Maria a hol on ngo tám himhimna er a wor mai, má a parai singin ngoromin, “Ngo á iáu sár ukte long pasi páplun, iau sung iáu, konom, ngo una parai singing má ina han inák long pasi.” ");
INSERT INTO sgz_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Mái Iesu a utngi ngo, “Maria!” Ái Maria a longrai ngorer má ák mák ilmi ngo ái Iesu, má a ilang suri mák parai ngo, “Rabonai!”. Má kuir wor er tili worwor Ebaraio, sálán ngo ‘Tám Aratintin’. ");
INSERT INTO sgz_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Mái Iesu a parai singin ngoromin, “Káp una te sigil iau be kabin kápte be iau kaleng urami narsán ái Kang. Mái sár una han uri narsán rang táring, má una bit di sur iau ngo ina kaleng urami narsán ái koner a Kakang má a Kák gam, ái koner kang Káláu má a kamu Káláu mul.” ");
INSERT INTO sgz_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Má ngorer ái Maria til Magadalene a han narsán kalilik án aratintin mák parai si di ngo, “Iakte mák Konom!” Má ák bit di uri tan táit ái Iesu ákte parai singin. ");
INSERT INTO sgz_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ákte libung má i Sade erei, má tan kalilik án aratintin di kis pagas sang iatung i rum dikte lok on kabin di bulat suri tan tátáil káián tan Iudáiá. Kándi tu kis ngorer, mái Iesu a tur soura iatung i katbán i di mák parai ngo, “Matau uri bál gam!” ");
INSERT INTO sgz_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","A be libung pas di ngorer, má namur a para inngasi aru limán má rusun si di er a manu tungu. Má tan kalilik di mák Iesu er tiklik mam di má dik lala laes sang. ");
INSERT INTO sgz_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Mái Iesu ákte lu bal parai mul si di ngo, “Matau uri bál gam! Ái Kang ákte tarwa iau uri naul matmatngan pokon, má ngorer á iau iau tarwa gam mul uri naul matmatngan pokon.” ");
INSERT INTO sgz_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Má namur a aunges uri di mák parai si di ngo, “Gama pasbat i bál gam pasi Tanián a Pilpil. ");
INSERT INTO sgz_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ngo gam hol palai sápkin káián kálámul, ki ái Káláu a hol palai mul má ákte ekesi pah má. Mái sár ngo kápgamte hol palai, ki kápate pah, a kis pagas sang.” ");
INSERT INTO sgz_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Má kes tili di á sángul mai aru á kalik án aratintin, ngisán ái Tomas koner di utngi mul mai Lulu, ái a bokoh i pákánbung ái Iesu a tur soura singin kán kalilik. ");
INSERT INTO sgz_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Má ngorer tan kalilik di han parai singin ngo dikte mák Konom a liu. Ái Tomas a longrai ngorer mák parai si di ngo, “Káp ina te ruruna be á iau! Koran má iak mákái bunrán nil i limán má iak singli, má iang kálik solai kátngán limang uri rusun, ki erár inak ruruna!” ");
INSERT INTO sgz_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Má kesá wik a rah, má tan kalilik án aratintin di kis talum mul i rum, mái Tomas iatung tiklik mam di. Tan mátán sál dikte lok on ngoro tungu, mái Iesu a tur soura mul i katbán i di mák parai ngo, “Matau uri bál gam!” ");
INSERT INTO sgz_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Má namur a parai si Tomas ngoromin, “Mákái limang má singli bunrán nil minái. Una sarsara má unák solai limam uri rusung. Koion na ru i kam hol, una ruruna sár!” ");
INSERT INTO sgz_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Mái Tomas a mákái ngorer mák parai si Iesu ngo, “Kang Konom má kang Káláu!” ");
INSERT INTO sgz_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Mái Iesu a parai singin ngo, “Ngádáh, u ruruna kabin ukte mák iau, be? Mái sár ái rung kápdite mák iau má di ruruna sár, di kuluk pala sang!” ");
INSERT INTO sgz_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Á iau ái Ioanes iau le páptai tan táit minái ái Iesu ákte longoi i mát gim i kán kalilik án aratintin. Má tara marán akiláng mul a longoi i mát gim, ái sár kápte iau le noi main i buk minái. ");
INSERT INTO sgz_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Má tan táit minái iakte le páptai suri gama ruruna ngo ái Iesu á Mesaia, Natun ái Káláu. Má ngo gama ruruna on, ki gama atur páptai liu muswan. ");
INSERT INTO sgz_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Má namur, ái Iesu a tur soura mul singin kán kalilik án aratintin ami dan taliu á Taiberias, má kesi ngisán mul ngo dan taliu á Galiláiá. Ngoromin a hut ngoi. ");
INSERT INTO sgz_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Tan kalilik án aratintin er dikte hut talum iatung i risán dan taliu, má di tara hit ngoromin: ái Saimon Petero, mái Tomas koner di utngi mul mai Lulu, mái Nataniel (koner tili malar á Kana i balis á Galiláiá), má aru natun ái Sebedaio, má aru mul á kalik. ");
INSERT INTO sgz_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Kándi tu kis sár, mái Saimon Petero a parai si di ngo, “Inak han be suri soksok isu á iau!” Má dik parai singin ngo, “Io, git má! Giták han!” Má ngorer di no di sa uri mon má dik han suri soksok isu. Di soksok rákna i libung erei, mái sár kápdite up tekesi isu. ");
INSERT INTO sgz_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Má ngo ákte arasa má, má nas ákte pos, ái Iesu a sámtur ami kon. Tan kalilik di mákái, má kápdite mák ilmi ngo ái Iesu sár á erei. ");
INSERT INTO sgz_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Mái Iesu a bin ur si di mák gálta di ngo, “Kalilik, gam up te isu ngo kápte?” Má di kosoi ngo, “Auh, wa kápte sang!” ");
INSERT INTO sgz_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Má a parai si di ngoromin, “Gama asihái kamu uben tili balsán mingin mon má gama up te isu!” Má ngorer di asihái uben uradi dan má kápate artálár ngo da talka kalengnai urami mon kabin ákte lala káng mai marán isu. ");
INSERT INTO sgz_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Má kalik án aratintin erei ái Iesu a lala mámnai a parai si Petero ngo, “Ái Konom sár á erei!” Má ngo ái Petero a longrai ngo ái Konom sang á erei, ki a sol kalengnai lusán nengen ákte lus palai mák roh uradi dan máng kakas masar urami kon ");
INSERT INTO sgz_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","kabin kápdite tepák alari kon. A ngorer i kesá mar sár á mitá tili kon uratung di bok ái mai mon. Má tan kalilik di masar namur mai mon urami kon, má di talkai mul i uben a káng mai marán isu. ");
INSERT INTO sgz_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Má ngo di masar ami kon, di mákái kámnah ákte oloi ái Iesu má isu a sawi iatung i kámnah má te balbal mul iatung i risán. ");
INSERT INTO sgz_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Mái Iesu a parai si di ngo, “Gam kip te isu er gam ubi ur main.” ");
INSERT INTO sgz_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Mái Saimon Petero a roh kaleng uri mon má a artangan i talka amasar i uben a káng mai tara isu. Má tan isu er di arwat mai kesi mar mai alim i sángul mai atul no (153). A lala marán á isu, ái sár kápate ráp á uben. ");
INSERT INTO sgz_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Mái Iesu a parai si di ngo, “Gam lákám! Gamák namnam!” Má kápte kesá kalik án aratintin ngo na gáltai ngo, “Iáu sinih?” Di no di rumrum kabin dikte mánán ngo ái Konom sár á erei. ");
INSERT INTO sgz_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Mái Iesu a han mák long pasi balbal erei. Ák tibi mák tami singin tan kalilik, má a longoi ngorer mul mai isu. ");
INSERT INTO sgz_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Má minái á átuil pákán ái Iesu a tur soura singin kán kalilik án aratintin i pákánbung ákte aptur kaleng tili minat. ");
INSERT INTO sgz_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Namur ngo dikte namnam no, ái Iesu a gálta Saimon Petero ngo, “Be, Saimon natun ái Ioanes, u mámna iau sang? Ái rung minái di lala mámna iau. Má iáu? Ngádáh, kam armámna uri narsang a pakta sorliwi kándi armámna ái rung min?” Ái Petero a kosoi ngo, “Áá, Konom, u mánán sang ngo iau mámna iáu.” Mái Iesu a longrai ngorer má a parai singin ngoromin, “A kuluk. Una ololoh i rang táring ngorer i tám ololoh a lu bálbálken i tan gengen sipsip.” ");
INSERT INTO sgz_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Mái Iesu a bal gáltai ngo, “Be, Saimon natun ái Ioanes, u mámna iau sang?” Mái Petero a kosoi ngo, “Áá, Konom, u mánán ngo iau mámna iáu.” Má ngorer ái Iesu a parai singin ngoromin, “A kuluk. Una ololoh i rang táring ngorer i tám ololoh a lu bálbálken i tan sipsip.” ");
INSERT INTO sgz_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Má i átuil pákán ái Iesu a gálta Petero ngo, “Be, Saimon natun ái Ioanes, u mámna iau sang?” Mái Petero a longra Iesu a gáltai i átuil pákán ngo, ‘U mámna iau?’ Ki ák tinang suri má ák parai si Iesu ngoromin, “Konom, ukte talas má suri tan táit no, má u mánán ngo iau mámna iáu!” Mái Iesu a parai singin ngo, “A kuluk. Una ololoh i rang táring ngorer i tám ololoh a lu bálbálken i tan sipsip. ");
INSERT INTO sgz_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","A muswan iau parai singim. I pákánbung ngo iáu kaukak, u lu eran má uk lu mur i kam nemnem uri pokon u han ur on. Ái sár namur, ngo ukte pupunkak má, una takotsai limam má tan kálámul da kabat iáu má dák talka iáu uri pokon u matai ngo una han ur on.” ");
INSERT INTO sgz_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ái Iesu a parai ngorer si Petero suri para tusi matngan minat ngádáh ái Petero na áslai má nák para agas Káláu mai. Má namur ái Iesu a parai singin ngo, “Má una mur i iau má, ioh!” ");
INSERT INTO sgz_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Mái Petero a ilang má ák mák pasi kalik án aratintin er ái Iesu a lala mámnai a tur namurwai, koner a deng sur Iesu tungu i long namnam mák gáltai ngo, “Konom, ái sinih na agur tar iáu?” ");
INSERT INTO sgz_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ái Petero a mákái ngorer má ák gálta Iesu ngo, “Má Konom, ngádáh sur konomin?” ");
INSERT INTO sgz_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Mái Iesu a kos Petero ngo, “Má ngo iau nem ngo na liu átik i pákánbung ina kaleng on, ki á iáu káp kam te ngat on. Má iáu sang una mur i iau!” ");
INSERT INTO sgz_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Má kabin suri worwor er si Iesu, marán i rang táir di hol on ngo kalik án aratintin er kápnate mat. Mái Iesu kápate parai ngo kalik er kápnate mat, ái sár a tu parai ngoromin, “Má ngo iau nem ngo na liu átik i pákánbung ina kaleng on, ki á iáu káp kam te ngat on.” ");
INSERT INTO sgz_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Má kalik er a parai ái Iesu, ái sang á kalik án aratintin er a parai tan worwor min má ák le páptai mul, má gim mánán ngo táit a parai a támin. ");
INSERT INTO sgz_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Má marán mul á te táit ái Iesu a longoi. Má ngo da lain le páptai tan táit no erei mul, iau hol on ngo naul bát má naul bim kápnate artálár gut suri tan buk er na kis on. ");
INSERT INTO sgz_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ur singim, Konom Tiopilo. Tungu i kak mulán worwor narsam, iau le páptai tan táit no ái Iesu ákte himnai má ákte aratintin mai tangkabin tili pákánbung a páng ");
INSERT INTO sgz_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","ák han pang i bung ái Káláu a top pasi urami bát. Má i pákánbung kápte be a tapam urami, ái Iesu a aptur kaleng tili minat, má namur a arinngas sang singin kán kalilik án aratintin. Marán i pákán a tur soura narsá di pasi ahat i sángul á bung. A longoi marán táit a inngas tari ngo ákte liu kaleng, má a worwor tiklik mam di suri lolsit káián ái Káláu. Má mai rakrakai káián Tanián a Pilpil, ái Iesu a atalsai kándi him si di ái rung er ákte ilwa pas di ngo kán boh apostolo. ");
INSERT INTO sgz_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Kán tu kis tiklik mam di ái Iesu, má a tur kalar di ngo, “Koion besang gama han pas til main Ierusalem, ái sár gama kis monai artabar káián ái Kakang ákte oror pagas mai má gamáte longrai singing. ");
INSERT INTO sgz_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Iau parai ngorer kabin ái Ioanes Tám Arsiu a lu arsiu mai dan sár, mái sár kápate tepák má bung, mái Kakang na siu gam mai Tanián a Pilpil.” ");
INSERT INTO sgz_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Di hau talum mul ái Iesu mai boh apostolo, ki dik gáltai ngo, “Be Konom, ngádáh? Onin má una aptur kalengnai kiskis má nagogon má ololoh káián ái Káláu main Israel?” ");
INSERT INTO sgz_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Má a kos di ngoromin, “Ái Tata masik a mon i kán nokwan suri puti pákánbung ngo na hut á tan táit min, má á gam káp kamu te talar suri ngo gama mánán on. ");
INSERT INTO sgz_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Mái sár á gam gama atur páptai rakrakai i pákánbung erei Tanián a Pilpil na akáng gam, má gamák arbin talas sur iau tangkabin main Ierusalem, má uri tan kuir no main Iudáiá, má anang Samaria, má uri naul matmatngan pokon no.” ");
INSERT INTO sgz_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","A be arahi kán worwor narsá di ái Iesu, ki ái Káláu a duruk pasi tili mátán táil i di uramuni armongoh, má kesá kumlán mehmeh a ámkuk pas Iesu alari mát di. ");
INSERT INTO sgz_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kándi tungai mákmák be namurwai uramuni armongoh, má káp melek sár mul aru kálámul diar tur soura narsá di má kándiar mermer a tuan bal. ");
INSERT INTO sgz_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Má diar má parai si di ngoromin, “Be, gam á bos kakun Galiláiá, wa suri dánih gam sámtur ngorer má kamu tungai mákmák uramuni armongoh? Ái Iesu minái a long pasi ái Káláu urami bát, ái sár na hut sosih ngorer sang mul gamáte mákái a tapam urami.” ");
INSERT INTO sgz_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Má ngorer ái rung di mák Iesu a tapam, di aptur pas tili pungpung á Oliwa má dik láklák artálár mai kesá kilomita kaleng ur Ierusalem. ");
INSERT INTO sgz_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Má ngo dikte purut á Ierusalem, dik tapam uramuni rum er di lu kis án asir on. Má ngis di ái rung er a ngoromin: ái Petero, mái Ioanes, mái Iakobo, mái Enru, mái Pilip, mái Tomas, mái Batolomi, mái Mataio, mái Iakobo natun ái Alpius, mái Iudas natun ái Iakop, mái Saimon (ái á kes tili di ái rung di nem ngo Israel na tur masik alari nagogon til Rom). ");
INSERT INTO sgz_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Má di no tiklik mai tan wák, mái Maria mámán ái Iesu, má rang tuán mul, di lu balbal kis talum má sung mai kepwen hol. ");
INSERT INTO sgz_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","I kesi bung i katbán tan bung erei, bos tám ruruna di kis talum má di arwat mai kesá mar mai aru i sángul, mái Petero a sámtur i katbán i di ");
INSERT INTO sgz_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","mák parai si di ngo, “Rang buhang, pinpidan tili Buk Tabu ákte hut muswan má onin. Tanián a Pilpil ákte para táilnai mai ngudun ái Dewit hirá sang sur Iudas, koner a táilnai rung di tola Iesu. ");
INSERT INTO sgz_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ái á kes tili git sang má a kipi risán talar i kángit him.” ");
INSERT INTO sgz_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ái Petero a parai ngorer kabin ái Iudas a top i pirán tabal er di huli suri kán sápkin tatalen má ák han lápkai sár iatung i rumán osmapak. Má namur ái Iudas a bibing mák pur mák liksa puri bál, ki ák leu sara i pokon bál. Má pirán tabal er káián ái Iudas, bos tátáil káián tan Iudáiá di kipi má dik huli kesá kuir bim mai. ");
INSERT INTO sgz_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Má matananu no til Ierusalem di longrai suri ngorer, pasi dik utngi kuir bim erei mai kándi wor ngo Akeldama, sálán ngo ‘Pokon án Dár’. ");
INSERT INTO sgz_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Mái Petero a sopasun i kán worwor mák parai ngo, “Kabisit Dewit a worwor tus sur Iudas iatung i Buk án Saksak er a parai ngo ‘Na pángán á kán rum, má kápte kesi kálámul na kis on.’ Má a parai mul ngo ‘Tekes na tánáu pasi kán talar.’ ");
INSERT INTO sgz_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Má minái gita ilwa pas tekes tili katbán i git suri na tur tiklik mam git má apos tari liu kaleng si Konom Iesu. Ái na tekes tili di á tan kálámul dikte tiklik mam git i kunlán pákánbung a kis i katbán i git ái Konom, tangkabin sang tili bung ái Iesu a kipi arsiu si Ioanes pang i bung ái Káláu a long pasi alar git urami naul bát.” ");
INSERT INTO sgz_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","A be worwor no ái Petero, má namur dik utngi ngisán aru kálámul, ái Matias mái Iosep Barsabas, kesá ngisán mul ái Iastus. ");
INSERT INTO sgz_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Di be utngi aru kálámul ngorer, ki namur dik sung ngoromin, “Konom, á iáu sang u mánán i bál matananu no. Ái Iudas ákte han alar gim mákte ilwa pasi kán kuir sang ngo na han ur on. Má ngorer una inngas tari si gim ngo ái sinih si diar i aru kálámul min ukte ilwa pasi suri na kipi talar káián apostolo.” ");
INSERT INTO sgz_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Má namur ái rung er di kis talum dik ililam mai matngan hat ngorer i satu, má hat ák pur mák inngas tar Matias, má ngorer dik wás tikliknai mai sángul mai kesá apostolo. ");
INSERT INTO sgz_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Má ngo bungán Pentikos ákte hut má, ái rung erei no di ruruna i Iesu dikte kis talum pagas sang i rum erei di lu kis talum ái. ");
INSERT INTO sgz_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Káp melek sár má dik longrai kesi kaungán táit tilamuni naul bát. Má irngán táit min a ngoro kaungán tiling kihkih a sosih mák akángái kunlán rum erei di kis talum ái. ");
INSERT INTO sgz_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ngo ákte hut mái táit er, namur di pánpán má dik mákái táit a ngoro boh kermen kámnah a hut sosih, ki ák tam sara uri kelgen kermen mák han kis i keskeskes tili di iatung. ");
INSERT INTO sgz_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Má di no di káng mai Tanián a Pilpil, má dik turpasi worwor mai lite wor ngorer Tanián a apos tari si di. ");
INSERT INTO sgz_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Má on á bung minái, marán kakun Iudáiá di lu lotu mai muswan uri narsá Káláu, dikte aptur tili tan balis no on á naul bim má dik tapam hut á Ierusalem má dik hut talum suri akiláng i bungán ililur. ");
INSERT INTO sgz_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Má di longrai kaungán táit ngoromin, má tilik morongnau di purut talum suri mákái. Di sodar má dik ngátngát sálán tan tám ruruna er di worwor mai tan lite wor, kápkabin ngo keskeskes tili di iatung di longra ilmi kándi wor sang tan tám ruruna di worwor mai. ");
INSERT INTO sgz_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Má matananu di longrai ngorer, má a pil i mansin i di má ák ngát i kándi hol suri, má ngorer dik worwor arliu i di sang ngoromin, “Di no ái rung min til Galiláiá, be? ");
INSERT INTO sgz_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ái sár iau longra ilmi á táit di parai mai kak wor sang! Ngádáh a ngoi á min? ");
INSERT INTO sgz_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Má git tili toltolom malar sang, ngorer te tili git di aptur til Patia má te di han til Midia. Ái rung til Elematia di minái, mái rung til Mesapotamiá mul. Te til main Iudáiá sár má te til Kapadosia. Te di han til tepák sang, til Pontás má Esiá mul. ");
INSERT INTO sgz_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ái rung til Pirigia di almain, mái rung til Pampilia mul. Tan kakun Aigipto di minái, mái rung tili tan kuir á Libia er pátmi Sairini. A mon mul á te di han tilada Rom, ");
INSERT INTO sgz_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","má te di han tili sim á Kirit, má te mul tili git di han til Arabia. Má git á tan Iudáiá git minái, mái rung tili risán mul di lu mur i ruruna kán tan Iudáiá, git no git minái. Áá, git tili toltolom malar sang, ái sár mai kángit tan worwor keskeskes, git longra ilam di di arbin suri tan rakrakai án him káián ái Káláu!” ");
INSERT INTO sgz_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Má morongnau iatung a pil i mansin i di má di ngátngát sálán, ngorer te tili di di tungai gálgálta keskeskes i di ngo, “A káplabin tili dánih á táit minái?” ");
INSERT INTO sgz_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ái sár te di tartar retret singin boh tám ruruna má dik parai ngo, “Wa di ngulngul mai dan rakrakai.” ");
INSERT INTO sgz_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Io, ái Petero a longrai ngorer má ák sámtur tili katbán sángul mai aru á apostolo mák perek urami bát, má ák lain para timani uri narsán matananu ngoromin, “Rang buhang á tan Iudáiá má gam mul gam kis be main Ierusalem, gama longra iau be suri táit ina para timani ur si gam. ");
INSERT INTO sgz_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Gam hol on ngo rung minái di ngin i dan rakrakai, mái sár kápte di longoi ngorer. Wa asiu á pákánbung sár á minái, má gim kápte be gim namnam má ngin. ");
INSERT INTO sgz_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Táit minái a tapam hut onin, na wa ái Ioel tám worwor tus a para páksi hirá sang ngo na ngoi, ");
INSERT INTO sgz_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","má a parai kán worwor ái Káláu ngoromin, ‘I áwáwatin bung, ina urai Taniang nák porta i matananu no. Rang nat gam, tan káláu má boh kalik átlái, da mánán tusi midang má dák arbin talas mai. Má kamu tan kalilik kaukak da mákái mákmák, má tan pupunkak tili narsá gam da mihi mihmih. ");
INSERT INTO sgz_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Áá, a támin. Ina longoi ngorer mul mai kak tan tám arardos, tan káláu má boh wák. Ina urai Taniang uri di on á tan bung erei má da para talsai midang singin matananu. ");
INSERT INTO sgz_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Má ina inngasi tara akiláng iamuni armongoh má adi naul bim mul. Na hut á dár má kámnah má lala tomon turán, ");
INSERT INTO sgz_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ngorer nas kápte na pos, na kuron pagas, má kalang na mirik ngoro dár. Má ngorer ngo tan akiláng ákte hut má, erei má tilik támin bung si Konom na purut. ");
INSERT INTO sgz_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Mái sinih na sung Konom suri na tángni, ái Konom sang na aliu pasi.’ ");
INSERT INTO sgz_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Matananu Israel, gama longrai be táit ina parai sur Iesu kakun Nasaret. Gam talas ngo ái Káláu a longoi rakrakai án him má tara akiláng mai limán ái Iesu kabin a longoi main i katbán i gam má gamá mákái. Má bos akiláng erei a inngas tari ngo ái Káláu sang a tarwa palai. ");
INSERT INTO sgz_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Má á gam tiklik mai bos tám sápkin, gam no gam bás páptai uri páspáng ák mat. Ái sár kápgamte long bia on, kabin hirá sang be ái Káláu a mánán táilnai tan táit no erei ngo na hut singin ái Iesu, kabin ái Káláu sang a hol páksi ngorer ur on, má ái a tari rakrakai si gam suri gama longoi ngorer. ");
INSERT INTO sgz_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Mái sár a salaptur pasi tili minat ái Káláu, má ák asengsegeng on alari rangrangas tili minat, kabin minat kápate artálár suri kabat páptai. ");
INSERT INTO sgz_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Wa kángit kabisit ái Dewit ákte worwor tus sur Mesaia hirá sang, má kán worwor a inngasi ngo táit minái iakte parai a nokwan. A parai ngoromin, ‘Iau mák Konom a lu tiklik mam iau. Kabin ái Konom a tur tangan iau, ngorer kápte kesi taun a arwat suri ketuk pala iau. ");
INSERT INTO sgz_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Io, ngorer a laes i balang, má kermang a para aposoi kak gasgas. Káksiai ngo kápán páplun i iau na mat, balang na matau kabin kápán páplun i iau a ngangai suri kán kiskis namur. ");
INSERT INTO sgz_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kápkabin káp una te hol pala iau iatung i tarang án minat, má káp una te káksiai kam toptop a pilpil suri nák beseng. ");
INSERT INTO sgz_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ukte atalsa iau ngo una aptur kalengna iau alari minat, má ina laes kabin una kis tiklik mam iau sang.’ ");
INSERT INTO sgz_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Má rang buhang, kápate ru á kángit hol sur kámpup git ái Dewit ngo ákte mat má dikte tahni, má mátán hat er di tahni on a kis pagas onin main i narsá git inái. ");
INSERT INTO sgz_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ái Dewit sang a tám worwor tus, má a mánán on ngo ái Káláu ákte oror pagas suri na ilwa pas tekesi subul on náng kis i kán kiskis án kabisit ngoro Dewit sang. ");
INSERT INTO sgz_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","A mákmák ur táilnai ái Dewit, má ák parai ngo Mesaia na aptur kaleng alari minat, má ngo kápnate páksiai iatung i tarang án minat má kápán páplun mul kápnate beseng. ");
INSERT INTO sgz_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Mái Iesu sár minái, ái ái koner ái Káláu a aliu kaleng on tili minat, má gim no min gim mákái má gim apapos ur on ngo a támin. ");
INSERT INTO sgz_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Mái Káláu sang a sángwái urami kiskis pakta i balsán mingin, pasi á ngorer ái Iesu ákte sara pasi tili limán ái Kákán á Tanián a Pilpil ngorer ái Kákán ákte oror pagas mai, má ákte urai bul ur si gim. Má táit minái gam mákái má longrai onin, ái á artabar erei ákte tari si gim. ");
INSERT INTO sgz_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ái Dewit kápate tapam urami bát ngorer ái Iesu, má ngorer git longra ilmi ngo kán worwor a parai kápate worwor suri sang. Auh, a worwor suri lite er ák parai ngoromin, ‘Ái Káláu a parai singin kang Konom ngoromin, una kis main i risán minging, ");
INSERT INTO sgz_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","má á iau ina suka bámiai kam tan kurtara uri lalin kikim má ina arumrum di.’” ");
INSERT INTO sgz_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Mái Petero a arahi kán worwor ngoromin, “Má ngorer gam á matananu Israel no, na tumran sang i kamu hol suri táit minái. Ái Iesu sang minái koner gamáte bás páptai, ái Káláu ákte oboi uri kiskis án Konom má Mesaia mul.” ");
INSERT INTO sgz_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Má ngo tan kálámul di longrai worwor si Petero, a soi nitán i di, má dik parai si Petero má bos apostolo ngoro minái, “Rang buh gim, dánih má gima longoi?” ");
INSERT INTO sgz_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Mái Petero a kos di ngoro minái, “Gam no gama tapriu alari kamu tan sápkin tatalen má gamáng kipi arsiu i ngisán ái Iesu Karisito suri ái Káláu na pah palai kamu bos sápkin. Má gamáng kipi Tanián a Pilpil ngorer i artangan káián ái Káláu uri narsá gam. ");
INSERT INTO sgz_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ái Káláu ákte oror pagas mai tan táit minái ur kamu má ur si rang nat gam má ur kándi ái rung er mul di kis tepák. Má oror minái ákte kabat arsakta noi rung er ái Káláu na kilkila pas di ur káián.” ");
INSERT INTO sgz_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Mái Petero a akeng i di mai marán worwor má ák inau i di ngoromin, “Gama ololoh kulukna gam, má gama lu mángát pas Káláu suri nák sáras pas gam tili katbán sápkin ngaul matananu onin, gama káp sák ngoro di.” ");
INSERT INTO sgz_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Mái rung di ruruna i worwor si Petero, di kipi arsiu sang. Má on á bung er, di arwat mai atul i arip mul á kálámul di kusak ur turán bos tám ruruna. ");
INSERT INTO sgz_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Má bos tám ruruna di tar kunlai kándi liu suri bos tatalen ngoromin. Di lu longra pasi aratintin káián bos apostolo má mur arwat pasi. Di lu kis án ararguna má artangan arliu mai kepwen hol sár. Di lu hut talum suri namnam tiklik má ani Namnam kán Konom, má suri sung talum mul uri narsán ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Má i bosbos bung erei, bos apostolo di longoi marán akiláng, má matananu no di mákái ngorer má dik pángáng má a kumráu i u di. ");
INSERT INTO sgz_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Bos tám ruruna di lu balbal hut talum má dik lu artabar arliu i di mai kándi tan minsik. ");
INSERT INTO sgz_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ái rung a mon i kándi kesá kuir bim ngo kándi tan minsik, di sirai pasi pirán tabal, má pirán tabal er di apángái, di kipi má dik tari si di ái rung di sáhár suri ák artálár mai kándi sáhár. ");
INSERT INTO sgz_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Má i bosbos bung no di lu balbal longoi ngoromin mul. Di lu hut talum suri lotu iatung i pelbut i rumán osmapak. Má dik lu hut talum mul suri namnam tiklik tangrai kándi tan rum keskeskes. Má dik lu kis án ararguna talum mai gasgas, má dik lu artabar arliu i di mai lain bál di sang, ");
INSERT INTO sgz_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","má dik lu parpara agas ur si Káláu. Matananu no di mák ilmi ngo tan tám ruruna a lain ninsin i di pasi dik laes mam di. Má i bosbos bung no ái Káláu a aliu pas di ái rung di pukdai kándi liu, má ngorer lálám i boh tám ruruna ák lu marmaras hanhan. ");
INSERT INTO sgz_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Kesi bung ái Petero mái Ioanes diar han urami pelbut i rumán osmapak i atul á pákánbung i rahrah, pákánbung erei matananu di lu hut talum suri sung. ");
INSERT INTO sgz_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Má imi rumán osmapak marán á mátán sál, má kes di utngi ngo Mátán Sál Malilis. Má kesi kálámul a peu, kápte a lu láklák, a káhái ngoi sang ái mámán. Bosbos bung rang buhán peu er di lu kipi uratung i mátán sál erei má dik lu aksimi ái, má ák lu sukis pagas suri sungi tan kálámul di lu kusak uri rumán osmapak pas te pirán tabal ur káián. ");
INSERT INTO sgz_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ái Petero mái Ioanes diará han urami rumán osmapak ngorer má diará láklák kusak sár. Má ngo peu erei a mák diar, ki ák lala sung diar ngo, “Wai, arwat gaura tabar iau be mam te táit á gaur?” ");
INSERT INTO sgz_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Diar longrai ngorer ki diar má sámtur, má diará lala mákái, má ái Petero ák parai singin ngo, “Mák giur be!” ");
INSERT INTO sgz_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Má peu erei a hol on ami kán hol ngo diara támri mam te táit, ki ák lala mák diar sang. ");
INSERT INTO sgz_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Má namur ái Petero a bali wor mai mák parai singin ngo, “Kápte te pirán tabal singing á iau ngo ina tabar iáu mai, mái sár táit a mon singing er ngo ina tari singim a ngoromin. Iau dos i iáu mai rakrakai káián ái Iesu Karisito kakun Nasaret ngo una aptur má unák láklák!” ");
INSERT INTO sgz_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Mái Petero a top pasi limán mingin peu er mák salapturi ák sámtur. Má káp melek sár má keken no ák rakrakai, ");
INSERT INTO sgz_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","má ngorer ák sámtur atu sang má ák turpasi láklák, ki ák rohrohman má parpara agas uri narsá Káláu, mák mur i Petero diar ái Ioanes, má ditul kusak no uratung i rumán osmapak. ");
INSERT INTO sgz_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Má ngo matananu iatung di mákái kán tu láklák má parpara agas narsá Káláu, ");
INSERT INTO sgz_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ki dik mák ilmi ngo ái sár á kálámul a peu tám sung, koner a lu sukis pagas i Mátán Sál Malilis. Di mákái ngorer má dik pánsálngát suri táit a tapam hut singin. ");
INSERT INTO sgz_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Má kálámul er a top pagas i Petero diar ái Ioanes má ditulá láklák uri kesi goson iatung i rumán osmapak, kuir er di utngi ngo Kahkah si Solomon. Má matananu no iatung di pángáng suri kálámul er má dik rut uratung sur ditul. ");
INSERT INTO sgz_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","A mákái ngorer ái Petero ki ák parai si di ngo, “Be, rang buhang tan kakun Israel, dánih gam pángáng suri á ngorer má gamá lala mákái? Gam hol on gut ngo giur tám pilpil, má mai kángiur rakrakai sang giurá asengsegeng pasi kálámul minái má gamá lala mák giur! Na, kápte muswan! ");
INSERT INTO sgz_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Wa kán rakrakai ái Iesu Karisito, ái a asengsegeng pasi kálámul minái! Ái Iesu ái koner ái Káláu a sángwái. Áá, ái Káláu si Abaram má si Aisak má si Iakop, má ái mul á Káláu káián rang támin i git til hirá sang, ái ákte sángáu Iesu kán tám arardos. Ái sár á gam gamá susdoi uri limán tan tám nagogon suri da up bingi, má gamá su bah gam ur on i pákánbung a tur i mátán táil ái Pilato. Ái Pilato ákte ngoi i bál ngo na arsok palai nák han, ái sár gam parai si Pilato ngo, ‘Auh, gim matai á ngorer á gim! Gim nem ngo na mat sang!’ ");
INSERT INTO sgz_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ái Iesu a Tám Pilpil má Tám Nokwan, ái sár gam pua palai. Má gamá sung Pilato suri ák pálás pala Barabas ur si gam, koner a lu up bing kálámul. ");
INSERT INTO sgz_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Má ngorer gam susdoi kálámul ái Koner a káplabin á liu má gamá up bingi ák mat. Ái sár ái Káláu a aptur pasi alari minat, má giur giuráte mák Iesu mai mát giur sang ngo ákte liu kaleng. ");
INSERT INTO sgz_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Má kálámul minái, gam no gam mánán on ngo a peu tungu, má onin gamá mákái táit er a tapam hut singin i mátán táil i gam no. Ái a ruruna i Iesu, má ngorer ái Iesu a arakrakai on má ák láklák má. Kabin i kán ruruna i Iesu, ngorer ák sengsegeng! ");
INSERT INTO sgz_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Má onin, rang buhang, iau mánán ngo tungu kápgamte talas uri táit á gam tiklik mai kamu boh pakpakta, gam ingai mam Iesu er gamá tari uri minat. ");
INSERT INTO sgz_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Áá, kápgamte mánán i táit gam longoi, mái sár hirá sang ái Káláu ákte parai narsán tan tám worwor tus suri kán Mesaia ngo na áslai rangrangas. Má i sál sár ngorer gam longoi, ái Káláu ákte long arwat pasi kán worwor. ");
INSERT INTO sgz_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","“Má ngorer gama hol kaleng má, má gamák tapriu sur Káláu suri na pah palai kamu tan abulbul. ");
INSERT INTO sgz_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Gama longoi ngorer suri na hut i tan pákánbung ái Konom na ahutngin pasi taniá gam má suri na tarwa Iesu er Mesaia, koner ákte ilwa pasi ur kamu. ");
INSERT INTO sgz_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ái koner si Mesaia na kis pagas besang ami bát nák han pang i bung ái Káláu na ahutngin pasi tan táit no. Hirá ái Káláu ákte parai suri pákánbung erei ur si di á kán tan tám worwor tus, ");
INSERT INTO sgz_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ngorer ái Moses a parai kán worwor ngoromin, ‘Ái Konom kamu Káláu na aptur pas tekes tili katbán i gam ngorer ákte aptur pas iau, má ái na tám worwor tus. Gama taram suri tan táit no na parai si gam. ");
INSERT INTO sgz_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Má ngo kes kápate taram suri táit a parai, kálámul er kápnate kis tiklik mai matananu si Káláu, na ekesi kelkel alar di.’ ");
INSERT INTO sgz_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Má tan tám worwor tus no er tangkabin tili Samuel mái rung di worwor mul namurwai, di no dikte worwor taru suri pákánbung minái na hut. ");
INSERT INTO sgz_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","“Má gam á matananu minái, worwor si Káláu di parai i tan tám worwor tus ákte pur uri katbán i gam, má kamkabat er ái Káláu a longoi mai rang támin i gam ákte hut mul. Ái á oror hirá sang ái Káláu ákte parai si Abaram ngoromin ngo, ‘Tekes tili rang kopkom i iáu na asosah i bos mát no on á naul matmatngan pokon.’ ");
INSERT INTO sgz_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Áá, onin ái Káláu ákte ilwa pas Iesu kán tám arardos má ákte dos palai uri narsá gam, má gam á bos mulán kálámul suri longrai kán arbin. A longoi ngorer suri asosah i gam, ngorer ák arilang i gam suri gama tapriu alari sál a sák er gam tungai mur on.” ");
INSERT INTO sgz_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Má i pákánbung er ái Petero mái Ioanes kándiar tunga wor mai matananu besang, tan Sadukaio má tan tám osmapak má pakpakta kándi tan tám mákmák kalar uri rumán osmapak, di han báháng i diar iatung. ");
INSERT INTO sgz_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ák sák i bál di uri diar kabin diar atintini matananu sur Iesu ngo ákte aptur kaleng tili minat, má kán apaptur kaleng ngorer a tus inngas tari ngo tan kálámul mul da aptur kaleng tili minat namur. ");
INSERT INTO sgz_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Dik han hut narsá diar ngorer, ki dik tola diar má dik obop diar i rumán batbat kalar suri diara kis besang nák ur latiu kabin ákte rahrah lik má. ");
INSERT INTO sgz_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Mái sár marán kálámul tili katbán matananu er di longrai kándiar worwor ki dik ruruna. Má lálám i di á bos tám ruruna no ák lu marmarán hanhan mák arwat mai alim i arip. ");
INSERT INTO sgz_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Má a be arasa ur latiu, tan tátáil káián kaunsel kán tan Iudáiá má tan kálámul pakta má tan tám mánán uri nagogon, di kis talum i bimán rum á Ierusalem. ");
INSERT INTO sgz_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ái rung erei no di hut talum mam Anas, koner a tám osmapak táil tungu. Mái Kaiapas mái Ioanes mái Aleksada má tan buhán ái Anas, di no iatung mul. ");
INSERT INTO sgz_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Má ngorer dik artari pas Petero mái Ioanes má kálámul er a sengsegeng alari peu, má dik atur ditul i mátán táil i di má dik gálgálta i Petero diar ái Ioanes ngoromin, “Gaur kipi si sinih á rakrakai erei gaur araliu mai, má i ngisán ái sinih gaurá longoi him er?” ");
INSERT INTO sgz_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Má i pákánbung er, ái Petero a káng mai Tanián a Pilpil máng kos di ngoromin, “Tan tátáil má tan kálámul pakta til Iudáiá, ");
INSERT INTO sgz_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","onin gam lala seuseuka holhol i giur suri giura atalsai lain táit a tapam hut singin peu minái má suri ngádáh a láklák ngoi. Má a kuluk sár. ");
INSERT INTO sgz_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ngorer á gam no minái gama lain talas kuluk, má matananu Israel mul da longra timani suri táit minái a tapam hut singin kálámul min. Kápte ngo kángiur rakrakai sang, wa rakrakai káián ái Iesu Karisito kakun Nasaret er gam bás páptai ák mat, mái Káláu ák aptur pasi alari minat. Ái á kán rakrakai er a aliu pasi kálámul minái a tur i mát gam. ");
INSERT INTO sgz_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ái Iesu sár ái koner Buk Tabu a worwor suri ngoro minái, ‘Hat erei á gam á tan tám long rum gam pukpukwai, mái sár ái Káláu a aksimi hat erei áng kábutkis si di no á tan hat.’ ");
INSERT INTO sgz_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kápte kes on á lalin naul bát no gita ser pasi araliu til on. Ái Iesu masik sár a mon i kán rakrakai suri na aliu pas git, má ái masik sár á sál gita mur on suri atur páptai liu.” ");
INSERT INTO sgz_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Má tan pakpakta er di longra Petero mái Ioanes, di pánsálngát sur diar kabin di mák ilmi ngo diar aru kálámul bia sár má kápte diar lala aratintin. Mái sár di mákái mul ngo diar lain para aposoi pinpidan ák tur talas má kápte diar mátut. Di pánsálngát ngorer má ák posal i kándi hol mul ngo diar aru táir ái Iesu. ");
INSERT INTO sgz_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Dik hol on ngo da kos diar, mái sár di mákái mul i kálámul er a tur tiklik mam diar ngo ákte sengsegeng má, má ngorer kápdite arwat suri ngo da pua diar. ");
INSERT INTO sgz_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Má ngorer di aso pala ditul be tili katbán kis talum uranang i malar, ki dik nguruk arliu i di má dik parai ngoromin ngo, ");
INSERT INTO sgz_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Dánih gita longoi mam diar á aru kálámul er? Matananu no til main Ierusalem dikte mánán ngo diaráte longoi kesá tilik akiláng, má kápte sang gita arkawar palai. ");
INSERT INTO sgz_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mái sár suri worwor er na mák han arkaliut uri te kuir mul, gita akeng i diar suri koion sang diara arbin mul mai ngisán kálámul er narsán matananu.” ");
INSERT INTO sgz_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Di be nguruk no, ki dik bin pas kalengna diar má dik tur kalar diar suri kái mul diara lu arbin mai ngisán ái Iesu ngo aratintin mai i mátán matananu. ");
INSERT INTO sgz_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Mái sár ái Petero mái Ioanes diar kos kalengna di ngoromin, “Áá, giur má te talas ur on á ngorer. Ái sár á gam sang gama mák timani erei gamáte oboi uri giur ngo a nokwan uri mátán ái Káláu ngo kápte. Ngádáh, giura taram i worwor gam parai, ngo giura mur i nemnem si Káláu? ");
INSERT INTO sgz_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Auh, kápate arwat ngo giura taram pasi táit gam parai kabin giura arbin sang mai táit giuráte longrai má giuráte mákái!” ");
INSERT INTO sgz_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Má bos pakpakta di longrai kándiar kokos má dik lala ser sál suri ngádáh da nagogon i diar ngoi. Mái sár kápte di arwat suri da oboi rangrangas kabin matananu no di lala parpara agas uri narsán ái Káláu suri akiláng er a tapam hut singin kálámul a peu. Má di parpara agas ngorer kabin kálámul er a páng mai peu, má ákte liu sorliwi ahat i sángul á bet, má onin ákte sengsegeng má! Má ngorer tan pakpakta di amátut i Petero diar ái Ioanes, ki dik pálás pala diar má. ");
INSERT INTO sgz_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Má i pákánbung er di pálás pala Petero mái Ioanes, diará han purut uratung singin boh tám ruruna, má diar má atatir suri tan táit dikte parai si diar á bos pakpakta kán tan tám osmapak má tan kálámul pakta. ");
INSERT INTO sgz_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Má di longrai ngorer á bos rang tur diar, ki di no sang a tukesi kepwen i kandi holhol má dik sung uri narsán ái Káláu ngoromin, “Konom Sorsorliu, á iáu u aksimi naul bát má naul bim má lontas má tan táit no er di liu on. ");
INSERT INTO sgz_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tanián a Pilpil a apos tari worwor si Dewit er kámpup gim má kam tám arardos, mák parai ngoromin, ‘Rung tili risán di rongrongas má dik hol on ngo da suka bámia Káláu! Má matananu di hol taru suri táit kápdite arwat ngo da long artálár pasi. ");
INSERT INTO sgz_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Tan kabisit tili naul bim dikte eran suri arup, má kándi tan tátáil di kis talum suri da tur kalar Konom má kán Mesaia mul.’ ");
INSERT INTO sgz_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“A támin muswan ngo aru pakpakta er ái Erodes mái Pontiás Pilato diar araturán pas mam rung tili risán má matananu Israel mul. Di no di hut talum main Ierusalem suri da tur talum pala Iesu er kam tám arardos a pilpil mái koner ukte ilwa pasi. ");
INSERT INTO sgz_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ái rung erei di tur talum ngorer suri longoi táit di sang di hol on. Ái sár táit di longoi, wa a hut tili kam rakrakai má tili kam nemnem á iáu, Káláu, má ngorer di long artálár pasi kam holhol taru sang. ");
INSERT INTO sgz_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","“Má inái, Konom, gim sung iáu suri una longra gim. Ukte talas má ngo dikte worwor án amátut uri gim á bos tám arardos kaiam, má ngorer gim sung iáu ngo una tabar gim mai kam rakrakai suri gima arbin mai mangan uri midán i iáu. ");
INSERT INTO sgz_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Una sarsara mai mingim suri aliu pasi tan sasam má suri longoi tara akiláng mai rakrakai káián ái Iesu, kam pilpil án tám arardos.” ");
INSERT INTO sgz_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Má i pákánbung di arahi kándi sung sár, kunlán rum er di kis on a gánuh. Má di no di káng mai Tanián a Pilpil, má namur dik so uradi malar má dik turpasi mul i arbin rakrakai mai pinpidan si Káláu má kápte di mátut. ");
INSERT INTO sgz_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Má tan tám ruruna no a tukesi kepwen á kándi hol má bál di mul. Kápte kesi tur di a kiu kári kán tekesi táit. Di lu hut talum mai wán kándi bos himhimna má kándi tan minsik má dik obop talmi uri tangan di no. ");
INSERT INTO sgz_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Mái Káláu a asosah i tan apostolo mai lala rakrakai, ki ngorer dik mangan mai arbin sur Konom Iesu ngo ákte liu kaleng má. Mái Káláu a urai kán lain artangan mák bonta di no. ");
INSERT INTO sgz_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Má di lain artangan arliu i di mul, ngorer a marán tili di ái rung a mon i kándi kuir bim ngo kándi rum, di sirai pasi pirán tabal. Má pirán tabal er di apángái, di kipi uri narsán tan apostolo má dik rusan tari si di, má tan apostolo dik tulsai ur si rung er di sáhár suri ák arwat mai kándi kis. Má ngorer kápte kes tili di a sáhár sur tekesi táit. ");
INSERT INTO sgz_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","A ngorer a longoi ngoi á kes tili di ngisán ái Iosep. Ái tili sim á Saipárás má a kabinhun si Lewi. Má kálámul er tan apostolo di lu utngi ngo Banabas, sálán ngo ‘koner a lu arakrakai i kálámul’. ");
INSERT INTO sgz_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Mái Banabas a mon i kán kesi kuir bim, má ák sirai pasi pirán tabal mák rusan tari singin tan apostolo. ");
INSERT INTO sgz_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","2","Mái sár kesi kálámul ngisán ái Ananias mai kán wák, ái Sapaira, a tukes i kándiar holhol suri sira palai kándiar kuir bim. Diaráte sira palai má, mái sár namur diará punam palai risán ur kándiar mokson. Má kesi risán sang, ái Ananias a kipi mák han tari singin bos apostolo, mák parai si di ngo pirán tabal di hul pasi kándiar kuir bim mai, erei sár ákte tar noi. ");
INSERT INTO sgz_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Mái Petero a mákái ngorer mák parai singin ngoromin, “Ananias, suri dáh u mángát pas Satan áng kátlán i kam liu má ngorer uk longoi angagur uri mátán Tanián a Pilpil mai punam palai risán mátán bim di hul pasi si gaur? ");
INSERT INTO sgz_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tungu kápte be u sirai kam bim, wa kaiam masik sang. Má namur má, ngo ukte sirai, ki kaiam sang á pirán tabal, má ngorer á iáu sang u kátlán i pirán erei ngorer u nem on. Má suri dáh u hol on ngo una longoi ngoromin? Angagur minái u longoi, kápte ngo u agur gim, wa u agur Káláu sang!” ");
INSERT INTO sgz_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Má pákánbung a longrai worwor erei, ái Ananias a bámrus uradi bim ák mat. Má ngorer tan kalilik án kaukak tilatung di aptur má dik duri páplun ái Ananias, má ding kipi uri tarang án minat má dik tahun palai. Mái rung di longrai arbin sur Ananias di lala mátut taladeng. ");
INSERT INTO sgz_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Mái Sapaira, kán wák ái Ananias, kápate mánán i táit a tapam hut. Ki ngorer, namur sár ngo atul i awa ákte rah, ák solsol hut mul uratung i rum er a kis ái ái Petero. ");
INSERT INTO sgz_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Mái Petero a mákái, má ngorer ák gáltai ngoromin, “Una para talsai singing ngo ngádáh, minái sár á lálám i pirán tabal er á iáu mái kam pup gaur top on tili bim gaur sirai?” Mái Sapaira a kosoi ngo, “Áá, erei sár á lálám i pirán giur top on.” ");
INSERT INTO sgz_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ái Petero a longrai ngorer má ák parai ngoromin, “Suri dáh gaur mokson mángát suri gaura tohoi Tanián ái Káláu? Gaur hol on ngo kápnate kosoi kamur angagur, be? Mákái, tan kálámul dikte tahun pala kam pup, di imunang i mátán sál má da kip iáu uranang i tarang án minat má dák tahun iáu mul!” ");
INSERT INTO sgz_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Má káp melek ái Sapaira a bámrus uradi bim i mátán táil ái Petero ák mat. Má tan kaukak er di kusak má dik mákái ngo ákte mat mul ái Sapaira, ki ngorer di kip pasi uranang i tarang án minat má dik tahni i risán i kán pup. ");
INSERT INTO sgz_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Má tan tám ruruna no á Ierusalem mái rung mul di longrai arbin sur Ananias mái kán wák, di no sang, tilik ráuráuwas má mátut a bonta di. ");
INSERT INTO sgz_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","I bos bung minái, ái Káláu a longoi marán akiláng i katbán matananu mai limán bos apostolo. Má bos tám ruruna no di lu han suri hau talum iatung i kuir rumán osmapak di utngi ngo Kahkah si Solomon. ");
INSERT INTO sgz_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Matananu di lu hol apakta i tan tám ruruna erei, mái sár ái rung kápdite ruruna, di lu bunbun suri kusak tiklik mam di. ");
INSERT INTO sgz_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Mái sár ák lu marmarán hanhan á tan káláu má tan wák di ruruna i Konom, má lálám i di no á tan tám ruruna ák lala marán. ");
INSERT INTO sgz_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tan apostolo kandi tu longoi sang i bos akiláng ngorer, pasi matananu di kip rung er di sasam uratung i sál má dik pálas kim uri di suri dik bopbop on nana Petero. Mái Petero a láklák mák top i di dik liu. Mái rung kápate arwat ngo na top i di, ki pákpák i Petero na kip di á te suri dák liu kuluk. ");
INSERT INTO sgz_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Má tilik matananu mul tili tan malar pátmi bimán rum á Ierusalem di han. Di kip rung di sasam mái rung er a kis i di á sápkin tanián, má tan apostolo dik aliu pas di no. ");
INSERT INTO sgz_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Má namur tám osmapak táil tiklik mai rang turán, di á tan Sadukaio, di lala bálsák uri tan apostolo, ");
INSERT INTO sgz_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","má ngorer dik tola pas di má dik akusak di i rumán batbat kalar. ");
INSERT INTO sgz_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Mái sár i libung, kesi angelo káián ái Konom a soura si di mák pasbat i rumán batbat kalar mák aso pala di. ");
INSERT INTO sgz_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Má namur a parai si di ngoromin, “Gama han urami rumán osmapak má gamák arbin talas singin matananu iatung suri bos táit no ur on á hutngin liu minái gam áslai.” ");
INSERT INTO sgz_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Má tan apostolo di longrai worwor káián angelo ki dik han má. Má arasa uri kábungbung, di solsol hut iatung i rumán osmapak má dik turpasi mul i atintini matananu. I ngahwán kábungbung on sang, tám osmapak táil má bos rang turán di tar wor pasi tan tátáil káián matananu Israel suri da kis talum á kunlán kaunsel kán tan Iudáiá. Má ngo dikte hut, namur di tarwai wor uri rumán batbat kalar pasi bos apostolo. ");
INSERT INTO sgz_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Má ngorer tan tám mákmák kalar di han suri long pas di. Mái sár ngo di kusak iatung i rumán batbat kalar, bos apostolo di bokoh, má ngorer di kaleng uri narsán tan kálámul pakta má dik atatir ngo, ");
INSERT INTO sgz_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Gimáte hut i rumán batbat kalar, má gimá mákái boh tám ololoh di sámtur pagas, má gimá mákái tan mátán sál a batbat mul. Ái sár ngo gim pasbat i bos mátán sál má gimá sol urami polgon, kápgimte mákái tekesi kálámul.” ");
INSERT INTO sgz_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Má pákánbung di be longrai ngorer á bos pakpakta kán tám osmapak má pakpakta kándi tan tám mákmák kalar, a lala ser i kandi hol suri ngo ngádáh a hut ngoi á táit min. ");
INSERT INTO sgz_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kándi tu holhol be ngorer, má kesi kálámul a hut iatung má ák parai si di ngo, “Tan kálámul gam obop di i rumán batbat kalar nabung, wa di imi má i rumán osmapak dik lu atintini matananu mul!” ");
INSERT INTO sgz_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Io, di longrai ngorer, má pakpakta kándi tan tám mákmák kalar a long pasi rang táir má dik han má dik long pasi tan apostolo kaleng uratung i rumán kis talum. Má tan tám mákmák kalar erei kápte di talka rápsa pasi tan apostolo kabin di mátut suri matananu da káp bás di mai hat, má ngorer di tu lain lam pas di sár uratung i rum di kis ái á tan kálámul pakta. ");
INSERT INTO sgz_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tan tám mákmák kalar di long pasi tan apostolo uratung i rumán kis talum ngorer, má dik atur di i mátán táil i kaunsel kán tan Iudáiá. Má namur tám osmapak táil a gálgálta i di ");
INSERT INTO sgz_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","mák parai ngoromin, “Gimáte wor rakrakai uri gam suri koion gama bali atintini matananu mul suri kálámul er, ái sár kápte gam taram i gim! Mákái táit gamáte longoi! Gamáte bonta noi bimán rum á Ierusalem mai kamu aratintin, má gamá atiutiu gim mai dárán ái koner ngo a kángim talar á kán minat!” ");
INSERT INTO sgz_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Mái Petero má tan apostolo di longrai worwor er má ding kosoi ngoromin ngo, “Káp gima te alongra suri mur i worwor a so tili ngudun kálámul sár. Ái sár á gim, gima taram i Káláu. ");
INSERT INTO sgz_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ái Káláu káián rang támin i git a aptur kalengna Iesu alari minat, ái koner gam bás páptai iamuni naul páspáng ák mat. ");
INSERT INTO sgz_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Má ái, ái Káláu ák sángwái urami narsán i kiskis pakta tili limán mingin. Ái Káláu a ilwa pasi suri áng kabisit kángit má kángit Tám Araliu mul. Má ákte pasbat i sál suri git á matananu Iudáiá gita hol kaleng mái Káláu na pah palai kángit tan sápkin. ");
INSERT INTO sgz_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Má tan táit erei, gim sang gimáte mákái, má gimá para talsai ngo a támin. Má Tanián a Pilpil mul, koner ái Káláu ákte tari si rung di lu taram on, ái mul a lu para talsai ngo a támin á bos táit erei.” ");
INSERT INTO sgz_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Má tan kálámul pakta erei di longrai worwor kandi á bos apostolo má dik lala mos sáksák sang, má dik hol on ngo da sá bing di. ");
INSERT INTO sgz_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Má kesi kálámul iatung, ngisán ái Gamaliel, kesi Parisaio má a tám aratintin uri nagogon, má matananu no til Iudáiá di lu rumrum on mul. Ái Gamaliel a aptur i katbán i di mák parai ngo da aso palai be bos apostolo uranang i malar arwat mai mudán pákánbung sár suri nák worwor. ");
INSERT INTO sgz_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Má namur a ot inau ur singin tan kálámul pakta ngoromin, “Gam tan kálámul til Israel rang buhang, gama ololoh kuluk besang suri táit gama longoi mai tan kálámul imunang. ");
INSERT INTO sgz_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ur tungu sár, ái koner si Tiudas a aptur má áng kaiang pasi ngo ái sang a kálámul pakta, má ngorer ák iang talmi marán kálámul di arwat mai ahat i mar dik rang táir. Má namur di up bing Tiudas ák mat, ki rang táir no dik tam sara má kándi him ák tu wáráh sár. ");
INSERT INTO sgz_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Má namur bul kesi kálámul sang a aptur, má ái mul a kaiang pasi ngo a kálámul pakta. Kálámul er ái Iudas a kakun Galiláiá, má a táilnai matananu er di mur on mai tatalen án abulbul i pákánbung án kip ngis. Má namur dik up bingi ák mat, má rang táir no di tam han sara. ");
INSERT INTO sgz_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Má minái suri tan kálámul imunang, iau parai si gam ngo gama káksia di dák han. Ngo kándi him ákte aptur tili holhol kán kálámul sár, ki na han bokoh pas má! ");
INSERT INTO sgz_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Mái sár ngo kándi him a aptur tili holhol si Káláu, káp gama te arwat suri tur kalar di. Má ngo him si Káláu, ki gama ololoh suri gama mák arup keleh mam Káláu!” ");
INSERT INTO sgz_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Io, tan kálámul pakta erei di longrai worwor án inau si Gamaliel má dik sormángát suri. Má ngorer dik bin pas kalengnai bos apostolo má dik tas di, má namur di tur kalar di ngo koion má da bali arbin mul mai ngisán ái Iesu, ki dik pálás pala di má dik han. ");
INSERT INTO sgz_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Má pákánbung tan apostolo di han alari kis talum erei, di lala laes kabin di mákái ngo ái Káláu a wás pas di ngo di arwat suri áslai arabilbiling sur Iesu. ");
INSERT INTO sgz_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Má ngorer tan apostolo kápdite aunges suri arbin. Bosbos bung no di atintini matananu iatung i pelbut án rumán osmapak má narsán tan kálámul i kándi boh rum mul, má dik arbin talas mai lain arbin sur Iesu ngo ái á Mesaia. ");
INSERT INTO sgz_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Má mámát i tan tám ruruna a lu marmaras hanhan. Má iatung Ierusalem i pákánbung erei, aru boh tám ruruna di kis. Kesá boh, wa rung til matung sang Israel má dik lu wor mai worwor Aramek. Má kesá boh sang, rung di páng tepák má namur dikte han kis á balis á Israel, má di lu wor mai worwor Girik. Má on á pákánbung er, aru boh tám ruruna di arngas. Rung di lu worwor mai Girik di tubán para pasi ngo kándi tan mokos di lu tulus sorliu di mai pirán tabal uri namnam má kápte di lu kip te. ");
INSERT INTO sgz_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Má ngorer sángul mai aru á apostolo di kilkila talmi tan tám ruruna no má ding kis talum, má tan apostolo di parai kándi holhol si di ngoromin, “Kápate nokwan sang suri gima tu holhol sirereh sár i arbin mai midán ái Káláu suri gimák ololoh i namnam. Auh, kápte a kuluk á ngorer. ");
INSERT INTO sgz_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Io ngorer, rang buh gim, á gam sang gama ilwa pas te na hit á kálámul tili gam. Gama ilwa pasi tan kálámul er git mánán i di ngo kándi tatalen a kuluk má di polon á hol má ding káng mai Tanián a Pilpil. Gama ilwa pas di ngorer, má gita oboi talar minái uri káil i di suri da ololoh i him án tulsai pirán tabal uri namnam. ");
INSERT INTO sgz_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Má gim sang á bos apostolo gima rusan tar gim suri talar mai sung má arbin mai midán ái Káláu.” ");
INSERT INTO sgz_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Má boh tám ruruna di longrai ngorer má dik gasgas no má sormángát suri worwor erei tan apostolo di parai, ki ngorer dik ilwa pasi ahit á kálámul tili katbán i di. Di ilwa pas Sitiwen, kálámul a atu i kán ruruna má a káng mai Tanián a Pilpil. Má dik ilwa pas Pilip mái Porokus mái Nikanor mái Timon mái Pamenas mái Nikolaus. Ái koner si Nikolaus, kálámul tili risán a kakun Antiok, má tungu ák pukdai kán liu uri tatalen án lotu káián tan Iudáiá, ki namur bul ák ruruna i Iesu. ");
INSERT INTO sgz_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Má tan tám ruruna di lami ahit á kálámul er ur singin tan apostolo, má bos apostolo di oboi lim di ami iátin lul di keskeskes má dik sung kalar di. ");
INSERT INTO sgz_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Má ngorer marán matananu taladeng di longrai midán ái Káláu má dik ruruna on, má lálám i bos tám ruruna i malar á Ierusalem ák lala kopkom. Má marán tan tám osmapak mul di longrai má dik ruruna i Iesu. ");
INSERT INTO sgz_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ái Sitiwen a lala asosah on ái Káláu mai tilik rakrakai, ngorer ák longoi tara akiláng i katbán matananu. ");
INSERT INTO sgz_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Má te kálámul di turpasi pua Sitiwen. Tan kálámul erei di tili kesá rumán lotu sár di utngi ngo Rumán Lotu Kándi ái Rung di Kamkamlawas. Di no bos kakun Iudáiá, mái sár di páng i malar Sairini má te tili malar Aleksadaria. Ái rung er mam te sang mul á Iudáiá di han tili aru balis á Silisia má Esiá, di arkipkip mam Sitiwen. ");
INSERT INTO sgz_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ái sár Tanián a Pilpil ákte inngasi mánán si Sitiwen, má ngorer kápte di artálár suri kot puai kán worwor. ");
INSERT INTO sgz_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Tan kálámul er di hul kodongna te kálámul tili katbán i di suri da angagur uri narsán ái Sitiwen má dák atiutiwi. Má tan kálámul er di parai ngoromin singin matananu, “Gim longrai kálámul er a ot bilingna Káláu má a ot bilingna Moses mul.” ");
INSERT INTO sgz_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Di para ngorer ur on má dik asoksokoi bál matananu má tan kálámul pakta turán tan tám mánán uri nagogon. Má ngorer di tola Sitiwen má dik long pasi uri katbán kaunsel kán tan Iudáiá. ");
INSERT INTO sgz_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Mái rung er di pua Sitiwen di lami tan kálámul suri dik angagur ur on, má dik parai ngoromin, “Káp a tini aunges mai worwor sáksák uri rumán osmapak má uri nagogon si Moses. ");
INSERT INTO sgz_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Gimáte longra Sitiwen a parai ngo kesi kálámul ngisán ái Iesu, wa salsalahin til Nasaret erei, a ngo na taráp sarai rumán osmapak má náng keles noi kángit tatalen a tari si git ái Moses.” ");
INSERT INTO sgz_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Mái rung no er di kis iatung i kaunsel di longrai ngorer má di lala mák Sitiwen, má dik mákái aur a tuan talas taladeng ngoro aur angelo. ");
INSERT INTO sgz_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Má tám osmapak táil a gálta Sitiwen ngoromin, “Worwor er di atiutiu iáu mai, ngádáh? A támin sang ngo ukte parai ngorer ngo kápte?” ");
INSERT INTO sgz_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Io, a kos kalengnai ái Sitiwen ngoromin, “Rang buhang, gama longra iau! I pákánbung kámpup git ái Abaram a lu kiskis besang i balis á Mesapotamiá má káp be a te han suri kis i malar á Haran, ái Káláu Sorsorliu a purut singin ");
INSERT INTO sgz_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","mák parai ngoromin, ‘Una támlai kam malar má rang buham, má unák han uri kuir bim ina para tari singim.’ ");
INSERT INTO sgz_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Má ngorer a aptur pas alari balis káián matananu Kaldia mák han lu kiskis á Haran. Ák lu kis iatung, má namur ngo ákte mat mái kákán ái Abaram, ái Káláu a kilkila Abaram mul mák tarwa palai ur main i balis minái gitá kis ái onin. ");
INSERT INTO sgz_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Mái sár ái Káláu kápate tar muswan be i kuir bim min si Abaram ngo na káián i pákánbung er. Kápte kesi án mudán pang kus a tari singin be. Mái sár i pákánbung er káp kán te kalik be ái Abaram suri tur kelsei, a worwor pagas ur singin ái Káláu ngo kuir bim er na ur káián má rang kopkom on namur. ");
INSERT INTO sgz_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ngoromin a para ngoi singin ái Káláu, ‘Bos rang kopkom i iáu da kis án asir i lite pokon má da kis án toptop káián tan temes. Da kis án toptop si di má dák abilbilingna di arwat mai ahat i mar á bet. ");
INSERT INTO sgz_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Mái sár namur ina tari rangrangas singin matananu ái rung di asáksákna di.’ Ái Káláu a parai mul ngo namur da han alari kuir bim er di asáksákna di on, má dák han suri da lotu uri narsán mainái i kuir bim minái git kis ái. ");
INSERT INTO sgz_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Má namur ái Káláu a tari tatalen án kut aririu si Abaram uri akiláng i kándiar kamkabat. Má namur ái Abaram a tám i Aisak, má ngo awal á bung palai ái mámán a káhái on, ái Abaram a kut aririu i Aisak. Má namur ái Aisak a kut aririu i natun, ái Iakop. Mái Iakop a kut aririu i sángul mai aru i rang natun káláu di akopkomoi sángul mai aru á kabinhun di rang kopkom i Abaram. ");
INSERT INTO sgz_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Má rang kámpup git er di bálsák uri kesi tuá di, ái koner si Iosep, má ngorer má dik sira palai ur Aigipto má ák him án toptop iatung. Mái sár ái Káláu a tiklik mai ");
INSERT INTO sgz_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","mák sáras pasi tili bos rangrangas a tongsoi kán liu. Ái Káláu a tari mánán má lain tatalen án armámna singin, ngorer má i pákánbung a kahra iatung i mátán ái Parau, kabisit til Aigipto, a pukdai bál ái Parau ngorer mák obop Iosep ák tám ololoh uri balis á Aigipto turán kán tan táit no ái Parau. ");
INSERT INTO sgz_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Má namur a hut si di á lala taul itol i aru balis no á Aigipto má Kanan, mák arangrangas i di, má rang kámpup git kápdite arwat suri da ser pas te namnam ur ándi. ");
INSERT INTO sgz_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Pákánbung a longrai ái Iakop ngo a mon i namnam i balis á Aigipto, ngorer ák dos palai rang natun, er rang kámpup git, i kándi mulán inan suri ser namnam adi Aigipto. ");
INSERT INTO sgz_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Má namur ngo ákte rah alar di á mudán namnam di kipi tungu til Aigipto, dikte lu bal kaleng má mul suri ser namnam. Má on á kándi áruán inan minái, ái Iosep ák apos tari si di ngo ái sang á tuá di, má ngorer ái Parau a mánán pasi rang tuán má kákán ái Iosep. ");
INSERT INTO sgz_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","15","Má namur ái Iosep ák tar wor pas kákán, ái Iakop, turán tan rang buhán uratung i balis á Aigipto má dik han kis á Aigipto má. Di no bos rang buhán di arwat mai ahit á sángul mai alim á kálámul. Má rang kámpup git erei di lu kis á Aigipto, má dik mat má iatung. ");
INSERT INTO sgz_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Má namur ding kip kalengnai tan tuán i di uranang Sikem, má dik dungi i kesi polgon hat ákte hul páksi mai te pirán tabal ái Abaram singin rang natun ái Hamor. ");
INSERT INTO sgz_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Ákte marán má bet, má lálám i kángit matananu di kis á Aigipto a pakta mák lala kopkom taladeng, má worwor pagas ákte parai ái Káláu si Abaram, páput má na ian támin. ");
INSERT INTO sgz_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Io, namur kesá hutngin kabisit a turpasi kátlán i balis á Aigipto, má ái kápate mánán i Iosep. ");
INSERT INTO sgz_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Má hutngin kabisit er a agurái kángit matananu mák suka bámiai rang támin i git, pasi ák dos palai kán tan tám arup suri dák han uri narsán tan wák suri dák ras pasi kándi tan goion kalik má lápka di dák mat. ");
INSERT INTO sgz_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Má i pákánbung erei, kesi kalik a páng ngisán ái Moses, má ái a tuan alal i mákmák ur on. Mái kákán mái mámán diar má ololoh kodongnai arwat mai atul i kalang iatung i kándiar rum. ");
INSERT INTO sgz_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Má ngo kápate arwat ngo da ololoh kodongnai má, ki ngorer dik dungi i polgon kas má dik obop páksi anang i dan. Má natun tahlik ái Parau a long pasi má ák patak pasi uri natun sang mák ololoh on. ");
INSERT INTO sgz_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ái Moses di lain atintini má áng kipi lala mánán uri tan táit til Aigipto, má uri tan táit a lu longoi má worwor a lu parai, a mon i rakrakai on. ");
INSERT INTO sgz_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Má ngo ákte hat i sángul má á kán bet ái Moses, ki ák hol on má ngo na laumái kán matananu Israel. ");
INSERT INTO sgz_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Má ngo a lu hanhan, ák mákái kesi kakun Aigipto a abilbilingnai kesi kakun Israel. Má ngorer ák tur singin kálámul til Israel er má ák up bing koner til Aigipto uri kosoi táit a longoi. ");
INSERT INTO sgz_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ái Moses a longoi ngorer mák hol on ngo kán matananu sang da mák ilmi ngo ái Káláu a sámtur tiklik mai suri asengsegeng pas di tili arabilbiling, mái sár a kápte bul di mák ilmi ngorer. ");
INSERT INTO sgz_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Má uri arasa ur latiu bul, ái Moses a banai aru kakun Israel diar arup arliu i diar, má ngorer ák tohoi suri apapah i diar mák parai si diar ngoromin, ‘Suri dáh gaur arup kaleng i gaur, má gaur aru kakun Israel sár?’ ");
INSERT INTO sgz_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Mái sár ái koner a abilbilingnai kesi turán a pus pala Moses mák balbal kalar ur on ngoromin, ‘Sinih a sormángát suri ngo una kátlán i gim má suri ngo unák nagogon i gim? ");
INSERT INTO sgz_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kol u ri suri ngo una up bing iau mul ngorer u up bingi kakun Aigipto nabung?’ ");
INSERT INTO sgz_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Má ngo a longrai ngorer ái Moses, ki ák táu pas til Aigipto ur Midián mák lu kiskis i katbán i di ái rung til Midián, ki áng kila iatung mák tám i aru kalik án káláu. ");
INSERT INTO sgz_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","31","“Má ngo ákte kis pasi ahat i sángul á bet iatung, angelo si Káláu a tapam hut si Moses. Ái Moses a lu ololoh i kán tan sipsip iatung i pokon mau pátmi pungpung á Sinai, má ák mák pasi kesi gengen aun kábau a kurkurem. Ái Moses a ngátngát sálán táit er a mákái, má ngorer a láklák pátum suri ngo na lain mákái sang. Ái Moses a lu hanhan ngorer, má angelo a tur soura tili kurmen kámnah erei, mái Moses a longrai kaungán ái Konom a parai ngoromin, ");
INSERT INTO sgz_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Á iau á Káláu káián rang kámpup i iáu, Káláu káián ái Abaram mái Aisak mái Iakop.’ Ái Moses a longrai ngorer mák lala mátut má ák surbáráu i on, má ngorer kápate mákmák suri aun kábau erei. ");
INSERT INTO sgz_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Má namur mul ák parai ái Konom singin ngoromin, ‘Una long palai táit er u bákrai kikim mai. Kuir bim minái iáu sámtur on a tam. ");
INSERT INTO sgz_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Iakte mákái arabilbiling di longoi mai kak matananu idi Aigipto má iakte longrai mul i kándi ngángángar, má ngoromin iak sosih suri asengsegeng pas di alari kándi rangrangas. Má inái ina tarwa kalengna iáu uradi Aigipto.’ ");
INSERT INTO sgz_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ái sár ngo ái Moses minái koner di mata palai mai worwor ngoromin, ‘Sinih a sormángát suri ngo una kátlán i gim má suri ngo una nagogon i gim?’ Mái sár ái Káláu sang a tarwai suri na kátlán i di má nák asengsegeng i di. Angelo a kipi midán ái Káláu mák tari si Moses ngo na han má nák asengsegeng pasi matananu Israel, má angelo erei a soura singin ami pokon mau i kábau a kurkurem. ");
INSERT INTO sgz_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Má namur ák lam aso i matananu til Aigipto, má ák longoi tara akiláng adi Aigipto má adi mul i Tas Mirik, má ák longoi mul iatung i pokon mau arwat mai ahat i sángul á bet. ");
INSERT INTO sgz_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Má ái Moses sár minái, ái ái koner a parai singin matananu Israel ngoromin, ‘Ái Káláu ákte aptur iau tili katbán i gam, má namur bul na aptur tekesá tám worwor tus ngoro iau má nák tarwai uri narsá gam.’ ");
INSERT INTO sgz_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","I pákánbung rang támin i git di hau talum ada i pokon mau, ái Moses a tur i katbán rang támin i git má angelo si Káláu er a worwor mai ami pungpung á Sinai. Ái á katbán kálámul suri kipi midán ái Káláu, wa worwor án liu a tur áklis, má ák asali ur singin kángit matananu. ");
INSERT INTO sgz_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Mái sár rang támin i git di matai suri taram i Moses, má dik balbal kalar ur on má dik nem ngo da kaleng ur Aigipto kabin bál di a hol kaleng ur ái. ");
INSERT INTO sgz_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Io, ngorer dik parai si Aron ngo, ‘Wai, wa unák long kángim te káláu be á iáu, koner na táilna gim. Ái koner si Moses er a agur pas gim til Aigipto, bokoh mái onin. Má gim sang, kápte gim mánán on dánih ákte tapam hut i narsán.’ ");
INSERT INTO sgz_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Má ngorer dik tuni kesi tantanián bulumakau gol uri kándi káláu. Má ngo a be wat i ngorer, ki dik osmapak narsán kándi káláu erei má dik longoi lala namnam, má dik mil má parmat suri párngai kándi káláu á di sang dikte longoi má. ");
INSERT INTO sgz_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Io, mái Káláu a su bahin alar di suri tatalen di longoi, má ák arlah pala di má dik lotu uri narsán nas má kalang má boh mátmátiah. A ngorer i worwor iatung i buk kán tan tám worwor tus er a parai ngoromin, ‘Be, matananu Israel! Pákánbung gam kis iamuda i pokon mau artálár mai ahat i sángul á bet, káp gam tini osmapak mai tan ololas erei uri narsang. Auh, kápte. Gam longoi osmapak ur singin kamu káláu sang, ");
INSERT INTO sgz_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","má gamá tungai kipi gengen rumán lotu si kamu káláu ái Molek táilna gam, má tantanián kamu káláu ái Repan. Diar á kamu aru káláu gam longoi suri gama lotu uri narsá diar. Má pasi á ngorer ina ketsikra pala gam uramunang tepák sorliwi Babilon.’ ");
INSERT INTO sgz_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Má rang támin i git tungu di tungai kipi rumán pálpálih si Káláu tiklik mam di tangrai pokon mau, má pálpálih erei a inngas tari ngo ái Káláu a kis tiklik mam di. Pálpálih dikte longoi a ngoro tártárwán pálpálih er ái Káláu ákte inngas tari si Moses, má dik longoi ngorer ái Káláu ákte parai suri ngádáh da longoi ngoi. ");
INSERT INTO sgz_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Marán á bet namur, rang támin i git bul dik top pasi á rumán pálpálih er singin rang támin i di, má di kipi tiklik mam di i pákánbung di kusak uri balis á Kanan tiklik mam Iosua. Má i pákánbung erei sang, di arup mai rakrakai káián ái Káláu, má dik tipar sarai matananu tilatung. Má rumán pálpálih er a tungai kis tiklik mam di ák han pasi pákánbung si Dewit. ");
INSERT INTO sgz_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Má ái Dewit má, a gáu i bál ái Káláu mai, ngorer ák lala ri suri ngo na longoi tekesi rum káián ái Káláu, koner a Káláu si Iakop. Ái sár kápate sormángát ái Káláu sur Dewit ngo na longoi. ");
INSERT INTO sgz_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ái Solomon má, er natun ái Dewit, ái a longoi á rum uri rum si Káláu. ");
INSERT INTO sgz_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Mái sár ái Káláu Sorsorliu káp a tini kis on á rum tan kálámul di longoi. A ngorer a parai i kesá tám worwor tus ngo, ");
INSERT INTO sgz_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","50","‘Ái Konom a parai ngoromin, “Iau sang iau aksimi tan táit no. Naul bát nián kiskis án nagogon kaiak, má naul bim pokon a aunges i kiking ái. Ngádáh una longoi ngoi á rum a artálár mam iau? Má aiá una ser pasi ái á niang?” ’ ");
INSERT INTO sgz_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","A sopasun kán worwor ái Sitiwen mák parai ngo, “Bál gam a tuan laklak má a kuron! Má talngá gam a batbat palai worwor si Káláu! Kápte gam lite alari rang támin i gam. Káp gam tini puplir suri sikra palai Tanián a Pilpil! ");
INSERT INTO sgz_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Bos tám worwor tus no, rang támin i gam dikte lu arangrangas i di. Má ngorer mul dik up bingi tan tám arbin si Káláu er tungu sang di para táilnai purpurut káián Tám Nokwan er kángit Mesaia. Má gam ngoro di sang kabin ngo tungu sár ákte hut i Tám Nokwan, ki gamá agur tari má gamáte up bingi. ");
INSERT INTO sgz_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Á gam sár erei tan angelo di tar sosih i nagogon si Káláu uri narsá gam, ái sár kápgamte mur on.” ");
INSERT INTO sgz_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Mái rung er di kis i kaunsel di longra Sitiwen kán tungai worwor be, ki dik ngarngar kulkul kalar má dik ararat ngis ur on. ");
INSERT INTO sgz_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Mái Sitiwen a káng mai Tanián a Pilpil, má a tántán uramuni bát mák mákái talsán minmáir i Káláu má ák mák Iesu a sámtur i risán mingin ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Mái Sitiwen a bin mák parai ngo, “Wái, gam longra iau! Iau mákái naul bát a pasbat má iak mákái Natun Kálámul a sámtur i risán mingin ái Káláu!” ");
INSERT INTO sgz_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Má ngo di longrai ngorer ái rung di kis i kaunsel, di lala wakwak taladeng má dik dung kári talngá di. Má dik rut suri, ");
INSERT INTO sgz_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","má dik top pasi limán, ngorer dik talka aso palai alari bimán rum má dik turpasi básái mai hat. Mái rung di atatir uri Sitiwen di rusni boh lusán i di uri narsán kesi kaukak ngisán ái Saulo. ");
INSERT INTO sgz_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Mái rung er kándi tu básái besang, mái Sitiwen áng kilkila ngángra Konom ngo, “U, kang Konom Iesu, iau tari taniang uri limam unáng kebeptai!” ");
INSERT INTO sgz_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Mái Sitiwen a kis pukun kek, ki ákte lu bali bin mul ngo, “Konom, koion á hol páptai kándi sápkin tatalen minái.” A para ngorer sár, ki ák so tip i mansin ák mat. ");
INSERT INTO sgz_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Mái Saulo a sámtur pagas iatung má ák mákái tan kálámul di bás bing Sitiwen, má ák mángát mul ngo kán minat ái Sitiwen a nokwan. Má on á bung erei sang ami Ierusalem, boh tám ruruna di turpasi áslai sápkin arabilbiling, pasi á ngorer dik tam táu arsagil uri tan pokon mau á Iudáiá má Samaria erei kápte kálámul a kis ái. Má boh apostolo kápte di táu, di mon pagas sár á Ierusalem. ");
INSERT INTO sgz_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Má te kálámul, ái rung di lotu mai muswan uri narsá Káláu, di tapam hut i pokon di bás bing Sitiwen ái má long pasi páplun, má dik han tahun palai. Mái rung iatung er di lu kiskis i iátin ái Sitiwen, di lala tangsi má ot keskam suri. ");
INSERT INTO sgz_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Mái Saulo ák turpasi tohoi suri sák mai tan tám ruruna má suh pala di, ngorer ák aptur pas mák han uri boh rum keskeskes káián boh tám ruruna má ák talka ráhra pas di, ngorer ák dung di i rumán batbat kalar. ");
INSERT INTO sgz_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Mái rung er di tam táu arsagil, di han arbin mai pinpidan tangrai boh goson erei di han átik ái. ");
INSERT INTO sgz_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Mái Pilip kes tili rung er di táu, má ái a han solsol hut i kesá bimán rum adi Samaria má ák arbin talas suri Mesaia iatung i narsán matananu. ");
INSERT INTO sgz_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Má matananu iatung di alongra sur Pilip má dik mákái tara akiláng a longoi, ki dik paupau alongra suri táit a parai. ");
INSERT INTO sgz_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Marán kálámul a mon i sápkin tanián i di, a aliu pas di ái Pilip, má bos sápkin tanián di lala wakwak urami iát sang má dik so alar di. Má marán ákte mat á te kuir páplun i di mái rung mul a sák i kik di, a aliu pas di ái Pilip dik sengsegeng má. ");
INSERT INTO sgz_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Má ngorer matananu tili bimán rum erei a tuan gáu i bál di má dik lala mámás taladeng. ");
INSERT INTO sgz_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Má kesi kálámul ngisán ái Saimon a lu kis á Samaria, má ákte kis iatung marán á bet má ák lu latlat pasi kálámul, má matananu Samaria di pángáng suri táit a longoi. A tubán kaiang pasi ur on sang ái Saimon ngo ái a kálámul pakta. ");
INSERT INTO sgz_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Má matananu no iatung, ái rung a ninir i ngis di má tan piráh piráh, di paupau alongra suri, má dik parai ur on ngo, “Káláu, Koner a Rakrakai Sorsorliu, ákte hut sosih ur main i katbán i git má ákte tar kápán páplun áng kálámul má.” ");
INSERT INTO sgz_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Má matananu di lu paupau alongra suri, kápkabin marán bung ái Saimon ákte latlat i marán kálámul má dik pángáng on. ");
INSERT INTO sgz_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Má ngo matananu di longrai arbin si Pilip sur Iesu Karisito má lolsit si Káláu, ái rung er di ruruna, tan káláu má boh wák mul, ding kipi arsiu. ");
INSERT INTO sgz_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Mái Saimon mul a ruruna máng kipi arsiu namur, pasi ngorer ák patap i Pilip, má ák lala pánsálngát suri mákái tara akiláng ái Pilip a longoi. ");
INSERT INTO sgz_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ami Ierusalem, boh apostolo di longrai ngo ái rung i balis á Samaria dikte ruruna má i pinpidan si Káláu, ki ngorer dik dos pala Petero mái Ioanes uri narsá di. ");
INSERT INTO sgz_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Ái rung minái dikte hutngin kipi arsiu i ngisán ái Konom Iesu, mái sár Tanián a Pilpil kápte be a porta i tekes tili di. Má ngo ái Petero mái Ioanes diar hut iatung, ki diar má sung Káláu suri Tanián a Pilpil na hut sosih suri nák porta i di, ");
INSERT INTO sgz_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","má namur diará oboi lim diar ami iátin lul di keskeskes, ki erár má ák porta i di á Tanián a Pilpil. ");
INSERT INTO sgz_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Mái Saimon tám latlat a mákái ngo Tanián a Pilpil a porta i di ái rung er diar oboi lim diar i iátin lul di, ki ák nem ngo na hul pasi rakrakai er mai pirán tabal, ");
INSERT INTO sgz_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","mák parai ái Saimon si diar ngoromin, “Awái! Gaur tari bul singing á rakrakai erei suri inak arwat mul suri oboi limang i tan kálámul má Tanián a Pilpil nák porta i di.” ");
INSERT INTO sgz_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Má diar longrai ngorer ki ák bali ur on ái Petero ngoromin, “Á iáu mai kam pirán tabal gaura mosrah tiklik, kabin u hol on ngo iáu arwat suri hul pasi artabar káián ái Káláu mai kam pirán. ");
INSERT INTO sgz_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Á iáu káp kam te kuir on á him minái kabin balam kápte a nokwan i mátán táil ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Una hol kaleng alari kam sápkin holhol erei má unák sung uri narsán ái Konom, má koran nák pah palai kam sápkin er a kis i balam. ");
INSERT INTO sgz_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kabin iau mák iáu ngo balam a káng mai bálsák má á iáu iáu toptop káián sápkin.” ");
INSERT INTO sgz_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Mái Saimon a kos diar mák parai ngoromin, “Keskam, gaura sung Konom sur iau suri koion á tekesá táit gauráte parai na tapam hut singing.” ");
INSERT INTO sgz_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Má ngo ái Petero mái Ioanes diar má te para aposoi tan táit diaráte mákái má diar mánán on sur Iesu má diará arbin talas ur on, ki diar má arbin hanhan mai lain arbin tangrai bos malar i balis á Samaria on á kándiar inan kaleng ur Ierusalem. ");
INSERT INTO sgz_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","27","Má kesi angelo káián ái Konom a dos pala Pilip til Samaria ngo, “Aptur má, má unák mur i sál er a han sosih til Ierusalem uradi Gasa, koner a rut tangrai pokon bia.” Ák aptur pas ái Pilip ngorer ki ák han tangra pasi sál. Má on á sál erei a mur on á kesi tilik tátáil til Itiopiá, ái koner a tám ololoh i omobop káián tasim a pakpakta kándi matananu Itiopiá. Tátáil minái ákte han urami Ierusalem suri lotu uri narsán ái Káláu, ");
INSERT INTO sgz_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","má minái ák elkaleng má suri na han uri kán malar, má a kis i kán karis a talkai i hos. Má tátáil erei a lu murmur i sál iamudi, má kán tu wáwás tili buk er a siri ái Aisaia tám worwor tus. ");
INSERT INTO sgz_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ngorer má Tanián a Pilpil ák parai si Pilip ngo, “Una han uri narsán karis imudi má unák láklák pátmi.” ");
INSERT INTO sgz_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","A longrai ngorer ái Pilip ki ák sangar i rut pátmi tátáil er mák longrai ngo ái kán tu wáwás tili buk er a siri ái Aisaia tám worwor tus. Mái Pilip a gátnai ngo, “Ukte talas má gut suri sálán worwor erei u wásái?” ");
INSERT INTO sgz_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Má tátáil a kosoi ngo, “Kápate artálár singing ngo ina talas ur on. Mái sár ngo tekes na pálási ur singing, ki erár má inak talas.” Má ngorer ák sik pas Pilip áng káusa uramuni iátin karis uri narsán, má diará lu hanhan tangrai sál tiklik. ");
INSERT INTO sgz_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Má pokon páp tili Buk Tabu a wásái a ngoromin: “Kálámul minái a ngoro sipsip di lam pasi suri tah kusi án pogong. A ngorer mul i gengen sipsip kápate long noi ngat i pákánbung di lam pasi suri kumur palai nihun. Kápte kesá kuir worwor a so tili ngudun. ");
INSERT INTO sgz_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Kálámul minái a rumrum i mátán matananu, má pákánbung a sámtur i nagogon, kápdite longoi táit a nokwan uri narsán. Kápate arwat ngo gita utung pasi rang kopkom on, kápkabin kán liu main i naul bim di tah kusi ák mut kus má.” ");
INSERT INTO sgz_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Má tátáil erei a gálta Pilip ngo, “Arwat una bit iau ngo ái sinih á minái tám worwor tus a worwor suri? A worwor suri sang, ngo a parai lite kálámul?” ");
INSERT INTO sgz_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Io, mái Pilip a tangkabin pálási tili kuir pinpidan sár kán tu wásái, má mai tan kuir pinpidan tili Buk Tabu mul ák taswai ur singin á lain arbin sur Iesu. ");
INSERT INTO sgz_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ngo kándiar tungai han be tangrai sál, diar má hut i pokon a mon i mátán pán ái. Má tátáil a parai ngo, “Minái má dan, apong. Iau nem ngo ina kipi arsiu. Dánih be a tur kalar iau má káp ina te kipi arsiu inái?” ");
INSERT INTO sgz_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Mái Pilip a kosoi ngo, “A kuluk. Ngo u ruruna mai kunlán balam no, ki a arwat sár una kipi arsiu.” Má tátáil er a parai ngo, “Áá, iau ruruna ngo ái Iesu Karisito a Natun sang ái Káláu.” ");
INSERT INTO sgz_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","A be parai ngorer ái tátáil, ki ák artari ur singin kálámul a tipri karis suri ngo na tur be. A be tur sár i karis, ki diar má sosih uradi dan, ngorer mái Pilip ák siwi tátáil er. ");
INSERT INTO sgz_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Má ngo diar tapam alari dan má sár, káp melek má Tanián ái Káláu ák long pas Pilip ák bokoh alari. Má ngorer tátáil kápte a mák Pilip mul, ái sár áng káusa kaleng uri kán karis má ák sopasun kán inan uradi kán malar mák tuan gas taladeng i bál. ");
INSERT INTO sgz_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Mái Pilip ák han mákái ngo ákte tapam hut bul i malar á Asdot, pasi ák turpasi arbin iatung mák lu hanhan arkaliut mai arbin suri lain arbin uri tan malar átik á Sisaria. ");
INSERT INTO sgz_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","On á tan bung erei sár mul, ái Saulo a balbal parai ngo na up bingi rung di tám ruruna i Iesu. Má pasi á ngorer ák aptur pas mák han uri narsán tám osmapak táil, ");
INSERT INTO sgz_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","má ák sungi suri te pákán ram a tari nokwan singin suri na tola di ái rung di ruruna i Sál si Iesu, má náng kip pasi tan pákán ram er ur Damasko uri tan rumán lotu káián tan Iudáiá. Má ngo ái Saulo na banai rung di tám ruruna i Sál si Iesu, na kabat pas di, tan káláu ngo boh wák mul, má na talka di urami Ierusalem. ");
INSERT INTO sgz_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Má ngo ái Saulo ákte kip pasi te pákán ram má, ki ák turpasi kán inan má uramunang Damasko. Má ngo ák lu hanhan pátmi bimán rum á Damasko, kesi lala talsán talas tilami bát a hut asodar mák márám kauli. ");
INSERT INTO sgz_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Mái Saulo ák pur uradi bim mák longrai kaungán kesi kálámul a bin mai ngo, “U, Saulo, Saulo! Suri dáh u tunga abilbilingna iau ngorer?” ");
INSERT INTO sgz_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","A longrai ái Saulo ngorer ki ák gáltai ngo, “Konom, iáu sinih?” Má a kos kaleng on ngoro minái, “Á iau sár ái Iesu, koner u abilbilingnai. ");
INSERT INTO sgz_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Mái sár, erei má una salaptur pas tilatung má unáng kusak i malar imunang, má tekes tilamunang na bit iáu on á táit una longoi namur.” ");
INSERT INTO sgz_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Mái rung erei di han mam Saulo di sámtur pagas sár má kápte te wát i di. Di longrai kaungán kálámul mái sár kápdite mák tekes. ");
INSERT INTO sgz_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","A salaptur pas ái Saulo tilatung i bim ák lu tur, má ngo a rau ránsi mátán, kápte a mákái tekesi táit, pasi á ngorer dik top i limán má dik tangnai ur Damasko. ");
INSERT INTO sgz_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Má mátán kápte a talas, a kuron pagas ák han artálár mai atul á bung, má kápte a namnam má kápate ngin. ");
INSERT INTO sgz_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Má kesi tám ruruna ngisán ái Ananias a kis iatung i malar á Damasko. Ái Ananias a mákái kesi mákmák ngorer ái Konom a hut narsán máng kilkilai ngisán ngo, “Ananias!” Mái Ananias a kosoi ngo, “Iau minái, Konom.” ");
INSERT INTO sgz_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Mái Konom a parai singin ngo, “Leget má unák han, una mur i sál di utngi ngo Sál Nokwan, má iatung i rum si Iudas una gálta suri kesá kálámul til Tarsus ngisán ái Saulo. Ái kán tungai sung. ");
INSERT INTO sgz_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","A mákái kesi mákmák ngo kálámul ngisán ái Ananias a han ngorer mák oboi aru limán i lul suri atalsa kalengnai mátán.” ");
INSERT INTO sgz_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Mái Ananias a kokos ngo, “Konom, iakte longrai marán atatir ur on á kálámul er suri arabilbiling a longoi uri narsán matananu kaiam ami Ierusalem. ");
INSERT INTO sgz_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Má inái ákte tapam hut main Damasko mai nokwan dikte tari singin á bos pakpakta kán tan tám osmapak suri tolai tan tám ruruna no, ái rung di lotu uri narsam.” ");
INSERT INTO sgz_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Mái sár a parai ái Konom singin ngo, “Una han sár uri narsán, kápkabin iakte ilwa pasi suri na toptop kaiak. Ái na arbin sur iau uri narsán rung tili risán má narsán kándi tan pakpakta, má i mátán táil i matananu til Israel mul. ");
INSERT INTO sgz_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Má á iau sang ina inngasi singin á bos rangrangas er na áslai kabin ái á kak tám him.” ");
INSERT INTO sgz_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Mái Ananias a longra pasi worwor si Konom ki ák han. A sol uri rum er ái Saulo kán tu kis ái, má ák oboi aru limán i lul ái Saulo mák parai singin ngoromin, “Saulo, tuang. Ái Konom, wa ái Iesu sang, koner a tapam hut singim iamudi sál er u tangrai ur main, ái a dos pala iau uri narsam suri na talas kaleng i matam má suri una káng mai Tanián a Pilpil.” ");
INSERT INTO sgz_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Má káp melek sár má táit ngoro ilkán isu a pur pas tilatung i mátán ái Saulo, má a talas kaleng i mátán. A salaptur pas ák lu tur, má áng kipi arsiu. ");
INSERT INTO sgz_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Má namur, a namnam no ki áng kaleng i mingin mák rakrakai. Mái Saulo a kis palai te bung besang mai boh tám ruruna á Damasko. ");
INSERT INTO sgz_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Má i tan pákánbung sang er, a sangar i han uri bos rumán lotu káián tan Iudáiá mák turpasi arbin sur Iesu ngo ái Natun ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Mái rung no iatung di longrai, di pánsálngát i kán arbin má dik worwor arliu i di ngo, “Kálámul minái tungu sár a tok sáksáknai kis má ák amosrahi rung di lotu uri narsán ái Iesu ami Ierusalem. Má ák han ur mainái suri longoi matngan sál er suri tolai má talkai tan tám ruruna uri narsán bos pakpakta kán tan tám osmapak.” ");
INSERT INTO sgz_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Mái sár kán arbin ái Saulo a lu rakrakai hanhan, má tan Iudáiá di lu kis á Damasko kápte di arwat suri ngo da kosoi. Má kán arbin a talka pasi marán mák amuswan on uri kándi holhol sur Iesu ngo ái á Mesaia. ");
INSERT INTO sgz_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Má namur, ngo ákte marán bung palai, tan tátáil kán tan Iudáiá di kis talum má dik ngurkai suri da sá bing Saulo. ");
INSERT INTO sgz_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Má ngorer i tan bungun nas má i libung, di pánpán kursál suri iatung i tan mátán sál uri bimán rum suri ngorer da up bingi. Mái sár ái Saulo a mánán pasi kándi worwor taru. ");
INSERT INTO sgz_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Má i kesá libung má, rang táir ái Saulo di long pasi kesá kudut má dik dung Saulo i polgon, má dik asihái uradi bim tilami iát i kesá arsolon i bat er di bat kauli bimán rum erei mai. ");
INSERT INTO sgz_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Má namur ái Saulo a han kaleng urami Ierusalem má ák tohoi suri na patap mai boh tám ruruna. Mái sár tan tám ruruna no di bunbun, kabin di hol on ngo a agur di ngo ái a tám ruruna muswan. ");
INSERT INTO sgz_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Io, ák lu hanhan mái Banabas ur on, ki ák lam pasi ur singin boh apostolo. Mái Banabas a taswai uri mát di suri ngádáh ái Saulo ákte bana Konom ngoi iatung i sál mái Konom ákte worwor mai. Ák bit di mul ái Banabas suri a mangan ái Saulo suri arbin mai ngisán ái Iesu anang Damasko. ");
INSERT INTO sgz_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Má ngorer boh apostolo di mángát pas Saulo áng kes mam di. Má namur sár ák han arsakit ami Ierusalem, má a mangan taladeng sang mai lain arbin suri ngisán ái Konom. ");
INSERT INTO sgz_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Tan Iudáiá di lu worwor mai wor Girik má mur i tatalen til Girik, ái Saulo a bana di má a nguruk mam di má ák arkipkip mam di mul, ái sár di tohoi suri sá bingi. ");
INSERT INTO sgz_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Má ngo boh tám ruruna di mánán pasi ngorer ngo dikte tohoi suri up bingi, ki dik long pasi má dik tiklik mai uradi Sisaria má dik tarwa palai ur Tarsus. ");
INSERT INTO sgz_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Má i pákánbung minái, boh tám ruruna tili atul á balis á Iudáiá má Galiláiá má Samaria di kis i kálgun moloh, kápte di áslai arabilbiling. Tanián a Pilpil a arakrakai i di, má ngorer lálám i di má kándi rakrakai mul a marmaras hanhan. Má kándi ninas a aposoi kándi rumrum ngo di rusan tar di uri lalin ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Má ngo ái Petero a lu hanhan tangrai malar suri laumái matananu si Káláu, ki ák han uradi malar á Lida suri mákái bos tám ruruna iatung. ");
INSERT INTO sgz_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Má iatung i malar erei, a banai kesi kálámul ákte mat má i te kuir páplun má a bop teken kim pasi awal á bet, ngisán ái Ainias. ");
INSERT INTO sgz_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Mái Petero a parai singin ngoromin, “Ainias, ái Iesu Karisito a asengsegeng i iáu. Una aptur má unák pipda timani kibam.” Má káp melek sár mul mái Ainias a salaptur pas mák lu tur. ");
INSERT INTO sgz_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Marán tilatung i malar á Lida má i kunlán balis no á Seron di mákái ngorer má dik tapriu sur Konom. ");
INSERT INTO sgz_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Má adi malar á Iopa, a mon á kesi wák a tám ruruna ngisán ái Tabita (di pukdai mai worwor til Girik má dik utngi ngo Dokas). Ái a tari kán liu suri longoi lain tatalen má a lu tángni bos maris án kálámul. ");
INSERT INTO sgz_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Má i pákánbung erei a sasam mák mat. Matananu iatung di long pasi kápán páplun má dik siwi má dik abopbopoi i kesi kuir rum ami iát i kesi rum. ");
INSERT INTO sgz_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Malar á Lida kápate tepák alari malar á Iopa. Má ngo bos tám ruruna á Iopa di longrai ngo ái Petero imi Lida ái, ki ngorer dik dos palai aru kálámul uri narsán má diar má ot sangar on mai worwor ngoromin, “Gim sung iáu ngo una sangar uradi narsá gim.” ");
INSERT INTO sgz_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Má ngorer ái Petero a aptur mák tiklik kaleng mam diar ur Iopa. Má ngo ditul tapam hut adi malar, ki dik lami urami rum imi iát. Má imi iát bos mokos no di tur kauli má kándi tu tang, má dik inngasi bos mermer má tan sepen kaen erei ái Dokas a bauti i pákánbung ngo a liu besang. ");
INSERT INTO sgz_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Má ngo a mákái ngorer ái Petero, ki ák aso pala di uradi malar, mái Petero diar masik ái Tabita má iatung i rum. Namur ák atur pukun kek má ák sung, ki ák pánpán suri kápán páplun ái Tabita mák ágái ngoromin, “Tabita, pán má unák aptur!” Mái Tabita a sakrai mátán ák mák Petero má ák salaptur. ");
INSERT INTO sgz_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Mái Petero a top pasi limán mák tángni ák sámtur má. Má namur áng kilkila pasi bos tám ruruna turán bos mokos erei má ák sara tari wák erei ákte liu kaleng si di. ");
INSERT INTO sgz_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Má arbin talas suri á táit minái a han arkaliut i malar á Iopa, má marán kálámul di ruruna i Konom. ");
INSERT INTO sgz_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Má ái Petero kán tu kis be iatung Iopa má a lala mongmong on iatung narsán kálámul ngisán ái Saimon. Kálámul er a lu timani kápán ololas suri dik lu longoi tan táit ngorer i reureu má te táit mul. ");
INSERT INTO sgz_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Má on á malar Sisaria, kesi lala boh tám arup di lu kis iatung. Má boh tám arup erei di utngi mai ‘Boh Tám Arup til Itali’. Má kesi tátáil tili katbán i di ngisán ái Konilius, a kátlán i kesá mar á boh tám arup iatung i malar erei. ");
INSERT INTO sgz_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ái Konilius tiklik mai rung no di lu kis i kán rum, di lotu mai muswan narsán ái Káláu kán tan Iudáiá. Má a lu balbal tángni tan kálámul til Iudáiá di sáhár, má a lu balbal sung uri narsán ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Kesá bung má, mamudi má nas, ákte tul á pákánbung má, mái Konilius a mákái kesá mákmák. Má i mákmák erei a mák tusi angelo káián ái Káláu a han narsán mák ágái ngo, “Konilius!” ");
INSERT INTO sgz_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Má ái a lala mákái angelo erei má ák ráuráuwas mák parai ngo, “Be, dánih?” Má angelo a parai singin ngo, “Konilius, a gas i bál ái Káláu mai tan sung kaiam má kam tan artangan uri narsán bos sáhár, má inái ái Káláu a kosoi uri narsam. ");
INSERT INTO sgz_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Kesá kálámul onin a lu kiskis i malar á Iopa má ngisán kálámul er ái Saimon, kesi ngisán mul ái Petero. Una dos pala te kálámul dák lam pasi ur main i narsam. ");
INSERT INTO sgz_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Má kálámul minái a lu kis i rum káián ái kán kes ngis, ái Saimon sang mul. Ái Saimon minái a lu timtiman kápán ololas suri da longoi reureu mai, má ái ái koner a atri kán rum pátmi lontas.” ");
INSERT INTO sgz_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Io, má ngo angelo erei a worwor mam Konilius ákte han pas má alari, ki namur ái Konilius ák bin pasi aru i kán tám arardos mai kesá tám arup mul a tám artangan káián má a lu lotu mai muswan uri narsán ái Káláu. ");
INSERT INTO sgz_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Mái ruktul erei a bin pas ditul ái Konilius. Ditul han uri narsán má ák bit ditul suri tan táit no ákte tapam hut singin, ki erár má ák dos pala ditul uradi Iopa má ngorer ditulá turpasi kánditul inan. ");
INSERT INTO sgz_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","I arasa ur latiu, nas a kis lul tur má, atul á kálámul si Konilius kánditul tu láklák be tangrai sál pátmi malar á Iopa. Kánditul tu láklák be ngorer, mái Petero a tapam urami iátin rum er a kis on. Rum er a leplep i ungán, má ngorer ák sa uramuni iátin suri sung. ");
INSERT INTO sgz_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ái Petero a lala matpám mák nem i an te táit, má i pákánbung di eran be i namnam, ái Petero a mákái kesi mákmák. ");
INSERT INTO sgz_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","A mákái naul bát a pasbat, mák mákái kesi táit a ngoro sepen kaen ngorer di top i ahat á goson má dik asosih on tilami naul bát ur main i naul bim. ");
INSERT INTO sgz_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Sepen kaen erei a káng mai toltolom ololas erei a tam uri narsá di á boh Iudáiá suri ani. Te á táit ahat i kik di, má te á táit di káukáu adi bim, mái rung di sehel mai bál di, má toltolom man mul tili armongoh. ");
INSERT INTO sgz_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Má kaungán kes a parai ngoromin singin, “Petero, tan ololas erei u mákái, aptur má unák up bing te má unák ani.” ");
INSERT INTO sgz_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Mái Petero a kosoi ngoromin, “Auh, Konom! Kápate arwat muswan sang suri ina longoi ngorer! Káp iau te lu an tekesi durwán táit.” ");
INSERT INTO sgz_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Má i áruán pákán kaungán kes er a parai ngoromin singin, “Koion una utngi táit ái Káláu ákte apilpilái ngo a durwán táit.” ");
INSERT INTO sgz_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Kándiar tu arkipkip mai worwor ngorer atul á pákán, ki káp melek sár mul má sepen kaen erei a tapam kaleng urami bát. ");
INSERT INTO sgz_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ngo ái Petero kán tu ngátngát sálán mákmák er a mákái, atul á kálámul er a dos pala ditul ái Konilius dituláte mánán pasi rum si Saimon singin te kálámul er ditul gátna di, ki ditul má han sámtur i mátsálán rum er. ");
INSERT INTO sgz_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ditulá aráng má gátna ngo, “Be, tekesá asir ngisán ái Saimon Petero almainái i narsá gam?” ");
INSERT INTO sgz_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ái Petero kán tu kis án hol besang suri mákmák, má Tanián a Pilpil a parai singin ngo, “Saimon, atul á kálámul idi malar, ditul gátna sur iáu. ");
INSERT INTO sgz_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Aptur má unák sosih uradi lal sur ditul. Má koion na ru i kam hol suri han tiklik mam ditul, kabin á iau sang iakte dos pala ditul ur main i narsam.” ");
INSERT INTO sgz_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ái Petero a aptur mák sosih uradi lal sur ditul mák parai si ditul ngo, “Wa, á iau sár á kálámul gamtul ser suri. Dánih á káplabin á kamutul inan ur main?” ");
INSERT INTO sgz_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Atul á kálámul er ditul má kosoi ngo, “Gimtul han tilanang Sisaria singin kesi tátáil kán tan tám arup. Ninsin a nokwan uri mátán ái Káláu má a lu lotu mai muswan uri narsán, má ái di lu mák ilmi ngo a lain kálámul má dik lu rumrum on á matananu Iudáiá. Ngisán ái Konilius, má nabung sár angelo si Káláu a parai singin suri gima sik pas iáu uranang i kán rum suri nák longrai dánih una parai singin.” ");
INSERT INTO sgz_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Mái Petero a longrai kánditul worwor ngorer má ák parai si ditul ngo, “A kuluk. Gamtula bop be main, má latiu giták aptur uranang Sisaria.” Má ngo a be kábungbung, ki ák eran sár ái Petero má ák han mam ditul, má te tám ruruna til Iopa di tiklik mam dihat. ");
INSERT INTO sgz_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Má ngo ákte arasa má bul, ki dik han solsol hut má á Sisaria ái Petero di. Mái Konilius a tungai mákmák kursál sur di, má ákte el pasi rang buhán má tan lain rang turán, di no di kis mona Petero dihat. ");
INSERT INTO sgz_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Má ngo ái Petero a láklák suri ngo na kusak sár, ái Konilius a mákái ki ák sangar i láklák suri banai, ngorer ák pur dirtapul mák lotu uri narsá Petero. ");
INSERT INTO sgz_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Mái sár ái Petero a top pasi limán ái Konilius mák parai singin ngo, “Salaptur, iau kálámul bia sár ngorer i iáu.” ");
INSERT INTO sgz_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Mái Petero diar tungai wor be ái Konilius iatung i mátán rum, má namur diará sol urami polgon rum, mái Petero a mákái lala matananu dikte hau talum monai iatung. ");
INSERT INTO sgz_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Mái Petero a mákái ngorer mák parai narsán matananu erei ngo, “Á gam sang gam mánán kuluknai ngo kápte kesá Iudáiá a lu mángta palai i nagogon suri na ararguna mai rung tili risán ngo kusak uri kándi tan rum ngo laum di. Áá, nagogon kángim á tan Iudáiá a parai ngo gam tili risán gam dur. Mái sár ái Káláu ákte inngasi singing ngo kápate arwat ina utung tekesi kálámul ngo a dur. ");
INSERT INTO sgz_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Má ngorer kápate ru i kak hol erei ngo u artari pas iau, má iau minái má. Má inái iau nem ina gálta iáu ngo dánih gam nem on ina longoi narsá gam?” ");
INSERT INTO sgz_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Mái Konilius a kosoi ngo, “Onin ákte hat á bung palai má mákmák iau mákái. Iau sung main i kak rum i atul á pákánbung i rahrah, má kesá kálámul kán mermer a tuan bal mák pilpilpil a hut asodar mák sámtur i mátán táil i iau ");
INSERT INTO sgz_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","mák sanglái ngisang ngo, ‘Konilius! A gas i bál ái Káláu mai tan sung kaiam má kam artangan uri narsán bos sáhár, má inái ái Káláu a kosoi uri narsam. ");
INSERT INTO sgz_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ngorer una dos palai te kálámul uradi Iopa suri kesi kálámul ngisán ái Saimon Petero. Kálámul minái a asir a lu kiskis i rum káián ái Saimon, koner a lu timani kápán ololas, má a atri kán rum pátmi lontas.’ ");
INSERT INTO sgz_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Má ngo iakte longrai ngorer, iau sangar sár i artari sur iáu, má a tuan kuluk sang ngo ukte hut 