﻿USE sofia;
DROP TABLE IF EXISTS sofia.sgb_vpl;
CREATE TABLE sgb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sgb_vpl WRITE;
INSERT INTO sgb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Habaytsi hilay ninuno ni Apo Jesu-Cristo. Hi Apo Jesu-Cristo ay kaapo-apoan ni Arin David haka hi Arin David ay kaapo-apoan ni apo Abraham. ");
INSERT INTO sgb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Hi Isaac ay anak ni apo Abraham, hi Jacob ay anak ni Isaac, hi Juda, haka hilay kaka nan lalaki, haka hilay ali nan lalaki, ay anak ni Jacob. ");
INSERT INTO sgb_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Hi Fares haka hi Zara ay anak ni Juda kan Tamar. Hi Esrom ay anak ni Fares, hi Aram ay anak ni Esrom. ");
INSERT INTO sgb_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Hi Aminadab ay anak ni Aram, hi Naason ay anak ni Aminadab, hi Salmon ay anak ni Naason. ");
INSERT INTO sgb_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Hi Booz ay anak ni Salmon kan Rahab, haka hi Obed ay anak ni Booz kan Ruth, hi Jesse ay anak ni Obed. ");
INSERT INTO sgb_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Hi Arin David ay anak ni Jesse, hi Solomon ay anak ni Arin David ha manan ahawa ni Urias. ");
INSERT INTO sgb_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Hi Rehoboam ay anak ni Solomon, hi Abias ay anak ni Rehoboam, hi Asa ay anak ni Abias. ");
INSERT INTO sgb_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Hi Josafat ay anak ni Asa, hi Joram ay anak ni Josafat, hi Ozias ay anak ni Joram. ");
INSERT INTO sgb_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Hi Jotam ay anak ni Ozias, hi Acaz ay anak ni Jotam, hi Ezequias ay anak ni Acaz. ");
INSERT INTO sgb_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hi Manases ay anak ni Ezequias, hi Amos ay anak ni Manases, hi Josias ay anak ni Amos. ");
INSERT INTO sgb_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Hi Jeconias haka hilay kapotoh pohêl na, ay anak ni Josias. Hên angkabiyay hila, ay dinakêp hilan taga-Babilonia hên dinyag ipoh ya Israelita ha bansan Babilonia. ");
INSERT INTO sgb_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bayro ha Babilonia, ay hi Salatiel ay nag-in anak ni Jeconias, hi Zorobabel ay anak ni Salatiel. ");
INSERT INTO sgb_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Hi Abiud ay anak ni Zorobabel, hi Eliaquim ay anak ni Abiud, hi Azor ay anak ni Abiud. ");
INSERT INTO sgb_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Hi Sadoc ay anak ni Azor, hi Aquim ay anak ni Sadoc, hi Eliud ay anak ni Aquim. ");
INSERT INTO sgb_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Hi Eleazar ay anak ni Eliud, hi Matan ay anak ni Eleazar, hi Jacob ay anak ni Matan. ");
INSERT INTO sgb_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ya anak ni Jacob, ay hi Jose, ya ahawa ni Maria, ya indo ni Jesus. Hi Jesus ya ambaêgên Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala. ");
INSERT INTO sgb_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ha êmbayro, ay main labin-apat ya ninuno ha láhi ni apo Abraham angga kan Arin David, haka labin-apat ya ninuno paubat kan Arin David angga ha dinakêp lan taga-Babilonia hên dinyag ipoh ya Israelita ha bansan Babilonia, haka labin-apat ya ninuno paubat hên dinakêp hila hên taga-Babilonia angga ha in-anak ya Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala. ");
INSERT INTO sgb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Êmên ya di ya pangianak kan Apo Jesu-Cristo, ya Mesias. Hi Maria ya indo na, ay kabaan ni Jose, noa, bayo hila nitakêh, ay nabuktot ya ha kapangyarihan hên Espiritu ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Hi Jose, ya kabaan ni Maria, ay mahonol ha Kautuhan. A na pon muwang ya dinyag nan Espiritu ni Apo Namalyari, kabay hên namwangan na, ya nabuktot hi Maria, ay naihipan na ya a nay nan kasalên. Noa, a na labay ya mipakarêng-êy hi Maria, kabay a na labay ya mamwangan hên kal-atan ya naihipan na. ");
INSERT INTO sgb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Noa, hên an-ihipên na, no ay-êmên na madyag ya habayto, ay main anghel ni Apo Namalyari ya nagpahlêk kana ha taynêp na, ya wana kana, “Jose, ya kaapo-apoan ni Arin David, paan kan malimo hên kasalên hi Maria, ta hiya ay ampangalêk gawan ha kapangyarihan hên Espiritu ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Lalaki ya ianak na, haka patangalanan mo yan Jesus, ta hiyay mamiligtas hên pinili na hên mag-in kana, ha parusa hên kasalanan la.” ");
INSERT INTO sgb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ha nalyari ya habayto ngan, ay natupad ya impamwang hên mámipamwang hên an-ipaihip kana ni Apo Namalyari, ya wana, ");
INSERT INTO sgb_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Pakalêng-ên yo, main mihay dalaga, ya a pon nakitakêh ha hinoman, ya mangalêk haka mangianak hên mihay bingot ya lalaki, ya patangalanan lan ‘Emmanuel’ ya labay habiên, ay ‘kalamo tamo hi Apo Namalyari.’” ");
INSERT INTO sgb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Hên nimata yay na hi Jose, ay hinonol nay in-utoh kana hên anghel ni Apo Namalyari, ta kinasal na hi Maria. ");
INSERT INTO sgb_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Noa, a na ya pinakitakêhan ni Jose, angga ha nangianak yan mihay bingot ya lalaki. Ya pinata-ngalanan nan Jesus. ");
INSERT INTO sgb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Hi Jesus ay in-anak ha balayan Betlehem ha probinsyan Judea, hên hi Arin Herodes pon ya manungkulan la. Hên habayto ay main nilumatêng ha balayan Jerusalem, ya manga-talino ya lalaki ya ubat ha marayo, ha dapit awahan allo. ");
INSERT INTO sgb_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nangotang hila no ay-iri hên in-anak ya ari lan Israelita. Haka la hinabi ya nahêlêk la hên inumawah ya bêtêwên ya palatandaan ya in-anak yay na, kabay simbaên la ya dayi. ");
INSERT INTO sgb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Hên nagilam ni Arin Herodes ya tungkol kanla, ay hadyay limo na, ta kayno halanghangên ya hên bayoy Ari. Haka malimo hilay kapareho nan taga-Jerusalem ha huluk ni Arin Herodes. ");
INSERT INTO sgb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kabay impa-tsipon ni Arin Herodes ya kaganawan mánoron Kautuhan ni apo Moises, haka hilay ampamaala kanlan pari, ta kinotang na hila no ay-iri hên ianak ya Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala. ");
INSERT INTO sgb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Wanla etaman kana, “Ha balayan Betlehem ha probinsyan Judea, ta êmên ya di ya inhulat nan mámipamwang hên an-ipaihip kana ni Apo Namalyari, ya wana, ");
INSERT INTO sgb_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Hika balayan Betlehem, ay miha ka kanlan maalagáy balayan ha luta ni Juda, gawan bahên kamo ay ianak ya mihay mamaala, haka hiyay manayhay kanlan Israelita ya pinili ko hên mag-in maának ko.’” ");
INSERT INTO sgb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Bayo lihim nan impabaêg ni Arin Herodes ya habaytoy manga-talino, haka namwangan na kanla no nakano lan nahêlêk hên immawah ya habaytoy bêtêwên. ");
INSERT INTO sgb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Bayo pinabita na hilay na ha Betlehem, ya wana, “Hali, mita kaw na, ta pakatapolên yoy habaytoy anak. No natapol yo yay na, ay mag-orong kaw di ta ipamwang yo kangko, ta êmên ko ya simbaên etaman.” ");
INSERT INTO sgb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Hên nagilam lay habi ni Arin Herodes, ay nammita hilay nay manga-talino. Ha pammita la, ay nahêlêk lan oman ya habaytoy bêtêwên, haka habaytoy hinonol la angga ha tinunggên ya habayto, ha ugton dyanan ni Apo Jesus ha Betlehem. ");
INSERT INTO sgb_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ayn kapantag ya higla la hên tinunggên ya bêtêwên. ");
INSERT INTO sgb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Panhumwên la ha bali, ay nahêlêk lay anak ya atsi ha dani ni Maria ya indo na. Nandoko hila ha arapan na ha pamagsimba la kana. Niloat la ya pinamyanan lan idigalo la kana ya main ginto, haka makamal ya pabango ya ambaêgên lan libanon, haka main êt mira ya in-ubuh lan indin kana. ");
INSERT INTO sgb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kaatag tanay dann ya dinanan lan manga-talino ha pamag-orong la, gawan impataynêp kanla ni Apo Namalyari, ya paan hilan mag-orong kan Arin Herodes. ");
INSERT INTO sgb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Hên nakabita hilay nay manga-talino, ay nanaynêp hi Jose. Ha taynêp na, ay nagpahlêk kana ya mihay anghel ni Apo Namalyari, ya wana, “Mimata ka, ta itákah mo hilay mitaindo, hên gêtan ha bansan Egipto. Paan kaw mag-alíh bayro, angga ha a ko habiên kamoyu, ta tapolên ni Arin Herodes ya habain ya anak, ta labay na yan patsên.” ");
INSERT INTO sgb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kabay hên habayton yabi, nimata ya hi Jose ta intakah nay mitaindo hên gintan ha bansan Egipto. ");
INSERT INTO sgb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Bayro hila tana hên angga ha natsi hi Arin Herodes. Nalyari ya habayto ta êmên matupad ya hinabi nan mihay mámipamwang ya impaihip kana ni Apo Namalyari, ya wana, “Binaêg koy anak ko, ya umawah yay na ha bansan Egipto.” ");
INSERT INTO sgb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hên namwangan ni Arin Herodes ya niloko ya hên habaytoy manga-talino, ay nagtulaw ya. Kabay impapatsi na hilay anak ya lalaki, ya loway taon paaypa, ha balayan Betlehem haka ha mamalibot, gawan ha namwangan na kanlan manga-talino ya loway taon nanan immawah ya habaytoy bêtêwên. ");
INSERT INTO sgb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ha dinyag nay habayto, ay natupad ya hinabi ni Propeta Jeremias, ya mihay mámipamwang hên impaihip kana ni Apo Namalyari, ya wana, ");
INSERT INTO sgb_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Nagilam ha balayan Rama ya makhaw ya pamanyêngên lan kaapo-apoan ni Raquel gawan ha impapatsi ya maának la. A hila taganán naamungmung.” ");
INSERT INTO sgb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Hên natsi hi Arin Herodes, ay main mihay anghel ni Apo Namalyari ya nagpahlêk kan Jose ha taynêp na ha bansan Egipto, ya wana, ");
INSERT INTO sgb_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Mimata ka, ta iuli mo hilay nay mitaindo, hên gêtan ha bansan Israel, gawan natsi yay na, ya labay mamatsi kanan anak.” ");
INSERT INTO sgb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kabay nimata hi Jose, haka na hilay na in-uli ya mitaindo ha bansan Israel. ");
INSERT INTO sgb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Noa, hên Namwangan ni Jose ya hi Arquelao ya anak ni Arin Herodes, ay ampamaala ha probinsyan Judea hên kahagili hên tatang na, ay nalimwan hi Jose hên mag-orong bayro. Hên nakataynêp yay na êt, ya kaillag hila kano, ay nagpakha hila tana ha probinsyan Galilea. ");
INSERT INTO sgb_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Bayro hila tanan nanugêl ha balayan Nazaret ha probinsyan Galilea, ta êmên matupad ya hinabi lan mámipamwang hên an-ipaihip kanla ni Apo Namalyari, ya wanla, “Baêgên yan Nazareno.” ");
INSERT INTO sgb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Hên nabuyot hilay na ha balayan Nazaret, hilan Apo Jesus, ay ampanoro yay na hi Juan Bautista kanlan dinumani kana, ha probinsyan Judea, ha logal ya kabalah-balahan. ");
INSERT INTO sgb_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Habaytsi ya an-ipamwang na, “Paghêhêan haka talibatokan yoy nay pamanyag yon kasalanan, ta nilumatêng ya pamanlokop ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Hi Juan Bautista ya inungkat ni Propeta Isaias, hatoy mihay mámipamwang hên an-ipaihip kana ni Apo Namalyari, ya wana, “Main ampan-angaw ha logal ya kabalah-balahan, ya wana kanlan kal-atan ya naka-tsipon, ‘Il-an yoy nakêm yo ha pamanlumatêng hên Panginoon, Ya nanad ha pamil-an hên dann ha pamanlumatêng hên mihay matag-ay ya manungkulan.’” Habaytoy hinabi ni Propeta Isaias ya tungkol kan Juan Bautista. ");
INSERT INTO sgb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Hi Juan ay nakatakop hên dyag ha habot hên kamelyo, haka ya tagkêh na ay dyag ha balat. Ya angkênaên na ay doron haka main bayron pulot panilan ya an-inêmên na. ");
INSERT INTO sgb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kal-atan lan taga-Jerusalem, haka kaatag pon ya logal ha probinsyan Judea, haka hilay ampaidi ha mitatalipay hên Ilog Jordan, ay dinumani kan Juan. ");
INSERT INTO sgb_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Inamin haka inhuko lay kasalanan la, bayo nagpabawtismo hila kana ha Ilog Jordan. ");
INSERT INTO sgb_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Noa, hên nahêlêk na ya mal-at ya Pariseo, haka Saduseo ya dinumani kana, ta êmên hila pabawtismo, ay wana kanla, “Nanad kaw utan, ya ampipag-ahug ha angkaulam. Hinoy namipamwang kamoyu hên tumakah kaw ha parusa ya lumatêng? ");
INSERT INTO sgb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Daygên yo ya pamaptêg hên naghêhê kaw ha kasalanan yo. ");
INSERT INTO sgb_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Paan kaw mangihip hên mailigtas kaw ha parusa ni Apo Namalyari, gawan hi apo Abraham ay ninuno yo. Agyan hata bato, ay madyag ni Apo Namalyari hên kaapo-apoan ni apo Abraham. ");
INSERT INTO sgb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ya pamanatol ni Apo Namalyari ay nanad ha payakol ya naitag-ay hên mihay ampamotoh hên kayo. Balang kayo ya a ampanagêy hên mangangêd, ay potohên ta iulam ha apoy. Haka hikaw ay maialimbawa ha kayo ya a ampanagêy hên mangangêd. ");
INSERT INTO sgb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ya impangakon Mámiligtas, ya lumatêng, ay matag-ay ya tungkulan kangko. Agyan mantan hên pag-apin bitsih na, ay ayn akon karapatan. Hikoy ampamawtismo kamoyu ha lanêm, ta êmên ipahlêk ya pinaghêhêan yon tinalibatokan ya kasalanan yo. Noa, hiyay mamawtismo kamoyu ha Espiritu ni Apo Namalyari haka ha apoy. ");
INSERT INTO sgb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Hiyay mamipapawa hên mapanyag kangêran kanlan mapanyag karawakan hên nanad ha mihay ampamalohboh. Ta ya trigo ya binalohbohan ay ihimpan, noa, ya apa haka tatap ay ulamên ha apoy ya a angkaparê.” ");
INSERT INTO sgb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Hên ampamawtismo hi Juan, ay nilumatêng hi Apo Jesus, ya ubat ha balayan Nazaret, ha probinsyan Galilea, ta nagpabawtismo ya kan Juan ha Ilog Jordan. ");
INSERT INTO sgb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Noa, binawal ya ni Juan, ya wana, “Hika ya dapat mamawtismo kangko! Pata hiko pon ya mamawtismo kamo!” ");
INSERT INTO sgb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Noa, hinabi ni Apo Jesus, “Paulayan mon malyari ya habaytsi, ta êmên matupad ya kalabayan ni Apo Namalyari.” Kabay nabay etaman hi Juan hên mamawtismo kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Hên nabawtismoan yay na hi Apo Jesus, hên inumawah ya ha lanêm, ay biglan nagloat ya langit, haka na nahêlêk ya Espiritu ni Apo Namalyari, ya an-umaypa hên nanad ha mihay pati-pati, ya inumugpa kana. ");
INSERT INTO sgb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Hên habayto, ay main habi ya ubat ha langit, ya wana, “Hatsi ya panlugurên kon Anak ya ampamahigla kangko.” ");
INSERT INTO sgb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pangayari yan nagpabawtismo hi Apo Jesus ha Ilog Jordan, ay hiyay gintan ha logal ya kabalah-balahan, hên Espiritu ni Apo Namalyari, ta tuksoên ya ni Satanas. ");
INSERT INTO sgb_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Apatapo ya allo haka yabi, ay nagtêêh ya hên a nangan. Kabay hên nalabah ya habayto, ay angkablay yay nan lonoh. ");
INSERT INTO sgb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nilumatêng hi Satanas ya mánukso, ta wana kan Apo Jesus, “No hika ya Anak ni Apo Namalyari, ay daygên mon puto ya hata bato.” ");
INSERT INTO sgb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Noa, hinabi kana ni Apo Jesus, “A ko! Ha habi ni Apo Namalyari ay nakahulat ya êmên di, ‘Hilay tawo ay a mabiyay ha kaên bêngat, noa, kailangan la etaman ya balang anhabiên ni Apo Namalyari.’” ");
INSERT INTO sgb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pangayari, ay gintan ya ni Satanas, hi Apo Jesus, ha Jerusalem, ya banal ya balayan, ha têngêl hên Templo. ");
INSERT INTO sgb_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Haka hinabi ni Satanas kan Apo Jesus, “No pêtêg hên hika ya Anak ni Apo Namalyari, ay magnabo kan paubat di, ta nakahulat ha Kahulatan, ya impahulat ni Apo Namalyari, ya êmên di, ‘Iutoh ni Apo Namalyari hilay anghel na hên mangillag kamo, haka halorên la ka êmên a mahakitan ya bitsih mo ha bato.’” ");
INSERT INTO sgb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Noa, hinabi ni Apo Jesus, ya wana, “Nakahulat etaman ha impahulat ni Apo Namalyari, ‘Paan mon subukên ya Panginoon mo, hi Apo Namalyari.’” ");
INSERT INTO sgb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pangayari, ay gintan yay na êt ni Satanas, hi Apo Jesus, ha hadyay tag-ay ya tawgtug, ta impahlêk ni Satanas kana ya balang bansa ha boon luta haka ya kahampatan la. ");
INSERT INTO sgb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Biha hinabi na kan Apo Jesus, ya wana, “Iubuh ko kamo ya habayto no mandoko kan mandêngdêng hên magsimba kangko.” ");
INSERT INTO sgb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Noa, hinabi ni Apo Jesus, ya wana, “Satanas, mag-alíh ka di! Ta nakahulat ha habi ni Apo Namalyari: ‘Simbaên moy Panginoon mo, hi Apo Namalyari, ta hiyan bêngat ya huyuên mo.’” ");
INSERT INTO sgb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Amêhên, ay nag-alíh yay na hi Satanas, haka main anghel ya nilumatêng, ya nipanawop kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Hên namwangan ni Apo Jesus, ya impakulung hi Juan Bautista, ay nag-orong ya ha balayan Nazaret ha probinsyan Galilea. ");
INSERT INTO sgb_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","A ya naglaêh ha Nazaret ta naglaêh ya ha balayan Capernaum, bayro êt ha probinsyan Galilea. Ya balayan Capernaum, ay atsi ha laylay hên Dagat-dagatan hên Galilea, ha nag-in logal lan kaapo-apoan ni Zabulon, haka Neftali ya lowa kanlan anak ni apo Israel. ");
INSERT INTO sgb_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ha panoro na bayro, ay nakatupad ya hinabi ni Propeta Isaias hatoy mihay mámipamwang hên an-ipaihip kana ni Apo Namalyari. Ya habi na ay nakahulat hên hato, ya êmên di, ");
INSERT INTO sgb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ha Galilea, ha logal lan kaapo-apoan ni Zabulon, haka lan kaapo-apoan ni Neftali ya atsi ha laylay hên dagat-dagatan, boy ha lipay hên Ilog Jordan, ya ampaidyanan etaman hên mal-at ya alwan Israelita ya a ampagpalokop kan Apo Namalyari, ");
INSERT INTO sgb_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ay nanad hilan atsi ha kariglêman haka ha kamatsan, gawan marayo hila kan Apo Namalyari. Noa, lano ay main mamahawang hên kaihipan la.” ");
INSERT INTO sgb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Paubat hên habayto, ay namipamwang yay na hi Apo Jesus, ya wana, “Maghêhê kaw na, haka talibatokan yoy pamanyag yon kasalanan, ta nilumatêng ya pamanlokop ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ha pammita ni Apo Jesus ha laylay hên Dagat-dagatan hên Galilea, ay nahêlêk nay loway mikapotoh pohêl, ya magdadakêp hên kênan lanêm, ya hi Andres haka hi Simon, ya ambanhagan lan Pedro. Hila ay ampayhabwag hên lambat ha lanêm, ta ampandakêp hila dayi hên kêna. ");
INSERT INTO sgb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Hinabi na kanla, “Makihonol kaw kangko, ta daygên kataw hên mámipakarani hên tawo kangko, ta êmên hila maniwala.” ");
INSERT INTO sgb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tampol lan imbalag ya lambat la, ta nakihonol hila kana. ");
INSERT INTO sgb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ha pammita lan Apo Jesus ha laylay hên lanêm, ay nahêlêk na êt ya maának ni Zebedeo, ya hi Santiago haka hi Juan. Hila ay atsi ha bangka hên kalamoy tatang la, hên ampamitoyo hên lambat la. Hinagyat hila ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tampol lan imbalag ya bangka la haka ya tatang la, ta nakihonol hila kana. ");
INSERT INTO sgb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nanoro yay na ha mal-at ya sinagoga lan Israelita ha boon probinsyan Galilea. Impamwang nay Mangêd ya Habi tungkol ha pamanlokop ni Apo Namalyari haka namaalíh ya êt hên kaganawan hakit la. ");
INSERT INTO sgb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ya tungkol kana ay nibahwag ha boon Siria. In-ubuh lan gintan kana ya main hakit, pokol, lumpo, pilay, hilay nagtugaw, haka hilay hinapatan hên nangarawak ya a angkahêlêk ya ampamairap kanla. Namaalíh ya hên kaganawan hakit la, haka kaganawan nangarawak ya a angkahêlêk ya ampamairap kanla. ");
INSERT INTO sgb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kabay hadyay kal-atan ya ubat ha probinsyan Galilea, Decapolis, probinsyan Judea, balayan Jerusalem, haka ha lipay hên Ilog Jordan, ya nangamat kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Hên nahêlêk ni Apo Jesus ya kal-atan ya ampangamat kana, ay nilumakat yan pêrad ha tawgtug, ta bayro yan nikno hên manoro kanla. Kabay dinumani hila kana ya tagahonol na. ");
INSERT INTO sgb_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Haka tinoroan na hila, ya wana, ");
INSERT INTO sgb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Iningalwan kaw ya alwan mapaglalang, gawan hikaw ay milamo ha pamanlokop ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Iningalwan kaw ya ampaglungkot gawan ha kasalanan yo, ta amung-mungên kaw ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Iningalwan kaw ya maaypa ya nakêm, ta midin kamoyu ya impangako ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Iningalwan kaw no labay-labay yon manonol ha kalabayan ni Apo Namalyari, ta hawpan na kaw hên manonol. ");
INSERT INTO sgb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Iningalwan kaw ya maingaloên, ta ihundo na kaw hên ingalwan ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Iningalwan kaw ya nakapêptêng ya nakêm kan Apo Namalyari, ta mahêlêk yo ya. ");
INSERT INTO sgb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Iningalwan kaw ya mámilatan, ta hikaw ay itad ni Apo Namalyari hên anak na. ");
INSERT INTO sgb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Iningalwan kaw no ampairapan la kaw gawan ha pamanhumonol yo ha kalabayan ni Apo Namalyari, ta milamo kaw ha pamanlokop na. ");
INSERT INTO sgb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Iningalwan kaw no gawan bêngat ha paniwala yo kangko, ay pairapan la kaw, haka musmusên la kaw, haka no habiên lay hinon nangarawak ya alwan pêtêg ya pamanira la kamoyu. ");
INSERT INTO sgb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","No malyari ya habayto, ay magpakahigla kaw, ta ayn kapantag ha kangêran, ya primyo ya matanggap yo lano ha langit. Panêmtêmên yoy êmbayro êt ya pamairap lan ninuno la kanlan mámipamwang hên an-ipaihip kanla ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Inhundo ni Apo Jesus ya panoro na, ya wana, “Hikaw ya anhumonol ha kalabayan ni Apo Namalyari, ay maialimbawa ha ahin bayri ha luta. Ihipên yo no ay-êmên anggamitên ya ahin. Mangêd ya ahin, noa, no naalihan yay nan alat, ay ahinan maiorong ya alat na. Ayn yay nan pukat! Itapon ya tana haka pitu-tuk-anan. ");
INSERT INTO sgb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Hikaw ay maialimbawa etaman ha hawang ya ampakahawang hên kaihipan hên balang miha ha boon luta. Ya kangêran ya andaygên yo, ya angkahêlêk lan kaatag, ay nanad ha a maitago ya balayan ya atsi ha bung-oy. ");
INSERT INTO sgb_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ayn mamagkêt hên atáng, bayo ihimpan o itagpên. Noa, ya atáng ay idin ha mantêg hên pamyanan atáng, ta êmên mahawangan hilay atsi ha bali. ");
INSERT INTO sgb_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Êmbayro êt ya pakapakikwanan yon mamiyay, hên main kangêran ha arapan hên kapareho yo, ta êmên la puriên hi Apo Namalyari, ya Tatang tamo ha langit.” ");
INSERT INTO sgb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Inhundo ni Apo Jesus ya panoro na, ya wana, “Paan yon ihipên ya atsi ko di, ta êmên alihan hên alagá ya Kautuhan ni apo Moises, haka ya inhulat lan kaatag ya mámipamwang hên an-ipaihip kanla ni Apo Namalyari. Atsi ko di, ta êmên ko tuparên haka ipamwang ya habayto kamoyu. ");
INSERT INTO sgb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Pakagilamên yo, kaban main pon angkahêlêk ha langit, haka kaban main pon luta, ay a malyarin daygên ayn pukat ya miha man ya nanaway letra o naipêk ya gulis hên habaytoy Kautuhan ni Apo Namalyari, o hên Kahulatan lan mámipamwang hên an-ipaihip kanla ni Apo Namalyari, angga ha a pon matupad ya kaganawan ya habayto. ");
INSERT INTO sgb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kabay hilay a anhumonol ha miha man kanlan habaytoy Kautuhan, bayo manoro êt ha kapareho la hên paan hilan humonol, ay hilay mag-in pinakamaaypa ha pamanlokop ni Apo Namalyari. Noa, hilay anhumonol ha Kautuhan, haka ampanoro hên dapat honolên ya habayto, ay mag-in matag-ay ha pamanlokop ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Pakagilamên yo, a kaw makapakilamo ha pamanlokop ni Apo Namalyari, no ya pamanhumonol yo kana ay alwan ubat ha nakêm. Paan yon tuwarên ya alwan mantêg ya pamanhumonol lan Pariseo haka mánoron Kautuhan ni apo Moises.” ");
INSERT INTO sgb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Inhundo ni Apo Jesus ya panoro na, ya wana, “Nagilam yoy in-utoh hên haton lagi, ‘Paan mamatsi hên kapareho ta hilay mamatsi, ay hatolan hên parusaan.’ ");
INSERT INTO sgb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Noa, hikoy ampaghabi kamoyu, ya hilay anhumuluk ha kapareho la, ay hatolan ni Apo Namalyari hên parusaan, haka hilay ampammusmus ha kapareho la, ay hatolan hên parusaan hên Sanedrin. Haka hilay ampaghabi ha kapareho la, ya ‘Mulala ka!’ ay ipalako ha apoy ha impiyerno. ");
INSERT INTO sgb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kabay bayo kaw mam-in digalo kan Apo Namalyari ha pamiulaman hên an-iátang kana ha Templo, ta main kaw napanêmtêman ya dinyag yoy alwan mangêd ha kapareho yo, haka main hilan hakit nakêm kamoyu, ");
INSERT INTO sgb_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ay paan pon idin ya idigalo yo. Lakwên yo hila pon, ta makikahundo kaw pon. Bayo maidin yoy nay idigalo yo kan Apo Namalyari ha pamiulaman hên an-iátang kan Apo Namalyari ha Templo. ");
INSERT INTO sgb_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“No main labay hên mamidikil kamoyu, ay mangêd ya tampol kaw makikatoynungan kanla, ta êmên a la kaw gêtan ha mánlingon kaso. Ta kayno idin na kaw ha magbantay hên hukulan, ta ikulung kaw. ");
INSERT INTO sgb_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kabay bayro kaw tana ha hukulan angga ha a yo maubuh hên mabayaran ya ipabayad la kamoyu.” ");
INSERT INTO sgb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Inhundo ni Apo Jesus ya panoro na, ya wana, “Nagilam yoy in-utoh hên haton lagi, ya wanla, ‘Paan mamabayi haka paan makilalaki.’ ");
INSERT INTO sgb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Noa, hikoy ampaghabi kamoyu, ya paan mangihip man hên kalabayan lawini ha pamanlêk ha alwan ahawa, ta habaytoy kasalanan hên mamabayi haka makilalaki. ");
INSERT INTO sgb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kabay, no mata yo ya anggamitên yon manyag kasalanan, ay kêwêtên yo, haka yon itapon. Ta mangêd pon ya maalihan kaw mata, kanan mihamwag kaw ha impiyerno, boo man ya lawini yo. ");
INSERT INTO sgb_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","No gamêt yo ya anggamitên yon manyag kasalanan, ay mangêd ya potohên yo ta itapon, kanan mihamwag kaw ha impiyerno, boo man ya lawini yo.” ");
INSERT INTO sgb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Inhundo ni Apo Jesus ya panoro na, ya wana, “Muwang yoy Kautuhan ya hinulat ni apo Moises, ya wanan hulat, ‘Hilay lalaki ya mamihiyay hên ahawa la, ay dapat dyanan lay ahawa la hên kahulatan ya inhiyay hila.’ ");
INSERT INTO sgb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Noa, amêhên hiko ya ampaghabi kamoyu, ya hilay lalaki ya mamihiyay hên ahawa la, no a hila nakilalaki, ay daygên lan mámakilalaki ya ahawa la no makiahawa hilan kaatag ya lalaki. Haka hilay makiahawa ha babayi ya inhiyay, ay mikasalanan hila etaman.” ");
INSERT INTO sgb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Inhundo ni Apo Jesus ya panoro na, ya wana, “Nagilam yoy in-utoh hên haton lagi, ya wanla, ‘Paan kaw mangako hên main lamoy paghumpa, no ayn ha nakêm yo ya tuparên ya habayto, ta dapat tuparên ya inhumpa ya pangako kan Apo Namalyari.’ ");
INSERT INTO sgb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Noa, hikoy ampaghabi kamoyu, ya paan kaw nan maghumpa no mangako kaw! Paan maghumpa hên manggamit hên langit, ta habaytoy dyanan ni Apo Namalyari, ");
INSERT INTO sgb_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","o ha luta man, gawan habaytoy nanad paypaluntoan bitsih na, o ha balayan Jerusalem, ta habaytoy balayan ni Apo Namalyari, ya Ari ya matag-ay ya tungkulan. ");
INSERT INTO sgb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Paan êt habiên ya ‘Matsi ko man.’ Ta yarin mapauban, o mapauyang yo ya habot yo! ");
INSERT INTO sgb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Habiên yo tanan, ‘Awo,’ o ‘Ahê.’ Paan yoy nan pahanan hên humpa, ta hi Satanas ya pangubatan hên habayto.” ");
INSERT INTO sgb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Inhundo ni Apo Jesus ya panoro na, ya wana, “Nagilam yoy in-utoh hên haton lagi, ya wanla, ‘No binuwag yoy mata hên kapareho yo, ay kailangan buwagên êt ya mata yo. No nanira kaw hên gogot hên kapareho yo, ay kailangan hiraên êt ya gogot yo.’ ");
INSERT INTO sgb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Noa, amêhên hiko ya ampaghabi kamoyu, paan yon tumbahan karawakan hilay mapanyag karawakan. No main manampaling kapakan pingi yo, ay ipatampaling yo êt kanla ya kapaka. ");
INSERT INTO sgb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","No main mangidikil kamoyu, ta êmên la makway kamiseta yo, ay idin yo kanla ya sambra yo etaman. ");
INSERT INTO sgb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","No patolukên la kaw hên mangarga hên kalga la ha mihay kilometro, ay kargaên yoy na hên loway kilometro. ");
INSERT INTO sgb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mam-i kaw kanlan kaganawan ya ampakikwa kamoyu, haka no main labay hên mandam pibandian yo, ay paan kaw mangimot.” ");
INSERT INTO sgb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Inhundo ni Apo Jesus ya panoro na, ya wana, “Nagilam yoy in-utoh hên haton lagi, ya wanla, ‘Dapat yon lugurên ya kapareho yo, haka dapat yon kahêmêkan ya kapatsi yo.’ ");
INSERT INTO sgb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Noa, panhabiên ko kamoyun atsi di hên ampanggilam, ya dapat yon lugurên ya kapatsi yo, haka dapat yon ihalangin hilay ampamairap kamoyu gawan ha paniwala yo, ");
INSERT INTO sgb_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ta êmên mamwangan ya hikaw ay maának ni Apo Namalyari, ya Tatang tamo ha langit. Gawan hiyay ampam-in allo boy uran kanlan mahonol kana haka kanlan mapanyag karawakan. ");
INSERT INTO sgb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","No anlugurên yon bêngat hilay ampanlugud kamoyu, ay yarin main kaw hên maêngganan ya primyo kan Apo Namalyari. Ta hila man ya máningil buwih, ya ampangwan sobra ha an-ipakwa kanla hên gobyernon Roma, ay ampanlugud êt ha ampanlugud kanla. ");
INSERT INTO sgb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Haka no ampansinên yon bat hilay ampamansin kamoyu, ay hinon kangêran ya andaygên yo ya igit ha pandaygên lan kaatag, ta hila man ya a ampagpalokop kana, ay ampamansin kanlan ampamansin kanla. ");
INSERT INTO sgb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kabay dapat kaw mag-in mangêd ya ayn hinon kapintasan hên nanad kan Apo Namalyari, ya Tatang tamo ha langit.” ");
INSERT INTO sgb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Inhundo ni Apo Jesus ya panoro na, ya wana, “Paan kaw magbabara hên mangêd kaw, ta no magbabara kaw hên mangêd kaw, ay ayn kaw bayton maêngganan ya ubat ha Tatang tamo ya atsi ha langit. ");
INSERT INTO sgb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Kabay no manawop kaw ha mangairap, ay paan yon ipamwang ya habayto. Paan yon tuwarên hilay ampagbabara hên mangêd bayro ha sinagoga haka ha kalsada. Ampanawop hilan bat gawan ampanapol hilan pamandayêw. Pakagilamên yo, ayn hilay nan maêngganan kan Apo Namalyari, gawan dinayêw hilay nan kapareho la. ");
INSERT INTO sgb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Noa, hikaw, no manawop kaw ha mangairap, ay paan yoy nan ipamwang agyan ha kalamo yo, ");
INSERT INTO sgb_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ta êmên a mamwangan ya habayto, haka main kaw hên maêngganan ubat ha Tatang tamo ha langit ta angkahêlêk nay kaganawan.” ");
INSERT INTO sgb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Inhundo ni Apo Jesus ya panoro na, ya wana, “No manalangin kaw, ay paan yo hilan tuwarên hilay ampagbabara hên mangêd hila, ta labay-labay lan mirêng hên manalangin ha sinagoga haka ha pihobangan dann, ta êmên hila mahêlêk hên kaatag. Pakagilamên yo, ayn hilay nan maêngganan kan Apo Namalyari, gawan tinanggap lay nay pamandayêw hên kapareho la, ya tinapol la. ");
INSERT INTO sgb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Noa, hikaw, no manalangin kaw, ay humwên kaw ha bali yo haka ihara yoy kabat, ta ya Tatang tamo, ya a angkahêlêk, ay hiyay ampakahêlêk kamoyu, haka main kaw hên maêngganan ya ubat kana. ");
INSERT INTO sgb_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“No manalangin kaw, ay paan yon piorong-orong ya ayn labay habiên hên nanad ha andaygên lan a ampagpalokop kan Apo Namalyari ya êndat la no gilamên hila, gawan kakarangan panalangin la. ");
INSERT INTO sgb_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Paan yo hilan tuwarên, ta bayo kaw ampakidawat ha Tatang tamo, ya hi Apo Namalyari, ay mana nay nan muwang ya angkailanganên yo. ");
INSERT INTO sgb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Manalangin kaw hên êmên di: ‘Tatang naên ha langit, puriên ka dayi hên balang miha. ");
INSERT INTO sgb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Dayi lumatêng ya pamanlokop mo di ha luta. Madyag ya kalabayan mo di ha luta, hên nanad ha langit. ");
INSERT INTO sgb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Dyanan mo kay dayi hên kaên ya kailangan naên amêhên. ");
INSERT INTO sgb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Patawarên mo kay ha kasalanan naên ta ampatawarên naên etaman ya kaganawan ya nakadyag kasalanan kannaên. ");
INSERT INTO sgb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Paan mo kay paulayan hên matukso, haka idayo mo kay ha karawakan. Gawan hika ya pinakapoon hên balang hino, haka atsi kamo ya kapangyarihan ya ayn kapantag. Hika ya puriên hên ayn angga! Amen.’ ");
INSERT INTO sgb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ta no patawarên yoy nakadyag kasalanan kamoyu, ay patawarên na kaw etaman ni Apo Namalyari ya Tatang tamo ha langit. ");
INSERT INTO sgb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Noa, ta no a yon patawarên ya nakadyag kasalanan kamoyu, ay a na kaw patawarên ni Apo Namalyari, ya Tatang tamo ya atsi ha langit.” ");
INSERT INTO sgb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Inhundo ni Apo Jesus ya panoro na, ya wana, “No ampagtêêh kaw hên a mangan, ta êmên a maabala ya panalangin yo, ay paan kaw manoto kanlan magbabara hên mangêd, ya a ampag-ayos, haka ampaglungkot, ta êmên mamwangan hên kaatag ya a hila ampangan. Dinayêw hilay na, kabay ayn hilay nan maêngganan kan Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Noa, hikaw, no ampagtêêh kaw hên a mangan, ta êmên a maabala ya panalangin yo, ay dyanan yon laro ya habot yo, maghuklay kaw haka magkulamêh, ");
INSERT INTO sgb_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ta êmên a madambi hên kaatag ya a kaw ampangan, ta hi Apo Namalyari, ya Tatang tamo, ya a angkahêlêk, ay hiyay ampakahêlêk kamoyu, haka main kaw hên maêngganan ya ubat kana.” ");
INSERT INTO sgb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Inhundo ni Apo Jesus ya panoro na, ya wana, “Paan kaw manipon hên pibandian bayri ha luta, ta main mal-at ya maniran habayto, nanad ha anag, o taêy. Haka malyarin maplak ya êt gawan main manakaw. ");
INSERT INTO sgb_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Noa, manyag kaw hên ikahigla ni Apo Namalyari ya nanad ha ampanipon kaw hên pibandian ha langit, ta ha êmbayro ay nanad kaw hên main pamyanan pibandian ya a mahira hên anag, o taêy, haka a maplak. ");
INSERT INTO sgb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Dapat yon daygên ya habayto, ta no anto ya pibandian yo, ay atsi êt bayro ya nakêm yo.” ");
INSERT INTO sgb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ya mata yo ay nanad pag-atáng hên nakêm yo. No nahawang ya mata yo, ay mahawangan êt ya nakêm yo. ");
INSERT INTO sgb_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Noa, no napukakê ya angkahêlêk yo, ay dumiglêm êt ya nakêm yo. No ya ampamahawang dayin nakêm yo, ay nariglêm awud, ay taganán ampamiyay kaw ha hadyay kariglêman.” ");
INSERT INTO sgb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ayn hinoman ya makapaghuyo ha loway amo hên booy nakêm. Ta lugurên nay miha, haka kahêmêkan nay miha, o huyuên nan mantêg ya miha, ta hatoy miha, ay pahawaan na. Êmbayro êt, ay a yo kayan huyuên hi Apo Namalyari no ubuhên yoy hêkaw yo hên magkamain pibandian. ");
INSERT INTO sgb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Kabay anhabiên ko kamoyu ya paan kaw manyagah, no hinoy maêkan haka mainêm yo, ta êmên kaw mabiyay. Paan kaw êt manyagah no hinoy maitakop yo. Gawan ya biyay ay maalagá ha kaên, haka ya lawini ay maalagá ha takop. ");
INSERT INTO sgb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Hêlkên yo hilay manok lalê, a hila mananêm, a hila ampanggapah, ayn hilan pamyanan hên nagapah la. Êmbayro man, ay ampakanên hila ni Apo Namalyari, ya Tatang tamo ha langit. Taganán maalagá kaw kanlan manok lalê kabay a na kaw paulayan! ");
INSERT INTO sgb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Manyagah kaw man, ay a yo mapakarang ya biyay yo! ");
INSERT INTO sgb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Awta manyagah kaw no hinoy itakop yo! Ihipên yo tanay pamantumubo hên bulaklak. A hila ampag-obra o ampanayi man hên takop la. ");
INSERT INTO sgb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Agyan hi Arin Solomon, ha kal-atan bandi na, ay a ya nakapagtakop hên nanad kahampatan hên mihay bulaklak. ");
INSERT INTO sgb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","No ya lamon, ya angkabiyay pon amêhên, bayo ulamên pangawatah, ay ampahampatên ni Apo Namalyari, yarin a na kaw dyanan takop! Kulang awud ya paniwala yo kana. ");
INSERT INTO sgb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kabay paan kaw manyagah ha panapol yon maêkan yo, mainêm yo haka maitakop yo. ");
INSERT INTO sgb_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ta hilay a ampagpalokop kan Apo Namalyari, ay panay hên ampanyagah no hinoy maêkan, mainêm haka maitakop la. Noa, hikaw, ay paan yo hilan totoên, ta muwang nan Tatang tamo ha langit, ya hi Apo Namalyari, ya kailangan yoy habayto. ");
INSERT INTO sgb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Unaên yoy pagpalokop yo kan Apo Namalyari, hên mamiyay hên mahonol ha kalabayan na, ta idin na ya kaganawan kailangan yo. ");
INSERT INTO sgb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kabay paan yon ikayagah ya kailangan yo lano, ta muwang ni Apo Namalyari no hinoy kailangan yo. Hukad ya kairapan ya an-arapên yo amêhên. Paan yon ikayagah ya kairapan ya lumatêng lano.” ");
INSERT INTO sgb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Inhundo ni Apo Jesus ya panoro na, ya wana, “Paan kaw mihahatol, ta êmên a kaw hatolan ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ta no ay-êmên ya pamanatol yo ha kaatag, ay êmbayro êt ya pamanatol ni Apo Namalyari kamoyu. Ta ya pamanatol ay nanad ha an-itakal. No ay-êmên ya pamaytakal yon pamanatol ha kaatag, ay êmbayro êt ya pamaytakal hên pamanatol ni Apo Namalyari kamoyu. ");
INSERT INTO sgb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Panhêlkên yoy alwan nabyat ya kasalanan ya nanad poling ha mata hên kaatag, noa, a yo ampansinên ya nabyat ya kasalanan yo, ya nanad batang ya atsi ha sarili yon mata. ");
INSERT INTO sgb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ay-êmên yon mahabi ha kapareho yo, ‘Paulayan mo kon alihên ya poling ha mata mo,’ no hikaw êt, ay a yo angkahêlêk ya nanad batang ya atsi ha mata yo. ");
INSERT INTO sgb_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Hikaw ya ampagbabara hên mangêd! Unaên yon alihên ya nanad batang ya atsi ha mata yo, bayo makahêlêk kaw hên mangêd, ta êmên yo maalíh ya nanad poling ha mata hên kaatag. ");
INSERT INTO sgb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Paan yon ipalêkpêk hên ipamwang ya tungkol kan Apo Namalyari kanlan a mabay manggilam, ta habaytoy nanad ha ampam-i kaw hên maalagá ha aho ya mangayat kamoyu. Haka nanad êt ha mamitapon ha baboy, hên makamal ya perlas, ta bat la tanan pitu-tuk-anan.” ");
INSERT INTO sgb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Wana êt ni Apo Jesus, “Paka-pakikwaan yoy kailangan yo kan Apo Namalyari, ta dyanan na kaw. Pakatapolên yo ya kailangan yo kana, ta hawpan na kaw. Pakabaêgên yo ya, ta pakibatan na kaw hên nanad ha kabat ya loatên. ");
INSERT INTO sgb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Daygên yoy habayto, ta hilay ampamalêkpêk hên kikwa ay dyanan. Hilay ampamalêkpêk hên manapol hên kailangan la kana ay makatapol. Hilay ampamalêkpêk hên mamaêg, ay pakibatan hên nanad ha kabat ya loatên. ");
INSERT INTO sgb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ayn miha man kamoyu ya mam-in bato ha anak na, no kikwa yan puto. ");
INSERT INTO sgb_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ayn etaman miha man kamoyu ya mam-in nabiyay ya utan ya makamatsi ha anak na, no kikwa yan kênan lanêm. ");
INSERT INTO sgb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Makasalanan kaw man, ay kamwang kaw hên mam-in ikakangêd ha maának yo. Hi Apo Namalyari pon kaya, ya Tatang tamo ya atsi ha langit, ya ayn kasalanan, ay yarin a ya mam-in ikakangêd lan kikwa kana! ");
INSERT INTO sgb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Ya kangêran ya labay yo hên daygên la kamoyu hên kaatag, ay êmbayro êt ya dapat yon daygên kanla, ta habaytoy nakahulat ha Kautuhan ni apo Moises, haka ha inhulat lan kaatag ya propeta ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Pakangêrên yon humwên ha makpit ya ilwangan, ta malawang ya ilwangan boy dann ya palako ha kaparusaan ya ayn angga, haka mal-at ya ampagdann hên anhumwên bayro. ");
INSERT INTO sgb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Noa, nakpit ya ilwangan boy dann ya palako ha biyay ya ayn anggaan, haka pêpêrad ya ampakatapol boy ampagdann bayro.” ");
INSERT INTO sgb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Kaillag kaw kanlan ampagbabara hên ampanoro hilan kaptêgan, ta naayang ya pamaghabi la. Nanad hilan matonud ya tupa, noa, ya an-itoro la ay ampakahira. ");
INSERT INTO sgb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mabalayan yo hila ha dyag la. A ya managêy hên ubas ya tanyuong! A etaman managêy hên igos ya korêrêng-êy! ");
INSERT INTO sgb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Êmbayro êt, hilay mangêd ya kayo, ay ampanagêy hên mangangêd, noa hilay narawak ya kayo, ay ampanagêy hên nangarawak. ");
INSERT INTO sgb_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ya mangêd ya kayo ay a ampanagêy hên nangarawak, haka ya narawak ya kayo ay a ampanagêy hên mangangêd. ");
INSERT INTO sgb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Hilay kayo ya ampanagêy hên nangarawak ay potohên ta ulamên. ");
INSERT INTO sgb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Hilay kayo ay angkabalayan ha tagêy la. Êmbayro êt, ay mamwangan hilay ampagbabara hên ampanoro hilan kaptêgan ha dyag la.” ");
INSERT INTO sgb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Hinabi nay na êt ni Apo Jesus, “Alwan kaganawan ya ampamaêg kangkon, ‘Panginoon, Panginoon,’ ay makapakilamo ha pamanlokop ni Apo Namalyari, ya Tatang ko ha langit, noa, hilan bat ya ampanyag kalabayan na. ");
INSERT INTO sgb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Lumatêng ya Allon Pamanukom ni Apo Namalyari, ay mal-at ya maghabi kangko hên, ‘Panginoon, Panginoon, pahowênên yo kay! Ta impamwang naên ya impamwang mo, haka ha kapangyarihan mo, ay namipaplag kay hên nangarawak ya hinumapat ha tawo, haka kay nanyag hên kaatag êt ya kapapaêpapah ha langan mo.’ ");
INSERT INTO sgb_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Gawan a la dinyag ya kalabayan ni Apo Namalyari, ay arap-arapan kon habiên kanla ya, ‘Ayn kaw hên karapatan hên humwên di! Pakarayo kaw kangko, ya nipanyag hên karawakan!’” ");
INSERT INTO sgb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Inhundo ni Apo Jesus ya panoro na, ya wana, “Hilay ampanggilam habi ko, haka anhumonol ha nagilam la, ay maialimbawa ha mihay lalaki ya matalino, ya nanyag bali. Nangali yan malalê hên angga ha nidaoh ha aplag, ta bayro nan impairêng ya bali na. ");
INSERT INTO sgb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Hên nanguran, nanlanab, haka nangangin hên makhaw, ay bininhêkan ya bali, noa, a ya natumba, ta impairêng ya ha aplag. ");
INSERT INTO sgb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Noa, hilay ampakagilam hên habi ko, bayo a ampanyag hên nagilam la, ay nanad hên lalaki, ya ayn minúwang, ya namairêng bali ha kabalahan ya alwan napah-êy. ");
INSERT INTO sgb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Hên nanguran, nanlanab, haka nangangin hên makhaw, ay bininhêkan ya bali, haka tampol natumba boy nangaagwat ya habayto.” ");
INSERT INTO sgb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Hên nayari yan naghabi hi Apo Jesus, ay naubuh hilan nag-êpapah ha panoro na, ");
INSERT INTO sgb_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","gawan ya pamaghabi na, ay pamaghabi hên mihay main tungkulan, alwan nanad pamaghabi lan mánoron Kautuhan ni apo Moises. ");
INSERT INTO sgb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Hên nakalohan hi Apo Jesus hên ubat ha tawgtug, ay main kal-atan ya nangamat kana. ");
INSERT INTO sgb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Dinumani kana ya mihay lalaki ya nag hakit ketong. Nandoko ya ha arapan na, ta wanan nakiingalo, “Panginoon, no kalabayan mo, ay paalihên moy hakit ko, êmên luminis ya lawini ko.” ");
INSERT INTO sgb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Impalunto ni Apo Jesus ya gamêt na ha nag hakit hên ketong, bayo wana, “Labay kon paalihên ya hakit mo. Luminis ka!” Tambêng naalíh ya hakit na. ");
INSERT INTO sgb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Bayo wani Apo Jesus kana, “Paan mo pon ipamwang ya hatsi ha hinoman. Pakha ka ha pari ta ipahlêk mo kana ya ayn kay nan ketong. Mantan kan maiparaya ha pamanhumonol mo ha utoh ni apo Moises, ta êmên mapaptêgan mo kanlan kaatag ya malinis kay na.” ");
INSERT INTO sgb_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Hên nilumatêng yay na hi Apo Jesus ha balayan Capernaum, ay main mihay kapitan hên hundaloh ya taga-Roma ya nakiingalo kana, ya wana, ");
INSERT INTO sgb_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Panginoon, ya ipoh ko ay a makaalíh ha papag, ta main yan nabyat ya hakit, haka a na maigalaw ya lawini na. Pêrad tana ay a nay na matêêh ya hadyay ilab.” ");
INSERT INTO sgb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Kabay wani Apo Jesus, “Mita kitay na, ta paalihên koy hakit na.” ");
INSERT INTO sgb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","“Panginoon, paan kay nan paabala hên humwên ha bali ko, ta angkarêng-êy ako kamo. Iutoh mo tana, ay maalíh ya hakit hên ipoh ko. ");
INSERT INTO sgb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Hiko man, ay atsi ko ha aypa hên kapangyarihan hên kaatag, bayo nag hundaloh ha aypan kapangyarihan ko. Ya kaganawan utoh ko, ay daygên la. No habiên ko kanan miha, ‘Mita ka,’ ay mita yay na. No habiên ko kanan kaatag, ‘Paidani ka di,’ ay dumani ya. No habiên ko kanan ipoh ko, ‘Daygên moy hatsi,’ ay daygên na.” ");
INSERT INTO sgb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Hên nagilam nay habayto ni Apo Jesus, ay nag-êpapah ya. Inarap nay kal-atan ya ampipanonol kana, ta hinabi na, “Pakagilamên yo, ayn akon nahêlêk ya miha man ya Israelita, ya êmbayro ya kataniêh ya paniwala. ");
INSERT INTO sgb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Pakaihipên yoy hatsi, mal-at ya alwan Israelita, ya ubat ha ay-irin logal di ha luta, ay kiaêm ha kaluto hên kalamo hi apo Abraham, apo Isaac, haka apo Jacob ha pamanlokop ni Apo Namalyari ha langit. ");
INSERT INTO sgb_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Noa, kal-atan ya Israelita ya unan hinagyat, ya a nabay ha pamanlokop ni Apo Namalyari, ay itapon ha kariglêman hên impiyerno. Hadyay tangih la bayro, haka mipang-ngê-ngêt hila ha hadyay huluk la boy ha hadyay ilab ya angkatanam la.” ");
INSERT INTO sgb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Bayo hinabi ni Apo Jesus ha kapitan hên hundaloh, ya wana, “Muli kay na, ta gawan ha paniwala mo, ay maalíh ya hakit hên ipoh mo.” Hên habayto êt, ay naalíh ya hakit hên ipoh hên kapitan. ");
INSERT INTO sgb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Hên nakahowên yay na hi Apo Jesus ha bali ni Simon Pedro, ay nahêlêk nay ampo ni Simon Pedro, ya an-omotên, ya atsi ha papag. ");
INSERT INTO sgb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Tinalan ni Apo Jesus ya gamêt hên bakêt. Tambêng nag-alíh ya hakit na, kabay nirêng yan namakan kanlan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Hên ampinaboy nay allo, ay gintan la kan Apo Jesus ya kal-atan ya hinapatan hên nangarawak ya a angkahêlêk, haka hilay nipaghakit, ta ha utoh nan bat, ay namipaplag yan hinumapat kanlan hinapatan, haka namaalíh yan hakit lan nipaghakit. ");
INSERT INTO sgb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Dinyag ni Apo Jesus ya habayto, ta êmên matupad ya hinabi ni Propeta Isaias, ya êmên di ya pangahabi, “Hiya ya namaalíh hên kaganawan hakit tamo.” ");
INSERT INTO sgb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Hên nahêlêk ni Apo Jesus ya kal-atan ya nakapalibot kana, ay in-utoh nay tagahonol na, ya wana, “Magbangka kitamo hên lumipay.” ");
INSERT INTO sgb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Bayo hila hinumakay ha bangka, ay main mihay mánoron Kautuhan ni apo Moises ya dinumani kana, ya wana kan Apo Jesus, “Mánoro, kihonol ako kamo ay-iri man ya lakwên mo.” ");
INSERT INTO sgb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Hinabi etaman kana ni Apo Jesus, “Hila man ya ahon lalê ay main lêyang ya ampaidyanan, haka hilay manok lalê ay main halay, noa, hiko ya Taga-Langit, ya In-anak Tawo, ay ayn ampaidyanan di ha luta.” ");
INSERT INTO sgb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Wanan miha pon kanan tagahonol na, “Panginoon, paulayan mo ko pon hên mamilbêng tatang ko.” ");
INSERT INTO sgb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Noa, wani Apo Jesus kana, “Kihonol ka kangko, haka paulayan mo hilay ayn biyay ya ayn anggaan, hên mamilbêng kapareho lan natsi.” ");
INSERT INTO sgb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Bayo hinumakay yay na ha bangka hi Apo Jesus, hên kalamo na hilay tagahonol na haka nag-umpisa hilay nan lumipay. ");
INSERT INTO sgb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ha pamanlumipay la, ay nabêlêw ya hi Apo Jesus ha bangka. Amêhên, nagkamain hên hadyay angin, haka ya bangka la ay angkapnoy nan lanêm, noa, hi Apo Jesus ay nabêlêw pon. ");
INSERT INTO sgb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Pinukaw la ya, ya wanla, “Panginoon! Panginoon! Iligtas mo kay, ta ampilêmêh kitamina!” ");
INSERT INTO sgb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Wana kanla, “Ayn kaw awud hên tsiwala kangko! Pata hadyay limo yo!” Nimata ya, ta binawal nay angin haka hadyay tandulon. Tinunggên etaman ya angin haka tandulon, hên namapatêkbêk. ");
INSERT INTO sgb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nag-êpapah hilay tagahonol na. Nihahabi hila, ya wanla, “Hino kaya ya hatsi ya ampakabawal hên angin haka tandulon bayo anhumonol hila kana?” ");
INSERT INTO sgb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Hên nilumatêng hilan Apo Jesus ha logal lan Gadareno, ha lipay lanêm, ay tinupa hila hên loway lalaki ya ubat ha pay-ilbêngan, ya hinapatan hên nangarawak ya a angkahêlêk. Gawan hadyay tobag la, ay ayn ampakadann bayro. ");
INSERT INTO sgb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nan-angaw hila, ya wanla, “Jesus, ya Anak ni Apo Namalyari, awta ampakiêmênan mo kay? Labay mo kay hên parusaan hên alwa pon ya intakda ya panaon?” ");
INSERT INTO sgb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Main kal-atan baboy bayro ya ampipambuk ha bung-oy ya narani ha lanêm. ");
INSERT INTO sgb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nakiingalo hilay hinumapat kanlan lalaki, ya wanla kan Apo Jesus, “No ipaplag mo kay, ay paulayan mo kay hên mipanhumapat kanlan baboy.” ");
INSERT INTO sgb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Pinaulayan na hila ni Apo Jesus. Kabay inumalih hila kanlan lalaki, ta nipanhumapat hila kanlan baboy. Hilay baboy ya hinapatan la, ay nipamwayun palohan ha natalindah ya laylay lanêm hên nilêmêh ha dagat-dagatan. ");
INSERT INTO sgb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Hilay manayhay hên baboy, ay nipamwayu ha balayan la, ta habaytoy nalyari kanlan hinapatan hên nangarawak ya a angkahêlêk, ay impamwang la ha kabalayan la. ");
INSERT INTO sgb_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Hên nagilam lay balita la, ay naubuh lan nilako hilan Apo Jesus. Nakiingalo hila kana ya mag-alíh ya ha logal la. ");
INSERT INTO sgb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Hinumakay hilan Apo Jesus ha bangka ta nilumipay hila ha balayan ya ampagdahêlan la. ");
INSERT INTO sgb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Main nilumatêng ya ungnoy lalaki ya ampantan hên mihay lumpo ya atsi ha langkayan. Hên nahêlêk ni Apo Jesus ya paniwala la kana, ay hinabi na kanan lumpo, “Pakhawên moy nakêm mo, ta pinatawad ya kasalanan mo.” ");
INSERT INTO sgb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Main bayron mánoron Kautuhan ni apo Moises ya êmbayri ya laman ihip, “Hinoy hatsi ya an-ipantag nay sarili na kan Apo Namalyari hên mamatawad hên kasalanan? Yarin a nan ammusmusên hi Apo Namalyari ya tawo yan bêngat! Mimiha na ni Apo Namalyari ya makapatawad hên kasalanan.” ");
INSERT INTO sgb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Muwang ni Apo Jesus ya laman ihip la. Kabay hinabi na kanla, “Awta ampangihipan yo ko hên narawak? ");
INSERT INTO sgb_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Hino awud ya maparah hên habiên kanan mihay a ampakabita, no wangko, ‘Napatawad kay na ha kasalanan mo,’ o no wangko, ‘Hali, mirêng ka ta mita kay na?’ ");
INSERT INTO sgb_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Noa, êmên yo mamwangan ya hiko, ya Taga-Langit, ya In-anak Tawo, ay main tungkulan di ha luta hên mamatawad kasalanan, ay habiên ko kanan lumpo, ‘Mirêng ka. Hapwatên moy langkayan mo ta muli kay na.’” ");
INSERT INTO sgb_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tambêng yan nirêng ha arapan la ya hata lumpo, ta nuli ya. ");
INSERT INTO sgb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Naubuh hilan nag-êpapah ya atsi bayro. Pinuri la hi Apo Namalyari, ya nam-in êmbayroy kapangyarihan ha tawo. ");
INSERT INTO sgb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Pangayari hên habayto, ay nammita yay na hi Apo Jesus. Ha pammita na, ay nakahêlêk yan mihay máningil buwih ya nag langan Mateo, ya ampikno ha paningilan na. Hinabi ni Apo Jesus kana, ya wana, “Kihonol ka kangko.” Kabay nakihonol ya kana. ");
INSERT INTO sgb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Amêhên, hên atsi hilan Apo Jesus ha bali ni Mateo hên ampangan, ay main nilumatêng ya kal-atan máningil buwih, ya kapareho ni Mateo, haka kaatag êt ya makasalanan, ya kalamo la hên nangan. ");
INSERT INTO sgb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Hên nahêlêk lan Pariseo ya ampangan hi Apo Jesus hên kalamoy máningil buwih, haka kaatag êt ya makasalanan, ay nangotang hila kanlan tagahonol ni Apo Jesus, ya wanla, “Pata ampangan ya mánoro yo, hên kalamo lan máningil buwih, haka kaatag êt ya makasalanan?” ");
INSERT INTO sgb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Hên nagilam nay hinabi la, ay nangalimbawa hi Apo Jesus, ya wana, “Hilay main hakit, ay ampangailangan doktor, alwan hilay ayn hakit. ");
INSERT INTO sgb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Êmbayro êt, atsi ko di ha luta ta êmên ko mahagyat hilay ampangamin hên makasalanan hila, hên maghêhê hên manalibokot ha pamanyag lan kasalanan. Noa, hilay ampaghabin ayn hilan kasalanan, ay a ko hawpan. Ihipên yoy hinabi ni Apo Namalyari, ya wana, ‘A ko labay ya mamiátang kaw. Ya labay ko ay mag-in kaw hên maingaloên.’” ");
INSERT INTO sgb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Main ungnoy tagahonol ni Juan Bautista ya naghabi kan Apo Jesus, ya wanla, “Pata hikay haka hilay Pariseo, ay panay hên ampagtêêh hên a mangan, ta êmên a maabala ya panalangin naên? Pata alwan êmbayro ya andaygên lan tagahonol mo?” ");
INSERT INTO sgb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Kabay in-alimbawa ni Apo Jesus ya sarili na ha lalaki ya an-ikasal, ya wana, “Êndat yon manyêngên ya bisita hên an-ikasal kaban kalamo la ya? Ahê! Lumatêng ya allo ya ipakarayo ya lalaki ya an-ikasal, ay bayro hilay nan a mangan.” ");
INSERT INTO sgb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Amêhên, intoro ni Apo Jesus ya a mailamo ya toro na, ha toro lan ninuno la, ya wana, “Ayn mamitagpi hên bayoy tela, ya a pon napipi ha gihi hên manan takop. No alimbawa ta daygên nay habayto, ta pipiên nay na, ay kumpêh ya intakap, haka humlay ya gihi. ");
INSERT INTO sgb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ayn mamitugtug hên bayon alak ha ubatan hên manan alak, gawan lumtoh ya pamyanan, haka mabullog ya alak. Ya bayoy alak ay dapat itugtug ha bayoy pamyanan, ta êmên parehon a tampol mahira.” ");
INSERT INTO sgb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Kaban ampaghabi ya pon hi Apo Jesus, ay main dinumani hên nandoko ha arapan na, ya mihay ampamaala bayro ha sinagoga. Labay na, ya kihonol ya kana ha bali na, hi Apo Jesus, hên ipalunto nay gamêt na ha anak nay babayi, ta pabiyayên na dayi. ");
INSERT INTO sgb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kabay nakihonol kana hi Apo Jesus haka hilay tagahonol na. ");
INSERT INTO sgb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Kaban ampammita hila, ay dinumani kana, ya mihay babayi ya labinloway taon nanan angkairapan ha hakit nan andayaên. Ginapa nay laylayan takop ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Dinyag nay habayto, ta hinabi na ha sarili na, no magapa nan bat ya takop ni Apo Jesus, ay maalíh ya hakit na. ");
INSERT INTO sgb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Hên namalingay hi Apo Jesus, ay nahêlêk na ya, haka wana kanan babayi, “Pakhawên moy nakêm mo. Inalíh ya hakit mo, gawan ha paniwala mo kangko.” Habayto êt, ay naalíh ya hakit na. ");
INSERT INTO sgb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Inhundo lan Apo Jesus ya pammita la ha bali nan habaytoy manungkulan, ha sinagoga. Hên hinumwên hilay na, ay nahêlêk ni Apo Jesus hilay ampag-bulongudyong, haka nagilam nay labak hên kal-atan. ");
INSERT INTO sgb_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Hinabi ni Apo Jesus kanla, “Mag-alíh kaw di, ta a ya natsi. Nabêlêw yan bêngat.” Noa, kinailyan la ya. ");
INSERT INTO sgb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Hên naipaawah na ya kal-atan ya atsi bayro, ay hinumwên yay na ha pinaypakatuluyan kanan anak. Tinalan ni Apo Jesus ya gamêt nan anak, haka tambêng yan nirêng. ");
INSERT INTO sgb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Namwangan ha boon logal hên habayto ya nalyari. ");
INSERT INTO sgb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Hên paalíh hilan Apo Jesus bayro ha bali nan habaytoy manungkulan ha sinagoga, ay main loway buwag, ya nangamat kan Apo Jesus, ya nan-angaw, ya wanla, “Apo Jesus, ya kaapo-apoan ni Arin David, ingalwan mo kay dayi!” ");
INSERT INTO sgb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Inhundo lan Apo Jesus ya pammita la, haka hila hinumwên ha bali ya lakwên la. Hinumwên êt ya loway buwag, kabay wani Apo Jesus kanla, “Ampaniwala kaw hên mapamukat kataw?” Wanla etaman, “Awo, Panginoon.” ");
INSERT INTO sgb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Bayo ginap-an nay mata la, ta wana kanla, “Gawan ha paniwala yo, ay makahêlêk kaw.” ");
INSERT INTO sgb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tambêng hila etaman nakahêlêk. Impapakabawal na hila hên ipamwang ha kaatag ya hiyay namamukat kanla. ");
INSERT INTO sgb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Noa, hên nammita hilay na, ay impamwang la ha boon logal ya habayto, ya pamamukat ni Apo Jesus hên mata la. ");
INSERT INTO sgb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Hên paalíh dayi hilan Apo Jesus, ay main gintan kana ya mihay lalaki, ya pipi ya hinapatan hên narawak ya a angkahêlêk. ");
INSERT INTO sgb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Namipaplag hi Apo Jesus hên narawak ya a angkahêlêk, kabay nakahabi yay nay lalaki. Naubuh hilan nag-êpapah ya atsi bayro, ya wanla, “Bayri kantamo ha bansan Israel, ay ayn êt nakahêlêk hên êmbayri ya kapapaêpapah.” ");
INSERT INTO sgb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Noa, hilay Pariseo ay naghabi, ya pamaalíh ni Apo Jesus hên nangarawak ya hinumapat ha tawo, ay ha kapangyarihan ni Satanas, ya poon lan nangarawak ya a angkahêlêk. ");
INSERT INTO sgb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Nammita hilan Apo Jesus ha mal-at ya balayan haka baryo, ta namitoro yan Mangêd ya Habi tungkol ha pamanlokop ni Apo Namalyari ha sinagoga la, haka namaalíh yan hino-hino kay na hên ya hakit. ");
INSERT INTO sgb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Hên nahêlêk nay kal-atan, ay iningalwan na hila, gawan hadyay kairapan ya angkatanam la, haka angkahiraan hilan nakêm, ta nanad hilan tupa ya ayn pastol. ");
INSERT INTO sgb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Bayo hinabi na kanlan tagahonol na, “Hilay kal-atan ya labay hên manggilam hên tungkol kan Apo Namalyari, ay nanad pali ya nawto, ya maranin gapahên. Maialimbawa hila hên êmbayro gawan nakal-an hilay na hên maniwala. Mal-at ya gapahên, noa, u-ungnon bêngat hilay manggapah. ");
INSERT INTO sgb_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kabay ihalangin yo dayi kan Apo Namalyari, ya nag nawtoy pali, ya mamiutoh ya dayi hên kaatag êt, ya kapareho yon nanad manggapah, ta êmên hila etaman manoro hên tungkol kana.” ");
INSERT INTO sgb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Mihay allo, ay tsinipon ni Apo Jesus ya labinloway tagahonol na, ta dinyanan na hila hên kapangyarihan hên mamaalíh hên nangarawak ya a angkahêlêk ya hinumapat ha tawo, haka hên mamaalíh hên kaganawan hakit. ");
INSERT INTO sgb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Habaytsi ya langan lan labinlowa ya pinili na hên mag-in apostol na: Hi Simon, ya pinata-ngalanan nan Pedro, haka hi Andres ya kapotoh pohêl ni Pedro. Pinili na êt ya loway anak ni Zebedeo ya hi Santiago, haka ya kapotoh pohêl na, hi Juan. ");
INSERT INTO sgb_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pinili na êt hi Felipe, hi Bartolome, hi Tomas, hi Mateo ya máningil buwih, hi Tadeo, hi Santiago ya anak ni Alfeo, ");
INSERT INTO sgb_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","hi Simon ya Makabayan, haka hi Judas Iscariote ya nay-upit kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","In-utoh ni Apo Jesus ya labinloway tagahonol na hên mamitoro hên tungkol ha pamanlokop ni Apo Namalyari, haka hên mamaalíh hên hakit. Bayo hila nammita, ay hinabi na kanla, “Paan kaw manoro kanlan alwan Israelita, haka ha hinon balayan lan Samaritano. ");
INSERT INTO sgb_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Noa, ya dapat yon toroan ay hilay kapareho yon Israelita, ya nanad tupa ya nitama. ");
INSERT INTO sgb_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mita kaw na ta ipamwang yo ya Mangêd ya Habi, ya marani yanay pamanlokop ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mamaalíh kaw hên hakit, nanad ha ketong. Mamabiyay kaw oman kanlan natsi. Mamipaplag kaw hên nangarawak ya a angkahêlêk ya hinumapat kanlan tawo. Ya tungkulan ya indin ko kamoyu, ay a ko impabayad, kabay a yo ipabayad ya pamanawop yo. ");
INSERT INTO sgb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Paan kaw mantan hên hinon pera ya nanad ha ginto, o pilak, o tangso. ");
INSERT INTO sgb_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ha pammita yo ay paan kaw mantan balutan o hinon maihagili yoy takop, pag-apin bitsih, o têkên. Kaên yo ya hinon iarap la kamoyu, ta habayto ay nanad upa la kamoyu ha pamitoro yo kanla. ");
INSERT INTO sgb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ha kaganawan baryo, o balayan ya lakwên yo, ay manapol kaw bayron mapanyag kangêran ya mapagdahêlan yo. Bayro kaw tanan maglaêh angga ha a pon nayari ya pamitoro yo ha logal ya habayto. ");
INSERT INTO sgb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ha panhumwên yo ha bali, ay habiên yo, ‘Dayi ingalwan kaw ni Apo Namalyari.’ ");
INSERT INTO sgb_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","No tanggapên la kaw bayro ha bali, ta marapat-dapat na hilan ingalwan ni Apo Namalyari, ay ingalwan na hila, no ahê, ay a hila ingalwan. ");
INSERT INTO sgb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","No a la kaw tanggapên ha mihay logal, o a hila manggilam toro yo, ay bayo kaw mag-alíh bayro, ay ikampag yoy tuwapok ya atsi ha bitsih yo, ta êmên la mamwangan ya atsi tana kanla no lumatêng kanla ya parusa ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Pakagilamên yo, lano ha Allon Pamanukom ni Apo Namalyari, ay mabyat ya pamarusa kanlan taga-balayan Sodoma, haka Gomorra ya inulam ni Apo Namalyari hên hato, gawan ha hadyay kasalanan la. Noa, mas mabyat ya pamarusa kanlan habaytoy a nananggap kamoyu.” ");
INSERT INTO sgb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Hikaw ay nanad tupa ya an-iutoh kon manoro kanlan nanad ahon lalê, ya mapamatsin tupa. Kabay dapat kaw mag-in alisto, haka dapat ayn maipintas ha pamimiyay yo. ");
INSERT INTO sgb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kaillag kaw, ta gêtan la kaw kanlan toa ya nag tungkulan ha hinon sinagoga haka pagpapatokên la kaw bayro. ");
INSERT INTO sgb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Gawan ha paniwala yo kangko, ay gêtan la kaw kanlan ari haka gobernador, ha êmbayro ay maipamwang yo kanla, haka kanlan alwan Israelita, ya Mangêd ya Habi tungkol kangko. ");
INSERT INTO sgb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Uston kotangên la kaw, ay paan kaw manyagah no hino ya habiên yo, ta habayto êt, ay ipamwang kamoyu no hinoy dapat yon habiên, ");
INSERT INTO sgb_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ta ya Espiritu ni Apo Namalyari, ay mamaihip kamoyu no hinoy habiên yo. ");
INSERT INTO sgb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Hila man ya kapotoh pohêl yo, haka ya toa yo, ay may-upit kamoyu. Hilay maának ay manalanghang ha toa la hên angga ha ipapatsi la hila. ");
INSERT INTO sgb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kahêmêkan la kaw hên kal-atan, gawan ha paniwala yo kangko. Noa, no maihundo yoy paniwala yo kangko, angga ha anggaan biyay yo, agyan ampagdanas kaw hên hadyay pamairap, ay madyanan kaw hên biyay ya ayn angga. ");
INSERT INTO sgb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","No pairapan la kaw ha mihay logal, ay tumakah kaw ha kaatag ya logal. Pakagilamên yo, a yo pon maubuh hên maabutan ya balang balayan haka baryo bayri ha bansan Israel, ay mag-orong ako, ya Taga-Langit, ya In-anak Tawo. ");
INSERT INTO sgb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ayn ampag-aral ya anggalangên igit ha ampanoro kana. Ya tungkulan hên mihay ipoh, ay alwan matag-ay ha tungkulan hên amo na. ");
INSERT INTO sgb_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kabay dapat pahalamat hilay antoroan, no ampairapan hila hên nanad ha angkaranasan lan ampanoro kanla, haka dapat pahalamat hilay ipoh, no pairapan hila hên nanad ha angkaranasan lan amo la. Hiko ya nanad nag bali, haka hikaw ay nanad kalamo ko ha bali. Minusmus akon binaêg Satanas, kabay taganán lalo kaw musmusên.” ");
INSERT INTO sgb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Kabay paan kaw malimo kanlan anhumêmêk kamoyu, ta ayn intago ya a mamwangan haka mihumbung. ");
INSERT INTO sgb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ya anhabiên ko kamoyun bêngat, ay dapat yon habiên ha kal-atan. Ya an-iinanah ko kamoyu, ay dapat yon ipamwang ha kal-atan. ");
INSERT INTO sgb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Paan yon kalimwan ya labay mamatsin lawini yo, ta lawini yon bêngat ya mapatsi la. A la man maipalako ha impiyerno ya kaêlwa yo. Dapat yon kalimwan hi Apo Namalyari, ta panga-ubat nan mangwan biyay, ay main ya êt hên kapangyarihan hên mamitapon kaêlwa yo ha apoy ya taganán a maparê ha impiyerno. ");
INSERT INTO sgb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Noa, hadyay lugud ni Apo Namalyari, ta hila man ya nanaway manok lalê, ay a na ampaulayan. ");
INSERT INTO sgb_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Agyan habot ulo yo, ay muwang nay bilang. ");
INSERT INTO sgb_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kabay paan kaw malimo. A na kaw paulayan, ta maalagá kaw kanlan mal-at ya manok lalê.” ");
INSERT INTO sgb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Hilay alwan marêng-êy hên mamaptêg ha arapan hên kal-atan ya hila ay ampaniwala kangko, ay a ko etaman ikarêng-êy ha langit, ha arapan ni Apo Namalyari, ya Tatang ko. ");
INSERT INTO sgb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Noa, hilay ampaghabin ha arapan hên kal-atan, ya a hila ampaniwala kangko, ay habiên ko etaman lano ha langit, ha arapan ni Apo Namalyari, ya Tatang ko, ya a ko hila muwang.” ");
INSERT INTO sgb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Paan yon ihipên ya nantan akon pamakiúmang ha miha ta miha, ta hikoy pangubatan hên hubakan, gawan main maniwala kangko, haka main a maniwala. ");
INSERT INTO sgb_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ta hilay ampaniwala haka hilay a ampaniwala, ay alwan parehoy ihip. Ya tatang ay mihay ihip ha anak nay lalaki. Ya indo ay mihay ihip ha anak nay babayi. Ya ampo ya babayi, ay mihay ihip ha manuyang nay babayi, kabay mihalang-hangan hila. ");
INSERT INTO sgb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Haka mismon kapamilya ay mihuhubak, gawan main maniwala boy main ahê. ");
INSERT INTO sgb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Hilay manlugud ha toa la hên igit ha pamanlugud la kangko, ay alwan hêpat hên mag-in tagahonol ko. Haka hilay manlugud ha anak la hên igit ha pamanlugud la kangko, ay alwan hêpat hên mag-in tagahonol ko. ");
INSERT INTO sgb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Boy hilay alwan nakal-an hên magtêêh hên pamairap, o matsi man, gawan ha paniwala la kangko, ay alwan hêpat hên mag-in tagahonol ko. ");
INSERT INTO sgb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Hila etaman ya a anhumonol kangko, gawan a la labay hên matsi, o mangoman ya pamimiyay la, ay matsi etaman. Noa, hilay matsi gawan ha paniwala la kangko, ay dyanan biyay ya ayn angga.” ");
INSERT INTO sgb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Hilay ampananggap kamoyu, ay hiko êt ya antanggapên la. Haka hilay ampananggap kangko ay antanggapên la hi Apo Namalyari ya namiutoh kangko. ");
INSERT INTO sgb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Hilay ampananggap kanlan mámipamwang hên an-ipaihip kanla ni Apo Namalyari, gawan habaytoy mámipamwang ay in-utoh na, ay dyanan digalo ya pareho ha tanggapên lan mámipamwang hên an-ipaihip kanla ni Apo Namalyari. Haka hilay ampananggap kanlan mahonol kana, gawan hilay habayto ay mahonol kana, ay tumbahan na etaman hên kangêran ya pareho ha tanggapên lan mahonol kana. ");
INSERT INTO sgb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Hilay mam-i kamoyu hên miha man ya baso hên lanêm ya nakêbêl, gawan hikaw ay tagahonol ko, ay taganán tumbahan hila etaman ni Apo Namalyari hên kangêran.” ");
INSERT INTO sgb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Hên natoroan nay na ni Apo Jesus ya labinloway tagahonol na ha dapat lan daygên, ay nanoro ya ha balayan ya namalibot bayro, ta impamwang na ya Mangêd ya Habi. ");
INSERT INTO sgb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Hên atsi ya ha hukulan hi Juan Bautista, ay namwangan na ya tungkol ha kapapaêpapah ya andaygên ni Cristo, kabay in-utoh ni Juan ya ungno kanlan tagahonol na hên mangotáng kan Apo Jesus, ");
INSERT INTO sgb_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","no hiya ya pinili ni Apo Namalyari hên mag-in Mámiligtas, ya impangako ni Apo Namalyari, o no mangênggan hila pon hên kaatag. ");
INSERT INTO sgb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Noa, wani Apo Jesus kanla, “Mag-orong kaw kan Juan ta ipamwang yo kana ya nahêlêk yo haka nagilam yo. ");
INSERT INTO sgb_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ampakahêlêk hilay nay buwag, ampakabita hilay nay lumpo, angkaalíh ya hakit lan nag ketong, ampakagilam hilay nay têkkên, ampangoman mabiyay hilay natsi, haka ya Mangêd ya Habi ay an-ipamwang kanlan mairap. ");
INSERT INTO sgb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Iningalwan hilay a ampag-alangan ha paniwala la kangko.” ");
INSERT INTO sgb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Hên nakabitay nay in-utoh ni Juan, ay namipamwang hi Apo Jesus hên tungkol kan Juan kanlan kal-atan, ya wana, “Hinoy nilako yo ha logal ya kabalah-balahan? Êndat yo no ya ihip ni Juan ay nanad tsimbo, ya mantêwêg ya angkadanan angin? ");
INSERT INTO sgb_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Hino awud ya nilako yo? Yarin nilako yo ya mihay nakatakop hên mangahampat! Alwa! Hilay nakatakop hên mangahampat, ay mahêlêk ha balin ari. ");
INSERT INTO sgb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Hino awud ya nilako yo? Ya mihay propeta? Awo. Pakagilamên yo! Hiyay mihay mámipamwang hên an-ipaihip kana ni Apo Namalyari, ya ayn kapantag. ");
INSERT INTO sgb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Gawan tungkol kan Juan Bautista ya hata nakahulat di ha habi ni Apo Namalyari, ya wana, ‘Mangiutoh ako hên muna kamo ya mangil-an hên danan mo.’ ");
INSERT INTO sgb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Anhabiên ko kamoyu, ha kaganawan tawo, ayn matag-ay kan Juan Bautista. Êmbayro man, ya pinakamaaypa ya nakapakilamo ha pamanlokop ni Apo Namalyari, ay matag-ay kan Juan. ");
INSERT INTO sgb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Paubat hên ampanoro ya hi Juan anggan amêhên, ay main ampaypilit hên tampol hên mangiaral hên Mangangêd ya Habi ya tungkol ha pamanlokop ni Apo Namalyari, haka mal-at ya ampamilit hên tampol palokop kana. ");
INSERT INTO sgb_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Gawan ya impamwang lan mámipamwang, hên an-ipaihip kanla ni Apo Namalyari, haka ya impamwang lan Kautuhan ya indin na kan apo Moises, ay tungkol ha pamanlokop ni Apo Namalyari. Haka hi Juan Bautista ya nag-umpisa hên nanupad hên habaytoy impamwang la. ");
INSERT INTO sgb_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","No ampaniwala kaw ha pamwang hên mihay mámipamwang hên hato, hên impaihip kana ni Apo Namalyari, ay maintindihan yo ya hi Juan Bautista, ya nanupad hên habaytoy papêt na, ya main nanad kan Propeta Elias ya lumatêng. ");
INSERT INTO sgb_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Pakaihipên yo ya nagilam yo!” ");
INSERT INTO sgb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Hinabi nay na êt ni Apo Jesus, ya wana, “Hino awud ya pangiparisan ko kanlan tawo amêhên? Nanad hino hila kaya? Nanad hilan anak ya ampipammikno ha pangalindagan hên ampibabaêg, ya wanla, ");
INSERT INTO sgb_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nanigtsig kay, noa, a kaw tsimmalêk. Nanyêngên kay, noa, a kaw nakiyêngên.’ ");
INSERT INTO sgb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ta nilumatêng hi Juan Bautista hên panay hên ampagtêêh hên a ampangan, ta êmên a maabala ya panalangin na, haka a ya ampinêm hên alak, noa gawan habayto, ay anhabiên yo, ya hiyay hinapatan hên narawak ya a angkahêlêk. ");
INSERT INTO sgb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Hiko etaman, ya Taga-Langit, ya In-anak Tawo, ay nilumatêng di hên ampangan haka ampinêm alak hên kalamo yo, noa gawan habayto, anhabiên yo ya hikoy mahiba, mamminêm hên alak, kaluguran lan máningil buwih, haka kaatag ya mapanyag kasalanan. Êmbayro man, ay mapaptêgan ya pêtêg ya toro naên ni Juan Bautista, gawan habaytoy mahêlêk ha pamimiyay lan anhumonol ha toro naên.” ");
INSERT INTO sgb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Hinabyanan ni Apo Jesus hilay a êt nipaghêhê hên nanalibokot ha pamanyag lan kasalanan, mal-at man ya kapapaêpapah ya dinyag na ha balayan la, ya wana, ");
INSERT INTO sgb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Kaingalo kaw ya taga-balayan Corazin haka taga-balayan Betsaida, gawan a yo paghêhêan hên talibatokan ya pamanyag yon kasalanan, agyan mal-at ya kapapaêpapah ya dinyag ko bahên. Mabyat ya kasalanan lan taga-balayan Tiro haka taga-balayan Sidon. Noa, no nadyag dayi kanla, ya kapapaêpapah ya dinyag ko bahên ha Corazin, haka Betsaida, ay tampol la dayi bayton impahlêk ha dyag la ya pinaghêhêan hên tinalibatokan la ya pamanyag lan kasalanan hên taga-Tiro haka Sidon. ");
INSERT INTO sgb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pakagilamên yo! Lumatêng lano ya allon pamipapawa ni Apo Namalyari hilay nagpalokop kana, ha a nagpalokop kana, ay mas mabyat ya pamarusa kamoyun taga-Corazin haka Betsaida kanan pamarusa kanlan taga-Tiro haka Sidon. ");
INSERT INTO sgb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Hikaw êt, ya taga-balayan Capernaum, êndat yo no mipalako kaw ha langit hên mananggap papuri, noa, ihamwag kaw ha impiyerno. Mabyat ya kasalanan lan taga-balayan Sodoma, noa, no nadyag na dayi kanla ni Apo Namalyari ya kapapaêpapah ya dinyag ko bahên ha Capernaum, ay nabuyot lay na dayin pinaghêhêan ya kasalanan la, haka a dayin nahira ya balayan la. ");
INSERT INTO sgb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Noa, pakagilamên yo, ha Allon Pamanukom, ay mas mabyat ya pamarusa kamoyun taga-Capernaum, kanan pamarusa kanlan taga-Sodoma.” ");
INSERT INTO sgb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Hên habayto êt, ay nanalangin ya hi Apo Jesus kan Apo Namalyari hên êmên di, “Tatang ko ha langit, ampuriên kata, ya ampamaala ha langit haka luta, gawan impamwang mo ya tungkol kangko kanlan maaypa ya nakêm, ya a mo impamwang kanlan manga-talino ya matag-ay ya pinag-aralan haka matag-ay ya nakêm. ");
INSERT INTO sgb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Awo, Tatang, ta habaytoy kalabayan mo.” ");
INSERT INTO sgb_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Bayo wani ni Apo Jesus kanlan kal-atan, “In-ubuh nan impamwang kangko hên Tatang ko, hi Apo Namalyari ya tungkol kana. Ayn taganán makakilala kangko, ya Anak na, no alwan hiyan bêngat ya Tatang ko. Ayn êt taganá hên makakilala kanan Tatang ko, no alwan hikon bêngat, ya Anak na, haka hilay piliên ko hên ipamukat hên tungkol kana. ");
INSERT INTO sgb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Paidani kaw kangko, ya hikaw ya angkabyatan ya nakêm ha pamangihip yo, ta dyanan kataw hên kapatêkbêkan nakêm. ");
INSERT INTO sgb_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Honolên yoy an-iutoh ko kamoyu, ta hiko ay maaypa ya nakêm haka maamêy ya pamanoro ko, kabay mag-in mapatêkbêk ya nakêm yo. ");
INSERT INTO sgb_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Gawan naêpaw ya an-ipadyag ko kamoyu ha pamanoro ko kamoyu.” ");
INSERT INTO sgb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mihay allon pamagsimba lan Israelita, hên nipadann hilan Apo Jesus ha nag trigo ha narani ha dann, ay nantê hilay tagahonol na hên pêrad. Niyêhê la ya hata trigo, ta nilêêm la ha pammita la, gawan anlonohên hila. ");
INSERT INTO sgb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Noa, nag Pariseo bayro ya naghabi kan Apo Jesus, ya wanla, “Hêlkên mo! Pata nantê hilay tagahonol mo hên trigo ha allon pamagsimba, bawal man ya habayto ha Kautuhan tamo?” ");
INSERT INTO sgb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Wana etaman ni Apo Jesus, “Kayno a yo pon nabaha ya dinyag ni Arin David hên hiya haka hilay kalamo na, ay angkablay hên lonoh. ");
INSERT INTO sgb_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Hinumwên ya ha bali ni Apo Namalyari, ta nangwa yan puto ya imparaêp kan Apo Namalyari ya pangkaên lan bat hên pari. Bawal man ha Kautuhan ni apo Moises hên mangan hên habayto, ay nangan ya, haka hilay kalamo na. ");
INSERT INTO sgb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kayno a yo pon nabaha ya Kautuhan ni apo Moises, ya ha allo man hên pamagsimba, ay andaygên lan pari ya dapat lan daygên ha Templo. Noa, alwan kasalanan ya habayto, ta mal-at ya dapat lan daygên ha Templo ha allon pamagsimba. ");
INSERT INTO sgb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pakagilamên yo, ya main di ya mas maalagá ha Templo. ");
INSERT INTO sgb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","No naintindihan yo dayi ya hata Kahulatan, ‘A ko labay ya mamiátang kaw. Ya labay ko ay mag-in kaw hên maingaloên,’ ay a yo dayin intad mapanyag kasalanan, ya ayn kasalanan. ");
INSERT INTO sgb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Gawan hiko ya Taga-Langit, ya In-anak Tawo, ay nag tungkulan hên maghabi no hinoy malyarin daygên ha allon pamagsimba.” ");
INSERT INTO sgb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nammita hi Apo Jesus ta hinumwên ya ha sinagoga ta manoro. ");
INSERT INTO sgb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Main lalaki bayro ya natsi ya gamêt. An-imatonan la ya hi Apo Jesus hên ungnoy lalaki, no mamaalíh yan hakit ha allon pamagsimba la, ta êmên la yan bad-an hên ampanyag yan bawal ha Kautuhan. Nangotang hila kana, “Bawal ha Kautuhan ni apo Moises ya mamaalíh hên hakit ha allon pamagsimba, o ahê?” ");
INSERT INTO sgb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Amêhên, hinabi ni Apo Jesus kanla, “No alimbawa ta mimihay tupa yo, haka habaytoy manabo ha malalê ya pangahoyan, a yo ya warin tampol hên iawah allo man hên pamagsimba? ");
INSERT INTO sgb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mas maalagá ya tawo ha tupa! Kabay alwan bawal ha Kautuhan ni apo Moises hên manyag kangêran ha allon pamagsimba.” ");
INSERT INTO sgb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Bayo wana kanan lalaki ya natsi ya mihay gamêt, “Ipaktang moy gamêt mo.” Kaban an-ipaktang na ya, ay naalíh ya hakit ha gamêt na, ta hatoy gamêt na ay nag-in nanad ha kapaka ya ayn hakit. ");
INSERT INTO sgb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kabay nammita hilay nay Pariseo, ta pinipupulungan lay na hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Hên namwangan ni Apo Jesus ya pamulong kana, ay nag-alíh ya bayro. Kal-atan ya nakihonol kana, haka namaalíh yan kaganawan hakit lan nipaghakit. ");
INSERT INTO sgb_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Binawal na hila hên ipamwang ya tungkol kana. ");
INSERT INTO sgb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Habaytoy nalyari ta êmên matupad ya impamwang ni Propeta Isaias, ya wana, ");
INSERT INTO sgb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Atsi di ya pinili kon tagahuyo ko, ya anlugurên ko, ya ikahigla ko. Ipahapat ko kana ya Espiritu ko, ta êmên na ipamwang ha tawo ha balang bansa, no ay-êmên hila mag-in ayn kapintasan ha hêlêk ko. ");
INSERT INTO sgb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","A ya makihubakan, haka makiangawan. Naamêy yan mag-habi ha dann. ");
INSERT INTO sgb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Hawpan na hilay alwan makhaw ya lawini, haka hilay alwan nakataniêh ha paniwala. Daygên nay habayto angga ha mabalayan la ya kaligtasan ya an-idin na. ");
INSERT INTO sgb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Habaytoy kaligtasan ya an-êngganan lan tawo ha balang bansa kana.” ");
INSERT INTO sgb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Bayo main gintan kan Apo Jesus ya mihay lalaki ya buwag haka pipi ya hinapatan hên narawak ya a angkahêlêk. Namipaplag hi Apo Jesus hên habaytoy narawak ya a angkahêlêk, kabay nakahabi, haka nakahêlêk yay nay lalaki. ");
INSERT INTO sgb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Naubuh hilan nag-êpapah ya kal-atan ya atsi bayro, ya wanla, “Habaytsi ya lawêh ya kaapo-apoan ni Arin David ya impangako kantamo ni Apo Namalyari!” ");
INSERT INTO sgb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Noa, pahabtan lan Pariseo, ya pamaalíh ni Apo Jesus hên nangarawak ya hinumapat ha tawo, ay ha kapangyarihan ni Satanas, ya poon lan nangarawak ya a angkahêlêk. ");
INSERT INTO sgb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Muwang ni Apo Jesus ya laman ihip la, ya êndat la no ubat kan Satanas ya kapangyarihan na. Kabay hinabi na, “No alimbawa ta mipapatsi ya angkalokopan hên mihay bansa, o balayan ay mahira ya habayto. Êmbayro êt ya malyari ha mipapamilya ya mipapatsi. ");
INSERT INTO sgb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","No mamipaplag hi Satanas hên sarili na, ay mahira bayto ya pamanlokop na. ");
INSERT INTO sgb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","No ampamipaplag akon nangarawak ya a angkahêlêk ha kapangyarihan ni Satanas, hino bayto ya nam-i hên kapangyarihan kanlan tagahonol yo, ya ampamipaplag hên nangarawak ya a angkahêlêk? Hila tana êt ya mamaptêg ya mali kaw. ");
INSERT INTO sgb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ha kapangyarihan nan Espiritu ni Apo Namalyari ya pamaalíh ko hên nangarawak ya a angkahêlêk. Ya labay habiên hên habayto, ay atsi kamoyu ya pamanlokop ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Hi Satanas ay nanad ha mihay makhaw, ya mal-at ya almas, ya ampamantay ha bali na. A makwa, ya hinon atsi kana, no a ya pon hambutên, haka gapohên. Noa, no gapohên ko ya, ay makwa ya kaganawan ya atsi kana. ");
INSERT INTO sgb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Hilay ayn pon ha lokop ko, ay kapatsi ko. Haka hilay a ampanawop hên manipon hên tawo, ta êmên hila makilamo kangko, ay ampamidayo hên tawo kangko. ");
INSERT INTO sgb_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Pakagilamên yoy habaytsi. Mapatawad hilay mipaghêhê ha nadyag lay kasalanan, haka ha hinabi lan pamaniran kapareho lan tawo, noa, ayn hinoman ya mapatawad ha hinabi lan pamaniran Espiritu ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Hilay maghabi hên halanghang kangko, ya Taga-Langit, ya In-anak Tawo, ay mapatawad. Noa, hilay maghabi hên halanghang ha Espiritu ni Apo Namalyari, ay a mapatawad. Ta habaytoy kasalanan, ay taganán ayn kapatawaran.” ");
INSERT INTO sgb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“No habiên tamoy mangêd ya mihay kayo, ay mangêd etaman ya tagêy na. No habiên tamon alwan mangêd ya mihay kayo, ay alwa etaman mangêd ya tagêy na. Ta hilay kayo ay angkabalayan ha tagêy la. ");
INSERT INTO sgb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nanad kaw utan ya makamatsi! A yon mahabi ya hinoman ya mangêd, gawan ha karawakan yo! Ta ya laman nakêm ay an-umawah ha bêbêy. ");
INSERT INTO sgb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Hilay mangangêd ay mapanyag hên kangêran, gawan mangêd ya nakêm la. Hilay nangarawak ay mapanyag hên karawakan, gawan narawak ya nakêm la. ");
INSERT INTO sgb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Pakagilamên yo, ha Allon Pamanukom, ay dapat yon ipamulah kan Apo Namalyari no awta hinabi yo ya balang hinabi yo ya ayn kapukatan. ");
INSERT INTO sgb_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Parusaan na kaw no alwan mangêd ya hinabi yo, haka a na kaw parusaan no mangêd ya hinabi yo.” ");
INSERT INTO sgb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Main Pariseo haka mánoron Kautuhan ni apo Moises ya labay manubuk kan Apo Jesus, ya mamipahlêk yan palatandaan ya ubat ha langit, ta êmên la mamwangan no pêtêg hên atsi kana ya kapangyarihan ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Noa, wani Apo Jesus kanla, “Bapan dawak hilay tawo amêhên. Ampanapol hilan kapapaêpapah ya palatandaan ya ubat ha langit. Noa, ayn ipahlêk kanla, no alwan nanad ha kapapaêpapah ya nalyari kan Propeta Jonas hên haton lagi. ");
INSERT INTO sgb_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","No ay-êmên hi Propeta Jonas ha tatloy allo haka tatloy yabi, ha bitokan kahlayan pating, ay êmên bayro êt, ay hiko, ya Taga-Langit, ya In-anak Tawo, ay tatloy allo haka tatloy yabi ko ha pinay-ilbêngan kangko. ");
INSERT INTO sgb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ha Allon Pamanukom ni Apo Namalyari, ay mirêng hilay biniyay oman, ya taga-Ninive, ya nipaghêhên pamanyag kasalanan la, hên nagilam lay toro ni Propeta Jonas, ta habyanan la kaw, gawan main di ya matag-ay ya tungkulan kan Propeta Jonas, yan a kaw naghêhên nanalibokot ha pamanyag yon kasalanan. ");
INSERT INTO sgb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ha Allon Pamanukom ni Apo Namalyari, ay habyanan na kaw hên Reyna ha Sheba hên haton lagi. Mipakarêng-êy kaw, ta agyan bapan dayo na, ay nilako na hi Arin Solomon, ta labay nan gilamên ya toro na. Amêhên, ay main di, ya mas matag-ay ya tungkulan kan Arin Solomon, noa, a kaw ampanggilam. ");
INSERT INTO sgb_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“No umalih ha mihay tawo ya narawak ya a angkahêlêk, ya hinumapat kana, ay tawak-tawakên nay namala ya luta, ta manapol yan mapagpatêkbêkan na. Noa, ayn yan matapol. ");
INSERT INTO sgb_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Kabay wana ha nakêm na, ‘Mag-orong ko ha tawo ya ubatan ko.’ Pag-orong na, ay malatêng nay ubatan na, ya ayn êt napahili kana, haka habaytoy tawo ay nanad yan bali ya malinis, haka nakakumpini, ya nakal-an hên togêlan. ");
INSERT INTO sgb_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kabay managyat yan pitoy a angkahêlêk ya narawak êt kana, ta paglamo na bayro. Haka humwên hila, kabay lalo yay nan kaingalo ya hatoy tawoy inorongan na. Êmbayro êt ya malyari kamoyu ya nakagilam hên Mangêd ya Habi, noa, a kaw naghêhên nanalibokot kasalanan yo.” ");
INSERT INTO sgb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Kaban ampaghabi ya pon hi Apo Jesus ha kal-atan, ay nilumatêng ya indo na, haka hilay patêl na, ta labay la yan makahabi. ");
INSERT INTO sgb_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Main naghabi kana, ya wana, “Atsi di ha ilwangan ya indo mo haka hilay patêl mo. Labay la kan makahabi.” ");
INSERT INTO sgb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Wani Apo Jesus kana, “Hino ya indo ko, haka hino hilay patêl ko?” ");
INSERT INTO sgb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Intoro nay tagahonol na, ta wana, “Hilay habaytsi ya anlugurên ko hên nanad ha pamanlugud ko ha indo ko, haka hilay patêl ko. ");
INSERT INTO sgb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Hilay manyag kalabayan ni Apo Namalyari, ya Tatang ko ha langit, ay yabay ya anlugurên ko hên nanad ha pamanlugud ko ha indo ko, haka hilay patêl ko.” ");
INSERT INTO sgb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Habayto êt hên allo, ay inumawah hilan Apo Jesus ha bali, ta nikno ya ha laylay lanêm hên nanoro kanla. ");
INSERT INTO sgb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Gawan ha hadyay kal-atan ya ampipagtsipon hên labay manggilam toro na, ay hinumakay ya ha mihay bangka, ta bayro yan nikno hên nanoro kanlan kal-atan ya atsi ha laylay hên lanêm. ");
INSERT INTO sgb_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ha pamanoro na kanla, ay mal-at ya paalimbawa, ya wana, “Main mihay lalaki ya namihabwag hên bini. ");
INSERT INTO sgb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ha pamihabwag nan bini, ay main bini ya natata ha dann. Habaytoy tinuktuk hên manok. ");
INSERT INTO sgb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ya kaatag ay natata ha mabato. Tampol yan tinumubo, gawan ha mababo ya luta. ");
INSERT INTO sgb_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Noa, hên nangallo, ay nayanto ya, gawan a nipakalalê ya yamot. ");
INSERT INTO sgb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ya kaatag ay natata ha kadiwian. Tinumubo ya bini, noa, tinumêytêy, gawan diwi. ");
INSERT INTO sgb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ya kaatag ay natata ha mataba ya luta. Tinumubo ya habaytoy bini haka naubuh hên nanagêy, hên main manimagatoh ya lahí, anêmapo, haka tatlumpo.” ");
INSERT INTO sgb_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Hên nahabi nay habayto ni Apo Jesus, ay wana êt, “Pakaihipên yo ya nagilam yo!” ");
INSERT INTO sgb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Dinumani kan Apo Jesus hilay tagahonol na ta nangotang hila, ya wanla, “Pata panay paalimbawa ya pamanoro mo kanlan kal-atan?” ");
INSERT INTO sgb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Kabay wani Apo Jesus kanla, “Hikaw bat ya makamwang hên inlihim ya tungkol ha pamanlokop ni Apo Namalyari, noa, a na impamwang ya habayto ha kaatag. ");
INSERT INTO sgb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","No honolên yoy toro ko, ay mapahanan ya pamangintindi yo, noa, no a yon honolên, ay alihên êt kamoyu ya pêpêrad ya naintindihan yo. ");
INSERT INTO sgb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kabay an-idann ko ha alimbawa ya pamanoro ko kanla, ta ‘Manlêk hila man, ay a la mamwangan ya anhêlkên la. Magilam la man, ay a hila manggilam, haka a la angkaintindihan ya angkagilaman la.’ ");
INSERT INTO sgb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Angkatupad kanla ya impamwang ni Propeta Isaias, ya wana hên hato, ‘Pakagilamên yo man, ay a yo maintindihan, haka pakahêlkên yo man, ay a yo mamwangan ya anhêlkên yo. ");
INSERT INTO sgb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","A hila malyarin maniwala gawan kinumdêy ya ulo la. Ampagtêtêkk hila, haka an-ipêrêng lay mata la. Ta kayno maintindihan la, haka maghêhê hilan dumani kangko, bayo patawarên ko hila.’ ");
INSERT INTO sgb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Noa, hikaw, ay iningalwan, kabay angkaintindihan yo ya angkakit yoy andaygên ko, haka angkaintindihan yoy anhabiên ko. ");
INSERT INTO sgb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Hên hato, ay mal-at ya mámipamwang hên an-ipaihip kanla ni Apo Namalyari, haka kaatag pon ya mahonol kana, ya labay-labay dayi hên makahêlêk hên angkakit yo ya andaygên ko. Labay-labay la dayin magilaman ya anhabiên ko ya angkagilaman yo. Noa, a la nahêlêk ya angkakit yo, haka a la êt nagilam ya angkagilaman yo.” ");
INSERT INTO sgb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Gilamên yoy habaytsi ya labay habiên hên alimbawa ya tungkol ha bini. ");
INSERT INTO sgb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ya bini ay habi ni Apo Namalyari hên tungkol ha pamanlokop na. Ya nakêm tawo ay in-alimbawa ha natataan bini. Ya bini ya natata ha dann ay habi ni Apo Namalyari ya nagilam lan tawo, noa, a la naintindihan, bayo tampol nilumatêng hi Satanas, ta inalíh nay habaytoy habi ha nakêm la. ");
INSERT INTO sgb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ya bini ya natata ha kabatoan, ay habi ni Apo Namalyari ya nagilam haka tinanggap lan tawo hên main kahiglaan, ");
INSERT INTO sgb_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","noa, a nimana ha nakêm la. Naniwala hila pon, noa, hên nilumatêng ya kairapan o ya pamairap, ay tampol naalíh ya paniwala la. ");
INSERT INTO sgb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ya bini ya natata ha kadiwian ay habi ni Apo Namalyari ya ginilam lan tawo, noa, tampol nialíh ha nakêm la, gawan kayagahan, pibandian, haka katsighaw hên biyay. Kabay a nabayo ya biyay la, hên nanad ha a nanagêy ya bini. ");
INSERT INTO sgb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ya bini ya inhabwag ha mataba ya luta ay habi ni Apo Namalyari ya nagilam haka naintindihan lan tawo, bayo nimana ha nakêm la, ya nanad ha lahí ya naubuh hên nanagêy hên main manimagatoh ya lahí, anêmapo, haka tatlumpo.” ");
INSERT INTO sgb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Impamwang kanla ni Apo Jesus ya miha pon ya alimbawa, ya wana, “Ya pamanlokop ni Apo Namalyari ay maialimbawa ya êmên di: Main mihay lalaki ya namiêhad hên mangêd ya bini hên trigo. ");
INSERT INTO sgb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Noa, hên mihay yabi, hên angkabêlêw hilangan, ay nilumatêng ya kapatsi na hên namihabwag hên tagêy hên lamon ha pinay-êharan trigo, bayo nammita yay na. ");
INSERT INTO sgb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tinumuboy trigo haka nakisabay hên tinumuboy lamon. Hên nanagêy ya trigo, ay napansin lan tagahuyo nan lalaki ya lamon. ");
INSERT INTO sgb_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kabay dinumani hila kana, ta wanla, ‘Êndat naên ya mangêd ya binin trigo ya in-êhad. Ay-irin ubat ya hata lamon?’ ");
INSERT INTO sgb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Hinabi nan lalaki, ya wana, ‘Main kapatsi ya namihabwag hên tagêy hên lamon bayri.’ Kabay nangotang hilay tagahuyo na, ‘Labay mon lamonên naên ya?’ ");
INSERT INTO sgb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Noa, wanan lalaki, ‘Paan pon. Ta no lamonên yo, ay maulot yoy trigo etaman. ");
INSERT INTO sgb_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Paulayan yoy na hên makisabay, hên angga ha panggapah. No panaon hên panggapah, ay habiên ko tana ha manggapah ya unaên la pon alihên ya lamon, haka la pêpêthên ta ulamên. Bayo gapahên ya trigo ta ihimpan.’” ");
INSERT INTO sgb_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Namitoro hi Apo Jesus hên miha pon ya alimbawa, ya wana kanla, “Ya pamanlokop ni Apo Namalyari ay maialimbawa ha pamantumubo hên mihay nanaway but-o ya intanêm. ");
INSERT INTO sgb_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Iibon man ya but-o, ay hinumlay yan nag-in kayo, kabay nipanyag halay ya manok-lalê ha hanga na.” ");
INSERT INTO sgb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Namitoro hi Apo Jesus hên miha pon ya alimbawa, ya wana kanla, “Ya pamanlokop ni Apo Namalyari ay maialimbawa ha pampaalsa ya pinakigawgaw hên mihay babayi ha kal-atan hên arina, haka nilum-at ya habaytoy kal-atan.” ");
INSERT INTO sgb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Hên nanoro hi Apo Jesus kanlan kal-atan, ay panay main hên alimbawa ha panoro na. ");
INSERT INTO sgb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Êmbayroy panoro na ta êmên matupad ya impamwang nan mihay mámipamwang hên impaihip kana ni Apo Namalyari, ya wana, “Ya panoro ko kanla ay paalimbawa. Ipamwang ko ya inlihim paubat hên dinyag ya hata luta.” ");
INSERT INTO sgb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Amêhên, imbalag ni Apo Jesus ya kal-atan, ta hinumwên ya ha bali. Haka dinumani kana ya tagahonol na, ta wanla, “Ipamulah mo kannaên ya alimbawa ya tungkol ha lamon ha trigo ya in-êhad.” ");
INSERT INTO sgb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Hinabi na etaman, ya wana, “Hiko, ya Taga-Langit, ya In-anak Tawo, ay in-alimbawa ha namiêhad hên mangêd ya bini hên trigo. ");
INSERT INTO sgb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ya in-alimbawa ha pinay-êharan ay boon luta, haka ya in-alimbawa ha mangêd ya bini hên trigo, ay hilay palokop kan Apo Namalyari. Ya in-alimbawa ha lamon, ay hilay angkalokopan ni Satanas, ");
INSERT INTO sgb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","haka ya in-alimbawa ha namihabwag tagêy lamon, ay hi Satanas. Ya in-alimbawa ha panggapah, ay yabay ya kaanggaan hên hata luta, haka ya in-alimbawa ha manggapah, ay hilay anghel ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","No ay-êmên tsinipon ya hatoy lamon, bayo inulam, ay êmbayro etaman ha anggaan hên hata luta. ");
INSERT INTO sgb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Gawan hiko, ya Taga-Langit, ya In-anak Tawo, ay mamiutoh hên anghel ko ha boon pamanlokop ko, ta tsiponên lay balang ampangubatan kasalanan, haka hilay mapanyag karawakan, ");
INSERT INTO sgb_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ta ihamwag hila ha apoy ya a angkaparê. Hadyay tangih la bayro, haka mipang-ngê-ngêt hila ha hadyay huluk la, boy ha hadyay ilab ya angkatanam la. ");
INSERT INTO sgb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Noa, hilay mahonol kana, ay mag-in nanad allo ya ampam-in hawang ha pamanlokop ni Apo Namalyari ya Tatang la. Pakaihipên yo ya nagilam yo.” ");
INSERT INTO sgb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Inhundo ni Apo Jesus ya panoro na, ya wana, “Ya pamanlokop ni Apo Namalyari ay maialimbawa ha maalagáy pibandian ya ayn kapantag, ya nakali ha lutan kaatag, bayo hinapolan oman. Ha hadyay kahiglaan nan nakatapol, ay nuli ya, ta in-ubuh nan inhaliw ya atsi kana, ta hinaliw nay habaytoy luta ya nag maalagáy pibandian ya ayn kapantag.” ");
INSERT INTO sgb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Inhundo ni Apo Jesus ya panoro na, ya wana, “Ya pamanlokop ni Apo Namalyari ay maialimbawa êt ha mihay mangalakal ya ampanapol hên maalagáy perlas. ");
INSERT INTO sgb_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Hên nakahêlêk yan mihay perlas ya hadyay maalagá, ay in-ubuh nan inhaliw ya atsi kana, ta hinaliw nay habaytoy hadyay maalagáy perlas.” ");
INSERT INTO sgb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Inhundo ni Apo Jesus ya panoro na, ya wana, “Ya pamanlokop ni Apo Namalyari ay maialimbawa êt ha lambat ya inhamwag ha dagat, ya nakakwa hên hino-hino kay na hên ya kênan lanêm. ");
INSERT INTO sgb_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Hên napno ya habayto, ay ginuloy la ha laylay, ta nikno hilan impapawa ya habaytoy makêna haka a makêna. Bayo la intapon ya a makêna. ");
INSERT INTO sgb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Êmbayro etaman ha anggaan hên hata luta. Ipapawa lan anghel, hilay mapanyag karawakan kanlan mahonol kan Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Hilay mapanyag karawakan, ay ihamwag ha impiyerno ya hadyay apoy ya a angkaparê. Hadyay tangih la bayro, haka mipang-ngê-ngêt hila ha hadyay huluk la, boy ha hadyay ilab ya angkatanam la.” ");
INSERT INTO sgb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Kinotang ni Apo Jesus hilay tagahonol na hên tungkol ha intoro na kanla, ya wana, “Naintindihan yoy habayto?” Wanla etaman, “Awo. Angkaintindihan naên.” ");
INSERT INTO sgb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Wanay na êt ni Apo Jesus, “Kabay maintindihan yo etaman ya habaytsi: hilay mánoron Kautuhan ni apo Moises ya ampaniwala ha an-itoro ko ya tungkol ha pamanlokop ni Apo Namalyari, ay maialimbawa ha mihay main bali, ya tampol hên maiawah ha dyanan pibandian na ya mana haka ya bayo. Gawan pareho lan maitoro ya manan toro haka ya bayon toro.” ");
INSERT INTO sgb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Hên naitoro nay na ya habaytoy alimbawa, ay nag-alíh yay na bayro. ");
INSERT INTO sgb_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Hên nilumatêng ya ha Nazaret, ya balayan ya pinanhumlayan na, ay hinumwên ya ha sinagoga la, ta nanoro ya. Haka ha pamanoro na, ay nipag-êpapah hilay nakagilam, ya wanla, “Ay-iri nan nakwa ya kamwangan na boy ya kapangyarihan na hên manyag hên kapapaêpapah?” ");
INSERT INTO sgb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","“Daptay hiyay anak ni Jose, ya kalpintero, ya kabalayan tamo. Yarin alwan Maria ya langan hên indo na! Yarin alwan hiyay patêl lan Santiago, Jose, Judas, haka hi Simon! ");
INSERT INTO sgb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Yarin alwan kabalayan tamo ya patêl nay babayi! Ay-iri nan nakwa ya kamwangan na, haka kapangyarihan nan manyag hên kapapaêpapah?” ");
INSERT INTO sgb_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kabay a la ya tinanggap. Noa, wani Apo Jesus kanla, “Hilay propeta ni Apo Namalyari, ay anggalangên ha agyan ayri ya logal, noa, a hila ampansinên hên kamag-anak la haka kabalayan la.” ");
INSERT INTO sgb_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Gawan ayn hilan paniwala kana, ay pêrad bat ya kapapaêpapah ya dinyag na bayro. ");
INSERT INTO sgb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Hên habayto, ya tungkol ha andaygên lan Apo Jesus ay nagilam ni Herodes Antipas, ya ampamaala ha probinsyan Galilea. ");
INSERT INTO sgb_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Kabay wana kanlan ampag-obra ha bali na, “Ya ambaêgên lan Jesus, ay taganán hi Juan Bautista ya impapotoh kinay ulo, ya nabiyay oman, kabay ampakadyag yan kapapaêpapah!” ");
INSERT INTO sgb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Hinabi nay habayto gawan hiyay naypadakêp, naypagapoh, haka naypahukul kan Juan Bautista gawan bat kan Herodias. Habaytsi hi Herodias, ay ahawa ni Felipe, ya ali ni Herodes Antipas, ya bat nan pinag-ahawa ni Herodes Antipas. ");
INSERT INTO sgb_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Panay nan an-ungkatên kan Herodes Antipas, ni Juan Bautista, ya wana, “Bawal ha Kautuhan ya pamag-ahawa mo kan Herodias, ya ahawan ali mo!” ");
INSERT INTO sgb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Kabay labay na dayi ni Herodes Antipas hên ipapatsi hi Juan Bautista, noa, malimo ya kanlan kal-atan, gawan ha muwang la, hi Juan ay mihay propeta ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ha kaluto, ha allon pamanêmtêm ha pay-anak kan Herodes Antipas, ay timmalêk ya anak ni Herodias ha arapan kal-atan. Haka hinumigla hi Herodes Antipas ha pamagtalêk nan dalaga, ");
INSERT INTO sgb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","kabay impangako na kana, hên main kalamoy humpa, ya idin na kana ya hinon pakikwaan na. ");
INSERT INTO sgb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Gawan ha hinabi kana hên indo na, ay pinakikwaan nan dalaga ya ipapotoh ni Herodes Antipas ya ulo ni Juan Bautista, ta idin kanan dalaga ya habayto, hên nakapalunto ha pinggan. ");
INSERT INTO sgb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Hadyay lungkot ni Herodes Antipas hên pakikwaan kana hên dalaga ya habayto, noa, a nay na mapag-agkoan, gawan naghumpa ya, haka gawan ha kal-atan ya hinagyat na ha kaluto. Hên habayto êt, ay in-utoh nay mihay hundaloh ha hukulan hên potohên nay ulo ni Juan Bautista. ");
INSERT INTO sgb_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tampol yan nammita ya in-utoh na ha hukulan, ta pinotoh nay ulo ni Juan, haka ");
INSERT INTO sgb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","na impalunto ya ulo ha pinggan, ta indin kanan dalaga, bayo indin nan dalaga ha indo na. ");
INSERT INTO sgb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Hên namwangan lan tagahonol ni Juan ya nalyari kana, ay kingwa la ya bangkay na, haka lay na in-ilbêng. Bayo impamwang la kan Apo Jesus ya nalyari. ");
INSERT INTO sgb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Hên nagilam lan Apo Jesus ya nalyari kan Juan Bautista, ay nagbangka hilan palipay ha logal ya kabalah-balahan. Noa, hên namwangan lan kal-atan ya pagpalakwan lan Apo Jesus, ay binitsih lan inunaan hilan Apo Jesus, hên kalamo hilay ubat ha kaganawan balayan ya dinanan la. ");
INSERT INTO sgb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Hên pataoy hilan Apo Jesus ha bangka, ay nahêlêk lay kal-atan. Naingalwan na hila, ni Apo Jesus, haka namaalíh yan hakit lan nipaghakit ya gintan la. ");
INSERT INTO sgb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Hên maranin matata ya allo ay dinumani kana ya labinlowa hên naghabi kana, ya wanla, “Ayn bali di, haka maranin matata ya allo. Dayi ipalako mo hilay kal-atan ha balang baryo, ya narani di, ta êmên hila makatsikap hên maêkan la.” ");
INSERT INTO sgb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Noa, hinabi na kanla, ya wana, “A la kailangan hên mita. Hikaw tanay mam-i kanla hên maêkan la.” ");
INSERT INTO sgb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Hinabi la etaman, “Main kitamon bêngat hên limay puto haka loway kênan lanêm.” ");
INSERT INTO sgb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Wana kanla ni Apo Jesus, “Gêtan yo di kangko ya habayto.” ");
INSERT INTO sgb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Amêhên, pinaikno ni Apo Jesus ya kal-atan ha pagpastolan bayro. Kingwa ni Apo Jesus ya limay puto haka loway kênan lanêm. Naningla ya, ta pinahalamatan nay habayto kan Apo Namalyari. Pino-potoh nay habayto, bayo indin na kanlan tagahonol na, ta itayak la kanlan kal-atan. ");
INSERT INTO sgb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Balang miha kanla ay nakaêkan angga ha nangabhoy hila. Hên tsinipon la ya tagan, ay nakapno hila êt hên labinloway lubon. ");
INSERT INTO sgb_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Main liman libo ya lalaki ya nangan. Main êt kal-atan ya babayi haka anak ya nangan. ");
INSERT INTO sgb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tampol nan pinahakay ni Apo Jesus ha bangka hilay tagahonol na hên impauna hên lumipay, kaban nagtsipan ya pon kanlan kal-atan. ");
INSERT INTO sgb_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Hên nagtsipan yay na ha kal-atan, ay nilumakat yan nanalangin hên kakapag na. Namawatah ya bayron miha na. ");
INSERT INTO sgb_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ya bangka ya anhakyan lan tagahonol na, ay atsi ha marayo-dayo hên panhalungatên hên makhaw ya angin haka tandulon. ");
INSERT INTO sgb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Hên mawatah, ay nilako na hila hên nammita ha babon lanêm. ");
INSERT INTO sgb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Hên nahêlêk la yan ampita ha babon lanêm, ay nipan-angaw hila ha hadyay limo la, ya wanla, “Main kamana!” ");
INSERT INTO sgb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Noa, tampol nan hinabi kanla, “Paan kaw malimo. Pakhawên yoy nakêm yo! Hikoy habaytsi.” ");
INSERT INTO sgb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Hên nagilam ni Pedro ya habayto, ay wana, “Panginoon, no pêtêg hên hika ya habain, ay palakwên mo ko bahên hên mita ha babon lanêm.” ");
INSERT INTO sgb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Wani Apo Jesus etaman kana, “Galing mina di awud!” Kabay nagtaoy hi Pedro ha bangka, ta nammita yay na ha babon lanêm hên palako kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Noa, hên napansin nay hadyay angin, ay nalimwan ya, haka ampilêmêh yay na, kabay nan-angaw ya, ya wana, “Panginoon, iligtas mo ko!” ");
INSERT INTO sgb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tampol yan dinwang ni Apo Jesus, bayo wana kana, “Kulang pon awud ya paniwala mo! Pata ampag-alangan ka!” ");
INSERT INTO sgb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Hên nakahakay hilay na ha bangka, ay tinunggên ya angin. ");
INSERT INTO sgb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Sinimba hi Apo Jesus hên hilay atsi ha bangka, ya wanla, “Taganán pêtêg hên hika awud ya Anak ni Apo Namalyari!” ");
INSERT INTO sgb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pamakalipay lan Apo Jesus, ay tinumaoy hila ha bangka ha logal hên Genesaret. ");
INSERT INTO sgb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Hên nabalayan la yan taga-bayro, ay pinarah lan impamwang ha boon logal ya habayto, ya nilumatêng hilan Apo Jesus. Kabay gintan la ya kaganawan ya main hakit kana. ");
INSERT INTO sgb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ampakiingalo hila kan Apo Jesus ya agyan laylayan dayin takop na, ya magapa lan ampaghakit. Haka hilay nakagapa takop na, ay naalihan etaman hakit. ");
INSERT INTO sgb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Panga-ubat hên habayto, ay main ungnoy Pariseo haka mánoron Kautuhan ni apo Moises ya ubat ha balayan Jerusalem, ya nipandumani kan Apo Jesus, ta nangotang hila kana, ya wanla, ");
INSERT INTO sgb_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Pata a hila anhumonol ya tagahonol mo ha natotoan tamo ha ninuno tamo, no ay-êmên ya pamag-uyah bayo mangan?” ");
INSERT INTO sgb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Bayo wana êt ni Apo Jesus, “Magaling kaw hên itad hên ayn alagá ya in-utoh ni Apo Namalyari, mahonol yon bat ya natotoan yo ha ninuno yo! ");
INSERT INTO sgb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ta namiutoh hi Apo Namalyari, ‘Galangên moy tatang haka indo mo,’ haka ‘Hinoman ya maniran toa na, ay dapat patsên.’ ");
INSERT INTO sgb_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Noa, an-itoro yo ya malyarin ialay kan Apo Namalyari, ya dapat ihawop ha toa. Ha pamanoro yon habayto, ay an-ibawal yoy pamanawop ha toa. ");
INSERT INTO sgb_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Antotoên yoy ninuno yo, ta an-itad yon ayn alagá ya Habi ni Apo Namalyari. Haka kal-atan pon ya êmbahên ya andaygên yo. ");
INSERT INTO sgb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ampagbabara kaw hên mangêd! Pêtêg ya impapêt ni Propeta Isaias ya tungkol kamoyu, ya wana ha Kahulatan ya impahulat ni Apo Namalyari, ");
INSERT INTO sgb_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ya pamagpuri la kangko, ay atsin bat ha bêbêy la, ta ayn ha nakêm la. ");
INSERT INTO sgb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ayn kapukat-pukat ya pamagsimba la kangko, ta ya natotoan la ha ninuno, ay an-itoro la hên nanad ha paytoro la hên Kautuhan ko.’” ");
INSERT INTO sgb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Bayo pinarani ni Apo Jesus ya kal-atan, ta wana kanla, “Manggilam kaw haka pakaintindiên yoy habaytsi. ");
INSERT INTO sgb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Alwan pamangan ya an-ihubo ha bêbêy ya ampakarêmêk hên tawo ha hêlêk ni Apo Namalyari, noa, ya nangarawak ya habi ya angkaubat ha bêbêy.” ");
INSERT INTO sgb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Pangayari nan naghabi, ay dinumani hila kan Apo Jesus hilay tagahonol na, ta wanla kana, “Muwang mo ya nahakitan ya nakêm lan Pariseo ha hinabi mo?” ");
INSERT INTO sgb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Hinabi ni Apo Jesus kanla ya wana, “Ya kaganawan tanaman ya a intanêm ni Apo Namalyari, ya Tatang ko ha langit, ay ulutên. ");
INSERT INTO sgb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Paulayan yo hila. Nanad hilan buwag ya ampangakay ha kapareho lan buwag. Ya mihay buwag ay a makaakay hên kapareho nan buwag, ta pareho hilan minabo ha malalê ya lubot.” ");
INSERT INTO sgb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Bayo hinabi ni Pedro kan Apo Jesus, ya wana, “Ipamulah mo kannaên daw, ya labay habiên hên habaytoy alimbawa ya tungkol ha ampakarêmêk hên tawo ha hêlêk ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Wana etaman kanlan Pedro, “Hikaw man, ay a kaw ampakaintindi? ");
INSERT INTO sgb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Alwan pamangan ya an-ihubo ha bêbêy ya ampakarêmêk hên tawo ha hêlêk ni Apo Namalyari, ta ya pamangan, ay ampidann ha bitoka bayo itaká. ");
INSERT INTO sgb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Noa, ya nangarawak ya habi ya angkaubat ha bêbêy, ay yabay ya ampakarêmêk hên tawo ha hêlêk ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ta angkaubat ha nakêm ya kaihipan hên manyag karawakan, nanad ha manyag karawakan kalabayan lawini, manakaw, mamatsin kapareho, mamabayi haka makilalaki, manistigos ha alwan pêtêg, haka maniran kapareho. ");
INSERT INTO sgb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Habaytoy dyag ay angkaubat ha nakêm, haka ampakarêmêk hên tawo ha hêlêk ni Apo Namalyari. Noa, a ampakadêmêk ha hêlêk ni Apo Namalyari ya mangan hên a pon nag-uyah, hên nanad ha toro hên ninuno tamo.” ");
INSERT INTO sgb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Immalíh hilan Apo Jesus bayro, ta nunta hila ha Tiro haka Sidon, ya logal hên alwan Israelita. ");
INSERT INTO sgb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Main bayron babayi ya taga-Canaan, ya dinumani kan Apo Jesus, ya namaêg, ya wana, “Panginoon, ya kaapo-apoan ni Arin David! Ingalwan mo ko! Ya anak koy babayi ay hinapatan hên narawak ya a angkahêlêk, ya hadyay ampamairap kana.” ");
INSERT INTO sgb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Noa, ayn yan hinabi hi Apo Jesus. Kabay dinumani kan Apo Jesus ya tagahonol na ta wanla, “Paalihên mo yay na, ta ampi-angaw-angaw ya.” ");
INSERT INTO sgb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Hinabi na ha babayi ya wana, “In-utoh akon bêngat kanlan Israelita ya nanad tupa ya nitama.” ");
INSERT INTO sgb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Noa, nandoko ya ha arapan ni Apo Jesus ta wana, “Panginoon, hawpan mo ko!” ");
INSERT INTO sgb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Noa, wani Apo Jesus kana, “Pakangêrên kon antoroan haka anhawpan ya hilay Israelita. Ta habaytoy taganán usto.” ");
INSERT INTO sgb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Noa, hinabi nan babayi, ya wana, “Panginoon, mangêd ya habayto, noa, yarin a minan hawpan ya alwan Israelita, no hadyay pamairap ya angkatanam la!” ");
INSERT INTO sgb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kabay hinabi ni Apo Jesus kana, ya wana, “Makhaw awud ya paniwala mo! Mahonol ya kalabayan mo!” Tampol etaman impaplag ya namairap ha anak na. ");
INSERT INTO sgb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Hên nag-alíh ya bayro hi Apo Jesus, ay nagdann ya ha laylay hên Dagat-dagatan hên Galilea. Bayo nilumakat ya ha tawgtug, ta nikno ya bayro. ");
INSERT INTO sgb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Main kal-atan ya dinumani kana ya ampantan hên pilay, buwag, pokol, pipi, haka kaatag pon ya ampipaghakit. Indin hila ha arapan ni Apo Jesus, haka hiyay namaalíh hên hakit la. ");
INSERT INTO sgb_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kabay nipag-êpapah hilay kal-atan ha nahêlêk lay ampakahabi hilay pipi, naalíh ya pagkasingkol lan singkol, ampakabitay nay pilay, haka ampakahêlêk hilay nay buwag. Ha nahêlêk la ay pinuri la hi Apo Namalyari ya Diyos lan Israelita. ");
INSERT INTO sgb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Binaêg ni Apo Jesus ya tagahonol na, ta wana kanla, “Kaingalo hilay kal-atan, ta tatloy nay allo la di, haka ayn hilay nan maêkan. No pauliên ko hilan angkablay lonoh, ay kayno mawê hila ha dann.” ");
INSERT INTO sgb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Wanlan tagahonol na etaman, “Ay-êmên tamo hilan mapakan ya hata kal-atan?” ");
INSERT INTO sgb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Kinotang hila ni Apo Jesus, “Main kitamo pon hên puto?” Hinabi la kana, ya wanla, “Main tanan pito, haka uungnoy nanaway kênan lanêm ya pinirito.” ");
INSERT INTO sgb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Bayo pinaikno na hilay kal-atan ha luta. ");
INSERT INTO sgb_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Haka dinampot nay pitoy puto boy ya kênan lanêm, ta impahalamat na kan Apo Namalyari, bayo pino-potoh nay habayto, ta impatayak na kanlan tagahonol na. ");
INSERT INTO sgb_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Naubuh hilan nangabhoy ya kal-atan, haka hên tsinipon lay natagan, ay nakapno hila hên pitoy tiklis. ");
INSERT INTO sgb_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Main apat ya libo ya lalaki ya nakaêkan. Main êt babayi haka anak ya nakaêkan. ");
INSERT INTO sgb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Bayo nagtsipan yay na kanlan kal-atan hi Apo Jesus, ta hinumakay hilan Apo Jesus ha bangka hên palako ha logal hên Magadan. ");
INSERT INTO sgb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Main Pariseo haka Saduseo ya labay manubuk kan Apo Jesus, ya mamipahlêk yan kapapaêpapah, ya ubat ha langit, ta êmên la mamwangan no pêtêg hên atsi kana ya kapangyarihan ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Noa, wani Apo Jesus kanla, “No angkatatay nay allo ta nag yayo, ay habiên yo, ‘A ya manguran nobukah ta nag yayo.’ ");
INSERT INTO sgb_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","No ha maranon ta tsinumilêm ya ginêm, ay habiên yo, ‘Manguran amêhên.’ Muwang yo no hinoy labay habiên hên angkahêlêk yo ha langit. Yarin a yo muwang ya balang kapapaêpapah ya andaygên ko, ay palatandaan hên nilumatêng ya pamanlokop ni Apo Namalyari! ");
INSERT INTO sgb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Bapan dawak kaw, ta antalibatokan yo hi Apo Namalyari. Ampanapol kaw hên kapapaêpapah ya ubat ha langit. Noa, ayn ipahlêk kamoyu, no alwan ya nanad ha naipahlêk hên hato, ya tatloy allo yan nabiyay ha bitokan pating hi Propeta Jonas.” Habayto tanay hinabi ni Apo Jesus, bayo nammita yay na. ");
INSERT INTO sgb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Hên anlumipay hilay na ha Dagat-dagatan hên Galilea, ay napansin lan tagahonol ni Apo Jesus ya naliwaan la hên mantan puto. ");
INSERT INTO sgb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Bayo wani Apo Jesus kanla, “Taganán dapat kaw hên kaillag ha pampaalsa lan Pariseo haka Saduseo.” ");
INSERT INTO sgb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Gawan ha hinabi ni Apo Jesus, ay êndat lan tagahonol na, no mantêg pampaalsa hên arina ya hinabi na kanla, kabay nihahabi hila, ya wanla, “Hinabi nay habayto gawan a kitamo nakagêtan puto.” ");
INSERT INTO sgb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Muwang ni Apo Jesus ya ampihahabian la, kabay wana kanla, “Kulang ya paniwala yo kangko! Pata an-ikayagah yoy a kaw nakagêtan puto! ");
INSERT INTO sgb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","A kaw pon awud hên ampakaintindi! A yo pon angkakwan ihipên no ay-irin ubat ya kapangyarihan ko! Naliwaan yoy na lawêh hên pinakan koy liman libo ha li-limay puto, haka no ungnoy lubon ya napno hên tagan! ");
INSERT INTO sgb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Naliwaan yoy na lawêh hên pinakan koy apat ya libo ha pi-pitoy puto, haka no ungnoy tiklis ya napno hên tagan! ");
INSERT INTO sgb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Yarin a kaw pon ampakaintindi ya alwan tungkol ha puto ya hinabi ko hên wangko ya dapat kaw kaillag ha pampaalsa lan Pariseo haka Saduseo!” ");
INSERT INTO sgb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Naintindihan lay na bayto, ya alwa awud pampaalsa hên puto ya anhabiên na kanla. Noa, ampaillagên hila ha alwan pêtêg ya toro lan Pariseo haka Saduseo, ta ya panoro la ay makaalit hên ihip hên nanad ha pamikalat hên pampaalsa ha arina ya andaygên puto. ");
INSERT INTO sgb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Hên nilumatêng hilan Apo Jesus ha logal hên Cesarea Filipos, kinotang na hilay tagahonol na, “Hinoy anhabiên lan tawo ya tungkol kangko, ya Taga-Langit, ya In-anak Tawo?” ");
INSERT INTO sgb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kabay hinabi la, “Wanlan kaatag ya hika ay hi Juan Bautista. Noa, wanlan kaatag êt ya hika ay hi Propeta Elias. Hilay kaatag êt ay ampaghabin nabiyay oman hi Propeta Jeremias, o ya miha kanlan kaatag ya propeta ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Wana êt kanla ni Apo Jesus, “Kamoyu etaman, hino ko ha ihip yo?” ");
INSERT INTO sgb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Wani Pedro etaman, “Hika ya Mesias, ya Cristo, ya impangakon Mámiligtas, ya Anak nan angkabiyay hên ayn angga ya hi Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Wani Apo Jesus kana, “Iningalwan ka Simon, anak ni Jonas, ta kakapag ni Apo Namalyari, ya Tatang ko ha langit, ya namipamwang hên habayto kamo. ");
INSERT INTO sgb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Pakagilamên moy anhabiên ko kamo, Pedro. Ya labay habiên hên langan mo ay bato. Haka ha bato ya habaytsi, ya nanad pampah-êy bali, ay ipairêng ko ya nanad bali ko, ya kabooan hên kapareho mon ampaniwala ya hikoy Cristo. Haka a hila mahambut hên kapangyarihan hên kamatsan, ta dyanan hila hên biyay ya ayn angga. ");
INSERT INTO sgb_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Idin ko kamo ya tungkulan ya nanad antalanên moy susi hên pamanlokop ni Apo Namalyari. Kabay ya bawalên mo bayri ha luta, ay bawalên ni Apo Namalyari ya atsi ha langit, haka ya a mo bawalên bayri ha luta, ay a etaman bawalên ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Bayo impapakabawal hila ni Apo Jesus hên ipamwang ha hinoman ya hiyay Mesias, ya Cristo. ");
INSERT INTO sgb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Paubat hên habayto, ay impamulah nay na ni Apo Jesus kanlan tagahonol na ya malyari kana ha lumatêng ya allo, ya wana, “Hiko ya Taga-Langit, ya In-anak Tawo, ay kailangan hên magdanas hên hadyay pamagdusa ha Jerusalem. Hikoy araên lan mánoron Kautuhan ni apo Moises. Araên la kon toa ya nag tungkulan ha bansa, haka araên la ko êt hên ampamaala kanlan pari. Ipapatsi la ko, noa, ha ikatlon allo ay biyayên akon oman.” ");
INSERT INTO sgb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kabay indayo yan pêrad ni Pedro ta hinabyanan na ya, gawan êndat nan a patsên ya Mesias, ya Cristo, ya wana, “Panginoon! Paan dayi palyariên ni Apo Namalyari ya habayto!” ");
INSERT INTO sgb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Noa, inumarap hi Apo Jesus kan Pedro ta hinabyanan na ya, “Pedro, paan mo kon tuksoên hên nanad ha pamanukso kangko ni Satanas! An-abalaên mo ko. Ya pan-ihipên mo ay alwan kaihipan ni Apo Namalyari, noa, kaihipan hên tawo!” ");
INSERT INTO sgb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Amêhên, wana kanlan tagahonol na, “Hilay labay hên humonol kangko, ay dapat liwaan lay sarili lan kalabayan haka humonol kangko. Dapat nakal-an hilan magdanas hên hadyay pamagdusa haka matsi, ya maialimbawa ha pamakay hên nabyat ya koros. ");
INSERT INTO sgb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Hila etaman ya a anhumonol kangko, gawan a la labay hên matsi o mangoman ya pamimiyay la, ay matsi etaman. Noa, hilay matsi gawan ha paniwala la kangko, ay dyanan biyay ya ayn angga. ");
INSERT INTO sgb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mikamihan man kanan mihay tawo ya pibandian di ha luta, ay a na mapakinabangnan ya habayto, no hiya etaman ay mipalako ha kaparusaan ya ayn angga! Yarin matanggap ya pibandian na hên pagbii, ta êmên a mipalako ha kaparusaan ya ayn anggaan ya kaêlwa na! ");
INSERT INTO sgb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Hiko ya Taga-Langit ya In-anak Tawo, ay mag-orong bayri ha luta. Ha pag-orong ko, ay atsi kangko ya kapangyarihan haka ya kapahilêw ya kahampatan ni Apo Namalyari, ya Tatang ko, haka kalamo ko hilay anghel na. Tumbahan ko bayto ya balang miha, ha dinyag la. ");
INSERT INTO sgb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Pakagilamên yo! Main ungno di kamoyu ya a matsi angga ha mahêlêk la ko, ya Taga-Langit, ya In-anak Tawo, hên ampamaala.” ");
INSERT INTO sgb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Hên nalabah ya anêm ya allo paubat hên hinabi nay habayto ni Apo Jesus ay pinaglamo na hi Pedro, hi Santiago haka hi Juan ya kapotoh pohêl ni Santiago, hên nilumakat ha matag-ay ya tawgtug hên kakapag la. ");
INSERT INTO sgb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kaban atsi hila bayro, ay naoman ya itsura ni Apo Jesus. Ya lupa na ay nag-in kapahilêw hên nanad ha allo, haka ya takop na ay nag-in bapan putsi ya kapahilêw. ");
INSERT INTO sgb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Namakonkaynaman ay main mámipamwang ya an-ipaihip kanla ni Apo Namalyari ya ubat ha langit, ya hi apo Moises haka hi apo Elias ya kalamo ni Apo Jesus hên ampihahabi. ");
INSERT INTO sgb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Bayo hinabi ni Pedro, ya wana, “Panginoon, mangêd ya atsi kitamo di. No labay mo, ay manyag akon tatloy hawong di. Miha kamo, miha kan apo Moises, haka miha kan apo Elias.” ");
INSERT INTO sgb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ampaghabi ya pon hi Pedro hên inupungan hila hên ginêm, haka main hilan nagilam ya habi ya ubat ha ginêm, ya wanan habi, “Hatsi ya anlugurên kon Anak ya taganán an-ikahigla ko. Gilamên yoy habi na.” ");
INSERT INTO sgb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Hên nagilam lan Pedro ya habayto, ay hadyay limo la, haka hila nipandoko hên nakadêngdêng. ");
INSERT INTO sgb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Noa, dinanian hila ni Apo Jesus hên inahwil, ta wana kanla, “Mirêng kaw, paan kaw malimo!” ");
INSERT INTO sgb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Hên naningla hila, ay mimiha na tana ni Apo Jesus ya nahêlêk la. ");
INSERT INTO sgb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ha paglohan la hên ubat ha tawgtug, ay impapakabawal ni Apo Jesus hilay habaytoy tatloy tagahonol na hên ipamwang ha hinoman ya nahêlêk la ha tawgtug, angga ha a ya pon matsi haka mabiyay oman, ya hiya, ya Taga-Langit, ya In-anak Tawo. ");
INSERT INTO sgb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Gawan nahêlêk la bayro ha tawgtug hi apo Elias, ay kinotang la hi Apo Jesus, ya wanla, “Awta panhabiên lan mánoron Kautuhan ni apo Moises ya kailangan mag-orong ya pon di ha luta hi apo Elias, bayo ya lumatêng ya Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala?” ");
INSERT INTO sgb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Hinabi na kanla ni Apo Jesus, ya wana, “Pêtêg ya habaytoy anhabiên lan mánoron Kautuhan ni apo Moises. ");
INSERT INTO sgb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Noa, anhabiên ko kamoyu, ya nilumatêng yay na di ha luta ya nanad kan apo Elias, haka a la ya nabalayan ya hiyay habayto ya lumatêng bayo ya lumatêng ya Mesias, ya Cristo, ta pinairapan la ya. Êmên êt bayro, ay hiko, ya Taga-Langit, ya In-anak Tawo, ay magdanas hên hadyay pamairap ha gamêt la.” ");
INSERT INTO sgb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Hên hinabi nay na ya habayto ni Apo Jesus, ay naintindihan lay na ya hi Juan Bautista awud ya inungkat ni Apo Jesus ya nanad kan apo Elias. ");
INSERT INTO sgb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Hên ubat hilay na ha tawgtug, ay tinupa hilan Apo Jesus hên kal-atan. Kalamo lay mihay lalaki ya nandoko ha arapan ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Wanan lalaki, “Panginoon, ingalwan mo dayi ya anak koy lalaki ta main yan tugaw. Hadyay pamairap ya angkatanam nan anak, ta panay yan ampitumba ha apoy, haka ampihugno ha lanêm. ");
INSERT INTO sgb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Gintan ko ya ha tagahonol mo, ta paalihên la dayi ya hakit na, noa, a la ya kayan paalihên.” ");
INSERT INTO sgb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Amêhên, wani Apo Jesus, “Hikaw ya angkabiyay amêhên ay ayn paniwala, haka hadyay dawak kaw. Ay-irin angga kataw hên pakilamoan haka pakitagalan?” Bayo wana kanan lalaki, “Gêtan mo di ya anak mo.” ");
INSERT INTO sgb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Bayo hinabyanan haka impaplag ni Apo Jesus ya narawak ya hinumapat kanan anak, kabay paubat hên habayto, ay a yay na tinugaw ya habaytoy anak. ");
INSERT INTO sgb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Hên hila-hila tana hilan Apo Jesus, haka hilay tagahonol na, ay kinotang la ya, “Awta a naên ya napaalíh ya hinumapat kanan anak?” ");
INSERT INTO sgb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Wana etaman ni Apo Jesus, “Gawan kulang ya paniwala yo ha kapangyarihan ni Apo Namalyari. Pakagilamên yo, pêpêrad man ya paniwala yo, hên nanad ha pinakananaway but-o, ay mahabi yo kanan hata tawgtug ya, ‘Mag-álih ka ha dagat!’ haka humonol ya kamoyu. Hilay ampaniwala kan Apo Namalyari ay makadyag hên kaganawan! ");
INSERT INTO sgb_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Noa, ya êmbayroy narawak ya a angkahêlêk, ay mapaalíh bêngat ha panalangin haka ha pamagtêêh hên a mangan, ta êmên a maabala ya panalangin.” ");
INSERT INTO sgb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Hên napi-tsi-tsipon hilan Apo Jesus ha probinsyan Galilea, ay wana kanlan tagahonol na, “Hiko, ya Taga-Langit, ya In-anak Tawo, ay i-upit ha kapatsi ko. ");
INSERT INTO sgb_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Patsên la ko, noa, ha ikatlon allo, ay mabiyay kon oman.” Kabay hadyay lungkot hên nakêm lan tagahonol na, hên nagilam lay habayto. ");
INSERT INTO sgb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Hên nilatêng hilan Apo Jesus ha balayan Capernaum, ay main napaidani kan Simon Pedro ya máningil buwih hên Templo, ta nangotang kana no ampamayad yan buwih hên Templo hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Awo. Ampamayad yan buwih,” wani Pedro. Hên nilumatêng hila ha bali ya anlakwên la, ay tampol nan kinotang ni Apo Jesus hi Pedro, “Simon, ha ihip mo, hino ya ampaningilan buwih hên hilay ari ya ampamaala bayri ha luta? Hilay mitataanak la, o hilay kaatag?” ");
INSERT INTO sgb_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Hinabi ni Pedro, ya wana, “Hilay kaatag.” Kabay wani Apo Jesus kana, “No êmbayro awud, ay a la ampaningilan buwih ya pamilya la. ");
INSERT INTO sgb_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Êmbayro man, ta êmên hila ayn mahabi, ay mamaniwit ka, ta ya una mon makwa, ay bibitên moy bêbêy ta mahêlêk mo bayro ya mihay pera ya pilak ya sakto ha pamayad hên buwih hên Templo ha loway katawo. Kowên moy habayto ta ibayad mo ha buwih ta.” ");
INSERT INTO sgb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Hên habayto, ay dinumani kan Apo Jesus, ya tagahonol na, hên nangotang no hino kanla ya pinakamatag-ay ya tungkulan lano ha pamanlokop ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Binaêg nay mihay anak ya nanawa hên mirêng ha arapan la. ");
INSERT INTO sgb_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Bayo wana kanla, “Pakagilamên yo, magbayo kaw hên mag-in maaypa ya nakêm, hên nanad kanan hata nanaway anak, ta no alwan maaypa ya nakêm yo, ay taganán a kaw makapakilamo ha pamanlokop ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Hilay maaypa ya nakêm, ay hilay mag-in pinakamatag-ay ha pamanlokop ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Hinoman ya ampaniwala kangko, ya ampananggap kanlan maaypa ya nakêm ya nanad hata nanaway anak, hên gawan habaytoy paniwala la kangko, ay nanad hiko ya antanggapên la.” ");
INSERT INTO sgb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Inhundo ni Apo Jesus ya pamaghabi na, ya wana, “Hinoman ya pangubatan hên pamanyag kasalanan hên mihay maaypa ya nakêm hên nanad kanan hata nanaway anak ya ampaniwala kangko, ay mangêd pon kana, ya bayo ya mag-in pangubatan hên habayto, ay patsên ya hên êl-an yan mahlay ya bato ha lêêy na, ta ilêmêh ya ha malalê ya lanêm. ");
INSERT INTO sgb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Taganán kapaingalo hilay tawo bayri ha luta, ta mal-at ya pangubatan hên pamanyag kasalanan. Taganán lumatêng kantamo ya tukso hên manyag kasalanan, noa, kaingalo ya ampangubatan hên tukso. ");
INSERT INTO sgb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“No gamêt o bitsih mo ya anggamitên mon manyag kasalanan, ay mangêd ya potohên mo ya habayto. Ta mangêd ya milamo ka ha biyay ya ayn angga ha langit hên ayn gamêt o bitsih kanan mitapon ha impiyerno ha apoy ya taganán a maparê hên main gamêt o bitsih. ");
INSERT INTO sgb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","No mata mo ya anggamitên mon manyag kasalanan, ay kêwêtên mo haka mon itapon. Ta mangêd pon ya ayn mata hên milamo ha biyay ya ayn anggaan ha langit, kanan main mata hên mihamwag ha apoy ha impiyerno.” ");
INSERT INTO sgb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Amêhên, ay wanay na êt ni Apo Jesus, “Paan yo hilan musmusên ya miha man ya ampaniwala kangko ya maaypa ya nakêm hên nanad kanan hata nanaway anak, ta hilay anghel ha langit, ya ampangillag kanla, ay panay hên ampamipamwang kan Apo Namalyari, ya Tatang ko, ha kaganawan angkalyari kanla. ");
INSERT INTO sgb_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Gawan hiko, ya Taga-Langit, ya In-anak Tawo, ay atsi di ha luta, ta êmên iligtas ha kaparusaan ya hilay nitama. ");
INSERT INTO sgb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“No alimbawa ta main miha kamoyu ya nag magatoh ya tupa, ta nitama ya miha, ay hinoy daygên na? Siguradon ibalag na pon ya siyamapo boy siyam bayro ha pagpastolan la, ta tapolên nay miha ya nitama hên angga ha matapol nay habayto. ");
INSERT INTO sgb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","No natapol nay habaytoy nitama, ay taganán mas ikahigla nay habayto, kanan siyamapo boy siyam ya a nitama. ");
INSERT INTO sgb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Êmbayro êt hi Apo Namalyari, ya Tatang ko ha langit. A na labay hên midayo kana ya miha man kanlan ampaniwala kangko ya maaypa ya nakêm hên nanad hata nanaway anak.” ");
INSERT INTO sgb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Inhundo ni Apo Jesus ya pamaghabi na, ya wana, “No makadyag kasalanan kamo ya mihay patêl mo ha Panginoon, ay pagkahabi mo ya hên kakapag yo. No gilamên na ka, ay miúmang ya pamipatêl yo ha Panginoon, haka naiúmang mo ya kan Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Noa, no a na ka gilamên, ay mangilamo ka hên miha o lowa ya kaatag ya patêl ha Panginoon, ta êmên main manggilam ha pinihabian yon lowa hên main lowa o tatloy tistigos. ");
INSERT INTO sgb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","No a ya pon êt manggilam, ay ipamwang mina ha arapan lan kapareho yon patêl ha Panginoon ya angkapi-tsi-tsipon. No a ya pon êt manggilam kanla man ya kapareho yon patêl ha Panginoon ya angkapi-tsi-tsipon, ay dayuán yo ya hên itad kanlan a ampagpalokop kan Apo Namalyari, haka nanad kanlan mapanyag karawakan.” ");
INSERT INTO sgb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Inhundo ni Apo Jesus ya pamaghabi na, ya wana, “Ya bawalên yo bayri ha luta, ay bawalên êt ha langit, haka ya a yo bawalên bayri ha luta, ay a etaman bawalên ha langit.” ");
INSERT INTO sgb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Pakagilamên yo. No main lowa kamoyu di ha luta, ya magkamiha ha panalangin yo, ay ipatupad ni Apo Namalyari, ya Tatang ko ha langit ya habaytoy labay yo kana. ");
INSERT INTO sgb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ta no anto ya main lowa o tatlo ya naka-tsipon gawan ha pamakimiha la kangko, ay atsi ko hên kalamo la.” ");
INSERT INTO sgb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Amêhên, ay napaidani hi Pedro kan Apo Jesus hên nangotang, “Panginoon, makaungno kon patawarên ya patêl ko ha Panginoon, ya panay hên ampanyag kasalanan kangko? Katapito kaya?” ");
INSERT INTO sgb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Hinabi kana ni Apo Jesus, “Alwan bat katapito, noa, pitumpon oman. ");
INSERT INTO sgb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Gawan êmên di ya maialimbawa ya pamanlokop ni Apo Namalyari. Main mihay ari ya labay maningil hên impautang na kanlan ipoh na. ");
INSERT INTO sgb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ya una hên gintan kana, ay main utang hên milyun-milyun ya pera. ");
INSERT INTO sgb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Gawan ha hiya ay taganán ayn maibayad, ay in-utoh hên ari ya ihaliw hilay mitataanak haka pibandian la, ta êmên mabayaran ya utang. ");
INSERT INTO sgb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Kabay nandoko ya ipoh ha arapan hên ari ta nakiingalo ya, ‘Dyanan mo ko pon hên panaon ta ubuhên kon bayaran kamo ya utang ko.’ ");
INSERT INTO sgb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Gawan ha naingalwan na ya, ay a na yay na pinabayad ta binura nay na ya utang. ");
INSERT INTO sgb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Noa, hên nammitay nay habaytoy ipoh, ay nakatupa nay kapareho nan ipoh ya main utang kana hên alagán magatoh ya allon pamag-obra. Dinakêp na ya ta sakalên na ya dayi, ya wana, ‘Bayaran minay utang mo kangko!’ ");
INSERT INTO sgb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nandoko ya ha arapan na ya kapareho nan ipoh hên nakiingalo, ya wana, ‘Dyanan mo ko pon hên panaon, ta bayaran koy utang ko.’ ");
INSERT INTO sgb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Noa, a ya nabay hên dyanan yan panaon. Yan impahukul na ya hên angga ha makabayad ya kana. ");
INSERT INTO sgb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Hên nahêlêk lan kapareho lan ipoh, ya nalyari, ay namalagêhbêg ya nakêm la, kabay inhumbung la kanan ari ya nalyari. ");
INSERT INTO sgb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kabay impabaêg yay na êt hên ari, ta wana kana, ‘Narawak ya ugali mo! Pinatawad kata ha boon utang mo kangko, gawan ha ingalo ko kamo. ");
INSERT INTO sgb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Pata a ka nalonos ha kapareho mon ipoh, hên nanad ha pangingalo ko kamo!’ ");
INSERT INTO sgb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ha hadyay huluk hên ari, ay impahukul nay ipoh, hên angga ha a nan nabayaran ya boon utang na. ");
INSERT INTO sgb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Êmbayro êt ya daygên kamoyu ni Apo Namalyari ya Tatang ko ha langit, no a yo patawarên ya kapareho yon patêl ha Panginoon hên booy nakêm.” ");
INSERT INTO sgb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Hên naitoro nay na ni Apo Jesus ya tungkol ha pamatawad, ay immalíh hila bayro ha probinsyan Galilea, ta nagdann hilay na ha probinsyan Judea, hên nilumipay ha Ilog Jordan. ");
INSERT INTO sgb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kal-atan ya nangamat kana, haka namaalíh yan hakit la. ");
INSERT INTO sgb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Main ungnoy Pariseo bayro ya napaidani kan Apo Jesus ya labay mandakêp kana ha pamaghabi na. Kabay nangotang hila kana, “Malyari ha mihay lalaki hên ihiyay nay ahawa na, agyan hinoman ya pagbad-an?” ");
INSERT INTO sgb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Hinabi hi Apo Jesus, “A yo pon nabaha, ya hên hato, hên dinyag ni Apo Namalyari ya luta, ay nanyag yan lalaki, haka nanyag ya êt hên babayi? ");
INSERT INTO sgb_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kabay lakwanan nan lalaki ya toa na, ta milamo hilay nay miahawa. Hilay miahawa ay mag-in mimiha, ");
INSERT INTO sgb_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","kabay alwa hilay nan lowa, ta mimiha hila tana. Ya pinilamo ni Apo Namalyari, ay paan pihiyayên.” ");
INSERT INTO sgb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Wanlay na êt, “Pata in-utoh ni apo Moises ya malyarin dyanan lan lalaki hên kahulatan hên pamihiyay ha ahawa la, bayo malyari lay nan ihiyay?” ");
INSERT INTO sgb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Hinabi nay na êt ni Apo Jesus, “Pinaulayan ni apo Moises hên manyag hên êmbayro, ya ninuno yo, gawan ha kakdêyan ulo la ha a la labay humonol ha kalabayan ni Apo Namalyari. Noa, hên dinyag ni Apo Namalyari ya luta, ay tinalagá na ya miahawa ay paan mihiyay. ");
INSERT INTO sgb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kabay anhabiên ko kamoyu amêhên, ya hinon lalaki ya mamihiyay hên ahawa na, no a ya nakilalaki, bayo mag-ahawan kaatag, ay nanyag kasalanan gawan namabayi ya.” ");
INSERT INTO sgb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Amêhên, wanlan tagahonol ni Apo Jesus, “No êmbayroy angkalyari, ay paan pon awud hên mag-ahawa ya mihay lalaki.” ");
INSERT INTO sgb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Noa, wani Apo Jesus, “Hilay kaatag ay dinyanan ni Apo Namalyari hên pamagtêêh hên a mag-ahawa, noa, hilay kaatag ay a makatêêh hên a mag-ahawa. ");
INSERT INTO sgb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Alwan pare-pareho ya ampangubatan no pata main lalaki ya a mag-ahawa. Ya kaatag, ay gintanan lay na ya habayto ha pagkaanak la. Ya kaatag ay dinyag êmbayro hên kapareho la. Haka ya kaatag, etaman ay tinalagá la hên a mag-ahawa, ta êmên a maabala ya pamitoro la hên tungkol ha pamanlokop ni Apo Namalyari. Hila ya ampakaintindi hên hinabi ko hên tungkol ha pamag-ahawa, ay dapat lan honolên ya habayto.” ");
INSERT INTO sgb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nanganaway anak man, ay anggêtan kan Apo Jesus, ta ihalangin na hila hên ipalunto nay gamêt na ha ulo la. Hên nahêlêk lan tagahonol ni Apo Jesus ya manianak-anak ay binawal lay ampantan kanla. ");
INSERT INTO sgb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Noa, wani Apo Jesus kanlan tagahonol na, “Paulayan yo hilay anak hên paidani kangko. Paan yo hilan bawalên. Ta hilay maaypa ya nakêm ya nanad kanla, ay hila ya ilamo ha pamanlokop ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Hên naipalunto nay gamêt na ha ulo hên inhalangin na hila, ay nammita yay na. ");
INSERT INTO sgb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Main mihay lalaki ya dinumani kan Apo Jesus, hên nangotang, “Mánoro, hinoy kangêran ya dapat kon daygên, ta êmên ako madyanan hên biyay ya ayn angga?” ");
INSERT INTO sgb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Hinabi kana ni Apo Jesus, “Pata kinotang mo kangko no hinoy mangêd? Hi Apo Namalyarin bêngat ya mangêd. No labay mon madyanan kan biyay ya ayn angga, ay dapat mon honolên ya Kautuhan na.” ");
INSERT INTO sgb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Kabay kinotang na êt hên lalaki, “Hinoy Kautuhan?” Hinabi nay na êt ni Apo Jesus, “Paan mamatsin kaparehon tawo. Paan mamabayi. Paan makilalaki. Paan manakaw. Paan manistigos ha alwan kaptêgan. ");
INSERT INTO sgb_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Galangên moy toa mo, haka lugurên moy kapareho mo hên nanad ha pamanlugud mo ha sarili mo.” ");
INSERT INTO sgb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","“Mánoro, anhonolên kina ya habayto ngan paubat hên anak ako pon. Hino pon ya kailangan kon daygên?” ");
INSERT INTO sgb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Hinabi nay na êt ni Apo Jesus, “No labay mon ayn kan pamagkulang kan Apo Namalyari, ay iubuh mon ihaliw ya pibandian mo, bayo idin moy naablian kanlan mangairap, ta madyanan kan mantêg hên pibandian ha langit. Pangayari mon nadyag ya habayto, ay mag-orong ka di, ta humonol ka kangko.” ");
INSERT INTO sgb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Noa, hên nagilam nay habi ni Apo Jesus, ay nammita yay na hên ampaglungkot, ta miha yay mabandi. ");
INSERT INTO sgb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Bayo wani Apo Jesus kanlan tagahonol na, “Pakagilamên yo! Alwan nataluh hên makapakilamo ha pamanlokop ni Apo Namalyari ya hilay mabandi! ");
INSERT INTO sgb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Anhabiên ko etaman kamoyu, ya nataluh hên magdann ha lubot karayêm ya mihay kamelyo kanan makapakilamo ha pamanlokop ni Apo Namalyari ya mihay mabandi.” ");
INSERT INTO sgb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Angkalipang ya ihip lan tagahonol na ha hinabi na, kabay kinotang la ya, “Hino awud ya miligtas hên makapakilamo ha pamanlokop ni Apo Namalyari?” ");
INSERT INTO sgb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Pinakahêlêk hila ni Apo Jesus, bayo wana, “Ya a madyag hên tawo, ay madyag ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Amêhên, wani Pedro, “Ay-êmên kay, ya tagahonol mo? Imbalag naên ya kaganawan, ta êmên kay humonol kamo. Hino etaman ya idin kannaên?” ");
INSERT INTO sgb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Hinabi etaman ni Apo Jesus, “Pakagilamên yo! Lano no bayoên ni Apo Namalyari ya luta, ta hiko, ya Taga-Langit, ya In-anak Tawo ay mamaala hên main kapangyarihan, ay mikno kaw ha iknoan hên ari ta mamaala kaw kanlan Israelita, ya hilay kaapo-apoan lan labinloway anak ya lalaki ni apo Israel. ");
INSERT INTO sgb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Hilay nangibalag bali la, o kapotoh pohêl la, o toa la, o anak la, o luta la, gawan ha pamanhumonol la kangko, ay matumbahan hên katamagatoh kanan imbalag la, kaban atsi hila pon di ha luta. Bayo lano madyanan hila êt hên biyay ya ayn angga. ");
INSERT INTO sgb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Noa, mal-at kanlan matag-ay ya tungkulan ha hêlêk hên kapareho la, ay alwan matag-ay ha hêlêk ni Apo Namalyari, haka mal-at kanlan maaypa ya tungkulan ha hêlêk hên kapareho la, ay matag-ay ha hêlêk ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Inhundo ni Apo Jesus ya pamanoro na, ya wana, “Ya pamanlokop ni Apo Namalyari, ay maialimbawa ya êmên di: Main mihay nag ubasan. Dali allo pon, ay inumawah yan nanapol hên mabay mag-obra ha ubasan na. ");
INSERT INTO sgb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Hên napikasundo hilay na ha upa ha mihay allon pamag-obra, ay pinaobra na hilay na. ");
INSERT INTO sgb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Hên alas nuwebe hên matag-ay ya allo, ay main yan nahêlêk ya ayn an-obraên ha palengke, ");
INSERT INTO sgb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","kabay wana kanla, ‘Mag-obra kaw ha ubasan ko ta upaan kataw ha hukad ya upa.’ Kabay nammita hilay nan nag-obra. ");
INSERT INTO sgb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Hên mag-aalas dose hên ugto, haka hên mag-aalas tres hên maapon, ay nakatapol yay na êt hên mabay mag-obra ta pinaobra na hila ha ubasan na. ");
INSERT INTO sgb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Hên mag-aalas singkoy na hên maapon hên immawah ya, ay nakahêlêk yay na êt hên ayn an-obraên, ta wana kanla, ‘Pata nakaiirêng kaw di hên ayn an-obraên hên boon allo?’ ");
INSERT INTO sgb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Wanla kana, ‘Gawan ayn namaobra kannaên.’ Hinabi na kanla, ‘Mag-obra kaw tana etaman ha ubasan ko.’ ");
INSERT INTO sgb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Hên anyumabi, ay wanan nag ubasan kanan paypaniwal-an na, ya wana, ‘Baêgên mo hilay nay mag-obra, ta idin mina kanla ya upa la. Ya una mon dyanan, ay hatoy natawli hên pinaobra.’ ");
INSERT INTO sgb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Hên nilumatêng hilay nay pinaobra hên paubat alas singko hên maapon, ay dinyanan hilan alagá hên pamag-obra ha mihay allo. ");
INSERT INTO sgb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Amêhên, hên nilumatêng hilay unan pinaobra, ay êndat la no maupaan hila hên mahlay kanan upa lan natawli hên pinaobra. Noa, pare-pareho hilan dinyanan etaman hên upa ha mihay allon pamag-obra nanad ha napikasundo la. ");
INSERT INTO sgb_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Hên nakwa lay nay upa la, ay nagmulongan hila ha nag ubasan, ");
INSERT INTO sgb_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ya wanla, ‘Mimihay oras ya pamag-obra lan natawli hên pinaobra mo, yan pareho ya upa la, haka upa naên, ya nag-obran patingapon, ha hadyay omot allo.’ ");
INSERT INTO sgb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Noa, wanan nag ubasan kanan miha kanlan una nan pinaobra, ‘A kata niloko. Napikahundoan ta ha upa ha mihay allon pamag-obra. ");
INSERT INTO sgb_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kowên minay upa mo ta mita kay na. Atsi kangko no piparehoên koy upa yon una haka natawli. ");
INSERT INTO sgb_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Yarin ayn akon karapatan ha pibandian ko, hên daygên ya kalabayan ko! Kayno angkahêm ka kangko, gawan mapam-i ko!’ ");
INSERT INTO sgb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Êmbayro êt ha pamanlokop ni Apo Namalyari. Mal-at kanlan matag-ay ya tungkulan ha hêlêk hên kapareho la, ay alwan matag-ay ha hêlêk ni Apo Namalyari, haka mal-at kanlan maaypa ya tungkulan ha hêlêk hên kapareho la, ay matag-ay ha hêlêk ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Hên atsi hila ha dann, hilan Apo Jesus, hên palako ha balayan Jerusalem, ay impapawa nay labinloway tagahonol na kanlan kal-atan, ta wana kanlan bêngat, ");
INSERT INTO sgb_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Pakagilamên yo! Anlumakat kitamo ha Jerusalem, haka hiko, ya Taga-Langit, ya In-anak Tawo, ay i-upit kanlan mánoron Kautuhan ni apo Moises haka kanlan ampamaala kanlan pari. Habiên lan habayto ya dapat akon patsên. ");
INSERT INTO sgb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Idin la ko kanlan alwan Israelita ta êmên ako musmusên, pagpapatokên haka patsên lan habayto ha koros. Noa, ha ikatlon allo, ay mabiyay kon oman!” ");
INSERT INTO sgb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nandoko hên nangotang kan Apo Jesus ya ahawa ni Zebedeo, hên kalamoy loway anak la, ya lowa kanlan tagahonol ni Apo Jesus, ya wana, “Panginoon, main ako dayin pakihabi kamo.” ");
INSERT INTO sgb_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kabay kinotang ni Apo Jesus, “Hinoy labay mo kangko?” Wana etaman kana, “Labay ko, ya lano ha pamanlokop mo, ay paiknoên moy hata loway anak ko ha dani mo, ya miha ha dapit panabtab, haka miha êt ha dapit uki.” ");
INSERT INTO sgb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Wani Apo Jesus kanlan loway anak na, “A yo angkaintindihan ya pamagdusa ya maranasan yo, no mahonol ya kalabayan yo. Matêêh yoy pamagdusa ya danasên ko? Taganán nakal-an kaw hên matsi hên nanad kangko?” Wanla etaman kana, “Awo. Nakal-an kay.” ");
INSERT INTO sgb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Kabay wani Apo Jesus kanla, “Madanasan yoy pamagdusa ya danasên ko, haka matsi kaw hên nanad kangko. Noa, ayn akon karapatan hên maghabi no hinoy mikno ha dani ko, ta habaytoy tinalagá nay na ni Apo Namalyari ya Tatang ko.” ");
INSERT INTO sgb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Hên nagilam lan mapoy tagahonol na, ya labay ni Santiago haka Juan, ay hinumuluk hila. ");
INSERT INTO sgb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kabay pinarani na hila ni Apo Jesus, ta wana kanla, “Muwang yo ya hilay manungkulan lan a ampagpalokop kan Apo Namalyari, ay andaygên lan ipoh ya angkalokopan la, haka an-iatay la hilan manyag kalabayan la. ");
INSERT INTO sgb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Noa, dapat alwan êmbayro ya daygên yo. No labay yon mag-in matag-ay ya tungkulan, ay dapat yon huyuên ya kapareho yon tawo. ");
INSERT INTO sgb_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ya labay mag-in pinakamatag-ay ya tungkulan, ay dapat mag-in nanad ipoh hên kalamo na. ");
INSERT INTO sgb_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ta hiko man ya Taga-Langit, ya In-anak Tawo, ay atsi bayri amêhên ha luta, alwan para paghuyuan, noa, para maghuyo angga ha idin koy biyay ko, ha pangakbus hên kal-atan.” ");
INSERT INTO sgb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Amêhên, nilumatêng hilan Apo Jesus ha balayan Jerico. Haka hên paalíh hila bayro ha balayan, ay main kal-atan ya nangamat kanla. ");
INSERT INTO sgb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Main bayron loway buwag ya ampikno ha danin dann. Hên nagilam lay ampanlibah hi Apo Jesus ay in-angaw la, ya wanla, “Panginoon, ya kaapo-apoan ni Arin David, ingalwan mo kay dayi!” ");
INSERT INTO sgb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Binawal hilan maglabak hên hatoy kal-atan ya ampakihonol kan Apo Jesus, noa, impakakhaw lan in-angaw, “Panginoon, ya kaapo-apoan ni Arin David, ingalwan mo kay dayi!” ");
INSERT INTO sgb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Hên nagilam ni Apo Jesus ya angaw la, tinunggên ya ta nangotang ya kanla, “Hinoy labay yon daygên ko kamoyu?” ");
INSERT INTO sgb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kabay wanlan buwag, “Panginoon, labay naên hên makahêlêk.” ");
INSERT INTO sgb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Iningalwan na hila ni Apo Jesus, kabay ginap-an nay mata la. Tambêng hila etaman nakahêlêk, haka nakihonol hilay na kanlan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nahên andumani hilan Apo Jesus ha Jerusalem, ta atsi hilay na ha balayan Betfage ha Tawgtug Olibo, ay impauna ni Apo Jesus ya lowa kanlan labinloway tagahonol na, ");
INSERT INTO sgb_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ta wana kanla, “Muna kaw ha balayan. Tampol yon mahêlêk ya nakah-êl ya mihay asno, ya nag bisero. Okalên yoy habayto, ta gêtan yo hila di. ");
INSERT INTO sgb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","No main mangotáng kamoyu no awta an-okalên yoy habayto, ay habiên yo, ya kailangan lan Panginoon, haka tampol nan ipagtan kamoyu.” ");
INSERT INTO sgb_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nalyari ya habayto, ta êmên matupad ya hinabi nan mámipamwang hên an-ipaihip kana ni Apo Namalyari hên hato, ya wana, ");
INSERT INTO sgb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Habiên yo kanlan taga-Jerusalem, ‘Hêlkên yo, atsi di ya ampamaala kamoyu, ya nagpakaaypan nakêm hên himmakay ha asno, haka ya biseron asno.’” ");
INSERT INTO sgb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kabay nammita hilay nay loway tagahonol na ya in-utoh na, ta hinonol lay hinabi ni Apo Jesus kanla. ");
INSERT INTO sgb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","In-akay lay na kan Apo Jesus ya mitaindoy asno, haka la inamakan pangkêbêl la, bayo himmakay hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Inhundo lan Apo Jesus ya pammita lan palakon Jerusalem. Ha pandanan lan Apo Jesus, ay nami-amak hilay kaatag ya atsi bayro hên takop la. Kaatag ay nanigpah hên bulong ya in-amak la etaman ha pandanan na, gawan ha panggalang la kana. ");
INSERT INTO sgb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Hilay kal-atan ya atsi ha unaan ni Apo Jesus haka hilay anhumonol kana ay nipan-angaw, “Hosanna kan Apo Jesus, ya kaapo-apoan ni Arin David! Iningalwan ya habaytsi ya in-utoh ni Apo Namalyari! Puriên hi Apo Namalyari!” ");
INSERT INTO sgb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Hên nilumatêng hilan Apo Jesus ha Jerusalem, ay nagulo ya boon balayan ta nikokotang hila, “Hinoy habaytsi?” ");
INSERT INTO sgb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Hinabi lan kal-atan kalamo ni Apo Jesus, “Habaytsi hi Apo Jesus ya propeta ni Apo Namalyari ya taga-Nazaret ha probinsyan Galilea.” ");
INSERT INTO sgb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Hên nilumatêng hilan Apo Jesus ha Jerusalem, ay nagpakha ya ha Templo. Intaboy na hilay ampipagtinda haka ampipanaliw bayro. In-iitwag nay lamisaan lan mámihagili hên pera, haka in-iitwag na êt ya iknoan lan mámihaliw hên pati-pati. ");
INSERT INTO sgb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Hinabi na kanla, “Nakahulat ha Kahulatan ya impahulat ni Apo Namalyari, ya wanan hulat, ‘Ya bali ko ay ambaêgên balin panalanginan.’ Noa, dinyag yo yan logal ya panlokoan yon kapareho yo!” ");
INSERT INTO sgb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Main bayron buwag haka pilay ya nipandumani kan Apo Jesus, haka namaalíh ya hên hakit la. ");
INSERT INTO sgb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Main êt bayro hên anak ya atsi ha lalên Templo ya ampagpuri kan Apo Jesus, ya wanla, “Puriên ya Kaapo-apoan ni Arin David!” Noa, hên nahêlêk lan mánoron Kautuhan ni apo Moises boy hilay poon pari ya kapapaêpapah ya dinyag ni Apo Jesus, haka la nagilam ya pamagpuri lan anak, ay hinumuluk hila. ");
INSERT INTO sgb_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Kabay wanla kan Apo Jesus, “A mo angkagilaman ya pamagpuri lan anak kamo?” Wana etaman ni Apo Jesus, “Awo! Angkagilam koy pamagpuri la kangko. Yarin a yo êt nabaha ha Kahulatan ya impahulat ni Apo Namalyari ya êmên di, ‘Tinoroan moy anak haka hilay ampanoho pon ta êmên mag-in ayn pamagkulang ya pamagpuri la kamo!’” ");
INSERT INTO sgb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Amêhên, ay immalíh yay na bayro hi Apo Jesus ta namayabi ya ha baryon Betania. ");
INSERT INTO sgb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pangamaranon hên mag-orong hilan Apo Jesus ha balayan Jerusalem hên ubat ha Betania, ay nilonoh hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Hên nahêlêk nay mihay poon igos ha dann, ay dinanian nan hinlêk no main tagêy. Noa, bulong bêngat ya nalatngan na. Kabay wana kanan kayo, “Angga-angga, ay a kay na managêy oman!” Haka tambêng nayangoy habaytoy kayo. ");
INSERT INTO sgb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Hên nahêlêk lan tagahonol na ya tambêng nayango ya habaytoy kayo, ay nag-êpapah hila, haka hila nangotang kan Apo Jesus no awta tampol nayango ya habayto. ");
INSERT INTO sgb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Wani Apo Jesus, “Pakagilamên yo, no ampaniwala kaw kan Apo Namalyari, haka no a kaw ampag-alangan, ay madyag yo êt ya dinyag ko ha kayon igos, haka alwan bat habayto ya madyag yo, noa, maiutoh yoy hata tawgtug hên mitapon ya ha dagat, ay daygên nay na ni Apo Namalyari ya habayto. ");
INSERT INTO sgb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","No ampaniwala kaw, ay matanggap yoy hinoman ya pakikwaan yo ha panalangin.” ");
INSERT INTO sgb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Mihay allo hên atsi ya hi Apo Jesus ha Templo hên ampanoro, ay dinumani kana hilay toa ya nag tungkulan ha bansa, haka hilay ampamaala kanlan pari. Hinabi la kana, “Habiên mo kannaên no hinoy tungkulan mo hên manyag hên pandaygên mo. Habiên mo êt no hinoy nam-i kamo hên habain ya tungkulan.” ");
INSERT INTO sgb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Kabay wani Apo Jesus, “Main ako pon hên kotangên kamoyu. No pakibatan yo ko, ay habiên ko kamoyu no hinoy nam-i kangko hên tungkulan hên manyag hên pandaygên ko. ");
INSERT INTO sgb_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Hinoy nam-i hên tungkulan kan Juan Bautista hên mamawtismo? Hi Apo Namalyari o tawo?” Kabay pinihahabian la, ya wanla, “Hinoy habiên tamo? No habiên tamo ya ‘Ubat kan Apo Namalyari ya tungkulan ni Juan Bautista,’ ay habiên na bayto, ‘Pata a yo yan pinaniwal-an?’ ");
INSERT INTO sgb_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Noa, no habiên tamo ya ‘Ubat ha tawo,’ ay hino kaya ya daygên lan kal-atan kantamo, ta ha ihip la, hi Juan ay mihay propeta, ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kabay hinabi la kan Apo Jesus, ya wanla, “A naên muwang no antoy ubatan tungkulan ni Juan Bautista.” Bayo wani Apo Jesus, “No êmbayro awud, ay a ko etaman habiên kamoyu no antoy ubatan tungkulan ko.” ");
INSERT INTO sgb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Inhundo ni Apo Jesus ya panoro na, ya wana, “Hino ha ihip yo ya tungkol di ha ialimbawa ko kamoyu? Main mihay lalaki ya nag loway anak ya lalaki. Intoro nay miha, ya wana, ‘Anak ko, mag-obra ka ha ubasan amêhên.’ ");
INSERT INTO sgb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Wana ha tatang na, ‘A ko mabay.’ Noa, nangoman ya ihip na, kabay nag-obra yay na ha ubasan. ");
INSERT INTO sgb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Êmbayro êt ya intoro nan tatang kanan ikalwan anak. Nabay ya, noa, a ya nammitan nag-obra.” ");
INSERT INTO sgb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Amêhên, kinotang hila ni Apo Jesus, “Hino kanlan lowa ya nanyag kalabayan tatang la?” Wanlan ampamaala ha Templo, “Hatoy unan intoro na.” Wani Apo Jesus kanla, “Awo! Pakagilamên yo! Hilay mapanyag kasalanan nanad kanlan máningil buwih haka hilay hostis ya naghêhê hên tinalibatokan ya kasalanan la, ay nanad hatoy unan intoro hên tatang, kabay muna hila kamoyu hên makapakilamo ha pamanlokop ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Habaytoy malyari gawan a kaw naniwala kan Juan Bautista, hên nanoro ya hên tungkol ha pamimiyay ya mahonol kan Apo Namalyari, nahêlêk yo man ya naniwala ha intoro na, ya hilay mapanyag karawakan hên nanad hilay máningil buwih haka hilay hostis.” ");
INSERT INTO sgb_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Amêhên, nangalimbawa yay na êt hi Apo Jesus, ya wana kanlan ampanggilam, “Minghan main lalaki ya nag luta ya tinamnan nan ubas. Bayo binakoran nay habayto. Nangali yan pangiunaban hên ubas, haka ya êt namairêng hên tawer ya pagbantayan. Impatsiwala na ha kaatag ya ubasan na, ta maglaêh ya ha kaatag ya bansa. ");
INSERT INTO sgb_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Hên pamutsi hên habaytoy ubas, ay in-utoh nay tatloy ipoh na, hên kowên ya atag na kanlan paypaniwal-an ubasan na. ");
INSERT INTO sgb_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Noa, dinakêp lay ipoh na. Pinakahakitan lay mihay ipoh, pinatsi lay ikalwa haka pinagbabato lay ikatlo. ");
INSERT INTO sgb_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Hên namwangan nan nag ubasan ya nalyari kanlan tatloy ipoh na, ay mal-at êt ya in-utoh na kanan haton una, noa, êmbayro êt ya dinyag la kanlan habayto. ");
INSERT INTO sgb_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Hên ayn yay nan kaatag ya maiutoh, ya nag ubasan, ay in-utoh nay anlugurên nan anak nay lalaki, ta wana, ‘Siguradon igalang lay anak ko.’ ");
INSERT INTO sgb_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Noa, hên nahêlêk lan paypaniwal-an ubasan, ya anak nan nag ubasan, ay nihahabi hila, ya wanla, ‘Hatsi ya paypamanaan na hên ubasan. Patsên tamo ya, ta êmên mapagbandi tamo ya hata ubasan na.’ ");
INSERT INTO sgb_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kabay dinakêp la ya, pinaalíh la ya ha ubasan haka pinatsi la ya.” ");
INSERT INTO sgb_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Amêhên, kinotang ni Apo Jesus, hilay ampamaala ha Templo, “Hino kaya ya daygên hên nag ubasan kanlan paypaniwal-an na?” ");
INSERT INTO sgb_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Hinabi la, “Siguradon lakwên nay nangarawak ya paypaniwal-an na, ta patsên na hila, bayo ipatsiwala nay ubasan na ha taganán mam-in atag na no pamutsin ubas.” ");
INSERT INTO sgb_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Wana êt ni Apo Jesus kanlan ampamaala ha Templo, “Yarin a yo êt nabaha ya habaytsi ya nakahulat ha Kahulatan ya impahulat ni Apo Namalyari? ‘Ya bato ya intapon lan manyag bali, ay nag-in pinakamaalagáy bato ta êmên mag-in napah-êy ya bali. Dinyag ni Apo Namalyari ya habayto, ya kapapaêpapah.’” ");
INSERT INTO sgb_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Wana êt kanla, “Kabay anhabiên ko kamoyu, alwan hikaw ya Israelita ya milamo ha pamanlokop ni Apo Namalyari, noa hilay taganán ampanyag hên kalabayan na ya milamo bayro. ");
INSERT INTO sgb_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Hilay matata kanan hata bato ay mangatutukihan but-o, haka hilay matat-an hên hata bato ay mangatatapong.” ");
INSERT INTO sgb_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Naintindihan lan Pariseo haka hilay ampamaala kanlan pari, ya hila ya in-alimbawa di ha manyag bali, haka ha nangarawak ya paypaniwal-an hên ubasan. ");
INSERT INTO sgb_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kabay labay la yan dakpên hi Apo Jesus, noa, malimo hila ha kal-atan ta ha muwang lan kal-atan, hiyay mihay propeta ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Amêhên, nangalimbawa yay na êt hi Apo Jesus kanlan nangotang no antoy ubatan hên tungkulan na, ya wana, ");
INSERT INTO sgb_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ya pamanlokop ni Apo Namalyari ay maialimbawa ya êmên di: Main mihay ari ya nagkaluto, ta magkasal ya anak nay lalaki. ");
INSERT INTO sgb_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Hên nakalutoy na, ay in-utoh na hilay ipoh na hên baêgên hilay hinagyat na, noa, a hila mabay. ");
INSERT INTO sgb_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Namiutoh yay na êt hên kaatag ipoh, ta habiên la kanlan hinagyat na, ya êmên di, ‘Kaw na di ha kasálan, nakal-an ya kaên tamo. Main kay hên pinatsi ya baka haka hên pinataba ya biseron baka.’ ");
INSERT INTO sgb_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Noa, a la dinambi ya habayto ta inhundo la tanay andaygên la. Ya miha ay nammita ha panamnan na, haka ya miha ay nammitan nagtsinda. ");
INSERT INTO sgb_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ya kaatag ay nandakêp kanlan in-utoh ta pinairapan hila, bayo pinatsi. ");
INSERT INTO sgb_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Hadyay huluk hên habaytoy ari. In-utoh nay hundaloh na hên patsên hilay namatsin maipoh na, haka na impaulam ya balayan la. ");
INSERT INTO sgb_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Bayo hinabi na ha ungno kanlan kaatag ipoh na, ya nakal-an ya kaluto hên kasálan, noa, hilay hinagyat, ay alwan hêpat hên makiaêm ha kaluto. ");
INSERT INTO sgb_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kabay in-utoh na hilay ipoh na hên managyat kaganawan ya mahêlêk la ya atsi ha dann. ");
INSERT INTO sgb_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Hinagyat lay kaganawan ya nahêlêk la bayro ha dann, mangangêd man o nangarawak ya ugali la, haka napno ya panganan lan kaluto hên kasálan. ");
INSERT INTO sgb_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Amêhên, hinumwên ya ari ha panganan ta hêlkên na hilay impahagyat na. Noa, nahêlêk nay mihay lalaki ya a nakatakop hên indigalo na kanlan impahagyat na, ya dapat lan ihulod ha kasálan. ");
INSERT INTO sgb_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kabay wana kana, ‘Pata a mo inhulod ya impahulod kamo! Ay-êmên ka nakahowên di!’ Hatoy lalaki, ay ayn maipakibat. ");
INSERT INTO sgb_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Bayo wanan ari kanlan ipoh na, ya gapohên la ya gamêt haka bitsih na, ta ihamwag ya ha kariglêman. Hadyay tangih na bayro, haka mang-ngê-ngêt ya ha hadyay huluk na boy ha hadyay ilab ya angkatanam na. ");
INSERT INTO sgb_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ya labay habiên hên habaytoy alimbawa ko, ay mal-at ya hinagyat hên makilamo ha pamanlokop ni Apo Namalyari, noa, pêpêrad ya piliên na hên makilamo, gawan pêpêrad ya mapagtsiwal-an.” ");
INSERT INTO sgb_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Amêhên, immalíh hilay Pariseo ya nakagilam hinabi ni Apo Jesus, ta pinihahabian la no ay-êmên la yan madakêp ha pamaghabi na. ");
INSERT INTO sgb_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bayo namiutoh hilan ungnoy kalamo la, haka ungnoy kagampi ni Herodes Antipas kan Apo Jesus. Wanlan in-utoh kana, “Mánoro, muwang naên ya kaptêgan ya panhabiên mo haka pan-itoro mo. An-itoro moy kalabayan ni Apo Namalyari, ha hinoman ya ampanggilam gawan alwa kan mapamili, ta pantag ya panlêk mo ha balang miha. ");
INSERT INTO sgb_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kabay main kay hên labay mamwangan kamo. Ayon ha Kautuhan tamon Israelita, ay malyarin mam-in buwih kanan Emperador o ahê?” ");
INSERT INTO sgb_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Noa, muwang ni Apo Jesus ya karawakan la, kabay hinabi na kanla, ya wana, “Hikaw ya magbabaran mangêd, pata labay yo kon dakpên ha pamaghabi ko! ");
INSERT INTO sgb_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ipahlêk yo kangko ya sintimos hên pilak ya pamayad hên buwih.” Namiawah hilan habayto, ");
INSERT INTO sgb_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","bayo kinotang na hila, “Hinoy nag lupa hên angkakit yo bahên? Hinoy nag langan ya nakahulat bahên?” ");
INSERT INTO sgb_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Hinabi la, “Kanan Emperador.” Kabay wani Apo Jesus, “No êmbayro awud, ay idin yo kanan Emperador ya kana, haka idin yo kan Apo Namalyari ya kan Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Hên nagilam lay hinabi na, ay nag-êpapah hila. Kabay nammita hilay na. ");
INSERT INTO sgb_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Habayton allo êt, ay main ungno kanlan Israelita ya ambaêgên Saduseo ya dinumani kan Apo Jesus. Hilay Saduseo ay a ampaniwala ha pangabiyay oman. Haka hinabi la kan Apo Jesus, ya wanla, ");
INSERT INTO sgb_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Mánoro, nanulat ya hi apo Moises ha Kautuhan, ya wanan hulat, ‘No main mitaahawa, ta natsi ya lalaki hên a hila nagkaanak, ay dapat ya kahonol nan natsi, ay ipaahawa kanan bawo. No magkaanak hila, ay habaytoy anak, ay itad anak na hên natsi.’ ");
INSERT INTO sgb_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Minghan, ay main pitoy mikakahonol ya lalaki. Nakapag-ahawa ya punganay, noa, natsi ya hên a ya nagkaanak. Bayo pinag-ahawa nan humonol ha punganay ya hata bawo. ");
INSERT INTO sgb_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Noa, natsi ya etaman ya humonol ha punganay hên a ya nagkaanak. Êmbayro êt ya nalyari ha ikatlon kahonol. Balang miha kanlan pitoy mikakahonol ay nakapag-ahawa hên hata babayi, noa, naubuh hilan natsi hên a nagkaanak. ");
INSERT INTO sgb_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Bayo natsi ya êt ya hata bawo. ");
INSERT INTO sgb_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Amêhên, ha allon pangoman mabiyay, hinoy nay taganán mag-in ahawa nan hata babayi, ta balang miha kanlan habaytoy pitoy mikakahonol ay nag-in ahawa na?” ");
INSERT INTO sgb_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Kabay wani Apo Jesus kanlan Saduseo, “Mali ya paniwala yo, ya a biyayên oman ya natsi, gawan a yo angkaintindihan ya Kahulatan ya impahulat ni Apo Namalyari haka a yo angkaintindihan ya kapangyarihan na! ");
INSERT INTO sgb_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ha pangoman biyayên hilay natsi, ay ayn nanan pamag-ahawa, ta maubuh hilay nan manoto kanlan anghel ha langit ya a ampag-ahawa. ");
INSERT INTO sgb_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ya hulat man ni apo Moises ay ampamaptêg ya hilay natsi ay biyayên oman, ta bayro ha hulat na ay mabáha tamo ya hinabi ni Apo Namalyari, ");
INSERT INTO sgb_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Hikoy Diyos ni Abraham, Isaac, haka Jacob.’ Hiya ya Diyos lan angkabiyay, ta balang miha ya natsi, ay angkabiyay ha hêlêk na.” ");
INSERT INTO sgb_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nikaêpapah hilay kal-atan ha pamanoro na. ");
INSERT INTO sgb_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ni-tsi-tsipon hilay Pariseo gawan nagilam la, ya ayn hilan mahabi, ya hilay Saduseo, ha hinabi ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Main miha kanla ya taganán main kamwangan ya tungkol ha Kautuhan ni apo Moises ya nakagilam hên pamakipalinawan la. Labay na yan subukên hi Apo Jesus, kabay nangotang ya kana, ");
INSERT INTO sgb_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mánoro, hinoy pinakamaalagáy utoh ha Kautuhan ni apo Moises?” ");
INSERT INTO sgb_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Hinabi ni Apo Jesus, “‘Lugurên mo hi Apo Namalyari, ya Panginoon hên boon nakêm, boon ihip, haka boon hêkaw.’ ");
INSERT INTO sgb_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Habaytoy pinakamaalagáy utoh. ");
INSERT INTO sgb_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ya ikalwan pinakamaalagáy utoh ay ‘Lugurên moy kapareho mo hên nanad pamanlugud mo ha lawini mo.’ ");
INSERT INTO sgb_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Bayro ha loway utoh, ay imboo ya Kautuhan ni Apo Namalyari ya impahulat na kan apo Moises, haka ya toro lan propeta ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Hên naka-tsipon hila pon bayro hilay Pariseo, ay kinotang na hila ni Apo Jesus, ");
INSERT INTO sgb_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ha ihip yo, ay hino ya Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala? Hinoy nag-anak kana?” Wanla etaman, “Hiyay kaapo-apoan ni Arin David.” ");
INSERT INTO sgb_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Wanay na êt kanla, “Pata binaêg ni Arin David ya Mesias, ya Cristo, hên ‘Panginoon ko’ hên hinabi nay humonol ya habi ha kapangyarihan nan Espiritu ni Apo Namalyari? ");
INSERT INTO sgb_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Hinabi ni Apo Namalyari ha Panginoon ko, “Mikno ka ha dapit panabtab ko hên mamaala hên kalamo ko, angga ha mahambut ko hilay kapatsi mo, ta idin ko hila ha aypan kapangyarihan mo.”’ ” ");
INSERT INTO sgb_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Wana êt ni Apo Jesus, “Hên hato, ay hi Arin David ya namaêg hên ‘Panginoon ko’ ha Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala. Kabay muwang tamo, ya hiyay Panginoon haka kaapo-apoan ni Arin David.” ");
INSERT INTO sgb_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Miha man kanla, ay ayn makaihip hên mahabi la kana. Paubat hên habayto ay marêng-êy hilay na hên mangotáng pon kan Apo Jesus ya hilay labay hên mandakêp kana ha pamaghabi na. ");
INSERT INTO sgb_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Amêhên, wani Apo Jesus kanlan kal-atan haka kanlan tagahonol na, ya wana, ");
INSERT INTO sgb_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Hilay mánoron Kautuhan ni apo Moises, haka hilay Pariseo, ay dinyanan tungkulan hên mamipamulah hên Kautuhan ni Apo Namalyari ya hinulat ni apo Moises. ");
INSERT INTO sgb_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kabay daygên yoy an-itoro la kamoyu. Noa, paan yon totoên ya pamimiyay la, gawan a la anhonolên ya an-itoro la. ");
INSERT INTO sgb_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bapan bêyat ya an-ipadyag la kanlan kaatag, noa, pêrad man, ay a hila ampanawop. ");
INSERT INTO sgb_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ya kaganawan dyag la, ay ampagpadayêw ha kaatag. Angkahlayên lay pamyanan lan habi ni Apo Namalyari ya an-iiptêh la ha dampal haka takiyay la, haka la êt angkarangên ya pahamoy ya pampahampat hên takop la. ");
INSERT INTO sgb_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ampiliên lay pinakamangêd ya iknoan ha sinagoga haka ha kaluto, ta êmên ipamwang ya matag-ay ya tungkulan la. ");
INSERT INTO sgb_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Labay la êt hên galangên, hilan kal-atan ha balayan haka baêgên hilan ‘Mánoro.’ ");
INSERT INTO sgb_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Noa, hikaw, ay paan yon paulayan hên baêgên kaw ‘Mánoro’ gawan mipapatêl kaw, haka hikon bat ya mánoro yo. ");
INSERT INTO sgb_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Haka paan yon baêgên ‘Tatang’ ya kaatag kamoyu di ha luta, ta mimihay Tatang yo, yabay ya hi Apo Namalyari ya atsi ha langit. ");
INSERT INTO sgb_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Haka paan yon paulayan hên baêgên kaw ‘Tagapagtoro’ ta mimihay Tagapagtoro yo, yabay ya Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala. ");
INSERT INTO sgb_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ya labay mag-in pinakamatag-ay ya tungkulan, ay dapat huyuên nay kapareho na. ");
INSERT INTO sgb_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Hilay mapagmatag-ay, ay iaypa haka hilay maaypa ya nakêm ay itag-ay.” ");
INSERT INTO sgb_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Kaingalo kaw ya mánoron Kautuhan ni apo Moises haka hikaw ya Pariseo! Ampagbabara kaw! Hikaw ay ampag-in habkol lan mabay makapakilamo ha pamanlokop ni Apo Namalyari. A kaw palokop, bayo ambawalên yo hilay mabay hên palokop. ");
INSERT INTO sgb_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Kaingalo kaw ya mánoron Kautuhan ni apo Moises haka hikaw ya Pariseo! Anlokoên yo hilay bawo ya babayi, ta êmên yo makwa ya pibandian la, bayo ampagbabara kaw ya mangêd kaw ta an-ikarang yoy panalangin yo ha arapan hên kal-atan. Kabay hadyay pamarusa kamoyu lano. ");
INSERT INTO sgb_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kaingalo kaw ya mánoron Kautuhan ni apo Moises haka hikaw ya Pariseo! Ampagbabara kaw! Ta anlumagay kaw ha ay-iri man ya logal, ta êmên yo mapapaniwala ha toro yo, ya miha man ya alwan Israelita. Bayo no mapapaniwala yo yay na, ay habaytoy taganán makapilako kana ha impiyerno, ta hiyay mag-in hadyay dawak êt kamoyu! ");
INSERT INTO sgb_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kaingalo kaw ya mánoron Kautuhan ni apo Moises haka hikaw ya Pariseo! Ta hikaw ay nanad ha mihay buwag ya ampangakay ha kapareho nan buwag. Pandaygên yon ayn alagá ya pamanumpa ha Templo ya pagsimbaan kan Apo Namalyari. Noa, pandaygên yon maalagá ya pamanumpa ha ginto ya atsi ha Templo! ");
INSERT INTO sgb_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Hikaw ya nanad buwag! Mulala kaw! Hino ya pinakamaalagá kanlan lowa, ya ginto o ya Templo ya ampam-in alagá ha ginto? ");
INSERT INTO sgb_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Pandaygên yon ayn alagá ya pamaghumpa ha pamiulaman hên an-iátang kan Apo Namalyari ha Templo. Noa, pandaygên yon maalagá ya pamaghumpa ha an-iátang. ");
INSERT INTO sgb_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Taganán buwag kaw! Hino ya pinakamaalagá kanlan lowa, ya indigalo ha pamiulaman hên an-iátang kan Apo Namalyari, o ya pamiulaman ya ampam-in alagá ha an-iátang? ");
INSERT INTO sgb_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kabay hilay maghumpa ha pamiulaman hên an-iátang kan Apo Namalyari ha Templo, ay ampaghumpaan la ya an-iátang etaman. ");
INSERT INTO sgb_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Hilay maghumpa ha Templo, ay ampaghumpa kan Apo Namalyari ya atsi ha Templo. ");
INSERT INTO sgb_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Hilay maghumpa ha langit, ay ampaghumpa kan Apo Namalyari ya ampamaala hên ubat bayro. ");
INSERT INTO sgb_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kaingalo kaw ya mánoron Kautuhan ni apo Moises haka hikaw ya Pariseo! Ampagbabara kaw! Mangêd ya an-idin yo kan Apo Namalyari ya ikamapo hên bulong ya pan-ihabug yo ha habaw yo, noa, angkapaulayan yoy maalagáy Kautuhan, ya katoynungan, haka ya ingalo ha kapareho yo, haka ya mag-in mapaniwal-an. Mu-muna kailangan yon dyanan alagá ya habayto kaban ihundo yoy pam-i yon ikamapo. ");
INSERT INTO sgb_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Hikaw ay nanad ha buwag ya ampangakay ha kapareho lan buwag. Andaygên yoy kaatag ya dapat daygên, noa, angkapaulayan yoy pinakamaalagá! ");
INSERT INTO sgb_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kaingalo kaw ya mánoron Kautuhan ni apo Moises haka hikaw ya Pariseo! Ampagbabara kaw! Hikaw ay maialimbawa ha mihay ampanguyah bat hên bulin baso haka bokot pinggan, gawan a yon an-uyahan ya mantêg dêmêk, ta ampaulayan yoy nakêm yo, ya hadyay kahibaan, haka ayn pamagpigil ha sarili. ");
INSERT INTO sgb_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Buwag kaw ya Pariseo! Unaên yon bayoên ya nakêm yo ta ha êmbayro ay mag-in bayo etaman ya pamimiyay yo. ");
INSERT INTO sgb_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kaingalo kaw ya mánoron Kautuhan ni apo Moises haka hikaw ya Pariseo! Ampagbabara kaw! Noa, nanad kaw pantson ya pinintoraan ya mahampat hêlkên, ya napnon but-o haka bangkay ya anggumata. ");
INSERT INTO sgb_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ta ha hêlêk lan kapareho yo ay mahonol kaw ha Kautuhan, noa, ha kaptêgan, ay ampagbabara kaw, haka panay karawakan ya laman nakêm yo.” ");
INSERT INTO sgb_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kaingalo kaw ya mánoron Kautuhan ni apo Moises haka hikaw ya Pariseo! Ampagbabara kaw! Ampamadyag kaw hên pantson lan propeta ni Apo Namalyari. Haka ampapakahampatên yoy pinangilbêngan kanlan nag-in mahonol kana. ");
INSERT INTO sgb_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Haka anhabiên yo êt ya, ‘No atsi kay dayi ha luta hên hato, ay a naên hila impapatsi hilay propeta ni Apo Namalyari.’ ");
INSERT INTO sgb_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ha pamaghabi yon habayto, ay ampamaptêg kaw, ya hikaw ay kaapo-apoan lan nammatsi kanlan propeta ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Hali! Ihundo yoy pamanyag karawakan ya inumpisaan lan ninuno yo! ");
INSERT INTO sgb_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nanad kaw utan ya makamatsi, ya ampipag-ahug ha angkaulam! Yarin makatakah kaw ha kaparusaan ha impiyerno! ");
INSERT INTO sgb_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kabay iutoh ko kamoyu ya hilay propeta ni Apo Namalyari, haka hilay manga-talino, haka hilay ampanoron kalabayan ni Apo Namalyari. Ya kaatag ay patsên yo ha koros. Ya kaatag ay pagpapatokên yo ha sinagoga yo, haka ya kaatag êt, ay pakikamat-kamatên yo ha ay-iri man ya balayan. ");
INSERT INTO sgb_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kabay parusaan kaw, gawan ha pangamatsi lan mahonol kan Apo Namalyari, paubat hên pinatsi hi Abel, ya ayn kasalanan, angga ha pinatsi hi Zacarias ya anak ni Baraquias, ya pinatsi lan ninuno yo ha Templo ha pilatan hên paypaahukan ya panalanginan haka ya pamiulaman hên an-iátang kan Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Pakagilamên yo, parusaan kaw ya angkabiyay amêhên gawan ha pangamatsi lan habayto.” ");
INSERT INTO sgb_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Hinabi nay na êt ni Apo Jesus, ya wana, “Kaingalo kaw ya taga-Jerusalem, ta pinatsi yoy propeta ni Apo Namalyari, haka pinagbabato yon pinatsi hilay kaatag ya in-utoh kamoyu. Kata-ungno kataw nan labay lokopên hên nanad ha pamanlokop hên manok ha hiwhiw na. Noa, a kaw mabay hên palokop kangko. ");
INSERT INTO sgb_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Pakagilamên yo! Booy nakêm nan paulayan ni Apo Namalyari ya balayan haka Templo yo. ");
INSERT INTO sgb_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Pakagilamên yo! Paubat amêhên, ay a yo ko pon mahêlêk, angga ha a yo habiên ya hatsi ya habi, ‘Iningalwan ya in-utoh ni Apo Namalyari.’” ");
INSERT INTO sgb_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Hên immawah hi Apo Jesus ha Templo, kaban ampammita ya, ay napaidani kana ya tagahonol na, ta intoro la kana ya kahampatan hên Templo. ");
INSERT INTO sgb_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Amêhên, hinabi ni Apo Jesus, ya wana, “Lumatêng lanoy allo, ay manga-aagwat ngan ya hata bato ya pinaglolog ya angkahêlêk yo.” ");
INSERT INTO sgb_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Amêhên, hên pamakalakat lan Apo Jesus ha Tawgtug Olibo, hên kakapag la tana, ay nangotang hilay tagahonol na kana, ya wanla, “Habiên mo kannaên no makanon malyari ya habayto, haka no ay-êmên naên mamwangan no marani yanay pamag-orong mo di, haka makano ya anggaan hên luta.” ");
INSERT INTO sgb_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Kabay wani Apo Jesus, “Kaillag kaw, ta êmên a kaw maloko, ");
INSERT INTO sgb_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ta mal-at ya maghabin êmên di, ‘Hiko ya Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala.’ Gawan bayro, ay mal-at ya maloko la. ");
INSERT INTO sgb_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Paan kaw malimo ha magilaman yoy tungkol ha manigulo-gulo haka pa-tsian, ta habayto ay kailangan lumatêng pon, noa, a pon tambêng lumatêng ya anggaan hên luta. ");
INSERT INTO sgb_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Milalaban hilay bansa haka hilay angkalokopan hên mihay bansa ay milalaban ha kabansa la. Lumatêng ya mangakhaw ya layon ha ay-iri man ya logal. Lumatêng êt ya hadyay lonoh. ");
INSERT INTO sgb_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Noa, habayto ay umpisan bêngat hên hadyay kairapan, hên nanad ha umpisan pan-umilab hên ampanganak. ");
INSERT INTO sgb_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Kanan habayto ay kahêmêkan kaw hên tawo ha balang bansa gawan ha paniwala yo kangko. Gêtan la kaw ha manungkulan, ta parusaan haka patsên. ");
INSERT INTO sgb_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kanan habayto, ay mal-at ya maalihan hên paniwala. Mikakahêmêk hila haka miuupit. ");
INSERT INTO sgb_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mal-at ya lumtaw ya magbabara ya hila ay propeta ni Apo Namalyari, kabay mal-at ya mapapaniwala la ha alwan pêtêg ya paniwala. ");
INSERT INTO sgb_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Gawan ha parawak hên parawak hilay atsi bayri ha boon luta, ay papêrad anan papêrad hilay ampanlugud. ");
INSERT INTO sgb_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Noa, hilay makahundo ha paniwala la kangko, angga ha anggaan biyay la, agyan ampagdanas hila hên hadyay kairapan, ay madyanan hên biyay ya ayn angga. ");
INSERT INTO sgb_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Maipamwang pon kanlan tawo ha balang bansa ya Mangêd ya Habi tungkol ha pamanlokop ni Apo Namalyari, bayo lumatêng ya anggaan hên luta.” ");
INSERT INTO sgb_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Inhundo ni Apo Jesus ya pamaghabi na, ya wana, “No mahêlêk yoy nay kapaparêng-êy ya hadyay karawakan ya malyari ha Templo ni Apo Namalyari, ay matupad ya habaytoy inungkat ni Propeta Daniel.” Hikaw ya ampamaha ay pakaintindiên yoy habaytsi! ");
INSERT INTO sgb_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Ha allon habayto ay kailangan muwayun lumakat ha babo, ya hilay taga-probinsyan Judea. ");
INSERT INTO sgb_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Habaytoy allo, no main atsi ha bubungan bali la, ay dapat tampol hilan tumaoy hên muwayun hên lumakat ha babo! Paan hilay nan mangwan pibandian la ha lalên bali la! ");
INSERT INTO sgb_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Paan hilay nan muli ya atsi ha panamnan hên mangwan pangkêbêl la! ");
INSERT INTO sgb_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kanan habayto, ay kaingalo hilay nabuktot haka hilay ampamahoho. ");
INSERT INTO sgb_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ihalangin yo, ya a dayi malyari ha panaon hên kêbêl o ha allon pamagsimba, ya habaytoy pammuwayu yo hên magtago. ");
INSERT INTO sgb_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ta di ha luta ay maranasan ya hadyay kairapan, ya ayn kapantag paubat hên dinyag ni Apo Namalyari ya hata luta angga amêhên. Haka ahina maranasan oman ya êmbayroy kairapan. ");
INSERT INTO sgb_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","No mabuyot ya habaytoy kairapan, ay ayn nanan mabiyay di ha luta, noa, gawan bat ha ikakangêd lan pinili na hên mag-in kana, ay tinalagá ni Apo Namalyari hên paipêkên ya habaytoy panaon. ");
INSERT INTO sgb_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Kanan habaytoy panaon, no main maghabin, ‘Atsi ya bayri ya Mesias, ya Cristo, ya Mámiligtas, o atsi ya bayro,’ ay paan kaw maniwala kanla. ");
INSERT INTO sgb_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ta main magbabara hên hila ay Cristo, haka main êt kaatag ya magbabara hên hila ay mámipamwang hên an-ipaihip kanla ni Apo Namalyari. Mamipahlêk hilan kapapaêpapah ta labay lan mámungaw ya hilay pinili ni Apo Namalyari hên mag-in kana. ");
INSERT INTO sgb_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kabay kaillag kaw! In-ubuh kinan hinabi ya malyari, ta êmên a kaw pamungaw kanla. ");
INSERT INTO sgb_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“No main maghabi, ‘Atsi ya bayro ya Cristo ha kabalah-balahan!’ o ‘Atsi ya bayri ha lalên bali!’ ay paan kaw maniwala. ");
INSERT INTO sgb_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ta no ay-êmên magkulibid ya kimat, ya mag-ahnag ha marayo, haka mahêlêk hên balang miha, ay êmbayro êt ya pag-orong ko, hên Taga-Langit, ya In-anak Tawo. ");
INSERT INTO sgb_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ya pag-orong ko ay taganán mamwangan, no ay-êmên taganán mamwangan ya main bangkay ha pagtsiponan lan uwak.” ");
INSERT INTO sgb_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Wana êt ni Apo Jesus, “Pangayarin habaytoy hadyay kairapan, ay dumiglêm ya allo, haka ahina humawang ya buwan, mangatata ya bêtêwên, haka maubuh hên mangayêgyêg ya angkahêlêk ha langit. ");
INSERT INTO sgb_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kanan habayto, ay mahêlêk hên palatandaan ha langit ya lumatêng ako, ya Taga-Langit, ya In-anak Tawo. Mipanyêngên hila bayto ya a naniwala kangko, ta mahêlêk ako, ha lêmm, ya anlumatêng, hên kalamoy kapangyarihan ko, haka kahampatan hawang ya a makwan ihipên. ");
INSERT INTO sgb_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kayêpan ya tambuyok hên hadyay hêkaw. Kanan habayto, ay iutoh ko hilay anghel ko ha kaganawan bansa ha boon luta, ta êmên la tsiponên ya pinili ni Apo Namalyari hên mag-in kana.” ");
INSERT INTO sgb_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Bayo wani Apo Jesus, “Mangwa kaw hên aral ha poon kayon igos. No mamayo yan bulong, ay muwang yoy na bayto ya marani yanay kaingitan. ");
INSERT INTO sgb_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Êmbayro êt, no mahêlêk yoy nan maubuh hên malyari ya habayto ya kapapalimo, ay mamwangan yoy taganán marani yanay pamag-orong ko. ");
INSERT INTO sgb_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Pakagilamên yo. Maubuh hên matupad ya habayto kaban main pon di ha luta hên kapareho yon Israelita. ");
INSERT INTO sgb_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ya luta haka ya angkahêlêk ha langit ay main anggaan, noa, ya habi ko ay ayn anggaan.” ");
INSERT INTO sgb_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Wanay na êt ni Apo Jesus, “Ayn ampakamwang no hinon allo, o oras ya pag-orong ko. Hila man ya anghel ha langit, o hiko man ya Anak ni Apo Namalyari, ay a ampakamwang hên habayto. Hiyan bat hi Apo Namalyari ya Tatang tamo, ya nag muwang. ");
INSERT INTO sgb_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","No ay-êmên ya karawakan pamimiyay la hên haton nabiyay hi apo Noe, ya nagpalokop kan Apo Namalyari, ay êmbayro êt mag-in narawak ya pamimiyay no marani yanay pag-orong ko, hên Taga-Langit, ya In-anak Tawo. ");
INSERT INTO sgb_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Hên haton nabiyay hi apo Noe, ay a la ginilam ya pamwang na. Inhundo lan angkabiyay hên hato ya pangan, pamamminêm, haka pamiaahawa la angga ha hinumwên hilan apo Noe ha dinyag nay barko. ");
INSERT INTO sgb_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ayn ha ihip lan a nipanggilam kan apo Noe ya malyari kanla, angga ha bigla hilan nahalipawan lanêm haka naubuh hilan nilêmêh. Êmbayro êt kabigla ya pag-orong ko, hên Taga-Langit, ya In-anak Tawo. ");
INSERT INTO sgb_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ha pag-orong ko, no alimbawa ta main loway lalaki ya ampilamo hên ampag-obra ha panamnan, ya ampaniwala ay gêtan ha langit, noa, ya a ampaniwala ay ibalag ta parusaan. ");
INSERT INTO sgb_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","No alimbawa ta main loway babayi ya ampanggiling, ya ampaniwala ay gêtan ha langit, noa, ya a ampaniwala ay ibalag ta parusaan. ");
INSERT INTO sgb_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Dapat panay kaw nakal-an, ta a yo muwang no makano ya pag-orong ko, ya Panginoon yo. ");
INSERT INTO sgb_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pakaihipên yoy hatsi, no muwang na dayi hên nag bali no hinon oras ya pamanlumatêng hên manakaw, ay taganán maglêan ya, haka a na paulayan hên mahowên ya bali na. ");
INSERT INTO sgb_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Hikaw man, ay kailangan nakal-an, ta hiko ya Taga-Langit, ya In-anak Tawo, ay biglan lumatêng.” ");
INSERT INTO sgb_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Wanay na êt ni Apo Jesus, “Ya ipoh ya mapaypaniwal-an haka matalino, ay hiya ya dyanan tungkulan no main yan lakwên ya amo na. Hiya ya manalan bali na, haka mami-arasyon hên iluto lan kapareho nan ipoh, hên allo-allo. ");
INSERT INTO sgb_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Hadyay higla hên ipoh, no malatêng na yan amo na hên ampanyag kalabayan na ha pag-orong na. ");
INSERT INTO sgb_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Pakagilamên yo, dyanan na yan tungkulan hên amo na hên manalan hên kaganawan pibandian na. ");
INSERT INTO sgb_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Noa, no alimbawa ta narawak ya habaytoy ipoh, ta an-ihipên na ya mabuyot pon lumatêng ya amo na, ");
INSERT INTO sgb_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","bayo umpisaan na hên pakatumbukên ya kapareho nan ipoh, ya lalaki boy babayi, ta mangan ya tana haka maglahing, ");
INSERT INTO sgb_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","haka biglan lumatêng ya amo nan hatoy ipoh, ");
INSERT INTO sgb_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ay parusaan nay ipoh na hên hadyay bêyat. Bayo pakilamo na ya kanlan magbabara, bayro ha parusa ya ayn angga. Hadyay tangih na bayro, haka mang-ngê-ngêt ya ha hadyay huluk na boy ha hadyay ilab ya angkatanam na.” ");
INSERT INTO sgb_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Inhundo ni Apo Jesus ya pamaghabi na, ya wana, “Habaytoy pamanlumatêng hên pamanlokop ni Apo Namalyari, ay maialimbawa ya êmên di: Main mapoy dalaga ya nanupa ha mihay lalaki ya an-ikasal. Balang miha kanla, ay main pag-atáng. ");
INSERT INTO sgb_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ya lima kanla ay ayn minúwang, haka ya lima ay matalino. ");
INSERT INTO sgb_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ya limay ayn minúwang, ay a nantan hên laro ya pag-gas hên pag-atáng la no maubuh ya laman hên pag-atáng la. ");
INSERT INTO sgb_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Noa, hilay limay manga-talino, ay nantan hên laro ya pag-gas la no maubuh ya laman hên pag-atáng la. ");
INSERT INTO sgb_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Hên niabala ya pamanlumatêng hên lalaki ya an-ikasal, ay nabêlêw hilay mapoy dalaga. ");
INSERT INTO sgb_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Noa, hên bonak yabi, ay main hên nan-angaw, ya wana, ‘Anlumatêng yay nay lalaki ya an-ikasal! Tupaên yo yay na!’ ");
INSERT INTO sgb_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tampol hila etaman nimata ya mapoy dalaga ta in-il-an lay nay pag-atáng la. ");
INSERT INTO sgb_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Hinabi lan limay dalaga ya ayn minúwang kanlan manga-talino, ‘Dyanan yo kay etaman hên laro ya pag-gas naên ta ampangulipêndêng ya pag-atáng naên.’ ");
INSERT INTO sgb_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Noa, wanlan limay manga-talino, ‘Kayno a mihukad kantamon mapo ya habaytsi. Mangêd ay manaliw kaw pon ha magtsinda.’ ");
INSERT INTO sgb_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kabay nammita hilay nay limay ayn minúwang hên nanaliw. Noa, kaban ayn hila bayro, ay nilumatêng ya lalaki ya an-ikasal. Haka hilay limay manga-talino ya nakal-an, ay nakalamo hên hinumwên ha pangasalan, bayo impapakahara ya kabat. ");
INSERT INTO sgb_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“A nabuyot ay nilumatêng ya limay ayn minúwang ta namaêg hila, ‘Apo, Apo, pahowênên mo kay!’ ");
INSERT INTO sgb_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Noa, wana kanla, ‘A kataw kilala!’ ");
INSERT INTO sgb_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kabay dapat panay kaw nakal-an, ta a yo muwang no makano ya pag-orong ko, hên Taga-Langit, ya In-anak Tawo.” ");
INSERT INTO sgb_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Impamwang ni Apo Jesus kanla no ay-êmên ya pamimiyay ha pamanlokop ni Apo Namalyari kaban an-êngganan lay pag-orong na, ya wana, “Main mihay lalaki, ya mita ha marayo. Bayo ya nammita ay binaêg na hilay ampaghuyo kana ta impatsiwala na kanla ya pibandian na. ");
INSERT INTO sgb_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Dinyanan hilan palak-ên la hên balang miha ha agyu la, ya peran ginto. Ya miha ay dinyanan nan limay pera ya ginto. Ya miha pon ay dinyanan nan loway pera ya ginto. Haka ya miha pon ay dinyanan nan mihay pera ya ginto. Bayo nammita yay na. ");
INSERT INTO sgb_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Hatoy dinyanan limay pera ya ginto ay nakatubo hên limay pera ya ginto. ");
INSERT INTO sgb_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Êmbayro êt ya dinyanan loway pera ya ginto ay nakatubo ya êt hên loway pera ya ginto. ");
INSERT INTO sgb_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Noa, ya hatoy nananggap hên mihay pera ya ginto, ay nangalin luta ta bayro nan inhinêp ya pera hên amo na. ");
INSERT INTO sgb_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Hên nabuyot yay na ha nilako na, ay nag-orong hatoy amo ya namatubo hên pera na, ta êmên na mamwangan no ungnoy tubo lan ampaghuyo kana ha imbalag nay pera kanla. ");
INSERT INTO sgb_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kabay napaidani ya hatoy dinyanan limay pera ya ginto, ta wana ha amo na, ya nakatubo yan lima ya pera ya ginto. ");
INSERT INTO sgb_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Wana kana hên amo na, ‘Magaling ka! Hika ay mihay mangêd ya tagahuyo. Gawan mapaypaniwal-an ka ha pêrad, ay manalan ka hên mal-at. Ilamo kata ha kahiglaan ko.’ ");
INSERT INTO sgb_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Napaidani êt ya hatoy dinyanan loway pera ya ginto, ta wana ha amo na, ya nakatubo yan loway pera ya ginto. ");
INSERT INTO sgb_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Wanan amo kana etaman, ‘Magaling ka! Hika ay mihay mangêd ya tagahuyo. Gawan mapaypaniwal-an ka ha pêrad, ay manalan ka hên mal-at. Ilamo kata ha kahiglaan ko.’ ");
INSERT INTO sgb_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Amêhên, nilumatêng yay na êt ya dinyanan mihay peran ginto, ta wana ha amo na, ‘Apo, muwang ko ya hadyay igpit mo. Ampangwa ka hên alwa mon pinaghayngêtan, bayo ampamutsi kan alwa mon intanêm. ");
INSERT INTO sgb_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Gawan malimo ko kamo, ay ingkali ko hên inhinêp ha luta ya pera mo. Hêlkên mo, atsi ya pera moy ginto.’ ");
INSERT INTO sgb_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Hinabi hên amo na, ‘Narawak ka, haka nabarog! Muwang mo awud ya hadya kon igpit. Ampangwa kon alwa kon pinaghayngêtan, bayo ampamutsi ko hên alwa kon intanêm! ");
INSERT INTO sgb_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","No êmbayro awud, ay awta a mo indin ya pera ko ha bangko, ta êmên mo dayin maiorong kangko ya habayto hên kalamoy tubo na ha bangko!’ ");
INSERT INTO sgb_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Bayo wana kanlan kaatag ya ampaghuyo kana, ‘Kowên yoy peray ginto, ya atsi kana, ta idin yo ha main mapo. ");
INSERT INTO sgb_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Hilay nakatubo hên indin kanla, ay dyanan ko pon êt. Noa, hilay a nakatubo hên indin kanla, ay alihên êt kanla ya pêrad ya atsi kanla. ");
INSERT INTO sgb_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Hata ipoh etaman, ya ayn pukat, ay itapon yo ha hadyay kariglêman. Hadyay tangih na bayro, haka mang-ngê-ngêt ya ha hadyay huluk na boy ha hadyay ilab ya angkatanam na.’” ");
INSERT INTO sgb_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ha pag-orong ko, ya Taga-Langit, ya In-anak Tawo, ay atsi kangko ya kapahilêw ya kahampatan hên panga-Diyos ko, hên kalamo ko hilay anghel ni Apo Namalyari. Bayro kinan mamaala. ");
INSERT INTO sgb_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Kanan habayto ay maubuh hên paitsipon ha arapan ko hilay ubat ha balang bansa. Ubuhên ko hilan pipapawaên hên nanad ha pamipapawa lan magpastol hên tupa haka kambing. ");
INSERT INTO sgb_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Hilay mapanyag kangêran, ya maialimbawa ha tupa ay idin ko ha dapit panabtab ko, haka hilay mapanyag karawakan ya maialimbawa ha kambing, ay idin ko ha dapit uki ko. ");
INSERT INTO sgb_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Bayo wangko, ya Ari la, kanlan atsi ha dapit panabtab ko, ‘Hikaw ya iningalwan hên Tatang ko, ay humwên kaw na, ta paidi kaw ha pamanlokop ko, ya in-il-an na para kamoyu paubat hên dinyag ya luta. ");
INSERT INTO sgb_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ta hên nilonoh ako, ay pinakan yo ko. Hên naangan ako, ay pinainêm yo ko. A yo ko man muwang, ay pinahowên yo ko. ");
INSERT INTO sgb_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Hên ayn akon maitakop, ay dinyanan yo kon maitakop. Hên nagkahakit ako, ay hinayhay yo ko. Hên nakahukul ako, ay hiniraw yo ko.’ ");
INSERT INTO sgb_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Bayo hinabi la kangko hên hilay mahonol kana, ‘Panginoon, nakano naên kan pinakan hên nilonoh ka? Nakano naên kan pinainêm hên naangan ka? ");
INSERT INTO sgb_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nakano naên kan pinahowên hên a naên ka muwang? Nakano naên kan dinyanan takop? ");
INSERT INTO sgb_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nakano naên kan hiniraw hên nagkahakit ka, o nakahukul ka?’ ");
INSERT INTO sgb_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Bayo habiên ko, ya ari la, kanla, ‘Pakagilamên yo, ha pamanawop yo kanlan kapareho yon ampaniwala, ya pinakamaaypa man ha hêlêk lan kaatag, ay hiko ya hinawpan yo.’ ");
INSERT INTO sgb_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Bayo wangko, kanlan atsi ha dapit uki ko, ‘Hikaw ya pinanlêan ni Apo Namalyari hên parusa, pakarayo kaw kangko, magtagloh kaw ha impiyerno ha apoy ya taganán a maparê ya inlêan ni Apo Namalyari para kan Satanas haka hilay kalamo nay nangarawak ya anghel. ");
INSERT INTO sgb_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ta hên nilonoh ako, ay a yo ko pinakan. Hên naangan ako, ay a yo ko pinainêm. ");
INSERT INTO sgb_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Hên a yo ko muwang, ay a yo ko pinahowên. Hên ayn akon maitakop, ay a yo ko dinyanan takop. Hên nagkahakit, haka nakahukul ako, ay a yo ko hiniraw.’ ");
INSERT INTO sgb_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Bayo hinabi la kangko hên hilay mapanyag karawakan, ‘Panginoon, nakano naên kan a pinakan, o a pinainêm hên naangan ka? Nakano naên kan a pinahowên hên a naên ka muwang? Nakano naên kan a dinyanan takop? Nakano naên kan a hiniraw hên nagkahakit ka, o nakahukul ka?’ ");
INSERT INTO sgb_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Bayo habiên ko kanla, ‘Pakagilamên yo, ha a yo pamanawop kanlan kapareho yo, ya pinakamaaypa ha hêlêk lan kaatag, ay hiko ya a yo hinawpan.’ ");
INSERT INTO sgb_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Bayo mipalako hilay mapanyag karawakan ha parusa ya ayn anggaan, noa, hilay mahonol kana, ay mipalako ha biyay ya ayn anggaan ha langit.” ");
INSERT INTO sgb_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Hên naubuh nay nan naitoro ni Apo Jesus ya habayto, ay hinabi na kanlan tagahonol na, ya wana, ");
INSERT INTO sgb_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Muwang yoy lowa tanay allo bayo mag Pistan Pangaligtas ha Egipto, haka hiko, ya Taga-Langit, ya In-anak Tawo, ay ipulong ta patsên ha koros.” ");
INSERT INTO sgb_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Hên habayto êt ha bali ni Caifas, ya pinakapoon pari, ay nipagtsipon hilay ampamaala kanlan pari haka hilay kaatag pon ya toa lan Israelita ya nag tungkulan ha bansa. ");
INSERT INTO sgb_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ta ampulungên la hi Apo Jesus, no ay-êmên la yan madakêp haka maipapatsi hên ayn makamwang. ");
INSERT INTO sgb_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Noa, wanla, “Paan tamo yan ipapatsi kaban pista, ta kayno magulo hilay kal-atan, ya ampanggilam toro na.” ");
INSERT INTO sgb_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Hên atsi hilan Apo Jesus ha baryon Betania, ay hinagyat hilan mangan ha bali ni Simon ya inalihan ketong. ");
INSERT INTO sgb_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Hên ampangan hila, ay main nilumatêng ya mihay babayi ya ampantan hên makamal ya pabango ya atsi ha pamyanan ya dyag ha alabastro, ta intugtug na ha ulo ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Hên nahêlêk lan tagahonol na ya dinyag nan babayi, ay nanuluk hila, ya wanla, “Pata hinayang nay pabango! ");
INSERT INTO sgb_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Naihaliw na dayi ya habayto hên kal-atan pera ya naidin na dayi ha mairap!” ");
INSERT INTO sgb_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Hên napansin ni Apo Jesus ya anhabiên la, ay wana kanla, “Pata an-abalaên yo ya! Paulayan yo ya, ta ya dinyag na, ay taganán mangêd. ");
INSERT INTO sgb_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Hilay mairap ay panay yon kalamo, kabay ha hinon oras, ay mahawpan yo hila, noa, hiko ay a yo panay hên mapagkalamo. ");
INSERT INTO sgb_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ha pamullog nan pabango kangko, ay nanad nay nan in-il-an ya lawini ko ha pamilbêng kangko no matsi kina. ");
INSERT INTO sgb_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Pakagilamên yo, ay-iri man ya logal bayri ha boon luta hên ipamwang ya Mangêd ya Habi, ay ungkatên etaman ya dinyag na ta êmên a ya maliwaan.” ");
INSERT INTO sgb_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Bayo nammita yay na hi Judas Iscariote, ya miha kanlan labinloway tagahonol ni Apo Jesus, ta êmên na ya mai-upit kanlan poon pari. ");
INSERT INTO sgb_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Wana kanla, “Hino awud ya idin yo kangko no hawpan kataw hên dakpên hi Jesus?” Kabay dinyanan la yan tatlumpo ya pera ya pilak. ");
INSERT INTO sgb_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Paubat hên habayto, ay ampangihip yay na hi Judas no ay-êmên na yan maidin ha gamêt la. ");
INSERT INTO sgb_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ha unan allon Pistan Puto ya ayn Pampaalsa, ya allon pamatsi lan Israelita hên anak tupa, ya kênaên la hên habayton yabi hên Pistan Pangaligtas ha Egipto, ay kinotang lan labinloway tagahonol ni Apo Jesus, kana, ya wanla, “Atoy labay moy logal ya pangil-anan naên hên pangkaên tamo amêhên yabi ha Pistan Pangaligtas?” ");
INSERT INTO sgb_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","In-utoh hila ni Apo Jesus ya wana kanla, “Muna kaw ha balayan Jerusalem. Panlumatêng yo bayro, ay matupa yoy mihay lalaki. Habaytsi ya habiên yo kana, ‘Wanan Mánoro naên ya marani yanay panaon ya intakda ni Apo Namalyari kana. Kailangan nay mihay kuwarto ya panganan nan kaên ha Pistan Pangaligtas ha bali mo, hên kalamo na kay ya tagahonol na.’” ");
INSERT INTO sgb_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Hinonol lan tagahonol na ya in-utoh na, ta in-il-an lay nay kaên ha Pistan Pangaligtas. ");
INSERT INTO sgb_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Hên yabi yana, ay inarap ni Apo Jesus ya kaên hên kalamo na hilay labinlowa. ");
INSERT INTO sgb_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kaban ampangan hila, ay wana kanla, “Pakagilamên yo, miha kamoyu bayri ha kaaêm tamo, ay mangi-upit kangko.” ");
INSERT INTO sgb_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Namalagêhbêg ya nakêm lan tagahonol na, haka wanlan balang miha kana, “Panginoon, yarin hiko ya inungkat mo!” ");
INSERT INTO sgb_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Kabay hinabi ni Apo Jesus, “Ya kalamo kon nami-tsil-tsil hên puto ha kolo, ay hiya ya mangi-upit kangko. ");
INSERT INTO sgb_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Hiko ya Taga-Langit, ya In-anak Tawo ay taganán matsi hên nanad ha impahulat ni Apo Namalyari ha Kahulatan hên haton lagi. Noa, taganán kaingalo ya mangi-upit kangko. Mangêd kana, ay a ya dayin in-anak.” ");
INSERT INTO sgb_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Amêhên, hi Judas Iscariote, ya nangi-upit kan Apo Jesus, ay nangotang, ya wana, “Mánoro, yarin hikoy inungkat mo!” Hinabi kana ni Apo Jesus, “Awo, hinabi mina.” ");
INSERT INTO sgb_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kaban ampangan hila, ay nandampot hi Apo Jesus hên puto ta impahalamat nay habayto kan Apo Namalyari, haka na pino-potoh, bayo inggawang na kanlan tagahonol na, ta wana, “Habaytsi ya lawini ko, kowên yo ta kaên yo.” ");
INSERT INTO sgb_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Amêhên, nandampot yan pamminêman ya nag alak ta impahalamat nay habayto kan Apo Namalyari. Bayo inggawang na kanla, ta wana, “Maubuh kaw hên minêm. ");
INSERT INTO sgb_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Habaytsi ya daya ko, ya mamoganggang ha pamatawad hên kasalanan hên kal-atan. Yabay ya nanad pinakapirma hên kahundoan ni Apo Namalyari kanlan pinili na hên mag-in kana. ");
INSERT INTO sgb_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ta anhabiên ko kamoyu, ya a ko pon minêm oman hên alak, angga ha allo hên inumên koy bayoy alak hên kalamo yo ha pamanlokop ni Apo Namalyari, ya Tatang ko.” ");
INSERT INTO sgb_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Hên nahabi ni Apo Jesus ya habayto, ay nagkanta hilan pamagpuri kan Apo Namalyari bayo nilumakat hila ha Tawgtug Olibo. ");
INSERT INTO sgb_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Hên anlumakat hilay na ha Tawgtug Olibo, ay wani Apo Jesus kanlan tagahonol na, “Laamêhên yabi, gawan ha malyari kangko, ay lakwanan yo ko, ta impahulat ni Apo Namalyari ha Kahulatan, ya êmên di, ‘Patsên ko ya pastol, haka mapitatayak hilay nay tupa.’ ");
INSERT INTO sgb_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Noa, ha pangoman kon mabiyay, ay muna ko kamoyu ha probinsyan Galilea.” ");
INSERT INTO sgb_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Bayo wani Pedro, “Lakwanan ka man hên kalamo ko, gawan ha malyari kamo, ay a kata lakwanan.” ");
INSERT INTO sgb_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Hinabi ni Apo Jesus, “Pakagilamên mo, bayo mangkatsi ya manok, amêhên yabi, ay katatlo mon habiên ya a mo ko muwang.” ");
INSERT INTO sgb_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Noa, impalêkpêk ni Pedro, ya wana, “Matsi ko man hên kalamo mo, ay a ko habiên ya a kata muwang.” Êmbayro êt ya hinabi lan kaatag ya tagahonol na. ");
INSERT INTO sgb_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Hên nilumatêng hilay na ha katanamanan Getsemani, ay wani Apo Jesus kanlan tagahonol na, “Mikno kaw di kaban manalangin ako bayro ha marayo-dayo.” ");
INSERT INTO sgb_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Bayo pinakilamo ni Apo Jesus hi Pedro, haka hilay loway anak ni Zebedeo, ya hi Santiago haka hi Juan. Bayron nakadanas yan hadyay kalungkutan haka kabyatan. ");
INSERT INTO sgb_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Haka wani Apo Jesus kanla, “A kina agyu ya hadyay kalungkutan ha nakêm ko, ya nanad kinan ikamatsi. Di kaw pon haka paan kaw mabêlêw.” ");
INSERT INTO sgb_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Napaidayo ya kanla hên marayo-dayo ta nandoko yan nanalangin, ya wana, “Tatang ko ha langit, no labay mo, ay a mo ko dayin paulayan hên magdanas ako hên hatsi ya hadyay pamagdusa ya lumatêng kangko. Êmbayro man ya labay ko, ay alwan kalabayan ko ya mahonol, noa, ya kalabayan mo ya mahonol.” ");
INSERT INTO sgb_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Hên nirêng ya, hên ubat nanalangin, ay nag-orong yay na ha andyanan lan Pedro. Nalatngan na hila hên angkabêlêw. Pinukaw na hi Simon Pedro, ya wana, “A kaw man makapagpuyat hên kalamo ko hên miha man ya oras? ");
INSERT INTO sgb_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Paan yon pakilakwan ya bêlêw. Manalangin kaw, ta êmên a kaw mahambut hên tukso no ansubukên ya paniwala yo. Nakal-an ya nakêm yo hên humonol, noa, a yo agyu.” ");
INSERT INTO sgb_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nag-orong hi Apo Jesus ha pinanalanginan na, hên nanalangin, ya wana, “Tatang ko ha langit, no taganán kailangan kon magdanas hên hatsi ya hadyay pamagdusa ya lumatêng kangko, ay kalabayan mo ya mahonol.” ");
INSERT INTO sgb_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Hên inorong na hilan oman ya tatlo, ay angkabêlêw hilay na êt gawan a la matêêh hên magpuyat. ");
INSERT INTO sgb_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nag-orong yan oman hi Apo Jesus ha pinanalanginan na hên katatlo yan nanalangin, ya inhalangin nay na. ");
INSERT INTO sgb_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Hên katatlo na hilan inorong, ay wana kanla, “Angkabêlêw kaw pon êt hên ampagpainawa! Nilumatêng ya oras ya hiko ya Taga-Langit, ya In-anak Tawo, ay i-upit kanlan makasalanan! ");
INSERT INTO sgb_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mirêng kaw na, ta anlumatêng ya ampami-upit kangko. Tupaên tamo ya!” ");
INSERT INTO sgb_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Kaban ampaghabi ya pon hi Apo Jesus, ay main nilumatêng ya kal-atan ya ampangamat kan Judas Iscariote ya miha kanlan labinloway tagahonol na. Hilay kal-atan ya nipag-almas hên êtak haka pamatok, ay in-utoh lan toa ya nag tungkulan ha bansa, haka kanlan ampamaala kanlan pari. ");
INSERT INTO sgb_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Hi Judas ay nam-i kanla hên palatandaan, ya no hinoy aroên na, ay yabay ya dakpên la. ");
INSERT INTO sgb_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tampol nilako ni Judas hi Apo Jesus hên kinumusta hên main lamoy pamangaro. ");
INSERT INTO sgb_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Kabay wani Apo Jesus kana, “Kalalaki, daygên minay ambalakên mo.” Bayo dinawhong la ya hi Apo Jesus hên dinakêp. ");
INSERT INTO sgb_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Noa, biglan nanigpah ya miha kanlan tagahonol ni Apo Jesus, hên têkk hên mihay ipoh hên pinakapoon pari. ");
INSERT INTO sgb_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Wani Apo Jesus kana, “Igoma moy êtak mo, ta hilay ampanggamit hên êtak ha pamatsi, ay ha êtak êt hên matsi. ");
INSERT INTO sgb_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Êndat yon a ko makadawat ha Tatang ko ha langit hên libo-liboy anghel ya manawop kangko! ");
INSERT INTO sgb_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Noa, no daygên koy habayto, ay êmên bayton matupad ya impahulat ni Apo Namalyari ha Kahulatan ya êmbayri ay taganán dapat malyari!” ");
INSERT INTO sgb_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Kanan habayto, ay wani Apo Jesus kanlan kal-atan ya ampipandakêp kana, “Andakpên yo ko hên main kalamoy êtak haka pammatok hên nanad pandakêp ha mapanyag karawakan. Allo-allo nanoro ko ha Templo, haka a yo ko dinakêp. ");
INSERT INTO sgb_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Noa, dapat matupad ya Kahulatan ya impahulat ni Apo Namalyari kanlan mámipamwang hên an-ipaihip na kanla.” Bayo naubuh la yan nilakwanan hên tagahonol na hên nipamwayu. ");
INSERT INTO sgb_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Hilay nandakêp kan Apo Jesus, ay nantan kana ha bali ni Caifas, ya pinakapoon pari ta bayro hilay nan naka-tsipon hilay mánoron Kautuhan ni apo Moises, haka hilay kaatag kanlan toa ya nag tungkulan ha bansa. ");
INSERT INTO sgb_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Hi Pedro ay nangamat kanla ha marayo-dayo ha lote hên bali nan pinakapoon pari. Nakiikno ya hên kalamo lan bantay ta labay nan mahêlêk no hinoy malyari kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Hilay ampamaala kanlan pari haka ya kaganawan kaatag ya kalamo la ha Sanedrin, ay ampanapol hên manistigos hên alwan pêtêg ya maibara la kan Apo Jesus, ta êmên la ya maipapatsi. ");
INSERT INTO sgb_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Noa, ayn hilan matapol, mal-at man ya nanistigos ha alwan kaptêgan ya tungkol kan Apo Jesus. Bayo main nilumatêng ya lowa, ");
INSERT INTO sgb_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ya naghabi, “Nagilam naên ya hinabi na ya hiraên na kano ya Templo ni Apo Namalyari, ta ipairêng nan oman ha tatlon allon bêngat.” ");
INSERT INTO sgb_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Amêhên, nirêng ya pinakapoon pari la ha arapan lan kal-atan ta kinotang na hi Apo Jesus, ya wana, “Hino ya mahabi mo ha an-ibara la kamo? Pata a ka maghabi?” ");
INSERT INTO sgb_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Noa, minghan man, ay a ya naghabi hi Apo Jesus. Wanan pinakapoon pari kana, “Ha arapan ni Apo Namalyari, ay habiên mo kannaên no hika ya Mesias, ya Cristo, ya Mámiligtas, ya Anak ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Wana etaman ni Apo Jesus, “Awo, pêtêg ya hinabi mo. Haka paubat amêhên, ay mahêlêk yo ko, ya Taga-Langit ya In-anak Tawo, hên nakaikno ha dapit panabtab ni Apo Namalyari ya Makapangyarihan. Haka mahêlêk yo kon lumatêng ubat ha langit ha pibonakan hên lêmm.” ");
INSERT INTO sgb_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Gawan huluk nan pinakapoon pari, ay ginihi nay sarili nan takop, ta wana, “A tamina kailangan hên kaatag ya tistigos, ta nagilam tamina man ya hinabi na. Nagilam yoy nay pamipantag nan sarili na kan Apo Namalyari! Yarin a nan ammusmusên hi Apo Namalyari ya tawo yan bêngat! ");
INSERT INTO sgb_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Hino ya labay yon daygên kana?” Naubuh hilan naghabi, ya dapat yan patsên. ");
INSERT INTO sgb_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Bayo dinul-an lay lupa na haka la ya pinagtutumbuk haka main nagtatampaling kana, ");
INSERT INTO sgb_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ya wanla, “No hika ya Mesias, ya Cristo, ya Mámiligtas, ay habiên mo no hinoy nanampaling kamo!” ");
INSERT INTO sgb_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kaban atsi ya hi Pedro hên nakiikno hên kalamo lan bantay, ay napansin yan mihay ipoh ya babayi, kabay wana kana, “Hika êt ya kalamo ni Jesus ya taga-Galilea.” ");
INSERT INTO sgb_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Noa, wani Pedro, “Alwa. A ko muwang ya anhabiên mo.” ");
INSERT INTO sgb_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Bayo nagdayo yan pêrad hên dinumani ha awahan. Noa, napansin yay na êt, hên kaatag ya ipoh ya babayi, ya wana kanlan karani na, “Habain ya lalaki ay kalamo ni Jesus ya taga-Nazaret.” ");
INSERT INTO sgb_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Noa, wani Pedro, “Alwa! Matsi ko man, ay taganán a ko ya muwang!” ");
INSERT INTO sgb_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Hên a nabuyot, ay wanlan karani ni Pedro, “Siguradon hika ya kalamo ni Jesus gawan napansin naên ha pamaghabi mo, ya taga-Galilea ka êt.” ");
INSERT INTO sgb_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Noa, wani Pedro, “Alwa! Matsi ko man, ay taganán a ko ya muwang ya habain!” Kaban ampaghabi ya pon, ay nangkatsi ya mihay manok. ");
INSERT INTO sgb_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Bayo naihipan ni Pedro ya hinabi ni Apo Jesus kana, ya “Bayo mangkatsi ya manok, ay katatlo mon habiên, ya a mo ko muwang.” Kabay inumawah ya hên hadyay tangih na. ");
INSERT INTO sgb_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Hên dali allo pon, ay nagkamiha hilay toa ya nag tungkulan ha bansa, haka hilay ampamaala kanlan pari, ya dapat yan patsên hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kabay ginapoh la yan gintan kan Gobernador Pilato. ");
INSERT INTO sgb_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Hên nahêlêk ni Judas Iscariote ya patsên lay na hi Apo Jesus, ay naghêhê ya, haka na in-orong kanlan poon pari boy kanlan toa ya nag tungkulan ha bansa, ya tatlumpo ya pera ya pilak ya in-upa la kana ha pay-upit na kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Haka wana kanla, “Nakadyag akon kasalanan, ta nai-upit koy linaw ya tawo.” Noa, wanla, “Ayn kay pakiêmên kamo! Atsi kamo!” ");
INSERT INTO sgb_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Inhamwag ni Judas ya hatoy pera ha lalên Templo, haka ya nammita ta nagpakamatsi ya hên nagbitkê. ");
INSERT INTO sgb_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Hatoy pera ay pinumpun lan ampamaala kanlan pari, ta wanla, “Bawal ha Kautuhan ni apo Moises hên ipahan ha peran Templo ya pinamayad hên mangwan biyay.” ");
INSERT INTO sgb_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kabay nagkamiha hilay ampamaala kanlan pari, ya habaytoy pera, ay panaliw hên luta hên mihay magdya-dyag korên ya pamilbêngan lan natsi ha Jerusalem, ya a la kilala, ya ubat ha kaatag ya bansa. ");
INSERT INTO sgb_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kabay angga amêhên ay ambaêgên lay habaytoy luta hên Luta hên Daya. ");
INSERT INTO sgb_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Habaytoy nakatupad hên hinabi ni Propeta Jeremias, ya wana, “Kingwa lay tatlumpoy pera ya pilak, ya in-alaga kana hên Israelita, ");
INSERT INTO sgb_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","haka la pinanaliw hên luta hên mihay magdya-dyag hên korên, ta habaytoy in-utoh kangkon Panginoon.” ");
INSERT INTO sgb_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Hên hi Apo Jesus ay in-arap kan Gobernador Pilato, ay kinotang na ya hi Apo Jesus, ya wana, “Awta? Hika ya ari hên Israelita?” Hinabi ni Apo Jesus, “Hinabi mina, Gobernador.” ");
INSERT INTO sgb_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Noa, hên ambad-an la ya hi Apo Jesus hên ampamaala kanlan pari haka hilay toa ya nag tungkulan ha bansa, ay a ya naghabi. ");
INSERT INTO sgb_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Bayo wani Gobernador Pilato kan Apo Jesus, “A mo angkagilaman ya kal-atan ya an-ibara la kamo?” ");
INSERT INTO sgb_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Noa, a ya naghabi hi Apo Jesus, ta miha man ha an-ibara la kana, ay a na pinakibatan. Kabay nag-êpapah hi Gobernador Pilato. ");
INSERT INTO sgb_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Main kaugalian, ha balang Pistan Pangaligtas ha Egipto, ya an-ibuhan nan gobernador ya mihay nakahukul ya ampiliên lan kal-atan. ");
INSERT INTO sgb_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kanan habayto ay main nakahukul ya nag langan Barrabas ya kamwangan gawan ha karawakan ya dinyag na. ");
INSERT INTO sgb_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Hên naka-tsipon ya kal-atan, ay kinotang hilay na ni Gobernador Pilato, ya wana, “Hino awud ya labay yon ibuhan ko, hi Barrabas o hi Jesus, ya ambaêgên Cristo?” ");
INSERT INTO sgb_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ta muwang ni Gobernador Pilato ya hi Apo Jesus, ay gintan la kana, gawan angkahêman la ya. ");
INSERT INTO sgb_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Kaban ampikno hi Pilato ha panlingonan kaso, ay nilumatêng kana ya pinaypagtanan ahawa na hên êmên di ya pangahabi, “Paan kan kiêmên hên parusaan habain ya ayn kasalanan, ta hadyay yagah hên nakêm ko gawan ha nataynêp ko ya tungkol kana.” ");
INSERT INTO sgb_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Noa, hilay ampamaala kanlan pari haka hilay toa ya nag tungkulan ha bansa, ay nanulhul hên kal-atan ya pakikwaan la kan Gobernador Pilato ya ibuhan na hi Barrabas, ta hi Apo Jesus ay patsên. ");
INSERT INTO sgb_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kabay kinotang na hilan oman ni Gobernador Pilato, “Hino kanlan lowa ya labay yon ibuhan ko?” Wanla kana, “Hi Barrabas!” ");
INSERT INTO sgb_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Kinotang na hilay na êt, “Hino awud ya labay yon daygên ko kan Jesus ya ambaêgên Cristo?” Kabay in-angaw la, “Ipako ya ha koros!” ");
INSERT INTO sgb_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Bayo kinotang ni Gobernador Pilato, “Awta? Hinoy kasalanan na?” Noa, impapakaangaw lay na êt, “Ipako ya ha koros!” ");
INSERT INTO sgb_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Hên nahêlêk ni Gobernador Pilato ya ayn yan madyag, ta magulo hilay na, ay nag-uyah yan gamêt na ha arapan lan kal-atan, haka wana kanla, “Ayn akon kasalanan ha pamatsi kanan habaytsi. Hikaw ya managot ha pamatsi kana!” ");
INSERT INTO sgb_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Hinabi lan kal-atan Israelita, ya wanla, “Ya pamarusa ni Apo Namalyari ay mipalakoy na kannaên haka ha maának naên gawan ha pangamatsi ni Jesus.” ");
INSERT INTO sgb_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Hinonol ni Gobernador Pilato ya kalabayan lan kal-atan, ta imbuhan na hi Barrabas. Impadapi na hi Apo Jesus, haka indin na ya kanla ta êmên la ya ipapako ha koros. ");
INSERT INTO sgb_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Hi Apo Jesus ay gintan lan hundaloh ni Gobernador Pilato ha lalên balin gobernador, haka inubuh la yan pinilolopungan hên kal-atan kapareho lan hundaloh. ");
INSERT INTO sgb_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ha pammusmus la kana, ay inalíh lay takop na ta pinatakopan la ya hên mahampat ya takop, ya nanad ha takop lan ari. ");
INSERT INTO sgb_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Bayo nangwa hilan nanad tanyuong, ta pinanyag la yan korona, ya impakopya la ha ulo na. Haka la ya pinatalanan tambo, ya waringan hên palatandaan ya hiyay mihay ari. Nandoko hila bayto ha arapan na, ya wanla, “Kumara dayi ya biyay hên Ari lan Israelita!” ");
INSERT INTO sgb_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Pinagdu-dul-an la ya, haka pinagpapatok lay ulo na hên tambo. ");
INSERT INTO sgb_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pamakayari la yan minusmus, ay inalíh lay takop ari ya impatakop la kana, ta impatakop la kanan oman ya takop na. Bayo gintan la yay na, ta ipako la ya ha koros. ");
INSERT INTO sgb_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ha pammita lan hundaloh hên anggêtan hi Apo Jesus, hên ipako ha koros, ay natupa la hi Simon ya taga-Cirene. Dinakêp la ya ta impabalangaw lay koros kana hên ampakihonol kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Inhundo lay pammita la hên angga ha nilumatêng hila ha logal ya ambaêgên Golgota o Bungo. ");
INSERT INTO sgb_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Painêmên la ya dayin alak, ya naglamo hên tambal ya nag langan mira, noa, hên natawayan na, ay a na ininêm. ");
INSERT INTO sgb_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Hên naipako lay na hi Apo Jesus ha koros, ay pinagpalabonutan lay takop na, ta êmên la mamwangan no hino kanla ya makakwa. ");
INSERT INTO sgb_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Bayo nikno hilay nay hundaloh ta binantayan la ya. ");
INSERT INTO sgb_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Atsi ha koros, ha ugton ulo na, ay nakahulat ya imbara la kana, “Hatsi hi Jesus, ya Ari lan Israelita.” ");
INSERT INTO sgb_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Main êt loway lalaki, ya parehon mapanyag karawakan ya impako ha koros. Ya miha ay atsi ha koros ha dapit panabtab ni Apo Jesus, haka ya miha ay atsi ha koros ha dapit uki na. ");
INSERT INTO sgb_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Minusmus la yan anlumabah hên main lamoy pamamêyêng, ");
INSERT INTO sgb_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ya wanla, “Hika awud ya labay maniran Templo ni Apo Namalyari, ta ipairêng mon oman ha tatloy allo! Iligtas moy sarili mo! Munaoy kan ubat ha koros, no hika ya Anak ni Apo Namalyari!” ");
INSERT INTO sgb_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Êmbayro êt ya pammusmus la kana hên hilay mánoron Kautuhan ni apo Moises, hilay ampamaala kanlan pari haka hilay toa ya nag tungkulan ha bansa, ya wanla, ");
INSERT INTO sgb_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Inligtas nay kaatag, pata a na mailigtas ya sarili na! Hiya kanoy Ari lan Israelita! No tumaoy yan ubat ha koros, ay maniwala kitamo kana! ");
INSERT INTO sgb_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ampaniwala ya kan Apo Namalyari, haka anhabiên na ya hiyay Anak ni Apo Namalyari, kabay hêlkên tamo no labay na yan iligtas ni Apo Namalyari!” ");
INSERT INTO sgb_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Êmbayro êt ya pammusmus la kana hên hilay loway mapanyag karawakan ya nakapako hên kalamo na. ");
INSERT INTO sgb_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Hên ugtoy nay allo, ay dinumiglêm ya boon luta angga ha alas tres hên maapon. ");
INSERT INTO sgb_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Hên maranin alas tres hên maapon, ay impakaangaw ni Apo Jesus, ya wana, “Eli, Eli, lema sabachthani,” ya labay habiên, “Diyos ko, Apo Namalyari, pata nilakwanan mo ko?” ");
INSERT INTO sgb_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Hên nagilam lan kaatag ya nakairêng bayro ya in-angaw na, ay êndat lan ambaêgên na hi Propeta Elias, kabay wanla, “Gilamên yo! Ambaêgên na hi Elias!” ");
INSERT INTO sgb_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tampol yan nuwayu ya miha kanla hên namiptêh hên nanad bolak ha mihay hanga, ta indêrê na ha nangihoy alak, ta painêmên na ya hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Noa, wanlan kaatag, “Paulayan tamo ya raw. Hêlkên tamo no iligtas ya ni Elias!” ");
INSERT INTO sgb_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nan-angaw yan oman hi Apo Jesus hên hadyay hêkaw, bayo natsi yay na. ");
INSERT INTO sgb_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Sakto kanan habayto ay biglan nawakwak hên napibonak paubat ha babo angga ha aypa, ya makugpa ya takop ya pinagpênlan bayro ha lalê hên Templo ha Jerusalem. Niyêgyêg ya boon luta, haka napaka hilay bato. ");
INSERT INTO sgb_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nipagloat ya pinay-ilbêngan kanlan kal-atan ya pinili ni Apo Namalyari hên mag-in kana, ya natsi hên hato, ta biniyay hilan oman. ");
INSERT INTO sgb_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Inumawah hila bayro ha pinay-ilbêngan kanla, ta hên nabiyay yan oman hi Apo Jesus, ay nagpahlêk hila ha kal-atan ha Jerusalem, ya banal ya balayan ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Hadyay limo nan ampamaala kanlan hundaloh, haka hilay kalamo nay hundaloh ya ampagbantay kan Apo Jesus, hên nahêlêk lay layon, haka ya kaatag pon ya nalyari ha pangamatsi ni Apo Jesus. Kabay wanla, “Pêtêg bay awud! Hiyay Anak ni Apo Namalyari!” ");
INSERT INTO sgb_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Bayro ha marayo kan Apo Jesus, ay main mal-at ya babayi ya ampandungaw ha angkalyari. Nakihonol hila kanlan Apo Jesus hên paubat ha probinsyan Galilea hên ampanawop kanla. ");
INSERT INTO sgb_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kalamo la hi Maria Magdalena, haka ya indo lan anak ni Zebedeo, haka hi Maria ya indo lan Jose haka Santiago. ");
INSERT INTO sgb_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Hên ampinaboy nay allo, ay main mihay mabandi ya taga-balayan Arimatea, ya nag langan Jose, ya ampaniwala kan Apo Jesus, ya ");
INSERT INTO sgb_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","nilumatêng kan Gobernador Pilato, ta pinakihabi nay bangkay ni Apo Jesus, hên iilbêng na. Namiutoh ya etaman hi Gobernador Pilato hên ipaulay kan Jose ya bangkay ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kabay kingwa na ya bangkay ni Apo Jesus, hên in-aypa, haka na kinêlkêlan hên bayoy takop, ya naputsi. ");
INSERT INTO sgb_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Bayo inhowên ni Jose ya bangkay ha sarili nan pay-ilbêngan, ya bayoy dinyag ya lêyang ya bato. Pangayari, ay intulid nay hadyay hêlay bato hên intakap na ha pinay-ilbêngan, bayo nammita yay na. ");
INSERT INTO sgb_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Atsi bayro hi Maria Magdalena haka ya katokayo na, ya nakaikno ha êtêb pinay-ilbêngan kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ha humonoy allo, ya allon Sabado, ay ni-tsi-tsipon hilay Pariseo haka hilay ampamaala kanlan pari ha arapan ni Gobernador Pilato, ");
INSERT INTO sgb_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ta hinabi la, ya wanla, “Napanêmtêman naên ya hinabi nan habaytoy magbabara hên haton angkabiyay ya pon, ya ha pantatloy allo, ay mabiyay yan oman. ");
INSERT INTO sgb_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kabay ampakihabi naên kamo ya pakabantayan yon mangêd ya habaytoy pinay-ilbêngan kana hên angga ha pantatloy allo. Ta kayno kowên lan tagahonol na ya bangkay na, haka la habiên ha kal-atan ya hiyay nangoman nabiyay. No daygên lay habayto, ay lalon mapaniwala ya kal-atan kana.” ");
INSERT INTO sgb_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Wana etaman kanla ni Gobernador Pilato, “Hali, mantan kaw hên hundaloh ta pakabantayan lan mangêd ya pinay-ilbêngan kana.” ");
INSERT INTO sgb_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kabay nammita hilay na ta dinyanan lan tatak ya habaytoy bato ya pinanakap ha pinay-ilbêngan kan Apo Jesus, haka binantayan lay habayto, ta êmên ayn makahowên. ");
INSERT INTO sgb_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Dali allo êt hên allon Dominggo, ay nammita hi Maria Magdalena haka ya katokayo na ha pinay-ilbêngan kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Biglan nanlayon hên hadyay hêkaw, haka tinumaoy ya mihay anghel ni Apo Namalyari ya ubat ha langit, ta intulid nay habaytoy bato ya pinanakap ha pinay-ilbêngan kan Apo Jesus, bayo nikno ya bayro ha babon bato. ");
INSERT INTO sgb_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ya lupa na ay kapahilêw ya nanad kimat haka ya takop na ay bapan putsi. ");
INSERT INTO sgb_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Hên nahêlêk lan hundaloh ya ampagbantay bayro ya anghel, ay hadyay limo la. Nipamêgpêg hila haka nipatumba hên nanad natsi. ");
INSERT INTO sgb_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Wanan anghel kanlan babayi, “Paan kaw malimo! Muwang ko ya antapolên yo hi Apo Jesus ya impako ha koros. ");
INSERT INTO sgb_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ayn ya bayri, ta hiya ay nabiyay oman hên nanad ha hinabi na hên hato! Hêlkên yoy habaytsi ya pinaybul-ihan kanan bangkay na. ");
INSERT INTO sgb_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Parah-parahên yon magtagloh kanlan tagahonol na, ta habiên yo hiyay nangoman nabiyay, haka muna yay na kanla ha probinsyan Galilea. Mahêlêk la yay na bayro. Habayton bat ya mahabi ko kamoyu.” ");
INSERT INTO sgb_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kabay nag-alíh hila bayro ha pinay-ilbêngan ta pinarah lan nuwayun nagtagloh kanlan tagahonol na, hên main lamoy limo haka hadyay higla. ");
INSERT INTO sgb_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ha pamwayu la, ay bigla hilan tinupa ni Apo Jesus ta kinumusta na hila. Nandoko hila hên nakadêngdêng hên nanalan bitsih na ha pamagsimba la kana. ");
INSERT INTO sgb_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Bayo wani Apo Jesus kanla, “Paan kaw malimo! Mita kaw na, ta habiên yo kanlan tagahonol ko, ya nanad kinan patêl, ya muna hila ha Probinsyan Galilea, haka mahêlêk la ko bayro.” ");
INSERT INTO sgb_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Pamakabita lan babayi, ay nammita hila etaman ya kaatag ya hundaloh ya ampagbantay bayro, haka pamanlumatêng la ha balayan Jerusalem, ay in-ubuh lan impamwang kanlan ampamaala kanlan pari ya nalyari ha pinay-ilbêngan kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kabay ni-tsi-tsipon hilay ampamaala kanlan pari haka hilay toa ya nag tungkulan ha bansa. Pinagkamihaan la, ay dyanan lan kal-atan pera ya hilay hundaloh ya nagbantay ha pinay-ilbêngan kan Apo Jesus, ta ");
INSERT INTO sgb_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","wanla kanlan hundaloh, “Ya dapat yon habiên kanlan kal-atan, ay tinakaw lan tagahonol na ya bangkay na hên angkabêlêw kaw nayabi. ");
INSERT INTO sgb_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","No mamwangan man hên Gobernador ya tinakaw lan tagahonol na, ya bangkay na hên angkabêlêw kaw, ay a kaw mabilyan ta atsi kannaên ya habayto.” ");
INSERT INTO sgb_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kabay kingwa lan hundaloh ya pera ta hinonol lay in-utoh kanla. Kabay angga amêhên ay êmbayro êt ya anhabiên lan kaatag ya Israelita. ");
INSERT INTO sgb_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Amêhên, hilay labinmihay tagahonol ni Apo Jesus ay nammitay na ha probinsyan Galilea ha tawgtug ya intoro kanla ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Hên nahêlêk lay na hi Apo Jesus ay sinimba la ya, main man pon kanla hên ampag-alangan. ");
INSERT INTO sgb_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Dinumani hi Apo Jesus kanla, ta wana, “In-ubuh hên indin kangko ya kapangyarihan ha langit haka bayri ha luta. ");
INSERT INTO sgb_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Mita kaw na ta ha kapangyarihan ko, ay toroan yo hila ha balang bansa ta êmên hila maniwala kangko. Bawtismoan yo hila ha langan nan Tatang, ha langan ko, ya Anak, haka ha langan nan Espiritu ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Bayo toroan yo hila ya dapat lan honolên ya kaganawan in-utoh ko kamoyu. Paan yon liwaan ya hiko ay panay yon kalamo, angga ha anggaan hên habaytsi ya luta.”");
INSERT INTO sgb_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ya laman hên hata hulat, ay yabay ya Mangêd ya Habi tungkol kan Apo Jesu-Cristo, ya Anak ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Habaytsi ay nag-umpisa hên nanupad hên hulat lan mámipamwang hên an-ipaihip kanla ni Apo Namalyari, ya wanan Kahulatan, “Iutoh ko ya mihay muna kamo, ya mangil-an hên danan mo. ");
INSERT INTO sgb_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Hiyay ampan-angaw ha logal ya kabalah-balahan, ya wana kanlan kal-atan ya naka-tsipon, ‘Il-an yoy nakêm yo ha pamanlumatêng hên Panginoon, Ya nanad ha pamil-an hên dann ha pamanlumatêng hên mihay matag-ay ya manungkulan.’” ");
INSERT INTO sgb_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Natupad ya habayto hên nakalatêng hi Juan Bautista hên namipamwang kanlan dinumani kana ha Ilog Jordan, ha logal ya kabalah-balahan, ya dapat lan paghêhêan hên talibatokan ya pamanyag kasalanan, bayo dapat pabawtismo hila, haka patawarên hila bayto ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kal-atan lan taga-Jerusalem, haka kaatag pon ya logal ha probinsyan Judea, ay dinumani kan Juan. Inamin haka inhuko lay kasalanan la, bayo nagpabawtismo hila kana ha Ilog Jordan. ");
INSERT INTO sgb_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Hi Juan ay nakatakop hên dyag ha habot hên kamelyo, haka ya tagkêh na ay dyag ha balat. Ya angkênaên na ay doron haka main bayron pulot panilan ya an-inêmên na. ");
INSERT INTO sgb_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Panay nan an-ipamwang ya êmên di, “Ya lumatêng ya Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala, ay makapangyarihan kangko. Agyan mangokal hên hêêl pag-apin bitsih na, ay ayn akon karapatan ta matag-ay ya tungkulan na. ");
INSERT INTO sgb_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Hikoy ampamawtismo kamoyu ha lanêm, noa, hiyay mamawtismo kamoyu ha Espiritu ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Hên habayto, ay nilumatêng hi Apo Jesus, ya ubat ha balayan Nazaret ha probinsyan Galilea, ta nagpabawtismo ya kan Juan ha Ilog Jordan. ");
INSERT INTO sgb_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Hên inumawah ya ha lanêm, ay nahêlêk ni Apo Jesus ya langit ya biglan nagloat, haka inumaypa kana ya Espiritu ni Apo Namalyari hên nanad ha mihay pati-pati. ");
INSERT INTO sgb_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Haka main habi ya ubat ha langit, ya wana, “Hika ya panlugurên kon Anak ya ampamahigla kangko.” ");
INSERT INTO sgb_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Pangayari yan nagpabawtismo hi Apo Jesus, ha Ilog Jordan, ay tampol yan impabita hên Espiritu ni Apo Namalyari ha logal ya kabalah-balahan. ");
INSERT INTO sgb_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Atsi ya bayro hên apatapo ya allo, hên antuksoên ni Satanas, noa, a ya napatukso. Main bayron mangahilêb ya ayop ya kalamo na, noa, main anghel ya nipanawop kana. ");
INSERT INTO sgb_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Hên nakakulung yay na hi Juan Bautista, ay nag-orong hi Apo Jesus ha probinsyan Galilea, ta impamwang na bayro ya Mangêd ya Habi ya ubat kan Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Impamwang na, ya wana, “Nilumatêng ya panaon ya intakda ni Apo Namalyari, haka marani ya pamanlokop na, kabay paghêhêan yon talibatokan ya pamanyag kasalanan, haka maniwala kaw ha Mangêd ya Habi!” ");
INSERT INTO sgb_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ha pammita ni Apo Jesus ha laylay hên Dagat-dagatan hên Galilea, ay nahêlêk nay loway mikapotoh pohêl, ya magdadakêp hên kênan lanêm, ya hi Andres haka hi Simon, ya ambanhagan lan Pedro. Hila ay ampayhabwag hên lambat ha lanêm, ta ampandakêp hila dayi hên kêna. ");
INSERT INTO sgb_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Hinabi na kanla, “Makihonol kaw kangko, ta daygên kataw hên mámipakarani hên tawo kangko, ta êmên hila maniwala.” ");
INSERT INTO sgb_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tampol lan imbalag ya lambat la, ta nakihonol hila kana. ");
INSERT INTO sgb_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ha pammita lan Apo Jesus ha laylay hên lanêm, ay nahêlêk na ya maának ni Zebedeo, ya hi Santiago haka hi Juan ya ampamitoyo hên lambat la, bayro ha bangka la. ");
INSERT INTO sgb_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tampol nan hinagyat hi Santiago haka hi Juan hên makihonol kana. Imbalag lay tatang la ha bangka hên kalamoy pan-upaan la ha pamandakêp kênan lanêm, ta nakihonol hila etaman kan Apo Jesus hên nanad kan Simon haka Andres. ");
INSERT INTO sgb_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nilumatêng hilan Apo Jesus ha balayan Capernaum. Ha allon pamagsimba, ay nanoro ya bayro ha sinagoga la. ");
INSERT INTO sgb_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Naubuh hilan nag-êpapah ha panoro na, gawan ya panoro na, ay nanad panoro hên main tungkulan, alwan nanad ha panoro lan mánoron Kautuhan ni apo Moises. ");
INSERT INTO sgb_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Bayro ha sinagoga, ay main lalaki ya hinapatan hên narawak ya a angkahêlêk. Nan-angaw ya hinumapat kana, ya wana, ");
INSERT INTO sgb_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jesus ya taga-Nazaret, hinoy ampakiêmênan mo kannaên? Labay mo kay hên parusaan? Muwang ko no hino ka. Hika ya banal, ya ayn hinon kasalanan, ya in-utoh ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Hên nagilam ni Apo Jesus ya hinabi nan hinumapat kanan hatoy lalaki, ay hinabyanan na ya, haka na ya impaplag, ya wana, “Paan kan maglabak! Mag-alíh ka ha hinapatan mo!” ");
INSERT INTO sgb_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Intumba ya lalaki hên hatoy hinumapat kana, haka na ya imbuwad-buwad, bayo nag-alíh ya kanan lalaki hên ampan-angaw. ");
INSERT INTO sgb_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nag-êpapah hilay atsi bayro, ta nihahabi hila, ya wanla, “Hino ya magkatoroan hên hatsi? Mihay bayoy toro lawêh! Nag tungkulan haka kapangyarihan ya pami-utoh nan paypaplag hên nangarawak ya a angkahêlêk ya hinumapat ha tawo.” ");
INSERT INTO sgb_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Habaytoy dinyag ni Apo Jesus, ay tampol nibahwag ha boon probinsyan Galilea. ");
INSERT INTO sgb_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Pamakaawah ni Apo Jesus ha sinagoga, hên kalamo na hi Santiago, hi Juan, hi Simon Pedro haka hi Andres, ay nagpakha hila ha bali lan Simon haka Andres. ");
INSERT INTO sgb_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nalatngan lay ampo ni Simon, ha papag, hên main hadyay omot. Kabay pinikihabi la kan Apo Jesus ya paalihên nay omot nan habaytoy bakêt, ya ampo ni Simon. ");
INSERT INTO sgb_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Dinumani hi Apo Jesus kana, tinalan nay gamêt, ta impaimata na ya, haka naalíh ya omot na. Bayo namakan ya kanlan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Hên ampinaboy nay allo, ay gintan la kan Apo Jesus ya nipaghakit, haka hilay hinapatan hên nangarawak ya a angkahêlêk. ");
INSERT INTO sgb_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nagtsipon ya boon balayan, ha ilwangan hên bali lan Simon. ");
INSERT INTO sgb_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Namaalíh hi Apo Jesus hên hino-hino kay na hên ya hakit la, haka impaplag nay nangarawak ya a angkahêlêk ya hinumapat kanlan kaatag. A na hila pinaulayan hên maghabi, ya impaplag na, gawan muwang la, ya hiyay Anak ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Dali allo pon, ay nammita yay na hi Apo Jesus ha mihay logal ya marayo ha tawo, ta nanalangin ya. ");
INSERT INTO sgb_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Noa, hilan Simon ay ampanapol kana. ");
INSERT INTO sgb_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Hên natapol la ya, ay hinabi la kana, ya antapolên la yan kal-atan. ");
INSERT INTO sgb_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Noa, wana kanla, “Lakwên tamo pon ya balayan di ha mamalibot ha logal ya habaytsi. Dapat ko etaman hên ipamwang kanla ya Mangêd ya Habi ya ubat kan Apo Namalyari. Kabay atsi ko di.” ");
INSERT INTO sgb_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nanoro yay na ha mal-at ya sinagoga lan Israelita ha boon probinsyan Galilea. Namipaplag ya hên nangarawak ya a angkahêlêk ya hinumapat hên namahakit kanlan atsi bayro. ");
INSERT INTO sgb_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Minghan hên main kal-atan ya nangamat kan Apo Jesus, ay main dinumani kana, ya mihay lalaki ya nag hakit ketong. Nandoko ya ha arapan ni Apo Jesus, ta wanan nakiingalo, “Panginoon, no kalabayan mo, ay paalihên moy hakit ko, êmên luminis ya lawini ko.” ");
INSERT INTO sgb_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Naingalwan ya ni Apo Jesus, kabay impalunto ni Apo Jesus ya gamêt na kana, ta wana, “Labay kon paalihên ya hakit mo. Luminis ka!” ");
INSERT INTO sgb_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tambêng naalíh ya hakit na. ");
INSERT INTO sgb_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Bayo in-utoh na ya ni Apo Jesus hên main panaad, ya wana, ");
INSERT INTO sgb_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Paan mo pon ipamwang ya hatsi ha hinoman. Pakha ka ha pari ta ipahlêk mo kana ya ayn kay nan ketong. Mantan kan maiparaya ha pamanhumonol mo ha utoh ni apo Moises, êmên paptêgan kanlan kaatag ya malinis kay na.” ");
INSERT INTO sgb_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Noa, hên nammita ya, ay impamwang nay pamipaalíh ni Apo Jesus hên ketong na, kabay lalon nibahwag ya kapangyarihan ni Apo Jesus, haka gawan ha kal-atan ya mabay manggilam hên toro na, ay a yay na makahowên ha hinon balayan bayro, ta a na hila makwan matoroan hên mangêd. Kabay napaidi ya tana ha marayo ha balayan, êmbayro man, ay nilako la yan kal-atan ubat ha ayri man ya logal. ");
INSERT INTO sgb_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Hên nakalabah ya ungnoy allo, ay nag-orong hilan Apo Jesus ha balayan Capernaum. Ya pamanlumatêng na bayro, ay nibahwag. ");
INSERT INTO sgb_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kabay ni-tsi-tsipon ya kal-atan bayro, angga ha napno ya bali haka ayn nanan dyanan agyan ha arapan hên ilwangan. Kaban an-ipamwang kanla ni Apo Jesus ya habi ni Apo Namalyari, ay ");
INSERT INTO sgb_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","main nilumatêng ya apat ya lalaki ya ampantan hên mihay lumpo ya atsi ha langkayan. Iarap la ya dayi kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Noa, gawan ha kal-atan, ay ayn hilan madanan. Kabay nunik hila ha bubungan ta nilubtan lay atêp ha dapit ugto ni Apo Jesus. In-antotoh lay lumpo ha pibonakan lan kal-atan ha arapan ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Hên nahêlêk ni Apo Jesus ya paniwala la kana, ay hinabi na kanan lumpo, “Pakhawên moy nakêm mo, ta pinatawad ya kasalanan mo.” ");
INSERT INTO sgb_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Main bayro hên mánoron Kautuhan ni apo Moises, ya ampangihip hên êmên di, ");
INSERT INTO sgb_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Hinoy hatsi ya an-ipantag nay sarili na kan Apo Namalyari hên mamatawad hên kasalanan? Yarin a nan ammusmusên hi Apo Namalyari ya tawo yan bêngat! Mimiha na ni Apo Namalyari ya makapatawad hên kasalanan.” ");
INSERT INTO sgb_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tampol nan namwangan ni Apo Jesus ya laman ihip la. Kabay hinabi na kanla, “Pata ampangihip kaw hên êmbayro? ");
INSERT INTO sgb_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Hino awud ya maparah hên habiên kanan mihay a ampakabita, no habiên ko, ‘Napatawad kay na ha kasalanan mo,’ o no habiên ko, ‘Hali, mirêng ka ta mita kay na.’ ");
INSERT INTO sgb_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Noa, êmên yo mamwangan ya hiko, ya Taga-Langit, ya In-anak Tawo, ay main tungkulan di ha luta hên mamatawad kasalanan, ay habiên ko kanan lumpo, ");
INSERT INTO sgb_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","‘Mirêng ka. Hapwatên moy langkayan mo ta muli kay na.’” ");
INSERT INTO sgb_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tambêng yan nirêng ha arapan la ya hata lumpo. Hinapwat nay langkayan na, ta nuli ya. Naubuh hilan nag-êpapah ya atsi bayro, kabay pinuri la hi Apo Namalyari, ya wanla, “Amêhên allo ay nakahêlêk kitamo hên a tamo êt nahêlêk.” ");
INSERT INTO sgb_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Bayo nag-orong yay na hi Apo Jesus ha laylay Dagat-dagatan hên Galilea. Pinakikamat-kamatan yan kal-atan, kabay tinoroan na hila. ");
INSERT INTO sgb_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pangayarin habayto, hên ampammita-bita ya, ay nakahêlêk yan mihay máningil buwih ya anak ni Alfeo, ya nag langan Levi, ya ampikno ha paningilan na. Hinabi ni Apo Jesus kana, ya wana, “Kihonol ka kangko.” Tampol ya etaman nakihonol kana. ");
INSERT INTO sgb_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Amêhên, hên atsi hilan Apo Jesus ha bali ni Levi hên ampangan, ay main nilumatêng ya kal-atan maningil buwih, ya kapareho ni Levi, haka kaatag êt ya makasalanan, ya ampakihonol kan Apo Jesus, ya kalamo la hên nangan. ");
INSERT INTO sgb_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Hên nahêlêk lan ungnoy mánoron Kautuhan ni apo Moises, ya Pariseo, ya ampangan hi Apo Jesus hên kalamo lan máningil buwih, haka kaatag êt ya makasalanan, ay nangotang hila kanlan tagahonol ni Apo Jesus, ya wanla, “Pata ampangan ya hên kalamo lan máningil buwih haka kaatag êt ya makasalanan?” ");
INSERT INTO sgb_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Hên nagilam nay hinabi la, ay nangalimbawa hi Apo Jesus, ya wana, “Hilay main hakit, ay ampangailangan doktor, alwan hilay ayn hakit. Êmbayro êt, atsi ko di ha luta ta êmên ko mahagyat hilay ampangamin makasalanan hila, hên maghêhê hên manalibokot ha pamanyag lan kasalanan. Noa, hilay ampaghabin ayn hilan kasalanan, ay a ko hawpan.” ");
INSERT INTO sgb_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Minghan hên nagtêêh hila hên a nangan, ta êmên a maabala ya panalangin la, ya tagahonol ni Juan Bautista haka hilay Pariseo, ay main ungno bayro ya naghabi kan Apo Jesus, ya wanla, “Hilay tagahonol ni Juan haka hilay tagahonol lan Pariseo, ay ampagtêêh hên a mangan, ta êmên a maabala ya panalangin la. Pata alwan êmbayro ya andaygên lan tagahonol mo?” ");
INSERT INTO sgb_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Kabay in-alimbawa ni Apo Jesus ya sarili na ha lalaki ya an-ikasal, ya wana, “Êndat yon a mangan ya bisita hên lalaki ya an-ikasal, no kalamo la ya? Siguradon mangan hila! ");
INSERT INTO sgb_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Lumatêng ya allo ya ipakarayo ya lalaki ya an-ikasal, ay bayro hilay nan a mangan.” ");
INSERT INTO sgb_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Amêhên, intoro ni Apo Jesus ya a mailamo ya toro na, ha toro lan ninuno la, ya wana, “Ayn mamitagpi hên bayoy tela, ya a pon napipi, ha gihi hên manan takop. No alimbawa ta daygên nay habayto, ta pipiên nay na, ay kumpêh ya intakap, haka humlay ya gihi. ");
INSERT INTO sgb_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ayn mamitugtug hên bayon alak ha ubatan hên manan alak gawan lumtoh ya pamyanan, haka mabullog ya alak. Ya bayoy alak ay dapat itugtug ha bayon pamyanan.” ");
INSERT INTO sgb_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mihay allon pamagsimba, hên nipadann hilan Apo Jesus ha nag trigo ya narani ha dann, ay nantê hilay tagahonol na hên pêrad. Kinêtêb la kaban ampammita hila. ");
INSERT INTO sgb_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Noa, nag Pariseo bayro ya naghabi kan Apo Jesus, ya wanla, “Pata nantê hilay tagahonol mo hên trigo ha allon pamagsimba, bawal man ya habayto ha Kautuhan tamo?” ");
INSERT INTO sgb_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Wana etaman ni Apo Jesus, “Kayno a yo pon nabaha ya dinyag ni Arin David hên haton panaon, hên hi Abiatar ay pinakapoon pari. Hên habayto, hiya, haka hilay kalamo na ay angkablay hên lonoh, kabay hinumwên ya ha bali ni Apo Namalyari ta nangwa yan puto ya imparaêp kan Apo Namalyari ya pangkaên bat hên pari. Bawal man ha Kautuhan ni apo Moises hên mangan hên habayto, ay nangan ya, bayo nam-i ya êt kanlan kalamo na.” ");
INSERT INTO sgb_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Inhundo ni Apo Jesus ya pamaghabi na kanlan Pariseo, ya wana, “Ya allon pamagsimba ay ha ikakangêd hên tawo. Ya tawo ay alwan ipoh hên allon pamagsimba. ");
INSERT INTO sgb_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Hiko ya Taga-Langit, ya In-anak Tawo, ay nag tungkulan hên maghabi no hinoy malyarin daygên ha allon pamagsimba.” ");
INSERT INTO sgb_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ha mihay na êt ya allon pamagsimba la, hên hinumwên hi Apo Jesus ha sinagoga ta manoro, ay main lalaki bayro ya natsi ya panabtab gamêt. ");
INSERT INTO sgb_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Hilay Pariseo haka mánoron Kautuhan ni apo Moises, ay ampangimaton kan Apo Jesus, no mamaalíh yan hakit ha allon pamagsimba la, ta êmên la yan bad-an hên ampanyag yan bawal ha allon pamagsimba. ");
INSERT INTO sgb_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Wani Apo Jesus kanan lalaki ya natsi ya gamêt, “Mirêng ka di ha arapan lan kal-atan.” Dinyag nay kalabayan ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Bayo kinotang ni Apo Jesus hilay Pariseo haka mánoron Kautuhan ni apo Moises, ya wana, “Hinoy nakahulat ha Kautuhan ni apo Moises ya tungkol ha dapat daygên ha allon pamagsimba? Manyag hên kangêran o manyag karawakan? Mamiligtas o mamatsi?” Noa, ayn miha man ya naghabi. ");
INSERT INTO sgb_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Amêhên, inubuh na hilan hinlêk ni Apo Jesus hên main huluk haka ingalo gawan ha kakdêyan ulo la. Bayo wana kanan lalaki ya natsi ya gamêt, “Ipaktang moy gamêt mo.” Hên impaktang na, ay naalíh ya hakit ha gamêt na. ");
INSERT INTO sgb_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tampol hilan nammita ya hilay Pariseo, haka kalamo lan kagampi ni Herodes Antipas, ay pinipupulungan lay na hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Hilan Apo Jesus etaman, ay nammitay na hên palako ha laylay hên Dagat-dagatan hên Galilea. Main hadyay kal-atan ya taga-probinsyan Galilea ya nangamat kanlan Apo Jesus hên manggilam toro na, haka magpaalíh hên hakit la. Main êt bayron kal-atan ya ubat ha probinsyan Judea, balayan Jerusalem, probinsyan Idumea, ha lipay hên Ilog Jordan, ha balayan Tiro boy Sidon, haka ha mamalibot bayro. ");
INSERT INTO sgb_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Gawan ha kal-atan, ay in-utoh nay tagahonol na, ya mamil-an hên bangka ya mahakyan na ta êmên ya a mapi-piitan hên kal-atan. ");
INSERT INTO sgb_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Gawan mal-at ya inalihan nan hakit, gap-an la ya dayi hi Apo Jesus hên hilay nipaghakit ta êmên maalíh ya hakit la. ");
INSERT INTO sgb_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Hilay hinapatan hên nangarawak ya a angkahêlêk, ay ampandoko ha arapan na haka ampipan-angaw hilay hinumapat kanla, ya wanla, “Hika ya Anak ni Apo Namalyari!” ");
INSERT INTO sgb_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Noa, impakabawal na hila hên ipamwang ya hiyay Mesias, ya Cristo. ");
INSERT INTO sgb_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Bayo nilumakat hilan Apo Jesus ha mihay tawgtug. Hên nakalakat hilay na, ay pinarani na hilay tagahonol na. ");
INSERT INTO sgb_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Namili ya hên labinlowa kanla ya pinata-ngalanan nan apostol ya panay nan makalamo, haka iutoh nan mamipamwang hên Mangêd ya Habi, ");
INSERT INTO sgb_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","haka ya dyanan nan kapangyarihan hên mamaalíh hên nangarawak ya a angkahêlêk ya hinumapat ha tawo. ");
INSERT INTO sgb_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Habaytsi hilay labinlowa ya pinili na hên mag-in apostol na: hi Simon, ya pinata-ngalanan nan Pedro, ");
INSERT INTO sgb_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ya loway anak ni Zebedeo, hi Santiago haka hi Juan. (Pinata-ngalanan na hilan Boanerges, ya labay habiên makhaw ya nakêm la.) ");
INSERT INTO sgb_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ya kaatag ay hi Andres, hi Felipe, hi Bartolome, hi Mateo, hi Tomas, haka hi Santiago ya anak ni Alfeo, hi Tadeo, hi Simon ya Makabayan, ");
INSERT INTO sgb_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","haka hi Judas Iscariote ya nay-upit kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Hên nuli hilan Apo Jesus, ay nipagtsipon hilay na êt ya kal-atan, kabay a lay na maarap hên mangan hilan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nagilam lan kamag-anak ni Apo Jesus ya panhabiên lan kaatag, ya angkamurit yay na, kabay nammita hilay na ta iuli la ya dayi. ");
INSERT INTO sgb_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Main bayron mánoron Kautuhan ni apo Moises ya nilumohan ya ubat ha Jerusalem. Hinabi la ya hi Apo Jesus ay hinapatan ni Satanas, ya poon lan nangarawak ya a angkahêlêk. Haka hinabi la êt ya pamaalíh ni Apo Jesus hên nangarawak ya a angkahêlêk ya hinumapat ha tawo, ay ha kapangyarihan ni Satanas. ");
INSERT INTO sgb_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Pinarani na hilay habayto ta hinabi na kanlan paalimbawa, ya wana, “Yarin maipaplag ni Satanas ya sarili na! ");
INSERT INTO sgb_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","No alimbawa ta mipapatsi ya angkalokopan hên mihay bansa, ay mahira ya habayto. ");
INSERT INTO sgb_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Êmbayro êt ya malyari ha mipapamilya ya mipapatsi. ");
INSERT INTO sgb_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","No mipapatsi hilay angkalokopan ni Satanas, ay mahira ya pamanlokop na. ");
INSERT INTO sgb_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Hi Satanas ay nanad ha mihay makhaw, ya mal-at ya almas, ya ampamantay ha bali na. A makwa, ya hinon atsi kana, no a ya pon hambutên, haka gapohên. Noa, no gapohên ya, ay makwa ya kaganawan ya atsi kana. ");
INSERT INTO sgb_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Pakagilamên yoy habaytsi. Mapatawad hilay mipaghêhê ha nadyag lay kasalanan, haka ha hinabi lan pamaniran kapareho lan tawo, ");
INSERT INTO sgb_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","noa, ayn hinoman ya mapatawad ha hinabi lan pamaniran Espiritu ni Apo Namalyari. Ta habaytoy kasalanan, ay taganán ayn kapatawaran.” ");
INSERT INTO sgb_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Hinabi ni Apo Jesus ya habayto, ta êmên la mamwangan ya ha pangahabi la, ya hiyay hinapatan hên narawak ya a angkahêlêk, ay anhiraên lay Espiritu ni Apo Namalyari ya ampangubatan hên kapangyarihan ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Hên nilumatêng ya indo ni Apo Jesus haka hilay patêl na, ay a hila midani kana gawan ha kal-atan. Kabay impabaêg la ya tana. ");
INSERT INTO sgb_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Main naghabi kana, ya wana, “Atsi di ha ilwangan ya indo mo haka hilay patêl mo. Labay la kan makahabi.” ");
INSERT INTO sgb_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Wani Apo Jesus kana, “Hino ya indo ko, haka hino hilay patêl ko?” ");
INSERT INTO sgb_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Hinlêk nay nakaiknon nakapalibot kana, ta wana, “Hilay habaytsi ya indo ko, haka hilay patêl ko. ");
INSERT INTO sgb_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Hilay ampanyag kalabayan ni Apo Namalyari, ay yabay ya anlugurên ko hên nanad ha pamanlugud ko ha indo ko, haka hilay patêl ko.” ");
INSERT INTO sgb_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Nanoro yay na êt hi Apo Jesus ha laylay Dagat-dagatan hên Galilea. Gawan ha hadyay kal-atan ya ampipagtsipon hên labay manggilam toro na, ay hinumakay ya ha mihay bangka, ta bayro yan nikno hên nanoro kanlan hadyay kal-atan ya atsi ha laylay. ");
INSERT INTO sgb_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ha pamanoro na kanla, ay mal-at ya paalimbawa, ya wana, ");
INSERT INTO sgb_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Pakagilamên yoy habaytsi! Main mihay lalaki ya namihabwag hên bini. ");
INSERT INTO sgb_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ha pamihabwag nan bini, ay main bini ya natata ha dann. Habaytoy tinuktuk hên manok. ");
INSERT INTO sgb_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ya kaatag ay natata ha mabato. Tampol yan tinumubo, gawan ha mababo ya luta. ");
INSERT INTO sgb_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Noa, hên nangallo, ay nayanto ya, gawan a nipakalalê ya yamot. ");
INSERT INTO sgb_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ya kaatag ay natata ha kadiwian. Tinumubo ya bini, noa, a hinumlay gawan diwi. ");
INSERT INTO sgb_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ya kaatag ay natata ha mataba ya luta. Tinumubo ya habaytoy bini haka naubuh hên nanagêy hên main manimagatoh ya lahí, anêmapo, o tatlumpo hên oman.” ");
INSERT INTO sgb_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Hên nahabi nay na ya habayto ni Apo Jesus, ay wana êt, “Pakaihipên yoy nagilam yo!” ");
INSERT INTO sgb_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Hên nakabita hilay nay kal-atan, ay main tanan ungno bayro ya kalamo lan labinloway tagahonol ni Apo Jesus, ya nangotang no hinoy labay habiên hên habaytoy alimbawa. ");
INSERT INTO sgb_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kabay wani Apo Jesus kanla, “Hikaw bat ya makamwang hên inlihim ya tungkol ha pamanlokop ni Apo Namalyari, noa, kanlan kaatag ay anhabiên ko ha alimbawan bêngat. ");
INSERT INTO sgb_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ta êmên, ‘Manlêk hila man, ay a la mamwangan ya anhêlkên la. Manggilam hila man, ay a la maintindihan. Ta kayno maintindihan la, haka maghêhê hilan dumani kan Apo Namalyari, bayo patawarên hila.’” ");
INSERT INTO sgb_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Bayo wanay na êt kanlan tagahonol na, “Awta a yo angkaintindihan ya alimbawa ya tungkol ha bini ya inhabwag! Ay-êmên yon maintindihan ya kaatag ya alimbawa! ");
INSERT INTO sgb_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ya ampamihabwag bini, ay ampamibahwag hên habi ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ya nakêm tawo ay in-alimbawa ha natataan bini. Ya bini ya natata ha dann ay habi ni Apo Namalyari ya nagilam lan tawo, noa, tampol nilumatêng hi Satanas, ta inalíh nay habaytoy habi ha nakêm la. ");
INSERT INTO sgb_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ya bini ya natata ha kabatoan, ay habi ni Apo Namalyari ya tinanggap lan tawo hên main kahiglaan, ");
INSERT INTO sgb_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","noa, a nimana ha nakêm la. Naniwala hila pon, noa, hên nilumatêng ya kairapan o pamairap, ay tampol naalíh ya paniwala la. ");
INSERT INTO sgb_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ya bini ya natata ha kadiwian ay habi ni Apo Namalyari ya ginilam lan tawo pon, ");
INSERT INTO sgb_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","noa, tampol nialíh ha nakêm la, gawan ha kayagahan, pibandian, haka katsighaw hên biyay la. Kabay a nabayo ya biyay la, hên nanad ha a nanagêy ya bini ya inhabwag. ");
INSERT INTO sgb_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ya bini ya inhabwag ha mataba ya luta ay habi ni Apo Namalyari ya ginilam lan tawo, bayo nimana ha nakêm la, ya nanad ha lahí ya naubuh hên nanagêy hên main manimagatoh ya lahí, anêmapo, o tatlumpon oman.” ");
INSERT INTO sgb_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Wanay na êt ni Apo Jesus, “Ayn mamagkêt hên atáng, bayo halokoban. A etaman idin ya atáng ha hilong pangkatuluyan. Noa, ya atáng ay idin ha mantêg hên pamyanan atáng. ");
INSERT INTO sgb_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ayn inhimpan ya a miawah. Ayn êt inlihim ya a mamwangan haka mihumbung. ");
INSERT INTO sgb_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Hikaw ya ampanggilam, ay pakaihipên yoy habayto.” ");
INSERT INTO sgb_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Inhundo ni Apo Jesus ya panoro na, ya wana, “Pakaihipên yoy angkagilam yo, ta no honolên yoy toro ko, ay taganán maintindihan yo. Ta no ay-êmên ya pamaytakal yon pamanggilam, ay êmbayro êt ya takal hên pamangintindi ya idin kamoyu ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","No honolên yoy toro ko, ay mapahanan ya pamangintindi yo, noa, no a yon honolên, ay alihên êt kamoyu ya pêpêrad ya naintindihan yo.” ");
INSERT INTO sgb_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Wanay na êt ni Apo Jesus kanla, “Ya pamanlokop ni Apo Namalyari ay maialimbawa ha pamantumubo hên bini ya in-êhad hên mihay lalaki. ");
INSERT INTO sgb_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Pinaulayan nan tinumubo, ta inhundo nay pamag-obra na hên allo-allo. Ya pamantumubon habayto, ay a na angkaintindihan no ay-êmên. ");
INSERT INTO sgb_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nag-in malakarayêm ya habayto gawan ha luta, haka tinumubo angga ha nanagêy hên mangataba ya lahí. ");
INSERT INTO sgb_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Hên nawtoy na, ay tampol nay nan ginapah gawan nilumatêng ya pamanggapah.” ");
INSERT INTO sgb_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Amêhên, inhundo ni Apo Jesus ya panoro na, ya wana, “Nanad hino kaya ya pamanlokop ni Apo Namalyari? Hino kaya ya pangialimbawaan ko hên pamanlokop na? ");
INSERT INTO sgb_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ya pamanlokop ni Apo Namalyari ay maialimbawa ha pamantumubo hên mihay nanaway but-o ya intanêm. Iibon man ya but-o, ");
INSERT INTO sgb_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ay hinumlay yan nag-in kayo, kabay nipanyag halay ya manok-lalê ha hanga na.” ");
INSERT INTO sgb_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Mal-at pon ya êmbayroy alimbawa ya intoro ni Apo Jesus kanlan kal-atan ya agyu lan maintindihan. ");
INSERT INTO sgb_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Hên nanoro hi Apo Jesus kanlan kal-atan, ay taganán mal-at ya alimbawa ha panoro na. Noa, hên hila-hila tanay labinloway tagahonol na, ay inubuh nan impamulah kanla ya habayto. ");
INSERT INTO sgb_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Habaytoy allo, hên yabi yana, ay hinabi ni Apo Jesus ha tagahonol na, “Magbangka kitamo hên lumipay ha dagat-dagatan.” ");
INSERT INTO sgb_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Imbalag lay kal-atan ta hinumakay hila ha bangka ya andyanan ni Apo Jesus, ta nag-umpisa hilay nan lumipay. Main êt hên kaatag ya bangka, ya nilumipay. ");
INSERT INTO sgb_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Amêhên, nagkamain hên hadyay angin, haka ya bangka la ay angkapnoy nan lanêm. ");
INSERT INTO sgb_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Hi Apo Jesus ay nabêlêw hên nakaulon ha dapit bulian hên bangka. Pinukaw la ya, ya wanla, “Mánoro! A mo muwang ya ampilêmêh kitamina?” ");
INSERT INTO sgb_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nimata ya, ta pinatunggên nay angin haka hadyay tandulon. Tinunggên etaman ya angin haka hadyay tandulon. ");
INSERT INTO sgb_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Bayo wana kanlan tagahonol na, “Pata hadyay limo yo! Ayn kaw pon awud hên paniwala kangko!” ");
INSERT INTO sgb_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Na-êngap hila ha hadyay limo la, haka ha pag-êpapah la, ay nihahabi hilan êmên di, “Hino kayay hatsi ya ampamipatunggên hên angin haka tandulon bayo anhumonol hila kana?” ");
INSERT INTO sgb_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nilumatêng hilan Apo Jesus ha logal lan Geraseno ha lipay dagat-dagatan ha êtêb hên probinsyan Galilea. ");
INSERT INTO sgb_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Pagtaoy ni Apo Jesus ha bangka, ay tinupa ya hên mihay lalaki ya hinapatan hên nangarawak ya a angkahêlêk ya ubat ha pay-ilbêngan. ");
INSERT INTO sgb_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ampaidi ya tana ha pay-ilbêngan. A la yay na maigapoh, hên taykala man. ");
INSERT INTO sgb_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kata-ungno lay nan an-igapoh, noa, panay nan pamboytoên ya taykala ha bitsih haka ha gamêt na. Ayn taganán ampakapatgên kana. ");
INSERT INTO sgb_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Allo-yabin nagkotawan ya ha pay-ilbêngan haka ha kabung-oyan hên ampiangaw-angaw hên anhugatên nay lawini na hên bato. ");
INSERT INTO sgb_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Hên nahêlêk na ya hi Apo Jesus ha marayo-dayo, nuwayu yan napaidani hên nandoko hên nakadêngdêng ha arapan na. ");
INSERT INTO sgb_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Nan-angaw ya, ya wana, “Jesus, ya Anak ni Apo Namalyari ya ayn kapantag ha kapangyarihan, awta ampakiêmênan mo ko? Maghumpa ka ha arapan ni Apo Namalyari, ya a mo kon parusaan!” ");
INSERT INTO sgb_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Hinabi nay habayto gawan ampaalihên ni Apo Jesus ya nangarawak ya a angkahêlêk ya nipanhumapat kana. ");
INSERT INTO sgb_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Amêhên, kinotang ya ni Apo Jesus, “Hinoy langan mo?” Wanlan hinumapat kana etaman, “Libo-Libo.” Hinabi lay habayto gawan mal-at hilay nangarawak ya a angkahêlêk ya nipanhumapat kana. ");
INSERT INTO sgb_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Habaytoy nipanhumapat ay nakiingalo kan Apo Jesus, ya paan hila dayin ipaplag ha logal ya habayto. ");
INSERT INTO sgb_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Main kal-atan baboy ya ampipambuk bayro ha talindah hên bung-oy ya nahêned ha dagat-dagatan. ");
INSERT INTO sgb_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nakiingalo hilay hinumapat hên paulayan hila dayi hên mipanhumapat kanlan baboy. ");
INSERT INTO sgb_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Pinaulayan na hila etaman ni Apo Jesus. Kabay inumalih hila kanan lalaki ta nipanhumapat hila kanlan baboy. Hilay manga lowan liboy baboy ya hinapatan la, ay nipamwayun palohan ha natalindah ya laylay lanêm hên nilêmêh ha dagat-dagatan. ");
INSERT INTO sgb_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Hilay manayhay hên baboy, ay nipamwayu, ta habaytoy nalyari, ay impamwang la ha kabaryo haka kabalayan la. Hên nagilam lan kaatag ya balita la, ay nilako lan hinlêk ya nalyari. ");
INSERT INTO sgb_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Hên nilumatêng hila kanlan Apo Jesus ay nahêlêk lay lalaki ya inalihan nangarawak ya a angkahêlêk. Nakatakop yay na haka ampikno hên napatêkbêk ya ihip. Naubuh hilan nalimwan ha kapangyarihan ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Impamwang lan nakahêlêk no ay-êmên yan namaalíh hên nangarawak ya a angkahêlêk ya hinumapat kanan lalaki, haka ya nalyari kanlan baboy. ");
INSERT INTO sgb_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Hên nagilam lay habayto, ay nakiingalo hila kan Apo Jesus ya mag-alíh ya ha logal la. ");
INSERT INTO sgb_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Hên anhumakay yay na hi Apo Jesus ha bangka, ay nakiingalo ya inalihan nangarawak ya a angkahêlêk hên gêtan ya dayi. ");
INSERT INTO sgb_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","A na ya pinaulayan, ta impaorong na ya ni Apo Jesus, ya wana, “Muli kay na ha bali mo ta ipamwang mo ya kangêran ya dinyag kamo hên Panginoon, haka no ay-êmên na kan iningalwan.” ");
INSERT INTO sgb_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nammita yay nay lalaki, ha mapoy balayan ha logal na, ya ambaêgên lan Decapolis, ta impamwang nay tungkol ha dinyag kana ni Apo Jesus, kabay naubuh hên nipag-êpapah hilay nakagilam. ");
INSERT INTO sgb_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Amêhên, ha pag-orong lan Apo Jesus hên nagbangkan ubat ha lipay, ay kal-atan ya nanupa kanla ha laylay lanêm. ");
INSERT INTO sgb_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Main dinumani hên nandoko hên nakadêngdêng ha bitsih ni Apo Jesus ya mihay ampamaala ha sinagoga, ya nag langan Jairo. ");
INSERT INTO sgb_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Impapakahabi na kan Apo Jesus, ya kihonol ya kana ha bali na, ta ipalunto nay gamêt na ha anak nay babayi, hên paalihên dayi ya hakit na, ta êmên ya mabiyay ya ampamêrad tanan matsi. ");
INSERT INTO sgb_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kabay nakihonol hilan Apo Jesus kan Jairo. Kal-atan ya nakihonol kanla haka ampi-pipiitan la hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kalamo lan hata kal-atan, ya mihay babayi ya labinloway taon nanan ampag-irap ha hakit nan andayaên. ");
INSERT INTO sgb_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Naiubuh nay na ya pibandian na ha hino-hino kay na hên ya doktor, haka nairapan ya êt ha pamanambal la hên hakit na, bayo nilumdêg êt ya habayto. ");
INSERT INTO sgb_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Hên namwangan na, ya tungkol kan Apo Jesus, ay dinumani ya kana hên ginapa ya takop ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Dinyag nay habayto ta hinabi na ha sarili na, no magapa nan bat ya takop ni Apo Jesus, ay maalíh ya hakit na. ");
INSERT INTO sgb_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tambêng etaman tinunggên ya ampantoloy daya na, kabay natanam nay naalíh ya hakit na. ");
INSERT INTO sgb_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tampol nan natanam ni Apo Jesus ya main inalihan hên hakit, gawan ha kapangyarihan na. Namalingay ya, ta wana, “Hinoy nakagapa hên takop ko?” Hên ayn mangamin, ay hinabi lan tagahonol na, ");
INSERT INTO sgb_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","“Panginoon, ampilolopungan la ka, haka la kan ampi-pipiitan hên kal-atan! Pata ampangotang ka no hinoy nakagapa kamo!” ");
INSERT INTO sgb_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Noa, ampakatapolên ni Apo Jesus no hinoy nakagapa kana. ");
INSERT INTO sgb_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nalimwan ya babayi gawan muwang na ya nalyari kana. Kabay ampamêgpêg yan nandoko hên nakadêngdêng ha arapan ni Apo Jesus, ta inamin na ya hiyay nakagapa kana haka naalíh ya hakit na. ");
INSERT INTO sgb_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Wani Apo Jesus kanan babayi, “Inalíh ya hakit mo gawan ha paniwala mo kangko. Muli kay na, hên mapatêkbêk ya ihip ta inalíh ya hakit mo.” ");
INSERT INTO sgb_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kaban ampaghabi ya pon hi Apo Jesus, ay main nilumatêng ya ubat ha bali ni Jairo, ya naghabi, “Natsi ya anak mo. A minan abalaên hi Apo Jesus hên maniraw ha bali.” ");
INSERT INTO sgb_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Noa, hên nagilam ni Apo Jesus ya habayto, ay wana kan Jairo, “Paan kan maglungkot. Ihundo moy paniwala mo ya maalíh koy hakit na.” ");
INSERT INTO sgb_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kabay inhundo lay pammita la. Ya pinaulayan nan bêngat ni Apo Jesus hên makilako kanla, ay hi Pedro, hi Santiago haka hi Juan ya kapotoh pohêl ni Santiago. ");
INSERT INTO sgb_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Panlumatêng la ha bali lan Jairo, ay nahêlêk ni Apo Jesus ya ampipanangih haka ampipanyêngên ya atsi bayro. ");
INSERT INTO sgb_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Kabay hinabi na kanla, “Paan kaw manangih, ta a ya natsi. Nabêlêw yan bêngat.” ");
INSERT INTO sgb_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kinailyan la ya hi Apo Jesus, ta muwang la ya pêtêg yay nan natsi. Hên naipaawah na hilay kal-atan ya atsi bayro, ay hinumwên yay na ha pinaypakatuluyan kanan anak, hên kalamoy toa na, haka ya tagahonol na hi Pedro, hi Juan, haka hi Santiago. ");
INSERT INTO sgb_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tinalan ni Apo Jesus ya gamêt nan anak, ta hinabi na, “Talita kumi,” ya labay habiên, “Anak ko, mimata ka.” ");
INSERT INTO sgb_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tambêng yan nimata ya anak, haka namita-bita. (Labinloway taon na.) Hadyay pag-êpapah lan atsi bayro. ");
INSERT INTO sgb_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Binawal na hila hên ipamwang ha kaatag ya biniyay nay anak. Hinabi na êt ya pakanên la ya. ");
INSERT INTO sgb_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Amêhên, nuli ya hi Apo Jesus ha balayan Nazaret, ya pinanhumlayan na. Kalamo na hilay tagahonol na. ");
INSERT INTO sgb_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Hên allon pamagsimba, ay hinumwên ya ha sinagoga la, ta nanoro ya. Haka ha pamanoro na, ay nipag-êpapah hilay nakagilam, ya wanla, “Ay-iri nan nakwa ya kamwangan na boy ya kapangyarihan na hên manyag hên kapapaêpapah? ");
INSERT INTO sgb_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Daptay hiyay kalpintero ya kabalayan tamo ya anak ni Maria! Yarin alwan hiyay patêl lan Santiago, Jose, Judas, haka hi Simon! Yarin alwan kabalayan tamo ya patêl nay babayi!” Kabay a la ya tinanggap. ");
INSERT INTO sgb_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Bayo wani Apo Jesus kanla, “Hilay propeta ni Apo Namalyari, ay anggalangên ha agyan ayri ya logal, noa, a hila ampansinên hên kamag-anak la haka kabalayan la.” ");
INSERT INTO sgb_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Gawan ayn hilan paniwala kana, ay pêrad bat ya inalihan nan hakit. Ayn kaatag ya kapapaêpapah ya dinyag na bayro ha Nazaret. ");
INSERT INTO sgb_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nag-êpapah hi Apo Jesus, ta taganán ayn hilan paniwala kana. Bayo nanoro ya hi Apo Jesus ha mal-at ya baryo ha namalibot hên Nazaret. ");
INSERT INTO sgb_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Haka tsinipon na ya labinloway tagahonol na, ta dinyanan na hilan kapangyarihan, hên mamaalíh hên nangarawak ya a angkahêlêk ya hinumapat ha tawo, bayo in-utoh na hila hên manilowa hên manoro. ");
INSERT INTO sgb_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Bayo hila nammita, ay hinabi na kanla, “Paan kaw mantan hên hinoman ya nanad ha puto, balutan, haka pera. Magtêkên kaw tana. ");
INSERT INTO sgb_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mag-apin kaw bitsih, noa, paan kaw mantan hên maihagili yoy takop. ");
INSERT INTO sgb_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Magdahêl kaw ha balin managyat kamoyu, haka bayro kaw tana, hên angga ha a pon nayari ya pamanoro yo, ha logal ya habayto. ");
INSERT INTO sgb_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","No a la kaw tanggapên, ta a hila mabay manggilam habi yo, ha mihay logal, ay bayo kaw mag-alíh bayro, ay ikampag yoy tuwapok ya atsi ha bitsih yo, ta êmên la mamwangan ya atsi tana kanla no lumatêng kanla ya parusa ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kabay nammita hilay nay labinlowa hên namipamwang ha kal-atan ya dapat lan paghêhêan hên talibatokan ya kasalanan la. ");
INSERT INTO sgb_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Namaalíh hila hên kal-atan nangarawak ya a angkahêlêk ya hinumapat ha tawo. Pinunihan lan pêrad ya laro ya kal-atan nipaghakit haka namaalíh hilan hakit la. ");
INSERT INTO sgb_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nagilam ni Herodes Antipas ya ampamaala ha probinsyan Galilea ya tungkol ha kapapaêpapah ya andaygên lan Apo Jesus, gawan habaytoy nibahwag. Main ampaghabin ampakadyag yan kapapaêpapah hi Apo Jesus gawan hiya hi Juan Bautista ya nangoman nabiyay. ");
INSERT INTO sgb_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Main kaatag ya ampaghabin kayno hi Apo Jesus ay Propeta Elias, ya nag-orong ha luta. Hilay kaatag êt ay ampaghabi ya hi Apo Jesus ay nanad kanlan kaatag ya propeta, ya mámipamwang hên an-ipaihip kanla ni Apo Namalyari hên haton lagi. ");
INSERT INTO sgb_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Noa, hên nagilam ni Herodes Antipas, ya anhabiên la, ay wana, “Ya ambaêgên lan Jesus, ay taganán hi Juan Bautista ya impapotoh kinay ulo, ya nabiyay oman, kabay ampakadyag yan kapapaêpapah!” ");
INSERT INTO sgb_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Hinabi nay habayto gawan hên hato ay hiyay naypadakêp, naypagapoh, haka naypahukul kan Juan, gawan kan Herodias, ya ahawa ni Felipe, ya ali ni Herodes Antipas, ya bat nan pinag-ahawa ni Herodes Antipas. ");
INSERT INTO sgb_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Panay nan an-ungkatên kan Herodes Antipas, ni Juan Bautista, ya wana, “Bawal ha Kautuhan ya pamag-ahawa mo kan Herodias ya ahawan ali mo!” ");
INSERT INTO sgb_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Gawan habayto, ay main yan hakit nakêm hi Herodias kan Juan, haka ipapatsi na ya dayi, noa, ayn yan madyag, ");
INSERT INTO sgb_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","gawan a na ya ampaulayan ni Herodes Antipas, ta anggalangên na hi Juan, gawan muwang na, ya mahonol hi Juan kan Apo Namalyari, haka ayn hilan mahabi ha biyay na. Labay-labay nan manggilam toro na, angkalipang man ya ihip na. ");
INSERT INTO sgb_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mihay allo nakaihip hi Herodias no ay-êmên na yan maipapatsi hi Juan Bautista. Hi Herodes Antipas, ay nagkaluto ha allon pamanêmtêm ha pay-anak kana. Hinagyat na hilay manungkulan na, haka hilay ampamaala ha hundaloh, haka hilay mabandi ha probinsyan Galilea hên magpakahigla hên kalamo na. ");
INSERT INTO sgb_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Timmalêk ya anak ni Herodias ha arapan hên kal-atan. Hinumigla hi Herodes Antipas haka hilay hinagyat na, ha pamagtalêk nan dalaga, kabay wani Herodes Antipas kanan dalaga, ya idin na kana ya hinon pakikwaan na kana. ");
INSERT INTO sgb_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nangako ya êt hên main kalamoy humpa, ya idin na kana ya kapitnan bandi na, no habaytoy labay na. ");
INSERT INTO sgb_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Inumawah ya dalaga ta kinotang nay indo na no hinoy pakikwaan na. Wana etaman ni Herodias, “Ya ulo ni Juan Bautista.” ");
INSERT INTO sgb_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tampol yan nag-orong ya dalaga, hên dinumani kan Herodes Antipas, ta pinakikwaan na, ya tampol ipapotoh ya ulo ni Juan Bautista, ta idin kanan dalaga ya habayto, hên nakapalunto ha pinggan. ");
INSERT INTO sgb_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Hadyay lungkot ni Herodes Antipas hên pakikwaan kana hên dalaga ya habayto, noa, a na ya matanggian gawan naghumpa ya, haka gawan ha kal-atan. ");
INSERT INTO sgb_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Hên habayto êt, ay in-utoh nay mihay hundaloh ha hukulan hên potohên nay ulo ni Juan Bautista. Tampol ya etaman nammita ha hukulan ya habaytoy hundaloh, ta pinotoh nay ulo ni Juan, ");
INSERT INTO sgb_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","hên indin ha pinggan, haka gintan kanan dalaga. Indin na etaman hên dalaga, ya habayto kan Herodias, ya indo na. ");
INSERT INTO sgb_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Hên namwangan lan tagahonol ni Juan ya nalyari kana, ay kingwa la ya bangkay na, haka lay na in-ilbêng. ");
INSERT INTO sgb_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Amêhên, hên nag-orong hilay nay labinloway tagahonol ni Apo Jesus ya in-utoh nan namitoro, ya ambaêgên la etaman hên apostol, ay ni-tsi-tsipon hila, ta in-ubuh lan in-istorya kana ya dinyag la haka intoro la. ");
INSERT INTO sgb_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Noa, a la angkadambi ya pangan la, gawan kal-atan ya angkapiuubah hên anlumatêng kanla. Kabay wani Apo Jesus kanla, “Magpainawa kitamo pon bayro ha logal ya kabalah-balahan.” ");
INSERT INTO sgb_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kabay hila-hila tanay himmakay ha bangka hên naglipay ha logal ya kabalah-balahan. ");
INSERT INTO sgb_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Noa, napansin lan kal-atan ya pamag-alíh la, haka ya pagpalakwan la, kabay binitsih lan inunaan hilan Apo Jesus, hên kalamo hilay ubat ha kaganawan balayan ya dinanan la. ");
INSERT INTO sgb_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Hên pataoy hilan Apo Jesus ha bangka, ay nahêlêk lay kal-atan, haka naingalwan na hila, gawan nanad hilan tupa ya ayn pastol, kabay mal-at ya intoro na kanla. ");
INSERT INTO sgb_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Hên maranin matata ya allo, ay hinabi lan tagahonol na kana, ya wanla, “Ayn bali di, haka maranin matata ya allo. ");
INSERT INTO sgb_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Dayi ipalako mo hilay kal-atan ha balang baryo, ya narani di, ta êmên hila makahaliw hên maêkan la.” ");
INSERT INTO sgb_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Noa, hinabi na kanla, ya wana, “Hikaw tanay mamakan kanla.” Kabay wanla kana, “Labay mon habiên, hikay ya manaliw hên pamangan lan kal-atan, ya magkaalaga hên upa hên mihay katawo ha waloy buwan!” ");
INSERT INTO sgb_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nangotang hi Apo Jesus, “Ungnoy puto yo? Hêlkên yo.” Hên namwangan lay na, ay hinabi la, “Li-limay puto haka lo-loway kênan lanêm.” ");
INSERT INTO sgb_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Bayo in-utoh ni Apo Jesus ha tagahonol na ya paiknoên lay kal-atan hên pusto-pusto. ");
INSERT INTO sgb_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kabay nipammikno hilay na hên pusto-pusto ya main mani-magatoh haka main mani-limampo. ");
INSERT INTO sgb_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Dinampot ni Apo Jesus ya limay puto haka loway kênan lanêm. Naningla ya, ta pinahalamatan nay habayto kan Apo Namalyari. Pino-potoh nay na, ta indin na kanlan tagahonol na, ta intayak la kanlan kal-atan. ");
INSERT INTO sgb_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Balang miha ya atsi bayro ay nakaêkan angga ha nangabhoy hila. ");
INSERT INTO sgb_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Hên tsinipon la ya tagan, ay nakapno hila êt hên labinloway lubon. ");
INSERT INTO sgb_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Main liman libo ya lalaki ya nangan. ");
INSERT INTO sgb_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tampol nan pinahakay ni Apo Jesus ha bangka hilay tagahonol na, hên impauna hên lumipay ha Betsaida, kaban ampauliên na pon ya kal-atan. ");
INSERT INTO sgb_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Hên nagtsipan ya kanla hi Apo Jesus, ay nilumakat yay nan nanalangin. ");
INSERT INTO sgb_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Hên yabi yana, kaban ampanalangin yan miha na, ay atsi hilay na ha bonak dagat-dagatan ya tagahonol na. ");
INSERT INTO sgb_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nahêlêk na hilay angkairapan hên lumipay, gawan panhalungatên hilan angin. Hên nawatah, ay nilako na hila hên nammita ha babon lanêm, hên makipantag ya dayi kanla, ");
INSERT INTO sgb_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","noa, hên nahêlêk la yay ampita ha babon lanêm, ay nipan-angaw hila, ta êndat la no hiyay mihay kamana. ");
INSERT INTO sgb_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Naubuh hilan nakahêlêk kana, haka hadyay limo la. Noa, tampol nan hinabi kanla, ya wana, “Paan kaw malimo! Pakhawên yoy nakêm yo! Hikoy habaytsi!” ");
INSERT INTO sgb_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Hên nakahakay yay na ha bangka, ay tinunggên ya angin. Hadyay êpapah la kana, ");
INSERT INTO sgb_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","gawan nahêlêk la man, ya pinalakê nay puto, ay a la pon angkaintindihan ya madyag nay hinoman, ha kapangyarihan ni Apo Namalyari, ta taganán a la makwan ihipên ya nalyari. ");
INSERT INTO sgb_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pamakalipay lan Apo Jesus, ay impadann lay bangka ha dani hên Genesaret. ");
INSERT INTO sgb_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Hên nakataoy hilan Apo Jesus, ay tampol la yan nabalayan. ");
INSERT INTO sgb_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Pinarah lan impamwang ha boon logal ya habayto, ya nilumatêng hilan Apo Jesus. Kabay hinapwat la hila ha angkatuluyan la ya nipaghakit hên gintan kana ay-iri man ya nilako na. ");
INSERT INTO sgb_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Anto man ya lakwên nay balayan, baryo, o hinon logal ya main bali, ay anggêtan la ha andanan na, ya nipaghakit. Ampakiingalo hila kan Apo Jesus, ya agyan laylayan dayin takop na, ya magapa lan ampaghakit. Haka hilay nakagapa takop na, ay naalihan etaman hakit. ");
INSERT INTO sgb_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Panga-ubat hên habayto, ay main ungnoy Pariseo haka mánoron Kautuhan ni apo Moises ya ubat ha balayan Jerusalem ya nipandumani kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Nadambi la ya main tagahonol ni Apo Jesus ya bat hên nangan hên a hinumonol ha natotoan la ha ninuno, no ay-êmên ya pamag-uyah bayo mangan. Kabay êndat lan Pariseo, ya marêmêk hilay tagahonol na, ha hêlêk ni Apo Namalyari, ");
INSERT INTO sgb_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ta hilay Pariseo haka hilay kaatag pon ya Israelita, ay a mangan no a hila pon nag-uyah hên nanad ha natotoan la ha ninuno. ");
INSERT INTO sgb_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Haka a lan bat angkaên ya ubat ha palengke, no a la pon uyahan. Mal-at pon ya natotoan la ha ninuno ya anhonolên la ya tungkol ha pamanguyah hên pamminêman, pamyanan lanêm haka kaldero ya dyag ha tangso. ");
INSERT INTO sgb_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kabay nangotang hila kan Apo Jesus ya hilay Pariseo, haka mánoron Kautuhan ni apo Moises, ya wanla, “Pata a hila anhumonol ya tagahonol mo ha natotoan tamo ha ninuno tamo, no ay-êmên ya pamag-uyah bayo mangan?” ");
INSERT INTO sgb_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Wani Apo Jesus, “Pêtêg ya impapêt ni Propeta Isaias ya tungkol kamoyun mapagbabara, ya wana ha Kahulatan ya impahulat ni Apo Namalyari, ‘Ya pamagpuri la kangko, ay atsin bat ha bêbêy la, ta ayn ha nakêm la. ");
INSERT INTO sgb_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ayn kapukat-pukat ya pamagsimba la kangko, ta ya natotoan la ha ninuno, ay an-itoro la hên nanad ha paytoro la hên Kautuhan ko.’ ");
INSERT INTO sgb_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Angkapaulayan yoy Kautuhan ni Apo Namalyari, ta anhonolên yoy natotoan yo ha ninuno yo.” ");
INSERT INTO sgb_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Bayo wana êt ni Apo Jesus, “Magaling kaw hên itad hên ayn alagá ya utoh ni Apo Namalyari, mahonol yon bat ya natotoan yo ha ninuno! ");
INSERT INTO sgb_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ta ya impahulat ni Apo Namalyari kan apo Moises, ay êmên di, ‘Galangên moy tatang haka indo mo,’ haka ‘Hinoman ya maniran toa na, ay dapat patsên.’ ");
INSERT INTO sgb_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Noa, an-itoro yo ya malyarin ialay kan Apo Namalyari, ya dapat ihawop ha toa. ");
INSERT INTO sgb_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ha pamanoro yon habayto, ay an-ibawal yoy pamanawop ha toa, ");
INSERT INTO sgb_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ta antuwarên yoy ninuno yo, hên an-itad yon ayn alagá ya Habi ni Apo Namalyari. Haka kal-atan pon ya êmbahên ya andaygên yo.” ");
INSERT INTO sgb_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Bayo pinarani ni Apo Jesus ya kal-atan, ta wana kanla, “Manggilam kaw haka pakaintindiên yoy habaytsi. ");
INSERT INTO sgb_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Alwan ya an-ihubo ha bêbêy ya ampakarêmêk hên tawo ha hêlêk ni Apo Namalyari, noa, ya ampakarêmêk, ay ya nangarawak ya habi ya angkaubat ha bêbêy. ");
INSERT INTO sgb_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(Pakaihipên yoy nagilam yo!)” ");
INSERT INTO sgb_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Pamakayari nan naghabi, ay imbalag ni Apo Jesus ya kal-atan, ta hinumwên ya ha lalên bali. Bayo nangotang hilay tagahonol na no hinoy labay habiên hên habaytoy alimbawa. ");
INSERT INTO sgb_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Wana etaman kanla, “Hikaw man, ay a kaw ampakaintindi? Alwan pamangan ya an-ihubo ha bêbêy ya ampakarêmêk hên tawo ha hêlêk ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ta ya pamangan, ay a ampidann ha nakêm, noa, ha bitoka bayo itaká.” Ha pangahabi ni Apo Jesus hên habayto, ay labay nan habiên ya ayn bawal ya pamangan. ");
INSERT INTO sgb_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Inhundo ni Apo Jesus ya pamaghabi na, ya wana, “Ta ya nangarawak ya habi ya angkaubat ha bêbêy, ay yabay ya ampakarêmêk hên tawo ha hêlêk ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ta angkaubat ha nakêm ya kaihipan hên manyag karawakan, nanad ha manyag karawakan kalabayan lawini, manakaw, mamatsin kaparehon tawo, ");
INSERT INTO sgb_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","makilalaki haka mamabayi, manyag kapanalarêhan, haka kaganawan karawakan nanad ha pamanloko, manyag kagatêan hên ayn pamagpigil ha sarili, bat maridya, maniran kapareho, mag-in mayabang, haka manyag ayn kapukatan. ");
INSERT INTO sgb_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kaganawan hên habayto ay angkaubat ha nakêm haka ampakarêmêk ha hêlêk ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Immalíh hilan Apo Jesus bayro hên palako ha Tiro ya logal hên alwan Israelita, haka hinumwên hila ha mihay bali bayro. A na labay hên mamwangan hên kaatag ya atsi hila bayro, ta magpainawa hila dayi, noa, napansinan hila. ");
INSERT INTO sgb_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Main bayron babayi ya nag anak ya hinapatan narawak ya a angkahêlêk, ya tampol hên nakamwang hên atsi ya bayro, kabay nilumatêng yan nandoko hên nakadêngdêng ha arapan na. ");
INSERT INTO sgb_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Habaytoy babayi ay alwan Israelita ta hiyay Griego ya taga-Sirofenicia. Nakiingalo ya kan Apo Jesus ya ipaplag ya hinumapat ha anak nay babayi. ");
INSERT INTO sgb_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Wani Apo Jesus kana, “Pakangêrên ko pon hên toroan haka hawpan ya hilay Israelita. Ta habaytoy taganán usto.” ");
INSERT INTO sgb_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Noa, hinabi nan babayi, ya wana, “Panginoon, mangêd ya habayto, noa, yarin a minan hawpan ya alwan Israelita no hadyay pamairap ya angkatanam la!” ");
INSERT INTO sgb_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Bayo wana kana, “Gawan ha paniwala mo kangko, ay muli kay na, ta naipaplag ya hinumapat ha anak mo.” ");
INSERT INTO sgb_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Hên nuli ya habaytoy babayi, ay nalatngan nay anak nay ampamatuloy hên napatêkbêk ha papag gawan naipaplag ya hinumapat kana. ");
INSERT INTO sgb_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ha pag-orong lan Apo Jesus hên ubat ha logal Tiro ay nagdann ya ha logal hên Sidon ha palakon Dagat-dagatan hên Galilea ha mapoy balayan ha logal, ya ambaêgên lan Decapolis. ");
INSERT INTO sgb_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Main ungno bayro ya nantan kan Apo Jesus hên mihay lalaki ya têkkên haka a makayn makahabi. Nakiingalo hila kana ya ipalunto nay gamêt kanan têkkên ta paalihên nay hakit na. ");
INSERT INTO sgb_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Indayo ni Apo Jesus ya lalaki kanlan kal-atan, ta ingkulug nay panoro na ha têkk nan lalaki, pangayari, ay nandula ya ha gamêt na ta impunih na ha dila nan lalaki. ");
INSERT INTO sgb_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Naningla hi Apo Jesus ha langit hên nakauyamêh ha panalangin na, bayo wana kanan lalaki, “Effata!” ya labay habiên, “Magloat!” ");
INSERT INTO sgb_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tampol ya etaman nakagilam haka nakapaghabi yay nan mangêd. ");
INSERT INTO sgb_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kata-ungno na hilan binawal ni Apo Jesus ya paan lan ipamwang ya habayto. Noa, lalo lan impamwang. ");
INSERT INTO sgb_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Hadyay êpapah la, ya wanla, “Mangêd ya kaganawan andaygên na. Ampagilamên nay têkkên haka ampahabiên nay pipi!” ");
INSERT INTO sgb_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Hên habayto, ay naka-tsipon hilay na êt ya kal-atan ya nanggilam hên toro ni Apo Jesus. Hên ayn hilay nan maêkan, ay binaêg ni Apo Jesus ya tagahonol na, ta wana kanla, ");
INSERT INTO sgb_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Kaingalo hilay kal-atan, ta tatloy nay allo la di, haka ayn hilay nan maêkan. ");
INSERT INTO sgb_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","No pauliên ko hilan angkablay lonoh, ay kayno mawê hila ha dann, ta marayo ya ubatan lan kaatag.” ");
INSERT INTO sgb_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Wanlan tagahonol na etaman, “Ay-êmên tamo hilan mapakan ya hata kal-atan di ha kabalah-balahan?” ");
INSERT INTO sgb_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Kinotang hila ni Apo Jesus, ya wana, “Main kitamo pon hên puto?” Wanla kana, “Main tanan pito.” ");
INSERT INTO sgb_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Bayo pinaikno na hilay kal-atan, haka na dinampot ya pitoy puto, ta impahalamat na kan Apo Namalyari, bayo pino-potoh nay habayto, ta impatayak na kanlan tagahonol na. ");
INSERT INTO sgb_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Main hila etaman hên ungnoy nanganaway kênan lanêm ya pinirito. Impahalamat na êt kan Apo Namalyari ya habayto, bayo impatayak na etaman kanlan tagahonol na. ");
INSERT INTO sgb_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Naubuh hilan nangabhoy ya kal-atan, haka hên tsinipon lay tagan, ay nakapno hila hên pitoy lubon. ");
INSERT INTO sgb_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Main manga apat ya libo ya nangabhoy. Bayo nagtsipan yay na kanla. ");
INSERT INTO sgb_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Hilan Apo Jesus etaman, ay hinumakay ha bangka hên palako ha logal hên Dalmanuta. ");
INSERT INTO sgb_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Main ungnoy Pariseo ya nilumatêng, ta pinakihubakan la ya hi Apo Jesus. Sinubuk la yan mamipahlêk yan kapapaêpapah ya ubat ha langit, ta êmên la mamwangan no pêtêg hên atsi kana ya kapangyarihan ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nakauyamêh ya hi Apo Jesus, bayo wana, “Hay! Awta ampanapol kaw hên kapapaêpapah! Pakagilamên yo! Taganán ayn ipahlêk kamoyu ya palatandaan ya hikoy in-utoh ni Apo Namalyari!” ");
INSERT INTO sgb_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Bayo nilakwanan na hilay na, ta himmakay hilay na ha bangka hên palipay hilan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Naliwaan lan tagahonol ni Apo Jesus hên mantan puto, kabay mimiha tanay puto ya atsi ha bangka. ");
INSERT INTO sgb_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Bayo binilinan hila ni Apo Jesus ya wana, “Kaillag kaw ha pampaalsa lan Pariseo haka ha pampaalsa ni Herodes Antipas.” ");
INSERT INTO sgb_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Gawan ha hinabi ni Apo Jesus, ay êndat lan tagahonol na no mantêg pampaalsa hên arina ya hinabi na kanla, kabay nihahabi hila, ya wanla, “Hinabi nay habayto gawan a kitamo nakagêtan puto.” ");
INSERT INTO sgb_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Muwang ni Apo Jesus ya ampihahabian la, kabay wana kanla, “Pata an-ikayagah yoy a kaw nakagêtan puto! A kaw pon awud hên ampakaintindi! A yo pon angkakwan ihipên no ay-irin ubat ya kapangyarihan ko! ");
INSERT INTO sgb_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nanad kaw ayn mata, haka ayn têkk! Naliwaan yoy na lawêh hên pinakan koy liman libo ha li-limay puto! ");
INSERT INTO sgb_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ungnoy lubon ya napno hên tagan ya tsinipon yo?” Wanla kana, “Labinloway lubon.” ");
INSERT INTO sgb_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Wanay na êt ni Apo Jesus, “Haka ungnoy lubon ya napno hên tagan ya tsinipon yo hên pinakan koy apat ya libo ha pi-pitoy puto?” Wanla etaman, “Pitoy lubon.” ");
INSERT INTO sgb_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Bayo wana kanla, “A kaw pon ampakaintindi?” ");
INSERT INTO sgb_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Hên nilumatêng hilan Apo Jesus ha balayan Betsaida, ay main ungno bayro ya nantan hên mihay lalaki ya buwag, ya pinakiingalo la kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Inakay ni Apo Jesus ya buwag hên indayo ha balayan. Bayo nandula ya ha gamêt na, ta impunih na ha mata nan buwag, bayo impalunto nay gamêt na kana, haka kinotang na ya, no ampakahêlêk yay na. ");
INSERT INTO sgb_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Wana etaman hên buwag, “Naburarêg pon ya angkahêlêk ko, ya tawoy ampammita, ay nanad kayo.” ");
INSERT INTO sgb_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Inapoap nan oman ni Apo Jesus ya mata nan lalaki. Kanan habayto, ay impakamukat nan lalaki ya mata na, haka alway nan naburarêg ya hêlêk na, ta ampakahêlêk yay nan mangêd. ");
INSERT INTO sgb_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Bayo nagtsipan hi Apo Jesus kana, ta wana, “Muli kay na, noa, paan kan magdann ha baryo.” ");
INSERT INTO sgb_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Bayo nammita hilan Apo Jesus palako ha balang baryo ya angkasakopan hên balayan Cesarea Filipos. Kaban ampita hila, ay kinotang nay tagahonol na, ya wana, “Hino ko kano?” ");
INSERT INTO sgb_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Kabay hinabi la, “Wanlan kaatag ya hika ay hi Juan Bautista. Noa, wanlan kaatag êt ya hika ay hi Propeta Elias. Hilay kaatag êt ay ampaghabin ya nabiyay oman ya miha kanlan unan mámipamwang hên an-ipaihip kanla ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Wana êt kanla ni Apo Jesus, “Kamoyu etaman, hino ko ha ihip yo?” Wani Pedro etaman, “Hika ya Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala.” ");
INSERT INTO sgb_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Noa, impapakabawal na hila hên ipamwang ha hinoman ya hiyay Cristo. ");
INSERT INTO sgb_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Bayo impamwang ni Apo Jesus kanlan tagahonol na, ya malyari kana lumatêng ya allo, ya wana, “Hiko ya Taga-Langit, ya In-anak Tawo, ay kailangan magdanas hên hadyay pamagdusa. Hikoy araên lan mánoron Kautuhan ni apo Moises. Araên la kon toa ya nag tungkulan ha bansa, haka araên la ko êt hên ampamaala kanlan pari. Ipapatsi la ko, noa, ha ikatlon allo ay biyayên akon oman.” ");
INSERT INTO sgb_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Impapakamulah ni Apo Jesus ya habayto kanla. Kabay indayo yan pêrad ni Pedro ta hinabyanan na ya, gawan êndat nan a patsên ya Mesias, ya Cristo. ");
INSERT INTO sgb_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Noa, immarap hi Apo Jesus ha kaatag ya tagahonol na, bayo hinabyanan na hi Pedro, ya wana, “Pedro, paan mo kon tuksoên hên nanad ha pamanukso kangko ni Satanas! Ya pan-ihipên mo ay alwan kaihipan ni Apo Namalyari, noa, kaihipan hên tawo!” ");
INSERT INTO sgb_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Bayo pinarani nay kal-atan hên kalamoy tagahonol na, ta wana kanla, “Hilay labay hên humonol kangko, ay dapat liwaan ya sarili lan kalabayan haka humonol kangko. Dapat nakal-an hilan magtêêh hên pamairap haka matsi, ya maialimbawa ha pamakay hên nabyat ya koros. ");
INSERT INTO sgb_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Hila etaman ya a anhumonol kangko, gawan a la labay hên matsi o mangoman ya pamimiyay la, ay matsi etaman. Noa, hilay matsi gawan ha paniwala la kangko haka ha pamipamwang lan Mangêd ya Habi tungkol kangko, ay dyanan biyay ya ayn angga. ");
INSERT INTO sgb_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mikamihan man kanan mihay tawo ya pibandian di ha luta, ay a na mapakinabangnan ya habayto, no hiya etaman ay mipalako ha kaparusaan ya ayn angga! ");
INSERT INTO sgb_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Yarin matanggap ya pibandian na, ta êmên a mipalako ha kaparusaan ya ayn angga ya kaêlwa na! ");
INSERT INTO sgb_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Hilay tawo amêhên ay taganán makasalanan, haka tinalibatokan la hi Apo Namalyari. No araên la ko, ya Taga-Langit, ya In-anak Tawo, haka no araên lay toro ko, ay araên ko hila êt ha pag-orong ko di. Ha pag-orong ko, ay atsi kangko ya kapahilêw ya kahampatan ni Apo Namalyari, ya Tatang ko, haka kalamo ko hilay anghel na.” ");
INSERT INTO sgb_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Inhundo ni Apo Jesus ya pamaghabi na kanlan tagahonol na, ya wana, “Pakagilamên yoy habaytsi, ya main ungno di kamoyu ya a matsi angga ha mahêlêk la, ya nilumatêng ya pamanlokop ni Apo Namalyari hên main kapangyarihan.” ");
INSERT INTO sgb_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Hên nalabah ya anêm ya allo paubat hên hinabi nay habayto ni Apo Jesus, ay pinaglamo na hi Pedro, hi Juan haka hi Santiago, hên nilumakat ha matag-ay ya tawgtug hên kakapag la. Kaban atsi hila bayro, ay naoman ya itsura ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ya takop na ay nag-in bapan putsi ya kapahilêw, ya ayn kapantag ha kaputsian. ");
INSERT INTO sgb_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Namakonkaynaman ay main loway mámipamwang ya an-ipaihip kanla ni Apo Namalyari ya ubat ha langit, ya hi apo Moises haka hi apo Elias ya kalamo ni Apo Jesus hên ampihahabi. ");
INSERT INTO sgb_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Bayo hinabi ni Pedro, ya wana, “Mánoro, mangêd ya atsi kitamo di. Manyag kay hên tatloy hawong. Miha kamo, miha kan apo Moises, haka miha kan apo Elias.” ");
INSERT INTO sgb_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Hinabi nay habayto ni Pedro gawan nakatsigag ya haka hilan Juan. ");
INSERT INTO sgb_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ampaghabi ya pon hi Pedro hên inupungan hila hên ginêm, haka main hilan nagilam ya habi ya ubat ha ginêm, ya wanan habi, “Hatsi ya anlugurên kon anak. Gilamên yoy anhabiên na.” ");
INSERT INTO sgb_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Hên tinunggên ya habi, ay nanlêk hilan Pedro ha palibot, noa, mimiha na tana ni Apo Jesus ya angkahêlêk la. ");
INSERT INTO sgb_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ha paglohan la hên ubat ha tawgtug, ay impapakabawal ni Apo Jesus hilay habaytoy tatloy tagahonol na hên ipamwang ha hinoman ya nahêlêk la ha tawgtug, angga ha a ya pon matsi haka mabiyay oman, ya hiya, ya Taga-Langit, ya In-anak Tawo. ");
INSERT INTO sgb_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kabay a la impamwang ya habayto ha hinoman. Pinihahabian la no hinoy labay habiên ya mabiyay yan oman. ");
INSERT INTO sgb_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Gawan nahêlêk la bayro ha tawgtug hi apo Elias, ay kinotang la ya, ya wanla, “Awta panhabiên lan mánoron Kautuhan ni apo Moises, ya kailangan mag-orong ya pon di ha luta hi apo Elias bayo ya lumatêng ya Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala?” ");
INSERT INTO sgb_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Wana etaman ni Apo Jesus, “Taganán nakahulat ha habi ni Apo Namalyari ya main nanad kan apo Elias ya manlêan hên nakêm ha pamanlumatêng ko. Haka nakahulat etaman ya hiko, ya Taga-Langit, ya In-anak Tawo, ay araên haka dapat magtêêh hên hadyay pamagdusa. ");
INSERT INTO sgb_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Noa, anhabiên ko kamoyu, ya nilumatêng yay na ya nanad kan apo Elias, haka a la ya nabalayan, ya hiyay habayto ya lumatêng bayo ya lumatêng ya Mesias, ya Cristo, ta dinyag la kana, ya labay la, hên nanad ha impamwang ha Kahulatan ya tungkol kana.” ");
INSERT INTO sgb_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Hên nakalohan hilay na ha tawgtug, hên marani hilay na ha andyanan lan kaatag ya tagahonol na, ay nahêlêk lay kal-atan ya nakapalibot kanla. Haka napansin la ya main mánoron Kautuhan ni apo Moises ya ampakihubak kanla. ");
INSERT INTO sgb_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Hên nahêlêk lan kal-atan hi Apo Jesus, ay nipag-êpapah hilan nuwayun nanupa kana. ");
INSERT INTO sgb_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Kinotang ni Apo Jesus hilay tagahonol na ya wana, “Hinoy ampihuhubakan yo?” ");
INSERT INTO sgb_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Wanan miha bayro, “Mánoro, gintan ko di kamo ya anak koy lalaki, ya anhapatan hên narawak ya a angkahêlêk, haka a yay na ampakahabi. ");
INSERT INTO sgb_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","No andawhongên na yan anhumapat kana, ay an-itumba na ya ha luta, bayo maggalak ya bêbêy na. Ampag-ngê-ngêt ya, haka angkumdêy ya lawini na. Pinakihabi kina ha tagahonol mo ya paalihên lay hinumapat, noa, a la ya agyu hên paalihên.” ");
INSERT INTO sgb_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Kabay wani Apo Jesus, “Hikaw ya angkabiyay amêhên ay ayn paniwala! Aydin angga kataw hên pakilamoan haka pakitagalan?” Bayo wana kanan lalaki, “Gêtan mo di ya anak mo.” ");
INSERT INTO sgb_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Gintan lay anak kan Apo Jesus. Hên nahêlêk na hi Apo Jesus, hên hatoy hinumapat kanan anak, ay impatumba nay anak hên imbuwad-buwad hên ampaggalak ya bêbêy. ");
INSERT INTO sgb_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Kinotang ni Apo Jesus ya toa nan anak, “Nakano yan unan hinapatan?” Wanan toa na, “Paubat hên nanawa ya pon. ");
INSERT INTO sgb_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","No andawhongên na ya, ay panay na yan an-itapon ha apoy, o an-ihugno ha lanêm ta patsên na ya dayi. Noa, no main kan madyag, ay ingalwan mo kay dayi, hên paalihên mo ya kana.” ");
INSERT INTO sgb_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Bayo wani Apo Jesus, “Pata nahabi mo, no main akon madyag? Hilay ampaniwala kan Apo Namalyari ay makadyag hên kaganawan!” ");
INSERT INTO sgb_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","In-ikhaw nan inhabi hên toa nan anak, ya wana, “Ampaniwala ko! Noa, no main pamagkulang ha paniwala ko, ay pahanan mina dayi!” ");
INSERT INTO sgb_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Hên nahêlêk ni Apo Jesus ya kal-atan ya anlumatêng, ay namipaplag ya hên hinumapat kanan anak, ya wana, “Hika ya namatêkk haka namaomêl kanan hata anak, ay mag-alíh ka kana, haka paan kay nan humapat kana!” ");
INSERT INTO sgb_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Hadyay angaw nan hinumapat kanan anak, intumba nay anak, haka hadyay pamibwad-bwad na kana, bayo inumalih yay na. Haka nanad hên bangkay ya lawini nan anak. Kabay êndat lan kal-atan ya natsi yay na. ");
INSERT INTO sgb_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Noa, tinalan ni Apo Jesus ya gamêt na ta impairêng na ya, nirêng ya etaman ya anak. ");
INSERT INTO sgb_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Hên nakahowên hilan Apo Jesus ha bali ya ampaidyanan la, ay kinotang la yan tagahonol na no awta a la ya napaalíh ya hinumapat kanan anak. ");
INSERT INTO sgb_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Wana etaman ni Apo Jesus, “Ya êmbayroy narawak ya a angkahêlêk, ay a mapaalíh no alwan gawan ha pamanalangin.” ");
INSERT INTO sgb_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nag-alíh hilan Apo Jesus bayro, haka nagdann hila ha probinsyan Galilea, ta êmên ayn makamwang no antoy andyanan la, ");
INSERT INTO sgb_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ta antoroan nay tagahonol na, ya wana, “Hiko ya Taga-Langit, ya In-anak Tawo, ay i-upit ha kapatsi ko. Patsên la ko, noa, ha ikatlon allo, ay mabiyay kon oman.” ");
INSERT INTO sgb_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Noa, a la naintindihan hên tagahonol na ya habaytoy hinabi na. Malimo hila etaman hên mangotáng kana. ");
INSERT INTO sgb_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Hên nilumatêng hilay na ha balayan Capernaum, hên atsi hilay na ha mihay bali, ay kinotang ni Apo Jesus hilay tagahonol na no hino ya pinihuhubakan la ha dann. ");
INSERT INTO sgb_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Noa, ayn kanla ya naghabi, gawan marêng-êy hila ta pinihuhubakan la no hino kanla ya matag-ay ya tungkulan. ");
INSERT INTO sgb_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nikno hi Apo Jesus, ta binaêg na hilay labinloway tagahonol na hên dumani kana, ta wana kanla, “Hilay labay mag-in matag-ay, ay kailangan magpakaaypa hên maghuyo kanlan ampangailangan hên hawop.” ");
INSERT INTO sgb_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Binaêg nay mihay anak ya nanawa hên mirêng ha arapan la ta tinakêh na ya, bayo wana kanlan tagahonol na, ");
INSERT INTO sgb_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Hinoman ya ampaniwala kangko, ya ampananggap kanlan maaypa ya nakêm nanad hata anak, hên gawan habaytoy paniwala la kangko, ay nanad hiko ya antanggapên la. Hila etaman ya ampananggap kangko, ay antanggapên la hi Apo Namalyari ya namiutoh kangko.” ");
INSERT INTO sgb_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Wani Juan kan Apo Jesus, “Manoro, nahêlêk naên ya mihay lalaki ya ampanggamit hên langan mo ha pamaalíh hên nangarawak ya a angkahêlêk. Binawal naên ya gawan alwa tamo yan kalamo.” ");
INSERT INTO sgb_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Noa, wani Apo Jesus kana, “Paan yo yan bawalên, ta ayn manyag hên kapapaêpapah ha langan ko, bayo maghabin halanghang kangko. ");
INSERT INTO sgb_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Hilay a ampanalanghang kantamo ay ampanawop kantamo. ");
INSERT INTO sgb_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Pakagilamên yo! Hilay mam-i kamoyu hên mihay baso hên lanêm, gawan hikaw ay ambaêgên tagahonol ko, ay taganán tumbahan hila etaman ni Apo Namalyari hên kangêran.” ");
INSERT INTO sgb_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Inhundo ni Apo Jesus ya pamaghabi na, ya wana, “Hinoman ya pangubatan hên pamanyag kasalanan hên mihay maaypa ya nakêm hên nanad kanan hata nanaway anak ya ampaniwala kangko, ay mangêd pon kana, ya bayo ya mag-in pangubatan hên habayto, ay patsên ya hên êl-an yan mahlay ya bato ha lêêy na, ta ilêmêh ha malalê ya lanêm. ");
INSERT INTO sgb_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","No gamêt mo ya anggamitên mon manyag kasalanan, ay mangêd ya potohên mo ya habayto. Ta mangêd pon ya milamo ka ha biyay ya ayn angga ha langit, hên ayn gamêt, kanan mipalako ka ha impiyerno ha apoy ya ayn angga, hên main gamêt. ");
INSERT INTO sgb_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(Bayro ha apoy ya ayn angga, ay main owêl ya a angkamatsi ya mangna kanlan mipalako bayro.) ");
INSERT INTO sgb_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","No bitsih mo ya anggamitên mon manyag kasalanan, ay mangêd ya potohên mo ya habayto. Ta mangêd ya milamo ka ha biyay ya ayn angga ha langit, hên ayn bitsih, kanan mitapon ka ha impiyerno, hên main bitsih. ");
INSERT INTO sgb_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(Bayro ay main owêl ya a angkamatsi ya mangna kanla.) ");
INSERT INTO sgb_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","No mata mo ya anggamitên mon manyag kasalanan, ay kêwêtên mo haka mon itapon. Ta mangêd ya milamo ka ha biyay ya ayn angga ha langit, hên ayn mata, kanan mitapon ka ha impiyerno, hên main mata. ");
INSERT INTO sgb_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Bayro ha impiyerno ay main owêl ya a angkamatsi ya mangna kanla, haka ya apoy bayro ay a angkaparê. ");
INSERT INTO sgb_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Ya balang miha ay magdanas hên kairapan, ta êmên mag-in mangêd ya ugali la. Habayto ay nanad ha kêna ya dinyanan ahin, bayo imparann ha apoy. ");
INSERT INTO sgb_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Mangêd ya ahin. Noa, no naalihan yay nan alat, ay ahinan maiorong ya alat na. Ihipên yoy pamanggamit hên ahin. Dapat panay kaw mag-in nanad ahin ya a naalihan, ta êmên main kapatêkbêkan ya pamilalamo yo.” ");
INSERT INTO sgb_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Amêhên, ay immalíh hilan Apo Jesus bayro ha probinsyan Galilea, ta nagdann hilay na ha probinsyan Judea, hên nilumipay ha Ilog Jordan. Kal-atan ya nagtsipon hên nagpatoro kana. Tinoroan na hila etaman hên nanad ha panay nan andaygên. ");
INSERT INTO sgb_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Main ungnoy Pariseo bayro ya napaidani kan Apo Jesus, ya labay mandakêp kana ha pamaghabi na. Kabay nangotang hila kana, ya wanla, “Malyari ha mihay lalaki hên ihiyay nay ahawa na, hinoman ya pagbad-an?” ");
INSERT INTO sgb_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Nangotang hi Apo Jesus, “Hinoy utoh ni apo Moises ya tungkol bayro?” ");
INSERT INTO sgb_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Wanla etaman, “Pinaulayan ni apo Moises ya lalaki hên mamihiyay hên ahawa la no main hilay nan kahulatan ya an-ihiyay lay ahawa la.” ");
INSERT INTO sgb_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Wanay na êt ni Apo Jesus, “Gawan ha kakdêyan ulo yo, ha a yo labay humonol ha kalabayan ni Apo Namalyari, ay kabay nanulat hi apo Moises hên habaytoy utoh. ");
INSERT INTO sgb_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Noa, hên haton lagi, hên dinyag ni Apo Namalyari ya luta, ay nanyag yan lalaki, haka nanyag ya êt hên babayi. ");
INSERT INTO sgb_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kabay lakwanan nan lalaki ya toa na, ta milamo hilay nay miahawa. ");
INSERT INTO sgb_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Hilay miahawa ay mag-in mimiha, kabay alwa hilay nan lowa, ta mimiha hila tana. ");
INSERT INTO sgb_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ya pinilamo ni Apo Namalyari, ay dapat a pihiyayên.” ");
INSERT INTO sgb_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Hên nilumatêng hilan Apo Jesus ha ampaidyanan la, ay hilay tagahonol na etaman ya nangotang kana, no hinoy labay habiên hên habaytoy hinabi na. ");
INSERT INTO sgb_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kabay hinabi ni Apo Jesus, ya wana, “Ya lalaki ya mamihiyay hên ahawa na, bayo mag-ahawa yan kaatag, ay nanyag kasalanan ha una nan ahawa gawan namabayi ya. ");
INSERT INTO sgb_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Êmbayro êt ya babayi ya nakihiyay ha ahawa na, bayo makiahawa ha kaatag ya lalaki, ay nanyag kasalanan gawan nakilalaki ya.” ");
INSERT INTO sgb_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nanganaway anak man, ay anggêtan kan Apo Jesus, ta ihalangin na hila hên ipalunto nay gamêt na ha ulo la. Hên nahêlêk lan tagahonol ni Apo Jesus ya hata manianak-anak, ay binawal lay ampantan kanla. ");
INSERT INTO sgb_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Noa, hên napansin ni Apo Jesus, ya angkalyari, ay hinuluk nay tagahonol na, ya wana, “Paulayan yo hilay anak hên paidani kangko. Paan yo hilan bawalên. Ta hilay maaypa ya nakêm ya nanad kanla, ay hila ya ilamo ha pamanlokop ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Pakagilamên yoy hatsi. Hilay a manoto ha paniwala lan nanaway anak ha pagpalokop la kan Apo Namalyari, ay a makapakilamo ha pamanlokop na.” ");
INSERT INTO sgb_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tinakêh nay manianak-anak, bayo impalunto nay gamêt na ha ulo la, ta inhalangin na hila. ");
INSERT INTO sgb_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Hên paalíh hilan Apo Jesus, ay main mihay lalaki ya nuwayun dinumani hên nandoko ha arapan na hên nangotang, “Mangêd ya Mánoro, hino ya dapat kon daygên, ta êmên ako madyanan hên biyay ya ayn angga?” ");
INSERT INTO sgb_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Wani Apo Jesus kana, “Pata binaêg mo kon mangêd? Hi Apo Namalyarin bêngat ya mangêd. ");
INSERT INTO sgb_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Muwang moy Kautuhan ni Apo Namalyari, ‘Paan mamatsin kaparehon tawo. Paan mamabayi. Paan makilalaki. Paan manakaw. Paan manistigos ha alwan pêtêg. Paan manloko. Galangên moy toa mo.’” ");
INSERT INTO sgb_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Bayo wanan lalaki, “Mánoro, anhonolên kina ya habayto ngan, paubat hên nanawa ko pon.” ");
INSERT INTO sgb_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Hên nagilam ni Apo Jesus ya hinabi na, ay hinlêk na ya lalaki hên main pamanlugud, ta wana, “Miha pon ya kailangan mon daygên. Iubuh mon ihaliw ya pibandian mo, bayo idin moy habaytoy naablian kanlan mangairap, ta madyanan kan mantêg hên pibandian ha langit. Pangayari mon madyag ya habayto, ay mag-orong ka di, ta humonol ka kangko.” ");
INSERT INTO sgb_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Noa, hên nagilam nay hinabi ni Apo Jesus, ay ayn yay nan higla haka nammita ya hên ampaglungkot, ta miha yay mabandi. ");
INSERT INTO sgb_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Hinlêk ni Apo Jesus hilay tagahonol na, bayo wana kanla, “Alwan nataluh hên makapakilamo ha pamanlokop ni Apo Namalyari ya hilay mabandi!” ");
INSERT INTO sgb_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Angkalipang ya ihip lan tagahonol na ha hinabi na. Noa, inoman nan hinabi ni Apo Jesus, “Hikaw ya nanad anak ko, alwan nataluh hên makapakilamo ha pamanlokop ni Apo Namalyari! ");
INSERT INTO sgb_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nataluh hên magdann ha lubot karayêm ya mihay kamelyo, kanan makapakilamo ha pamanlokop ni Apo Namalyari ya mihay mabandi.” ");
INSERT INTO sgb_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Angkalipang ya ihip lan tagahonol na ha hinabi na, kabay nipakotang hila, “Hino awud ya miligtas, hên makapakilamo ha pamanlokop ni Apo Namalyari?” ");
INSERT INTO sgb_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Pinakahêlêk hila ni Apo Jesus, bayo wana, “Ya a madyag hên tawo, ay madyag ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Amêhên, wani Pedro, “Ay-êmên kay, ya tagahonol mo? Imbalag naên ya kaganawan, ta êmên kay humonol kamo.” ");
INSERT INTO sgb_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Wana etaman ni Apo Jesus, “Hilay nangibalag bali la, kapotoh pohêl la, toa la, anak la, haka luta la, gawan ha pamanhumonol la kangko, hên maypamwang hên Mangangêd ya Habi ya tungkol ha kaligtasan, ");
INSERT INTO sgb_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ay matumbahan hên katamagatoh kanan imbalag la. Kaban atsi hila pon di ha luta, ay matumbahan hilan bali, kapotoh pohêl, indo, anak haka luta. Pairapan hilan kaatag, noa, lano, ay madyanan hila hên biyay ya ayn angga. ");
INSERT INTO sgb_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Noa, mal-at kanlan matag-ay ya tungkulan ha hêlêk hên kapareho la, ay alwan matag-ay ha hêlêk ni Apo Namalyari, haka mal-at kanlan maaypa ya tungkulan ha hêlêk hên kapareho la, ay matag-ay ha hêlêk ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Hên atsi hila ha dann, hilan Apo Jesus, hên palako ha balayan Jerusalem, ay angkauna hi Apo Jesus ha pammita la. Ampag-êpapah hilay tagahonol na, haka hilay kaatag ya ampakihonol kanla, ay angkalimwan, gawan muwang lay main labay mamatsi kan Apo Jesus bayro ha Jerusalem. Amêhên, impapawa nay labinloway tagahonol na, ta impamwang na kanlan bêngat ya malyari kana, ");
INSERT INTO sgb_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ya wana, “Pakagilamên yo! Anlumakat kitamo ha Jerusalem ta hiko, ya Taga-Langit, ya In-anak Tawo ay i-upit bayro ha gamêt lan mánoron Kautuhan ni apo Moises, haka kanlan ampamaala kanlan pari. Habiên lan habayto ya hikoy dapat patsên, bayo idin la ko kanlan alwan Israelita. ");
INSERT INTO sgb_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Musmusên, dul-an, haka pagpapatokên la ko, bayo patsên la ko. Noa, ha ikatlon allo, ay mabiyay kon oman!” ");
INSERT INTO sgb_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Dinumani hên nangotang kan Apo Jesus ya loway anak ni Zebedeo, ya hi Santiago haka hi Juan, ya wanla, “Manoro, main kay dayin pakihabi kamo.” ");
INSERT INTO sgb_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Wani Apo Jesus etaman, “Hinoy labay yo kangko?” ");
INSERT INTO sgb_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Wanla etaman kana, “Labay naên, ya lano ha pamanlokop mo, ay paiknoên mo kay ha dani mo, ya miha ha dapit panabtab, haka miha êt ha dapit uki.” ");
INSERT INTO sgb_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Wani Apo Jesus kanla, “A yo angkaintindihan ya pamagdusa ya maranasan yo, no mahonol ya kalabayan yo. Matêêh yoy pamagdusa ya danasên ko? Taganán nakal-an kaw hên matsi hên nanad kangko?” ");
INSERT INTO sgb_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Wanla etaman kana, “Awo. Nakal-an kay.” Kabay wani Apo Jesus kanla, “Madanasan yoy pamagdusa ya danasên ko, haka matsi kaw hên nanad kangko. ");
INSERT INTO sgb_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Noa, ayn akon karapatan hên maghabi no hinoy mikno ha dani ko, ta tinalagá nay na ni Apo Namalyari no hinoy mikno ha dani ko.” ");
INSERT INTO sgb_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Hên nagilam lan mapoy kaatag ya tagahonol na, ya labay ni Santiago haka ni Juan, ay hinumuluk hila. ");
INSERT INTO sgb_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kabay pinarani na hila ni Apo Jesus, ta wana kanla, “Muwang yo ya hilay manungkulan lan a ampagpalokop kan Apo Namalyari, ay andaygên lan ipoh ya angkalokopan la, haka an-iatay la hilan manyag kalabayan la. ");
INSERT INTO sgb_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Noa, dapat alwan êmbayro ya daygên yo. No labay yon mag-in matag-ay ya tungkulan, ay dapat yon huyuên ya kapareho yon tawo. ");
INSERT INTO sgb_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ya labay mag-in pinakamatag-ay ya tungkulan, ay dapat mag-in nanad ipoh hên kalamo na. ");
INSERT INTO sgb_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ta hiko man ya Taga-Langit, ya In-anak Tawo, ay atsi bayri amêhên ha luta, alwan para paghuyuan, noa, para maghuyo angga ha idin koy biyay ko, ha pangakbus hên kal-atan.” ");
INSERT INTO sgb_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Amêhên, nilumatêng hilan Apo Jesus ha balayan Jerico. Hên paalíh hila bayro ha balayan, hên kalamo hilay kal-atan, ay main buwag ya ampikno ha danin dann, ya ampakikwan pera. Ya langan na ay Bartimeo, ya anak ni Timeo. ");
INSERT INTO sgb_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Hên nagilam nay ampanlibah hi Apo Jesus ya taga-balayan Nazaret, ay nan-angaw ya, ya wana, “Apo Jesus, ya kaapo-apoan ni Arin David, ingalwan mo ko dayi!” ");
INSERT INTO sgb_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Binawal yan maglabak hên hatoy kal-atan ya ampakihonol kan Apo Jesus, noa, impakakhaw nan in-angaw, “Kaapo-apoan ni Arin David, ingalwan mo ko dayi!” ");
INSERT INTO sgb_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Hên nagilam ni Apo Jesus ya angaw na, tinunggên ya, ta main yan in-utoh, hên akayên lay buwag hên ilako kana. Hinabi la kanan buwag, “Pakhawên moy nakêm mo! Mirêng ka ta impaakay na ka kana.” ");
INSERT INTO sgb_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tampol yan nirêng. Imbalag nay pangkêbêl na, ta nagpaakay ya ha dani ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nangotang hi Apo Jesus kana, “Hinoy labay mon daygên ko kamo?” Amêhên, wanan buwag, “Panginoon, labay ko dayin makahêlêk.” ");
INSERT INTO sgb_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Kabay hinabi ni Apo Jesus kana, “Makahêlêk ka, gawan ha paniwala mo kangko. Malyari kay nan mita.” Tambêng ya etaman nakahêlêk, kabay nakihonol yay na kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nahên narani hilan Apo Jesus ha Jerusalem, ha talindah hên Tawgtug Olibo, hên angkadungawan lay balayan Betfage, haka baryon Betania, ay impauna ni Apo Jesus ya lowa kanlan tagahonol na, ");
INSERT INTO sgb_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ta wana kanla, “Muna kaw ha balayan ha unaan tamo. Panhumwên yo ha balayan, ay tampol yon mahêlêk ya mihay biseron asno, ya nakah-êl, ya a pon nahakyan. Okalên yoy habayto, ta gêtan yo di. ");
INSERT INTO sgb_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","No main mangotáng kamoyu no awta an-okalên yoy habayto, ay habiên yo, ‘Kailangan yan Panginoon haka tampol nan ipaorong di.’” ");
INSERT INTO sgb_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kabay nammita hilay nay loway in-utoh na. Haka natapol la etaman ya biseron asno ya nakah-êl ha mihay ilwangan ha danin dann. Kaban an-okalên la ya, ");
INSERT INTO sgb_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ay main ungnoy nangotang, “Pata an-okalên yoy habain ya bisero?” ");
INSERT INTO sgb_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Impamwang la ya hinabi ni Apo Jesus kanla. Kabay pinaulayan hila etaman. ");
INSERT INTO sgb_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","In-akay lay nay bisero kan Apo Jesus, haka la inamakan pangkêbêl la, bayo himmakay hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Inhundo lan Apo Jesus ya pammita lan palakon Jerusalem. Ha pandanan lan Apo Jesus, ay nami-amak hilay atsi bayro hên pangkêbêl la o bulong, gawan ha panggalang la kana. ");
INSERT INTO sgb_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Hilay atsi ha unaan ni Apo Jesus haka hilay anhumonol kana ay nipan-angaw, “Hosanna! Iningalwan ya habaytsi ya in-utoh ni Apo Namalyari! ");
INSERT INTO sgb_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Iningalwan ya anlumatêng ya pamamaala nan kaapo-apoan ni Arin David! Hosanna! Puriên hi Apo Namalyari!” ");
INSERT INTO sgb_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Hên nilumatêng hilan Apo Jesus ha Jerusalem, ay nagpakha ya ha Templo. Inubuh nan hinlêk ya angkalyari bayro. Gawan anyumabi yana, ay immawah ya ta nag-orong ya ha baryon Betania, hên kalamo nay labinloway tagahonol na. ");
INSERT INTO sgb_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pangamaranon hên mag-orong hilan Apo Jesus ha balayan Jerusalem hên ubat ha Betania, ay nilonoh hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Hên naipatanêh nay mihay poon igos ya nagbulong, ay dinanian nan hinlêk no main tagêy. Noa, bulong bêngat ya nalatngan na gawan alwa pon panaon tagêy. ");
INSERT INTO sgb_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kabay wana kanan kayo, “Angga-angga, ay a kay na managêy oman!” Nagilam lan tagahonol na ya hinabi na. ");
INSERT INTO sgb_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Hên nilumatêng hilan Apo Jesus ha Jerusalem, ay nagpakha ya ha Templo. Intaboy na hilay ampipagtinda haka ampipanaliw bayro. In-iitwag nay lamisaan lan mámihagili hên pera, haka in-iitwag na êt ya iknoan lan mámihaliw hên pati-pati ya gamitên ha átang. ");
INSERT INTO sgb_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Binawal na hilay ampangalga, hên magdann bayro ha Templo. ");
INSERT INTO sgb_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Haka na hila tinoroan ya kal-atan, ya wana kanla, “Nakahulat ha habi ni Apo Namalyari, ya wanan hulat, ‘Ya bali ko, ay ambaêgên balin panalanginan para ha balang bansa.’ Noa, dinyag yo yan logal ya panlokoan yon kapareho yo!” ");
INSERT INTO sgb_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Hên nagilam lan mánoron Kautuhan ni apo Moises, haka hilay ampamaala kanlan pari, ya tungkol ha hinabi haka dinyag ni Apo Jesus, ay pinihabian la no hinoy maibara la kana, ta êmên la ya mapatsi. Angkalimo hila kana, gawan ha kal-atan ya ampag-êpapah ha pamanoro na. ");
INSERT INTO sgb_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Hên anyumabi yana, ay nag-alíh hilan Apo Jesus bayro ha balayan Jerusalem. ");
INSERT INTO sgb_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pangamaranon, hên nagdann hilan Apo Jesus bayro ha inhumpay poon kayon igos, ay nayangoy na ya habayto. ");
INSERT INTO sgb_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Napanêmtêman ni Pedro ya inhumpa ya kayo, kabay wana, “Manoro, hêlkên mo! Nayangoy nay inhumpa moy kayo!” ");
INSERT INTO sgb_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Wani Apo Jesus, “Maniwala kaw kan Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Pakagilamên yo, no main mamiutoh kanan hata tawgtug hên mitapon ya ha dagat, no ampaniwala ya, hên ayn pamikakono, ay itapon nay na ni Apo Namalyari ha dagat. ");
INSERT INTO sgb_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kabay, pakagilamên yo, no ampaniwala kaw, ay matanggap yoy hinoman ya pakikwaan yo ha panalangin. ");
INSERT INTO sgb_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Haka bayo kaw manalangin, ay patawarên yo pon hilay nakadyag kasalanan kamoyu, ta êmên na kaw etaman patawarên ni Apo Namalyari, ya Tatang tamo ha langit. ");
INSERT INTO sgb_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Noa, ta no a yon patawarên ya nakadyag kasalanan kamoyu, ay a na kaw patawarên ni Apo Namalyari, ya Tatang tamo ha langit.” ");
INSERT INTO sgb_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Hên atsi hilay nan oman ha Jerusalem hilan Apo Jesus, hên ampibita-bita ya ha Templo, ay dinumani kana hilay mánoron Kautuhan ni apo Moises, hilay toa ya nag tungkulan ha bansa, haka hilay ampamaala kanlan pari. ");
INSERT INTO sgb_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Hinabi la kana, “Habiên mo kannaên no hinoy tungkulan mo hên manyag hên pandaygên mo. Habiên mo êt no hinoy nam-i kamo hên habain ya tungkulan.” ");
INSERT INTO sgb_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Kabay wani Apo Jesus, “Main ako pon hên kotangên kamoyu. No pakibatan yo ko, ay habiên ko kamoyu no hinoy nam-i kangko hên tungkulan hên manyag hên pandaygên ko. ");
INSERT INTO sgb_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Hinoy nam-i hên tungkulan kan Juan Bautista hên mamawtismo? Hi Apo Namalyari o tawo?” ");
INSERT INTO sgb_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kabay pinihahabian la, ya wanla, “Hinoy habiên tamo? No habiên tamo ya ‘Ubat kan Apo Namalyari ya tungkulan ni Juan Bautista,’ ay habiên na bayto, ‘Pata a yo yan pinaniwal-an?’ ");
INSERT INTO sgb_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Noa, no habiên tamo ya ‘Ubat ha tawo,’ ay hino kaya ya daygên lan kal-atan kantamo, ta ha ihip la, hi Juan ay mihay propeta ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kabay hinabi la kan Apo Jesus, ya wanla, “A naên muwang no antoy ubatan tungkulan ni Juan Bautista.” Bayo wani Apo Jesus, “No êmbayro awud, ay a ko etaman habiên kamoyu no antoy ubatan tungkulan ko.” ");
INSERT INTO sgb_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Amêhên, nangalimbawa yay na êt hi Apo Jesus, ya wana kanlan ampanggilam, “Minghan main lalaki ya nag luta ya tinamnan nan ubas. Bayo binakoran nay habayto. Nangali yan pangiunaban hên ubas, haka ya êt namairêng hên tawer ya pagbantayan. Impatsiwala na ha kaatag ya ubasan na, ta maglaêh ya ha kaatag ya bansa. ");
INSERT INTO sgb_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Hên pamutsi hên habaytoy ubas, ay in-utoh nay mihay ipoh na, hên kowên ya atag na kanlan paypaniwal-an ubasan na. ");
INSERT INTO sgb_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Noa, dinakêp haka tinumbuk lay ipoh na, bayo impaorong la ya, hên ayn anggêtan. ");
INSERT INTO sgb_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kabay in-utoh nay na êt ya kaatag ya ipoh na, noa, pinatok lay ulo na, impakarêng-êy la ya, bayo impaorong la ya hên ayn anggêtan. ");
INSERT INTO sgb_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nahên in-utoh nay na êt ya ikatlon ipoh na, ay pinatsi la ya. Mal-at êt ya ipoh ya in-utoh na. Ya kaatag kanla ay tinumbuk la, haka ya kaatag, ay pinatsi la. ");
INSERT INTO sgb_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Hên ayn yay nan ipoh ya maiutoh, ya nag ubasan, ay in-utoh nay anlugurên nan anak nay lalaki, ta wana, ‘Siguradon igalang lay anak ko.’ ");
INSERT INTO sgb_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Noa, hên nahêlêk lan paypaniwal-an ubasan ya anak nan nag ubasan, ay nihahabi hila, ya wanla, ‘Hatsi ya paypamanaan na hên ubasan. Patsên tamo ya, ta êmên mapagbandi tamo ya hata ubasan na.’ ");
INSERT INTO sgb_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kabay dinakêp la ya, haka pinatsi, bayo inhamwag lay bangkay na ha luwal hên ubasan.” ");
INSERT INTO sgb_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Amêhên, kinotang ni Apo Jesus, hilay ampamaala ha Templo, ya wana, “Hino kaya ya daygên hên nag ubasan kanlan paypaniwal-an nan ubasan? Siguradon lakwên nay paypaniwal-an nan ubasan, ta patsên na hila, bayo ipatsiwala nay ubasan na ha kaatag.” ");
INSERT INTO sgb_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Wana êt ni Apo Jesus kanlan ampamaala ha Templo, “Yarin a yo êt nabaha ya habaytsi ya nakahulat ha Kahulatan ya impahulat ni Apo Namalyari? ‘Ya bato ya intapon lan manyag bali, ay nag-in pinakamaalagáy bato ta êmên mag-in napah-êy ya bali. ");
INSERT INTO sgb_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Dinyag ni Apo Namalyari ya habayto ya kapapaêpapah.’” ");
INSERT INTO sgb_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Naintindihan lan ampamaala ha Templo, ya hilay in-alimbawa di ha manyag bali, haka ha nangarawak ya paypaniwal-an ubasan, kabay labay la yan dakpên, noa, malimo hila ha kal-atan. Kabay nammita hilay na. ");
INSERT INTO sgb_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Bayo namiutoh hilan ungnoy Pariseo haka ungnoy kagampi ni Herodes Antipas, ya waringan main hilan labay mamwangan kan Apo Jesus. Noa, labay la yan madakêp ha pamaghabi na. ");
INSERT INTO sgb_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Hên nilumatêng hila kan Apo Jesus, ay hinabi la, “Mánoro, muwang naên ya kaptêgan ya panhabiên mo haka panoro mo. An-itoro moy kalabayan ni Apo Namalyari, ha hinoman ya ampanggilam, gawan alwa kan mapamili, ta pantag ya panlêk mo ha balang miha. Kabay main kay hên labay mamwangan kamo. Ayon ha Kautuhan ni apo Moises, ay malyarin mam-in buwih kanan Emperador o ahê?” ");
INSERT INTO sgb_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Noa, muwang ni Apo Jesus ya pagbabara la, kabay hinabi na kanla, ya wana, “Pata labay yo kon dakpên ha pamaghabi ko! Ipahlêk yo kangko ya mihay sintimos hên pilak.” ");
INSERT INTO sgb_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Namiawah hilan habayto, bayo kinotang na hila. “Hinoy nag lupa hên angkakit yo bahên? Hinoy nag langan ya nakahulat bahên?” Hinabi la etaman, “Kanan Emperador.” ");
INSERT INTO sgb_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kabay wani Apo Jesus, “No êmbayro awud, ay idin yo kanan Emperador ya kana, haka idin yo kan Apo Namalyari ya kan Apo Namalyari.” Hên nagilam lay hinabi na, ay nag-êpapah hila. ");
INSERT INTO sgb_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Amêhên, ay main ungno ha mihay pangkat lan Israelita ya ambaêgên Saduseo ya dinumani kan Apo Jesus. Hilay Saduseo ay a ampaniwala ha pangabiyay oman. Haka hinabi la kan Apo Jesus, ya wanla, ");
INSERT INTO sgb_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mánoro, nanulat ya hi apo Moises ha Kautuhan hên para kantamo, ya wanan hulat, ‘No main mitaahawa, ta natsi ya lalaki hên a hila nagkaanak, ay dapat ya kahonol nan natsi, ay ipaahawa kanan bawo. No magkaanak hila, ay habaytoy anak, ay itad anak na hên natsi.’ ");
INSERT INTO sgb_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Minghan, ay main pitoy mikakahonol ya lalaki. Nakapag-ahawa ya punganay, noa, natsi ya hên a nagkaanak. ");
INSERT INTO sgb_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Bayo pinag-ahawa nan humonol ha punganay ya hata bawo, noa, natsi ya etaman ya humonol ha punganay hên a nagkaanak. Êmbayro êt ya nalyari ha ikatlon kahonol. ");
INSERT INTO sgb_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Balang miha kanlan pitoy mikakahonol ay nakapag-ahawa hên hata babayi, noa, naubuh hilan natsi hên a nagkaanak. Bayo natsi ya êt ya hata bawo. ");
INSERT INTO sgb_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Amêhên, ha allon pangoman mabiyay, hinoy nay taganán mag-in ahawa nan hata babayi, ta balang miha kanlan habaytoy pitoy mikakahonol ay nag-in ahawa na?” ");
INSERT INTO sgb_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Kabay wani Apo Jesus kanlan Saduseo, “Mali ya paniwala yo, ya a biyayên oman ya natsi, gawan a yo angkaintindihan ya Kahulatan ya impahulat ni Apo Namalyari haka a yo angkaintindihan ya kapangyarihan na! ");
INSERT INTO sgb_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ha pangoman biyayên hilay natsi, ay ayn nanan pamag-ahawa, ta manoto hila kanlan anghel ha langit ya a ampag-ahawa. ");
INSERT INTO sgb_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ya hulat man ni apo Moises ay ampamaptêg ya biyayên oman hilay natsi, ta bayro ha hulat na, ya tungkol ha maaypa ya kayoy andungkêt, mabáha tamo ya hinabi ni Apo Namalyari, ‘Hikoy Diyos ni Abraham, Diyos ni Isaac, haka Diyos ni Jacob.’ ");
INSERT INTO sgb_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Habaytoy labay habiên ya hiyay Diyos lan angkabiyay, ta balang miha ya natsi, ay angkabiyay ha hêlêk na. Mali ya paniwala yo, ya a biyayên oman ya natsi.” ");
INSERT INTO sgb_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Main mánoron Kautuhan ni apo Moises ya nakagilam hên pamakipagpalinawan la. Hên napansin na, ya mangêd awud, ya hinabi ni Apo Jesus, ay nangotang ya, “Mánoro, hinoy pinakamaalagá ha utoh ni Apo Namalyari?” ");
INSERT INTO sgb_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Hinabi ni Apo Jesus, “Ya pinakamaalagáy utoh ni Apo Namalyari, ay ‘Manggilam kaw ya Israelita. Mimihay Panginoon tamo, yabay ya hi Apo Namalyari, ayn nanan kaatag. ");
INSERT INTO sgb_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Lugurên mo hi Apo Namalyari, ya Panginoon hên boon nakêm, boon ihip, haka boon hêkaw.’ ");
INSERT INTO sgb_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ya ikalwa ay, ‘Lugurên moy kapareho mo hên nanad pamanlugud mo ha lawini mo.’ Ayn kaatag ya utoh ya maalagá kanlan habaytoy lowa.” ");
INSERT INTO sgb_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Wanan mánoron Kautuhan ni apo Moises, “Taganán pêtêg ya hinabi mo ya mimihay Panginoon tamo, yabay ya hi Apo Namalyari, ayn nanan kaatag. ");
INSERT INTO sgb_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Haka muwang ko ya maalagá ya lugurên tamo ya hên boon nakêm, boon ihip, haka boon hêkaw. Dapat tamo etaman hên lugurên ya kapareho tamo hên nanad ha pamanlugud tamo ha lawini tamo. Maalagá ya habayto kanan hinon imparaya o in-átang kana.” ");
INSERT INTO sgb_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nadambi ni Apo Jesus ya main kagalingan ya hinabi nan mánoron Kautuhan ni apo Moises, kabay wana kana, “Marani ka ha pamanlokop ni Apo Namalyari, ta pêrad tana ay palokop ka kana.” Marêng-êy hilay na hên mangotáng pon kan Apo Jesus, hilay labay hên mandakêp kana ha pamaghabi na. ");
INSERT INTO sgb_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Kaban ampanoro ya hi Apo Jesus ha Templo, ay nangotang ya, “Ay-êmên lan mahabi lan mánoron Kautuhan, ya Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala ay kaapo-apoan bat ni Arin David? ");
INSERT INTO sgb_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Mismon hi Arin David, ya ninuno tamo, ay namihulat ha Kahulatan ha kapangyarihan nan Espiritu ni Apo Namalyari, hên tungkol ha Mesias, ya Cristo, ya wana, ‘Hinabi ni Apo Namalyari ha Panginoon ko, “Mikno ka ha dapit panabtab ko hên mamaala hên kalamo ko, angga ha mahambut ko hilay kapatsi mo, ta idin ko hila ha aypan kapangyarihan mo.”’ ” ");
INSERT INTO sgb_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Wana êt ni Apo Jesus, “Hên hato, ay hi Arin David ya namaêg hên ‘Panginoon ko’ ha Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala. Kabay muwang tamo, ya hiyay Panginoon haka kaapo-apoan ni Arin David.” Hadyay kahiglaan lan kal-atan hên manggilam hên toro na. ");
INSERT INTO sgb_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Inhundo ni Apo Jesus ya panoro na, ya wana, “Kaillag kaw ha toro lan mánoron Kautuhan ni apo Moises. Labay-labay la hên mibita-bita hên nakatakop hên makarang ya takop, ta êmên ipamwang ya matag-ay ya tungkulan la. Labay la êt hên galangên, haka dayêwên hila hên kal-atan ha balayan. ");
INSERT INTO sgb_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ya kaatag pon ya andaygên la ta êmên ipamwang ya matag-ay ya tungkulan la, ay ampiliên lay pinakamangêd ya iknoan ha sinagoga haka ha kaluto. ");
INSERT INTO sgb_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Anlokoên la êt ya bawo ya babayi, ta êmên la makwa ya pibandian la, bayo magma-mangêd hilan ikarang ya panalangin la ha arapan hên kal-atan. Kabay hadyay pamarusa kanla lano.” ");
INSERT INTO sgb_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kaban atsi ya pon ha Templo hi Apo Jesus, hên ampikno ha êtêb hên pamyanan alay, ay anhêlkên nay kal-atan ya ampam-in alay la ha pamyanan alay. Mal-at ya mabandi ya nam-in kal-atan bandi. ");
INSERT INTO sgb_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Noa, ya mihay bawo ya babayi, ya mairap, ay nam-in lo-loway sintimos ha pamyanan alay. ");
INSERT INTO sgb_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Kabay wani Apo Jesus kanlan tagahonol na, “Pakagilamên yo, hata bawo ay nam-in mal-at kanan indin lan kal-atan mabandi. ");
INSERT INTO sgb_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ta hilay kaatag ay nam-in a la pon kailangan, noa, hata bawo, ay in-ubuh nan indin ya panaliw nan maêkan na.” ");
INSERT INTO sgb_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Hên mag-awah hilan Apo Jesus ha Templo, ay wanan miha kanlan tagahonol na, “Mánoro, hêlkên mo ya pangahlayan bato ya pinaglolog la ha Templo! Hadyay kahampatan na!” ");
INSERT INTO sgb_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Amêhên, hinabi ni Apo Jesus, ya wana, “Lumatêng lanoy allo, ay manga-aagwat ngan ya hata bato ya pinaglolog ya angkahêlêk yo.” ");
INSERT INTO sgb_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Hên atsi hilan Apo Jesus ha Tawgtug Olibo, hên nakaikno ya ha êtêb Templo, ay napaidani kana hi Pedro, hi Santiago, hi Juan, haka hi Andres, hên hilan bêngat. ");
INSERT INTO sgb_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Amêhên, nangotang hila kana, “Habiên mo kannaên no makanon malyari ya habayto, haka no ay-êmên naên mamwangan no maranin malyari ya habayto.” ");
INSERT INTO sgb_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Kabay wani Apo Jesus, “Kaillag kaw, ta êmên a kaw maloko, ");
INSERT INTO sgb_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ta mal-at ya maghabin êmên di, ‘Hiko ya Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala.’ Gawan bayro, ay mal-at ya maloko la. ");
INSERT INTO sgb_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Paan kaw malimo ha magilaman yoy tungkol ha manigulo-gulo haka pa-tsian, ta habayto ay kailangan lumatêng pon, noa, a pon tambêng lumatêng ya anggaan hên luta. ");
INSERT INTO sgb_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Milalaban hilay bansa haka hilay angkalokopan hên mihay bansa ay milalaban ha kabansa la. Lumatêng ya mangakhaw ya layon ha ay-iri man ya logal. Lumatêng êt ya hadyay lonoh. Noa, habayto ay umpisan bêngat hên hadyay kairapan, hên nanad ha umpisan pan-umilab hên ampanganak. ");
INSERT INTO sgb_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Dapat kaillag kaw, ta gêtan la kaw kanlan toa ya nag tungkulan ha hinon sinagoga, kotangên la kaw haka pagpapatokên la kaw ha sinagoga. Gawan ha paniwala yo kangko, ay gêtan kaw kanlan ari haka gobernador. Ha êmbayro ay maipamwang yo kanla ya Mangêd ya Habi tungkol kangko. ");
INSERT INTO sgb_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Yabay ya kailangan hên ipamwang ha balang bansa bayo lumatêng ya kaanggaan hên hata luta. ");
INSERT INTO sgb_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Uston iarap la kaw kanlan manungkulan, ta kotangên la kaw, paan kaw manyagah no hinoy habiên yo, ta ya Espiritu ni Apo Namalyari, ay mamaihip kamoyu no hinoy habiên yo. ");
INSERT INTO sgb_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Main kapotoh pohêl, haka toa, ya may-upit hên kamag-anak la. Main maának ya manalanghang ha toa la hên angga ha ipapatsi la hila. ");
INSERT INTO sgb_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kahêmêkan kaw hên kal-atan, gawan ha paniwala yo kangko. Noa, no maihundo yoy paniwala yo kangko, angga ha anggaan biyay yo, agyan ampagdanas kaw hên hadyay pamairap, ay madyanan kaw hên biyay ya ayn angga.” ");
INSERT INTO sgb_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Inhundo ni Apo Jesus ya pamaghabi na, ya wana, “No mahêlêk yoy nay kapaparêng-êy ya hadyay karawakan ya malyari ha Templo ni Apo Namalyari, ay ha allon habayto, ay kailangan muwayun magtago ha babo, ya hilay taga-probinsyan Judea.” Hikaw ya ampamaha ay pakaintindiên yoy habaytsi! ");
INSERT INTO sgb_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","“Habaytoy allo, no main atsi ha bubungan bali la, ay dapat tampol hilan tumaoy hên muwayun lumakat ha babo! Paan hilay nan mangwan pibandian la ha lalên bali la! ");
INSERT INTO sgb_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Paan hilay nan muli ya atsi ha panamnan hên mangwan sambra la! ");
INSERT INTO sgb_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kanan habayto, ay kaingalo hilay nabuktot haka hilay ampamahoho. ");
INSERT INTO sgb_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ihalangin yo, ya a dayi malyari ha panaon hên kêbêl, ya habaytoy pammuwayu yo hên magtago. ");
INSERT INTO sgb_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ta di ha luta ay maranasan ya hadyay kairapan, ya ayn kapantag paubat hên dinyag ni Apo Namalyari ya hata luta, angga amêhên. Haka ahina maranasan oman ya êmbayroy kairapan. ");
INSERT INTO sgb_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","No mabuyot ya habaytoy kairapan, ay ayn nanan mabiyay di ha luta, noa, gawan bat ha ikakangêd lan pinili na hên mag-in kana, ay tinalagá ni Apo Namalyari hên paipêkên ya habaytoy panaon. ");
INSERT INTO sgb_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Kanan habaytoy panaon, no main maghabin, ‘Atsi ya bayri ya Mesias, ya Cristo, ya Mámiligtas, o atsi ya bayro,’ ay paan kaw maniwala kanla. ");
INSERT INTO sgb_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ta main magbabara hên hila ay Cristo, haka main êt kaatag ya magbabara hên hila ay mámipamwang hên an-ipaihip kanla ni Apo Namalyari. Mamipahlêk hilan kapapaêpapah ta labay lan mámungaw hilay pinili ni Apo Namalyari hên mag-in kana. ");
INSERT INTO sgb_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kabay kaillag kaw! In-ubuh kinan hinabi ya malyari, ta êmên a kaw mámungaw.” ");
INSERT INTO sgb_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Wana êt ni Apo Jesus, “Pangayarin habaytoy hadyay kairapan, ay dumiglêm ya allo, haka ahina humawang ya buwan, ");
INSERT INTO sgb_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","mangatata ya bêtêwên, haka maubuh hên mangayêgyêg ya angkahêlêk ha langit. ");
INSERT INTO sgb_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kanan habayto, ay mahêlêk la ko ha lêmm, ya Taga-Langit, ya In-anak Tawo, ya anlumatêng hên kalamoy kapangyarihan ko, ya ayn kapantag, haka ya kapahilêw ya kahampatan hên panga-Diyos ko. ");
INSERT INTO sgb_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Kanan habayto, ay iutoh ko hilay anghel ha kaganawan bansa ha boon luta, ta êmên la tsiponên ya pinili ni Apo Namalyari hên mag-in kana.” ");
INSERT INTO sgb_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Bayo wani Apo Jesus, “Mangwa kaw hên aral di ha poon kayon igos. No mamayo yan bulong, ay muwang yoy na bayto ya marani yanay kaingitan. ");
INSERT INTO sgb_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Êmbayro êt, no mahêlêk yoy nan maubuh hên malyari ya habayto ya kapapalimo, ay mamwangan yoy taganán marani ya pamag-orong ko. ");
INSERT INTO sgb_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Pakagilamên yo. Maubuh hên matupad ya habayto kaban main pon di ha luta hên kapareho yon Israelita. ");
INSERT INTO sgb_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ya luta haka ya angkahêlêk ha langit ay main anggaan, noa, ya habi ko ay ayn anggaan.” ");
INSERT INTO sgb_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Wanay na êt ni Apo Jesus, “Ayn ampakamwang no hinon allo, o oras ya pag-orong ko. Hila man ya anghel ha langit, o hiko man ya Anak ni Apo Namalyari, ay a ampakamwang hên habayto. Hiyan bat hi Apo Namalyari ya Tatang tamo, ya nag muwang. ");
INSERT INTO sgb_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kabay pakaalisto kaw! Dapat panay kaw nakal-an, ta a yon muwang no makanon malyari ya habayto.” ");
INSERT INTO sgb_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Impamwang ni Apo Jesus kanla, no ay-êmên ya dapat mag-in pamimiyay la, kaban an-êngganan lay pag-orong na, ta wana, “Habaytoy nanad ha mihay lalaki, ya nilumagay ha marayo. Bayo ya nammita ay binaêg nay ipoh na, ta dinyanan hilan tsi-tsihan obra la, haka hinabi na ha magbantay hên ilwangan, ya dapat yan panay nakal-an ha pag-orong na. ");
INSERT INTO sgb_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kabay pakaalisto kaw! Dapat panay kaw nakal-an, ta a yo muwang no makano ya pag-orong nan main bali. A yo man muwang no kapiyabi, bonak yabi, magdadali allo, o maranon ya pag-orong na. ");
INSERT INTO sgb_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ta kayno malatngan na kaw ya angkabêlêw ha bigla nan pamanlumatêng. ");
INSERT INTO sgb_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ya anhabiên ko kamoyu, ay anhabiên ko ha balang miha, ya dapat panay kaw nakal-an! Pakaalisto kaw!” ");
INSERT INTO sgb_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Amêhên, lowa tanay allo bayo mag Pistan Pangaligtas ha Egipto haka Pistan Puto ya ayn Pampaalsa. Hilay mánoron Kautuhan ni apo Moises, haka hilay ampamaala kanlan pari, ay ampamulong kan Apo Jesus, no ay-êmên la yan madakêp haka maipapatsi hên ayn makamwang. ");
INSERT INTO sgb_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ta wanla, “Paan tamo yan ipapatsi kaban pista pon, ta kayno manulhul hilay kal-atan, ya ampanggilam toro na.” ");
INSERT INTO sgb_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Hên atsi hilan Apo Jesus ha baryon Betania, hên ampangan ha bali ni Simon, ya inalihan ketong, ay main nilumatêng ya mihay babayi, ya ampantan hên makamal ya pabango, ya nardo, ya atsi ha pamyanan ya dyag ha alabastro, ta intugtug na ha ulo ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Hên nahêlêk lan kaatag ya dinyag nan babayi, ay nanuluk hila, ya wanla, “Pata hinayang nay pabango? ");
INSERT INTO sgb_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Pata a ya inhaliw ya habaytoy pabango, ya ampag-alaga hên suweldo hên mihay katawo ha mihay taon, ta indin dayi ha mangairap ya habaytoy pera?” Bayo hinuluk la ya. ");
INSERT INTO sgb_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Noa, wani Apo Jesus kanla, “Pata an-abalaên yo ya! Paulayan yo ya, ta ya dinyag na, ay taganán mangêd. ");
INSERT INTO sgb_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Hilay mairap ay panay yon kalamo, kabay ha hinon oras, ay mahawpan yo hila, noa, hiko ay a yon panay hên mapagkalamo. ");
INSERT INTO sgb_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Dinyag nay agyu nan daygên. Ha pamitugtug nan pabango kangko, ay nanad nay nan in-il-an ya lawini ko ha pamilbêng kangko no matsi kina. ");
INSERT INTO sgb_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Pakagilamên yo, ay-iri man ya logal bayri ha boon luta hên ipamwang ya Mangêd ya Habi, ay ungkatên etaman ya dinyag na, ta êmên ya a maliwaan.” ");
INSERT INTO sgb_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Bayo nammita yay na hi Judas Iscariote, ya miha kanlan labinloway tagahonol ni Apo Jesus, ta êmên na ya mai-upit kanlan poon pari. ");
INSERT INTO sgb_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Hinumigla hila etaman ha pay-upit ni Judas kan Apo Jesus kanla, haka nangako hila ya dyanan la yan pera. Paubat hên habayto, ay ampangihip yay na hi Judas no ay-êmên na yan maidin ha gamêt la. ");
INSERT INTO sgb_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ha unan allon Pistan Puto ya ayn Pampaalsa ya allon pamatsi lan Israelita hên anak tupa, ya kênaên la hên habayton yabi ha Pistan Pangaligtas ha Egipto, ay kinotang ya hi Apo Jesus, hên labinloway tagahonol na, ya wanla, “Atoy labay moy logal ya pangil-anan naên hên pangkaên tamo amêhên yabi ha Pistan Pangaligtas?” ");
INSERT INTO sgb_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kabay in-utoh ni Apo Jesus ya loway tagahonol na, ya wana kanla, “Muna kaw ha balayan Jerusalem, pamanlumatêng yo, ay matupa yoy mihay lalaki ya ampantan banga ya nag lanêm. Pakihonolan yo ya ha bali ya howênên na, ");
INSERT INTO sgb_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ta habiên yo ha nag bali, ya êmên di, ‘Labay nan Mánoro ya itoro mo kannaên, no antoy kuwarto ya panganan nan kaên ha Pistan Pangaligtas, hên kalamo na kay ya tagahonol na.’ ");
INSERT INTO sgb_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kabay ipahlêk na kamoyu ya mihay mahlay ya kuwarto ya nakal-an ha tag-ay. Bayro yon il-an ya kaên tamo ha Pista.” ");
INSERT INTO sgb_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nammita hilay nay loway tagahonol, haka natupad ya balang hinabi ni Apo Jesus kanla. Kabay in-il-an lay nay kaên ha Pista. ");
INSERT INTO sgb_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Hên yabi yana, ay nag-tsipon hilay labinlowa hên kalamo la hi Apo Jesus, bayro ha mahlay ya kuwarto. ");
INSERT INTO sgb_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Hên ampangan hilay na, ay wana kanla ni Apo Jesus, “Pakagilamên yo, miha bayri ha kaaêm tamo, ay mangi-upit kangko.” ");
INSERT INTO sgb_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Namalagêhbêg ya nakêm lan tagahonol na, haka wanlan balang miha kana, “Yarin hiko ya inungkat mo!” ");
INSERT INTO sgb_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Kabay hinabi ni Apo Jesus, “Hiyay miha kamoyun labinlowa. Ya kalamo kon ampami-tsil-tsil hên puto ha kolo, ay hiya ya mangi-upit kangko. ");
INSERT INTO sgb_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Hiko ya Taga-Langit, ya In-anak Tawo ay taganán matsi hên nanad ha impahulat ni Apo Namalyari ha Kahulatan hên haton lagi. Noa, taganán kaingalo ya mangi-upit kangko. Mangêd kana, ay a yay na dayin in-anak.” ");
INSERT INTO sgb_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kaban ampangan hila, ay nandampot hi Apo Jesus hên puto ta impahalamat nay habayto kan Apo Namalyari, haka na pino-potoh, bayo inggawang na kanlan tagahonol na, ta wana, “Habaytsi ya lawini ko, kowên yo ta kaên yo.” ");
INSERT INTO sgb_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Amêhên, nandampot yan pamminêman ya nag alak, ta impahalamat nay habayto kan Apo Namalyari. Bayo inggawang na kanla ta naubuh hilan ninêm. ");
INSERT INTO sgb_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Haka wana, “Habain ay daya ko, ya mamoganggang ha pamatawad hên kasalanan hên kal-atan. Yabay ya nanad pinakapirma hên kahundoan ni Apo Namalyari kanlan pinili na hên mag-in kana. ");
INSERT INTO sgb_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ta anhabiên ko kamoyu, ya a ko pon minêm oman hên alak, angga ha allo hên inumên koy bayoy alak ha pamanlokop ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Hên nahabi ni Apo Jesus ya habayto, ay nagkanta hilan pamagpuri kan Apo Namalyari, bayo nilumakat hila ha Tawgtug Olibo. ");
INSERT INTO sgb_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Hên anlumakat hilay na, ay wani Apo Jesus kanlan tagahonol na, “Laamêhên ay lakwanan yo ko, ta impahulat ni Apo Namalyari ha Kahulatan, ya êmên di, ‘Patsên ko ya pastol, haka mapitatayak hilay nay tupa.’ ");
INSERT INTO sgb_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Noa, ha pangoman kon mabiyay, ay muna ko kamoyu ha probinsyan Galilea.” ");
INSERT INTO sgb_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Bayo wani Pedro, “Lakwanan ka man hên kalamo ko, ay a kata lakwanan.” ");
INSERT INTO sgb_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Hinabi ni Apo Jesus, “Pakagilamên mo, bayo mangkatsi ya manok hên katalwa, amêhên yabi, ay katatlo mon habiên ya a mo ko muwang.” ");
INSERT INTO sgb_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Noa, impalêkpêk ni Pedro, ya wana, “Matsi ko man hên kalamo mo, ay a ko habiên ya a kata muwang.” Êmbayro êt ya hinabi lan kaatag ya tagahonol na. ");
INSERT INTO sgb_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Hên nilumatêng hilay na ha katanamanan Getsemani, ay wani Apo Jesus kanlan tagahonol na, “Mikno kaw di kaban manalangin ako.” ");
INSERT INTO sgb_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Bayo pinakilamo ni Apo Jesus hi Pedro, haka hilay loway anak ni Zebedeo, ya hi Santiago haka hi Juan. Bayron nakadanas yan hadyay kalungkutan haka kabyatan. ");
INSERT INTO sgb_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Haka wani Apo Jesus kanla, “A kina agyu ya hadyay kalungkutan ha nakêm ko, ya nanad kinan ikamatsi. Di kaw pon haka paan kaw mabêlêw.” ");
INSERT INTO sgb_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Napaidayo ya kanla hên marayo-dayo ta nandoko yan nanalangin, ya no malyari dayi, ay a na ya paulayan ni Apo Namalyari hên magdanas hên hadyay pamagdusa, ya wana, ");
INSERT INTO sgb_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Tatang ko ha langit, madyag mo ya hinoman. A mo ko dayin paulayan hên magdanas hên hatsi ya hadyay pamagdusa ya lumatêng kangko. Êmbayro man, ay alwan kalabayan ko ya mahonol, noa, ya kalabayan mo ya mahonol.” ");
INSERT INTO sgb_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Hên nirêng ya, hên ubat nanalangin, ay nag-orong yay na ha andyanan lan Pedro. Nalatngan na hila hên angkabêlêw. Pinukaw na hi Simon Pedro, ya wana, “Simon, pata angkabêlêw ka? A ka man makapagpuyat hên agyan miha man ya oras? ");
INSERT INTO sgb_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Paan yon pakilakwan ya bêlêw. Manalangin kaw, ta êmên kaw a mahambut hên tukso no ansubukên ya paniwala yo kangko. Nakal-an ya nakêm yo hên humonol, noa, a yo agyu.” ");
INSERT INTO sgb_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nag-orong yan oman hi Apo Jesus ha pinanalanginan na, hên inhalangin oman, ya inhalangin nay na. ");
INSERT INTO sgb_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Hên inorong na hilan oman ya tatlo, ay angkabêlêw hilay na êt, gawan a la matêêh hên magpuyat. Hên nimata hila, ay ayn hilan maihabi kan Apo Jesus gawan dêng-êy la. ");
INSERT INTO sgb_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Hên katatlo na hilan inorong, ay wana kanla, “Angkabêlêw kaw pon êt hên ampagpainawa! Hukad ya! Ta nilumatêng ya oras ya hiko ya Taga-Langit, ya In-anak Tawo, ay i-upit kanlan makasalanan! ");
INSERT INTO sgb_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mita kitamina, ta anlumatêng ya mangi-upit kangko. Tupaên tamo ya!” ");
INSERT INTO sgb_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Kaban ampaghabi ya pon hi Apo Jesus, ay main nilumatêng, ya kal-atan ya ampangamat kan Judas Iscariote ya miha kanlan labinloway tagahonol na. Hilay kal-atan ya nipag-almas hên êtak haka pamatok, ay in-utoh lan mánoron Kautuhan ni apo Moises, haka kanlan toa ya nag tungkulan ha bansa, haka kanlan ampamaala kanlan pari. ");
INSERT INTO sgb_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Hi Judas ay nam-i kanla hên palatandaan, ya no hinoy aroên na, ay yabay ya dakpên lan gêtan hên pakabantayan. ");
INSERT INTO sgb_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tampol nilako ni Judas, hi Apo Jesus hên kinumusta hên main lamoy pamangaro. ");
INSERT INTO sgb_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Dinawhong la ya hi Apo Jesus hên dinakêp. ");
INSERT INTO sgb_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Noa, bat nanigpah ya miha kanlan tagahonol ni Apo Jesus, hên têkk hên mihay ipoh hên pinakapoon pari. ");
INSERT INTO sgb_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Amêhên, wani Apo Jesus kanlan ampipandakêp kana, “Andakpên yo ko hên main kalamoy êtak haka pammatok hên nanad pandakêp ha mapanyag karawakan. ");
INSERT INTO sgb_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Allo-allo atsi ko bahên kamoyu hên nanoro ha Templo, unin a yo ko dinakêp. Noa, dapat matupad ya Kahulatan ya impahulat ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Bayo naubuh la yan nilakwanan hên tagahonol na hên nipamwayu. ");
INSERT INTO sgb_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Amêhên, main mihay miyawhay ya nangamat kanlan Apo Jesus, ya nakatapih hên ayn panlalê. Dinakêp la yan nandakêp kan Apo Jesus, ");
INSERT INTO sgb_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","noa, ha pamag-ulabtoh na, ay nabalagan na ya pinagtapih na, kabay nakalaboh ya tanan nuwayu. ");
INSERT INTO sgb_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Gintan la hi Apo Jesus ha balin pinakapoon pari. Ta bayro hilan ni-tsi-tsipon hilay mánoron Kautuhan ni apo Moises, hilay toa ya nag tungkulan ha bansa, haka hilay ampamaala kanlan pari. ");
INSERT INTO sgb_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Hi Pedro ay nangamat kanla ha marayo-dayo angga ha lote hên bali nan pinakapoon pari. Bayro yan nakiikno kanlan bantay ya ampanêngêy. ");
INSERT INTO sgb_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Hilay ampamaala kanlan pari haka ya boon Sanedrin, ay ampanapol hên maibara la kan Apo Jesus, ta êmên la ya maipapatsi. Noa, ayn hilan matapol. ");
INSERT INTO sgb_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mal-at ya bat hên ampanistigos ya alwan pêtêg hên tungkol kan Apo Jesus, noa, alwan akma ya panhabiên la. ");
INSERT INTO sgb_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Bayo main ungnoy nirêng ya naghabin alwan pêtêg, ya wanla, ");
INSERT INTO sgb_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nagilam naên ya hinabi na ya hiraên nay Templo ya dinyag tawo, ta ha tatloy allo, ay maypairêng yan kaatag ya Templo ya alwan dyag tawo.” ");
INSERT INTO sgb_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Noa, alwa êt akma ya hinabi la. ");
INSERT INTO sgb_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Amêhên, nirêng ya pinakapoon pari la ha arapan lan kal-atan, ta kinotang na hi Apo Jesus, ya wana, “Hino ya mahabi mo ha an-ibara la kamo? Pata a ka maghabi?” ");
INSERT INTO sgb_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Noa, minghan man, ay a ya naghabi hi Apo Jesus. Wanay na êt hên pinakapoon pari kana, “Habiên mo kannaên no hika ya Mesias, ya Cristo, ya impangakon Mámiligtas, ya Anak ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Wana etaman ni Apo Jesus, “Awo, pêtêg ya hinabi mo. Haka lano, ay mahêlêk yo ko, ya Taga-Langit, ya In-anak Tawo, hên nakaikno ha dapit panabtab ni Apo Namalyari ya Makapangyarihan. Haka ha pag-orong kon ubat ha langit, ay mahêlêk yo ko ha lêmm ya anlumatêng.” ");
INSERT INTO sgb_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Gawan huluk nan pinakapoon pari, ay ginihi nay sarili nan takop, ta wana, “A tamina kailangan hên kaatag ya tistigos, ta nagilam tamina man ya hinabi na. ");
INSERT INTO sgb_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nagilam yoy nay pamipantag nan sarili na kan Apo Namalyari! Yarin a nan ammusmusên hi Apo Namalyari ya tawo yan bêngat! Hino ya labay yon daygên kana?” Naubuh hilan naghabi ya dapat yan patsên. ");
INSERT INTO sgb_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Hi Apo Jesus ay dinul-an haka pinagtutumbuk. Tinagpênan lay mata na, bayo wanla, “Habiên mo no hinoy nanumbuk kamo!” Pinagtatampaling la ya êt hên ampipagbantay kana. ");
INSERT INTO sgb_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Kaban atsi ya hi Pedro hên nakiikno hên kalamo lan bantay ya ampanêngêy, ay napansin yan babayi ya mihay ipoh hên pinakapoon pari. ");
INSERT INTO sgb_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pinuliah na ya, ta wana, “Hika ay kalamo êt ni Jesus ya taga-Nazaret.” ");
INSERT INTO sgb_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Noa, hinabi ni Pedro, ya wana, “Alwa. A ko muwang ya anhabiên mo.” Bayo nagdayo yan pêrad ha apoy hên dinumani ha pag-awahan. Kanan habayto ay nangkatsi ya mihay manok. ");
INSERT INTO sgb_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","A nabuyot ay napansin yay na êt hi Pedro, hên habaytoy ipoh ya babayi, ya wana kanlan lalaki ya atsi bayro, “Habain ya lalaki, ay miha ya êt kanla!” ");
INSERT INTO sgb_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Noa, nagpuglaoh yay na êt hi Pedro. Hên a nabuyot, ay wanlan karani ni Pedro kana, “Siguradon hika ya kalamo ni Jesus, gawan taga-Galilea ka êt.” ");
INSERT INTO sgb_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Noa, hinabi ni Pedro, ya wana, “Alwa! Matsi ko man, ay taganán a ko ya muwang ya habain!” ");
INSERT INTO sgb_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kaban ampaghabi ya pon, ay nangkatsi yay na êt ya manok. Bayo naihipan ni Pedro ya hinabi kana ni Apo Jesus, ya wana, “Bayo mangkatsi ya manok hên katalwa, ay katatlo mon habiên, ya a mo ko muwang.” Kabay inumawah ya hi Pedro hên hadyay tangih na. ");
INSERT INTO sgb_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Dali allo, ay nagkamiha ya Sanedrin, ya angkaboo hên toa ya nag tungkulan ha bansa, hilay ampanoro hên Kautuhan ni apo Moises, haka hilay ampamaala kanlan pari, hên gêtan la hi Apo Jesus kan Gobernador Pilato. Kabay ginapoh la yan gintan kana. ");
INSERT INTO sgb_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Amêhên, kinotang ni Gobernador Pilato hi Apo Jesus, ya wana, “Awta? Hika ya ari hên Israelita?” Hinabi etaman ni Apo Jesus, “Hinabi mina, Gobernador.” ");
INSERT INTO sgb_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Mal-at ya an-ibara la kan Apo Jesus hên hilay ampamaala kanlan pari. Noa, a ya naghabi hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Wanay na êt ni Gobernador Pilato kan Apo Jesus, “Awta a mon pakibatan ya an-ibara la kamo? A mo angkagilaman ya kal-atan an-ibara la kamo?” ");
INSERT INTO sgb_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Noa, a ya naghabi hi Apo Jesus. Kabay nag-êpapah hi Gobernador Pilato. ");
INSERT INTO sgb_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Main kaugalian, ha balang Pistan Pangaligtas ha Egipto, ya an-ibuhan nan gobernador ya mihay nakahukul ya ampiliên lan kal-atan. ");
INSERT INTO sgb_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kanan habayto, ay nakahukul ya mihay lalaki ya nag langan Barrabas, gawan nakilamo ya kanlan nanalanghang ha gobyernon Roma, haka gawan namatsi yan tawo. ");
INSERT INTO sgb_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Dinumani hilay kal-atan kan Gobernador Pilato hên nakihabi kana ya honolên nay kaugalian, ya ha Pistan Pangaligtas, ay ibuhan nay mihay nakahukul. ");
INSERT INTO sgb_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Kabay wana kanla, “Labay yon ibuhan ko hi Jesus, ya Ari yon Israelita?” ");
INSERT INTO sgb_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ta muwang ni Gobernador Pilato ya hi Apo Jesus, ay gintan lan ampamaala kanlan pari kana, gawan angkahêman la ya. ");
INSERT INTO sgb_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Noa, hilay ampamaala kanlan pari, ay nanulhul hên kal-atan ya pakikwaan la kan Gobernador Pilato ya ibuhan na hi Barrabas. ");
INSERT INTO sgb_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Kabay kinotang na hila ni Gobernador Pilato, “Hino awud ya labay yon daygên ko kan Jesus ya ambaêgên yon Ari yon Israelita?” ");
INSERT INTO sgb_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Kabay in-angaw la, “Ipako ya ha koros!” ");
INSERT INTO sgb_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Bayo kinotang ni Gobernador Pilato, “Awta? Hinoy kasalanan na?” Noa, impapakaangaw lay na êt, “Ipako ya ha koros!” ");
INSERT INTO sgb_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Hinonol nay kalabayan lan kal-atan, ta imbuhan na hi Barrabas. Impadapi na hi Apo Jesus, haka indin na ya kanla, ta êmên la ya ipapako ha koros. ");
INSERT INTO sgb_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Hi Apo Jesus ay gintan lan hundaloh ha lalên balin gobernador, haka inubuh lan tsinipon ya kal-atan kapareho lan hundaloh. ");
INSERT INTO sgb_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ha pammusmus la kana, ay pinatakopan la ya hên mahampat ya takop, ya nanad ha takop lan ari. Bayo nangwa hilan nanad tanyuong, ya pinanyag la yan korona, ya impakopya la ha ulo na. ");
INSERT INTO sgb_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Haka in-angaw ya êmên di, “Kumara dayi ya biyay hên Ari lan Israelita!” ");
INSERT INTO sgb_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Pinagpapatok lay ulo na hên tambo, haka la ya pinagdu-dul-an. Nandoko hila ha arapan na ha pamanggalang la waringan kana. ");
INSERT INTO sgb_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pamakayari la yan minusmus, ay inalíh lay takop ari ya impatakop la kana, ta impatakop la kanan oman ya takop na. Bayo gintan la yay na, ta ipako la ya ha koros. ");
INSERT INTO sgb_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ha pammita lan hundaloh hên anggêtan hi Apo Jesus, hên ipako ha koros, ay natupa la ya tatang ni Alejandro haka ni Rufo, ya hi Simon ya taga-Cirene, ya ampamuli ha balayan. Dinakêp la ya ta impabalangaw kana ya koros ya paypakoan la kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Inhundo lay pammita la, hên angga ha nilumatêng hila ha logal ya ambaêgên Golgota o Bungo. ");
INSERT INTO sgb_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Painêmên la ya dayin alak, ya dyag ha habaw ubas, ya naglamo hên tambal ilab ya nag langan mira, noa, a na ininêm. ");
INSERT INTO sgb_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Amêhên, impako la yay na bayro ha koros. Bayo pinagpalabonutan lay takop na, ta êmên la mamwangan no hino kanla ya makakwa. ");
INSERT INTO sgb_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Alas nuwebe hên habayto, hên matag-ay ya allo, hên impako la hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Bayro ha koros, ha ugton ulo na, ay nakahulat ya imbara la kana, “Hatsi ya Ari lan Israelita.” ");
INSERT INTO sgb_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Main êt loway lalaki, ya parehon mapanyag karawakan ya impako ha koros. Ya miha ay atsi ha koros ha dapit panabtab ni Apo Jesus, haka ya miha ay atsi ha koros ha dapit uki ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ha dinyag la kan Apo Jesus, ay natupad ya impahulat ni Apo Namalyari ha Kahulatan ya wanan hulat, “Intad la yan mapanyag karawakan.” ");
INSERT INTO sgb_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Minusmus la yan anlumabah hên main lamoy pamamêyêng, ya wanla, “Hika awud ya labay maniran Templo ni Apo Namalyari, ta ipairêng mon oman ha tatloy allo! ");
INSERT INTO sgb_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Munaoy kan ubat ha koros hên iligtas moy sarili mo!” ");
INSERT INTO sgb_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Êmbayro êt ya pammusmus la kana hên hilay mánoron Kautuhan ni apo Moises haka hilay ampamaala kanlan pari, ya wanla ha miha ta miha, “Inligtas nay kaatag, pata a na mailigtas ya sarili na! ");
INSERT INTO sgb_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","No tumaoy yan ubat ha koros, habain ya Mesias, ya Cristo, ya Ari tamon Israelita, ay maniwala kitamo kana!” Minusmus ya êt, hên hilay mapanyag karawakan ya nakapako hên kalamo na. ");
INSERT INTO sgb_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Hên ugtoy nay allo, ay dinumiglêm ya boon luta angga ha alas tres hên maapon. ");
INSERT INTO sgb_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Hên alas tres hên maapon, ay impakaangaw ni Apo Jesus, ya wana, “Eloi, Eloi, lema sabachthani?” ya labay habiên, “Diyos ko, Apo Namalyari, pata nilakwanan mo ko?” ");
INSERT INTO sgb_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Hên nagilam lan kaatag ya nakairêng bayro ya in-angaw na, ay êndat lan ambaêgên na hi Propeta Elias, kabay wanla, “Gilamên yo! Ambaêgên na hi Elias!” ");
INSERT INTO sgb_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nuwayu ya miha kanla hên namiptêh hên nanad bolak ha mihay hanga, ta indêrê na ha nangihoy alak, ya dyag ha habaw ubas, ta painêmên na ya hi Apo Jesus. Bayo wana, “Paulayan tamo ya raw. Hêlkên tamo no iligtas ya ni Elias!” ");
INSERT INTO sgb_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Amêhên, nan-angaw hi Apo Jesus hên hadyay hêkaw, bayo natsi yay na. ");
INSERT INTO sgb_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ya makugpa ya takop ya pinagpênlan bayro ha lalê hên Templo ha Jerusalem, ay biglan nawakwak hên napibonak paubat ha babo angga ha aypa. ");
INSERT INTO sgb_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Hên nahêlêk nay pangamatsi ni Apo Jesus hên ampamaala kanlan hundaloh, ya atsi ha êtêb na, ay pinuri na hi Apo Namalyari, ya wana, “Pêtêg bay awud! Hiyay Anak ni Apo Namalyari!” ");
INSERT INTO sgb_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Main babayi bayro ya ampandungaw ha angkalyari. Kalamo la hi Maria Magdalena, hi Salome haka, hi Maria ya indo ni Jose boy hi Santiago ya ambaêgên Ali. ");
INSERT INTO sgb_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Hilay habaytoy babayi ay kalamo lan Apo Jesus hên nanaglap kanla paubat hên atsi hila pon ha probinsyan Galilea. Main pon êt hên kal-atan babayi bayro, ya kala-kalamo la hên angga ha Jerusalem. ");
INSERT INTO sgb_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Hên ampinaboy nay allo, haka gawan ha kaugalian la, ya dapat milbêng ya natsi, hên bayo matata ya allo ha Biyernes, ya allon pamaglêan la para ha allon pamagsimba la, ");
INSERT INTO sgb_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ay makhaw ya nakêm hên nakiarap kan Gobernador Pilato, ya miha kanlan taga-balayan Arimatea, ya nag langan Jose. Hi Jose, ay miha kanlan kalamo ha Sanedrin, ya anggalangên hên kapareho na, ya ampangênggan ha pamanlumatêng hên pamanlokop ni Apo Namalyari. Pinakihabi nay bangkay ni Apo Jesus, ta iilbêng na dayi. ");
INSERT INTO sgb_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nag-êpapah hi Gobernador Pilato hên nagilam na ya natsi yay na hi Apo Jesus. Kabay impabaêg nay ampamaala kanlan hundaloh, ta labay nan mamwangan no pêtêg yay nan natsi hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Hên namwangan na ha ampamaala kanlan hundaloh ya pêtêg yay nan natsi hi Apo Jesus, ay nabay yay na etaman. Kabay impaulay nay na kan Jose ya bangkay ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nanaliw hi Jose hên makarang ya takop ya naputsi ya pinangêlkêl na hên bangkay ni Apo Jesus hên naiaypa nay na. Bayo inhowên na ya ha bayoy dinyag ya pay-ilbêngan ya lêyang. Pangayari, ay intulid nay hadyay hêlay bato hên panakap na ha bêbêy pinay-ilbêngan. ");
INSERT INTO sgb_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Hi Maria Magdalena haka hi Maria, ya indo ni Jose ay nakahêlêk hên pamilbêng la kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Hên yabin Sabado, hên nayari ya allon pamagsimba la, ay nanaliw hên pabango, hi Salome, hi Maria Magdalena, haka Maria ya indo ni Jose haka hi Santiago, ta habaytoy pabango, ay itugtug la dayi ha bangkay ni Apo Jesus ha humonoy maranon. ");
INSERT INTO sgb_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Dali allo êt hên allon Dominggo, ay nagtagloh hilay nay babayi ha pinay-ilbêngan, kabay hên nilumatêng hila, ay an-umawah ya allo. ");
INSERT INTO sgb_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kaban atsi hila ha dann, ay nihahabi hila no hino ya mapakihabian la hên itulid ya bato ha bêbêy hên pinay-ilbêngan kana ta êmên hila makahowên. ");
INSERT INTO sgb_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Noa, hên hinlêk la, ay napansin la ya naitulid ya habaytoy hadyay hêlay bato. ");
INSERT INTO sgb_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Hên hinumwên hila ha pinay-ilbêngan, ay nahêlêk lay mihay miyawhay ya nakatakop hên naputsi ya nakaikno ha dapit panabtab, kabay hadyay limo lan babayi. ");
INSERT INTO sgb_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Noa, wana kanla, “Paan kaw malimo! Antapolên yo hi Apo Jesus, ya taga-Nazaret ya impako ha koros. Nabiyay yan oman! Ayn ya di. Hêlkên yoy habaytsi ya pinaybul-ihan kana. ");
INSERT INTO sgb_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mag-orong kaw, ta habiên yo kan Pedro haka kanlan kaatag ya tagahonol na, ya hi Apo Jesus ay nangoman nabiyay, haka muna yay na kanla ha probinsyan Galilea hên nanad ha hinabi na kanla.” ");
INSERT INTO sgb_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Inumawah hila ha pinay-ilbêngan hên ampamêgpêg, haka pinarah lan nuwayun nagtagloh kanlan tagahonol. Gawan ha limo la, ay a la inhabi ya nalyari ha hinoman ya atsi ha dann. ");
INSERT INTO sgb_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Hên habayto êt hên allon Dominggo, hên nabiyay yan oman hi Apo Jesus, ya una nan pinagpahlêkan, ay hi Maria Magdalena, ya inalihan na hên hato hên pitoy narawak ya a angkahêlêk ya hinumapat kana. ");
INSERT INTO sgb_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Nagtagloh hi Maria Magdalena kanlan tagahonol ni Apo Jesus ya nalatêng nan ampamalagêhbêg ya nakêm haka ampipanangih, ta hinabi na kanla ya nabiyay yan oman hi Apo Jesus haka nahêlêk na ya. Noa, a hila naniwala ha hinabi na. ");
INSERT INTO sgb_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Panga-ubat hên habayto, ay nagpahlêk hi Apo Jesus kanlan loway tagahonol na, ya atsi ha dann hên palako ha mihay baryo, noa, kaatag ya itsura na. ");
INSERT INTO sgb_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tampol hilan nag-orong ha Jerusalem ta imbalita la kanlan kapareho lan tagahonol, ya nahêlêk la hi Apo Jesus, noa, a hila pinaniwal-an. ");
INSERT INTO sgb_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Bayo nagpahlêk ya hi Apo Jesus kanlan labinmihay tagahonol na, kaban ampangan hila. Hinabyanan na hila, gawan kulang ya paniwala la kana, haka kakdêyan ulo la, ya a hila naniwala ha balita lan nakahêlêk kana ya hiyay nabiyay oman. ");
INSERT INTO sgb_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Wana kanla, “Ipamwang yo ha boon luta ya Mangêd ya Habi tungkol kangko. ");
INSERT INTO sgb_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Hilay maniwala ha Mangêd ya Habi, haka pabawtismo, ay miligtas ha kaparusaan hên kasalanan la. Noa, hilay a maniwala ay parusaan ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Hilay ampaniwala kangko, ay madyanan ni Apo Namalyari hên kapangyarihan hên manyag kapapaêpapah, hên nanad ha mamaalíh hên nangarawak ya a angkahêlêk, gawan ampanggamit hilan langan ko, haka maghabi hila ha bayoy habi ya a la pinag-aralan. ");
INSERT INTO sgb_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Makatalan hila man hên utan ya makamatsi, o makainêm man hên hinon makamatsi, ay ayn malyari kanla. No ipalunto lay gamêt la, hên ihalangin hilay nipaghakit, ay maalíh ya hakit la.” ");
INSERT INTO sgb_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Hên nahabi nay na ya habayto ni Panginoon Jesus, kaban anhêlkên la ya, ay antumag-ay yay na hên palako ha langit, haka ya nikno ha dapit panabtab ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Hilay tagahonol na ay nipammitay na ha ayri man ya logal, hên naypamwang hên Mangêd ya Habi tungkol kana. Hi Panginoon Jesus ay ampamaptêg ha pamanoro la, gawan habaytoy kapapaêpapah ya angkadyag la ha kapangyarihan na.");
INSERT INTO sgb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Panggalangên kon Teofilo, Mal-at ya nanulat hên tungkol ha natupad di kantamo ha bansan Israel. ");
INSERT INTO sgb_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ya inhulat la ay hatoy impamwang kannaên lan habaytoy nakahêlêk hên natupad. Hilay nakahêlêk hên natupad, ay namipamwang hên habi ni Apo Jesu-Cristo paubat hên babayo yan nanoro. ");
INSERT INTO sgb_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Hên naubuh kinan pinag-aralan hên mangêd ya habayto, paubat hên una, ay naihipan ko etaman hên ipakangêd kon ihulat ya habayto para kamo, panggalangên kon Teofilo. ");
INSERT INTO sgb_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Anhulatan kata ta êmên mo mapaptêgan ya impamwang kamo. ");
INSERT INTO sgb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ha panaon hên hi Arin Herodes ay manungkulan ha probinsyan Judea, nag mihay pari bayro, ya hi Zacarias. Hi Zacarias, ay miha kanlan pari ha pangkat ni Abias. Hiya haka ya ahawa na, hi Elisabet, ay parehon kaapo-apoan ni Aaron, ya kauna-unaan pari lan Israelita. ");
INSERT INTO sgb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Hata miahawa ay mangêd ha arapan ni Apo Namalyari. Hinonol lay balang utoh haka patakaran na. ");
INSERT INTO sgb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Noa, ayn hilan anak gawan layuh hi Elisabet, haka toa hilay na. ");
INSERT INTO sgb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Amêhên, mihay allo, hên atag lan pangkat ni Zacarias hên maghuyo ha arapan ni Apo Namalyari, ");
INSERT INTO sgb_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","langan ni Zacarias ay nabonut hên nanad ugali lan pari, ta êmên ya humwên ha Templo, ya pagsimbaan kan Apo Namalyari, êmên mamaahuk hên pabango ha pamagsimba kana. Kabay hinumwên yay na hên mimiha na ");
INSERT INTO sgb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","hên mamaahuk hên pabango, kaban atsi hila ha danin ilwangan ya kal-atan ya ampanalangin. ");
INSERT INTO sgb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Namakonkaynaman, ay nag anghel ni Apo Namalyari ha dapit panabtab hên paybul-ihan paypaahukan nan pabango ni Zacarias. ");
INSERT INTO sgb_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nakatsigag ya hi Zacarias hên nahêlêk nay anghel. Hadyay limo na. ");
INSERT INTO sgb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Noa, hinabi kana hên anghel, ya wana, “Paan kan malimo, Zacarias, ta nagilam ya panalangin mo. Hi Elisabet, ya ahawa mo, ay magkaanak ya kamo hên mihay lalaki ya pata-ngalanan yon Juan. ");
INSERT INTO sgb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Hadyay higla mo. Haka mal-at ya kaatag ya humigla ha pamianak kana, ");
INSERT INTO sgb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","gawan hiyay dayêwên ni Apo Namalyari. Hata ianak, ya hi Juan, ay dapat a ya minêm hên alak, haka hinon makalahing. Ya Espiritu ni Apo Namalyari ay humapat kana hên paubat ha hiyay ialêk. ");
INSERT INTO sgb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Paorongên nay ihip hên mal-at ya Israelita kan Apo Namalyari, ya Diyos la. ");
INSERT INTO sgb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Hiyay muna kanan Panginoon ha parehon hêkaw haka kapangyarihan ya indin kan apo Elias, ya mámipamwang hên impaihip kana ni Apo Namalyari hên hato. Paorongên nay pamanlugud ha balang mitataanak, haka na paorongên hilay anhumalanghang hên mag-in nanad kanlan mahonol kan Apo Namalyari. Daygên nay habayto ta êmên mail-an ya ihip lan pinili na, ha pamanlumatêng hên Panginoon.” ");
INSERT INTO sgb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Amêhên, hinabi ni Zacarias kanan anghel, ya wana, “Ay-êmên kon mapaptêgan no matupad ya hatsi? Mantêg kinan toa haka mantêg toa ya ahawa ko.” ");
INSERT INTO sgb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Hinabi nan anghel, ya wana, “Hikoy Gabriel ya panay pan-iutoh ni Apo Namalyari. In-utoh na ko êmên ipamwang kamo ya hata mangangêd ya habi. ");
INSERT INTO sgb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Noa, gawan a ka naniwala ha hinabi ko, ay a ka pon makahabi angga ha a pon matupad ya hata impamwang ko kamo ya taganán matupad.” ");
INSERT INTO sgb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Hilay kal-atan ya atsi ha danin ilwangan, ya ampanalangin, ya ampangênggan kan Zacarias, ay nag-êpapah no awta hadyay buyot na ha lalê hên Templo. ");
INSERT INTO sgb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Hên inumawah ya, ay a yay na makahabi. Panay singyal tana ya ginamit na. Kabay namwangan la ya nakahêlêk yan kapapaêpapah bayro ha lalên Templo. Taganán a yay na makahabi hi Zacarias. ");
INSERT INTO sgb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Hên nayari nay na ya pandaygên na ha Templo, ay nuli yay na. ");
INSERT INTO sgb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","A nabuyot ay nangalêk ya ahawa na, hi Elisabet. Mana ya tana ha bali la hên limay buwan. ");
INSERT INTO sgb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Amêhên, naghabi ya hi Elisabet, ya wana, “Dinambi ko ni Apo Namalyari. Dinyag nay hatsi ta êmên maalíh ya dêng-êy ko ha kapareho ko.” ");
INSERT INTO sgb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Amêhên, ha pang-anêm ya buwan hên buktot ni Elisabet, ay in-utoh ni Apo Namalyari hi Gabriel, ya habaytoy anghel, ha balayan Nazaret ha probinsyan Galilea ");
INSERT INTO sgb_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ha mihay dalaga ya nag langan Maria, ya kabaan ni Jose, ya mihay kaapo-apoan ni Arin David. ");
INSERT INTO sgb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Hên nilumatêng ya kanlan Maria, ay hinabi nan anghel, ya wana, “Iningalwan ka ni Apo Namalyari kabay atsi ya kamo.” ");
INSERT INTO sgb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nakatsigag hi Maria ha hinabi na haka nan an-ihip-ihipên no hinoy labay nan habiên hên hatsi. ");
INSERT INTO sgb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Noa, hinabi nan anghel kana, ya wana, “Paan kan malimo Maria, ta iningalwan ka ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Manggilam ka! Mangalêk ka ta mamianak ka hên lalaki ya pata-ngalanan mon Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Hiyay itag-ay ni Apo Namalyari haka hiyay baêgên Anak ni Apo Namalyari. Idin kana ni Apo Namalyari ya panungkulan ya nanad panungkulan ni Arin David, ya mihay ninuno na. ");
INSERT INTO sgb_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kabay hiyay manungkulan kanlan Israelita hên ayn angga. Ya pamanlokop na ay ayn angga.” ");
INSERT INTO sgb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Kabay hinabi ni Maria ha anghel, ya wana, “Ay-êmên malyari ya hatsi, ha dalaga ko pon?” ");
INSERT INTO sgb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Amêhên, wanan anghel ya êmên di, “Ya Espiritu ni Apo Namalyari ay lumatêng kamo ta ya kapangyarihan na ay magdahêl kamo. Kabay ya ianak mo ay ayn hinon kasalanan haka baêgên yan Anak ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Hêlkên mo hi Elisabet, ya kamag-anak mo. Muwang lan kal-atan ya layuh ya. Yan nangalêk ya, haka atsi yay na ha pang-anêm ya buwan hên buktot na, agyan toa yay na. ");
INSERT INTO sgb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Hinoman ya labay nan daygên ni Apo Namalyari, ay madyag na.” ");
INSERT INTO sgb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kabay hinabi ni Maria, ya wana, “Humonol ako kan Apo Namalyari. Malyari dayi kangko ya hinabi mo.” Haka nag-alíh yay nay anghel. ");
INSERT INTO sgb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","A nabuyot, namarah-parah hi Maria ha bali lan Zacarias ha mihay balayan ha kabung-oyan hên probinsyan Judea. ");
INSERT INTO sgb_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Hên nilumatêng ya ha bali la, ay binaêg na hi Elisabet, bayo hinumwên yay na. ");
INSERT INTO sgb_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Hên nagilam ni Elisabet ya baêg ni Maria, ay nagkimit ya anak ha bitoka na haka hinumapat kana ya Espiritu ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","In-ikhaw nay habi na, ya wana, “Iningalwan ka kanlan kaganawan babayi haka ya ianak mo, ay iningalwan etaman ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Hino ko ta hiniraw ako hên indo hên Panginoon ko? ");
INSERT INTO sgb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nahên nagilam koy baêg mo, ay nagkimit ya anak ha bitoka ko, gawan kahiglaan na. ");
INSERT INTO sgb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Iningalwan ka gawan naniwala ka ya matupad ya impahabi kamo ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Amêhên, hinabi ni Maria, ya wana, “Ampuriên ko hi Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Mahigla ko gawan hiyay Mámiligtas ko. ");
INSERT INTO sgb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Hiyay puriên ko, gawan miha ko man ya mairap ya ipoh na, ay dinambi na ko. Ubat amêhên angga-angga, ay baêgên la ko hên iningalwan, ");
INSERT INTO sgb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","gawan ha kapapaêpapah ya dinyag na kangko ni Apo Namalyari ya makapangyarihan haka banal. ");
INSERT INTO sgb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","An-ingalwan nay balang ampagpalokop kana, paubat hên unan panaon hên angga-angga. ");
INSERT INTO sgb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Impakit nay kapangyarihan na hên pinitatayak na hilay mapaglalang. ");
INSERT INTO sgb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Impaalíh nay manungkulan ha tungkulan la haka impatag-ay na hilay alwan mapaglalang. ");
INSERT INTO sgb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Pinabhoy na hilay matsin lonoh hên mangangêd, haka impaalíh na hilay mabandi hên ayn hino. ");
INSERT INTO sgb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Hinawpan na kitamo ya Israelita ya nagpalokop kana gawan hiyay maingaloên. Ha êmbayro ay tinupad nay pangako na ");
INSERT INTO sgb_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Kan apo Abraham, ya ninuno tamo, boy kantamo haka kanlan kaganawan kaapo-apoan ni apo Abraham ya hawpan na kitamo hên angga-angga!” ");
INSERT INTO sgb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Naglaêh hi Maria kanlan Elisabet hên tatloy buwan bayo nuli yay na. ");
INSERT INTO sgb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Amêhên, hên nilumatêng ya oras hên panganak ni Elisabet ay in-anak nay mihay lalaki. ");
INSERT INTO sgb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Hên namwangan lan kabaryo na haka kamag-anak na, ya impahlêk kana ni Apo Namalyari ya ingangalo na, ay hinumigla hila etaman. ");
INSERT INTO sgb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Hên nilumatêng ya pangwalon allo ay naniraw hila kanlan Zacarias, ta tuliên lay habaytoy anak. Pata-ngalanan la ya dayin Zacarias nanad hên toa na. ");
INSERT INTO sgb_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Noa, hinabi ni Elisabet, ya wana, “Alwan Zacarias, ta Juan ya ipata-ngalan kana.” ");
INSERT INTO sgb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Amêhên, hinabi la kana, “Ayn kanlan kamag-anak mo ya nag langan Juan.” ");
INSERT INTO sgb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Bayo siningyalan la hi Zacarias no hinoy labay nan ipata-ngalan ha anak na. ");
INSERT INTO sgb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Namakwa yan mapanulatan ta nanulat ya hên hatsi, “Ya langan na ay Juan.” Naubuh hilan nag-êpapah. ");
INSERT INTO sgb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Namakonkaynaman ay nakapaghabi yay nan oman, kabay pinuri na hi Apo Namalyari! ");
INSERT INTO sgb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nalimwan ya kabaryo la, haka hata nalyari ay impamwang ha kaganawan baryo ha kabung-oyan hên probinsyan Judea. ");
INSERT INTO sgb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Habaytoy nalyari ay ampapakaihipên hên balang nakagilam ha nalyari, haka ampikokotang hila no hinoy mag-in kapalaran nan anak, ta malinaw kanla ya atsi kanan anak ya kapangyarihan ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Amêhên, hinumapat kan Zacarias ya Espiritu ni Apo Namalyari. Impapêt na ya êmên di, ya wana, ");
INSERT INTO sgb_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Puriên tamo hi Apo Namalyari, ya Diyos tamon Israelita. Iningalwan na kitamoy ampagsimba kana ta inakbus na kitamo. ");
INSERT INTO sgb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","In-utoh na kantamo ya makhaw ya Mámiligtas, ya mihay kaapo-apoan ni Arin David, ya naghuyo êt kana. ");
INSERT INTO sgb_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Habaytoy impamwang na kanlan banal ya mámipamwang hên an-ipaihip na kanla hên unan panaon. Hinabi la ");
INSERT INTO sgb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ya iligtas na kitamo kanlan kapatsi tamo, haka kanlan kaganawan anhumêmêk kantamo. ");
INSERT INTO sgb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ingalwan nay ninuno tamo ta tuparên nay banal ya kahundoan na kanla, ");
INSERT INTO sgb_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ya impangako na kan apo Abraham, ya ninuno tamo, ");
INSERT INTO sgb_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ya iligtas na kitamo kanlan kapatsi tamo ta êmên mapaghuyuan tamo ya hên ayn limo, ");
INSERT INTO sgb_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","hên main kabanalan, haka hên main pamanhumonol kana angga ha anggaan biyay tamo ha luta.” ");
INSERT INTO sgb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Amêhên, hinabi ni Zacarias kanan anak na, ya wana, “Hika, anak ko ay baêgên la kan propeta ni Apo Namalyari gawan muna ka ha Panginoon tamo ta êmên mo mail-an ya danan na ha pamanlumatêng na. ");
INSERT INTO sgb_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ipamwang mo ha pinili na, ya patawarên hila haka iligtas hila ha parusa ya lumatêng kanla gawan kasalanan la. ");
INSERT INTO sgb_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Hatsi ay gawan ingangalo haka pamanlugud ni Apo Namalyari, ");
INSERT INTO sgb_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ya mamahawang hên nanad allo kanlan atsi ha kariglêman, ya maranin matsi, haka hiyay mamitoro kantamo hên dann ya palakon kapatêkbêkan.” ");
INSERT INTO sgb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Amêhên, hinumlay ya hata anak haka nagkaihip. Napaidi ya ha kabalah-balahan, hên angga ha hiyay napabalay kanlan Israelita. ");
INSERT INTO sgb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Amêhên, hên habayton panaon, kaban hi Arin Herodes ay manungkulan ha probinsyan Judea, ya pinakapoon la ha Roma, ay hi Emperador Augusto. Namiutoh ya hi Emperador Augusto hên mangwa hilan sidula, ya balang miha ya angkasakopan na, ta êmên ya makakwan bayad hên buwih la. ");
INSERT INTO sgb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Habaytsi ya unan utoh tungkol ha mangwan sidula ay nalyari hên hi Cirenio ay gobernador ha probinsyan Siria. ");
INSERT INTO sgb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kaganawan ya atsi ha lokop hên bansan Roma, anggan hilay Israelita, ay nammita ha balayan lan ninuno la, ta êmên mangwan sidula. ");
INSERT INTO sgb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Hi Jose, ya taga-balayan Nazaret, ha probinsyan Galilea, ay mihay kaapo-apoan ni Arin David ya in-anak ha balayan Betlehem ha probinsyan Judea. Kabay nammita hilan Jose hên mangwan sidula ha Betlehem. ");
INSERT INTO sgb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Lamo na ya hi Maria, ya kabaan na, ya nabuktot gawan ha kapangyarihan nan Espiritu ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kaban atsi hila bayro ha Betlehem, ay ampipaanak yay na. ");
INSERT INTO sgb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Noa, gawan ayn dyanan ha bali lan tawo ay nagdahêl hila tana ha paydyanan ayop. Bayron in-anak ya punganay na ya lalaki. Inupungan na yan takop, bayo na ya impakatuloy ha panganan hên baka ya nag aray. ");
INSERT INTO sgb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Habayton yabi, bayro êt ha danin Betlehem ay main nagdangho ya pastol ya ampipagbantay ha tupa la. ");
INSERT INTO sgb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Namakonkaynaman ay nagpahlêk kanla ya mihay anghel ni Apo Namalyari, haka hinumawang kanla ya kapahilêw ya kahampatan ni Apo Namalyari. Kabay hadyay limo la. ");
INSERT INTO sgb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Noa, wanan anghel, “Paan kaw malimo ta ampantan kataw hên mangêd ya habi ya mamahigla hên balang miha. ");
INSERT INTO sgb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","In-anak amêhên yabi ya Mesias, ya Cristo, ya impangakon Mámiligtas, ya Panginoon. Bayri yan in-anak ha Betlehem, ya balayan ni Arin David. ");
INSERT INTO sgb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Êmên di yo yan mamwangan. Matsikap yoy mihay kapianak ya inupong haka nakakatuloy ha panganan hên baka ya nag aray.” ");
INSERT INTO sgb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Namakonkaynaman ay nagpahlêk kanla ha danin anghel ya mal-at ya kalupa na ya ubat ha langit ya ampagpuri kan Apo Namalyari hên êmên di, ");
INSERT INTO sgb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Puriên hi Apo Namalyari ya atsi ha langit. Haka magkamain dayin kapatêkbêkan ya hilay atsi ha luta ya ampamahigla kana.” ");
INSERT INTO sgb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Hên nakabita hilay nay anghel paorong ha langit, nihahabi hilay pastol. “Mita kitamina ha Betlehem ta êmên tamo mahêlêk ya hata nalyari ya impamwang ni Apo Namalyari kantamo.” ");
INSERT INTO sgb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kabay pinarah-parah lan nammita. Natsikap la hi Maria haka hi Jose. Habaytoy kapianak ay nakakatuloy ha panganan hên baka ya nag aray. ");
INSERT INTO sgb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Hên nahêlêk lay kapianak, ay impamwang lay nay hinabi nan anghel ya tungkol kana. ");
INSERT INTO sgb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Naubuh hên nikaêpapah ya nakagilam hên habaytoy habi lan pastol. ");
INSERT INTO sgb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nitanêm ha ihip ni Maria ya hata habi la haka na pinag-ihip-ihipan. ");
INSERT INTO sgb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Kaban ampag-orong hilay pastol, ay ampuriên la hi Apo Namalyari bayro ha nagilam la haka nahêlêk la gawan napaptêgan lay hinabi nan anghel. ");
INSERT INTO sgb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Hên waloy nay allo nan hata anak, hiya ay tinuli haka pinata-ngalanan Jesus, ya langan ya indin nan anghel hên a ya pon in-alêk. ");
INSERT INTO sgb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Amêhên, nilumatêng ya ikaapatapoy allo ni Maria hên ubat nanganak. Habaytsi ya allo hên pamaglinis kanla, ay hinumwên hila ha Templo ha Jerusalem hên pamanhumonol ha Kautuhan ni apo Moises. Gintan la ya etaman hi Jesus ta iarap kan Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Dinyag lay habayto hên pamanhumonol ha nakahulat ha Kautuhan ni Apo Namalyari ya balang punganay ya lalaki ay idin kana, ta êmên hila maghuyo kana. ");
INSERT INTO sgb_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Amêhên, namiátang hila gawan Kautuhan ni Apo Namalyari ya wanan hulat, “Loway kokolok o loway oymok hên pati-pati.” ");
INSERT INTO sgb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Amêhên, main mihay lalaki ha balayan Jerusalem ya nag langan Simeon. Hi Simeon ay mangêd ha arapan ni Apo Namalyari haka hinonol nay Kautuhan na. Pan-êngganan nay pamiligtas kanlan Israelita haka atsi kana ya Espiritu ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Impamwang kana hên Espiritu ni Apo Namalyari, ya a ya matsi, angga ha a na mahêlêk ya Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala. ");
INSERT INTO sgb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Amêhên, impalako ya ha Templo hên Espiritu ni Apo Namalyari. Kaban atsi ya bayro, inhowên lan Maria ya bingot ya hi Jesus ta honolên lay Kautuhan. ");
INSERT INTO sgb_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Kingwa ni Simeon ya bingot hên inampon bayo pinuri na hi Apo Namalyari hên êmên di, ");
INSERT INTO sgb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Apo Namalyari, tinupad moy pangako mo. Malyari kinan matsi hên napatêkbêk, ");
INSERT INTO sgb_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","gawan nahêlêk kinay Mámiligtas ya impangako mo, ");
INSERT INTO sgb_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ya inlêan mo para ha kaganawan bansa. ");
INSERT INTO sgb_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kaalimbawaan nay hawang ya mamahawang hên dann lan alwan Israelita hên palako kamo. Gawan hata anak, ay dayêwên hilay Israelita.” ");
INSERT INTO sgb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nag-êpapah hi Maria haka hi Jose ha hinabi ni Simeon ya tungkol ha bingot. ");
INSERT INTO sgb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Inhalangin na hila ni Simeon bayo na hinabi kan Maria ya indo ni Jesus, ya wana, “Hata anak ay mag-in ikaparusa o ikaligtas hên mal-at ya Israelita. Hiyay palatandaan ya ubat kan Apo Namalyari ya halanghangên lan kal-atan. ");
INSERT INTO sgb_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Kabay mipamwang ya laman ihip hên kal-atan. Haka kamo, Maria, lumatêng ya kamo ya hadyay kalungkutan, ya nanad nilatog hên êtak ya nakêm mo.” ");
INSERT INTO sgb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Amêhên, atsi ya êt ha pagsimbaan ya mihay mámipamwang hên an-ipaihip kana ni Apo Namalyari ya nag langan Ana, ya anak ni Fanuel, ya kaapo-apoan ni Aser. Hi Ana ay toay na. Pitoy taon hilan nilamo hên ahawa na ");
INSERT INTO sgb_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","bayo ya nabawo. Amêhên walumpo boy apat ya taon nay na. Panay yan atsi ha Templo hên ampagsimba kan Apo Namalyari hên allo-yabi. Ha panalangin na ay a na angkadambi ya pangan na. ");
INSERT INTO sgb_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Sakton habayto, ay napakarani ya kanla hên ampahalamatan na hi Apo Namalyari. Impamwang na êt ya tungkol kanan hata bingot kanlan balang ampangênggan hên pamibuhan kanlan Israelita. ");
INSERT INTO sgb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Amêhên, hên nahonol lay nay balang utoh hên tungkol ha mitaindo ha pamanhumonol ha Kautuhan ni Apo Namalyari, ay nag-orong hilan Maria ha balayan Nazaret, ya balayan la, ha probinsyan Galilea. ");
INSERT INTO sgb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Amêhên, hi Jesus ay hinumlay, nagkaihip, haka nag-in matalino gawan atsi kana ya ingalo ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Balang taon main pista hilay Israelita ha Jerusalem, ta êmên la maihipan ya pamiligtas ni Apo Namalyari kanlan ninuno la ha bansan Egipto. Nakaugalian lan Maria haka hi Jose hên makipista. ");
INSERT INTO sgb_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Hên nag labinloway taon hi Jesus, ay nakipista hilay na êt, haka gintan la hi Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Hên nayari ya pista, ha pamag-orong la ay napaibalag ya ha Jerusalem hi Jesus ya anak la. Noa, a la muwang hên toa na. ");
INSERT INTO sgb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Êndat la no kalamo la ya ha kal-atan ya namapayabi hên ampita hên ampag-orong ha bali la. Habaytoy yabi, ay tinapol la ya ha kamag-anak la haka kabalay la. ");
INSERT INTO sgb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Amêhên, hên a la ya matapol ay nag-orong hilay na êt ha Jerusalem ta tapolên la ya bayro. ");
INSERT INTO sgb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Hên ikatloy nan allo hên panapol la kana, ay natapol la ya ha Templo hên kalamo lan mánoro. Ampanggilam ya kanla, haka ya ampangotang kanla. ");
INSERT INTO sgb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Hilay nakagilam habi na ay nipag-êpapah ha kagalingan ihip na haka ha kagalingan pamakibat na ha kotang la. ");
INSERT INTO sgb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nag-êpapah hilan Maria haka hi Jose hên nahêlêk la ya. “Anak ko,” wani Maria kana, “awta dinyag moy hatsi kannaên? Pinayagah mo kay hên nanapol kamo.” ");
INSERT INTO sgb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Amêhên, wani Jesus kanla, ya wana, “Pata antapolên yo ko, Indo? Awta a yo muwang ya kailangan hên atsi ko di ha balin Tatang ko?” ");
INSERT INTO sgb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Noa, a la naintindihan ya hinabi na kanla. ");
INSERT INTO sgb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Amêhên, nakihonol yay na kanla hên nuli ha balayan Nazaret ta dinyag na ya kaganawan labay lan toa na. In-ubuh nan intanêm ni Maria ya nalyari ha ihip na. ");
INSERT INTO sgb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Hi Jesus ay nagkaihip haka hinumlay. Hinumigla kana hi Apo Namalyari haka hilay tawo. ");
INSERT INTO sgb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Hên nakalabah ya ungnoy taon, ay ikalabinlimay taon hên pamamaala nan pinakapoon ha bansan Roma, ya hi Emperador Tiberio. Ya gobernador ha Judea, ay hi Poncio Pilato. Ya gobernador ha Galilea, ay hi Herodes Antipas, haka ya kapotoh pohêl na, ya hi Felipe ay gobernador ha Iturea haka Traconite. Hi Lisanias etaman ay gobernador ha Abilinia. ");
INSERT INTO sgb_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ya pinakapoon pari lan Israelita, ay hi Anas haka hi Caifas. Hên habayton panaon, ay ampaidi ya ha logal ya kabalah-balahan hi Juan, ya anak ni Zacarias, haka bayron nilumatêng kana ya utoh ni Apo Namalyari, ");
INSERT INTO sgb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","kabay nammita yay na hên nanoro ha mitatalipay hên Ilog Jordan. Impamwang na kanlan dinumani kana, ya dapat lan paghêhêan ya pamanyag lan kasalanan, bayo dapat pabawtismo hila, haka patawarên hila bayto ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ha dinyag ni Juan, ay natupad ya hinabi ni Propeta Isaias ya mihay mámipamwang hên an-ipaihip kana ni Apo Namalyari hên hato. Ya habaytoy hinabi na ay nakahulat, ya êmên di, “Main ampan-angaw ha logal ya kabalah-balahan, ya wana kanlan kal-atan ya naka-tsipon, ‘Il-an yoy nakêm yo ha pamanlumatêng hên Panginoon, Ya nanad ha pamil-an hên dann ha pamanlumatêng hên mihay matag-ay ya manungkulan. Itoynung yoy danan na. ");
INSERT INTO sgb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Taphonan yoy kaganawan nalêhêk, haka patagên yoy kaganawan tawgtug haka bung-oy. Itoynung yoy nabalingkêwêd ya dann, haka yo patagên ya nikakikilhung ya dann. ");
INSERT INTO sgb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ya balang miha ay makahêlêk hên pamiligtas ya daygên ni Apo Namalyari.’” ");
INSERT INTO sgb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Mal-at ya dinumani kan Juan ta êmên hila pabawtismo. Wana kanla, “Nanad kaw utan ya makamatsi. Hinoy namipamwang kamoyu hên tumakah ha parusa ya lumatêng? ");
INSERT INTO sgb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Daygên yo ya pamaptêg hên naghêhê kaw ha pamanyag yon kasalanan. Paan kaw mangihip hên mailigtas kaw ha parusa ni Apo Namalyari, gawan hi apo Abraham ay ninuno yo. Agyan hata bato, ay madyag ni Apo Namalyari hên kaapo-apoan ni apo Abraham. ");
INSERT INTO sgb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ya pamanatol ni Apo Namalyari ay nanad ha payakol ya naitag-ay hên mihay ampamotoh hên kayo. Balang kayo ya a ampanagêy hên mangangêd, ay potohên ta iulam ha apoy. Haka hikaw ay maialimbawa ha kayo ya a ampanagêy hên mangangêd.” ");
INSERT INTO sgb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Amêhên, hinabi lan kal-atan, ya wanla, “No êmbayro, ay hino ya dapat naên daygên?” ");
INSERT INTO sgb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Hinabi ni Juan, ya wana, “No main kaw loway takop, ay idin yoy miha kanan ayn. Êmbayro êt ya daygên yo ha kaganawan maêkan.” ");
INSERT INTO sgb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Agyan hilay máningil buwih ay dinumani kan Juan ta êmên hila pabawtismo. Naghabi hila kan Juan, ya wanla, “Hino ya dapat naên daygên?” ");
INSERT INTO sgb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Amêhên, hinabi na kanla, ya wana, “Paan kaw mangwa hên sobra ha an-ipahingil kamoyu hên gobyerno.” ");
INSERT INTO sgb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Main hundaloh bayro, ya nangotang, “Ay-êmên kay, hinoy dapat naên daygên?” Hinabi ni Juan kanla, “Paan kaw mangwa hên alwan kamoyu ha pamilit o ha pamara hên alwan pêtêg. Dapat mahigla kaw ha suweldo yo.” ");
INSERT INTO sgb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","An-êngganan lan tawo ya marani yay nan lumatêng ya Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala ya impangako. Kabay an-ihip-ihipên la no hi Juan ya habaytoy impangako, o no alwa. ");
INSERT INTO sgb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kabay hinabi ni Juan kanla, “Ya Mesias, ya Cristo, ya Mámiligtas, ay makapangyarihan kangko. Agyan mangokal hên hêêl pag-apin bitsih na, ay ayn akon karapatan, ta matag-ay ya tungkulan na. Hikoy ampamawtismo kamoyu ha lanêm. Noa, hiyay mamawtismo kamoyu ha Espiritu ni Apo Namalyari haka ha apoy. ");
INSERT INTO sgb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Hiyay mamipapawa hên mapanyag kangêran kanlan mapanyag karawakan hên nanad ha mihay ampamalohboh. Ta ya trigo ya binalohbohan ay ihimpan, noa, ya apa haka tatap ay ulamên ha apoy ya a angkaparê.” ");
INSERT INTO sgb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mal-at pon ya in-aral ni Juan kanlan kal-atan, ha pamipamwang na kanla ya Mangangêd ya Habi. ");
INSERT INTO sgb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Noa, hi Herodes Antipas, ya gobernador ha probinsyan Galilea, ay hinabyanan ni Juan hên mahakit, gawan bat nan pinag-ahawa hi Herodias, ta hi Herodias, ay ahawa ni Felipe, ya ali ni Herodes Antipas, haka gawan mal-at êt ya nangarawak ya pandaygên ni Herodes Antipas. ");
INSERT INTO sgb_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Napahanan êt ya nangarawak ya dyag na hên impahukul na hi Juan. ");
INSERT INTO sgb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Hên a ya pon impahukul hi Juan, hên naubuh na hilan binawtismoan ya labay hên pabawtismo, ay nagpabawtismo hi Apo Jesus etaman. Kaban ampanalangin hi Apo Jesus, hên ubat nagpabawtismo, ay nagloat ya langit, ");
INSERT INTO sgb_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","bayo inumaypa kana ya Espiritu ni Apo Namalyari hên nanad ha mihay pati-pati. Main habi ya ubat ha langit, ya wana, “Hika ya panlugurên kon Anak ya ampamahigla kangko.” ");
INSERT INTO sgb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Mag tatlumpo ya taon hi Apo Jesus hên nag-umpisa yan nanoro. Ya muwang lan tawo ay hiya ay anak ni Jose. Hi Jose ay anak ni Eli. ");
INSERT INTO sgb_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hi Eli ay anak ni Matat, hi Matat ay anak ni Levi, hi Levi ay anak ni Melqui, hi Melqui ay anak ni Janai, hi Janai ay anak ni Jose, ");
INSERT INTO sgb_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Hi Jose ay anak ni Matatias, hi Matatias ay anak ni Amos, hi Amos ay anak ni Nahum, hi Nahum ay anak ni Esli, hi Esli ay anak ni Nagai, ");
INSERT INTO sgb_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Hi Nagai ay anak ni Maat, hi Maat ay anak ni Matatias, hi Matatias ay anak ni Semei, hi Semei ay anak ni Josec, hi Josec ay anak ni Joda, ");
INSERT INTO sgb_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Hi Joda ay anak ni Joanan, hi Joanan ay anak ni Resa, hi Resa ay anak ni Zorobabel, hi Zorobabel ay anak ni Salatiel, hi Salatiel ay anak ni Neri, ");
INSERT INTO sgb_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Hi Neri ay anak ni Melqui, hi Melqui ay anak ni Adi, hi Adi ay anak ni Cosam, hi Cosam ay anak ni Elmadam, hi Elmadam ay anak ni Er, ");
INSERT INTO sgb_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Hi Er ay anak ni Josue, hi Josue ay anak ni Eliezer, hi Eliezer ay anak ni Jorim, hi Jorim ay anak ni Matat, hi Matat ay anak ni Levi, ");
INSERT INTO sgb_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Hi Levi ay anak ni Simeon, hi Simeon ay anak ni Juda, hi Juda ay anak ni Jose, hi Jose ay anak ni Jonan, hi Jonan ay anak ni Eliaquim, ");
INSERT INTO sgb_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Hi Eliaquim ay anak ni Melea, hi Melea ay anak ni Mennan, hi Mennan ay anak ni Matata, hi Matata ay anak ni Natan, hi Natan ay anak ni David, ");
INSERT INTO sgb_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Hi David ay anak ni Jesse, hi Jesse ay anak ni Obed, hi Obed ay anak ni Booz, hi Booz ay anak ni Salmon, hi Salmon ay anak ni Naason, ");
INSERT INTO sgb_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Hi Naason ay anak ni Aminadab, hi Aminadab ay anak ni Admin, hi Admin ay anak ni Arni, hi Arni ay anak ni Esrom, hi Esrom ay anak ni Farez, hi Farez ay anak ni Juda, ");
INSERT INTO sgb_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Hi Juda ay anak ni Jacob, hi Jacob ay anak ni Isaac, hi Isaac ay anak ni Abraham, hi Abraham ay anak ni Terah, hi Terah ay anak ni Nahor, ");
INSERT INTO sgb_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Hi Nahor ay anak ni Serug, hi Serug ay anak ni Reu, hi Reu ay anak ni Peleg, hi Peleg ay anak ni Eber, hi Eber ay anak ni Sala, ");
INSERT INTO sgb_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Hi Sala ay anak ni Cainan, hi Cainan ay anak ni Arfaxad, hi Arfaxad ay anak ni Shem, hi Shem ay anak ni Noe, hi Noe ay anak ni Lamec, ");
INSERT INTO sgb_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Hi Lamec ay anak ni Matusalem, hi Matusalem ay anak ni Enoc, hi Enoc ay anak ni Jared, hi Jared ay anak ni Mahalaleel, hi Mahalaleel ay anak ni Kenen, ");
INSERT INTO sgb_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Hi Kenen ay anak ni Enos, hi Enos ay anak ni Set, hi Set ay anak ni Adan, hi Adan ay anak ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Hên ubat yan nagpabawtismo hi Apo Jesus ha Ilog Jordan, ay hiyay pinaihipan hên Espiritu ni Apo Namalyari, ya hinumapat kana, hên maglaêh ya pon ha logal ya kabalah-balahan. ");
INSERT INTO sgb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Atsi ya bayro hên apatapo ya allo, hên antuksoên ni Satanas. Habaytoy apatapo ya allo, ay a ya nangan. Kabay hên nalabah ya habayto, ay angkablay yay nan lonoh. ");
INSERT INTO sgb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Hinabi ni Satanas kan Apo Jesus, ya wana, “No hika ya Anak ni Apo Namalyari, ay daygên mon puto ya hata bato.” ");
INSERT INTO sgb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Amêhên, hinabi ni Apo Jesus kana, ya wana, “Ha habi ni Apo Namalyari ay nakahulat ya êmên di, ‘Ya tawo ay ahê angkabiyay ha kaên bêngat.’” ");
INSERT INTO sgb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pangayarin habayto, ay gintan ya ni Satanas hi Apo Jesus ha bapan tag-ay ya logal, ta saguli nan impahlêk ni Satanas kana ya balang bansa ha boon luta. ");
INSERT INTO sgb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Biha hinabi na kan Apo Jesus, ya wana, “Idin ko kamo ya tungkulan haka pibandian hên habaytoy bansa. Naidin kangko ya habayto kabay maidin ko ha hinon labay kon dyanan. ");
INSERT INTO sgb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","No simbaên mo ko, ay iubuh kinan idin kamo ya habayto.” ");
INSERT INTO sgb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Noa, hinabi ni Apo Jesus, ya wana, “Hatsi ya nakahulat ha habi ni Apo Namalyari: ‘Simbaên moy Panginoon mo, hi Apo Namalyari, ta hiyan bêngat ya huyuên mo.’” ");
INSERT INTO sgb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pangayari, ay gintan ya ni Satanas hi Apo Jesus ha balayan Jerusalem ha têngêl hên Templo, haka na hinabi ni Satanas, ya wana, “No pêtêg hên hika ya Anak ni Apo Namalyari ay magnabo kan paubat di, ");
INSERT INTO sgb_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ta êmên di ya nakahulat ha habi ni Apo Namalyari, ‘Iutoh ni Apo Namalyari hilay anghel na hên mangillag kamo,’ ");
INSERT INTO sgb_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","haka ‘Halorên la ka êmên a mahakitan ya bitsih mo ha bato.’” ");
INSERT INTO sgb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Noa, hinabi ni Apo Jesus, ya wana, “Nakahulat êt ha Kahulatan ya impahulat ni Apo Namalyari, ‘Paan mon subukên ya Panginoon mo, hi Apo Namalyari.’” ");
INSERT INTO sgb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Amêhên, hên nayari nay na ni Satanas ya balang pamanukso na, ay nag-alíh yay na pon. ");
INSERT INTO sgb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Hi Apo Jesus ay nag-orong ha probinsyan Galilea ha kapangyarihan hên Espiritu ni Apo Namalyari. Ya tungkol kana ay nibahwag ha mamalibot hên habaytoy logal. ");
INSERT INTO sgb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nanoro ya ha balang sinagoga haka hiyay dinayêw hên balang miha. ");
INSERT INTO sgb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Amêhên, nag-orong ya hi Apo Jesus ha balayan Nazaret, ya pinanhumlayan na. Hinumwên ya ha sinagoga la hên nanad panay nan pandaygên no allon pamagsimba. Bayo, nirêng yan namahan habi ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ya naka-tsili-tsil ya papel ya pinanulatan hên hinabi ni Propeta Isaias ya mihay mámipamwang hên an-ipaihip kana ni Apo Namalyari, ay inggawang kana. Binuhal nay naka-tsili-tsil bayo na binaha ya nakahulat, ya wana, ");
INSERT INTO sgb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Atsi kangko ya Espiritu ni Apo Namalyari gawan hikoy pinili na hên mamitoro hên Mangangêd ya Habi na kanlan mangairap. In-utoh na ko ta êmên ko ipamwang kanlan nakahukul ya ibuhan hila, haka kanlan buwag ya makahêlêk hila, haka kanlan ampairapan ya, a hilay nan pairapan, ");
INSERT INTO sgb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","haka êmên ipamwang ya nilumatêng ya pamiligtas ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Amêhên, hên nai-tsili-tsil nay na êt ya hatoy hulat, ay in-orong na kanan ampanawop bayro ha sinagoga bayo ya nikno hên nanoro kanla. Namakahêlêk kana ya kaganawan ya atsi bayro ha sinagoga. ");
INSERT INTO sgb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Bayo hinabi na kanla, ya wana, “Amêhên kaban ampanggilam kaw kangko ay natupad ya hatoy binaha ko ubat ha Kahulatan ya impahulat ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Dinayêw ya hên balang miha ta nag-êpapah hila ha mangangêd ya habi na. Noa, ampihahabi hila ya wanla, “Daptay anak ni Jose ya kabalayan tamo ya habaytsi!” ");
INSERT INTO sgb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Kabay wani Apo Jesus kanla, “Siguradon ungkatên yo kangko ya habaytsi ya kahabian, ‘Doktor, tambalan moy sarili mo. Ya nabalitaan naên ya kapapaêpapah ya dinyag mo ha balayan Capernaum, ay daygên mo di etaman ha sarili mon logal.’” ");
INSERT INTO sgb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Bayo wanay na êt ni Apo Jesus, “Pakagilamên yo, ya mihay propeta ni Apo Namalyari, ay a ampansinên ha sarili nan balayan. ");
INSERT INTO sgb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Hên panaon ni Propeta Elias, ay ayn maêkan gawan ayn uran hên tatloy taon haka anêm ya buwan. Hên hato, ay mal-at ya babayi ya bawo di ha bansan Israel, ");
INSERT INTO sgb_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","noa, hi Propeta Elias ay a ya in-utoh ni Apo Namalyari hên manawop kanla. Hiyay in-utoh kanan mihay babayin bawo ha Sarepta ya sakop hên Sidon. ");
INSERT INTO sgb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Hên panaon ni Propeta Eliseo, ay kal-atan ya nag hakit hên ketong di ha bansan Israel, noa ya inalihan nan bêngat hakit, ay hi Naaman ya taga bansan Siria.” ");
INSERT INTO sgb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Hên nagilam lay hinabi ni Apo Jesus, ay naubuh hilan nagtulaw ya atsi bayro ha sinagoga. ");
INSERT INTO sgb_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Namakonkaynaman ay nirêng hila, ta impaplag la ya ha balayan, haka impalako la ya ha palaypay hên bêngaw ha bung-oy ya pinaypairêngan balayan la, ta itoron la ya dayi. ");
INSERT INTO sgb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Noa, nammita ya hên nagdann ha pibonakan la. ");
INSERT INTO sgb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ubat bayro, ay nilumohan ya hi Apo Jesus ha balayan Capernaum ha probinsyan Galilea. Ha allon pamagsimba, ay nanoro ya ha sinagoga la. ");
INSERT INTO sgb_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Naubuh hilan nag-êpapah ha panoro na gawan ya panoro na ay nanad panoro hên main tungkulan. ");
INSERT INTO sgb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Main lalaki bayro ha sinagoga ya hinapatan hên narawak ya a angkahêlêk. Nan-angaw ya hatoy hinumapat kanan lalaki, ya wana, ");
INSERT INTO sgb_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Jesus ya taga-Nazaret, hinoy pakiêmênan mo kannaên? Labay mo kay hên parusaan? Muwang ko no hino ka. Hika ya banal, ya ayn hinon kasalanan, ya in-utoh ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Hên nagilam ni Apo Jesus ya hinabi nan hinumapat kanan hatoy lalaki, ay hinabyanan na ya, haka na ya impaplag, ya wana, “Paan kan maglabak! Mag-alíh ka ha hinapatan mo!” Intumba ya lalaki hên hinumapat kana ha pibonakan la. Bayo nag-alíh ya, hên a na ya pinakahakitan ya lalaki. ");
INSERT INTO sgb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nag-êpapah hilay atsi bayro, ta nihahabi hila, ya wanla, “Hino kaya ya magkahabian hên hatsi? Nag tungkulan haka kapangyarihan ya pami-utoh nan paypaplag hên nangarawak ya hinumapat ha tawo, bayo ampag-alíh hila.” ");
INSERT INTO sgb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Habaytoy dinyag ni Apo Jesus ay nibahwag ha boon logal hên habayto. ");
INSERT INTO sgb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Amêhên, nag-alíh yay na hi Apo Jesus bayro ha sinagoga ta nagpakha ya ha bali lan Simon. Hên habayto ay main matag-ay ya omot ya ampo nay babayi ni Simon. Kabay pinikihabi la kan Apo Jesus ya hawpan na ya. ");
INSERT INTO sgb_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Dinanian ni Apo Jesus ya bakêt. Impaalíh nay omot na kabay tambêng yan nirêng ta namakan ya kanlan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Amêhên, hên ampinaboy nay allo, ay gintan la kan Apo Jesus ya nipaghakit. Hino-hino kay na hên ya hakit la. Impalunto nay gamêt na kanlan balang miha kanla ta namaalíh yan hakit la. ");
INSERT INTO sgb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Haka ya nangarawak ya a angkahêlêk ya hinumapat ha kal-atan ay ampag-alíh kanla. Ampan-angaw hilay habaytoy nangarawak ya espiritu, ya wanla, “Hika ya Anak ni Apo Namalyari.” Noa, binawal hila ni Apo Jesus hên maghabi gawan muwang la, ya hiyay Mesias, ya Cristo, ya pinili ni Apo Namalyari hên mag-in habaytoy Mámiligtas ya impangako na. ");
INSERT INTO sgb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Hên maranon, ay nammita ya hi Apo Jesus ha mihay logal ya marayo ha tawo ta êmên ya manalangin. Kabay tinapol la yan kal-atan. Hên natapol la ya, ay pinikihabian la ya hên a ya pon dayi mita. ");
INSERT INTO sgb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Noa, hinabi kanla ni Apo Jesus, ya wana, “Ya Mangêd ya Habi tungkol ha pamanlokop ni Apo Namalyari, ay kailangan kon itoro ha kaatag ya logal. Kabay in-utoh na ko di ha luta.” ");
INSERT INTO sgb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Bayo inhundo nay panoro na ha mal-at ya sinagoga lan Israelita. ");
INSERT INTO sgb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Minghan hên atsi ya hi Apo Jesus hên ampanoro ha laylay hên Dagat-dagatan hên Genesaret, ay pinilolopungan la ya hên kal-atan ya labay manggilam hên habi ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Amêhên, nakahêlêk yan loway bangka ya narani ha laylay, ya ayn tawo gawan hilay magdadakêp kênan lanêm, ay atsi ha lanêm hên ampanguyah hên lambat la. ");
INSERT INTO sgb_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Hinumakay ya hi Apo Jesus ha bangka ni Simon, haka ya nakihabi kan Simon ya ipabita ya bangka hên pêrad ha laylay. Bayro yan nikno hên nanoro kanlan kal-atan. ");
INSERT INTO sgb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Hên nayari yay nan nanoro ay hinabi na kan Simon, ya wana, “Ipalako yo ya hata bangka ha malalê bayo yo iaypa ya lambat ta êmên kaw makakwa.” ");
INSERT INTO sgb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Kabay wani Simon kana, “Mánoro, mamapayabi kay hên nagpagal hên an-iaypa ya lambat, noa, ayn kay hên nakwa. Êmbayro man, gawan ha hinabi mo, ay iaypa koy lambat.” ");
INSERT INTO sgb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Hên nadyag la ya habayto, ay pêrad tanan nagihi ya habaytoy lambat gawan kal-atan ya nakwa la. ");
INSERT INTO sgb_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kabay siningyalan lay kalamo la ha mihay bangka, ta pahawop hila kanla. Dinumani hila bayo la pinno ya loway bangka angga ha mamêrad hila tanan nilêmêh. ");
INSERT INTO sgb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Hên nakit ni Simon Pedro ya habayto ya nalyari, ay nandoko yan nakadêngdêng ha arapan ni Apo Jesus ta wana, “Panginoon, pakarayo ka kangko ta makasalanan ako.” ");
INSERT INTO sgb_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Hinabi nay habayto gawan nag-êpapah ya haka hilay kalamo na gawan mal-at ya nakwa la. ");
INSERT INTO sgb_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nag-êpapah etaman ya maának ni Zebedeo ya hi Santiago haka hi Juan, ya kala-kalamo ni Simon. Amêhên, hinabi ni Apo Jesus kan Simon, ya wana, “Paan kan malimo. Paubat amêhên, ay daygên katan mámipakarani hên tawo kangko, ta êmên hila maniwala.” ");
INSERT INTO sgb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Hên ginuloy lay nay bangka la ha laylay lanêm, ay in-ubuh lan imbalag ya habayto, ta nakihonol hila kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Minghan hên atsi ya hi Apo Jesus ha mihay balayan, ay dinumani kana ya mihay lalaki ya nag hakit ketong. Nandoko ya ha arapan na, ta wanan nakiingalo, “Panginoon, no kalabayan mo, ay paalihên moy hakit ko, êmên luminis ya lawini ko.” ");
INSERT INTO sgb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Impalunto ni Apo Jesus ya gamêt na ha nag hakit hên ketong, bayo wana, “Labay kon paalihên ya hakit mo. Luminis ka!” Tambêng naalíh ya hakit na. ");
INSERT INTO sgb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Bayo in-utoh na ya ni Apo Jesus hên main pamamawal, ya wana, “Paan mo pon ipamwang ya hatsi ha hinoman. Pakha ka ha pari ta ipahlêk mo kana ya ayn kay nan ketong. Mantan kan maiparaya ha pamanhumonol mo ha utoh ni apo Moises, êmên paptêgan kanlan kaatag ya malinis kay na.” ");
INSERT INTO sgb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Noa, lalon nibahwag ya tungkol kan Apo Jesus, kabay kal-atan ay nangamat kana hên manggilam panoro na. Haka impaalíh la êt ya hakit la kana. ");
INSERT INTO sgb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Noa, hi Apo Jesus ay panay hên nagdayo ha kal-atan hên nanalangin. ");
INSERT INTO sgb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Amêhên, mihay allo, hên ampanoro ya hi Apo Jesus, ay main bayron Pariseo haka mánoron Kautuhan ni apo Moises. Main kanla ya taga-balayan Jerusalem, haka main ubat ha balayan hên probinsyan Galilea haka probinsyan Judea. Atsi kan Apo Jesus ya kapangyarihan ni Apo Namalyari hên mamaalíh hên hakit. ");
INSERT INTO sgb_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Main nilumatêng ya ungnoy lalaki ya ampantan hên mihay lumpo ya atsi ha langkayan. Iarap la ya dayi kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Noa, gawan ha kal-atan, ay ayn hilan madanan. Kabay nunik hila ha bubungan ta nilubtan lay atêp ha dapit ugto ni Apo Jesus. In-antotoh lay lumpo ha pibonakan lan kal-atan ha arapan ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Hên nahêlêk ni Apo Jesus ya paniwala la kana, ay hinabi na kanan lumpo, “Pakhawên moy nakêm mo, ta pinatawad ya kasalanan mo.” ");
INSERT INTO sgb_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Amêhên, ampangihip hilay Pariseo haka mánoron Kautuhan ni apo Moises hên êmên di, “Hinoy hatsi ya an-ipantag nay sarili na kan Apo Namalyari hên ampamatawad hên kasalanan? Yarin a nan ammusmusên hi Apo Namalyari ya tawo yan bêngat! Mimiha na ni Apo Namalyari ya makapatawad hên kasalanan.” ");
INSERT INTO sgb_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Muwang ni Apo Jesus ya laman ihip la. Kabay wana kanla, “Pata ampangihip kaw hên êmbayro? ");
INSERT INTO sgb_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Hino awud ya maparah hên habiên kanan mihay a ampakabita, no wangko, ‘Napatawad kay na ha kasalanan mo,’ o no wangko, ‘Hali, mirêng ka ta mita kay na.’ ");
INSERT INTO sgb_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Noa, êmên yo mamwangan ya hiko, ya Taga-Langit, ya In-anak Tawo, ay main tungkulan di ha luta hên mamatawad kasalanan, ay habiên ko kanan lumpo, ‘Mirêng ka. Hapwatên moy langkayan mo ta muli kay na.’” ");
INSERT INTO sgb_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tambêng yan nirêng ha arapan la ya habaytoy lumpo. Hinapwat nay langkayan na, ta nuli ya hên ampuriên na hi Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Naubuh hilan nag-êpapah ya atsi bayro. Pinuri la hi Apo Namalyari hên main lamoy êpapah, ya wanla, “Amêhên allo ay nakahêlêk kitamo hên kapapaêpapah.” ");
INSERT INTO sgb_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pangayari hên habayto, ay nammita yay na hi Apo Jesus, haka nakahêlêk yan mihay máningil buwih ya nag langan Levi, ya ampikno ha paningilan na. Hinabi ni Apo Jesus kana, ya wana, “Kihonol ka kangko.” ");
INSERT INTO sgb_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nirêng ya etaman hi Levi, haka in-ubuh nan imbalag ya obra na, ta nakihonol ya kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Amêhên, pinayhanda ni Levi hilan Apo Jesus hên kal-atan maêkan. Kal-atan máningil buwih ya kapareho ni Levi, haka kaatag êt, ay kalamo la hên nangan. ");
INSERT INTO sgb_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Noa, hilay Pariseo haka hilay kalamo lay mánoron Kautuhan ni apo Moises ay nagmulongan kanlan tagahonol ni Apo Jesus, ya wanla, “Pata ampakiaêm kaw hên kalamo lan máningil buwih haka kaatag êt ya makasalanan?” ");
INSERT INTO sgb_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Hên nagilam nay hinabi la, ay nangalimbawa hi Apo Jesus, ya wana, “Hilay main hakit, ay ampangailangan doktor, alwan hilay ayn hakit. ");
INSERT INTO sgb_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Êmbayro êt, atsi ko di ha luta ta êmên ko mahagyat hilay ampangamin makasalanan hila, hên maghêhê hên manalibokot ha pamanyag lan kasalanan. Noa, hilay ampaghabin ayn hilan kasalanan, ay a ko hawpan.” ");
INSERT INTO sgb_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Main ungno bayro ya naghabi kan Apo Jesus, ya wanla, “Hilay tagahonol ni Juan haka hilay tagahonol lan Pariseo ay panay hên ampagtêêh hên a mangan ta êmên a maabala ya panalangin la. Pata alwan êmbayro ya andaygên lan tagahonol mo?” ");
INSERT INTO sgb_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Kabay in-alimbawa ni Apo Jesus ya sarili na ha lalaki ya an-ikasal, ya wana, “Êndat yon mabawal yon mangan ya bisita ha kasálan no kalamo lay lalaki ya an-ikasal? A yo hila mabawal. ");
INSERT INTO sgb_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Lumatêng ya allo, ya idayo lay lalaki ya an-ikasal, ay bayro hilay nan a mangan.” ");
INSERT INTO sgb_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Amêhên, intoro ni Apo Jesus ya a mailamo ya toro na, ha toro lan ninuno la, ya wana, “Ayn mangguntsing hên bayoy baro ta itagpi ha gihi hên manan takop. No alimbawa ta daygên nay habayto, ay mahira ya bayoy baro, haka habaytoy bayoy intagpi, ay a mipareho ha manan takop. ");
INSERT INTO sgb_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ayn mamitugtug hên bayon alak, ha ubatan hên manan alak, gawan lumtoh ya pamyanan, haka mibullog ya alak. ");
INSERT INTO sgb_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ya bayoy alak, ay dapat itugtug ha bayoy pamyanan. ");
INSERT INTO sgb_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ayn labay minêm hên bayoy alak no nakainêm yay na hên mana ta habiên na, ya naayang ya mana.” ");
INSERT INTO sgb_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Mihay allon pamagsimba, hên nipadann hilan Apo Jesus ha nag trigo ya narani ha dann, ay nantê hilay tagahonol na hên pêrad. Niyêhê la ya hata trigo ta nilêêm la ha pammita la. ");
INSERT INTO sgb_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Noa, nag Pariseo bayro ya naghabi kan Apo Jesus, ya wanla, “Pata nantê kaw ha allon pamagsimba, bawal man ya habayto ha Kautuhan tamo?” ");
INSERT INTO sgb_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Wana etaman ni Apo Jesus, “Kayno a yo pon nabaha ya dinyag ni Arin David hên hiya haka hilay kalamo na ay angkablay hên lonoh. ");
INSERT INTO sgb_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Hinumwên ya ha bali ni Apo Namalyari, ta nangwa yan puto ya imparaêp kan Apo Namalyari ya pangkaên lan bat hên pari. Bawal man ha Kautuhan ni apo Moises hên mangan hên habayto, ay nangan ya, bayo nam-i ya êt kanlan kalamo na.” ");
INSERT INTO sgb_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Inhundo ni Apo Jesus ya pamaghabi na kanlan Pariseo, ya wana, “Hiko ya Taga-Langit, ya In-anak Tawo, ay nag tungkulan hên maghabi no hinoy malyarin daygên ha allon pamagsimba.” ");
INSERT INTO sgb_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ha mihay na êt ya allon pamagsimba la, hên hinumwên ya ha sinagoga ta manoro, ay nag lalaki bayro ya natsi ya panabtab gamêt. ");
INSERT INTO sgb_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Hilay Pariseo haka mánoron Kautuhan ni apo Moises, ay ampangimaton kan Apo Jesus, no mamaalíh yan hakit ha allon pamagsimba, ta êmên la yan bad-an hên ampanyag yan bawal ha allon pamagsimba. ");
INSERT INTO sgb_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Agyan muwang na ya laman ihip la, ay wani Apo Jesus kanan lalaki ya natsi ya gamêt, “Mirêng ka di ha arapan lan kal-atan.” Dinyag nay kalabayan ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Bayo kinotang ni Apo Jesus, hilay Pariseo haka mánoron Kautuhan ni apo Moises, ya wana, “Hinoy nakahulat ha Kautuhan ni apo Moises ya tungkol ha dapat daygên ha allon pamagsimba? Manyag hên kangêran o manyag karawakan? Mamiligtas o mamatsi?” Noa, ayn miha man ya naghabi. ");
INSERT INTO sgb_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Hinlêk na hilangan ni Apo Jesus. Bayo wana kanan lalaki ya natsi ya gamêt, “Ipaktang moy gamêt mo.” Hên impaktang na, ay naalíh ya hakit ha gamêt na. ");
INSERT INTO sgb_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Noa, hadyay huluk lan Pariseo, kabay pinipupulungan lay na hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Hên habayto, ay nilumakat ya hi Apo Jesus ha mihay tawgtug, ta êmên ya manalangin. Namawatah yan nanalangin kan Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Hên alloy na, ay binaêg na hilay tagahonol na hên dumani kana, ta mamili ya hên labinlowa kanla ya pinata-ngalanan nan apostol. ");
INSERT INTO sgb_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Hila ay hi Simon, ya pinata-ngalanan nan Pedro, haka hi Andres ya kapotoh pohêl ni Pedro. Pinili na êt hi Santiago, hi Juan, hi Felipe, hi Bartolome, ");
INSERT INTO sgb_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","hi Mateo, hi Tomas, haka hi Santiago ya anak ni Alfeo. Pinili na êt hi Simon ya Makabayan. ");
INSERT INTO sgb_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Pinili na êt hi Judas ya anak ni Santiago haka hi Judas Iscariote ya nay-upit kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Amêhên, nilumohan hilan Apo Jesus ha napatal ya logal. Kalamo la bayro ya kal-atan kanlan antoroan na haka kal-atan ya ubat ha probinsyan Judea, balayan Jerusalem, haka ha dani hên Tiro haka Sidon. ");
INSERT INTO sgb_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Habaytoy kal-atan ay labay manggilam toro na, haka magpaalíh hên hakit la. Impaalíh na etaman hilay narawak ya a angkahêlêk, ya ampamairap kanlan kaatag. ");
INSERT INTO sgb_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Gap-an la ya dayi hên kal-atan hi Apo Jesus, gawan atsi kana ya kapangyarihan ni Apo Namalyari hên mamaalíh hên kaganawan hakit la. ");
INSERT INTO sgb_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Hinlêk ni Apo Jesus ya tagahonol na, bayo hinabi na, ya wana, “Iningalwan kaw ya mangairap, gawan hikaw ay milamo ha pamanlokop ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Iningalwan kaw ya angkablay amêhên, ta mabhoy kaw. Iningalwan kaw ya ampanangih amêhên, gawan mangkaili kaw. ");
INSERT INTO sgb_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Iningalwan kaw no gawan bêngat ha paniwala yo kangko ya Taga-Langit, ya In-anak Tawo, ay kahêmêkan la kaw, ipaplag la kaw, musmusên la kaw, haka hiraên la kaw. ");
INSERT INTO sgb_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","No malyari ya habayto, ay dapat humigla kaw, haka kaw mag-ukdo gawan kahiglaan yo, ta mahlay ya primyo ya matanggap yo ha langit. Ta êmbayro êt ya pamairap lan ninuno la kanlan mámipamwang hên an-ipaihip kanla ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Noa, kaingalo kaw ya mabandi ta nilumatêng kamoyu ya katsighaw yo! Ayn kaw na hên maêngganan! ");
INSERT INTO sgb_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kaingalo kaw ya nabhoy amêhên ta hikaw ay mablay hên lonoh. Kaingalo kaw ya ampangkaili amêhên ta hikaw ay manyêngên. ");
INSERT INTO sgb_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kaingalo kaw no andayêwên kaw hên kaganawan ta êmbayro êt ya dinyag lan ninuno la kanlan nagbabaran mámipamwang hên an-ipaihip kanla ni Apo Namalyari hên hato.” ");
INSERT INTO sgb_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Inhundo ni Apo Jesus ya panoro na, ya wana, “Panhabiên ko kamoyun atsi di hên ampanggilam, ya dapat yon lugurên ya kapatsi yo. Daygên yoy kangêran kanlan anhumêmêk kamoyu. ");
INSERT INTO sgb_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ihalangin yo hilay ampanuboy kamoyu, haka hilay ampamairap kamoyu. ");
INSERT INTO sgb_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","No main manampaling kapakan pingi yo ay ipatampaling yo êt kanla ya kapaka. No main mangwan sambra yo, ay idin yo kanla etaman ya kamiseta yo. ");
INSERT INTO sgb_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mam-i kaw kanlan kaganawan ampakikwa kamoyu, haka no main mangwan pibandian yo, ay paulayan yo hila. ");
INSERT INTO sgb_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ya kangêran ya labay yo hên daygên la kamoyu hên kaatag, ay êmbayro êt ya daygên yo kanla. ");
INSERT INTO sgb_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“No anlugurên yon bêngat hilay ampanlugud kamoyu, ay a na kaw dayêwên ni Apo Namalyari. Ta hila man ya makasalanan ay ampanlugud kanlan ampanlugud kanla. ");
INSERT INTO sgb_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","No ampanyag kaw hên kangêran kanlan bêngat hên ampanyag kangêran kamoyu, ay a na kaw dayêwên ni Apo Namalyari. Hila man ya makasalanan ay ampanyag kangêran kanlan ampanyag kangêran kanla. ");
INSERT INTO sgb_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","No mamaram kaw bêngat kanlan ampakapiorong hên indam la kamoyu, ay a na kaw dayêwên ni Apo Namalyari. Hila man ya makasalanan ay ampamaram kanlan kapareho la, ya ampakapiorong hên indam kanla. ");
INSERT INTO sgb_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Noa, dapat yon lugurên ya kapatsi yo. Manyag kaw hên kangêran. Mamaram kaw kanlan a makabayad hên indam la kamoyu. No daygên yoy habayto ay dyanan na kaw ni Apo Namalyari, ya pinakamakapangyarihan, hên mahlay ya primyo, haka hikaw ay mamwangan maának na gawan hiya man ay an-ingalwan na hilay narawak ya ayn utang nakêm. ");
INSERT INTO sgb_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Dapat kaw mag-in maingaloên hên nanad kan Apo Namalyari ya Tatang tamo ya maingaloên.” ");
INSERT INTO sgb_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Paan kaw mihahatol ta êmên a kaw hatolan ni Apo Namalyari. Paan yon parusaan ya kaatag, ta êmên a na kaw parusaan ni Apo Namalyari. Mamatawad kaw ta patawarên kaw êt ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mam-i kaw ha kaatag ta dyanan na kaw ni Apo Namalyari hên mangêd ya takal ya imbinhêk, intêtê, haka nakatalibohboh. Ta no ay-êmên ya pamaytakal yo ha kaatag, ay êmbayro êt ya takal ya idin kamoyu ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Hên nahabi nay na ya habayto ni Apo Jesus ay intoro nay na êt ya habaytsi ya kahabian kanla, ya wana, “Ya mihay buwag ay a makaakay hên kapareho nan buwag ta pareho hilan minabo ha malalê ya lubot. ");
INSERT INTO sgb_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ayn mag-aral ya magaling ha ampanoro kana. Noa, hilay natoroan hên mangêd ay mag-in nanad ha ampanoro kanla. ");
INSERT INTO sgb_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Panhêlkên yoy alwan nabyat ya kasalanan ya nanad poling ha mata hên kaatag, noa, a yo ampansinên ya nabyat ya kasalanan yo ya nanad batang ya atsi ha sarili yon mata. ");
INSERT INTO sgb_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ay-êmên yon mahabi ha kapareho yo, ‘Patêl, paulayan mo kon alihên ya poling ha mata mo,’ no hikaw êt, ay a yo angkahêlêk ya nanad batang ya atsi ha mata yo. Ampagbabara kaw! Unaên yon alihên ya nanad batang ya atsi ha mata yo, bayo makahêlêk kaw hên mangêd, ta êmên yo maalíh ya nanad poling ha mata hên kaatag.” ");
INSERT INTO sgb_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Hilay mangêd ya kayo, ay a ampanagêy hên nangarawak. Ayn êt kayo ya narawak ya ampanagêy hên mangangêd. ");
INSERT INTO sgb_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ta hilay kayo ay angkabalayan ha tagêy la. A ya managêy hên igos ya korêrêng-êy. A etaman managêy hên ubas ya tanyuong. ");
INSERT INTO sgb_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Hilay mangêd, ay mapanyag hên kangêran, gawan mangêd ya nakêm la. Hilay narawak, ay mapanyag hên karawakan, gawan narawak ya nakêm la. Ta ya laman nakêm ay an-umawah ha bêbêy.” ");
INSERT INTO sgb_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Pambaêgên yo ko hên ‘Panginoon, Panginoon,’ noa, a yo andaygên ya panhabiên ko. ");
INSERT INTO sgb_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ipahlêk ko kamoyu no nanad hino hilay andumani kangko hên manggilam habi ko, haka anhumonol ha nalêngê la. ");
INSERT INTO sgb_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Hila ay nanad ha mihay lalaki ya nanyag bali. Nangali yan malalê angga ha nidaoh ha dapah, ta bayro nan impairêng ya bali na. Hên nanlanab, ay nadanan yan maawêh ya lanêm, noa, a ya nayêgê ya bali na gawan mangêd ya pangadyag na. ");
INSERT INTO sgb_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Noa, ya ampakagilam hên habi ko, bayo a manyag hên nagilam na, ay nanad yan lalaki ya nanyag bali ya alwan napah-êy gawan a na impakakali. Kabay hên nadanan yan maawêh ya lanab, ay tambêng yan nigêyma. Nangaagwat ya hatoy boon bali.” ");
INSERT INTO sgb_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Hên nayari nay na ni Apo Jesus ya panoro na, ay nammita yay na ha balayan Capernaum. ");
INSERT INTO sgb_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Atsi bayro ya mihay kapitan hên hundaloh ya taga-Roma. Main ipoh ya hata kapitan ya anlugurên na. Main hakit ya hata ipoh haka angkaboytoy inanawa na. ");
INSERT INTO sgb_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Hên namwangan hên hata kapitan ya tungkol kan Apo Jesus, ay impaalap na ya kanlan toa lan Israelita ya nag tungkulan hên pakihabian la hi Apo Jesus hên mamaalíh hakit hên ipoh na. ");
INSERT INTO sgb_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Hên nilumatêng hilay na kan Apo Jesus ay pinakihabian la yan mangêd hên daygên na dayi ya kalabayan hên kapitan, ta agyan alwa yan Israelita, ay mangêd yan tawo. ");
INSERT INTO sgb_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Hinabi la, “Anlugurên na kitamo ya Israelita, ta hiyay namipairêng sinagoga tamo.” ");
INSERT INTO sgb_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kabay nakihonol ya hi Apo Jesus kanla. Amêhên, hên narani hilan Apo Jesus, ha bali hên kapitan, ay in-utoh nay na êt hên hata kapitan ya ungnoy kaluguran na hên manupa kanlan Apo Jesus. Hinabi la, ya wanla, “Panginoon, paan kay na kano hên paabala hên humwên ha bali na ta angkarêng-êy ya kamo. ");
INSERT INTO sgb_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kabay a ya kano hên umarap kamo, noa, iutoh mo tana kano, ay maalíh ya hakit hên ipoh na. ");
INSERT INTO sgb_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Hiya man kano, ay atsi ha aypa hên kapangyarihan hên kaatag, bayo nag hundaloh ha aypan kapangyarihan na. Ya kaganawan utoh na ay daygên la. No habiên na kanan miha, ‘Mita ka,’ ay mita yay na. No habiên na kanan kaatag, ‘Paidani ka di,’ ay dumani ya. No habiên na kanan ipoh na, ‘Daygên moy hatsi,’ ay daygên na.” ");
INSERT INTO sgb_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Hên nagilam nay habayto ni Apo Jesus ay nag-êpapah ya. Inarap nay kal-atan ya ampanhumonol kana ta hinabi na, “Pakagilamên yo, ayn akon nahêlêk ya miha man ya Israelita, ya êmbayro ya nakataniêh ya paniwala.” ");
INSERT INTO sgb_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Hên nag-orong hilay nay in-utoh hên kapitan, ay ayn nanan hakit ya ipoh. ");
INSERT INTO sgb_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","A nabuyot, ay nammita hi Apo Jesus ha balayan ya ambaêgên Nain. Kalamo na hilay tagahonol na, haka kal-atan ya kaatag. ");
INSERT INTO sgb_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Hên marani yay na bayro ha pahowên ha balayan, ay nakatupa hila hên kal-atan ya ampammitan mamilbêng, ya kalamo nan indo nan natsi. Ya natsi ay mihay lalaki, ya kamiha-mihaan ya anak hên habaytoy babayi ya bawo. ");
INSERT INTO sgb_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Hên nahêlêk ni Apo Jesus ya habaytoy indo hên natsi ay naingalwan na ya, kabay hinabi na, ya wana, “Paan kan manangih.” ");
INSERT INTO sgb_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Amêhên, dinumani ya hi Apo Jesus ha bangkay hên anak nan babayi ta tinalan nay langkayan. Kabay tinunggên hilay mamalatay hên natsi. Hinabi ni Apo Jesus kanan natsi, ya wana, “Miyawhay, mimata ka.” ");
INSERT INTO sgb_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nikno ya hata miyawhay bayo naghabi ya. Amêhên, hinabi ni Apo Jesus kanan indo na, ya wana, “Hatsi ya anak mo, ya nabiyay oman.” ");
INSERT INTO sgb_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Naubuh hilan nipag-êpapah. Pinuri la hi Apo Namalyari, ya wanla, “Main makapangyarihan ya propeta ya nilumtaw kantamo. Hiniraw ni Apo Namalyari hikitamoy Israelita.” ");
INSERT INTO sgb_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Habaytoy tungkol kan Apo Jesus ay nibahwag ha ayri man ya logal ha probinsyan Judea haka ha mamalibot hên Judea. ");
INSERT INTO sgb_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Impamwang kan Juan Bautista ya balang habaytoy dinyag ni Apo Jesus hên tagahonol ni Juan. ");
INSERT INTO sgb_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","In-utoh ni Juan ya lowa kanlan tagahonol na, kan Apo Jesus hên mangotáng kana, no hiya ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala, o no mangênggan hila pon hên kaatag. ");
INSERT INTO sgb_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Hên nilumatêng hila kan Apo Jesus, ay hinabi la, “In-utoh kay ni Juan Bautista, ta labay nan mamwangan no hika ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala o no mangênggan kay pon hên kaatag.” ");
INSERT INTO sgb_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kanan habayto ay mal-at ya inalihan ni Apo Jesus hên hinon hakit, haka nangarawak ya a angkahêlêk. Mal-at êt ya buwag ya pinamukat na. ");
INSERT INTO sgb_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Amêhên, hinabi na kanla, ya wana, “Mag-orong kaw kan Juan ta ipamwang yo kana ya nahêlêk yo haka nagilam yo, ya ampakahêlêk hilay nay buwag, ampakabita hilay nay lumpo, angkaalíh ya hakit lan nag ketong, ampakagilam hilay nay têkkên, ampangoman mabiyay hilay natsi, haka ya Mangêd ya Habi ni Apo Namalyari ay an-ipamwang kanlan mairap. ");
INSERT INTO sgb_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Iningalwan hilay a ampag-alangan ha paniwala la kangko.” ");
INSERT INTO sgb_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Hên nakabitay nay in-utoh ni Juan, ay namipamwang hi Apo Jesus hên tungkol kan Juan kanlan kal-atan, ya wana, “Hinoy nilako yo ha logal ya kabalah-balahan? Êndat yo no ya ihip ni Juan ay nanad tsimbo ya mantêwêg ya angkadanan angin? ");
INSERT INTO sgb_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Hino awud ya nilako yo? Yarin nilako yo ya mihay nakatakop hên mangahampat! Alwa. Hilay nakatakop hên mangahampat, haka ampatsighaw, ay mahêlêk ha balin ari. ");
INSERT INTO sgb_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Hino awud ya nilako yo? Ya mihay propeta? Awo. Pakagilamên yo! Hiyay mihay propeta ya ayn kapantag. ");
INSERT INTO sgb_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Gawan tungkol kan Juan Bautista ya hata nakahulat di ha habi ni Apo Namalyari, ya wana, ‘Mangiutoh ako hên muna kamo, ya mangil-an hên danan mo.’ ");
INSERT INTO sgb_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Anhabiên ko kamoyu, ya ha kaganawan tawo, ayn matag-ay kan Juan Bautista. Êmbayro man, ya pinakamaaypa ya nakapakilamo ha pamanlokop ni Apo Namalyari, ay matag-ay kan Juan.” ");
INSERT INTO sgb_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ginilam lan kal-atan kalamo lan máningil buwih ya hinabi na, haka hinumonol hilangan ha makatoynungan ya Kautuhan ni Apo Namalyari gawan nagpabawtismo hila kan Juan. ");
INSERT INTO sgb_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Noa, in-ara lan Pariseo haka hilay mánoron Kautuhan ni apo Moises ya kalabayan ni Apo Namalyari ha biyay la, gawan a hila nagpabawtismo kan Juan. ");
INSERT INTO sgb_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Hinabi nay na êt ni Apo Jesus, ya wana, “Hino awud ya pangiparisan ko kanlan tawo amêhên? Nanad hino hila kaya? ");
INSERT INTO sgb_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nanad hilan anak ya ampipammikno ha pangalindagan hên ampibabaêg, ya wanla, ‘Nanigtsig kay, noa, a kaw tsimmalêk. Nanyêngên kay, noa, a kaw nakiyêngên.’ ");
INSERT INTO sgb_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ta nilumatêng hi Juan Bautista hên panay hên ampagtêêh hên a ampangan ta êmên a maabala ya panalangin na, haka a ya ampinêm hên alak, noa gawan habayto ay anhabiên yo, ya hinapatan yan narawak ya a angkahêlêk. ");
INSERT INTO sgb_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Hiko etaman, ya Taga-Langit, ya In-anak Tawo, ay nilumatêng di hên ampakiaêm haka ampinêm hên kalamo yo, noa gawan habayto, anhabiên yo ya hiko kano ay mahiba, mamminêm hên alak haka kaluguran lan máningil buwih haka kaatag ya mapanyag kasalanan. ");
INSERT INTO sgb_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Êmbayro man, ay mapaptêgan ya pêtêg ya toro naên ni Juan Bautista, gawan habaytoy mahêlêk ha pamimiyay lan anhumonol ha toro naên.” ");
INSERT INTO sgb_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Amêhên, main mihay Pariseo ya nag langan Simon ya nanagyat kan Apo Jesus hên mangan. Kabay hinumwên ya ha bali na ta nangan. ");
INSERT INTO sgb_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ha balayan ya habayto, ay nag babayi ya muwang lan kal-atan ya makasalanan ya. Hên namwangan nan babayi ya ampangan ya hi Apo Jesus ha bali nan Pariseo, ay pinantan na yan makamal ya pabango ya atsi ha pamyanan ya dyag ha alabastro. ");
INSERT INTO sgb_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Dinumani ya ha bokot ni Apo Jesus, ha dapit bitsih na hên ampanangih. Nabahá ya bitsih ni Apo Jesus hên luwa na kabay pinunihan nan habot na, haka na inaro ya bitsih ni Apo Jesus bayo tinugtugan na hên hatoy pabango. ");
INSERT INTO sgb_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Hên nahêlêk nan habaytoy Pariseo ya nanagyat kan Apo Jesus ya dinyag nan babayi ay nangihip yan êmên di, “No pêtêg yan propeta ni Apo Namalyari, ay muwang na dayi ya makasalanan ya hata ampanggapa kana haka bawalên na ya dayi.” ");
INSERT INTO sgb_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Muwang ni Apo Jesus ya laman ihip nan hata Pariseo, kabay wana, “Simon, main akon habiên kamo.” Amêhên, wani Simon, ya wana, “Hinoy habayto?” ");
INSERT INTO sgb_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Hinabi ni Apo Jesus, ya wana, “Main loway tawo ya nangútang kanan mihay mámautang pera. Ya miha ay nangútang hên 500 bayo ya miha ay nangútang hên 50. ");
INSERT INTO sgb_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Hên a hila makabayad, ay naingalwan na hila, kabay a na hilay na pinabayad hên utang la. Nanad hilay nan pinatawad. Amêhên, hino kanlan lowa ya mantêg manlugud kanan mámautang pera?” ");
INSERT INTO sgb_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Amêhên, hinabi ni Simon, “Kayno habaytoy nangútang hên mal-at.” Hinabi ni Apo Jesus, “Awo, hukad ya hinabi mo.” ");
INSERT INTO sgb_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Bayo, pinalingayan nay babayi haka na hinabi kan Simon, ya wana, “Angkahêlêk moy andaygên hên hata babayi? Hên hinumwên ako ha bali mo ay a mo ko dinyanan lanêm hên panguyah hên bitsih ko. Noa, hata babayi, ay luwa na ya pinanguyah nan bitsih ko bayo pinunihan na hên habot na. ");
INSERT INTO sgb_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","A mo ko inaro, noa, hiya, ay a na tinêgnan hên inaro ya bitsih ko paubat hên hinumwên ako. ");
INSERT INTO sgb_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","A mo dinyanan laro ya ulo ko, noa, hata babayi, ay bitsih koy tinugtugan nan pabango. ");
INSERT INTO sgb_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kabay anhabiên ko kamo ya hadyay lugud na ay pamaptêg ya napatawad ya kal-atan kasalanan na. Hinoman ya pinatawad bêngat hên pêrad ay manlugud bêngat hên pêrad.” ");
INSERT INTO sgb_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Amêhên, wani Apo Jesus kanan babayi, “Pinatawad ya kasalanan mo.” ");
INSERT INTO sgb_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Hilay kaatag ya kalamo lan ampangan bayro ay naghabi ha sarili la, ya wanla, “Hinoy hatsi ya ampamatawad kasalanan?” ");
INSERT INTO sgb_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Noa, hinabi ni Apo Jesus kanan babayi, ya wana, “Inligtas ka ha parusa hên kasalanan mo gawan paniwala mo kangko. Mag-orong kay na, hên mapatêkbêk ya nakêm.” ");
INSERT INTO sgb_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pangayari, ay nanoro yay na hi Apo Jesus ha mal-at ya balayan haka baryo. Impamwang nay Mangangêd ya Habi ya tungkol ha pamanlokop ni Apo Namalyari. Kalamo na hilay labinloway tagahonol na. ");
INSERT INTO sgb_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kalamo na êt ya ungnoy babayi ya inalihan na hên hakit haka ya nangarawak ya a angkahêlêk ya hinumapat kanla. Ya miha kanlan hatoy babayi ay hi Maria, ya ambaêgên Magdalena, ya inalihan hên pitoy narawak ya a angkahêlêk. ");
INSERT INTO sgb_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ya miha pon kanla ay hi Juana ya ahawa ni Cusa, ya mihay manungkulan ha sakop ni Herodes. Kalamo la êt hi Susana haka mal-at êt ya kaatag. Ginamit lan habaytoy babayi ya sarili lan bandi ya inhaliw lan kaên lan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Hên napi-tsi-tsipon ya kal-atan ya ubat ha ay-irin balayan, ay intoro na kanla ni Apo Jesus ya hata alimbawa, ya wana, ");
INSERT INTO sgb_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Main mihay lalaki ya namihabwag hên bini. Ha pamihabwag nan bini ay main bini ya natata ha dann. Habaytoy natorakan bayo tinuktuk hên manok. ");
INSERT INTO sgb_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ya kaatag ay natata ha mabato ha mababo ya luta. Tinumubo ya, noa, nayanto, gawan namala ya luta bayro. ");
INSERT INTO sgb_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ya kaatag ay natata ha kadiwian. Tinumubo ya bini, noa, tinumêytêy, gawan diwi. ");
INSERT INTO sgb_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ya kaatag ay natata ha mataba ya luta. Tinumubo ya habaytoy bini haka naubuh hên nanagêy hên manimagatoh ya lahí.” Hên nahabi nay na ya habayto ni Apo Jesus ay hinabi nay na êt hên in-ikhaw, ya wana, “Pakaihipên yoy nagilam yo!” ");
INSERT INTO sgb_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Hên labay lan mamwangan hên labinloway tagahonol ni Apo Jesus no hinoy labay habiên hên alimbawa ya tungkol ha bini, ");
INSERT INTO sgb_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ay hinabi ni Apo Jesus, “Hikaw bat ya makamwang hên inlihim ya tungkol ha pamanlokop ni Apo Namalyari, noa, kanlan kaatag ay anhabiên ko ha alimbawan bêngat, ta êmên ‘Manlêk hila man, ay a la mamwangan ya anhêlkên la. Manggilam hila man, ay a la maintindihan ya angkagilaman la.’” ");
INSERT INTO sgb_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Êmên ya di ya labay habiên hên hatoy alimbawa. Ya bini ay habi ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ya nakêm tawo ay in-alimbawa ha natataan bini. Ya bini ya natata ha dann ay habi ni Apo Namalyari ya nagilam lan tawo, noa, nilumatêng hi Satanas ta inalíh na ya habaytoy habi ha nakêm la, ta êmên hila a maniwala kan Apo Namalyari, haka a miligtas ha parusa. ");
INSERT INTO sgb_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ya bini ya natata ha kabatoan, ay habi ni Apo Namalyari ya tinanggap la hên main kahiglaan, noa, a nimana ha nakêm la. Naniwala hila pon, noa, hên nilumatêng ya pamanubuk, ay a hilay na naniwala. ");
INSERT INTO sgb_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ya bini ya natata ha kadiwian ay habi ni Apo Namalyari ya ginilam la pon, noa, tampol nialíh ha nakêm la, gawan ha kayagahan, pibandian, haka katsighaw hên biyay la. Kabay a nabayo ya biyay la, hên nanad ha a nanagêy ya bini. ");
INSERT INTO sgb_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ya bini ya natata ha mataba ya luta ay habi ni Apo Namalyari ya ginilam la, bayo nimana ha nakêm la, gawan mangêd ya nakêm la. Ha pamagtêêh la, ay nabayoy biyay la.” ");
INSERT INTO sgb_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Ayn mamagkêt hên atáng bayo halokoban o idin ha hilong pangkatuluyan. Noa, idin na ha mantêg pamyanan atáng, ta êmên mahawangan ya danan lan anhumwên. ");
INSERT INTO sgb_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ayn intago ya a miawah. Ayn êt inlihim ya a mamwangan haka mihumbung. ");
INSERT INTO sgb_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Pakaihipên yoy angkagilam yo, ta no honolên yoy toro ko, ay mapahanan ya pamangintindi yo, noa, no a yon honolên, ay alihên êt kamoyu ya pêpêrad ya naintindihan yo.” ");
INSERT INTO sgb_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Amêhên, nilumatêng ya indo ni Apo Jesus haka hilay patêl na, noa, a hila midani kana gawan ha kal-atan. ");
INSERT INTO sgb_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Main naghabi kana, ya wana, “Atsi di ha ilwangan ya indo mo haka hilay patêl mo. Labay la kan makahabi.” ");
INSERT INTO sgb_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Noa, wani ni Apo Jesus kanla, “Hilay ampanggilam habi ni Apo Namalyari haka ampanyag kalabayan na, ay anlugurên ko hên nanad ha pamanlugud ko ha indo ko, haka hilay patêl ko.” ");
INSERT INTO sgb_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Mihay allo, hinumakay ha bangka hi Apo Jesus hên kalamo na hilay tagahonol na. Hinabi na kanla, “Magbangka kitamo hên lumipay.” Kabay nag-umpisa hilay nan lumipay. ");
INSERT INTO sgb_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ha pamanlumipay la, ay nabêlêw ya hi Apo Jesus ha bangka. Amêhên, nagkamain hên hadyay angin, haka ya bangka la ay angkapnoy nan lanêm, kabay atsi hila ha kapapotog. ");
INSERT INTO sgb_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Pinukaw la ya, ya wanla, “Panginoon! Panginoon! Ampilêmêh kitamina!” Nimata ya, ta binawal nay angin haka hadyay tandulon. Tinunggên ya angin haka tandulon, hên nagpatêkbêk. ");
INSERT INTO sgb_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Hinabi na kanla, ya wana, “Ayn kaw awud hên tsiwala kangko!” Nalimwan hila. Nag-êpapah hilan nihahabi, ya wanla, “Hino kaya ya hatsi ya ampakabawal hên angin haka lanêm, bayo anhumonol hila kana?” ");
INSERT INTO sgb_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Amêhên, nilumatêng hilan Apo Jesus ha logal lan Gergeseno ha lipay lanêm ha êtêb hên probinsyan Galilea. ");
INSERT INTO sgb_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pagtaoy ni Apo Jesus ha bangka ay tinupa ya hên mihay lalaki ya taga bayro ha balayan ya habayto ya hinapatan hên nangarawak ya a angkahêlêk. Nabuyot yay nan, a ampagtakop. A yay na ampaidi ha bali, ta ampaidi ya tana ha pay-ilbêngan. ");
INSERT INTO sgb_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Hên nahêlêk na hi Apo Jesus, ay nan-angaw ya, bayo nandoko ya, hên nakadêngdêng ha arapan na, ta makhaw nan hinabi, ya wana, “Jesus, Anak ni Apo Namalyari, awta ampakiêmênan mo ko? Ampakihabi ko kamo ya a mo ko dayin parusaan.” ");
INSERT INTO sgb_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Hinabi nay habayto gawan ampaalihên ni Apo Jesus ya nangarawak ya nipanhumapat kanan lalaki. Hata lalaki ay panay anhapatan hên nangarawak ya a angkahêlêk. Agyan ambantayan la ya hên kabaryo na, haka an-itaykala la ya gamêt haka bitsih na, ay pamboytoên nan bat ya habayto, bayo an-ipalako la ya ha marayo ha tawo hên hatoy nipanhumapat kana. ");
INSERT INTO sgb_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Amêhên, nangotang hi Apo Jesus, ya wana, “Hinoy langan mo?” Wanlan hinumapat kana etaman, “Libo-Libo.” Hinabi lay habayto, gawan mal-at ya nangarawak ya a angkahêlêk ya nipanhumapat kanan lalaki. ");
INSERT INTO sgb_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Habaytoy hinumapat ay nakiingalo kan Apo Jesus, ya paan hila dayin iutoh ha logal ya kaparusaan, ya ayn anggaan ya kalalêan. ");
INSERT INTO sgb_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Main kal-atan baboy bayro ya ampipambuk ha bung-oy ya narani ha lanêm. Nakiingalo hilay hinumapat hên paulayan hila dayi hên humapat kanlan baboy. Pinaulayan na hila etaman ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kabay inumalih hila kanan lalaki ta nipanhumapat hila kanlan baboy. Habaytoy baboy ya hinapatan la, ay nipamwayun palohan ha natalindah ya laylay lanêm hên nilêmêh ha dagat-dagatan. ");
INSERT INTO sgb_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Hên nahêlêk lan manayhay hên baboy ya nalyari, ay nipamwayu hila ta impamwang lay habayto ha kaganawan baryo haka ha balayan la. ");
INSERT INTO sgb_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Hên nagilam lay balita la, ay nilako lan hinlêk ya nalyari. Hên nilumatêng hila kan Apo Jesus ay nahêlêk lay lalaki, ya inalihan nangarawak ya a angkahêlêk. Nakatakop yay na haka ampikno ya ha dani ni Apo Jesus hên mapatêkbêk ya ihip. Nipangkalimo hila ha kapangyarihan ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Impamwang lan nakahêlêk ya dinyag ni Apo Jesus, no ay-êmên yan namaalíh hên nangarawak ya a angkahêlêk ya hinumapat kanan lalaki. ");
INSERT INTO sgb_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Bayo nakiingalo hilay Gergeseno ya atsi bayro, kan Apo Jesus, ya mag-alíh ya ha logal la. Dinyag lay habayto gawan hadyay limo la. Kabay hinumakay hilan Apo Jesus ha bangka hên paorong. ");
INSERT INTO sgb_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Hên nakitan nan lalaki ya inalihan nangarawak ya a angkahêlêk, ya paalíh hilan Apo Jesus, ay nakiingalo ya hên gêtan ya dayi, noa, impaorong na ya ni Apo Jesus, ya wana, ");
INSERT INTO sgb_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Muli kay na ha bali mo, ta ipamwang mo ya kangêran ya dinyag kamo ni Apo Namalyari.” Nammita yay nay lalaki ta impamwang na ha boon balayan ya habayto ya tungkol ha dinyag ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Amêhên, ha pag-orong lan Apo Jesus hên nagbangkan ubat ha lipay, ay hinumigla hilay kal-atan ya ampangênggan kana. ");
INSERT INTO sgb_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Main dinumani hên nandoko hên nakadêngdêng ha bitsih ni Apo Jesus ya mihay ampamaala ha sinagoga bayro, ya nag langan Jairo. Nakiingalo ya kan Apo Jesus, ya kihonol ya dayi kana ha bali na, ");
INSERT INTO sgb_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","gawan ampamêrad-pêrad yay nan matsi, ya kamiha-mihaan nan anak ya babayi, ya main manga labinloway taon. Kaban ampita hilan Apo Jesus ha bali ni Jairo, ay ampi-pipiitan la yan kal-atan ya nakihonol kanla. ");
INSERT INTO sgb_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kalamo lan hata kal-atan, ya mihay babayi, ya labinloway taon nanan andayaên. Naiubuh nay na ya pibandian na ha hino-hino kay na hên ya doktor, noa, ayn nakaalíh hakit na. ");
INSERT INTO sgb_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kaban ampammita hila, ay dinumani ya hatoy babayi ta ginap-an nay laylayan takop ni Apo Jesus ha dapit bokotan, haka tambêng tinunggên ya ampantoloy daya na. ");
INSERT INTO sgb_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tampol yan nangotang hi Apo Jesus, “Hinoy nakagapa hên takop ko?” Hên ayn mangamin, ay hinabi ni Pedro, “Panginoon, ampilolopungan la ka, haka la kan ampi-pipiitan hên kal-atan!” ");
INSERT INTO sgb_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Noa, hinabi ni Apo Jesus, ya wana, “Main nakagapa hên takop ko, ta natanam ko ya main inalihan hakit gawan ha kapangyarihan ko.” ");
INSERT INTO sgb_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Hên namwangan nan babayi ya napansin ni Apo Jesus ya dinyag na, ay ampamêgpêg yan inumarap kana, hên nandoko hên nakadêngdêng. Ha arapan lan kal-atan, ay impamwang na no pata ginap-an na ya takop ni Apo Jesus, haka no ay-êmên tambêng hên tinunggên ya ampantoloy daya na. ");
INSERT INTO sgb_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Amêhên, wani Apo Jesus kanan babayi, “Inalíh ya hakit mo gawan ha paniwala mo kangko. Muli kay na hên mapatêkbêk ya ihip.” ");
INSERT INTO sgb_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Kaban ampaghabi ya pon hi Apo Jesus, ay main nilumatêng ya ubat ha bali ni Jairo, ya naghabi, “Natsi ya anak mo. A minan abalaên hi Apo Jesus hên maniraw ha bali.” ");
INSERT INTO sgb_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Noa, hên nagilam ni Apo Jesus ya habayto, ay wana kan Jairo, “Paan kan maglungkot. Maniwala ka tana kangko, ta ma-alíh ya hakit hên anak mo.” ");
INSERT INTO sgb_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Panlumatêng la ha bali lan Jairo, ya pinahowên nan bêngat ni Apo Jesus ay hi Pedro, hi Juan, hi Santiago haka hilay toa hên hata anak. ");
INSERT INTO sgb_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Naubuh hilan ampipanangih haka ampipanyêngên ya atsi bayro, kabay hinabi na kanla, “Paan kaw manangih ta a ya natsi. Nabêlêw yan bêngat.” ");
INSERT INTO sgb_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kinailyan la ya hi Apo Jesus, ta muwang la ya pêtêg yay nan natsi. ");
INSERT INTO sgb_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Noa, tinalan ni Apo Jesus ya gamêt nan anak ta hinabi na, “Anak ko, mimata ka.” ");
INSERT INTO sgb_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nabiyay yan oman haka tambêng yan nimata. Hinabi na êt ni Apo Jesus ya pakanên la ya. ");
INSERT INTO sgb_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nag-êpapah ya toa nan anak, noa, binawal na hila hên paan ipamwang ha kaatag ya biniyay nay anak. ");
INSERT INTO sgb_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Mihay allo, ay tsinipon ni Apo Jesus ya labinloway tagahonol na, ta dinyanan na hila hên kapangyarihan haka tungkulan hên mamaalíh hên hakit haka kaganawan nangarawak ya a angkahêlêk. ");
INSERT INTO sgb_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Bayo in-utoh na hila hên mamitoro hên tungkol ha pamanlokop ni Apo Namalyari haka mamaalíh hên hakit. ");
INSERT INTO sgb_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Bayo hila nammita, ay hinabi na kanla, “Paan kaw mantan hên hinoman ya nanad ha têkên, balutan, puto, pera, haka takop. ");
INSERT INTO sgb_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Magdahêl kaw ha balin managyat kamoyu, haka bayro kaw tana angga ha a pon nayari ya pamitoro yo ha logal ya habayto. ");
INSERT INTO sgb_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","No a la kaw tanggapên ha mihay logal, ay bayo kaw mag-alíh bayro, ay ikampag yoy tuwapok ha bitsih yo, ta êmên la mamwangan ya atsi tana kanla no lumatêng kanla ya parusa ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Amêhên, nammita hilay na hên mamitoro hên Mangangêd ya Habi haka hên mamaalíh hên hakit ha ayri man ya logal. ");
INSERT INTO sgb_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Hên nagilam ni Gobernador Herodes Antipas ya ampamaala ha Galilea ya tungkol ha kapapaêpapah ya andaygên lan Apo Jesus, ay nanyagah yay na, gawan main ampaghabin hi Apo Jesus ay Juan Bautista ya impapatsi na, ya nangoman nabiyay. ");
INSERT INTO sgb_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Main kaatag ya ampaghabin nagpahlêk ya hi propeta Elias. Ampaghabi êt hên kaatag, ya nangoman nabiyay ya miha kanlan kaatag ya mámipamwang hên an-ipaihip kanla ni Apo Namalyari hên haton lagi. ");
INSERT INTO sgb_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Amêhên, hinabi ni Gobernador Herodes Antipas, ya wana, “Impapotoh kinay ulo ni Juan Bautista, noa, hinoy hata lalaki ya angkababalit-an kon habaytsi ya angkalyari?” Kabay labay na ya dayin mahêlêk hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Hên nag-orong hilay nay labinloway apostol, ay hinabi la kan Apo Jesus ya dinyag la. Gintan na hila, hên kakapag lan bêngat, ha balayan Betsaida. ");
INSERT INTO sgb_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Hên namwangan lan kal-atan, ya atsi hila bayro, ay nangamat hila. Dinambi na hila etaman ni Apo Jesus. Intoro na kanla ya tungkol ha pamanlokop ni Apo Namalyari bayo namaalíh yan hakit la. ");
INSERT INTO sgb_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Hên maranin matata ya allo ay dinumani kana ya labinlowa hên naghabi kana, ya wanla, “Dayi ipalako mo hilay kal-atan ha balang baryo, ya alwan marayo di ta êmên hila makatsikap hên maêkan la haka mapagdahêlan la gawan ayn bali di.” ");
INSERT INTO sgb_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Noa, hinabi na kanla, ya wana, “Hikaw tanay mam-i kanla hên maêkan la.” Hinabi la, ya wanla, “Main kitamon bêngat hên limay puto haka loway kênan lanêm. Labay mo hên manaliw kay hên kaên hên hatsi ya kal-atan?” ");
INSERT INTO sgb_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Hinabi lay habayto, gawan main manga liman libo ya lalaki bayro. Noa, hinabi ni Apo Jesus kanlan labinloway tagahonol na, ya wana, “Paiknoên yo hilan pusto-pusto ya mani-limampo ha balang pusto.” ");
INSERT INTO sgb_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Dinyag la ya kalabayan ni Apo Jesus. Pinaikno la ya kal-atan. ");
INSERT INTO sgb_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Kingwa ni Apo Jesus ya limay puto haka loway kênan lanêm. Naningla ya, ta pinahalamatan nay hatsi kan Apo Namalyari. Pino-potoh nay habayto, ta impatayak na kanlan tagahonol na. ");
INSERT INTO sgb_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ya kaganawan tawo ay nakaêkan angga ha nangabhoy hila. Hên tsinipon la ya tagan, ay nakapno hila êt hên labinloway lubon. ");
INSERT INTO sgb_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Mihay allo hên ampanalangin yan miha na hi Apo Jesus, ay dinumani kana ya tagahonol na. Kinotang na hila, ya wana, “Hino ko kano?” ");
INSERT INTO sgb_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Kabay hinabi la, “Wanlan kaatag ya hika ay hi Juan Bautista. Noa, wanlan kaatag êt ya hika ay hi Propeta Elias. Hilay kaatag êt ay ampaghabin nabiyay hên oman ya miha kanlan unan mámipamwang hên an-ipaihip kanla ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Wana êt kanla ni Apo Jesus, “Kamoyu etaman, hino ko ha ihip yo?” Wani Pedro etaman, “Hika ya Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala.” ");
INSERT INTO sgb_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Noa, binawal na hila hên ipamwang ya hatoy hinabi ni Pedro ha hinoman. ");
INSERT INTO sgb_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Wana êt ni Apo Jesus, “Hiko ya Taga-Langit, ya In-anak Tawo, ay kailangan magtêêh hên hadyay pamagdusa. Hikoy araên lan mánoron Kautuhan ni apo Moises. Araên la kon toa ya nag tungkulan ha bansa, haka araên la ko êt hên ampamaala kanlan pari. Ipapatsi la ko, noa, ha ikatlon allo ay biyayên akon oman.” ");
INSERT INTO sgb_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Bayo pinarani nay kal-atan hên kalamoy tagahonol na, ta wana kanla, “Hilay labay hên humonol kangko, ay dapat lan liwaan ya sarili lan kalabayan. Allo-allo ay dapat nakal-an hilan magtêêh hên kairapan, o matsi man, ya maialimbawa ha pamakay hên nabyat ya koros. ");
INSERT INTO sgb_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Hilay a mabay hên humonol kangko, gawan a la labay hên mangoman ya pamimiyay la, ay maalihan êt hên biyay. Noa, hilay matsi gawan ha paniwala la kangko, ay dyanan biyay ya ayn angga. ");
INSERT INTO sgb_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Agyan mikamihan kanan mihay tawo ya pibandian di ha luta, ay a na mapakinabangnan ya habayto, no hiya etaman ay mipalako ha kaparusaan ya ayn angga! ");
INSERT INTO sgb_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ya balang maykarêng-êy ha toro ko, haka kangko, ya Taga-Langit, ya In-anak Tawo, ay ikarêng-êy ko hila êt ha pag-orong ko di. Ha pag-orong ko di, ay atsi kangko ya kapahilêw ya kahampatan ko, ya kapahilêw ya kahampatan ni Apo Namalyari, ya Tatang ko, haka ya kapahilêw ya kahampatan lan anghel na. ");
INSERT INTO sgb_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Pakagilamên yoy habaytsi, ya main ungno di kamoyu ya a matsi angga ha mahêlêk la, ya nilumatêng ya pamanlokop ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Hên nalabah ya manga waloy allo paubat hên hinabi nay habayto ni Apo Jesus, ay nilumakat ya ha tawgtug ta manalangin. Pinaglamo na hi Pedro, hi Juan haka hi Santiago. ");
INSERT INTO sgb_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kaban ampanalangin ya, ay naoman ya itsura na. Ya takop na ay nag-in bapan putsi ya kapahilêw. ");
INSERT INTO sgb_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Namakonkaynaman ay main loway lalaki ya nagpahêlêk ya ampaghabi kan Apo Jesus. Hila ay hi apo Moises haka hi apo Elias ya lowa kanlan manan mámipamwang ya an-ipaihip kanla ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Bat nilumtaw ya hata lowa hên main kapangyarihan haka ya kapahilêw ya kahampatan ni Apo Namalyari, ta pinihabian lay kamatsan kan Apo Jesus ya malyari ha balayan Jerusalem. ");
INSERT INTO sgb_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Hi Pedro haka hilay loway lamo na ay nabêlêw, noa, nipaalimugat hila ta nahêlêk la ya kapahilêw ya kahampatan ni Apo Jesus haka ya loway lalaki ya kalamo na. ");
INSERT INTO sgb_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Pammita lan lalaki, ay hinabi ni Pedro, ya wana, “Panginoon, mangêd ya atsi kitamo di. Manyag kay hên tatloy hawong. Miha kamo, miha kan apo Moises, haka miha kan apo Elias.” Hinabi nay habayto ni Pedro gawan nakatsigag ya. ");
INSERT INTO sgb_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ampaghabi ya pon hi Pedro hên inupungan hila hên ginêm. Kabay nalimwan hilan Pedro. ");
INSERT INTO sgb_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Haka main hilan nagilam ya habi ya ubat ha ginêm, ya wanan habi, “Hatsi ya anlugurên kon Anak. Gilamên yoy habi na!” ");
INSERT INTO sgb_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Hên tinunggên ya habi, ay mimiha na tana ni Apo Jesus ya nahêlêk la. A la pon hinabi ha hinoman ya habaytoy nahêlêk la. ");
INSERT INTO sgb_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Hên humonoy allo, hên nakalohan hilay na ha tawgtug, ay tinupa hilan Apo Jesus hên kal-atan. ");
INSERT INTO sgb_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Namakonkaynaman ay namaêg ya mihay lalaki, ya wana, “Mánoro, ingalwan mo dayi ya anak koy lalaki gawan hiyay kamiha-mihaan kon anak. ");
INSERT INTO sgb_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Bêngat yan andawhongên hên anhumapat kana, bayo ampiangaw-angaw ya. An-ibuwad-buwad na yan hata anhumapat kana angga ha ampaggalak ya bêbêy na. Ampakahakitan na ya haka a na labay itêgên ya pamahakit na kana. ");
INSERT INTO sgb_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Impapakahabi kina ha tagahonol mo ya paalihên la ya, noa, a la ya agyu hên paalihên.” ");
INSERT INTO sgb_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Amêhên, wani Apo Jesus, “Hikaw ya angkabiyay amêhên ay ayn paniwala haka hadyay karawakan yo. Aydin angga kataw hên pakilamoan haka pakitagalan?” Bayo wana kanan lalaki, “Gêtan mo di ya anak mo.” ");
INSERT INTO sgb_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kaban andumani ya anak ay impatumba yan hatoy hinumapat kana haka imbuwad-buwad na ya. Noa, hi Apo Jesus ay namawal kanan hinumapat haka namipaplag kana, bayo in-orong nay anak ha toa na. ");
INSERT INTO sgb_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Naubuh hilan nag-êpapah ha kapangyarihan ni Apo Namalyari. Kaban ampag-êpapah hila ha balang dyag ni Apo Jesus, ay hinabi na kanlan tagahonol na, ya wana, ");
INSERT INTO sgb_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Pakagilamên yo. Hiko, ya Taga-Langit, ya In-anak Tawo, ay i-upit ha kapatsi ko.” ");
INSERT INTO sgb_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Noa, a la naintindihan hên tagahonol na ya habaytoy hinabi na, gawan habaytoy a impamwang kanla ni Apo Namalyari. Haka malimo hila etaman hên mangotáng. ");
INSERT INTO sgb_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Mihay allo ay pinihuhubakan lan tagahonol ni Apo Jesus no hino kanla ya matag-ay ya tungkulan. ");
INSERT INTO sgb_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Muwang ni Apo Jesus ya laman ihip la, kabay pinairêng nay mihay anak ya nanawa ha dani na. ");
INSERT INTO sgb_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Haka wana kanla, “Hinoman ya ampaniwala kangko, ya ampananggap kanlan maaypa ya nakêm nanad hata anak, hên gawan habaytoy paniwala la kangko, ay hila ya matag-ay ya tungkulan. Ta ha pananggap la kanla, ay nanad hiko ya antanggapên la. Hila etaman ya ampananggap kangko, ay antanggapên la hi Apo Namalyari ya namiutoh kangko.” ");
INSERT INTO sgb_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Wani Juan kan Apo Jesus, “Nahêlêk naên ya mihay lalaki ya ampamaalíh hên nangarawak ya a angkahêlêk ha langan mo. Binawal naên ya gawan alwa tamo yan kalamo.” ");
INSERT INTO sgb_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Noa, wani Apo Jesus kana, “Paan yo yan bawalên, ta hilay a ampanalanghang kamoyu ay ampanawop kamoyu.” ");
INSERT INTO sgb_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Hên marani ya allon pamag-orong ni Apo Jesus ha langit, ay tinalagá na hên maniraw ha balayan Jerusalem. ");
INSERT INTO sgb_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Main yan in-utoh ya nuna kana ha mihay baryo ha Samaria hên namil-an pagdahêlan lan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Noa, a la ya tanggapên bayro gawan magsimba ya ha Jerusalem, haka hilay Samaritano haka hilay ampagsimba ha Jerusalem ay a angkapiintindi. ");
INSERT INTO sgb_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Hên namwangan lan tagahonol na, hi Santiago haka hi Juan, ya nalyari, ay hinabi la, ya wanla, “Panginoon, labay mo hên mamaaypa kay hên apoy ya ubat ha langit êmên hila mangamamatsi?” ");
INSERT INTO sgb_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Noa, pinalingayan na hila, haka hinabyanan na hila. ");
INSERT INTO sgb_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Amêhên, nammita hila ha kaatag ya baryo. ");
INSERT INTO sgb_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ha pammita la, ay main lalaki ya naghabi kana, “Mánoro, kihonol ako kamo ayri man ya lakwên mo.” ");
INSERT INTO sgb_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Hinabi etaman kana ni Apo Jesus, “Hila man ya ahon lalê ay main lêyang ya ampaidyanan, haka hilay manok lalê ay main halay, noa, hiko ya Taga-Langit, ya In-anak Tawo, ay ayn dyanan di ha luta.” ");
INSERT INTO sgb_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Bayo, hinabi na kanan kaatag, ya wana, “Kihonol ka kangko.” Noa, hinabi nan hatsi, ya wana, “Panginoon, paulayan mo ko pon hên mamilbêng toa ko.” ");
INSERT INTO sgb_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Noa, hinabi ni Apo Jesus kana, ya wana, “Paulayan mo hilay ayn biyay ya ayn anggaan hên mamilbêng kapareho lan natsi. Noa, hika ay dapat hên mamipamwang hên tungkol ha pamanlokop ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Main kaatag ya naghabi, ya wana, “Panginoon, kihonol ako kamo, noa, paulayan mo ko pon hên magpamwang ha bali.” ");
INSERT INTO sgb_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Hinabi ni Apo Jesus kana, ya wana, “Alwan hêpat ha mihay manyarol hên panay hên mamalingay. Êmbayro êt, alwan hêpat hên makilamo ha pamanlokop ni Apo Namalyari ya hilay a nakapêptêng ya ihip ha pamanhumonol kana.” ");
INSERT INTO sgb_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pangayari hên habayto, ay namili ya hi Apo Jesus hên pitumpo boy lowa ya kaatag ya tagahonol na. Impauna na hila hên lowa-lowa ha balang balayan haka ha balang baryo ya lakwên na, ta êmên hila manoro hên habi ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Bayo hila nammita, ay hinabi na kanla, “Hilay kal-atan ya labay hên manggilam hên tungkol kan Apo Namalyari, ay nanad hilan pali ya nawto ya maranin gapahên, gawan nakal-an hilay na hên maniwala. Mal-at ya gapahên, noa, u-ungnon bêngat hilay manggapah. Kabay ihalangin yo kan Apo Namalyari, ya nag pali, ya mamiutoh ya hên kaatag êt, ya kapareho yon manggapah, ta êmên hila etaman manoro hên tungkol kana. ");
INSERT INTO sgb_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Hali, mita kaw na. Noa, kaillag kaw, ta hikaw ay nanad anak tupa, ya an-iutoh ko kanlan nanad ahon lalê, ya mapamatsin tupa. ");
INSERT INTO sgb_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Paan kaw mantan hên pera, balutan, o paghagili hên pag-apin bitsih yo. A kaw magpabuyot hên maghabi ha katupa yo ha dann. ");
INSERT INTO sgb_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Bayo kaw hên humwên ha mihay bali, ay habiên yo pon, ‘Lumatêng dayi kamoyu ya ingalo ya pan-idin ni Apo Namalyari.’ ");
INSERT INTO sgb_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","No ya nakêm lan hatoy nag bali ya anlakwên yo ay nakal-an hên mananggap ingalo ni Apo Namalyari, ay makatanggap hilan habayto. No a hila nakal-an hên mananggap ingalo na, ay a hila makatanggap hên habayto. ");
INSERT INTO sgb_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Bayro kaw tanan maglaêh ha dinahêlan yoy bali. A kaw paálih-álih hên katuluyan yo. Kaên yo, haka inêmên yo, ya hinon iarap la kamoyu, ta hilay mag-obra ay dapat dyanan hên suweldo. ");
INSERT INTO sgb_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ha balang balayan ya lakwên yo, no tanggapên la kaw, ay kaên yo ya iarap la kamoyu. ");
INSERT INTO sgb_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Paalihên yoy kaganawan hakit lan nipaghakit, bayo habiên yo kanlan atsi bayro ya êmên di, ‘Dinumani kamoyu ya pamanlokop ni Apo Namalyari.’ ");
INSERT INTO sgb_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Noa, paglatêng yo ha mihay balayan, ta a la kaw tanggapên, ay paan kaw magdahêl bayro. Bayo kaw mita, ay habiên yo kanla ya êmên di, ");
INSERT INTO sgb_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Agyan tuwapok hên balayan yo, ya nipagpak ha bitsih naên, ay ikampag naên bayo kay mita, ta êmên yo mamwangan ya atsi tana kamoyu no lumatêng kamoyu ya parusa ni Apo Namalyari. Pakaihipên yo ya dinumani kamoyu ya pamanlokop na, noa, a kaw nagpalokop.’” ");
INSERT INTO sgb_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Hinabi nay na êt ni Apo Jesus kanlan tagahonol na, ya wana, “Pakagilamên yo, mabyat ya parusa kanlan taga-balayan Sodoma ya inulam ni Apo Namalyari hên hato, gawan hadyay kasalanan la. Noa, ha allon pamipapawa ni Apo Namalyari hên nagpalokop kana ha a nagpalokop kana, ay mas mabyat ya parusa kanlan hata balayan ya a nananggap kamoyu kanan parusa kanlan taga-balayan Sodoma.” ");
INSERT INTO sgb_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Inhundo ni Apo Jesus ya paghabi na, ya wana, “Kaingalo kaw ya taga-balayan Corazin haka taga-balayan Betsaida gawan a yo paghêhêan hên talibatokan ya pamanyag yon kasalanan, agyan mal-at ya kapapaêpapah ya dinyag ko bahên. Mabyat ya kasalanan lan taga-balayan Tiro haka taga-balayan Sidon. Noa, no nadyag dayi kanla ya kapapaêpapah ya dinyag ko bahên ha Corazin boy Betsaida, ay tampol la dayi bayton impahlêk ha dyag la ya pinaghêhêan haka tinalibatokan la ya pamanyag lan kasalanan, hên taga-Tiro haka Sidon. ");
INSERT INTO sgb_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Lumatêng lano ya allon pamipapawa ni Apo Namalyari hên nagpalokop kana, ha a nagpalokop kana, ay mas mabyat ya pamarusa kamoyun taga-Corazin haka Betsaida kanan pamarusa kanlan taga-Tiro haka Sidon. ");
INSERT INTO sgb_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Hikaw êt, ya taga-balayan Capernaum, êndat yo no mipalako kaw ha langit hên mananggap papuri, noa, ihamwag kaw ha impiyerno.” ");
INSERT INTO sgb_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Hinabi na êt ni Apo Jesus kanlan tagahonol na, ya wana, “Hilay ampanggilam kamoyu, ay ampanggilam kangko. Hilay ampangara kamoyu, ay hiko ya an-araên la. Hilay ampangara kangko, ay an-araên la hi Apo Namalyari ya namiutoh kangko.” Hên nayari yay nan naghabi hi Apo Jesus, ay nammita hilay nay pitumpo boy lowa. ");
INSERT INTO sgb_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Pag-orong lan pitumpo boy lowa, ay hadyay higla la. “Panginoon,” wanla, “hila man ya nangarawak ya a angkahêlêk ay nag-alíh gawan ha kapangyarihan mo hên impaplag naên hila.” ");
INSERT INTO sgb_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Hinabi ni Apo Jesus kanla, “Nahêlêk ko hi Satanas ya innabo ubat ha langit, ya nanad ha kagalingan hên kimat. ");
INSERT INTO sgb_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Dinyanan kataw hên kapangyarihan hên torakan ya kapatsi tamo, ya hilan Satanas. Hila ay nanad utan haka mahlay ya konipit ya makamatsi, noa, a kaw mahakitan, torakan yo hila man. ");
INSERT INTO sgb_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Êmbayro man, ay paan kaw humigla, gawan hikaw ay namaalíh hên nangarawak ya a angkahêlêk. Noa, dapat humigla kaw, gawan nakahulat ha langit ya langan yo, ya labay habiên ya nag biyay kaw na hên ayn angga kalamo ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Hên habayto, ay pinahigla hi Apo Jesus hên Espiritu ni Apo Namalyari. Nanalangin ya hên êmên di, “Tatang ko ha langit, ampahalamatan kata, ya ampamaala ha langit haka luta, gawan impamwang mo ya tungkol kangko kanlan maaypa ya nakêm, ya a mo impamwang kanlan matag-ay ya pinag-aralan, ya matag-ay ya nakêm. Awo, Tatang, ta habaytoy kalabayan mo.” ");
INSERT INTO sgb_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Bayo wani ni Apo Jesus kanlan kal-atan, “In-ubuh nan impamwang kangko hên Tatang ko, hi Apo Namalyari ya tungkol kana. Ayn taganán makakilala kangko, ya Anak na, no alwan hiyan bêngat ya Tatang ko. Ayn êt taganá hên makakilala kanan Tatang ko, no alwan hikon bêngat, ya Anak na, haka hilay piliên ko hên makakilala kana.” ");
INSERT INTO sgb_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Amêhên, hinabi ni Apo Jesus kanlan tagahonol nan bêngat, ya wana, “Iningalwan kaw, gawan angkakit yo ya dyag ko. ");
INSERT INTO sgb_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Hên hato, ay mal-at ya mámipamwang hên an-ipaihip kanla ni Apo Namalyari, haka main ari ya labay dayi hên makahêlêk hên angkakit yo. Labay la dayin magilaman ya angkagilaman yo. Noa, a la nahêlêk ya angkakit yo. A la êt nagilam ya angkagilaman yo.” ");
INSERT INTO sgb_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Minghan, main mánoron Kautuhan ni apo Moises ya nirêng, ta tuksoên na dayi hi Apo Jesus, ya wana, “Mánoro, hino ya daygên ko ta êmên ako madyanan hên biyay ya ayn angga?” ");
INSERT INTO sgb_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Kabay nangotang hi Apo Jesus kana, “Hinoy nakahulat ha Kautuhan ni Apo Namalyari? Hinoy angkabáha mo bayro?” ");
INSERT INTO sgb_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Amêhên, hinabi nan lalaki, ya wana, “Dapat lugurên tamo hi Apo Namalyari, ya Panginoon hên boon nakêm, boon ihip, haka boon hêkaw. Dapat tamo etaman hên lugurên ya kapareho tamo hên nanad pamanlugud tamo ha lawini tamo.” ");
INSERT INTO sgb_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","“Pêtêg ya hinabi mo,” wani Apo Jesus. “No daygên mo ya habain, ay madyanan kan biyay ya ayn angga.” ");
INSERT INTO sgb_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nangotang yay na êt kan Apo Jesus ya hata mánoron Kautuhan, gawan a na labay hên mipakarêng-êy ya, ya wana, “Hinoy kapareho ko?” ");
INSERT INTO sgb_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Kabay hinabi ni Apo Jesus, “Minghan main lalaki ya anlumohan ubat ha balayan Jerusalem palako ha balayan Jerico. Tinambangan la ya hên nangarawak ya lalaki. Kingwa lay takop na. Pinakatumbuk la ya êt. Bayo imbalag la ya hên pêrad tanan natsi. ");
INSERT INTO sgb_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Amêhên, ay main pari tamon taga-probinsyan Judea, ya nagdann bayro. Hên nakit nay hatoy pêrad tanan matsi, ay nagtugigih ya. ");
INSERT INTO sgb_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Êmbayro êt ya dinyag hên mihay Levita, ya kapareho tamon taga-probinsyan Judea ya nagdann bayro, ay nagtugigih ya êt. ");
INSERT INTO sgb_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Noa, main mihay taga-probinsyan Samaria, ya nagdann bayro. Nahên nahêlêk nay lalaki ya tinambangan, ay naingalwan na ya. ");
INSERT INTO sgb_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nilako nay tinambangan, ta tinambalan nan alak haka laro ya manihugat-hugat na, bayo kinêlkêlan nay habayto. Inhakay na ya ha anhakyan na, hên palako ha mihay bali ya pagdahêlan ya pan-upaan. Hinayhay na ya bayro. ");
INSERT INTO sgb_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nahên nagwatah, ay nam-i yan pera kanan hata nag bali, ta wana, ‘Hayhayên mo ya. No kulang ya hata an-ibalag ko, ay bayaran ko tana ya kulang ha pag-orong ko di.’” ");
INSERT INTO sgb_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Amêhên, hinabi ni Apo Jesus ha mánoron Kautuhan ni apo Moises, ya wana, “Kanlan hatoy tatlo ya nagdann bayro ha lalaki ya tinambangan, ay hinoy main pamikipatêl ha kapareho na?” ");
INSERT INTO sgb_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","“Hatoy nakaingalo kana,” wanan mánoron Kautuhan ni apo Moises. Kabay wani Apo Jesus, “Mita kay na, ta êmbayro êt ya daygên mo.” ");
INSERT INTO sgb_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Inhundo ni Apo Jesus haka hilay tagahonol na ya pammita la. Nilumatêng hila ha balayan ya main babayi ya nag langan Marta ya nanagyat kanlan Apo Jesus ha bali na, ta mangan. ");
INSERT INTO sgb_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Main yan ali hi Marta hên mihay babayi ya nag langan Maria, ya nikno ha danin bitsih ni Apo Jesus hên ampanggilam toro na. ");
INSERT INTO sgb_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Noa, nampotog ya hi Marta ta mal-at ya an-iluto na hên mimiha na. Kabay hinabi na kan Apo Jesus, ya wana, “Panginoon, a mo angkadambi ya pinaulayan na kon ali ko hên manluto hên mimiha ko? Iutoh mo ya dayi hên hawpan na ko.” ");
INSERT INTO sgb_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","“Marta, anak ko, mampotog ka ha kal-atan dyag. ");
INSERT INTO sgb_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Mihan bêngat ya kailangan. Pinili ni Maria ya mangêd, ta panggilamên nay panoro ko. Ayn mamawal kana.” ");
INSERT INTO sgb_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Minghan nanalangin ya hi Apo Jesus ha mihay logal. Pangayari na, ay hinabi kana hên mihay tagahonol na, ya wana, “Panginoon, toroan mo kay dayi hên manalangin hên nanad panoro ni Juan Bautista ha tagahonol na.” ");
INSERT INTO sgb_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Hinabi ni Apo Jesus, “No manalangin kaw, ay êmên di ya habiên yo: ‘Tatang, puriên ka dayi hên balang miha. Dayi lumatêng ya pamanlokop mo. ");
INSERT INTO sgb_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Dyanan mo kay dayi hên kaên ya kailangan naên amêhên. ");
INSERT INTO sgb_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Patawarên mo kay dayi ha kasalanan naên ta ampatawarên naên etaman ya kaganawan ya nakadyag kasalanan kannaên. Paan mo kay paulayan hên matukso.’” ");
INSERT INTO sgb_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Hinabi nay na êt ni Apo Jesus kanlan tagahonol na, ya wana, “Waringan, ya miha kamoyu ay lumatêng ha balin kaluguran na hên bonak yabi, ta habiên na ya êmên di, ‘Kalalaki, dyanan mo ko pon hên maêkan. ");
INSERT INTO sgb_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Nilumatêng ya kaatag ya kaluguran ko ya nagdann di, ya ubat ha marayo, noa, ayn akon maipakan kana.’ ");
INSERT INTO sgb_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Êmbayro man, ay hinabi nan kaluguran na ha lalên bali na, ya wana, ‘A mo kon abalaên. Nakakabat ya ilwangan, ta angkabêlêw kay, anggan maának ko. A ko kaimata hên mam-in kailangan mo.’ ");
INSERT INTO sgb_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“Anhabiên ko kamoyu ya no a ya dayi mimata gawan ha pamilulugud la, ay mimata ya gawan pamalêkpêk hên hata kaluguran na, bayo idin nay kailangan hên kaluguran na. ");
INSERT INTO sgb_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kabay wangko kamoyu, pakapakikwaan yoy kailangan yo kan Apo Namalyari, ta dyanan na kaw. Pakatapolên yo ya kailangan yo kana, ta hawpan na kaw. Pakabaêgên yo ya, ta gilamên na kaw hên nanad ha kabat ya loatên. ");
INSERT INTO sgb_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Daygên yoy habayto, ta hilay ampakikwa ay dyanan. Hilay ampanapol hên kailangan la kana ay makatapol. Hilay ampamaêg ay gilamên hên nanad ha kabat ya loatên. ");
INSERT INTO sgb_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ayn miha man kamoyu ya mam-in nabiyay ya utan ya makamatsi ha anak yo, no kikwa yan kênan lanêm. ");
INSERT INTO sgb_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ayn etaman mam-in mahlay ya konipit ha anak na, no kikwa yan poga. ");
INSERT INTO sgb_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Makasalanan kaw man, ay kamwang kaw hên mam-in ikakangêd ha maának yo. Hi Apo Namalyari pon kaya, ya Tatang tamo ha langit, ya ayn kasalanan, ay yarin a ya mamahapat hên Espiritu na kanlan balang kikwan habayto kana!” ");
INSERT INTO sgb_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Minghan impaplag ni Apo Jesus ya mihay narawak ya a angkahêlêk ya hinumapat, hên namaomêl ha mihay lalaki. Hên inumalih yay na, ay ampakahabi yay nay omêl. Nag-êpapah hilay kal-atan ya atsi bayro. ");
INSERT INTO sgb_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Noa, panhabiên lan kaatag, ya pamaalíh ni Apo Jesus hên nangarawak ya a angkahêlêk, ay ha kapangyarihan ni Satanas, ya poon lan nangarawak ya a angkahêlêk. ");
INSERT INTO sgb_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Hilay kaatag etaman, ay labay la yan subukên, kabay hinabi la kana ya mamipahlêk yan palatandaan, ya ubat ha langit, ta êmên la mamwangan no pêtêg hên atsi kana ya kapangyarihan ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Muwang ni Apo Jesus ya laman ihip la, ya êndat la no ubat kan Satanas ya kapangyarihan na. Kabay hinabi na, “No alimbawa ta mipapatsi ya angkalokopan hên mihay bansa, ay mahira ya habayto. Êmbayro êt ya malyari ha mipapamilya ya mipapatsi. ");
INSERT INTO sgb_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","No mipapatsi hilay angkalokopan ni Satanas, ay mahira bayto ya pamanlokop na. Panhabiên yo ya ampamaalíh akon nangarawak ya a angkahêlêk ha kapangyarihan ni Satanas. ");
INSERT INTO sgb_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","No êmbayro awud, ay anto baytoy ubatan kapangyarihan hên kalamo yo, ya ampamaalíh hên nangarawak ya a angkahêlêk? Hila êt ya ampamaptêg hên mali kaw. ");
INSERT INTO sgb_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ha kapangyarihan ni Apo Namalyari ya pamaalíh ko hên nangarawak ya a angkahêlêk. Ya labay habiên hên habayto, ay atsi kamoyu ya pamanlokop ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“No main mihay makhaw, ya mal-at ya almas, ya ampamantay ha bali na, ay a makwa ya hinon atsi kana. ");
INSERT INTO sgb_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Noa, no main lumatêng ya makhaw êt kana, ay hambutên na ya, ta kowên na ya almas ya an-asaan na, haka ya kaganawan ya atsi kana, ta iatag-atag na. ");
INSERT INTO sgb_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Hilay ayn pon ha lokop ko, ay kapatsi ko. Haka hilay a ampanawop hên manipon hên tawo ta êmên hila makilamo kangko, ay ampamidayo hên tawo kangko. ");
INSERT INTO sgb_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“No umalih ha mihay tawo ya narawak ya a angkahêlêk, ya hinumapat kana, ay tawak-tawakên nay namala ya luta, ta manapol yan mapagpatêkbêkan na. Noa, ayn yan matapol. Kabay wana ha nakêm na, ‘Mag-orong ko ha tawo ya ubatan ko.’ ");
INSERT INTO sgb_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Pag-orong na, ay malatêng nay ubatan na, ya ayn êt napahili kana, malinis, haka nakakumpini, ya nakal-an hên togêlan. ");
INSERT INTO sgb_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kabay managyat yan pitoy kapareho nan a angkahêlêk, ya narawak êt kana, ta paglamo na bayro. Haka humwên hila, kabay lalo yay nan kaingalo ya hatoy tawoy inorongan na.” ");
INSERT INTO sgb_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kaban ampaghabi ya pon hi Apo Jesus, ay main mihay babayi bayro ha kal-atan, ya naghabi hên makhaw kan Apo Jesus, “Iningalwan ya namianak haka namahoho kamo.” ");
INSERT INTO sgb_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Noa, hinabi ni Apo Jesus kana ya êmên di, “Lalo hên an-ingalwan ya ampanggilam haka anhumonol ha habi ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kaban ampi-tsi-tsipon hilay kal-atan ha dani ni Apo Jesus, ay inhundo nay pamaghabi na, ya wana, “Bapan dawak hilay tawo amêhên. Ampanapol hilan kapapaêpapah ya palatandaan ya ubat ha langit. Noa, ayn ipahlêk kanla, no alwan nanad ha naipahlêk hên hato, ya kapapaêpapah ya nalyari kan Propeta Jonas. ");
INSERT INTO sgb_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","No ay-êmên yan nag-in palatandaan kanlan taga-balayan Ninive, hi Propeta Jonas, ay êmên êt bayro hiko, ya Taga-Langit, ya In-anak Tawo, ay mag-in palatandaan kanlan tawo amêhên. ");
INSERT INTO sgb_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ha Allon Pamanukom ni Apo Namalyari, ay mirêng ya Reyna hên Sheba hên hato hên habyanan na kaw. Mipakarêng-êy kaw, ta agyan hadyay dayo na, ay nilako na hi Arin Solomon, ta labay nan gilamên ya toro na. Amêhên, ay main di ya matag-ay ya tungkulan kan Arin Solomon, noa, a kaw ampanggilam. ");
INSERT INTO sgb_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ha Allon Pamanukom ni Apo Namalyari, ay mirêng hilay taga-Ninive, ya nipaghêhên pamanyag lan kasalanan, hên haton nagilam lay toro ni Propeta Jonas, ta habyanan la kaw, gawan main di ya matag-ay ya tungkulan kan Propeta Jonas, yan a kaw naghêhên nanalibokot ha pamanyag yon kasalanan.” ");
INSERT INTO sgb_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Hinabi nay na êt ni Apo Jesus, ya wana, “Ayn mamagkêt hên atáng, bayo ihinêp o itagpên. Noa, ya atáng ay idin ha mantêg hên pamyanan atáng, ta êmên mahawangan ya danan lan anhumwên. ");
INSERT INTO sgb_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ya mata yo ay nanad pag-atáng yo. No nahawang ya mata yo, ay mahawangan êt ya nakêm yo. Noa, no napukakê ya angkahêlêk yo, ay nanad nariglêm êt ya nakêm yo. ");
INSERT INTO sgb_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kabay kaillag kaw, ta kayno ya êndat yon hawang, ya atsi kamoyu, ay kariglêman awud. ");
INSERT INTO sgb_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","No nahawangan ni Apo Namalyari ya nakêm yo, ta ayn man pêrad ya kariglêman bahên, ay hadyay hawang ya biyay yo, ya nanad angkahawangan hên hadyay hawang ya atáng.” ");
INSERT INTO sgb_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Hên nayari yay nan nanoro hi Apo Jesus, ay main Pariseo ya nanagyat kana hên mangan. Kabay nakilako ya, haka inarap nay kaên. ");
INSERT INTO sgb_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nag-êpapah ya habaytoy Pariseo hên napansin na, ya a ya pon nag-uyah gamêt na hi Apo Jesus, bayo ya nangan. ");
INSERT INTO sgb_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kabay wani Apo Jesus kana, “Hikaw ya Pariseo, ay maialimbawa ha mihay ampanguyah bat hên bulin baso haka bokot pinggan, ya a ampanguyah hên mantêg dêmêk. Ta ampanguyah kaw hên gamêt yo, noa, ampaulayan yoy nakêm yo, ya hadyay kahibaan haka karawakan. ");
INSERT INTO sgb_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mulala kaw lawêh! Ya nanyag hên lawini, ay hiya êt ya nanyag hên nakêm. ");
INSERT INTO sgb_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Noa, idin yo dayi kanlan ayn maêkan ya laman hên pinggan yo, ta habaytoy mamalinis hên kabooan hên atsi kamoyu. ");
INSERT INTO sgb_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Kaingalo kaw ya Pariseo! Mangêd ya an-idin yo kan Apo Namalyari ya ikamapo hên bulong ya pan-ihabug yo ha habaw yo, noa, angkapaulayan yoy maalagá, ya katoynungan haka ya pamanlugud yo kan Apo Namalyari. Dapat yon idin kana ya ikamapo, noa, paan yon paulayan ya katoynungan haka ya pamanlugud yo kana. ");
INSERT INTO sgb_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Kaingalo kaw ya Pariseo! Ta labay yoy pinakamangêd ya iknoan ha sinagoga, haka labay yon galangên la kaw ha balayan. ");
INSERT INTO sgb_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kaingalo kaw ya Pariseo! Maialimbawa kaw ha pinangilbêngan ya bawal hên torakan ya ayn palatandaan, ya angkatorakan tawo gawan a la muwang. Ha hêlêk lan tawo ay mangêd kaw, yan antoroan yo hila hên manyag kasalanan hên a la muwang.” ");
INSERT INTO sgb_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Amêhên, hinabi nan mihay mánoron Kautuhan ni apo Moises kana, ya wana, “Mánoro, ha hinabi mo, ay angkahugatan kay etaman.” ");
INSERT INTO sgb_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Kabay hinabi ni Apo Jesus, “Kaingalo kaw etaman, ya mánoron Kautuhan ni apo Moises, ta hadyay bêyat ya an-ipadyag yo kanlan kaatag, noa, pêrad man, ay a kaw ampanawop kanla. ");
INSERT INTO sgb_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kaingalo kaw, ta ampamadyag kaw hên pantson lan propeta ni Apo Namalyari ya pinatsi lan ninuno yo. ");
INSERT INTO sgb_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ya panyag yon habayto, ay pamaptêg ya an-umuyon kaw ha dinyag lan ninuno yo. Pinatsi lay propeta ni Apo Namalyari, bayo ampamadyag kaw pon êt hên pantson lan pinatsi la. ");
INSERT INTO sgb_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Gawan êmbayro, ay hinabi nan kamwangan ni Apo Namalyari, ‘Iutoh ko kanla hilay mámipamwang hên an-ipaihip ko kanla haka hilay apostol. Ya kaatag ay patsên la. Ya kaatag êt ay pairapan la.’ ");
INSERT INTO sgb_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kabay tanggapên lan tawo amêhên ya parusa, gawan ha pangamatsi lan habaytoy mámipamwang, paubat hên dinyag nay hata luta angga amêhên. ");
INSERT INTO sgb_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Mal-at ya pinatsi paubat hên pinatsi hi Abel, angga ha pinatsi hi Zacarias, ya pinatsi ha pilatan hên pamiulaman hên an-iátang kan Apo Namalyari haka ya Templo. Anhabiên ko kamoyu, parusaan ya tawo amêhên, gawan ha pangamatsi lan habayto. ");
INSERT INTO sgb_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Kaingalo kaw ya mánoron Kautuhan ni apo Moises! Inalíh yoy susi hên kabat ha balin nag kamwangan tungkol ha kalabayan ni Apo Namalyari. A kaw anhumwên, bayo ambawalên yo êt hilay labay humwên.” ");
INSERT INTO sgb_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Hên nayari yan naghabi, ay nimitay na hi Apo Jesus bayro ha bali. Paubat hên habayto, ay minusmus la ya hên Pariseo haka mánoron Kautuhan ni apo Moises. Mal-at ya an-ikotang la kana ta ");
INSERT INTO sgb_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","inimatonan la ya, ta êmên la yan madakêp ha pamaghabi na. ");
INSERT INTO sgb_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Hên hato, libo-liboy ni-tsi-tsipon angga ha nangapitotorak hilan bitsih. Naghabi ya pon hi Apo Jesus kanlan tagahonol na, ya wana, “Kaillag kaw ha pampaalsa lan Pariseo, ya pagbabara lan anhumonol hila kan Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ayn intago ya a mamwangan haka mihumbung. ");
INSERT INTO sgb_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ya hinabi yo ha nariglêm, ay magilaman ha nahawang. Ya inanah yo ha bali yo, ay miangaw.” ");
INSERT INTO sgb_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Anhabiên ko kamoyun kaluguran ko, paan yon kalimwan ya labay mamatsin lawini yo, ta lawini yon bêngat ya mapatsi la. A la man magêtan ha impiyerno ya kaêlwa yo. ");
INSERT INTO sgb_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Anhabiên ko kamoyu no hino ya dapat yon kalimwan. Kalimwan yo hi Apo Namalyari, ta panga-ubat nan mangwan biyay, ay main ya êt hên kapangyarihan hên mamitapon kaêlwa yo ha apoy ya taganán a maparê ha impiyerno. Awo. Habiên ko kamoyu, hiya ya kalimwan yo, alwan kaatag. ");
INSERT INTO sgb_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Noa, hadyay lugud ni Apo Namalyari, ta agyan hilay nanaway manok lalê, ay a na ampaulayan. ");
INSERT INTO sgb_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Agyan habot ulo yo, ay muwang nay bilang. Kabay paan kaw malimo. A na kaw paulayan, ta maalagá kaw kanlan mal-at ya manok lalê.” ");
INSERT INTO sgb_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Hinabi nay na êt ni Apo Jesus, “Hilay alwan marêng-êy hên mamaptêg ha arapan hên kal-atan ya hila ay ampaniwala kangko, ya Taga-Langit, ya In-anak Tawo, ay a ko etaman ikarêng-êy ha arapan lan anghel ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Noa, hilay ampaghabi ha arapan hên kal-atan, ya a hila ampaniwala kangko, ay habiên ko etaman lano ha arapan lan anghel ni Apo Namalyari, ya a ko hila muwang. ");
INSERT INTO sgb_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Hilay maghabi hên pamanira kangko, ya Taga-Langit, ya In-anak Tawo, ay mapatawad. Noa, hilay maghabi hên pamaniran Espiritu ni Apo Namalyari, ay a mapatawad. ");
INSERT INTO sgb_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Idikil la kaw ha sinagoga haka la kaw gêtan kanlan kaatag ya manungkulan, ta kotangên la kaw, noa, paan kaw manyagah no hinoy pakibat yo, ");
INSERT INTO sgb_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ta habayto êt ay mamitoro kamoyu ya Espiritu ni Apo Namalyari no hinoy habiên yo.” ");
INSERT INTO sgb_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Amêhên, ya miha kanlan kal-atan, ay naghabi kan Apo Jesus, ya wana, “Mánoro, iutoh mo ha kaka ko ya atagan na ko ha mana naên ha tatang naên.” ");
INSERT INTO sgb_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Wani Apo Jesus kana, “Pata kotangên mo kangkoy habain? Alwan tungkulan ko hên manlingon ha pamiatag hên mana yo.” ");
INSERT INTO sgb_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Bayo wana kanlan kal-atan, “Illagan yoy nakêm yo ha kaganawan karidyaan, ta ya biyay ay a angkakwa ha mal-at ya pibandian.” ");
INSERT INTO sgb_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Amêhên, in-alimbawa ni Apo Jesus hên êmên di, ya wana, “Ya mihay mabandi ay nakagapah hên hadyay lakê ha luta na. ");
INSERT INTO sgb_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Amêhên, nangihip ya hata mabandi no hino ya daygên na, ta kulang ya pamyanan na hên nagapah na. ");
INSERT INTO sgb_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Naihipan na ya agwatên nay pamyanan na hên nagapah na, ta manyag yan bayo, ya mahlay, ya pamyanan nan kaganawan pibandian na. ");
INSERT INTO sgb_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ta atsi ha ihip na, no manyag yan habayto, ay mahabi na ha nakêm na ya pamamatuloy na tana, mangan, minêm, haka magpakahigla, ta a yay na maalihan hên hinon maêkan ha mal-at ya taon. ");
INSERT INTO sgb_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Noa, wani Apo Namalyari kana, ‘Mulala ka! Amêhên yabi, ay maalihan kan biyay. Kabay a mina mapakinabangnan ya imbunton mo ya para kamon bêngat.’” ");
INSERT INTO sgb_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Hên nayari ni Apo Jesus ya habaytoy alimbawa na, ay wana, “Êmbayroy malyari kanlan ampaybunton hên pibandian, noa, ampagkulang hila ha arapan ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Bayo hinabi ni Apo Jesus kanlan tagahonol na, ya wana, “Paan kaw manyagah, no hinoy maêkan yo, ta êmên kaw mabiyay. Paan kaw êt manyagah no hinoy maitakop yo. ");
INSERT INTO sgb_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Gawan ya biyay ay maalagá ha kaên, haka ya lawini ay maalagá ha takop. ");
INSERT INTO sgb_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Hêlkên yoy manok lalê. A hila ampananêm o ampanggapah man, haka ayn hilan pamyanan hên nagapah la. Êmbayro man, ay ampakanên hila ni Apo Namalyari. Taganán maalagá kaw kanlan manok lalê, kabay a na kaw paulayan! ");
INSERT INTO sgb_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Manyagah kaw man, ay a yo mapakarang ya biyay yo! ");
INSERT INTO sgb_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","No pêrad man, ay a yo mapakarang ya biyay yo ha kayagahan yo, ay pata manyagah kaw hên tungkol ha hinoman! ");
INSERT INTO sgb_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Awta manyagah kaw no hinoy itakop yo! Ihipên yo tanay pamantumubo hên bulaklak. A hila ampag-obra o ampanayi man hên takop la. Agyan hi Arin Solomon, ha kal-atan bandi na, ay a ya nakapagtakop hên nanad kahampatan hên mihay bulaklak. ");
INSERT INTO sgb_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","No ya lamon, ya angkabiyay pon amêhên, bayo ulamên pangawatah, ay ampahampatên ni Apo Namalyari, yarin a na kaw dyanan takop! Kulang awud ya paniwala yo kana. ");
INSERT INTO sgb_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kabay paan kaw manyagah ha panapol yon maêkan haka mainêm yo. ");
INSERT INTO sgb_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ta hilay a ampagpalokop kan Apo Namalyari, ay panay hên ampanyagah no hinoy maêkan haka mainêm la. Noa, hikaw ay paan yo hilan totoên, ta muwang ni Apo Namalyari ya Tatang tamo ya kailangan yoy habayto. ");
INSERT INTO sgb_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kabay unaên yoy pagpalokop yo kan Apo Namalyari, ta idin na ya kaganawan kailangan yo.” ");
INSERT INTO sgb_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Amêhên, hinabi nay na êt ni Apo Jesus kanlan tagahonol na, ya wana, “Paan kaw malimo agyan pêpêrad kaw, ta mahigla hi Apo Namalyari, ya Tatang yo hên ilamo na kaw ha pamanlokop na. ");
INSERT INTO sgb_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ihaliw yoy pibandian yo, ta mam-i kaw kanlan ampangailangan. Ya mangêd ay manipon kaw hên pibandian ha langit, ta ha êmbayro, ay nanad kaw hên main pamyanan pera ya a mahira, haka a maalihan laman. Ta habaytoy pibandian ay a maplak, haka a êt mahira hên anag. ");
INSERT INTO sgb_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Dapat yon daygên ya habayto, ta no anto ya pibandian yo, ay atsi êt bayro ya nakêm yo.” ");
INSERT INTO sgb_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Hinabi nay na êt ni Apo Jesus, ya wana, “Dapat panay kaw hên nakal-an, hên nanad ha mihay mangêd ya ipoh ya panay nag dêkêt ya solo, ta êmên kaw ");
INSERT INTO sgb_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","mag-in nanad kanlan panay nakal-an hên tampol manloat danan hên amo la uston mamaêg ya, pamanlumatêng nan ubat ha kasálan. ");
INSERT INTO sgb_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Hadyay higla lan ipoh, no malatêng hilan amo la hên nakal-an. Paiknoên hilan amo la, ta hiyay mamiapag kaên la. ");
INSERT INTO sgb_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Hadyay higla lan ipoh no malatêng na hilan nakal-an, pammuli na hên bonak yabi o maranon man. ");
INSERT INTO sgb_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Pakaihipên yoy hatsi, no muwang na dayi hên nag bali no hinon oras hên lumatêng ya manakaw, ay a na ya paulayan hên mahowên ya bali na. ");
INSERT INTO sgb_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Hikaw man, ay kailangan nakal-an kaw, ta hiko ya Taga-Langit, ya In-anak Tawo, ay biglan lumatêng.” ");
INSERT INTO sgb_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Amêhên, wani Pedro, “Panginoon, hinabi moy hatoy alimbawa para bêngat kannaên hên labinloway tagahonol mo o para ha kal-atan?” ");
INSERT INTO sgb_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Kabay wani Apo Jesus, “Ya ipoh ya mapaypaniwal-an haka magaling, ay hiya ya dyanan tungkulan no main yan lakwên ya amo na. Hiya ya manalan bali na, haka mamiarasyon hên iluto lan kapareho nan ipoh, hên allo-allo. ");
INSERT INTO sgb_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Hadyay higla hên ipoh, no malatêng na yan amo na hên ampanyag kalabayan na ha pag-orong na. ");
INSERT INTO sgb_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Pakagilamên yo, dyanan na yan tungkulan hên amo na hên manalan hên hinon pibandian na. ");
INSERT INTO sgb_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Noa, no ihipên nan hatoy ipoh ya mabuyot pon lumatêng ya amo na, bayo umpisaan nan pakatumbukên ya kapareho nan ipoh, ya lalaki haka babayi, ta mangan ya tana haka maglahing êt, ");
INSERT INTO sgb_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ay no biglan lumatêng ya amo nan hatoy ipoh, ay parusaan nay ipoh na hên hadyay bêyat, bayo ilamo na ya kanlan a ampaniwala, bayro ha parusa ya ayn angga. ");
INSERT INTO sgb_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ya ipoh ya ampakamwang kalabayan hên amo na, noa, a ya nakal-an hên honolên ya habayto, ay parusaan ya hên mabyat ya parusa. ");
INSERT INTO sgb_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Noa, ya ipoh ya a ampakamwang no hinoy pan-ibawal hên amo na, ya nakadyag hên bawal ya dapat pamarusaan kana, ay parusaan hên alwan mabyat. Hilay dinyanan ni Apo Namalyari hên mal-at, ay mal-at etaman ya tapolên kanla. Hilay pinatsiwal-an hên mal-at, ay panapolan êt hên mal-at.” ");
INSERT INTO sgb_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Wanay na êt ni Apo Jesus, “Atsi ko di ha luta hên ampantan hên nanad apoy ya pamanatol ni Apo Namalyari. Dayi napagkêtan ana ya habayto. ");
INSERT INTO sgb_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Noa, hadyay bêyat ya kailangan kon danan pon. Habayto ya ampamagulon ihip ko angga ha a ya pon matupad. ");
INSERT INTO sgb_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Paan yon ihipên ya nantan akon pamikiúmang ha miha ta miha, ta hikoy pangubatan hên pamigagampi, gawan main maniwala kangko, haka main a maniwala. ");
INSERT INTO sgb_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Paubat amêhên, no alimbawa ta main limay katawo ha mihay pamilya, ay alwan parehoy ihip la, ta ya tatlo ay mihay ihip kanlan lowa. ");
INSERT INTO sgb_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ta hilay ampaniwala haka hilay a ampaniwala, ay alwan parehoy ihip. Ya tatang ay mihay ihip ha anak nay lalaki. Ya indo ay mihay ihip ha anak nay babayi. Ya ampo ya babayi ay mihay ihip ha manuyang nay babayi.” ");
INSERT INTO sgb_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Wanay na êt ni Apo Jesus kanlan kal-atan, “No mahêlêk yo ya naborêg ha dapit kanaboan allo, ay habiên yo, ‘Manguran ya.’ Ay manguran ya bay. ");
INSERT INTO sgb_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","No angkapansin yoy angin ya ubat ha kabalah-balahan, ay habiên yo, ‘Mag-in hadyay omot amêhên.’ Ay mag-in hadyay omot bay. ");
INSERT INTO sgb_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ampagbabara kaw! Muwang yo no hinoy labay habiên hên angkakit yo ha langit. Yarin a yo muwang ya labay habiên hên angkalyari amêhên panaon!” ");
INSERT INTO sgb_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Wana êt ni Apo Jesus, “Pata a kaw manimbángan no hinoy hêpat? ");
INSERT INTO sgb_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","No main mamidikil kamoyu, ta gêtan la kaw ha mánlingon kaso, ay mangêd ya makikatoynungan kaw pon kanla ha dann, ta êmên a la kaw na gêtan ha mánlingon kaso. Ta kayno idin na kaw ha magbantay hên hukulan, ta ikulung kaw. ");
INSERT INTO sgb_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kabay bayro kaw tana ha hukulan angga ha a yo mabayaran ya kaganawan ya ipabayad la kamoyu.” ");
INSERT INTO sgb_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Hên habayto, kaban ampaghabi ya pon hi Apo Jesus, ay nilumatêng ya ungnoy namihumbung kana, ya wanla, “Impapatsi ni Gobernador Pilato ya ungnoy taga-probinsyan Galilea kaban ampangátang hila hên ampakikwan patawad kan Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Hinabi ni Apo Jesus kanla, ya wana, “Êndat yo no mabyat ya kasalanan lan hata taga-Galilea kanlan kasalanan lan kaatag ya taga-Galilea, gawan êmbayro ya nalyari kanla? ");
INSERT INTO sgb_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Alwa! Noa, anhabiên ko kamoyu, no a yo paghêhêan hên talibatokan ya pamanyag yon kasalanan, ay matsi kaw ngan etaman. ");
INSERT INTO sgb_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ihipên yo hilay labinwalo ya natsi hên natumba ya tawer ha Siloe. Êndat yo no mabyat ya kasalanan la kanlan kasalanan lan kaatag ya ampaidi ha balayan Jerusalem? ");
INSERT INTO sgb_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Alwa! Noa, anhabiên ko kamoyu, no a yo paghêhêan hên talibatokan ya pamanyag yon kasalanan, ay matsi kaw ngan etaman.” ");
INSERT INTO sgb_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Amêhên, nam-i yan alimbawa hi Apo Jesus, ya wana, “Main mihay lalaki ya nag poon kayoy igos ha pananêman nan ubas. Minghan nanapol yan tagêy hên hatoy igos, noa, ayn. ");
INSERT INTO sgb_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kabay hinabi na ha ampanayhay hên tanaman na, ya wana, ‘Tatloy nay taon hên ampanapol akon tagêy hên hata igos, noa, ayn. Potohên mina, ta bêngat ya tanan angkahayang ya luta.’ ");
INSERT INTO sgb_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Noa, hinabi nan ampanayhay hên tanaman, ya wana, ‘Apo, paulayan mo ya pon hata taon, ta gambolên koy poon na, ta dyanan ko yan abono. ");
INSERT INTO sgb_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","No managêy ya ha taon, ay mangêd. No a ya êt managêy, ay ipapotoh mina bayto kangko.’” ");
INSERT INTO sgb_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Mihay allon pamagsimba, ay ampanoro ya hi Apo Jesus ha miha kanlan sinagoga. ");
INSERT INTO sgb_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Main babayi bayro ya hinapatan hên namakuba kana, hên labinwaloy taon ana. A nay nan maitoynung ya bokot na. ");
INSERT INTO sgb_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Hên nahêlêk na ya ni Apo Jesus, ay wana ha babayi, “Ayn kay nan hakit!” ");
INSERT INTO sgb_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Impalunto nay gamêt na ha nakuba, kabay tambêng yan tinumoynung ya bokot na, bayo pinuri na hi Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Noa, nanuluk ya main tungkulan ha sinagoga, gawan allon pamagsimba, hên namaalíh hi Apo Jesus hên hakit nan nakuba. Kabay wana kanlan kal-atan, “Main anêm ya allo ya nakal-an ha pamag-obra. Kabay dapat ipaalíh yoy hakit yo ha miha kanlan habaytoy anêm ya allo, alwa ha allon pamagsimba.” ");
INSERT INTO sgb_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Kabay wani Apo Jesus kanla, “Hikaw ya ampagbabara! No main kaw hên baka o asno ya nakah-êl, ay yarin a yo yan okalên ta êmên ya kainêm, ha allo man hên pamagsimba! ");
INSERT INTO sgb_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Hata babayi, ya mihay kaapo-apoan ni apo Abraham, ay atsi ha aypan kapangyarihan ni Satanas hên main nanan labinwaloy taon, kabay kailangan yan okalên, agyan allo hên pamagsimba.” ");
INSERT INTO sgb_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Hên nahabi nay habayto, ay nipakarêng-êy hilay anhumalanghang kana. Noa, hilay kaatag bayro ay nipaghigla ha mangangêd ya kapapaêpapah ya dinyag na. ");
INSERT INTO sgb_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Amêhên, inhundo ni Apo Jesus ya panoro na, ya wana, “Nanad hino kaya ya pamanlokop ni Apo Namalyari? Hino kaya ya pangialimbawaan ko hên pamanlokop na? ");
INSERT INTO sgb_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ya pamanlokop ni Apo Namalyari ay maialimbawa ha pamantumubo hên mihay nanaway but-o ya intanêm. Iibon man ya but-o, ay hinumlay yan nag-in kayo, kabay nipanyag halay ya manok-lalê ha hanga na.” ");
INSERT INTO sgb_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Hinabi nay na êt ni Apo Jesus, ya wana, “Hinoy pangialimbawaan ko hên pamanlokop ni Apo Namalyari? ");
INSERT INTO sgb_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ya pamanlokop ni Apo Namalyari ay maialimbawa ha pampaalsa ya pinakigawgaw hên mihay babayi ha kal-atan hên arina, haka nilum-at ya habaytoy kal-atan.” ");
INSERT INTO sgb_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Kaban inhundo ni Apo Jesus ya pammita na ha balayan Jerusalem, ay nanoro ya ha kaganawan balayan haka kaganawan baryo ya angkadanan na. ");
INSERT INTO sgb_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Minghan main naghabi kana, ya wana, “Apo, pêpêrad bêngat ya madyanan biyay ya ayn angga?” ");
INSERT INTO sgb_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Hinabi ni Apo Jesus, ya wana, “Pakangêrên yon humwên ha makpit ya ilwangan. Anhabiên ko kamoyu, mal-at ya mapilit hên humwên, noa, a hila makahowên. ");
INSERT INTO sgb_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","“No ingkabat nan nag bali ya ilwangan, ta mirêng kaw hên mamaêg hên mamaêg, ya habiên yo, ‘Panginoon pahowênên mo kay!’ ay habiên na kamoyu, ‘A ko muwang no hino kaw.’ ");
INSERT INTO sgb_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Bayo habiên yo, ‘Ay-êmên mon mahabi ya habayto, ha napagkaaêm naên ka, ta nanoro ka di ha logal naên.’ ");
INSERT INTO sgb_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Amêhên, habiên nay na êt hên nag bali, ya wana, ‘A ko muwang no hino kaw. Pakarayo kaw kangko, hikaw ya nipanyag karawakan.’ ");
INSERT INTO sgb_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Hadyay tangih yo bayto, haka mipang-ngê-ngêt kaw ha hadyay ilab boy ha hadyay huluk ya matanam yo, ta mahêlêk yo hilay unan natsi, hi apo Abraham, hi apo Isaac, hi apo Jacob haka hilay mámipamwang hên an-ipaihip kanla ni Apo Namalyari ya atsi ha pamanlokop na, noa, hikaw etaman, ay itaboy. ");
INSERT INTO sgb_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Habaytoy allo, ay mal-at ya alwan Israelita ya ubat ha ayri man ya logal di ha luta, ya kiaêm ha kaluto ha pamanlokop ni Apo Namalyari ha langit. ");
INSERT INTO sgb_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Pakagilamên yo. Main kaatag ya êndat yon a hila makahowên ha pamanlokop ni Apo Namalyari, yan itad hilan hêpat hên humwên. Main kaatag êt ya êndat yon itad hilan hêpat hên humwên, yan a hila makahowên.” ");
INSERT INTO sgb_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Hên habayto, ay main nilumatêng ya ungnoy Pariseo. Hinabi la kan Apo Jesus, ya wanla, “Pakarayo ka di, ta labay na kan patsên ni Gobernador Herodes Antipas.” ");
INSERT INTO sgb_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Amêhên, wani Apo Jesus kanla, “Habiên yo kan Gobernador Herodes Antipas, ya habaytoy manloko, ya ampamaalíh akon hakit haka nangarawak ya a angkahêlêk amêhên haka nobukah. Haka ha ikatlon allo ay yariên ko ya dyag ko. ");
INSERT INTO sgb_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ihundo koy pammita ko ha balayan Jerusalem amêhên, nobukah haka makalwa, ta alwan mangêd para ha mihay propeta ni Apo Namalyari hên matsi ha kaatag ya logal no alwan ha Jerusalem.” ");
INSERT INTO sgb_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Hinabi nay na êt ni Apo Jesus, ya wana, “Kaingalo kaw ya taga-Jerusalem, ta pinagbabato yoy propeta ni Apo Namalyari angga ha hilay natsi. Kata-ungno kataw nan labay lokopên hên nanad ha pamanlokop hên mihay toan manok ha hiwhiw na. Noa, a kaw mabay hên palokop kangko. ");
INSERT INTO sgb_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kabay booy nakêm kataw nan paulayan. A yo ko pon mahêlêk, angga ha a yo habiên ya habaytsi, ‘Iningalwan ya in-utoh ni Apo Namalyari.’” ");
INSERT INTO sgb_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Mihay allon pamagsimba lan Israelita, ay hinagyat hi Apo Jesus hên mangan ha bali hên mihay manungkulan lan Pariseo. Inimatonan la hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Kaban an-imatonan la ya, dinumani kan Apo Jesus ya mihay lalaki ya ginumayá ya lawini gawan hakit. ");
INSERT INTO sgb_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Kabay hinabi ni Apo Jesus kanlan Pariseo haka kanlan mánoron Kautuhan ni apo Moises, ya wana, “Ay-êmên ya nakahulat ha Kautuhan ni Apo Namalyari? Bawal kano hên mamaalíh hên hakit ha allon pamagsimba o ahê?” ");
INSERT INTO sgb_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Noa, a hila nagtonoy. Ya dinyag ni Apo Jesus ay namaalíh ya hên hakit nan lalaki, bayo impabita na ya. ");
INSERT INTO sgb_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Amêhên, hinabi ni Apo Jesus kanla, “No alimbawa ta anak yo, o baka yoy manabo ha malalê ya pangahoyan, yarin a yo tambêng ialih ya habayto, allo man hên pamagsimba?” ");
INSERT INTO sgb_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Noa, ayn naghabi. ");
INSERT INTO sgb_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Napansin ni Apo Jesus ya hilay kaatag ya hinagyat bayro ha kaluto hên hatoy Pariseo, ay nikno ha iknoan hên manungkulan agyan alwa hilan manungkulan. Kabay tinoroan na hila, ya wana, ");
INSERT INTO sgb_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“No alimbawa ta main managyat kamo ha kaluto hên kasal, ay paan kan mikno ha iknoan hên manungkulan, ta kayno main lumatêng ya manungkulan, ");
INSERT INTO sgb_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","bayo habiên na kamo hên hatoy nanagyat kamo, ‘Kalalaki ko, idin mo pon kanan manungkulan ya habain ya iknoan.’ Kabay mipakarêng-êy kay na, ta mikno ka tana ha pinakamarayo ya iknoan. ");
INSERT INTO sgb_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","No in-agkat ka ha kaluto, ya mangêd, ay mikno ka tana ha pinakamarayo ya iknoan, ta kayno habiên nan nanagyat kamo, ‘Kalalaki ko, dumani ka di ha mangêd ya iknoan.’ Ha êmbayro ay, mahêlêk lan kaatag ya atsi ha kaluto no ay-êmên kan dinayêw. ");
INSERT INTO sgb_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Hilay mapagmatag-ay, ay iaypa, haka hilay maaypay nakêm ay itag-ay.” ");
INSERT INTO sgb_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Amêhên, hinabi ni Apo Jesus ha nanagyat kana, “No magkaluto ka, paan mon bêngat hên hagyatên hilay kaluguran mo, kamag-anak mo haka hilay karani mo hên bali ya mabandi. Ta lano, ay hagyatên la ka êt, kabay matumbahan la kay na. ");
INSERT INTO sgb_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","No magkaluto ka, ay hagyatên mo hilay mangairap, hilay lumpo, hilay pilay, haka hilay buwag. ");
INSERT INTO sgb_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","A hila man makahagyat kamo, ay humigla ka, ta tumbahan na kan hagyatên lano ni Apo Namalyari ha mangoman mabiyay hilay banal.” ");
INSERT INTO sgb_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Hên nagilam hên miha kanlan ampangan bayro ha bali nan Pariseo ya hinabi ni Apo Jesus, ay wana kana, “Bapan higla lan tawo ya kilamo ha kaluto ha pamanlokop ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Amêhên, wani Apo Jesus, “Main mihay lalaki ya nagkaluto, ta mal-at ya hinagyat na. ");
INSERT INTO sgb_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Hên nakalutoy na, ay in-utoh na hilay ipoh na hên baêgên hilay hinagyat na, ta habiên na ya êmên di, ‘Kaw na di, ta nakal-an ya kaên tamo.’ ");
INSERT INTO sgb_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Noa, balang miha kanla ay naghabi, ‘Pasinsya kaw na, ta a ko makalako ha kaluto.’ Ya una ay naghabi ha ipoh, ya wana, ‘A ko makalako ha kaluto, gawan nakahaliw akon tamnan ko, ya kailangan kon hirawên.’ ");
INSERT INTO sgb_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Hinabi hên miha, ‘Nakahaliw akon limay paris hên baka. Dapat ko hilan subukên hên panyarol. Pasinsya kaw na.’ ");
INSERT INTO sgb_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Hinabin mihay na êt, ya wana, ‘Babayo kay kasal, kabay a ko makalako ha kaluto.’ ");
INSERT INTO sgb_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Nuli ya habaytoy ipoh, ta in-ubuh nan hinabi ya habayto ha amo na. Hadyay huluk hên amo hên habaytoy ipoh. Hinabi na ha ipoh, ya wana, ‘Galingên mo ha dann hên balayan, ta hagyatên mo hilay mairap, hilay lumpo, hilay pilay, haka hilay buwag.’ Kabay nammita yay nay ipoh. ");
INSERT INTO sgb_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Hên nag-orong ya ipoh, ay wana, ‘Hinonol koy utoh mo, Apo. Noa, makwal pon ya panganan.’ ");
INSERT INTO sgb_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kabay hinabi nan amo ha ipoh na, ya wana, ‘Pakahagyatên mo hilay ayn bali, ya nag hawong ha danin dann ha laylay balayan, ta êmên mapno ya bali ko. ");
INSERT INTO sgb_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Anhabiên ko kamoyu ya ayn miha man kanlan una kon hinagyat ya makataway hên kaluto ko.’” ");
INSERT INTO sgb_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Minghan, hên mal-at ya nakilako kan Apo Jesus, ay inarap na hila, ta hinabi na kanla, ");
INSERT INTO sgb_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Hilay labay hên magpalokop kangko, ta mag-in tagahonol ko, ay kailangan lugurên la ko hên igit êt ha toa la, ahawa la, anak la, kaka la, ali la, haka sarili la. ");
INSERT INTO sgb_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Haka hilay alwan nakal-an hên magtêêh hên pamairap, o matsi man, ha pamanhumonol la kangko hên nanad ha pamwat hên nabyat ya koros, ay alwan hêpat hên mag-in tagahonol ko. ");
INSERT INTO sgb_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Dapat yon pakaihipên pon ya kairapan hên mag-in tagahonol ko. Habaytoy nanad ha mihay labay hên manyag hên matag-ay ya bali, ya pakaihipên na pon mangêd, no hukad ya kaganawan kailangan na, ta êmên mayari ya bali. ");
INSERT INTO sgb_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ta, no a nan pakaihipên hên mangêd, ta bat nay nan umpisaan daygên, bayo, no a na mayari, ay kailyan la yan balang makahêlêk hên bali na, ta katarêk-tarêk ya nayari. ");
INSERT INTO sgb_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Wanla, ‘Hêlkên yo! Hatsi ay nag-umpisan manyag bali, noa, a na impayari.’ ");
INSERT INTO sgb_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Êmbayro êt ya mihay ari ya main mapon liboy hundaloh, ya labay hên lumaban ha kaatag ya ari ya nag lowampon libo ya hundaloh, ay pakaihipên na pon hên mangêd no kaya na. ");
INSERT INTO sgb_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ta no a na kaya, kaban marayo ya pon ya kapatsi na, ay main yan iutoh ya makihabi pon ha kapatsi na ya makikatoynungan ya tana. ");
INSERT INTO sgb_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Êmbayro êt kamoyu no labay yo hên mag-in tagahonol ko, ay pakaihipên yo pon no kaya yon ibalag ya kaganawan maalagá kamoyu, bayo kaw magpalokop kangko. Ta no a yo kaya, ay a kaw malyarin mag-in tagahonol ko.” ");
INSERT INTO sgb_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Mangêd ya ahin. Noa, no naalihan yay nan alat, ay ahinan maiorong ya alat na. ");
INSERT INTO sgb_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","A ya magamit hên pamataba man hên luta. Kabay itapon la tana. Hikaw ya ampanggilam kangko, pakaihipên yoy toro ko!” ");
INSERT INTO sgb_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Amêhên, hilay máningil buwih haka kaatag êt ya mapanyag nangarawak, ay dinumani kan Apo Jesus ta manggilam hên anhabiên na. ");
INSERT INTO sgb_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Anhumulapo hilay Pariseo haka hilay mánoron Kautuhan ni apo Moises, ya wanla, “Têh! Habaytsi ay ampananggap hên makasalanan, bayo ampakiaêm ya êt kanla!” ");
INSERT INTO sgb_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kabay dinyanan hila ni Apo Jesus hên hata alimbawa, ");
INSERT INTO sgb_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“No alimbawa ta main miha kamoyu ya nag magatoh ya tupa, ta nitama ya miha, ay hinoy daygên na? Siguradon ibalag na pon ya siyamapo boy siyam bayro ha pagpastolan la, ta tapolên nay habaytoy miha ya nitama hên angga ha matapol nay habayto. ");
INSERT INTO sgb_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Pamakatapol nan habaytoy tupa, ay bapan higla nay na. Kabay bakayên na yan paorong. ");
INSERT INTO sgb_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Panlumatêng na ha bali na, ay hagyatên nay kaluguran na haka karani nan bali, ta wana kanla, ‘Magpakahigla kitamo, ta natapol koy tupa ko ya nitama.’ ");
INSERT INTO sgb_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Êmbayro êt ha langit, ay siguradon magpakahigla hila ha mihay makasalanan ya maghêhê hên manalibokot ha pamanyag karawakan, kisa ha siyamapo boy siyam ya êndat lan mangêd hila haka a lay nan kailangan hên kikwan patawad.” ");
INSERT INTO sgb_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Inhundo ni Apo Jesus ya pamaghabi na, ya wana, “O alimbawa ta main babayi ya nag mapoy pera ya pilak, bayo nakatak ya miha, hinoy daygên na? Pagkêtan nay pag-atáng, palisan nay bali, ta pakatapolên nan mangêd angga ha matapol na ya nakatak. ");
INSERT INTO sgb_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Pamakatapol na hên habaytoy pera, ay hagyatên na hilay karani nan bali, haka kaluguran na ta magpakahigla hila. ");
INSERT INTO sgb_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Êmbayro êt ya kahiglaan lan anghel ni Apo Namalyari, gawan main mihay makasalanan ya maghêhê hên manalibokot ha pamanyag karawakan.” ");
INSERT INTO sgb_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Inhundo ni Apo Jesus ya pamaghabi na, ya wana, “Main mihay lalaki ya nag anak hên loway miyawhay. ");
INSERT INTO sgb_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Amêhên, hinabi nan poto ha tatang na, ya wana, ‘Tatang, idin mina kangko amêhên ya atag ko ha pibandian mo, ya mana naên lowan mitaali.’ Kabay inatag nan tatang la ya pibandian na kanlan lowa. ");
INSERT INTO sgb_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","A nabuyot, ay inhaliw nan poto ya atag nay bandi, ta nammita yan palako ha kaatag ya bansa ya marayo. Bayro nan inhayang ya atag nay bandi na ha pamanyag karawakan. ");
INSERT INTO sgb_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ha kabuyutan, ay naubuh nay nan nagastos ya atag na. Hên habayto ay nagkamain lonoh bayro. Kabay pêrad tana, ay natsi yay na dayi. ");
INSERT INTO sgb_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ya dinyag na ay nakiamo yay na pon ha mihay taga-bayro ya namiutoh kana hên mamakan hên baboy na. ");
INSERT INTO sgb_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Labay na dayin makiêkan ha pangkaên lan baboy, noa, a la ya dinyanan. ");
INSERT INTO sgb_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Hên napakaihip-ihip nan mangêd ya dinyag na, ay hinabi na ha nakêm na, ya wana, ‘Hilay ipoh hên tatang ko ay angkahawa ha pangan, kaban hikong kit, ay pêrad tanan matsi ha hadyay lonoh ko di. ");
INSERT INTO sgb_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mag-orong ako ha tatang ko, ta habiên ko kana, “Tatang, nakadyag akon kasalanan kan Apo Namalyari haka kamo. ");
INSERT INTO sgb_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Alwa mo kinan baêgên anak mo. Daygên mo ko tanan mihay ipoh mo.”’ ");
INSERT INTO sgb_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kabay nammita yay nan pauli ha tatang na. “Marayo ya êt ha bali la, ay napatsilyapan yay nan tatang na. Naingalwan na yan tatang na kabay nuwayu ya hên nanupa ha anak na, ta tinakêh haka inaro na ya. ");
INSERT INTO sgb_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","‘Tatang,’ wanan anak, ‘nakadyag akon kasalanan kan Apo Namalyari haka kamo. Alwa mo kinan baêgên anak mo.’ ");
INSERT INTO sgb_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Noa, binaêg nan tatang na ya ipoh na, ta wana, ‘Galingên yo. Kowên yoy pinakamahampat ya takop, ta ipatakop yo kana. Pahing-hingan yo ya haka dyanan yo yan pag-apin bitsih. ");
INSERT INTO sgb_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Patsên yoy pinakamatabay biseron baka, ta magpakahigla kitamo! ");
INSERT INTO sgb_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Magpakahigla kitamo, gawan hata anak ko ya nanad natsi, ay angkabiyay awud! Hiyay nanad nitama, noa, nilumatêng ya awud!’ Kabay nagpakahigla hila. ");
INSERT INTO sgb_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Hên habayto, ay atsi ya ha panamnan la ha marayo ya kaka na, ya punganay. Hên narani yay na ha bali la, ay nagilam nay tsig-tsigan haka hayawan. ");
INSERT INTO sgb_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kabay binaêg nay mihay ipoh la, ta wana, ‘Hinoy angkalyari di?’ ");
INSERT INTO sgb_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kabay wanan ipoh, ‘Apo, nilumatêng ya ali mo. Impapatsi hên tatang mo ya pinakamatabay biseron baka, gawan nilumatêng ya hên nabiyay.’ ");
INSERT INTO sgb_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Amêhên, hinumuluk ya punganay. A na labay humwên ha bali. Kabay inumawah ya tatang na, ta inamung-mung na ya, ta êmên ya humwên. ");
INSERT INTO sgb_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Noa, wana ha tatang na, ya wana, ‘Mal-at ya taon kinan ampanawop kamo hên nanad ipoh. Ya kaganawan an-iutoh mo kangko, ay hinonol ko. Noa, miha man ya biseron kambing, ay ayn kan indin kangko ya maipapatsi naên dayi hên kaluguran ko, ta êmên kay magpakahigla. ");
INSERT INTO sgb_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Hata poto mo, ay nanayang bandi mo ha pamabayi na, bayo pinamatsi mo ya êt hên pinakamatabay biseron baka!’ ");
INSERT INTO sgb_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Kabay wanan tatang na, ‘Anak ko, alwan êmbayro. Panay katan kalamo. Ya kaganawan pibandian ko ay pibandian mo. ");
INSERT INTO sgb_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Noa, hata ali mo ya nanad natsi, ay angkabiyay awud! Hiyay nanad nitama, noa, nilumatêng ya awud! Kabay kailangan kitamon magpakahigla.’” ");
INSERT INTO sgb_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Hinabi nay na êt ni Apo Jesus kanlan tagahonol na, ya wana, “Main mihay mabandi ya main pinatsiwal-an hên pibandian na. Noa, main naghabi ha mabandi ya panhayangên ya pibandian na hên pinatsiwal-an na. ");
INSERT INTO sgb_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kabay impabaêg nan mabandi ya habaytoy pinatsiwal-an na, ta wana kana, ‘Hinoy hatsi ya angkalêngê ko tungkol kamo? Ipahlêk mo kangko ya hulat mo ha nagastos mo ha pibandian ko, ta paubat amêhên alway nan hika ya patsiwal-an ko.’ ");
INSERT INTO sgb_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Kabay hinabi nan hata pinatsiwal-an ha nakêm na, ya wana, ‘Alihan akon ámo ko ha tungkulan ko. Hino kaya ya daygên ko? A ko agyu ya mabyat ya obra, nanad pag-obra ha luta. Marêng-êy ako etaman hên magpalimos. ");
INSERT INTO sgb_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Awo bay, muwang kina ya daygên ko, ta êmên la ko hagyatên ha bali la, agyan alihên na ko ha tungkulan ko.’ ");
INSERT INTO sgb_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Miha-miha nan binaêg hilay main utang ha amo na. Hinabi na ha una, ya wana, ‘Ungnoy utang mo ha amo ko?’ ");
INSERT INTO sgb_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Kabay wanan nag utang, ‘Dinalan ya hukat hên langis.’ Amêhên, hinabi nan pinatsiwal-an ha nag utang, ya wana, ‘Iawah moy listahan utang mo. Tambêng kan mikno, ta hagilyan mon limampo.’ ");
INSERT INTO sgb_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Bayo hinabi nan pinatsiwal-an ha kaatag ya main utang, ya wana, ‘Ungnoy utang mo?’ Kabay wanan nag utang, ‘Dinalan ya kaban hên trigo.’ Amêhên, hinabi nay na êt hên hatoy pinatsiwal-an, ya wana, ‘Iawah moy listahan utang mo, ta hagilyan mon walumpo.’ ");
INSERT INTO sgb_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Hên napansin nan amo ya dinyag nan pinatsiwal-an nan pibandian na, ay dinayêw na ya. Dinayêw na ya, alwan gawan pamanloko na kana, noa, gawan magaling yan mangihip. Pêtêg bay magaling hilan mangihip hên ikakangêd la ha sarili la, hilay a ampagpalokop kan Apo Namalyari, kisa kanlan nagpalokop kana.” ");
INSERT INTO sgb_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Wana êt ni Apo Jesus ha tagahonol na, “Anhabiên ko kamoyu, gamitên yoy pibandian yo ha pamanawop hên kalamo yo di ha luta, ta êmên lano ha langit, ha ayn nanan pera, ay mahigla la kaw tanggapên lan kalamo yo ya atsi bayro gawan ha hawop yo kanla. ");
INSERT INTO sgb_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ya mapaypaniwal-an ha pêrad, ay mapaypaniwal-an ha mal-at. Ya a mapaypaniwal-an ha pêrad, ay a etaman mapaypaniwal-an ha mal-at. ");
INSERT INTO sgb_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","No alwa kaw hên mapaypaniwal-an ha pibandian di ha luta, ay ayn etaman mamipatsiwala kamoyu hên mantêg pibandian ha langit. ");
INSERT INTO sgb_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","No alwa kaw hên mapaypaniwal-an ha pibandian hên kaatag, ay ayn bayton mam-i kamoyu, hên mag-in taganán kamoyu. ");
INSERT INTO sgb_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ayn hinoman ya makapaghuyo ha loway amo hên booy nakêm. Ta lugurên nay miha, haka kahêmêkan nay miha, o huyuên nan mantêg ya miha, ta hatoy miha, ay pahawaan na. Êmbayro êt, ay a yo kayan huyuên hi Apo Namalyari no ubuhên yoy hêkaw yo ha pibandian.” ");
INSERT INTO sgb_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Hên nagilam lan Pariseo ya hinabi ni Apo Jesus, ay kinailyan la ya gawan kamata hilan pera. ");
INSERT INTO sgb_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Kabay hinabi na kanla, ya wana, “Ampagbabara kaw ha arapan hên kapareho yo, noa, muwang ni Apo Namalyari ya nakêm yo. Ya bapan hampat ha ihip hên tawo, ay kapahuluk kan Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Ya impamwang lan mámipamwang hên an-ipaihip kanla ni Apo Namalyari, haka ya impamwang lan Kautuhan ya impahulat na kan apo Moises, ay tungkol ha pamanlokop ni Apo Namalyari. Haka hi Juan Bautista ya nag-umpisa hên nanupad hên habaytoy impamwang la. Paubat ha pamanlumatêng na, ay an-iaral ya Mangêd ya Habi tungkol ha pamanlokop ni Apo Namalyari haka mal-at ya ampamilit hên palokop kana. ");
INSERT INTO sgb_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Noa, nataluh hên alihên ya luta haka ya angkahêlêk ha langit kanan daygên ayn pukat ya miha man ya naipêk ya gulis kanlan habaytoy Kautuhan ni Apo Namalyari, ya hinulat ni apo Moises.” ");
INSERT INTO sgb_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Hinabi na êt ni Apo Jesus, ya wana, “Ya lalaki ya mamihiyay hên ahawa na, bayo mag-ahawan kaatag, ay nakadyag kasalanan gawan namabayi ya. Êmbayro êt ya lalaki ya nangahawa hên babayi ya inhiyay, ay nakadyag ya êt kasalanan hên namabayi.” ");
INSERT INTO sgb_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Hinabi nay na êt ni Apo Jesus, ya wana, “Main mihay mabandi ya ampagtakop hên makamal ya takop. Allo-allo, ay angkahawa ya ha hinon labay nan kaên. ");
INSERT INTO sgb_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Main etaman mihay mairap bayro ya nag langan Lazaro ya napnoan hên nuka, ya pan-ibul-ih lan kit ha arapan bali nan hatoy mabandi. ");
INSERT INTO sgb_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Atsi ya bayro, ta labay na dayin makaêkan agyan momo hên mabandi. Kaingalo yan kit, ta main êt bayron aho ya ampipanapoh hên nuka na. ");
INSERT INTO sgb_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Hên natsi hi Lazaro, hiyay gintan hên anghel ni Apo Namalyari ha langit, ha dani ni apo Abraham. Natsi ya êt ya hatoy mabandi, bayo in-ilbêng. ");
INSERT INTO sgb_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","“Hiyay gintan ha Hades. Kaban ampagdusa ya bayro ay naningla ya. Bayro ha marayo, ay nahêlêk na hi apo Abraham haka hi Lazaro. ");
INSERT INTO sgb_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kabay nan-angaw ya, ya wana, ‘Apo Abraham, ingalwan mo ko dayi. Iutoh mo hi Lazaro ya ibahá nay tampoh hên panoro na ha lanêm, ta pakêbêlên nay dila ko, ta angkairapan ako di, gawan hadyay omot hên hata apoy.’ ");
INSERT INTO sgb_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Noa, wani apo Abraham, ‘Anak ko, muwang mo hên angkabiyay ka pon, ay hinumawa ka ha kaganawan mangangêd, kaban nagtêêh yan kairapan hi Lazaro. Amêhên, ay mahigla ya bayri hi Lazaro, kaban hika ay ampag-irap. ");
INSERT INTO sgb_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Miha êt, ay main bapan lalên bêngaw ha pilatan tamo. Kabay a kay makalako kamoyu, haka a kaw makalako di.’ ");
INSERT INTO sgb_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Hinabi nay na êt hên mabandi, ‘No êmbayro awud, ay iutoh mo dayi hi Lazaro ha balin tatang ko. ");
INSERT INTO sgb_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ta habiên na dayi kanlan limay kapotoh pohêl ko ya kaillag hila, ta êmên hila a miabot di ha logal hên hadyay pamagdusa.’ ");
INSERT INTO sgb_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Noa, wani apo Abraham, ‘Atsi kanlan kapotoh pohêl mo ya inhulat ni apo Moises haka ya inhulat lan kaatag ya mámipamwang hên an-ipaihip kanla ni Apo Namalyari ya paniwal-an la dayi.’ ");
INSERT INTO sgb_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Wanan mabandi, ‘Kulang ya habayto apo Abraham. Noa, no main mangoman mabiyay ya natsi, ya mangaral kanla, ay paghêhêan la bayto ya kasalanan la.’ ");
INSERT INTO sgb_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Noa, wani apo Abraham, ‘No a la paniwal-an ya inhulat ni apo Moises, haka ya inhulat lan kaatag ya mámipamwang hên an-ipaihip kanla ni Apo Namalyari, ay a hila êt mapaniwala ha pamwang hên mihay natsi, ya nabiyay oman.’” ");
INSERT INTO sgb_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Amêhên, wani Apo Jesus kanlan tagahonol na, ya wana, “Taganán lumatêng kantamo ya tukso hên manyag kasalanan, noa, kaingalo ya ampangubatan hên tukso. ");
INSERT INTO sgb_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Hinoman ya pangubatan hên pamanyag kasalanan hên mihay maaypa ya nakêm hên nanad kanlan habaytsi ya ampaniwala kangko, ay mangêd pon kana, ya bayo ya mag-in pangubatan hên habayto, ay patsên ya hên êl-an yan mahlay ya bato ha lêêy na, ta ilêmêh ya ha malalê ya lanêm. ");
INSERT INTO sgb_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kabay kaillag kaw. “No ya kapareho mo ay nakadyag hên kasalanan kamo, ay kailangan habyanan mo ya, ta êmên ya maghêhê ha pamanyag nan kasalanan. No maghêhê ya, ay patawarên mo ya. ");
INSERT INTO sgb_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kata-ungno ya man hên mikasalanan kamo, ha mihay allo, ta panay yan maghêhê, ay dapat mo yan patawarên.” ");
INSERT INTO sgb_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Amêhên, hinabi lan apostol kana, ya wanla, “Panginoon, pahanan moy paniwala naên kan Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Hinabi ni Apo Jesus, ya wana, “Nanawa man ya paniwala yo kan Apo Namalyari, ya nanad bat but-on mustasa, ay mahabi yo kanan hata kayo, ‘Ulutên moy sarili mo, ta mag-álih ka ha dagat!’ ay humonol ya kamoyu.” ");
INSERT INTO sgb_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Inhundo ni Apo Jesus ya pamaghabi na, ya wana, “Waringan, no main kaw hên ipoh ya nilumatêng ya ubat ha panyarolan o kaya ha pagpastolan, yarin mahabi yo kana ya, ‘Ka di, ta mangan!’ ");
INSERT INTO sgb_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Alwa. Ya habiên yo kana ay ‘Pangil-an mo kon kaên. Bayo maghagili kan takop, ta mamiatag ka kangko, ta kaban ampangan ako, ay gawangan mo kon hinon kailangan ko. Pangayari ko, ay hikay nay mangan.’ ");
INSERT INTO sgb_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","A yo ya man pahalamatan no daygên nay kaganawan in-utoh yo kana. ");
INSERT INTO sgb_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Êmbayro êt ya dapat yon daygên pamakadyag yon kaganawan impadyag ni Apo Namalyari kamoyu. Paan kaw nan manapol hên pamandayêw. Habiên yo tana ya, ‘Hikay ay ipoh bêngat. Kabay andaygên naên bêngat ya tungkulan naên.’” ");
INSERT INTO sgb_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ha pammita lan Apo Jesus palako ha balayan Jerusalem, ay nagdann hila ha pilatan hên probinsyan Samaria haka probinsyan Galilea. ");
INSERT INTO sgb_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Hên pahowên hilay na ha mihay baryo, ay nakatupa hila hên mapoy nag hakit hên ketong ya tinunggên ha marayo-dayo, ");
INSERT INTO sgb_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ta in-angaw la, ya wanla, “Panginoon Jesus, ingalwan mo kay.” ");
INSERT INTO sgb_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Hên nahêlêk na hila, ay wana kanla, “Pahlêk kaw kanlan pari ta êmên la ipamwang ya ayn kaw nan hakit.” Kaban ampammita hila, ay ampialíh ya hakit la. ");
INSERT INTO sgb_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Hên napansin la, ya naalíh ya hakit la, ay nag-orong ya miha kan Apo Jesus, haka na in-ikhaw ya pamagpuri na kan Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nandoko ya ha arapan ni Apo Jesus, ta nagpahalamat. Habayto ay mihay taga-probinsyan Samaria. ");
INSERT INTO sgb_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Bayo hinabi ni Apo Jesus, ya wana, “Mapo ya inalihan hakit. Ato hilay nay siyam? ");
INSERT INTO sgb_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Pata ayn nag-orong kanla hên nagpuri kan Apo Namalyari? Hatsin bêngat ya alwan Israelita ya nag-orong.” ");
INSERT INTO sgb_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Amêhên, hinabi ni Apo Jesus kana, “Mita kay na, ta naalíh ya hakit mo gawan ha paniwala mo.” ");
INSERT INTO sgb_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Minghan, ay labay lan Pariseo hên mamwangan kan Apo Jesus no makanon lumatêng ya pamanlokop ni Apo Namalyari. Kabay wani Apo Jesus kanla, “Ya umpisa hên pamanlokop ni Apo Namalyari ay a mahêlêk hên mata. ");
INSERT INTO sgb_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ayn makapaghabi hên, ‘Hêlkên yo! Nag-umpisay na di!’ o ‘Nag-umpisay na do!’ Ta ha kaptêgan, ya pamanlokop ni Apo Namalyari ay atsi ha nakêm lan ampaniwala kana.” ");
INSERT INTO sgb_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Bayo wana kanlan tagahonol na, “Lumatêng ya allo, ay labay-labay yon mahêlêk ya pamanlumatêng ko, ya Taga-Langit, ya In-anak Tawo. Noa, a yo ko mahêlêk. ");
INSERT INTO sgb_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Main maghabi kamoyu, ‘Nag-orong yay na ya Mesias, ya Cristo, ya Mámiligtas ta atsi ya di!’ Wanla êt hên kaatag, ‘Atsi ya bayro!’ Noa, paan kaw maniwala kanla, hên kihonol kanla hên manapol kangko. ");
INSERT INTO sgb_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ta no ay-êmên magkulibid ya kimat, ya mag-ahnag ha marayo, haka mahêlêk hên balang miha, ay êmbayro êt ya pag-orong ko, hên Taga-Langit, ya In-anak Tawo. ");
INSERT INTO sgb_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Noa, kailangan têêhên ko pon ya mal-at ya kairapan, ta araên la ko hên tawo amêhên. ");
INSERT INTO sgb_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","No ay-êmên ya karawakan pamimiyay la hên haton nabiyay hi apo Noe, ya nagpalokop kan Apo Namalyari, ay êmbayro êt mag-in narawak ya pamimiyay no marani yanay pag-orong ko, ya Taga-Langit, ya In-anak Tawo. ");
INSERT INTO sgb_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Hên haton nabiyay hi apo Noe, ay a la ginilam ya paypamwang na. Inhundo lan angkabiyay hên hato ya pangan, pamamminêm, haka pamiaahawa la angga ha hinumwên hilan apo Noe ha dinyag nay barko. Kabay naubuh hilan natsi ha lubug. ");
INSERT INTO sgb_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Êmbayro êt hên hato, hên nabiyay pon hi apo Lot. Inhundo lan taga-balayan Sodoma ya pangan la, pamamminêm la, kapanapolan la, pananêm la, haka pamadyag hên bali la. ");
INSERT INTO sgb_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Noa, ha allon pamag-alíh lan Lot bayro ha Sodoma, ay naubuh hilan natsi, gawan pinauranan na hila ni Apo Namalyari hên apoy haka sulpud. ");
INSERT INTO sgb_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Êmbayro êt ya malyari ha pag-orong ko, ya Taga-Langit, ya In-anak Tawo. ");
INSERT INTO sgb_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Habaytoy allo, no main atsi ha bubungan bali la, ay paan hilay nan tumaoy hên mangwan pibandian la ha lalên bali la. Paan hilay nan muli ya atsi ha panamnan. ");
INSERT INTO sgb_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ihipên yo ya nalyari ha ahawa ni apo Lot, hên haton natsi ya, gawan namalingay ya hên ampag-alíh hila ha balayan Sodoma. ");
INSERT INTO sgb_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Hilay a mabay hên mangoman ya pamimiyay la, ay maalihan hên biyay. Noa, hilay nakal-an hên manalibokot ha pamimiyay la, gawan ha paniwala la kangko, ay dyanan hên biyay ya ayn angga. ");
INSERT INTO sgb_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Pakagilamên yo, ha yabin pag-orong ko, no alimbawa ta main loway nabêlêw ha mihay papag, ay gêtan ha langit ya ampaniwala, noa, ibalag ta parusaan ya a ampaniwala. ");
INSERT INTO sgb_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","No alimbawa ta main loway babayi ya ampanggiling, ya ampaniwala ay gêtan ha langit, noa, ya a ampaniwala ay ibalag ta parusaan. ");
INSERT INTO sgb_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ha pag-orong ko, no alimbawa ta main loway lalaki ya ampilamo hên ampag-obra ha panamnan, ya ampaniwala ay gêtan ha langit, noa, ya a ampaniwala ay ibalag ta parusaan.” ");
INSERT INTO sgb_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Amêhên, nangotang hilay tagahonol ni Apo Jesus, ya wanla, “Panginoon, anton matupad ya habayto?” Kabay wani Apo Jesus kanla, “No anto ya bangkay, ay bayro êt mi-tsi-tsipon ya uwak.” ");
INSERT INTO sgb_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Amêhên, nangalimbawa yay na êt hi Apo Jesus, ta toroan na hilay tagahonol na ya kailangan panay hilan manalangin hên a hila humawa ha pamanalangin. ");
INSERT INTO sgb_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Hinabi ni Apo Jesus, ya wana, “Ha mihay balayan, ay main mánlingon kaso ya a angkalimo kan Apo Namalyari, haka ayn yan anggalangên ya tawo. ");
INSERT INTO sgb_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Bayro ha balayan, ay main babayi ya bawo, ya ayn têgên hên mangabala kanan hata mánlingon kaso, ta panhabiên na, ‘Hawpan mo kon lumaban ha kapatsi ko.’ ");
INSERT INTO sgb_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ha pangabala na kana, ay a na ya pon dinambi, noa, hên a nay na matêêh, ay wana ha nakêm na, ‘A ko angkalimo kan Apo Namalyari, haka ayn akon anggalangên ya tawo, ");
INSERT INTO sgb_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","noa, hawpan ko yay na, gawan ayn têgên ya pangabala na kangko, ta pêrad tana, a kina matêêh ya pangabala na kangko.’” ");
INSERT INTO sgb_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Amêhên, wani Apo Jesus kanla, “Pakaihipên yoy hinabi hên hatoy mánlingon kaso ya agyan narawak ya ugali na, ay nanawop ya kanan babayi ya bawo. ");
INSERT INTO sgb_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Hi Apo Namalyari pon kaya, ya makatoynungan, yarin a ya tambêng manawop kanlan pinili na hên mag-in kana, ya ampamaêg kana hên allo-yabi. ");
INSERT INTO sgb_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Panhabiên ko kamoyu, tambêng na hilan lingonên ha ikakangêd la. Noa, pamag-orong ko, ya Taga-Langit, ya In-anak Tawo, ay makalatêng ako kaya hên tawo ya main paniwala hên êmbayro, ya ayn têgên hên manalangin?” ");
INSERT INTO sgb_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nam-i yay na êt hi Apo Jesus hên hata alimbawa kanlan kaatag, ya êndat la no mahonol hila kan Apo Namalyari, bayo ammusmusên lay kapareho la. ");
INSERT INTO sgb_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Wana kanla, “Main loway lalaki ya hinumwên hên manalangin ha Templo. Ya miha ay Pariseo, haka ya miha ay máningil buwih. ");
INSERT INTO sgb_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nirêng ya Pariseo ha marayo-dayo, ta in-ikhaw nay panalangin na, ya wana, ‘Apo Namalyari, ampagpahalamat ako kamo, ta alwa kon nanad kanlan kaatag ya mapanakaw, mapanloko, haka mamabayi. Alwa ko êt nanad kanan hata máningil buwih. ");
INSERT INTO sgb_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Loway allo ha balang parominggo, ay ampagtêêh ko hên a ko ampangan, ta êmên a maabala ya panalangin ko kamo. Ampam-i ko êt kamon ikamapo hên kaganawan angkatsikap ko.’ ");
INSERT INTO sgb_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Noa, ya hatoy máningil buwih, ay ampanalangin ha marayo. A ya makatsingla, haka pandug-dugên na êt ya pagaw na gawan hadyay dêng-êy na, ta wana, ‘Apo Namalyari, ingalwan mo ko, ya mihay makasalanan.’ ");
INSERT INTO sgb_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Panhabiên ko kamoyu ya hatoy máningil buwih, ay nuli hên pinatawad ha kasalanan, noa, hatoy Pariseo, ay a pinatawad. Hilay mapagmatag-ay, ay iaypa, noa, hilay maaypa ya nakêm ay itag-ay.” ");
INSERT INTO sgb_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nanganaway anak man, ay anggêtan kan Apo Jesus, ta ihalangin na hila hên ipalunto nay gamêt na ha ulo la. Hên nahêlêk lan tagahonol ni Apo Jesus ya hata manianak-anak, ay binawal lay ampantan kanla. ");
INSERT INTO sgb_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Noa, binaêg ni Apo Jesus hilay manianak-anak, bayo wana kanlan tagahonol na, “Paulayan yo hilay anak hên paidani kangko. Paan yo hilan bawalên. Ta hilay maaypa ya nakêm ya nanad kanla, ay hila ya ilamo ha pamanlokop ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Pakagilamên yoy hatsi. Hilay a manoto ha paniwala hên nanaway anak ha pagpalokop la kan Apo Namalyari, ay a makapakilamo ha pamanlokop na.” ");
INSERT INTO sgb_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Main mihay Israelita, ya nagtungkulan, ya nangotang kan Apo Jesus, ya wana, “Mangêd ya Mánoro, hino ya dapat kon daygên, ta êmên ako madyanan hên biyay ya ayn angga?” ");
INSERT INTO sgb_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Wani Apo Jesus kana, “Pata binaêg mo kon mangêd? Hi Apo Namalyarin bêngat ya mangêd. ");
INSERT INTO sgb_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Muwang moy Kautuhan ni Apo Namalyari, ‘Paan mamabayi. Paan makilalaki. Paan mamatsin kaparehon tawo. Paan manakaw. Paan manistigos ha alwan kaptêgan. Galangên moy toa mo.’” ");
INSERT INTO sgb_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Bayo wanan lalaki, “Mánoro, panhonolên ko ya kaganawan ya habayto paubat hên anak ako pon.” ");
INSERT INTO sgb_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Hên nagilam ni Apo Jesus ya hinabi na, ay wana, “Miha pon ya kailangan mon daygên. Iubuh mon ihaliw ya pibandian mo, bayo idin moy habaytoy naablian kanlan mangairap, ta madyanan kan mantêg pibandian ha langit. Pangayari mon madyag ya habayto, ay mag-orong ka di, ta humonol ka kangko.” ");
INSERT INTO sgb_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Noa, hên nagilam nay hinabi ni Apo Jesus, ay naglungkot ya, ta miha yay mabandi. ");
INSERT INTO sgb_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Nadambi ni Apo Jesus ya naglungkot ya lalaki, kabay wana, “Taganán alwan nataluh hên makapakilamo ha pamanlokop ni Apo Namalyari ya hilay mabandi! ");
INSERT INTO sgb_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Pêtêg ya. Nataluh hên magdann ha lubot karayêm ya mihay kamelyo kanan makapakilamo ha pamanlokop ni Apo Namalyari ya mihay mabandi.” ");
INSERT INTO sgb_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Hilay nakagilam hên habayto, ay nangotang, “Hino awud ya miligtas, hên makapakilamo ha pamanlokop ni Apo Namalyari?” ");
INSERT INTO sgb_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Wani Apo Jesus, “Ya a madyag hên tawo, ay madyag ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Amêhên, wani Pedro, “Ay-êmên kay, ya tagahonol mo? Imbalag naên ya bali naên, ta êmên kay humonol kamo.” ");
INSERT INTO sgb_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Hinabi etaman ni Apo Jesus, “Pakagilamên yo! Hilay nangibalag bali la, o ahawa la, o kapotoh pohêl la, o toa la, o anak la, gawan ha pagpalokop la ha pamanlokop ni Apo Namalyari, ");
INSERT INTO sgb_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ay madyanan hên mal-at kanan imbalag la, kaban atsi hila pon di ha luta. Bayo lano madyanan hila êt hên biyay ya ayn angga.” ");
INSERT INTO sgb_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Impapawa ni Apo Jesus ya labinloway tagahonol na, ta wana kanlan bêngat, “Pakagilamên yo! Anlumakat kitamo ha Jerusalem, ta maubuh hên matupad ya hinulat lan mámipamwang hên an-ipaihip kanla ni Apo Namalyari ya tungkol kangko, ya Taga-Langit, ya In-anak Tawo. ");
INSERT INTO sgb_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ta idin la ko kanlan alwan Israelita. Musmusên la ko, dul-an la ko, ");
INSERT INTO sgb_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","pagpapatokên la ko, bayo la ko patsên. Noa, ha ikatlon allo, ay mabiyay kon oman!” Habaytoy hinabi ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Noa, a naintindihan hên labinloway tagahonol na, ya nagilam la, gawan habayto ay a pon impamwang kanla, kabay a la nakway labay nan habiên. ");
INSERT INTO sgb_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Amêhên, hên andumani hilan Apo Jesus ha balayan Jerico, ay main bayron buwag ya ampikno ha danin dann ya ampakikwan pera. ");
INSERT INTO sgb_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Hên nagilam nay kal-atan ya ampipagdann ha dani na, ay labay nan mamwangan no hinoy angkalyari. ");
INSERT INTO sgb_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Main naghabi kana ya hi Apo Jesus ya taga-balayan Nazaret ay ampagdann bayro. ");
INSERT INTO sgb_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kabay nan-angaw ya, ya wana, “Apo Jesus, ya kaapo-apoan ni Arin David, ingalwan mo ko dayi!” ");
INSERT INTO sgb_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Binawal yan maglabak hên hatoy ampita ha unaan lan Apo Jesus, noa, impakakhaw nan in-angaw, “Kaapo-apoan ni Arin David, ingalwan mo ko dayi!” ");
INSERT INTO sgb_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Hên nagilam ni Apo Jesus ya angaw na, tinunggên ya ta main yan in-utoh, ta akayên lay buwag hên idani kana. Hên narani yanay buwag, ay wani Apo Jesus kana, ");
INSERT INTO sgb_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Hinoy labay mon daygên ko kamo?” Amêhên, wanan buwag, “Panginoon, labay kon makahêlêk ako.” ");
INSERT INTO sgb_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Kabay hinabi ni Apo Jesus, “Makahêlêk ka, gawan ha paniwala mo kangko.” ");
INSERT INTO sgb_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tambêng yan nakahêlêk, kabay nakihonol yay na kan Apo Jesus kaban ampuriên na hi Apo Namalyari. Hên nahêlêk lan atsi bayro ya nalyari, ay pinuri la etaman hi Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nilumatêng hilan Apo Jesus ha balayan Jerico, ta bayro hilan nipadann ha balayan. ");
INSERT INTO sgb_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Main lalaki bayro ya nag langan Zaqueo. Hi Zaqueo ay ampamaala kanlan mangwan buwih, kabay mabandi ya. ");
INSERT INTO sgb_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Labay na dayin mahêlêk hi Apo Jesus, ta êmên na ya mapuliah, noa, a na ya mahêlêk, gawan kal-atan, ta pandak yan kit. ");
INSERT INTO sgb_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kabay ya dinyag na, ay nuwayu ya ha unaan lan Apo Jesus, ta nunik ya ha kayon sikomoro, ta êmên na ya mahêlêk. ");
INSERT INTO sgb_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nahên niabot hilan Apo Jesus ha nag kayo, ay tsiningla na ya, ta wana, “Zaqueo, galingên mon tumaoy, ta maniraw ako ha bali mo amêhên.” ");
INSERT INTO sgb_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Kabay ginaling nan tinumaoy, ta mahigla yan nanagyat kanlan Apo Jesus ha bali na. ");
INSERT INTO sgb_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Hilay kal-atan ya atsi bayro ay nanotol, ya wanla, “Awta bay maniraw hi Apo Jesus ha balin makasalanan!” ");
INSERT INTO sgb_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kaban ampikno hila ha bali lan Zaqueo ay nirêng ya hi Zaqueo, ta wana kan Apo Jesus, “Panginoon, ya kagitna hên pibandian ko ay idin ko kanlan ampangailangan. Ha balang miha ya pinirayit ko, ay iorong ko hên kaapat ya napirayit ko kanla.” ");
INSERT INTO sgb_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Nahên nagilam ni Apo Jesus ya hinabi na, ay wana, “Amêhên ay nailigtas ya hata pamilya, ta hi Zaqueo ay ampaniwala kan Apo Namalyari hên nanad ha paniwala hên ninuno yo hi apo Abraham. ");
INSERT INTO sgb_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Gawan hiko ya Taga-Langit, ya In-anak Tawo, ay atsi ko di ha luta ta êmên ko hila tapolên haka iligtas ha kaparusaan ya hilay nitama.” ");
INSERT INTO sgb_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Kaban anggilamên lay habi ni Apo Jesus, ay in-istorya na ya hata alimbawa, gawan marani yay nan lumatêng ha balayan Jerusalem. Haka gawan êndat la no tampol mipairêng bayro ya pamanlokop ni Apo Namalyari, haka bayron mikno hi Apo Jesus hên mamaala kanla ha bansan Israel. ");
INSERT INTO sgb_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kabay impamwang ni Apo Jesus kanla no ay-êmên ya dapat mag-in pamimiyay la, kaban an-êngganan lay pag-orong na, ta wana, “Main mihay nag tungkulan, ya mita ha marayoy bansa, ta tanggapên nay karapatan nan mag-ari, bayo mag-orong yay na ta êmên ya mamaala ha kabansa na. ");
INSERT INTO sgb_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Bayo ya nammita ay binaêg nay mapo kanlan ipoh na, ta binalagan na hila hên tsi-tsi mihan pera ya ginto, ta wana kanla, ‘Pakal-atên yoy hata pera, ta êmên ya lum-at kaban ayn ako pon di.’ ");
INSERT INTO sgb_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Amêhên, gawan angkahêmêkan la yan kabansa na, ay ha pammita na, ay main hilan in-utoh ha nag tungkulan bayro ha marayoy bansa, ta wanla, ‘A naên labay ya habaytsi hên mag-in ari naên.’ ");
INSERT INTO sgb_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Êmbayro man, hiya ay nag-in ari, bayo nag-orong yay na. Nahên nilumatêng ya ha bali na, ay impabaêg nay ipoh na, ta êmên na mamwangan no ungnoy tubo la ha imbalag nay pera kanla. ");
INSERT INTO sgb_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Dinumani kana ya una, ta hinabi na, ya wana, ‘Apo, ya pera moy ginto ay tinumubo hên mapoy peran ginto.’ ");
INSERT INTO sgb_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“‘Magaling,’ wanan ari, ‘Hika ay mihay mangêd ya ipoh. Gawan mapaypaniwal-an ka ha pêrad, ay manalan ka hên mapo ya balayan.’ ");
INSERT INTO sgb_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Nilumatêng ya ikalwan ipoh, ta wana, ‘Apo, ya pera moy ginto ay tinumubo yan limay pera ya ginto.’ ");
INSERT INTO sgb_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Kabay hinabi nan ari kana, ya wana, ‘Hika ay manalan hên limay balayan.’ ");
INSERT INTO sgb_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Amêhên, nilumatêng yay na êt ya mihay ipoh, ta wana, ‘Apo, atsi di ya pera moy ginto, ya impunggoh ko ha panyo ko, bayo ko ya inhinêp. ");
INSERT INTO sgb_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Dinyag koy habayto ta malimo ko kamo. Muwang ko ya hadyay igpit mo. Ampangwa ka hên alwa mon pinaghayngêtan, bayo ampamutsi kan alwa mon intanêm.’ ");
INSERT INTO sgb_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Kabay hinabi nan ari kana, ya wana, ‘Hika ay mihay narawak ya ipoh. Gawan ha habi mo, ay hatolan ka hên parusaan. Muwang mo awud ya maigpit ako. Ampangwa kon alwa kon pinaghayngêtan, bayo ampamutsi ko hên alwa kon intanêm. ");
INSERT INTO sgb_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","No êmbayro awud, awta a mo indin ya pera ko ha bangko, ta êmên mo dayin maiorong kangko ya habayto hên kalamoy tubo ha bangko?’ ");
INSERT INTO sgb_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Bayo wana kanlan atsi bayro, ‘Kowên yoy peray ginto, ya atsi kana, ta idin yo ha main mapo.’ ");
INSERT INTO sgb_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Noa, hinabi la kana, ‘Apo, main yay nan mapo!’ ");
INSERT INTO sgb_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Kabay hinabi nan ari, ‘Anhabiên ko kamoyu, hilay tapat ha pamanggamit hên indin kanla, ay dyanan ko pon êt. Noa, hilay alwan tapat ha pamanggamit hên indin kanla, ay alihên êt kanla ya pêrad ya atsi kanla. ");
INSERT INTO sgb_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Amêhên, gêtan yo di kangko hilay kapatsi ko, ya a nabay hên hiko ay mag-in ari la, ta patsên yo hila ha arapan ko.’” ");
INSERT INTO sgb_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ubat nan hinabi ya habayto ni Apo Jesus, ay inhundo lay pammita la ha Jerusalem. Hi Apo Jesus ay ampammita ha arapan lan kalamo na. ");
INSERT INTO sgb_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nahên andumani hilay na ha baryon Betfage, haka baryon Betania ha Tawgtug Olibo, ay impauna ni Apo Jesus ya lowa kanlan tagahonol na, ta wana kanla, ");
INSERT INTO sgb_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Muna kaw ha humonoy baryo. Panhumwên yo bayro, ay mahêlêk yoy mihay biseron asno, ya nakah-êl, ya a pon nahakyan. Okalên yoy habayto, ta gêtan yo di. ");
INSERT INTO sgb_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","No main mangotáng kamoyu no awta an-okalên yoy habayto, ay habiên yo, ‘Kailangan yan Panginoon.’” ");
INSERT INTO sgb_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kabay nammita hilay nay loway in-utoh na. Haka natapol la etaman ya biseron asno ya nanad hinabi ni Apo Jesus kanla. ");
INSERT INTO sgb_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kaban an-okalên la ya, ay hinabi lan nag asno, ya wanla, “Pata an-okalên yoy habain ya bisero?” ");
INSERT INTO sgb_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Hinabi lan in-utoh ni Apo Jesus, ya wanla, “Kailangan yan Panginoon.” Kabay pinaulayan hila etaman. ");
INSERT INTO sgb_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","In-akay lay bisero kan Apo Jesus, haka la inamakan pangkêbêl la, bayo himmakay hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Inhundo lan Apo Jesus ya pammita lan palakon Jerusalem. Ha pandanan lan Apo Jesus, ay nami-amak hilay atsi bayro hên pangkêbêl la, gawan ha panggalang la kana. ");
INSERT INTO sgb_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nahên andumani hilay na ha palohan ha Tawgtug Olibo, ay nagkanta hila hên bapan higla, hilay kal-atan ya antoroan na ya anhumonol kana, ta ampuriên la hi Apo Namalyari, gawan ha nahêlêk lay kapapaêpapah ya dinyag ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ya pamagpuri la ay êmên di, “Puriên ya ampamaala ya in-utoh ni Apo Namalyari! Nakapakiúmang kitamo kan Apo Namalyari! Puriên hi Apo Namalyari!” ");
INSERT INTO sgb_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Amêhên, bayro ha kal-atan ya anhumonol kan Apo Jesus, ay main ungnoy Pariseo ya naghabi kana, ya wanla, “Mánoro, bawalên moy tagahonol mo hên magpuri kamo.” ");
INSERT INTO sgb_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Kabay wani Apo Jesus, “Anhabiên ko kamoyu, no a la kon puriên hên habaytsi ya tagahonol ko, ay hilay bato tana ya magpuri kangko.” ");
INSERT INTO sgb_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nahên narani hilan Apo Jesus ha balayan Jerusalem, hên nahêlêk nay balayan, ay tsinangihan nay taga-Jerusalem, ");
INSERT INTO sgb_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ta wana, “No muwang yo dayi amêhên no hino ya mam-in kapatêkbêkan nakêm yo, ay alwa kaw dayin kapaingalo! Noa, a yo muwang. ");
INSERT INTO sgb_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Lumatêng lano ya allo ay libotên la kaw hên kapatsi yo êmên a kaw makaalíh. Bayo hipitên la kaw angga ha mamalibot. ");
INSERT INTO sgb_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Hiraên lay balayan yo angga ha mag-in patag ya ubatan bali yo. Patsên lay hinoman ya atsi bayro, gawan a yo dinambi hi Apo Namalyari hên nilumatêng ya hên mamiligtas kamoyu.” ");
INSERT INTO sgb_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Amêhên, ay hinumwên ya hi Apo Jesus ha Templo, ta intaboy na hilay ampipagtinda hên ayop ya gamitên ha átang. ");
INSERT INTO sgb_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Hinabi na kanla, ya wana, “Nakahulat ha habi ni Apo Namalyari, ya wanan hulat, ‘Ya bali ko ay ambaêgên balin panalanginan.’ Noa, dinyag yo yan logal ya panlokoan yon kapareho yo!” ");
INSERT INTO sgb_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Allo-allo ay nanoro ya hi Apo Jesus ha Templo. Noa, labay la yan patsên lan mánoron Kautuhan ni apo Moises. Labay la yan patsên hên toa ya nag tungkulan ha bansa. Haka labay la ya êt hên patsên lan ampamaala kanlan pari. ");
INSERT INTO sgb_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Noa, a la ya mapatsi, ta mal-at ya labay-labay hên manggilam habi na. ");
INSERT INTO sgb_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Mihay allo hên atsi ya hi Apo Jesus ha Templo hên ampamitoro hên Mangangêd ya Habi, ay dinumani kana hilay mánoron Kautuhan ni apo Moises, ya hilay toa ya nag tungkulan ha bansa, haka hilay ampamaala kanlan pari. ");
INSERT INTO sgb_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Hinabi la kana, “Habiên mo kannaên no hinoy tungkulan mo hên manyag hên pandaygên mo. Habiên mo êt no hinoy nam-i kamo hên habain ya tungkulan.” ");
INSERT INTO sgb_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Kabay wani Apo Jesus, “Main ako pon hên kotangên kamoyu. ");
INSERT INTO sgb_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Hinoy nam-i hên tungkulan kan Juan Bautista hên mamawtismo? Hi Apo Namalyari o tawo?” ");
INSERT INTO sgb_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kabay pinihahabian la, ya wanla, “Hinoy habiên tamo? No habiên tamo ya ‘Ubat kan Apo Namalyari ya tungkulan ni Juan Bautista,’ ay habiên na bayto, ‘Pata a yo yan pinaniwal-an?’ ");
INSERT INTO sgb_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Noa, no habiên tamo ya ‘Ubat ha tawo,’ ay batoên la kitamo, hên kal-atan di, ta ha ihip la, hi Juan ay mihay propeta ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kabay hinabi la kan Apo Jesus, ya wanla, “A naên muwang no antoy ubatan tungkulan ni Juan Bautista.” ");
INSERT INTO sgb_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Bayo wani Apo Jesus, “No êmbayro awud, ay a ko etaman habiên kamoyu no antoy ubatan tungkulan ko.” ");
INSERT INTO sgb_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Amêhên, nangalimbawa yay na êt hi Apo Jesus, ya wana kanlan ampanggilam, “Minghan main lalaki ya nag luta ya tinamnan nan ubas. Impatsiwala na ha kaatag ya ubasan na, ta maglaêh ya ha kaatag ya bansa. ");
INSERT INTO sgb_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Hên pamutsi hên habaytoy ubas, ay in-utoh nay mihay ipoh na, hên kowên ya atag na kanlan paypaniwal-an ubasan na. Noa, tinumbuk lay ipoh na, bayo impaorong la ya, hên ayn anggêtan. ");
INSERT INTO sgb_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kabay in-utoh nay na êt ya kaatag ya ipoh na, noa, tinumbuk la ya êt, impakarêng-êy la ya, bayo impaorong la ya hên ayn anggêtan. ");
INSERT INTO sgb_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nahên in-utoh nay na êt ya ikatlon ipoh na, ay hinugat-hugat la ya êt, bayo impaplag la ya. ");
INSERT INTO sgb_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Kabay, pan-ihip-ihipên nan nag ubasan no hino ya daygên na. Naihipan nan iutoh ya anlugurên nan anak nay lalaki, ta wana, ‘Siguradon igalang lay anak ko.’ ");
INSERT INTO sgb_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Noa, hên nahêlêk lan paypaniwal-an ubasan ya anak nan nag ubasan, ay nihahabi hila, ya wanla, ‘Hatsi ya paypamanaan na hên ubasan. Patsên tamo ya, ta êmên mapagbandi tamo ya hata ubasan na.’ ");
INSERT INTO sgb_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kabay pinaalíh la ya ha ubasan ta pinatsi la ya.” Amêhên, kinotang ni Apo Jesus hilay ampanggilam, “Hino kaya ya daygên hên nag ubasan kanlan paypaniwal-an na? ");
INSERT INTO sgb_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Siguradon lakwên nay paypaniwal-an na, ta patsên na hila, bayo ipatsiwala nay na ha kaatag ya ubasan na.” Hên nagilam lay habayto, ay wanla, “Paan dayin malyari ya habayto!” ");
INSERT INTO sgb_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Noa, pinakahêlêk ni Apo Jesus hilay ampamaala ha Templo, ta wana kanla, “Hino awud ya labay habiên hên habaytsi ya nakahulat ha Kahulatan ya impahulat ni Apo Namalyari? ‘Ya bato ya intapon lan manyag bali, ay nag-in pinakamaalagáy bato ta êmên mag-in napah-êy ya bali.’ ");
INSERT INTO sgb_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Hilay matata kanan hata bato ay mangatutukihan but-o, haka hilay matat-an hên hata bato ay mangatatapong.” ");
INSERT INTO sgb_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Naintindihan lan mánoron Kautuhan ni apo Moises haka hilay ampamaala kanlan pari, ya hilay in-alimbawa di ha manyag bali, haka ha nangarawak ya paypaniwal-an ubasan, kabay labay la yan tambêng hên dakpên, noa, malimo hila ha kal-atan. ");
INSERT INTO sgb_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kabay inimatonan la ya haka hila namiutoh hên ungno ya waringan mangêd hila, ya mangotáng kan Apo Jesus. Noa, labay la yan madakêp ha pamaghabi na, ta êmên la ya magêtan ha kapangyarihan hên gobernador. ");
INSERT INTO sgb_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Amêhên, hinabi lan hata magbabara kan Apo Jesus, “Mánoro, muwang naên ya kaptêgan ya panhabiên mo haka panoro mo. An-itoro moy kalabayan ni Apo Namalyari, ha hinoman ya ampanggilam gawan alwa kan mapamili, ta pantag ya panlêk mo ha balang miha. ");
INSERT INTO sgb_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kabay main kay hên labay mamwangan kamo. Ayon ha Kautuhan tamon Israelita, ay malyarin mam-in buwih kanan Emperador o ahê?” ");
INSERT INTO sgb_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Noa, muwang ni Apo Jesus ya pagbabara la, kabay hinabi na kanla, ya wana, ");
INSERT INTO sgb_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ipahlêk yo kangko ya mihay sintimos hên pilak. Hinoy nag lupa hên angkakit yo bahên? Hinoy nag langan ya nakahulat bahên?” Hinabi la etaman, “Kanan Emperador.” ");
INSERT INTO sgb_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Kabay wani Apo Jesus, “No êmbayro awud, ay idin yo kanan Emperador ya kana, haka idin yo kan Apo Namalyari ya kan Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kabay a la ya madakêp hi Apo Jesus ha habi na ha arapan lan kal-atan. Ayn hilay nan mahabi ta nag-êpapah hila ha habi na. ");
INSERT INTO sgb_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Amêhên, ay main ungno ha mihay pangkat lan Israelita ya ambaêgên Saduseo ya dinumani kan Apo Jesus. Hilay Saduseo ay a ampaniwala ha pangabiyay oman. Haka hinabi la kan Apo Jesus, ya wanla, ");
INSERT INTO sgb_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Mánoro, nanulat ya hi apo Moises ha Kautuhan hên para kantamo, ya wanan hulat, ‘No main mitaahawa, ta natsi ya lalaki hên a hila nagkaanak, ay dapat ya kahonol nan natsi, ay ipaahawa kanan bawo. No magkaanak hila, ay habaytoy anak, ay itad anak nan natsi.’ ");
INSERT INTO sgb_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Minghan, ay main pitoy mikakahonol ya lalaki. Nakapag-ahawa ya punganay, noa, natsi ya hên a ya nagkaanak. ");
INSERT INTO sgb_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Bayo pinag-ahawa nan humonol ha punganay ya hata bawo, noa, natsi ya etaman ya humonol ha punganay hên a nagkaanak. ");
INSERT INTO sgb_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Êmbayro êt ya nalyari ha ikatlon kahonol. Balang miha kanlan pitoy mikakahonol ay nakapag-ahawa hên hata babayi, noa, naubuh hilan natsi hên a nagkaanak. ");
INSERT INTO sgb_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Bayo natsi ya êt ya hata bawo. ");
INSERT INTO sgb_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Amêhên, ha allon mangoman mabiyay, hinoy nay taganán mag-in ahawa nan hata babayi, ta balang miha kanlan habaytoy pitoy mikakahonol ay nag-in ahawa na?” ");
INSERT INTO sgb_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Kabay wani Apo Jesus kanlan Saduseo, “Ya pamag-ahawa ay din bêngat amêhên ha luta. ");
INSERT INTO sgb_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Hilay babayi haka lalaki ya an-itad ni Apo Namalyari hên anak na, ya biyayên nan oman, ay a hilay nan mag-ahawa ha ikalwan biyay. ");
INSERT INTO sgb_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Manoto hilay na kanlan anghel ha langit, ya a ampag-ahawa, haka a hilay na matsi. Hila ay anak ni Apo Namalyari ta biniyay na hilan oman. ");
INSERT INTO sgb_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Agyan ya hulat ni apo Moises ay ampamaptêg ya biyayên oman ya nangamatsi, ta bayro ha hulat na ya tungkol ha maaypa ya kayoy andungkêt, mabáha tamo ya hinabi ni apo Moises hên tungkol kan Apo Namalyari ya hiyay ‘Diyos ni Abraham, Isaac, haka ni Jacob.’ ");
INSERT INTO sgb_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Hiyay alwan Diyos lan natsi, noa, hiyay Diyos lan angkabiyay, ta balang miha ya natsi, ay angkabiyay ha hêlêk na.” ");
INSERT INTO sgb_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Main ungno kanlan mánoron Kautuhan ni apo Moises ya naghabi, ya wanla, “Mangêd ya hinabi mo, Mánoro.” ");
INSERT INTO sgb_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Hinabi lay habayto, ta marêng-êy hilay na hên mangotáng pon kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Amêhên, hinabi ni Apo Jesus kanla, ya wana, “Ay-êmên lan mahabi ya Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala ay kaapo-apoan bat ni Arin David? ");
INSERT INTO sgb_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Mismon hi Arin David, ya ninuno tamo, ay namihulat ha Kahulatan ha Awit hên tungkol ha Mesias, ya Cristo, ya wana, ‘Hinabi ni Apo Namalyari ha Panginoon ko, “Mikno ka ha dapit panabtab ko hên mamaala hên kalamo ko, ");
INSERT INTO sgb_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","angga ha mahambut ko hilay kapatsi mo, ta idin ko hila ha aypan kapangyarihan mo.”’ ” ");
INSERT INTO sgb_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Wana êt ni Apo Jesus, “Hên hato, ay hi Arin David ya namaêg hên ‘Panginoon ko,’ ha Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala. Kabay muwang tamo, ya hiyay Panginoon haka kaapo-apoan ni Arin David.” ");
INSERT INTO sgb_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kaban ampanggilam hilay kal-atan, ay hinabi ni Apo Jesus kanlan tagahonol na, ya wana, ");
INSERT INTO sgb_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Kaillag kaw ha toro lan mánoron Kautuhan ni apo Moises. Labay-labay la hên mibita-bita hên nakatakop hên makarang, ta êmên ipamwang ya matag-ay ya tungkulan la. Labay la êt hên galangên, haka dayêwên hila hên kal-atan ha balayan. Ya kaatag pon ya andaygên la ta êmên ipamwang ya matag-ay ya tungkulan la, ay ampiliên lay pinakamangêd ya iknoan ha sinagoga haka ha kaluto. ");
INSERT INTO sgb_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Anlokoên la êt ya bawo ya babayi, ta êmên la makwa ya pibandian la, bayo magma-mangêd hilan ikarang ya panalangin la ha arapan hên kal-atan. Kabay hadyay pamarusa kanla lano!” ");
INSERT INTO sgb_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Kaban atsi ya pon ha Templo hi Apo Jesus, ay napansin na hilay mabandi, ya ampam-in alay la ha pamyanan alay. ");
INSERT INTO sgb_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nadambi na etaman ya mihay bawo ya babayi, ya mairap, ya nam-in lo-loway sintimos ha pamyanan alay. ");
INSERT INTO sgb_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kabay wani Apo Jesus kanlan tagahonol na, “Pakagilamên yo, hata bawo ay nam-i hên mal-at kanan indin lan kal-atan mabandi. ");
INSERT INTO sgb_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ta hilay kaatag ay nam-i hên a la pon kailangan, noa, hata bawo ay in-ubuh nan indin ya panaliw nan maêkan na.” ");
INSERT INTO sgb_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Hilay ungno kanlan tagahonol ni Apo Jesus ay ampihahabian lay kahampatan hên Templo. No ay-êmên kahampat ya bato ya pinaglolog haka ya kahampatan hên hino-hino kay na hên ya impapadpak ha lolog. ");
INSERT INTO sgb_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Amêhên, hinabi ni Apo Jesus, ya wana, “Lumatêng lanoy allo, ay manga-aagwat ngan ya hata bato ya pinaglolog ya angkahêlêk yo.” ");
INSERT INTO sgb_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Amêhên, nangotang hilay tagahonol na kana, “Mánoro, makanon malyari ya habayto, haka ay-êmên naên mamwangan no maranin malyari ya habayto?” ");
INSERT INTO sgb_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Kabay wani Apo Jesus, “Kaillag kaw, ta êmên a kaw maloko, ta mal-at ya maghabin êmên di, ‘Hiko ya Cristo ya impangako ni Apo Namalyari. Nilumatêng ya panaon hên anggaan hên luta.’ Yabay ya habiên la, noa, paan kaw maniwala kanla. ");
INSERT INTO sgb_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Paan kaw malimo ha magilaman yoy tungkol ha manigulo-gulo haka pa-tsian, ta habayto ay kailangan lumatêng pon, noa, a pon tambêng lumatêng ya anggaan hên luta.” ");
INSERT INTO sgb_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Amêhên, inhundo nay na êt ni Apo Jesus ya pamaghabi na, ya wana, “Milalaban hilay bansa haka hilay angkalokopan hên mihay bansa ay milalaban ha kabansa la. ");
INSERT INTO sgb_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Lumatêng ya mangakhaw ya layon. Lumatêng êt ya hadyay lonoh haka salot ya ubatan hên hino-hino kay na hên ya hakit ya ikamatsi lan tawo ha mal-at ya logal. Lumatêng êt ya kapalimo haka kapapaêpapah ya mangalyari ha angkahêlêk ha langit. ");
INSERT INTO sgb_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Noa, bayo malyari ya habayto, ay dakpên la kaw, haka pairapan la kaw, ta gêtan la kaw kanlan toa ya nag tungkulan ha hinon sinagoga, kotangên la kaw, bayo ikulung la kaw. Gawan ha paniwala yo kangko, ay gêtan kaw kanlan ari haka gobernador. ");
INSERT INTO sgb_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ha êmbayro ay maipamwang yo kanla ya Mangêd ya Habi tungkol kangko. ");
INSERT INTO sgb_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Uston iarap la kaw kanlan manungkulan, ay pataniêhên yoy nakêm yo. A kaw manyagah no hinoy habiên yo hên pamakibat ha kotang la, ");
INSERT INTO sgb_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ta ipaihip ko kamoyu ya mangêd yon habiên, ya a la kayan labanan o hambutên hên kapatsi yo. ");
INSERT INTO sgb_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Miha êt, hila man ya toa yo, kapotoh pohêl yo, kaatag êt ya kamag-anak yo, haka hilay kaluguran yo ay may-upit kamoyu, kabay ya kaatag kamoyu ay patsên. ");
INSERT INTO sgb_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kahêmêkan kaw hên kal-atan gawan paniwala yo kangko. ");
INSERT INTO sgb_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Noa, a na kaw paulayan ni Apo Namalyari, ta miha man ya habot ulo yo, ay a miabot ha impiyerno. ");
INSERT INTO sgb_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Têêhên yoy habayto, ta êmên kaw madyanan hên biyay ya ayn angga.” ");
INSERT INTO sgb_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Uston mahêlêk yoy balayan Jerusalem ya napalibutan hên hundaloh, ay mamwangan yoy na bayto ya marani yana ya pamanira kana. ");
INSERT INTO sgb_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ha allon habayto ay kailangan muwayun magtago ha babo, ya hilay taga-probinsyan Judea. Hilay atsi ha balayan Jerusalem ay kailangan hên mag-alíh. Hilay atsi ha pananêman la, ay paan mag-orong ha balayan. ");
INSERT INTO sgb_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Gawan habaytoy panaon hên pamarusa, ta êmên matupad ya nakahulat, ya impamwang lan mámipamwang hên an-ipaihip kanla ni Apo Namalyari hên hato. ");
INSERT INTO sgb_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kanan habayto, ay kaingalo hilay nabuktot haka hilay ampamahoho, ta mabyat ya kairapan ya maranasan la di ha luta, ta ya tobag ni Apo Namalyari ay lumatêng kanlan Israelita. ");
INSERT INTO sgb_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Main hên matsi ha gulo, bayo ya kaatag ay gêtan ta ikulung ha marayo ya bansa. Ya balayan Jerusalem ay pakahiraên lan alwan Israelita, ya a ampagpalokop kan Apo Namalyari, angga ha mayari ya panaon ya indin kanla.” ");
INSERT INTO sgb_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Wana êt ni Apo Jesus, “Pangayarin habaytoy hadyay kairapan, ay mahêlêk yoy kapapaêpapah ha allo, ha buwan, haka ha bêtêwên. Alwan bêngat habayto, noa, man-awk êt ya tandulon ha dagat kabay manyagah hilay tawo ha balang bansa. ");
INSERT INTO sgb_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Hilay tawo ay mangabunsol, gawan hadyay limo la kaban an-ihipên lay angkalyari ha boon luta, ta mayêgyêg hilay bêtêwên haka maubuh hên mangayêgyêg ya angkahêlêk ha langit. ");
INSERT INTO sgb_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kanan habayto, ay mahêlêk la ko ha lêmm, ya Taga-Langit, ya In-anak Tawo, ya anlumatêng, hên main kapangyarihan, haka ya kapahilêw ya kahampatan ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Wanay na êt ni Apo Jesus kanlan tagahonol na, ya wana, “No mag-umpisan malyari ya habayto ya kapapaêpapah, ay pataniêhên yoy nakêm yo, ta marani yanay pangakbus kamoyu.” ");
INSERT INTO sgb_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Bayo wani Apo Jesus hên nangalimbawa, “Hêlkên yoy poon kayon igos, haka kaatag êt ya poon kayo. ");
INSERT INTO sgb_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","No mamayo yan bulong, ay muwang yoy na ya marani yanay kaingitan. ");
INSERT INTO sgb_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Êmbayro êt, no mahêlêk yoy nan maubuh hên malyari ya habayto ya kapapalimo, ay mamwangan yoy marani yanay pamanlokop ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Pakagilamên yo. Maubuh hên matupad ya habayto kaban main pon di ha luta hên kapareho yon Israelita. ");
INSERT INTO sgb_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ya angkahêlêk ha langit, haka ya luta ay main anggaan, noa, ya habi ko ay ayn anggaan.” ");
INSERT INTO sgb_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Hinabi nay na êt ni Apo Jesus, ya wana, “Kaillag kaw ta êmên a kaw mipahobohob ha kahibaan, pamaglahing, haka kayagahan ha kailangan yo ha biyay di ha luta. Ta êmên a kataw malatngan ya a nakal-an ha allon pamanlumatêng kon oman. ");
INSERT INTO sgb_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Gawan ha biglan lumatêng ya habaytoy allo, ay maubuh hên mabigla hilay tawo ha boon luta. ");
INSERT INTO sgb_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kabay kailangan panay kaw nakal-an ha balang oras. Dapat panay kaw manalangin ya dyanan na kaw hên hêkaw, ta êmên a kaw mahambut hên hinoman ya angkalyari di, ta êmên kaw makapakiarap kangko, ya Taga-Langit, ya In-anak Tawo.” ");
INSERT INTO sgb_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Allo-allo ay ampanoro ya hi Apo Jesus ha Templo ya atsi ha balayan Jerusalem. Balang yabi ay anlumakat ya ha Tawgtug Olibo ta bayro yan ampagdahêl. ");
INSERT INTO sgb_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kabay maranon hên allo-allo, ay ampammita ya kal-atan, hên manggilam toro na ha Templo. ");
INSERT INTO sgb_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Amêhên, ay marani yanay pista lan Israelita ya ambaêgên lan Pistan Puto ya ayn Pampaalsa haka ya Pistan Pangaligtas ha Egipto. ");
INSERT INTO sgb_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Hilay mánoron Kautuhan ni apo Moises, haka hilay ampamaala kanlan pari, ay ampamulong kan Apo Jesus, no ay-êmên la yan maipapatsi hên ayn makamwang, gawan malimo hila ha kal-atan, ya ampanggilam toro na. ");
INSERT INTO sgb_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Amêhên, hi Satanas ay hinumapat kan Judas, ya ambaêgên lan Iscariote, ya miha kanlan labinloway tagahonol ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Kabay nammita yay na hi Judas hên makihabi kanlan ampamaala kanlan pari haka kanlan ampamaala kanlan bantay ha Templo, no ay-êmên na mai-upit hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Hinumigla hila etaman ya i-upit ni Judas hi Apo Jesus kanla, haka nangako hila ya dyanan la yan pera. ");
INSERT INTO sgb_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nabay ya etaman hi Judas, kabay paubat hên habayto, ay ampangihip yay na no ay-êmên na yan maidin ha gamêt la, hên a mamwangan hên kal-atan. ");
INSERT INTO sgb_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Amêhên, nilumatêng ya unan allo hên Pistan Puto ya ayn Pampaalsa. Habaytoy allon pamatsi lan Israelita hên anak tupa, ya kênaên la no manaboy nay allo hên habayton yabi hên Pistan Pangaligtas ha Egipto. ");
INSERT INTO sgb_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Namipal-an hi Apo Jesus kan Pedro haka kan Juan hên pangkaên ha Pistan Pangaligtas, ta wana, “Mita kaw na, ta il-an yoy pangkaên tamo amêhên yabi ha pista.” ");
INSERT INTO sgb_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Kabay nangotang hilan Pedro, “Atoy labay moy logal ya pangil-anan naên hên kaên tamo?” ");
INSERT INTO sgb_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Wani Apo Jesus, “Panlumatêng yo ha balayan Jerusalem, ay matupa yoy mihay lalaki ya ampantan banga ya nag lanêm. Pakihonolan yo ya ha bali ya howênên na, ");
INSERT INTO sgb_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ta habiên yo ha nag bali, ya êmên di, ‘Labay nan Mánoro ya itoro mo kannaên, no antoy kuwarto ya panganan nan kaên ha Pistan Pangaligtas, hên kalamo na kay ya tagahonol na.’ ");
INSERT INTO sgb_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kabay ipahlêk na kamoyu ya mihay mahlay ya kuwarto ya nakal-an ha tag-ay. Bayro yon il-an ya kaên tamo ha pista.” ");
INSERT INTO sgb_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nammita hilay nay loway tagahonol, haka natupad ya balang hinabi ni Apo Jesus kanla. Kabay in-il-an lay nay kaên ha pista. ");
INSERT INTO sgb_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Hên oras hên mangan hên pangkaên ha Pistan Pangaligtas, ay inarap lan Apo Jesus ya kaên la. ");
INSERT INTO sgb_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Amêhên, wana kanlan labinloway apostol na, “Bayo ko magdanas hên pamagdusa, ay boon nakêm kon labay hên mapagkaêm kataw pon hên mangan hên habaytsi ya pangkaên ha Pistan Pangaligtas. ");
INSERT INTO sgb_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Anhabiên ko kamoyu, ya a kina oman mangan pangkaên ha Pistan Pangaligtas angga ha a pon matupad ya labay habiên hên habaytsi ha pamanlokop ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Amêhên, dinampot nay pamminêman ya nag alak ta impahalamat nay hatsi kan Apo Namalyari, bayo hinabi na kanla, ya wana, “Piatagan yoy hatsi laamêhên. ");
INSERT INTO sgb_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ta anhabiên ko kamoyu, ya a ko pon minêm oman hên alak, angga ha a pon lumatêng ya pamanlokop ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Amêhên, nandampot yan puto ta impahalamat nay habayto kan Apo Namalyari, haka na pino-potoh, bayo inggawang na kanla, ta wana, “Habaytsi ya lawini ko, ya an-idin ko ha ikakangêd yo. Dapat panay yon daygên ya habaytsi, ta êmên yo ko maihipan.” ");
INSERT INTO sgb_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Êmbayro êt, hên nayari hilan nangumapon, ay nandampot yan pamminêman ya nag alak, ta wana, “Habaytsi ya daya ko, ya mamoganggang ha pamatawad hên kasalanan hên kal-atan. Yabay ya nanad pinakapirma hên bayoy kahundoan ni Apo Namalyari kanlan pinili na hên mag-in kana. ");
INSERT INTO sgb_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Noa, ya mihay kaaêm tamo di, ay mangi-upit kangko. ");
INSERT INTO sgb_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Hiko ya Taga-Langit, ya In-anak Tawo ay taganán matsi, ta habaytoy tinalagá ni Apo Namalyari. Noa, taganán kaingalo ya mangi-upit kangko.” ");
INSERT INTO sgb_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Amêhên, ampikokotang hilay labinlowa no hino kanla ya manyag hên êmbayro. ");
INSERT INTO sgb_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ampihuhubakan lan tagahonol ni Apo Jesus no hino kanla ya main matag-ay ya tungkulan. ");
INSERT INTO sgb_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Kabay hinabi ni Apo Jesus kanla, ya wana, “Hilay ari haka hilay kaatag ya ampamaala, ay ampamiatay kanlan atsi ha lokop la hên manyag kalabayan la, yan labay la êt hên mabaêg hila hên maingaloên. ");
INSERT INTO sgb_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Noa, dapat alwan êmbayro kamoyu, ta ya pinakamatag-ay, ay dapat mag-in pinakamaaypa. Haka ya ampamaala, ay kailangan maghuyo. ");
INSERT INTO sgb_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Hino ya matag-ay ya tungkulan? Ya ampikno ha lamisaan, o ya ampamigawang hên hinon kailangan nan ampikno? Taganán habaytoy ampikno ya nag tungkulan! Noa, hiko ay atsi di hên nanad ha mihay ampaghuyo. ");
INSERT INTO sgb_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Hikaw ay panay kon nakalamo, ha kairapan man ya dinanan ko, ya nanad pamanubuk kangko. ");
INSERT INTO sgb_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kabay, no ay-êmên nan indin kangko ya tungkulan hên mamaala, ni Apo Namalyari, ya Tatang ko, ay êmbayro êt ay dyanan kataw hên tungkulan hên mamaala. ");
INSERT INTO sgb_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Lano ay mapagkalamo kataw hên mangan ha lamisaan ya atsi ha pamanlokop ko. Mikno kaw ha iknoan hên ari ta mamaala kaw kanlan Israelita, ya hilay kaapo-apoan lan labinloway anak ya lalaki ni apo Israel.” ");
INSERT INTO sgb_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simon, manggilam ka,” wani Apo Jesus, “Nakihabi hi Satanas kan Apo Namalyari ya subukên na kaw ya labinloway tagahonol, haka paulayan na ya ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Noa, inhalangin kata Simon, ya a dayin maalíh ya paniwala mo kangko. Haka ha pag-orong hên nakêm mo ay dapat mon pataniêhên ya nakêm hên kapareho mon ampaniwala.” ");
INSERT INTO sgb_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Kabay hinabi ni Simon Pedro, ya wana, “Panginoon, nakal-an akon magpakulung haka matsi hên kalamo mo.” ");
INSERT INTO sgb_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","“Pedro,” wani Apo Jesus, “pakagilamên mo, bayo mangkatsi ya manok amêhên yabi, ay katatlo mon habiên ya a mo ko muwang.” ");
INSERT INTO sgb_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Amêhên, hinabi ni Apo Jesus kanlan tagahonol na, ya wana, “Yarin nagkulang kaw hên in-utoh kataw hên ayn pera, ayn balutan, haka ayn pag-apin bitsih yo!” “A kay, Apo,” wanla etaman. ");
INSERT INTO sgb_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","“Noa, amêhên, ya balang miha ya main, ay kailangan mantan pera haka balutan la. Haka hilay ayn panlaban ay kailangan manaliw hilan panlaban la, ihaliw la man ya takop la, ta êmên hila main hên panaliw. ");
INSERT INTO sgb_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ta kailangan matupad ya nakahulat ya tungkol kangko bayro ha Kahulatan ya impahulat ni Apo Namalyari kan Propeta Isaias, ya wana, ‘Intad la yan mapanyag karawakan.’ Haka ya inhulat ya tungkol kangko ay angkatupad amêhên.” ");
INSERT INTO sgb_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kabay hinabi lan tagahonol na, “Panginoon, hêlkên moy hatsi. Main kitamo hên loway êtak ya panlaban.” Wana etaman ni Apo Jesus, “Hukad ya.” ");
INSERT INTO sgb_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nahên ubat hilan nangan pangkaên ha Pistan Pangaligtas, ay nammita hilan Apo Jesus ha Tawgtug Olibo, ya panlakwên la no yabi. ");
INSERT INTO sgb_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Hên nilumatêng hilay na bayro, ay hinabi ni Apo Jesus kanlan tagahonol na, ya wana, “Manalangin kaw kan Apo Namalyari, ta êmên a kaw mahambut hên tukso.” ");
INSERT INTO sgb_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Napaidayo ya kanla hên marayo-dayo ta nandoko yan nanalangin, ya wana, ");
INSERT INTO sgb_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tatang ko ha langit, no labay mo, ay a mo ko dayin paulayan hên magdanas ako hên hatsi ya mabyat ya kairapan ya lumatêng kangko. Êmbayro man, alwan kalabayan ko, noa, ya kalabayan mo ya honolên ko.” ");
INSERT INTO sgb_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kaban ampanalangin ya ay nagpahlêk kana ya mihay anghel, ya ubat ha langit, ya namahêkaw kana. ");
INSERT INTO sgb_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Gawan ha kabyatan laman ihip na, ay lalo nan imboo ya nakêm na ha panalangin, kabay ya hayngêt na, ay nanad daya ya ampantolo ha luta. ");
INSERT INTO sgb_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Hên nirêng ya, hên ubat nanalangin, ay nag-orong yay na ha andyanan lan tagahonol na. Nalatngan na hila hên angkabêlêw gawan hadyay lungkot la. ");
INSERT INTO sgb_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Pinukaw na hila, ta wana kanla, “Pata angkabêlêw kaw? Mimata kaw, haka kaw manalangin ta êmên kaw a mahambut hên tukso.” ");
INSERT INTO sgb_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Kaban ampaghabi ya pon hi Apo Jesus, ay main nilumatêng ya kal-atan, ya ampangamat kan Judas Iscariote ya miha kanlan labinloway tagahonol na. Dinumani ya kan Apo Jesus ta aroên na ya dayi. ");
INSERT INTO sgb_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Noa, wani Apo Jesus kan Judas, “Aro awud ya pinay-upit mo kangko, ya Taga-Langit, ya In-anak Tawo.” ");
INSERT INTO sgb_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Hên nahêlêk lan tagahonol, ya kalamo ni Apo Jesus, ya angkalyari, ay wanla, “Panginoon, labay mon gamitên naên ya hata panlaban naên?” ");
INSERT INTO sgb_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Amêhên, bat yan nanigpah ya miha kanlan tagahonol na hên têkk hên mihay ipoh hên pinakapoon pari. ");
INSERT INTO sgb_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Noa, wani Apo Jesus, “Paan!” Tinalan nay têkk, ta in-orong na ya ha mana, ya hatoy têkk. ");
INSERT INTO sgb_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Amêhên, wani Apo Jesus kanlan ampagbantay ha Templo, kanlan toa ya nag tungkulan ha bansa, haka kanlan ampamaala kanlan pari, ya ampipandakêp kana, “Andakpên yo ko hên nanad pandakêp ha mapanyag karawakan. ");
INSERT INTO sgb_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Allo-allo atsi ko bahên kamoyu ha Templo, unin a yo ko dinakêp. Noa, amêhên ya panaon yo, haka panaon ya indin kan Satanas, ta êmên na madyag ya karawakan ya labay nan daygên.” ");
INSERT INTO sgb_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Dinakêp la hi Apo Jesus ta gintan la ya ha bali nan pinakapoon pari. Hi Pedro ay nangamat kanla ha marayo-dayo. ");
INSERT INTO sgb_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Hên nilumatêng hilay na ha balin pinakapoon pari ay namagkêt hilan apoy, kabay nakilamo hi Pedro kanlan ampanêngêy bayro. ");
INSERT INTO sgb_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Hên napansin yan mihay ipoh ya babayi, ha hawang hên apoy, ay pinuliah na ya, ta wana, “Habain ya lalaki ay kalamo ni Jesus.” ");
INSERT INTO sgb_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Noa, hinabi ni Pedro, ya wana, “Alwa. A ko ya man muwang.” ");
INSERT INTO sgb_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","A nabuyot ay napansin yay na êt hi Pedro, hên mihay lalaki, ya naghabi, “Miha ka êt kanla!” Noa, hinabi na etaman ni Pedro, “Alwan hiko.” ");
INSERT INTO sgb_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Hên nakalabah ya miha êt ya oras, ay main ana êt mihay lalaki ya ampamilit, ya wana, “Siguradon hata lalaki ay kalamo ni Jesus gawan taga-Galilea ya êt.” ");
INSERT INTO sgb_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Noa, hinabi ni Pedro, ya wana, “A ko muwang ya panhabiên mo!” Kaban ampaghabi ya pon, ay nangkatsi ya mihay manok. ");
INSERT INTO sgb_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Namalingay hi Apo Jesus ta pinakahêlêk na hi Pedro. Kabay naihipan ni Pedro ya hinabi ni Apo Jesus kana ya, “Bayo mangkatsi ya manok amêhên yabi, ay katatlo mon habiên, ya a mo ko muwang.” ");
INSERT INTO sgb_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Kabay inumawah ya hên hadyay tangih na. ");
INSERT INTO sgb_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Hi Apo Jesus etaman ay kinailyan haka tinumbuk hên ampipagbantay kana. ");
INSERT INTO sgb_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tinagpênan lay mata na hên panyo haka la ya kinotang, “Hinoy nanumbuk kamo? Habiên mo!” ");
INSERT INTO sgb_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Mal-at êt ya kaatag ya hinabi la, ya pammusmus kana. ");
INSERT INTO sgb_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pangamaranon, ay ni-tsi-tsipon hilay kalamo hên Sanedrin, ya angkaboo hên toa ya nag tungkulan ha bansa, boy hilay ampanoro hên Kautuhan ni apo Moises, haka hilay ampamaala kanlan pari. In-arap kanla hi Apo Jesus ta lingonên lay kaso na, ya wanla, ");
INSERT INTO sgb_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Habiên mo kannaên no hika ya Mesias, ya Cristo, ya pinili ni Apo Namalyari hên mag-in habaytoy Mámiligtas ya impangako na.” Noa, wana kanla, “Agyan habiên ko kamoyu, ay a yo ko paniwal-an. ");
INSERT INTO sgb_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Haka no kotangên kataw, ay a kaw man makibat. ");
INSERT INTO sgb_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Noa, ubat amêhên, hiko, ya Taga-Langit ya In-anak Tawo, ay mikno ha dapit panabtab ni Apo Namalyari ya Makapangyarihan.” ");
INSERT INTO sgb_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kabay wanla, “No êmbayro awud, ay anhabiên mo ya hika ay Anak ni Apo Namalyari.” Bayo wani Apo Jesus, “Awo, hikaw nay ampaghabin hikoy habayto.” ");
INSERT INTO sgb_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kabay wanla, “A tamina kailangan hên kaatag êt ya tistigos, ta nagilaman tamina ya hinabi na.” ");
INSERT INTO sgb_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Amêhên, naubuh hilan nirêng ya kalamo hên Sanedrin, ta gintan la ya hi Apo Jesus hên in-arap kan Gobernador Pilato, ya gobernador hên probinsyan Judea. ");
INSERT INTO sgb_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Binad-an la ya, ya wanla kan Gobernador Pilato, “Narakêp naên ya habaytsi. Alwan mangêd ya panhabiên na ha kal-atan, ya a hila kano kailangan hên mamayad hên buwih ha pinakapoon ha bansan Roma, haka hiya kano ya Mesias, ya Cristo, ya mihay ari.” ");
INSERT INTO sgb_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Amêhên, kinotang ni Gobernador Pilato hi Apo Jesus, ya wana, “Awta? Hika ya ari hên Israelita?” Hinabi etaman ni Apo Jesus, “Hinabi mina, Gobernador.” ");
INSERT INTO sgb_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kabay wani Gobernador Pilato kanlan poon pari haka kanlan kaatag, “Ayn akon angkahêlêk ya ikadikil hên hata lalaki.” ");
INSERT INTO sgb_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Noa, lalo lan impalêkpêk, ya wanla, “Gawan ha panoro na di ha probinsyan Judea, ay nahulhulan hilay nay tawo hên manobag ha gobyernon Roma. Nag-umpisa yan nanoro ha probinsyan Galilea, bayo amêhên atsi yay na di.” ");
INSERT INTO sgb_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Hên nagilaman ni Gobernador Pilato ya habaytsi, ay kinotang na no taga-probinsyan Galilea hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Hên namwangan ni Gobernador Pilato ya hi Apo Jesus ay taga-probinsyan Galilea awud, ya sakop ni Gobernador Herodes Antipas, ay in-utoh na hên gêtan la ya hi Apo Jesus kana, ta atsi ya etaman bayro ha Jerusalem hên habayto. ");
INSERT INTO sgb_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Hadyay higla ni Gobernador Herodes Antipas hên nahêlêk na hi Apo Jesus, gawan mal-at ya nagilam na, ya tungkol kana, haka nabuyot nay nan labay mahêlêk ya kapapaêpapah ya dyag na. ");
INSERT INTO sgb_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kabay pinagkokotang ni Gobernador Herodes Antipas hi Apo Jesus. Noa, a ya naghabi hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Hadyay huluk lan poon pari haka hadyay huluk lan mánoron Kautuhan ni apo Moises ha pamara la kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hi Apo Jesus ay pinagmumusmus haka kinailyan ni Gobernador Herodes Antipas haka hilay hundaloh na. Ha pammusmus la kana ay pinatakopan la ya hên mahampat ya nanad takop hên ari, bayo impaorong la ya kan Gobernador Pilato. ");
INSERT INTO sgb_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Hên hato, ay mikapatsi hi Gobernador Pilato haka hi Gobernador Herodes Antipas, noa, habayton allo êt ay napilugud hilay nay lowa. ");
INSERT INTO sgb_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pinatsipon ni Gobernador Pilato hilay ampamaala kanlan pari, hilay kaatag ya ampamaala, haka hilay kal-atan Israelita. ");
INSERT INTO sgb_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ta wana kanla, “Gintan yo ya hatsi ya lalaki kangko gawan alwa kanon mangêd ya panoro na kanlan kal-atan. Pinakakotang ko ya, noa, ayn akon nahêlêk kana ya kasalanan ya an-ibara yo kana. ");
INSERT INTO sgb_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hi Gobernador Herodes Antipas man, ay ayn yan nahêlêk kanay kasalanan, kabay impaorong na ya kantamo di. Ayn yan dinyag ya pamatsan kana. ");
INSERT INTO sgb_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kabay ipalatiko ko ya tana, bayo ibuhan ko ya.” ");
INSERT INTO sgb_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(Balang Pistan Pangaligtas ha Egipto, ay kailangan ni Gobernador Pilato hên ibuhan ya miha kanlan nakahukul.) ");
INSERT INTO sgb_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Noa, ya kal-atan ay nan-angaw, ya wanla, “Patsên hi Jesus! Hi Barrabas tana ya labay naên hên ibuhan mo!” ");
INSERT INTO sgb_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Nakahukul hi Barrabas gawan nakilamo ya kanlan kal-atan ya nanyag hên halanghang ha gobyernon Roma ha balayan Jerusalem, haka gawan namatsi yan tawo.) ");
INSERT INTO sgb_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Labay na dayi ni Gobernador Pilaton mibuhan hi Apo Jesus, kabay naghabi yan oman ya ibuhan dayi hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Noa, in-angaw la, ya wanla, “Ipako ya ha koros! Ipako ya ha koros!” ");
INSERT INTO sgb_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Katatlo nan hinabi ni Gobernador Pilato, ya wana, “Awta? Hinoy kasalanan na? Ayn akon nahêlêk kana ya pamatsan kana. Ipalatiko ko ya tana, bayo ibuhan ko ya.” ");
INSERT INTO sgb_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Noa, impapakaangaw lan poon pari haka lan kaatag, ya ipako ya ha koros. Kabay ayn yay nan madyag hi Gobernador Pilato. ");
INSERT INTO sgb_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pinaulayan na hilay na ha kalabayan la. ");
INSERT INTO sgb_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Hinonol nay kalabayan lan kal-atan, ta imbuhan na hi Barrabas, ya nakahukul gawan nanalanghang ya ha gobyerno, haka gawan namatsi yan tawo. Indin na ya hi Apo Jesus ha gamêt la, ta êmên la madyag ya kalabayan la. ");
INSERT INTO sgb_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Amêhên, gintan la hi Apo Jesus hên hundaloh ta ipako la ya ha koros. Ha pammita la ay nakatupa hila hên mihay lalaki ya nag langan Simon ya taga-Cirene, ya anhumwên ha balayan. Dinakêp la ya ta impabalangaw lay koros kana hên ampakihonol kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Hadyay kal-atan ya hinumonol kana. Kalamo la ya kaatag ya babayi ya hadyay tangih, ta antangihan la ya. ");
INSERT INTO sgb_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Namalingay hi Apo Jesus, ta wana kanla, “Hikaw ya babayi ya taga-Jerusalem, paan yo ko tangihan, noa, tangihan yoy sarili yo haka maának yo, ");
INSERT INTO sgb_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ta lumatêng lano ya allo ya habiên la, ya iningalwan hilay a nakaanak haka a namahoho. ");
INSERT INTO sgb_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Habaytoy panaon ay habiên la kanlan tawgtug, ya wanla, ‘Gêymaan yo kay.’ Wanla êt kanlan bung-oy, ‘Taphonan yo kay.’ ");
INSERT INTO sgb_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ta no êmên di ya daygên la ha kayoy nailê, ay hino bayto ya daygên la ha kayoy nayango?” ");
INSERT INTO sgb_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Main êt loway lalaki, ya parehon mapanyag karawakan ya gintan hên patsên kalamo ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Hên nilumatêng hila ha logal ya ambaêgên lan Golgota o Bungo, ay bayro la hilan impako hên hundaloh, ha tatloy koros. Ya miha ay atsi ha koros ha dapit panabtab ni Apo Jesus, haka ya miha ay atsi ha koros ha dapit uki na. ");
INSERT INTO sgb_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Amêhên, nanalangin ya hi Apo Jesus, “Tatang ko ha langit, patawarên mo hila ta a la muwang ya pandaygên la.” Hilay hundaloh etaman, ay nangwan takop ni Apo Jesus ta inatag-atag lan pinagpalabonutan. ");
INSERT INTO sgb_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mal-at ya atsi bayro hên ampanlêk kaban ammusmusên la ya hên ampamaala ha Templo, ya wanla, “Inligtas nay kaatag. No hiya ya Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala, pata a na mailigtas ya sarili na!” ");
INSERT INTO sgb_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Hilay hundaloh ay nammusmus kana etaman. Painêmên la ya dayin nangihoy alak, ");
INSERT INTO sgb_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ta wanla kana, “No hika ya Ari lan Israelita, iligtas moy sarili mo!” ");
INSERT INTO sgb_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Atsi ha koros, ha ugton ulo na, ya nakahulat (ha habin Griego, Latin, haka Hebreo), ya wanan hulat, “Hatsi ya Ari lan Israelita.” ");
INSERT INTO sgb_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Minusmus ya êt hên miha kanlan loway mapanyag karawakan ya nakapako ha koros hên karani na, ya wana, “No hika ya Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala, ay iligtas moy sarili mo, haka hikay.” ");
INSERT INTO sgb_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Noa, tinobag na yan kapareho nan mapanyag karawakan, ya wana, “Ayn kan limo kan Apo Namalyari? Pare-pareho kitamon amparusaan hên patsên. ");
INSERT INTO sgb_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Hêpat kanta ya habayto ta nakadyag kitan kasalanan, noa, hiya etaman, ay ayn yan kasalanan.” ");
INSERT INTO sgb_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Bayo hinabi na kan Apo Jesus, ya wana, “Apo, a mo kon liwaan, uston ampamaala kay na.” ");
INSERT INTO sgb_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Kabay, hinabi ni Apo Jesus kana, ya wana, “An-ipangako ko kamo, ya amêhên êt, ay mapagkalamo mo ko ha langit, ha Paraiso.” ");
INSERT INTO sgb_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Hên marani yanay ugtoy allo, ay dinumiglêm ya boon luta angga ha alas tres hên maapon. ");
INSERT INTO sgb_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Sakton dinumiglêm, ay biglan nawakwak hên napibonak ya makogpaw ya takop ya pinagpênlan bayro ha lalê hên Templo ha Jerusalem. ");
INSERT INTO sgb_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Amêhên, nan-angaw hi Apo Jesus hên hadyay hêkaw, ya wana, “Tatang ko ha langit, ipaulay kina kamo ya kaêlwa ko.” Hên nayari nan hinabi ya habayto ay natsi yay na. ");
INSERT INTO sgb_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Hên nahêlêk nan ampamaala kanlan hundaloh, ya pangamatsi ni Apo Jesus, ay pinuri na hi Apo Namalyari, ya wana, “Pêtêg bay awud! Ayn yan kasalanan ya habaytsi!” ");
INSERT INTO sgb_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Hên nahêlêk lan kal-atan ya ni-tsi-tsipon, ya nalyari, ay nuli hila hên andugdugên lay pagaw la, gawan hadyay lungkot la. ");
INSERT INTO sgb_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Noa, hilay kabalay ni Apo Jesus, kalamo hilay babayi ya nakihonol kana hên nanaglap kana, hên paubat ha probinsyan Galilea, ay nakairêng ha marayo-dayo kana, ta andungawan lay angkalyari. ");
INSERT INTO sgb_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Main bayro hên mihay lalaki, ya hi Jose, ya taga-balayan Arimatea ha probinsyan Judea. Hiyay mapanyag kangêran haka anhumonol ya ha Kautuhan ni apo Moises. Hiyay mihay kalamo hên Sanedrin. ");
INSERT INTO sgb_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Noa, a ya nakiuyon ha dinyag la kan Apo Jesus. Pan-êngganan nay pamanlokop ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Dinumani ya kan Gobernador Pilato, ta pinakikwaan nay bangkay ni Apo Jesus, ta iilbêng na ya. Nabay ya etaman hi Gobernador Pilato. ");
INSERT INTO sgb_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kabay kingwa ni Jose ya bangkay ni Apo Jesus, hên in-aypa, haka na kinêlkêlan hên makarang ya takop, ya naputsi. Bayo inhowên na ya ha pay-ilbêngan ha lêyang ya bato, ya a êt pinay-ilbêngan. ");
INSERT INTO sgb_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Hên habayto ay allon pamaglêan ha allon pamagsimba lan Israelita. ");
INSERT INTO sgb_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Hilay babayi ya nakihonol kan Apo Jesus ya ubat ha probinsyan Galilea, ay nakilako kan Jose. Nahêlêk lay pinay-ilbêngan kan Apo Jesus haka no ay-êmên inhowên bayro ya bangkay na. ");
INSERT INTO sgb_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bayo nag-orong hilay na ha balayan, ta namil-an hilan pabango, ya idin la ha bangkay ni Apo Jesus. A la tambêng nagêtan kanay habaytoy pabango, ta nagpainawa hila ha allon Sabado ha pamanhumonol ha Kautuhan. ");
INSERT INTO sgb_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Dali allo êt hên allon Dominggo, ay nammita hilay nay babayi ha pinay-ilbêngan ta idin lay hatoy pabango ya in-il-an la ha bangkay ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nalatngan lay natulid anay hadyay hêlay bato, ya intakap ha lêyang ya pinay-ilbêngan kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Kabay hinumwên hila, noa, a la matapol ya bangkay ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kaban ampikokotang hila no hinoy nalyari ha bangkay ni Apo Jesus, ay bigla lan nahêlêk ya loway lalaki, ya nakatakop hên ampangislap, ya nakairêng ha dani la. ");
INSERT INTO sgb_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Gawan hadyay limo la, ay nandoko hilan napaidêngdêng. Hinabi kanla hên loway lalaki, “Awta pantapolên yoy nabiyay ha pay-ilbêngan hên natsi? ");
INSERT INTO sgb_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ayn yay na di, ta nabiyay yan oman. Ihipên yoy hinabi na kamoyu bayro ha probinsyan Galilea, ya ");
INSERT INTO sgb_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","hiya, ya Taga-Langit, ya In-anak Tawo ay idin ha gamêt lan makasalanan. Ipako la ya ha koros. Bayo panga-ubat hên tatloy allo ay mabiyay yan oman.” ");
INSERT INTO sgb_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Amêhên, naihipan lan babayi ya habaytoy hinabi na. ");
INSERT INTO sgb_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Kabay nag-orong hilay na ha balayan, ta inhumbung la ha labinmiha haka kanlan kalamo la ya nalyari. ");
INSERT INTO sgb_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ya namihumbung hên habayto kanlan apostol ay hilan Maria Magdalena, hi Juana, hi Maria ya indo ni Santiago, haka hilay kaatag ya babayi ya kalamo la. ");
INSERT INTO sgb_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Noa, êndat lan apostol, no alwan pêtêg ya panhabiên lan babayi, gawan nanad hilan namurit ya ampipaghabi. Kabay a la hila pinaniwal-an. ");
INSERT INTO sgb_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Êmbayro man, hi Pedro ay nuwayun nako bayro ha pinay-ilbêngan kan Apo Jesus. Hên nilumatêng ya bayro ay ayn yan nahêlêk, no alwan hatoy naputsi ya takop ya pinangêlkêl kan Apo Jesus. Bayo nuli ya hên ampag-êpapah ha nalyari. ");
INSERT INTO sgb_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Habaytoy allo ay main lowa kanlan tagahonol ni Apo Jesus ya atsi ha dann hên palako ha mihay baryo ya nag langan Emaus, ya main labinmihay kilometro ya dayo ha balayan Jerusalem. ");
INSERT INTO sgb_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ampihabian lay balang nalyari. ");
INSERT INTO sgb_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kaban ampihabi hila ha pammita la, ay dinumani kanla hi Apo Jesus hên napaipantag kanlan loway ampammita. ");
INSERT INTO sgb_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Nahêlêk la ya, noa, a pinaulayan ni Apo Namalyari hên mabalayan la hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Kinotang na hila, ya wana, “Hinoy ampihabian yo?” Tinunggên hila. Angkahêlêk ha mata la ya malungkot hila. ");
INSERT INTO sgb_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ya miha kanla, ya hi Cleopas, ay naghabi, ya wana, “Mimiha mo siguro kanlan kal-atan lan naniraw ha Jerusalem ya a nakagilam hên nalyari bayro hên ungnoy allon bêngat ya nalabah.” ");
INSERT INTO sgb_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Kabay kinotang ni Apo Jesus, “Hinoy nalyari?” Wanla etaman, “Ya nalyari kan Apo Jesus ya taga-Nazaret. Hiya ay mihay propeta ni Apo Namalyari. Ya kapapaêpapah ya dinyag ni Apo Jesus, haka ya hinabi na ay ampamaptêg ya ubat kan Apo Namalyari ya kapangyarihan na. Muwang lan tawo ya habayto. ");
INSERT INTO sgb_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Hiyay impapatsi lan ampamaala kanlan pari haka lan kaatag ya main tungkulan, kabay hiya ay impako ha koros. ");
INSERT INTO sgb_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Êndat naên no hiyay mangakbus hên bansan Israel. Noa, main nanan tatloy allo hên pinatsi la ya. ");
INSERT INTO sgb_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nag-êpapah kay ha ungnoy babayi, ya kalamo naên, ya atsi bayro nangun maranon ha pinay-ilbêngan la kana, ");
INSERT INTO sgb_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","hên inhumbung la kannaên ya ayn ana bayro ya bangkay na. Wanla êt ya nakahêlêk hila hên anghel ni Apo Namalyari ya nipaghabi kanla ya biniyay oman hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ya kaatag kanlan kalamo naên ay nagtagloh etaman bayro ha pinay-ilbêngan kana. Nahêlêk la êt ya nanad ha hinabi lan babayi, noa, a la ya êt nahêlêk hi Apo Jesus.” ");
INSERT INTO sgb_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Amêhên, hinabi ni Apo Jesus kanla, ya wana, “Kakakdêyan hên ulo yo! Pata a yo ampaniwal-an ya habi lan mámipamwang hên an-ipaihip kanla ni Apo Namalyari? ");
INSERT INTO sgb_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ta hila ya namipapêt hên tungkol ha Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala ya taganán kailangan yan magdanas hên hadyay irap bayo ya mag-orong ha langit hên mamaala hên kalamo ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Impamulah ni Apo Jesus kanla ya kaganawan ya tungkol kana ya nakahulat ha Kahulatan ya impahulat ni Apo Namalyari, ubat ha inhulat ni apo Moises, haka ha inhulat lan kaganawan ya kaatag ya mámipamwang hên an-ipaihip kanla ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Hên andumani hilay na ha baryon Emaus, ya lakwên la, ay nanad magpaitagloh ya hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Noa, hinagyat la yan magdahêl pon hên kalamo la, ya wanla, “Pamibalayan mipatêl makê! Magdahêl ka pon di, ta êmên makalamo naên ka pon.” Kabay nakilako ya kanla. ");
INSERT INTO sgb_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Hên atsi hilay na ha arapan kaên, ay nangwa ya hi Apo Jesus hên puto ta pinahalamatan nay habayto kan Apo Namalyari. Hên nayari nan pinahalamatan ay pinotoh nay habayto, bayo indin nay na kanla. ");
INSERT INTO sgb_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Hên dinyag nay habayto, ay nabalayan la ya. Hiya awud hi Apo Jesus. Noa, bat yan naplak ha arapan la. ");
INSERT INTO sgb_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nihabi hilay nay lowa, ya wanla, “Kabay awud nanad apoy ya atsi ha nakêm ta nangun ha dann, hên an-ipamulah nay Kahulatan ya impahulat ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tambêng hilay nan nag-orong ha balayan Jerusalem, kabay nalatngan la bayro hilay labinmihay tagahonol ni Apo Jesus kalamo lan kaatag, ");
INSERT INTO sgb_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ya ampaghabi kanlan lowa, ya wanla, “Nabiyay yan oman hi Apo Jesus. Nagpahlêk ya kan Simon Pedro!” ");
INSERT INTO sgb_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Amêhên, impamwang lan hata lowa ya nalyari ha dann, haka no ay-êmên la yan nabalayan hi Apo Jesus hên pinotoh nay puto. ");
INSERT INTO sgb_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kaban ampaghabi hila pon ya lowa, ay biglan nagpahlêk kanla hi Apo Jesus, ta hinabi na kanla, ya wana, “Patêkbêkên ni Apo Namalyari ya nakêm yo.” ");
INSERT INTO sgb_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Noa, nakatsigag hila haka hadyay limo la, ta êndat la no ampakahêlêk hilan kamana. ");
INSERT INTO sgb_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kabay hinabi na kanla, ya wana, “Pata hadyay limo yo? Pata ampag-alangan kaw? ");
INSERT INTO sgb_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Hêlkên yoy gamêt ko haka bitsih ko. Hikoy hatsi. Gap-an yo, haka pakapoliahên yoy lawini ko. Alwa kon kamana, ta ya mihay kamana ay ayn but-o haka ayn laman.” ");
INSERT INTO sgb_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Hên nahabi nay na ya habayto, ay impahlêk nay gamêt haka bitsih na kanla. ");
INSERT INTO sgb_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Hadyay kahiglaan la hên nabalayan la ya, noa, ampag-êpapahan la pon no taganán hiya, kabay wana kanla, “Main kaw hên maêkan di?” ");
INSERT INTO sgb_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kabay dinyanan la ya hên mihay yunit kênan lanêm ya in-iyaw. ");
INSERT INTO sgb_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Kinna nay habayto ha arapan la. ");
INSERT INTO sgb_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Bayo hinabi na kanla, “Habaytsi ya labay kon habiên kamoyu hên panay kataw napagkalamo, ya kailangan maubuh hên matupad ya nakahulat ya tungkol kangko ha libro hên Awit, haka ha inhulat ni apo Moises, haka ha inhulat lan kaatag ya mámipamwang hên an-ipaihip kanla ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Impamulah na kanla ya Kahulatan ya impahulat ni Apo Namalyari, ");
INSERT INTO sgb_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ta wana kanla, “Habaytsi ya nakahulat, ‘Ya Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala ay kailangan matsi. Bayo panga-ubat hên tatloy allo ay mabiyay yan oman.’ ");
INSERT INTO sgb_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Nakahulat êt ya êmên di, ‘Ha kapangyarihan na ay kailangan iaral ya tungkol ha pamaghêhê haka ha pamatawad hên kasalanan ha balang bansa paubat ha balayan Jerusalem.’ ");
INSERT INTO sgb_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Hikaw ya mamaptêg kangko, ya mamipamwang ha balang nalyari hên nanad ha impamwang la hên hato. ");
INSERT INTO sgb_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Impangako ni Apo Namalyari, ya Tatang ko, ya ipahapat na kamoyu ya Espiritu na, haka lano ipagtan ko ya kamoyu. Noa, mangênggan kaw pon di ha balayan angga ha lumatêng ya kamoyu hên main kapangyarihan.” ");
INSERT INTO sgb_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Amêhên, pinagkalamo ni Apo Jesus hilay tagahonol na hên palakon baryon Betania. Hên narani hila bayro, ay intag-ay nay gamêt na ta inhalangin na hila ya ingalwan hila ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kaban an-ihalangin na hila, ay hiyay gintan ha langit. ");
INSERT INTO sgb_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Pinuri la ya, bayo nag-orong hila ha balayan Jerusalem hên hadyay higla. ");
INSERT INTO sgb_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Paubat hên habayto, ay panay hilan atsi ha Templo hên ampuriên hi Apo Namalyari.");
INSERT INTO sgb_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Hên haton kauna-unaan hên a pon dinyag ya hata langit, haka luta ay main nanan Habi. Habaytoy Habi ay atsi bayro hên kalamo ni Apo Namalyari, haka hiyay Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Hiyay kalamo ni Apo Namalyari paubat hên una. ");
INSERT INTO sgb_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Hiyay nanyag hên kaganawan ya atsi bayri. Ayn hinon nadyag no alwan gawan kana. ");
INSERT INTO sgb_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Hiyay ubatan hên biyay haka hiyay maialimbawa ha atáng ya ampamahawang ha ihip hên balang miha. ");
INSERT INTO sgb_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Habaytoy hawang ay anhumawang ha luta ya nanad dinumiglêm gawan ha kasalanan. A ya napahambut ha kariglêman. ");
INSERT INTO sgb_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Amêhên, main lalaki ya in-utoh ni Apo Namalyari, ya nag langan Juan. ");
INSERT INTO sgb_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","In-utoh na ya hên mamipamwang hên tungkol ha hawang, ta êmên ya balang miha ay maniwala kanan habayto ya ampamahawang hên kaihipan. ");
INSERT INTO sgb_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Alwan hi Juan ya hawang, noa, hiyay in-utoh hên mamipamwang hên tungkol ha hawang. ");
INSERT INTO sgb_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ya pêtêg ya hawang, ay habaytoy nilumatêng di ha luta ya ampamahawang ha kaihipan hên balang miha. ");
INSERT INTO sgb_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Hiyay nanyag hên hata luta hên hato pon, haka hiyay nilumatêng di ha luta. Noa, a la ya awud nabalayan. ");
INSERT INTO sgb_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Agyan hilay Israelita ya kamag-anak na, ay a nananggap kana hên nilumatêng ya kanla. ");
INSERT INTO sgb_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Noa, hilangan ya nananggap kana, haka naniwala kana, ay dinyanan nan tungkulan hên mag-in anak ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ya pangianak kanlan anak ni Apo Namalyari, ay alwan nanad pangianak tawo, haka alwan gawan ha kalabayan lan miahawa hên magkamain anak, noa, gawan ha kapangyarihan ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ya Habi ay nag-in tawo, haka napaidi di ha luta. Ya hinabi na ay panay pêtêg haka hiya ay panay maingaloên. Nahêlêk naên ya panga-Diyos na. Yabay ya panga-Diyos hên kamiha-mihaan Anak ni Apo Namalyari, ya Tatang na. ");
INSERT INTO sgb_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Nangaral hi Juan Bautista hên tungkol kanan hata Habi ya nag-in tawo. Habaytsi ya pamipamwang na, hên intoro na hi Apo Jesus, ya wana, “Yabay ya hinabi ko kamoyu ya ‘main lumatêng ya makapangyarihan kangko, gawan atsi yay na, hên a ko pon in-anak.’” ");
INSERT INTO sgb_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kaganawan tamo ay ampakinabang ha kahampatan nakêm ni Apo Jesu-Cristo, ya hadyay maingaloên. ");
INSERT INTO sgb_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ya Kautuhan ni Apo Namalyari, ay impamwang ni apo Moises kanlan Israelita, noa, ya kaptêgan, haka ya ingalo ni Apo Namalyari, ay impamwang ni Apo Jesu-Cristo. ");
INSERT INTO sgb_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Paubat hên haton lagi, ay ayn êt nakahêlêk kan Apo Namalyari, no alwan bêngat hi Apo Jesu-Cristo ya kamiha-mihaan nan Anak. Hiyay Apo Namalyari, haka hiyay panay nan kalamo. Hiya ya namipamwang kan Apo Namalyari, ya Tatang na. ");
INSERT INTO sgb_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Amêhên, hilay Israelita, ya ampamaala ha balayan Jerusalem, ay namiutoh hên ungno kanlan pari la, haka ungno kanlan Levita ya ampanawop kanlan pari, ta êmên hila mangotáng kan Juan Bautista no hino ya. ");
INSERT INTO sgb_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Hinabi ni Juan ya kaptêgan, ya wana, “Alwan hikoy Mesias, ya Cristo, ya pinili ni Apo Namalyari hên mag-in habaytoy Mámiligtas ya impangako na.” ");
INSERT INTO sgb_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“No êmbayro, hino ka awud?” wanla. “Kayno hika hi Propeta Elias!” “Alwa.” wani Juan. “Kayno hika ya Propeta ni Apo Namalyari, ya an-êngganan naên!” “Alwa.” wanan oman ni Juan. ");
INSERT INTO sgb_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Wanlay na êt, “Habiên mo awud no hino ka, ta êmên naên maipamwang kanlan namiutoh kannaên. Hinoy mahabi mo ya tungkol ha sarili mo?” ");
INSERT INTO sgb_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Amêhên, hinabi ni Juan, “Hiko ya inungkat ni Propeta Isaias, ya wana, ‘Main ampan-angaw ha logal ya kabalah-balahan, ya wana kanlan kal-atan ya naka-tsipon, “Il-an yoy nakêm yo ha pamanlumatêng hên Panginoon, Ya nanad ha pamil-an hên dann ha pamanlumatêng hên mihay matag-ay ya manungkulan.”’ Habaytoy hinabi ni Propeta Isaias ya tungkol kangko.” ");
INSERT INTO sgb_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Hilay nangotang, ay in-utoh lan Pariseo. ");
INSERT INTO sgb_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Nangotang hilay na êt kan Juan, ya wanla, “Awta ampamawtismo ka? Alwan hika awud ya Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala. Alwa ka etaman hi Propeta Elias. Haka alwan hika ya Propeta ni Apo Namalyari ya an-êngganan naên.” ");
INSERT INTO sgb_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Kabay hinabi ni Juan, ya wana, “Lanêm ya ampangibawtismoan ko, noa, main di hên kalamo yo, ya a yo kilala. ");
INSERT INTO sgb_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Agyan nuna kon nilumatêng kana, ay mangokal man hên hêêl pag-apin bitsih na, ay ayn akon karapatan ta matag-ay ya tungkulan na.” ");
INSERT INTO sgb_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Habayto ay nalyari ha baryon Betania, ha lipay hên Ilog Jordan. Yabay ya ilog ya pinamawtismoan ni Juan. ");
INSERT INTO sgb_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Hên humonoy allo, ay nahêlêk ni Juan hi Apo Jesus ya andumani kana. Kabay wana kanlan kalamo na, “Hêlkên yo! Atsi di ya Biseron Tupa ni Apo Namalyari. Hiya ya ayn kasalanan, ya mamialíh kasalanan lan tawo di ha luta. ");
INSERT INTO sgb_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yabay ya hinabi ko kamoyu ya ‘main lumatêng ya makapangyarihan kangko, gawan atsi yay na, hên a ko pon in-anak.’ ");
INSERT INTO sgb_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Agyan hiko, ay a ko ya muwang no hino yan taganá hên hato. Êmbayro man, ay atsi ko di, hên ampamawtismo ta êmên ya ipamwang ha Israelita.” ");
INSERT INTO sgb_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Habaytsi ya pamipamwang ni Juan Bautista, “Nahêlêk ko ya Espiritu ni Apo Namalyari ya inumaypan ubat ha langit, hên nanad ha mihay pati-pati, haka nagmana ya kana. ");
INSERT INTO sgb_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Hiko man, hên una, ay a ko muwang no hino yan taganá. Noa, hi Apo Namalyari, ya namiutoh kangko hên mamawtismo ha lanêm, ya naghabi kangko, hên êmên di, ‘Mahêlêk mo ya Espiritu ko ya umaypa haka magmana ha mihay lalaki. Hiyay mamawtismo ha pamahapat hên Espiritu ko.’ ");
INSERT INTO sgb_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nahêlêk ko ngan ya nalyari, kabay an-ipamwang ko ya hiya ya Anak ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ha humonol ya allo, ay atsi yay na êt ha lanêm hi Juan Bautista haka ya lowa kanlan tagahonol na. ");
INSERT INTO sgb_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Hên naikit na ya ampita bayro hi Apo Jesus, ay wana, “Hêlkên yo! Hiyay Biseron Tupa ni Apo Namalyari. Hiya ya halanggo tamo.” ");
INSERT INTO sgb_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Nagilam lan loway tagahonol ni Juan ya hinabi na, kabay hinumonol hila kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Hên namalingay hi Apo Jesus ay nahêlêk na hilay anhumonol kana haka na hila kinotang, ya wana, “Main kaw hên labay?” Kabay hinabi la, “Rabi, antoy ampaidyanan mo?” (Ya labay habiên hên Rabi ay Mánoro.) ");
INSERT INTO sgb_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Wani Apo Jesus kanla, “Kihonol kaw kangko, ta hêlkên yo.” Mag-aalas quatro hên maapon hên habayto. Nakihonol hila kana ta hinlêk lay ampaidyanan na. Nagdahêl hila tana kana. ");
INSERT INTO sgb_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ya miha kanlan lowa, ya nakagilam hên habi ni Juan Bautista, haka nakihonol kan Apo Jesus, ay hi Andres, ya kapotoh pohêl ni Simon Pedro. ");
INSERT INTO sgb_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Habayto hi Andres, ay una nan tinapol hi Simon, ya kapotoh pohêl na, ta wana kana, “Natapol naên ya Mesias, ya pinili ni Apo Namalyari hên mag-in Mámiligtas!” (Ya labay habiên hên Mesias ha habin Griego ay Cristo.) ");
INSERT INTO sgb_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Pinakilamo ni Andres hi Simon kan Apo Jesus. Hinlêk ni Apo Jesus hi Pedro, bayo wana, “Hika hi Simon, ya anak ni Juan. Banhagan la kan Cefas.” (Ya labay habiên hên Cefas ay bato. Habayto ay Pedro ha habin Griego.) ");
INSERT INTO sgb_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ha humonoy allo, ay naihipan ni Apo Jesus hên maniraw ha probinsyan Galilea. Natapol na hi Felipe, haka wana kana, “Kihonol ka kangko.” ");
INSERT INTO sgb_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Hi Felipe ay taga-Betsaida ya balayan lan Andres haka Pedro. ");
INSERT INTO sgb_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Tinapol ni Felipe hi Natanael, bayo wana kana, “Natapol naên ya Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala, ya inungkat ni apo Moises ha Kahulatan ya impahulat kana ni Apo Namalyari. Hiya ya inungkat etaman ha inhulat lan kaatag ya mámipamwang ni Apo Namalyari. Hiya hi Jesus, ya taga-Nazaret, ya anak ni Jose.” ");
INSERT INTO sgb_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Amêhên, wani Natanael kan Felipe, “Yarin main mangêd ya ubat ha balayan Nazaret, ya pêpêrad ya tawo?” Kabay wani Felipe kana, “Kihonol ka kangko ta hêlkên mo.” ");
INSERT INTO sgb_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Hên nahêlêk ni Apo Jesus ya andumani kana hi Natanael, ay wana, “Hêlkên yo! Atsi di ya mihay pêtêg ya Israelita ya a ampanloko.” ");
INSERT INTO sgb_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Kabay wani Natanael, “Ay-êmên mon namwangan ya laman nakêm ko?” Amêhên, wani Apo Jesus, “Bayo ka binaêg ni Felipe ay nahêlêk kata ha hilong hên poon igos.” ");
INSERT INTO sgb_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Kabay wani Natanael, “Mánoro, hika ya Anak ni Apo Namalyari! Hika ya Poon hên bansan Israel.” ");
INSERT INTO sgb_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Wani Apo Jesus kan Natanael, “Ampaniwala ka kangko gawan nahêlêk kata ha hilong hên poon igos. Igit pon di ya kapapaêpapah ya mahêlêk mo.” ");
INSERT INTO sgb_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Wani Apo Jesus kanla, “Pakagilamên yo, lumatêng ya allo, ay mahêlêk yoy nakaloat ya langit, haka hilay anghel ni Apo Namalyari ya lumakat haka lumohan bayro, hên palako kangko, ya Taga-Langit, ya In-anak Tawo.” ");
INSERT INTO sgb_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Hên nalabah ya loway allo, main kasálan ha balayan Cana ha probinsyan Galilea. Atsi bayro ya indo ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Hi Apo Jesus, haka hilay tagahonol na, ay hinagyat ha kasálan etaman. ");
INSERT INTO sgb_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Hên naubuh ya alak ha kasálan, ay hinabi nan indo ni Apo Jesus kana, ya wana, “Naubuh ya alak la. Manawop ka dayi.” ");
INSERT INTO sgb_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Kabay hinabi ni Apo Jesus ha indo na, “Paulayan mo ko, Indo. Alwa ko pon oras, hên manyag hên kapapaêpapah.” ");
INSERT INTO sgb_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Êmbayro man, ay hinabi nan indo ni Apo Jesus kanlan ampanawop ha kasálan, “Daygên yo ya hinon habiên na kamoyu.” ");
INSERT INTO sgb_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Amêhên, main bayro hên anêm ya panyanan lanêm ya nadyag ha bato, ya panggamitên lan Israelita no honolên lay paniwala la hên tungkol ha pamaglinis hên lawini la. Hata panyanan ay ampaglaman hên lowampo angga ha tatlumpo ya galon ya balang miha. ");
INSERT INTO sgb_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Wani Apo Jesus kanlan ampamiapag ha kasálan, “Pun-ên yon lanêm ya hata anêm ya panyanan.” Kabay pinno lan lanêm, hên angga ha bêbêy. ");
INSERT INTO sgb_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Bayo wana kanla, “Manakhob kaw ta gêtan yo kanan ampamaala kanlan ampanawop ha kasálan.” Kabay nanakhob hila, haka la gintan kanan ampamaala. ");
INSERT INTO sgb_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tinawayan nan ampamaala ya lanêm, ya nadyag ni Apo Jesus hên alak, noa, a na muwang no antoy ubatan hên habaytoy alak, ta hilay nangahoy bêngat, ya nag muwang hên habayto. Kabay binaêg nay lalaki ya an-ikasal. ");
INSERT INTO sgb_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ta hinabi na kanan lalaki, “Hilay kaatag ay ampamiawah pon hên naayang ya alak. Bayo, no mal-at ya nainêm lan makikasal, ay mamiawah hila bayto hên ayn makayn ayang. Noa, hika, ay babayo mon in-awah ya naayang.” ");
INSERT INTO sgb_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Habayto ya nalyari ha balayan Cana, ha probinsyan Galilea, ay unan kapapaêpapah ya dinyag ni Apo Jesus. Hên dinyag nay habayto, ay impamwang nay panga-Diyos na. Haka naniwala hilay tagahonol na, ya hiyay Cristo. ");
INSERT INTO sgb_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nahên nayari ya kasálan, ay nilumohan hilan Apo Jesus ha balayan Capernaum. Nakihonol kana ya indo na, hilay ali na, haka hilay tagahonol na. Nagdahêl hila bayro hên ungnoy yabi. ");
INSERT INTO sgb_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Kaban atsi hilan Apo Jesus ha balayan Capernaum, ay marani yanay Pistan Pangaligtas ha Egipto. Kabay nilumakat hi Apo Jesus haka hilay tagahonol na ha balayan Jerusalem ta makipista. ");
INSERT INTO sgb_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Hên nilumatêng hilay na ha ilwangan hên Templo ay nahêlêk na hilay mámihaliw hên baka, tupa, haka pati-pati ya iátang kan Apo Namalyari. Atsi êt bayro hilay mámihagili hên pera. ");
INSERT INTO sgb_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Nanuluk ya hi Apo Jesus. Nanyag yan pangumpah kanla, ta intaboy-taboy na hilangan, anggan tupa, haka baka ha plasa hên Templo. Intapon nay pera lan mámihagilin pera haka na in-iitwag ya lamisaan la. ");
INSERT INTO sgb_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Hinabi na kanlan mamihaliw hên pati-pati, ya wana, “Alihên yo ya pati-pati di. Paan yon daygên palengke ya bali ni Apo Namalyari, ya Tatang ko.” ");
INSERT INTO sgb_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Naihipan lan tagahonol na, ya nakahulat ha habi ni Apo Namalyari, ya tungkol kanan Mesias, ya Cristo, ya wanan hulat, “Ikamatsi ko ya hadyay pamanlugud ko ha bali mo.” ");
INSERT INTO sgb_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Kabay hinabi lan taga-Israêl ya ampamaala ha Templo kan Apo Jesus, ya wanla, “Hinoy maipahlêk mo kannaên, ya kapapaêpapah, ta êmên naên mamwangan, ya main kan tungkulan hên manyag hên dinyag mo?” ");
INSERT INTO sgb_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Amêhên, wani Apo Jesus, “Hiraên yoy hata Templo, ta ipairêng kon oman ha tatloy allo.” ");
INSERT INTO sgb_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Kabay wanlan Israelita, “Apatapo boy anêm ya taon ya panyag hên hata Templo. Yarin maipairêng mo ya ha tatloy allon bêngat.” ");
INSERT INTO sgb_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Noa, ya Templo ya inungkat ni Apo Jesus, ay yabay ya lawini na. ");
INSERT INTO sgb_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kabay hên nabiyay yan oman hi Apo Jesus ha ikatlon allo hên ubat yan natsi, ay naihipan lan tagahonol na, ya hinabi nay habayto. Pinaniwal-an lay Kahulatan ya impahulat ni Apo Namalyari, haka ya hinabi ni Apo Jesus ya tungkol ha pangabiyay nan oman. ");
INSERT INTO sgb_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Kaban atsi ya hi Apo Jesus ha balayan Jerusalem, ha Pistan Pangaligtas, ay mal-at ya naniwala, ya hiyay Cristo, ya pan-êngganan la. Naniwala hila, gawan ha kapapaêpapah ya dinyag na. ");
INSERT INTO sgb_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Êmbayro man, ay ayn yan tsiwala kanla hi Apo Jesus, ta muwang nay laman ihip hên balang miha. ");
INSERT INTO sgb_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ahina kailangan ipamwang kana, ya tungkol ha ugali hên hinoman, gawan mana nay nan muwang ya laman ihip hên balang miha. ");
INSERT INTO sgb_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Bayro ha balayan Jerusalem, ay main mihay Pariseo, ya nag langan Nicodemo. Hiyay miha kanlan ampamaala ha Israelita. ");
INSERT INTO sgb_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Mihay yabi, ay dinumani ya kan Apo Jesus, ta wana kana, “Mánoro, muwang naên ya in-utoh ka ni Apo Namalyari, hên manoro kannaên, ta a mo madyag ya andaygên moy kapapaêpapah, no ayn ya kamo hi Apo Namalyari, hên ampanawop kamo.” ");
INSERT INTO sgb_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Kabay wani Apo Jesus kana, “Pakagilamên mo, hilay a in-anak oman, ay a makapakilamo ha pamanlokop ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","“Apo, ay-êmên hilan ma-ianak oman no toa hilay na? Makahowên hilan oman ha bitokan indo la?” ");
INSERT INTO sgb_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Kabay wani Apo Jesus kana, “Pakagilamên mo. Ayn makapakilamo ha pamanlokop ni Apo Namalyari, no a ya pon na-ianak ha lanêm, haka ha Espiritu ni Apo Namalyari ta êmên mabayo ya nakêm na. ");
INSERT INTO sgb_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Hilay tawo ay ampamianak hên tawo ya main biyay bayri ha luta. Hilay in-anak ha Espiritu ni Apo Namalyari, ay main bayoy biyay ha hawop nan Espiritu na. ");
INSERT INTO sgb_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Paan kan mag-êpapah ha hinabi ko kamo, ya ‘Hikaw ay kailangan ianak oman.’ ");
INSERT INTO sgb_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ya Espiritu ni Apo Namalyari ay nanad hên angin, ya a maiutoh. Angkagilam ya tonoy hên angin. Noa, a mamwangan no antoy ubatan na, haka no antoy lakwên na. Êmbayro êt, ay a mahêlêk no ay-êmên nan bayoên nan Espiritu ni Apo Namalyari ya nakêm, noa, habaytoy mahêlêk ha biyay.” ");
INSERT INTO sgb_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Amêhên, wani Nicodemo, “Apo, ay-êmên mangyari ya habain ya hinabi mo?” ");
INSERT INTO sgb_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Kabay hinabi ni Apo Jesus kana, “Miha ka ya mánoro di ha Israel. Yarin a mo angkaintindihan ya hatsi. ");
INSERT INTO sgb_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Pakagilamên mo. Panhabiên naên ya muwang naên, haka an-ipamwang naên ya nahêlêk naên. Noa, a yo ampaniwal-an ya anhabiên naên. ");
INSERT INTO sgb_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","No, a yo paniwal-an ya impamwang ko kamoyu, ya tungkol di ha luta, ay-êmên yon paniwal-an ya ipamwang ko kamoyu ya tungkol ha langit! ");
INSERT INTO sgb_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ta hikon bêngat, ya Taga-Langit, ya In-anak Tawo, ya nag-aypa ubat ha langit, ay mag-orong ha langit. ");
INSERT INTO sgb_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Haka no ay-êmên nan intag-ay ni apo Moises ya utan, ya nadyag ha tangso, ha kabalah-balahan, ay êmbayro êt, ay kailangan itag-ay ako ha koros, hiko, ya Taga-Langit, ya In-anak Tawo. ");
INSERT INTO sgb_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Kailangan ya habayto, ta êmên hilay ampaniwala ya hikoy Cristo, ay madyanan biyay ya ayn angga.” Habaytoy hinabi ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Gawan ha hadyay pamanlugud ni Apo Namalyari ha balang miha, ay in-utoh na ya kamiha-mihaan nan Anak ha luta, ta êmên hilay ampaniwala kana, ay a migtan ha impiyerno, noa, madyanan biyay ya ayn angga. ");
INSERT INTO sgb_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ta a na in-utoh ni Apo Namalyari ya Anak na, ta êmên sintinsyahan hên parusaan hilay tawo. Noa, in-utoh na ya ta êmên na hila iligtas ha parusa. ");
INSERT INTO sgb_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","A hila parusaan hilay ampaniwala ha Anak. Noa, hilay a ampaniwala kana, ay sinintinsyahan nanan parusaan, gawan a hila naniwala ha kamiha-mihaan Anak ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Sinintinsyahan hilan parusaan, gawan agyan nantan ya Anak na hên kamwangan ya tungkol kan Apo Namalyari ya nanad hawang ha balang miha ha luta, ay labay la pon ya kariglêman, gawan nangarawak ya dyag la. ");
INSERT INTO sgb_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ta hilay ampanyag karawakan, ay angkahêmêkan lay hawang, haka a hila andumani ha hawang, ta êmên a mahawangan ya nangarawak ya dyag la. ");
INSERT INTO sgb_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Noa, hilay ampanyag kangêran, ay andumani ha hawang, ta êmên mahêlêk ya habaytoy andaygên la, ay kalabayan ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Amêhên, nilumohan hi Apo Jesus haka hilay tagahonol na ha dani hên lanêm. Nagdahêl ya bayro ha probinsyan Judea hên kalamo lan tagahonol na, haka namawtismo ya kanlan labay pabawtismo. ");
INSERT INTO sgb_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Hi Juan Bautista ay namawtismo etaman ha logal ya nag langan Enon ha danin Salim, gawan mal-at ya lanêm bayro, haka mal-at ya ampagpabawtismo kana. ");
INSERT INTO sgb_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","A ya pon bayton impahukul hi Juan. ");
INSERT INTO sgb_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Mihay allo, ay main mihay Israelita, ya nakihubakan kanlan tagahonol ni Juan, ya tungkol ha pamaglinis lan Israelita, hên pamanhumonol ha paniwala la. ");
INSERT INTO sgb_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Amêhên, dinumani kan Juan ya tagahonol na, ta wanla, “Mánoro, habaytoy kalamo mo ha lipay hên lanêm, ya impamwang mo ya hiyay Cristo, ay atsi bayri hên ampamawtismo kanlan mabay pabawtismo. Haka mal-at ya andumani kana.” ");
INSERT INTO sgb_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Kabay wani Juan, “Ya katungkulan na ay ubat kan Apo Namalyari, ta ayn hinoman ya main êmbayro ya katungkulan no a indin kana ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Hikaw man, ay muwang yoy na, ya hinabi ko, ya alwan hikoy Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala. Ta hikoy in-utoh ni Apo Namalyari hên mamipamwang, hên lumatêng yay na. ");
INSERT INTO sgb_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nanad ha kaluguran hên mihay lalaki ya an-ikasal, ya ampamil-an kaganawan ha kasálan. Hadyay higla na ha magilam nay habi nan lalaki ya an-ikasal. Êmbayro êt kangko. In-il-an koy pamanlumatêng nan Mesias, ya Cristo, haka hadyay higla ko ta nilumatêng yay na. ");
INSERT INTO sgb_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Dapat mitag-ay ya, haka kailangan miaypa ya tungkulan ko.” ");
INSERT INTO sgb_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Hi Apo Jesus, ya taga-langit, ay ayn kapantag. Noa, ya taga-luta, ay atsi di ha luta ya nakêm na, haka ya anhabiên na ay tungkol di ha luta. Hi Apo Jesus ay daêg nay balang miha. ");
INSERT INTO sgb_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Haka an-ipamwang na ya nahêlêk na, haka ya nagilam na, êmbayro man, ay pêpêrad ya ampaniwala ha anhabiên na. ");
INSERT INTO sgb_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Noa, hilay ampaniwala ha anhabiên na, ay ampamaptêg ya pêtêg ya habi ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ta hiyay in-utoh ni Apo Namalyari, hi Apo Jesus bay, ay ampamipamwang hên habi na. Haka ayn kulang ya pam-i ni Apo Namalyari hên Espiritu na kana. ");
INSERT INTO sgb_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Anlugurên ni Apo Namalyari, ya Tatang tamo, ya Anak na, hi Apo Jesus. Haka impatalan na kana ya kaganawan ya atsi kana. ");
INSERT INTO sgb_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Hilay ampaniwala kan Apo Jesus, ya Anak ni Apo Namalyari, ay main biyay ya ayn angga. Noa, hilay a mabay hên humonol kana, ay a madyanan habaytoy biyay, ta ya huluk ni Apo Namalyari ay atsi kanla, haka parusaan hila hên ayn angga. ");
INSERT INTO sgb_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Amêhên, namwangan lan Pariseo ya mal-at pon ya andumani kan Apo Jesus hên pabawtismo haka patoro kana, kanan hilay andumani kan Juan. Namwangan ni Apo Jesus ya muwang lan Pariseo ya habayto. ");
INSERT INTO sgb_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Êmbayro man, ay alwan hi Apo Jesus ya ampamawtismo, noa, ya tagahonol na ya ampamawtismo. ");
INSERT INTO sgb_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Gawan namwangan ni Apo Jesus ya muwang lan Pariseo ya habayto, ay nag-alíh ya, haka hilay tagahonol na ha probinsyan Judea, ta nag-orong hila ha probinsyan Galilea. ");
INSERT INTO sgb_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Bayo hila miabot ha probinsyan Galilea, ay madanan la pon ya probinsyan Samaria. ");
INSERT INTO sgb_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nilumatêng hila ha mihay balayan hên Samaria ya pinata-ngalanan Sicar, ya narani ha luta ya indin ni apo Jacob, ya miha kanlan ninuno lan Israelita, ha anak na, hi Jose hên haton lagi. ");
INSERT INTO sgb_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Atsi bayro ya libon ya kinali ni apo Jacob. Nikno ya hi Apo Jesus ha dani nan habaytoy libon, gawan pagal na ha pammita. Maranin ugto hên habayto. ");
INSERT INTO sgb_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Kabay nagtagloh hilay tagahonol na ha balayan hên nanaliw hên kaên. Kaban ampikno ya bayro hi Apo Jesus, ay main nilumatêng ya mihay babayi, ya taga-Samaria ta mangahoy. Amêhên, wani Apo Jesus kana, “Kiinêm ako raw.” ");
INSERT INTO sgb_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Amêhên, wanan babayi kana, ya wana, “Awo, noa, hika ay mihay ampagsimba ha Templo ha balayan Jerusalem, awta ampakikwa kan lanêm kangko, ya mihay taga-Samaria?” Hinabi nay habayto ta bawal kanlan Israelita ya ampagsimba ha Templo ha Jerusalem, hên manggamit hên gamit lan taga-Samaria. ");
INSERT INTO sgb_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Kabay wani Apo Jesus kana, “No muwang mo dayi ya pan-idin ni Apo Namalyari, haka no hino ko, ya ampakikwan lanêm kamo, ay nakikwa ka dayi kangko, ta dinyanan kata dayi hên lanêm, ya ampam-in biyay.” ");
INSERT INTO sgb_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kabay wanan babayi, “Apo, ayn kan panakhub, haka malalê ya hata libon. Antoy pangwanan mon habaytoy lanêm ya ampam-in biyay? ");
INSERT INTO sgb_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Yarin daêg mo hi Jacob ya unan toa tamo, ya nangali hên hata libon, haka ninêm di hên kalamo nay maának na haka ayop na!” ");
INSERT INTO sgb_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Amêhên, wani Apo Jesus, “Hilay ampinêm hên hata lanêm ay maangan oman. ");
INSERT INTO sgb_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Noa, hilay ampinêm hên lanêm ya an-idin ko, ay ahinan maangan oman, ta ya lanêm ya an-idin ko, ay mag-in nanad sibol ha nakêm la, ya mam-in biyay ya ayn angga.” ");
INSERT INTO sgb_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Amêhên, wanan babayi kana, “Apo, dyanan mo kon habaytoy lanêm, ta êmên a kina maangan oman, haka a kina kailangan mangahoy di.” ");
INSERT INTO sgb_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Amêhên, wani Apo Jesus kana, “Lakwên moy ahawa mo, ta gêtan mo ya di.” ");
INSERT INTO sgb_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Noa, wanan babayi, “Ayn akon ahawa, Apo.” Nahên nahabi nay habayto, wani Apo Jesus, “Awo, pêtêg ya hinabi mo, ya ayn kan ahawa. ");
INSERT INTO sgb_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ta limay nay nag-in ahawa mo, haka ya lalaki, ya ampaglamo mo amêhên, ay alwa mon ahawa.” ");
INSERT INTO sgb_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Bayo, wanan babayi kana, “Apo, angkaintindihan kina ya hika, ay mihay propeta ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Hilay unan toa tamo, ay nagsimba di ha tawgtug hên Samaria. Noa, panhabiên yo, ya kailangan magsimba ha Templo ha Jerusalem.” ");
INSERT INTO sgb_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Kabay wani Apo Jesus kana, “Maniwala ka ha anhabiên ko, ya lumatêng ya allo, ay alwan bayri, o ha Templo ha Jerusalem ya pagsimbaan kan Apo Namalyari, ya Tatang tamo. ");
INSERT INTO sgb_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Hikaw ya taga-Samaria, ay a yo kilala ya ansimbaên yo. Noa, hikay, ay kilala naên ya ansimbaên naên, ta ya kamwangan, ya tungkol ha kaligtasan, ay ampangubat kannaên, ya ampagsimba ha Jerusalem. ");
INSERT INTO sgb_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Amêhên ya panaon ya hilay pêtêg hên ampagsimba kan Apo Namalyari, ya Tatang tamo, ay magsimba kana hên booy nakêm ha hawop hên Espiritu na. Ta êmbayroy pamagsimba ya antapolên na. ");
INSERT INTO sgb_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Hiyay Espiritu. Kabay hilay ampagsimba kana ay kailangan hên magsimba kanan pêtêg ha hawop hên Espiritu na.” ");
INSERT INTO sgb_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Amêhên, wanan babayi, “Muwang ko ya lumatêng ya Mesias, ya ambaêgên lan Cristo. Panlumatêng na di, ay ipamulah na kantamo ya balang hino.” ");
INSERT INTO sgb_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Kabay wani Apo Jesus, “Hiko, ya kahabi mo ay habaytoy Cristo.” ");
INSERT INTO sgb_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Kaban ampaghabi ya, ay anlumatêng hilay tagahonol na. Nag-êpapah hila, ta main yan kahabi ya babayi. Noa, ayn nangotang kana no hinoy labay na kanan babayi o no awta ampakihabi ya kana. ");
INSERT INTO sgb_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Imbalag nan babayi ya banga na, haka ya nag-orong ha balayan, ta hinabi na kanlan kal-atan, ya wana, ");
INSERT INTO sgb_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Kihonol kaw kangko ta hêlkên yoy mihay lalaki, ya namihabi kangko ngan hên dinyag ko. Kayno hiyay Mesias.” ");
INSERT INTO sgb_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kabay nakihonol hila kana ta hêlkên la hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Kaban ayn ya bayro ya babayi, ay anhagyatên yan tagahonol na hi Apo Jesus, ya mangan ya dayi. ");
INSERT INTO sgb_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Noa, wana kanla, “Main akon maêkan ya a yo muwang.” ");
INSERT INTO sgb_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kabay nihahabi hilay tagahonol na, “Kayno main nam-in kaên kana.” ");
INSERT INTO sgb_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Hinabi ni Apo Jesus kanla, ya wana, “Ya pamanyag kalabayan hên nangiutoh kangko, haka yariên ya impadyag na kangko, ay yabay ya nanad kaên ko.” ");
INSERT INTO sgb_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Anhabiên yo ya, ‘Apat a buwan pon bayo panggapah.’ Noa, anhabiên ko kamoyu, ya pakahêlkên yo hilay mabay hên manggilam habi ko. Nanad hilan pali ya nawto ya magapah. ");
INSERT INTO sgb_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Hilay ampanggapah ay ampananggap hên upa la. Hilay ampakahagyat hên tawo hên maniwala kangko, ay nanad kanlan ampanggapah, ta ampanipon hilan tagêy ya para ha biyay ya ayn angga, ta êmên hilay nanghad, haka hilay nanggapah ay maghigla. ");
INSERT INTO sgb_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Bayrin angka-pêtêg ya kahabian, ya wana, ‘Mihay ampanghad haka mihay na êt ya ampanggapah.’ ");
INSERT INTO sgb_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","In-utoh kataw hên gapahên ya a yo pinaghayngêtan. Kaatag ya namipamwang hên habi ko, haka hikaw ya nakinabang.” Habaytoy hinabi ni Apo Jesus kanlan tagahonol na. ");
INSERT INTO sgb_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mal-at kanlan taga-Samaria ha balayan Sicar ya naniwala, ya hi Apo Jesus, ay hiyay Cristo, gawan ha habi nan babayi, ya wana, “In-ubuh nan hinabi kangko ya dinyag ko.” ");
INSERT INTO sgb_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kabay hên nilumatêng hilay taga-Samaria kanlan Apo Jesus, ay hinagyat la hilan Apo Jesus hên magdahêl kanla. Nagdahêl hila kanla hên loway yabi. ");
INSERT INTO sgb_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Nanoro hi Apo Jesus haka mal-at êt ya kaatag kanlan taga-Samaria ay naniwala ya hiyay Cristo, gawan ha toro na. ");
INSERT INTO sgb_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Hinabi la kanan babayi, “Ampaniwala kay alwan bêngat gawan ha hinabi mo, noa, gawan nagilam naên ya hinabi na, haka muwang naên taganá ya hiyay Cristo, ya impangakon Mámiligtas ya in-utoh ni Apo Namalyari ha tawo ha luta.” ");
INSERT INTO sgb_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nahên nalabah ya loway yabi, ay nammita hilan Apo Jesus hên palakon probinsyan Galilea. ");
INSERT INTO sgb_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Wani Apo Jesus hên hato pon, ya mihay propeta ni Apo Namalyari, ay a an-igalang ha sarili nan logal. ");
INSERT INTO sgb_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Noa, hên nilumatêng hila bayro, ay mahigla hilan tinanggap hên taga-probinsyan Galilea, gawan nahêlêk la ya dyag ni Apo Jesus, hên nakipista ya ha Pistan Pangaligtas ha Egipto ha balayan Jerusalem. ");
INSERT INTO sgb_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Amêhên, nag-orong hilan Apo Jesus ha balayan Cana, ha probinsyan Galilea, ya pinanyagan nan alak ya lanêm. Main bayro hên mihay main tungkulan ha balayan Capernaum, ya main anak ya lalaki ya ampaghakit. ");
INSERT INTO sgb_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Hên nagilam na, ya nilumatêng hi Apo Jesus ha probinsyan Galilea hên ubat ha probinsyan Judea, ay nilako na ya, ta nakihabi ya kan Apo Jesus, ya kihonol ya kana, ta êmên na paalihên ya hakit hên anak na, ya angkaboytoy inanawa. ");
INSERT INTO sgb_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Kabay wani Apo Jesus, “Angga ha a yo angkahêlêk ya dyag ni Apo Namalyari ya kapapaêpapah, ay a kaw awud maniwala!” ");
INSERT INTO sgb_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Noa, hinabi nan main tungkulan, “Apo, kihonol ka kangko ta êmên ya a matsi ya anak ko.” ");
INSERT INTO sgb_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Amêhên, hinabi ni Apo Jesus kana, ya wana, “Muli kay na, ta mabiyay ya anak mo, agyan a ko kilako.” Naniwala ya main tungkulan ha hinabi ni Apo Jesus kana, kabay nammita yay na. ");
INSERT INTO sgb_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ha pamag-orong na ay tinupa ya hên ipoh na, haka la hinabi ya ayn nanan hakit ya anak na. ");
INSERT INTO sgb_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nahên kinotang na hila no hinon oras yan namahig-pahig ya anak na, ay hinabi la, “Naalíh ya omot na naapon hên a la una hên maapon.” ");
INSERT INTO sgb_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Muwang nan main tungkulan ya habayton oras êt, hên hinabi ni Apo Jesus kana, ya, mabiyay ya anak na. Kabay hiya, haka hilay kalamo na ha bali, ay naniwala, ya hi Apo Jesus, ay hiyay Cristo. ");
INSERT INTO sgb_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Habayto ya ikalwan kapapaêpapah ya dinyag ni Apo Jesus ha probinsyan Galilea. Dinyag nay habayto hên ubat ya ha probinsyan Judea. ");
INSERT INTO sgb_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Amêhên, main miha pon ya pista lan Israelita ha Jerusalem. Kabay nakipista ya hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Bayro ha Jerusalem ha Templo, ay main pagpalyuan, ya pinata-ngalanan Betesda ha habin Hebreo. Habayto ay ha danin ilwangan ya ambaêgên lan Pamihowênan tupa. Hatoy pagpalyuan ay main limay bubungan ya paghalilungan ha dani na. ");
INSERT INTO sgb_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Do ha hilong hên habaytoy bubungan, ay main bapan lakê ya ampaghakit. Main buwag, pilay, haka a ampakagalaw ya lawini, ya ampangênggan hên panggalaw hên hatoy lanêm, ");
INSERT INTO sgb_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ta ampaniwala hila ya paminghan-minghan, ay main lumatêng ya mihay anghel ni Apo Namalyari, ya ampangiho-kiho hên lanêm. No hinoy mu-munan makapaghugno ha lanêm, ya ubat hên kiniho-kiho hên anghel, ay angkaalihan hên kaganawan hakit. ");
INSERT INTO sgb_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Main mihay lalaki bayro, ya tatlumpo boy waloy taon nanan ampaghakit. ");
INSERT INTO sgb_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nahên nahêlêk na ya ni Apo Jesus, haka muwang na ya nabuyot yay nan ampaghakit, ay kinotang na ya no labay na hên maalíh ya hakit na. ");
INSERT INTO sgb_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Wanan ampaghakit, “Apo, labay ko, noa, ayn mami-aypa kangko ha lanêm no ubat hên nagalaw. Kabay panay kaatag ya miuna kangko ha lanêm.” ");
INSERT INTO sgb_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Wani Apo Jesus kana, “Mirêng ka. Hapwatên moy amak mo, ta mita kay na.” ");
INSERT INTO sgb_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Tambêng yan nirêng ta naalíh ya hakit na. Haka na hinonol ya hinabi ni Apo Jesus. Allon pamagsimba lan Israelita hên habayto. ");
INSERT INTO sgb_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Kabay wanlan poon lan Israelita kanan inalihan hakit, “Allon pamagsimba amêhên. Bawal ha Kautuhan tamo hên mantan hên hinoman amêhên.” ");
INSERT INTO sgb_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Noa, wana kanla, “Ya lalaki ya namaalíh hên hakit ko, ay naghabi kangko, ya hapwatên koy amak ko, ta mita kina.” ");
INSERT INTO sgb_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Kabay wanla kana, “Hinoy naghabin habain kamo?” ");
INSERT INTO sgb_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Noa, a na muwang, no hino ya, ya namaalíh hên hakit na, ta ayn yay na bayro hi Apo Jesus, haka kal-atan tawo bayro. ");
INSERT INTO sgb_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Nahên nalyari ya habayto, ay natapol ni Apo Jesus ya hatoy lalaki, ya inalihan nan hakit ha Templo, haka wana kana, “Hêlkên mo, ayn kay nan hakit. Paan kay nan manyag kasalanan, ta kayno main narawak pon ya malyari kamo.” ");
INSERT INTO sgb_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nammita ya hatoy lalaki, ta hinabi na kanlan poon lan Israelita, ya hi Apo Jesus, ya namaalíh hên hakit na. ");
INSERT INTO sgb_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Gawan ha pamaalíh nan hakit ha allon pamagsimba la, ay nag-umpisa hilay nan namairap kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Noa, hinabi ni Apo Jesus kanla, “Ya Tatang ko, hi Apo Namalyari, ay ayn têgên ha pamangingalo. Êmên ako êt bayro kana.” ");
INSERT INTO sgb_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Gawan habaytoy hinabi na, ay lalo la yan labay hên patsên, alwan bêngat ha main yan dinyag, ya bawal ha allon pamagsimba, noa, gawan ha hinabi na êt, ya hi Apo Namalyari ay Tatang na. Ha pangahabi nan habayto, ay impantag nay sarili na kan Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Amêhên, wani Apo Jesus, “Pakagilamên yo, hiko, ya Anak ni Apo Namalyari, ay ayn akon madyag ha sarili kon kalabayan. Pandaygên kon bêngat ya angkahêlêk ko kan Apo Namalyari, ya Tatang ko, ta ya pandaygên na, ay pandaygên ko êt. ");
INSERT INTO sgb_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Panlugurên ako ni Apo Namalyari, ya Tatang ko, haka ubuhên nan an-ipahlêk kangko ya dyag na. Haka igit pon di ay ipahlêk na kangko ya daygên ko, ta êmên kaw mag-êpapah. ");
INSERT INTO sgb_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Hi Apo Namalyari, ya Tatang ko ya ampamabiyay kanlan natsi, haka ampam-i kanla hên biyay ya ayn angga. Êmbayro êt, ay ampam-i kon biyay ya ayn angga kanlan labay kon dyanan. ");
INSERT INTO sgb_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Hi Apo Namalyari, ya Tatang ko, ay a manatol ha hinoman, ta indin nay na kangko ya habaytoy tungkulan, ");
INSERT INTO sgb_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ta êmên la kon igalang, ya Anak na, hên balang miha, hên nanad ha pamigalang la kan Apo Namalyari. No a la ko anggalangên, ay a la êt anggalangên hi Apo Namalyari, ya Tatang ko, ya namiutoh kangko. ");
INSERT INTO sgb_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Pakagilamên yo! Hilay ampanggilam habi ko, haka ampaniwala kanan namiutoh kangko, ay main biyay ya ayn angga. Haka a hila hatolan hên parusaan ha impiyerno, ta gêtan hilay na ha biyay ya ayn angga. ");
INSERT INTO sgb_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Pakagilamên yo! Main tawo ya ayn paniwala kan Apo Namalyari. Nanad hilan natsi. Noa, paubat amêhên, ay magilam la ya habi ko, ya Anak ni Apo Namalyari. Haka hilay manonol ha habi ko, ay mabiyay hên ayn angga. ");
INSERT INTO sgb_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Gawan no ay-êmên ya Tatang ko, hi Apo Namalyari, ay main kapangyarihan hên mam-in biyay, ay êmbayro êt ay dinyanan na ko, ya Anak na, hên kapangyarihan hên mam-in biyay. ");
INSERT INTO sgb_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Haka hiko, ya Taga-Langit, ya In-anak Tawo, ay dinyanan na kon tungkulan hên hatolan hên parusaan hilay a ampaniwala kana. ");
INSERT INTO sgb_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Paan kaw mag-êpapah ha anhabiên ko, ta lumatêng ya allo, ay magilaman lan natsi ya baêg ko ha pinay-ilbêngan kanla. ");
INSERT INTO sgb_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Pamakagilam lan baêg ko, ay mipan-umawah hila. Hilay nanyag kangêran, ay dyanan biyay ya ayn angga. Haka hilay nanyag karawakan, ay hatolan hên parusaan hên ayn angga. ");
INSERT INTO sgb_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Ayn akon madyag ha sarili ko, ta anhonolên koy kalabayan ni Apo Namalyari, ya namiutoh kangko. Makatoynungan ya pamanatol ko, gawan a ko anhonolên ya sarili kon kalabayan, ta anhonolên koy kalabayan na ya an-ipamwang na kangko. ");
INSERT INTO sgb_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“No kakapag ko ya ampaghabi hên para ha sarili ko, ay mahabi yo ya alwan pêtêg ya habayto. ");
INSERT INTO sgb_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Noa, main kaatag pon ya ampamipamwang hên tungkol kangko etaman. Yabay ya hi Apo Namalyari, ya Tatang ko, haka muwang ko ya panhabiên na ay pêtêg. ");
INSERT INTO sgb_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Namiutoh kaw hên ungnoy tawo kan Juan Bautista, haka ya hinabi ni Juan hên tungkol kangko ay pêtêg. ");
INSERT INTO sgb_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","An-ipaihip ko ya habayto kamoyu, alwan gawan ha kailangan koy pamaptêg hên tawo, noa, gawan labay ko hên maniwala kaw, ya hikoy Cristo, ta êmên kaw miligtas ha parusa, ya hêpat kamoyu. ");
INSERT INTO sgb_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Hi Juan Bautista, ay nanad hên pag-atáng ya impagkêt ni Apo Namalyari, ta êmên mam-in hawang. Haka hikaw ay hinumigla pon ha hawang na. ");
INSERT INTO sgb_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pêtêg ya impamwang ni Juan, ya tungkol kangko, noa, maalagá pon bayro ya pandaygên ko, ya an-ipadyag na kangko ni Apo Namalyari, ya Tatang ko. Habaytoy pamaptêg ya in-utoh na ko. ");
INSERT INTO sgb_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Haka hi Apo Namalyari, ya Tatang ko, ya namiutoh kangko, ay namipamwang, ya hikoy Cristo. Minghan man, ay a yo nagilam ya pamaghabi na, ni nahêlêk ya lupa na. ");
INSERT INTO sgb_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Haka a yo intanêm ya hinabi na ha nakêm yo, gawan a kaw ampaniwala kangko, ya in-utoh na. ");
INSERT INTO sgb_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ampakapag-aralan yoy Kahulatan ya impahulat ni Apo Namalyari, ta êndat yo no daygên yoy habayto, ay madyanan kaw hên biyay ya ayn angga. Ha Kahulatan ay impamwang ya tungkol kangko. ");
INSERT INTO sgb_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Noa, a kaw ampaidani kangko, ta êmên kaw madyanan biyay ya ayn angga. ");
INSERT INTO sgb_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“A ko ampanapol hên pamagpuri hên tawo, ");
INSERT INTO sgb_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","gawan muwang ko ya a yo anlugurên hi Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","In-utoh na ko di ni Apo Namalyari, ya Tatang ko, noa, a yo ko paniwal-an. No main lumatêng di ya ampamitag-ay hên sarili na, ay ampaniwal-an yo ya. ");
INSERT INTO sgb_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","A kaw ampaniwala kan Apo Namalyari gawan antapolên yoy pamandayêw hên kapareho yo, haka a kaw ampanapol hên pamandayêw ni Apo Namalyari, ya kamiha-mihaan Diyos. ");
INSERT INTO sgb_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Paan yon ihipên ya hikoy mamidikil kamoyu ha arapan ni Apo Namalyari, ya Tatang ko. Hi apo Moises, ya mamidikil kamoyu ta êndat yo ya anhonolên yoy intoro na. ");
INSERT INTO sgb_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","No pêtêg dayi ya paniwala yo ha hinulat ni apo Moises, ay paniwal-an yo ko etaman, ta nanulat ya hên tungkol kangko. ");
INSERT INTO sgb_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Noa, gawan a kaw ampaniwala ha hinulat ni apo Moises ya tungkol kangko, ay a kaw etaman maniwala ha habi ko!” ");
INSERT INTO sgb_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Amêhên, namatah hilan Apo Jesus ha lipay hên Dagat-dagatan hên Galilea, ya ambaêgên lan kaatag ya Dagat-dagatan hên Tiberias. ");
INSERT INTO sgb_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kal-atan ya ampakihonol kanla, gawan kapapaêpapah ya dinyag na ha pamaalíh hên hakit lan ampaghakit. ");
INSERT INTO sgb_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Nilumakat hilan Apo Jesus ha babo, ta nikno ya bayro hên kalamo na hilay tagahonol na. ");
INSERT INTO sgb_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Hên habayto ay marani ya Pista hên Kaligtasan. ");
INSERT INTO sgb_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Nahên manlêk hi Apo Jesus ay nahêlêk nay kal-atan ya andumani kanla. Hinabi na kan Felipe, “Antoy mapanaliwan tamon maipakan kanlan hata kal-atan?” ");
INSERT INTO sgb_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Hinabi nay habayto ta hêlkên na no ay-êmên ya paniwala ni Felipe. Muwang nay na ni Apo Jesus ya daygên na. ");
INSERT INTO sgb_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Hinabi ni Felipe kana, “Apo, kulang pon ya suweldo hên mihay katawo ha anêm ya buwan hên panaliw hên maêkan lan hata kal-atan, agyan manipêrad bat ya kaên la.” ");
INSERT INTO sgb_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Miha kanlan tagahonol ni Apo Jesus ya hi Andres, ya kapotoh pohêl ni Simon Pedro ya naghabi, ");
INSERT INTO sgb_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Main mihay anak ya lalaki di, ya main limay puto, haka loway kênan lanêm. Noa, kulang ya habayto ha kal-atan.” ");
INSERT INTO sgb_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Amêhên, wani Apo Jesus, “Paiknoên yo hila.” Makwal ya pagpastolan bayro, kabay nikno hilay liman libo ya lalaki haka hilay kalamo la. ");
INSERT INTO sgb_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kingwa ni Apo Jesus ya hatoy limay puto, haka panga-ubat nan impahalamat ya habayto kan Apo Namalyari, ay indin na kanlan ampikno ta pinitatayakan la. Êmbayro êt ya dinyag na ha kênan lanêm. Nangan hila hên angga ha mabay hila. ");
INSERT INTO sgb_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nahên nabhoy hila ay impa-tsipon ni Apo Jesus kanlan tagahonol na ya natagan, ta êmên ayn mahayang. ");
INSERT INTO sgb_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Kabay tsinipon lay na ya tagan. Nakapno hila êt hên labinloway lubon hên tagan hên hatoy limay puto. ");
INSERT INTO sgb_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Gawan nahêlêk lan kal-atan ya habaytoy kapapaêpapah, ya dinyag ni Apo Jesus, ay hinabi la, “Hiyan taganá ya Cristo, ya Propeta ya an-êngganan tamo, ya in-utoh di ha luta.” ");
INSERT INTO sgb_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Nahên namwangan ni Apo Jesus, ya labay la hên dumani kana, ta palêkpêkên la ya hên daygên ari la, ay nagpabokol yan nilumakat ha bung-oy hên nanalangin. ");
INSERT INTO sgb_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nahên yabi yana, nilumohan hilay tagahonol na ha dagat-dagatan. ");
INSERT INTO sgb_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Hinumakay hila ha mihay bangka ta lumipay, ha balayan Capernaum. Nariglêm ana, noa, ayn ya êt hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Hinumkaw ya angin, kabay matandulon ha dagat-dagatan. ");
INSERT INTO sgb_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nahên nidayo hilay na hên lima, o anêm ya kilometro ha laylay hên lanêm, ay nahêlêk la hi Apo Jesus, ya ampammita ha lanêm, hên andumani ha bangka. Nalimwan hila, ta êndat la no hiya ay mihay kamana. ");
INSERT INTO sgb_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Noa, wana kanla, “Paan kaw malimo! Hikoy habaytsi!” ");
INSERT INTO sgb_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kabay mahigla la yan hinagyat hên pinahakay ha bangka, haka tambêng hilan nakalatêng ha dani hên Capernaum. ");
INSERT INTO sgb_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ha humonoy allo, bayro ha ubatan lan Apo Jesus, ay an-êngganan la yan kal-atan. Êndat la no a ya pon nag-alíh bayro, ta nahêlêk la, ya a ya hinumakay ha bangka hên kalamo na hilay tagahonol na, ta kakapag la ya hinumakay bayro, haka ayn kaatag ya bangka bayro. ");
INSERT INTO sgb_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Amêhên, main ungnoy bangka ya ubat ha Tiberias ya nilumatêng bayro ha narani ha pinanganan lan puto hên ubat nan pinahalamatan ni Panginoon Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nahên namwangan lan tawo ya ayn ana bayro hi Apo Jesus, haka ayn etaman bayro hilay tagahonol na, ay hinumakay hila bayro ha nilumatêng ya bangka, ta tapolên la hi Apo Jesus ha Capernaum. ");
INSERT INTO sgb_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nahên natapol la ya ha lipay lanêm ay hinabi la kana, “Mánoro, nakano kan nilumatêng di?” ");
INSERT INTO sgb_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Kabay wani Apo Jesus, “Pakagilamên yo, antapolên yo ko, gawan nabhoy kaw ha puto ya pinalakê ko, alwan gawan naintindihan yoy kapapaêpapah ya dinyag ko. ");
INSERT INTO sgb_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Alwan kakapag pamangan ya angkaronot, ya dapat yon pagpagalan. Noa, dapat pagpagalan yo etaman ya pamangan ya makab-in biyay, ya ayn angga hên kalamo ni Apo Namalyari. Hiko ya Taga-Langit, ya In-anak Tawo, ya mam-i kamoyu hên pamangan ya makab-in biyay, ta hikoy dinyanan kapangyarihan ni Apo Namalyari, ya Tatang ko.” ");
INSERT INTO sgb_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Amêhên, kinotang la kan Apo Jesus, “Apo, hinoy kailangan naên daygên, ta êmên kay makadyag hên kalabayan ni Apo Namalyari?” ");
INSERT INTO sgb_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Kabay wani Apo Jesus, “Habaytsi ya labay ni Apo Namalyari ya daygên yo: paniwal-an yo ya hikoy Cristo ya in-utoh na.” ");
INSERT INTO sgb_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Kabay wanla kana, “Apo, no êmbayro, ay hinoy kapapaêpapah ya daygên mo, ta êmên kay maniwala ya hika ya Cristo? Hinoy daygên mo? ");
INSERT INTO sgb_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ya ninuno tamo ay nangan hên manna ha kabalah-balahan hên êmên ha nakahulat ha habi ni Apo Namalyari, ‘Dinyanan na hilan kaên ya ubat ha langit.’” ");
INSERT INTO sgb_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Amêhên, wani Apo Jesus kanla, “Pakagilamên yo. Alwan hi apo Moises, noa, hi Apo Namalyari ya nam-i kanlan ninuno yo hên manna ya kaên ya ubat ha langit. Haka amêhên hi Apo Namalyari, ya Tatang ko, ay ampam-i kamoyu hên pêtêg ya kaên, ya ubat ha langit. ");
INSERT INTO sgb_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ta ya pêtêg ya kaên, ya pan-idin ni Apo Namalyari, ay yabay ya ubat ha langit, ya ampam-in biyay ya ayn angga ha tawo.” ");
INSERT INTO sgb_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Amêhên, hinabi la kana, “Panginoon, lawah mo kay dayi hên dyanan hên habaytoy kaên.” ");
INSERT INTO sgb_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Wani Apo Jesus kanla, “Hikoy kaên ya ampam-in biyay ya ayn angga. Hilay andumani kangko, ay a lonohên, haka hilay ampaniwala kangko, ay ahina hên maangan oman. ");
INSERT INTO sgb_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Noa, hinabi kina kamoyu ya nahêlêk yo ko man, ay a kaw maniwala kangko. ");
INSERT INTO sgb_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tinalagá ni Apo Namalyari, ya Tatang ko no hino hilay makapakilamo kangko. Dumani hila kangko haka tanggapên ko hila. ");
INSERT INTO sgb_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ta ubat ako ha langit, ta êmên ko daygên ya kalabayan ni Apo Namalyari ya namiutoh kangko, alwan para daygên ya kalabayan ko. ");
INSERT INTO sgb_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ya kalabayan nan namiutoh kangko, ay ha Allon Pamanukom, ay biyayên kon oman hilay tinalagá na hên makapakilamo kangko. ");
INSERT INTO sgb_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ta ya kalabayan ni Apo Namalyari, ya Tatang ko, ay hilay ampakamwang kangko, haka ampaniwala kangko, ya Anak na, ay dyanan biyay ya ayn angga. Haka hiko ya mamabiyay kanla ha Allon Pamanukom.” ");
INSERT INTO sgb_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Hên ampaghabi ya êt hi Apo Jesus, ay main Israelita ya nagmulongan, gawan hinabi na ya hiyay kaên ya ubat ha langit. ");
INSERT INTO sgb_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Amêhên, nagmulongan hila, ya wanla, “Hiya hi Jesus ya anak ni Jose. Kilala tamoy indo na haka tatang na. Ay-êmên nan mahabi ya ubat ya ha langit?” ");
INSERT INTO sgb_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Kabay wani Apo Jesus, “Paan kaw magmulongan hên êmbayro. ");
INSERT INTO sgb_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ayn makarani kangko no a hila ipakarani kangko ni Apo Namalyari, ya Tatang ko, ya namiutoh kangko. Haka hikon taganá ya mamabiyay kanla ha Allon Pamanukom. ");
INSERT INTO sgb_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nakahulat ha mihay hulat lan mámipamwang ni Apo Namalyari hên hato, ‘Toroan hilangan ni Apo Namalyari.’ Kabay kaganawan ya ampanggilam habi ni Apo Namalyari haka ampakamwang bayro, ay dumani kangko. ");
INSERT INTO sgb_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Habaytoy a labay habiên ya main nanan nakahêlêk kan Apo Namalyari, ya Tatang ko, ta ayn nakahêlêk kana no alwan kakapag ko ya ubat kana. ");
INSERT INTO sgb_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Pakagilamên yo. Hilay ampaniwala kangko, ay main biyay ya ayn angga. ");
INSERT INTO sgb_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Hikoy nanad kaên ya ampam-in biyay ya ayn angga. ");
INSERT INTO sgb_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Hi Apo Namalyari ay nam-in kaên ya ambaêgên lan manna kanlan ninuno yo hên haton atsi hila ha kabalah-balahan, êmbayro man ay natsi hila. ");
INSERT INTO sgb_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Noa, hilay mangan hên pêtêg ya kaên ya ubat ha langit, ya inungkat ko, ay ahinan matsi. ");
INSERT INTO sgb_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Haka hiko ya maialimbawa ha pêtêg ya kaên ya ubat ha langit, ya ampam-in biyay ya ayn angga. Hilay mangan habaytsi ya kaên ay madyanan biyay ya ayn angga. Ya kaên ya idin ko ay lawini ko, ta êmên kaganawan ay madyanan biyay ya ayn angga.” ");
INSERT INTO sgb_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Gawan habaytoy hinabi ni Apo Jesus, ay nihuhubakan hilay kaatag Israelita, ya wanla, “Ay-êmên nan maidin kantamoy lawini na, ta êmên tamon kaên ya habayto?” ");
INSERT INTO sgb_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kabay wani Apo Jesus, “Pakagilamên yo. No a kaw mangan lawini ko, hên Taga-Langit, ya In-anak Tawo, haka no a kaw minêm daya ko, ay ayn kaw hên biyay ya ayn angga. ");
INSERT INTO sgb_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Hilay ampangan hên lawini ko, haka ampinêm hên daya ko, ay main biyay ya ayn angga, haka biyayên ko hila ha Allon Pamanukom. ");
INSERT INTO sgb_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ya lawini ko ay mantêg kaên haka ya daya ko ay mantêg pan-inêmên. ");
INSERT INTO sgb_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Hilay ampangan hên lawini ko haka ampinêm hên daya ko ay main pakikimiha kangko, haka hikoy main pakikimiha kanla. ");
INSERT INTO sgb_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","In-utoh ako ni Apo Namalyari, ya Tatang ko, ya angkabiyay. Haka angkabiyay ako gawan ha kapangyarihan na. Êmên êt bayro mabiyay hilay mangan lawini ko gawan ha kapangyarihan ko. ");
INSERT INTO sgb_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Hikoy maialimbawa ha pêtêg ya kaên ya ubat ha langit, haka hilay mangan hên habaytsi, ay mabiyay hên ayn angga. Habaytsi ya kaên ay alwan nanad ha kaên ya indin ha ninuno yo. Nangan hila noa, natsi hila morin.” ");
INSERT INTO sgb_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Hên hinabi ni Apo Jesus ya habayto, ay atsi ya ha sinagoga ha Capernaum hên ampanoro. ");
INSERT INTO sgb_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Mal-at kanlan antoroan ni Apo Jesus, ya nanggilam hên habaytoy hinabi na, ay naghabin, “Nabyat ya habaytoy hinabi na. Kayno ayn maniwala kana.” ");
INSERT INTO sgb_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Muwang ni Apo Jesus ya nagmulongan hilay kaatag ya antoroan na, kabay hinabi na, “Gawan habaytoy hinabi ko, ay labay yo kon lakwanan? ");
INSERT INTO sgb_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Hino awud ya daygên yo no mahêlêk yo ko, ya Taga-Langit, ya In-anak Tawo, hên paitag-ay ha langit, ha ubatan ko? ");
INSERT INTO sgb_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ya Espiritu ni Apo Namalyari ya mam-in biyay ya ayn angga. Alwan tawo ya ampam-in habayto. Ya hinabi ko ay ubat ha Espiritu ni Apo Namalyari, haka habaytoy ampam-in biyay ya ayn angga. ");
INSERT INTO sgb_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Noa, main kaatag kamoyu ya a ampaniwala ha hinabi ko.” Ta ubat hên una, ay muwang nay na ni Apo Jesus no hino hila ya a maniwala kana, haka no hino ya mangi-upit kana. ");
INSERT INTO sgb_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Wana êt, “Gawan muwang ko ya main kamoyu ya a ampaniwala kangko, ay hinabi ko ya ayn makapaidani kangko no alwan kalabayan ni Apo Namalyari, ya Tatang ko.” ");
INSERT INTO sgb_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Paubat hên habayto ay nilakwanan la hi Apo Jesus hên mal-at kanlan antoroan na, haka a hilay na ampakihonol kana. ");
INSERT INTO sgb_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Amêhên, hinabi ni Apo Jesus kanlan labinloway tagahonol na, “Labay yo ko etaman hên lakwanan?” ");
INSERT INTO sgb_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Kabay wani Simon Pedro, “Panginoon, hino ya lakwên naên? Kakapag mo ya main habi ya ampam-in biyay ya ayn angga! ");
INSERT INTO sgb_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ampaniwala kay kamo, haka muwang naên taganá ya hika ya Cristo, ya ayn hinon kasalanan, ya in-utoh ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Amêhên, hinabi ni Apo Jesus kanla, “Awo, gawan hikoy namili kamoyu, ya labinloway tagahonol ko. Êmbayro man, ya miha kamoyu ay mahuloran ni Satanas.” ");
INSERT INTO sgb_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ya inungkat na, ay yabay ya miha kanlan labinloway tagahonol na, ya hi Judas, ya anak ni Simon, ya taga-Iscariote ta hiyay mangi-upit kana. ");
INSERT INTO sgb_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Amêhên, ay nanoro ya tana hên kalamo na hilay tagahonol na ha probinsyan Galilea. A nay na pon labay hên manoro ha probinsyan Judea, gawan labay la yan patsên bayro hên poon lan Israelita. ");
INSERT INTO sgb_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Marani yanay Pista hên Tolda, yabay ya mihay pista lan Israelita ta êmên la maihipan ya pamangillag ni Apo Namalyari ha ninuno la, haton atsi hila ha kabalah-balahan. ");
INSERT INTO sgb_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Kabay hinabi hên ali na kana, ya wanla, “Awta a ka mag-alíh din maniraw ha probinsyan Judea, ta êmên hilay anhumonol kamo bayro, ay makahêlêk hên kapapaêpapah, ya andaygên mo. ");
INSERT INTO sgb_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ta no labay mo hên mamwangan la ya tungkol kamo, ay ipamwang minay andaygên mo. No ampanyag ka hên kapapaêpapah, ay ipamwang mina dayi.” ");
INSERT INTO sgb_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Hinabi lay habayto ta hila man, ay a ampaniwala kana. ");
INSERT INTO sgb_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Hinabi ni Apo Jesus kanla, “Laamêhên akon mita, ta alwa ko pon oras. Noa, hikaw, ay malyari kaw nan mita ha hinoman ya oras ya labay yo. ");
INSERT INTO sgb_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Alwan hikaw ya angkahêmêkan lan tawo, noa, hikoy angkahêmêkan la, gawan an-ipamwang ko ya nangarawak ya dyag la. ");
INSERT INTO sgb_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Hikaw tana ya makipista, ta a kina pon makipista gawan alwa pon oras hên hikoy mita.” ");
INSERT INTO sgb_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Pangahabi nan habayto ay napaibalag ya ha Galilea. ");
INSERT INTO sgb_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Hên nammitay nay ali na, ay nammita ya etaman hên ayn nakamwang. ");
INSERT INTO sgb_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Bayro ha balayan Jerusalem ay antapolên la yan poon lan Israelita ha pista, ta wanla, “Anto ya?” ");
INSERT INTO sgb_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ampihahabian lan tawo no hino ya. Main naghabi, “Mangêd yan tawo.” Wanla etaman hên kaatag, “Anlokoên nay tawo.” ");
INSERT INTO sgb_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Noa, gawan ha limo la kanlan ampamaala, ay ayn naghabi hên tungkol kana ha arapan lan kal-atan. ");
INSERT INTO sgb_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Hên ika-apat ya allo hên pista, ay hinumwên hi Apo Jesus ha Templo, ta nanoro ya bayro. ");
INSERT INTO sgb_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nakaêpapah hilay poon lan Israelita, ta wanla, “Antoy pinangwanan nan hata tawo, hên kamwangan na, ya a ya man nag-aral?” ");
INSERT INTO sgb_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Kabay wani Apo Jesus, “Ya pan-itoro ko ay alwan ubat kangko, noa, ubat kan Apo Namalyari ya namiutoh kangko. ");
INSERT INTO sgb_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Hilay mabay hên manyag kalabayan na, ay mamwangan, no ya an-itoro ko ay ubat kana, o no panhabiên kon bat ya laman ihip ko. ");
INSERT INTO sgb_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Hilay ampamitoro hên ubat ha sarili lan kaihipan, ay ampanapol hên pamandayêw hên kapareho la. Noa, hilay mabay hên padayêw ya namiutoh kanla ay mapaypaniwal-an haka taganán alwan malaram. ");
INSERT INTO sgb_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Hi apo Moises ya nam-i kamoyu hên Kautuhan ni Apo Namalyari. Noa, a yo anhonolên ya habayto, ta labay yo kon patsên.” ");
INSERT INTO sgb_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nahên nahabi nay habayto, ay wanla, “Nahapatan kan narawak ya a angkahêlêk. Ayn mabay hên mamatsi kamo!” ");
INSERT INTO sgb_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Wani Apo Jesus, “Mimihay dinyag ko ha allon pamagsimba haka naubuh kaw hên nag-êpapah. ");
INSERT INTO sgb_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Dinyanan na kaw ni apo Moises hên utoh ya tuliên yoy anak yo ha ikawalon allo hên ubat in-anak, haka an-ipatuli yo hila, allo man hên pamagsimba. Habayto ay manan ugali lan ninuno yo bayo dinyag ya Kautuhan ni apo Moises ya ubat kan Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","No an-ipatuli yoy anak yo ha allon pamagsimba, ta êmên mahonol ya Kautuhan ni apo Moises, awta anhulukên yo ko gawan namaalíh akon hakit hên boon lawini hên mihay lalaki ha allon pamagsimba! ");
INSERT INTO sgb_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Paan kaw bat mam-in hatol ha angkahêlêk yon bêngat, noa, imbistigaên yo pon bayo kaw manatol.” ");
INSERT INTO sgb_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Amêhên, main kanlan taga-Jerusalem ya naghabi, “Yabay ya labay lan patsên hên poon tamo. ");
INSERT INTO sgb_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Atsi ya di hên ampaghabi ha arapan hên kal-atan haka a la ya bawalên. Kayno muwang lan poon, ya pêtêg ya, hên hiyay Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala. ");
INSERT INTO sgb_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Noa, muwang tamo no ay-iri yan mangubat, haka no lumatêng ya pêtêg ya Mesias, ya Cristo, ay ayn kanon makamwang no ay-iri yan mangubat.” ");
INSERT INTO sgb_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Kabay in-ikhaw ni Apo Jesus ya pamaghabi na ha panoro na ha Templo. “Awo, muwang yo no hino ko, haka no ay-iri kon nangubat. Noa, main namiutoh kangko, haka a yo ya muwang ya habayto. Hiyay pêtêg. ");
INSERT INTO sgb_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Kilala ko ya, ta hiyay namiutoh kangko, haka ubat ako kana.” ");
INSERT INTO sgb_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Kabay labay la yan dakpên, noa, ayn makarakêp kana, ta alwa na pon oras. ");
INSERT INTO sgb_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Noa, mal-at ya naniwala ya hiyay Mesias, ya Cristo, ta wanla, “No alwa yan Mesias, ya Cristo ya habaytsi, no lumatêng ya pêtêg ya Mesias, ya Cristo, ay makadyag ya kaya hên mal-at pon ya kapapaêpapah?” ");
INSERT INTO sgb_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nagilam lan Pariseo ya pagmulong lan tawo ya tungkol kan Apo Jesus. Kabay namiutoh hila, haka hilay ampamaala kanlan pari hên tanod hên Templo, hên dakpên ya. ");
INSERT INTO sgb_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Amêhên, wani Apo Jesus, “Pêrad tanay panahon hên makalamo yo ko, ta ahina mabuyot ay mag-orong kina ha namiutoh kangko. ");
INSERT INTO sgb_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Tapolên yo ko bayto. Noa, a yo ko matapol gawan a kaw makalako ha lakwên ko.” ");
INSERT INTO sgb_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Kabay wanlan poon lan Israelita ha miha ta miha, “Ato awud ya lakwên na ta a tamo ya matapol? Mako ya kaya kanlan Israelita, ya atsi bayro ha bansan Griego, ta toroan na hila, haka hilay kabansa la?” ");
INSERT INTO sgb_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","“Hino awud ya labay habiên hên hata hinabi na, ‘Tapolên yo ko man, ay a yo ko mahêlêk,’ haka ‘Ya lakwên ko, ay a yo malako’?” ");
INSERT INTO sgb_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ha ikawalon allo, ya pinakamaalagáy allo hên pista, ay nirêng hi Apo Jesus, ta nan-angaw ya, “No angkaangan kaw, ay dumani kaw kangko, ta minêm kaw. ");
INSERT INTO sgb_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nakahulat ha Kahulatan ya impahulat ni Apo Namalyari, ‘No maniwala kaw kangko, ay magkamain kaw hên biyay ya nanad sibol ha nakêm yo ya a angkaubuhan lanêm.’” ");
INSERT INTO sgb_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ya inungkat ni Apo Jesus, ay Espiritu ni Apo Namalyari, ya idin ha balang ampaniwala kana. A ya pon na-idin ya hatoy Espiritu ni Apo Namalyari, gawan a ya pon natsi, haka nabiyay oman hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Main kanlan kal-atan bayro ya nakagilam hên hinabi ni Apo Jesus, ya naghabin, “Yabay yan taganá ya Propeta ni Apo Namalyari, ya an-êngganan tamo.” ");
INSERT INTO sgb_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Hilay kaatag, ay naghabin hiyay Mesias, ya Cristo. Noa, wanlan kaatag pon, “A ya maubat ha Galilea ya Mesias. ");
INSERT INTO sgb_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Nakahulat ha Kahulatan ya impahulat ni Apo Namalyari ya hiyay Mesias, ay maubat ha kaapo-apoan ni Arin David, haka ha Betlehem yan ianak ha balayan ni Arin David.” ");
INSERT INTO sgb_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Alwan mimihay ihip lan kal-atan ya tungkol kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Labay lan kaatag, hên dakpên ya, noa, a la ya dinakêp. ");
INSERT INTO sgb_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nahên nag-orong hilay tanod hên Templo kanlan ampamaala kanlan pari haka kanlan Pariseo, ay kinotang lan Pariseo kanlan tanod, “Awta a yo ya gintan di?” ");
INSERT INTO sgb_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Wanlan guardya etaman, “A naên ya dinakêp, ta ayn kay êt nagilam ya magaling maghabi hên nanad kana.” ");
INSERT INTO sgb_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Amêhên, hinabi lan Pariseo, “Kayno naamuyot na kaw etaman. ");
INSERT INTO sgb_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ayn kannaên ya Pariseo o manungkulan ya ampaniwala kana. ");
INSERT INTO sgb_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kakapag lan kal-atan, ya ayn muwang hên tungkol ha Kautuhan tamon Israelita, ay ampaniwala kana. Parusaan hila ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ya miha kanlan Pariseo bayro ay hi Nicodemo, ya dinumani kan Apo Jesus hên hato. Wana kanan kalamo na, ");
INSERT INTO sgb_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Bawal kanlan Kautuhan tamo hên parusaan ya mihay tawo, no a ya pon naimbistiga.” ");
INSERT INTO sgb_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Kabay wanla kan Nicodemo, “Taga-Galilea ka etaman? Bahaên moy Kahulatan ya impahulat ni Apo Namalyari, haka mo mamwangan ya ayn propeta ni Apo Namalyari ya maubat ha Galilea.” ");
INSERT INTO sgb_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Bayo nuli hilangan. ");
INSERT INTO sgb_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Hi Apo Jesus etaman, ay nilumakat ha Tawgtug Olibo. ");
INSERT INTO sgb_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Hên pangamaranon, ay nilumatêng yay na êt ha Templo hên manoro. Mal-at ya dinumani kana hên labay manggilam habi na, kabay nikno yan nanoro kanla. ");
INSERT INTO sgb_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Kaban ampikno ya bayro, ay main nilumatêng ya kaatag kanlan mánoron Kautuhan ni apo Moises, haka ya kaatag kanlan Pariseo. Main hilan gintan ya mihay babayi ya narakêp ha pamakilalaki. Pinairêng la ya ha arapan lan kal-atan. ");
INSERT INTO sgb_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Bayo wanla kan Apo Jesus, “Mánoro, hata babayi ay narakêp ha pamakilalaki. ");
INSERT INTO sgb_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nakahulat ha Kautuhan ni apo Moises ya kailangan batoên ya hilay babayi ya êmên di angga ha matsi hila. Noa, hinoy mahabi mo ya tungkol kana?” ");
INSERT INTO sgb_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Hinabi lay habayto ta subukên la ya no magkamali hi Apo Jesus ha pakibat na, ta êmên hila magkamain hên ibara kana. Ya dinyag ni Apo Jesus ay, napaiyoko ya, ta pinanulat nay panoron gamêt na ha luta. ");
INSERT INTO sgb_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Gawan ha pamihundo lan mangotáng kana, ay nirêng ya, ta wana, “No main kamoyu ya a nakadyag hên hinon bawal ha Kautuhan, ay hiyay munan mamato kana.” ");
INSERT INTO sgb_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nahên nahabi nay habayto, ay inhundo nay panulat na ha luta. ");
INSERT INTO sgb_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Hên pamakagilam lan hinabi na, ay tsiha-tsiha hilan nammita ya hilay nantan habaytoy babayi kan Apo Jesus. Nunan nammita hilay matoa kanla. Nabalag tana hi Apo Jesus haka hatoy babayi, ya nakairêng ha arapan na. ");
INSERT INTO sgb_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Amêhên, nirêng hi Apo Jesus ta hinabi na kanan babayi, “Anto hilay nay nantan kamo di? Ayn namarusa kamo?” ");
INSERT INTO sgb_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Kabay wanan babayi, “Ayn Apo.” Amêhên, wani Apo Jesus, “Hiko man, ay a kata parusaan. Mita kay na, haka itêgên minay pamanyag mon kasalanan.” ");
INSERT INTO sgb_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Amêhên, naghabi yay na êt ha kal-atan hi Apo Jesus. Wana kanla, “Hikoy hawang lan tawo. Hilay humonol kangko, ay madyanan hawang, ya ampam-in biyay, ya ayn angga hên kalamo ni Apo Namalyari. Maalíh ya kariglêman nakêm la.” ");
INSERT INTO sgb_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Kabay wanlan Pariseo kana, “Mimiha mo, ya ampaghabin habain, kabay a ya malyarin paniwal-an ya habi mo.” ");
INSERT INTO sgb_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Wani Apo Jesus kanla, “Ampamaptêg ako man hên tungkol ha sarili ko, ay malyari yon paniwal-an ya anhabiên ko, ta muwang koy ubatan ko, haka muwang ko ya lakwên ko. Noa, a yo muwang ya ubatan ko, haka a yo muwang ya lakwên ko. ");
INSERT INTO sgb_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ya pamanatol yo ay ubat ha kaihipan yo di ha luta, noa, a ko anhatolan ya hinoman. ");
INSERT INTO sgb_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","No manatol ako man, ay makatoynungan ya pamanatol ko, ta alwan kakapag ko ya ampanatol, ta kalamo ko hi Apo Namalyari, ya Tatang ko, ya namiutoh kangko. ");
INSERT INTO sgb_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ha Kautuhan yo, ay nakahulat ya no pareho ya pamaptêg hên loway katawo, ay dapat paniwal-an ya pamaptêg la. ");
INSERT INTO sgb_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Lowa kay ya ampamaptêg hên tungkol kangko. Hikoy ampaghabi hên tungkol kangko, haka hi Apo Namalyari, ya Tatang ko, ya namiutoh kangko, ay ampamaptêg êt, kabay mapaniwal-an yoy anhabiên naên.” ");
INSERT INTO sgb_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kabay hinabi la kana, “Antoy tatang mo?” Wani Apo Jesus, “A yo ko kilala, haka a yo kilala ya Tatang ko. No kilala yo ko dayi, ay makilala yo etaman ya Tatang ko, hi Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Hinabi ni Apo Jesus ya habayto hên ampanoro ya ha dani hên pamyanan hên pera ya an-ialay ha Templo. Ayn nandakêp kana, ta alwa na pon oras. ");
INSERT INTO sgb_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Amêhên, hinabi nay na êt kanla, “A mabuyot ay mita kina. Kanan habayto ay pakatapolên yo ko, noa, matsi kaw hên a kaw napatawad. A kaw makalako ha lakwên ko.” ");
INSERT INTO sgb_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Amêhên, hinabi lan poon lan Israelita, “Kayno magpakamatsi ya. Ta wana, ‘A kaw makalako ha lakwên ko.’” ");
INSERT INTO sgb_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Amêhên, wana kanla, “Hikaw ay taga-bayri, ha luta. Hikoy taga-langit. ");
INSERT INTO sgb_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kabay hinabi kina kamoyu, ya matsi kaw hên a kaw pon mapatawad. Ta a kaw mapatawad, no hikaw ay a maniwala ya ‘Hikoy Hiko taganá.’” ");
INSERT INTO sgb_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Amêhên, hinabi la kana, “Hino ka?” Kabay wani Apo Jesus kanla, “Hiko ya hatoy hinabi kina kamoyu paubat hên una. ");
INSERT INTO sgb_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mal-at ya mahabi ko, ya maipintas kamoyu. Noa, pêtêg ya habi ni Apo Namalyari ya namiutoh kangko, haka ipamwang kon bêngat ya nagilam ko kana.” ");
INSERT INTO sgb_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","A la naintindihan ya ampaghabi ya hên tungkol kan Apo Namalyari, ya Tatang na. ");
INSERT INTO sgb_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Kabay wani Apo Jesus, “Lano no naipako yo kina ha koros, ay mamwangan yoy na ya hiko, ya Taga-Langit, ya In-anak Tawo, ay hikoy Mesias, ya Cristo ya nanad ha hinabi kina. Kanan habayto, ay mamwangan yo etaman, ya kaganawan dyag ko, haka habi ko, ay impadyag kangko ni Apo Namalyari, ya Tatang ko. ");
INSERT INTO sgb_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Kalamo ko di hi Apo Namalyari, ya namiutoh kangko. A na ko anlakwanan, ta panay kon andaygên ya kalabayan na.” ");
INSERT INTO sgb_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Mal-at kanlay nakagilam hên habayto ay naniwalan hiyay Mesias, ya Cristo. ");
INSERT INTO sgb_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Amêhên, hinabi ni Apo Jesus kanlan Israelita, ya naniwala kana, “No ihundo yoy pamanhumonol yo ha an-itoro ko, ay hikaw ya pêtêg kon tagahonol, ");
INSERT INTO sgb_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ta mamwangan yoy kaptêgan, haka ya kaptêgan ay mamialíh kamoyu ha panga-ipoh.” ");
INSERT INTO sgb_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Kabay hinabi la, “Hikay ya kaapo-apoan ni apo Abraham. Haka a kay êt nagpa-ipoh. Awta hinabi mo ya mag-alíh kay ha panga-ipoh?” ");
INSERT INTO sgb_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Hinabi ni Apo Jesus kanla, “Pakagilamên yo. Hilay ampanyag kasalanan, ay ampagpa-ipoh ha kasalanan. ");
INSERT INTO sgb_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ya ipoh, ay ampakilamo bat ha pamilyan amo na, noa, ya anak nan amo ay kalamo bayro hên ayn angga. ");
INSERT INTO sgb_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","No hiko, ya Anak ni Apo Namalyari, ya mamibuhan kamoyu ha pangaipoh yo, ay taganán mibuhan kaw ha pangaipoh. ");
INSERT INTO sgb_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Muwang koy kaapo-apoan kaw ni apo Abraham. Noa, kaapo-apoan kaw man ni apo Abraham, ay labay yo kon patsên, gawan a yo labay pahowênên ya habi ko ha nakêm yo. ");
INSERT INTO sgb_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ya panhabiên ko, ay yabay ya namwangan ko kan Apo Namalyari, ya Tatang ko. Haka hikaw man, ay ampanyag hên namwangan yo ha tatang yo.” ");
INSERT INTO sgb_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Hinabi la kana, “Hi apo Abraham ya tatang naên.” Amêhên, hinabi ni Apo Jesus kanla, “No hikaw ay taganán anak ni apo Abraham, ay ampanyag kaw dayi hên dinyag na. ");
INSERT INTO sgb_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Noa, labay yo kon patsên, ya hiko ya ampaghabin kaptêgan, ya nagilam ko kan Apo Namalyari. Ayn yan dinyag hên êmbayro hi apo Abraham ta hiyay nanggilam kan Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ya pandaygên yo ay nanad ha dinyag hên tatang yo.” Kabay wanla kana, “Alwa kay anak hên kaatag. Mimihay Tatang naên haka yabay ya hi Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Bayo wani Apo Jesus, “No pêtêg ya hi Apo Namalyari ya Tatang yo, ay lugurên yo ko dayi, ta hikoy ubat kana, haka atsi kina di. A ko nilumatêng di hên gawan bat ha sarili kon ihip, noa, gawan in-utoh na ko. ");
INSERT INTO sgb_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","A yo angkaintindihan ya anhabiên ko, gawan a yo labay gilamên ya panhabiên ko. ");
INSERT INTO sgb_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Hi Satanas ya tatang yo. Ta no hinoy labay na, ay yabay ya andaygên yo. Hiyay mapamatsin tawo ubat hên haton una. A na labay ya kaptêgan, kabay pêrad man, ay ayn taganán kaptêgan kana. No maghabi ya, ay panay kalaraman ta taganán mapaglaram ya, haka hiyay ampangubatan hên kaganawan kalaraman. ");
INSERT INTO sgb_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Noa, gawan anhabiên koy kaptêgan, ay a yo ko ampaniwal-an. ");
INSERT INTO sgb_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Yarin main kamoyu ya makahabin nakadyag akon kasalanan? No pêtêg ya panhabiên ko, ay awta a yo ko paniwal-an? ");
INSERT INTO sgb_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Hilay ubat kan Apo Namalyari, ay ampanggilam habi na. Alwa kaw ubat kan Apo Namalyari, kabay a yo panggilamên ya habi na.” ");
INSERT INTO sgb_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Amêhên, hinabi lan Israelita kan Apo Jesus, “Pêtêg awud ya hinabi naên ya miha ka ya Samaritano ya nahapatan hên narawak ya a angkahêlêk.” ");
INSERT INTO sgb_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","“A ko nahapatan hên narawak ya a angkahêlêk ta muwang ko hên mam-in galang kan Apo Namalyari, ya Tatang ko. Noa, hikaw, ay a yo ko anggalangên. ");
INSERT INTO sgb_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","A ko etaman ampanapol hên galang yo. Noa, labay ni Apo Namalyari ya hikoy puriên, haka hiyay manatol. ");
INSERT INTO sgb_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Pakagilamên yo! Hilay manggilam habi ko, ay a matsi makanoman.” ");
INSERT INTO sgb_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Nahên nahabi nay habayto ay wanlan Israelita kana, “Muwang naên amêhên ya nahapatan ka hên narawak ya a angkahêlêk. Natsi ya hi apo Abraham angga hilay mámipamwang ni Apo Namalyari. Noa, panhabiên mo, ya hilay ampanggilam habi mo ay dyanan biyay ya ayn angga. ");
INSERT INTO sgb_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Makapangyarihan ka kaya kan apo Abraham ya natsi, haka kanlan mámipamwang ni Apo Namalyari ya natsi? Awta! Êndat mo no hino ka?” ");
INSERT INTO sgb_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Wani Apo Jesus, “No dayêwên koy sarili ko, ay ayn alagá ya habayto. Ya ampandayêw kangko ay Tatang ko, hi Apo Namalyari. Yabay ya panhabiên yo ya ansimbaên yo. ");
INSERT INTO sgb_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","A yo yan kilala. Noa, kilala ko ya. No habiên ko ya a ko ya kilala, ay hikoy malaram hên nanad kamoyu. Noa, kilala ko ya, haka anhonolên koy habi na. ");
INSERT INTO sgb_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Hinumigla ya ninuno yo, hi apo Abraham, hên namwangan na ya tungkol ha pamanlumatêng ko di. Hinumigla ya ta muwang na hikoy lumatêng.” ");
INSERT INTO sgb_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Wanlan Israelita kana etaman, “Ayn ka pon hên limampoy taon. Nabuyot yay nan natsi hi apo Abraham. Ay-êmên mo yan nahêlêk?” ");
INSERT INTO sgb_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Hinabi ni Apo Jesus, ya wana, “Pakagilamên yo! Bayo ya in-anak hi apo Abraham, ay Hikoy Hikina.” ");
INSERT INTO sgb_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Gawan hinabi nay habayto, ay namulot hilan bato, ta batoên la ya dayi. Noa, nipahalimbêng ya ha pibonakan lan tawo bayro, haka inumawah ya ha Templo hên a la ya namwangan. ");
INSERT INTO sgb_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ha pammita na ay nakahêlêk hi Apo Jesus hên mihay lalaki ya buwag paubat hên in-anak ya. ");
INSERT INTO sgb_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Kabay hinabi lan tagahonol na kana, ya wanla, “Mánoro, hinoy nanyag kasalanan, hata lalaki, o hilay toa na? Awta buwag yay na ubat hên in-anak ya?” ");
INSERT INTO sgb_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Hinabi ni Apo Jesus, “Ya pangabuwag na, ay alwan gawan kasalanan na, haka alwan gawan kasalanan hên toa na. Hiyay in-anak hên buwag ta êmên ipahlêk kana ya kapangyarihan ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Dapat tamon daygên ya an-ipadyag ni Apo Namalyari, ya namiutoh kangko kaban main pon panaon, ta uston lumatêng ya nanad yabi, ay ayn kitaminan madyag. ");
INSERT INTO sgb_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kaban atsi ko pon di ha luta, hikoy hawang lan tawo, ta êmên mahawangan ya kaihipan.” ");
INSERT INTO sgb_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nahên nahabi nay habayto, ay nandula ya ha luta. Bayo kingwa nay hata luta ta impunih na ha mata hên buwag. ");
INSERT INTO sgb_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Bayo wana kana, “Mita kay na, ta magkulamêh ka do ha lanêm ya pinata-ngalanan Siloe.” Ya labay habiên hên Siloe ay in-utoh. Nahên nadyag hên buwag ya in-utoh ni Apo Jesus kana, ay nuli ya hên ampakahêlêk. ");
INSERT INTO sgb_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Hilay karani nan bali, haka hilay kaatag hên kabalay na ay naghabi, “Habaytsi awud ya ampikno hên ampakikwan pera.” ");
INSERT INTO sgb_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Wanlan kaatag, “Yabay ya.” Noa, wanlan kaatag êt, “Kalupa na yan bat hên buwag.” Amêhên, wanan lalaki, “Hiko ya.” ");
INSERT INTO sgb_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Kabay wanla kana, “Ay-êmên nimukat ya mata mo?” ");
INSERT INTO sgb_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Hinabi na, “Ya lalaki, ya nag langan Jesus, ay nanyag hên pita ta impunih na ha mata ko. Bayo wana kangko, ya magkulamêh ako do ha lanêm ha Siloe. Dinyag koy hinabi na, kabay ampakahêlêk kina.” ");
INSERT INTO sgb_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Amêhên, wanla kana, “Anto yay na?” Hinabi na, “A ko muwang.” ");
INSERT INTO sgb_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Gintan lay hatoy lalaki, ya manan buwag ya ampakahêlêk, kanlan Pariseo. ");
INSERT INTO sgb_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Allon pamagsimba lan Israelita hên nanyag yan pita hi Apo Jesus, haka na pinamukat ya hata lalaki. ");
INSERT INTO sgb_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Amêhên, kinotang la yan Pariseo, no pata ampakahêlêk yay na. Kabay wana kanla, “Namipunih yan pita ha mata ko, bayo hên nagkulamêh ako, ay ampakahêlêk kina.” ");
INSERT INTO sgb_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Wanlan kaatag ya Pariseo, “Hi Jesus, ay alwan ubat kan Apo Namalyari, ta a na anhonolên ya Kautuhan, ya paan mag-obra ha allon pamagsimba.” Noa, wanlan kaatag, “No makasalanan ya, ay a ya makadyag hên êmbayro ya makapaêpapah.” Alwan mimihay ihip la. ");
INSERT INTO sgb_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kabay wanla kanan pinamukat, “Hika bay, ya pinamukat na. Hinoy mahabi mo ya tungkol kana?” Amêhên, wanan pinamukat, “Hiyay mihay propeta ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","A hila naniwala ya mana yan buwag, ya pinamukat. Kabay impabaêg lay toa na. ");
INSERT INTO sgb_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Hinabi la kanla, “Anak yoy hatsi ya buwag hên paubat hiyay in-anak? Ay-êmên ta ampakahêlêk yay na amêhên?” ");
INSERT INTO sgb_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Hinabi la, “Hiya ya anak naên, haka buwag yay na hên in-anak ya. ");
INSERT INTO sgb_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Noa, a naên muwang, no ay-êmên nimukat ya mata na. A naên etaman muwang, no hinoy namamukat kana. Kotangên yo ya, ta toa yay na. Habiên na no hinoy nalyari kana.” ");
INSERT INTO sgb_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Êmbayro ya hinabi lan toa na, gawan malimo hila ha Pariseo. Ta pinihabian lan poon lan Israelita, ya bawalên magsimba ha sinagoga ya hilay ampaghabi, ya hi Apo Jesus, ay hiya ya Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala. ");
INSERT INTO sgb_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Gawan namwangan lay pinihahabian hên poon la, ay hinabi lan toa na, “Hiya tana ya kotangên yo ta toa yay na.” ");
INSERT INTO sgb_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kabay impabaêg lan oman ya pinamukat haka la hinabi kana, “Puriên mo hi Apo Namalyari ta habiên moy kaptêgan. Muwang naên ya makasalanan ya hi Jesus.” ");
INSERT INTO sgb_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Amêhên, wanan pinamukat, “A ko muwang no makasalanan ya. Noa, muwang ko ya mana kon buwag, haka amêhên ampakahêlêk kina.” ");
INSERT INTO sgb_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Amêhên, hinabi la, “Hinoy dinyag na kamo? Ay-êmên nan pinamukat ya mata mo?” ");
INSERT INTO sgb_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Kabay wanan pinamukat, “Hinabi kina kamoyu, noa, a kaw nanggilam. Awta labay yon magilaman oman? Labay yo hên mag-in tagahonol na etaman?” ");
INSERT INTO sgb_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Minusmus la ya, ya wanla, “Hika ya tagahonol na. Noa, hikay ay tagahonol ni apo Moises. ");
INSERT INTO sgb_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Muwang naên ya naghabi hi Apo Namalyari kan apo Moises. Noa, a naên muwang no ay-iri ya taga hi Jesus.” ");
INSERT INTO sgb_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Wanan pinamukat, “Têh! Pinamukat nay mata ko haka a yo muwang no taga ay-iri ya! ");
INSERT INTO sgb_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Muwang tamo ya hi Apo Namalyari ay a na panggilamên hilay makasalanan, noa, gilamên nay balang ampagsimba kana haka ampanyag kalabayan na. ");
INSERT INTO sgb_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Paubat hên dinyag ya hata luta, ay ayn pon namamukat ha mihay tawo ya buwag paubat hên hiyay in-anak. ");
INSERT INTO sgb_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","No hiyay alwan ubat kan Apo Namalyari, ay a na madyag ya kapapaêpapah.” ");
INSERT INTO sgb_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Amêhên, hinabi la, “Makasalanan kan in-anak, haka labay mo kay hên toroan?” Nahên nahabi lay habayto, ay intaboy la ya ha sinagoga. ");
INSERT INTO sgb_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Namwangan ni Apo Jesus ya nalyari ha pinamukat na. Hên natapol na ya, ay wana kana, “Ampaniwala ka kanan Taga-Langit, ya In-anak Tawo?” ");
INSERT INTO sgb_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Wanan pinamukat, “Hino ya, Apo? Labay ko yan paniwal-an” ");
INSERT INTO sgb_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Wani Apo Jesus, “Angkahêlêk mina, ta hiko ya ampaghabi kamo ay habaytoy Taga-Langit, ya In-anak Tawo.” ");
INSERT INTO sgb_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Wanan pinamukat, “Panginoon, ampaniwala ko kamo!” Nandoko ya haka na sinimba hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Hinabi ni Apo Jesus, “Atsi ko ri ha luta ta hatolan koy tawo. Hilay ampangamin ya buwag ya nakêm la, ay makahêlêk hên kaptêgan. Hilay êndat lan ampakahêlêk hila, ay mabuwag ya nakêm la.” ");
INSERT INTO sgb_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Main Pariseo ha dani ni Apo Jesus ya nakagilam hên habaytoy hinabi na. Kabay wanla, “Yarin buwag ya nakêm naên etaman!” ");
INSERT INTO sgb_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Hinabi ni Apo Jesus kanla, “No ampangamin kaw dayi ya buwag ya nakêm yo, ay ayn kaw hên kasalanan. Noa, gawan anhabiên yo ya alwan buwag ya nakêm yo, ay a maalíh ya kasalanan yo.” ");
INSERT INTO sgb_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Wani Apo Jesus kanlan kal-atan, “Pakagilamên yo! Hilay anhumwên ha koral hên tupa, hên a magdann ha mantêg ilwangan, ay manakaw. ");
INSERT INTO sgb_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ya ampagdann ha mantêg ilwangan, ay mantêg pastol lan tupa. ");
INSERT INTO sgb_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Hilay tanod hên koral hên tupa ay ampanloat hên kabat, ta êmên ya makadann. Muwang lan tupa ya baêg hên maypastol kanla, ta baêgên nay langan la, haka humonol hila kana. ");
INSERT INTO sgb_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","No naubuh hên na-iawah ya tupa na, ay ampuna ya kanla, haka humonol hila kana, ta muwang lay pamaghabi na. ");
INSERT INTO sgb_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","A la honolên ya pamaghabi hên kaatag ta muwayu hila, ta a la mapuliah ya pamaghabi hên kaatag.” ");
INSERT INTO sgb_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","In-alimbawa ni Apo Jesus ya sarili na bayro, noa, a la naintindihan ya labay nan habiên. ");
INSERT INTO sgb_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Kabay hinabi nan oman kanla, “Pakagilamên yo! Hikoy ilwangan hên koral lan tupa. ");
INSERT INTO sgb_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Main nuna kangko ya nanoro hên alwan pêtêg. Hila ay maialimbawa ha mabay manakaw hên tupa. Noa, hilay tupa, ay a nanggilam ha pamaghabi la. ");
INSERT INTO sgb_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Hikoy nanad ilwangan. Hilay ampaniwala kangko, haka magdann kangko, ay miligtas. Malyari hilay nan humwên haka umawah, haka la matapol ya kaganawan kailangan la. ");
INSERT INTO sgb_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Hilay manakaw ay labay lan bat hên manakaw, mamatsi, haka manira. Noa, hiko, ay atsi ko di ha luta ta êmên mam-in biyay ya sagana ya ayn pamagkulang. ");
INSERT INTO sgb_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Hikoy mangêd ya pastol. Ya mangêd ya pastol ay nakal-an hên matsi ha ikakangêd hên tupa na. ");
INSERT INTO sgb_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Hilay an-upaan ya pastol, ay alwan nanad hên mangêd ya pastol, ya ampanlugud ha tupa na. No mahêlêk lay kapalimoy aho, ay lakwanan lay tupa, ta muwayu hila. Kabay patsên nan ahon lalê ya kaatag tupa, haka mipaplag hilay kaatag. ");
INSERT INTO sgb_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Muwayu hilay pastol, gawan an-upaan hilan bêngat. Alwa hila hên nanad ha mangêd ya pastol. A lan anlugurên ya habaytoy tupa, gawan alwan hila ya nag tupa. ");
INSERT INTO sgb_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Hikoy nanad hên mangêd ya pastol. Muwang koy nakêm lan ampaniwala kangko, haka muwang lay nakêm ko. ");
INSERT INTO sgb_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Êmbayro êt, ay muwang na ko ni Apo Namalyari ya Tatang ko, haka êmbayro êt, ay muwang ko ya. Nakal-an ako hên matsi ha ikakangêd lan ampaniwala kangko. ");
INSERT INTO sgb_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Main akon kaatag tupa, ya ayn di ha koral. Gêtan ko hila etaman ta gilamên lay pamaghabi ko. Pilalamoên ko hila ta êmên mag-in mimiha hila, haka kakapag ko ya pastol la. ");
INSERT INTO sgb_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Anlugurên ako ni Apo Namalyari, ya Tatang ko, gawan nakal-an akon matsi ta êmên ako mabiyay oman. ");
INSERT INTO sgb_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ayn malyarin mamatsi kangko, no a ko ya paulayan. Nakal-an akon matsi, haka atsi kangkoy kapangyarihan hên mabiyay oman, ta hatsi ya in-utoh kangko ni Apo Namalyari, ya Tatang ko.” ");
INSERT INTO sgb_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Gawan hata habi ni Apo Jesus, ay alwan mimihay ihip lan Israelita. ");
INSERT INTO sgb_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Mal-at kanla ya naghabi, ya wanla, “Hinapatan yan narawak ya a angkahêlêk, haka angkamurit yay na! Awta panggilamên yoy habi na?” ");
INSERT INTO sgb_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Noa, hinabi lan kaatag, “A ya makahabi hên êmbayro ya mihay hinapatan hên narawak ya a angkahêlêk. A hila makapamukat hên buwag, ya hilay narawak ya a angkahêlêk.” ");
INSERT INTO sgb_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ha balayan Jerusalem hên habayto ay pista hên pamanêmtêm lan Israelita, ha pamanlinis lan ninuno la ha Templo, ya dinêmêkan lan kapatsi la. Panaon hên kêbêl hên habayto, ");
INSERT INTO sgb_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","haka hi Apo Jesus ay ampibita-bita ha pinata-ngalanan Portiko ni Arin Solomon ha Templo. ");
INSERT INTO sgb_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Amêhên, main hên poon lan Israelita, ya nagpalibot kan Apo Jesus, ta dakpên la ya dayi ha pamaghabi na. Hinabi la kana, “Mabuyot naên nanan labay mamwangan no hino kan taganá. Habiên mina dayi ta êmên naên maintindihan no hika ya Mesias, ya Cristo, ya pinili ni Apo Namalyari hên mag-in habaytoy Mámiligtas ya impangako na.” ");
INSERT INTO sgb_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Kabay hinabi ni Apo Jesus, “Hinabi kina kamoyu noa, a yo ko paniwal-an. Ya kapapaêpapah ya dyag ko, ya pandaygên ko ha kapangyarihan ni Apo Namalyari, ya Tatang ko, ay ampamaptêg, no hino ko. ");
INSERT INTO sgb_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Noa, a kaw ampaniwala gawan a kaw kalamo ha ampastolan ko. ");
INSERT INTO sgb_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Hilay ampastolan ko, ay nanad tupa ya ampanggilam hên pamaghabi ko. Muwang koy nakêm la, haka anhumonol hila kangko. ");
INSERT INTO sgb_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Dyanan ko hilan biyay ya ayn angga. Antalanên koy biyay la, kabay a hila mipalako ha impiyerno haka a hila ma-ayu kangko. ");
INSERT INTO sgb_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Hi Apo Namalyari, ya Tatang ko, ya namipatalan hên biyay la kangko, ay makapangyarihan ha kaganawan kapatsi la. Ayn maka-ayu hên an-illagan na. ");
INSERT INTO sgb_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Hiko, haka hi Apo Namalyari, ya Tatang ko, ay mimiha.” ");
INSERT INTO sgb_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Gawan hinabi nay habayto, ay nangwa hilan bato, ta batoên la ya dayi. ");
INSERT INTO sgb_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Noa, wani Apo Jesus, “Mal-at ya mangêd ya dinyag ko, ya impadyag na kangko ni Apo Namalyari, ya Tatang ko. Hino ha dinyag ko, ya namaihip kamoyu hên batoên ako?” ");
INSERT INTO sgb_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Kabay wanlan Israelita bayro, “Alwan gawan ha mangêd ya dinyag mo, ya pamatoan naên kamo. Noa, labay naên kan batoên, gawan ha an-ipantag moy sarili mo kan Apo Namalyari. Yarin a mon ammusmusên hi Apo Namalyari ya tawo kan bêngat!” ");
INSERT INTO sgb_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Kabay wani Apo Jesus, “Habaytsi ya nakahulat ha Kahulatan ya impahulat ni Apo Namalyari ya tungkol kanlan mánlingon kaso, ‘Hinabi ko, ya hikaw ay diyos.’ ");
INSERT INTO sgb_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Bayro ha impahulat ni Apo Namalyari, ya pêtêg, ay diyos ya pamaêg na kanlan pinatsiwal-an na hên habi na. ");
INSERT INTO sgb_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Anhabiên yo ya ammusmusên ko hi Apo Namalyari, ya Tatang ko, gawan ha hinabi ko, ya hikoy Anak na! Noa, ayn kaw hên karapatan hên maghabin êmbayro, ta hikoy pinili na, haka in-utoh di ha luta. ");
INSERT INTO sgb_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","No a ko ampanyag, hên an-ipadyag na kangko ni Apo Namalyari, ya Tatang ko, ay a yo kailangan hên maniwala kangko. ");
INSERT INTO sgb_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Noa, no pandaygên koy an-ipadyag na kangko, awta a yo paniwal-an ya habi ko! Paniwal-an yo tana dayi ya dyag ko, ta êmên yo maintindihan ya atsi kangkoy Tatang ko, hi Apo Namalyari, haka hikoy atsi kana.” ");
INSERT INTO sgb_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Gawan habaytoy hinabi na, ay labay lay na êt dayi hên dakpên yan oman. Noa, ayn makadakêp kana. ");
INSERT INTO sgb_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nammita yay na êt hi Apo Jesus, ta lumipay ya ha lanêm ya ampatangalanan lan Ilog Jordan ya pinamawtismoan ni Juan Bautista hên una. Naglaêh ya bayro hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mal-at ya dinumani kana, ta wanla, “A ya nanyag hên kapapaêpapah hi Juan, noa, pêtêg ya balang hinabi na, ya tungkol kanan habaytsi.” ");
INSERT INTO sgb_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Mal-at bayro ya naniwala kan Apo Jesus, ya hiyay Mesias, ya Cristo, ya in-utoh ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Main mihay lalaki ya nag langan Lazaro ya ampaidi ha baryon Betania ha probinsyan Judea, ha dani hên balayan Jerusalem. Kalamo na ya kapotoh pohêl na hilan Marta haka hi Maria. Amêhên, nagkahakit hi Lazaro. ");
INSERT INTO sgb_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Hi Maria ya namitugtug hên pabango ha bitsih ni Apo Jesus, haka na punihan hên habot na.) Gawan nagkahakit hi Lazaro, ");
INSERT INTO sgb_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ay impahabi lan Marta haka Maria kan Apo Jesus, ya wanla, “Panginoon, ampaghakit ya anluguran mon kalalaki.” ");
INSERT INTO sgb_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Noa, hên nagilam ni Apo Jesus ya impahabi la, ay wana, “A na ikamatsi ya hakit na. Nalyari ya hatsi, ta êmên maipamwang ya kapangyarihan ni Apo Namalyari, haka ya kapangyarihan ko, ya Anak na.” ");
INSERT INTO sgb_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Anlugurên ni Apo Jesus hilay mitataali ya hi Marta, Maria haka Lazaro. ");
INSERT INTO sgb_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Kabay lowa tanay allo na bayro ha Ilog Jordan paubat hên impamwang kana, ya nagkahakit hi Lazaro. ");
INSERT INTO sgb_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Amêhên, hinabi na kanlan tagahonol na, “Mag-orong kitamina ha probinsyan Judea.” ");
INSERT INTO sgb_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Kabay wanla kana, “Mánoro, a pon nabuyot, ay labay la kan batoên, hên patsên, hên hilay poon tamon Israelita bayro. Awta labay mon mag-orong bayro?” ");
INSERT INTO sgb_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Kabay wani Apo Jesus kanla, “Main labinloway oras, hên hawang, ha balang allo. Hilay ampammita no mahawang, ay a mibatol, gawan angkahêlêk lay ampam-in hawang kanlan tawo. ");
INSERT INTO sgb_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Noa, hilay ampammita ha yabi, ay mibatol gawan ayn hawang kanla.” ");
INSERT INTO sgb_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nahên nahabi nay habayto, ay wana kanla, “Ya kaluguran tamo hi Lazaro, ay nabêlêw. Noa, lakwên ko ya, ta pukawên ko ya.” ");
INSERT INTO sgb_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Kabay hinabi lan tagahonol na kana, “Panginoon, no nipakatuloy ya, ay mapanat ya hakit na.” ");
INSERT INTO sgb_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ya labay nan habiên ni Apo Jesus, ay natsi yay na hi Lazaro. Noa, a la naintindihan ya labay nan habiên, ta êndat la no bêlêw yan taganá hi Lazaro. ");
INSERT INTO sgb_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kabay indiretsa nay nan hinabi ni Apo Jesus, “Natsi ya hi Lazaro. ");
INSERT INTO sgb_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ha ikakangêd yo, ay mahigla ko, ya ayn ako bayro hên namaalíh hên hakit na, ta êmên mapahanan ya paniwala yo, ya hikoy Mesias, ya Cristo. Mita kitamina na, ta lakwên tamo ya.” ");
INSERT INTO sgb_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Amêhên, wani Tomas, ya banhagan lan Kambal, “Hali, kihonol kitamo kana, ta êmên kitamo matsi hên kalamo na.” ");
INSERT INTO sgb_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Hên nilumatêng hilan Apo Jesus ha baryon Betania, ay ika-apatan allo hên in-ilbêng ya bangkay ni Lazaro. ");
INSERT INTO sgb_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Tatloy kilometron bêngat ya dayo hên balayan Jerusalem ha baryon Betania. ");
INSERT INTO sgb_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Kabay mal-at ya Israelita ya taga-Judea ya nilumatêng ta nakidamay kanlan Marta haka Maria gawan natsi ya kapotoh pohêl la. ");
INSERT INTO sgb_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Hên nagilam ni Marta, ya anlumatêng hilan Apo Jesus, ay immawah ya, ta nanupa kanla. Noa, hi Maria, ay a inumawah ha bali. ");
INSERT INTO sgb_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Wani Marta kan Apo Jesus, “Panginoon, no atsi ka dayi, ay a ya bayton natsi ya kapotoh pohêl ko. ");
INSERT INTO sgb_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Êmbayro man, ay muwang ko, ya hinoman ya pakikwaan yo kan Apo Namalyari, ay daygên na.” ");
INSERT INTO sgb_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Wani Apo Jesus kana, “Mabiyay yan oman hi Lazaro.” ");
INSERT INTO sgb_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Wani Marta kan Apo Jesus, “Awo, Panginoon. Muwang ko ya mabiyay yan oman ha Allon Pamanukom ya lumatêng ha anggaan hên luta.” ");
INSERT INTO sgb_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Amêhên, wani Apo Jesus, “Hikoy ampam-in biyay haka hikoy mamabiyay oman kanlan natsi. Hilay ampaniwala kangko, ay mabiyay oman, natsi hila man di ha luta. ");
INSERT INTO sgb_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Hilay ampaniwala kangko, ay dyanan hên biyay ya ayn angga. Ampaniwal-an mo ya habayto, ya hinabi ko?” ");
INSERT INTO sgb_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“Awo, Panginoon,” wani Marta. “Ampaniwala ko ya hika ya Anak ni Apo Namalyari. Hika ya Mesias, ya Cristo, ya pan-êngganan naên di ha luta.” ");
INSERT INTO sgb_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nahên nahabi nay na ya habayto ni Marta, ay nuli ya ta binaêg na hi Maria, hên in-inanah na kana ya nilumatêng ya Mánoro, haka impabaêg na ya. ");
INSERT INTO sgb_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ya dinyag ni Maria hên nagilam nay habayto, ay tambêng yan nirêng ta nagtagloh ya kana. ");
INSERT INTO sgb_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","A ya pon nilumatêng ha balayan hi Apo Jesus, ta atsi ya pon ha logal ya pinakatupaan kana ni Marta. ");
INSERT INTO sgb_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Nahên nahêlêk lan taga-Judea, ya kalamo ni Maria ha bali hên ampakidamay kana, ya bigla yan nammita hi Maria, ay kinamat la ya, ta êndat la no lakwên na ya pinay-ilbêngan hên bangkay ni Lazaro, hên manangih. ");
INSERT INTO sgb_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Hên nilumatêng hi Maria ha ampaidyanan ni Apo Jesus, ay nandoko ya ha arapan na, ta wana, “Panginoon, no atsi ka dayi bayri, ay a ya bayton natsi ya kapotoh pohêl ko.” ");
INSERT INTO sgb_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Gawan ampanangih hi Maria haka hilay Israelita, ya nangamat kana, ay namalagêhbêg ya nakêm ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Hinabi na, “Atoy pinay-ilbêngan yon bangkay na?” Kabay wanla, “Panginoon, kihonol ka kannaên ta hêlkên mo ya.” ");
INSERT INTO sgb_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nanangih hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Kabay wanlan kaatag Israelita, “Nilugud nan taganá hi Lazaro.” ");
INSERT INTO sgb_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Noa, wanlan kaatag, “Hiya ya namamukat hên buwag. Awta pinaulayan na hi Lazaro hên matsi?” ");
INSERT INTO sgb_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Nahên nilumatêng hila ha lêyang, ya pinay-ilbêngan lan bangkay ni Lazaro, ay namalagêhbêg ya nakêm ni Apo Jesus. Main nakapênlan ya bato ha bêbêy lêyang. ");
INSERT INTO sgb_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Kabay wani Apo Jesus, “Alihên yoy bato.” Noa, wani Marta, “Panginoon, apat ya allo yay nan natsi. Nabatay nay bangkay na.” ");
INSERT INTO sgb_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Wani Apo Jesus kan Marta, “Hinabi kina kamo ya no maniwala ka kangko, ay mahêlêk moy kapangyarihan ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Kabay inalíh la ya habaytoy bato ha pinay-ilbêngan la kan Lazaro. Naningla hi Apo Jesus ta wana, “Tatang ko ha langit, ampahalamatan kata, gawan ginilam moy halangin ko. ");
INSERT INTO sgb_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mana kinan muwang, ya panay mon anggilamên ya kaganawan dawat ko. Noa, hinabi koy habayto, ta êmên hila maniwala ya atsi bayri, ya hika ya namiutoh kangko.” ");
INSERT INTO sgb_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nahên nahabi na ya habayto, ay nan-angaw ya, “Lazaro, umawah ka!” ");
INSERT INTO sgb_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Inumawah ya. Ya gamêt haka bitsih na ay nakabêlbêl, hên nanad ha ugali la ha natsi. Main panyo ya nakabêlbêl ha ulo na. Amêhên, wani Apo Jesus kanla, “Alihên yoy nakabêlbêl kana ta êmên ya mibuhan.” ");
INSERT INTO sgb_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mal-at kanlan Israelita ya taga-Judea, ya nangamat kan Maria, ay nakahêlêk hên biniyay oman hi Lazaro. Kabay naniwala hila kan Apo Jesus ya hiyay Mesias, ya Cristo ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala. ");
INSERT INTO sgb_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Noa, ya kaatag ay nammita, ta hinabi la kanlan Pariseo ya dinyag ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kabay namatsipon hilay Pariseo haka hilay ampamaala kanlan pari hên kalamo la ha Sanedrin. Pinihahabian la no hinoy daygên la, gawan hi Apo Jesus ay ampanyag hên mal-at ya kapapaêpapah. ");
INSERT INTO sgb_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Hinabi la, “No paulayan tamo ya hên manyag hên êmbayro, ay mal-at ya maniwala ya hiyay Mesias, ya Cristo. Bayo lumatêng hilay hundaloh hên Roma ta hiraên la ya Templo ni Apo Namalyari, haka bansa tamo.” ");
INSERT INTO sgb_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Noa, ya miha kanla, ya hi Caifas, ya pinakapoon pari, ay naghabi, ya wana, “Ayn kaw hên muwang! ");
INSERT INTO sgb_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","A yo angkaintindihan ya ikakangêd tamo no mimiha tana ya matsi, kanan matsi kitamon kaganawan ha boon bansan Israel.” ");
INSERT INTO sgb_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ya habaytoy hinabi ni Caifas, ay alwan ubat ha sarili na, ta habaytoy impapapêt kana ni Apo Namalyari, gawan hiyay pinakapoon pari hên habaytoy taon. Impapêt na ya hi Apo Jesus ay matsi ha ikakangêd lan Israelita, ");
INSERT INTO sgb_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","haka alwan bêngat ha ikakangêd lan Israelita, noa, ta êmên matsipon etaman ya maának ni Apo Namalyari ya nitatayak ha kaganawan bansa. ");
INSERT INTO sgb_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Paubat hên habayton allo, ay pan-ihipên la, no ay-êmên lan mapatsi hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kabay a yay na pon nunta ha logal lan Israelita ya mal-at ya tawo. Naglaêh ya tana hên kalamo na hilay tagahonol na ha balayan Efraim, ya atsi ha dani hên logal ya kabalah-balahan. ");
INSERT INTO sgb_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Amêhên, hên marani yay na êt ya Pistan Pangaligtas ha Egipto, ay mal-at ya nilumatêng ha balayan Jerusalem, ta honolên lay ugali lan pamaglinis hên sarili la, bayo hila makipista. ");
INSERT INTO sgb_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Hên a la matapol hi Apo Jesus ha Templo, ay nihahabi hilay tawo ha miha ta miha no makipista ya hi Apo Jesus, o no a ya, ");
INSERT INTO sgb_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ta namiutoh hilay ampamaala kanlan pari haka hilay Pariseo, ya no main makahêlêk kan Apo Jesus, ay dapat ipamwang la kanla ta êmên la ya madakêp. ");
INSERT INTO sgb_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Amêhên, anêm ya allo bayo mag-umpisa ya Pistan Pangaligtas ha Egipto, ay nilumatêng hilan Apo Jesus ha baryon Betania ya balayan ni Lazaro, ya biniyay oman ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Pinanluto hilan Apo Jesus hên maêkan. Namiapag hi Marta. Hi Lazaro etaman, ay miha kanlan ampangan hên kalamo lan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Hên ampangan hila, ay nangwa hi Maria hên bote hên makamal ya pabango ta intugtug na ha bitsih ni Apo Jesus. Bayo, pinunihan nan habot na. Hata pabango ay naraêp ha boon bali. ");
INSERT INTO sgb_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Hi Judas Iscariote, ya tagahonol ni Apo Jesus ya may-upit kana, ay naghabi, ya wana, ");
INSERT INTO sgb_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Pata a ya inhaliw ya habaytoy pabango, ya ampag-alaga hên suweldo hên mihay katawo ha mihay taon, ta indin dayi ha mangairap ya habaytoy pera?” ");
INSERT INTO sgb_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Hinabi nay habayto, alwan gawan ingalo na ha mairap, noa, gawan hiyay ampanalan hên pera lan Apo Jesus, haka antakawên nay hatsi ha pansarili na. ");
INSERT INTO sgb_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Wani Apo Jesus kan Judas, “Pata an-abalaên mo ya! Paulayan mo hi Maria, ta hata dinyag na, ay nanad nan in-il-an ya lawini ko ha pamilbêng kangko no matsi kina. ");
INSERT INTO sgb_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Hilay mairap ay panay yon kalamo, kabay ha hinon oras, ay mahawpan yo hila, noa, hiko ay a yo panay hên mapagkalamo.” ");
INSERT INTO sgb_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Hên namwangan hên kal-atan kanlan Israelita ya taga-Judea, ya atsi ya ha Betania hi Apo Jesus, ay nilako la ya. Labay la êt hêlkên hi Lazaro, ya biniyay oman ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Labay lan ampamaala kanlan pari, ya anggan hi Lazaro ya ipapatsi la, ");
INSERT INTO sgb_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","gawan mal-at ya Israelita ya nanalibokot kanla, haka ampaniwala hilay na kan Apo Jesus, gawan ha biniyay nan oman hi Lazaro. ");
INSERT INTO sgb_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ha humonoy allo, ay namwangan hên kal-atan ya nakipista, ya anlumatêng hi Apo Jesus ha Jerusalem. ");
INSERT INTO sgb_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Nangwa hilan bulong, ya nanad bulong ongot haka nanupa hila kana. Nipan-angaw hila ha panupa la kana, “Hosanna! Iningalwan ya habaytsi ya in-utoh ni Apo Namalyari! Puriên hi Apo Jesus ya ampamaala ha Israel!” ");
INSERT INTO sgb_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Anlumatêng hi Apo Jesus hên nakahakay ha bisero hên asno nanad ha nakahulat ha habi ni Apo Namalyari: ");
INSERT INTO sgb_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Paan kaw malimo, hikaw ya taga-Jerusalem, ta anlumatêng ya ampamaala kamoyu, ya nagpakaaypan nakêm hên himmakay ha bisero hên asno!” ");
INSERT INTO sgb_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Hên habayto ay a la pon muwang hên tagahonol ni Apo Jesus ya labay habiên hên habayto. Noa, hên nabiyay yan oman, ay naihipan la ya hatoy nakahulat, ay tungkol kana, haka nalyari kana. ");
INSERT INTO sgb_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Amêhên, hilay kal-atan ya nakahêlêk hên biniyay nan oman ni Apo Jesus hi Lazaro, ay naghabi kanlan kaatag, ya pêtêg ya habayto ya dinyag ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Mal-at ya nanupa kan Apo Jesus gawan ha nagilam la, ya biniyay nan oman hi Lazaro. ");
INSERT INTO sgb_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kabay wanlan Pariseo ha miha ta miha, “Ayn kitaminan madyag ta naubuh-ubuh hilay nan anhumonol kana.” ");
INSERT INTO sgb_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nakipista êt hên magsimba kan Apo Namalyari ya ungnoy Griego. ");
INSERT INTO sgb_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Dinumani hila kan Felipe, ya taga-Betsaida ha probinsyan Galilea. Hinabi la kan Felipe, “Apo, labay naên mahêlêk hi Apo Jesus.” ");
INSERT INTO sgb_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Hinabi ni Felipe ya kalabayan la kan Andres. Bayo hinabi lan lowa ya kalabayan lan Griego kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Hinabi ni Apo Jesus, “Nilumatêng ya oras ya ipahlêk ya panga-Diyos ko, hên Taga-Langit, ya In-anak Tawo. ");
INSERT INTO sgb_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Pakagilamên yo, hikoy maialimbawa ha mihay lahí hên bini hên trigo. No a ya iilbêng ha luta hên nanad natsi, ay mimiha na tana. Noa, uston atsi yay na ha luta, ay tumubo ya haka managêy yan mal-at. ");
INSERT INTO sgb_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Hilay ampanlugud hên biyay la hên igit ha pamanlugud la kan Apo Namalyari, ay maalihan habayto. Noa, hilay ampanlugud kan Apo Namalyari hên igit ha biyay la di ha luta, ay main biyay ya ayn angga. ");
INSERT INTO sgb_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Hilay mabay hên maghuyo kangko, ay kailangan hên humonol kangko, ta ya hinon lakwên ko, ay lakwên la etaman. Hilay maghuyo kangko ay itag-ay ni Apo Namalyari, ya Tatang ko.” ");
INSERT INTO sgb_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Hinabi na êt ni Apo Jesus, “Angkabyatan ako. Noa, a ko habiên, ‘Tatang, iligtas mo ko ha kairapan ya atsi ha arapan ko.’ A ko mahabi ya habayto, gawan nilumatêng ako di ha luta, ta êmên ko maranasan ya hata kairapan.” ");
INSERT INTO sgb_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Wana êt ni Apo Jesus, “Tatang, ipahlêk moy panga-Diyos mo, ta êmên la ka puriên.” Amêhên, wanan habi ya ubat ha langit, “Impahlêk kina ya panga-Diyos ko, haka ipahlêk kon oman.” ");
INSERT INTO sgb_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Naubuh hilan nakagilam hên hatoy habi. Wanlan kaatag ya nangilat. Wanlan kaatag pon ya main anghel ya naghabi kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Wani Apo Jesus, “Habaytoy habi ya nagilam yo ay impagilam ha ikakangêd yo, alwan ha ikakangêd ko. ");
INSERT INTO sgb_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","“Gawan nilumatêng ya pamanatol ni Apo Namalyari ha tawo ha luta. Alihên ya tungkulan ni Satanas, ya poon lan a ampagpalokop kan Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Haka hiko, uston itag-ay ako ha koros, haka mag-orong ha langit, ay ingalwan ko hilay tawo ha balang bansa ta êmên hila makarani kangko.” ");
INSERT INTO sgb_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Hinabi nay habayto ta êmên na ipamwang no ay-êmên yan matsi. ");
INSERT INTO sgb_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Hinabi lan naka-tsipon, ya wanla, “Namwangan naên ha Kahulatan ni Apo Namalyari, ya Mesias, ya Cristo, ya impangakon Mámiligtas ay mabiyay hên ayn angga. No hika ay habaytoy Taga-Langit, ya In-anak Tawo, ay-êmên mon mahabi ya hika ay matsi ha koros? Hino ya Taga-Langit, ya In-anak Tawo?” ");
INSERT INTO sgb_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Wani Apo Jesus kanla, “Hiko ya maialimbawa ha hawang, ay a magbuyot di kamoyu. Dapat manonol kaw ha intoro ko kamoyu kaban atsi ko pon di. Habayto ay nanad kaw hên ampitan allo, ta êmên a kaw mayabyan. No mita kaw hên dêmm ay mitama kaw. ");
INSERT INTO sgb_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kaban atsi ko pon di, ay maniwala kaw kangko ta êmên kaw mag-in tawo ya nahawangan ya kaihipan.” Pamakahabi nan habayto, ay nammita ya haka a yay na nagpahlêk kanla. ");
INSERT INTO sgb_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Agyan kal-atan ya kapapaêpapah ya dinyag na ha arapan la, ay mal-at pon êt kanla ya a naniwala ya hiyay Cristo. ");
INSERT INTO sgb_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nalyari ya habayto ta êmên matupad ya impamwang ni Propeta Isaias, ya wana: “Panginoon, ayn naniwala ha impamwang naên. Ayn naniwala agyan impahêlêk minay kapangyarihan mo kanla.” ");
INSERT INTO sgb_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","A hila malyarin maniwala, ta nanad êt ha hinabi ni Propeta Isaias, ya wana: ");
INSERT INTO sgb_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Binuwag ni Apo Namalyari ya ihip la, ta êmên la a maintindihan, haka pinakdêy na êt ya nakêm la. Dinyag nay habayto ta êmên hila a maghêhê hên dumani kana, haka ta êmên a na hila iumang kana.” ");
INSERT INTO sgb_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Hinabi nay habayto ni Propeta Isaias gawan impahalumata kana ya panga-Diyos ni Apo Jesus. Haka naghabi yan tungkol kana. ");
INSERT INTO sgb_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Êmbayro man, ay mal-at kanlan ampamaala kanlan Israelita ya naniwala ya hi Apo Jesus, ay hiyay Cristo. Noa, gawan malimo hila kanlan Pariseo, ay a la impamwang kanlan kaatag, ta kayno bawalan hila hên makilamo ha kapareho lan Israelita ha sinagoga. ");
INSERT INTO sgb_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Nalabayan la awud ya pamandayêw hên tawo kanan pamandayêw ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Amêhên, nanoro yay na êt hi Apo Jesus ha kal-atan. In-ikhaw nay pamaghabi na, ya wana, “Hilay ampaniwala kangko, ay ampaniwala etaman kan Apo Namalyari ya namiutoh kangko. ");
INSERT INTO sgb_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Hilay nakahêlêk kangko ay nakahêlêk kan Apo Namalyari, ya namiutoh kangko. ");
INSERT INTO sgb_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nilumatêng ako di ha luta hên nanad ha hawang, ta êmên hilay maniwala kangko ay ahina paidi ha kariglêman. ");
INSERT INTO sgb_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Hatolan hilay a naniwala ha nagilam lay habi ko, noa, alwan hiko ya manatol kanla, ta a ko nilumatêng di hên parusaan ya hinoman. Noa, nilumatêng ako di ta êmên iligtas hila. ");
INSERT INTO sgb_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Hilay ampangara kangko, haka a ampaniwala ha habi ko ay maparusaan. Ya habi ya impamwang ko ay mamarusa kanla ha anggaan hên luta. ");
INSERT INTO sgb_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ta a ko naghabi ha sarili kon tungkulan, noa, ya Tatang ko hi Apo Namalyari ya namiutoh kangko ay namihabi kangko no hinoy habiên ko. ");
INSERT INTO sgb_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Muwang ko ya utoh na, ay mam-in biyay hên ayn angga hên kalamo na, ha ampaniwala kana. Kabay ya impahabi na kangko ay anhabiên ko.” ");
INSERT INTO sgb_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nilumatêng ya yabi hên bayo mag Pistan Pangaligtas. Muwang ni Apo Jesus ya nilumatêng ya panaon hên pamag-alíh na di ha luta, ta êmên ya mag-orong kan Apo Namalyari, ya Tatang na. Anlugurên na hilay tagahonol na, ya atsi di ha luta. Haka an-ipahlêk na, no ay-êmên ya pamanlugud na kanla hên angga ha anggaan. ");
INSERT INTO sgb_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Kaban ampangan hi Apo Jesus hên kalamo lan tagahonol na, ay naipaihip ni Satanas kan Judas, ya anak ni Simon, ya taga-Iscariote, ya ipulong na hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Muwang nay na ni Apo Jesus ya in-ubuh hên indin kana ni Apo Namalyari, ya Tatang na, ya kaganawan kapangyarihan. Muwang na êt, ya ubat ya kan Apo Namalyari, haka mag-orong yay na kana. ");
INSERT INTO sgb_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Kabay haton ampangan hila ay nirêng ya hi Apo Jesus, ta nag-alíh ya hên pangkêbêl na, bayo pintêh na ya awak na hên makarang ya tuwalya. ");
INSERT INTO sgb_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nanad andaygên lan ipoh, ay nangwa yan lanêm, ta indin na ha palanggana, haka na inuyahan ya bitsih lan tagahonol na. Bayo pinunihan na hên tuwalya ya nakaptêh ha awak na. ");
INSERT INTO sgb_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Hên dinumani ya kan Pedro, ay wani Pedro, “Awkêh! Pata hika pon, Panginoon, ya manguyah hên bitsih ko?” ");
INSERT INTO sgb_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Hinabi ni Apo Jesus, “A mo maintindihan amêhên, ya andaygên ko, noa, maintindihan mina lano.” ");
INSERT INTO sgb_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Hinabi kana ni Pedro, “Panginoon, taganán a ko ipauyah ya bitsih ko kamo.” Amêhên, wani Apo Jesus, “No a kata uyahan, ay ayn kan pamakilamo kangko.” ");
INSERT INTO sgb_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Kabay hinabi ni Pedro, “Panginoon, no êmbayro awud, ay alwan bêngat hên bitsih ko ya ipauyah ko kamo, noa, gamêt ko, haka ulo ko etaman.” ");
INSERT INTO sgb_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Hinabi ni Apo Jesus, “No nagpalyuy nay mihay tawo, ay a nay nan kailangan hên magpalyu hên oman ta malinis yay na. Bitsih na tana ya uyahan na. Noa, main miha kamoyu ya alwan malinis.” ");
INSERT INTO sgb_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Hinabi nay êmbayro ni Apo Jesus, ta muwang na no hino ya mangi-upit kana.) ");
INSERT INTO sgb_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Hên nauyahan ni Apo Jesus ya bitsih la, ay inhulod nay na êt ya pangkêbêl na. Nag-orong yay na ha panganan, ta kinotang na hila, no naintindihan la ya dinyag na kanla, ya wana, ");
INSERT INTO sgb_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Ambaêgên yo ko hên Mánoro, haka Panginoon. Pêtêg ya anhabiên yo ta hikoy habayto. ");
INSERT INTO sgb_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","No hiko, ya Panginoon yo, haka Mánoro yo, ya nanguyah hên bitsih yo, hikaw etaman êt ya kailangan manguyah hên bitsih hên miha ta miha. ");
INSERT INTO sgb_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Dinyanan kataw hên alimbawa ta êmên yo ko tuwarên. ");
INSERT INTO sgb_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Pakagilamên yo! Ya tungkulan hên mihay ipoh ay alwan matag-ay ha tungkulan hên amo na. Haka hatoy in-utoh, ay alwan matag-ay ya tungkulan ha nay-utoh kana. ");
INSERT INTO sgb_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","No angkaintindihan yo, ya hata anhabiên ko kamoyu, ta daygên yo, ay ingalwan kaw ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Alwan kaganawan yo ya ingalwan, ta muwang koy nakêm hên pinili ko. Noa, kailangan matupad ya habi ha Kahulatan ni Apo Namalyari, ya wana, ‘Hikoy in-upit hên kaaêm ko.’ ");
INSERT INTO sgb_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Anhabiên ko ya hatsi kamoyu, bayo ya malyari, ta êmên no malyari yay na, ay maniwala kaw ya ‘Hikoy Hiko taganá.’ ");
INSERT INTO sgb_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Pakagilamên yo. Hilay ampananggap ha in-utoh ko, ay hiko êt ya antanggapên la. Haka hilay ampananggap kangko, ay ampananggap ha namiutoh kangko.” ");
INSERT INTO sgb_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Pangahabi nan habayto, ay namalagêhbêg ya nakêm na. Bayo wana kanla, “Pakagilamên yo! Miha kamoyu ya mangi-upit kangko.” ");
INSERT INTO sgb_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Amêhên, nihêhêlêk hila ya tagahonol na, ta a la muwang no hinoy an-ungkatên na. ");
INSERT INTO sgb_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ya tagahonol na, ya banhagan lan anlugurên ni Apo Jesus, ay atsi ha dani na. ");
INSERT INTO sgb_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Kabay siningyalan ya ni Simon Pedro, ya ikotang na, no hinoy an-ungkatên na ya may-upit kana. ");
INSERT INTO sgb_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kabay dinumani ya kan Apo Jesus, hên indani nay ulo na ha pagaw na, ta wana, “Panginoon, hinoy may-upit kamo?” ");
INSERT INTO sgb_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Hinabi ni Apo Jesus, “Ya dyanan ko hên puto ya ubat kon intsil-tsil, ay hiya ya may-upit kangko.” Kabay nangwa yan puto, haka ubat nan intsil-tsil, ay indin na kan Judas ya anak ni Simon Iscariote. ");
INSERT INTO sgb_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Hên kingwa ni Judas ya puto, ay hinuloran ya ni Satanas. Hinabi ni Apo Jesus kan Judas, “Daygên mina ya labay mon daygên.” ");
INSERT INTO sgb_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Noa, miha man kanla ha kaaêm na, ay ayn nakamwang no awta nahabi nay habayto. ");
INSERT INTO sgb_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Gawan hi Judas, ya magkatalan hên pera la, êndat la no pinahaliw yan bêngat ni Apo Jesus hên kailangan la ha pista, o no in-utoh na ya hên mam-i hên pera ha mangairap. ");
INSERT INTO sgb_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Hên naêkan nay na ni Judas ya puto, ay nammita yay na. Nariglêm hên habayto. ");
INSERT INTO sgb_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Hên nammita yay na hi Judas, wani Apo Jesus, “Ya malyari laamêhên, kangkon Taga-Langit, ya In-anak Tawo, ay mamipahlêk hên panga-Diyos ko, haka mam-in pamagpuri kan Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Haka no mapuri yay na hi Apo Namalyari gawan kangko, ay tampol nan ipahlêk ya panga-Diyos ko. ");
INSERT INTO sgb_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Maanak ko, naipêk tanay panaon hên makalamo yo ko. Tapolên yo ko, noa, anhabiên ko kamoyu, hên nanad ha hinabi kina kanlan poon lan Israelita, ya a kaw makapakilako ha anlakwên ko. ");
INSERT INTO sgb_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Habaytsi ay mihay bayoy utoh ya an-idin ko kamoyu. Milulugud kaw! No ay-êmên kataw hên anlugurên ay, êmên êt bayro ya pamilulugud yo. ");
INSERT INTO sgb_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","No ampilulugud kaw, ay mamwangan hên kal-atan, ya hikaw ay tagahonol ko.” ");
INSERT INTO sgb_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Amêhên, wani Simon Pedro kan Apo Jesus, “Apo, antoy lakwên mo?” Kabay wani Apo Jesus, “Ha anlakwên ko, a ka pon makapakilako amêhên, noa, humonol ka tana lano.” ");
INSERT INTO sgb_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Wanay na êt ni Pedro, “Panginoon, pata a ko pon makapakihonol kamo amêhên? Nakal-an akon matsi ha ikakangêd mo.” ");
INSERT INTO sgb_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Wani Apo Jesus, “Yarin nakal-an ka hên matsi ha ikangêd ko! Pakagilamên mo. Bayo mangkatsi ya manok, ay katatlo mon habiên, ya a mo ko muwang.” ");
INSERT INTO sgb_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Wanay na êt ni Apo Jesus, “Paan kaw mampotog. Ihundo yoy paniwala yo kan Apo Namalyari haka maniwala kaw etaman kangko. ");
INSERT INTO sgb_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ha langit ha ampaidyanan hên Tatang ko, ay mal-at ya paidyanan. No alwan pêtêg ya habayto, ay yarin habiên koy êmbayro? Muna kina bayro, ta il-an koy paidyanan yo. ");
INSERT INTO sgb_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","No atsi kina bayro, haka no nail-an kina ya paidyanan yo, ay mag-orong kina, ta gêtan kataw bayro ha ampaidyanan ko. ");
INSERT INTO sgb_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Muwang yoy na bayto, ya dann ya palako do ha anlakwên ko.” ");
INSERT INTO sgb_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Amêhên, hinabi kana ni Tomas, “Panginoon, a naên muwang ya lakwên mo, ay-êmên naên mamwangan ya dann?” ");
INSERT INTO sgb_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Kabay hinabi ni Apo Jesus, “Hiko ya dann ya palako kan Apo Namalyari, ya Tatang ha langit. Hiko ya ampamipamwang hên kaptêgan ya tungkol kana, haka hiko ya ampam-in biyay ya ayn angga. Ayn midani kana, no a ya magdann kangko. ");
INSERT INTO sgb_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","No muwang yo no hino kon taganá, ay kilala yo etaman ya Tatang ko. Paubat amêhên, ay kilala yo yay na, haka nanad nahêlêk yo yay na.” ");
INSERT INTO sgb_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Amêhên, hinabi kana ni Felipe, “Panginoon, ipahlêk mo kannaên ya Tatang mo. Bayo ayn kay kaatag ya tapolên.” ");
INSERT INTO sgb_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Kabay wani Apo Jesus, “Felipe, nabuyot yo kinan kalamo. Angga amêhên, ay a mo ko pon kilala? No nahêlêk yo ko, ay nahêlêk yoy nay Tatang ko. Pata hinabi mo ya ipahlêk ko kamo ya Tatang ko? ");
INSERT INTO sgb_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Yarin a ka ampaniwala, ya mimiha kay ni Tatang? Hiko ay atsi kana, haka hiya ay atsi kangko. Ya anhabiên ko, ay angkaubat kana alwan ha sarili ko. Êmbayro etaman ya kaganawan dyag ko, ay angkaubat kana. ");
INSERT INTO sgb_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Maniwala kaw ha hinabi ko ya atsi ko ha Tatang ko, haka ya Tatang ko ay atsi kangko. No a kaw maniwala ha anhabiên ko, maniwala kaw tana, gawan ha kapapaêpapah ya andaygên ko. ");
INSERT INTO sgb_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Anhabiên ko kamoyu, ya hinon ampanlugud kangko, ay makadyag etaman hên andaygên ko, haka mal-at pon di, ta mag-orong kina ha Tatang ko. ");
INSERT INTO sgb_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ya hinon pakikwaan yo kan Tatang, gawan ha pakikimiha yo kangko, ay daygên ko ta êmên mapuri hi Tatang, gawan kangko, ya Anak. ");
INSERT INTO sgb_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ya hinon pakikwaan yo kangko gawan ha pakikimiha yo kangko, ay daygên ko.” ");
INSERT INTO sgb_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“No anlugurên yo ko, tuparên yoy an-iutoh ko kamoyu. ");
INSERT INTO sgb_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Haka makidawat ako kan Apo Namalyari, ya Tatang ko, ya dyanan na kaw hên miha pon ya Kahawop yo, ya makalamo yo hên ayn angga. ");
INSERT INTO sgb_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Yabay ya Espiritu ni Apo Namalyari ya an-ipamwang hên kaptêgan. Hiya ay a matanggap lan a ampagpalokop kan Apo Namalyari, gawan a la ya angkahêlêk, haka a la ya angkabalayan. Noa, balay yo ya, ta atsi ya kamoyu, haka lumatêng ya allo, ay humapat ya kamoyu. ");
INSERT INTO sgb_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“A kataw ibalag hên nanad ha olila ta mag-orong ako kamoyu. ");
INSERT INTO sgb_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","A mabuyot ay, a la kina mahêlêk lan a ampagpalokop kan Apo Namalyari. Noa, hikaw, ay mahêlêk yo ko. Gawan mabiyay kon oman, ay mabiyay kaw etaman. ");
INSERT INTO sgb_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kanan habayto, ay mamwangan yo ya hiko, ay main pakikimiha ha Tatang ko, haka hikaw etaman ay main pakikimiha kangko, haka hiko ay main pakikimiha kamoyu. ");
INSERT INTO sgb_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Hilay ampanggilam haka ampanupad hên utoh ko, ay ampanlugud kangko. Hilay ampanlugud kangko, ay lugurên hên Tatang ko. Lugurên ko hila êt, haka ipamwang ko kanla, ya tungkol kangko.” ");
INSERT INTO sgb_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Kabay hinabi ni Judas (alwan Judas Iscariote), “Panginoon, awta kannaên kan bêngat magpabalay? Awta a mo ipamwang ya tungkol kamo kanlan kaganawan tawo ha luta?” ");
INSERT INTO sgb_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Naghabi hi Apo Jesus, “Hilay ampanlugud kangko, ay manyag hên anhabiên ko. Lugurên hila hên Tatang ko, haka humapat kay kanla. ");
INSERT INTO sgb_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Hilay a ampanlugud kangko, ay a hila etaman manyag hên anhabiên ko. Ya anhabiên ko kamoyu, ay angkaubat kan Apo Namalyari, ya Tatang ko, ya nay-utoh kangko.” ");
INSERT INTO sgb_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Habaytoy hinabi kina kamoyu kaban kalamo yo ko pon. ");
INSERT INTO sgb_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Noa, lano, ay mamiutoh hi Apo Namalyari, ya Tatang ko, hên Espiritu na, ya mag-in Kahawop yo. Hiyay mamihundo hên panoro ko kamoyu hên kaganawan, haka hiya ya maypaihip kamoyu hên kaganawan intoro ko kamoyu.” ");
INSERT INTO sgb_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Paan kaw manyagah. Paan kaw malimo. Ta patêkbêkên koy ihip yo. Ya kapatêkbêkan ya an-idin ko kamoyu, ay pêtêg ya kapatêkbêkan. Habayto ay alwan nanad ha kapatêkbêkan ya an-ungkatên lan tawo di ha luta. ");
INSERT INTO sgb_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nagilam yoy hinabi ko kamoyu ya hikoy mag-alíh. Haka mag-orong ako kamoyu. No anlugurên yo ko dayi, ay ikahigla yo dayi ya pag-orong ko kan Apo Namalyari, ya Tatang ko, ta daêg na ko gawan ya tungkulan na ay matag-ay ha tungkulan ko. ");
INSERT INTO sgb_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Anhabiên kina kamoyu ya hatsi bayo malyari, ta êmên no malyari ya, ay maniwala kaw, ya pêtêg ya hinabi ko. ");
INSERT INTO sgb_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","A kina pakakarangên ya pamaghabi ko kamoyu, ta anlumatêng hi Satanas, ya poon lan a ampagpalokop kan Apo Namalyari. Ayn yan kapangyarihan kangko. ");
INSERT INTO sgb_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Êmbayro man, ta êmên mamwangan hên balang miha, ya anlugurên ko ya Tatang ko, hi Apo Namalyari, ay andaygên ko ya hatoy an-iutoh na kangko. Hali awud, mita kitamina.” ");
INSERT INTO sgb_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Kaban ampammita hila, ay wani Apo Jesus kanlan tagahonol na, “Hiko ya mantêg hên poon ubas, haka ya Tatang ko, hi Apo Namalyari, ya ampanayhay hên ubasan. ");
INSERT INTO sgb_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ampotohên na hilay hanga ko ya ayn tagêy, haka anlinisan na hilay hanga ya main tagêy, ta êmên lalo hilan managêy. ");
INSERT INTO sgb_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nilinisan kaw na gawan ha paniwala yo ha hinabi ko kamoyu. ");
INSERT INTO sgb_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ihundo yoy pakikimiha yo kangko, haka hiko man, ay ihundo koy pakikimiha ko kamoyu. A ya managêy ya hanga hên ubas, no a ya nakatumpang ha poon. Êmbayro êt kamoyu, no a yo ihundo ya pakikimiha yo kangko.” ");
INSERT INTO sgb_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Bayo inoman nan inungkat ya alimbawa na, ya wana, “Hiko ya poon hên ubas haka hikaw ya hanga. Hilay ampamihundo hên pakikimiha la kangko, ta êmên ako etaman magkamain pakikimiha kanla, ay hilay nanad ha hanga ya managêy hên bapan lakê, gawan ayn kaw madyag, no hikaw ay nakapapawa kangko. ");
INSERT INTO sgb_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Hilay a ampamihundo hên pakikimiha la kangko, ay nanad hilan hanga ya itapon. No mayango ya êmbayroy hanga, ay tsiponên hila tana, ta ulamên. ");
INSERT INTO sgb_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Noa, no ihundo yo ya pakikimiha yo kangko, haka no maglaêh ha nakêm yo ya habi ko, ay pakikwaan yo ya hinoman ya labay yo kan Apo Namalyari, ta idin na kamoyu. ");
INSERT INTO sgb_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Angkapuri ya Tatang ko no hikaw ay ampanagêy hên bapan lakê, haka angkapaptêgan hên hikaw ay tagahonol ko. ");
INSERT INTO sgb_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","No ay-êmên ya pamanlugud na kangko hên Tatang ko, ay êmbayro êt ya pamanlugud ko kamoyu. Ihundo yoy pakikimiha yo kangko, ta ha êmbayro ay panay yon mapakinabangnan ya pamanlugud ko. ");
INSERT INTO sgb_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","No anhonolên yoy utoh ko, ay mapakinabangnan yoy pamanlugud ko kamoyu. Nanad kangko, anhonolên ko êt ya kaganawan utoh ni Apo Namalyari, ya Tatang ko, haka panay kon pakinabangnan ya pamanlugud na.” ");
INSERT INTO sgb_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Hinabi koy habayto kamoyu, ta êmên kaw milamo ha hadyay kahiglaan ko. ");
INSERT INTO sgb_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Habaytsi ya utoh ko kamoyu ya milulugud kaw hên nanad hên pamanlugud ko kamoyu. ");
INSERT INTO sgb_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ayn pamanlugud ya igit ha pamanlugud hên mihay lalaki, ya ihalanggo nay biyay na kanlan kaluguran na. ");
INSERT INTO sgb_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Hikaw ay kaluguran ko, no anhonolên yoy an-iutoh ko. ");
INSERT INTO sgb_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","A kataw nan baêgên tagahuyo, ta a na muwang hên tagahuyo, ya andaygên hên amo na. Noa, binaêg kataw hên kaluguran ko, ta hinabi kina kamoyu ya kaganawan ya nagilam ko kan Apo Namalyari, ya Tatang ko. ");
INSERT INTO sgb_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Alwan hikaw ya namili kangko, ta hiko ya namili kamoyu. In-utoh kataw hên maypamwang hên habi ni Apo Namalyari, ya Tatang ko, ta êmên mal-at ya maniwala, haka hilay nanad ayn anggay tagêy hên paniwala yo. Ta no daygên yoy habayto, ay idin na kamoyu ya hinon pakikwaan yo, gawan ha pakikimiha yo kangko. ");
INSERT INTO sgb_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Habaytsi ya an-ioman kon iutoh kamoyu, ya milulugud kaw.” ");
INSERT INTO sgb_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Wanay na êt ni Apo Jesus, “No angkahêmêkan la kaw lan a ampagpalokop kan Apo Namalyari, ay ihipên yo ya bayo la kaw kinahêmêkan, hiko pon ya kinahêmêkan la. ");
INSERT INTO sgb_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","No alimbawa ta tuwarên yoy ugali la, ay lugurên la kaw. Noa, a yo hila antuwarên, ta pinili kataw na hên mag-in tagahonol ko. Kabay angkahêmêkan la kaw. ");
INSERT INTO sgb_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Paka-ihipên yo ya hinabi ko kamoyu, ya tungkulan hên mihay ipoh ay alwan matag-ay ha tungkulan hên amo na. Pinairapan la ko, haka pairapan la kaw. No hinonol lay hinabi ko, ay honolên lay panhabiên yo. ");
INSERT INTO sgb_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Daygên lay hatsi kamoyu gawan ha pakikimiha yo kangko ta a la kilala hi Apo Namalyari, ya nay-utoh kangko. ");
INSERT INTO sgb_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","No a ko dayi nilumatêng di ha luta hên nanoro kanla, ay mahabi la ya a la muwang ya kasalanan awud ya andaygên la. Noa, amêhên, a lay na mahabi ya a la muwang ya kasalanan ya andaygên la, ta tinoroan ko hilay na. ");
INSERT INTO sgb_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Hilay anhumêmêk kangko, ay anhumêmêk etaman kan Apo Namalyari, ya Tatang ko. ");
INSERT INTO sgb_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nanyag akon kapapaêpapah ha arapan la, ya a pon nadyag hên hinoman, kabay a lay na mahabi ya alwan kasalanan, ya hila ay a ampaniwala kangko. Nahêlêk la man ya kaganawan dinyag ko, ay angkahêmêkan la ko, haka angkahêmêkan la hi Apo Namalyari, ya Tatang ko. ");
INSERT INTO sgb_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Noa, êmên din taganá, gawan natupad ya impahulat ni Apo Namalyari ha Kahulatan na, ya wana, ‘Bat la kon kinahêmêkan.’” ");
INSERT INTO sgb_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Hinabi na êt ni Apo Jesus, ya wana, “Lumatêng ya allo, ay iutoh ko kamoyu ya Kahawop yo, ya Espiritu hên kaptêgan, ya ubat kan Apo Namalyari, ya Tatang ko. Hiya ya mamaptêg hên tungkol kangko. ");
INSERT INTO sgb_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Hikaw êt ya mamaptêg ha kaganawan dinyag ko, ta paubat hên una, ay kalamo kataw na.” ");
INSERT INTO sgb_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Hinabi nay na êt ni Apo Jesus, ya wana, “Mana kinan hinabi ya habayto kamoyu, ta êmên yo ihundo ya paniwala yo kangko. ");
INSERT INTO sgb_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Paalihên la kaw ha sinagoga yo. Lumatêng ya panaon ay main mamatsi kamoyu, ta êndat la no ampaghuyo hila kan Apo Namalyari no patsên la kaw. ");
INSERT INTO sgb_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Daygên lay habayto ta a la nabalayan hi Apo Namalyari, ya Tatang ko, haka a la ko nabalayan. ");
INSERT INTO sgb_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mana kinan anhabiên ya habayto kamoyu, ta no lumatêng ya allo, ya daygên lay habayto kamoyu, maihipan yo ya nagilam yo kangko.” Hinabi nay na êt ni Apo Jesus, ya wana, “A ko pon hinabi ya habaytsi kamoyu, ta kalamo yo ko pon. ");
INSERT INTO sgb_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Noa, habiên kina, ta mag-orong kina kan Apo Namalyari, ya Tatang ko, ya nay-utoh kangko. Ayn man kamoyu hên ampangotang kangko no antoy lakwên ko. ");
INSERT INTO sgb_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Noa, hadyay lungkot yo tana gawan hinabi kina kamoyu ya habayto. ");
INSERT INTO sgb_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Êmbayro man, ay dapat yon mamwangan ya kaptêgan. Ya pamag-alíh ko, ay ha ikakangêd yo, ta a ya lumatêng di kamoyu ya Espiritu ni Apo Namalyari, ya Kahawop yo, no a ko mag-alíh. No atsi kina bayro kan Apo Namalyari ay iutoh ko yay na kamoyu. ");
INSERT INTO sgb_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ha pamanlumatêng na, ay ipaihip na kanlan a ampagpalokop kan Apo Namalyari, ya alwan usto ya an-ihipên la tungkol ha kasalanan, haka tungkol ha katoynungan, haka tungkol ha pamanatol ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Mamwangan la ya makasalanan hila, gawan a hila naniwala ya hikoy Anak na. ");
INSERT INTO sgb_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Mamwangan la ya hikoy makatoynungan, ta mag-orong kina kana, ya Tatang ko. Bayo a yo kinan mahêlêk. ");
INSERT INTO sgb_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Mamwangan la ya lingonên hilan parusaan, gawan hinatolan yay na hên parusaan hi Satanas, ya poon lan a ampagpalokop kan Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Mal-at pon dayi ya habiên ko kamoyu. Noa, a pon agyu hên ihip yo amêhên. ");
INSERT INTO sgb_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Panlumatêng hên Espiritu ni Apo Namalyari, ya ubatan hên kaganawan kaptêgan, ipamwang na kamoyu ya boon kaptêgan, ta a ya mag-habi ha sarili nan ihip, noa, ya habiên nan bêngat, ay hatoy nagilam na kan Apo Namalyari. Haka ipamwang na êt kamoyu ya a pon nalyari. ");
INSERT INTO sgb_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ipahlêk na ya panga-Diyos ko, haka ipamwang na kamoyu ya laman ihip ko. ");
INSERT INTO sgb_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ya laman ihip ni Apo Namalyari, ya Tatang ko, ay habayto êt ya laman ihip ko, kabay hinabi ko ya laman ihip ko, ya ipamwang na kamoyu.” ");
INSERT INTO sgb_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Hinabi nay na êt ni Apo Jesus kanlan tagahonol na, ya wana, “A mabuyot, ay a yo kina mahêlêk. Bayo, a mabuyot, mahêlêk yo kon oman.” ");
INSERT INTO sgb_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Nihahabi hilay nay tagahonol na, ya wanla, “Hino raw ya labay nan habiên? Pata hinabi nay a mabuyot, ay a tamo yay nan mahêlêk, bayo a mabuyot, ay mahêlêk tamo yay na êt. Haka wana êt ya, lakwên na hi Apo Namalyari, ya Tatang na. ");
INSERT INTO sgb_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Hinoy labay habiên, hên hinabi na ya a mabuyot? A tamo muwang no hino ya labay nan habiên.” ");
INSERT INTO sgb_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Namwangan ni Apo Jesus ya labay lan kotangên, kabay hinabi nay na kanla, ya wana, “Ampangotang kaw ha hinabi ko ya a mabuyot ay a yo kinan mahêlêk, bayo a mabuyot ay mahêlêk yo kina êt. ");
INSERT INTO sgb_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Pakagilamên yo. Manangih kaw haka manyêngên kaw. Noa, hilay a ampagpalokop kan Apo Namalyari ay humigla. Hikaw ay maglungkot pon, noa, ya kalungkutan yo ay hagilyan hên kahiglaan. ");
INSERT INTO sgb_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","“Habayto ay nanad ha mihay babayi, no angkatanam nay na ya manganak ya, ay ampaglungkot ya pon, ta nilumatêng ya oras hên kairapan na. Noa, no na-ianak nay na, ay a nay nan maihipan ya kairapan, gawan kahiglaan na ha anak na. ");
INSERT INTO sgb_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Êmên kaw êt bayro. Ampaglungkot kaw amêhên, bayo no mahêlêk yo kon oman, ay humigla kaw hên taganá. Ya kahiglaan yo ay a maayu hên hinoman. ");
INSERT INTO sgb_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“A yoy nan kailangan hên mangotáng hên hinoman kangko ha alloy habayto. Pakagilamên yo, ya hinoman ya pakikwaan yo kan Apo Namalyari, ya Tatang ko, ay idin na gawan ha pakikimiha yo kangko. ");
INSERT INTO sgb_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Angga amêhên, ay ayn kaw pon pinakikwaan kana gawan ha pakikimiha yo kangko. Noa, amêhên, ay panay kaw dayi hên kikwa, ta dyanan na kaw, ta êmên kaw magkamain hên hadyay kahiglaan.” ");
INSERT INTO sgb_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Inhundo ni Apo Jesus ya pamaghabi na, ya wana, “Habaytoy hinabi ko kamoyu hên paalimbawa. Noa, lumatêng ya panaon, ay a kinan maghabi kamoyu hên paalimbawa, ta ipakapuliah kinan habiên kamoyu ya tungkol kan Apo Namalyari, ya Tatang ko. ");
INSERT INTO sgb_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ha alloy habayto, ay makikwa kaw kana, gawan ha pakikimiha yo kangko. A ko anhabiên kamoyu ya pakikwa kataw hên hinoman kana, ");
INSERT INTO sgb_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","gawan hiyan taganá ya ampanlugud kamoyu. Anlugurên na kaw gawan anlugurên yo ko haka ampaniwala kaw ya hiko ay ubat kana. ");
INSERT INTO sgb_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Hiya ya ubatan ko hên nilumatêng ako di ha luta. Haka mag-orong kina kana.” ");
INSERT INTO sgb_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Hên nagilam lay habayto hên hilay tagahonol na, ay wanla, “Awo, Panginoon. Amêhên, angkaintindihan naên ya anhabiên mo, ta impakapuliah mina. Alway nan paalimbawa ya anhabiên mo. ");
INSERT INTO sgb_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Amêhên, ay muwang naên ya muwang moy balang hino. Muwang moy kotang ya atsi ha ihip hên balang tawo. Kabay ampaniwala kay, ya hika ay ubat kan Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Wani Apo Jesus, “Awo, ampaniwala kaw na amêhên. ");
INSERT INTO sgb_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Noa, ihipên yoy habaytsi. Marani yanay oras ya mapitatayak kaw. Ibalag yo ko, ta muli kaw ha bali yo. Êmbayro man, kalamo ko hi Apo Namalyari, ya Tatang ko. ");
INSERT INTO sgb_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Hinabi kina kamoyu ya habayto, ta êmên kaw magkamain kapatêkbêkan hên ihip gawan ha pakikimiha yo kangko. Êmbayro man, ay main kaw pon hên kairapan di ha luta. Noa, pakataniêhên yoy nakêm yo, ta hinambut kinay nangarawak di ha luta.” ");
INSERT INTO sgb_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Hên nahabi nay na ni Apo Jesus, ya habayto, ay naningla ya ha langit ta wana, “Tatang, nilumatêng ya oras. Ipahlêk minay panga-Diyos ko, ya Anak mo, ta êmên ko ipahlêk ya panga-Diyos mo etaman. ");
INSERT INTO sgb_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ta indin mo kangko ya tungkulan hên mamaala ha balang miha, ta êmên hila dyanan biyay ya ayn angga ya impatsiwala mo kangko. ");
INSERT INTO sgb_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Habaytsi ya biyay ya ayn angga, ya makilala la ka, ya kamiha-mihaan Diyos, haka mamwangan la ko, hi Apo Jesu-Cristo ya in-utoh mo. ");
INSERT INTO sgb_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Impahlêk koy panga-Diyos mo di ha luta ta nayari kina ya impadyag mo kangko. ");
INSERT INTO sgb_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Amêhên, Tatang, ha arapan mo, ay ipahlêk mo dayi ya panga-Diyos ko, ya atsi kangko hên kalamo kata haton bayo êt dinyag ya hata luta. ");
INSERT INTO sgb_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Impabalay kata kanlan impatsiwala mo kangko, ya hilay pinili mo ha kal-atan tawo ha luta. Kamo hila, bayo impatsiwala mo hila kangko. Hinonol la etaman ya in-utoh mo kanla. ");
INSERT INTO sgb_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Amêhên muwang lay na ya hika ya ubatan hên kaganawan ya dinyag haka hinabi ko. ");
INSERT INTO sgb_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Gawan ginilam la ya intoro kina kanla, ya namwangan ko kamo, haka taganán muwang la, ya hiko ay ubat kamo, haka ampaniwala hila, ya hika ya namiutoh kangko. ");
INSERT INTO sgb_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Hila ya an-ihalangin ko. A ko an-ihalangin hilay a ampagpalokop kamo. Noa, an-ihalangin ko hilay impatsiwala mo kangko, ta kamo hila. ");
INSERT INTO sgb_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ya hinoman ya atsi kangko, ay kamo, haka ya hinoman ya atsi kamo, ay kangko. Angkahêlêk ya panga-Diyos ko gawan ha paniwala la kangko. ");
INSERT INTO sgb_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mag-alíh kina di ha luta, ta mag-orong kina kamo. Noa, atsi hila pon di ha luta. Tatang koy banal, illagan mo hilay impatsiwala mo kangko ha kapangyarihan mo, ta êmên mag-in mimihay nakêm la, hên nanad nakêm mo haka nakêm ko, ya mimiha. ");
INSERT INTO sgb_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Kaban kalamo la ko, di ha luta, ay inillagan ko hila gawan ha kapangyarihan mo, haka ayn kanla ya nidayo kangko, no alwan bêngat hatoy miha ya manan tinalagá ya midayo ya, haka milako ha kaparusaan, ta êmên matupad ya nakahulat ha Kahulatan mo. ");
INSERT INTO sgb_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Marani ya pamag-orong ko kamo. Kabay ipagilam ko kanla ya hatsi, ya an-ihalangin ko kamo, kaban atsi ko pon di ha luta, ta êmên hila magkamain hên hadyay kahiglaan, hên nanad ha kahiglaan ko. ");
INSERT INTO sgb_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Naidin kina kanla ya habi mo, bayo kinahêmêkan hila hên a ampaniwala, ya hiko ay ubat kamo. Kinahêmêkan hila, gawan ayn hilan pamakilamo kanlan a ampaniwala kangko, hên nanad kangko ya ayn pamakilamo kanlan a ampagpalokop kan Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","A ko an-ihalangin ya alihên mo hila di ha luta, noa, an-ihalangin ko ya illagan mo hila kan Satanas. ");
INSERT INTO sgb_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ayn hilan pamakilamo kanlan a ampaniwala kangko, hên nanad kangko ya ayn pamakilamo kanlan a ampagpalokop kan Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ha pamanggilam lan habi mo ya kaptêgan ay ipapawa mo hila hên manyag kalabayan mo. ");
INSERT INTO sgb_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","No ay-êmên ya pay-utoh mo kangko kanlan a ampaniwala kamo, êmên êt bayro ya pay-utoh ko kanla, ta êmên hila manoro kanlan a ampaniwala kamo. ");
INSERT INTO sgb_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","An-italagá koy sarili ko hên manyag kalabayan mo, ta êmên hila etaman ay mitalagá hên manyag kalabayan mo. ");
INSERT INTO sgb_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Alwan bêngat hilay habaytsi ya tagahonol ko ya an-ihalangin ko kamo, noa, hato êt ya maniwala kangko gawan ha an-itoro la. ");
INSERT INTO sgb_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tatang, an-ihalangin ko hilangan ta êmên mag-in mimihay nakêm la, hên nanad ha nakêm mo haka nakêm ko ya mimiha. Atsi hila dayi kantamo hên nanad atsi ka kangko, haka nanad atsi ko kamo, ta êmên hilay tawo ha luta ay maniwala ya hika ya nay-utoh kangko. ");
INSERT INTO sgb_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","No ay-êmên mo kon dinyanan karangalan, ay êmbayro êt ya dinyanan ko hilan karangalan, ta êmên mag-in mimihay nakêm la, hên nanad ha nakêm mo haka nakêm ko ya mimiha. ");
INSERT INTO sgb_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Hiko ay atsi kanla, haka hika ay atsi kangko, ta êmên mag-in ayn pamagkulang ya pagmimiha la. Haka, ta êmên mamwangan lan a ampaniwala kamo, ya hika ya nay-utoh kangko. Haka, ta êmên la mamwangan ya anlugurên mo hila, ya nanad ha pamanlugud mo kangko. ");
INSERT INTO sgb_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tatang ko, labay kon makalamo ko hilay impatsiwala mo kangko ha langit, ta êmên la mahêlêk ya kapahilêw ya kahampatan hên panga-Diyos ko, ya indin mo kangko gawan ha pamanlugud mo kangko paubat hên a pon dinyag ya hata luta. ");
INSERT INTO sgb_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O Tatang ko, ya makatoynungan, a la ka kilala lan a ampagpalokop kamo. Noa, hiko, ay kilala kata, haka habaytsi hilay tagahonol ko, ay muwang la, ya hika ya nay-utoh kangko. ");
INSERT INTO sgb_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Impakilala kata kanla haka ihundo katan ipakilala kanla, ta êmên hila milulugud, hên nanad ha pamanlugud mo kangko ta êmên hikoy magpaidi kanla.” ");
INSERT INTO sgb_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Hên naihalangin ni Apo Jesus ya habayto, ay nammita yay na hên kalamo nay tagahonol na hên palako ha lipay hên hapa ya nag langan Cedron. Bayro ha lipay, ya nilako lan Apo Jesus, ay mal-at ya intanêm ya poon olibo. ");
INSERT INTO sgb_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Amêhên, hi Judas Iscariote, ya may-upit kan Apo Jesus, ay muwang na ya habaytoy logal, ya panay lan anlakwên lan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Bayro na hilan nilako ni Judas hên kalamo nay ungno kanlan ampagbantay ha Templo haka mihay pangkat hên hundaloh, ya impalako bayro hên ampamaala kanlan pari haka hilay Pariseo. Ampantan hila hên pag-atáng haka almas. ");
INSERT INTO sgb_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Gawan muwang na ngan ni Apo Jesus ya malyari kana ay tinupa na hila haka na hinabi kanla, ya wana, “Hinoy antapolên yo?” ");
INSERT INTO sgb_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Kabay wanla, “Antapolên naên hi Jesus, ya taga-Nazaret.” Bayo hinabi ni Apo Jesus, “Hikoy habayto.” Kalamo lan hundaloh hi Judas, ya nay-upit kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Pamakahabi ni Apo Jesus ya hiyay habaytoy antapolên la, ay nipaorong hila haka hila nipatumba ha luta. ");
INSERT INTO sgb_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Kabay nangoman yan nangotang hi Apo Jesus, ya wana, “Hino ya antapolên yo?” Hinabi la, ya wanla, “Hi Jesus ya taga-Nazaret.” ");
INSERT INTO sgb_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Amêhên, wani Apo Jesus, “Hinabi kina kamoyu, ya hiko yan makê. No hiko ya antapolên yo, ay paulayan yo hilay tagahonol ko.” ");
INSERT INTO sgb_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Hinabi nay habayto ta êmên matupad ya hinabi na, ya ayn miha man kanlan impatsiwala kana, ya midayo kana hên mipalako ha kaparusaan. ");
INSERT INTO sgb_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Biglan inanoh ni Simon Pedro ya êtak na, ta tsinigpah nay têkk ni Malco, ya mihay ipoh hên pinakapoon pari. ");
INSERT INTO sgb_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Wani Apo Jesus kan Pedro, “Igoma moy êtak mo, ta kailangan kon têêhên ya kairapan, ta habaytsi ay kalabayan ni Apo Namalyari, ya Tatang ko.” ");
INSERT INTO sgb_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Dinakêp hi Apo Jesus, ta ginapoh ya gamêt na, hên hilay hundaloh hên kalamo lay kapitan la haka hilay Israelita ya tanod hên Templo. ");
INSERT INTO sgb_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Hiyay gintan pon kan Anas, ya ampo ni Caifas. Habaytsi hi Caifas ay pinakapoon pari hên panaon hên habayto. ");
INSERT INTO sgb_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Hi Caifas ya naghabi kanlan kapareho nan poon lan Israelita ha Templo, ya mangêd ay miha tana ya matsi para ha kal-atan. ");
INSERT INTO sgb_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Hi Simon Pedro, haka miha pon ya tagahonol ni Apo Jesus ay hinumonol kanlan Apo Jesus. Gawan kilala yan pinakapoon pari ya hatoy miha, ay nakahowên ya ha bakod hên lote hên pinakapoon pari hên kalamo lan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Nabalag hi Pedro ha danin kabat hên bakod. Immawah ya hatoy mihay tagahonol, ya kabalay hên pinakapoon pari, ta kinahabi nay babayi ya ampagbantay ha kabat hên bakod, haka na pinahowên hi Pedro. ");
INSERT INTO sgb_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kinotang nan hatoy babayi kan Pedro, ya wana, “Miha ka ha tagahonol nan habaytoy dinakêp?” Kabay wani Pedro, “Alwa.” ");
INSERT INTO sgb_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Gawan nakêbêl hên habayto, namagkêt hên uling hilay ipoh, haka hilay tanod, bayo nanêngêy hila. Hi Pedro ay kalamo lan nakairêng hên ampanêngêy. ");
INSERT INTO sgb_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Hi Apo Jesus ay kinotang ni Anas, ya pasado ya pinakapoon pari, hên tungkol ha tagahonol na, haka tungkol ha panoro na. ");
INSERT INTO sgb_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Hinabi ni Apo Jesus, ya wana, “Hikoy nanoro ha arapan lan kal-atan. Hikoy panay hên nanoro ha sinagoga haka ha Templo ya pagtsiponan hên Israelita. Ayn akon hinabi hên patago. ");
INSERT INTO sgb_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Pata hiko ya kotangên mo? Ya kotangên mo dayi ay hatoy nanggilam hên habi ko, ta muwang la no hinoy hinabi ko kanla.” ");
INSERT INTO sgb_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Hên pangahabi ni Apo Jesus hên habayto, ay tsinampaling ya hên hatoy mihay bantay ya atsi bayro, ya wana, “Pata êmbayro ya hinabi mo ha pinakapoon pari?” ");
INSERT INTO sgb_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Wana etaman ni Apo Jesus, “No naghabi kon alwan mangêd, paptêgan mo. No mangêd ya hinabi ko, awta tsinampaling mo ko?” ");
INSERT INTO sgb_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Amêhên, hi Apo Jesus ay impagtan ni Anas kan Caifas, ya pinakapoon pari hên habayto. Nakagapoh pon ya gamêt na. ");
INSERT INTO sgb_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Kaban atsi ya pon bayro hi Simon Pedro hên ampanêngêy, ay kinotang la yan oman, ya wanla, “Alwan hika ya mihay tagahonol hên tawoy hato?” Impuglaoh ni Pedro, ya wana, “Alwa.” ");
INSERT INTO sgb_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Atsi bayro ya mihay kamag-anak hên ipoh ya tsinigpahan ni Pedro hên têkk. Miha ya etaman kanlan ipoh hên pinakapoon pari. Kinotang na kan Pedro, ya wana, “Alwan hika ya nahêlêk ko hên kalamo ni Jesus do ha mal-at ya poon olibo?” Hinabi ni Pedro, ya wana, “Alwa.” ");
INSERT INTO sgb_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Nahên minghan nay na êt impuglaoh ni Pedro, ya a na muwang hi Apo Jesus, ay nangkatsi ya mihay manok. ");
INSERT INTO sgb_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Hên nayari lay nan kinotang hi Apo Jesus ha bali ni Caifas, ay gintan la yay na ha bali ni Gobernador Pilato, ya taga-Roma. Dali allo hên habayto. Hilay Israelita ay a hinumwên ha bali na ta marani yanay Pistan Pangaligtas ha Egipto haka labay lan mangan ha pista. ");
INSERT INTO sgb_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kabay immawah ya hi Gobernador Pilato ta kinotang na hila, no hinoy an-ibara la kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Hinabi lan Israelita, ya wanla, “No ayn ya dayin dinyag ya alwan mangêd, ay a naên ya gintan di kamo.” ");
INSERT INTO sgb_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Hinabi ni Gobernador Pilato kanla, ya wana, “Hikaw tana ya manatol kana hên pamanhumonol ha Kautuhan yo.” Noa hinabi lan Israelita, ya wanla, “Ayn kay karapatan hên hatolan hên patsên ya hinoman.” ");
INSERT INTO sgb_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nalyari ya habayto ta êmên matupad ya hinabi ni Apo Jesus no ay-êmên yan matsi. ");
INSERT INTO sgb_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Hi Gobernador Pilato, ay nag-orong ha bali na, haka na impabaêg hi Apo Jesus, ta kinotang na ya, “Hika ya ari hên Israelita?” ");
INSERT INTO sgb_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Hinabi ni Apo Jesus, ya wana, “Habain ay ubat ha sarili mon kaihipan, o main naghabin habain kamo?” ");
INSERT INTO sgb_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Hinabi ni Gobernador Pilato, ya wana, “Yarin Israelita ko? Hilay kapareho mon Israelita, haka hilay ampamaala kanlan pari yo, ya nantan kamo di. Hino awud ya dinyag mo?” ");
INSERT INTO sgb_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Hinabi ni Apo Jesus kana, “Ya pamanlokop ko ay alwan di ha luta. No di ha luta ya pamanlokop ko, ay impaglaban la ko dayi hên tagahuyo ko, ta êmên a la kon dakpên lan Israelita. Noa, alwan di ha luta ya pamanlokop ko.” ");
INSERT INTO sgb_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Amêhên, nangotang hi Gobernador Pilato, ya wana, “No êmbayro, ay ari ka?” Bayo hinabi ni Apo Jesus, ya wana, “Hika ya naghabi hên hikoy mihay ari. In-anak ako di ha luta ta êmên mamipamwang hên kaptêgan. Hilay mabay hên mamwangan ya kaptêgan, ay ampanggilam hên anhabiên ko.” ");
INSERT INTO sgb_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Kabay wani Gobernador Pilato, “Hino awud ya kaptêgan?” Pangahabi na ay nangoman yan immawah hi Gobernador Pilato, ta hinabi na kanlan Israelita, ya wana, “Ayn akon angkahêlêk ya ikadikil kana. ");
INSERT INTO sgb_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Main kaw hên kaugalian, ha balang Pistan Pangaligtas, ya kailangan kon ibuhan ya mihay nakahukul. Labay yon ibuhan ko hi Jesus, ya Ari yon Israelita?” ");
INSERT INTO sgb_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Noa, naubuh hilan nan-angaw, ya wanla, “Alwan habain. Hi Barrabas tana ya ibuhan.” (Hi Barrabas ay mihay nanalanghang ha gobyerno.) ");
INSERT INTO sgb_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Gawan ha kalabayan lan ampamaala ha Templo, ay impalatiko ni Gobernador Pilato hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ha pammusmus lan hundaloh kana, ay nangwa hilan nanad tanyuong ya pinanyag la yan korona, ya impakopya la ha ulo na. Haka la ya pinatakopan hên mahampat ya takop, ya kulay ubi, ya nanad ha takop lan ari. ");
INSERT INTO sgb_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bayo miha-miha hilan dinumani kana, ta wanla kana, “Kumara dayi ya biyay hên Ari lan Israelita!” Haka la ya pinagtatampaling. ");
INSERT INTO sgb_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Immawah oman hi Gobernador Pilato, ta hinabi na kanla, iarap ko ya kamoyu ta êmên yo mamwangan ya ayn akon nahêlêk ya kasalanan na. ");
INSERT INTO sgb_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","In-awah la hi Apo Jesus ya pinakopyaan lan korona ya dyag ha diwi, haka pinatakopan hên kulay ubi. Bayo hinabi kanla ni Gobernador Pilato, ya wana, “Hêlkên yoy habaytsi.” ");
INSERT INTO sgb_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Hên nahêlêk lay na hi Apo Jesus hên poon pari, haka hên hilay bantay ha Templo, ay in-angaw la, ya wanla, “Ipako ya ha koros! Ipako ya ha koros!” Noa, hinabi kanla ni Gobernador Pilato, ya wana, “Hikaw tana ya maypako kana ta ayn akon nahêlêk ya dinyag nay kasalanan.” ");
INSERT INTO sgb_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Naghabi hilay Israelita, ya wanla, “Main kay hên anhonolên ya utoh ya hêpat yan patsên, ta hinabi na, ya hiya kanoy Anak ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nahên nagilam ni Gobernador Pilato ya hata hinabi la, lalo yay nan nalimwan. ");
INSERT INTO sgb_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Nangoman yan hinumwên ha lalên bali na ta kinotang na hi Apo Jesus, ya wana, “Taga-ayri ka?” Noa, a ya naghabi hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Kinotang na yay na êt, ya wana, “Pata a mo labay maghabi kangko? A mo muwang ya main akon kapangyarihan hên ipabuhan kata, o ipapako ka ha koros?” ");
INSERT INTO sgb_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Bayo naghabi hi Apo Jesus, ya wana, “Madyag moy habain, ta dinyanan na kan tungkulan ni Apo Namalyari. Kabay mabyat ya kasalanan lan nantan kangko di kanan kasalanan mo.” ");
INSERT INTO sgb_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Nahên nagilam ni Gobernador Pilato ya hinabi ni Apo Jesus, ay labay na ya dayi hên ibuhan, noa, nan-angaw hilay Israelita, ya wanla, “No ibuhan moy habain, alwa kan kaluguran nan Emperador, ya poon mo ha Roma. Ta no hinoman ya ampaghabin hiya ay mihay ari, ay kapatsi nan Emperador.” ");
INSERT INTO sgb_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Hên nagilam ni Gobernador Pilato ya pangahabin êmbayro, ay in-awah na hi Apo Jesus, haka ya nikno ha iknoan hên panlingonan hên kaso, ha logal ya nag langan Gabata ha habin Hebreo, ya main intabladoy bato. ");
INSERT INTO sgb_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Allo hên habayto hên pamaglêan ha Pistan Pangaligtas. Maranin ugto hên hinabi ni Gobernador Pilato kanlan Israelita, ya wana, “Hatsi yay na ya ari yo.” ");
INSERT INTO sgb_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Nan-angaw hila, ya wanla, “Patsên ya! Patsên ya! Ipako ya ha koros!” Amêhên, wani Gobernador Pilato, ya wana, “Labay yo yan ipako ha koros, ya ari yo?” Amêhên, naghabi hilay ampamaala kanlan pari ya wanla, “Ayn kay hên kaatag ya ari no alwan ya Emperador.” ");
INSERT INTO sgb_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kabay indin ni Gobernador Pilato hi Apo Jesus kanla ta êmên la ya ipapako ha koros. Kingwa la hi Apo Jesus, ");
INSERT INTO sgb_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ta impabalangaw kana ya mihay koros hên palako ha logal ya ambaêgên hên Bungo (Golgota ha habin Hebreo, ya habi lan Israelita). ");
INSERT INTO sgb_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Panlumatêng la bayro, ay impako la hi Apo Jesus ha koros ha pibonakan hên loway nakapako êt ha koros la. Ya miha ay atsi ha koros ha dapit panabtab ni Apo Jesus, haka ya miha ay atsi ha koros ha dapit uki ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Nanulat hi Gobernador Pilato. Ya wanan hulat, “Hi Jesus, ya taga-Nazaret, ya Ari lan Israelita.” Bayo la indin ya hata hulat ha koros, ha ugton ulo ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Inhulat nay habayto ha habin Hebreo, Latin, haka Griego. Mal-at kanlan Israelita ya namahan habayto, ta narani ya ha balayan, ya pinaypakoan kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kabay hinabi lan ampamaala kanlan pari lan Israelita kan Gobernador Pilato, ya wanla, “Paan mon ihulat ‘ya Ari hên Israelita,’ noa, ya ihulat mo dayi ay, ‘Hinabin hatsi, ya hiya ya Ari lan Israelita.’” ");
INSERT INTO sgb_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Hinabi ni Gobernador Pilato, ya wana, “Ya naihulat ko, ay naihulat kina.” ");
INSERT INTO sgb_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Hên naipako lay na hên hundaloh hi Apo Jesus, ay kingwa la ya takop na, bayo piniaatagan lan apat. Haka la êt kingwa ya hatoy pangkêbêl na ya ayn tayi. ");
INSERT INTO sgb_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Pinihahabian lan hundaloh, ya wanla, “Paan tamon pigi-gihian ya hatsi, ta mahayang tamo. Mahampat, ay magpalabonutan kitamo no hinoy makapiuli.” Nalyari ya habayto, ta êmên matupad ya nakahulat ha Kahulatan ni Apo Namalyari, ya wana, “Pini-aatagan la ya takop ko, bayo hatoy pangkêbêl ko ay pinagpalabonutan la.” Ta êmbayro ya dinyag lan hundaloh. ");
INSERT INTO sgb_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ha danin koros ha pinaypakoan kan Apo Jesus, ay nakairêng ya indo na, bayo mihay babayi ya kapotoh pohêl hên indo na, haka hi Maria Magdalena haka hi Maria, ya ahawa ni Cleopas. ");
INSERT INTO sgb_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Hên nahêlêk ni Apo Jesus ya indo na, haka hatoy banhagan lan anlugurên nan tagahonol na, ya atsi ha dani na, ay hinabi na, ya wana, “Indo, atsi ya anak mo.” ");
INSERT INTO sgb_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Hinabi na êt ha tagahonol na, ya wana, “Atsi di ya indo mo.” Kabay paubat hên habayto, ay pinagkalamo na ya indo ni Apo Jesus ha bali na. ");
INSERT INTO sgb_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Muwang ni Apo Jesus ya nayari ya kaganawan ya impadyag kana ni Apo Namalyari. Haka ta êmên matupad ya atsi ha Kahulatan na, ay hinabi na, “Angkaangan ako.” ");
INSERT INTO sgb_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Atsi bayro ha nanad kolo, ya main nangiho ya alak. In-iptêh la ya nanad bolak ha makarang ya hanga hên isopo. Bayo indêrê la ha nangihoy alak, ya atsi ha nanad kolo, ta intag-ay la ha bêbêy ni Apo Jesus ta êmên na halêphêpên. ");
INSERT INTO sgb_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Hên hinalêphêp nay na ni Apo Jesus ya nangihoy alak, ay hinabi na, ya wana, “Nayari yana.” Nagkulaêy ya ulo na hên natsi yay na. ");
INSERT INTO sgb_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Allon pamaglêan la ha pamagsimba haka pista la hên habayto. Nilako la hên Israelita hi Gobernador Pilato, ta a la labay ilaêh ha koros ya natsi no allon pamagsimba. Haka maalagá kanla ya habaytoy allon pamagsimba ta napitagon pista ya êt, kabay pinakihabi la kan Gobernador Pilato, ya ipapakli ya but-on ahêl hên nakapako ha koros ta alihên bayro ya bangkay la. ");
INSERT INTO sgb_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kabay nilako lay na êt hên hundaloh hên pinakli ya but-on ahêl lan loway nakapako hên kalamo ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Hên lumatêng hila kan Apo Jesus, ay nahêlêk la, ya mana yay nan natsi. Kabay a lay na pinakli ya but-on ahêl na. ");
INSERT INTO sgb_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Noa, nilatog hên mihay hundaloh ya lawini ni Apo Jesus ha aypan tagyang, bayo biglan namoganggang ya daya haka lanêm. ");
INSERT INTO sgb_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Habaytoy nalyari, ay pêtêg, ta ya nakahêlêk hên nalyari, ay mapaypaniwal-an. Kabay an-ipamwang na ya kaganawan ya nahêlêk na, ta êmên hikaw man, ay maniwala. ");
INSERT INTO sgb_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nalyari ya habayto, ta êmên matupad ya Kahulatan ni Apo Namalyari, ya ayn mapakli ya miha man ha but-o na. ");
INSERT INTO sgb_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Haka main êt kaatag ya nakahulat ha Kahulatan ni Apo Namalyari, ya wanan Kahulatan, “Pakahêlkên lay hatoy nilatog la.” ");
INSERT INTO sgb_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Hên nayari ya habayto, ay pinakihabi ni Jose ya taga-balayan Arimatea, kan Gobernador Pilato, ya paulayan yan may-ilbêng bangkay ni Apo Jesus. Hatsi hi Jose, ay mihay ampaniwala kan Apo Jesus, noa, a na impamwang ya paniwala na, gawan malimo ya kanlan poon lan Israelita. Pinaulayan ya etaman ni Gobernador Pilato. Kabay kingwa ni Jose ya bangkay ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Kalamo ni Jose hi Nicodemo, ya dinumani kan Apo Jesus hên haton mihay yabi. Nantan yan tatlumpo ya kilo hên pabango, ya piniagêm hên mira haka aloe. ");
INSERT INTO sgb_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Kingwa lay bangkay ni Apo Jesus, ta dinyanan lan pabango kaban kinêlkêlan la ya hên takop, ya naputsi gawan ha kaugalian lan Israelita no main iilbêng. ");
INSERT INTO sgb_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ha dani hên pinaypakoan kan Apo Jesus, ay main pananêman. Bayro ha pananêman, ay main pay-ilbêngan ya nanad lêyang ya bayon dyag, ya a êt pinay-ilbêngan. ");
INSERT INTO sgb_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Indin lay bangkay ni Apo Jesus bayro, gawan narani, haka gawan kailangan yan iilbêng, bayo matatay allo, gawan habaytoy bisperas hên pista, haka bisperas allon pamagsimba la. ");
INSERT INTO sgb_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Naririglêm pon hên allon Dominggo, ay nilumatêng hilan Maria Magdalena ha pinay-ilbêngan kan Apo Jesus. Nahêlêk la ya natulid ya hadyay hêlay bato, ya intakap ha bêbêy hên pinay-ilbêngan. ");
INSERT INTO sgb_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Gawan ha nahêlêk la, ay nuwayu hilan nagtagloh kan Simon Pedro, haka kanan tagahonol, ya banhagan lan anlugurên ni Apo Jesus. Hinabi la kanla, “Kingwa la ya bangkay hên Panginoon ha pinay-ilbêngan kana. Haka a naên muwang no ay-iri la yan gintan.” ");
INSERT INTO sgb_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kabay hi Pedro, haka hatoy tagahonol ya banhagan lan anlugurên ni Apo Jesus, ay nagtagloh bayro ha pinay-ilbêngan. ");
INSERT INTO sgb_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Niagnan hilan nuwayu, noa, hi Pedro ay naunaan yan hatoy mihay tagahonol ha pinay-ilbêngan. ");
INSERT INTO sgb_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Napaiyoko ya, ta hinilip na ya lalên lêyang. Nahêlêk na ya hatoy pinamunggoh ha bangkay ni Apo Jesus, noa, a ya pon hinumwên. ");
INSERT INTO sgb_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Hên nilumatêng ya hi Pedro, ay tinumagloh yan hinumwên ha lalên lêyang. Nahêlêk na etaman, ya atsi ya awud bayro ya pinamunggoh ha bangkay ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Main êt bayro, hên nakapapawa, ya nanad mahlay ya panyo, ya pinangêlkêl ha ulo hên bangkay ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Amêhên, hinumwên yay na etaman ya hatoy tagahonol ya nunan nilumatêng bayro. Nahêlêk na êt ya habayto, kabay naniwala yay na, ya nabiyay yan oman hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Agyan impahulat ni Apo Namalyari ha Kahulatan na, ya kailangan mangoman mabiyay hi Apo Jesus, ay a la êt naintindihan ya habayto. ");
INSERT INTO sgb_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Amêhên, nuli hilay nay loway tagahonol ni Apo Jesus ha bali la. ");
INSERT INTO sgb_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Nakabita hilay nay loway tagahonol ni Apo Jesus hên nilumatêng bayro hi Maria Magdalena ha pinay-ilbêngan kan Apo Jesus. Nakairêng ya bayro ha bêbêy hên lêyang hên ampanangih. Kaban ampanangih ya, ay hinilip nay lalên lêyang. ");
INSERT INTO sgb_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Nahêlêk na bayro ya loway anghel ya nakatakop hên naputsi ya nakaikno ha ubatan hên bangkay ni Apo Jesus, miha ha dapit ulo haka miha ha dapit bitsih. ");
INSERT INTO sgb_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Kinotang la hi Maria, “Pata ampanangih ka?” Hinabi na, ya wana, “Kingwa la ya bangkay hên Panginoon ko, haka a ko muwang no ay-iri la yan gintan.” ");
INSERT INTO sgb_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Hên namalingay hi Maria hên nahabi nay habayto, ay nahêlêk na hi Apo Jesus ya nakairêng bayro, noa, a na ya nabalayan. ");
INSERT INTO sgb_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Kinotang ya ni Apo Jesus, ya wana, “Pata ampanangih ka? Hinoy antapolên mo?” Êndat ni Maria hên hiya ya manayhay hên tanaman bayro. Kabay kinotang na, ya wana, “Apo, no hika ya nangwa kana, itoro mo kangko no ay-iri mo yan gintan ta kowên ko ya.” ");
INSERT INTO sgb_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Amêhên, wani Apo Jesus kana, “Maria.” Inumarap hi Maria kan Apo Jesus, ta wana, “Raboni.” (Ya labay habiên hên “Raboni” ay “Mánoro” ha habin Hebreo ya habi lan Israelita.) ");
INSERT INTO sgb_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Hinabi ni Apo Jesus kana, ya wana, “Paan mo kon talanên ta a ko êt nakaorong kanan Tatang. Lakwên mo hilay patêl ko ta habiên mo kanla ya mag-orong kina kanan Tatang ko, ya Tatang yo etaman, kan Apo Namalyari, ya Diyos ko haka Diyos yo.” ");
INSERT INTO sgb_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Kabay nagtagloh yay na hi Maria Magdalena kanlan tagahonol na, ta wana, “Nabiyay yan oman ya Panginoon! Nahêlêk ko ya!” Bayo hinabi na êt ya impahabi na kana ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Hên yabi yana hên habayton allon Dominggo, ay naka-tsipon hilay tagahonol na. Impakakabat lay bali ta angkalimo hila ha poon lan Israelita. Namakonkaynaman ay nirêng ya hi Apo Jesus ha bonak la. Hinabi na, “Patêkbêkên ni Apo Namalyari ya nakêm yo.” ");
INSERT INTO sgb_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Pangahabi nan habayto, ay impahlêk na kanla ya hugat ha gamêt na, haka ha aypan tagyang na. Nabalayan la yay na bayto, kabay hadyay kahiglaan lan tagahonol na. ");
INSERT INTO sgb_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Hinabi nay na êt ni Apo Jesus kanla, “Magkamain kaw hên kapatêkbêkan nakêm. No ay-êmên na kon in-utoh ni Apo Namalyari, ya Tatang ko, ay êmên êt bayro hên an-iutoh kataw.” ");
INSERT INTO sgb_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Pangayari nan naghabi ay pinahlêpan na hila haka na hinabi, “Tanggapên yoy Espiritu ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Hiyay mamitoro kamoyu, ta no habiên yo ya main tawo ya pinatawad ha kasalanan la, ay taganán pinatawad hila ni Apo Namalyari. Haka no habiên yo ya a hila pinatawad ha kasalanan la, ay a hila taganán pinatawad ni Apo Namalyari ha kasalanan la.” ");
INSERT INTO sgb_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Hi Tomas, ya miha kanlan labinlowa, ya ambanhagan Kambal, ay ayn bayro hên nagpahlêk hi Apo Jesus kanlan tagahonol na. ");
INSERT INTO sgb_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Kabay hinabi kana hên kaatag ya tagahonol, ya wanla, “Nabiyay yan oman ya Panginoon. Nahêlêk naên ya.” Noa, hinabi ni Tomas, ya wana, “A ko maniwala ya nabiyay yan oman, angga ha a ko pon mahêlêk ya ubatan hên pako ha gamêt na, haka no a ko pon magap-an ya hugat ha aypan tagyang na.” ");
INSERT INTO sgb_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Hên mayari ya waloy allo, nangoman hilan ni-tsi-tsipon ha bali, ya hilay tagahonol na. Kalamo la hi Tomas. Naubuh hên nakakabat ya ilwangan, noa, nakahowên ya hi Apo Jesus, biha nirêng ya ha bonak la. Hinabi nay na êt, ya wana, “Magkamain kaw hên kapatêkbêkan nakêm.” ");
INSERT INTO sgb_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Bayo hinabi na kan Tomas, “Pakahêlkên mo, haka gap-an moy hugat ha gamêt ko haka ha aypan tagyang ko. Paan kan mag-alangan. Maniwala kay na.” ");
INSERT INTO sgb_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Hinabi ni Tomas, ya wana, “Panginoon ko, hika awud hi Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Amêhên, hinabi kana ni Apo Jesus, ya wana, “Ampaniwala kay na, gawan ha nahêlêk mo kina? Lalo hilan an-ingalwan ya ampaniwala kangko, agyan a la ko angkahêlêk.” ");
INSERT INTO sgb_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Bapan lakê pon ya kapapaêpapah ya dinyag ni Apo Jesus ya nahêlêk lan tagahonol na. Noa, a naihulat bayri ha libro. ");
INSERT INTO sgb_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ya naihulat di ay inhulat, ta êmên kaw maniwala ya hi Apo Jesus ay Anak ni Apo Namalyari, ya Mesias, ya Cristo, ya Mámiligtas ya pinili nan mamaala. Ta no maniwala kaw, ay madyanan kaw hên biyay ya ayn angga, gawan ha pakikimiha yo kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Hên nayari ya habayto, ay nagpahlêk yay na êt hi Apo Jesus kanlan tagahonol na. Êmên di ya pangapalyari ha Dagat-dagatan hên Tiberias. ");
INSERT INTO sgb_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Mikakalamo hilan Simon Pedro, hi Tomas ya banhagan lan Kambal, hi Natanael ya taga-Cana, ha probinsyan Galilea, ya loway anak ni Zebedeo, haka ya lowa pon êt ya tagahonol ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Hinabi kanla ni Simon Pedro, ya wana, “Manlapêt ako.” Hinabi lan kaatag, ya wanla, “Kilako kay kamo.” Amêhên, ay nammita hilay na hên hinumakay ha bangka, noa, ayn hilan nakwa hên yabin habayto. ");
INSERT INTO sgb_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Hên dali allo, ay nakairêng hi Apo Jesus ha laylay lanêm, noa, a la ya nabalayan hên tagahonol na. ");
INSERT INTO sgb_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Kinotang na hila, “Maanak ko, main kaw hên nakwa?” Kabay wanla, “Ayn kay nakwa.” ");
INSERT INTO sgb_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Wanay na êt ni Apo Jesus kanla, ya wana, “Itata yo ha dapit panabtab hên bangka ya lambat yo ta êmên kaw makakwa.” Kabay intata la ya lambat la, haka hên habayto êt, ay a lay na maguloy-guloy ya lambat la ha kal-atan hên nakwa la. ");
INSERT INTO sgb_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Amêhên, hinabi na kan Pedro hên hatoy mihay tagahonol, ya banhagan lan anlugurên ni Apo Jesus, ya wana, “Hi Panginoon ya awud ya habayto!” Hên nagilam ni Simon Pedro ya hinabi kana, ay nagbaro ya, ta a ya nakabaro. Hên nakabaro yay na, ay naglukho yay na ha lanêm ta nanawonghong ya hên lakwên kumustaên hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ya kaatag ya tagahonol, ay nagbangkan palako ha laylay hên ampigu-guluyan ya lambat ya napno hên kênan lanêm. A hila marayo ha laylay lanêm ta siyamapo ya metros tana. ");
INSERT INTO sgb_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Hên nakalatêng hilay na ha laylay lanêm ay nakahêlêk hila hên apoy, ya main in-iyaw ya kênan lanêm haka puto. ");
INSERT INTO sgb_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Amêhên, wani Apo Jesus kanla, “Mantan kaw di hên kêna ya nakwa yo.” ");
INSERT INTO sgb_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Hi Simon Pedro ay hinumakay ha bangka ta hinawpan na hilay kalamo na hên mangguloy hên lambat, ya napno hên mangahlay ya kêna ya main bilang hên magatoh boy limampo boy tatlo. A ya nagihi ya lambat agyan êmbayroy kal-atan kêna. ");
INSERT INTO sgb_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Wani Apo Jesus kanla, “Kaw di, ta mangan kitamo.” Miha man kanla, ay ayn naghêkaw nakêm hên mangotáng kana no hino ya, ta muwang la ya hiya ya Panginoon. ");
INSERT INTO sgb_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Amêhên, kingwa ni Apo Jesus ya puto, haka kênan lanêm ta indin na kanla. ");
INSERT INTO sgb_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Habaytoy katatlo nan pagpahlêk ni Apo Jesus kanlan tagahonol na paubat hên nabiyay yan oman. ");
INSERT INTO sgb_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Hên nayari hilan nangan, ay kinotang ni Apo Jesus hi Simon Pedro, ya wana, “Simon, anak ni Juan, anlugurên mo kon igit kanlan habaytsi ya kaatag ya tagahonol ko?” Kabay wani Pedro, “Awo, Panginoon. Muwang mo ya anlugurên kata.” Amêhên, wani Apo Jesus, “Hayhayên mo hilay bayon ampaniwala kangko, ya maialimbawa ha biseron tupa.” ");
INSERT INTO sgb_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Amêhên, katalwa nay na êt kinotang ni Apo Jesus hi Pedro, “Simon, anak ni Juan, anlugurên mo ko?” Bayo wani Pedro, “Awo, Panginoon. Muwang mo ya anlugurên kata.” Amêhên, wani Apo Jesus, “Hayhayên mo hilay ampaniwala kangko, ya maialimbawa ha tupa.” ");
INSERT INTO sgb_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ikatlo yan kinotang ni Apo Jesus, ya wana, “Simon, anak ni Juan, anlugurên mo ko?” Amêhên, hinumakit ya nakêm ni Pedro ha katatlo yan kinotang. Hinabi na, ya wana, “Panginoon, muwang moy balang hino. Muwang mo ya anlugurên kata.” Amêhên, hinabi kana ni Apo Jesus, ya wana, “Hayhayên mo hilay ampaniwala kangko, ya maialimbawa ha tupa. ");
INSERT INTO sgb_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Anhabiên ko kamo ya kaptêgan. Hên alwa ka pon mantêg toa, ay ampabaroan moy sarili mo, haka anlakwên moy labay mon lakwên. Noa, pantumoa mon pêtêg, ay ipaktang moy gamêt mo ta kaatag ya mamikêlêkêl kamo, haka la ka gêtan do ha a mo labay lakwên.” ");
INSERT INTO sgb_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Hinabi kana ni Apo Jesus ya habayto, ta êmên mamwangan no ay-êmên yan matsi hi Pedro, ta êmên madyanan pamagpuri hi Apo Namalyari. Amêhên, hinabi ni Apo Jesus kana, ya wana, “Ihundo moy pamakihonol mo kangko.” ");
INSERT INTO sgb_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Namalingay hi Pedro, haka na nahêlêk ya anhumonol kanla hi Juan, ya hatoy tagahonol ya banhagan lan anlugurên ni Apo Jesus. Hatoy namidanin ulo ha pagaw ni Apo Jesus hên nangotang, “Panginoon, hinoy may-upit kamo?” hên nangan hilay na hên haton yabi hên dinakêp la hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Hên nahêlêk ya ni Pedro, kinotang na kan Apo Jesus, ya wana, “Panginoon, hino etaman ya malyari di ha tawoy hatsi? Ay-êmên yan matsi?” ");
INSERT INTO sgb_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Hinabi ni Apo Jesus ya wana, “No labay kon mabiyay yan angga ha pag-orong ko, ay ayn kay nan pakiêmên bayro. Ya daygên mo, ay humonol ka kangko.” ");
INSERT INTO sgb_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Gawan ha hinabi nay habayto, ay nibahwag kanlan ampaniwala kan Apo Jesus ya balita ya a ya matsi ya tagahonol ya hatsi. Noa, a na hinabi ni Apo Jesus, ya a ya matsi. Ta, ya hinabi na ay, “No labay kon mabiyay yan angga ha pag-orong ko, ay ayn kay nan pakiêmên bayro.” ");
INSERT INTO sgb_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Habaytsi ya tagahonol ya banhagan lan anlugurên ni Apo Jesus, hiya ya ampamaptêg ha balang nakahulat di. Hiya êt ya nanulat hên kaganawan hên habaytsi, haka muwang naên ya pamaptêg na ay kaptêgan. ");
INSERT INTO sgb_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Mal-at pon ya dinyag ni Apo Jesus. No ihulat ya kaganawan ya habayto, ay kayno a mihukad di ha luta ya kal-atan kahulatan ya maihulat.");
INSERT INTO sgb_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Panlugurên kon Teofilo, ha unan hulat, ay nanulat ako hên tungkol ha dinyag ni Apo Jesus, haka ya balang in-aral na paubat hên haton una yan nanoro ");
INSERT INTO sgb_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","angga ha allon hiyay ampitag-ay hên palako ha langit. Bayo ya tinumag-ay, ay ha kapangyarihan hên Espiritu ni Apo Namalyari, ay hinabi na pon kanla ya dapat lan daygên, ya hilay pinili nan apostol. ");
INSERT INTO sgb_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ha apatapo ya allo paubat hên natsi ya ha koros haka nabiyay oman, ay panay yan nagpahlêk kanlan apostol, haka mal-at ya dinyag nay pamaptêg hên hiyay taganán nabiyay oman. Haka intoro na ya tungkol ha pamanlokop ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Minghan hên naka-tsipon hila, hinabi ni Apo Jesus kanla, “Paan kaw pon mag-alíh di ha balayan Jerusalem. Êngganan yo pon ya impangako hên Tatang ko, ya idigalo na kamoyu ya nahabi kina. ");
INSERT INTO sgb_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Gawan a mabuyot, ay bawtismoan na kaw ha Espiritu na, ya ipahapat na kamoyu. Habaytsi ay alwan nanad ha pamawtismo ni Juan Bautista ha lanêm, ya a namihapat hên Espiritu ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Hên nilalamo hilay apostol hên kalamo ni Apo Jesus, ay kinotang la ya, ya wanla, “Panginoon, amêhên ana ya pamamaala hên bansan Israel hên nanad ha panaon hên ninuno tamo?” ");
INSERT INTO sgb_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Hinabi ni Apo Jesus kanla, ya wana, “A yo malyarin mamwangan no makanon malyari ya habayto. Ya Tatang ko ya ampanalan hên panaon haka kaganawan ya malyari. ");
INSERT INTO sgb_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Noa, dyanan kaw hên kapangyarihan ha panhumapat kamoyu hên Espiritu ni Apo Namalyari bayo mamipamwang kaw na hên tungkol kangko bayri ha balayan Jerusalem, ha probinsyan Judea, ha probinsyan Samaria, haka ha ayri man ya logal di ha boon luta.” ");
INSERT INTO sgb_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Hên nahabi nay na ya habayto ni Panginoon Jesus, kaban anhêlkên la ya, ay antumag-ay yay na hên palako ha langit haka natagpênan yan ginêm. ");
INSERT INTO sgb_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kaban ampakahêlkên lay langit, ay biglan nagpahlêk kanla ya loway anghel ya nakabaron naputsi ya nirêng ha dani lan apostol. ");
INSERT INTO sgb_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Hinabi lan lowa, “Hikaw ya taga-probinsyan Galilea, awta ampakahêlkên yoy langit! No ay-êmên yan nitag-ay hi Apo Jesus ha langit hên kalamoy lêmm, ay êmbayro êt ya pamag-orong na hên main kalamoy lêmm.” ");
INSERT INTO sgb_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Nag-orong hilay nay apostol hên ubat ha Tawgtug Olibo palako ha balayan Jerusalem, ya dayo bat hên mihay kilometro. ");
INSERT INTO sgb_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Hên nilatêng hilay na ha balayan, ay nunik hilay na ha pagdahêlan lay kuwarto. Hila ya habaytsi ay hilan Pedro, Juan, Santiago, Andres, Felipe, Tomas, Bartolome, Mateo, Santiago, ya anak ni Alfeo, hi Simon ya ambanhagan lan Makabayan, haka hi Judas ya anak ni Santiago. ");
INSERT INTO sgb_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Mimihay nakêm la haka panay hilan ampagtsipon hên manalangin hên kalamoy ungnoy babayi, hi Maria ya indo ni Apo Jesus, haka hilay lalaki, ya patêl ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Hên nalabah ya ungnoy allo, ay nagtsipon ya magatoh haka lowampo ya patêl ha Panginoon. Kalamo la hi apostol Pedro ya nirêng ha arapan la, ta wana, ");
INSERT INTO sgb_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Hikaw ya patêl ko ha Panginoon, kailangan hên matupad ya impahulat nan Espiritu ni Apo Namalyari kan Arin David hên hato, ya tungkol kan Judas Iscariote, ya naypadakêp kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Hi Judas Iscariote, ay kalamo naên pinili ni Apo Jesus hên maghuyo kana.” ");
INSERT INTO sgb_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Ya imbayad kan Judas ha karawakan dinyag na, ay pinanaliw nan luta. Bayro ha luta na ay nanabo ya. Nilumtoh ya bitoka na haka inumawah ya laman na. ");
INSERT INTO sgb_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Namwangan lan kaganawan taga-Jerusalem ya nalyari, kabay ha habi la ay binaêg lay habaytoy luta hên Akeldama, ya labay habiên ay Luta hên Daya.) ");
INSERT INTO sgb_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Hinabi nay na êt ni apostol Pedro, ya wana, “Êmên di ya nakahulat ha libron Awit, ‘Paulayan ya logal na. Alway nan paidyanan ya habayto.’ Nakahulat etaman ya wana, ‘Main dayin managili hên manupad ha tungkulan hên mamaala ya indin kana.’ ");
INSERT INTO sgb_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Kabay dapat kitamon mamili hên mihay kahagili ni Judas. Kailangan miha ya kanlan panay tamon nakalamo hên kalamo tamo hi Panginoon Jesus, ");
INSERT INTO sgb_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","paubat hên binawtismoan ya ni Juan Bautista angga ha hiyay nitag-ay ha langit. Ya piliên tamo, ay dapat mag-in kalamo tamo hên mamipamwang hên tungkol ha pangabiyay oman ni Panginoon Jesus.” ");
INSERT INTO sgb_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Kabay pinili la hi Matias haka hi Jose Justus ya ambaêgên Barsabas ya pamilian lan miha. ");
INSERT INTO sgb_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Nanalangin hila bayto hên wanla, “Panginoon, muwang moy kaihipan hên hinoman. Ipamwang mo kannaên no hino kanlan hata lowa ya pinili mo ");
INSERT INTO sgb_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","hên manupad ha tungkulan hên pangaapostol ya tinalibatokan ni Judas Iscariote, ya nammita ha logal ya hêpat kana.” ");
INSERT INTO sgb_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Hên nayari hilan nanalangin, ay pinagpalabonutan lay langan hên hata lowa, haka nabonut ya langan ni Matias, ya nipahan ha labinmihay apostol. ");
INSERT INTO sgb_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Hên nilumatêng ya pista lan Israelita ya ambaêgên lan Pentecostes, ay naubuh hilan nipagtsipon ha mihay bali ya hilay apostol, haka hilay kaatag ya ampaniwala kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Namakonkaynaman ay main hilan nagilaman ya ubat ha langit ya nanad alaboob ya main kalamoy makhaw ya angin ha boon bali ya dinyanan la. ");
INSERT INTO sgb_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Nakahêlêk hila hên nanad dila ya dêkêt ya nipagtayak ha balang miha. ");
INSERT INTO sgb_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Naubuh hilan hinapatan hên Espiritu ni Apo Namalyari, haka ha kapangyarihan na ay nag-umpisa hilay nan naghabi ha hino-hino kay na hên ya habi ya a la muwang. ");
INSERT INTO sgb_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Hên habayto, ay main Israelita ya ampaidi ha Jerusalem, ya mapanhumonol ha Kautuhan ni Apo Namalyari, ya ubat ha hino kay na hên ya bansa, kabay hino-hino kay na hên ya habi la. ");
INSERT INTO sgb_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Hên nagilam lay nanad hên alaboob ya main kalamoy angin, ay napaidani hila, haka pinilolopungan lay habaytoy ampaniwala kan Apo Jesus. Nag-êpapah hila no pata ampakapaghabi hilay nay ampaniwala kan Apo Jesus hên habi la. ");
INSERT INTO sgb_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Gawan ha pamag-êpapah la ay hinabi la, ya wanla, “Pata ampakapaghabin êmên di hilay hata taga-probinsyan Galilea! ");
INSERT INTO sgb_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ay êmên hilan ampakapaghabin hino-hino kay na hên habi tamo? ");
INSERT INTO sgb_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Main di kantamon taga-Partia, main taga-Media, main taga-Elam, main êt hên ampaidi ha Mesopotamia, ha Judea, ha Capadocia, ha Ponto, haka ha Asia. ");
INSERT INTO sgb_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Main pon êt kantamo hên taga-Frigia haka Panfilia, Egipto, angga ha logal hên Libia ha dani hên Cirene. Ya kaatag kantamo ay taga-Roma, ");
INSERT INTO sgb_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","main Israelita, haka main alwan Israelita ya anhumonol ha paniwala tamon Israelita. Ya kaatag kantamo ay taga-Creta haka Arabia. Yan angkagilaman tamina ya tungkol ha kapapaêpapah ya dinyag ni Apo Namalyari gawan ampakahabi hilay nan habi tamo, ya ampaniwala kan Apo Jesus.” ");
INSERT INTO sgb_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Gawan ha hadyay pamag-êpapah la, ay a la makwan maihip ya nalyari. Kabay ampikokotang hila ya wanla, “Hino ya labay habiên hên habaytsi?” ");
INSERT INTO sgb_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Noa, ya kaatag kanla ay naghabin main lamoy pamandaêh, ya wanla, “Lahing hilan bat ya habain!” ");
INSERT INTO sgb_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nirêng hilay labinloway apostol, haka in-ikhaw ni apostol Pedro ya pamaghabi na ya wana, “Kapareho kon Israelita, haka hikaw ya kaatag pon ya atsi bayri ha balayan Jerusalem. Pakagilamên yon mangêd ya habiên ko kamoyu. ");
INSERT INTO sgb_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Êndat yon lahing kay. Alwa kay lahing, ta alas nuwebe pon hên maranon. ");
INSERT INTO sgb_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ha nalyari kannaên, ay natupad ya hinabi ni Propeta Joel, ya wana, ");
INSERT INTO sgb_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Habaytsi ya anhabiên ni Apo Namalyari. Ya daygên ko ha tawlin allo, ta êmên yo mamwangan ya dapat yon daygên, ay êmên ya di. Ipahapat koy Espiritu ko kanlan balang miha. Ipamwang lan maának yo ya ipaihip ko kanla. Hilay miyawhay yo ay makahêlêk hên halumata, ya ipahlêk ko kanla haka hilay toay lalaki ya ampamaala ay manaynêp hên ipataynêp ko kanla. ");
INSERT INTO sgb_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Kanlan ampaghuyo kangko, ya lalaki haka babayi, ay ipahapat ko ya Espiritu ko, haka ipamwang la ya ipaihip ko kanla. ");
INSERT INTO sgb_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Haka manyag akon kapapaêpapah ha luta haka ha angkahêlêk ha langit. Magkamain daya, apoy, haka makugpa ya ahuk. ");
INSERT INTO sgb_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Dumiglêm ya allo bayto, haka umurit ya buwan hên nanad daya. Lumatêng bayto ya allo, ya ayn kapantag ha kapapaêpapah ya kapangyarihan, yabay ya allon pamag-orong hên Panginoon. ");
INSERT INTO sgb_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Haka hinoman ya ampakiingalo ha Panginoon ay miligtas ha parusa hên kasalanan la.’ Habaytoy impamwang ni Propeta Joel.” ");
INSERT INTO sgb_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Inhundo nay pamaghabi na ni apostol Pedro, ya wana, “Kabay hikaw ya kapareho kon Israelita, pakagilamên yoy habaytsi! Hi Apo Jesus ya taga-Nazaret ay in-utoh ni Apo Namalyari. Pinaptêgan ni Apo Namalyari ya tungkulan ya indin na kan Apo Jesus ha kapapaêpapah ya dyag, ya main kapangyarihan ya impadyag ni Apo Namalyari kana. Muwang yo etaman ya habayto, ta nalyari ya habayto di kamoyu. ");
INSERT INTO sgb_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yabay ya hi Apo Jesus ya mana nay nan tinalagá ni Apo Namalyari hên idin na ha gamêt yo, haka muwang ni Apo Namalyari ya daygên yo kana. Impapako haka impapatsi yo ya ha koros ha nangarawak ya tawo. ");
INSERT INTO sgb_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Noa, hi Apo Jesus ay imbuhan ha kapangyarihan hên kamatsan ta hiyay biniyay oman ni Apo Namalyari, ta ya kamatsan ay ayn kapangyarihan kana. ");
INSERT INTO sgb_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ta ya habi ni Apo Jesus ay impamwang ni Arin David hên hato, ya wana, ‘Nahêlêk ko ya Panginoon ya panay atsi ha arapan ko, ta hiyay panay hên ampanawop kangko, kabay a ko malimo. ");
INSERT INTO sgb_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kabay angkahiglay boon nakêm ko. Mahiglay pamagpuri ko kamo. Main akon kasiguradoan ha impangako mo, ");
INSERT INTO sgb_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","gawan a mo paulayan ya kaêlwa ko ha logal lan natsi. A mon paulayan hên gumata ha pay-ilbêngan ya bangkay hên mapaypaniwal-an mo ya ayn kapantag ha kangêran. ");
INSERT INTO sgb_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Intoro mo kangko ya dann ya palako ha biyay ya ayn angga. Hika ya taganán mamahigla kangko no makit katay nan arap-arapan.’ Habaytoy inhulat ni Arin David.” wani apostol Pedro. ");
INSERT INTO sgb_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Bayo wana, “Kapareho kon Israelita, pakaihipên yoy habaytsi. Hi Arin David, ya ninuno tamo ay natsi, haka ya pinay-ilbêngan kana ay atsi kantamo, ya angkahêlêk angga amêhên. ");
INSERT INTO sgb_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Hiyay mihay propeta ni Apo Namalyari, haka muwang nay impangako ni Apo Namalyari kana, ya miha kanlan kaapo-apoan na ay mag-in ari hên nanad kana. ");
INSERT INTO sgb_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ya pangabiyay oman hên Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala, ay impamwang ni Arin David hên hinabi nan êmên di, ya wana, ‘A ya pinaulayan hên mag-buyot ha logal lan natsi. A pinaulayan hên gumata ya lawini na.’ ");
INSERT INTO sgb_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Habaytoy pinili ni Apo Namalyari hên mag-in Mámiligtas, ay ayn kaatag no alwan hi Apo Jesus, ya biniyay oman ni Apo Namalyari. Haka muwang naên ya habayto, ta naubuh naên yan nahêlêk hên nabiyay yan oman, haka habaytoy an-ipamwang naên. ");
INSERT INTO sgb_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Hiyay intag-ay ha langit ni Apo Namalyari, ya Tatang na, haka hiyay dinyanan tungkulan. Ha tungkulan na, ay namihapat yan Espiritu ni Apo Namalyari kannaên. Yabay ya impangako na, ya angkahêlêk haka angkagilaman yo amêhên. ");
INSERT INTO sgb_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ta main yan hinulat hi Arin David ya tungkol ha Panginoon na, ya intag-ay ha langit, alwan tungkol ha sarili na. Hatsi ya hinulat na, ya wana, ‘Hinabi ni Apo Namalyari ha Panginoon ko, ya wana, “Mikno ka ha dapit panabtab ko hên mamaala hên kalamo ko, ");
INSERT INTO sgb_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","angga ha hambutên ko hilay kapatsi mo, ta idin ko hila ha aypan kapangyarihan mo.”’ ” ");
INSERT INTO sgb_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Inhundo ni apostol Pedro ya pamaghabi na, ya wana, “Kabay hikaw haka ya balang kapareho kon Israelita, ay dapat mamwangan ya hi Apo Jesus ya impapatsi yo ha koros, ay yabay ya dinyag ni Apo Namalyari hên Panginoon, haka Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala!” ");
INSERT INTO sgb_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Hên nagilam la ya hinabi kanla ni apostol Pedro, ay angkahêmêkan lay sarili la. Kabay kinotang la hi apostol Pedro haka hilay kaatag ya apostol, ya wanla, “Hikaw ya kapareho naên Israelita, hino awud ya dapat naên daygên?” ");
INSERT INTO sgb_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Hinabi kanla ni apostol Pedro, ya wana, “Ya balang miha kamoyu, ay dapat hên maghêhê. Dapat talibatokan yoy pamanyag hên kasalanan, haka pabawtismo kaw ha langan ni Apo Jesu-Cristo, ta êmên mapatawad ya kasalanan yo, haka ta êmên na ipahapat kamoyu ni Apo Namalyari ya Espiritu na. ");
INSERT INTO sgb_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ta ya Espiritu ni Apo Namalyari ay impangako kamoyu etaman, haka kanlan maának tamo, haka kanlan kaapo-apoan tamo, haka kanlan atsi ha mangarayo ya logal. Awo bay, namipangako hi Apo Namalyari, ya Panginoon tamo, hên ipahapat ya Espiritu na kanlan pinili na, hên mag-in kana.” ");
INSERT INTO sgb_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Mal-at pon ya pamaptêg kanla ni apostol Pedro, haka inaralan na hila, ta êmên hila miakay ha kaptêgan, ya wana, “Makiingalo kaw kan Apo Namalyari, ya iligtas kaw ha parusa ya ayn angga ya lumatêng kanlan ampanyag karawakan!” ");
INSERT INTO sgb_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Mal-at ya naniwala ha impamwang ni apostol Pedro kabay binawtismoan la hila. Ha alloy habayto ay tatlon liboy nipahan kanlan ampaniwala kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Inhundo lay pamanggilam la ha intoro lan apostol. Nakiagêm hila ha pami-tsi-tsipon lan apostol hên manalangin, haka magkomunyon hên main mangêd ya pamilalamo. ");
INSERT INTO sgb_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Gawan ha kapangyarihan ni Apo Namalyari, ay namaalíh hilay apostol hên hakit hên kal-atan, haka nanyag hila hên kaatag pon ya kapapaêpapah ha ikakangêd lan atsi bayro, kabay naubuh hilan nipag-êpapah, hên main kalamoy pamanggalang kan Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Hilay ampaniwala kan Apo Jesus, ay ampagmimihan nakêm haka ya pibandian la ay ampiaagêmên la. ");
INSERT INTO sgb_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","An-ihaliw lay pibandian la, ta ya pera ya naabli la ay an-idin do ha ampangailangan hên balang miha. ");
INSERT INTO sgb_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Allo-allo hilan ampagtsipon ha Templo. Ampiaaêm hila haka ampagkomunyon hila ha bali la hên mahiglay nakêm. ");
INSERT INTO sgb_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Panay lan ampuriên hi Apo Namalyari. Haka hila ay an-igalang hên hinoman ya atsi bayro. Allo-allo ay an-ipahan kanla hên Panginoon ya hilay ampiligtas ha parusa ya ayn angga. ");
INSERT INTO sgb_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Minghan hên alas tres hên maapon, ya oras hên panalangin lan Israelita ay nilumohan hi apostol Pedro haka hi apostol Juan ha Templo. ");
INSERT INTO sgb_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Bayro ha Templo, ay main ambaêgên Mahampat ya Ilwangan. Allo-allo ay anggêtan la bayro ya mihay lalaki, ya mamalimos, ya a ampakabita hên paubat hên in-anak ya, ta ampakikwa yan pera kanlan anhumwên bayro. ");
INSERT INTO sgb_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Hên nahêlêk na hilay loway apostol ya anhumwên ha Templo, ay nakikwa yan pera kanla. ");
INSERT INTO sgb_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pinakahêlêk la ya, bayo wani apostol Pedro kana, “Hêlkên mo kay!” ");
INSERT INTO sgb_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Kabay pinakahêlêk na hila ta êndat nan dyanan la yan pera. ");
INSERT INTO sgb_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Noa, wani apostol Pedro kana, “Taganán ayn akon pera, noa, hawpan kata. Ha kapangyarihan ni Apo Jesu-Cristo, ya taga-Nazaret, ay an-iutoh katan mirêng haka mita!” ");
INSERT INTO sgb_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tinalan ni apostol Pedro ya gamêt na ta hinawpan na yan nirêng ya habaytoy lalaki ya a ampakabita. Namakon, ay tambêng hinumkaw ya bitsih haka boklong na. ");
INSERT INTO sgb_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Naglukho yay nan nirêng, haka nakilako yay na kanlan apostol Pedro hên hinumwên ha Templo hên ampakabita hên paglukho-lukho hên ampagpuri kan Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nadambi la ya, hên kal-atan ya atsi bayro. ");
INSERT INTO sgb_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Nabalayan la ya, ya hiya awud ya hatoy lalaki ya a ampakabita ya ampakikwa hên pera ha Mahampat ya Ilwangan, haka nipag-êpapah hila ha nalyari kana. ");
INSERT INTO sgb_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Pangayarin habayto, hên atsi hilay loway apostol ha ambaêgên lan Portiko ni Arin Solomon ya atsi bayro êt ha Templo, ay hatoy lalaki ya ampakabitay na ay nayêngyêng hên a mabay paibul-ih kanla. Naubuh etaman hên nuwayun dinumani kanlay kal-atan ampipag-êpapah ha nalyari. ");
INSERT INTO sgb_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Hên pamakahêlêk ni apostol Pedro kanlan kal-atan, ay wana kanla, “Hikaw ya patêl ko, ya kapareho kon Israelita, awta ampag-êpapah kaw ha nalyari? Pata ampakahêlkên yo kay? Kayno êndat yon napabita naên ya ha sarili naên kapangyarihan o gawan mangêd ya ugali naên! ");
INSERT INTO sgb_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Taganán alwan hikay, noa, hi Apo Namalyari ya namabita kanan hata lalaki. Hiya ya ansimbaên lan ninuno tamo, ya hilan apo Abraham, apo Isaac haka hi apo Jacob, haka hiya ya namabita kanan hata lalaki, ta êmên mamwangan ya panga-Diyos ni Apo Jesus. Hi Apo Jesus ya nanyag kalabayan na di ha luta, ay atsi ha langit amêhên hên ampamaala. Yabay ya a yo pinaniwal-an, ya indin yo kanlan manungkulan, haka ya inara yo, agyan ibuhan ya dayi ni Gobernador Pilato. ");
INSERT INTO sgb_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Hiya ya Banal haka Makatoynungan, noa, a yo yan pinaniwal-an, yan hatoy mapamatsi, ay impabuhan yo kan Gobernador Pilato! ");
INSERT INTO sgb_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Impapatsi yo, ya ampam-in biyay ya ayn anggaan, noa, biniyay yan oman ni Apo Namalyari, haka hikay ya ampamaptêg ya biniyay yan oman gawan nahêlêk naên ya. ");
INSERT INTO sgb_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ya kapangyarihan ni Apo Jesus haka ya paniwala kana, ay namabita kanan hata lalaki ya angkahêlêk yo, ya muwang yo. Hiyay makhaw di ha arapan yo gawan ha paniwala kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Patêl ko, muwang koy impapatsi yo ya, gawan a yo muwang ya hiyay Mesias, ya Cristo. Hila man ya ampamaala, ay a la muwang ya hiyay habayto. ");
INSERT INTO sgb_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ha dinyag yo ay natupad ya impamwang lan mámipamwang hên an-ipaihip kanla ni Apo Namalyari, ya dapat magdusa haka matsi ya Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala. ");
INSERT INTO sgb_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kabay dapat kaw hên maghêhê, haka dapat kaw hên mag-orong kan Apo Namalyari ta êmên kaw mapatawad ha kasalanan yo. ");
INSERT INTO sgb_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","No daygên yoy habayto, ay papaynawaên hên pakhawên ni Apo Namalyari ya nakêm yo haka iutoh na kamoyu hi Apo Jesus, ya Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili na hên mamaala kamoyu. ");
INSERT INTO sgb_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Hiyay dapat paidi pon ha langit angga ha matupad ya kaganawan ya impapapêt ni Apo Namalyari kanlan banal ya mámipamwang hên an-ipaihip na kanla hên hato. ");
INSERT INTO sgb_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ta êmên ya di ya hinabi ni apo Moises hên hato, ‘Lumatêng ya allo ay main propeta, ya nanad kangko, ya iutoh kamoyu ni Apo Namalyari, ya Panginoon. Hiyay mihay kapareho tamon Israelita. Dapat yon honolên ya hinon habiên na kamoyu. ");
INSERT INTO sgb_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ya balang a humonol kanan habaytoy mámipamwang hên an-ipaihip kana ni Apo Namalyari, ay ipapawa kanlan ampaniwala kan Apo Namalyari ta patsên na hila.’” ");
INSERT INTO sgb_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Inhundo ni apostol Pedro ya pamaghabi na, ya wana, “Hilay propeta ni Apo Namalyari paubat kan apo Samuel ay pare-parehon namipamwang hên angkalyari amêhên. ");
INSERT INTO sgb_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Hikitamo ya kaapo-apoan lan propeta ni Apo Namalyari, ya pinaypangakoan na hên habaytsi ya Mesias, ya Cristo. Haka hikitamo êt ya kalamo ha kahundoan ni Apo Namalyari ha ninuno tamo. Nanad ha hinabi na kan apo Abraham, ya wana, ‘Ingalwan ko hilay kal-atan ha balang bansa ha boon luta gawan ha mihay kaapo-apoan mo. Habaytoy hinabi ni Apo Namalyari.’” ");
INSERT INTO sgb_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Inhundo nay na êt ni apostol Pedro ya pamaghabi na, ya wana, “Kabay unan in-utoh ni Apo Namalyari kantamon Israelita, hi Apo Jesus, ya nanyag kalabayan na di ha luta. Hiyay Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala, ya nangingalo kantamo hên namipatalibatok ha kasalanan tamo.” ");
INSERT INTO sgb_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Hên ampaghabi pon hi apostol Pedro haka hi apostol Juan ha kal-atan ya atsi bayro ha Portiko ni Arin Solomon ha Templo, ay main nilumatêng ya ungnoy pari ya ampamaala ha Templo, kalamo lay kapitan lan ampamantay ha Templo, haka ungnoy Saduseo, ya a ampaniwala ya biyayên oman ya hilay natsi. ");
INSERT INTO sgb_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Hadyay huluk la kanlan loway apostol gawan an-itoro la kanlan tawo ya biniyay oman hi Apo Jesus, haka habaytsi ay ampamaptêg ya mabiyay oman hilay natsi. ");
INSERT INTO sgb_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kabay dinakêp la hilay loway apostol, noa, gawan yabi yana, ay inhukul la hila pon hên angga ha humonoy allo. ");
INSERT INTO sgb_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Êmbayro man, ay mal-at kanla ya nakagilam ha pamipamwang lan apostol, ya naniwala kan Apo Jesus. Kabay nag-in liman libo (5,000) hilay nay lalaki ya ampaniwala. ");
INSERT INTO sgb_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Hên humonoy allo, ay ni-tsi-tsipon ha Jerusalem hilay mánoron Kautuhan ni apo Moises, hilay toa ya nag tungkulan ha bansa, haka hilay kaatag pon ya ampamaala ha Israelita. ");
INSERT INTO sgb_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Atsi êt bayro hi Anas, ya pinakapoon pari, haka hi Caifas, hi Juan, hi Alejandro, haka hilay kaatag ya lalaki ya kamag-anak ni Anas. ");
INSERT INTO sgb_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","In-arap hi apostol Pedro haka hi apostol Juan ya ubat ha hukulan ta kinotang la hila ya wanla, “Hinoy nam-i kamoyu hên kapangyarihan ta napabita yoy hata lalaki ya a ampakabita?” ");
INSERT INTO sgb_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ha kapangyarihan hên Espiritu ni Apo Namalyari, ay naghabi hi apostol Pedro, ya wana, “Anggalangên kon mangatoa ya main tungkulan ha bansa, haka hikaw ya kaatag pon di ya main tungkulan, ");
INSERT INTO sgb_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","no angkotangên yo kay hên tungkol ha kangêran ya dinyag naên ha mihay lalaki ya ampaghakit, haka no ay-êmên yan nakabita, ");
INSERT INTO sgb_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ay dapat mamwangan yo haka ya balang kapareho tamon Israelita ya habaytsi. Ya hata lalaki ay ampakairêng amêhên di ha arapan yo hên ayn nanan hakit, gawan ha kapangyarihan ni Apo Jesu-Cristo ya taga-Nazaret, ya impapatsi yo ha koros, ya biniyay oman ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Hiyay in-alimbawa ha impahulat ni Apo Namalyari ya tungkol kanan Mesias, ya Cristo, ya wanan hulat, ‘Ya bato ya intapon yon mámipairêng hên bali, ay nag-in pinakamaalagáy bato ta êmên mag-in napah-êy ya bali.’ ");
INSERT INTO sgb_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ayn kaatag ha boon luta ya makapiligtas kantamo ha parusa ya ayn anggaan no alwan hi Apo Jesu-Cristo, ya in-utoh ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nipag-êpapah hilay ampamaala ha Templo ha kakhawan nakêm lan loway apostol, hên namwangan la ya naaypan bat ya pinag-aralan la. Namwangan lay na, ya hila awud ya kala-kalamo ni Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Noa, ayn hilay nan mahabi ta angkahêlêk lay nay lalaki, ya ampakabitay na, ya nakairêng hên kalamo lan apostol. ");
INSERT INTO sgb_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kabay pinaawah la hila pon hilan apostol Pedro ha pami-tsi-tsipon lan Sanedrin, bayo pinihabian la no hinoy daygên la. ");
INSERT INTO sgb_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Hino” wanla, “ya daygên tamo kanlan habaytsi? A tamina maipuglaoh ya habaytsi ya dinyag lay kapapaêpapah, ta hilay atsi di ha boon Jerusalem ay ampakamwang hên dinyag la. ");
INSERT INTO sgb_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ta êmên a lalon mibahwag ya habaytsi, ay bawalên tamo hilan maghabi hên tungkol kan Jesus ha hinoman.” ");
INSERT INTO sgb_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kabay impabaêg hilan oman haka binawal hila, ya paan hila mamitoro o maghabi man hên tungkol kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Noa, hinabi lan apostol, “Hikaw ya manimbángan no hinoy mangêd ha arapan ni Apo Namalyari, no humonol kay kamoyu, o no humonol kay kan Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ta a naên maipatgên ya pamipamwang hên nahêlêk haka nagilam naên kan Apo Jesus.” ");
INSERT INTO sgb_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Amêhên, lalo la hilan binawal biha hila imbuhan. A la maihipan no ay-êmên la hilan maparusaan, ta kal-atan ya taga-Jerusalem ay ampagpuri kan Apo Namalyari, gawan ha napabita lan apostol ya habaytoy lalaki, ");
INSERT INTO sgb_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ya maigit apatapoy taon hên habayto. ");
INSERT INTO sgb_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Hên naibuhan hilay loway apostol, ay nagtagloh hilay na ha kalamo lan ampaniwala kan Apo Jesus, haka la impamwang ya hinabi kanla hên poon pari haka hilay toa ya main tungkulan ha bansa. ");
INSERT INTO sgb_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Hên nagilam lay habayto, ay nipagpuri hila kan Apo Namalyari, ya wanla, “Panginoon, hika ya nanyag hên langit, luta, dagat, haka ya kaganawan ya atsi kanla! ");
INSERT INTO sgb_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ya Espiritu mo ay namipahabi kan Arin David, ya ninuno naên, ya naghuyo kamo, ya wana, ‘Pata hadyay omot ulo lan alwan Israelita kan Apo Namalyari? Awta ampangihip hilan ayn kapukatan ya kapareho kon Israelita? ");
INSERT INTO sgb_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Hilay ari ya ampamaala bayri ha luta, haka hilay kaatag ya ampamaala, ay ampi-tsi-tsipon hên manalanghang kan Apo Namalyari haka ha tinalagá nan mag-in Mesias, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala.’ ");
INSERT INTO sgb_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Muwang naên ya habaytoy impahabi mo kan Arin David hên hato, ay natupad. Ta di ha Jerusalem, ay nagkamiha hilan Herodes Antipas, hi Poncio Pilato, hilay alwan Israelita, haka hilay kapareho naên Israelita, hên patsên hi Apo Jesus, ya ayn hinon kasalanan, ya nanyag kalabayan mo di ha luta, ya tinalagá mon mag-in Mesias, ya Cristo. ");
INSERT INTO sgb_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Gawan makapangyarihan ka, ay dinyag lan bêngat ya mana minan tinalagá. ");
INSERT INTO sgb_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Haka amêhên, Panginoon, pansinên mo dayi ya habla la kannaên, haka pakhawên moy nakêm naên, ha paghuyo naên kamo ha pamipamwang hên habi mo. ");
INSERT INTO sgb_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Dayi ipahlêk moy kapangyarihan mo ta êmên kay makapaalíh hên hakit haka makadyag hên kaatag pon ya kapapaêpapah, gawan kan Apo Jesus, ya ayn hinon kasalanan, ya nanyag kalabayan mo di ha luta.” ");
INSERT INTO sgb_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pangayari lan nanalangin, ay nayêgyêg ya pinagtsiponan la. Ha kapangyarihan hên Espiritu ni Apo Namalyari, ay hinumkaw ya nakêm lan namipamwang hên habi na. ");
INSERT INTO sgb_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Hilay ampaniwala kan Apo Jesus ay nagkamiha hên kaihipan boy nakêm, haka ayn kanla ya nay-imot hên bandi la ha miha ta miha. ");
INSERT INTO sgb_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ha makhaw ya kapangyarihan hên Espiritu ni Apo Namalyari ay impamwang lan apostol ya biniyay oman hi Panginoon Jesus. Haka ya ayn kapantag ya ingalo na, ay atsi ha balang ampaniwala. ");
INSERT INTO sgb_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Ayn kanlan nagkulang ha hinon kailangan, ta hilay main luta o bali, ay namihaliw hên habayto, haka la indin kanlan apostol ya naablian la, bayo indin lan apostol kanlan ampangailangan. ");
INSERT INTO sgb_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Êmbayro êt ya dinyag ni Jose ya taga-Chipre, ya mihay Levita ya kaapo-apoan ni apo Levi Ya pamaêg lan apostol kana ay Bernabe, ya labay habiên mamahiglan nakêm. ");
INSERT INTO sgb_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Main yan luta hi Bernabe ya inhaliw na, haka na indin kanlan apostol ya naablian na. ");
INSERT INTO sgb_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Main miahawa ya nag langan Ananias haka Safira ya namihaliw hên luta la etaman. ");
INSERT INTO sgb_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Noa, pinagkamihaan lan miahawa ya a lan iubuh hên idin kanlan apostol, ya hatoy naablian la ha luta la. Kabay kaatag bat hên naablian la ya gintan ni Ananias kanlan apostol. ");
INSERT INTO sgb_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Noa, wani apostol Pedro kana, “Ananias, pata nagpatukso ka kan Satanas, hên naglaram ka ha Espiritu ni Apo Namalyari hên nagbabaran indin moy boon naablian yo? ");
INSERT INTO sgb_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Yarin alwan kamoyu ya habaytoy luta hên a yo pon inhaliw! Yarin alwa êt kamoyu ya naablian yo! Pata pinagkamihaan yon maglaram hên indin yoy kabooan naablian? A ka naglaram ha tawo, noa, naglaram ka kan Apo Namalyari!” ");
INSERT INTO sgb_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Pamakagilam ni Ananias hên habayto, ay natsi ya. Hadyay nay pag-êpapah lan nakagilam ha nalyari kana. ");
INSERT INTO sgb_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Main miyawhay bayro ya namipungguh hên bangkay na ta gintan hên in-ilbêng. ");
INSERT INTO sgb_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Pamakalabah hên tatloy oras, ay nilumatêng ya ahawa ni Ananias, ya hi Safira, ya ayn kamuwang-muwang ha nalyari ha ahawa na. ");
INSERT INTO sgb_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Hinabi ni apostol Pedro kana, ya wana, “Habiên mo kangko no hahatsin bat ya naablian yon miahawa ha luta yo.” “Awo, habain bat.” ");
INSERT INTO sgb_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kabay wani apostol Pedro kana, “Pata pinagkamihaan yon subukên ya Espiritu nan Panginoon? Anlumatêng hilay nay-ilbêng hên bangkay hên ahawa mo, haka hilay na êt ya manapwat hên bangkay mo hên mamilbêng.” ");
INSERT INTO sgb_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tampol yan natsi hi Safira. Panhumwên lan miyawhay, ay nahêlêk lay nay bangkay na. Kabay in-ilbêng lay na êt ya bangkay na ha dani hên pinay-ilbêngan lan ahawa na. ");
INSERT INTO sgb_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Hadyay limo lan patêl ha Panginoon ya angkapi-tsi-tsipon haka hadyay limo lan balang miha ya nakagilam hên nalyari kan Ananias haka kan Safira. ");
INSERT INTO sgb_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Hên habayto ay mal-at ya inalihan hakit, haka mal-at ya kaatag ya kapapaêpapah ya dinyag lan apostol ha kapangyarihan ni Apo Namalyari ha arapan lan kal-atan. Angkapi-tsi-tsipon hilay ampaniwala kan Apo Jesu-Cristo ha Templo, ha logal ya ambaêgên Portiko ni Arin Solomon. ");
INSERT INTO sgb_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Hilay a ampaniwala kana, ay a ampaidani kanla ta malimo hila hên makilamo kanla. Êmbayro man, ay anggalangên lay ampaniwala kan Apo Jesu-Cristo. ");
INSERT INTO sgb_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Noa, lalo hên anlum-at hilay kal-atan lalaki haka babayi ya ampaniwala kan Panginoon. ");
INSERT INTO sgb_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Gawan ha mal-at ya kapapaêpapah ya andaygên lan apostol, ay anhapwatan lan ayn hakit, ya ampipaghakit, ha pangkatuluyan la, hên gêtan ha danin dann, ta êmên ha pamagdann ni apostol Pedro, ay maêtêban hila man hên anino na ya kaatag kanla, ay maalíh ya hakit la. ");
INSERT INTO sgb_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Main êt kal-atan ya nilumatêng ya naubat ha balayan ya nakapalibot ha Jerusalem. Anggêtan la hilay main hakit haka hilay ampairapan hên nangarawak ya a angkahêlêk. Impaalíh ya hakit lan main hakit, haka ya nangarawak ya a angkahêlêk ya ampamairap kanlan kaatag. ");
INSERT INTO sgb_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Hadyay kahêm hên pinakapoon pari, haka hên kalamo nay panay Saduseo, ha angkadyag lan apostol. ");
INSERT INTO sgb_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Kabay dinakêp la hilay apostol ta inhukul. ");
INSERT INTO sgb_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Noa, hên yabin habayto, ay niloat hên mihay anghel hên Panginoon ya kabat hên hatoy hukulan, haka na hila pinaawah ya apostol, ta wana kanla, ");
INSERT INTO sgb_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Mamipamwang kaw kanlan atsi bayro ha Templo hên tungkol ha bayon biyay ya an-idin ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Hinonol lan apostol ya hinabi na, kabay hên dali alloy na, ay hinumwên hilay na ha Templo ta nanoro. Noa, a la muwang hên pinakapoon pari haka hilay kalamo na, ya nakaawah hilay nay apostol ha hukulan. Hên nilumatêng hila ha pagtsiponan la, ay impaalap la ya boon Sanedrin haka ya kaganawan toa ya main tungkulan ha bansa. Biha namiutoh hilan bantay ya kowên hilay apostol ha hukulan. ");
INSERT INTO sgb_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Noa, pamanlumatêng lan bantay ha hukulan, ay ayn hilay na bayro, kabay tampol hilan nag-orong ta inhumbung kanlan naka-tsipon ya wanla, ");
INSERT INTO sgb_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Hên nilatêng kay ha hukulan, ay nakakabat ya, haka hilay bantay ay atsi bayro ha kabat. Noa, hên niloat naên ya habaytoy kabat, ay ayn hilay na bayro ya apostol!” ");
INSERT INTO sgb_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Hên nagilam lan poon lan ampamantay ha Templo, haka hilay poon pari ya habayto, ay a la makwan maihip no hino pon ya malyari. ");
INSERT INTO sgb_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Namakonkaynaman ay main nilumatêng ya namihumbung, ya hatoy impahukul la, ay atsi ha Templo hên ampanoro. ");
INSERT INTO sgb_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kabay inalap la hilay apostol, hên kapitan lan bantay ha Templo hên kalamo na hilay bantay. Gintan lay apostol hên a la hila pinahakitan, ta malimo hilay bantay ya batoên hila hên antoroan lan apostol. ");
INSERT INTO sgb_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Paglatêng la bayro ha pagtsiponan lan Sanedrin, ay in-arap hilay apostol, ta kinotang na hila hên pinakapoon pari. ");
INSERT INTO sgb_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Wana kanla, “Impapakabawal naên kamoyu ya paan yoy nan itoro ya tungkol kan Jesus. Yan lalo yon intoro ya tungkol kana ha boon Jerusalem, haka ampalwahên yo pon êt hên hikay ya main kasalanan ha pangamatsi na!” ");
INSERT INTO sgb_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Noa, hinabi lan apostol Pedro, ya wanla, “Hi Apo Namalyarin bêngat ya dapat naên honolên, alwan tawo. ");
INSERT INTO sgb_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Hi Apo Namalyari, ya ansimbaên hên ninuno tamo, ay namabiyay oman kan Apo Jesus ya impapatsi yo ha koros. ");
INSERT INTO sgb_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Hi Apo Namalyari etaman ya namitag-ay kana hên mag-in Poon haka Mámiligtas tamon Israelita, ta êmên kitamo mapatawad ha kasalanan ya ampaghêhêan haka antalibatokan tamo. ");
INSERT INTO sgb_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ampaptêgan naên, haka ampaptêgan nan Espiritu ni Apo Namalyari, ya an-ipahapat na kanlan anhumonol kana, ya habaytsi ya nalyari kan Apo Jesus.” ");
INSERT INTO sgb_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Pamakagilam lan ampamaala hên habayto, ay hadyay tulaw la, haka labay la hilay nan patsên ya apostol. ");
INSERT INTO sgb_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Noa, nirêng ya mihay Pariseo, ya kalamo hên Sanedrin ya nag langan Gamaliel, ya mihay mánoron Kautuhan ni apo Moises, ya anggalangên hên kal-atan. In-utoh na, ya iawah hila pon ya apostol ha pami-tsi-tsipon la. ");
INSERT INTO sgb_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Bayo wana kanlan naka-tsipon, “Kapareho kon Israelita, pakaihipên yo pon mangêd ya daygên yo kanlan habaytsi. ");
INSERT INTO sgb_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Hên hato ay main êt êmên di ya nalyari. Hi Teudas ya nagbabara hên mihay makhaw ya ampamaala, ay nakahagyat hên apat a gatoh ya lalaki ya nakilamo kana. Noa, a nadyag ya labay nan daygên, ta hên napatsi ya, ay nangapi-hihiyay hila tanay habaytoy kalamo na. ");
INSERT INTO sgb_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pangayarin habayto, ay êmbayro êt ya nalyari kan Judas, ya mihay taga-probinsyan Galilea, hên haton panaon hên pamamayad hên buwih. Nakahagyat ya êt hên kal-atan lalaki. Hên napatsi ya, ay nangapi-hihiyay etaman hilay nahagyat na. ");
INSERT INTO sgb_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kabay ampakihabi ko kamoyu amêhên, ya paan yo hilan pakiêmênan hilay habaytsi. Paulayan hila tana, ta no habaytsi ya andaygên la, ay ubat bêngat kanla, ay ayn hilan madyag. ");
INSERT INTO sgb_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Noa, no ubat kan Apo Namalyari ya andaygên la, ay a yo hila mapatunggên. Ta kayno lumtaw kaw hên anhumalanghang kana!” Habayto ya imbilin ni apo Gamaliel kanla. Kabay hinonol lan naka-tsipon ya aral na. ");
INSERT INTO sgb_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Pinahowên la hilan oman ya apostol. Impalatiko hila haka binawal la hilan manoro hên tungkol kan Apo Jesus. Pangayari, ay imbuhan la hila. ");
INSERT INTO sgb_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Nag-alíh hilay apostol ha arapan Sanedrin. Hadyay kahiglaan la gawan intad hila ni Apo Namalyari hên hêpat hên mipakarêng-êy gawan ha pamanhumonol la kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Allo-allo ay inhundo lay pamanoro haka pamipamwang ha Templo angga ha binali-bali, ya tungkol kan Apo Jesu-Cristo ya hiyay Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala, ya an-êngganan la. ");
INSERT INTO sgb_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Hên panaon hên habayto, kaban anlum-at hilay ampaniwala kan Apo Jesus, ay main kanla ya ampaghabin Griego, ya ampagreklamo kanlan kapareho lan Israelita ya ampaniwala kan Apo Jesus, ya ampaghabin Hebreo. Panhabiên la ya angkapaulayan hilay babayin Griego ya ayn nanan ahawa, ha pami-arasyon ha pan-allo-allo lan pamangailangan. ");
INSERT INTO sgb_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kabay impa-tsipon lan labinloway apostol ya kaganawan lan ampaniwala kan Apo Jesu-Cristo ta wanla, “Alwan mangêd hên mamaala kay ha rasyon ta mapaulayan naên ya pamipamwang hên Habi ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kabay patêl, mamili kaw na ha kalamo yo hên pitoy lalaki, ya muwang yoy nay mangêd ya ugali, ya main kagalingan, haka panay ampamiyay ha kapangyarihan hên Espiritu ni Apo Namalyari. Idin naên kanla ya tungkulan hên mami-arasyon. ");
INSERT INTO sgb_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Hikay etaman, ay maiubuh naên bayto ya ihip naên ha panalangin haka ha pamipamwang hên Habi ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nalabayan lan naka-tsipon ya hinabi lan apostol, kabay namili hilay na. Ya miha ya pinili la ay hi Esteban. Nananiêh ya paniwala na haka atsi kana ya kapangyarihan nan Espiritu ni Apo Namalyari. Pinili la etaman hilan Felipe, Procoro, Nicanor, Timon, Parmenas, haka hi Nicolas. Hi Nicolas ya taga-Antioquia, ay mihay alwan Israelita, noa, anhumonol yay na ha paniwala lan Israelita, haka ampaniwala ya etaman ya hi Apo Jesus ay habaytoy impangakon Mámiligtas. ");
INSERT INTO sgb_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","In-arap lay hatoy pitoy pinili la kanlan apostol. Impalunto lan apostol ya gamêt la kanla ta inhalangin la hila. ");
INSERT INTO sgb_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Kabay lalon nipamwang ya habi ni Apo Namalyari, hên angga ha panlulum-at hilay ampaniwala kan Apo Jesus ha Jerusalem. Mal-at etaman ya pari ya naniwala. ");
INSERT INTO sgb_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Atsi kan Esteban ya kapangyarihan haka ya ayn kapantag ya ingalo ni Apo Namalyari. Namaalíh yan hakit lan kal-atan haka nanyag ya êt hên kaatag ya kapapaêpapah ha ikakangêd lan atsi bayro. ");
INSERT INTO sgb_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Noa, pinakihubakan la yan ungnoy kalamo la ha ambaêgên Sinagoga lan Ipoh ya Imbuhan. Habaytsi ya sinagoga ay angkaboo hên Israelita ya taga-Cirene, taga-Alejandria, taga-probinsyan Cilicia, haka taga-Asia. ");
INSERT INTO sgb_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Noa, a la ya mahambut ha pamakibat, gawan ha kagalingan pamaghabi na ya ubat ha Espiritu ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kabay hên ayn makamwang, ay inamuyot lay ungnoy lalaki ya maghabin kalaraman. Habaytsi ya impahabi la kanla, “Nagilam naên ya hinabi ni Esteban ya pamanira ha Kautuhan ni apo Moises haka kan Apo Namalyari!” ");
INSERT INTO sgb_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ya hinabi la ay nakapahuluk kanlan toa ya main tungkulan ha bansa, kanlan mánoron Kautuhan ni apo Moises, haka kanlan kal-atan ya atsi bayro. Kabay dinakêp la hi Esteban, haka la ya in-arap ha Sanedrin. ");
INSERT INTO sgb_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Namiarap hila etaman hên naghabin kalaraman ya halanghang kan Esteban ya wanla, “Hata lalaki, ay ayn têgên ha pamaghabi hên halanghang ha Templo ni Apo Namalyari haka ha Kautuhan ni apo Moises. ");
INSERT INTO sgb_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nagilam naên êt ya hinabi na ya agwatên kano ni Jesus ya taga-Nazaret, ya habaytsi ya Templo, haka omanên na kano ya ugali ya impahonol kantamo ni apo Moises!” ");
INSERT INTO sgb_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Hilay kaganawan kalamo hên Sanedrin ay namakahêlêk kan Esteban, haka la nahêlêk ya lupa na, ya nanad lupa hên mihay anghel ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kinotang nan pinakapoon pari hi Esteban, no pêtêg ya habaytoy imbara kana. ");
INSERT INTO sgb_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Hinabi ni Esteban, ya wana, “Hikaw ya patêl ko haka matoa ko, pakagilamên yo ya anhabiên ko. Hên haton a ya pon ampaidi ha balayan hên Haran, hên idi ya pon ha Mesopotamia, hi apo Abraham, ya ninuno tamo, ay nagpahlêk kana, hi Apo Namalyari ya ayn kapantag ha kapangyarihan, kangêran haka kahampatan. ");
INSERT INTO sgb_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Wana kan apo Abraham, ‘Mag-alíh ka bayri ha luta mo. Ibalag moy kamag-anak mo ta lakwên moy logal ya itoro ko kamo.’ ");
INSERT INTO sgb_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Kabay immalíh hi apo Abraham bayro ha luta na ha bansan Caldeo ta napaidi ya ha Haran. Hên pangamatsi hên tatang na, ay in-álih na ya ni Apo Namalyari bayri ha lutan Canaan ya andyanan tamo amêhên. ");
INSERT INTO sgb_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Êmbayro man, ay a na ya pon dinyanan hên nanawa man ya hukat hên luta bayri. Noa, impangako kana ni Apo Namalyari, ya habaytsi ya lutan Canaan, ay idin kana, haka ha mag-in kaapo-apoan na. Hên nangako hi Apo Namalyari hên habayto, ay ayn ya pon anak hi apo Abraham. ");
INSERT INTO sgb_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Êmbayri ya hinabi ni Apo Namalyari kana, ‘Hilay mag-in kaapo-apoan mo ay paidi ha kaatag ya bansa. Daygên hilan ipoh bayro, haka hila pairapan ha apat a gatoh ya taon. ");
INSERT INTO sgb_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Noa, parusaan ko hilay mamaipoh kanla. Panga-ubat kanan habayto, ay mag-alíh hila bayro, ya mag-in kaapo-apoan mo, ta bayri la kon simbaên.’ Êmbayroy hinabi ni Apo Namalyari kan apo Abraham. ");
INSERT INTO sgb_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Haka in-utoh na ya êt hên dapat tuliên ya mag-in kaapo-apoan na ya palatandaan hên kahundoan na kanla. Kabay hên in-anak hi apo Isaac, hên nakalabah ya waloy allo ay tinuli na yay na ni apo Abraham. Êmbayro êt ya dinyag ni apo Isaac kan apo Jacob, ya anak na. Hi apo Jacob, ya ambaêgên hên apo Israel etaman, ay êmbayro êt ya dinyag na ha labinloway anak na, ya ninuno tamo. ");
INSERT INTO sgb_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Noa, hi apo Jose, ya miha kanlan labinloway anak ni apo Jacob, ay kinahêman lan kaka na. Kabay inhaliw la ya hên mag-in ipoh ha bansan Egipto. Noa, a na yan pinaulayan ni Apo Namalyari, ");
INSERT INTO sgb_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ta pinataniêh na ya ha kaganawan kairapan ya dinanan na. Dinyanan na yan kamwangan hên makilamo, haka kagalingan hên umarap kanan Faraon, ya ari, ya pinakapoon hên bansan Egipto. Kabay dinyanan na yan Faraon hên tungkulan hên mag-in gobernador ha boon bansan Egipto haka mamaala ha kaganawan ya atsi ha bali ni Faraon. ");
INSERT INTO sgb_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Hên gobernador yay na hi Jose hên pitoy taon, ay ayn nanan tumubo ha kaganawan tanaman gawan a nanguran ha pitoy taon ha bansan Egipto haka ha bansan Canaan. Kabay nadanasan lay hadyay kairapan. Ayn hilay nan mapangwaan hên maêkan ya hilay ninuno tamo ha Canaan. ");
INSERT INTO sgb_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Hên namwangan ni apo Jacob ya main awud hên mahaliw ya trigo ha bansan Egipto, ay in-utoh na hilay anak na hên manaliw. Habaytoy unan pammako la bayro, ay a la ya nabalayan hi apo Jose. ");
INSERT INTO sgb_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ha ikalwan oman hên pammako la bayro, ay nagpabalay hi apo Jose kanla. Kabay namwangan hên Faraon ya tungkol ha mipapatêl haka ya toa ni apo Jose. ");
INSERT INTO sgb_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Kabay impauli ni apo Jose ya tatang na, hi apo Jacob, haka hilay kaganawan kamag-anak na, ya pitumpo boy limay katawo. ");
INSERT INTO sgb_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Haka nanugêl hi apo Jacob ha bansan Egipto hên angga ha natsi ya. Hilay maának na ya ninuno tamo ay natsi bayro etaman. ");
INSERT INTO sgb_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ya bangkay la ay in-uli di ha luta tamo ta in-ilbêng ha Siquem ha pay-ilbêngan, ya hinaliw ni apo Abraham hên hato ha maának ni Hamor. ");
INSERT INTO sgb_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Hên marani yay na ya panaon hên panupad ni Apo Namalyari ha pangako na kan apo Abraham ya idin kanlan mag-in kaapo-apoan na ya lutan Canaan, ay kal-atan lay nan ninuno tamo ha Egipto. ");
INSERT INTO sgb_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ya bayon ari ha Egipto hên habaytoy panaon ay a na muwang ya tungkol kan apo Jose. ");
INSERT INTO sgb_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Inutakan haka pinairapan nay ninuno tamo ha pamatoluk na, ya itapon lay bingot ta êmên hila matsi. ");
INSERT INTO sgb_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Hên panaon hên habayto ay in-anak hi apo Moises, ya mihay anak ya bapan mahampat. Hinayhay la ya pon, hên toa na, ha bali la, hên tatloy buwan, ");
INSERT INTO sgb_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","bayo hên in-awah la ya, ay main babayi bayro ya nangwa kana. Hiyay anak hên habaytoy ari. Intad na ya hi apo Moises hên mantêg nan anak. ");
INSERT INTO sgb_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Tinoroan la hi apo Moises ha kamwangan lan taga-Egipto ya manga-talino kabay hiyay nag-in magaling ha pamaghabi haka magaling ha kaganawan dyag. ");
INSERT INTO sgb_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Hên apatapoy taon nay na ni apo Moises, ay naihipan nan hirawên hilay kapareho nan Israelita, ta hêlkên na no hinoy nay angkalyari kanla. ");
INSERT INTO sgb_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Hên atsi yay na bayro, ay nahêlêk na ya mihay kapareho na ya ampairapan hên mihay Egipcio. Hinawpan nay kapareho na, haka ha pamihigantsi na hên kapareho na, ay pinatsi nay hatoy Egipcio. ");
INSERT INTO sgb_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Êndat na no angkaintindihan lan kapareho na ya hiyay pinili ni Apo Namalyari hên mamibuhan kanla ha pangaipoh la. Noa, a la naintindihan. ");
INSERT INTO sgb_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Hên humonoy allo, ay nahêlêk nay loway kapareho na ya ampihuhubakan. Labay na dayi ya makiúmang hila, kabay wana, ‘Patêl, awta ampihuhubak kaw ya parehon Israelita?’ ");
INSERT INTO sgb_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Noa, intolak hi apo Moises hên hatoy namahakit ha kapareho na, ta wana, ‘Yarin main kan tungkulan hên mamaala haka manlingon kannaên! ");
INSERT INTO sgb_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Labay mo kon patsên hên nanad ha pamatsi mo naapon kanan Egipcio!’ ");
INSERT INTO sgb_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Hên pamakagilam ni apo Moises hên habi na, ay nuwayu yan nagtago hên nanugêl ha logal ya ambaêgên Madian. Bayro yan nakapag-ahawa haka nakapag-anak hên loway lalaki. ");
INSERT INTO sgb_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Pangalabah hên apatapo ya taon, ay nagpahlêk kan apo Moises ya mihay anghel ni Apo Namalyari ha dani hên Tawgtug Sinai ha kabalah-balahan, ha mihay naaypa ya poon kayo ya andungkêt. ");
INSERT INTO sgb_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nag-êpapah hi apo Moises ha nahêlêk na. Kaban ampaidani ya ta puliahên na ya, ay nagilam nay habi hên Panginoon, ya wana, ");
INSERT INTO sgb_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Hiko hi Apo Namalyari ya ansimbaên lan ninuno mo, ya hilan Abraham, Isaac haka Jacob.’ Namêgpêg hi apo Moises gawan limo na, haka malimo yan manlêk. ");
INSERT INTO sgb_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Hinabi nay na êt hên Panginoon kana, ya wana, ‘Alihên moy panlatop hên bitsih mo ta luta ko ya habaytsi. ");
INSERT INTO sgb_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Angkahêlêk ko ya hadyay pamairap kanlan pinili ko, ya atsi bayro ha Egipto. Angkagilaman koy pamakiingalo la kangko. Kabay atsi ko bayri hên ibuhan hila. Mako ka di, ta paorongên kata ha Egipto.’” Habayto ya hinabi ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Inhundo ni Esteban ya pamaghabi na, ya wana, “Hi apo Moises ay a tinanggap hên kapareho na hên hinabi la, ya wanla kana, ‘Yarin main kan tungkulan hên mamaala haka manlingon kaso naên!’ Yan hiya êt ya in-utoh ni Apo Namalyari hên mamaala haka mamibuhan kanla ha hawop hên anghel, ya nagpahlêk kana ha naaypa ya poon kayoy andungkêt. ");
INSERT INTO sgb_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Hiya êt ya namaala kanlan kapareho na, ha pag-alíh la ha Egipto ha pamanyag hên kal-atan ya kapapaêpapah bayro ha Egipto, ha Dagat ya nag langan Naorit haka ha apatapo ya taon la ha kabalah-balahan. ");
INSERT INTO sgb_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Hiya êt hi apo Moises ya nag-habi ha kapareho na, ya wana, ‘Hi Apo Namalyari ya mamili hên mihay kapareho tamon Israelita hên mag-in propeta na, hên nanad kangko.’ ");
INSERT INTO sgb_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Hiya êt, hi apo Moises, ya kalamo hên ninuno tamo hên nagtsipon hila ha kabalah-balahan, ya kinahabi hên anghel ha Tawgtug Sinai, ha kabalah-balahan, hên indin kana ya habi ni Apo Namalyari ya ampam-in biyay ya in-intsilga na kantamon kaapo-apoan na. ");
INSERT INTO sgb_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Noa, a la ya hinonol hên ninuno tamo. A la ya tinanggap, ta labay lay na êt hên mag-orong ha Egipto. ");
INSERT INTO sgb_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Hên nabuyotan hi apo Moises bayro ha Tawgtug Sinai, ay kinahabi la ya kaka na, hi Aaron, ya panyag na hilan diyos-diyosan ya mamaala kanla gawan a la muwang no hinoy nalyari kan apo Moises ya nantan kanla hên ubat ha Egipto. ");
INSERT INTO sgb_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kabay nanyag hilan rebulto hên alwan pêtêg ya diyos ya kalupan biseron baka. Pangayari ay nipamatsi hilan ayop ta in-arap la bayro ha rebulto. Nagkaluto hila haka nagpakahigla hila bayro hên nagsimba ha arapan hên habaytoy rebulto ya bat lan dinyag. ");
INSERT INTO sgb_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Gawan bayro, ay tinalibatokan hila ni Apo Namalyari haka na hila pinaulayan hên magsimba ha allo, buwan haka bêtêwên. Bayron natupad ya impahulat ni Apo Namalyari ha mihay mámipamwang hên an-ipaihip kana ni Apo Namalyari, ya wanan hulat, ‘Hikaw ya Israelita, alwan hiko ya pinamatsi yo hên ayop ha apatapo ya taon hên atsi kaw ha kabalah-balahan! ");
INSERT INTO sgb_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ya ampigêgêtan yo ay tolda nan alwan pêtêg hên diyos ya nag langan Moloc, haka ya bêbêtêwênan nan diyos-diyosan Renfan. Yabay ya indukit yo ha kayo haka ansimbaên yo. Kabay paalihên kataw di ta ipalako kataw ha kapatsi yo ha marayo pon ha balayan Babilonia.’” ");
INSERT INTO sgb_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Inhundo ni Esteban ya pamaghabi na, ya wana, “Kala-kalamo lan ninuno tamo ha kabalah-balahan ya Toldan Tsipan ni Apo Namalyari, ya pagsimbaan la kana. Habaytoy palatandaan kanlan ninuno tamo ya a na hila paulayan. Ha panyag lan habaytoy Toldan Tsipan, ay tinoto lay impahlêk ni Apo Namalyari kan apo Moises. ");
INSERT INTO sgb_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Hên natsi hi apo Moises, ta hi apo Josue ya namaala kanlan ninuno tamo, ay gintan lay Toldan Tsipan ni Apo Namalyari di ha Canaan, hên nanugêl hila di, hên panga-ubat lan impaalíh ni Apo Namalyari ya manan ampipaidi bayri. Atsi ya pon di ya habaytoy Toldan Tsipan ni Apo Namalyari, ya pagsimbaan la kana, hên panaon ni Arin David. ");
INSERT INTO sgb_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Hi Arin David ay iningalwan ni Apo Namalyari haka kinotang na kan Apo Namalyari no malyari yan mangipairêng hên paidyanan na, ya mapagsimbaan kana, hên ninuno tamon kaapo-apoan ni apo Jacob. ");
INSERT INTO sgb_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Yan ya anak ni Arin David, hi Arin Solomon ya nakapipairêng hên habayto. ");
INSERT INTO sgb_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Noa, hi Apo Namalyari, ya ayn kapantag, ay a ya ampaidi ha bali ya dyag hên tawo, ta êmên di ya hinulat ni Propeta Isaias, ya wanan hulat, ");
INSERT INTO sgb_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Wanan Panginoon, “Ampamaala ko ha langit haka ha luta. Kabay panyag yo ko man hên bali, ay a ya maipareho ha ampaidyanan ko, ");
INSERT INTO sgb_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","gawan ha hiko ya nanyag hên kaganawan.”’ ” ");
INSERT INTO sgb_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Inhundo ni Esteban ya pamaghabi na, ya wana, “Kakakdêyan ulo yo! Angga amêhên ay nanad kaw kanlan a ampanonol kan Apo Namalyari, ta a yo labay gilamên ya habi na. Nanad kaw hên ninuno yo, ya a hinumonol ha kalabayan hên Espiritu ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Hilay mámipamwang hên an-ipaihip kanla ni Apo Namalyari, ay naubuh hên pinairapan lan ninuno yo! Pinatsi lay in-utoh na ya namipapêt ha pamanlumatêng di hên Mesias, ya Cristo, ya impulong yo bayo impapatsi yo. ");
INSERT INTO sgb_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Hikaw pon êt ya nananggap hên Kautuhan ni Apo Namalyari ya indin lan anghel kanlan ninuno tamo, bayo a yo ya hinonol.” ");
INSERT INTO sgb_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Pamakagilam lan ampamaala ha hinabi ni Esteban, ay hadyay tulaw la. ");
INSERT INTO sgb_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Noa, atsi kan Esteban ya kapangyarihan nan Espiritu ni Apo Namalyari. Naningla ya ha langit haka nahêlêk nay kapahilêw ya kahampatan ni Apo Namalyari ya ayn kapantag. Nahêlêk na êt hi Apo Jesus ya nakairêng ha dapit panabtab ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kabay wana, “Awkêh! Hêlkên yo! Nakaloat ya langit haka nakairêng ya ha dapit panabtab ni Apo Namalyari ya Taga-Langit, ya In-anak Tawo!” ");
INSERT INTO sgb_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tinagpênan lay têkk la ta êndat la no andêmêhên na hi Apo Namalyari. Nipan-angaw hila gawan huluk la, haka piniaagnan la yan dinawhong hi Esteban. ");
INSERT INTO sgb_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Pinigogoluyan la yan paawah ha balayan Jerusalem ta pinagbabato la ya. Hilay tistigos ya naghabin kalaraman ya halanghang kan Esteban, ay namibalag hên takop lay pangkêbêl ha bitsih hên mihay lalaki ya nag langan Saulo. ");
INSERT INTO sgb_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Kaban ampibabatoan la ya, ay ampanalangin ya, hi Esteban, ya wana, “Panginoon Jesus, ipaulay kina kamo ya kaêlwa ko.” ");
INSERT INTO sgb_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Nandoko ya bayo ya nan-angaw hên hadyay hêkaw, ya wana, “Panginoon, patawarên mo hila di ha dinyag la kangko.” Natsi yay na bayto. ");
INSERT INTO sgb_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Hinumigla hi Saulo ha pamatsi la kan Esteban. Paubat ha allon habayton pinatsi hi Esteban, ay pinairapan hilay patêl ha Panginoon ya angkapi-tsi-tsipon ha Jerusalem. Kabay nanga-pitatayak hila ha probinsyan Judea haka ha probinsyan Samaria. Hilay labinloway apostol tana ya nabalag ha Jerusalem. ");
INSERT INTO sgb_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ya bangkay ni Esteban etaman, ay in-ilbêng hên kayêngênan lan mangangêd, ya mapanhumonol ha Kautuhan ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Noa, hi Saulo ay ampakikwanan na hilan pairapan haka ubuhên na hila dayi hên patsên hilay patêl ha Panginoon ya angkapi-tsi-tsipon, ta anhowên-howênên na hila ha binali-bali, ta hinoman ya mahêlêk na kanlan anhumonol kan Apo Jesus, mag-in lalaki o babayi, ay andakpên na hilan angguluyên hên gêtan ha hukulan. ");
INSERT INTO sgb_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Hilay ampaniwala kan Apo Jesus etaman, ay nanga-pitatayak, haka ay idi hila man hên milatêng, ay an-ipamwang lay Mangêd ya Habi tungkol kan Apo Jesu-Cristo. ");
INSERT INTO sgb_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Hi apostol Felipe ay nilumohan ha mihay mahlay ya balayan ya angkasakopan hên Samaria ta impamwang na kanlan atsi bayro ya tungkol kanan Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala. ");
INSERT INTO sgb_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Hên nagilam la ya panoro ni apostol Felipe, haka angkahêlêk lay kapapaêpapah ya andaygên na, ay ginilam lan mangêd ya an-itoro na. ");
INSERT INTO sgb_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Mal-at ya nangarawak ya a angkahêlêk ya hinumapat ha kaatag, ya nipan-angaw hên inumalih hila hên ampaalihên na hila ni apostol Felipe. Kal-atan ya a maigalaw ya lawini, haka kal-atan ya pilay, ya nangaba-tsikwad ya bitsih, ay ampakabitay na. ");
INSERT INTO sgb_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kabay hadyay higla lan ampaidi bayro ha balayan hên Samaria. ");
INSERT INTO sgb_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Noa, main mihay lalaki ya nag langan Simon, ya ampaidi bayro, ya ampaghalumangka paubat hên hato pon. Kabay hilay taga-Samaria ay ampag-êpapah kana. An-ipaglambung na ya hiyay mihay makhaw ya ampamaala. ");
INSERT INTO sgb_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Anggilamên la yan kaganawan taga-Samaria, hilay mangabandi haka hilay mangairap. Ya panabêt la kan Simon, ay hiyay Kapangyarihan hên mihay diyos, ya ambaêgên lan Makhaw. ");
INSERT INTO sgb_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ampaniwal-an la ya gawan nabuyot yay nan ampaghalumangka haka nabuyot hilay nan ampag-êpapah ha andaygên na. ");
INSERT INTO sgb_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Noa, hên naniwala hila ha impamwang kanla ni apostol Felipe ya tungkol ha pamanlokop ni Apo Namalyari, haka ya Mangêd ya Habi tungkol kan Apo Jesu-Cristo, ya Mesias, ay nagpabawtismo hilay lalaki haka babayi ha langan ni Apo Jesu-Cristo. ");
INSERT INTO sgb_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Hi Simon ay naniwala etaman, haka panga-ubat na hên binawtismoan, ay nakilako ya kan apostol Felipe haka ampag-êpapah ya ha kapapaêpapah ya andaygên ni apostol Felipe. ");
INSERT INTO sgb_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Hên nagilam lan apostol ha Jerusalem, ya ampaniwala hilay nay taga-Samaria ha habi ni Apo Namalyari ya intoro ni apostol Felipe, ay in-utoh la hi apostol Pedro haka hi apostol Juan bayro. ");
INSERT INTO sgb_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Paglatêng lan apostol Pedro ay impanalangin la hila bayro ya naniwala kan Apo Jesus ta êmên humapat kanla ya Espiritu ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Dinyag lay habayto gawan ya Espiritu ni Apo Namalyari ay a pon hinumapat kanlan taga-Samaria, ta binawtismoan hilan bat ha langan ni Panginoon Jesus. ");
INSERT INTO sgb_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Impalunto lan apostol Pedro ya gamêt la kanlan nipaniwala kan Apo Jesus, biha hinumapat kanla ya Espiritu ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Hên nahêlêk ni Simon ya kapapaêpapah ya dyag hên Espiritu ni Apo Namalyari ya hinumapat ha pinayluntoan lan gamêt lan apostol, ay in-amlog na kanlan apostol ya pera, ");
INSERT INTO sgb_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ya wana, “Dyanan yo ko etaman hên kapangyarihan, ta êmên hinoman ya paluntoan kon gamêt ay mahapatan hên Espiritu ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Noa, hinabi kana ni apostol Pedro, ya wana, “Hika haka ya pera mo ay mipalako ha impiyerno gawan êndat mon mahaliw moy an-idigalo ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","A na ka dinyanan tungkulan ni Apo Namalyari hên kilamo ha panoro naên gawan alwan usto ya nakêm mo ha arapan na. ");
INSERT INTO sgb_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Paghêhêan haka talibatokan minay pamanyag karawakan, haka ka makiingalon manalangin ha Panginoon ya dayi ay patawarên ka ha karawakan ya an-ihipên mo. ");
INSERT INTO sgb_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ta angkahêlêk ko ya gawan hadyay kahêm mo ay anhumahakit ya nakêm mo, haka a ka makaalíh ha pangaipoh mo ha pamanyag kasalanan.” ");
INSERT INTO sgb_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Hinabi ni Simon kanlan apostol Pedro, ya wana, “Ampakihabi ko awud kamoyu ya ihalangin yo ko ha Panginoon, ta êmên ko a maranasan ya hatoy hinabi yo kangko!” ");
INSERT INTO sgb_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pangayari lan nanoro hên Mangangêd ya Habi ya nagilam la kan Panginoon Jesus, haka namaptêg ha nahêlêk la hên hiyay kalamo la, ay nag-orong hila ha Jerusalem hi apostol Pedro haka hi apostol Juan. Ha pag-orong la ay an-ipamwang lay Mangêd ya Habi tungkol kan Apo Jesu-Cristo ha kal-atan baryo ha probinsyan Samaria. ");
INSERT INTO sgb_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Hi Felipe etaman, ay main mihay anghel hên Panginoon ya naghabi kana, ya wana, “Tampol kan magtagloh ha dapit timog ha dann ha kabalah-balahan ya angkaubat ha Jerusalem ha palako ha balayan Gaza.” ");
INSERT INTO sgb_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Tampol yan nammita hi Felipe. Kaban atsi ya ha dann, ay nahêlêk nay mihay pinagtsiwal-an hên poon lan bansan Etiopia, ya reyna o Candace. Habaytoy pinagtsiwal-an, ay ampamaala ha kaganawan pibandian nan habaytoy reyna. Angkaubat ya ha Jerusalem ta nagsimba ya kan Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Pauli yay na hên habayto hên nakahakay ha kalesa. Ambahaên nay habi ni Apo Namalyari ya inhulat ni Propeta Isaias, ya mihay mámipamwang hên an-ipaihip kana ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Hinabi nan Espiritu ni Apo Namalyari kan apostol Felipe, ya wana, “Pakarani ka ha anhakyan nan habain haka makipantag ka kana.” ");
INSERT INTO sgb_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Nuwayun nagpakarani hi apostol Felipe haka ya nanggilam hên inhulat ni Propeta Isaias, ya ambahaên hên hatoy pinagtsiwal-an. Kinotang na ya, “Angkaintindihan moy habain ya ambahaên mo?” ");
INSERT INTO sgb_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Wanan pinatsiwal-an, “Ay-êmên kon maintindihan ya habaytsi no ayn mamipamulah kangko?” Hinagyat na hi apostol Felipe hên mikno ha dani na. ");
INSERT INTO sgb_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Habaytoy Kahulatan ya ambahaên na ay impahulat ni Apo Namalyari kanan mihay mámipamwang na ya hi Propeta Isaias. Êmên ya di: “Hiyay nanad tupa ya anggêtan ha paypatsan, nanad ya êt hên biseron tupa ya ayn labak kaban an-orogan. Pinaulayan na hila. ");
INSERT INTO sgb_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Hiyay minusmus haka impakarêng-êy. Intad la yan ayn karapatan. Ayn yan kaapo-apoan, ta pinaipêk lay biyay na di ha luta.” ");
INSERT INTO sgb_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Hinabi nan pinatsiwal-an kan apostol Felipe, ya wana, “Ipalinaw mo raw kangko no hinoy an-ungkatên nan mámipamwang ni Apo Namalyari, ha binasa ko, ya sarili na, o kaatag?” ");
INSERT INTO sgb_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Impalinaw ni apostol Felipe, ya tungkol kan Apo Jesus ya habayto. Ya hiyay Mámiligtas ya an-êngganan la, ya nilumatêng. Biha impalinaw na êt kana ya kaatag pon ya tungkol ha Mangêd ya Habi. ");
INSERT INTO sgb_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ha pamammita la ay nilatêng hila ha mihay logal ya nag lanêm. Kabay wanan pinatsiwal-an, “Main lanêm di. Malyari mikinan bawtismoan?” ");
INSERT INTO sgb_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","(Hinabi kana ni apostol Felipe, ya wana, “Malyari, no ampaniwala kan boon nakêm.” Naghabi ya etaman, “Ampaniwala ko ya hi Apo Jesu-Cristo ay anak ni Apo Namalyari.”) ");
INSERT INTO sgb_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Pinatêgên nan pinatsiwal-an ya kalesa, ta nunaoy hila hên nilumohan ha lanêm, ta binawtismoan na ya ni apostol Felipe. ");
INSERT INTO sgb_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Pag-alíh la ha lanêm, ay kingwa hi apostol Felipe hên Espiritu ni Apo Namalyari. Paubat hên habayto ay a yay na nahêlêk hên hatoy pinatsiwal-an. Êmbayro man, ay inhundoy nay pamammita na hên hadyay higla. ");
INSERT INTO sgb_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Hi apostol Felipe etaman, ay namwangan na ya hiyay gintan hên Espiritu ni Apo Namalyari ha balayan Azoto. Paubat bayro ay impamwang nay Mangêd ya Habi tungkol kan Apo Jesu-Cristo ha balang balayan ya angkadanan na, angga ha niabot ya ha balayan Cesarea. ");
INSERT INTO sgb_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Kanan habayto, ay pan-ihundo ni Saulo ya pamalimo haka pamatsi na kanlan ampaniwala ha Panginoon. Dinumani ya ha pinakapoon pari, ");
INSERT INTO sgb_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ta nakikwa yan kahulatan ya main yan tungkulan hên humwên ha hinoman ya sinagoga ha balayan Damasco, ta êmên na hila dakpên hên gapohên, hên gêtan ha Jerusalem ya hilay ampaniwala ha toro ni Panginoon Jesu-Cristo, mag-in lalaki o babayi. ");
INSERT INTO sgb_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ha pammita na, hên narani yay na ha Damasco, ay namakonkaynaman, ay main kapahilêw ya ubat ha langit ya nakapalibot kana. ");
INSERT INTO sgb_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Nihubhub ya ha luta, biha main yan nagilam ya naghabi kana, ya wana, “Saulo, Saulo! Awta ampairapan mo ko?” ");
INSERT INTO sgb_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Kabay nangotang etaman hi Saulo, “Hino ka, Panginoon?” “Hiko hi Jesus, ya ampairapan mo.” wanan habi. ");
INSERT INTO sgb_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“Mirêng ka haka pakha ka ha balayan Damasco, ta habiên la kamo bayro ya dapat mon daygên.” ");
INSERT INTO sgb_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nakatsigag hilay kalamo ni Saulo. Nagilam lay habi noa, ayn hilan mahêlêk. ");
INSERT INTO sgb_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Nirêng hi Saulo, haka immukat nay mata na, noa, a yay nan makahêlêk. Kabay inakay la ya tana hên palako ha Damasco. ");
INSERT INTO sgb_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tatloy allo yan a ampakahêlêk. A ya êt nangan haka ninêm. ");
INSERT INTO sgb_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Bayro ha Damasco ay main mihay ampaniwala kan Apo Jesus ya nag langan Ananias. Kinahabi yan Panginoon ha pahalumata, ya wana, “Ananias!” Kabay naghabi hi Ananias, ya wana, “Hino awud ya habayto Panginoon?” ");
INSERT INTO sgb_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Wanan Panginoon kan Ananias, “Magtagloh ka ha bali ni Judas, bayro ha dann ya ambaêgên lan Matoynung, ta ikotang mo ya mihay lalaki ya taga-Tarso. Ya langan na ay Saulo, hiyay ampanalangin amêhên. ");
INSERT INTO sgb_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ha mihay pahalumata, ay nahêlêk na ka hên anhumwên ha ampaidyanan na bayo impalunto moy gamêt mo kana ta êmên ya makahêlêk.” ");
INSERT INTO sgb_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Noa, hinabi ni Ananias, ya wana, “Panginoon, mal-at ya namihumbung kangko hên tungkol kanan habain, haka tungkol ha pamarusa na kanlan ampaniwala kamo ha Jerusalem. ");
INSERT INTO sgb_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Haka atsi ya di ha Damasco hên main tungkulan ya naubat kanlan ampamaala kanlan pari hên dakpên na hilay ampagsimba kamo.” Habaytoy hinabi ni Ananias. ");
INSERT INTO sgb_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Noa, wanan Panginoon kana, “Êmbayro man, ay lakwên mo ya, ta hiya ya pinili ko hên mamipamwang hên tungkol kangko, kanlan alwan Israelita haka kanlan poon la, haka kamoyun Israelita. ");
INSERT INTO sgb_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Hikoy mamipamwang kana hên kal-atan ya kairapan ya dapat nan têêhên ta êmên maipamwang ya tungkol kangko.” ");
INSERT INTO sgb_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Kabay nammita yay na hi Ananias ta hinumwên ya ha andyanan ni Saulo. Impalunto nay gamêt na kana ta wana kan Saulo, “Patêl, in-utoh na ko ni Panginoon Jesus, ya nagpahlêk kamo ha dann hên palako ka bayri. In-utoh na ko bayri ta êmên ka makahêlêk oman, haka ka mahapatan hên Epiritu ni Apo Namalyari hên main kapangyarihan.” ");
INSERT INTO sgb_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Namakonkaynaman ay main natata ya nanad hikhik hên kênan lanêm ya naubat ha mata ni Saulo, haka yay na nakahêlêk. Nirêng yay na, ta tampol yay nan nagpabawtismo. ");
INSERT INTO sgb_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Pangayari, ay nangan yay na haka nag-orong ya hêkaw na. Nanugêl ya bayro ha Damasco hi Saulo hên ungnoy allo kanlan ampaniwala kan Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tampol nan impamwang ha mal-at ya sinagoga, ya hi Apo Jesus, ay Anak ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ampag-êpapah hilay kal-atan ya ampakagilam hên panoro na. Hinabi la, “Hiyay namairap kanlan nipaniwala kan Apo Jesus ha Jerusalem. Haka atsi ya di ha Damasco hên main tungkulan ya naubat kanlan ampamaala kanlan pari ha Jerusalem hên gapohên na hilay ampagsimba kan Apo Jesus hên gêtan hila ha arapan la ha Jerusalem.” ");
INSERT INTO sgb_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Noa, lalon hinumkaw ya nakêm ni Saulo haka hiyay nag-in magaling ha pamaptêg na hên tungkol kan Apo Jesus, ya hiyay Cristo, ya impangakon Mámiligtas, ya pinili ni Apo Namalyari hên mamaala, ya an-êngganan la. Kabay hilay Israelita bayro ha Damasco, ya anhumalanghang kan Saulo, ay ayn mahabi kana. ");
INSERT INTO sgb_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Hên nakalabah ya ungnoy allo, ay pinulong la yan poon lan Israelita. ");
INSERT INTO sgb_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Allo-yabi, ay nakal-an hilan manambang kana ha paawah ha balayan, ta labay la yan patsên. Noa, namwangan ni Saulo ya habayto. ");
INSERT INTO sgb_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kabay mihay yabi ay pinaikno la hi Saulo ha mahlay ya lubon hên hilay nahagyat nan maniwala kan Apo Jesus, ta in-antotoh la ya ha paka hên matag-ay ya bakod hên Damasco, ta êmên ya makatakah ha namulong kana. ");
INSERT INTO sgb_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Paglatêng ni Saulo ha Jerusalem, ay labay na dayi hên makilamo kanlan ampaniwala kan Apo Jesus. Noa, nalimwan hila kana, ta a hila maniwala ya ampaniwala yay na etaman kan Apo Jesus, hi Saulo. ");
INSERT INTO sgb_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Noa, nilamoan na ya ni Bernabe kanlan apostol. Ta impamulah na kanla no ay-êmên nan nahêlêk ni Saulo ya Panginoon, hên atsi ya ha dann. Hinabi na êt ni Bernabe kanla ya kakhawan nakêm ni Saulo hên namipamwang hên tungkol kan Apo Jesus ha Damasco. ");
INSERT INTO sgb_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Paubat hên habayto, ay kala-kalamo la yay na hi Saulo hên ampanoro ha Jerusalem. Kakhawan nakêm na hên ampanoro hên tungkol kan Panginoon Jesus. ");
INSERT INTO sgb_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Main êt bayro hên Israelita ya ampaghabin Griego. Hi Saulo ay nakihabi kanla, haka nakihubakan ya kanla, kabay labay la yan patsên. ");
INSERT INTO sgb_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Hên namwangan lan ampaniwala kan Apo Jesus ya labay la yan patsên, ay in-atêl la ya hi Saulo ha balayan Cesarea, haka la ya pinabita ha balayan hên Tarso. ");
INSERT INTO sgb_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Gawan êmbayroy nalyari, ay tinunggên pon ya gulo ha boon probinsyan Judea, probinsyan Galilea, haka ha probinsyan Samaria, kabay main pon kapatêkbêkan hilay patêl ha Panginoon ya angkapi-tsi-tsipon. Angkapahanan hila, haka antumaniêh ya paniwala la gawan ha hawop hên Espiritu ni Apo Namalyari, haka gawan ha ampamiyay hila hên main galang ha Panginoon. ");
INSERT INTO sgb_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Hi apostol Pedro etaman, ha pamanlumagay na hên maniraw kanlan ampaniwala kan Panginoon Jesu-Cristo, ay hiniraw na hilay ampaniwala ha balayan Lida. ");
INSERT INTO sgb_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Bayro nan nahêlêk ya mihay lalaki ya nag langan Eneas, ya nakakatuloy hên waloy taon gawan nalumpo ya. ");
INSERT INTO sgb_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Wani apostol Pedro kana, “Eneas, inalíh ni Panginoon Jesu-Cristo ya hakit mo. Mirêng ka ta ikumpini minay angkatuluyan mo.” Tampol yan nirêng etaman. ");
INSERT INTO sgb_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Kaganawan lan atsi bayro ha balayan Lida haka hilay taga patal Saron, ay nakahêlêk kan Eneas ya ampakabitay na, kabay naniwala hila ha Panginoon. ");
INSERT INTO sgb_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ha balayan Jope ay main mihay babayi ya hi Tabita ya ampaniwala kan Apo Jesus. Ya langan na ha habin Griego ay Dorcas, ya labay habiên oyha. An-iubuh nay panaon na ha pamanyag hên kangêran, ta anhawpan nay mangairap. ");
INSERT INTO sgb_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Kanan habayto ay nagkahakit ya haka natsi. Pinunahan lay bangkay na ta in-unik lay na ha mihay kuwarto ha tag-ay. ");
INSERT INTO sgb_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Napidani ya balayan Jope haka ya balayan Lida, kabay hên nabalit-an lan ampaniwala kan Apo Jesus ha Jope, ya atsi ya ha Lida hi apostol Pedro, ay namiutoh hilan loway lalaki ya makihabi ya tampol yan maniraw ha Jope. ");
INSERT INTO sgb_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Nakilako ya etaman kanla. Panlumatêng la bayro ay gintan la ya ha kuwarto ya nag bangkay. Hilay babayi ya bawo, ay naubuh hên ampanangih gawan natsi ya hi Dorcas, ay napaidani kan apostol Pedro ta impakit la kana ya takop la, ya tinayi na hên haton angkabiyay ya pon. ");
INSERT INTO sgb_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","In-ubuh na hilan pinaawah ni apostol Pedro ta nandoko yan nanalangin. Pangayari ay inarap nay bangkay ni Tabita, ta wana, “Tabita, mimata ka!” Tampol nan immukat ya mata na ni Tabita. Hên nahêlêk na hi apostol Pedro, ay nikno yay na. ");
INSERT INTO sgb_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Tinalan ni apostol Pedro ya gamêt na, ta hinawpan na yan mirêng. Bayo binaêg na hilay ampaniwala kan Apo Jesus, kalamo hilay bawo ta in-arap na ya kanla hi Dorcas, ya biniyay oman. ");
INSERT INTO sgb_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Habaytsi ya nalyari ay namwangan ha boon Jope, kabay mal-at ya naniwala ha Panginoon. ");
INSERT INTO sgb_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Hi apostol Pedro ay nabuyot hên nanugêl ha Jope ha bali ni Simon, ya máy-il-an hên balat ayop ta daygên hên hino-hino kay na hên ya dyag. ");
INSERT INTO sgb_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ha balayan Cesarea ay main lalaki ya nag langan Cornelio. Hiya ay kapitan hên hundaloh ya taga-Roma. Ya baêg kanlan pangkat na, ay hundalon Italia. ");
INSERT INTO sgb_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Maka-Diyos hi Cornelio. Hiya haka hilay kaganawan kalamo na ha bali na ay ampagsimba kan Apo Namalyari. Panay yan ampanalangin, haka ampanawop kanlan Israelita ya mangairap. ");
INSERT INTO sgb_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Mihay maapon hên mag-aalas tres, ay nakahalumata yan mihay anghel ni Apo Namalyari ya hinumwên ha bali na, ya wana, “Cornelio!” ");
INSERT INTO sgb_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Hadyay limo nan ampamakapopoh hên naghabi, ya wana, “Hino ya habayto, Panginoon?” Wanan anghel, “Ginilam ni Apo Namalyari ya panalangin mo kana, haka nahêlêk nay pamanawop mo ha mangairap. ");
INSERT INTO sgb_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Mamiutoh ka amêhên hên ungnoy lalaki ha balayan Jope, ta alapên la ya mihay lalaki ya nag langan Simon Pedro. ");
INSERT INTO sgb_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Atsi ya bayro ha bali ni Simon, ya mihay máy-il-an hên balat ayop, ta daygên hên hino-hino kay na hên ya dyag. Ya bali na ay atsi ha laylay hên dagat.” ");
INSERT INTO sgb_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Pamakaalíh hên anghel, ay binaêg ni Cornelio ya lowa kanlan ampaghuyo kana, haka mihay hundaloh na ya kapareho nan maka-Diyos. ");
INSERT INTO sgb_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Impamwang na kanla ya nalyari, bayo in-utoh na hila ha balayan Jope. ");
INSERT INTO sgb_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Hên humonoy allo, hên mag-uugtoy na, ay atsi hilay na ha dann ya pahowên ha Jope. Hi apostol Pedro etaman, ay nunik ha napatal ya bubungan bali ta manalangin. ");
INSERT INTO sgb_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kaban ampanluto hilay kalamo na, ay matsi yay nan lonoh, haka nakahalumata ya. ");
INSERT INTO sgb_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Nahêlêk nay langit ya nagloat, biha main yan nahêlêk ya nanad mahlay ya uwêh ya an-i-antotoh ha luta ya nakabitsin ha apat ya duyo. ");
INSERT INTO sgb_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Atsi bayro ya hinon bawal lan kênaên hên hilay Israelita. Main hino-hino kay na hên ya mahlay ya ayop, boy ya nanad ha utan, haka ya kaatag ya manok lalê ya imbawal kanla. ");
INSERT INTO sgb_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Nagilam nay habi ya wana, “Mirêng ka, Pedro. Mamatsi kan kênaên mo!” ");
INSERT INTO sgb_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Noa, wani apostol Pedro, ya wana, “Panginoon, a ko madyag ya habain. A ko êt nangan hên imbawal kannaên Israelita.” ");
INSERT INTO sgb_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Nagilam nay na êt oman ya naghabi kana, ya wana, “Alwa minan itad hên bawal, ya maêkan, ya a nay nan an-ibawal ni Apo Namalyari.” ");
INSERT INTO sgb_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Katatlon nagilam haka nahêlêk ni apostol Pedro ya habayto. Pangayari, ay nagtag-ay ha langit ya habaytoy nanad uwêh ya nakaantotoh. ");
INSERT INTO sgb_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Hên ampapakaihipên ni apostol Pedro ya nahalumata na, ay lumatêng hilay in-utoh ni Cornelio ta namwangan lay nay bali ni Simon, ya máy-il-an hên balat ayop. ");
INSERT INTO sgb_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Namaêg hila, ya wanla, “Main ampanugêl di ya nag langan Simon Pedro?” ");
INSERT INTO sgb_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ampapakaihipên na pon ni apostol Pedro ya labay habiên hên nahalumata na hên hinabi kana hên Espiritu ni Apo Namalyari, ya wana, “Main tatloy lalaki di ya ampanapol kamo. ");
INSERT INTO sgb_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Kabay magtaoy kay na ta paan kan mag-alangan hên kilako kanla ta hiko ya namiutoh kanla.” ");
INSERT INTO sgb_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Kabay nagtaoy hi Pedro ta hinabi na kanlan ampanapol kana, ya wana, “Hiko ya antapolên yo. Hinoy maihawop ko kamoyu?” ");
INSERT INTO sgb_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","“In-utoh kay di ni Kapitan Cornelio. Hiyay ampagsimba boy mahonol kan Apo Namalyari, haka hiyay anggalangên lan Israelita. Kinahabi yan mihay anghel ni Apo Namalyari ya ipaalap na ka, ta êmên na magilaman ya pamipamwang mo.” ");
INSERT INTO sgb_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pinahowên na hila ni Pedro ha lalên bali. Hinagyat na hila hên matuloy bayro hên yabin habayto. Hên humonoy allo, ay nakilako yay na kanla. Nakilako hila etaman kanla ya ungnoy ampaniwala kan Apo Jesus ya taga-Jope. ");
INSERT INTO sgb_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Hên humonoy allo, ay nilumatêng hilan Pedro ha balayan Cesarea. Ampangênggan ana hi Cornelio, hilay kamag-anak ni Cornelio, haka hilay mantêg kabalay ni Cornelio, ya hinagyat na. ");
INSERT INTO sgb_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Hên anhumwên dayi hi apostol Pedro ay tinupa ya ni Cornelio, hên nanlokob ha arapan ni apostol Pedro ta simbaên na ya dayi. ");
INSERT INTO sgb_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Noa, hinabi ni apostol Pedro kana, ya wana, “Mirêng ka. Paan mo kon simbaên ta tawo kon bêngat.” ");
INSERT INTO sgb_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Hên an-ihundo lay pamihabi la hên pahowên ha bali, ay nahêlêk ni apostol Pedro ya kal-atan tawo ya naka-tsipon bayro. ");
INSERT INTO sgb_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Wana kanla, “Muwang yoy na ya bawal ha Kautuhan naên Israelita hên makilamo o maniraw ha alwan Israelita. Noa, impamwang na kangko ni Apo Namalyari ya hinoman ay paan kon itad hên narêmêk. ");
INSERT INTO sgb_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kabay hên impalako yo ko, ay a ko nag-alangan hên nakilako. Haka labay kon mamwangan no awta impaalap yo ko.” ");
INSERT INTO sgb_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kabay hinabi ni Cornelio, ya wana, “Main nanan apat ya allo, ha êmên di êt ya oras hên mag-aalas tres hên maapon, hên ampanalangin ako bayri ha bali ko, ay namakonkaynaman, ay main nirêng ha arapan ko ya mihay lalaki ya nakatakop hên ampakahilêw. ");
INSERT INTO sgb_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Hinabi na kangko, ya wana, ‘Cornelio! Ginilam ni Apo Namalyari ya panalangin mo kana, haka nahêlêk nay panawop mo kanlan mangairap. ");
INSERT INTO sgb_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Mamiutoh kan ungnoy lalaki ha balayan Jope ta alapên la ya mihay lalaki ya nag langan Simon Pedro. Atsi ya bayro ha bali ni Simon, ya mihay máy-il-an hên balat ayop ta daygên hên hino-hino kay na hên ya dyag. Ya bali na ay atsi ha laylay hên dagat.’ ");
INSERT INTO sgb_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kabay tampol katan impaalap. Halamat etaman ta nakilako ka bayri. Naka-tsipon kay di ha hêlêk ni Apo Namalyari, ta êmên naên pakagilamên ya impahabi hên Panginoon kamo.” ");
INSERT INTO sgb_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Nanoro yay na hi apostol Pedro, ya wana, “Muwang kinan taganán pêtêg ya pamanlêk ni Apo Namalyari ha tawo ay pantag. ");
INSERT INTO sgb_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Anlugurên nay hinoman ya main limo kana haka ampanyag hên kalabayan na, kaapo-apoan man ni apo Israel o alwa. ");
INSERT INTO sgb_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Muwang yoy na ya Mangêd ya Habi, ya impamwang nay na kannaên Israelita ya tungkol ha pamakiúmang tamo kana gawan kan Apo Jesu-Cristo, ya Panginoon hên balang miha. ");
INSERT INTO sgb_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Muwang yo etaman ya nalyari ha boon probinsyan Judea, paubat ha probinsyan Galilea hên namipamwang hi Juan Bautista hên tungkol ha pamawtismo. ");
INSERT INTO sgb_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Muwang yo etaman ya tungkol kan Apo Jesus ya taga-Nazaret. Impahapat ni Apo Namalyari kana ya Espiritu na haka kapangyarihan na. Nammita ya ha ay-iri man ya logal, hên ampanyag hên panay kangêran. Gawan atsi kana hi Apo Namalyari ay ampaalihên na etaman hi Satanas, ya ampamairap kanlan kaatag. ");
INSERT INTO sgb_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Hikay ya apostol ni Panginoon Jesu-Cristo, ay ampamaptêg ha kaganawan kapapaêpapah ya dinyag na, ha logal naên ha Jerusalem, haka ha kaatag êt ya balayan ha Israel. Êmbayro man, ay impapatsi la yan impako ha koros. ");
INSERT INTO sgb_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Noa, hên nalabah ya tatloy allo, ay biniyay yan oman ni Apo Namalyari, haka ya nagpahlêk kannaên. ");
INSERT INTO sgb_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Hikay ay nakaaêm na hên biniyay yan oman ni Apo Namalyari. A ya nagpahlêk ha kal-atan, noa, kannaên bat hên pinili ni Apo Namalyari hên mamaptêg ya nabiyay yan oman hi Apo Jesus. ");
INSERT INTO sgb_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Hikay ya in-utoh na hên maypamwang hên Mangangêd ya Habi tungkol kana, haka hên mamaptêg ya hiyay pinili ni Apo Namalyari hên manatol kanlan natsi haka kanlan angkabiyay, ha lumatêng ya allo. ");
INSERT INTO sgb_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Hiyay impamwang lan mámipamwang hên an-ipaihip kanla ni Apo Namalyari, hên haton lagi. Impapêt la, ya mapatawad ya kasalanan lan maniwala kana gawan ha kapangyarihan na.” ");
INSERT INTO sgb_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Kaban ampaghabi ya pon hi apostol Pedro, ay hinumapat ya Espiritu ni Apo Namalyari kanlan Cornelio ya ampanggilam hên toro na. ");
INSERT INTO sgb_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Nipag-êpapah hilay Israelita ya taga-Jope, ya ampaniwalay na kan Apo Jesus, ya kalamo ni apostol Pedro, no awta hinumapat ya Espiritu ni Apo Namalyari kanlan Cornelio, ya alwan Israelita. ");
INSERT INTO sgb_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Muwang lay habayto, ta nagilam la hilan Cornelio hên ampaghabi hên hino-hino kay na hên ya habi, ya a la muwang, ha pamagpuri la kan Apo Namalyari. Kabay hinabi ni apostol Pedro, ya wana, ");
INSERT INTO sgb_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Hinumapat kanlay Espiritu ni Apo Namalyari hên nanad ha nalyari kannaên hên Israelita. Yarin a hila mabawtismoan agyan alwa hilan Israelita!” ");
INSERT INTO sgb_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Biha in-utoh ni apostol Pedro ya bawtismoan hilan Cornelio ha langan ni Panginoon Jesu-Cristo. Pangayari ay pinakihabi lan Cornelio kan apostol Pedro ya paidi ya pon bayro hên ungnoy allo. ");
INSERT INTO sgb_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Namwangan lan apostol haka hilay kaatag ya ampaniwala kan Panginoon Jesu-Cristo ha probinsyan Judea, ya hilay alwan Israelita, ay ampaniwalay na ha habi ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Hên nag-orong hi apostol Pedro ha Jerusalem, hinabyanan la yan kapareho nan Israelita. An-ipalêkpêk la ya dapat patuli hilay ampaniwala kan Panginoon Jesu-Cristo, no labay la hên madyanan hilan biyay ya ayn angga. ");
INSERT INTO sgb_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Hinabi la kan apostol Pedro, ya wanla, “Hinumwên ka ha bali lan alwan Israelita, haka nakiaêm ka êt kanla!” ");
INSERT INTO sgb_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Kabay impamwang na kanla ya nalyari paubat hên nakahalumata yan hatoy nanad uwêh kaban ampanalangin ya. ");
INSERT INTO sgb_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Wana kanla, “Hên atsi ko ha Jope hên ampanalangin, ay nakahalumata ko. Nakahêlêk akon nanad mahlay ya uwêh ya nakabitsin ha apat ya duyo ya an-i-antotoh ha dani ko, ya ubat ha langit. ");
INSERT INTO sgb_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Pinakapopoh ko yan mangêd ya habayto bayo nahêlêk ko bayro ya kaganawan ayop ya bawal tamon kênaên hên hikitamoy Israelita. Main bayro hên mahlay ya ayop haka ya nanad ha utan haka ya kaatag ya manok lalê ya bawal kantamo. ");
INSERT INTO sgb_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nagilam koy habi, ya wana, ‘Mirêng ka, Pedro. Mamatsi kan kênaên mo!’ ");
INSERT INTO sgb_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Noa, wangko, ‘Panginoon, a ko madyag ya habain. A ko êt nangan hên bawal kannaên Israelita.’ ");
INSERT INTO sgb_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Nagilam kina êt oman ya habi ya ubat ha langit, ya wana, ‘Alwa minan itad hên bawal, ya maêkan ya a nay nan an-ibawal ni Apo Namalyari.’ ");
INSERT INTO sgb_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Katatlon oman nalyari ya habayto. Pangayari, ay ginuloy ya habaytoy nanad uwêh hên patag-ay ha langit. ");
INSERT INTO sgb_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Kanan habayto, ay main nilumatêng ha bali ya andyanan ko, ya tatloy lalaki ya in-utoh ni Cornelio, ya mihay alwan Israelita, ya ampaidi ha Cesarea. ");
INSERT INTO sgb_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Hinabi nan Espiritu ni Apo Namalyari ya paan akon mampotog hên kilako kanla, agyan alwa hilan Israelita. Main etaman anêm ya patêl ha Panginoon ya taga-Jope, ya nakilamo kangkon palakon Cesarea, haka hikay ay hinumwên ha bali lan Cornelio. ");
INSERT INTO sgb_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Hinabi ni Cornelio kannaên ya nakahêlêk yan anghel ha bali na, ya wana kana, ‘Mamiutoh kan mangalap hên mihay lalaki ya nag langan Simon Pedro ha balayan Jope. ");
INSERT INTO sgb_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Habiên na kamoyu no ay-êmên mailigtas ha parusa ya ayn anggaan ya kaganawan ya atsi ha bali mo.’ ");
INSERT INTO sgb_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Hên nag-umpisa kon naghabi kanla, ay hinumapat kanla ya Espiritu ni Apo Namalyari, hên nanad êt ha panhumapat na kantamo hên haton una. ");
INSERT INTO sgb_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Napanêmtêman ko bayto ya hinabi ni Panginoon Jesu-Cristo, ya wana, ‘Lanêm ya ginamit ni Juan hên namawtismo ya. Noa, hikaw ay bawtismoan ha Espiritu ni Apo Namalyari ya ipahapat na kamoyu.’ ");
INSERT INTO sgb_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","No impahapat ni Apo Namalyari ya Espiritu na kanla, hên nanad ha impahapat na kantamo, hên babayo kitamo hên naniwala kan Panginoon Jesu-Cristo, ay ayn akon tungkulan hên manalanghang kan Apo Namalyari!” Habayto ya hinabi ni apostol Pedro. ");
INSERT INTO sgb_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Hên nagilam lay hinabi na, ay intêgên lay pamamintas la kana, ta nagpuri hilay na kan Apo Namalyari, ya wanla, “No êmbayro awud, ay dinyanan ni Apo Namalyari ya alwan Israelita, hên panaon, hên maghêhê ha kasalanan la, ta êmên hila madyanan hên biyay ya ayn angga hên kalamo na.” ");
INSERT INTO sgb_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Paubat hên haton pinatsi hi Esteban, ay hilay ampaniwala kan Panginoon Jesus ay nanga-pitatayak gawan ha hadyay pamairap kanla. Main nipalako ha probinsyan Fenicia, ha Chipre, haka ha balayan Antioquia. Ay-iri hila man hên nilatêng, ay impamwang lay Mangêd ya Habi tungkol kan Panginoon Jesus. Noa, intoro lan bat ya habayto, kanlan Israelita. ");
INSERT INTO sgb_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Noa, kalamo la hilay kaatag ya ampaniwala kan Panginoon Jesus, ya taga-Chipre haka ya taga-balayan Cirene, ya namipamwang hên Mangêd ya Habi tungkol kan Panginoon Jesus kanlan Griego hên nilumatêng hila ha Antioquia. ");
INSERT INTO sgb_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Atsi kanlan nanoro ya kapangyarihan hên Panginoon, kabay mal-at ya naniwala kana. ");
INSERT INTO sgb_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Namwangan lan patêl ha Panginoon ya angkapi-tsi-tsipon ha Jerusalem, ya angkalyari ha Antioquia. Kabay in-utoh la hi Bernabe hên maniraw ha Antioquia. ");
INSERT INTO sgb_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Hên nilatêng bayro hi Bernabe, ay nahêlêk nay iningalwan ni Apo Namalyari ya hilay taga-Antioquia. Hiyay bapan higla. Inaralan na hila ya ihundo lay paniwala la kan Panginoon Jesus hinoman ya malyari. ");
INSERT INTO sgb_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Gawan mangêd ya hi Bernabe, haka ampamiyay ya ha kapangyarihan hên Espiritu ni Apo Namalyari, haka makhaw ya paniwala na, ay mal-at êt ya naniwala ha Panginoon. ");
INSERT INTO sgb_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Pamakayari, ay nagtagloh hi Bernabe ha balayan Tarso, ta tapolên na hi Saulo. ");
INSERT INTO sgb_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Hên natapol na ya, ay pinagkalamo na ya ha Antioquia. Nanugêl hila bayro hên mihay taon hên kala-kalamo la hilay patêl ha Panginoon ya angkapi-tsi-tsipon. Nanoro hila ha kal-atan. Bayro ha balayan Antioquia, ay kauna-unaan hilan binaêg hên Cristiano, ya hilay ampaniwala kan Panginoon Jesus. ");
INSERT INTO sgb_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Kanan habayto, ay main ungnoy mámipamwang hên an-ipaihip kanla ni Apo Namalyari, ya nilumatêng ha balayan hên Antioquia ya naubat ha Jerusalem. ");
INSERT INTO sgb_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ha kapangyarihan hên Espiritu ni Apo Namalyari ay nirêng ya miha kanla ya nag langan Agabo, ta impamwang nay magkamain hadyay lonoh ha boon luta. (Natupad ya hatsi hên haton ampamaala ya pon hi Emperador Claudio.) ");
INSERT INTO sgb_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Tinalagá lan ampaniwala kan Apo Jesus hên mamagtan hên agyu lan maihawop kanlan patêl ha Panginoon ya ampaidi ha probinsyan Judea. ");
INSERT INTO sgb_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Êmbayro ya dinyag la, haka la impagtan ya habayto kanlan Bernabe boy Saulo ta indin la etaman kanlan toa ya ampamaala ha patêl ha Panginoon ya angkapi-tsi-tsipon ha Jerusalem. ");
INSERT INTO sgb_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Kanan habayto, ay ampairapan ni Arin Herodes ya kaatag kanlan patêl ha Panginoon ya angkapi-tsi-tsipon. ");
INSERT INTO sgb_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Impapotoh nay ulo ni apostol Santiago ya kapotoh pohêl ni apostol Juan. ");
INSERT INTO sgb_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Hên nahêlêk ni Arin Herodes, ya hinumigla hilay Israelita ha pamamatsi kan apostol Santiago, ay impadakêp na etaman hi apostol Pedro. (Nalyari ya habayto hên Pistan Puto ya ayn Pampaalsa.) ");
INSERT INTO sgb_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pamakadakêp la kan apostol Pedro, ay impahukul la ya, haka impabantay kanlan hundaloh hên apat ya pangkat, ya main mani apat ya hundaloh. Naihipan ni Arin Herodes, ya iarap na yan lingonên hi apostol Pedro kanlan kal-atan, pangayarin pista. ");
INSERT INTO sgb_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kaban atsi ya ha hukulan hi apostol Pedro, ay an-ipaka-panalangin la ya, hên hilay patêl ha Panginoon ya angkapi-tsi-tsipon. ");
INSERT INTO sgb_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Hên yabin bayo na yan iarap dayi ni Arin Herodes, ha kal-atan, hi apostol Pedro, ay nabêlêw hi apostol Pedro hên nakataykala hên loway taykala, ha pibonakan hên loway hundaloh. Main êt hên hundaloh ya ampagbantay ha kabat hên hukulan. ");
INSERT INTO sgb_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Namakonkaynaman, ay main mihay anghel hên Panginoon ya namukaw kan apostol Pedro. Hinumawang ya andyanan lan apostol Pedro. Hinabi nan anghel kana, ya wana, “Parahên minan mimata!” Tambêng naokal ya taykala ya atsi ha gamêt ni apostol Pedro. ");
INSERT INTO sgb_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Bayo wanan anghel, “Ihulod minay takop mo, magtagkêh ka, haka ihulod minay apin bitsih mo, ta kilako ka kangko.” Kabay hinonol nay hinabi kana. ");
INSERT INTO sgb_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Nakihonol ya kanan anghel hên paawah ha hukulan, êndat ni apostol Pedro no alwan pêtêg ya angkalyari kana, ta êndat na no halumata nay habayto. ");
INSERT INTO sgb_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Nalibahan lay nay unan pangkat hên bantay haka ikalwan pangkat. Hên atsi hilay na ha kabat hên hukulan ya paawah ha balayan, ay nagloat yan sarili na ya habaytoy kabat. Hên nakaawah hilay na, ha pamagdann la ha mihay dann ay biglan napanat ya hatoy anghel. ");
INSERT INTO sgb_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Namwangan na bayto ni apostol Pedro, ya pêtêg awud ya nalyari kana, kabay wana, “Muwang kinan pêtêg ya in-utoh ni Apo Namalyari ya anghel na ta inligtas ako ha pamatsi na kangko ni Arin Herodes ya pan-êngganan lan kapareho kon Israelita ya malyari kangko.” ");
INSERT INTO sgb_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Hên mapakaihip nay na, ya nakabuhan yay na, ay nagtagloh ya ha bali ni Maria, ya indo ni apostol Juan Marcos. Mal-at ya naka-tsipon bayro hên ampanalangin. ");
INSERT INTO sgb_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Hên nilumatêng ya bayro, ay namaêg ya. Mihay ipoh ya dalaga ya nag langan Rode ya napaidani ha kabat. ");
INSERT INTO sgb_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nabalayan nay baêg ni apostol Pedro, kabay ha hadyay higla na, ay naliwaan nan loatên ya kabat, ta tampol yan nuwayu hên impamwang ha kalamo na ya atsi ya ha kabat hi apostol Pedro. ");
INSERT INTO sgb_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","“Angkamurit kay na lawêh!” wanla kana. Noa, impilit na ya atsi ya bayro hi apostol Pedro ha kabat. Gawan a hila naniwala ya nakabuhan hi apostol Pedro, ay wanla, “Kayno anghel ni Apo Namalyari ya habayto, ya ampangillag kana!” ");
INSERT INTO sgb_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Hi apostol Pedro etaman, ay pangakantsig ha kabat angga ha niloat lay na. Hên mahêlêk la yay na, ay nipag-êpapah hilay na. ");
INSERT INTO sgb_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Siningyalan na hila, ya paan hilan maglabak. Hên nakahowên yay na, ay impamwang na kanla no ay-êmên yan in-awah hên Panginoon ha hukulan. Hinabi na êt kanla ya ipamwang la ya habaytsi kan Santiago haka kanlan kaatag ya patêl ha Panginoon. Bayo nag-alíh ya bayro ta nammita ya ha kaatag ya logal. ");
INSERT INTO sgb_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Hên pangamaranon, ay hadyay gulo lan hundaloh ya ampagbantay ha hukulan ha pangapanat ni apostol Pedro. A la muwang no hinoy nalyari kana. ");
INSERT INTO sgb_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Impatapol ya ni Arin Herodes hi apostol Pedro. Hên a lay na matapol, ay impakotang na hilay bantay, bayo impapatsi na hila. Hên pangayarin habayto ha probinsyan Judea, ay nammita yay na hi Arin Herodes ha balayan Cesarea ta nanugêl ya bayro. ");
INSERT INTO sgb_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Gawan manay na ya huluk ni Arin Herodes ha taga-balayan Tiro haka ha taga-balayan Sidon, ay tinalagá lan habayto hên sabay-sabay hên makihabi kana hên makikahundoan hila kana. Nahagyat la hi Blasto ya ampamaala bayro ha bali ni Arin Herodes hên hawpan hilan makikatoynungan, gawan angkaubat ha angkasakopan ni Arin Herodes ya an-ikabiyay la. ");
INSERT INTO sgb_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Hên niabot ya allon pamiaarap la, ay naghulod hi Arin Herodes hên takop pan-ari, haka ya nikno ha iknoan nan mamaala ta naghabi yan nabuyot kanla. ");
INSERT INTO sgb_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Nipan-angaw hilay kal-atan, ya wanla, “Habaytsi ya ampaghabi ay mihay diyos, alwan tawo!” ");
INSERT INTO sgb_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Hên habayto êt ay dinyanan ya hên hakit hên mihay anghel hên Panginoon gawan tinanggap nay pamagsimba, ya hêpat bêngat kan Apo Namalyari. Hiya ay inowêl angga ha hiya ay natsi. ");
INSERT INTO sgb_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Hên habayto ay panlulum-at hilay ampanggilam hên habi ni apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Hên nayari nay na ni Bernabe haka ni Saulo ya dyag la ha Jerusalem, ay gintan la hi Juan Marcos hên paorong ha Antioquia hên kalamo la. ");
INSERT INTO sgb_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Main kanlan patêl ha Panginoon ya angkapi-tsi-tsipon, ha balayan Antioquia ha probinsyan Siria, ya mámipamwang hên an-ipaihip kanla ni Apo Namalyari, haka main mámitoro kanlan ampaniwala kan Panginoon Jesus no hinoy dapat mag-in pamimiyay la. Ya langan la ay hi Bernabe, hi Simeon, ya ambaêgên lan Negro, hi Lucio ya taga-Cirene, hi Saulo, haka hi Manaen, ya kapatubo ni Gobernador Herodes Antipas ha probinsyan Galilea. ");
INSERT INTO sgb_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Mihay allo hên nagtêêh hila hên a nangan ta êmên la maiboo ya nakêm la ha pamagsimba la ha Panginoon, ay hinabi kanla hên Espiritu ni Apo Namalyari ya ipapawa la hi Bernabe haka hi Saulo kanlan kaatag ta main yan ipadyag kanla. ");
INSERT INTO sgb_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Kabay panga-ubat la hên nagtêêh hên a nangan, ta êmên a maabala ya panalangin la, ay impalunto lay nay gamêt la kan Bernabe haka kan Saulo ta inhalangin la hila bayo impabita hilay na. ");
INSERT INTO sgb_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Kabay nilumohan hi Bernabe haka hi Saulo ha balayan Seleucia gawan ha utoh nan Espiritu ni Apo Namalyari. Paubat bayro ay hinumakay hila ha barko hên palako ha polun Chipre. ");
INSERT INTO sgb_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Pamiabot la bayro ha balayan hên Salamina, ha polun Chipre, ay impamwang lay nay habi ni Apo Namalyari ha mal-at ya sinagoga ya pagsimbaan lan Israelita. Kalamo la hi Juan Marcos ya kahawop la. ");
INSERT INTO sgb_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tinêbêh lay balayan hên habaytoy pulo angga ha nakalatêng hila ha balayan hên Pafos. Bayro lan natupa ya mihay naghalamangka ya nag langan Bar-Jesus. Hiyay mihay Israelita ya ampagbabaran hiyay mihay mámipamwang hên an-ipaihip kana ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Hi Bar-Jesus ay kalamo nan gobernador ha Chipre, ya hi Sergio Paulo, ya matalino. Impabaêg hilan Bernabe ni Gobernador Sergio Paulo ta labay nan manggilam habi ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Noa, hinalanghang hila ni Bar-Jesus ya naghalamangka, ya nag langan Elimas ha habin Griego, gawan a na labay hên maniwala kan Panginoon Jesus, ya hi Gobernador Sergio Paulo. ");
INSERT INTO sgb_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ha kapangyarihan nan Espiritu ni Apo Namalyari ya atsi kan Saulo, ya ambaêgên etaman apostol Pablo, ay pinakahêlêk na, hi Elimas, ");
INSERT INTO sgb_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ya wana, “Elimas, anak ka ni Satanas! Kapatsi ka hên kaganawan maka-Diyos. Panay kalokwan haka karawakan ya andaygên mo. An-itumbalik moy kaptêgan ya ubat kan Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Amêhên parusaan na ka. Mabuwag ka haka a minan mahêlêk ya hawang hên allo hên angga ha allo ya intakda na.” Namakonkaynaman ay nagdiglêm ya hêlêk ni Elimas hên mabuwag ya, kabay ampakapakikwanan nan mangapkap hên mangakay kana. ");
INSERT INTO sgb_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Hên nahêlêk nan gobernador ya nalyari kan Elimas, ay naniwala ya kan Panginoon Jesus gawan nag-êpapah ya ha kapangyarihan hên intoro la, ya tungkol ha Panginoon. ");
INSERT INTO sgb_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ha Pafos, hinumakay hilan apostol Pablo ha barko ya palako ha balayan Perga ha probinsyan Panfilia. Panlumatêng la bayro ay nilakwanan hila ni Juan Marcos ta nag-orong ya ha balayan Jerusalem. ");
INSERT INTO sgb_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Hilan apostol Pablo ay nagtagloh ha balayan Antioquia ya karani hên Pisidia. Ha allon pamagsimba lan Israelita, ay nakiikno hilan nakisimba ha mihay sinagoga. ");
INSERT INTO sgb_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Main namaha ha Kautuhan ni Apo Namalyari ya impahulat na kan apo Moises, haka ha inhulat lan kaatag ya mámipamwang hên an-ipaihip na kanla. Panga-ubat hên pamaha, ay hinagyat hilan apostol Pablo hên hilay ampamaala, hên manoro kanla no main hilan iaral kanla. ");
INSERT INTO sgb_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Kabay nirêng ya hi apostol Pablo ta siningyalan na hilay naka-tsipon ya manggilam hila, biha wana, “Kapareho kon Israelita, haka hikaw ya alwan Israelita ya main limo kan Apo Namalyari, ay manggilam kaw ha habiên ko. ");
INSERT INTO sgb_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Hi Apo Namalyari, ya ansimbaên tamon Israelita, ya namili hên ninuno tamo, bayo pinalakê na hila haton lagi hên ampaidi hila pon ha bansan Egipto, ya alwa lan bansa. Ha kapangyarihan na, ya ayn kapantag, ay imbuhan na hila ha pangaipoh la haka hinawpan na hilan mag-alíh ha Egipto. ");
INSERT INTO sgb_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Pinagtêêhan nay pamanalanghang la kana kaban hinayhay na hila ha kabalah-balahan hên apatapoy taon. ");
INSERT INTO sgb_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Hên nilumatêng hila ha Canaan, ay hinambut lay pitoy lahin katutubo bayro ha kapangyarihan na, ta indin nay habaytoy luta kanla, hên hilay ninuno tamon kaapo-apoan ni apo Israel. ");
INSERT INTO sgb_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Apat a gatoh boy limampoy taon (450) ya nakalabah paubat hên nilumatêng ya ninuno tamo ha Egipto angga ha nilumatêng ya kaapo-apoan la ha Canaan. Ha Canaan, ay dinyanan na hila ni Apo Namalyari hên honol-honol ya mánlingon kaso ya namaala kanla hên angga ha pamamaala ni Samuel ya mihay mámipamwang hên an-ipaihip kana ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Hên toa yay na hi Samuel, ay nakikwa hilan ari ya mamaala kanla, kabay namili hi Apo Namalyari hên mihay lalaki, ya kaapo-apoan ni Benjamin, ya hi Saulo, ya anak ni Cis, ya mag-in ari la. Hi Arin Saulo ay namaala hên apatapoy taon. ");
INSERT INTO sgb_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Hên inalíh ni Apo Namalyari hi Arin Saulo ha pamamaala na, ay hi David ya impahili na. Habaytsi ya pamaptêg ni Apo Namalyari hên tungkol kan David, ‘An-ikahigla ko hi David ya anak ni Jesse. Ubuhên nan daygên ya kalabayan ko.’” ");
INSERT INTO sgb_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Inhundo ni apostol Pablo ya pamipamwang na, ya wana, “Yabay ya hi Arin David ya ninuno ni Apo Jesus. Hi Apo Jesus etaman, ay hiyay Mámiligtas, ya impangako ni Apo Namalyari kanlan ninuno tamon Israelita. ");
INSERT INTO sgb_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Hên a ya pon mag-umpisa hi Apo Jesus ha dyag na, ay main lalaki ya nag langan Juan, ya in-utoh ni Apo Namalyari, ya namipamwang hên dapat maghêhê haka pabawtismo ya kaganawan kapareho tamon Israelita. ");
INSERT INTO sgb_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Hên marani nay nan mayari ni Juan ya impadyag kana ni Apo Namalyari, ay hinabi na kanlan kal-atan, ‘Êndat yo no hikoy Cristo ya lumatêng ya an-êngganan yo! Alwan hiko. Noa, marani yay nan lumatêng. Mangokal man hên hêêl apin bitsih na, ay ayn akon karapatan ta hiyay makapangyarihan kangko.’” ");
INSERT INTO sgb_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Inhundo ni apostol Pablo ya pamipamwang na, ya wana, “Kapareho kon kaapo-apoan ni apo Abraham, haka hikaw ya alwan Israelita ya main limo kan Apo Namalyari, kantamo impamwang no ay-êmên na kitamo iligtas ha parusa ya ayn anggaan. ");
INSERT INTO sgb_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Gawan a la naintindihan lan ampaidi ha Jerusalem haka hilay ampamaala kanla, ya hi Apo Jesus, ay habaytoy impangakon Mámiligtas, ya ambahaên la hên balang allon pamagsimba, ha Kahulatan lan mámipamwang hên an-ipaihip kanla ni Apo Namalyari, ay hila pon êt ya nanupad hên Kahulatan, hên hinabi la ya dapat yan patsên. ");
INSERT INTO sgb_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Agyan ayn hilan hêpat ya dahilan hên hiyay patsên, ay pinakipilitan la ya pon êt kan Gobernador Pilato ya hiyay ipapatsi. ");
INSERT INTO sgb_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Hên nadyag lay na ya habayto, haka naubuh hên natupad ya nakahulat ya tungkol kana, ay main namiaypan bangkay na ha koros ta in-ilbêng. ");
INSERT INTO sgb_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Noa, hiyay biniyay oman ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Mal-at ya allo yan nagpahlêk ha mana nan kalamo hên nilumagay ya hên paubat ha Galilea angga ha Jerusalem. Angga amêhên, ay hila ya ampamaptêg kanlan kapareho tamon Israelita ya hiyay nabiyay oman. ");
INSERT INTO sgb_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Kabay atsi kay di hên an-ipamwang kamoyu ya Mangêd ya Habi ya impangako ni Apo Namalyari ha ninuno tamo. ");
INSERT INTO sgb_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Habayto ay tinupad nay na kantamon kaapo-apoan ni apo Israel, hên biniyay nan oman hi Apo Jesus. Habaytoy nakahulat êt ha ikalwan Awit, ya wana, ‘Hika ya anak ko, haka amêhên impamwang ko ya hikoy Tatang mo.’ ");
INSERT INTO sgb_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Haka habaytsi ya hinabi ni Apo Namalyari ya tungkol ha pangabiyay oman ni Apo Jesus, ya a yay nan matsin oman, ‘Hiko ya mangingalo kamoyu, hên taganán tuparên ya impangako ko kan Arin David.’ ");
INSERT INTO sgb_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Hi Apo Jesus ya nanupad hên habaytoy impangako, ta habaytsi ya nakahulat ya hinabi ni Arin David kan Apo Namalyari, ya wana, ‘A mon paulayan hên gumata ha pay-ilbêngan ya lawini hên mapaypaniwal-an mo ya ayn kapantag ha kangêran.’ ");
INSERT INTO sgb_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Noa, hên natupad nay na ni Arin David ya impadyag kana ni Apo Namalyari, ay natsi ya, haka in-ilbêng ya hên kalamo hên ninuno na. Ginumata ya bangkay na ha pay-ilbêngan. ");
INSERT INTO sgb_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Yan a ginumata ya bangkay ni Apo Jesus ya biniyay oman ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Hikaw ya kapareho kon Israelita, an-ipamwang naên kamoyu, ya dapat yon mamwangan, ya gawan ha dinyag ni Apo Jesus, ay mapatawad ni Apo Namalyari ya kasalanan tamo. ");
INSERT INTO sgb_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Gawan kan Apo Jesus ay patawaran ya kasalanan lan kaganawan ya ampaniwala kana. Noa, ayn mapatawad gawan ha pamanhumonol ha Kautuhan ni apo Moises. ");
INSERT INTO sgb_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kabay kaillag kaw ta êmên a malyari kamoyu ya hinabi lan mámipamwang hên an-ipaihip kanla ni Apo Namalyari hên hato, ya wanla, ");
INSERT INTO sgb_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Gilamên yon, hikaw ya mapammusmus! Mipag-êpapah kaw ha daygên ko, noa, matsi kaw pon êt! Ta ya andaygên ko amêhên, ay a yo paniwal-an, main man mamipamwang hên habaytsi kamoyu!’” ");
INSERT INTO sgb_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Hên nayari yay nan namipamwang hi apostol Pablo, hên paawah hilay na ni Bernabe ha sinagoga, ay pinakihabian hila hên mag-orong hila ha humonoy allon pamagsimba, ta êmên ihundo ya pamipamwang la. ");
INSERT INTO sgb_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Hên nipan-umawah hila ha sinagoga, ay mal-at kanlan Israelita haka hilay alwan Israelita, ya anhumonol ha ugali lan Israelita, ya nangamat kanlan apostol Pablo. Kabay pinakihabian ni apostol Pablo haka ni Bernabe ya kapareho la ya dapat lan ihundo ya paniwala la ha ingalo ni Apo Namalyari ha pamimiyay la. ");
INSERT INTO sgb_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Hên humonoy allon pamagsimba la, ay pêrad tanan naubuh hên nagtsipon ya atsi bayro ha balayan, ta êmên hila manggilam hên habi ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nahêm hilay Israelita ya ampamaala ha sinagoga hên nahêlêk lay kal-atan ya naka-tsipon. Kabay hinalanghang lay anhabiên ni apostol Pablo haka la ya minusmus. ");
INSERT INTO sgb_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Noa, a hila nalimwan ya apostol ta makhaw a nakêm lan naghabi, ya wanla, “Taganán kailangan pon ipamwang kamoyun kapareho naên Israelita ya habi ni Apo Namalyari. Noa, gawan an-itaah yo ya habaytsi, ay andaygên yoy sarili yon alwan hêpat hên dyanan hên biyay ya ayn angga. Kabay mita kay, ta manoro kay kanlan alwan Israelita. ");
INSERT INTO sgb_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ta habaytsi ya in-utoh kannaên hên Panginoon, ya wana, ‘Pinili kata ta êmên mamahawang hên kaihipan lan alwan Israelita, Ta êmên gawan kamo, ay miligtas hilay atsi ha boon luta ha parusa ya ayn anggaan.’” Habayto tana ya hinabi ni apostol Pablo haka ni Bernabe. ");
INSERT INTO sgb_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Hên nagilam lan alwan Israelita, ya habaytsi, ay nipaghigla hilan nagpuri ha Panginoon gawan ha habi na. Haka hilay pinili ni Apo Namalyari hên dyanan biyay ya ayn angga hên kalamo na, ay naniwala. ");
INSERT INTO sgb_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Kabay nibahwag ya tungkol kan Panginoon Jesus ha boon logal ya habayto. ");
INSERT INTO sgb_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Noa, main bayron ungnoy mabandi ya babayi ya alwan Israelita, ya maka-Diyos. Hila, haka hilay main tungkulan bayro ha balayan Antioquia, ay ginulo lan ampamaala ha sinagoga, ya a naniwala kan Panginoon Jesus hên ipaplag hilan apostol Pablo bayro ha balayan Antioquia. Kabay impaplag la hi apostol Pablo haka hi Bernabe. ");
INSERT INTO sgb_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ingkampag lan apostol Pablo ya tuwapok ya atsi ha bitsih la ta impahlêk la kanlan Israelita, ya a naniwala kan Panginoon Jesus bayro ha Antioquia, ya lumatêng kanla ya huluk ni Apo Namalyari. Pangayarin habayto, ay nammita hilay na ha balayan Iconio. ");
INSERT INTO sgb_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Hila etaman ya taga-Antioquia ya ampaniwala kan Panginoon Jesus, ay ampamiyay hila ha kapangyarihan nan Espiritu ni Apo Namalyari, haka boon nakêm hilan nagpalokop kana, haka boon nakêm hilan pinahigla. ");
INSERT INTO sgb_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ha Iconio, nilako ni apostol Pablo haka ni Bernabe, ya sinagoga lan kapareho lan Israelita hên nanad êt ha balang balayan ya nilako la. Gawan atsi kanla ya Espiritu ni Apo Namalyari ha paypamwang la, ay mal-at ya Israelita haka Griego ya naniwala kan Panginoon Jesus. ");
INSERT INTO sgb_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Noa, hilay Israelita ya a mabay hên maniwala kana, ay namagulon nakêm lan alwan Israelita, ta êmên hila lumaban kanlan apostol Pablo. ");
INSERT INTO sgb_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Kabay êmbayro man, ay naglaêh hilay apostol bayro hên makhaw ya nakêm hên namipamwang hên tungkol ha Panginoon, ya namaptêg hên pêtêg ya an-ipamwang la ya tungkol ha ingalo na, hên nam-i ya kanla hên kapangyarihan hên mamaalíh hên hakit haka manyag hên kaatag pon ya kapapaêpapah. ");
INSERT INTO sgb_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Noa, ayn pakikimiha ya taga-Iconio. Ya kaatag ay nakigampi kanlan Israelita, haka ya kaatag ay nakigampi kanlan apostol. ");
INSERT INTO sgb_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Main alwan Israelita, haka habaytoy Israelita ya a naniwala, kalamo lay ampamaala kanla ya ampamalak hên pairapan hilay apostol hên batoên hila angga ha hilay matsi. ");
INSERT INTO sgb_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Hên namwangan lan apostol ya balak la, ay nuwayu hila ha Listra haka ha Derbe ya balayan ya atsi ha lokop hên Licaonia angga ha mamalibot hên habaytoy logal. ");
INSERT INTO sgb_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Bayro lan impamwang ya Mangêd ya Habi tungkol kan Panginoon Jesus. ");
INSERT INTO sgb_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ha Listra ay main mihay lalaki ya a ampakabita, paubat hên in-anak ya. ");
INSERT INTO sgb_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Nakaikno yan ampanggilam ha an-ipamwang ni apostol Pablo. Ha pamakahêlêk kana ni apostol Pablo, ay napansin na, ya main yan paniwala ya makabita ya, ");
INSERT INTO sgb_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","bayo wanan namikhaw hên habi na, “Mirêng ka!” Naglukho yan nirêng ta namita-bita yay na. ");
INSERT INTO sgb_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Hên nahêlêk lan kal-atan ya dinyag ni apostol Pablo, ay nan-angaw hila ha habin Licaonia, ya a la naintindihan lan apostol Pablo, “Nag-in tawo hilay diyos haka hiniraw la kitamo!” ");
INSERT INTO sgb_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Hi Bernabe ay êndat lan hi Zeus, ya mihay andiyosên la haka hi apostol Pablo etaman, ay êndat la hi Hermes gawan hiyay ampaypamwang hên nanad kan Hermes ya miha pon ya andiyosên la. ");
INSERT INTO sgb_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ha danin balayan Listra ay main pagsimbaan kan Zeus. Ya pari la bayro ay nantan hên baka ya kinapon ya pinaunoan lan bulaklak, ha ilwangan hên balayan, ta iátang la dayi kanlan apostol Pablo ha pamagsimba la kanla. ");
INSERT INTO sgb_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Hên namwangan lan apostol Pablo ya habayto, ay gininit lay sarili lan takop ha lawini la, ya palatandaan ya taganán a la labay ya habayto. Pinarah-parah lan nagdann ha pibonakan lan kal-atan ta nan-angaw, ");
INSERT INTO sgb_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Alwa yo kay atángan! Tawo kay bêngat hên êmên kamoyu! Atsi kay di hên an-ipamwang kamoyu ya Mangêd ya Habi tungkol kan Panginoon Jesus, ta êmên yo talibatokan ya ansimbaên yo, ya alwan pêtêg diyos, ta hi Apo Namalyari ya angkabiyay ya simbaên yoy naman. Hiyay nanyag hên langit, luta, dagat haka ya kaganawan ya atsi bayro. ");
INSERT INTO sgb_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Hên haton lagi ay pinaulayan nay ninuno yo, haka hilay ninuno lan alwan Israelita ha kalabayan la. ");
INSERT INTO sgb_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Êmbayro man, ay panay nan impakit ya panga-Diyos na ha pam-in uran haka ha pamabokal na ha kaganawan tanaman ha ustoy panaon, ta êmên kaw hinumigla ha katsighaw yo,” habayto tanay in-angaw lan apostol Pablo. ");
INSERT INTO sgb_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Agyan in-angaw la ya habayto, ay namêrad lay nan pinatsi ya habaytoy baka ya kinapon ya iátang la dayi hên taga-Listra. ");
INSERT INTO sgb_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Amêhên, main nilumatêng ha Listra ya Israelita ya ubat ha Antioquia ha sakop hên Pisidia haka Iconio ya nanulhul kanlan naka-tsipon, kabay binato la hi apostol Pablo ta êmên ya matsi, haka la ya ginuloy hên in-awah ha balayan, ta êndat la no natsi yay na. ");
INSERT INTO sgb_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Noa, hên pinilolopungan la yan ampaniwala kan Panginoon Jesus, ay nirêng ya ta nag-orong ha balayan. Hên humonoy allo, ay nammita yay na ha balayan Derbe hên kalamo na hi Bernabe. ");
INSERT INTO sgb_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Hên nilumatêng hilay na ha Derbe, ay impamwang lay Mangêd ya Habi tungkol kan Panginoon Jesus, haka mal-at ya nahagyat la hên maniwala kana. Pangayarin habayto ay nag-orong hilay na êt ha balayan Listra, Iconio, haka Antioquia. ");
INSERT INTO sgb_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Pinataniêh lay nakêm lan ampaniwala kan Panginoon Jesus ha balang balayan, haka la hila inaralan ya ihundo lay paniwala la, gawan mal-at ya kairapan ya kailangan lan danasên bayo hila makahowên ha pamanlokop ni Apo Namalyari ha langit. ");
INSERT INTO sgb_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ha balang logal ya main patêl ha Panginoon ya angkapi-tsi-tsipon ay namili hilan toa ya mamaala bayro, ha pamili la, ay nagtêêh hila hên a nangan, ta êmên a maabala ya panalangin la. Inhalangin la hilay pinili la ya illagan hilan Panginoon ya ampagtsiwal-an la. ");
INSERT INTO sgb_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pangayarin habayto ay nagdann hila ha probinsyan Pisidia angga ha niabot hila ha probinsyan Panfilia. ");
INSERT INTO sgb_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Bayro ha balayan Perga ha Panfilia, ay namipamwang hilan Mangêd ya Habi tungkol kan Panginoon Jesus bayo hila nilumohan ha balayan Atalia. ");
INSERT INTO sgb_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ubat bayro ay naghakay hila ha barko hên paorong ha Antioquia ha probinsyan Siria. Habaytoy ubatan la hên bayo hilan in-utoh, hên haton inhalangin hila, ya illagan haka ingalwan hila ni Apo Namalyari ha pamipamwang hên tungkol kan Panginoon Jesus, ya natupad lay na. ");
INSERT INTO sgb_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Hên pamiabot ni apostol Pablo haka ni Bernabe ha Antioquia, ay binaêg lay patêl ha Panginoon ya angkapi-tsi-tsipon, ta ipamwang ya balang impadyag kanla ni Apo Namalyari, haka no ay-êmên hilan naniwala kan Panginoon Jesus ya hilay alwan Israelita. ");
INSERT INTO sgb_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Naglaêh hilay na bayro hên kalamo lan ampaniwala. ");
INSERT INTO sgb_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Kaban atsi hi apostol Pablo haka hi Bernabe ha balayan Antioquia, ay main nilumatêng ya ungnoy taga-probinsyan Judea, ya anhumonol ha ugali ya intoro ni apo Moises. Tinoroan la hilay patêl ha Panginoon hên êmên di, “A kaw miligtas ha parusa ya ayn anggaan, no a kaw patuli hên nanad ha ugali ya intoro ni apo Moises.” ");
INSERT INTO sgb_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Bayro ha hinabi la, ay taganán pinakihubakan hila lan apostol Pablo. Kabay napagkamihaan lan patêl ha Panginoon ya taga-Antioquia hên palakwên la hila ha Jerusalem hilan apostol Pablo, haka hilay kaatag kanla, ta iarap la ya tungkol ha napihuhubakan la kanlan kaatag ya apostol bayro ha Jerusalem, haka kanlan toa ya ampamaala ha patêl ha Panginoon ha Jerusalem. ");
INSERT INTO sgb_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Kabay hilan apostol Pablo ay in-utoh lan patêl ha Panginoon ya angkapi-tsi-tsipon ha Antioquia. Ha pammita la, ha pagdann la ha probinsyan Fenicia haka probinsyan Samaria, ay impamwang lan apostol Pablo kanlan patêl ha Panginoon ya tungkol ha paniwala lan alwan Israelita kan Panginoon Jesus. Hadyay higla lan patêl ha Panginoon bayro ha nagilam la. ");
INSERT INTO sgb_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Hên nakalatêng hilay na ha balayan Jerusalem, ay boon nakêm hilan tinanggap hên hilay patêl ha Panginoon ya angkapi-tsi-tsipon, kalamo hilay toa ya ampamaala kanla, haka hilay apostol. Impamwang lan apostol Pablo ya kal-atan ya nalyari gawan ha kapangyarihan ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Noa, nirêng ya ungnoy Pariseo ya ampaniwala kan Panginoon Jesus, ya wanla, “Dapat patuli hilay habaytoy alwan Israelita ya ampaniwala ha Panginoon, haka dapat êt hên ipahonol kanlay Kautuhan ni apo Moises.” ");
INSERT INTO sgb_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Kabay, ni-tsi-tsipon hilay apostol haka hilay toa ya ampamaala ha patêl ha Panginoon bayro ha Jerusalem, ta êmên la mapi-iihipan no hino ya dapat lan daygên. ");
INSERT INTO sgb_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Pangayari hên bapan karang ya pamihahabi la, ay nirêng hi apostol Pedro, ta wana, “Hikaw ya patêl ko ha Panginoon, kamwangan yo etaman, ya hikoy pinili ni Apo Namalyari kamoyu hên hato, ta êmên mamipamwang hên Mangêd ya Habi tungkol kan Panginoon Jesus, kanlan alwan Israelita, ta êmên hila maniwala etaman. ");
INSERT INTO sgb_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Haka hi Apo Namalyari, ya ampakamwang hên laman nakêm, ay hiya êt ya namaptêg hên tinanggap na hila hên impahapat na kanlan alwan Israelita ya Espiritu na hên nanad ha impahapat na kantamo. ");
INSERT INTO sgb_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Pantag ya pamanlêk ni Apo Namalyari kanla haka kantamo gawan nilinis na êt ya nakêm la gawan ha paniwala la kana. ");
INSERT INTO sgb_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Pata magma-makhawan kaw pon kan Apo Namalyari! Pata ipahonol yo kanlan alwan Israelita ya ampaniwala kan Panginoon Jesus ya a la mahonol. A tamo mahonol ya habayto, haka hila man ya ninuno tamo ay a la êt nahonol! ");
INSERT INTO sgb_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Hikitamoy ampaniwala kan Panginoon Jesus, ay naligtas ha parusa ya ayn anggaan gawan ha ingalo ni Panginoon Jesus, êmên hila êt bayro ya alwan Israelita. Naligtas hila etaman gawan ha ingalo na.” ");
INSERT INTO sgb_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Hên nayari yay nan naghabi hi apostol Pedro, ay miha man kanlan kal-atan, ay ayn hilan maihabi kana. Bayo nanggilam hilay na êt ha pamwang ni Bernabe angga ni apostol Pablo, ya tungkol ha kapangyarihan hên mamaalíh hên hakit, haka kaatag pon ya kapapaêpapah ya dinyag ni Apo Namalyari ha paypamwang la, hên tungkol kan Panginoon Jesus kanlan alwan Israelita. ");
INSERT INTO sgb_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pangayari lan Bernabe hên naghabi, ay naghabi hi Santiago, ya wana, “Hikaw ya patêl ko ha Panginoon, gilamên yo ko. ");
INSERT INTO sgb_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Kaubat-ubat na pon nangun ni Simon Pedro hên naghabi no ay-êmên na hilan iningalwan ni Apo Namalyari ya hilay alwan Israelita hên namili kanla hên hilay mag-in kana. ");
INSERT INTO sgb_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Habayto êt ay impapapêt ni Apo Namalyari hên hato ya nakahulat ya êmên di, ");
INSERT INTO sgb_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Lumatêng ya allo ay mag-orong ako, ta ipairêng kon oman ya pamanlokop ni Arin David. Paubat ha pangahira, ay ipairêng kon oman, ta êmên mag-in makhaw ya habayto. ");
INSERT INTO sgb_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ta êmên hiko, ya Panginoon, ay tapolên lan alwan Israelita, ya pinili ko hên mag-in kangko. ");
INSERT INTO sgb_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Habaytoy hinabi ni Apo Namalyari, ay impamwang hên haton lagi.’ ");
INSERT INTO sgb_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Kabay ha ihip ko, ay paan tamo hilan pairapan ya hilay alwan Israelita, ya ampaniwalay na kan Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ya mangêd, ay hulatan tamo hila hên paan hilan mangan hên imparaêp ha alwan pêtêg ya diyos, haka paan hilan mangna hên hinon ayop ya a inalihan daya, haka paan hilan mamabayi haka makilalaki. ");
INSERT INTO sgb_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Dapat lan honolên ya habayto, ta êmên a mahakit ya nakêm lan kapareho tamon Israelita, ta paubat hên haton lagi, ay ambahaên ha balang sinagoga, ha balang balayan, ya Kautuhan ni apo Moises no allon pamagsimba tamo.” Habaytoy hinabi ni Santiago. ");
INSERT INTO sgb_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Kabay hilay patêl ha Panginoon ya angkapi-tsi-tsipon ha Jerusalem, kalamo hilay toa ya ampamaala kanla haka hilay apostol, ay nangapikakahundo hên mamilin loway lalaki ya iutoh hên mag-in kalamo ni apostol Pablo boy Bernabe ha pammako la ha balayan Antioquia. Ya pinili la, ay lowa kanlan ampamaala bayro, ya hi Judas ya ambanhagan lan Barsabas haka hi Silas, ya ");
INSERT INTO sgb_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","mantan hên hulat ya êmên di ya laman: “Hikay ya apostol haka hikay ya toa ya ampamaala kanlan patêl ha Panginoon bayri ha Jerusalem, ay ampangumusta kamoyun patêl naên ha Panginoon, ya alwan Israelita, ya atsi bahên ha balayan Antioquia, haka ha probinsyan Siria angga ha probinsyan Cilicia. ");
INSERT INTO sgb_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Namwangan naên ya main ungnoy ubat di, ya a naên in-utoh, ya namuligaw hên ihip yo ha toro la kamoyu. ");
INSERT INTO sgb_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kabay nagtsipon kay haka pinagkamihaan naên hên mamili hên loway lalaki ya iutoh naên bahên kamoyu. Makilako hila kanlan anlugurên tamon patêl ha Panginoon, ya hi Bernabe angga hi apostol Pablo. ");
INSERT INTO sgb_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Indin lay biyay la ha pamaghuyo la kan Panginoon tamon Jesu-Cristo. ");
INSERT INTO sgb_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Iutoh naên hilan Judas haka hi Silas bahên ta êmên la maipalinaw hên arap-arapan ya habaytsi ya an-ihulat naên. ");
INSERT INTO sgb_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Impaihip kannaên hên Espiritu ni Apo Namalyari ya paan naên kaw hên pabyatan hên pahonolên ya a yon kailangan. Habaytsi ya humonol tana ya dapat yon dayuán. ");
INSERT INTO sgb_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Paan kaw mangan hên imparaêp ha alwan pêtêg ya diyos, haka paan mangna hên hinon ayop ya a inalihan daya, haka paan kaw mamabayi haka makilalaki. Dayuán yoy habayto. Angga tana bayro ya mahabi naên kamoyu.” ");
INSERT INTO sgb_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Hilay an-iutoh la ay nammitay na ha Antioquia. Panlumatêng la bayro ay tsinipon la hilay patêl ha Panginoon bayo la indin ya hatoy hulat. ");
INSERT INTO sgb_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Pamakabaha lan hatoy hulat ay hadyay higla la, gawan ha nagilam la bayro ha hulat. ");
INSERT INTO sgb_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Hi Judas haka hi Silas ay mámipamwang hên an-ipaihip kanla ni Apo Namalyari, kabay mal-at ya naiaral la kanlan patêl ha Panginoon ya namataniêh hên paniwala la kana. ");
INSERT INTO sgb_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Hilay lowa ay mabuyot-buyot bayro. Hên mita hilay na ay impanalangin hila lan patêl ha Panginoon, ya illagan hila ha pammita la. Pangayari, ay nag-orong hilay na ha nay-utoh kanla. ");
INSERT INTO sgb_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Noa, hi Silas ay napaibalag tana bayro. ");
INSERT INTO sgb_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Hi apostol Pablo haka hi Bernabe ay inhundo lay paytoro haka paypamwang hên tungkol kan Panginoon Jesu-Cristo ha Antioquia, kalamo hilay mal-at ya kaatag ya patêl ha Panginoon. ");
INSERT INTO sgb_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Pangalabah hên ungnoy allo, ay hinabi ni apostol Pablo kan Bernabe, ya wana, “Orongên ta hila hên hirawên ya hilay patêl ha Panginoon, ya pinaypamwangan ta hên habi na ha balang balayan, ta hêlkên ta no hinoy nay angkalyari kanla.” ");
INSERT INTO sgb_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Labay ni Bernabe hên pakilako hi Juan ya ambanhagan hên Marcos. ");
INSERT INTO sgb_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Noa, a nabay hi apostol Pablo hên pakilako la ya ta hên haton atsi hila ha probinsyan Panfilia ay imbalag na hila ni Juan Marcos. ");
INSERT INTO sgb_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Gawan ha hadyay pamihubak la ay niblag hilay na ni Bernabe haka hi apostol Pablo. Pinagkalamo ni Bernabe hi Marcos haka hilay na hinumakay ha barko ya palakon Chipre. ");
INSERT INTO sgb_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Hi Pablo etaman ay pinagkalamo na hi Silas. Bayo hila nammita ay impanalangin hila lan patêl ha Panginoon ya illagan hila dayi ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Nammita hilan apostol Pablo ha probinsyan Siria haka Cilicia hên pinataniêh ya paniwala lan patêl ha Panginoon ya angkapi-tsi-tsipon. ");
INSERT INTO sgb_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Nilumatêng hilan apostol Pablo ha balayan Derbe angga ha balayan Listra. Bayro ha balayan Listra ay main mihay miyawhay ya nag langan Timoteo, ya ampaniwalay na kan Panginoon Jesu-Cristo. Ya indo na ay Israelita, ya ampaniwala etaman kan Panginoon Jesu-Cristo. Ya tatang ni Timoteo ay Griego. ");
INSERT INTO sgb_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Hilay patêl ha Panginoon ya atsi bayro ha Listra angga ha balayan Iconio ay ampamaptêg ya mangêd ya ugali ni Timoteo. ");
INSERT INTO sgb_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Labay ni apostol Pablo hên pakilako na hi Timoteo, kabay impatuli na ya ta êmên la ya tanggapên hên hilay Israelita, gawan muwang la ya Griego ya tatang ni Timoteo, haka a ya êt impatuli hi Timoteo. ");
INSERT INTO sgb_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ha pamagdann la ha binabalayan ay an-ipamwang la kanlan ampaniwala kan Panginoon Jesu-Cristo, ya napikakahundoan lan apostol haka hilay toa ya ampamaala kanlan patêl ha Panginoon ha Jerusalem, ya dapat lan honolên. ");
INSERT INTO sgb_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kabay lalon hinumkaw ya paniwala lan patêl ha Panginoon ya angkapi-tsi-tsipon, ya hiniraw la, haka allo-allo angkapahanan hila. ");
INSERT INTO sgb_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ha pammita la ay nagdann hila ha probinsyan Frigia haka Galacia gawan binawal hila hên Espiritu ni Apo Namalyari hên paan hilan mamipamwang ha probinsyan Asia. ");
INSERT INTO sgb_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Hên niabot hilay na ha pianggaan hên probinsyan Misia, ay labay la dayin manoro ha probinsyan Bitinia, noa, binawal hilay na êt hên Espiritu ni Panginoon Jesus. ");
INSERT INTO sgb_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Kabay nagdann hila tana ha probinsyan Misia angga ha nilumatêng hila ha balayan Troas. ");
INSERT INTO sgb_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Habayton yabi, ay main yan nahalumata hi apostol Pablo ya mihay lalaki ya taga-probinsyan Macedonia ya ampakihabi kana, ya wana, “Maglipay kaw pon di kannaên ha Macedonia ta hawpan yo kay!” ");
INSERT INTO sgb_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pangayari hên halumata, ay tampol kay nanapol hên barko ya mahakyan hên palipay ha probinsyan Macedonia gawan muwang naên ya an-iutoh na kay ni Apo Namalyari hên ipamwang kanla ya Mangêd ya Habi tungkol kan Panginoon Jesus. ");
INSERT INTO sgb_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Paubat ha balayan Troas ay nagtagloh kay ha pulo hên Samotracia. Bayo, pangamaranon ay inhundo naên ya pamaglipay ha balayan Neapolis. ");
INSERT INTO sgb_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Paubat bayro ay namitsih kay palako ha balayan Filipos ya pinakamahlay ya balayan ha probinsyan Macedonia ya sakop hên gobyernon Roma. Naglaêh kay pon bayro. ");
INSERT INTO sgb_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Hên allo-allon pamagsimba lan Israelita, ay inumawah kay ha balayan, ta nikno kay ha laylay hên ilog ta habayto kanoy pagtsiponan lan Israelita hên manalangin. Intoro naên kanlan babayi ya naka-tsipon bayro ya Mangêd ya Habi tungkol kan Panginoon Jesus. ");
INSERT INTO sgb_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ya miha kanla bayro, ya nag langan Lydia, ya taga-balayan Tiatira, ay mámihaliw hên tela ya kulay ubi. Hiyay ampagsimba etaman kan Apo Namalyari. In-il-an ni Apo Namalyari ya nakêm na hên pakapaniwal-an nay toro ni apostol Pablo. ");
INSERT INTO sgb_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ha maparah ya habi ay nagpabawtismo ya hi Lydia haka hilay kalamo na ya atsi ha bali na. Pangayari ay hinagyat na kay hên magdahêl ha bali la, ya wana, “No ampaniwala kaw hên pêtêg ya paniwala ko ha Panginoon, ay magdahêl kaw pon di ha bali.” Gawan ampalêkpêkên na kay, ay a naên natanggian ya pamanagyat na kannaên. ");
INSERT INTO sgb_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Mihay allo hên anlakwên naên habaytoy panalanginan, ay natupa naên ya mihay dalaga ya ipoh. Habaytsi ay anhapatan hên narawak ya a angkahêlêk ya main kapangyarihan hên manawas. Kal-atan hên pera ya angkakwa lan ámo na gawan ha pamanawas na. ");
INSERT INTO sgb_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ampangamat-kamat ya kannaên ni apostol Pablo, ya wana, “Hilay habaytsi ay ampaghuyo kan Apo Namalyari. An-ipamulah la kamoyu no ay-êmên kaw hên miligtas ha parusa ya ayn anggaan.” ");
INSERT INTO sgb_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Hên allo-alloy nan habiên ya habayto, ay nanuluk kana hi apostol Pablo, haka na ya inarap ta hinabyanan nay hinumapat ha dalaga, ya wana, “Ha kapangyarihan ni Panginoon Jesu-Cristo, ay mag-alíh ka kana.” Tampol hên inumalih ya hatoy hinumapat kana. ");
INSERT INTO sgb_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Hên nahêlêk lan ámo nan hatoy dalaga ya ayn hilay nan mapangwanan pera, ay dinakêp la hi apostol Pablo haka hi Silas. Ginuloy la hilan in-arap kanlan manungkulan. ");
INSERT INTO sgb_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Hên in-arap hilan apostol Pablo kanlan habaytoy manungkulan hên gobyernon Roma, bayro êt ha Filipos, ay êmên di ya pamidikil la: “Habaytsi ya loway Israelita ay ampamuligaw bayri ha balayan tamo. ");
INSERT INTO sgb_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ya an-itoro la ay ugalin halanghang ha patakaran tamon taga-Roma. A tamo malyarin tanggapên o honolên ya habayto.” ");
INSERT INTO sgb_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Hilay atsi bayro hên nakalopong, ay nakilamon nandakêp kanlan apostol Pablo. Gawan êmbayro, ay pinaláboh hilan habaytoy manungkulan hên gobyernon Roma bayro ha Filipos hilan apostol Pablo, haka la hila impabarog. ");
INSERT INTO sgb_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Hên nayari hilan binarog, ay impahukul hila haka in-utoh lan ampamaala ha hukulan ya pakabantayan na hilan mangêd. ");
INSERT INTO sgb_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kabay inhowên na hila ha kalalê-lalêan hên hukulan, haka na hila hinipit ya bitsih la hên loway tabla ya tinalagá hên nilubtan ta êmên main dyanan hên bitsih. ");
INSERT INTO sgb_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Hên bonak yabi, ay ampanalangin haka ampagkantan pamagpuri kan Apo Namalyari hi apostol Pablo haka hi Silas. Ampanggilam hilay kapareho lan nakahukul bayro. ");
INSERT INTO sgb_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Namakonkaynaman, ay nanlayon hên hadyay hêkaw. Kabay nangayêgê ya hatoy hukulan. Biglan naubuh hên nangaloat ya kabat, haka nangakalag ya taykala ya pinanggapoh la kanlan nangahukul. ");
INSERT INTO sgb_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Hên nipaimata ya hatoy ampamaala bayro ha hukulan haka na napansin ya nangaloat ya kabat, ay inulbut nay hundang na ta magpakamatsi ya dayi ta êndat na no nakatakah hilay nay nakahukul. ");
INSERT INTO sgb_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Noa, inangawan ya ni apostol Pablo, ya wana, “Paan kan magpakamatsi ta atsi kay pon di ya kal-atan!” ");
INSERT INTO sgb_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Namakwa yan pag-atáng ya hatoy ampamaala ha hukulan, haka naparagah yan hinumwên hên ampamêgpêg hên nanlokob ha arapan lan apostol Pablo angga ni Silas. ");
INSERT INTO sgb_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Bayo in-awah na hila ha hukulan haka ya nangotang kanla, ya wana, “Hinoy dapat kon daygên êmên ko miligtas ha parusa ya ayn anggaan?” ");
INSERT INTO sgb_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Hinabi la etaman, ya wanla, “Maniwala ka kan Panginoon Jesus ta êmên ka miligtas ha parusa ya ayn anggaan, hika boy hilay kalamo yo ha bali.” ");
INSERT INTO sgb_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ha maparah ya habi ay impamwang lan apostol Pablo ya habi hên Panginoon ha ampamaala bayro ha hukulan haka ha kalamo na ha bali. ");
INSERT INTO sgb_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Habayto êt hên yabi hên inuyahan nan bantay ya hugat lan apostol Pablo, ay hiya haka ya kalamo na ha bali ay tampol hên nagpabawtismo. ");
INSERT INTO sgb_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Pangayari ay hinagyat na hilan humwên ha bali na ta inapagan na hilan pamangan. Hadyay higla nan ampamaala ha hukulan haka ya kalamo na ha bali gawan ha naniwala hilay na kan Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Pangamaranon, ay namiutoh ya habaytoy manungkulan hên gobyernon Roma ya atsi ha Filipos, hên polis ha hukulan, ya ipaawah lay na kano, hilan apostol Pablo. ");
INSERT INTO sgb_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Gawan êmbayro, ay hinabi na kan apostol Pablo, hên habaytoy ampamaala ha hukulan, “Namipagtan hilan habi ya manungkulan hên gobyernon Roma bayri ha Filipos ya iawah kaw. Kabay mita kaw na dayi hên mapatêkbêk.” ");
INSERT INTO sgb_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Noa, wani apostol Pablo, “Impabarog la kay ha arapan hên kal-atan, haka la kay impahukul hên a la kay pon nilingon agyan taga-Roma kay! Bayo labay la kay hên ipaawah hên ayn makamwang! A malyari ya êmbayro! Dapat hilay maglakó di hên mamiawah kannaên!” ");
INSERT INTO sgb_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Inhumbung lan polis kanlan manungkulan ya hinabi ni apostol Pablo. Nalimwan hilay habaytoy manungkulan hên gobyernon Roma hên namwangan la ya taga-Roma hila awud hilan apostol Pablo. ");
INSERT INTO sgb_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Kabay nagtagloh hila ha hukulan hên nakikwan patawad kanla haka la hilay na in-awah. Pinakihabi la kanla etaman ya mag-alíh hila ha balayan Filipos. ");
INSERT INTO sgb_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pamakaawah la ha hukulan hilan apostol Pablo, ay nagtagloh hila ha bali lan Lydia. Hên napahigla lay nay nakêm lan patêl ha Panginoon, ay nammita hilay na. ");
INSERT INTO sgb_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Hi apostol Pablo, hi Silas haka hi Timoteo ay nagdann ha balayan Amfipolis haka ha balayan Apolonia angga ha nilatêng hila ha balayan Tesalonica ya main sinagoga lan Israelita. ");
INSERT INTO sgb_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Gawan nakasanayan nay na ni apostol Pablo hên makisimba hên toroan na hilay kapareho nan Israelita, ay ha tatloy allon pamagsimba la, ay anlakwên na hila bayro ha sinagoga la, ta nakipagpalinawan ya kanla ubat ha Kahulatan ya impahulat ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Impalinaw haka pinaptêgan na ya nakahulat bayro ya tungkol ha Mesias, ya Cristo, ya impangakon Mámiligtas ya pinili ni Apo Namalyari hên mamaala, ya kailangan nan matsi haka mabiyay oman. Impamwang na kanla ya hi Panginoon Jesus ay habaytoy Mámiligtas, ya an-êngganan la, ya impangako bayro ha Kahulatan ya impahulat ni Apo Namalyari. ");
INSERT INTO sgb_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Main kaatag Israelita ya nanggilam ha impamwang, haka nakihonol kan apostol Pablo haka kan Silas. Main etaman bayro hên babayi ya mabandi haka kal-atan Griego ya maka-Diyos ya naniwala kan Panginoon Jesus. ");
INSERT INTO sgb_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Noa, main kaatag ya poon lan kapareho lan Israelita ya nag-inakit kanlan apostol Pablo. Tsinipon la hilay mapanyag karawakan, ya ampagbabakahaan ha palengke, ya nangamuyot a êt hên kal-atan hên nanulhul hên boon balayan hên lakwên ya bali ni Jason ta êndat lan atsi hila bayro hilan apostol Pablo ta paawahên la hila dayi. ");
INSERT INTO sgb_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Hên a lay na natapol, ay ginuloy lan gintan hi Jason haka kaatag kanlan patêl ha Panginoon, hên in-arap ha manungkulan hên balayan Tesalonica hên main kalamoy angaw, ya wanla, “Hilay habaytoy lalaki ay ampamuligaw ha balang logal ya anlakwên la! Amêhên, atsi hilay na bayri kantamo! ");
INSERT INTO sgb_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Pinakatuloy na hila ni Jason ha bali na, haka hilangan ay anhumalanghang ha patakaran hên pinakapoon ha Roma ya ampag-ari kantamo, ta anhabiên la ya main kaatag ya pinakapoon, ya langan na ay Jesus.” ");
INSERT INTO sgb_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Hên pamakagilam lan habayto hên hilay kal-atan, haka hilay manungkulan hên balayan Tesalonica, ay nangabuligaw hila. ");
INSERT INTO sgb_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Hên tinanggap lay nay impiyansa ni Jason haka ya impiyansa lan kaatag ya patêl ha Panginoon, ay imbuhan hilay na. ");
INSERT INTO sgb_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Hên habayton yabi êt, ay in-aporah la hi apostol Pablo, hi Silas haka hi Timoteo hên impalakoy na ha balayan Berea. Hên nilumatêng hilay na, ay hinumwên hila ha sinagoga lan kapareho lan Israelita. ");
INSERT INTO sgb_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Hilay Israelita bayro ha Berea ay loat ya kaihipan, kanan kaihipan lan Israelita ha Tesalonica. Labay-labay lan manggilam ha panoro ni apostol Pablo. Allo-allo lan ampag-aralan ya Kahulatan ya impahulat ni Apo Namalyari, ta êmên la mamwangan no pêtêg ya an-itoro ni apostol Pablo. ");
INSERT INTO sgb_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Mal-at kanla ya naniwala haka main etaman bayro hên kal-atan babayi haka lalaki ya Griego ya mabandi. ");
INSERT INTO sgb_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Noa, hên namwangan lan Israelita ha Tesalonica ya ampaypamwang hi apostol Pablo hên habi ni Apo Namalyari ha balayan Berea, ay nangamat hilay na êt bayro hên nanulhul kanlan taga-Berea hên manalanghang kan apostol Pablo. ");
INSERT INTO sgb_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","In-aporah la hi apostol Pablo hên hilay patêl ha Panginoon ha Berea hên impalako ha laylay hên dagat ta êmên ya makahakay ha barko. Noa, nabalag hi Silas angga hi Timoteo bayro ha Berea. ");
INSERT INTO sgb_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Main ungnoy nangiatêl kan apostol Pablo hên angga ha balayan Atenas. Hên paorong hilay nay nangiatêl kana, ay intsipan na kanla ya tampol hilan mangamat hi Silas angga hi Timoteo, no malyari. ");
INSERT INTO sgb_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Hên an-êngganan ni apostol Pablo hi Silas haka hi Timoteo ha balayan Atenas, ay namalagêhbêg ya nakêm na ha napansin nay kal-atan hên rebulto hên alwan pêtêg ya diyos ya ansimbaên lan taga-Atenas. ");
INSERT INTO sgb_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Kabay ya dinyag na, ay bayro ha sinagoga, ay nakipagpalinawan ya hên kalamo nay kapareho nan Israelita haka hilay kaatag ya maka-Diyos. Allo-allo ya etaman hên ampakidebate kanlan atsi bayro ha plasa. ");
INSERT INTO sgb_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Bayro ha plasa ay main mánoro ya Epicureo haka mánoro hên Estoico ya ampakidebate kana. Wanlan kaatag, “Hinoy an-ilambung nan hata ayn minúwang?” Wanla êt hên kaatag, “Ampaypamwang ya lawêh hên tungkol ha diyos lan kaatag ya bansa!” Hinabi lay habayto gawan an-ipamwang na kanla ya Mangêd ya Habi tungkol kan Panginoon Jesus haka tungkol ha natsi ya biyayên hilan oman. ");
INSERT INTO sgb_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ha maparah ya habi, ay gintan la hi apostol Pablo ha pagtsiponan lan manungkulan bayro ha logal ya ambaêgên lan Areopago, ya wanla, “Labay naên mamwangan no hino ya habaytsi ya bayoy toro ya an-itoro mo kannaên. ");
INSERT INTO sgb_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Babayo naên magilaman ya habaytsi ya anhabiên mo kabay labay naên mamwangan no hinoy labay habiên hên habaytsi.” ");
INSERT INTO sgb_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Hilay taga-Atenas haka hilay kaatag ya ampaidi bayro ay allo-allo lan labay hên manggilam haka pihabian ya hinoman ya bayoy toro.) ");
INSERT INTO sgb_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Kabay nirêng hi apostol Pablo ha arapan lan naka-tsipon ta hinabi na kanla, “Anggalangên kon taga-Atenas, angkahêlêk ko ya mahipêg kaw ha pamagsimba. ");
INSERT INTO sgb_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ta ha pagtawak-tawak ko bayri ha logal yo, ay napansin koy mal-at ya ansimbaên yo. Nahêlêk ko ya mihay pamiatangan ya nag-hulat hên êmên di, ‘Habaytsi ay ha Diyos ya a naên muwang.’ Habaytoy ansimbaên yo, ya a yo man kilala, ay yabay ya an-ipamwang ko kamoyu. ");
INSERT INTO sgb_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Hiya hi Apo Namalyari ya nanyag hên luta haka ya kaganawan ya atsi bayri. Hiya ya Panginoon ha langit haka ha luta, kabay a ya ampaidi ha pagsimbaan ya dinyag tawo. ");
INSERT INTO sgb_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","A na kitamon ampanapolan hên hinoman, ta hiyay ampam-in biyay haka inanawa haka hinoman ya kailangan tamo. ");