﻿USE sofia;
DROP TABLE IF EXISTS sofia.seyNT_vpl;
CREATE TABLE seyNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES seyNT_vpl WRITE;
INSERT INTO seyNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Iye aꞌë, Abraham cuiꞌne David tsëcapë acohuaꞌire cue̱cueseꞌe ja̱ yëꞌtaꞌa Jesucristo paꞌimaꞌnë paꞌisicohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Isaac pëca jaꞌquë pajiꞌi, Abraham. Jacob pëca jaꞌquë pajiꞌi, Isaac. Cuiꞌne Judá cuiꞌne i̱ yoꞌje tsi̱ pëca jaꞌquë pajiꞌi, Jacob. ");
INSERT INTO seyNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Fares cuiꞌne Zara pëca jaꞌquë pajiꞌi, Judá. Cuiꞌne i̱ohuaꞌi pëca jaꞌco pacoꞌë, Tamar. Esrom pëca jaꞌquë pajiꞌi, Fares. Aram pëca jaꞌquë pajiꞌi, Fares. ");
INSERT INTO seyNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aminadad pëca jaꞌquë pajiꞌi, Aram. Naasón pëca jaꞌquë pajiꞌi, Aminadad. Salmón pëca jaꞌquë pajiꞌi, Naasón. ");
INSERT INTO seyNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Booz pëca jaꞌquë pajiꞌi, Salmón. Cuiꞌne i̱ pëca jaꞌco pacoꞌë, Raab. Obed pëca jaꞌquë pajiꞌi, Booz. Obed pëca jaꞌco pacoꞌë, Rut. Isaí pëca jaꞌquë pajiꞌi, Obed. ");
INSERT INTO seyNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Pa̱i ëjaë David pëca jaꞌquë pajiꞌi, Isaí. Salomón pëca jaꞌquë pajiꞌi, David. Cuiꞌne Urías nëjo paꞌisicopi Salomón jaꞌco pacoꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Roboam pëca jaꞌquë pajiꞌi, Salomón. Abías pëca jaꞌquë pajiꞌi, Roboam. Asa pëca jaꞌquë pajiꞌi, Abías. ");
INSERT INTO seyNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Josafat pëca jaꞌquë pajiꞌi, Asa. Joram pëca jaꞌquë pajiꞌi, Josafat. Uzías pëca jaꞌquë pajiꞌi, Joram. ");
INSERT INTO seyNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Jotam pëca jaꞌquë pajiꞌi, Uzías. Acaz pëca jaꞌquë pajiꞌi, Jotam. Esequías pëca jaꞌquë pajiꞌi, Acaz. ");
INSERT INTO seyNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Manases pëca jaꞌquë pajiꞌi, Esequías. Amón pëca jaꞌquë pajiꞌi, Manases. Josías pëca jaꞌquë pajiꞌi, Amón. ");
INSERT INTO seyNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jeconías cuiꞌne i̱ yoꞌje tsi̱ co̱ni pëca jaꞌquë pajiꞌi, Josías. Ja̱ohuaꞌi cato co̱asicohuaꞌi paëꞌë, Israelita pa̱ire tse̱ani Babilonia yejana sa maca. ");
INSERT INTO seyNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Israelita pa̱i sa cua̱ñosi jeteyoꞌje Salatiel pëca jaꞌquë pajiꞌi, Jeconías. Zorobabel pëca jaꞌquë pajiꞌi, Salatiel. ");
INSERT INTO seyNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Abiud pëca jaꞌquë pajiꞌi, Zorobabel. Cuiꞌne Eliquin pëca jaꞌquë pajiꞌi, Abiud. Azor pëca jaꞌquë pajiꞌi, Eliquin. ");
INSERT INTO seyNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Sadoc pëca jaꞌquë pajiꞌi, Azor. Aquim pëca jaꞌquë pajiꞌi, Sadoc. Eliud pëca jaꞌquë pajiꞌi, Aquim. ");
INSERT INTO seyNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eleazar pëca jaꞌquë pajiꞌi, Eliud. Matán pëca jaꞌquë pajiꞌi, Eleazar. Jacobo pëca jaꞌquë pajiꞌi, Matán. ");
INSERT INTO seyNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","José pëca jaꞌquë pajiꞌi, Jacobo. José cato Jesucristo pëca jaꞌco María ë̱jë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ja̱je paꞌina, Abrahampi cuiꞌne David paꞌi macaja̱ꞌa cue̱cueto catorce paꞌye de ai deꞌhuaseꞌe paꞌiji. Davidpi cuiꞌne Israelita mañare Babiloniana tse̱seni sasi macaja̱ꞌa cue̱cueto cuiꞌne catorce paꞌiji. Cuiꞌne yequë catorce paꞌi maca Cristo ai deꞌopi. ");
INSERT INTO seyNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristore co̱aseꞌe ñeje paꞌiji: María i̱ pëca jaꞌco, José ja̱ꞌre huejaja̱ꞌcoa, ca nëosico pacoꞌë. Ja̱je ca nëosicopi ja̱ yëꞌtaꞌa tsioni paꞌimaꞌnë tsi̱ ë̱tapë deꞌo Maijaꞌquë joyo tutupi. ");
INSERT INTO seyNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José i̱o ë̱jë nuñerepa paꞌi pajiꞌi. Ja̱je paꞌitaꞌa nëjo Maríare siꞌaohuaꞌi pa̱i asajëna, je̱oñe coepi. Coa ai jerepa pa̱ije ti asamaꞌpëna i̱seꞌe je̱osiꞌi cuasapi. ");
INSERT INTO seyNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ja̱je cuasaquë paꞌina, Ëjaë hui̱ñaëpi i̱te huëo hue̱ꞌñajaꞌa ñaini capi: “José David tsëcapë aquë, Maríare caꞌramaꞌë paꞌijë̱ꞌë, nëjore deꞌhuani paye. I̱o paja̱ꞌquë cato Maijaꞌquë joyo tse̱quë api. ");
INSERT INTO seyNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Tsihuaëꞌni paja̱ꞌcoa. Pacona, i̱ mami Jesure sëojë̱ꞌë, huasoquëre. Ja̱je hueꞌequë paꞌija̱ꞌquë api, i̱ pa̱ire coꞌaye yoꞌocohuaꞌire huasoja̱ꞌquë sëte.” ");
INSERT INTO seyNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Siꞌaye ja̱je ti̱ꞌapi, tsoe hue̱ꞌña Maijaꞌquëre quëacaiquë ca nëoquë paꞌiseꞌepi, ñeje: ");
INSERT INTO seyNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Nomio tsi̱o, ë̱më ti yoꞌomaꞌcopi tsi̱ quëꞌio deꞌoni tsihuaꞌëre pasio. Ja̱ëpi i̱ mami hueꞌequë pasipi, Emanuel. Ja̱je cani cayë, Maijaꞌquë mai ja̱ꞌre paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ja̱ maca José sëtani mai Ëjaë cua̱ñeseꞌeje̱ Maríare nëjore pao cuasaquë ti pëani nëjore papi. ");
INSERT INTO seyNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ja̱je paꞌiquëtaꞌare huejasicohuaꞌi paꞌiyepi paꞌiye pa̱huë, mamaquëre tëꞌya dani i̱ mami Jesús hueꞌyo macaja̱ꞌa. ");
INSERT INTO seyNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Judea yejana Jesús co̱asiquë pajiꞌi, aꞌri daripë Belén huëꞌe daripëna. Ja̱ muꞌseña Herodes pajiꞌi, Pa̱i Ëjaë, ja̱ yeja cua̱ñequë. Ja̱ muꞌseña Jerusalénpi daëꞌë, ë̱së mëi te̱ꞌtepi, yequë ë̱mëohuaꞌi Magos hueꞌecohuaꞌipi. Ja̱ohuaꞌi cato pairiohuaꞌi paëꞌë, ë̱së mëi te̱ꞌte quëꞌro acohuaꞌi. Maꞌñoco yoꞌoye yeꞌyecohuaꞌipi cuiꞌne deꞌhue ta̱ꞌñe cacohuaꞌi paëꞌë, i̱ti yoꞌoyere ñajë. ");
INSERT INTO seyNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ja̱ohuaꞌipi dani se̱iꞌë: “¿Jerore paꞌiquëꞌni, judío pa̱i Ëjaë yure co̱asiquë? Jeto ë̱së mëi te̱ꞌtepi ñahuë, i̱ maꞌñocore. Ja̱je ñani daëꞌë, i̱te doꞌre jaꞌrujë se̱ñuꞌu cajë i̱ñona.” ");
INSERT INTO seyNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Cajëna, pa̱i ëjaë Herodes asani ai cuasapi, ¿me yoꞌoseꞌere cayeꞌni? caquë, cuiꞌne siꞌa Jerusalén paꞌicohuaꞌi ai cuasahuë, i̱tire asani. ");
INSERT INTO seyNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ja̱ maca pa̱i ëjaë siꞌaohuaꞌire soipi, Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌire cuiꞌne cua̱ñeseꞌe pa̱ire yeꞌyacohuaꞌire. Soini se̱ni asapi, ja̱ohuaꞌire, ¿jerona Cristore co̱a ja̱ꞌñe ca nëoseꞌe paꞌiquëꞌni? caquë. ");
INSERT INTO seyNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Caquëna, ja̱ohuaꞌipi cahuë, i̱te: Belén Judea yejana co̱ajaꞌquë api, caquë. Maijaꞌquë jëjo daoquë tsoe aquë toyapi, ñeje: ");
INSERT INTO seyNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Belén maca, Judá yeja paꞌico. Mëꞌëre cua̱ñecohuaꞌi jerepa aꞌrico maca paꞌimaꞌo paꞌiyë, mëꞌë. Ja̱je paꞌina, mëꞌëpi etaja̱ꞌquë api, Ëjaërepa, Israel pa̱ire ñacaija̱ꞌquë. ");
INSERT INTO seyNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Cajëna, asani ja̱ maca Herodes Magos huaꞌire yahuerepa soini i̱ohuaꞌiseꞌere se̱jiꞌi, ¿je yëhua maꞌñoco ñaina, ñareꞌni? caquë. ");
INSERT INTO seyNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Se̱ni asani ja̱ maca Belénna ja̱ohuaꞌire jëjo saoquë capi: “Saijë̱ꞌë. Ja̱rona sani asajë̱ꞌë, deꞌoyerepa tsihuaꞌë paꞌiyere paꞌire pamaꞌquë. Ja̱je i̱ni ti̱ꞌasicohuaꞌi pani yëꞌëre dani quëajë̱ꞌë. Yëꞌëje̱ sani doꞌre jaꞌruquë se̱jasiꞌi, i̱te.” ");
INSERT INTO seyNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ja̱je pa̱i ëjaë caëna, Magos maña saëꞌë. Saijëna, maꞌñoco i̱ohuaꞌi ë̱së mëi te̱ꞌte ñasiquëpi duꞌru sai sapi. Ja̱je saiquëpi tsihuaꞌë paꞌi hue̱ꞌñana nëajani huesëpi, sa tëjini. ");
INSERT INTO seyNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ja̱ maca Magos maña maꞌñocopi ja̱je yoꞌouna, ñani ai sihuahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Sihuajë huëꞌena sa cacajë ñahuë, tsi̱tuꞌure pëca jaꞌco María ja̱ꞌre u̱ina. Ñani doꞌre jaꞌruni tsihuaꞌëre deꞌoquë macani cajë sihuahuë. Ja̱ jeteyoꞌje i̱ohuaꞌi mahuëa mañare huiꞌyoni oro, huëo së̱ñe cuiꞌne mirra i̱te i̱sihuë, jai doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ja̱ jeteyoꞌje Maijaꞌquëpi huëo hue̱ꞌñajaꞌa quëapi, Herodes quëꞌro coꞌimaꞌpë paꞌijë̱ꞌë, caquë. Ja̱je quëaëna, yequë maꞌajaꞌa coꞌihuë, i̱ohuaꞌi yejana. ");
INSERT INTO seyNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ja̱ohuaꞌi Magos saisi jeteyoꞌje Ëjaë hui̱ñaëpi huëo hue̱ꞌñajaꞌa ñani Josére capi: “Huëni tsihuaꞌëre cuiꞌne pëca jaꞌcore sai sajë̱ꞌë, Egípto yejana. Ja̱rona sani pëajë̱ꞌë, yëꞌëpi yeque yoꞌoye paꞌito caëna, yoꞌoja̱ꞌquë. Yure cato Herodespi tsihuaꞌëre huani je̱osiꞌi caquë coꞌeja̱ꞌquë api. Ja̱ doꞌire saijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ja̱je caëna, José huëni tsihuaꞌëre cuiꞌne i̱ pëca jaꞌcore sëtoni ñami sai sapi, Egíptona. ");
INSERT INTO seyNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ja̱rote paëꞌë, Herodes ju̱ꞌi macaja̱ꞌa. Tsoe aquë Maijaꞌquëre quëacaiquëpi Ëjaëpi caquëna, toyapi: “Egíptopi yëꞌë mamaquëre soihuë” ja̱ toyaseꞌepi ti̱ꞌaëna, ja̱je yoꞌohuë. ");
INSERT INTO seyNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ja̱ maca Herodes, Magos huaꞌi yëꞌëre coꞌaquë api cajë yoꞌore caquë ai pë̱i tsi̱re caya o̱metëca pacohuaꞌire cuiꞌne ai tsi̱tu̱ꞌñare huani je̱ajëꞌë, cua̱ñepi. Belén paꞌicohuaꞌire, cuiꞌne i̱ti yërëhue paꞌicohuaꞌireje̱ caquë, caya o̱metëca maꞌñoco paꞌi huëoseꞌe paꞌiji, Israel pa̱i ta̱ꞌñe paꞌiohuaꞌi caseꞌere cuasaquë ja̱je yoꞌopi. ");
INSERT INTO seyNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ja̱je yoꞌoquëna, ti̱ꞌapi, Maijaꞌquëre quëacaiquë Jeremias ñeje toyaquë paꞌiseꞌe. ");
INSERT INTO seyNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Rama quëꞌropi, cuiye cuiꞌne jaiye oi yëꞌo jutaquëna asahuë. Ja̱o cato Raquelpi mamajëni ocoꞌë. Yëhuotoje̱ asaye coeo, Mamajëpi tsoe ju̱jusicohuaꞌi paꞌijëna. ");
INSERT INTO seyNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodes ju̱ꞌisi jeteyoꞌje, Ëjaë hui̱ñaëpi Josére huëo hue̱ꞌñajaꞌa ñaini capi, Egíptore paꞌina: ");
INSERT INTO seyNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Huëni tsihuaꞌëre mëꞌëpi co̱ani, cuiꞌne pëca jaꞌcore huëoni coꞌijë̱ꞌë, Israel yejana. Tsoe tsihuaꞌëre huajo yëjë paꞌisicohuaꞌi ju̱ju sahuë.” ");
INSERT INTO seyNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ja̱ maca José huëni tsihuaëre cuiꞌne pëca jaꞌcore sai sapi, Israel yejana. ");
INSERT INTO seyNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ja̱je saiquëtaꞌa José asapi, Herodes mamaquë Arquelaopi pëca jaꞌquë yoꞌoraꞌaseꞌere yoꞌoji cajëna. Ja̱je asani ja̱ro saiye caꞌraquëna, huëo hue̱ꞌñajaꞌa Maijaꞌquëpi quëaëna, Galilea yeja quëꞌrona sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ja̱rona ti̱ꞌani Nazaret huëꞌe daripëna pëapi. Ja̱je yoꞌoquëna, Maijaꞌquëre quëacaicohuaꞌi ca nëojë paꞌiseꞌe ti̱ꞌapi, “Jesús Nazareno paꞌija̱ꞌquë api” caseꞌe. ");
INSERT INTO seyNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ja̱ muꞌseña Juan oco doquëpi Judea cue̱ne yejana so̱quë peo hue̱ꞌñana Maijaꞌquë cocare quëaquë dajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ñeje caquë: “Maꞌtëmo cua̱ñeñe jaꞌyere paꞌiji. Ja̱ doꞌire ja̱ꞌrë cuasaseꞌe je̱oni po̱nëjëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Iquë Juan yoꞌo ja̱ꞌñere Maijaꞌquëre quëacaiquë Isaías toyaꞌa̱jiꞌi, ñeje: Cue̱ne yejapi pa̱i ñeje cuiye asa cua̱ñoji. Ne deꞌhuajë̱ꞌë, Ëjaërepa maꞌare. Nui maꞌarepa huiꞌyocaijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan juꞌi ca̱ camello nañapi nesico pajiꞌi. Cuiꞌne i̱ të̱ica̱je ca̱ꞌni me pajiꞌi. Ja̱je paꞌipi pu̱ꞌsuni a̱jiꞌi. Cuiꞌne mejaë payare o̱cuequë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalén daripë paꞌicohuaꞌi, cuiꞌne siꞌaohuaꞌi Judea yeja paꞌicohuaꞌije̱, cuiꞌne Jordán tsiaya jaꞌye maca paꞌicohuaꞌije̱ i̱ quëaye daijë asahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ja̱ohuaꞌipi i̱ohuaꞌi coꞌaye yoꞌoseꞌere oijë quëacohuaꞌini Juanpi Jordán tsiayana dopi. ");
INSERT INTO seyNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ja̱je yoꞌoquëna, jai pa̱i fariseohuaꞌi cuiꞌne saduceohuaꞌi co̱ni oco do cua̱ñoñuꞌu cajë daijëna, Juanpi ñani capi, ja̱ohuaꞌire: “¡A̲ña tsëcapë acohuaꞌi! ¿Nepi mësarute quëareꞌni, Maijaꞌquë nejoñe, ti̱ꞌañere jëajë̱ꞌë, cajë? ");
INSERT INTO seyNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ja̱je paꞌito nuñerepa po̱nësicohuaꞌi yoꞌoyere yoꞌojë̱ꞌë, ti̱ña ñañerepa ja̱ꞌnë paꞌiseꞌe je̱oni. ");
INSERT INTO seyNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Cuiꞌne mësaruja̱ꞌa sa̱ꞌñe yëquë Abraham tsëcapë acohuaꞌi aꞌë camaꞌpë paꞌijë̱ꞌë. Care payë, Maijaꞌquëpi iye quë̱na pë̱aque i̱pi yëni Abraham tsëcapëre neñe paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ja̱je paꞌina, tsu̱ꞌupo tsoe niusicoa, so̱quë ñëa cue̱jaꞌcore. Siꞌa so̱quë ñëa deꞌo ca̱ quë̱i maꞌñe cue̱ni ta̱oni ëo ja̱ꞌñe aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Yëꞌë nuñerepa ocopi doyë, mësarute, ja̱ꞌnë cuasaseꞌe je̱oñere i̱ño ja̱ꞌñere. Ja̱je paꞌiquëtaꞌare jeteyoꞌje daiquë api. Ja̱ëpi yuretaꞌa Maijaꞌquë joyopi cuiꞌne toapi doja̱ꞌquë api, jerepa paꞌipi. Yëꞌë cato i̱te deꞌoye necaiye ti̱ꞌamaꞌquë aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tsoe i̱ jë̱tëpi pala ca̱jiji, trigo ne deꞌhuaquë joroseꞌe ti̱rona huahueja̱ꞌcore. I̱ti ca̱re paseꞌe huëꞌena deꞌhuaquë, i̱ti joroseꞌe se yayamaꞌa toana ëoja̱ꞌquë api.” ");
INSERT INTO seyNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Juanpi doja̱quë caquë Jesús Galileapi Jordán tsiayana dajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ja̱je daquëna, Juan duꞌru macarepa coepi, doye. Ja̱je coequë capi, Jesure: “Yëꞌëpi mëꞌëni do cua̱ñoꞌñe paꞌi aꞌë. ¿Me yoꞌoquë yëꞌë quëꞌrona daquëꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Caquëna, Jesús i̱te capi: “Yureseꞌe ja̱je paꞌija̱quë. Coa Maijaꞌquë yëyeje̱ paꞌye yoꞌoye paꞌiji.” Caëna, ja̱ maca Juanpi sehuoni dopi. ");
INSERT INTO seyNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesús do cua̱ñosiquëpi tsiayapi tu̱masi maca, maꞌtëmopi huiꞌyo sai maca Jesús ñapi, Maijaꞌquë joyopi suꞌteje̱ paꞌipi i̱ si̱opë quëꞌrona nëca meina. ");
INSERT INTO seyNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ja̱ maca maꞌtëmopi yëꞌoseꞌe ñeje pi̱siquëna, asahuë: “Iquë api, yëꞌë mamaquë. Ja̱ëni sihuaquë paꞌiyë.” ");
INSERT INTO seyNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ja̱ jeteyoꞌje Maijaꞌquë joyopi sai sapi, cue̱ne yejana, huati neñajaquë caquë. ");
INSERT INTO seyNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ja̱rote pajiꞌi, cuarenta muꞌseña cuiꞌne cuarenta ñamiña ti a̱o a̱imaꞌquëpi. Ja̱je paꞌina, a̱o ëaye nëjiꞌi, i̱te. ");
INSERT INTO seyNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ja̱ maca huatipi Jesure tsio dani neñasiꞌi caquë capi: “Maijaꞌquë mamaquërepa pani iye quë̱na pë̱are pan deꞌhuajë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ja̱je caquëna, Jesupi i̱te sehuopi: “Toyaseꞌe caji: Coa pan a̱iñe mañapi paꞌiye peoji, pa̱i. Coa ai jerepa Maijaꞌquë cayere yoꞌoyepi paꞌiye paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ja̱ maca huatipi Jerusalénna sapi, Maijaꞌquëre se̱ huëꞌe ë̱mëjeꞌena. ");
INSERT INTO seyNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Cuiꞌne ja̱rona capi, i̱te: “Maijaꞌquë mamaquërepa pani i̱ñopi to̱mejëꞌë, yejana. Toyaseꞌe caji, ñeje: Maijaꞌquëpi i̱ hui̱ñaohuaire cua̱ñeina, jë̱ñapi tse̱ꞌe pajëna, quë̱na pëna i̱ quë̱o jaꞌhua aꞌsi to̱meñe peoye to̱mejaꞌquë api.” ");
INSERT INTO seyNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Caquëna, Jesupi i̱te sehuopi: “Yequë hue̱ꞌñapi toyaseꞌeje̱ caji: ‘Mëꞌë Ëjaë Diusure neñasiꞌi caquë yoꞌomaꞌë paꞌijë̱ꞌë.’ ” ");
INSERT INTO seyNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ti̱jupë huatipi sa co̱pi, jai cu̱tihuëna. Ja̱rona sani siꞌa yejaña paꞌiyere cuiꞌne siꞌaye i̱o deꞌoyere i̱ñopi. ");
INSERT INTO seyNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","I̱ñoquë capi, i̱te: “Yëꞌëpi mëꞌëre siꞌaye iyere i̱sisiꞌi, mëꞌëpi yëꞌëni doꞌre jaꞌruni deꞌoquëre pani caquë paꞌito.” ");
INSERT INTO seyNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Caquëna, ja̱ maca Jesupi i̱te capi: “Saijë̱ꞌë, Satanás. Toyaseꞌe caji: Mëꞌë Ëjaë, Diusuni deꞌoquëre paꞌni caquë sihuajë̱ꞌë. Cuiꞌne ja̱ëseꞌere teꞌire necaijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ja̱ maca Jesure jo̱sa yoꞌosiquë huati saquëna, hui̱ñaohuaꞌi dani deꞌoyerepa necaëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Juan co cua̱ñosiquë paꞌiji. Asani Galilea yejana sajiꞌi, Jesús. ");
INSERT INTO seyNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ja̱je saisiquëtaꞌa pëamaꞌë pajiꞌi, Nazaret daripë. Pëamaꞌë Capernaum daripëna sani pajiꞌi, jaira të̱ꞌtëpa paꞌicona, Zabulón cuiꞌne Neftalí yeja quëꞌrona. ");
INSERT INTO seyNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ja̱je yoꞌopi, Isaías Maijaꞌquëre quëacaiquë toyaquë paꞌiseꞌepi ti̱ꞌajaquë caquë i̱ toyaseꞌe caji: ");
INSERT INTO seyNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zabulón cuiꞌne Neftalí yeja paꞌicohuaꞌipi, Jai tsiaya të̱ꞌtëpa maꞌa paꞌicohuaꞌipi, Jordán tsiaya je te̱ꞌte paꞌicohuaꞌipi, Galilea judío pa̱i peo hue̱ꞌña paꞌicohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nea hue̱ꞌñare paꞌisicohuaꞌipi Jaiye miañere ñahuë. Cuiꞌne ju̱ꞌiñepi tëhuosicohuaꞌi paꞌisicohuaꞌini, Miañere papi ñata saopi.” ");
INSERT INTO seyNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ja̱ maca Jesús quëa huëopi, ñeje caquë: “Ja̱ꞌnë cuasaseꞌe je̱oni po̱nëjëꞌë, maꞌtëmo cua̱ñeñe jaꞌyere paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesús Galilea jaira të̱ꞌtëpaja̱ꞌa saiquëpi ja̱ maca ñapi, cayahuaꞌire, yoꞌjeipi cuiꞌne majaꞌyëpi paꞌijëna. Simón ja̱re i̱pi yequë mami Pedro hueꞌequëpi, cuiꞌne i̱ yoꞌjei Andrés paëꞌë. Huaꞌi yoꞌecohuaꞌi sëte tsiayana yoꞌeñuꞌu cajë yoꞌe nëare je̱a dësohuë. ");
INSERT INTO seyNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ja̱ maca Jesús capi, ja̱ohuaꞌire: “Tuijë̱ꞌë, yëꞌëni. Yëꞌëpi pa̱ire yoꞌecohuaꞌire nesiꞌi, mësarute.” ");
INSERT INTO seyNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ja̱je ca maca i̱ti macapi i̱ohuaꞌi yoꞌe nëa se je̱oni i̱ ja̱ꞌre co̱ni saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Aꞌri maña se̱ña maca Jesús saiquëpi ñapi, cuiꞌne cayaohuaꞌire yoꞌjeipi, majaꞌyëpi paꞌijëna. Ja̱ohuaꞌi cato Zebedeo mamajë paëꞌë, Jacobo cuiꞌne Juan. Ja̱ohuaꞌipi pëca jaꞌquë ja̱ꞌre co̱ni i̱ohuaꞌi yoꞌe nëare que̱ꞌquejë jai yohuëre paëꞌë. Paꞌijëna, ja̱ohuaꞌire Jesupi soipi. ");
INSERT INTO seyNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Soina, i̱ti macapi yohuëre je̱oni cuiꞌne pëca jaꞌquëre saiyë cani i̱ ja̱ꞌre co̱ni saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús siꞌa hue̱ꞌña Galilea quëꞌro yeꞌyaroja̱jiꞌi, pa̱i tsiꞌsi hue̱ꞌñana. Deꞌo cocare quëaquë, cuiꞌne Maijaꞌquë cua̱ñeñe ayere quëaquë cuiꞌne siꞌa ju̱ꞌi dahuë jujuquë cujiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ja̱je yoꞌoquëna, Jesús yoꞌoye Siria yeja paꞌicohuaꞌi asahuë. Asani siꞌaohuaꞌi ai yoꞌocohuaꞌire dahuë, i̱ quëꞌrona. Aꞌsi ju̱ꞌicohuaꞌire, coꞌa joyo hueꞌecohuaꞌire, hueꞌhue dahuë ju̱ꞌicohuaꞌire, cuiꞌne quëꞌquë dahuë ju̱ꞌicohuaꞌire dahuë. Dajëna, Jesupi jujupi. ");
INSERT INTO seyNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ja̱je yoꞌoquëna, jai pa̱i Galilea acohuaꞌipi Decápolis paꞌicohuaꞌipi, Jerusalén paꞌicohuaꞌipi, cuiꞌne Judea yeja paꞌicohuaꞌipi cuiꞌne Jordán tsiaya je te̱ꞌte paꞌicohuaꞌipi co̱ni i̱te peꞌtehuë. ");
INSERT INTO seyNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Siꞌa pa̱ire Jesús ñani ai cu̱tihuë mëni ja̱rona jaꞌrupi. Jaꞌruna, i̱te yeꞌyecohuaꞌipi i̱ quëꞌrona tsiꞌsihuë. ");
INSERT INTO seyNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ja̱ maca Jesupi yeꞌya huëopi, ñeje caquë: ");
INSERT INTO seyNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Joyo paꞌiye caraji cajë asacohuaꞌipi sihuacohuaꞌi paꞌiyë, Maꞌtëmo i̱ohuaꞌi tse̱co paꞌiye sëte. ");
INSERT INTO seyNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Oicohuaꞌipi sihuacohuaꞌi paꞌiyë, Maijaꞌquëpi i̱ohuaꞌi oiyere ne deꞌhuacaija̱ꞌquëni. ");
INSERT INTO seyNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Teaye paꞌi aꞌë cuasa joyo hueꞌecohuaꞌi maña sihuacohuaꞌi paꞌiyë, Maijaꞌquë ca nëosi yejare paꞌija̱ꞌcohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Sihuacohuaꞌi paꞌiyë, nuñere pare yoꞌoñuꞌu cajë a̱o ëa ju̱ꞌiñeje paꞌye cuiꞌne oco ëa ju̱ꞌiñeje paꞌye nuñerepa yoꞌoyere yëcohuaꞌi cato. Ja̱je paꞌina, Maijaꞌquëpi co̱caina, deꞌhue yoꞌo ti̱ꞌajaꞌcohuaꞌi aꞌë, i̱ohuaꞌi yëye. ");
INSERT INTO seyNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ai yoꞌocohuaꞌire oijë co̱caicohuaꞌipi sihuacohuaꞌi paꞌiyë, i̱ohuaꞌireje̱ Diusupi oi ñaquë co̱caija̱ꞌquëni. ");
INSERT INTO seyNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Deꞌo joyo hueꞌecohuaꞌi cato sihuacohuaꞌi paꞌiyë, Maijaꞌquëre ñajaꞌcohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Deꞌoye joꞌcua paꞌiyere cajë ai yoꞌocohuaꞌi cato sihuacohuaꞌi paꞌiyë, Maijaꞌquë mamajërepa paꞌija̱ꞌcohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Maijaꞌquë yëyere yoꞌojëna, yecohuaꞌipi sa̱ñope jo̱sa yoꞌojëna, ai yoꞌocohuaꞌi cato sihuacohuaꞌi paꞌiyë, maꞌtëmo i̱ohuaꞌi tse̱co paꞌiye sëte. ");
INSERT INTO seyNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Mësarute pa̱ipi coꞌacohuaꞌi aꞌë cajë, coꞌaye yoꞌojë, cosojë sa̱ñope cacohuaꞌi paꞌito sihuacohuaꞌi paꞌiyë, yëꞌë doꞌire ca cua̱ñojë. ");
INSERT INTO seyNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ai yoꞌosicohuaꞌi cato jaiye maꞌtëmona deꞌhuacaisi coꞌamaña payë. Ja̱je paꞌito ai sihuajë deꞌoye paꞌijë̱ꞌë, coꞌa ju̱ꞌiñe peoyerepa, yure mësarute yoꞌoyeje̱ paꞌye Maijaꞌquëre tsoe quëacaicohuaꞌireje̱ sa̱ñope yoꞌojë paꞌa̱huëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Mësaru aꞌë, a̱sije̱ paꞌiohuaꞌi, iye yeja paꞌini. Ja̱je paꞌiohuaꞌitaꞌa sa̱i ja̱ꞌñere caraja̱isicohuaꞌi pani co̱caiye peoji. Ja̱je paꞌina, ti co̱caiye peocore yejana je̱ocoye paꞌiji, pa̱ipi tsaꞌcujëna, u̱ijaꞌcore. ");
INSERT INTO seyNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Mësaru toaje̱ paꞌiohuaꞌi paꞌiyë, yecohuaꞌire miacaiye iye yeja paꞌini. Pa̱i daripëpi ai cu̱tihuëre paꞌini peoji, catiye. ");
INSERT INTO seyNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mahuë sa̱ꞌnahuëna nëcoja̱ꞌconi toaje̱ tsë̱omaꞌcohuaꞌi aꞌë. Coa ai jerepa huëꞌe paꞌicohuaꞌire miacaija̱ꞌconi ti̱ñarepa nëcocohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ja̱je mësaruje̱ ti̱ñarepa pa̱ire miacaicohuaꞌi paꞌijë̱ꞌë. Ja̱je paꞌijëna, pa̱ije mësaru deꞌoye paꞌiyere ñajë mësaru jaꞌquë maꞌtëmo paꞌiquëre ja̱ohuaꞌije̱ sihuajë deꞌoquë api, caja̱ꞌcohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yëꞌëpi Moisés cua̱ñeseꞌere cuiꞌne Maijaꞌquëre quëacaicohuaꞌi yeꞌyaseꞌere nejosiꞌi caquë daisiquë api cuasamaꞌpë paꞌijë̱ꞌë. Yëꞌë cato ja̱ohuaꞌi caseꞌeje̱ paꞌye yoꞌo ti̱ꞌasiꞌi, caquë daisiquë aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ja̱je paꞌina, nuñerepa cayë, mësarute. Ja̱ yëꞌtaꞌa maꞌtëmo cuiꞌne yeja paꞌito cua̱ñeseꞌere teꞌe toya eꞌquehuëje̱ nejoñe peoji, cuiꞌne teꞌe coca yëꞌopoje̱. Ja̱je paꞌina, siꞌaye ca nëoseꞌe ti̱ꞌa macaja̱ꞌa paꞌi ja̱ꞌñe aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ja̱je paꞌina, iye cua̱ñeseꞌe ayere deꞌoye sehuomaꞌquëpi ai aꞌriquë macapi, pa̱ini i̱ yoꞌoyeje̱ paꞌye se yeꞌyasiquë pani, ai aꞌriquë maca maꞌtëmo cua̱ñe hue̱ꞌñana paꞌija̱ꞌquë api. Ja̱je paꞌiquëtaꞌare deꞌoye sehuocaiquëpi yecohuaꞌire i̱ yoꞌoyeje̱ paꞌye se yeꞌyasiquë cato Maijaꞌquë cua̱ñe te̱ꞌtena jaiquë paꞌija̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ja̱je paꞌina, mësarute cayë. Mësarupi cua̱ñeseꞌe yeꞌyacohuaꞌire cuiꞌne fariseohuaꞌire tëto sani nuñerepa Maijaꞌquë yëyere yoꞌomaꞌcohuaꞌi pani maꞌtëmo cacaye peoji. ");
INSERT INTO seyNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Mësarupi asahuë, mësaru aiohuaꞌire caseꞌe: ‘Huani je̱omaꞌë paꞌijë̱ꞌë. Ja̱je paꞌiquëtaꞌare huani je̱osiquë pani paꞌito i̱ yoꞌosi doꞌire sa̱iñe paꞌiji cajë ña deꞌhuaye paꞌiji.’ ");
INSERT INTO seyNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ja̱je paꞌiquëtaꞌare yëꞌëpi cayë, coa yoꞌjeire pë̱isiquëje̱ i̱ pë̱isi doꞌire sa̱iñe paꞌina. Ña deꞌhua cua̱ñoñe paꞌiji cuiꞌne yoꞌjeire tea ju̱ꞌiquëreje̱ i̱ tea ju̱ꞌi doꞌire sa̱iñe paꞌina, ca tëji ëjaohuaꞌipi ña deꞌhuaye paꞌiji. Cuiꞌne yoꞌjeire huesë ai caquë cato toa yejana saiyere paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ja̱je paꞌiye sëte, Maijaꞌquëre i̱sisiꞌi caquë saquëpi mëꞌë yoꞌjeipi mëꞌëre sa̱ñope caye payere cuasani. ");
INSERT INTO seyNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","I̱ti macana mëꞌë i̱sisiꞌi caquë saye o̱ani coꞌini mëꞌë yoꞌjei ja̱re cajei deꞌojë̱ꞌë. Ja̱ maca yuretaꞌa sani mëꞌë i̱sisiꞌi caquë daseꞌe Maijaꞌquëna i̱sijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ja̱je paꞌina, mëꞌëni coꞌaye yoꞌopi caquë yequëpi, pa̱i yoꞌoye ña deꞌhua hue̱ꞌñana saquë paꞌito i̱ti mëꞌëre coꞌaye yoꞌopi caquë saquëni ja̱ sai maꞌana ca deꞌhuajë̱ꞌë, pa̱i yoꞌoye ñaquëna, quëaye pa̱jaꞌquëre. Pa̱ñe cato pa̱i yoꞌoye ñaquëna, quëaëna, asani ja̱ëpi yuretaꞌare mëꞌëre pa̱ire cocohuaꞌina se cua̱ñeina, co hue̱ꞌñana coja̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nuñerepa cayë, cosi maca yuretaꞌa, ja̱ropi etaye peosipi, mëꞌë curiquë të̱ꞌña maña siꞌaye sa̱imaꞌë pani. ");
INSERT INTO seyNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Mësarupi asacohuaꞌi aꞌë, tsoe caseꞌe: ‘Yequë nëjore yoꞌomaꞌpë paꞌijë̱ꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ja̱je paꞌiquëtaꞌare yëꞌëpi cayë. Nomioni yëjë ëaye ñasicohuaꞌi pani, tsoe yeconi nomiore yoꞌoseꞌe paꞌiji, joyopi i̱ote se cuasaseꞌepi. ");
INSERT INTO seyNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ja̱je paꞌina, mëꞌë ëja te̱ꞌte ñacoapi tayoyena ne ta̱oco paꞌito dutani soꞌona je̱ocojë̱ꞌë. Ai jerepa deꞌoji, mëꞌë ca̱pë acoseꞌere nejoñepi siꞌa mëꞌë ca̱pë toa yejana nejo cua̱ñoñe pa̱jaꞌcore. ");
INSERT INTO seyNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Cuiꞌne yeque pa̱nitaꞌa, mëꞌë ëja te̱ꞌte jë̱tëpi tayo yoꞌoyena sa yëto tëto tëani soꞌona je̱ocojë̱ꞌë. Ai jerepa deꞌoji, teꞌe te̱ꞌte ca̱pë nejoto siꞌa ca̱pë toa yejana nejo cua̱ñoñe pa̱jaꞌcore. ");
INSERT INTO seyNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ja̱ꞌnë tsoe caseꞌe paꞌiji: ‘Nëjore je̱oquë pani i̱ti je̱oco doꞌire quëaquë toyasi jaꞌhuare i̱siye paꞌiji.’ ");
INSERT INTO seyNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ja̱je paꞌiquëtaꞌare yëꞌëpi cayë. Ë̲jëpi yequë ë̱mëohuaꞌire yoꞌomaꞌconi nëjore coa je̱ocoquë pani i̱ doꞌire yequë ë̱mëre yoꞌoja̱core neji. Ja̱je paꞌina, je̱ocosiconi yequëpi huejani yequë nëjore yoꞌoquë deꞌoji. Ja̱ doꞌire siꞌa jupë coꞌaye yoꞌo huesëyë. ");
INSERT INTO seyNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Mësarupi asacohuaꞌi aꞌë, tsoe acohuaꞌire caseꞌe: ‘Mai Ëjaë ña hue̱ꞌñana care payë ca huesosicohuaꞌi cato ja̱re neñe paꞌiji, i̱ti ca nëoseꞌe.’ ");
INSERT INTO seyNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ja̱je paꞌiquëtaꞌare yëꞌëpi cayë. Yequena se ca coꞌija̱ijë care payë cajë camaꞌpë paꞌijë̱ꞌë. Maꞌtëmona se ca coꞌija̱ijë care payë camaꞌpë paꞌijë̱ꞌë. Ja̱ro cato Maijaꞌquë ñuꞌi saihuë aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Yejana se ca coꞌija̱ijë care payë camaꞌpë paꞌijë̱ꞌë. Ja̱roje̱ Maijaꞌquë tsaꞌcupa hue̱ꞌñaꞌë. Jerusalénna se ca coꞌija̱ijë care payë camaꞌpë paꞌijë̱ꞌë. Ja̱oje Mai Ëjaërepa daripë aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Cuiꞌne mëꞌë si̱opëna coꞌye ca coꞌija̱i care payë camaꞌë paꞌijë̱ꞌë. Je pojaꞌicore cuiꞌne neacore ne ti̱ꞌañuꞌju cayeꞌni. Coa Maijaꞌquëseꞌe neñe paꞌiji. Ja̱je paꞌito ja̱je caye pa̱jëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Coa teꞌe nuñe cajë̱ꞌë, ‘jaëꞌë’ pa̱nitaꞌa ‘pa̱ñë’. Ja̱je paꞌiquëtaꞌare ai jerepa se tuajë caye cato huati aye aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Mësarupi asacohuaꞌi aꞌë, Moisés cua̱ñeseꞌe caye: ‘Yequë ñacoare nejocaiquë pani i̱ ñacoapi sa̱iñe paꞌiji. Cuiꞌne yequë cu̱jire tëto jëyoquë pani i̱ cu̱jipi sa̱iñe paꞌiji, cuiꞌne nejo cua̱ñoquë.’ ");
INSERT INTO seyNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ja̱je paꞌiquëtaꞌare yëꞌëpi cayë, mësarute. Coꞌa pa̱ire sa̱ñope sa̱imaꞌpë paꞌijë̱ꞌë. Coa ai jerepa tsiana tëtoquë paꞌito, yequë te̱ꞌte tsiaje̱ nëocaijë̱ꞌë, tëtoja̱quë. ");
INSERT INTO seyNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Cuiꞌne, yecohuaꞌipi mëꞌëre i̱sijë̱ꞌë cajë, mëꞌë camisare jio paꞌito, dëi juꞌi ca̱je i̱sijë̱ꞌë, saja̱jë. ");
INSERT INTO seyNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Yeque coꞌamañare hueꞌequë teꞌe kilómetro sacaijë̱ꞌë, cajë cua̱ñesicohuaꞌi paꞌito ai jerepa caya kilómetros hueꞌecaijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Yequëpi mëꞌë coꞌamañare se̱quë paꞌito i̱sijë̱ꞌë. Cuiꞌne ne tëjini coꞌyosiꞌi caquë paꞌito i̱sijë̱ꞌë. Coa ë̱semaꞌë paꞌijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Cuiꞌne asacohuaꞌi aꞌë, mësaru tsoe caseꞌe: ‘Oijë̱ꞌë, mëꞌë cajeire, mëꞌëre oiquëni, cuiꞌne mëꞌëre sa̱ñope yoꞌoquëni oimaꞌë paꞌijë̱ꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ja̱je paꞌiquëtaꞌare yëꞌëpi cayë, mësarute. Oijë̱ꞌë, mësarute sa̱ñope yoꞌocohuaꞌire. Mësarute coꞌaye cacohuaꞌire, deꞌoye paꞌi ja̱ꞌñere cacaijë̱ꞌë, mësarute coecohuaꞌire deꞌoye yoꞌojë̱ꞌë cuiꞌne mësarute tea ju̱ꞌijë cuiꞌne coꞌaye yoꞌocohuaꞌire oijë Maijaꞌquëre se̱cacaijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ja̱je mësaru yoꞌojë Maijaꞌquë mamajë paꞌija̱ꞌcohuaꞌi aꞌë, i̱ yoꞌoyeje̱ yoꞌojë. I̱ je̱ꞌquë coꞌacohuaꞌire, cuiꞌne deꞌocohuaꞌire ë̱sëcaiye necajiꞌi. Cuiꞌne ocoyeje̱ siꞌaohuaꞌire necajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ja̱je paꞌiquëtaꞌare mësarupi mësarute oicohuaꞌiseꞌere deꞌoye yoꞌojë paꞌicohuaꞌi pani, ¿Iquëre mësaru i̱si cua̱ñojaꞌcohuaꞌi aꞌni, ja̱ yoꞌosi doꞌipi? Curiquë paꞌi doꞌi se̱cohuaꞌi yoꞌoyeje̱ yoꞌosicohuaꞌi pani. ");
INSERT INTO seyNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mësaru yoꞌje tsi̱seꞌere pëpajë yoꞌoni ¿I̱quere deꞌoye yoꞌoyeꞌni? Siꞌahuaꞌi Maijaꞌquëre sehuomaꞌcohuaꞌi yoꞌoyere yoꞌoni. ");
INSERT INTO seyNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nuñerepa deꞌoye yoꞌocohuaꞌi paꞌijë̱ꞌë, mësaru jaꞌquë nuñe yoꞌoquë maꞌtëmo paꞌiquëje̱ paꞌiohuaꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Pa̱ini deꞌoye yoꞌoyere i̱ñoñuꞌu cajë yoꞌomaꞌpë paꞌijë̱ꞌë. Ja̱je cuasajë yoꞌocohuaꞌire cato mësaru jaꞌquë maꞌtëmo paꞌiquëpi deꞌhuacaisi coꞌamaña i̱siye peoji. ");
INSERT INTO seyNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ja̱je paꞌina, mësarupi peocohuaꞌini co̱caisicohuaꞌi pani siꞌa pa̱i asaja̱jë cajë caroja̱imaꞌpë paꞌijë̱ꞌë, coa cacohuaꞌi yoꞌoyeje̱. Ja̱ohuaꞌi cato pa̱i tsiꞌsisi huë̱ꞌñana cuiꞌne maꞌañana caroja̱icohuaꞌi aꞌë, pa̱ipi deꞌocohuaꞌi aꞌë, caja̱jë cajë. Ja̱je paꞌina, yëꞌë mësarute nuñerepa cayë, ja̱je yoꞌocohuaꞌi cato tsoe payë, i̱ohuaꞌi yoꞌo doꞌire i̱si cua̱ñoseꞌe pa̱i sihuacaiyere. ");
INSERT INTO seyNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ja̱je paꞌina, mëꞌëpi peocohuaꞌire coꞌamaña i̱siquë pani, mëꞌëseꞌe yahuerepa i̱si tëjijë̱ꞌë, mëꞌë deꞌo cajeireje̱ quëaye peoye. Coa ne maꞌñeje paꞌi paꞌijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Coa yahue yoꞌojë̱ꞌë. Cuiꞌne mëꞌëpi ja̱je yahue yoꞌoquëna, më Jaꞌquëseꞌe ñasiquëpi mëꞌëre coꞌamaña i̱sisipi, deꞌhuacaiseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Cuiꞌne mësarupi se̱cohuaꞌi pani coa cacohuaꞌi yoꞌoyeje̱ yoꞌomaꞌpë paꞌijë̱ꞌë. Coa cacohuaꞌi cato pa̱i tsiꞌsisi huë̱ꞌñana huëni nëcani cuiꞌne maꞌaña so̱nohuëapi se̱ñere yëcohuaꞌi aꞌë, pa̱ipi ñajajë cajë. Care payë, ja̱ yoꞌoseꞌepi tsoe payë, i̱ohuaꞌi yoꞌo doꞌire i̱si cua̱ñoseꞌe pa̱i sihuacaiyere. ");
INSERT INTO seyNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ja̱je paꞌina, mëꞌëpi se̱quë pani mëꞌë tuꞌrihuëna cacani eta saꞌro si̱oni më jaꞌquë mëꞌë ja̱ꞌre co̱ni paꞌiquëni se̱jëꞌë, ja̱ropi. Ja̱ maca mëꞌë jaꞌquë mëꞌë yahue yoꞌoye ñaquëpi, mëꞌëre deꞌhuacaisi coꞌamañare i̱sija̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Maijaꞌquëre se̱ maca cuiꞌna yëꞌore ca co̱maꞌpë paꞌijë̱ꞌë, doꞌi peoyepi. Maijaꞌquëre sehuomaꞌcohuaꞌipi jaiye teꞌoni cajëna, Diusu asacasipi cajë cuasacohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ja̱ohuaꞌije̱ paꞌiohuaꞌi paꞌimaꞌpë paꞌijë̱ꞌë, mësaru cato. Mësaru jaꞌquë cato tsoe ñaji, mësarute caraye ja̱ yëꞌtaꞌa mësaru i̱te se̱maꞌnë. ");
INSERT INTO seyNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ja̱je paꞌina, mësarupi se̱cohuaꞌi pani ñeje se̱jëꞌë: ‘Maꞌtëmo paꞌiquë yëquë jaꞌquë, Deꞌoyere paꞌë caseꞌe paꞌija̱quë, mëꞌë mami. ");
INSERT INTO seyNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mëꞌë cua̱ñeñepi daija̱quë yëquëna. Mëꞌë yëyepi yoꞌoye paꞌija̱quë, iye yejaje̱ ja̱ro maꞌtëmo yoꞌoyeje̱ paꞌye. ");
INSERT INTO seyNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Yurepi i̱sijë̱ꞌë, a̱o mañaje yëquëre caraye. ");
INSERT INTO seyNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Yëquë coꞌaye yoꞌoseꞌere oi ne deꞌhuacaijë̱ꞌë, yequëre coꞌaye yoꞌosicohuaꞌire yëquë oijë ne deꞌhuacaiyeje̱ paꞌye. ");
INSERT INTO seyNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Yëquëre neñañepi daina, coa ñamaꞌë, coꞌayere esa nejocaijë̱ꞌë. Mëꞌë tse̱ aꞌë cua̱ñeñe, jerepa paꞌi paꞌiye cuiꞌne deꞌoyerepa, caraja̱iñe peoyerepa. Ja̱je paꞌija̱quë.’ ");
INSERT INTO seyNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ja̱je paꞌina, mësarute coꞌaye yoꞌocohuaꞌire oijë ne deꞌhuacaijë̱ꞌë. Mësarupi ja̱je yoꞌocohuaꞌi paꞌito, Diusu maꞌtëmo paꞌiquëje̱ mësaru tayoyere oi ne deꞌhuacaija̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ja̱je paꞌiquëtaꞌare mësarupi yecohuaꞌire coꞌaye yoꞌoyere oijë paꞌija̱quë cajë ne deꞌhuacaiye pa̱to mësaru jaꞌquë maꞌtëmo paꞌiquëje̱ mësaru tayo yoꞌoyere oi ne deꞌhuacaiye pa̱sipi. ");
INSERT INTO seyNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ja̱je paꞌina, mësarupi a̱o a̱imaꞌpë se̱cohuaꞌi pani coa cacohuaꞌi yoꞌoyeje̱ paꞌye oiyeje̱ paꞌi tsia neni yoꞌomaꞌpë paꞌijë̱ꞌë. Ja̱je yoꞌocohuaꞌi cato pa̱ipi a̱o a̱imaꞌcohuaꞌipi yoꞌoyë caja̱jë cajë yoꞌoyë. Care payë, ja̱je yoꞌoni tsoe iye yejana payë, deꞌhuacaisi coꞌamaña. ");
INSERT INTO seyNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ja̱je paꞌiquëtaꞌare mëꞌëpi a̱o a̱imaꞌquëpi se̱quë pani, tsia si̱ꞌsini cuiꞌne nañaje deꞌoye yojë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Mëꞌë a̱o a̱imaꞌquëpi se̱ñe pa̱ije ña ti̱ꞌañe pa̱jaꞌcohuaꞌire, coa mëꞌë jaꞌquë mëꞌë ja̱ꞌre co̱ni paꞌiquëseꞌe asaja̱quë, mëꞌëre deꞌhuacaisi coꞌamaña i̱sija̱ꞌquëseꞌe. ");
INSERT INTO seyNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Iye yejana jaiye coꞌamaña tsiso ti̱mëmaꞌpë paꞌijë̱ꞌë, puꞌju a̱i hue̱ꞌñana, coꞌamaña ne huesë hue̱ꞌñana, coꞌamaña ñacohuaꞌi cacajë i̱ma hue̱ꞌñana. ");
INSERT INTO seyNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ai jerepa maꞌtëmo coꞌamañana tsiꞌso ti̱mëjëꞌë, puꞌjuje̱ a̱imaꞌtona, coꞌamañaje ne huesëmaꞌtona, cuiꞌne coꞌamaña yahue i̱mamaꞌtona. ");
INSERT INTO seyNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ja̱ maca yuretaꞌa mësaru joyopi coꞌamaña paꞌi hue̱ꞌñare cuasajë paꞌija̱ꞌcohuaꞌi aꞌë, mëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Më ñaco ca̱ cato mëꞌë ca̱pë miacaiye aꞌë. Ja̱je paꞌina, mëꞌë ñaco ca̱pi deꞌoye paꞌito, siꞌao mëꞌë ca̱pëje̱ i̱o miacaiyere pasipi. ");
INSERT INTO seyNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ja̱je paꞌiquëtaꞌare mëꞌë ñaco ca̱pi coꞌayere cuasaquë ñañe paꞌito, siꞌa mëꞌë ca̱pëje̱ nea hue̱ꞌñare paꞌiji. Ja̱je paꞌina, mëꞌë ñañepi neaꞌñere paꞌito, ¡ñaco ca̱ neañe jerepa neañe paꞌiji, yequeje̱! ");
INSERT INTO seyNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Teꞌipi caya ëjaohuaꞌire necani ti̱ꞌañe peoji. Ja̱je paꞌina, yoꞌo jujani yequëni coequë, yequëni oiye paꞌiji pa̱nitaꞌa yequëni deꞌoye sehuoquë, yequëni deꞌoye sehuomaꞌë sa̱ñope caye paꞌiji. Ja̱je paꞌina, Maijaꞌquëre cuiꞌne curiquëre necani ti̱ꞌañe peoji. ");
INSERT INTO seyNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Mësarute cayë, ¿jere a̱ijaꞌcohuaꞌi aꞌni? ¿jere u̱cujë paꞌija̱ꞌcohuaꞌi aꞌni? pa̱nitaꞌa ¿jere ca̱ña juꞌija̱ꞌcohuaꞌi aꞌni? cuasajë coꞌa ju̱ꞌimaꞌpë paꞌijë̱ꞌë, caquë. Mësaru paꞌiyepi a̱o a̱iñe jerepa doꞌi quëꞌye aꞌë. Cuiꞌne ca̱pëpi ca̱ña jerepa doꞌi quëꞌye aꞌë. Ja̱je paꞌito ¿me airepa coꞌa ju̱ꞌiñeꞌni? ");
INSERT INTO seyNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ñajëꞌë, pi̱ꞌani peo deꞌoto cuꞌicohuaꞌini a̱o ta̱maꞌcohuaꞌitaꞌa, tëamaꞌcohuaꞌitaꞌa tëani huëꞌena deꞌhuamaꞌcohuaꞌitaꞌa, deꞌhue mësaru jaꞌquë maꞌtëmo paꞌiquëpi a̱oquëna, paꞌicohuaꞌini. Mësaru cato pi̱ꞌa jerepa doꞌicohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ja̱je paꞌina, mësaru aquë ¿nepi ai jerepa coꞌa ju̱ꞌi doꞌipi jerepa tsoaquë ai deꞌoja̱ꞌquë aꞌni? ");
INSERT INTO seyNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ja̱je paꞌito ¿Me yoꞌojë ca̱ña juꞌiyere cuasajë coꞌa ju̱ꞌiñeꞌni? Ñajëꞌë, airo deꞌo joro mëañere, coꞌamaña ne maꞌñepi cuiꞌne oya maꞌñetaꞌa, ");
INSERT INTO seyNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","pa̱i ëjaë Salomón maca juꞌiseꞌe se̱ña maca deꞌo joro aꞌë. Deꞌo hue̱ꞌñare pare paꞌinije jorohuëje̱ paꞌirepa juꞌiye pa̱pi. ");
INSERT INTO seyNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ja̱je taya je̱ꞌquë esa pani to̱meñetaꞌa Maijaꞌquëpi deꞌo joro su̱ñacaiji, se ñataquëna, toapi ëo ja̱ꞌñetaꞌa. Ja̱je paꞌina, mësaru pa̱ire pare sëte Maijaꞌquë jerepa deꞌoye ñacasipi. ¡Necaiye pa̱jaꞌquë api, cuasacohuaꞌi maña! ");
INSERT INTO seyNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ja̱je paꞌito, coꞌa ju̱ꞌimaꞌpë paꞌijë̱ꞌë, ‘¿i̱quere a̱ijaꞌcohuaꞌi aꞌni, cajë pa̱nitaꞌa i̱quere u̱cuja̱ꞌcohuaꞌi aꞌni, cajë pa̱nitaꞌa i̱quere juꞌija̱ꞌcohuaꞌi aꞌni?’ cajë. ");
INSERT INTO seyNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Iye yeja pa̱i cato ja̱je cajë oijë paꞌiyë. Ja̱je paꞌiquëtaꞌare mësaru cato payë, jaꞌquëre, maꞌtëmo paꞌiquëre, siꞌaye mësarute caraye ñaquë paꞌiquëre pani. ");
INSERT INTO seyNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ja̱je paꞌina, Maijaꞌquë quëꞌrore cuasajë cuiꞌne i̱ yëyere deꞌoye yoꞌojë paꞌijë̱ꞌë, Ja̱je cuasajë yoꞌocohuaꞌini siꞌaye i̱ti caraye i̱sija̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ja̱je paꞌiye sëte coꞌa ju̱ꞌimaꞌpë paꞌijë̱ꞌë, ñaminaꞌa paꞌi ja̱ꞌñere. Ñaminaꞌa cato yeque coꞌa ju̱ꞌiñere i̱sija̱ꞌcoa. Ja̱je paꞌina, ñaminaꞌa paꞌi ja̱ꞌñere se coꞌa ju̱ꞌimaꞌpë paꞌijë̱ꞌë. Ja̱je paꞌina, muꞌseña ñape ti̱ñe coꞌa ju̱ꞌijë ai yoꞌoye daji. ");
INSERT INTO seyNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yecohuaꞌi tayoyere pa̱i yoꞌoyere ña deꞌhuacohuaꞌi cayeje̱ camaꞌpë paꞌijë̱ꞌë, Maijaꞌquëpi mësaru tayoyere sa̱ñope caye pa̱jaꞌquëre. ");
INSERT INTO seyNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ja̱je paꞌina, mësaru yecohuaꞌire tayoyë caseꞌeje̱ paꞌye, cuiꞌne mësaruteje̱ tayoyë caja̱ꞌquë api cuiꞌne mësaru yecohuaꞌire yoꞌoseꞌeje̱ paꞌye cuiꞌne yoꞌoja̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ja̱je paꞌito ¿me mëꞌë yoꞌjei ñacoa juꞌi neꞌcua ña ti̱ꞌaëꞌni, mëꞌë ñacoa juꞌiconire jai so̱quë tsaroje̱ paꞌiore ña ti̱ꞌamaꞌquëtaꞌa? ");
INSERT INTO seyNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Me mëꞌë ñacoare so̱quë tiroje̱ paꞌiopi juꞌiona, ‘Dajë̱ꞌë. Dutacasiꞌi, mëꞌë ñacoa neꞌcua juꞌicore casiꞌni?’ ");
INSERT INTO seyNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Coa caquë maca! Duꞌru macarepa mëꞌë ñacoa tiro juꞌiconi duta je̱oni, ja̱ maca deꞌoye ñaquë mëꞌë yoꞌjei ñacoa neꞌcua juꞌicoreje̱ dutacaiye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Joꞌya yaina deꞌoyere pare i̱simaꞌpë paꞌijë̱ꞌë, mësaruna coꞌye po̱nëni cu̱cu huesojë peo hue̱ꞌñarepa. Se̱sena mësaru jai doꞌi yiꞌyore o̱ecaimaꞌpë paꞌijë̱ꞌë, tsaꞌcu huesojë. ");
INSERT INTO seyNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","I̱sijë̱ꞌë cajë se̱to Diusupi i̱sija̱ꞌquë api. Coꞌecohuaꞌipi ti̱ꞌajaꞌcohuaꞌi aꞌë. Eta saꞌrona tëꞌcacohuaꞌini huiꞌyocaiye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ja̱je paꞌina, i̱sijë̱ꞌë caquë se̱quëpi i̱si cua̱ñojaꞌquë api. Cuiꞌne coꞌequëpi ti̱ꞌañe paꞌiji. Cuiꞌne eta saꞌrona tëꞌcaquëni huiꞌyocaiye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","I̱que ë̱mëpi ¿Mësaru aquë mamaquëpi panre se̱ina, quë̱na përe i̱siquë paꞌiquëꞌni? ");
INSERT INTO seyNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Pa̱nitaꞌa ¿tsiaya huaꞌini se̱ina, a̱ñani i̱siquë paꞌiquëꞌni? ");
INSERT INTO seyNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ja̱je paꞌina, cayë, mësaru ai coꞌacohuaꞌitaꞌa mësaru mamajëre deꞌo coꞌamañare i̱sicohuaꞌi aꞌë. ¡Ja̱je paꞌiye sëte mësaru jaꞌquë maꞌtëmo aquëpi ai jerepa deꞌo coꞌamañare i̱siye paꞌiji, i̱te se̱cohuaꞌire! ");
INSERT INTO seyNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ja̱je paꞌito, mësaru yecohuaꞌire deꞌoye yoꞌo cua̱ñoñe yëyeje̱ paꞌye cuiꞌne deꞌoye yoꞌojë̱ꞌë, yecohuaꞌire. Ja̱je cua̱ñeji, Moisés cua̱ñeseꞌe cuiꞌne Maijaꞌquëre quëacaicohuaꞌi toyaseꞌeje̱. ");
INSERT INTO seyNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Cacajë̱ꞌë, aꞌri ja̱to saꞌroja̱ꞌa. Nejo hue̱ꞌñana saco cato jai ja̱to saꞌropi cuiꞌne jai maꞌaꞌë. Ja̱ maꞌana jai pa̱i cacayë. ");
INSERT INTO seyNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ja̱je paꞌiquëtaꞌare aꞌri maꞌapi cuiꞌne aꞌri saꞌro aꞌë, paꞌi hue̱ꞌñare pana saco. Ja̱ maꞌa cacacohuaꞌipi aꞌri pa̱i paꞌiyë. ");
INSERT INTO seyNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Deꞌhua ñajëꞌë, cosocohuaꞌire Maijaꞌquë cocare cayë cajë cacohuaꞌire, yëi ñama ca̱ꞌnire su̱ñaseꞌeje̱ paꞌiohuaꞌipi sa̱ꞌnahuë cato yaije̱ paꞌiohuaꞌipi a̱i yëcohuaꞌipi cacohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mësaru ñañe paꞌiji, i̱ohuaꞌi yoꞌoyena. Miu so̱quë yëna tëamaꞌcohuaꞌi aꞌë, cuiyaꞌire. Cuiꞌne ë̱ne ñëna tëamaꞌcohuaꞌi aꞌë, toa pë̱a. ");
INSERT INTO seyNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ja̱je paꞌina, ja̱re deꞌo so̱quë yëpi deꞌo ca̱re quë̱iñe paꞌiji, cuiꞌne coꞌa so̱quë yëpi ja̱re coꞌa ca̱re quë̱iñe paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Deꞌo so̱quë yëpi coꞌa ca̱ quë̱iñe peoji, cuiꞌne coꞌa so̱quë yëpi deꞌo ca̱ quë̱iñe peoji. ");
INSERT INTO seyNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ja̱je paꞌina, siꞌa so̱quë deꞌo ca̱ quë̱i maꞌñe cato cue̱ni toana ëo je̱oꞌñe paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ja̱je paꞌina, mësaru i̱ohuaꞌi yoꞌoyena ñajaꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Yëꞌë, ‘Ëjaë, Ëjaë’, cacohuaꞌipi siꞌaohuaꞌirepa maꞌtëmo cua̱ñe hue̱ꞌña cacamaꞌpë paꞌija̱ꞌcohuaꞌi aꞌë. Ja̱je paꞌina, yëꞌë jaꞌquë maꞌtëmo paꞌiquë yëye yoꞌocohuaꞌiseꞌe cacaja̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","I̱ti muꞌse ti̱ꞌasi maca jai pa̱i yëꞌëre caja̱ꞌcohuaꞌi aꞌë, ‘Ëjaë, Ëjaë, yëquë mëꞌë mamire quëahuë, cuiꞌne mëꞌë mamipi cajë huatiohuaꞌire eto saohuë, cuiꞌne mëꞌë mamipi cajë jaiye pa̱i yoꞌo ti̱ꞌa maꞌñe nehuë.’ ");
INSERT INTO seyNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ja̱je cajëna, yëꞌëpi quëaquë caja̱ꞌquë aꞌë, ja̱ohuaꞌire: ‘Ti ñamaꞌquë aꞌë, mësarute. Yëꞌë quë̱no maca paꞌimaꞌpë saijë̱ꞌë, coꞌayere yoꞌosicohuaꞌi.’ ");
INSERT INTO seyNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ja̱je paꞌina, yëꞌë caye asani cuiꞌne yoꞌoquë cato, quë̱na yejana ta̱ꞌñe asaquëpi, huëꞌe neseꞌeje̱ paꞌi api. ");
INSERT INTO seyNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ja̱je quë̱na yejana nesiconi oconi tsiaña coꞌjeni jai tutu dani yoꞌonije ne ta̱oñe pa̱o. ");
INSERT INTO seyNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ja̱je paꞌiquëtaꞌare yëꞌë caye asaquëtaꞌa yëꞌë cayeje̱ yoꞌomaꞌquë cato mejahuëna huesëquëpi huëꞌe neseꞌeje̱ paꞌi api. ");
INSERT INTO seyNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ja̱je huesëquë nesicopi, oconi tsiaña coꞌjeyena cuiꞌne, tutuyena, huëꞌe ta̱ni meaona, ¡ja̱ maca ai yoꞌoye pajiꞌi!” ");
INSERT INTO seyNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ja̱je Jesús ca tëjisi maca pa̱ipi ai cuasahuë, ¿i̱ yeꞌyayere deꞌoyerepa yeꞌyaquëni cajë? ");
INSERT INTO seyNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","I̱ yeꞌyaye cato cua̱ñequë Ëjaërepa yeꞌyayeje̱ pajiꞌi, pa̱ni cua̱ñeseꞌe yeꞌyacohuaꞌi yeꞌyayeje̱ paꞌye. ");
INSERT INTO seyNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesús ai cu̱tihuëpi cajeina, jai pa̱i i̱te peꞌtehuë. ");
INSERT INTO seyNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Peꞌtejëna, ja̱ꞌju dahuë ju̱ꞌiquëpi Jesús quëꞌrona tsioja̱ni doꞌre jaꞌruni capi. “Ëjaë mëꞌëpi yëꞌëre ju̱ꞌi dahuë jujucaiye yëni necaijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ja̱je caquëna, Jesupi jë̱tëpi patoquë capi: “Yëyë, siꞌsi peoquë paꞌijë̱ꞌë.” Ja̱je ca maca ja̱ꞌju dahuë ju̱ꞌiquë paꞌisiquëpi tsoe deꞌoquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Cuiꞌne ja̱ maca Jesupi capi, i̱te: “I̱na, yecohuaꞌire quëamaꞌpë paꞌijë̱ꞌë. Coa Maijaꞌquë huëꞌere necaiquëseꞌere sani i̱ñojëꞌë. I̱ñoquë Moisés cua̱ñequë paꞌiseꞌere i̱sijë̱ꞌë, Maijaꞌquëna. Ja̱je yoꞌoquëna, siꞌaohuaꞌi ju̱ꞌi dahuë peoquë to̱mesiquëpi yoꞌoji, cuasajë ñajaꞌcohuaꞌire.” ");
INSERT INTO seyNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesús Capernaum yejana sa ti̱ꞌaquëna, teꞌi Capitán romanopi tsio dani i̱te se̱jiꞌi, ");
INSERT INTO seyNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ñeje caquë: “Ëjaë, yëꞌë huëꞌe ñacaiquëpi yëꞌë joꞌyaëpi ju̱ꞌiji. Ti cuꞌimaꞌë cuiꞌne ai aꞌsi ju̱ꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Caquëna, Jesupi capi, i̱te: “Yëꞌëpi sani jujusiꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Caquëna, Capitánpi sehuopi: “Coꞌaquë macaꞌë, Ëjaë, yëꞌë huëꞌena daimaꞌë paꞌijë̱ꞌë. Coa coꞌya ja̱ꞌñeseꞌe se cua̱ñejëꞌë. Ja̱je yoꞌouna, yëꞌëre necaiquëpi coꞌyaja̱quëre. ");
INSERT INTO seyNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ja̱re yëꞌëpi ëjaëohuaꞌipi meñe cua̱ñesiquëpi paꞌiyë. Ja̱je paꞌitaꞌa yëꞌë soldado pa̱ireje̱ se meñe payë, yëꞌë cua̱ñecohuaꞌire. Yëꞌëpi ja̱ohuaꞌi aquëni ‘saijë̱ꞌë’ cato saiji. Cuiꞌne ‘daijë̱ꞌë’ ca maca daiji. Cuiꞌne yëꞌëpi yëꞌë joꞌyaëre ‘ja̱ro nejëꞌë’ caquë cua̱ñeru, yëꞌë cua̱ñeseꞌere nequë api.” ");
INSERT INTO seyNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ja̱je caquëna, Jesús asani ta̱ꞌñerepa caquë aꞌni cuasaquë ñapi, i̱te. Ja̱ maca i̱te peꞌtecohuaꞌire capi: “Nuñerepa cayë, siꞌa Israel pa̱i ti peohuë, iquë cuasayeje̱ ta̱ꞌñe cuasacohuaꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ja̱je paꞌina, yëꞌëpi cayë, jai pa̱i ë̱së mëi hue̱ꞌñapi cuiꞌne ë̱së duꞌi hue̱ꞌñapi daija̱ꞌcohuaꞌi aꞌë, Abraham, Isaac, cuiꞌne Jacobo ja̱ꞌre co̱ni maꞌtëmona a̱ijaꞌcohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ja̱je paꞌiquëtaꞌare i̱ti maꞌtëmo patiꞌñe paꞌiohuaꞌipi nea hue̱ꞌña hueꞌsena je̱ocosicohuaꞌi paꞌija̱ꞌcohuaꞌi aꞌë. Ja̱ropi oijë cu̱ji qui̱ꞌcoja̱ꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ja̱ maca Jesús capitánre capi: “Saijë̱ꞌë mëꞌë huëꞌena, mëꞌë cuasaseꞌeje̱ yoꞌoseꞌe paꞌija̱quë.” I̱ ja̱je ca maca i̱ joꞌyaë coꞌyasiquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pedro huëꞌena Jesupi sajiꞌi. Sani ñapi, Pedro huaopi ca̱i saihuëre su̱ña dahuëre ju̱ꞌicopi u̱iona. ");
INSERT INTO seyNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ñani ja̱ maca i̱ote jë̱tëpi patoquëna, su̱ña dahuë peo hue̱ꞌña je̱ouna, huëni i̱opi i̱te necai huëo. ");
INSERT INTO seyNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ñami deꞌoye jaꞌi maca jai pa̱i Jesús quëꞌrona huati quëꞌiohuaꞌire dahuë. Darena, teꞌe yëꞌopo cayepi huatiohuaꞌire eto saopi, cuiꞌne ju̱ꞌicohuaꞌireje̱ jujupi. ");
INSERT INTO seyNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Iye cato Maijaꞌquëre quëacaiquë Isaías caquë paꞌiseꞌepi ti̱ꞌaëna, yoꞌopi. Ñeje caseꞌepi: “I̱pi mai ju̱ꞌiñere hueꞌequë sajiꞌi cuiꞌne mai ju̱ꞌi dahuëje̱ jujucajiꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesús i̱ quëꞌrona jai pa̱i tsiꞌsijëna, ñani jaira je te̱ꞌtena je̱ñuꞌu ne deꞌhuajë̱ꞌë cua̱ñepi, i̱ yeꞌyacohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Caquëna, ja̱ maca cua̱ñeseꞌe yeꞌyaquëpi Jesús quëꞌrona tsio dani capi: “Yeꞌyaquë, coa siꞌa hue̱ꞌña mëꞌë saina, tuiye yëyë.” ");
INSERT INTO seyNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Caquëna, Jesupi sehuopi, i̱te: “Airo yai mañaje co̱ña pacohuaꞌi aꞌë, cuiꞌne pi̱ꞌaje i̱ohuaꞌi tsianoa pacohuaꞌi aꞌë. Ja̱je pacohuaꞌitaꞌare Pa̱i Mamaquë cato peoquë api, i̱ si̱opë tëoni pëa huajë hue̱ꞌñaje.” ");
INSERT INTO seyNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Caquëna, i̱ yeꞌyacohuaꞌi aquëpi i̱te capi: “Ëjaë, duꞌru yëꞌëtaꞌa yëꞌë jaꞌquëre ta̱jasiꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Caquëna, Jesupi sehuopi, i̱te: “Yëꞌëni peꞌtejë̱ꞌë, i̱ohuaꞌiseꞌe ta̱jajë ju̱ꞌisicohuaꞌire ja̱re cuiꞌne ju̱ꞌisicohuaꞌije̱ paꞌiohuaꞌipi.” ");
INSERT INTO seyNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ja̱ maca Jesús jai yohuëna aya mëni saina, i̱ yeꞌyacohuaꞌije̱ co̱ni saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ja̱je saijëna, jairana ai tutu dapi, yohuëna to̱ꞌañepi cacayerepa. Ja̱je yoꞌotoje̱ Jesutaꞌa ca̱isiquëpi pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Paꞌina, ja̱ maca i̱ yeꞌyacohuaꞌipi i̱te sani ne sëtojë cahuë: “¡Ëjaë, huasojë̱ꞌë! ¡Mai ea duꞌiyë!” ");
INSERT INTO seyNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ca maca i̱pi sehuopi: “¿I̱na me yoꞌojë airepa caꞌrayeꞌni? ¡Mësaru, Maijaꞌquëpi nequë api, cuasayere aꞌri maña payë!” Cani huëni nëcani tuture cuiꞌne coꞌpoyere yoꞌomaꞌo capi. Ca maca jairapi ti yoꞌomaꞌcorepa deꞌo nëcoꞌë, tutuje̱ peoyerepa. ");
INSERT INTO seyNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","I̱ohuaꞌipi ja̱re ñani ai cuasajë cahuë: “¿I̱queire paꞌni, iquë, ja̱ jerepa tutupi cuiꞌne jai tsiayapi asani sehuoquërepa?” ");
INSERT INTO seyNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesús jaira je te̱ꞌtena, Gadara yejana ti̱ꞌasi maca huati quëꞌiohuaꞌipi caya ë̱mëohuaꞌi ju̱ꞌisicohuaꞌire ta̱ hue̱ꞌñapi etani daicohuaꞌipi i̱ quëꞌrona tsio daëꞌë. Cayahuaꞌi huati quëꞌiohuaꞌi paëꞌë. Ja̱je paꞌiohuaꞌipi paꞌijëna, yecohuaꞌije̱ ja̱ maꞌa ti cuꞌiye pa̱huë, ai pë̱ti yëcohuaꞌi paꞌijëna, caꞌrajë. ");
INSERT INTO seyNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ja̱ohuaꞌipi ñani cuihuë, ñeje: “¿Me nesiꞌquë yëquëre jo̱sa yoꞌosiꞌi caquë daquëꞌni, Maijaꞌquë mamaquë? ¿Ja̱ yëꞌtaꞌa nejoñe ti̱ꞌamaꞌnë yëquëre ai yoꞌoyena, nejosiꞌi caquë daquë?” ");
INSERT INTO seyNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ja̱ropi aꞌri maña soꞌore jai se̱se tsëcapë a̱ore a̱ijë nëtëroja̱iëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ja̱je nëtëroja̱ijëna, asajë coꞌa joñoapi Jesure se̱ëꞌë: “Mëꞌëpi yëquëre eto saoquë pani, coa ñajëꞌë yequëseꞌe se̱sena cacaja̱ꞌcohuaꞌire.” ");
INSERT INTO seyNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Cajëna, Jesupi capi: “Deꞌoji, cacajë̱ꞌë.” Caëna, ja̱ maca ja̱ohuaꞌire paꞌisicohuaꞌipi, coꞌa joñoapi etani se̱sena caca maca se̱sepi të̱ꞌtëpaja̱ꞌa huaꞌque to̱mejë jairana dutu ju̱juhuë. ");
INSERT INTO seyNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ja̱ maca se̱sere ñacohuaꞌipi quëquëni huëꞌhuëjë pa̱i daripëna ti̱ꞌani siꞌaye i̱ti yoꞌoseꞌe quëajë cuiꞌne huati quëꞌiohuaꞌi paꞌisicohuaꞌire yoꞌoseꞌeje̱ quëahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Quëajëna, asani pa̱i daripë paꞌicohuaꞌipi siꞌaohuaꞌi Jesús paꞌi hue̱ꞌñana daëꞌë. Dani i̱te ñani se̱iꞌë, saijë̱ꞌë, i̱ño yëquë quëꞌro paꞌimaꞌë, cajë. ");
INSERT INTO seyNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ja̱je cajëna, Jesús asani yohuëna aya mëni jaira je te̱ꞌtena je̱jiꞌi, i̱ paꞌi daripëna. ");
INSERT INTO seyNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ja̱rote paꞌina, quëꞌquë dahuë ju̱ꞌiquëpi ca̱i saihuëre u̱ina, dahuë. Jujuquë api cuasajë yoꞌorena, ñani capi, ju̱ꞌiquëre: “Tsihuaꞌë coꞌya huajësiꞌi caquë yoꞌojë̱ꞌë. Mëꞌë coꞌaye yoꞌoseꞌe yurepi oi ne deꞌhuacaiyë.” ");
INSERT INTO seyNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ja̱je caquëna, cua̱ñeseꞌe yeꞌyacohuaꞌi acohuaꞌipi cuasahuë: “Iquë Maijaꞌquëni cueꞌcuequë ja̱je caji cajë.” ");
INSERT INTO seyNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ja̱je cuasajëna, Jesús asaquë capi, ja̱ohuaꞌire: “¿Me yoꞌojë mësaru coꞌayerepa cuasayere payeꞌni? ");
INSERT INTO seyNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ja̱je paꞌito ¿me cayepi deꞌoquëꞌni, ‘Mëꞌë coꞌaye yoꞌoseꞌere oi ne deꞌhuacaiyë,’ caye, pa̱nitaꞌa ‘huëni saijë̱ꞌë’ caye?” ");
INSERT INTO seyNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ja̱je se cani capi: “Deꞌoji. I̱ñosiꞌi, Pa̱i Mamaquë iye yejare paꞌi tutu quëꞌirepa paꞌiyere, pa̱i tayo coꞌaye yoꞌoyere oi ne deꞌhuacaiyere.” Cani quëꞌquë dahuë ju̱ꞌiquëre capi: “Huëijë̱ꞌë. Huëni mëꞌë u̱i daisicore deꞌhuani huëꞌena saijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ja̱je ca maca quëꞌquë dahuë ju̱ꞌiquëpi huëni i̱ huëꞌena sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Pa̱ipi ja̱ yoꞌoseꞌere ñani ai caꞌrajë Maijaꞌquëre deꞌoquëre paꞌni cajë sihuahuë, pa̱ina Maijaꞌquëpi iye tutu i̱siseꞌere, cuasajë. ");
INSERT INTO seyNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ja̱ yoꞌo sitopi je̱oni sajiꞌi, Jesús. Saisiquëpi Mateore ñapi, paꞌi doꞌi sa̱i hue̱ꞌñare ñuꞌi curiquëre se̱ina. Ñani capi: “Peꞌtejë̱ꞌë, yëꞌëre.” Ja̱je caëna, Mateo huëni i̱ ja̱ꞌre sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mateo huëꞌena a̱o a̱i saihuëre Jesús ñuꞌi a̱ina, paꞌi doꞌi se̱cohuaꞌi cuiꞌne coꞌaye yoꞌocohuaꞌi dani teꞌe Jesús ja̱ꞌre co̱ni a̱o a̱i saihuëre paëꞌë. I̱ yeꞌyacohuaꞌije̱ ja̱rote co̱ni paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ja̱je yoꞌojëna, fariseohuaꞌipi ñani i̱ yeꞌyacohuaꞌire se̱iꞌë. “¿Me yoꞌoquë mësarute yeꞌyaquë curiquë paꞌi doꞌi se̱cohuaꞌi ja̱ꞌre cuiꞌne coꞌaye yoꞌocohuaꞌi ja̱ꞌre co̱ni a̱iquëꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesupi iyere asani capi: “Deꞌoye huajëcohuaꞌi paꞌicohuaꞌipi jujuquëre coꞌemaꞌcohuaꞌi aꞌë. Ju̱ꞌicohuaꞌipi coꞌecohuaꞌi aꞌë, jujuquëre. ");
INSERT INTO seyNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ja̱je paꞌito sani iye toyaseꞌe cayere yeꞌyejë̱ꞌë: ‘Ai yoꞌocohuaꞌire teaye ñani co̱caiyere yëꞌë cato yëyë. Coeyë, nëicohuaꞌire huani i̱siye cato.’ Ja̱je paꞌina, yëꞌë cato daimaꞌë paëꞌë, deꞌocohuaꞌini soisiꞌi caquë. Tayo yoꞌocohuaꞌini caquë daëꞌë, ja̱ohuaꞌipi i̱ohuaꞌi yoꞌoye je̱oni po̱nëjajë caquë.” ");
INSERT INTO seyNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Juan oco doquë yeꞌyacohuaꞌipi Jesure tsio dani se̱iꞌë: “Yëquë cuiꞌne fariseohuaꞌi ja̱ꞌre a̱o a̱imaꞌpë se̱ñe. ¿Me yoꞌojë mëꞌë yeꞌyacohuaꞌiseꞌe yoꞌomapë paꞌiyeꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Cajëna, Jesupi sehuopi: “Mësarupi ñacohuaꞌi aꞌë, hueja po̱së paꞌina, ñañuꞌu cajë daisicohuaꞌije̱ oimaꞌcohuaꞌi paꞌiye. Ja̱je paꞌisicohuaꞌitaꞌare ti̱ꞌajaꞌcoa, hueja po̱sëni yequë muꞌse jio je̱ocaiye. Ja̱ macataꞌa a̱o a̱imaꞌpë se̱jaꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Yecohuaꞌije̱ ai juꞌi ca̱na huajëcopi se sëo deꞌhuamaꞌcohuaꞌi aꞌë, huajëcore se sëosicopi jo̱jajëna, quërësi̱o ai jerepa jaicore ne yeto saoye paꞌiji, ai juꞌi ca̱re. ");
INSERT INTO seyNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Cuiꞌne ai ca̱ꞌni topëna huajë cuiyaꞌi co̱nore ayamaꞌcoa. Ja̱je paꞌiquëtaꞌare ayasico paꞌito ai ca̱ꞌnihuëpi oꞌsaona, joni saiona, siꞌaye oꞌsa co̱no cuiꞌne topë nejoñe paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ja̱ yëꞌtaꞌa Jesús iyere caquëna, Judío pa̱i ëjaëpi ti̱tani i̱ ña hue̱ꞌñana doꞌre jaꞌruni capi: “Yëꞌë mamacopi ja̱ꞌarepa ju̱ni huesëo. Ja̱je paꞌiquëtaꞌare mëꞌëpi dani jë̱ñapi i̱ona patoquë paꞌito cuiꞌnaopi huajëco huëija̱ꞌcoa.” ");
INSERT INTO seyNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Caquëna, Jesupi asani huëni i̱ ja̱ꞌre co̱ni sajiꞌi. Saina, i̱ yeꞌyacohuaꞌi co̱ni saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ja̱ muꞌse siꞌanë tsie cajequëna, doce o̱metëca ju̱ꞌicopi Jesús jeteyoꞌjeja̱ꞌa tsioja̱ni yahuerepa i̱ juꞌi ca̱na pato, ");
INSERT INTO seyNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","I̱ juꞌi ca̱na patoni coꞌyaja̱ꞌcoaꞌë cuasaco. ");
INSERT INTO seyNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ja̱je yoꞌocona, Jesupi coꞌye po̱nëni i̱ote ñani capi: “Coꞌya huajëjë̱ꞌë, tsihuaꞌo, jujuquë api, mëꞌë cuasasi doꞌire.” Ca maca ja̱re i̱ti macapi coꞌyasico pacoꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jesús pa̱i ëjaë huëꞌena ti̱ꞌaquë ñaquëna, musica yoꞌocohuaꞌi ne deꞌhuasicohuaꞌipi paëꞌë, ta̱ maca yoꞌocaija̱ꞌcohuaꞌipi. Paꞌijëna, pa̱ije ai cuijë oicohuaꞌije̱ paëꞌë, i̱ti maca. ");
INSERT INTO seyNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Paꞌijëna, ñani capi: “Etajë̱ꞌë. Tsihuaꞌo ju̱ꞌimaꞌco pacoꞌë, coa ca̱ico.” Ja̱je caquëna, pa̱ipi coa cani cuasajë cueꞌcuejë sohuë. ");
INSERT INTO seyNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ja̱je cuasatoje̱ Jesupi pa̱ire hueꞌsena eto saopi. Eto saoni, cacani tsihuaꞌore jë̱tëpi tse̱aquëna, huajëcorepa huëcoꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ja̱ yoꞌoseꞌere siꞌa hue̱ꞌña ja̱ro paꞌicohuaꞌi asahuë, yecohuaꞌipi se quëajëna. ");
INSERT INTO seyNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ja̱ropi Jesús etani sai maca caya ë̱mëohuaꞌi ñamaꞌcohuaꞌipi ¡David mamaquë yëquëre oijë̱ꞌë! ¡Teaye ai yoꞌoyë! cajë cuijë daëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Huëꞌena Jesús cacasi maca ñamaꞌcohuaꞌipi i̱ quëꞌrona tsio datena, i̱pi se̱jiꞌi, i̱ohuaꞌire: “¿Mësaru yëꞌëpi necaiquë api ñeje paꞌye cuasaye?” Caquëna, i̱ohuaꞌipi cahuë: “Ja̱je cuasayë, Ëjaë.” ");
INSERT INTO seyNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Cajëna, Jesupi i̱ohuaꞌi ñaco ca̱na patoquë capi: “Mësaru cuasaseꞌeje̱ neseꞌe paꞌija̱quë.” ");
INSERT INTO seyNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ca maca ñacohuaꞌi po̱nëhuë. Po̱nësi maca Jesús ja̱ohuaꞌire cua̱ñepi, ñeje caquë: “Deꞌhua yecohuaꞌire quëaye peoyerepa cuꞌijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ja̱je casiquëtaꞌare coa sa etani quëahuë, siꞌa huë̱ꞌña paꞌicohuaꞌire, Jesús i̱ohuaꞌire jujuseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ñamaꞌcohuaꞌi paꞌisicohuaꞌipi eta maca, Jesús quëꞌrona dahuë, coca camaꞌquëre huati quëꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Dasi maca Jesupi huatire eto saouna, coca camaꞌquë paꞌisiquëpi coca ca huëopi. Ja̱je caquëna, pa̱ipi ñani ai cuasahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ja̱je cuasajë fariseo pa̱ipi cahuë: “Iquë cato huatiohuaꞌi ëjaëpi deꞌoye sehuojëna, huatire eto saoji.” ");
INSERT INTO seyNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Pa̱i ñape daripë̱a pa̱i tsiꞌsi huë̱ꞌña paꞌiyena Jesús cuꞌi yeꞌyaroja̱jiꞌi. Maijaꞌquë cua̱ñe te̱ꞌte ayere deꞌo cocare quëaquë. Cuiꞌne siꞌa ju̱ꞌi dahuë jujucai, cuiꞌne aꞌsi ju̱ꞌijë ai yoꞌocohuaꞌireje̱ jujucajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yëi ñama i̱ohuaꞌire ñacaiquëre peocohuaꞌije̱ paꞌiohuaꞌipi pa̱i maña ai yoꞌojë cuiꞌne coꞌa ju̱ꞌijë paꞌijëna, ñani ojiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ja̱je oi i̱ yeꞌyacohuaꞌire capi: “Nuñerepa jaiye aꞌë, tëaye. Ja̱je paꞌiquëtaꞌare necohuaꞌipi aꞌri pa̱i paꞌiyë. ");
INSERT INTO seyNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ja̱je paꞌina, Maijaꞌquëni se̱jëꞌë, i̱ti tse̱ aquëni, ja̱ëpi i̱ti tëacohuaꞌire jëjo daoja̱ꞌquëre.” ");
INSERT INTO seyNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesupi i̱ doce yeꞌyacohuaꞌire soini tutu i̱sipi, huatiohuaꞌire etoye cuiꞌne siꞌa ju̱ꞌi dahuë jujuye cuiꞌne ai yoꞌojë aꞌsi ju̱ꞌicohuaꞌire jujuyeje̱. ");
INSERT INTO seyNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ñeje hueꞌecohuaꞌi paëꞌë. I̱ doce jëjo saocohuaꞌi cato: Simón cuiꞌne ja̱re i̱pi Pedro hueꞌequë pajiꞌi. I̱ yoꞌjei Andrés pajiꞌi. Jacobo cuiꞌne i̱ yoꞌjei Juan paëꞌë, Zebedeo mamajë. ");
INSERT INTO seyNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás paëꞌë. Cuiꞌne Mateo paꞌi doꞌi curiquë tsiꞌsoquë paꞌisiquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Yequë Simónje pajiꞌi, judío pa̱irepa deꞌoye paꞌiyere cuasajë yoꞌo tsëcapë aquë. Cuiꞌne Judas pajiꞌi, Jesure yehuoja̱ꞌquëje̱. ");
INSERT INTO seyNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","I̱ yeꞌyacohuaꞌire Jesús ñeje quëani jëjo saopi: “Judío pa̱i peocohuaꞌi quëꞌro saimaꞌpë caquë cuiꞌne cacamaꞌpë paꞌijë̱ꞌë, Samaria quëꞌroje̱. ");
INSERT INTO seyNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Coa judío pa̱i quëꞌroseꞌe sani quëajë̱ꞌë, yëi ñama ne huesëseꞌeje̱ paꞌiohuaꞌiseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Tsoe ti̱ꞌapi, Maijaꞌquë cua̱ñe te̱ꞌtere paꞌiye, cajë quëajë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ju̱ꞌicohuaꞌire jujucaijë̱ꞌë. Ju̱ꞌisicohuaꞌire ne huëojë̱ꞌë. Si̱ꞌsi dahuë ju̱ꞌicohuaꞌire aꞌsi peocohuaꞌire necaijë̱ꞌë. Huatire eto saojë̱ꞌë. Doꞌi peoye jujucaijë̱ꞌë, mësarute doꞌi peoye i̱siseꞌeje̱ cuiꞌne. ");
INSERT INTO seyNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Curiquë samaꞌpë paꞌijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mësaru juꞌicoseꞌere juꞌijë saijë̱ꞌë. Teꞌe juꞌi ca̱ sajë̱ꞌë. Topëje̱ saye pa̱jëꞌë, zapatoje̱. So̱quë tupëje̱ siꞌaye peocohuaꞌi saijë̱ꞌë. Coꞌamaña nequë cato i̱ ne doꞌipi a̱iquë api. ");
INSERT INTO seyNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ja̱je paꞌina, mësarupi pa̱i daripëna pa̱nitaꞌa teꞌohuaꞌiseꞌe paꞌi hue̱ꞌñana ti̱ꞌasicohuaꞌi pani coꞌejë̱ꞌë, deꞌoye ca pa̱ini. Ti̱ꞌani i̱ huëꞌena pëajë̱ꞌë, quëa tëjini sai macaja̱ꞌa. ");
INSERT INTO seyNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Huëꞌena cacacohuaꞌi pani pëpajë̱ꞌë, deꞌoye paꞌija̱jë cuasacaijë. ");
INSERT INTO seyNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ja̱je pëpajëna, ja̱ huëꞌe paꞌicohuaꞌipi yëjëna, i̱ohuaꞌina deꞌoye paꞌiye je̱ocani pëpani saijë̱ꞌë. Ja̱je paꞌiquëtaꞌare ja̱je pëpajëna, coecohuaꞌi paꞌito, ja̱ pëpaseꞌe jiojë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Cuiꞌne mësarute coꞌejë cuiꞌne asayeje̱ coecohuaꞌi paꞌito, ja̱ maca ja̱ huëꞌepi pa̱nitaꞌa ja̱ daripëpi etani neꞌña mësaru tsaꞌcuseꞌere hueꞌsena ti̱ꞌto to̱jëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nuñerepa cayë. Ja̱je yoꞌosicohuaꞌire sa̱iñe pasipi, pa̱i yoꞌoseꞌe ña muꞌse ti̱ꞌasi maca. Ja̱ maca ja̱ohuaꞌire Sodoma cuiꞌne Gomorra daripë̱a yoꞌoseꞌe se̱ña maca coꞌayere papi yoꞌoye pasipi. ");
INSERT INTO seyNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ai yoꞌoyena mësarute yëꞌë jëjo saoyë, yëi ñamaje paꞌiohuaꞌini yai jopona. Ja̱je paꞌina, a̱ñaje paꞌiohuaꞌi paꞌijë̱ꞌë, ta̱ꞌñe asajë yoꞌocohuaꞌi. Ja̱je paꞌiohuaꞌitaꞌa yecohuaꞌire sa̱ñope nemaꞌcohuaꞌipi suꞌteje̱ paꞌiohuaꞌi paꞌijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Deꞌhua ñajëꞌë, mësarute pa̱ipi coꞌacohuaꞌi aꞌë cajë ëjaohuaꞌina i̱sija̱ꞌcohuaꞌi aꞌë, cuiꞌne tëꞌcaja̱ꞌcohuaꞌi aꞌë, pa̱i tsiꞌsisi huë̱ꞌñapi. ");
INSERT INTO seyNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Cuiꞌne mësarute saja̱ꞌcohuaꞌi aꞌë, cua̱ñecohuaꞌi quëꞌrona cuiꞌne pa̱i ëjaohuaꞌi quëꞌrona, yëꞌë doꞌire. Ja̱je yoꞌojëna, mësaru quëaja̱ꞌcohuaꞌi aꞌë yëꞌë paꞌiye ayere. Ja̱ohuaꞌi asajëna, cuiꞌne judío pa̱i peocohuaꞌi asajëna, quëaja̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mësaruni ëjaohuaꞌina i̱sisicohuaꞌi paꞌito coꞌa ju̱ꞌimaꞌpë paꞌijë̱ꞌë. ‘¿Me caja̱ꞌcohuaꞌi aꞌni?’ cuasajë ca ja̱ꞌñere coꞌemaꞌpë paꞌijë̱ꞌë. Maijaꞌquëpi i̱sija̱ꞌquë api, coca caye ti̱ꞌasi maca. ");
INSERT INTO seyNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Maijaꞌquë joyo i̱siyepi caja̱ꞌcohuaꞌi aꞌë, ja̱je paꞌina. ");
INSERT INTO seyNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Majaꞌyë jupëpi yoꞌje tsi̱re tse̱a je̱o cua̱ñojaꞌcohuaꞌi aꞌë, huani je̱ajaꞌcohuaꞌire. Cuiꞌne pëca jaꞌquëohuaꞌipi mamajëre tse̱a je̱o cua̱ñojaꞌcohuaꞌi aꞌë. Mamajëpi pëca jaꞌquëohuaꞌire sa̱ñope yoꞌoja̱ꞌcohuaꞌi aꞌë. Ja̱je yoꞌojë mamajëpi pëca jaꞌquëohuaꞌire huahuo je̱ojaꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Siꞌa pa̱i mësarute coeja̱ꞌcohuaꞌi aꞌë, yëꞌë doꞌire. Ja̱je paꞌitoje̱ quëcoquë cuiꞌne nuñerepa paꞌi caraja̱isiquëpi ja̱ëpi huasosiquë paꞌija̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pa̱i daripëre paꞌijëna, tse̱añuꞌu cajë coꞌecohuaꞌi paꞌito catijë̱ꞌë, yequë daripëna. Ja̱je paꞌina, nuñerepa cayë. Pa̱i Mamaquë, ja̱ yëꞌtaꞌa mësaru siꞌa Israel pa̱i dari quëa saomaꞌnë daija̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Yeꞌyequë cato i̱te yeꞌyaquëje̱ paꞌirepa peoji. Necaiquëje̱ i̱ ëjaëje̱ paꞌirepa peoji. ");
INSERT INTO seyNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yeꞌyequëpi i̱te yeꞌyaquëje̱ paꞌi ti̱ꞌani i̱je paꞌi aꞌë cuasaye paꞌiji. Cuiꞌne coꞌamaña necaiquëpi i̱ ëjaëje̱ paꞌi ti̱ꞌani i̱je paꞌi aꞌë cuasaji. Ja̱je paꞌina, yëꞌëni yure i̱ti huëꞌe ëjaëni huati ëjaëpi cani ¿Me mësaruteje̱ caye pa̱ñeꞌni? ");
INSERT INTO seyNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Caꞌramaꞌpë paꞌijë̱ꞌë, pa̱ire. Siꞌaye ña ja̱ꞌñeseꞌe paꞌiji. Yahue sitona yoꞌoseꞌeje̱ ña ja̱ꞌñeseꞌe paꞌiji. Siꞌaye asa ja̱ꞌñeseꞌe paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yëꞌë nea hue̱ꞌña caseꞌere mësarupi mia hue̱ꞌñana cajë̱ꞌë. Cuiꞌne yëꞌë yahueseꞌere, mësarupi ti̱ñarepa huë̱ꞌña ë̱mëje totopi nëcajë cuijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Caꞌramaꞌpë paꞌijë̱ꞌë, ca̱pë huani je̱ocohuaꞌire joyo huani ti̱ꞌamaꞌcohuaꞌire. Ai jerepa caꞌrajë̱ꞌë, ca̱pë nejoquë cuiꞌne joyoje̱ toa yejana nejoquëre pani. ");
INSERT INTO seyNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Teꞌe curi tëꞌquire caya pi̱ꞌare i̱sicohuaꞌi aꞌë, mësaru. Ja̱je aꞌri doꞌicohuaꞌitaꞌare, jaꞌquëpi ë̱sequëna, teꞌije̱ to̱meñe pa̱cohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ja̱je paꞌina, mësaru si̱opë nañaje cue̱cueseꞌe aꞌë, teꞌe measeꞌe siꞌaye cue̱cueseꞌepi paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ja̱je paꞌina, caꞌramaꞌpë paꞌijë̱ꞌë. Mësaru aꞌë, pi̱ꞌa jerepa doꞌicohuaꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Pa̱i ña hue̱ꞌñana Jesús acohuaꞌi aꞌë cacaisicohuaꞌire yëꞌëje̱ cuiꞌne yëꞌë jaꞌquë maꞌtëmo paꞌiquë ña hue̱ꞌñana yëꞌë pa̱i aꞌë, caquë quëasiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ja̱je paꞌiquëtaꞌare pa̱i ña hue̱ꞌñana yëꞌëre cacaimaꞌcohuaꞌire yëꞌëje̱ cuiꞌne jaꞌquë maꞌtëmo paꞌiquë ña hue̱ꞌñana cacaiye pa̱jaꞌquë aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Deꞌoye paꞌi ja̱ꞌñere necaisiquë iye yejana dajiꞌi, cuasamaꞌpë paꞌijë̱ꞌë, yëꞌëre. Yëꞌë cato coa ai jerepa sa̱ñope yoꞌoyere dahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Pa̱ipi pëca jaꞌquëre sa̱ñope yoꞌo ja̱ꞌñere dahuë. Mamacopi pëca jaꞌcore sa̱ñope yoꞌoyere, cuiꞌne mamaquë nëjopi huaore pë̱icore paja̱ꞌcoa. ");
INSERT INTO seyNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ja̱je yoꞌojë cajë teꞌe tsëcapëtaꞌa pa̱i ñape i̱ohuaꞌi pë̱icohuaꞌire paja̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Pëca jaꞌquëni cuiꞌne pëca jaꞌconi yëꞌëre oiye jerepa oiquë pani doꞌi peoquë paꞌiji. Cuiꞌne mamaquëni pa̱nitaꞌa mamaconi yëꞌëre oiye jerepa oiquë pani doꞌi peoji, yëꞌëre. ");
INSERT INTO seyNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Cuiꞌne i̱ paꞌiyere ai oi yëꞌëre peꞌtemaꞌquë pani doꞌi peoquë paꞌiji, yëꞌëre. ");
INSERT INTO seyNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Jëasiꞌi caquë yoꞌoquëpi i̱ paꞌiyere coa nejo huesoja̱ꞌquë api. Ja̱je paꞌiquëtaꞌare yëꞌë doꞌire yoꞌoquë i̱ paꞌiyere cuasaquë jëasiꞌi caquë yoꞌoquëpi i̱ paꞌiyere coa nejo huesoja̱ꞌquë api. Ja̱je paꞌiquëtaꞌare yëꞌë doꞌire yoꞌoquë i̱ paꞌiye nejosiquëpi paꞌiye ti̱ꞌajaꞌquë aquëpi. ");
INSERT INTO seyNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Mësarute deꞌoye tsioquë pani yëꞌëni deꞌoye tsioji. Yëꞌëni deꞌoye tsioquë pani yëꞌëre jëjo daosiquëni deꞌoye tsioji. ");
INSERT INTO seyNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Maijaꞌquë yoꞌo ja̱ꞌñere quëacaiquëni deꞌoye yoꞌoquë pani ja̱re ja̱ohuaꞌire i̱si coꞌamaña ayere i̱ñe paꞌiji, nesi doꞌi. Deꞌo pa̱ini deꞌoye tsioquë pani ja̱re nuñerepa paꞌicohuaꞌire i̱si coꞌamaña ayere i̱ñe paꞌiji, nesi doꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Yëꞌëre tuiquë macani oco mañare o̱cuasicohuaꞌi pani deꞌo coꞌamaña i̱si cua̱ñojaꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesús i̱ doce yeꞌyacohuaꞌire i̱ohuaꞌi yoꞌo ja̱ꞌñe quëa tëjini sajiꞌi, yeꞌyaquë cuiꞌne quëasiꞌi caquë ja̱ yeja paꞌi daripë̱ana. ");
INSERT INTO seyNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan co sitore ñuꞌiquëpi Cristo yoꞌoyere asani i̱ yeꞌyacohuaꞌire Jesús quëꞌrona jëjo saopi, se̱ni asaja̱ꞌcohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Mëꞌë aꞌë, Cristo i̱ti daija̱ꞌquëre ca nëosiquë pa̱nitaꞌa yequëre uteye paꞌiquë cajë. ");
INSERT INTO seyNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jëjo saosicohuaꞌipi se̱jëna, Jesupi sehuopi, ja̱ohuaꞌire: “Sani Juanre cajë̱ꞌë, mësaru ñaseꞌere cuiꞌne mësaru yure asaseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ñamaꞌcohuaꞌi paꞌisicohuaꞌipi ñañere, cuꞌimaꞌcohuaꞌi paꞌisicohuaꞌipi cuꞌiyere, si̱ꞌsi dahuë ju̱ꞌicohuaꞌi paꞌisicohuaꞌipi to̱me sayere, asamaꞌcohuaꞌipi asayere, ju̱ꞌisicohuaꞌi paꞌisicohuaꞌipi huajëcohuaꞌi huëoyere, cuiꞌne coꞌamaña peocohuaꞌina deꞌo coca quëayere quëajë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Yëꞌëre jëa coemaꞌcohuaꞌipi deꞌoye sihuajë paꞌija̱ꞌcohuaꞌi aꞌë, i̱re papi cuasacohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ja̱ohuaꞌi saisi maca Jesús Juan paꞌiye ayere ca huëopi, pa̱ire. Ñeje capi: ¿I̱quere mësaru so̱quë peo hue̱ꞌña saisicohuaꞌi ñareꞌni, ca̱të jaꞌore tutupi juꞌaquëna, huahuëquëna, ñare? ");
INSERT INTO seyNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿I̱queini ñareꞌni, ja̱je paꞌito? ¿Deꞌo ca̱ña su̱ñasiquëni ñare? Tsoe mësarupi ñacohuaꞌi aꞌë, pa̱i ëjaohuaꞌi huëꞌe paꞌicohuaꞌi cato deꞌo ca̱ña juꞌicohuaꞌi paꞌiye. ");
INSERT INTO seyNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ja̱je paꞌina, tëjiyerepa cayë. ¿I̱queini ñareꞌni, sani? ¿Maijaꞌquëre quëacaiquë? Ja̱je paꞌijë̱ꞌë. Ja̱ëpi Maijaꞌquëre quëacaicohuaꞌi aquë ja̱ëje paꞌiohuaꞌi peoa̱huëꞌë, iquë Juan cato jerepa paꞌi api. ");
INSERT INTO seyNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jaë, Juan ayere toyaseꞌe caji, ñeje: Yëꞌëpi jëjo saoyë, yëꞌëre quëacaiquëre mëꞌë ña hue̱ꞌñana, Mëꞌëre maꞌa ne deꞌhuacaija̱ꞌquëre. ");
INSERT INTO seyNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nuñerepa cayë, mësarute. Siꞌa pa̱i tsoe paꞌisicohuaꞌipi cuiꞌne yure paꞌicohuaꞌije̱ Juan oco doquëre tëto saisicohuaꞌi peoyë. Ja̱je paꞌiquëtaꞌare maꞌtëmo cua̱ñe te̱ꞌtere aꞌriquë paꞌiquëpi Juanre tëto saisiquë paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Juan oco doquë daisi maca acohuaꞌipi yureje̱ tutu yoꞌoyë, maꞌtëmo cua̱ñe te̱ꞌtena ti̱ꞌañuꞌu cajë. Ja̱je yoꞌojë tutu quëꞌiohuaꞌiseꞌe deꞌhue ti̱ꞌañë. ");
INSERT INTO seyNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Siꞌaohuaꞌi Maijaꞌquëre quëacaicohuaꞌi cuiꞌne Moisés cua̱ñeseꞌe yeꞌyacohuaꞌi cahuë, maꞌtëmo ayere, Juan dai macaja̱ꞌa. ");
INSERT INTO seyNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Juan cato Elíaspi ja̱ëni Maijaꞌquëre quëacaicohuaꞌi caꞌa̱huëꞌë, ‘daija̱ꞌquë api’. Ja̱je paꞌina, mësarupi i̱ api cuasajë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ca̱joro hueꞌecohuaꞌipi asajë̱ꞌë, iye. ");
INSERT INTO seyNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿I̱quena co̱ni quëa i̱ñoraꞌye iyeꞌnë pa̱i paꞌiye? Cani capi: Tsi̱pi coꞌamaña huero hue̱ꞌñana jaꞌrusicohuaꞌipi dujë cajeohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ñeje cuiyeje̱ paꞌiohuaꞌi aꞌë. Pi̱ꞌcohuë̱api juitoje̱ pairamaꞌpë paëꞌë, mësarupi. Oi ëaye jë̱jëtoje̱ mësarupi oimaꞌpë paëꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juan cato dajiꞌi, jaiye a̱o a̱imaꞌquëpi cuiꞌne oꞌsa co̱no u̱cumaꞌquëpi. Ja̱je paꞌini mësarupi cayë, huati quëꞌi api. Ja̱je paꞌiquëtaꞌare Maijaꞌquë ta̱ꞌñe yoꞌoye cato i̱ñoji, i̱ti yoꞌoyepi. ");
INSERT INTO seyNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ja̱ jeteyoꞌje dajiꞌi, Pa̱i Mamaquë a̱o a̱iquëpi cuiꞌne oꞌsa co̱no u̱cuquëpi. Ja̱je paꞌini cayë, jai a̱upi, cuiꞌne jai co̱noupi, coꞌaye yoꞌocohuaꞌi cajeipi cuiꞌne curiquë tsiꞌsohuaꞌi cajeipi. Ja̱je cajëtaꞌare Maijaꞌquë ta̱ꞌñe yoꞌoye cato i̱ñoji, i̱ti yoꞌoyepi.” ");
INSERT INTO seyNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ja̱ maca Jesús pa̱i yoꞌo ti̱ꞌa maꞌñere ne i̱ñosi darire tutu yëhuopi, i̱ohuaꞌi paꞌiye po̱nëmaꞌpë paꞌisi doꞌire caquë. ");
INSERT INTO seyNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Yëhuoquë capi: “¡Teayerepa Corazín daripë! ¡Betsaida daripë! Mësarute ne i̱ñoseꞌeje̱ paꞌye Tiro cuiꞌne Sidón darina ne i̱ñoñe paꞌito tsoe asani po̱nëraꞌhuë, ja̱ꞌrë paꞌiseꞌe je̱oni. Cuiꞌne oijë su̱ña ca̱ñani hua̱tapi coꞌye joꞌjëni oijë i̱ñoraꞌhuë, i̱ohuaꞌi oiye. ");
INSERT INTO seyNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ja̱je paꞌina, mësarute cayë. Pa̱i yoꞌoseꞌe ña muꞌse ti̱ꞌasi maca ai coꞌayerepa mësarute sa̱iñe paꞌiji, Tiro cuiꞌne Sidón daripë̱a sa̱iñe se̱ña maca paꞌyepi. ");
INSERT INTO seyNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Capernaum daripë ¿Mëꞌë maꞌtëmore pana sa cua̱ñojaꞌcoaꞌë, cuasaco? Coa ai jerepa mëꞌë cato meñe caje huesëja̱ꞌcoaꞌë, ju̱ꞌisicohuaꞌi quëꞌrona. Sodoma yejañana, mësarute i̱ñoñeje paꞌye i̱ñoñe paꞌito i̱ohuaꞌi yoꞌoye je̱oni po̱nëraꞌhuë, cuiꞌne ja̱ pa̱i daripë ja̱ yëꞌtaꞌa yureje̱ patiraꞌo. ");
INSERT INTO seyNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ja̱je paꞌina, cayë, mësarute. Pa̱i ñape yoꞌoseꞌe ña muꞌse ti̱ꞌasi maca mësarupi ai jerepa coꞌayerepa sa̱i cua̱ñojaꞌcohuaꞌi aꞌë, Sodoma yejaña quëꞌro paꞌicohuaꞌire yoꞌoseꞌe jerepa paꞌyepi.” ");
INSERT INTO seyNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ja̱ muꞌseña Jesús capi: “Sihuayë, jaꞌquë mëꞌëre maꞌtëmo cuiꞌne yeja ëjaëre. Mëꞌëpi i̱ñohuë, teaye paꞌiohuaꞌini, ta̱ꞌñe paꞌiohuaꞌire cuiꞌne ta̱ꞌñe asacohuaꞌire yahuesi coꞌamañare. ");
INSERT INTO seyNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ja̱je paꞌijë̱ꞌë. Jaꞌquë mëꞌëpi yë ja̱je yoꞌohuë. ");
INSERT INTO seyNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yëꞌë jaꞌquëpi yëꞌëna siꞌa coꞌamaña i̱sipi. Pëca jaꞌquëseꞌe mamaquëre ñaji. Cuiꞌne mamaquëseꞌe pëca jaꞌquëre ñaji. Cuiꞌne mamaquë i̱ñoñe yëcohuaꞌiseꞌe asaye paꞌiji, i̱te. ");
INSERT INTO seyNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Daijë̱ꞌë, yëꞌëna. Siꞌaohuaꞌi coꞌamaña nejë, cuiꞌne hueꞌejë jëꞌjosicohuaꞌi yëꞌëpi pëa huajëye i̱sisiꞌi, mësarute. ");
INSERT INTO seyNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yëꞌë paꞌiyere ñani cuiꞌne yoꞌoñuꞌu cuasajë̱ꞌë caquë yëꞌë yoꞌoye i̱siyë. Yeꞌyejë̱ꞌë, yëꞌëni. Yëꞌë cato esa yoꞌo jujamaꞌquë aꞌë cuiꞌne jerepa paꞌi aꞌë cuasamaꞌquë aꞌë. Ja̱je yoꞌonitaꞌa ti̱ꞌajaꞌcohuaꞌi aꞌë, joyo pëa huajë hue̱ꞌña. ");
INSERT INTO seyNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Yëꞌë quërë saihuëre mësarute i̱siyë, a̱ꞌjiñe sayere cuiꞌne pe̱añe hueꞌeyere.” ");
INSERT INTO seyNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Jesús ta̱ sitoja̱ꞌa sajiꞌi. Ja̱je saina, i̱ yeꞌyacohuaꞌi a̱o ëaye nëina, trigo sa̱ꞌñare tëa huëohuë. Tëani i̱ti ca̱re a̱ëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ja̱je yoꞌojëna, fariseohuaꞌipi ñani cahuë, Jesure: “Ñajëꞌë, mëꞌë yeꞌyacohuaꞌi coꞌamaña neñere. Coꞌamaña nemaꞌa muꞌse aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ja̱je cajëna, i̱pi ja̱ohuaꞌire capi: “¿Ñamaꞌcohuaꞌi aꞌni, mësaru, David yoꞌoseꞌe i̱ cajeohuaꞌi ja̱ꞌre co̱ni a̱o ëa ju̱ꞌi maca? ");
INSERT INTO seyNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","A̲o ëa ju̱ꞌijë Maijaꞌquë huëꞌe necaicohuaꞌiseꞌe a̱iñere Maijaꞌquë huëꞌena cacani David cuiꞌne i̱ cajeohuaꞌi a̱ëꞌë, i̱te cuiꞌne yecohuaꞌire ë̱seseꞌere, Maijaꞌquëna i̱siseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Moisés cua̱ñeseꞌepi toyaseꞌe caji: ‘Maijaꞌquë huëꞌe necaicohuaꞌi cato huajë muꞌseje̱ neñe payë.’ Ja̱je paꞌiquëtaꞌare i̱ohuaꞌire sa̱ñope caye peoji. ");
INSERT INTO seyNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ja̱je paꞌina, cayë mësarute ‘i̱ñore paꞌiji, Maijaꞌquë huëꞌe se̱ña maca paꞌire papi.’ ");
INSERT INTO seyNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Iye toyaseꞌe caye asamaꞌpë paëꞌë, mësaru. Ja̱pi caji: ‘Mësarupi pa̱ire teaye ñajë oicohuaꞌi paꞌiyere yëꞌë cato yëyë. Coeye nëicohuaꞌire huaijë i̱siye cato.’ Pa̱ire oiyere asacohuaꞌi pani pa̱ire doꞌi peocohuaꞌini coꞌacohuaꞌi aꞌë caye pa̱raꞌhuë, mësaru. ");
INSERT INTO seyNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ja̱je paꞌina, Pa̱i Mamaquë cato huajë muꞌse Ëjaëpi.” ");
INSERT INTO seyNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ja̱ maca Jesús ja̱ropi sani pa̱i tsiꞌsi huëꞌena cacapi. ");
INSERT INTO seyNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ja̱rote teꞌi jë̱të cue̱nesicore hueꞌequëpi pajiꞌi. Ja̱je paꞌina, ñani Jesupi tayo caëna, i̱te sa̱ñope cayeque paꞌiji cuasajë se̱iꞌë: “¿Ju̱ꞌiquëre jujuye deꞌoquë huajë muꞌse paꞌitoje̱?” ");
INSERT INTO seyNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Cajëna, Jesupi sehuopi: “¿Nepi mësaru acohuaꞌi yëi ñamapi cojena duquëna sani dutamaꞌcohuaꞌi aꞌni, huajë muꞌse paꞌitoje̱? ");
INSERT INTO seyNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ja̱je paꞌina, pa̱ipi doꞌiji, yëi ñamare jerepa. Ja̱je huajë muꞌse paꞌitoje̱ deꞌoye yoꞌoye paꞌito yoꞌoye paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Cani ja̱ maca i̱te capi: “Jë̱tëre mëajëꞌë.” Ja̱je caquëna, i̱pi se mëaquëna, yequë te̱ꞌte jë̱tëje̱ paꞌio huajëco po̱nëo. ");
INSERT INTO seyNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ja̱ maca fariseohuaꞌipi etani Jesure huani je̱o ja̱ꞌñere ca huëohuë, ¿me neni huani je̱ojaꞌcohuaꞌi aꞌni? cajë. ");
INSERT INTO seyNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesús ja̱re asani ja̱ropi yequë hue̱ꞌñana sajiꞌi. Saina, jai pa̱i i̱te tuëꞌë. Jesupi coa siꞌa ju̱ꞌi dahuë ju̱ꞌicohuaꞌire jujupi. ");
INSERT INTO seyNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jujuquë cuiꞌne ë̱sepi, yecohuaꞌire se quëayeje̱. ");
INSERT INTO seyNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Iye cato yoꞌoreña, Maijaꞌquëre quëacaiquë Isaías toyaquë caquë paꞌiseꞌepi ti̱ꞌa ja̱ꞌñere, ñeje: ");
INSERT INTO seyNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Iquë api, yëꞌë joꞌyaë yëꞌë sahuani tse̱asiquë, I̱te oiyë, cuiꞌne i̱ni sihuaquë paꞌiyë. I̱na, yëꞌë joyo je̱ocaija̱ꞌquë aꞌë. Cuiꞌne i̱pi siꞌa pa̱ire yëꞌë nuñerepa paꞌi yoꞌoyere quëacaija̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Pa̱ini coꞌa cocare camaꞌë pasipi, cuimaꞌë pasipi. Cuiꞌne i̱ cayeje̱ asacaiye pa̱jaꞌcohuaꞌi aꞌë, cuꞌi hue̱ꞌñana. ");
INSERT INTO seyNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ca̱tëpë caꞌhuere quëꞌioreje̱ ne jëyomaꞌë pasipi. Cuiꞌne picoseꞌe mëicoreje̱ yayomaꞌë pasipi. I̱ nuñerepa cua̱ñeñe ne macaja̱ꞌa ja̱je yoꞌoja̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Siꞌa pa̱i maña i̱ni necaija̱ꞌquë api cajë utejë paꞌija̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jesús quëꞌrona sahuë, ñamaꞌquëre cuiꞌne coca camaꞌquëre huatire hueꞌequëre. Sarena, Jesupi jujupi. Jujuna, ñaquë cuiꞌne coca caquë po̱nëpi. ");
INSERT INTO seyNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ja̱re siꞌa pa̱i ña quëquëni cahuë: “¿Iquë David mamaquëre papi?” ");
INSERT INTO seyNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ja̱je cajëna, fariseohuaꞌipi asani cahuë: “Iquë cato huatiohuaꞌire eto saoji, i̱ohuaꞌi ëjaë Beelzebú tuture hueꞌequëpi.” ");
INSERT INTO seyNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesupi i̱ohuaꞌi cuasaye asani capi, ja̱ohuaꞌire: “Teꞌe yeja ëjaëpi jopore paja̱ꞌa huani i̱ti pa̱ijaꞌa sa̱ꞌñe uihuajë yoꞌocohuaꞌi pani peo hue̱ꞌñarepa caraja̱iñe paꞌiji. Pa̱i daripëpi, panitaꞌa teꞌe tsëcapëpi sa̱ꞌñe pë̱icohuaꞌi pani quëcoye peoji, yecohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ja̱je cuiꞌne huati ëjaëje̱ i̱jaꞌa coꞌye eto saoquë pani ¿Me cuiꞌne i̱ tutu paquëꞌni, i̱jaꞌa sa̱ñope yoꞌoquë pani? ");
INSERT INTO seyNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mësarupi yëꞌëre cayë, Beelzebú tutupi huatiohuaꞌire eto saoji. Ja̱je paꞌito ¿nepi tutupi i̱siyeꞌni, mësarute tuicohuaꞌire eto sao tutu? Ja̱ohuaꞌini se̱ni asato mësarupi coa tayo huesëhuë, caja̱ꞌcohuaꞌi paꞌini. ");
INSERT INTO seyNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Yëꞌë cato huatiohuaꞌire eto saoyë, Maijaꞌquë joyo tutupi. Yëꞌë yoꞌoye cato quëaji, Maijaꞌquë cua̱ñe te̱ꞌtepi mësaruna ti̱taseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","¿Tutu quëꞌi huëꞌe paꞌito cacani i̱ coꞌamaña sioye peoji, duꞌru i̱ni tse̱amaꞌcohuaꞌi pani? Ja̱je paꞌina, i̱ni tse̱anitaꞌa deꞌhue cacani i̱ coꞌamaña i̱ñe paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Yëꞌë yoꞌoyere co̱ yoꞌomaꞌquë cato yëꞌëre sa̱ñope yoꞌoquë api. Cuiꞌne yëꞌë ja̱ꞌre co̱ni tëamaꞌquë cato coa ne ñaꞌñe saoquë api. ");
INSERT INTO seyNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ja̱je paꞌina, cayë, mësarute. Siꞌaye coꞌaye pa̱ire yoꞌoseꞌe paꞌitoje̱ sa̱i deꞌhuacaiye paꞌiji, siꞌaye coꞌaye caseꞌe paꞌitoje̱. Ja̱je paꞌiquëtaꞌare Maijaꞌquë joyore coꞌaye casicohuaꞌi paꞌitotaꞌa ti sa̱i deꞌhuacaiye peoji. ");
INSERT INTO seyNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Cuiꞌne yëꞌë Pa̱i Mamaquëni coꞌaye casicohuaꞌireje̱ sa̱i deꞌhuaye paꞌiji. Ja̱je paꞌiquëtaꞌare Maijaꞌquë joyore sa̱ñope casicohuaꞌire sa̱i deꞌhuacaiye peoji. ");
INSERT INTO seyNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Deꞌo so̱quë yëpi deꞌo ca̱re quë̱iñe paꞌiji. Coꞌa so̱quë yëpi ja̱re coꞌa ca̱re quë̱iñe paꞌiji. Ja̱je paꞌina, i̱o quë̱iñena ñañe paꞌiji, so̱quë yë. ");
INSERT INTO seyNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡A̲ña tsëcapë acohuaꞌi! ¿Me deꞌoye ca ti̱ꞌañeꞌni, mësaru, ja̱re mësarupi coꞌacohuaꞌi paꞌini? Ja̱je paꞌina, yëꞌopo cato joyo paꞌiyere caye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Deꞌo pa̱i cato deꞌo cocare caji, ja̱re i̱ joyo paꞌiyepi. Cuiꞌne coꞌa pa̱ipi caji coꞌayere, ja̱re i̱ joyo coꞌaye paꞌiyeje̱ paꞌye. ");
INSERT INTO seyNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ja̱je paꞌina, yëꞌë cayë. Ja̱ohuaꞌire pa̱i ñape yoꞌoseꞌe ña muꞌse ti̱ꞌasi maca siꞌaohuaꞌi i̱ñoñe paꞌiji, siꞌaye i̱ohuaꞌi cuasamaꞌpë caseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ja̱je paꞌina, mëꞌë caseꞌeje̱ paꞌye ña deꞌhua cua̱ñoñe paꞌiji, doꞌi peoquë pa̱nitaꞌa doꞌi quëꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ja̱ maca Jesure fariseohuaꞌi cuiꞌne cua̱ñeseꞌe yeꞌyacohuaꞌi co̱ni cahuë: “Yeꞌyaquë, yëquë ñañe yëyë, mëꞌëpi pa̱i yoꞌo ti̱ꞌa maꞌñe yoꞌoquëna.” ");
INSERT INTO seyNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Cajëna, Jesupi sehuopi, ja̱ohuaꞌire: “Coꞌa pa̱ipi nuñerepa cuasamaꞌcohuaꞌipi pa̱i yoꞌo ti̱ꞌa maꞌñe yoꞌoquëna, ñañuꞌu cajë, se̱ñë. Ja̱je se̱jëtaꞌare Maijaꞌquëre quëacaiquë Jonás i̱ñoquë paꞌiseꞌeje̱ paꞌye jerepa i̱ñoñe peosipi. ");
INSERT INTO seyNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Coa Jonás jai huaꞌi ë̱tapë paꞌiseꞌeje̱ paꞌyeseꞌe i̱ñoñe paꞌiji. Ja̱ë je̱ꞌquë toaso̱ muꞌseña cuiꞌne toaso̱ ñami paꞌa̱jiꞌi. Ja̱je paꞌye Pa̱i Mamaquëje̱ toaso̱ muꞌseña cuiꞌne toaso̱ ñami paꞌija̱ꞌquë api, yeja sa̱ꞌnahuëre. ");
INSERT INTO seyNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Tsoe hue̱ꞌña Nínive daripë paꞌisicohuaꞌipi huëni pa̱i ñape yoꞌoseꞌe ña muꞌse ti̱ꞌaëna, iyeꞌnë paꞌicohuaꞌire nejojaꞌcohuaꞌi aꞌë. Nínive acohuaꞌi cato deꞌhue asani ja̱ꞌrë paꞌiseꞌe je̱oni po̱nëahuëꞌë, Jonás Maijaꞌquë coca quëaquëna, asani. Yure i̱ñore paꞌiji, Jonás se̱ña maca paꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Cuiꞌne huëꞌehuë te̱ꞌte pa̱i ëjaoje̱ huëija̱ꞌcoa, nejo muꞌse ti̱ꞌasi maca. Huëni iyeꞌnë paꞌicohuaꞌi yoꞌoseꞌe ñani cuiꞌne nejoñe paꞌiji, caja̱ꞌcoa. Ja̱o cato soꞌo yejapi Salomón ta̱ꞌñe yoꞌoyere asasiꞌi caco daisico sëte. Yure i̱ñore paꞌiji, Salomón jerepa paꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Huatipi pa̱ire paꞌisiquëpi etani saisiquë pani cuꞌiji, cue̱nesi yejañare pëa huajë hue̱ꞌñare coꞌequë ti̱ꞌamaꞌë coꞌe jujani cuasaji: ");
INSERT INTO seyNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘Coꞌisiꞌi, cuiꞌnaona, yëꞌë huëꞌena yëꞌë etani daisicona.’ Ja̱je cani coꞌiquë ñaquëna, pa̱i peo huëꞌepi coa yuasicopi cuiꞌne deꞌoye ne deꞌhuasicopi paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Paꞌina, ñani ja̱ maca sani siete huatiohuaꞌire i̱ jerepa coꞌacohuaꞌini quërëja̱ni, dani i̱na cacani pëayë. Pëarena, ja̱ maca ja̱ꞌnë paꞌiseꞌe se̱ña maca coꞌaquë paꞌija̱ꞌquë api. Ja̱je cuiꞌne iye coꞌa pa̱ire yoꞌoye paꞌija̱ꞌcoa.” ");
INSERT INTO seyNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús ja̱ yëꞌtaꞌa pa̱ini caquëna, ti̱tahuë, pëca jaꞌco cuiꞌne i̱ yoꞌje tsi̱ co̱ni. Dani hueꞌsena pëahuë, i̱ni cajë daisicohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ja̱je paꞌijëna, yecohuaꞌipi Jesure quëahuë: “Më jaꞌco cuiꞌne më yoꞌje tsi̱ hueꞌsere paꞌiyë, mëꞌëni cajë dani.” ");
INSERT INTO seyNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Caquëna, i̱ti quëaquëre capi, Jesús: “¿Ne aꞌni, yëꞌë jaꞌco cuiꞌne ne aꞌni, yëꞌë yoꞌje tsi̱?” ");
INSERT INTO seyNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Cani i̱ yeꞌyacohuaꞌire i̱ñoquë quëapi: “Icohuaꞌi aꞌë, yëꞌë jaꞌco cuiꞌne yëꞌë yoꞌje tsi̱. ");
INSERT INTO seyNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Pa̱ipi yëꞌë jaꞌquë maꞌtëmo paꞌiquë yëyere yoꞌocohuaꞌipi ja̱ohuaꞌi aꞌë, yëꞌë yoꞌjei pa̱nitaꞌa yoꞌjeo cuiꞌne jaꞌco.” ");
INSERT INTO seyNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ja̱ muꞌse Jesús huëꞌepi etani sani jaira të̱ꞌtë macana jaꞌrupi. ");
INSERT INTO seyNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ja̱rote paꞌina, jai pa̱i i̱ quëꞌrona daijëna, ñani jai yohuëna aya mëni jaꞌrupi. Siꞌa pa̱i mejahuëna pëa sahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ja̱ maca jaiye yeꞌyapi i̱ohuaꞌi ñañe ayena co̱ni quëaquë capi: “Ta̱quëpi ta̱siꞌi caquë sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Sai ta̱quëna, yequë ca̱pi to̱mepi, maꞌana. Ja̱ to̱meseꞌere pi̱ꞌapi dani peo hue̱ꞌña o̱cue saohuë. ");
INSERT INTO seyNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Yequë ca̱pi to̱mepi, quë̱na pë̱a quëꞌrona, jaiye yeja peo hue̱ꞌñana. Ja̱ ca̱pi esa sacapi, yaꞌopi hua̱iñe peoquëna. ");
INSERT INTO seyNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ja̱je mëasicotaꞌa ë̱sëpi ëo hue̱api, jaiye tsita meseꞌe peoye sëte ju̱jiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Yequë ca̱pi to̱mepi, miu quëꞌrona. To̱meina, miupi mëani ne hue̱api. ");
INSERT INTO seyNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ja̱je to̱mequëtaꞌare yequë ca̱pi to̱mepi, deꞌo yejana. To̱meni mëani jaiye quë̱quëna, tëahuë. Yequë ñëapi quë̱jiꞌi, cien ca̱. Yequë ñëapi quë̱jiꞌi, sesenta ca̱. Cuiꞌne yequë ñëapi quë̱jiꞌi, treinta ca̱. ");
INSERT INTO seyNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Mësarupi ca̱joro quëꞌiohuaꞌi pani ¡asajë̱ꞌë!” ");
INSERT INTO seyNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ja̱ maca i̱ yeꞌyacohuaꞌipi Jesús quëꞌrona tsio dani se̱iꞌë, I̱te: “¿Me ne ja̱ꞌñere pa̱ire i̱ohuaꞌi ñañena co̱ni ja̱je quëaquëꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Se̱jëna, i̱pi sehuopi: “Mësarute Maijaꞌquëpi ta̱ꞌñe asaye i̱sipi, yahueseꞌere maꞌtëmo te̱ꞌte ayere. Ja̱je paꞌiquëtaꞌare ja̱ohuaꞌi cato asa ti̱ꞌañe pa̱ñë. ");
INSERT INTO seyNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ja̱je paꞌina, paquëna, ai jerepa yeque se i̱siye paꞌiji, i̱sina, jaiye paja̱ꞌquëre. Ja̱je paꞌiquëtaꞌare peoquëni ai jerepa jero saꞌana se sio huesoye paꞌiji, aꞌri maña i̱ payeque. ");
INSERT INTO seyNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ja̱je paꞌina, i̱ohuaꞌi ñañe ayena co̱ni caquëna, ñajëtaꞌa ña maꞌñeje paꞌiohuaꞌi ña huesëyë. Cuiꞌne asajëtaꞌa ti asamaꞌcohuaꞌije̱ paꞌiohuaꞌi asa huesëyë. ");
INSERT INTO seyNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ja̱je yoꞌo ja̱ꞌñere Maijaꞌquëre quëacaiquë Isaías capi: Mësaru cato asaja̱ꞌcohuaꞌi aꞌë. Ja̱je asajëtaꞌa asa ti̱ꞌamaꞌpë paꞌija̱ꞌcohuaꞌi aꞌë. Ñañe cato ñajaꞌcohuaꞌi aꞌë. Ja̱je ñajëtaꞌa ña ti̱ꞌamaꞌpë paꞌija̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Pa̱i joyopi jëacorepa ne huesësi doꞌire, Coꞌayerepa asaja̱ꞌcohuaꞌi aꞌë. Cuiꞌne i̱ohuaꞌi ñaco ca̱je si̱oseꞌere hueꞌeja̱ꞌcohuaꞌi aꞌë ñaco ca̱pi. Ñamaꞌpë paꞌija̱ꞌcohuaꞌi. Cuiꞌne asamaꞌpë paꞌija̱ꞌcohuaꞌi aꞌë. Cuiꞌne joyopi asa ti̱ꞌamaꞌpë paꞌija̱ꞌcohuaꞌi aꞌë. Cuiꞌne yëꞌëna juju cua̱ñoñuꞌu cajë yoꞌomaꞌpë paꞌija̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ja̱je paꞌiquëtaꞌare mësaru cato sihuajë̱ꞌë, ñaco ca̱pi ñajë cuiꞌne ca̱joropi asa doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nuñerepa cayë, mësarute. Jai pa̱i Maijaꞌquëre quëacaicohuaꞌi cuiꞌne deꞌo pa̱i ñañe yëhuë, mësaru yure ñañere. Ja̱je yëjëtaꞌa ñamaꞌpë paëꞌë. Asaye yëhuë, mësaru asayere. Ja̱je yëjëtaꞌa asamaꞌpë paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Asajë̱ꞌë. Ja̱je paꞌito ta̱quëre quëaseꞌe ayere. ");
INSERT INTO seyNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Maꞌana i̱ti ca̱ to̱meseꞌe cato quëaji, maꞌtëmo paꞌi te̱ꞌte ayere asacohuaꞌitaꞌa asa ti̱ꞌamaꞌcohuaꞌini cuiꞌne huatipi i̱ohuaꞌi deꞌo coca asaseꞌere peo hue̱ꞌña sioyere. ");
INSERT INTO seyNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Quë̱na pë̱a quëꞌrona to̱mesi ca̱ cato quëaji, duꞌru macare paseꞌe sihuajë asani sehuocohuaꞌini. ");
INSERT INTO seyNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Jeteyoꞌje jaiye tsita peoye sëte quëcomaꞌpë neñañepi cuiꞌne yecohuaꞌipi jo̱sa yoꞌojëna, ai yoꞌoyepi paꞌina, yoꞌo jujani je̱ocohuaꞌini. ");
INSERT INTO seyNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Miu quëꞌrona ta̱si ca̱ cato quëaji, Maijaꞌquë coca asajëtaꞌa iye yeja coꞌamañare ai cuasajë jaiye coꞌamaña ëayena coso cua̱ñoñere. Siꞌaye iye Maijaꞌquë cocare pëꞌpë huesoye aꞌë. Ja̱je yoꞌoquëna, pa̱ipi quë̱iñeje paꞌye deꞌoye yoꞌo ti̱ꞌañe peoye aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ja̱je paꞌiquëtaꞌare deꞌo yejana ta̱si ca̱ cato quëaji, Maijaꞌquë coca asani je̱omaꞌpë tuicohuaꞌini, deꞌoyerepa quë̱icohuaꞌini. Ja̱je paꞌina, yecohuaꞌipi cien ca̱, yecohuaꞌipi sesenta ca̱ cuiꞌne yecohuaꞌipi treinta ca̱ quë̱icohuaꞌi paꞌiyë.” ");
INSERT INTO seyNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ja̱ꞌnë quëaseꞌeje̱ paꞌye neni i̱ñoquë Jesús quëapi, ñeje: “Trigo ca̱re pare ta̱quëpi yejana ta̱seꞌeje̱ paꞌye aꞌë, maꞌtëmo paꞌi te̱ꞌte aye. ");
INSERT INTO seyNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ta̱siquëtaꞌare i̱te sa̱ñope yoꞌoquëpi siꞌaohuaꞌi ca̱isi maca dani coꞌa ca̱re ta̱ni sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Saquëna, trigopi ai deꞌoni i̱ti tsa̱ꞌña ne maca teꞌe coꞌa tayaje̱ etapi. ");
INSERT INTO seyNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ja̱ maca joꞌyaohuaꞌipi i̱ti tse̱ aquëre sani cahuë: ‘Ëjaë, mëꞌë tsio deꞌo ca̱seꞌe ta̱sicohuaꞌitaꞌa ¿jero ayepi iye coꞌa taya co̱ni mëaëꞌni?’ ");
INSERT INTO seyNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Cajëna, i̱ti tse̱ aquëpi capi, ja̱ohuaꞌire: ‘Yequë coꞌaquëpi yoꞌopi yëꞌëre sa̱ñope yoꞌoquëpi.’ Caquëna, i̱ joꞌyapi cahuë, i̱te: ‘¿Yëquëpi ja̱ coꞌa taya duꞌte je̱ocaiye yëmaꞌquë?’ ");
INSERT INTO seyNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Cajëna, i̱pi capi, ja̱ohuaꞌire: ‘Pa̱ni, coꞌa tayare dutajë trigoje̱ duta je̱omaꞌcohuaꞌipi yoꞌoyeꞌni. ");
INSERT INTO seyNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","I̱oseꞌe mëajaco tëa muꞌse ti̱ꞌaëna, nejo ja̱ꞌñepi, ja̱ macataꞌa coꞌamaña necohuaꞌire jëjo saosiꞌi, coꞌa tayare ti pë̱a hue̱ni toana ëo je̱ojaꞌcohuaꞌire, ja̱ jeteyoꞌje trigo ca̱re paseꞌe yëꞌë deꞌhua hue̱ꞌñana deꞌhuacaija̱jë.’ ” ");
INSERT INTO seyNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Quëaye neni Jesús quëapi, ñeje: “Maꞌtëmo paꞌi te̱ꞌte cato mostaza ca̱re yejana pa̱ipi ta̱seꞌeje̱ paꞌye aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mostaza cato nuñerepa aꞌri ca̱ꞌë. Ja̱je paꞌisicotaꞌa ai deꞌoco jai so̱quë yë deꞌona pi̱ꞌapi i̱ona daijë capë̱ana tsianoa necohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yeque cuiꞌne quëaye neni quëapi, ñeje: “Maꞌtëmo paꞌi te̱ꞌte cato pan ne poreje̱ paꞌye aꞌë. Ja̱je paꞌyere nomiopi tres jai ji̱ꞌso harina neona, siꞌa së̱pë oꞌsaco jujucoa.” ");
INSERT INTO seyNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesús siꞌaye pa̱ire quëapi, i̱ohuaꞌi ñañe ayepi caquë. Coꞌarepa ña maꞌñepi caquë quëamaꞌë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Iye cato yoꞌoseꞌe paꞌiji, Maijaꞌquëre quëacaiquë toyaquë paꞌiseꞌepi ti̱ꞌajaquë caquë i̱ toyaquë paꞌiseꞌepi caji: “Caja̱ꞌquë aꞌë, i̱ohuaꞌi ñañe ayepi co̱ni.” Caja̱ꞌquë aꞌë, yahuesi coꞌamaña paꞌiseꞌere yeja deꞌhuanë ayere. ");
INSERT INTO seyNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ja̱ maca Jesús pa̱ire ca tëjini huëꞌena cacapi. Cacaëna, ja̱rona i̱te yeꞌyecohuaꞌi tsioja̱ni cahuë: “Quëajë̱ꞌë, coꞌa tayapi tsiona mëaseꞌe ayere.” ");
INSERT INTO seyNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Cajëna, Jesupi capi, ja̱ohuaꞌire: “Deꞌo ca̱ ta̱quë cato Pa̱i Mamaquë api. ");
INSERT INTO seyNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Cuiꞌne tsio cato siꞌa yejaꞌë. Deꞌo ca̱ cato Maijaꞌquë te̱ꞌte acohuaꞌini quëaji, cuiꞌne taya cato quëaji, huati te̱ꞌte acohuaꞌini. ");
INSERT INTO seyNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Sa̱ñope yoꞌoquëpi coꞌa taya ta̱caisiquë cato huati ëjaëpi. Tëaye cato quëaji, yeja caraja̱i ja̱ꞌñere, cuiꞌne i̱ti ca̱ tëacohuaꞌi cato hui̱ñaohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Coꞌa taya tsiꞌsoni toana ëo je̱oñeje paꞌye cuiꞌne yeja caraja̱i maca yoꞌoye paꞌija̱ꞌcoa. ");
INSERT INTO seyNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Pa̱i Mamaquëpi jëjo daoja̱ꞌquë api, hui̱ñaohuaꞌire i̱ cua̱ñe te̱ꞌtere paꞌijë tayo yoꞌoye yecohuaꞌire necohuaꞌire, cuiꞌne coꞌacohuaꞌire tsiꞌsoja̱ꞌcohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tsiꞌsoni toana ëo je̱ojaꞌcohuaꞌi aꞌë. Ja̱ropi yuretaꞌa oijë cuiꞌne cu̱ji qui̱ꞌcoja̱ꞌhuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ja̱ maca Maijaꞌquë yëye yoꞌocohuaꞌipi ë̱së miañeje miajaꞌcohuaꞌi aꞌë, i̱ohuaꞌi pëca jaꞌquë te̱ꞌtere paꞌijë. Ja̱je paꞌina, mësarupi ca̱jonoa hueꞌecohuaꞌi pani ¡asajë̱ꞌë! ");
INSERT INTO seyNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Maꞌtëmo paꞌi te̱ꞌte cato curi mahuë yejana quë̱ni yahue o̱aseꞌeje̱ paꞌio. Ja̱je paꞌioni teꞌi pa̱ipi curi mahuëre ti̱ꞌani cuiꞌnaoni i̱ti macana se yahue o̱ani ai sihuaquë sani siꞌaye i̱ paye i̱si saoni curi quëꞌi yejare hueroseꞌeje̱ paꞌye aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Maꞌtëmo paꞌi te̱ꞌte cato coꞌamaña i̱siquëpi jai doꞌi quë̱nare pare perla hueꞌyosi quë̱na përe, coꞌequë cuꞌiyeje̱ paꞌye aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ja̱je coꞌequë jai doꞌire ti̱ꞌani siꞌaye i̱ paseꞌe i̱si je̱ani, jai doꞌi quë̱nare pare hueroyeje̱ paꞌye aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Maꞌtëmo paꞌi te̱ꞌte cato huaꞌi yoꞌeconi jai tsiayana je̱o dëoni coa siꞌa huaꞌire neñeje paꞌye aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Huaꞌi yoꞌeco ti̱mësi maca huaꞌi yoꞌecohuaꞌipi mejahuëna naë mani ja̱ropi ñuꞌijë sahuajë deꞌo huaꞌiseꞌere doꞌrohuëna ayajë coꞌacohuaꞌiseꞌere je̱ococohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ja̱je yeja caraja̱isi maca hui̱ñaohuaꞌipi etani coꞌacohuaꞌire cuiꞌne deꞌo huaꞌire sahuajë huahueja̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ja̱ maca coꞌacohuaꞌire cato toa cojena je̱o dëorena, ja̱ropi cu̱ji qui̱ꞌcojë oija̱ꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ja̱ maca Jesús se̱jiꞌi, ja̱ohuaꞌire: “¿Asaye mësaru siꞌaye iye?” Se̱ina, sehuohuë: “Ja̱je paꞌijë̱ꞌë asayë, Ëjaë.” ");
INSERT INTO seyNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Cajëna, Jesupi capi: “Cua̱ñeseꞌe yeꞌyaquëpi Maijaꞌquë cua̱ñe te̱ꞌte ayere ai yeꞌyequë pani huëꞌe paquëje̱ paꞌi po̱nëji, i̱ deꞌhuaseꞌere coꞌamaña cuiꞌne ai coꞌamaña etoquë i̱siyeje̱ paꞌirepa.” ");
INSERT INTO seyNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ja̱ maca Jesús ja̱je quëaquë yeꞌya tëjini sajiꞌi, yequë hue̱ꞌñana. ");
INSERT INTO seyNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Sai ti̱ꞌapi, i̱ yejana i̱ ai deꞌo sitona. Ja̱rona ti̱ꞌasiquëpi pa̱i tsiꞌsi hue̱ꞌñana yeꞌyapi. Yeꞌyaquëna, pa̱ipi ai cuasajë ñajë cahuë: “¿Jerona iquë yeꞌyeiꞌni, jerepa ta̱ꞌñe caye? ¿Merepa cuiꞌne pa̱i yoꞌo ti̱ꞌa maꞌñe yoꞌoquëꞌni? ");
INSERT INTO seyNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Carpintero mamaquëtaꞌa cuiꞌne i̱ñore paꞌiyë, i̱ pëca jaꞌco María. Cuiꞌne Jacobo, José, Simón, Judas paꞌiyë, i̱ yoꞌje tsi̱je. ");
INSERT INTO seyNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","I̱ñore i̱ yoꞌje tsi̱ nomiohuaꞌije̱ paꞌiyë. ¿Ja̱je paꞌito jerona iye siꞌaye yeꞌyeiꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ja̱je cajë coejë asaye pa̱huë, i̱ caye. Ja̱je coejëtaꞌare Jesupi capi, ja̱ohuaꞌire: “Siꞌaohuaꞌi yëyë, Maijaꞌquë jëjo daoquëre. Ja̱je paꞌiquëtaꞌare i̱ ai deꞌosi yeja acohuaꞌi cuiꞌne huëꞌe acohuaꞌirepa coeyë, i̱te.” ");
INSERT INTO seyNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","I̱te i̱re papi cajë asamaꞌ doꞌire ñaquë ja̱ro cato jaiye pa̱i yoꞌo ti̱ꞌa maꞌñe neñe pa̱pi. ");
INSERT INTO seyNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ja̱ muꞌseña Herodes Galilea cua̱ñequë pajiꞌi. Ja̱je paꞌipi Jesús pa̱i yoꞌo ti̱ꞌa maꞌñere yoꞌoyere asapi. ");
INSERT INTO seyNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Asani i̱ ja̱ꞌre co̱ni paꞌicohuaꞌire capi: “Juan oco doquëpi huëni tutu paquë yoꞌomaꞌquë.” ");
INSERT INTO seyNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ja̱je cuasapi, Herodes cato Juanre tse̱ani hue̱ni coꞌacohuaꞌire co hue̱ꞌñana cosiquë sëte yoꞌjei Felipe nëjo doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Juan cato caëña, Herodesre: “Më nëjore payeje̱ pamaꞌë paꞌijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ja̱je caquëna, Herodes Juanre huani je̱osiꞌi caquëtaꞌa pa̱ini caꞌraquë pa̱pi, siꞌaohuaꞌi Juanre Maijaꞌquë coca quëaquë api ca doꞌire caꞌraquë. ");
INSERT INTO seyNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ja̱je paꞌiquëtaꞌare i̱te Herodesre co̱asi muꞌseña ti̱ꞌasi maca Herodías mamacopi pa̱i tsiꞌsisicohuaꞌi ñajëna, etani pairacona, Herodes ñani ai sihuaquë. ");
INSERT INTO seyNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ca nëopi siꞌaye mëꞌë se̱ñe paꞌito i̱sisiꞌi, coꞌamaña. ");
INSERT INTO seyNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ja̱je ca maca pëca jaꞌcopi duꞌru yëhuosico sëte cao, Herodes: “Juan oco doquë si̱opëre quë̱na deꞌhuana ayasiconi i̱sijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ja̱je ca maca Herodes oi ëayerepa asapi. Ja̱je i̱pi tsoe siꞌaohuaꞌi soisicohuaꞌi asajëna, i̱sisiꞌi, më se̱ñere ca nëo huesosiquë sëte jëjo saopi, i̱sijë̱ꞌë caquë. ");
INSERT INTO seyNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ja̱ maca cua̱ñeiña, sani Juan cosiquë paꞌiquëre si̱opëseꞌe tëto tëaja̱ni, ");
INSERT INTO seyNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","quë̱na deꞌhuana ayasiconi dani i̱sihuë, nomi tsi̱ona. Ja̱opi se i̱sio, pëca jaꞌcona. ");
INSERT INTO seyNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ja̱je yoꞌorena, Juanre yeꞌyecohuaꞌipi dani i̱ ca̱pëseꞌe sani ta̱huë. Ta̱ni ja̱ jeteyoꞌje sani Jesure quëahuë, i̱ti yoꞌoseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ja̱ropi ja̱re asani Jesús sajiꞌi, pa̱i peo hue̱ꞌñana yohuëja̱ꞌa. Ja̱je saisiquëtaꞌare pa̱ipi asa ti̱ꞌani i̱te tui huëohuë, yejaja̱ꞌa pa̱i daripë paꞌicohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesús yohuëpi etaquë ñaquëna, jai pa̱i paëꞌë. Ja̱je paꞌijëna, teaye oi ja̱ohuaꞌire ñani jujupi, ju̱ꞌicohuaꞌire i̱ohuaꞌi dacohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tsoe naꞌiquëna, ñani i̱ yeꞌyacohuaꞌipi Jesús quëꞌrona dani cahuë: “Tsoe naꞌiji. I̱ño pa̱i peo hue̱ꞌñaꞌë. Deꞌoji. Ja̱ macaja̱ꞌa ca tëjijë̱ꞌë, sani pa̱i paꞌi hue̱ꞌñana hueroni a̱o maña a̱ijajë.” ");
INSERT INTO seyNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Cajëna, Jesupi capi, ja̱ohuaꞌire: “Saiye peoji. Ja̱ohuaꞌire mësarupi a̱ojëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Caquëna, ja̱ohuaꞌipi cahuë, i̱te: “Peoyë. Coa cinco pan cuiꞌne caya huaꞌire pare payë, i̱ño.” ");
INSERT INTO seyNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Cajëna, Jesupi capi: “Dajë̱ꞌë, i̱ñona i̱tire.” ");
INSERT INTO seyNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Cani cuiꞌne pa̱ire cua̱ñepi, tayahuëna jaꞌru sajë̱ꞌë, caquë. Ja̱ jeteyoꞌje i̱ jë̱ñapi cinco pan pë̱a cuiꞌne cayaohuaꞌire i̱ni ca̱jiquë maꞌtëmona ñaquë, Maijaꞌquëre deꞌoji caquë pëpapi. Pëpani panre jëꞌyeni i̱ yeꞌyacohuaꞌina i̱sipi. I̱sina, ja̱ohuaꞌipi pa̱ire se a̱ohuë. ");
INSERT INTO seyNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Siꞌaohuaꞌi a̱ni huajësicohuaꞌi paëꞌë. Ja̱ jeteyoꞌje a̱ni jujaseꞌere doce doꞌrohuë̱arepa ayahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ja̱ a̱isicohuaꞌi cato paëꞌë, cinco mil ë̱mëohuaꞌiseꞌe. Nomiohuaꞌire cuiꞌne tsi̱re cue̱cueye peoyerepa ja̱ohuaꞌique paꞌini ai jerepa paꞌiyë. ");
INSERT INTO seyNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ja̱ jeteyoꞌje Jesús pa̱ini pëpa tëjiquë i̱ yeꞌyacohuaꞌiseꞌere duꞌru jai yohuëna aya mëijëꞌë caëna, aya mëtena, jaira je te̱ꞌtena jëjo saopi. ");
INSERT INTO seyNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pa̱ire pëpa tëjini mëjiꞌi, jai cu̱tihuëna teꞌi, Maijaꞌquëre se̱siꞌi caquë. Ñami deꞌosi maca Jesús ja̱rote teꞌi pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Jai yohuë cato jopo jairare ja̱ yëꞌtaꞌa saio nëcoꞌë, to̱ꞌañepi yohuëna tutu juꞌaquëna, saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ñataquëna, Jesús i̱ohuaꞌi quëꞌrona tsioja̱jiꞌi, oco daꞌca ë̱mëjejaꞌa nëcaquë. ");
INSERT INTO seyNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ja̱ maca i̱ yeꞌyacohuaꞌi tsiayaja̱ꞌa nëcaquë daina, ñani quëquë huesëjë caꞌrajë cuihuë: “¡Pa̱i joyo huatio!” ");
INSERT INTO seyNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ja̱je cajëna, Jesupi capi, ja̱ohuaꞌire: “Quëcojë̱ꞌë, yëꞌë aꞌë. Caꞌramaꞌpë paꞌijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Caquëna, ja̱ maca Pedropi capi, ñeje: “Ejaë, mëꞌërepa pani yëꞌëreje̱ cua̱ñejëꞌë, tsiayaja̱ꞌa nëcaquë sasiꞌi, mëꞌë quëꞌrore pana.” ");
INSERT INTO seyNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Caquëna, Jesupi capi: “Daijë̱ꞌë.” Caëna, Pedropi yohuëpi cajeni tsiayaja̱ꞌa nëcaquë sai huëopi, Jesús paꞌi hue̱ꞌñana ti̱ꞌasiꞌi caquë. ");
INSERT INTO seyNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ja̱je saiquëtaꞌa tutu juꞌayena asaquë, quëquëquë duꞌi huëoquë cuipi: “¡Huasojë̱ꞌë, Ëjaë!” ");
INSERT INTO seyNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ja̱re i̱ti macapi Jesús jë̱ñana tse̱aquë capi, i̱te: “¡Yëꞌëna quëcoyere aꞌri maña paquë, mëꞌë! ¡Me yoꞌoquë nemaꞌquëje̱ paꞌire cuasaëꞌni!” ");
INSERT INTO seyNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Jai yohuëna aya mëisi maca tutu to̱mepi. ");
INSERT INTO seyNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ja̱ maca jai yohuë paꞌicohuaꞌipi Jesuna doꞌre jaꞌruni cahuë: “Nuñerepa mëꞌë Maijaꞌquë mamaquëre paꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Je̱ꞌejë ti̱ꞌahuë, Genesaret yejana. ");
INSERT INTO seyNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ti̱ꞌarena, pa̱ipi Jesús daiseꞌere asa ti̱ꞌani siꞌa hue̱ꞌña i̱ti yeja paꞌicohuaꞌire quëahuë. Quëarena, i̱ paꞌi hue̱ꞌñana ju̱ꞌicohuaꞌire dahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Dajë se̱iꞌë, i̱ juꞌi ca̱na patoni coꞌyato deꞌomaꞌquë cajë. Ja̱je cani siꞌaohuaꞌi i̱ juꞌi ca̱na patocohuaꞌipi coꞌya sahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Jerusalénpi fariseohuaꞌi cuiꞌne cua̱ñeseꞌe yeꞌyacohuaꞌipi daisicohuaꞌipi Jesús quëꞌrona tsio dani se̱iꞌë: ");
INSERT INTO seyNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“¿Me yoꞌojë mëꞌë yeꞌyacohuaꞌi mai aipë cua̱ñeseꞌe sehuocaiye pa̱ñeꞌni, ja̱ yëꞌtaꞌa a̱o a̱imaꞌnë jë̱ña tsoajë̱ꞌë, cua̱ñeseꞌe?” ");
INSERT INTO seyNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ja̱je cajëna, Jesupi se̱jiꞌi, ja̱ohuaꞌire: “¿Cuiꞌne mësaru me yoꞌojë Maijaꞌquë cua̱ñeseꞌe deꞌoye sehuocaimaꞌpë pa̱i cua̱ñeseꞌere deꞌoye sehuoyeꞌni? ");
INSERT INTO seyNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Maijaꞌquë cato capi: ‘Më jaꞌcore cuiꞌne më jaꞌquëre ëjaohuaꞌire ñaquë pajë̱ꞌë.’ Cuiꞌne capi: ‘Pëca jaꞌquëre cuiꞌne pëca jaꞌcore coꞌaye sa̱ñope caquë cato huani je̱o cua̱ñojaꞌquë.’ ");
INSERT INTO seyNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ja̱je paꞌiquëtaꞌare mësarupi cayë pëca jaꞌquëre cuiꞌne pëca jaꞌcore caye deꞌoji: ‘Tsoe siꞌaye yëꞌë paye Maijaꞌquëna i̱si saohuë. Ja̱je paꞌina, co̱caiye peoyë.’ ");
INSERT INTO seyNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Cuiꞌne ja̱je cacohuaꞌipi pëca jaꞌquëre pa̱nitaꞌa pëca jaꞌcore co̱caiye peoyë, cuasajë paꞌiyë. Ja̱je yoꞌojë Maijaꞌquë cua̱ñeseꞌere doꞌi peoye ne huesoni coa pa̱i cayere sehuocaijë paꞌiyë. ");
INSERT INTO seyNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Coa cacohuaꞌi! Nuñerepa Maijaꞌquëre quëacaiquë Isaías capi, mësaru ayere toyaquë ñeje: ");
INSERT INTO seyNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Iye pa̱i yëꞌëre yëꞌoposeꞌe oiyë, I̱ohuaꞌi joyo cato soꞌore paꞌina. ");
INSERT INTO seyNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Mësaru Maijaꞌquëre se̱ñe doꞌi peoye aꞌë, Pa̱iseꞌe cua̱ñeñepi huëojë yoꞌojëna.” ");
INSERT INTO seyNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ja̱ maca pa̱ire soini capi: “Deꞌhua asajë cuasa ti̱ꞌajëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yëꞌopoja̱ꞌa cacaye cato pa̱ire coꞌa deꞌhua maꞌñe aꞌë. Coa ai jerepa pa̱ire coꞌa deꞌhuaye cato yëꞌopopi etaye aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ja̱ maca i̱ yeꞌyacohuaꞌipi Jesús quëꞌrona tsio dani cahuë: “¿Asaë, mëꞌë fariseo pa̱i mëꞌë cayere asajë oiseꞌe?” ");
INSERT INTO seyNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ja̱je cajëna, i̱pi sehuopi, ja̱ohuaꞌire: “Yëꞌë jaꞌquë, maꞌtëmo paꞌiquë ta̱ maꞌñe cato peo hue̱ꞌñarepa duta ja̱ꞌñe aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Coa ñajëꞌë, i̱ohuaꞌiseꞌe paꞌija̱jë. Ja̱ohuaꞌi cato ñaco ca̱ peocohuaꞌi aꞌë. Cuiꞌne ñamaꞌcohuaꞌini cuacohuaꞌi aꞌë. Ja̱je paꞌina, ñamaꞌquëpi cuiꞌne ñamaꞌquëni sai saquë pani siꞌa jupë cojena duꞌiye paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pedropi ja̱ maca capi, Jesure: “Quëajë̱ꞌë, mëꞌë quëaseꞌe ayere.” ");
INSERT INTO seyNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Caquëna, Jesupi capi: “¿Mësaruje̱ ja̱ yëꞌtaꞌa asa ti̱ꞌamaꞌpë paꞌiye? ");
INSERT INTO seyNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Huesëye, mësaru, siꞌa a̱o yëꞌopoja̱ꞌa cacani ë̱tatuꞌuna saiseꞌepi jeteyoꞌje eta saiye? ");
INSERT INTO seyNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ja̱je paꞌiquëtaꞌare yëꞌopoja̱ꞌa etaye cato joyo paꞌiyepi etaji. Ja̱ꞌë, pa̱ire coꞌayerepa neñe. ");
INSERT INTO seyNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ja̱je paꞌina, joyopi etaji, coꞌaye cuasaye, huani je̱o ëaye, nomi ëaye cuasaye, coꞌamaña ñañe, coa cosoye, cuiꞌne coꞌa coca caye. ");
INSERT INTO seyNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Iye aꞌë, pa̱ire coꞌa deꞌhuayerepa. Jë̱ña tsoajë̱ꞌë cua̱ñeseꞌere sehuomaꞌpë a̱iñe cato pa̱ire coꞌaye ne maꞌñe aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesupi ja̱ropi etani sajiꞌi, Tiro cuiꞌne Sidón yejana. ");
INSERT INTO seyNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ja̱rote pacoꞌë, cananea nomio ja̱opi Jesús quëꞌrona cuico dacoꞌë, ñeje: “¡Ëjaë, David mamaquë oijë̱ꞌë, yëꞌë macare! Yëꞌë mamacopi huati joyore hueꞌeco, ai ai yoꞌoco coꞌayerepa.” ");
INSERT INTO seyNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ja̱je catoje̱ Jesús ti aꞌri mañaje sehuomaꞌë sajiꞌi. Saina, i̱ yeꞌyacohuaꞌipi dani i̱te se̱iꞌë: “Quëa saojë̱ꞌë, teꞌija. Coꞌaye mai jeteyoꞌjeja̱ꞌa cui daoco.” ");
INSERT INTO seyNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Cajëna, Jesupi capi: “Maijaꞌquë yëꞌëre jëjo daopi, Israel pa̱ini caquë yëi ñama ne huesëseꞌeje̱ paꞌioni caquë.” ");
INSERT INTO seyNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ja̱je paꞌiquëtaꞌare i̱ ña hue̱ꞌñana doꞌre jaꞌruni cao: “¡Ëjaë, co̱caijë̱ꞌë!” ");
INSERT INTO seyNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ja̱je cacona, Jesupi capi, ja̱ote: “Deꞌomaꞌcoa, mamajë a̱iconi a̱ore jioni joꞌya yaina a̱oto.” ");
INSERT INTO seyNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ja̱je catoje̱ i̱opi i̱te cao: “Ja̱je paꞌijë̱ꞌë, Ëjaë. Ja̱je paꞌiquëtaꞌare joꞌya yaije̱ a̱icohuaꞌi aꞌë, pa̱i a̱ni to̱ neꞌña mañaje.” ");
INSERT INTO seyNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ja̱je cacona, Jesupi capi, ja̱ote: “¡Nomio ta̱ꞌñerepa neñe paꞌiji, cuasayë, mëꞌë! Mëꞌë yëseꞌe neseꞌeje̱ paꞌija̱quë.” Caëna, i̱ti macapi i̱o mamaco coꞌyasico pacoꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús ja̱ropi etani Galilea jaira të̱ꞌtëpaja̱ꞌa tëto sani cu̱tihuëna mëni ja̱rona jaꞌrupi. ");
INSERT INTO seyNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ja̱rote paꞌina, jai pa̱i daëꞌë, i̱ paꞌi hue̱ꞌñana. Daijë dahuë, doꞌpëcohuaꞌire, ñamaꞌcohuaꞌire, asamaꞌcohuaꞌire, peo tupë̱are, cuiꞌne jai pa̱i yeque ju̱ꞌicohuaꞌire dahuë. Dani i̱ quë̱o yëꞌquë macana oijëna, Jesupi jujupi, ju̱ꞌicohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Pa̱i ña quëquëyerepa yoꞌopi, asamaꞌcohuaꞌipi cuiꞌne coca camaꞌcohuaꞌipi asajë cajëna, nëcañoa peo tupë̱api deꞌocohuaꞌi po̱nëjëna, doꞌpëcohuaꞌipi cuꞌijëna cuiꞌne ñamaꞌcohuaꞌipi, ñacohuaꞌi po̱nëjëna. Ja̱je yoꞌoquëna, ñajë Israel pa̱i Maijaꞌquëre ai deꞌoji cajë sihuahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ja̱ maca Jesús i̱ yeꞌyacohuaꞌire soini capi: “Teaye iye pa̱i mañare oi ñañë. Tres muꞌseña paꞌiji, i̱ño i̱ohuaꞌi paꞌiye. Ja̱je paꞌijë ti peoyë, i̱ohuaꞌi a̱i mañaje. Ja̱je paꞌina, a̱imaꞌcohuaꞌire huëꞌena jëjo saoye pa̱siꞌi saijë maꞌana dahuëra ju̱ꞌimaꞌcohuaꞌini.” ");
INSERT INTO seyNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Caquëna, ja̱ maca i̱ yeꞌyacohuaꞌipi cahuë, i̱te: “Ja̱je paꞌiquëtaꞌare ¿me i̱ño pa̱ije peo hue̱ꞌña a̱o hueroni a̱oñeꞌni, jai pa̱ire pare?” ");
INSERT INTO seyNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Cajëna, Jesupi se̱jiꞌi: “¿Je so̱ pan payeꞌni, mësaru?” Se̱ina, i̱ohuaꞌipi cahuë: “Siete pan cuiꞌne aꞌri maña tsiaya huaꞌire payë.” ");
INSERT INTO seyNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Cajëna, ja̱ maca pa̱ire cua̱ñepi, yejana jaꞌru sajë̱ꞌë caquë. ");
INSERT INTO seyNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jaꞌrusi maca siete pan cuiꞌne huaꞌire i̱ni Maijaꞌquëre deꞌoji caquë se̱jiꞌi. Se̱ni tëjini i̱ yeꞌyacohuaꞌina se i̱sina, ja̱ohuaꞌipi pa̱ire se a̱ohuë. ");
INSERT INTO seyNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ja̱ maca siꞌaohuaꞌi a̱ni huajëhuë. Ja̱je paꞌitoje̱ ja̱ yëꞌtaꞌa siete doꞌrohuë̱a a̱ni jujaseꞌe nëaëna, ayahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","I̱ti a̱isicohuaꞌi cato cuatro mil pa̱i paëꞌë, nomiohuaꞌire cuiꞌne tsi̱re cue̱cuemaꞌpëna. ");
INSERT INTO seyNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ja̱ jeteyoꞌje Jesús pa̱ire sai pëpa tëjini jai yohuëna aya mëni sajiꞌi, Magdala yejana. ");
INSERT INTO seyNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseohuaꞌi cuiꞌne saduceohuaꞌi co̱ni Jesure neñañuꞌu cajë dani maꞌtëmo ayere pa̱i yoꞌo ti̱ꞌa maꞌñere i̱ñojëꞌë se̱i, i̱pi yoꞌouna, ñani tse̱añuꞌu cajë. ");
INSERT INTO seyNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ja̱je cajë se̱jëna, i̱pi sehuopi, ja̱ohuaꞌire: “Naꞌiquëna, maꞌtëmo majaꞌico paꞌina, ñani mësaru cacohuaꞌi aꞌë, ‘Deꞌo muꞌse paꞌija̱ꞌcoa.’ ");
INSERT INTO seyNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Cuiꞌne ñataquëna, nea siri paꞌina, ñani cacohuaꞌi aꞌë, ‘yure cato coꞌa muꞌse paꞌija̱ꞌcoa.’ ¡Mësaru, coa cacohuaꞌi aꞌë! Maꞌtëmore ñani ta̱ꞌñe asacohuaꞌitaꞌa ¿me yoꞌojë iye muꞌseña yoꞌoye ñani ta̱ꞌñe camaꞌpë ja̱ yëꞌtaꞌa huesëcohuaꞌi paꞌiyeꞌni? ");
INSERT INTO seyNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Iye coꞌa pa̱i nuñe yoꞌomaꞌcohuaꞌipi se̱ñë, maꞌtëmo yoꞌoyere nejëꞌë ñañuꞌu cajë. Ja̱je se̱jëtaꞌare Jonásre yoꞌoseꞌeje̱ paꞌyepi i̱ñoseꞌe pasipi. Jerepa yoꞌo i̱ñoñe peoji.” Ja̱je cani je̱oni sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jaira je tëꞌhuina je̱ꞌejë i̱ yeꞌyacohuaꞌi pan sayere hua̱nëyeiꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Hua̱nëyesicohuaꞌini Jesupi ja̱ohuaꞌire capi: “I̱na deꞌhua ñajëꞌë, fariseohuaꞌi cuiꞌne saduceohuaꞌi oꞌsaque paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Caquëna, i̱ yeꞌyacohuaꞌipi sa̱ꞌñe i̱ohuaꞌija̱ꞌa cahuë: “Mai panre damaꞌpë patena, caji.” ");
INSERT INTO seyNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ja̱je yahue caye Jesupi asani capi, ja̱ohuaꞌire: “¿Me yoꞌojë pan peoyë cayeꞌni? ¿Ai jerepa mësaru, yëꞌëre nequë api, cuasayere peoyeꞌni? ");
INSERT INTO seyNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ja̱ yëꞌtaꞌa asa ti̱ꞌañe pa̱ñe, cuiꞌne ñañe pa̱re cinco pan paꞌiseꞌere cinco mil pa̱ire a̱oseꞌeje̱ cuiꞌne a̱ni jujarena, doꞌrohuë̱ana deꞌhuaseꞌeje̱? ");
INSERT INTO seyNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Cuiꞌne siete pan paꞌiseꞌepi cuatro mil pa̱ire a̱o maca doꞌrohuë̱a nëaseꞌeje̱ cuasaye pa̱ñe? ");
INSERT INTO seyNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Me yoꞌojë mësaru yëꞌë ca maca panre caji, cuasareꞌni? Deꞌhua ñajëꞌë, fariseohuaꞌi cuiꞌne saduceohuaꞌi oꞌsana co̱ꞌme huesëye.” ");
INSERT INTO seyNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ja̱je ca maca cuasa ti̱ꞌahuë, Jesús pan neñere camaꞌë paꞌiseꞌere. Coa ai jerepa Fariseo cuiꞌne saduceohuaꞌi yeꞌyayere caseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesús Cesarea Filipo yeja quëꞌrona ti̱ꞌani i̱ yeꞌyacohuaꞌire se̱jiꞌi: “¿I̱queipi cayeꞌni, Pa̱i Mamaquëre?” ");
INSERT INTO seyNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Caquëna, ja̱ohuaꞌipi cahuë: “Yecohuaꞌipi cayë, Juan oco doquë api. Yecohuaꞌipi cayë, Elíaspi. Cuiꞌne yecohuaꞌipi ja̱ yëꞌtaꞌa yeque cayë, Jeremiaspi pa̱nitaꞌa yequë Maijaꞌquë jëjo daoquë api, caye.” ");
INSERT INTO seyNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ja̱ maca ja̱ohuaꞌire capi: “Cuiꞌne mësarutaꞌa ¿i̱queipi cayeꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Caquëna, Simón Pedropi capi: “Mëꞌë cato Cristo aꞌë, Diusu huajëquërepa mamaquë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Caquëna, Jesupi sehuopi: “Deꞌoji. Simón Jonás mamaquë yecohuaꞌije̱ mëꞌëre quëaye pa̱huë. Coa yëꞌë Jaꞌquë maꞌtëmo paꞌiquëpi i̱ñopi. ");
INSERT INTO seyNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ja̱je paꞌina, yëꞌëpi mëꞌëre cayë Pedro ja̱re iye quë̱na pë ë̱mëjeꞌena yëꞌë huëꞌe nesiꞌi. Neina, ju̱ꞌiñe tutuje̱ quëcoquë ti neñe peoji. ");
INSERT INTO seyNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Yëꞌëpi mëꞌëre maꞌtëmo paꞌi te̱ꞌte huiꞌyocore i̱sija̱ꞌquë aꞌë. Mëꞌëpi iye yejana sëaquë paꞌito maꞌtëmoje sëaye paꞌiji. Cuiꞌne mëꞌëpi iye yejana joyequë paꞌito maꞌtëmoje joyeye pasipi.” ");
INSERT INTO seyNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ja̱ maca Jesupi cua̱ñepi, i̱ yeꞌyacohuaꞌire. Yëꞌëre Cristo api, cajë pa̱ire quëamaꞌpë caquë. ");
INSERT INTO seyNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ja̱re ja̱ macapi Jesupi quëa huëopi, i̱ yeꞌyacohuaꞌire. Jerusalénna sani ai yoꞌoja̱ꞌquë aꞌë, Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌipi cuiꞌne cua̱ñeseꞌe yeꞌyacohuaꞌipi yoꞌojëna, caquë. Cuiꞌne capi, ja̱je yoꞌojë huani je̱ojaꞌcohuaꞌi aꞌë. Ja̱je huani je̱osicohuaꞌitaꞌare toaso̱ muꞌseña paꞌi maca huëija̱ꞌquë aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ja̱ maca Pedropi ti̱rona i̱te sani yëhuosiꞌi caquë capi: “¡Maijaꞌquëje̱ ja̱je yoꞌoye coeji, Ëjaë! ¡Ja̱je yoꞌoye ti peoja̱quë mëꞌëre!” ");
INSERT INTO seyNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ja̱je caquëna, Jesús coꞌye po̱nëni ñani i̱te Pedrore capi: “Saijë̱ꞌë. Yëꞌë quëꞌro paꞌimaꞌë, huati ëjaë. Yëꞌëre jo̱sa tëhuoquë, ai. Mëꞌë cato Maijaꞌquë cuasayeje̱ cuasamaꞌquë aꞌë. Coa pa̱i cuasayeje̱ cuasaquë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ja̱ maca Jesupi i̱ yeꞌyacohuaꞌire capi: “Yëꞌëre tuiye yëcohuaꞌi pani hua̱nëyeye paꞌi coꞌye deꞌoye paꞌiyere. Ja̱je yoꞌoni ai yoꞌoye paꞌito quëcojë tuiye paꞌiji, coꞌye cuasamaꞌpë. ");
INSERT INTO seyNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ja̱je paꞌina, coꞌye deꞌoye paꞌiyere cuasaquë yoꞌoquëpi coa ne huesoja̱ꞌquë api, i̱ paꞌiye. Ja̱je paꞌiquëtaꞌare yëꞌë doꞌire ai yoꞌoquë i̱ paꞌiye ne huesosiquëpi ti̱ꞌajaꞌquë api, paꞌiye. ");
INSERT INTO seyNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ja̱je paꞌina, ¿I̱quere co̱caiye paꞌiquëꞌni, pa̱ipi siꞌaye iye yejana coꞌamañare pajëtaꞌa joyore ne huesoto? ¿Je jaꞌye sa̱iñe paꞌiquëꞌni, i̱ joyo doꞌire? ");
INSERT INTO seyNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ja̱je paꞌina, Pa̱i Mamaquë daija̱ꞌquë api, siꞌa i̱ pëca jaꞌquë deꞌo tutu quëꞌipi cuiꞌne i̱ hui̱ñaohuaꞌina co̱ni. Ja̱ maca i̱pi sa̱ijaꞌquë api, teꞌohuaꞌiseꞌe yoꞌoseꞌeje̱ paꞌye. ");
INSERT INTO seyNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ja̱je paꞌina, nuñerepa cayë, ja̱ yëꞌtaꞌa yure paꞌicohuaꞌi ju̱ꞌimaꞌpë Pa̱i Mamaquë i̱ quëꞌropi daina, ñajaꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Seis muꞌseña tëto sai maca Jesupi sapi, Pedrore, Jacobore cuiꞌne Juanre Jacobo yoꞌjeire teꞌi ja̱ohuaꞌi ja̱ꞌre sajiꞌi, jai ë̱më cu̱tihuëna. ");
INSERT INTO seyNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ja̱rona i̱ ca̱pë i̱ohuaꞌique ñajëna, ti̱ñerepa po̱nëpi. I̱ tsia cato ë̱së mëiñeje paꞌyere miaco po̱nëpi. Cuiꞌne i̱ juꞌi ca̱pi toaje̱ paꞌiorepa po̱nëpi, miañerepa. ");
INSERT INTO seyNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Cuiꞌne ja̱ maca ñañuꞌu cuasamaꞌpë paꞌiseꞌere ñahuë, Moisés cuiꞌne Elías, Jesús ja̱ꞌre cocare cajëna. ");
INSERT INTO seyNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ja̱ maca Pedropi capi, Jesure: “Ëjaë, ¡Deꞌoji. Yuretaꞌa i̱ñore pañuꞌu! Mëꞌëpi yëto neñuꞌu toaso̱ aꞌri huë̱ꞌña: mëꞌë tse̱core teꞌore, Moisés tse̱core, cuiꞌne Elías tse̱core yecore.” ");
INSERT INTO seyNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ja̱ yëꞌtaꞌa Pedro cocare caquëna, miacore papi sirio nëca meni peo hue̱ꞌña ca̱ꞌne huesona sirio jopopi yëꞌoseꞌe ñeje pi̱siquëna, asahuë: “Iquë yëꞌë mamaquëre papi i̱ni ai sihuaquë paꞌiyë. Asajë̱ꞌë, i̱ cayere.” ");
INSERT INTO seyNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Iyere asani i̱ yeꞌyacohuaꞌi yejana i̱ohuaꞌi tsiapi meñe simeni u̱ëꞌë, quëquëquë huesëni. ");
INSERT INTO seyNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ja̱ maca Jesupi i̱ohuaꞌi quëꞌrona tsioja̱ni patoquë capi: “Huëijë̱ꞌë. Caꞌramaꞌpë paꞌijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Caquëna, huëijë coa Jesuseꞌe teꞌi paꞌina, ñahuë, yecohuaꞌitaꞌa peojëna. ");
INSERT INTO seyNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ja̱ropi cajejëna, Jesupi cua̱ñepi, ja̱ohuaꞌire: “Quëamaꞌpë paꞌijë̱ꞌë, yecohuaꞌire, iye mësaru ñaseꞌe. Pa̱i Mamaquë ju̱ꞌisiquëpi cuiꞌnaëpi huëimaꞌë paꞌito ju̱ni huëisi maca quëajë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ja̱ maca i̱ yeꞌyacohuaꞌipi Jesure se̱iꞌë: “¿Me yoꞌojë cua̱ñeseꞌe yeꞌyacohuaꞌi ja̱je paꞌito Elíaspi duꞌru daija̱ꞌquë api, cayeꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Cajëna, Jesupi sehuopi: “Nuñerepa cayë. Duꞌru daija̱ꞌquë api. Siꞌaye ne deꞌhuaja̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ja̱je paꞌiquëtaꞌare yëꞌëpi cayë, mësarute. Elíaspi tsoe dajiꞌi. Daisiquëtaꞌare i̱ohuaꞌipi deꞌhua ñamaꞌpë coa i̱ohuaꞌi yëyeje̱ yoꞌohuë, i̱te. Ja̱je cuiꞌne Pa̱i Mamaquëje̱ ai yoꞌoja̱ꞌquë api, ja̱re ja̱ohuaꞌi jë̱ñapi yoꞌojëna.” ");
INSERT INTO seyNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ja̱ maca i̱ yeꞌyacohuaꞌipi cuasa ñajaëꞌë, Juan oco doquë paꞌisiquëni caji cuasajë. ");
INSERT INTO seyNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pa̱i paꞌi hue̱ꞌñana daisi maca Jesús quëꞌrona teꞌi tsio dani i̱ ña hue̱ꞌñana doꞌre jaꞌruni capi: ");
INSERT INTO seyNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Ëjaë, oijë̱ꞌë, yëꞌë mamaquëre. Ai yoꞌoji, hueꞌhue dahuëre hueꞌequë. Ja̱je paꞌipi jaiye toana ta̱i yequere tsiayana duꞌi yoꞌoji. ");
INSERT INTO seyNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Iye macana dahuë, i̱te. Mëꞌë yeꞌyacohuaꞌina, i̱ñosiquëtaꞌare juju ti̱ꞌamaꞌpë paëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Caquëna, Jesupi sehuopi: “¡I̱na, necaiquë api cuasamaꞌ pa̱i cuiꞌne coꞌacohuaꞌi! ¿Je yëhuarepa paꞌija̱ꞌquë aꞌni, mësaru ja̱ꞌre co̱ni? ¿Je yëhuarepa quëcoja̱ꞌquë aꞌni? Dajë̱ꞌë, i̱ñona tsihuaꞌëre.” ");
INSERT INTO seyNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Cani ja̱ maca Jesupi coꞌa joyore pë̱ni eto saopi, tsihuaꞌëre paꞌisicore. Ja̱re i̱ti macapi tsihuaꞌë huajëquë coꞌyapi. ");
INSERT INTO seyNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ja̱ jeteyoꞌje i̱seꞌere i̱ yeꞌyacohuaꞌi cahuë: “¿Me yoꞌojë yëquë huatire eto saoye pa̱reꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Se̱jëna, Jesupi capi: “Mësaru ne ti̱ꞌañe peoji, cuasayere payë. Nuñerepa cayë. Mësarupi mostaza ca̱ jaꞌiore ne ti̱ꞌañe paꞌiji cuasayere hueꞌecohuaꞌi pani caraꞌhuë ja̱ cu̱tihuëre: ‘Saijë̱ꞌë, iye macapi yequë hue̱ꞌñana.’ Carena, ai cu̱tihuëpi saija̱ꞌcoa. Ti coa ca jujaye peoji, mësarupi neñe paꞌiji cuasacohuaꞌi pani. ");
INSERT INTO seyNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ja̱je paꞌiquëtaꞌare iye coꞌa joñoare cato, eto saoye paꞌiji Maijaꞌquëre se̱ñepi cuiꞌne a̱o a̱imaꞌpë se̱ñepi.” ");
INSERT INTO seyNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Siꞌa jupë Galilea quëꞌrore cuꞌi maca Jesupi capi, ja̱ohuaꞌire: “Pa̱i Mamaquëre tse̱ani pa̱ina i̱si huesoja̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ja̱je yoꞌojë huani je̱ojaꞌcohuaꞌi aꞌë. Ja̱je huani je̱osicohuaꞌitaꞌare toaso̱ muꞌseña paꞌi maca cuiꞌnaëpi huëija̱ꞌquë api.” Ja̱je quëaquëna, ai oi ëaye asahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesús cuiꞌne i̱ yeꞌyacohuaꞌi Capernaum daripëna ti̱ꞌasi maca Maijaꞌquë huëꞌe doꞌire curiquë se̱cohuaꞌipi Pedrore sani ñani se̱iꞌë: “¿Mësaru yeꞌyaquë curiquë sa̱iquë Maijaꞌquë huëꞌe doꞌi?” ");
INSERT INTO seyNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Cajëna, Pedropi sehuopi: “Ja̱je paꞌijë̱ꞌë. Sa̱iji.” Ja̱je cani huëꞌena Pedropi cacaquëna, Jesupi duꞌru i̱te capi, ñeje: “¿Me cuasaquëꞌni, mëꞌë Simón? ¿Neni iye yeja ëjaohuaꞌi coꞌamaña pa doꞌi cuiꞌne paꞌi doꞌi se̱ñeꞌni, i̱ohuaꞌi tse̱cohuaꞌi panitaꞌa ti̱ohuaꞌini se̱ñe?” ");
INSERT INTO seyNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Caquëna, Pedropi sehuopi, i̱te: “Ti̱ohuaꞌini se̱ñë.” Caquëna, Jesupi capi, i̱te: “Ja̱je paꞌito i̱ohuaꞌi tse̱cohuaꞌi cato sa̱iñe peoji. ");
INSERT INTO seyNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ja̱je paꞌiquëtaꞌare sa̱ñope yoꞌoyere coejë sa̱iñuꞌu. Ja̱je paꞌito jairana sani mojëꞌë, huaꞌini. Duꞌru macarepa huiꞌyoquëni moni i̱ yëꞌopore curiquë paꞌina, i̱ni sani sa̱ijëꞌë, siꞌaye, yëꞌë paꞌi doꞌi cuiꞌne mëꞌë doꞌi co̱ni teꞌepi.” ");
INSERT INTO seyNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ja̱re ja̱ macapi i̱ yeꞌyacohuaꞌi Jesús quëꞌrona tsioja̱ni se̱teña, i̱te: “¿Nepi jerepa paꞌiohuaꞌi paꞌija̱ꞌcohuaꞌi aꞌni, maꞌtëmo?” ");
INSERT INTO seyNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Cajëna, ja̱ maca Jesupi tsihuaꞌëre soini i̱ohuaꞌi jopona nëcoquë ");
INSERT INTO seyNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","capi: “Nuñerepa cayë. Mësarupi ja̱ꞌrë paꞌiseꞌe je̱oni cuiꞌne tsihuaꞌëje̱ paꞌiohuaꞌi deꞌomaꞌpë pani maꞌtëmo caca ti̱ꞌañe peoji. ");
INSERT INTO seyNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ja̱je paꞌina, i̱ti jerepa paꞌi maꞌtëmo paꞌi te̱ꞌtequëpi, ai jerepa paꞌi aꞌë cuasamaꞌquëpi iquë tsihuaꞌëje̱ paꞌi paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Cuiꞌne yëꞌëni cuasajë iquëre tsihuaꞌëre deꞌoye necaicohuaꞌi pani yëꞌëni necaiyë. ");
INSERT INTO seyNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yëꞌëre asaquëni yequëpi coꞌaye yoꞌoyere yeꞌyaquë paꞌito jai quë̱na pëpi ñaje tëcana sëani jai tsiayana hua̱i hue̱ꞌñana je̱o dëoto deꞌoji. ");
INSERT INTO seyNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Coꞌacore paꞌni, iye yeja, pa̱ire coꞌaye yoꞌoyena ne ta̱oco! Pa̱ire coꞌayena ne ta̱oñere jëaye ti peoji. Ja̱je paꞌiquëtaꞌare yecohuaꞌire coꞌaye yoꞌoyena yeꞌyaquë ne ta̱ñoquëpi ai jerepa teaye coꞌaquëpi paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ja̱je paꞌina, mëꞌë jë̱tëpi pa̱nitaꞌa mëꞌë nëcayopi coꞌaye yoꞌoyena saco paꞌito tëto tëani soꞌona je̱ocojë̱ꞌë. Ai jerepa deꞌoji, paꞌi hue̱ꞌñana saiyepi peo tupëpi, pa̱nitaꞌa doꞌpëquëpi, toa yejana caya jë̱ña cuiꞌne caya nëcañoa hueꞌequëpi je̱oco cua̱ñoto coꞌaji. ");
INSERT INTO seyNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Pa̱nitaꞌa mëꞌë ñacoapi coꞌayena saco paꞌito duta je̱oni soꞌona je̱ocojë̱ꞌë. Ai jerepa deꞌoji, paꞌi hue̱ꞌñana cacayepi teꞌe ñacoa hueꞌequë api, toa yejana caya ñaco ca̱ hueꞌequëpi je̱oco cua̱ñoto coꞌaji. ");
INSERT INTO seyNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Coemaꞌpë paꞌijë̱ꞌë, icohuaꞌi aꞌricohuaꞌire. Quëare payë. Ja̱ohuaꞌi cato hui̱ñaohuaꞌire payë, maꞌtëmore yëꞌë jaꞌquë ña hue̱ꞌñare. ");
INSERT INTO seyNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Pa̱i Mamaquë cato daisiquë api, ne huesëseꞌere huasosiꞌi caquë. ");
INSERT INTO seyNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Me yoꞌoquë aꞌni? Cien yëi ñamare paquëni teꞌi ne huesësiquë paꞌito sani coꞌequë api, noventa y nueve ñamare cu̱tina je̱o sani. ");
INSERT INTO seyNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ja̱je coꞌequë ne huesësiquëre ti̱ꞌasiquë pani noventa y nueve ne huesëmaꞌcohuaꞌire sihuaye jerepa sihuaquë api. ");
INSERT INTO seyNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ja̱je cuiꞌne mësaru jaꞌquë maꞌtëmo paꞌiquëje̱ coꞌeji, teꞌe aꞌriquëje̱ ne huesëye pa̱jaꞌquë caquë. ");
INSERT INTO seyNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Mëꞌë yoꞌjeipi coꞌaye mëꞌëre yoꞌosiquë paꞌito i̱seꞌere cajë̱ꞌë, i̱ tayoseꞌe asa sëtaja̱ꞌquëre. Ja̱je caquëna, mëꞌë cayere asani sehuocaisiquë paꞌito, mëꞌë yoꞌjeire se quëcohuë, mëꞌëpi. ");
INSERT INTO seyNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ja̱je paꞌiquëtaꞌare mëꞌë caye asa yëmaꞌë paꞌito ja̱ maca soijë̱ꞌë, teꞌire pa̱nitaꞌa cayaohuaꞌire i̱ yoꞌoye ñacohuaꞌipi teꞌe cuiꞌne paꞌye caja̱ꞌcohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ja̱ohuaꞌireje̱ asamaꞌë paꞌito quëajë̱ꞌë, jai pa̱i tsiꞌsi sitona. Jai pa̱i catoje̱ asa yëmaꞌë paꞌina, ja̱ maca Maijaꞌquëre asa maꞌñeje paꞌire je̱ojëꞌë, pa̱nitaꞌa paꞌi doꞌi curiquë se̱quëje̱ paꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Nuñerepa cayë, mësarute. Iye yejana mësaru sëasiquë pani maꞌtëmoje sëasiquë pasipi. Cuiꞌne mësarupi iye yejana joyesiquë pani cuiꞌne joyesiquë pasipi, maꞌtëmoje. ");
INSERT INTO seyNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Cuiꞌne cayë, mësarute yequeje̱. Mësarupi cayaohuaꞌi iye yejare paꞌijë teꞌe cuasajë Maijaꞌquë coꞌamañare se̱to yëꞌë jaꞌquë maꞌtëmo paꞌiquëpi i̱sija̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ja̱je paꞌina, cayaohuaꞌi panitaꞌa toaso̱cohuaꞌi yëꞌë mamire cajë tsiꞌsicohuaꞌi paꞌito ja̱rote yëꞌëje̱ paꞌija̱ꞌquë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ja̱ maca Pedro sani Jesure se̱jiꞌi: “¿Ëjaë, yëꞌëni yëꞌë yoꞌjeipi coꞌaye yoꞌoquë paꞌito je so̱ñe sa̱i deꞌhuacaija̱ꞌquë aꞌni, i̱te?” ");
INSERT INTO seyNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Caquëna, Jesupi sehuopi: “Sieteja̱ꞌa paꞌye sa̱i deꞌhuacaijë̱ꞌë caye pa̱ñë. Ai jerepa sa̱i deꞌhuacaijë̱ꞌë, siete paꞌye setenta. ");
INSERT INTO seyNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ja̱je paꞌina, maꞌtëmo paꞌi te̱ꞌte cato pa̱i ëjaëpi i̱te necaicohuaꞌi ne doꞌire sa̱iñeje paꞌye aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ja̱ꞌa ne deꞌhua huëoquëna, jaiye curiquë i̱ doꞌi sa̱iñe paquëre dahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Darena, i̱ joꞌyaë curiquë peoquë pajiꞌi. Ja̱je peoquë paꞌina, i̱ ëjaëpi cua̱ñepi, i̱si je̱ojëꞌë, i̱te cuiꞌne i̱ nëjore, mamajëre cuiꞌne siꞌaye i̱ coꞌamañaje ja̱ curipi i̱ doꞌi paye sa̱ijaꞌquëre. ");
INSERT INTO seyNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ca maca i̱ joꞌyaëpi i̱ ëjaë ña hue̱ꞌñana doꞌre jaꞌruni se̱jiꞌi: ‘Ëjaë, quëcojë̱ꞌë, yëꞌë macare. Sa̱ijaꞌquë aꞌë, siꞌaye mëꞌëre.’ ");
INSERT INTO seyNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Caquëna, ëjaëpi i̱te teaye caji cuasani oi ne deꞌhuacani eto huasopi. ");
INSERT INTO seyNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ja̱ maca joꞌyaëpi esa etani sai ti̱ꞌapi, yequëre i̱ cajeire, cuiꞌne necaiquëre ti̱ꞌani ñaje tëcana tse̱ani huani je̱o huëopi, ñeje caquë: ‘Sa̱ijëꞌë, mëꞌë yëꞌëre doꞌi payere.’ Ja̱ë cato aꞌri maña i̱te doꞌi paquëni ja̱je yoꞌopi. ");
INSERT INTO seyNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ja̱ maca i̱ cajeipi doꞌre jaꞌruni se̱jiꞌi: ‘Quëcojë̱ꞌë, sa̱ijaꞌquë aꞌë, siꞌaye mëꞌëre doꞌi paye.’ ");
INSERT INTO seyNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ja̱je catoje̱ yequëpi coequë coa ai jerepa pa̱ire coꞌa hue̱ꞌñana sani copi, sa̱isi maca etoja̱ꞌquë api, caquë. ");
INSERT INTO seyNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ja̱ maca ëjaë joꞌyapi iyere ñani ai coꞌa ju̱ꞌijë sani quëahuë, i̱ohuaꞌi ñaseꞌere siꞌaye. ");
INSERT INTO seyNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ja̱ maca i̱ ëjaëpi jëjo saopi, i̱te soija̱ꞌcohuaꞌire. Soini capi, i̱te: ‘Coꞌa merepa coꞌa joꞌyaë. Yëꞌëpi mëꞌëre sa̱i deꞌhuacaëꞌë, siꞌaye mëꞌë doꞌi paꞌiseꞌe mëꞌëpi se̱ina. ");
INSERT INTO seyNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mëꞌëje cuiꞌne mëꞌë cajeire quëcoquë sa̱i deꞌhuacaiye pajiꞌi, yëꞌë mëꞌëre teaye caquëna, sa̱i deꞌhuacaiseꞌeje̱.’ ");
INSERT INTO seyNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ja̱ maca i̱ ëjaëpi pë̱i ja̱je yoꞌosi doꞌire cojë̱ꞌë, cua̱ñepi, siꞌaye sa̱ina, je̱ojëꞌë caquë.” ");
INSERT INTO seyNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesupi ja̱je ca tëjiquë capi: “Ja̱je cuiꞌne yëꞌë jaꞌquë maꞌtëmo paꞌiquëje̱ mësaruteje̱ yoꞌoja̱ꞌquë api, mësarupi pa̱i ñape cajeire joyore papi coꞌaye yoꞌoseꞌe sa̱i deꞌhuacaiye pa̱cohuaꞌire.” ");
INSERT INTO seyNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesús iye coca casi jeteyoꞌje Galileapi sajiꞌi. Sai Judea quëꞌrona Jordán tsiaya quëꞌrona ë̱së mëi te̱ꞌtena ti̱ꞌapi. ");
INSERT INTO seyNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Jai pa̱i i̱te peꞌtehuë. Peꞌterena, ja̱rona ju̱ꞌicohuaꞌire jujupi. ");
INSERT INTO seyNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ja̱ maca fariseohuaꞌi Jesure tsioja̱ni se̱iꞌë, tayo sehuouna, tse̱añuꞌu cajë ñeje: “¿Nëjore je̱ocoye paꞌiquë coa aꞌri maña yequere yoꞌona?” ");
INSERT INTO seyNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Cajëna, i̱pi ja̱ohuaꞌire sehuopi: “¿Ñamaꞌcohuaꞌi aꞌni, toyaseꞌe caye siꞌaye duꞌru paꞌi huëoseꞌe nesiquëpi ‘Nepi ë̱mëre cuiꞌne nomiore’? ");
INSERT INTO seyNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Cuiꞌne caji: ‘Ja̱je paꞌina, pëca jaꞌquëre cuiꞌne pëca jaꞌcore je̱oni nëjona tsioni cayaohuaꞌi paꞌimaꞌpë coa teꞌije̱ paꞌiohuaꞌi paꞌija̱ꞌcohuaꞌi aꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ja̱je paꞌina, cayaohuaꞌi paꞌiye paja̱ꞌcohuaꞌi aꞌë. Coa ai jerepa teꞌi paꞌija̱ꞌcohuaꞌi aꞌë. Ja̱je paꞌina, ë̱mëpi nëjore je̱ocoye peoji, Maijaꞌquë ñaquë tsioseꞌe.” ");
INSERT INTO seyNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ja̱ maca i̱te se̱iꞌë: “¿Me yoꞌoquë Moisés nëjore je̱ocoye paꞌiji, toya jaꞌhuana je̱oco doꞌire toyani cua̱ñeiꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Cajëna, Jesupi capi: “Mësaru jëa joyo paꞌi doꞌire Moisés je̱ocoye deꞌoji, capi. Duꞌru paꞌi huëo maca cato ja̱je paꞌiye pa̱pi. ");
INSERT INTO seyNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ja̱je paꞌina, yëꞌëpi cayë. Yequë ë̱mëohuaꞌire yoꞌomaꞌona je̱oconi yequë nomiore huejaquë pani tsoe coꞌa deꞌopi, yecore yoꞌo doꞌire. Cuiꞌne je̱ocosi nomioni po̱sëpi huejaquë panije cuiꞌne coꞌa deꞌoji, ë̱jëre paconi yoꞌoquë.” ");
INSERT INTO seyNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ja̱ maca i̱ yeꞌyacohuaꞌipi cahuë: “Ja̱je paꞌiye sëte ë̱mëpi nomiore huejaye coꞌaji.” ");
INSERT INTO seyNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Cajëna, Jesupi capi: “Siꞌaohuaꞌi iye asaye peoji. Coa Maijaꞌquë ta̱ꞌñe asaye i̱sisicohuaꞌiseꞌe asaye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Iye doꞌire yecohuaꞌi ë̱mëohuaꞌi huejamaꞌcohuaꞌi paꞌiyë. Tsi̱ꞌnëna coꞌa deꞌosicohuaꞌi ai deꞌoyë, pa̱ipi huejamaꞌpë paꞌija̱jë cajë coꞌa deꞌhuasicohuaꞌi paꞌiyë. Yecohuaꞌipi huejamaꞌcohuaꞌi paꞌiyë, maꞌtëmo ayere cajë. Iye yëꞌë caseꞌe yëquëpi ja̱je pasiꞌi cuasani ja̱je huejamaꞌquë paꞌijë̱ꞌë. Pa̱i ñape ti̱ñe paꞌi doꞌire ë̱mëohuaꞌi huejaye pa̱ñë. Yecohuaꞌipi hueja ti̱ꞌañe paꞌija̱ꞌcohuaꞌipi ai deꞌoyë. Pa̱ipi huejamaꞌpë paꞌija̱ꞌcohuaꞌire nesicohuaꞌipi pa̱ñë. Yecohuaꞌipi maꞌtëmo paꞌiyere cajë huejaye pa̱ñë. Ja̱je pasiꞌi cani ja̱je paꞌijë̱ꞌë, ai cuasaquëpi.” ");
INSERT INTO seyNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ja̱ maca tsi̱re Jesús quëꞌrona dahuë, i̱pi jëñapi patoquë se̱cacaija̱quë cajë. Ja̱je yoꞌojëna, i̱ yeꞌyacohuaꞌipi tsi̱re dacohuaꞌire damaꞌpë cajë ë̱sehuë. ");
INSERT INTO seyNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ja̱je cajëna, Jesupi capi: “Coa ñajëꞌë, tsi̱ i̱ohuaꞌiseꞌe yëꞌë quëꞌrona daija̱jë. Ë̲semaꞌpë paꞌijë̱ꞌë. Maꞌtëmo cato ja̱ohuaꞌije̱ paꞌiohuaꞌi tse̱coa.” ");
INSERT INTO seyNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ja̱ maca tsi̱re i̱ jë̱ñapi patoquë yoꞌo tëjini sajiꞌi, yequë hue̱ꞌñana. ");
INSERT INTO seyNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Po̱sëpi jaiye coꞌamaña paquëpi Jesure sani se̱jiꞌi: “Deꞌo yeꞌyaquë. ¿I̱que deꞌo coꞌamañare yoꞌoja̱ꞌquë aꞌni, maꞌtëmo ti pani huesëye ti̱ꞌasiꞌi cani?” ");
INSERT INTO seyNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Caquëna, Jesupi capi, i̱te: “¿Me yoꞌoquë deꞌoquë caquëꞌni, yëꞌëre? Peoji, deꞌoquë. Coa teꞌi paꞌiji, ja̱ë cato Diusupi. Ja̱je paꞌiquëtaꞌare mëꞌëpi ti paꞌi hue̱ꞌña cacaye yëni sehuoye paꞌiji, cua̱ñeseꞌere.” ");
INSERT INTO seyNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Caquëna, po̱sëpi i̱te capi: “¿Je aꞌni, i̱ti yëꞌë sehuo ja̱ꞌñe?” Caquëna, Jesupi capi, i̱te: “Huani je̱omaꞌë paꞌijë̱ꞌë, yequë. Nëjore yecore yoꞌomaꞌë paꞌijë̱ꞌë. Coꞌamaña ñamaꞌë. Yecohuaꞌire cosomaꞌë paꞌijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Deꞌoye sehuojë̱ꞌë, mëꞌë jaꞌquëre cuiꞌne më jaꞌcore. Cuiꞌne oijë̱ꞌë, më quë̱no maca paꞌiquëre mëꞌëjaꞌa coꞌye oiyeje̱ paꞌye.” ");
INSERT INTO seyNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Po̱sëpi i̱te capi: “Siꞌaye iye tsihuaꞌë paꞌinëpi deꞌoye yoꞌosiquë aꞌë. ¿Ja̱je paꞌito i̱quepi caraquëꞌni, yëꞌëre?” ");
INSERT INTO seyNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Caquëna, Jesupi sehuopi, i̱te: “Mëꞌëpi deꞌoquërepa pasiꞌi cani sani mëꞌë payere i̱siquë curiquë nequë cuiꞌne peocohuaꞌini coa i̱sijë̱ꞌë. Ja̱ macataꞌa mëꞌë maꞌtëmore jaiye coꞌamaña paye paꞌiji. Ja̱ jeteyoꞌje dani tuijë̱ꞌë, yëꞌëre.” ");
INSERT INTO seyNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ja̱je caquëna, iyere po̱së asani ai oi sajiꞌi, jaiye coꞌamaña paquë sëte. ");
INSERT INTO seyNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ja̱ maca Jesupi i̱ yeꞌyacohuaꞌire capi: “Nuñerepa cayë, mësarute. Ai jëaji, maꞌtëmo jaiye coꞌamaña pacohuaꞌipi cacaye. ");
INSERT INTO seyNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Cayë, ti̱jupë mësarute. Camellore miu ñaca cojeja̱ꞌa sa etoja̱iñe peoji. Ja̱je paꞌitaꞌare ai jerepa jëaji, jaiye coꞌamaña pacohuaꞌipi maꞌtëmo cacaye.” ");
INSERT INTO seyNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ja̱re i̱ yeꞌyacohuaꞌipi asani ai cuasajë i̱ohuaꞌija̱ꞌa sa̱ꞌñe se̱iꞌë: “¿Ja̱je paꞌito nepi huasosicohuaꞌi paꞌiye paꞌiquëꞌni, cajë?” ");
INSERT INTO seyNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesupi ñani capi, ja̱ohuaꞌire: “Pa̱ire cato caca ti̱ꞌañe peoji. Ja̱je paꞌiquëtaꞌare Maijaꞌquëre cato neñe paꞌiji, siꞌaye.” ");
INSERT INTO seyNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ja̱ maca Pedropi capi, i̱te: “Ëjaë, yëquë siꞌaye yëquë coꞌamaña paseꞌe je̱oni mëꞌëre tuëꞌë. ¿Ja̱je yoꞌosicohuaꞌi i̱quere yëquë paja̱ꞌcohuaꞌi aꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Cajëna, Jesupi sehuopi, ja̱ohuaꞌire: “Nuñerepa cayë, mësarute. Ja̱ muꞌse siꞌaye huajëye deꞌosi maca Pa̱i Mamaquëpi i̱ ñuꞌi saihuëna Ëjaërepa jaꞌrusi maca, mësaru yëꞌëre tuisicohuaꞌije̱ jaꞌruja̱ꞌcohuaꞌi aꞌë, doce ñuꞌi saihuë̱ana, doce tsëcapë̱a Israel pa̱i yoꞌoseꞌe ña deꞌhuaja̱ꞌcohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Huëꞌe pa̱nitaꞌa aꞌyëre, aꞌyore, pa̱nitaꞌa jaꞌquëre, pa̱nitaꞌa jaꞌcore, pa̱nitaꞌa nëjore, pa̱nitaꞌa mamajëre, pa̱nitaꞌa yejare yëꞌë doꞌire je̱osicohuaꞌi cato cien paꞌye jerepa paja̱ꞌcohuaꞌi aꞌë, cuiꞌne ti pani huesëyere paja̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ja̱je paꞌiquëtaꞌare jai pa̱i yure duꞌru paꞌicohuaꞌipi tëjiohuaꞌirepa paꞌija̱ꞌcohuaꞌi aꞌë, cuiꞌne yure jeteyoꞌjerepa paꞌisicohuaꞌipi duꞌru acohuaꞌi paꞌija̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Maꞌtëmo paꞌi te̱ꞌte cato jai tsio paquëpi nea hue̱ꞌñarepa coꞌamaña necaicohuaꞌire coꞌesiꞌi, cuiyaꞌi tëaja̱ꞌcohuaꞌire caquë saiseꞌeje̱ paꞌye aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Coꞌamaña necaicohuaꞌire ti̱ꞌani teꞌe muꞌse yoꞌo doꞌire teꞌe ëja jaꞌhua sa̱isiꞌi, capi. Ja̱je quëani ne deꞌhuani jëjo saopi, i̱ tsio necaija̱ꞌcohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nea hue̱ꞌña nueve paꞌi maca etani sajiꞌi. Sai ñaquëna, nemaꞌcohuaꞌipi jai pa̱i quëꞌrore coa paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Paꞌijëna, capi, ja̱ohuaꞌire: ‘Mësaruje̱ sani yëꞌë tse̱ tëacaijë̱ꞌë, sa̱isiꞌi, i̱ti sa̱iñe paꞌiyeje̱’ caëna. Ja̱ maca saëꞌë, tëaja̱ꞌcohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Muꞌse jopo paꞌi maca tsio aquë etani sajiꞌi. Saisiquëpi tres paꞌi maca sani co̱pi, ja̱re cuiꞌne pa̱ire coꞌequë. ");
INSERT INTO seyNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Saisiquëpi cuiꞌne neato cinco paꞌi maca, sani co̱pi. Sani ti̱ꞌapi, pa̱i coa paꞌi hue̱ꞌñare yoꞌomaꞌpë coa nëcacohuaꞌire. Ñani capi: ‘¿I̱quere yoꞌojë siꞌa muꞌse coa paꞌiyeꞌni?’ ");
INSERT INTO seyNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Caquëna, i̱ohuaꞌipi cahuë, i̱te: ‘Yëquëre yecohuaꞌije̱ coꞌamaña nejëꞌë cajë cua̱ñeseꞌe peocohuaꞌi aꞌë.’ Cajëna, i̱ohuaꞌire capi: ‘Ja̱je paꞌito sani mësaruje̱ yëꞌë coꞌamañare necaijë̱ꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ñami deꞌosi maca i̱ti tsio aquëpi coꞌamaña necaicohuaꞌire ñacaiquëre soini capi: ‘Coꞌamaña nesi doꞌire sa̱ijëꞌë. Jeteyoꞌje cacasicohuaꞌini sa̱ijëꞌë duꞌru sa̱ini jeteyoꞌje duꞌru cacasicohuaꞌire sa̱ijëꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Caëna, coꞌamaña nesicohuaꞌire soiquëna, neato cinco paꞌi maca cacasicohuaꞌipi daëꞌë. Datena, teꞌe muꞌse yoꞌosi doꞌi jaꞌye sa̱ipi. ");
INSERT INTO seyNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ja̱ jeteyoꞌje duꞌru cacasicohuaꞌire soiquëna, cuasahuë, jerepa curiquë nejaꞌcohuaꞌi aꞌë, cajë. Ja̱je cuasasicohuaꞌitaꞌare pa̱i ñapere teꞌe muꞌse yoꞌoseꞌe jaꞌye sa̱ipi. ");
INSERT INTO seyNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ja̱je sa̱i cua̱ñoni sa̱ñope ca huëohuë, i̱ti coꞌamaña paquëni, ");
INSERT INTO seyNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ñeje cajë: ‘Icohuaꞌi jeteyoꞌje cacasicohuaꞌi cato coa teꞌe hora nehuë. Ja̱je nesicohuaꞌitaꞌare yëquë siꞌa muꞌse coꞌamaña nejë, ë̱së uquëna, quëcojë nesicohuaꞌire sa̱iñe jaꞌye sa̱ihuë, mëꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ja̱je cajëna, i̱ti tsio aquëpi sehuopi, ja̱ohuaꞌi aquëre ñeje: ‘Cajei, coꞌaye yoꞌomaꞌë paꞌiyë, mëꞌëre. ¿Mëꞌëje pa̱ipi teꞌe muꞌse ne doꞌire, sa̱ijëꞌë caquë yëꞌë ja̱ꞌre co̱ni, ne deꞌhuasiquëtaꞌa? ");
INSERT INTO seyNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ja̱je paꞌito iye mëꞌë ne doꞌi i̱ni saijë̱ꞌë. Yëꞌëpi yëë mëꞌëre i̱siye jaꞌye iquëreje̱ i̱siyë, jeteyoꞌje cacasiquëreje̱. ");
INSERT INTO seyNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Mëꞌëpi cuasani yëꞌë curiquëre, yëꞌë yëyeje̱ paꞌye yoꞌoye peoji, cuasaquë? ¿Pa̱nitaꞌa coa jaiye pasiꞌi cuasaquëna, pë̱ti ëaye mëꞌëre nëiquë yëꞌëpi pa̱ire oiquëpi yoꞌoquëna?’ ");
INSERT INTO seyNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ja̱je paꞌina, jeteyoꞌje paꞌisicohuaꞌipi duꞌru acohuaꞌi paꞌija̱ꞌcohuaꞌi aꞌë. Cuiꞌne duꞌru acohuaꞌipi jeteyoꞌje paꞌija̱ꞌcohuaꞌi aꞌë. Ja̱je paꞌina, jai pa̱i soisicohuaꞌi paꞌiyë. Paꞌijëtaꞌare, sahuani joꞌya nesicohuaꞌipi aꞌri jaꞌi pa̱i paꞌiyë.” ");
INSERT INTO seyNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús Jerusalén maꞌare paꞌi i̱ doce yeꞌyacohuaꞌire i̱ohuaꞌiseꞌere ti̱ro sani capi: ");
INSERT INTO seyNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Mësarupi ñañë, mai Jerusalénna mëi huëoye, Pa̱i Mamaquëre Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌina cuiꞌne cua̱ñeseꞌe yeꞌyacohuaꞌina i̱sija̱ꞌtona, i̱sisi maca ja̱ohuaꞌipi huani je̱ojaꞌquë api cajë, ");
INSERT INTO seyNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ti̱ pa̱ina i̱sija̱ꞌcohuaꞌi aꞌë. I̱sirena, ja̱ohuaꞌipi i̱te cueꞌcuejë tëꞌcajë yoꞌoni, so̱quë sarahuana que̱jajë cajë. Ja̱je yoꞌosicohuaꞌitaꞌare toaso̱ muꞌseña paꞌi maca huëija̱ꞌquë api.” ");
INSERT INTO seyNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Jesús quëꞌrona Jacobo cuiꞌne Juan pëca jaꞌcopi Zebedeo mamajë ja̱ꞌre co̱ni doꞌre jaꞌruo, Jesús ña hue̱ꞌñana necai ja̱ꞌñere se̱siꞌi caco. ");
INSERT INTO seyNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ja̱ maca i̱pi se̱jiꞌi, i̱ote: “¿I̱quere yëcoꞌni, mëꞌë?” Caquëna, sehuo, ñeje: “Yëꞌë caya mamajëre mëꞌë paꞌi te̱ꞌtena ëjaohuaꞌire neni mëꞌë ëja te̱ꞌtena yequëre cuiꞌne ari te̱ꞌtena ñocaijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Cacona, Jesupi sehuopi: “Cuasaye peoye huesërepa se̱ñë, mësaru. ¿Mësaru deꞌhue tëto sani ti̱ꞌañe, yëꞌë së̱je co̱no tëto sai ja̱ꞌñeje paꞌye, cuiꞌne do cua̱ño ti̱ꞌañe yëꞌë do cua̱ño ja̱ꞌñeje paꞌye?” Ja̱ohuaꞌipi cahuë: “Ti̱ꞌañë.” ");
INSERT INTO seyNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Cajëna, i̱pi capi, ja̱ohuaꞌire: “Nuñerepa cayë, ja̱je paꞌijë̱ꞌë. Mësaru tëto saija̱ꞌcohuaꞌi aꞌë, iye së̱je co̱nojaꞌa. Cuiꞌne yëꞌë do cua̱ñoseꞌeje̱ do cua̱ñojaꞌcohuaꞌi aꞌë. Ja̱je paꞌiquëtaꞌare ëja te̱ꞌte cuiꞌne ari te̱ꞌtena jaꞌruye cato yëꞌëpi i̱siye peoji. Yëꞌë jaꞌquëpi i̱ ne deꞌhuacaisicohuaꞌina i̱sija̱ꞌquë api.” ");
INSERT INTO seyNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ja̱je caquëna, diez i̱ yeꞌyacohuaꞌipi iyere asani sa̱ñope pë̱ti huëohuë, caya huaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ja̱je sa̱ñope yoꞌoye paꞌina, Jesupi soini capi, ja̱ohuaꞌire: “Mësaru, tsoe ta̱ꞌñe asayë. Iye yeja pa̱i ëjaohuaꞌi cato siꞌa coꞌamaña meñe payë, cuiꞌne i̱ohuaꞌi huëꞌehuë maca acohuaꞌipi mëñe ëjaohuaꞌire payë, i̱ohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ja̱je paꞌye peosipi, mësarute cato. Ai jerepa paꞌi pasiꞌi caquëpi yecohuaꞌire necaiquë paꞌiye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Cuiꞌne mësaru aquëpi duꞌru aquë pasiꞌi caquë pani yecohuaꞌini necaiquëpi joꞌyaë paꞌiye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Pa̱i Mamaquëje̱ paꞌiohuaꞌi paꞌiye paꞌiji. Ja̱ë je̱ꞌquë daimaꞌë pajiꞌi, yecohuaꞌipi necaija̱jë caquë. Coa ai jerepa necasiꞌi caquë dajiꞌi, i̱ paꞌiye doꞌipi jai pa̱i deꞌoye paꞌi ja̱ꞌñe necasiꞌi caquë.” ");
INSERT INTO seyNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jericó daripëpi etani saijëna, jai pa̱i Jesure tuëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Saijëna, ja̱rote cayaohuaꞌi ñamaꞌcohuaꞌipi paëꞌë, maꞌa yëꞌquë macare. Paꞌicohuaꞌipi Jesupi tëtosaiji asani cuihuë: “Ëjaë, David Mamaquë, yëquë mañare teaye ñani co̱caijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Cajëna, pa̱ipi cuimaꞌpë paꞌijë, cahuë. Ja̱je catoje̱ ai jerepa cuihuë: “Ëjaë, David Mamaquë yëquë mañare teaye ñani co̱caijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ja̱ maca Jesús nëcaja̱ni ñamaꞌcohuaꞌire soini se̱jiꞌi, ja̱ohuaꞌire: “¿I̱quere necaija̱quë cajë yëyeꞌni, yëꞌëre?” ");
INSERT INTO seyNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Caquëna, ja̱ohuaꞌipi sehuohuë: “Ëjaë, yëquë ñañere yëyë.” ");
INSERT INTO seyNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Cajëna, Jesupi teaye paꞌiohuaꞌire ñani oi patopi, ñaco ca̱na. Ja̱je patoquëna, i̱ti macapi tsoe ñacohuaꞌi paëꞌë. Paꞌijë Jesure tuëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jerusalén jaꞌye macare paꞌijë ti̱ꞌahuë, Betfagé daripëna, Olivos ai cu̱tihuë quë̱no maca paꞌicona. Ja̱ropi Jesús cayahuaꞌire i̱ yeꞌyacohuaꞌire jëjo saopi. ");
INSERT INTO seyNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Jëjo saoquë capi, ja̱ohuaꞌire: “Saijë̱ꞌë, je̱ꞌñerepa paꞌi daripëna. Ja̱rona ti̱ꞌajaꞌcohuaꞌi aꞌë, burra sëa nëosicopi. Burrito ja̱ꞌre co̱ni nëiona, ñani joyeni dacaijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ja̱je sajëna, yecohuaꞌipi ¿me nejaꞌquëni, saye? Cato cajë̱ꞌë: ‘Ëjaëpi cusiꞌi’ caëna, yoꞌoyë. Esa coꞌyoja̱ꞌquë api, cuni tëjini.” ");
INSERT INTO seyNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Iye cato yoꞌoseꞌe pajiꞌi tsoe aquë Maijaꞌquëre quëacaiquë toyaquë caquë paꞌiseꞌepi ti̱ꞌaquëna ñeje toyaseꞌepi: ");
INSERT INTO seyNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Sión daripëre cajë̱ꞌë: “Ñajëꞌë. Mëꞌë ëjaëre papi mëꞌëna daiji, Jerepa paꞌi aꞌë cuasamaꞌquëpi burroni ñuꞌi Coꞌamaña hueꞌeco burra mamaquëni ñuꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ja̱ maca i̱ yeꞌyacohuaꞌipi sani Jesús cua̱ñeseꞌeje̱ yoꞌohuë. ");
INSERT INTO seyNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Burrare cuiꞌne i̱o mamaquëre dani ca̱ñapi i̱ohuaꞌi jetena jajehuë. Jajerena, ja̱ maca Jesupi mëni jaꞌrupi. ");
INSERT INTO seyNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ja̱ maca jai pa̱i paꞌiye sëte ca̱ñapi maꞌana jajehuë. Yecohuaꞌipi so̱quë capë̱are tëtejë maꞌana o̱ehuë, sihuajë. ");
INSERT INTO seyNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ja̱ maca duꞌru sai pa̱i cuiꞌne jeteyoꞌje dai pa̱ipi cui huëohuë: “¡Deꞌoquëre pani, pa̱i ëjaë David mamaquë! ¡Ëjaërepa mami hueꞌequëpi daiji, deꞌoquëpi! ¡Deꞌoquëre papi, Maijaꞌquë!” ");
INSERT INTO seyNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesús Jerusalén cacasi maca siꞌa pa̱i i̱ti daripë paꞌicohuaꞌi ai cuasajë yecohuaꞌire se̱iꞌë: “¿I̱queiꞌni, iquë?” ");
INSERT INTO seyNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Cajëna, pa̱ipi cahuë: “Iquë cato Maijaꞌquëre quëacaiquë api Jesupi, Nazaret Galilea aquë api.” ");
INSERT INTO seyNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ja̱ jeteyoꞌje Jesús cacapi, Maijaꞌquëre huëꞌena. Cacani siꞌaohuaꞌire huerojë cuiꞌne i̱sijë yoꞌocohuaꞌire hueꞌsena eto saopi, ja̱ro paꞌisicohuaꞌire mesaña po̱ꞌne ta̱ño saopi, curiquë pa̱ire cambiaseꞌe cuiꞌne suꞌtere i̱sicohuaꞌi ñuꞌi saije̱ po̱ꞌne ta̱ño saopi. ");
INSERT INTO seyNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ja̱je yoꞌoquë capi, ja̱ohuaꞌire: “Toyaseꞌe caji, ñeje: ‘Yëꞌë huëꞌe cato Maijaꞌquëre se̱ huëꞌe hueꞌyosicoa.’ Ja̱je paꞌiquëtaꞌare mësaru cato coꞌamaña ñaohuaꞌi tuꞌaro neni yoꞌoyë.” ");
INSERT INTO seyNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Maijaꞌquëre se̱ huëꞌena ñamaꞌcohuaꞌi cuiꞌne doꞌpëcohuaꞌi daëꞌë. Jesús quëꞌrona daijëna, i̱pi jujupi. ");
INSERT INTO seyNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ja̱je yoꞌoquëna, Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌipi cuiꞌne cua̱ñeseꞌe yeꞌyacohuaꞌipi iye pa̱i yoꞌo ti̱ꞌa maꞌñere yoꞌoquëna, ñahuë. Cuiꞌne tsi̱pi Maijaꞌquë huëꞌepi ai ñeje cuijë cajëna, asahuë. ¡Deꞌoquëre papi David mamaquë pa̱i Ëjaë! Ja̱je cajëna, asani pë̱ijë, ");
INSERT INTO seyNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jesure cahuë: “¿Asaquë, mëꞌë ja̱ohuaꞌi mëꞌëre cuijë caye?” Cajëna, Jesupi sehuopi: “Jë̱jëꞌë, asayë. ¿Mësaru ñamaꞌcohuaꞌi aꞌni, toyaseꞌe ñeje caye? Mëꞌëpi aꞌricohuaꞌi mañare cuiꞌne oje tsu̱ꞌsucohuaꞌire nehuë, Maijaꞌquëre deꞌoyerepa jë̱jëjaꞌcohuaꞌëre.” ");
INSERT INTO seyNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ja̱je cani sajiꞌi, yequë aꞌri daripë Betaniana. Ja̱rona ñami pëapi. ");
INSERT INTO seyNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nea hue̱ꞌña Jesús pa̱i daripëpi coꞌiquëna, a̱i ëaye nëjiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nëina, maꞌa yëꞌquë maca nëca yëre jaꞌye maca tsioja̱ni ñaquëna, ti peoyë pajiꞌi. Quë̱imaꞌ ñë, coa jaꞌoseꞌe pajiꞌi. Ja̱ maca Jesupi capi, so̱quë yëre: “¡Yuretaꞌa ti quë̱imaꞌo paꞌijë̱ꞌë cua̱ñeñë, mëꞌëre!” Ja̱je i̱ ca macapi cue̱ne huesësico pacoꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Iyere ñani i̱ yeꞌyacohuaꞌipi ai cuasajë Jesure se̱iꞌë: “¿Me yoꞌoquë so̱quë yë esarepa cue̱ne huesëcoꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Cajëna, Jesupi sehuopi, ja̱ohuaꞌire: “Nuñerepa cayë. mësarute. Mësarupi neñe paꞌiji cuasacohuaꞌi pani jëa coeye peoni yëꞌë so̱quë yë caëna, yoꞌoseꞌeje̱ yoꞌoye paꞌiji. Iye cu̱tihuëre cacohuaꞌi pani cayë: ‘Iye macapi sani jai tsiayana sa duꞌijë̱ꞌë.’ Ja̱je ca maca tsoe yoꞌoseꞌe paꞌiye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Cuasare pajë se̱cohuaꞌi pani siꞌaye mësaruseꞌe ti̱ꞌajaꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ja̱ maca Jesús Maijaꞌquë huëꞌena paꞌi yeꞌyapi. Jarote ja̱ yëꞌtaꞌa yeꞌyaquëna, Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌi cuiꞌne judío pa̱i aiohuaꞌi tsio dani i̱te se̱iꞌë: “¿I̱que cua̱ñeñepi iye coꞌamaña yoꞌoquëꞌni? ¿Nepi mëꞌëre iye cua̱ñe tutu paquëre nereꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Cajëna, Jesupi sehuopi, ja̱ohuaꞌire: “Yëꞌëje̱ cuiꞌne mësaruteje̱ se̱siꞌi. Iye se̱seꞌere sehuorena, yëꞌëje̱ quëasiꞌi iye coꞌamaña yoꞌo tutu aye. ");
INSERT INTO seyNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","‘¿Ne cua̱ñesiquëpi paquëꞌni, Juan oco doquë, Maijaꞌquë pa̱nitaꞌa pa̱ipi cua̱ñesiquë paquë?’ ” Caëna, ja̱ maca sa̱ꞌñe ca huëohuë, i̱ohuaꞌija̱ꞌa ñeje: “Maijaꞌquë jëjo daosiquë pajiꞌi, cato i̱pi sehuoja̱ꞌquë api, maire: ‘¿Ja̱je paꞌiquëtaꞌare me yoꞌojë mësaru asamaꞌpë pateꞌni?’ ");
INSERT INTO seyNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Cuiꞌne ‘maipi pa̱i cua̱ñesiquë pajiꞌi’ canije caꞌrayë, pa̱ire. Juanre cato Maijaꞌquë cocare quëaquë pajiꞌi cuasayë, pa̱ije.” ");
INSERT INTO seyNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ja̱je paꞌina, cahuë, Jesure: “Huesëyë, yëquë.” Cajëna, i̱je capi: “Yëꞌëje̱ quëaye pa̱ñë, iye coꞌamaña yoꞌo tutu cua̱ñequëre.” ");
INSERT INTO seyNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesupi capi, ja̱ohuaꞌire: “¿Me cuasayeꞌni, mësaru iyere asani? Pa̱ipi caya mamajëre paquëpi capi, ja̱ohuaꞌi aquëni: ‘Tsihuaꞌë, yure sani yëꞌë coꞌamañare necaijë̱ꞌë, cuiyaꞌi tëayere.’ ");
INSERT INTO seyNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Mamaquëpi sehuopi: ‘Pa̱ñë.’ Ja̱je casiquëtaꞌa ti̱ñe cuasa ñajani sani coꞌamaña nepi. ");
INSERT INTO seyNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ja̱ jeteyoꞌje sani yequëre capi, cuiꞌne caquëna, i̱pi sehuopi: ‘Jaë, jaꞌquë sasiꞌi.’ Casiquëtaꞌa saiye pa̱pi. ");
INSERT INTO seyNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","‘¿Ja̱je paꞌito jequëpi pëca jaꞌquë yëseꞌe necaquëꞌni, ja̱ohuaꞌi aquë?’ ” Caquëna, ja̱ohuaꞌipi cahuë: “Duꞌru aquë.” Ja̱ maca Jesupi capi, ja̱ohuaꞌire: “Nuñerepa cayë, mësarute. Paꞌi doꞌi curi se̱cohuaꞌi, cuiꞌne ë̱mëohuaꞌire yoꞌoroja̱icohuaꞌipi, maꞌtëmo duꞌru cacaja̱ꞌcohuaꞌi aꞌë, mësaru ja̱ cacamaꞌpëna. ");
INSERT INTO seyNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan oco doquëpi mësarute quëapi. I̱ti paꞌiyere quëaquëtaꞌare mësarupi asamaꞌpë paëꞌë. Ja̱je paꞌiquëtaꞌare paꞌi doꞌi curiquë se̱cohuaꞌipi cuiꞌne siꞌa ë̱mëohuaꞌire yoꞌocohuaꞌipi asajë po̱nëhuë. Ja̱je siꞌaye ñajëtaꞌa mësaru po̱nëmaꞌpë paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Asajë̱ꞌë, yure iye quëayere. Jai tsio paquëpi ta̱pi, pi̱si cuiyaꞌire. Ta̱ni tsioja̱ꞌa tëhuo tëꞌija̱jiꞌi cuiꞌne cuiyaꞌi suja̱ꞌcoreje̱ nepi, cuiꞌne jai ë̱më huëꞌeje̱ nepi, i̱opi tuijë siꞌa tsio ñajaꞌcore yahue i̱macohuaꞌire. Ja̱ jeteyoꞌje coꞌamaña necohuaꞌire coꞌeni necaijë̱ꞌë cani soꞌona sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Saisiquëpi tëa muꞌseña ti̱ꞌasi maca jëjo daopi, i̱ joꞌyare. Sani i̱te coꞌamaña necaicohuaꞌina se̱jëna, ja̱ohuaꞌipi i̱te cajë nëocaiseꞌere i̱sija̱jë caquë. ");
INSERT INTO seyNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ja̱je caquë jëjo saosiquëtaꞌare coꞌamaña necohuaꞌipi i̱ joꞌya mañare tse̱ani tëꞌcahuë, teꞌire. Yequëni coa huani je̱ohuë. Cuiꞌne yequëni quë̱na pë̱api je̱a huëohuë. ");
INSERT INTO seyNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ja̱je yoꞌoruje̱ i̱ti tse̱ aquëpi ti̱jupë duꞌru jëjo daoseꞌe se̱ña maca jai pa̱ire jëjo daopi, i̱ joꞌyare. Ja̱je jëjo daoruje̱ coꞌamaña necohuaꞌipi cuiꞌne ja̱ohuaꞌireje̱ yoꞌohuë. ");
INSERT INTO seyNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ai tëjiyerepa jëjo daopi, i̱ mamaquëre pani, ‘oijë dahuëre ñajaꞌcohuaꞌi aꞌë, cuasaquë.’ ");
INSERT INTO seyNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ja̱je jëjo daosi maca i̱ mamaquëni ñani, coꞌamaña necohuaꞌipi i̱ohuaꞌija̱ꞌa sa̱ꞌñe cahuë: ‘Iquë api, i̱ti coꞌamaña tse̱ aquë deꞌoja̱ꞌquë. Ja̱je paꞌito huani je̱oñuꞌu, maipi iye yeja tse̱ acohuaꞌi paꞌija̱ꞌcohuaꞌi.’ ");
INSERT INTO seyNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ja̱je cani tse̱ani tsiopi hueꞌsena etoni sani huani je̱ohuë.” ");
INSERT INTO seyNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ca tëjini Jesús se̱jiꞌi: “I̱ti tsio aquëpi daisiquë pani, ¿me nejaꞌquë aꞌni, coꞌamaña necohuaꞌire?” ");
INSERT INTO seyNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Caquëna, ja̱ohuaꞌipi cahuë, i̱te: “Huani je̱ojaꞌquë api, ti oiye peoye coꞌacohuaꞌire. Yoꞌoni yecohuaꞌini coꞌeni tsio coꞌamaña nejaꞌcohuaꞌire je̱osipi. Je̱ona, quë̱i maca ti̱ꞌaëna, tëani i̱te i̱sija̱ꞌcohuaꞌi aꞌë, i̱te cajë necaiseꞌere.” ");
INSERT INTO seyNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ja̱ maca Jesupi capi, ja̱ohuaꞌire: “¿Ti ñamaꞌcohuaꞌi aꞌni, toyaseꞌe, mësaru? Caji ñeje: Necohuaꞌipi yoꞌo jujani je̱osi quëna pëpi, Yure cato duꞌru huëocorepa po̱nëo. Iye cato ëjaëpi ja̱je neina, merepa ja̱je neini cajë ai cuasajë ñañe paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ja̱je paꞌina, mësarute cayë. Diusu paꞌi te̱ꞌte pasicohuaꞌire mësarute sioja̱ꞌquë api. Tsioni yecohuaꞌina i̱sija̱ꞌquë api, i̱ paꞌi te̱ꞌtena i̱ti ca̱ tëani i̱sicohuaꞌina. ");
INSERT INTO seyNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Quë̱na pë cato, yecohuaꞌipi i̱o ë̱mëjeꞌena to̱mecohuaꞌipi jëꞌyecoa. Cuiꞌne quë̱na pëpi yecohuaꞌi ë̱mëjeꞌena to̱meco pani peo së̱pë̱are neñe paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ja̱je caquëna, Maijaꞌquë huëꞌe ñacai ëjaohuaꞌi cuiꞌne fariseohuaꞌipi maini caji cuasajë Jesús caye asahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ja̱ maca tse̱añe yëjëtaꞌa pa̱ini caꞌrajë pa̱huë, jai pa̱i Jesure Maijaꞌquëre quëacaiquë api cuasacohuaꞌi paꞌijëna, ñani. ");
INSERT INTO seyNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús ti̱jupë ca huëo co̱pi, pa̱i ñañe ayeja̱ꞌa i̱ñoquë ñeje: ");
INSERT INTO seyNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Maꞌtëmo cato pa̱i ëjaëpi mamaquëre huejaquëna, sihuaquë pa̱ire tsiꞌsoni yoꞌoseꞌeje̱ paꞌye aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ja̱je yoꞌoquë jëjo saopi, i̱ joꞌyare, huëosicohuaꞌire quërëja̱ijëꞌë, caquë. Ja̱je paꞌiquëtaꞌare huëosicohuaꞌipi daiye coehuë. ");
INSERT INTO seyNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ti̱jupë i̱ joꞌyare jëjo saoquë capi: ‘Quëajë̱ꞌë, soisicohuaꞌire. Tsoe siꞌaye a̱i ja̱ꞌñe deꞌhua saohuë. Hue̱quëreje̱ huiꞌyape quëꞌiohuaꞌini huani ne deꞌhuahuë, huejaye ñajaꞌcohuaꞌi daija̱jë caquë.’ ");
INSERT INTO seyNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Caquëna, asani i̱ caseꞌe quëajëna, huëosicohuaꞌi asacaimaꞌpë paëꞌë. Yequëpi tsiona sajiꞌi. Yequë coꞌamaña i̱si sapi. ");
INSERT INTO seyNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Cuiꞌne yecohuaꞌipi ja̱ ëjaë joꞌyare tse̱ani coꞌaye yoꞌojë huani je̱ahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ja̱ maca pa̱i ëjaë pë̱i i̱ soldado pa̱ire jëjo saopi, huaisicohuaꞌire. Huani je̱ani i̱ti daripëje̱ ëo je̱ojaꞌcohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ja̱ jeteyoꞌje capi, i̱ joꞌyare. ‘Hueja a̱o ne deꞌhuaseꞌepi pajiꞌi. Ja̱je paꞌiquëtaꞌare soisicohuaꞌi daiye pa̱huë. Ja̱ soisicohuaꞌi cato doꞌi peocohuaꞌi paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ja̱je paꞌi doꞌire jai maꞌañana sani huëojë̱ꞌë. Coa siꞌaohuaꞌire maꞌa paꞌicohuaꞌire dajë̱ꞌë, hueja a̱o a̱ijaꞌcohuaꞌire.’ ");
INSERT INTO seyNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Caëna, pa̱i ëjaë joꞌyapi etani sani maꞌajaꞌa cuꞌijë coꞌacohuaꞌire cuiꞌne deꞌocohuaꞌire siꞌsohuë, huëꞌe ti̱më huesëyerepa. ");
INSERT INTO seyNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ja̱ maca ëjaë cacani soisicohuaꞌire ñapi. Ñaquëna, teꞌi hueja ca̱ña su̱ñamaꞌquëpi ñujiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ñani capi, i̱te: ‘¿Cajei, me mëꞌë i̱ño cacaëꞌni, hueja ca̱ña su̱ñamaꞌquë?’ Ja̱je caquëna, i̱pi ti sehuomaꞌë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Camaꞌëna, ja̱ maca pa̱i ëjaëpi mesa ñuꞌicohuaꞌire necaijë paꞌicohuaꞌire capi: ‘Ja̱ëte tse̱ani nëcañoa cuiꞌne jë̱ña sëani je̱ocojë̱ꞌë, nea hue̱ꞌña hueꞌsena. Ja̱ropi oi cuiꞌne cu̱ji qui̱ꞌcoja̱quë.’ ");
INSERT INTO seyNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ja̱je paꞌina, jai pa̱i paꞌiyë, soisicohuaꞌi. Ja̱je paꞌiquëtaꞌare aꞌri maña paꞌiyë, sahuani joꞌya nesicohuaꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ja̱ maca fariseohuaꞌipi sani sa̱ꞌñe coca cajë teꞌe cuasahuë. Ja̱je cajëna, tayo sehuouna coꞌaye capi cajë ne ja̱ꞌñere. ");
INSERT INTO seyNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ja̱je cani jëjo saohuë, i̱ohuaꞌi acohuaꞌire Herodes tsëcapë acohuaꞌina co̱ni teꞌe Jesure caja̱ꞌcohuaꞌire ñeje: “Yeꞌyaquë, asayë, yëquë mëꞌë nuñerepa caquë paꞌiye, cuiꞌne nuñerepa Maijaꞌquë maꞌare yeꞌyaquëpi pa̱i cayere asacaimaꞌquëpi cuiꞌne pa̱i paꞌiye ë̱mëjeseꞌe ñaquë camaꞌquë paꞌiye. ");
INSERT INTO seyNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","¿Ja̱je paꞌipi me mëꞌë caquëꞌni? ‘¿Deꞌoquë paꞌi doꞌire siꞌa pa̱i ëjaë Césarna curi sa̱iñe pa̱nitaꞌa pa̱ñe?’ ” ");
INSERT INTO seyNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ja̱je cajëna, Jesús tsoe asapi, i̱ohuaꞌi coꞌaye cuasajë se̱ñe. Ja̱je paꞌina, capi, ja̱ohuaꞌire: “Coa cacohuaꞌi, ¿Me yoꞌojë yëꞌëre cosojë neñuꞌu cajë cayeꞌni? ");
INSERT INTO seyNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","I̱ñojëꞌë, paꞌi doꞌi sa̱i tëꞌquire.” Caquëna, teꞌe tëꞌqui romano curi tëꞌquire dahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Darena, Jesús ñani ja̱ohuaꞌire se̱jiꞌi: “¿Ne tsiare hueꞌecoꞌni, iye tëꞌqui ico cuiꞌne ne mamire hueꞌecoꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Caquëna, i̱ohuaꞌipi sehuohuë: “Siꞌaohuaꞌi ëjaërepa mamipi paꞌiji.” Cajëna, Jesupi capi, ja̱ohuaꞌire: “I̱sijë̱ꞌë, pa̱i ëjaë tse̱co paꞌito ja̱re i̱ti tse̱ aquëna. Cuiꞌne Maijaꞌquë tse̱ paꞌito ja̱re Maijaꞌquëna i̱sijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Caquëna, iyere asani ai cuasahuë. Ja̱je yoꞌoni i̱te je̱oni saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ja̱re ja̱ muꞌse saduceohuaꞌi Jesure sani ñañuꞌu cajë saëꞌë. Saduceo huaꞌi cato ju̱ꞌisicohuaꞌi huëiye peoji, cacohuaꞌi aꞌë. Ja̱je paꞌiohuaꞌipi iyere cahuë, i̱te: ");
INSERT INTO seyNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Yeꞌyaquë, Moisés capi, huejasiquëpi mamajëre peoquë ju̱ꞌisiquë paꞌito yoꞌjeipi huejaye paꞌiji, huaꞌjeore, majaꞌyë ju̱ꞌisi doꞌire mamajëre pacaija̱ꞌquëpi. ");
INSERT INTO seyNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Yëquë acohuaꞌipi siete yoꞌje tsi̱ teꞌe tsëcapëre paëꞌë. Paꞌicohuaꞌipi duꞌru majaꞌyëpi huejani ju̱jiꞌi, mamajëre peoquë. Ju̱ꞌi yoꞌjeina je̱ocajiꞌi, nëjore. ");
INSERT INTO seyNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ja̱ëje mamajëre peoquë ju̱jiꞌi. Ju̱quëna, toaso̱ñe aquë huejapi. Huejani ja̱re ja̱je peoquë ju̱jiꞌi. Ja̱jeseꞌe siꞌa tsëcapë siete ju̱ju sahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ai jeteyoꞌjerepa nomio ju̱coꞌë, siꞌaohuaꞌi ju̱tena. ");
INSERT INTO seyNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ja̱je paꞌito ju̱ꞌisicohuaꞌi huëi maca ¿ne nëjo paꞌija̱ꞌcoaꞌni, ja̱je siꞌaohuaꞌi teꞌoni huejasico?” ");
INSERT INTO seyNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesupi sehuopi, ja̱ohuaꞌire: “Mësarupi tayo cuasayë, toyapë ñamaꞌcohuaꞌi sëte cuiꞌne Maijaꞌquë tutu ñamaꞌcohuaꞌi sëte. ");
INSERT INTO seyNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ju̱iꞌsicohuaꞌipi huëisicohuaꞌi huejamaꞌpë paꞌija̱ꞌcohuaꞌi aꞌë. Cuiꞌne mamajë nomiohuaꞌire huejomaꞌpë paꞌija̱ꞌcohuaꞌi aꞌë. Maꞌtëmo acohuaꞌi hui̱ñaohuaꞌije̱ paꞌiohuaꞌi paꞌija̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ja̱je paꞌito mësaru ju̱ꞌisicohuaꞌi huëiye aye Maijaꞌquë caseꞌere toyaseꞌe ñamaꞌcohuaꞌi aꞌë. Toyaseꞌe ñeje caji: ");
INSERT INTO seyNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Yëꞌë cato Abraham, Isaac, cuiꞌne Jacobo Diusu aꞌë.’ Diusu cato ju̱ꞌisicohuaꞌi Diusu peoji. Ja̱ë cato huajëcohuaꞌi Diusu api.” ");
INSERT INTO seyNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ja̱je caquëna, iyere pa̱i asani ai cuasahuë, me ja̱ jerepa yeꞌyaquëꞌni, cuasajë. ");
INSERT INTO seyNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jesupi saduceo pa̱ire ti sehuoye peoyerepa ca huesopi, asani fariseo pa̱ipi tsiꞌsihuë, coca cañuꞌu cajë. Ja̱ maca dani ");
INSERT INTO seyNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Fariseo pa̱i aquëpi cua̱ñeseꞌe yeꞌyaquëpi neñasiꞌi caquë i̱te se̱jiꞌi: ");
INSERT INTO seyNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Yeꞌyaquë, ¿Jeco aꞌni, cua̱ñeseꞌe siꞌaye se̱ña maca paꞌio pa̱ire yeꞌya ja̱ꞌñe?” ");
INSERT INTO seyNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Se̱ina, Jesupi capi: “Oijë̱ꞌë, më Ëjaë Diusure, siꞌa më joyopi, siꞌa më paꞌiyepi cuiꞌne siꞌa mëꞌë cuasayepi. ");
INSERT INTO seyNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Iye aꞌë, siꞌaye se̱ña maca jerepa paꞌye cuiꞌne duꞌru macarepa cua̱ñeseꞌe. ");
INSERT INTO seyNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Yecoje̱ ja̱re cuiꞌne paꞌio. Ja̱opi caji, ñeje: ‘Oijë̱ꞌë, më quë̱no maca aquëre mëꞌëjaꞌa coꞌye cuasaquë oiyeje̱ paꞌye.’ ");
INSERT INTO seyNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Iye cayayena siꞌaye Moisés cua̱ñeseꞌe cuiꞌne Maijaꞌquëre quëacaicohuaꞌi yeꞌyaseꞌe meñe quëco paji.” ");
INSERT INTO seyNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ja̱ yëꞌtaꞌa fariseohuaꞌi tsiꞌsisicohuaꞌi paꞌijëna, ");
INSERT INTO seyNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesús se̱jiꞌi, ja̱ohuaꞌire: “¿Me cuasayeꞌni, mësaru Cristore? ¿Ne mamaquë aꞌni?” Caquëna, i̱ohuaꞌipi sehuohuë: “David mamaquë api, ja̱ë cato.” ");
INSERT INTO seyNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ja̱ maca Jesupi capi, ja̱ohuaꞌire: “¿Ja̱je paꞌiquëtaꞌare David Maijaꞌquë joyopi quëaquëna, Ëjaë hueꞌyouꞌni, i̱te? Ja̱je paꞌina, Davidpi capi: ");
INSERT INTO seyNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ëjaëpi capi, yëꞌë Ëjaëre: ‘Jaꞌrujë̱ꞌë, yëꞌë ëja te̱ꞌtena, Mëꞌëre sa̱ñope yoꞌocohuaꞌire mëꞌë quë̱o huëꞌehuëna tëꞌya me macaja̱ꞌa.’ ");
INSERT INTO seyNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Me ja̱je paꞌito Cristo David mamaquë paꞌiquëꞌni, Davidpi Ëjaë i̱te hueꞌyoto?” ");
INSERT INTO seyNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ja̱ maca teꞌije̱ ti teꞌe yëꞌopoje̱ caye pa̱pi. Cuiꞌne ja̱re ja̱ muꞌsepi cua̱ñeseꞌe yeꞌyacohuaꞌije̱ jaiye se̱ñe je̱ohuë, caꞌrajë. ");
INSERT INTO seyNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ja̱ maca Jesupi capi, pa̱ire cuiꞌne i̱ yeꞌyacohuaꞌire: ");
INSERT INTO seyNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Cua̱ñeseꞌe yeꞌyacohuaꞌi cuiꞌne fariseo pa̱i cato Moisésje̱ paꞌiohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ja̱je paꞌina, mësaru siꞌaye ja̱ohuaꞌi caye sehuocaiye paꞌiji. Ja̱je paꞌiquëtaꞌare i̱ohuaꞌi yoꞌoyere yeꞌyemaꞌpë paꞌijë̱ꞌë. Ja̱ohuaꞌi cato ñeje yoꞌoye paꞌiji casicohuaꞌipi i̱ohuaꞌi caseꞌere yoꞌomaꞌpë ai yequere yoꞌocohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ja̱ohuaꞌi cato hueꞌocaiyë, dëquëyere pare. Quëco ëa maꞌñere pare ja̱re pa̱ipi hueꞌeja̱jë cajë yoꞌoyë. Ja̱je yoꞌojëtaꞌa i̱ohuaꞌi cato moño maca pu̱ꞌpeyeque coecohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Siꞌaye i̱ohuaꞌi yoꞌoye cato pa̱ipi ñajajë cajë yoꞌoye aꞌë. Ja̱je paꞌina, tsia ti̱ñare pana cuiꞌne ta̱ta tuna ca̱ña ca̱ꞌtina Maijaꞌquë coca ayepi toyaseꞌere sëoni juꞌijë cuꞌiyë. Cuiꞌne juꞌi ca̱ niamoajaꞌa deꞌoyerepa tsoa ca̱ña nëojë huatoseꞌere juꞌiyë, yequë pa̱i juꞌiye se̱ña maca deꞌoyere. ");
INSERT INTO seyNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Deꞌo hue̱ꞌñana a̱o a̱iñere yëcohuaꞌi aꞌë. Cuiꞌne sihua cua̱ñocohuaꞌi ñuꞌi saihuëna jaꞌruye yëcohuaꞌi aꞌë, pa̱i tsiꞌsi hue̱ꞌñana. ");
INSERT INTO seyNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Cuiꞌne pa̱ipi deꞌoyerepa ëjaohuaꞌi aꞌë cajë caꞌrajë pëpayere yëcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ja̱je ja̱ohuaꞌi yoꞌocohuaꞌitaꞌare mësaru cato pa̱ipi yeꞌyacohuaꞌi aꞌë hueꞌyoja̱jë cajë yoꞌomaꞌpë paꞌijë̱ꞌë. Ja̱je paꞌina, siꞌaohuaꞌi mësaru cato teꞌe yoꞌje tsi̱ aꞌë. Cuiꞌne teꞌere yeꞌyaquëre pacohuaꞌi aꞌë, Cristore. ");
INSERT INTO seyNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Jaꞌquë hueꞌyomaꞌpë paꞌijë̱ꞌë, teꞌireje̱ iye yeja acohuaꞌire. Coa teꞌire maꞌtëmo paꞌiquëseꞌere jaꞌquëre payë, mësaru. ");
INSERT INTO seyNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Pa̱ipi mësarute ëjaohuaꞌi aꞌë, caja̱jë cajë yoꞌomaꞌpë paꞌijë̱ꞌë, teꞌi mësaru ëjaë Cristo paꞌito me ja̱je yoꞌoye. ");
INSERT INTO seyNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ja̱je paꞌina, mësaru aquëpi yecohuaꞌire necaiquëpi ai jerepa paꞌi paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","I̱jaꞌa coꞌye jerepa paꞌi aꞌë, cuasaquë cato meñe casa cua̱ñoñe paꞌiji. Ja̱je paꞌiquëtaꞌare jerepa paꞌi aꞌë cuasamaꞌquëni jerepa paꞌire neñe paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","¡Teayerepa mësaru cua̱ñeseꞌe yeꞌyacohuaꞌi cuiꞌne fariseo pa̱i! Coa cacohuaꞌi. Teayerepa mësaru cua̱ñeseꞌe yeꞌyacohuaꞌi cuiꞌne fariseo pa̱i, coa cacohuaꞌi. ¿Me yoꞌojë maꞌtëmo caca saꞌro tëhuoyeꞌni? yecohuaꞌi paꞌija̱jë cajë. Ja̱je yoꞌojë mësaruje̱ cacamaꞌpë yecohuaꞌi cacañuꞌu cajë yoꞌocohuaꞌireje̱ ë̱seyë. ");
INSERT INTO seyNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Teayerepa, mësaru cua̱ñeseꞌe yeꞌyacohuaꞌi cuiꞌne fariseo pa̱i. Coa cacohuaꞌi! ¿Me neñuꞌu, cajë huaꞌjeohuaꞌi huë̱ꞌña siojë yoꞌoyeꞌni, mësaru? Ja̱je yoꞌocohuaꞌipi pa̱ipi deꞌocohuaꞌi aꞌë cuasaja̱jë cajë tsoaye se̱ñë. Ja̱je yoꞌosi doꞌire mësarute jerepa coꞌayerepa sa̱iñe paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Teayerepa mësaru cua̱ñeseꞌe yeꞌyacohuaꞌi cuiꞌne fariseo pa̱i! ¡Coa cacohuaꞌi! Mësaru cato cuꞌicohuaꞌi aꞌë, yeja cuiꞌne jai tsiaya pa̱ini mësaru sehuoyena yeꞌyañuꞌu cajë. Ja̱je yoꞌoroja̱ijë neni i̱ti sehuoquëni mësaru se̱ña maca cayaye jerepa coꞌaquëre neñë, toana uja̱ꞌquëre. ");
INSERT INTO seyNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Teayerepa mësaru ñaco ca̱ peocohuaꞌije̱ paꞌiohuaꞌipi yecohuaꞌire sacohuaꞌi paꞌiyë. Ja̱je paꞌiohuaꞌipi cayë, ‘Maijaꞌquë huëꞌe doꞌipi ca nëoseꞌe cato neñe peoji. Maijaꞌquë huëꞌe paꞌi oropi ca nëoseꞌepi neñe paꞌiji.’ ");
INSERT INTO seyNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Huesëohuaꞌipi cuiꞌne ñaco ca̱ peocohuaꞌije̱ paꞌiohuaꞌipi. ¿Mësaru ñato je aꞌni, i̱ti jerepa paꞌye, oro pa̱nitaꞌa Maijaꞌquë huëꞌepi orore Maijaꞌquë tse̱ necaiye aꞌni, i̱tirepa? ");
INSERT INTO seyNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Yequeje̱ mësaru cayë, ‘Maijaꞌquëre i̱si saihuë doꞌipi nesiꞌi ca nëoñe peoji.’ ");
INSERT INTO seyNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Huesëohuaꞌi cuiꞌne ñaco ca̱ peocohuaꞌije̱ paꞌiohuaꞌi! ¿I̱que aꞌni, jerepa paꞌye, ë̱mëjeꞌe tuiye pa̱nitaꞌa i̱ti saihuë, Maijaꞌquë tse̱ necai saihuë? ");
INSERT INTO seyNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ja̱je paꞌina, i̱ti saihuë doꞌipi ca nëoquë pani coa i̱oseꞌere camaꞌë paꞌiji. Siꞌaye i̱o ë̱mëjeꞌe tuiye co̱ni caji. ");
INSERT INTO seyNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Cuiꞌne Maijaꞌquë huëꞌe doꞌipi ca nëoquë pani ja̱ro paꞌiquëni Diusuni caye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Cuiꞌne maꞌtëmo doꞌipi ca nëoquë pani Maijaꞌquë ñuꞌi saihuëna caye paꞌiji. Cuiꞌne i̱oni caquë Maijaꞌquë i̱ote ñuꞌiquëni caye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Teayerepa mësaru cua̱ñeseꞌe yeꞌya pa̱i cuiꞌne fariseo pa̱i! ¡Coa cacohuaꞌi! Maijaꞌquëre mësaru i̱siyë, menta, anis cuiꞌne comino a̱iñe së̱ñe neñere, diez ayere teꞌore huaseꞌere. Ja̱je yoꞌojëtaꞌa cuasaye pa̱ñë, ai jerepa doꞌi quëꞌyere, nuñerepa paꞌiyere, pa̱ire oiyere, cuiꞌne Maijaꞌquëre paꞌiji cuasayere. Iyeje̱ yoꞌojë cuiꞌne ja̱ yëꞌtaꞌa yequeje̱ yoꞌoye paꞌiji, je̱omaꞌpë. ");
INSERT INTO seyNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ñaco ca̱ peocohuaꞌipi yecohuaꞌire sacohuaꞌipi paꞌiyë, mësaru. Miꞌare deꞌoye ñajë i̱ma je̱ocohuaꞌitaꞌa camellore nëocohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Teayerepa mësaru cua̱ñeseꞌe yeꞌyacohuaꞌi cuiꞌne fariseo pa̱i! ¡Coa cacohuaꞌi! Ë̲mëjeꞌeseꞌe u̱cu duruhuë̱a cuiꞌne quë̱na neꞌña tsoacohuaꞌi aꞌë. Sa̱ꞌnahuë cato coꞌamaña yahue i̱mañe cuiꞌne teꞌohuaꞌi jaiye coꞌamaña pañuꞌu caye ti̱mësicohuaꞌi paꞌiyë. ");
INSERT INTO seyNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Fariseo, ñaco ca̱ peoquë! Duꞌru macarepa u̱cu duruhuëre cuiꞌne quë̱na deꞌhuare tsoajë̱ꞌë. Sa̱ꞌnahuë paꞌiyere jeteyoꞌje yuretaꞌa hueꞌse paꞌiyeje̱ siꞌsi peoye pasipi. ");
INSERT INTO seyNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Teayerepa mësaru cua̱ñeseꞌe yeꞌyacohuaꞌi cuiꞌne fariseohuaꞌi. Coa cacohuaꞌi. Mësaru cato pa̱ire ta̱si darije̱ paꞌiohuaꞌi aꞌë, huëꞌeseꞌe pojaꞌicore tsoaseꞌeje̱ paꞌiohuaꞌipi. Ja̱je paꞌiohuaꞌipi sa̱ꞌnahuë cato ju̱ꞌisi tara cuiꞌne siꞌaye siꞌsi ti̱më huesësicohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ja̱je paꞌiohuaꞌi aꞌë, mësaru, pa̱i ña hue̱ꞌñaseꞌe deꞌocohuaꞌipi. Sa̱ꞌnahuë cato coa cosoyena cuiꞌne coꞌaye yoꞌoyena ti̱mësicohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Teayerepa mësaru cua̱ñeseꞌe yeꞌyacohuaꞌi cuiꞌne Fariseo pa̱i! ¡Coa cacohuaꞌi! Mësarupi deꞌoye necaicohuaꞌi aꞌë, cuasajë tsoe Maijaꞌquëre quëacaicohuaꞌi ju̱tena, ta̱si darire cuiꞌne deꞌo pa̱ipi ju̱ꞌisicohuaꞌini i̱ohuaꞌire ta̱si darina quë̱na tupë̱a ëja deꞌhuacohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ja̱je yoꞌojë cayë: ‘Maipi mai aipë paꞌinë paꞌicohuaꞌi pani co̱ huaiye pa̱raꞌhuë, Maijaꞌquëre quëacaicohuaꞌire.’ ");
INSERT INTO seyNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ja̱je iyere yoꞌojë tsoe mësaruja̱ꞌa ñañë, Maijaꞌquëre quëacaicohuaꞌire huasi tsëcapë acohuaꞌi aꞌë cajë. ");
INSERT INTO seyNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Ja̱je paꞌito ja̱ macaja̱ꞌa yoꞌo tëjijë̱ꞌë, mësaru aipë yoꞌo huëojë paꞌiseꞌe! ");
INSERT INTO seyNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡A̲ñaohuaꞌi! ¡A̲ña tsëcapë! ¿Me jëaja̱ꞌcohuaꞌi aꞌni, mësaru toa yeja uye? ");
INSERT INTO seyNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mësarupi yoꞌo saoja̱jë iyere caquë jëjo daoja̱ꞌquë aꞌë, yequë muꞌseña paꞌi ja̱ꞌñe quëacohuaꞌire, ta̱ꞌñe asacohuaꞌire, cuiꞌne cua̱ñeseꞌere yeꞌyacohuaꞌire. Ja̱je paꞌiquëtaꞌare mësarupi yecohuaꞌire huani je̱ojë so̱quë sarahuana que̱ni huani je̱ojë yoꞌoja̱ꞌcohuaꞌi aꞌë. Ja̱ohuaꞌi acohuaꞌire cuiꞌne yecohuaꞌini tsiꞌsi huë̱ꞌñana tse̱ani tëꞌcaja̱ꞌcohuaꞌi aꞌë. Cuiꞌne siꞌa pa̱i dari ñape coꞌeroja̱ijë jo̱sa yoꞌoja̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ja̱je yoꞌojëna, mësaruna siꞌa deꞌo pa̱ire huani je̱osi doꞌi to̱mejaꞌcoa. Nuñerepa yoꞌoquë Abelre huani je̱osi macapi Zacarias, Berequías mamaquëre huani je̱osi macana, ëojë se̱ saihuë cuiꞌne deꞌo hue̱ꞌña jopo saꞌrona mësaru huani je̱osiquëna to̱mesipi. ");
INSERT INTO seyNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nuñerepa cayë. Siꞌaye iye doꞌi cato yure paꞌi pa̱ipi sa̱iñe to̱mejaꞌcoa. ");
INSERT INTO seyNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerusalén, Jerusalén, yequë muꞌse paꞌi ja̱ꞌñe quëacohuaꞌire cuiꞌne Maijaꞌquë coca quëacohuaꞌire mëꞌëni caquë Maijaꞌquë jëjo daoquëna, huani je̱ohuë, mësaru. Yoꞌojëtaꞌare deꞌhuerepa mëꞌë mamajëre tsisosiꞌi caquë yoꞌohuë, cura mamajëre i̱o capë̱a huëꞌehuëna deꞌhuasiꞌi caco yoꞌoyeje̱. Yoꞌoquëna, coehuë. ");
INSERT INTO seyNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ñajëꞌë. Yure mësaru huëꞌe je̱ocosico paꞌico. ");
INSERT INTO seyNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nuñerepa cayë. Yëꞌëre mësaru ña co̱ñe pa̱jaꞌcohuaꞌi aꞌë, ‘mësarupi deꞌoquëre paꞌni ëjaë mamirepa hueꞌequë daiquë’ ca maca ti̱ꞌañe pa̱to.” ");
INSERT INTO seyNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesupi Maijaꞌquë huëꞌepi etani je̱ꞌnë saina, i̱ yeꞌyacohuaꞌipi tsio dani i̱te Maijaꞌquë se̱ huëꞌe ayere ñajë ca huëohuë. ");
INSERT INTO seyNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Cajëna, Jesupi capi: “¿Siꞌaye mësaru ñañe? Deꞌoji, nuñerepa mësarute cayë. Siꞌaye ja̱ mësaru ñañe nejoseꞌe paꞌija̱ꞌcoa. Iye maca ti teꞌe quë̱na pëje̱ jupë u̱iñe pa̱jaꞌcoa.” ");
INSERT INTO seyNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ja̱ maca Olivos cu̱tihuëna saëꞌë. Sani Jesús jaꞌruni ñuꞌina, i̱ yeꞌyacohuaꞌipi i̱te yahuerepa cahuë: “I̱na, yëquëre quëajë̱ꞌë. ¿Je yëhua ja̱je yoꞌoja̱coaꞌni? ¿Me i̱ñoñe paꞌija̱ꞌcoaꞌni, mëꞌë daiye cuiꞌne yeja caraja̱iñe?” ");
INSERT INTO seyNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Cajëna, Jesupi capi: “Deꞌhua ñajë paꞌijë̱ꞌë, mësarute yecohuaꞌipi coso huesojë. ");
INSERT INTO seyNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Jai pa̱i yëꞌë mamipi cajë daija̱ꞌcohuaꞌi aꞌë: ‘Yëꞌë aꞌë, Cristo’ cajë. Cajëna, jai pa̱i i̱ohuaꞌire tuija̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Siꞌa hue̱ꞌña sa̱ꞌñe huajo huaiyere mësaru asaja̱ꞌcohuaꞌi aꞌë. Asani quëquëmaꞌpë paꞌijë̱ꞌë. Ja̱re ja̱je tëto saiye paꞌiji. Paꞌiquëtaꞌa ja̱ yëꞌtaꞌa tëjiye peoji. ");
INSERT INTO seyNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Yequë yeja paꞌicohuaꞌipi yequë yeja paꞌicohuaꞌire se uihuaja̱ꞌcohuaꞌi aꞌë. Cuiꞌne yequë pa̱ipi yequë pa̱ini se uihuaja̱ꞌcohuaꞌi aꞌë. Cuiꞌne a̱iñeje peoquëna, a̱i ëa ju̱ꞌijaꞌcohuaꞌi aꞌë. Cuiꞌne yeja ñuꞌcueye paꞌija̱ꞌcoa, yequë hue̱ꞌña ñape. ");
INSERT INTO seyNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Iye cato ja̱ꞌa ai yoꞌo huëoyepi paꞌija̱ꞌcoa. ");
INSERT INTO seyNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Cuiꞌne yëꞌë doꞌire mësarute coꞌaye yoꞌojë tse̱ani yecohuaꞌina i̱sijë cuiꞌne huani je̱ojë yoꞌojë cuiꞌne siꞌa pa̱i mësarute coeja̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ja̱ muꞌseña ai Maijaꞌquëre cuasaseꞌe nejo huesoja̱ꞌcohuaꞌi aꞌë. Ja̱je yoꞌojë yecohuaꞌire coejë cajeohuaꞌije̱ paꞌiohuaꞌitaꞌa sa̱ñope yoꞌocohuaꞌi paꞌija̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Cuiꞌne jai pa̱i coa cosocohuaꞌije̱ paꞌija̱ꞌcohuaꞌi aꞌë, Maijaꞌquëre quëacaicohuaꞌi aꞌë cacohuaꞌije̱. Ja̱je yoꞌojëna, jai pa̱i cosoyere asaja̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Cuiꞌne ja̱je jaiye coꞌaye paꞌina, yoꞌojë jai pa̱i pa̱ire oiye je̱ojaꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ja̱je paꞌiquëtaꞌare i̱ti quëcoquë nuiñe paꞌisiquëpi ja̱ëpi huasosiquë pasipi. ");
INSERT INTO seyNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Cuiꞌne iye deꞌo cocaje̱ siꞌa hue̱ꞌña yeja paꞌicohuaꞌire quëaseꞌe paꞌija̱ꞌcoa, ja̱ohuaꞌije̱ asaja̱jë cajë. Ja̱ macataꞌa ti̱ꞌajaꞌcoa, caraja̱iñerepa. ");
INSERT INTO seyNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Maijaꞌquëre quëacaiquë Daniel toyapi, pa̱ire coꞌa deꞌhuaquë cuiꞌne pa̱ire ne huesoquë yoꞌoye ayere. Ja̱je paꞌina, iquëpi siꞌsi peo hue̱ꞌñana ti̱ꞌasi maca ñani toya jaꞌo ñaquëpi asaye paꞌiji, ti̱ꞌapi, caquë. ");
INSERT INTO seyNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ja̱ maca Judea paꞌicohuaꞌipi catiye paꞌiji, ai cu̱tina. ");
INSERT INTO seyNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Huëꞌe ë̱mëjeꞌe totore paꞌiquë pani cajeye peoji, sa̱ꞌnahuë coꞌamaña paꞌiye i̱siꞌi caquë. ");
INSERT INTO seyNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Cuiꞌne tsiore paꞌiquë pani coꞌiye peoji, ca̱ña i̱masiꞌi caquë. ");
INSERT INTO seyNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Teayerepa ja̱ muꞌseña nomiohuaꞌi tsi̱ ë̱tapë̱a paꞌicohuaꞌi cuiꞌne oje tsu̱ꞌsucohuaꞌire pacohuaꞌi maña ai yoꞌoja̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ja̱je paꞌina, se̱jëꞌë, Maijaꞌquëre sësë tëcahuë catiye peoja̱ꞌcore, cuiꞌne huajë muꞌseña catiye peoja̱ꞌcore. ");
INSERT INTO seyNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ja̱ muꞌseña cato jaiye ai yoꞌoye pasipi, ja̱ꞌa yeja deꞌhuasi maca ti peoseꞌepi jeteyoꞌjeje̱ peo ja̱ꞌñepi. ");
INSERT INTO seyNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ja̱ muꞌseña Maijaꞌquëpi tëamaꞌquë paꞌito teꞌi macaje̱ huaso cua̱ñoñe peoraꞌpi. Ja̱je paꞌiquëtaꞌare Maijaꞌquëpi i̱ joꞌya nesicohuaꞌini oi tëaja̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Mësarute yecohuaꞌipi caja̱ꞌcohuaꞌi aꞌë: ‘Ñajëꞌë, i̱ñore paꞌiji, Cristo pa̱nitaꞌa Ñajëꞌë, ja̱rote paꞌiji.’ Ja̱je catoje̱ carepa maꞌñe cuasamaꞌpë paꞌijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Daija̱ꞌcohuaꞌi aꞌë, yëꞌë Cristo aꞌë, cacohuaꞌi coa cosocohuaꞌipi. Cuiꞌne Maijaꞌquë coca quëacaicohuaꞌi aꞌë, cacohuaꞌipi. Ja̱ohuaꞌipi cuiꞌne jaiye pa̱i yoꞌo maꞌñe ne i̱ñojaꞌcohuaꞌi aꞌë, coa cosoñuꞌu cajë. Ja̱je yoꞌojëna, Maijaꞌquërepa joꞌya nesicohuaꞌije̱ care payë cajë sehuoja̱ꞌcohuaꞌi aꞌë, a̱ꞌji sehuocohuaꞌi cato. ");
INSERT INTO seyNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ja̱je paꞌina, tsoe duꞌru cahuë iye mësarute ja̱je yoꞌo maꞌñe caquë. ");
INSERT INTO seyNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ja̱je paꞌina, yecohuaꞌipi mësarute ‘jeto cue̱ne yejare paꞌiji, ñajëꞌë’ cacohuaꞌi paꞌito saimaꞌpë pa̱nitaꞌa yeque ‘Ñajëꞌë, i̱ño tuꞌrihuëre paꞌiji,’ catoje̱ asamaꞌpë paꞌijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Pa̱i Mamaquë daiyerepa cato ë̱së mëi hue̱ꞌñapi cuiꞌne ë̱së sa duꞌi hue̱ꞌñana mujuë yeꞌhueyeje̱ paꞌyerepa paꞌija̱ꞌcoa. ");
INSERT INTO seyNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ju̱ꞌisiquë ca̱pë paꞌi hue̱ꞌñana ja̱rona pëꞌpëri tsiꞌsija̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Esa ai yoꞌo muꞌseña tëto sai maca ë̱së yayaja̱ꞌquë api. Cuiꞌne ñañëje miamaꞌë paꞌija̱ꞌquë api. Maꞌñocoje̱ maꞌtëmopi to̱mejaꞌcohuaꞌi aꞌë. Cuiꞌne maꞌtëmo tutu paꞌiyeque tsasija̱ꞌcoa. ");
INSERT INTO seyNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ja̱ maca Pa̱i Mamaquë tutu yoꞌoye ñajaꞌcohuaꞌi aꞌë, maꞌtëmopi yoꞌoquëna. Cuiꞌne siꞌa pa̱i dari yeja paꞌicohuaꞌi oija̱ꞌcohuaꞌi aꞌë. Ja̱ maca ñajaꞌcohuaꞌi aꞌë, Pa̱i Mamaquë maꞌtëmopi sirija̱ꞌa daiye, tutu quëꞌire papi cuiꞌne deꞌoyepi quëcosiquëpi daina. ");
INSERT INTO seyNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ja̱ maca hui̱ñaohuaꞌire cua̱ñejaꞌquë api, i̱ sahuasicohuaꞌire cajeseꞌe yeja te̱ꞌña, siꞌa yeja paꞌicohuaꞌire tsiꞌsojë̱ꞌë, caquë ai tutu duruhuë juiyepi. ");
INSERT INTO seyNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yeꞌyejë̱ꞌë, higuera so̱quë yë yoꞌoye ayere quëaquëna. Hui̱ña capë̱a paꞌi maca jaꞌo etaquëna, mësaru ñani je̱ꞌnë utëcahuë ti̱ꞌaquëna, yoꞌoji cacohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ja̱je cuiꞌne siꞌaye iye tëto saina, ñani je̱ꞌnë caraja̱i muꞌseña ti̱ꞌaquëna, eta saꞌrore paꞌina, yoꞌoji cuasajë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nuñerepa cayë, mësarute. Siꞌaye iye yoꞌo ja̱ꞌñe aꞌë, ja̱ yëꞌtaꞌa iye muꞌseña pa̱i ju̱ju samaꞌpëna. ");
INSERT INTO seyNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Maꞌtëmo cuiꞌne yeja caraja̱i ja̱ꞌñe aꞌë. Yëꞌë cocataꞌa ti caraja̱iñe pa̱ ja̱ꞌñe aꞌë. Ja̱re i̱ti caseꞌeje̱ ti̱ꞌaquë paꞌi ja̱ꞌñe aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ja̱je paꞌiquëtaꞌare peoji, i̱ti muꞌserepa cuiꞌne hora quëaye. Huesëyë, yecohuaꞌije̱. Maꞌtëmo paꞌicohuaꞌi hui̱ñaohuaꞌije̱ cuiꞌne Maijaꞌquë mamaquëje̱ huesëji, coa Maijaꞌquëseꞌe asaji, i̱ti. ");
INSERT INTO seyNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noé paꞌi muꞌseña yoꞌojë paꞌiseꞌeje̱ paꞌye pasipi, Pa̱i Mamaquë dai macaje̱. ");
INSERT INTO seyNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ja̱ muꞌseña ja̱ yëꞌtaꞌa coꞌjemaꞌnë pa̱ipi a̱o a̱ijë, u̱cujë, nomi huejajë, cuiꞌne pëca jaꞌquëohuaꞌipi nomi tsi̱re huejojë paëꞌë, Noé jai yohuëna caca macaja̱ꞌa. ");
INSERT INTO seyNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ja̱ huesëjëna, jai coꞌje dani siꞌaohuaꞌire peo hue̱ꞌña coꞌje hue̱aꞌcoꞌë. Ja̱je cuiꞌne pasipi, Pa̱i Mamaquë dai macaje̱. ");
INSERT INTO seyNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ja̱ muꞌseña caya ë̱mëohuaꞌi tsiore paꞌija̱ꞌcohuaꞌi aꞌë. Paꞌijëna, teꞌire saquë cuiꞌne teꞌire je̱osipi. ");
INSERT INTO seyNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Caya nomiohuaꞌi hueare toaja̱ꞌcohuaꞌi aꞌë. Toajëna, teꞌore saquëna, cuiꞌne teꞌo je̱o saisico paꞌija̱ꞌcoa. ");
INSERT INTO seyNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ëjaë daija̱ꞌa maca huesëye sëte cuiꞌñasicohuaꞌipi paꞌijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ja̱je paꞌiquëtaꞌare iyeje̱ asajë̱ꞌë, i̱ti huëꞌe aquëpi ñami ja̱ hora paꞌi maca coꞌamaña ñaquë daija̱ꞌquë api asaquë pani sëtasiquëpi i̱ huëꞌe coꞌamaña cacani i̱mañe ë̱seja̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ja̱je paꞌina, mësaruje̱ ne deꞌhuasicohuaꞌipi paꞌijë̱ꞌë, mësaru hua̱nëyesi maca Pa̱i Mamaquë dani quëcoquë. ");
INSERT INTO seyNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","¿Jequë aꞌni, nuñerepa deꞌo joꞌyaë, cuiꞌne asaquërepa i̱ti ti̱ꞌasi maca i̱ huëꞌe acohuaꞌire a̱ocaijë̱ꞌë, caquë je̱oni saisiquë? ");
INSERT INTO seyNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Sihua cua̱ñojaꞌquë api, i̱ ëjaë cua̱ñeseꞌeje̱ yoꞌoquë paꞌina, ti̱tani ñasiquëpi. ");
INSERT INTO seyNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nuñerepa cayë i̱ti tse̱ aquë siꞌaye i̱ paye ñacaijë̱ꞌë caquë cua̱ñe nëojaꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ja̱je paꞌiquëtaꞌare coꞌa joꞌyaë pani cuasaji, tsoe nëijaꞌquëre me je esa ti̱tasina, cuasaquë. ");
INSERT INTO seyNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","I̱ ëjaë joꞌyare coꞌaye yoꞌo huëoni cuiꞌne a̱o a̱i huëoni cuiꞌne co̱no u̱cu huëoni cuepecohuaꞌi ja̱ꞌre co̱ni yoꞌoquë pasipi. ");
INSERT INTO seyNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Paꞌina, ja̱ maca i̱ ëjaë coꞌisipi, i̱ joꞌyaë hua̱nëyeni je dasina caquë utemaꞌë yoꞌo maca. ");
INSERT INTO seyNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ja̱ maca i̱te ai coꞌayerepa siꞌseni coa cacohuaꞌire nejoñepi nejoñe paꞌiji. Ja̱ maca oisipi, cu̱jije qui̱ꞌcoquë. ");
INSERT INTO seyNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ja̱je paꞌito maꞌtëmo paꞌi te̱ꞌte cato diez nomi tsi̱pi huiꞌyapepi dani toa tsë̱opë̱are i̱mani hueja hue̱ꞌñana i̱ohuaꞌi ë̱jëre ti̱ꞌañuꞌu cajë saiseꞌeje̱ paꞌye aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Cinco paꞌiohuaꞌi ne deꞌhuamaꞌcohuaꞌi paëꞌë. Cuiꞌne cinco ne deꞌhuasicohuaꞌi paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ne deꞌhuamaꞌcohuaꞌipi toa tsë̱o pë̱a sajëtaꞌa huiꞌyapere samaꞌpë paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ne deꞌhuasicohuaꞌipi sahuë, quë̱na huë̱ana huiꞌyape doseꞌere cuiꞌne toa tsë̱o pë̱aje siꞌaye ti̱mëseꞌere sahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Huejaja̱ꞌquëpi esa daimaꞌë paꞌina, huëo ca̱i ëapi siꞌa nomiohuaꞌire ja̱je huëo ca̱i ëaquëna, ute jujani ca̱ëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ja̱ maca ñami jopo paꞌi maca asahuë, cuiye: ‘Je̱ꞌnërepa daiji, huejaja̱ꞌquëpi etani i̱te pëpajë̱ꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Cui maca siꞌa nomi tsi̱ huëni i̱ohuaꞌi toa tsë̱o pë̱a ne deꞌhuahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ja̱ jeteyoꞌje cinco ne deꞌhuamaꞌcohuaꞌipi cahuë, cinco ne deꞌhuasicohuaꞌire: ‘I̱sijë̱ꞌë, aꞌri maña mësaru huiꞌyapere yëquë toa tsë̱o pë̱api yaya huëoji.’ ");
INSERT INTO seyNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ja̱je cajëna, cinco nomi tsi̱ ne deꞌhuasicohuaꞌipi cahuë: ‘Pa̱ñë, ti̱ꞌañe pamaꞌconi yëquëre cuiꞌne mësarureje̱ ¿me i̱siyeꞌni? Saijë̱ꞌë. I̱ti i̱si hue̱ꞌñana sani huerojë̱ꞌë, mësaru tsë̱o ja̱ꞌñeseꞌe.’ ");
INSERT INTO seyNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Carena, cinco nomi tsi̱ ne deꞌhuamaꞌcohuaꞌipi huiꞌyape hueroñuꞌu cajë saijëna, tsoe ti̱tapi, huejaquë. Nomi tsi̱ cuiꞌñani utesicohuaꞌi cato i̱ ja̱ꞌre co̱ni cacahuë, hueja hue̱ꞌña. Cacarena, eta saꞌro si̱o huesopi. ");
INSERT INTO seyNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ja̱ jeteyoꞌje ti̱tahuë, yequë nomi tsi̱ ti̱tani cahuë: ‘Ëjaë, ëjaë huiꞌyocaijë̱ꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ja̱je cajëna, i̱pi capi, ja̱ohuaꞌire: ‘Nuñerepa cayë, mësarute ñamaꞌquë aꞌë, yëꞌë.’ ” ");
INSERT INTO seyNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ja̱ maca Jesupi capi, ja̱ohuaꞌire: “Pa̱i Mamaquë daija̱ꞌa maca huesëyë, mësaru, i̱ti dai muꞌse cuiꞌne horaje̱. Ja̱je paꞌina, mësaru sëtasicohuaꞌipi paꞌijë utejë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Maꞌtëmo paꞌi te̱ꞌte aye cato pa̱ipi yequë yejana sai huëoni, i̱ joꞌyare soini curiquë i̱sisiquë cua̱ñe nëoseꞌeje̱ paꞌio. ");
INSERT INTO seyNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ja̱ohuaꞌi aquëni i̱sipi, cinco mil curiquë të̱ꞌña. Yequëni i̱sipi, caya mil të̱ꞌña. Cuiꞌne yequëni i̱sipi, teꞌe mil. Pa̱i ñapere i̱ohuaꞌi tutu paꞌiye jaꞌye i̱sini ja̱ maca sajiꞌi, soꞌona. ");
INSERT INTO seyNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Cinco mil të̱ꞌña i̱sisiquëpi sani ja̱pi hueroni ai jerepa cuiꞌne cinco mil të̱ꞌña se ne co̱pi. ");
INSERT INTO seyNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Caya mil i̱sisiquëje̱ cuiꞌne yeque caya mil se ne co̱pi. ");
INSERT INTO seyNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ja̱je yoꞌojëtaꞌare yequëpi teꞌe mil i̱si cua̱ñosiquëpi sani yeja coje nesicona, ta̱pi, curiquë. ");
INSERT INTO seyNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ai tsoepi coꞌipi, i̱ohuaꞌi ëjaë. Coꞌini i̱ohuaꞌi neseꞌe ña huëopi. ");
INSERT INTO seyNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Duꞌru macarepa ti̱tapi, cinco mil të̱ꞌña i̱si cua̱ñosiquëpi. Ti̱tani i̱sipi, i̱ ëjaëre, ñeje caquë: ‘Ëjaë cinco mil mëꞌë yëꞌëre i̱sihuë. I̱sisiquëni yequë cinco mil ne co̱huë, iye mëꞌë tse̱.’ ");
INSERT INTO seyNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Caquëna, ëjaëpi capi, i̱te: ‘Ai deꞌoji, mëꞌë deꞌo joꞌyaëꞌë, deꞌoye yoꞌosiquëre cato yure ai jerepa jaiye i̱si nëosiꞌi cacajë̱ꞌë, yëꞌë ja̱ꞌre co̱ni sihuaja̱ꞌquë.’ ");
INSERT INTO seyNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Jeteyoꞌje dajiꞌi, caya mil i̱sisi joꞌyaë. Ja̱ëpi capi, cuiꞌne: ‘Ëjaë, mëꞌë yëꞌëre caya mil i̱sihuë. Ja̱je i̱sisiquëni yeque caya mil se ne co̱huë, iye mëꞌë tse̱.’ ");
INSERT INTO seyNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","I̱ Ëjaëpi capi, i̱te: ‘Ai deꞌoji, mëꞌë deꞌo joꞌyaëꞌë, nuñerepa paꞌi aꞌë. Aꞌri mañare nuñerepa deꞌoye yoꞌosiquëni ai jerepa jaiye i̱sisiꞌi, ñacai ja̱ꞌñe. Cacani yëꞌë ja̱ꞌre co̱ni sihuajë̱ꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ja̱ë teꞌe mil i̱sisiquëpi ti̱tani capi, i̱ Ëjaëre: ‘Ëjaë mëꞌëpi pa̱ire oimaꞌquëpi mëꞌë ta̱maꞌtona coa ti̱ꞌaquë cuiꞌne mëꞌë ti je̱a maꞌñere tëaquëre asayë. ");
INSERT INTO seyNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ja̱je paꞌina, caꞌraquë sani mëꞌë curiquë yejana yahuehuë. Iye mëꞌë curiquë dacaëꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Caquëna, ëjaëpi sehuopi, i̱te: ‘Joꞌyaë coꞌaquë cuiꞌne jo̱saë. Yëꞌëpi yëꞌë ta̱ maꞌñere tëaquëpi cuiꞌne yëꞌë je̱amaꞌtore tëaquë paꞌiye asaquë sëte. ");
INSERT INTO seyNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ja̱ doꞌire yëꞌë curiquë bancona tëoyere pa̱ëꞌni. Tëosiquë paꞌito coꞌini i̱tipi se nesi doꞌire curiquë neraꞌhuë, yëꞌë tse̱.’ ");
INSERT INTO seyNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ja̱ maca capi, i̱ti maca paꞌicohuaꞌire: ‘Siojë̱ꞌë, curiquë të̱ꞌña. Sioni i̱sijë̱ꞌë, diez mil të̱ꞌña paquëna. ");
INSERT INTO seyNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ja̱je paꞌina, jaiye paquëni ai jerepa se i̱siye paꞌiji. I̱sina, jaiye tëto saquëna, nëaseꞌeque paye paꞌiji. Ja̱je paꞌiquëtaꞌare peoquëni ai jerepa se sioye paꞌiji, i̱ aꞌri maña payeque.’ ");
INSERT INTO seyNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ja̱je cani capi, iquë coꞌa joꞌyaëre: ‘Tse̱ani je̱ocojë̱ꞌë, nea hue̱ꞌña hueꞌsena, ja̱ropi oi cuiꞌne cu̱ji qui̱ꞌcoja̱ꞌquëre.’ ");
INSERT INTO seyNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Pa̱i Mamaquë pa̱i ëjaërepa cua̱ñequë hui̱ñaohuaꞌipi tëꞌija̱isiquëpi daisi maca i̱ deꞌo ñuꞌi saihuëna jaꞌruja̱ꞌquë api, cua̱ñequëre papi. ");
INSERT INTO seyNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ja̱ maca siꞌa yeja paꞌicohuaꞌipi tsiꞌsija̱ꞌcohuaꞌi aꞌë, i̱ ña hue̱ꞌñana. Ja̱ pa̱ire huahueja̱ꞌquë api, yëi ñamare cuiꞌne cabrare ñaquëpi huahueyeje̱ paꞌye. ");
INSERT INTO seyNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","I̱ ëja te̱ꞌtena yëi ñamare cuiꞌne ari te̱ꞌtena cabrare huahuesipi, ti̱ tsëcapë̱aseꞌe. ");
INSERT INTO seyNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ja̱ maca pa̱i ëjaëpi caja̱ꞌquë api, i̱ ëja te̱ꞌte paꞌicohuaꞌire: ‘Daijë̱ꞌë, mësaru yëꞌë jaꞌquë ñacaina, deꞌoye paꞌisicohuaꞌi. Deꞌoye paꞌijë̱ꞌë, maꞌtëmore mësarure caquë yeja deꞌhua maca Diusu deꞌhuacai paꞌi sitore. ");
INSERT INTO seyNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","A̲o ëa ju̱ꞌina, mësarupi deꞌhue a̱ohuë. Oco ëa ju̱ꞌina, cuiꞌne o̱cuahuë. Mësarupi huëꞌe peoquëpi coa cuꞌiquë paëꞌë. Paꞌina, pëa hue̱ꞌña i̱sihuë. ");
INSERT INTO seyNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ca̱ña peoquë paꞌina, mësarupi deꞌhue i̱sihuë. Ju̱ꞌiquë paëꞌë. Paꞌina, yëꞌëre doꞌi sani ñahuë. Tayo yoꞌocohuaꞌire co hue̱ꞌñana co cua̱ñosiquë paëꞌë. Paꞌina, dani ñahuë, yëꞌëre.’ ");
INSERT INTO seyNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ja̱ maca i̱ti nuñerepa yoꞌosicohuaꞌi etasicohuaꞌipi caja̱ꞌcohuaꞌi aꞌë: ‘¿Ëjaë, je yëhua mëꞌëre a̱o ëa ju̱ꞌiquëre ñani a̱oreꞌni, pa̱nitaꞌa je yëhua oco ëa ju̱ꞌiquëre ñani oco o̱cuareꞌni? ");
INSERT INTO seyNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Pa̱nitaꞌa ¿je yëhua huëꞌe peoquëpi coa cuꞌina ñani pëa hue̱ꞌñana i̱sireꞌni? Pa̱nitaꞌa ¿je yëhua ca̱ña peoquë paꞌina, ñani i̱sireꞌni, juꞌiye? ");
INSERT INTO seyNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Pa̱nitaꞌa ¿je yëhua ju̱ꞌiquëre mëꞌëre ñareꞌni? Pa̱nitaꞌa ¿co hue̱ꞌñana cosiquëpi paꞌina, sani ñareꞌni mëꞌëre?’ ");
INSERT INTO seyNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Cajëna, pa̱i ëjaëpi sehuoja̱ꞌquë api, ja̱ohuaꞌire: ‘Nuñerepa cayë, mësarute. Siꞌaye mësaru ja̱ohuaꞌire yëꞌë yoꞌje tsi̱ni aꞌricohuaꞌire teaye paꞌiohuaꞌire ñajë deꞌoye yoꞌoseꞌe cato ja̱re yëꞌëni deꞌoye yoꞌoseꞌe paꞌiji.’ ");
INSERT INTO seyNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ja̱ maca cuiꞌne Ëjaëpi caja̱ꞌquë api, ari te̱ꞌte paꞌicohuaꞌire: ‘Saijë̱ꞌë, yëꞌë quëꞌro paꞌimaꞌpë nejosi te̱ꞌtere paꞌicohuaꞌi. Saijë̱ꞌë, huatire cuiꞌne i̱ joꞌyare caquë toa yeja deꞌhua sitona. ");
INSERT INTO seyNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","A̲o ëa ju̱ꞌina, mësaru a̱omaꞌpë paëꞌë, yëꞌëre. Oco ëa ju̱ꞌina, ocoje̱ cuiꞌne o̱cuaye pa̱huë. ");
INSERT INTO seyNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Huëꞌe peoquëpi coa cuꞌiquë paëꞌë. Ja̱je paꞌina, mësarupi pëa hue̱ꞌña i̱siye pa̱huë. Ca̱ña peoquë paëꞌë. Paꞌina, mësarupi i̱simaꞌpë paëꞌë. Ju̱ꞌiquë paëꞌë. Paꞌina, mësaru dani ñañe pa̱huë. Cosiquë paëꞌë. Paꞌina, sani ñamaꞌpë paëꞌë, mësaru.’ ");
INSERT INTO seyNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ja̱ maca i̱ohuaꞌipi caja̱ꞌcohuaꞌi aꞌë, i̱te: ‘¿Ëjaë, je yëhua mëꞌëre a̱o ëa ju̱ꞌiquëre pa̱nitaꞌa oco ëa ju̱ꞌiquëre, pa̱nitaꞌa coa cuꞌiquëre, pa̱nitaꞌa ca̱ña peoquëre pa̱nitaꞌa ju̱ꞌiquëre, pa̱nitaꞌa cosiquëre ñajëtaꞌa co̱caiye pa̱reꞌni?’ ");
INSERT INTO seyNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ja̱je cajëna, pa̱i ëjaëpi sehuoja̱ꞌquë api: ‘Nuñerepa cayë, i̱ohuaꞌi teaye paꞌi pa̱ire ñajëtaꞌa co̱caiye pa̱jë cuiꞌne yëꞌëreje̱ ai jerepa ti necaiye pa̱huë, mësaru.’ ");
INSERT INTO seyNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ja̱je casi maca i̱ohuaꞌi saija̱ꞌcohuaꞌi aꞌë, ti nejo hue̱ꞌñana. Cuiꞌne nuiñe yoꞌosicohuaꞌipi ti paꞌi hue̱ꞌñana saija̱ꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ja̱je Jesús siꞌaye iyere ca tëjini capi, i̱ yeꞌyacohuaꞌire: ");
INSERT INTO seyNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mësarupi tsoe asayë, caya muꞌseña paꞌi maca Israel pa̱i Egíptopi etajë paꞌiseꞌere cuasajë tsiꞌsini yoꞌoye ti̱ꞌa ja̱ꞌñe. Ja̱ maca Pa̱i Mamaquë tse̱a cua̱ñosiquë paꞌija̱ꞌquë api, que̱ cua̱ñojaꞌquëpi.” ");
INSERT INTO seyNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ja̱ muꞌseña Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌi, cua̱ñeseꞌe yeꞌyacohuaꞌi, cuiꞌne aiohuaꞌi, tsiꞌsisicohuaꞌipi paëꞌë, Caifás Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaë jai huëꞌe hueꞌse daripëna. ");
INSERT INTO seyNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ja̱rona Jesure coa cosojë tse̱ani huani je̱o ja̱ꞌñere ca ñahuë, i̱ti yoꞌo ja̱ꞌñere. ");
INSERT INTO seyNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ja̱je paꞌiquëtaꞌare “fiesta pa̱i tsiꞌsi macataꞌa tse̱añe pa̱ñuꞌu, pa̱ipi coꞌaye sa̱ñope yoꞌomaꞌcohuaꞌini” cahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Simón huëꞌere Jesús pajiꞌi, Betania daripëre ja̱ꞌju dahuë ju̱ꞌiquë hueꞌyosiquë huëꞌere. ");
INSERT INTO seyNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ja̱rote paꞌina, nomiopi quë̱na huë jai doꞌi quë̱na huëna deꞌo së̱ maꞌñapi ti̱mësiconi ca̱jico dacopi tsio dani, Jesús mesare ñuꞌina, ja̱ maꞌñapi i̱ si̱opëna doo. ");
INSERT INTO seyNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ja̱je iyere yoꞌocona, ñani i̱ yeꞌyacohuaꞌipi pë̱ijë ca huëohuë. “¿Me ne ja̱ꞌñere coa nejocoꞌni, jai doꞌire? ");
INSERT INTO seyNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","I̱opi yecohuaꞌina i̱sico jaiye curi neni peocohuaꞌi mañani co̱caito deꞌoꞌñe paꞌioni yoꞌoco.” ");
INSERT INTO seyNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Cajëna, Jesupi asani capi: “¿Me yoꞌojë jo̱sa cayeꞌni, i̱ote? Iye yëꞌëre yoꞌocaiye deꞌoye aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Coa siꞌanë mësaru coꞌamaña peocohuaꞌire paja̱ꞌcohuaꞌi aꞌë, mësaru acohuaꞌire. Ja̱je paꞌiquëtaꞌare yëꞌëre cato siꞌanë mësaru pamaꞌpë paꞌija̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Yëꞌë si̱opëna huëo së̱ maꞌñapi doye cato yëꞌëre ta̱si maca huëo së̱ ja̱ꞌñere ne deꞌhuacaio yoꞌoco. ");
INSERT INTO seyNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ja̱je paꞌina, nuñerepa cayë, mësarute. Coa siꞌa hue̱ꞌña iye huaso coca quëanije ico yëꞌëre yoꞌoseꞌe quëaja̱ꞌcohuaꞌi aꞌë. Ja̱je quëajëna, pa̱ije i̱ote hua̱nëyomaꞌpë cuasaja̱ꞌcohuaꞌi aꞌë, i̱o yoꞌoco paꞌiseꞌe.” ");
INSERT INTO seyNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ja̱ maca i̱ yeꞌyacohuaꞌipi aquëpi Judas Iscariote hueꞌequëpi Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌi quëꞌrona sani capi: ");
INSERT INTO seyNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“¿Je jaꞌye sa̱iñe yëyeꞌni, yëꞌëpi Jesure tse̱acaito?” Ja̱je caquëna, asani i̱te sa̱ihuë, treinta curiquë të̱ꞌña. ");
INSERT INTO seyNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ja̱re ja̱ macapi Judas Jesure pa̱i peo maca ñani tse̱ani ja̱ohuaꞌi jë̱ñana i̱sisiꞌi caquë coꞌepi. ");
INSERT INTO seyNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Fiesta huëo muꞌse oꞌsaye co̱ꞌmemaꞌa a̱o a̱i muꞌse ti̱ꞌaëna, i̱ yeꞌyacohuaꞌipi Jesure tsio dani se̱iꞌë: ¿Jerona nejaꞌcohuaꞌi aꞌni naꞌiquëna, a̱iñe, Egíptopi Israel pa̱i etajë paꞌiseꞌere cuasajë a̱i ja̱ꞌñe? “¿Jerona Egíptopi Israel pa̱i etaseꞌe cuasajë naꞌiquëna, a̱i ja̱ꞌñe neñeꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Cajëna, i̱pi capi, i̱ohuaꞌire: “Saijë̱ꞌë, jai daripëna sani huëꞌe paꞌiquëni ti̱ꞌani i̱te cajë̱ꞌë: ‘Yeꞌyaquëpi caji: Yëꞌë yoꞌo maca tsoe jaꞌyere paꞌiji. Ja̱je paꞌina, mëꞌë huëꞌena yëꞌë yeꞌyacohuaꞌi ja̱ꞌre co̱ni Egíptopi Israel pa̱i etajë paꞌiseꞌere cuasajë yoꞌoye nesiꞌi,’ caquë jëjo saopi.” ");
INSERT INTO seyNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ja̱je caëna, i̱ yeꞌyacohuaꞌipi Jesús cua̱ñeseꞌeje̱ yoꞌohuë. Yoꞌojë naꞌiquëna, a̱i ja̱ꞌñe ne deꞌhuahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ñami deꞌosi maca Jesús mesare i̱ doce yeꞌyacohuaꞌi ja̱ꞌre co̱ni pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Paꞌi ja̱ yëꞌtaꞌa a̱ore a̱i ñuꞌi capi, cuiꞌne: “Nuñerepa cayë mësarute, mësaru aquëpi yëꞌëre yehuoja̱ꞌquë api.” ");
INSERT INTO seyNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ja̱ maca ja̱je caquëna, ja̱ohuaꞌipi ai oi ëayerepa asa huesëhuë. Asani sa̱ꞌñe i̱ohuaꞌija̱ꞌa se̱ huëohuë, ñeje cajë: “Ëjaë, ¿më ñato yëꞌëpi yoꞌoja̱ꞌquë aꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Cajëna, ja̱ohuaꞌire sehuopi, Jesupi: “Yëꞌë ja̱ꞌre co̱ni teꞌe quë̱na deꞌhuana a̱iquëpi i̱ti yëꞌëre deꞌoye yoꞌoyeje̱ yoꞌoquë cosoquë tse̱a je̱o cua̱ñojaꞌquë. ");
INSERT INTO seyNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ja̱je paꞌina, Pa̱i Mamaquë cato toyaseꞌe cayeje̱ paꞌye yoꞌo saoye paꞌiji. Ja̱je paꞌiquëtaꞌare teayerepa yoꞌoja̱ꞌquë api, i̱te yehuoquë. Deꞌoraꞌpi, ja̱ë ai deꞌomaꞌë patu.” ");
INSERT INTO seyNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ja̱ maca Judaspi, i̱ti cosoquë tse̱a je̱o cua̱ñojaꞌquëpi i̱te capi: “¿Yeꞌyaquë, mëꞌë ñato yëꞌëpi yoꞌoja̱ꞌquë aꞌni?” Caquëna, capi: “Ja̱je paꞌijë̱ꞌë. Mëꞌë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ja̱ yëꞌtaꞌa a̱ore a̱ijë dujëna, Jesús i̱ jë̱ñapi panpë i̱ni Maijaꞌquëre deꞌoji caquë se̱jiꞌi. Ja̱ jeteyoꞌje i̱ yeꞌyacohuaꞌire i̱siquë capi: “A̲ijëꞌë. Iye cato yëꞌë ca̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ja̱ jeteyoꞌje u̱cu duruhuë i̱ jë̱ñapi i̱ni Maijaꞌquëre deꞌoji caquë se̱ni i̱ohuaꞌina se i̱siquë capi: “Siꞌaohuaꞌi u̱cujë̱ꞌë, iye u̱cu duruhuëna. ");
INSERT INTO seyNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Iye cato yëꞌë tsie aꞌë. Huajëye ca nëoñere neñe aꞌë. Cuiꞌne jai pa̱i coꞌaye yoꞌoseꞌere sa̱i deꞌhuayere caquë i̱siye aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ja̱je paꞌiquëtaꞌare cuiꞌnaëpi iye cuiyaꞌi oꞌsa co̱no u̱cuye pa̱jaꞌquë aꞌë, mësaru ja̱ꞌre co̱ni, yëꞌë jaꞌquë cua̱ñe te̱ꞌtena mësaru ja̱ꞌre huajë oꞌsa co̱no u̱cuye ti̱ꞌa macaja̱ꞌa.” ");
INSERT INTO seyNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Jë̱jë tëjisi jeteyoꞌje Olivos cu̱tihuëna saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ja̱ maca Jesupi capi, ja̱ohuaꞌire: “Iye ñami siꞌaohuaꞌire mësarute yëꞌëre quëco paseꞌe ti peocohuaꞌire nëijaꞌcoa. Ja̱je paꞌina, toyaseꞌe caji: ‘Huani je̱osiꞌi, yëi ñamare ñacaiquëre. Huani je̱osi maca yëi ñama huahuesicohuaꞌi paꞌija̱ꞌcohuaꞌi aꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ja̱je paꞌiquëtaꞌare yëꞌëpi ju̱ꞌisiquëpi huëni duꞌru Galileana saquëna, mësarupi jeteyoꞌje ti̱ꞌajaꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ja̱je ca maca Pedropi sehuopi: “Ja̱je siꞌaohuaꞌire mëꞌëre tuiye je̱osicohuaꞌi paꞌitoje̱ yëꞌë cato pa̱ñë.” ");
INSERT INTO seyNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ja̱je caquëna, Jesupi capi, i̱te: “Nuñerepa cayë, mëꞌëre. Iye ñami ja̱ yëꞌtaꞌa cura yëꞌimaꞌëna, mëꞌë yëꞌë ti ñamaꞌquë aꞌë caquë toaso̱ñe coa caja̱ꞌquë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedropi capi, i̱te: “Mëꞌë ja̱ꞌre co̱ni ju̱ꞌiñe paꞌito ju̱ꞌiñë, yëꞌë. Coa caye pa̱ñë.” Caquëna, cuiꞌne siꞌaohuaꞌi i̱ yeꞌyacohuaꞌi cahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ja̱ maca Jesús i̱ yeꞌyacohuaꞌi ja̱ꞌre co̱ni ti̱ꞌapi, Getsemaní hueꞌyo hue̱ꞌñana. Ti̱ꞌani capi, ja̱ohuaꞌire: “Yëꞌëseꞌe sani je macana se̱ina, mësaruseꞌe iye macana jaꞌrujë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ja̱je cani coa Pedrore cuiꞌne Zebedeo mamajëre cayaohuaꞌire sai sapi. Sani ai oi cuiꞌne ai coꞌa ju̱ꞌi ai yoꞌo huëopi. ");
INSERT INTO seyNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ja̱ maca capi, ja̱ohuaꞌire: “Ai oiyë, yëꞌë joyopi, ju̱ni huesëye paꞌina. Ja̱je paꞌina, mësaruseꞌe iye macana pëajë̱ꞌë, cuiꞌne yëꞌë ja̱ꞌre co̱ni sëtasicohuaꞌi paꞌijë̱ꞌë, mësaruje̱.” ");
INSERT INTO seyNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ja̱je cani Jesús ai se̱ña maca teꞌi se sajiꞌi. Sani ja̱rona tsiapi yejana simeni u̱i se̱jiꞌi, Maijaꞌquëre, ñeje caquë: “Yëꞌë jaꞌquë maca, deꞌhue ne ti̱ꞌañe paꞌito iye së̱je daꞌcare pare yëꞌëre nejocaijë̱ꞌë, pa̱ni yëꞌë yëquë cayeje̱ paꞌye yoꞌoye, coa mëꞌë yëyepi yoꞌoseꞌe paꞌija̱quë.” ");
INSERT INTO seyNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ja̱ maca i̱ yeꞌyacohuaꞌi quëꞌro coꞌiquë ti̱ꞌapi, tsoe ca̱isicohuaꞌipi u̱ijëna. Ñani Pedrore capi: “¿Quëco ti̱ꞌañe pa̱re, yëꞌë ja̱ꞌre co̱ni teꞌe hora macaje̱? ");
INSERT INTO seyNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Sëtasicohuaꞌi paꞌijë̱ꞌë. Cuiꞌne se̱jëꞌë, coꞌaye mëiñena, ta̱isicohuaꞌi paꞌiye pa̱jaꞌcohuaꞌi. Nuñerepa joyo cato yëji, neñe. Ja̱je paꞌiquëtaꞌare ca̱pëpi tutu peoji.” ");
INSERT INTO seyNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ti̱jupë sani co̱ni se̱jiꞌi, ñeje: “Yëꞌë jaꞌquë iye neñañe ai yoꞌoyere yeque necaiye peoto, coa mëꞌë yëyeje̱ yoꞌoseꞌe paꞌija̱ꞌquë.” ");
INSERT INTO seyNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ti̱jupë coꞌipi. Coꞌiquë i̱ yeꞌyacohuaꞌi ca̱isicohuaꞌini ti̱ꞌa co̱pi. I̱ohuaꞌi ñaco ca̱pi ai huëo ca̱ꞌa doꞌire si̱o meina, ca̱ëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ja̱ maca ñani je̱oni sajiꞌi, cuiꞌnaëpi Maijaꞌquëre se̱siꞌi caquë toaso̱ñe acore. Ja̱ꞌrë i̱ caseꞌeje̱ paꞌye caquë se̱jiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ja̱ maca sajiꞌi. I̱ yeꞌyacohuaꞌi quëꞌrona sani capi, ja̱ohuaꞌire: “Yuretaꞌa deꞌoji. Ca̱ijëꞌë, cuiꞌne huajëjë̱ꞌë. Tsoe ti̱ꞌapi, Pa̱i Mamaquëre coꞌaye yoꞌocohuaꞌi jë̱ñana i̱sija̱ꞌa maca. ");
INSERT INTO seyNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Huëijë̱ꞌë. Sañuꞌu. Tsoe daiji, yëꞌëre yehuoja̱ꞌquë.” ");
INSERT INTO seyNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús ja̱ yëꞌtaꞌa cocare capi, Judas ti̱tasi macaje̱. Jaë cato doce soisicohuaꞌi aquë pajiꞌi. Cuiꞌne i̱ ja̱ꞌre co̱ni jai pa̱i daëꞌë, hua̱ꞌña cuiꞌne tara co̱ni ca̱jicohuaꞌipi. Ja̱ohuaꞌi cato Maijaꞌquë huëꞌe ñacaicohuaꞌi ja̱ohuaꞌi jëjo daocohuaꞌi cuiꞌne judío pa̱i aiohuaꞌi jëjo daocohuaꞌi paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas i̱ti yoꞌoquë yehuoja̱ꞌquëpi quëaëña, ja̱ohuaꞌire: “Yëꞌë i̱ni sihuaja̱ꞌquë aꞌë. Ja̱ëni tse̱ajëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ja̱je casiquëpi Jesuna tsioja̱ni i̱te sihuayeje̱ yoꞌoquë capi: “¿Paꞌiquë, yeꞌyaquë?” ");
INSERT INTO seyNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Caquëna, Jesupi sehuopi i̱te: “¿Cajei, i̱quena daiquëꞌni?” Ja̱ maca Jesure tsioja̱ni tse̱ani sahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ja̱ maca ja̱je yoꞌojëna, Jesús cajeipi huaꞌtiyo dutani ca̱joroseꞌe tëto tëapi, Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaë joꞌyaëre pani. ");
INSERT INTO seyNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ja̱je yoꞌoquëna, Jesupi capi: “Deꞌhuajë̱ꞌë, mëꞌë huaꞌtiyo i̱o paꞌi hue̱ꞌñana. Siꞌaohuaꞌi huaꞌtiñoapi uihuacohuaꞌi cato ja̱re cuiꞌne huaꞌtiñoapi huaijëna, ju̱ꞌijaꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Huesëquë mëꞌë yëꞌëpi yëꞌë jaꞌquëre se̱quëna, yurepi tsoe doce mil hui̱ñaohuaꞌire jëjo daouna, co̱catiraꞌseꞌe? ");
INSERT INTO seyNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ja̱je yoꞌoye paꞌito ¿me toyaseꞌe caye ti̱ꞌaquëꞌni, ja̱je yoꞌo ja̱ꞌñe aꞌë, ca nëoseꞌe?” ");
INSERT INTO seyNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ja̱ maca Jesús pa̱ire capi: “¿Mësaru yëꞌëre tse̱añuꞌu cajë hua̱ꞌñapi cuiꞌne tarapi co̱ni tse̱ꞌejë date, coꞌamaña ñaëre tse̱añeje paꞌye? Siꞌa muꞌseña mësaru ja̱ꞌre yëꞌë paꞌi Maijaꞌquë huëꞌepi ñuꞌi yeꞌyaquëna, mësaru ti yëꞌëre tse̱añuꞌu camaꞌpë paꞌisicohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ja̱je paꞌiquëtaꞌare siꞌaye iye yoꞌoye paꞌiji, tsoe acohuaꞌi Maijaꞌquëre quëacaicohuaꞌi toyajë paꞌiseꞌepi ti̱ꞌajaquë cajë.” Ja̱ maca siꞌaohuaꞌi i̱ yeꞌyacohuaꞌi Jesure teꞌire je̱oni cati saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesure tse̱asicohuaꞌi sahuë, Caifás Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaë quëꞌrona. Cuiꞌne ja̱rote cua̱ñeseꞌe yeꞌyacohuaꞌi cuiꞌne aiohuaꞌi tsiꞌsisicohuaꞌipi paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ja̱je paꞌijëna, Pedropi soꞌo maca se ñaquë jeteyoꞌje tujiꞌi, pa̱i ëjaërepa huëꞌe daripë quëꞌrore paja̱ꞌa. Sani ja̱ro cacani ja̱ huëꞌere ñacaicohuaꞌi ja̱ꞌre co̱ni jaꞌrupi, merepa yoꞌoja̱ꞌcohuaꞌi aꞌni i̱te tse̱asicohuaꞌi cuasaquë. ");
INSERT INTO seyNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌipi cuiꞌne aiohuaꞌipi cuiꞌne siꞌa judío pa̱i yoꞌoye ñani ca tëjicohuaꞌipi coꞌehuë, Jesure sa̱ñope coꞌaye yoꞌoquë api cacohuaꞌini ti̱ꞌani Jesure huani je̱oñuꞌu cajë. ");
INSERT INTO seyNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ja̱je coꞌejëtaꞌa ti̱ꞌañe pa̱huë, i̱te sa̱ñope ca ja̱ꞌñe. Ja̱je ti̱ꞌamaꞌpë jai pa̱i i̱te coa huëojë cosojë coꞌaye yoꞌoquë api, cahuë. Ja̱je yoꞌo maca cayaohuaꞌi tëji hue̱ꞌñarepa sa̱ñope cacohuaꞌi daëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ja̱ohuaꞌipi dani cahuë: “Iquë cato yëꞌëpi Maijaꞌquë huëꞌe nejosiquëpi toaso̱ muꞌseña paꞌi maca cuiꞌnaoni huëoja̱ꞌquë aꞌë, caquë api.” ");
INSERT INTO seyNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ja̱ maca Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaëpi huëni nëcani capi, Jesure: “¿Ti teꞌe yëꞌopoje̱ sa̱ñope sehuoye pa̱quë, mëꞌë? ¿Mëꞌëre sa̱ñope ja̱ohuaꞌi caye asaquë, mëꞌë?” ");
INSERT INTO seyNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ja̱je catoje̱ Jesús ti camaꞌë pajiꞌi. Ja̱ maca Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaëpi capi, i̱te: “Maijaꞌquë huajëquërepa mamipi mëꞌëre care pajë̱ꞌë, cayë. Quëajë̱ꞌë, mëꞌëpi Maijaꞌquë mamaquërepa Cristo pani.” ");
INSERT INTO seyNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ja̱je caquëna, Jesupi capi, i̱te: “Ja̱je paꞌijë̱ꞌë. I̱ aꞌë, yëꞌë, mëꞌë cayeje̱. Cuiꞌne mësaru ñajaꞌcohuaꞌi aꞌë, Pa̱i Mamaquë Diusu tutu quëꞌirepa ëja te̱ꞌtere ñuꞌina, cuiꞌne maꞌtëmopi sirija̱ꞌa daina.” ");
INSERT INTO seyNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ja̱ maca Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaëpi i̱ juꞌi ca̱re naë yeꞌsapi, ai coa care paji caquë i̱ñoquë. Ja̱je yoꞌoquë capi: “Iquë Maijaꞌquëre ai cueꞌcuequë yoꞌoji, i̱ yëꞌopo cayepi. ¿Ja̱je paꞌito i̱quere yeque cajë i̱ yoꞌoquëna, ñasicohuaꞌini se̱ni asañuꞌu cajë coꞌeyeꞌni? Mësarupi tsoe asahuë, i̱ cueꞌcuequë caye. ");
INSERT INTO seyNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ja̱je paꞌito ¿me cayeꞌni, mësaru?” Caquëna, i̱ohuaꞌipi cahuë: “Ja̱je coꞌaye caquë api. Ja̱je paꞌina, ju̱ꞌiñe paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ja̱ maca i̱ tsiana copi tseꞌsejë cuiꞌne tarapi tëꞌcahuë. Yecohuaꞌipi tsiana mosi̱capi tëꞌcahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ja̱je yoꞌocohuaꞌipi cahuë, i̱te: “¿Mëꞌë aꞌë, Cristorepa se ta̱ꞌñe ca ñajëꞌë, nepi mëꞌëre tëtoreꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ja̱je yoꞌojëna, Pedro cato hueꞌse yejare jaꞌrusiquëpi ñujiꞌi. Ñuꞌina, pa̱ire necaico i̱ quëꞌrona tsioja̱ni cao, i̱te: “Mëꞌëje Jesús Galilea aquë ja̱ꞌre co̱ni cuꞌi paꞌisiquë aë.” ");
INSERT INTO seyNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ja̱je cacona, Pedropi siꞌaohuaꞌi paꞌi hue̱ꞌñana coa cosopi, ñeje caquë: “Huesëyë, mëꞌë caye. ¿I̱quere ja̱je cacoꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pedro eta saꞌro quëꞌrona huëni je̱ꞌnë saina, yecopi nomio ñani cao, i̱ti maca paꞌicohuaꞌire: “Iquë Jesús Nazaret aquë ja̱ꞌre co̱ni cuꞌi paꞌisiquë api.” ");
INSERT INTO seyNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Cacona, ja̱ maca Pedropi ti̱jupë coso co̱pi: “Ñamaꞌquëre paꞌë, ja̱ëte. Quëare payë.” ");
INSERT INTO seyNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Aꞌri maña tsoe paꞌi maca i̱ti maca paꞌicohuaꞌipi Pedro quëꞌrona tsioja̱ni cuiꞌne i̱te cahuë: “Nuñerepa mëꞌë i̱ yeꞌyasicohuaꞌi aquëre paꞌë. Ja̱je paꞌina, mëꞌë coca cayeque ti̱ñe paꞌiji, huesëye peoye.” ");
INSERT INTO seyNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Cajëna, i̱pi capi: “Ti ñamaꞌquë aꞌë, caye asa maꞌñe, mësaru.” Ja̱je i̱tire yoꞌoquë caquëna, cura yëjiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Yëꞌina, ja̱ maca Pedro cuasa ñajajiꞌi, Jesús i̱te caseꞌe: “Ja̱ yëꞌtaꞌa cura yëꞌimaꞌëna, mëꞌë toaso̱ñe yëꞌëre ñamaꞌquë aꞌë cosoja̱ꞌquë aꞌë.” Ja̱re cuasaquë ja̱ maca ja̱ro paꞌisiquëpi Pedro etani ai ojiꞌi, coꞌa ju̱ꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ñata to̱mesi maca Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌipi cuiꞌne judío pa̱i aiohuaꞌipi teꞌe cuasaye nehuë, Jesure huani je̱a ja̱ꞌñere cajë. ");
INSERT INTO seyNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Sëasiquëni sani Poncio Pilatona i̱ti yeja ëjaëna i̱sihuë. ");
INSERT INTO seyNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas Jesure yehuoquëpi ñaquëna, Jesupi huani je̱o cua̱ñojaꞌquë paꞌina, ñani ai oi pa̱ñete yoꞌoreꞌni cuasaquë oi treinta curi të̱ꞌña i̱te i̱siseꞌere cuiꞌnare coꞌyopi, Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌina. ");
INSERT INTO seyNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Coꞌyoquë capi, ja̱ohuaꞌire: “Coꞌaye yëꞌë yoꞌohuë, ti doꞌi peoquëni huani je̱ojaꞌquëre i̱siquë.” Ja̱je caquëna, i̱ohuaꞌipi sehuohuë, i̱te: “¿I̱quere yëquë oiyeꞌni, ja̱ yoꞌoseꞌe? Mëꞌëseꞌe yoꞌoquë cajë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ja̱ maca Judas, curiquë Maijaꞌquë huëꞌena je̱o ñato saoni sani que̱o deni ju̱jiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌipi curiquë ñaꞌñe o̱eseꞌere tsiꞌsoni careña: “Iye curiquë Maijaꞌquëre coa i̱sijë aya mahuëna ayaye peoji, tsie doꞌi sa̱iseꞌe me ayayeꞌni.” ");
INSERT INTO seyNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ja̱ jeteyoꞌje ja̱ohuaꞌi teꞌe cuiꞌne siꞌa yëꞌquë maca cuasajë ca deꞌhuahuë, “soto ne hue̱ꞌñana yejare hueroñuꞌu, ti̱ohuaꞌire ta̱jaꞌa yejare” cahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ja̱je paꞌina, ja̱ yeja yureje̱ “Tsie Yeja” hueꞌeji. ");
INSERT INTO seyNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ja̱je ti̱ꞌapi, tsoe aquë Maijaꞌquëre quëacaiquë Jeremias toyaquë paꞌiseꞌe ñeje cayepi: “Treinta curiquë të̱ꞌña i̱mahuë, i̱ doꞌire Israel pa̱i i̱siseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ja̱pi huerohuë, soto ne yejare, ëjaë yëꞌëre cua̱ñeseꞌeje̱ paꞌye.” ");
INSERT INTO seyNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús pa̱i ëjaë quëꞌrona sasiquë pajiꞌi. Paꞌina, i̱pi i̱te se̱jiꞌi: “¿Mëꞌë aë, judío pa̱i ëjaërepa?” Caquëna, Jesupi capi, i̱te: “Ja̱je paꞌijë̱ꞌë. Mëꞌë caseꞌeje̱ paꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌipi cuiꞌne aiohuaꞌipi sa̱ñope coꞌaye catoje̱ Jesús ti aꞌri mañaje sehuomaꞌë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pa̱quëna, ja̱ maca Pilatopi capi, i̱te: “¿Asamaꞌquë mëꞌë, mëꞌëre sa̱ñope yoꞌojë caye?” ");
INSERT INTO seyNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ja̱je catoje̱ Jesús ti sehuomaꞌë pajiꞌi. Ja̱je paꞌina, ña jujani pa̱i ëjaëpi ai i̱seꞌere ñani ¿me nejaꞌquë aꞌni? cuasapi. Cuiꞌne huesëpi, yeque yoꞌoye peoquëna. ");
INSERT INTO seyNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ja̱je paꞌiquëtaꞌare siꞌanë fiesta paꞌi maca pa̱i ëjaëpi cosicohuaꞌire eto saoquë yoꞌoye paquë pajiꞌi. Pa̱ipi ja̱ëni etoye paꞌiji cajëna, etoquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Pajiꞌi, cosiquë Barrabás hueꞌequë siꞌaohuaꞌi i̱ coꞌaye yoꞌoye asaquë. ");
INSERT INTO seyNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ja̱rote jai pa̱i tsiꞌsisicohuaꞌi paꞌijëna, Pilatopi se̱jiꞌi, ja̱ohuaꞌire: “¿Neni yëyeꞌni, deꞌoye paꞌija̱ꞌquëre jëjo saoye, Barrabás pa̱nitaꞌa Jesucristo?” ");
INSERT INTO seyNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Deꞌhue asapi, pa̱ipi Jesuni ai yëjë yoꞌo doꞌire pë̱ijë coꞌaye yoꞌomaꞌquëni tse̱aseꞌe. Ja̱je paꞌina, Pilato ja̱je capi. ");
INSERT INTO seyNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ja̱ yëꞌtaꞌa Pilato pa̱i coꞌaye yoꞌoseꞌere asani ne deꞌhua hue̱ꞌñare ñuꞌina, i̱ pacopi jëjo dao, i̱o caseꞌere quëaja̱ꞌquëre ñeje caco: “Ja̱ëre nuñerepa deꞌo pa̱ire cuiꞌna co̱ni yoꞌomaꞌë paꞌijë̱ꞌë. Coa ñajëꞌë. Ja̱ëte yoꞌo doꞌire huëo ca̱ni ñahuë, ai coꞌayerepa.” ");
INSERT INTO seyNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ja̱je paꞌiquëtaꞌare Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌipi cuiꞌne judío pa̱i aiohuaꞌipi pa̱ire cua̱ñehuë, Barrabásni etojë̱ꞌë cajë, cuiꞌne Jesuni huani je̱ojaꞌquëre cajë̱ꞌë, cahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pa̱i ëjaëpi ti̱jupë cuiꞌne se̱ni co̱quë capi: “¿Cayahuaꞌi tse̱asicohuaꞌi paꞌicohuaꞌire jequëni yëyeꞌni, eto saoye?” Caquëna, ja̱ohuaꞌipi cahuë: “Barrabásni etoye yëyë.” ");
INSERT INTO seyNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Cajëna, Pilatopi se̱jiꞌi, ja̱ohuaꞌire: “¿Cuiꞌne me nejaꞌquë aꞌni, Jesure Cristo hueꞌequëre?” Caquëna, siꞌaohuaꞌi sa̱ñope cahuë: “¡Que̱jaꞌquë api!” ");
INSERT INTO seyNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ja̱ maca Pilato capi, ja̱ohuaꞌire: “¿Ja̱je paꞌito i̱quere coꞌaye yoꞌo uꞌni?” Caquëna, ti̱jupë cuiꞌne cui co̱huë: “¡Que̱jaꞌquë api!” ");
INSERT INTO seyNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatopi i̱ coꞌaye yoꞌoseꞌe asa ti̱ꞌamaꞌëna, coa pa̱ipi jerepa jo̱sa yoꞌojë sa̱ñope ja̱seꞌe cajëna, ña jujani jë̱ña tsoasiꞌi caquë oco daja̱ꞌquëre jëjo saouna, daëna, tsoaquë capi: “Yëꞌëpi iquë deꞌo pa̱ire huani je̱o ja̱ꞌñe cua̱ñemaꞌë paꞌiyë. Mësaruseꞌe yoꞌojë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ja̱je caquëna, siꞌa pa̱i sehuohuë: “Yëquëna cuiꞌne yëquë mamajëna i̱te huani je̱o doꞌi to̱mejaquë.” ");
INSERT INTO seyNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ja̱ maca Pilatopi Barrabásni eto saopi, deꞌoye paꞌija̱ꞌquëre. Etoquë Jesuni siꞌseni ja̱ jeteyoꞌje que̱ni huani je̱ojaꞌquëre jëjo saopi. ");
INSERT INTO seyNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ja̱ jeteyoꞌje pa̱i ëjaë soldado pa̱ipi Jesure sahuë, jai huëꞌena. Siꞌa soldado pa̱i tsiꞌsisicohuaꞌirepa paëꞌë, Jesús paꞌi hue̱ꞌñana. ");
INSERT INTO seyNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ja̱ jeteyoꞌje i̱ juꞌi ca̱ dutani majaꞌi juꞌi ca̱re su̱ñacaëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Cuiꞌne si̱opëna miu maro pu̱acaëꞌë. Cuiꞌne ëja te̱ꞌte jë̱tëna so̱quë tarapë i̱sihuë. Ja̱ maca i̱ ña hue̱ꞌñana doꞌre jaꞌruni cueꞌcuejë ñeje i̱te cahuë: “¡Paꞌijë̱ꞌë, judío pa̱i ëjaërepa!” ");
INSERT INTO seyNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ja̱je cajë cuiꞌne copi tseꞌsejë cuiꞌne i̱te tarapëpi si̱opëna tëꞌcajë yoꞌohuë. ");
INSERT INTO seyNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ja̱je i̱te cueꞌcue tëjini majaꞌi juꞌi ca̱ dutani i̱ juꞌi ca̱re pare su̱ñacani ja̱ maca que̱jaꞌquëre sahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ja̱ropi etani saijë Cirene aquëre ti̱ꞌahuë, Simón hueꞌequëre. Ja̱ëni Jesure que̱jaꞌa sarahua sacaija̱ꞌquëre cua̱ñehuë. ");
INSERT INTO seyNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ja̱je yoꞌojë Gólgota hueꞌe hue̱ꞌñana ti̱ꞌahuë. Ja̱je cani cayë, pa̱i si̱opë tara. ");
INSERT INTO seyNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ja̱rona Jesure cuiyaꞌi oꞌsa co̱nona së̱jeñe co̱ni co̱ꞌmesicore o̱cuahuë. Ja̱je o̱cuajëna, Jesús i̱pi neñani u̱cuye coepi, i̱ote. ");
INSERT INTO seyNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","I̱te que̱si maca jeteyoꞌje soldado pa̱ipi Jesús juꞌi ca̱re ¿nepi i̱ote paja̱ꞌcohuaꞌi aꞌni? cajë yoꞌohuë, sa̱ꞌñe i̱ohuaꞌija̱ꞌa. Ja̱je yoꞌojëna, tsoe aquë Maijaꞌquëre quëacaiquë toyaseꞌe ñeje caye ti̱ꞌapi: “Yëꞌë juꞌi ca̱re pa̱i ñape huahuehuë, i̱ohuaꞌija̱ꞌa ¿nepi paja̱ꞌcohuaꞌi aꞌni?” cajë yoꞌohuë. ");
INSERT INTO seyNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ja̱je yoꞌo tëjini yecohuaꞌipi dani samaꞌcohuaꞌini cajë jaꞌruni ñahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Cuiꞌne i̱ si̱opë sa̱ꞌnihuëna ja̱ doꞌire ju̱ꞌiji caco quëacore toyani sëohuë. Toyasico cato pajiꞌi, ñeje: IQUË API, JESÚS, JUDÍO PA̲I ËJAË. ");
INSERT INTO seyNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Cuiꞌne caya coꞌamaña yahue i̱macohuaꞌire que̱sicohuaꞌi paëꞌë, i̱ ja̱ꞌre co̱ni, yequëni i̱ ëja te̱ꞌtena cuiꞌne yequëni i̱ ari te̱ꞌtena. ");
INSERT INTO seyNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Cuiꞌne i̱ti macasaꞌa da saicohuaꞌipi cueꞌcuejë tea ju̱ꞌijë si̱opë api së̱ꞌcuijë saëꞌë, i̱te ñajë. ");
INSERT INTO seyNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Cuiꞌne cahuë: “Mëꞌë aꞌë, Maijaꞌquë huëꞌe peo hue̱ꞌña nejoni cuiꞌne toaso̱ muꞌseña paꞌi maca cuiꞌnaoni huëoja̱ꞌquë aꞌë, caquë paꞌisiquë. Ja̱je paꞌi sëte yure coꞌye huasojë̱ꞌë. Mëꞌëpi Maijaꞌquë mamaquë pani cruzupi caje nëcajë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ja̱je cuiꞌne Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌije̱ cuiꞌne cua̱ñeseꞌe yeꞌyacohuaꞌije̱, fariseohuaꞌije̱ cuiꞌne cueꞌcuehuë, i̱te. Ja̱je cueꞌcuejë sa̱ꞌñe i̱ohuaꞌija̱ꞌa cahuë: ");
INSERT INTO seyNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Yecohuaꞌitaꞌare huasopi. Ja̱je paꞌiquëtaꞌa i̱jaꞌa coꞌye huasoyere pa̱ji. Ja̱je paꞌina, i̱pi Israel pa̱i ëjaërepa pani yurepi cruzu dequëpi caje nëcaëna, sehuoye patiraꞌpi, maire. ");
INSERT INTO seyNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Iquë cato Maijaꞌquëna i̱re papi cuasaquë quëcoquë pajiꞌi. Ja̱je paꞌisiquëre sëte yure Maijaꞌquëpi i̱te huasoja̱quë, i̱te oiquërepa pani. I̱taꞌa maire ‘yëꞌë cato Diusu mamaquëre paꞌë’ caquë paꞌisiquë api.” ");
INSERT INTO seyNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Cuiꞌne coꞌamaña ñaohuaꞌije̱ i̱ ja̱ꞌre co̱ni que̱sicohuaꞌique tea ju̱ꞌijë sa̱ñope cahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ja̱ maca yuretaꞌa siꞌa yeja ñamije paꞌiorepa deꞌo nëjiꞌi, muꞌse jopore papi naꞌi maca tres paꞌi macaja̱ꞌa. ");
INSERT INTO seyNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Cuiꞌne ja̱re ja̱ hora paꞌi maca Jesús ai tutu cuipi: “Eli, Eli, lama sabactani”. Ja̱ caye cato caji: Yëꞌë Diusu, Yëꞌë Diusu, ¿me nesiꞌquë yëꞌëre je̱oco huesouꞌni? ");
INSERT INTO seyNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Yecohuaꞌi i̱ti maca paꞌicohuaꞌipi asani cahuë: “Tsoe aquë Maijaꞌquëre quëacaiquë Elías paꞌisiquëni soiji.” ");
INSERT INTO seyNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ja̱re i̱ti macapi teꞌi huëꞌhuëpi, oco sa̱ësi pë quërëja̱siꞌi caquë. Quërëja̱ni dani oꞌsa cuiyaꞌi co̱nore sa̱ë tëjini so̱quë tarapëna hue̱ sëoni u̱cuja̱quë caquë jaꞌye maca sapi. ");
INSERT INTO seyNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ja̱je yoꞌoquëna, yecohuaꞌipi cahuë: “Yoꞌomaꞌë. Ñañuꞌu, Elíaspi dani i̱te huasoquë paꞌito.” ");
INSERT INTO seyNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ti̱jupë Jesús tutu cuiꞌne cui co̱pi. Ja̱ maca ju̱ni huesëpi. ");
INSERT INTO seyNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ja̱re i̱ti macapi Maijaꞌquë huëꞌe ta̱ꞌtëpo tëhuosico cayaye ë̱mëjeꞌepi huëꞌehuëre pana yete sajiꞌi. Yejaje̱ ñuꞌcuequë cuiꞌne quë̱na yejañaje tsate sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Cuiꞌne ju̱ꞌisicohuaꞌire ta̱seꞌeje̱ huiꞌye sapi. Cuiꞌne Maijaꞌquëre asani ju̱ꞌisicohuaꞌije̱ huëisicohuaꞌi paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ta̱si daripë̱api huëisicohuaꞌi paëꞌë, Jesús huëisi jeteyoꞌje. Huëni deꞌo Jerusalén daripëna cacahuë. Cacajëna, jai pa̱i ñahuë, ja̱ohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ja̱ maca Capitán cuiꞌne i̱ ja̱ꞌre co̱ni Jesure ñacohuaꞌipi yeja ñuꞌcueye ñani cuiꞌne yeque jaiye yoꞌoyere ñajë ai caꞌrajë cahuë: “Nuñerepa iquë Maijaꞌquë mamaquërepa pajiꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ja̱rote jai pa̱i nomiohuaꞌije̱ paëꞌë, soꞌopi de ñajë, Jesure Galileapi co̱caijë tuisicohuaꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ja̱ohuaꞌi ja̱ꞌre co̱ni paëꞌë, María Magdalena, María Jacobo cuiꞌne José pëca jaꞌco cuiꞌne Zebedeo mamajë pëca jaꞌco co̱ni paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ñami deꞌo huëo maca jaiye coꞌamaña paquë José hueꞌequë Arimatea daripë aquëpi dajiꞌi. Ja̱ë cato Jesure tuiquë deꞌosiquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ja̱je paꞌipi ja̱ëpi Pilato quëꞌrona sani Jesús ca̱përe se̱jiꞌi. Se̱ina, ja̱ maca Pilatopi cua̱ñepi, i̱sijë̱ꞌë caquë i̱ti ñacaicohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josépi i̱ ca̱pë siꞌsi peo ca̱pi peo hue̱ꞌña deapi. ");
INSERT INTO seyNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Yoꞌoni huajëcore pana i̱ tse̱cona o̱api, quë̱na yeja perepëna coje nesicona. I̱te ta̱ni jai quë̱na pëpi daripë se si̱oni sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Cuiꞌne ja̱rote paëꞌë, María Magdalena, cuiꞌne yequë María co̱ni, daripë ti̱ñare pare jaꞌrusicohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Se ñatasi muꞌse cato huajë muꞌse deꞌhua tëjisi maca pajiꞌi. Paꞌina, Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌipi cuiꞌne fariseohuaꞌi co̱ni Pilato quëꞌrona saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ti̱ꞌani cahuë: “Ëjaë, yëquë ja̱ë cosou ja̱ yëꞌtaꞌa huajëquë paꞌinë ñeje caquë paꞌiseꞌere cuasayë, ‘Toaso̱ muꞌseña paꞌi maca ju̱ꞌisiquëpi cuiꞌnaëpi huëija̱ꞌquë aꞌë caseꞌere.’ ");
INSERT INTO seyNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ja̱je paꞌina, jëjo saojë̱ꞌë, ta̱si daripë ñajaꞌcohuaꞌire toaso̱ muꞌseña paꞌi macaja̱ꞌa, i̱ yeꞌyaquë paꞌisicohuaꞌipi dani i̱ ca̱pë ñani sani, ja̱ maca pa̱ire ‘Tsoe huëjiꞌi, ju̱ni huesësiquë paꞌisiquëpi’ camaꞌcohuaꞌini. Ja̱je yoꞌoseꞌe cato ai jerepa duꞌru cososeꞌe jerepa coa cososeꞌe paꞌimaꞌconi tëjiyerepa cosoyepi.” ");
INSERT INTO seyNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Cajëna, Pilatopi capi, ja̱ohuaꞌire: “Ja̱ohuaꞌi paꞌiyë, i̱ti ñacohuaꞌi soldado pa̱i. Ja̱je paꞌito sani deꞌoyerepa ñajëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ja̱je caëna, sani ta̱si daripëre deꞌoyerepa deꞌhuani i̱ti coje si̱o quë̱na pë ë̱mëjeꞌena toyani sëohuë. Sëoni i̱ti macana soldado pa̱ire ñajaꞌcohuaꞌire je̱oni saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Huajë muꞌse tëto sani duꞌru macarepa semana muꞌse ñata maca María Magdalena, cuiꞌne yeco María co̱ni ta̱si daripë ñañuꞌu cajë saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Saijëna, cuasamaꞌtore papi tutu yeja ñuꞌcueye pajiꞌi, Ja̱ cato Ëjaë hui̱ñaëpi maꞌtëmopi ta̱si daripë quëꞌrona ti̱tani yoꞌopi, quë̱na pë coje si̱osiconi ne ta̱oni i̱o ë̱mëjeꞌena jaꞌrupi. ");
INSERT INTO seyNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Mujuë yeꞌhueye miañe ñañeje paꞌirepa pajiꞌi. Cuiꞌne i̱ juꞌi ca̱pi po yëioje̱ paꞌiorepa pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ja̱re ñani soldado pa̱ipi quëquë huesëni tsasijë ju̱ꞌiseꞌeje̱ paꞌiohuaꞌi deꞌohuë. ");
INSERT INTO seyNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ja̱ maca ëjaë joꞌyaëpi capi, nomiohuaꞌire: “Caꞌramaꞌpë paꞌijë̱ꞌë. Tsoe yëꞌëpi asayë, Jesure que̱ni huani je̱osiquëre mësaru coꞌeye. ");
INSERT INTO seyNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","I̱ño peoji. Tsoe huëjiꞌi, i̱ caseꞌeje̱ paꞌye. Dani ñajëꞌë, i̱te o̱a sitore. ");
INSERT INTO seyNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Sani esa cajë̱ꞌë, i̱ yeꞌyacohuaꞌire: ‘I̱ cato ju̱ꞌisiquë paꞌisiquëpi huëjiꞌi. Yure ja̱je paꞌipi mësaru Galilea ja̱ yëꞌtaꞌa ti̱ꞌamaꞌpëna duꞌru saija̱ꞌquë api. Ja̱rona i̱te ñajaꞌcohuaꞌi aꞌë, mësaru.’ Iyeseꞌe paꞌiji, yëꞌë mësarute casiꞌi cuasaseꞌe.” ");
INSERT INTO seyNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ja̱ maca nomiohuaꞌipi esa ta̱si daripë quëꞌropi caꞌrajë cuiꞌne ai sihuacohuaꞌipi huëꞌhuëjë saëꞌë, huajë cocare i̱ yeꞌyacohuaꞌi paꞌisicohuaꞌire quëañuꞌu cajë. ");
INSERT INTO seyNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ja̱ huëꞌhuëjëna, Jesupi ja̱ohuaꞌina ñaini pëpapi. Pëpaquëna, ja̱ maca Jesure i̱re papi cajë i̱ quë̱ona suꞌcuajë deꞌoquëre pani cahuë. ");
INSERT INTO seyNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yoꞌojëna, i̱pi capi, ja̱ohuaꞌire: “Caꞌramaꞌpë paꞌijë̱ꞌë. Sani quëajë̱ꞌë, yëꞌë yoꞌje tsi̱re. Galileana sani yëꞌëre ñañe paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ja̱ yëꞌtaꞌa nomiohuaꞌi saijëna, yecohuaꞌi soldado pa̱i i̱ti ñasicohuaꞌipi pa̱i paꞌi hue̱ꞌñana sani siꞌaye i̱ohuaꞌi yoꞌoquëna, ñaseꞌere quëahuë, Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ëjaohuaꞌipi sani aiohuaꞌi ja̱ꞌre co̱ni cahuë, siꞌa yëꞌquë maca cuasaye paꞌija̱quë cajë. Ja̱je cajë ja̱ maca soldado pa̱ire jaiye curiquë i̱sihuë. ");
INSERT INTO seyNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","I̱sijë cahuë, ja̱ohuaꞌire: “Mësarupi cajë̱ꞌë: ‘ñami yëquë ca̱ni huesësi maca Jesús yeꞌyaquë paꞌisicohuaꞌipi dani i̱ ca̱pë ñani sahuë.’ ");
INSERT INTO seyNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ja̱re pa̱i ëjaëpi asa ti̱ꞌani, mësarute sa̱ñope yoꞌoye paꞌito yëquëpi i̱te ca deꞌhuacañuꞌu. Cuiꞌne ai yoꞌoye paꞌitoje̱ co̱caija̱ꞌcohuaꞌi aꞌë, mësarute.” ");
INSERT INTO seyNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ja̱ maca soldado pa̱ipi curiquë i̱mani, sani ja̱re i̱ohuaꞌi yëhuojë caseꞌeje̱ paꞌye quëahuë. Ja̱je paꞌina, yure iye muꞌseñaje judío pa̱i cuiꞌne quëajë paꞌicohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ja̱je duꞌru ca nëoseꞌe sëte i̱ yeꞌyacohuaꞌi once paꞌiohuaꞌi Galileana saëꞌë, Jesús quëa nëosi cu̱tihuëna. ");
INSERT INTO seyNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ja̱rona Jesure ñani i̱te doꞌre jaꞌruni deꞌoquëre paꞌni cajë yoꞌohuë, ja̱ yëꞌtaꞌa yecohuaꞌi jëa coejëtaꞌa. ");
INSERT INTO seyNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ja̱ maca Jesús ja̱ohuaꞌire tsioja̱ni capi: “Yëꞌëna siꞌaye tutu i̱siseꞌe paꞌiji, maꞌtëmo cuiꞌne yeja cua̱ñequërepa paꞌija̱ꞌquëre. ");
INSERT INTO seyNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ja̱je paꞌina, saijë̱ꞌë, coa siꞌa yejaña pa̱i paꞌi hue̱ꞌñana. Sani yëꞌëre yeꞌyecohuaꞌire necaijë̱ꞌë. Ja̱ohuaꞌire Maijaꞌquë mamipi, i̱ mamaquë mamipi, cuiꞌne deꞌo joyo mamipi oco docaijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ja̱je yoꞌojë cuiꞌne yeꞌyajë̱ꞌë, yëꞌë mësarute cua̱ñeseꞌere siꞌaye sehuoja̱jë cajë. Cuiꞌne cuasajë̱ꞌë, yëꞌëpi mësaru ja̱ꞌre siꞌa muꞌseña paꞌiji, yeja caraja̱isi macaja̱ꞌa.” Deꞌoji. Ja̱je paꞌija̱quë.");
INSERT INTO seyNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Deꞌo coca ñeje huëopi. Ñeje yoꞌopi, Ëjaë Jesucristo Maijaꞌquë mamaquë. ");
INSERT INTO seyNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Maijaꞌquëre quëacaiquë Isaíaspi Maijaꞌquë quëaquëna, toyapi, ñeje: “Yëꞌëre quëacaiquëre duꞌru jëjo saosiꞌi, saija̱ꞌa maꞌa ne deꞌhuacaija̱ꞌquëre. ");
INSERT INTO seyNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Airopi i̱ yëꞌoseꞌe jutaja̱ꞌcoa. Ne deꞌhuajë̱ꞌë, Mai Ëjaë daija̱ꞌa maꞌa, nui maꞌa huiꞌyocaijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ja̱je paꞌina, Juan cue̱ne yejaja̱ꞌa dai pa̱ire doquë dajiꞌi. Ja̱je dai capi: Mësaru ja̱ꞌrë cuasaseꞌere je̱oni po̱nëto oco doye paꞌiji, mësaru coꞌaye yoꞌoseꞌe sa̱i deꞌhuacaiseꞌe paꞌija̱ꞌcore. ");
INSERT INTO seyNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Judea quëꞌro pa̱i cuiꞌne Jerusalén daripë pa̱i siꞌaohuaꞌi i̱ paꞌi hue̱ꞌñana sani i̱ohuaꞌi coꞌaye yoꞌoseꞌe oijë quëajëna, Juanpi Jordán tsiayana dopi. ");
INSERT INTO seyNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan ca̱ña cato camello nañapi neseꞌe pajiꞌi. Cuiꞌne i̱ të̱i ca̱ cato ca̱ꞌnipi nesico pajiꞌi. I̱ a̱iñe cato pu̱ꞌsu cuiꞌne mejaë paya pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ñeje caquë pa̱ire quëaëña: “Yëꞌë jeteyoꞌje jerepa paꞌipi daiji. I̱ joꞌyaë në meni zapato joyecaiquëje̱ paꞌi yëꞌë peoyë, ai teaye paꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ocopi dohuë, mësarute. Jesutaꞌa Maijaꞌquë joyore i̱sija̱ꞌquë api.” ");
INSERT INTO seyNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ja̱ muꞌseña Jesupi Nazaret daripëpi de daquëña. Nazaret daripë cato Galilea quëꞌro pajiꞌi. Daquëna, Juanpi Jordán ñana dopi, Jesure. ");
INSERT INTO seyNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Do tëjina, Jesús tsiayapi tu̱maquëna, maꞌtëmo ja̱ca sacona, ñaëña. Ñaquëna, Maijaꞌquë joyo i̱re pana nëca mequëña, suꞌteje̱ paꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nëca meina, maꞌtëmopi yëꞌoseꞌe jutaëña: “Mëꞌë yëꞌë mamaquë aꞌë. Mëꞌëre ai yëyë. Ai sihuaquë paꞌiyë, mëꞌëre.” ");
INSERT INTO seyNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ja̱ maca je̱ꞌnërepa Maijaꞌquë joyopi saëña, Jesure, yequë hue̱ꞌñana, pa̱i peo hue̱ꞌñana. ");
INSERT INTO seyNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Saëna, airo acohuaꞌi quëꞌrona cuarenta muꞌseña paꞌina, mënapi coꞌaye yoꞌoja̱quë caquë dani neñaëña. Mënapi ja̱je yoꞌo tëji maca hui̱ñaohuaꞌipi dani Jesure necateña. ");
INSERT INTO seyNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Juanre tsoe tse̱ani cosi maca Jesús jeteyoꞌje sajiꞌi, Galileana, deꞌo cocare quëaquë Diusu te̱ꞌte ayere. ");
INSERT INTO seyNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ñeje caquë quëapi: “Tsoe ti̱ꞌapi, Maijaꞌquë cua̱ñe te̱ꞌte. Jaꞌyere paꞌiji. Mësaru ja̱ꞌrë cuasaseꞌe je̱oni yeque cuasayena po̱nëjëꞌë. Huaso cocare asajë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesupi Galilea jaira të̱ꞌtëpaja̱ꞌa saina, Simón i̱ yoꞌjei Andrés co̱ni huaꞌi hua̱terë je̱o dëojëna, ñaëña, i̱ti huaꞌi yoꞌecohuaꞌi sëte. ");
INSERT INTO seyNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ñani ja̱ohuaꞌire capi: “Yëꞌë ja̱ꞌre daijë̱ꞌë. Yuretaꞌa pa̱ire yoꞌecohuaꞌi paꞌija̱ꞌcohuaꞌire nesiꞌi, yëꞌëpi.” ");
INSERT INTO seyNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ca tëjina, hua̱terë je̱oni sateña, i̱ ja̱ꞌre. ");
INSERT INTO seyNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Satena, se̱ña maca saina, Zebedeo mamajëpi Jacobopi i̱ yoꞌjei Juanpi co̱ni yohuëre ñuꞌijë hua̱terëre que̱ꞌque doꞌsejëna, ñaëña. ");
INSERT INTO seyNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ñani i̱ohuaꞌire soiña. Soina, ja̱ohuaꞌije̱ pëca jaꞌquëre je̱oni Jesús ja̱ꞌre sateña, i̱ saina co̱caicohuaꞌi ja̱ꞌre co̱ni yohuëre paꞌina. ");
INSERT INTO seyNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Je̱o saisicohuaꞌipi capernaum daripëna sa ti̱ꞌani, duꞌru huajë muꞌse Judea pa̱i tsiꞌsi huëꞌena cacarena, yeꞌyaëña, Jesupi. ");
INSERT INTO seyNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Yeꞌyaquëna, me nesiquëpi deꞌoyerepa ta̱ꞌñerepa yeꞌyaquëꞌni, ja̱ë, cua̱ñequëje̱ paꞌirepa yeꞌyaquëꞌni. Maire yeꞌyacohuaꞌi yoꞌoyeje̱ yoꞌoye pa̱ji, cuasareña. ");
INSERT INTO seyNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Cuiꞌne pa̱i tsiꞌsi huëꞌere huati quëꞌi paquëña. ");
INSERT INTO seyNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Paꞌipi caëña: “¿Jesús Nazaret daripëpi daiquë me nesiꞌquë yëquëre yoꞌoquëꞌni? ¿Yëquëre huasiꞌquë daiquë? Ti cua̱ñequërepa deꞌoquëni ñahuë, mëꞌëre.” ");
INSERT INTO seyNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Caquëna, Jesupi huatire caëña: “Camaꞌë paꞌijë̱ꞌë. Ja̱ëte je̱oni etajë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Caquëna, asani hueꞌhue dahuëje̱ paꞌye ju̱ꞌiquëte yoꞌoni cuini etaëña, huati. ");
INSERT INTO seyNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ja̱je yoꞌouna, ñani siꞌaohuaꞌi quëquë huesëni sa̱ꞌñe se̱teña: “¿I̱que aꞌni, iye? ¿I̱querepa huajë yeꞌyaye aꞌni, iye? ¿Huatiohuaꞌire eto sao tuture paque paji. Ja̱je paquëni i̱ cua̱ñeñe sehuojë etayë?” ");
INSERT INTO seyNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ja̱je Jesús yoꞌoyeseꞌe esa Galilea yeja paꞌicohuaꞌi asa ti̱ꞌareña. ");
INSERT INTO seyNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yeꞌya tëjini pa̱i tsiꞌsi huëꞌepi etani Simón cuiꞌne Andrés huëꞌena cacaëña. Jacobo cuiꞌne Juan co̱ni cacareña, Jesús ja̱ꞌre. ");
INSERT INTO seyNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Cacarena, Simón huao su̱ña dahuëre ju̱ꞌio u̱ico pacoña. Paꞌiona, i̱o ju̱ꞌiñe quëareña, Jesure. ");
INSERT INTO seyNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Quëarena, asani dani i̱o jë̱tëna tse̱ani naë huëouña. Naë huëouna, su̱ña dahuë je̱ouña. Je̱ouna, huëni siꞌaohuaꞌire a̱oña. ");
INSERT INTO seyNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Naꞌiquëna, ë̱së caje huesëquëna, ja̱ daripë siꞌa ju̱ꞌicohuaꞌire cuiꞌne huati quëꞌiohuaꞌire Jesús quëꞌrona dareña. ");
INSERT INTO seyNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Siꞌa pa̱i ja̱ daripë acohuaꞌi tsiꞌsireña, eta saꞌro quëꞌrona. ");
INSERT INTO seyNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Tsiꞌsirena, jai pa̱ire jujuquëna, coꞌyareña, siꞌaohuaꞌi. Siꞌaye ju̱ꞌiñe paꞌitoje̱ deꞌoye jujuña. Cuiꞌne huati quëꞌiohuaꞌi paꞌijëna, eto saouña, huatiohuaꞌire. Huatiohuaꞌipi tsoe Jesure ñareña. Jesupi huatiohuaꞌi cayete ë̱sequë, camaꞌpë paꞌijë̱ꞌë, cani eto saouña. ");
INSERT INTO seyNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ja̱ yoꞌo tëjini pëani ca̱ni nea hue̱ꞌñarepa huëni saquëña, pa̱i peo hue̱ꞌñana Maijaꞌquëni casiꞌi caquë. ");
INSERT INTO seyNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ja̱ caquëna, Simón cuiꞌne yecohuaꞌi co̱ni tuteña. ");
INSERT INTO seyNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tuni ti̱ꞌani i̱te careña: “Siꞌaohuaꞌi mëꞌëni coꞌeyë.” ");
INSERT INTO seyNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Cajëna, Jesupi i̱ohuaꞌire caëña: “Je darina sañuꞌu. Je darije̱ cuiꞌne Maijaꞌquë coca quëasiꞌquë daëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Cani saquëña. Siꞌa hue̱ꞌña Galilea quëꞌroja̱ꞌa sai siꞌa Judea tsiꞌsi huëꞌena cacani Maijaꞌquë coca quëaroja̱quëña. Cuiꞌne huatiohuaꞌire eta saouña. ");
INSERT INTO seyNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jesús paꞌi hue̱ꞌñana teꞌi ju̱ꞌiquëpi daquëña. Ja̱ꞌju dahuë ju̱ꞌiñe hueꞌequëpi dani doꞌre jaꞌruni oi se̱quëña: “Mëꞌëpi yëni ne coꞌyajë̱ꞌë, yëꞌëre.” ");
INSERT INTO seyNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ju̱ꞌiquëte oi ñaquë jë̱tëpi se patoquë caëña: “Yëyë. Mëꞌëre jujusiꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Cani patoquëna, ti ju̱ꞌiñe peoquëre pare ne coꞌyaëña, i̱te. ");
INSERT INTO seyNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ne coꞌyani Jesupi yëhuouña, yëꞌë ne coꞌyaseꞌe quëamaꞌë paꞌijë: ");
INSERT INTO seyNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Yecohuaꞌire quëamaꞌë paꞌijë̱ꞌë, coa Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaëseꞌere i̱ñojëꞌë, Moisés cua̱ñequë paꞌiseꞌere i̱siquë mëꞌë siꞌsire tsoa to̱siquë paꞌiyere i̱ñoquë. Ja̱je yoꞌoquëna, yecohuaꞌi ñajajë caëña. Cani jëjo saouña.” ");
INSERT INTO seyNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ti jujusiquëpi etani sani Jesús yoꞌoseꞌere siꞌa hue̱ꞌña quëaëña. Quëaëna, Jesupi pa̱i daripë̱a ti̱ñarepa cacaye peouña. Peoquëna, hueꞌsere pa̱i peo hue̱ꞌñare paquëña. Paꞌiquëtaꞌare pa̱ipi i̱ quëꞌrona siꞌa hue̱ꞌña acohuaꞌipi dateña. ");
INSERT INTO seyNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yequë huë̱ꞌñare paniroja̱ni tëjini, ti̱jupë Capernaum yejana coꞌi co̱pi. Coꞌina, huëꞌere paꞌiji asareña, yecohuaꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Asani esa tsiꞌsireña. Siꞌa huëꞌe ti̱më huesëoña, soꞌo saꞌro peoyerepa. Ja̱je tsiꞌsirena, i̱ cato Maijaꞌquë cocare quëaëña. ");
INSERT INTO seyNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Quëaquëna, cajeseꞌe ë̱mëohuaꞌipi ju̱ꞌiquëre hueꞌejë dareña. I̱ ju̱ꞌiñe cato quëꞌquë dahuë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Dani jai pa̱i paꞌijëna, Jesús paꞌi hue̱ꞌñana caca ti̱ꞌañe peoquëna, ña jujani huëꞌe ë̱mëjeꞌejaꞌa coje neni ju̱ꞌiquëre ca̱i saihuëre u̱ina, Jesús nëca hue̱ꞌñana casareña. ");
INSERT INTO seyNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jujucaija̱ꞌquë api cuasajë yoꞌoyere ñani Jesús ju̱ꞌiquëre capi: “Tsihuaꞌë, mëꞌë coꞌaye yoꞌoseꞌere sa̱i deꞌhuacaiseꞌe aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ja̱je caquëna, i̱ti maca ñuꞌicohuaꞌipi cua̱ñeseꞌe yeꞌyacohuaꞌi acohuaꞌipi asani cuasahuë. ");
INSERT INTO seyNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","¿Me yoꞌoquë ja̱je caquëꞌni, iquë? Coa Maijaꞌquëni cueꞌcuequë caji. Iye yeja acohuaꞌi pa̱i coꞌaye yoꞌoseꞌere sa̱i deꞌhuaye peoji. Coa Diususeꞌe yoꞌoye aꞌë, ja̱ cato. ");
INSERT INTO seyNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Cuasajëna, Jesús i̱ joyopi i̱ohuaꞌi cuasaseꞌe asani caëña: “¿Me neñuꞌju ja̱je cuasayeꞌni, mësaru? ");
INSERT INTO seyNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","I̱que aꞌni, ju̱ꞌiquëre ai deꞌoye caꞌñe paꞌye: ‘Mëꞌë coꞌaye yoꞌoseꞌe sa̱i deꞌhuacaiseꞌe aꞌë.’ Pa̱nitaꞌa caye, ‘Huëni mëꞌë ca̱i saihuë i̱ni saijë̱ꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ja̱je paꞌito mësarute i̱ñosiꞌi, yëꞌë Pa̱i Mamaquë iye yeja paꞌi pa̱i coꞌaye yoꞌoseꞌere sa̱i deꞌhua tutu paquë paꞌiyere.” Ja̱je cani ju̱ꞌiquëre caëña: ");
INSERT INTO seyNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Mëꞌëni cayë, huëijë̱ꞌë. Më ca̱icore i̱ni hueꞌequë më huëꞌena saijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ja̱re caëna, ju̱ꞌiquëpi i̱ ca̱i sëohuë i̱ni hueꞌequë saquëña. Saquëna, ñani Maijaꞌquë ai deꞌoji cajë sihuareña, mai ña maꞌñere ñañë, cajë. ");
INSERT INTO seyNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesupi sani co̱uña, jaira të̱ꞌtëpana. Sani co̱una, siꞌa pa̱i i̱ quëꞌrona tsiꞌsirena, yeꞌyaëña. ");
INSERT INTO seyNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Yeꞌya tëjini jerepa saina, Leví, Alfeo mamaquëpi paꞌi doꞌi sa̱i huëꞌere ñuꞌina, Jesupi ñani caëña: “Yëꞌë ja̱ꞌre daijë̱ꞌë.” Caëna, asani i̱ ja̱ꞌre saquëña. ");
INSERT INTO seyNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jesupi Leví huëꞌena sani ñuꞌi a̱ina, jai pa̱i paꞌi doꞌi se̱cohuaꞌi cuiꞌne yecohuaꞌi coꞌaye yoꞌocohuaꞌi cuiꞌne i̱ yeꞌyacohuaꞌi co̱ni teꞌe ñuꞌijë a̱teña. ");
INSERT INTO seyNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jesupi ja̱je ja̱ohuaꞌi ja̱ꞌre co̱ni ñuꞌi a̱ina, ñaquë ñani cua̱ñeseꞌe yeꞌyacohuaꞌipi cuiꞌne fariseohuaꞌipi i̱ yeꞌyacohuaꞌire se̱teña: “¿Me neni mësarute yeꞌyaquë paꞌi doꞌi se̱cohuaꞌi ja̱ꞌre co̱ni cuiꞌne coꞌacohuaꞌi ja̱ꞌre co̱ni u̱cuquë cuiꞌne a̱iquëꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Se̱jëna, Jesupi asani sehuouña, ja̱ohuaꞌire: “Huajëcohuaꞌi cuiꞌne deꞌoye paꞌicohuaꞌi jujuquëre coꞌemaꞌcohuaꞌi aꞌë. Ju̱ꞌicohuaꞌipi coꞌecohuaꞌi aꞌë. Yëꞌë cato deꞌocohuaꞌini soisiꞌi caquë daiye pa̱huë. Coꞌacohuaꞌini caquë daisiquë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Fariseo pa̱i yeꞌyacohuaꞌipi cuiꞌne Juanre yeꞌyacohuaꞌipi a̱imaꞌpë Maijaꞌquëre se̱jëna, yecohuaꞌipi ñani Jesús quëꞌrona dani se̱teña: “¿Me yoꞌojë më yeꞌyacohuaꞌi a̱imaꞌpë se̱ñe pa̱ñeꞌni, Juan yeꞌyacohuaꞌi cuiꞌne fariseo pa̱i yeꞌyacohuaꞌiseꞌe a̱imaꞌpë se̱jëna?” ");
INSERT INTO seyNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Se̱jëna, Jesupi sehuouña: “¿Hueja a̱o a̱ijaꞌcohuaꞌire soisicohuaꞌi je̱ꞌquë a̱imaꞌcohuaꞌini i̱ti hueja po̱sëpi i̱ohuaꞌi ja̱ꞌre co̱ni paꞌito? I̱pi paꞌito a̱iñe paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ja̱je paꞌiquëtaꞌare hueja po̱sëje̱ paꞌini yequë muꞌse sio cua̱ñoni ja̱ macataꞌa a̱imaꞌpë se̱jaꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ai juꞌi ca̱re huajë ca̱pi jaomaꞌcohuaꞌi aꞌë. Ja̱je yoꞌosicohuaꞌi paꞌito jo̱jajëna, huajë ca̱pi quërësi̱o ai juꞌi ca̱re jerepa jai coje neñe paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Cuiꞌne huajë cuiyaꞌi co̱nore ai ca̱ꞌni topëna ayamaꞌcohuaꞌi aꞌë. Ayasicohuaꞌi paꞌito huajë cuiyaꞌi co̱nopi oꞌsaquë qui̱ꞌco joiye paꞌiji. Ja̱ maca yuretaꞌa siꞌaye nejoñe paꞌiji, co̱no cuiꞌne topëje̱ co̱ni. Ja̱ doꞌire huajë cuiyaꞌi co̱no ja̱ꞌre huajë ca̱ꞌni topëna ayaye paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Teꞌe muꞌse Jesús huajë muꞌse paꞌina, trigo tsioja̱ꞌa saina, i̱ yeꞌyacohuaꞌipi sa tëto saijë tëahuë. ");
INSERT INTO seyNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tëajëna, ñani fariseo pa̱ipi careña, Jesure: “Ñajëꞌë, ja̱ohuaꞌi yoꞌoyere huajë muꞌse yoꞌoye peoji, huajëye paꞌi muꞌsere.” ");
INSERT INTO seyNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Cajëna, i̱pi i̱ohuaꞌire caëña: “¿Maijaꞌquë toyapë mësaru ñamaꞌcohuaꞌi aꞌni? Toyaseꞌe cato caji: Abiatar Maijaꞌquë huëꞌere ñacaicohuaꞌi ëjaërepa paꞌi maca, Davidpi cuiꞌne i̱ co̱cohuaꞌipi a̱iñe peoquëna, a̱i ëa ju̱ꞌijë. ");
INSERT INTO seyNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","David cuiꞌne i̱ co̱cohuaꞌi co̱ni cacani a̱ore Maijaꞌquë ña hue̱ꞌñana tëoseꞌere a̱ëꞌë. Iye a̱o cato Maijaꞌquë huëꞌe ñacaicohuaꞌiseꞌe a̱i ja̱ꞌñe paꞌiji. Yecohuaꞌire ë̱seseꞌe pajiꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Cuiꞌne ja̱ohuaꞌire Jesupi caëña: “Pa̱ini caquë Maijaꞌquë huajë muꞌse nepi. Pa̱ni pa̱ipi huajë muꞌse doꞌire ai yoꞌoja̱jë caquë neñe. ");
INSERT INTO seyNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yëꞌë Pa̱i Mamaquë cato huajë muꞌse ëjaëpi yoꞌoyë.” ");
INSERT INTO seyNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Pa̱i tsiꞌsi huëꞌena Jesupi ti̱jupë cacapi. Cacaëna, ja̱rote jë̱të sëyë huesësiquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Paꞌina, huajë muꞌsere Jesupi jujuquëna, ñañuꞌu cuasajë camaꞌpë ñahuë, jujuquëna, sa̱ñope i̱te cañuꞌu cajë. ");
INSERT INTO seyNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ja̱ maca Jesús jë̱të sëyësiquëre ñani caëña: “Huëni nëcani iye maca jopore pana dani nëcajë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ja̱je se cani yecohuaꞌire se̱jiꞌi: “¿Huajë muꞌse i̱que yoꞌoyepi deꞌoquëꞌni? ¿Deꞌoye, pa̱nitaꞌa coꞌayere yoꞌoye, pa̱ire huasoye, pa̱nitaꞌa pa̱ire huani je̱oñe?” Ja̱je caquëna, ti sehuoye pa̱reña. ");
INSERT INTO seyNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ja̱je Jesús se̱ni jujani pë̱i i̱ohuaꞌire ñapi, i̱ cayere asaye coejëna, ñani. Ja̱je oi ña jujani ju̱ꞌiquëre capi: “Mëꞌë jë̱tëre pi̱ꞌnajëꞌë.” Caquëna, pi̱ꞌnapi. Pi̱ꞌnaquëna, i̱ jë̱tëpi tsoe deꞌoco pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ja̱re ñani fariseo pa̱i etasicohuaꞌipi Jesure huani je̱o ja̱ꞌñere ca deꞌhuajë paëꞌë, Herodes pa̱i ja̱ꞌre co̱ni. ");
INSERT INTO seyNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesupi i̱ yeꞌyacohuaꞌi ja̱ꞌre co̱ni sajiꞌi. Saina, jai pa̱i tuteña, Galilea pa̱ipi. ");
INSERT INTO seyNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jaiye yoꞌoquëna, asa ti̱ꞌani Judea, Jerusalén, Idumea, Jordán je te̱ꞌte quëꞌro acohuaꞌi, Tiro yeja acohuaꞌi, cuiꞌne Sidón yeja acohuaꞌi i̱ quëꞌrona ñañuꞌu cajë dateña. ");
INSERT INTO seyNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ja̱je paꞌina, Jesupi i̱ yeꞌyacohuaꞌire caëña. Yohuë jaꞌyena dajë̱ꞌë, pa̱ipi quiꞌimaꞌcohuaꞌini. ");
INSERT INTO seyNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Iye cato capi jai pa̱ire jujuquëna, ñani ju̱ꞌicohuaꞌipi i̱ni patoni coꞌyañuꞌu cajë yoꞌojëna. ");
INSERT INTO seyNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Cuiꞌne huatiohuaꞌipi i̱ni ñani doꞌre jaꞌrujë cuijë cahuë: “Mëꞌë cato Maijaꞌquë mamaquë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ja̱je cajëna, Jesús ai ë̱sepi camaꞌpë caquë. Ja̱ë api, quëaye coepi. ");
INSERT INTO seyNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ja̱ jeteyoꞌje ai cu̱tihuëna tu̱mani ja̱rona i̱ yë sahua nëosicohuaꞌire soina, dateña. ");
INSERT INTO seyNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Datena, soipi, siꞌa jëña cayañoa paꞌiohuaꞌire tsiꞌsoni sahua nëosicohuaꞌire yëꞌë ja̱ꞌre paꞌija̱jë caquë ja̱ohuaꞌire mësarute jëjo saosiꞌi yëꞌë coca quëaja̱ꞌcohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Cuiꞌne ju̱ꞌicohuaꞌire juju tutu cuiꞌne huatiohuaꞌire eto sao tutu i̱siña. ");
INSERT INTO seyNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Icohuaꞌi aꞌë, doce i̱ soisicohuaꞌi: Simón ja̱re i̱ni Pedrore hueꞌyopi. ");
INSERT INTO seyNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo cuiꞌne i̱ yoꞌjei Juan, Zebedeo mamajë paëꞌë, cuiꞌne ja̱ohuaꞌini hueꞌyopi Boanerges ja̱je cani cayë mujuë mamajë. ");
INSERT INTO seyNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felipe, Bartolomé, Mateo, Tomás, Jacobo cato Alfeo mamaquë Tadeo, Simón pajiꞌi. Ja̱ë cato judío pa̱i deꞌoye paꞌiyere caquë yoꞌo tsëcapë aquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Cuiꞌne Judas Iscariote pajiꞌi, Jesure cosoquë yehuoja̱ꞌquëje̱. ");
INSERT INTO seyNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ja̱je quëa tëjini i̱ yeꞌyacohuaꞌi ja̱ꞌre huëꞌena cacaëña. Cacaëna, ti̱jupë pa̱ipi tsiꞌsi dateña. Tsiꞌsi huesëjëna, ai yoꞌoye paꞌina, ai yoꞌojë a̱iñeque pa̱reña. ");
INSERT INTO seyNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ja̱je paꞌina, i̱ cajeohuaꞌipi asani Jesure quërëja̱ñuꞌu cajë dateña, coa cuepei neni yoꞌoji, caye paꞌina. ");
INSERT INTO seyNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Cua̱ñeseꞌe yeꞌyacohuaꞌipi Jerusalénpi daisicohuaꞌipi careña: “Huati ëjaë Beelzebúre hueꞌequëpi yoꞌoji. Ja̱je paꞌina, ja̱ë tutupi coꞌa joñoare eto saoquë yoꞌoji.” ");
INSERT INTO seyNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ja̱je cajëna, ja̱ maca Jesupi soiña, ti̱ña asaja̱jë caquë quëapi, pa̱i yoꞌoyeje̱ paꞌye ñeje caquë: “¿Huati ëjaë pani me i̱jaꞌa coꞌye eto saoquëꞌni? ");
INSERT INTO seyNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Pa̱ipi yeja ëjaëpi huasiquë pani, yecohuaꞌipi i̱ni sa̱ñope yoꞌojëna, uihuaquë coa caraja̱iñe paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Cuiꞌne teꞌe huëꞌe acohuaꞌipi uihuajë huasicohuaꞌi pani coa sa̱ꞌñe yoꞌojë caraja̱iñe paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ja̱je huatipi i̱jaꞌa sa̱ꞌñe uihuaquë pani quëcoye peoji. Ja̱je yoꞌoquë pani tsoe caraja̱isiꞌquë yoꞌoye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ai tutu quëꞌi huëꞌe paꞌito cacaye peoji, i̱ coꞌamaña sioñuꞌu cajë. I̱ni duꞌru hue̱nitaꞌa i̱ coꞌamaña jioye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nuñerepa cayë, mësarute: siꞌaye pa̱i coꞌaye yoꞌoseꞌe sa̱i deꞌhuacaiye paꞌiji. Cuiꞌne Maijaꞌquëre coꞌa coca cayeje̱ sa̱i deꞌhuacaiye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ja̱je paꞌiquëtaꞌare Maijaꞌquë joyore sa̱ñope coꞌa coca casiquëre cato sa̱i deꞌhuacaiye ti peosipi. Siꞌanë doꞌi pasipi.” ");
INSERT INTO seyNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Huatire hueꞌequë api casi doꞌire, ja̱je Jesús quëaëña. ");
INSERT INTO seyNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesús pëca jaꞌco cuiꞌne i̱ yoꞌje tsi̱ co̱ni dani hueꞌsere paꞌijë Jesure quëacaija̱ꞌquëre jëjo saoreña, daija̱quë cajë. ");
INSERT INTO seyNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ja̱re asani Jesús quëꞌro jai pa̱i ñuꞌijë asacohuaꞌipi Jesure careña: “Mëꞌë jaꞌco cuiꞌne më yoꞌje tsi̱ mëꞌëni soiyë, hueꞌsepi.” ");
INSERT INTO seyNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Cajëna, sehuouña: “¿Ne aꞌni, yëꞌë jaꞌco, cuiꞌne yëꞌë yoꞌje tsi̱?” ");
INSERT INTO seyNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ja̱je cani i̱ quëꞌro ducohuaꞌire se̱ña tëjija̱ni caëña: “I̱ñore paꞌiyë, jaꞌcoje̱ paꞌiohuaꞌi cuiꞌne yëꞌë yoꞌje tsi̱je paꞌiohuaꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Siꞌaye Maijaꞌquë yëyete yoꞌocohuaꞌipi yëꞌë yoꞌjei cuiꞌne yëꞌë yoꞌjeo cuiꞌne yëꞌë jaꞌcohuaꞌi paꞌiyë.” ");
INSERT INTO seyNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ti̱jupë Jesús jaira të̱ꞌtëpapi yeꞌya huëouna, jai pa̱i i̱ quëꞌrona tsiꞌsi dateña. Jai pa̱irepa tsiꞌsi daijëna, Jesús ña jujani i̱ti maca jaira huahua yona aya mëni jaꞌruña, pa̱iseꞌe mejahuëre paꞌijëna. ");
INSERT INTO seyNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ja̱ maca yuretaꞌa jaiye yeꞌyaëña, pa̱i yoꞌoyeje̱ paꞌye ñeje caquë. ");
INSERT INTO seyNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Asajë̱ꞌë, iyere, ta̱quë sani ta̱seꞌere. ");
INSERT INTO seyNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ja̱je sani ta̱quëna, yequë ca̱pi maꞌana to̱mepi. To̱meina, pi̱ꞌapi dani peo hue̱ꞌña o̱cue saopi. ");
INSERT INTO seyNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Yequë ca̱pi quë̱na yejana to̱meo. To̱meni esa mëapi, pe̱a yeja doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ja̱je mëacotaꞌare ë̱sëpi ëo hue̱api, tsita memaꞌconi. ");
INSERT INTO seyNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Yequepi to̱mepi, miu pi̱si quëꞌrona. Ja̱je paꞌina, miu pi̱sipi teꞌe ai deꞌoni hue̱ hue̱api. Ja̱je yoꞌoni quë̱imaꞌo pacoꞌë, ta̱seꞌe. ");
INSERT INTO seyNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Yequë ca̱pi deꞌo yejana to̱mepi. To̱meni mëani jaiye deꞌoye quë̱jiꞌi. I̱ti ca̱ yequë ñëapi quë̱jiꞌi, treinta ca̱, yequepi sesenta ca̱ cuiꞌne yequepi cien ca̱ quë̱jiꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Casi jeteyoꞌje caëña, ja̱ohuaꞌire: “Ca̱joro hueꞌecohuaꞌi pani, asajë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Quëa tëjisi jeteyoꞌje Jesús teꞌi pëaëña. Pëaëna, ñani i̱ quë̱no maca i̱ yeꞌyacohuaꞌi ja̱ꞌre co̱ni paꞌicohuaꞌipi se̱teña: ¿I̱ohuaꞌi ñañena co̱ni i̱que yoꞌoyere quëaëꞌni, ja̱je? ");
INSERT INTO seyNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Cajëna, i̱pi sehuouña. Se̱jëna, Jesupi caëña: “Mësarute Maijaꞌquëpi ta̱ꞌñe asaye i̱sipi, yahueseꞌere maꞌtëmo te̱ꞌte ayere. Ja̱je paꞌiquëtaꞌare ja̱ro ti̱ro paꞌicohuaꞌire cato i̱ohuaꞌi ñañe ayepi co̱ni caquë quëaye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ja̱ohuaꞌipi ñajëtaꞌa ñañe pa̱jajë caquë. Cuiꞌne asajëtaꞌa ti ja̱re caji cuasamaꞌcohuaꞌipi paꞌija̱jë caquë, cuiꞌne asani po̱nëmaꞌpëna i̱ohuaꞌi coꞌaye yoꞌoseꞌe sa̱i deꞌhuacaiye peoja̱quë caquë quëayë.” ");
INSERT INTO seyNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Caëña, yequeje̱: “¿Mësaru iye quëaseꞌe asa ti̱ꞌañe pa̱ñe? ¿Ja̱je pani me yeque cuiꞌne paꞌye quëato asa ti̱ꞌajaꞌcohuaꞌi aꞌni? ");
INSERT INTO seyNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Maijaꞌquë coca quëaquë api, i̱ti ca̱ ta̱ñeje paꞌi. Maijaꞌquë cocaꞌë, i̱ti ca̱. ");
INSERT INTO seyNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Maꞌana i̱ti to̱meseꞌeje̱ paꞌiohuaꞌi paꞌiyë, yecohuaꞌi. Ja̱je paꞌiohuaꞌipi Maijaꞌquë coca asayë. Asarena, huatipi dani, peo hue̱ꞌña i̱ohuaꞌi asaseꞌere nejoñere quëaji. ");
INSERT INTO seyNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Quë̱na yejana ta̱seꞌeje̱ paꞌiohuaꞌi aꞌë, yecohuaꞌi. Ja̱je paꞌiohuaꞌipi ai yëjë asani sihuajë deꞌhuayë, Maijaꞌquë coca. ");
INSERT INTO seyNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ja̱je asasicohuaꞌitaꞌa quëcomaꞌpë ai yoꞌoyepi paꞌina, pa̱nitaꞌa deꞌo coca doꞌire pa̱ipi sa̱ñope yoꞌojëna, yoꞌo jujani je̱oñere quëaji. ");
INSERT INTO seyNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Yecohuaꞌipi miu pi̱si quëꞌrona ta̱ëna mëañeje paꞌiohuaꞌipi deꞌo coca asayë. ");
INSERT INTO seyNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Asasicohuaꞌitaꞌa iye yeja coꞌamañare ai cuasajë jaiye coꞌamaña pa ëayepi cosoquëna, coa siꞌa coꞌamaña yë huesëni yoꞌojë Maijaꞌquë cocare nejoñe aꞌë. Ja̱je yoꞌocohuaꞌi quë̱iñeje paꞌye deꞌoye paꞌiyere i̱ño ti̱ꞌañe peoji. ");
INSERT INTO seyNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Yecohuaꞌipi deꞌo coca asani ti deꞌhuacohuaꞌi paꞌiyë. Ja̱ohuaꞌipi jaiye quë̱iñeje paꞌiohuaꞌi paꞌiyë, deꞌo yejaje̱ paꞌiohuaꞌi. Yecohuaꞌipi treinta ca̱ quë̱iseꞌeje̱ paꞌiohuaꞌi paꞌiyë. Yecohuaꞌipi sesenta ca̱ quë̱iseꞌeje̱ paꞌiohuaꞌi paꞌiyë. Cuiꞌne yecohuaꞌipi cien ca̱ quë̱iseꞌeje̱ paꞌiohuaꞌi paꞌiyë.” ");
INSERT INTO seyNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Caëña, cuiꞌne: “¿Toa tsë̱o përe dani mahuë huëꞌehuëna nëcocohuaꞌi aꞌni pa̱nitaꞌa ca̱i saihuë huëꞌehuëna nëcocohuaꞌi aꞌni? Pa̱ni, toa tsë̱o pë cato siꞌa hue̱ꞌña miajaꞌconi ti̱ñare pana nëcoye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yahueseꞌe paꞌiseꞌepi siꞌaye ti̱ꞌa ja̱ꞌñeseꞌe aꞌë cuiꞌne pa̱i ñamaꞌpë paꞌija̱jë cajë yoꞌoseꞌere siꞌaohuaꞌi, asaseꞌe paꞌija̱ꞌcoa. ");
INSERT INTO seyNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mësarupi ca̱joro hueꞌecohuaꞌi sëte asa ti̱ꞌajëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Caëna, cuiꞌne: “Deꞌhua mësaru asaseꞌere yoꞌojë̱ꞌë. Mësaru yecohuaꞌire cue̱cueni i̱siyeje̱ paꞌye mësaruteje̱ Diusupi cue̱cueni i̱sija̱ꞌquë api. Mësaruni jerepa i̱sija̱ꞌquë api, i̱ti asacohuaꞌini. ");
INSERT INTO seyNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ja̱je paꞌina, paquëni jerepa i̱siye paꞌiji. Cuiꞌne peoquëni jerepa aꞌri maña i̱ payeque jioye paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesupi capi, cuiꞌne: “Maijaꞌquë cua̱ñe te̱ꞌte cato yejana i̱ti ca̱re ta̱ëna, i̱oseꞌe mëañeje paꞌye aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ja̱je paꞌina, ta̱ tëjisi jeteyoꞌje sani i̱ti ta̱siquë ca̱iji. Ca̱ni tëjini naꞌiquëna, huëiji. Ja̱je cuiꞌne muꞌseña cuiꞌne ñamije tëto saiji. Yoꞌoquëna, ta̱si ca̱ cato tsatani mëa huëoji. Ja̱je yoꞌoquëna, i̱ti ta̱siquë cato huesëquë paꞌiji, i̱o yoꞌoye. ");
INSERT INTO seyNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Yejaseꞌe ai deꞌoye necaina, mëaji. Duꞌru macarepa i̱ti ñë macapi mëaji. Jeteyoꞌje i̱ti tsa̱ꞌña neji. Jeteyoꞌje i̱ti ca̱ yuretaꞌa neji, i̱ti tsa̱ꞌñana ti̱më ja̱ꞌñe. ");
INSERT INTO seyNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","I̱ti ca̱ yaꞌji tëjisi maca i̱ti ca̱ tëasiꞌi caquë etaquë api. Ja̱je yoꞌoyeje̱ paꞌye aꞌë, Maijaꞌquë te̱ꞌte aye.” ");
INSERT INTO seyNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yequeje̱ caëña, Jesús: “¿I̱queje̱ paꞌye aꞌni, Maijaꞌquë te̱ꞌte aye, pa̱nitaꞌa i̱quena co̱ni caquë quëaraꞌye i̱ohuaꞌi asa ja̱ꞌñe? ");
INSERT INTO seyNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mostaza ca̱re yejana ta̱ñeje paꞌye aꞌë. Ja̱ ca̱ cato siꞌa so̱quë ca̱ maña se̱ña maca ai aꞌri ca̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ja̱je paꞌiquëtaꞌare ta̱sicopi ai deꞌosico pani siꞌa so̱quë ñëa maña jerepa jaico ai deꞌocoa. Ja̱je paꞌiopi jai so̱quë capë̱a paꞌiona, pi̱ꞌaje i̱ona daijë pëa huajëjë paꞌicohuaꞌi aꞌë, jaꞌo huëꞌehuëna.” ");
INSERT INTO seyNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ja̱je Jesús yeꞌyapi, Maijaꞌquë coca. Jaiye i̱ohuaꞌi ñañe ayepi caquë i̱ohuaꞌi a̱ꞌjiñe asa ti̱ꞌañeque quëapi. ");
INSERT INTO seyNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","I̱ohuaꞌi ñañe ayepi caquë siꞌanë quëaëña. Coa peoye quëaye pa̱ëña. Ja̱je paꞌiquëtaꞌare i̱ yeꞌyacohuaꞌiseꞌere siꞌaye i̱ quëaseꞌere ja̱re cayë caquë nuñerepa quëaëña, teꞌohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","I̱ti muꞌse naꞌiquëna, i̱re yeꞌyecohuaꞌire caëña: “Je tëꞌhuina je̱ñuꞌu.” ");
INSERT INTO seyNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Caëna, ja̱ maca Jesús yohuëre paꞌina, pa̱ire je̱oni sateña, Jesús ja̱ꞌre. Saijëna, cuiꞌne yequë yohuëja̱ꞌa co̱ni sateña. ");
INSERT INTO seyNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Saijëna, ai tutu huëouña. Jairapi ai to̱ꞌaquë yohuëna ocopi ti̱mëoña. ");
INSERT INTO seyNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ti̱mëquëna, Jesutaꞌa sëtipë quëꞌrore coa u̱i ca̱quëña, i̱ si̱opë tëo pacona tëo paquë. Ca̱ina, ja̱ohuaꞌipi dani sëtoni careña: “Yeꞌyaquë, mai ne huesëyë.” ");
INSERT INTO seyNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Cajëna, huëni tuture cua̱ñeiña. Cuiꞌne jairare caëña. “Yoꞌomaꞌo paꞌijë̱ꞌë.” Caquëna, tutupi joꞌcua je̱o nëquëña. Cuiꞌne jairaje̱ tsi̱ña deꞌhuaje̱ paꞌio deꞌoña. ");
INSERT INTO seyNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ja̱ maca ja̱ohuaꞌire caëña: “¿Me yoꞌojë caꞌrayeꞌni? ¿Maijaꞌquëpi ñacaiji, cuasa maꞌñe?” ");
INSERT INTO seyNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Caquëna, i̱re yeꞌyecohuaꞌipi ña quëquëni careña: “¿I̱queire papi, iquë ja̱ jerepa tuture cuiꞌne jairate cua̱ñequëꞌni, cuiꞌne sehuoco?” ");
INSERT INTO seyNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jaira je tëꞌhuina ti̱ꞌareña, Gadara quëꞌrona. ");
INSERT INTO seyNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yohuëpi Jesús ja̱ꞌa tu̱maquëna, ju̱ꞌisicohuaꞌire ta̱ hue̱ꞌñapi teꞌi ë̱më huati quëꞌipi sa̱ñope daquëña. ");
INSERT INTO seyNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Huati quëꞌi cato, ju̱ꞌicohuaꞌire ta̱ hue̱ꞌñare paꞌiquë paquëña, quë̱na meapi hue̱ñuꞌu cajëtaꞌa hue̱ñe peoquëpi. ");
INSERT INTO seyNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Jë̱ña nëcañoa co̱ni jaiye hue̱toje̱ i̱pi naë tëte je̱aëña. I̱ jerepa tutu neñe peouña. ");
INSERT INTO seyNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ñami, muꞌse ju̱ꞌisicohuaꞌire ta̱ hue̱ꞌñare ai cu̱tihuëre paꞌi cuiquë quë̱na pë̱api coꞌye huai yoꞌoquë paquëña. ");
INSERT INTO seyNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Soꞌopi Jesure ñani huëꞌhuëni Jesús nëca macana ti̱ꞌani Jesús mëꞌëpi jerepa tutu paquë cani doꞌre jaꞌruña. ");
INSERT INTO seyNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Doꞌre jaꞌruna Jesupi caëña, huatire: “Iye ë̱mëre etajë̱ꞌë.” Caquëna, ai tutu caquë se̱quëña: “Jesús, Diusu ti ëjaërepa mamaquë ai yoꞌoyete yëꞌëre i̱simaꞌë paꞌijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Se̱ina, Jesupi ja̱ëte caëña: “¿I̱que mami aꞌni?” Caquëna, sehuouña: “Yëꞌë mami cato jai pa̱i aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Cani Jesure ai se̱quëña: “Iye huatiohuaꞌire yequë hue̱ꞌñana jëjo saomaꞌë, i̱ñore paꞌija̱jë.” ");
INSERT INTO seyNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Caquëna, jaꞌyere jai se̱se dohuë cu̱ti perepëre a̱ijë paꞌijëna, ");
INSERT INTO seyNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Huatiohuaꞌipi asani se̱teña: “Se̱se quëꞌrona jëjo saojë̱ꞌë. Yëquëre ja̱ohuaꞌina cacañuꞌu.” ");
INSERT INTO seyNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Careña, deꞌoji saijë̱ꞌë caëna, etani sani se̱sena cacareña. Cacarena, siꞌa dos mil se̱se huëꞌhuëjë jai huaꞌque të̱ꞌtëpapi to̱mejë jairana dutu ju̱teña. ");
INSERT INTO seyNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ju̱tena, se̱sere ñacaicohuaꞌipi ñani huëꞌhuëni pa̱i daripëna siꞌaye quëareña, i̱ti yoꞌoseꞌe. Quëarena, pa̱ipi asani dateña. ");
INSERT INTO seyNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesús paꞌi hue̱ꞌñana ti̱ꞌani ñajëna, huati quëꞌi paꞌisiquëpi ca̱ña su̱ñasiquëpi deꞌo cocare caquë ñuquëña. Ñuꞌina, i̱te ñani siꞌaohuaꞌi caꞌrareña. ");
INSERT INTO seyNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Caꞌrajëna, se̱se ñacaicohuaꞌipi Jesús yoꞌoseꞌere quëareña, huati quëꞌire yoꞌoseꞌe cuiꞌne se̱sere yoꞌoseꞌe co̱ni. ");
INSERT INTO seyNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ja̱je quëajëna, asani Jesure saijë̱ꞌë, i̱ño paꞌimaꞌë cajë, se̱ huëoreña. ");
INSERT INTO seyNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Carena, Jesupi yohuëna aya mëni sai huëoquëna, huati quëꞌi paꞌisiquëpi ai se̱quëña, Jesure mëꞌë ja̱ꞌre co̱ni sani pasiꞌi caquë. ");
INSERT INTO seyNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Caquëna, Jesupi pa̱ni sehuouña: “Mëꞌë huëꞌena saijë̱ꞌë. Sani mëꞌë cajeohuaꞌire quëajë̱ꞌë, mëꞌë ëjaëpi oi ñani necaiseꞌere.” ");
INSERT INTO seyNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Caëna, saquëña. Sani siꞌa jë̱ña daripë̱a quëa huëouña. I̱re Jesús necaiseꞌere quëaquëna, asani ai deꞌoye yoꞌoseꞌe paꞌiji, careña. ");
INSERT INTO seyNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesupi yohuëja̱ꞌa cuiꞌnaëpi yequë te̱ꞌtena je̱ꞌesi maca jai pa̱i tsiꞌsi dateña. Ja̱je yoꞌojëna, jaira të̱ꞌtëpare paꞌina. ");
INSERT INTO seyNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ja̱ maca pa̱i tsiꞌsi hue̱ꞌña cua̱ñequëpi Jesús paꞌi hue̱ꞌñana Jairo hueꞌequëpi i̱te ñani doꞌre jaꞌruni, ");
INSERT INTO seyNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","caëña: “Yëꞌë mamacopi ju̱ni huesëco. Sani mëꞌë jë̱tëpi pato coꞌyacaijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Se̱ina, Jesupi i̱ ja̱ꞌre co̱ni saquëña. Saina, jai pa̱i cuiꞌne sateña. Ja̱je paꞌijë i̱te quiꞌi huesoreña. ");
INSERT INTO seyNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ja̱je jai pa̱i paꞌi hue̱ꞌñare teꞌo nomio doce o̱metëca ju̱ꞌico pacoña. Siꞌanë tsie cajequëna, ai yoꞌoco pacoña. ");
INSERT INTO seyNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","I̱ote siꞌa jujucohuaꞌi yoꞌo jujajëna, ai yoꞌoco paꞌico pacoña. Siꞌaye i̱o paye juju doꞌina sa̱i saosico pacoña. Siꞌaye ja̱ co̱ñe pa̱ëña, i̱ote. Coa ai jerepa ai yoꞌoco pacoña, coꞌyaye peoyerepa. ");
INSERT INTO seyNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ja̱je paꞌiopi Jesús cayere cajëna, asani dani jeteyoꞌjeja̱ꞌa i̱ juꞌi ca̱na patoña. ");
INSERT INTO seyNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Coa i̱ juꞌi ca̱na patoni coꞌyasico paꞌija̱ꞌcoaꞌë, caco. ");
INSERT INTO seyNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Pato macarepa tsie cajeye je̱ouña. Ja̱ maca asaoña, tsoe i̱o ca̱pë coꞌyasico paꞌiye. ");
INSERT INTO seyNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ja̱je yoꞌosi maca Jesupi asaëña, i̱ tutupi ju̱ꞌicore jujuseꞌe. Ja̱je paꞌina, coꞌye po̱nëni pa̱ire ñani caëña: “¿Nepi yëꞌë juꞌi ca̱na patoreꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Caquëna, i̱ yeꞌyacohuaꞌipi careña: “Tsoe mëꞌëpi pa̱i quiꞌiyerepa paꞌiye ñaquëtaꞌa, ¿nepi patoreꞌni se̱quëꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ja̱je catoje̱ Jesús cato siꞌa hue̱ꞌña po̱nëquë ñaëña, nepi patoreꞌni caquë. ");
INSERT INTO seyNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ñaquëna, ti coꞌyasicopi asani caꞌraco tsasico dani i̱ nëca hue̱ꞌñana ta̱ni i̱o yoꞌoseꞌe nuñerepa quëaoña. ");
INSERT INTO seyNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Quëacona, Jesús ja̱ore caëña: “Huau maca yëꞌëre cuasaseꞌepi ne coꞌyahuë. Se̱ñaco saijë̱ꞌë. Iye ju̱ꞌiñe ti ne coꞌyahuë, mëꞌëre.” ");
INSERT INTO seyNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ja̱ caquëna, yecohuaꞌipi dateña, pa̱i tsiꞌsi huëꞌe cua̱ñequë huëꞌepi. Dani Jairore careña: “Mëꞌë mamaco tsoe ju̱ꞌisico pacoꞌë. Yeꞌyaquëre jerepa jo̱sa camaꞌë paꞌijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Caquëna, Jesupi asasiquëtaꞌa asa maꞌñeje paꞌipi tsiꞌsi huëꞌe cua̱ñequëre caëña: “Caꞌramaꞌpë paꞌijë̱ꞌë. Maijaꞌquëpi necaiquë api cuasajë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jesupi saina, Pedro co̱ni Jacobo co̱ni cuiꞌne Jacobo yoꞌjei Juan co̱ni sateña. Yecohuaꞌi co̱ni saiye ë̱seiña. ");
INSERT INTO seyNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tsiꞌsi huëꞌe cua̱ñequë huëꞌena ti̱ꞌani ai yoꞌoye ñaëña, pa̱ipi ai cuijë oijëna. ");
INSERT INTO seyNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ja̱je oijëna, huëꞌe cacani ja̱ohuaꞌire caëña: “¿Me neni mësaru ai yoꞌojë cajë cuiꞌne ai oiyeꞌni? I̱ mamaco ju̱ꞌimaꞌo pacoꞌë. Coa ca̱ico.” ");
INSERT INTO seyNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Caquëna, ja̱ohuaꞌipi i̱re soreña. Sojëna, Jesús siꞌaohuaꞌire hueꞌsena eto saouña. Coa pëca jaꞌquëpi cuiꞌne pëca jaꞌcopi co̱ni ju̱ꞌisico paꞌi hue̱ꞌñana cacareña. ");
INSERT INTO seyNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Cacani ju̱ꞌisico jë̱tëna tse̱ani i̱ote caëña: “Talita cumi.” Mai coca cato “tsihuaꞌo huëijë̱ꞌë” caye aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ja̱je ca macarepa doce o̱metëca pacopi tsihuaꞌo huëni cucoña. Ja̱je cuꞌiona, ñani deꞌoquëre papi yoꞌoji cuasareña. ");
INSERT INTO seyNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ja̱je jujusiquëtaꞌa ai ë̱seiña, yecohuaꞌire quëaye pa̱jëꞌë caquë. Tsihuaꞌore sani a̱ore a̱ojëꞌë, caëña. ");
INSERT INTO seyNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ja̱ropi etani i̱ quëꞌrona coꞌiña, i̱re yeꞌyecohuaꞌi ja̱ꞌre co̱ni. ");
INSERT INTO seyNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Huajë muꞌse ti̱ꞌasi maca pa̱i tsiꞌsi huëꞌena yeꞌya huëouña. Yeꞌyaquëna, i̱ pa̱ipi ai deꞌoyerepa yeꞌyaquëꞌni cuasareña. Ja̱je cuasajë careña: “¿Jerona iquë jerepa siꞌaye yeꞌyeiꞌni? ¿I̱querepa ta̱ꞌñe yeꞌyaye aꞌni, cuiꞌne nepi i̱te pa̱i yoꞌo ti̱ꞌa maꞌñe yoꞌo ja̱ꞌñe i̱sireꞌni? ");
INSERT INTO seyNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Iquë cato mai ñaquë api, María mamaquë api, huë̱ꞌña deꞌhuaquë api, Jacobo, José, Judas cuiꞌne Simón majaꞌyë api, cuiꞌne i̱ yoꞌjeohuaꞌije̱ mai ja̱ꞌre co̱ni paꞌiyë, i̱ñore.” Ja̱je cajë i̱ caye asaye coereña. ");
INSERT INTO seyNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ja̱je cajëna, Jesupi ja̱ohuaꞌire caëña: “Siꞌa hue̱ꞌña yecohuaꞌi cato Maijaꞌquëre quëacaiquëre yëcohuaꞌi aꞌë. Ja̱je paꞌiquëtaꞌare i̱ yeja acohuaꞌipi cuiꞌne i̱ cajeohuaꞌipi cuiꞌne i̱ huëꞌe acohuaꞌipi coeyë.” ");
INSERT INTO seyNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ja̱rona airepa pa̱i yoꞌo ti̱ꞌa maꞌñe yoꞌoye pa̱ëña, pa̱ipi i̱te asaye coe doꞌire. Ja̱je paꞌina, coa ju̱ꞌicohuaꞌi mañaseꞌere pato coꞌyaquë aꞌri pa̱i mañare jujuña. ");
INSERT INTO seyNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ja̱je paꞌina, nequë api cuasamaꞌpëna, ñani me yoꞌojë ja̱je paꞌiyeꞌni cuasaëña. Ja̱ jeteyoꞌje yeque huë̱ꞌñana sani cuꞌi yeꞌyaroja̱quëña. ");
INSERT INTO seyNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","I̱ yeꞌyacohuaꞌire doce paꞌiohuaꞌire soini, huatire eto saoja̱ꞌa tutu i̱sini cayaohuaꞌiseꞌere jëjo saouña. ");
INSERT INTO seyNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Jëjo saoquë cua̱ñeiña: “Samaꞌpë paꞌijë̱ꞌë, a̱o tupë, curiquëje̱. Coa topë macaseꞌe sajë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Cuiꞌne zapato cuiꞌne camisa sajë̱ꞌë, yeque su̱ña ja̱ꞌñe samaꞌpë.” ");
INSERT INTO seyNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Cuiꞌne caëña, ja̱ohuaꞌire: “Huëꞌena cacasicohuaꞌi pani i̱ti macana pëajë̱ꞌë, ja̱ daripë quëa tëjini sai macaja̱ꞌa. ");
INSERT INTO seyNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Cuiꞌne yequë hue̱ꞌñapi mësarute coecohuaꞌi paꞌito, pa̱nitaꞌa asaye coecohuaꞌi paꞌito mësaru quë̱o yaꞌo tsaꞌcuseꞌere ti̱ꞌto to̱ni eta saijë̱ꞌë. Ja̱je yoꞌojë i̱ñoñe paꞌiji, i̱ohuaꞌire sa̱ñope yoꞌoye. Nuñerepa cayë, pa̱i ñape yoꞌoseꞌe ña muꞌse ti̱ꞌaëna, ja̱ohuaꞌire ai coꞌayerepa sa̱iñe paꞌiji, mësarute ë̱sesicohuaꞌire. Sodoma cuiꞌne Gomorra yeja pa̱ire cato aꞌri jaꞌye sa̱iñe pajiꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ja̱je jëjo saosicohuaꞌipi huajëye paꞌiyena po̱nëñe paꞌiji cajë quëareña, pa̱ire. ");
INSERT INTO seyNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Cuiꞌne huatiohuaꞌireje̱ eto saoreña. Ju̱ꞌicohuaꞌire huiꞌyapepi nejëna, coꞌyareña, jai pa̱i. ");
INSERT INTO seyNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ja̱ maca romano pa̱i ëjaë Herodesje̱ asaëña, siꞌa pa̱i Jesús yoꞌoye asajëna. Ja̱je asani Herodespi caëña: “Juan oco doquëpi huëjiꞌi. Ja̱je paꞌina, tutu paquë yoꞌoji.” ");
INSERT INTO seyNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Yecohuaꞌipi careña: “Tsoe aquë Maijaꞌquëre quëacaiquë Elíaspi.” Cuiꞌne yecohuaꞌipi careña: “Tsoe hue̱ꞌña Maijaꞌquëre quëacaicohuaꞌi paꞌiseꞌeje̱ paꞌi api.” ");
INSERT INTO seyNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ja̱re Herodespi asani caëña: “Ja̱ë cato Juanpi yëꞌë cua̱ñeina, si̱opë tëto tëasiquë api. Ja̱ëpi ju̱ꞌisiquëpi huëni yoꞌoji.” ");
INSERT INTO seyNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herodes cato Juanre tse̱ani quë̱na meapi hue̱ni coꞌacohuaꞌire co hue̱ꞌñana coꞌa̱jiꞌi, Herodías doꞌire. Herodías cato yoꞌjei Felipe nëjo pacoꞌë. Ja̱je paꞌioni Herodespi yoꞌjei nëjore jioni i̱ nëjore nepi. ");
INSERT INTO seyNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ja̱je yoꞌoquëna, Juanpi caëña, Herodesre: “Mëꞌë yoꞌjei nëjoni jioni paye coꞌaji.” ");
INSERT INTO seyNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ja̱je caquëna, Herodíaspi Juanre ai coeco pacoña. Ja̱je paꞌina, huani je̱osiꞌi cacotaꞌa huani je̱oñe ti̱ꞌañe pa̱oña. ");
INSERT INTO seyNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodespi i̱te Juanre nuñerepa deꞌoquë api caquë caꞌraëña. Ja̱je paꞌina, i̱pi huani je̱oñe ë̱sequëna, pa̱oña. I̱ caye siꞌaye asamaꞌquëtaꞌa Herodes cato i̱ caye yë asaquë paquëña. ");
INSERT INTO seyNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ja̱je paꞌiquëtaꞌare Herodías ti̱ꞌaoña, i̱o huani je̱oñe oiseꞌe. Herodespi i̱te co̱asi muꞌse ti̱ꞌaëna, pa̱i ëjaohuaꞌire, soldado ëjaohuaꞌire, cuiꞌne Galilea ëjaohuaꞌire soini a̱o a̱i maca. ");
INSERT INTO seyNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodías mamacopi cacani deꞌoyerepa pairacona, ñani ai sihuareña, siꞌaohuaꞌi i̱ti ñacohuaꞌi. Ja̱je paꞌina, Herodes sihuaquë caëña, nomi tsi̱ore: “Mëꞌë yëyere se̱jëꞌë. I̱sisiꞌi, mëꞌëre.” ");
INSERT INTO seyNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Cuiꞌne caëña, care payë. Coa caye pa̱ñë. Siꞌa coꞌamaña mëꞌë se̱seꞌe i̱siye paꞌiji. Yëꞌë cua̱ñeñe jopore paja̱ꞌa i̱sinije i̱siyë, caëña. ");
INSERT INTO seyNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ja̱je caëna, asani sani pëca jaꞌcore se̱coña: “¿I̱quere se̱jaꞌcoaꞌni, i̱te?” Cacona, i̱opi caoña: “Se̱jëꞌë, Juan oco doquë si̱opëre.” ");
INSERT INTO seyNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ja̱je quëaona, asani pa̱i ëjaë paꞌi hue̱ꞌñana sani caoña: “Yurepi Juan oco doquë si̱opëre quë̱na deꞌhuana ayasiconi i̱sijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ja̱re pa̱i ëjaëpi asani ai coꞌa ju̱quëña. Ja̱je paꞌiquëtaꞌare tsoe ca huesosiquë sëte pa̱ñë caye peouña, cuiꞌne i̱ soisicohuaꞌije̱ asasi doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ja̱ doꞌire ja̱re i̱ti macapi teꞌe soldadore jëjo saouña, Juan si̱opë quërëja̱ijaꞌquëre. ");
INSERT INTO seyNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Caëna, soldadopi sani Juanre huani je̱oni si̱opë yëto tëani quë̱na deꞌhuana ayani dani i̱siña. I̱sina, Herodespi nomi tsi̱ona i̱sina, ja̱opi pëca jaꞌcore i̱sio. ");
INSERT INTO seyNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ja̱ yoꞌoseꞌere asani Juanre yeꞌyecohuaꞌipi dani Juan ca̱pë maca sani ta̱ je̱oreña. ");
INSERT INTO seyNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ja̱ jeteyoꞌje doce pa̱ire jëjo saosicohuaꞌipi coꞌini tsiꞌsini Jesure quëareña, i̱ohuaꞌi yoꞌoseꞌere, cuiꞌne i̱ohuaꞌi yeꞌyaseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Quëajëna, Jesupi caëña, ja̱ohuaꞌire: “Daijë̱ꞌë. Sani pa̱i peo hue̱ꞌñana pëa huajëñuꞌu.” A̲o a̱iñeque peoyerepa pa̱i tsiꞌsi ja̱ꞌñere asaquë capi. ");
INSERT INTO seyNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ja̱je caëna, saëꞌë, yohuëja̱ꞌa i̱ohuaꞌiseꞌe pa̱i peo hue̱ꞌñana. ");
INSERT INTO seyNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ja̱je saijëtaꞌare jai pa̱i ñareña, i̱ saiye. Ja̱je ñani Jesupi saiji cani huëꞌhuëjë, i̱ sai hue̱ꞌñana siꞌa daripë̱a paꞌicohuaꞌi sateña. Ja̱ ti̱ꞌamaꞌnë duꞌru ti̱ꞌareña, pa̱ipi. ");
INSERT INTO seyNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ja̱je yoꞌojëna, Jesupi yohuëpi tu̱mani pa̱i mañare teaye oi ñaëña, yëi ñama ñacaiquëre peocohuaꞌije̱ paꞌiohuaꞌi mañapi. Paꞌijë yoꞌojëna, ñani jaiye i̱ohuaꞌire yeꞌya huëouña. ");
INSERT INTO seyNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ai naꞌi huesëquëna, ñani i̱ yeꞌyacohuaꞌipi i̱te careña: “Tsoe naꞌiji, i̱ño pa̱i peo hue̱ꞌñaꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Jëjo saojë̱ꞌë, sani pa̱i paꞌi hue̱ꞌñana a̱o maña hueroni a̱ijajë. I̱ño cato peoyë, i̱ohuaꞌire a̱oñe.” ");
INSERT INTO seyNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Cajëna, Jesupi sehuouña i̱ohuaꞌire: “Mësarupi a̱ojëꞌë.” Caquëna, i̱ohuaꞌipi careña: “¿Ja̱je paꞌito yëquëpi sani veinte mil të̱ꞌña doꞌire papi pan hueroni a̱oñe?” ");
INSERT INTO seyNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Cajëna, Jesupi caëña: “¿Je so̱ pan payeꞌni, i̱ño? Sani ñajëꞌë.” Caquëna, careña: “Paꞌiji, cinco pan cuiꞌne caya tsiaya huaꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Cajëna, Jesupi cua̱ñeiña, pa̱ire. Ja̱je paꞌito siꞌaohuaꞌi tayahuëna jaꞌrujë̱ꞌë, caëña. ");
INSERT INTO seyNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Caëna, cien pa̱iseꞌe cuiꞌne cincuenta pa̱i deꞌo tsëcapë̱a jaꞌrureña. ");
INSERT INTO seyNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ja̱ maca Jesupi cinco pan cuiꞌne caya tsiaya huaꞌire i̱ni maꞌtëmona ñaquë deꞌoji caquë Maijaꞌquëre pëpani, panre i̱ yeꞌyacohuaꞌina i̱siña. I̱siquëna, ja̱ohuaꞌipi pa̱ire se i̱sicateña. ");
INSERT INTO seyNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ja̱ maca siꞌaohuaꞌi a̱ni sihuacohuaꞌi pateña. ");
INSERT INTO seyNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","A̲ni tëjisi jeteyoꞌje a̱ni jujaseꞌere tsiꞌsoreña, doce doꞌrohuë̱a huaꞌina co̱jë. ");
INSERT INTO seyNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ja̱ pan a̱isicohuaꞌi cato cinco mil ë̱mëohuaꞌi pateña. ");
INSERT INTO seyNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ja̱ jeteyoꞌje Jesús i̱ yeꞌyacohuaꞌire capi, duꞌru saijë̱ꞌë, yohuëja̱ꞌa Betsaidana. Yëꞌëseꞌe pa̱ire saiyë caquë pëpa tëjini sasiꞌi, caëña. ");
INSERT INTO seyNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Saiyë, caquë pëpa tëjini ai cu̱tihuëna Maijaꞌquëre casiꞌi caquë saquëña. ");
INSERT INTO seyNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ñami deꞌosi maca Jesús teꞌi yejare paꞌina, yohuë saisicohuaꞌi cato jaira jopore pateña. ");
INSERT INTO seyNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ja̱ropi paꞌi i̱ yeꞌyacohuaꞌi ai yoꞌojë co̱ꞌmejëna, ñaëña, tutupi sa̱ñope tutuquëna. Je̱ꞌnë ñata to̱me maca Jesupi oco daꞌca ë̱mëjeꞌejaꞌa nëcaquë saquëña, i̱ yeꞌyacohuaꞌi quëꞌrona. Coa sa tëto sasiꞌquë saiyeje̱ paꞌye saquëña. ");
INSERT INTO seyNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Oco daꞌca ë̱mëjeꞌejaꞌa nëcaquë saina, ñani huati paꞌimaꞌco cuasajë quëquëni cuihuë. ");
INSERT INTO seyNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Siꞌaohuaꞌi ñani quëquëni cuijëna, i̱pi capi, ja̱ohuaꞌire: “Ai yoꞌojë camaꞌpë yëꞌë aꞌë. Caꞌramaꞌpë paꞌijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ja̱je cani i̱ohuaꞌi paꞌi yohuëna aya mëina, tutupi je̱ouna, ja̱ maca merepa ja̱je yoꞌoquëꞌni cuasajë ñareña, i̱ yoꞌoseꞌe. ");
INSERT INTO seyNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Aꞌri maña pan paꞌiseꞌere jaiye neni pa̱ire a̱oseꞌere cuasaye pa̱reña, i̱ohuaꞌi joyo jëa doꞌire. Ja̱je paꞌina, ai cuasareña. ");
INSERT INTO seyNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Je̱ni ti̱ꞌareña, Genesaret yejana. Ja̱rona i̱ohuaꞌi yohuë sëa huahuoreña. ");
INSERT INTO seyNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Yohuëpi sa tu̱masi maca Jesu api cajë ñareña. ");
INSERT INTO seyNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ñani ja̱ maca siꞌa hue̱ꞌña cuꞌijë ju̱ꞌicohuaꞌire da huëoreña, ca̱i saihuëre u̱ijëna, Jesús quëꞌrona. ");
INSERT INTO seyNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Aꞌri dari mañana saina, pa̱i daripë̱ana saina, tsio huë̱ꞌñana saina, ju̱ꞌicohuaꞌire i̱ sai maꞌañana o̱ereña, jujucaija̱quë cajë. Jesure ai se̱teña, mëꞌë juꞌi ca̱na patoni ju̱ꞌicohuaꞌi coꞌyaja̱jë cajë. Siꞌaohuaꞌi i̱ juꞌi ca̱ patocohuaꞌi coꞌyareña. ");
INSERT INTO seyNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Jesús quëꞌrona Fariseo pa̱i cuiꞌne cua̱ñeseꞌe yeꞌyacohuaꞌi tsio dateña, Jerusalénpi daisicohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ja̱je daisicohuaꞌipi ñajëna, Jesús yeꞌyacohuaꞌipi jë̱ña tsoamaꞌpë a̱ëꞌë. Ja̱je tsoamaꞌcohuaꞌipi a̱ijëna, ñani cueꞌcuehuë, siꞌsi jë̱ñapi a̱iñë cajë. ");
INSERT INTO seyNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ja̱ohuaꞌi cato ja̱ yëꞌtaꞌa a̱o a̱imaꞌnë jë̱ña tsoajë̱ꞌë. Aipë caseꞌere yoꞌocohuaꞌi paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ja̱je paꞌiohuaꞌipi a̱o huero hue̱ꞌñapi coꞌini ai jë̱ña tsoacohuaꞌi pateña. Cuiꞌne jaiye yeque yoꞌocohuaꞌi pateña, i̱ohuaꞌi aipë yoꞌoye, u̱cu duruhuë̱a tsoaye, quë̱na neꞌña tsoaye, ca̱isi saihuë tsoaye, yoꞌocohuaꞌi pateña. ");
INSERT INTO seyNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ja̱je yoꞌocohuaꞌipi fariseo pa̱i cuiꞌne cua̱ñeseꞌe yeꞌyacohuaꞌipi se̱teña, Jesure ñeje: “¿Me yoꞌojë mëꞌë yeꞌyacohuaꞌi jë̱ña tsoajë̱ꞌë ja̱ yëꞌtaꞌa a̱imaꞌnë caseꞌe yoꞌomaꞌpë, siꞌsi jë̱ñapi a̱iñeꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ja̱je cajëna, Jesupi capi, ja̱ohuaꞌire: “Nuñerepa ja̱je mësaru coa cacohuaꞌi paꞌijëna, asaquë coꞌaji Maijaꞌquëre quëacaiquë Isaías ñeje caquë toyapi: Icohuaꞌi cato yëꞌëre coa yëꞌoposeꞌe oiyë cayë. Ja̱je paꞌiquëtaꞌare i̱ohuaꞌi joñoapi yëꞌëre oiye pa̱ñë. ");
INSERT INTO seyNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","I̱ohuaꞌi yëꞌëre se̱ñë cajë yoꞌoye doꞌi peoye aꞌë. Coa pa̱iseꞌe cua̱ñeseꞌere yeꞌyajë yoꞌo doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","¿Me yoꞌojë mësaru Maijaꞌquë cua̱ñeseꞌere yoꞌomaꞌpë yequere coa pa̱i cua̱ñeseꞌere yoꞌoyeꞌni? ¿U̲cu duruhuë̱are tsoaye, quë̱na neꞌña tsoayere cuiꞌne jaiye ja̱je paꞌye yequeje̱ yoꞌoyeꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Caëña, Jesús yequeje̱: “Mësaru aiohuaꞌi caseꞌere yoꞌoñuꞌu cajë Maijaꞌquë cua̱ñeseꞌere ti̱rona je̱oni yoꞌoyë, mësaru. ");
INSERT INTO seyNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés cato capi: ‘Mëꞌë jaꞌcore cuiꞌne më jaꞌquëre deꞌoye oi sa̱ñope camaꞌë paꞌijë̱ꞌë. Pëca jaꞌcore cuiꞌne pëca jaꞌquëre sa̱ñope coꞌaye caquëre cato huani je̱oñe paꞌiji.’ ");
INSERT INTO seyNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ja̱je caseꞌe paꞌiquëtaꞌare mësaru caye paꞌiji: ‘Jaꞌquëre cuiꞌne jaꞌcore co̱caiye pa̱ñë. Siꞌaye yëꞌë paye Maijaꞌquëna i̱sihuë.’ ");
INSERT INTO seyNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ja̱je mësaru cani cayë, jaꞌcore cuiꞌne jaꞌquëre co̱caiye peoji, cajë. ");
INSERT INTO seyNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ja̱je mësaru yoꞌojë Maijaꞌquë cua̱ñeseꞌere pare je̱ocoyë, pa̱i caseꞌere yecohuaꞌina se yeꞌyajë. Ja̱je paꞌye yequeje̱ jaiye yoꞌoyë, mësaru.” ");
INSERT INTO seyNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ti̱jupë Jesús soini capi, pa̱ire: “Asajë̱ꞌë, siꞌa pa̱i. Coa tayo asamaꞌpë deꞌhuajë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Siꞌaye ë̱mëjeꞌepi se cacaye cato pa̱ire coꞌaye ne maꞌñe aꞌë. Sa̱ꞌnahuë joyopi coꞌaye etaye aꞌë, pa̱ire coꞌaye siꞌsi neñe. ");
INSERT INTO seyNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ca̱joro pacohuaꞌi sëte asajë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ja̱je casi jeteyoꞌje pa̱ire je̱oni huëꞌena Jesús cacasi maca i̱ yeꞌyacohuaꞌipi ja̱ caseꞌere quëajë̱ꞌë cajë se̱teña. ");
INSERT INTO seyNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Se̱jëna, caëña: “¿Ja̱je paꞌito mësaruje̱ asa ti̱ꞌañe pa̱re? Mësarupi asahuë, siꞌaye ë̱mëjeꞌepi cacaseꞌe cato pa̱ire coꞌaye neñe peoji. ");
INSERT INTO seyNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","A̲o cato joyona saiye pa̱ji. Coa a̱i ë̱tatuꞌuna saiseꞌepi jeteyoꞌje eta saiji. ");
INSERT INTO seyNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Cuiꞌne pa̱i joyopi etaye aꞌë, coꞌaye neñe. ");
INSERT INTO seyNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Sa̱ꞌnahuë joyore cayë ja̱ropi etaji, siꞌaye coꞌaye cuasaye: yecohuaꞌini nomiohuaꞌire, ë̱mëre yoꞌoye, pa̱ire huani je̱oñe, ");
INSERT INTO seyNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","coꞌamaña i̱mañe, yecohuaꞌi coꞌamañare pa ëaye ñañe, siꞌaye coꞌayere yëye, cosojë yoꞌoye coꞌayena sëo measicohuaꞌi paꞌiye, yecohuaꞌi payere ëa ñajë pë̱iñe, yequëna coꞌa coca ca maꞌñere se quëaye, jerepa paꞌi aꞌë cuasaye, cuiꞌne yecohuaꞌi paꞌiyere cuasacaimaꞌpë coa jo̱sa yoꞌoroja̱iñe. ");
INSERT INTO seyNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Siꞌaye iye joyo sa̱ꞌnahuëpi etaji. Ja̱pi pa̱ire siꞌsi neñe aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ja̱ropi Jesús Tiro cuiꞌne Sidón yejana sajiꞌi, huëꞌena cacani pa̱ije huesëja̱jë yëꞌëre caquë. Yoꞌoquëtaꞌare catiye peopi. ");
INSERT INTO seyNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ja̱ doꞌire tsoe Jesu api asaco, huati quëꞌio pëca jaꞌcopi i̱ quëꞌrona dani doꞌre jaꞌruni se̱coꞌë, huatire eto saocaijë̱ꞌë, yëꞌë mamacore paꞌicore. ");
INSERT INTO seyNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ja̱o cato Sirofenicia pa̱io pacoꞌë, yequë yeja aco. ");
INSERT INTO seyNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ja̱je cacona, Jesupi capi, i̱ote: “Mamajëpi duꞌru a̱ijajë, coꞌaji, mamajë a̱iñere sioni joꞌya yaina i̱siye.” ");
INSERT INTO seyNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Caquëna, i̱opi sehuoña: “Ja̱je paꞌijë̱ꞌë, Ëjaë. Ja̱je paꞌiquëtaꞌare joꞌya yaije̱ a̱icohuaꞌi aꞌë, mamajë a̱ijë ne to̱ neꞌña mañaje.” ");
INSERT INTO seyNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Cacona, Jesupi caëña: “Deꞌoyerepa mëꞌë cayë, tsoe mëꞌë mamacore huati eta sajiꞌi, se̱ñaco saijë̱ꞌë, deꞌoji.” ");
INSERT INTO seyNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Caëna, huëꞌe ti̱ꞌani ñacona, ca̱i saihuë u̱icopi mamaco tsoe huatire peocopi deꞌoye pacoña. ");
INSERT INTO seyNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús Tiro yejapi etani Sidón yeja sa tëto sani cuiꞌne Decápolis daripë̱aje tëto sani Galilea jaira ti̱ꞌaëña. ");
INSERT INTO seyNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ja̱rote paꞌina, asamaꞌquëpi cuiꞌne hua̱ꞌhua̱ coca caquëni dareña. Dani pato coꞌyacaijë̱ꞌë, cajë se̱teña. ");
INSERT INTO seyNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Se̱jëna, Jesupi pa̱i peo te̱ꞌtena sani moñopi ca̱jorona sa̱quëña. Sa̱ꞌi copi i̱ moñona tseꞌseni tse̱meñoje papiña. ");
INSERT INTO seyNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Papiquë maꞌtëmona ñaquë ai yëꞌeni caëña: “¡Efata!” Ja̱je cani capi, Huiꞌyojë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ja̱ maca tsoe ca̱joro huiꞌyopi. Ja̱ maca deꞌoye coca caquë paquëña. ");
INSERT INTO seyNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ja̱je yoꞌoni capi, ja̱ohuaꞌire, yecohuaꞌire quëamaꞌpë. Ja̱je caëna, coa jerepa quëareña. ");
INSERT INTO seyNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Quëarena, deꞌoyerepa yoꞌoquëꞌni cuasajë careña: “Siꞌaye deꞌoye yoꞌoji. Yoꞌoquëna, asamaꞌcohuaꞌije̱ asacohuaꞌi deꞌoyë, camaꞌcohuaꞌije̱ cayë.” ");
INSERT INTO seyNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ja̱re ja̱ muꞌse jai pa̱i tsiꞌsireña, tsiꞌsisicohuaꞌipi a̱iñe peoreña. Peojëna, Jesupi i̱ yeꞌyacohuaꞌire soini caëña: ");
INSERT INTO seyNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Teaye pa̱i mañare ñañë, yëꞌë ja̱ꞌre tsoe tres muꞌseña a̱iñe peocohuaꞌipi paꞌijëna. ");
INSERT INTO seyNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ja̱je a̱imaꞌcohuaꞌini jëjo saoquë paꞌito jopo maꞌana dahuëra ju̱ꞌijaꞌcohuaꞌi paꞌini, yecohuaꞌipi soꞌopi daisicohuaꞌipi paꞌiyë.” ");
INSERT INTO seyNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Caquëna, i̱ yeꞌyacohuaꞌipi careña: “¿Me i̱ño cato hueroni a̱oñeꞌni, pa̱ije peo hue̱ꞌña?” ");
INSERT INTO seyNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Cajëna, Jesupi se̱quëña: “¿Je so̱ pan payeꞌni, mësaru?” Se̱ina, careña: “Siete pan payë.” ");
INSERT INTO seyNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Cajëna, asani pa̱ire cua̱ñeiña, tayahuëna jaꞌrujë̱ꞌë caquë. Ja̱ maca siete pan i̱ni Maijaꞌquëre deꞌoji caquë pëpani. Ja̱ jeteyoꞌje i̱ yeꞌyacohuaꞌina huahueni i̱sipi. I̱sina, ja̱ohuaꞌipi pa̱ire se a̱ohuë. ");
INSERT INTO seyNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tsiaya huaꞌireje̱ pahuë. Pajëna, Jesupi cuiꞌne ja̱ohuaꞌireje̱ yoꞌoni huahueni i̱ yeꞌyacohuaꞌina i̱sina, se a̱ohuë. ");
INSERT INTO seyNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Siꞌa pa̱i a̱ni sihuacohuaꞌi paëꞌë, siete doꞌrohuë̱a nëapi, a̱ni jujaseꞌe. ");
INSERT INTO seyNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ja̱ a̱isicohuaꞌi cato cuatro mil paëꞌë. Ja̱ maca Jesupi i̱ohuaꞌire saiyë cani ");
INSERT INTO seyNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","sajiꞌi, i̱ yeꞌyacohuaꞌi ja̱ꞌre co̱ni yohuëja̱ꞌa Dalmanuta yejana. ");
INSERT INTO seyNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Fariseo pa̱ipi dani Jesure sa̱ñope careña. I̱te neñañuꞌu cajë se̱teña, pa̱i yoꞌo ti̱ꞌa maꞌñere maꞌtëmo ayere ne i̱ñojëꞌë cajë. ");
INSERT INTO seyNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Se̱jëna, ai ëja yëꞌeni caëña: “¿Me neñuꞌju iye pa̱i ja̱je se̱ñeꞌni pa̱i yoꞌo ti̱ꞌa maꞌñere yoꞌo i̱ñojëꞌë cajë? Care payë, mësarute i̱ñoñeje peoji, teꞌoreje̱.” ");
INSERT INTO seyNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ja̱je cani je̱oni, cuiꞌnaëpi yohuëna aya mëni jaira je te̱ꞌtena saquëña. ");
INSERT INTO seyNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Pan hua̱nëyeni saëꞌë, a̱i ja̱ꞌñe peocohuaꞌi, coa teꞌe panpë maca sahuë. Ja̱oseꞌe yohuë paquëña. ");
INSERT INTO seyNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Paꞌina, Jesupi i̱ohuaꞌire cua̱ñeiña. Deꞌhua ñajëꞌë, fariseo pa̱i oꞌsa cuiꞌne Herodes pa̱i oꞌsana co̱ꞌme huesëye caquë. ");
INSERT INTO seyNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ja̱je caquëna, i̱ yeꞌyacohuaꞌipi sa̱ꞌñe careña: pan peocohuaꞌi datena caji. ");
INSERT INTO seyNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ja̱je cajëna, Jesupi asani caëña, ja̱ohuaꞌire: “¿Me yoꞌojë pan peoyë, cayeꞌni? ¿Ja̱ yëꞌtaꞌa huesëjë ja̱je caye? ¿Ai jëa joyore hueꞌeye, mësaru? ");
INSERT INTO seyNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Cuiꞌne ti ñamaꞌpë paꞌiye, cuiꞌne asamaꞌpë paꞌiye, mësaru ca̱joropi? ¿Yëꞌë ja̱ꞌrë jaiye pan neseꞌe cuasaye pa̱ñe? ");
INSERT INTO seyNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Mësarupi ñasicohuaꞌitaꞌa cinco panpi cinco mil pa̱ire a̱oseꞌe: ¿a̱ojëna, cuiꞌne je jaꞌye nëaëꞌni?” Caquëna, i̱ohuaꞌipi sehuoreña: “Doce doꞌrohuë̱a nëapi.” ");
INSERT INTO seyNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“¿Cuiꞌne cuatro mil pa̱ire siete pan paꞌiseꞌepi a̱oto je jaꞌye nëaëꞌni?” Caquëna, i̱ohuaꞌipi careña: “Siete doꞌrohuë̱a nëapi.” ");
INSERT INTO seyNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ja̱je cajëna, i̱pi caëña: “¿Ja̱ yëꞌtaꞌa ja̱je ñasicohuaꞌitaꞌa cuiꞌne huesëcohuaꞌi paꞌijë ja̱je cuasayeꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ja̱ jeteyoꞌje Betsaidana ti̱ꞌareña. Ti̱ꞌasi maca Jesús quëꞌrona dareña, ñamaꞌquëni jujucaijë̱ꞌë cajë. ");
INSERT INTO seyNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ja̱je cajëna, asani ñamaꞌquë jë̱tëna tse̱ani ca̱jiquë pa̱i daripëpi hueꞌsena etouña. Copi ñaco ca̱na neni i̱na patoquë, se̱quëña, ¡Deꞌhue ña cua̱ñoquë! ");
INSERT INTO seyNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Caquëna, ñamaꞌquëpi caëña: “Ñañë, pa̱ire. Ñaquëtaꞌare so̱quë ñëaje paꞌyepi cuꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ja̱je caquëna, Jesupi ti̱jupë ñaco ca̱na patoquëna, yuretaꞌa deꞌoyerepa ñaquë po̱nëni coꞌyasiquë paquëña. ");
INSERT INTO seyNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ja̱ maca Jesús huëꞌena i̱te jëjo saoquë caëña: “Pa̱i daripë cacamaꞌë cuiꞌne yecohuaꞌireje̱ quëamaꞌë paꞌijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ja̱ jeteyoꞌje Jesús cuiꞌne i̱ yeꞌyacohuaꞌi co̱ni Cesarea cuiꞌne Filipo yeja pa̱i aꞌri darina sateña. Saijëna, maꞌana Jesupi se̱quëña, i̱ yeꞌyacohuaꞌire: “¿I̱queipi yëꞌëre cayeꞌni, pa̱i?” ");
INSERT INTO seyNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Caquëna, i̱ohuaꞌipi careña: “Yecohuaꞌipi mëꞌëre cayë, Juan oco doquë api. Yecohuaꞌipi cayë, Elíaspi. Cuiꞌne yecohuaꞌipi Maijaꞌquë jëjo daoquë api cayë.” ");
INSERT INTO seyNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ja̱ maca i̱pi se̱quëña, i̱ohuaꞌire: “¿Mësarutaꞌa i̱queipi cayeꞌni, yëꞌëre?” Caquëna, Pedropi caëña: “Mëꞌë cato huasoquë Cristore paꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ja̱je caëna, Jesupi caëña, ja̱ohuaꞌire: “Yecohuaꞌire quëamaꞌpë paꞌijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ja̱ maca yeꞌya huëoni yeꞌyaquë caëña. Pa̱i Mamaquë yëꞌë ai yoꞌoye paꞌiji. Aiohuaꞌipi yëꞌëre coeja̱ꞌcohuaꞌi aꞌë. Pa̱i ëjaohuaꞌije̱ coeja̱ꞌcohuaꞌi aꞌë. Cuiꞌne cua̱ñeseꞌe yeꞌyacohuaꞌije̱ yëꞌëre coeja̱ꞌcohuaꞌi aꞌë. Ja̱je coejë yëꞌëre huani je̱ojaꞌcohuaꞌi aꞌë. Ja̱je huani je̱osicohuaꞌitaꞌare toaso̱ muꞌseña paꞌi maca huëija̱ꞌquë aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iye ti̱ñarepa quëaëña. Quëaquëna, Pedro i̱te ti̱rona sani caëña. Ja̱je yoꞌoto coꞌaji. Iye camaꞌë paꞌijë̱ꞌë, ca huëoëña. ");
INSERT INTO seyNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ja̱je caquëna, Jesús coꞌye po̱nëni i̱ yeꞌyacohuaꞌire ñaëña. Ñani Pedrore tutu caëña: “Huati ëjaë saijë̱ꞌë. I̱ño paꞌimaꞌë. Mëꞌë cato Diusu cuasayeje̱ cuasamaꞌquë aꞌë. Coa pa̱i cuasayere cuasaquë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ja̱ maca Jesús i̱ yeꞌyacohuaꞌire cuiꞌne pa̱ire soini caëña: “Yëꞌëni tuñuꞌu cani coꞌye deꞌoye paꞌiyere hua̱nëyejë̱ꞌë. Ja̱je yoꞌoni mëꞌëre que̱jaꞌcore hueꞌoni tuijë̱ꞌë, yëꞌëre. ");
INSERT INTO seyNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ja̱je paꞌina, i̱ paꞌiye jëasiꞌi caquë yoꞌoquëpi coa ne huesoja̱ꞌquë api. Ja̱je paꞌiquëtaꞌare yëꞌë doꞌire cuiꞌne yëꞌë coca doꞌire i̱ paꞌiye nejosiquëpi paꞌiye ti̱ꞌajaꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Ja̱je paꞌina, i̱quere co̱caiquëꞌni, pa̱ipi siꞌaye iye yeja coꞌamaña ti̱ꞌasicohuaꞌipi i̱ohuaꞌi joyore coa nejoto? ");
INSERT INTO seyNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Joyore nejosiquë pani yecore ti̱ꞌañe peoji. ");
INSERT INTO seyNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yëꞌëni cuiꞌne yëꞌë cocare huajëyaꞌye quëamaꞌquëpi cajë pa̱ini caꞌrajë pa̱sicohuaꞌire, yëꞌë Pa̱i Mamaquëpi cuiꞌne huajëyaꞌye quëamaꞌquëpi caquë coeja̱ꞌquë aꞌë, yëꞌë jaꞌquë deꞌo tuture papi cuiꞌne i̱ hui̱ñaohuaꞌi ja̱ꞌre dai maca.” ");
INSERT INTO seyNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Cuiꞌne Jesús caꞌquëña: “Nuñerepa cayë, mësarute. Mësaru acohuaꞌi iye maca paꞌicohuaꞌi ju̱ꞌimaꞌpë paꞌija̱ꞌcohuaꞌi aꞌë, maꞌtëmo te̱ꞌte ñamaꞌpë pani.” ");
INSERT INTO seyNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Seis muꞌseña tëto saisi maca Jesupi Pedrore, Jacobore cuiꞌne Juanre sai saëña, ai cu̱tihuëna. Ja̱rona i̱ juꞌi ca̱ cuiꞌne i̱ tsia ti̱ñe paꞌi po̱nëña. ");
INSERT INTO seyNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Miacorepa iye yeja ca̱ña jo̱ja ti̱ꞌañe peoji, ja̱re coa sësë pe̱, pojaꞌiyeje̱ pojaꞌico po̱nëoña, i̱ juꞌi ca̱ yeꞌhue paꞌiorepa. ");
INSERT INTO seyNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ja̱ maca ñareña, Elíasre cuiꞌne Moisésre Jesús ja̱ꞌre nëcajë cocare cajëna. ");
INSERT INTO seyNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ja̱ maca Pedropi Jesure caëña: “Yeꞌyaquë, ¿deꞌoyerepa i̱ño paꞌiyeꞌni, mai? Toaso̱ aꞌri huë̱ꞌña neñuꞌu. Mëꞌë huëꞌe, Moisés huëꞌe, cuiꞌne Elías huëꞌe neñuꞌu.” ");
INSERT INTO seyNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ja̱je Pedro cani ti cuasamaꞌë capi, tsoe quëquë huesë sitopi. Siꞌahuaꞌi i̱ yeꞌyacohuaꞌi cato quëquë huesësicohuaꞌi pateña. ");
INSERT INTO seyNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ja̱ maca maꞌtëmopi sirio i̱ohuaꞌi quëꞌrona nëca mequëna, asajëna, yëꞌoseꞌe pi̱siña: “Iquë cato yëꞌë mamaquë api. I̱ni ai sihuaquë paꞌiyë. I̱ cayere asajë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ja̱ jeteyoꞌje coa Jesuseꞌe teꞌi paquëña. ");
INSERT INTO seyNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ai cu̱tihuëpi cajequë Jesús i̱ yeꞌyacohuaꞌire caëña, yecohuaꞌire mësaru ñaseꞌe quëamaꞌpë, yëꞌë ju̱ꞌisiquëpi huëisi maca quëajë̱ꞌë, caëña. ");
INSERT INTO seyNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ja̱je caëna, i̱ohuaꞌiseꞌe yahue deꞌhuaseꞌere pareña. Ja̱je pajë coa sa̱ꞌñe se̱teña, i̱quere caëꞌni, ju̱ꞌisiquëpi huëisi maca quëajë̱ꞌë caquë. ");
INSERT INTO seyNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ja̱je paꞌina, Jesure se̱teña: “¿Me yoꞌojë cua̱ñeseꞌe yeꞌyacohuaꞌi Elíaspi duꞌru daiye paꞌiji, cayeꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Cajëna, i̱pi sehuouña: “Nuñerepa duꞌru daija̱ꞌquë api. Dani siꞌaye ne deꞌhuaja̱ꞌquë api. Cuiꞌne ¿me caquëꞌni, toyaseꞌe yëꞌë Pa̱i Mamaquë aye? Ai yoꞌoja̱ꞌquë api. Cuiꞌne pa̱ije i̱te coeja̱ꞌcohuaꞌi aꞌë, caji. ");
INSERT INTO seyNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ja̱je paꞌiquëtaꞌare yëꞌë cayë tsoe Elías dajiꞌi. I̱ni pa̱i i̱ohuaꞌi yëyeje̱ yoꞌohuë, toyaseꞌe cayeje̱ paꞌye.” ");
INSERT INTO seyNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jeteyoꞌje coꞌireña, i̱ yeꞌyacohuaꞌi paꞌi hue̱ꞌñana. Dani jai pa̱i paꞌijëna, ñareña. Ñajëna, cuiꞌne i̱ yeꞌyacohuaꞌi ja̱ꞌre co̱ni sa̱ñope cajë pateña, cua̱ñeseꞌe yeꞌyacohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ja̱je cacohuaꞌipi Jesure ñani se je̱oni huëꞌhuëni pëpareña, deꞌoquëre paꞌni cuasajë. ");
INSERT INTO seyNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ja̱ maca Jesupi i̱ohuaꞌire se̱quëña: “¿I̱quere sa̱ꞌñe yoꞌojë careꞌni, ja̱ohuaꞌi ja̱ꞌre?” ");
INSERT INTO seyNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Se̱ina, i̱ohuaꞌi ja̱ꞌre paꞌisiquëpi sehuouña: “Yeꞌyaquë yëꞌëpi dahuë, huati quëꞌini, yëꞌë mamaquëre camaꞌquëni mëꞌëni ña cua̱ñosiꞌi caquë. ");
INSERT INTO seyNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Huatipi i̱te deꞌoye paꞌina, ne ta̱oquë yoꞌoji. Yoꞌoquëna, siri yëꞌopoja̱ꞌa mëaquë cuiꞌne cu̱ji qui̱ꞌcoquë yoꞌoji. Ja̱je yoꞌoquë tutu peoquë deꞌo huesëji. Mëꞌë yeꞌyacohuaꞌire eto saocaijë̱ꞌë, caquë se̱ni jujahuë, ne ti̱ꞌañe peojëna.” ");
INSERT INTO seyNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Caquëna, Jesupi caëña: “¡Maijaꞌquëpi necaiquë api cuasamaꞌcohuaꞌi! ¿Mësaru ja̱ꞌre yëꞌë tsoe aquëpi paꞌiyë? ¿Je jaꞌye tsoerepa mësarute quëcoquë co̱cai paꞌija̱ꞌquë aꞌni, ja̱je huesëto? Dajë̱ꞌë, tsihuaꞌëre.” 2 ");
INSERT INTO seyNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Caëna, darena, huatipi Jesure ñani, hueꞌhue dahuë nequëna, sa ta̱ni tearoja̱ni siri yëꞌopoja̱ꞌa etoquë yoꞌouña. ");
INSERT INTO seyNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ja̱je yoꞌoquëna, ñani Jesús caëña, pëca jaꞌquëre: “¿Je jaꞌye tsoe ja̱je yoꞌoquë paꞌiquëꞌni?” Caquëna, pëca jaꞌquëpi caëña: “Tsihuaꞌë paꞌinë aquë api. ");
INSERT INTO seyNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Yequere toana, tsiayana huani je̱osiꞌi, caquë yoꞌoquë api, jaiye. Ja̱je paꞌina, mëꞌëpi yëquëre oi co̱caijë̱ꞌë, deꞌhue.” ");
INSERT INTO seyNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Caquëna, Jesupi caëña: “Mëꞌëpi neñe paꞌiji, cuasaquë paꞌito neñe paꞌiji, siꞌaye.” ");
INSERT INTO seyNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Caquëna, tsihuaꞌë pëca jaꞌquëpi cuiña: “Neñe paꞌiji, cuasayë. Co̱caijë̱ꞌë, ai jerepa ja̱je cuasa ja̱ꞌñere.” ");
INSERT INTO seyNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ai jerepa jai pa̱i tsiꞌsi daijëna, ñani huatire caëña: “Huati asamaꞌquë cuiꞌne camaꞌquë, yëꞌëpi mëꞌëre cayë, etajë̱ꞌë. Iquë tsihuaꞌëre je̱oni sani cuiꞌnaëni cacaye pa̱jëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Caquëna, huatipi cuini yeque hueꞌhue dahuë se ne co̱uña. Neni ju̱ꞌiseꞌeje̱ paꞌire je̱oni saquëña. Ja̱re ñani yecohuaꞌi ju̱ꞌisiquë paꞌiji, careña. ");
INSERT INTO seyNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ja̱je cajëna, Jesupi i̱te jë̱tëna tse̱ani naë huëo nëcouña. ");
INSERT INTO seyNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ja̱ maca Jesús huëꞌena cacaëna, i̱ yeꞌyacohuaꞌipi se̱teña: “¿Me yoꞌojë yëquë huatire eto saoye pa̱reꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Cajëna, Jesupi caëña: “Ñeje paꞌi huatire cato coa a̱imaꞌpë cuiꞌne Maijaꞌquëre se̱ñepi eto saoye paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ja̱ropi saijë Galileaja̱ꞌa tëto sateña. Pa̱ije huesëjëna, sasiꞌi cuasaëña, Jesús. ");
INSERT INTO seyNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ja̱ muꞌse cato Jesús i̱ yeꞌyacohuaꞌini quëaquë cuquëña. Yëꞌë Pa̱i Mamaquë cato tse̱a cua̱ñosiquë paꞌija̱ꞌquë aꞌë. Ja̱ohuaꞌipi huani je̱ojaꞌcohuaꞌi aꞌë caëña. Cuiꞌne caëña, toaso̱ muꞌseña paꞌi maca ju̱ꞌisiquëpi huëija̱ꞌquë aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ja̱je quëaquëna, i̱ yeꞌyacohuaꞌi asa ti̱ꞌañe pa̱reña. Pa̱jëtaꞌa se̱ni asaye pa̱reña, caꞌrajë. ");
INSERT INTO seyNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Capernaum daripëna ti̱ꞌani huëꞌere paꞌi maca Jesupi se̱quëña: “¿I̱quere mësaru maꞌa daini sa̱ꞌñe yoꞌojë careꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Caquëna, sehuomaꞌpë pateña. Nepi jerepa paꞌi paꞌija̱ꞌquë aꞌni, cajë sa̱ꞌñe yoꞌojë casicohuaꞌipi maꞌa dai maca. ");
INSERT INTO seyNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Pa̱jëna, jaꞌruni ñuꞌi doce i̱ yeꞌyacohuaꞌire caëña: “Siꞌaohuaꞌire tëto saisiquë pasiꞌi, cani siꞌaye yecohuaꞌire necaiquë joꞌyaë paꞌiye paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ja̱je ca tëjini tsihuaꞌëre jopore pana nëconi, suꞌcuani caëña, ja̱ohuaꞌire: ");
INSERT INTO seyNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Yëꞌëje̱ paꞌire cuasajë tsihuaëre deꞌoye yoꞌocaini yëꞌëni yoꞌoye paꞌiji. Yëꞌëre deꞌoye yoꞌoquë cato yëꞌëseꞌere deꞌoye yoꞌoye peoji, cuiꞌne yëꞌëre jëjo daosiquëreje̱ deꞌoye yoꞌocaiye paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ja̱ maca Juanpi caëña: “Yeꞌyaquë, yëquë ñahuë, mëꞌë mamipi caquë huatire eto saoquëre. Ñani yoꞌomaꞌë cajë ë̱sehuë, mai ja̱ꞌre co̱ni cuꞌimaꞌquëpi yoꞌoquëna.” ");
INSERT INTO seyNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Caquëna, Jesupi caëña: “Ë̲semaꞌpë paꞌijë̱ꞌë, yëꞌë mamipi cajë pa̱i yoꞌo ti̱ꞌa maꞌñe yoꞌocohuaꞌire. Ja̱ohuaꞌi cato yëꞌëre sa̱ñope camaꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Maire sa̱ñope yoꞌomaꞌquë cato mai te̱ꞌtere paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Mësaruni yecohuaꞌipi yëꞌë doꞌipi cajë oco mañare o̱cuacohuaꞌi pani deꞌhuacaisi coꞌamaña paja̱ꞌcohuaꞌi aꞌë, mësaru Cristo acohuaꞌini deꞌoye yoꞌosi doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Tayo yoꞌoyena ne ta̱oquëre cato, quë̱na pëpi ñaje tëcana sëani jai tsiayana je̱o dëoꞌñe paꞌi api, aꞌricohuaꞌipi yëꞌëre cuasacohuaꞌire coꞌa deꞌhuaquëre. ");
INSERT INTO seyNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ja̱je paꞌina, cayë mëꞌë jë̱tëpi tayo yoꞌoyena saco paꞌito tëto tëajë̱ꞌë. Ai jerepa deꞌoji, paꞌi hue̱ꞌñana peo tupëpi cacato toa yejana saiye peoye, ");
INSERT INTO seyNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","pecoje̱ ju̱ꞌimaꞌtona cuiꞌne toaje̱ yayamaꞌtona. ");
INSERT INTO seyNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Mëꞌë nëcayopi tayo yoꞌoyena saco paꞌito tëto tëajë̱ꞌë. Ai jerepa deꞌoji, paꞌi hue̱ꞌñana peo tupëpi cacato. Ai jerepa coꞌaji, caya nëcañoa hueꞌequëpi toa yejana saito. ");
INSERT INTO seyNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ja̱ro pecoje̱ ju̱ꞌimaꞌtona cuiꞌne toaje̱ yayamaꞌtona. ");
INSERT INTO seyNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Panitaꞌa mëꞌë ñacoapi tayo yoꞌoyena saco paꞌito dutani je̱ocojë̱ꞌë. Ai jerepa deꞌoji, Diusu cua̱ñe te̱ꞌtena teꞌe ñacoa hueꞌequëpi cacato. Ai jerepa coꞌaji, caya ñacoa hueꞌequëpi toa yejana saito. ");
INSERT INTO seyNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ja̱ro pecoje̱ ju̱ꞌimaꞌtona cuiꞌne toaje̱ yayamaꞌtona. ");
INSERT INTO seyNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Siꞌahuaꞌi toapi ne deꞌhuasicohuaꞌi paꞌija̱ꞌcohuaꞌi aꞌë, cuiꞌne siꞌaye Maijaꞌquë coa i̱siye cato a̱sipi, ne deꞌhuaseꞌe pasipi. ");
INSERT INTO seyNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","A̲sipi i̱o së̱ñere caraja̱isico pani coꞌaji, huaꞌi saraye. Ja̱je paꞌina, cayë: Mësaru sa̱i ja̱ꞌñere ne huesomaꞌpë paꞌijë̱ꞌë, pa̱i ja̱ꞌre sa̱ñope yoꞌomaꞌpë joꞌcua deꞌoye paꞌijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yeꞌya tëjini Capernaum sani Jordán ña oca te̱ꞌtena saquëña, Judea yejana. Ja̱rona jai pa̱i tsiꞌsireña, i̱ paꞌi hue̱ꞌñana. Tsiꞌsirena, yeꞌyaëña, i̱ yeꞌyaye sëte. ");
INSERT INTO seyNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Fariseo pa̱ipi neñañuꞌu cajë se̱teña, ñeje: “¿Nëjore je̱oñe deoquë?” ");
INSERT INTO seyNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Cajëna, i̱pi sehuouña: “¿Moisés me cua̱ñeiꞌni, mësarute?” ");
INSERT INTO seyNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Caquëna, careña: “Moiséspi cua̱ñepi pa̱i ëjaëpi nëjore je̱oco toya jaꞌo necaquëna, je̱ocoye paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Cajëna, Jesupi caëña: “Ja̱ cato Moisés cua̱ñepi mësaru joyopi deꞌoye cuasamaꞌ doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ja̱ꞌa Maijaꞌquë siꞌaye yeja paꞌiye deꞌhua maca ë̱mëre cuiꞌne nomiore deꞌhuapi. ");
INSERT INTO seyNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ja̱ doꞌire huejani pëca jaꞌquëre cuiꞌne pëca jaꞌcore je̱oni nëjona tsioni paꞌiye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ja̱ maca caya huaꞌi paꞌiye pa̱ñë. Coa teꞌije̱ paꞌiohuaꞌi paꞌiyë. ");
INSERT INTO seyNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ja̱ doꞌire nëjore je̱oñe coꞌaji, Maijaꞌquë deꞌoye ñacai tsioseꞌere.” ");
INSERT INTO seyNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Huëꞌena coꞌisi maca i̱ yeꞌyacohuaꞌipi Jesure cuiꞌnare se̱ni co̱reña, nuñerepa asañuꞌu cajë. ");
INSERT INTO seyNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Cajëna, Jesupi caëña: “Nëjore je̱oconi yecore huejaquë pani yeconi nomiore yoꞌoji, coꞌaye nëjore paquëtaꞌa. ");
INSERT INTO seyNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nomiopi ë̱jëre je̱ocosicopi yequëre huejaco pani ë̱mëre yoꞌoco, ë̱jëre pacotaꞌa, ja̱oje coꞌaye yoꞌoco.” ");
INSERT INTO seyNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jesús quëꞌrona tsi̱re dareña, i̱pi papicaija̱ꞌquë cajë. Ja̱je yoꞌojëna, i̱ yeꞌyacohuaꞌipi tsi̱re dacohuaꞌire damaꞌpë Jesús quëꞌro cajë ë̱sereña. ");
INSERT INTO seyNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ja̱je ë̱sejëna, Jesupi ñani pë̱i caëña, ja̱ohuaꞌire: “Coa ñajëꞌë, tsi̱re i̱ohuaꞌiseꞌe daija̱jë, ë̱semaꞌpë. Maꞌtëmo cato ja̱ohuaꞌije̱ paꞌiohuaꞌi tse̱coa. ");
INSERT INTO seyNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nuñerepa cayë, mësarute. Maijaꞌquë cua̱ñe te̱ꞌte cacaye peoji, tsi̱je paꞌiohuaꞌi paꞌiye pa̱ni.” ");
INSERT INTO seyNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Cani tsi̱re suꞌcuani si̱opëna jëñapi patoquë deꞌoye paꞌijë̱ꞌë, cacaquëña. ");
INSERT INTO seyNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ja̱je yoꞌo tëjini Jesús saina, teꞌi huëꞌhuë to̱me dani doꞌre jaꞌruni caëña: “Deꞌo yeꞌyaquë, ¿me nejaꞌquë aꞌni, ti paꞌiyere ti̱ꞌasiꞌi cani?” ");
INSERT INTO seyNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Caquëna, Jesupi caëña: “¿Me yoꞌoquë yëꞌëre deꞌoquë caquëꞌni? Peoji, deꞌoquë. Coa Maijaꞌquëseꞌe deꞌoquë paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Maijaꞌquë cua̱ñeseꞌe mëꞌëpi asayë, pa̱ire huani je̱omaꞌë paꞌijë̱ꞌë. Yequë paconi yoꞌomaꞌë paꞌijë̱ꞌë. Coꞌamaña ñamaꞌë paꞌijë̱ꞌë. Cosomaꞌë paꞌijë̱ꞌë, yecohuaꞌire. Mëꞌë jaꞌquëre cuiꞌne mëꞌë jaꞌcore deꞌoye oi necaijë̱ꞌë, coꞌaye camaꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Caquëna, Jesure i̱pi caëña: “Yeꞌyaquë, yëꞌë cato tsihuaꞌë paꞌinëna, iye cua̱ñeseꞌe asani siꞌa muꞌseña deꞌoye sehuohuë.” ");
INSERT INTO seyNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Caquëna, Jesupi i̱te oi ñani caëña: “Ja̱ yëꞌtaꞌa teꞌo carapi. Sani siꞌaye mëꞌë coꞌamaña i̱sijë̱ꞌë. I̱sini ja̱ curire peocohuaꞌina coa i̱sijë̱ꞌë. Ja̱je yoꞌoni maꞌtëmona jaiye paja̱ꞌquë, i̱si tëjini daijë̱ꞌë, yëꞌë ja̱ꞌre co̱ni.” ");
INSERT INTO seyNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ja̱je caquëna, po̱sëpi oi saquëña, jaiye coꞌamaña paquë sëte. ");
INSERT INTO seyNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Saquëna, Jesús ñani i̱te yeꞌyacohuaꞌire caëña: “Jaiye coꞌamaña pacohuaꞌire maꞌtëmo maꞌa cacaye ai jëaji.” ");
INSERT INTO seyNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Caquëna, i̱te yeꞌyacohuaꞌipi ai cuasareña. Cuasajëna, Jesupi ca co̱uña: “Huau dohuë, curiquëpi siꞌaye ti̱ꞌañë cuasacohuaꞌi maꞌtëmo maꞌa cacaye peoji. ");
INSERT INTO seyNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ti̱ꞌañe pa̱ji, camellore miu ñaca cojeja̱ꞌa jua etoja̱iñe. Ja̱je paꞌina, jaiye coꞌamaña paquëre cato ai jerepa jëaji.” ");
INSERT INTO seyNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ja̱je caquëna, asani ai cuasa co̱ꞌme huesësicohuaꞌi paꞌijë se̱teña: “Ja̱je paꞌito ¿nepi huaso cua̱ñosicohuaꞌi paꞌija̱ꞌcohuaꞌi aꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Se̱jëna, Jesupi ja̱ohuaꞌire ñani caëña: “Pa̱i cato ne ti̱ꞌañe peoji. Ja̱je paꞌiquëtaꞌare Maijaꞌquë cato ne ti̱ꞌañe paꞌiji. Maijaꞌquëre cato siꞌaye ne ti̱ꞌañeseꞌe paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Caquëna, Pedropi caëña: “Ëjaë, yëquë coꞌamaña siꞌaye je̱oni mëꞌëre tuëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Cajëna, Jesupi caëña: “Nuñerepa cayë, mësarute. Huëꞌere, aꞌyëohuaꞌire, yoꞌjeohuaꞌire, jaꞌquëre, jaꞌcore, nëjore, mamajëre, yejaña yëꞌë doꞌire cuiꞌne huaso coca doꞌire je̱osicohuaꞌi pani, ");
INSERT INTO seyNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","iye yejana cien jerepa paja̱ꞌcohuaꞌi, huëꞌe, aꞌyëohuaꞌire, yoꞌjeohuaꞌire, jaꞌcore, mamajëre, yejaña paja̱ꞌcohuaꞌi aꞌë, cuiꞌne yecohuaꞌipi jo̱sa yoꞌoye cuiꞌne maꞌtëmona ti paꞌiyere ti̱ꞌajaꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ja̱je paꞌiquëtaꞌare yure jerepa paꞌiohuaꞌi paꞌisicohuaꞌipi jeteyoꞌjere, paꞌija̱ꞌcohuaꞌi aꞌë, cuiꞌne yure jeteyoꞌjere paꞌisicohuaꞌipi jerepa paꞌiohuaꞌi paꞌija̱ꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesupi duꞌru saina, i̱ yeꞌyacohuaꞌipi jeteyoꞌje saëꞌë, Jerusalénna tu̱maquëna. Saijëtaꞌa merepa yoꞌoye paꞌija̱ꞌcoaꞌni cuasajë quëquë huesësicohuaꞌipi saëꞌë. Saijëna, ja̱ maca Jesupi i̱ohuaꞌiseꞌere soini i̱te yoꞌo ja̱ꞌñere, ");
INSERT INTO seyNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ñeje caëña: “Ñañë, mai Jerusalénna saiye. Ja̱rona Pa̱i Mamaquëre Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌina cuiꞌne cua̱ñeseꞌe yeꞌyacohuaꞌina tse̱ani i̱sija̱ꞌcohuaꞌi aꞌë. I̱sirena, ja̱ohuaꞌipi yequë pa̱ina se i̱sija̱ꞌcohuaꞌi aꞌë, huani je̱ojaꞌquëre. ");
INSERT INTO seyNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","I̱sirena, ja̱ohuaꞌipi yëꞌëre cueꞌcuejë copi tseꞌseja̱ꞌcohuaꞌi aꞌë. Jeteyoꞌje yëꞌëre huani je̱ojaꞌcohuaꞌi aꞌë. Huani je̱orena, toaso̱ muꞌseña ta̱siquëpi huajëquë huëija̱ꞌquë aꞌë, yëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ja̱ maca Zebedeo mamajëpi Jacobo cuiꞌne Juan Jesús quë̱no macana dani se̱teña: “Yeꞌyaquë, yëquëre necaijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Cajëna caëña: “¿I̱quere necaiyeꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Caquëna, ja̱ohuaꞌipi careña: “Mëꞌë cua̱ñe te̱ꞌte deꞌo hue̱ꞌñare pana ëjaërepa deꞌoni jaꞌru maca yëquëre mëꞌë ëja te̱ꞌtena teꞌire cuiꞌne mëꞌë ari te̱ꞌtena teꞌire ñojëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Se̱jëna, Jesupi caëña: “Mësaru huesëjë coa se̱ñë. ¿Deꞌhue mësaru yëꞌë së̱je co̱no u̱cu ti̱ꞌañe panitaꞌa deꞌhue mësaru yëꞌë do cua̱ñoñeje paꞌye paꞌito tëto sani ti̱ꞌañe? Yëꞌë cato ai yoꞌoja̱ꞌquë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Caquëna, sehuoreña, i̱te: “Yëquëje̱ yoꞌo ti̱ꞌajaꞌcohuaꞌi aꞌë.” Cajëna, Jesús ja̱ohuaꞌire caëña: “Ja̱je paꞌire paji. Yëꞌë ai yoꞌoseꞌeje̱ mësaruje̱ ai yoꞌoja̱ꞌcohuaꞌi aꞌë. Cuiꞌne yëꞌë do cua̱ñoseꞌeje̱ paꞌye mësaruje̱ do cua̱ñojaꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Yëꞌë ëja tëꞌhuina cuiꞌne yëꞌë ari tëꞌhuina ñuꞌiñe i̱siye peoji. Ja̱ cato Maijaꞌquëpi i̱si ja̱ꞌñe aꞌë, i̱ caquë ne deꞌhuasicohuaꞌina.” ");
INSERT INTO seyNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ja̱re asani diez, i̱ yeꞌyacohuaꞌipi Juanre cuiꞌne Jacobore sa̱ñope pë̱ti huëoreña. ");
INSERT INTO seyNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ja̱je sa̱ꞌñe pë̱ijëna, Jesupi ja̱ohuaꞌire soini caëña: “Iye yeja cua̱ñe ëjaohuaꞌi cato siꞌaye ëjaohuaꞌirepa deꞌocohuaꞌi aꞌë. Cuiꞌne i̱ohuaꞌi meñe acohuaꞌipi ëjaohuaꞌire paꞌë, cuasajë i̱ohuaꞌini caꞌrajëna, paꞌicohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mësaru cato yeque yoꞌoye paꞌiji. Pa̱i ëjaë pasiꞌi, cani yecohuaꞌini necaiquë paꞌiye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Cuiꞌne ai jerepa duꞌru aquë pasiꞌi cani siꞌaohuaꞌire necaiquëpi joꞌyaë paꞌijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Yëꞌë Pa̱i Mamaquë daimaꞌë paëꞌë, pa̱ipi necaija̱jë caquë. Yëꞌëpi pa̱ini necasiꞌi caquë daëꞌë. Yëꞌë ju̱ꞌi doꞌipi siꞌaohuaꞌire huasoyere caquë daëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jericó daripëna ti̱ꞌasicohuaꞌipi i̱ti daripëpi etareña, Jesús cuiꞌne i̱ yeꞌyacohuaꞌi cuiꞌne jai pa̱i co̱ni. Ja̱ro eta hue̱ꞌñare Bartimeo ñamaꞌquëpi da saicohuaꞌini curiquë se̱i ñuquëña, Timeo mamaquëpi. ");
INSERT INTO seyNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ñuꞌiquëpi Jesús Nazaret aquëpi daiji asani cui huëouña: “¡Jesús David mamaquë, yëꞌë macare co̱caijë̱ꞌë! ¡Ai yoꞌoyë!” ");
INSERT INTO seyNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Caquëna, pa̱ipi pë̱ijë i̱te careña: “Camaꞌë paꞌijë̱ꞌë.” Cajëna, ai jerepa tutu ca co̱uña: “¡David mamaquë yëꞌëre oi necaijë̱ꞌë! ¡Ai yoꞌoyë!” ");
INSERT INTO seyNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Caquëna, asani Jesupi caëña: “Daijë̱ꞌë cajë̱ꞌë, i̱te.” Caëna, ñamaꞌquëre careña: “Ai pequë maca huëni saijë̱ꞌë, i̱ quëꞌrona. Mëꞌëre soiji, i̱pi.” ");
INSERT INTO seyNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Carena, esa i̱ ë̱mëjeꞌe juꞌicore se dutani Jesús quëꞌrona saquëña, tsoe nëiñe peoyerepa. ");
INSERT INTO seyNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús quëꞌrona saquëna, caëña, i̱te: “¿Me necaiyete yëquëꞌni, mëꞌë?” Caquëna, ñamaꞌquëpi caëña, i̱te: “Ëjaë, yëꞌë deꞌoye ñañere yëyë.” ");
INSERT INTO seyNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Caquëna, Jesupi i̱te caëña: “Deꞌoji, deꞌhue jujuquë api cuasato jujucasiꞌi, mëꞌëre.” Ca macarepa sëtani ñaëña. Ñani Jesús ja̱ꞌre saquëña. ");
INSERT INTO seyNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jerusalén jaꞌye macana ti̱ꞌani Olivos cu̱tihuë je̱ꞌñerepa daripë̱a Betfagé cuiꞌne Betania daripë̱are paꞌi Jesupi cayaohuaꞌire i̱ yeꞌyacohuaꞌire jëjo saouña. ");
INSERT INTO seyNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ñeje caquë: “Je te̱ꞌte aꞌri daripëna sani ti̱ꞌa maca mësaru ñajaꞌcohuaꞌi aꞌë, burro po̱sëre papi pa̱ireje̱ hueꞌemaꞌquëni, sëasiquëni. Nëina, joyeni dajë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","¿Yecohuaꞌipi me neñuꞌju sayeꞌni? cacohuaꞌi paꞌito cajë̱ꞌë: ‘Ëjaëpi cusiꞌi caquëna, sayë. Cuni tëjini je̱o daija̱ꞌcohuaꞌi aꞌë,’ cajë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Caëna, sani burrore ti̱ꞌareña, maꞌare sëasiquëpi hueꞌsere nëina, caca saꞌro yëꞌquë macare. Ñani i̱te joyereña. ");
INSERT INTO seyNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Joyejëna, i̱ti maca paꞌicohuaꞌipi careña: “¿Me nejaꞌquëni burrore sayeꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Cajëna, Jesús caseꞌeje̱ careña. Cajëna, deꞌoji. Sajë̱ꞌë, careña. ");
INSERT INTO seyNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Carena, Jesús quëꞌrona burrore dareña. Dani i̱ohuaꞌi ca̱ñapi burro jetena jajereña. ");
INSERT INTO seyNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mëni jaꞌruna jai pa̱i i̱ohuaꞌi ca̱ñapi, i̱ sai maꞌana jaje o̱ereña. Yecohuaꞌipi jaiye jaꞌo tëteni da o̱ereña, i̱ sai maꞌana. ");
INSERT INTO seyNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Duꞌru saicohuaꞌipi cuiꞌne jeteyoꞌje saicohuaꞌipi sihuajë cuireña: “Deꞌoquërepa daiji, Maijaꞌquë jëjo daoquë. ");
INSERT INTO seyNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","I̱ cua̱ñe maca jerepa deꞌoye pasio. Mai ñecuë David maca cua̱ñe maca paꞌiseꞌeje̱ Maijaꞌquë ai deꞌoji.” ");
INSERT INTO seyNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jerusalénna cacani Maijaꞌquë huëꞌena sani cacani siꞌa huëꞌe ñani naꞌi huesëquëna, Betania quëꞌrona i̱ doce yeꞌyacohuaꞌi ja̱ꞌre co̱ni saquëña. ");
INSERT INTO seyNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ñatasi muꞌse Betaniapi saijëna, Jesure a̱i ëaëña. ");
INSERT INTO seyNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","A̲i ëaquëna, soꞌopi se̱ñaquë, higuera so̱quë yëpi jaꞌo quë̱i ñëpi nëcaoña. Nëcacona, i̱ti ca̱ paꞌimaꞌquë caquë saquëña. Sani ñaquëna, coa jaꞌoseꞌe paquëña, i̱ti quë̱imaꞌa tëcahuë sëte. ");
INSERT INTO seyNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Paꞌina, Jesús i̱ti ñëre caëña: “Yuretaꞌa pa̱i o̱cueye peosipi, mëꞌë quë̱iseꞌe.” Ja̱je caquëna, i̱ yeꞌyacohuaꞌipi asareña. ");
INSERT INTO seyNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ja̱ jeteyoꞌje Jerusalén ti̱ꞌani, Jesús Maijaꞌquë huëꞌena cacani coꞌamaña huerojë cuiꞌne coꞌamaña i̱sicohuaꞌire eto saoña. Curiquë cambia mesaña jëꞌje ta̱ño sauña. Cuiꞌne suꞌtere i̱sicohuaꞌi ñuꞌi sai jëꞌje ta̱ño sauña. ");
INSERT INTO seyNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Maijaꞌquë huëꞌena coꞌamañare saye ë̱seiña. ");
INSERT INTO seyNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ë̲seni yeꞌyaquë caëña: “Toya pëpë caji: ‘Yëꞌë huëꞌe cato siꞌa pa̱i Maijaꞌquëre se̱ huëꞌe hueꞌyoye paꞌiji.’ Ja̱je paꞌiquëtaꞌare mësaru cato coꞌamaña ñacohuaꞌi tuꞌaro neni yoꞌoyë.” ");
INSERT INTO seyNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ja̱je caquëna, asani Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌipi cuiꞌne cua̱ñeseꞌe yeꞌyacohuaꞌipi Jesure huani je̱oñere careña: ¿Me huani je̱ojaꞌcohuaꞌi aꞌni? cajë. Yecohuaꞌi cato airepa deꞌoye yeꞌyaquëꞌni cuasareña. Ja̱ doꞌire ëjaohuaꞌipi Jesure caꞌrajë huani je̱oñere careña. ");
INSERT INTO seyNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ñami deꞌoquëna, Jesús pa̱i daripëpi ti̱rona saquëña. ");
INSERT INTO seyNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ñatasi muꞌse nea hue̱ꞌña saijë ñajëna, higuera so̱quë yë tsoe sucua mañaque cue̱ne huesësicopi paꞌiona, ñareña. ");
INSERT INTO seyNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ñani ja̱ maca Pedro, Jesús caseꞌere cuasa ñajani caëña, i̱te: “Yeꞌyaquë ñajëꞌë, mëꞌë casi ñëre, tsoe cue̱ne huesësico paꞌico.” ");
INSERT INTO seyNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Caquëna, Jesupi i̱ yeꞌyacohuaꞌire caëña: “Nequëre papi cuasajë̱ꞌë, Maijaꞌquëre. ");
INSERT INTO seyNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nuñerepa cayë, mësarute. Iye cu̱tihuëre tsiayana jëjo saoye yëni Maijaꞌquëre nequë api cuasani se̱to neñe paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nuñerepa cayë, Maijaꞌquëre se̱ni i̱sija̱ꞌquë api cuasato i̱siye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Maijaꞌquëre se̱ maca yequere sa̱ñope yoꞌoye pacohuaꞌi paꞌini sa̱i deꞌhuacaijë̱ꞌë, Maijaꞌquë maꞌtëmo aquëpi mësaru coꞌaye tayo yoꞌoseꞌe sa̱i deꞌhuacaija̱ꞌquëre. ");
INSERT INTO seyNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ja̱je paꞌiquëtaꞌare mësarupi sa̱i deꞌhuacaimaꞌcohuaꞌi paꞌito mësaru jaꞌquë maꞌtëmo paꞌiquëje̱ mësaru tayoseꞌe sa̱i deꞌhuacaiye pa̱sipi.” ");
INSERT INTO seyNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ja̱ maca Jerusalénna coꞌireña. Coꞌini Jesús Maijaꞌquë huëꞌeja̱ꞌa cuꞌina, Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌipi cuiꞌne cua̱ñeseꞌe yeꞌyacohuaꞌipi cuiꞌne aiohuaꞌipi Jesús quëꞌrona dani ");
INSERT INTO seyNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","i̱te se̱teña: “¿I̱que cua̱ñeñepi iye mëꞌë yoꞌoquëꞌni? ¿Nepi mëꞌëre cua̱ñequë ëjaëre carena, yoꞌoquëni?” ");
INSERT INTO seyNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Cajëna, Jesupi caëña: “Yëꞌëje̱ mësarute se̱siꞌi teꞌore. Mësarupi yëꞌë se̱ñere sehuorena, yëꞌëje̱ quëasiꞌi, yëꞌëre cua̱ñequëre jëjo daoquëre. ");
INSERT INTO seyNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Nepi Juan i̱ti doquëre jëjo daoreꞌni, Maijaꞌquë pa̱nitaꞌa pa̱i? Mësarupi sehuojë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ja̱je caëna, sa̱ꞌñe careña, ñeje: “Maipi Diusu jëjo daosiquë paꞌiji cato i̱pi sehuosipi ‘¿Ja̱je paꞌiquëtaꞌare mësaru me yoꞌojë i̱te care paji cajë asaye pa̱reꞌni?’ ");
INSERT INTO seyNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Cuiꞌne pa̱ipi cua̱ñesiquë paꞌiji cayeje̱ pa̱ñuꞌu.” Siꞌa pa̱i Juanre Maijaꞌquë cocare quëaquë pajiꞌi, cuasa doꞌire caꞌrajë. ");
INSERT INTO seyNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ja̱je cani Jesure careña: “Huesëyë.” Cajëna, Jesupi caëña: “Cuiꞌne yëꞌëje̱, yëꞌë cua̱ñe tutu quëaye pa̱ñë.” ");
INSERT INTO seyNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ja̱ maca Jesús pa̱i yoꞌoyeje̱ paꞌye caquë quëaëña, ñeje: “Pajiꞌi, teꞌi pa̱i yeja paquë. Ja̱je paꞌipi ta̱pi, cuiyaꞌi. Ta̱ni tuꞌrihuë tëhuopi. Cuiꞌne cuiyaꞌi suni deꞌhuaja̱ꞌtoje̱ nepi. Cuiꞌne cuiyaꞌi tsio ë̱më huëꞌepi tuijë siꞌa tsio ñajaꞌcore nepi. Ja̱je siꞌaye ne tëjini coꞌamaña necaicohuaꞌini i̱si nëoni sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tëaye ti̱ꞌasi maca i̱ joꞌyare jëjo daopi, coꞌamaña necaicohuaꞌi quëꞌrona i̱te cajë necaiseꞌe paꞌiji, caquë. ");
INSERT INTO seyNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ja̱je jëjo daosiquëtaꞌare coꞌamaña necohuaꞌipi tse̱ani siꞌseni i̱simaꞌpë jëjo saohuë. ");
INSERT INTO seyNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ja̱je yoꞌorena, i̱ti tse̱ aquëpi yequëre jëjo saopi. Jëjo saouna, ja̱ëreje̱ quë̱na pë̱api je̱ahuë. Cuiꞌne si̱opëje̱ aꞌsi quëꞌire tea ju̱ꞌijë yoꞌoni jëjo saohuë. ");
INSERT INTO seyNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ja̱je yoꞌoruje̱ i̱ti tse̱ aquë ja̱ yëꞌtaꞌapi yequëre jëjo sao co̱pi. Jëjo saosiquëni ja̱ëni coa huani je̱ohuë. ");
INSERT INTO seyNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Jëjo saoquë pequë yuretaꞌa i̱ mamaquëre pani jëjo saopi, yëꞌë mamaquëre cato yoꞌoye peoji caquë. ");
INSERT INTO seyNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ja̱je caquë jëjo saosiquëtaꞌare coꞌamaña necohuaꞌipi ñani ‘iquëpi siꞌa coꞌamaña paja̱ꞌquë api huani je̱oni maipi i̱ti tse̱ acohuaꞌi neñuꞌu,’ cani huani je̱ohuë. ");
INSERT INTO seyNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ja̱je yoꞌoni tse̱ani huani je̱oni i̱ ca̱pë hueꞌsena je̱ocohuë.” ");
INSERT INTO seyNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ja̱je quëa tëjini Jesús se̱quëña: “¿Me yoꞌoja̱ꞌquë aꞌni, i̱ti yeja aquë?” Cani caëña, i̱ti yeja aquë cato dani, huani je̱ajaꞌquë api, coꞌamaña necohuaꞌire. Huani je̱oni yecohuaꞌina i̱sija̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Ñamaꞌcohuaꞌi aꞌni toya pëpë caye? Ñeje caji: Quë̱na pë̱a huëꞌe necohuaꞌi yoꞌo jujani je̱ocosi quë̱na pëpi yure cato huëꞌehuërepa u̱i quë̱na pë deꞌoye i̱ti quëco pacorepa. ");
INSERT INTO seyNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Iye cato ëjaëpi ja̱je yoꞌopi. Ja̱je yoꞌoseꞌere deꞌoyerepa yoꞌo uꞌni cajë ñañë, mai. ");
INSERT INTO seyNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Casi maca Jesure tse̱añuꞌu cajë yoꞌoreña. Jesupi yoꞌoseꞌeje̱ paꞌye caquë i̱ohuaꞌi yoꞌoyere caëna, asani pë̱ijë yoꞌoreña. Ja̱je yoꞌojëtaꞌa tse̱añe pa̱reña, pa̱ini caꞌrajë. Ja̱je paꞌina, yoꞌomaꞌpë pateña. ");
INSERT INTO seyNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ja̱ jeteyoꞌje Jesús quëꞌrona fariseo acohuaꞌire cuiꞌne Herodes acohuaꞌire jëjo daoreña, ja̱ohuaꞌipi i̱te neñajajë cajë. ");
INSERT INTO seyNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ja̱je daisicohuaꞌipi Jesure careña: “Yeꞌyaquë, yëquë asayë, mëꞌë nuñerepa caquëpi paꞌiye, pa̱i cayere asamaꞌquëpi nuñerepa Maijaꞌquë cocare caquëpi pa̱ire siꞌaohuaꞌire siꞌa yëꞌquë maca caquëpi paꞌiye. Ja̱je paꞌina, ¿deꞌoquë paꞌi doꞌire romano pa̱i ëjaëna sa̱iñe, pa̱nitaꞌa pa̱ñe?” ");
INSERT INTO seyNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Cajëna, Jesupi tsoe i̱ohuaꞌi coa caye asani caëña: “¿Me neñuꞌju yëꞌëre cosojë neñañuꞌu cajë cayeꞌni? Dajë̱ꞌë, curiquë tëꞌquire ñajaꞌcore.” ");
INSERT INTO seyNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Darena, Jesús ñani se̱quëña: “¿Ne tsiaꞌni ico? ¿Cuiꞌne, ne mamire toyasicoaꞌni?” Caquëna, sehuoreña: “Romano pa̱i ëjaë mamipi toyasicoa.” ");
INSERT INTO seyNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Cajëna, Jesupi caëña: “I̱ tse̱co paꞌito i̱na i̱sijë̱ꞌë. Maijaꞌquë tse̱co paꞌito Maijaꞌquëna i̱sijë̱ꞌë.” Ja̱je sehuouna, airepa deꞌoyerepa caëꞌni, cuasareña. ");
INSERT INTO seyNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Jesure ñañuꞌu cajë dateña, saduceo pa̱i acohuaꞌipi. Ja̱ohuaꞌi cato ju̱ꞌisicohuaꞌi huëiye peoji cacohuaꞌi pateña. Ja̱ohuaꞌipi careña, ñeje: ");
INSERT INTO seyNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Yeꞌyaquë, Moiséspi yëquëre toyani je̱ocaꞌa̱jiꞌi, majaꞌyëpi huejani mamajëre peoquë ju̱ꞌisiquë paꞌito yoꞌjeipi huejani mamajëre pacaiye paꞌiji, majaꞌyë doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Teꞌipi siete mamajë ë̱mëohuaꞌire paëña. Paquëna, ja̱ohuaꞌi aquë majaꞌyëpi huejani mamajëre peoquë ju̱jiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ju̱quëna, yoꞌjeipi huaꞌjeore huejapi. Ja̱ëje mamajëre peoquë ju̱jiꞌi. Ju̱quëna, yoꞌjeipi huejani cuiꞌne yoꞌopi. ");
INSERT INTO seyNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ja̱re ja̱jeseꞌe siꞌa tsëcapë huaꞌjeore huejajë ju̱ju sahuë, siꞌaohuaꞌi mamajëre peocohuaꞌi. Ja̱ jeteyoꞌje i̱oje ju̱coꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","¿Ja̱je paꞌito ju̱ꞌisicohuaꞌi huëi maca ne nëjo paꞌija̱ꞌcoaꞌni, teꞌoni siete pa̱irepa huejasico?” ");
INSERT INTO seyNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Cajëna, Jesupi sehuouña: “Mësaru coa tayo huesëjë cayë, Maijaꞌquë tuturepa cuiꞌne Maijaꞌquë toya pëpë ñamaꞌ doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ju̱ꞌisicohuaꞌipi huëisicohuaꞌi cato huejaye peoji. Mamajëre i̱siye peoji. Maꞌtëmo hui̱ñaohuaꞌije̱ paꞌiohuaꞌi paꞌija̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","¿Ju̱ꞌisicohuaꞌi huëiye ayere, toyaseꞌe mësaru ñamaꞌcohuaꞌi aꞌni, Moisés toyaseꞌe ja̱ropi caji, Maijaꞌquë aꞌri so̱quë yëpi toaje̱ paꞌio tsë̱ꞌisicopi caseꞌere? ‘Yëꞌë cato Abraham Diusu aꞌë, Isaac Diusu aꞌë, cuiꞌne Jacobo Diusu aꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Diusu cato ju̱ꞌisicohuaꞌi Diusu peoji, huajëcohuaꞌi Diusupi. Ja̱je paꞌiquëtaꞌare mësaru coa tayo huesëni yoꞌojë cayë.” ");
INSERT INTO seyNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Sa̱ꞌñe yoꞌojë cajëna, Jesupi siꞌaye tayomaꞌë sehuoquëna, asasiquëpi cua̱ñeseꞌe yeꞌyaquëpi ti̱tani se̱quëña: “¿Jeco aꞌni, duꞌru macarepa huëo maca cua̱ñesico jerepa paꞌio?” ");
INSERT INTO seyNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Caquëna, Jesupi caëña: “Duꞌru macarepa cua̱ñeseꞌe siꞌaye jerepa paꞌio cato caji: Israel pa̱i asajë̱ꞌë, mai Ëjaë Diusure. Ja̱ëseꞌe teꞌi paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Oijë̱ꞌë, Ëjaë Diusure siꞌa mëꞌë yëyepi, siꞌa mëꞌë joyopi, siꞌa mëꞌë cuasayepi cuiꞌne siꞌa mëꞌë tutupi. Ja̱je caji, cua̱ñeseꞌe duꞌru macarepa aye siꞌaye jerepa paꞌye. ");
INSERT INTO seyNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Cayaye acoje̱ ja̱re cuiꞌne paꞌio. Ja̱opi caji ñeje: ‘Oijë̱ꞌë, mëꞌë quë̱no maca paꞌiquëre mëꞌëjaꞌa coꞌye oiyeje̱ paꞌye.’ Yeque jerepa paꞌye peoji.” ");
INSERT INTO seyNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ja̱je sehuouna, cua̱ñeseꞌe yeꞌyaquëpi caëña: “Deꞌoyerepa cahuë, mëꞌë yeꞌyaquë. Peore paji, yequë Diusu. Teꞌi paꞌiji, Diusu. Nuñerepa cahuë, mëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ja̱je paꞌina, Maijaꞌquëre siꞌa më yëye oiyepi siꞌaye më asaye oiyepi cuiꞌne siꞌa joyo oiyepi cuiꞌne siꞌa tutu oiyepi, cuiꞌne mai quë̱no maca paꞌiquëre coꞌye oiyeje̱ paꞌyepi, ja̱ oiyepi jerepa paꞌye aꞌë, Maijaꞌquëre i̱siye, cuiꞌne ëojë se̱ñe jerepa.” ");
INSERT INTO seyNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Siꞌaye nuñerepa caquëna, Jesupi ñani caëña: “Mëꞌëre Maijaꞌquë cua̱ñe te̱ꞌte soꞌore paꞌiye pa̱ji.” Ja̱je caëna, asani yecohuaꞌije̱ i̱te se̱ni co̱ñe pa̱reña, siꞌaye asaquë api cajë. ");
INSERT INTO seyNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Maijaꞌquë huëꞌena yeꞌyaquë Jesús caëña: “¿Me yoꞌojë cua̱ñeseꞌe yeꞌyacohuaꞌi Cristo cato David mamaquë api cayeꞌni? ");
INSERT INTO seyNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David ja̱re i̱pi capi. Maijaꞌquë joyopi quëaquëna, ñeje capi: Ëjaëpi capi, yëꞌë Ëjaëre: ‘Yëꞌë ëja te̱ꞌtena jaꞌrujë̱ꞌë, yëꞌëpi mëꞌëre sa̱ñope yoꞌocohuaꞌire mëꞌë quë̱o huëꞌehuëna tëꞌya me macaja̱ꞌa.’ ");
INSERT INTO seyNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Ja̱je paꞌito me Cristo David mamaquë paꞌiquëꞌni, Davidpi Cristore yëꞌë ëjaë hueꞌyoto?” Ja̱je caquëna, jai pa̱i tsiꞌsisicohuaꞌipi ai yëjë asareña. ");
INSERT INTO seyNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesupi caëña, i̱ yeꞌya maca: “Deꞌhua ñajëꞌë, cua̱ñeseꞌe yeꞌyacohuaꞌi yoꞌoye yeꞌyemaꞌpë. Ja̱ohuaꞌi cato tsoa ca̱ña su̱ñani cuiꞌne pa̱ipi deꞌoye pëpaja̱jë cajë yoꞌocohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ja̱ohuaꞌi cato deꞌo ñuꞌi saire pa̱i tsiꞌsi hue̱ꞌñana coꞌeni jaꞌrucohuaꞌi aꞌë, cuiꞌne deꞌo hue̱ꞌñana a̱oje a̱icohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Huaꞌjeohuaꞌi huë̱ꞌña jiojë yoꞌocohuaꞌi aꞌë. Pa̱ipi deꞌocohuaꞌire paꞌë caja̱jë cajë tsoaye Maijaꞌquëre se̱ñë cajë yoꞌocohuaꞌi aꞌë. Ja̱ohuaꞌi aꞌë, i̱ti jerepa siꞌse cua̱ñojaꞌcohuaꞌi, ja̱je yoꞌosi doꞌire.” ");
INSERT INTO seyNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesús Maijaꞌquë huëꞌere paquëña, Maijaꞌquëna curi i̱si mahuë je̱ꞌñere pare. Ja̱rote ñuꞌi ñaquëna, jaiye curi pacohuaꞌi daijë i̱ti mahuëna ayareña. ");
INSERT INTO seyNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ayajëna, ñaquë ñuꞌina, huaꞌjeo maca curiquë peocopi dani caya cobre të̱ꞌñare ayaoña, jai doꞌi peoyere. ");
INSERT INTO seyNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ja̱je ñani i̱ yeꞌyacohuaꞌire soini caëña: “Nuñerepa cayë, mësarute. Ja̱o huaꞌjeo coꞌamaña peocopi siꞌaohuaꞌi curi ayaye jerepa ayao doꞌi quëꞌyerepa. ");
INSERT INTO seyNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Yecohuaꞌi cato i̱ohuaꞌi huero jujaseꞌere i̱siyë. Ja̱je paꞌiquëtaꞌare ico cato peocopi siꞌa mañare i̱si sao.” ");
INSERT INTO seyNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Maijaꞌquë huëꞌepi Jesús eta maca i̱ yeꞌyaquëpi caëña: “¡Yeꞌyaquë, iye quë̱na pë̱are ñajëꞌë, cuiꞌne jai huë̱ꞌñare!” ");
INSERT INTO seyNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ja̱je caquëna, Jesupi sehuouña: “¿Jai huë̱ꞌñare ñaquë caquë? Ja̱ mëꞌë ñaseꞌe yequë muꞌse, peo ja̱ꞌñe aꞌë. Quë̱na pë̱api tu̱ñajë neseꞌe siꞌaye nejo ja̱ꞌñe aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ja̱ maca Maijaꞌquë huëꞌe je̱ꞌñere pare Olivos cu̱tihuë paꞌicona sani Jesús jaꞌrusiquëpi ñuꞌina, Pedro, Jacobo, Juan cuiꞌne Andrés co̱ni pa̱i asamaꞌtona se̱teña: ");
INSERT INTO seyNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Je yëhua ja̱je yoꞌo ja̱ꞌñere mëꞌë caëꞌni, yëquëre quëajë̱ꞌë. ¿Me paꞌija̱ꞌcoaꞌni, i̱ti yoꞌo i̱ño ja̱ꞌñe ja̱ yoꞌoye ti̱ꞌa maca?” ");
INSERT INTO seyNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Cajëna, Jesupi sehuouña: “Deꞌhuarepa ñajë paꞌijë̱ꞌë, mësarute coa cosojëna, sehuoye. ");
INSERT INTO seyNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Jai pa̱i yëꞌë mamire cajë ‘yëꞌë aꞌë, Cristo’ caja̱ꞌcohuaꞌi aꞌë. Ja̱je cajë coa cosojëna, sehuoja̱ꞌcohuaꞌi aꞌë, jai pa̱i. ");
INSERT INTO seyNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ja̱je paꞌiquëtaꞌare mësarupi huajo coca cuiꞌne uihuaye asacohuaꞌi pani quëquëmaꞌpë paꞌijë̱ꞌë. Ja̱ cato ja̱re ja̱je yoꞌoye paꞌina, yoꞌoji. Ja̱je yoꞌonije ja̱ yëꞌtaꞌa caraja̱iñe peosipi. ");
INSERT INTO seyNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Yequë pa̱i tsëcapëpi yequë tsëcapëre se uihuaja̱ꞌcohuaꞌi aꞌë. Cuiꞌne yequë yeja pa̱ipi se uihuaja̱ꞌcohuaꞌi aꞌë. Siꞌa hue̱ꞌña yeja ñuꞌcueye paꞌija̱ꞌcoa. Cuiꞌne a̱opi peoquëna, a̱i ëa ju̱ꞌijaꞌcohuaꞌi aꞌë. Cuiꞌne ai yoꞌoyepi pasipi. Iye pasipi, duꞌru macarepa ai yoꞌoye. ");
INSERT INTO seyNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Deꞌhua mësaruja̱ꞌa coꞌye deꞌoye ñajëꞌë. Mësarute cato pa̱ipi tse̱ani pa̱i ëjaohuaꞌina i̱sija̱ꞌcohuaꞌi aꞌë. Ja̱ohuaꞌipi cua̱ñejëna, mësarute pa̱i tsiꞌsi hue̱ꞌñana siꞌsejë yoꞌoja̱ꞌcohuaꞌi aꞌë. Ja̱je yoꞌojëna, mësarupi yëꞌë doꞌire i̱ñojaꞌcohuaꞌi aꞌë cua̱ñecohuaꞌi cuiꞌne siꞌa pa̱i ëjaohuaꞌi ña hue̱ꞌñana. ");
INSERT INTO seyNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ja̱ yëꞌtaꞌa caraja̱imaꞌnë deꞌo cocare quëaye paꞌiji, siꞌa hue̱ꞌña. ");
INSERT INTO seyNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mësaruni ëjaohuaꞌi quëꞌrona sasicohuaꞌi paꞌito ¿me caja̱ꞌcohuaꞌi aꞌni? cuasamaꞌpë paꞌijë̱ꞌë. Cajë̱ꞌë, Maijaꞌquë i̱si cocapi, ja̱ maca cato. Ja̱je paꞌina, mësarupi caye pa̱jaꞌcohuaꞌi aꞌë, Maijaꞌquë joyopi caja̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Teꞌe tsëcapë acohuaꞌipi yoꞌjeire pa̱nitaꞌa majaꞌyëre quëa yehuoja̱ꞌcohuaꞌi aꞌë huani je̱ojëꞌë, cajë. Pëca jaꞌquëohuaꞌipi mamajëre quëa yehuoja̱ꞌcohuaꞌi aꞌë, cuiꞌne mamajëpi pëca jaꞌquëohuaꞌire sa̱ñope yoꞌojë huani je̱ojaꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Siꞌa pa̱i mësarute coeja̱ꞌcohuaꞌi aꞌë, yëꞌë doꞌire. Ja̱je paꞌiquëtaꞌare yoꞌo jujamaꞌquëpi huaso cua̱ñojaꞌquë api nuñerepa yoꞌoquëpi. ");
INSERT INTO seyNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Maijaꞌquëre quëacaiquë Daniel toyaquë paꞌa̱jiꞌi, siꞌsi nequëpi cuiꞌne coa nejoquëpi siꞌsi paꞌimaꞌtore paꞌina, ñani Maijaꞌquë toya jaꞌo ñaquëpi asa ti̱ꞌañe paꞌiji. Ja̱ maca Judea paꞌicohuaꞌipi ai cu̱tihuë̱ana catiye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ja̱ muꞌse huëꞌe ë̱mëjeꞌe totore paꞌiquë pani cajeni cacani coꞌamañare sasiꞌi caquë yoꞌomaꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tsiore paꞌiquë pani coꞌini ca̱ña sasiꞌi caquë yoꞌomaꞌë paꞌijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ja̱ muꞌseña nomiohuaꞌi tsi̱ ë̱tapë̱a paꞌicohuaꞌi cuiꞌne tsi̱ mañare pacohuaꞌi ai yoꞌoja̱ꞌcohuaꞌi aꞌë, teaye. ");
INSERT INTO seyNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mësaru cato Maijaꞌquëni se̱jëꞌë, sësë muꞌseña catiye peoja̱ꞌcore. ");
INSERT INTO seyNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Siꞌaye ai yoꞌoye tëto saiseꞌerepa paꞌija̱ꞌcoa. Ja̱ muꞌseña cato ai coꞌa muꞌseña pasipi, yeja deꞌhua maca peopi. Cuiꞌne jeteyoꞌje peosipi, ja̱ jerepa ai yoꞌoye. ");
INSERT INTO seyNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ja̱ muꞌseña Ëjaëpi ja̱ yoꞌoye tëamaꞌquë paꞌito teꞌije̱ jëaye peoꞌñe paꞌio. Ja̱je paꞌiquëtaꞌare i̱ sahuasicohuaꞌini i̱ pa̱ini caquë ja̱ ai yoꞌoyere tëaquëna, yecohuaꞌije̱ co̱ni jëaja̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Mësarute yecohuaꞌipi ‘i̱ñore paꞌiji, Cristo ñajëꞌë,’ cacohuaꞌi paꞌito asamaꞌpë paꞌijë̱ꞌë, pa̱nitaꞌa ‘Jetore paꞌiji.’ Catoje̱ sehuomaꞌpë paꞌijë̱ꞌë, i̱ohuaꞌi caye. ");
INSERT INTO seyNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Coa cacohuaꞌi daija̱ꞌcohuaꞌi aꞌë. Yëꞌë aꞌë, Cristo cacohuaꞌi, cuiꞌne Maijaꞌquë cocare quëacohuaꞌi aꞌë cacohuaꞌije̱ daija̱ꞌcohuaꞌi aꞌë. Ja̱ohuaꞌipi pa̱i yoꞌo ti̱ꞌa maꞌñere yoꞌo i̱ñojaꞌcohuaꞌi aꞌë, coa cosoñuꞌu cajë. Ja̱je yoꞌojëna, Maijaꞌquërepa sahuasicohuaꞌique ja̱ohuaꞌire sehuoye jaꞌi maca yoꞌoja̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ja̱je paꞌina, mësarute duꞌru quëa nëohuë deꞌoye ñajë paꞌijë̱ꞌë, caquë. ");
INSERT INTO seyNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ja̱je ai yoꞌo muꞌseña tëto saisi maca yuretaꞌa, ë̱sëpi yaya huesëja̱ꞌquë api. Ñañëje miañe pa̱jaꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Maꞌñocoje̱ maꞌtëmopi to̱mejaꞌcohuaꞌi aꞌë. Ja̱je yoꞌo maca maꞌtëmo tuture paque tsasija̱ꞌcoa. ");
INSERT INTO seyNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ja̱ maca sirija̱ꞌa tutu quëꞌire papi cuiꞌne deꞌoquëre papi Pa̱i Mamaquë daija̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ja̱ jeteyoꞌje i̱ hui̱ñaohuaꞌire cua̱ñesipi, i̱ sahuasicohuaꞌire cajeseꞌe tutu jupë̱api i̱ pa̱ire tsiꞌsojë̱ꞌë, caquë siꞌa hue̱ꞌña paꞌicohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Higuera so̱quë yë yoꞌoye ayere yeꞌyejë̱ꞌë. Ja̱ so̱quë yë cato hui̱ña capë̱a paꞌi maca je̱ꞌnërepa jaꞌo eta huëocoa. Eta maca ñani cacohuaꞌi aꞌë, utëcahuë ti̱ꞌaji. ");
INSERT INTO seyNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ja̱ yoꞌoyeje̱ paꞌye mësarupi ñajëna, yëꞌë caseꞌepi ti̱ꞌaquë tëto saina, ñajë je̱ꞌnë jaꞌyere eta saꞌrore paꞌiji cayë. ");
INSERT INTO seyNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nuñerepa cayë, ja̱ yëꞌtaꞌa iye maca paꞌicohuaꞌi ju̱ꞌimaꞌnë tëto saija̱ꞌcoa, iye. ");
INSERT INTO seyNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Maꞌtëmo cuiꞌne yeja pani jujani caraja̱i ja̱ꞌñe aꞌë. Ja̱je paꞌiquëtaꞌare yëꞌë coca cato yëꞌë caseꞌeje̱ ti paꞌi ja̱ꞌñe aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","I̱ti muꞌse cuiꞌne hora pa̱i huesëyë. Hui̱ñaohuaꞌije̱ cuiꞌne Maijaꞌquë mamaquëje̱ huesëji. Siꞌaohuaꞌi huesëyë. Coa jaꞌquëseꞌe asaji, i̱ti muꞌse. ");
INSERT INTO seyNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ja̱je paꞌi doꞌire, mësaru cato siꞌanë sëtasicohuaꞌije̱ paꞌiohuaꞌipi ñajë se̱jë paꞌijë̱ꞌë, i̱ dai hora huesëye sëte. ");
INSERT INTO seyNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yëꞌë dai maca cato teꞌi soꞌona sai huëoni ja̱ yëꞌtaꞌa huëꞌepi saimaꞌnë i̱ joꞌyare pa̱i ñapere coꞌamaña yoꞌo ja̱ꞌñe i̱sini cuiꞌne eta saꞌro ñacaiquëre cua̱ñeni ñajëꞌë cani saiseꞌeje̱ paꞌiye aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ja̱je paꞌina, mësaru cato sëtasicohuaꞌipi paꞌijë̱ꞌë, coa siꞌanëpi, i̱ti huëꞌe aquë ti̱tayere huesëye sëte. Naꞌi maca, ñami jopo, muꞌse, cura yëꞌi maca, pa̱nitaꞌa nea hue̱ꞌña daimaꞌquëni cajë. ");
INSERT INTO seyNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Yoꞌojëna, cuasamaꞌtopi ca̱isicohuaꞌini ti̱tamaꞌquëni deꞌhua ñajëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Iye mësarute caye cato siꞌa pa̱ire cayë: ‘Sëtasicohuaꞌipi paꞌijë̱ꞌë,’ caquë.” ");
INSERT INTO seyNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Israel pa̱i Egíptopi etajë paꞌiseꞌere cuasajë yoꞌoye, cuiꞌne oꞌsa peo pan a̱iñe caya muꞌseña cara maca, Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌipi cuiꞌne cua̱ñeseꞌe yeꞌyacohuaꞌipi merepa Jesure coa cosojë tse̱ani huani je̱oraꞌye cajë. I̱ti yoꞌo ja̱ꞌñere coꞌehuë. ");
INSERT INTO seyNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Careña, cuiꞌne pa̱i tsiꞌsini sihuajë yoꞌo maca huaiye pa̱ñuꞌu, coꞌaye pa̱ipi cuasa co̱ꞌme huesëni sa̱ñope ai yoꞌojë camaꞌcohuaꞌini, careña. ");
INSERT INTO seyNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús Betania daripëre paquëña, Simón ja̱ꞌju dahuë hueꞌequë paꞌisiquë huëꞌere, mesare ñuquëña, Jesús. Ñuꞌina, teꞌo nomio jai doꞌi huëo së̱ daꞌcare quë̱na huëna ti̱mësiconi dani Jesús si̱opëna i̱ti daꞌcapi dooña. Nardo daꞌcaseꞌe nesicopi, yequeje̱ co̱ꞌmemaꞌcopi. ");
INSERT INTO seyNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","I̱ti maca ñuꞌicohuaꞌipi pë̱ti huëoreña. Ja̱je pë̱ti huëojë careña: “¿Me yoꞌoco huëo së̱ daꞌca coa nejocoꞌni? ");
INSERT INTO seyNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","I̱opi yecohuaꞌina se i̱sico pani trecientos romano curiquë të̱ꞌña neraꞌo. Ja̱je yoꞌoni coꞌamaña peocohuaꞌire co̱catiraꞌo.” Ja̱je cajë i̱ote coejë pë̱ijë ñareña. ");
INSERT INTO seyNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ja̱je ñajëna, Jesupi caëña: “Coa ñajëꞌë, i̱oseꞌe yoꞌoja̱ꞌco. ¿Me yoꞌojë jo̱sa cayeꞌni? Iye i̱o yëꞌëre necaiseꞌe cato deꞌo coꞌamañaꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Coꞌamaña peocohuaꞌire siꞌanë mësaru ñajë paja̱ꞌcohuaꞌi aꞌë. Ja̱je paꞌiquëtaꞌare yëꞌë cato mësaru ña hue̱ꞌñare siꞌanë paꞌiye pa̱jaꞌquë aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","I̱o cuasaye jaꞌi maña ico cato deꞌhue yëꞌë si̱opë huëo së̱ñe necacoꞌë, duꞌruna yëꞌëre ta̱ ja̱ꞌñere caco. ");
INSERT INTO seyNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nuñerepa cayë, coa siꞌa hue̱ꞌña ico yoꞌoseꞌe quëaye paꞌija̱ꞌcoa, i̱o yoꞌoseꞌe hua̱nëyemaꞌpë cuasa ja̱ꞌñere cajë, huaso coca quëa maca.” ");
INSERT INTO seyNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariotepi sani Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌi ja̱ꞌre co̱ni coca caëña, Jesure tse̱ani i̱ohuaꞌina i̱si ja̱ꞌñere. Ja̱ë cato doce yeꞌyacohuaꞌi aquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ja̱je caquëna, asani ai sihuareña. Ja̱je sihuajë curiquë i̱sireña. I̱sirena, Judaspi ¿Jesure merepa tse̱ani i̱sija̱ꞌquë aꞌni? caquë i̱ yoꞌo ja̱ꞌñere coꞌeiña. ");
INSERT INTO seyNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Egíptopi Israel pa̱i etajë paꞌiseꞌere cuasajë sihuajë pa̱i tsiꞌsini, tsoe yoꞌojë paꞌiseꞌeje̱ yoꞌo muꞌse ti̱ꞌaëña, oꞌsa co̱ꞌme maꞌa a̱o a̱i muꞌse. Duꞌru muꞌserepa, cuiꞌne yëi ñamare huai muꞌserepa ti̱ꞌaëña. Ja̱je ti̱ꞌaëna, Jesús yeꞌyacohuaꞌipi se̱teña: “¿Egíptopi Israel pa̱i etajë paꞌiseꞌere cuasajë, a̱iñe jerona sani ne deꞌhuarena a̱iñe yëquëꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Cajëna, Jesupi cayaohuaꞌire i̱ yeꞌyacohuaꞌire jëjo saoquë caëña: “Jai pa̱i daripëna sani oco yurupë saquëni ti̱ꞌani i̱ ja̱ꞌre saijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Sani ja̱ꞌre sa cacajë cajë̱ꞌë i̱te huëꞌe aquëre: ‘Yeꞌyaquëpi capi: ¿Jerore paꞌicoꞌni, tuꞌrihuë yëꞌë yeꞌyacohuaꞌi ja̱ꞌre naꞌiquëna a̱ijaꞌco, Egíptopi Israel pa̱i etaseꞌere cuasajë? cajë̱ꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","I̱pi mësarute i̱ñojaꞌquë api, jai tuꞌrihuëpi tsoe ne deꞌhuasiconi. Ja̱rona yuretaꞌa ñani ne deꞌhuajë̱ꞌë, mai tse̱.” ");
INSERT INTO seyNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","I̱ yeꞌyacohuaꞌipi sani ti̱ꞌareña, jai daripë. Ti̱ꞌani ja̱re Jesús quëaseꞌeje̱ siꞌaye ti̱ꞌareña. Ti̱ꞌani naꞌiquëna, a̱i ja̱ꞌñe ne deꞌhuareña, Egíptopi Israel pa̱i etaseꞌere cuasajë yoꞌoyere. ");
INSERT INTO seyNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ñami deꞌosi maca Jesús i̱ doce yeꞌyacohuaꞌi ja̱ꞌre ti̱ꞌaëña, i̱ti hue̱ꞌña. ");
INSERT INTO seyNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ti̱ꞌani mesare ñuꞌi a̱iquëpi caëña, Jesús: “Nuñerepa mësarute cayë. Mësaru aquëpi yëꞌë ja̱ꞌre teꞌona a̱iquëpi i̱si yehuoja̱ꞌquë api.” ");
INSERT INTO seyNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ja̱je ca maca i̱ohuaꞌipi sa̱ꞌñe i̱ohuaꞌija̱ꞌa se̱teña: “¿Yëꞌë paꞌija̱ꞌquë aꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Cajëna, Jesupi caëña: “Doce aquëpi yoꞌoja̱ꞌquë api, yëꞌë ja̱ꞌre teꞌe quë̱na deꞌhuana a̱iquëpi. ");
INSERT INTO seyNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ja̱je paꞌitoje̱ deꞌoji. Pa̱i Mamaquë cato ja̱re i̱ti toyaseꞌe paꞌiyeje̱ saiji. Ja̱je paꞌiquëtaꞌare ¡Teayerepa yoꞌoja̱ꞌquë api, i̱te i̱si yehuoquëtaꞌa! I̱pi ai deꞌoye pa̱siquë paꞌito deꞌoraꞌpi, ja̱ëte.” ");
INSERT INTO seyNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ja̱ yëꞌtaꞌa a̱ore a̱ijëna, Jesupi panpë i̱ni Maijaꞌquëre deꞌoji caquë se̱ni i̱ yeꞌyacohuaꞌire a̱oquë caëña: “A̲ijëꞌë. Iye cato yëꞌë ca̱pë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Jeteyoꞌje u̱cu duruhuë i̱ni Maijaꞌquëre deꞌoji, caquë se̱ni, i̱ yeꞌyacohuaꞌina i̱siña. I̱sina, siꞌaohuaꞌi u̱cureña, i̱ote. ");
INSERT INTO seyNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","U̲curena, caëña: “Iye cato yëꞌë tsie aꞌë. Jai pa̱i deꞌoye paꞌi ja̱ꞌñere caquë huajëye Maijaꞌquë pa̱ire cayere quëaye aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ja̱je paꞌina, mësarute nuñerepa cayë cuiꞌnaëpi iye, cuiyaꞌi oꞌsa co̱no u̱cuye pa̱jaꞌquë aꞌë. Yequë muꞌse Maijaꞌquë cua̱ñe te̱ꞌtena cuiyaꞌi oꞌsa u̱cuñuꞌu.” ");
INSERT INTO seyNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Jë̱jë tëjini Olivos cu̱tina sateña. ");
INSERT INTO seyNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesupi caëña, ja̱ohuaꞌire: “Siꞌaohuaꞌi mësaru yëꞌëre je̱ocoja̱ꞌcohuaꞌi aꞌë, iye ñami. Ja̱je paꞌina, toyaseꞌe caji: ‘Huani je̱ojaꞌquë aꞌë, yëi ñamare ñacaiquëre. Ja̱ maca yëi ñamapi tiya huesëja̱ꞌcohuaꞌi aꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ja̱je paꞌiquëtaꞌare ju̱ꞌisiquëpi huëisi maca yëꞌëpi duꞌru saija̱ꞌquë aꞌë, Galileana, mësaru ja̱ yëꞌtaꞌa saimaꞌpëna.” ");
INSERT INTO seyNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ja̱je caquëna, Pedropi caëña: “Ja̱je yecohuaꞌi mëꞌëre je̱ocotoje̱ yëꞌë cato mëꞌëre je̱oñe pa̱ñë.” ");
INSERT INTO seyNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Caquëna, Jesupi caëña: “Nuñerepa mëꞌëre cayë. Iye ñami ja̱ yëꞌtaꞌa cura cayaye yëꞌimaꞌnë mëꞌëpi toaso̱ñe cosoja̱ꞌquë aꞌë, i̱te ñamaꞌquë aꞌë caquë.” ");
INSERT INTO seyNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ja̱je Jesús caquëna, i̱pi caëña: “Yëꞌë cato pa̱ñë, cosoye. Ju̱ꞌiñe paꞌitoje̱ mëꞌë ja̱ꞌre ju̱ꞌijaꞌquë aꞌë.” Caquëna, yecohuaꞌije̱ cuiꞌne careña. ");
INSERT INTO seyNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Getsemaní hueꞌe hue̱ꞌñana ti̱ꞌani Jesús caëña, i̱ yeꞌyacohuaꞌire: “I̱ñore dujë paꞌijë̱ꞌë, yëꞌëseꞌe Maijaꞌquëre sani se̱siꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Cani coa Pedrore, Jacobore, cuiꞌne Juanre saëña. Ja̱ maca ai cuasaquë cuiꞌne ai yoꞌo huëouña. ");
INSERT INTO seyNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ja̱je yoꞌoquë caëña, ja̱ohuaꞌire: “Ai oi ëaye nëiji, yëꞌë joyore papi ju̱ni huesëye paꞌina. I̱ñona mësaru cato pëani sëtasicohuaꞌipi paꞌijë̱ꞌë, ca̱imaꞌpë.” ");
INSERT INTO seyNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Cani Jesús i̱seꞌe se̱ña maca sani yejana doꞌre jaꞌruni Maijaꞌquëre deꞌhue neñe paꞌito, necaijë̱ꞌë, ai yoꞌoye pa̱siꞌi, i̱ti yoꞌo maca ti̱ꞌaëna, caquë se̱quëña. ");
INSERT INTO seyNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ja̱je se̱i caëña: “Yëꞌë jaꞌquë, mëꞌëre cato siꞌaye neñeseꞌe paꞌiji. Nejocaijë̱ꞌë, yëꞌëre ai yoꞌoye ne ja̱ꞌñere. Yëꞌë yëye peoja̱ꞌquë, coa mëꞌë yëyepi yoꞌoye paꞌija̱ꞌquë.” ");
INSERT INTO seyNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ja̱je se̱ni tëjini i̱ yeꞌyacohuaꞌi quëꞌrona sani ñaquëna, ca̱isicohuaꞌipi pateña. Paꞌijëna, Pedrore caëña: “¿Simón ca̱iquë, mëꞌë? ¿Teꞌe hora macaje̱ sëtasiquëpi ña ti̱ꞌañe pa̱ë, mëꞌë? ");
INSERT INTO seyNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Sëtasicohuaꞌipi paꞌijë Maijaꞌquëre se̱jëꞌë, coꞌayena ta̱iñe pa̱jaꞌcohuaꞌi. Nuñerepa joyo cato yoꞌoye yëji. Ja̱je paꞌiquëtaꞌare mëꞌë ca̱pëpi tutu peoji.” ");
INSERT INTO seyNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ja̱je cani ti̱jupë sani ja̱ꞌrë caseꞌeje̱ paꞌye caquë se̱quëña. ");
INSERT INTO seyNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ja̱ro cuiꞌnaëpi coꞌiquë cuiꞌne ca̱isicohuaꞌini ti̱ꞌapi i̱, yeꞌyacohuaꞌire. Airepa huëo ca̱ꞌquëna ñaco naimopi jameina ca̱ëꞌë, quëcoñuꞌu cajëtaꞌa. Ja̱je paꞌina, i̱te sa̱ñope sehuo ti̱ꞌañe peohuë. ");
INSERT INTO seyNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Toaso̱ñe acore saisiquëpi ti̱taquë caëña, ja̱ohuaꞌire: “Yuretaꞌa ca̱ni huajëjë̱ꞌë. Tsoe deꞌoji. Ja̱ jaꞌye ca̱ijëꞌë. Ti̱ꞌapi Pa̱i Mamaquëre coꞌaye yoꞌocohuaꞌi jë̱ñana i̱si maca. ");
INSERT INTO seyNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Huëijë̱ꞌë. Sañuꞌu. Yëꞌëre i̱si yehuoja̱ꞌquëpi daiji.” ");
INSERT INTO seyNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ja̱ yëꞌtaꞌa Jesús cocare i̱ yeꞌyacohuaꞌi ja̱ꞌre caquëna, Judaspi tsoe ti̱taëña. Ja̱ë cato doce acohuaꞌi aquë pajiꞌi. I̱ ja̱ꞌre co̱ni jai pa̱i huaꞌti ca̱jicohuaꞌipi cuiꞌne tara ca̱jicohuaꞌipi dateña. Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌipi, cua̱ñeseꞌe yeꞌyacohuaꞌipi cuiꞌne aiohuaꞌipi jëjo daocohuaꞌipi co̱ni daisicohuaꞌi pateña. ");
INSERT INTO seyNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas i̱ti i̱si yehuoja̱ꞌquëpi caëña, ja̱ohuaꞌire: “Yëꞌëpi i̱ni ti̱ꞌani sihuaja̱ꞌquë aꞌë. Sihuaquëna, ñani ja̱ëni tse̱ajëꞌë. Tse̱ani deꞌoye sëani sajë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ja̱je casiquëpi ti̱ꞌani Jesure tsioja̱ni caëña: “Yeꞌyaquë, Yeꞌyaquë.” Ja̱je caquë tsu̱ꞌsupi. ");
INSERT INTO seyNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tsu̱ꞌsuquëna, ja̱ maca Jesure to̱me dani tse̱ani sareña, sëasiquëni. ");
INSERT INTO seyNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ja̱je yoꞌo maca i̱ti maca paꞌiquëpi huaꞌti dutani Maijaꞌquë huëꞌe ñacaicohuaꞌi necaiquëni ca̱joroseꞌe tëto tëaëña. ");
INSERT INTO seyNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ja̱ maca Jesuje̱ caëña, i̱te tse̱a pa̱ire: “¿Tarapi hua̱ꞌñapi co̱ni date, yëꞌëre tse̱añuꞌu cajë coꞌamaña yahue i̱maquëre yoꞌoyeje̱ paꞌye? ");
INSERT INTO seyNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yëꞌë siꞌa muꞌseña Maijaꞌquë huëꞌepi paꞌi mësarute yeꞌyaquëna, mësarupi yëꞌëre tse̱añe pa̱huë. Ja̱je paꞌiquëtaꞌare iye cato toyaseꞌepi ti̱ꞌaquëna, ja̱je yoꞌoye paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ja̱ maca i̱ yeꞌyacohuaꞌipi Jesuseꞌere teꞌire je̱oni cati sateña. ");
INSERT INTO seyNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ja̱je paꞌiquëtaꞌare teꞌi tsi̱ po̱së macapi jai ca̱pi deasiquëpi tuquëña, Jesure. Tuina, tse̱areña. ");
INSERT INTO seyNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Tse̱arena, jai ca̱seꞌe je̱oni peoyo catiña. ");
INSERT INTO seyNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesure ja̱ maca sareña, Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaërepa quëꞌrona. Ja̱rona Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌi tsiꞌsireña, aiohuaꞌi, cuiꞌne cua̱ñeseꞌe yeꞌyacohuaꞌi co̱ni. ");
INSERT INTO seyNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ja̱je sajëna, Pedroje̱ soꞌo maca se ñaquë tuquëña, Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaërepa huëꞌe hueꞌse daripëre pana. Ja̱rona soldado pa̱i ja̱ꞌre co̱ni pëani toare cu̱i ñuquëña. ");
INSERT INTO seyNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌi cuiꞌne pa̱i yoꞌoye ca tëji ëjaohuaꞌire papi Jesure ja̱je yoꞌoquëre papi cayere coꞌereña, asani huani je̱oñere cajë. Ja̱je coꞌejëtaꞌa ti̱ꞌañe pa̱reña. ");
INSERT INTO seyNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Cuiꞌne jai pa̱i coa huëojë ti yoꞌo maꞌñere sa̱ñope Jesure careña, cosojë. Cuiꞌne i̱ohuaꞌija̱ꞌa sa̱ꞌñe yoꞌojë careña, teꞌe cayepi peoquëna. ");
INSERT INTO seyNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Yecohuaꞌipi coꞌarepa huëojë careña. ");
INSERT INTO seyNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Yëquëpi i̱ caye asasicohuaꞌi aꞌë, cajë yoꞌojë careña: “Ñeje caquë api, ‘yëꞌëpi Maijaꞌquë huëꞌe nejojaꞌquë aꞌë, pa̱i deꞌhuasi huëꞌe. Ja̱je yoꞌoni jeteyoꞌje tres muꞌseña paꞌi maca huajëcore nejaꞌquë aꞌë, pa̱ipi nemaꞌcore.’ Ja̱re asahuë.” ");
INSERT INTO seyNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ja̱je canije nuñerepa teꞌeje̱ paꞌye caye pa̱reña. ");
INSERT INTO seyNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ja̱ maca Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaëpi i̱ohuaꞌi ca jopoja̱ꞌa huëni nëcayepi Jesure se̱quëña: “¿Asaquë mëꞌë, mëꞌëre sa̱ñope caye? ¿Me yoꞌoquë sa̱ñope sehuoye pa̱quëꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Caquëna, Jesupi ai jerepa ti sehuoye pa̱ëña, i̱ caye. Ja̱je pa̱quëna, Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaëpi ti̱jupë Jesure se̱quëña, ñeje: “¿Mëꞌë Cristo, Maijaꞌquë deꞌoquërepa mamaquë aꞌë?” ");
INSERT INTO seyNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Caquëna, ja̱ maca Jesupi sehuouña: “Ja̱je paꞌijë̱ꞌë. Yëꞌë aꞌë. Cuiꞌne mësarupi Pa̱i Mamaquëre yëꞌëre ñajaꞌcohuaꞌi aꞌë, Diusu tutu quëꞌirepa ëja te̱ꞌtere ñuꞌina. Cuiꞌne Maꞌtëmopi sirija̱ꞌa nëca meina, ñajaꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ja̱je caquëna, asani Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaëpi i̱ juꞌi ca̱re coꞌye naë yeto saoquë caëña: “¿I̱quere cajë jerepa pa̱ire quëaja̱ꞌcohuaꞌire coꞌeyeꞌni, tsoe ti̱ꞌapi? ");
INSERT INTO seyNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ja̱re mësarupi asahuë, i̱ yëꞌopopi Maijaꞌquëre cueꞌcuequë caye. Ja̱je paꞌito ¿me cayeꞌni, mësaru?” Ja̱je caëna, yuretaꞌa siꞌa pa̱i careña: “Huani je̱oñe paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Casi maca je̱ꞌnërepa yecohuaꞌipi copi tseꞌse huëoreña. Cuiꞌne yecohuaꞌipi tsiana ca̱ñapi tëto que̱oni tëꞌcajë yoꞌojë careña: “¿Nepi tëꞌcareꞌni? Se ca ñajëꞌë.” Cajëna, soldado pa̱ije yoꞌoreña, i̱te. ");
INSERT INTO seyNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro cato huëꞌehuëre paquëña, hueꞌse daripëre. Ja̱rote paꞌina, Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaëre necaicopi ");
INSERT INTO seyNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","toare cu̱i ñuꞌina, ñani i̱te caoña: “I̱na, mëꞌëje Jesús Nazaret aquë ja̱ꞌre paꞌisiquë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Cacona, Pedropi caquë cosouña: “Ñamaꞌquë aꞌë, i̱te. ¿I̱quere ja̱je cacoꞌni? Huesëyë.” Ja̱je cani eta saꞌro quëꞌrona etaëña. Eta maca curapi yëquëña. ");
INSERT INTO seyNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaëre necaicopi ñani cuiꞌnaopi ca huëo co̱ña, i̱ti maca paꞌicohuaꞌina: “Iquë cato Jesús yeꞌyacohuaꞌi aquë api.” ");
INSERT INTO seyNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ja̱je catoje̱ i̱je cuiꞌnaëpi coso co̱uña, ñamaꞌquë aꞌë caquë. Aꞌri maña tsoe maca paꞌi maca Pedrore i̱ti maca paꞌicohuaꞌipi careña: “Mëꞌë Jesús yeꞌyacohuaꞌi aquëre paꞌë. Mëꞌë cato Galilea aquë aꞌë. Cuiꞌne mëꞌë coca cayeje̱ Jesús yeꞌyacohuaꞌi caye aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ja̱je caquëna, Pedropi yuretaꞌa sa̱ñope coꞌaye caquë, cuiꞌne ñamaꞌquë aꞌë care payë caquë capi: “¿I̱quere mësaru yoꞌojë cayeꞌni? Ñamaꞌquë aꞌë, ja̱ëte.” ");
INSERT INTO seyNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Caquëna, cuiꞌnaëpi cura yëni co̱pi. Ja̱je cura yëꞌi maca yuretaꞌa Pedro cuasa ñajajiꞌi, Jesús i̱te caseꞌe. Jesús cato caꞌa̱jiꞌi: “Ja̱ yëꞌtaꞌa cura cayaye yëꞌimaꞌëna mëꞌëpi toaso̱ñe ñamaꞌquë aꞌë caquë cosoja̱ꞌquë aꞌë.” Ja̱je i̱ caseꞌeje̱ ti̱ꞌaëna, i̱tire cuasa ñajani ota huëoni ai ojiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ñata to̱me maca Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌipi tsiꞌsireña, judío i̱ohuaꞌi ja̱ꞌre, cuiꞌne cua̱ñeseꞌe yeꞌyacohuaꞌi ja̱ꞌre, cuiꞌne pa̱i yoꞌoye ñani ca tëjicohuaꞌi ja̱ꞌre co̱ni. Tsiꞌsini ca tëjini Jesure sëasiquëni Pilato quëꞌrona sareña. ");
INSERT INTO seyNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ja̱ maca Pilatopi i̱te ñani se̱quëña: “¿Mëꞌë aꞌë, judío pa̱i ëjaërepa?” Caquëna, Jesupi sehuouña: “Ja̱je paꞌijë̱ꞌë, mëꞌë cayeje̱.” ");
INSERT INTO seyNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌi cato jaiye sa̱ñope careña. ");
INSERT INTO seyNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ja̱je cajëna, Pilatopi ti̱jupë se̱ni co̱uña, Jesure: “¿Me yoꞌoquë sehuomaꞌquëꞌni? Ñaquë mëꞌë i̱ohuaꞌi mëꞌëre sa̱ñope caye.” ");
INSERT INTO seyNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ja̱je catoje̱ Jesús cato ti sa̱ñope sehuoye pa̱ëña. Ja̱je pa̱quëna, Pilato ai cuasaëña: ¿Me yoꞌoquë pa̱quëꞌni? caquë. ");
INSERT INTO seyNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pilato cato judío pa̱i tsiꞌsi muꞌseña ti̱ꞌaëna, tse̱asiquëre eto saoquë yoꞌoquë paquëña, pa̱ipi yëjë se̱quëni. ");
INSERT INTO seyNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ja̱ro co sitore paquëña, Barrabás hueꞌequëpi yecohuaꞌi pa̱ire huaisicohuaꞌi ja̱ꞌre co̱ni. ");
INSERT INTO seyNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Pa̱ipi Pilatore dani se̱teña: Ja̱re mëꞌë yoꞌoyeje̱ paꞌye yoꞌojë̱ꞌë, cajë. ");
INSERT INTO seyNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ja̱je cajëna, Pilatopi sehuouña: “¿Yëye judío pa̱i ëjaëni eto saoye?” ");
INSERT INTO seyNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ja̱ cato caëña, coa i̱ deꞌoye yoꞌoyere ëa ñajë pë̱ijë Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌipi tse̱ani yoꞌoyë cuasaquë. ");
INSERT INTO seyNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ja̱je paꞌiquëtaꞌare Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌipi pa̱ire ca co̱ꞌme huesojë cuiꞌne yëhuoreña, Barrabásni eto saoja̱ꞌquëre se̱jëꞌë, cajë. ");
INSERT INTO seyNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ja̱ maca Pilatopi pa̱ire se̱quëña: “¿Me nejaquë cayeꞌni, mësaru judío pa̱i ëjaë hueꞌyoquëre?” ");
INSERT INTO seyNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Caquëna, ja̱ohuaꞌipi careña, cuijë: “Que̱jaꞌquë paꞌija̱quë.” ");
INSERT INTO seyNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Cajëna, Pilatopi caëña: “¿I̱quere i̱ coꞌaye yoꞌo uꞌni?” Ja̱je catoje̱ i̱ohuaꞌi jero saꞌna ai cuireña: “Que̱jaꞌquë api.” ");
INSERT INTO seyNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ja̱je asani Pilato Judea pa̱ini deꞌo cajei pasiꞌi caquë Barrabásni joye sauña. Jesuni siꞌseni que̱jaꞌquëre jëjo saoquë. ");
INSERT INTO seyNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ja̱ maca soldado pa̱ipi jai pa̱i tsiꞌsini Jesure pa̱i ëjaë huëꞌere pana sareña. ");
INSERT INTO seyNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Sani nea majaꞌi ca̱re su̱ñani cuiꞌne miu maro pu̱ani sareña. ");
INSERT INTO seyNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ja̱ jeteyoꞌje cueꞌcuejë cuireña: “¡Paꞌijë̱ꞌë. Yure judío pa̱i Ëjaërepa!” ");
INSERT INTO seyNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ja̱je cajë si̱opëna tëꞌcareña, tarapi. Copi tseꞌsejë, cuiꞌne doꞌre jaꞌrujë ëjaëre paꞌë mëꞌë cajë yoꞌoreña. ");
INSERT INTO seyNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ja̱je i̱te cueꞌcue tëjini majaꞌi juꞌi ca̱ dutani i̱ juꞌi ca̱re pare su̱ñacateña. Ja̱ jeteyoꞌje i̱ juꞌi ca̱ dutareña, que̱jaꞌquëre. ");
INSERT INTO seyNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Cirene aquëpi tsiopi daina, ñani Jesure que̱jaꞌconi hueꞌejë̱ꞌë, cajë soldado pa̱ipi cua̱ñereña. Ja̱ë cato Simón hueꞌequë pajiꞌi, Alejandro cuiꞌne Rufo pëca jaꞌquë. ");
INSERT INTO seyNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ja̱ maca Jesure Gólgotana sareña, pa̱i si̱opë tara hueꞌe hue̱ꞌñana pa̱i coca cato. ");
INSERT INTO seyNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ja̱rona Jesure que̱reña. ");
INSERT INTO seyNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Que̱ni soldado pa̱ipi Jesús juꞌi ca̱re nepi saja̱ꞌcohuaꞌi aꞌni cajë neñareña, deꞌhue nesiquëpi saye paꞌiji cajë. ");
INSERT INTO seyNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ja̱ yoꞌo maca cato nea hue̱ꞌña nueve pajiꞌi, i̱te que̱si maca. ");
INSERT INTO seyNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Toyasicore i̱ si̱o sa̱ꞌnihuëna sëoreña, ja̱ doꞌire que̱ñë cajë. Toyasicopi capi: JUDÍO PA̲I ËJAËREPA. ");
INSERT INTO seyNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","I̱ ja̱ꞌre co̱ni caya coꞌamaña yahue i̱macohuaꞌire que̱huë. Teꞌire ëja te̱ꞌtena cuiꞌne yequëni ari te̱ꞌtena nëconi que̱huë. ");
INSERT INTO seyNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ja̱je yoꞌo maca toyaseꞌe ñeje caye ti̱ꞌapi: “Coꞌacohuaꞌi ja̱ꞌre co̱ni que̱ cua̱ñopi.” ");
INSERT INTO seyNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Cuiꞌne coa da saicohuaꞌije̱ i̱te ñajë cueꞌcuejë ñeje cajë sateña: “¡Asajë̱ꞌë. Yure mëꞌëpi Maijaꞌquë huëꞌe nejoni toaso̱ muꞌseña paꞌi maca huajë huëꞌe nesiꞌi caquë maca! ");
INSERT INTO seyNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Yure coꞌye huasoni da caje ñajëꞌë, que̱si sarahuapi.” ");
INSERT INTO seyNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ja̱je cuiꞌne Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌije̱, cuiꞌne cua̱ñeseꞌe yeꞌyacohuaꞌije̱ i̱te cueꞌcuejë careña: “Yecohuaꞌitaꞌare huasopi. Ja̱je paꞌiquëtaꞌare i̱jaꞌa coꞌye huaso ti̱ꞌañe pa̱ji.” ");
INSERT INTO seyNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Israel pa̱i ëjaëpi Cristore papi caja̱ꞌcohuaꞌi aꞌë cruzupi caje nëcaquëna, ñanitaꞌa careña. I̱ ja̱ꞌre co̱ni teꞌe que̱sicohuaꞌique i̱te pë̱teña. ");
INSERT INTO seyNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Je̱ꞌnërepa muꞌse jopo ti̱ꞌa maca siꞌa yeja ñamije paꞌio ne huesëoña. Toaso̱ hora ja̱je paquëña. ");
INSERT INTO seyNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ja̱re ja̱ maca Jesús tuturepa cuiña ñeje: “Eloi, Eloi ¿lama sabactani?” Ja̱je cani caye aꞌë, ¡Yëꞌë Diusu maca, yëꞌë Diusu maca! ¿Me yoꞌoquë yëꞌëre je̱ocouꞌni, teꞌire? ");
INSERT INTO seyNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ja̱je cuiquëna, i̱ti maca paꞌicohuaꞌipi asani careña: “Asajë̱ꞌë. Tsoe aquë Maijaꞌquëre quëacaiquë Elíasni cuiji.” ");
INSERT INTO seyNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ja̱je cajëna, i̱ohuaꞌi aquëpi huëꞌhuëni oꞌsa co̱nore yëi sëohuëna sa̱quëni u̱cuja̱quë caquë sani nëoquë caëña: “Coa ñajëꞌë. Ñañuꞌu, Elíaspi i̱te cruzu dequëre casa nëcoquëna.” ");
INSERT INTO seyNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ja̱ maca Jesús ai tutu cuini ju̱ni huesëña. ");
INSERT INTO seyNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","I̱ ju̱ꞌi maca Maijaꞌquë huëꞌe joporepa tëhuocopi jopore paja̱ꞌa cayayeseꞌe meñe yete saquëña. ");
INSERT INTO seyNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Romano Capitánpi Jesús je̱ꞌñerepa nëcasiquëpi ja̱je Jesús cuiquë ju̱ni huesëquëna, ñasiquëpi caëña: “Nuñerepa iquë Maijaꞌquë mamaquërepa pajiꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Cuiꞌne nomiohuaꞌi soꞌopi de ñajë nëcareña. Ja̱ohuaꞌi cato paëꞌë, María Magdalena. Cuiꞌne yeco pacoꞌë, María, Jacobo po̱sërepa, José cuiꞌne Salomé, pëca jaꞌco. ");
INSERT INTO seyNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Iye nomiohuaꞌi cato Jesure co̱caicohuaꞌi pateña. I̱ Galilea cuꞌi maca cuiꞌne ja̱rote jai pa̱i yecohuaꞌije̱ pateña, Jesús ja̱ꞌre Jerusalénna saisicohuaꞌije̱. ");
INSERT INTO seyNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ñaminaꞌa huajë muꞌse paꞌija̱ꞌcoa cajë fiesta yoꞌo ja̱ꞌñe ne deꞌhua muꞌse naꞌiquëna, ");
INSERT INTO seyNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","José Arimatea aquëpi pa̱i yoꞌoye ñani ca tëjicohuaꞌi ëjaohuaꞌirepa aquë paquëña. Ja̱ë cato Maijaꞌquë cua̱ñe te̱ꞌte yoꞌoyere utequë paquëña. Ja̱je paꞌipi Pilato quëꞌrona siꞌa tuturepa cacani caꞌramaꞌë Jesús ca̱përe ta̱siꞌi caquë se̱quëña. ");
INSERT INTO seyNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ja̱je se̱ina, Pilatopi ai cuasaëña, i̱ ju̱ni huesëre paꞌë caquë. Ja̱je cuasa doꞌire Capitánre soini i̱ ju̱ni huesë caquë se̱ni asaquëna, ju̱ꞌire papi, caëña. ");
INSERT INTO seyNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ja̱je caëna, asani Pilatopi Jesús ca̱përe saye deꞌoji caëña, Josére. ");
INSERT INTO seyNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Caëna, Josépi sani Jesús ca̱pë casani jai doꞌi sabanare hueroni deani quë̱na yejana coje nesicona ta̱ni quë̱na pëpi si̱ouña. ");
INSERT INTO seyNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ta̱jëna, ñareña, María Magdalena cuiꞌne María José pëca jaꞌco co̱ni. ");
INSERT INTO seyNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Huajë muꞌse tëto sai maca María Magdalena cuiꞌne Jacobo, Salomé pëca jaꞌcopi María co̱ni huëo së̱ maꞌñare hueroni sateña, Jesús ca̱përe huëo së̱ñepi neñuꞌu cajë. ");
INSERT INTO seyNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Semana huëo muꞌserepa ai nea hue̱ꞌñarepa tsoe ë̱së paꞌina, sani ti̱ꞌareña, ta̱si daripë quëꞌro. ");
INSERT INTO seyNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","I̱ohuaꞌija̱ꞌa sa̱ꞌñe careña: “¿Nepi jai quë̱na pë huiꞌyoja̱ꞌcohuaꞌi aꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ja̱je cajë ñajëna, ta̱si daripëpi tsoe huiꞌyosico pacoña. ");
INSERT INTO seyNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Paꞌiona, ñani ta̱si daripëna cacareña: Cacajë ñajëna, ëja te̱ꞌtere pojaꞌi juꞌi ca̱re po̱sëpi juꞌi ñuquëña. Ja̱ëni ñani ai quëquëreña. ");
INSERT INTO seyNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Quëquëjëna, i̱pi caëña: “Quëquëmaꞌpë paꞌijë̱ꞌë. Mësaru cato Jesús Nazaret aquëni coꞌeyë, que̱ sarahuana que̱siquëni. Ja̱je paꞌiquëtaꞌare i̱ cato tsoe huëjiꞌi. Peoji, i̱ño. Ñajëꞌë. I̱te o̱a sitore peoji. ");
INSERT INTO seyNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mësarupi sani i̱ yeꞌyacohuaꞌire cuiꞌne Pedrore quëajë̱ꞌë. Galileana duꞌru saija̱ꞌquë api. Ja̱rona i̱te ñajaꞌcohuaꞌi aꞌë, i̱ ja̱ꞌrë mësarute quëaseꞌeje̱.” ");
INSERT INTO seyNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ja̱ maca nomiohuaꞌipi quëquë huesëni tsasijë etani ta̱si daripëpi sateña. Coꞌini yecohuaꞌire quëaye pa̱reña, quëquë huesësicohuaꞌi paꞌijë. ");
INSERT INTO seyNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Semana huëo muꞌse huëisiquëpi duꞌru macarepa María Magdalenana ñaiña. Ja̱o cato siete huatiohuaꞌire eto sao cua̱ñosico pacoꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ja̱opi yuretaꞌa ñani sani quëaoña, i̱ ja̱ꞌre cuꞌijë paꞌisicohuaꞌire oijë coꞌa ju̱ꞌijë paꞌicohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ja̱ohuaꞌipi quëacona, asani care paco cuasaye pa̱reña, i̱o caseꞌe. ");
INSERT INTO seyNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ja̱ jeteyoꞌje Jesús ñaiña, cayaohuaꞌi tsiona maꞌajaꞌa saicohuaꞌina. ");
INSERT INTO seyNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ja̱ohuaꞌipi sani yecohuaꞌire quëareña. Quëajëna, ja̱ohuaꞌije̱ coa cayë cuasajë asaye pa̱reña. ");
INSERT INTO seyNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ai tsoe maca yuretaꞌa once i̱ yeꞌyacohuaꞌina ñaiña, mesare ñuꞌijëna. Ñaini ja̱ohuaꞌire yëhuo nuꞌñeiña, ju̱ꞌisiquëpi huëisiquëre ñani quëacohuaꞌire asacaiye pa̱si doꞌire, i̱ohuaꞌi jëa joñoa hueꞌe doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Yëhuoquë caëña: “Siꞌa hue̱ꞌña sani cuꞌijë iye huaso cocare quëajë̱ꞌë, siꞌa pa̱ire. ");
INSERT INTO seyNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Quëajëna, asani quëare payë caquë asaquëni oco dosiquëpi huasosiquë pasipi. Ja̱je quëajëna, coa cayë caquë asamaꞌquë cato nejosiquë api. ");
INSERT INTO seyNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Iye tuture paja̱ꞌcohuaꞌi aꞌë yëꞌëre asacohuaꞌi cato: Yëꞌë mamipi cajë huatire eto saoja̱ꞌcohuaꞌi aꞌë. Huajë cocapi caja̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","A̲ñare tse̱ajaꞌcohuaꞌi aꞌë. Tsi̱mare u̱cusicohuaꞌi panije ai yoꞌoye pa̱jaꞌcohuaꞌi aꞌë. Cuiꞌne yequeje̱, ju̱ꞌicohuaꞌire patojëna, coꞌyaja̱ꞌcohuaꞌi aꞌë, ju̱ꞌicohuaꞌipi.” ");
INSERT INTO seyNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ja̱je ca tëjini Ëjaë Jesús maꞌtëmona sa cua̱ñopi. Ja̱rona Diusu ëja te̱ꞌte ñuꞌi saihuëna jaꞌruña. ");
INSERT INTO seyNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ja̱ maca ja̱ohuaꞌipi siꞌa hue̱ꞌña cuꞌijë quëareña, huaso cocare. Ja̱re Ëjaëpi co̱cai cuiꞌne i̱pi pa̱i yoꞌo ti̱ꞌa maꞌñere yoꞌo i̱ñoquëna, quëareña, huaso coca. I̱ cocare paꞌë caquë yoꞌoquëna, ja̱ yoꞌoyepi i̱ñojë huaso cocare quëareña. Ca tëjihuë.");
INSERT INTO seyNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","I̱ti duꞌru huëoseꞌe ñasicohuaꞌipi deꞌo coca quëajëna, asajë jai pa̱i toyahuë, mai quëꞌro yoꞌoseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ja̱je paꞌina, yëꞌëje̱ asare paquë i̱ti yoꞌoseꞌeje̱ paꞌye duꞌru huëoseꞌere papi toyayë, mëꞌëna, Teofilo, yëꞌë cajei. ");
INSERT INTO seyNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Mëꞌëpi mëꞌëre yeꞌyaseꞌere ti̱ñarepa asa ti̱ꞌajaꞌquë caquë. ");
INSERT INTO seyNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herodes Judea pa̱i ëjaë paꞌi maca, teꞌi Maijaꞌquë huëꞌe ñacaiquë Zacarías hueꞌequë pajiꞌi, Abías tsëcapë aquëpi. I̱ paco Elisabet hueꞌecopi, Maijaꞌquë huëꞌe ñacaiquë Aarón tsëcapë aco pacoꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Cayahuaꞌi deꞌoye nuñerepa paꞌicohuaꞌi paëꞌë, Maijaꞌquë ña hue̱ꞌña paꞌiohuaꞌipi i̱ cua̱ñeseꞌe cuiꞌne i̱ caseꞌere deꞌoye sehuocohuaꞌi paëꞌë. Ja̱je paꞌicohuaꞌini yecohuaꞌije̱ coꞌaye paꞌiyë caye ti peocohuaꞌirepa paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ja̱je paꞌiquëtaꞌare mamajëre peocohuaꞌi paëꞌë. Elisabetpi mamajëre pamaꞌco pacoꞌë, carao. Cuiꞌne ja̱je paꞌiohuaꞌipi siꞌa jupë aiohuaꞌi maña paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Teꞌe muꞌse Zacarías ja̱ꞌre Maijaꞌquë huëꞌe ñacaicohuaꞌi paꞌicohuaꞌipi yequë yoꞌo tëjina ja̱re ja̱jeseꞌe siꞌa i̱ohuaꞌi tsëcapë yoꞌoye pajiꞌi, Maijaꞌquë paꞌi hue̱ꞌñana. ");
INSERT INTO seyNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ja̱je paꞌiohuaꞌija̱ꞌa nepi maꞌñare ëojë yoꞌoye paꞌiquëꞌni cajë neñajëna, Zacaríasna to̱mepi, i̱ti yoꞌoye. To̱meina, Maijaꞌquë huëꞌena cacapi. ");
INSERT INTO seyNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Cacani huëo së̱ñere ëoquëna, hueꞌseja̱ꞌa jai pa̱i Maijaꞌquëre se̱jë paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ja̱ maca Ëjaë joꞌyaëpi hui̱ñaëpi Zacarías huëo së̱ñe ëo saihuë ëja te̱ꞌtena ñai nëcapi. ");
INSERT INTO seyNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nëcaquëna, Zacaríaspi ñani me nejaꞌquë aꞌni caquë quëquë huesëquëna. ");
INSERT INTO seyNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ëjaë joꞌyaëpi capi, i̱te: “Zacarías caꞌramaꞌë paꞌijë̱ꞌë. Maijaꞌquëpi mëꞌë se̱ñe asapi. Ja̱je paꞌina, mëꞌë paco Elisabetpi tsihuaꞌëre pasio. Pacona, mëꞌëpi i̱ mami hueꞌyojë̱ꞌë, Juanre. ");
INSERT INTO seyNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mëꞌë i̱te sihuaja̱ꞌquë aꞌë, cuiꞌne yecohuaꞌije̱ jai pa̱i i̱te co̱asi maca sihuaja̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Mëꞌë mamaquë cato deꞌoyerepa yoꞌoquë paꞌija̱ꞌquë api, Maijaꞌquë joꞌyaëpi. Ja̱je paꞌipi ja̱ yëꞌtaꞌa i̱te co̱amaꞌnë Maijaꞌquë joyopi i̱ni paꞌija̱ꞌquë api. Paꞌina, cuepe ëaye neñe co̱no u̱cumaꞌquë pasipi. ");
INSERT INTO seyNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ja̱ëpi jai pa̱i Israel pa̱ire cuiꞌnaohuaꞌipi i̱ohuaꞌi mai Ëjaë Diusuna coꞌye asa co̱ñe necasipi. ");
INSERT INTO seyNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Maijaꞌquë ñacaina, iquë Juan deꞌoye yoꞌoquë paꞌija̱ꞌquë api, mai Ëjaë pa̱i deoja̱jë. Ja̱je paꞌipi, tsoe hue̱ꞌña Maijaꞌquë jëjo daoquë Elías yoꞌoquë paꞌisi tuture hueꞌequë pasipi. Ja̱ëpi pëca jaꞌquëohuaꞌi ja̱ꞌre mamajë deꞌoye paꞌiye necasipi. Ja̱je sehuomaꞌcohuaꞌire po̱najaꞌquë api, Ëjaëre deꞌoye asaja̱ꞌcohuaꞌire, mai Ëjaë pa̱i deoja̱jë.” ");
INSERT INTO seyNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacaríaspi Maijaꞌquë hui̱ñaë se̱jiꞌi, ñeje: “¿Yëꞌëje̱ ai maca paꞌina, cuiꞌne yëꞌë pacoje̱ aio maca paꞌito me yëꞌë nuñere paꞌë caquë asayeꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Caquëna, Maijaꞌquë hui̱ñaë i̱te sehuouña: “Yëꞌë Gabriel aꞌë, Maijaꞌquëre necai paꞌiquë. Ja̱je paꞌina, yëꞌëre i̱pi jëjo daouna, iye huajë coca quëasiꞌi, mëꞌëre caquë daëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ja̱je paꞌiquëtaꞌare yure mëꞌë yëꞌë nuñerepa quëayere asamaꞌë paꞌisi doꞌire camaꞌquë deꞌoni camaꞌë paꞌija̱ꞌquë aꞌë, mëꞌë mamaquëre co̱a macaja̱ꞌa iye caseꞌe ti̱ꞌa ja̱ꞌñe aꞌë, i̱ti muꞌse ti̱ꞌaëna.” ");
INSERT INTO seyNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ja̱je yoꞌoquë Maijaꞌquë huëꞌe ëo hue̱ꞌñana cacasiquëpi tsoe nëina, yecohuaꞌi hueꞌse paꞌicohuaꞌi i̱quere yoꞌoquë Zacarías etamaꞌquëpi nëi paꞌini cajë utehuë. ");
INSERT INTO seyNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Utejëna, ja̱ropi Zacarías etani ja̱ohuaꞌire camaꞌë pajiꞌi. Ja̱je camaꞌëna, ñani cani ñañeje paꞌye Maijaꞌquëre se̱ hue̱ꞌñana cacani ñapi, cuasahuë. Ja̱je paꞌipi coa jë̱të a̱ꞌuñeseꞌepi capi, camaꞌquë po̱nëseꞌe sëte. ");
INSERT INTO seyNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zacarías Maijaꞌquë huëꞌe co̱cai muꞌseña caraja̱isi maca, sajiꞌi, i̱ huëꞌena. ");
INSERT INTO seyNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ja̱ jeteyoꞌje i̱ paco Elisabet tsi̱ ë̱tapë deꞌo. Deꞌoni cinco ñañëohuaꞌire i̱o huëꞌepi yequë hue̱ꞌña saimaꞌo ai cuasaco pacoꞌë, ñeje: ");
INSERT INTO seyNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ëjaëpi yure yëꞌëre ja̱je ñacai yoꞌopi, pa̱ipi tsi̱ pamaꞌcoa cajë cueꞌcuemaꞌpë paꞌija̱jë caquë. ");
INSERT INTO seyNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Seis ñañëohuaꞌi paꞌi maca Maijaꞌquëpi i̱ hui̱ñaë Gabrielre Galilea yejana Nazaret hueꞌe daripëna jëjo saopi. ");
INSERT INTO seyNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nomi tsi̱o María hueꞌecopi ë̱mëohuaꞌire yoꞌomaꞌcore doꞌi ñajaꞌquëni caquë. Ja̱o cato José hueꞌequëna, huejaja̱ꞌcoa. Ca nëosicopi pacoꞌë, ëjaë David tsëcapë aquëna. ");
INSERT INTO seyNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Maijaꞌquë jëjo daoquëpi i̱o paꞌi hue̱ꞌñana cacani capi: “Pëpayë, mëꞌëre. Sihuajë̱ꞌë. Mai Ëjaëpi mëꞌë ja̱ꞌre paꞌiji. Diusupi siꞌa nomiohuaꞌi sihuaye jerepa i̱sipi, mëꞌëre.” ");
INSERT INTO seyNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ja̱je caquëna, i̱opi Maijaꞌquë jëjo daoquëre ñani quëquëo i̱ cocare asaco cuiꞌne ja̱ maca coꞌye se̱coꞌë: “¿Me yoꞌoquë ja̱je pëpaquëꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ja̱je cacona, Maijaꞌquë hui̱ñaëpi capi, i̱ote: “María caꞌramaꞌo paꞌijë̱ꞌë, Maijaꞌquë mëꞌëre sihuaquë api. ");
INSERT INTO seyNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Yurepi pa̱i quëꞌio deꞌoni mëꞌë tsihuaꞌëre paja̱ꞌcoaꞌë. Paco i̱ mami hueꞌyojë̱ꞌë, Jesure. ");
INSERT INTO seyNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ja̱ë cato jerepa paꞌi paꞌija̱ꞌquë api, ja̱je paꞌipi Maijaꞌquërepa mamaquë pa̱ipi hueꞌyoquëni. Ja̱je paꞌina, Maijaꞌquëpi pa̱i ëjaë David ñuꞌi saihuëre i̱sija̱ꞌquë api, pa̱i ëjaëre deꞌhuani. ");
INSERT INTO seyNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Israel pa̱ire ti cua̱ñequërepa paꞌija̱ꞌquëpi, i̱ cua̱ñeñe cato caraja̱iñe peoja̱ꞌcoa.” ");
INSERT INTO seyNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ja̱ maca Maríapi Maijaꞌquë hui̱ñaëre se̱coꞌë: “¿Me iye ja̱je yoꞌo ja̱ꞌñe aꞌni, yëꞌë ë̱mëohuaꞌi ja̱ꞌre co̱ni paꞌimaꞌcore?” ");
INSERT INTO seyNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Cacona, Maijaꞌquë hui̱ñaëpi sehuouña: “Maijaꞌquë joyopi mëꞌëna necaina, cuiꞌne Maijaꞌquërepa tutupi mëꞌëna sirio tsiocaiyeje̱ tsio daija̱ꞌcoa. Ja̱ doꞌire mëꞌë mamaquëre Maijaꞌquë mamaquë hueꞌyoja̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ja̱je cuiꞌne mëꞌë cajeo tsëcapë aco Elisabetje̱ tsihuaꞌëre paja̱ꞌcoa, aio macataꞌa. Tsi̱ pamaꞌcoa pa̱i cajë paꞌisicotaꞌa seis ñañëohuaꞌire pa̱i quëꞌio paꞌico, yure. ");
INSERT INTO seyNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Maijaꞌquëre cato neñeseꞌe paꞌiji. Peoji, i̱ jaꞌruja̱iñe.” ");
INSERT INTO seyNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ja̱ maca Maríapi cao: “Yëꞌë cato Ëjaë joꞌyao macaꞌë. Maijaꞌquëpi mëꞌë caseꞌeje̱ yoꞌoja̱ꞌquë yëꞌëre sihuayë.” Ja̱je Maijaꞌquë hui̱ñaë iyeseꞌe quëani sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ja̱ muꞌseña María esa sacoꞌë, Judea cu̱ti quëꞌrore pa̱i daripë paꞌi hue̱ꞌñana. ");
INSERT INTO seyNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sani Zacarías cuiꞌne Elisabet paꞌi huëꞌena cacani pëpao. ");
INSERT INTO seyNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Pëpacona, Elisabetpi i̱o pëpaye asa maca tsihuaꞌë ë̱tapë paꞌiquëpi ti̱ꞌtopi Maijaꞌquë joyopi i̱oni paꞌina, pacoꞌë, Elisabetpi. ");
INSERT INTO seyNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ja̱je paꞌiopi tutu cao: “Maijaꞌquëpi mëꞌëre yequë nomiohuaꞌire sihuaye necaiye jerepa deꞌoye necajiꞌi. Cuiꞌne mëꞌë mamaquë ai deꞌoquërepa paꞌija̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿I̱que oꞌni, yëꞌë ja̱je yëꞌë Ëjaë pëca jaꞌcopi doꞌi dani ña ja̱ꞌñe? ");
INSERT INTO seyNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mëꞌë yëꞌëre pëpacona, asa maca tsihuaꞌë yëꞌë ë̱tapëpi sihuaquë teapi. ");
INSERT INTO seyNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ai sihuayë, mëꞌë caseꞌere care paji caco asa doꞌire.” ");
INSERT INTO seyNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ja̱ maca María cao: Yëꞌë ai sihuayë, Maijaꞌquëre. ");
INSERT INTO seyNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Cuiꞌne yëꞌë joyopi sihuayë, Maijaꞌquë yëꞌëre huasoquëna. ");
INSERT INTO seyNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Maijaꞌquëpi i̱ joꞌyao ai cuasaye peocore deꞌoye cuasapi. Yuretaꞌa ja̱je yoꞌoquëna, siꞌa pa̱ipi ai sihuaco siꞌanë caja̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Maijaꞌquë ai jerepa tutu quëꞌipi yëꞌëna deꞌoye necaëꞌë. Yëꞌë Ëjaë i̱ mami cato ai deꞌoyerepa. ");
INSERT INTO seyNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Siꞌanë oiquë api, i̱te caꞌracohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tutu quëꞌi coꞌamaña yoꞌoquë nepi, i̱ jë̱ñapi. Jerepa paꞌiohuaꞌi aꞌë cuasa joñoa hueꞌecohuaꞌini meñe quëconi huahue huesopi. ");
INSERT INTO seyNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ñajëꞌë, i̱ yoꞌoseꞌere: Ëjaohuaꞌi paꞌisicohuaꞌini meñe peocohuaꞌire nequë Cuiꞌne i̱ti jerepa paꞌiohuaꞌi aꞌë cuasamaꞌcohuaꞌini ñese mëoseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","A̲o ëa ju̱ꞌicohuaꞌi paꞌisicohuaꞌini deꞌoye a̱o ti̱mëpi. Cuiꞌne jaiye coꞌamaña pasicohuaꞌini coa peo jëña ne saopi. ");
INSERT INTO seyNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Deꞌhue co̱cajiꞌi, Israel pa̱ire. I̱ joꞌyare hua̱nëyemaꞌë ojiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Abrahamre ca nëoseꞌere deꞌoyerepa yoꞌopi, mai aiohuaꞌire. Cuiꞌne ja̱je Abraham tsëcapë Israel pa̱ire deꞌoye yoꞌoja̱ꞌquë api, siꞌanë ja̱jeseꞌe. ");
INSERT INTO seyNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ca tëjini pëpao, Elisabet huëꞌena, toaso̱ ñañëohuaꞌire. Pëasicopi pani tëjini jeteyoꞌje i̱o huëꞌena coꞌio. ");
INSERT INTO seyNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ja̱ jeteyoꞌje Elisabet tsihuaꞌëre co̱a muꞌseña ti̱ꞌaëna, mamaquëre pao. ");
INSERT INTO seyNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","I̱o cajeohuaꞌi cuiꞌne doꞌicohuaꞌi jaꞌye paꞌicohuaꞌi sani pëpahuë, i̱ote, Maijaꞌquë deꞌoye yoꞌoseꞌere asani sihuajë. ");
INSERT INTO seyNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ocho muꞌseña paꞌi maca sahuë, cuiri ca̱ꞌnihuë tëañuꞌu cajë Israel pa̱i deoja̱jë cajë, cuiꞌne pëca jaꞌquë Zacarías mamire sëoñuꞌu cajë yoꞌohuë. ");
INSERT INTO seyNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ja̱je cajëna, pëca jaꞌcopi cao: “Pa̱ni, i̱ cato Juan hueꞌeye paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ja̱je cacona, i̱ote cahuë: “¿Me yoꞌoquë ja̱je hueꞌequëꞌni, mëꞌë pa̱irepa ja̱ mamire hueꞌecohuaꞌi peoyë. Ja̱je paꞌi mami hueꞌecohuaꞌi peoto?” ");
INSERT INTO seyNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ja̱ maca tsihuaꞌë pëca jaꞌquëre moñopi i̱ñojë se̱iꞌë: “¿I̱que mamire hueꞌyoye yëquëꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Se̱jëna, pëca jaꞌquëpi so̱quë totore dajë̱ꞌë caquëna, i̱sirena, i̱ona toyapi: “I̱ mami cato Juanpi.” Ja̱je toyaëna, siꞌa huaꞌi ai cuasajë ñahuë. ");
INSERT INTO seyNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ja̱ macapi Zacaríasje̱ cuiꞌnaëpi coca caquë deꞌoni Maijaꞌquëre sihuaquë ca huëopi. ");
INSERT INTO seyNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ja̱je iye yoꞌoseꞌere ñani i̱ quë̱no maca paꞌicohuaꞌi ai cuasahuë. Cuiꞌne iye yoꞌoseꞌere siꞌa Judea ai cu̱ti paꞌicohuaꞌire quëajëna, asahuë. ");
INSERT INTO seyNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Siꞌahuaꞌi i̱ti quëaye asacohuaꞌi i̱tire cuasahuëni asaꞌñe nëina, se̱niroja̱ëꞌë: “¿Me yoꞌoquërepa ai deꞌoja̱ꞌquë aꞌni, ja̱ë tsihuaꞌë?” Maipi ñahuë, Maijaꞌquëre papi i̱te ñacaiseꞌe. ");
INSERT INTO seyNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacarías Maijaꞌquë joyo ti̱mësiquëpi Maijaꞌquë i̱si yëꞌopi capi: ");
INSERT INTO seyNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Sihuañuꞌu, mai Ëjaëre Israel pa̱i Diusure. Ja̱ë cato maina dani huasopi. ");
INSERT INTO seyNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Maina Maijaꞌquëpi i̱sipi tutu quëꞌire, pa̱ire huasoquëre. Ja̱ë cato i̱ joꞌyaë David tsëcapë aquëpi. ");
INSERT INTO seyNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Maijaꞌquëpi ñeje ca nëoaꞌjiꞌi, i̱ caseꞌere quëacaicohuaꞌi tsoe hue̱ꞌña acohuaꞌi ja̱ꞌre: ");
INSERT INTO seyNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Maire huasosiꞌi, siꞌaohuaꞌi maire coejë sa̱ñope yoꞌojëna, paꞌicohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Mai aipëre teaye ñaquë I̱ ca nëoseꞌe hua̱nëñemaꞌë deꞌoye necajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Yëꞌëna i̱sisicohuaꞌipi nuñe paꞌicohuaꞌipi caꞌramaꞌpë Yëꞌëre necaicohuaꞌi ti paꞌija̱ꞌcohuaꞌi aꞌë caquë Mësarute sa̱ñope yoꞌoyere huasosiꞌi ca nëopi, mai ai ñecuë Abrahamre. ");
INSERT INTO seyNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Maijaꞌquërepa quëacaiquë hueꞌyoja̱ꞌcohuaꞌi aꞌë, pa̱ipi, Mëꞌëpi mai Ëjaë saija̱ꞌa maꞌare nui maꞌarepa sani ne deꞌhuaja̱ꞌquëni. ");
INSERT INTO seyNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","I̱ pa̱ire deꞌhue i̱ohuaꞌi coꞌaye yoꞌo doꞌire sa̱i deꞌhuacaiye paꞌiji, quëaja̱ꞌquë aꞌë, mëꞌëpi. Ja̱ doꞌipi huasosicohuaꞌi paꞌija̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Maijaꞌquë oi cuiꞌne teaye ña doꞌipi, Ë̲së ñata maca mëi miañeje paꞌye maire huasoquë maꞌtëmopi daija̱ꞌquë api, maire miajaꞌquë. ");
INSERT INTO seyNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Huesëcohuaꞌire ju̱ni tëjicohuaꞌire miacai Cuiꞌne deꞌoye i̱ maire huasoye asaja̱jë caquë paꞌiyere yeꞌyaja̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Juan ai deꞌopi. Cuiꞌne i̱ joyoje̱ ai deꞌopi. Ai deꞌoquëpi pa̱i peo hue̱ꞌña cue̱ne yejare pajiꞌi, Israel pa̱ire quëa huëo macaja̱ꞌa. ");
INSERT INTO seyNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ja̱ muꞌseña pa̱i ëjaë César Augustopi siꞌa yeja paꞌicohuaꞌire cue̱cueye paꞌiji caquë cua̱ñepi. ");
INSERT INTO seyNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Iye duꞌru macarepa pa̱ire cue̱cueye cato yoꞌohuë, Cirenio Siria cua̱ñequë paꞌi maca. ");
INSERT INTO seyNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ja̱je paꞌina, siꞌahuaꞌi saiye pajiꞌi, pa̱i ñape i̱ohuaꞌi daripëre pana ja̱rona cue̱cue cua̱ñojaꞌcohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","José cato David tsëcapë aquë pajiꞌi. Ja̱ doꞌire Galilea yeja daripë Nazaretpi sani Judea yeja daripë Belénna sajiꞌi, Davidre co̱a sitona. ");
INSERT INTO seyNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Toya cua̱ñojaꞌquëpi Belénna sajiꞌi, María i̱ huejaja̱ꞌcoa ca nëosicopi co̱añe ti̱ꞌa huesësico ja̱ꞌre. ");
INSERT INTO seyNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ja̱je sani Belénre paꞌijëna, María co̱añe ti̱ꞌaëna, ");
INSERT INTO seyNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ja̱rona pao, i̱o duꞌru mamaquëre. Pani ca̱ña ca̱tipëpi tu̱nani hue̱quë a̱i deꞌhuana o̱ao, pa̱i pëa hue̱ꞌña peo doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Belén quë̱no macare yëi ñamare ñacohuaꞌipi ñamique tsiore i̱ohuaꞌini ñajë paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Paꞌijëna, cuasamaꞌtore papi Ëjaë hui̱ñaë ñai nëcaquëna, Maijaꞌquë miañepi i̱ohuaꞌire mia huesoquëna, ai quëquë huesëhuë. ");
INSERT INTO seyNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ja̱je ña quëquëjëna, Maijaꞌquë hui̱ñaëpi capi: “Caꞌramaꞌpë paꞌijë̱ꞌë, mësarute huajë coca quëasiꞌquë daiyë, mësaru siꞌahuaꞌi asani ai sihua ja̱ꞌñere. ");
INSERT INTO seyNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Yure David daripëna tsi̱tuꞌure co̱ao, mësarute huasoja̱ꞌquëpi. Ja̱ë cato Cristo Ëjaëre papi. ");
INSERT INTO seyNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Mësaru ñani i̱ api cuasa ja̱ꞌñere ca̱ña ca̱tipëpi tu̱nani hue̱quë ai deꞌhuana o̱asiquëpi u̱ina ti̱ꞌajaꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Teꞌi Maijaꞌquë joꞌyaë hui̱ñaë ñai macapi yecohuaꞌi maꞌtëmo acohuaꞌije̱ ñaihuë. Ñeje cajë Maijaꞌquëre sihuajë: ");
INSERT INTO seyNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Sihuajë deꞌoyerepa cañuꞌu, Maijaꞌquëre maꞌtëmo aquëre, Deꞌoye paꞌiyere paꞌijë̱ꞌë, i̱pi sihuaquëna paꞌicohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Maijaꞌquë jëjo daosicohuaꞌi maꞌtëmona coꞌisi maca yëi ñamare ñacohuaꞌipi i̱ohuaꞌija̱ꞌa sa̱ꞌñe ca huëohuë. “Ja̱je paꞌito esa Belénna sani ñañuꞌu, ëjaë maire quëaseꞌere.” ");
INSERT INTO seyNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Sani ti̱ꞌahuë, Maríare, Josére cuiꞌne tsihuaꞌëpi hue̱quë a̱ocona o̱asiquëpi u̱ina. ");
INSERT INTO seyNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ja̱je i̱te ñani Maijaꞌquë joꞌyaë i̱ohuaꞌire quëaseꞌere quëareña. ");
INSERT INTO seyNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Quëajëna, asacohuaꞌipi ai cuasareña. ");
INSERT INTO seyNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ja̱je yecohuaꞌi yoꞌojëtaꞌare María cato i̱o joyona deꞌhuao, siꞌaye iye, ti yoꞌoseꞌere cuasaco. ");
INSERT INTO seyNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Yëi ñamare ñacohuaꞌi siꞌaye i̱ohuaꞌire caseꞌeje̱ paye paꞌina, ñani Maijaꞌquëna sihuajë jë̱jëjë coꞌihuë. ");
INSERT INTO seyNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ocho muꞌseña paꞌi maca tsihuaꞌë ca̱ꞌni maña tëajë cuiꞌne i̱ mamije hueꞌyohuë, Jesús, hui̱ñaë Maríare ja̱ peoco paꞌi maca quëaseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Tsi̱tuꞌure pasi jeteyoꞌje siꞌsire tsoa to̱ muꞌseña ti̱ꞌaëna, Jerusalén daripëna saijë tsi̱tuꞌureje̱ sahuë, Maijaꞌquëna i̱siñuꞌu cajë, Moisés cua̱ñeseꞌepi ja̱je caye sëte. ");
INSERT INTO seyNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ja̱je yoꞌohuë, ëjaë cua̱ñeseꞌepi ñeje toyaseꞌe paꞌi doꞌire: “Siꞌa ë̱më tsi̱ duꞌru co̱acohuaꞌi Maijaꞌquëna i̱sisicohuaꞌi paꞌija̱ꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ëjaë cua̱ñeñepi caji: “Caya pi̱ꞌare pa̱nitaꞌa caya suꞌtere i̱sijë̱ꞌë.” Ja̱ yoꞌoyere cajë saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ja̱ muꞌseña Jerusalén paꞌiquëpi Simeón hueꞌequëpi pajiꞌi. Nuiñerepa paꞌiquëpi Maijaꞌquëre se̱i paꞌiquëpi, Israel pa̱ire huasoyere utequë pajiꞌi. Ja̱je paꞌina, Maijaꞌquë joyopi Simeón ja̱ꞌre paꞌi ");
INSERT INTO seyNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","quëapi, mëꞌë ju̱ꞌiñe pa̱jaꞌquë aꞌë, ëjaë jëjo daoquë Cristore ñamaꞌë pani. ");
INSERT INTO seyNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Maijaꞌquë joyopi quëaquëna, Maijaꞌquëre se̱ huëꞌena sani paꞌina, Jesús pëca jaꞌquëohuaꞌi tsihuaꞌëre cua̱ñeseꞌe cayeje̱ neñuꞌu cajë Maijaꞌquëre se̱ huëꞌena dahuë. ");
INSERT INTO seyNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Dajëna, Simeónpi tsihuaꞌëre co̱ani Maijaꞌquëna sihuaquë capi: ");
INSERT INTO seyNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ëjaë, yëꞌë yuretaꞌa sihuaquë ju̱ꞌiñe paꞌiji. Mëꞌë ca nëoseꞌere ñasiquëpi. ");
INSERT INTO seyNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Yëꞌë ñaco ca̱pi huasoquëre ñahuë, ");
INSERT INTO seyNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Siꞌa pa̱i ña hue̱ꞌñana mëꞌë necaisiquëre. ");
INSERT INTO seyNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ja̱ë api, Israel peocohuaꞌire miacaija̱ꞌquë Cuiꞌne i̱ doꞌire yecohuaꞌipi Israel pa̱i ai deꞌocohuaꞌi aꞌë, caja̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeón tsihuaꞌëre ñaquë cayere ai cuasareña, pëca jaꞌquëohuaꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ja̱ maca Simeón Maijaꞌquëpi deꞌoye ñacaija̱ꞌquë icohuaꞌire caquë Maijaꞌquëre se̱jiꞌi. Se̱ni tëjini Maríare capi, Jesús pëca jaꞌcore: “Asajë̱ꞌë. Iquë tsihuaꞌë jai pa̱ire Israel pa̱ire ne ta̱ñojaquë api. Cuiꞌne jai pa̱ire Israel pa̱ire Maijaꞌquëre tuiye huëoquë yoꞌoja̱ꞌquë api. Ja̱je paꞌina, jai pa̱i i̱te sa̱ñope caja̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Cuiꞌne, iquë doꞌire jai pa̱i pa̱i ñape i̱ohuaꞌi joñoa cuasaye ñañe paꞌija̱ꞌcoa. Ja̱je paꞌiquëtaꞌare mëꞌëretaꞌa siꞌaye iye yoꞌoyete cuasani huaꞌtipi më joyoja̱ꞌa tota etoja̱iñeje paꞌye paꞌija̱ꞌcoa, oi doꞌire.” ");
INSERT INTO seyNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Cuiꞌne ja̱rote teꞌo nomio yequë muꞌse paꞌi ja̱ꞌñere asaco quëaco. Ana hueꞌeco, Fanuel mamaco pacoꞌë. Aser tsëcapë aco, aio maca pacoꞌë. Nomi tsi̱opi huejani siete o̱metëca ë̱jëre pani huaꞌjesicopi pacoꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Yure cato huaꞌjeopi ochenta y cuatro o̱metëca pacoꞌë. Maijaꞌquëre se̱ huëꞌepi etamaꞌcopi ñamiña cuiꞌne muꞌseña Maijaꞌquëre sihuaco a̱o a̱imaꞌo se̱o pacoꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ja̱o Anapi i̱ti ja̱je yoꞌojë ca maca dani Maijaꞌquëre duꞌru se deꞌoji caco pëpa to̱ni Jerusalén pa̱ire huaso ja̱ꞌñere utecohuaꞌini quëao, tsihuaꞌë Jesús yoꞌo ja̱ꞌñe ayere. ");
INSERT INTO seyNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ja̱ maca siꞌaye ëjaë cua̱ñeseꞌe yoꞌo tëjini coꞌihuë, Galileana i̱ohuaꞌi paꞌi daripë Nazaretna. ");
INSERT INTO seyNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Tsihuaꞌë i̱ ai deꞌoyeje̱ ai tutu quëꞌi cuiꞌne ai ta̱ꞌñe paꞌi deꞌopi, Maijaꞌquëpi i̱te deꞌoyerepa ñacaina. ");
INSERT INTO seyNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","I̱ pëca jaꞌquëohuaꞌi coa siꞌa o̱metëcaña Jerusalénna saëꞌë, Israel pa̱i Egíptopi etasi muꞌsere cuasajë tsiꞌsiyena. ");
INSERT INTO seyNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesús doce o̱metëca ti̱ꞌani paꞌi maca siꞌahuaꞌi Jerusalénna ja̱ fiesta yoꞌoyena tsiꞌsiñuꞌu cajë saëꞌë, noni ja̱je yoꞌojë paꞌicohuaꞌi sëte. ");
INSERT INTO seyNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ja̱ fiesta caraja̱quëna, coꞌi maca tsihuaꞌë Jesús Jerusalénna pëapi, pëca jaꞌco cuiꞌne José huesëjëna. ");
INSERT INTO seyNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Teꞌe muꞌserepa maꞌajaꞌa Jesuje̱ daiji jai pa̱i co̱ni cuasajë saëꞌë. Saijëtaꞌa doꞌijë quëꞌro cuiꞌne i̱ohuaꞌi ñacohuaꞌi quëꞌro coꞌejëna, peopi. ");
INSERT INTO seyNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Peoquëna, ñani ja̱ maca yuretaꞌa coꞌihuë, Jerusalénna coꞌeñuꞌu cajë. ");
INSERT INTO seyNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Toaso̱ muꞌseña paꞌi maca ti̱ꞌahuë, Maijaꞌquë huëꞌere paꞌina, cua̱ñeseꞌe yeꞌyacohuaꞌi ja̱ꞌre co̱ni jaꞌrusiquëpi ñuꞌi i̱ohuaꞌi cayere asaquë cuiꞌne i̱ohuaꞌireje̱ sa̱ñope se̱i yoꞌoquëna. ");
INSERT INTO seyNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Siꞌa paꞌicohuaꞌi Jesús siꞌaye ta̱ꞌñe asaquëpi sa̱ñope deꞌoyerepa sehuoyere asajë quëquëhuë. Merepa ai asaquëꞌni, ja̱ë cajë ai cuasareña. ");
INSERT INTO seyNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Pëca jaꞌquëohuaꞌipi i̱te ti̱ꞌajë ai cuasajëna, pëca jaꞌcopi cao: “Tsihuaꞌë, mëꞌëni më jaꞌquë cuiꞌne yëꞌë coꞌa ju̱ꞌijë coꞌeroja̱iñë. ¿Me nesiꞌquë ja̱je yëquëre, huesë ëaye yoꞌouꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ja̱je cacona, Jesupi i̱ote capi: “¿Me yoꞌojë yëꞌëre coꞌeyeꞌni? Huesëmaꞌpë yëꞌë cato jaꞌquë coꞌamañare yoꞌoja̱ꞌquë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ja̱je caquëna, i̱ohuaꞌipi cuasaquë cayere asa ti̱ꞌamaꞌpë paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ja̱ maca i̱ohuaꞌi ja̱ꞌre co̱ni coꞌipi, Nazaretna. Siꞌanë deꞌoye sehuoquë pajiꞌi, pëca jaꞌquëohuaꞌire. Pëca jaꞌcopi iyere siꞌaye i̱o joyona deꞌhuao. ");
INSERT INTO seyNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ja̱je yoꞌoquë Jesús ai deꞌopi, i̱ ca̱pë cuiꞌne i̱ cuasayeje̱. Maijaꞌquëpi cuiꞌne pa̱ipi co̱ni i̱ deꞌoye paꞌiyere ñajë deꞌoquë api cuasahuë, tayoye peoquëna. ");
INSERT INTO seyNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberio César pa̱i ëjaë pajiꞌi. I̱pi quince o̱metëca cua̱ñequë paꞌi maca Poncio Pilatopi pajiꞌi, Judea cua̱ñequë ëjaë. Herodespi Galilea cua̱ñequë pajiꞌi. I̱ yoꞌjei Felipepi Iturea cuiꞌne Tranconite cua̱ñequë pajiꞌi. Cuiꞌne Lisaniaspi Abilinia cua̱ñequë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌi cato Anás cuiꞌne Caifás paëꞌë. Ja̱ohuaꞌi paꞌi muꞌseña Maijaꞌquëpi Zacarías mamaquë Juanna capi, cue̱ne yejare paꞌina. ");
INSERT INTO seyNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Juan cato Jordán tsiaya quëꞌroja̱ꞌa sai siꞌa hue̱ꞌña pa̱i paꞌicohuaꞌire capi: Ja̱ꞌnë coꞌaye cuasaseꞌere je̱oni po̱nëñe paꞌiji. Po̱nëni oco dosicohuaꞌini Maijaꞌquëpi mësaru coꞌaye yoꞌoseꞌere sa̱i deꞌhuaja̱ꞌquë api. Ja̱je yëhuopi. ");
INSERT INTO seyNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tsoe ja̱ꞌrë Maijaꞌquë caye quëacaiquë Isaíaspi toyaquë paꞌiseꞌeje̱ cuiꞌne ja̱pi ti̱ꞌapi, i̱ toyaseꞌe caji: Cue̱ne yejapi pa̱i cuiꞌneje asa cua̱ñoji, Ne deꞌhuajë̱ꞌë, mai Ëjaë maꞌare. Nuñerepa maꞌa necaijë̱ꞌë, i̱ cuꞌi hue̱ꞌña. ");
INSERT INTO seyNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Yoꞌcohuë paꞌiseꞌere ne ti̱më ja̱ꞌñe aꞌë. Jai cu̱ti cuiꞌne aꞌri cu̱ti paꞌiseꞌere nui yejarepa ne ja̱ꞌñe aꞌë. Nui maꞌaña peoseꞌere nui maꞌaña deꞌhuaye aꞌë. Dea pë̱a quëꞌi maꞌaña paꞌiseꞌere nui yeja ne ja̱ꞌñe aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ja̱ maca Maijaꞌquë pa̱ire huasoye siꞌa pa̱i ñajaꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","I̱te oco do cua̱ñoñuꞌu cajë pa̱ipi i̱ quëꞌrona daicohuaꞌire Juanpi capi: “¡A̲ña tsëcapë acohuaꞌi! ¿Nepi mësarute quëareꞌni, Maijaꞌquë pë̱i nejoquëna, jëa ja̱ꞌñere? ");
INSERT INTO seyNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Po̱nësicohuaꞌi pani, po̱nësicohuaꞌi yoꞌoyere yoꞌojë̱ꞌë. Ja̱je yoꞌojëna, ñani dosiꞌi. Abraham tsëcapë aꞌë camaꞌpë paꞌijë̱ꞌë. Ja̱ caye ti̱ꞌa maꞌñe aꞌë. Maijaꞌquëpi yëni iye quë̱na pë̱aje Abraham tsëcapëre neñe paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tsu̱ꞌupo tsoe ne deꞌhuasicoa, so̱quë ñëa cue̱jaꞌcore. Siꞌa so̱quë ñëa deꞌoye quë̱i maꞌñe cato cu̱eni toana ëocoa. Maijaꞌquë tsu̱ꞌupoje̱ paꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ja̱ maca pa̱ipi i̱te se̱teña: “¿Ja̱je paꞌito i̱quere nejaꞌcohuaꞌi aꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Se̱jëna, Juanpi sehuopi: “Caya juꞌi ca̱ña paquë pani teꞌore i̱siye paꞌiji, ti peoquëna. A̲iñe paquë pani peoquë ja̱ꞌre co̱ni a̱iñe paꞌiji, teꞌe.” ");
INSERT INTO seyNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Paꞌi doꞌi curiquë se̱cohuaꞌije̱ oco do cua̱ñoñuꞌu cajë daisicohuaꞌipi paꞌijë Juanre se̱iꞌë: “¿Yeꞌyaquë, i̱quere yëquë nejaꞌcohuaꞌi aꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Se̱jëna, Juanpi capi: “Cua̱ñeseꞌe caye paꞌina, jerepa curiquë se̱maꞌpë paꞌijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Soldado paꞌicohuaꞌipi i̱te se̱teña: “Cuiꞌne yëquë, ¿i̱quere nejaꞌcohuaꞌi aꞌni?” Cajëna, sehuopi: “Tutu yoꞌojë siomaꞌpë paꞌijë̱ꞌë, yecohuaꞌi payere. Coa coso doꞌire tsiomaꞌpë. Cuiꞌne mësarute sa̱iñere ti̱ꞌapi cuasajë paꞌijë̱ꞌë, sihuani.” ");
INSERT INTO seyNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Juanni Cristo paꞌimaꞌquë cuasajë pa̱i utehuë. I̱ aꞌë caquëna, asañuꞌu cajë. ");
INSERT INTO seyNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Cuasajëna, Juanpi capi: “Ocopi doyë, mësarute. Ja̱ yëꞌtaꞌa yëꞌë jeteyoꞌje daija̱ꞌquë api, yëꞌë jerepa deꞌoquëpi. I̱ joꞌyaë i̱ zapato joyecaiquë yëꞌëre tëto saisiquë api. Yëꞌë jerepa teaye paꞌi aꞌë. Ja̱ë cato doja̱ꞌquë api, Maijaꞌquë joyopi cuiꞌne toapi. ");
INSERT INTO seyNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tsoe pala ca̱jiji, trigo jëoquë i̱ti ca̱seꞌe deꞌhuaquë jaꞌoseꞌe huahueja̱ꞌcore. I̱ti ca̱re paseꞌe i̱ deꞌhua hue̱ꞌñana deꞌhuaquë jaꞌoseꞌe toa ti yayamaꞌcona ëoja̱ꞌquë api.” ");
INSERT INTO seyNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ñeje caquë pa̱ire deꞌo coca yëhuoquë cuiꞌne jaiye yequeje̱ Juan quëapi. ");
INSERT INTO seyNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Cuiꞌne Herodes pa̱i ëjaëpi yoꞌjei Felipe nëjo Herodíasni jioni paquëña. Ja̱je yoꞌo maꞌñe aꞌë caquë cuiꞌne i̱ yeque coꞌaye yoꞌoseꞌena co̱ni yëhuopi, Juan. ");
INSERT INTO seyNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ja̱je quëaquëtaꞌare Herodespi i̱ caye asamaꞌë. Ja̱ yëꞌtaꞌapi yeque coꞌaye yoꞌo co̱quë Juanre coꞌa pa̱ire co hue̱ꞌñana copi. ");
INSERT INTO seyNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ja̱ yëꞌtaꞌa co cua̱ñomaꞌquëpi Juan oco doquë paꞌina, Jesuje̱ do cua̱ñosiquë pajiꞌi, cuiꞌne i̱pi Maijaꞌquëre se̱ maca maꞌtëmopi ja̱ca saiona. ");
INSERT INTO seyNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Maijaꞌquë joyopi suꞌteje̱ paꞌipi i̱na nëca meni pa̱ije ñajëna, ja̱ maca yëꞌoseꞌe maꞌtëmopi jutapi, ñeje: “Mëꞌë aꞌë, yëꞌë mamaquërepa. Mëꞌëni ai sihuaquë paꞌiyë.” ");
INSERT INTO seyNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús treinta o̱metëca paquëpi Maijaꞌquë coꞌamañarepa ne huëopi. Pa̱i caye cato José mamaquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","José pajiꞌi, Elí mamaquë. Elí pajiꞌi, Matat mamaquë. Matat pajiꞌi, Leví mamaquë. Leví pajiꞌi, Melqui mamaquë. Melqui pajiꞌi, Jana mamaquë. Jana pajiꞌi, José mamaquë. ");
INSERT INTO seyNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José pajiꞌi, Matatías mamaquë. Matatías pajiꞌi, Amós mamaquë. Amós pajiꞌi, Nahúm mamaquë. Nahúm pajiꞌi, Esli mamaquë. Esli pajiꞌi, Nagai mamaquë. ");
INSERT INTO seyNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai pajiꞌi, Maat mamaquë. Maat pajiꞌi, Matatías mamaquë. Matatías pajiꞌi, Semei mamaquë. Semei pajiꞌi, José mamaquë. José pajiꞌi, Judá mamaquë. ");
INSERT INTO seyNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá pajiꞌi, Joana mamaquë. Joana pajiꞌi, Resa mamaquë. Resa pajiꞌi, Zorababel mamaquë. Zorobabel pajiꞌi, Salatiel mamaquë. Salatiel pajiꞌi, Neri mamaquë. ");
INSERT INTO seyNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri pajiꞌi, Malqui mamaquë. Melqui pajiꞌi, Adi mamaquë. Adi pajiꞌi, Cosam mamaquë. Cosam pajiꞌi, Elmodam mamaquë. Elmodam pajiꞌi, Er mamaquë. ");
INSERT INTO seyNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er pajiꞌi, Josué mamaquë. Josué pajiꞌi, Elizer mamaquë. Elizer pajiꞌi, Jorim mamaquë. Jorim pajiꞌi, Matat mamaquë. ");
INSERT INTO seyNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat pajiꞌi, Leví mamaquë. Leví pajiꞌi, Simeón mamaquë. Simeón pajiꞌi, Judá mamaquë. Judá pajiꞌi, José mamaquë. José pajiꞌi, Jonán mamaquë. Jonán pajiꞌi, Eliaquim mamaquë. ");
INSERT INTO seyNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim pajiꞌi, Melea mamaquë. Melea pajiꞌi, Mainán mamaquë. Mainán pajiꞌi, Matata mamaquë. Matata pajiꞌi, Natán mamaquë. ");
INSERT INTO seyNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán pajiꞌi, David mamaquë. David pajiꞌi, Isaí mamaquë. Isaí pajiꞌi, Obed mamaquë. Obed pajiꞌi, Booz mamaquë. Booz pajiꞌi, Salmón mamaquë. Salmón pajiꞌi, Naasón mamaquë. ");
INSERT INTO seyNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón pajiꞌi, Aminabab mamaquë. Aminabab pajiꞌi, Aram mamaquë. Aram pajiꞌi, Esrom mamaquë. Esrom pajiꞌi, Fares mamaquë. Fares pajiꞌi, Judá mamaquë. ");
INSERT INTO seyNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá pajiꞌi, Jacob mamaquë. Jacob pajiꞌi, Isaac mamaquë. Isaac pajiꞌi, Abraham mamaquë. Abraham pajiꞌi, Taré mamaquë. Taré pajiꞌi, Nacor mamaquë. ");
INSERT INTO seyNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor pajiꞌi, Serug mamaquë. Serug pajiꞌi, Ragau mamaquë. Ragau pajiꞌi, Peleg mamaquë. Peleg pajiꞌi, Heber mamaquë. Heber pajiꞌi, Sala mamaquë. ");
INSERT INTO seyNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala pajiꞌi, Cainán mamaquë. Cainán pajiꞌi, Arfaxad mamaquë. Arfaxad pajiꞌi, Sem mamaquë. Sem pajiꞌi, Noé mamaquë. Noé pajiꞌi, Lamec mamaquë. ");
INSERT INTO seyNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec pajiꞌi, Matusalén mamaquë. Matusalén pajiꞌi, Enoc mamaquë. Enoc pajiꞌi, Jared mamaquë. Jared pajiꞌi, Mahalaleel mamaquë. Mahalaleel pajiꞌi, Cainán mamaquë. ");
INSERT INTO seyNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán pajiꞌi, Enós mamaquë. Enós pajiꞌi, Set mamaquë. Set pajiꞌi, Adán mamaquë, cuiꞌne Adán pajiꞌi, Diusu mamaquë. ");
INSERT INTO seyNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Maijaꞌquë joyo i̱ni paꞌina, Jordán tsiayapi coꞌiquëna, Maijaꞌquë joyopi sapi, cue̱ne huesësi yejana. ");
INSERT INTO seyNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ja̱rote cuarenta muꞌseña a̱o ti a̱imaꞌë paꞌina, jeteyoꞌje a̱o ëaye nëi maca ");
INSERT INTO seyNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","huatipi i̱te neñasiꞌi, caquë capi: “Maijaꞌquë mamaquë sëte iye quë̱na përe cua̱ñejëꞌë, pan pë deꞌoja̱co.” ");
INSERT INTO seyNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Caquëna, Jesupi i̱te capi: “Toyaseꞌe caji, Coa a̱oseꞌe a̱i paꞌiye peoji, pa̱i. Peoquëna, ai jerepa siꞌaye Maijaꞌquë ca cocare deꞌoye sehuocaiye paꞌiye paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ja̱ jeteyoꞌje huatipi sapi, ai cu̱tihuëna. Sani iye yeja paꞌiyere teꞌepi esa i̱ñopi siꞌaye, pa̱ire cuiꞌne i̱ote paꞌiyeje̱. ");
INSERT INTO seyNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","I̱ñoni huatipi i̱te capi: “Yëꞌëpi mëꞌëre siꞌa iye tutu, cuiꞌne iye jai yejaña deꞌo coꞌamaña i̱sisiꞌi. Yëꞌëna i̱siseꞌe aꞌë, siꞌaye iye. Ja̱je paꞌina, yëꞌë yëyeje̱ i̱siye paꞌiji, yëꞌë i̱siye yëquëna. ");
INSERT INTO seyNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Mëꞌëpi doꞌre jaꞌruni yëꞌëni se̱quë paꞌito mëꞌë tse̱ pasipi.” ");
INSERT INTO seyNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesupi i̱te sehuopi: “Yëꞌë quë̱no maca paꞌimaꞌë paꞌijë̱ꞌë, Satanás. Saijë̱ꞌë. Toyaseꞌe caji: Se̱jëꞌë, më Ëjaë Diusuni cuiꞌne i̱seꞌere necaijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ja̱ jeteyoꞌje huatipi Jerusalén daripëna sani Maijaꞌquë huëꞌe jetena mëani capi: “Maijaꞌquë mamaquërepa pani ti̱to sa to̱mejëꞌë, iye macapi yejana. ");
INSERT INTO seyNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Toyaseꞌe caji: Maijaꞌquëpi i̱ hui̱ñaohuaꞌire cua̱ñeina, mëꞌëre ñacaija̱ꞌcohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Mëꞌëpi to̱mequëna, i̱ohuaꞌi jë̱ñapi tse̱ajaꞌcohuaꞌi aꞌë, Quë̱na pë̱ana më nëcañoa aꞌsi nemaꞌquëni cajë.” ");
INSERT INTO seyNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Caquëna, Jesupi i̱te sehuopi: “Yequeje̱ toyaseꞌe caji: Mëꞌë Ëjaë Diusure neñamaꞌë paꞌijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Caquëna, huati Jesure siꞌaye neñani yoꞌo jujani, tsoe maca je̱oni sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Je̱o saquëna, Jesupi Galileana coꞌipi, Maijaꞌquë joyo tutu ti̱mësiquëpi. Ja̱je paꞌina, pa̱i i̱ paꞌiyere quëajëna, ja̱ yejaña paꞌicohuaꞌi asahuë. ");
INSERT INTO seyNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Pa̱i dari ñape tsiꞌsi huë̱ꞌña paꞌiyena yeꞌyaquë paꞌina, siꞌahuaꞌi i̱te deꞌoquëre papi cajë sihuahuë. ");
INSERT INTO seyNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ja̱ maca Jesús Nazaretna sajiꞌi, i̱ ai deꞌosi daripëna. Huajë muꞌse ti̱ꞌaëna, pa̱i tsiꞌsi huëꞌena cacani jaꞌrupi. Ja̱je i̱ siꞌanë yoꞌoye sëte. Jaꞌrusipi Maijaꞌquë coca pëpë ñasiꞌi caquë huëni nëcapi. ");
INSERT INTO seyNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nëcaquëna, Isaías Maijaꞌquëre quëacaiquë toyaquë paꞌiseꞌere i̱siëña. I̱ti maca aquëpi i̱siquëna, huiꞌyoquë ti̱ꞌapi, ñeje toyaseꞌe paꞌi hue̱ꞌñare: ");
INSERT INTO seyNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Mai Ëjaë joyopi yëꞌëni paꞌiji. Ja̱je paꞌina, yëꞌëna deꞌo cocare i̱sipi, caraja̱icohuaꞌina quëa ja̱ꞌñere. Cuiꞌne ai oicohuaꞌire yëhuo huasoja̱ꞌquë aꞌë. Tse̱a cua̱ñosicohuaꞌi paꞌicohuaꞌire quëa huasoja̱ꞌquë aꞌë. Cuiꞌne ñamaꞌcohuaꞌini ñacohuaꞌire nejaꞌquë aꞌë. Coꞌaye yoꞌojëna, ai yoꞌojë paꞌicohuaꞌini deꞌo paꞌiye i̱sija̱ꞌquë aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Mai Ëjaë oi necai tëcahuëre pa̱ipi asaja̱ꞌcohuaꞌi aꞌë caquë yëꞌëre jëjo daopi. ");
INSERT INTO seyNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ja̱je Jesús ña tëjini tëoni pa̱i tsiꞌsi huëꞌe co̱caiquëna, i̱sini jaꞌrupi. Ja̱ maca siꞌahuaꞌi ai ñahuë, i̱seꞌere, pa̱i tsiꞌsi huëꞌere tsiꞌsicohuaꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ñajëna, i̱ohuaꞌire je̱ꞌnërepa ca huëopi: “Yure iye muꞌse ti̱ꞌapi, iye toyaseꞌe caye mësaru asa maca.” ");
INSERT INTO seyNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Siꞌahuaꞌi Jesús deꞌoquë api cajë i̱ caseꞌere merepa deꞌoye caëna, cajë ai cuasajë sa̱ꞌñe cahuë: “¿Iquë coa José mamaquë api, paꞌimaꞌquë?” ");
INSERT INTO seyNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesupi capi, ja̱ohuaꞌire: “Jujuquë sëte coꞌye jujujë̱ꞌë, caja̱ꞌcohuaꞌi aꞌë. Casicohuaꞌipi yequeje̱ caja̱ꞌcohuaꞌi aꞌë. Capernaum yejana yoꞌoseꞌeje̱ yure i̱ño mëꞌë yejare pana yoꞌojë̱ꞌë, yëquë asaseꞌeje̱.” ");
INSERT INTO seyNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ja̱ maca ai se̱ña maca ca saoquë cuiꞌne capi: “Nuñerepa cayë. I̱ ai deꞌo sito paꞌicohuaꞌi caye Maijaꞌquëre quëacaiquëre teꞌije̱ deꞌoyerepa sihua cua̱ñosiquë peopi. ");
INSERT INTO seyNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Maijaꞌquëre quëacaiquë Elías paꞌi muꞌseñare Israel pa̱i huaꞌjeohuaꞌi jai pa̱i paëꞌë. Ja̱ muꞌseña tres o̱metëca jerepa ocomaꞌëna, siꞌa yeja paꞌicohuaꞌi a̱o ëa ju̱ꞌijë ai yoꞌohuë. ");
INSERT INTO seyNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ja̱je ai yoꞌojëtaꞌare Maijaꞌquëpi Elíasre Israel pa̱i huaꞌjeohuaꞌire jëjo saoye pa̱pi. Paquë Sareptare huaꞌjeo paꞌico quëꞌrona jëjo saopi, Sidón yejana. ");
INSERT INTO seyNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Cuiꞌne Maijaꞌquëre quëacaiquë Eliseo paꞌi muꞌseñaje jai pa̱i Israel pa̱i ja̱ꞌju dahuë ju̱ꞌicohuaꞌi paëꞌë. Paꞌijëtaꞌare teꞌireje̱ jujucaiye pa̱pi. Paquë Siria yeja aquë Naamánni jujucajiꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ja̱je caquëna, asani tsiꞌsisicohuaꞌipi ai pë̱ti huëohuë. ");
INSERT INTO seyNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ja̱ maca huëni nëcani Jesure tse̱ani pa̱i daripë peo hue̱ꞌña hueꞌsena etoni sahuë, cu̱ti sa̱ꞌnihuëre pana. Ja̱ropi jëjo to̱ñuꞌu cajë. I̱ti cu̱tihuëre pa̱i paꞌi daripë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ja̱je jëjo to̱ñuꞌu cajë sasicohuaꞌitaꞌare Jesús i̱ohuaꞌi jopoja̱ꞌa etani sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ja̱ maca Jesús sajiꞌi, Capernaumna Galilea yeja daripëna. Ja̱rona sani huajë muꞌseña pa̱ire yeꞌya huëopi. ");
INSERT INTO seyNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","I̱ohuaꞌire yeꞌyayere asajë ai ñahuë. ¿Merepa ja̱je cua̱ñequë quëayeje̱ paꞌyerepa quëaquëꞌni? cuasajë. ");
INSERT INTO seyNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ja̱ro tsiꞌsi hue̱ꞌñare pajiꞌi, teꞌi ë̱më huati joyo hueꞌequë. Ja̱ëpi cuipi. ");
INSERT INTO seyNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Yëquëre yoꞌomaꞌë. ¿Me nesiꞌquë yëquëre yoꞌoquëꞌni, Jesús Nazaret aquë? ¿Nejosiꞌquë daiquë? Mëꞌëre yëꞌë ñañë. Mëꞌë cato Maijaꞌquë mamaquë, deꞌoquëre paꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ja̱ maca Jesús coꞌa joyore capi: “Camaꞌë. Ja̱ëte je̱oni saijë̱ꞌë.” Ja̱je ca maca coꞌa joyopi pa̱i ña hue̱ꞌñana coꞌaye neñe peoyerepa yejana ne ta̱oni eta sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Siꞌaohuaꞌi ña quëquëni sa̱ꞌñe i̱ohuaꞌija̱ꞌa cahuë: “¿I̱que yëꞌo aꞌni, ja̱ jerepa paꞌye iye? Cua̱ñequëna, huatiohuaꞌije̱ i̱te sehuojë etayë.” ");
INSERT INTO seyNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ja̱je yoꞌoquëna, pa̱ipi Jesús yoꞌoye ayere ja̱ yeja siꞌa hue̱ꞌña quëaroja̱teña. ");
INSERT INTO seyNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ja̱ maca Jesús tsiꞌsi huëꞌepi etani Simón huëꞌena cacapi. Ja̱rote pacoꞌë, Simón huao su̱ña dahuë ai ju̱ꞌicopi. Ja̱je paꞌiona, Jesure jujucaijë̱ꞌë, cajë se̱iꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ja̱ maca Jesús su̱ña dahuë ju̱ꞌiconi ñaquë su̱ña dahuëre piꞌra saouna, su̱ña dahuë peocopi huëni a̱ore neni a̱o. ");
INSERT INTO seyNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ë̲së cara mesi maca jai pa̱ire ju̱ꞌicohuaꞌire dahuë, coa siꞌa ju̱ꞌi dahuë quëꞌiohuaꞌire Jesuna. Dajëna, ju̱ꞌicohuaꞌire i̱ jë̱tëpi pa̱i ñapere patoquëna, coꞌyahuë, siꞌaohuaꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ju̱ꞌicohuaꞌire paꞌisicohuaꞌipi huatiohuaꞌi etajë Maijaꞌquë mamaquëre papi cuijëna. Jesupi ja̱ cayere ë̱sepi, tsoe i̱ohuaꞌipi Maijaꞌquë jëjo daoquë Cristo api asa doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Jesús nea hue̱ꞌñarepa pa̱i peo hue̱ꞌñana saquëna, saimaꞌquëni cajë coꞌejë ti̱ꞌahuë. ");
INSERT INTO seyNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ti̱ꞌasi maca Jesupi capi, ja̱ohuaꞌire: “Quëaye paꞌiji, deꞌo coca Maijaꞌquë paꞌi te̱ꞌte ayere yequë pa̱i daripë̱aje. Ja̱re caquë jëjo daosiquë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ja̱je Jesús cuꞌi quëaroja̱jiꞌi, Galilea tsiꞌsi huë̱ꞌñana. ");
INSERT INTO seyNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jesús Genesaret Jaira të̱ꞌtëpare paꞌi quëaquëna, jai pa̱i quiꞌiyerepa Maijaꞌquë coca asañuꞌu cajë dateña. ");
INSERT INTO seyNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Daijëna, Jesupi caya yohuë, peo huë̱api huahuaquëna, ñapi. I̱ti yohuë acohuaꞌipi yoꞌe nëare tsoa to̱ñuꞌu cajë tu̱mareña. ");
INSERT INTO seyNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ñani ja̱ maca Jesús yohuëna aya mëjiꞌi. I̱ aya mëisi yohuë Simón tse̱ pacoꞌë. Ja̱ maca capi, aꞌri maña soꞌona jëjo sao huahuojë̱ꞌë, yohuë. Huahuojëna, jaꞌruni ñuꞌi Jesús pa̱ire yeꞌya huëopi. ");
INSERT INTO seyNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yeꞌya tëjini Simónre capi: “Huaꞌi paꞌi hue̱ꞌñana yohuëja̱ꞌa sani mësaru yoꞌe nëapi huaꞌire neñuꞌu.” ");
INSERT INTO seyNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simónpi sehuopi: “Yeꞌyaquë, siꞌa ñami teꞌe huaꞌireje̱ neñe peoyerepa ai yoꞌohuë, nemaꞌpë. Ja̱je pa̱sicohuaꞌitaꞌa mëꞌëpi cua̱ñeñe sëte huaꞌi yoꞌerë je̱o dëosiꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Cani je̱o dëosi maca huaꞌipi airepa ti̱mërena, huaꞌi yoꞌerëpi tëi huëo. ");
INSERT INTO seyNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ja̱ maca yequë yohuëre cajeohuaꞌi paꞌicohuaꞌire jë̱ñapi soihuë. Soina, dani siꞌahuaꞌi caya yohuë̱a ea tete macarepa aya ti̱mëhuë. ");
INSERT INTO seyNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ja̱ maca Simón Pedro iyere ñani doꞌre jaꞌruni Jesure capi: “Saijë̱ꞌë, Ëjaë, yëꞌë quë̱no maca paꞌimaꞌë. Yëꞌë coꞌaye yoꞌoquë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Coa quëquë huesëni ja̱je caquëna, i̱ ja̱ꞌre co̱ni paꞌicohuaꞌije̱ huaꞌire neseꞌere cuasajë ai quëquëhuë. ");
INSERT INTO seyNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Cuiꞌne, Zebedeo mamajë Jacobo cuiꞌne Juan, Simón cajeohuaꞌije̱ quëquë huesësicohuaꞌi paëꞌë. Ja̱je quëquëjëtaꞌare Jesús capi, Simónre: “Caꞌramaꞌë paꞌijë̱ꞌë. Mëꞌë yurepi pa̱ire yoꞌecaiquë paꞌija̱ꞌquë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ja̱ maca yohuë̱are të̱ꞌtëpana sani je̱oni Jesús ja̱ꞌre saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesús pa̱i daripëre paꞌina, teꞌi pa̱i ja̱ꞌju dahuë ju̱ꞌiquëpi ti̱tani Jesure ñani i̱ tsiapi yejare pana se̱meni se̱jiꞌi. Ñeje caquë: “Ejaë, mëꞌëpi yëꞌëre jujuye yëni jujujë̱ꞌë. Yëꞌë ju̱ꞌi dahuë.” ");
INSERT INTO seyNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ja̱ maca Jesús i̱ jë̱tëpi patoquë capi: “Yëꞌë jujucaiyë.” Caquëna, ja̱re i̱ti macapi ja̱ꞌju dahuë peoquë deꞌopi. ");
INSERT INTO seyNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ja̱ maca Jesús i̱te capi: “Quëamaꞌë paꞌijë̱ꞌë, pa̱ire. Coa Maijaꞌquë huëꞌe ñacaicohuaꞌiseꞌere sani i̱ñojëꞌë. I̱ñoni mëꞌë coꞌayere tsoa to̱quë yoꞌo doꞌire i̱sijë̱ꞌë, Moisés cua̱ñequë paꞌiseꞌere. Ja̱je yoꞌoquëna, siꞌa huaꞌi mëꞌë ju̱ꞌiquë paꞌisiquëpi deꞌoquë po̱nëni yoꞌoye ñajaꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ja̱je paꞌiquëtaꞌare Jesús yoꞌoyepi jero saꞌana jai sajiꞌi. Ja̱je paꞌina, jai pa̱i i̱ caye asañuꞌu cajë daijëna, ju̱ꞌicohuaꞌije̱ daëꞌë, juju cua̱ñoñuꞌu cajë. ");
INSERT INTO seyNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ja̱je yoꞌojëna, Jesús pa̱i peo hue̱ꞌñana sai Maijaꞌquëre se̱jiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Jesupi yeꞌyaquëna, ja̱rote jaꞌrusicohuaꞌipi ñuëꞌë. Fariseo acohuaꞌi cuiꞌne cua̱ñeseꞌe yeꞌyacohuaꞌi co̱ni, Galilea yejare siꞌa hue̱ꞌña paꞌicohuaꞌipi daisicohuaꞌi paëꞌë. Paꞌijëna, yecohuaꞌipi Judeapi cuiꞌne Jerusalénpi daisicohuaꞌije̱ paëꞌë. Paꞌijëna, Jesupi pajiꞌi, Maijaꞌquë tutu ju̱ꞌicohuaꞌire jujucaiye. ");
INSERT INTO seyNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Paquëna, yoꞌoye peoquëpi ju̱ꞌiquëni ca̱i saihuëna o̱asiquëni cua̱ijë Jesús paꞌi hue̱ꞌña co̱areña, ñajaquë cajë. ");
INSERT INTO seyNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Dajëtaꞌare caca hue̱ꞌñapi jai pa̱i ti̱mësico paꞌi doꞌire cacaye pa̱jë ña jujani huëꞌe jeteja̱ꞌa mëni peo coje tëteni ju̱ꞌiquëre pa̱i jopoja̱ꞌa meñe casahuë, Jesús ña hue̱ꞌña ca̱i saihuëna o̱asiquëni. ");
INSERT INTO seyNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ja̱ maca Jesús i̱ohuaꞌipi i̱te jujuquë api cuasayere ñani ju̱ꞌiquëre capi: “Mëꞌë coꞌaye yoꞌoseꞌere sa̱i deꞌhuacaiyë.” ");
INSERT INTO seyNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ja̱je caquëna, asani cua̱ñeseꞌe yeꞌyacohuaꞌi cuiꞌne fariseohuaꞌi cuasa huëoreña: “Pa̱ipi yequë coꞌaye yoꞌoseꞌere sa̱i deꞌhuacaiye peoji. Ja̱re Maijaꞌquëseꞌe sa̱i deꞌhuacaiye paꞌiji. ¿I̱queiꞌni, iquë ja̱ jerepa Maijaꞌquëre cueꞌcuequë caquë?” ");
INSERT INTO seyNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesupi ja̱je cuasajëna, ñani capi: “¿Me yoꞌojë ja̱je cuasayeꞌni? ");
INSERT INTO seyNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Coꞌaye yoꞌoseꞌere sa̱i deꞌhuaye cuiꞌne iquëre jujucaiye pa̱i cato yoꞌo ti̱ꞌa maꞌñe aꞌë. A̲ꞌjiñe yoꞌoye peoji. ");
INSERT INTO seyNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ja̱je paꞌito deꞌoji. I̱ñosiꞌi, mësarute. Yëꞌë Pa̱i Mamaquëpi teꞌipi iye yeja cua̱ñequëre papi coꞌaye yoꞌoseꞌere sa̱i deꞌhuacaiquë paꞌiyë.” Ja̱je se cani ju̱ꞌiquëre capi: “Mëꞌëni cayë, huëijë̱ꞌë. Më u̱icore i̱ni mëꞌë huëꞌena saijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Caquëna, ja̱ macarepa i̱ti ju̱ꞌiquë paꞌisiquëpi ja̱ohuaꞌi ñajëna, huëni nëcani i̱ u̱isicore se deꞌhuani Maijaꞌquëre sihuaquë caquë sajiꞌi, i̱ huëꞌena. ");
INSERT INTO seyNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Saina, siꞌahuaꞌi ña quëquëni Maijaꞌquëre sihuajë careña. “Yurena ñahuë, pa̱ije yoꞌo maꞌñere yoꞌoye.” ");
INSERT INTO seyNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Iye yoꞌosi jeteyoꞌje Jesús etaquë Leví hueꞌequëre ñapi, paꞌi doꞌi sa̱i hue̱ꞌñare ñuꞌi curire se̱ina, ñani capi: “Tuijë̱ꞌë, yëꞌëni.” ");
INSERT INTO seyNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ja̱ maca Leví i̱ yoꞌoye siꞌaye se je̱oni Jesús ja̱ꞌre co̱ni sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ja̱ jeteyoꞌje Leví jai fiesta nepi, i̱ huëꞌena, Jesuni sihuaquë. Ja̱rote cuiꞌne jai pa̱i paꞌi doꞌi se̱cohuaꞌi cuiꞌne yecohuaꞌi co̱ni a̱i saihuëna jaꞌrusicohuaꞌipi paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Paꞌijëna, ñani fariseohuaꞌi cuiꞌne cua̱ñeseꞌe yeꞌyacohuaꞌi Jesure yeꞌyecohuaꞌipi deꞌoye yoꞌomaꞌcohuaꞌi aꞌë, cuasajë sa̱ñope ca huëojë careña: “¿Me yoꞌojë mësaru paꞌi doꞌi se̱cohuaꞌi ja̱ꞌre cuiꞌne coꞌaye yoꞌocohuaꞌi ja̱ꞌre co̱ni a̱ijë cuiꞌne u̱cuyeꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Cajëna, asani Jesupi sehuopi: “Deꞌoye paꞌicohuaꞌi cuiꞌne huajëcohuaꞌi jujuquëre coꞌeye pa̱ñë. Ja̱je paꞌina, ju̱ꞌicohuaꞌipi coꞌecohuaꞌi aꞌë, jujuquëre. ");
INSERT INTO seyNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ja̱ doꞌire deꞌocohuaꞌini soisiꞌi caquë, daisiquë peoyë. Coꞌacohuaꞌini soisiꞌi caquë daisiquë aꞌë, ja̱ohuaꞌipi ja̱ꞌrë yoꞌoseꞌe je̱oni po̱nëjajë caquë.” ");
INSERT INTO seyNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Caquëna, i̱ohuaꞌipi Jesure se̱teña: “Juanre yeꞌyecohuaꞌi yoꞌoye sëte a̱imaꞌpë Maijaꞌquëre ai se̱jë yoꞌoyë, cuiꞌne fariseo yeꞌyecohuaꞌije̱. ¿Me yoꞌojë mëꞌë yeꞌyacohuaꞌiseꞌe siꞌanë a̱ijë cuiꞌne u̱cujë paꞌiyeꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Cajëna, Jesupi sehuopi: “¿Hueja a̱o a̱ijaꞌcohuaꞌire soisicohuaꞌire a̱imaꞌpë paꞌijë̱ꞌë cacohuaꞌi aꞌni, mësaru, huejaquëpi i̱ti macare co̱ni paꞌito? ");
INSERT INTO seyNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ja̱je paꞌiquëtaꞌare yequë muꞌse huejaquëre yëꞌëre sioye paꞌiji. Ja̱ maca huejaquëpi peoëna, a̱o a̱imaꞌpë paꞌija̱ꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Cuiꞌne quëa i̱ñopi, i̱ohuaꞌi ñañena co̱ni ñeje: “Yecohuaꞌije̱ huajë juꞌi ca̱re tëani ai juꞌi ca̱re sëomaꞌcohuaꞌi aꞌë. Ja̱je yoꞌocohuaꞌi pani coa huajë juꞌi ca̱re nejoñë. Cuiꞌne huajë ca̱ ca̱tipëpi ai juꞌi ca̱na sëosicohuaꞌi paꞌito teꞌoje̱ paꞌio ña cua̱ñoñe pa̱ji. ");
INSERT INTO seyNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ja̱re cuiꞌne paꞌiji. Cuiyaꞌi co̱no doye peoji, ai ca̱ꞌnihuë deꞌhuasicona. Ja̱je ai ca̱ꞌnihuëna huajë cuiyaꞌi co̱no doto yete saiye paꞌiji. Ja̱je yete saina, siꞌaye nejoñe paꞌiji, cuiyaꞌi co̱no cuiꞌne ca̱ꞌnihuë deꞌhuasi topëje̱ nejoñe paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ja̱je paꞌina, huajë cuiyaꞌi co̱no doye paꞌiji, ja̱re cuiꞌne huajë ca̱ꞌni topëna. Ja̱je huajëyeseꞌe paꞌi deꞌoye quëcoja̱ꞌcoa. ");
INSERT INTO seyNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ja̱je paꞌina, oꞌsasi co̱no u̱cucohuaꞌije̱ huajë co̱no u̱cuye pa̱ñë, oꞌsasi co̱no ai deꞌoye aꞌë, cajë.” ");
INSERT INTO seyNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Teꞌe huajë muꞌse Jesús ta̱ sitoja̱ꞌa saina, i̱re yeꞌyecohuaꞌipi trigo tsa̱ꞌña tëajë saëꞌë. Yoꞌoni jeteyoꞌje jë̱ñapi i̱ti ca̱seꞌe poꞌtejë a̱ëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ja̱je yoꞌojëna, fariseo acohuaꞌipi ñani se̱iꞌë: “¿Moisés cua̱ñeseꞌe caji huajë muꞌse yoꞌoye peoji. Ja̱je paꞌiquëtaꞌare me neñuꞌju yoꞌoyeꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Cajëna, Jesupi sehuopi: “¿Ñamaꞌcohuaꞌini David cuiꞌne i̱ cajeohuaꞌi co̱ni a̱o ëa ju̱ꞌijë yoꞌoseꞌe? ");
INSERT INTO seyNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Maijaꞌquë huëꞌe ñacaicohuaꞌiseꞌe Maijaꞌquëna i̱siseꞌere a̱o a̱iñere a̱o ëa ju̱ꞌi Maijaꞌquë huëꞌena cacani a̱ore i̱mani a̱i cuiꞌne i̱ ja̱ꞌre paꞌicohuaꞌireje̱ a̱opi.” ");
INSERT INTO seyNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Cuiꞌne capi, ja̱ohuaꞌire: “Pa̱i Mamaquëre papi tutu payë, huajë muꞌse paꞌitoje̱ cua̱ñeñe.” ");
INSERT INTO seyNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Yëquë huajë muꞌse Jesús pa̱i tsiꞌsi huëꞌena cacani, yeꞌya huëoquëna, ja̱rote pajiꞌi, teꞌi ë̱më ëja tëꞌhui jë̱tëre cue̱nesicore hueꞌequë. ");
INSERT INTO seyNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Paꞌina, cua̱ñeseꞌe yeꞌyacohuaꞌi cuiꞌne fariseohuaꞌi co̱ni cuasahuë. Jesupi huajë muꞌsere jujuquëna, ñani i̱te sa̱ñope cañuꞌu cajë utejë ñahuë. ");
INSERT INTO seyNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ja̱je cuasaye ñaquëtaꞌa cue̱nesi jë̱të hueꞌequëre capi: “Huëijë̱ꞌë. Huëni ja̱ maca jopore pare nëcajë̱ꞌë.” Caquëna, huëni nëcapi. ");
INSERT INTO seyNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ja̱ maca Jesús yecohuaꞌire capi: “Se̱siꞌi, mësarute teꞌore. ¿I̱quepi deꞌoquëꞌni, huajë muꞌse yoꞌoye, deꞌoye panitaꞌa coꞌaye? ¿Pa̱ire huasoye panitaꞌa pa̱ire coa nejoñe?” ");
INSERT INTO seyNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ja̱ maca siꞌahuaꞌire se̱ña tëꞌija̱ni Jesús capi, ju̱ꞌiquëre: “Më jë̱tëre mëajëꞌë.” Caquëna, i̱ caseꞌeje̱ yoꞌopi. Yoꞌoquëna, i̱ jë̱të cue̱nesico paꞌisico deꞌoco pacoꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ja̱je yoꞌoquëna, ñani yecohuaꞌi ai pë̱ti ëaye ñajë ca huëohuë, sa̱ꞌñe i̱quepi Jesure sa̱ñope neꞌñe paꞌioni cajë. ");
INSERT INTO seyNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ja̱ muꞌseña Jesús Maijaꞌquëre se̱siꞌi caquë sajiꞌi, ai cu̱tihuë. Ja̱ropi siꞌa ñami Maijaꞌquëre se̱jiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ñata to̱mesi maca i̱ yeꞌyacohuaꞌire soini doce paꞌiohuaꞌi i̱ ja̱ꞌre paꞌicohuaꞌire hueꞌyopi, jëjo daocohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ja̱ohuaꞌi cato paëꞌë: Simón, ja̱re ja̱ëni se hueꞌyo co̱siquë pajiꞌi, Pedro. Cuiꞌne i̱ yoꞌjei, Andrés pajiꞌi. Jacobo, Juan, Felipe, Bartolomé, ");
INSERT INTO seyNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, cuiꞌne Alfeo mamaquë Jacobo pajiꞌi. Simón Cananista tsëcapë aquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas Jacobo yoꞌjei pajiꞌi. Cuiꞌne yequë Judas Iscariote Jesure yehuoja̱ꞌquëje̱. ");
INSERT INTO seyNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús ai cu̱tihuëpi i̱ yeꞌyacohuaꞌi ja̱ꞌre co̱ni cajequëpi perepë yejana pëapi. Ja̱rote jai pa̱i paëꞌë. Siꞌa hue̱ꞌña acohuaꞌi, yecohuaꞌipi Judea cuiꞌne Jerusalén cuiꞌne jai tsiaya të̱ꞌtëpa Tiro cuiꞌne Sidón quëꞌro acohuaꞌi daisicohuaꞌi paëꞌë, Jesús cayere asañuꞌu cajë cuiꞌne i̱ohuaꞌi ju̱ꞌi dahuëre jujucaija̱quë cajë daisicohuaipi. ");
INSERT INTO seyNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Huati yoꞌoquëna, ai yoꞌojë paꞌicohuaꞌipi juju cua̱ñosicohuaꞌi deꞌohuë. ");
INSERT INTO seyNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Siꞌa pa̱i Jesure patosicohuaꞌipi i̱ tutupi siꞌahuaꞌi coꞌyasicohuaꞌi paëꞌë. Jujusicohuaꞌire ñani pato doꞌire siꞌahuaꞌi yëhuë, patoye. ");
INSERT INTO seyNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ja̱ maca Jesús i̱ yeꞌyacohuaꞌire ñani capi: “Sihuacohuaꞌi paꞌijë̱ꞌë, mësaru teaye paꞌiohuaꞌi, Maijaꞌquë te̱ꞌtena deꞌoye cacani paja̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Sihuacohuaꞌi paꞌijë̱ꞌë, mësaru a̱o a̱i ëa ju̱ꞌicohuaꞌipi jeteyoꞌje siꞌaye ti̱ꞌajaꞌcohuaꞌipi. Sihuacohuaꞌi paꞌijë̱ꞌë, oicohuaꞌi paꞌisicohuaꞌipi jeteyoꞌje soja̱ꞌcohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Pa̱i Mamaquëre tui doꞌire pa̱ipi mësarute pë̱ijë coejë i̱ohuaꞌi quëꞌrore etojë cueꞌcueye paꞌiji. Ja̱je yoꞌoto sihuajë̱ꞌë, yëꞌëre tui doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ja̱je yoꞌojëna, ai sihuajë̱ꞌë, maꞌtëmona mësarute caquë deꞌhuacaisi coꞌamañare jerepa paja̱ꞌcohuaꞌipi. Mësarute coꞌaye yoꞌoyeje̱ paꞌye yoꞌoa̱ꞌhuëꞌë, Maijaꞌquë tsoe hue̱ꞌña quëacaicohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ja̱je paꞌiquëtaꞌare jaiye yure coꞌamaña pajë sihua to̱sicohuaꞌiretaꞌa, sihuaye peoja̱ꞌcoa. ");
INSERT INTO seyNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Teayerepa mësaruretaꞌa yure a̱o a̱ni ti̱mëni sihuajë paꞌisicohuaꞌire jeteyoꞌje a̱o ëa ju̱ꞌiñe pasipi. Teayerepa mësaru yure so huajëjë paꞌisicohuaꞌiretaꞌa jeteyoꞌje oiye pasipi. ");
INSERT INTO seyNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Teayerepa mësaru paꞌiyeꞌni siꞌa pa̱i deꞌo pa̱ire paꞌë cajëna, paꞌicohuaꞌi maña. Tsoe acohuaꞌije̱ ja̱je cuiꞌne deꞌocohuaꞌi aꞌë caꞌa̱huëꞌë, Maijaꞌquë jëjo daocohuaꞌije̱ paꞌicohuaꞌitaꞌa coa cosocohuaꞌini. ");
INSERT INTO seyNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ja̱je paꞌiquëtaꞌare mësaru yëꞌëre asacohuaꞌire cayë: Oijë̱ꞌë, mësarute sa̱ñope cacohuaꞌire. Deꞌoye yoꞌocaijë̱ꞌë, mësarute coecohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Deꞌoye paꞌi ja̱ꞌñere cacaijë̱ꞌë, mësaruni sa̱ñope ai yoꞌo ja̱ꞌñere de cacohuaꞌini. Se̱cacaijë̱ꞌë, mësarute tea ju̱ꞌicohuaꞌireje̱. ");
INSERT INTO seyNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Yecohuaꞌipi tsiana teꞌe te̱ꞌte tëtoru yequë te̱ꞌte tsiaje̱ nëocaijë̱ꞌë. Cuiꞌne yecohuaꞌipi më sësëquëna juꞌiconi jioni sato huëꞌehuë juꞌicoreje̱ se i̱si saojë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Se̱cohuaꞌi paꞌito i̱sijë̱ꞌë. Yeque më tse̱coni jiosicohuaꞌi paꞌito, coa ñajëꞌë, cuiꞌnaoni se̱ñe pa̱jëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Yecohuaꞌipi mësaruni deꞌoye yoꞌoja̱jë cuasayeje̱ paꞌye yecohuaꞌini se deꞌoye yoꞌojë̱ꞌë, mësarupi. ");
INSERT INTO seyNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","¿Ja̱je paꞌiquëtaꞌare mësarupi mësarute oicohuaꞌiseꞌere oicohuaꞌi pani, i̱quere deꞌoye yoꞌoyeꞌni? Coꞌahuaꞌije̱ cuiꞌne sa̱ꞌñe oiyere yoꞌocohuaꞌi pani. ");
INSERT INTO seyNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","¿Ja̱je paꞌina, mësarupi mësarute deꞌoye yoꞌocohuaꞌiseꞌere deꞌoye yoꞌoni i̱quere deꞌoye yoꞌoyeꞌni? Coꞌacohuaꞌije̱ cuiꞌne yoꞌoyere yoꞌoni. ");
INSERT INTO seyNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","¿Ja̱je mësarupi deꞌoye coꞌyocohuaꞌiseꞌere coꞌyoja̱ꞌcohuaꞌi aꞌë cuasajë i̱sicohuaꞌi pani i̱quere deꞌoye yoꞌoyeꞌni? Coꞌacohuaꞌije̱ coꞌyoja̱ꞌcohuaꞌi aꞌë cuasajë yoꞌoyere yoꞌoni. ");
INSERT INTO seyNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ja̱je paꞌiquëtaꞌare mësaru cato oiye paꞌiji, mësarute sa̱ñope yoꞌocohuaꞌire. Ja̱ohuaꞌire deꞌoye yoꞌojë i̱siye paꞌiji, coꞌyoja̱ꞌcohuaꞌi aꞌë cuasaye peoyerepa. Ja̱je yoꞌosicohuaꞌini maꞌtëmo jaiye deꞌo coꞌamaña i̱siye paꞌiji. Cuiꞌne mësaru paꞌija̱ꞌcohuaꞌi aꞌë, Maijaꞌquë Ëjaërepa mamajë, cuiꞌne i̱je oiquë api, coꞌacohuaꞌire cuiꞌne i̱ i̱siyere deꞌoji camaꞌcohuaꞌireje̱. ");
INSERT INTO seyNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ja̱je cuiꞌne mësaruje̱ oijë̱ꞌë, yecohuaꞌire, Maijaꞌquë oiyeje̱. ");
INSERT INTO seyNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ja̱je paꞌina, coꞌacohuaꞌi aꞌë camaꞌpë paꞌijë̱ꞌë, yecohuaꞌire. Ja̱je pa̱jëna, Maijaꞌquëje̱ mësarute coꞌacohuaꞌi aꞌë caye pa̱jaꞌquë api. Yecohuaꞌire nejoñe pa̱jëꞌë. Ja̱je pa̱jëna, Maijaꞌquëje̱ mësarute nejoñe pa̱sipi. Yecohuaꞌi tayo yoꞌoyere sa̱i deꞌhuacaijëna, Maijaꞌquëje̱ mësaru tayo yoꞌoye sa̱i deꞌhuacaija̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Yecohuaꞌire i̱sicohuaꞌi paꞌijëna, Maijaꞌquëje̱ mësarute i̱sisipi. I̱sija̱ꞌquë api, i̱ topëna deꞌoye cuasa ti̱ꞌacore pani. Dëso quiosiconi, ñaꞌco quiosiconi, ti̱mësicore pani, mësaru yecohuaꞌire i̱siyeje̱ paꞌye Maijaꞌquëje̱ i̱sija̱ꞌquë api, mësarute.” ");
INSERT INTO seyNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesupi ñeje yoꞌoyeje̱ paꞌye aꞌë capi: “Ñamaꞌquëpi yequë ñamaꞌquëni sai saquë paꞌito cojena to̱mejaꞌcohuaꞌi aꞌë, siꞌa jupë. ");
INSERT INTO seyNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Yeꞌyecohuaꞌipi i̱ohuaꞌire yeꞌyaquëre tëto saisicohuaꞌi peoyë. Yeꞌye tëjinitaꞌa ti̱ꞌañe paꞌiji, i̱ohuaꞌire yeꞌyaquëje̱ paꞌiohuaꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Me ja̱je paꞌito, mëꞌë yoꞌjei ñacoare neꞌcua paꞌicore se ñaquë casiꞌni? ¿Mëꞌë ñacoare so̱quë tiro jaꞌiore papi juꞌicore duꞌru ñamaꞌë paꞌini? ");
INSERT INTO seyNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Mëꞌë ñacoare pare so̱quë tiropi juꞌiona ti ñamaꞌë paꞌiquëpi me mëꞌë yoꞌjeire casiꞌni: ‘Huau, mëꞌë ñacoare neꞌcua juꞌicore dutasiꞌi, nëocaijë̱ꞌë.’ Deꞌoquëre paꞌë coa caquë yoꞌoquë maca. Mëꞌëpi duꞌru macarepa mëꞌë ñacoare so̱quë tiro juꞌiconi duta je̱ojëꞌë. Jeteyoꞌje deꞌoye ñaquëpi mëꞌë yoꞌjeire neꞌcua juꞌicore dutacaiye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Deꞌo so̱quë yëpi coꞌa ca̱ quë̱iñe peoji. Ja̱je cuiꞌne coꞌa so̱quë yëje̱ deꞌo ca̱ quë̱iñe peoji. ");
INSERT INTO seyNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ja̱je paꞌina, so̱quë ñëa ñape ñañe paꞌiji, i̱ti quë̱iñena. Miu so̱quë yë pani quë̱iñe pa̱ji, co̱sa ca̱re. Ja̱je cuiꞌne miu pi̱si pani quë̱iñe pa̱ji, cuiyaꞌi ca̱re. ");
INSERT INTO seyNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ja̱je paꞌina, deꞌo pa̱i pani caji, deꞌoyere, i̱ joyo deꞌoyepi paꞌiyere. Cuiꞌne coꞌaquë pani coꞌayere caji, i̱ joyo coꞌayepi paꞌiyere. Yëꞌopopi caji, joyo paꞌiyepi etaquëna. ");
INSERT INTO seyNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Me yoꞌojë mësaru yëꞌëre Ëjaë, Ëjaë cajëtaꞌa yëꞌë cayeje̱ ne maꞌñeꞌni? ");
INSERT INTO seyNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Quëasiꞌi, yëꞌëna dani asacohuaꞌipi cuiꞌne yëꞌë cayeje̱ yoꞌocohuaꞌi paꞌiyere. Iyeje̱ paꞌye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ja̱ohuaꞌi cato ë̱më cu̱tihuëna nëconi huëꞌe nesiquëje̱ paꞌi paꞌiji. Tsiayapi coꞌjenije ti̱ꞌamaꞌëna ta̱iñe pa̱jaꞌquë api. Deꞌo yejana nesi doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ja̱je paꞌiquëtaꞌare asaquëtaꞌa yëꞌë caseꞌeje̱ yoꞌomaꞌquëpi mejahuëna nëconi huëꞌe nesiquëje̱ paꞌi paꞌiji. Tsiaya coꞌjeni ai tutu tsa̱ꞌina ta̱iñe paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesús coca ca tëjini sajiꞌi, Capernaum yejana. ");
INSERT INTO seyNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ja̱rote romano soldado pa̱i capitán i̱ joꞌyaë i̱ oiquëre papi ju̱ni huesë tëjiquëre paquëpi pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ja̱je paꞌina, capitánpi Jesure asani jëjo saopi, judío aiohuaꞌi acohuaꞌini, dani i̱ joꞌyaëre jujucaija̱ꞌquëre se̱ni daja̱ꞌcohuaꞌire caquë. ");
INSERT INTO seyNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ja̱ohuaꞌi Jesure tsioja̱ni ai se̱ huëohuë, ñeje cajë: “Iye capitán deꞌoquë api, mëꞌëpi i̱te co̱catiꞌñe paꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Cuiꞌne judío pa̱ire oiquë api. Ja̱je yoꞌoquëpi pa̱i tsiꞌsi huëꞌe sa̱icaina, mai se̱core nehuë.” ");
INSERT INTO seyNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ja̱je cajëna, Jesús asani i̱ohuaꞌi ja̱ꞌre co̱ni sajiꞌi. Saijë i̱ huëꞌe ti̱ꞌañe jaꞌi macare paꞌijëna, capitánpi jëjo daopi i̱ cajeohuaꞌire Jesure ñeje quëaja̱ꞌcohuaꞌire: “Ëjaë, ai yoꞌomaꞌë paꞌijë̱ꞌë. Ja̱je paꞌina, cayë yëꞌë coꞌaquë huëꞌena daimaꞌë paꞌijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","Yëꞌë ëjaohuaꞌi cua̱ñeñere yoꞌoquë paꞌiquëpi yëꞌë soldado pa̱ire meñe cua̱ñequëna, sehuocohuaꞌire payë. Ja̱je paquëpi yëꞌëpi cayë, ja̱ohuaꞌi aquëni: ‘Saijë̱ꞌë,’ caëna, saiji. Cuiꞌne yequëni ‘daijë̱ꞌë’ caru, daiji. Cuiꞌne yëꞌë joꞌyaëni: ‘ja̱re nejëꞌë’ cua̱ñeru neji. Ja̱je mëꞌëpi coꞌyajë̱ꞌë cua̱ñeru, yëꞌë joꞌyaëpi coꞌyasipi asayë, yëꞌë. Ja̱je paꞌina, daimaꞌë cua̱ñejëꞌë, yëꞌë joꞌyaë coꞌyaja̱quë.” ");
INSERT INTO seyNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ja̱je caseꞌere asani Jesús ai sihuapi, ta̱ꞌñe caquëre papi paꞌiquëꞌni caquë. Ja̱je cuasani i̱te tuicohuaꞌire capi: “Ti ñamaꞌë paëꞌë, Israel pa̱ipi ja̱je yëꞌëre necaija̱ꞌquë api cuasacohuaꞌire iquë yoꞌoseꞌeje̱ care paye.” ");
INSERT INTO seyNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ja̱ maca i̱ jëjo daosicohuaꞌi huëꞌena coꞌini capitán joꞌyaë tsoe coꞌyasiquëni ti̱ꞌahuë. ");
INSERT INTO seyNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Iye yoꞌosi jeteyoꞌje Jesús sajiꞌi, Naín hueꞌe daripëna. Saina, cuiꞌne i̱ yeꞌyacohuaꞌi cuiꞌne jai pa̱i co̱ni saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Pa̱i daripë eta saꞌrona jaꞌye ti̱ꞌasi maca ju̱ꞌisiquëni ta̱ñuꞌu cajë sacohuaꞌire ñapi. Jai pa̱i co̱ni saëꞌë, i̱ti daripë acohuaꞌije̱. Pëca jaꞌquë ju̱quëna, huaꞌjeopi teꞌire nëcoquëpi ju̱ꞌisiquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ja̱je saijëna, Ëjaëpi ja̱ote teaye ñani oi capi: “Oimaꞌo.” ");
INSERT INTO seyNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ja̱ maca Jesús tsioja̱ni mahuëna patopi. Patoquëna, i̱ti sacohuaꞌi nëcaja̱ëꞌë. Ja̱ maca Jesús ju̱ꞌisiquëni capi: “Po̱së, yëꞌëpi cayë mëꞌëre, huëijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Caquëna, i̱ti ju̱ꞌisiquëpi huëni jaꞌruni coca ca huëopi. Pëca jaꞌcona huëoni i̱sipi, Jesús. ");
INSERT INTO seyNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ja̱ maca iyere ñani siꞌahuaꞌi quëquëni Maijaꞌquëre deꞌoquëre paꞌni sihuajë ca huëohuë ñeje: “Mai aquëpi Maijaꞌquë quëacaiquë paꞌiji, jerepa paꞌipi.” Cuiꞌne cahuë: “Maijaꞌquëpi i̱ pa̱ire co̱casiꞌi caquë dajiꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ja̱je Jesús yoꞌoseꞌere Judea paꞌicohuaꞌi cuiꞌne Judea yeja niamoa paꞌicohuaꞌije̱ asahuë. ");
INSERT INTO seyNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Juanpi siꞌaye iye yoꞌoseꞌere asapi, i̱te yeꞌyecohuaꞌipi quëajëna. Ja̱je asani daija̱ꞌquë api ca nëosiquë ¿Cristorepa paꞌimaꞌquë, panitaꞌa ja̱ yëꞌtaꞌa yequëre uteye paꞌiquë? cuasaquë i̱ yeꞌyacohuaꞌire cayahuaꞌire soini Jesús quëꞌrona jëjo saopi, se̱ni asaja̱ꞌcohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Jëjo saosicohuaꞌipi Jesús quëꞌrona ti̱ꞌani cahuë: “¿Cristo i̱ti daija̱ꞌquë api ca nëosiquë paꞌimaꞌquë mëꞌë? Pa̱nitaꞌa ja̱ yëꞌtaꞌa ¿yequëre uteye paꞌiquë? caquë Juan oco doquëpi yëquëre jëjo daopi.” ");
INSERT INTO seyNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Sa ti̱ꞌajëna, Jesupi jai pa̱ire ju̱ꞌicohuaꞌire cuiꞌne ai yoꞌocohuaꞌire huati quëꞌiohuaꞌire eto saoquë, cuiꞌne ñamaꞌcohuaꞌire jujuquë yoꞌopi. ");
INSERT INTO seyNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yoꞌoquëni se̱jëna, Jesupi sehuopi, ja̱ohuaꞌire: “Sani Juanre cajë̱ꞌë: Mësaru ñajë cuiꞌne asaseꞌere quëajë̱ꞌë, ñamaꞌcohuaꞌi paꞌisicohuaꞌi ñañere, cuꞌimaꞌcohuaꞌi paꞌisicohuaꞌipi cuꞌiyere, ja̱ꞌju dahuë hueꞌecohuaꞌipi peocohuaꞌi to̱meñere, asamaꞌcohuaꞌipi asayere, ju̱ꞌisicohuaꞌipi huëiyere, cuiꞌne teaye ai yoꞌocohuaꞌini huaso coca quëayere. ");
INSERT INTO seyNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Coa asani yëꞌëre i̱re papi caquë jëa coeye pa̱quëpi sihuaquë deꞌoye pasipi.” ");
INSERT INTO seyNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juan jëjo daosicohuaꞌipi coꞌisi maca Jesupi pa̱ire ca huëopi, Juan ayere ñeje: “¿I̱quere sani ñareꞌni, cue̱ne yeja saisicohuaꞌi? ¿Tutupi ca̱tëna juꞌaquëna, huahuëyere ñare? Pa̱ni. ");
INSERT INTO seyNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ja̱je paꞌina, ¿i̱quere sani ñareꞌni? ¿Ëja deꞌoni jai doꞌi ca̱ñare juꞌiquëni ñare? Pa̱ni. Ja̱je paꞌina, mësarupi ñacohuaꞌi aꞌë, pa̱i ëjaohuaꞌi huë̱ꞌña paꞌicohuaꞌipi jai doꞌi ca̱ñare juꞌijë paꞌicohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ti̱jupë cayë, ja̱je paꞌito: ¿I̱queini sani ñareꞌni, Maijaꞌquë jëjo daoquë? Ja̱je paꞌijë̱ꞌë. Nuñerepa cayë, Maijaꞌquë quëacaiquë jerepa paꞌi api. ");
INSERT INTO seyNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Toyaseꞌe cato caji: Jëjo saosiꞌi, yëꞌëre quëacaiquëre mëꞌë sai hue̱ꞌñana Mëꞌëre maꞌa ne deꞌhuacaija̱ꞌquëre. ");
INSERT INTO seyNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ja̱je paꞌina, cayë, mësarute. Pa̱i paꞌi hue̱ꞌñana iquë Juan oco doquëje̱ paꞌi ti peopi, Maijaꞌquë quëacaiquë jerepa paꞌi. Ja̱je paꞌiquëtaꞌare ai aꞌriquë macapi Maijaꞌquë paꞌi te̱ꞌte jerepa paꞌi paꞌija̱ꞌquë api.” ");
INSERT INTO seyNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ja̱je caquëna, asani siꞌaohuaꞌi Juanre oco do cua̱ñosicohuaꞌi coꞌa pa̱i cuiꞌne paꞌi doꞌi curi se̱cohuaꞌi Maijaꞌquë deꞌoyerepa yoꞌoseꞌere sihuajë nuñerepa paꞌi api, Maijaꞌquë. ");
INSERT INTO seyNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ja̱je paꞌiquëtaꞌare Juan oco do cua̱ñomaꞌcohuaꞌipi fariseo pa̱ipi cuiꞌne cua̱ñeseꞌe yeꞌyacohuaꞌipi Maijaꞌquë i̱ohuaꞌire caquë yoꞌoyere asacaiye coereña, coꞌaye aꞌë cajë. ");
INSERT INTO seyNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ëjaëpi yequeje̱ capi: “¿I̱quena co̱ni iyeꞌnë pa̱ire ja̱ yoꞌoyeje̱ paꞌiohuaꞌi aꞌë caquë quëaraꞌye? ¿I̱que yoꞌoyeje̱ paꞌiohuaꞌi ña cua̱ñoñeꞌni? ");
INSERT INTO seyNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Deꞌoji, ja̱je paꞌito tsi̱pi jai pa̱i paꞌi hue̱ꞌñana ca̱ꞌa yoꞌoñuꞌu cajë jaꞌrusicohuaꞌipi caje tsi̱ni pi̱ꞌcohuëre jucacaitoje̱ bailaye pa̱huë. Cuiꞌne oiyeje̱ paꞌiohuaꞌitaꞌa jë̱jëñere jë̱jëcaitoje̱ oire paye pa̱huë. Yure paꞌicohuaꞌi cuiꞌneje paꞌiyë. ");
INSERT INTO seyNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Juan oco doquëpi ai a̱imaꞌquëpi cuiꞌne oꞌsa u̱cumaꞌquëpi paꞌina, mësarupi i̱te huati quëꞌi api cayë. ");
INSERT INTO seyNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ja̱ jeteyoꞌje Pa̱i Mamaquë dajiꞌi, a̱o a̱iquëpi cuiꞌne oꞌsa u̱cuquëpi. Ja̱je paꞌina, mësarupi jaiye a̱iquë api cuiꞌne jaiye oꞌsa u̱cuquë api, coꞌaye yoꞌocohuaꞌi cajeipi cuiꞌne paꞌi doꞌire curi se̱cohuaꞌi cajeipi cayë. ");
INSERT INTO seyNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ja̱je paꞌiquëtaꞌare Maijaꞌquë mamajëpi i̱ i̱ñoñere cayahuaꞌi yoꞌoye deꞌoji, asayë.” ");
INSERT INTO seyNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Fariseo aquëpi Jesure soipi, i̱ huëꞌena sani a̱o a̱ijëꞌë caquë. Soina, Jesús sani a̱o a̱i saihuëna jaꞌrupi. ");
INSERT INTO seyNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Jaꞌruni ñuꞌina, i̱ti daripë, teꞌo nomio coꞌaye paꞌisicopi asani i̱ paꞌi hue̱ꞌña dacoꞌë, ai huëo së̱ maꞌña daꞌcare quë̱na huëna daco. ");
INSERT INTO seyNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Dani i̱opi Jesús quë̱no macana doꞌre jaꞌruni oio i̱o oi copi i̱ quë̱o tsoani jeteyoꞌje i̱o nañapi të̱no cue̱nani tsu̱ꞌsuco sihuaco huëo së̱ maꞌñapi i̱ quë̱oje doco. ");
INSERT INTO seyNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ja̱je yoꞌocona, fariseo Jesure soisiquëpi ñani cuasapi: “Iquë Maijaꞌquë coca quëacaiquërepa pani i̱te coꞌa nomiopi papico yoꞌoye asaraꞌpi, coꞌa nomiopi yoꞌoco caquë.” ");
INSERT INTO seyNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Cuasaquëna, Jesupi fariseore capi: “Simón, mëꞌëre yeque maña caye payë.” Caquëna, fariseopi sehuopi: “Cajë̱ꞌë, yeꞌyaquë.” ");
INSERT INTO seyNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesupi capi: “Curiquë prestaquëni caya ë̱mëohuaꞌi curire coꞌyoye pa̱huë. Quinientos denario teꞌipi doꞌi pa̱pi, yequëpi cincuenta denario doꞌi pa̱pi. ");
INSERT INTO seyNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ja̱je doꞌi pacohuaꞌipi sa̱i ti̱ꞌañe pa̱jëna, ñani curiquë prestasiquëpi ja̱ohuaꞌire oi i̱pi sa̱i deꞌhuapi. Ja̱je paꞌito yure quëajë̱ꞌë. ¿Nepi ja̱ohuaꞌi aquë ai jerepa oiyeꞌni, i̱te?” ");
INSERT INTO seyNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Caquëna, Simónpi sehuopi: “I̱ti ai jaiye doꞌi pasiquëpi i̱te sa̱i deꞌhuacaisiquëre ai ojiꞌi, cuasayë.” Ja̱je caquëna, Jesupi sehuopi: “Nuñerepa cayë, mëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ja̱ maca Jesús nomiore ñani capi, Simónre: “¿Ñaquë i̱o yoꞌoye? Mëꞌë huëꞌena yëꞌë caca maca mëꞌëpi oco dacaimaꞌë paëꞌë, yëꞌë nëcañoa tsoa ja̱ꞌñere. Ja̱je paꞌiquëtaꞌare icopi i̱o oisi ocopi tsoacacoꞌë, nëcañoare cuiꞌne nañapi të̱no cue̱nao. ");
INSERT INTO seyNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mëꞌëpi sihuaquë pëpamaꞌë. Ja̱je paꞌiquëtaꞌare i̱o cato caca macapi sihuao deꞌoyerepa pëpao, ja̱ yëꞌtaꞌa yoꞌoco. ");
INSERT INTO seyNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mëꞌëpi yëꞌëre si̱opë huiꞌyape pe̱ꞌnamaꞌë paëꞌë. Ja̱je paꞌiquëtaꞌare i̱o cato yëꞌëre huëo së̱ maꞌñapi nëcañoana doo. ");
INSERT INTO seyNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ja̱je paꞌina, mëꞌëre cayë, i̱o ai oio yoꞌoyepi i̱o jaiye coꞌaye yoꞌoseꞌere sa̱i deꞌhua cua̱ñosico paꞌio, i̱ñoco. Ja̱je paꞌiquëtaꞌare aꞌri mañare sa̱i deꞌhua cua̱ñoquëpi aꞌri maña oiyere i̱ñoji.” ");
INSERT INTO seyNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ja̱je se cani capi, i̱ote: “Mëꞌë coꞌaye yoꞌoco paꞌiseꞌe sa̱i deꞌhuacaëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ja̱je caquëna, soisicohuaꞌi ñuꞌicohuaꞌipi sa̱ꞌñe i̱ohuaꞌija̱ꞌa ca huëohuë: “¿I̱queiꞌni, iquë ja̱je coꞌaye yoꞌoseꞌere sa̱i deꞌhuacaiquë?” ");
INSERT INTO seyNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ja̱je cajëtaꞌare Jesupi capi, i̱ote: “Maijaꞌquëpi huasoja̱ꞌquë api cuasani yoꞌo doꞌire huasosico paꞌiyë, mëꞌë. Se̱ñaco deꞌoye saijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ja̱ jeteyoꞌje Jesús jai daripë̱ana cuiꞌne aꞌri daripë̱ana siꞌa hue̱ꞌña cuꞌi quëaroja̱i, cuiꞌne Maijaꞌquë cua̱ñe te̱ꞌtena cacani deꞌoye paꞌiyere quëapi. I̱te co̱huë, doce i̱ yeꞌyacohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Cuiꞌne nomiohuaꞌipi huati quëꞌiohuaꞌi paꞌisicohuaꞌi cuiꞌne i̱pi ju̱ꞌi dahuëje̱ jujucaisicohuaꞌipi i̱te co̱ni cuahuë. Ja̱ohuaꞌi ja̱ꞌre co̱ni María Magdalena hueꞌecoje̱ sacoꞌë, i̱ti siete huatiohuaꞌire eto cua̱ñosicopi. ");
INSERT INTO seyNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Cuiꞌne Herodes yëyere i̱seꞌe cuasaquë huëꞌe deꞌoye necaiquë Chuza i̱ nëjo Juana cuiꞌne Susana, cuiꞌne jai pa̱i yequë nomiohuaꞌije̱ i̱ohuaꞌi coꞌamañapi co̱caëꞌë, i̱te. ");
INSERT INTO seyNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Pa̱i daripë̱a ñape etani daëꞌë, Jesure ñañuꞌu cajë. Ja̱je jai pa̱i datena, ñani quëapi, i̱ohuaꞌi ñañe ayena. Caquë i̱ñoquë ñeje capi: ");
INSERT INTO seyNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ta̱quëpi ta̱siꞌi caquë tsiona sani i̱ti ca̱re je̱aquëna, maꞌana to̱mepi. To̱meina, cuꞌicohuaꞌipi tsacu huesohuë, cuiꞌne yequë ca̱re pi̱ꞌapi o̱cue huesohuë. ");
INSERT INTO seyNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Yequë ca̱pi to̱mepi, quë̱na yejana. To̱meni ai deꞌoquëtaꞌa ocopi peoquëna, cue̱ne ju̱jiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Yequë ca̱pi to̱mepi miu pi̱si quëꞌrona. To̱meni ai deꞌoquëna, pi̱sije̱ teꞌe ai deꞌoni hue̱ hue̱api. ");
INSERT INTO seyNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Cuiꞌne yequë ca̱pi to̱mepi deꞌo yejana. To̱meni ai deꞌoni cien ca̱ jaiye i̱ti ñëa ñape quë̱jiꞌi.” Ja̱je iyere Jesús ca tëjiquë ai tutu capi: “Mësarupi ca̱joro quëꞌiohuaꞌi pani asajë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ja̱ maca i̱ yeꞌyacohuaꞌipi se̱iꞌë: ¿I̱quere ja̱ mëꞌë ja̱je quëaëꞌni, i̱ohuaꞌi ñañena co̱ni? ");
INSERT INTO seyNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Cajëna, i̱pi ja̱ohuaꞌire sehuopi: “Maijaꞌquë i̱ te̱ꞌte ayere pa̱ije asa ti̱ꞌa maꞌñere i̱ñoquëna, deꞌhue asayë, mësaru. Ja̱je paꞌiquëtaꞌare yecohuaꞌini cayë iye yoꞌoyeje̱ paꞌye aꞌë caquë i̱ohuaꞌi ñañe ayepi i̱ti ñajëtaꞌa ña maꞌñeje paꞌiohuaꞌi paꞌiyere caquë. Cuiꞌne i̱tire asajë coa noni asa huesojë ti asa ti̱ꞌañe pa̱jajë caquë. ");
INSERT INTO seyNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Iye aꞌë. Iye quëaseꞌe caye: I̱ti ca̱ cato Maijaꞌquë cocaje̱ paꞌye. ");
INSERT INTO seyNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Maꞌa cato quëaji, Maijaꞌquë coca asacohuaꞌini. Ja̱je asacohuaꞌini huatipi dani i̱ohuaꞌi joñoana deꞌhuaseꞌere peo hue̱ꞌña jioni asamaꞌcohuaꞌire neni ne huesoyere quëaji. ");
INSERT INTO seyNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Quë̱na yejana i̱ti ca̱ to̱meseꞌe cato Maijaꞌquë cocare duꞌru macarepa sihuajë asasicohuaꞌipi paꞌijëna, jeteyoꞌje ai yoꞌoyepi ti̱ꞌasi maca yoꞌo jujani je̱ocohuaꞌini quëaji. ");
INSERT INTO seyNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Miu pi̱si quëꞌrona i̱ti ca̱ to̱meseꞌe cato quëaji. Asajëtaꞌa ja̱ yëꞌtaꞌa i̱ohuaꞌi ai cuasayere yoꞌojë paꞌicohuaꞌini ja̱je yoꞌojë coꞌamaña jaiye payena cuasajë cuiꞌne yeja sihuayere yëjë coꞌa ju̱ꞌijëna, pi̱si meapi hue̱ hue̱añeje paꞌye yoꞌoquëna, i̱ti ca̱ quë̱imaꞌpë paꞌiyere. ");
INSERT INTO seyNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Cuiꞌne yequë ca̱ deꞌo yejana to̱meseꞌe cato quëaji, deꞌo joyopi ja̱je yoꞌoñuꞌu cajë asacohuaꞌini cuiꞌne yëhuoseꞌere asani cuiꞌne yoꞌocohuaꞌipi cuiꞌne yoꞌo jujamaꞌcohuaꞌipi nuñerepa i̱tire paꞌijë i̱ti ca̱ quë̱icohuaꞌije̱ paꞌicohuaꞌi paꞌiyere. ");
INSERT INTO seyNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Toa tsë̱omaꞌcohuaꞌi aꞌë, tsë̱oni jeteyoꞌje yequë coꞌamañapi si̱ojaꞌconi panitaꞌa ca̱i saihuë huëꞌehuëna nëcoja̱ꞌconi. Ja̱je yoꞌoye pa̱jë coa ai jerepa ë̱mëjeꞌna nëcojë yecohuaꞌi cacajëna, miacaija̱ꞌcore. ");
INSERT INTO seyNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Yahueseꞌepi ti yahue huesoseꞌe pani huesoye peoji. Cuiꞌne pa̱i asa maꞌñepi ti asamaꞌpëna, paꞌiye peoji. Siꞌaye asa ja̱ꞌñe aꞌë, ti̱ñarepa. ");
INSERT INTO seyNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ja̱je paꞌito deꞌoye asajë̱ꞌë. Ja̱je paꞌina, paquëna ai jerepa se i̱si co̱ñe paꞌiji. Ja̱je paꞌiquëtaꞌa peoquëni ai jerepa se si̱o co̱ñe paꞌiji, i̱ payë, cuasaseꞌe mañaque siꞌaye.” ");
INSERT INTO seyNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ja̱ maca Jesús pëca jaꞌco cuiꞌne i̱ yoꞌje tsi̱ co̱ni ti̱tahuë, i̱ paꞌi hue̱ꞌñana. Ti̱tasicohuaꞌitaꞌa jai pa̱i paꞌi doꞌire i̱ paꞌi hue̱ꞌña ti̱ꞌañe pa̱huë. ");
INSERT INTO seyNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ja̱je paꞌina, yecohuaꞌipi Jesure quëahuë: “Më jaꞌco cuiꞌne mëꞌë yoꞌje tsi̱ co̱ni hueꞌsere paꞌiyë, mëꞌëni ñañuꞌu cajë dani.” ");
INSERT INTO seyNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Cajëna, i̱pi capi: “Maijaꞌquë coca asani cuiꞌne i̱ti cayeje̱ yoꞌocohuaꞌipi yëꞌë jaꞌco cuiꞌne yëꞌë yoꞌje tsi̱ paꞌiyë.” ");
INSERT INTO seyNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Teꞌe muꞌse Jesús jai yohuëna i̱ yeꞌyacohuaꞌi ja̱ꞌre co̱ni tu̱mëni capi: “Jaira je te̱ꞌtena je̱ñuꞌu.” ");
INSERT INTO seyNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Caëna, ja̱ je̱ꞌejëna, Jesús ca̱jiꞌi. Ca̱ina, ai tutu dapi. Jairare paꞌijëna, tutu dani coꞌpoyepi yohuëna oco ti̱më huëopi, ea duꞌiye jaꞌi macarepa. ");
INSERT INTO seyNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ña quëquëni ca̱iquëre sëtoni cahuë: “Yeꞌyaquë, Yeꞌyaquë, ea duꞌiyë, mai.” Cajëna, Jesús huëni nëcani tuture cuiꞌne coꞌpoyere yoꞌomaꞌo capi. Ca macarepa tsi̱ña deꞌhuaje̱ paꞌiorepa deꞌopi, ti coꞌpomaꞌco. ");
INSERT INTO seyNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Coꞌpomaꞌco deꞌona, i̱ yeꞌyacohuaꞌire capi: “¿Je jaꞌye tsoe Maijaꞌquëpi necaija̱ꞌquë api cuasaye je̱ore?” Ja̱je caquëna, ja̱ohuaꞌi cato quëquë huesësicohuaꞌipi ai ñahuë. Ñajë i̱ohuaꞌija̱ꞌa sa̱ꞌñe cahuë: “¿I̱queire pani, iquë, tutu cuiꞌne oco asani sehuocaiquërepa?” ");
INSERT INTO seyNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ai yoꞌosi jeteyoꞌjere papi Gadara yejana ti̱ꞌahuë, Galilea je̱ꞌñerepa paꞌicona. ");
INSERT INTO seyNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ti̱ꞌajëna, Jesús tu̱maquëna, teꞌi ë̱më i̱ti daripë aquëpi tsio dajiꞌi. Ai tsoe iquë huatire hueꞌequëpi, juꞌi ca̱ñaje juꞌimaꞌquëpi cuiꞌne huëꞌeje̱ paꞌimaꞌquë pajiꞌi. Ja̱je paꞌipi coa pa̱i ju̱ꞌisicohuaꞌire ta̱ hue̱ꞌñare pare iquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ja̱je paꞌipi Jesure ñani ta̱ni doꞌre jaꞌruni ai cuipi: “¿Me yoꞌoquë Jesús yëꞌëre jo̱sa yoꞌosiꞌquë daiquëꞌni, Maijaꞌquërepa mamaquëpi? Se̱ñë, mëꞌëre. Yëꞌëre jo̱sa yoꞌomaꞌë paꞌijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Iye cato Jesupi huatire etani saijë̱ꞌë, cua̱ñequëna, ja̱ doꞌire ja̱je capi. Iquë cato huatipi i̱te joꞌya nesiquëre papi ai tsoe. Ja̱je paꞌina, pa̱ipi i̱te quë̱na meapi sëahuë, saimaꞌë paꞌija̱ꞌquë cajë. Ja̱je yoꞌojëtaꞌare huatipi tutu i̱siquëna, ne tëte saoquë saiquëpi pa̱i peo yejana huatipi saquëna. ");
INSERT INTO seyNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesupi capi, i̱te: “¿I̱que mami aꞌni, mëꞌë?” Se̱ina, i̱pi sehuopi: “Yëꞌë Legión hueꞌequë aꞌë.” Ja̱je cani capi, huatiohuaꞌipi i̱na jai pa̱i cacani paꞌi doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ja̱je paꞌijë huatiohuaꞌipi Jesure se̱iꞌë. Jëjo saomaꞌë paꞌijë̱ꞌë, nejo hue̱ꞌñare pana cajë. ");
INSERT INTO seyNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Coa se̱se quëꞌrona jëjo saojë̱ꞌë, yëquëre cahuë, ai cu̱tihuëre jai pa̱i se̱se nëijë a̱icohuaꞌina. Cajëna, Jesupi deꞌoji, sehuouna. ");
INSERT INTO seyNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Pa̱ite paꞌisicohuaꞌipi etani se̱sena cacahuë. Cacajëna, se̱se jai huaꞌque të̱ꞌtëpapi to̱mejë jairana dutu ju̱juhuë. ");
INSERT INTO seyNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ja̱ maca i̱ti se̱sere ñacaicohuaꞌipi ña quëquëjë huëꞌhuëni pa̱i darina cuiꞌne yequë hue̱ꞌñana i̱ti yoꞌoseꞌere quëahuë. ");
INSERT INTO seyNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Quëarena, pa̱ipi ñañuꞌu cajë saëꞌë. Saijë Jesús paꞌi hue̱ꞌñana ti̱ꞌajë ñajëna, huati quëꞌi paꞌisiquëpi i̱ quë̱no macare juꞌi ca̱ su̱ñasiquëpi dahuëre paꞌipi yoꞌomaꞌquëpi ñujiꞌi. Ñuꞌina, ñani ai caꞌrahuë. ");
INSERT INTO seyNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ja̱ maca i̱ti ñasicohuaꞌipi daripëpi daisicohuaꞌire quëahuë, huati quëꞌi paꞌisiquëni Jesupi jujuseꞌere, nuiñere cuasaquëre. ");
INSERT INTO seyNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ja̱re asani Gadara yeja pa̱ipi siꞌahuaꞌi i̱ni ai caꞌra doꞌire se̱iꞌë. Saijë̱ꞌë. I̱ño paꞌimaꞌë paꞌijë̱ꞌë cajë. Ja̱je cajëna, asani Jesupi jai yohuëna aya mëni sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Saina, i̱ti huatire eto sao cua̱ñosiquëpi sajë̱ꞌë yëꞌëreje̱ caquë se̱jiꞌi. Se̱ina, Jesupi i̱te pëajë̱ꞌë, cani capi: ");
INSERT INTO seyNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Coꞌijë̱ꞌë, mëꞌë huëꞌena. Coꞌini siꞌaye mëꞌëre Maijaꞌquë ne deꞌhuaseꞌere quëajë̱ꞌë.” Ja̱je caëna, sani siꞌa daripë cuꞌi quëapi, Jesús i̱te ne deꞌhuaseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ja̱je Jesús jaira je te̱ꞌtepi coꞌina, siꞌahuaꞌi i̱te utejë paꞌisicohuaꞌipi sihuajë pëpahuë. ");
INSERT INTO seyNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Pëpa maca Jairo hueꞌequëpi pa̱i tsiꞌsi huëꞌere ñacaicohuaꞌi ëjaëpi ti̱tapi. Ti̱tani Jesús quë̱o yëꞌquë maca doꞌre jaꞌruni yëꞌë huëꞌena daijë̱ꞌë, caquë se̱jiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Teꞌo macare mamacore paquëni, doce o̱metëca pacopi, ju̱ni huesë tëjicona. Se̱quëna, jujucaija̱ꞌquë Jesupi ja̱rona sajiꞌi. Saina, jai pa̱i co̱ni quiꞌiyerepa saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Saquëna, saru dahuë ju̱ꞌicopi ai yoꞌoco pacoꞌë, tsieje̱ tëcamaꞌona doce o̱metëca. Ja̱je paꞌiopi jujucohuaꞌini juju cua̱ñosiꞌi caco siꞌaye i̱o curi sa̱io sao. Ja̱je yoꞌotoje̱ jujuye peopi. ");
INSERT INTO seyNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ja̱je ai yoꞌocopi Jesure tsioja̱ni tuni i̱ juꞌi ca̱na patocona, ja̱re i̱ti macapi tsie tëcapi. ");
INSERT INTO seyNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ja̱je patocona, Jesupi se̱jiꞌi: “¿Nepi yëꞌëre patoreꞌni?” Caquëna, siꞌahuaꞌi cahuë: “Pa̱huë, patoye.” Cajëna, Pedro cuiꞌne i̱ cajeohuaꞌi co̱ni cahuë: “Yeꞌyaquë, jai pa̱i siꞌa te̱ꞌñapi jëꞌjejëna, ñaquëtaꞌa se̱quëꞌni, ¿nepi yëꞌëre patoreꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Cajëna, Jesupi capi: “Asayë, yëꞌë tutupi yëꞌëre patosicore jujuseꞌere.” ");
INSERT INTO seyNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ja̱ maca tsoe coꞌyasico paꞌio yahue yoꞌoseꞌe peoquëna, tsoe asapi caco caꞌraco tsaꞌsico dani doꞌre jaꞌruni Jesús quë̱o yëꞌquë macapi quëao, siꞌahuaꞌi ñajëna, i̱o cuasani yoꞌoseꞌere cuiꞌne i̱o pato macapi esa coꞌyaseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Quëa maca Jesupi capi: “Huau, mëꞌëpi jujuja̱ꞌquë api cuasani yoꞌosi doꞌipi jujusico paꞌiyë, mëꞌë. Se̱ñaco deꞌoye saijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ja̱ yëꞌtaꞌa Jesús cocare caquëna, Jairo huëꞌepi dani ti̱taquë Jairore capi: “Mëꞌë mamaco tsoe ju̱coꞌë. Yeꞌyaquëre ai jerepa jo̱sa yoꞌomaꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Caquëna, Jesupi asani capi, Jairore: “Quëquëmaꞌë paꞌijë̱ꞌë. Yëꞌëpi jujuja̱ꞌquë api caquë utejë̱ꞌë. Ja̱je cuasaquë utequëna, mëꞌë mamaco coꞌyasico pasio.” ");
INSERT INTO seyNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Huëꞌena ti̱ꞌasi maca teꞌireje̱ co̱ñe pa̱pi, i̱ caca hue̱ꞌña. Coa Pedro, Jacobo, Juan cuiꞌne tsihuaꞌo pëca jaꞌquë cuiꞌne pëca jaꞌco ja̱ohuaꞌiseꞌe cacahuë, i̱ ja̱ꞌre co̱ni. ");
INSERT INTO seyNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Siꞌahuaꞌi oëꞌë, coꞌa ju̱ëꞌë, i̱oni cuasajë. Ja̱je oijëna, Jesupi capi, ja̱ohuaꞌire: “Oimaꞌpë paꞌijë̱ꞌë. Tsihuaꞌo ju̱ꞌimaꞌo pacoꞌë. Coa ca̱ico.” ");
INSERT INTO seyNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Caquëna, tsoe ju̱ꞌisiconi caji cajë i̱ cayere cueꞌcuejë sohuë. ");
INSERT INTO seyNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ja̱ maca Jesupi ju̱ꞌisico jë̱tëna tse̱ani capi: “Tsihuaꞌo huëijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ja̱je caquëna, i̱ti macapi paꞌi huëo cuiꞌnaopi, nëcaco. Nëcacona, ja̱ maca Jesús a̱ore a̱ojëꞌë cua̱ñepi. ");
INSERT INTO seyNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Pëca jaꞌquëohuaꞌipi ai cuasahuë, i̱ti yoꞌoseꞌere. Ja̱ maca Jesupi cua̱ñepi, iye yoꞌoseꞌe yecohuaꞌire ti quëamaꞌpë paꞌijë̱ꞌë, caquë. ");
INSERT INTO seyNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesupi i̱ doce yeꞌyacohuaꞌire tsiꞌsoni i̱sipi, i̱ tuture cua̱ñecohuaꞌi paꞌija̱jë coa siꞌaye ti̱ñe paꞌi coꞌa joñoare eto saojë cuiꞌne ju̱ꞌicohuaꞌire jujujë yoꞌo ja̱ꞌñere. ");
INSERT INTO seyNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Maijaꞌquë cua̱ñe te̱ꞌtena cacani paꞌiyere quëaja̱ꞌcohuaꞌini cuiꞌne siꞌa ju̱ꞌiñere jujucaija̱ꞌcohuaꞌini jëjo saopi. ");
INSERT INTO seyNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ja̱je jëjo saoquë capi: “Tupë, turupë a̱o, curiquë samaꞌpë paꞌijë̱ꞌë. Maꞌa sajë teꞌe juꞌi ca̱ sajë̱ꞌë, cayaye samaꞌpë, peojë saijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Teꞌe daripë yoꞌoye paꞌina, teꞌe huëꞌena pëajë̱ꞌë, mësarute sihuacohuaꞌi paꞌito. ");
INSERT INTO seyNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Yeque mësaruni coecohuaꞌi paꞌito etani saijë yaꞌo siꞌsi paꞌiyere ti̱ꞌto to̱jëꞌë. Ja̱je yoꞌojë ja̱pi i̱ñoñe paꞌiji, i̱ohuaꞌire sa̱ñope Maijaꞌquë yoꞌo ja̱ꞌñere.” ");
INSERT INTO seyNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ja̱je caëna, etani sateña, siꞌa hue̱ꞌña pa̱i paꞌi hue̱ꞌñana, huaso cocare quëajë cuiꞌne ju̱ꞌicohuaꞌini jujujë. ");
INSERT INTO seyNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Ja̱je Jesús yoꞌoquëna, yecohuaꞌipi Juan huëisiquëpi huëni yoꞌoji, cajëna, cuiꞌne yecohuaꞌipi Maijaꞌquë jëjo daoquë Elíaspi ñaipi cahuë. Cajëna, yecohuaꞌipi ai tsoe Maijaꞌquë jëjo daoquë paꞌisiquëpi huëni yoꞌoji, cahuë. Ja̱je cajëna, Galilea ëjaë Herodespi asaquë cuiꞌna jaꞌyeseꞌe cuasa huesëpi. ");
INSERT INTO seyNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ja̱je paꞌiquëtaꞌa Herodespi capi: “Yëꞌëpi Juan si̱opëre yëto tëajë̱ꞌë caquë cua̱ñehuë. Ja̱je paꞌito ¿i̱queipi jaiye coꞌamaña yoꞌoquërepa paꞌina, cajëna, asayeꞌni?” Ja̱je paꞌina, Jerodespi i̱te ñasiꞌi caquë yoꞌopi. ");
INSERT INTO seyNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","I̱ jëjo saosicohuaꞌipi coꞌini Jesure quëahuë, i̱ohuaꞌi yoꞌoroja̱iseꞌere. Quëa tëjijëna, ja̱ jeteyoꞌje sai sapi, ja̱ohuaꞌire, pa̱i peo hue̱ꞌñana, Betsaida daripë quëꞌrona. ");
INSERT INTO seyNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ja̱je saicohuaꞌitaꞌare pa̱ipi asani tuëꞌë. Tuijëna, Jesús sihuaquë pëpani Maijaꞌquë te̱ꞌte ayere quëani cuiꞌne ju̱ꞌicohuaꞌire jujupi. ");
INSERT INTO seyNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Neato deꞌo huëoquëna, i̱ doce yeꞌyacohuaꞌipi tsio dani Jesure cahuë: “Jaꞌye huë̱ꞌña paꞌi hue̱ꞌña i̱ño ti peoji. Pa̱ire quëajë̱ꞌë, saija̱jë, sani huajëja̱jë, cuiꞌne pa̱i daripëna sani a̱o hueroni a̱ijajë.” ");
INSERT INTO seyNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ja̱je cajëna, Jesupi capi: “Mësarupi a̱ojëꞌë, ja̱ohuaꞌire.” Caquëna, i̱ohuaꞌipi sehuohuë: “Coa cinco pan pë̱a cuiꞌne caya tsiaya huaꞌire pare payë. Ja̱je paꞌina, siꞌahuaꞌire a̱oñe cani sani hueroyeseꞌe paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Cinco mil ë̱mëohuaꞌi paëꞌë. Ja̱je paꞌijëtaꞌare Jesupi i̱ yeꞌyacohuaꞌire capi: “Cincuenta pa̱iseꞌere teꞌe macana ñoꞌe saojë̱ꞌë. Ja̱re ja̱ so̱cohuaꞌiseꞌere siꞌahuaꞌire huahuejë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","I̱ caseꞌeje̱ yoꞌojëna, siꞌahuaꞌi jaꞌru sahuë. ");
INSERT INTO seyNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ja̱ maca Jesús cinco pan cuiꞌne caya tsiaya huaꞌire i̱mani maꞌtëmona ñaquë deꞌoji iye mëꞌë i̱siseꞌe payë caquë Maijaꞌquëre pëpapi. Pëpani jëꞌyeni i̱ yeꞌyacohuaꞌina i̱sipi, pa̱ire a̱ojëꞌë caquë. Ja̱ maca ja̱ohuaꞌipi pa̱ire a̱ohuë. ");
INSERT INTO seyNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Siꞌahuaꞌi i̱ohuaꞌi yëseꞌere ti̱ꞌasicohuaꞌi paëꞌë. A̲ni tëjisi jeteyoꞌje i̱ti nëaseꞌere doce doꞌrohuë̱a aya ti̱mëhuë. ");
INSERT INTO seyNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Yequë muꞌse Jesús teꞌipi Maijaꞌquëre se̱jiꞌi, pa̱i peo hue̱ꞌñana. Se̱ina, i̱ yeꞌyacohuaꞌi datena, se̱jiꞌi, ja̱ohuaꞌire: “¿I̱queipi cayeꞌni, pa̱i yëꞌëre?” ");
INSERT INTO seyNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Caquëna, i̱ohuaꞌipi sehuohuë: “Yecohuaꞌipi cayë, mëꞌëre Juan oco doquë api. Yecohuaꞌipi Elíaspi cayë. Yecohuaꞌipi mëꞌëre cayë, ai tsoe Maijaꞌquë jëjo daoquë paꞌisiquëpi huëjiꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ja̱je cajëna, se̱jiꞌi, i̱ohuaꞌini: “¿Cuiꞌne mësarutaꞌa yëꞌëre i̱queipi cayeꞌni?” Caquëna, Pedropi capi: “Mëꞌë cato Cristo, maire huasoquë, Maijaꞌquë tse̱quëre paꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ja̱je asajëna, Jesupi ja̱ohuaꞌire ai cua̱ñepi: Quëamaꞌpë paꞌijë̱ꞌë, yecohuaꞌire caquë, ");
INSERT INTO seyNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","cani capi, ja̱ohuaꞌire: “Pa̱i Mamaquë ai yoꞌoja̱ꞌquë api, aiohuaꞌi, Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌije̱, cua̱ñeseꞌe yeꞌyacohuaꞌije̱ yëꞌëre coejë huani je̱ojaꞌcohuaꞌi aꞌë. Ja̱je yoꞌosiquëtaꞌa toaso̱ muꞌseña paꞌi maca huëija̱ꞌquë api.” ");
INSERT INTO seyNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ja̱ jeteyoꞌje siꞌahuaꞌire capi: “Pa̱ipi yëꞌëre tuiye yëni je̱oñe paꞌiji, i̱ohuaꞌi yëꞌë tse̱ aꞌë cuasaseꞌere, yëꞌëseꞌe cuasaseꞌere. Je̱oni yëꞌëre tuiye paꞌiji, siꞌa muꞌseña ai yoꞌoye paꞌitoje̱. ");
INSERT INTO seyNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ja̱je paꞌina, i̱ paꞌiyere deꞌoye pasiꞌi cuasaquë pani, coa ne huesoye paꞌiji. Ja̱je paꞌina, yëꞌë doꞌire i̱ paꞌiye ne huesosiquëpi ja̱ëpi huasosiquë pasipi. ");
INSERT INTO seyNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Teꞌipi yoꞌoni siꞌaye iye yeja coꞌamañare hueroni paquëpi ja̱ yëꞌtaꞌa i̱ joyo i̱seꞌe ne huesëquëna, paꞌito deꞌoquë? ");
INSERT INTO seyNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ja̱je paꞌina, yëꞌë mamire cuiꞌne yëꞌë cocare asaquëtaꞌa pa̱ini caꞌraquë yëꞌë yoꞌoye ayere quëamaꞌë paꞌisiquëre cuiꞌne i̱teje̱ yëꞌë Pa̱i Mamaquëpi ëjaë deꞌoni, jaꞌquë paꞌiyepi cuiꞌne hui̱ñaohuaꞌi co̱ni dai maca caꞌraja̱ꞌquë aꞌë, jaꞌquëna quëayere. ");
INSERT INTO seyNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ja̱je nuñerepa cayë. Iye maca paꞌicohuaꞌipi Maijaꞌquë te̱ꞌte ayere ñamaꞌpë pa̱jaꞌcohuaꞌi aꞌë. Maijaꞌquë te̱ꞌte ayepi daina, ñajëna, jeteyoꞌje ju̱ꞌiñe paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Iye caseꞌe paꞌi maca ocho muꞌse jeteyoꞌje Jesupi sajiꞌi, ai cu̱tihuëna Maijaꞌquëre se̱siꞌi caquë. Saina, co̱ni saëꞌë, Pedro, Jacobo cuiꞌne Juan. ");
INSERT INTO seyNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ja̱ maca sani Jesupi Maijaꞌquëre ja̱ se̱i ti̱ñe paꞌi tsiarepa po̱nëpi, cuiꞌne i̱ juꞌi ca̱je ai miacore papi ña ti̱ꞌañe peocorepa po̱nëpi. ");
INSERT INTO seyNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Po̱në maca Jesuje̱ paꞌiohuaꞌipi ñaini caya huaꞌi soꞌoja̱ꞌa miañerepa nëcajë Jesús ja̱ꞌre cocare cahuë. Ja̱ohuaꞌi cato Moisés cuiꞌne Elías paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Jesús Jerusalénna sani ai yoꞌoquë ju̱ꞌi ja̱ꞌñere cahuë. ");
INSERT INTO seyNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ja̱ maca ai huëo ca̱ꞌañe Pedrore cuiꞌne i̱ cajeohuaꞌire nëiseꞌepi peo hue̱ꞌñarepa to̱meina, sëtasicohuaꞌipi ñahuë, Jesús i̱repa paꞌiyere, cuiꞌne cayahuaꞌi i̱ ja̱ꞌre nëcajëna. ");
INSERT INTO seyNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ja̱ maca Jesús quë̱no maca paꞌisicohuaꞌi je̱o saijëna, Pedropi capi: “Yeꞌyaquë, i̱ño pëato deꞌoji. Toaso̱ huë̱ꞌña neꞌñe paꞌio; mëꞌë huëꞌe, Moisés huëꞌe, cuiꞌne Elías huëꞌe.” Ja̱je caquëtaꞌa Pedro coa huesë capi, cuasamaꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ja̱je ja̱ yëꞌtaꞌa caquëna, siriopi nëca meni si̱o huesopi. Si̱o huesoquëna, ai quëquëhuë, sirio sa̱ꞌnahuëre paꞌijë. ");
INSERT INTO seyNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ja̱je paꞌijëna, siriopi yëꞌoseꞌe caye asahuë: “Iquë yëꞌë mamaquë yëꞌë oiquëre papi i̱ cayere asajë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ja̱je casi jeteyoꞌje ñajëna, teꞌi Jesuseꞌe pajiꞌi. Paꞌina, ñani ja̱ohuaꞌi ti camaꞌcohuaꞌi joꞌcua paëꞌë. Cuiꞌne yecohuaꞌireje̱ i̱ohuaꞌi ñaseꞌe ti quëamaꞌpë paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Se ñatasi muꞌse ai cu̱tihuëpi cajejëna, jai pa̱i Jesure sa̱ñope ti̱ꞌahuë. ");
INSERT INTO seyNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ja̱ maca pa̱i jopo aquëpi teꞌi tutu capi: “Yeꞌyaquë, ñacaijë̱ꞌë, care payë yëꞌë mamaquë teꞌi macapi. ");
INSERT INTO seyNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Huatire hueꞌequëna, ja̱ëpi jo̱sa yoꞌoquëna, cuiꞌne cuiquë yoꞌoji, cuiꞌne hueꞌhue nequëna, yëꞌopoja̱ꞌa siri etoquë yoꞌoji, coꞌaye yoꞌoquë ti je̱oñe coeji, i̱te. ");
INSERT INTO seyNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Tsoe mëꞌë yeꞌyacohuaꞌire se̱iꞌë, huatire eto saojë̱ꞌë caquë. Ja̱je caëna, coa yoꞌo jujahuë.” ");
INSERT INTO seyNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Caquëna, Jesupi asani i̱ yeꞌyacohuaꞌire capi: “Maijaꞌquë necaiquë api cuasamaꞌcohuaꞌipi ti̱ñere cuasacohuaꞌi. ¿Je yëhuarepa tsoe mësaru ja̱ꞌre co̱ni paꞌi yoꞌoquëna, ñani Maijaꞌquëpi nequë api cuasaja̱ꞌcohuaꞌi aꞌni, mësaru? Ja̱je cani dajë̱ꞌë, mëꞌë mamaquëre i̱ñona.” ");
INSERT INTO seyNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ja̱je caëna, tsihuaꞌëpi i̱ quëꞌrona jaꞌye tsioja̱ina, huatipi yeque hueꞌhue ne co̱quëna, ta̱jiꞌi, yejana. Ja̱je yoꞌoquëna, Jesupi huatire yoꞌomaꞌë cani eto saoni tsihuaꞌëre jujuni pëca jaꞌquëna i̱sipi. ");
INSERT INTO seyNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ja̱ maca siꞌa pa̱i ai cuasahuë, Maijaꞌquë jaiye yoꞌoyere ñani. Cuiꞌne siꞌahuaꞌi Jesús yoꞌoseꞌere ñani ai cuasajëna, Jesupi i̱ yeꞌyacohuaꞌire capi: ");
INSERT INTO seyNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Deꞌoye asajë̱ꞌë, iyere. Hua̱nëyemaꞌpë paꞌijë̱ꞌë. Yëꞌëre Pa̱i Mamaquëre pa̱i jë̱ñana i̱siye paꞌiji. Ja̱je paꞌina, i̱ohuaꞌi yëyeje̱ yoꞌoja̱ꞌcohuaꞌi aꞌë, yëꞌëre.” ");
INSERT INTO seyNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ja̱je caquëna, i̱ yeꞌyacohuaꞌi ti asa ti̱ꞌañe pa̱huë, i̱ caye. Ja̱re ja̱je asaye paja̱jë i̱pi cuasaye sëte. Ja̱je paꞌina, i̱ohuaꞌi caꞌracohuaꞌipi se̱ni asaye pa̱huë, i̱ caseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ja̱ maca i̱ yeꞌyacohuaꞌi sa̱ꞌñe cahuë, i̱ohuaꞌija̱ꞌa nepi airepa paꞌiohuaꞌi paꞌiohuaꞌi aꞌni, cajë. ");
INSERT INTO seyNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ja̱je cuasajëna, Jesupi i̱ohuaꞌi cuasaye asani ja̱ maca tsihuaꞌëre i̱ quëꞌrona dani nëcopi. ");
INSERT INTO seyNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Dani ja̱ohuaꞌire capi: “Iquë tsihuaꞌëre yëꞌë mamipi cuasajë ñacaini yëꞌëni ñacaiyë. Cuiꞌne yëꞌëre ñacaicohuaꞌi pani yëꞌëre jëjo daosiquëreje̱ cuiꞌne ñacaiyë. Ja̱je paꞌina, i̱ti mësaru aquëpi yecohuaꞌire ai jerepa ñacaiquë pani ai jerepa paꞌi paꞌija̱ꞌquë api.” ");
INSERT INTO seyNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Caquëna, Juan capi, i̱te: “Yeꞌyaquë, yëquë teꞌi ë̱më mëꞌë mamipi caquë huatire eto saoquëre yoꞌomaꞌë paꞌijë̱ꞌë cajë ë̱sehuë, yëquë ja̱ꞌre co̱ni cuꞌimaꞌ doꞌire.” ");
INSERT INTO seyNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Caquëna, Jesupi capi: “¿Me neñuꞌju ë̱sereꞌni? Maire sa̱ñope camaꞌquë pani mai yoꞌoye yoꞌo co̱cohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jesús maꞌtëmo mëiñe ti̱ꞌañe jaꞌi maca paꞌina, Jerusalénna sai huëoni sajiꞌi, i̱ cuasa nëoseꞌere yoꞌosiꞌi caquë. ");
INSERT INTO seyNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Saija̱ꞌquëpi jëjo saopi, i̱ duꞌru sani i̱ pëaja̱to coꞌeja̱ꞌcohuaꞌire, Samaria pa̱i quëꞌrona. ");
INSERT INTO seyNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ja̱je paꞌiquëtaꞌare Jerusalénna saiye nëina, Samaria pa̱i coehuë, pëa hue̱ꞌña i̱siye. ");
INSERT INTO seyNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ja̱ maca ja̱je ë̱sejëna, asani i̱ yeꞌyacohuaꞌi Juan cuiꞌne Jacobo cahuë: “Ëjaë, yëquë mëꞌë ja̱ohuaꞌire toapi cua̱ñerena, maꞌtëmopi to̱meni peo hue̱ꞌñarepa ëo huesoye. Tsoe Maijaꞌquë jëjo daoquë Elías yoꞌoquë paꞌiseꞌeje̱ yoꞌoñuꞌu.” ");
INSERT INTO seyNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ja̱je cajëna, Jesús ñani ja̱ohuaꞌi caseꞌere coequë sa̱ñope capi: “¿I̱que joyore hueꞌeyeꞌni, mësaru? ");
INSERT INTO seyNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Yëꞌë Pa̱i Mamaquë cato daimaꞌë pajiꞌi, pa̱i joñoare nejosiꞌi caquë. Coa ai jerepa pa̱ini huasosiꞌi caquë daëꞌë.” Ja̱je cani je̱oni yequë pa̱i paꞌi hue̱ꞌñana saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Maꞌajaꞌa ja̱ohuaꞌi saijëna, teꞌi ë̱më Jesure capi: “Ëjaë, mëꞌë ja̱ꞌre co̱ni saiye yëyë. Coa siꞌa hue̱ꞌña mëꞌë saitoje̱.” ");
INSERT INTO seyNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesupi sehuopi: “Airo joꞌya mañaje co̱ña pacohuaꞌi aꞌë cuiꞌne pi̱ꞌa mañaje tsiaro pacohuaꞌi aꞌë. Pa̱i Mamaquë cato ti peoquë api, i̱ si̱opë tëo paquë u̱i mañaque.” ");
INSERT INTO seyNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesupi yequëre capi: “Yëꞌëre tuijë̱ꞌë.” Ja̱je caquëna, i̱pi capi: “Ëjaë, utejë̱ꞌë. Yëꞌëtaꞌa duꞌru jaꞌquëre ta̱jasiꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesupi sehuopi: “Yëꞌëre cuasamaꞌcohuaꞌi ju̱ꞌisicohuaꞌije̱ paꞌiohuaꞌi paꞌiyë. Ja̱ohuaꞌipi cuiꞌneje ju̱ꞌisicohuaꞌini ta̱jajë. Mëꞌë cato daijë̱ꞌë, Maijaꞌquë paꞌiyere yecohuaꞌire quëaja̱ꞌquëpi.” ");
INSERT INTO seyNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ja̱ maca yequëpi capi: “Ëjaë, tuiye yëyë. Utejë̱ꞌë. Duꞌru macarepa yëꞌëtaꞌa huëꞌe paꞌicohuaꞌire pëpa tëjisiꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesupi i̱te capi: “Yëꞌë coꞌamañare ne huëosiquëpi, jaiye yeque yoꞌoyere cuasaquë yoꞌoquë pani yëꞌë coꞌamaña ne ti̱ꞌañe peoji.” ");
INSERT INTO seyNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ja̱je iye yoꞌosi jeteyoꞌje setenta paꞌiohuaꞌini i̱ saija̱ꞌa daripë̱ana duꞌru jëjo saopi, cayaohuaꞌiseꞌere, i̱pi ñaquë sahuasicohuaꞌini. ");
INSERT INTO seyNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jëjo saoquë capi, ja̱ohuaꞌire: “Nuñerepa cayë. Tëa ja̱ꞌñe cato jaiye aꞌë. Ja̱je paꞌiquëtaꞌare i̱ti necohuaꞌipi aꞌri maña paꞌiyë. Ja̱je paꞌina, se̱jëꞌë, i̱ti tse̱ aquëni jai pa̱ire jëjo saoja̱quë nejaꞌcohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ñajë saijë̱ꞌë. Mësarute jëjo saoyë, yëi ñamaje paꞌiohuaꞌini yaije̱ paꞌiohuaꞌi jopona. ");
INSERT INTO seyNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Samaꞌpë paꞌijë̱ꞌë, curi topëje̱, ca̱i topëje̱, cuiꞌne curiquëje̱, cuiꞌne zapatoje̱, cuiꞌne maꞌajaꞌa saijë pa̱i paꞌicohuaꞌi paꞌito coa sa pëpajë saijë̱ꞌë, tsoe nëcaja̱ni caye peoye. ");
INSERT INTO seyNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Huëꞌena cacacohuaꞌi pani duꞌru macarepa ñeje cajë̱ꞌë: ‘Iye huëꞌe paꞌicohuaꞌire deꞌoye paꞌiyepi paꞌijë̱ꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ja̱je pëpajëna, ja̱ohuaꞌipi deꞌoye paꞌiyere oicohuaꞌi paꞌito mësaru pëpaseꞌepi i̱ohuaꞌini paꞌija̱ꞌcoa. Deꞌoye paꞌiyere oimaꞌcohuaꞌi paꞌito ja̱ pëpaseꞌepi mësaruna coꞌi co̱sipi. ");
INSERT INTO seyNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Duꞌru pëpasi huëꞌena cacani pëani i̱ohuaꞌi a̱oñere a̱ijë cuiꞌne u̱cujë paꞌijë̱ꞌë. Coꞌamaña necohuaꞌire sëte i̱ohuaꞌipi sa̱iñeje paꞌye co̱caiyepi paꞌijë̱ꞌë. Ja̱je paꞌina, huë̱ꞌña ñape cuꞌimaꞌpë paꞌijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Pa̱i daripëna ti̱ꞌarena, ja̱ro aquëpi i̱ huëꞌena pëpasiquëpi a̱ore a̱oto a̱ijëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ja̱rore ju̱ꞌicohuaꞌi paꞌito jujucaijë̱ꞌë. Cuiꞌne quëajë̱ꞌë, Maijaꞌquë cua̱ñe te̱ꞌtena mësarupi po̱nëñe jaꞌyere paꞌiji cajë. ");
INSERT INTO seyNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ja̱je paꞌiquëtaꞌare yequë hue̱ꞌña daripë paꞌicohuaꞌipi mësarute coeto i̱ti daripë maꞌañana etani cajë̱ꞌë: ");
INSERT INTO seyNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Mësaru daripë yaꞌopi yëquë quë̱ona sëꞌaseꞌere ti̱ꞌto to̱ñë, mësaru asaye yëmaꞌpë paꞌi doꞌire i̱ñojë.’ Deꞌhua cuasajë̱ꞌë, iyere, Maijaꞌquë paꞌi te̱ꞌtena jaꞌyere paꞌiji, mësarute. ");
INSERT INTO seyNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mësarute cayë, pa̱i ñape yoꞌoseꞌe ne deꞌhua muꞌse ti̱ꞌasi maca ja̱ohuaꞌi coꞌaye yoꞌoseꞌe sa̱iñe pasipi. Sodoma daripë acohuaꞌire yoꞌoseꞌe jerepa coꞌayepi. ");
INSERT INTO seyNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Teayerepa mëꞌë Corazín daripë maca cuiꞌne Betsaida daripë. Jaiye pa̱i yoꞌo ti̱ꞌa maꞌñere yoꞌotoje̱ coa ñahuë, mëꞌë. Ja̱ro yoꞌoseꞌeje̱ paꞌye Tirona cuiꞌne Sidón daripëna yoꞌoquëna, ñasicohuaꞌi pani tsoe otiraꞌhuë. I̱ohuaꞌi coꞌayere cuasajë ai juꞌi ca̱re su̱ñani hua̱tapi jorëjë ai oiyere i̱ñoraꞌhuë. ");
INSERT INTO seyNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ja̱je paꞌiquëtaꞌare pa̱i ñape yoꞌoseꞌe muꞌse ti̱ꞌasi maca mësarupi ai jerepa coꞌaye yoꞌosi doꞌire sa̱i cua̱ñoñe paꞌiji. Tiro cuiꞌne Sidón daripë̱a paꞌicohuaꞌi se̱ña maca. ");
INSERT INTO seyNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Cuiꞌne mësaru Capernaum daripë paꞌicohuaꞌi yëquëpi ai jerepa tëto saisicohuaꞌi aꞌë maꞌtëmo quëꞌrore pana cuasayë, mësaru. Pa̱ni mësaru cato coa ai jerepa huëꞌehuëre pana caje huesëja̱ꞌcohuaꞌi aꞌë, toa yejana. ");
INSERT INTO seyNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Mësaru cayere asacohuaꞌi pani yëꞌëni asaja̱ꞌcohuaꞌi aꞌë, cuiꞌne mësaruni coecohuaꞌi pani yëꞌëni coeja̱ꞌcohuaꞌi aꞌë, cuiꞌne yëꞌëni coecohuaꞌi pani yëꞌëre jëjo daosiquëni coeyë.” ");
INSERT INTO seyNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ja̱ohuaꞌi setenta paꞌiohuaꞌi ai sihuayë. Coꞌini cahuë: “Ëjaë, huatiohuaꞌique yëquë mëꞌë mamire cajëna, asajë caꞌrajë etahuë.” ");
INSERT INTO seyNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesupi capi, ja̱ohuaꞌire: “Ja̱je paꞌijë̱ꞌë. Yëꞌëje̱ ñahuë, huati ëjaëpi maꞌtëmopi mujuë yeꞌhueyeje̱ paꞌyerepa to̱mequëna. ");
INSERT INTO seyNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yëꞌëpi mësarute tutu i̱sihuë, a̱ñare, pu̱nire tsaꞌcujëna, ti aꞌsi neñe peo ja̱ꞌñere. Cuiꞌne maire sa̱ñope yoꞌoquë tutu jerepa i̱sihuë, quëcoja̱ꞌcohuaꞌire caquë. ");
INSERT INTO seyNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ja̱je paꞌiquëtaꞌare sihuamaꞌpë paꞌijë̱ꞌë, huatiohuaꞌi mësarute sehuoyere. Coa ai jerepa mësaru mami maꞌtëmore toyaseꞌe paꞌiyere sihuajë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ja̱ maca Jesús Maijaꞌquë joyopi i̱ ja̱ꞌre paꞌiye sëte ai sihuaquë capi: “Sihuayë, Jaꞌquë mëꞌëre maꞌtëmo cuiꞌne yeja Ëjaëre. Mëꞌëpi iyere i̱ñohuë, tsi̱je paꞌiohuaꞌina mëꞌëpi ta̱ꞌñe cuasajë paꞌicohuaꞌire cuiꞌne ai asacohuaꞌire yahueseꞌere. Ja̱je ti̱ꞌapi, mëꞌë yëyeje̱.” ");
INSERT INTO seyNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yëꞌë jaꞌquëpi siꞌa coꞌamaña yëꞌëna i̱sipi. Maijaꞌquë mamaquë api cajë pa̱i ñañe pa̱ñë. Coa jaꞌquëseꞌe asaji, i̱ mamaquëre. Jaꞌquëreje̱ pa̱i ñañe pa̱ñë. Coa mamaquëseꞌe asaji, i̱te. Ja̱je asaquë i̱ mamaquëpi i̱ yëcohuaꞌina i̱ñocohuaꞌiseꞌe asayë, i̱ paꞌiye. ");
INSERT INTO seyNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ja̱ maca i̱ yeꞌyacohuaꞌiseꞌere capi: “Mësaru ñañeje ñacohuaꞌipi sihuacohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ja̱je paꞌina, cayë, mësarute. Jai pa̱i Maijaꞌquë yoꞌo ja̱ꞌñere quëacaicohuaꞌi cuiꞌne pa̱i ëjaohuaꞌi mësaru ñañeje paꞌye ñañe yëhuë. Ja̱je yëjëtaꞌa ñamaꞌpë paëꞌë. Cuiꞌne asaye yëhuë, mësaru asayeje̱ paꞌyere. Ja̱je yëjëtaꞌa asaye pa̱huë.” ");
INSERT INTO seyNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ja̱ maca cua̱ñeseꞌe yeꞌyaquëpi huëni Jesús quëꞌrona i̱ ja̱ꞌre coca caquë, neñasiꞌi cuasaquë sani se̱jiꞌi: “¿Yeꞌyaquë, me nejaꞌquë aꞌni, ti paꞌiye ti̱ꞌañe cani?” ");
INSERT INTO seyNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesupi sehuopi: “¿I̱ti cua̱ñeseꞌere ñato me paꞌiquëꞌni, mëꞌëpi asato?” ");
INSERT INTO seyNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Caquëna, cua̱ñeseꞌe yeꞌyaquëpi sehuopi: “Oijë̱ꞌë, mëꞌë Ëjaë Diusure siꞌa mëꞌë yëyepi, siꞌa mëꞌë joyo, siꞌa mëꞌë tutu, cuiꞌne siꞌa mëꞌë cuasaye. Cuiꞌne oijë̱ꞌë, mëꞌë quë̱no maca aquëre mëꞌëjaꞌa coꞌye oiyeje̱ paꞌye.” ");
INSERT INTO seyNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Caquëna, ja̱ maca Jesupi capi: “I̱te deꞌoyerepa sehuohuë, mëꞌë. Ja̱je mëꞌë yoꞌoquë pani, ti paꞌiye ti̱ꞌajaꞌquë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ja̱je caquëna, cua̱ñeseꞌe yeꞌyaquëpi deꞌoye yoꞌoquë aꞌë caquë Jesure i̱ñosiꞌi caquë sa̱ñope se̱jiꞌi: “¿Ja̱je paꞌito ne aꞌni, yëꞌë quë̱no maca paꞌiquë?” ");
INSERT INTO seyNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Caquëna, Jesupi sehuopi i̱te: “Teꞌi pa̱i Jerusalénpi maꞌajaꞌa Jericóna mejiꞌi. Meina, coꞌamaña ñacohuaꞌipi tse̱ani siꞌaye i̱ paye cuiꞌne i̱ juꞌi ca̱je jiohuë. Ai tëꞌcarena, ju̱ꞌiseꞌeje̱ paꞌi u̱ina, je̱oni saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Cuiꞌna maꞌajaꞌa judío Maijaꞌquë huëꞌere ñacaiquë saiquëpi maꞌare u̱ina, ñani coa ñaquë sa sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Cuiꞌne i̱ti maꞌajaꞌa levita sai coa ñani sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ja̱je sai sitore Samaria pa̱i coecohuaꞌi aquëpi cuiꞌne maꞌajaꞌa sai teaye ñani. ");
INSERT INTO seyNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ja̱ maca tsioja̱ni aꞌsire huiꞌyape ocopi cuiꞌne oꞌsayepi tsoani ca̱ñapi hue̱ni jujupi. Jeteyoꞌje i̱ caballona tëoni sapi, saicohuaꞌi pëa huëꞌena. ");
INSERT INTO seyNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Se ñatasi muꞌse Samaria aquëpi sai huëoni caya curiquë të̱ꞌña i̱sipi, i̱ti huëꞌe aquëre. I̱siquë capi: ‘Deꞌhua ñacaijë̱ꞌë, iquëre. Mëꞌëpi ai jerepa i̱ doꞌire necaisiquë paꞌitoje̱ yëꞌëpi sa̱isiꞌi cuiꞌnaëpi coꞌi co̱si maca.’ ");
INSERT INTO seyNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Deꞌoji. Ja̱je paꞌito: ¿Toaso̱cohuaꞌi aquë jequë paquëꞌni, ñaohuaꞌi huani o̱ani saisiquë quë̱no maca aquë i̱te oisiquë, mëꞌëpi cuasato?” ");
INSERT INTO seyNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Caquëna, cua̱ñeseꞌe yeꞌyaquëpi capi: “I̱te ñani oi necaisiquë api cuasayë.” Caquëna, ja̱ maca Jesupi capi, i̱te: “Mëꞌëje cuiꞌne sani yoꞌoquë paꞌijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús maꞌajaꞌa saiquëpi ti̱ꞌapi, aꞌri daripëna. Ja̱rote cuiꞌne pacoꞌë, Marta hueꞌecopi. Ja̱opi i̱o huëꞌena pëpao, i̱te, cuiꞌne i̱ yeꞌyacohuaꞌije̱. ");
INSERT INTO seyNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Cuiꞌne pacoꞌë, Marta yoꞌjeo María hueꞌecoje̱. Ja̱opi Jesús quë̱o yëꞌquë macana jaꞌruni ñuꞌio asao, i̱ cayere. ");
INSERT INTO seyNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Asacona, Martapi jaiye huëꞌe coꞌamaña neñe paꞌina, ñani ai cuasa huesëco Jesús quëꞌrona tsio dani cao: “¿Ëjaë, yëꞌëseꞌe necona, yëꞌë yoꞌjeo coa ñuꞌico ñaquë, mëꞌë? Ja̱je paꞌina, cayë i̱ote cajë̱ꞌë, yëꞌëre sani co̱caija̱ꞌco.” ");
INSERT INTO seyNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ja̱je cacona, Jesupi sehuopi: “Marta, Marta mëꞌë jaiye neñere coꞌa ju̱ꞌio, cuiꞌne ai cuasaco. ");
INSERT INTO seyNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ja̱je paꞌiquëtaꞌare teꞌo paꞌiji nuñerepa co̱caiye. Ja̱re María ti̱ꞌao, yecohuaꞌije̱ jioye ti peoyere.” ");
INSERT INTO seyNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ti̱jupë Jesús Maijaꞌquëre se̱ni tëjisi maca i̱ yeꞌyacohuaꞌi aquëpi capi, i̱te. Ëjaë, yeꞌyajë̱ꞌë, Maijaꞌquëre se̱ñe, Juan i̱ yeꞌyacohuaꞌire yeꞌyaquë paꞌiseꞌeje̱. ");
INSERT INTO seyNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Caquëna, Jesupi sehuopi: “Se̱cohuaꞌi pani ñeje cajë̱ꞌë: Yëquë Jaꞌquë maꞌtëmo paꞌiquë, Mëꞌë mami deꞌoyere paꞌë. Mëꞌë cua̱ñeñe daija̱quë yëquëna, Mëꞌë yëyepi yoꞌoye paꞌija̱ꞌquë, iye yejaje̱, maꞌtëmo yoꞌoyeje̱ paꞌye. ");
INSERT INTO seyNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Iye muꞌse a̱i ja̱ꞌñere i̱sijë̱ꞌë, caraye peoye. ");
INSERT INTO seyNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Yecohuaꞌipi yëquëni doꞌi pajëna, sa̱i deꞌhuacaiyeje̱ paꞌye mëꞌëpi yëquë doꞌire sa̱i deꞌhuacaijë̱ꞌë. Neñañe paꞌito mëꞌëpi coꞌayere nejocaijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesupi capi, ja̱ohuaꞌire: “Mësaru aquëpi teꞌire i̱ cajeire paquëni ja̱ëpi ñami jopo i̱ huëꞌena dani caji, i̱te: ‘Cajei, toaso̱ a̱o i̱sijë̱ꞌë, coꞌyoja̱ꞌquë aꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Yëꞌë cajeipi yure ti̱taëna, a̱oñepi peoquëna, cayë, caji. ");
INSERT INTO seyNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Caquëna, tuꞌrihuëpi de sehuoquë casipi: ‘Jo̱sa da cayë. Eta saꞌro si̱osicoa. Jere mëꞌëre i̱sisiꞌquë coa huëiyeꞌni, tsi̱ ja̱ꞌre u̱ini.’ ");
INSERT INTO seyNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ja̱je casiquëtaꞌa cajei paꞌisi doꞌire huëni i̱siye pa̱pi, coa jo̱sa jerepa se̱maꞌquëni caquë huëni i̱sipi, siꞌaye i̱te caraseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ja̱je paꞌina, yëꞌëpi cayë, mësarute: Se̱jëꞌë. Maijaꞌquëpi i̱sija̱ꞌquë api. Coꞌejë ti̱ꞌajaꞌcohuaꞌi aꞌë. Eta saꞌrona tëꞌcajëna, huiꞌyosipi. ");
INSERT INTO seyNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ja̱je paꞌina, se̱quëpi i̱si cua̱ñoñe paꞌiji. Cuiꞌne coꞌequëpi ti̱ꞌañe paꞌiji. Cuiꞌne eta saꞌrona tëꞌcaquëni huiꞌyocaiye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Mamaquëpi panre se̱ina, quë̱na përe i̱siꞌñe paꞌi aꞌë mësaru aquë je̱ꞌquë mamaquëre ¿panitaꞌa huaꞌire se̱ina, a̱ñani a̱oꞌñe paꞌi aꞌë? ");
INSERT INTO seyNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Pa̱nitaꞌa tsiapëre se̱ina, pu̱nini a̱oꞌñe paꞌi aꞌë? Pa̱ni. ");
INSERT INTO seyNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ñajëꞌë. Mësaru coꞌacohuaꞌitaꞌa mamajëre oijë deꞌoyere i̱sicohuaꞌi aꞌë. Ja̱je paꞌiye sëte mësaru Jaꞌquë ai jerepa oiquë sëte i̱ deꞌo joyore pañuꞌu cajë se̱cohuaꞌire i̱sija̱ꞌquë api.” ");
INSERT INTO seyNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yequë muꞌseña huatipi coca camaꞌquëre nesiquëni Jesupi huatire eto sauna, coca capi, camaꞌquë paꞌisiquëpi caquëna, ñajë jai pa̱i ai cuasahuë, merepa yoꞌo uꞌni iye cajë. ");
INSERT INTO seyNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Yecohuaꞌipi cahuë: “Huatiohuaꞌi ëjaë Beelzebú tutupi yoꞌoji, iquë, huatire eto saoquëna, ñajë.” ");
INSERT INTO seyNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Yecohuaꞌipi pa̱i yoꞌo ti̱ꞌa maꞌñe maꞌtëmo ayere yoꞌo i̱ñojëꞌë cajë se̱iꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ja̱ se̱cohuaꞌi cuasayere asaquëpi ja̱ohuaꞌire capi: “Teꞌe yeja ëjaohuaꞌipi jopoja̱ꞌa huasicohuaꞌi pani sa̱ꞌñe uihuani coꞌye i̱ohuaꞌi yejare nejoñë. Cuiꞌne teꞌe caje tsëcapë paꞌisicohuaꞌipi hua saisicohuaꞌi pani sa̱ñope yoꞌojë i̱ohuaꞌija̱ꞌa peo hue̱ꞌña ne huesëyë. ");
INSERT INTO seyNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Satanáspi i̱ tsëcapëni sa̱ñope yoꞌoquë pani ¿me siꞌaohuaꞌi cua̱ñe ti̱ꞌañe paꞌiquëꞌni? Iye cayë, mësarupi yëꞌëni Beelzebú tutupi huatire eto saoji cajëna. ");
INSERT INTO seyNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ja̱je yëꞌëpi Beelzebú tutupi yoꞌoquë paꞌito, ¿nepi mësarute tuicohuaꞌire tutu i̱siyeꞌni, huatiohuaꞌire eto sao ja̱ꞌñe? Ja̱je paꞌina, i̱ohuaꞌini mësarupi se̱ni asajë̱ꞌë, quëaja̱jë. ");
INSERT INTO seyNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ja̱je paꞌiquëtaꞌare yëꞌë cato Maijaꞌquë tuture papi huatire eto saoquë yoꞌoyë. Ja̱je paꞌina, yëꞌë yoꞌoye cato Maijaꞌquë cua̱ñe te̱ꞌtepi tsoe ti̱tapi caquë i̱ñoñe aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ai tutu quëꞌipi cuiꞌñasiquë i̱ coꞌamañare deꞌoye ñaquë paꞌito, yecohuaꞌije̱ jioye peoji. ");
INSERT INTO seyNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ja̱je paꞌiquëtaꞌare yequë ai jerepa tutu quëꞌipi cacani i̱te quëco saoye paꞌiji. Ja̱ maca siꞌaye i̱ quëcoquë uihua ja̱ꞌñere paseꞌe jioni i̱ tse̱ deꞌhuaye paꞌiji, i̱ paseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ja̱je paꞌina, yëꞌë yoꞌoyere deꞌoji cacaimaꞌquë cato yëꞌëre sa̱ñope yoꞌoquë api, cuiꞌne yëꞌë ja̱ꞌre teꞌe tsiꞌsomaꞌquë pani, coa ne tiya saoquë api. ");
INSERT INTO seyNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Huatipi pa̱ini paꞌisiquëpi eta saisiquë pani coa cue̱ne yejañare cuꞌiji, pëa hue̱ꞌñare coꞌequë. Ja̱je coꞌequë ti̱ꞌamaꞌë coꞌisiꞌi yëꞌë etani daisi huëꞌena cuasaji. ");
INSERT INTO seyNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Cani coꞌiquë ñaquëna, deꞌoyerepa yuani ne deꞌhuaseꞌeje̱ paꞌipi paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Paꞌina, ñani sani siete huatiohuaꞌi i̱ jerepa coꞌacohuaꞌi ja̱ꞌre co̱ni cacani cuiꞌnaëna, pëasi maca yuretaꞌa ja̱ꞌnë paꞌiseꞌe se̱ña maca coꞌaquë paꞌija̱ꞌquë api.” ");
INSERT INTO seyNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesús ja̱ yëꞌtaꞌa i̱tire caquëna, pa̱i jopopi nomiopi cuio: “Mëꞌëre co̱ani ai deꞌhuasico ai sihuaco paꞌico.” ");
INSERT INTO seyNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ja̱je cacona, i̱pi capi: “Ai jerepa sihuacohuaꞌi paꞌiyë, Maijaꞌquë caye asacohuaꞌipi cuiꞌne sehuocohuaꞌipi.” ");
INSERT INTO seyNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Pa̱ipi Jesús quë̱no macana tsiꞌsini saijëna, i̱pi coca ca huëopi: “Iyeꞌnë pa̱i coꞌacohuaꞌi aꞌë. Ja̱je paꞌiohuaꞌipi se̱ñë, pa̱i yoꞌo ti̱ꞌa maꞌñere yoꞌo i̱ñojëꞌë cajë. Ja̱re se̱toje̱ Maijaꞌquë yoꞌo ja̱ꞌñere quëacaiquë Jonás yoꞌoquë paꞌiseꞌeje̱ paꞌye deꞌoye yoꞌo i̱ñoñe paꞌiji. Mësaru yëyere i̱ñoñe peosipi. ");
INSERT INTO seyNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jonás Nínive daripë pa̱ire Maijaꞌquë caseꞌere i̱ñocaiquë pajiꞌi. Cuiꞌneje paꞌisiquëpi yure Pa̱i Mamaquëpi yure paꞌicohuaꞌire i̱ñojaꞌquëpi paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","32","Nínive daripë paꞌicohuaꞌipi pa̱i ñape yoꞌoseꞌe ña muꞌse huëni iyeꞌnë pa̱ire sa̱ñope caja̱ꞌcohuaꞌi aꞌë. Jonáspi Maijaꞌquë cocare quëaquëna, asani ja̱ꞌrë paꞌiseꞌe je̱oni po̱nësi doꞌipi. I̱ñore yure Jonásre tëto saisiquëpi paꞌiji. Pa̱i ñape yoꞌoseꞌe ña muꞌse paꞌi maca iye pa̱ire i̱ohuaꞌi yoꞌoseꞌeje̱ paꞌye sa̱i maca ti̱ꞌaëna, huëꞌehuë te̱ꞌte pa̱i ëjaopi huëni nejoñe paꞌiji caja̱ꞌcoa. I̱o soꞌo yejapi Salomón ta̱ꞌñe yoꞌoye asasiꞌi caco daisi doꞌire. I̱ñore Salomón jerepa paꞌipi paꞌiji, yure. ");
INSERT INTO seyNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Toa tsë̱oni yahueye peoji, pa̱nitaꞌa mahuë sa̱ꞌnahuëna ayaye peoji. Ja̱je yoꞌoye pa̱jë coa ai jerepa ë̱mëjeꞌena nëcoyë, daicohuaꞌire miacaija̱ꞌconi. ");
INSERT INTO seyNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ca̱përe ñaco ca̱ miacaiye paꞌiji. Ja̱je paꞌina, mëꞌë ñaco ca̱pi deꞌoyere ñañe paꞌito më ca̱pëje̱ deꞌoye miacaisico paꞌiji. Ja̱je paꞌiquëtaꞌare mëꞌë ñaco ca̱pi coꞌato siꞌa mëꞌë ca̱pëje̱ ai yoꞌoyere paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Deꞌhua ñajëꞌë, mëꞌë miañe paꞌiyere, neañena po̱nëmaꞌconi caquë. ");
INSERT INTO seyNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ja̱je paꞌina, mëꞌë ca̱pëpi miañe jopore paꞌito siꞌaye ti̱ñarepa ñañe paꞌiji, neañe peoto. Toa tsë̱ocopi miacaina, ñañeje paꞌye.” ");
INSERT INTO seyNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesús coca ca tëji maca, fariseopi Jesure huëopi, i̱ huëꞌena a̱o sani a̱ijëꞌë caquë. Huëouna, sani jaꞌrupi a̱o a̱i saihuëna. ");
INSERT INTO seyNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jaꞌruna, fariseopi jë̱ña tsoajë̱ꞌë a̱imaꞌnë cua̱ñeseꞌere yoꞌomaꞌajiꞌi, ñaquë cuasapi. ");
INSERT INTO seyNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ja̱je cuasaquëna, Ëjaëpi capi, i̱te: “Mësaru fariseo pa̱i cato coa ë̱mëjeꞌe u̱cu duruhuë̱aseꞌe cuiꞌne quë̱na neꞌñaseꞌe tsoacohuaꞌi aꞌë. Ja̱je yoꞌocohuaꞌitaꞌa sa̱ꞌnahuë cato siꞌsio. Yecohuaꞌi payere yëcohuaꞌipi cuiꞌne coꞌayepi ti̱mësicohuaꞌi aꞌë. Mësaru cuiꞌne paꞌiyë. ");
INSERT INTO seyNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Huesëohuaꞌi, ña maꞌñe ë̱mëjeꞌe nesiquëpi sa̱ꞌnahuë ayeje̱ Maijaꞌquëpi neseꞌe aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ja̱je paꞌina, peocohuaꞌina i̱sijë̱ꞌë, mësaru sa̱ꞌnahuë payere. Ja̱je yoꞌoto siꞌaye tsoa to̱seꞌe paꞌija̱ꞌcoa. ");
INSERT INTO seyNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Teayerepa mësaru fariseo pa̱i maña. Mësarupi diez topë̱a neni teꞌore Maijaꞌquëna i̱siyë, a̱iñena huëo së̱ñe nejë a̱iñere, cuiꞌne ta̱seꞌe co̱ni. Ja̱je deꞌoye yoꞌojëtaꞌa nuñerepa deꞌoye yoꞌoyere cuiꞌne Maijaꞌquë oiyeje̱ paꞌye yoꞌoyere peocohuaꞌipi paꞌiyë. Ja̱je paꞌina, iyere yoꞌoye paꞌiji, mësaru tsoe deꞌoye yoꞌoyena co̱ni. ");
INSERT INTO seyNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Teayerepa mësaru fariseo, pa̱i maña! Pa̱i tsiꞌsi huë̱ꞌñare deꞌo saire ñuꞌijëna, ñajë pa̱ipi jerepa paꞌiohuaꞌi aꞌë caja̱jë cuasacohuaꞌi aꞌë, cuiꞌne coꞌamaña huero hue̱ꞌñare nëcajëna, jai pa̱i i̱ti maca ñacohuaꞌipi jerepa paꞌiohuaꞌi aꞌë cajë deꞌoye pëpaja̱jë cajë, mësaruje̱ teaye yoꞌocohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Cua̱ñeseꞌe yeꞌyacohuaꞌi cuiꞌne fariseo pa̱i co̱ni teayerepa coa cacohuaꞌi aꞌni, ta̱si daripëje̱ paꞌiohuaꞌini, pa̱i ñamaꞌpë tsaꞌcujë siꞌsi neñeje yoꞌoyë.” ");
INSERT INTO seyNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ja̱je caquëna, cua̱ñeseꞌe yeꞌyaquëpi ñeje caquë sa̱ñope sehuopi: “Yeꞌyaquë, ja̱je mëꞌë cani yëquëreje̱ tea ju̱ꞌi cayë.” ");
INSERT INTO seyNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ja̱je caquëna, Jesupi sehuopi: “Teayerepa mësaruje̱ cua̱ñeseꞌe yeꞌyacohuaꞌije̱ yoꞌoyë. Yecohuaꞌiseꞌere dëquë coꞌamañare hueꞌocaiyë. Ja̱je yoꞌojëtaꞌa mësarupi teꞌe moño macaje̱ se co̱caiye coecohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Maijaꞌquë yoꞌo ja̱ꞌñere quëacaicohuaꞌire ja̱re mësaru aiohuaꞌipi huani je̱oni ta̱si daripë̱are mësaru teayerepa ne deꞌhuacohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ja̱je yoꞌojë mësaru aipë yoꞌoseꞌere deꞌoji cuasajë yoꞌoye ñañe paꞌiji, mësarupi i̱ohuaꞌi huani ta̱si daripë̱are ne deꞌhuajëna. ");
INSERT INTO seyNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ja̱je paꞌina, Maijaꞌquë i̱ ta̱ꞌñe asayepi capi: ‘Jëjo saoja̱ꞌquë aꞌë yequë muꞌse yoꞌo ja̱ꞌñere ca nëocohuaꞌire cuiꞌne sahuani yëꞌë coca quëacohuaꞌire nesicohuaꞌireje̱ ja̱ohuaꞌini huani je̱ajaꞌcohuaꞌi aꞌë, yecohuaꞌini coa jo̱sa yoꞌojë.’ ");
INSERT INTO seyNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ja̱je paꞌina, yeja deꞌhuasi macapi i̱te quëacaicohuaꞌire huaisi doꞌire yure paꞌi pa̱ini Maijaꞌquëpi se̱jaꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abelre huaisi macapi cuiꞌne Sacariare huaisi macaja̱ꞌa acohuaꞌi doꞌire yëi ñamare ëo hue̱ꞌñana cuiꞌne Maijaꞌquëre se̱ huëꞌena joporepa. Ja̱je paꞌina, nuñerepa cayë quëapi, yure paꞌi pa̱ina se̱jaꞌquë api, tsie doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Teayerepa mësaru cua̱ñeseꞌe yeꞌyacohuaꞌi nuñerepa cocare yahueyë. Ja̱je yoꞌojë coejë yecohuaꞌi asañuꞌu cajë yëcohuaꞌireje̱ ë̱sejë sa̱ñope yoꞌoyë, mësarupi.” ");
INSERT INTO seyNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ñeje Jesús caquëna, asani cua̱ñeseꞌe yeꞌyacohuaꞌi cuiꞌne fariseohuaꞌi ai pë̱titeiꞌë. Ja̱je paꞌijë jaiye se̱ huëohuë. ");
INSERT INTO seyNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Se̱jëna, tayo sehuouna, ñani tse̱añuꞌu, coꞌaquë api caja̱jë cuasajë. ");
INSERT INTO seyNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jai pa̱i mil jerepa teꞌe macana tsiꞌsini airepa ti̱mëni sa̱ꞌñe juꞌajë yoꞌohuë. Yoꞌojëna, Jesupi i̱ yeꞌyacohuaꞌini duꞌru macarepa ca huëopi, ñeje: “Deꞌhua ñajëꞌë, fariseohuaꞌi porere. Ja̱je cani capi fariseohuaꞌi coa cajë yoꞌoyere yeꞌyemaꞌpë paꞌijë̱ꞌë caquë. ");
INSERT INTO seyNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ja̱je paꞌina, asamaꞌpëna yoꞌoseꞌere ti̱ꞌa ja̱ꞌñe aꞌë cuiꞌne yahue yoꞌoseꞌere, asa ja̱ꞌñe aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ja̱je paꞌina, mësaru nea hue̱ꞌña yoꞌoseꞌere muꞌsepi asaja̱ꞌcohuaꞌi aꞌë, cuiꞌne yahuerepa tuꞌrihuëna si̱oni caseꞌere huëꞌe sa̱ꞌnihuëpi nëcajë cui ja̱ꞌñe aꞌë, pa̱i asa hue̱ꞌñana. ");
INSERT INTO seyNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ja̱je paꞌina, cayë, mësarute. Ca̱pë huaicohuaꞌire caꞌramaꞌpë paꞌijë̱ꞌë. Ja̱ohuaꞌi cato jerepa yoꞌoye peoyë. ");
INSERT INTO seyNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ja̱je paꞌina, quëasiꞌi. Caꞌrajë̱ꞌë, huani je̱osi jeteyoꞌje toa yejana jëjo saoquëni. Ja̱je paꞌina, caꞌrajë̱ꞌë, Maijaꞌquëni. ");
INSERT INTO seyNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Mësarupi asayë, cinco pi̱ꞌani caya të̱ꞌña i̱sicohuaꞌi aꞌë cajë. Ja̱je aꞌri doꞌiohuaꞌitaꞌare Maijaꞌquë hua̱nëyemaꞌë ñacaiji. ");
INSERT INTO seyNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ja̱je paꞌina, mësaru nañaque cue̱cueseꞌe aꞌë, caꞌramaꞌpë mësarupi. Ja̱je paꞌina, pi̱ꞌa jerepa doꞌicohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Siꞌaohuaꞌi mësarupi yëꞌëni caꞌramaꞌpë yëꞌë cajeipi cacohuaꞌire cato, yëꞌë Pa̱i Mamaquëje̱ Maijaꞌquë hui̱ñaohuaꞌina yëꞌë cajeipi quëaja̱ꞌquë aꞌë cayë. ");
INSERT INTO seyNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ja̱je cuiꞌne yëꞌëni caꞌrajë cajei peoyë, pa̱i asa hue̱ꞌñana casicohuaꞌire yëꞌëje̱ cuiꞌne Maijaꞌquë hui̱ñaohuaꞌi ña hue̱ꞌñana yëꞌë cajei peoji, caja̱ꞌquë aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ja̱je paꞌina, yecohuaꞌipi Pa̱i Mamaquëre coꞌaye casicohuaꞌi pani sa̱i deꞌhua cua̱ñoñe paꞌiji. Ja̱je paꞌiquëtaꞌare yecohuaꞌipi Maijaꞌquë joyore coꞌaye casicohuaꞌi pani sa̱i deꞌhua cua̱ñoñe ti peoji. ");
INSERT INTO seyNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Mësarute tse̱ani pa̱i tsiꞌsi huë̱ꞌñana, pa̱nitaꞌa pa̱i yoꞌoye ñacohuaꞌi quëꞌrona coꞌaye yoꞌocohuaꞌi aꞌë cajë sacohuaꞌi paꞌito duꞌru cuasamaꞌpë paꞌijë̱ꞌë, me sehuoja̱ꞌcohuaꞌi aꞌni cajë. ");
INSERT INTO seyNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","I̱ti caye ti̱ꞌasi maca Maijaꞌquë joyopi quëaquëna, mësaru caja̱ꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Pa̱i jopopi Jesure capi, ñeje: “Yeꞌyaquë, se quëajë̱ꞌë, yëꞌë aꞌyëre yëꞌëreje̱ coꞌamaña huacaija̱quë jaꞌquë paseꞌe.” ");
INSERT INTO seyNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Caquëna, Jesupi capi, i̱te: “¿I̱na, nepi yëꞌëre pa̱i yoꞌoye ñaquëre cuiꞌne coꞌamaña huahuequëre cua̱ñereꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Yequeje̱ capi, Jesús: “Siꞌaye coꞌamaña ëayere deꞌhua ñajëꞌë. Ja̱je paꞌina, pa̱i paꞌiye cato jaiye coꞌamaña payepi co̱caina, paꞌiye peoji.” ");
INSERT INTO seyNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ja̱je caquë pa̱i paꞌiyere ti̱ñarepa quëasiꞌi caquë capi: “Paꞌiji, teꞌi ë̱më jaiye coꞌamaña paquë. Paꞌina, i̱ ta̱si coꞌamañapi jaiye tëa ja̱ꞌñepi quë̱jiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ja̱ maca ñani jaiye coꞌamaña paquëpi ¿me nejaꞌquë aꞌni, i̱ti deꞌhua hue̱ꞌñaje? ¿Jerona deꞌhuaja̱ꞌquë aꞌni, quë̱iseꞌe? caquë cuasa huëopi. ");
INSERT INTO seyNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ja̱ maca cuasapi, peo hue̱ꞌña ja̱ꞌrë deꞌhua huë̱ꞌña paꞌiseꞌe nejoni yeque jerepa jai huë̱ꞌña nesiꞌi. Neni ja̱rona deꞌhuasiꞌi siꞌaye yëꞌë tëaseꞌe cuiꞌne siꞌaye yëꞌë tsoe paye co̱ni. ");
INSERT INTO seyNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ja̱ jeteyoꞌje deꞌhuani yëꞌëja̱ꞌa casiꞌi: ‘Jaiye coꞌamaña deꞌhuaseꞌe payë, tsoe o̱metëca paꞌi ja̱ꞌñere pëa huajëquë sihuaquë u̱cuquë a̱i pasiꞌi’ cuasapi. ");
INSERT INTO seyNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ja̱je cuasaquëna, Maijaꞌquëpi i̱te capi: ‘Huesë maca, iye ñami mëꞌë ju̱ꞌijaꞌquë aꞌë. Ja̱je paꞌina, mëꞌë deꞌhuaseꞌe ¿ne tse̱ paꞌi ja̱ꞌñe aꞌni?’ ");
INSERT INTO seyNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ja̱ maca po̱nëni siꞌaohuaꞌire capi. Ja̱je yoꞌoye paꞌiji. Jaiye coꞌamaña paquëpi coꞌye deꞌoye paꞌiyeseꞌe cuasaquë, Maijaꞌquëre cuasamaꞌquë cato.” ");
INSERT INTO seyNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jeteyoꞌje Jesús i̱ yeꞌyacohuaꞌire capi: “Ja̱je paꞌina, mësarute coꞌa ju̱ꞌimaꞌpë paꞌijë̱ꞌë, jere a̱ijaꞌcohuaꞌi aꞌni cuasajë. Cuiꞌne coꞌa ju̱ꞌimaꞌpë paꞌijë̱ꞌë, jere ca̱ña juꞌija̱ꞌcohuaꞌi aꞌni cuasajë. ");
INSERT INTO seyNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","A̲o a̱iñe jerepa doꞌiye aꞌë, pa̱i paꞌiye. Cuiꞌne ca̱ña juꞌiye jerepa doꞌiye aꞌë, mai ca̱pë. ");
INSERT INTO seyNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ñajëꞌë, ja̱ohuaꞌi pëꞌpërini, coꞌamaña ta̱maꞌcohuaꞌitaꞌa cuiꞌne tëamaꞌcohuaꞌitaꞌa cuiꞌne i̱ti ca̱ deꞌhua huëꞌe peocohuaꞌitaꞌa cuiꞌne pëa hue̱ꞌña peocohuaꞌitaꞌa deꞌhue Maijaꞌquëpi co̱caina, paꞌicohuaꞌini. Ja̱je paꞌina, mësaru pi̱ꞌa se̱ña maca doꞌicohuaꞌi aꞌë, pa̱irepa sëte. ");
INSERT INTO seyNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ja̱je paꞌito ¿nepi mësaru acohuaꞌi ai coꞌa ju̱ꞌi doꞌire metro joporeja̱ꞌa tsoacohuaꞌi ai deꞌoja̱ꞌcohuaꞌi aꞌni? ");
INSERT INTO seyNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ja̱je paꞌina, ai cuasa doꞌire aꞌri maña paꞌiseꞌere jaiye se mëoñuꞌu ai jerepa cuasayeꞌni. Ja̱je paꞌito ¿me neñuꞌju airepa yequë coꞌamañare coꞌa ju̱ꞌiñeꞌni? ");
INSERT INTO seyNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ñajëꞌë, cuiꞌne jorore coa mëani paꞌiyere coꞌamaña ne maꞌñetaꞌa cuiꞌne yëije̱ oya maꞌñetaꞌa ai deꞌo joro paꞌiyere. Ja̱je paꞌina, cayë, pa̱i ëjaë Salomón maca i̱ deꞌo hue̱ꞌñare paꞌinije deꞌo joꞌya joroje̱ paꞌirepa juꞌiye pa̱pi. ");
INSERT INTO seyNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ja̱je Maijaꞌquë taya mañataꞌa deꞌoye su̱ñacaiseꞌere paji, coa yureseꞌe pani ñaminaꞌa tsoe ju̱ꞌiseꞌe paꞌina, toana ëo ja̱ꞌñetaꞌa. Ja̱je paꞌito mësarute ai jerepa ca̱ña su̱ñacaiye paꞌiji, Maijaꞌquë necaimaꞌquë api, cuasacohuaꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ja̱je paꞌina, coꞌa ju̱ꞌijë cuiꞌne coꞌejë cuꞌimaꞌpë paꞌijë̱ꞌë, jere a̱ijaꞌcohuaꞌi aꞌni cuiꞌne jere u̱cuja̱ꞌcohuaꞌi aꞌni cuasajë. ");
INSERT INTO seyNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Iye yeja pa̱i ja̱je ai cuasajë paꞌiyë, siꞌaye iyere. Ja̱je paꞌiquëtaꞌa mësaru tsoe mësaru jaꞌquëre payë, siꞌaye mësarute jopo caraye asaquëni. ");
INSERT INTO seyNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ja̱je paꞌina, mësarupi Maijaꞌquë cua̱ñe te̱ꞌtere ai oijë yoꞌoto Maijaꞌquëpi deꞌhue jopo caraye i̱siquëna, coꞌamaña pajë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Caꞌramaꞌpë paꞌijë̱ꞌë, yëꞌëre asacohuaꞌi mësaru aꞌri pa̱i mañaꞌë. Ja̱je paꞌiquëtaꞌare mësaru jaꞌquëpi i̱ cua̱ñe te̱ꞌtere i̱siye yëji. ");
INSERT INTO seyNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mësaru paye paꞌito i̱sijë̱ꞌë, curiquëpi cuiꞌne coꞌamaña carasicohuaꞌina doꞌi peoye coa i̱sijë̱ꞌë. Ja̱je yoꞌojë ai hua̱no topë̱a deꞌo maꞌñere ti̱ꞌajëꞌë. Maꞌtëmo coꞌamaña caraja̱i maꞌñere, cuiꞌne ñaëje cacamaꞌtore puꞌjuje̱ puꞌjumaꞌtore paja̱ꞌcohuaꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mësaru coꞌamaña pa hue̱ꞌñare, cuiꞌne ja̱rote mësaru joñoaje̱ pasipi. ");
INSERT INTO seyNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ne deꞌhuasicohuaꞌipi ñare pajë paꞌijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Fiesta ña tëjini ëjaë coꞌija̱ꞌquëpi cayë, i̱ joꞌya utejë paꞌiyeje̱ paꞌiohuaꞌi paꞌijë̱ꞌë. Ti̱tani eta saꞌrona tëꞌca maca esa huiꞌyocaiyeje̱ yoꞌoja̱ꞌcohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Sihuaja̱ꞌcohuaꞌi aꞌë, i̱ohuaꞌi ëjaëpi utejë paꞌijëna, ti̱taëna ñani. Nuñerepa cayë, i̱ohuaꞌi ëjaëpi sihuaquë a̱o a̱i saihuëna soini a̱ore a̱ojaꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ñami joporepa pa̱nitaꞌa ñata ñami ti̱taquëtaꞌa, sëtasicohuaꞌini ti̱taquë paꞌito sihuaja̱ꞌcohuaꞌi aꞌë, i̱te necaicohuaꞌi mañapi. ");
INSERT INTO seyNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Deꞌhua asajë̱ꞌë, coꞌamaña ñaquë dai ja̱ꞌñere asasiquëpi utequë paꞌito i̱ huëꞌe coꞌamaña i̱mani saye peoji. ");
INSERT INTO seyNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mësaru huesë maca Pa̱i Mamaquë daija̱ꞌquë api. Ja̱je paꞌina, deꞌhua ñajë utejë paꞌijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ja̱ maca Pedropi capi: “¿Ëjaë, iye yeꞌyaseꞌe yëquëseꞌere caquë yeꞌyaë? ¿Pa̱nitaꞌa siꞌaohuaꞌire caquë yeꞌyaseꞌe aꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Caquëna, Ëjaëpi sehuopi: “¿Ja̱je paꞌito ne aꞌni, ta̱ꞌñe asaquëpi cuiꞌne nuñe yoꞌoquëpi i̱ ëjaë ñacaijë̱ꞌë huëꞌe paꞌiye caseꞌere deꞌoye sehuoquë, cuiꞌne i̱ ëjaë joꞌyareje̱ a̱o deꞌoye a̱oquë yoꞌoquë? ");
INSERT INTO seyNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","I̱ ëjaë ti̱taquë ñaquëna, i̱ caseꞌeje̱ yoꞌoquë, cato deꞌoye paꞌija̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nuñerepa cayë, mësarute. Coꞌamaña paquëpi siꞌaye i̱ coꞌamaña deꞌoye ñacaisiquëna, siꞌaye i̱ coꞌamañare ñacaijë̱ꞌë caquë i̱sija̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ja̱je i̱siquëni i̱ joꞌyaëpi ëjaë ja̱ yëꞌtaꞌa tsoe nëijaꞌquë api caquë i̱ ëjaë joꞌyani coꞌaye siꞌsequë yoꞌoquë cuiꞌne nomiohuaꞌi i̱ti huëꞌe paꞌicohuaꞌire, coꞌaye yoꞌoquë cuiꞌne a̱o fiesta nequë a̱i huëoni cuiꞌne co̱no u̱cuquë cuepe huëoni. ");
INSERT INTO seyNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Yoꞌo maca i̱ ëjaë coꞌija̱ꞌquë api, i̱ joꞌyaë hua̱nëyeni utemaꞌë huesëquë yoꞌo maca ja̱ maca sehuomaꞌcohuaꞌire nejoñepi nejojaꞌquë api, i̱ yoꞌosi doꞌire ai siꞌseni. ");
INSERT INTO seyNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","I̱ ëjaë yëye i̱ joꞌyaë asaquëtaꞌa deꞌoye yoꞌomaꞌquëpi cuiꞌne i̱ caye sehuomaꞌë yoꞌoquë cato jaiye tëꞌca cua̱ñoñe paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ja̱je paꞌiquëtaꞌare i̱ ëjaë yëye huesëquëpi, coa yoꞌoni aꞌri maña tëꞌca cua̱ñoñe paꞌiji. Ja̱je paꞌina, ai cuasaye i̱sisiquëni ai se̱ñe paꞌiji, cuiꞌne i̱ti deꞌhue nequëni nequë api cuasani ai jerepa cua̱ñeñe paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Iye yejana yëꞌë toa tsë̱osiꞌi caquë daëꞌë. Tsoe coꞌarepa toa neꞌsu mëiñeje yoꞌoquëna, ñaraꞌye, merepa tsoe ne saoseꞌe paꞌina, ñaraꞌye. ");
INSERT INTO seyNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ja̱ saomaꞌ doꞌire yure cato oco doyeje̱ paꞌye ai yoꞌoyepi yëꞌëre yoꞌoquëna, tëjiyerepa ai yoꞌoquë tëto saija̱ꞌquë aꞌë caquë oiyë. ");
INSERT INTO seyNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Deꞌoye paꞌi ja̱ꞌñere dapi, cuasaye mësaru? Pa̱ni. Coa ai jerepa huahueyere dahuë. ");
INSERT INTO seyNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ja̱je paꞌina, yurepi se̱ña maca muꞌseña cato cinco teꞌe tsëcapëre paꞌicohuaꞌipi huani toaso̱cohuaꞌi sa̱ñope yoꞌoja̱ꞌcohuaꞌi aꞌë, cayahuaꞌini cuiꞌne cayahuaꞌipi toaso̱cohuaꞌini sa̱ñope yoꞌoja̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Cuiꞌne pëca jaꞌquëpi mamaquëre sa̱ñope yoꞌoye paꞌiji. Mamaquëpi pëca jaꞌquëre sa̱ñope yoꞌoye paꞌiji. Cuiꞌne pëca jaꞌcopi mamaconi sa̱ñope yoꞌoye pasipi. Cuiꞌne mamacopi pëca jaꞌcore sa̱ñope yoꞌoye pasipi, huaopi i̱o mamaquë nëjore sa̱ñope yoꞌoye pasipi. Cuiꞌne mamaquë nëjopi huaore sa̱ñope yoꞌoye pasipi.” ");
INSERT INTO seyNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesupi capi, pa̱ire: “Ë̲së caje hue̱ꞌñapi nea siri mëina, ñani cacohuaꞌi aꞌë ocoja̱ꞌcoa. Carena, cuiꞌne ocoji. ");
INSERT INTO seyNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ja̱je cuiꞌne huëꞌehuë te̱ꞌtepi tutuquëna, ñani cayë ai ë̱së uja̱ꞌcoa. Ja̱je carena, cuiꞌne ë̱sëquë uji. ");
INSERT INTO seyNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Coa cacohuaꞌi, mësaru ta̱ꞌñe cacohuaꞌi aꞌë maꞌtëmo cuiꞌne yeja yoꞌoyena, ñani. Ja̱je yoꞌocohuaꞌitaꞌa ¿me yoꞌojë mësaru paꞌi tëcahuë ayere yure ja̱je yoꞌo macare paꞌiyë cajë asa maꞌñeꞌni, ta̱ꞌñe? ");
INSERT INTO seyNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Me yoꞌojë mësaruseꞌe tayo yoꞌoye ñani? ");
INSERT INTO seyNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ja̱je paꞌina, yequëpi mëꞌëre doꞌi paquëpi cani saquë paꞌito mëꞌëre doꞌi paquë api caquë saquëni duꞌru ne deꞌhuajë̱ꞌë, ja̱ yëꞌtaꞌa pa̱i yoꞌoseꞌe ñaquë quëꞌrona ti̱ꞌamaꞌnë. Ja̱je ne deꞌhuaëna, pa̱i yoꞌoye ñaquë quëꞌro samaꞌë paꞌija̱ꞌquëre. Ja̱je mëꞌëpi yoꞌomaꞌë paꞌito pa̱i yoꞌoye ñaquëpi coꞌacohuaꞌire cocohuaꞌina i̱sina, ja̱ohuaꞌipi yuretaꞌa coꞌacohuaꞌire co hue̱ꞌñana coja̱ꞌcohuaꞌi aꞌë, mëꞌëre. ");
INSERT INTO seyNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ja̱rona cosiquë pani etaye peoji, mëꞌëpi siꞌaye mëꞌë doꞌi sa̱imaꞌë pani.” ");
INSERT INTO seyNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ja̱re ja̱ muꞌseña Pilatopi Galilea acohuaꞌire huani je̱ani, cuiꞌne i̱ohuaꞌi ëojë se̱ñuꞌu cajë huaisicohuaꞌi tsiena pa̱i tsiepi co̱ꞌmeni yoꞌoseꞌere, yecohuaꞌipi quëahuë, Jesure. ");
INSERT INTO seyNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Quëajëna, capi: “¿Mësarupi cuasani huani je̱osicohuaꞌipi Galilea pa̱ire se̱ña maca coꞌacohuaꞌi paëꞌë, cuasaye? ");
INSERT INTO seyNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Pa̱ni. Ja̱je paꞌina, cayë, mësaru. Ja̱ꞌrë yoꞌoyere je̱oni po̱nëmaꞌcohuaꞌi pani siꞌa pa̱i mësaruje̱ ja̱je yoꞌo cua̱ñojaꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Mësarupi cuasani Jerusalén paꞌicohuaꞌire se̱ña maca coꞌacohuaꞌini, diez y ocho pa̱ire Siloé tupëpi quë̱o hue̱aꞌcoꞌë, cuasaye. ");
INSERT INTO seyNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Pa̱ni. Nuñerepa cayë. Ja̱je paꞌina, mësarupi huajëye paꞌiye po̱nëmaꞌcohuaꞌi pani ja̱re cuiꞌne yoꞌo cua̱ñojaꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ja̱ maca Jesús pa̱i yoꞌoyeje̱ paꞌye neni quëaquë capi: “I̱ yejana ta̱si ñë paquëpi quë̱imaꞌo paco caquë sani ñaquëna, quë̱imaꞌco pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Paꞌina, ñani ja̱ maca yeja ñaquëre capi: ‘i̱na, toaso̱ o̱metëca daiyë, i̱ti ca̱ quë̱iseꞌe ñasiꞌi caquë. Daiquëtaꞌa ti̱ꞌamaꞌë paꞌiyë, quë̱isico paꞌiona. Ja̱je paꞌito cue̱ni je̱ojëꞌë. Me nesiꞌco coa yejare que̱ꞌeñe nëcacoꞌni.’ ");
INSERT INTO seyNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Caquëna, i̱ti yeja ñacaiquëpi sehuopi: ‘Ëjaë iye o̱metëcahuëseꞌe paꞌija̱ꞌco, a̱ꞌji yeja neni yequë coꞌamañapi o̱a ñasiꞌi, quë̱ijaꞌcore. ");
INSERT INTO seyNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ja̱je nerutaꞌa quë̱ti̱ꞌñe paꞌio i̱ti ca̱. Ja̱je neruje̱ quë̱imaꞌona, ña jujani ja̱ macataꞌa cue̱ni je̱ojëꞌë,’ capi.” ");
INSERT INTO seyNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Huajë muꞌse pa̱i tsiꞌsi hue̱ꞌñana yeꞌyaquëna, ");
INSERT INTO seyNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ja̱rote pacoꞌë, teꞌo nomio diez y ocho o̱metëca ju̱ꞌico, huatipi ne quëꞌca̱sicopi ti nuiñe nëcaye peocopi. ");
INSERT INTO seyNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Paꞌiona, ñani Jesupi soini capi: “Nomio mëꞌë ju̱ꞌi dahuë tsoe je̱opi. Deꞌoye paꞌijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Caquë ja̱ maca i̱ jëñapi i̱ona pato maca ja̱re i̱ti macapi nuñerepa nëcaco po̱nëni, Maijaꞌquë deꞌoquë api, sihuaco ca huëo. ");
INSERT INTO seyNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ja̱je Jesús huajë muꞌse jujuna, ñani pa̱i tsiꞌsi huëꞌe ñacaiquë ëjaëpi iyere ñani pë̱i, pa̱ire capi: “Seis muꞌseña paꞌiji, coꞌamaña ne muꞌseña. Ja̱ muꞌseña ja̱je paꞌito dani juju cua̱ñojëꞌë, pa̱ni huajë muꞌse juju cua̱ñoñe.” ");
INSERT INTO seyNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Caquëna, ja̱ maca Ëjaëpi sehuopi: “¡Coa cacohuaꞌi pa̱i! ¿Joyemaꞌcohuaꞌini mësaru acohuaꞌi je̱ꞌquë, huajë muꞌse paꞌina, mësaru duruhue̱quëpi pa̱nitaꞌa burropi oco u̱cuja̱ꞌquëre? ");
INSERT INTO seyNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","¿Ico nomio cato Abraham tsëcapë aconi Satanáspi diez y ocho o̱metëca hue̱seꞌeje̱ paꞌioni, joyeye coꞌaquë huajë muꞌse paꞌi doꞌire?” ");
INSERT INTO seyNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ja̱je Jesús caëna, i̱te sa̱ñope cacohuaꞌipi huajëyaꞌyerepa maire caëꞌni cuasahuë. Ja̱je cuasajëtaꞌare siꞌa pa̱i sihuahuë, Jesús pa̱i yoꞌo ti̱ꞌa maꞌñere deꞌoye yoꞌoquëna, ñani. ");
INSERT INTO seyNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ja̱ maca capi: “¿I̱queje̱ paꞌye aꞌni, Maijaꞌquë te̱ꞌte aye? ¿I̱quena cuiꞌne paꞌye neni i̱ñoraꞌye? ");
INSERT INTO seyNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ja̱je cani capi, aꞌri mostaza ca̱re ta̱quëpi yejana ta̱ëna, ai deꞌoni jai so̱quë yë deꞌona pi̱ꞌapi i̱ti ñë capë̱ana tsianoa nejë payeje̱ paꞌye aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ja̱je cani yequeje̱ capi, Jesús: “¿I̱quepi co̱ni cuiꞌne paꞌyeje̱ ne i̱ñoraꞌye, Maijaꞌquë te̱ꞌte aye yoꞌoye? ");
INSERT INTO seyNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Cani capi: Pan necopi harinare toaso̱ jai ji̱ꞌso neni cuiꞌne oꞌsa mëiñere aꞌri maña i̱ona co̱ꞌmeni i̱ona siꞌa së̱pë juju mëicoa. Ja̱ juju mëiñeje paꞌye yoꞌoye aꞌë, Maijaꞌquë te̱ꞌte ayeje̱.” ");
INSERT INTO seyNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jerusalénna sai, pa̱i daripë̱a cuiꞌne aꞌri daripë paꞌicohuaꞌire yeꞌyaquë sa tëto sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ja̱ro paꞌiquëpi se̱jiꞌi, i̱te: “Ëjaë, ¿aꞌri pa̱i maña paꞌiyë, huaso cua̱ñocohuaꞌi?” Caquëna, i̱pi sehuopi: ");
INSERT INTO seyNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Aꞌri ja̱to saꞌroja̱ꞌa cacasiꞌi cani siꞌa më cuasayepi yoꞌojë̱ꞌë. Ja̱je paꞌina, cayë mësarute pa̱i cacayere yëja̱ꞌcohuaꞌi aꞌë. Ja̱je yëjëtaꞌa caca ti̱ꞌamaꞌpë paꞌija̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ja̱ maca i̱ti huëꞌe aquëpi huëni ja̱to saꞌro si̱osi maca, mësaru hueꞌse paꞌisicohuaꞌipi caja̱ꞌcohuaꞌi aꞌë ja̱to saꞌrona tëꞌcajë ‘Ëjaë, huiꞌyojë̱ꞌë’. Ja̱je cajëna, i̱pi casipi ‘ñamaꞌquë aꞌë, mësarute. Jero acohuaꞌi aꞌni.’ ");
INSERT INTO seyNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Caquëna, mësarupi ca huëoja̱ꞌcohuaꞌi aꞌë: ‘Mëꞌë ja̱ꞌre co̱ni a̱ijë cuiꞌne u̱cujë yoꞌosicohuaꞌi aꞌë cuiꞌne ja̱re mëꞌëpi paꞌi hue̱ꞌñana dani yeꞌyasiquë aꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Cajëna, sehuoja̱ꞌquë api: ‘Tsoe cahuë ñamaꞌquë aꞌë, mësarute. Jero acohuaꞌi aꞌni. Saijë̱ꞌë, coꞌayeseꞌe yoꞌocohuaꞌi.’ ");
INSERT INTO seyNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ja̱je casi maca Maijaꞌquë te̱ꞌtere Abraham, Isaac, Jacobo, cuiꞌne Maijaꞌquë yoꞌo ja̱ꞌñere quëajë paꞌisicohuaꞌi paꞌijëna, ñani mësarupi hueꞌsena je̱ocosicohuaꞌi paꞌijë cu̱ji qui̱ꞌcojë oija̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ja̱ maca daija̱ꞌcohuaꞌi aꞌë ë̱mëjeꞌe te̱ꞌte cuiꞌne huëꞌehuë te̱ꞌte, ë̱së mëi hue̱ꞌña cuiꞌne sa̱ꞌnihuë pa̱ipi Maijaꞌquë quëꞌrona tsiꞌsini a̱o a̱ijaꞌcohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ja̱ maca yure teaye paꞌiohuaꞌi paꞌisicohuaꞌi jerepa paꞌiohuaꞌi paꞌija̱ꞌcohuaꞌi aꞌë cuiꞌne yure jerepa paꞌiohuaꞌi paꞌisicohuaꞌipi teaye paꞌiohuaꞌi paꞌija̱ꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ja̱re ja̱ muꞌse daëꞌë, fariseo pa̱i dani i̱te cahuë: “Saijë̱ꞌë, Herodes mëꞌëre huani je̱osiꞌi caji.” ");
INSERT INTO seyNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Cajëna, i̱pi sehuopi: “Sani cajë̱ꞌë, ja̱ëte coꞌaquë ta̱ꞌñe asamaꞌquëre: ‘Yure, cuiꞌne ñaminaꞌa huatiohuaꞌire eto saoquë yoꞌoni cuiꞌne ju̱ꞌicohuaꞌire juju tëjini ñaminaꞌa jerepa muꞌse saosiꞌi.’ ");
INSERT INTO seyNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ja̱je paꞌiquëtaꞌare ja̱ yëꞌtaꞌa yoꞌoja̱ꞌquë aꞌë yure, ñaminaꞌa cuiꞌne se ñatasi muꞌseje̱. Coꞌaji, Maijaꞌquëre quëacaiquëpi Jerusalén peo hue̱ꞌñana ju̱ꞌito. ");
INSERT INTO seyNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","¡Jerusalén Maijaꞌquë yoꞌo ja̱ꞌñe quëacaicohuaꞌire huani je̱o daripë! Cuiꞌne Maijaꞌquë mëꞌëni caquë jëjo daocohuaꞌire quë̱na pë̱api je̱a daripë. Jaiye mësarute oi cura mamajëre oio capë̱a huëꞌehuëna coyeje̱ yoꞌosiꞌi caquë yoꞌoquëna, coehuë. ");
INSERT INTO seyNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Mësarute Maijaꞌquëpi je̱ocoja̱ꞌquë api. Cuiꞌne yëꞌëre ña co̱ñe peoja̱ꞌcohuaꞌi aꞌë, ‘mësarupi deꞌoquëre paꞌni Ëjaë mamirepa hueꞌequë daiquë’ ca maca ti̱ꞌañe pa̱to.” ");
INSERT INTO seyNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Huajë muꞌse ti̱ꞌaëna, Jesús sajiꞌi, fariseo ëjaë huëꞌena, a̱o a̱siꞌi caquë. Saquëna, fariseohuaꞌipi huajë muꞌse i̱ yoꞌoquëna, ñañuꞌu cuasajë cuiꞌñani ñahuë. ");
INSERT INTO seyNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ñajëna, i̱ ñaquë ñuꞌi hue̱ꞌñare teꞌi coto dahuë ju̱ꞌiquëpi pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Paꞌina, Jesús se̱jiꞌi, cua̱ñeseꞌe yeꞌyacohuaꞌire cuiꞌne fariseo pa̱ire: “¿Jujuye deꞌoquë huajë muꞌse paꞌito ju̱ꞌiquëre, mësarupi asato, pa̱nitaꞌa jujuye pa̱ñe?” ");
INSERT INTO seyNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ja̱je caquëna, coa ai jerepa camaꞌpë paëꞌë. Paꞌijëna, i̱pi ju̱ꞌiquëre jujuni capi, saijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ja̱je se jujuni fariseohuaꞌire capi: “¿Nepi mësaru acohuaꞌi burropi pa̱nitaꞌa hue̱quëpi cojena to̱mesiquëre etomaꞌcohuaꞌi aꞌni, huajë muꞌse paꞌi doꞌire?” ");
INSERT INTO seyNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Caquëna, ti sehuoye pa̱huë. ");
INSERT INTO seyNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Soisicohuaꞌipi deꞌo ñuꞌi saina coꞌejë a̱o a̱i saihuëna jaꞌrujëna, ñani Jesupi ja̱ohuaꞌire ñeje yëhuopi, i̱ohuaꞌi asa ja̱ꞌñere: ");
INSERT INTO seyNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Mëꞌëni yecohuaꞌipi huejajëna, ñajaꞌquëre soisiquë pani deꞌo ñuꞌi saihuëna tëto sani jaꞌrumaꞌë paꞌijë̱ꞌë. Jaꞌruni ñuꞌina, mëꞌë jerepa paꞌini dani mësarute soisiquëpi camaꞌquëni: ‘Mëꞌë ñuꞌi saihuëre iquëna i̱sijë̱ꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Caquëna, mëꞌëpi pa̱i ñajëna, huajëyaꞌye huëni ai jeteyoꞌjerepa ñuꞌi saihuëna sani jaꞌrumaꞌquëpi ja̱je yoꞌosiꞌni. ");
INSERT INTO seyNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ja̱je yoꞌomaꞌë, huëosicohuaꞌi paꞌito, jeteyoꞌje ñuꞌi saihuëna jaꞌrujë̱ꞌë. Ja̱je jaꞌrusiquëpi ñuꞌina, mëꞌëre huëosiquëpi dani caja̱quë: ‘Yëꞌë cajei, i̱ño deꞌo hue̱ꞌñana dani jaꞌrujë̱ꞌë.’ Ja̱je cato mëꞌëje sihuaquë i̱ ja̱ꞌre co̱ni a̱o a̱i saihuëna jaꞌrusicohuaꞌi ñajëna, deꞌo ñuꞌi saihuëna jaꞌruja̱ꞌquë aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ja̱je paꞌina, yëꞌë aꞌë jerepa paꞌi caquë i̱jaꞌa yoꞌosiquëpi coa ai jerepa coꞌaquë maca po̱nëñe paꞌiji. Cuiꞌne i̱ti coꞌaquë teaye paꞌi paꞌisiquëpi jerepa paꞌi po̱nëñe paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Capi, i̱te soisiquëreje̱: “A̲ore a̱oquë pani, pa̱nitaꞌa naꞌiquëna, a̱ore a̱oquë pani, soimaꞌë paꞌijë̱ꞌë, mëꞌë cajeohuaꞌire, cuiꞌne yoꞌje tsi̱re cuiꞌne mëꞌë doꞌijëre cuiꞌne më quë̱no maca jaiye coꞌamaña pacohuaꞌire. Mëꞌëpi ja̱je soisiquë paꞌito i̱ohuaꞌije̱ mëꞌëreje̱ soija̱ꞌcohuaꞌi aꞌë, a̱ijaꞌquëre. Ja̱ maca sa̱iseꞌeje̱ paꞌye pasipi. ");
INSERT INTO seyNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ja̱je paꞌi doꞌire mëꞌëpi a̱ore paquë pani soijë̱ꞌë, coꞌamaña peocohuaꞌini, coꞌa deꞌosicohuaꞌi mañani, cuꞌimaꞌcohuaꞌini, cuiꞌne ñamaꞌcohuaꞌini. ");
INSERT INTO seyNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Coꞌye i̱siye ti pa̱jaꞌcohuaꞌini co̱caijë̱ꞌë. Ja̱je pa̱sicohuaꞌitaꞌare, nuñe yoꞌocohuaꞌi ju̱ꞌisicohuaꞌipi huëi maca mëꞌëje huëni sa̱i cua̱ñojaꞌquë aꞌë, Maijaꞌquëni.” ");
INSERT INTO seyNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ja̱je iyere caquëna, asani a̱o a̱i saihuë ñuꞌicohuaꞌi aquëpi capi, Jesure: “Deꞌhue Maijaꞌquë te̱ꞌtere paꞌi a̱o a̱ijaꞌquëpi sihuaquë paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Caquëna, Jesupi capi, i̱te: “Jai pa̱i tsiꞌsirena, a̱osiꞌi caquë jai pa̱ire huëopi. ");
INSERT INTO seyNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Huëosiquëpi a̱o a̱i macarepa ti̱ꞌaëna, i̱ joꞌyaëre capi: ‘Quërëja̱ijëꞌë, huëosicohuaꞌire siꞌaye ne saohuë’ capi. ");
INSERT INTO seyNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ja̱je casiquëtaꞌare siꞌaohuaꞌi pa̱jaꞌquë paꞌini ca huëohuë. Duꞌru macarepa aquëpi capi: ‘Ja̱ꞌarepa yejare huerohuë. Ja̱ote sani ñañeque paꞌiji. Care payë, yëꞌëre oi cuasamaꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Yequëpi capi: ‘Diez duruhue̱quëre huerohuë, yeja a̱ꞌjiñe necohuaꞌire ja̱ohuaꞌire neñañeque paꞌiji. Yëꞌëre ai cuasamaꞌë, paꞌijë̱ꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Yequëpi capi: ‘Ja̱ꞌarepa huejahuë. Ja̱je paꞌina, saiye pa̱ñë.’ ");
INSERT INTO seyNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ja̱ maca i̱ joꞌyaë coꞌini i̱ asaseꞌere siꞌaye quëapi. Quëaquëna, Ëjaëpi asani pë̱i i̱ joꞌyaëre capi: ‘Esa sani ja̱je paꞌito coꞌamaña peocohuaꞌini, cuꞌimaꞌcohuaꞌini cuiꞌne ñamaꞌcohuaꞌini, siꞌaye ai yoꞌojë paꞌicohuaꞌini ti̱ꞌani dajë̱ꞌë, jai daripë cuꞌi maꞌña paꞌicohuaꞌini.’ ");
INSERT INTO seyNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ai tsoe paꞌi maca dani i̱ joꞌyaëpi capi: Ëjaë mëꞌë cua̱ñeseꞌeje̱ yoꞌohuë. Ja̱je paꞌiquëtaꞌare ja̱ yëꞌtaꞌa peo saꞌnoa paꞌiji, ti̱mëñe peoye. ");
INSERT INTO seyNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ja̱je caquëna, ëjaëpi i̱ joꞌyaëre capi: ‘Sani iye daripëpi sai maꞌaña paꞌicohuaꞌini cua̱ñejëꞌë, dani yëꞌë huëꞌe ti̱mëjajë.’ ");
INSERT INTO seyNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Care payë, yëꞌë duꞌru huëosicohuaꞌi aquë teꞌije̱ a̱iñe peoji, yëꞌë a̱o macarepa.” ");
INSERT INTO seyNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jai pa̱i Jesure tuijëna, i̱pi coꞌye po̱nëni i̱ohuaꞌire capi: ");
INSERT INTO seyNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Yëꞌëre tuiye yëni ai yëꞌëni oiye paꞌiji, jaꞌquëre, jaꞌcore, nëjore, mamajëre, yoꞌjeire, yoꞌjeore cuiꞌne coꞌye paꞌiye oiye jerepa. Ja̱je yëꞌëni oimaꞌquë pani yëꞌëre yeꞌyequë paꞌiye peoji. ");
INSERT INTO seyNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Cuiꞌne yëꞌë doꞌire i̱ paꞌiye ai yoꞌoye paꞌitoje̱ ja̱re tusiꞌi cuasamaꞌë, coa tusiꞌi caquë yoꞌoquë pani yëꞌëre yeꞌyequë peoji. ");
INSERT INTO seyNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Cuiꞌne mësaru acohuaꞌipi jai huëꞌe neñuꞌu cajë huëocohuaꞌi pani duꞌru jaꞌruni dujë cuasacohuaꞌi aꞌni ¿Je jaꞌyepi curiquë nejaꞌcohuaꞌi aꞌni cajë? ");
INSERT INTO seyNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ja̱je deꞌoye cuasamaꞌpë, coa ja̱ꞌa huëo macaseꞌe neni, cuiꞌne jeteyoꞌje ne saoye pa̱to, siꞌaohuaꞌi i̱ti ñasicohuaꞌipi cueꞌcue huëoja̱ꞌcohuaꞌi paꞌini, yoꞌo jujayere ñani. ");
INSERT INTO seyNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ja̱ maca cueꞌcuejë caja̱ꞌcohuaꞌi aꞌë: ‘Nesiꞌi caquë huëosiquëtaꞌa ne sao ti̱ꞌamaꞌë paꞌiji.’ ");
INSERT INTO seyNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ja̱je paꞌina, cuiꞌne pa̱i ëjaë yequë yeja ëjaë ja̱ꞌre uihuasiꞌi cani, ne ti̱ꞌañe paꞌiquë caquë jaꞌruni cuasani, i̱ soldado pa̱ire cue̱cue ñaquëna, diez mil pa̱i paꞌiyë. Paꞌijëna, i̱te huajo daquëpi paji veinte mil soldado pa̱ire. ");
INSERT INTO seyNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Paquëna, neña jujani, ja̱ yëꞌtaꞌa yequë ëjaë soꞌore paꞌina, uihuaye pa̱ñuꞌu ca deꞌhuaja̱ꞌcohuaꞌire jëjo saoja̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ja̱je cuiꞌne mësaru acohuaꞌipi siꞌaye ja̱ꞌrë paꞌiseꞌere je̱oñe coecohuaꞌi pani, yëꞌë yoꞌoye yeꞌyecohuaꞌi peoyë. ");
INSERT INTO seyNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","A̲si deꞌoye aꞌë, sa̱ijaꞌiñe pani. Ja̱je paꞌiquëtaꞌare sa̱i ja̱ꞌñere caraja̱isico pani ¿me cuiꞌnaopi sa̱i ja̱ꞌñe deꞌo co̱coꞌni? ");
INSERT INTO seyNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Cuiꞌne me co̱caicoꞌni pu̱ꞌcani nea yaꞌo neina, ta̱ñuꞌu cajë nesi tsu̱ꞌsupëje̱, coꞌa deꞌoseꞌe pani. Ja̱je paꞌina, coa je̱ocoye paꞌiji, yeja ne deꞌhuaye co̱cai maꞌñe paꞌito. Ca̱joro quëꞌiohuaꞌi sëte cuasajë asajë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Paꞌi doꞌire curiquë se̱cohuaꞌi cuiꞌne coꞌaye yoꞌocohuaꞌi siꞌaohuaꞌi Jesure asañuꞌu cajë tsio daëꞌë, i̱ quëꞌrona. ");
INSERT INTO seyNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ja̱je yoꞌojëna, ñani fariseohuaꞌi cuiꞌne cua̱ñeseꞌe yeꞌyacohuaꞌi co̱ni cueꞌcuejë ñeje cahuë: “Iye ë̱më coꞌaye yoꞌocohuaꞌini yëquë tsioni a̱iji.” ");
INSERT INTO seyNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ja̱je cajëna, Jesupi pa̱i yoꞌoyeje̱ paꞌye neni quëapi, iye: ");
INSERT INTO seyNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“¿Nepi mësaru acohuaꞌi aquëpi cien yëi ñamare paquëni teꞌi ja̱ohuaꞌi aquëpi ne huesëna ne huesëja̱quë noventa y nueve paꞌija̱jë cani coꞌemaꞌquë aꞌni, ti̱ꞌamaꞌë pani? ");
INSERT INTO seyNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Deꞌhue coꞌequë ti̱ꞌani sihuaquë ta̱ta tupëna co̱a seoni. ");
INSERT INTO seyNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","I̱ huëꞌena ti̱ꞌani i̱ cajeohuaꞌire cuiꞌne i̱ jaꞌye paꞌicohuaꞌire soihuë, yëꞌë ja̱ꞌre co̱ni sihuajë̱ꞌë, ne huesësicore ti̱ꞌa doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ja̱je paꞌina, coꞌaye yoꞌoquëpi ja̱ꞌrë paꞌiseꞌere je̱oni po̱nëto hui̱ñaohuaꞌipi ai sihuayë, noventa y nueve deꞌoye paꞌicohuaꞌire sihuaseꞌe jerepa. ");
INSERT INTO seyNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Cuiꞌne ¿ico nomiopi diez të̱ꞌña pasiconi teꞌo ne huesëni toa tsë̱oni siꞌa huëꞌe ñare paco yuaco coꞌemaꞌcoa, ti̱ꞌajaꞌcoaꞌë caco? ");
INSERT INTO seyNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ja̱je deꞌhue coꞌeco ti̱ꞌani i̱o cajeohuaꞌi ja̱ꞌre co̱ni cuiꞌne i̱o quë̱no maca huëꞌe acohuaꞌi ja̱ꞌre co̱ni sihuaco casio: ‘Yëꞌë ja̱ꞌre co̱ni sihuajë̱ꞌë, curi tëꞌqui ne huesësicore ti̱ꞌahuë.’ ");
INSERT INTO seyNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ja̱je paꞌina, cayë, cuiꞌne Maijaꞌquë hui̱ñaohuaꞌi sihuaye paꞌiji, teꞌi coꞌaye yoꞌoquëpi i̱ paꞌiseꞌe je̱oni po̱nëto.” ");
INSERT INTO seyNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesupi capi, yequeje̱: “Caya mamajë ë̱mëohuaꞌire paquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Paꞌina, yoꞌjeipi capi pëca jaꞌquëre: ‘Jaꞌquë i̱sijë̱ꞌë, yëꞌëre i̱sija̱ꞌa coꞌamaña ca nëoseꞌere.’ Caquëna, pëca jaꞌquëpi coꞌamañare huahuecajiꞌi, pa̱i ñape i̱ohuaꞌi pa ja̱ꞌñe. ");
INSERT INTO seyNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","I̱sisi jeteyoꞌje aꞌri maña paꞌiquëpi yoꞌjeipi i̱ yejare i̱sipi, yecohuaꞌina. Ja̱ doꞌipi curiquë neni sajiꞌi, ai soꞌo yejana. Ja̱rona sani siꞌa curiquë coꞌayere yoꞌoquë nejo saopi. ");
INSERT INTO seyNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ja̱je siꞌaye curiquë neja saosi maca jaiye a̱o peopi, ja̱ yeja. Ja̱ maca i̱pi a̱o ëa ju̱ꞌi huëopi. ");
INSERT INTO seyNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ja̱ maca curi peoquë coꞌepi, coꞌamaña neñe ja̱ yeja aquë coꞌamañare. Ja̱ëpi i̱te cua̱ñepi i̱ joꞌya se̱sere ñacaijë̱ꞌë caquë. ");
INSERT INTO seyNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ja̱ maca ai a̱o ëaye ti̱ꞌaëna, se̱se a̱iñere a̱tiꞌñerepa nëjiꞌi. I̱te yecohuaꞌije̱ a̱o a̱oñe pa̱huë. ");
INSERT INTO seyNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","A̲o ëa ju̱ꞌi cuasa huëopi, ‘jaꞌquë huëꞌe coꞌamaña necaicohuaꞌi coꞌarepa a̱o a̱ni huajëjë. Paꞌijëna, i̱ñore yëꞌë teaye a̱o ëa ju̱ꞌi paꞌiye.’ ");
INSERT INTO seyNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ja̱je paꞌito jaꞌquë paꞌi hue̱ꞌñana coꞌini i̱te casio: ‘Jaꞌquë, mëꞌëre cuiꞌne Maijaꞌquëre coꞌaye yoꞌohuë. ");
INSERT INTO seyNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mëꞌë mamaquëre caye peoji, yëꞌëre. Mëꞌëre necaicohuaꞌire yoꞌoyepi cuiꞌne cua̱ñejëꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ja̱ maca ja̱je cuasani coꞌipi, maꞌajaꞌa pëca jaꞌquë huëꞌena. Ja̱ yëꞌtaꞌa soꞌore paꞌina, pëca jaꞌquë ñani i̱te teayerepa yoꞌoroja̱ꞌquëꞌni cuasani i̱te ñani, ja̱ maca huëꞌhuë to̱mejani suꞌcuaquë cuiꞌne tsu̱ꞌsuquë sihuapi. ");
INSERT INTO seyNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ja̱ maca mamaquëpi i̱te capi: ‘Yëꞌë jaꞌquë coꞌaye yoꞌohuë, Maijaꞌquëre cuiꞌne mëꞌëreje̱. Ja̱je paꞌina, mëꞌë mamaquëre caye peoji, yëꞌëre.’ ");
INSERT INTO seyNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ja̱je caquëna, pëca jaꞌquëpi capi, i̱ joꞌyare: ‘Esao maña deꞌo ca̱ñare etoni su̱ñacaijë̱ꞌë. Cuiꞌne i̱ moñona aniño su̱ñacaijë̱ꞌë, zapatoje̱ su̱ñacaijë̱ꞌë, i̱ quë̱o. ");
INSERT INTO seyNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Cuiꞌne duruhue̱quë tsi̱ jujusiquëni dani huani je̱ojëꞌë, a̱ñuꞌu jai pa̱i tsiꞌsini sihuajë. ");
INSERT INTO seyNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Iquë yëꞌë mamaquë ju̱ꞌisiquëje̱ paꞌi paꞌisiquëpi cuiꞌnaëpi paꞌiji. Ne huesësiquëpi ti̱ꞌasiquë paꞌiji.’ Ja̱je cani sihuaquëna, jaiye a̱o ne huëohuë. ");
INSERT INTO seyNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ja̱je yoꞌojëna, i̱ mamaquë duꞌru aquëpi dajiꞌi, coꞌamaña ne hue̱ꞌña paꞌiquëpi. Huëꞌe jaꞌye ti̱ꞌaquë, asapi musica yoꞌoye cuiꞌne pairaye. ");
INSERT INTO seyNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Asani po̱sëohuaꞌi aquëre soini se̱jiꞌi. I̱quere ja̱je yoꞌoyeꞌni ja̱ro, caquëna. ");
INSERT INTO seyNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tsi̱ po̱sëpi i̱te capi: ‘Mëꞌë yoꞌjeipi dajiꞌi. Ja̱je daquëna, mëꞌë jaꞌquëpi hue̱quë tsi̱ni huaijë̱ꞌë jujusiquëni cua̱ñepi, i̱ huajëquëpi cuiꞌne deꞌoye ti̱tasi doꞌi caquë.’ ");
INSERT INTO seyNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ja̱je quëaquëna, majaꞌyëpi pë̱i cueꞌyoni huëꞌe cacaye coequëna, pëca jaꞌquë etani i̱te huëꞌena cacani ñajëꞌë caquë ai se̱jiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Se̱ina, i̱pi pëca jaꞌquëre capi: ‘Tsoe mëꞌëpi asayë, mëꞌëre yëꞌë necai paꞌiye, ti jo̱sa coeye peoyerepa. Ja̱je paꞌiquëtaꞌare teꞌe ñamareje̱ yëꞌë cajeohuaꞌi ja̱ꞌre co̱ni fiesta nejaꞌquëre i̱siye pa̱huë, mëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ja̱je paꞌiquëtaꞌare yure iquë mëꞌë mamaquë mëꞌë curiquë coꞌa nomiohuaꞌini yoꞌoquë neja saosiquëpi ti̱taëna, sihuaquë duruhue̱quë tsi̱ jujusiquëre huani je̱oni yoꞌoyë ñañë.’ ");
INSERT INTO seyNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Caquëna, pëca jaꞌquëpi i̱te capi: ‘Yëꞌë mamaquë mëꞌë cato siꞌanë yëꞌë ja̱ꞌre co̱ni paꞌiyë. Ja̱je paꞌina, siꞌaye yëꞌë paye mëꞌë coꞌamañaꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ja̱je paꞌina, yure nuñerepa fiesta neñe paꞌiji, sihuajë. Mëꞌë yoꞌjei ju̱ꞌisiquëje̱ paꞌi paꞌisiquëpi cuiꞌnaëpi paꞌi doꞌire. Ne huesësiquë paꞌisiquëni yure ti̱ꞌasi doꞌire.’ Ja̱je yoꞌoyë.” ");
INSERT INTO seyNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesupi capi, i̱ yeꞌyacohuaꞌire: “Paꞌiji, teꞌe ë̱më coꞌamaña paquëpi ñacaiquëre paquë. Ja̱je paꞌini sani quëahuë, coꞌamaña paquëna. Mëꞌë coꞌamaña ñacaiquëpi coꞌaye yoꞌoquë saoji, asahuë cajë. ");
INSERT INTO seyNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Quëarena, asani ëjaëpi i̱te soini capi: ‘¿I̱quere mëꞌë yoꞌoquëna, yëꞌëre quëayeꞌni? Dajë̱ꞌë, mëꞌë coꞌamaña neseꞌe toyaseꞌere ñasiꞌi, mëꞌë yëꞌëre necaiquë paꞌiye peoji.’ ");
INSERT INTO seyNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ja̱ maca coꞌamaña ñacaiquëpi ai cuasa huëopi: ‘¿Me nejaꞌquë aꞌni, yure yëꞌë ëjaëpi coꞌamaña neñe peoyerepa eto huesoru? Tutuje̱ peoyë, yeja neni ta̱ñeje. Cuiꞌne huajëyaꞌji yecohuaꞌini peoyë i̱sijë̱ꞌë caquë se̱niroja̱iñeje caꞌrayë’ cuasapi. ");
INSERT INTO seyNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Cuasani capi: Tsoe cuasahuë. Ja̱je yoꞌosiꞌi, yëꞌë coꞌamaña neñe peoquë paꞌina, i̱ohuaꞌi huëꞌena pëpaja̱ꞌcohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Cani ja̱ maca soipi teꞌohuaꞌiseꞌere, i̱ ëjaë doꞌi pacohuaꞌire, duꞌru aquëni se̱jiꞌi: ‘¿Je jaꞌye yëꞌë ëjaëre doꞌi paquë aꞌni?’ ");
INSERT INTO seyNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Caquëna, sehuopi i̱pi: ‘Cien jai quë̱na huë̱a huiꞌyape i̱siye paꞌiji,’ caquë coꞌamaña ñacaiquëpi capi, i̱te: ‘Icoa, mëꞌë ja̱ꞌnë sa̱ijaꞌa doꞌi caquë toyasico, ja̱ote nejoni esa yecore toyajë̱ꞌë, coa cincuentaseꞌe.’ ");
INSERT INTO seyNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ja̱ jeteyoꞌje se̱jiꞌi, yequëre: ‘¿Cuiꞌne mëꞌë je jaꞌye doꞌi paquëꞌni?’ Caquëna, i̱pi capi: ‘Cien trigo topë̱a i̱siye paꞌiji,’ caquëna, capi: ‘Icoa, mëꞌë ja̱ꞌrë sa̱ijaꞌa doꞌi toyasico yecona esa toyajë̱ꞌë, coa ochenta topë̱aseꞌe.’ ");
INSERT INTO seyNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ja̱ maca ñapi, i̱ ëjaë ja̱ë coꞌaquë i̱ coꞌamaña ñacaiquëpi tsoe siꞌaye ne deꞌhuasiquëpi pajiꞌi. Ja̱je paꞌina, iye yeja acohuaꞌi ta̱ꞌñe asani yoꞌocohuaꞌi aꞌë, sehuosicohuaꞌi yoꞌoye jerepa yoꞌocohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ja̱je paꞌina, cayë, mësarute. Iye yeja coꞌamañapi i̱sijë yecohuaꞌini cajeohuaꞌire nejëꞌë. Ja̱je yoꞌojë saosicohuaꞌipi ti̱ꞌajëna, ti paꞌi hue̱ꞌñapi sihuaquë daijë̱ꞌë caquë Maijaꞌquëpi pëpaja̱ꞌquëre. ");
INSERT INTO seyNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Deꞌoyerepa aꞌri maña paꞌina, ñacaiquëpi cuiꞌne jaiye paꞌitoje̱ deꞌoyerepa ñacaiye paꞌiji. Ja̱je aꞌri mañare deꞌoye ñacaimaꞌpë pani, jaiyere paje̱ deꞌoye ñacaiye peoji. ");
INSERT INTO seyNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ja̱je paꞌina, mësarupi coa yeja coꞌamañare deꞌoye ñacaimaꞌpë coꞌaye yoꞌocohuaꞌi paꞌito, ¿nepi mësarute deꞌhue necohuaꞌi aꞌë cuasaja̱ꞌcohuaꞌi aꞌni, deꞌo coꞌamañare pare yoꞌoye paꞌito? ");
INSERT INTO seyNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Deꞌoye yecohuaꞌi tse̱re ñamaꞌpë yoꞌoto, ¿nepi i̱sija̱ꞌcohuaꞌi aꞌni, mësaru pa ja̱ꞌñe? ");
INSERT INTO seyNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ja̱je paꞌina, ëjaohuaꞌire necaiquë pani caya ëjaohuaꞌire necaiye peoji. Ja̱je yoꞌoquë pani yequëni coequë cuiꞌne yequëni oiye paꞌiji. Pa̱nitaꞌa yeque, yequëni deꞌoye sehuocai yequëni sa̱ñope caye paꞌiji. Ja̱je paꞌina, teꞌipi Maijaꞌquëre cuiꞌne curiquëre necaiye peoji.” ");
INSERT INTO seyNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariseo pa̱i curiquë ai yëcohuaꞌi sëte i̱ cayere asani Jesús coa caji cajë cueꞌcuehuë. ");
INSERT INTO seyNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ja̱ maca Jesupi capi, ja̱ohuaꞌire: “Mësaru aꞌë, pa̱i ña hue̱ꞌñaseꞌe deꞌocohuaꞌi aꞌë cajë yoꞌocohuaꞌi. Maijaꞌquë cato ñaji, mësaru joñoare, ja̱je yoꞌojëtaꞌare. Ja̱je paꞌina, pa̱i jaiye deꞌoye yoꞌoyë cajë paꞌiyere Maijaꞌquëpi coequë api. ");
INSERT INTO seyNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Juan paꞌi macaja̱ꞌa Moisés cua̱ñeseꞌe cuiꞌne Maijaꞌquë yequë muꞌse yoꞌo ja̱ꞌñere ca nëocohuaꞌi yeꞌyajëna, asahuë. Ja̱ maca yure quëa huëohuë, deꞌo cocare Maijaꞌquë cua̱ñe te̱ꞌtena cacayere. Ja̱je quëajëna, asajë cacañuꞌu cajë siꞌaohuaꞌi tutu yoꞌoyë. ");
INSERT INTO seyNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Maꞌtëmo cuiꞌne yeja caraja̱iñe paꞌiji. Ja̱je paꞌiquëtaꞌare Maijaꞌquë coca cato caraja̱iñe peoyerepa. Ti̱ꞌasipi, i̱o cayeje̱. ");
INSERT INTO seyNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ja̱je paꞌina, ë̱më huejasiquëpi nëjore je̱oni cuiꞌne yecona se huejani, deꞌoye yoꞌoye pa̱ji. Cuiꞌne ë̱mëre je̱ocosiconi yequëpi huejani cuiꞌne coꞌaye yoꞌoji. ");
INSERT INTO seyNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Pajiꞌi, teꞌi ë̱më jaiye paquë siꞌanë deꞌo ca̱ña cuiꞌne jai doꞌire juꞌiquë cuiꞌne siꞌa muꞌseña fiesta nequë deꞌoyerepa yoꞌoquë paꞌiquë. ");
INSERT INTO seyNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ja̱je paꞌiquë paꞌina, cuiꞌne Lázaro ca̱ꞌmi quëꞌipi teaye yoꞌoquë paꞌiquëje̱ pajiꞌi. Ja̱je paꞌipi jaiye coꞌamaña paquë huëꞌe eta saꞌrore ñujiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ja̱je iquë teaye paꞌi macapi a̱o ëa ju̱ꞌi a̱o a̱i saihuë to̱meñere a̱tiꞌñerepa nëina, ñapi. Cuiꞌne i̱ aꞌsire joꞌyaque daijë neꞌnejëna, ñujiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ja̱je paꞌiquëpi teaye paꞌi maca ju̱jiꞌi. Ju̱quëna, hui̱ñaohuaꞌipi sahuë, maꞌtëmona Abraham ja̱ꞌre co̱ni paꞌija̱ꞌquëre. Ja̱je cuiꞌne jaiye paquëje̱ ju̱jiꞌi. Ju̱quëna, ta̱huë. ");
INSERT INTO seyNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Jaiye coꞌamaña paquëpi ju̱ni sajiꞌi, ju̱ꞌisicohuaꞌi ai yoꞌo hue̱ꞌñana. Ja̱rore papi ñapi, Abrahamre cuiꞌne Lázarore. ");
INSERT INTO seyNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ja̱ maca ñani cuipi: ‘Jaꞌquë Abraham, yëꞌëre oi ñajëꞌë. Ai yoꞌoyë. Jëjo saojë̱ꞌë, Lázarore ocore i̱ moño sa̱ꞌnihuëna neni dani sësëye yëꞌë tse̱meñona ne huasoja̱quë. Ai yoꞌoyë, yëꞌë toaseꞌepi paꞌina.’ ");
INSERT INTO seyNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ja̱je caquëna, Abrahampi capi i̱te: ‘Tsihuaꞌë cuasajë̱ꞌë mëꞌë deꞌoye paꞌiseꞌere ja̱ yëꞌtaꞌa mëꞌë huajëquë paꞌinë, cuiꞌne iquë Lázaropi ai coꞌaye pajiꞌi, ja̱ro paꞌi maca. Ja̱je paꞌisiquëpi yure i̱pi deꞌoye paꞌiji, i̱ñore. Cuiꞌne mëꞌëpi ai yoꞌoyë. ");
INSERT INTO seyNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Cuiꞌne ja̱je siꞌaye iye mëꞌë yoꞌoseꞌe paꞌitoje̱ paꞌiji, cuiꞌne jai huaꞌque të̱ꞌtëpaje̱, yëquë tëto saiye peoyerepa cuiꞌne mëꞌëje i̱ñona tëto daiye peoye. Ja̱je paꞌina, i̱ño paꞌicohuaꞌi ja̱ro tëto saiye peoji, cuiꞌne ja̱ro acohuaꞌije̱ i̱ño daiye peoji.’ ");
INSERT INTO seyNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ja̱ maca jaiye paquë paꞌisiquëpi capi: ‘Ja̱je paꞌito jaꞌquë Abraham mëꞌëre se̱ñë, Lázarore jëjo saojë̱ꞌë, yëꞌë jaꞌquë huëꞌena. ");
INSERT INTO seyNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ja̱rote cinco yoꞌje tsi̱re payë. Sani quëacaijë̱ꞌë, i̱ño yëꞌë ai yoꞌo hue̱ꞌñana daimaꞌpë caquë.’ ");
INSERT INTO seyNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ja̱je caquëna, Abrahampi capi, i̱te: ‘Ja̱ohuaꞌi cato payë, Moisés cua̱ñeseꞌe cuiꞌne yecohuaꞌi Maijaꞌquëre quëacaicohuaꞌi toyaseꞌere, ja̱re ñani sehuoja̱jë.’ ");
INSERT INTO seyNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ja̱je caquëna, jaiye paquë paꞌisiquëpi sehuopi: ‘Ja̱je paꞌitoje̱ jaꞌquë Abraham sehuoye pa̱ñë. Ju̱ꞌisicohuaꞌi aquëpi sani quëatotaꞌa ja̱ꞌnë paꞌiseꞌe je̱oni po̱nëjaꞌcohuaꞌi paꞌini.’ ");
INSERT INTO seyNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ja̱je caquëna, Abrahampi capi, i̱te: ‘Moisés cuiꞌne Maijaꞌquëre quëacaicohuaꞌi caseꞌere sehuoye coeni, me ju̱ꞌisiquëpi huëtuje̱ sehuoyeꞌni’.” ");
INSERT INTO seyNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesupi capi, I̱ yeꞌyacohuaꞌire: “Pa̱i coꞌaye neñe caraja̱iñe peoja̱ꞌcoa. Ja̱je paꞌiquëtaꞌare coꞌayere paꞌiquëpi yecohuaꞌire se yeꞌyaquëna, coꞌaye ne doꞌire teayerepa paꞌija̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ja̱je paꞌina, tsi̱re coꞌaye yeꞌyamaꞌnë, ja̱je paꞌire ñaje tëcana quë̱na pëpi sëani jairana je̱o dëoto ai jerepa deꞌoꞌñe paꞌio. ");
INSERT INTO seyNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Deꞌhua ñajëꞌë. Mëꞌë yoꞌjeipi mëꞌëre coꞌaye yoꞌosiquë paꞌito yoꞌomaꞌë quëajë̱ꞌë cuiꞌne ja̱ꞌrë yoꞌoseꞌere je̱oni po̱nëna i̱ yoꞌoseꞌere sa̱i deꞌhuacaijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Cuiꞌne mëꞌëni teꞌe muꞌsere siete paꞌye coꞌaye yoꞌosiquë pani, cuiꞌne siete paꞌye dai caye paꞌiji: ‘Ti̱jupë coꞌaye yoꞌoye pa̱siꞌi.’ Ja̱je caquëna, i̱ coꞌaye yoꞌoseꞌere sa̱i deꞌhuacaiye paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","I̱te yeꞌyecohuaꞌipi cahuë, Ëjaëre: I̱sijë̱ꞌë yëquëre ai nuñerepa neñe paꞌiji cuasayere. ");
INSERT INTO seyNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Cajëna, Ëjaëpi sehuopi ja̱ohuaꞌire: “Mësarupi neñe paꞌiji cuasayere aꞌri maña mostaza ca̱je paꞌye pacohuaꞌi pani cayë, iye so̱quëre iye macapi etani jaira jopore pare sa nëcajë̱ꞌë. Ca maca asani sati̱ꞌñe paꞌio. ");
INSERT INTO seyNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Mësarupi coꞌamaña necaiquëre pacohuaꞌini tsio coꞌamaña ne tëjini pa̱nitaꞌa hue̱quëre ña tëjini coꞌiquëna, ¿cacohuaꞌi aꞌni, ‘da sani jaꞌrujë̱ꞌë, a̱i a̱ijaꞌquë?’ ");
INSERT INTO seyNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ja̱je camaꞌpë coa ai jerepa cayë: ‘A̲ore cuaꞌcojë̱ꞌë, neato a̱i ja̱ꞌñere, yëꞌë a̱o a̱i huëosi maca deꞌoye a̱o ja̱ꞌñere cuiꞌñajëꞌë, yëꞌë a̱ni tëjisi jeteyoꞌje mëꞌëje a̱i cuiꞌne u̱cuja̱ꞌquë.’ ");
INSERT INTO seyNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ja̱je cua̱ñeseꞌere yoꞌoquëna, necaire pahuë deꞌoji cajë pëpaye peoji joꞌyaëpi cua̱ñeseꞌere necaito. ¿Me deꞌoji cayeꞌni, joꞌyaëpi cua̱ñeseꞌere neto? ");
INSERT INTO seyNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ja̱je cuiꞌne paꞌiji, mësaruje̱. Ja̱je paꞌina, Maijaꞌquë cua̱ñeseꞌere siꞌaye nesicohuaꞌi pani: ‘Coꞌa joꞌya mañaꞌë, mëꞌë nejëꞌë casi mañaseꞌe nehuë,’ caye paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesús ja̱ yëꞌtaꞌa Jerusalénna sai Samaria cuiꞌne Galilea yejaña tëto sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Saiquëpi aꞌri daripëna ti̱ꞌaquëna, diez ë̱mëohuaꞌi ja̱ꞌju dahuë ju̱ꞌicohuaꞌipi sa̱ñope ti̱ꞌahuë. Ti̱ꞌajëtaꞌa soꞌona nëcaja̱ni, ");
INSERT INTO seyNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","cuihuë: “¡Jesús, Yeꞌyaquë, yëquë mañare oijë̱ꞌë!” ");
INSERT INTO seyNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ja̱ maca Jesupi ñani ja̱ohuaꞌire capi: “Sani Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌina i̱ñojaijëꞌë.” Ja̱je caëna, ja̱ saijë i̱ohuaꞌi ju̱ꞌi dahuë peocohuaꞌi to̱me huesëhuë. ");
INSERT INTO seyNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ja̱ maca teꞌi ja̱ohuaꞌi aquëpi ju̱ꞌi dahuë peo hue̱ꞌña to̱mesiquë paꞌi ña jujani Maijaꞌquëni tutu yëꞌopi caquë sihuaquë coꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Coꞌini doꞌre jaꞌrupi Jesús ña hue̱ꞌñana cuiꞌne i̱ tsiapi yejare pana në meni Maijaꞌquëre deꞌoji caquë sihuapi. Iquë ë̱më i̱ti sihuasiquë Samaria yeja aquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ja̱ maca Jesupi capi, i̱te: “¿Mësaru diez paꞌiohuaꞌi paꞌimaꞌpë pate, i̱ti ju̱ꞌicohuaꞌi? ¿Yecohuaꞌi nueve jerore paꞌiyeꞌni? ");
INSERT INTO seyNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Iquë yequë yeja aquëseꞌe Maijaꞌquëre sihuasiꞌi caquë coꞌisiquë paꞌiquë?” ");
INSERT INTO seyNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ja̱je cani i̱te capi: “Huëni saijë̱ꞌë. Jujuquë api, mëꞌë cuasani yoꞌo doꞌipi coꞌyasiquë sëte.” ");
INSERT INTO seyNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fariseo pa̱ipi Jesure se̱iꞌë: ¿Je yëhua Maijaꞌquë te̱ꞌte ayepi ti̱ꞌajaꞌcoaꞌni? Ja̱je se̱jëna, i̱pi sehuopi: “Maijaꞌquë cua̱ñe te̱ꞌte ayere ti̱ñarepa ñañe peoji, coꞌamaña ñañeje paꞌye. ");
INSERT INTO seyNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","‘I̱ñore tsoe paꞌiji’ pa̱nitaꞌa ‘jetore paꞌiji’ caye peoji. Ja̱je paꞌina, tsoe Maijaꞌquë cua̱ñe te̱ꞌte ayere mësaru joponi paꞌiji, yure.” ");
INSERT INTO seyNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ja̱je paꞌina, i̱re yeꞌyecohuaꞌire capi: “Ti̱ꞌajaꞌcoa, coꞌa muꞌseña Pa̱i Mamaquë yoꞌoquëna, ña ëa muꞌseña. Ja̱je ña ëaquëtaꞌare ñañe pa̱jaꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ja̱je ña ëaquëna, paꞌijëna, caja̱ꞌcohuaꞌi aꞌë: ‘I̱ñore paꞌiji’ pa̱nitaꞌa ‘jetore paꞌiji’. Ja̱je catoje̱ saimaꞌpë, cuiꞌne tuimaꞌpë paꞌijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Maꞌtëmopi mujuë yeꞌhueyeje̱ paꞌye pasipi. Pa̱i Mamaquë ti̱ta muꞌse cato asa tayoye peoja̱ꞌcoa. ");
INSERT INTO seyNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ja̱je paꞌiquëtaꞌare duꞌru macarepa ai ai yoꞌoye paꞌiji. Yure paꞌiji, yure paꞌi pa̱ipi yëꞌëre coejëna. ");
INSERT INTO seyNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noé paꞌi muꞌseña yoꞌojë paꞌiseꞌeje̱ paꞌye cuiꞌne paꞌija̱ꞌcoa, Pa̱i Mamaquë daija̱ꞌa muꞌseñaje. ");
INSERT INTO seyNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ja̱ muꞌseña je̱ꞌquë a̱o a̱ijë cuiꞌne u̱cujë, huejajë cuiꞌne mamajëre huejojë yoꞌohuë. Ja̱je yoꞌojëna, Noé jai yohuëna cacapi. Cacasi maca, jai coꞌje ti̱ꞌaëna, ja̱ohuaꞌi siꞌaohuaꞌi coꞌje ju̱juhuë. ");
INSERT INTO seyNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ja̱je cuiꞌne Lot paꞌi muꞌseñaje yoꞌohuë: A̲o a̱ijë cuiꞌne co̱no u̱cujë huerojë cuiꞌne yecohuaꞌina se i̱sijë, coꞌamaña ta̱jë cuiꞌne huë̱ꞌña nejë paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ja̱je yoꞌojë paꞌijëna, Lot Sodomapi etani sajiꞌi. Saisi maca maꞌtëmopi oco to̱meñeje paꞌye toapi to̱mequë siꞌaohuaꞌire huani je̱api, Sodoma pa̱ire. ");
INSERT INTO seyNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ja̱je cuiꞌne paꞌye pasipi, Pa̱i Mamaquë ñaijaꞌa muꞌseñaje. ");
INSERT INTO seyNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ja̱ coꞌa muꞌseña ti̱ꞌaëna, huëꞌe hueꞌsere paꞌijëna, coꞌamañapi huëꞌe sa̱ꞌnahuëre paꞌito i̱jañuꞌu cajë yoꞌomaꞌpë paꞌijë̱ꞌë. Cuiꞌne yecohuaꞌipi tsiore paꞌicohuaꞌi pani coꞌimaꞌpë paꞌijë̱ꞌë, huëꞌena. ");
INSERT INTO seyNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Deꞌhua cuasajë̱ꞌë, Lot nëjo yoꞌoseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ja̱je paꞌina, coꞌye i̱ paꞌiyere ai cuasaquë cato siꞌaye ne huesëye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ja̱je paꞌina, cayë. Ja̱ ñami ca̱i saihuëna cayahuaꞌi ca̱icohuaꞌi paꞌito teꞌire saquë yequëni je̱o saiye paꞌija̱ꞌcoa. ");
INSERT INTO seyNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Cuiꞌne caya nomiohuaꞌi teꞌe toacohuaꞌini teꞌore saquë cuiꞌne yeconi je̱o saiye paꞌija̱ꞌcoa. ");
INSERT INTO seyNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ja̱je cuiꞌne caya ë̱mëohuaꞌi tsiore paꞌijëna, teꞌire saquëna, cuiꞌne teꞌi je̱o saisiquë paꞌija̱ꞌquë api.” ");
INSERT INTO seyNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ja̱je caquëna, iyere asani se̱teña: “¿Jerona iye yoꞌo ja̱ꞌñe aꞌni, Ëjaë?” Cajëna, i̱pi capi: “Ju̱ꞌisiquë u̱i hue̱ꞌña pëꞌpëri tsiꞌsiyeje̱ paꞌye tsiꞌsija̱ꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Siꞌanë Maijaꞌquëre se̱jë paꞌiye paꞌiji, yoꞌo jujaye peoye caquë Jesús pa̱i yoꞌoye ayena ti̱ña caquë ñeje, yeꞌyapi. ");
INSERT INTO seyNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Yeꞌyaquë capi: “Paꞌiji, pa̱i daripë pa̱i yoꞌoye ñaquë, Maijaꞌquëre caꞌramaꞌquëpi, cuiꞌne yecohuaꞌireje̱ oimaꞌquëpi. ");
INSERT INTO seyNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Cuiꞌne ja̱re ja̱ daripëre pacoꞌë, huaꞌjeo. Ja̱opi pa̱i yoꞌoye ñaquëna, i̱ote sa̱ñope yoꞌoquëni quëaona ca deꞌhuacaija̱quë caco siꞌanëpi sacoꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ja̱je saio yoꞌocona, pa̱i yoꞌoye ñaquëpi coepi. Coesiquëtaꞌa jeteyoꞌje cuasapi: ‘Maijaꞌquëre caꞌramaꞌquëje̱ cuiꞌne pa̱ireje̱ oimaꞌquëpi. ");
INSERT INTO seyNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Co̱casiꞌi huaꞌjeore, jo̱sa siꞌanë daio yëꞌë yequere cuasaquëna, camaꞌo paꞌija̱ꞌcore,’ cuasapi.” ");
INSERT INTO seyNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ja̱je capi, iquë pa̱i yoꞌoye ñaquë coꞌaquë. Ja̱je paꞌito Jesús capi: ");
INSERT INTO seyNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","“¿Maijaꞌquëre muꞌseñapi cuiꞌne ñamiñapi se̱cohuaꞌire i̱ joꞌya nesicohuaꞌire co̱caiye pa̱jaꞌquë aë? ¿Tsoe utejë̱ꞌë, caquë aë? ");
INSERT INTO seyNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Pa̱ni. Ja̱je paꞌina, cayë, ti tsoe nëiñe peoye co̱caija̱ꞌquë api, Maijaꞌquë. Ja̱je paꞌiquëtaꞌare ¿yëꞌë iye yejana dai maca, deꞌhue yëꞌëre necaiquë api cuasacohuaꞌi paꞌijëna, ti̱ꞌajaꞌquë aꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Pa̱i yoꞌoyeje̱ paꞌye neni Jesús quëapi, deꞌocohuaꞌi aꞌë cuasajë yecohuaꞌire coꞌacohuaꞌi aꞌë cajë coecohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Quëa huëoquë capi: “Caya ë̱mëohuaꞌi Maijaꞌquëre se̱ huëꞌena saëꞌë, se̱ñuꞌu cajë. Teꞌi ja̱ohuaꞌi aquëpi fariseo paꞌiji, cuiꞌne yequëpi paꞌi doꞌi curiquë se̱quë pajiꞌi, pa̱i ëjaëre necaiquë. ");
INSERT INTO seyNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Paꞌina, fariseopi coa nëcaquë se̱jiꞌi, ñeje: ‘I̱na, jaꞌquë mëꞌëre sihuayë, yëꞌëre cato ja̱ohuaꞌi coꞌamaña ñacohuaꞌi, cuiꞌne coꞌacohuaꞌi cuiꞌne nomiohuaꞌire coa yoꞌocohuaꞌije̱ paꞌi peoyë. Cuiꞌne ja̱ë paꞌi doꞌi se̱quëje̱ paꞌi ti peoyë. ");
INSERT INTO seyNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Cuiꞌne teꞌe semanare cayaye a̱o a̱imaꞌquëpi se̱i cuiꞌne yëꞌë yoꞌoquë curiquë neñeje Maijaꞌquë huëꞌena diez paꞌye neni teꞌore i̱siquë aꞌë, deꞌhue.’ ");
INSERT INTO seyNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ja̱je se̱ina, paꞌi doꞌire se̱quëpi soꞌo macana pëani ñaco ca̱ mañaje maꞌtëmona se mëani ñamaꞌë coa ai jerepa coti saihuëna tëꞌcaquë ñeje caquë se̱jiꞌi: ‘I̱na, yëꞌë Jaꞌquë yëꞌëre oijë̱ꞌë, yëꞌë maca ai coꞌaquë aꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ja̱je paꞌina, cayë, mësarute. Iquë paꞌi doꞌire curiquë se̱quë cato Maijaꞌquëna i̱ coꞌaquë paꞌiye quëa to̱ni Maijaꞌquë ja̱ꞌre paꞌi sihuaquë coꞌipi. Ja̱je coꞌiquëtaꞌare fariseo cato ti sihuamaꞌë pajiꞌi. Ja̱je paꞌina, coꞌye yëꞌë jerepa paꞌi aꞌë cuasacohuaꞌire cato coa ai jerepa meñe neñe paꞌiji. Ja̱je paꞌiquëtaꞌare yëꞌë teaye paꞌi aꞌë cuasaquëni ai jerepa paꞌire neñe paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Jesús quëꞌrona tsi̱re dahuë, papija̱quë cajë. Ja̱je yoꞌojëna, i̱ yeꞌyacohuaꞌipi ñani i̱ti tsi̱re dacohuaꞌire yoꞌomaꞌpë paꞌijë̱ꞌë ca huëohuë. ");
INSERT INTO seyNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ja̱je cajëna, Jesús ja̱ohuaꞌire soini capi: “Coa ñajëꞌë, ë̱semaꞌpë tsi̱re, i̱ohuaꞌiseꞌe daija̱jë yëꞌë quëꞌrona. Maijaꞌquë quëꞌro ja̱ohuaꞌije̱ paꞌiohuaꞌiseꞌe cacaye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ja̱je paꞌina, nuñerepa cayë, mësarute. Tsi̱ deꞌoji cajë yëyeje̱ paꞌye yoꞌomaꞌcohuaꞌi pani ti cacaye peoji, Maijaꞌquë cua̱ñe hue̱ꞌña.” ");
INSERT INTO seyNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Pa̱i ëjaohuaꞌi aquëpi se̱jiꞌi, Jesure: “Deꞌo yeꞌyaquë, ¿me yoꞌoni ti pani huesëye ti̱ꞌajaꞌquë aꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesupi i̱te capi: “¿Me yoꞌoquë yëꞌëre deꞌoquë caquëꞌni? Peoji, teꞌije̱ deꞌoquë. Coa teꞌi Maijaꞌquëseꞌe deꞌoquë paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Asaquë aꞌë, Maijaꞌquë cua̱ñeseꞌe: ‘Nomiore yoꞌomaꞌë nëjore peoni, pa̱ire huani je̱omaꞌë, coꞌamaña ñamaꞌë, coa cosomaꞌë, cuiꞌne ëjaohuaꞌire ñajë oijë̱ꞌë, më jaꞌquëre cuiꞌne më jaꞌcore.’ Ja̱re mëꞌëpi asaë.” ");
INSERT INTO seyNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ja̱je caquëna, i̱ti se̱siquëpi capi, i̱te: “Siꞌanë iye tsihuaꞌë paꞌinëpi deꞌoye sehuoquë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ja̱je caquëna, Jesupi asani i̱te capi: “Ja̱ yëꞌtaꞌa teꞌo carapi, mëꞌëre. Siꞌaye mëꞌë payere i̱sijë̱ꞌë, peocohuaꞌini. Ja̱je mëꞌë yoꞌonitaꞌa Maꞌtëmore coꞌamaña paye paꞌiji. Ja̱ jeteyoꞌje dani tuijë̱ꞌë, yëꞌëre.” ");
INSERT INTO seyNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ja̱je caquëna, iyere asani ai oi, jaiye coꞌamaña paquë sëte. ");
INSERT INTO seyNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ja̱je oina, ñani Jesús capi: “Airepa jëaye paꞌiji, jaiye coꞌamaña pacohuaꞌipi Maijaꞌquë cua̱ñe te̱ꞌtena cacaye. ");
INSERT INTO seyNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Camellore miu ñaca cojeja̱ꞌa etoja̱iñe ti peoji. Ja̱ jëaye se̱ña maca jëaji, coꞌamaña pacohuaꞌipi Maijaꞌquë te̱ꞌtena cacaye.” ");
INSERT INTO seyNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ja̱je caquëna, i̱ti asasicohuaꞌipi cahuë: “Ja̱je paꞌito ¿nepi huasosicohuaꞌi paꞌija̱ꞌcohuaꞌi aꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Cajëna, Jesupi capi, ja̱ohuaꞌire: “Ja̱je paꞌina, pa̱i ne ti̱ꞌañe peoyere, Maijaꞌquëseꞌe ne ti̱ꞌañe paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Caquëna, Pedropi capi: “Ëjaë, yëquë paseꞌe siꞌaye je̱ohuë, mëꞌëni tuñuꞌu cajë.” ");
INSERT INTO seyNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Caquëna i̱pi sehuopi: “Nuñerepa cayë. Pa̱ipi Maijaꞌquë te̱ꞌte doꞌire i̱ huëꞌe, jaꞌquëohuaꞌire, aꞌyëohuaꞌire, nëjore, mamajëre je̱osiquë pani, ");
INSERT INTO seyNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","yequë yejana paꞌiye huëo maca ti paꞌiyere ti̱ꞌajaꞌquë api.” ");
INSERT INTO seyNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús pa̱i peo hue̱ꞌñana i̱ yeꞌyacohuaꞌire soini, capi: “Yure sañuꞌu, Jerusalénna. Ja̱rona siꞌaye ti̱ꞌajaꞌcoa, Pa̱i Mamaquëre yoꞌo ja̱ꞌñere Maijaꞌquëre quëacaicohuaꞌi toyajë paꞌiseꞌe. ");
INSERT INTO seyNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ja̱rona yëꞌëre i̱sija̱ꞌcohuaꞌi aꞌë, judío pa̱i peocohuaꞌina. I̱sirena, cueꞌcuejë yoꞌoja̱ꞌcohuaꞌi aꞌë yëꞌëre coꞌaye cajë, cuiꞌne copi tseꞌseja̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Tëꞌca tëjini huani je̱ojaꞌcohuaꞌi aꞌë. Ja̱je yoꞌosicohuaꞌitaꞌare toaso̱ muꞌseña paꞌi maca huëija̱ꞌquë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ja̱je caquëna, ja̱ohuaꞌi coa huesë asahuë, i̱quere caquëꞌni cuasajë. I̱pi ti̱ña asaye ë̱sequëna. ");
INSERT INTO seyNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesupi Jericó daripë quë̱no macare paꞌina, teꞌi ñamaꞌquëpi maꞌa yëꞌquë macare ñuꞌi curiquë da saicohuaꞌire se̱jiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Se̱quëpi jai pa̱i saijë cajëna, asani se̱jiꞌi, i̱quere ja̱je yoꞌojë cayeꞌni caquë. ");
INSERT INTO seyNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Se̱ina, i̱te quëahuë. Ja̱roja̱ꞌa Jesús Nazaret aquëpi daina, yoꞌojë cayë. ");
INSERT INTO seyNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Cajëna, ja̱ maca asani cuipi: “Jesús, David mamaquë yëꞌëre oijë̱ꞌë. Ai yoꞌoyë.” ");
INSERT INTO seyNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ja̱je cuiquëna, yecohuaꞌipi duꞌru saicohuaꞌipi i̱te cahuë, cuimaꞌë paꞌijë̱ꞌë. Ja̱ cajëtaꞌare i̱pi ai jerepa ja̱ yëꞌtaꞌapi cuipi: “David mamaquë yëꞌëre oijë̱ꞌë. ¡Ai yoꞌoyë!” ");
INSERT INTO seyNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Caquëna, asani Jesús nëcaja̱ni, quërëja̱ni dajë̱ꞌë caquë jëjo saopi, teꞌire. Dasi maca i̱te se̱jiꞌi: ");
INSERT INTO seyNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“¿Me nejaquë cuasaquëꞌni, mëꞌë yëꞌëre?” Caquëna, ñamaꞌquëpi sehuopi: “Ëjaë, ñaco ca̱re deꞌhuacaijë̱ꞌë. Ñasiꞌi, yëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Caquëna, Jesupi capi, i̱te: “¡Ñaquë paꞌijë̱ꞌë! Mëꞌë nequë api cuasaquë ca doꞌipi.” ");
INSERT INTO seyNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ja̱je ca macapi, tsoe ñaquë pajiꞌi, ñamaꞌquë paꞌisiquëpi. Ja̱ maca Jesure tujiꞌi, Maijaꞌquëre sihuaquë. Cuiꞌne siꞌaye iye yoꞌoye ñasicohuaꞌije̱ Maijaꞌquëre ai sihuahuë. ");
INSERT INTO seyNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ja̱ maca Jericó daripëna Jesús cacani tëto saina, ");
INSERT INTO seyNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","cuiꞌne ja̱rote jaiye coꞌamaña paquë Zaqueo hueꞌequëje̱ pajiꞌi, curiquë paꞌi doꞌi se̱cohuaꞌi ëjaëpi. ");
INSERT INTO seyNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ja̱ë cato Jesure ñañe yëquë pajiꞌi. Ja̱je yëquëtaꞌa me ñaquëꞌni pa̱i jaꞌi maña paꞌijëna, Zaqueo nëhuiquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ja̱je paꞌipi duꞌru huëꞌhuëni so̱quë yëna mëjiꞌi, Jesús jaꞌye tëto saija̱ꞌtona ñani. ");
INSERT INTO seyNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ja̱ maca Jesús ja̱roja̱ꞌa saiquëpi ñani Zaqueore capi: “Esa cajejë̱ꞌë, yure mëꞌë huëꞌena sani pëaja̱ꞌquëpi saiyë.” ");
INSERT INTO seyNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ja̱ maca Zaqueo esa cajeni sihuaquë Jesure i̱ huëꞌena sai sapi. ");
INSERT INTO seyNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ja̱ maca iyere yecohuaꞌi ñani siꞌahuaꞌi deꞌoye yoꞌomaꞌajiꞌi cahuë, Jesupi coꞌaye yoꞌoquë huëꞌena pëasiꞌi caquë, saquëna. ");
INSERT INTO seyNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ja̱ maca Zaqueopi huëni nëcani capi, Ëjaëre: “I̱na Ëjaë, yëꞌë paye jopore paja̱ꞌa i̱sisiꞌi coꞌamaña peocohuaꞌire, cuiꞌne yëꞌë coa cosoquë jerepa neseꞌe paꞌito coꞌyosiꞌi cuatro paꞌye jerepa yëꞌë se jiosiquëre.” ");
INSERT INTO seyNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ja̱je caquëna, Jesupi capi, i̱te: “Iye muꞌse ti̱tapi iye huëꞌe huasoye cuiꞌne iye ë̱më cato Abraham tsëcapë aquë api. ");
INSERT INTO seyNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ja̱je paꞌina, Pa̱i Mamaquë dajiꞌi, ne huesësicohuaꞌire coꞌequë huasosiꞌi caquë.” ");
INSERT INTO seyNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ja̱ yëꞌtaꞌa Jesús cayere pa̱i asajë cuasahuë, yure Maijaꞌquë cua̱ñe te̱ꞌte ti̱ꞌajaꞌcoa cajë. Ja̱je cuasahuë, Jesupi Jerusalén jaꞌyere paꞌi doꞌire ñajë. Ja̱je cuasajëna, i̱pi pa̱i yoꞌoyeje̱ paꞌye caquë quëa huëopi. ");
INSERT INTO seyNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ja̱ maca capi: “Pajiꞌi, teꞌe pa̱i deꞌo tsëcapë aquë. Ja̱ëpi soꞌo yejana sajiꞌi, pa̱i ëjaëre nesi maca, pa̱i ëjaë deꞌoni cuiꞌnaëpi coꞌi co̱siꞌi caquë. ");
INSERT INTO seyNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ja̱ yëꞌtaꞌa saimaꞌnë, diez paꞌiohuaꞌire i̱ joꞌya acohuaꞌini soini, pa̱i ñapere i̱sipi jai doꞌi curiquë të̱ꞌñare teꞌe të̱ꞌñaseꞌe i̱siquë capi: ‘Iye curiquëpi se hueroni yeque jaiye nejëꞌë, yëꞌë coꞌi macaja̱ꞌa.’ ");
INSERT INTO seyNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ja̱je casiquëtaꞌare i̱ yeja paꞌi pa̱ipi i̱te coejë, i̱ saisi jeteyoꞌje jëjo saohuë, quëaja̱ꞌcohuaꞌipi: ‘Coeyë, mëꞌëre yëquë ëjaë deꞌoye’ cajë. ");
INSERT INTO seyNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ja̱je casicohuaꞌitaꞌare pa̱i ëjaë deꞌosiquëpi coꞌipi, i̱ yejana. Ti̱tani cua̱ñe saopi, i̱ curiquë i̱sisicohuaꞌire quërëja̱ijëꞌë caquë. Asasiꞌi, je jaꞌye pa̱i ñape ja̱ curiquëpi nereꞌni caquë. ");
INSERT INTO seyNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Soina, duꞌru macarepa ti̱taquëpi capi: ‘Ëjaë, mëꞌë curiquëpi diez paꞌye jerepa se ne co̱huë.’ ");
INSERT INTO seyNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Pa̱i ëjaëpi sehuopi: ‘Ai deꞌoji, mëꞌë deꞌo joꞌyaëꞌë. Mëꞌë aꞌri mañare deꞌoye ñacaisi doꞌire, mëꞌëre diez daripë̱a cua̱ñequëre neñë.’ ");
INSERT INTO seyNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Yequëpi dani capi: ‘Ëjaë, mëꞌë curiquëpi cinco paꞌye jerepa nehuë.’ ");
INSERT INTO seyNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Cuiꞌne iquëreje̱ sehuopi: ‘Mëꞌë cato cinco daripë̱a cua̱ñequë paꞌijë̱ꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ja̱ maca yequëpi dani capi: ‘Ëjaë, iye paꞌiji, mëꞌë curiquë pañuelo ca̱ꞌtipëna deani deꞌhuaseꞌe. ");
INSERT INTO seyNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mëꞌëpi pa̱ire oimaꞌë yoꞌoquë mëꞌë i̱si maꞌñere tsiꞌsoni, cuiꞌne mëꞌë ta̱ maꞌñere coa tëaquë, yoꞌoquëni caꞌraquë pa̱huë.’ ");
INSERT INTO seyNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Caquëna, pa̱i ëjaëpi capi: ‘Coꞌa joꞌyaë, ja̱re mëꞌë caseꞌepi i̱ñoji, mëꞌë coꞌaquë paꞌiye. Ja̱je yëꞌë pa̱ire oimaꞌë yoꞌoquëpi yëꞌë ne maꞌñere tsiꞌsoquë cuiꞌne yëꞌë ta̱ maꞌñere coa tëaquë yoꞌoye asaquë sëte. ");
INSERT INTO seyNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Me yoꞌoquë curiquë i̱sirena, i̱tipi ne doꞌire coꞌye sa̱i hue̱ꞌñana tëomaꞌë paquëꞌni, yëꞌë dani i̱ti mañaque nejaꞌquëtaꞌare huëꞌe ti̱tasi maca?’ ");
INSERT INTO seyNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ja̱je cani i̱ti maca paꞌicohuaꞌire capi: ‘Jiojë̱ꞌë, curi tëꞌquire. Jioni i̱sijë̱ꞌë, diez të̱ꞌña paquëna.’ ");
INSERT INTO seyNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Caquëna, ja̱ohuaꞌipi cahuë, i̱te: ‘¿Ëjaë, tsoe diez të̱ꞌña paquëre me ai jerepa i̱siyeꞌni?’ ");
INSERT INTO seyNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Cajëna, pa̱i ëjaëpi sehuopi: ‘Nuñerepa cayë, paquëni ai jerepa se i̱siye paꞌiji. Ja̱je paꞌina, cuiꞌne peoquëni coa ai jerepa se jio co̱ñe paꞌiji, siꞌaye i̱ payeje̱ peo hue̱ꞌñarepa. ");
INSERT INTO seyNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Cuiꞌne yecohuaꞌi yëꞌëre ëjaë deꞌoye coesicohuaꞌire quërëja̱ni i̱ñona dani yëꞌëque ñaquëna, huani je̱ajëꞌë,’ capi.” ");
INSERT INTO seyNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ja̱je iye se ca tëjini Jesús Jerusalénna sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tsoe Betfagé cuiꞌne Betania daripë̱a cuiꞌne Olivos hueꞌyosi cu̱tihuë̱a ti̱ꞌañe jaꞌi maca paꞌi i̱ yeꞌyacohuaꞌire cayaohuaꞌire jëjo saopi. ");
INSERT INTO seyNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ñeje caquë: “Ja̱ maca jaꞌye daripëna saijë̱ꞌë. Ti̱ꞌa maca ja̱rote paꞌija̱ꞌquë api, burro sëasiquëpi, pa̱ije ja̱ yëꞌtaꞌa tuimaꞌquëpi. Ti̱ꞌani joyeni dajë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Joyejëna, yecohuaꞌipi me nejaꞌquëni sayeꞌni se̱cohuaꞌi paꞌito, cajë̱ꞌë, Ëjaëpi yoꞌoye paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ja̱ maca i̱ yeꞌyacohuaꞌipi sani Jesús caseꞌeje̱ ti̱ꞌahuë. ");
INSERT INTO seyNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ti̱ꞌani burroni joyejëna i̱ti tse̱ acohuaꞌipi se̱iꞌë: “¿Me neñuꞌju joyeyeꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Cajëna, i̱ohuaꞌipi sehuohuë: “Ëjaëpi yoꞌoye paꞌiji, caëna, yoꞌoyë.” ");
INSERT INTO seyNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ja̱je quëani joyeni Jesús quëꞌrona sahuë. Sani ca̱ñapi burro jetena jajeni Jesure mëo ñohuë. ");
INSERT INTO seyNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ja̱ maca ñuꞌi sajiꞌi. Saina, pa̱i ca̱ñare i̱ saija̱ꞌa maꞌana jajehuë. ");
INSERT INTO seyNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Olivos cu̱tihuë perepë cajeye jaꞌi macare paꞌina, siꞌahuaꞌi i̱te asani tuicohuaꞌipi Maijaꞌquëre sihuajë cui huëohuë, pa̱i yoꞌo ti̱ꞌa maꞌñere yoꞌoquëna, ñasicohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ñeje cajë: “Deꞌoquëre papi pa̱i Ëjaë daiji, Maijaꞌquë jëjo daoquëre papi, deꞌoye paꞌiyere papi co̱ni. Ja̱je paꞌito sihuañuꞌu, i̱te maꞌtëmo acohuaꞌije̱ sihuajëna.” ");
INSERT INTO seyNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ja̱ maca fariseohuaꞌi pa̱i jopore co̱ni paꞌicohuaꞌipi cahuë, i̱te: “Yeꞌyaquë, mëꞌëre tuicohuaꞌire camaꞌpë cajë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ja̱je cajëna, Jesupi sehuopi: “Nuñerepa cayë. Icohuaꞌipi cuiye je̱ocohuaꞌi paꞌito quë̱na pë̱api cuija̱ꞌcoa.” ");
INSERT INTO seyNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ja̱ maca Jesús Jerusalén quë̱no maca ti̱ꞌaquë i̱ti daripëre ñani ojiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ñeje caquë: “¡Iye muꞌse mëꞌë deꞌhue asato yëꞌë i̱siye deꞌoraꞌpi. Mëꞌë deꞌoye paꞌiye ti̱ꞌaraꞌhuë, i̱siyere! Ja̱je paꞌiquëtaꞌare yure cato yahueseꞌe paꞌiji. Ja̱je paꞌina, mëꞌë ña ti̱ꞌañe peoji. ");
INSERT INTO seyNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Coꞌa muꞌse ti̱ꞌajaꞌcoa, mëꞌëre. Mëꞌëre sa̱ñope yoꞌocohuaꞌipi quë̱na tëhuopaje̱ paꞌiore tëꞌyaja̱icohuaꞌi aꞌë. Ja̱je yoꞌoni coa siꞌa te̱ꞌñapi etaye peoja̱jë cajë yoꞌocohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ja̱je yoꞌojë yejana siꞌaye quë̱na pë̱a ne ta̱o o̱ajaꞌcohuaꞌi aꞌë, huani je̱ajaꞌcohuaꞌi aꞌë, mëꞌë mamajëre, huesë paꞌisi doꞌire Maijaꞌquë mëꞌëre doꞌi daisi maca.” ");
INSERT INTO seyNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ja̱ maca Jesús Maijaꞌquëre huëꞌena cacani i̱ti huëꞌena coꞌamaña i̱sijë cuiꞌne huerojë yoꞌocohuaꞌire peo hue̱ꞌñarepa eto saopi, hueꞌsena. ");
INSERT INTO seyNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Yoꞌoquë capi, ja̱ohuaꞌire: “Toyaseꞌe caji, ñeje: ‘Yëꞌë huëꞌe cato Maijaꞌquëre se̱ huëꞌe aꞌë.’ Ja̱je paꞌiotaꞌare mësaru cato, coꞌamaña ñaohuaꞌi tuꞌaro neni yoꞌoyë.” ");
INSERT INTO seyNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Siꞌa muꞌseña Jesús yeꞌyapi, Maijaꞌquëre se̱ huëꞌena. Ja̱je yeꞌyaquëna, Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌi cuiꞌne cua̱ñeseꞌe yeꞌyacohuaꞌi cuiꞌne pa̱i daripë ëjaohuaꞌije̱ me neni huani je̱ojaꞌcohuaꞌi aꞌni cuasajë coꞌehuë, i̱ti yoꞌo ja̱ꞌñere. ");
INSERT INTO seyNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ja̱je coꞌejëtaꞌa ti̱ꞌamaꞌpë paëꞌë, i̱te ne ja̱ꞌñere. Siꞌa pa̱i i̱seꞌere asajë cuiꞌne sehuojë yoꞌojëna, ñajë. ");
INSERT INTO seyNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Teꞌe muꞌse Jesús Maijaꞌquëre se̱ huëꞌere pa̱ire yeꞌyaquë cuiꞌne huaso cocare quëaquë paꞌina, ti̱tahuë, Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌi, cua̱ñeseꞌe yeꞌyacohuaꞌi cuiꞌne aiohuaꞌi co̱ni. ");
INSERT INTO seyNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ja̱ohuaꞌipi ti̱tani cahuë: “¿Quëajë̱ꞌë, i̱que tutupi cua̱ñequërepa paꞌi yoꞌoquëꞌni, iye? ¿I̱queipi iye cua̱ñe tutu i̱sina, yoꞌoquëꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Cajëna, ja̱ maca Jesupi ja̱ohuaꞌire capi: “Yëꞌëre cuiꞌne se̱siꞌi, mësarute. Sehuojë̱ꞌë, yëꞌë cato: ");
INSERT INTO seyNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Nepi cua̱ñereꞌni, Juan oco doquë paꞌi ja̱ꞌñe? ¿Maijaꞌquë pa̱nitaꞌa pa̱i?” ");
INSERT INTO seyNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Caquëna, sehuoye pa̱jë coa sa̱ꞌñe i̱ohuaꞌija̱ꞌa cahuë, ñeje: “¿Me caja̱ꞌcohuaꞌi aꞌni? Maipi Maijaꞌquëpi jëjo daopi cacohuaꞌi paꞌito i̱pi sehuoja̱ꞌquë paꞌini: ‘¿Ja̱je paꞌitaꞌare me yoꞌojë sehuoye pa̱reꞌni?’ ");
INSERT INTO seyNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Cuiꞌne maipi pa̱ipi cua̱ñesiquë pajiꞌi catoje̱, siꞌa pa̱i huëni maire quë̱na pë̱api je̱ajë huani je̱ajaꞌcohuaꞌi paꞌini, siꞌaohuaꞌi Juanre Maijaꞌquë coca quëaquërepa pajiꞌi cuasajë cahuë.” ");
INSERT INTO seyNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ja̱je cuasani cahuë: “Huesëyë. Ne saꞌapi Juanre oco doquë paꞌi ja̱ꞌñe cua̱ñehuë.” ");
INSERT INTO seyNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Cajëna, Jesuje̱ capi, ja̱ohuaꞌire: “Yëꞌëje̱ mësaru se̱seꞌe quëaye pa̱ñë.” ");
INSERT INTO seyNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ja̱ jeteyoꞌje Jesús pa̱ire coca ca huëopi. Pa̱i yoꞌoyeje̱ paꞌye neni quëapi, ñeje: “Pajiꞌi, teꞌi tsio paquëpi cuiyaꞌi ta̱ni i̱ coꞌamaña necaicohuaꞌina i̱si nëoni sani huesëquë. ");
INSERT INTO seyNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tëaye ti̱ꞌasi maca saisiquëpi i̱ joꞌyaëre jëjo daopi, coꞌamaña necaicohuaꞌire se̱ni tëani dajë̱ꞌë, yëꞌëre nëocaiseꞌere caquë. Ja̱je cani jëjo daosiquëni ja̱ohuaꞌipi coa tarapi tëꞌcani jëjo saohuë, peoquëre. ");
INSERT INTO seyNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ja̱ maca i̱ti tse̱ aquëpi yequë joꞌyaëre jëjo dao co̱pi. Cuiꞌne ja̱ëteje̱ tarapi tëꞌcani jëjo saohuë, ti i̱simaꞌpë. ");
INSERT INTO seyNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","I̱ti tse̱ aquëpi ti̱jupë yequë joꞌyaëre jëjo daoruje̱ coꞌamaña necaicohuaꞌipi ñani ja̱ëteje̱ tëꞌcani hueꞌsena quërë eto saohuë, pë̱ijë. ");
INSERT INTO seyNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ja̱ maca ña jujani i̱ti yeja tse̱ aquë capi: ‘¿Me neñe ja̱je paꞌito? cani i̱ oi mamaquëre pani jëjo saopi. Ja̱ëni ñanitaꞌa caꞌrajë deꞌoye sehuoja̱ꞌcohuaꞌi aꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Jëjo saouna, i̱pi ti̱ꞌaquëna, tsio ñacaicohuaꞌipi ñani sa̱ꞌñe cahuë: ‘Iquëpi iye tsio tse̱ aquë deꞌoja̱ꞌquë api, huani je̱oñuꞌu. Ja̱je yoꞌoni ti ñese maipi i̱ti tse̱ acohuaꞌi deꞌoñuꞌu cahuë.’ ");
INSERT INTO seyNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ja̱je cani tsio peo hue̱ꞌñana etoni i̱te huani je̱ohuë.” Ja̱je quëani Jesupi se̱jiꞌi: “¿Ja̱je yoꞌosi doꞌi me yoꞌoja̱ꞌquë aꞌni, i̱ti tsio aquë ja̱ohuaꞌire?” ");
INSERT INTO seyNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Cani capi, i̱pi: “Dani coꞌamaña necohuaꞌire huani je̱ani yecohuaꞌina i̱sija̱ꞌquë api, i̱ yeja.” Ja̱je caquëna, iyere asani cahuë: “¡Ja̱je yoꞌoto Maijaꞌquëje̱ coeni!” ");
INSERT INTO seyNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ja̱je cajëna, Jesús i̱ohuaꞌire ñani capi: “Ja̱je mësaru cuasato, ¿i̱quere caquëꞌni, toya pëpë, paꞌiye ñañuꞌu? Ñeje caji: Huëꞌe necaicohuaꞌi ne jujani nejosi quë̱na pëpi Ja̱opi yure quë̱na pë i̱orepa paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ja̱o quë̱na pë ë̱mëjeꞌna pa̱ipi to̱mecohuaꞌi pani, to̱me jëꞌyeye paꞌiji. Cuiꞌne quë̱na pëpi pa̱i ë̱mëjeꞌna to̱meco pani peo së̱pë̱arepa neñe paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌi cuiꞌne cua̱ñeseꞌe yeꞌyacohuaꞌi Jesure i̱ti macapi tse̱ani coñuꞌu maini caquë ja̱je quëaji. Cuasajëtaꞌa pa̱ini caꞌrajë yoꞌoye pa̱huë. ");
INSERT INTO seyNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ja̱ maca yahue deꞌo pa̱irepa cayeje̱ cajë coa cosoja̱ꞌcohuaꞌire jëjo saohuë. Ja̱ohuaꞌipi se̱jëna, i̱pi tayo caëna, ja̱ doꞌire pa̱i ëjaëna tse̱ani i̱siñuꞌu cajë. ");
INSERT INTO seyNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","I̱te se̱ni ñañuꞌu cajë saisicohuaꞌipi cahuë: “Yeꞌyaquë, mëꞌë pa̱ire nuñerepa caquë yeꞌyaquëpi cuiꞌne pa̱ireje̱ siꞌahuaꞌire siꞌa yëꞌquë maca caquëpi coa ai jerepa nuñere pare Maijaꞌquë cocare yeꞌyaquëna, asayë, yëquë. ");
INSERT INTO seyNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ja̱je paꞌina, se̱ñë. Quëajë̱ꞌë: ¿Deꞌoquë paꞌi doꞌire pa̱i ëjaë Césarna sa̱iñe, pa̱nitaꞌa coꞌaquë?” ");
INSERT INTO seyNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Cajë se̱jëna, tsoe Jesús asapi, i̱ohuaꞌi coꞌaye cuasajë se̱ñe. Ja̱je ñani capi: “¿Me yoꞌojë yëꞌëre ja̱je neñañuꞌu cajë yoꞌoyeꞌni? ");
INSERT INTO seyNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","I̱ñojëꞌë, curiquë tëꞌquire. ¿Ne tsiare hueꞌecoꞌni? ¿Cuiꞌne ne mamire toyaseꞌeje̱ hueꞌecoꞌni?” Caquëna, i̱ohuaꞌipi sehuohuë: “Romano pa̱i ëjaë mamire toyasicoa.” ");
INSERT INTO seyNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Cajëna, ja̱ maca i̱pi capi: “Ja̱je paꞌito i̱sijë̱ꞌë, romano pa̱i ëjaëna i̱ tse̱co paꞌito. Cuiꞌne Maijaꞌquë tse̱ paꞌito Maijaꞌquëna i̱sijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ja̱je pa̱i ña hue̱ꞌñana siꞌaye i̱ohuaꞌi cosojë neñuꞌu cajë yoꞌoseꞌere sehuoquëna, ñani ai ta̱ꞌñe asaji cuasajë caꞌrajë jerepa camaꞌpë paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Jeteyoꞌje Saduceohuaꞌipi Jesure sani ñahuë. Ja̱ohuaꞌi Saduceohuaꞌi cato ju̱ꞌisicohuaꞌi huëiye peoji cacohuaꞌi paëꞌë. Ja̱je paꞌiohuaꞌipi cahuë, Jesure: ");
INSERT INTO seyNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Yeꞌyaquë, Moisés toyani yëquëre je̱ocajiꞌi, ñeje: Teꞌi ë̱mëpi mamajëre pamaꞌë nëjore je̱oni ju̱ꞌisiquë paꞌito i̱ yoꞌjeipi huaꞌjeore huejani mamajëre pacaiye paꞌiji, majaꞌyë doꞌire, toyapi careña. ");
INSERT INTO seyNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ja̱je paꞌina, teꞌe tsëcapëre siete ë̱mëohuaꞌipi ñeje yoꞌohuë: Majaꞌyëpi huejapi. Huejani mamajëre peoquë ju̱jiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ju̱quëna, jeteyoꞌje aquëpi huaꞌjeore huejani cuiꞌne ja̱ëje ju̱jiꞌi, mamajëre peoquë. ");
INSERT INTO seyNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ja̱ maca toaso̱ñe aquëpi huejapi i̱ote ja̱ëje cuiꞌne yoꞌopi. Ja̱re ja̱jeseꞌe siete paꞌiohuaꞌi huejajë mamajëre peocohuaꞌi ju̱ju sahuë. ");
INSERT INTO seyNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ai jeteyoꞌjerepa nomio ju̱coꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ja̱je paꞌito ju̱ꞌisicohuaꞌi huëi maca ¿nepi ja̱ote nëjore paja̱ꞌcohuaꞌi aꞌni, siꞌahuaꞌi siete paꞌiohuaꞌi huejasicore?” ");
INSERT INTO seyNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Cajëna, ja̱ maca Jesupi sehuopi, ja̱ohuaꞌire: “Iye yeja cato ë̱mëohuaꞌi cuiꞌne nomiohuaꞌi huejajë. Cuiꞌne nomiohuaꞌire huejojë yoꞌoyë. ");
INSERT INTO seyNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ja̱je paꞌiquëtaꞌare sehuosicohuaꞌipi ju̱ꞌisicohuaꞌipi huëisicohuaꞌipi maꞌtëmo ti̱ꞌani huejaye peoji, cuiꞌne mamajëre pajë huejoye peoji. ");
INSERT INTO seyNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ja̱ro cato hui̱ñaohuaꞌije̱ paꞌiohuaꞌi paꞌija̱ꞌcohuaꞌi aꞌë ju̱ꞌisicohuaꞌipi huëisi doꞌire Maijaꞌquë mamajërepa paꞌija̱ꞌcohuaꞌi aꞌë, ju̱ꞌimaꞌcohuaꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ja̱je paꞌina, so̱quë yëpi tsë̱ꞌisi maca, Moisés ñaquë paꞌiseꞌere toyaseꞌe acopi caji, ñeje: ‘Ëjaëpi caꞌa̱jiꞌi. Yëꞌë cato Abraham, Isaac, Jacobo, Diusu aꞌë. Ja̱ doꞌire asayë, ju̱ꞌisicohuaꞌipi huajëcohuaꞌi huëiye.’ ");
INSERT INTO seyNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ja̱je paꞌina, Maijaꞌquë ju̱ꞌisicohuaꞌi Diusu peoji, coa ai jerepa huajëcohuaꞌi Diusupi. Ja̱je paꞌina, i̱te cato siꞌahuaꞌi huajëcohuaꞌiseꞌe paꞌiyë. Peoji, ju̱ꞌisiquë i̱pi ñato.” ");
INSERT INTO seyNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ja̱ maca cua̱ñeseꞌe yeꞌyacohuaꞌi acohuaꞌipi cahuë: “Yeꞌyaquë, deꞌoyerepa cahuë, mëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ja̱je cani ai jerepa jaiye se̱ñe pa̱huë, caꞌrajë. ");
INSERT INTO seyNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesupi capi, ja̱ohuaꞌire: “¿Me yoꞌojë Cristore David tsëcapë api cayeꞌni? ");
INSERT INTO seyNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ja̱je i̱pi David ñeje casiquëtaꞌare Salmos toya pëpëna: Ëjaëpi capi, yëꞌë Ëjaëre: Jaꞌrujë̱ꞌë, yëꞌë ëja te̱ꞌtena. ");
INSERT INTO seyNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Mëꞌëre sa̱ñope yoꞌocohuaꞌire yëꞌëpi mëꞌë quë̱o tëꞌya me macaja̱ꞌa. ");
INSERT INTO seyNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Ja̱je paꞌito me yoꞌoquë Cristo David tsëcapë aquë paꞌiquëꞌni, tsoe ja̱re i̱pi Davidpi Yëꞌë Ëjaë cato?” ");
INSERT INTO seyNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Siꞌa pa̱i asahuë, Jesús i̱ yeꞌyacohuaꞌire ja̱je cajëna: ");
INSERT INTO seyNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Cua̱ñeseꞌe yeꞌyacohuaꞌi cato tsoa ca̱ña su̱ñani cuiꞌne deꞌoyerepa jai pa̱i paꞌi hue̱ꞌñapi pëpajëna, cuꞌiyere yëcohuaꞌi aꞌë, cuiꞌne pa̱i tsiꞌsi huë̱ꞌñaje ai deꞌo ñuꞌi saina coꞌejë jaꞌruyere yëcohuaꞌi aꞌë, jerepa paꞌiohuaꞌi aꞌë cajë. Ja̱je yoꞌoye mësarutaꞌa deꞌhua ñajëꞌë. Cuiꞌneje yoꞌomaꞌpë pañuꞌu cajë. ");
INSERT INTO seyNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Cuiꞌne huaꞌjeohuaꞌireje̱ i̱ohuaꞌi huë̱ꞌña jiojë yoꞌocohuaꞌi aꞌë, cuiꞌne pa̱ipi deꞌocohuaꞌi aꞌë caja̱jë cajë, tsoerepa se̱cohuaꞌi aꞌë. Ja̱je paꞌina, ja̱ohuaꞌi aꞌë, i̱ti coꞌayerepa sa̱i cua̱ñojaꞌcohuaꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús ñapi, jaiye pacohuaꞌipi Maijaꞌquëre se̱ huëꞌena cacajë, mahuëana curiquë ayajë Maijaꞌquëre i̱sijëna. ");
INSERT INTO seyNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Cuiꞌne ñapi, teꞌo huaꞌjeo macapi caya aꞌri të̱ꞌña mahuëna ayacona. ");
INSERT INTO seyNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ñani Jesupi capi: “Nuñerepa cayë, mësarute. Ico huaꞌjeo ti peocopi siꞌahuaꞌi i̱siye jerepa i̱sio. ");
INSERT INTO seyNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ja̱je paꞌina, ja̱ohuaꞌi siꞌahuaꞌi i̱sihuë, i̱ohuaꞌi huero jujajëna, nëañere. Ja̱je paꞌiquëtaꞌare ja̱o ti peocopi i̱sio, siꞌaye i̱o paco paꞌi mañare.” ");
INSERT INTO seyNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yecohuaꞌipi cocare cahuë, Maijaꞌquëre se̱ huëꞌe ayere, cuiꞌne i̱o deꞌo quë̱na pë̱api nesico paꞌiyere cuiꞌne Maijaꞌquëre coa i̱sisi coꞌamañapi nesico paꞌiyere. Ja̱je cajëna, Jesupi capi: ");
INSERT INTO seyNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Yequë muꞌse mësaru ñaseꞌe peo hue̱ꞌña nejo ja̱ꞌñe ti̱ꞌasipi, yequë quë̱na pë ë̱mëjeꞌe tuiyeje̱ peoyerepa.” ");
INSERT INTO seyNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ja̱je caquëna, se̱iꞌë, i̱te: “¿Yeꞌyaquë, je yëhua ja̱je mëꞌë caseꞌeje̱ yoꞌoja̱ꞌcoaꞌni? ¿Me yoꞌo i̱ñoñe paꞌija̱ꞌcoaꞌni, iye yoꞌoye ti̱ꞌañe jaꞌi maca paꞌito cahuë?” ");
INSERT INTO seyNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Cajëna, Jesupi capi: “Deꞌhua ñajëꞌë, mësarute cosojë. Ja̱je paꞌina, cayë. Jai pa̱i yëꞌë mamire cajë yoꞌoja̱ꞌcohuaꞌi paꞌija̱ꞌcohuaꞌi aꞌë, ‘yëꞌë aꞌë, Cristo,’ cuiꞌne ‘yure aꞌë. Tsoe ti̱ꞌapi’ caja̱ꞌcohuaꞌi aꞌë. Ja̱je catoje̱, sehuomaꞌpë paꞌijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Yequë yejapi cuiꞌne yequë yejana uihuaye paꞌina, cuiꞌne sa̱ꞌñe i̱ti yeja acohuaꞌija̱ꞌa uihuaye paꞌina, asani, quëquëmaꞌpë paꞌijë̱ꞌë. Ja̱je iyepi duꞌru tëto saiye paꞌija̱ꞌcoa. Ja̱je paꞌiquëtaꞌare ja̱ yëꞌtaꞌa caraja̱iñerepa ti̱ꞌañe pa̱jaꞌcoa.” ");
INSERT INTO seyNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ai jerepa yequeje̱ ñeje capi: “Teꞌe jai yejapi cuiꞌne jai yejana se uihuaye pasipi. Cuiꞌne yequë pa̱ipi yequë pa̱i ja̱ꞌre uihuaja̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Pasipi, yeja ñuꞌcueyeje̱, a̱o ëa ju̱ꞌiñe. Cuiꞌne coa siꞌa hue̱ꞌña ju̱ꞌi dahuë pasipi. Cuiꞌne maꞌtëmopi huajëyaꞌye yoꞌoye paꞌina, ñajaꞌcohuaꞌi aꞌë. Cuiꞌne jaiye ti ña maꞌñere ñajaꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ja̱ yëꞌtaꞌa iye siꞌaye yoꞌomaꞌnë, mësarute tse̱ajë cuiꞌne jo̱sa yoꞌoja̱ꞌcohuaꞌi aꞌë. Ja̱je yoꞌojë coꞌacohuaꞌi aꞌë cajë saja̱ꞌcohuaꞌi aꞌë, pa̱i tsiꞌsi huë̱ꞌñana. Pa̱ire co hue̱ꞌñana coja̱ꞌcohuaꞌi aꞌë. Ja̱je yoꞌojë pa̱i ëjaohuaꞌi quëꞌrona, cuiꞌne cua̱ñecohuaꞌi quëꞌrona saja̱ꞌcohuaꞌi aꞌë, yëꞌë mami doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ja̱je yoꞌojëna, mësaru yëꞌë cocare quëacaija̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ja̱je paꞌina, tse̱arena, ca ja̱ꞌñere ne deꞌhuañuꞌu cajë ai cuasamaꞌpë paꞌijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ja̱je paꞌina, yëꞌëpi ta̱ꞌñe coca caye i̱siquëna, mësarute sa̱ñope yoꞌocohuaꞌire sa̱ñope deꞌhue sehuoye peoyerepa cuiꞌne quëcoye peoyerepa caja̱ꞌcohuaꞌi aꞌë, mësaru. ");
INSERT INTO seyNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ja̱je paꞌiquëtaꞌare mësaru jaꞌquëohuaꞌipi, yoꞌje tsi̱pi, doꞌijëpi cuiꞌne cajeohuaꞌipi, tse̱ani yecohuaꞌina i̱sija̱ꞌcohuaꞌi aꞌë, cuiꞌne yecohuaꞌini huani je̱ajaꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Cuiꞌne siꞌa pa̱i mësarute coeja̱ꞌcohuaꞌi aꞌë, yëꞌë doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ja̱je yoꞌojëtaꞌare mësaru si̱opë naña me macaje̱ teꞌoje̱ ne huesëye pa̱sipi. ");
INSERT INTO seyNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Yoꞌo jujamaꞌpë nuñerepa paꞌisicohuaꞌi pani, ti paꞌiyere pana ti̱ꞌajaꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Jerusalén daripëre soldado pa̱ipi tëhuo tëꞌija̱isico paꞌiona, ñani ja̱ maca cuasajë̱ꞌë, yure maca nejosico paꞌija̱ꞌcoa cajë. ");
INSERT INTO seyNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ja̱ maca Judea paꞌicohuaꞌipi catiye paꞌiji, jai cu̱tihuëna. Jerusalén daripë paꞌicohuaꞌipi etani saiye paꞌiji, yequë hue̱ꞌñana. Cuiꞌne tsio paꞌicohuaꞌipi coꞌiye peoji, cuiꞌna daripëna. ");
INSERT INTO seyNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ja̱ muꞌseña cato i̱ohuaꞌi yoꞌosi doꞌire sa̱i muꞌseña pasipi. Ja̱je yoꞌo muꞌseña siꞌaye toyaseꞌe ti̱ꞌasipi. ");
INSERT INTO seyNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Coꞌayerepa ja̱ muꞌseña tsi̱ ë̱ta pë̱a maña cuiꞌne tsi̱ tu̱ꞌña pacohuaꞌi maña ai yoꞌoja̱ꞌcohuaꞌi aꞌë, Maijaꞌquë pë̱i ai yoꞌoye nesi maca. ");
INSERT INTO seyNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ja̱je paꞌina, huajore huaijë yecohuaꞌi huahuoja̱ꞌcohuaꞌi aꞌë, yecohuaꞌini coa tse̱sejë coa siꞌa hue̱ꞌñana saja̱ꞌcohuaꞌi aꞌë. Cuiꞌne judío pa̱i peocohuaꞌipi Jerusalén daripë tsaꞌcu huesoja̱ꞌcohuaꞌi aꞌë, Maijaꞌquë ña nëosi tëcahuë, caraja̱i macaja̱ꞌa. ");
INSERT INTO seyNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ja̱ maca ë̱së yoꞌoye, cuiꞌne ñañë yoꞌoye cuiꞌne maꞌñocohuaꞌi yoꞌoyere ñajë iye yeja paꞌicohuaꞌipi cuasa co̱ꞌme huesësicohuaꞌi paꞌija̱ꞌcohuaꞌi aꞌë, jai tsiayapi coꞌpoco ai pi̱siquëna, asajë quëquësicohuaꞌi paꞌijë. ");
INSERT INTO seyNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Pa̱i coa quëquë huesëjë ju̱ꞌiseꞌeje̱ paꞌiohuaꞌi dahuëra etaja̱ijëna, yoꞌoja̱ꞌcohuaꞌi aꞌë, iye yeja caraja̱i yoꞌo maca, maꞌtëmo tuture paque tsasija̱ꞌcoa. ");
INSERT INTO seyNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ja̱ maca ñajaꞌcohuaꞌi aꞌë, Pa̱i Mamaquë sirija̱ꞌa tutu quëꞌire papi cuiꞌne i̱ deꞌoye paꞌiyepi daina. ");
INSERT INTO seyNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ja̱je paꞌina, iyepi siꞌaye yoꞌo huëoquëna, ñani sihuajë̱ꞌë, cuiꞌne si̱opë̱a maña mëani ñajëꞌë, tsoe deꞌoye paꞌiye mësarute i̱sija̱ꞌquëpi daija̱ꞌquë api cajë.” ");
INSERT INTO seyNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ja̱ maca quëapi, pa̱i ñajëna, so̱quë yë yoꞌoyeje̱ paꞌye ñani quëaquë capi: “Higuera so̱quë yë yoꞌoyeje̱ paꞌye yoꞌoja̱ꞌcoa. Tsoe mësarupi ta̱ꞌñe asacohuaꞌi aꞌë, i̱o yoꞌoye. ");
INSERT INTO seyNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ja̱je paꞌina, jaꞌopi mëa huëoquëna, ñani o̱metëcahuë ti̱ꞌañe jaꞌyere paꞌiji, cacohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ja̱je cuiꞌne yëꞌë caseꞌepi ti̱ꞌaquë yoꞌo huëoquëna, ñani tsoe ti̱ꞌaji. Jaꞌyere paꞌiji, Maijaꞌquë cua̱ñe te̱ꞌte. ");
INSERT INTO seyNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nuñerepa cayë. Siꞌaye iye ja̱je yoꞌo saoja̱ꞌcoa. Ja̱ yëꞌtaꞌa yure iye yoꞌo huëo ñasicohuaꞌi paꞌicohuaꞌi ju̱ju samaꞌnë. ");
INSERT INTO seyNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ja̱je paꞌina, maꞌtëmo, yeja pani tëjini caraja̱ijaꞌcoa, yëꞌë cocataꞌa ti pani huesëja̱ꞌcoa. ");
INSERT INTO seyNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Deꞌhua ñare pajë paꞌijë̱ꞌë, më joñoare jëa joyo neñere, coꞌaye yëyere, co̱no cuepeyere cuiꞌne iye yeja paꞌijë deꞌoye pañuꞌu cayere, ja̱ muꞌse ti̱ꞌaquëna, cuasamaꞌpë yoꞌoyepi. ");
INSERT INTO seyNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Trampana si̱oñeje yoꞌoja̱ꞌcoa, ja̱ muꞌse siꞌa hue̱ꞌña yeja paꞌicohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ne deꞌhuasicohuaꞌipi paꞌijë̱ꞌë, Maijaꞌquëre siꞌanë se̱jë, iye tëto saitoje̱ jëasicohuaꞌi paꞌicohuaꞌipi Pa̱i Mamaquë daina, deꞌoyepi i̱ñojaꞌcohuaꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ja̱ muꞌseña cato Jesús yeꞌyapi, Maijaꞌquëre se̱ huëꞌe Jerusalén paꞌicona. Cuiꞌne ñamire Olivos hueꞌyosi cu̱tihuëna sani pëapi. ");
INSERT INTO seyNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ja̱je paꞌina, siꞌa nea hue̱ꞌña pa̱ipi daëꞌë, Maijaꞌquëre se̱ huëꞌena i̱ quëaquëna, asañuꞌu cajë. ");
INSERT INTO seyNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Jujumaꞌ a̱o a̱iñe ti̱ꞌañe jaꞌi maca paꞌiji, ja̱ cato. Egípto pa̱i mamajëseꞌere huai Israel pa̱i mamajëre huaiye pa̱seꞌere coꞌye cuasajë sihuajë yoꞌoye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ja̱ muꞌseña Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌi cuiꞌne cua̱ñeseꞌe yeꞌyacohuaꞌipi, Jesure me neni huani je̱ojaꞌcohuaꞌi aꞌni cuasajë coꞌehuë, i̱te asa pa̱ini caꞌrajë. ");
INSERT INTO seyNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ja̱ maca huati ëjaëpi Judas cuiꞌne yequë mami Iscariote hueꞌequëna cacapi, doce Jesús soisicohuaꞌi aquëna. ");
INSERT INTO seyNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Cacaquëna, ja̱ëpi sajiꞌi, Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌi quëꞌrona cuiꞌne Maijaꞌquëre se̱ huëꞌe ñacaicohuaꞌi quëꞌrona sani ja̱ohuaꞌi ja̱ꞌre co̱ni Jesure ñeje yoꞌoni tse̱ani mësaru jë̱ñana i̱siꞌñe paꞌi api capi. ");
INSERT INTO seyNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ja̱je caquëna, asani ja̱ohuaꞌi ai sihuajë curiquë sa̱iñuꞌu ca nëohuë, i̱te. ");
INSERT INTO seyNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Cajëna, i̱pi sehuoni i̱te tse̱a ja̱ꞌñere me pa̱i peo maca i̱te tse̱ani i̱sija̱ꞌquë aꞌni cuasaquë i̱ yoꞌo ja̱ꞌñe coꞌepi. ");
INSERT INTO seyNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Jujumaꞌ a̱o a̱ijë cuiꞌne yëi ñamare huani Maijaꞌquëre i̱sijë se̱ muꞌse ti̱ꞌapi. ");
INSERT INTO seyNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ti̱ꞌaëna, Jesupi Pedrore cuiꞌne Juanre jëjo saoquë capi: “Sani ne deꞌhuajë̱ꞌë, naꞌiquëna a̱i ja̱ꞌñere Israel pa̱i fiestare cuasajë.” ");
INSERT INTO seyNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ja̱ohuaꞌipi i̱te se̱iꞌë: “¿Jerona ne deꞌhuayeꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Cajëna, Jesupi sehuopi: “Mësaru jai daripëna caca maca ti̱ꞌajaꞌcohuaꞌi aꞌë, teꞌi ë̱mëpi yurupëna oco saquëni. Ti̱ꞌani i̱ huëꞌere pana tuijë̱ꞌë. I̱pi cacaquëna, ñani teꞌe cacajë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Cacani ja̱ maca i̱ti huëꞌe aquëre se̱jëꞌë: ‘¿Jerore paꞌicoꞌni, yëꞌë yeꞌyacohuaꞌi ja̱ꞌre co̱ni naꞌiquëna, Israel pa̱i fiestare cuasajë a̱ijaꞌa tuꞌrihuë? Capi yeꞌyaquëpi,’ cajë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ja̱je cajëna, i̱pi i̱ñosipi, ë̱mëjeꞌe tuꞌrihuëpi, jai hue̱ꞌñapi tsoe siꞌaye paꞌiconi. Ñani ja̱rona ne deꞌhuajë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ja̱je caëna, ja̱ohuaꞌipi sani ja̱re Jesús caseꞌeje̱ ti̱ꞌahuë. Ti̱ꞌani Israel pa̱i fiesta yoꞌoyere cuasajë ne deꞌhuaë. ");
INSERT INTO seyNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","A̲o a̱iñe ti̱ꞌasi maca Jesús cuiꞌne i̱ yeꞌyacohuaꞌi co̱ni jaꞌruhuë, a̱o a̱i saihuëna. ");
INSERT INTO seyNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ja̱ maca Jesupi capi, ja̱ohuaꞌire: “Mësaru ja̱ꞌre co̱ni iye fiesta naꞌiquëna, a̱iñe yëhuë. Ja̱ yëꞌtaꞌa yëꞌë ai yoꞌoye ti̱ꞌamaꞌnë. ");
INSERT INTO seyNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ja̱je paꞌina, cayë, mësarute. Ti̱jupë cuiꞌnaëpi mësaru ja̱ꞌre co̱ni iye fiesta yoꞌo co̱ñe pa̱jaꞌquë aꞌë, iye yejana. Iye yoꞌoye Maijaꞌquë te̱ꞌtena ne sao maca ja̱ maca a̱ni co̱siꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ja̱ maca ja̱je cani u̱cu duruhuë i̱ni Maijaꞌquëre deꞌoji, se pëpani capi: “Iyere i̱ni huahuejë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Care payë, mësarute. Ti̱jupë cuiꞌnaëpi cuiyaꞌi co̱no u̱cumaꞌë paꞌija̱ꞌquë aꞌë, Maijaꞌquë cua̱ñe te̱ꞌtena yoꞌoye ti̱ꞌañe pa̱to.” ");
INSERT INTO seyNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ja̱ jeteyoꞌje panpë i̱ni Maijaꞌquëre deꞌoji se pëpani i̱pi huaꞌquequë ja̱ohuaꞌina i̱sipi. I̱sini capi: “Iye yëꞌë ca̱ꞌë. Iye yoꞌoyeje̱ paꞌyere yoꞌojë̱ꞌë, yëꞌëre cuasajë.” ");
INSERT INTO seyNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ja̱je cuiꞌne u̱cu duruhuëje̱ a̱ni tëjini i̱ni capi: “Iye u̱cu duruhuë cato huajëye yoꞌo ja̱ꞌñere ca nëoñe aꞌë, yëꞌë tsiepi mësaru deꞌoye paꞌi ja̱ꞌñere caquë nejojaꞌa doꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ja̱je paꞌina, yëꞌëre cosoquë tse̱ani yecohuaꞌina i̱sija̱ꞌquë i̱ñore paꞌiji, yëꞌë ja̱ꞌre teꞌe a̱o a̱i saihuëna tëoseꞌepi. ");
INSERT INTO seyNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ja̱je yoꞌoye paꞌiji, Pa̱i Mamaquë cato ja̱re i̱te quëa nëosi maꞌajaꞌa saiji. Ja̱je paꞌiquëtaꞌare ¡teaye paꞌi paꞌiji, i̱ti yehuoja̱ꞌquë!” ");
INSERT INTO seyNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ja̱ maca ja̱je caëna, i̱ohuaꞌija̱ꞌa sa̱ꞌñe se̱iꞌë, “¿nepi mai aquë yehuoja̱ꞌquë aꞌni?” cajë. ");
INSERT INTO seyNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ja̱ maca sa̱ꞌñe cajë, “¿nepi ai jerepa paꞌi paꞌija̱ꞌquë aꞌni?” cahuë. ");
INSERT INTO seyNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Cajëna, Jesupi sehuopi: “Yejaña ëjaohuaꞌipi i̱ti necaicohuaꞌire cajë cua̱ñecohuaꞌi aꞌë, cuiꞌne i̱ti yeja deꞌoye paꞌi ja̱ꞌñere cajë necaicohuaꞌipi, cajeohuaꞌire hueꞌyocohuaꞌi aꞌë, i̱ohuaꞌi ëjaëre. ");
INSERT INTO seyNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ja̱je paꞌiquëtaꞌare mësaru cato ja̱je yoꞌocohuaꞌi paꞌiye peoji. Coa ai jerepa ñeje yoꞌoye paꞌiji. I̱ti ai jerepa paꞌipi mësaru aquë cato tsi̱ po̱sëje̱ paꞌi paꞌiye paꞌiji, cuiꞌne i̱ti cua̱ñequëpi coa necaiquëje̱ paꞌi paꞌiye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ja̱je paꞌito, ¿ne aꞌni, ai jerepa paꞌi, a̱o a̱i saihuëna jaꞌruni ñuꞌi a̱iquë, pa̱nitaꞌa i̱ti a̱ore sa a̱oquë? Ja̱je paꞌina, mësarupi ñato a̱o a̱i saihuë ñuꞌiquë api jerepa paꞌiji, cayë. Ja̱je paꞌiquëtaꞌare yëꞌë cato mësarute necaiquë paꞌiyë. ");
INSERT INTO seyNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Mësaru aꞌë, yëꞌëre ai yoꞌoye paꞌina, siꞌanë yëꞌë ja̱ꞌre co̱ni paꞌisicohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ja̱je paꞌina, mësarute yëꞌëpi cua̱ñecohuaꞌi paꞌi ja̱ꞌñere, jaꞌquë yëꞌëre i̱siseꞌeje̱ i̱siyë. ");
INSERT INTO seyNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Yëꞌë ja̱ꞌre co̱ni a̱o a̱i saihuëna, yëꞌë cua̱ñe hue̱ꞌñana a̱ijajë cuiꞌne u̱cuja̱ꞌcohuaꞌini cuiꞌne cua̱ñecohuaꞌi ñuꞌi saire pana jaꞌruja̱jë doce Israel pa̱i tsëcapë acohuaꞌi yoꞌoseꞌere ña deꞌhuaja̱ꞌcohuaꞌini paꞌija̱ꞌcohuaꞌi aꞌë, mësaru.” ");
INSERT INTO seyNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ëjaëpi yequeje̱ capi: “Simón, Simón Satanáspi mëꞌëre trigo ñuꞌcueyeje̱ paꞌye yoꞌosiꞌi caquë se̱jiꞌi. Deꞌhua ñajëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ja̱je paꞌiquëtaꞌare yëꞌëpi mëꞌëni caquë Maijaꞌquëre se̱cacaëꞌë, mëꞌë cuasayepi deꞌoye paꞌija̱quë caquë. Mëꞌëpi ja̱ yoꞌoye tëto sani yëꞌëna po̱nësi maca. Co̱caijë̱ꞌë, mëꞌë yoꞌje tsi̱re nuñerepa paꞌija̱ꞌcohuaꞌini.” ");
INSERT INTO seyNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ja̱je caquëna, Simónpi capi: “Ëjaë, yëꞌë cato mëꞌë ja̱ꞌre co̱ni co hue̱ꞌña cotoje̱ co cua̱ñosiꞌi cuasayë, cuiꞌne ju̱ꞌiñe paꞌitoje̱ teꞌe ju̱ꞌiñere yëyë.” ");
INSERT INTO seyNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Caquëna, Jesupi capi, i̱te: “Pedro, care payë. Mëꞌëre iye ñata to̱me maca ja̱ yëꞌtaꞌa cura yëꞌimaꞌëna, toaso̱ñe paꞌye cosoja̱ꞌquë aꞌë, mëꞌë ñamaꞌquë aꞌë i̱te, yëꞌë caquë.” ");
INSERT INTO seyNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesupi se̱jiꞌi, ja̱ohuaꞌire: “Mësarute topë̱a peocohuaꞌire cuiꞌne curiquë peocohuaꞌire, cuiꞌne zapatoje̱ peocohuaꞌire jëjo saosi maca ¿mësarute coꞌamaña jopo caraë?” Ja̱je se̱ina, i̱ohuaꞌipi cahuë: “Pa̱ni.” ");
INSERT INTO seyNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Cajëna, capi, ja̱ohuaꞌire: “Ja̱je yoꞌoseꞌe paꞌiquëtaꞌare yure cato ti̱ñe yeque yoꞌoye paꞌiji. Ja̱je paꞌina, topë paquë pani saye paꞌiji. Cuiꞌne curiquë ayacore paquë pani saye paꞌiji. Cuiꞌne huaꞌti peoquë pani dëi juꞌi ca̱re i̱siquë curi neni hueroye paꞌiji, huaꞌtije̱. ");
INSERT INTO seyNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Yëꞌëna tsoe toyajë paꞌiseꞌere ti̱ꞌañe paꞌiji. Ja̱ toyaseꞌepi caji: ‘Coꞌacohuaꞌi ja̱ꞌre co̱ni cue̱cuehuë.’ Ja̱je paꞌina, siꞌaye toyaseꞌe nuñerepa ti̱ꞌañe paꞌiji, yëꞌëna.” ");
INSERT INTO seyNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ja̱je caquëna, ja̱ohuaꞌipi cahuë: “Ëjaë, i̱ñore caya hua̱ꞌña paꞌiji.” Ja̱je cajëna, i̱pi sehuopi: “Tsoe ti̱ꞌapi.” ");
INSERT INTO seyNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ja̱ maca sajiꞌi, etani Olivos cu̱tihuëna noni i̱ sai hue̱ꞌñana. Saina, i̱ yeꞌyacohuaꞌije̱ co̱ni tuëꞌë, i̱te. ");
INSERT INTO seyNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","I̱ti hue̱ꞌña ti̱ꞌani, ja̱ohuaꞌire capi: “Se̱jëꞌë, huati neña maca ta̱iñe pa̱jaꞌcohuaꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Cani ja̱ jeteyoꞌje Jesús ja̱ohuaꞌire je̱oni sajiꞌi, quë̱na pë je̱oñe jaꞌi macana. Ja̱rona doꞌre jaꞌruni se̱jiꞌi, Maijaꞌquëre. ");
INSERT INTO seyNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ñeje caquë: “Jaꞌquë, mëꞌëpi iye së̱je co̱no daꞌca nejocaiye paꞌito nejocaijë̱ꞌë, ai yoꞌo ja̱ꞌñere. Ja̱ yëꞌtaꞌa yëꞌë cuasaseꞌeje̱ yoꞌomaꞌë paꞌijë̱ꞌë. Coa ai jerepa mëꞌë cuasaseꞌere yoꞌosiꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ja̱je paꞌina, Maijaꞌquë hui̱ñaëpi maꞌtëmopi ñaipi, i̱te tutu i̱sisiꞌi caquë. ");
INSERT INTO seyNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ja̱je ai oi yoꞌoquë ai jerepa tutu Maijaꞌquëre se̱jiꞌi cuiꞌne i̱ ai ë̱së cajeyeje̱ paꞌye tsiepi yejana cajepi. ");
INSERT INTO seyNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ja̱je Maijaꞌquëre se̱ni tëjini huëni sajiꞌi, i̱ yeꞌyacohuaꞌi quëꞌrona. Ti̱ꞌaquë ñaquëna, oiyepi quëco huesouna ca̱isicohuaꞌipi paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Paꞌijëna, ja̱ maca capi, ja̱ohuaꞌire: “¿Me yoꞌojë ca̱isicohuaꞌipi u̱iñeꞌni? Huëijë̱ꞌë. Huëni se̱jëꞌë, huatipi neñaquëna, ta̱imaꞌpë paꞌija̱ꞌcohuaꞌipi.” ");
INSERT INTO seyNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesupi ja̱ yëꞌtaꞌa cocare caëna, jai pa̱i ti̱ꞌasi macaje̱ Judas hueꞌequë doce i̱ soisicohuaꞌi aquëpi duꞌru dajiꞌi. Daina, yecohuaꞌi jeteyoꞌje daëꞌë. Ja̱ëpi ti̱ꞌani Jesure tsu̱ꞌsusiꞌi caquë tsio dajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Tsio dai maca Jesús i̱te capi: “Judas, ¿coa tsu̱ꞌsuquë sihuayeje̱ paꞌyepi yoꞌoquë yehuosiꞌi caquë yoꞌoquë Pa̱i Mamaquëre, mëꞌë?” ");
INSERT INTO seyNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ja̱ maca Jesús ja̱ꞌre co̱ni paꞌicohuaꞌipi ñani se̱iꞌë: “Ëjaë, ¿hua̱ꞌñapi ja̱ohuaꞌire huaiye deꞌoquë?” ");
INSERT INTO seyNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ja̱je se̱ maca i̱ohuaꞌi aquëpi tsoe Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaë joꞌyaëni ëja te̱ꞌte ca̱jorona tëtopi, peo te̱ꞌterepa. ");
INSERT INTO seyNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ja̱je yoꞌoquëna, Jesupi capi: “Je̱ojëꞌë, tsoe deꞌoji.” Ja̱ maca Jesús Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaë joꞌyaë ca̱jorore cuiꞌnaoni i̱ni tuacajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ja̱ jeteyoꞌje Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌire cuiꞌne Maijaꞌquë huëꞌe ñacai soldado pa̱i ëjaohuaꞌire cuiꞌne aiohuaꞌire Jesupi capi, i̱te tse̱ani sañuꞌu cajë daisicohuaꞌire: “¿Coꞌamaña ñaëre yoꞌoyeje̱ paꞌye mësaru tarapi, hua̱ꞌñapi co̱ni date? yëꞌëre tse̱añuꞌu cajë. ");
INSERT INTO seyNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Yëꞌë mësaru ja̱ꞌre co̱ni siꞌa muꞌseña Maijaꞌquëre se̱ huëꞌe paꞌina, mësarupi yëꞌëre pu̱ꞌpemaꞌpë paꞌisicohuaꞌitaꞌa ja̱je yoꞌo macapi ti̱ꞌaëna, mësaru yoꞌojë neañepi quëco huesosi maca.” ");
INSERT INTO seyNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ja̱ maca Jesure tse̱ani coñuꞌu cajë sahuë, Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaë huëꞌena. Sajëna, cuiꞌne Pedroje̱ tujiꞌi, soꞌo maca se ñaquë. ");
INSERT INTO seyNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ja̱ro hueꞌse daripë tëhuo sitopi toa suahuë. Suani jaꞌru tëꞌija̱ëꞌë, i̱ojaꞌa. Cuiꞌne Pedroje̱ i̱ohuaꞌi ja̱ꞌre co̱ni jaꞌrupi. ");
INSERT INTO seyNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ja̱ maca teꞌo huëꞌe necaicopi toa yëꞌquë macare jaꞌrusiquëpi toa mia hue̱ꞌñare ñuꞌina, i̱seꞌere ai ñani cao: “Iquë Jesús ja̱ꞌre co̱ni paꞌisiquë api.” ");
INSERT INTO seyNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ja̱je cacona, Pedropi cosoquë capi: “Ñamaꞌquë aꞌë, i̱te.” ");
INSERT INTO seyNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Aꞌri maña tsoe paꞌi maca yequëpi sani cuiꞌne capi: “Mëꞌëje Jesús yeꞌyacohuaꞌi aquë aꞌë.” Ja̱je caquëna, Pedropi capi: “Pa̱ni. Yëꞌë yequë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Teꞌe hora tëto sai maca yequë cuiꞌne ti̱tani capi: “Nuñerepa mëꞌë i̱ ja̱ꞌre co̱ni paꞌisiquë aꞌë. Cuiꞌne ja̱je paꞌipi Galilea aquë aꞌë, mëꞌë. Asayë, mëꞌë cocana.” ");
INSERT INTO seyNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Caquëna, Pedropi capi: “Huesëyë, yëꞌë mëꞌë caye. ¿I̱quere caquëꞌni, ja̱je paꞌye?” Ja̱ yëꞌtaꞌa i̱tire Pedro caquëna, cura yëjiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Yëꞌina, ja̱ maca Ëjaëpi coꞌye po̱nëni ñapi, Pedrore. Ja̱ maca Pedro Ëjaë caseꞌere cuasa ñajajiꞌi: “Ja̱ yëꞌtaꞌa cura yëꞌimaꞌëna, toaso̱ñe paꞌye cosoja̱ꞌquë aꞌë, mëꞌë caseꞌere.” ");
INSERT INTO seyNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ja̱ maca Pedro hueꞌsena etani ai ojiꞌi, i̱ tayoseꞌere coꞌa ju̱ꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jesure tse̱ani pacohuaꞌipi cueꞌcuejë cuiꞌne i̱te tara pë̱api tëꞌcahuë. ");
INSERT INTO seyNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","I̱te ñaco ca̱ ca̱ñapi sëani tsiana mosi̱capi tëꞌcajë cahuë: “¿Se ca ñajëꞌë. Nepi tëꞌcareꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Cuiꞌne jaiye yequë cocaje̱ cahuë, i̱te tea ju̱ꞌijë. ");
INSERT INTO seyNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Muꞌse paꞌi maca Judío i̱ohuaꞌi Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌi, cuiꞌne cua̱ñeseꞌe yeꞌyacohuaꞌi tsiꞌsini Jesure sahuë. Jerepa ëjaohuaꞌipi ca tëjicohuaꞌirepa quëꞌrona, se̱ni asañuꞌu cajë, sani cahuë: ");
INSERT INTO seyNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Quëajë̱ꞌë. ¿Mëꞌë aë, Cristorepa?” Cajëna, i̱pi sehuopi, ja̱ohuaꞌire: “Yëꞌë i̱ aꞌë catoje̱ mësaru coa caji cuasaye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Cuiꞌne yëꞌëpi mësaruni se̱quë paꞌito yëꞌë se̱ñere sehuo ti̱ꞌañe peoji, cuiꞌne joye saoyeje̱ pa̱jaꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ja̱je paꞌisicohuaꞌitaꞌare yuretaꞌa Pa̱i Mamaquë Maijaꞌquërepa ëja te̱ꞌtere jaꞌrusiquëpi ñuꞌijaꞌquë api, Ëjaërepa paꞌija̱ꞌquëpi.” ");
INSERT INTO seyNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ja̱je caquëna, ja̱ maca siꞌahuaꞌi i̱te se̱iꞌë: “¿Ja̱je paꞌito mëꞌë aë, Maijaꞌquë mamaquë?” Se̱jëna, Jesupi sehuopi: “Ja̱je paꞌijë̱ꞌë. Yëꞌë aꞌë, mësaru cayeje̱.” ");
INSERT INTO seyNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Caquëna, ja̱ maca i̱ohuaꞌipi cahuë: “¿I̱quere cajë ai jerepa i̱ caquëna, asasicohuaꞌire coꞌeyeꞌni? Tsoe maipi asahuë, i̱ yëꞌore pare cahuë.” ");
INSERT INTO seyNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ja̱ maca ja̱je cani siꞌahuaꞌi huëni Jesure sahuë, Pilato quëꞌrona. ");
INSERT INTO seyNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ja̱rona coꞌaquëre papi ca huëohuë, ñeje cajë: “Iquë coꞌaye yoꞌoye ti̱ꞌahuë, yëquë pa̱ini coꞌa deꞌhuaquë cuiꞌne pa̱i doꞌi sa̱imaꞌpë paꞌijë̱ꞌë, romano pa̱i ëjaëre caquë. Cuiꞌne, ja̱re i̱pi yëꞌë Cristo, pa̱i ëjaëre paꞌë caquë api.” ");
INSERT INTO seyNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ja̱je caquëna, Pilatopi se̱jiꞌi, i̱te: “¿Mëꞌë aꞌë, judío pa̱i ëjaë?” Caquëna, Jesupi sehuopi: “Ja̱je paꞌijë̱ꞌë, mëꞌë caseꞌeje̱.” ");
INSERT INTO seyNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Caquëna, ja̱ maca Pilato capi, ja̱ohuaꞌire Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌire, cuiꞌne pa̱ire: “Iquë coꞌaye yoꞌoye ti̱ꞌamaꞌë paꞌiyë.” ");
INSERT INTO seyNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Caquëna, i̱ohuaꞌipi ai tutu cahuë: “I̱ yeꞌyapi siꞌa Judea pa̱ire coꞌa deꞌhuaquë sa̱ñope ëjaohuaꞌire, yoꞌocohuaꞌire nequë api. Ja̱je paꞌipi yure i̱ñona cuiꞌne yoꞌoji, Galileapi huëosiquëpi.” ");
INSERT INTO seyNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatopi ja̱re asani, ja̱je paꞌito iquë Galilea aquë aꞌë capi. ");
INSERT INTO seyNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ja̱je paꞌina, mësarupi ja̱ro aquë api carena, Herodes quëꞌrona jëjo saosiꞌi, Galilea daripë cua̱ñequëna, capi. Ja̱ muꞌseña cato ja̱ëje Jerusalénre pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Sarena, Herodespi ñani ai sihuaquë ai tsoe coa ña ëa ju̱ꞌi paꞌiquëpi i̱ yoꞌoyeseꞌe cajëna, asaquë pajiꞌi. Ja̱je paꞌipi pa̱i yoꞌo ti̱ꞌa maꞌñere yoꞌoquëna, ñasiꞌi caquë paꞌiquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ja̱je paꞌipi jaiye se̱jiꞌi. Se̱quëtaꞌare Jesús teꞌoreje̱ sehuomaꞌë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Cuiꞌne ja̱rote Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌipi cuiꞌne cua̱ñeseꞌe yeꞌyacohuaꞌipi ja̱ohuaꞌipi i̱te ai sa̱ñope cacohuaꞌi paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ja̱ maca Herodes cuiꞌne i̱ soldado pa̱i tea ju̱ꞌijë coꞌaye yoꞌohuë. Coa i̱ni cueꞌcueñuꞌu cajë su̱ñahuë, deꞌo ca̱ñare pa̱i ëjaohuaꞌi juꞌi ca̱re. Ja̱ jeteyoꞌje cuiꞌnaëni Pilato quëꞌrona jëjo saopi. ");
INSERT INTO seyNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ja̱ muꞌse Pilato cuiꞌne Herodes cajeohuaꞌi deꞌohuë, ja̱ꞌrë pë̱icohuaꞌi paꞌisicohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ja̱ maca Pilato Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌire cuiꞌne pa̱i ëjaohuaꞌire tsiꞌsoni, ");
INSERT INTO seyNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","capi: “Mësarupi dahuë, iquëre yëꞌë quëꞌrona coꞌaye pa̱ire yoꞌoji cajë. Ja̱je paꞌiquëtaꞌare yëꞌëpi se̱ni asasiꞌi caquë mësarupi ñajëna, yoꞌohuë. Ja̱je paꞌina, tsoe mësarupi ñahuë, doꞌi peoquë paꞌina. Ja̱je paꞌito i̱que doꞌire i̱te coꞌaye cayeꞌni. ");
INSERT INTO seyNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ja̱je paꞌina, Herodesje̱ ti coꞌaye yoꞌomaꞌquë paꞌina, ña jujani jëjo daopi. Ja̱je paꞌina, iquëre huani je̱oñe peoji. ");
INSERT INTO seyNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ja̱je paꞌina, coa siꞌseni jeteyoꞌje joye saoja̱ꞌquë aꞌë, paꞌija̱ꞌquëre.” ");
INSERT INTO seyNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ja̱je fiesta muꞌseña cosicohuaꞌire teꞌire eto saoquë pajiꞌi, pa̱ire deꞌoye yoꞌosiꞌi caquë. ");
INSERT INTO seyNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ja̱je caquëna, siꞌahuaꞌi cui huëohuë: “¡Ja̱ëte huani je̱oñe paꞌiji! ¡Barrabásni eto saojë̱ꞌë!” ");
INSERT INTO seyNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Iquë Barrabás cato pa̱ire huaisiquëni cosiquë pajiꞌi. Cuiꞌne ja̱ daripë pa̱i i̱ohuaꞌi ëjaohuaꞌire uihuaye huëoquëpi. ");
INSERT INTO seyNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato cato Jesuni etoye yëpi. Ja̱je paꞌina, ti̱jupë ca co̱pi. ");
INSERT INTO seyNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Caquëna, ai jerepa tutu cuihuë: “¡Que̱jaꞌquë api, que̱jaꞌquë api!” ");
INSERT INTO seyNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Toaso̱ñe aye Pilato capi, ja̱ohuaꞌire: “¿I̱quere coꞌaye yoꞌo uꞌni, i̱? Yëꞌë i̱ coꞌaye yoꞌoseꞌe ti̱ꞌamaꞌë paꞌiyë. Ja̱je paꞌire ¿me coa huaiyeꞌni? Ja̱je paꞌina, coa ai siꞌseni jëjo saosiꞌi, paꞌija̱ꞌquëre.” ");
INSERT INTO seyNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ja̱je caquëna, ai jerepa tutu cuihuë, que̱jaꞌquë api cajë. Ja̱je ai cui doꞌipi Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌi caseꞌe ja̱ yoꞌoye ti̱ꞌahuë. ");
INSERT INTO seyNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ja̱ maca Pilato i̱ohuaꞌi yëjë cayeje̱ yoꞌoseꞌe paꞌija̱quë cuasapi. ");
INSERT INTO seyNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Cuasani ja̱je i̱ohuaꞌi casiquëni eto saopi, pa̱ire huaiquë coꞌaquëni. Ja̱ maca Jesuni i̱ohuaꞌi yëyeje̱ huaija̱ꞌquëre i̱sipi. ");
INSERT INTO seyNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ja̱ maca Jesure que̱jaꞌquëre sajëna, Cirene aquëpi Simón hueꞌequëpi sa̱ñope daina, ti̱ꞌani tse̱ani cua̱ñehuë, Jesure que̱jaꞌcore cruzu hueꞌequë saja̱ꞌquëre cajë Jesupi duꞌru saina. ");
INSERT INTO seyNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ja̱je saina, jai pa̱i tuëꞌë. Cuiꞌne nomiohuaꞌije̱ jai pa̱i oijë cuijë saëꞌë, i̱ni coꞌa ju̱ꞌijë. ");
INSERT INTO seyNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ja̱je oijëna, Jesús ñani capi, ja̱ohuaꞌire: “Jerusalén nomiohuaꞌi oimaꞌpë paꞌijë̱ꞌë, yëꞌëre. Coa ai jerepa mësaruja̱ꞌa cuiꞌne mësaru mamajëni oijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Yequë muꞌse ñeje caye ti̱ꞌajaꞌcoa: ‘Nomiohuaꞌi mamajëre peocohuaꞌi, tsi̱ pamaꞌpë paꞌisicohuaꞌi, cuiꞌne ojeje̱ tso̱samaꞌpë paꞌisicohuaꞌi jerepa sihuaja̱ꞌcohuaꞌi aꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Cajëna, pa̱ipi ca huëoja̱ꞌcohuaꞌi aꞌë, ai cu̱tire: ‘Yëquëna quë̱ñojëꞌë’ cuiꞌne aꞌri cu̱tihuë̱are caja̱ꞌcohuaꞌi aꞌë, ‘Yahuejë̱ꞌë, yëquëre.’ ");
INSERT INTO seyNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Huajë so̱quë yëje̱ paꞌini yëꞌëre jaiye yoꞌoni me mësarute pa̱jaꞌcohuaꞌi aꞌni cue̱nisi so̱quë yëje̱ paꞌiohuaꞌire.” ");
INSERT INTO seyNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Jesús ja̱ꞌre co̱ni huaija̱ꞌcohuaꞌire caya pa̱ire sahuë, coꞌamaña yahue ñacohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ja̱ maca Pa̱i Si̱opë hueꞌyosi hue̱ꞌñana ti̱ꞌani Jesure que̱huë. Cuiꞌne caya coꞌa pa̱ire co̱ni, yequëni i̱ ëja te̱ꞌtena cuiꞌne yequëni i̱ ari te̱ꞌtena nëcohuë. ");
INSERT INTO seyNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ja̱ maca i̱te que̱jëna, Jesupi capi: “Jaꞌquë oijë̱ꞌë, ja̱ohuaꞌire i̱ohuaꞌi yoꞌoye huesëjë yoꞌocohuaꞌire.” Soldado pa̱ipi Jesús juꞌi ca̱re dutani sa̱ꞌñe i̱ohuaꞌija̱ꞌa nepi, i̱ote paja̱ꞌcohuaꞌi aꞌni cajë yoꞌohuë. ");
INSERT INTO seyNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ja̱je yoꞌojëna, pa̱ipi ai ñahuë. Cuiꞌne pa̱i ëjaohuaꞌique cueꞌcuejë cahuë: “Yecohuaꞌire huasopi. Yuretaꞌa coꞌye huasoyere paji, nuñerepa Cristo Maijaꞌquë tse̱quërepa pani coꞌye huasoye paꞌini.” ");
INSERT INTO seyNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Cuiꞌne soldado pa̱ije cueꞌcuejë i̱te oꞌsa cuiyaꞌi co̱nore o̱cuasiꞌi cajë yoꞌohuë. ");
INSERT INTO seyNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ja̱je yoꞌojë i̱te cahuë: “Judío pa̱i ëjaë pani mëꞌëjaꞌa coꞌye huasojë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Cuiꞌne i̱ si̱opë ë̱mëjeꞌere toyasico pacoꞌë, griego, latín cuiꞌne hebreo cocapi ñeje: IQUË JUDÍO PA̲I ËJAËPI. ");
INSERT INTO seyNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Coꞌaye yoꞌocohuaꞌi aquëre que̱ deosiquëpi i̱ti maca dequëpi tea ju̱ꞌi coꞌaye capi, ñeje: “Mëꞌëpi Cristorepa pani mëꞌëjaꞌa coꞌye huasoni jeteyoꞌje yëquëre huasojë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ja̱je caquëna, yequëpi i̱ cajeire capi camaꞌë: “¿Maijaꞌquëre caꞌramaꞌquë, mëꞌëje cuiꞌne ju̱ꞌijaꞌquë me casiꞌni? ");
INSERT INTO seyNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Mai cato nuñerepa coꞌaye yoꞌocohuaꞌipi yoꞌo cua̱ñoñë, ja̱re mai coꞌaye yoꞌosi doꞌire sa̱ijë. Ja̱je paꞌiquëtaꞌare iquë ti coꞌaye yoꞌomaꞌquëpi yoꞌo cua̱ñoji, ñaquë mëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Cani ja̱ maca capi: “Jesús hua̱nëyemaꞌë paꞌijë̱ꞌë, yëꞌëre mëꞌë cua̱ñe huëo maca.” ");
INSERT INTO seyNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Caquëna, Jesupi capi, i̱te: “Nuñerepa cayë, mëꞌëre. Yurepi yëꞌë ja̱ꞌre co̱ni paꞌija̱ꞌquë aꞌë, deꞌo hue̱ꞌñare.” ");
INSERT INTO seyNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Muꞌse joporepa paꞌi maca siꞌa yeja ñamije paꞌiorepa deꞌopi, tres paꞌi macaja̱ꞌa naꞌiquëna. ");
INSERT INTO seyNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ë̲sëje̱ miañe pa̱ni cuiꞌne ta̱ꞌtëpo ca̱pi Maijaꞌquëre se̱ huëꞌe Maijaꞌquë paꞌi sito tëhuosicoje̱ jopore paja̱ꞌa tsata sajiꞌi, ë̱mëjeꞌepi meñe huëꞌehuëre pana. ");
INSERT INTO seyNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ja̱ maca Jesupi cuipi: “Jaꞌquë, Jaꞌquë yëꞌë joyo mëꞌëna i̱si nëoñë.” Ja̱je cani ju̱ni huesëpi. ");
INSERT INTO seyNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ja̱ maca capitán, romanopi iye yoꞌoseꞌere ñani Maijaꞌquëre sihuaquë capi: “Nuñerepa iquë ti coꞌaye yoꞌomaꞌquë pajiꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Siꞌahuaꞌi ja̱ maca paꞌisicohuaꞌipi i̱te yoꞌoseꞌere ñani quëquë huesëjë coti saihuë̱ana tëꞌcajë saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ja̱je saijëtaꞌare siꞌahuaꞌi Jesús ñacohuaꞌipi cuiꞌne nomiohuaꞌi Galileapi tuisicohuaꞌipi soꞌona pëani ñahuë, iye yoꞌoye. ");
INSERT INTO seyNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Pajiꞌi, teꞌi nuñerepa yoꞌoquëpi i̱ mami José hueꞌequëpi, Judea yejare Arimatea daripëre paꞌiquë. Ja̱ë cato judío pa̱i ëjaohuaꞌi aquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Iquë José cato Maijaꞌquë te̱ꞌte aye yoꞌoye ñasiꞌi cuasaquë utequë pajiꞌi. Ja̱je paꞌipi yequë ëjaohuaꞌi Jesure huai ja̱ꞌñere cajëna, teꞌe cuiꞌne cuasaye pa̱pi. ");
INSERT INTO seyNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ja̱je paꞌina, ëjaëpi Pilatore sani se̱jiꞌi, Jesús ca̱pë ta̱ ja̱ꞌñere caquë. ");
INSERT INTO seyNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Cruzu dequëre casani jai ca̱ñapi ca̱ꞌneni quë̱na yejana coje nesicona o̱api, ja̱ yëꞌtaꞌa pa̱ire ta̱maꞌa cojena. ");
INSERT INTO seyNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Huajë muꞌse paꞌija̱ꞌconi ne deꞌhua muꞌse pajiꞌi. Ja̱ muꞌse cato tsoe huëoye jaꞌi maca paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galileapi Jesure nomiohuaꞌi tuisicohuaꞌipi sani ta̱si daripë ñahuë, me o̱areꞌni, i̱ ca̱pë cajë. ");
INSERT INTO seyNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ñani ja̱ maca huëꞌena coꞌini huëo së̱ maꞌña ne deꞌhuahuë. Ne deꞌhuani huajë muꞌse huajëhuë, i̱ti cua̱ñeseꞌe paꞌiyeje̱. ");
INSERT INTO seyNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Duꞌru macarepa coꞌamaña ne muꞌse paꞌi maca cuiꞌnaohuaꞌipi saëꞌë, ta̱si daripë quëꞌrona nea hue̱ꞌñarepa huëo së̱ñe ne deꞌhuaseꞌere sajë. Cuiꞌne yecohuaꞌi nomiohuaꞌi co̱ni saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ja̱ maca ti̱ꞌajë ñajëna, quë̱na pë daripë si̱osicopi ti̱rore paꞌiona, ti̱ꞌahuë. ");
INSERT INTO seyNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ti̱ꞌani cacajë Ëjaë Jesús ca̱përe ti̱ꞌamaꞌpë. ");
INSERT INTO seyNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Peoquëna, ai quëquëhuë, me neiꞌni cajë. Ja̱je quëquëjë ñajëna, ja̱rote caya ë̱mëohuaꞌi mia juꞌi ca̱ña juꞌicohuaꞌipi i̱ohuaꞌi ja̱ꞌre co̱ni nëcahuë. ");
INSERT INTO seyNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ja̱je ña quëquëni yejare pana në me huesëjëna, ñajë ja̱ohuaꞌipi, cahuë: “¿I̱quere coꞌeyeꞌni, ju̱ꞌisicohuaꞌi quëꞌro? Tsoe huajëquëpi paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","I̱ñore paꞌimaꞌë paꞌiji. Tsoe huëjiꞌi. Cuasajë̱ꞌë. Ja̱ yëꞌtaꞌa Galilea paꞌimaꞌca i̱ caꞌñere, ");
INSERT INTO seyNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ñeje: ‘Pa̱i Mamaquë coꞌaye yoꞌocohuaꞌi jë̱ñana i̱sisiquë paꞌija̱ꞌquë api. Paꞌina, ja̱ohuaꞌipi que̱jaꞌcohuaꞌi aꞌë, so̱quë sarahuana. Ja̱je yoꞌosiquëtaꞌa toaso̱ muꞌseña paꞌi maca huajëquë huëija̱ꞌquë api.’ Tsoe ja̱re quëapi”. ");
INSERT INTO seyNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ja̱je caëna, ja̱ maca Jesús caꞌñe cuasa ñajaëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ja̱ jeteyoꞌje daripë ñasicohuaꞌipi coꞌini siꞌaye i̱ohuaꞌi ñaseꞌere quëahuë, once soisicohuaꞌire cuiꞌne siꞌahuaꞌi i̱ti maca co̱ni paꞌicohuaꞌireje̱. ");
INSERT INTO seyNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Iye coca i̱ soisicohuaꞌire sani quëasicohuaꞌi cato paëꞌë: María Magdalena, Juana, María, Jacobo pëca jaꞌco, cuiꞌne yequë nomiohuaꞌi co̱ni. ");
INSERT INTO seyNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ja̱je quëajëna, i̱ soisicohuaꞌipi ja̱ohuaꞌi quëaye asani sehuomaꞌpë paëꞌë, coa cuepejë cayeje̱ paꞌye nëina. ");
INSERT INTO seyNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ja̱je nuñerepa cayë cuasamaꞌquëtaꞌa Pedropi etani huëꞌhuëquë sajiꞌi, ta̱si daripëre ñasiꞌi caquë. Sa ti̱ꞌani ñaquëna, i̱te ca̱ꞌnesi ca̱ña ti̱rona ne saoseꞌepi pajiꞌi. Paꞌina, ñani ai cuasaquë sajiꞌi, huëꞌena. ");
INSERT INTO seyNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ja̱re ja̱ muꞌse caya ë̱mëohuaꞌi Emaús daripëna saëꞌë, Jerusalénpi once kilómetro sai hue̱ꞌñana. ");
INSERT INTO seyNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Saijë Jesús ayere cajë saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ja̱je cajë saijëna, ja̱re i̱pi Jesús ja̱ohuaꞌire tsioja̱jiꞌi. Tsioja̱ni i̱ohuaꞌi ja̱ꞌre co̱ni sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Saina, aꞌri maña carapi, i̱ohuaꞌi ña ti̱ꞌare paye i̱te. ");
INSERT INTO seyNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ja̱ maca sai Jesupi ja̱ohuaꞌire se̱jiꞌi: “¿I̱quere sa̱ꞌñe cajë saiyeꞌni, maꞌajaꞌa saini? ¿Me yoꞌojë oicohuaꞌi paꞌiyeꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Caquëna, ja̱ohuaꞌi aquë Cleofas hueꞌequëpi sehuopi, i̱te: “Siꞌa yeja Jerusalén daripë iye muꞌse yoꞌoseꞌe asayë. ¿Ja̱je paꞌiquëtaꞌare cuiꞌne mëꞌëseꞌe i̱ti hue̱ꞌña paꞌinije asamaꞌë pani se̱quë?” ");
INSERT INTO seyNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Caquëna, ja̱ maca i̱pi capi, i̱te: “¿Me yoꞌoreꞌni?” Caquëna, i̱ohuaꞌipi cahuë: “Jesús Nazaret aquëpi, Maijaꞌquëre quëacaiquëpi, siꞌaye tutu quëꞌipi cuiꞌne i̱ cayeje̱ Maijaꞌquë ña hue̱ꞌñana, nuñerepa caquëpi siꞌa pa̱i ña hue̱ꞌñana caquëre pare yoꞌoseꞌere cayë. ");
INSERT INTO seyNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ja̱je paꞌini, que̱ni huani je̱ohuë, Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌi maire cua̱ñecohuaꞌi cuiꞌne siꞌa ëjaohuaꞌi huani je̱oñe paꞌiji cajëna. ");
INSERT INTO seyNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Yëquë cato ja̱ëpi Israel pa̱ire huasoja̱ꞌquë api cajë utecohuaꞌi paëꞌë. Yure ja̱je paꞌijëna, siꞌaye iye coꞌaye yoꞌohuë, coa toaso̱ muꞌseña i̱te yoꞌoseꞌe tëtosaiji, yure. ");
INSERT INTO seyNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ja̱je yoꞌoseꞌe paꞌitoje̱ ai jerepa ai cuasaye paꞌiji. Yëquë ja̱ꞌre co̱ni nomiohuaꞌi paꞌicohuaꞌipi nea hue̱ꞌñarepa sani ña quëquëhuë, ta̱si daripë. ");
INSERT INTO seyNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Jesús ca̱pë peoco paꞌina, ja̱je ñani ja̱ohuaꞌipi dani yëquëre quëahuë. Huëo ca̱ni ñañeje paꞌye hui̱ñaohuaꞌire ñajëna, ja̱ohuaꞌipi Jesús huajëquëpi paꞌiji cahuë cajë. ");
INSERT INTO seyNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ja̱ jeteyoꞌje yëquë cajeohuaꞌije̱ ta̱si daripëre sani ñajëna, ja̱re ja̱je nomiohuaꞌi caseꞌeje̱ paꞌye paꞌina, ti̱ꞌani ñahuë. Jesuretaꞌa ñamaꞌpë paëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ja̱je quëaquëna, ja̱ maca Jesupi capi, ja̱ohuaꞌire: “Asa ti̱ꞌamaꞌcohuaꞌire paꞌni, mësaru. Je yëhua asani sehuoja̱ꞌcohuaꞌi aꞌni Maijaꞌquëre quëacaicohuaꞌi cajë paꞌiseꞌe. ");
INSERT INTO seyNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Mësarupi cuasato Cristo ai yoꞌoye paja̱ꞌquë paquë siꞌaye iye ja̱ yëꞌtaꞌa i̱ deꞌo hue̱ꞌñarepa saimaꞌë pani?” ");
INSERT INTO seyNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ja̱je se cani ja̱ maca quëa huëopi, siꞌaye i̱te yoꞌo ja̱ꞌñere cajë toyaseꞌere. Moisés toyaquë paꞌiseꞌepi huëoni cuiꞌne yecohuaꞌi Maijaꞌquë quëaquëna, toyasicohuaꞌi toyajë paꞌiseꞌe co̱ni quëapi. ");
INSERT INTO seyNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","I̱ohuaꞌi cajë saisi daripëna ti̱ꞌani, Jesús ja̱ yëꞌtaꞌa i̱ sai hue̱ꞌña sasiꞌi caquë yoꞌoyeje̱ yoꞌopi. ");
INSERT INTO seyNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ja̱je yoꞌoquëna, ja̱ohuaꞌipi soihuë: “Yëquë ja̱ꞌre co̱ni pëajë̱ꞌë naꞌiji, coa ñami deꞌo tëjiji.” Asani ja̱ maca Jesús i̱ohuaꞌi ja̱ꞌre co̱ni cacani pëapi. ");
INSERT INTO seyNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Pëasiquëpi a̱o a̱i saihuëna i̱ohuaꞌi ja̱ꞌre co̱ni jaꞌrusi maca i̱pi panpë i̱ni Maijaꞌquëre se pëpani jëyoni jëꞌyequë ja̱ohuaꞌire a̱opi. ");
INSERT INTO seyNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ja̱je i̱ yoꞌo maca ña ti̱tahuë, i̱re papi cuasajë. Ja̱je cuasa maca tsoe peo hue̱ꞌña huesëpi. ");
INSERT INTO seyNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ja̱ maca i̱ohuaꞌija̱ꞌa sa̱ꞌñe cahuë: “Maipi asahuë, mai joñoa ai sihua ëaye nëiñe, maꞌajaꞌa dai toyaseꞌere i̱pi quëaquëna.” ");
INSERT INTO seyNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ja̱je ñani ti uteye peoyerepa maꞌajaꞌa dai huëoni daëꞌë, cuiꞌnaohuaꞌipi Jerusalénna. Ti̱tajëna, ja̱rote paëꞌë, once Jesús soicohuaꞌi tsiꞌsisicohuaꞌipi i̱ohuaꞌi cajeohuaꞌi ja̱ꞌre co̱ni. ");
INSERT INTO seyNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Paꞌijëna, ti̱tani asajëna, ja̱ohuaꞌije̱ cahuë: “Nuñerepa Jesús huëjiꞌi. Cuiꞌne i̱seꞌere i̱ñopi, Simónre.” ");
INSERT INTO seyNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Cajëna, ja̱ maca i̱ohuaꞌije̱ quëahuë, maꞌajaꞌa saijëna, yoꞌoseꞌere. Cuiꞌne Jesupi panre jëꞌyequëna, ñani i̱te ña ti̱taseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ja̱ yëꞌtaꞌa i̱ti yoꞌoseꞌere cajëna, Jesús i̱ohuaꞌi jopore pana ñai nëcapi. Ja̱ maca pëpapi, ñeje caquë: “Deꞌoye paꞌija̱ꞌcohuaꞌi aꞌë, mësaru.” ");
INSERT INTO seyNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Caquëna, ja̱ohuaꞌipi ai quëquë huesëhuë, i̱ paꞌisi joyore ñañë cuasajë. ");
INSERT INTO seyNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ja̱je cuasajëna, Jesupi ja̱ohuaꞌire capi: “¿Me yoꞌojë quëquë huesësicohuaꞌi paꞌiyeꞌni? ¿Me yoꞌojë mësaru joñoa jëa coeyeque hueꞌeyeꞌni? ");
INSERT INTO seyNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ñajëꞌë, yëꞌë jë̱ñare cuiꞌne yëꞌë quë̱ore. Ja̱re yëꞌë i̱ aꞌë, mësaru ñasiquërepa. Patoni cuiꞌne ñajëꞌë. Joyo cato ca̱pë cuiꞌne tara peocoa. Mësarupi yëꞌëre ñajëtaꞌa ca̱pë tara hueꞌequë paꞌiye. Yëꞌë aꞌë, me joyo paꞌiyeꞌni.” ");
INSERT INTO seyNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ja̱je cani ja̱ohuaꞌire i̱ñopi, jë̱ña cuiꞌne quë̱o i̱te que̱seꞌere. ");
INSERT INTO seyNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ja̱je yoꞌoquëna, ja̱ yëꞌtaꞌa i̱re papi cuasaye pa̱huë, ai sihua doꞌire, cuiꞌne quëquë doꞌire. Ja̱je paꞌina, Jesupi ja̱ohuaꞌire capi: “¿A̲i maña paye, i̱ño?” ");
INSERT INTO seyNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Caquëna, i̱ni i̱sihuë, tsiaya huaꞌi tsaro sëyosiconi. ");
INSERT INTO seyNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","I̱sijëna, i̱ni i̱ohuaꞌique ñajëna, a̱jiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ja̱ jeteyoꞌje capi, ja̱ohuaꞌire: “Ja̱ yoꞌoseꞌe cato yëꞌë mësaru ja̱ꞌre ja̱ yëꞌtaꞌa co̱ni paꞌi caseꞌere yoꞌohuë. Siꞌaye Moisés cua̱ñeseꞌe cuiꞌne Maijaꞌquëre quëacaicohuaꞌi toyaseꞌe, cuiꞌne Salmos toyaseꞌe siꞌaye ti̱ꞌañe pajiꞌi. Me paquëꞌni, nuñerepa caseꞌe. Ja̱je paꞌina, yoꞌohuë.” ");
INSERT INTO seyNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ja̱ cato quëapi, toyaseꞌe cayere nuñerepa asa ti̱ꞌajajë caquë. ");
INSERT INTO seyNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ja̱je paꞌina, quëaquë ja̱ohuaꞌire capi: “Ñeje toyaseꞌe paꞌiji. Cristo ai yoꞌoquë ju̱ni huesëye paꞌiji. Ja̱je ju̱ꞌisiquëtaꞌa toaso̱ muꞌseña paꞌi maca cuiꞌnaëpi huëija̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ja̱je paꞌina, Cristo mamire cajë quëaye paꞌiji. Siꞌa hue̱ꞌña paꞌicohuaꞌire Jerusalén pa̱ire quëa huëoye paꞌiji. Huëosicohuaꞌipi ñeje cajë: Ja̱ꞌnë cuasaseꞌe je̱oni po̱nëjëꞌë. Ja̱je yoꞌojëna, mësaru coꞌaye yoꞌoseꞌere sa̱i deꞌhuacaiye paꞌija̱ꞌcoa. ");
INSERT INTO seyNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ja̱je paꞌina, mësaru aꞌë, yure iye ñasicohuaꞌirepa. ");
INSERT INTO seyNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","I̱na, yëꞌëpi, jaꞌquë ca nëoseꞌe jëjo daoja̱ꞌquë aꞌë, mësaruna. Ja̱je paꞌina, saimaꞌpë i̱ño Jerusalén daripëre paꞌijë̱ꞌë, maꞌtëmo jëjo dao tuture utejë̱ꞌë, mësaru su̱ña ja̱ꞌñere.” ");
INSERT INTO seyNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jesupi sai sapi, jai daripë Betaniare pana. Ja̱rona jë̱ña mëani Maijaꞌquëre se̱cacajiꞌi, ja̱ohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Deꞌoye paꞌijë̱ꞌë, cani ja̱ohuaꞌire je̱oni maꞌtëmona sa cua̱ñopi. ");
INSERT INTO seyNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ja̱ jeteyoꞌje Maijaꞌquëre se̱ni tëjini coꞌihuë, Jerusalénna ai sihuajë. ");
INSERT INTO seyNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Cuiꞌne siꞌanë Maijaꞌquëre se̱ huëꞌere paꞌijë Maijaꞌquëre deꞌoquë api cajë sihuajë paëꞌë. Deꞌoji. Ca tëjihuë.");
INSERT INTO seyNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ja̱ yëꞌtaꞌa yequë coꞌamaña paꞌimaꞌnë i̱ti coca tsoe pajiꞌi. I̱ti coca cato Maijaꞌquë ja̱ꞌre pajiꞌi. I̱ti coca cato Diusupi. ");
INSERT INTO seyNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Duꞌru huëo macana Maijaꞌquë ja̱ꞌre co̱ni pajiꞌi, i̱ti cocapi. ");
INSERT INTO seyNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","I̱pi Maijaꞌquë ja̱ꞌre co̱ni coꞌamaña deꞌhuapi. Peoji, i̱ deꞌhua maꞌñe, siꞌaye i̱ deꞌhuaseꞌe aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","I̱ni pajiꞌi, ti pani huesëye. Ti pani huesëyepi pa̱ire miacaiye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Iye miañepi nea hue̱ꞌñare pana miacajiꞌi. Miacaina, neañepi ne yayo ti̱ꞌañe pa̱pi. ");
INSERT INTO seyNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Paꞌiji, Maijaꞌquë jëjo daoquë Juan hueꞌequë. ");
INSERT INTO seyNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ja̱ë cato i̱ti miañe ñasiquëpi quëacaiquë pajiꞌi, i̱ cayere care paji cuasani siꞌa pa̱i asaja̱jë caquë. ");
INSERT INTO seyNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan cato miañe peopi. Ja̱ë cato coa miañe ñasiquëpi quëacaiquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nuñerepa siꞌa pa̱ire miacaiyepi iye yejana ti̱tapi. ");
INSERT INTO seyNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","I̱pi Diusu ja̱ꞌre paꞌi iye yeja deꞌhuasiquëtaꞌare iye yeja paꞌicohuaꞌipi i̱re papi cajë asaye pa̱huë. ");
INSERT INTO seyNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","I̱ pa̱ire pana dajiꞌi. Daisiquëtaꞌare i̱ pa̱ipi i̱te deꞌoye sihuajë yoꞌoye pa̱huë. ");
INSERT INTO seyNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ja̱je jai pa̱i pa̱jëtaꞌare deꞌhue teꞌohuaꞌiseꞌe sihuajë i̱te nuñerepa Cristo huasoquë api cuasajë asahuë. Ja̱je i̱te cuasasicohuaꞌini nuñerepa Maijaꞌquë mamajërepa paꞌiye nepi. ");
INSERT INTO seyNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Pa̱i mamajëje paꞌiohuaꞌi peoyë. Diusu mamajë cato, Diusupi necaina, i̱ mamajë deꞌosicohuaꞌi aꞌë. Pa̱i ai deꞌoyepi ai deꞌomaꞌcohuaꞌi aꞌë. Pa̱nitaꞌa coa yëjë yoꞌoyepi ai deꞌoseꞌeje̱ paꞌiohuaꞌi peoyë. ");
INSERT INTO seyNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Cristopi pa̱i deꞌoni mai ja̱ꞌre co̱ni pajiꞌi, pa̱ire oiquëre papi, cuiꞌne nuñerepa paꞌipi. Ja̱je paꞌini i̱ deꞌoquë paꞌiyerepa ñahuë, yëquëpi, Maijaꞌquë Mamaquërepa teꞌi macapi, ai deꞌoquërepa paꞌina. ");
INSERT INTO seyNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ja̱je paꞌina, Juan Cristo doꞌire caꞌa̱jiꞌi, ñeje: “Iquë api, yëꞌë mësarute quëasiquë. Ja̱ëni yëꞌë quëahuë. Yëꞌë jeteyoꞌje daiji, jerepa paꞌi. Yëꞌë peoꞌnë paꞌisiquë caꞌa̱jiꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Deꞌoye paꞌiye ti̱ꞌahuë, i̱ doꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Cua̱ñeseꞌe cato Moisésja̱ꞌa Maijaꞌquëpi i̱siseꞌe aꞌë. Cuiꞌneje pa̱ire oiye, cuiꞌne nuñerepa yoꞌoye cato Jesucristoja̱ꞌa i̱siseꞌe aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Teꞌije̱ Diusure ñasiquë peoji. Coa i̱ mamaquë i̱ ja̱ꞌre co̱ni paꞌiquëseꞌe. Ja̱ëseꞌe ñapi. Maire quëa i̱ñopi, i̱ paꞌiye aye. ");
INSERT INTO seyNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalén paꞌi judío ëjaohuaꞌipi Maijaꞌquë huëꞌe ñacaicohuaꞌire cuiꞌne levitasre jëjo saoreña, Juanre i̱queiꞌni mëꞌë cajë se̱ni asaja̱ꞌcohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ja̱je jëjo saorena, sani se̱jëna, Juanpi ti̱ñarepa quëaëña: “Yëꞌë cato Cristo Maijaꞌquë pa̱ire huasoquë peoyë.” ");
INSERT INTO seyNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ja̱je caquëna, se̱ni co̱reña: “¿Ja̱je paꞌito i̱queiꞌni, mëꞌë, tsoe hue̱ꞌña Maijaꞌquë quëacaiquë paꞌisiquë?” Cajëna, Juanpi caëña: “Pa̱ni.” Yeque se̱ni co̱reña: “Ja̱je paꞌito ¿Maijaꞌquëre quëacaiquë daija̱ꞌquë api ca nëosiquë aë, mëꞌë?” Ja̱je catoje̱ sehuouña: “Pa̱ni.” ");
INSERT INTO seyNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ja̱ maca careña: “¿I̱queiꞌni, ja̱je paꞌito? ¿Me yëquëre jëjo daosicohuaꞌire sani quëaja̱ꞌcohuaꞌi aꞌni? Mëꞌë ayere quëajë̱ꞌë, yëquëre.” ");
INSERT INTO seyNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Cajëna, Juanpi caëña: “Yëꞌë cato yëꞌoseꞌe cue̱ne yejapi cuiquë aꞌë: ‘Nui maꞌarepa huiꞌyojë̱ꞌë, Ëjaë daija̱ꞌa maꞌa.’ Maijaꞌquëre quëacaiquë Isaías caquë paꞌiseꞌeje̱ caquë aꞌë, yëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Juanre sani casicohuaꞌi cato fariseo pa̱ipi jëjo saosicohuaꞌi paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ja̱ohuaꞌipi se̱teña, i̱te: “Cristo peoni, cuiꞌne Elíasje̱ peoni, cuiꞌne Maijaꞌquë jëjo daosiꞌi casiquëje̱ peoni, ¿Me yoꞌoquë cuiꞌne oco doquëꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Cajëna, Juanpi caëña: “Yëꞌë cato oco doquë aë. Ja̱je paꞌiquëtaꞌare mësaru ja̱ꞌre co̱ni paꞌiji, mësaru ña ti̱ꞌamaꞌquëje̱. ");
INSERT INTO seyNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ja̱ë cato yëꞌë jeteyoꞌje daija̱ꞌquë api, yëꞌëre tëto saisiquëpi. Yëꞌë cato doꞌi peoyë, i̱ zapato joyecaiyeque.” ");
INSERT INTO seyNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Iye cato Betábara hueꞌe hue̱ꞌñana yoꞌoseꞌe aꞌë, Jordán tsiaya ë̱së mëi te̱ꞌtena Juan oco do hue̱ꞌñana. ");
INSERT INTO seyNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Se ñatasi muꞌse Jesupi Juan quëꞌrona tsio daina, ñaquë caëña, Juan: “Ñajëꞌë. Iquë api, Maijaꞌquë Yëi ñama iye yeja paꞌicohuaꞌi tayo yoꞌoye nejocaiquë. ");
INSERT INTO seyNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yëꞌë ja̱ëni cahuë: ‘Yëꞌë jeteyoꞌje daiji, yëꞌëre tëto saisiquë. Ja̱ë cato yëꞌë peo maca paꞌisiquë api.’ ");
INSERT INTO seyNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yëꞌëje̱ huesëhuë. I̱queiꞌni cuasahuë. Ja̱je paꞌiquëtaꞌare ocopi dohuë, Israel pa̱ipi ñajajë caquë.” ");
INSERT INTO seyNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Caëña, Juan yequeje̱: “Yëꞌëpi ñahuë, Maijaꞌquë deꞌo joyopi maꞌtëmopi suꞌteje̱ paꞌipi i̱na cajeni pëaquëna. ");
INSERT INTO seyNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Yëꞌë cato ja̱ yëꞌtaꞌa huesëhuë, i̱queiꞌni cuasaquë. Ja̱je paꞌiquëtaꞌare yëꞌëre oco dojë̱ꞌë caquë cua̱ñesiquëpi capi: ‘Mëꞌëpi oco doquë ñaquëna, deꞌo joyopi cajeni i̱na pëasiquëpi. Ja̱ë api, pa̱ire Maijaꞌquë deꞌo joyopi doquë.’ ");
INSERT INTO seyNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ja̱je paꞌina, yëꞌë i̱ti ñasiquëpi quëacaiquë paꞌiyë, Maijaꞌquë Mamaquëre papi caquë.” ");
INSERT INTO seyNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Se ñatasi muꞌse Juan cuiꞌne i̱ yeꞌyacohuaꞌi co̱ni paëꞌë, ja̱ꞌrë paꞌisi macare. ");
INSERT INTO seyNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Paꞌijëna, Jesús da saina, ñaquë Juan capi: “Ñajëꞌë. Ja̱ë api, Maijaꞌquë Yëi ñama.” ");
INSERT INTO seyNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ja̱je Juan caquëna, asani i̱ yeꞌyacohuaꞌipi cayaohuaꞌi Jesure tuteña. ");
INSERT INTO seyNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ja̱je tuijëna, Jesupi asani coꞌye ñani caëña, ja̱ohuaꞌire: “¿I̱quere coꞌeyeꞌni?” Caquëna, i̱ohuaꞌipi careña: “Yeꞌyaquë, ¿Mëꞌë jerona paꞌiquëꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Cajëna, Jesupi capi: “Dani ñajëꞌë, yëꞌë paꞌi hue̱ꞌña.” Caëna, i̱ paꞌi hue̱ꞌñana sani ñani i̱ ja̱ꞌre pëani paëꞌë, cuatro paꞌi maca ti̱ꞌasicohuaꞌipi i̱ti muꞌse naꞌi macaja̱ꞌa. ");
INSERT INTO seyNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Juan caquëna, asani tuisicohuaꞌi aquë cato, teꞌi Andrés pajiꞌi, Simón Pedro yoꞌjei. ");
INSERT INTO seyNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ja̱ yëꞌtaꞌa yeque yoꞌomaꞌnë duꞌru macarepa cato Andrés, majaꞌyë Simónni sani coꞌepi. Ti̱ꞌani capi, i̱te: “Ti̱ꞌahuë, yëquë, Mesías maire huasoquë.” ");
INSERT INTO seyNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ja̱je quëani Andrés sai saëña, Simónre Jesús quëꞌrona. Saquëna, ñani Jesupi caëña: “Mëꞌë cato Jonás mamaquë Simónꞌë. Ja̱je paꞌiquëtaꞌare Cefas hueꞌequë paꞌijë̱ꞌë. Ja̱je cani Pedro caye aꞌë. (Mai coca cani quë̱na pë caye paꞌiji.)” ");
INSERT INTO seyNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Se ñatasi muꞌse Jesús Galilea yeja quëꞌrona sasiꞌi caquë yoꞌoquë, Felipere ti̱ꞌapi. Ti̱ꞌani capi: “Tuijë̱ꞌë, yëꞌëre.” ");
INSERT INTO seyNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Iquë Felipe cato Betsaida daripë aquë pajiꞌi, Andrés cuiꞌne Pedro paꞌi hue̱ꞌña aquë. ");
INSERT INTO seyNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ñani ja̱ maca Felipe Natanaelre coꞌeseꞌe caquë sani ti̱ꞌani i̱te capi: “Ai tsoe Maijaꞌquëre quëacaicohuaꞌi cuiꞌne Moisés toyaquë paꞌisiquëni ñahuë, yëquë. Ja̱ë cato Jesupi José mamaquë Nazaret daripëpi aquë api.” ");
INSERT INTO seyNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Caquëna, Natanaelpi capi: “¿Nazaret daripëpi deꞌo pa̱i eta ti̱ꞌañe paꞌiquë?” Caquëna, Felipepi capi: “Dani ñajëꞌë, i̱ni.” ");
INSERT INTO seyNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natanaelpi Jesús quëꞌrona tsioja̱ina, Jesús capi: “Nuñerepa Israelita macapi daiji, iquë cosoye peoquëpi.” ");
INSERT INTO seyNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ja̱je caquëna, Natanaelpi se̱quëña: “¿Me yëꞌëre ñaquëꞌni?” Caquëna, Jesupi capi: “Ja̱ yëꞌtaꞌa Felipe mëꞌëre soimaꞌnë ñahuë, Higuera so̱quë yë huëꞌehuëre mëꞌë nëca maca.” ");
INSERT INTO seyNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ja̱ maca Natanaelpi capi: “Yeꞌyaquë, mëꞌë cato Diusu mamaquë aꞌë. Judío pa̱i ëjaëre paꞌë, mëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Caquëna, Jesupi sehuopi: “¿Coa Higuera so̱quë yë huëꞌehuëre paꞌi maca ñahuë caseꞌere nuñerepa Ëjaëpi caji caquë asaquë, mëꞌë yëꞌëre? Ai jerepa paꞌyere, mëꞌë ñajaꞌquë aꞌë, jeteyoꞌje.” ");
INSERT INTO seyNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yequeje̱ Jesupi capi, i̱te: “Nuñerepa cayë. Maꞌtëmo huiꞌyosicopi paꞌiona, Diusu hui̱ñaohuaꞌipi mëisicohuaꞌipi cajesicohuaꞌipi Pa̱i Mamaquëni cajë yoꞌojëna, ñajaꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Toaso̱ muꞌseña sa tëto sai maca Caná daripëre hueja fiesta paquëña, Galilea yejare. Ja̱rote Jesús pëca jaꞌcoje̱ pacoña. ");
INSERT INTO seyNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesús cuiꞌne i̱ yeꞌyacohuaꞌi co̱ni hueja fiestana soi cua̱ñoisicohuaꞌipi paꞌijë sateña. ");
INSERT INTO seyNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Cuiyaꞌi oꞌsa caraja̱isi maca, Jesús pëca jaꞌcopi cao: “Cuiyaꞌi oꞌsa yure peoji.” ");
INSERT INTO seyNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Cacona, Jesupi sehuopi: “¿Nomio me yoꞌoco ja̱je yëꞌëre cacoꞌni? Yëꞌë yoꞌo maca ja̱ yëꞌtaꞌa ti̱ꞌañe pa̱ji.” ");
INSERT INTO seyNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ja̱je catoje̱ i̱opi cao, pa̱ire necaicohuaꞌire: “I̱ cayeje̱ yoꞌojë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ja̱rote seis quë̱na yurupë̱a pajiꞌi, judío pa̱i siꞌsi cuya to̱jë yoꞌo yurupë̱a. Teꞌe yurupë cato veinte panitaꞌa veinticinco galones doye pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesupi pa̱ire necaicohuaꞌire capi: “Iye yurupë̱ana ocore doꞌe ti̱mëjëꞌë.” Caëna, doꞌe ti̱mëreña. ");
INSERT INTO seyNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Doꞌe ti̱mërena, Jesupi capi: “Yure cato aꞌri maña doni fiesta yoꞌoye ñacaiquëna sacaijë̱ꞌë.” Caëna, ja̱je yoꞌoreña. ");
INSERT INTO seyNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Sarena, fiesta yoꞌoye ñacaiquëpi, ocopi cuiyaꞌi co̱no deꞌoseꞌere neñapi, huesëquë. I̱ti ñajë ocopi yurupë̱ana dosicohuaꞌiseꞌe ja̱ꞌë cuasahuë. Ja̱je neñani fiesta yoꞌoye ñacaiquëpi huejaquëre soini capi: ");
INSERT INTO seyNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Siꞌa pa̱i duꞌru macarepa cato deꞌo cuiyaꞌi co̱nore pare u̱cucoa. Ai u̱cusi macarepa jeteyoꞌje aꞌri maña deꞌo cuiyaꞌi co̱no o̱cuacoa. Ja̱je paꞌiquëtaꞌare mëꞌë cato ai deꞌo cuiyaꞌi co̱nore pare deꞌhuahuë.” ");
INSERT INTO seyNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesús Caná daripë Galilea yejana pa̱i yoꞌo ti̱ꞌa maꞌñere yoꞌoseꞌe cato duꞌru macarepa yoꞌo i̱ñoseꞌe pajiꞌi, i̱ deꞌoquërepa paꞌiyere. Ja̱je yoꞌouna, i̱te yeꞌyecohuaꞌi i̱re papi cuasahuë. ");
INSERT INTO seyNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Iye yoꞌo tëjisi jeteyoꞌje Capernaum daripëna sajiꞌi, pëca jaꞌco, yoꞌje tsi̱, cuiꞌne i̱ yeꞌyacohuaꞌi co̱ni saijëna. Sani ja̱rona paëꞌë, aꞌri maña muꞌseña. ");
INSERT INTO seyNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Israel pa̱i Egíptopi etajë paꞌiseꞌere cuasajë judío pa̱i yoꞌo muꞌseña ti̱ꞌa tëjiquëna, Jesupi Jerusalénna sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Sani ti̱ꞌapi, Maijaꞌquë huëꞌere curiquë neñuꞌu cajë duruhue̱quëre i̱sicohuaꞌi, cuiꞌne yëi ñamare i̱sicohuaꞌi, cuiꞌne suꞌtere i̱sicohuaꞌi cuiꞌne curiquë cambiacohuaꞌi jaꞌrusicohuaꞌipi ñuꞌijëna, ñani. ");
INSERT INTO seyNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jesupi i̱ohuaꞌire siꞌseja̱ꞌcore neni yuretaꞌa siꞌa pa̱ire coꞌamaña i̱sicohuaꞌire yëi ñamare cuiꞌne hue̱quëre co̱ni teꞌepi curiquë cambiajë ñuꞌicohuaꞌini eto saoni i̱ohuaꞌi curi topë̱a je̱a ñaꞌñe saocai, cuiꞌne mesa saihuë̱aje jëꞌje ta̱ño saocajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Suꞌtere i̱sicohuaꞌini capi: “¡Eto saojë̱ꞌë, i̱ño pamaꞌpë! ¡Yëꞌë Jaꞌquë huëꞌere coꞌamaña huero huëꞌe neni yoꞌomaꞌpë!” ");
INSERT INTO seyNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ja̱ maca i̱ yeꞌyacohuaꞌipi toyaseꞌe cayere cuasa ñajateña, ñeje cayere: “Siꞌaye yëꞌë paꞌiye mëꞌë huëꞌere cuasani ñacai yoꞌoyë.” ");
INSERT INTO seyNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ja̱ maca judío pa̱ipi Jesure se̱iꞌë: “¿I̱quepi mëꞌë i̱ñojaꞌquë aꞌni, mëꞌë cua̱ñequë paꞌiye iye yoꞌoquë?” ");
INSERT INTO seyNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Cajëna, Jesupi sehuopi: “Nejojëꞌë, iye huëꞌere. Ja̱je yoꞌojëna, yëꞌëpi coa toaso̱ muꞌseñapi nesiꞌi, cuiꞌnaoni.” ");
INSERT INTO seyNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Caquëna, judío pa̱ipi careña: “Cuarenta y seis o̱metëcarepa nesicore ¿me mëꞌëpi coa toaso̱ muꞌseñapi huëꞌe nesiꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ja̱je Jesús cani i̱ ca̱përe capi, huëꞌere pare caye pa̱pi. ");
INSERT INTO seyNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ja̱je paꞌina, Jesús ju̱ꞌisiquëpi huëisi maca i̱ yeꞌyacohuaꞌipi cuasa ñajateña, i̱ iye caseꞌere. Cuiꞌne ja̱ maca toyaseꞌe caseꞌeje̱ nuñerepa care paꞌë cajë asahuë. ");
INSERT INTO seyNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesús Jerusalénre paꞌi pa̱i yoꞌo ti̱ꞌa maꞌñere yoꞌoquëna, ñani jai pa̱i i̱te i̱re papi cajë asahuë, Israel pa̱i Egíptopi etaseꞌere cuasajë yoꞌo fiesta paꞌi maca yoꞌoquëna. ");
INSERT INTO seyNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ja̱je paꞌiquëtaꞌare Jesús cato pa̱i cuasayere ñani pa̱i nuñerepa cayë cuasaye pa̱pi, siꞌaye pa̱i cuasaye ñaquë sëte. ");
INSERT INTO seyNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Pa̱ipi i̱te dani ja̱je yoꞌoquë api iquë cajë quëa ti̱ꞌañe peopi, tsoe i̱seꞌe asapi, pa̱i joyo cuasajë paꞌiye. ");
INSERT INTO seyNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Pajiꞌi, teꞌi fariseo Nicodemo hueꞌequë. Ja̱ë cato ëjaërepa pajiꞌi, judío pa̱i aquë. ");
INSERT INTO seyNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ja̱je paꞌipi Nicodemo ñami Jesure ñasiꞌi caquë, sani capi, i̱te: “Yeꞌyaquë, asayë, mëꞌëre Diusupi yeꞌyaja̱ꞌquëre jëjo daosiquëpi paꞌi, pa̱i yoꞌo ti̱ꞌa maꞌñere yoꞌoquë tutu i̱ñoquë cuiꞌne siꞌaye yoꞌoquëna. Pa̱iseꞌe paꞌini ja̱je yoꞌo ti̱ꞌañe peoji, Diusupi co̱ni yoꞌoye pa̱to.” ");
INSERT INTO seyNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Caquëna, Jesupi capi, i̱te: “Nuñerepa mëꞌëre cayë, pëca jaꞌcoja̱ꞌa tëꞌya daiseꞌeje̱ paꞌye ti̱jupë tëꞌya dani cua̱ñomaꞌquë pani Maijaꞌquë cua̱ñe te̱ꞌte ñañe peoji.” ");
INSERT INTO seyNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Caquëna, Nicodemopi se̱jiꞌi, i̱te: “¿Me ja̱je aipi pëca jaꞌcona caca co̱ni tëꞌya dani cua̱ñoñe paꞌiquëꞌni? ¿Me ja̱je yoꞌoye paꞌiquëꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Caquëna, Jesupi sehuopi: “Nuñerepa mëꞌëre cayë. Cuiꞌnaëpi pëca jaꞌco tëꞌya daiseꞌeje̱ paꞌye ocopi cuiꞌne joyopi tëꞌya dani cua̱ñomaꞌquë cato Maijaꞌquë cua̱ñe te̱ꞌte cacaye peoji. ");
INSERT INTO seyNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Pëca jaꞌquëohuaꞌi pa̱ipi parena, tëꞌya daisicohuaꞌi cato ja̱re pa̱i paꞌiyë. Joyopi tëꞌya daisicohuaꞌi cato ja̱re joyo acohuaꞌi paꞌiyë. ");
INSERT INTO seyNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ai cuasamaꞌë paꞌijë̱ꞌë. Yëꞌëpi ñeje cato: ‘Siꞌa pa̱i huajëye ai deꞌoye paꞌiji.’ ");
INSERT INTO seyNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Tutu cato siꞌa hue̱ꞌña daicoa, i̱o pi̱siyeseꞌe asajëna. Ja̱je paꞌiquëtaꞌare huesëyë, i̱o dai hue̱ꞌña cuiꞌne i̱o sai hue̱ꞌñaje. Siꞌa joyopi tëꞌya daisicohuaꞌi cato, tutuje̱ paꞌiohuaꞌi paꞌiyë.” ");
INSERT INTO seyNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ja̱je caquëna, Nicodemopi se̱jiꞌi: “¿Me ja̱je yoꞌoye paꞌiquëꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Se̱ina, Jesupi sehuopi: “¿Mëꞌë judío pa̱ire yeꞌyaquëre pataꞌa huesëquëꞌni, iye? ");
INSERT INTO seyNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nuñerepa mëꞌëre cayë, yëquë asayere, cuiꞌne i̱ti ñaseꞌere quëayë. Ja̱je paꞌiquëtaꞌare mësarupi nuñerepa cayë cajë asaye pa̱ñë. ");
INSERT INTO seyNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Iye yeja ayere quëaquëna, asamaꞌpë pani ai jerepa asaye peoji, yëꞌëpi maꞌtëmo ayere quëato. ");
INSERT INTO seyNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Pa̱i mañaje maꞌtëmo mëni ñamaꞌcohuaꞌi aꞌë. Coa i̱ti hue̱ꞌñapi Pa̱i Mamaquë daisiquëseꞌe asaji, maꞌtëmo aquëseꞌe. ");
INSERT INTO seyNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moisés a̱ñare cue̱ne yejana neni so̱quë tarapëna tëoni huëo nëcoquë paꞌiseꞌeje̱ cuiꞌne Pa̱i Mamaquëje̱ huëo nëco cua̱ñojaꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Siꞌahuaꞌi i̱te se̱cohuaꞌipi ne huesëmaꞌpë ti pani huesëyere paja̱jë caquë. ");
INSERT INTO seyNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Siꞌa pa̱ire oi doꞌire Maijaꞌquëpi i̱ mamaquë teꞌi macani i̱sipi, siꞌa pa̱i i̱te, nuñerepa i̱re papi, cajë cuasacohuaꞌipi ne huesëmaꞌpë, ti pani huesëja̱jë caquë. ");
INSERT INTO seyNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Diusu mamaquëre jëjo daomaꞌë pajiꞌi, pa̱ire nejojaꞌquëni. Jëjo daopi, huasoja̱ꞌquëni. ");
INSERT INTO seyNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Diusu mamaquëre nuñerepa i̱ api caquë cuasaquëpi nejosiquë peoji. Ja̱je paꞌiquëtaꞌare i̱re papi caquë cuasamaꞌquëpi nejosiquë paꞌiji, Diusu mamaquëre asamaꞌ doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","I̱re papi cajë cuasamaꞌcohuaꞌi cato nejosicohuaꞌi aꞌë, miañepi iye yejana daisiquëtaꞌa nea hue̱ꞌñare miañe jerepa yëhuë, i̱ohuaꞌi yoꞌoyepi coꞌa doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Siꞌa pa̱i coꞌayere yoꞌocohuaꞌipi miañere coecohuaꞌi aꞌë, i̱ohuaꞌi yoꞌoyepi ti̱ñarepa ña cua̱ñomaꞌquëni cajë. ");
INSERT INTO seyNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ja̱je paꞌiquëtaꞌare deꞌoyerepa yoꞌojë paꞌicohuaꞌipi tsio daiyë, miañena. I̱ohuaꞌi yoꞌoye cato Diusupi yëni co̱caina, yoꞌoye aꞌë cajë i̱ñoñuꞌu cajë.” ");
INSERT INTO seyNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ja̱ jeteyoꞌje Jesús i̱ yeꞌyacohuaꞌi ja̱ꞌre co̱ni Judea yejana sajiꞌi. Ja̱rote tsoe maca i̱ohuaꞌi ja̱ꞌre paꞌi oco doquë yoꞌopi. ");
INSERT INTO seyNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juanje ja̱ muꞌseña cato Enón quëꞌrore oco doquë pajiꞌi, Salim jaꞌye macare, ja̱rote ocoje̱ ai paꞌi doꞌire. Siꞌa pa̱i i̱ quëꞌro daisicohuaꞌi oco do cua̱ñosicohuaꞌi paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Iye cato ja̱ yëꞌtaꞌa Juanre tse̱ani comaꞌnë yoꞌoseꞌe aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ja̱ maca Juan yeꞌyacohuaꞌi acohuaꞌipi judío pa̱i ja̱ꞌre sa̱ñope yoꞌojë careña, siꞌsi tsoa to̱ñe ayere cajë. ");
INSERT INTO seyNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ja̱ohuaꞌipi Juanre sani careña: “Yeꞌyaquë, asajë̱ꞌë, mëꞌë ja̱ꞌre co̱ni Jordán tsiaya oco doquë paꞌisiquëpi, mëꞌë yëquëre quëasiquëpi. Yure cato ocore doquëna, jai pa̱i i̱seꞌena saiyë.” ");
INSERT INTO seyNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Cajëna, Juanpi capi, ja̱ohuaꞌire: “Maijaꞌquëpi i̱simaꞌquë paꞌito yecohuaꞌije̱ ja̱je yoꞌo tutu paye peoji. ");
INSERT INTO seyNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ti̱ñarepa yëꞌë quëahuë, mësarute. Cristo peoyë caquë, cuiꞌne quëahuë yëꞌë cato i̱te ne deꞌhuacaiquë duꞌru jëjo daosiquë aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Se ñajëꞌë, cuiꞌne hueja fiesta je̱ꞌquë huejaja̱ꞌcore paquë api, i̱ti huejaquërepa. Huejaquë cajei cato cocare asaquë, sihuaquë ñuꞌiquë api. Ja̱je yëꞌëje̱ yure asaquë sihuayë, i̱ ayere cajëna. ");
INSERT INTO seyNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ja̱ë cato jero saꞌana jerepa paꞌi paꞌija̱ꞌquë api, yëꞌë cato coa jero saꞌna doꞌi peoquë deꞌoja̱ꞌquë aë.” ");
INSERT INTO seyNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ë̲mëjeꞌpi daiquë cato siꞌa pa̱ire tëto saisiquë api. Iye yeja aquë cato ja̱re iye yeja aquë api. Ja̱je paꞌina, yeja cocare caji. Ja̱je paꞌiquëtaꞌare maꞌtëmo daiquë api, siꞌa pa̱i jerepa paꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ja̱je paꞌina, ñaseꞌere cuiꞌne asaseꞌere quëaji. Quëaquëtaꞌare pa̱ipi nuñerepa caji cajë asaye pa̱ñë, i̱ cayere. ");
INSERT INTO seyNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nuñerepa caji caquë cuasasiquë pani, Maijaꞌquë nuñerepa caquë api cacaiji. ");
INSERT INTO seyNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ja̱je paꞌina, Maijaꞌquë jëjo daosiquë cato Maijaꞌquë cocare caji, Maijaꞌquë ë̱seye peoyerepa i̱ deꞌo joyore i̱siquëna. ");
INSERT INTO seyNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Pëca jaꞌquë oiji, i̱ mamaquëre. Ja̱je paꞌina, siꞌaye i̱ jë̱ñaseꞌena je̱opi, yoꞌoja̱quë caquë. ");
INSERT INTO seyNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Pa̱i Mamaquëre i̱re papi caquë cuasaquëpi ti pani huesëja̱ꞌquë api. Ja̱je paꞌiquëtaꞌare asamaꞌë coequë cato ja̱ paꞌiye peoji. Peoquëpi coa ai jerepa Maijaꞌquë pë̱i sa̱iñena sa̱i cua̱ñejaꞌquë api, coꞌayerepa. ");
INSERT INTO seyNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jesupi Juan se̱ña maca i̱te tuicohuaꞌire paquëpi cuiꞌne jai pa̱ire oco doquë yoꞌoji asareña, fariseo pa̱i. ");
INSERT INTO seyNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Nuñerepa Jesupi oco doye pa̱pi. Coa i̱ yeꞌyacohuaꞌipi oco dohuë. ");
INSERT INTO seyNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ja̱je Jesús asani Judea yejapi etapi, Galileana sasiꞌi caquë. ");
INSERT INTO seyNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Coꞌi maca Samaria yejaja̱ꞌa tëto saiye pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Paꞌina, daiquëpi Samaria yeja daripë Sicar ti̱tapi, Jacobo mamaquë Josére yeja i̱siquë paꞌisico quëꞌrona. ");
INSERT INTO seyNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ja̱rote Jacobo oco coje pajiꞌi. Maꞌajaꞌa dai jëꞌjosiquë sëte Jesús oco coje yëꞌquë macana jaꞌrupi. Muꞌse joporepa pajiꞌi, ja̱ maca cato. ");
INSERT INTO seyNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Yeꞌyacohuaꞌipi pa̱i daripëna a̱iñe hueroñuꞌu cajë saëꞌë. Satena, ja̱ maca teꞌi ñuꞌina, Samaria nomiopi oco easiꞌi caco dacoꞌë. Dacona, Jesupi capi: “Ocore i̱sijë̱ꞌë, yëꞌëre.” ");
INSERT INTO seyNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ja̱je caquëna, Samaria nomiopi sehuoo: “¿Mëꞌë judío pa̱itaꞌa, me yoꞌoquë yëꞌë Samaria nomioni oco hueroquëꞌni?” (Judío pa̱i cato Samaria pa̱ire tsiomaꞌcohuaꞌi aꞌë.) ");
INSERT INTO seyNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ja̱ maca Jesús sehuopi: “Diusu mëꞌëre i̱siye asaco pani, cuiꞌne mëꞌëre oco se̱quëreje̱ ja̱ë api asaco pani, mëꞌëpi yëꞌëre se̱tiraꞌhuë. Se̱ona, yëꞌëpi paꞌi ocore pare i̱siraꞌhuë, mëꞌëre.” ");
INSERT INTO seyNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Caquëna, i̱opi cao: “Ëjaë, ¿jepi mëꞌë oco eani i̱sisiꞌni, yëꞌëre? I̱ti eayeje̱ peoquë, cuiꞌne oco coje cato hua̱icoa. ¿Jero ayere paꞌi ocoje̱ yëꞌëre i̱sisiꞌni? ");
INSERT INTO seyNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Iye oco coje cato yëquë ai Jacob necaisicoa. Ja̱je icona i̱je cuiꞌne i̱ mamajëje cuiꞌne nëicohuaꞌije̱ u̱cujë paꞌa̱huëꞌë. ¿Mëꞌëpi cuasani i̱ jerepa paꞌi aꞌë cuasaquë?” ");
INSERT INTO seyNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Cacona, Jesupi sehuopi: “Siꞌahuaꞌi iye oco u̱cucohuaꞌi cato siꞌanë oco ëaquëna, paꞌiyë. ");
INSERT INTO seyNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ja̱je paꞌiquëtaꞌare yëꞌë i̱si oco u̱cusiquë cato cuiꞌnaëpi oco huëoye peosipi. Yëꞌë oco cato sa̱ꞌnahuëre papi oco coje tsa̱ꞌiñeje paꞌye etaquëna pasipi, ti pani huesëye i̱siyepi.” ");
INSERT INTO seyNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ja̱ maca cao i̱opi: “Ëjaë, ja̱je paꞌito ja̱ ocore i̱sijë̱ꞌë, yëꞌëre, cuiꞌnaopi oco ëaye peoye, cuiꞌne iye oco coje ea daiye pa̱jaꞌcore.” ");
INSERT INTO seyNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Cacona, Jesupi capi: “Mëꞌë ë̱jëre soija̱ni ja̱ maca daijë̱ꞌë, i̱ñona.” ");
INSERT INTO seyNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Caquëna, i̱opi cao: “Ë̲jëre peocoaꞌë.” Cacona, Jesupi sehuopi: “Ë̲jëre peocoaꞌë cani peore paco cayë, mëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ja̱ꞌnë cato mëꞌë cinco ë̱mëohuaꞌire pahuë. Yure mëꞌë paquë cato mëꞌë ë̱jë peoji. Peocoaꞌë cani mëꞌë care pahuë.” ");
INSERT INTO seyNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ja̱re asani i̱opi caco: “Ëjaë, mëꞌë cato Maijaꞌquëre quëacaiquë aꞌë asayë, mëꞌëre. ");
INSERT INTO seyNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Yëquë aiohuaꞌi Samaritano pa̱i iye cu̱tihuëna Maijaꞌquëre se̱jë paꞌa̱huëꞌë. Ja̱je paꞌiquëtaꞌare mësaru judío pa̱ipi Jerusalénna Maijaꞌquëre se̱ñe paꞌiji, cacohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Cacona, Jesupi sehuopi: “Care paji cuasajë̱ꞌë, nomio. Maijaꞌquëre coa siꞌa hue̱ꞌña paꞌijë se̱ñe ti̱ꞌapi. Ja̱ maca cato ai cu̱tihuëna pa̱nitaꞌa Jerusalénna sani se̱ñe peosipi. ");
INSERT INTO seyNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mësaru Samaria pa̱i cato huesëjë coa se̱ñë. Yëquë judío pa̱i cato asajë se̱ñë. Huaso coca cato judío pa̱i tsëcapë aye aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Tsoe i̱ti macarepa ti̱ꞌapi. Yure aꞌë, Maijaꞌquëre se̱cohuaꞌirepa joyore papi nuñerepa cuasajë yoꞌo maca. Ja̱je yoꞌoyere ai yëji, jaꞌquë. ");
INSERT INTO seyNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Diusu cato joyo api. Ja̱je paꞌina, i̱te se̱cohuaꞌije̱ joyo ayere papi yoꞌoye paꞌiji, nuñerepa yoꞌoyepi.” ");
INSERT INTO seyNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Caquëna, Nomiopi cao: “Yëꞌë cato asayë, Mesías, maire huasoquë Cristopi dani ja̱ëpi siꞌaye quëaja̱ꞌquë api.” ");
INSERT INTO seyNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Cacona, Jesupi capi: “Yëꞌë aꞌë, i̱pi mëꞌë ja̱ꞌre coca caji.” ");
INSERT INTO seyNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jesús ja̱je cocare caquëna, i̱ yeꞌyacohuaꞌipi ti̱tareña. Nomio ja̱ꞌre Jesús coca caquëna, quëquë ñareña. Ja̱je ñajëtaꞌa se̱ni asañuꞌu i̱quere yë caëꞌni, pa̱nitaꞌa i̱que cocare nomio ja̱ꞌre caëꞌni cajë se̱ñe pa̱huë. ");
INSERT INTO seyNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ja̱ maca i̱o yurupë i̱ti macana ñoni pa̱i daripëna sani cao: ");
INSERT INTO seyNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Dani ñajëꞌë, yëꞌë yoꞌoseꞌere siꞌaye casiquëni. ¿I̱ Cristo paꞌimaꞌquë?” ");
INSERT INTO seyNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ja̱ maca asani, pa̱ipi Jesús quëꞌrona saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ja̱ yëꞌtaꞌa pa̱i daimaꞌpëna i̱ yeꞌyacohuaꞌipi Jesure cahuë: “Yeꞌyaquë, a̱o a̱ijëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Cajëna, i̱pi capi: “Mësaru ña maꞌñere yëꞌë cato payë, yëꞌë a̱i ja̱ꞌñe.” ");
INSERT INTO seyNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ja̱je caëna, ja̱ maca i̱ yeꞌyacohuaꞌipi sa̱ꞌñe i̱ohuaꞌija̱ꞌa se̱teña: “¿Pa̱ipi dacatena, a̱ni camaꞌquë?” ");
INSERT INTO seyNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Cajëna, Jesupi capi: “Yëꞌë a̱o cato yëꞌëre jëjo daosiquë yëyeje̱ yoꞌoye aꞌë. Cuiꞌne i̱ coꞌamaña ne saocaiye aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mësarupi cacohuaꞌi aꞌë: ‘Ja̱ yëꞌtaꞌa cuatro ñañëohuaꞌi carapi, tëaye.’ Ja̱je cacohuaꞌitaꞌare yëꞌëpi cayë: Ñani cuasajë̱ꞌë, ta̱seꞌere tsoe querepi, tëa ja̱ꞌñe. ");
INSERT INTO seyNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Tëaquëje̱ sa̱i cua̱ñoñe paꞌiji, i̱ti ca̱ tëaseꞌe cato ti pani huesëye aꞌë, i̱ti ta̱quë cuiꞌne i̱ti tëaquë siꞌa yëꞌquë maca sihuaye paꞌiji caquë. ");
INSERT INTO seyNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nuñerepa caji. Pa̱i caseꞌe je̱ꞌquë ñeje: ‘I̱ti ta̱quë cato yequë api cuiꞌne i̱ti tëaquë cato yequë api.’ ");
INSERT INTO seyNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yëꞌëpi mësarute jëjo saohuë, tëajë̱ꞌë caquë, mësaru ai yoꞌojë ta̱ maꞌñere. Ja̱je paꞌito yecohuaꞌipi nerena, mësaru cato coa tëacohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Jai pa̱i Samaria acohuaꞌi Jesure i̱re papi cajë cuasahuë, nomio caseꞌere cuasajë. Ja̱o cato cao, “Yëꞌë yoꞌoseꞌere siꞌaye capi.” ");
INSERT INTO seyNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ja̱re Samaria pa̱i asani Jesure se̱iꞌë, pëajë̱ꞌë cajë. Cajëna, asani caya muꞌseña pëapi. ");
INSERT INTO seyNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ai jerepa i̱re papi cuasajë asahuë, i̱pi i̱ ayere quëaquëna. ");
INSERT INTO seyNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ja̱ maca Nomiore cahuë. Yuretaꞌa i̱re papi cuasayë, yëquë. Mëꞌë caseꞌe asasicohuaꞌipi, cuiꞌne yure yëquëje̱ asa co̱ni i̱ caquëna, ja̱ doꞌire asayë. Nuñerepa Cristo api, iye yeja huasoquë cajë. ");
INSERT INTO seyNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Caya muꞌseña Samaria pëasiquëpi Galilea yejana sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ja̱re i̱pi Jesús caꞌa̱jiꞌi, Maijaꞌquëre quëacaiquëre i̱ quëꞌro acohuaꞌi cato coecohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galilea ti̱ꞌasi maca deꞌoye i̱te pëpahuë. Ja̱ohuaꞌi cato, Jesús Jerusalénre paꞌi deꞌoye yoꞌoquëna, ñasicohuaꞌipi pëpahuë. Egíptopi Israel pa̱i etajë paꞌiseꞌere cuasajë yoꞌojë teꞌe sani ñasicohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ja̱ maca Jesús Caná daripëna coꞌipi, Galilea yejana, i̱ ocore cuiyaꞌi oꞌsa co̱no ne sitona. Ja̱rote pajiꞌi, pa̱i ëjaërepa yoꞌoye ayere co̱caiquëpi. Ja̱ëpi mamaquëre Capernaum yejare ju̱ꞌiquëre paquëpi. ");
INSERT INTO seyNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ja̱je paquëpi pa̱i ëjaëre pare co̱caiquëpi Jesús, Judea yejapi Galileana dajiꞌi asani, sani Jesure ñapi. Ñaquë se̱jiꞌi, yëꞌë huëꞌena sani yëꞌë mamaquë ju̱ni huesë tëjiquëre jujucaijë̱ꞌë, caquë. ");
INSERT INTO seyNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ja̱ maca Jesupi capi: “Mësaru nuñere paꞌë cuasajë asaye pa̱ñë, pa̱i yoꞌo ti̱ꞌa maꞌñere yoꞌo i̱ñoñe pa̱to.” ");
INSERT INTO seyNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ja̱je caquëtaꞌare pa̱i ëjaëre pare co̱caiquëpi capi: “Ëjaë, esa daijë̱ꞌë, yëꞌë mamaquë ja̱ ju̱ꞌimaꞌnë.” ");
INSERT INTO seyNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Caquëna, Jesupi ja̱ maca capi: “Coꞌijë̱ꞌë, mëꞌë huëꞌena. Mëꞌë mamaquë huajëquëpi paꞌiji.” Caquëna, care paji cuasaquë asani sajiꞌi, i̱ huëꞌena. ");
INSERT INTO seyNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","I̱ huëꞌena je̱ꞌnërepa ti̱ꞌaquëna, ñani i̱ joꞌyapi i̱te ñañuꞌu cajë etani i̱te cahuë: “Mëꞌë mamaquë huajëquë paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ja̱je cajëna, i̱pi se̱jiꞌi: “¿I̱que hora paꞌi maca huajëquërepa paquëꞌni?” Caquëna, i̱ohuaꞌipi cahuë: “Ñaminaꞌa mëñerepa sa tëꞌyo maca, una paꞌi maca ja̱ maca su̱ña dahuë tëto sajiꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ja̱je cajëna, tsihuaꞌë pëca jaꞌquëpi asani cuasa ñajaquëña, ja̱re ja̱ hora paꞌi maca Jesús, “mëꞌë mamaquë huajëquëpi paꞌiji” caseꞌere. Ja̱je ñani i̱ cuiꞌne siꞌa huëꞌe paꞌicohuaꞌi Jesure nuñerepa i̱ api cajë asareña. ");
INSERT INTO seyNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Iye yoꞌoseꞌe cato cayaye aco pacoꞌë, pa̱i yoꞌo ti̱ꞌa maꞌñere Jesús yoꞌoseꞌe, Judeapi, Galilea coꞌisi maca. ");
INSERT INTO seyNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ja̱ yoꞌosi jeteyoꞌje judío pa̱ipi fiestare yoꞌohuë. Yoꞌojëna, Jesuje̱ coꞌi co̱pi, Jerusalénna. ");
INSERT INTO seyNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ja̱ daripëre yëi ñama hueꞌyosi eta saꞌro pajiꞌi. Paꞌina, ja̱o yëꞌquë macare ocore tëhuosi dea pëpi Betesda mami hueꞌeco pacoꞌë. Hebreo pa̱i coca cato ja̱opi cinco huajëjë ñuꞌi pe̱pë̱a quëꞌio pacoꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ja̱rote jai pa̱i ju̱ꞌicohuaꞌi pëasicohuaꞌipi u̱ëꞌë, peo yejare. Siꞌa ju̱ꞌi dahuë ju̱ꞌicohuaꞌi paëꞌë: ñamaꞌcohuaꞌi, doꞌpëcohuaꞌi, cuiꞌne quëꞌquësicohuaꞌi. Ja̱ohuaꞌipi utejë paëꞌë, oco daꞌcapi, tuꞌeja̱co cajë. ");
INSERT INTO seyNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ja̱rona teꞌe mañaseꞌe hui̱ñaëpi cajeni ocore tuꞌequëna, ñani duꞌru duꞌisiquëpi ja̱ jeteyoꞌje coꞌyaye paꞌiji, coa siꞌa ju̱ꞌi dahuë hueꞌequëje̱. ");
INSERT INTO seyNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ja̱rote pajiꞌi, treinta y ocho o̱metëca ju̱ꞌiquë. ");
INSERT INTO seyNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ja̱je paꞌipi, u̱ina, ñani Jesús i̱te tsoe ja̱je ai yoꞌoquë paꞌiyere asaquë se̱jiꞌi, i̱te: “¿Coꞌyaye yëquë, mëꞌë?” ");
INSERT INTO seyNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Caquëna, ju̱ꞌiquëpi sehuopi: “Ëjaë, yëꞌëre oco daꞌcana jëjo dëoni ma o̱aquëpi peoji. Ja̱je paꞌina, oco tuꞌe maca tsoe yequëpi duꞌiji, ja̱ꞌa yëꞌë dusiꞌi caquë yoꞌoquëna.” ");
INSERT INTO seyNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Caquëna, Jesús capi: “Huëni mëꞌë ca̱ico macare i̱ni sai huëojë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ja̱je ca maca tsoe coꞌyasiquë pajiꞌi. Paꞌi i̱ ca̱icore i̱ni sai huëopi. Ja̱je paꞌiquëtaꞌare ja̱ muꞌseña cato huajë muꞌse pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ja̱je paꞌi doꞌire judío pa̱ipi cahuë, i̱ti juju cua̱ñosiquëre: “Iye muꞌse cato huajë muꞌse aꞌë. Mëꞌë ca̱icore hueꞌeye peoji.” ");
INSERT INTO seyNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Cajëna, i̱pi sehuopi: “Yëꞌëre jujusiquë cato ‘mëꞌë u̱i ca̱icore i̱ni saijë̱ꞌë, capi.’ ” ");
INSERT INTO seyNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Caquëna, ja̱ maca se̱teña: “¿Jequëpi mëꞌëre ‘mëꞌë u̱i ca̱icore i̱ni saijë̱ꞌë’ caëꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Cajëna, huesëña i̱ti jujusiquëre Jesús cato jai pa̱i jopoja̱ꞌa sani huesëña, ña cua̱ñoñe peoye. ");
INSERT INTO seyNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ja̱je yoꞌosiquëpi jeteyoꞌje Maijaꞌquë huëꞌena ti̱ꞌani i̱te caëña: “I̱na, yure mëꞌë huajëquë paꞌiye sëte, cuiꞌnaëpi tayo coꞌayere yoꞌomaꞌë. Yoꞌoquëna, jerepa mëꞌëre coꞌaye ne co̱co.” ");
INSERT INTO seyNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ja̱je caëna, ja̱ maca sani judío pa̱ire quëapi, Jesús pajiꞌi, yëꞌëre jujusiquë caquë. ");
INSERT INTO seyNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ja̱ doꞌire judío pa̱i Jesure huani je̱oñuꞌu cajë cuiꞌne jo̱sa yoꞌohuë, huajë muꞌsere yoꞌosi doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ja̱je paꞌiquëtaꞌare Jesupi capi: “Yëꞌë Jaꞌquë siꞌanë coꞌamaña nequë api, cuiꞌne yëꞌëje̱ coꞌamaña yoꞌoyë.” ");
INSERT INTO seyNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ja̱je casi doꞌire jerepa judío pa̱i huani je̱oñuꞌu cajë yoꞌohuë. Huajë muꞌsere sehuomaꞌë yoꞌosi doꞌiseꞌe paꞌiye pa̱pi. Jerepa i̱pi Diusuje̱ paꞌi aꞌë caquë cuiꞌne Diusu api, yëꞌë jaꞌquë ca doꞌire yoꞌohuë. ");
INSERT INTO seyNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ja̱ maca Jesús capi, ja̱ohuaꞌire: “Nuñerepa mësarute cayë. Diusu mamaquë cato i̱seꞌe cuasayepi yoꞌoye peoji. Pëca jaꞌquë yoꞌoquëna, ñaseꞌere yoꞌoquë api. Siꞌaye pëca jaꞌquë yoꞌoyere mamaquëje̱ yoꞌoquë api. ");
INSERT INTO seyNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ja̱je paꞌina, mamaquëre oiji. Pëca jaꞌquëpi ja̱ doꞌire i̱ yoꞌoye i̱ñoji. Cuiꞌne iye yoꞌoseꞌe jerepa paꞌyere i̱ñojaꞌquë api. Ja̱je yoꞌoquëna, mësaru merepa yoꞌoquëꞌni cuasaja̱ꞌcohuaꞌi aꞌë, ña quëquëjë. ");
INSERT INTO seyNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Pëca jaꞌquë ju̱ꞌisicohuaꞌire cuiꞌnaohuaꞌini huajëcohuaꞌire huëoni paꞌiye i̱siyeje̱ paꞌye, cuiꞌne i̱ mamaquëje̱ i̱siji, paꞌiye, i̱ i̱siye yëquëna. ");
INSERT INTO seyNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Jaꞌquë cato pa̱i yoꞌoyere ña deꞌhuamaꞌajiꞌi. Pa̱quë mamaquëna i̱sipi, pa̱i yoꞌojëna, ñaquë ne deꞌhuaja̱ꞌa tutu. ");
INSERT INTO seyNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ja̱ doꞌire mamaquëre deꞌoquëre papi caja̱ꞌcohuaꞌi aꞌë, pëca jaꞌquëre cayepi. Pëca jaꞌquë jëjo daosiquëni deꞌoquëre papi caye pa̱ni pëca jaꞌquëreje̱ deꞌoquëre papi caye peoji. ");
INSERT INTO seyNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Nuñerepa cayë, mësarute. Yëꞌë caye deꞌhue asacani, cuiꞌne yëꞌëre jëjo daosiquëre i̱re papi caquë cuasasiquëpi ti pani huesëye paji. Nejoñe peoji, i̱te. Ju̱ni huesëyepi ti paꞌiyena tëto saisiquë api. ");
INSERT INTO seyNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nuñerepa, cayë, mësarute. Ti̱taji, hora. Yure i̱ti macaꞌë, ju̱ꞌisicohuaꞌipi Diusu mamaquë yëꞌore asaja̱ꞌa maca. I̱ caye asani sehuocaicohuaꞌipi paꞌija̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Jaꞌquë cato paꞌiye paji. Ja̱je paquëpi mamaquëre paꞌiye i̱sipi. ");
INSERT INTO seyNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ja̱je cuiꞌne pa̱i yoꞌoye ne deꞌhuaja̱ꞌa tutuje̱ i̱sipi, Pa̱i Mamaquëre. ");
INSERT INTO seyNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Iyere asani ai cuasamaꞌpë paꞌijë̱ꞌë. Quëare payë. Ju̱ꞌisicohuaꞌi ta̱sicohuaꞌipi siꞌaohuaꞌi i̱ yëꞌo asaja̱ꞌa maca ti̱ꞌajaꞌcoa. ");
INSERT INTO seyNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Asani ta̱si daripë̱api etaja̱ꞌcohuaꞌi aꞌë, siꞌaohuaꞌi. Deꞌoyerepa yoꞌosicohuaꞌipi ti paꞌiyena huëija̱ꞌcohuaꞌi aꞌë. Ja̱je paꞌiquëtaꞌare coꞌayere yoꞌojë paꞌisicohuaꞌi cato coa nejojaꞌcohuaꞌipi huëija̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jaꞌquëre ja̱ se̱ni asamaꞌë yëꞌëseꞌe cuasayepi nejoñe peoyë. Yëꞌë cato yëꞌëre cua̱ñeseꞌeje̱ caquë aꞌë, tayo yoꞌocohuaꞌire. Yëꞌë yoꞌoye cato nuñerepa yoꞌoye aꞌë. Yëꞌë yëyeje̱ yoꞌoye coeyë. Jaꞌquë yëꞌëre jëjo daosiquë yëyepi yoꞌoquë aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ja̱je paꞌina, yëꞌëpi coꞌye yëꞌëja̱ꞌa deꞌoye yoꞌoyë caquë paꞌito yëꞌë caye care paji cacaiquë peoraꞌpi. ");
INSERT INTO seyNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ja̱je paꞌiquëtaꞌare paꞌiji, yëꞌë yoꞌoye ñaquëpi yëꞌëre deꞌoye cacaiquë. Ja̱je paꞌina, yëꞌëre i̱ cacaiye cato nuñerepa doꞌi paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mësarupi Juanre se̱ni asaja̱ꞌcohuaꞌire jëjo saoreña. Se̱jëna, Juanpi nuñerepa sehuopi, ja̱je paꞌire paquëna. ");
INSERT INTO seyNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Iye cato cayë mësarupi huaso cua̱ñosicohuaꞌi paꞌija̱jë caquë yëꞌë cato pa̱ipi deꞌoye cacaiyere coꞌemaꞌë paꞌiyë. ");
INSERT INTO seyNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan cato toa tsë̱o pë miañeje miacaiquë pajiꞌi. Ja̱je paꞌina, mësarupi i̱ miañere sihuacaicohuaꞌi paëꞌë, coa nëhui tëcahuë. ");
INSERT INTO seyNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Juan yëꞌëre cacaiseꞌe jerepa deꞌoye yëꞌëja̱ꞌa coꞌye quëaye payë. Yëꞌë yoꞌoye cato jaꞌquë yëꞌëre yoꞌojë̱ꞌë caquë cua̱ñe nëoseꞌe aꞌë. Ja̱je paꞌina, ja̱pi quëaji, yëꞌë nuñerepa jaꞌquë jëjo daosiquë paꞌiye. ");
INSERT INTO seyNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Jaꞌquë yëꞌëre jëjo daosiquë cato, quëaji, yëꞌë nuñerepa deꞌoye yoꞌoquë paꞌiyere, mësaru i̱ yëꞌo asamaꞌcohuaꞌi paꞌitoje̱ cuiꞌne i̱te ñamaꞌcohuaꞌi paꞌitoje̱. ");
INSERT INTO seyNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","I̱ coca i̱tire paꞌë cajë cuasamaꞌ doꞌire i̱ coca mësarute cacaye pa̱ji, pëca jaꞌquë jëjo daosiquëre coe doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mësaru cato Maijaꞌquë coca tayoye peoye yeꞌyeyë, ti pani huesëyere i̱tire ñajë ti̱ꞌañuꞌu cajë. Ja̱je paꞌiquëtaꞌa ja̱ toyaseꞌe cato yëꞌë ayere caji. ");
INSERT INTO seyNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ja̱je yëjëtaꞌa yëꞌëna daiye coeyë, ja̱ paꞌiye paja̱ꞌcohuaꞌitaꞌa. ");
INSERT INTO seyNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Yëꞌë cato coꞌemaꞌë paꞌiyë, pa̱ipi deꞌoquëre papi cajë yoꞌoyere. ");
INSERT INTO seyNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Asayë, mësaru nuñerepa Maijaꞌquëre oimaꞌcohuaꞌi paꞌiye. ");
INSERT INTO seyNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yëꞌë cato jaꞌquë paꞌi huë̱ꞌñapi daisiquë aꞌë. Ja̱je paꞌiquëtaꞌare mësarupi asaye coeyë. Coa pa̱iseꞌe huëoni coꞌye i̱re paꞌë caquëni cuasacohuaꞌi aꞌë, mësaru deꞌoji cajë. ");
INSERT INTO seyNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Me mësaru asaja̱ꞌcohuaꞌi aꞌni, pa̱ijaꞌa sa̱ꞌñe deꞌoquëre papi cajë yoꞌocohuaꞌipi? ¿Me yoꞌojë Diusupi mësarute deꞌoquëre papi cayere coꞌe maꞌñeꞌni? ");
INSERT INTO seyNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Cuasamaꞌpë paꞌijë̱ꞌë. Yëꞌëpi yëꞌë jaꞌquë ña hue̱ꞌñana mësarute doꞌi quëꞌiohuaꞌi aꞌë, caja̱ꞌquë api cajë. Mësarute sa̱ñope caquë cato Moiséspi mësaru necaiquë api cajë utejë paꞌiquë. ");
INSERT INTO seyNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ja̱je paꞌina, mësarupi Moisés caseꞌe care paji cajë asacaicohuaꞌi pani yëꞌëreje̱ asacatiraꞌhuë, Moisés cato yëꞌë ayere toya doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ja̱je paꞌina, mësaru Moisés toyaseꞌere asacaimaꞌcohuaꞌi pani, ¿Me yëꞌë caye asacaiyeꞌni, care paji cajë?” ");
INSERT INTO seyNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ja̱ jeteyoꞌje Jesús Galilea jairana je te̱ꞌtena sajiꞌi. Ja̱re i̱ti jairapi Tiberias yequë mami hueꞌeco pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ja̱je saina, jai pa̱i tuëꞌë, pa̱i yoꞌo ti̱ꞌa maꞌñere yoꞌoquë, ju̱ꞌicohuaꞌire jujuquëna, ñasicohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ja̱ maca Jesús i̱ yeꞌyecohuaꞌi ja̱ꞌre ai cu̱tihuëna mëni jaꞌrupi. ");
INSERT INTO seyNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Egíptopi Israel pa̱i etajë paꞌiseꞌere cuasajë judío pa̱i yoꞌo maca ti̱ꞌañe jaꞌi maca pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Paꞌina, ja̱ maca Jesús jai pa̱i i̱te tuijëna, ñani Felipere capi: “¿Jerona a̱o hueroja̱ꞌcohuaꞌi aꞌni, jai pa̱i a̱i ja̱ꞌñe?” ");
INSERT INTO seyNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ja̱ cato capi, Felipere neñasiꞌi caquë, Jesús cato tsoe i̱ ne ja̱ꞌñe paꞌina. ");
INSERT INTO seyNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ja̱je caquëna, Felipepi sehuopi: “Docientos romano quëriqui të̱ꞌñapi pan hueroto ti̱ꞌañe pa̱ji, teꞌe panpë teꞌireje̱.” ");
INSERT INTO seyNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ja̱ maca Andréspi Jesús yeꞌyaquëpi Simón Pedro yoꞌjeipi capi: ");
INSERT INTO seyNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“I̱ñore teꞌe tsihuaꞌë cinco pan cuiꞌne caya tsiaya huaꞌire paquë paꞌiji. ¿Ja̱ maña pato me jai pa̱ire ti̱ꞌaquëꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ja̱ maca Jesupi capi: “Siꞌa pa̱ire cajë̱ꞌë, jaꞌruja̱jë.” Ai taya paquëna, taya ë̱mëjeꞌena jai pa̱i jaꞌrureña. Ë̲mëohuaꞌiseꞌe cinco mil pa̱i paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ja̱ maca Jesús cinco pan i̱ni Diusure deꞌoji caquë pëpani ja̱ jeteyoꞌje i̱ yeꞌyacohuaꞌina i̱sipi. I̱sina, i̱ yeꞌyacohuaꞌipi pa̱ire se a̱ohuë. Ja̱re cuiꞌne tsiaya huaꞌireje̱ yoꞌopi. Siꞌaye i̱ohuaꞌi yëye necajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tsoe a̱ni huajësicohuaꞌi paꞌijëna, Jesupi capi, i̱ yeꞌyacohuaꞌire: “A̲ni jujaseꞌe tsiꞌsojë̱ꞌë, coa nejoñe peoja̱ꞌquë.” ");
INSERT INTO seyNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Caëna, tsiꞌsohuë, a̱ni jujaseꞌe. Tsiꞌsojë doce doꞌrohuë̱a ti̱mëhuë, cinco pan paꞌiseꞌepi jaiye neseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ja̱ maca Jesús yoꞌoseꞌere ñani, pa̱ipi cahuë: “Iquë nuñerepa Maijaꞌquëre quëacaiquë api, iye yejana daija̱ꞌquë api ca nëosiquë.” ");
INSERT INTO seyNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ja̱je paꞌiquëtaꞌare Jesús asapi, i̱ohuaꞌi yëyepi coetoje̱ ëjaëre pare neñuꞌu cuasaye. Ja̱je paꞌina, ja̱ohuaꞌire je̱oni ai cu̱tihuëna sajiꞌi, teꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ñami deꞌosi maca Jesús yeꞌyacohuaꞌipi jairana cajehuë. ");
INSERT INTO seyNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Cajeni yohuëna aya mëni Capernaum yejana je̱ꞌe huëohuë. Ja̱ maca cato tsoe ai neapi, cuiꞌne Jesuje̱ ja̱ coꞌimaꞌë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ja̱ maca ai tutuquë cuiꞌne ai to̱ꞌa huëopi. ");
INSERT INTO seyNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Cinco kilómetros pa̱nitaꞌa seis kilómetros paꞌi macare paꞌijë ñahuë, Jesupi yohuë quëꞌrona daina, oco daꞌca ë̱mëjeꞌejaꞌa. Ja̱je ñani ai caꞌrahuë. ");
INSERT INTO seyNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ja̱je caꞌrajëna, i̱pi capi, ja̱ohuaꞌire: “¡Yëꞌë aꞌë. Caꞌramaꞌpë paꞌijë̱ꞌë!” ");
INSERT INTO seyNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ja̱ maca sihuajë yohuëna daijë̱ꞌë cajë yoꞌoye i̱ñohuë. Cuiꞌne ja̱ maca aya mëquëna, i̱ ja̱ꞌre co̱ni esarepa i̱ohuaꞌi cajë saisi yejana ti̱ꞌahuë. ");
INSERT INTO seyNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Se ñatasi muꞌse jaira je te̱ꞌtena pëasicohuaꞌipi cuasa ti̱ꞌahuë. Teꞌe yohuë paꞌisicoja̱ꞌa i̱ yeꞌyacohuaꞌipi saëꞌë. Saijëna, Jesuseꞌe i̱ohuaꞌi ja̱ꞌre saiye pa̱pi cajë. ");
INSERT INTO seyNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ja̱je cuasajë paꞌijëna, Tiberias daripëpi jaiye yohuë̱a dajiꞌi, i̱ohuaꞌire pan Ëjaëpi neni a̱o sito quë̱no macana. ");
INSERT INTO seyNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ja̱je Jesús cuiꞌne i̱ yeꞌyacohuaꞌi peojëna, ñani yohuë̱ana aya mëni Capernaum yejana saëꞌë, Jesure coꞌeñuꞌu cajë. ");
INSERT INTO seyNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Jaira je te̱ꞌtena ti̱ꞌani Jesure se̱teña: “¿Yeꞌyaquë je yëhua ti̱taëꞌni, i̱ño?” ");
INSERT INTO seyNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Cajëna, Jesupi capi: “Nuñerepa mësarute cayë. Mësaru cato yëꞌëre coꞌeyë, coa panre ti̱mëñerepa a̱ni ñani. Coꞌemaꞌpë paꞌiyë, pa̱i yoꞌo ti̱ꞌa maꞌñere ñasi doꞌire asa ti̱ꞌañe. ");
INSERT INTO seyNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Coa caraja̱i a̱ore cajë ai yoꞌomaꞌpë paꞌijë̱ꞌë. Ai jerepa ti pani huesë a̱ore pare cajë yoꞌojë̱ꞌë, quëcoyere pare. Iyere Maijaꞌquë mamaquë cato i̱sija̱ꞌquë api, mësarute. Jaꞌquë Diusupi yëꞌëna ja̱ tuture i̱sipi.” ");
INSERT INTO seyNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ja̱je caquëna, i̱ohuaꞌipi se̱iꞌë: “¿Me yoꞌoja̱ꞌcohuaꞌi aꞌni, yëquë Diusu yëyere necañuꞌu cani?” ");
INSERT INTO seyNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Cajëna, Jesupi sehuopi: “Diusu yëye cato i̱ jëjo daosiquëni care paji cajë cuasacaiye aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ja̱je caquëna, i̱ohuaꞌipi se̱iꞌë: “¿I̱quere mëꞌë yoꞌo i̱ñojaꞌquë aꞌni, pa̱i yoꞌo ti̱ꞌa maꞌñe yëquëre mëꞌëre care paji cuasajë asaja̱ꞌcohuaꞌire? ");
INSERT INTO seyNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Tsoe acohuaꞌi a̱ꞌahuëꞌë, manare cue̱ne yeja paꞌi maca. Ja̱re toyaseꞌe cato: ‘Diusupi maꞌtëmo panre a̱opi,’ caji.” ");
INSERT INTO seyNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Cajëna, Jesupi sehuopi: “Nuñerepa cayë, mësarute. Moiséspi maꞌtëmo panre a̱oñe pa̱pi, yëꞌë jaꞌquë api, nuñerepa maꞌtëmo panrepa a̱oquë. ");
INSERT INTO seyNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Diusu i̱si panrepa cato, maꞌtëmopi pa̱ire ti pani huesëye i̱siquë daisiquë api.” ");
INSERT INTO seyNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ja̱ maca i̱ohuaꞌipi cahuë: “Ja̱ panseꞌe yëquëre i̱sijë̱ꞌë, Ëjaë.” ");
INSERT INTO seyNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Cajëna, Jesupi capi: “Yëꞌë aꞌë, pan paꞌiye i̱siquë. Yëꞌëna daisiquë cato a̱i ëaye peosipi. Cuiꞌne yëꞌëre i̱re papi caquë cuasasiquë cato oco ëaye peosipi. ");
INSERT INTO seyNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Yëꞌë mësarute caseꞌeje̱ paꞌye yëꞌëre mësarupi ñajëtaꞌa i̱re papi cajë cuasaye pa̱ñë. ");
INSERT INTO seyNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Jaꞌquë yëꞌëna, i̱sicohuaꞌi cato siꞌaohuaꞌi yëꞌëna daiyë. Yëꞌëna daisicohuaꞌire cato eto saoye pa̱jaꞌquë aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Yëꞌë cato maꞌtëmopi yëꞌë yëyeje̱ yoꞌosiꞌi caquë daiye pa̱huë. Yëꞌëre jëjo daosiquë yëyere yoꞌosiꞌi caquë daisiquë aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yëꞌë jaꞌquë yëꞌëre jëjo daosiquë cato i̱ yëꞌëre i̱sicohuaꞌini teꞌire ne huesocaiye peoye deꞌoye yëꞌëpi ñacaiyere yëji. Cuiꞌne yëꞌëpi tëji muꞌserepa ju̱ꞌisicohuaꞌini huëocaiyere yëji. ");
INSERT INTO seyNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Yëꞌë jaꞌquë cato siꞌahuaꞌi Maijaꞌquë mamaquëre ñani i̱re papi cajë cuasasicohuaꞌipi ti pani huesëyere yëji. Yëꞌëna, yëꞌëpi tëji muꞌserepa ju̱ꞌisicohuaꞌini huëosiꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ja̱ maca “yëꞌë aꞌë, maꞌtëmopi cajesi pan” casi doꞌire judío pa̱ipi i̱te cueꞌcue huëohuë. ");
INSERT INTO seyNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Cueꞌcuejë cahuë: “¿Iquë Jesús paꞌimaꞌquë José mamaquë maipi i̱ pëca jaꞌquëre cuiꞌne pëca jaꞌcore ñacohuaꞌi paꞌi maꞌñe? ¿Ja̱je paꞌitaꞌa me yoꞌoquë maꞌtëmopi daisiquë aꞌë, caquëꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ja̱je cajëna, Jesupi capi: “Cueꞌcueyere je̱ojëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Yëꞌëna teꞌohuaꞌi dani ti̱ꞌañe peoji, yëꞌëre jëjo daosiquëpi jaꞌquëpi i̱te damaꞌquë paꞌito. Ja̱ëni yëꞌëpi tëji muꞌserepa huëoja̱ꞌquë aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Maijaꞌquëre quëacaicohuaꞌi toyajë paꞌiseꞌepi caji ñeje: ‘Diusupi yeꞌyaja̱ꞌquë api, siꞌa pa̱ire.’ Ja̱je paꞌina, siꞌahuaꞌi jaꞌquëre asacohuaꞌipi cuiꞌne i̱te yeꞌyecohuaꞌipi daiyë, yëꞌëna. ");
INSERT INTO seyNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Jaꞌquëre pa̱ije ñamaꞌcohuaꞌi aꞌë. Diusu quëꞌropi daisiquëseꞌe i̱te ñaquë api. ");
INSERT INTO seyNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nuñerepa cayë. Yëꞌëre care paji caquë cuasaquëpi ju̱ꞌimaꞌë ti paꞌiye paji. ");
INSERT INTO seyNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yëꞌë aꞌë, pan paꞌiye i̱siquë. ");
INSERT INTO seyNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mësaru aipë Maijaꞌquë a̱oñere a̱ꞌahuëꞌë, pan cue̱ne yeja cuꞌi maca. Ja̱je a̱isicohuaꞌitaꞌa peo hue̱ꞌña ju̱ju saꞌa̱huëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ja̱je paꞌiquëtaꞌare yëꞌë cato maꞌtëmo cajesiquë panre cayë. Ja̱re pa̱ipi a̱isicohuaꞌi pani ti ju̱ꞌiñe peoji. ");
INSERT INTO seyNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yëꞌë aꞌë, ja̱ pan maꞌtëmopi huajëquë cajesiquë. Ja̱ panre pa̱ipi a̱isicohuaꞌi pani ti pani huesëye paꞌiji. Yëꞌë i̱sija̱ꞌa pan cato, yëꞌë ca̱pë aꞌë. Iye yeja paꞌicohuaꞌi paꞌiyere caquë i̱sija̱ꞌquë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ja̱ maca ja̱re asani judío pa̱ipi sa̱ꞌñe coca cahuë, ñeje cajë: “¿Me iquë maire i̱ ca̱pë a̱osiꞌquë caquëꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Cajëna, Jesupi capi: “Nuñerepa cayë, mësarute. Mësarupi Pa̱i Mamaquë ca̱përe a̱imaꞌcohuaꞌi pani cuiꞌne i̱ tsiere u̱cumaꞌcohuaꞌi pani ti pani huesëye peocohuaꞌi paꞌiyë. ");
INSERT INTO seyNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Yëꞌë ca̱pë a̱isiquëpi cuiꞌne yëꞌë tsie u̱cusiquëpi ti paꞌiye paji. Ja̱je paꞌini yëꞌëpi tëji muꞌserepa ju̱ꞌisiquëni huëoja̱ꞌquë aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ja̱je paꞌina, yëꞌë ca̱pë cato nuñerepa a̱ore paꞌë, cuiꞌne yëꞌë tsie cato nuñerepa u̱cuyere paꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Yëꞌë ca̱pë a̱isiquëpi cuiꞌne yëꞌë tsie u̱cusiquëpi yëꞌë ja̱ꞌre co̱ni tsioni paꞌiji. Paꞌina, yëꞌëpi i̱ ja̱ꞌre co̱ni paꞌiyë. ");
INSERT INTO seyNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Yëꞌëre jëjo daosiquë jaꞌquë cato paꞌiye paji, yëꞌë i̱ni pacacaiyë. Ja̱je cuiꞌne, yëꞌëre a̱iquëje̱ yëꞌë doꞌire pasipi. ");
INSERT INTO seyNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Maꞌtëmopi cajesi pan ayere cayë. Iye cato ai tsoe Maijaꞌquë Israel pa̱ire a̱oseꞌeje̱ paꞌye peoji. Ja̱ pan a̱isicohuaꞌi siꞌa pa̱i ju̱ju saꞌa̱huëꞌë. Ja̱je paꞌiquëtaꞌare iye pan a̱isiquë cato ti pani huesëye paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iye cato Jesús yeꞌyapi, Capernaum daripë pa̱i tsiꞌsi huëꞌena. ");
INSERT INTO seyNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Iye yeꞌyayere asani Jesure jai pa̱i tuicohuaꞌi acohuaꞌipi cahuë: “Iye i̱ caye ja̱je paꞌijë̱ꞌë cajë asa ti̱ꞌañe peoji. Ai jerepa jëaji. ¿Ja̱je paꞌito nepi, asa ti̱ꞌañe paꞌiquëꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ja̱ maca Jesús asapi, i̱ohuaꞌi sa̱ñope caye. Ja̱je paꞌina, se̱jiꞌi, ja̱ohuaꞌire: “¿Yëꞌë caseꞌepi mësarute sa̱ñope caquë? ");
INSERT INTO seyNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Me yoꞌoꞌñe paꞌiohuaꞌi aꞌni, Pa̱i Mamaquëpi i̱ ja̱ꞌnë paꞌi sitona mëina, ñani? ");
INSERT INTO seyNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Joyopi paꞌiye i̱siji, ca̱pë cato co̱caimaꞌcoa. Yëꞌë mësarute caseꞌe cato nuñerepa joyo aye aꞌë, ti paꞌiye i̱siye aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ja̱je paꞌiquëtaꞌare mësaru acohuaꞌi yecohuaꞌi ja̱ yëꞌtaꞌa nuñere paꞌë cajë asa ti̱tamaꞌcohuaꞌipi paꞌiyë.” Jesús cato asapi, duꞌru huëo macana i̱ti cuasamaꞌcohuaꞌire, cuiꞌne i̱te coso yehuoja̱ꞌquëre. ");
INSERT INTO seyNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ja̱je paꞌina, capi: “Mësarute cahuë. Jaꞌquëpi yëꞌëna dacaimaꞌquë paꞌito yëꞌë quëꞌro teꞌije̱ dani ti̱ꞌañe peoji.” ");
INSERT INTO seyNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ja̱je casi macapi jai pa̱i Jesús ja̱ꞌre cuꞌicohuaꞌi je̱oni i̱ ja̱ꞌre co̱ni cuꞌiye pa̱huë. ");
INSERT INTO seyNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ja̱ maca Jesupi se̱jiꞌi, I̱ doce yeꞌyacohuaꞌire: “¿Mësaruje̱ je̱oni saiye yëye?” ");
INSERT INTO seyNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Caquëna, Simón Pedropi sehuopi: “¿Ëjaë, neina yëquë saija̱ꞌcohuaꞌi aꞌni? Mëꞌë coca cato ti pani huesë cocaꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Yëquë cato mëꞌëre care paji cajë cuasahuë. Cuiꞌne asayë, mëꞌë cato Cristo api, Maijaꞌquë huajëquërepa Mamaquëre papi.” ");
INSERT INTO seyNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Caquëna, Jesupi sehuopi: “Yëꞌëpi mësaru doce paꞌiohuaꞌire soihuë. Ja̱je paꞌiquëtaꞌare mësaru aquë teꞌi huati api.” ");
INSERT INTO seyNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ja̱je cani Jesús Judas Iscarioteni capi, Simón mamaquëni, doce soisicohuaꞌi aquëni, Judaspi i̱te coso yehuoja̱ꞌquëni capi. ");
INSERT INTO seyNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Iye casi jeteyoꞌje Jesús Galilea yejare cuniroja̱jiꞌi, Judea yeja paꞌiye coepi, judío pa̱ipi i̱ni huani je̱oñuꞌu cajë yoꞌo doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ja̱je paꞌiquëtaꞌare judío pa̱i Egíptopi etani aꞌri huë̱ꞌña nejë paꞌisi muꞌsere cuasajë yoꞌo muꞌseña ti̱ꞌa huëopi. ");
INSERT INTO seyNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ti̱ꞌa huëoquëna, Jesús yoꞌje tsi̱pi cahuë, i̱te: “I̱ño pëamaꞌë yure Judeana saijë̱ꞌë, mëꞌëre tuicohuaꞌije̱ mëꞌë yoꞌoye ñajaꞌcohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ja̱je paꞌina, siꞌa pa̱i ñajajë cani yahue yoꞌocoje̱ ñani, mëꞌë yoꞌoyeje̱ pa̱i yoꞌo ti̱ꞌa maꞌñere yoꞌocohuaꞌi. Pa̱i yoꞌo ti̱ꞌa maꞌñe yoꞌoquë sëte siꞌa pa̱i ñajëna, yoꞌo i̱ñojëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","I̱ yoꞌje tsi̱ cato aꞌri mañaje care paji cuasajë asamaꞌcohuaꞌipi cahuë. ");
INSERT INTO seyNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ja̱ maca Jesupi capi: “Ja̱ yëꞌtaꞌa yëꞌë yoꞌo maca ti̱ꞌañe pa̱pi. Mësarute cato coa siꞌaë yoꞌoye deꞌoji. ");
INSERT INTO seyNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mësarute cato iye yeja acohuaꞌi coeye peoji. Ja̱je paꞌiquëtaꞌare yëꞌëre cato coeyë. Yëꞌëpi ti̱ñarepa i̱ohuaꞌi yoꞌoye coꞌaye aꞌë caquë i̱ño doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Saijë̱ꞌë, mësaruseꞌe fiestana. Yëꞌë cato saiye pa̱ñë. Ja̱ yëꞌtaꞌa yëꞌë sai maca ti̱ꞌañe pa̱ji.” ");
INSERT INTO seyNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ja̱je ca tëjini Galileana pëapi. ");
INSERT INTO seyNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pa̱i ti̱ñarepa ñañe peoye yahue Jesuje̱ sajiꞌi, fiestana, i̱ yoꞌje tsi̱ saisi jeteyoꞌje. ");
INSERT INTO seyNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Fiesta paꞌi maca judío pa̱ipi coꞌejë cahuë: “¿Jerore pare paꞌiquëꞌni, ja̱ë?” ");
INSERT INTO seyNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Jai pa̱i tsiꞌsi sitopi Jesús ayere cahuë. Yecohuaꞌipi cahuë: “Deꞌo pa̱i api.” Cajëna, yecohuaꞌipi cahuë: “Coꞌaquë api. Coa pa̱ire cosoquëna, asaquë api.” ");
INSERT INTO seyNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ja̱je paꞌiquëtaꞌare ti̱ñarepa caye pa̱huë, judío pa̱ini caꞌra doꞌire yahue caroja̱ëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Fiesta joporepa paꞌi maca Jesupi Maijaꞌquë huëꞌena cacani yeꞌya huëopi. ");
INSERT INTO seyNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yeꞌyaquëna, judío pa̱ipi ai ñajë cuasajë cahuë: “¿Merepa iquë jaiye ta̱ꞌñe yeꞌyaquëꞌni, toya jaꞌo yeꞌyemaꞌquëtaꞌa?” ");
INSERT INTO seyNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Cajëna, Jesupi sehuopi: “Yëꞌë yeꞌyaye cato yëꞌë tse̱ peoji. Ja̱ cato yëꞌëre jëjo daosiquë tse̱ aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mësaru aquëpi Maijaꞌquë yëyere yoꞌoquë pani yëꞌë yeꞌyaye Diusu yeꞌyaye aꞌë caquë asaja̱ꞌquë api. Pa̱nitaꞌa coa i̱seꞌe cuasayere yeꞌyaji caquë asaja̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","I̱seꞌe cuasayepi caquë cato pa̱ipi deꞌoquë api caja̱jë caquë caquë api. Ja̱je paꞌiquëtaꞌare i̱te jëjo daosiquëni pa̱ipi deꞌoquë api cacaija̱jë caquë yoꞌoquëpi nuñerepa caji. Ja̱je paꞌina, ti cosomaꞌquëpi caji. ");
INSERT INTO seyNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mësarute Moiséspi cua̱ñeseꞌe i̱sipi. I̱siquëtaꞌare mësarupi sehuocaiye pa̱ñë, ja̱ cua̱ñeseꞌe. ¿Me yoꞌojë yëꞌëre huani je̱oñe yëyeꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Caquëna, pa̱ipi sehuohuë: “Huati joyore hueꞌequë, mëꞌë. Ja̱je cayë, mëꞌë, ¿nepi mëꞌëre huani je̱oñe yëyeꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Cajëna, Jesupi sehuopi: “Huajë muꞌse paꞌina, teꞌore yoꞌoseꞌere ñani mësaru ai cuasayë. ");
INSERT INTO seyNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mësaru aipë tsoe duꞌru yoꞌoyere Moisés cato cua̱ñepi cuiri ca̱ꞌni tëaye pajiꞌi caquë. I̱pi huëoye pa̱pi, ja̱ cato. Ja̱je paꞌina, mësaru huajë muꞌse paꞌitoje̱ cuiri ca̱ꞌni tëacohuaꞌi aꞌë, tsi̱re. ");
INSERT INTO seyNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ñajëꞌë. Yure, mësarupi Moisés cua̱ñeseꞌe yoꞌo ti̱ꞌañuꞌu cajë huajë muꞌse paꞌitoje̱ tsi̱re cuiri ca̱ꞌni tëacohuaꞌitaꞌa, ¿me yoꞌojë mësaru yëꞌëre pë̱iñeꞌni, ju̱ꞌiquë macare huajë muꞌse paꞌina, jujucaisi doꞌire cajë? ");
INSERT INTO seyNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Coꞌaye yoꞌoyeje̱ paꞌye ña cua̱ñoñere coꞌaji camaꞌpë paꞌijë̱ꞌë. Coꞌaye yoꞌoji cacohuaꞌi pani nuñerepa coꞌayere ñani cajë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ja̱ maca Jerusalén paꞌicohuaꞌi acohuaꞌipi sa̱ꞌñe se̱ huëoreña: “¿Ja̱ëje paꞌini, pa̱i huani je̱oñuꞌu cajë coꞌejëna, mai ñasicohuaꞌitaꞌa? ");
INSERT INTO seyNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Yure i̱pi siꞌaohuaꞌi ñajëna, caquëtaꞌare teꞌije̱ i̱te sa̱ñope caye pa̱ji. ¿Ëjaohuaꞌipi i̱ohuaꞌitaꞌa nuñerepa Cristore papi caji cajë cuasa doꞌire sa̱ñope caye pa̱ñë? ");
INSERT INTO seyNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ja̱je paꞌiquëtaꞌare mai cato asayë, i̱ huëo sito.” ");
INSERT INTO seyNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Iyere Jesús asani, Maijaꞌquë huëꞌe yeꞌyaquëpi ai tutu, capi, ñeje: “Ja̱je paꞌito mësaru asayë, yëꞌë dai sito cuiꞌne yëꞌëreje̱ ñacohuaꞌi aꞌë. Yëꞌë cato nuñerepa paꞌipi jëjo daosiquë aꞌë, mësaruje̱ ñamaꞌquëpi. ");
INSERT INTO seyNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yëꞌë cato i̱te ñaquë aꞌë, i̱ quëꞌropi daisiquë sëte. I̱pi yëꞌëre jëjo daopi.” ");
INSERT INTO seyNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ja̱ maca i̱te tse̱añuꞌu cajë yoꞌojëtaꞌa teꞌije̱ i̱te to̱me dani tse̱añe pa̱huë, ja̱ yëꞌtaꞌa i̱te tse̱a maca ti̱ꞌañe pa̱si doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Jai pa̱i Jesure i̱re papi cuasajë asahuë. Ja̱je paꞌina, cahuë: “Cristopi daisiquë pani, iquë yoꞌoseꞌe se̱ña maca pa̱i yoꞌo ti̱ꞌa maꞌñere yoꞌoye i̱ñoñe peoji, cuasayë.” ");
INSERT INTO seyNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseo pa̱ipi asahuë, Jesús ayere pa̱ipi cajëna. Ja̱je asani ja̱ohuaꞌi cuiꞌne Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌi co̱ni coꞌaye yoꞌocohuaꞌire tse̱secohuaꞌire jëjo daohuë, tse̱ani Jesure saja̱jë cajë. ");
INSERT INTO seyNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ja̱ maca Jesupi capi, i̱te tse̱a dasicohuaꞌire: “Yureseꞌe mësaru ja̱ꞌre co̱ni aꞌri maña pasiꞌi. Ja̱ jeteyoꞌje yëꞌëre jëjo daosiquë quëꞌrona coꞌisiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mësaru yëꞌëre coꞌejëtaꞌa ti̱ꞌañe pa̱jaꞌcohuaꞌi aꞌë, yëꞌë sai sito sani ti̱ꞌañe peo doꞌire.” ");
INSERT INTO seyNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ja̱ maca judío pa̱ipi i̱ohuaꞌija̱ꞌa sa̱ꞌñe se̱teña, ñeje cajë: “¿Jerona sani huesësiꞌquë caquëꞌni, iquë, mai ti̱ꞌañe peo hue̱ꞌñarepa? ¿Judío pa̱ipi griego pa̱ina co̱ꞌme huesëni paꞌicohuaꞌina sani griego pa̱ini yeꞌyaja̱ꞌquëpi caquë? ");
INSERT INTO seyNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Me caquë yëꞌëre coꞌeja̱ꞌcohuaꞌi aꞌë, coꞌejëtaꞌa ti̱ꞌañe pa̱jaꞌcohuaꞌi aꞌë, yëꞌë paꞌi hue̱ꞌña sani ti̱ꞌañe peo doꞌire caëꞌni, maire?” ");
INSERT INTO seyNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Fiesta tëji muꞌserepa cato ai ëja muꞌserepa paꞌiji. Paꞌi maca Jesupi huëni nëcani ai tutu capi, ñeje: “Oco ëa ju̱ꞌiquë pani daijë̱ꞌë, yëꞌëna. Dani u̱cujë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Toya pëpë cayeje̱ yëꞌëre sehuoquëre cato joyopi paꞌi ocorepa etaquëna, pasipi, tsiayaje̱ paꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ja̱je cani Jesús capi, i̱te i̱re papi cajë cuasacohuaꞌipi Maijaꞌquë deꞌo joyore ti̱ꞌajaꞌcohuaꞌi aꞌë caquë. Ja̱ maca cato ja̱ yëꞌtaꞌa Maijaꞌquë deꞌo joyo daiye pa̱pi, Jesupi ja̱ yëꞌtaꞌa maꞌtëmona coꞌimaꞌëna. ");
INSERT INTO seyNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Pa̱i jopo paꞌicohuaꞌipi ja̱je cayere asani careña: “Iquë cato nuñerepa Maijaꞌquëre quëacaiquë api. I̱ti daija̱ꞌquë api casiquë api.” ");
INSERT INTO seyNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Cajëna, yecohuaꞌipi careña: “Iquë cato Cristo api.” Ja̱je cajëtaꞌare yecohuaꞌipi cahuë: “¿Me Cristo paꞌiquëꞌni, Galilea yeja aquë? ");
INSERT INTO seyNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Toyaseꞌe cato caji, Cristo cato pa̱i ëjaërepa David tsëcapë aquë paꞌija̱ꞌquë api. Belén daripë aquë paꞌija̱ꞌquë api. David paꞌisi daripë aquë pasipi.” ");
INSERT INTO seyNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ja̱je paꞌina, Jesús doꞌire yoꞌojë cajë pa̱ipi huahue sahuë, yequë tsëca deꞌojë. ");
INSERT INTO seyNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Yecohuaꞌipi tse̱ani sañuꞌu cajëtaꞌa tse̱añe pa̱huë. ");
INSERT INTO seyNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Jesure tse̱seohuaꞌipi coꞌihuë, Maijaꞌquë huëꞌe ñacaicohuaꞌi quëꞌrona, cuiꞌne fariseo pa̱i cuiꞌne Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌi quëꞌrona. Coꞌirena, ja̱ohuaꞌipi se̱iꞌë: “¿Me yoꞌojë tse̱ani daye pa̱reꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Cajëna, pa̱ire tse̱secohuaꞌipi sehuojë cahuë: “¡Ai deꞌoyerepa yecohuaꞌije̱ ja̱ë cayeje̱ cacohuaꞌi ti peoyë!” ");
INSERT INTO seyNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ja̱ maca fariseo pa̱ipi cahuë: “¿Mësaruje̱ i̱ cosoyere sehuore? ");
INSERT INTO seyNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Yëquë ëjaohuaꞌije̱ i̱ caye asaye pa̱huë. Cuiꞌne fariseo ëjaohuaꞌije̱ i̱te asacaiye pa̱huë. ");
INSERT INTO seyNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ja̱je paꞌiquëtaꞌare cua̱ñeseꞌe caye asamaꞌcohuaꞌipi coꞌacohuaꞌipi sehuocaiyë, ne huesëja̱ꞌcohuaꞌipi.” ");
INSERT INTO seyNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemo fariseo aquëpi ñami sani Jesure ñasiquëpi capi, ja̱ohuaꞌire: ");
INSERT INTO seyNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Mai cua̱ñeseꞌeje̱ paꞌye yoꞌoni, ja̱ëte huani je̱oñe peoji, ja̱ yëꞌtaꞌa i̱ yoꞌoseꞌere asamaꞌpë pani.” ");
INSERT INTO seyNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ja̱je caquëna, ja̱ maca sehuoreña: “¿Mëꞌëje Galilea aquë aë? Deꞌhua toyaseꞌere yeꞌyejë̱ꞌë, Ja̱re mëꞌë yeꞌyenitaꞌa Galileapi, Maijaꞌquëre quëacaiquë teꞌije̱ daiye pa̱seꞌe, asaye paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ja̱ maca pa̱i ñape i̱ohuaꞌi huë̱ꞌñaseꞌena sani sahuë. ");
INSERT INTO seyNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesupi Olivos cu̱tihuëna sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ñatasi muꞌse nea hue̱ꞌña Maijaꞌquë huëꞌena coꞌipi. Siꞌa pa̱i i̱ quëꞌrona tsio daëꞌë. Datena, jaꞌruni ñuꞌi yeꞌya huëopi. ");
INSERT INTO seyNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ja̱ maca cua̱ñeseꞌe yeꞌyacohuaꞌipi cuiꞌne fariseo pa̱ipi ë̱mëre yoꞌocona, ti̱ꞌasiconi dahuë. Dani i̱ti maca paꞌicohuaꞌi jopona nëconi. ");
INSERT INTO seyNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jesure cahuë: “Yeꞌyaquë, iye nomiore yëquë dahuë, ë̱mëre yoꞌocona, ti̱ꞌasiconi. ");
INSERT INTO seyNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisés cua̱ñeseꞌepi maire cua̱ñeji ñeje yoꞌo nomiohuaꞌire quë̱na pë̱api je̱a joꞌa hue̱ajëꞌë, caquë. ¿Ja̱je paꞌito mëꞌë me caquëꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Iye cato cahuë, neñañuꞌu cajë. Ca tayouna, sa̱ñope cayere cajë cahuë. Ja̱ maca Jesús meñe në meni moñopi yejana toyapi. ");
INSERT INTO seyNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ja̱je yoꞌoquëna, ja̱ohuaꞌi cato ja̱ yëꞌtaꞌa se̱jë nëcahuë. Ja̱ maca yuretaꞌa nuñerepa nëcaquë capi, ja̱ohuaꞌire: “Mësaru aquëpi ti tayo coꞌaye yoꞌomaꞌquëpi quë̱na pë i̱ni i̱ona je̱o huëoja̱quë.” ");
INSERT INTO seyNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ja̱je cani cuiꞌnaëpi në me co̱ni yejana toyapi. ");
INSERT INTO seyNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ja̱re asani, ai cuasajë teꞌo huaꞌiseꞌe etajë saëꞌë. Aiohuaꞌipi eta huëoni siꞌa pa̱i etahuë. Siꞌa pa̱i sani saisi maca Jesuseꞌe pëapi, nomio ja̱ꞌre co̱ni. ");
INSERT INTO seyNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ja̱ maca Jesús nuiñe nëcani pa̱ije peojëna, ñani nomioseꞌe paꞌiona, capi: “¿Nomio jerore paꞌiyeꞌni, mëꞌëre sa̱ñope casicohuaꞌi? ¿Teꞌije̱ mëꞌëre nejoñe pa̱ë?” ");
INSERT INTO seyNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Caquëna, i̱opi cao: “Pa̱huë, sa̱ñope yoꞌoye, Ëjaë.” Cacona, ja̱ maca Jesupi capi: “Yëꞌëje̱ mëꞌëre sa̱ñope caye pa̱ñë. Yurepi sani cuiꞌnaopi coꞌaye yoꞌo co̱ñe pa̱jëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ti̱jupë Jesús pa̱ire caquë capi: “Yëꞌë aꞌë, iye yeja miacaiquë. Yëꞌëre peꞌtequë cato miañere pasipi, paꞌiye i̱siyere. Ja̱je paꞌi nea hue̱ꞌñare cuꞌiye pa̱sipi.” ");
INSERT INTO seyNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Caquëna, ja̱ maca fariseo pa̱ipi cahuë: “Mëꞌëjaꞌa coꞌye deꞌoquë aꞌë caquë quëayë, mëꞌë. Ja̱je quëaye cato coꞌaji.” ");
INSERT INTO seyNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Cajëna, Jesupi capi: “Yëꞌë quëaye cato doꞌi quëꞌye aꞌë, yëꞌëpi yëꞌëja̱ꞌa coꞌye caquë quëatoje̱. Yëꞌë cato asayë, yëꞌë dai sito cuiꞌne yëꞌë saija̱ꞌto. Ja̱je paꞌiquëtaꞌare mësaru cato huesëyë, yëꞌë dai sito cuiꞌne yëꞌë saija̱ꞌto. ");
INSERT INTO seyNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mësaru cato iye yeja pa̱i coꞌaji cayepi cacohuaꞌi aꞌë. Yëꞌë cato teꞌireje̱ coꞌaji, camaꞌquë aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ja̱je paꞌiquëtaꞌare yëꞌëpi coꞌaji cani yëꞌëseꞌe caye pa̱ñë. Yëꞌë jaꞌquë yëꞌëre jëjo daosiquëpi yëꞌë ja̱ꞌre co̱ni caquëna, cayë. Yëꞌë caye cato nuñere paꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mësaru cua̱ñeseꞌe cato caji cayahuaꞌi cuiꞌne teꞌeje̱ paꞌye cato asaye paꞌiji, care payë cajë. ");
INSERT INTO seyNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ja̱je paꞌiye sëte yëꞌëja̱ꞌa coꞌye quëacaiquë paꞌiyë. Yëꞌë jaꞌquë yëꞌëre jëjo daosiquëje̱ yëꞌëre quëacaiquë api.” ");
INSERT INTO seyNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Caquëna, ja̱ maca se̱teña: “¿Jerore paꞌiquëꞌni, mëꞌë jaꞌquë?” Cajëna, Jesupi sehuopi: “Mësaru yëꞌëre ña ti̱ꞌañe pa̱ñë. Pa̱jë cuiꞌne jaꞌquëreje̱ ña ti̱ꞌañe pa̱ñë. Yëꞌëre ña ti̱ꞌacohuaꞌi pani, jaꞌquëreje̱ ña ti̱ꞌañe patiraꞌpi.” ");
INSERT INTO seyNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iye cato Jesús capi, ja̱ yëꞌtaꞌa Maijaꞌquë huëꞌere paꞌi yeꞌya maca. Maijaꞌquëna curi i̱si mahuëa quëꞌropi nëcaquë caseꞌe aꞌë. Ja̱je catoje̱ i̱te tse̱añe pa̱huë, ja̱ yëꞌtaꞌa i̱te tse̱a maca ti̱ꞌañe pa̱seꞌe sëte. ");
INSERT INTO seyNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Cuiꞌnaëpi Jesús ca co̱pi: “Yëꞌë saiyë. Saquëna, mësaru coꞌeja̱ꞌcohuaꞌi aꞌë. Ja̱je coꞌejëtaꞌa ja̱re mësaru tayo coꞌaye yoꞌoyena ju̱ꞌijaꞌcohuaꞌi aꞌë. Ja̱je paꞌina, yëꞌë sai hue̱ꞌña, mësaru saiye pa̱jaꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ja̱ maca judío pa̱ipi cahuë: “¿Coꞌye huani ju̱siꞌquë caquë. Ja̱je yoꞌouna, i̱ quëꞌro ti̱ꞌañe paja̱ꞌcohuaꞌi aꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Cajëna, ja̱ maca Jesupi capi, ja̱ohuaꞌire: “Mësaru cato i̱ño huëꞌehuë acohuaꞌi aꞌë. Yëꞌë cato jeto ë̱më aquë aꞌë. Mësaru cato iye yeja acohuaꞌi aꞌë. Yëꞌë cato iye yeja aquë peoyë. ");
INSERT INTO seyNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ja̱je paꞌina, cahuë, mësaru tayo coꞌaye yoꞌoyena ju̱ꞌijaꞌcohuaꞌi aꞌë, yëꞌëni i̱re papi cajë cuasamaꞌcohuaꞌi pani. Ja̱je mësaru tayoyena ju̱ꞌijaꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ja̱ maca se̱teña: “¿I̱queiꞌni, mëꞌë?” Cajëna, Jesupi sehuopi: “Tsoe mësarute ja̱ꞌa huëo maca cahuë. ");
INSERT INTO seyNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Jaiye mësaru tayoyere caye paꞌiquëtaꞌare pa̱ñë. Yëꞌëre jëjo daosiquëpi nuñerepa caji, ti tayoye peoyerepa. Ja̱je paꞌina, yëꞌë iye yeja pa̱ire caye cato i̱ caquëna, asaseꞌere cayë.” ");
INSERT INTO seyNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ja̱je caquëna, ja̱ohuaꞌipi, Maijaꞌquë ayere caji cajë asaye pa̱huë. ");
INSERT INTO seyNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ja̱je paꞌi doꞌire capi: “Mësarupi yëꞌëre ë̱mëjeꞌna huëo nëcosi maca Pa̱i Mamaquëre i̱re papi cajë ñajaꞌcohuaꞌi aꞌë. Ja̱ maca yuretaꞌa coa i̱si yoꞌoye pa̱pi cajë ñajaꞌcohuaꞌi aꞌë. Ja̱je paꞌina, yëꞌë cato jaꞌquë yeꞌyaseꞌere cayë, mësarute. ");
INSERT INTO seyNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yëꞌëre jëjo daosiquë cato yëꞌë ja̱ꞌre co̱ni paꞌiji, yëꞌë jaꞌquë yëꞌëre teꞌire je̱oñe pa̱pi. Ja̱je paꞌina, yëꞌë cato siꞌanë i̱ yëyere yoꞌoyë.” ");
INSERT INTO seyNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ja̱je Jesús iyere caëna, jai pa̱i i̱te i̱re papi cajë cuasare pahuë. ");
INSERT INTO seyNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ja̱ maca Jesús capi, judío pa̱ipi i̱te i̱re papi cajë cuasasicohuaꞌire: “Mësarupi yëꞌë nuñerepa caseꞌere tayo saimaꞌpë paꞌini, ja̱ macataꞌa nuñerepa yëꞌëre yeꞌyecohuaꞌi paꞌiyë. ");
INSERT INTO seyNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ja̱je paꞌijë nuñerepa paꞌiyere ñajaꞌcohuaꞌi aꞌë. Ñajëna, nuñerepa paꞌiyepi mësarute joꞌyaohuaꞌi peocohuaꞌire neñe paꞌiji, joye huasoyeje̱ paꞌye.” ");
INSERT INTO seyNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ja̱je caquëna, ja̱ohuaꞌipi sehuohuë: “Yëquë cato Abraham tsëcapë acohuaꞌi aꞌë, cuiꞌne ti yecohuaꞌi joꞌya paꞌimaꞌcohuaꞌi aꞌë. ¿Me yoꞌoquë mëꞌë, joꞌya tse̱asicohuaꞌi peojë deꞌoye paꞌija̱ꞌcohuaꞌi aꞌë, caquëꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Cajëna, Jesupi capi: “Siꞌaohuaꞌi tayo coꞌaye yoꞌocohuaꞌi cato tayo coꞌaye yoꞌoyepi joꞌyaohuaꞌire paquëna, paꞌiyë. ");
INSERT INTO seyNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Siꞌanë i̱ti tsëcapë ja̱ꞌre paꞌiquë api. Mamaquë cato ja̱je paꞌiquëtaꞌare joꞌyaë cato coa co̱ni paꞌiquë api, i̱ti tsëcapë aquë peoquëpi, ti paꞌiye peopi. ");
INSERT INTO seyNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ja̱je paꞌina, mësaru i̱ Mamaquëre papi joꞌyaohuaꞌi paꞌiyere nejocaquëna, ja̱ maca yuretaꞌa nuñerepa joꞌyaohuaꞌi peoye paꞌija̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Tsoe asayë, mësaru Abraham tsëcapë acohuaꞌi paꞌiye. Ja̱je paꞌiohuaꞌitaꞌa yëꞌëre huani je̱oñe yëyë, yëꞌë cayere asaye coe doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yëꞌë jaꞌquë i̱ñoseꞌere cayë, mësarute. Caquëna, mësarupi mësaru jaꞌquë caseꞌere yoꞌoyë.” ");
INSERT INTO seyNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Caquëna, i̱ohuaꞌipi cahuë, i̱te: “Abraham cato yëquë jaꞌquë api.” Cajëna, Jesupi capi: “Mësarupi nuñerepa Abraham mamajë pani i̱ yoꞌoseꞌeje̱ cuiꞌne yoꞌoraꞌhuë. ");
INSERT INTO seyNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Tsoe mësarute nuñerepa Diusu yeꞌyaseꞌere cahuë. Ja̱je paꞌiquëtaꞌare yëꞌëre huani je̱oñe yëyë, mësaru. ¡Abraham ja̱je yoꞌoye ti pa̱pi! ");
INSERT INTO seyNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mësaru cato mësaru jaꞌquë yoꞌoyepi yoꞌoyë.” Caquëna, ja̱ maca i̱ohuaꞌipi cahuë: “Yëquë cato coa huero mamajë peoyë. Teꞌire jaꞌquëre payë. Ja̱ë cato Diusupi.” ");
INSERT INTO seyNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Cajëna, ja̱ maca Jesupi capi: “Nuñerepa mësaru Jaꞌquëpi Diusu paꞌito mësaru yëꞌëre otiraꞌhuë. Yëꞌë cato Diusu quëꞌropi daisiquë aꞌë. Daisiquëpi i̱ñore paꞌiyë. Yëꞌëseꞌe daisiquë peoyë. Diusupi jëjo daosiquë aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Me yoꞌojë mësaru, yëꞌë cayë asa ti̱ꞌañe pa̱ñeꞌni? Mësarupi asaye coe doꞌire pa̱ñë. ");
INSERT INTO seyNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mësaru jaꞌquë cato huati api. Mësaru i̱ tse̱cohuaꞌi aꞌë. Ja̱je paꞌina, i̱ yëyere yoꞌoye yëyë. Huati cato huani je̱oquë api. Ja̱re ja̱je paꞌi api, tsoeje̱, ti nuñerepa yoꞌomaꞌquë api, cuiꞌne ti nuñerepa camaꞌquë api. Coa cosoyere cani, ja̱je i̱ ayere caji, coa cosou sëte, coa cosoye pëca jaꞌquë sëte. ");
INSERT INTO seyNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ja̱je paꞌina, yëꞌë nuñere pare caquëni, mësaru asacaiye coeyë. ");
INSERT INTO seyNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Nepi mësaru acohuaꞌi, yëꞌëre mëꞌë tayoyë cajë i̱ñojaꞌcohuaꞌi aꞌni? Nuñerepa yëꞌë caquëre, ¿me yoꞌojë mësaru care paji cajë asacaiye pa̱ñeꞌni? ");
INSERT INTO seyNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Diusu te̱ꞌte aquëpi, Maijaꞌquë coca asaye paꞌiji. Ja̱je paꞌiquëtaꞌare mësaru cato Diusu acohuaꞌi peoyë. Ja̱je paꞌina, asaye coeyë, yëꞌë caye.” ");
INSERT INTO seyNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ja̱ maca judío pa̱ipi cahuë: “Nuñere pajë mëꞌëre ja̱je caquëꞌni, Samaritanopi cuiꞌne coꞌa joyore hueꞌequë api cayë, yëquë.” ");
INSERT INTO seyNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Cajëna, Jesupi sehuopi: “Coꞌa joyore ti peoquë aꞌë. Yëꞌë cato jaꞌquëni deꞌoquëre papi cacaiyë. Ja̱ doꞌire mësaru cato yëꞌëre coꞌaquë api, cayë. ");
INSERT INTO seyNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yëꞌëre deꞌoye cacaijë̱ꞌë caquë oimaꞌë paꞌiyë. Yëꞌëre deꞌoye cacaiquë paꞌiji. Ja̱ë api, i̱ti yoꞌoseꞌe paꞌiyeje̱ caquërepa. ");
INSERT INTO seyNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nuñerepa cayë, yëꞌë caye asani yëꞌë cayeje̱ yoꞌoquë cato ti ju̱ꞌiñe pa̱jaꞌquë api.” ");
INSERT INTO seyNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ja̱ maca judío pa̱ipi sehuohuë: “Yuretaꞌa asare pahuë, mëꞌë nuñerepa coꞌa joyore hueꞌequërepa paꞌiye. Abraham cuiꞌne Maijaꞌquëre quëacaicohuaꞌi tsoe acohuaꞌije̱ ju̱ni huesëa̱ꞌhuëꞌë. Ja̱je paꞌiquëtaꞌare mëꞌëpi cayë ‘yëꞌë caye asani, yëꞌë cayeje̱ yoꞌoquë cato ti ju̱ꞌiñe pa̱jaꞌquë api.’ ");
INSERT INTO seyNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Yëquë jaꞌquë cato Abraham. ¿Mëꞌëpi se̱ña maca paꞌi aꞌë cuasaquë, mëꞌë? Abraham cuiꞌne Maijaꞌquëre quëacaicohuaꞌi ju̱ju saꞌa̱huëꞌë. ¿I̱quei aꞌë cuasaquë mëꞌë caquëꞌni, ja̱je?” ");
INSERT INTO seyNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Cajëna, Jesupi sehuopi: “Yëꞌëja̱ꞌa coꞌye deꞌoye yoꞌoyë caquë paꞌito yëꞌë deꞌoye yoꞌoyë caye ti co̱caiye pa̱ji. Ja̱je paꞌiquëtaꞌare mësaru yëquë jaꞌquë api caquëpi yëꞌëre deꞌoye yoꞌoji cacaiji yëꞌë jaꞌquëpi. ");
INSERT INTO seyNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ja̱je paꞌiquëtaꞌare mësaru ña ti̱ꞌamaꞌpë paꞌiyë. Yëꞌëtaꞌa i̱te ñaquë aꞌë. Ja̱je ñaquëtaꞌa yëꞌëpi ñamaꞌquë aꞌë caquë pani coa cosourepa paꞌiye paꞌiji mësaruje̱ paꞌi. Ja̱je paꞌiquëtaꞌare yëꞌë cato nuñerepa ñaquë aꞌë. Ja̱je paꞌina, i̱ caye sehuocai yoꞌoyë. ");
INSERT INTO seyNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham mësaru aipi sihuaꞌa̱jiꞌi, yëꞌë muꞌseñare ñajaꞌquë aꞌë caquë. Ñani sihua huajëa̱ꞌjiꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ja̱ maca judío pa̱i Jesure cahuë: “Ti cincuenta o̱metëcajë peoquëpi ¿Abrahamre ñaꞌahuëꞌë cayë, mëꞌë?” ");
INSERT INTO seyNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Cajëna, Jesupi capi: “Nuñerepa mësarute cayë. Yëꞌë cato Abraham paꞌimaꞌnë ai jerepa tsoe aquë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Caëna, ja̱ maca quë̱na pë̱api i̱mani je̱añuꞌu Jesuna cajë yoꞌohuë. Yoꞌojëna, catipi. Catini Maijaꞌquë huëꞌepi i̱ohuaꞌi jopoja̱ꞌa sa etani sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Pa̱i paꞌi hue̱ꞌñajaꞌa sai Jesús ñapi, tsi̱ꞌnëna ñaco ca̱ porei ai deꞌosiquëre. ");
INSERT INTO seyNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ja̱je paꞌina, ñani i̱ yeꞌyacohuaꞌipi se̱iꞌë, Jesure: “¿Me yoꞌoquë ñaco ca̱ porei ai deꞌouꞌni, ja̱ë? Pëca jaꞌquëohuaꞌi tayo doꞌire coꞌaye ai deꞌou, pa̱nitaꞌa ¿i̱ doꞌi aꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Cajëna, Jesupi capi: “I̱ tayo doꞌije̱ peoji. Cuiꞌne pëca jaꞌquëohuaꞌije̱ tayo doꞌije̱ peoji. Iquë cato i̱te juju maca Maijaꞌquë yoꞌoye pa̱ire i̱ñojaꞌquëpi ai deosiquë api. ");
INSERT INTO seyNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ja̱ yëꞌtaꞌa muꞌse paꞌinë yëꞌëre jëjo daosiquë coꞌamaña yoꞌoye paꞌiji. Ñami deꞌo huëoji. Ñami cato coꞌamaña neñe peoji. ");
INSERT INTO seyNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Yëꞌë ja̱ yëꞌtaꞌa iye yejare paꞌini yëꞌë aꞌë, miacaiquë iye yeja paꞌicohuaꞌire.” ");
INSERT INTO seyNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Iye se ca tëjini Jesús yejana copi neni yaꞌore a̱ꞌji së̱pë neni ñamaꞌquë ñaco ca̱na yaꞌopi nepi. ");
INSERT INTO seyNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ja̱ maca capi: “Siloé oco dea pëna sani tsoa to̱jëꞌë. Siloé cani cayë, jëjo daosiquë.” Ja̱je caëna, ñamaꞌquëpi sani tsoa to̱ni tsoe ñaquëpi dajiꞌi, i̱ quëꞌro. ");
INSERT INTO seyNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ja̱ maca ja̱ꞌnë ñamaꞌquë paꞌina, ñasicohuaꞌipi cuiꞌne i̱ quë̱no maca paꞌicohuaꞌipi cahuë: “¿Iquë mai ñajëna, curi se̱i ñuꞌisiquë paꞌimaꞌquë aë?” ");
INSERT INTO seyNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Cajëna, yecohuaꞌipi cahuë: “Ja̱je paꞌijë̱ꞌë. I̱ api.” Yecohuaꞌipi cahuë: “Ja̱re i̱je paꞌitaꞌa yequë api.” Ja̱je cajëna, i̱pi capi: “Yëꞌë i̱ aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ca maca i̱te se̱teña: “¿Me mëꞌë yure neni ñaquë paꞌiquëꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Cajëna, i̱pi sehuopi: “Ja̱ë Jesús hueꞌequëpi yëꞌëre yaꞌopi a̱ꞌjiñe neni ñaco ca̱na je̱ꞌnapi. Ja̱je yoꞌoni capi: ‘Siloé oco dea pëna sani tsoajë̱ꞌë.’ Caëna, sani tsoa to̱ maca tsoe ñaquë paëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ja̱je caquëna, i̱te se̱iꞌë: “¿Jerore paꞌiquëꞌni?” Cajëna, i̱pi capi: “Huesëyë.” ");
INSERT INTO seyNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ja̱ maca fariseo pa̱i quëꞌrona ñaco ca̱ porei paꞌisiquëre sahuë. ");
INSERT INTO seyNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jesús yaꞌopi neni ñaco ca̱ poreire jujusi muꞌse cato huajë muꞌse pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ja̱je paꞌisi doꞌire, fariseo pa̱ipi asani ñamaꞌquë paꞌisiquëre se̱ni co̱huë. Me mëꞌë yure neni ñaquëꞌni cajë. Cajëna, i̱pi capi: “Yaꞌopi a̱ꞌjiñe neni yëꞌëre ñaco ca̱na je̱ꞌnaëna, sani tsoa to̱ni yure ñaquë paꞌiyë.” ");
INSERT INTO seyNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ja̱ maca fariseo acohuaꞌi cahuë: “Iye yoꞌosiquë cato Diusu te̱ꞌte peoquëpi ja̱je yoꞌopi, huajë muꞌse aꞌë caye peoye.” Ja̱je, cajëna, yecohuaꞌipi cahuë: “¿Me coꞌaquë pani ñeje, pa̱i yoꞌo ti̱ꞌa maꞌñere deꞌoye yoꞌoquëꞌni, i̱?” Ja̱je yoꞌojë cajë yequë tsëcapë̱a huayeque pajiꞌi, sa̱ꞌñe ca doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ti̱jupë se̱ni co̱huë, ja̱ꞌrë ñamaꞌquë paꞌisiquëre ñeje cajë: “¿Mëꞌë i̱queipi caquëꞌni, mëꞌëre ñañe necaisiquëre?” Cajëna, i̱pi sehuopi: “Yëꞌë cato cayë, Maijaꞌquëre quëacaiquë api.” ");
INSERT INTO seyNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ja̱je caquëtaꞌare judío pa̱ipi nuñerepa ñamaꞌquë paꞌisiquëpi ñaji cajë asaye pa̱huë. Coa caji cajë, i̱ pëca jaꞌquëohuaꞌireje̱ soihuë, ja̱ doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Soini se̱iꞌë: “¿Mësaru mamaquë aë, iquë ñaco ca̱ porei ai deꞌosiquë? ¿Yure ja̱je paꞌitaꞌa me yoꞌoquë ñaquëꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Cajëna, i̱ pëca jaꞌquëohuaꞌipi sehuohuë: “Yëquë mamaquë api. Cuiꞌne i̱te co̱a macana ñamaꞌquë. Ai deꞌosiquë api asayë, yëquëpi ja̱ cato. ");
INSERT INTO seyNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ja̱je paꞌiquëtaꞌare yure cato huesëyë, me yoꞌoquë ñaquë po̱nëꞌni cajë i̱te ñañe necaisiquëreje̱ huesëyë. I̱ni se̱ni asajë̱ꞌë. Tsoe ai api, i̱pi quëaja̱quë ja̱ doꞌire ñaquë paꞌiyë, caquë.” ");
INSERT INTO seyNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ñamaꞌquë pëca jaꞌquëohuaꞌi cato coa judío pa̱ini caꞌrajë ja̱je cahuë. Siꞌahuaꞌire Jesure Cristo api cacohuaꞌire pa̱i tsiꞌsi hue̱ꞌñapi eto saoye paꞌiji cajë cuiꞌñaseꞌere asajë. ");
INSERT INTO seyNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ja̱ doꞌire i̱ pëca jaꞌquëohuaꞌipi cahuë: “I̱ni se̱ni asajë̱ꞌë. Tsoe ai api.” ");
INSERT INTO seyNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ja̱ maca judío pa̱i ñamaꞌquë paꞌisiquëre soi co̱reña. Daquëna, cahuë: “Nuñerepa quëajë̱ꞌë, Diusu ña hue̱ꞌñare pana. Yëquë asayë, mëꞌëre jujusiquëre tayo yoꞌoquë api cajë.” ");
INSERT INTO seyNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Cajëna, i̱pi sehuopi: “Yëꞌë cato huesëyë, tayo yoꞌoquë api caye cuiꞌne pa̱quëre papi cayeje̱. Yëꞌë ta̱ꞌñe asaye cato iyeseꞌe paꞌiji, ja̱ꞌrë ñamaꞌquë paꞌisiquëpi yure ñaquë paꞌiyë.” ");
INSERT INTO seyNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ti̱jupë se̱teña: “¿Me mëꞌëre neiꞌni? ¿Mëꞌëre me yoꞌoni ñaquëre neiꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Cajëna, sehuopi: “Tsoe quëahuë, mësarute. Quëatoje̱ asa yëmaꞌpë paꞌiyë. Yëꞌë caye: ¿I̱quere cajë cuiꞌnare ca co̱jëꞌë cajë se̱ñeꞌni? ¿I̱ni tuñuꞌu cajë yëjë se̱ñe?” ");
INSERT INTO seyNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Caquëna, ja̱ maca i̱te ai tea ju̱ni tëjini capi: “Mëꞌëpi i̱ni tuina nëiji, yëquë cato Moisésre tuicohuaꞌi aꞌë cahuë. ");
INSERT INTO seyNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Yëquë asayë, Moisésre Diusupi caseꞌe. Ja̱ëre cato huesëyë, i̱ paꞌi hue̱ꞌñaje.” ");
INSERT INTO seyNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Cajëna, i̱pi capi: “¡Merepa yoꞌojë mësaru huesëyeꞌni, ai yeꞌyesicohuaꞌitaꞌa, i̱ dai sito, yëꞌëre ñaco ca̱ jujucaisiquëre! ");
INSERT INTO seyNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Maipi asayë, tayo yoꞌocohuaꞌire Diusu asacaiye pa̱ji. I̱te sihuacohuaꞌire cuiꞌne i̱ yëye yoꞌocohuaꞌiseꞌere asacaiquë api, Diusu. ");
INSERT INTO seyNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tsoeje̱ ti asamaꞌcohuaꞌi aꞌë, tsihuaꞌë paꞌinë ñamaꞌquë ai deꞌosiquëni ñaquëre necaiseꞌe. ");
INSERT INTO seyNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Iquëpi Diusu quëꞌropi daimaꞌquë pani ti ja̱je yoꞌoyeje̱ pa̱raꞌpi.” ");
INSERT INTO seyNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Caquëna, ja̱ maca i̱ohuaꞌipi cahuë: “¿Tayo yoꞌoye ti̱mësiquëpi ai deꞌosiquë api, mëꞌë yëquëre yeꞌyasiꞌi caquë?” Ja̱je cani i̱te pa̱i tsiꞌsi hue̱ꞌñapi eto saohuë. ");
INSERT INTO seyNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús tsoe asapi, ñamaꞌquë paꞌisiquëpi ñaquë paꞌina, judío pa̱ipi eto saoseꞌe. Jesupi i̱te ti̱ꞌani capi: “¿Diusu mamaquëre mëꞌë i̱re papi cuasaquë paꞌiquë?” ");
INSERT INTO seyNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Caquëna, i̱pi capi: “Ëjaë, quëajë̱ꞌë, yëꞌëre. Jequë aꞌni, yëꞌëje̱ i̱te ja̱ë api caquë cuasaquë paꞌija̱ꞌquëre.” ");
INSERT INTO seyNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Caquëna, Jesupi sehuopi: “Tsoe mëꞌë ñahuë. Yëꞌë i̱ aꞌë. I̱ ja̱ꞌre mëꞌë coca cayë.” ");
INSERT INTO seyNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ja̱ maca Jesús yëꞌquë macana doꞌre jaꞌruni capi: “I̱re papi caquë cuasayë, Ëjaë, mëꞌëre.” ");
INSERT INTO seyNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ja̱ jeteyoꞌje capi, Jesús: “Yëꞌë cato iye yejana daëꞌë, nuñerepa yoꞌoyepi paꞌija̱quë caquë. Ñamaꞌcohuaꞌi paꞌisicohuaꞌipi ñajajë caquë, cuiꞌne ñacohuaꞌi paꞌisicohuaꞌipi joyopi ñamaꞌcohuaꞌi paꞌija̱jë caquë.” ");
INSERT INTO seyNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ja̱ maca fariseo pa̱ipi i̱ ja̱ꞌre co̱ni paꞌisicohuaꞌipi iyere asani se̱iꞌë: “¿Yëquëje̱ mëꞌë ñato ñaco ca̱ peocohuaꞌi aꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Cajëna, Jesupi sehuopi: “Mësarupi ñamaꞌcohuaꞌi pani mësaru tayo yoꞌo doꞌire jai doꞌi peocohuaꞌi patiraꞌhuë. Ja̱je paꞌiquëtaꞌare mësarupi ñacohuaꞌi aꞌë caye sëte doꞌi quëꞌiohuaꞌi paꞌiyë. ");
INSERT INTO seyNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Nuñerepa mësarute cayë, yëi ñama eta saꞌroja̱ꞌa tuꞌrihuëna cacamaꞌquë pani, ñaëpi cuiꞌne coꞌaquëpi eta saꞌro peo hue̱ꞌñajaꞌa cacaquë cato. ");
INSERT INTO seyNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ja̱je paꞌiquëtaꞌare yëi ñama eta saꞌroja̱ꞌa cacaquë cato yëi ñamare ñacaiquë api. ");
INSERT INTO seyNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Eta saꞌro huiꞌyocaiquëje̱ deꞌoye huiꞌyocaiji, cacaja̱quë caquë. Cuiꞌne yëi ñamaje asayë, i̱ yëꞌo. I̱ohuaꞌi mamire caquë soiji, yëi ñamare. Cuiꞌne tuꞌrihuë nëicohuaꞌini hueꞌsena etoji. ");
INSERT INTO seyNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Etoni sai saji, i̱pi duꞌru sai. Yëi ñamaje asayë, i̱ yëꞌo. Ja̱je asajë tuiyë, i̱te. ");
INSERT INTO seyNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ja̱je tuicohuaꞌitaꞌa yequëpi soiquë paꞌito asani coa catiyë, ñamaꞌquëre sëte yequë yëꞌo caquëna, asajë.” ");
INSERT INTO seyNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ñeje yoꞌoyë, pa̱i caquë i̱ñoquëtaꞌare pa̱ipi asa ti̱ꞌañe pa̱huë, Jesús caye. ");
INSERT INTO seyNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ja̱ maca Jesús ti̱jupë ca co̱pi: “Nuñerepa mësarute cayë. Yëꞌë aꞌë, eta saꞌro yëi ñama caca saꞌro. ");
INSERT INTO seyNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ja̱ yëꞌtaꞌa yëꞌë daimaꞌnë daisicohuaꞌi cato ñaohuaꞌi aꞌë cuiꞌne coꞌacohuaꞌi aꞌë. Ja̱je paꞌiquëtaꞌare yëi ñamapi asaye pa̱huë, i̱ohuaꞌi cayere. ");
INSERT INTO seyNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yëꞌë aꞌë, eta saꞌro. Yëꞌëja̱ꞌa cacasiquë cato huaso cua̱ñosiquë paꞌija̱ꞌquë api. Ja̱je paꞌi etasiquëpi cuiꞌne cacasiquëpi i̱ yëyeje̱ yoꞌoquë paꞌija̱ꞌquë api, cuiꞌne deꞌo a̱ore ti̱ꞌajaꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ñaë cato coa yahue i̱mañe caquë cacaquë api, huani je̱osiꞌi caquë, cuiꞌne nejosiꞌi caquë. Yëꞌë cato yëi ñamapi paꞌiyere paja̱jë caquë daisiquë aꞌë, ti paꞌiyere jaiye paja̱jë caquë. ");
INSERT INTO seyNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yëꞌë cato deꞌoye yëi ñamare ñacaiquë aꞌë. Deꞌoye ñacaiquëpi yëi ñamapi paꞌija̱jë i̱seꞌe caquë i̱ paꞌiyere i̱siquë api. ");
INSERT INTO seyNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Coa sa̱i doꞌire necaiquë cato lobopi daina, ñani yëi ñamare ñacaiye je̱oni catiquë api, yëi ñamare ñacaimaꞌquë sëte, cuiꞌne yëi ñamaje ti̱ohuaꞌire sëte ja̱je yoꞌoji. Yoꞌouna, ja̱ maca lobopi dani tse̱ani yoꞌoquë tiya huesoquë api cuiꞌna hue̱ꞌña. ");
INSERT INTO seyNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Catiquë cato sa̱i doꞌire yoꞌoquë api. Ja̱je paꞌina, oi ëayeje̱ ti peoji, i̱te yëi ñamare. ");
INSERT INTO seyNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Yëꞌë aꞌë, deꞌoyerepa yëi ñamare ñacaiquë yëꞌëre jaꞌquë ñaquë paꞌiyeje̱, yëꞌëje̱ i̱te jaꞌquëre ñaquë paꞌiyë. Ja̱je cuiꞌne yëꞌë yëi ñamareje̱ ñaquë payë. Ñaquëna, i̱ohuaꞌije̱ yëꞌëre ñañë. Yëꞌëpi yëꞌë paꞌiyere yëi ñama doꞌire i̱siyë. ");
INSERT INTO seyNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Payë, cuiꞌne yequë yëi ñamareje̱. Yequë tuꞌrihuë acohuaꞌire ja̱ohuaꞌireje̱ i̱ñona daye paꞌiji, yëꞌëre. Ja̱ohuaꞌije̱ yëꞌë caye sehuocaija̱ꞌcohuaꞌi aꞌë. Ja̱ maca cuiꞌne teꞌe tsëcapë paꞌija̱ꞌcohuaꞌi aꞌë, cuiꞌne teꞌi yëi ñamare ñacaiquë paꞌija̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Jaꞌquë yëꞌëre yëji, yëꞌë paꞌiyere i̱sisiquëpi cuiꞌnaëpi yëꞌë paꞌiye pa co̱jaꞌquëpi yoꞌoquëna. ");
INSERT INTO seyNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Yëꞌë paꞌiye jioquë peoji. Yëꞌë yëyepi i̱siyë, yëꞌë paꞌiye. Yëꞌë ja̱je neñe paꞌiji cuiꞌne cuiꞌnare pa co̱ñeje deꞌoji. Iye aꞌë, yëꞌë Jaꞌquë yëꞌëre cua̱ñeseꞌe.” ");
INSERT INTO seyNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Iyere judío pa̱i asani cuiꞌnaohuaꞌipi hua co̱huë, ti̱ tsëcapë̱a. ");
INSERT INTO seyNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Jai pa̱i i̱ohuaꞌi acohuaꞌipi cahuë: “¿Me neñuꞌju i̱ caye asani sehuocaiyeꞌni, care paji cajë coꞌa joyore hueꞌequëpi cuiꞌne coa cuepequë caquëre?” ");
INSERT INTO seyNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Cajëna, yecohuaꞌipi cahuë: “Coꞌa joyore hueꞌequëpi ja̱je ca ti̱ꞌañe peoji. ¿Coꞌa joyopi ñamaꞌquëre ñaquëre necaiye paꞌiquë? Cuiꞌne ti peoji.” ");
INSERT INTO seyNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ja̱ muꞌseña cato oco tëcahuë pajiꞌi. Paꞌina, Jerusalén cato Maijaꞌquë huëꞌe ne ja̱ꞌñere cuasajë sihuajë jai pa̱i tsiꞌsini yoꞌo maca ti̱ꞌapi. ");
INSERT INTO seyNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesús cato Maijaꞌquë huëꞌe sa̱ꞌnahuëre cuniroja̱jiꞌi, Salomón hueꞌyosi hue̱ꞌña. ");
INSERT INTO seyNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ja̱ maca judío pa̱ipi Jesure tsiꞌsini cahuë: “¿Yëquëre mëꞌë je yëhua nuñerepa quëaja̱ꞌquëpi huesë ëaye caquë paꞌiquëꞌni? Mëꞌëpi nuñerepa Cristo pani quëare pajë̱ꞌë, teꞌe nuñerepa.” ");
INSERT INTO seyNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Cajëna, Jesupi capi: “Tsoe mësarute cahuë. Caquëtaꞌare mësarupi care paji cajë asaye pa̱huë. Yëꞌë jaꞌquë cua̱ñesi tutupi yoꞌoyë. Ja̱ yoꞌoyepi ti̱ñarepa i̱ñoji, mësarute. ");
INSERT INTO seyNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ja̱je paꞌiquëtaꞌare mësarupi nuñere paꞌë cajë asaye pa̱ñë, yëꞌë yëi ñama acohuaꞌi paꞌimaꞌ doꞌire. Tsoe cahuë, ja̱ꞌrë. ");
INSERT INTO seyNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Yëꞌë yëi ñamapi asayë, yëꞌë yëꞌona. Asajëna, yëꞌëpi i̱ohuaꞌire ñañë. Ñaquëna, i̱ohuaꞌije̱ yëꞌëre peꞌteyë. ");
INSERT INTO seyNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yëꞌëpi ti ju̱ꞌimaꞌpë paꞌiye i̱siquë aꞌë. I̱sina, ti ne huesëmaꞌpë paꞌija̱ꞌcohuaꞌi aꞌë, cuiꞌne yëꞌë jë̱ñare paꞌicohuaꞌire yecohuaꞌi mañaje jioye ti peoji. ");
INSERT INTO seyNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yëꞌë jaꞌquëpi yëꞌëna i̱sipi, i̱ohuaꞌire. I̱sisiquë cato siꞌaye jerepa paꞌi api. I̱te cato yecohuaꞌije̱ ti jio ti̱ꞌañe peoji, i̱ jë̱tëre pacohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yëꞌë cuiꞌne jaꞌquë co̱ni teꞌije̱ paꞌiohuaꞌi paꞌiyë.” ");
INSERT INTO seyNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ja̱ maca judío pa̱i cuiꞌnaohuaꞌipi quë̱na pë̱api i̱mani je̱añuꞌu cajë yoꞌohuë. ");
INSERT INTO seyNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yoꞌojëna, Jesupi capi: “Mësaru asajëna, jaiye deꞌoyere necaëꞌë, yëꞌë jaꞌquë tuture papi. ¿Iye nesi doꞌi aye mësarupi asato jeco aꞌni, yëꞌë coꞌaye yoꞌosico, ja̱je quë̱na pë̱api je̱añuꞌu ca ja̱ꞌñe?” ");
INSERT INTO seyNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Caquëna, judío pa̱ipi sehuohuë: “Mëꞌë deꞌoye yoꞌosi doꞌire mëꞌëre quë̱na pë̱api je̱oñe pa̱jaꞌcohuaꞌi aꞌë. Mëꞌëpi yëꞌë aꞌë, Diusu casi doꞌire quë̱na pë̱api je̱ajaꞌcohuaꞌi aꞌë, mëꞌëre. Mëꞌë cato coa pa̱itaꞌa, yëꞌë Diusure paꞌë caquë yoꞌoyë.” ");
INSERT INTO seyNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ja̱ maca Jesupi capi: “Mësaru cua̱ñeñepi toyaseꞌe caji Diusu mësarute caseꞌere ñeje: ‘Mësaru aꞌë, diusuohuaꞌi.’ ");
INSERT INTO seyNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Toyaseꞌe caye cato nuñerepa caye aꞌë. Ja̱je paꞌina, care paji cajë asayë, mai. Diusupi hueꞌyopi, i̱ coca asasicohuaꞌire diusu aꞌë, mësaru. ");
INSERT INTO seyNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿Diusupi yëꞌëre huani iye yejana jëjo daosiquëpi Diusu mamaquë aꞌë caye me neni coꞌaquëꞌni? ");
INSERT INTO seyNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Jaꞌquë yoꞌoyere yëꞌëpi yoꞌomaꞌëna, i̱re papi caye pa̱jëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ja̱je paꞌiquëtaꞌare yëꞌëpi yoꞌoquëna, i̱re papi yoꞌoji cajë asamaꞌcohuaꞌitaꞌa yëꞌë yoꞌo i̱ñoñere ñajë Maijaꞌquë yoꞌoye aꞌë cajë asajë̱ꞌë. Ja̱ maca yuretaꞌa asa ti̱ꞌañe paꞌiji, Maijaꞌquëpi yëꞌë ja̱ꞌre paꞌiji, cuiꞌne yëꞌëpi i̱ ja̱ꞌre paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ti̱jupë tse̱ani preso saye yëhuë. Ja̱je paꞌiquëtaꞌare Jesupi deꞌhue jëapi. ");
INSERT INTO seyNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ja̱ maca Jesús Jordán tsiaya ë̱së mëi te̱ꞌtena coꞌipi. Coꞌini ja̱rona pëapi, Juan oco doquë paꞌi sitona. ");
INSERT INTO seyNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ja̱rote paꞌina, jai pa̱i i̱ quëꞌrona sani ñajë cahuë: “Nuñerepa Juan, pa̱i yoꞌo ti̱ꞌa maꞌñere yoꞌomaꞌquëtaꞌa care paquë caseꞌe pajiꞌi, iquë yoꞌo ja̱ꞌñe ayere.” ");
INSERT INTO seyNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ja̱rona jai pa̱i i̱re papi cajë cuasahuë, i̱te. ");
INSERT INTO seyNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Teꞌi ë̱më ju̱ꞌiquë Lázaro hueꞌequë pajiꞌi. Ja̱ë cato Betania aquë pajiꞌi. María cuiꞌne i̱o yoꞌjeo Marta paꞌi daripë aquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","María cato ju̱ꞌiquë Lázaro yoꞌjeo pacoꞌë. Ja̱o cato Ëjaërepa nëcañoana huëo së̱ daꞌcapi ja̱ñuni i̱o nañapi të̱nocaio yoꞌosico pacoꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ja̱je paꞌina, ja̱ohuaꞌipi Ëjaë mëꞌë cajeipi ju̱ꞌiji caquë sani quëacaijë̱ꞌë cajë Jesús quëꞌro jëjo saohuë, teꞌire. ");
INSERT INTO seyNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jëjo saorena, Jesús ja̱re asani capi: “Iye ju̱ꞌi dahuë cato ti ju̱ni huesëyena saye pa̱ ja̱ꞌñe aꞌë. Diusu i̱ deꞌoquë paꞌiyere i̱ño ja̱ꞌñe aꞌë. Cuiꞌne Maijaꞌquë mamaquë deꞌoquë paꞌiyere i̱ño ja̱ꞌñe aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús cato Marta cuiꞌne i̱o majaꞌyo Maríare cuiꞌne Lázarore ai oiquëtaꞌa. ");
INSERT INTO seyNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Caya muꞌseña se pëa co̱pi, i̱ paꞌi hue̱ꞌñana, Lázaro ju̱ꞌiji cajë quëasicohuaꞌitaꞌare. ");
INSERT INTO seyNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ja̱ jeteyoꞌje capi, Jesús i̱ yeꞌyacohuaꞌire: “Sani co̱ñuꞌu, Judeana.” ");
INSERT INTO seyNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Caquëna, i̱ yeꞌyacohuaꞌipi i̱te cahuë, ja̱ maca: “¿Yeꞌyaquë, mëꞌëre judío pa̱i quë̱na pë̱api je̱añuꞌu ca sitona coꞌija̱ꞌquë aë?” ");
INSERT INTO seyNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Cajëna, Jesupi capi: “¿Teꞌe muꞌse doce hora paꞌicoa, miañe? Ja̱je paꞌina, pa̱ipi muꞌse cuꞌini ti juꞌaye peoji, iye yeja miacaiyeja̱ꞌa cuꞌini.” ");
INSERT INTO seyNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ja̱je paꞌiquëtaꞌare pa̱ipi ñami cuꞌini juꞌaye paꞌiji, miañe peo doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ja̱ jeteyoꞌje Jesupi capi: “Mai cajei Lázaro ca̱jiꞌi. Ca̱isiquëtaꞌare sani ne sëtoja̱ꞌquë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Caquëna, ja̱ maca i̱ yeꞌyacohuaꞌipi cahuë, i̱te: “¿Ëjaë, ja̱je ca̱jiꞌi cani coꞌyaja̱ꞌquë api caye aꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesús cato ja̱je cani ju̱jiꞌi caquë capi. Ja̱je caquëna, i̱ yeꞌyacohuaꞌipi cuasani coa huëore ca̱ina caji cuasahuë. ");
INSERT INTO seyNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ja̱ maca Jesupi yuretaꞌa ti̱ñarepa capi: “Lázaro tsoe ju̱jiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Sihuayë, deꞌoye ja̱rote paꞌimaꞌëna ju̱jiꞌi. Ja̱jepi ai deꞌoji. Mësaru ñani mësaru i̱re papi cajë yëꞌëre cuasaja̱ꞌcohuaꞌire. Sani ñañuꞌu.” ");
INSERT INTO seyNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ja̱ maca Tomás Gemelo hueꞌequëpi i̱ ja̱ꞌre yeꞌyecohuaꞌire capi: “Jë̱najë̱ꞌë, maije i̱ ja̱ꞌre co̱ni sañuꞌu, teꞌe i̱ ju̱ꞌina ju̱ꞌijaꞌcohuaꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Tsoe Lázarote cuatro muꞌseña ta̱seꞌe paꞌina, Jesús ti̱ꞌapi. ");
INSERT INTO seyNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania cato Jerusalén jaꞌyere pajiꞌi, coa caya kilómetropi cuiꞌne yequë jopo kilómetro co̱si macare. ");
INSERT INTO seyNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Jai pa̱i judío pa̱i acohuaꞌipi Marta cuiꞌne Maríare doꞌi ñajë cuiꞌne i̱ohuaꞌi majaꞌyëpi ju̱quëna, oicohuaꞌini yëhuo huasoñuꞌu cajë daisicohuaꞌipi paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ja̱ maca Martapi Jesús daiji asani etani i̱te pëpasiꞌi caco sacoꞌë. María cato huëꞌe sa̱ꞌnahuëre pacoꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ja̱ maca Martapi Jesure cao: “Ëjaë, mëꞌë i̱ñore paꞌiquë paꞌito yëꞌë aꞌyë ju̱ꞌiñe pa̱raꞌpi. ");
INSERT INTO seyNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ja̱je paꞌiquëtaꞌare yëꞌë cato asayë, Maijaꞌquëpi mëꞌë se̱ñere i̱sija̱ꞌquë api.” ");
INSERT INTO seyNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Cacona, Jesupi capi: “Mëꞌë aꞌyë cuiꞌnaëpi pani co̱jaꞌquë api.” ");
INSERT INTO seyNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Caquëna, Martapi cao: “Ja̱je paꞌijë̱ꞌë. Cuiꞌnaëpi pani co̱jaꞌquë api, ju̱ni huesësicohuaꞌi huëi maca tëji muꞌserepa.” ");
INSERT INTO seyNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Cacona, Jesupi capi: “Yëꞌë aꞌë, ju̱ni huesësicohuaꞌi huëiye cuiꞌne paꞌiye. Yëꞌëre i̱re papi caquë cuasaquë cato ju̱ꞌisiquëje̱ ja̱re paꞌija̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Cuiꞌne ja̱ yëꞌtaꞌa huajëquë paꞌi yëꞌëre i̱re papi caquë cuasaquë cato ti ju̱ꞌiñe pa̱jaꞌquë api. ¿Iye yëꞌë caye ja̱je paꞌire paji caco cuasaco, mëꞌë?” ");
INSERT INTO seyNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Caquëna, i̱opi cao: “Ja̱je paꞌijë̱ꞌë, cuasayë, yëꞌë. Cuiꞌne Ëjaë, mëꞌë cato Cristore papi asayë, yëꞌë. Diusu mamaquëpi iye yejana daija̱ꞌquë ca nëosiquëpi daisiquë aꞌë, mëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ja̱je se ca tëjini Marta i̱o majaꞌyo María quëꞌrona sani cao, yahue: “Yeꞌyaquë i̱ñore paꞌi mëꞌëre daija̱co caquë soiji.” ");
INSERT INTO seyNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Cacona, i̱ti se asayeja̱ꞌa Jesús quëꞌrona esa sacoꞌë, i̱te ñasiꞌi caco. ");
INSERT INTO seyNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ja̱ yëꞌtaꞌa Jesús pa̱i daripërepa cacaye pa̱pi. Ja̱ maca cato, Marta i̱te ti̱ꞌasi macare pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Maríapi coꞌarepa huëni saiona, ñani judío pa̱ipi María huëꞌere paꞌijë oimaꞌo cajë yëhuocohuaꞌipi ta̱si daripëna sani osiꞌi caco saico cuasajë tuëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ja̱ maca María Jesús quëꞌrona sani doꞌre jaꞌruni cao: “Ëjaë, i̱ñore mëꞌë paꞌiquë paꞌito aꞌyë ju̱ni huesëye pa̱raꞌpi.” ");
INSERT INTO seyNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","María ja̱ꞌre co̱ni judío pa̱i daisicohuaꞌipi oijëna, Jesupi ja̱ohuaꞌire oi ëayerepa ñapi. Ñani i̱ joyopi ca ëayerepa nëina, ");
INSERT INTO seyNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ja̱ohuaꞌire se̱jiꞌi: “¿Jerona i̱te ta̱reꞌni?” Caquë se̱ina, i̱ohuaꞌipi cahuë: “Ëjaë, dani ñajëꞌë. I̱ñona ta̱huë.” ");
INSERT INTO seyNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ja̱ maca Jesús ojiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Oina, ñani judío pa̱ipi cahuë, ja̱ maca: “I̱ ai oiquërepa pajiꞌi. Ñajëꞌë, i̱ oiyere.” ");
INSERT INTO seyNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Yecohuaꞌipi cahuë: “Ñamaꞌquëre ñaquëre nesiquë api, iquë. ¿Ja̱je paꞌitaꞌa cuiꞌne me yoꞌoquë Lázarore jujucaiye pa̱ëꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Cuiꞌnaëni coꞌarepa esa necatiꞌñerepa nëina, ta̱si daripë quëꞌrona tsio dajiꞌi. Coje nesico pajiꞌi. Paꞌioni jai quë̱na pëpi si̱osico pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Paꞌiona, Jesupi capi: “Quë̱na përe huiꞌyo je̱ojëꞌë.” Caquëna, Marta ju̱ꞌisiquë yoꞌjeopi cao: “Ëjaë, tsoe coꞌa së̱ji cuasayë. Tsoe cuatro muꞌseña paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Cacona, Jesupi capi: “Mëꞌëje paꞌioni cahuë care paji cuasani mëꞌë ñajaꞌcoaꞌë, Maijaꞌquë deꞌoyerepa yoꞌoquëna caseꞌe.” ");
INSERT INTO seyNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Caëna, ja̱ maca quë̱na pë huiꞌyo je̱orena, Jesús maꞌtëmo mëñe ñaquë capi: “Deꞌoji, Jaꞌquë. Yëꞌë caye mëꞌëpi asacaëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yëꞌë cato asayë, mëꞌë siꞌanë yëꞌë caye asaquë paꞌiye. Ja̱je paꞌiquëtaꞌare iye maca paꞌicohuaꞌi asa ja̱ꞌñere caquë cayë, mëꞌëpi yëꞌëre jëjo daosiquë api cajë asare paja̱jë caquë.” ");
INSERT INTO seyNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ja̱je se ca tëjini, ai tutu cuipi: “¡Lázaro etajë̱ꞌë!” ");
INSERT INTO seyNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Caquëna, ju̱ꞌisiquë paꞌisiquëpi jë̱ña, nëcañoa hue̱siquëpi, cuiꞌne tsiaje̱ ca̱ñapi hue̱siquëpi etapi. Etaquëna, ja̱ maca Jesupi capi: “Joyecaijë̱ꞌë, saija̱quë.” ");
INSERT INTO seyNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ja̱je iyere yoꞌouna, Jesure jai pa̱i judío pa̱i i̱re papi cajë cuasahuë, María ja̱ꞌre co̱ni daisicohuaꞌipi, i̱ti Jesús yoꞌoquëna, ñasicohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ja̱ohuaꞌi acohuaꞌipi fariseo pa̱i quëꞌrona sani ñajë quëahuë, Jesús yoꞌoseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ja̱ maca fariseo pa̱ipi cuiꞌne Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌipi ca tëji ëjaohuaꞌi quëꞌrona tsiꞌsini cahuë: “¿Me nejaꞌcohuaꞌi aꞌni, ja̱ëte? I̱ cato jaiye pa̱i yoꞌo ti̱ꞌa maꞌñe yoꞌo i̱ñoji, pa̱ire. ");
INSERT INTO seyNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ja̱je paꞌina, maipi coa ñacohuaꞌi paꞌito siꞌa pa̱ipi i̱seꞌena asa huesëja̱ꞌcohuaꞌi paꞌini. Ja̱je yoꞌojëna, yuretaꞌa romano pa̱ipi dani Maijaꞌquëre se̱ huëꞌe cuiꞌne mai yeja ne huesoja̱ꞌcohuaꞌi paꞌini.” ");
INSERT INTO seyNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Cajëna, Caifás hueꞌequëpi Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaëpi ja̱ o̱metëcahuë paꞌiquëpi capi, ja̱ohuaꞌire: “Mësaru huesëjë cayë. ");
INSERT INTO seyNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Cuiꞌne ti asamaꞌpë, teꞌi ju̱cacatiꞌñe paꞌi api, siꞌa pa̱i doꞌire ai jerepa siꞌa pa̱i ju̱ꞌiñe peoye, iye daripë paꞌicohuaꞌire.” ");
INSERT INTO seyNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Caifás cato i̱seꞌe ta̱ꞌñe ja̱je caye pa̱pi. Coa Maijaꞌquë joyopi i̱siquëna, capi, ja̱ o̱metëcahuë Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaë sëte, Jesupi judío pa̱i doꞌire ju̱cacaiye paꞌiji, paꞌi ja̱ꞌñere ca nëoquë. ");
INSERT INTO seyNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Coa judío pa̱iseꞌere caquë ju̱cacaiye pa̱ni cuiꞌne siꞌa hue̱ꞌña coa tiya huesësicohuaꞌire Diusu mamajëre. ");
INSERT INTO seyNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ja̱re ja̱ muꞌsepi yuretaꞌa judío pa̱i ëjaohuaꞌi Jesure huani je̱oñe ca nëohuë. ");
INSERT INTO seyNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ja̱je paꞌina, Jesús yuretaꞌa siꞌa judío pa̱i ñajëna, cuꞌiye pa̱pi. Pa̱quë Judeapi etani Efraín daripëna sajiꞌi, cue̱ne yeja jaꞌye maca paꞌi daripëna. Ja̱rona sani i̱ yeꞌyacohuaꞌi ja̱ꞌre pëapi. ");
INSERT INTO seyNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Aꞌri maña carapi, Egíptopi Israel pa̱i etajë paꞌiseꞌere cuasajë tsiꞌsini yoꞌo muꞌseña. Ja̱je paꞌina, jai pa̱i paꞌi daripë̱a paꞌicohuaꞌi saëꞌë, Jerusalénna siꞌsire tsoa to̱ñere cajë. ");
INSERT INTO seyNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jesure coꞌejë cuëꞌë. Ja̱je paꞌina, Maijaꞌquë huëꞌere paꞌijë se̱iꞌë, yecohuaꞌire: “¿Mësaru me cuasayeꞌni? Daija̱ꞌquë api fiestana, pa̱nitaꞌa pa̱jaꞌquë api cuasaye cajë.” ");
INSERT INTO seyNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Fariseo pa̱i cuiꞌne Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌipi cua̱ñe nëohuë. Jesús paꞌi hue̱ꞌñare asasicohuaꞌi pani quëajë̱ꞌë, sani tse̱ajaꞌquëre cajë. ");
INSERT INTO seyNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Seis muꞌseña Egíptopi Israel pa̱i etajë paꞌiseꞌere cuasajë yoꞌoye caraquëna, Jesupi Betaniana sajiꞌi. Lázaro paꞌi hue̱ꞌñana ju̱ꞌisiquëni Jesupi ne coꞌyasiquë pajiꞌi, ja̱ë cato. ");
INSERT INTO seyNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ja̱rona Jesure a̱o cuaꞌconi a̱ohuë. Martapi a̱o huahueco pacoꞌë. Lázaropi Jesús ja̱ꞌre co̱ni mesare ñuꞌi a̱jiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ja̱ maca Maríapi huëo së̱ maꞌña daꞌcare dani Jesús quë̱ona ja̱ꞌñeni i̱o nañapi të̱no cue̱nao. Ja̱je yoꞌocona, siꞌa huëꞌe huëo së̱ñena ti̱mëo. Ja̱ cato jai doꞌi maꞌña pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ja̱ maca Judas Iscariotepi Simón mamaquëpi Jesús yeꞌyaquëpi, Jesure coso yehuoja̱ꞌquëpi capi: ");
INSERT INTO seyNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“¿Me yoꞌoco iye huëo së̱ maꞌña coa yecohuaꞌina se i̱sico trecientos romano curiquë të̱ꞌña nemaꞌo pacoꞌni, neni curi peocohuaꞌire co̱caija̱ꞌcotaꞌa?” ");
INSERT INTO seyNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas ja̱je cani curiquë peocohuaꞌini ai oi doꞌire camaꞌë pajiꞌi. Coꞌamaña yahue i̱maquëpi capi. Ja̱je i̱pi curi aya topë paquë sëte, yahue i̱maquë pajiꞌi, i̱ona yecohuaꞌipi aya curire. ");
INSERT INTO seyNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ja̱ maca Jesupi i̱te capi: “Coa ñajëꞌë. Yëꞌëre ta̱ muꞌse huëo së̱ ja̱ꞌñere ne deꞌhuaco yoꞌoco. ");
INSERT INTO seyNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Curi peocohuaꞌire siꞌanë mësaru ñajë paja̱ꞌcohuaꞌi aꞌë. Ja̱je paꞌiquëtaꞌare yëꞌëre cato siꞌanë paye peosipi.” ");
INSERT INTO seyNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jesús Betaniare paꞌiji asani jai pa̱i judío pa̱i saëꞌë, ja̱rona. Jesuseꞌere ñañuꞌu cajë saiye pa̱huë. Lázarore ñañuꞌu, Jesús ju̱ꞌisiquëni huëosiquëre cajë saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Cuiꞌneje Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌipi Lázaroreje̱ huani je̱oñe paꞌiji cahuë. ");
INSERT INTO seyNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Judío pa̱ipi Lázaro doꞌire Jesupi i̱re papi cajë cuasa doꞌire, cuiꞌne i̱ohuaꞌire je̱oco doꞌire ja̱je cahuë. ");
INSERT INTO seyNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Jai pa̱i Jerusalénna saëꞌë, Egíptopi Israel pa̱i etajë paꞌiseꞌere cuasajë yoꞌo muꞌse ti̱ꞌaëna. Se ñatasi muꞌse Jesús daija̱ꞌquë api, iye daripëna asani. ");
INSERT INTO seyNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ja̱ maca Jesús daina, sihuajë jaꞌo tëteni cuijë saëꞌë. Jesure pëpañuꞌu cajë cuihuë: “¡Deꞌoquëre paꞌni, Diusu! ¡Deꞌoquëre paꞌni, Ëjaë mamirepa hueꞌequëpi daiquë! ¡Deꞌoquëre paꞌni, Israel pa̱i Ëjaë!” ");
INSERT INTO seyNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Burrore ti̱ꞌani Jesús tui sajiꞌi, toyaseꞌe cayeje̱ paꞌye ja̱pi caji ñeje: ");
INSERT INTO seyNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Caꞌramaꞌo paꞌijë̱ꞌë. Israel pa̱i daripë Mëꞌë Ëjaërepa daiji, burroni ñuꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Iye caseꞌe i̱ yeꞌyacohuaꞌi asa ti̱ꞌañe pa̱huë, duꞌru macarepa cato. Jesús deꞌoquërepa deꞌosi maca ja̱ maca yuretaꞌa asahuë, siꞌaye Jesús ayere toyaseꞌe pajiꞌi cajë cuiꞌne ja̱je tëto sajiꞌi, mai ña hue̱ꞌñana cuasajë. ");
INSERT INTO seyNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jesús ja̱ꞌre paꞌijë Lázarore ju̱quëna, ta̱siquëni huëoquë soiquëna, asasicohuaꞌipi yecohuaꞌire se quëahuë, i̱ohuaꞌi ñaseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ja̱je paꞌina, Jesure sa̱ñope ti̱ꞌani pëpañuꞌu cajë saëꞌë, pa̱i yoꞌo ti̱ꞌa maꞌñere yoꞌoquëna, asasi doꞌire cajë. ");
INSERT INTO seyNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ja̱ maca fariseo pa̱ipi cahuë, i̱ohuaꞌija̱ꞌa sa̱ꞌñe: “Ñañe mësaru siꞌa pa̱i i̱seꞌere tuiye, yure cato ne ti̱ꞌañe peoji.” ");
INSERT INTO seyNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Fiesta paꞌi maca Maijaꞌquëre se̱ñuꞌu cajë Jerusalénna saisicohuaꞌi ja̱ꞌre co̱ni griego pa̱ije paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Paꞌicohuaꞌipi ja̱ohuaꞌipi Felipena tsio dani Betsaida Galilea aquëna se̱jë cahuë: “Ëjaë, yëquë Jesure ñañe yëyë.” ");
INSERT INTO seyNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ja̱je cajëna, asani Felipepi sani Andrésni capi. Cani yuretaꞌa cayaohuaꞌi Jesure sani cahuë. ");
INSERT INTO seyNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Cajëna, Jesupi ja̱ maca capi: “Tsoe ti̱ꞌapi, Maijaꞌquë mamaquë deꞌoquërepa deꞌoja̱i maca. ");
INSERT INTO seyNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mësarute cayë, trigo ca̱pi yejana to̱memaꞌco pani ja̱re teꞌe ca maca paꞌio caraja̱icoa. Ja̱je paꞌiquëtaꞌare i̱ti ca̱pi yejana to̱meni ju̱nitaꞌa jaiye quë̱icoa, i̱ti ñëpi mëani. ");
INSERT INTO seyNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","I̱ paꞌiyere ai oiquë cato coa ne huesoja̱ꞌquë api. Ja̱je paꞌiquëtaꞌa iye yeja paꞌiyere coequë cato ne deꞌhuaquë paꞌiji, ti pani huesë ja̱ꞌñere. ");
INSERT INTO seyNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Pa̱ipi yëꞌëre necaiye yëni tuijë̱ꞌë, yëꞌëre. Yëꞌëre necaiquë cato, yëꞌë paꞌi hue̱ꞌñare co̱ni paꞌija̱ꞌquë api. Pa̱ipi yëꞌëre necaiquë paꞌito yëꞌë jaꞌquëpi i̱te deꞌoquëre paꞌni caquë ñacaija̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yure cato yëꞌë ai oiyë. ¿Ja̱ doꞌire jaꞌquëre ñeje ca ti̱ꞌañe paꞌiquë? ‘¿Jaꞌquë huasojë̱ꞌë, yëꞌëre yure tëto sai ja̱ꞌñere?’ Ja̱je ca ti̱ꞌañe peoji. Yëꞌë cato ja̱re caquë daisiquë aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Jaꞌquë mëꞌë mamire jerepa deꞌo mami nejëꞌë.” Ja̱ maca asapi, maꞌtëmopi yëꞌoseꞌe pi̱siquëna: “Tsoe deꞌoquëre pare nehuë. Ja̱je paꞌiquëtaꞌare ti̱jupë deꞌoquëre pare ne co̱siꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","I̱ti maca nëcajë asasicohuaꞌipi cahuë, mujuëpi pi̱siji. Cajëna, yecohuaꞌipi cahuë: “Hui̱ñaëpi i̱ni cocare capi.” ");
INSERT INTO seyNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ja̱ maca Jesupi capi: “Yëꞌëni caquë iye yëꞌo pi̱siye pa̱pi. Mësaru asa ja̱ꞌñere caquë iye yëꞌo pi̱sipi. ");
INSERT INTO seyNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Yure aꞌë, iye yeja i̱o yoꞌoseꞌe ña deꞌhua cua̱ño ja̱ maca, cuiꞌne yurepi iye yeja cua̱ñequëje̱ i̱ tutu nejo cua̱ñosiquë paꞌija̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Yëꞌëpi cruzuna mëa deo cua̱ñosi maca siꞌahuaꞌire tsiꞌso saosiꞌi yëꞌëseꞌena pa̱ire.” ");
INSERT INTO seyNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ja̱ quëayena pa̱i asahuë, cruzuna ju̱ꞌijaꞌquë aꞌë caquë quëaye. ");
INSERT INTO seyNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Pa̱ipi asani sa̱ñope sehuohuë: “Yëquë cato yequë toyapë ñacohuaꞌi aꞌë, Cristo ti ju̱ꞌiñe peoji cayere. ¿Me yoꞌoquë mëꞌë Pa̱i Mamaquë cruzuna ju̱ꞌijaꞌquë aꞌë caquëꞌni? ¿I̱queiꞌni, Pa̱i Mamaquë?” ");
INSERT INTO seyNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ja̱ maca Jesupi capi: “Ja̱ yëꞌtaꞌa mësaru ja̱ꞌre miañe paꞌiji. Ja̱ yëꞌtaꞌa miañe paꞌi maca miañejaꞌa cuꞌijë̱ꞌë, neañepi tsio daiona, merepa yoꞌocoꞌni cajë ai cuasaye pa̱cohuaꞌi. Nea hue̱ꞌñajaꞌa cuꞌiquë cato i̱ sai hue̱ꞌña huesëquë coa saiji. ");
INSERT INTO seyNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Miañe i̱tire pare paꞌiyë cajë asajë̱ꞌë, ja̱ yëꞌtaꞌa mësaru ja̱ꞌre co̱ni miacai paꞌi macapi. Ja̱je paꞌijë yuretaꞌa mia hue̱ꞌña paꞌicohuaꞌirepa po̱nëjaꞌcohuaꞌipi.” Ja̱je ca tëjini Jesús sani catipi, i̱ohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jaiye Jesús pa̱i yoꞌo ti̱ꞌa maꞌñere yoꞌo i̱ñosiquëtaꞌare i̱re papi cajë cuasaye pa̱huë. ");
INSERT INTO seyNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Maijaꞌquëre quëacaiquë Isaías ñeje toyaquë paꞌiseꞌepi ti̱ꞌa ja̱ꞌñepi paꞌina, pa̱huë asaye. Toyaseꞌe cato caji: Ëjaë ¿nepi yëquë quëaseꞌe care payë cajë asareꞌni? ¿Neni Diusu i̱ño uꞌni, i̱ tutu? ");
INSERT INTO seyNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ja̱je paꞌina, asa ti̱ꞌañe pa̱huë. Yequeje̱ Maijaꞌquëre quëacaiquë Isaías toyapi, ñeje: ");
INSERT INTO seyNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Diusupi ñamaꞌcohuaꞌire cuiꞌna jëa joyo quëꞌiohuaꞌire nepi, Ñaco ca̱pi ña maꞌñe caquë, Cuiꞌne joyopi asa maꞌñe caquë, Cuiꞌne Maijaꞌquëna po̱nëni juju cua̱ñomaꞌcohuaꞌini caquë. ");
INSERT INTO seyNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Iye cato Isaías capi, Jesús deꞌoquërepa paꞌiye ñasiquëpi. Ja̱je paꞌina, i̱ ayere capi. ");
INSERT INTO seyNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ja̱je paꞌiquëtaꞌare jai pa̱i judío pa̱i Jesure i̱re papi cajë cuasahuë. Yecohuaꞌi ëjaohuaꞌire paque cuasahuë, Jesure. Ja̱je paꞌiquëtaꞌare jai pa̱i cuasajëna, quëaye pahuë, fariseo pa̱ini caꞌra doꞌire, pa̱i tsiꞌsi hue̱ꞌñapi eto sao maꞌñe cajë. ");
INSERT INTO seyNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Fariseo pa̱i cato pa̱ipi i̱ohuaꞌini deꞌocohuaꞌire paꞌni cacaiyere yëcohuaꞌi paëꞌë. Maijaꞌquëpi deꞌoji cayere coecohuaꞌi paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesús ai tutu capi: “Yëꞌëre i̱re papi caquë cuasaquë cato yëꞌëseꞌere asaye peoji. Yëꞌë jaꞌquë yëꞌëre jëjo daosiquëreje̱ asaji. ");
INSERT INTO seyNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Yëꞌëre ñaquëpi yëꞌëre jëjo daosiquëreje̱ ñaji. ");
INSERT INTO seyNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yëꞌëre i̱re papi cajë cuasasicohuaꞌipi nea hue̱ꞌñare paꞌimaꞌpë paꞌija̱jë caquë muꞌse miañeje paꞌipi yëꞌë iye yejana daëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ja̱je paꞌiquëtaꞌare yëꞌë caye asaquëtaꞌa yëꞌë cayeje̱ yoꞌomaꞌquëre yëꞌëpi nejoñe pa̱jaꞌquë aꞌë. Yëꞌë cato iye yejana daisiquë aꞌë, iye yeja paꞌicohuaꞌire huasosiꞌi caquë. ");
INSERT INTO seyNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Yëꞌëre coequëpi cuiꞌne yëꞌë caye asani cuiꞌne yoꞌomaꞌquë cato, tsoe paji, i̱te nejo ja̱ꞌñe. Yëꞌë caseꞌepi tëji muꞌserepa pa̱ire nejo ja̱ꞌñe aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Yëꞌë cuasayepi huëoquë camaꞌë paꞌiyë. Yëꞌë jaꞌquë yëꞌëre jëjo daosiquë cua̱ñeseꞌere caquë yeꞌyayë, i̱ caseꞌeje̱ paꞌye caquë asayë, yëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Jaꞌquë cua̱ñeseꞌe cato ti pani huesë cocare paꞌë caquë asayë, yëꞌë. Ja̱je paꞌina, yëꞌë caye cato jaꞌquë cua̱ñeseꞌeje̱ paꞌye aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ja̱ yëꞌtaꞌa Egíptopi Israel pa̱i etajë paꞌiseꞌere cuasajë yoꞌo muꞌse ti̱ꞌamaꞌë teꞌe muꞌse carapi. Jesupi tsoe asapi, je̱ꞌnërepa iye yeja pani tëjini pëca jaꞌquë quëꞌrona coꞌiye ti̱ꞌaseꞌe. Siꞌanë Jesús cato ai oiquë pajiꞌi, i̱ tse̱cohuaꞌire iye yeja paꞌicohuaꞌire. Ja̱je paꞌina, yure cato i̱ ai oiyere pare i̱ñoquë yoꞌopi. ");
INSERT INTO seyNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Huati cato Simón mamaquëna Judas Iscariote joyona tsoe coꞌaye cuasaye nepi. Ja̱je paꞌina, Jesure coso yehuosiꞌi cuasayere papi, i̱ joyo. Jesús cato Diusu quëꞌropi daisiquë aꞌë asaquëpi, cuiꞌne coꞌija̱ꞌquë aꞌë Diusu quëꞌrona asaquëpi pajiꞌi. Cuiꞌne jaꞌquëpi yëꞌëre ëjaërepa paꞌi ja̱ꞌñe tutu i̱sipi asaquë pajiꞌi. Ja̱je paꞌina, Jesús i̱ yeꞌyacohuaꞌi a̱o a̱ijëna, co̱ni ñuꞌi a̱iquëpi, huëni i̱ ë̱mëjeꞌe juꞌicore dutani, i̱ juꞌruhuëna toayapi sëapi. ");
INSERT INTO seyNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ja̱ maca quë̱na deꞌhuana oco doni i̱ yeꞌyacohuaꞌire quë̱o tsoa huëopi. Tsoaquë i̱ toaya juꞌruhuëna sëasicopi të̱no cue̱nacajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simón Pedro quë̱ore tsoasiꞌi caquë yoꞌoquëna, i̱pi capi: “¿Ëjaë, mëꞌëpi yëꞌë quë̱ore tsoacasiꞌi caquë yoꞌoquë?” ");
INSERT INTO seyNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Caquëna, Jesupi sehuopi: “Yure mëꞌë huesëyë, yëꞌë caquë yoꞌoye. Pa̱siquëtaꞌa jeteyoꞌje mëꞌë asa ti̱ꞌajaꞌquë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ja̱je caquëtaꞌare Pedropi capi: “Yëꞌë quë̱o mëꞌëpi tsoacaiye peoji.” Caquëna, Jesupi capi: “Yëꞌëpi mëꞌëni tsoa to̱caimaꞌquë paꞌito mëꞌë yëꞌë te̱ꞌte aquë peoja̱ꞌquë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Caquëna, Simón Pedropi capi: “Ja̱je paꞌito Ëjaë, coa quë̱oseꞌe tsoamaꞌë paꞌijë̱ꞌë. Yëꞌëre jë̱ñaje̱ cuiꞌne si̱opëje̱ tsoacaijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Caquëna, Jesupi capi: “Ja̱ꞌa cuyasiquë cato coa nëcañoaseꞌe tsoaquë api, siꞌaë deꞌoquë paꞌiye sëte. Mësaru cato sisi peocohuaꞌi aꞌë. Ja̱je paꞌiquëtaꞌare siꞌahuaꞌi deꞌocohuaꞌiseꞌe paꞌiye pa̱ñë.” ");
INSERT INTO seyNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Siꞌaohuaꞌi siꞌsi peocohuaꞌiseꞌe paꞌiye pa̱ñë capi, i̱te coso yehuoja̱ꞌquëque paꞌina, asaquë. ");
INSERT INTO seyNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Quë̱o jaꞌo tsoa tëjini i̱ ë̱mëjeꞌe juꞌicore su̱ñani cuiꞌnaëpi mesana jaꞌruni capi: “¿Mësaru yëꞌë caquë yoꞌoseꞌe asa ti̱ꞌañe? ");
INSERT INTO seyNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mësaru yëꞌë Ëjaëpi cuiꞌne yeꞌyaquë api, cani nuñerepa cayë, ja̱ëre pani. ");
INSERT INTO seyNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Yëꞌë Ëjaëpi cuiꞌne yeꞌyaquëpi mësaru quë̱o tsoasiquëre sëte mësaruje̱ yecohuaꞌi quë̱o jaꞌoñare tsoacaiye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Iye cato mësaruni yoꞌo i̱ñoquë yoꞌohuë. Ja̱je yoꞌojë̱ꞌë, caquë yëꞌë yoꞌoseꞌeje̱. ");
INSERT INTO seyNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nuñerepa mësarute cayë. I̱ joꞌyaëpi i̱ ëjaëre tëto saisiquë peoji, cuiꞌne jëjo dao cua̱ñoquëje̱ i̱te jëjo daoquëre tëto saisiquë peoji. ");
INSERT INTO seyNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Asa ti̱ꞌani yëꞌë caseꞌeje̱ paꞌye yoꞌocohuaꞌi pani sihuacohuaꞌi paꞌija̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Mësarute siꞌaohuaꞌire pare camaꞌë paꞌiyë, coa yëꞌë sahua nëosiquëseꞌere cayë. Toyaseꞌe cayepi ti̱ꞌañe paꞌiji. Ja̱pi caji: ‘Yëꞌë ja̱ꞌre co̱ni a̱iquëpi yëꞌëre sa̱ñope yoꞌoquë po̱nëpi.’ ");
INSERT INTO seyNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Iye cato mësarute cayë i̱tipi tëto saina, ñani mësarupi nuñerepa i̱re papi capi cajë yëꞌëre asa ja̱ꞌñere caquë. ");
INSERT INTO seyNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nuñerepa cayë, mësarute. Yëꞌë jëjo daoquëre sihuaquë deꞌoye yoꞌoquëpi yëꞌëreje̱ sihuaquë deꞌoye yoꞌosipi. Yëꞌëre sihuaquë deꞌoye yoꞌoquëpi, yëꞌëre jëjo daoquëreje̱ sihuaquë deꞌoye yoꞌosipi.” ");
INSERT INTO seyNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ja̱ casi jeteyoꞌje Jesús i̱ joyopi caꞌñerepa nëina, capi, siꞌaye ti̱ñarepa: “Nuñerepa cayë. Mësaru aquëpi yëꞌëre yoꞌoquë yehuoja̱ꞌquë api.” ");
INSERT INTO seyNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ja̱ maca i̱ yeꞌyacohuaꞌipi sa̱ꞌñe i̱ohuaꞌija̱ꞌa ña huëohuë, nepi yoꞌoja̱ꞌcohuaꞌini cajë huesëjë. ");
INSERT INTO seyNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","I̱ yeꞌyacohuaꞌi aquëpi Jesús i̱ yëquëpi i̱ yëꞌquë macare ñuꞌi a̱jiꞌi, naꞌiquëna, a̱iñere. ");
INSERT INTO seyNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","A̲ina, Simón Pedropi coa moñopi mëꞌëpi se̱ni asajë̱ꞌë, nepi yoꞌoja̱ꞌcohuaꞌini caquëꞌni caquë yoꞌopi. ");
INSERT INTO seyNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Yoꞌoquëna, ñani Jesuna tsio ja̱ni se̱jiꞌi: “¿Ëjaë, jequë aꞌni, i̱ti yoꞌoja̱ꞌquë?” ");
INSERT INTO seyNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Caquëna, i̱pi sehuopi: “Panpë yëꞌëpi sa̱ꞌsuni a̱oquë cato i̱ paꞌija̱ꞌquë api.” Ja̱je cani panpë i̱ni sa̱ꞌsuni Judas Iscariotena a̱opi, Simón mamaquëna. ");
INSERT INTO seyNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ja̱re panpë i̱ maca tsoe huatije̱ Judas joyona cacapi. Ja̱ maca Jesús capi i̱te: “Mëꞌë yoꞌo ja̱ꞌñe paꞌito esa yoꞌojë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ja̱je catoje̱ i̱ti maca mesa ñuꞌicohuaꞌi asa ti̱ꞌañe pa̱huë, i̱ caye. ");
INSERT INTO seyNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judaspi curiquë deꞌhua turupë paquëre sëte yecohuaꞌi cato cuasahuë, sani a̱ore hueroja̱ijëꞌë fiesta yoꞌo ja̱ꞌñere caquë caji cuasahuë. Pa̱nitaꞌa curiquë peocohuaꞌina sani i̱sijë̱ꞌë caquë Jesús caji cuasahuë. ");
INSERT INTO seyNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Panpë i̱sisi jeteyoꞌje Judas etani sajiꞌi. Ja̱ maca cato tsoe ñami pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas etani saisi maca Jesupi capi: “Yure i̱ñoñe paꞌiji, Pa̱i Mamaquë deꞌoquërepa paꞌiye. Cuiꞌne Diusu deꞌoquërepa paꞌiyeje̱ i̱ñojaꞌquë api, i̱pi. ");
INSERT INTO seyNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Maijaꞌquë deꞌoquërepa paꞌiyere Pa̱i Mamaquëpi i̱ñoquë paꞌito, Maijaꞌquëje̱ mamaquë deꞌoquërepa paꞌiyere i̱ñosipi. Esa i̱ñojaꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Tsi̱ dohuë, mësaru ja̱ꞌre co̱ni tsoe paꞌiye paja̱ꞌquë aꞌë. Mësaru yëꞌëre coꞌeja̱ꞌcohuaꞌi aꞌë. Ja̱je paꞌina, ja̱re judío pa̱ire caseꞌeje̱ mësarute cayë. Mësaru yëꞌë sai sito sani ti̱ꞌañe peoji. ");
INSERT INTO seyNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mësarute huajëye cua̱ñeñere i̱siyë, pa̱ire oicohuaꞌi paꞌiyere yëꞌë mësarute oiyeje̱. Cuiꞌne mësarupi yecohuaꞌire se oijë paꞌijë̱ꞌë, caquë. ");
INSERT INTO seyNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Yecohuaꞌire mësarupi oicohuaꞌi paꞌito pa̱ipi mësarute yëꞌë yeꞌyacohuaꞌire paꞌë cajë ñajaꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedropi Jesure capi: “Ëjaë, ¿mëꞌë jerona sai caquëꞌni?” Caquëna, Jesupi sehuopi: “Yëꞌë sai hue̱ꞌña mëꞌë tuni ti̱ꞌañe peoji, yure cato. Jeteyoꞌje mëꞌë cato tuija̱ꞌquë aꞌë, yëꞌëre.” ");
INSERT INTO seyNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ja̱ maca Pedropi capi: “Ëjaë, ¿me yoꞌoquë yëꞌë yure tuni ti̱ꞌañe peoquëꞌni? Yëꞌë cato tsoe cuiꞌñasiquëpi paꞌiyë, mëꞌë doꞌire yëꞌëpi sa̱icasiꞌi caquë.” ");
INSERT INTO seyNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Caquëna, Jesupi sehuopi: “¿Nuñerepa yëꞌë doꞌire mëꞌëpi sa̱icaire pasiꞌi caquë cuiꞌñasiquëpi paꞌi caquë? Nuñerepa cayë. Mëꞌëre ja̱ yëꞌtaꞌa cura yëꞌimaꞌnë mëꞌëpi toaso̱ñe cosoja̱ꞌquë aꞌë, yëꞌëre ñamaꞌquë aꞌë caquë.” ");
INSERT INTO seyNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ai coꞌa ju̱ꞌimaꞌpë paꞌijë̱ꞌë. Diusuni necaiquë api cuasajë paꞌijë̱ꞌë. Cuiꞌne yëꞌëreje̱ necaiquë api cuasajë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Jaꞌquë maꞌtëmo huëꞌe cato jaiye paꞌiji, paꞌi hue̱ꞌña. Ja̱je paꞌimaꞌco paꞌito, yëꞌëpi mësarute tsoe quëaraꞌhuë. Ja̱je paꞌiye sëte yure cato saiyë, mësaru paꞌija̱ꞌto ne deꞌhuacasiꞌi caquë. ");
INSERT INTO seyNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Saisiquëpi paꞌi hue̱ꞌña ne deꞌhua tëjini ja̱ maca coꞌi co̱jaꞌquë aꞌë, mësarute sasiꞌi caquë. Saëna, mësaruje̱ yëꞌë paꞌi hue̱ꞌñare paꞌija̱jë caquë. ");
INSERT INTO seyNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mësaru cato asayë, yëꞌë sai hue̱ꞌña, cuiꞌne i̱ti maꞌaje asayë. ");
INSERT INTO seyNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Caquëna, Tomáspi capi: “Ëjaë, yëquë huesëyë, mëꞌë sai hue̱ꞌña. ¿Me mëꞌë saija̱ꞌa maꞌaje asayeꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Caquëna, Jesupi capi: “Yëꞌë aꞌë, maꞌa cuiꞌne yëꞌë aꞌë, nuñerepa cuiꞌne yëꞌë aꞌë, paꞌiye. Yëꞌëja̱ꞌa ti̱ꞌañe paꞌiji, jaꞌquëre. Peoji, yequëre ti̱ꞌañe. ");
INSERT INTO seyNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Mësarupi yëꞌëre ña ti̱ꞌacohuaꞌi pani jaꞌquëreje̱ ña ti̱ꞌaraꞌhuë. Ja̱je paꞌiquëtaꞌare yure i̱te mësaru ña ti̱ꞌañë, tsoe i̱te siꞌanë ñajë paꞌicohuaꞌi sëte.” ");
INSERT INTO seyNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ja̱ maca Felipepi capi: “Ëjaë, yëquëre i̱ñojëꞌë, mëꞌë jaꞌquëre. Coa ja̱ mañaseꞌe yëyë.” ");
INSERT INTO seyNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Caquëna, Jesupi sehuopi: “Felipe mësaru ja̱ꞌre co̱ni yëꞌë tsoe paꞌiyë. ¿Ja̱je paꞌiquëtaꞌare mëꞌë cato yëꞌëre ti ñamaꞌquë aꞌë? Yëꞌëni ñajë jaꞌquëreje̱ ñañe paꞌiji. Ja̱je paꞌito ¿Me yoꞌoquë mëꞌë jaꞌquëre i̱ñojëꞌë caquë se̱quëꞌni? ");
INSERT INTO seyNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Mëꞌë huesëquë yëꞌëpi jaꞌquë ja̱ꞌre tsioni paꞌiye, paꞌina, jaꞌquëpi yëꞌë ja̱ꞌre co̱ni paꞌiye? ¿Cuiꞌne mëꞌë asamaꞌë paꞌiquë ja̱ paꞌiye? Yëꞌë caye cato yëꞌëseꞌe cuasayepi caye pa̱ñë. Yëꞌë jaꞌquë yëꞌëre paꞌiquëpi i̱ coꞌamaña yoꞌoji. ");
INSERT INTO seyNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Pëca jaꞌquë ja̱ꞌre co̱ni paꞌire paji cajë cuasajë̱ꞌë. Cuiꞌne jaꞌquëpi yëꞌë ja̱ꞌre co̱ni paꞌiji cajë cuasajë̱ꞌë. Pa̱nitaꞌa ja̱re asa ti̱ꞌañe pa̱nije yëꞌë yoꞌoyena ñajë deꞌhue cuasajë̱ꞌë, care paji cajë. ");
INSERT INTO seyNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nuñerepa mësarute cayë. Yëꞌëre i̱re papi caquë cuasaquëpi, yëꞌë yoꞌo coꞌamañaje, yoꞌoja̱ꞌquë api. Yëꞌëpi yëꞌë jaꞌquë quëꞌrona saquëna, ja̱ doꞌire ai se̱ña maca deꞌo coꞌamañaje yoꞌoja̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Mësarupi yëꞌë mamina cajë se̱to yëꞌëpi yoꞌoja̱ꞌquë aꞌë. Mamaquëpi pëca jaꞌquë deꞌoquërepa paꞌiyere i̱ñojaꞌquë caquë. ");
INSERT INTO seyNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yëꞌë mamina cajë se̱jëna, yëꞌëpi yoꞌoja̱ꞌquë aꞌë, siꞌaye mësaru yëjë se̱ñe paꞌito. ");
INSERT INTO seyNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Mësarupi yëꞌëre oicohuaꞌi pani yëꞌë cua̱ñeseꞌere sehuocaijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Mësaru ja̱ꞌre siꞌanë paꞌija̱ꞌquëre yequëre jëjo daojë̱ꞌë caquë jaꞌquëre se̱siꞌi, mësarute co̱cai cuiꞌne quëcoye necaija̱ꞌquëre. ");
INSERT INTO seyNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ja̱ë cato nuñerepa ca joyo paꞌija̱ꞌquë api. Iye yeja pa̱i ja̱ëte pa ti̱ꞌañe peoji, i̱te ñamaꞌcohuaꞌi cuiꞌne i̱te asamaꞌcohuaꞌi. Ja̱je paꞌiquëtaꞌare mësaru cato asayë, i̱te. Cuiꞌne i̱pi mësaru ja̱ꞌre paꞌiji. Paꞌisiquëpi ti mësaru ja̱ꞌre pani huesëja̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mësarute teꞌohuaꞌire je̱o sani huesoye pa̱jaꞌquë aꞌë. Cuiꞌnaëpi pani co̱jaꞌquë aꞌë, mësaru ja̱ꞌre co̱ni. ");
INSERT INTO seyNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ëa maca cato pa̱i yëꞌëre ñañe pa̱jaꞌcohuaꞌi aꞌë. Ja̱je paꞌiquëtaꞌare mësaru cato yëꞌëre ñajaꞌcohuaꞌi aꞌë, yëꞌë huajëquë paꞌina, mësaruje̱ huajëcohuaꞌi paꞌija̱ꞌcohuaꞌi sëte. ");
INSERT INTO seyNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ja̱ muꞌse mësaru yuretaꞌa nuñerepa asaja̱ꞌcohuaꞌi aꞌë, yëꞌëpi jaꞌquë ja̱ꞌre co̱ni paꞌiye. Paꞌina, mësarupi yëꞌë ja̱ꞌre co̱ni paꞌiye asaja̱ꞌcohuaꞌi aꞌë. Cuiꞌne yëꞌëpi mësaru ja̱ꞌre co̱ni paꞌiye asaja̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ta̱ꞌñe asaquëpi cuiꞌne yëꞌë cua̱ñeseꞌe sehuoquë yoꞌoquëpi, yëꞌëre oiye i̱ñoji. Ja̱je paꞌina, yëꞌë jaꞌquëpi i̱teje̱ oija̱ꞌquë api. Oina, yëꞌëje̱ i̱te oija̱ꞌquë aꞌë. Ja̱je oi yëꞌëpi i̱na tsio dani yëꞌëseꞌe i̱ñojaꞌquë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas Iscariote peoquëpi, yequë Judaspi capi: “Ëjaë, ¿me yoꞌoquë yëquëna i̱ñojaꞌquë aꞌni, mëꞌëseꞌere. Me paꞌina, iye yeja pa̱ina mëꞌë paꞌiye i̱ñomaꞌë paꞌija̱ꞌquë aꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Caquëna, Jesupi sehuopi: “Yëꞌëre oiquëpi yëꞌë cua̱ñeseꞌe sehuoquë cuiꞌne yoꞌoji. Ja̱je yoꞌoquëni yëꞌë jaꞌquëpi i̱te oija̱ꞌquë api. Yëꞌë jaꞌquëpi cuiꞌne yëꞌëpi co̱ni dani i̱ ja̱ꞌre paꞌija̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yëꞌëre oimaꞌquëpi yëꞌë caseꞌeje̱ yoꞌoye pa̱ji. Iye coca mësaru yëꞌë tse̱ peoji. Yëꞌëre jëjo daosiquë jaꞌquë tse̱ aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Mësaru ja̱ꞌre ja̱ yëꞌtaꞌa yëꞌë paꞌi maca siꞌaye cayë. ");
INSERT INTO seyNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ja̱je paꞌiquëtaꞌare deꞌo joyopi jaꞌquë yëꞌë mami doꞌire jëjo daoja̱ꞌquë api. Ja̱ëpi mësarute co̱cai cuiꞌne oicohuaꞌi paꞌijëna, yëhuoja̱ꞌquë api, siꞌaye yeꞌyaquë. Cuiꞌne siꞌaye yëꞌë caseꞌere cuasa ñajaiñe necaija̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Deꞌoye paꞌiyere mësarute i̱sicani saiyë. Yëꞌë deꞌoye paꞌiyere i̱siyë, mësarute. Iye yeja pa̱i deꞌoye paꞌiye aꞌë cajë i̱siyeje̱ paꞌyere i̱simaꞌë paꞌiyë. Caꞌramaꞌpë paꞌijë̱ꞌë, cuiꞌne coꞌa ju̱ꞌimaꞌpë paꞌijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Yëꞌë jaꞌquë yëꞌë jerepa paꞌi quëꞌrona saiyë caquëna, mësaru asani ai sihuaraꞌhuë, yëꞌëre oicohuaꞌirepa pani. Mësaru tsoe asahuë, saisiquëpi cuiꞌnaëpi dani mësaru ja̱ꞌre pasiꞌi caquëna. ");
INSERT INTO seyNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Iye cato cayë, ja̱je ti̱ꞌa ja̱ꞌñe paꞌina, i̱tipi tëto saina, ñani care papi cajë yëꞌëre cuasaja̱jë caquë. ");
INSERT INTO seyNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ai jaiye mësaru ja̱ꞌre caye pa̱ñë. Yure cato tsoe daiji, iye yeja cua̱ñequëpi. Yëꞌëre meñe cua̱ñeñe peoquëtaꞌa yoꞌoji. ");
INSERT INTO seyNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ja̱je tëto saiye paꞌiji, jaꞌquëre yëꞌë oiye pa̱ipi ñajajë caquë, cuiꞌne i̱ cua̱ñeñere yoꞌoji cajë ñajajë caquë. Huëijë̱ꞌë. Sañuꞌu, ti̱rona. ");
INSERT INTO seyNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Cuiyaꞌi ñëje paꞌi aꞌë, yëꞌë. Yëꞌë jaꞌquë api, i̱ti ñacaiquëje̱ paꞌi api. ");
INSERT INTO seyNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yëꞌë capë̱a i̱pi tëꞌca tëte je̱aquëpi quë̱imaꞌ capë̱a. Ja̱je yoꞌoquë quë̱i capë̱are paseꞌe nëoquë api, ai quë̱ijaꞌquë caquë. ");
INSERT INTO seyNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mësaru cato tsoe deꞌoye jëo nëcosicohuaꞌi aꞌë, yëꞌë iye coca quëa doꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yëꞌëna tsiosicohuaꞌirepa siꞌanë paꞌijë̱ꞌë, mësaru cato, yëꞌë mësaruna tsioseꞌeje̱ paꞌye. I̱ti capëseꞌe pani quë̱ni ti̱ꞌañe peoji, i̱ti ñëre pana tsiosicopi paꞌiye pa̱ni. Ja̱je cuiꞌne mësaruje̱ yëꞌë ja̱ꞌre tsiosicohuaꞌipi paꞌimaꞌpë pani quë̱ni ti̱ꞌañe peoyë. ");
INSERT INTO seyNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Yëꞌë cato i̱ti ñëre paꞌë. Mësaru cato i̱ti capë̱aꞌë. Yëꞌë ja̱ꞌre tsioni paꞌina, cuiꞌne yëꞌëpi i̱ ja̱ꞌre tsioni paꞌiquëpi jaiye i̱ti ca̱ quë̱iñe paꞌiji. Paꞌina, mësaruseꞌe yoꞌo ti̱ꞌañe ti peoyë, yëꞌë peoquëna. ");
INSERT INTO seyNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Yëꞌë ja̱ꞌre co̱ni paꞌimaꞌquë cato nejo cua̱ñoquë api. Nejo cua̱ñoni toa sua ja̱ꞌñe so̱quë capë̱a cue̱neñeje paꞌyere tsiꞌsoni ëoja̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mësarupi yëꞌë ja̱ꞌre tsiosicohuaꞌipi paꞌijë cuiꞌne yëꞌë yeꞌyaseꞌeje̱ hua̱nëyemaꞌcohuaꞌipi, mësaru yëyere se̱cohuaꞌi paꞌito, siꞌaye mësaru se̱ñe i̱sija̱ꞌquë aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mësarupi jaiye deꞌo coꞌamaña quë̱iñeje paꞌye yoꞌojëna, yëꞌë jaꞌquëpi pa̱ini sihua cua̱ñoji. Ja̱je deꞌoye yoꞌocaijë yuretaꞌa mësarupi yëꞌë yeꞌyacohuaꞌirepa paꞌiye ti̱ꞌañë. ");
INSERT INTO seyNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Yëꞌë mësarute oiyë, yëꞌëre jaꞌquë oiyeje̱ paꞌye. Ja̱je paꞌina, yëꞌë oiyere paꞌijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Yëꞌë cua̱ñeseꞌere sehuocaijë cuiꞌne yoꞌoni yëꞌë oiyere paꞌiyë. Jaꞌquë cua̱ñeseꞌere yëꞌë sehuocai yoꞌoquëpi yëꞌë jaꞌquë oiyere paꞌiyë, cuiꞌneje. ");
INSERT INTO seyNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ja̱re quëahuë, mësarute. Yëꞌë ja̱ꞌre teꞌe sihuajë cuiꞌne sihuayepi ti̱mësicohuaꞌi paꞌija̱jë caquë. ");
INSERT INTO seyNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yëꞌë cua̱ñeñe cato iye aꞌë: Oijë̱ꞌë, yecohuaꞌire, yëꞌë mësarute oiseꞌeje̱ paꞌye. ");
INSERT INTO seyNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Cajeohuaꞌire oi doꞌire teꞌi ju̱cacaiye aꞌë, ai oiye. Yequë peoji, ja̱ jerepa paꞌye pa̱ire oiye. ");
INSERT INTO seyNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Mësaru yëꞌë cajeohuaꞌi aꞌë, yëꞌë cua̱ñeseꞌere yoꞌoni. ");
INSERT INTO seyNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mësarute joꞌyaohuaꞌire caye pa̱ñë. Teꞌe nuñerepa cajeohuaꞌire cayë, mësarupi yëꞌë i̱ñosi doꞌire, yëꞌë jaꞌquë yëꞌëre caseꞌere siꞌaye huesëmaꞌpë asa doꞌire. Joꞌyaë cato huesëquë api, i̱ ëjaë caquë yoꞌoye. ");
INSERT INTO seyNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mësarupi yëꞌëre sahuani soimaꞌpë paëꞌë. Yëꞌëpi mësarute sahuani soihuë. Soini cuiꞌne cua̱ñehuë, sani jaiye quë̱ijëꞌë caquë, ja̱ quë̱iñepi ti paꞌija̱ꞌquë caquë. Ja̱je jaiye quë̱icohuaꞌipi yëꞌë doꞌipi se̱jëna, jaꞌquëpi mësaru se̱seꞌere siꞌaye i̱sija̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Iye aꞌë, mësarute yëꞌë cua̱ñeñe: Sa̱ꞌñe oijë paꞌijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Iye yeja pa̱ipi mësarute coecohuaꞌi paꞌito, yëꞌëre duꞌru coeseꞌere cuasajë oimaꞌpë. ");
INSERT INTO seyNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Mësarupi iye yeja acohuaꞌi paꞌito mësarute otiraꞌhuë, i̱ohuaꞌi cajeohuaꞌire oiyepi. Ja̱je paꞌiquëtaꞌare yëꞌëpi mësarute iye yeja acohuaꞌini sahuani soisi doꞌire mësarute coeyë, iye yeja pa̱ipi, iye yeja acohuaꞌi peo doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Yëꞌë mësarute caseꞌere cuasajë̱ꞌë. ‘Necaiquë cato i̱ ëjaëre tëto saisiquë peoji.’ Ja̱je paꞌiye sëte yëꞌëre pani sa̱ñope yoꞌosicohuaꞌi me mësarute sa̱ñope yoꞌoye pa̱ñeꞌni cuiꞌne yoꞌoja̱ꞌcohuaꞌi aꞌë. Cuiꞌne yëꞌë yeꞌyayere sehuocaisicohuaꞌi panitaꞌa mësaru yeꞌyaye sehuoja̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Siꞌaye ja̱je yoꞌoja̱ꞌcohuaꞌi aꞌë, yëꞌë doꞌire cuiꞌne yëꞌëre jëjo daosiquëre huesë doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Yëꞌë dani camaꞌquë paꞌito ja̱ohuaꞌi doꞌi peocohuaꞌi patiraꞌhuë. Ja̱je paꞌiquëtaꞌare yure cato i̱ohuaꞌi tayo yoꞌo doꞌire ca deꞌhua ti̱ꞌañe peoyë. ");
INSERT INTO seyNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Yëꞌëre coequë cato jaꞌquëreje̱ coeji. ");
INSERT INTO seyNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","I̱ohuaꞌique ñajëna, pa̱i yoꞌo ti̱ꞌa maꞌñere yëꞌë yoꞌomaꞌquë paꞌito sa̱ñope yoꞌo ja̱ꞌñe peocohuaꞌi patiraꞌhuë. Ja̱je paꞌiquëtaꞌare yure cato yëꞌë yoꞌoquëna, ñahuë. Ja̱je ñasicohuaꞌitaꞌa yëꞌëre cuiꞌne jaꞌquëre coeyë. Ja̱ doꞌire doꞌi quëꞌiohuaꞌi paꞌiyë. ");
INSERT INTO seyNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Iye cato yoꞌoyë, i̱ohuaꞌina cua̱ñeñe toyaseꞌepi ti̱ꞌajaquë caquë nëina. Toyaseꞌepi caji: ‘Doꞌije̱ peoquëni yëꞌëre coeyë.’ ");
INSERT INTO seyNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ja̱je paꞌiquëtaꞌare Maijaꞌquë quëꞌropi pa̱ire co̱caiquëre cuiꞌne nuñerepa yoꞌo joyore yëꞌë jëjo daoquëpi, ja̱ëpi yëꞌë ayere cacaija̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mësaruje̱ yëꞌë ayere cacaija̱ꞌcohuaꞌi aꞌë, yëꞌë ja̱ꞌre co̱ni ai tsoe paꞌisicohuaꞌi sëte. ");
INSERT INTO seyNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yëꞌëre cuasayere ne hueꞌsomaꞌpë mësarupi ta̱iñe pa̱jajë caquë iye mësarute cahuë. ");
INSERT INTO seyNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Pa̱i tsiꞌsi huë̱ꞌñapi mësarute eto saoja̱ꞌcohuaꞌi aꞌë. Ja̱je yoꞌojë mësarute huani je̱ajaꞌcohuaꞌi aꞌë. Ja̱je yoꞌojë Diusuni deꞌoye necaiyë cuasaja̱ꞌcohuaꞌi aꞌë, huaicohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Iye cato yoꞌoja̱ꞌcohuaꞌi aꞌë, ti jaꞌquëre cuiꞌne yëꞌëreje̱ asamaꞌcohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Iye cato mësarute cayë, i̱ti ti̱ꞌasi maca yëꞌë caseꞌere cuasa ñajaijajë caquë. Mësaru ja̱ꞌre paꞌi doꞌire ja̱je caye pa̱huë, ja̱ꞌa huëo maca. ");
INSERT INTO seyNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ja̱je paꞌiquëtaꞌare yure cato saiyë, yëꞌëre jëjo daosiquë ja̱ꞌre pasiꞌi caquë. Mësaru aquëje̱ ti teꞌije̱ yëꞌëre se̱ni asaye pa̱ji, jerona mëꞌë saiquëꞌni caquë. ");
INSERT INTO seyNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Coa ai jerepa oicohuaꞌi deꞌo huesëhuë, iyere caëna. ");
INSERT INTO seyNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nuñerepa mësarute cayë. Yëꞌëpi saquëna, jerepa deꞌoye patiꞌñe paꞌiohuaꞌi aꞌë, mësaru. Yëꞌëpi saimaꞌquë paꞌito, mësarute co̱cai cuiꞌne sihua ëaye joyona necaiquë daiye peoji. Yëꞌëpi saisiquë pani jëjo daoye paꞌiji, i̱te. ");
INSERT INTO seyNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","I̱pi daisi maca quëaja̱ꞌquë api, coꞌayere pa̱i yoꞌoyë, caquë. Nuñerepa yoꞌoye paꞌiji, quëasipi, cuiꞌne tayo yoꞌosicohuaꞌije̱ sa̱i deꞌhuaye paꞌiji quëasipi. ");
INSERT INTO seyNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Yëꞌëre i̱re papi cajë cuasamaꞌ doꞌire, tayo yoꞌocohuaꞌi paꞌiyë. ");
INSERT INTO seyNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Nuñerepa deꞌo maꞌare i̱ñojaꞌquë api, yëꞌëpi jaꞌquë quëꞌrona saisi doꞌire, ja̱ maca mësaru yëꞌëre ñañe peoji. ");
INSERT INTO seyNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Iye yeja cua̱ñequëpi i̱ tayo yoꞌo doꞌire nejo cua̱ñosiquë paꞌi doꞌire pa̱ipi asa ti̱ꞌajaꞌcohuaꞌi aꞌë, Diusupi i̱ohuaꞌi tayo yoꞌo doꞌire sa̱i deꞌhua cua̱ñeñe paꞌiji, ca ja̱ꞌñere i̱pi quëaquëna. ");
INSERT INTO seyNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ja̱ yëꞌtaꞌa jaiye mësarute caye payë. Ja̱je paꞌiquëtaꞌare yure cato mësaru asa ti̱ꞌañere peoyë. ");
INSERT INTO seyNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nuñerepa ca joyopi dani mësarute yeꞌyaja̱ꞌquë api, siꞌaye nuñere pare. Coa i̱seꞌe cuasayere camaꞌë pasipi. Siꞌaye asaseꞌere casipi. Cuiꞌne mësarute quëasipi, yequë muꞌse tëto sai ja̱ꞌñere. ");
INSERT INTO seyNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yëꞌëre deꞌoquëre papi caja̱ꞌquë api, yëꞌë tse̱ ayere paquëpi mësarute quëa i̱ñojaꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Siꞌaye jaꞌquë paye yëꞌë tse̱ aꞌë. Ja̱je paꞌina, cahuë. Yëꞌë tse̱re deꞌo joyo cato paja̱ꞌquë api. Ja̱je paquëpi yëꞌë tse̱re mësarute se i̱ñojaꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ëa maca cato, yëꞌëre ñañe pa̱jaꞌcohuaꞌi aꞌë, mësaru. Pa̱sicohuaꞌitaꞌa ai tsoe maca pani ñajaꞌcohuaꞌi aꞌë, yëꞌëre. Jaꞌquë quëꞌrona saiyë, yëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ja̱ maca i̱ yeꞌyacohuaꞌi acohuaꞌipi sa̱ꞌñe se̱iꞌë, ñeje cajë: “¿Me caquë ja̱je caquëꞌni? Ëa maca cato yëꞌëre ñañe pa̱jaꞌcohuaꞌi aꞌë, cuiꞌne yequëje̱ caji ai tsoe maca pani ña co̱jaꞌcohuaꞌi aꞌë, yëꞌëre. Jaꞌquë quëꞌrona saisi doꞌire ja̱je pasipi caji. ");
INSERT INTO seyNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿I̱quere caquë ja̱je ëa maca caquëꞌni? Ja̱je cato me asa ti̱ꞌañeꞌni huesëyë, i̱ caye.” ");
INSERT INTO seyNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ja̱je yoꞌojë cajëna, Jesús cato asapi, i̱ohuaꞌi se̱ni asañuꞌu cajë yoꞌoye. Ja̱je paꞌina, capi: “Mësarute cahuë, ëa maca cato yëꞌëre ñañe pa̱jaꞌcohuaꞌi aꞌë, ai tsoe maca pani yëꞌëre ña co̱jaꞌcohuaꞌi aꞌë. ¿Ja̱ caseꞌere mësaru sa̱ꞌñe se̱jë yoꞌojë caye? ");
INSERT INTO seyNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nuñerepa mësarute cayë. Mësaru airepa oija̱ꞌcohuaꞌi aꞌë, cuiꞌne coꞌa ju̱ꞌijë paꞌija̱ꞌcohuaꞌi aꞌë. Ja̱je paꞌijëtaꞌare iye yeja pa̱i cato sihuaja̱ꞌcohuaꞌi aꞌë. Ja̱je oijë paꞌisicohuaꞌitaꞌare mësaru oiseꞌepi yequë muꞌse sihuaye po̱nëjaꞌcoa. ");
INSERT INTO seyNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nomiopi tsi̱ co̱a huëosico pani ai yoꞌocoa, tsi̱tuꞌure pa maca ti̱ꞌaëna, aꞌsi ju̱ꞌio. Ja̱je yoꞌosicotaꞌa tsihuaꞌë macare tëꞌya dani aꞌsiseꞌe hua̱nëyecoa, huajë tsi̱tuꞌupi iye yejare paꞌina, sihuaco. ");
INSERT INTO seyNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ja̱je cuiꞌne mësaruje̱ ai yoꞌoja̱ꞌcohuaꞌi aꞌë, yure cato. Ja̱je paꞌiquëtaꞌare yëꞌëpi coꞌini mësarute ña co̱jaꞌquë aꞌë. Ja̱ maca mësaru sihua huajëja̱ꞌcohuaꞌi aꞌë. Ja̱ mësaru sihuaye yecohuaꞌije̱ jioye ti peoji. ");
INSERT INTO seyNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ja̱ muꞌse cato yëꞌëre se̱ni asaye ti peosipi. Nuñerepa mësarute cayë. Jaꞌquëpi mësarute i̱sija̱ꞌquë api, siꞌaye mësaru se̱ñe yëꞌë mamipi cajë se̱jëna. ");
INSERT INTO seyNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Iye macaja̱ꞌa mësaru yëꞌë mamipi cajë se̱ñe pa̱huë, yuretaꞌa se̱jëꞌë. Se̱jëna, i̱sija̱ꞌquë api. I̱siquëna, sihuaja̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Mësarute cahuë. Iye coca pa̱i yoꞌoye ayena co̱ni cue̱cue ñaquë ja̱je casiquëtaꞌare yequë muꞌse ti̱ꞌajaꞌcoa, pa̱i yoꞌoye ayena co̱ni cue̱cuemaꞌë caye, nuñerepa caja̱ꞌquë aꞌë, jaꞌquë ayere ti̱ña asayerepa. ");
INSERT INTO seyNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ja̱ muꞌse cato mësaru yëꞌë mamipi cajë se̱jaꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Tsoe jaꞌquëpi mësarute oi paji, mësarupi yëꞌëre oi doꞌire cuiꞌne mësarupi yëꞌëre Diusu quëꞌropi daisiquë api, cajë asa doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Jaꞌquë quëꞌrore papi etani iye yejana daisiquë aꞌë. Ja̱je paꞌiquëtaꞌare yure cato iye yejapi je̱oni jaꞌquë quëꞌrona coꞌija̱ꞌquë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ja̱ maca i̱ yeꞌyacohuaꞌipi cahuë: “Yuretaꞌa mëꞌë ti̱ñarepa cayë, yequena co̱ni cue̱cueye peoye. ");
INSERT INTO seyNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Yuretaꞌa mëꞌëre ñajë cuiꞌne asayë, siꞌaye ta̱ꞌñe asaquëre papi. Ja̱je paꞌini yecohuaꞌije̱ mëꞌëre se̱ni asañuꞌu cajë yoꞌoye peoji. Ja̱je paꞌina, mëꞌëre Diusu quëꞌropi daisiquë api cajë asayë, yëquë.” ");
INSERT INTO seyNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Cajëna, Jesupi capi: “¿Ja̱je paꞌito yuretaꞌa asa ti̱ꞌare paye? ");
INSERT INTO seyNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Tsoe ti̱ꞌaji, i̱ti yoꞌo maca. Yure i̱ti macare paꞌiyë, mësaru yëꞌëre teꞌire je̱oni pa̱i ñape hua saija̱ꞌcohuaꞌi aꞌë. Ja̱ maca teꞌi pëaja̱ꞌquë aꞌë. Ja̱je pëasiquëtaꞌa teꞌi paꞌiye pa̱jaꞌquë aꞌë. Yëꞌë jaꞌquëpi yëꞌë ja̱ꞌre co̱ni paꞌija̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Iye cato cayë, mësarute yëꞌë ja̱ꞌre co̱ni paꞌijë ai yoꞌoye peoye deꞌoye paꞌijë̱ꞌë caquë. Iye yeja cato mësaru ai yoꞌoye paꞌiji. Ja̱je paꞌiquëtaꞌare quëcocohuaꞌi paꞌijë̱ꞌë. Yëꞌë je̱ꞌquë iye yejare ñese quëcoquë paëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ja̱je ca tëjini Jesús maꞌtëmona ñaquë capi: “Jaꞌquë tsoe ti̱ꞌapi, i̱ti yoꞌo maca. Mëꞌë mamaquëre deꞌoquëre papi i̱ñocaijë̱ꞌë, mëꞌë mamaquëpi mëꞌëreje̱ deꞌoquëre papi caquë i̱ñojaꞌquëre. ");
INSERT INTO seyNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Mëꞌëpi mëꞌë mamaquëre iye yeja pa̱ire cua̱ñequëre nehuë, mëꞌë i̱sicohuaꞌire ti pani huesëye i̱sija̱quë caquë. ");
INSERT INTO seyNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mëꞌëre teꞌi api Diusu asajë cuiꞌne mëꞌë jëjo daosiquëre Jesucristore asaye aꞌë, ti pani huesëye. ");
INSERT INTO seyNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Iye yejare paꞌi mëꞌëre deꞌoquëre papi caquë i̱ñoquë mëꞌë cua̱ñeseꞌere ne saohuë. ");
INSERT INTO seyNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Iye yeja peoꞌnë yëꞌë mëꞌë ja̱ꞌre paꞌi deꞌoyere pare paseꞌeje̱ paꞌye yure yëꞌëre i̱si co̱jëꞌë, jaꞌquë. ");
INSERT INTO seyNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Iye yeja acohuaꞌini mëꞌë yëꞌëre sahuani i̱sisicohuaꞌire yëꞌëpi mëꞌë paꞌiyere i̱ñohuë. Mëꞌë tse̱cohuaꞌi paëꞌë. Ja̱je paꞌiohuaꞌini yëꞌëna mëꞌëpi i̱sina, i̱ohuaꞌipi mëꞌë cocare deꞌoye sehuojë yoꞌohuë. ");
INSERT INTO seyNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Yure cato ja̱ohuaꞌi asayë, mëꞌë tse̱ aꞌë cajë mëꞌë yëꞌëre i̱siseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ja̱je paꞌina, deꞌoye sehuojë asahuë, mëꞌë yëꞌëre i̱sisi coca. Asa ti̱ꞌare pahuë, mëꞌë quëꞌropi daisiquë api cajë, cuiꞌne mëꞌëpi jëjo daosiquë api cajë asahuë. ");
INSERT INTO seyNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ja̱ohuaꞌi doꞌire caquë mëꞌëre se̱ñë: Coa iye yeja acohuaꞌini caquë se̱ñe pa̱ñë. Mëꞌë yëꞌëre i̱sisicohuaꞌini caquë se̱ñë, mëꞌë tse̱cohuaꞌini. ");
INSERT INTO seyNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yëꞌë paye mëꞌë tse̱ aꞌë, cuiꞌne mëꞌë payepi yëꞌë tse̱ aꞌë. Ja̱je paꞌina, yëꞌë deꞌoyere ja̱ohuaꞌipi i̱ñoñë. ");
INSERT INTO seyNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Yëꞌë iye yejare paꞌiye pa̱jaꞌquë aꞌë. Pa̱quëtaꞌare ja̱ohuaꞌitaꞌa iye yejare paꞌija̱ꞌcohuaꞌi aꞌë. Yëꞌë cato saiyë, mëꞌë ja̱ꞌre paꞌija̱ꞌquëpi. Jaꞌquë deꞌoquërepa ja̱ohuaꞌi mañare ñacaijë̱ꞌë, mëꞌë tutupi mëꞌë yëꞌëre i̱sisicohuaꞌire, mëꞌë cuiꞌne yëꞌë co̱ni paꞌiyeje̱ paꞌye teꞌije̱ paꞌiohuaꞌi paꞌija̱ꞌcohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Yëꞌë iye yeja paꞌi maca mëꞌë tutupi deꞌoye ñacaëꞌë, i̱ohuaꞌire, mëꞌë yëꞌëre i̱sisicohuaꞌire. Ñacaina, teꞌije̱ ne huesëye pa̱pi, noni ne huesësiquëseꞌe ne huesëpi toyaseꞌepi ti̱ꞌaquëna. ");
INSERT INTO seyNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Yure cato mëꞌë paꞌi hue̱ꞌñana saiyë. Ja̱je paꞌiquëtaꞌare yëꞌë ja̱ yëꞌtaꞌa iye yejare paꞌi doꞌire cayë, iye coca, ja̱ohuaꞌije̱ yëꞌë sihuayeje̱ paꞌye sihuaja̱jë caquë. ");
INSERT INTO seyNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mëꞌë cocare ja̱ohuaꞌina i̱sihuë. I̱sina, iye yeja acohuaꞌipi i̱ohuaꞌire coeyë, iye yeja acohuaꞌi peo doꞌire. Yëꞌëje̱ iye yeja aquë peoyë. ");
INSERT INTO seyNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Iye yejapi ja̱ohuaꞌire etoni sajë̱ꞌë caquë se̱ñe pa̱ñë. Yëꞌë cato se̱ñë, mëꞌëpi ñacaina, huatipi jo̱sa yoꞌoye pa̱jaquë caquë. ");
INSERT INTO seyNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ja̱ohuaꞌi cato iye yeja acohuaꞌi peoyë. Yëꞌëje̱ iye yeja aquë peoyë. ");
INSERT INTO seyNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mëꞌë tse̱cohuaꞌirepa paꞌija̱ꞌcohuaꞌire deꞌocohuaꞌire pare nejëꞌë, mëꞌë cocapi. Mëꞌë coca cato nuñere paꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mëꞌë yëꞌëre iye yejana jëjo daoseꞌeje̱ paꞌye cuiꞌne yëꞌëje̱ ja̱ohuaꞌire iye yejana jëjo saoyë. ");
INSERT INTO seyNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ja̱je paꞌina, ja̱ohuaꞌini caquë yëꞌëpi mëꞌëna i̱siyë, ja̱ohuaꞌije̱ nuñerepa coca doꞌipi mëꞌëna i̱sisicohuaꞌi paꞌijë mëꞌë yëyere yoꞌoja̱jë caquë. ");
INSERT INTO seyNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ja̱ohuaꞌiseꞌere caquë se̱cacaiye pa̱ñë, cuiꞌne i̱ohuaꞌi quëajëna, jeteyoꞌje asani i̱tire paꞌë cajë cuasaja̱ꞌcohuaꞌireje̱ caquë se̱cacaiyë. ");
INSERT INTO seyNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Siꞌaohuaꞌi ja̱ohuaꞌije̱ teꞌije̱ paꞌiohuaꞌi paꞌija̱jë caquë se̱ñë, teꞌije̱ paꞌiohuaꞌi maina tsioni paꞌija̱quë caquë. Jaꞌquë, yëꞌë cuiꞌne mëꞌë co̱ni tsioni teꞌije̱ paꞌiohuaꞌi paꞌiyeje̱ paꞌye paꞌija̱jë ja̱ohuaꞌije̱. Ja̱je tsiosicohuaꞌipi teꞌije̱ paꞌiohuaꞌi paꞌijëna, iye yeja acohuaꞌipi ñajë mëꞌëpi yëꞌëre jëjo daopi cajë sehuoja̱ꞌcohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ja̱ohuaꞌire i̱sihuë, deꞌoyere pare mëꞌë yëꞌëre i̱siseꞌere, teꞌije̱ paꞌiohuaꞌi paꞌija̱jë caquë, mëꞌë cuiꞌne yëꞌë teꞌije̱ paꞌiohuaꞌi paꞌiyeje̱ cuiꞌne paꞌija̱jë caquë. ");
INSERT INTO seyNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yëꞌëpi i̱ohuaꞌi ja̱ꞌre co̱ni pasiꞌi. Paꞌina, mëꞌëpi yëꞌë ja̱ꞌre co̱ni paꞌijë̱ꞌë. Paꞌina, i̱ohuaꞌipi teꞌije̱ paꞌiohuaꞌirepa paꞌija̱ꞌcohuaꞌire. Ja̱je paꞌijëna, iye yeja pa̱ipi, mëꞌëpi yëꞌëre jëjo daopi cajë asaja̱ꞌcohuaꞌi aꞌë, mëꞌëpi ja̱ohuaꞌire yëꞌëre oiyeje̱ paꞌye oina ñajë. ");
INSERT INTO seyNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Jaꞌquë mëꞌëpi yëꞌëre i̱sihuë. Ja̱je paꞌina, mëꞌëre se̱ñë, ja̱ohuaꞌije̱ yëꞌë paꞌi hue̱ꞌñare paꞌija̱jë caquë, paꞌijë mëꞌë yëꞌëre deꞌoyerepa i̱siseꞌere ñajajë. Yëꞌëre mëꞌë cato ai oiquë aꞌë, ja̱ yëꞌtaꞌa yeja deꞌhuamaꞌnëpi. ");
INSERT INTO seyNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Yëꞌë jaꞌquë nuñerepa yoꞌoquë, mëꞌëre iye yeja pa̱i asa ti̱ꞌañe pa̱ñë. Ja̱je paꞌiquëtaꞌare yëꞌë cato mëꞌëre asayë icohuaꞌije̱ mëꞌë jëjo daosiquë api cajë asayë, yëꞌëre. ");
INSERT INTO seyNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Yëꞌëpi i̱ñohuë, mëꞌë paꞌiye ja̱ohuaꞌire. Ja̱ yëꞌtaꞌapi i̱ñoquë pasiꞌi, ai jerepa ti̱ña. Ja̱je i̱ñoquëna, mëꞌë yëꞌëre oiyepi i̱ohuaꞌini paꞌija̱quë paꞌina, yëꞌëpi i̱ohuaꞌi ja̱ꞌre co̱ni pasiꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Iye ca tëjini jeteyoꞌje Jesús sajiꞌi, i̱ yeꞌyacohuaꞌi ja̱ꞌre co̱ni Cedrón aꞌri tsiaya je te̱ꞌtena. Ja̱rote aꞌri tsio pajiꞌi. Ja̱rona Jesús i̱ yeꞌyacohuaꞌi ja̱ꞌre co̱ni cacapi. ");
INSERT INTO seyNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judasje̱, coso yehuoja̱ꞌquëje̱ ja̱ro ñaquë pajiꞌi. Ja̱rona Jesús siꞌanë i̱ yeꞌyacohuaꞌi ja̱ꞌre tsiꞌsi hue̱ꞌña pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Paꞌina, Judas i̱ti ñaquë sëte i̱ti hue̱ꞌñana sa ti̱ꞌapi, soldado pa̱i ja̱ꞌre, cuiꞌne Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌi jëjo daocohuaꞌi ja̱ꞌre, cuiꞌne fariseo pa̱i jëjo daocohuaꞌi ja̱ꞌre. Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌi jëjo daocohuaꞌi cato Maijaꞌquë huëꞌe ñacai soldado pa̱i paëꞌë. Siꞌaohuaꞌi huajo cuiꞌñasicohuaꞌire papi daëꞌë, toa tsë̱opë̱ana cuiꞌne so̱quë pe̱na tsë̱osicohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesupi i̱ohuaꞌi yoꞌo ja̱ꞌñe asaquë duꞌru sani i̱ohuaꞌire se̱jiꞌi: “¿Neni coꞌeyeꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Caquëna, i̱ohuaꞌipi cahuë: “Jesús Nazaret aquëni coꞌeyë.” Cajëna, Jesupi sehuoquë capi: “Yëꞌë i̱ aꞌë.” Judasje̱ i̱ohuaꞌi ja̱ꞌre co̱ni pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ja̱je caquëna, asani coꞌye jëa saoni yejana ta̱ta o̱mehuë. ");
INSERT INTO seyNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ja̱ maca Jesús ti̱jupë se̱jiꞌi, i̱ohuaꞌire cahuë: “¿Neni coꞌeyeꞌni?” Caquëna, i̱ohuaꞌipi cahuë: “Jesús Nazaret aquëni coꞌeyë.” ");
INSERT INTO seyNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Cajëna, Jesús capi, i̱ohuaꞌire: “Tsoe mësarupi asahuë. Yëꞌë i̱ aꞌë. Yëꞌëni coꞌeye sëte ja̱ohuaꞌire jo̱sa yoꞌomaꞌpë paꞌijë̱ꞌë, i̱ohuaꞌiseꞌe saija̱jë.” ");
INSERT INTO seyNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ja̱je Jesús caseꞌe ti̱ꞌapi, i̱ caseꞌe cato caji: “Mëꞌë yëꞌëre i̱sisicohuaꞌire ne huesoye pa̱huë, teꞌireje̱.” ");
INSERT INTO seyNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ja̱ maca Simón Pedropi i̱ huaꞌti dutani ëja tëꞌhui ca̱joroseꞌe tëto huatopi. I̱ tëtosiquë cato Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaëre necaiquë pajiꞌi. I̱ mami cato Malco hueꞌequë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ja̱je yoꞌoquëna, Jesupi Pedrore capi: “Huaꞌtire i̱o juꞌi hue̱ꞌñana jua nëojëꞌë. Iye ja̱re ja̱je ai yoꞌoye paꞌiji, yëꞌë jaꞌquëpi i̱sito.” ");
INSERT INTO seyNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ja̱ maca soldado pa̱i cuiꞌne i̱ohuaꞌi ëjaë co̱ni, cuiꞌne judío pa̱i soldado co̱ni Jesure tse̱ani hue̱huë. ");
INSERT INTO seyNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ja̱ jeteyoꞌje Anás huëꞌena sahuë. Anás mamacorepa doꞌire Caifás cato Anás huau pajiꞌi. Ja̱ëpi ja̱ tëcahuë cato Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ja̱re iquë Caifáspi ca nëopi, judío pa̱ire teꞌi mai aquëpi ju̱cacaiye paꞌiji, siꞌa judío pa̱i doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro cuiꞌne yequë i̱ yeꞌyequë co̱ni tuëꞌë, Jesure. Jesús yeꞌyaquë cato Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaë ñaquë pajiꞌi. Ja̱je paꞌi doꞌire cacapi, Jesús ja̱ꞌre co̱ni, ëjaë huëꞌe hueꞌse daripëna. ");
INSERT INTO seyNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ja̱je paꞌiquëtaꞌare Pedroseꞌe hueꞌse eta saꞌrona pëapi. Ja̱je pëaëna, Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaë ñaquëpi Jesús yeꞌyaquëpi etani eta saꞌro ñacore coca cani Pedrore copi, sa̱ꞌnahuëna. ");
INSERT INTO seyNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ja̱ maca eta saꞌro ñacopi Pedrore se̱coꞌë: “¿Mëꞌë i̱ yeꞌyacohuaꞌi aquë paꞌimaꞌquë?” Se̱ona, Pedropi capi: “Pa̱jëꞌë, yequë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ai sësëye sëte, joꞌyaohuaꞌi cuiꞌne policia pa̱i co̱ni jeca dani suani toa nehuë. Neni ja̱rote ñuꞌijë sësëquëna, cu̱ijë paëꞌë. Pedroje̱ ja̱rote pajiꞌi, sësëquëna, cu̱iquë. ");
INSERT INTO seyNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaëpi Jesure se̱ huëopi, jecohuaꞌi aꞌni, mëꞌë yeꞌyacohuaꞌi caquë, cuiꞌne i̱quere mëꞌë yeꞌyaquë paquëꞌni caquë se̱jiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Se̱ina, Jesupi capi: “Siꞌa pa̱i asajëna, yëꞌë cato casiquë aꞌë. Siꞌanë pa̱i tsiꞌsi sitona yeꞌyaquë paꞌisiquë aꞌë. Cuiꞌne Maijaꞌquë huëꞌena yeꞌyaquë paꞌisiquë aꞌë, judío pa̱i tsiꞌsi hue̱ꞌñana. Yëꞌë cato yoꞌosiquë aꞌë, yahue yoꞌomaꞌë paꞌisiquë aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Me yoꞌoquë yëꞌëre se̱ni asaquëꞌni? Se̱ni asajë̱ꞌë, yëꞌë caquëna, asasicohuaꞌini, ja̱ohuaꞌipi quëaja̱jë yëꞌë caseꞌe. Ja̱ohuaꞌipi asayë, yëꞌë caseꞌe siꞌaye.” ");
INSERT INTO seyNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ja̱je Jesús ca maca Maijaꞌquë huëꞌe ñacai policiapi i̱ti maca nëcaquëpi tsiana tëtoquë capi: “¿Ja̱je i̱o Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaëre sa̱ñope sehuocoa?” ");
INSERT INTO seyNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Caquëna, Jesupi capi: “Quëajë̱ꞌë. ¿I̱quere yëꞌë coꞌaye careꞌni? ¿Yëꞌë caseꞌepi deꞌoye paꞌito me yoꞌoquë tëꞌcaquëꞌni, yëꞌëre?” ");
INSERT INTO seyNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ja̱ maca Anáspi Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaë Caifás quëꞌrona sëasiquëni jëjo saopi. ");
INSERT INTO seyNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pedro ja̱je yoꞌo maca cato toare cu̱i nëcapi. Nëcaquëna, i̱te cahuë: “¿Mëꞌëje i̱ yeꞌyacohuaꞌi aquë paꞌimaꞌquë?” Cajëna, Pedropi cosoquë capi: “Pa̱jëꞌë. Ñamaꞌquë aꞌë, i̱te.” ");
INSERT INTO seyNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ja̱ maca Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaëre necaicohuaꞌi aquëpi se̱jiꞌi, Pedro ca̱joro tëto tëasiquë, doꞌiquëpi ñeje caquë: “¿Mëꞌëje paꞌini yëꞌë ñasiquëtaꞌa jeto tsio?” ");
INSERT INTO seyNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Caquëna, Pedropi ti̱jupë cosopi. Coso macarepa curaje̱ yëjiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ja̱ maca Caifás huëꞌepi Jesure Pilato huëꞌena sahuë. Ja̱ maca cato ñata to̱me huesë maca pajiꞌi. Judío cato cacamaꞌpë paꞌë huëꞌe, siꞌsi neñere coejë, i̱ohuaꞌipi ja̱rona cacasicohuaꞌi pani Egíptopi Israel pa̱i etajë paꞌiseꞌere cuasajë a̱iñere pa̱raꞌhuë. ");
INSERT INTO seyNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ja̱je paꞌina, Pilatopi etani i̱ohuaꞌire capi: “¿I̱que doꞌire iquëre sa̱ñope cayeꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Caquëna, i̱ohuaꞌipi sehuohuë. Doꞌi quëꞌi peoto yëquë mëꞌë quëꞌrona daye pa̱raꞌhuë. ");
INSERT INTO seyNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ja̱ maca Pilatopi capi: “Sajë̱ꞌë, iquëre. Sani mësaru cua̱ñeseꞌe paꞌiyeje̱ doꞌi quëꞌi paꞌito yoꞌojë̱ꞌë.” Caquëna, judío pa̱ipi cahuë: “Ja̱je paꞌiquëtaꞌare yëquë judío pa̱i cato pa̱ire huani je̱oñe cua̱ñeñe ti peoyë.” ");
INSERT INTO seyNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ja̱je yoꞌojëna, Jesús i̱ ju̱ꞌi ja̱ꞌñe ca nëoseꞌe ti̱ꞌapi. ");
INSERT INTO seyNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato cuiꞌnaëpi i̱ huëꞌena cacani Jesure soini se̱jiꞌi: “¿Mëꞌë judío pa̱i ëjaëre paë?” ");
INSERT INTO seyNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Caquëna, Jesupi capi: “¿Mëꞌëseꞌe cuasaquë caquë, pa̱nitaꞌa yecohuaꞌipi carena, caquë?” ");
INSERT INTO seyNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Caquëna, Pilatopi sehuopi: “¿Judíoje̱ ñani yëꞌë cato? Mëꞌë pa̱ipi cuiꞌne Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌipi yëꞌëna dani i̱sihuë, mëꞌëre ja̱ doꞌire cayë. ¿I̱quere yoꞌo uꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Caquëna, Jesupi sehuopi: “Iye yeja yëꞌë cua̱ñe hue̱ꞌña peoji. Iye yeja yëꞌë quëꞌro paꞌito, yëꞌë te̱ꞌte paꞌicohuaꞌipi uihuaraꞌhuë, yëꞌëpi judío pa̱ini tse̱a cua̱ñoñe pa̱jajë cajë. Yëꞌë cua̱ñe hue̱ꞌña peoji, i̱ño.” ");
INSERT INTO seyNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ja̱ maca Pilatopi capi: “Ja̱je paꞌito judío pa̱i ëjaë, mëꞌë.” Caquëna, Jesupi capi: “Pa̱i ëjaëꞌë, mëꞌë cayeje̱. Peosiquëpi pa̱i deꞌoni yëꞌë cato iye yejana daisiquë aꞌë, nuñerepa cocare casiꞌi caquë. Nuñerepa cocare sehuocaicohuaꞌipi yëꞌë caye asacaiyë.” ");
INSERT INTO seyNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Caquëna, Pilatopi capi: “¿I̱que aꞌni, nuñerepa?” Ja̱je se̱ni tëjini, Pilato ti̱jupë pa̱i ja̱ꞌre coca casiꞌi caquë, etani capi: “I̱ coꞌaye yoꞌoseꞌe yëꞌë ti̱ꞌamaꞌë paꞌiyë, iquëre. ");
INSERT INTO seyNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Mësaru cato Egíptopi Israel pa̱i etajë paꞌiseꞌere cuasajë yoꞌo muꞌseña tse̱asicohuaꞌire teꞌire etocohuaꞌi aꞌë. ¿Ja̱je paꞌiye sëte mësaru neni etoye yëyeꞌni? ¿Judío pa̱i ëjaëni etoye?” ");
INSERT INTO seyNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ja̱je ca maca siꞌa pa̱i cui co̱reña: “¡Ja̱ëre cato etoye peoji! Barrabásni eto saojë̱ꞌë.” Iquë Barrabás cato coꞌamaña yahue i̱maquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ja̱je cajëna, asani Pilatopi Jesure siꞌsejë̱ꞌë caëna, siꞌsehuë. ");
INSERT INTO seyNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Soldado pa̱i Jesure miupi maro tëosicopi si̱opëna pu̱ahuë. Cuiꞌne nea majaꞌi juꞌi ca̱re Jesure su̱ñacaëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ja̱ jeteyoꞌje i̱ quëꞌrona tsioja̱ijë cahuë: “¡Judío pa̱i ëjaëre paꞌë, mëꞌë!” Ja̱je cajë tsiana tëꞌcahuë. ");
INSERT INTO seyNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ti̱jupë Pilato eta co̱ni capi: “Asajë̱ꞌë. Iquë coꞌaye yoꞌoseꞌe ti̱ꞌamaꞌë paꞌiyë. Cuiꞌnaëni mësaru quëꞌrona da co̱ñë, doꞌi peoquë api cajë ñajajë caquë.” ");
INSERT INTO seyNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jesupi miu maro pu̱ꞌi cuiꞌne nea majaꞌi juꞌi ca̱ juꞌi etaquëna, ja̱ maca Pilatopi capi: “¡Ñajëꞌë. I̱ñore paꞌiji, iquë!” ");
INSERT INTO seyNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌi cuiꞌne policia pa̱i ñani cuihuë: “¡Que̱ñe paꞌiji. Que̱ñe paꞌiji!” Ja̱je cuijëna, Pilatopi capi: “Sani que̱jëꞌë, mësarupi. Yëꞌë cato ti̱ꞌañe pa̱huë, i̱ coꞌaye yoꞌoseꞌe.” ");
INSERT INTO seyNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Caquëna, judío pa̱ipi sehuohuë: “Yëquë cua̱ñeseꞌe payë. Ja̱je paꞌina, yëquë cua̱ñeseꞌeje̱ ju̱ꞌiñe paꞌiji, Diusu mamaquë aꞌë casi doꞌire.” ");
INSERT INTO seyNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ja̱re Pilato asani ai jerepa caꞌrapi. ");
INSERT INTO seyNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ja̱ maca cuiꞌnaëpi huëꞌena cacani se̱jiꞌi, Jesure: “¿Jero aquë aꞌni, mëꞌë caquë?” Se̱ina, Jesús ti sehuomaꞌë pajiꞌi, teꞌo macareje̱. ");
INSERT INTO seyNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ja̱ maca Pilato capi: “¿Yëꞌëre sehuocaiye pa̱quë? ¿Huesëquë cuiꞌne yëꞌëpi mëꞌëre que̱jaꞌa tutu cuiꞌne mëꞌëre eto sao tutuje̱ paye?” ");
INSERT INTO seyNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Caquëna, Jesupi capi: “Diusupi mëꞌëre ja̱ tutu i̱simaꞌquë paꞌito mëꞌë yëꞌëre yoꞌo ti̱ꞌañe ti peoraꞌpi. Ja̱je paꞌina, yëꞌëre tse̱ani mëꞌëna i̱sisiquëpi mëꞌë jerepa jai doꞌi paji, tayo doꞌire.” ");
INSERT INTO seyNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ja̱re ja̱ macapi Pilato cato Jesure eto sao huasosiꞌi caquë coꞌepi. Coꞌequëtaꞌare judío pa̱ipi jerepa cuihuë, ñeje: “Ja̱ëni eto saoquë pani César cajei peoja̱ꞌquë aꞌë, mëꞌë. ¡Pa̱i ëjaëre paꞌë caquë yoꞌoquë cato Césarte sa̱ñope yoꞌoquë api!” ");
INSERT INTO seyNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ja̱ maca Pilato iyere asani Jesure hueꞌsena etoni pa̱i yoꞌoseꞌe ne deꞌhuaquë ña deꞌhua hue̱ꞌñana jaꞌrupi, hebreo pa̱i coca cato Gabata hueꞌyo hue̱ꞌñana. Ja̱je cani cayë, “Quë̱napi nesico”. ");
INSERT INTO seyNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ja̱ yëꞌtaꞌa Egíptopi Israel pa̱i etajë paꞌiseꞌere cuasajë yoꞌo muꞌse ti̱ꞌañe pa̱ maca muꞌse joporepa paꞌina, yoꞌohuë, teꞌe muꞌse caraquëna. Ja̱ maca judío pa̱ire Pilatopi capi: “¡Iquë mësaru ëjaërepa pajë̱ꞌë!” ");
INSERT INTO seyNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ja̱je caquëna, i̱ohuaꞌipi cahuë: “¡Ju̱ꞌijaquë, ju̱ꞌijaquë! ¡Que̱ñe paꞌiji!” Cajëna, Pilatopi capi: “¿Yëꞌëpi mësaru ëjaëre que̱jaꞌquë aꞌni, ja̱je ca ja̱ꞌñe?” Caquëna, Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌipi cahuë, i̱te: “Yequë ëjaëre pare peoyë. Coa Césarseꞌe yëquë ëjaë paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ja̱je ca tëjini Pilatopi Jesure i̱ohuaꞌina i̱sipi que̱jajë caquë. I̱sina, i̱ohuaꞌipi sahuë. ");
INSERT INTO seyNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesús ja̱ropi etani i̱te que̱jaꞌa sarahua co̱ani sajiꞌi, pa̱i si̱opë tara hueꞌe hue̱ꞌñana hebreo pa̱i coca cato Gólgota hueꞌyo hue̱ꞌñana. ");
INSERT INTO seyNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ja̱rona i̱te que̱huë. Yecohuaꞌire cayaohuaꞌire i̱ ja̱ꞌre co̱ni que̱huë. Jesuni jopore pana nëcojë yecohuaꞌini i̱ ëja te̱ꞌtena cuiꞌne i̱ ari te̱ꞌtena nëcohuë. ");
INSERT INTO seyNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatopi cua̱ñepi cruzu ë̱mëjeꞌena: JESÚS NAZARET AQUË JUDÍO PA̲I ËJAËPI toyasicore deojë̱ꞌë caquë. ");
INSERT INTO seyNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ja̱je toyasicore jai pa̱i judío pa̱i ñahuë, Jesure que̱ sitopi pa̱i daripë jaꞌyere paꞌi doꞌire. Toyasico cato pajiꞌi, hebreo coca, griego coca, cuiꞌne latín coca. ");
INSERT INTO seyNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ja̱je paꞌina, Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌi judío pa̱ipi cahuë, Pilatore: “Toyamaꞌë paꞌijë̱ꞌë ‘Judío pa̱i ëjaëpi’ caquë coa toyajë̱ꞌë, ñeje, ‘Judío pa̱i ëjaëꞌë caquë api.’ Ja̱re toyajë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Cajëna, Pilatopi sehuopi: “Yëꞌë toya huesosico cato ja̱je paꞌiji. Yeque po̱nañe peoji.” ");
INSERT INTO seyNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","I̱te que̱si jeteyoꞌje soldado pa̱ipi Jesús juꞌi ca̱re i̱ni cajeseꞌe paꞌi ca̱ña huahuehuë, pa̱i ñape cuiꞌna jaꞌyeseꞌe. Cuiꞌne camisaje̱ i̱ꞌë, i̱tena teꞌopi tsoa ca̱ paꞌiye sëte, ");
INSERT INTO seyNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","sa̱ꞌñe i̱ohuaꞌi cahuë: “Nanë yeꞌsaye pa̱ñuꞌu, coa i̱ti deꞌhue nesiquëpi i̱ote paja̱ꞌquëre.” Ja̱je cajë yoꞌo maca tsoe ti̱ꞌapi, toyaseꞌe ñeje cayepi: “Yëꞌë juꞌi ca̱re pa̱i ñape huahuehuë. Nepi paja̱ꞌcohuaꞌi aꞌni, cajë.” Ja̱je soldado pa̱i yoꞌohuë, i̱ti caseꞌeje̱ paꞌye. ");
INSERT INTO seyNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Cruz yëꞌquë macare Jesús pëca jaꞌco cuiꞌne i̱o majaꞌyo, cuiꞌne Cleofas nëjo María, cuiꞌne yequë María Magdalena paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Paꞌijëna, pëca jaꞌcore Jesús ñani, cuiꞌne i̱ ai oi yeꞌyaquë paꞌisiquëpi i̱o yëꞌquë macare nëcaquëna, ñani capi: “Nomio ja̱ë api, mëꞌë mamaquë.” ");
INSERT INTO seyNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ja̱ jeteyoꞌje i̱ yeꞌyaquëre capi: “Ja̱o, mëꞌë jaꞌco.” Ja̱re i̱ti casi macapi i̱ yeꞌyaquëpi i̱ huëꞌena sai sapi, i̱ote. ");
INSERT INTO seyNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ja̱ jeteyoꞌje Jesús tsoe siꞌaye ne saoseꞌe sëte toyaseꞌe cayepi ti̱ꞌajaquë caquë capi: “Oco ëaji.” ");
INSERT INTO seyNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ja̱rote oꞌsa co̱no ti̱mësicopi ñucoꞌë. Ñuꞌiona, ja̱ maca ca̱ꞌcona sa̱ëni so̱quë tarapëna hue̱ni i̱ yëꞌopona u̱cuja̱quë cajë yoꞌojëna. ");
INSERT INTO seyNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesupi oꞌsa cuiyaꞌi co̱nore u̱cupi. U̲cuni capi: “Siꞌaye ti̱ꞌapi, yuretaꞌa.” Ja̱je cani meñe si̱opë ne meni, ju̱ni huesëpi. ");
INSERT INTO seyNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ja̱ yëꞌtaꞌa Egíptopi Israel pa̱i etajë paꞌiseꞌere cuasajë yoꞌo muꞌse ti̱ꞌamaꞌë pajiꞌi. Ja̱ muꞌse cato huajë muꞌse pajiꞌi. Ja̱je paꞌi doꞌire coꞌaye cruzure ju̱ꞌisicohuaꞌipi dete maꞌñe cajë Pilatore se̱iꞌë, que̱sicohuaꞌire quë̱ñaseꞌe tëꞌca jëꞌyeni ti̱ona saja̱jë cajë. ");
INSERT INTO seyNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ja̱ maca soldado pa̱ipi sani duꞌru aquëre pani quë̱ña tëꞌca jëꞌyehuë, cuiꞌne yequëreje̱ tëꞌca jëꞌyehuë, Jesús ja̱ꞌre que̱sicohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ja̱je yoꞌoni Jesús quëꞌrona sa tsioja̱ijë ñajëna, tsoe ju̱ꞌisiquë pajiꞌi. Paꞌina, ña jujani quë̱ña tëꞌca jëꞌyeye pa̱huë. ");
INSERT INTO seyNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ja̱je paꞌiquëtaꞌare soldadopi uiyopi totapi. Coripana totaquëna, tsie cuiꞌne oco etapi. ");
INSERT INTO seyNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Iye quëaquë cato i̱ti ñasiquëpi quëaji cuiꞌne nuñerepa caji. Nuñerepa quëaji i̱ti asasiquëpi, mësarureje̱ care paji cajë asaja̱jë caquë. ");
INSERT INTO seyNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Iye cato yoꞌohuë, ñeje toyaseꞌepi ti̱ꞌajaquë cajë, i̱tipi caji: “I̱ quë̱ña tëꞌca jëꞌyeye pa̱jaꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Yequë hue̱ꞌña toyaseꞌepi caji: “I̱ohuaꞌi aꞌsi nesiquëni ñajaꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ja̱ jeteyoꞌje José, Arimatea aquëpi Pilatore sani Jesús ca̱pë ta̱siꞌi caquë se̱jiꞌi. José cato judío pa̱ini caꞌraquë Jesure yahuerepa tuiquë pajiꞌi. Ja̱je paꞌipi se̱jiꞌi, Pilatore Jesús ca̱pë sani ta̱siꞌi caquë. Caquëna, Pilatopi deꞌoji sajë̱ꞌë. Caëna, sani Jesús ca̱pë i̱ni sapi. ");
INSERT INTO seyNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Cuiꞌne Nicodemoje̱ sajiꞌi, treinta kilos mirra cuiꞌne aloes co̱ꞌmeseꞌere saquë. Ja̱ë cato Jesure ñami sani coca casiquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ja̱je José cuiꞌne Nicodemo co̱ni saisicohuaꞌipi Jesús ca̱përe i̱ni i̱ohuaꞌi saseꞌe huëo së̱ñepi ca̱ñana neni tu̱nahuë, ju̱ꞌisiquëre. Ta̱jaꞌquëre judío pa̱i yoꞌoyepi yoꞌohuë, ja̱je yoꞌocohuaꞌi sëte. ");
INSERT INTO seyNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesure que̱ sito jaꞌyere tsio pajiꞌi. Paꞌina, ja̱ tsiore pajiꞌi, huajë quë̱ꞌisi coje pa̱ire ta̱maꞌcoje̱. ");
INSERT INTO seyNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Paꞌina, ja̱ cojena Jesure ta̱huë, jaꞌye maca paꞌicona. Ja̱ maca cato judío pa̱i huajë muꞌse tsoe ti̱ꞌa huëopi. ");
INSERT INTO seyNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Duꞌru coꞌamaña ne muꞌse ñata maca ja̱ neaquëna, María Magdalenapi sacoꞌë, ta̱si daripëna. Saio ñacona, daripë si̱osicopi jai quë̱na pë huiꞌyosico pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ja̱ maca Simón Pedro quëꞌrona cuiꞌne Jesús ai oiquërepa paꞌisiquë quëꞌrona huëꞌhuëni cao: “Ëjaë ca̱pë tsoe sahuë, daripë paꞌisicore. Huesëyë, jero saꞌna nehuë.” ");
INSERT INTO seyNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ja̱je cacona, Pedro cuiꞌne yequë i̱ yeꞌyaquë co̱ni daripë quëꞌrona ñañuꞌu cajë saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Cayahuaꞌi teꞌe coꞌarepa huëꞌhuëjë saëꞌë. Teꞌi ai jerepa huëꞌhuësiquëpi duꞌru ti̱ꞌapi, ta̱si daripëna. Pedropi jeteyoꞌje ti̱ꞌapi. ");
INSERT INTO seyNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Duꞌru ti̱ꞌani në meni ñaquëna, coa i̱te hue̱ni o̱asi ca̱ñaseꞌe pajiꞌi. Cacani ñañetaꞌa pa̱pi. ");
INSERT INTO seyNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Pa̱quëna, Simón Pedropi jeteyoꞌje daisiquëpi daripëna cacapi. Ja̱ëje cuiꞌne ñapi, i̱te hue̱ni o̱asi ca̱ñaseꞌe paꞌina. ");
INSERT INTO seyNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Cuiꞌne yequeje̱ ñapi, Jesús si̱opë tu̱nasi ca̱pi ti̱rona i̱oseꞌere tu̱nani yequë ca̱ña u̱imaꞌtona o̱asicopi paꞌiona. ");
INSERT INTO seyNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ja̱ maca cuiꞌne duꞌru daripëna ti̱ꞌasiquëje̱ cacani i̱ti yoꞌoseꞌe ñaquë nuñerepa asapi, i̱ti yoꞌoseꞌe. ");
INSERT INTO seyNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Jesucristo ju̱ꞌisiquëpi huëi ja̱ꞌñere caseꞌere ja̱ yëꞌtaꞌa toyaseꞌe caye asa ti̱ꞌamaꞌcohuaꞌi sëte. ");
INSERT INTO seyNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ja̱je ña tëjini i̱ yeꞌyacohuaꞌi coꞌihuë, huëꞌena. ");
INSERT INTO seyNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ja̱je paꞌiquëtaꞌare María cato hueꞌsena pëa nëcani oi nëcao, daripë yëꞌquë macapi. Ja̱ oio se në meni ñao daripë sa̱ꞌnahuëna. ");
INSERT INTO seyNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ñacopi ñao, cayahuaꞌi pojaꞌi juꞌi ca̱ña su̱ñasicohuaꞌipi, Jesús ca̱pë paꞌi sitore paꞌijëna, teꞌi quë̱o paꞌi sitore paꞌina, yequëpi si̱opë paꞌi sitore ñuꞌina. ");
INSERT INTO seyNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ja̱ maca hui̱ñaohuaꞌipi i̱ote se̱iꞌë: “¿Nomio, i̱quere oicoꞌni?” Cajëna, i̱opi sehuo: “Yëꞌë Ëjaëni sahuë. Ja̱ doꞌire oiyë. Huesëyë, jero saꞌna sani nehuë.” ");
INSERT INTO seyNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ja̱je se ca to̱co, se po̱nëco Jesure ñao, i̱ti macare nëcaquëna. Ñacotaꞌa Jesupi cuasaye pa̱o. ");
INSERT INTO seyNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ja̱ maca Jesupi i̱ote se̱jiꞌi: “¿Nomio, i̱quere oicoꞌni? ¿Neni coꞌecoꞌni?” Caquëna, i̱ti maca tsio ñaquë api cuasaco cao: “Ëjaë, mëꞌëpi sasiquë pani quëajë̱ꞌë, mëꞌë ne sito. Quëaëna, yëꞌëpi i̱te sasiꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ja̱ maca Jesupi capi, i̱ote: “¡María!” Caquëna, i̱opi po̱nëni cao, hebreo cocapi: “¡Raboni!” Ja̱je caye cato cao, yeꞌyaquë. ");
INSERT INTO seyNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ja̱ maca Jesupi capi: “Tse̱amaꞌo, ñuꞌijë̱ꞌë. Ja̱ yëꞌtaꞌa jaꞌquë quëꞌro saimaꞌquë aꞌë. Ja̱je paꞌiquëtaꞌare sani quëajë̱ꞌë, yëꞌë yoꞌje tsi̱re. Pëca jaꞌquë quëꞌrona cuiꞌne mai Diusu quëꞌrona saiyë.” ");
INSERT INTO seyNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Caquëna, ja̱ maca María Magdalenapi sani i̱ yeꞌyaquë paꞌisicohuaꞌire quëao. Ëjaëni ñahuë, caco. I̱pi ja̱je quëajë̱ꞌë, caëna, cayë, cao. ");
INSERT INTO seyNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ja̱re ja̱ muꞌse duꞌru coꞌamaña ne muꞌse ñami paꞌi maca i̱ yeꞌyacohuaꞌipi tuꞌrihuëna judío pa̱ini caꞌrajë cacani eta saꞌro si̱osicohuaꞌipi paëꞌë. Paꞌijëna, Jesupi i̱ohuaꞌi jopona ñaiquë pëpaquë capi: “Deꞌoye paꞌijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ja̱ se ca tëjini i̱ jë̱ña cuiꞌne i̱ coripa i̱ñopi. Ja̱ maca Ëjaëre papi cuasajë sihuahuë. ");
INSERT INTO seyNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ja̱ maca cuiꞌnaëpi Jesús ca co̱pi: “Deꞌoye paꞌijë̱ꞌë, mësaru. Jaꞌquë yëꞌëre jëjo daoseꞌeje̱ cuiꞌne yëꞌëje̱ mësaruteje̱ jëjo saoyë.” ");
INSERT INTO seyNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ja̱je cani sëcopi i̱ohuaꞌina, sëcoquë capi: “Deꞌo joyore pare pajë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mësarupi sa̱i deꞌhuacaicohuaꞌini i̱ohuaꞌi tayo yoꞌoseꞌe sa̱i deꞌhuacaiye paꞌiji. Mësaru sa̱i deꞌhuacaimaꞌcohuaꞌini i̱ohuaꞌi tayo yoꞌoseꞌe sa̱i deꞌhuacaiye peoji.” ");
INSERT INTO seyNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomás Jesús doce soisicohuaꞌi aquëpi cuiꞌne yequë mami Gemelo hueꞌequëpi Jesús ñai maca peopi. Peoquëna, yecohuaꞌiseꞌe paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Peoquëna, ñasicohuaꞌipi Jesús yeꞌyacohuaꞌipi quëahuë, Ëjaëni yëquë ñahuë cajë. Cajëna, Tomáspi capi: “Yëꞌëpi i̱ jë̱të quë̱na ñaca cojena cuiꞌne i̱ coripa ui cojena yëꞌë jë̱tëpi sani ñamaꞌë pani i̱re papi caye pa̱jaꞌquë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ocho muꞌseña tëto saisi maca i̱ yeꞌyacohuaꞌipi huëꞌena tsiꞌsicohuaꞌipi paëꞌë. Paꞌijëna, ja̱rote Tomásje̱ co̱ni pajiꞌi, yure cato. Ja̱ maca Jesús ñaipi, eta saꞌnoa si̱oseꞌepi paꞌiquëtaꞌare. Ja̱ maca pëpaquë capi: “Deꞌoye paꞌijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ja̱ maca capi, Tomásre: “Mëꞌë jë̱tëpi i̱ñona sa̱ꞌijë̱ꞌë. Sa̱ꞌi ñajëꞌë, yëꞌë jë̱ñare. Mëꞌë jë̱tëre dajë̱ꞌë. Dani yëꞌë coripa ui cojena sa̱ꞌijëꞌë, tsoerepa jëa coemaꞌë paꞌija̱ꞌquë nuñere paꞌë caquë asaja̱ꞌquë.” ");
INSERT INTO seyNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ja̱ maca Tomáspi sehuopi: “Yëꞌë ¡Ëjaë cuiꞌne yëꞌë Diusu!” ");
INSERT INTO seyNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Caquëna, Jesupi capi: “Tomás yuretaꞌa asare payë, mëꞌë yëꞌëre ñasi doꞌire. Sihuayë, yëꞌëre ñamaꞌcohuaꞌipi coa quëayena asani nuñere paꞌë cajë cuasacohuaꞌire.” ");
INSERT INTO seyNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesús jaiye yoꞌopi i̱ yeꞌyacohuaꞌi ñajëna, pa̱i yoꞌo ti̱ꞌa maꞌñere ja̱ yoꞌoseꞌe toya pëpëna siꞌaye toyaseꞌe peoji. ");
INSERT INTO seyNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ja̱je paꞌiquëtaꞌare iye cato mësarupi Jesure i̱re papi Cristo huasoquë api, cajë cuiꞌne Diusu mamaquëre papi cajë asani ti paꞌiyere ti̱ꞌajajë cajë toyaseꞌe aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ja̱ jeteyoꞌje Jesús ti̱jupë i̱ yeꞌyacohuaꞌina ñaipi, Tiberias jaira të̱ꞌtëpana. Ñaini ñeje yoꞌopi: ");
INSERT INTO seyNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simón Pedropi cuiꞌne Tomás Gemelo hueꞌequë cuiꞌne Natanael Caná yeja Galilea aquë cuiꞌne Zebedeo mamajë cuiꞌne cayaohuaꞌi Jesús yeꞌyacohuaꞌi co̱ni paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Paꞌijëna, Pedropi capi: “Huaꞌire sani nesiꞌi.” Caquëna, yecohuaꞌije̱ cahuë: “Yëquëje̱ mëꞌë ja̱ꞌre sañuꞌu.” Cani saëꞌë, teꞌe i̱ ja̱ꞌre co̱ni yohuëna aya mëni. Ja̱ ñami huaꞌire neñe pa̱huë. ");
INSERT INTO seyNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ñata to̱me maca Jesús tsiaya të̱ꞌtëpare nëcapi, i̱ yeꞌyacohuaꞌipi huesëhuë, i̱queiꞌni cajë. ");
INSERT INTO seyNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ja̱ maca capi, Jesupi: “¿Tsi̱dohuë, huaꞌi neñe pa̱re?” Caquëna, i̱ohuaꞌipi cahuë: “Pa̱huë, neñe.” ");
INSERT INTO seyNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ja̱ maca Jesús capi: “Yohuë ëja te̱ꞌtena huaꞌi yoꞌecore je̱o dëojë̱ꞌë. Ja̱ maca mësaru nejaꞌcohuaꞌi aꞌë.” Caëna, i̱ caseꞌeje̱ je̱o dëohuë. Je̱o dëorena, huaꞌipi ti̱mëni dëquëcona, naë ti̱ꞌañe pa̱huë. ");
INSERT INTO seyNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ja̱ maca Jesús ai yëquëpi Pedrore capi: “¡Mai Ëjaëre papi!” Ja̱je ca macarepa asayepi Simón Pedropi i̱ ë̱mëje juꞌicore se su̱ñani sa dujiꞌi, tsiayana. ");
INSERT INTO seyNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Yecohuaꞌi cato yohuëja̱ꞌa tsio daëꞌë, mejahuëna, huaꞌi yoꞌerë naëjë. Coa cien metro pajiꞌi, të̱ꞌtëpa ti̱ꞌañe. ");
INSERT INTO seyNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Yejana ti̱tani tu̱majë ti̱ꞌahuë, tsoe toa suasicopi paꞌina. Cuiꞌne huaꞌi, pan pajiꞌi, toa ë̱mëjeꞌna tu̱ñaseꞌepi. ");
INSERT INTO seyNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ja̱ maca Jesupi capi: “Dajë̱ꞌë, huaꞌire mësaru nesicohuaꞌini.” ");
INSERT INTO seyNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simón Pedropi yohuëna aya mëni huaꞌi yoꞌecore cu̱tihuëre pana naë mapi, mejahuëna huaꞌi ti̱mësiconi. Ciento cincuenta y tres huaꞌire nehuë. Ja̱je paꞌiquëtaꞌare huaꞌi yoꞌerë tëiye pa̱o. ");
INSERT INTO seyNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ja̱ maca Jesupi capi: “Dani huaꞌi a̱ijëꞌë.” Teꞌije̱ i̱te i̱queiꞌni, mëꞌë caquë se̱ñe pa̱pi. Siꞌaohuaꞌi Ëjaëre papi cajë asahuë. ");
INSERT INTO seyNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ja̱ jeteyoꞌje Jesupi panpë i̱ni huaꞌquequë a̱opi siꞌaohuaꞌire, cuiꞌne huaꞌireje̱ huaꞌquequë a̱opi. ");
INSERT INTO seyNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Iye cato toaso̱ñe aco pajiꞌi, i̱ohuaꞌi i̱te ñaseꞌe ju̱ꞌisiquëpi huëisiquëre. ");
INSERT INTO seyNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","A̲o a̱ni tëjisi jeteyoꞌje Jesupi se̱jiꞌi, Pedrore ñeje: “Simón Jonás mamaquë, ¿iye jerepa mëꞌë yëꞌëre oiquë?” Caquëna, Pedropi sehuopi: “Ja̱je paꞌijë̱ꞌë, Ëjaë. Mëꞌëpi tsoe asayë, yëꞌë mëꞌëre oiye.” Caquëna, Jesupi capi: “Ja̱je paꞌito yëꞌë yëi ñamare deꞌoye ñacaijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ti̱jupë se̱ni co̱pi, cayaye acore: “Simón Jonás mamaquë, ¿yëꞌëre oiquë?” Caquëna, Pedropi sehuopi: “Ja̱je paꞌiji, Ëjaë. Mëꞌëpi tsoe asayë, yëꞌë mëꞌëre oiye.” Caquëna, Jesupi capi: “Ja̱je paꞌito yëꞌë yëi ñamare ñacaijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Toaso̱ñe acore se̱jiꞌi: “Simón Jonás Mamaquë, ¿yëꞌëre mëꞌë yëquë?” Ja̱ maca Pedro oi tsia nepi, toaso̱ñe acore yëquë mëꞌë yëꞌëre oiquë caquëna. Ja̱ maca sehuopi Pedro: “Ëjaë, mëꞌëpi siꞌaye asayë, yëꞌë mëꞌëre oiye.” Ja̱ maca Jesupi capi: “Yëꞌë yëi ñamare deꞌoye ñacaijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nuñerepa mëꞌëre cayë, ai po̱sërepa paꞌi maca, mëꞌëseꞌe ca̱ña su̱ñani mëꞌë yë hue̱ꞌñana sai paꞌisiquë aꞌë. Ja̱je paꞌiquëtaꞌare ai hua̱nou deꞌosi maca coa jë̱tëre nëocaina, yequëpi su̱ñacaija̱ꞌquë api. Ja̱ maca mëꞌë saiye yëmaꞌtona saja̱ꞌquë api.” ");
INSERT INTO seyNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ja̱je Jesús cani capi: Pedro ju̱ꞌiñepi Maijaꞌquë deꞌoquërepa paꞌiye i̱ñocai ja̱ꞌñere quëaquë. Ja̱ jeteyoꞌje capi: “Tuijë̱ꞌë, yëꞌëre.” ");
INSERT INTO seyNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Coꞌiquë Pedro ñaquëna, i̱ ai oiquëre papi Jesure tujiꞌi, Jesure tse̱amaꞌnë a̱o a̱i maca jaꞌye ñuꞌi, “Ëjaë, ¿nepi coso yehuoja̱ꞌcohuaꞌi aꞌni?” caquë se̱siquëpi. ");
INSERT INTO seyNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pedropi ñani Jesure se̱jiꞌi: “¿Ëjaë, iquëretaꞌa me yoꞌoye paꞌija̱ꞌcoaꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Caquëna, Jesupi capi: “Yëꞌë coꞌi macaja̱ꞌa huajëquë iquë paꞌija̱quë caquë paꞌito ¿i̱quepi mëꞌëre coꞌaquëꞌni? Mëꞌë cato yëꞌëni tuijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ja̱ maca iye caseꞌere Jesús oiquërepa sehuosicohuaꞌi jupëpi asahuë. Asani cuasahuë, iquë cato ju̱ꞌiñe pa̱jaꞌquë api. Ja̱je Jesús cato ju̱ꞌiñe pa̱jaꞌquë api caye pa̱pi. I̱ cato capi: “¿Yëꞌë coꞌi macaja̱ꞌa huajëquë paꞌija̱quë caquë paꞌito i̱quepi mëꞌëre coꞌaquëꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Iye coca toyaquë cato i̱ oiquëpi toyayë, nuñerepa cocare quëaquë. Ja̱je paꞌina, nuñerepa cocare caji cajë asayë. ");
INSERT INTO seyNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesús yoꞌoseꞌe jaiye paꞌiji, paꞌiquëtaꞌare toyaye pa̱ñë. I̱ yoꞌoseꞌe ñape toyañuꞌu cajë yoꞌocohuaꞌi pani toya saoye peoji, siꞌa yeja maca toya pëpi ti̱më huesotoje̱. Ja̱ yëꞌtaꞌapi toyaye patiꞌñe paꞌio. Ca tëjihuë. Ja̱je paꞌija̱quë.");
INSERT INTO seyNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Yëꞌë cajei Teofilo, yëꞌë duꞌru macarepa toya pëpëna siꞌaye Jesuja̱ꞌa macarepa yoꞌo huëoquë yoꞌoseꞌe cuiꞌne i̱ yeꞌyaseꞌe, cuiꞌne i̱ maꞌtëmona sai macaja̱ꞌa yoꞌoseꞌe siꞌaye toyahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Ja̱ yëꞌtaꞌa maꞌtëmo saimaꞌnë i̱ jëjo saocohuaꞌire joꞌya sahuani deꞌo joyo co̱caiyepi i̱ohuaꞌi yoꞌo ja̱ꞌñe quëaëña. ");
INSERT INTO seyNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Cuiꞌne ju̱ꞌisiquëpi huajëquërepa paꞌiji cajë ñajajë caquë ja̱ꞌnë paꞌiseꞌeje̱ paꞌirepa pani i̱ñoquë cuarenta muꞌseña ñaiquë Diusu cua̱ñe te̱ꞌtere quëaëña, ja̱ohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ja̱ yëꞌtaꞌa Jesús i̱ jëjo saocohuaꞌi ja̱ꞌre paꞌi caëña: “Jerusalénpi saimaꞌpë utejë̱ꞌë, jaꞌquë mësarute i̱sisiꞌi ca nëoseꞌere yëꞌë quëaseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Juan cato ocopi dopi. Ja̱je paꞌiquëtaꞌare aꞌri maña se ñata sao muꞌseña mësaru cato deꞌo joyore pani do cua̱ñojaꞌcohuaꞌi paꞌija̱ꞌcohuaꞌi aꞌë, oco doyeje̱ paꞌye.” ");
INSERT INTO seyNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jesús quëꞌrona tsiꞌsija̱ni Jesure se̱iꞌë ñeje: “Ëjaë, ¿mëꞌë yurepi Israel pa̱i ëjaëre necaija̱ꞌquë aꞌë, yëquëre deꞌoye cua̱ñejaꞌquëre?” Cajëna, Jesupi sehuoëña: ");
INSERT INTO seyNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","“Ja̱ cato pa̱i asaye peoye aꞌë. Coa jaꞌquëseꞌe neñe paꞌiji. Ja̱je paꞌina, mësaru i̱ti nejaꞌa muꞌse cuiꞌne ti̱ yoꞌoja̱ꞌa tëcahuëje̱ asaye peoji. ");
INSERT INTO seyNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ja̱je paꞌiquëtaꞌare deꞌo joyopi mësaruna dani paꞌi maca tutu i̱si cua̱ñoni Jerusalén, Judea yeja, Samaria yeja, coa siꞌa yeja paꞌicohuaꞌire quëacaija̱ꞌcohuaꞌi aꞌë, yëꞌë yoꞌoseꞌe ayere.” ");
INSERT INTO seyNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ja̱ se ca tëjini ñajë nëcajëna, Jesús maꞌtëmona sa cua̱ñoëña. Sa cua̱ñoquëna, siriopi i̱te peo hue̱ꞌñarepa tsio dani hueso. ");
INSERT INTO seyNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ja̱ yëꞌtaꞌa Jesús maꞌtëmona mëiñere ñajë nëcajëna, peo hue̱ꞌña paꞌisicohuaꞌipi caya ë̱mëohuaꞌi pojaꞌi juꞌi ca̱ña juꞌicohuaꞌipi ñaini caëña, i̱ohuaꞌire: ");
INSERT INTO seyNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“Galilea pa̱i ¿me yoꞌojë maꞌtëmore ñajë nëcayeꞌni? Iquë Jesús mësaru ja̱ꞌre paꞌisiquëpi yure maꞌtëmo sa cua̱ñosiquë cuiꞌnaëpi coꞌija̱ꞌquë api, mësaru ñajëna, saiseꞌeje̱ paꞌye.” ");
INSERT INTO seyNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ja̱ maca Jesús jëjo saocohuaꞌi Olivos ai cu̱tihuëpi teꞌe kilómetro sani Jerusalénna coꞌireña, ja̱ohuaꞌi cato saëꞌë, huajë muꞌse ja̱ jaꞌye cuꞌiye paꞌiji, cua̱ñeseꞌe jaꞌye. ");
INSERT INTO seyNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ja̱ maca pa̱i daripëna ti̱ꞌani i̱ohuaꞌi huero pëani paꞌi huëꞌe ë̱mëjeꞌe tuꞌrihuëna mëni pëareña. I̱ti pëasicohuaꞌi cato paꞌiyë: Pedro, Juan, Jacobo, Andrés, Felipe, Tomás, Bartolomé, Mateo, Alfeo mamaquë Jacobo, Simón yequë mami hueꞌyosiquë Zelote, cuiꞌne Jacobo mamaquë Judas. ");
INSERT INTO seyNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Siꞌaohuaꞌi ja̱ohuaꞌi Jesús yoꞌje tsi̱ ja̱ꞌre, cuiꞌne Jesús pëca jaꞌco María ja̱ꞌre co̱ni, cuiꞌne yequë nomiohuaꞌi ja̱ꞌre co̱ni teꞌe cuasayepi siꞌanë Maijaꞌquëre se̱ñuꞌu cajë tsiꞌsijë paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ciento veinte sehuosicohuaꞌi paꞌicohuaꞌipi ja̱ muꞌseña teꞌe macana tsiꞌsirena, Pedropi jopore pana huëni nëcani caëña, ñeje: ");
INSERT INTO seyNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Maijaꞌquë doꞌijë, Jesure tse̱acohuaꞌire sai saquë Judas yoꞌo ja̱ꞌñere Maijaꞌquë joyopi Davidre duꞌru quëaëña. Quëaquëna, toyapi. Ja̱ toyaseꞌe, Maijaꞌquë joyo caseꞌe ti̱ꞌañe pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas cato mai aquë pajiꞌi. Cuiꞌne mai neñe ayere co̱ nequë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ja̱je paꞌiquëtaꞌa, coꞌaye yoꞌo doꞌire sa̱isi curiquëpi yejare huerohuë. Ja̱je paꞌiquëtaꞌare Judas cato si̱opëja̱ꞌa meñe to̱meni ë̱tatuꞌu joquëna, siꞌaye ë̱ta mea etaëna, ju̱quëña. ");
INSERT INTO seyNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ja̱ yoꞌoseꞌere Jerusalén paꞌicohuaꞌipi asani i̱ti tsiore hueꞌyohuë, tsie tsio. I̱ohuaꞌi cocarepa cato Acéldama hueꞌyoreña. ");
INSERT INTO seyNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ja̱je paꞌina, Salmos toya pëpë caji: I̱ paꞌisi huëꞌe je̱ocosi huëꞌe paꞌija̱ꞌcoa, Pëa co̱maꞌa huëꞌe. Cuiꞌne caji, yequeje̱: I̱ yoꞌoraꞌaseꞌere yequëpi yoꞌoye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Deꞌoji. Maipi iye macare payë, Jesús mai ja̱ꞌre paꞌi macapi, mai ja̱ꞌre siꞌanë paꞌicohuaꞌire Jesure Juan oco do macapi cuiꞌne i̱ maꞌtëmo mëi macana mai ja̱ꞌre paꞌicohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Ja̱je paꞌina, deꞌoji, ja̱ohuaꞌi aquëni teꞌire maire tsioja̱ꞌquëre neñe. Nerena, ja̱ëpi mai ja̱ꞌre co̱ni teꞌe Jesús ju̱ꞌisiquëpi huëjiꞌi, quëaja̱ꞌquëre.” ");
INSERT INTO seyNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Casi maca coꞌejë cayaohuaꞌire ti̱ꞌareña, José Barsabás cuiꞌne Matias. Josépi yequë mami Justo hueꞌequë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Ti̱ꞌani Maijaꞌquëre ñeje se̱iꞌë: “Jaꞌquë, mëꞌëpi pa̱i cuasaye ta̱ꞌñe asaquë aꞌë. Yëquëre i̱ñojëꞌë, ¿jequë aꞌni, mëꞌë joꞌya nesiquërepa mëꞌë jëjo saoquërepa Judas coꞌaye yoꞌoquë ne huesësiquë neraꞌaseꞌe nejaꞌquë?” ");
INSERT INTO seyNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Se̱ni tëjini neñañuꞌu cajë yoꞌojëna, Matiasna Jesús jëjo saoquë paꞌiye to̱mepi. To̱meina, ja̱re i̱ti macapi, Jesús once jëjo saocohuaꞌi ja̱ꞌre co̱ni paꞌiquë po̱nëpi. ");
INSERT INTO seyNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Judío pa̱i fiesta Pentecostés muꞌse ti̱ꞌasi maca siꞌaohuaꞌi sehuosicohuaꞌi teꞌe macana tsiꞌsini paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Paꞌijëna, cuasamaꞌtore papi jai tutu jupë pi̱sico jutayeje̱ paꞌyerepa maꞌtëmopi pi̱sico jutaëña. Jutani i̱ti pi̱siyepi siꞌa huëꞌe ti̱mëëña, i̱ohuaꞌi paꞌi hue̱ꞌña. ");
INSERT INTO seyNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ja̱ maca pa̱i ñapere toa corohuë̱aje paꞌyepi i̱ohuaꞌi si̱opë̱ana ñai nëcareña. ");
INSERT INTO seyNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ja̱ maca yuretaꞌa siꞌaohuaꞌi deꞌo joyopi ti̱mësicohuaꞌi pateña. Paꞌijë joyo necaina, yequë pa̱i cocapi careña. ");
INSERT INTO seyNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ja̱ muꞌseña Judío pa̱i siꞌa hue̱ꞌña paꞌicohuaꞌipi Jerusalénna tsiꞌsicohuaꞌipi pateña, deꞌoye yoꞌo pa̱ipi. ");
INSERT INTO seyNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Paꞌicohuaꞌipi tutu pi̱siyeje̱ paꞌyere asani tsiꞌsireña, i̱ti pi̱si hue̱ꞌñana. Tsiꞌsini asareña, i̱ohuaꞌi cocapi, sehuosicohuaꞌipi cajëna. Asajë ¿merepa ja̱je cayeꞌni? cuasahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ja̱je cuasajë asa quëquëjë ai coꞌa ju̱ꞌijë sa̱ꞌñe cahuë: “¿Siꞌaohuaꞌi icohuaꞌi Galilea pa̱itaꞌa pa̱i ñape cocapi cayeꞌni? ");
INSERT INTO seyNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Me neni pa̱i ñape cocare papi cajëna, asayeꞌni? ");
INSERT INTO seyNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Iye maca paꞌiyë, Partia pa̱i, Elam pa̱i, Media pa̱i, Mesopotamia pa̱i, Judea pa̱i, Capadocia pa̱i, Ponto pa̱i, cuiꞌne Asia yeja pa̱i, paꞌiyë. ");
INSERT INTO seyNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Paꞌiyë cuiꞌne Frigia pa̱i, Panfilia pa̱i, Egípto pa̱i, cuiꞌne Cirene quëꞌro Libia pa̱ije paꞌiyë. Paꞌiyë, cuiꞌne romano pa̱ije, coa dani paꞌicohuaꞌije̱ judío pa̱irepa cuiꞌne judío pa̱i yoꞌoye coa se yeꞌyesicohuaꞌije̱ paꞌiyë. ");
INSERT INTO seyNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Paꞌiyë, cuiꞌne Creta pa̱i cuiꞌne Arabia pa̱ije siꞌaohuaꞌi paꞌicohuaꞌipi asahuë, Maijaꞌquë deꞌoyerepa yoꞌoyere pa̱i ñape cocapi cajëna.” ");
INSERT INTO seyNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Siꞌaohuaꞌi quëquë huesësicohuaꞌi paëꞌë, jerepa yeque cuasaye peoyerepa. Ja̱je paꞌijë sa̱ꞌñe se̱iꞌë: “¿I̱quere pare quëaquëꞌni, iye yoꞌoyere?” ");
INSERT INTO seyNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Cajëna, yecohuaꞌipi cueꞌcuejë careña: “Ja̱ohuaꞌi cato da huesoquëna, yoꞌojë cayë.” ");
INSERT INTO seyNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Cajëna, ja̱ maca Jesús jëjo saocohuaꞌi aquë Pedropi yecohuaꞌi i̱ cajeohuaꞌi once paꞌiohuaꞌi ja̱ꞌre co̱ni huëni nëcani tutu capi, ñeje: “Judío pa̱i cuiꞌne siꞌaohuaꞌi Jerusalén paꞌicohuaꞌi asajë̱ꞌë. Iye mësaruje̱ yëꞌë caquëna, deꞌoye asajë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Icohuaꞌi daquëna yoꞌojë camaꞌpë paꞌiyë, mësaru cuasayeje̱ paꞌye, yurena nueve paꞌito me cuepeyeꞌni. ");
INSERT INTO seyNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Iye cato coa ai jerepa Maijaꞌquë caye quëacaiquë Joel caquë paꞌiseꞌepi ti̱ꞌaquë yoꞌoquëna cayë. I̱ caseꞌe cato caji: ");
INSERT INTO seyNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Tëji muꞌseñarepa yëꞌë joyore pa̱ina i̱sija̱ꞌquë aꞌë caji, Maijaꞌquë. I̱sina, mësaru mamajë ë̱mëohuaꞌi cuiꞌne nomiohuaꞌi yëꞌë ayere caja̱ꞌcohuaꞌi aꞌë, Po̱sëohuaꞌipi ca̱imaꞌpëtaꞌa ca̱ni ñañeje paꞌye ñajëna, quëasiꞌi. Cuiꞌne aiohuaꞌi huëo hue̱ꞌñajaꞌa ñajëna, quëasiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ja̱ muꞌseña yëꞌë joꞌyaohuaꞌi ë̱mëohuaꞌina cuiꞌne nomiohuaꞌina yëꞌë joyore i̱sisiꞌi. I̱siquëna, yëꞌë ayere quëacohuaꞌi paꞌija̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Cuiꞌne maꞌtëmopi pa̱i ti ña maꞌñere i̱ñoñe paꞌija̱ꞌcoa, Cuiꞌne yejare i̱ñosiꞌi, tsiepi, toapi, cuiꞌne toa picopi, ");
INSERT INTO seyNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ë̲së miamaꞌquë deꞌoja̱ꞌquë api, Cuiꞌne ñañëje tsieje̱ paꞌi deꞌoja̱ꞌquë api, Iye cato mai Ëjaërepa ja̱ daimaꞌnë paꞌi ja̱ꞌñe aꞌë. I̱ dai muꞌserepa cato ëja muꞌserepa cuiꞌne deꞌo muꞌserepa pasipi. ");
INSERT INTO seyNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ja̱ muꞌseña siꞌaohuaꞌi yëꞌëre se̱cohuaꞌi ti̱ꞌajaꞌcohuaꞌi aꞌë, huaso cua̱ñosicohuaꞌi paꞌiye. Toyapi, Joel. ");
INSERT INTO seyNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Israel pa̱i asajë̱ꞌë, yëꞌë caquëna. Mësarupi tsoe asayë, Jesús Nazaret aquë pa̱i pajiꞌi. Paꞌina, Maijaꞌquëpi mësaru ña hue̱ꞌñana i̱repa paꞌiye i̱ñopi. I̱ñoquë Jesuja̱ꞌa Maijaꞌquëpi pa̱i yoꞌo ti̱ꞌa maꞌñere cuiꞌne jaiye deꞌoyere pare yoꞌo i̱ñopi. ");
INSERT INTO seyNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ja̱je paꞌitaꞌare Maijaꞌquë tsoe ja̱je yoꞌosiꞌi cuasa nëoseꞌeje̱ paꞌye, mësaruna i̱te tse̱ani que̱ni huani je̱ohuë, coꞌacohuaꞌi jëñaja̱ꞌa. ");
INSERT INTO seyNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ja̱je huani je̱osicohuaꞌitaꞌare Maijaꞌquëpi ju̱ꞌiñe hue̱seꞌere peo hue̱ꞌña nejoni huajëquëre huëopi, je i̱ paꞌimaꞌquëni ju̱ꞌiñepi meñe quëco pacoꞌni. ");
INSERT INTO seyNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Pa̱i ëjaërepa David Jesús ayere caquë capi, ñeje: Ëjaëpi yëꞌë ti̱ñare pare paꞌina, i̱seꞌere siꞌanë ñahuë. I̱pi yëꞌë ëja te̱ꞌtere paꞌito, yëꞌëre siꞌaye coꞌaye paꞌinije ne ta̱oñe peoji. ");
INSERT INTO seyNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ja̱je paꞌina, ai sihuayë, yëꞌë joyopi, sihuaquë yëꞌë yëꞌopopi jë̱jëñë. Mëꞌëpi ñacaina, quëcoquë pëa huajëja̱ꞌquë aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ja̱re mëꞌëpi yëꞌëre ta̱si daripëna je̱omaꞌë paꞌija̱quë aꞌë. Cuiꞌne yëꞌë mëꞌë deꞌo joꞌyaë ca̱pë ja̱ꞌju tiya huesëyeje̱ pa̱jaꞌcoa, mëꞌëpi ë̱sequëna. ");
INSERT INTO seyNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Mëꞌëpi yëꞌëre i̱ñohuë, paꞌi maꞌare pare, Cuiꞌne mëꞌë ja̱ꞌre co̱ni paꞌi ai sihuaja̱ꞌquë aꞌë, yëꞌë. Ja̱je capi, David, Jesús ca ja̱ꞌñe. ");
INSERT INTO seyNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Israel pa̱i asajë̱ꞌë, David mai ñecuë tsoe ju̱quëna, ta̱jë paꞌa̱huëꞌë. Yureje̱ i̱te ta̱jë paꞌisicoje̱ huiꞌyomaꞌcopi paꞌico. ");
INSERT INTO seyNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Israel pa̱i ëjaërepa David cato Maijaꞌquëre quëacaiquë pajiꞌi. Ja̱je paꞌipi asapi, Maijaꞌquë care paquëpi ca nëoseꞌere i̱ tsëcapë aquëni Maijaꞌquëpi Israel pa̱i ëjaëre pare necai ja̱ꞌñere, i̱ meñe najeini. ");
INSERT INTO seyNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ja̱je paꞌina, David ñaquë cayeje̱ paꞌyere capi, Cristo huëi ja̱ꞌñere. I̱o caseꞌe cato caji: ‘ta̱si daripëre u̱i huesëye pa̱jaꞌquë api,’ cuiꞌne ‘i̱ ca̱pëje̱ ja̱ꞌju tiya huesëye pa̱jaꞌcoa,’ capi. ");
INSERT INTO seyNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ja̱je paꞌiye sëte Maijaꞌquëpi Jesure ja̱re David casiquëni huëopi, huajëquëre. Ja̱ yoꞌoseꞌe yëquëpi ñasicohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ja̱je paꞌina, Maijaꞌquëpi Jesure i̱ ëja te̱ꞌte ñuꞌijaꞌquëre nepi, jerepa paꞌire pare. Ja̱je neina, pëca jaꞌquëni deꞌo joyore pare i̱si cua̱ñopi i̱ ca nëosiquëre i̱si cua̱ñoni i̱pi yure pa̱i ñapere huahuecajiꞌi, huahuecaiyere ja̱re yure mësaru ñajë cuiꞌne asahuë capi. ");
INSERT INTO seyNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ja̱je paꞌina, Davidpi maꞌtëmo mëiñe pa̱pi. Ja̱je paꞌiye sëte capi: Ëjaëpi yëꞌë Ëjaëre capi: ‘Jaꞌrujë̱ꞌë, yëꞌë ëja te̱ꞌtena, ");
INSERT INTO seyNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Yëꞌëpi mëꞌëre sa̱ñope yoꞌocohuaꞌire mëꞌë quë̱o huëꞌehuëna jëjo o̱a sao macaja̱ꞌa.’ ");
INSERT INTO seyNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ja̱je paꞌina, Jesús mësaru que̱ni huani je̱ocosiquëre Diusupi Ëjaëre pare Cristo huasoquëre nepi. Iyere cato Israel pa̱i asaye paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ja̱je Pedro caquëna, asani joyore papi ai coꞌa ju̱ꞌijë oijë Pedrore cuiꞌne i̱ cajeohuaꞌire once paꞌiohuaꞌireje̱ se̱iꞌë, ñeje cajë: “¿Yëquë yure me nejaꞌcohuaꞌi aꞌni, Maijaꞌquë doꞌijë?” ");
INSERT INTO seyNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Se̱jëna, Pedro capi: “Mësaru tayo yoꞌoseꞌere sa̱i to̱ cua̱ñoñe cani cuiꞌne deꞌo joyore i̱sija̱ꞌquë cani mësaru ja̱ꞌnë cuasaseꞌere je̱oni Maijaꞌquëna po̱nëñe paꞌiji. Ja̱je yoꞌoni pa̱i ñape Jesuni cuasajë oco do cua̱ñoñe paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Maijaꞌquë i̱ joyo i̱sisiꞌi ca nëoseꞌe mësaru. Mësaru mamajë cuiꞌne soꞌo paꞌicohuaꞌi cuiꞌne siꞌaohuaꞌi Maijaꞌquë yë soija̱ꞌcohuaꞌi tse̱ aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Yequeje̱ cuiꞌne capi, Pedro: “Huasosicohuaꞌi paꞌijë̱ꞌë, ai coꞌacohuaꞌi jopo paꞌicohuaꞌipi.” Ja̱je caquë yëhuopi. ");
INSERT INTO seyNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","I̱ ja̱je caquë yëhuoye asasicohuaꞌiseꞌe oco do cua̱ñoni tres mil Jesure sehuocohuaꞌi paëꞌë, ja̱ maca. ");
INSERT INTO seyNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Paꞌijë siꞌaohuaꞌi Jesús jëjo daocohuaꞌi yeꞌyayere deꞌoye sehuocaijë nuñerepa paëꞌë. Paꞌijë sa̱ꞌñe deꞌoye yoꞌojë, Maijaꞌquëre se̱jë cuiꞌne a̱o yëtoni a̱ijë paëꞌë, Jesús yoꞌoseꞌere cuasajë. ");
INSERT INTO seyNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Jesús yeꞌyaquë paꞌisicohuaꞌipi jaiye pa̱i yoꞌo ti̱ꞌa maꞌñere yoꞌojëna, ñajë ai cuasareña, merepa ja̱je yoꞌoyeꞌni cajë. ");
INSERT INTO seyNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","I̱tire paꞌë cuasajë asasicohuaꞌipi teꞌe cuasajë tsiosicohuaꞌipi paꞌijë coꞌamañaje teꞌe pahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Siꞌaye i̱ohuaꞌi coꞌamaña i̱sijë curi maña huerojë yecohuaꞌi coꞌamaña caracohuaꞌina i̱sihuë, i̱ohuaꞌire caraye. ");
INSERT INTO seyNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ja̱je yoꞌojë paꞌicohuaꞌipi siꞌa muꞌseña Maijaꞌquëre se̱jë paëꞌë, Maijaꞌquëre se̱ huëꞌena. Ja̱je yoꞌojë cuiꞌne i̱ohuaꞌi huë̱ꞌñana Jesure cuasajë a̱ore yëtoni a̱ijë teꞌe hue̱ꞌña tsiꞌsini a̱ore huahuejë a̱ijë sihuajë paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Paꞌijë Maijaꞌquë deꞌoquëre paꞌni cajë paëꞌë. Siꞌaohuaꞌi yecohuaꞌije̱ deꞌo pa̱ire paꞌë cajë ñahuë. Cajë ñajëna, Ëjaëpi jero saꞌna jai pa̱ire i̱te sehuocohuaꞌire nepi. Nequëna, jai pa̱i sehuocohuaꞌi huaso cua̱ñosicohuaꞌi paëꞌë, muꞌse ñape. ");
INSERT INTO seyNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Teꞌe muꞌse naꞌiquëna, Pedropi cuiꞌne Juanpi co̱ni Maijaꞌquëre se̱ hora a las tres paꞌi maca Maijaꞌquëre se̱ huëꞌena saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Satena, ja̱rote cuꞌimaꞌquëpi Deꞌoco hueꞌyosi eta saꞌro yëꞌquë macare da ñosiquëpi ñuꞌi Pedrore cuiꞌne Juanre caca huëojëna, curiquë se̱jiꞌi. Ja̱ë cato tsi̱ꞌnëna cuꞌimaꞌquë pajiꞌi, da cacacohuaꞌire curiquë se̱jaquë cajë dasiquëpi. Ja̱je paꞌipi siꞌa muꞌseña pa̱ipi i̱te sa̱ñojëna, curi hueroquë ñuꞌiquë pajiꞌi, eta saꞌro yëꞌquë macare ñuꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ja̱je curi ñuꞌi se̱i ñuꞌiquëpi Pedrore cuiꞌne Juanre ñani curiquë se̱jiꞌi, tsoe caca tëjiye jaꞌi macare paꞌijëna. ");
INSERT INTO seyNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Se̱ina, Pedropi i̱te ñani capi: “Ñajëꞌë, yëquëni.” ");
INSERT INTO seyNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Caquëna, curiquëre i̱sisiꞌquë camaꞌquë cuasaquë i̱seꞌere ñaquëna, ");
INSERT INTO seyNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pedropi capi, i̱te: “Yëꞌë curiquë peoyë. Ja̱je paꞌiquëtaꞌare yëꞌë payere i̱sisiꞌi. Jesús Nazaret aquë mamipi cayë huëni cuꞌijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Caquë Pedropi ëja te̱ꞌte jë̱tëna tse̱ani naë huëo nëcoquëna, teꞌere papi jëꞌa huëni nëcapi. Huëni nëcaquëna, i̱ nëcañoa cuiꞌne i̱ jëo peto ca̱ jëaye carapi. ");
INSERT INTO seyNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Caraëna, deꞌoye nëcaquë cujiꞌi. Ja̱ maca yuretaꞌa i̱ohuaꞌi ja̱ꞌre tsioni teꞌe Maijaꞌquëre se̱ huëꞌena cacani Maijaꞌquëre deꞌoquëre paꞌni caquë sihuaquë saꞌcaquë yoꞌopi. ");
INSERT INTO seyNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Cacani cuꞌi Maijaꞌquë deꞌoquëre paꞌni caquë sihuaquë yoꞌoquëna, siꞌaohuaꞌi i̱te ñahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ñajë quëquë huesëhuë, i̱te yoꞌoseꞌere cuasajë. Noni Maijaꞌquëre se̱ huëꞌe eta saꞌropi Deꞌoco hueꞌe hue̱ꞌñapi curi se̱i ñuꞌina, ñacohuaꞌi sëte quëquëhuë, i̱ cuꞌiye ñani. ");
INSERT INTO seyNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","I̱ti coꞌyasiquëpi Pedrore cuiꞌne Juanre tse̱ani ñuni saomaꞌë yoꞌopi. Yoꞌoquëna, ña quëquëjë siꞌaohuaꞌi Pórtico de Salomón ca hue̱ꞌñana huëꞌhuëjë saëꞌë, i̱ohuaꞌi paꞌi hue̱ꞌñana ñañuꞌu cajë. ");
INSERT INTO seyNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Jai pa̱i tsiꞌsijëna, ñani Pedro capi: “¿Me yoꞌojë Israel pa̱i ai cuasayeꞌni? Iquëre yëquë tutupi pa̱nitaꞌa Maijaꞌquëre yëquë ai oi doꞌipi ne coꞌyarena, cuꞌiyeje̱ ñajë mësaru yëquëseꞌere ai ñañë. ");
INSERT INTO seyNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Iquë ju̱ꞌiquëre cato, mai aiohuaꞌi, Abraham Diusupi Isaac cuiꞌne Jacobo Diusupi ne coꞌyapi. I̱ necaiquë Jesuni jerepa paꞌire i̱ñoquë. Mësaru pa̱i ëjaëna tse̱ani i̱sirena, Pilato deꞌoquë api cuasani joyesiꞌi caquëna, mësaru ë̱sehuë. Ja̱je paꞌina, mësaru ë̱sesiquë paꞌiyere i̱ñoquë yoꞌopi. ");
INSERT INTO seyNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Iquë deꞌoye nuiñe yoꞌoquëni joyeye ë̱sejë pa̱ire huaiquëni joyejë̱ꞌë, cahuë, mësaru. ");
INSERT INTO seyNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ja̱je yoꞌoni paꞌiye i̱si Ëjaëni mësaru huani je̱ohuë. Ja̱je yoꞌosicohuaꞌitaꞌare Maijaꞌquëpi huajëquëre huëopi, i̱te. Ja̱ yoꞌoseꞌe yëquëpi ñasicohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Iquë mësaru noni ñaquëre, Jesure necaiquëre pare asa doꞌipi tutu i̱sipi. I̱sina, ñañë, mësaru. Jesure necaiquëre pare asa doꞌipi iquëre ju̱ꞌiñe ti peoquëre pare ne coꞌyapi, mësarupi ñañë, siꞌaohuaꞌi i̱ti yoꞌoseꞌe. ");
INSERT INTO seyNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Asayë, yuretaꞌa mësaru Jesure huai maca yoꞌoseꞌe. Mësaru cuiꞌne mësaru ëjaohuaꞌi cato ja̱re cajë yoꞌoyë, cuasamaꞌpë coa noni huesë huani je̱ohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ja̱je yoꞌojëna, Maijaꞌquë cato i̱te quëacohuaꞌi ja̱ꞌre Cristo ju̱ꞌiñe paꞌiji tsoe hue̱ꞌña caseꞌere yoꞌo ti̱ꞌapi. ");
INSERT INTO seyNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ja̱je paꞌina, mësarupi Maijaꞌquëna daijë̱ꞌë. Dani ja̱ꞌnë yoꞌoseꞌe je̱ojëꞌë, mësaru coꞌaye yoꞌoseꞌere të̱no je̱ocaija̱ꞌquëre. Ja̱je yoꞌojëna, ñani Maijaꞌquëpi deꞌoye paꞌiye i̱siꞌñe paꞌi api. ");
INSERT INTO seyNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Tsoe hue̱ꞌña mësarute i̱sisiꞌi, Cristore cuasa nëosiquëni Jesuni jëjo daoquë mësaruna. ");
INSERT INTO seyNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ja̱je paꞌiquëtaꞌare yure cato i̱te quëacaicohuaꞌi tsoe hue̱ꞌña paꞌisicohuaꞌi ja̱ꞌnë caꞌñeje paꞌye siꞌa coꞌamaña ne deꞌhua macaja̱ꞌa Cristo maꞌtëmore paꞌija̱ꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ja̱je paꞌina, mai aiohuaꞌire Moisés quëapi, ñeje: ‘Ëjaë Diusupi yëꞌëje̱ paꞌire i̱te quëacaija̱ꞌquëre nejaꞌquë api, mësaru aquëni. Siꞌaye i̱ caye deꞌoye sehuocaijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Siꞌaohuaꞌi i̱ caye sehuocaimaꞌcohuaꞌi cato, pa̱i paꞌi daripëpi ti̱rona nejosicohuaꞌi paꞌija̱ꞌcohuaꞌi aꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Siꞌaohuaꞌi Maijaꞌquëre quëacaicohuaꞌi Samuel paꞌinëpi de ñata dao muꞌseña cato iye muꞌseña paꞌi ja̱ꞌñere cahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ja̱je paꞌina, mësaru aꞌë, i̱te quëacaicohuaꞌi mamajë Maijaꞌquë i̱sisiꞌi ca nëoseꞌere pacohuaꞌi, Abrahamre ca nëoseꞌe pacohuaꞌi. I̱ caseꞌe cato caji: ‘Mëꞌë tsëcapë acohuaꞌija̱ꞌa iye yeja paꞌicohuaꞌi siꞌaohuaꞌi deꞌoye paꞌiye i̱si cua̱ñojaꞌcohuaꞌi aꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ja̱je paꞌina, mësarupi coꞌaye paꞌiyere je̱oni po̱nëjëna, deꞌoye paꞌiye i̱sisiꞌi caquë Maijaꞌquëpi i̱ mamaquëre ju̱ꞌisiquëni huëoni mësaruna duꞌru jëjo daopi.” ");
INSERT INTO seyNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro cuiꞌne Juan ja̱ yëꞌtaꞌa pa̱ire cajëna, Israel pa̱i ëjaohuaꞌipi cuiꞌne Maijaꞌquëre se̱ huëꞌe ñacai soldado pa̱i ëjaëpi cuiꞌne saduceo pa̱i co̱ni da ti̱tahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ti̱tani ja̱ohuaꞌipi pë̱ijë asahuë, ju̱ꞌisicohuaꞌi huëiye paꞌiji, Jesús huëiseꞌepi i̱ñopi cajëna, Pedropi cuiꞌne Juan co̱ni. ");
INSERT INTO seyNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Asani tse̱ahuë. Tse̱ani naꞌi huesëye sëte pa̱ire co hue̱ꞌñana cohuë, se ñatasi muꞌse ñañuꞌu cajë. ");
INSERT INTO seyNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ja̱je yoꞌojëtaꞌare i̱ti quëaye asasicohuaꞌi jai pa̱i sehuohuë. Ja̱ maca sehuosicohuaꞌire ë̱mëohuaꞌiseꞌere cue̱cueto cinco mil pa̱i paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ñatasi muꞌse Jerusalénna tsiꞌsihuë, Israel pa̱i ëjaohuaꞌi, aiohuaꞌi cuiꞌne cua̱ñeseꞌe yeꞌyacohuaꞌi co̱ni. ");
INSERT INTO seyNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ja̱rote Maijaꞌquë huëꞌe ñacai ëjaërepa Anásje̱ pajiꞌi. Paꞌina, cuiꞌne yecohuaꞌije̱ paëꞌë, Caifás, Juan, Alejandro co̱ni. Paꞌijëna, cuiꞌne siꞌaohuaꞌi Maijaꞌquë huëꞌe ñacai ëjaërepa sëcapë tsiꞌsisicohuaꞌipi paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Paꞌijë cua̱ñehuë, Pedrore cuiꞌne Juanre dajë̱ꞌë. Carena, darena, i̱ohuaꞌi jopona nëconi ñeje cajë se̱iꞌë: “¿I̱que tutupi pa̱nitaꞌa i̱quei mamipi mësaru cajë iye ñeje yoꞌoyeꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Se̱jëna, Pedro deꞌo joyopi i̱ ja̱ꞌre paꞌiye sëte i̱ohuaꞌire sehuoquë capi: “Mai ëjaohuaꞌi cuiꞌne mai aiohuaꞌi asajë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ju̱ꞌiquëre jujuseꞌere me neni ne coꞌyareꞌni cajë se̱ni asañuꞌu cajë se̱ñe sëte quëasiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Deꞌoji. Ja̱je paꞌito, siꞌaohuaꞌi mësaru asa hue̱ꞌñana quëañuꞌu, siꞌaohuaꞌi Israel pa̱i asaja̱jë cajë. Iquë iye maca siꞌaohuaꞌi mai ñajëna, paꞌiquë cato Jesucristo Nazaret aquë mami doꞌire coꞌyapi, mësaru que̱ni huani je̱orena, Maijaꞌquëpi huajëquëre huëosiquë doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Iquë Jesús mësaru huëꞌe necohuaꞌipi doꞌi peoquëre ñasi quë̱na pë api. Ja̱je paꞌisiquëtaꞌa yure cato i̱ti quëco pa quë̱na përepa deꞌopi. ");
INSERT INTO seyNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ja̱je paꞌina, Peoji, yequë pa̱ire huasoquë. Maijaꞌquë maire huasoja̱ꞌquëre yequëre necaiye pa̱pi.” ");
INSERT INTO seyNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Caꞌraye peoyerepa Pedropi cuiꞌne Juanpi co̱ni cajëna, ñajë ëjaohuaꞌipi cuasahuë, icohuaꞌi ai yeꞌyemaꞌcohuaꞌi aꞌë cuiꞌne pa̱i paꞌiyeje̱ yeꞌyemaꞌcohuaꞌi aꞌë. Ja̱je paꞌiohuaꞌipi cuiꞌne Jesús yeꞌyaquë paꞌisicohuaꞌi aꞌë. Ja̱je cuasajë ñajë quëquë asahuë, i̱ohuaꞌi cayere. ");
INSERT INTO seyNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Jerepa, cuiꞌne i̱ohuaꞌi ja̱ꞌre co̱ni i̱ti coꞌyasiquëje̱ paꞌina, ñajë ti sa̱ñope cayeje̱ pa̱huë. ");
INSERT INTO seyNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Pa̱jë ja̱ maca tsiꞌsi sitopi Pedrore cuiꞌne Juanre etajë̱ꞌë carena, etahuë. Etarena, i̱ohuaꞌiseꞌe sa̱ꞌñe coca cahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ñeje cahuë: “Siꞌaohuaꞌi Jerusalén paꞌicohuaꞌi asayë, iye pa̱i yoꞌo ti̱ꞌa maꞌñere yoꞌoseꞌe. Ja̱je asajëna, maipi ja̱je yoꞌoye pa̱huë ca ti̱ꞌañe peoji. ¿Ja̱je paꞌito yure me nejaꞌcohuaꞌi aꞌni, icohuaꞌire? ");
INSERT INTO seyNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ja̱je paꞌito iyere yoꞌoñuꞌu. Iye yoꞌosi coca jerepa jai saiye pa̱jaꞌcore huajo yëni quëcoñuꞌu i̱ohuaꞌini iye macapi jerepa pa̱ire quëaye pa̱jaꞌcohuaꞌire, Jesús ayere.” ");
INSERT INTO seyNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Cani yuretaꞌa i̱ohuaꞌire soini cua̱ñehuë, Jesús aye pa̱ire camaꞌpë paꞌijë̱ꞌë, cuiꞌne i̱ ayeje̱ pa̱ire yeꞌyamaꞌpë paꞌijë̱ꞌë cajë. ");
INSERT INTO seyNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Cua̱ñejëna, Pedropi cuiꞌne Juanpi sa̱ñope sehuojë cahuë: “Mësarupi cuasani ñajëꞌë, ¿i̱quepi deꞌoquëꞌni, mësaru cayere sehuoye, pa̱nitaꞌa Maijaꞌquë cayere? ");
INSERT INTO seyNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Yëquë ñaseꞌere cuiꞌne asaseꞌere quëaye paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Pa̱i cato ne coꞌyasiquëni ñani Maijaꞌquë ai deꞌoji cajë sihuahuë. Ja̱je sihuajëna, ëjaohuaꞌipi Pedrore cuiꞌne Juanre siꞌseñuꞌu cuasajëtaꞌa pa̱ini caꞌrajë siꞌsemaꞌpë coa huajo yëni eto saohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Pa̱i ne ti̱ꞌa maꞌñere papi coꞌyasiquë cato cuarenta o̱metëca jerepa paquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Eto saorena, Pedro cuiꞌne Juan sehuosicohuaꞌi quëꞌrona sani Israel ëjaohuaꞌi cuiꞌne aiohuaꞌi caseꞌere siꞌaye quëahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Quëajëna, asani siꞌaohuaꞌi teꞌe cajë Maijaꞌquëre se̱iꞌë, ñeje: “Ëjaë maꞌtëmo cuiꞌne yeja, jai tsiaya, siꞌaye i̱ote paꞌiye deꞌhuasiquë, ");
INSERT INTO seyNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","mëꞌëpi deꞌo joyoja̱ꞌa cahuë, mëꞌë joꞌyaë David yëꞌopoja̱ꞌa ñeje: ¿Me yoꞌojë pa̱i jo̱sa yoꞌojë cayeꞌni? ¿Me yoꞌojë pa̱i ti cuasamaꞌpë coa huëojë ja̱je neñuꞌu ca nëoñeꞌni? ");
INSERT INTO seyNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Pa̱i ëjaohuaꞌipi cuiꞌne ëjaohuaꞌipi co̱ni, Maijaꞌquëre cuiꞌne maire huasoquëre sa̱ñope yoꞌoñuꞌu cajë teꞌe cuasajë yoꞌoyë. ");
INSERT INTO seyNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Iye daripëna Herodes cuiꞌne Pilato cuiꞌne yequë pa̱i cuiꞌne Israel pa̱i tsiꞌsini Jesure sa̱ñope yoꞌohuë, mëꞌë sahuani i̱sisiquëre. ");
INSERT INTO seyNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ja̱je yoꞌojë yoꞌo ti̱ꞌacaëꞌë, mëꞌë ja̱je yoꞌosiꞌi cuasa nëoquë paꞌiseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Yure Ëjaë, yëquë mëꞌë joꞌyare i̱ohuaꞌi huajo yëyere ñani i̱sijë̱ꞌë, mëꞌë coca, caꞌramaꞌpë quëa ja̱ꞌñere. ");
INSERT INTO seyNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Jesús mëꞌë mamaquë cocare quëajëna, mëꞌë tutupi ju̱ꞌicohuaꞌire jujuye, yequë muꞌseña paꞌi ja̱ꞌñe i̱ñoñe cuiꞌne pa̱i yoꞌo ti̱ꞌa maꞌñere yoꞌojë̱ꞌë, Jesús doꞌipi.” ");
INSERT INTO seyNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ja̱je se̱ni tëjisi maca i̱ohuaꞌi se̱ sitopi ñuꞌcueo. Ñuꞌcuecona, siꞌaohuaꞌi deꞌo joyo ti̱mësicohuaꞌi paëꞌë. Paꞌijë Maijaꞌquë coca quëahuë ti̱ñarepa, caꞌramaꞌpë. ");
INSERT INTO seyNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jai pa̱i sehuosicohuaꞌi paꞌicohuaꞌipi teꞌe cuasajë cuiꞌne nëina, paëꞌë. Paꞌijë coꞌamañaje siꞌaohuaꞌi teꞌena pahuë. Teꞌije̱ yëꞌëseꞌe teꞌi pasiꞌi caquë yoꞌoquëje̱ peopi. ");
INSERT INTO seyNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Peojëna, Jesús jëjo saocohuaꞌipi siꞌa tuturepa quëahuë, Jesús ju̱ꞌisiquëpi huëiseꞌere. Quëajëna, Maijaꞌquëpi ñacaina, siꞌaohuaꞌi deꞌoye paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Paꞌijëna, teꞌije̱ i̱ohuaꞌi aquë coꞌamaña caraquëna, ai yoꞌoquë peopi siꞌaohuaꞌi pahuë. Ja̱ payere cajë yejaña pa̱nitaꞌa huë̱ꞌña pacohuaꞌipi i̱sijë curi neni, ");
INSERT INTO seyNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Jesús jëjo saocohuaꞌina dani curi i̱sihuë. Ja̱ohuaꞌipi siꞌaohuaꞌire i̱ti pa̱i ñapere caraye jaꞌye huahueja̱jë cajë i̱sihuë. ");
INSERT INTO seyNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ja̱je yoꞌopi, levita José hueꞌequëni, Chipre saodohuë aquëni Jesús jëjo saocohuaꞌipi Bernabére hueꞌyosiquëpi. Bernabé cani cayë “Yëhuo huasoquë mamaquë”. ");
INSERT INTO seyNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ja̱ëpi i̱ yejare i̱siquë curi neni Jesús jëjo daocohuaꞌina curi dani i̱sipi, i̱ohuaꞌipi ñajë huahueja̱jë caquë. ");
INSERT INTO seyNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ja̱je paꞌiquëtaꞌare yequëpi Ananías hueꞌequëpi i̱ paco Safira ja̱ꞌre yejare i̱sihuë. I̱sini curi neni, ");
INSERT INTO seyNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","siꞌaye i̱siye pa̱ñuꞌu teꞌe cuasahuë. Cuasani i̱ohuaꞌi pa ja̱ꞌñe deꞌhuahuë. Deꞌhuani yequere Jesús jëjo saocohuaꞌina i̱sipi, i̱ohuaꞌipi ñajë huahueja̱jë caquë. ");
INSERT INTO seyNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","I̱siquëna, Pedropi capi: “¿Ananías i̱que doꞌire huati ëjaë mëꞌë joyona cacaëꞌni yeja doꞌi sa̱isi curire mëꞌëpi yequere deꞌhuani yequere i̱siquë siꞌaye i̱siyë caquë deꞌo joyore cosoja̱quë caquë? ");
INSERT INTO seyNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Yejaje̱ mëꞌë yeja paꞌimaꞌona, ja̱je yoꞌou? ¿Curije̱ mëꞌë curiquë paꞌimaꞌëna, ja̱je yoꞌou? ¿Merepa mëꞌë ja̱je yoꞌosiꞌi cuasaëꞌni? Pa̱ini mëꞌë cosomaꞌë paëꞌë. Maijaꞌquëni mëꞌë cosohuë.” ");
INSERT INTO seyNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Caquëna, Ananías asani ju̱ni ta̱jiꞌi. Siꞌaohuaꞌi i̱ ju̱ni ta̱iseꞌe asasicohuaꞌi quëquë huesëhuë. ");
INSERT INTO seyNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ja̱ maca yuretaꞌa po̱sëohuaꞌipi dani i̱ ca̱pë ca̱ñapi tu̱nani sani ta̱huë. ");
INSERT INTO seyNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tres horas tëto sai maca Ananías nëjo cacao, i̱o ë̱jëre yoꞌoseꞌe asamaꞌcopi. ");
INSERT INTO seyNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Cacacona, Pedropi i̱ote se̱jiꞌi: “¿Mësaru caseꞌe jaꞌye yeja doꞌi i̱sire?” Caquëna, cao: “Ja̱je paꞌijë̱ꞌë, ja̱re ja̱ jaꞌye i̱sihuë.” ");
INSERT INTO seyNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Cacona, Pedropi capi: “¿Me neni mësaru teꞌe ja̱je yoꞌoñuꞌu cuasani ëjaërepa joyore neñañuꞌu cajë yoꞌoyeꞌni? Jecohuaꞌi daiyë, mëꞌë ë̱jëre ta̱sicohuaꞌi cuiꞌne yure mëꞌëni saja̱ꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ca macarepa Safira huajërepa ju̱ni ta̱coꞌë, Pedro quë̱o yëꞌquë macana. Ju̱ni ta̱isicopi u̱iona, po̱sëohuaꞌipi cacani ti̱ꞌani sani ta̱huë, i̱o ë̱jëre ta̱sico yëꞌquë macana. ");
INSERT INTO seyNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ja̱ maca siꞌaohuaꞌi sehuosicohuaꞌi cuiꞌne siꞌaohuaꞌi i̱ti yoꞌoseꞌe, asasicohuaꞌi quëquë huesëhuë. ");
INSERT INTO seyNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Pa̱i paꞌi hue̱ꞌñana Jesús jëjo saocohuaꞌipi jaiye deꞌoye yoꞌohuë, pa̱i yoꞌo ti̱ꞌa maꞌñere cuiꞌne i̱ñoñere. Yoꞌojëna, siꞌaohuaꞌi Salomón nequë paꞌisi tuꞌrihuë paꞌicona, tsiꞌsijë yoꞌohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Teꞌije̱ yecohuaꞌi aquë tsiosiꞌi caquë yoꞌoye pa̱pi, i̱ohuaꞌire. Ja̱je paꞌiquëtaꞌare pa̱i cato deꞌocohuaꞌi aꞌë, cuasajë. ");
INSERT INTO seyNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Yoꞌojëna, ë̱mëohuaꞌi cuiꞌne nomiohuaꞌi Ëjaëre sehuoni jai pa̱i paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Cuiꞌne ju̱ꞌicohuaꞌireje̱ ca̱i saina cuiꞌne ju̱ꞌicohuaꞌire sayena o̱eni maꞌañana eto o̱ehuë, Pedropi da saina, i̱ pa̱i toꞌoupi ja̱ohuaꞌi acohuaꞌina juꞌaquëna, coꞌyaja̱jë cuasajë. ");
INSERT INTO seyNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Cuiꞌne Jerusalén yërëhue pa̱i dari paꞌicohuaꞌipi jai pa̱i Jerusalénna daëꞌë, ju̱ꞌicohuaꞌire cuiꞌne huati quëꞌiohuaꞌire dajë. Dajëna, siꞌaohuaꞌi juju cua̱ñohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaë ja̱ꞌre saduceo pa̱i paꞌicohuaꞌipi siꞌaohuaꞌi co̱ni i̱ohuaꞌi yoꞌoyere ñajë oicohuaꞌi paëꞌë, cuiꞌne yoꞌo ti̱ꞌañe peo doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ñani pë̱ijë Jesús jëjo saocohuaꞌire tse̱ani coꞌaye yoꞌocohuaꞌire co hue̱ꞌñana cohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Cosicohuaꞌini Maijaꞌquë hui̱ñaëpi ñami pa̱ire co huëꞌe eta saꞌro huiꞌyoni etopi, ñeje caquë: ");
INSERT INTO seyNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Sani pa̱ire quëajë̱ꞌë, mësaru iye huajëye paꞌiyere Maijaꞌquëre se̱ huëꞌepi nëcajë.” ");
INSERT INTO seyNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Caëna, asasicohuaꞌipi ñatani i̱ caseꞌeje̱ paꞌye Maijaꞌquë huëꞌena nea hue̱ꞌñarepa cacani pa̱ire yeꞌya huëohuë. Ja̱je yeꞌyajëna, Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaë cuiꞌne i̱ ja̱ꞌre co̱ni paꞌisicohuaꞌipi ëjaohuaꞌire paseꞌe coca cayena soihuë, siꞌaohuaꞌire Israel pa̱i aiohuaꞌire coca cañuꞌu cajë. Ja̱ maca tsiꞌsini Jesús jëjo saocohuaꞌire co hue̱ꞌña ñuꞌicohuaꞌire quërëja̱ijaꞌcohuaꞌire jëjo saohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Jëjo saojëna, soldadopi co huëꞌena sani coa ña jujahuë, tsoe peojëna. Ja̱je ña jujani coꞌini ñeje cajë quëahuë: ");
INSERT INTO seyNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Pa̱ire co tuꞌrihuë cato deꞌoyerepa si̱osico pajiꞌi. Paꞌina, cuiꞌne soldado pa̱ije eta saꞌnoare nëcajë deꞌoyerepa ñahuë. Ja̱je paꞌioni huiꞌyojë ñajëna, ti pa̱i peoco pajiꞌi, sa̱ꞌnahuë.” ");
INSERT INTO seyNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Cajëna, ja̱re asani Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaërepa, Maijaꞌquëre se̱ huëꞌe ñacai soldado pa̱i ëjaë cuiꞌne aiohuaꞌi co̱ni cahuë: “¿Jerore pana ja̱ yoꞌoseꞌe nëajai ja̱ꞌñe aꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ja̱je yoꞌojë ca macarepa teꞌi ti̱tani capi: “Mësaru cosicohuaꞌipi Maijaꞌquëre se̱ huëꞌere nëcajë pa̱ini yeꞌyayë.” ");
INSERT INTO seyNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Caquëna, asani soldado pa̱i ëjaëpi i̱ soldado pa̱i ja̱ꞌre sajiꞌi, tse̱asiꞌi caquë. Tse̱asicohuaꞌitaꞌa coꞌaye yoꞌoye pa̱huë, pa̱ipi pë̱ti huëoni quë̱na pë̱api je̱amaꞌcohuaꞌini cuasajë caꞌrajë. ");
INSERT INTO seyNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ti̱tani i̱ohuaꞌire tse̱ani sahuë, ca tëji ëjaohuaꞌi quëꞌrona. Sarena, Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaëre papi capi, i̱ohuaꞌire: ");
INSERT INTO seyNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Tsoe mësarute cahuë yëquë, ja̱ë Jesús aye ti pa̱ire yeꞌyamaꞌpë paꞌijë̱ꞌë cajë. ¿Casicohuaꞌini mësaru cato me yoꞌoreꞌni? Mësaru cato siꞌa Jerusalén ja̱ë aye yeꞌyayepi ti̱më huesoyë. Cuiꞌne ja̱seꞌe yoꞌoye pa̱ni yëquëreje̱ ja̱ëre huani je̱osi doꞌi quëꞌiohuaꞌire cañuꞌu cajë yoꞌoyë.” ");
INSERT INTO seyNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Caquëna, Pedropi cuiꞌne i̱ cajeohuaꞌi Jesús jëjo saocohuaꞌipi sehuojë cahuë, ñeje: “Yëquë cato Maijaꞌquë cayere sehuocaiye paꞌiji, pa̱ni pa̱i cayere. ");
INSERT INTO seyNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mësaru cruzuna deoni huani je̱osiquëre mai aiohuaꞌi Diusupi huajëquëre huëopi, Jesure. ");
INSERT INTO seyNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Maijaꞌquëpi huëoni i̱ ëja te̱ꞌtena ñopi, i̱te. Pa̱ire deꞌoye saquëre neni cuiꞌne huasoquëre nepi, i̱te, Israel pa̱ipi Maijaꞌquëna coꞌini i̱ohuaꞌi coꞌaye yoꞌoseꞌe sa̱icaja̱ꞌquë caquë. ");
INSERT INTO seyNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Iye yoꞌoseꞌe yëquë ñasicohuaꞌipi quëaye cuiꞌne Maijaꞌquë i̱te sehuocohuaꞌire i̱si joyo deꞌo joyoje̱ ñasiquëpi quëaji.” ");
INSERT INTO seyNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ja̱je cayere asani Israel pa̱i ëjaohuaꞌipi pë̱titeni huani je̱oñuꞌu cajë yoꞌohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ja̱je yoꞌojë ca ëjaohuaꞌi jopore teꞌi fariseo Gamaliel hueꞌequë pajiꞌi, siꞌa pa̱i deꞌoye cajëna paꞌiquërepa, cuiꞌne cua̱ñeseꞌe yeꞌyaquërepa. Ja̱ëpi huëni nëcani cua̱ñepi: “Jesús jëjo saocohuaꞌire hueꞌsena eto saojë̱ꞌë, ëa maca cacaja̱ꞌcohuaꞌire,” capi. ");
INSERT INTO seyNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Caëna, etosi jeteyoꞌje i̱je paꞌi ëjaohuaꞌire capi: “Israel pa̱i mësaru ja̱ohuaꞌire yoꞌo ja̱ꞌñe deꞌhua ñani yoꞌojë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Cuasajë̱ꞌë, cuiꞌne Teudas yoꞌoseꞌere. Ai tsoe maca, ja̱ë je̱ꞌquë ëjaëre paꞌë caquë yoꞌopi. Yoꞌoquëna, cuatrocientos pa̱irepa i̱te peꞌtehuë. Peꞌtejëna, i̱ti saquëni huani je̱orena, i̱te peꞌtecohuaꞌi peo hue̱ꞌña tiya huesëhuë. Ja̱ maca caraja̱jiꞌi, ja̱ yoꞌoseꞌe siꞌaye. ");
INSERT INTO seyNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ja̱ jeteyoꞌje pa̱ire cue̱cue muꞌseña paꞌi maca Judas Galilea aquëpi cuiꞌne ëjaëꞌë caquë yoꞌopi. Yoꞌoquëna, i̱te pa̱i peꞌte huëohuë. Peꞌte huëorena, i̱ni huani je̱orena, i̱te peꞌtecohuaꞌi peo hue̱ꞌña tiya huesëhuë. ");
INSERT INTO seyNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ja̱je paꞌina, mësarute yëhuoquë cayë. Ja̱ohuaꞌire yoꞌoye je̱oni ñuni saojë̱ꞌë, i̱ohuaꞌiseꞌe paꞌija̱jë. Ja̱je paꞌina, iyepi pa̱i tse̱ pani coa caraja̱i ja̱ꞌñe aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ja̱je paꞌiquëtaꞌare iyepi Maijaꞌquë tse̱ paꞌito mësaru ne ti̱ꞌañe pa̱jaꞌcohuaꞌi aꞌë. Ja̱je paꞌito ñare pajë yoꞌojë̱ꞌë. Yoꞌojë Maijaꞌquëni sa̱ñope yoꞌoyë, mësarupi.” ");
INSERT INTO seyNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Caëna, asani i̱ caseꞌe sehuocaëꞌë. Ja̱ maca yuretaꞌa Jesús jëjo saocohuaꞌire soini siꞌseni, Jesús coca ti quëaye pa̱jëꞌë, cani yuretaꞌa ñuni saohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ñuni saojëna, Jesús jëjo saocohuaꞌipi etajë Maijaꞌquëpi ja̱je yëna Jesús mami doꞌire ai yoꞌoyë cuasajë sihuahuë, pa̱i ëjaohuaꞌi quëꞌropi etajë. ");
INSERT INTO seyNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Etasicohuaꞌipi siꞌa muꞌseña Jesús deꞌo cocare quëajë yeꞌyahuë, Maijaꞌquëre se̱ huëꞌena cuiꞌne huë̱ꞌñana. ");
INSERT INTO seyNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ja̱ muꞌseña sehuocohuaꞌipi jai pa̱i sehuojë jojo saiye sëte, griego pa̱i coca cacohuaꞌipi sa̱ñope ca huëohuë, hebreo pa̱i coca cacohuaꞌini griego pa̱i huaꞌjeohuaꞌini siꞌa muꞌseña huahueyere deꞌoye huahuecaimaꞌpë paꞌiyë cajë. ");
INSERT INTO seyNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ja̱je cajëna, asani doce paꞌiohuaꞌi Jesús soisicohuaꞌipi siꞌaohuaꞌire sehuosicohuaꞌire tsiꞌsoni cahuë: “Coꞌaji, yëquëpi huahueye ñañere cajë, Maijaꞌquë coca quëayere je̱oto. ");
INSERT INTO seyNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ja̱je paꞌi doꞌire sehuosicohuaꞌi mësarupi mësaru acohuaꞌini siete paꞌiohuaꞌire coꞌejë̱ꞌë, mësaru ai deꞌo pa̱ire ñacohuaꞌini, ta̱ꞌñe asacohuaꞌini cuiꞌne deꞌo joyo ti̱mësicohuaꞌini. Ti̱ꞌarena, ja̱ohuaꞌina iye coꞌamaña yoꞌo ja̱ꞌñe i̱siñuꞌu, yëquë. ");
INSERT INTO seyNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","I̱sini yëquë cato Maijaꞌquëre se̱jë cuiꞌne i̱ coca quëajë pañuꞌu.” ");
INSERT INTO seyNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Carena, siꞌaohuaꞌi ja̱je yoꞌoñuꞌu cuasani sahuajë ti̱ꞌahuë, Estebanre, Maijaꞌquëre asaquëre pare, deꞌo joyore ti̱mësiquëre, Felipere, Prócorore, Nicanorre, Timónre, Parmenasre, Nicolásre, Nicolás cato ja̱ꞌnë Israel pa̱i yoꞌoye sehuo aquë pajiꞌi, Antioquía aquë. ");
INSERT INTO seyNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ti̱ꞌani Jesús jëjo saocohuaꞌi quëꞌrona sahuë, i̱ohuaꞌire. Sarena, ja̱ohuaꞌipi i̱ohuaꞌi si̱opë̱ana patojë Maijaꞌquëre se̱cacaëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Maijaꞌquë coca jero saꞌna jai sacoꞌë. Jai saiona, sehuojë jai pa̱i paëꞌë, sehuocohuaꞌije̱ Jerusalén paꞌicohuaꞌipi. Ja̱je jai pa̱i sehuojëna, cuiꞌne Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌije̱ sehuohuë, teꞌohuaꞌiseꞌe. ");
INSERT INTO seyNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Maijaꞌquë i̱si tutu deꞌoyere pare paquëꞌni Esteban pa̱i yoꞌo ti̱ꞌa maꞌñere yoꞌo i̱ñopi, pa̱i daripë paꞌicohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ja̱je yoꞌoquëna, ñani Joꞌyaohuaꞌi paꞌisicohuaꞌipi eta huajësicohuaꞌi hueꞌyo huëꞌe paꞌicohuaꞌipi cuiꞌne Cirene acohuaꞌipi, Alejandría acohuaꞌipi, cuiꞌne Cilicia acohuaꞌipi, cuiꞌne Asia yeja acohuaꞌipi Estebanre sa̱ñope ca huëohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ca huëosicohuaꞌitaꞌa ca ti̱ꞌañe pa̱huë, deꞌo joyo i̱siyepi ta̱ꞌñerepa caquëna, siꞌaye. ");
INSERT INTO seyNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ja̱ maca yuretaꞌa Moisésre cuiꞌne Maijaꞌquëre sa̱ñope caquëna, asahuë, caja̱ꞌcohuaꞌire curipi sa̱ihuë. ");
INSERT INTO seyNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Sa̱irena, ja̱ohuaꞌipi siꞌa i̱ti daripë pa̱ire ne huëohuë, jai coꞌa coca. Ja̱je ne huëorena, aiohuaꞌi cuiꞌne cua̱ñeseꞌe yeꞌyacohuaꞌi Estebanre huajo huëohuë. Huajo huëoni tse̱ani ca tëji ëjaohuaꞌi quëꞌrona sahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ja̱je yoꞌojë cuiꞌne coa cosoja̱ꞌcohuaꞌireje̱ nesicohuaꞌipi ñeje cahuë: “Maijaꞌquëre se̱ huëꞌere iquë ai sa̱ñope caquë api cuiꞌne cua̱ñeseꞌeje̱ sa̱ñope caquë api. ");
INSERT INTO seyNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Cuiꞌne Jesús Nazaret aquëpi Maijaꞌquëre se̱ huëꞌe nejojaꞌquë api. Nejoquë cuiꞌne Moisés maire je̱ocaiseꞌere ti̱ñe po̱najaꞌquë api, caquë api, iquë.” ");
INSERT INTO seyNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Siꞌaohuaꞌi i̱ti maca ñuꞌicohuaꞌipi cuiꞌne ëjaohuaꞌipi co̱ni Esteban tsiare ñahuë, hui̱ñaë tsiaje̱ paꞌiore pare hueꞌequëna. ");
INSERT INTO seyNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaëre papi Estebanre se̱jiꞌi. “¿Mëꞌëre ja̱je yoꞌoquëre pani ja̱ohuaꞌi caye caquë?” ");
INSERT INTO seyNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Se̱ina, Esteban sehuoquë capi: “Aꞌyëohuaꞌi, cuiꞌne jaꞌquëohuaꞌi, asajë̱ꞌë, yëꞌë caquëna. Maijaꞌquë deꞌoquëpi mai ai Abrahamna ñai i̱ñopi, Mesopotamiare paꞌina, Harán yejana ja̱ saimaꞌnë. ");
INSERT INTO seyNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","I̱ñoquë capi: ‘Mëꞌë yeja cuiꞌne mëꞌë cajeohuaꞌire je̱oconi saijë̱ꞌë, yëꞌë i̱ñojaꞌa yejana.’ ");
INSERT INTO seyNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Caëna, Abraham Caldea yejapi etani Harán yejana sani pajiꞌi. Paꞌina, pëca jaꞌquë ju̱ni huesëpi. Ju̱quëna, jeteyoꞌje Maijaꞌquëpi Abrahamre iye yejana dapi, yure mësaru paꞌi hue̱ꞌñana. ");
INSERT INTO seyNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ja̱je paꞌiquëtaꞌare i̱ti yejana coꞌamaña necani i̱siye pa̱pi. Quë̱o tsaꞌcuja̱ꞌtoje̱ i̱siye pa̱pi. Ja̱je paꞌiquëtaꞌare i̱sija̱ꞌquë aꞌë ca nëopi, i̱ ju̱ꞌisi jeteyoꞌje i̱ tsëcapë tse̱co paꞌija̱ꞌcore. Ja̱ muꞌseña cato Abraham mamajëre peoquë paꞌinije ja̱je capi. ");
INSERT INTO seyNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Yequeje̱ cuiꞌne Maijaꞌquëpi capi, i̱te: ‘Mëꞌë tsëcapë acohuaꞌipi yequë pa̱i yejare huero paꞌija̱ꞌcohuaꞌi aꞌë. Paꞌijëna, joꞌyaohuaꞌire pajë coꞌaye yoꞌoja̱ꞌcohuaꞌi aꞌë, cuatrocientos o̱metëcarepa.’ ");
INSERT INTO seyNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Yequeje̱ capi, Maijaꞌquë: ‘Yëꞌëpi mësarute joꞌyaohuaꞌire neni pasicohuaꞌire sa̱ijaꞌquë aꞌë. Ja̱ jeteyoꞌje mësaru eta huajëni yëꞌëre iye macapi necaijë paꞌija̱ꞌcohuaꞌi aꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ca nëoseꞌere yoꞌoja̱jë caquë Abrahamre Diusupi cua̱ñepi, cuiri ca̱ꞌnire tëajë̱ꞌë, caquë. Ja̱je paꞌina, Abraham i̱ mamaquë Isaacre ocho muꞌseña co̱asiquë paꞌina, cuiri ca̱ꞌnihuë maca tëapi. Ja̱je cuiꞌne yoꞌopi, Isaacje̱ I̱ mamaquë Jacobre. Iquë Jacobpi siꞌaohuaꞌire i̱ mamajëre ja̱je yoꞌopi, Israel pa̱i doce tsëcapë̱a pëca jaꞌquëohuaꞌi paꞌija̱ꞌcohuaꞌireje̱. ");
INSERT INTO seyNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Mai aipë Jacobo mamajëpi yoꞌjei Josére pëca jaꞌquëpi ai oina cuiꞌne oni cua̱ñoñe peojë i̱si je̱ohuë, Egíptona saja̱jë cajë. Ja̱je paꞌiquëtaꞌare Diusupi José ja̱ꞌre co̱ni pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Paꞌi siꞌaye i̱ ai yoꞌoye huasopi. Co̱cai cuiꞌne ta̱ꞌñe yoꞌoye i̱sipi. I̱siquë cuiꞌne Egípto ëjaëre papi deꞌoye i̱te ñacai ja̱ꞌñeje necajiꞌi. Necaina, Josére Egípto pa̱i ëjaëre hueꞌyopi. Cuiꞌne i̱ Faraónrepa paꞌi huëꞌe ñacaiquëre pare hueꞌyopi. ");
INSERT INTO seyNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ja̱ maca siꞌa Egípto yeja Canaán yeja a̱o ëa ju̱ꞌiñe pajiꞌi, ai yoꞌo muꞌseña. Paꞌina, mai aipëje̱ a̱iñe ti peocohuaꞌi paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Paꞌijëna, Jacobpi Egíptore a̱o paꞌiji, asani i̱ mamajëre mai aipëre jëjo saopi. Iye saiseꞌe cato duꞌru macarepa saiseꞌe aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ti̱jupë cayaye acore satena, Josépi i̱ majaꞌyë jupëre yëꞌë mësaru yoꞌjeiꞌë caquë quëapi. Ja̱je quëaquëna, asani Faraónpi ja̱ tsëcapë aquë api caquë Josére ñapi. ");
INSERT INTO seyNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ja̱ jeteyoꞌje Josépi pëca jaꞌquë Jacobre cuiꞌne i̱ tsëcapë setenta y cinco pa̱i paꞌicohuaꞌire Egíptona daijë̱ꞌë, caquë cua̱ñepi. ");
INSERT INTO seyNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ja̱je cua̱ñeina, Jacob Egíptona sani pajiꞌi. Paꞌiquëpi ju̱jiꞌi. Ja̱je cuiꞌne i̱ mamajëje ju̱juhuë, mai aipëje̱. ");
INSERT INTO seyNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ja̱ maca taraseꞌe Siquemna sani cojena o̱a huesohuë. Abraham curipi Hamor mamajëre hueroquë paꞌisi yejana o̱areña. ");
INSERT INTO seyNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Maijaꞌquë Abrahamre ca nëoseꞌe ti̱ꞌañe jaꞌi maca paꞌina, Israel pa̱i jai pa̱i jojo sateña, Egípto yeja. Ja̱je yoꞌoni jai pa̱i pateña. ");
INSERT INTO seyNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ja̱je paꞌi maca Josére ñamaꞌquëpi yequepi Egípto pa̱i ëjaë cua̱ñe huëouña. ");
INSERT INTO seyNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Cua̱ñe huëoni iye ëjaëpi mai pa̱ire care payeje̱ paꞌye caquë, coꞌaye yoꞌoquë tsi̱re ja̱ꞌa co̱asicohuaꞌire je̱ocojë̱ꞌë ju̱ꞌijaꞌcohuaꞌire caquë cua̱ñepi, pëca jaꞌquëohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ja̱ muꞌseña Moisés co̱a. Co̱aëna, Maijaꞌquë sihuaquë ñapi, i̱te. Ja̱ëni pëca jaꞌquëohuaꞌipi toaso̱ ñañëohuaꞌire huëꞌena ñajë pahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Pa jujani je̱ocoye paꞌijëna, Faraón mamacopi i̱te i̱ni mamaquëre pare ai deꞌhuayeje̱ paꞌye ai deꞌhuao. ");
INSERT INTO seyNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ja̱je paꞌina, Moisés cato Egípto pa̱i ta̱ꞌñe yoꞌoyere yeꞌyesiquë pajiꞌi. Ja̱je paꞌipi tutu caquëpi cuiꞌne yoꞌoyeje̱ i̱ caseꞌeje̱ yoꞌoquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Cuarenta o̱metëcaña papi i̱ pa̱ire Israel pa̱ire ñasiꞌi cuasapi. ");
INSERT INTO seyNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Cuasaquëpi ñaquëna, Egípto pa̱ipi Israel pa̱ire coꞌaye yoꞌoquëna, ñani Moisés co̱casiꞌi caquë yoꞌoquë Egípto pa̱ire huani je̱opi. ");
INSERT INTO seyNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisés cato ja̱je yoꞌoquëna, ñani i̱ cajeohuaꞌipi Diusu i̱ohuaꞌire huasoja̱ꞌquëre jëjo daoquë api cuasaja̱jë caquë yoꞌopi. Yoꞌoquëtaꞌare i̱ cajeohuaꞌipi ja̱je cuasaye pa̱huë. ");
INSERT INTO seyNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Yoꞌosiquëpi ñatasi muꞌse Israel pa̱ipi cayaohuaꞌi sa̱ꞌñe uihuajëna, Moiséspi ti̱ꞌapi. Ti̱ꞌani uihuamaꞌpë paꞌija̱jë caquë capi: ‘¿Me neñuꞌju teꞌe tsëcapëtaꞌa sa̱ꞌñe uihuayeꞌni?’ ");
INSERT INTO seyNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Caquëna, i̱ti se ai huaiquëpi Moisésre jë̱tëpi jëjo saoquë capi: ‘¿Nepi mëꞌëre pa̱i ëjaëre cuiꞌne yëquë yoꞌoye ñaquë ne deꞌhuaja̱ꞌquëre nereꞌni? ");
INSERT INTO seyNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Ñaminaꞌa Egípto pa̱ire huani je̱oseꞌeje̱ paꞌye yëꞌëre huani je̱osiꞌi caquë?’ ");
INSERT INTO seyNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Caquëna, iyere asani Moisés Madián yejana cati sajiꞌi. Sani ja̱rote ti̱ yejare huero paꞌi caya mamajëre papi. ");
INSERT INTO seyNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Cuarenta o̱metëca tëto saisi maca, zarza ñëpi toa corohuërepa tsë̱ꞌisicoja̱ꞌa hui̱ñaëpi ñai nëcapi, Sinaí cu̱tihuëna cue̱ne yejana. ");
INSERT INTO seyNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ca̱ni ñañeje paꞌye Moisés ñaquë i̱quere paꞌni cuasaquë ñapi. Ja̱je cuasaquë deꞌoyerepa ñasiꞌi caquë tsioja̱i asapi, Ëjaë yëꞌore ñeje caquëna: ");
INSERT INTO seyNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Yëꞌë cato mëꞌë aipë Diusu aꞌë. Abraham, Isaac, cuiꞌne Jacob Diusu aꞌë, Yëꞌë.’ Ja̱re asani Moisés i̱ti ca hue̱ꞌña ñamaꞌë, caꞌraquë coa tsasi huëouna. ");
INSERT INTO seyNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ja̱ maca Ëjaëpi caëña: ‘Dutajë̱ꞌë, quë̱o juꞌiye. Mëꞌë nëca hue̱ꞌña cato deꞌo hue̱ꞌñare paꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Egípto yejare paꞌijë yëꞌë pa̱i ai yoꞌoye ti̱ñarepa ñaquë paꞌiyë. Aiohuaꞌipi ai yoꞌojë oijëna, asani huasosiꞌi caquë cajehuë. Ja̱je paꞌiye sëte daijë̱ꞌë, yëꞌëpi mëꞌëre Egíptona jëjo saosiꞌi.’ ");
INSERT INTO seyNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Israel pa̱i coejë ‘¿nepi mëꞌëre pa̱i ëjaëre cuiꞌne yëquë yoꞌoye ñaquë ne deꞌhuaquëre nereꞌni casiquëni?’ Maijaꞌquëpi pa̱i ëjaëre cuiꞌne pa̱ire huasoquëre neni jëjo saopi, i̱ohuaꞌi quëꞌrona. Aꞌri so̱quë yë ñasiquë hui̱ñaëpi co̱caina, yoꞌo ti̱ꞌajaquë caquë. ");
INSERT INTO seyNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Iquë Moisés mai aipëre Egíptopi etopi, pa̱i yoꞌo ti̱ꞌa maꞌñere yoꞌoquëna, cuarenta o̱metëcahuëa̱ña. ");
INSERT INTO seyNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ja̱re iquë Moiséspi capi, Maijaꞌquëpi mësaru aquëni yëꞌëje̱ paꞌire nejaꞌquë api, i̱te quëacaiquë paꞌija̱ꞌquëre. ");
INSERT INTO seyNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Cuiꞌne ja̱re iquë Moiséspi Israel pa̱i ja̱ꞌre tsiꞌsini coca caꞌa̱jiꞌi, jeto cue̱ne yejana. Ja̱re i̱pi hui̱ñaëre coca caꞌa̱jiꞌi, Sinaí cu̱tihuëna. Ja̱re i̱pi mai aipë ja̱ꞌre paꞌa̱jiꞌi. Cuiꞌne ja̱re i̱pi paꞌi cocarepa asapi, maire quëa ja̱ꞌñeje̱. ");
INSERT INTO seyNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ja̱je paꞌiquëtaꞌare mai aipë cato sehuocaiye coehuë. Coejë Egíptona coꞌiñuꞌu cahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ja̱je cajë Aarónre cahuë, yëquëre saja̱ꞌa diusuohuaꞌini necaijë̱ꞌë. Huesëyë. Me saꞌrepa yëquëre Egíptopi etosiquë Moisés neni joꞌcuarepa nëiji, cahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ja̱je cani duruhue̱quëje̱ paꞌire diusu api cajë deꞌhuahuë. Deꞌhuani i̱te i̱siñuꞌu cajë nëicohuaꞌire huani i̱sijë cuiꞌne jai pa̱i tsiꞌsini i̱ohuaꞌi deꞌhuasi diusure sihuajë yoꞌohuë, Maijaꞌquë api cajë. ");
INSERT INTO seyNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ja̱je yoꞌojëna, Maijaꞌquëpi ja̱ohuaꞌire ña jujani je̱ocopi maꞌñocohuaꞌi maꞌtëmo paꞌicohuaꞌini se̱cohuaꞌi paꞌija̱jë caquë. Ja̱je paꞌina, Maijaꞌquëre quëacaicohuaꞌi toyapëna toyaseꞌe paꞌiji, ñeje: Israel pa̱i, ¿mësaru jeto cue̱ne yeja cuarenta o̱metëca paꞌi maca, Yëꞌëre sihuajë deꞌoye se̱ñuꞌu cajë nëtëroja̱icohuaꞌire huani i̱sijë, cuiꞌne coꞌamaña coa i̱sijë yoꞌore? ");
INSERT INTO seyNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Pa̱huë, mësaru ja̱je yoꞌoye. Coa ai jerepa Moloc diusu huëꞌere hueꞌejë sajë, Cuiꞌne Refán diusu maꞌñoconi hueꞌejë sajë Cuiꞌne mësaru se̱ñuꞌu cajë deꞌhuasi diusuohuaꞌini hueꞌejë sajë yoꞌohuë. Ja̱ doꞌire mësarute yëꞌëpi Babiloniana jëjo saoja̱ꞌquë aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ja̱ maca cato mai aiohuaꞌi ca̱ꞌnipi nesi huëꞌere pahuë, Maijaꞌquë ja̱ꞌre. Ja̱je yoꞌoñuꞌu, cajë nejaquë neseꞌere i̱ño huëꞌere. Ja̱ huëꞌe cato Moisésre Maijaꞌquë caquë i̱ñoni ñeje paꞌiore nejëꞌë caquë cua̱ñeseꞌeje̱ paꞌiore nesico pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ja̱ huëꞌe mai aiohuaꞌi tsoe pasiconi Josué ja̱ꞌre daicohuaꞌipi teꞌe i̱ohuaꞌi daiyeje̱ dahuë, yecohuaꞌi yeja jio maca Maijaꞌquëpi i̱ohuaꞌi ñajëna, yequë pa̱ire nejo maca. Ja̱je pahuë, ja̱ huëꞌe David paꞌi macaja̱ꞌa. ");
INSERT INTO seyNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Pajë paꞌicohuaꞌini Davidpi Maijaꞌquëre deꞌoye ña cua̱ñoquëpi Jacob Diusu huëꞌe necasiꞌi cuasapi. ");
INSERT INTO seyNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Cuasaquëtaꞌa pa̱pi. Necaiye pa̱quëna, mamaquë Salomónpi necajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ja̱je paꞌiquëtaꞌare Maijaꞌquë i̱repa cato pa̱i nesi huëꞌere paꞌimaꞌquë api. Ja̱je paꞌina, Maijaꞌquëre quëacaiquëpi capi, ñeje: ");
INSERT INTO seyNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Maꞌtëmo cato yëꞌë paꞌi hue̱ꞌñaꞌë. Yëꞌë ñuꞌi cua̱ñe hue̱ꞌñaꞌë. Yeja cato yëꞌë quë̱o meñe tsaꞌcupa hue̱ꞌñaꞌë. ¿Ja̱je paꞌito me yëꞌë huëꞌe necaija̱ꞌcohuaꞌi aꞌni? caji, Ëjaë. ¿Jero aꞌni, yëꞌë pëa huajëja̱ꞌto? ");
INSERT INTO seyNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Siꞌaye yëꞌë ne saoseꞌepi paꞌito. ");
INSERT INTO seyNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ja̱je paꞌiquëtaꞌare mësaru cato nuiñerepa asajëtaꞌa nuñere pare yoꞌoyere coecohuaꞌi aꞌë. Ja̱je paꞌiohuaꞌipi ca̱jonoaje asamaꞌcohuaꞌipi cuiꞌne joñoaje̱ ti Maijaꞌquëre cuasamaꞌcohuaꞌi aꞌë, mësaru. Deꞌhue Maijaꞌquë joyore sa̱ñope yoꞌocohuaꞌi aꞌë. Aiohuaꞌi paꞌiseꞌeje̱ paꞌiohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ja̱je paꞌina, ¿jequë aꞌni, Maijaꞌquëre quëacaiquë mësaru aiohuaꞌi coꞌaye yoꞌoye pa̱siquë? Ti peoji, teꞌije̱. Ja̱je paꞌina, coꞌaye yoꞌojë huani je̱ohuë, nuñerepa paꞌi dai ja̱ꞌñere quëacohuaꞌire. Yure i̱pi nuñerepa paꞌipi daquëna, mësarupi tse̱ani huani je̱ohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mësaru hui̱ñaohuaꞌipi cua̱ñeseꞌe i̱sijëna, i̱sicohuaꞌi deꞌoye sehuocaimaꞌpë paꞌiyë.” Ja̱re capi, Esteban. ");
INSERT INTO seyNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ja̱je caquëna, asani Estebanre ai pë̱ijë cu̱ji qui̱ꞌcohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ja̱je yoꞌotoje̱ Esteban cato deꞌo joyo ti̱mësiquëpi maꞌtëmore ñaquë Maijaꞌquë deꞌoyere pare ñapi. Ñaquë cuiꞌne Jesure ñapi, Maijaꞌquë ëja tëꞌhui quëꞌrore nëcaquëna. ");
INSERT INTO seyNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ñani capi: “I̱na maꞌtëmo huiꞌyosiconi ñañë, cuiꞌne Jesupi Maijaꞌquë ëja tëꞌhuire nëcaquëna.” ");
INSERT INTO seyNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Caquëna, asani pë̱ijë ca̱jonoa pëꞌpëni cuijë i̱na da to̱me daëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Da to̱me dani tse̱ani pa̱i daripëpi etoni quë̱na pë̱api je̱a hue̱ahuë, coꞌaye yoꞌoquë api cajë. Huaicohuaꞌipi i̱ohuaꞌi ca̱ña duꞌteni teꞌe po̱së Saulo hueꞌequëna, i̱sihuë, ñacaijë̱ꞌë cajë. ");
INSERT INTO seyNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Quë̱na pë̱api je̱ajëna, Estebanpi Maijaꞌquëre se̱i capi: “Ëjaë Jesús, yëꞌë joyo mëꞌëpi deꞌhuacaijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Cani ja̱ maca doꞌre jaꞌruni ai tutu capi: “Ëjaë yëꞌëre huaicohuaꞌi yoꞌoseꞌe sa̱imaꞌë paꞌijë̱ꞌë.” Ja̱re cani ju̱jiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ju̱ni huesëquëna, i̱ti maca Saulo nëcaquë ñaquëpi. Deꞌoji, Estebanre huaiseꞌe cuasaquë ñapi. ");
INSERT INTO seyNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Deꞌo pa̱ire papi Estebanre ai oijë ta̱ je̱ohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ja̱re yoꞌojëna, Saulo cato sehuosicohuaꞌire huë̱ꞌña ñape cacaquë ë̱mëohuaꞌire, nomiohuaꞌire, quërë etoquë co hue̱ꞌñana cosiꞌi caquë yoꞌopi. ");
INSERT INTO seyNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ja̱je yoꞌojëna, Jerusalénpi etasicohuaꞌipi siꞌa hue̱ꞌña saijë huaso coca quëahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Quëajëna, i̱ohuaꞌi aquë Felipepi Samaria daripëna sani Jesús coca quëapi. ");
INSERT INTO seyNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Quëaquë pa̱i yoꞌo ti̱ꞌa maꞌñe yoꞌopi. Yoꞌoquëna, ñajë siꞌaohuaꞌi tsiꞌsini ai asahuë, Felipe caye. ");
INSERT INTO seyNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Jai pa̱i huati quëꞌiohuaꞌi paꞌisicohuaꞌipi huatire eto sao cua̱ñohuë. Huatiohuaꞌipi etajë cuijë etahuë. Cuiꞌne jai pa̱i cuꞌimaꞌcohuaꞌije̱, cuiꞌne doꞌpëjë cuꞌicohuaꞌije̱ coꞌyasicohuaꞌi paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ja̱ yoꞌo doꞌire ja̱ daripë acohuaꞌi ai sihuahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ja̱ sihua hue̱ꞌñare teꞌi ë̱më Simón hueꞌequë ja̱ꞌnë dahuë paꞌisiquë pajiꞌi. Samaria pa̱ire care payeje̱ caquë jerepa paꞌi aꞌë caquë yoꞌosiquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ja̱je paꞌini siꞌaohuaꞌi aꞌricohuaꞌi maña cuiꞌne jaicohuaꞌina co̱ni i̱ caye asacaijë cahuë: “Iquë api, i̱repa Maijaꞌquë tuture paquërepa cahuë.” ");
INSERT INTO seyNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ja̱je cajë i̱te deꞌoye i̱ caye sehuocaëꞌë. Tsoe hue̱ꞌña noni i̱ dahuë ñañepi yoꞌoquë care payeje̱ caquëre sëte ja̱je sehuocaëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ja̱je yoꞌojë paꞌicohuaꞌipi Felipe quëayere asani Maijaꞌquë cua̱ñe te̱ꞌte ayere cuiꞌne Jesucristo ayere asani ë̱mëohuaꞌi cuiꞌne nomiohuaꞌi sehuohuë. Sehuoni oco do cua̱ñohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Do cua̱ñojëna, i̱ Simónque sehuoni oco do cua̱ñoni ai deꞌoyere pare pa̱i yoꞌo ti̱ꞌa maꞌñere ñaquë ai deꞌoyere paꞌni cuasaquë Felipe ja̱ꞌre teꞌe cuꞌi huëopi. ");
INSERT INTO seyNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Samaria pa̱ipi Maijaꞌquë coca sehuorena, Jesús doce soisicohuaꞌipi asani Jerusalén paꞌicohuaꞌipi Pedrore cuiꞌne Juanre jëjo saohuë, Samariana. ");
INSERT INTO seyNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Jëjo saorena, sani Samaria sehuosicohuaꞌire Maijaꞌquëre se̱cacaëꞌë, deꞌo joyore paja̱jë cajë. ");
INSERT INTO seyNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Jesús mai Ëjaë mamipi do cua̱ñosicohuaꞌitaꞌa ja̱ yëꞌtaꞌa deꞌo joyo peocohuaꞌi paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ja̱ doꞌire Pedro cuiꞌne Juanpi jë̱ñapi jëjo pajë Maijaꞌquëre se̱jëna, deꞌo joyore i̱si cua̱ñohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Jë̱ñapi Jesús jëjo saocohuaꞌipi jëjo pajë se̱jëna, Maijaꞌquë joyore i̱siña. I̱sina, ñani Simónpi curipi huerosiꞌi cuasaquë caëña. ");
INSERT INTO seyNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“I̱sijë̱ꞌë, ja̱ tuture pare yëꞌëje̱ i̱sina, ja̱ tutupi yëꞌëpi jë̱ñapi patoquë se̱ina, deꞌo joyore i̱si cua̱ñojaꞌcohuaꞌire.” ");
INSERT INTO seyNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Caquëna, Pedropi i̱te capi: “Mëꞌë curiquë ja̱ꞌre mëꞌë ne huesëye paꞌiji. Maijaꞌquë i̱siye curiquëpi hueroye peoji. ");
INSERT INTO seyNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Maijaꞌquë ña hue̱ꞌña mëꞌë nui joyo peoyë. Ja̱je paꞌina, ja̱ tutupi i̱si cua̱ñoñe peoji, mëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Mëꞌë coꞌaye cuasayere je̱ocojë̱ꞌë. Je̱oconi mai Ëjaëre se̱jëꞌë. Se̱ina, deꞌhue oni yejeꞌñe paꞌi api, mëꞌë ja̱je cuasaseꞌe. ");
INSERT INTO seyNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Yecohuaꞌipi deꞌoye yoꞌojëna, ñani sihuamaꞌë. Ñañepi mëꞌë ti̱mësiquëpi paꞌina, ñaquë cayë. Ja̱ doꞌire mëꞌë coꞌaye cuasayepi hue̱siquëre paji, mëꞌëre.” ");
INSERT INTO seyNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Caquëna, Simónpi capi: “Mësarupi yëꞌë doꞌire se̱cacaijë̱ꞌë, Ëjaëre. Siꞌaye mësaru caseꞌeje̱ paꞌye tëto saiye pa̱jaꞌcore yëꞌëre.” ");
INSERT INTO seyNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Iye aꞌë, maire caquë Jesús yoꞌoseꞌe cajë quëajë cuiꞌne Maijaꞌquë coca quëa tëjini Jesús jëjo saocohuaꞌipi Samaria yeja aꞌri daripë̱ana, deꞌo coca quëahuë. Quëa tëjini yuretaꞌa Jerusalénna coꞌihuë. ");
INSERT INTO seyNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ja̱ jeteyoꞌje mai Ëjaë hui̱ñaëpi Felipere capi: “Huëni Jerusalén maꞌana saijë̱ꞌë, Gazana sai maꞌana huëꞌehuë te̱ꞌtena.” Iye maꞌa cato cue̱nesi yejaja̱ꞌa sa sai maꞌa pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Caëna, asani Felipe huëni ja̱ maꞌajaꞌa sajiꞌi. Saiquëpi maꞌana Etiopia pa̱ire ti̱ꞌapi. Ja̱ë cato ëjaërepa pajiꞌi. Etiopia ëjao curi deꞌhuacaiquë pajiꞌi. Ja̱ëpi Jerusalénna Maijaꞌquëre se̱siꞌi caquë saisiquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ja̱je saisiquëpi i̱ yejana coꞌiquë caballopi quërëcore ñuꞌi sai Maijaꞌquëre quëacaiquë Isaías toyaseꞌere ñaquë sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Saina, joyopi Felipere capi: “Caballo quërëco quëꞌrona saijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Caëna, Felipe tsioja̱i asaquëna, Isaías toyaseꞌere ñaquë caquë sajiꞌi, Etiopia aquëpi. Ja̱ maca i̱te se̱jiꞌi: “¿Asaquë mëꞌë, mëꞌë ñaseꞌe?” ");
INSERT INTO seyNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Se̱ina, sehuopi: “¿Me asa ti̱ꞌañeꞌni, i̱ti quëaquëpi peoto?” Cani Felipere yëꞌë ja̱ꞌre mëni ñuꞌi saijë̱ꞌë caquë se̱jiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Toyasico i̱ ñasico cato ico pacoꞌë, ñeje caco: Huai hue̱ꞌñana yëi ñamare sayeje̱ paꞌye sahuë, i̱te. Sarena, tëacohuaꞌi ña hue̱ꞌñana yëi ñama memeñe pa̱ñeje paꞌye memeñe pa̱pi. ");
INSERT INTO seyNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Teaye paꞌi pajiꞌi. Ja̱je paꞌitaꞌare nuñerepa deꞌoye i̱te necaiye pa̱huë. Iye yeja paꞌiquëni i̱ paꞌiye naë tëa je̱oñere, ¿nepi cacaija̱ꞌcohuaꞌi aꞌni, i̱ tsëcapë? ");
INSERT INTO seyNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Etiopia aquëpi Felipere se̱jiꞌi: “Quëare pajë̱ꞌë, yëꞌëre. ¿Neni caquëꞌni, Maijaꞌquëre quëacaiquë i̱jaꞌa coꞌye caquë pa̱nitaꞌa yequëni caquë?” ");
INSERT INTO seyNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Caquëna, ja̱ maca Felipe Etiopia pa̱i ñasico acopi toyaseꞌe cayepi huëoni Jesús aye deꞌo coca quëapi, i̱te. ");
INSERT INTO seyNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Quëaquëna, oco quëꞌroja̱ꞌa sa sai Etiopia aquëpi capi: “¿I̱na oco i̱ñore paꞌiji, yëꞌëre doye deꞌomaꞌquë?” ");
INSERT INTO seyNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Caquëna, Felipepi capi: “Mëꞌëpi siꞌa joyorepa deꞌoye sehuoquë paꞌito doye deꞌoji.” Caquëna, i̱pi capi: “Jesucristo Maijaꞌquë mamaquë api asayë, yëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Caëna, ja̱ maca o̱mejani siꞌa jupë cayaohuaꞌi Felipe cuiꞌne Eunuco co̱ni oco quëꞌrona sa cajeni Felipepi oco dopi. ");
INSERT INTO seyNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Do tëjini tu̱masi maca mai Ëjaë joyopi Felipere sapi. Ti̱rona saëna, Etiopia aquë ti̱jupë ñamaꞌë pajiꞌi. Ja̱je paꞌiquëtaꞌare sihuaquë sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipe cato Azoto daripëre pajiꞌi. Paꞌi pa̱i ñape dari Maijaꞌquë coca quëaquë Cesarea daripëna ti̱ꞌapi. ");
INSERT INTO seyNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ja̱je yoꞌoye paꞌina, Saulopi Jesure sehuosicohuaꞌire huasiꞌi caquë yoꞌoquëpi Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaërepa quëꞌrona sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Sani i̱te se̱jiꞌi: Toyacaijë̱ꞌë, Damasco pa̱i tsiꞌsi huë̱ꞌñana, siꞌaye yëꞌëpi cacani coꞌequë Jesure sehuocohuaꞌire ë̱mëohuaꞌire cuiꞌne nomiohuaꞌireje̱ tse̱ani hue̱ni Jerusalénna dani coja̱ꞌquëre capi. Caquë se̱ina, toyacaquëna, sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sai je̱ꞌnërepa Damasco quë̱no macare paꞌina, maꞌtëmopi Saulona miañerepa juꞌapi, siꞌaëre cuasamaꞌtore papi. ");
INSERT INTO seyNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Juꞌaquëna, yejana ta̱ni yëꞌoseꞌe caquëna, asapi: “¿Saulo, Saulo, Me yoꞌoquë yëꞌëre jo̱sa yoꞌoquëꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Caquëna, Saulopi se̱jiꞌi: “¿Ëjaë, mëꞌë i̱queipi caquëꞌni?” Caquëna, yëꞌoseꞌe sehuopi: “Jesu aꞌë, yëꞌë. Mëꞌë sa̱ñope yoꞌoquë aꞌë. Tsoa tarapë jë̱jësë̱ ñaca quëꞌiopi duruhue̱quëre jëjo saojëna, hue̱quëpi tarapëna coꞌye ti̱toquë pani aꞌsi ju̱ꞌiquë api, mëꞌë cuiꞌne yoꞌoyë, hue̱quë yoꞌoyeje̱ paꞌye.” ");
INSERT INTO seyNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Caquëna, Saulopi quëquëni tsasiquë capi: “¿Yëꞌë Ëjaë, i̱quere yoꞌoja̱ꞌquë aꞌni, yëꞌë?” Caquëna, capi: “Huëni ja̱ daripëna cacajë̱ꞌë. Ja̱ropi mëꞌë yoꞌo ja̱ꞌñe quëaye paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Caquëna, Saulore co̱cohuaꞌije̱ asahuë. Asajëtaꞌa i̱ti caquëre ñamaꞌpë ai quëquëni camaꞌpë paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Paꞌijëna, Saulo yejapi huëni ñacoa sëtaquëtaꞌa ñamaꞌë pajiꞌi. Ja̱je ñamaꞌë paꞌina, i̱te co̱cohuaꞌipi jë̱tëna tse̱ajë Damascona sahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Sarena, toaso̱ muꞌseña ñamaꞌquëpi, a̱imaꞌquëpi, cuiꞌne u̱cumaꞌquëpi coa pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Paꞌina, Damasco daripëre teꞌi Jesure sehuosiquë pajiꞌi. I̱ mami cato Ananías hueꞌequë pajiꞌi. Paꞌina, ja̱ëna ca̱ni ñañeje paꞌyeja̱ꞌa mai Ëjaëpi ñaini capi: “¡Ananías!” Caquëna, capi: “Ëjaë, paꞌiyë.” ");
INSERT INTO seyNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Sehuoquëna, mai Ëjaëpi i̱te capi: “Huëijë̱ꞌë. Huëni saijë̱ꞌë, Nui maꞌa hueꞌyosi maꞌana. Sani ‘i̱ñore Saulo Tarso aquë paꞌiquë’ caquë se̱jëꞌë. Judas huëꞌena Maijaꞌquëni se̱i paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Paꞌiquëpi ca̱ni ñañeje paꞌyeja̱ꞌa ñapi. Teꞌi ë̱më Ananías hueꞌequëpi dani jë̱ñapi i̱te jëjo paquë ñajaꞌquë caquë se̱cacaina, Maijaꞌquëre.” ");
INSERT INTO seyNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Caquëna, asani Ananíaspi capi: “Ëjaë, iquëpi Jerusalén daripë paꞌicohuaꞌire, mëꞌëre sehuocohuaꞌire ai sa̱ñope coꞌaye yoꞌoji jai pa̱i cajëna, asahuë, yëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ja̱je paꞌipi yure i̱ñona dajiꞌi, Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaëohuaꞌi cua̱ñesi tutupi siꞌaohuaꞌire mëꞌëre se̱cohuaꞌire tse̱seni hue̱ni sasiꞌi caquë.” ");
INSERT INTO seyNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Caquëna, Ëjaëpi capi: “Ja̱je paꞌitaꞌare sani ñajëꞌë. Yëꞌëpi i̱te soihuë, yëꞌë cocare Israel pa̱ire quëacaiquë, cuiꞌne yequë pa̱ire quëacaiquë, cuiꞌne ëjaohuaꞌire quëacaiquë paꞌija̱quë caquë. ");
INSERT INTO seyNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Yëꞌë coca quëa doꞌire i̱pi ai yoꞌoye paꞌi ja̱ꞌñere i̱te i̱ñosiꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Caëna, Ananíaspi Saulo paꞌi huëꞌena sani cacani i̱ jë̱ñapi Saulore patoquë capi: “Saulo, yëꞌë yoꞌjei, Ëjaë Jesupi yëꞌëre maꞌajaꞌa mëꞌëre daina, ñasiquëpi jëjo daopi. Mëꞌëpi ñaquë paꞌija̱quë caquë, cuiꞌne Maijaꞌquë joyo quëꞌi paꞌija̱quë caquë.” ");
INSERT INTO seyNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ca macarepa ñacoa paꞌiseꞌepi soꞌcoje̱ paꞌyepi to̱mepi. To̱meina, deꞌoye ñaquë deꞌoni huëni oco do cua̱ñopi. ");
INSERT INTO seyNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Do cua̱ñosi jeteyoꞌje, a̱o a̱ni, tutu tsiꞌsoni, Damasco sehuosicohuaꞌi ja̱ꞌre pëani tsoe maca muꞌseña pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tutu tsiꞌsosiquëpi Israel pa̱i tsiꞌsi hue̱ꞌñana Jesucristo Maijaꞌquë mamaquë api, quëa huëopi. ");
INSERT INTO seyNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Quëaquëna, siꞌa asacohuaꞌipi ai cuasajë coꞌa ju̱ꞌijë cahuë: “Iquëpi Jerusalén paꞌicohuaꞌire hue̱ni Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaohuaꞌina sani i̱sisiꞌi caquë daisiquë api.” ");
INSERT INTO seyNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ja̱je catoje̱ Saulopi ai jerepa nuñerepa capi, Jesús cocare caꞌraye peoyerepa. Caꞌramaꞌë quëaquë capi, Cristo api, mai huasoquërepa. Ja̱je quëaquëna, Israel pa̱i Damasco acohuaꞌipi asajë ai cuasahuë, ¿merepa neni ja̱ jerepa caquëꞌni? cajë. ");
INSERT INTO seyNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ai tsoe muꞌseña quëaquë paꞌina, ñani Israel pa̱ipi Saulore huani je̱oñuꞌu cuasahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Cuasani yoꞌojëna, Saulo deꞌhue asapi, i̱ohuaꞌi yoꞌoye huañuꞌu cajë siꞌa muꞌseñapi, cuiꞌne ñamiñapi daripë eta saꞌnoa ñape utehuë, Saulote. ");
INSERT INTO seyNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Utejë paꞌina, Jesure sehuosicohuaꞌipi ñami jai doꞌrohuëna Saulote ayani jai daripë tëhuopaja̱ꞌa meñe casahuë. Casarena, deꞌhue catipi. Ja̱je jëapi, deꞌhue. ");
INSERT INTO seyNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Deꞌhue jëasiquëpi Jerusalénna Saulopi ti̱ꞌani Jesure yeꞌyecohuaꞌi ja̱ꞌre co̱ni pasiꞌi caquë yoꞌoquëna, ja̱ohuaꞌipi sehuomaꞌquë api cuasajë i̱te caꞌrahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Caꞌrajëna, Bernabépi Saulore Jesús jëjo saocohuaꞌi quëꞌrona dani i̱ñoquë quëapi, i̱te yoꞌoseꞌere ñeje: Iquë Damasco maꞌana mai Ëjaëre pare ñasiquë api. Mai Ëjaëre papi i̱te coca caquëna asasiquë api, cuiꞌne Damasco daripëna caꞌraye peoyerepa quëcoquë Jesús coca deꞌoye quëasiquë api, capi Bernabé. ");
INSERT INTO seyNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ja̱je quëaquëna, “deꞌoji,” careña. Saulo Jerusalénna pëapi. Pëani i̱ohuaꞌi ja̱ꞌre cuꞌi yoꞌoquë Jesús cocare caꞌraye peoyerepa quëapi. ");
INSERT INTO seyNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Israel pa̱itaꞌa griego cocapi cacohuaꞌire coca caquë cuiꞌne sa̱ñope cajëna, i̱je sa̱ñope caquë yoꞌopi. Quëaquëna, ja̱ohuaꞌipi i̱te huañuꞌu cajë yoꞌohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Yoꞌojëna, sehuosicohuaꞌipi asani Cesareana sahuë, i̱te. Ja̱ropi yuretaꞌa Tarso yejana jëjo saohuë, Saulore. ");
INSERT INTO seyNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ja̱ maca siꞌaohuaꞌi sehuosicohuaꞌi Judea yeja paꞌicohuaꞌi, Galilea yeja paꞌicohuaꞌi cuiꞌne Samaria yeja paꞌicohuaꞌi sa̱ñope yoꞌoye je̱orena, deꞌoye paꞌi huëohuë. Paꞌijë joyo paꞌiye ai tutu quëꞌiohuaꞌi deꞌohuë. Deꞌojë Maijaꞌquë yëyere deꞌoye sehuocaijë paëꞌë. Paꞌijëna, deꞌo joyopi co̱caina, siꞌa muꞌseñajaꞌa sehuocohuaꞌije̱ paꞌijë jai saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pedropi sehuosicohuaꞌire doꞌi ñasiꞌi caquë saisiquëpi Lida paꞌicohuaꞌireje̱ sehuosicohuaꞌire ñasiꞌi caquë sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Saisiquëpi ñaquëna, Ja̱rote teꞌi ë̱më Eneas i̱ mami hueꞌequëpi, ocho o̱metëca u̱iquë pajiꞌi, ti cuꞌimaꞌquëpi. ");
INSERT INTO seyNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Paꞌina, Pedro ñani i̱te capi: “Eneas, Jesucristopi mëꞌëre ne coꞌyaji, huëni më ca̱iñe deꞌhuajë̱ꞌë.” Ca macarepa huëjiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Huëina, ñasicohuaꞌipi Lida acohuaꞌipi cuiꞌne Sarón acohuaꞌipi Ëjaë Jesucristore sehuohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ja̱ muꞌseña Jope daripëre teꞌo nomio sehuosico pacoꞌë. I̱o mami cato Tabita hueꞌecopi, griego coca cato Dorcas caye paꞌiji. Ja̱o cato peocohuaꞌire deꞌoye co̱caico pacoꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ja̱je paꞌiopi ju̱ꞌi huëoni ju̱coꞌë. Ju̱cona, i̱o ca̱ꞌnihuë tsoani ë̱mëjeꞌe tuꞌrihuëna o̱ahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","O̲ani Pedrore esa Jopena daijë̱ꞌë, tsoe nëiñe peoyerepa cajë huëoja̱ꞌcohuaꞌire cayaohuaꞌire jëjo saohuë, sehuosicohuaꞌipi. Jope cato Lida quë̱no macare paꞌiye sëte. Ja̱je yoꞌohuë, Pedropi Lidare paꞌiji asani. ");
INSERT INTO seyNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Sani huëojëna, Pedropi i̱ohuaꞌi ja̱ꞌre co̱ni sajiꞌi. Sa ti̱ꞌasi maca ju̱ꞌisico u̱i hue̱ꞌñana ë̱mëjeꞌe tuꞌrihuëna i̱te sahuë. Sasi maca siꞌa huaꞌjeohuaꞌi oijë i̱o necaisi ca̱ñare i̱te i̱ñohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ja̱ maca Pedropi siꞌaohuaꞌire eto saoni doꞌre jaꞌruni Maijaꞌquëre se̱jiꞌi. Se̱si jeteyoꞌje ju̱ꞌisicore ñaquë capi: “Tabita huëijë̱ꞌë.” Caquëna, sëtani i̱te ñani huëni jaꞌruo. ");
INSERT INTO seyNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Jaꞌruona, Pedropi i̱o jë̱tëna tse̱ani huëo nëcopi. Huëo nëconi sehuosicohuaꞌire cuiꞌne huaꞌjeohuaꞌire soini huajëco paꞌico yure caquë i̱ñopi. ");
INSERT INTO seyNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Iye yoꞌoseꞌere siꞌa Jope daripë paꞌicohuaꞌi asahuë. Asani jai pa̱i Ëjaëre sehuohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Iye yoꞌosiquëpi Pedro Jope daripëna pëapi. Pëani tsoe muꞌseña maña Simón huëꞌena, ca̱ꞌni deꞌhuaquë huëꞌena. ");
INSERT INTO seyNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Cesarea daripëre teꞌi ë̱më Cornelio hueꞌyosiquë pajiꞌi, cien soldado pa̱i ëjaë. Capitán pajiꞌi. I̱ Cien soldado tsëcapë aquë mami cato Italiano hueꞌyosico pacoꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ja̱ë cato deꞌoquë pajiꞌi, Maijaꞌquëre caꞌraquëpi. Ja̱je paꞌipi siꞌa i̱ huëꞌe acohuaꞌi ja̱ꞌre Maijaꞌquëre se̱i paꞌiquë pajiꞌi. Ja̱je paꞌipi peocohuaꞌire deꞌoye i̱sipi, co̱casiꞌi caquë judío pa̱ire, cuiꞌne siꞌa muꞌseña Maijaꞌquëre se̱i pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Paꞌipi teꞌe muꞌse naꞌiquëna, tres paꞌi maca ca̱ni ñañeje paꞌye ñaquëna, Maijaꞌquë jëjo daoquë hui̱ñaëpi i̱ huëꞌena cacapi. Cacaquëna, ti̱ñarepa i̱te ñapi. Ñaquëna, capi: “¡Cornelio!” ");
INSERT INTO seyNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Caquëna, i̱ni ñaquë quëquëni se̱jiꞌi, i̱te: “Ëjaë, ¿I̱quere yëquëꞌni?” Caquëna, hui̱ñaëpi capi: “Mëꞌë se̱ñe Maijaꞌquë asaji, cuiꞌne mëꞌë peocohuaꞌire deꞌhue co̱cai yoꞌoyeje̱ ñaji, Maijaꞌquë capi, ja̱je paꞌiye sëte. ");
INSERT INTO seyNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Yure ë̱mëohuaꞌire Jopena jëjo saojë̱ꞌë, Simón Pedro hueꞌyosiquëre quërëja̱ijaꞌcohuaꞌire. Pedro cato yequë Simón huëꞌere pëasiquëpi paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Yequë Simón ca̱ꞌni deꞌhuaquë huëꞌere paꞌiji. Ja̱ huëꞌe cato jaira të̱ꞌtëpare paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","8","Maijaꞌquë jëjo daosiquëpi saisi maca Corneliopi i̱te necaicohuaꞌire cayaohuaꞌire cuiꞌne teꞌe soldadore soini i̱ ñaseꞌe siꞌaye quëani Jopena jëjo saopi. Soldado cato Maijaꞌquëre cuasaquë pajiꞌi. Ja̱je paꞌini Cornelioje̱ deꞌoye cuasaquë pajiꞌi. Ja̱je paꞌini Cornelioje̱ deꞌoye cuasaquë jëjo saopi. ");
INSERT INTO seyNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Jëjo saouna, se ñatasi muꞌse ja̱ yëꞌtaꞌa maꞌare saijë je̱ꞌnë Jope quë̱no macare paꞌijëna, jopo muꞌserepa paꞌi maca Pedropi huëꞌe ë̱mëjeꞌe totona mëjiꞌi, Maijaꞌquëre se̱siꞌi caquë. ");
INSERT INTO seyNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ja̱ yëꞌtaꞌa a̱ore cuaꞌcojëna, a̱o ëaye nëi macapi ca̱ni ñañeje paꞌye ñapi. ");
INSERT INTO seyNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ñaquëna, maꞌtëmopi huiꞌyoni jai ca̱ ca̱ꞌtipëje̱ paꞌiona, cajeseꞌe si̱ca que̱ꞌquesicona, ");
INSERT INTO seyNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","siꞌa nëicohuaꞌire, u̱ijë cuꞌicohuaꞌire cuiꞌne jaꞌjëcohuaꞌire ayasi tuꞌupi yejare pana cajeo. ");
INSERT INTO seyNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Caje maca yëꞌoseꞌe i̱te jutapi ñeje: “Pedro, huëni huani a̱ijëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Caquëna, Pedropi sa̱ñope capi: “Pa̱siꞌi, Ëjaë. A̲i maꞌñe aꞌë. Siꞌsi aꞌë. Siꞌsiohuaꞌire yëꞌë ti a̱imaꞌquë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Caquëna, ti̱jupë yëꞌoseꞌe i̱te jutaëña: “Maijaꞌquë siꞌsi peoye neseꞌere siꞌsi aꞌë caye peoji.” ");
INSERT INTO seyNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ja̱je toaso̱ñe paꞌye Maijaꞌquë i̱te ca tëjini coꞌamaña ayasi tuꞌure maꞌtëmona mëa huesopi. ");
INSERT INTO seyNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Mëa huesouna, Pedro ¿merepa yoꞌo ja̱ꞌñere ja̱je paꞌye i̱ño uꞌni? caquë ai cuasaquë pajiꞌi. Paꞌina, Cornelio jëjo saosicohuaꞌipi ja̱to saꞌro quëꞌrona ti̱tahuë, ¿Simón huëꞌe jerore paꞌicoꞌni? cajë se̱ni asajë daicohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ja̱ohuaꞌi ti̱tani tutu cajë se̱iꞌë: I̱ño Simón hueꞌequëpi cuiꞌne yequë mami Pedro hueꞌequë paꞌimaꞌquë cajë se̱iꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ja̱je se̱ni asajëna, Pedro cato ja̱ yëꞌtaꞌa i̱ ñaseꞌere cuasaquë pajiꞌi. Paꞌina, deꞌo joyopi capi, i̱te: “I̱na, mëꞌëni toaso̱ ë̱mëohuaꞌi coꞌeroja̱iñë. ");
INSERT INTO seyNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Huëni i̱ohuaꞌi ja̱ꞌre saijë̱ꞌë, jëa coeye peoyerepa. Yëꞌë jëjo daosicohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Caëna, Pedro cajeni capi: “Yëꞌë aꞌë, mësaru coꞌequë. ¿I̱quena dateꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Caquëna, i̱ohuaꞌipi cahuë: “Yëquë cato Cornelio jëjo daocohuaꞌipi daëꞌë. Maijaꞌquë hui̱ñaëpi mëꞌëni soija̱tena. Cornelio huëꞌena dani quëaquëna, i̱pi mëꞌë quëaye asaja̱quë caëna, asani Cornelio, soldado pa̱i ëjaëpi jëjo daoquëna, daëꞌë. Nuñe paꞌiquëpi, Maijaꞌquëre se̱quëpi, cuiꞌne siꞌa judío pa̱i deꞌoye yoꞌoquë api cajë oiquëpi jëjo daocohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Cajëna, Pedropi capi: “Cacani pëajë̱ꞌë.” Caëna, cacani i̱ ja̱ꞌre co̱ni pëahuë, ja̱ ñami. Ñatasi muꞌse Pedropi i̱ohuaꞌi ja̱ꞌre co̱ni sajiꞌi. Saina, i̱te co̱ñuꞌu cajë Jope acohuaꞌije̱ i̱ ja̱ꞌre saëꞌë, Maijaꞌquëre sehuosicohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ja̱je saisicohuaꞌipi se ñatasi muꞌse Cesareana ti̱ꞌahuë, Cornelio cuiꞌne i̱ tsëcapë cuiꞌne i̱ ai oi cajeohuaꞌi co̱ni tsiꞌsini ute hue̱ꞌñana. Ja̱ohuaꞌi cato Cornelio huëosicohuaꞌipi daisicohuaꞌipi paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Paꞌijëna, Pedropi huëꞌena ti̱ꞌaquëna, Corneliopi pëpasiꞌi caquë etaquëpi Pedrote yëꞌë ëjaërepa caquë doꞌre jaꞌruëña. ");
INSERT INTO seyNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Jaꞌruquëna, Pedropi i̱te naë huëo nëcoquë capi: “Yëꞌëje̱ mëꞌëje paꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ja̱je i̱ ja̱ꞌre caquë sa cacaquë ñaquëna, jai pa̱i tsiꞌsicohuaꞌipi paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Paꞌijëna, ñani Pedropi capi: “Mësarupi asacohuaꞌi aꞌë, Israel pa̱i ti ti̱ pa̱i ja̱ꞌre tsioye peoye. Pa̱nitaꞌa yequë pa̱i huëꞌena cacaye peoye. Israel pa̱i yoꞌoye ja̱je paꞌiji. Ja̱je paꞌiquëtaꞌare yëꞌëre Maijaꞌquëpi yeꞌyapi pa̱ire coꞌacohuaꞌi aꞌë, siꞌsiohuaꞌi aꞌë caye pa̱jëꞌë caquë. ");
INSERT INTO seyNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ja̱je paꞌina, ja̱ohuaꞌi sani yëꞌëre se̱jëna, ai cuasaye peoyerepa esa daëꞌë. Deꞌoji. Yuretaꞌa quëajë̱ꞌë. ¿I̱quere cajë yëꞌëre soireꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Caquëna, Corneliopi capi: “Paꞌiji, cuatro muꞌseña, iye jaꞌi maca naꞌiquëna, tres paꞌi maca yëꞌë huëꞌere paꞌi a̱o a̱imaꞌquëpi Maijaꞌquëre se̱i paꞌiseꞌe. Paꞌiquëpi naꞌiquëna, Maijaꞌquëre se̱ñere se̱ina, Maijaꞌquë jëjo daoquëpi ai mia juꞌi ca̱repa juꞌiquëpi ñaini capi: ");
INSERT INTO seyNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‘Cornelio, mëꞌë Maijaꞌquëre se̱ñe Maijaꞌquë asaji, cuiꞌne mëꞌë peocohuaꞌire co̱caiyeje̱ Maijaꞌquë ñaquë sihuaji deꞌoyerepa yoꞌoji caquë ñaji. ");
INSERT INTO seyNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ja̱je paꞌiye sëte yurepi ë̱mëohuaꞌire Jopena jëjo saojë̱ꞌë, Simón Pedro hueꞌequëre quërëja̱ni i̱ñona daja̱ꞌcohuaꞌire. I̱ cato yequë Simón huëꞌere paꞌiji, ja̱ë yequë Simón cato ca̱ꞌnipi deꞌhuaquë api. I̱ huëꞌe cato jaira të̱ꞌtëpare paꞌiji,’ capi, yëꞌëre. ");
INSERT INTO seyNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Caëna, asani esa mëꞌëre quërëja̱ijaꞌcohuaꞌire jëjo saohuë. Ja̱je jëjo saouna, yure mëꞌëpi daquëna, deꞌoji. Maijaꞌquë coca asañuꞌu cajë yëquë tsiꞌsisicohuaꞌipi paꞌiyë, mëꞌëre mai Ëjaërepa cajë̱ꞌë caquë i̱siyere caquëna, asañuꞌu, yëquë.” ");
INSERT INTO seyNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Caquëna, Pedropi quëapi: “Yuretaꞌa asayë, Maijaꞌquëpi pa̱ire cuiꞌne paꞌiohuaꞌiseꞌere ñaquë paꞌiye. ");
INSERT INTO seyNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ja̱je paꞌina, Maijaꞌquë cato siꞌa pa̱ire i̱te deꞌoquëre paꞌni cacohuaꞌire cuiꞌne nuñerepa yoꞌocohuaꞌire deꞌoji caquë ñaji, coa siꞌa tsëca acohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ja̱je paꞌina, siꞌaohuaꞌi Ëjaë Jesucristoja̱ꞌa deꞌoye paꞌiye ti̱ꞌañere, Maijaꞌquë i̱ coca Israel pa̱ina i̱sipi. ");
INSERT INTO seyNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mësarupi siꞌaohuaꞌi asayë, Juan oco doquë cuiꞌne quëaquë yoꞌosi jeteyoꞌje Jesupi Galileapi huëoni siꞌa hue̱ꞌña judío pa̱i paꞌi hue̱ꞌña yoꞌoseꞌe cuꞌiseꞌe. ");
INSERT INTO seyNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ja̱je paꞌina, Maijaꞌquëpi Jesús Nazaret aquëre deꞌo joyo tuture i̱sipi. I̱sina, huati tutupi yoꞌoquëna, ai yoꞌojë paꞌicohuaꞌire jujucai cuiꞌne pa̱ire deꞌoye yoꞌocai cujiꞌi, Maijaꞌquëpi i̱ ja̱ꞌre paꞌi doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ja̱je yoꞌoquëna, yëquë ñasicohuaꞌi aꞌë, Jesús yoꞌoye. Jerusalénna cuiꞌne Judea yejana yoꞌoquëna, ñasicohuaꞌi aꞌë. Ja̱ jeteyoꞌje yuretaꞌa i̱te so̱quë sarahuana que̱ deoni huani je̱ohuë, judío pa̱ipi. ");
INSERT INTO seyNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ja̱je huaisiquëtaꞌa toaso̱ muꞌseña paꞌi maca Maijaꞌquëpi huajëquëre huëopi. Huëoni yëquëre i̱ñopi. ");
INSERT INTO seyNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Coa yëquëseꞌere ñai i̱ñopi. Siꞌa pa̱ire ñai i̱ñoñe pa̱pi. Yëquë i̱ tsoe sahua nëosicohuaꞌiseꞌere ñai i̱ñopi. Ja̱je paꞌina, yëquë i̱ ja̱ꞌre co̱ni u̱cujë cuiꞌne a̱ijë yoꞌohuë, i̱ huëisi jeteyoꞌje. ");
INSERT INTO seyNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ja̱re ja̱ëni Maijaꞌquëpi ju̱ꞌisicohuaꞌire cuiꞌne huajëcohuaꞌire ñani ca tëjiquëre nepi cajë quëaja̱ꞌcohuaꞌini yëquëre jëjo daopi. ");
INSERT INTO seyNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ja̱je paꞌina, tsoe Maijaꞌquëre quëacaicohuaꞌi Jesús ayere cajë cahuë, i̱te Jesure sehuocohuaꞌipi i̱ohuaꞌi coꞌaye yoꞌoseꞌere sa̱i deꞌhuani oni yeje cua̱ñojaꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ja̱ yëꞌtaꞌa Pedro caquëna, deꞌo joyopi i̱ caye asacohuaꞌina tsio dajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Tsio daquëna, Israel pa̱i sehuoye sehuocohuaꞌipi Pedro ja̱ꞌre daisicohuaꞌipi ai cuasajë ñahuë, Israel pa̱i peocohuaꞌipi deꞌo joyore i̱si cua̱ñojë, ");
INSERT INTO seyNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","yequë pa̱i cocapi cajë cuiꞌne Maijaꞌquëre deꞌoquëre paꞌni cajë yoꞌojëna. ");
INSERT INTO seyNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ja̱je ai cuasajëna, Pedropi capi: “Icohuaꞌire oco doye deꞌoji, mai i̱si cua̱ñoseꞌeje̱ paꞌye deꞌo joyore i̱si cua̱ñosicohuaꞌire.” ");
INSERT INTO seyNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Cani i̱ohuaꞌire Jesucristo mamipi do cua̱ñoñe paꞌiji cani docajiꞌi. Ja̱ jeteyoꞌje i̱ohuaꞌipi Pedrore cahuë, yëquë ja̱ꞌre tsoe muꞌseña maña pëani paꞌijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Israel pa̱i tsëca peocohuaꞌipi Maijaꞌquë coca deꞌoyerepa sehuoseꞌere Jesús jëjo saocohuaꞌipi cuiꞌne yëquë sehuocohuaꞌipi asahuë, Judea paꞌicohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Asani Pedropi Jerusalénna coꞌina, Israel pa̱i sehuoye sehuocohuaꞌipi i̱ yoꞌoseꞌere sa̱ñope cahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Cajë i̱te se̱iꞌë: “¿Me yoꞌoquë Israel pa̱i peocohuaꞌi huëꞌena cacani i̱ohuaꞌi ja̱ꞌre co̱ni a̱i yoꞌo uꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Cajëna, Pedropi siꞌaye i̱te duꞌru macarepa huëoni yoꞌoseꞌeje̱ paꞌye ja̱ohuaꞌire quëapi: ");
INSERT INTO seyNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Jope daripëre paꞌi Maijaꞌquëre se̱i ca̱ni ñañeje paꞌye ñahuë. Ñaquëna, maꞌtëmopi jai ca̱ꞌtipëje̱ paꞌiona, ayasi tuꞌure cajeseꞌe si̱capë̱a que̱ꞌquesicona, yëꞌë quëꞌrona casaëna, ñahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ayasi tuꞌure ñaquëna, siꞌaohuaꞌi nëicohuaꞌi, a̱ñaje paꞌiohuaꞌi coti saihuëpi cuꞌicohuaꞌi, cuiꞌne jaꞌjëcohuaꞌi paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Paꞌijëna, yëꞌëre yëꞌoseꞌe jutapi: ‘Pedro huëijë̱ꞌë. Huëni huani a̱ijëꞌë,’ capi. ");
INSERT INTO seyNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Caquëna, cahuë: ‘Pa̱siꞌi, Ëjaë. A̲i maꞌñe aꞌë. Siꞌsi aꞌë. Siꞌsiohuaꞌire yëꞌë ti a̱imaꞌquë aꞌë,’ cahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Caquëna, ti̱jupë yëꞌoseꞌe yëꞌëre juta co̱pi: ‘Maijaꞌquë tsoa to̱seꞌere siꞌsi aꞌë camaꞌë paꞌijë̱ꞌë,’ capi. ");
INSERT INTO seyNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ja̱je toaso̱ñe Maijaꞌquë cuiꞌne paꞌye capi. Ca tëjina, ayasi tuꞌupi maꞌtëmona mëni huesëo. ");
INSERT INTO seyNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ja̱ macarepa toaso̱ ë̱mëohuaꞌi Cesarea yejapi jëjo daosicohuaꞌipi yëꞌëre coꞌecohuaꞌipi yëꞌë paꞌi huëꞌena ti̱tahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ti̱tarena, Maijaꞌquë joyopi yëꞌëre cua̱ñepi: ‘I̱ohuaꞌi ja̱ꞌre co̱ni saijë̱ꞌë,’ caquë ‘ai cuasamaꞌë,’ capi. Caëna, asani saëꞌë, icohuaꞌi seis sehuosicohuaꞌi ja̱ꞌre co̱ni. Sani siꞌaohuaꞌi paꞌi huëꞌena cacahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Cacarena, Maijaꞌquë jëjo daoquëre i̱ huëꞌena ñaseꞌere cuiꞌne ñaquëna, i̱ caseꞌere quëapi. Jopena mëꞌë joꞌyare jëjo saojë̱ꞌë, Simón Pedro hueꞌequëre daja̱ꞌcohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ja̱ëpi dani huaso coca quëaquëna, asani mëꞌë cuiꞌne më tsëcapë huasosicohuaꞌi paꞌija̱ꞌcohuaꞌi aꞌë capi, quëapi. ");
INSERT INTO seyNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Quëaquëna, asani yëꞌëpi cocare quëa huëoquëna, deꞌo joyopi i̱ohuaꞌina dajiꞌi, maire duꞌru macarepa daiseꞌeje̱ paꞌye. ");
INSERT INTO seyNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ja̱ maca mai Ëjaërepa caseꞌere cuasahuë, ‘Juan cato ocopi dopi. Ja̱je paꞌiquëtaꞌare mësaru cato deꞌo joyore i̱si cua̱ñojaꞌcohuaꞌi aꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ja̱je paꞌina, Maijaꞌquëpi maire Ëjaë Jesucristore sehuocohuaꞌire i̱siseꞌeje̱ paꞌye i̱siru, ¿me sa̱ñope Maijaꞌquë yoꞌo maꞌñe aꞌë cayeꞌni?” Capi, Pedro. ");
INSERT INTO seyNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Caquëna, asani Jerusalén acohuaꞌi sehuosicohuaꞌipi sa̱ñope caye je̱oni Maijaꞌquë ai deꞌoyerepa yoꞌoji, cajë cahuë: “Ja̱je yoꞌoquë judío pa̱i peocohuaꞌire i̱siji, i̱te sehuoni ti pani huesëye ti̱ꞌañe.” ");
INSERT INTO seyNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Estebanre huani je̱osi jeteyoꞌje Jesure sehuocohuaꞌire jo̱sa yoꞌo huëohuë. Jo̱sa yoꞌo huëorena, yecohuaꞌipi Feniciana, Chipre saodohuëna, cuiꞌne Antioquía daripëna cati saëꞌë. Saisicohuaꞌipi ja̱rona Israel pa̱iseꞌere Maijaꞌquë coca quëahuë. Yequë pa̱iretaꞌa quëaye pa̱huë. ");
INSERT INTO seyNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pa̱jëtaꞌare Chipre cuiꞌne Cirene quëꞌro acohuaꞌi sehuosicohuaꞌipi Antioquía daripëna ti̱ꞌani griego pa̱ire mai Ëjaë Jesús deꞌo cocare quëahuë, judío pa̱i peocohuaꞌina. ");
INSERT INTO seyNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Mai Ëjaë i̱ohuaꞌi ja̱ꞌre co̱ni paꞌina, deꞌoye quëajëna, jai pa̱i ja̱ꞌnë i̱tire paꞌë cuasaseꞌe je̱oni Ëjaë Jesuna sehuohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ja̱je yoꞌojëna, sehuosicohuaꞌi Jerusalén paꞌicohuaꞌipi asani Bernabére Antioquía daripëna jëjo saohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Jëjo saorena, Bernabépi ti̱ꞌani Maijaꞌquëre sehuosicohuaꞌire Maijaꞌquë deꞌoye yoꞌocaiyere ñapi. Ñani ai sihuapi. Sihuaquë Bernabé yëhuopi, deꞌoyerepa. Ti je̱omaꞌpë tuijë mai Ëjaërepa caseꞌeje̱, caquë yëhuopi. ");
INSERT INTO seyNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bernabé cato ai deꞌoquë pajiꞌi. Maijaꞌquëre ai cuasaquëpi cuiꞌne deꞌo joyo ti̱mësiquëpi pajiꞌi. Ja̱je paꞌipi yëhuoquëna, asani jai pa̱i sehuohuë, mai Ëjaë caseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ja̱ jeteyoꞌje Bernabépi Saulore coꞌesiꞌi caquë Tarso daripëna sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Sani ti̱ꞌani i̱te Antioquía daripëna sapi. Sani ja̱rona teꞌe o̱metëcahuë pëahuë, sehuosicohuaꞌi ja̱ꞌre co̱ni. Pëani paꞌijë jai pa̱ire yeꞌyahuë. Ja̱rona Antioquía daripëna duꞌru macarepa Cristiano hueꞌyohuë, sehuosicohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ja̱ muꞌseña Antioquíana ti̱tahuë, Maijaꞌquëre quëacaicohuaꞌipi Jerusalén daicohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ti̱tasicohuaꞌi aquëpi Agabo hueꞌequëpi nëcaquë capi, deꞌo joyopi quëaquëna, yequë muꞌseña paꞌi ja̱ꞌñere. Yequë muꞌseña siꞌa hue̱ꞌña a̱iñe peoquëna, pa̱i a̱i ëa ju̱ꞌijaꞌcohuaꞌi aꞌë. Ja̱je tëto sajiꞌi, Claudio César pa̱i ëjaërepa paꞌi maca. ");
INSERT INTO seyNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ja̱je caëna, asani Antioquía sehuosicohuaꞌipi Judea sehuosicohuaꞌire co̱cai ja̱ꞌñere i̱sini jëjo saoñuꞌu cahuë, pa̱i ñape cuasaye jaꞌye. ");
INSERT INTO seyNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Cani i̱sini yuretaꞌa i̱ti i̱siseꞌere jëjo saohuë, Bernabé cuiꞌne Saulo ja̱ꞌre sehuosicohuaꞌi aiohuaꞌina Judeana. ");
INSERT INTO seyNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ja̱ muꞌseña pa̱i ëjaë Herodespi sehuosicohuaꞌi acohuaꞌire jo̱sa yoꞌoquë, ");
INSERT INTO seyNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Santiagore huaꞌtipi huani je̱ojëꞌë cua̱ñeina, huani je̱ohuë, Juan majaꞌyëre. ");
INSERT INTO seyNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Yoꞌorena, judío pa̱ipi ñani sihuajëna, Herodespi Pedroreje̱ tse̱ani copi, sihuaja̱ꞌcohuaꞌi aꞌë caquë. Iye cato yoꞌopi, levadura ne maꞌñe pan a̱ijë tsiꞌsi maca. ");
INSERT INTO seyNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ja̱je yoꞌoquë Pedrore tse̱ani co hue̱ꞌñana copi, cuatro tsëca soldado pa̱i ñajë nëca hue̱ꞌñana, teꞌe tsëcapëre cuatro paꞌiohuaꞌi paꞌi hue̱ꞌñana. I̱ cato Egíptopi Maijaꞌquë Israel pa̱ire etoquë paꞌiseꞌere cuasajë, tsiꞌsi tëjisi maca tse̱asiquëre etoni pa̱ire i̱ñosiꞌi cuasaquë yoꞌopi. ");
INSERT INTO seyNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ja̱je paꞌina, Pedro cato tse̱a cua̱ñosiquëpi pajiꞌi, etamaꞌquë cajë ña hue̱ꞌñare. Ja̱je paꞌitoje̱ sehuosicohuaꞌi cato Maijaꞌquëni se̱jë paëꞌë, siꞌa joyorepa cuasajë Pedroni cajë. ");
INSERT INTO seyNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herodes ñaminaꞌa Pedrore etoni pa̱ire i̱ñosiꞌi cuasaquëna, Pedro cato huëore ca̱jiꞌi, caya soldado pa̱ina quë̱na mepi se sëasiquëpi jopore pare u̱i. Ca̱ina, yequë soldado pa̱ipi pa̱ire co huëꞌe eta saꞌrore etamaꞌquë cajë ñajë nëcahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ja̱je paꞌi macarepa mai Ëjaë hui̱ñaë siꞌa co tuꞌrihuë mia merepa ñai nëcapi. Ja̱ maca Pedrore pato sëtoni capi: “Esa huëijë̱ꞌë.” Caquëna, jë̱ña hue̱seꞌe paꞌiseꞌe joye to̱mepi. ");
INSERT INTO seyNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ja̱ maca Ëjaë jëjo daoquëpi capi: “Mëꞌë ca̱ña su̱ñajëꞌë, cuiꞌne zapatoje̱ su̱ñajëꞌë.” Caquëna, yoꞌoquëna, cuiꞌne yequeje̱ capi: “Mëꞌë dëi juꞌi ca̱je su̱ñani yëꞌë ja̱ꞌre daijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Caëna, mai Ëjaë jëjo daoquë jeteyoꞌje dani etapi, coa huesërepa. Mai Ëjaë jëjo daoquëpi yoꞌoji, cuasamaꞌë pajiꞌi, coa ca̱ni ñañë cuasaquëpi. ");
INSERT INTO seyNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Cuasaquëtaꞌa duꞌru nëcajë ñacohuaꞌire sa tëto sani cayaye acohuaꞌire sa tëto sani yuretaꞌa maꞌana eta hue̱ꞌñarepa acore ti̱ꞌarena, i̱oseꞌe huiꞌyo eta saꞌro huiꞌyona, etani maꞌajaꞌa teꞌe saëꞌë. Ja̱je co̱ni saiquëpi mai Ëjaë jëjo daoquëpi peo hue̱ꞌña sajiꞌi, teꞌire je̱oni. ");
INSERT INTO seyNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Je̱o saquëna, yuretaꞌa Pedropi capi: “Yuretaꞌa asayë, Herodes ñaminaꞌa yëꞌëre yoꞌo ja̱ꞌñere cuiꞌne Israel pa̱i yëꞌëre yoꞌoye yëyere Ëjaëpi asani i̱ hui̱ñaëre huasoja̱ꞌquëre jëjo daopi.” ");
INSERT INTO seyNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ja̱je yoꞌou cuasani Pedropi sajiꞌi, Juan pëca jaꞌco María huëꞌena Juanpi yequë mamije Marcos hueꞌequë pëca jaꞌco quëꞌrona. Ja̱rote jai pa̱i tsiꞌsicohuaꞌipi paëꞌë, Maijaꞌquëni se̱jë. ");
INSERT INTO seyNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Paꞌijëna, Pedropi maꞌa eta saꞌrona ti̱ꞌani tëꞌcapi, soiquë. Soiquëna, asani teꞌo nomi tsi̱o Rode i̱o mami hueꞌecopi ¿nepi soiyeꞌni? cuasani sani ñasiꞌi caco eta saꞌro quëꞌrona dacoꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Dani Pedro yëꞌore asani sihuaco eta saꞌro huiꞌyocaimaꞌo coꞌye huëꞌhuë cacao, Pedropi eta saꞌrore paꞌiji quëasiꞌi caco. ");
INSERT INTO seyNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Quëacona, i̱ohuaꞌipi i̱ote cahuë: “Cuepeco, caco.” Cajëna, cao: “Nuñerepa cayë.” Cacona: “Pedrore ñacaiquë maꞌtëmo aquë paꞌini.” ");
INSERT INTO seyNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Cajëna, ja̱ yëꞌtaꞌa Pedropi tëꞌcaye je̱omaꞌë pajiꞌi. Paꞌina, huiꞌyoni i̱te ñani ai quëquëhuë. ");
INSERT INTO seyNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Quëquëjëna, jë̱tëpi camaꞌpë caquë yoꞌoni je̱orena, i̱te co hue̱ꞌñapi etoseꞌere quëapi. Quëaquë capi: “Santiagore cuiꞌne yecohuaꞌire sehuosicohuaꞌire quëacaijë̱ꞌë, yëꞌëre etoseꞌere.” Cani yequë hue̱ꞌñana sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ñata to̱mesi maca Pedro peoquëna, soldado pa̱i ai cuasajë huesëjë sa̱ꞌñe ai yoꞌojë cahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Yoꞌojë cajëna, Herodespi cua̱ñepi, Pedrore coꞌejë̱ꞌë caquë. Cua̱ñeina, coꞌe jujahuë. Coꞌe jujarena, deꞌoye ñajëꞌë casicohuaꞌipi ñamaꞌpë paꞌisicohuaꞌire huani je̱ojëꞌë, cua̱ñepi. Cua̱ñeina, huani je̱ohuë, soldado pa̱ire. Ja̱je yoꞌosi jeteyoꞌje Herodes Judea paꞌiye je̱oni Cesareana sani pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes Sidón pa̱ire cuiꞌne Tiro pa̱ire pë̱i pajiꞌi. Paꞌina, i̱ohuaꞌipi pa̱i ëjaë Herodesre ca deꞌhuañuꞌu, cajë teꞌe. Ja̱je yoꞌoñuꞌu cahuë. Casicohuaꞌipi i̱ quë̱no macarepa co̱cai paꞌiquë Blasto hueꞌequëna cajeohuaꞌi deꞌohuë. Deꞌoni ja̱ëjaꞌa se̱iꞌë, Herodesre deꞌoye pë̱imaꞌëna, paꞌiyere. Tiro cuiꞌne Sidón pa̱i cato Herodes yejana a̱o huerocohuaꞌi paëꞌë. Ja̱je paꞌina, ja̱je yoꞌohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ja̱je yoꞌosicohuaꞌini yequë muꞌse Herodespi capi, ja̱ muꞌse pa̱i tsiꞌsiye paꞌiji, caëna, tsiꞌsirena, deꞌo ca̱ñarepa su̱ñasiquëpi i̱ ñuꞌi pa̱ire cua̱ñe hue̱ꞌñana jaꞌruni cocare capi, pa̱ire. ");
INSERT INTO seyNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Caquëna, asacohuaꞌipi tutu cuihuë. Ñeje cajë: “Maijaꞌquëpi caji, pa̱ipi caye pa̱ji.” ");
INSERT INTO seyNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Cajëna, Ëjaë hui̱ñaëre jëjo daoquëpi ju̱ꞌiñe nepi, i̱te, ja̱re i̱ti yoꞌojë ca macapi. Neina, pecona a̱o ju̱jiꞌi. Maijaꞌquëre jerepa paꞌipi cacaimaꞌ doꞌire ju̱jiꞌi, i̱jaꞌa coꞌye Maijaꞌquëje̱ paꞌi aꞌë caquë sihuaquë asa doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ja̱je yoꞌojë paꞌijëna, Maijaꞌquë coca cato jerepa jai sajiꞌi. Jai saina, siꞌa hue̱ꞌña i̱ti cocare quëahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabé cuiꞌne Saulo coꞌamaña ne tëjini Jerusalénpi coꞌijë Juanreje̱ dahuë, yequë mami Marcos hueꞌequëreje̱. ");
INSERT INTO seyNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioquía yejare Maijaꞌquëre quëacaicohuaꞌi cuiꞌne Maijaꞌquë coca yeꞌyacohuaꞌi paëꞌë, sehuosicohuaꞌi ja̱ꞌre co̱ni. Icohuaꞌipi paëꞌë, Bernabé, Simón yequë mami Negro hueꞌequë, yequë Lucio Cirene aquë pajiꞌi, Manaén pajiꞌi, (Herodes ja̱ꞌre ai deꞌosiquë Galilea yeja cua̱ñequë paꞌisiquë) cuiꞌne Saulo pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ja̱je paꞌicohuaꞌipi teꞌe muꞌse a̱imaꞌcohuaꞌipi mai Ëjaëre se̱jëna, deꞌo joyopi capi: “Ja̱ohuaꞌire Bernabére cuiꞌne Saulore jëjo saojë̱ꞌë, yëꞌë nejajë caquë soiseꞌe nejaꞌcohuaꞌire.” ");
INSERT INTO seyNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Caëna, a̱imaꞌpë Maijaꞌquëre se̱ni tëjini ja̱ohuaꞌire jë̱ñapi jëjo pajë se̱cacani jëjo saohuë, se ñajë saijë̱ꞌë cajë. ");
INSERT INTO seyNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Maijaꞌquë joyopi jëjo saoquëna, saicohuaꞌipi Bernabé cuiꞌne Saulo saëꞌë, Seleucia daripëna saicohuaꞌipi. Ja̱ropi jai yohuëna aya mëni Chipre hueꞌe saodohuëna saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Saicohuaꞌipi Salamina yo saꞌrona ti̱ꞌani judío pa̱i tsiꞌsi huë̱ꞌñana Maijaꞌquë coca quëa huëohuë. Juan i̱ohuaꞌire co̱casiꞌi caquë saisiquëje̱ i̱ohuaꞌi ja̱ꞌre pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Siꞌa saodohuë quëaroja̱ijë Pafos daripëna sa ti̱ꞌahuë. Ti̱ꞌani ja̱rona ñahuë, Israel pa̱ipi dahuëpi Barjesús hueꞌequëre. Ja̱ëpi Maijaꞌquë cocare cayë caquë pa̱ire cosoquë yoꞌoquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ja̱ë dahuëpi Sergio Paulo ta̱ꞌñe asaquë ja̱ꞌre pa̱i ëjaë ja̱ꞌre pajiꞌi. Paꞌina, pa̱i ëjaëpi Bernabére cuiꞌne Saulore quërëja̱ijaꞌcohuaꞌire jëjo saopi, Maijaꞌquë coca quëajëna, asayere yë. ");
INSERT INTO seyNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ja̱je yoꞌoquëtaꞌare griego pa̱i coca cato Elimas hueꞌequëpi dahuëpi pa̱i ëjaë sehuoyere ë̱sequë Bernabére cuiꞌne Saulore sa̱ñope capi. ");
INSERT INTO seyNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Caquëna, Saulopi Pablo hueꞌequëpi Maijaꞌquë joyo ti̱mësiquëpi i̱te ai ñani, ");
INSERT INTO seyNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","capi: “¡Cosou, coꞌaquërepa, huati mamaquë siꞌaye deꞌoyere sa̱ñope yoꞌoquë ai! ¿Je yëhua Ëjaëre sa̱ñope yoꞌoye je̱ojaꞌquë aꞌni, mëꞌë? ");
INSERT INTO seyNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Yure Maijaꞌquëpi mëꞌëre siꞌsesipi. Siꞌsequëna, tsoe muꞌseña ñamaꞌë paꞌi cuiꞌne ë̱së miañeje ñamaꞌë paꞌija̱ꞌquë aꞌë, mëꞌë.” Ca macarepa Elimas ñamaꞌquë deꞌopi, ñamije paꞌioseꞌere ñaquë deꞌoni. Ja̱ maca i̱te jë̱tëna tse̱ꞌejë cuaja̱ꞌcohuaꞌini coꞌepi. ");
INSERT INTO seyNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ja̱re ñani ai deꞌoyere paꞌë, Ëjaë aye yeꞌyaye cuasaquë pa̱i ëjaë sehuopi. ");
INSERT INTO seyNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pablo cuiꞌne i̱te co̱cohuaꞌi jai yohuëna aya mëni Pafos daripë je̱oni Perge daripëna ti̱ꞌahuë, Perge daripë Panfilia yeja quëꞌro acona. Ja̱rona Juan je̱oni Jerusalénna coꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Perge sa sani Pisidia yeja quëꞌro daripëna Antioquíana ti̱ꞌahuë. Ti̱ꞌani huajë muꞌse paꞌina, Israel pa̱i tsiꞌsi huëꞌena cacani jaꞌruhuë. ");
INSERT INTO seyNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Jaꞌruni ñuꞌijëna, tsiꞌsi huëꞌe ëjaohuaꞌipi cua̱ñeseꞌe cuiꞌne Maijaꞌquëre quëacaicohuaꞌi toyasi pëpë ña tëjini cahuë: “Aꞌyë dohuë, pa̱ire yëhuoye paꞌito quëajë̱ꞌë, yurepi.” ");
INSERT INTO seyNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Carena, ja̱ maca Pablo huëni nëcani jë̱tëpi camaꞌpë caquë jaꞌjëni capi: “Ë̲mëohuaꞌi Israel pa̱i cuiꞌne siꞌaohuaꞌi yequë pa̱i Maijaꞌquëre caꞌracohuaꞌi asajë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel pa̱i Diusupi mai aiohuaꞌire joꞌya nepi. Joꞌya neni ja̱ohuaꞌija̱ꞌa jai pa̱i jojo saiye nepi, yequë pa̱i yeja Egíptore paꞌi maca cuiꞌne ja̱ jeteyoꞌje i̱ tutupi yoꞌoquë etopi, ja̱ yeja paꞌisicohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Etouna, Israel pa̱ipi cuarenta o̱metëca pa̱i peo hue̱ꞌña cue̱nesi yejaja̱ꞌa cuꞌijë yoꞌojëna, Maijaꞌquëpi i̱ohuaꞌire deꞌoye ñacaijiꞌi, yoꞌo jujamaꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ja̱je yoꞌoquë siete tsëcapë̱arepa Canaán yeja paꞌicohuaꞌire nejopi, ja̱ohuaꞌi yejare mai aipëna i̱sisiꞌi caquë. ");
INSERT INTO seyNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Siꞌaye iye yoꞌoye cato cuatrocientos cincuenta o̱metëca pajiꞌi. Ja̱ paꞌisi jeteyoꞌje yuretaꞌa Maijaꞌquëpi Israel pa̱i yoꞌoyere ñani ca tëji ëjaohuaꞌire i̱sipi, Maijaꞌquëre quëacaiquë Samuel paꞌi macaja̱ꞌa. ");
INSERT INTO seyNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ja̱je yoꞌoye paꞌina, yuretaꞌa se̱iꞌë, yëquëre cua̱ñe ëjaëre pare necaijë̱ꞌë cajë. Se̱jëna, Maijaꞌquëpi Cis mamaquë Saúlni pa̱i ëjaëre necajiꞌi, cuarenta o̱metëca i̱ohuaꞌire cua̱ñejaꞌquëre. Ja̱ë cato Benjamín tsëcapë aquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Paꞌina, jeteyoꞌje Maijaꞌquëpi Saúlre pa̱i ëjaërepa paꞌiye jioni Davidna i̱sipi, pa̱i ëjaërepa paꞌiye. Davidni Maijaꞌquë capi, ñeje: ‘Isaí mamaquë David cato yëꞌë yëyere yoꞌosiꞌi cuasaji. Ja̱je paꞌipi, yëꞌë ña hue̱ꞌñaje deꞌoye yoꞌoquë api.’ ");
INSERT INTO seyNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ja̱je paꞌina, i̱ ca nëoseꞌeje̱ paꞌye Israel pa̱ire huasosiꞌi caquë jëjo daopi, Jesure. Jesús cato David tsëcapë aquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ja̱ yëꞌtaꞌa Jesús daimaꞌnë Juanpi siꞌa Israel pa̱ire Maijaꞌquë coca quëapi. Quëaquë capi, ja̱ꞌnë cuasaseꞌere je̱oni Maijaꞌquëna po̱nëjëꞌë. Po̱nëjëna, oco doye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Casiquëpi je̱ꞌnë i̱ pani tëjiye ti̱ꞌaquëna, capi Juan: ‘Yëꞌë mësaru cuasayeje̱ paꞌi peoyë. Yëꞌë paꞌisi jeteyoꞌje teꞌi jerepa paꞌipi daiji. Ja̱ëre yëꞌë i̱ zapato dutacaiyeque peoquëpi, teaye paꞌi aꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ja̱je paꞌiye sëte ë̱mëohuaꞌi Maijaꞌquë doꞌijë Abraham tsëcapë acohuaꞌi, cuiꞌne mësaru ti̱ohuaꞌi, Maijaꞌquëre caꞌrajë i̱ yëyeje̱ paꞌicohuaꞌi, iye huaso coca mësaru asa ja̱ꞌñere jëjo daoseꞌe aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalén paꞌicohuaꞌi cuiꞌne i̱ohuaꞌi ëjaohuaꞌije̱ Jesure huesëjë coa pa̱ije paꞌire ñahuë. Ñajë cuiꞌne huajë muꞌseña ñape pa̱i tsiꞌsi huëꞌepi Maijaꞌquëre quëacaicohuaꞌi toyaseꞌere ñanije asa ti̱ꞌañe pa̱huë. Pa̱jë ja̱re i̱ohuaꞌipi Maijaꞌquëre quëacaicohuaꞌi caseꞌere yoꞌo ti̱ꞌacaëꞌë, Jesure huani je̱o maca. ");
INSERT INTO seyNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Jesús coꞌaye yoꞌoseꞌere ti̱ꞌamaꞌpëtaꞌa Jesure huani je̱oñere Pilatopi soldado pa̱ina cua̱ñejaquë cajë se̱iꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ja̱ jeteyoꞌje yuretaꞌa siꞌaye iye yoꞌo ja̱ꞌñere toyaseꞌe cayere yoꞌo tëjini so̱quë sarahua dequëni casani yejana ta̱huë. ");
INSERT INTO seyNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ja̱je yoꞌosiquëtaꞌare Maijaꞌquëpi i̱te huajëquëre huëopi. ");
INSERT INTO seyNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Huëosiquëpi Jesús jai so̱ muꞌseña ñaiquë i̱ñopi, i̱ ja̱ꞌre co̱ni Galileapi Jerusalénna saina, saisicohuaꞌire. Yure ja̱ohuaꞌipi i̱ coca quëacohuaꞌi paꞌiyë. ");
INSERT INTO seyNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ja̱je paꞌiye sëte yëquë mësarute deꞌo cocare quëayë, mai aiohuaꞌire ca nëoseꞌere yoꞌo ti̱ꞌapi, mai paꞌi maca i̱ ca nëosi tsëcapë acohuaꞌina. ");
INSERT INTO seyNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ja̱ i̱ ca nëoseꞌere yoꞌo ti̱ꞌaquë Jesure ju̱ꞌisiquëni huajëquëre huëopi, Maijaꞌquëpi. Salmos cayaye acore toyaseꞌeje̱ paꞌye yoꞌopi. Ja̱pi caji, ñeje: ‘Mëꞌë yëꞌë mamaquë aꞌë. Yurepi yëꞌë mëꞌë jaꞌquë aꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ja̱je paꞌina, Maijaꞌquë yequë hue̱ꞌña toyaseꞌeja̱ꞌa capi: ‘Davidre i̱sija̱ꞌquë aꞌë, ca nëoseꞌere. Deꞌoyere pare nuñerepa ca nëoseꞌere i̱sija̱ꞌquë aꞌë, mëꞌëre.’ Ja̱je paꞌina, tsoe Maijaꞌquëpi quëapi, ju̱ꞌisiquëpi huëi ja̱ꞌñe cuiꞌne i̱ ca̱pë ja̱ꞌjuñe pa̱ ja̱ꞌñe. ");
INSERT INTO seyNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ja̱je paꞌina, yequë hue̱ꞌña toyaseꞌe caji: ‘Mëꞌë joꞌyaë deꞌoquërepa ca̱pë ja̱ꞌju huesëye mëꞌëpi ë̱seja̱ꞌquë aꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Deꞌoji, yure ja̱je paꞌiye sëte casiꞌi. David cato Maijaꞌquë i̱te cua̱ñeseꞌeje̱ paꞌye i̱ pa̱ire necani tëjini ju̱ni huesëpi, i̱ aiohuaꞌi ju̱ꞌiseꞌeje̱ paꞌye. Ja̱je ju̱ni i̱ ca̱pë ja̱ꞌju huesëpi. ");
INSERT INTO seyNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ja̱je paꞌiquëtaꞌare ja̱ë, Maijaꞌquë huëosiquë Jesús ca̱pë cato ja̱ꞌjuñe pa̱pi. ");
INSERT INTO seyNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Ja̱je paꞌiye sëte mësaru Maijaꞌquë doꞌijëpi asaye paꞌiji, Jesuja̱ꞌa coꞌaye yoꞌoseꞌe oni yeje cua̱ñoñe paꞌiji, cajë. Ja̱je paꞌina, siꞌaye Moisés cua̱ñeseꞌe oni yejeye pa̱seꞌere Jesure i̱re pare asacohuaꞌire oni yejeye paꞌiji, i̱tire paꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Deꞌhua ñajëꞌë, mësaruna Maijaꞌquëre quëacaicohuaꞌi toyaseꞌe to̱mequë i̱ohuaꞌi toyaseꞌe cato caji: ");
INSERT INTO seyNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Nuñere pare ñajëtaꞌa coꞌaji cajë coecohuaꞌi, ne huesëjë̱ꞌë. Mësaru paꞌi muꞌseña yëꞌëpi coꞌamañare nequëna, Yecohuaꞌipi mësarute quëatoje̱ care payë cajë sehuocaiye pa̱jaꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Judío pa̱i tsiꞌsi huëꞌepi Pablo cuiꞌne i̱ cajeohuaꞌi co̱ni etajëna, tsi̱ꞌnëna, judío pa̱irepa peocohuaꞌipi cahuë: Yequë semana huajë muꞌse paꞌina, cuiꞌnare quëajë̱ꞌë, yëquëre. ");
INSERT INTO seyNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ca tëjisi maca tsiꞌsi huëꞌepi Pablo cuiꞌne Bernabé saijëna, jai pa̱i judío pa̱ipi cuiꞌne judío pa̱i peocohuaꞌipi judío yeꞌyayena huero yeꞌyesicohuaꞌipi i̱ohuaꞌi ja̱ꞌre saëꞌë. Saijëna, i̱ohuaꞌipi yëhuojë cahuë. Nuñerepa Maijaꞌquë mësarute oi soiseꞌere paꞌijë̱ꞌë, yoꞌo jujamaꞌpë. ");
INSERT INTO seyNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Casicohuaꞌipi yequë semana huajë muꞌse ti̱ꞌaëna, ja̱ daripë paꞌicohuaꞌipi siꞌaohuaꞌi tsiꞌsiye jaꞌi maca jai pa̱i tsiꞌsihuë, Maijaꞌquë coca asañuꞌu cajë. ");
INSERT INTO seyNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Tsiꞌsijëna, ñani Israel pa̱ipi ë̱sejë oijë Pablo ai coꞌaquë api sa̱ñope ca huëohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Cajëna, Pablopi cuiꞌne Bernabépi quëcojë sa̱ñope cahuë, i̱ohuaꞌire: “Mësaru judío pa̱ini duꞌru macarepa Maijaꞌquë coca quëaye paꞌiji. Paꞌisiconi mësarupi coejë cuiꞌne ti pani huesëyere paye cuasamaꞌpëna, yure cato judío pa̱i peocohuaꞌina sani quëaye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ja̱je paꞌina, Ëjaëpi yëquëre cua̱ñequë capi: Siꞌa pa̱ire miacaija̱ꞌquëre je̱oñë, mësarute. Yëꞌë huaso cocare siꞌa hue̱ꞌña soꞌo paꞌicohuaꞌire quëacaijë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ja̱je caquëna, asani judío pa̱i peocohuaꞌipi sihuajë siꞌaohuaꞌi Maijaꞌquë coca ai deꞌoye aꞌë, cajë ti pani huesëyere ti̱ꞌajaꞌcohuaꞌi aꞌë, caquë ña nëosicohuaꞌipi sehuohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Sehuojëna, ja̱je Maijaꞌquë coca quëahuë, ja̱ yeja paꞌicohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ja̱je sehuojëtaꞌare judío pa̱ipi Pablore cuiꞌne Bernabére eto saoñuꞌu cajë, deꞌo nomiohuaꞌi ja̱ꞌre cuiꞌne deꞌo ë̱mëohuaꞌire cuiꞌne i̱ti daripë ëjaohuaꞌi ja̱ꞌre coca cahuë, sa̱ñope ja̱ohuaꞌire yoꞌoñuꞌu cajë cani sa̱ñope yoꞌojë etohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Etorena, saijë i̱ohuaꞌi nëcañoa yaꞌore ti̱ꞌto to̱huë, ja̱ohuaꞌi yoꞌoyere sa̱ñope cayere i̱ñojë. Ja̱je yoꞌoni Iconiana saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ja̱je paꞌiquëtaꞌare i̱ti sehuosicohuaꞌi cato sihuahuë, deꞌo joyopi i̱ohuaꞌi ja̱ꞌre paꞌina. ");
INSERT INTO seyNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pablopi cuiꞌne Bernabépi Iconiore paꞌijë judío pa̱i tsiꞌsi huëꞌena cacani Maijaꞌquë coca quëajëna, jai pa̱i judío pa̱i cuiꞌne judío pa̱i peocohuaꞌi sehuohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Sehuojëna, judío pa̱i sehuomaꞌcohuaꞌipi sa̱ñope yoꞌoja̱jë cajë judío pa̱i peocohuaꞌire cua̱ñejëna, sehuosicohuaꞌire coꞌaye cuasa huëohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ja̱je coꞌaye cuasa huëo doꞌire ai tsoe ja̱ daripëna pëani Maijaꞌquë coca deꞌoyerepa quëahuë. Quëajëna, Maijaꞌquëpi pa̱i yoꞌo ti̱ꞌa maꞌñe yoꞌo tutu i̱siquëna, jaiye deꞌoyere yoꞌohuë. Ja̱je yoꞌojëna, Maijaꞌquë oiye i̱ohuaꞌi quëaye doꞌi quëꞌyerepa paꞌiye i̱ñopi. ");
INSERT INTO seyNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ja̱je paꞌiquëtaꞌare i̱ti daripë acohuaꞌipi caya tsëca huasicohuaꞌi paëꞌë. Paꞌijë yecohuaꞌipi judío pa̱i cayere deꞌoye aꞌë, cacaëꞌë. Cajëna, yecohuaꞌipi Ëjaë jëjo saocohuaꞌi cayere deꞌoye aꞌë, cacaëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ja̱je cajë paꞌijëna, judío pa̱ipi cuiꞌne judío pa̱i peocohuaꞌipi Pablore cuiꞌne Bernabére coꞌaye yoꞌojë quë̱na pë̱api je̱a joꞌañuꞌu cajë i̱ti daripë ëjaohuaꞌi ja̱ꞌre coca cani teꞌe ja̱je yoꞌoye deꞌoji, cuasa nëohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Cuasa nëoseꞌere asani Pablopi cuiꞌne Bernabépi catihuë, Listrana cuiꞌne Derbena Licaonia yejana cuiꞌne i̱ti yeja yequë daripë̱a paꞌiyena. ");
INSERT INTO seyNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Catini ja̱roje̱ quëahuë, deꞌo cocare. ");
INSERT INTO seyNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra daripëre teꞌi ë̱më tsi̱ꞌnëna cuꞌimaꞌquë ai deꞌosiquëpi pajiꞌi, coa ñuꞌiquëpi. ");
INSERT INTO seyNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Coa ñuꞌiquëpi Pablo quëayere asaquë Maijaꞌquëpi yëꞌëre ne coꞌyaye paꞌiji cuasaquë ñujiꞌi. Ñuꞌina, Pablopi i̱ ja̱je Maijaꞌquëre cuasaye asani ");
INSERT INTO seyNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ai tutu capi: “Huëni nëcajë̱ꞌë.” Caquëna, ca macarepa teꞌere papi huëni nëcani cuꞌi huëopi. ");
INSERT INTO seyNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ja̱je Pablo yoꞌouna, ñani Licaonia cocapi tutu cuijë cahuë: “Diusuohuaꞌipi pa̱ije paꞌiohuaꞌi deꞌoni mai quëꞌrona cajeni yoꞌoyë.” ");
INSERT INTO seyNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Cajë Bernabéni diusu Zeus hueꞌyohuë. Hueꞌyojë Pabloni i̱ti coca ca doꞌire Hermes hueꞌyohuë. Listra pa̱i diusu mamire hueꞌyohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ja̱ maca yuretaꞌa pa̱i daripë caca saꞌro yëꞌquë macare diusu Zeuste se̱ huëꞌe paquëpi i̱ti huëꞌe ñacai ëjaëpi duruhue̱quëre cuiꞌne deꞌo joro neseꞌere dapi. Dani Jesús jëjo saocohuaꞌire deꞌocohuaꞌire paꞌni caquë se̱siꞌi, caquë yoꞌopi. Yoꞌoquëna, yecohuaꞌije̱ i̱ ja̱ꞌre se̱ñuꞌu, cajë yoꞌohuë. Yoꞌojë i̱ohuaꞌi ai yoꞌojë pacohuaꞌini nëicohuaꞌire huani coa i̱sijë se̱ñuꞌu, cajë yoꞌohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Yoꞌoyere asani Bernabépi cuiꞌne Pablopi coꞌaji, ja̱ yoꞌoye cajë. Juꞌi ca̱ñana coꞌrëjë, cuijë sa to̱mejaëꞌë, i̱ohuaꞌi jopona. ");
INSERT INTO seyNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Ñeje cuihuë: “¿Merepa mësaru ja̱je yoꞌoyeꞌni? Yëquë cato mësaruje̱ paꞌiohuaꞌi aꞌë. Yure mësaru coa yoꞌoye je̱oni Maijaꞌquë i̱ti yeja, maꞌtëmo, jai tsiaya cuiꞌne siꞌaye i̱ote paꞌiye deꞌhuasiquëre pani sehuoni paꞌija̱jë cajë quëañuꞌu cajë daisicohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ja̱je paꞌiquëtaꞌare yequë muꞌseña cato i̱ohuaꞌiseꞌe i̱ohuaꞌi yëyeje̱ yoꞌojë paꞌija̱jë caquë ñapi, Maijaꞌquë. ");
INSERT INTO seyNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ja̱je yoꞌojë paꞌitoje̱ Maijaꞌquëpi deꞌoye yoꞌoyeja̱ꞌa i̱ñopi, yëꞌë paꞌiye caquë. Ja̱je paꞌina, i̱pi mësarute oco cuiꞌne deꞌoye quë̱quëna tëaye cuiꞌne a̱iñe cuiꞌne sihuajë paꞌiye i̱siji.” ");
INSERT INTO seyNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ja̱je siꞌaye canije ai yoꞌojë maña duruhue̱quëre huaiye pa̱jëꞌë, cajë ë̱sehuë, diusuohuaꞌire i̱sijë se̱ñuꞌu cajë yoꞌocohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ja̱je yoꞌojë ca maca da ti̱tahuë, Israel pa̱i, Antioquía yeja cuiꞌne Iconia yeja paꞌicohuaꞌi. Ja̱ohuaꞌipi ti̱tani ti̱ñe cuasayena pa̱ire po̱nahuë. Po̱narena, Pablore quë̱na pë̱api je̱a joꞌahuë. Je̱a joꞌani huani je̱ohuë, cuasajë pa̱i paꞌi daripë hueꞌsena quërë etohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Quërë je̱orena, sehuosicohuaꞌipi i̱ u̱i hue̱ꞌñana tsiꞌsini nëcajëna, huëjiꞌi. Huëni pa̱i daripëna cacapi. Cacasiquëpi ñatasi muꞌse Bernabé ja̱ꞌre co̱ni Derbe daripëna saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Sani ja̱ro Derbena deꞌo coca quëajëna, jai pa̱i sehuohuë. Sehuorena, ñani ja̱ropi Listrana, Iconiana cuiꞌne Antioquía darina coꞌihuë. ");
INSERT INTO seyNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Coꞌini, ja̱ro sehuosicohuaꞌi paꞌicohuaꞌire yoꞌo jujamaꞌpë ñese tuijë̱ꞌë, cahuë. Cajë cuiꞌne Maijaꞌquëre cuasare pajë paꞌijë̱ꞌë, cahuë. Ja̱je cajë cuiꞌne yequeje̱ cahuë, Maijaꞌquë cua̱ñe te̱ꞌtena cacañuꞌu cani jaiye ai yoꞌoye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ja̱je cajë cuiꞌne yequeje̱ sehuosicohuaꞌi tsëcapë̱a ñape i̱ohuaꞌi ëjaohuaꞌi paꞌija̱ꞌcohuaꞌire nehuë. Neni a̱o a̱imaꞌcohuaꞌipi Maijaꞌquëre se̱jë yoꞌo tëjini icohuaꞌire deꞌoye ñacaijë̱ꞌë, cajë Maijaꞌquëre se̱cacaëꞌë, i̱ohuaꞌi sehuosiquëna. ");
INSERT INTO seyNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pisidia yeja sa tëto sani Panfilia yejana ti̱ꞌahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ti̱ꞌani Perge yeja paꞌicohuaꞌire deꞌo coca quëahuë. Quëa tëjini Antalia daripëna saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Sani ja̱rona yuretaꞌa yohuëna aya mëni Antioquíana, Maijaꞌquë oiye ayepi necaijë̱ꞌë cajë cua̱ñe sitona, i̱ohuaꞌi deꞌoye i̱ti caseꞌeje̱ ne tëji sitona coꞌihuë. ");
INSERT INTO seyNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Coꞌini Antioquíana ti̱tani siꞌa sehuosicohuaꞌire siꞌsoni Maijaꞌquë i̱ohuaꞌi ja̱ꞌre co̱ni yoꞌoquëna, Ëjaëpi judío pa̱i peocohuaꞌipi sehuoja̱jë caquë ja̱to saꞌroje̱ paꞌiore huiꞌyocaquëna, deꞌoye sehuoseꞌere quëahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Quëasicohuaꞌipi sehuosicohuaꞌi ja̱ꞌre co̱ni i̱ti macana pëani tsoe paëꞌë, ja̱rote. ");
INSERT INTO seyNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ja̱ muꞌseña Judeapi Antioquíana cayao maña saisicohuaꞌipi Maijaꞌquë doꞌijëre yeꞌyajë cahuë huaso cua̱ñoñe peoji, Moisés cua̱ñeseꞌere yoꞌomaꞌpë pani, ca̱ꞌni tëamaꞌpë pani, cahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ja̱je cajëna, Pablopi cuiꞌne Bernabépi co̱ni i̱ohuaꞌi ja̱ꞌre ai sa̱ꞌñe yoꞌojë cahuë. Ja̱je yoꞌojë cajëna, Pablore, Bernabére cuiꞌne yecohuaꞌi sehuosicohuaꞌire Jerusalénna sani Jesús jëjo saocohuaꞌi ja̱ꞌre cuiꞌne ja̱ daripë sehuosicohuaꞌi ëjaohuaꞌi ja̱ꞌre ca̱ꞌni tëaye ayere coca caja̱ꞌcohuaꞌire jëjo saoñuꞌu, cani jëjo saohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Antioquía daripë sehuosicohuaꞌi paꞌicohuaꞌipi jëjo saojëna, saicohuaꞌipi Fenicia yejaja̱ꞌa cuiꞌne Samaria yejaja̱ꞌa sa saijë quëahuë, judío pa̱i peocohuaꞌipi ja̱ꞌnë i̱tire paꞌë cuasajë paꞌiseꞌere je̱oconi Maijaꞌquëre sehuoseꞌere quëajëna, asani siꞌaohuaꞌi sehuocohuaꞌi sihuahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jerusalénna Pablo cuiꞌne Bernabé ti̱ꞌarena, sehuosicohuaꞌipi cuiꞌne Jesús jëjo saocohuaꞌipi cuiꞌne sehuosicohuaꞌi ëjaohuaꞌipi co̱ni deꞌoye pëpahuë. Pëparena, paꞌijë siꞌaye Maijaꞌquë i̱ohuaꞌi ja̱ꞌre yoꞌoseꞌere quëahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Quëajëna, fariseo acohuaꞌipi Maijaꞌquëre sehuosicohuaꞌipi huëni nëcani cahuë: “Yequë pa̱ipi sehuosicohuaꞌire ca̱ꞌni tëaye paꞌiji. Ja̱ maca Moisés cua̱ñeseꞌere yoꞌo ti̱ꞌajëꞌë, cua̱ñeñe paꞌiji.” ");
INSERT INTO seyNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Cajëna, asani ja̱ maca Jesús jëjo saocohuaꞌipi cuiꞌne sehuosicohuaꞌi ëjaohuaꞌipi tsiꞌsihuë, fariseo acohuaꞌi caseꞌere sa̱ꞌñe coca cajë asañuꞌu cajë. ");
INSERT INTO seyNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ja̱je cajë tsiꞌsisicohuaꞌipi ai sa̱ꞌñe ca tëji maca Pedropi huëni nëcani capi: “Maijaꞌquë doꞌijë mësarupi ta̱ꞌñe asayë, yëꞌëre mësaru aquëni Maijaꞌquëpi joꞌya neseꞌe tsoe hue̱ꞌña i̱ huaso cocare judío pa̱i peocohuaꞌina quëaquëna, ja̱ohuaꞌipi i̱tire paꞌë cajë sehuoja̱jë caquë. ");
INSERT INTO seyNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Maijaꞌquë pa̱i joñoa cuasaye ñaquëpi yëꞌë tse̱cohuaꞌire neñë caquë i̱ñoquë, deꞌo joyore i̱sipi, judío pa̱i peocohuaꞌina maire i̱siseꞌeje̱ paꞌye. ");
INSERT INTO seyNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ja̱je paꞌina, Maijaꞌquë cato ja̱ohuaꞌire cuiꞌne maire ti̱ñe paꞌiohuaꞌire ñañe pa̱ji, siꞌaohuaꞌire cuiꞌne paꞌiohuaꞌire ñaji. Ja̱je paꞌina, Maijaꞌquëre cuasa doꞌija̱ꞌa deꞌo joñoa tsoa to̱cajiꞌi, ja̱ohuaꞌireje̱. ");
INSERT INTO seyNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Yure ja̱je paꞌito, ¿me yoꞌojë Maijaꞌquë yoꞌoyere sa̱ñope uihuayeꞌni, sehuosicohuaꞌina dëquëcoje̱ paꞌiore hueꞌocaijë maije cuiꞌne mai aipëje̱ yoꞌo ti̱ꞌañe pa̱seꞌere? ");
INSERT INTO seyNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ja̱je paꞌina, yëquë cato cuasayë ja̱ohuaꞌire huasoseꞌeje̱ paꞌyepi yëquëreje̱ Ëjaë Jesús oi coa i̱siyepi huasopi cuasayë.” ");
INSERT INTO seyNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Caquëna, siꞌaohuaꞌi joꞌcua je̱oni Bernabé cuiꞌne Pablo cayere asahuë. I̱ohuaꞌi ja̱ꞌre Maijaꞌquë paꞌi co̱caina, yequë muꞌseña paꞌi ja̱ꞌñe i̱ñoseꞌe cuiꞌne pa̱i yoꞌo ti̱ꞌa maꞌñe yoꞌoseꞌe quëajëna, asahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ja̱ maca quëa tëjijëna, Santiagopi capi: “Maijaꞌquë doꞌijë asajë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Maijaꞌquëpi judío pa̱i peocohuaꞌire deꞌoye yoꞌocai ja̱ohuaꞌi acohuaꞌini sahuani i̱ pa̱irepa paꞌija̱ꞌcohuaꞌire neseꞌere Simónpi maire quëaquëna, asahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ja̱je paꞌina, iye toyaseꞌe cato Maijaꞌquëre quëacaicohuaꞌi toyaseꞌeje̱ paꞌye yoꞌoseꞌe aꞌë. Ja̱je paꞌina, ñeje caji, toyaseꞌe: ");
INSERT INTO seyNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Ja̱ jeteyoꞌje coꞌi co̱ni David huëꞌe ta̱isicore ne deꞌhuacasiꞌi Cuiꞌne i̱o coꞌa deꞌoseꞌe siꞌaye ne deꞌhuasiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ne deꞌhuaëna, ëjaëre judío pa̱i coꞌeja̱jë, yëꞌë mami se̱cohuaꞌi judío pa̱i peocohuaꞌi ja̱ꞌre. ");
INSERT INTO seyNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Tsoe hue̱ꞌña iye yoꞌo ja̱ꞌñe quëasiquëpi, ëjaëpi i̱sipi iye coca. ");
INSERT INTO seyNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ja̱je paꞌina, yëꞌë cato cayë, judío pa̱i peocohuaꞌipi ja̱ꞌnë i̱tire paꞌë cuasaseꞌere je̱oni Maijaꞌquëni tuicohuaꞌire cua̱ñeseꞌere yoꞌojë̱ꞌë cajë cua̱ñeñe peoji. ");
INSERT INTO seyNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ja̱je paꞌina, coa iyeseꞌe yoꞌomaꞌpë paꞌijë̱ꞌë cajë toyaseꞌe tsoe ti̱ꞌapi. Pa̱i deꞌhuasi diusure i̱sisi huaꞌire a̱imaꞌpë paꞌijë̱ꞌë, ë̱mëre cuiꞌne nomiore coa yoꞌoroja̱imaꞌpë paꞌijë̱ꞌë, quio hue̱asicohuaꞌire a̱imaꞌpë paꞌijë̱ꞌë, pa̱nitaꞌa tsie a̱imaꞌpë paꞌijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ja̱ maña toyañuꞌu, Moisés cua̱ñeseꞌe cato tsoe hue̱ꞌñapi pa̱i ñape daripë̱a paꞌicohuaꞌire quëajë paꞌiyë, huajë muꞌseña ñape tsiꞌsi huë̱ꞌñapi i̱ti toyaseꞌere ñajë. Ja̱je paꞌito me airepa cayeꞌni.” ");
INSERT INTO seyNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ja̱ maca yuretaꞌa Antioquíana i̱ohuaꞌi acohuaꞌini sahuani Pablo cuiꞌne Bernabé ja̱ꞌre jëjo saoñuꞌu, cajë siꞌa sehuosicohuaꞌi. Sehuosicohuaꞌi ëjaohuaꞌi cuiꞌne Jesús jëjo saocohuaꞌi teꞌe cuasahuë. Cuasani yoꞌojë Judas hueꞌequëni, ja̱re i̱pi yequë mami Barsabás hueꞌequëni cuiꞌne Silasni saija̱ꞌcohuaꞌire nehuë, deꞌocohuaꞌire pare. ");
INSERT INTO seyNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Neni ja̱ohuaꞌi ja̱ꞌre ñeje toyasicore jëjo saohuë: “Yëquë Jesús jëjo saocohuaꞌipi cuiꞌne sehuosicohuaꞌi ëjaohuaꞌipi mësaru aꞌyëohuaꞌije̱ paꞌiohuaꞌipi mësarute yëquë yoꞌje tsi̱je paꞌiohuaꞌire cuasajë judío pa̱i peocohuaꞌipi sehuosicohuaꞌire pëpayë, ja̱ro Antioquía daripë, cuiꞌne Siria cuiꞌne Cilicia yeja paꞌicohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Cuiꞌne yëquë jëjo saomaꞌcohuaꞌipi i̱ñopi. Saisicohuaꞌipi mësarute jo̱sa yoꞌojë huesë ëaye ca co̱ꞌme huesojëna, ai yoꞌojë asahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","26","Ja̱je paꞌina, asani siꞌaohuaꞌi ja̱je yoꞌoye deꞌoji cuasani mësarute yëquë acohuaꞌipi sani ñajaꞌcohuaꞌire neñuꞌu cani nehuë, yëquë ai oicohuaꞌi Pablo cuiꞌne Bernabé ja̱ꞌre saija̱ꞌcohuaꞌire, ju̱ꞌiñe paꞌitoje̱ quëcojë Jesucristo coca doꞌire quëaroja̱icohuaꞌi ja̱ꞌre saija̱ꞌcohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ja̱je yoꞌosicohuaꞌipi yure mësaru quëꞌrona jëjo saoyë, Judasre cuiꞌne Silasre mësaru ja̱ꞌre teꞌe tsiarepa ñajë coca siꞌaye quëaja̱ꞌcohuaꞌire, yëquë quëaseꞌeje̱ paꞌye. ");
INSERT INTO seyNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ja̱je paꞌina, deꞌo joyoje̱ deꞌoji, ja̱je yoꞌoye caquëna, ñaquëna, yëquëje̱ mësarute jaiye yoꞌojë̱ꞌë cajë cua̱ñeñe peoyë. Coa doꞌi quëꞌyeseꞌe yoꞌojë̱ꞌë caye yëyë, iyeseꞌe: ");
INSERT INTO seyNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Pa̱i deꞌhuasi diusuna i̱sisi huaꞌi a̱imaꞌpë paꞌijë̱ꞌë, quio hue̱asicohuaꞌire a̱imaꞌpë paꞌijë̱ꞌë, tsieje̱ a̱imaꞌpë paꞌijë̱ꞌë, cuiꞌne ë̱mëpi nomiohuaꞌire coa yoꞌoroja̱iñe yoꞌomaꞌpë paꞌijë̱ꞌë, nomioje ë̱mëohuaꞌire coa yoꞌoroja̱iñe yoꞌomaꞌo paꞌijë̱ꞌë. Iye caseꞌere yoꞌoni mësaru deꞌoye paꞌija̱ꞌcohuaꞌi aꞌë. Deꞌoye paꞌijë̱ꞌë. Ca tëjihuë.” ");
INSERT INTO seyNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ja̱ maca sai huëoni pëpa tëjini yuretaꞌa Antioquíana saëꞌë. Sani ti̱ꞌani sehuosicohuaꞌire tsiꞌsoni toyasicore i̱sihuë. ");
INSERT INTO seyNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","I̱sirena, sehuosicohuaꞌipi toyaseꞌere ñajë cajëna, asajë jai pa̱i sihuahuë, i̱te yëhuoyere asajë. ");
INSERT INTO seyNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Sihuajë asajëna, Judas cuiꞌne Silaspi Maijaꞌquë caye asani quëacai tutu pacohuaꞌipi ai tsoe quëahuë, yëhuojë. Ja̱je yëhuojëna, asa huajëjë jerepa tutu quëꞌi joñoa paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ja̱je quëajë pani tëjirena, sehuosicohuaꞌipi sani pëpacaijë̱ꞌë siꞌaohuaꞌire mësarute jëjo daosicohuaꞌire cajë pëpa tëjihuë, coꞌija̱ꞌcohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ja̱je paꞌiquëtaꞌare Silasseꞌe deꞌoji pëaye cuasani pëapi. ");
INSERT INTO seyNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pëaquëna, cuiꞌne Pabloje̱ cuiꞌne Bernabéje̱ pëahuë, Antioquíana, Maijaꞌquë coca yeꞌyajë cuiꞌne quëaroja̱ijë yoꞌoja̱ꞌcohuaꞌipi. Pëarena, jai pa̱i sehuosicohuaꞌipi i̱ohuaꞌi ja̱ꞌre co̱ni yoꞌohuë, i̱ti coꞌamaña. ");
INSERT INTO seyNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ai tsoe paꞌiquëpi Pablo capi, Bernabére: “Sehuosicohuaꞌire ti̱jupë doꞌi sani ñañuꞌu, mai ja̱ꞌnë Ëjaë coca quëasi daripë̱ana. ¿Me paꞌiyeꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Caquëna, Bernabépi Juanre yequë mami Marco hueꞌequëre sañuꞌu capi. ");
INSERT INTO seyNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Caquëna, Pablopi ë̱sepi, saye. Ja̱ë Marcopi ja̱ꞌnëje Panfiliana i̱ yoꞌoye je̱oconi teꞌe nemaꞌë yoꞌosiquëre me caquë. ");
INSERT INTO seyNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ja̱je paꞌina, teꞌe cuasaye peoquëna, teꞌohuaꞌiseꞌe huahuë. Huani Bernabépi Marcore sapi. Saquë jai yohuëna aya mëni Chiprena saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Saijëna, Pablopi i̱te co̱jaꞌquëre Silasni ti̱ꞌapi. Ti̱ꞌaëna, sehuosicohuaꞌipi Maijaꞌquëre se̱cacatena, etani sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Saiquëpi Siria yejaja̱ꞌa cuiꞌne Cilicia yejaja̱ꞌa sa tëto sai Maijaꞌquëre sehuosicohuaꞌire quëa huasoquë cujiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pablopi Derbena cuiꞌne Listrana ti̱ꞌani ja̱rona Timoteore ñapi. Judío nomiopi sehuosico mamaquëni cuiꞌne i̱ pëca jaꞌquëpi griego pa̱i pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ja̱je paꞌini Timoteore sehuosicohuaꞌipi deꞌoquë api cahuë, Listra cuiꞌne Iconia paꞌicohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Ja̱je caquëni Pablopi i̱te co̱jaꞌquëre sasiꞌi, cuasaquë. Ja̱ yëꞌtaꞌa samaꞌnë Timoteo ca̱ꞌnihuëre yëto tëapi, judío pa̱i i̱ saija̱ꞌto paꞌicohuaꞌipi coꞌaye camaꞌcohuaꞌini caquë. Cuiꞌne siꞌaohuaꞌi Timoteore griego pa̱i mamaquë api, asa doꞌire ja̱je yoꞌopi. ");
INSERT INTO seyNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ja̱je yoꞌosi jeteyoꞌje siꞌa daripë̱a maña i̱ohuaꞌi sa saiyeje̱ paꞌye Jesús jëjo saocohuaꞌi cuiꞌne Jerusalén paꞌicohuaꞌi sehuosicohuaꞌi ëjaohuaꞌi caseꞌere quëahuë, sehuosicohuaꞌina ñeje yoꞌojë̱ꞌë cajë. ");
INSERT INTO seyNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ja̱je yoꞌojëna, sehuosicohuaꞌipi i̱ohuaꞌi sehuoseꞌere i̱tire paꞌë asajë tutu quëꞌi joñoa paëꞌë. Paꞌijëna, muꞌseña ñape jai pa̱i sehuojë jai saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Deꞌo joyopi Asia yejana Maijaꞌquë coca quëaye ë̱se doꞌire Frigia yeja cuiꞌne Galacia yeja sa tëto sani, ");
INSERT INTO seyNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Misia yeja niamona ti̱ꞌahuë. Ti̱ꞌani ja̱ropi Bitinia sañuꞌu cuasahuë. Cuasajëtaꞌare Jesús joyopi ë̱sepi. ");
INSERT INTO seyNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ë̲sequëna, Misia yejaje̱ sa tëto sani Troas yo saꞌrona meñe cajehuë. ");
INSERT INTO seyNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Cajeni ja̱rona Pablopi ca̱ni ñapi, teꞌi Macedonia aquëpi nëcaquë i̱te yëquëre dani co̱caijë̱ꞌë caquëna. ");
INSERT INTO seyNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ja̱je Pablopi ca̱ni ñaëna, ja̱ro Macedoniana deꞌo coca quëaye paꞌiji caquë Maijaꞌquëpi soiji cajë ne deꞌhuahuë, sañuꞌu cajë. ");
INSERT INTO seyNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Troas yo saꞌrona aya mëisicohuaꞌipi teꞌe muꞌserepa saëꞌë, Samotracia saodohuëna. Saisicohuaꞌipi ñatasi muꞌse Neápolisna ti̱ꞌahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ti̱ꞌani ja̱ropi Filiposna saëꞌë, romano pa̱i daripëna. Ja̱ro Macedonia yeja ai ëja daripëre pana saëꞌë. Sani ja̱rona pëahuë, tsoe muꞌseña maña. ");
INSERT INTO seyNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Pëasicohuaꞌipi huajë muꞌse paꞌina, pa̱i daripëpi hueꞌsena etani saëꞌë. Tsiaya të̱ꞌtëpa quëꞌrona sani cuasahuë, judío pa̱i Maijaꞌquëre se̱ hue̱ꞌñaꞌë. I̱ño cuasani jaꞌruni ñuꞌijë deꞌo cocare quëahuë, nomiohuaꞌire i̱ti maca tsiꞌsini ñuꞌicohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Quëajëna, teꞌo nomio Lidia hueꞌecopi, Tiatira daripë pa̱iopi, jai doꞌi ca̱ña ma ja̱ꞌñe i̱sicopi tsiꞌsicohuaꞌi ja̱ꞌre pacoꞌë. Ja̱je paꞌiona, Maijaꞌquëpi Pablo cayere deꞌoyerepa asaja̱co caquë necaina, ai Pablo cayeseꞌe asao, siꞌaye i̱ quëaye. Ja̱o cato Maijaꞌquëre se̱co pacoꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ja̱je paꞌiopi i̱o tsëcapë ja̱ꞌre co̱ni oco do cua̱ñoni yëquëre cao: “Mësarupi yëꞌëre sehuosicore pare ñani yëꞌë huëꞌena sani pëajë̱ꞌë.” Ja̱je caco ai se̱ona, i̱o huëꞌena sani pëahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Pëasicohuaꞌipi teꞌe muꞌse Maijaꞌquëre se̱ hue̱ꞌñana saijë teꞌo nomi tsi̱o ta̱ꞌñe yequë muꞌseña paꞌi ja̱ꞌñere quëa joyore hueꞌeconi ti̱ꞌahuë. Ja̱je paꞌiopi i̱o ëjaohuaꞌire jaiye curiquë necaico pacoꞌë, i̱o ta̱ꞌñe ca doꞌipi. I̱o cato i̱ohuaꞌi joꞌyao pacoꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ja̱je paꞌiopi Pablore cuiꞌne yëquëre peꞌte huëoni peꞌteco cuio: “¡Icohuaꞌi cato Diusu tutu quëꞌire pare necaicohuaꞌi aꞌë. Ja̱je paꞌiohuaꞌipi mësarute huaso cocare pare quëayë!” ");
INSERT INTO seyNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ja̱jeseꞌe siꞌa muꞌseña cuico peꞌteroja̱iona, yoꞌo jujani Pablopi coꞌye po̱nëni i̱ote ta̱ꞌñe ca cocare capi: “Jesucristo mamipi cua̱ñeñë, icore je̱oni etani saijë̱ꞌë, coꞌa joyo.” Ca macarepa ja̱re i̱ti macapi coꞌa joyo i̱ote etani sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ja̱je huatipi etaëna, i̱o ëjaohuaꞌipi ñani yure curiquë neñe peoji cuasajë Pablore cuiꞌne Silasre tse̱ahuë. Tse̱ani coꞌamaña huero hue̱ꞌñana sahuë, ja̱ daripë ëjaohuaꞌi quëꞌrona. ");
INSERT INTO seyNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Dani ëjaohuaꞌire cahuë: “Icohuaꞌi Israel pa̱i aꞌë. Ja̱ohuaꞌipi mai daripë ai jo̱sa yoꞌoyë. ");
INSERT INTO seyNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Israel pa̱i yoꞌoyere yeꞌyayë, ja̱ohuaꞌi. ¿Me mai romano pa̱i i̱ohuaꞌi caye asani yoꞌoyeꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Cajëna, siꞌaohuaꞌi cuiꞌne cahuë. Cajëna, ja̱ daripë pa̱i yoꞌoye ñacohuaꞌipi Pablore cuiꞌne Silasre juꞌi ca̱ña duꞌteni siꞌsejë̱ꞌë, cua̱ñehuë. ");
INSERT INTO seyNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Cua̱ñejëna, ai siꞌsehuë. Siꞌse tëjini co hue̱ꞌñana sani cosicohuaꞌire ñaquëre deꞌhua ñajëꞌë, icohuaꞌire cajë cua̱ñeni co huesohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Cua̱ñerena, asani ai sa̱ꞌnahuë tuꞌrihuëna sani copi. Coni so̱quë totona co̱ña nesicona nëcañoa jua nëoni hue̱ñopi. ");
INSERT INTO seyNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Hue̱ñosicohuaꞌipi ñuꞌijë jopo ñami paꞌina, Pablopi cuiꞌne Silaspi co̱ni Maijaꞌquëre se̱jë cuiꞌne jë̱jë yoꞌojëna, siꞌa cosicohuaꞌi asahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ja̱ macarepa yejapi ai ñuꞌcueo. Ñuꞌcuecona, co hue̱ꞌña eta saꞌnoapi siꞌaye huiꞌyo sao, cuiꞌne pa̱ire quë̱na meapi hue̱seꞌeje̱ to̱me sapi, peo hue̱ꞌña. ");
INSERT INTO seyNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ja̱ maca cosicohuaꞌire ñaquëpi sëtani huiꞌyoseꞌe eta saꞌnoa paꞌiona, ñani cosicohuaꞌipi tsoe etahuë cuasaquë i̱ huaꞌtipi dutani coꞌye huasiꞌi caquë yoꞌopi. ");
INSERT INTO seyNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Yoꞌoquëna, Pablopi tutu capi: “Yoꞌomaꞌë. Siꞌaohuaꞌi yëquë iye macare paꞌiyë.” ");
INSERT INTO seyNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Caquëna, asani miañe dajë̱ꞌë cani tsasiquë caꞌraquë huëꞌhuë cacani Pablo cuiꞌne Silas quë̱o quëꞌrona doꞌre jaꞌrupi. ");
INSERT INTO seyNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Yoꞌo tëjini huëni nëcani Pablore cuiꞌne Silasre etoni se̱jiꞌi: “¿Huasosiquë paꞌiye cani me yoꞌoye paꞌiquëꞌni, yëꞌë?” ");
INSERT INTO seyNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Se̱ina cahuë: “Jesucristoni sehuojë̱ꞌë. Sehuoni huasosiquë paꞌija̱ꞌquë aꞌë, mëꞌë. Cuiꞌne mëꞌë huëꞌe acohuaꞌi huasosicohuaꞌi paꞌija̱ꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ja̱ maca i̱te cuiꞌne siꞌaohuaꞌi i̱ huëꞌe acohuaꞌire mai Ëjaë cocare quëahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ja̱re i̱ti quëa tëji maca, cosicohuaꞌire ñaquëpi Pablore cuiꞌne Silasre siꞌseseꞌe aꞌsi tsoapi. Ja̱ jeteyoꞌje i̱ cuiꞌne siꞌaohuaꞌi i̱ huëꞌe acohuaꞌi oco do cua̱ñohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Do tëjisi maca tu̱mani Pablore cuiꞌne Silasre i̱ huëꞌena sani a̱opi. I̱ cuiꞌne i̱ tsëcapë acohuaꞌi Maijaꞌquëre sehuosicohuaꞌi paꞌijë ai sihuahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Nea hue̱ꞌña paꞌi maca pa̱i yoꞌoye ñani ca deꞌhuacohuaꞌipi Pablore cuiꞌne Silasre eto saojë̱ꞌë cajë cosicohuaꞌire ñaquëre quëaja̱ꞌa soldado pa̱ire jëjo daohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Sani quëarena, cosicohuaꞌire ñaquëpi capi, Pablore: “Pa̱i yoꞌoye ñacohuaꞌipi yëꞌëre mësarute eto saojë̱ꞌë, cua̱ñehuë. Ja̱je paꞌiye sëte se̱ñajë deꞌoye saijë̱ꞌë, yure.” ");
INSERT INTO seyNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Caquëna, Pablopi capi: “Quëañuꞌu cajë daisicohuaꞌire soldado pa̱ire yëquë romano pa̱ini mësaru ti coꞌaye yoꞌoseꞌeje̱ camaꞌpë doꞌi peocohuaꞌini siꞌa pa̱i ñajëna, siꞌsehuë. ¿Yure ja̱je yoꞌosicohuaꞌipi yahuerepa etoñuꞌu cayë? Ja̱je yoꞌoye coeyë, i̱ti yëquëre cosicohuaꞌipi dani eto saoja̱jë.” ");
INSERT INTO seyNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Caquëna, soldado pa̱ipi sani romano pa̱i aꞌë, quëarena, pa̱i yoꞌoye ñani ca deꞌhuacohuaꞌipi quëquëhuë. ");
INSERT INTO seyNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Quëquësicohuaꞌipi dani pa̱i yoꞌoye ca deꞌhua ëjaohuaꞌipi yëquë mësarute coꞌaye yoꞌoseꞌe oijë̱ꞌë cajë se̱iꞌë, Pablore cuiꞌne Silasre. Ja̱je cani etoni iye daripëpi etani saijë̱ꞌë cajë se̱iꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Se̱tena, Pablopi cuiꞌne Silaspi co hue̱ꞌñapi etani Lidia huëꞌena saëꞌë. Sani sehuosicohuaꞌire ñajë cuiꞌne je̱omaꞌpë tuijë̱ꞌë cajë yëhuo tëjini etani saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pablo cuiꞌne Silas saicohuaꞌipi Anfípolis cuiꞌne Apolonia dari sa sani Tesalónica daripëna ti̱ꞌahuë. Ti̱ꞌarena, ja̱rote Israel pa̱i tsiꞌsi huëꞌe pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paꞌina, Pablopi i̱ noni yoꞌoroja̱iñe sëte Israel pa̱i tsiꞌsi huëꞌena sajiꞌi, toaso̱ semanarepa huajë muꞌse ñape sai i̱ohuaꞌi ja̱ꞌre Maijaꞌquë toyapëre ñaquë i̱ti cayeje̱ paꞌye, ");
INSERT INTO seyNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","caquë quëaquëpi. Jesús ju̱ꞌisiquëpi cuiꞌnaëpi huajëquë huëiye paꞌiji. “Ja̱je paꞌina, yëꞌë mësarute quëaquë Jesús i̱ api, maire huasoquë.” ");
INSERT INTO seyNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Caquëna, Israel pa̱i acohuaꞌipi sehuoni Pablona cuiꞌne Silasna tsiohuë. Cuiꞌne jai pa̱i Maijaꞌquëre se̱cohuaꞌipi griego pa̱ije sehuohuë. Sehuojëna, cuiꞌne jai pa̱i ëja nomiohuaꞌije̱ sehuohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ja̱je sehuojëna, ñani oijë pë̱ijë Israel pa̱i sehuomaꞌcohuaꞌipi coꞌa pa̱i maꞌñare nemaꞌpë coꞌa nëcaroja̱icohuaꞌini tsiꞌsohuë, ja̱ohuaꞌipi ca huëojëna, siꞌa pa̱i daripë paꞌicohuaꞌipi pë̱ti huëoni jo̱sa yoꞌojë caja̱jë cajë. Ja̱je yoꞌojëna, tsiꞌsisicohuaꞌipi Pabloni cuiꞌne Silasni coejë Jasón huëꞌena to̱mejani cacani jo̱sa yoꞌohuë, paꞌijëna, tse̱ani etoni pa̱ina i̱siñuꞌu cajë. ");
INSERT INTO seyNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Yoꞌojëna, i̱ohuaꞌi cajë yoꞌocohuaꞌipi peojëna, coa paꞌiohuaꞌini Jasónni cuiꞌne yecohuaꞌi sehuosicohuaꞌini tse̱ani quërë etoni ja̱ daripë pa̱i ëjaohuaꞌi quëꞌrona sahuë. Sani cuijë cahuë: “Icohuaꞌipi siꞌa hue̱ꞌña paꞌicohuaꞌire ti̱ñe paꞌiyena po̱najë yoꞌocohuaꞌipi i̱ñoje dani yoꞌoyë. ");
INSERT INTO seyNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yoꞌojëna, Jasónpi i̱ohuaꞌire oi i̱ huëꞌena pëaye i̱sipi. Ja̱je yoꞌocohuaꞌi siꞌaohuaꞌi César siꞌa pa̱i ëjaë cua̱ñeseꞌere sa̱ñope yoꞌoyë. Yoꞌojë cayë, yequë pa̱i ëjaërepa paꞌiji, Jesu api i̱repa cayë.” ");
INSERT INTO seyNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Cajëna, ja̱ daripë acohuaꞌipi cuiꞌne i̱ohuaꞌi ëjaohuaꞌipi asani ¿ja̱ jerepa yoꞌocohuaꞌi aꞌni? cuasa huëohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Cuasajëtaꞌare Jasónpi cuiꞌne yecohuaꞌi sehuosicohuaꞌipi mësaru cua̱ñeñe ti̱ꞌacaija̱ꞌcohuaꞌi aꞌë cani curiquëre i̱si nëoni eto cua̱ñohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ja̱ ñami sehuosicohuaꞌipi esa Berea daripëna saijë̱ꞌë cajë jëjo saohuë, Pablore cuiꞌne Silasre. Jëjo saojëna, saisicohuaꞌipi ti̱ꞌani Israel pa̱i tsiꞌsi huëꞌena cacahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Berea acohuaꞌi Israel pa̱i deꞌo pa̱i paëꞌë. Tesalónica pa̱ire sa tëto saisicohuaꞌi paëꞌë. Ja̱je paꞌiohuaꞌipi Pablo quëaye deꞌoye asajë nuñerepa quëaquë cajë siꞌa muꞌseñapi Maijaꞌquë toyapëre ñahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ja̱je yoꞌojë jai pa̱i Israel pa̱i acohuaꞌipi sehuohuë. Sehuojëna, cuiꞌne griego pa̱i ë̱mëohuaꞌi cuiꞌne ëja nomiohuaꞌije̱ sehuohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Sehuojëna, Pablopi Bereana Maijaꞌquë coca quëaquë paꞌiji asani Tesalónica Israel pa̱ipi Bereana dani Pablore pa̱ipi jo̱sa yoꞌo ja̱ꞌñe ne huëohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ja̱je yoꞌo huëojëna, sehuosicohuaꞌipi Pablore esa eto saohuë, jai tsiaya të̱ꞌtëpa quëꞌrona. Jëjo saojëna, coa Silaspi cuiꞌne Timoteopi co̱ni pëahuë, Bereana. ");
INSERT INTO seyNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pëarena, Pablore co̱ni saijë sasicohuaꞌipi Atenas daripëja̱ꞌa je̱ojani coꞌihuë. Coꞌijë Timoteore cuiꞌne Silasre Pablo esa daijë̱ꞌë caseꞌere dani quëahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pablopi Silasre cuiꞌne Timoteore Atenas daripëpi paꞌi utequë siꞌa hue̱ꞌña pa̱i deꞌhuasi diusure paseꞌe paꞌijëna, ñaquë ojiꞌi, coꞌayerepa yoꞌoyeꞌni cuasaquë. ");
INSERT INTO seyNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ja̱je paꞌina, Israel pa̱i tsiꞌsi huëꞌena cacaquë Israel pa̱i ja̱ꞌre cuiꞌne Maijaꞌquëre se̱cohuaꞌi ja̱ꞌre co̱ni capi. Caquë cuiꞌne siꞌa muꞌseñapi huero hue̱ꞌñana tsiꞌsisicohuaꞌireje̱ yëhuoquë capi. ");
INSERT INTO seyNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Caquëna, pa̱i paꞌiye asacohuaꞌi epicúreos pa̱ipi cuiꞌne estoicos pa̱ipi i̱te ca huëoni cajë yecohuaꞌipi cahuë: “¿I̱quere iquë caquëꞌni, jai cocaë maca?” Cajëna, yecohuaꞌipi cahuë: “Yequë pa̱i diusuohuaꞌi ayere quëacaiquë api cuasayë.” Ja̱je cahuë, Pablopi deꞌo coca Jesús ayere cuiꞌne i̱ ju̱ꞌisiquëpi huëiseꞌere quëaquëna. ");
INSERT INTO seyNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ja̱ maca Pablore Areópago cu̱tihuëna sahuë, ëjaohuaꞌi tsiꞌsi hue̱ꞌñana. Sani i̱te se̱iꞌë: “¿Yëquë asaye yëyë, i̱que huajë yeꞌyaye aꞌni, iye mëꞌë yëquëre quëaye? ");
INSERT INTO seyNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Yëquë asa maꞌñere mëꞌëpi caquëna, asa jujani ¿i̱quere mëꞌë caye quëaquëꞌni? cajë se̱ñë, mëꞌëre.” ");
INSERT INTO seyNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Atenas pa̱ipi cuiꞌne ti̱ pa̱ipi i̱ti maca paꞌicohuaꞌipi ja̱ꞌa yoꞌoseꞌere paseꞌe asacohuaꞌi paëꞌë. Ja̱je paꞌiohuaꞌi sëte ja̱je cahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Cajëna, i̱ohuaꞌi joporepa paꞌiquëpi Pablo huëni nëcani Areópago cu̱tihuëpi nëcaquë i̱ohuaꞌire capi: “Atenas pa̱i yëꞌë mësarute ñañe cato mësaru diusuohuaꞌire cuasañuꞌu cajë ai yëjë yoꞌocohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ja̱je yoꞌocohuaꞌini yëꞌë mësaru se̱ hue̱ꞌñana cacani i̱ti tëojë se̱ hue̱ꞌñana ñeje toyaseꞌe paꞌina, ñahuë: ‘Ti pa̱i ñamaꞌa diusure se̱ hue̱ꞌñaꞌë.’ Ja̱je paꞌina, yëꞌë, ja̱ë mësaru ti ñamaꞌpë se̱ diusu ayere quëaquë aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Ja̱ëpi yeja cuiꞌne i̱ote paꞌiye nesiquë ja̱je paꞌina, i̱ api, maꞌtëmo cuiꞌne yeja ëjaërepa. Ja̱je paꞌipi pa̱i nesi huë̱ꞌñare paꞌimaꞌquë api. ");
INSERT INTO seyNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Pa̱ini necaijë̱ꞌë, yëꞌëre camaꞌquë api. I̱ api, maire paꞌiye siꞌaye yëꞌeye cuiꞌne yequë coꞌamañaje i̱sisiquë. ");
INSERT INTO seyNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Teꞌire pa̱ire deꞌhuasiquëpi ja̱ëpi teꞌipi jai pa̱i daripë̱a nepi, Maijaꞌquëpi siꞌa yeja paꞌija̱jë caquë. Ja̱je paꞌina, i̱pi i̱ohuaꞌi paꞌija̱ꞌto cuiꞌne i̱te i̱ohuaꞌi coꞌeja̱ꞌa macaje̱ ca nëopi. ");
INSERT INTO seyNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ja̱ohuaꞌipi Maijaꞌquë mai quë̱no macare paꞌiquëtaꞌare coa cuasarepa i̱na coꞌe ti̱ꞌajajë caquë nepi. ");
INSERT INTO seyNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ja̱je paꞌina, mai i̱na paꞌiyë, huajëcohuaꞌi paꞌijë cuꞌiyë. Mësaru aipë ta̱ꞌñe coca cacohuaꞌi caseꞌerepa: ‘Mai cato Maijaꞌquë tsëcapë acohuaꞌi aꞌë’. ");
INSERT INTO seyNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ja̱je Maijaꞌquë tsëcapë acohuaꞌi sëte pa̱i i̱ohuaꞌi cuasayepi huëojë curiquëpi, po curiquëpi cuiꞌne quë̱napi deꞌhuaseꞌere Maijaꞌquëje̱ paꞌi api, cuasamaꞌpë pañuꞌu. ");
INSERT INTO seyNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ai tsoe cato Maijaꞌquë pa̱i huesëjë yoꞌoye coa ñaquë pajiꞌi. Ja̱je paꞌisiquëtaꞌa yure cato Maijaꞌquë cua̱ñeji, siꞌa hue̱ꞌña paꞌicohuaꞌire i̱na sehuojë daijë̱ꞌë caquë. ");
INSERT INTO seyNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ja̱je paꞌina, Maijaꞌquëpi pa̱i yoꞌoseꞌe nuñerepa caquë ne deꞌhuaja̱ꞌa muꞌse ca nëopi: Jesu api, ja̱ yoꞌoye yoꞌoja̱ꞌquë, i̱ joꞌya nesiquëpi. Ja̱je paꞌina, Jesuna cuasaye paꞌiji caquë siꞌaohuaꞌire i̱ñopi, ju̱ꞌisiquëni huëoquë.” ");
INSERT INTO seyNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ja̱je ju̱ꞌisicohuaꞌi huëiye ayere caquëna, asani cueꞌcuehuë. Cueꞌcuejëna, yecohuaꞌipi cahuë: “Yequë muꞌse asañuꞌu, mëꞌë caye.” ");
INSERT INTO seyNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Cajëna, ja̱ohuaꞌire quëaye je̱opi. ");
INSERT INTO seyNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ja̱je paꞌiquëtaꞌare yecohuaꞌipi sehuohuë. Sehuoni i̱ ja̱ꞌre co̱ni tsiohuë. Cuiꞌne ja̱ohuaꞌi ja̱ꞌre co̱ni paëꞌë, Dionicio. Cuiꞌne teꞌe nomio Dámaris hueꞌeco pacoꞌë. Ja̱ohuaꞌi cato Areópago tsëcapë acohuaꞌi paëꞌë. Paꞌijëna, cuiꞌne yecohuaꞌije̱ co̱ni paëꞌë, i̱ohuaꞌi ja̱ꞌre co̱ni. ");
INSERT INTO seyNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ja̱je yoꞌo tëjini Atenaspi etani Corinto daripëna sajiꞌi, Pablo. ");
INSERT INTO seyNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ja̱rona teꞌire Israel pa̱ire Aquilare ti̱ꞌapi. Ja̱ë cato Ponto yeja aquë pajiꞌi. Ja̱je paꞌipi Pablo ja̱ yëꞌtaꞌa ti̱ꞌamaꞌnë Aquila cuiꞌne i̱ paco Priscilapi co̱ni Pontona ti̱ꞌasicohuaꞌipi paëꞌë. Ja̱ohuaꞌi cato Italiapi etani daisicohuaꞌi paëꞌë. Claudio romano pa̱i ëjaëpi siꞌa Israel pa̱i Roma paꞌicohuaꞌi etaye paꞌiji caquë cua̱ñequëna, etasicohuaꞌi paëꞌë. Ja̱je paꞌiohuaꞌini Pablo doꞌi ñasiꞌi caquë sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Sani i̱ohuaꞌi ja̱ꞌre co̱ni pëapi. I̱ohuaꞌi neñeje paꞌye ca̱ꞌnipi huë̱ꞌña nequë sëte i̱ohuaꞌi ja̱ꞌre co̱ni nesiꞌi caquë pëapi. ");
INSERT INTO seyNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Pëasiquëpi paꞌi siꞌa huajë muꞌseña Israel pa̱i tsiꞌsi huëꞌena sai quëapi, Israel pa̱ire cuiꞌne yequë pa̱ire asare paja̱jë caquë. ");
INSERT INTO seyNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Macedonia paꞌicohuaꞌipi Silas cuiꞌne Timoteo co̱ni ti̱ꞌasi maca Pablopi siꞌa muꞌseña Maijaꞌquë coca quëa huëoni quëaquë judío pa̱ire capi. Jesús pajiꞌi, maire huasoquërepa. ");
INSERT INTO seyNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ja̱je caquëna, ja̱ohuaꞌipi i̱te sa̱ñope cajë pë̱ꞌë. Pë̱ijëna, Pablo ña jujani i̱ohuaꞌire sa̱ñope cayere i̱ñosiꞌi caquë i̱ juꞌi ca̱re ta̱ꞌtë to̱pi. Ta̱ꞌtë to̱ni capi, i̱ohuaꞌire: “Mësaru doꞌi pasipi mësaru ne huesëye, yëꞌë doꞌi peosipi. Ja̱je paꞌina, yurepi jerepa cato judío pa̱i peocohuaꞌina sani Maijaꞌquë coca quëaja̱ꞌquë aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Cani tsiꞌsi hue̱ꞌñapi etani Justo huëꞌena sajiꞌi, Maijaꞌquëre se̱quë huëꞌena, Israel pa̱i tsiꞌsi huëꞌe quë̱no maca paꞌi huëꞌena. ");
INSERT INTO seyNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ja̱je paꞌiquëtaꞌare Israel pa̱i tsiꞌsi huëꞌe ñacohuaꞌi ëjaërepa Crispo hueꞌequëpi Maijaꞌquë coca asani sehuopi. Sehuoquëna, cuiꞌne siꞌaohuaꞌi i̱ tsëcapë acohuaꞌije̱ sehuohuë. Sehuojëna, cuiꞌne Corinto daripë acohuaꞌije̱ jai pa̱i sehuohuë. Sehuorena, oco dopi, sehuosicohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ja̱je yoꞌoquë paꞌina, teꞌe ñami Ëjaëpi ca̱ni ñañeje paꞌyeja̱ꞌa ñaini capi, Pablore: “Caꞌramaꞌë paꞌijë̱ꞌë, coca quëaye, je̱omaꞌë cajë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Yëꞌë coca sehuoja̱ꞌcohuaꞌire iye daripë acohuaꞌire jai pa̱ire payë. Yëꞌëpi mëꞌë ja̱ꞌre co̱ni paꞌiyë. Paꞌina, mëꞌëre pa̱ipi coꞌaye yoꞌo ti̱ꞌañe pa̱jaꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Caëna, asani Pablopi Corintona teꞌe o̱metëcahuë jopore paja̱ꞌa pëani paꞌi Maijaꞌquë cocare yeꞌyapi, i̱ohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ja̱je yoꞌoquë paꞌina, Acaya pa̱i ëjaë Galión paꞌi maca judío pa̱ipi Pablore sa̱ñope yoꞌoñuꞌu cajë tsiꞌsihuë. Tsiꞌsini tse̱ani sahuë, pa̱i yoꞌoye ca deꞌhua hue̱ꞌñana. ");
INSERT INTO seyNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Sani i̱ohuaꞌi ëjaëre cahuë: “Iquëpi cua̱ñeseꞌe cayeje̱ paꞌye yoꞌomaꞌpë, ti̱ñe Maijaꞌquëre se̱ñe paꞌiji caquë pa̱ire yeꞌyaquë api.” ");
INSERT INTO seyNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Cajëna, asani Pablopi casiꞌi cuasaquëna, Galiónpi duꞌruja̱ꞌa capi, Israel pa̱ire: “Coꞌaye yoꞌoseꞌere pa̱nitaꞌa pa̱ire huani je̱oseꞌere yoꞌojë catotaꞌa mësaru Israel pa̱ire asa catiraꞌhuë. ");
INSERT INTO seyNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ja̱je paꞌiquëtaꞌare yure cato coa coca yëꞌoseꞌe caseꞌere, mami ayere, cuiꞌne mësaru cua̱ñeñe ayere yoꞌojë cayë. Ja̱je paꞌiye sëte mësaruseꞌe ne deꞌhuajë̱ꞌë. Mësaru yoꞌojë cayere cuiꞌna maca yoꞌoquë caye coeyë.” ");
INSERT INTO seyNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ja̱je cani pa̱i yoꞌoseꞌe ca deꞌhua hue̱ꞌñapi eto saopi, i̱ohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Eto sauna, pa̱i yoꞌoseꞌe ca deꞌhua hue̱ꞌña ti̱ña macare pana Sóstenesre tse̱ani tëꞌcahuë. Ja̱ë cato Israel pa̱i tsiꞌsi huëꞌe ñacai ëjaë pajiꞌi. Ja̱je yoꞌotoje̱ Galión cato coꞌa ju̱ꞌi ñañe pa̱pi, i̱ohuaꞌi yoꞌoye. ");
INSERT INTO seyNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Ja̱ yëꞌtaꞌa Pablo Corinto daripëna pëasiquëpi tsoe muꞌseña pajiꞌi. Paꞌiquëpi sai huëoni sehuosicohuaꞌire saiyë, caquë pëpa tëjini sai Priscila cuiꞌne Aquila ja̱ꞌre co̱ni sajiꞌi. Siria yejana yohuëja̱ꞌa ja̱ yëꞌtaꞌa yohuë aya mëimaꞌnë Cencreana naña peo caꞌtopë hueopi, i̱ nesiꞌi ca nëoseꞌere yoꞌo ti̱ꞌasiꞌi caquë. ");
INSERT INTO seyNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ja̱je yoꞌosi jeteyoꞌje Efesona ti̱ꞌahuë. Ti̱ꞌani Pablopi Priscilare cuiꞌne Aquilare je̱oni Israel pa̱i tsiꞌsi huëꞌena sajiꞌi. Sani Israel pa̱i tsiꞌsicohuaꞌi ja̱ꞌre coca capi. ");
INSERT INTO seyNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Caquëna, asani i̱ohuaꞌipi i̱te pëajë̱ꞌë cajë se̱iꞌë. Se̱jëna, pa̱ñë, pëaye cani. ");
INSERT INTO seyNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Pëpani sai capi: “Maijaꞌquëpi yëna cuiꞌnaëpi yeque coꞌini ñasiꞌi.” Cani ja̱ jeteyoꞌje yohuëna aya mëni Efesopi yequë hue̱ꞌñana sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ja̱ maca Cesareana ti̱ꞌani sehuosicohuaꞌire pëpasiꞌi caquë Jerusalénna sajiꞌi. Sani ja̱ropi yuretaꞌa Antioquíana sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Sani ja̱rona tsoe maca pani yuretaꞌa cuiꞌnaëpi cuꞌi huëo co̱pi, pa̱i ñape darina, Galacia cuiꞌne Frigia yeja daripë̱ana, sehuosicohuaꞌire tutu quëꞌiohuaꞌire quëa huasoquë. ");
INSERT INTO seyNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ja̱ muꞌseña teꞌi Israel pa̱i aquëpi Apolos hueꞌequëpi Efesona ti̱tapi, Alejandría daripë aquëpi. Ja̱ë cato ai ta̱ꞌñe coca caquë cuiꞌne Maijaꞌquë toyapë ai deꞌoyerepa asaquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ja̱je paꞌipi mai Ëjaërepa coca paꞌiyena yeꞌyesiquë pajiꞌi. Ja̱je paꞌipi tuturepa caquë Jesús ayere ti̱ñarepa yeꞌyapi, coa Juan oco doyeseꞌe asaquëtaꞌa. ");
INSERT INTO seyNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ja̱je paꞌipi Apolos Israel pa̱i tsiꞌsi huëꞌena jai pa̱i asajëna, caquëna, Priscila cuiꞌne Aquilapi asani i̱te teꞌire ti̱rona sani quëahuë, ai ti̱ñarepa Maijaꞌquë coca ayere. ");
INSERT INTO seyNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Quëasiquëpi Apolos Acayana sasiꞌi caquë yoꞌoquëna, sehuosicohuaꞌipi i̱ sai ja̱ꞌñe co̱caëꞌë. Co̱caijë cuiꞌne teꞌe carta toyahuë, Acaya sehuosicohuaꞌi paꞌicohuaꞌina deꞌoye i̱te pëpacaijë̱ꞌë cajë. Ja̱je yoꞌorena, Acaya ti̱ꞌani Maijaꞌquë oi doꞌipi sehuosicohuaꞌire ai deꞌoyerepa co̱cajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Co̱cai siꞌaohuaꞌi ña hue̱ꞌñana Israel pa̱ire toyapëna ñaquë Jesús i̱repa maire huasoquë pajiꞌi caquë sa̱ñope capi. I̱ohuaꞌije̱ mëꞌë coa cayë caye peoyere papi, capi. ");
INSERT INTO seyNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolos Corintore paꞌina, Pablopi cu̱ti quëꞌroja̱ꞌa sa sani Efesona ti̱ꞌapi. Ti̱ꞌani ja̱rona jai pa̱ire sehuosicohuaꞌire ti̱ꞌapi. ");
INSERT INTO seyNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ti̱ꞌani ja̱ohuaꞌire se̱jiꞌi: “¿Mësaru sehuo maca deꞌo joyo tsio daquë?” Caquëna, i̱ohuaꞌipi cahuë: “Pa̱ni, deꞌo joyo paꞌiye ayeque caye yëquë ti asamaꞌcohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Cajëna, Pablopi capi: “¿I̱quere asajë do cua̱ñoreꞌni?” Caquëna, i̱ohuaꞌipi cahuë: “Juan oco doquë quëaseꞌere asani sehuojë do cua̱ñosicohuaꞌi aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Cajëna, Pablopi capi: “Deꞌoji, Juan cato coꞌaye yoꞌoseꞌere je̱oni Maijaꞌquëna po̱nëcohuaꞌini oco dopi, doquë capi: ‘I̱ jeteyoꞌje daiquëni sehuoye paꞌiji.’ Ja̱ëre cato Jesuni.” ");
INSERT INTO seyNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ja̱je caquëna, asani Jesuni i̱re papi cuasani sehuorena, Ëjaë Jesús mamipi cani dopi, i̱ohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Dosicohuaꞌini Pablopi jë̱ñapi patoquëna, deꞌo joyopi i̱ohuaꞌina tsio dajiꞌi. Tsio daina, yequë cocapi cajë yoꞌohuë. Yoꞌojë Maijaꞌquë cayere asajë yecohuaꞌina se quëahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","I̱ti ja̱je yoꞌosicohuaꞌi cato doce ë̱mëohuaꞌi paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pablopi pa̱ire Maijaꞌquë cua̱ñe te̱ꞌte ayere quëare pasiꞌi caquë ti caꞌramaꞌë toaso̱ ñañëohuaꞌire Israel pa̱i tsiꞌsi huëꞌena sai capi. ");
INSERT INTO seyNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Caquëna, yecohuaꞌipi sehuocaiye pa̱jë, siꞌaohuaꞌi ña hue̱ꞌñana huajë maꞌa Pablo yeꞌyaye coꞌaye aꞌë cahuë. Cajëna, Pablopi ja̱ohuaꞌire je̱oni sehuosicohuaꞌiseꞌere huani sapi, Tiranno coca ca huëꞌena. ");
INSERT INTO seyNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ja̱rona sani siꞌa muꞌseñapi coca caquë ja̱jeseꞌe caya o̱metëcahuë̱a yoꞌopi. Yoꞌoquë paꞌina, Asia provincia yeja paꞌicohuaꞌipi Israel pa̱ipi cuiꞌne Israel pa̱i peocohuaꞌipi Ëjaë coca asahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ja̱je yoꞌoquëna, Maijaꞌquëpi Pablo ja̱ꞌre paꞌi jaiye pa̱i yoꞌo ti̱ꞌa maꞌñe yoꞌopi. ");
INSERT INTO seyNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Yoꞌoquëna, Pablo juꞌi ca̱ñapi cuiꞌne aꞌri të̱no ca̱ꞌti pë̱a i̱ papiseꞌepi ju̱ꞌicohuaꞌina sani nejëna, ju̱ꞌicohuaꞌipi coꞌyahuë. Cuiꞌne huati quëꞌiohuaꞌije̱ huatire eto sao cua̱ñohuë. Ja̱ jerepa yoꞌopi. ");
INSERT INTO seyNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ja̱je yoꞌoquëna, ñani cuiꞌne Israel pa̱ije paëꞌë, maꞌajaꞌa cuꞌijë huati joñoapi pa̱ire paꞌiye eto saohuaꞌije̱, coa yoꞌocohuaꞌi. Ja̱ohuaꞌipi cuasahuë, Jesús mamipi cajë huatire eto saoye paꞌiji. Cuasani huati joñoare cahuë: “Pablo quëaquë Jesús mamipi cua̱ñeñë, etajë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Iye yoꞌoye cato Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaërepa Israel pa̱i Esceva siete mamajëpi yoꞌohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ja̱je yoꞌocohuaꞌini yequë muꞌse huati joyopi i̱ohuaꞌire sa̱ñope sehuoquë capi: “Jesure asayë, cuiꞌne Pabloreje̱ asayë. ¿Mësarutaꞌa ne aꞌni?” ");
INSERT INTO seyNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Caquë ja̱re i̱ti macapi huati quëꞌipi ja̱ohuaꞌire tuturepa yoꞌoquë tse̱ani aꞌsi neina, aꞌsi quëꞌiohuaꞌipi ca̱ña peoñoa huëꞌepi etani cati saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Iye yoꞌoseꞌere siꞌaohuaꞌi Efeso paꞌicohuaꞌi griego pa̱i cuiꞌne Israel pa̱i asani caꞌrahuë. Ja̱je yoꞌojëna, Jesús mami jerepa ai deꞌoye aꞌë, siꞌa hue̱ꞌña paꞌicohuaꞌi cahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ja̱je cuiꞌne jai pa̱i sehuosicohuaꞌipi i̱ohuaꞌi coꞌaye yoꞌoseꞌere jai pa̱i ña hue̱ꞌñana oijë quëahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Quëajëna, cuiꞌne jai pa̱i ja̱ꞌnë dahuëohuaꞌi paꞌisicohuaꞌipi i̱o dahuë toyapëre pa̱i ña hue̱ꞌñana dani ëohuë. Ja̱ toyapë doꞌire cue̱cue ñañe cato cincuenta mil curiquë të̱ꞌñarepa doꞌi pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ja̱je yoꞌoco mai Ëjaë coca jerepa jai sacoꞌë, siꞌa hue̱ꞌña i̱o tuture pa̱ire i̱ñoco. ");
INSERT INTO seyNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ja̱ jeteyoꞌje Pablo Macedoniana cuiꞌne Acayana doꞌi sani cuiꞌne ja̱ropi Jerusalénje̱ doꞌi sasiꞌi cuasapi. Cuasaquë yequeje̱ capi, ja̱ro Jerusalén saisi jeteyoꞌje Romaje̱ saija̱ꞌquë aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ja̱je caquë Timoteore cuiꞌne Erastore i̱ti co̱caicohuaꞌire cayaohuaꞌire Macedoniana jëjo saopi, i̱seꞌe ja̱ yëꞌtaꞌa Asia yejana aꞌri maña pëaquë. ");
INSERT INTO seyNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ja̱ muꞌseña Efeso daripë paꞌicohuaꞌipi ai jo̱sa yoꞌojë cahuë, huajë maꞌa ayere. ");
INSERT INTO seyNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Demetrio po curiquë deꞌhuaquëpi ca huëouna. Ja̱ëpi diusa Diana huëꞌeje̱ paꞌye aꞌri huë̱ꞌña maña nequë pajiꞌi. Ja̱je nequëpi i̱te co̱caicohuaꞌire jaiye curiquë i̱siquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ja̱ëpi i̱te co̱caicohuaꞌire cuiꞌne i̱ neñeje paꞌye necohuaꞌire tsiꞌsopi. Tsiꞌsoni capi: “Ëjaohuaꞌi mësarupi asayë, iye aꞌri huë̱ꞌña deꞌhua doꞌi mai deꞌoye paꞌiye. ");
INSERT INTO seyNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ja̱je paꞌiquëtaꞌare ja̱ë Pablopi mësarupi asajë cuiꞌne ñajëna, caji, pa̱i deꞌhuaseꞌe diusu peoye aꞌë. Ja̱je caquë jai pa̱ire yeꞌya huesoji, i̱ cayena. I̱ño Efeso pa̱ire cuiꞌne siꞌa Asia provincia paꞌicohuaꞌire ja̱je yeꞌyaji. ");
INSERT INTO seyNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Iye i̱ ja̱je yeꞌyaye ai coꞌaji, mai coꞌamaña peo hue̱ꞌña ne huesëye paꞌiji, cuiꞌne diusa Dianaje̱ i̱o yure doꞌi quëꞌio paꞌiye peo hue̱ꞌña to̱meñe paꞌiji. Ja̱je to̱meni iye diusa coꞌa coa cueꞌcue cua̱ñojaꞌcoa. Yure iye provincia Asia paꞌicohuaꞌi tse̱copi cuiꞌne iye yeja siꞌa yeja paꞌicohuaꞌi tse̱copi caraja̱sio.” ");
INSERT INTO seyNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Caquëna, asani pë̱titeni tutu cuijë cahuë: “Paꞌijë̱ꞌë, Diana Efesios pa̱i jaꞌcorepa.” ");
INSERT INTO seyNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ja̱je yoꞌojë cajëna, siꞌa i̱ti daripë acohuaꞌi coa huesë asahuë, i̱ohuaꞌi yoꞌojë caye. Ja̱je yoꞌojë cajë Pablore co̱cohuaꞌire cayaohuaꞌire Macedonia acohuaꞌire Aristarcore cuiꞌne Gayore tse̱ani quërëjë sahuë, pa̱i tsiꞌsijë ña hue̱ꞌña quëꞌrore pana. ");
INSERT INTO seyNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Ja̱je yoꞌojëna, Pablopi pa̱ire casiꞌi caquë yoꞌoquëna, sehuosicohuaꞌi i̱te ë̱sehuë. ");
INSERT INTO seyNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Cuiꞌne ja̱ro ëjaohuaꞌi paꞌi hue̱ꞌñare yecohuaꞌi ëjaohuaꞌipi Pablore ñacohuaꞌique paëꞌë, paꞌijë ja̱ohuaꞌije̱ ai ë̱sehuë, co̱ni yoꞌoquë camaꞌë cajë. Ja̱je paꞌina, i̱te quëaja̱ꞌcohuaꞌire jëjo saohuë. Pablo quëꞌrona. ");
INSERT INTO seyNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ja̱je yoꞌo maca, cato i̱ti tsiꞌsisicohuaꞌi cato deꞌhuarepa yoꞌojë cahuë, yecohuaꞌi ti̱ñe cuijëna, cuiꞌne yecohuaꞌi ai yeque cajëna, yoꞌohuë. Ja̱je yoꞌohuë, pa̱i. Coa ca huëosi doꞌire huesërepa tsiꞌsini, jai pa̱i yecohuaꞌi i̱ti cajë tsiꞌsiseꞌeque huesëhuë. ");
INSERT INTO seyNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ja̱je jai pa̱i huesëjëna, Alejandroje̱ huesëquëna, yecohuaꞌipi quëahuë, i̱ti cajë tsiꞌsiseꞌe. Ja̱ëni judío pa̱ipi coca cajë̱ꞌë cajë jëjo eto nëcohuë, pa̱i ña hue̱ꞌñana. Ja̱ maca Alejandropi pa̱ire coca casiꞌi judío pa̱i ayere caquë jë̱ñapi yoꞌopi. Yoꞌoquëna, ");
INSERT INTO seyNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","i̱je judío pa̱ipi casiꞌi caquë yoꞌoji asani ai tutu cuihuë, caya horas: “Paꞌijë̱ꞌë, Diana Efesios pa̱i jaꞌco.” ");
INSERT INTO seyNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Cuijë pejë je̱orena, i̱ti daripë paꞌiye toyaquëpi capi, pa̱ire: “Efesios pa̱i asajë̱ꞌë, siꞌa pa̱i iye yeja acohuaꞌi asayë, iye daripë paꞌicohuaꞌi siꞌaohuaꞌi Dianate ne huesomaꞌpë paye paꞌiji caseꞌe. Cuiꞌne maꞌtëmopi to̱mesi quë̱naoreje̱ ñacaiye paꞌiji, asayë. ");
INSERT INTO seyNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ja̱je paꞌiye sëte coꞌarepa huëojë coꞌaye yoꞌomaꞌpë paꞌijë̱ꞌë. Duꞌru macarepa ai cuasajë̱ꞌë, je huesëjëna, airepa yoꞌojë cayeꞌni. ");
INSERT INTO seyNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Iconi mësaru tse̱ani dasicohuaꞌi coꞌaye caye pa̱huë, mai jaꞌcore pare. ");
INSERT INTO seyNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ja̱je paꞌina, Demetriopi cuiꞌne i̱ ja̱ꞌre yoꞌojë cacohuaꞌipi yecohuaꞌire sa̱ñope cayere pani pa̱i yoꞌoseꞌe asani ca deꞌhuacohuaꞌina quëajë̱ꞌë. Ja̱ohuaꞌi paꞌiyë, mësaru yëye ëjaohuaꞌina cajë̱ꞌë. Ja̱ maca pa̱i ñape mësaru paꞌiye quëa deꞌhuajë ne deꞌhuajë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Mësarupi yequë coꞌamañare se̱ñe pacohuaꞌi pani jai pa̱i deꞌoyerepa tsiꞌsi sitona coca caye paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Yure iye yoꞌoseꞌe coꞌaji. Ëjaohuaꞌipi asani maire caye paꞌiji coa jo̱sa yoꞌojë cacohuaꞌire. I̱quere yoꞌojë careꞌni, cajë se̱to quëaye peoji. ¿Jere quëayeꞌni, i̱ti cajë yoꞌoseꞌe peoto?” ");
INSERT INTO seyNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ja̱je se ca tëjini je̱opi, i̱ti yoꞌoye. ");
INSERT INTO seyNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Jo̱sa yoꞌojë ca tëjisi jeteyoꞌje Pablopi sehuosicohuaꞌire soini yëhuo tëjini saiyë caquë pëpani Macedoniana sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Sani siꞌa hue̱ꞌña ja̱ro paꞌi daripë̱ana doꞌi sai sehuosicohuaꞌire sihua ëaye yëhuo huasoquë cujiꞌi. Cuni tëjini jeteyoꞌje Greciana ti̱ꞌapi. ");
INSERT INTO seyNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ti̱ꞌani ja̱rona toaso̱ ñañëohuaꞌire pëapi. Pëasiquëpi paꞌiquëpi Siriana sai yohuëna aya mëni tëjiquëpi i̱te judío pa̱i huañuꞌu cajë cuiꞌñaseꞌere asapi. Asani Macedonia yejaja̱ꞌa cuiꞌnaëpi tëto sai quë̱opi coꞌisiꞌi cuasapi. ");
INSERT INTO seyNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Cuasani saina, i̱ ja̱ꞌre co̱ni saëꞌë, Sópater Berea aquë, Pirro mamaquë, Aristarco, Segundo Tesalónica acohuaꞌi, Gayo Derbe mamaquë, Timoteo, Tíquico. Cuiꞌne Trófimo Asia yeja acohuaꞌi saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Saisicohuaꞌipi Maijaꞌquë doꞌijëpi yëquëre Troaspi utehuë. ");
INSERT INTO seyNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Utejëna, yëquëpi levadura co̱ꞌmemaꞌa a̱o a̱iñe tsiꞌsini yoꞌo tëjini, Filipos daripëpi etani jai yohuëja̱ꞌa cinco muꞌseña saijë ti̱ꞌahuë, Troasna. Ti̱ꞌani ja̱rona siete muꞌseña pëahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Huajë muꞌse paꞌina, Jesús yoꞌoseꞌere cuasajë a̱o jëꞌyeni a̱ñuꞌu cajë tsiꞌsisicohuaꞌipi paꞌijëna, Pablopi ñatasi muꞌse saiyeque paꞌiji caquë ai yëhuopi, ñami jopo paꞌi macare paja̱ꞌa. ");
INSERT INTO seyNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Yëhuoquëna, ë̱mëjeꞌrepa tuꞌrihuëna tsiꞌsisicohuaꞌipi paëꞌë, jaiye toa tsë̱opë̱a tsë̱o sitore. ");
INSERT INTO seyNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Paꞌijëna, teꞌi po̱së Eutico hueꞌequëpi hueꞌse ña saꞌrona jaꞌrusiquëpi ñujiꞌi. Ñuꞌiquëpi, Pablopi airepa tsoe quëaye sëte ca̱i huëoni yuretaꞌa ca̱ni huesëni ja̱ro toaso̱ yaꞌripa ë̱mëjeꞌre papi to̱mepi. To̱meina, ju̱ꞌisiquëni co̱ani huëohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ja̱je ju̱ꞌisiquëni o̱arena, Pablopi cajeni jai ca̱pi po̱sëna jani suꞌcuapi. Suꞌcuani capi, sehuosicohuaꞌire: “Quëquëmaꞌpë paꞌijë̱ꞌë. Huajëquë api.” ");
INSERT INTO seyNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Cani ja̱ jeteyoꞌje, ja̱ꞌnë paꞌi sitona mëni a̱o yëtoni a̱ni ja̱re Maijaꞌquë coca quëaquë ñatapi. Ñata to̱mequëna, caye je̱oni sajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Saina, yecohuaꞌije̱ tsihuaꞌëre huajëquëre sahuë. Sajë ai sihuajë saëꞌë, i̱ti yoꞌoseꞌere cuasajë. ");
INSERT INTO seyNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Cu̱tihuëja̱ꞌa sasiꞌi caëna, yëquëpi duꞌru saëꞌë, yohuëja̱ꞌa Asón daripëna. Ja̱rona Pablore i̱ caseꞌeje̱ paꞌye ayañuꞌu cajë. ");
INSERT INTO seyNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Yoꞌosicohuaꞌipi Asónna i̱te ti̱ꞌahuë. Ti̱ꞌarena, aya mëquëna, sani i̱ ja̱ꞌre co̱ni Mitilenena ti̱ꞌahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ti̱ꞌasicohuaꞌipi ja̱ropi sani se ñatasi muꞌse Quío daripë je̱ꞌñere paja̱ꞌa sa saëꞌë. Sa sani se ñatasi muꞌse, Samos yo saꞌrona ti̱ꞌahuë. Ti̱ꞌasicohuaꞌipi se ñatasi muꞌse Meletona ti̱ꞌahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Ja̱je yoꞌohuë, Pablopi esa Jerusalénna ti̱ꞌani duꞌru quë̱iseꞌe tëa fiestare pasiꞌi caquëna. I̱pi Efesona saisiquë pani Asia yejana ai tsoe pëayere coequëna, ja̱je yoꞌohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Miletore Pablo paꞌi Efeso sehuosicohuaꞌi ëjaohuaꞌire soipi. ");
INSERT INTO seyNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Soina, asani datena, capi, ja̱ohuaꞌire: “Yëꞌë duꞌru macarepa Asiana ti̱ꞌasi muꞌse aquëpi yëꞌë paꞌi yoꞌoseꞌe asacohuaꞌi aꞌë, mësaru. ");
INSERT INTO seyNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Siꞌanë mësaru ja̱ꞌre paꞌi jerepa paꞌi aꞌë caquë yoꞌomaꞌë mai Ëjaëre necaiyë. Israel pa̱ipi yëꞌëre jaiye jo̱sa yoꞌoñuꞌu cuasajë yoꞌo jopopi ai yoꞌoquë mësarute otare papi oi quëahuë. Ja̱je paꞌina, ");
INSERT INTO seyNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","mësarute deꞌoye paꞌiye i̱siyere quëa jujani je̱omaꞌë pa̱i tsiꞌsi hue̱ꞌñana cuiꞌne mësaru huë̱ꞌñana cuꞌi quëaroja̱ëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ja̱je quëaquë Israel pa̱ire cuiꞌne griego pa̱ireje̱ cahuë, Maijaꞌquëna po̱nëni mai Ëjaë Jesucristore sehuojë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ja̱je mësarute quëasiquëpi yuretaꞌa joyore papi Jerusalénna saiye paꞌiji caquë yëꞌëre cua̱ñequëna, ja̱rona saija̱ꞌquë aꞌë, yëꞌëre yoꞌo ja̱ꞌñe huesëquë. ");
INSERT INTO seyNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Coa iyeseꞌe deꞌo joyo quëaquëna, asaquë paꞌiyë, mëꞌëre co hue̱ꞌñapi cuiꞌne ai yoꞌoyepi uteji. Ja̱jeseꞌe caji, yëꞌë sai daripë̱a ñape. ");
INSERT INTO seyNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ja̱je paꞌiquëtaꞌare yëꞌë cato, yëꞌë paꞌiyere ai oi me nejaꞌquë aꞌni camaꞌë paꞌiyë. Coa sihuaquë yëꞌë pani tëji macaja̱ꞌa deꞌo cocare Maijaꞌquë pa̱ire oiyere Ëjaë Jesús quëacaijë̱ꞌë caquë i̱siseꞌere ne saoyeseꞌe paꞌiji. ");
INSERT INTO seyNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Mësaru yëꞌë quëaquëna, Maijaꞌquë cua̱ñe te̱ꞌte asasicohuaꞌi yëꞌëre ti̱jupë ña co̱ñe pa̱jaꞌcohuaꞌi aꞌë. Ja̱je yure cato asayë coa caye pa̱ñë. ");
INSERT INTO seyNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ja̱je paꞌina, mësarute caye yëyë, mësaru acohuaꞌipi ne huesëto yëꞌë quëamaꞌë paꞌisi doꞌi peosipi. ");
INSERT INTO seyNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Mësarute tsoe siꞌaye Maijaꞌquë cuasa nëoseꞌere yoꞌoseꞌere siꞌaye yahueye peoyerepa quëahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ja̱je paꞌiye sëte mësaruja̱ꞌa coꞌye ñare pajë paꞌijë, i̱ tsie doꞌipi huerosicohuaꞌire siꞌa sehuosicohuaꞌire Maijaꞌquë tse̱cohuaꞌire yëi ñamare ñacohuaꞌi yoꞌoyeje̱ paꞌye deꞌoye ñacaijë̱ꞌë, deꞌo joyopi mësarute ñacaicohuaꞌi paꞌija̱jë caquë nesicohuaꞌi sëte. ");
INSERT INTO seyNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Yëꞌë saisi jeteyoꞌje yai a̱i yëyeje̱ paꞌiohuaꞌipi sehuosicohuaꞌire nejo saoñuꞌu cajë yecohuaꞌipi daija̱ꞌcohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Yequeje̱ ja̱re mësaru acohuaꞌipi cosoyere yeꞌyajë yoꞌoja̱ꞌcohuaꞌi aꞌë sehuosicohuaꞌipi i̱ohuaꞌini tuija̱jë cajë. ");
INSERT INTO seyNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Yëꞌë mësaru ja̱ꞌre toaso̱ o̱metëca paꞌi muꞌseñapi cuiꞌne ñamiñapi otarepa oi pa̱i ñapere yëhuoye je̱omaꞌë yëhuoseꞌere hua̱nëyemaꞌpë ja̱re cuasajë ñare pajë paꞌijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Maijaꞌquë doꞌijë, mësarute Maijaꞌquëna cuiꞌne i̱ oi coca cayena i̱si nëoñë. Ja̱ coca tutu quëꞌyepi mësaru joñoa jerepa deꞌoye cuasaye necaiyena cuiꞌne siꞌaye i̱ ca nëoseꞌere i̱ deꞌo pa̱ina i̱siyena. ");
INSERT INTO seyNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Yecohuaꞌi coꞌamañare, curiquëre, ca̱ñare oimaꞌë paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Coa ai jerepa yëꞌë jë̱tëpi nequë yëꞌëre caraye ti̱ꞌaquë pahuë. Paquë cuiꞌne yëꞌë ja̱ꞌre co̱ni paꞌicohuaꞌireje̱ co̱caëꞌë, yëꞌëpi nequë. Ja̱je yoꞌoye mësarupi ñahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ñajëna, mësaruteje̱ ja̱je coꞌamaña nejë yecohuaꞌire coꞌamaña peocohuaꞌire co̱caicoa caquë yeꞌyahuë, siꞌanëpi. Jesús caquë paꞌiseꞌere cuasaquë i̱ caseꞌe cato caji: “I̱si cua̱ñoni sihuaye jerepa sihuaye paꞌiji, yecohuaꞌina se i̱sini.” ");
INSERT INTO seyNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ca tëjini Pablo doꞌre jaꞌruni Maijaꞌquëre se̱jiꞌi, i̱ohuaꞌi ja̱ꞌre co̱ni. ");
INSERT INTO seyNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ja̱ maca Pablore ai oijë suꞌcuani sihuahuë. Ja̱je yoꞌohuë, i̱pi yëꞌëre ti̱jupë ña co̱ñe pa̱jaꞌcohuaꞌi aꞌë caëna. Ja̱ maca yuretaꞌa teꞌe saijë sani i̱ sai yohuë quëꞌrore paja̱ꞌa je̱ojaëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Pablopi yëꞌëre ti̱jupë ti ñañe pa̱jaꞌcohuaꞌi aꞌë caseꞌe cuasajë ai oicohuaꞌi paëꞌë. Paꞌijë Pablo ja̱ꞌre co̱ni yohuëja̱ꞌa saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Maijaꞌquë doꞌijëre je̱oni aya mëni teꞌere papi Cos daripëna saëꞌë. Sani ñatasi muꞌsepi Rodasna ti̱ꞌahuë. Ti̱ꞌani ja̱opi Pátarana saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Sani Pátarana jai yohuë ti̱ꞌahuë, Feniciana saiconi ti̱ꞌani i̱ona ayamëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Aya mëni saicohuaꞌipi Chipre saodohuë coa ñajë saëꞌë. Ari te̱ꞌtere paꞌiona, ñajë saicohuaꞌipi Siriana ti̱ꞌahuë. Ti̱ꞌani Tiro yo saꞌrona coꞌamaña maꞌñe paꞌiye sëte ja̱rona yohuë sëꞌao. ");
INSERT INTO seyNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Sëꞌaona ja̱rona Maijaꞌquë doꞌijëre ti̱ꞌahuë. Ti̱ꞌani i̱ohuaꞌi quëꞌrona pëahuë, siete muꞌseña. Pëarena, deꞌo joyopi Pablo ai yoꞌo ja̱ꞌñere quëaquëna, asani cahuë, Pablore Jerusalénna saimaꞌë paꞌijë̱ꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ja̱je casicohuaꞌitaꞌare siete muꞌseña tëto saisi maca etani saëꞌë. Saijëna, siꞌaohuaꞌi ë̱mëohuaꞌi cuiꞌne nëjohuaꞌi tsi̱ maña co̱ni yëquë ja̱ꞌre daëꞌë, pa̱i daripë hueꞌsere pana. Datena, ja̱rona mejahuëna doꞌre jaꞌruni Maijaꞌquëre se̱iꞌë. Se̱ni tëjini saiyë cajë pëpani, ");
INSERT INTO seyNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","jai yohuëna aya mëni yëquë cato saëꞌë. Saijëna, i̱ohuaꞌipi i̱ohuaꞌi huë̱ꞌñana coꞌihuë. ");
INSERT INTO seyNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tiropi Tolemaidana tsiaya saiye sani tëjini Maijaꞌquë doꞌijëre pëpani teꞌe muꞌse i̱ti macana pëahuë, i̱ohuaꞌi ja̱ꞌre co̱ni. ");
INSERT INTO seyNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ñatasi muꞌse saicohuaꞌipi Cesareana ti̱ꞌahuë. Ti̱ꞌani Jesús jëjo saocohuaꞌire co̱caicohuaꞌi siete aquë Felipe huëꞌena pëahuë, deꞌo coca quëaquë huëꞌena. ");
INSERT INTO seyNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ja̱ë Felipepi cuatro mamajëre nomi tsi̱re huejamaꞌcohuaꞌire paquë pajiꞌi. Ja̱ohuaꞌi cato yequë muꞌse paꞌi ja̱ꞌñere quëacohuaꞌi paëꞌë, Maijaꞌquëpi quëaquëna. ");
INSERT INTO seyNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ja̱ huëꞌere tsoe muꞌseña maña paꞌijëna, dajiꞌi, Agabo Judeapi. Ja̱ë cato yequë muꞌse yoꞌo ja̱ꞌñere quëaquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Paꞌipi ti̱tani yëquë ña hue̱ꞌña Pablo të̱icore i̱ni jë̱ña cuiꞌne nëcañoa coꞌye i̱jaꞌa hue̱pi, hue̱ni capi: “Ñeje iye të̱ica̱ paquëre hue̱jaꞌcohuaꞌi aꞌë, judío pa̱ipi Jerusalénna ja̱ jeteyoꞌje ti̱ pa̱ina i̱sija̱ꞌcohuaꞌi aꞌë, i̱te. Ja̱je caji, deꞌo joyopi.” ");
INSERT INTO seyNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Caquëna, asani yëquë Pablote co̱cohuaꞌipi cuiꞌne ja̱ daripë sehuosicohuaꞌipi Jerusalénna saimaꞌë paꞌijë̱ꞌë, cajë ë̱sehuë. ");
INSERT INTO seyNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ë̲sejë cajëna, Pablopi capi: “¿Me yoꞌojë oiyeꞌni, yëꞌëre coꞌa ju̱ꞌiñeꞌni? Yëꞌë Jerusalénna ju̱ꞌiñe deꞌoji, hue̱siquëpi mai Ëjaë Jesús yëye yoꞌoto.” ");
INSERT INTO seyNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ja̱je caquë Jerusalénna sasiꞌi caquëna, asani i̱te pëajë̱ꞌë caye je̱oni cahuë: “Mai Ëjaë yëyeje̱ paꞌija̱quë.” ");
INSERT INTO seyNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ja̱ jeteyoꞌje coꞌamaña deꞌhua tëjini Jerusalénna saëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Saijëna, Cesarea pa̱i sehuocohuaꞌipi yëquëre co̱ni saijë sahuë. Sani ja̱ohuaꞌipi Jerusalénna ti̱ꞌani Mason huëꞌena sahuë, yëquë pëaja̱ꞌtona. Mason cato Chipre aquë pajiꞌi, ai tsoe Maijaꞌquë coca sehuosiquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Jerusalénna ti̱ꞌajëna, sehuocohuaꞌipi sihuajë yëquëre pëpahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Pëparena, ñatasi muꞌse Pablo ja̱ꞌre co̱ni Jacobo quëꞌrona doꞌi saëꞌë. Sa ti̱ꞌajëna, ja̱rote cuiꞌne siꞌaohuaꞌi sehuocohuaꞌi ëjaohuaꞌi paëꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paꞌijëna, pëpa tëjini Pablopi siꞌaye quëapi, judío pa̱i peocohuaꞌire quëaroja̱ina, Maijaꞌquëpi ja̱ohuaꞌire necaiseꞌere. ");
INSERT INTO seyNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Quëaquëna, asani Maijaꞌquë ai deꞌoji cani Pablore cahuë: “Maijaꞌquë doꞌiquë, deꞌoji mëꞌëre quëañuꞌu. Jai pa̱i Israel pa̱i sehuosicohuaꞌi paꞌiyë, i̱ño. Ja̱ohuaꞌi cato Moisés cua̱ñeseꞌere yoꞌoye paꞌiji cacohuaꞌi aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ja̱je cacohuaꞌipi asayë mëꞌëpi judío pa̱i yequë pa̱i quëꞌro paꞌicohuaꞌire Moisés cua̱ñeseꞌere yoꞌomaꞌpë caquë cuiꞌne ca̱ꞌnije tëamaꞌpë paꞌijë̱ꞌë caquë, cuiꞌne aiohuaꞌi yoꞌoseꞌe yoꞌomaꞌpë caquë yeꞌyaji asayë. ");
INSERT INTO seyNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ja̱je asacohuaꞌipi mëꞌë i̱ño daiseꞌe asaja̱ꞌcohuaꞌi aꞌë. ¿Ja̱je paꞌito me nejaꞌcohuaꞌi aꞌni? ");
INSERT INTO seyNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Iyeseꞌe mëꞌë yoꞌoye paꞌiji cuasajë, i̱ñore cajeseꞌe paꞌi ë̱mëohuaꞌi paꞌiyë i̱ohuaꞌi Maijaꞌquëre ca nëoseꞌere yoꞌoja̱ꞌcohuaꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ja̱ohuaꞌi ja̱ꞌre sani Moisés cua̱ñeseꞌere yoꞌoquë ja̱ohuaꞌi ja̱ꞌre teꞌe siꞌsire tsoa to̱jëꞌë, nañare tëa cua̱ñoquë. Cuiꞌne mëꞌëpi ja̱ohuaꞌi tëa cua̱ño doꞌije̱ sa̱icaijë̱ꞌë. Ja̱je yoꞌoquëna, siꞌaohuaꞌi ñani mëꞌëre sa̱ñope caseꞌe coa caseꞌe aꞌë cuasaja̱jë, Moisés cua̱ñeseꞌere sehuocai mëꞌëje yoꞌoquëna, ña jujani. ");
INSERT INTO seyNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Tsoe toyahuë, yëquë cuasaseꞌe judío pa̱i peocohuaꞌipi sehuosicohuaꞌi yoꞌo ja̱ꞌñe. Ja̱ohuaꞌi cato yoꞌoye paꞌiji, a̱iñe peoji deꞌhuasi diusuna i̱sisihuaꞌi. Tsieje̱ a̱iñe peoji, cuiꞌne quio hue̱asicohuaꞌire a̱iñe peoji. Huejamaꞌcohuaꞌipi ë̱mëre nomiore yoꞌoye peoji. Ja̱je toyahuë.” ");
INSERT INTO seyNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ja̱je casi maca Pablopi cuatro ë̱mëohuaꞌire sapi. Sani ñatasi muꞌse i̱ohuaꞌi ja̱ꞌre teꞌe siꞌsire cuya to̱ni Maijaꞌquëre se̱ huëꞌena cacapi, i̱ohuaꞌi ca nëosi muꞌse ti̱ꞌajaꞌa muꞌse quëasiꞌi caquë. Ja̱je cani cayë, pa̱i ñape Maijaꞌquëre coa i̱siyere daja̱ꞌa muꞌse ti̱ꞌaëna yoꞌo ja̱ꞌñere. ");
INSERT INTO seyNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Je̱ꞌnë siete muꞌseña sa tëto saiye jaꞌi maca paꞌina, Asia yeja acohuaꞌipi Israel pa̱ipi Maijaꞌquëre se̱ huëꞌere Pablo paꞌina, ñani pa̱ire ca huëohuë. Ca huëojë Pablo quëꞌrona sa to̱mejaëꞌë, ");
INSERT INTO seyNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","tutu cuijë: “Israel pa̱i co̱caijë̱ꞌë. Iquëpi siꞌa hue̱ꞌña cuꞌi maire sa̱ñope caquë yeꞌyaquë cuiꞌne Moisés cua̱ñeseꞌe cuiꞌne iye huëꞌe sa̱ñope caquë yeꞌyaquë. Ja̱je paꞌipi yure Maijaꞌquë huëꞌena griego pa̱ire dapi, iye deꞌo huëꞌere siꞌsi necai, cahuë.” ");
INSERT INTO seyNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ja̱je cahuë, Pablopi Efeso aquë Trófimo ja̱ꞌre co̱ni Jerusalénre paꞌina, ñasicohuaꞌipi, judío pa̱i peocohuaꞌi ja̱ꞌre co̱ni Maijaꞌquë huëꞌena cacapi cuasajë ja̱je cahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ja̱je yoꞌojëna, siꞌa ja̱ daripë paꞌicohuaꞌi asani pë̱ijë tsiꞌsini Pablote tse̱ani hueꞌsena quërëjë sahuë. Hueꞌsena quërë etoni, Maijaꞌquë huëꞌe eta saꞌnoa si̱ꞌñe saohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Pablote ja̱ maca huani je̱oñuꞌu cajë yoꞌojëna, yecohuaꞌipi soldado pa̱i ëjaëre Coronelre, siꞌa Jerusalén acohuaꞌi ai jo̱sa yoꞌoyë, quëahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Quëarena, Coronelpi asani i̱ soldado pa̱i ja̱ꞌre co̱ni i̱ti yoꞌo hue̱ꞌñana huëꞌhuëhuë. Huëꞌhuë ti̱ꞌajëna, ñani Pablote huaiye je̱ohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ja̱ maca Coronelpi ti̱ꞌani i̱ soldadore cua̱ñepi. Pablote tse̱ani caya quë̱na meapi hue̱jëꞌë caquë ja̱ maca Pablote se̱jiꞌi: “¿I̱que mami aꞌni?” caquë, cuiꞌne “¿i̱quere yoꞌoquëna, mëꞌëre sa̱ñope yoꞌoyeꞌni?” caquë. ");
INSERT INTO seyNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Se̱ina, yecohuaꞌipi ai tutu cajëna, yecohuaꞌipi yequere tutu ai cajëna, asamaꞌë soldado daripëna sajë̱ꞌë, cua̱ñepi. ");
INSERT INTO seyNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Cua̱ñeina, sacohuaꞌipi je̱ꞌnërepa soldado pa̱i daripë mëicona ti̱ꞌani soldado pa̱ipi coa cua̱ijë sahuë, Pablote huajo yëcohuaꞌipi ai jo̱sa yoꞌo doꞌire. ");
INSERT INTO seyNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Sajëna, jai pa̱i tutu cuihuë: “I̱te huaijë̱ꞌë”. ");
INSERT INTO seyNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Sajëna, soldado huëꞌe caca maca Pablopi Coronelre capi, griego cocapi: “Aꞌri maña mëꞌëre casiꞌi.” Caquëna, soldado ëjaëpi capi: “¿Mëꞌë griego cocare caquë aë? ");
INSERT INTO seyNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Mëꞌë paꞌimaꞌquë Egípto pa̱i ëjaëre sa̱ñope yoꞌoquëpi, cuatro mil ë̱mëohuaꞌi huaicohuaꞌi ja̱ꞌre co̱ni pa̱i peo hue̱ꞌñajaꞌa saisiquë.” ");
INSERT INTO seyNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Caquëna, Pablopi capi: “Pa̱ni, yëꞌë cato Israel pa̱i aꞌë. Cilicia yeja Tarso daripë aquë aꞌë. Ja̱je paꞌina, mëꞌëre se̱ñë, ja̱ohuaꞌire coca casiꞌi.” ");
INSERT INTO seyNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Caquëna, deꞌoji, caëna. Caquëna, Pablopi soldado huëꞌe mëiconi nëcaquë jë̱tëpi jaꞌjëquëna, ñani coca caye je̱orena, Pablopi hebreo cocapi capi, Israel pa̱ire: ");
INSERT INTO seyNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Aꞌyë dohuë, cuiꞌne jaꞌquëohuaꞌi asajë̱ꞌë siꞌaye quëasiꞌi, mësarute.” ");
INSERT INTO seyNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ja̱je hebreo cocapi caquëna, asani Pablo caye ai jerepa joꞌcua je̱oni camaꞌpë asajëna, capi: ");
INSERT INTO seyNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Yëꞌë Israel pa̱i aꞌë. Cilicia yeja Tarso daripëna co̱asiquë aꞌë. Ja̱je paꞌipi iye daripë Jerusalénna ai deꞌohuë. Ai deꞌoquëna, Gamalielpi yëꞌëre yeꞌyapi, mai aiohuaꞌi cua̱ñeseꞌere siꞌaye. Yeꞌyasiquëpi siꞌaye Maijaꞌquë yëye yoꞌosiꞌi caquë deꞌhue yoꞌohuë, mësaru yoꞌoyeje̱ paꞌye cuiꞌne. ");
INSERT INTO seyNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Jesús yeꞌyaseꞌere ë̱sequë i̱te sehuocohuaꞌire huani je̱osiꞌi caquë i̱te sehuocohuaꞌire tse̱ani siꞌseni co hue̱ꞌñana jëjo saohuë, ë̱mëohuaꞌire cuiꞌne nomiohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaërepa cuiꞌne siꞌa Israel aiohuaꞌi asayë. Yëꞌë ja̱je yoꞌoseꞌe, ja̱ohuaꞌipi Damasco acohuaꞌina Israel pa̱ina toyani jëjo saohuë, Jesure sehuocohuaꞌire coꞌequë tse̱ani i̱ño Jerusalénna dani siꞌseye paꞌiji caquë. ");
INSERT INTO seyNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Maꞌajaꞌa sai Damasco ti̱ꞌañe jaꞌi maca paꞌina, jopo muꞌse maꞌtëmopi ai miañerepa yëꞌëna juꞌapi. ");
INSERT INTO seyNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Juꞌaquëna, yejana to̱mehuë. Ja̱ macapi asahuë, yëꞌoseꞌe: ‘¿Saulo, Saulo me yoꞌoquë yëꞌëre jo̱sa yoꞌoquëꞌni?’ ");
INSERT INTO seyNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Caquëna, sehuohuë. ‘¿Ne aꞌni ëjaë?’ cahuë. Caquëna, capi: ‘Yëꞌë Jesu aꞌë. Nazaret aquë aꞌë, mëꞌë jo̱sa yoꞌoquë.’ ");
INSERT INTO seyNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Caquëna, yëꞌëre co̱cohuaꞌi cato miañe ñajëtaꞌa Jesús cayete asamaꞌpë quëquësicohuaꞌi pateña. ");
INSERT INTO seyNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Paꞌijëna, Jesús caquëna, asani cahuë: ‘¿I̱quere yoꞌoja̱ꞌquë aꞌni, Ëjaë?’ Caquëna, mai Ëjaëpi capi: ‘Huëni Damascona saijë̱ꞌë. Ja̱ropi mëꞌë yoꞌo ja̱ꞌñe quëaye paꞌiji.’ ");
INSERT INTO seyNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ai miañepi juꞌa huesouna, ñamaꞌquë deꞌohuë. Yëꞌëre co̱cohuaꞌipi jë̱tëre tse̱ꞌejë sahuë, Damascona. ");
INSERT INTO seyNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Ja̱rote Ananías Moisés cua̱ñeseꞌe yoꞌoquëpi Damascore pëasiquëpi pajiꞌi. Ja̱ë cato ai deꞌoquë api, siꞌaohuaꞌi judío pa̱i cajëna, paꞌiquë pajiꞌi. ");
INSERT INTO seyNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Damascona ti̱ꞌani pëahuë. Pëaëna, Ananíaspi dani nëcaquë capi: ‘Saulo yëꞌë yoꞌjei, yure mëꞌëpi ñañe paꞌiji. Caquëna, ñahuë, i̱ti macapi.’ ");
INSERT INTO seyNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ja̱ maca yëꞌëre capi: ‘Mai aiohuaꞌi Diusupi i̱ yëyere asaquë yoꞌoja̱quë caquë mëꞌëre joꞌya nepi, nuñe paꞌini ñaquë cuiꞌne Jesús cayere asaquë yoꞌoja̱ꞌquëni soipi. ");
INSERT INTO seyNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ja̱je paꞌina, mëꞌë ñaseꞌere cuiꞌne asaseꞌere siꞌaohuaꞌire quëaye paꞌiji. Mëꞌë cato i̱ paꞌiyere quëacaiquë paꞌija̱ꞌquë aꞌë. ");
INSERT INTO seyNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","¿Yure me yoꞌoquë utequëꞌni? Huëni do cua̱ñojëꞌë, mai Ëjaë mamire cuasaquë mëꞌë coꞌaye yoꞌoseꞌe tsoa to̱siquë paꞌiquë.’ ");
INSERT INTO seyNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Jeteyoꞌje Jerusalénna coꞌini Maijaꞌquëre se̱ huëꞌena cacani Maijaꞌquëni se̱i ca̱ni ñañeje paꞌye ñahuë. ");
INSERT INTO seyNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ñaquëna, Ëjaëpi yëꞌëre capi: ‘Esa Jerusalénpi etani saijë̱ꞌë. Iye daripë paꞌicohuaꞌi yëꞌë coca mëꞌë quëaye asacaiye pa̱jaꞌcohuaꞌi aꞌë.’ ");
INSERT INTO seyNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Caquëna cahuë: ‘Ëjaë, me ja̱ohuaꞌire quëayeꞌni, tsoe ja̱ohuaꞌipi yëꞌë mëꞌëre sehuocohuaꞌire judío pa̱i tsiꞌsi hue̱ꞌñana sai tse̱aquë tëꞌcaquë cuiꞌne co hue̱ꞌñana coquë yoꞌoseꞌe asacohuaꞌire. ");
INSERT INTO seyNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Cuiꞌne mëꞌë joꞌyaë Estebanre huani je̱ojëna, yëꞌëpi huaicohuaꞌi ca̱ña ñacai nëcaquë huaiye deꞌoji cuasahuë. Siꞌa pa̱i asayë, yëꞌë yoꞌoseꞌe.’ ");
INSERT INTO seyNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Caquëna, mai Ëjaëpi yëꞌëre capi: ‘Saijë̱ꞌë. Soꞌona jëjo saosiꞌi, yëꞌë cocarepa yequë pa̱ire quëaja̱ꞌquëre, Israel pa̱i peocohuaꞌini,’ capi.” ");
INSERT INTO seyNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Deꞌoye iye ca macaja̱ꞌa asa tëjini ai tutu cui huëohuë: “Huajëquë paꞌito coꞌaji. Me huajëquë paꞌija̱ꞌquë.” ");
INSERT INTO seyNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ja̱je je̱oñe peoyerepa ai tutu cuijë pë̱ijë i̱ohuaꞌi juꞌi sara duꞌteni je̱ajë cuiꞌne yaꞌo neꞌñare ë̱mëjeꞌena je̱ajë yoꞌohuë. ");
INSERT INTO seyNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Yoꞌojëna, soldado huëꞌena Pablore coni ca̱ꞌni mepi siꞌsejë̱ꞌë. ¿Siꞌsejëna, quëaja̱quë i̱ coꞌaye yoꞌoseꞌe. I̱quere yoꞌoquëna, ai sa̱ñope cayeꞌni? Asasiꞌi caquë cua̱ñepi, Coronelpi. ");
INSERT INTO seyNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Siꞌseñuꞌu cajë hue̱ni yoꞌojëna, Pablopi Capitánre capi: “Yëꞌë yoꞌoseꞌe asamaꞌpë siꞌseye peoji. Cua̱ñeseꞌe paꞌiji, yëꞌë romano aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Caquëna, Capitánpi asani sani i̱ ëjaëre capi: “Iquëre deꞌhua ñani yoꞌojë̱ꞌë. Romano api.” ");
INSERT INTO seyNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Caquëna, Coronelpi dani capi: “Yëꞌëre quëajë̱ꞌë. ¿Romano aꞌë, mëꞌë?” Caquëna, Pablopi capi: “Jë̱jëꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Caquëna, Coronelpi capi: “Jaiye curiquë sa̱ini yëꞌë romano pa̱i deꞌohuë.” Caquëna, Pablopi capi: “Yëꞌë sa̱iñe pa̱huë. Yëꞌë cato tsi̱ꞌnëna romano pa̱i aꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Caquëna, siꞌseñuꞌu cajë yoꞌosicohuaꞌipi i̱te je̱oni sateña. Cuiꞌne Coronelpi romanore hue̱jëꞌë cua̱ñesiquëpi quëquëpi. ");
INSERT INTO seyNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ñatasi muꞌse Coronelpi Israel pa̱i Pablote sa̱ñope caseꞌere asasiꞌi i̱que doꞌire sa̱ñope cayeꞌni caquë Maijaꞌquë huëꞌe ñacai ëjaohuaꞌire cuiꞌne judío pa̱i yoꞌoye asani ca tëji ëjaohuaꞌire tsiꞌsopi. Aiohuaꞌire tsiꞌsoni Pablote quë̱na mea joyeni tsiꞌsi hue̱ꞌñana daëña. ");
INSERT INTO seyNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Sa nëcouna, Israel pa̱i yoꞌoye asani ca tëji ëjaohuaꞌire Pablopi ai ñani capi: “Maijaꞌquë doꞌijë, iye macaja̱ꞌa Maijaꞌquë ña hue̱ꞌña yëꞌë ai cuasaquë coꞌa ju̱ꞌi paꞌiye pa̱ñë.” ");
INSERT INTO seyNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Caquëna, Ananíaspi Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaëre papi Pablore jaꞌye nëcacohuaꞌire capi: “Yëꞌopona tëtojë̱ꞌë.” ");
INSERT INTO seyNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Cua̱ñequëna, Pablopi i̱te capi: “Mëꞌëni coa caquëre Maijaꞌquëpi tëtoja̱ꞌquë api, mëꞌë cato Moisés cua̱ñeseꞌepi yëꞌë yoꞌoseꞌere asani ne deꞌhuaja̱ꞌquëpi jaꞌrusiquëpi ñuꞌiñë, ja̱ maca. Ja̱je paꞌitaꞌa ¿me yoꞌoquë tëtojë̱ꞌë, cua̱ñequëꞌni? Ja̱je cani mëꞌëpi Moisés cua̱ñeseꞌere sa̱ñope yoꞌoyë.” ");
INSERT INTO seyNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Caquëna, i̱ti maca nëcacohuaꞌipi i̱te cahuë: “¿Maijaꞌquë huëꞌe ñacaicohuaꞌi ëjaëre pare pë̱i sa̱ñope caquë?” ");
INSERT INTO seyNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Cajëna, Pablopi capi. “Doꞌijë ëjaëre huesëquë cahuë. Ëjaëpi asani ja̱je caye pa̱raꞌhuë. Maijaꞌquë toya pëpë caji: ‘Pa̱i ëjaëre pë̱i sa̱ñope camaꞌë paꞌijë̱ꞌë.’ ” ");
INSERT INTO seyNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Cani ja̱ jeteyoꞌje, Israel pa̱i yoꞌoye asani ca tëjicohuaꞌi acohuaꞌipi saduceo pa̱i cuiꞌne fariseo pa̱i paꞌiyë asani, Pablopi tutu capi: “Doꞌijë, yëꞌë fariseoꞌë. Fariseo tsëcapë aquë aꞌë. Ju̱ꞌisicohuaꞌi huëiye paꞌiji cuasa doꞌire tse̱a cua̱ñosiquë paꞌiyë.” ");
INSERT INTO seyNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ja̱je caëna, fariseohuaꞌipi, saduceohuaꞌi ja̱ꞌre sa̱ñope yoꞌojë cajë caya tsëca huahuë, tsiꞌsisicohuaꞌipi. ");
INSERT INTO seyNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Saduceohuaꞌi cato ju