﻿USE sofia;
DROP TABLE IF EXISTS sofia.set_vpl;
CREATE TABLE set_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES set_vpl WRITE;
INSERT INTO set_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Na bere hele Yahudi kanine ro mbai nekewole na ro Yesus. Neyae Yahudi ro miyae naei yobe mbai nendo Abrahambe orona menara yeuboke, nane merau Yahudi naei Ondofolo Kaban Daudle orona mena. Allah yae nda Yesusre Wali Ondofolore ranenjendere oro umau heraweungeboke. Yesus na yobe naei kamahe naei homone molaikoke nda niyae: ");
INSERT INTO set_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahambe kelu Ishak, Ishakle kelu Yakub, Yakuble kelu Yehuda na aka baeke wa bele, ");
INSERT INTO set_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yehudale kelu Peresle Zerahle Tamar yae honoukoke, Peresle kelu Hezron, Hezronbe kelu Ram, ");
INSERT INTO set_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Rambe kelu Aminadab, Aminadable kelu Nahason, Nahasonbe kelu Salmon, ");
INSERT INTO set_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmonbe kelu Boas Rahab yae hongke, Boasle kelu Obed Rut yae hongke, Obedle kelu Isai, ");
INSERT INTO set_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaite kelu Daud Yahudi naei Ondofolo Kaban. Daudle kelu Salomo Badseba bere Uriale nekeikoke miyae yae hongke, ");
INSERT INTO set_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomole kelu Rehabeam, Rehabeambe kelu Abia, Abiale kelu Asa, ");
INSERT INTO set_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asale kelu Yosafat, Yosafatle kelu Yoram, Yorambe kelu Uzia, ");
INSERT INTO set_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziale kelu Yotam, Yotambe kelu Ahas, Ahasle kelu Hizkia, ");
INSERT INTO set_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hizkiale kelu Manasye, Manasyele kelu Amon, Amonbe kelu Yosia, ");
INSERT INTO set_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiale kelu Yekhonya na aka baeke wa bele. Nebei hee Israelna ro miyae Babel ro miyae yae ikilewate, Babel kanire hauwate ewate. ");
INSERT INTO set_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Israel Babel kanire ekate hee yae Yekhonyale kelu Sealtiel hongkate, Sealtielle kelu Zerubabel, ");
INSERT INTO set_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabelle kelu Abihud, Abihudle kelu Elyakim, Elyakimbe kelu Azor, ");
INSERT INTO set_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorle kelu Zadok, Zadokle kelu Akhim, Akhimbe kelu Eliud, ");
INSERT INTO set_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudle kelu Eleazar, Eleazarle kelu Matan, Matanbe kelu Yakub, ");
INSERT INTO set_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakuble kelu Yusuf Mariale molo Yesusre hongke. Nda Yesus Allah yae Wali Ondofolore oro umau heraweungeboke kiyae. ");
INSERT INTO set_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Yesus Na yobe naei kamahe naei nemene na helen nda niyae: Abrahambe heera mewole Daudle heene, na akona akona nemene me bee oro nen keli bele (14). Daudle heera mewole Babel kanine aisayeukoke heene, na akona akona nemene me bee oro nen keli bele (14). Nebei sului mbai Babel kanine aisayeukoke heera mewole Yesusle heene, na akona akona nemene me bee oro nen keli bele (14). ");
INSERT INTO set_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesus Wali Ondofolore hongkate na mekai ma nda niyae: Yesus nenake Maria Yusuflere endere be hinainyeboke, rore miyaere namman eyeiboi mo, Allahle Roh yae aungebokene Maria emale yeuboke. ");
INSERT INTO set_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yusuf wali himaloungeboke nekeweke aerene ro miyae helen bene febe mokonnebonde belene, Mariare maleu-maleu wae nennehinde naei merau raungehike. ");
INSERT INTO set_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yusuf nibi ninae mokoukoke Mariare nukennebondere. Ijongkune eungeke nebei u benene haiwole hee Allahle malaikat imene uwa yakaungeboke weunge, “Yusuf, Ondofolo kaban Daudle orona mena, Mariare rowele waei miyaere yembonde naeise wa kena wauwau wae okoijae. Rabuhine ban, Maria na kou bulu yahi buluna yale Fa ro miyae naeinya ban, nebeibe Allah yae Rohle walora Mariale kou ei yahi einye aungeboke yale. ");
INSERT INTO set_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Maria Kelu Fabe hononde, Na ro Yesus yae hele roungebonde. Rabuhine ban nebei Kiyae yae hele nda kanina kelana ro miyae hole emmimolonde na beko neban mokoyatera emmifaeinyende.” ");
INSERT INTO set_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Allahle ako faeuko Naei yendo kayaalo Yesaya yae eleukoke na hului yembonde naeise nda rambun bewate. ");
INSERT INTO set_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Yesaya nda mekai a eleukoke, “Maengke yele mbai emale miyae yembonde, kelu fabe hononde. Na ro ronainyebonde niyae: Imanuel.” (Imanuel na mekai: Allah aere ei haweyeume.) ");
INSERT INTO set_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yusuf ijongkura aunguke mo, Allahle malaikat yae imene ukeunge a huluinye hakouboke. Mariare roke nekewote. ");
INSERT INTO set_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nebeibe hokolo bee uwa mbainye ohonoi mo meinyekekokete Maria fa honoke. Allahle malaikat yae eleukoke huluinye, nebei Fa na ro Yesus yae rainyeboke. ");
INSERT INTO set_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesus Betlehem yone hongkate hee Herodes Ondofolore Yudea kanine nekewole. Nebei hee findelau mehinin mewalore isaei hebaen bele yo naufa Yerusalem yore mewate ");
INSERT INTO set_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","hinaimimeke, “Makeinye Yahudi naei Ondofolo manemfana hongkate? Maere kelemebo! Na findelau naufe reufine meuyakauboke eranneboke. Mana meyae nebei kiyaere eise molomandere baeimeyannele.” ");
INSERT INTO set_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ondofolo Herodes nane merau Yerusalemna ro miyae nebei a nanemene borowate hee na kena u isasa alalo kowate. ");
INSERT INTO set_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ondofolo Herodes ukeumile Yahudi naei imam yun-jun bele, Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi yo bele nanemene arileumihike mo hineumi, “Allah yae oro umaufe heraweungeboke Wali Ondofolo makeinye hononatere?” ");
INSERT INTO set_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nebei yo wainye, “Betlehem yone Yudea kanine. Nebeinye hononate yae Allah yae Na yendo kayaalo walora Betlehem naeise nda a moloukoke, ");
INSERT INTO set_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Mayae Betlehem yona ro miyae Yahuda kani honolene nekaube. Wa yo yan na hele melae, nebeibe Yahuda kanina Ondofolo holo erayete weyae melae ban. Rabuhine ban, wa yo ei yan eisa Ondofolo mbai menjakambonde, Raei ro miyae Israelre Neyae mende, obo yoku domba kayaalo nebei domba naei be yun be yebae hebate wanen mae, nebei ro miyae naei be yun be yebaere mensebende.’ ” ");
INSERT INTO set_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nebei findelau mehinin mewalore isaei hebaen bele naufa mekate yore Ondofolo Herodes maleu-maleu wae arileumihike wa, nebei findelau meujakauboke hee hinewoumine isaeyaeinyeboke. ");
INSERT INTO set_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nebeisa Ondofolo Herodes naufa mekate yore Betlehem yore enatere ukeumi mo a heraweumi, “Embe, nebei fa hongkate anuwau foi yae hinengkombe. Hubayengkombena bembombe mensewembe, rangkele yae erele, nebei fare be erensinende ei eremolonde.” ");
INSERT INTO set_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ondofolo Herodeslena a boraiboke heera, oro molaiboke Betlehem yore ewate. Nibi nolone ewate yae findelau nau reufine erekainyele kiyae bere holo yae nebei fa nekewole anuwau ranne yauboke. ");
INSERT INTO set_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nebei isaei bele hebaen bele yo benen findelaufe erekainyelene, rei mai sele kowate. ");
INSERT INTO set_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nebei imaene ayeuboke nebei Fa melae nenake Mariale nekewote hubayaeikoke, uwa are nihaeinyehike ei molowainye. Na run kangke wewe molaimiboke, na hili era akau era foi sele yarowate, nebei Fare kolowainye. Nebei rambun nda niyae: mas, kemenyan, mur. ");
INSERT INTO set_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ondofolo Herodesle bokore ebeiboi ei naeise Allah ime walora a hun raumihike. Nebeinye nda yo na yore yande nibi hira baeiboke ewate. ");
INSERT INTO set_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Naufa mekate yo kulun ukate ewate hee yae, Allahle malaikat benen Yusufre imene uwa yakaungeboke weunge, “Ondofolo Herodes nebei fa baennekonde hombondere merau raungehike. Nebeinye anyu, Fa melae nenakele bele yaweimibo hakangkombe Mesir kanire embe. Nebei kanine mo nekembe, benen bembombe naeise ware a ufete.” ");
INSERT INTO set_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yusuf aunguke, Fa melae nenakele bele yaweumiboke, nebei reniai mo kulun ukate Mesir kanire ewate. ");
INSERT INTO set_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Mesir kanine mo nekewate Herodes hereke hee yae bukaiboke Israel kanire mewate. Nda rambun bewate walora Allah yae Na yendo kayaalo Hoseale walora homone moloukoke huluinye yeuboke. Nebei a nda mekai moloukoke, “Mesir kanira Raei Kelu kaenerengkonde.” ");
INSERT INTO set_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ondofolo Herodes isaeyeuboke naufa mekate isaei bele hebaen bele yo nare ame-amebe baeinyekokene ikele hele kowole. Nebeinye felayore ukeumi, “Betlehem yore embe, naufa mekate yo rainyehike ralo yakama hului beera onde ane kelu fa-fa nemene hongkombe.” ");
INSERT INTO set_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nda rambun bewate walora Allahle yendo kayaalo Yeremia yae Israel kani naeise homone moloukoke huluinye yeuboke. Nebei a nda mekai moloukoke, ");
INSERT INTO set_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rime kali ayan buyan bole, Rama yora borande. Yahudi naei yobe Israel na miyae Rahel naei orona mena na fa-fa aerene rimele. Kena foi mokainye an, rabuhine ban na fa-fa nundate aerene.” ");
INSERT INTO set_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mesir kanine nekewate Ondofolo Herodes hereke mo, Allahle malaikat benen Yusufre imene uwa yakaungeboke weunge, ");
INSERT INTO set_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Anyu, Fa melae nenakele bele yaweimibo, kulun wembe Israel kanire eme! Rabuhine ban nebei Fare baewainyele honaibondere merau kolowainye yo ninae heraiboke.” ");
INSERT INTO set_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yusuf aunguke, Fa melae nenake bele yaweumiboke, kulun ukate Israel kanire ewate. ");
INSERT INTO set_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Yudea kanine Arkelaus naeko Herodesle a bulure Ondofolore ranaijeke a boroubokene Yusuf buhae hokoungeboke nebei kanire ei. Imene Allah yae keleungeboke huluinye, Yusuf naei Galilea kanire ekate. ");
INSERT INTO set_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nebei kanire ekate, yo mbai na ro Nazaret, nebei yone ekainyekewate. Allahle yendo kayaalo Yeremia yae Yesusle are moloukoke na hului yeuboke. Nebei a nda mekai moloukoke, “Nare Nazaret yona ro yae enainyeronde.” ");
INSERT INTO set_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ralo yakama 30 hului mainyekeukoke mo Yohanes bure koumi kiyae Yudea kanina a kala-kalane na uwa meumiyakauboke ahuba huwewoumi weumi, ");
INSERT INTO set_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Mai beko nebanda nulu kenayembe! Rabuhine ban Allah merau raungehike ya ninae nobeungeboke Naei holona ro miyae Wali Ondofolole me kelee u keleene menayorulembonde nekenate.” ");
INSERT INTO set_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohanesle naeise Allahle yendo kayaalo Yesaya yae a yen kolowole, weumi, “Ro mbai a kala-kala anuwaufa kali yae kaenele weumi, ‘Tuhan menderene wali nibi mokonnehambe, yeli-yeli kayeero ijen alonnehambe.’ ” ");
INSERT INTO set_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohanes na malo hirewole unta maara haikoke, na yolu ha rinewole nebei obo yoku rara mokouboke. Kesengki bele akelana madu bele anewole. ");
INSERT INTO set_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ro miyae Yerusalem yora, Yudea kanira, nane merau Yordan Wi kelaeunga yo honatera Yohanesle bokore hokoumeke. ");
INSERT INTO set_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nebei ro miyae hokoumeke Yohanes yae uwoumi ane boraiboke. Na me u beko mokowatere wo kaikoke yore, Yordan Wine Yohanes bu kowoumi. ");
INSERT INTO set_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yahudi era henare na bereise eraimi holo mbai Farisi yae ro raimiboke yo nane merau nulu yo mahe yora benen ewaleiboi are kelaeimi Saduki yae ro raimiboke yo helen sele bure kowoumi anuwaufe mekate. Nebei yo erekeumine Yohanes yae weumi, “Mayae rami ehekaei wanen hangkei, faeu kai bee. Allah mare ehee bukulu inyembombe belene mai walire himalonnebombe naeise, nde yae mare angkaa yobombokembe? ");
INSERT INTO set_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mai wali beko nebanda nei huwayembokembena, na ani nebei suluinye mai u mekai wa mekainye kelembe. ");
INSERT INTO set_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mai uware menaeijae bumane kaeube wa elaube, ‘Meyae Abrahambe orona mena yo.’ Nebei aerene mayae u bene nekayembe Allah mare Naei ro miyaere me baele. Reyae wamale, nda ruka yoni-yoni honatera Allah na hului Abrahambe orona menare weumile yaeiboube! ");
INSERT INTO set_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nda hee ramekahu o kambu kelaeunge relahi mokoungehake. O anire omokoi yo nemene kahende balenate, inye hayende hukulenate. Nebei sului mbai Allah yae Naei kenare kole me u omokoi ro miyaere ehee bukulu yemmile.” ");
INSERT INTO set_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Mai wali nei huwembokembe iwau naeise Reyae mare bu yae kamale. Raei moisa mende Kiyae Allah yae Nare uwa keteungebokene naei oro mehau kaerebondere Reyae yeisi raeiboi ban sele. Nebei Kiyae Niyae ro miyaere Allahle Roh hawemmile, nane merau i naumene rambun hibate wanen mae a elae elende walora ro miyae kena u einye mokommile. ");
INSERT INTO set_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kayeere wahende naei hiloi kaban Na mene rouke gandumde arilendere. Ani yo naei fale einye kolonde, rebauka yoni-yoni i na hibi mo beyele nebei nolone ensayengkonde hukulenate. Nebei sului mbai Allah yae ro miyaere mokommile.” ");
INSERT INTO set_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yohanes yae bure konnebonderene, Yesus Galilea kanira Yohanesle bokore Yordan wire eke. ");
INSERT INTO set_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yohanes na melihau fele erewoungene weunge, “Weyae rare bu korebomae ya! Na man ban sele reyae Ware bu koreibotere mewoyae.” ");
INSERT INTO set_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesus yae weunge, “Reyae wawale huluinye yeubo. Nebei mekai yaere Allah Naei kenare kole huluinye haraungeboke ma nanemene eyae hakomabonde.” Yesusle ane Yohanes hakouboke. ");
INSERT INTO set_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Bu koungeboke mo, Yesus yeukiteke. Nebei hee yaku wewe koukoke Yesus erele Allahle Roh aye merpati wanen mae nauwa rande oke. ");
INSERT INTO set_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Yakura nda a wanen mae elele, “Nda niyae kena buhaere haenale Kelu, Ra kenare foise mokoyeufe Kiyae.” ");
INSERT INTO set_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yesusre bu koungebokera, walobo yun mae umalire hubannehinderene Allahle Roh yae Yesusre yaweungehoke, a kala-kala anuwaufe ekete. ");
INSERT INTO set_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ya rorele u bee reniai bele rai bele raman aneikoi mo meunekeukokene, Yesus moni hele hubawounge. ");
INSERT INTO set_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nebei hee yae walobo yun meke mo Yesusre weunge, “Weyae na hele Allahle Keluna, mana nda ruka yoni-yoni honate weimi, ‘Ramande yaeibo.’ ” ");
INSERT INTO set_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nebeibe Yesus yae weunge, “Allahle homofaene nda wanen mae molaikoke, ‘Ro miyae raman elaene mo wali enekei, Allahle Naei a elelere hakate walora ro miyae na hului walire nekenate.’ ” ");
INSERT INTO set_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nebeisa mo walobo yun Yesusre yaweungehoke Yerusalem yone Allahle ei mom-mom imae na kaban sele kiyae naei mali ranne haungeboke wa ");
INSERT INTO set_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Yesusre weunge, “Weyae na hele Allahle Keluna, mana honoinyihi are oyo. Waei naeise Allahle homofaene molaikoke, ‘Woro rukane oungende belene Allah Na malaikat yoni-yonire weumile na me hirenaibonde Ware hole molonayeibote.’ ” ");
INSERT INTO set_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesus yae walobo yunde weunge, “Allahle homofaene nda wanen molaikoke, ‘Allah waei Tuhan Nare weyae umali ehubainyemae!’ ” ");
INSERT INTO set_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nebeisa walobo yun kiyae Yesusre yaweungehoke elu mbai buma hosoro helere ekete. Nebeise ekete wa, Yesusre nda kani kelana yo yan na one hengko bele nemene kelewounge. ");
INSERT INTO set_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Walobo yun mae weunge, “Weyae raei bene uwa are niheungehinde ei moloufebondena, nda kani kelana yo yan ereyae nemene Ware mo kinyerete hakerete.” ");
INSERT INTO set_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesus yae walobo yunde a elae lon mae haeungeboke weunge, “Walobo, raei bera nundeye howaleye! Allahle homofaene nda wanen molaikoke, ‘Allah waei Tuhan, ei moloungele nane merau Naei a elele mo hakoungele!’ ” ");
INSERT INTO set_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Walobo yun moise keungehike. Malaikat yoni-yoni mekate Yesusre ei mekaisauwainye. ");
INSERT INTO set_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","13","Yesus Nazaret yone nekewole hee, Herodes yae Yohanes bure kowoumi kiyaere kawane heungekoke a boroke hee Nazaret yora kulun uke Galilea kanina yo mbai na ro Kapernaum Galilea bukoba enene honolere yae eke. Na bere Zebulonbe Naftalile rore rowaimi kani ranna. ");
INSERT INTO set_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Allahle yendo kayaalo Yesaya yae eleukoke a na hului yembondere nebei kanine Yesus ekenekewole. ");
INSERT INTO set_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Yesaya nda a mekai moloukoke, “Zebulonbe Naftalile kani Galilea bumoko wai reufina honate. Naubure ende nibi naei kani Yahudi ban ro miyae nekate anuwau. ");
INSERT INTO set_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nebeinya ro miyae ouben hauben nolone, rabuhine ban Allahre isaeyeiboi nekeimeyate. Nebeisa Allah Naei a foi faeu foi kelemmile wali nibi foi naeise. Nebei a faeu hehe wanen nebei ouben haubenne hehe enaibolombonde.” ");
INSERT INTO set_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nebei heera Yesus huba raweuboke ro miyaere huwoumi weumi, “Ma u mekai beko mokoyaubera nei hungembe, uwa olomombe. Rabuhine ban, Allah merau raungehike ya Naei ro miyae Raei me kelee u keleene menayorulembonde nekenatere nobeungekokene.” ");
INSERT INTO set_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kapernaum yone nekewole hee, ya mbai Yesus Galilea buhaeisa oroweke mo, kare baete ro bee naekale nauwakele wau wae kane baewote erekeumi. Nebei ro bee na ro niyae: Simon, Petrus yae raiboke kiyaele, Andreas bele. ");
INSERT INTO set_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesus hokolo beere weumi, “Mebu, Rare meisehakoko. Reyae elae isebe. Nebei elae walora mayae ro miyaere baemile Raei me kelee u keleene menayorulembonde nekenate. Kare baeube wanen mae nebei ro miyaere baebebe.” ");
INSERT INTO set_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nebei a boroibokene, na hibi hele na ka baei-baei kalia nukeiboke, Yesusre hakoinyekoke. ");
INSERT INTO set_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesus nebei bee bele oro molaiboke ewate mo, benen ro bee naekale nauwakele hubayaeikoke. Nebei ro bee Zebedeusle kelu wa na ro: Yakobusle Yohanesle. Hokolo bee naeko Zebedeus bele naei kai einye wau foinye mokowate. Nebei ro beere Yesus nane merau kaeneumikoke. ");
INSERT INTO set_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Hokolo bee na hibi hele na waka nukeiboke, nane merau naekore nukeinyeboke, Yesusre hakoinyekoke. ");
INSERT INTO set_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesus Galilea kani yanewole na Allahre ei mom-mom imae hine hine ro miyaere nda a foi faeu foi huwoumi: Allah merau raungehike ro miyae Raei me kelee u keleene nekenatere wali hena bona inyemile. Nebeinya ro miyae era buloo na mane-mane kowate yore Yesus onomi iwoumi. ");
INSERT INTO set_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Erana buloona yore Yesus onomi iwoumi a Siria kanire eungeyoboukoke. Erana buloona yo na mane-mane bele, u buhae kaban kowate yo bele, alo yae hawaimiyeke kayeke yo bele, u rani-rani kate yo bele, oro mere nimewaimi yo bele, Yesusle bokore onomire yaronatere yauwaimi mewate. Yesus na hibi nebei yore onomi iwoumi. ");
INSERT INTO set_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ro miyae helen sele Galilea kanira, Dekapolis kanina yo me bee yora, Yerusalem yora, Yudea kanira, nane merau Yordan wi reufira mewate Yesusle moisa mo hakowainye. ");
INSERT INTO set_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nebei ro miyae helende Yesus erekeumi hee, mokore yae Yesus ike, angken nuweuboke hee yae na moisa orowate yo Naei bokore mekate. ");
INSERT INTO set_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Yesus huba raweuboke kelewoumi weumi, ");
INSERT INTO set_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ro miyae naei u mekai beko mokoyelera roiboyoungera alonnehandere, Allah mbai yae na hului hakonnebonde naeise isaeyeiboyele ro miyae onomi foka hubannende. Nebei ro miyae Raei me kelee u keleene nekate holona ro miyae yae me baerebonde. ");
INSERT INTO set_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ro miyae naei u mekai beko mokoyelera roiboyeungene kena beko koyele kiyae onomi foka hubannende. Allah nebei holonare kena foi u foi mokommikonde. ");
INSERT INTO set_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nauwa ro ban elele kiyae nane merau Allah weunge a hului rilibo ban olomo narulu ban u mekai ma nekende ro miyae onomi foka hubannende. Allah yae nda kani kela nebei yore kinyemmile hakemmile. ");
INSERT INTO set_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Wali himalonnebondere kena haehae koyele kiyae, neyae onomi foka hubannende. Nebei kiyaere wali himalonnebonde naeise Allah yakannebonde. ");
INSERT INTO set_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Yanekoi yase bele kiyae, neyae onomi foka hubannende. Allah nare yanekoi yase yae ei hawennele. ");
INSERT INTO set_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ro miyae naei kenare kole bele Allah naei kenare kole bele na hului mbainye orole kiyae, neyae onomi foka hubannende. Nebei holona ro miyae Allahre ijoko enainyerende. ");
INSERT INTO set_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ro miyae mbai hiwa yo naei yokeijo belere foi mokoyeumi kiyae, neyae onomi foka hubannende. Nebei holona ro miyaere Allah Naei kelu omi yae kaenemmile. ");
INSERT INTO set_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Allah Naei a elelere hakoyeunge aerene weitasi koyainye kiyae, neyae onomi foka hubannende. Nebei ro miyae Raei me kelee u keleene nekate holona ro miyae yae me baerebonde. ");
INSERT INTO set_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Mare Raei aerene a beko yae ungayembe, mare weitasi konayembe, nane merau na hele ban a beko yae aukaka konayembe, nebei mekai ma mokonayembena, onomi foka hubannembe. ");
INSERT INTO set_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mayae rei yae mai yae kombe, rabuhine ban Allah surgana mai me buhae kaban mokoungehake. Mare u mekai beko mokayembe nebei sului mbai Allahle yenjo kayaayo holonare na bere mokowaimile ma mbai. ");
INSERT INTO set_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Hae raman einye yuweiboyole wanen mae nda kani kelana ro miyae naei wali einye mayae foi mokommiyembe. Hae naei han faennekondena nebei han benen emereiboi sului. Nebei hae rabuhi ban yeubokene, hainyaikonde ifau wanen nendon mae ro miyae ele mele na ranne oronate. ");
INSERT INTO set_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Nda kani kelana ro miyae bene mayae hehe wanen naeukoke nekaube. Moko ranne hebate yo yande naeungekoke isehe faunge nekate ro miyae nanemene na hului erenate. ");
INSERT INTO set_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Hehe mokonnebonde ro miyae na hului ijoko erei-ereise erenate. Ise releikoyeunge boloisiyele ro miyae nebeisa helai yae obumboi. Nebei imaena ro miyae nanemene hehe naemmikonderene bende anuwaunge ambonde hele. ");
INSERT INTO set_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nebei sului mbai, ro miyae bene mai me u foi mokombe. Nebei me u neyae hehe merau erenate. Mai me u foi mokombene, mai Ako surgana ekenekele Kiyaere buma enainyekolonde. ");
INSERT INTO set_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Musale walora wali heere foloukoke bele Allahle yenjo kayaayo homone molaikoke belere hororebonde naeise mekale bene yae enekeijae. Naeinya hesele na mekai ma haraungebokere kelerembombere mekale. ");
INSERT INTO set_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Reyae nana heselebe mare wamale, nda yaku bele kani kela bele ainyundeuboube hororebe, nebeibe Musale walora wali heere foloukoke homona molaikoke a nemene fomene honnate nda kani kela huba mennemokongkonde heene. ");
INSERT INTO set_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nebeinye nde yae Musale walora wali heere foloukokena berei ban sele are horombonde nane merau nebei horoubokere hiwa yo mokonatere kelemmilena, nebei ro raei me kelee u keleene nekate holone ro ban sele yae me baerebonde. Nebeibe nde yae nebei rabuhi ban sele are hubara haeisa yanennele nane merau hiwa yore nebei sului hakonatere kelemmilena, nebei ro Raei me kelee u keleene nekate holone ro bele holona yae me baerebonde. ");
INSERT INTO set_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Reyae mare wamale, Farisi holona yo bele Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi holona yo bele naei wali himalonainyelere Musale walora wali heere foloukoke hakoyainye. Nebeibe nebei wali nibi yae wali ehimaloiboi sului. Mayae Raei me kelee u keleene nekate yo holonare emembombere mai wali himalonembomberena, Raei a elerelere hila rabo halembe hele. Nda wanen maere mai u mekai Farisi holona bele Saduki holona bele yo naei wali moi wommiyombe. ");
INSERT INTO set_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Musale walora wali heere foloukokena ma haraungebokere Yesus yae kelewoumi weumi, ‘Mai yobe naei kamahe naeise nda uwaimile a mayae boroimeyaube: Ro miyae ohoijae! Ro miyaere hombonde kiyae, na walire ro miyae hului ranainyehinde ehee bukulu inyainyele.’ ");
INSERT INTO set_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nebeibe Reyae mare wamale, naendae wanen horo ro mbai na aka baekere ikele mo konendena, nebei kiyae naei walire ro miyae hului ranainyehinde ehee bukulu inyainyele. Nebei sului mbai nde yae na aka baekere a haufau okonnekonde, nebei kiyae naei wali Yahudi naei yoyo koseyo hului ranainyehinde ehee bukulu kaban hainyainyele. Nde yae na aka baekere a haufau okonnelena, nebei kiyae naei walire Allah yae hului rannehinde, narakana i kaban beyelene wononde. ");
INSERT INTO set_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Nebei aerene weyae Allahre ei mom-mom imaere na ongkou felate itukai rande wa hili era akau era Allahre yeungelere ekae yae bene nekeufikete wa aka baeke ware na kena eisa ikele kotena, ");
INSERT INTO set_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","nebei hili era akau era itukai bene nukeubonde hononate, beufonde ele wa aka baeke bele foi mokokobe. Nebeisa mo Allahre ei mom-mom imaere ele, wa hili era akau era Allahre buma eungekolonde. ");
INSERT INTO set_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Wa yokeijo mai ikele koube rambunde ro miyae bene a faeu yakangkonderena, u hasale yae foi mokokobe. Nebei omokoiboinya, nebei yokeijo ware are hokate ro naei me eise kinyeneibote benen ikilenayeikote na kayaa yore inyemmile ware kawane ahenayeukonde bele. ");
INSERT INTO set_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Na helebe Reyae wamale, Kawa einye ahenainyekonde, na roi hului aheikoi ebaeisoinya, weyae nebei kawara emeituwei sului.” ");
INSERT INTO set_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mai yobe naei kamahe naeise nda ukaimi a mayae boroimeyaube, ‘Ro hi naei miyae bele uwa mbainye eisonoijae.’ ");
INSERT INTO set_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nebeibe Reyae mare wamale, ro nde yae miyae maengkere ijokone mo erenende yae u beko naeise na kenara ura rowenehindena, nebei ro nebei miyae maengke bele uwa mbainye honoikoke. ");
INSERT INTO set_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Na hului nda wali nekandene ijoko mbai era buloone elaekei sele konde. Na foi sele nebei ijoko mbai keleufinde, ijoko bee yae euferende belene. Nebei sului mbai weyae na hului u bene beko nekenayetene, weyae rambun beko ijoko yae ereubonde. Naei foi sele waei u bene bekore herawewende, weyae narakare ele belene. ");
INSERT INTO set_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nane merau me mbai na hului era buloo elaekei sele konde. Na foi sele nebei me mbai neufande, me bee yae euferende belene. Nebei sului mbai weyae na hului u bene beko nekenayetene waei me yae beko mokoubonde. Naei foi sele waei u bene bekore herawewende, weyae narakare ele belene. ");
INSERT INTO set_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Mai yobe naei kamahe naeise nda ukaimi a mayae boroimeyaube, ‘Ro nde yae na miyaere nennehinderena, neyae homo molongkonde nare yennele hele. Nda homone yakambonde nebei miyae naei ban.’ ");
INSERT INTO set_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nebeibe Reyae mare wamale, ro mbai na miyae ro hi bele uwa mbainye ohonoibe, nebeibe nennehindena, nebei ro mokoungeboke naei miyae u beko mokonde. Nane merau ro nde yae neungehike miyaebe rowendena, neyae u beko mokouboke, ((rabuhine ban Allahle ro be ro yoinye nebei miyae bena ro bele naei miyaere yeubokene.)) ");
INSERT INTO set_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Mai yobe naei kamahe naeise nda ukaimi a mayae boroimeyaube, ‘Weyae a holore koukokae rambun asasi okoijae. Allahle ro randa a holo koukondena, na hibi yae mokoubonde.’ ");
INSERT INTO set_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nebeibe Reyae mare wamale, a holo nendon okoijae. Surga ro randa a holo okoijae. Rabuhine ban surga Allah Naei kendan wamerande yeuboke. ");
INSERT INTO set_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nane merau kani kela ro randa a holo okoijae. Rabuhine ban kani kela Allah Naei oro hensen anuwau. Nane merau Yerusalem ro randa a holo okoijae. Rabuhine ban Yerusalem Ondofolo kaban Allah Naei yo yan. ");
INSERT INTO set_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nebei sului mbai waei uwana yun randa a holo okoijae, rabuhine ban waei yunna umaa mbai sambai keleumonde yembonde nane merau nokommon mare yembonde naeise weyae omokoiboi sului. ");
INSERT INTO set_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Na fokai fere weyae ‘ehee, niyae ban’ eleukondena, nebei a huluinye mokoubonde hele. Waei a eleyae Allah yae nemene fomene boroyele. A helen baraumilena, nebei a walobo yun belera mate. ");
INSERT INTO set_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mai yobe naei kamahe naeise nda ukaimi a mayae boroimeyaube, ‘Ijoko na ijoko yae beneikonde, heraa na heraa yae beneikonde.’ ");
INSERT INTO set_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nebeibe Reyae mare wamale, mare bekore mokonayembe yore beko yae ebeijae. Nde yae wa kahu meube reufi ungetena, waeungehinde meli reufi bele ungete. ");
INSERT INTO set_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nde yae hakimde bokore waei ei malo hireyae aerene yaungeufonde ebena, waei moi malo hireyae bele nare yeungele. ");
INSERT INTO set_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nde yae ware kilometer mbai yae mo hakoungebonde ebe naeise elae hele molonetena, weyae kilometer bee yae nare hakoungebonde. ");
INSERT INTO set_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ro miyae waeinya rambun rinyayetena yeumiyende. Nane merau ro miyae waeinya rambunde rinyeisite ya hire menahengkondere ungetena, ahi eweijae hele. ");
INSERT INTO set_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mai yobe naei kamahe naeise nda a ukaimi boroimeyaube, ‘Wa kena buhae u buhae mangkele ya-ya wali nibi mbaise oraube yore mo heumiyende, wa yokeijore ikele yae koumiyende.’ ");
INSERT INTO set_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nebeibe Reyae wamale, ma yokeijore buhae hemmiyembe, nane merau ro miyae mare weitasi koyayembe yore Allahre riyennehimbe onomi foka yae ei hawemmile. ");
INSERT INTO set_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Nebei mekai yaere mai Arai Allah surgane nekele Kiyaele kelu omire yembombe. Rabuhine ban ro miyae wali foi nekeyate, wali beko mokoyate nanemene Allah waesiyeumi hu naekoyeumi. Nebei sului mbai wali himalainyeboke yore, me hila u hila bele yore Allah waesiyeumi ya rileyeumi. ");
INSERT INTO set_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ro miyae kena buhaere haeyembe yore mo mayae kena buhae hemmilena, rabuhi ban yeuboke! Nebei u mekai ma mbai pajakre yoko bele riyaimi yo mokate lonbe. ");
INSERT INTO set_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nane merau mayae ro melaeyeiboise mai aka baeke ware mo a melaeyaumina, rabuhi ban yeuboke! Ro miyae Allahre oroiboi wanen nekeyate yo nebei sului mbai mokoyate lonbe. ");
INSERT INTO set_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nebei aerene mai Arai surgane nekele Kiyae naei wali nekele ma, mayae nebei sului mbai wali himalennebombe hele.” ");
INSERT INTO set_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Kayaa hebembe, mai me foi u foi ro yae miyae yae ijokore erenayembe naeise omokoijae. Rabuhine ban ro miyae erenayembe naeise mokombena, Arai surgane nekele Kiyae mai roibu eyei. ");
INSERT INTO set_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Nebei aerene ma hili era akau era hun ban wai ban yore yemmiyembena burelen mae oboyeijae. U mekai beere oroyate yo yae nebei me ma u ma mokoyate. Ro miyae nare be hinenaimile naeise Allahre ei mom-mom imaene naei me u mokatere amin mae raneiboyate burelen eibowate nane merau nibine ane huweyaimi. Reyae na helebe wamale, nebei ro ma miyae ma na roibu nemene ninae yaraikoke. ");
INSERT INTO set_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ma hili era akau era hun ban wai ban yore waheyaumi heene, a ban ma mokombe, meube me yae yeumiyaumi, meli me isian wanen mae mokombe. ");
INSERT INTO set_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Mai me foi u foi mokaube nunne-nunne mokombe. Mai Arai nunne mokaubere erembene ma roibu wahenembe. ");
INSERT INTO set_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Allahre ebelire bonnele hee, u mekai beere oroyate yo naei u mekaise ehakoijae. Nebei yo na kena hele eikowate Allahre ei mom-mom imaene nane merau ro miyae helen orate nibi kainye aufae yae hebeiboyate, ro miyae yae ijokore erenaimilere ebeli eibowate. Reyae na helebe wamale, nebei yo na roibu ninae yaraikoke. ");
INSERT INTO set_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Weyae Allahre ebelire boungehinde hee, wa u mbai yae yowa eise eweufinde, romau ahuneukonde, Arai ereiboi Kiyaere ebeli boungehinde. Wa me u nunne mokoyaere waei Arai yae erete nane merau roibu inyete. ");
INSERT INTO set_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Allahre onaeinye yo yae molate wanen mae waei ebeli einye a mbai mo eibeko meibeko ebeijae. Neyae u bene nekaimi a eibeko meibeko yae benaimilene naei ebelire bainye kiyae yae borommibonde. ");
INSERT INTO set_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nebei yo naei u mekai wa mekainye ehakoijae. Rabuhine ban, mai wali rambun namman eriyeisi mo mai Arai na bere isaeyeuboke. ");
INSERT INTO set_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Mai ebeli nda wanen mae bonnele, ‘Arai surgane nekeyae, Waei ro nene waewae hele yae mokomayewende. ");
INSERT INTO set_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ro miyae Waei me kelee u keleene nekate yo yan meinyeibo. Waei kenare koyae surgana wanen nebei sului mbai nda kani ran kela ranne mokommikonde. ");
INSERT INTO set_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Maei raman mana ya naeise maere na hului yae yeumele. ");
INSERT INTO set_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Maei beko neban faeinyeumeko, meyae hiwa yo naei beko neban mokaimekokere u bene nundaimekoke wanen mae. ");
INSERT INTO set_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Maere wabenaimele hee, ei haweumele meyae ane nalemmihinde balemale belene. Walobo yun, bekore mokole kiyaele me ei u eisa hole moloumebonde. ((Rabuhine ban Waei me kelee u keleene ro miyae nemene nekenate. Elae wake nane merau one hengko bele Waei einye huba ban haei ban ninae hononende. Amin.))’ ");
INSERT INTO set_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ro miyae hiwa yo yae mare beko mokayengkokembere mai u benene nundemmikombena, mai Arai surgana nebei sului mbai mai bekore faeinyenembombe. ");
INSERT INTO set_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nebeibe, mayae hiwa yo naei beko mare mokayengkokembe u benene enundeikoinya, mai Arai nebei sului mbai mai me u beko mokaubere efaeinyeiboi. ");
INSERT INTO set_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Mayae mai kena huluinye yarele me hembombe hee, ma be yoi u mekai beere orate yo yae kena bekone kate mokoiboyate wanen mae enekeijae. Nebei yo ro miyae erenaimile naeise yarele me heiboyate mom nekate be yoi baeinyehoke. Reyae na helebe wamale, nebei ro ma miyae ma na roibu nemene ninae yaraikoke. ");
INSERT INTO set_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nebeibe mayae yarele me hembombe mon nekembena, ma be yoi nendon ma erenayembe naeise bu yae hobengkombe nane merau ma yunne minyak yae hengkombe. ");
INSERT INTO set_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Nebei wanenne ro miyae isian mayae yarele me heiboyaube mon nekaube naeise. Mai Arai ro miyae yae ereiboi Kiyae mai me u nunne mokaubokere Neyae ijoko erenembe. Neyae mai roibu wahenembe. ");
INSERT INTO set_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Eba he nda kani ran kela ranne waei u mbai naeise arileyeijae. Rabuhine ban, nda kanine oyaya bele ehi bele rambun-rambunde bekore mokate, nane merau yokoyo yae honate anuwau kelarenaibonde. Nebei rambun yoko yae yaronaikonde. ");
INSERT INTO set_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nebei aerene naei foi sele mai eba he surgane kolon, rabuhine ban oyaya bele ehi bele bekore omokoiboi sului, nane merau yokoyo yae ekelaiboi. Nebei rambun yoko ebaeikoi sului. ");
INSERT INTO set_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Rabuhine ban waei ebare here honnayete anuwaunge, waei kena u nebeinye. ");
INSERT INTO set_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Mai kena una hubaunge mai ijoko wanen mokoikoyole. Rambun na foi reufine mo eremembena, hehere erembe wanen mai u bene foi nekenayembe yae nekemembe. ");
INSERT INTO set_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Rambun na beko reufine mo eremembena, ouben hauben erembe wanen u bene beko nekenayembe yae nekemembe. Mayae u bene beko na hibi-hibi nekenayembena, mai kena une beko mo eremembe. ");
INSERT INTO set_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ro miyae mbai rowa bee naei yebaei bubaeise eyeiboi sului. Rabuhine ban hire ikele yae konnele, hire buhae yae hennele. Nane merau hire mo boronnele, hire oboroi. Allah Naei a elele hakombombe bele roise abunembe kena roungensimbe bele na beene na kulun mbainye mayae omokoiboi sului. ");
INSERT INTO set_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Nebei aerene Reyae wamale eraman bu, malo, nda wali nekemale rambunde buhae ohokoijae. Allahle ro be ro yoinye aei wali nekemale ma na bereise aei wali rambunde. Raman bele malo bele Allah na foma-foma mokommihande. ");
INSERT INTO set_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Eremmi, aye bumana o haka eheraeyeyei, ani era emaluyei, ufeyei heke falene okoloyei, nebeibe mai Arai surgane nekele Kiyae na hibi-hibi nareyeumi. Nebei aye yoni-yonira mare na bereise yae Allah erembe. ");
INSERT INTO set_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nde mai nolona buhae-buhae koyele walora na hului hukai mbai na wali baraungeboke heki meungeyoboukoke? ");
INSERT INTO set_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Nane merau rahene hirembe naei malo aerene buhae hokombe? Akelana arokou hebate ereibo buleibo konne, me ban u banbe baengko fereisayeunge. ");
INSERT INTO set_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nebeibe Reyae mare wamale, Ondofolo Salomo one bele hengko bele ketewainye hororebe na malo bae Allah arokoufe hiyei raneungeboke ma ehireikoi mo. ");
INSERT INTO set_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nebei mekai mbai yae Allah akelana arokou na foi bele keteumiboube hororebe mana ya hebele wahenare i ranne hayeikoube, hila rabo kalore moloyembe hororebe, Allah mare emekai bele yae kitenembombe. ");
INSERT INTO set_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nebei aerene buhae ohokoijae, nda a mekai eleijae, ‘Rahe raman mae anemale? Rahe bu yae anemahinde? Nane merau rahe malo yae hiremale?’ ");
INSERT INTO set_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nebei rambun yoni-yonire Allahre oneyainye yo yae hineyate baeyate. Mai Arai surgane nekele Kiyae naeisaei sele mai walire nebei rambun yoni-yoni nemene baeyaube mo. ");
INSERT INTO set_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nebeibe Raei me kelee u keleene nekate holonare me baenembombere relennekombe nane merau Raei a elalere hakongkombe rambun na bemere hele. Mai wali rambun nemene bararemembe. ");
INSERT INTO set_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nebei aerene wahena ya naeise buhae ohokoijae. Rabuhine ban wahena ya maei kena bekore mokommele rambun nenaei. Ya mbai buhaere hokoyembe rambun na hului yae benayende.” ");
INSERT INTO set_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Weyae hiwa yo naei bekore hului okoloijae, waei bekore hului ranayeisite bele. ");
INSERT INTO set_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Rabuhine ban, hiwa yo naei bekore hului kolamae, nebei wanen mbai waei bekore hului ranayeisite. Hiwa yo naei rambunde hului kolamae wanen nebei sului mbai ware mokonayete. ");
INSERT INTO set_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Rahe londe waka baekele wali na beko reufire mo a eleyae nebeibe waei wali naeise weyae ereiboi! Nda hului mbai waka baeke na ijokona kerende mo ereyae, waei ijoko einya o male aheukokere weyae isian nekeyae! ");
INSERT INTO set_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Naendae wanen lon mae waka baekere wanae, ‘Mei, wa ijokona keren don reyae roufe,’ nebeibe waei ijokona o male bae na hibi mo honoimeyele? ");
INSERT INTO set_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Weyae u bee-beere koyae kiyae! Na bemere waei ijokore aheukokete o malebe weinye. Wa ijoko yoloneukonde mo, nebeisa waka baekele ijokona keren weyae rowele. ");
INSERT INTO set_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Allah Naei ako faeuko rambun foi sele moi sele nau buna mutiara wanen mae yeuboke. Nebei ako faeuko obo yoku u mekai wanen ro miyaere ehuweijae. Obo mutiara ranne nendon oro aleikoyate wanen mae nebei yo yae Allah naei ako faeukore a beko elenate. Yoku benaibonde ware akenayeikote waei uwa fo bee-bee raungayeikote wanen mae neyae ware a yae horonayete. ");
INSERT INTO set_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mai kenare kaube rambun inyengkomberena, na hibi mo riyennele. Mayae ereibo rambunde hubayengkomberena, na hibi mo baembe. Me kaba-kaba bonnelena, romau mare raungembombe. ");
INSERT INTO set_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Rabuhine ban nde yae riyende kiyaere yennele. Nde yae baende kiyae, hubainyekonde. Nde yae me kaba-kaba bonde kiyae, romau raungembonde. ");
INSERT INTO set_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Ako nde mai nolona nekele na kelu feufe riyewoungebe ruka yae ikeunge, ");
INSERT INTO set_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","nane merau kare riyewoungebe rami yae ikeunge? ");
INSERT INTO set_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mayae beko bele neban bele yo maisaei nekaube ma kelu omi riyayembere foi bele moi bele rambun yeyaumi. Na kaban sele mai Arai surgane nekele Kiyae foi bele moi bele rambun Nare riyeyainye yore yeyeumi. ");
INSERT INTO set_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Me naei u naeise mai kenare kaube huluinye ro miyae mokonayemberena, nebei sului mbai hiwa yore mokommile. Musale walora wali heere foloukoke homo bele, Allahle yenjo kayaayo naei homo bele, nebei a na no niyae. ");
INSERT INTO set_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Raei a elalere hakoyate romau melaera enayembonde nibi kikira orate wanen. Wali nibi hi kiyae kaeu mau molaimiboke na romau kaban. Romau kikira eweufinde. Rabuhine ban, romau kaban bele nibi kaeu mau bele bekore eke nibi, ro miyae helen sele nebei nibira hakaikoke ate. ");
INSERT INTO set_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nebeibe romau melae bele nibi kiki bele nebei wali henare ate nibi niyae. Ro miyae na hangka hele nebei nibi aisubayekoke. ");
INSERT INTO set_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ame-amere yanate yenjo kayaayore kayaa hebembe. Mai bokore domba wanen kena nime haba menatebe, serigala wanen hangkei sele. ");
INSERT INTO set_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Na u mekai wa mekai kelenatera mayae nebei yore rommibombe. Ro yae miyae yae isa bele nora anggur ani ohokoiboi. Nane wanen fonom bele kaiwa bele nora ara ani ohokoiboi sului. ");
INSERT INTO set_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","O rimi-rimina ani foi mokonde. O beko na ani beko mokonde. ");
INSERT INTO set_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Na hului ban sele o rimi-rimi kiyae ani bekore omokoi sului, nane merau o beko kiyae ani foise omokoi sului. ");
INSERT INTO set_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","O ha ani foise omokoi yo, kahenate i tanne hainyate. ");
INSERT INTO set_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nebei sului mbai ame-ame yae yanate yenjo kayaayo na u mekai wa mekai kelaetera mo mayae rommibombe. ");
INSERT INTO set_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ro miyae nde yae Tuhan mae kaenensele aerene mo raei me kelee u keleene nekate yo holone eyeisi. Naeinya hesele nde yae Maeko surgane nekele Kiyae kenare kole huluinye mokonde kiyae na hului enensinde. ");
INSERT INTO set_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Huba mokoikoi ya mendene, ro miyae helen sele Rare ungaisele, ‘Tuhan, meyae ro miyaere Waei ro yae kelewammile, buloo walobore Waei ro yae hukewammile, nane merau rambun emere-emere Waei ro yae mokowandebe ya!’ ");
INSERT INTO set_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nebei hee Reyae na yaka yae ufemile, ‘Reyae mare onaemale. Mayae bekore nebande mokoyaube yo, Raei bokora felande yae eme!’ ");
INSERT INTO set_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Nebei aerene ro miyae nde yae Raeinya a faeu elalere borole na hibi me yae u yae mokoimeyele kiyae, nebei kiyae isaei hebaen bele ma yae uwa haraungeboke kiyae na imae ruka ranne heuboke wanen mae ahunebokale. ");
INSERT INTO set_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ya woke molowole, bumae meke nane merau alu boye elaekei sele raweuboke. Nebei imae nekeunge nebeibe ebuleisai, rabuhine ban nebei imae ruka ranne heubokene. ");
INSERT INTO set_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ro miyae nde yae raei a elalere borolere me ban u banna, nebei kiyae onei handai ro na imae ifau ranne heuboke wanen mae ahunebokale. ");
INSERT INTO set_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ya woke molowole, bumae meke, alu boye elaekei sele rawewole, nebei imae nekeunge buleufake, na beko hele yeuboke. ");
INSERT INTO set_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","“Yesus nebei a usaei yoni-yoni weumikoke baeufoke heera, nebei ro helen miyae helen borowate yo Na isaei hebaen ma kelewoumilere fa yae bowate. ");
INSERT INTO set_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Rabuhine ban Na mekai kelewoumilere hului kolowainye Allah one hengko bele kiteungeboke wanen keleumi, Musale walora wali heere foloukoke are isaeyaeikoke yo yae kelaeimi wanen ban.” ");
INSERT INTO set_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesus mokora owakouboke ro miyae helen sele mewate na moisa hakainyekoke. ");
INSERT INTO set_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ro mbai u bauwaunge kowole kiyae meke, Yesusle bene oro selen-selen roroukoke weunge, “Tuhan, weyae kena kokomae yae, rare na hului onomi yeremae.” ");
INSERT INTO set_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesus Na me nekeunge nebei rore me rameungehike mo weunge, “Reyae kena kale, weyae onomi rowei!” Na hibi hele na uwana bauwau nebei hukai yae faeinyeungekoke. ");
INSERT INTO set_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesus nebei rore weunge, “Boroyae, ro hi miyae hire eisuweijae. Oro moloubonde imamde hebele kiyaele bere ele, onomi yeuboke naei uwa yakaungebonde. Musale walora wali heere foloukoke a huluinye Allahre hili era akau erare ongkou wae felennekonde naeise obo yoku mbai yeungele. Nebei mekai yae isaeyeumibonde weyae na hele onomi roukae.” ");
INSERT INTO set_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nebeisa Yesus Kapernaum yore eke. Eweufike hee, Kaisar Romawi naei fela be neboi holona ro mbai Yesusle bokore meke. Nebei rore Yesus hakonnebondere riyewounge ");
INSERT INTO set_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","weunge, “Tuhan, raei yebaei bubaei oro me nimainyekoke buhae kaban koyelene, imaene ekehonole.” ");
INSERT INTO set_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesus yae weunge, “Reyae erele onomi erenjende!” ");
INSERT INTO set_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nebeibe felayona ro yae weunge, “Tuhan, Weyae raei imaere obere ele naeise reyae yeisi raeiboi ban sele. Ndara weyae are mo eleiko, raei yebaei bubaei na hului onomi rowende. ");
INSERT INTO set_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Rabuhine ban, reyae hiwa yo naei keleene nekale, nebei sului mbai raei keleene felayo hiwa nekate. Reyae ro hire wanale, ‘Eye,’ neyae eyewole. Ro hire wanale, ‘Mei,’ neyae eimewole. Nebei sului mbai raei yebaei bubaeise wanale, ‘Nda mokoibo,’ neyae mokoiboyele.” ");
INSERT INTO set_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesus nebei a wanen borokene fa yae bowole. Na moisa hakainyekoke mate yore weumi, “Reyae na helebe mare wamale, Israel kanina ro miyae nekate nolone nda hila rabo ma Reyae roko mbai ehubaikoi mo. ");
INSERT INTO set_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Reyae wamale, Yahudi ban ro miyae helen sele naufa waisa raei me kelee u keleene nekate ro miyae holonare hokommende. Surgare enate heene Abraham mae, Isak yae, Yakub yae nebei ro miyae hokommende bele anuwau mbainye enaitombonde raman mbainye anenaikonde. ");
INSERT INTO set_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nebeibe Yahudi ro miyae helen moinya ouben kika honolene hainyaikonde. Nebeinye rime bele a bele konate nane merau beko hubanainyelene heraa kili-kili enaikonde.” ");
INSERT INTO set_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nebeisa Yesus meubeke Roma naei felayona rore weunge, “Waei imaere beiso eye, hilare rabore haleyae huluinye yembonde.” Nebei hukai mbai na yebaei bubaei na hibi onomi rouke. ");
INSERT INTO set_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Petrusle imaere ekate hee, Petrus na miyae nenake era naume kaban sele kowole, na ijongku honson ranne ane neke honowole Yesus erekeunge. ");
INSERT INTO set_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesus nebei miyae mere mo rameungehike bae na hibi na uwana naume kowole u yeuboke, ewaunguke Yesusre ei hauwounge. ");
INSERT INTO set_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Be bahewole ro miyae helen sele alo yae hauwaimi yo Yesusle bokore yauwaimi mewate. Yesus are mo eleukoke nebei alo yoni-yoni ro naei miyae naei u bulura horayeke balayeke. Erana buloona kowate yo helen sele Yesus onomi iwoumi. ");
INSERT INTO set_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nda bewate walora Allahle yendo kayaalo Yesaya yae nuleungekoke a na hului yeuboke. Neyae nda a mekai moloukoke, “Neyae aei era buloo nemene fomene onomire ikeume kiyae.” ");
INSERT INTO set_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ro miyae helen sele hokoimeyelere Yesus erelene, na moisa orowate yore ukeumi rambun mokonainyehande bukoba reufire fonatere. ");
INSERT INTO set_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nebeinye uwoumi mo, Musale walora wali heere foloukoke kelewaimi holona ro mbai Yesusle bokore meke weunge, “Guru, makei ijende ele reyae hakorebonde orayendere.” ");
INSERT INTO set_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesus yae weunge, “Serigala yoni-yoni kate na ahe bulu bele, aye yoni-yoni bumana koyate na nale bele, nebeibe Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae nore isebonde imae ban mae nekale.” ");
INSERT INTO set_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yesus Na moisa orowate ro hi yae weunge, “Tuhan, na bere holo rare waeisihi maeko eremolonsan.” ");
INSERT INTO set_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nebeibe Yesus yae weunge, “Nda hee yae Rare hakoisobo. Raei a elalere hila rabo ehalei ro miyae herewate yo wanen. Nebei yo nenaeijae waemmihi heraiboke ro miyaere molonate.” ");
INSERT INTO set_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesus na moisa orowate yo bele nane kai mbaisa hawaiboke naisike fowate. ");
INSERT INTO set_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Na roko mbai sele alu elaekei raweuboke nebei kai ruwae yae felennehandere kowounge. Nebeibe Yesus nebei hee ijongkune honowole. ");
INSERT INTO set_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Na moisa orowate yo ekate yengkainyekoke aunguke, wainye, “Aei wali hole moloibo! Meyae bune anemabonde bele!” ");
INSERT INTO set_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesus yae weumi, “Rare mai hila rabo haleyaufe wauwaunge era mayae buhae hele hokombokembe!” Yesus aufae yae yeufureukoke, alu rawewole bele ruwae haiwole belere a elae yae haeungeboke. Nebei bukobana alu rauwole na hibi hele kalaungeboke. ");
INSERT INTO set_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nebei yo fa yae bowate na a bele elewate, “Alu bele ruwae bele a elae yae haeumibokene boroinyeboke Kiyae naeinya hesele nde maenin?” ");
INSERT INTO set_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Bukoba reufina, Gadara kanine ro bee hele alo yae aumiboke kowote, here bulei ruka einye nekeyeke. Hokolo bee na u mekai nansau fele koyekene, ro miyae fe faeiboke nane merau nebei nibira oroyei nekayeke. ");
INSERT INTO set_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Yesus naei fainyoke hee, hokolo bee naei nekewote anuwaufa meibaleke Yesusre hubainyekondere mewote, na kali bele kaenewoinye, “Allahle Kelu, Weyae ndare na ijen ban sele mekae! Allah bekore mokoumelere merau raungehike ya na hului eyeiboi tonbe.” ");
INSERT INTO set_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nebei anuwaufa ahau fele ban, obo helen sele ramanne anewate. ");
INSERT INTO set_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nane alo yoni-yoni yae Yesusre riwainye wainye, “Weyae maere hukeumihinde emabalenderena, obo riyana kate einye weime emayembon.” ");
INSERT INTO set_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesus yae weumi, “Eme!” Nane alo yoni-yoni hokolo bee naei u bulura maibaleke obo naei uwa einye ayeuboke. Nane obo yoni-yoni kowate alo yae nekaimi a yaeyaere habeleyoke, bune waibaleke, anayeke, herayeke. ");
INSERT INTO set_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Obo kayaare hebewate yo hakaikoke nobena honate yore ekate, nebei yeuboke rambun huwaimi. Alo yae hawaimiboke ro bee foi yeiboke naei a ekaisuwaimi. ");
INSERT INTO set_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nebei yona yanna ro miyae nebei a borowatene nemene hele Yesusre hubainyaikondere mewate. Nda yo Yesusre riyewainye nebei anuwau nukembonde anuwau hire yae endere uwainye. ");
INSERT INTO set_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesus naei Kapernaum yore enaterene kaisa hawaiboke bukoba reufire fowate. ");
INSERT INTO set_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kapernaum yone ekate yae, ro mbai orora nimainyekoke kiyaere na ijongku honson ranne ro hiwa yo yae kaeibokate Yesusle bokore mekate. Yesus nebei yo naei hila rabo erekeumine, orora nimainyekoke kiyaere weunge, “Kelu, rabo halei. Wa beko yoni-yoni ninae faeinyeubokawale.” ");
INSERT INTO set_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Musale walora wali heere foloukoke isaeyaeiboke kelaeimi holona yo hiwa nebeinye hebewate yo Yesus eleukoke a borowate. Na u benera haeyaeinye wa elate, “Buhae hokoiboi ban eleukoke. Ro miyae naei beko faeinyeiboise ro hi miyae hi yae na hului ban. Allah nenaeijaere na hului. Nda ro Allahre aukakabe kounge!” ");
INSERT INTO set_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nebei yo na u benera hayaeinye a Yesus isaeyeubokene weumi, “Mai kena u einye a na hele ban elaube! ");
INSERT INTO set_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Meyae elaube, ‘Na foma-foma hele Yesus nda rore weungele, wa beko ninae faeinyeubokawale, rabuhine ban yembonde naeise ro miyae ereiboinye. Nebeibe ehekaei kiyaebe Yesus wennele, ainyu, wa koi kaeibo eye, rabuhine ban ro miyae erenaterene.’ ");
INSERT INTO set_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mana Reyae kelerembombere Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae nane merau Allah one hengko bele kiteufeboke yae Reyae mere mokale. Reyae na hului beko bele neban bele yore faeinyeremile.” Nebeisa orora nimainyekoke kiyaere weunge, “Ainyu, wa ijongku honson kaeibo na hibi aloinyoko wa imaere eye!” ");
INSERT INTO set_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nebei ro aunguke, na hibi aloungekoke imaere ewole. ");
INSERT INTO set_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ro miyae helen sele nebei iwau rileuboke eraibokene fa yae bowate. Allahre ei molowainyele, rabuhine ban nebei one hengko Yesusre kiteungeboke. ");
INSERT INTO set_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesus nebei anuwaufa oro molouboke ewole yae, ro mbai na ro Matius pajakre arilate imaene nekewolebe erekeunge. Yesus yae weunge, “Rare hakoisobo!” Matius aunguke na hibi Yesusre hakoungeboke. ");
INSERT INTO set_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesus na moisa orowate yo bele Matiusle imaene ramanne anewate hee, pajakre arilate yo bele Yahudi yo yae bekore nebande mokayeke erewaimi yo bele mekate raman mbainye Yesus naei raiboke anewate. ");
INSERT INTO set_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farisi holona yo nebei mekai erekaimine, Yesus na moisa orowate yore waimi, “Rahene mai guru pajakre arileyate yo bele bekore nebande mokoyate yo bele raman mbainye raiboke anate?” ");
INSERT INTO set_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesus nebei a elewate borokeumine weumi, “Onomire foise nekate yo onomire mokoumi rore ebaeyei, erane buloone kate yo yaere baeyainye. ");
INSERT INTO set_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mana embe Allahle homofae yae elele a isaeyembombe, ‘Reyae mai hili era akau erare kena okoi, nebeibe Raei kena kale mayae hiwa yore yanekoi yase yae ei hawemmile.’ Rabuhine ban wali himalainyeboke yo yae nauware elate yore Reyae kaeneremile naeise mekale ban, bekone nebanne mokate yore kaeneremile nulu kenaimibonde naeise mewale.” ");
INSERT INTO set_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Yohanes bure kowoumi kiyaele moisa orowate yo Yesusle bokore mekate mo hinainye, “Rahene Farisi holona yo bele maengkele yarele me heiboyande nekandebe, nebeibe Waei moisa orate yo nendon nekate?” ");
INSERT INTO set_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesus isaeyeuboke na heki ban mo Nare honaibonde. Neyae kani kelane nekele naeise raman bulau wanen a yae ahuneuboke weumi, “Ro mbai miyae neme rowele raman bulau mokoiboyolere hokoimeyele yo nebei ro bele nanembainye nekate yae yarele me heiboyate? Nebei mekai ban. Raman bulau baensonde mo, nebei molo neme naei u nolo u kaisa ahaufe ende wa. Nebei hee na kahili wa na hului yarele me heiboyate nekate.” ");
INSERT INTO set_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","((Nda ahuba beene malo male bele anggur bu anuwau male bele na u mekai Musale walora wali heere foloukoke are hakainye ro miyae wanen Yesus yae a ahuneuboke. Malo neme bele anggur bu anuwau neme bele na u mekai Yesus Naei a elelere hila rabo halaeinye ro miyae wanen a ahuneuboke.)) Nebei ahuba nda mekai huwoumi, “Hangkande malo neme yae malo male ranne oboyei. Rabuhine ban nebei malo neme kingkongebonde malo malere yobongkonde benen kaban sele kayengkonde. ");
INSERT INTO set_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nebei sului mbai anggur bu neme anuwau malene erileyei. Rabuhine ban nebei anggur bu kaban bende, mokonnebonde nebei bure rilate anuwau ferengkonde, beko yembondene bu rilengkonde baensonde. Nebeinye hole moloiboise anggur bu neme anuwau anggur bu neme rilengkombe.” ");
INSERT INTO set_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nda yore Yesus ane uwoumi hee, Allahre ei mom-mom imae mbai naei yun meke, Yesusle bene oro selen-selen roroukoke mo weunge, “Raei maengke manemfa hele nare hereke. Nebeibe kena kokomae yae raei imaere memae, me na u ranne ranehimae neyae waleuboube.” ");
INSERT INTO set_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesus aunguke na moisa orowate yo bele nanembaisa nebei rore hakainyekoke ewate. ");
INSERT INTO set_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Oro molaiboke ewate mo, miyae mbai meke ralo yakama me bee oro hine bee bele (12) ha yae rileweke. Yesusle moisa meuyaneufoke Na malo buraibe me yae rameufike. ");
INSERT INTO set_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Na kena eisa elele, “Na malore mo katarensinde, na hului onomi roufele.” ");
INSERT INTO set_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesus meubeufoke nebei miyaere erewounge wa weunge, “Omi, rabo mo halei, waei hila yae rabo yae ware onomi ikete.” Yesus are ukeunge hee yae nebei miyae onomi na hibi rouke. ");
INSERT INTO set_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Allahre ei mom-mom imae naei yunbe imaene Yesus naei ayeuboke hee, erewoumi rime ei haungainyelere sulingde ranewate yo bele ro helen miyae helen bele mewarileufike aku nau fele howate. ");
INSERT INTO set_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yesus yae weumi, “Nda anuwaufa nemene embale. Nda maengke eherei, ijongkube honole.” Yesus nda a mekai eleukokene ro helen miyae helen borowate yo na re bele harewainye aukaka yae kowainye. ");
INSERT INTO set_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nebei ro miyae nemene moise aibaleke mo, Yesus eweufike na mera ikileungeboke bele nebei maengke aufae aunguke. ");
INSERT INTO set_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Allahre ei mom-mom imae naei yun na maengke waleungeboke a eungeyoboukoke. Nebei kanine nekewate ro miyae nemene borowate. ");
INSERT INTO set_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nebei anuwaufa Yesus aloungekoke ewole mo, ro bee ijoko kumba na moisa hakoinyekoke kali ara nene kaenewoinye weinye, “Weyae Ondofolo kaban Daudle orona mena Kiyae, maere yanekoi yase yae ei haweumele ya!” ");
INSERT INTO set_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Imaene Yesus eweufike hee, hokolo bee Yesusle bokore mekete mo hineumi, “Ma ijoko erebe naeise Reyae na hului mokorebobere mayae hila rabo haleube?” Hokolo bee yae weinye, “Yesus, meyae hila rabo halende.” ");
INSERT INTO set_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Hokolo bee na ijoko Yesus me rameumikoke mo weumi, “Mai hilare rabore haleube hului yae yembonde.” ");
INSERT INTO set_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Na hibi hele hokole bee na ijoko erewote. Yesus nebei beere a hun raumihike weumi, “Ro miyae hiwa yore nda yeuboke a eisuweijae hele.” ");
INSERT INTO set_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nebeibe hokolo bee nebei imaera eibaleke Yesus onomi ikeumi abe nebei yo ran yo ranne huweyeke eungeyobouboke borowate. ");
INSERT INTO set_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Hokolo bee eibaleke hee, ro mbai alo yae aungebokene a munde yeuboke nekeweke kiyae, Yesusle bokore yawainyehoke mekate. ");
INSERT INTO set_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesus nebei alore hukeungehike eukuke bae, nebei ro a elewole. Ro miyae helen fa yae bowate elate, “Nda me ma u ma, Israel ro miyae nolone eyeiboi mo.” ");
INSERT INTO set_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nebeibe Farisi holona yo yae elate, “Walobo yun mae elae ikeunge walora, alo yoni-yonire hukeumi baleyate.” ");
INSERT INTO set_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesus yo ran yo randa oroweke, Yahudi naei Allahre ei mom-mom imaene nda a foi faeu foi huweumiyeke, “Allah merau raungehike ro miyae Raei me kelee u keleene nekenatere wali hena bona Allah inyemmile.” Nane merau erana buloo u ranna u buluna kayeke yore Neyae onomi yeumiyeke. ");
INSERT INTO set_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nebei ro helen miyae helen Yesus erewoumine na beko hubawaimi aerene kena beko hele hubawounge, rabuhine ban male yambi yae koloukeumi. Nebei ro miyae domba yoni-yoni yaweiboi ro ban wanenne, na uware hole moloiboise na hingkin ban sele. ");
INSERT INTO set_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nebei yore Yesus ahuba hekena ani era wanen mae ahuneuboke Na moisa orowate yore weumi, “Ani era helen sele ninae henaiboke, nebeibe malunaibonde yo na hangka hele. ");
INSERT INTO set_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nebei aerene Allah na heke yunde a yae riyennehi, ‘Heke kaliare enaimokonde yo weumile enate. Nebei male yambi bele yore wali nibi foi naei kelenaimile.’ ” ");
INSERT INTO set_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ya mbai mo Yesus na moisa orowate yo me bee oro nen bee belere riyane arileumihike mo, walobore hukenaimile naei elae nane merau era buloo na mane-mane onomi inyaimile naei elae nda yore kiteumiboke. ");
INSERT INTO set_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nda ro me bee oro nen bee bele yo na ro niyae: Simon na ro hi Petrus yae eiwewainye, naka baeke Andreas, Zebedeusle kelu wa bee Yakobusle naka baeke Yohanesle, ");
INSERT INTO set_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipus, Bartolomeus, Tomas, Matius pajak arileweke kiyae, Yakobus Alfeusle fa, Tadeus, ");
INSERT INTO set_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon zelot holona ro, Yudas Iskariot Yesusre haiboke kelaise neke kiyae. ");
INSERT INTO set_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Na moisa orowate yo ro me bee oro nen bee belere Yesus ukeumi enaterene a weumi, “Yahudi ro miyae ban naei yo yan bele Samaria kanina yo yan honate bele nibire yae eweyeijae. ");
INSERT INTO set_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nebeibe Israel ro miyae yoni-yoni nekate domba wanen here ware waeiboke nundeyate howaleyate holonare yae embe. ");
INSERT INTO set_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nda abe huwemmile: Allah yae merau raungehike ya Naei holona ro miyae Wali Ondofolole me kelee u keleene menayorulembonde nekenate naei ya nobeungekoke. ");
INSERT INTO set_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Erana buloona kate ro miyae onomi yemmile, herenate yore walemmile, u bauwaunga kate yore onomi yemmile, alo u rannare hukemmile. Mai elae nanemene me karo yae yaraukokene, nebei sului mbai me karo yae emmiyembe. ");
INSERT INTO set_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Roi emasra, perakra, tembagara, ma yolu ha roi haufau hawate anuwau einye eyaroi eijae. ");
INSERT INTO set_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nibi embe naei era inyale holoboi, uwa naei malo beere, oro mehau karo bele, o mehukun, eyaroi eijae. Rabuhine ban kaliare mokonde kiyae na kalia mokowole hului roibu inyainyele lonbe. ");
INSERT INTO set_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Yo kaban yan kabanne nane merau yo melae honatene mayae embalembena, mare eise annembombe u mekai foi bele ro mbai baennekombe. Nebeinye nekembe mayae kulun wembe embe. ");
INSERT INTO set_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nebei ro naei imaere emembombena, nebei imaena yore ro melaeyemmibombe. ");
INSERT INTO set_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nebei imaena yo ei anayembombena, mai uware kitewamale hakawamalena onomi foi yemmile. Nebeibe mare ahi yae elenatena, nebei onomi foi mai uware yobombombe. ");
INSERT INTO set_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ro miyae mbai mare ei aiboise ahi yae elende nane merau mainya a faeu wemmilere oboroinya, nebei yo yanda, imae obera embalembe. Mai orona kani bahe bongkombe nebei anuwau embalembera rubommibombe. Neyae u mekai beko helebe mokaibokene nda iwau wanen mae kelemmibombe ");
INSERT INTO set_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Reyae wamale, nana hesele Allah yae ro miyae mere nommiyonde yane Sodom yo bele Gomora yo belena ro miyae naei ehee bukulu foma-foma inyaibonde, nebei yo yoni-yoni honatena ro miyae naei ehee bukulu ehekaei sele kaenaibonde. ");
INSERT INTO set_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Bene nekenayembe! Mayae domba wanen mae me baemale nekaube. Reyae mare ufembe han bele obo yoku serigala wanen ro miyae nolore embere. Nebeinye mai isaei hebaen bumane nekembe mai u mekai han ban aye yawo-yawo wanen mae. ");
INSERT INTO set_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Uwa kayaa bele yae hebembe. Rabuhine ban mare ikilenayembe Yahudi naei yun-jun hebate bene mai wali hului kolonainyekombere mare kinyenayembe, nebeisa Allahre ei mom-mom imaene erahuae olenayembe. ");
INSERT INTO set_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Rare hakaufeboke aerene mare yobonayembe gubernur yoni-yoni bere nane merau ondofolo kaban yoni-yoni bere embe. Raeinya a faeu nda yo bele Yahudi ban ro miyae belere nebei mom mae kelemmilerene yobonayembe embe. ");
INSERT INTO set_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nebei yo naei me einye kinyenayembombe hee mayae are wemmile naeise buhae ohokoijae. Mayae nebeinye elembe a nanemene Allah mare kelenembe. ");
INSERT INTO set_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Rabuhine ban nebei hee mai u benera elembe ban, Arai Allah Naei Rohle walora mayae elembe. ");
INSERT INTO set_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Nda u mekai enaibende hele, ro miyae naka baeke nake mbainyare wali huluise koloyaimi yo naei me einye kinyenaimile. Naeko yae na kelure, kelu omi naei ako nakere nebei sului mbai enaimikinyende. ");
INSERT INTO set_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Rare hakaufekoke aerene ro miyae nanemene mare ikele konayembe. Nebeibe ro miyae kena beko hubanainyele hororebe kena yae herawembonde Reyae a uwamale hului nekende kiyae Reyae hole molorembonde. ");
INSERT INTO set_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Yo hine weitasi konayembena, na kelaeunge yore yae hakangkombe embe. Reyae mare isaeyaemale, nana hesele Israel naei yo yoni-yoni honate mayae huba eimokoikoijae, Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae merele.” ");
INSERT INTO set_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Yesus Na moisa orowate yore kelewoumi weumi, “Isaeise isaeyele kiyae na isaei hebaen ana, nebei isaeise keleunge kiyae bumana. Nane merau yebaei bubaei ro ban sele, na rowa ro bele. ");
INSERT INTO set_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Isaeise isaeyele kiyae nebei isaeise keleunge kiyae naei wali nibi hului mbai orole, rilibo ehayei. Yebaei bubaei naei rowale wali nibi hului orole. Reyae imae yun wanen Kiyaere walobo yun Beelzebul ro raisebokene, mayae nebei sului mbai Raei imae mbai nekaube yo wanen nane merau ro na beko hele yae ronayembe. ");
INSERT INTO set_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Nda a isaeyaeubokene, weitasire kayembe ro miyaere fe efaeijae. Felaimi rambun nemene wewe enaimimolombonde, nunna honate rambun nemene emmiyakambonde. ");
INSERT INTO set_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mare huae yae uwamale a nebei a mbai na rai yaka yae wemmile. Mare angkaei kelaeufa a maehae-maehae yae uwamale a ro miyae nemene na yaka yae isaeinyaibondere imae malira wemmile. ");
INSERT INTO set_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nda uwa na hului honayengkombe yore fe efaeijae. Neyae narakare ungayembe embe naeise na hului ban. Nebeibe Allahre fe faenne. Neyae na hului narakare ungembe embe, ndine beko hele ennehubambe. ");
INSERT INTO set_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Aye kilin-kilin (aye kerendeng) naise roi ane hele. Na hului nebei aye beere heiboyate perak mbai rowate horobe, nebeibe mai Arai Allah kena okoikoinya mbai sambai nendon ewaeisi kani ranne eruwei sele. ");
INSERT INTO set_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nane merau ma yunna umaa hebate nanemene Allah me baeukoke. ");
INSERT INTO set_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nebei aerene weitasi konayembe yore mayae fe efaeyeijae, Allahle bene nda aye yoni-yoni katera mayae aweukoke hele. ");
INSERT INTO set_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Nde yae ro miyae ro be ro yoinye Rare Wali Ondofolo yae elendena, Reyae naei mekai mbai Maeko surgane nekele Kiyaele ro be ro yoinye nebei rore Raei me kelee u keleene nekate holona ro yae erelengkonde. ");
INSERT INTO set_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nebeibe nde yae ro miyae ro be ro yoinye Rare Wali Ondofolo ban mae elendena, Reyae naei mekai mbai Maeko surgane nekele Kiyaele ro be ro yoinye nebei rore Raei me kelee u keleene nekate holona yo ban mae erelengkonde. ");
INSERT INTO set_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Mai u benera nekayembe elaube Reyae rei mai nda kani kela rande roukale mekale. Reyae rei maibe erowei mei, nana hesele buloo felabe roukale mekale. ");
INSERT INTO set_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Reyae mekale aerene Allahle homofaene moloukoke nda a hului yembonde, ‘Kelu naeko bele, maengke nenake bele, na fau miyae nenake bele han onyeibonde releneinyele. ");
INSERT INTO set_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nane merau na yokeijo hele bae ro miyae naei imae mbainya yo bele yembonde.’ ");
INSERT INTO set_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ro miyae nde yae naeko bele nenake belere nane merau na kelu bele na maengke belere kena buhae hemmile ma Rare emekai bele henselena, Raei moisa hakombonde holonara yeisi raeiboi ban sele. ");
INSERT INTO set_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Raei aerene ohaline bonaikonde ro Rare hakoufele wanen ehakoiboi kiyae Raei ro miyaere yeisi raeiboi ban sele. ");
INSERT INTO set_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nde yae naei wali Raei me einye ekinyeiboinya, naei wali holere omoloiboi. Nebeibe nde yae naei wali Raei me einye kinyensebondena, nebei ro na wali hole molorebonde. ");
INSERT INTO set_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Rare hakaufekoke aerene ro miyae ei haungayembena, Rare ei hawaise. Nane merau Rare eise hawensele ro miyae nebei kiyae Allah Rare ukeufe mekale Kiyaere ei haweunge. ");
INSERT INTO set_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nde yae yenjo kayaayo yae ro rainyebokene ei hawennelena, na roibu yenjo kayaayo hului yaronate. Nane merau nde yae wali himaloungeboke yo yae ro rainyebokene ei hawennelena, na roibu nebei sului rowende. ");
INSERT INTO set_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Raei moisa oronde aerene hun ban wai ban yeuboke kiyaere bu nuku kolaei mbai ken sele yennele anensindena, nana hesele na roibu einyundeiboi.” ");
INSERT INTO set_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesus na moisa orowate yo me bee oro nen bee bele a weumikoke baeufokera, nebei anuwaufa aloungekoke Galilea kanina yo yoni-yoni honatere kelemmiyenderene ewole. ");
INSERT INTO set_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yesus Wali Ondofolo na kalia ma mokowolebe a eungeyoboukoke Yohanes bure kowoumi kiyae kawa eisa boroke. Nebeinye Yohanes na moisa orowate yore ukeumi ");
INSERT INTO set_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Yesusre are enainyehinensindere, “Mendere nulainyekoke Wali Ondofolo Weyae niyae, benen meyae ro hire rakemandere?” ");
INSERT INTO set_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Are ukeumi yore Yesus weumi, “Embe mo, mayae ijokore eraukoke, angkaeise boraukoke hului yae Yohanesre huwennekombe. ");
INSERT INTO set_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ro miyae ijoko kumba nekayeke mana ijoko erate, oro rebeisi-rebeisi rebaeyeke yo mana ele mele kate, u bauwaufe kayeke yo onomi yarowate, ro miyae angkaei kokun nekayeke yo mana angkaei borate, herewate yo walaeiboke, a foi faeu foi hun ban wai ban yore ekehuweumi. ");
INSERT INTO set_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ro miyae Rare hakoyaise aerene ehekaei hubayainyebe Rare moi ebulei yo onomi foka hubanainyende.” ");
INSERT INTO set_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yohanes yae ukeumi mekate yo ewate mo, Yesus huba raweuboke ro miyae helen hebatere Yohanesle ane weumi, “Rahere erembomberene mayae a kala-kalare eyewaube, nebeinya kena u wauwaufe koyate holona ro mbai naei u mekai o mbai alu yae ndire ndare kuseunge wanende erembombere? ");
INSERT INTO set_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Rahere erembombere eyewaube, ro mbai malo maye-maye hireukokere erennebombere? Niyae ban! Ro miyae malo maye-mayere hirate yo bae naei anuwau ondofolo yoni-yoni naei imaena. ");
INSERT INTO set_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nebeise banna, rahere mayae eyewaube? Yenjo kayaayo mbaise erennebombere? Na hele. Reyae mare wamale, neyae Allahle yenjo kayaayo holore moi wokeumi. ");
INSERT INTO set_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Nane merau naei naeise Allahle homofaene homo molaikoke. Neyae Raei burelen boi-boi rore yeuboke naeise Allah yae Rare ukeufe are Maleakhi moloukoke, ‘Nda niyae Raei burelen boi-boi ro. Neyae Weyae mele nibi a mokoisaise nare bere holo yae ufende ende.’ ");
INSERT INTO set_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Reyae nda a na helebe mare wamale, Miyae naei kou ei yahi eisa honowate yoni-yoni nolora Yohanes bure kowoumi kiyae na bumane hele. Nebeibe ro ban sele ro miyae Raei me kelee u keleene nekate holo yo Yohanesre moi wokainye. ");
INSERT INTO set_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yohanes bure koumi kiyae yeuyakauboke a kelewoumi heera meke nda heene Yahudi yun-jun kena okoi hororebe Allahle holona ro miyae Raei me kele u keleene menayorulembonde are huweimeyate, nane merau nebei yun-jun huwaimi a asasi konate hororebe ro miyae nenaeijae uwa mayoruleuboke. ");
INSERT INTO set_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Rabuhine ban Allahle yenjo kayaayo nemene naei a bele Musa yae wali heere foloukokene a bele Wali Ondofolole naeise nulewainye meke Yohanes meuyakauboke heene. ");
INSERT INTO set_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nebei aerene, naei a borom, ‘Allahle yendo kayaalo Elia benen mende.’ Nebei a huluinye Eliale u mekai wanen ma Yohanes meke. ");
INSERT INTO set_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Raei a elalere u bene nekenayembe! ");
INSERT INTO set_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Rahe rambun mae nda holona ro miyaere ahundebonde elerekonde? Nebei yo fa-fa rambun nai hei-sei anuwaunge roiboyate naei hokolo uneyaufe kaenaimi wanen waimi, ");
INSERT INTO set_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Mai naeise meyae suling ranandebokebe, nebeibe mayae bae okoi mo. Meyae here rime wanenjekebe, nebeibe mayae rime erimei mo.’ ");
INSERT INTO set_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Rabuhine ban Yohanes bure koumi kiyae meke bae raman bele bu bele nendon ban aneinye, nebeinye ro miyae yae elate, ‘Nda ro alo yae aungeboke.’ ");
INSERT INTO set_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nebeisa Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae raman bele bu bele nendon mae analene, ro miyae elate, ‘Ndi ro erenne, raman mali bu mali ro, pajakre u bulu-bulu buleyate yo bele ro miyae beko nebande mokoyate holona yo bele kahili awaikoke.’ “Allahle isaei hebaen bele ro miyae me foi u foi mokoyatene, erenate ro miyae yae naei foi naeise elenate.” ");
INSERT INTO set_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Na bere Yesus rambun emere-emere helende mokowole yo yoni-yonina nekate ro miyae nulu ekeiboi mo katene, Yesus huba raweuboke a elae hele naei naeise uwoumi, ");
INSERT INTO set_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Mayae Khorazim yona ro miyae bele Betsaida yona ro miyae bele beko bele hubanembe. Rabuhine ban rambun emere-emere mai yo yan nolone mokowale bewate ma na bere hele Tirus yone bele Sidon yone belene mokole yae, nendahina nda yo rime a kaikoube nane merau nulu kaimiboube. ");
INSERT INTO set_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nebeinye Reyae mare wamale, Allah ro miyaere me nommiyonde yane Tirus bele Sidon bele naei ehee bukulu fomammibonde, mayae ehee bukulu kaban sele kaembombe. ");
INSERT INTO set_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nane merau mayae Kapernaum yo ei bele molonayembe buma bele kolonayembere kaube! Nebei mekai ebei sele! Mayae nulu yo mahe yore omembombe. Rabuhine ban mai nolone rambun emere-emere mokowale ma na bere hele Sodom yone yaeikoube yae, nebei yo yoni-yoni nda ya bele na hebaen foi nekaimeube. ");
INSERT INTO set_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nebeibe Reyae mare wamale, Allah ro miyaere me nommiyonde yane Sodom yo naei ehee bukulu fomannebonde mare ehee bukulu kaban sele inyembe.” ");
INSERT INTO set_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","A weumikoke baeufoke heera Yesus nda mekai yae Naekore weunge, “Arai, bumana anare ikileubokae Ako, Ware mbaibe buma kaewale. Helen foi wawale, rabuhine ban Waei ako faeuko no nanemene isaei bele hebaen bele ro miyae naeisa nunne raufikae, nebeibe fa-fa wanen ro miyae isaei ban hebaen ban yore keleumibokae. ");
INSERT INTO set_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ako nebei mekai Wa kenare foi yae hubanae.” ");
INSERT INTO set_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yesus a weumi, “Raei Ako Allah nemene fomene Raei me einye kinyewoufe. Ro miyae hi yae ha yae Rare oroiboi Ako Allah nembai mo roufeboke. Nane merau hi yae ha yae Raei Ako Allahre oroiboi. Reyae na kelu nane merau Reyae elerebonde Akore yakaremibonde ro miyae bele mo Ako Allah royanne. ");
INSERT INTO set_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Mayae Musale walora wali heere foloukoke huluinye hakombombere relaunge aerene uwa yambi koloukembe ro miyae nanemene Raei bokore men. Reyae mare wali no yeiboi wali nibi isembe. ");
INSERT INTO set_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Reyae wamale a hakombo, nane merau Raeisa meme isaeyengko. Rabuhine ban Reyae nime haba nane merau kena u ane nekeyale. Mai beko bakore faeinyerembombera kena foi u foi isembe. ");
INSERT INTO set_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Raei a wamale hakombombere nime haba, mai baka ranna ransikamale na foma-foma hele.” ");
INSERT INTO set_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sabat ya mbai Yesus na moisa orowate yo bele gandum heke nolora ewate. Moni kowatene gandum ani hokayeke anayeke. ");
INSERT INTO set_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farisi holona yo erekaimilene Yesusre wainye, “Ereimi, Yahudi naei era hena huluinye Sabat ya omokoijae eleukoke rambunbe wa moisa orate yo mokate.” ");
INSERT INTO set_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Nebeibe Yesus yae weumi, “Naendae wanen, aei yobe Ondofolo kaban Daud na moisa hakainyekoke orayeke yo bele monine kowatene mokouboke u mekai mayae homone okoikoi? ");
INSERT INTO set_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Allahre ei mom-mom imae eise eweufike imam yoni-yoni yae mo anenaikonde feube yaroukoke na moisa hakainyekoke ro miyae bele ikeumi anaikoke. Musale walora wali heere foloukoke a huluinye nebei feu ro miyae hosoro anei sului. ");
INSERT INTO set_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nane merau Musale walora wali heere foloukoke homone moloukoke mayae okoikoi. Nebei homone molaikoke Sabat yare kalia omokoijaebe, nebeibe imam yoni-yoni Allahre ei mom-mom imae na kaban sele kiyaene kalia imokowate. Nebei naeise Allah yae bekore eleikoi. ");
INSERT INTO set_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Reyae mare wamale, Reyae mai nolone hebale Kiyae Allahre ei mom-mom imae na kaban sele kiyaere hameungekokale. ");
INSERT INTO set_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Allahle yendo kayaalo Hosea yae nda Allah ukeunge a moloukoke, ‘Yanekoi yase bele wali mekaise Raei kena kale, Rare hili era akau erare ongkou wae felennekonde Reyae kena ban.’ Nebei a faeu naei no isaeyaeubokena, mayae Raei moisa orande yo beko omokoi holore me onoyoi sului. ");
INSERT INTO set_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Rabuhine ban Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae Sabat ya na yunde yeubokale Reyae niyae.” ");
INSERT INTO set_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nebei anuwaufa alainyekoke ewate, aibaleke yona Allahre ei mom-mom imae mbainye Yesus eweufike. ");
INSERT INTO set_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nebeinye ro mbai na me reufi nimainyekoke nangkele eweufike. Nda yo Yesusre kemere nenainyebonderene a melaeli wanen mae nainyeboke wainye, “Sabat ya yae ro miyaere na hului onomi inyaimile?” ");
INSERT INTO set_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesus yae weumi, “Mayae ro miyae nemene mai domba naendae mekai horo a bulune Sabat ya yae ruweubere bae mayae kaeuboube. ");
INSERT INTO set_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ro miyae bae Allahle ro be ro yoinye berei sele nda domba yoni-yonira. Nebeinye Reyae wamale, Ro miyaere Sabat ya na hului hakomambonde?” ");
INSERT INTO set_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yesus euweke nda rore weunge, “Wa me neinye!” Nebei ro na me nekeunge na hibi na me reufina me wanen onomi yeuboke. ");
INSERT INTO set_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nebei aerene Farisi holona yo Allahre ei mom-mom imaera aibaleke Yesusre honaibonde naei a meraunge kolowainyele. ");
INSERT INTO set_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nda yo na merau kolowainyele Yesus isaeyeubokene nebei ei mom-mom imaera eukuke anuwau hire ewole. Ro miyae helen Yesus ewolene hakainyekoke ewate era yo buloo yo nanemene onomi iwoumi. ");
INSERT INTO set_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","17","Allahle yendo kayaalo Yesaya yae Yesusle naeise nuleungekoke a na hului yembonde naeise, nda ro miyaere a hun kolowoumi Naei uwa naeise hiwa yore ehuweijae. ");
INSERT INTO set_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Nda Wali Ondofolo naeise Allah ukeunge are Yesaya yae moloukoke, “Erenne, Raei yebaei bubaei eleubokale ukanale endere Reyae buhaere haenaele Kiyae nane merau Raei kenare foise mokoyeufe Kiyae. Raei Roh Nare arembonde. Neyae Yahudi ban ro miyaere wali ijen are huwemmile. ");
INSERT INTO set_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Neyae nibi enene a kaban mae ekaengkoi, ro kabande ebaei. ");
INSERT INTO set_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Hila rabo holei-holei an ro miyae wali o ha ba bele wanen nane merau ye rondon wanen. Nebei yo Neyae mokommile naei hila rabo elae halenate. Nebei me u Neyae mokonde mende ro miyae nemene Allah Naei me kelee u keleene enayorulengkonde nekenayende. ");
INSERT INTO set_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nare mbaibe nda kani kelana Yahudi ban ro miyae wali hena bonare rabo enainyehalende.” ");
INSERT INTO set_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nebeisa ro mbai alo yae ainyebokene na ijoko kumba yeuboke nane merau a mun yeuboke Yesusle bokore yawainyehoke mekate. Yesus onomi ikeungera a elewole ijoko erewole. ");
INSERT INTO set_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nebeinya ro miyae nanemene fa yae bowate elate, “Ondofolo kaban Daudle orona mena are nulainyekoke Ro nda niyae era!” ");
INSERT INTO set_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Farisi holona borokate bae nda ro miyaere waimi, “Beelzebul, walobo yun mae elae ikeungebe, walobore hukeumi.” ");
INSERT INTO set_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Farisi holona yo naei u benena a Yesus naeisaeinye weumi, “Yo yan mbai na ro miyae be hun ma hun nekenatena, nebei yo yan here ware wembonde. Nane merau yo mbai na ro miyae naeise naeise kena ikele nekenatena, nebei yona ro miyae here ware wembonde. ");
INSERT INTO set_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nebei sului mbai walobo yun na walobo akobaere hukennehindena, nauware uware fela roronete. Nebei mekai yae na yo yan kerensonde. ");
INSERT INTO set_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Beelzebulle elae yae Reyae nda walobore hukeungehikale elaubena, ndele elae yae mai moisa orate yo walobore hukaimi? Nebeinye mai moisa orate yo yae mai beko mokaubere me nonayemombe. ");
INSERT INTO set_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nebeinye nda walobo yoni-yoni Allahle Roh elae yae hukamaelena, nana hesele Allah Rare eleufeboke nda kani kelana ro miyae me mokoremile. ");
INSERT INTO set_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Elae bele ro naei imaene nekelena, naei rambun yaroikoise ro miyae na hului ban sele. Nebei imaena ro na bere ha yae ikilenainyekonde helere nebeisa naei rambun yaronaikonde. ");
INSERT INTO set_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Nde yae Raei a elalere ehakoyei kiyae, nebei kiyae Rangkele yokeijobe nekende. Nde yae Raei me kelee u keleene nekate holona ro miyae inyaibondere moi eneisi, nebei kiyae ro miyaere here warebe boumi. ");
INSERT INTO set_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Nebei aerene Reyae mare wamale, nde yae me hila u hilae Rare konsele, a beko faeu beko Rare wensele kiyae Allah naei beko bako faeinyennebonde. Nebeibe nde yae Allahle Roh Naei me u mokole walobolena elae walora mokale yae elengkondena, Allah nare buhae eheikoi sului. ");
INSERT INTO set_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyaere ro miyae mbai a beko wenselena, Allah naei beko bakore faeinyennebonde. Nebeibe nde yae Allahle Rohre a beko wennele kiyae Allah naei beko bako efaeinyeiboi mo nekenende nda kani kela huba mennemokonde yane. ");
INSERT INTO set_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Raei u mekai kombo mahu ani mokoyate wanen mae ahunerebonde. Mayae Raei u mekai ma elengko! Raei me u Allahle walora mokalene u mekai foi ma nekale, nebei banna, Raei me u walobo yun elae walora mokalene u mekai beko ma nekale. Rabuhine ban anira nebei o no roiboyainye wanen mae ro miyae naei me u mokate yae na hului ronainyebonde. ");
INSERT INTO set_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mayae rami holona wanen ro miyae yaeuboke. Mai u mekai beko nolone nekeimeyaubene, mayae a foi faeu foise eleikoi sului! Rabuhine ban mai kena beko u beko eisa are faeufe elaube. ");
INSERT INTO set_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","U mekai foi bele ro miyae foi yae maemae koikoyeunge na kena einye honainyene, foi naei rambunde mo eyelewole. Nebei sului mbai beko yae maemae koikoyeunge na kena einye honainyele kiyae beko naei rambunde mo eyelewole. ");
INSERT INTO set_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nebeinye bene nekenayembe, Allah yae ro miyae naei walire hului enengkolombe yane, mayae nanemene mai a faeu mekai ban elewaube wo engkongkombe. ");
INSERT INTO set_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Rabuhine ban menaeijae elaube a faeu huluinye Allah yae foi yo kaenenembe, beko yo naei ehee bukulu inyembe.” ");
INSERT INTO set_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nebei hee yae Musale walora wali heere foloukoke isaeyaeiboke kelewaimi holona yo bele Farisi holona yo bele Yesusre wainye, “Guru, meyae kena hele kande Weyae rambun emere-emere mokoubonde eremabondere.” ");
INSERT INTO set_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nebeibe Yesus yae weumi, “Mayae u hila wa hilaere kaube ro miyae, rambun hoime bahe Allah merau wae ei molaungele lonbe, iwau emere mokorebondere riyaufe. Mare iwau eme Reyae omokoi, Allahle yendo kayaalo Yunusle iwau mbaibe kelerembombe. ");
INSERT INTO set_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yunus reniai ya name ka kaban yarele einye nekeukoke naei wanen mbai, Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae reniai ya name kani einye erenekengkonde. ");
INSERT INTO set_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Allah ro miyae naei walire hului emmikolonde yane, Niniwe yone nendahina hele nekewate ro miyae bele nda kulunne yo bele nanembaisa anainyunde. Niniwena yo nda kulunna yore me nonaimiyonde. Rabuhine ban Niniwe ro miyae na mene ban une ban Yunus Allahlena a yae huwoumine hee rorowate nulu keumiboke. Mana Reyae mekale, Yunus yae ehameikoi Kiyae wamalebe, nebeibe mayae nulu ekeiboi sele. ");
INSERT INTO set_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Allah ro miyae naei walire hului emmikolonde yane miyae Ondofolo Hilo Norona nda holona yo bele mbainye anainyunde, na beko mokowatera me nommiyonde. Rabuhine ban nda miyae Ondofolo kani kela hubara Ondofolo Salomole isaei hebaende borombonderene mewole. Mana Reyae nda nekale Salomo yae ehameikoi Kiyae, nebeibe Raei isaei hebaende oboroiboi sele kaube. ");
INSERT INTO set_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Nda kulunna ro miyae walobo nansau wae beko yae ei aungeboke wanen. Nebei walobo nansau ro miyae naei uwara etuwele hee, nore yembonde naei a kala-kala anuwaunge baeyele anne. ");
INSERT INTO set_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Nebei walobo elele, ‘Reyae nukeubokale role uwa eise berehonde erelere.’ Eke bae nebei ro naei wali erele bangka, niki ban, nambai mokoungehake. ");
INSERT INTO set_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nebeinye nda walobo eukuke eke walobo na beko hele kayeero mehine bee yaweumiboke ayeuboke nekewate. Nda ro naei wali beko hele bena nekewolera. Nebei sului mbai nda u hila wa hilae ma kulunna ro miyae mai wali beko hele yembombe. Rabuhine ban Reyae mai nolone nekale heene, walobo yoni-yoni aibaleke. Nebeibe mayae Raei a elale hila rabo ehaleinye, Reyae erele heene walobo yoni-yoni helen bukenaibonde menate.” ");
INSERT INTO set_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ro miyae helende Yesus ane weumi hee yae, nenake nauwake wa bele mekate. Yesus naei are elenaikonderene moinye hebewate. ");
INSERT INTO set_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ro miyae helen nolona ro mbai yae Yesusre eke weunge, “Ereibo ba, ana wauwake wa bele moinya mekaisebate Wangkele hubayengkombere.” ");
INSERT INTO set_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nebeibe are ukeunge rore Yesus yae weunge, “Nde menake wanen? Nde raei aka baeke wanen?” ");
INSERT INTO set_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Na moisa orowate yore me yae keleumi wa elele, “Nda niyae menake naei rauwake wa naei. ");
INSERT INTO set_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Rabuhine ban nde yae Maeko surgana naei kena kole huluinye hakonde mokonde, nebei kiyae Raei aka baeke wa yae menake naei yae elerekonde.” ");
INSERT INTO set_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nebei yana ayeuboke imaera Yesus eukuke eke Galilea bukoba buhaei yaufaeinye nuweuboke nekewole. ");
INSERT INTO set_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ro miyae helen sele hokoumeke, Yesusre ele yae nainyebokene, Yesus kai einye eunguweuboke nebei ro miyae hokoumeke nanemene buhaei yaufaeisa hebaiboke. ");
INSERT INTO set_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nda yore Yesus a mekai mahi-mahi ahunewole kelewoumi huwoumi, “Ro mbai na hekere o haka heraeyeikoise eukuke. ");
INSERT INTO set_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Heraeiwole hee nebei o haka hiwa nibi enene balewate, aye mekate anaikoke baeufoke. ");
INSERT INTO set_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Hiwa ruka bele kanine balewate. Nebei kani hele-hele ranne nda o haka na hibi hele kitewate. ");
INSERT INTO set_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nebeibe hu naeukoke inyukui naumene, kambu eleman ororoiboi oinye habawate kala-kala bewate. ");
INSERT INTO set_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Hiwa hun isa bele nolone balewate. Hun kaban bewole nda o haka kitewatere aiwaimine herewate. ");
INSERT INTO set_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Hiwa kani foinye balewate, na hibi kitewate, ani mokowate, faru wang-wang hiwa rorele u maehae mbai (100), rorele u name (60), rorele u mbai me bee bele (30) bewate. ");
INSERT INTO set_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Raei a elalere u bene foi nekenayembe.” ");
INSERT INTO set_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Na moisa orate yo mekate mo Yesusre hinainye, “Rahene nda yore rambun hine-hine ahuneubokae huwamae?” ");
INSERT INTO set_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesus yae weumi, “Raei me kelee u keleene nekate ro miyae holo naeise na nunna honate rambun isaeyembombe naeise mare mo ikembe, ndi yore eyei. ");
INSERT INTO set_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Rabuhine ban Allah na mekai ma haraungebokere baenate ro miyae kelemmile, helen isaeinyate, nebeibe ebaei yo boraikoke a u benera hanenaimikonde. ");
INSERT INTO set_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nebeinye a ahumbo-ahumbo yae nda yore huwamaele, rabuhine ban ‘Neyae ijoko yae erenayendebe nane merau angkaei yae boronayendebe, nebeibe u benene orowei.’ ");
INSERT INTO set_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Naei naeise Allahle yendo kayaalo Yesaya yae nuleungekoke a na hului yeuboke. Nda mekai yae moloukoke, ‘Mayae roko yae roko yae emborombe hororebe, isaeyeiboi sele. Nane merau roko yae roko yae emerembe hororebe, ereiboi sele ");
INSERT INTO set_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Rabuhine ban, nda ro miyae na kena ruka-ruka yaeiboke, angkaei kokun yaeiboke, ijoko nambai kunaikoke. Neyae kena okoi ijoko yae enayerembonde, naei angkaei yae enaiborombonde, naei kenara enaisaeyembonde, wali enainyeharambonde nebeisa Rare waenaisehinde naei u mekaise onomi isemilere.’ ” ");
INSERT INTO set_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Nebeibe mayae Raei moisa oraube yo na foi moi sele Raei me u mokalere mai ijoko yae eraube, Raei a elalere mai angkaei yae boraube. ");
INSERT INTO set_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Reyae mare wamale, nana hesele nendahina hele Allahle yenjo kayaayo nane merau ro miyae wali himalainyeboke yo yae kena hele kayeke nda hena eraubere erenaibondere, boraubere boronaibondere, nebeibe nda yo ereiboi oboroiboi sele.” ");
INSERT INTO set_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Nebeinye heke rone a ahuneubokamale na mekai ma borombo. ");
INSERT INTO set_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nibi enene balewate o haka na mekai ro miyae nde Raei me kelee u keleene nekate ro holone eise ate naei a faeu borombonde, nebeibe mbai sambai isaeyeiboi sele. Walobo yun meke bae na kenane heraeyaibokebe nukeufake. ");
INSERT INTO set_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","O haka heraeyeweke ruka bele kanine balayeke yo, na mekai ro miyae nebei a faeu borolera na rei mai yae hele ei aiboyeunge. ");
INSERT INTO set_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Nebeibe neyae kambu kanire ehireiboi einye hekire ehebeikoi. Nebei a faeu boroke aerene wali beko hubanainyele belene weitasi nare kainye belene nebei wali nibira u hale yae ungaiyende. ");
INSERT INTO set_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","O haka heraeiwole hun isa bele nolone balewate yo nebei niyae ro miyae nebei a faeufe boraiboke yo. Nebeibe nda yo naei wali holere molommibonde aerene buhae hokoiboyoumi nane merau yeisi raeiboi walire kena haehae koyatene, nebei a faeufe ayeikoyainyene anire omokoi. ");
INSERT INTO set_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","O haka heraeiwole kani foi kela foinye balewate yo, nebei ro miyae niyae nda a faeufe borowate nane merau isaeyaeiboke, nebeinye ani mokowate faru wang-wang hiwa rorele u maehae mbai (100) rorele u name (60), rorele u mbai me bee bele (30) bewate.” ");
INSERT INTO set_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesus a hi kiyaebe benen nda yore ahuneuboke huwoumi, “Raei me kelee u keleene nekate ro miyae holo naeise na mekai ma heke ro mbai na hekene o haka foi heraeyekoke yae ahundebondere. ");
INSERT INTO set_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nebeibe ro miyae ijongkune honowate hee yae, na yokeijo ro meke gandum nolone hun haka heraeyeukokera ewole. ");
INSERT INTO set_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Gandum kitekate anire hurenaimile hee yae nebei hun yaeijakauboke. ");
INSERT INTO set_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Nebeinye na kalia yo yae na heke rowale bokore mekate mo wainye, ‘Rowa, o haka foibe wa hekene heraeyeubokaebe, nebeibe makeisabe ndi hun kitekate?’ ” ");
INSERT INTO set_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Nane heke rowa yae weumi, ‘Ra yokeijo ro yae hele nda mekai mokouboke.’ “Kalia yo yae wainye, ‘Rowa kena kokomae yae meyae ande ndi hun rawandekoube?’ ” ");
INSERT INTO set_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Nebeibe nebei heke rowa yae weumi, ‘Nebei mekai omokoijae, nendon mayae hunde rawembe hee gandumbe rawembombe bele. ");
INSERT INTO set_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Waemmihi nebei hun bele nanembainye kitai ani hokoi-sokoi ya mende nebei hee yae hokonate yore ufemile, Na bere hun korombombe bomone-bomone rinengkombe i ranne hekelengkombere, nebeisa gandum mo arilensimbe honson anuwaunge engkolongkombe.’ ” ");
INSERT INTO set_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Nebei yore Yesus benen weumi, “Raei me kelee u keleene nekate ro miyae holo naeise o kaban naei ko heke ro rouke na hekene eke moloufake yae a ahunerebondere. Nebei o kaban na ro Yunani afaeunge mustard yae elewate. ");
INSERT INTO set_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nda o haka ko sawi ko wanen mbaibe na kaei-kaei sele. Nebeibe kitele bae nda o reu ha reu hiwa hebatera neyae na kaban sele yeiboyele, maensa akau rorole ate, aye bumana mate nebeinye no yeiboise meisebate.” ");
INSERT INTO set_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Benen Yesus weumi, “Raei me kelee u keleene nekate ro miyae holo naeise nda mekai a ahunerebondere. Miyae mbai ragi ebi mo roke terigu kaban mokoungehakene alewoungele nanemene ohuleuboke.” ");
INSERT INTO set_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","A usaei wasaei nemene Yesus a ahumbo-ahumbo yae mo nda ro miyae helende uwoumi. ");
INSERT INTO set_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nebei ahuba ahunewolera Allahle yenjo kayaayo yae Yesus naei uware nulainyekoke a faeu na hului yaeiboke. Yesusle naeise nda mekai ma moloukoke, “Reyae nda yore a ahumboi yae ahunerebonde ufemilere. Nda kani kela mokouboke heera nunne honayeke rambunde hufekondere.” ");
INSERT INTO set_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nebei ro miyae helende nanene Yesus nukeumiboke. Imae mbainye ayeuboke hee, na moisa orowate yo mekate Yesusre wainye, “Hun gandum heke nolone kitewate ahuba ahuneuboke huwekokae a maere yakaimebone.” ");
INSERT INTO set_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesus yae weumi, “O haka foise heraeyeukoke ro Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae Niyae. ");
INSERT INTO set_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Na heke nda kani kela niyae. O haka foi nebei Raei me kelee u keleene nekate holona yo. Hun hobo nebei walobo yun naei me kelee u keleene nekate holona yo. ");
INSERT INTO set_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Yokeijo hun hobore heraeiwole kiyae nebei walobo yun niyae. Anire hokonate ya nebei huba mokoikoi ya, anire hokonate yo nebei malaikat yoni-yoni niyae. ");
INSERT INTO set_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Hun hobo arilaisike i ranne hayaikoke wanen, nebei mekai mbai huba mokoikoi ya enjembonde. ");
INSERT INTO set_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae malaikat yoni-yonire ufemile Raei me kelee u keleene nekate holona ro miyae nolora ro miyaere mokaimiyeke bekore mokonate yo nane merau me hila u hilare kayeke yo nanemene hele arilenaimihinde. ");
INSERT INTO set_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Nebei yo i kaban beyele ranne nanemene hekelenaikonde, rime a heraa kili-kili anuwaunge enaikonde. ");
INSERT INTO set_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nebei hee yae wali himalainyeboke ro miyae Ako Allahle yo yanne hu inyukui wanen enainyaengkonde. Mayae angkaei bele mone borombo.” ");
INSERT INTO set_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesus nebei yore weumi, “Raei me kelee u keleene nekate holo na mekai nda a ahunerebondere. Rambun na roi bumane hele kani einye honowekebe ro mbai yae hubayeikoke benen kani yae feleungekoke na kena rei mai sele hubawounge. Eke naei rambun-rambun honowainyele nanemene hele naise heukoke beufoke nane rambunde moloufake kanire roi yae rouke.” ");
INSERT INTO set_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yesus nebei yore benen weumi, “Benen Raei me kelee u keleene nekate holo naeise Reyae ro mbai mutiara foise baeweke wanen mae ahunerebonde elerekondere. ");
INSERT INTO set_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nebei mutiara foi hubayeikokene, eke naei rambun honowainyele nanemene naise heukoke, nebeisa nda mutiara roi yae rouke.” ");
INSERT INTO set_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesus benen weumi, “Naei mekai mbai Raei me kelee u keleene nekate holo naeise Reyae ela bumokone hayaete ka na mane mane arilate wanen mae ahunerebonde. ");
INSERT INTO set_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kare baete ela ka yae maemae koikoyole hee ohore yae yoboiboyate maete, nebeisa angken mae roiboyate, foi-foi yo eleikoyate kakaline haweikoyate beko yo hayaete. ");
INSERT INTO set_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nebei mekai mbai huba mokoikoi ya mendene, malaikat yoni-yoni yae enate me hila u hilare kayeke ro miyaere wali himalainyeboke yo naeisa here bonaimile. ");
INSERT INTO set_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Nebeisa me hila u hila bele ro miyae i kaban beyele ranne hekelenaikonde, beko hubanainyelene rime a heraa kili-kili nebei anuwaunge anaikonde.” ");
INSERT INTO set_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesus yae hineumi, “Nda a elale mayae nanemene isaeyaeuboke?” Nda yo yae wainye, “Ehee, meyae isaeyaendeboke.” ");
INSERT INTO set_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yesus nda yore weumi, “Nebeinye Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi holona ro mbai Raei me kelee u keleene nekate holona ako faeukore ehe koukoke kiyae nda mekai yae yeuboke. Neyae imae rowa wanen, naei rambunde honate anuwaufa eba he neme bele male belere yakammikondere yaroukoke.” ");
INSERT INTO set_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Are ahunewole huwoumi riyau weubokera, nebei anuwaufa Yesus kulun uke ewole. ");
INSERT INTO set_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Yesus ewole kabande yeuboke yone eke. Allahre ei mom-mom imaene eweufike nebeinya ro miyaere a usaei kelewoumi. Borowate yo fa yae bowate elate, “Ndi isaei hebaen makeisa yaroukoke nane merau rambun emere-emere mokole makeinya elae wakebe kitewainye? ");
INSERT INTO set_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Aeisaeise nekande Neyae ore ahuneweke kiyaele fa, nenake Maria nauwake wa Yakobus, Yusuf, Simon, Yudas, ");
INSERT INTO set_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","nane merau nemaen wa nanemene aengkele nanembainye nekande. Nebeinye makeisabe nda wanen nanemene yarowole?” ");
INSERT INTO set_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nebei ro miyae Yesusre moi yae bulainyeboke. Yesus yae nda yore weumi, “Yendo kayaalo mbai ende ijenne be hinenainyende ei haungainyende, nebeibe naei yo yanne naei imae obene bere ehineiboi eise aiboi sele.” ");
INSERT INTO set_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Na yona yanna yo hila rabo ehalei aerene Yesus rambun emere-emere helen nebei anuwaunge omokoikoi. ");
INSERT INTO set_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nebei hee Ondofolo Herodes Galilea kani mere ikileuboke kiyae, Yesusle a yobowounge boroukoke. ");
INSERT INTO set_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nare hakowainye yore weumi, “Na hele nda Yohanes bure kowoumi kiyae nulu yo mahe yora aunguke. Nebei mekainye neyae elae rouke rambun emere-emere mokole.” ");
INSERT INTO set_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Nda Herodes yae na aka baeke Filipusle miyae Herodiasre rouke. Roko yae roko yae Yohanes yae Ondofolo Herodesre a elae uwounge, “Na ijen ban sele Herodias roukae.” Nebei aerene Herodes ukeumi Yohanesre ikilenaibonde kawane ahenainyekondere. ");
INSERT INTO set_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes Yohanesre hombondere kena kowolebe, nebeibe ro miyae helen Yohanesre yenjo kayaayo holona hi yae erewainyene fe yae faewole. ");
INSERT INTO set_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ondofolo Herodes na ralo yakama barauboke ya, raman bulau mokouboke. Nebei kanina rore raimi yo kaenewoumi hokoumeke. Nebei hee Herodias na maengke nebeinya ro miyae bene baene kowolera Herodes rei mai aungeboke kowole. ");
INSERT INTO set_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Nebeinye Ondofolo Herodes a holo yae heteungekoke nda maengke yae riyensinde rambun yennele hele. ");
INSERT INTO set_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nenake yae a moi-moi mokoungekokene nda maengke eke Ondofolo Herodesre riyewounge weunge, “Rare nda hee yae mo Yohanes bure kowoumi kiyaele yun hote einye ambombe yensele.” ");
INSERT INTO set_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nda a mekai riyeungehikene Ondofolo Herodes na kenara beko hele hubawounge, nebeibe ro bele yo hokoumeke bene a eleukokene ukeumile nebei maengke yae riyeumihike a huluinye hakouboke. ");
INSERT INTO set_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Yohanesle yun neisaise kawa eise ukeumi ekate. ");
INSERT INTO set_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Yohanes na yun naisake hote einye aiboke roukate mekate, nebei maengkere ikeungele, rouke eke nenakere ikeunge. ");
INSERT INTO set_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nebeisa Yohanes bure kowoumi kiyae na moisa orowate yo mekate na nore mo roukate a bulune aimoloufake. Nda yo yae ekate Yohanesle a Yesusre isaeyaeinyeboke. ");
INSERT INTO set_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yohanes bure kowoumi kiyae haiboke a Yesus boroukokera bae nebei anuwaufa keungehike kaisa hawaiboke aku ban nau ban anuwaufe enatere. Nebeibe ro miyae nebei a borokatene na yora yanda balaimeke Yesus kaisa fowolere yau nibira alainyekoke fowate. ");
INSERT INTO set_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesus naei fowate kai ohone fainyoke bele, ro miyae helen bolen hokoumeke erewoumine na beko hubawaime aerene kena beko hele hubawounge. Nebei yo hokoumeke nolona erare buloore kowate ro miyaere onomi iwoumi. ");
INSERT INTO set_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Huae rai yae Yesus na moisa orowate yo yae mekate mo Yesusre wainye, “Nda anuwau mon sele nane merau huae raibe yeuboke. Naei foi sele ndi yo-yo honatenare nda ro miyae weimi ai na hului raman enaiyarongkonde.” ");
INSERT INTO set_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nebeibe Yesus yae weumi, “Nda yo rahe londe wemmile enatere? Mayae raman yemmile anenaikonde.” ");
INSERT INTO set_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Na moisa orowate yo yae wainye, “Feu maehae mbai ka bee nebei mo maeinye honaime.” ");
INSERT INTO set_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesus yae weumi, “Raei bokore yarongko men.” ");
INSERT INTO set_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nebeisa nda ro miyae helen ukeumi angken mae mo ke ranne raiboke. Nebei feu maehae mbai ka bee belere mo yaroukoke, be bumare weuweke, Allahre helen foise mo ukeunge, nebei feu kaiwole, na moisa orowate yore iwoumi, nebei ro miyae helende wahewaimi. ");
INSERT INTO set_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Hokoumeke yo nanemene anaikoke uwa raeiboke. Nebeisa Yesus na moisa orowate yo raman kalun arilaisike kakali me bee oro nen bee bele maemae kaikoke. ");
INSERT INTO set_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nebei ramande anaikoke yo, ro mo 5.000 hului, miyae maengke bele nane merau fa-fa bele me ebaeikoi. ");
INSERT INTO set_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nebeisa Yesus na moisa orowate yore ukeumi kaisa hawaiboke bere holo yae bukoba reufire fonaimaembondere. Yesus nembai nekewole nda ro miyae helen bolen uwoumile ewate. ");
INSERT INTO set_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ro miyae eufokoubokera mo, Yesus nembai ebeli boisise moko mbaise ewole. Be baheuboke Yesus namman nebeinye nembai nekewole. ");
INSERT INTO set_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Na moisa orowate yo hawaiboke fowate kai ahau fele bumoko nolone, alu yekele elae hele raweubokene nauwala ruwae yae eiwo meiwo kowoumi. ");
INSERT INTO set_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Yare me fo hukai name hului Yesus na moisa orowate yo bokore bu randa aloungekoke mewole. ");
INSERT INTO set_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Na moisa orowate yo erainye Yesus bu randa mewolene kulu-kulu hele yaeiboke, fe waku roukeumi kate na kali bele kaenewate, “Enaelo ya!” ");
INSERT INTO set_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nebeibe Yesus yae weumi, “Hilembo. Reyae yae fe waku okoijae.” ");
INSERT INTO set_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petrus yae weunge, “Weyae na hele Yesusna, rare weise bu randa waei bokore ere.” ");
INSERT INTO set_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesus yae weunge, “Meinye.” Petrus nebei kai eisa bu ranne owakouboke aloungekoke Yesusle bokore eke. ");
INSERT INTO set_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nebeibe nauwala ruwae erewolene buhae hokoungeboke bae nauwa ruwambonde wanen hubawoungene kaenele, “Tuhan, rare hakoisobo!” ");
INSERT INTO set_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Na hibi hele Yesus na me nekeunge, ikileungeboke wa weunge, “Petrus, rahene kena wauwau koyae. Wa hila rabo kalo molotene?” ");
INSERT INTO set_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Hokolo bee kai einye yeisaweiboke bele alu bele na hibi kalaungeboke. ");
INSERT INTO set_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kai einya yo Yesusre ei molowainye wa elate, “Nana hesele Weyae Allahle Kelu.” ");
INSERT INTO set_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bukoba reufire fokate Genesaret yo ohone na kai fainyoke. ");
INSERT INTO set_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nebei anuwaunge ro miyae Yesusre rainyebokene, Yesus meke a yo yoni-yoni nebei kanina honatere eungeyoboukoke. Ro miyae erana buloona nanemene Yesusle bokore yauwaimi mewate. ");
INSERT INTO set_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nda yo Yesusre riwainye ehee kommikonde na malo buraisa mo katanainyele. Ro miyae nanemene na malo buraisa katawate yo onomi yarowate. ");
INSERT INTO set_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Farisi holona bele Musalena walora wali heere foloukoke isaeyaeikoke kelaeimi yo holona bele Yesusle bokore Yerusalem yora mekate mo hinainye, ");
INSERT INTO set_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Rahene wa moisa orate yo aei abu naei arai naeitena era hena moi wokate? Neyae me ekuikoi yae raman eyanewate.” ");
INSERT INTO set_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nebeibe Yesus yae nda yore weumi, “Rahene mayae nebei sului mbai Allah wali heere foloukoke are moi hayeyaube mai abu naei arai naeitena era hena aerene? ");
INSERT INTO set_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Rabuhine ban Allah yae a eleukoke, ‘Ako naekere be hinemmiyembe benen nde yae akore nakere olomo roromilena honaibonde hele.’ ");
INSERT INTO set_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nebeibe mayae elaube, nde yae ako naekere wemmile, ‘Raeinya mare isebe rambunbe, Allahre hili era akau erare erenjendere,’ ");
INSERT INTO set_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","nebei ro miyae ako nakere bere hinenaimile naeise era buhi ban yeiboyole. Nebei mekainye Allahle ako faeukore fomaiboyaunge abu naei arai naeitena era hena aerene. ");
INSERT INTO set_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mayae ro miyae faeu kai bee. Naijen sele mai naeise Allahle yendo kayaalo Yesaya yae Allah ukeunge a nuleungekoke. Nebei a nda mekai yae moloukoke, ");
INSERT INTO set_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Nda ro miyae Rare euwa boneisa mo be hinaise, nebeibe na kena u nahau buhau fele. ");
INSERT INTO set_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Na karo hele nda yo Rare ei molaise. Na usaei wasaei bae ro miyae yae elate wali heere folaikoke abe kelaeimi.’ ” ");
INSERT INTO set_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nebeisa Yesus nda ro miyae helende kaeneumikoke mo weumi, “Reyae elerele a borombe isaeyembe. ");
INSERT INTO set_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Euwa eise ate rambun mae nikire olei, kena u einya euwa walora baleimeyate yaere ro miyaere nikire olaeimi.” ");
INSERT INTO set_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nebeisa na moisa orowate yo mekate Yesusre wainye, “Weyae isaeyeubokae Farisi holona yore nebei a mekai wamaene na kenara ikele kate?” ");
INSERT INTO set_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesus a ahuneuboke weumi, “Ro mbai o meleme ha meleme omoloikoi yo na kambura hele endawengkonde wanen mae Maeko surgana ekenekele Kiyae yae ame-ame kelaeimi a faeufe era buhi ban mokommile. ");
INSERT INTO set_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nebei yo nenaeijae waemmihi, neyae ro miyae ijoko kumba. Ro mbai ijoko kumbabe benen ijoko kumba rore yawennehondena na beene bo einye eneibalende.” ");
INSERT INTO set_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Nebeisa Petrus yae Yesusre weunge, “Nebei a ahuneubokae wamae, maere bele yae yakaimebo.” ");
INSERT INTO set_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesus yae weumi, “Mayae namman isaeyeiboi mone? ");
INSERT INTO set_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mayae isian selene, rambun yoni-yoni euwa eise ate yarelere oyowate nebeisa kelen bele anuwaunge eyokate? ");
INSERT INTO set_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nebeibe euwa eisa baleimeyate rambun kenara mo hebeunge. Nebei yaere ro miyaere niki oleumi. ");
INSERT INTO set_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Rabuhine ban kena eisa u bene beko, ro miyae hoi-soise, yokore kaeimaere, yokore, ame-amere, aukakare, baleimeyate. ");
INSERT INTO set_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nebei u mekai yaere ro miyaere mokoumi niki belere baete, nebeibe me ekuyekoijae raman anendene ro miyaere nikire olei.” ");
INSERT INTO set_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Nebei anuwaufa Yesus eukuke ewole Tirus yo bele Sidon yo bele kelaeunga anuwaufe eke. ");
INSERT INTO set_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nebeinye Yahudi holona ban miyae mbai Kanaan kanine nekewole Yesusle bokore mele na kali bele kaeneimeyele, “Tuhan, Daudle orona mena, Wa yanekoi yase yae rare ei meisehaweise. Raei maengke fa alo yae aungebokene nauwa ekeukabeunge hele ya.” ");
INSERT INTO set_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yesus a ban faeu ban nekele, na moisa orawate yo yae wainye, “Nebei miyaere weinye ‘Eunge,’ beko hele aei moisa hakoumeboke kali yae kaeneimeyele.” ");
INSERT INTO set_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesus euweke nda miyaere weunge, “Allah Rare ukeufe mekale Israel ro miyae mo hakoremilere. Neyae domba nibira oneikoyate wanen yaeiboke, rabuhine ban Allah Naei a elelere oboroiboi katene.” ");
INSERT INTO set_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nda miyae Yesusle bene oro selen-selen roroukoke mo weunge, “Tuhan, rare hakoisobo.” ");
INSERT INTO set_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","((Yahudi ro miyae yae Yahudi ban ro miyaere yoku yae kaenewaimine)) Yesus yae weunge, “Na ijen ban sele fa-fa naei feu yarorekonde yokure haisemikonde.” ");
INSERT INTO set_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nebei miyae yae weunge, “Tuhan, na hele, nebeibe yoku naei hayeunge ro ramande anele anuwaufa feu mohi-mohi balate naei yoku yae eyanewole lonbe.” ");
INSERT INTO set_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesus yae weunge, “Wa hila rabo kaban sele! Waei kenare koyae hului yae yembonde.” Nebei hee yae nda miyae na fa onomi rouke. ");
INSERT INTO set_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Nebei anuwaufa Yesus aloungekoke Galilea buhaei yaufaeisa ewole. Nebeinya moko mbainye eukiteke nuweuboke nekewole. ");
INSERT INTO set_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ro miyae helen sele naei bokore mewate, ro miyae oro rebeisi-rebeisi yo, ijoko kumba yo, oro me nimewaimile yo, a mun yo, nane merau era buloo mahi-mahi kate yo, yarowaimi mewate Yesus noro wene hawaimi. Nebei yo nanemene Yesus yae onomi iwoumi. ");
INSERT INTO set_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nebei ro miyae helen nda rambunde na ijoko yae erewate: a mun yo a elewate, oro rebaeyeke yo alowate, orora nimewaimi yo ainyukate ele mele kowate, ijoko kumbare nekayeke yo ijoko erewate. Nebei erewate ro miyae fa yae bowate, Israel naei Allahre ei molowainye. ");
INSERT INTO set_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Nebeisa Yesus na moisa orowate yo kaeneumikoke mo weumi, “Nda ro miyae helen bolende nda ya name nendobe Rare mo hakaisekoke matene raman baeumihokene, Reyae kena beko hele hubanale. Reyae kena ban nda yore na moni yae ufemile enatere, rabuhine ban nibi nolone enate monine ijoko belau-belaunge balenayende bele.” ");
INSERT INTO set_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Yesus na moisa orowate yo yae wainye, “Nda anuwau mon wanen, makeinya raman mae yaromakonde nda ro miyae helen bolende na hului imamile anenaikonde?” ");
INSERT INTO set_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesus yae hineumi, “Mai mene feu naennaen hului honate?” Neyae wainye, “Feu mehine bee, ka fele-fele keli name.” ");
INSERT INTO set_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesus nda ro miyae helen ukeumi kani ranne raiboke. ");
INSERT INTO set_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nebeisa nane feu bele ka bele yaroukoke, Allahre helen foise mo ukeunge, nebei feu kayewole na moisa orowate yore wahewoumi, ro miyae helende wahenaimilere. Nebei sului mbai kare wahewaimi. ");
INSERT INTO set_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nebei ro miyae nanemene anewate uwa raeiboke, nebeisa anaikokena kalun arilaisike, kakali mehine bee maemae kaikoke. ");
INSERT INTO set_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ramande anaikoke me baeikoke ro mo 4.000, miyae fa-fabe me ebaeikoi. ");
INSERT INTO set_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nebeisa Yesus nda ro miyaere ukeumi ewate. Yesus naei kaisa eufileukoke naisike Magadan yo kelaeunga kanire ewate. ");
INSERT INTO set_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ya mbai Farisi holona yo bele Saduki holona yo bele riya mbai mekate Yesusle bokore u malire hubanainyehindere. Nda yo yae Allahle elae naei iwau mahi eme helere Yesus kelemmibondere riwainye. ");
INSERT INTO set_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nebeibe Yesus yae weumi, “Huae raei hu naeukoke inyukui hasai roroiboyolene mayae elaube, ‘Wahenare buma foi sele.’ ");
INSERT INTO set_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nane merau Israel kanine ya heiboyole rene hu naeukoke inyukui hasai roroiboyole mangko belene mayae elaube, ‘Yare molondere.’ Yaku buma na mekai ma mayae na hului nulembombe, nebeibe nda heena Raei me u mahi-mahi mokalere mayae isaeyeiboi sele. ");
INSERT INTO set_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mayae u hila wa hila koyaube ro miyae, hoime bahe rambun Allah merau wae ei molaungele lonbe, iwau emere-emere kelerembombere riyaufe. Mare na iwau eme hi ekeleiboi, Yunusle uwana yeubokere mo kelerembombe.” Nebeisa Yesus nda yore nanene nukeumiboke aloungekoke ewole. ");
INSERT INTO set_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesus na moisa orowate yo bele bukoba reufine fokate yae nda yo u bene nekeumihike feu na mene oroweifoi. ");
INSERT INTO set_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesus yae weumi, “Farisi holona bele Saduki holona bele yo naei ragire mauwa kayaa bele hebembe.” ");
INSERT INTO set_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Yesus nebei a mekai eleukoke borokatene, na moisa orowate yo hi yae hire weunge, “Eyae feu orowei meinye Yesus ndi a mekai haraungeboke elele.” ");
INSERT INTO set_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Nda yo yae elate a Yesus isaeyeuboke, nebeinye weumi, “Rahene mayae feu ban maube ane kolaunge, hila rabo wauwau koyaube ro miyae! ");
INSERT INTO set_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mayae namman isaeyeiboi selene! Mai u benera onengkokembe era, feu maehae mbai yae 5.000 ro anaikoke, nebeisa kakali naennaen hului kalun arilaufike? ");
INSERT INTO set_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nane merau feu mehine bee yae 4.000 ro anaikoke, nebeisa kakali naennaen hului kalun arilaufike? ");
INSERT INTO set_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Naendae mekai tonne mayae isaeyeiboi sele, feu naei abe Reyae eharaiboi eleikoi! Reyae wamale, Farisi holona bele Saduki holona bele naei ragire mauwa kayaa bele hebembe.” ");
INSERT INTO set_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nebei mekai a Yesus ukeumine, na moisa orowate yo isaeyaeiboke Farisi holona Saduki holona yae kelaeimi a usaei uwa kayaa hebenate, ragi hele ban. ");
INSERT INTO set_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kaisarea Filipi yo nobaeinyekoke mo, Yesus yae na moisa orowate yore a hinewoumi, “Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyaere ro miyae yae nde yae elate?” ");
INSERT INTO set_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nda yo yae wainye, “Ro miyae hiwa yo Yohanes bure kowoumi kiyae yae elate, hiwa yo Allahle yendo kayaalo Elia yae elate, hiwa yo Allahle yendo kayaalo Yeremia yae elate, hiwa yo yenjo kayaayo ro holona hi yae elate.” ");
INSERT INTO set_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nebeisa Yesus nda yore hineumi, “Nebeibe mayae nde yae Rare elaube?” ");
INSERT INTO set_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Petrus yae weunge, “Weyae Niyae Allah yae oro umaufe heraweubokete Wali Ondofolo, Allah huba ban haei ban nekeimeyele Kiyaele Kelu.” ");
INSERT INTO set_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesus yae Simon Petrusre weunge, “Foi moi sele weyae Simon Yunusle kelu, rabuhine ban nda are ro miyae yae ware ewei, Maeko Surgane ekenekele Kiyae yae ukete. ");
INSERT INTO set_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nane merau Reyae ware wawale, Wa ro Petrus, na mekai ruka. Nda ruka ranne raei jemaat arenundere naei ro miyae nulu yo mahe yo naei me kelee u keleene einyekei sele. ");
INSERT INTO set_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Raei me kelee u keleene nekate ro miyae holore enayembonde nibire Reyae ware kelereibote. Weyae nebei nibi romau kayaa roware yeubonde. Nda kani kelana rahe rambun weyae hun raungehinde, Allah surgana Kiyae nebei sului mbai ware be hinenete. Rahe rambun weyae meraufe raungehinde, Allah surgana Kiyae nebei sului mbai ware be hinenete.” ");
INSERT INTO set_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nebeisa Yesus na moisa orate yore a hun raumihike weumi, “Reyae Wali Ondofolore oro umau heraweufeboke a ro miyae hiwa yore ehuweijae.” ");
INSERT INTO set_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nebei heera Yesus huba raweuboke na moisa orowate yore na yaka yae uwoumi, Neyae Yerusalemde ende hele, nane merau Yahudi naei yun-jun naeisa, imam yun-jun naeisa, nane merau Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi yo naeisa, weitasi konainyele beko helen hubannekonde. Nebeisa honaibonde nebeibe ya name nendo Allah yae anennunde. ");
INSERT INTO set_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nebei a wanen Yesus eleukokene, Petrus me nekeunge Yesusre yaweungehoke enere yae ekete mo a elae yae weunge, “Tuhan, nda benate naeise felande yae Allah kena koukoube weungeweube. Nda mekai waei uwane ebeijae hele!” ");
INSERT INTO set_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesus weke Petrusre weunge, “Walobo yun, Ra moise yae eye, Rare oro halun wanen yeuboke kiyae. Waei u bene nekayete ro miyae helen mae u bene nekaimi hului mbai, Allahle u benene nekainye ma ban.” ");
INSERT INTO set_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nebeisa Yesus na moisa orowate yore weumi, “Raei moisa hakombonde ro, naei kenare koyele wali mekai kena yae herawende hele, nebeisa Raei aerene ohaline bonaikonde ro wanen mae Rare hakonsebonde. ");
INSERT INTO set_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Rabuhine ban nde yae naei wali Raei me einye ekinyeiboinya, naei wali hole omoloiboi. Nebeibe nde yae naei wali Raei me einye kinyensebondena, nebei kiyae naei wali hole molorembonde. ");
INSERT INTO set_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Na foi rahe ro miyae mbai nda kani kelana rambun naei me einye honoube, nebeibe wali hena bona eitowei. Nane merau rahe rambun mae na hului na wali hole moloiboise beneikonde. ");
INSERT INTO set_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Rabuhine ban Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae Maeko naei one hengko hehe kaban bele einye na malaikat yoni-yoni bele surgara memale. Nebei hee yae Reyae ro miyaere na u mekai wa mekai mokowate huluinye isemile. ");
INSERT INTO set_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nana heselebe Reyae wamale, ndane mewarileufike ro miyae mai nolona hiwa eherei mo nekenate, Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae Wali Ondofolore yolu ikilaiseboke one hengko bele ma yae merele erenaisele.” ");
INSERT INTO set_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ya mehine mbai nekaikokera Yesus yae Petrus, Yakobus, na aka baeke Yohanes naeise yaweumiboke nanembaisa moko mbaise ekate. Nebeinye nda yo na mo-mo ekainyekewate. ");
INSERT INTO set_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nebeisa na ijoko bene erewate Yesus nauwa mahi bewole. Na be yoi hehe hu inyukui wanen naeukoke, na malo keleumon wili halaman bowole. ");
INSERT INTO set_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Hokolo name erate Allahle yenjo kayaayo Musale Elia bele meiyakauboke Yesus naei ane elewate. ");
INSERT INTO set_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petrus yae Yesusre weunge, “Tuhan, na foi moi sele meyae nda anuwaunge mekannekande, Weyae kena koyae Reyae nda anuwaunge fale name herekonde, mbai waei, hi Musale, hi Eliale.” ");
INSERT INTO set_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Petrus ane weunge hee mangko hehe yae nda yore oumifelemboke. Nebei mangko eisa a borate, elele, “Nda Niyae buhaere haenale Fa, Ra kena foise mokoufe Kiyae. Nare mo boronnele!” ");
INSERT INTO set_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Hokolo name nda a borokate bae buhae hele hokoumiboke, be are aitoroke. ");
INSERT INTO set_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Nebeibe Yesus hokolo name bokore meke me yae katawoumi, weumi, “Annu, buhae ohokoijae!” ");
INSERT INTO set_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Na be waijeke erate bae, Yesus mbai mo hebewole. ");
INSERT INTO set_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mokora owate hee yae hokolo namere Yesus a hun kolowoumi wa weumi, “Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae nulu yo mahe yora arenunde ya nammanne, mayae ijokore eraukoke rambun ro miyae hiwa yore ehuweyeijae.” ");
INSERT INTO set_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Hokolo name yae hinainye, “Nebei mekainya rahene Musale walora wali heere foloukoke are isaeyaeiboke kelaeime holona yae elate, ‘Allahle yendo kayaalo Elia na bere holo yae mende mo nebeisa Wali Ondofolo mende?’ ” ");
INSERT INTO set_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesus yae weumi, “Na hele, Elia bere yae mende ro miyae naei wali beko belere hiyei ranembonde. ");
INSERT INTO set_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Reyae wamale, Elia meke, nebeibe ro miyae nare oroiboi kate, naei kenare kate hului yae mokainye. Nebei sului mbai Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae nebei yo naei me kelee u keleene beko erensubande.” ");
INSERT INTO set_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Nebei hee yae wa Yesus na moisa orowate yo isaeyaeiboke, Yohanes bure kowoumi Eliale u mekai wanen nekewole kiyaele abe Yesus elele. ");
INSERT INTO set_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesus hokolo name bele moko orone ro miyae helen rakewaimi bokore bukaiboke okate hee ro mbai meke Yesusle bene oro selen-selen roroukoke ");
INSERT INTO set_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","na a bele weunge, “Tuhan, Wa yanekoi yase yae ra kelu fare ei meungehawende. Roko yae roko yae wayang mae watene, naei yun beko yeiboyole, nauwa beko hele hubayeunge. ");
INSERT INTO set_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Wa moisa orate yo bokore roukanale ekendebe, nebeibe neyae onomi yeise na hului ban mae ukaisele.” ");
INSERT INTO set_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesus yae weumi, “Na hele ya, mayae nda kulunna ro miyae hila ban rabo ban yo nane merau wali nibi wewere koyaube yo. Reyae kena okoi sele, naendae mekai horo lon mangkele heki hele mbainye oroimeyandebe mayae Rare hila rabo ehalei sele. Nane merau kena beko hele hubanale, mai wali mekai nekeimeyaubere heki hele kena yae heraweumekale.” Nebeisa nda yore weumi, “Nebei fa yawennoho meu!” ");
INSERT INTO set_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nda fa nauwa einya walobore Yesus oku yae nekeunge. Na uwa einya walobo eukuke nebei hee na hibi hele nda fa onomi rouke. ");
INSERT INTO set_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ya hi yae Yesus na moisa orowate yo bele na mo-mo nekewate mo hinainye, “Rahene walobo hukeisi ferere meyae na hului ban sele kande?” ");
INSERT INTO set_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesus nda yore weumi, “Ma hila rabo kalo molombene. Nebeinye mare wamale nana hesele mai hila rabo sawi ko hului honayembe yae mayae na hului nda mokore waungele, ‘Nda anuwaufa ndire yae nakeleisi,’ nebei moko nakeleufiube. Mayae hila rabo halemmembena, na hului rambun kaban sele mokombe. ");
INSERT INTO set_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Nda walobo ma nendon mae ehukeisi hului, ebeli boungele bele yarele me heubonde moni yae nekeukonde bele na hului hukeumile.” ");
INSERT INTO set_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ya mbai Yesus na moisa orowate yo bele nanembaisa Galilea kanine arilaisike mo Yesus yae weumi, “Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae ro miyae naei me kelee u keleene enaisekinyembonde. ");
INSERT INTO set_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nebei ro miyae yae enaisehombonde, ya name nendo nulu yo mahe yora arenunde.” Nebei a ma na moisa orayeke yore ukeumine, na kena beko hele hubawainye. ");
INSERT INTO set_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesus na moisa orowate yo bele ewate Kapernaum yone aibaleke hee, Allahre ei mom-mom imae na kaban sele naei roise riyeyate yo Petrusle bokore mekate mo hinainye, “Allahre ei mom-mom imae naei roi dirham bee riyande mai guru mokombondere?” ");
INSERT INTO set_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petrus yae weumi, “Mokombondere.” Petrus imae eise eweufike. Eweufike hee mo, Yesus na bere a hineunge, “Simon, waei u benera naendae yae hubanae, nde naeise nda kani kelana Ondofolo yoni-yoni pajak naei roi riyeyaimi. Na kanina kelana ro miyaere? Yo moinya meiko-meiko ro miyaere?” ");
INSERT INTO set_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petrus yae weunge, “Yo moinya meiko-meiko ro miyaere.” Nebeinye Yesus yae weunge, “Nebeinya na kanina kelana ro miyae omokoi. ");
INSERT INTO set_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nebeibe nda kani yo kela yo eyae na kena beko mokomamibonde belene, kaiwa rowei bukobane eiwoyo. Bena ka yoboubonde rowele, neuwa kaeweungekonde roi dirham keli neuwa einye hubayeukonde. Nebei roi yaroukonde aei bee naei eumokoubonde.” ");
INSERT INTO set_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Petrusre ane uwounge hee yae na moisa orowate yo mekate Yesusre hinainye, “Waei me kelee u keleene nekate ro miyae nolone nde ro bele enainyerombonde?” ");
INSERT INTO set_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesus fa kaei-kaei mbai kaeneungekoke nda yo nolone haungeboke mo, ");
INSERT INTO set_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","weumi, “Reyae mare wamale, nana hesele mai wali nulu ekeiboi mauwa ebukeisi nda fa kaei-kaei wanen eyeiboinya, Raei me kele u keleene nekate holo einye mayae eyeiboi sului. ");
INSERT INTO set_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nde yae nauwa, na kena u ane rannehinde nda fa kaei-kaei wanen yembondena, Raei me kelee u keleene nekate holo einye nebei ro miyae ro kaban sele enainyeronde. ");
INSERT INTO set_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Nane merau nde yae Raei ro aerene na wali fa kaei-kaei wanen yeuboke ro miyaere ei hawennelena, Rare ei haweufe wanen. ");
INSERT INTO set_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nebeibe nde mai nolona nda fa kaei-kaei mbaise, na hila rabo Rare haleufera mokonnebonde ruwendena, naei foi sele nebei kiyae na horone ha ruka kaban mae bainyaisinde nau bune enaiwonde. ");
INSERT INTO set_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Nda kani kelana ro miyae hiware mokommile beko mokonaikonde ro miyae, beko hele hubanainyele. Rambun beko na hibi-hibi baete, nebeibe naei beko hele nebeise mokonate ro miyae. ");
INSERT INTO set_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Mai kena u foi yae kayaa hebembe. Na hului waei me mbai oro mbai era buloone elaekei sele konde. Na foi sele nebei me oro mbai neufande nainyekon mae euferende belene. Nebei sului mbai weyae na hului beko mokolere kena kole. Naei foi sele waei beko bele kena ure herawewende, weyae narakare ele belene. ");
INSERT INTO set_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nane merau na hului ijoko mbai era buloone elaekei sele konde. Na foi sele nebei ijoko mbai keleufinde, ijoko bee yae euferende belene. Nebei sului mbai weyae na hului rambun beko ijoko yae ereubondere kena kole. Na foi sele waei beko bele kena ure herawewende, weyae narakare ele belene. ");
INSERT INTO set_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Bene nekenayembe, nda fa kaei-kaei holonare ro ban mae eleijae. Reyae mare isaeyaemale, nda yo naei malaikat yoni-yoni Maekole be yoi na hibi mo surgane ekaikanainye na hului nebei fa holona a ungainyele. ");
INSERT INTO set_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","“Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae ro miyae na wali nalaiboke horoyate yore holere moloremibonde naeise mekale. ");
INSERT INTO set_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Waei u benera naendae yae nekayete? Ro mbai na domba rorele u maehae mbai (100) kate. Nebei nolora mbai nundeuboube. Nda mbai nundeubokere baeikoisene, na kayaa ro na domba 99 hele elune nukeumiboube? ");
INSERT INTO set_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Reyae wamale, nana hesele nebei domba mbai erennebondena, rei mai kaban sele koube, nda domba 99 elune nekate yore rei mai kommira. ");
INSERT INTO set_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nebei sului mbai Arai surgana ekenekele Kiyae kena kaban kole nda fa fele-fele u mekai wanen ro miyae nolora hi Naei wali nibi wewe okoyei nekenate. ");
INSERT INTO set_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Waka baeke yae beko ware mokoneibotena, wauwa yae na bokore ele, a usaei weungele. Boroneibotena nebei kiyaele aka baekere nekebe. ");
INSERT INTO set_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Neyae ware oboroinya, me u beko hiyei raneboise nebei rambun ijoko erewate ro miyae bee name a hului kolonnele naeise, ro mbai bee naei bokore yaweumibonde. ");
INSERT INTO set_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nebei yo naei a wainye oboroinya, naei me u beko mokouboke jemaatre isaeyemmibombe. Jemaat naei a oboroinya nare erennele Allahre onaeinye holona ro wanen nane merau pajakre arileyate ro beko wanen. ");
INSERT INTO set_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Rare hakaufele yore nana heselebe mare wamale, rahe rambun nda kani kelana mai kena mbai yae hun rannehimbena, Allah surgane ekenekele Kiyae nebei sului mbai be hinenembe. Nda kani kelane mayae kena mbai yae merau rannehimbe, Allah surgane ekenekele Kiyae nebei sului mbai be hinenembe. ");
INSERT INTO set_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Benen Reyae wamale, nda kani kelane mai nolona ro bee rambun mbaise na kena mbai yae riyeneisindena, nebei a boneinyele Maeko Surgana nekele Kiyae nebei rambun emmimokombonde. ");
INSERT INTO set_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Rabuhine ban makei anuwaunge ro bee name Raei ro einye arilenaisindena, nebei yo naei nolone Reyae rangkele.” ");
INSERT INTO set_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nebeisa Petrus meke mo Yesusre hineunge, “Tuhan, raei aka baeke yae rare u mekai beko mokonsebondena, roko naennaen mae nebei u mekai beko mokoufebokere raei u benera hanensekonde, roko mehine bee bele yae?” ");
INSERT INTO set_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesus yae weunge, “Roko mehine bee bele yae ban. Nana hesele roko u name me bee oro nen bee bele (77) hului yae mokoungekonde. ");
INSERT INTO set_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Nebeinye Raei me kelee u keleene nekate holona naeise ondofolo mbai na yebaei bubaei rambun yaraikokere mere baenaikondere kaenewoumi wanen mae a ahundebondere. ");
INSERT INTO set_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nebei mene mokowole hee, ro mbai rambun yaroweke na roi kaban sele 10.000 talenta hului yeubokebe nda ondofolo bere yawainyehoke mekate. ");
INSERT INTO set_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nebei ro nda roi kaban sului aheikoise na hului banne, nebei ondofolo yae ukeumi ekate, ‘Naei uwa, na miyae, na fa-fa, naeinya honainye rambun nanemene hele naise henaikonde, nebei roi suluise ahenaikondere.’ ");
INSERT INTO set_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Nebei yebaei bubaei be are neke be hineunge wa weunge, ‘Wa kena na hebaen fere rakeise. Nebei rambunde yaroukokale roi sului eraehengkonde.’ ");
INSERT INTO set_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nebei ondofolo kena beko hubawoungene, nebei rore heungeboke roi suluisa fomaungeboke omokoijae ukeunge. ");
INSERT INTO set_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Nebeibe nda ro nebei ondofolole bera eukukera, eke na kahili mbai naeinya rambun yaroweke na roi ane hele 100 dinar hului yeuboke kiyaebe hubayeikoke. Ikileuboke na horora ramewounge wa weunge, ‘Rambun yaroukokae roi sului hasale aheiko!’ ");
INSERT INTO set_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Na kahili are hele ruke a ri-ti yae riyeunge weunge, ‘Wa kena na hebaen fere rakeise. Nebei rambun yarokokale roi sului na hului ahereikote ya!’ ");
INSERT INTO set_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Nebeibe nda ro roko yae roko yae riwounge hororebe, neyae kena ban sele. Nebei ro kawane eungeheukoke hebende yaroukoke roi sului ahengkonde baensonde mo menduwende. ");
INSERT INTO set_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nebei u mekai mokouboke yebaei bubaei hiwa yo erewatene, kenara beko yae hubawainye. Nda u mekai mokoubokene nda yona ondofolore yakainyeboke. ");
INSERT INTO set_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Nebei ondofolo ukeumi na yebaei bubaei kaenainyekoke meke wa weunge, ‘Weyae ro beko hele, waei rambun yarowoyae na hebaen-sebaen riyewaraene reyae fomaubokawale. ");
INSERT INTO set_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Reyae ware yanekoi yase yae ei hawawale ma, wa kahilire weyae ei ehawei sului.’ ");
INSERT INTO set_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Nda ondofolo na kena ikele hele kowolene kawa kayaare hebate yore kinyeumiboke, nda ro nebeinye hebende naei yarowole rambun roi sului ahengkonde baensonde mo kawara menduwende. ");
INSERT INTO set_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Nda wali nekaubene maise naeise mai aka baeke naei bekore mai u benera nundenayengkombena, Maeko surgana ekenekele Kiyae nebei sului mbai mare enemmokombe.” ");
INSERT INTO set_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesus nda a usaei waeisaei huwoumi huba mokoungekokera, Galilea kanire kulun uke Yudea kanire endere bukeufike Yordan wi enaa reufira ewole. ");
INSERT INTO set_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ro miyae helen bolen Yesusre hakainyekoke, ewate ijenne erana buloona yo onomi yeumiyeke. ");
INSERT INTO set_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Farisi holona yo mekate oro halunde ungayonderene nda a yae Yesusre hinainye, “Musale walora wali heere foloukoke a huluinye na hului ro mbai naei kena hului yae na miyaere nennehinde?” ");
INSERT INTO set_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesus yae weumi, “Homona molaikoke a mayae kaukoke hele. Na bere hele ro me miyae mere mokouboke Kiyae ro bele miyae bele mokoukoke. ");
INSERT INTO set_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Nebeisa eleukoke, ‘Nebei aerene ro naei ako nake nukemmibonde na miyae bele mbainye nekenete, na beene uwa mbaise inyeibonde ((kena u aweneikonde)).’ ");
INSERT INTO set_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nebei mekai yaere uwa bee ban, nana hesele mbaise yeiboke. Nebeinye, Allah yae mbaise mokoungeboke yo ro miyae yae kayee omoloijae hele.” ");
INSERT INTO set_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nda yo yae Yesusre wainye, “Nebei mekai lonbe, rahe aerene Musa ukeumi ro na miyaere nennehinderena kayeere moloneikonde naei homo yae mokombonde yennele?” ");
INSERT INTO set_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesus yae weumi, “Allah Naei a eleukoke hakombere mayae kena okoi aerene Musa be hinembokembe. Nana hesele na bere nebei mekai ban. ");
INSERT INTO set_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nebeinye Reyae mare wamale, Nde yae na miyae ro hi bele uwa mbainye honoikoke aerene ban nennehinde, nebeisa maengke hi benen rowendena, nebei ro yoko kaeimaebe koukoke.” ");
INSERT INTO set_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yesus na moisa orowate yo yae wainye, “Rore miyaere yeiboyete na mekai nebei wanenna, naei foi sele ro miyae eyaroi, miyae maengke rore ei.” ");
INSERT INTO set_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Nebeibe Yesus nda yore weumi, “Ro miyae nanemene miyae ehurei a kelaemalere ehakoiboi sului, Allah Naei a elelere hakainye holona ro miyae mo na hului nebei a elelere hakonainyebonde. ");
INSERT INTO set_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ro miyae ban mo nekenende naeise hiwa nenakele yarele eisa nebei mekai honokatene, ro hiwa yo hakara yaraimi aerene miyae eyaroi. Hiwa Raei me kelee u keleene kalia na hibi-hibi mokate aerene miyae eyaroi. Nde yae na hului Raei kelaemale a usaei hakonnele, nenaeijae hakonnele.” ");
INSERT INTO set_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nebei hee yae ro miyae na fa-fa fele-fele naei yun ranne Yesus mere kolommilere nane merau Allahlere ebeli boisi naeise Yesusle bokore yauwaimi mewate. Nebeibe Yesus na moisa orowate yo yae nebei fa-fa yaraimi mate ro miyaere a elae yae uwaimi. ");
INSERT INTO set_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesus na moisa orate yore a elae yae weumi, “Rahene nebei fa-fa a hun kolaumi, waemmihi Raei bokore mai. Rabuhine ban ro miyae nde Rare hila rabo haleufe nda fa-fa naekole nenakele hila rabo haleyaimi wanen mae Raei me kelee u keleene nekate holone na hului enayembonde.” ");
INSERT INTO set_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nebeisa Yesus na mere mo nda fa-fa naei yun ranne koloumikoke. Baeufokera mo Yesus nebei anuwaufa kulun uke ewole. ");
INSERT INTO set_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ro mbai Yesusle bokore meke mo weunge, “Guru, rahe me u foi yae mokorebondene wali hena bona eitoufele?” ");
INSERT INTO set_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesus yae weunge, “Rahe aerene ‘foi’ naei are Rare hinarae? Ako mbai ken sele foi. Nebeibe waei kena koyae wali hena bonare rowelerena, Musale walora wali heere foloukoke a faeube hakoubonde!” ");
INSERT INTO set_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nebei ro yae Yesusre weunge, “Wali heere foloukoke makei kayeero?” Yesus yae weunge, “Ro miyae ohoijae, ro miyae bele miyae ro bele mbainye ohonoijae, yoko ebaeyeijae, ro naei miyae naei a ame-ame ehuweijae, ");
INSERT INTO set_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ako nakere be hineumiyende, waei uware kena buhae haenae wanen nebei sului mbai ya-ya wali nibi mbainye oraube yore heumiyende.” ");
INSERT INTO set_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nda ro yae weunge, “Nda warae nanemene mokoimeyale, rahebe erarae kalore moloufe?” ");
INSERT INTO set_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesus yae weunge, “Waei kena haehae koyae wali himaloungebonderena, eye, waei keren nale honayete nanemene naise heukonde. Nebei keren nale heukonde na roi keren ban nale ban ro miyaere waheumikonde. Surgana eba he yae weyae eukowende. Nebeisa mele raei moisa meufakoubonde orayende.” ");
INSERT INTO set_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nebei ro nda a wanen boroubokene na kena beko hele hubawoungene, aloungekoke ewole. Rabuhine ban nebei ro keren nale helen sele honowainyelene. ");
INSERT INTO set_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nebeisa Yesus na moisa orate yore weumi, “Na helebe Reyae wamale, na yabi-yabi hele ro mbai keren bele nale bele kiyae, Raei me kelee u keleene nekate yo holo eise enensindere. ");
INSERT INTO set_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Benen Reyae wamale, aimake bulure obo unta na hului eweifiube, nebeibe keren bele nale bele yo Raei me kelee u keleene nekate yo holonare enayembondere na yabi-yabi hele.” ");
INSERT INTO set_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yesus na moisa orate yo nda wanen borowatene fa yae bowate. Nebeisa Yesusre hinainye, “Nebei wanenna, nde naeibe wali hena bona enaijaronde naeise hole emmimolombonde?” ");
INSERT INTO set_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Nda yore kaeneumikoke wa Yesus yae weumi, “Ro miyae yae nda rambun omokoi hului, nebeibe Allah yae rambun nanemene na hului mokoikoyele!” ");
INSERT INTO set_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nebeinye Petrus yae Yesusre weunge, “Meyae mokandeke rambun nanemene nukewande haiwande, ware mo hakayekokete. Nebei mekainye rahe era yae meyae emayarongkonde?” ");
INSERT INTO set_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesus yae weunge, “Reyae na helebe nda a wamale, nda kani kela neme ennebensonde hee Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae one hengko bele yae kendan wameranne nuwerebonde hee, mayae Rare hakaufekoke yo ro me bee oro nen bee bele (12) kendan wameran mokoungehake ranne enrombombe, Israel yoho yoni-yoni mai keleene enainyekende. ");
INSERT INTO set_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nane merau ro miyae nde Raei ro aerene naei imae obe, naei aka baeke, ako nake, kelu omi, na buro kela nukewole, nebei kiyae raka rorele u maehae mbai (100) sele nebei rambun nukewolere enjarongkonde nane merau wali hena bona endowende. ");
INSERT INTO set_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nebeibe rore rowaimi ro miyae helen Allahle bene ro ban inyaibonde. Nane merau nda hee ro ban nekate ro miyae helen ro bele inyaibonde.” ");
INSERT INTO set_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesus nebei yore weumi, “Raei me kelee u keleene nekate ro miyae holona na mekai, rowa mbai na rene kaukau imaera akouboke naei anggur hekere mokonate yone baeumiyeke wanen mae a ahunerebonde ufembere. ");
INSERT INTO set_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Weumikoke yo ya mbai na roibu hobeikoise dinar mbai yae be hinaiboke, nebeisa nda yore ukeumi naei anggur hekene ekaimokowate. ");
INSERT INTO set_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Nda heke rowa rene hukai mehine keli hului eukuke oroweke. Nai hei-sei anuwaunge ro miyae hiwa kalia ban nekatebe erewoumi. ");
INSERT INTO set_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nda yore weumi, ‘Mangkele yae raei anggur heke kalia mokombere. Eme, roibu yeyaimi hului mare isembe.’ ");
INSERT INTO set_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nda yo alainyekoke ewate. “Rai hu hului me bee oro nen bee bele (12) nane merau huae rai hukai name hului eukuke oroweke, ro hiwa yo hubayaeikoke mo bena hubayaeikoke a hului yae benen ukeumi. ");
INSERT INTO set_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Huae rai hukai maehae mbai sului benen eukuke oroweke, ro miyae hiwabe hubayaeikokere nda yore weumi, ‘Rahene mayae nda hu koko kalia ban nekeyaube?’ ");
INSERT INTO set_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Nda yo wainye, ‘Ro hi kaliare emamokonde naei a eweinye.’ “Heke rowa yae weumi, ‘Nebei mekainya mayae raei anggur hekene kalia emmoko.’ ");
INSERT INTO set_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Hu helae bowole hee nda rowa na kalia yunde hebele rore weunge, ‘Kalia yo nanemene na roise waheumikondere kaeneimiko mai. Moisa mayeuboke yo naeise huba raweubonde waheumile onde na rene na mayeuboke yo na moi sungkaya.’ ");
INSERT INTO set_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Hukai maehae mbai sului kaliare mayeuboke yo mekate, nebei kalia yun mae ro mbai dinar mbai yeumikoke. ");
INSERT INTO set_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nebeisa na rene hele kaliare mayeuboke yo mekate, nda yo na u benera nekaimi helen yaronaikonde era, nebeibe nda ro mbai dinar mbaibe yeumikoke. ");
INSERT INTO set_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nda yo yaraikoke heera na mulun-mulun bele heke roware wainye, ");
INSERT INTO set_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Moinya hele mayeuboke yo hukai mbai mo kalia mokaikoke bele meyae nda hu koko rolonsan ijaja beyande yo bele, rahene roi nane helen nen yeumekokae?’ ");
INSERT INTO set_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Nebei rowa yae na ro hire weunge, ‘Aka baeke, rahe u mekai ware keleubokawalene raei u mekai na ijen ban mae eleyae? Ya mbai dinar mbai isete naeise weyae be hineubokae. ");
INSERT INTO set_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Waei kayeero rowei, ndara eye. Reyae ware ikawale hului yae kalia moisa hele mayeuboke yore isemikondere kena kale. ");
INSERT INTO set_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Raei rambun honaisele raei kena hului yae mokorele. Reyae eiwahe meiwahe kena ma haraungebokalene, nebeinye weyae kena hensen okoijae!’ ");
INSERT INTO set_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Naei mekai yaere ro ban nekate ro miyae helen Allahle bene ro bele inyaibonde. Rore raimi ro miyae helen ro ban inyaibonde.” ");
INSERT INTO set_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesus naei Yerusalem yore ewate, nibi nolore mo haeikoke bae na moisa orowate yo me bee mehine bee belere mo kaeneumikoke, nenaei mo arilaisike Yesus ane weumi, ");
INSERT INTO set_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Angkaei boron! Eyae nda hee Yerusalem yore ande. Nebei anuwau emalene Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyaere imam yun-jun holo bele nane merau Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi yo holo bele me einye kinyenaisebonde. Nebei yo yae honaisebonde naei a hokonaikonde. ");
INSERT INTO set_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nebeisa Yahudi holone eyeiboi yore kinyenaisebonde. Nebei yo yae aukaka weitasi konaisele, nane merau ohaline bonaisekonde, nebeibe ya name mo Reyae arenunde!” ");
INSERT INTO set_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nebeisa Zebedeusle miyae na fa-fa bee Yakobusle Yohanesle yaweumiboke Yesusle bokore ekate, oro selen-selen mae roroukoke, rambun mbaise riyennehindere. ");
INSERT INTO set_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesus yae weunge, “Rahe rambunbe weyae kena koyae?” Zebedeusle miyae yae weunge, “Waei me kelee u keleene nekate ro miyae holo einye, reyae kena kale nda fa-fa bee na huluinya Wa meline meubene eumihangkonde.” ");
INSERT INTO set_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Nebeibe Yesus yae weunge, “Rare riyarae a mekai wenaeijae isaeyeiboi.” Yesus euweke hokolo bere weumi, “Reyae andehinde bu kolaei mayae na hului aneisibe, ((Rare beko enaisehubande na hului mayae ennehubabe))?” Yesusre weinye, “Meyae na hului.” ");
INSERT INTO set_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Nda beere Yesus weumi, “Nana hesele Reyae andehinde bu kolaeisa mayae aneisibe. Nebeibe Raei meline meubene ennekebe naeise Raei me einye ban. Nebei anuwau Maeko yae eleukoke ro miyaere yemmile naeise mokoungehake.” ");
INSERT INTO set_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Yesus na moisa orowate me bee hiwa yo nebei wanen a borokatene, hokolo beere ikele hele kowaimi. ");
INSERT INTO set_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nebeinye Yesus nda yo nanemene kaeneumikoke mekate mo weumi, “Mayae maisaei, nda kani kelana yun-jun Allahre isian nekeyate holona naei kena hului yae naei me kelee u keleene nekate yore mokoyaimi. Nane merau ondofolo kose na keleena yore herawaimi weijei kaeiboi ban nekeyate. ");
INSERT INTO set_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mai holona nekaube nolone nebei mekai ban. Nde yae kena kole mai nolone kabande yembonderena, mai yebaei bubaeise yembonde hele. ");
INSERT INTO set_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nane merau nde yae mai nolone be neiboi rore yembondere kena kondena, mai yebaei bubaeise yembonde hele. ");
INSERT INTO set_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Rare erensebo, Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae Rare mokonaiselere mekale ban. Reyae ro miyaere mokoremilere mekale, nane merau ro miyae helen naei beko bako aherekonde baensonde naeise Raei uwa yae kinyeremibonde honaisebonde.” ");
INSERT INTO set_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesus na moisa orowate yo bele Yerikho yora aibaleke hee ro miyae helen bolen Yesusre hakainyekoke ewate. ");
INSERT INTO set_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Yesus ewole nibi enene ro bee ijoko kumba roiboke nekewote. Yesus ele borowotene hokolo bee kali yae kaenewote, “Tuhan, aei Yahudi Ondofolo Daudle orona mena, Wa yanekoi yase yae maere ei meimaibo!” ");
INSERT INTO set_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nane ro miyae helen bolen ate yo yae hokolo beere waimi, “Hileibo!” Nebeibe nda bee benen kali elae hele yae kaenete, “Tuhan, Ondofolo Daudle orona mena, maere yanekoi yase yae ei haweimeko!” ");
INSERT INTO set_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nebeinye Yesus hebeunguke, hokolo beere kaeneumikoke mo, Yesus yae hineumi, “Rahebe mayae kena koube Reyae mokorebobere?” ");
INSERT INTO set_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Hokolo bee yae weinye, “Tuhan, maei kena ijoko eralere konde.” ");
INSERT INTO set_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesus kena beko hele hubawoungene, na mere mo nekeunge na ijokora me rameumihike. Nebei hee yae na ijoko keleikoke na hului erewote. Nebeisa Yesusre hakoinyeboke ewate. ");
INSERT INTO set_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesus na moisa orowate yo bele Yerusalem yo bere mo rainyehike hee Zaitun moko orona honole yo Betfagene aibaleke. Ro beere mo ukeumi bere holo yae eneterene ");
INSERT INTO set_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","nda a bele weumi, “Ma bena yo honolere yae ebe.” Nebei yo ebalebene keledai nafe mbai ha yae wokainyele na kelu bele hebetebe hubayekobe. Nebei keledai ha bulaerennekobe na beene yawemmibobe mebe. ");
INSERT INTO set_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ro miyae hi yae hinenayebe wanenna, wemmile, “Tuhan Yesus nda keledai rande hebenundere, nebeisa benen roungaimete.” ");
INSERT INTO set_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Na bena Allahle yendo kayaalo Zakharia yae nuleungehoke a na hului yembondere nda rambun bewate. Zakharia nda a mekai moloukoke, ");
INSERT INTO set_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Yerusalem yore a weinye, ‘Erei! Mai Ondofolo mai bokore mele. Nebei ro kena nime haba keledai kelu randa mele.’ ” ");
INSERT INTO set_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Hokolo bee ekete Yesus yae ukeumi hului yae eimokouboke. ");
INSERT INTO set_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Keledai nafe na kelu bele nanembaisa yaweimiboke, nebeisa keledai moko ranne malo baikoke, Yesus keledai ranne yeufebeunguke. ");
INSERT INTO set_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ro miyae helen bolen sele ei haungainyelere malo nibine bewate, hiwa yo o maensa nihewate ende nibine haiwate. ");
INSERT INTO set_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Bere ate holona bele, na moisa mate holona bele kaenate, “Foi moi Ondofolo Daudle orona mena kelu. Allahle ro yae meke Kiyae, onomi foka hubanayende. Allah anuwau na bumana hele nekele Kiyaere eyae nemene ei moloman.” ");
INSERT INTO set_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yerusalem yo eise eweufike hee ro miyae yeufike, eisine meisine hinate, “Nda ro nde?” ");
INSERT INTO set_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ro miyae yae elate, “Nebei niyae Yesus Galilea kani Nazaret yona yendo kayaalo.” ");
INSERT INTO set_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesus Allahre ei mom-mom imae na kaban sele kiyae eise eweufike, ro miyae imaehounge naise haete yo, yaroi-yaroise yarate yo nanemene hukewoumi, Yahudi naei ban roi yarowate Yahudi naei roi yae ibewaimi yo naei anuwau, merpati naise haete anuwau, yarowole are felewoumi. ");
INSERT INTO set_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Nda yore Allah Na homofaene Naei imae are moloukoke Yesus yae weumi, “ ‘Raei imae ebeli boi-boi imae yae enayelende,’ nebeibe mayae mokaungeboke yokoyo naei nalere yeuboke.” ");
INSERT INTO set_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ro miyae ijoko kumba bele orora nimewaimi yo bele Yesus Allahre ei mom-mom imae na kaban sele kiyaene eweufikere hokoumeke, nanemene Yesus onomi iwoumi. ");
INSERT INTO set_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nebeibe imam yun-jun nane merau Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi holona yo Yesus iwau emere-emere mokowole erewatene nane merau nebeinya fa-fa a bulau wae kate ei molainye, “Onomi foka Daudle orona mena kelu” boratene, na kenare ikele hele kowate. ");
INSERT INTO set_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nda yo yae Yesusre wainye, “Nda fa-fa yae elate a weyae boroyae?” Yesus yae weumi, “Reyae borale. Mayae roko mbai Allahle homofaene molaikoke okoikoi mone? Nebei homofae Raei naei are moloukoke, Fa-fa wayeu naei euwara bele fa-fa fele-fele naei euwara bele Ware buma kaenayete naeise mokoungehake.” ");
INSERT INTO set_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nebei yore Yesus nanene nukeumiboke Yerusalemda eukuke, bukeufike Betania yone ensonondere ewole. ");
INSERT INTO set_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Na rene hele Yesus benen bukeufike Yerusalemde ewole. Nibine ewate hee Yesus moni hubawounge. ");
INSERT INTO set_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nibi kelaeunge ara no erekene nebeise yae eke, nebeibe ani mbai ereiboi sele, fae bangka mo hebewate. Nebei ara nore weunge, “Weyae nda heera ani omokoi mo hebewendere!” Are ukeunge hee na hibi nebei ara na fae habawate. ");
INSERT INTO set_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Na moisa orowate yo iwau eme hele mokouboke erewatene fa yae bowate nebeisa elate, “Naendae mekai yae nda ara no na roko mbai sele kalaukoke?” ");
INSERT INTO set_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesus yae weumi, “Reyae nana heselebe wamale, Mai hila rabo kena wauwau banna, mayae na hului nda ara nore ukanale kalaukoke ma mokombombe, nane merau nebei mo ban. Mayae na hului nda mokore wennele, ‘Weije naubune eituwe,’ nebei rambun na hului enaibende. ");
INSERT INTO set_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mai ebelire embombe rambun hila rabo nana heselena, mayae na hului enjarombe.” ");
INSERT INTO set_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Allahre ei mom-mom imae na kaban sele kiyaene Yesus eweufike kelewoumi hee, imam yun-jun bele Yahudi yoyo koseyo bele Yesusle bokore mekate mo hinainye, “Ndele ro yae nda me u mekai nanemene Weyae mokoyae? Nde yae nda elae ikete?” ");
INSERT INTO set_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesus yae weumi, “Reyae naei mekai a mbaise mare hinerensimbere. Nebei a hinerensimbe Rare yakansebombena, nebei me u mekai mokalere Rare elaere ikeufe a mare yakarembombe.” ");
INSERT INTO set_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yesus nda yore hineumi, “Ndele ro yae Yohanes ro miyaere bure kowoumi, Allahle ro yae, ro miyae naei ro yae?” Nda yo nenaei mo a kolainyekoke wa elate, “Eyae umande, ‘Allahle ro yae,’ Neyae wemmele, ‘Nebei mekainya rahene mayae nare na hele yae eleikoi kowaube?’ ");
INSERT INTO set_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nebeibe eyae umande, ‘Nda ro miyae naei ro yae,’ eyae nda ro miyae helen boronaibondere buhae hele hokoume.” Rabuhine ban ro miyae nanemene hele nda Yohanesre Allahle yenjo kayaayo holona yae elatene. ");
INSERT INTO set_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nebeinye nda yo yae Yesusre wainye, “Meyae maeisaei ban.” Yesus yae weumi, “Nebei mekainya, Reyae naei mekai mbai ndele ro yae mokale naeise mare eyakai.” ");
INSERT INTO set_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesus yae nebei yore weumi, “Nda ahumbo-ahumbo ahunerebonde rahe a yae elembe? Ro mbai na kelu wa bee hele. Nebei ro eke na kelu benare weunge, ‘Kelu, mana ya eye, anggur hekene kalia eimoko.’ ");
INSERT INTO set_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Na kelu bena kiyae yae weunge, ‘Arai, reyae nebei kaliare ahi elale.’ Nebeibe na heki ban mo, naei u bene nekainyekokera mehi neufake aloungekoke nebei hekene ekemokowole. ");
INSERT INTO set_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Nda ro na kelu moinya bokore eke nebei a hului mbai ukeunge. Nebei fa yae weunge, ‘Arai reyae erelere.’ Nebeibe neyae hekere ei nekewole. ");
INSERT INTO set_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Nda kelu wa beera nde yae naekole a hakouboke?” Nda yo yae wainye, “Bena fa kiyae yae.” Yesus yae nebei imam yun-jun bele Yahudi yoyo koseyo belere weumi, “Reyae na helebe nda a wamale, Pajak roi arileyate yo bele nauwa naise heyate miyae maengke bele Raei me kelee u keleene nekate yo holo eise mare moi ungainyemombe bere yae enayembonde. ");
INSERT INTO set_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Rabuhine ban Yohanes bure kowoumi ro meke Allah mokoungehake nibi ro miyaere wali himalainyeboke yore me baemmile are kelewoumi mayae boraukokebe, na helere eleikoi nulu ekeiboi. Nebeibe nane beko bako bele yo na hele yae elewate.” ");
INSERT INTO set_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesus yae weumi, “Benen a mbaise ahunerebonde ufembere borombe. Kani rowa mbai anggur heke mokouboke mo nebei heke ele yae neuboke, anggur bure ramenate rilenate naei anuwau a bulu waeuboke, heke kayaa hensen naei imae heuboke. Nebeisa roi yae mokonate yore nebei heke kinyeumiboke, kulun uke, yo hire kolone oroweke. ");
INSERT INTO set_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Anggur anire hokonate hee meuyeuboke mo, kani rowa na yebaei bubaeise ukeumi anggur ani naei kayeerore yarongkonderene na hekere mokate yo bokore ekate. ");
INSERT INTO set_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Nebeibe hekere mokate yo nda yebaei bubaei ukeumi ekatere ikilaikoke hi erahuae yae baikoke, hi haiboke, name nendo ruka yae haiwainye. ");
INSERT INTO set_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nebeisa kani rowa na yebaei bubaei helen sele na bena ekate hului mbai ukeumi ewate, nebeibe na bere ukeumi ekatere mokowaimi mekai yae nda yore mokowaimi. ");
INSERT INTO set_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kani rowa na yebaei bubaei haikoke baeufokene, na moi sungkaya hele naei kelu mbai ken sele nda yo bokore ukeunge ewole. Naei u benera elele, ‘Raei kelu yae endene fe faenainyele.’ ");
INSERT INTO set_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Nebeibe heke yo na kelu mewole erekainyele hee, hi yae hire weunge, ‘Kani rowa naei rambunde kinyennele kiyaebe mele. Men! Eyae homabon. Nebei mekai yaere nare kinyennele rambun aeise inyaibonde.’ ");
INSERT INTO set_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Heke yo nda kelu fa ikilaiboke, heke moise yobaiboke eke mo, nebeisa haiboke.” ");
INSERT INTO set_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesus yae hineumi, “Kani rowa bensonde mende hee anggur hekere kinyeumiboke mokowate yore naendae mekai yae mokommibonde?” ");
INSERT INTO set_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nda yo yae wainye, “Nebei u mekai bekore mokaiboke yore hongkonde beko mokommibonde, nebeisa nane anggur heke mokowate hiwa yore kinyeumibonde. Nebei yo yae anggur anire na rokone baei nebei rowa bele enaiwahende.” ");
INSERT INTO set_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesus benen weumi, “Mayae Allahle homofaene nda mekai yae moloukokene kaukoke hele, ‘Imae hei-seise isaei hebaen bele yo na hului banne wokate rukabe Allah yae nebei imae naei berei rukare mokouboke. Aei ijokone erannele nebei wanen mokouboke foi sele.’ ” ");
INSERT INTO set_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Nebei aerene Reyae wamale, Raei me kelee u keleene nekate yo holore mayae Yahudi agamanare mo hakaube yore eyei. Raei kena kale me u mokonatere ro miyae ani foise mokate o wanen yaeiboke. Nda u mekai wanen ro miyae Raei me kelee u keleene nekate yo holonare enaijembonde. ");
INSERT INTO set_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nde naei Rare moi ungaisondena, ehee bukulu inyaimile hele. Nebei yo ruka oro halunde naleisiyeumi oimohaete wanen inyaibonde. Nane merau nde naei Reyae mere noremiyonde yo, ehee bukulu ehekaei sele inyaimile hele. Nebei yo ruka yae ennefelembonde wanen, mohi-mohi kamai-kamai inyaibonde.” ");
INSERT INTO set_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Imam yun-jun nane merau Farisi holona yo Yesus yae a ahunewole huwoumi borokate hee, nda holo bee isaeyaeiboke naei uwa naei abe Yesus ahuneuboke huwoumi. ((Naeisaei nekate neyae heke mokate yo nane merau imae hei-sei isaei hebaen bele yo bele a ahuneuboke.)) ");
INSERT INTO set_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nebeinye Yesusre ikilenaibonde naei nibine baewate. Nebeibe ro miyae helen Yesusre Allahle yenjo kayaayo holona ro hi yae bene nekewaimine, nda yo Yesusre ikilenaibondere buhae yae hokowoumi. ");
INSERT INTO set_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nda ro miyae helende Yesus benen Yahudi ro miyae Nare me u mokonainyelere a yae ahuneuboke huwoumi, ");
INSERT INTO set_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Raei me kelee u keleene nekate yo na mekai ondofolo mbai na kelu miyae rokeungere raman bulau mokouboke wanen. ");
INSERT INTO set_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ro miyae helen homo haiwoumi menatere. Raman bulau mokoungehake hee, na yebaei bubaeise ukeumi homore hayeukoke yore kaenaimiyeke, nebeibe hi yae ha yae emei mo. ");
INSERT INTO set_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Benen na yebaei bubaei hiwa yore ukeumi nda a yae nebei homo hayeukoke yore wemmiyendere, ‘Nana hesele, raman ninae mokainyehake, sapi uwa foi moi roukate folaikoke. Nanemene hele mokainyehakene, men, nda raman bulau anuwaufe yae, ema!’ ");
INSERT INTO set_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Nebeibe homore haiwaimi ro miyae oboroi angkaei nekewate, hiwa na buro kelare ewate, hiwa na kalia anuwaufe ewate. ");
INSERT INTO set_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Nane merau hiwa yo nda ondofolo na yebaei bubaeise ikilaikoke erahuae yae bowate nane merau haikoke. ");
INSERT INTO set_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Nebei ondofolo na yebaei bubaei haikoke a borokene ikele hele haneungeboke. Na felayore ukeumile enate rore haikoke yo honaikonde, na yo yan i yae relenainyekonde bende. ");
INSERT INTO set_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Nebeisa nda ondofolo na yebaei bubaeise weumi, ‘Rore miyaere yeiboke raman bulau mokoungehakale, nebeibe homore hayeumikokale ro miyae na u mekai beko aerene ndare menate naeise na hului ban selene. ");
INSERT INTO set_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nda hee embe nibi kaban enene, nibi kainye hubayembe ro miyae nanemene yawemmile raman bulau mokoungehakale anuwaufe hokommende.’ ");
INSERT INTO set_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nebei yebaei bubaei ekate nibine hubaiwate ro miyae na u mekai beko, foi, nanemene yauwaimile raman bulau wakundanne hokoumeke yo yae maemae meukoukoke. ");
INSERT INTO set_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ro miyae hokoumeke ijoko ereiboise nebei ondofolo eweufike bae, ro mbai raman bulau malo ehireikoi mekebe erekeunge. ");
INSERT INTO set_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nebei ondofolo yae nda rore weunge, ‘Aka baeke, weyae naendae mekainye raman bulau naei malo ehireikoi yae nda anuwaufe meweufikae?’ Nebei ro a ban faeu ban yeuboke. ");
INSERT INTO set_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Nebei ondofolo na yebaei bubaeise weumi, ‘Nebei ro noro me ha yae rinenneko, ouben kika anuwaunge kannehimbe ennekende, ndine rime a heraa kili-kili engkonde.’ ” ");
INSERT INTO set_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Nebei a ahuneuboke huwamaele naei no nda niyae: Allah ro miyae helen bolen Raei me kelee u keleene nekate yo holone enayembondere kaenemmile, nebeibe Raei a elalere hakainye ro miyae mo enaijembonde. Nebei u mekai ma ndana ro miyae keli name hele.” ");
INSERT INTO set_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nebeisa Farisi holona yo ekate meraunge ekaikolowainyele, rahe a yae hinenainyehindene na hului Yesusre oro halun ungainyonde. ");
INSERT INTO set_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","((Naeisaei nekate Farisi holona pajak mokonatere ahi hele elate nane merau Ondofolo Herodesre hakainye holona yo kelaeimi pajak mokonate helene)), nebei holo bee na yo hiwa ukaimile Yesusre a hineisise ekate wainye, “Guru, meyae maeisaei Weyae ro mbai wali ijen sele nekeyeyae. Ro miyae be ijokore ereyei, nebeibe be rabuleiboyoyae Allah Naei wali nibire na ijen mae kelaemae. ");
INSERT INTO set_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nebeinye Waei eranae ma maere weime, Romawi kani naei Ondofolo kaban Kaisarre roi mokomandere, omokoijae?” ");
INSERT INTO set_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Na merau beko rainyehike Yesus isaeyeubokene, nebei yore weumi, “Faeu kai bee ro miyae, mayae kena kaube Rare oro halunbe hayaeufe. ");
INSERT INTO set_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mayae pajakre mokaube roi Rare kelensebo!” Nda yo Romawi kanina roi dinar roukate Yesusre ikainyele. ");
INSERT INTO set_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yesus nda yore weumi, “Nda ndele be yoi mokouboke, na me nou bele molaikoke?” ");
INSERT INTO set_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Nda yo yae wainye, “Kaisarle be yoi bele me nou bele.” Nebeisa Yesus yae weumi, “Kaisar naei kayeero Kaisarre yeungele, Allah naei kayeero Allahre yeungele.” ");
INSERT INTO set_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nebei a mekai borowatene nebei yo fa yae bowate, Yesusre nanene nukainyeboke ewate. ");
INSERT INTO set_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nebei ya mbai Saduki holona riya mbai Yesusle bokore mekate. Naei u benera nekewaimi herewate yo benen ainyui sului, nebeinye Yesusre hinainye, ");
INSERT INTO set_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Guru, Musa keleumikoke ro mbai miyae rowende nekeneikonde fa ban mae herende, nukeungeboke miyaenale naka baeke yae rowende, naekale oro mere holensindere. ");
INSERT INTO set_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Maei nolona ako nake mbainya kelu mehine bee hele. Bena kiyae miyae rouke, fa ban mae hereke. Nebei miyaenale nauwake bee nendo yae rouke. ");
INSERT INTO set_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Naei mekai mbai bee nendo fa ban mae hereke. Name nendo nebei sului mbai eke ro mehine bee yae rouke na fa ban mo nekeikoke hereke. ");
INSERT INTO set_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Na moi sungkaya nebei miyae hereke. ");
INSERT INTO set_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nda ro mehine bee heraikoke nebei miyae bele nekaikokene, ro miyae herewate amminunde heene, ndele miyaere yembonde?” ");
INSERT INTO set_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesus yae weumi, “Mai u bene na ijen ban selebe nekayembe, rabuhine ban Allahle homofaena a ma haraungeboke bele Allah Naei elae wake bele mayae isaeyeiboinye. ");
INSERT INTO set_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ro miyae herewate yo anainyunde hee menjembondene ro miyae eyaroi, nane merau miyae maengke rone enekei. Nda yo malaikat surgana wanen na wali enaijembonde. ");
INSERT INTO set_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ro miyae heraibokera anainyunde naei, naendae wanen Allahle homofaene roko mbai Neyae mare ukembe a mayae homone okoikoi? Allahle homone nda mekai yae moloukoke, ");
INSERT INTO set_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Abraham mae, Isak yae, Yakob yae, Rare ei molaisele.’ Ro miyae herate yo Rare ei omoloikoi sului. Waline nekate ro miyae yae mo Rare ei moloyaisele. Nebei a keleumekoke herate yo benen walenaibonde.” ");
INSERT INTO set_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ro miyae helen Yesus yae elewole are borowate yo na mekai ma uwoumire ei sele molowainyele. ");
INSERT INTO set_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Farisi holona yo hebate borokate Yesus yae elele a yae mokoumikoke Saduki holona yo a mun faeu mun bewate. Nebei aerene Farisi holona yo riyane mewarileufike Yesusre umalire hubanainyehinderene a meraunge kolowainye. ");
INSERT INTO set_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Musale walora wali heere folaikokere isaeyeuboke ro mbai yae hineunge, ");
INSERT INTO set_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Guru, maere weimena Musale walora wali heere foloukoke einya honate a makei na berei selena kiyae?” ");
INSERT INTO set_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesus yae weunge, “Waei kena buhae u buhae Allahre no ban hee ban mae heungele, wa meli mekai yae nane merau wa u bene wa bene yae. ");
INSERT INTO set_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nebei niyae wali heere foloukoke a na bereinya kiyae. ");
INSERT INTO set_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Wali heere foloukoke bee nendo nebei sului mbai: Waei uware buhae haenae wanen mae ya-ya wali nibi mbainye oraube ro miyaere buhae heumiyende. ");
INSERT INTO set_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Musale walora wali heere foloukoke a yoni-yoni nane merau yenjo kayaayo yae kelewaimi a nanemene nda bee yae nore yeiboke.” ");
INSERT INTO set_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisi holona yo arilaisike namman hebate hee, Yesus yae hineumi, ");
INSERT INTO set_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mai u benera Wali Ondofolore naendae yae u bene nekayembe? Neyae ndele orona mena yae elaube?” Nda yo yae wainye, “Ondofolo Daudle orona mena.” ");
INSERT INTO set_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesus nda yore weumi, “Nebei mekai lonbe, naendae mekainye Daud yae Allahle Roh walora kelewoumi hee Wali Ondofolore naei Tuhan mae ro roungeboke. Daud nda a wanen mae eleukoke, ");
INSERT INTO set_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Allah yae raei Tuhande weunge, “Raei meube reufine nuweibo mende Waei yokeijo mokoremibonde waei oro keleene mo menayorulembonde.” ’ ");
INSERT INTO set_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Daud yae Nare naei Tuhan mae rowounge lonbe, na hului ban sele nare benen naei orona mena yae wennelere!” ");
INSERT INTO set_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Hi yae ha yae benen are wennelere na hului ban hubawainye. Nane merau nebei yara are hinenainyehindere fe yae faewate. Nebei yo oro halunde owoyoi sului. ");
INSERT INTO set_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nebei ro miyae helen bele, na moisa orowate yo belere Yesus yae weumi, ");
INSERT INTO set_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi holona yo bele Farisi holona bele Musale a faeu kayaare hebate. ");
INSERT INTO set_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nebeinye naeinya a usaei wasaei kelenayembe hakombe, nebeibe naei u mekai wa mekai mokatere mayae ehakoijae hele. Rabuhine ban neyae kelaeimi huluinye na u mekai wa mekai eharaiboi omokoi sele. ");
INSERT INTO set_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Neyae wali hee emere ro miyaere waimi hakonatere, rambun ehekaei wanen mae. Nebeibe nda wali heere emere mokaiboke kelaeime yo nebei a huluinye neyae ehakoiboi. ");
INSERT INTO set_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Naei meli mekai nanemene ro miyae yae erenaimile naei mobe haraiboyainye imokowate. U mehauwae na baka ranne Allahle homofaena a mbemba moloikoyate hokou kaei-kaei einye haweikoyate, nane merau na malo ene burai koko mokoikoyate. ");
INSERT INTO set_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kena hele eikowate raman bulaunge ro bele anuwaunge roiboyate nane merau Allahre ei mom-mom imaene bene hele roiboyate. ");
INSERT INTO set_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nda yo nai hei-sei anuwaunge be hinenaimilere nane merau ro bele erenaimilere ‘Agama naei Guru’ yae kaenenaimilere kena hele ikowate. ");
INSERT INTO set_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Nebeibe mare agama naei Guru yae kaenenayembe naeise kena okoyeijae hele. Rabuhine ban mai Tuhan mbai mo Allah Niyae nane merau mayae nanemene aka mbai baeke mbai wanen yaeuboke. ");
INSERT INTO set_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nane merau nda kanine waei ako hele ban hire ako yae ekaneyeijae, rabuhine ban mai Ako mbai sele surgana nekele. ");
INSERT INTO set_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","A usaeise kelaeimi ro yae ro ronayete naeise kena okoyeijae, rabuhine ban mare a usaeise kelembe ro mbai sele, Reyae Wali Ondofolo Niyae. ");
INSERT INTO set_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mai nolone nde ro ronainyebondena, neyae yebaei bubaeise yembonde hele. ");
INSERT INTO set_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nde yae nauware bumane engkaendena, Allah yae nebei kiyaere ane enneransinde. Nane merau nde yae nauwa ane enneransindena, Allah yae nebei kiyaere bumane ennekaembonde. ");
INSERT INTO set_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Mayae Musale walora wali heere foloukoke are isaeyaeukoke kelaeumi holona bele Farisi holona bele, mayae faeu kai bee holona nekaube yo. Raei me kelee u keleene nekate yo holo naei eise eke romau mayae ahaeube. Mayae eyeiboise kena okoinye, enayembondere relaeinye yore ahaeumi. Mayae na beko hele hubannembe! ");
INSERT INTO set_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Mayae Musale walora wali heere foloukoke are isaeyaeukoke kelaeumi holona bele Farisi holona bele, mayae faeu kai bee holona nekaube yo. Miyae nannalere ame-ame yae wabaumi naei imae obe yaraube maise baete. Mai beko mokaubere ro miyae isaeinyaibonde belene, Allahre ebeli akoisi yae akoisiyaunge ibowaunge. Nebei aerene Allah yae ehee bukulu ehekaei sele mai uwane enensayembe. Mayae na beko hele hubannembe! ");
INSERT INTO set_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Mayae Musale walora wali heere foloukoke are isaeyaeukoke kelaeumi holona bele Farisi holona bele, mayae faeu kai bee holona nekaube yo. Ro miyae mbaise mokonnebombe Musale walora wali heere foloukoke hakonnele naeise mayae naubu walaubu ahau fele eyewaube, kani yoni-yoni eyerekoyaube. Nebei wali nibi hakonnelena, narakare embe. Mayae na hele narakare aube, nebei sului mbai nda ro narakare ende hele. Mayae na beko hele hubannembe! ");
INSERT INTO set_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Mayae Musale walora wali heere foloukoke isaeyaeukoke kelaeumi holona bele Farisi holona bele yo, mayae ijoko erei be yun be yebaere hebaube. Mayae nda mekai yae waumi, ‘Nde yae Allahre ei mom-mom imae na kaban sele hebele randa a holo kondena, nebei a elae ban. Nebeibe Allahle imaena emas randa a holo kondena, nebei a elaekei yembonde.’ ");
INSERT INTO set_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nebei emas Allah naei. Mayae kobu yae felembokembe nane merau ijoko ereiboi kaube ro miyae. Nebei emas bele imae bele Allah Naei me einye honete. Nebei bee naei elae mbai, Allahle rambunbe yaeibokene. ");
INSERT INTO set_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Naei mekai mbai waumi, ‘Nde yae Allahle imaena hili era akau era ongkou felate itukai randa a holo kondena, nebei a elae ban. Nebei itukai ranna rambun nebei randa a holo kondena, nebei a elaekei yembonde.’ ");
INSERT INTO set_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mayae na hele ro miyae ijoko ereiboi sele kaube. Nebei itukai bele nebei itukai randa rambun bele Allahle me einye honete, naei elae mbai roukete. ");
INSERT INTO set_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nebei mekainye, nde yae hili era akau era ongkou felate itukai randa a holo kondena, nebei sului mbai nebei itukai ranne kolaikoke rambun randa a holo konde. ");
INSERT INTO set_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nane merau nde yae Allahre ei mom-mom imae na kaban sele kiyae randa a holo kondena, nebei sului mbai Allah neinye nekele kiyaele randa a holo konde. ");
INSERT INTO set_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nde yae surga randa a holo kondena, nane merau Allahle kendan wameranda a holo konde, na mekai nebei kiyae Allahle randa a holo konde. Mayae na beko hele hubannembe! ");
INSERT INTO set_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Mayae Musale walora wali heere foloukoke are isaeyaeukoke kelaeumi holona bele Farisi holona yo bele, mayae faeu kai bee holona nekaube yo. Mai hekena ani hili era akau era fololo bele selasih, adas yu bele, jintan bele me bee kayeero Allahre mbai yeyaunge. Nebeibe wali heere folaikoke nda niyae: wali ame-ame ban, yanekoi yase, mai a eleukoke huluinye mokole, na bereinya kiyae mayae omokoyei. Na foi sele nebei u mekai nemene mokombe. ");
INSERT INTO set_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mayae be yun be yebae ijoko erei wanen nekaube. Rabuhine ban mayae wali heere foloukoke na berei ban kiyae kelaeumi, nebei na bereinya Kiyae ehakoiboi. Nebei wanen mbai anensimbe bu einya baendo kaei-kaeise mayae moise yaraube hayaube, nebeibe unta kaban anensimbe bu einyare mayae moise ehayei. Mayae na beko hele hubannembe! ");
INSERT INTO set_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Mayae Musale walora wali heere foloukoke are isaeyaeuboke kelaeumi holona bele Farisi holona bele, ma faeu kai bee holona nekaube. Mai wali kolaei bele hote bele a yae ahunerebondere. Nebei kolaei bele hote belere moise reufi hiyei sele ramboyaube eyerewate, nebeibe eise reufi niki hele. Rabuhine ban mai wali u mekai nda ma niki bele: rambun hiwa yo naei hangko ma haweyaube nane merau mai bekore kena haehae koyaubere hakoyaube mokoyaube. ");
INSERT INTO set_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mayae Farisi holona ijoko erei wanen. Eise reufi bere kuyengko yolo-yolo yaeibo, nebei mekai yaere moise reufi yolo-yolo inyaibonde. Mayae na beko hele hubannembe! ");
INSERT INTO set_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Mayae Musale walora wali heere foloukoke are isaeyaeuboke kelaeumi holona bele Farisi holona bele, ma faeu kai bee holona nekaube yo. Mai u mekai bulei auma mokoiboyate anuwau au keleumon mae oleikoyainye hiyei ramboyate wanen. Nebei anuwau moisa ijokore maeikoi ma, nebeibe neinye bae ro miyae herewate bo yae maemae koukoke kelen baeii aufike. ");
INSERT INTO set_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mayae naei mekai sele. Ro miyae moisa erayembe bae wali himalaungeboke, nebeibe mayae wali faeu kai bee bele u hila wa hila bele mokaube. Mayae na beko hele hubannembe! ");
INSERT INTO set_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Mayae Musale walora wali heere foloukoke are isaeyaeuboke kelaeumi holona bele Farisi holona bele, ma faeu kai bee holona nekaube yo. Allahle yenjo kayaayo wali himalainyeboke yo naei bulei foi ainyainyu koyaumi nane merau hiyei raneyaumi. ");
INSERT INTO set_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mayae elaube, ‘Maei yobe naei kamahe naei bere nekewate maengkele nebei hee nekande yae Allah Naei yenjo kayaayo howatere meyae nebei yo naei moisa ehakoikoi sele.’ ");
INSERT INTO set_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nebei yo mai yobe naei kamahe naei yae elaubene, mai euwara menai wo kaube mayae Allah Naei yenjo kayaayore howate yo naei orona mena yaeuboke. Mayae na beko hele hubannembe! ");
INSERT INTO set_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ninae lonbe, abu naei yae arai naei yae huba rawaiboke u mekai beko mokowate mayae mokonemembe mende Allah a elengkonde, ‘Hennu!’ Mai naeise na beko hele yembombe naeibe mokaube. ");
INSERT INTO set_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Mayae beko bako bele holona. Rami ehekaei ro miyaere beko mokoyaimi wanen mae mayae ro miyaere beko mokaumi. Mayae narakana ehee bukulu mokoungehakera mauwa holere omoloiboi sului. ");
INSERT INTO set_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Foi yae boron, Reyae yenjo kayaayo bele isaei hebaen bele ma yae uwa harainyeboke yo bele Allahle a faeufe kelaeimi yo bele ufemile mai bokore menate. Nane helen nen mayae hongkombe, hiwa ohaline bongkombe, na hiwa mai ei mom-mom imaene rahuae bombe, hiwa mayae hawensambe yo ran yo randa habelenayende. ");
INSERT INTO set_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Na bena hele, mai yobe naei kamahe naeite wali himaloungeboke ro mbai na ro Habel haiboke. Nebei heera neyae roko helen wali himalainyeboke yo hiwa maisokoke. Meke Berekiale fa Zakharialene mayae Allahre ei mom-mom imae na kaban sele anuwaunge bele hili era akau era ongkou felate itukai bele kaikainye hauboke. Mai yobe naei kamahe naeite wanen mbai mayae wali himalainyeboke ro miyaere hoimeyaube. Nebei aerene hoi-soi howate yo naei ehee bukulu mare enenjembe. ");
INSERT INTO set_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nana heselebe wamale, nda u mekai mokaibokere nanemene nda kulunna yo yae ehee bukulu engkaembombe. ");
INSERT INTO set_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Mai Yerusalem yona ro miyae, wa yore yande Allah yae ukeumi mewate yenjo kayaayo hiwa houmekaube, hiwa ruka yae hayeumimekaube heraimeke. Ojo nafe na kelu ware na noro keleene arileumi wanen mae Raei kena roweisiyeufe ndane nekate ro miyae arilewamalebe, nebeibe mayae ahi hele elewaube. ");
INSERT INTO set_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Erembe! Mai nekaube yo na imae obe ennukembombe aku ban nau ban enaisononde. ");
INSERT INTO set_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Reyae mare wamale, Nda heera mayae benen Rare ereiboi nekemembe, ende nda a wanen Raei naeise emelengkombe, ‘Tuhan, Allahle ro yae mele Kiyaere, na rei mai yae ei hawenne.’ ” ");
INSERT INTO set_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nebeisa Allahre ei mom-mom imae na kaban sele kiyaera Yesus eukuke aloungekoke. Ewole hee, na moisa orowate yo mekate Allahre ei mom-mom imae na kaban sele kiyae reufira reufira kelaeinye. ");
INSERT INTO set_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesus yae nda yore weumi, “Mayae nebei ainyunuke nanemene eraube? Reyae na helebe wamale, Nebei imaere ainyunuke ruka nemene fomene kelanaikonde.” ");
INSERT INTO set_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nebeisa Zaitun mokone ikate Yesus angken nuweuboke nekewole hee, na moisa orowate yo na mo-mo nekewate yae are hinenainyehinderene Yesusle bokore mekate mo hinainye, “Maere yakaimebone, nda a eleyae makei hee yae nanemene enaibende enaiyakande? Rahe iwau wae Waei mele naei ya bele nda kani kela huba mokoungele naei ya bele yen kolonde?” ");
INSERT INTO set_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesus yae weumi, “Ro miyae yae mare ame-ame wabenayengkombe bele kayaa foi yae hebembe. ");
INSERT INTO set_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Rabuhine ban ro miyae helen Raei ro yae kelenayembe ungayembe, ‘Reyae Wali Ondofolo niyae’. Nebei u mekai yae ro miyae helen ame-ame wabenaimile. ");
INSERT INTO set_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Buloo fela kulun relennele nane merau fela oinyaibonde relenainyele a yo-yo mayae emborombe, nebeibe uwa mekai bele nekembe, isasa alalobe okoijae. Rabuhine ban nda a wamale nanemene enaijembonde, nebeibe huba mokoikoi ya namman. ");
INSERT INTO set_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Yo hi yo hi bele kani hi kani hi bele fela oinyaibonde releneinyele, anuwau helen moni mai nende konate, oinyeu hinenate. ");
INSERT INTO set_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nebei benate rambun huba mokoikoi ya naei hengkelenbe raufike baete, miyae fa honoise hiyau buhae bere releunge wanen. ");
INSERT INTO set_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Raei moisa hakaufekoke aerene nda kani kelana ro miyae helen sele ikele konayembe. Nebei hee mare ikilenayembe, weitasi konayembe, nane merau honayembe. ");
INSERT INTO set_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nebei hee Rare hila rabo halaeise ro miyae helen bena wali niki belere bukenaibonde, hi yae hire kelai nenende, nane merau hi yae hire ikele konnele. ");
INSERT INTO set_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Yenjo kayaayo na hele ban helen sele menaiyakande ro miyae helen wabenaimile. ");
INSERT INTO set_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","U mekai wa mekai beko fendulun nelau ranna wanen mae yakanatene nebei aerene ro miyae naeise naeise yanekoi yase u inyaibonde. ");
INSERT INTO set_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nebeibe ro miyae naendae wanen horo wali beko hubanainyele Raei a elalere hila rabo halenayende, nebei ya huba enainyemokondena, na wali Reyae hole eremimolombonde. ");
INSERT INTO set_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nane merau Raei me kelee u keleene nekenate yo holone ro miyae na hului enayembonde, wali hena bona yaronaikonde naei a foi faeu foi nda kani kelana ro miyae boronaibonde naeise, enaisuwengkonde huba enainyemokongkondera, nebeisa wa huba mokoikoi ya menyakambonde. ");
INSERT INTO set_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Yendo kayaalo Daniel are eleukoke huluinye ro mbai Yesus a elelere mehauwae kelande horonde kiyae menyakambonde. Nda ro Allahle ro be ro yoinye na beko hele nane merau Allahre ei mom-mom imae na kaban sele kiyaene u mekai u nenere koi-koi ma mokongkonde. Nebei ro Allah heere neufake anuwaunge mensebenunde. Nde yae nda homo kongkondena, nda rambun erengkondena foi yae nou hennebonde. ");
INSERT INTO set_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Nebei hee Yudea kanina ro miyae uwa hole moloiboise elure u hale me hale yae habelemembe. ");
INSERT INTO set_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Holokare okoi ma imae bumana ro miyae rambun imae einya roweise oijae. ");
INSERT INTO set_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Hekere embe ro miyae malo roweise imaere ebukei eijae. ");
INSERT INTO set_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nebei ya emale miyae holona bele wayeu miyae holona bele uwa hole moloiboise na beko hele enainyehubande, rabuhine ban ehabelei suluinye. ");
INSERT INTO set_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mai uwa hole moloiboise habelemembe ya naei ebeli ennebombe hin manse meinyele hee bele Sabat ya bele ebeijae hele. ");
INSERT INTO set_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Rabuhine ban nebei hee ro miyae beko hele hubanainyele, nebei wanen roko mbai eyeiboi mo nda kani kela mokoubokera meke nda heene nane merau benen nebei wanen eibei. ");
INSERT INTO set_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Allah yae nebei ya wanen fofo eimokoiboinya, walire nekande yo wali hole omoloiboi sului. Nebeibe Allah yae eleukoke holona ro miyae aerene nebei ya fofo mokonnebonde. ");
INSERT INTO set_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Nebei hee ro miyae hi yae mare ungembe, ‘Erembo, Wali Ondofolo ndine Nare yakauboke, ndane Nare yakauboke.’ Ro miyae nebei ma elenatere na hele yae eleijae. ");
INSERT INTO set_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Rabuhine ban wali ondofolo na hele ban bele yenjo kayaayo na hele ban bele helen menaiyakande. Iwau mahi-mahi, rambun emere-emere nda yo mokonate, na huluinya Allah yae eleukoke holona ro miyaere mokonaimibonde naei nibi bekone enaisakongkonde. ");
INSERT INTO set_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nebeinye u bene nekenayembe, nebei ma eyeiboi yae na bere wanen mae mare nda naeise Reyae isaeyaemale. ");
INSERT INTO set_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Mare ro miyae yae ungayembe, ‘Eren, Wali Ondofolo ndi a kala-kalane eke nekele.’ Mayae nebeise eijae hele. Nane merau ungayembe, ‘Ndi yowa einye eke nekele.’ Nebei are na hele yae eleijae. ");
INSERT INTO set_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Rabuhine ban Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae, Raei merele ya wili enaa reufira wele na hehe ifale reufine bele ole naeikoyole wanen mae yembonde. ");
INSERT INTO set_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Makeinye ro miyae na u mekai beko nekatene here no kaka honole ijen wanen yembonde. Allah nebei ro miyaere emmihubayengkonde, here nore anate aye hubayeikoyate wanen. ");
INSERT INTO set_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","‘Reyae na bere huwekokamale ro miyae beko hele hubanaimile ya baensondera, Hu hehe wende ouben yembonde, oko na hehe kebengkonde, findelau yoni-yoni yakuna balenate onate, yakune hebate yoni-yoni kusenate.’ ");
INSERT INTO set_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae benen merele hee yae, yakura Raei iwau yakambondera nda kani kela nanemene naei ro miyae ele kali rime ayan buyan konate. Rare erenaisele elae wake bele nane merau one hengko bele yae uwa kitensebonde yakuna mangko randa merele. ");
INSERT INTO set_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Raei malaikat yoni-yoni ufemile amin rannaibonde. Nebei malaikat yoni-yoni nda kani kela na huba kelina Allahle holone me baeuboke yore arilenaimile, huba hira ende huba hine. ");
INSERT INTO set_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ara none ahuneubokale ane mo hamennele. Hebate onsi fawate maensa rimi-rimi baete hee Israel kanine mayae isaeyeiboyaube yakama nobeungeboke. ");
INSERT INTO set_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nebei sului mbai are wamale, kun waunge iwau emere-emere enaibende nanemene mayae emerembena, isaeyembombe. Reyae benen merele ya nobeungeboke, nebei wanen mbai ro romau bena meke hebele na heki ban imae eise enensinde. ");
INSERT INTO set_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Reyae mare wamale, nana hesele nda holona yo nanemene ehereiboi yae nda wamale enaiyembonde. ");
INSERT INTO set_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yaku bele nda kani kela bele nundenaibonde, nebeibe Raei ako faeuko mbai sambai enundeiboi. ");
INSERT INTO set_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Raei merele ya na hu hului bele hi yae ha yae naeisaei ban mo, malaikat surgane nekate nane merau Reyae Na Kelu isian, Maeko Allah mbai naeisaei nekele. ");
INSERT INTO set_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae merele ya na mekai na bere hele Nuh nekewole heena wanen. ");
INSERT INTO set_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Bu kabande ufewole ya namman mae, ro miyae bulau kaban mokayeke anayeke nane merau ro miyae yarowate, maengke rore ewate. Nebei mekai kaimeke Nuh kai kaban mokouboke einye eweufike. ");
INSERT INTO set_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nebei heena ro miyae yembonde rambun na isian mae nekewate, meke bu yae ufeukoke nanemene riyau weumiboke. Naei mekai mbai Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae merele yane benate. ");
INSERT INTO set_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nebei hee ro bee hekene eneimokonde, hire rowende, hire nukennebonde. ");
INSERT INTO set_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Miyae bee gandumne ruka yae yalenete, hire rowende, hire nukennebonde. ");
INSERT INTO set_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Nebeinye kayaa hebembe, rabuhine ban mai Tuhan mende ya mayae isianne. ");
INSERT INTO set_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nda niyae bene nekenayembe, imae rowa yoko rorele huae mende hee isaeyeiboyolene, kayaa hebende hele, naei imaena rambun yoko yo yae eyaroikoi sului. ");
INSERT INTO set_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nebeinye mayae uwa mokoisa-mokoisa yae nekembe, rabuhine ban Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae mayae isian nekembe ya yae merele.” ");
INSERT INTO set_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Benen Yesus a ahuneuboke weumi, “Yebaei bubaei na ijenne nekeyele, isaei hebaen bele ma yae uwa haraungeboke kiyae, na rowa yae yunde kaeuboke nekewole, nebei imae einya kalia mokate ro miyaere raman na huluinye yemmile anenatere naeise. ");
INSERT INTO set_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nebei imaena rowa bensonde mende hee, nebei yebaei bubaei nebei rowa naei ukeunge kaliane mokonde yae hubainyeikonde ro onomi foka hubannele. ");
INSERT INTO set_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Reyae wamale, nana hesele na rowa nda yebaei bubaei ranenjende na imae einya rambun nemene me mokoise yembonde. ");
INSERT INTO set_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Nebeibe na hului nda yebaei bubaei na u mekai bekona nda wanen mae na kenara elende, ‘Raei rowa wabengkonde mende lonbe, naei a ukeufe moi ufoyonde.’ ");
INSERT INTO set_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Nebeinye na yebaei bubaei hiwa yore rahuae eyole meyole olemmile, raman bulau keu bure anate yo bele anenate konate. ");
INSERT INTO set_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Na rowa mende ya huluise nebei yebaei bubaei u benere enekeise ya yae mende. ");
INSERT INTO set_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nebei yebaei bubaei na rowa yae rahuae bongkonde hombonde, nane merau nebei ro mokonnebonde ro miyaere faeu kai bee holona yo bele nangkele enainyekende. Naei nekenate anuwaunge beko hubanainyelene rime, heraa kili-kili enaikonde.” ");
INSERT INTO set_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","((Na bera Yahudi era henara reniai nolone ro miyae rowende hee yae neraman bulau mokowate. Nebei ro neme emei mone, raman bulau omokoi. Mende mo neraman bulau mokonate.)) Yesus benen a ahuneuboke weumi, “Reyae benen merele hee, Raei me kelee u keleene nekate yo holone enayembonde nibi nda ahuba merau yembonde. “Roko mbai reniai nolone ro neme emei mone, maengke me bee na kaijeu yaraikoke yae raman bulau imae eise anainyebondere ekaitakewainyele. ");
INSERT INTO set_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Maengke me bee nebei nolona maehae mbai kobu, maehae mbai isaei hebaen bele ma yae uwa harainyeboke. ");
INSERT INTO set_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Kobu yo na kaijeu yaraikoke nebeibe na minyak hama ban ekate. ");
INSERT INTO set_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Isaei hebaen bele ma yae uwa harainyeboke maengke maehae mbai kaijeune minyak rilaikoke hiwa minyakre rilate anuwaunge rowayeke. ");
INSERT INTO set_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nebei rore heki hele rakewainyene, nanemene ijongku kowatene relaeiboke honowate. ");
INSERT INTO set_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Reniai nolo borate ro miyae kaenate, ‘Ma ro rakaunge mele ya. Men, ei menneambo!’ ");
INSERT INTO set_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Nebei maengke me bee ainyuke, na kaijeu relaeikoke. ");
INSERT INTO set_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nebei kobu maehae mbai yae isaei hebaen bele ma yae uwa harainyeboke maehae mbaise waimi, ‘Maei kaijeu kebenaikondere nobaeinyekokene, mainya roweimeyaube minyak ebimbin maei kaijeunge rilemmeko.’ ");
INSERT INTO set_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Nebeibe isaei hebaen bele ma yae uwa harainyeboke maengke maehae mbai yae waimi, ‘Mangkele wahemakondena, maei minyak baemmihonde. Naei foi sele minyakre haete anuwaufe embe, mai naeise yarongkombe.’ ");
INSERT INTO set_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Nebeibe minyak yaroikoise ewate hee yae nane ro rakewainye kiyae meke, mokainyehake maengke bele miyae neme ro neme raman bulau mokainyehake anuwau imaene ayeuboke, na romau bele na hibi ahunaiboke. ");
INSERT INTO set_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Nebeisa maengke kobu yo mekate. Nda yo kaenate, ‘Rowa, rowa, maere romau raweimobo!’ ");
INSERT INTO set_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Nebeibe nda rowa eisa weumi, ‘Nana hesele reyae mare onaemale.’ ” ");
INSERT INTO set_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Nebeisa Yesus nda ahuba mekai ahuneuboke huba mokounge wa elele, “Reyae benen merele hu hului mayae isianne, nebeinye kayaa bele hebembe.” ");
INSERT INTO set_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Raei me kelee u keleene nekate yo holo naeise nda wanen mae ahuba ahundebondere. Ro mbai yo moise kolore endere, na yebaei bubaei kaeneumikoke eba he honowainyelere me nulaiboke mo waheumikoke. ");
INSERT INTO set_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","((Nebei kanine roi kaban Yunani afaeunge talenta yae elate.)) Bena ro kaeneungekokere talenta maehae mbai kinyeungeboke, hire bee, hire mbai kinyeungeboke. Nebei yebaei bubaei naei meli mekai huluinye yeumikokera, kulun uke ewole. ");
INSERT INTO set_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Na hibi hele talenta maehae mbai yaroukoke kiyae eke na isaei hebaen bele yae mokowole benen talenta maehae mbai baraungeboke. ");
INSERT INTO set_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Beere yaroukoke kiyae nebei sului mbai mokoungeboke benen bee baraungeboke. ");
INSERT INTO set_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nebeibe mbaise roke kiyae eke na rowa yae ikeunge talenta kanine moloufake honowole. ");
INSERT INTO set_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Heki hele nekaikoke mo, nda rowa yo moinye eke nekewolera bukeufike meke. Na yebaei bubaei kaeneumikoke yeumikoke talenta huluise kolonainyekondere. ");
INSERT INTO set_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Na yebaei bubaei talenta maehae mbaise yeungekoke kiyae na mene talenta maehae mbai baraungeboke bele yaroukoke meke. Na roware weunge, ‘Weyae maehae mbai yeufekokae. Erei, reyae raei wakena yae maehae mbai baraungebokale.’ ");
INSERT INTO set_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Na rowa yae weunge, ‘Nda u mekai foi selebe mokoubokae! Weyae raei yebaei bubaei u mekai na foi sele nane merau raei are hakoyae. Rambun kaei-kaeise na mekai yae mokoubokaene, reyae rambun kaban mae kinyereibotere. Eyeisi, raei rei mai kale nolone wangkele eiko eisukele!’ ");
INSERT INTO set_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Nebeisa talenta beere yeungekoke kiyae meke na roware weunge, ‘Talenta bee hele rare yeufekoke. Erei, benen bee hele raei wakena yae baraungebokale.’ ");
INSERT INTO set_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Na rowa yae weunge, ‘Nda u mekai foi selebe mokoubokae. Weyae raei yebaei bubaei u mekai na foi sele nane merau raei are hakoyae. Rambun kaei-kaeise na mekai yae mokoubokaene, reyae rambun kabande kinyereibotere. Eyeisi, raei rei mai kale nolone wangkele eiko eisukele!’ ");
INSERT INTO set_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Nebeisa talenta mbaise ikeunge kiyae meke na roware weunge, ‘Rowa, raeisaei sele weyae ro nansau, omokoi anuwaube anire mo eisokoyae, eheraeyeiboi anuwaunge anire mo eyarileyae. ");
INSERT INTO set_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Reyae buhae yae hokowoufene, waeinya talenta mbai ikarae rokale ekale kani einye aubokale. Rowa, nda niyae nane talenta mbai rowei.’ ");
INSERT INTO set_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Nebeinye na rowa yae weunge, ‘Weyae raei yebaei bubaei u mekai beko nane merau yambi horo. Weyae isaeyeubokae hele omokoi anuwaunga anire mo hokoyale, eheraeyei anuwaunga anire mo arileyale. ");
INSERT INTO set_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Nebei mekai isaeyeubokene, naeinya hesele nebei talenta roise hawate anuwaunge eyabomae ya? Nebei mekai yaere reyae behole merele nda ikawale hi bele yae baranebomae!’ ");
INSERT INTO set_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“ ‘Nebeinye nda talenta ikanale naeisa rowembe, talenta me beere yeuboke kiyaere yennele. ");
INSERT INTO set_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Rabuhine ban honnainyele ro miyaere benen inyainyele. Helen bolen bele na naeinye honnainyele. Nebeibe ohonoi ro miyae naeise, honainyele ebi ken bele naeisa yaronaikonde. ");
INSERT INTO set_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nda yebaei bubaei me ban u ban kiyae, moinya ouben kika nolone ennekansi. Ndine rime a nane merau heraa kili-kili engkonde.’ ((Nebei ahuba walora Yesus kelewoumi Allah yae yeyeumi rambun mayae foi yae mokombe.)) ");
INSERT INTO set_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae hehe naensekonde yae malaikat yoni-yoni bele nanembaisa memale hee, Reyae Allah kiteufeboke one hengko bele kendan wameranne erenuwembonde. ");
INSERT INTO set_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nda kani kelana ro miyae nanemene Raei kendan wameran bene arilenaimihinde. Nebeisa Reyae ro miyaere me mokorele riya beere yembonde, domba bele kambing bele kayeero kayee moloumi wanen. ");
INSERT INTO set_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Reyae waherekonde domba holona yo meube reufine ufemile hebenate, kambing holona yo meli reufire yae ufemile hebenate. ");
INSERT INTO set_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Nebeisa Reyae Ondofolo Kiyae Ra meube reufina yore ufemile, ‘Maeko yae foi yoni-yoni ei haweimeyembe holona, men! Nda kani kela mokouboke heera, mai naeise yo waku mbai mokoungehakene emembo. ");
INSERT INTO set_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Rabuhine ban Reyae moni kowale hee, mayae raman ikaufele aneukokale. Reyae bukine kowalene, mayae bu ikaufele aneufikale. Reyae yo moisa mekalene imae ban obe ban kowale, mai imaene honowale. ");
INSERT INTO set_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Reyae melan nekewale, mayae malo ikaufele. Reyae erane buloone kowale, mayae ei hauwaufele. Reyae kawane hebewale, mayae Raei ereiboise ekaube.’ ");
INSERT INTO set_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Wali himalainyeboke ro miyae yae hinenaisele, ‘Tuhan, makei hee yae erewayete monine kowoyae meyae raman ikayete aneukokae, bukine kowoyae meyae bu ikayete, ");
INSERT INTO set_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Weyae imae ban obe banne maei imaene honowoyae, Weyae melanne meyae malo ikayete, ");
INSERT INTO set_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Weyae erane buloone meyae ei hauwayete, Weyae kawane hebewoyae meyae Waei ereiboise ekande?’ ");
INSERT INTO set_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Reyae Ondofolo Kiyae nda yore ufemile, ‘Reyae nana heselebe mare wamale, Rare hila rabore halaeise holona ro miyae me baei ban sele nekende kiyaere foi mokaungebokena, nebei foi mayae Rare mokaufeboke.’ ");
INSERT INTO set_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Nebeisa Reyae meli reufina yore ufemile, ‘Olomore nembokembe ro miyae, walobo yun na malaikat yoni-yoni belere mokainyehake na hibi mo i benende anuwaunge emembo. ");
INSERT INTO set_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Rabuhine ban Reyae monine kowale mayae raman eyei angkoi, Reyae bukine kowale mayae bu eyei, ");
INSERT INTO set_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Reyae imae ban obe ban mayae imaere ewei ei, Reyae melan nekewale mayae malo eyei, eranne buloone kowale mayae ei aiboi, kawane hebewale mayae Rare ereiboise emei.’ ");
INSERT INTO set_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Nda yo yae ungaisele, ‘Tuhan, makei hee yae Weyae monine kowoyae, bukine kowoyae, imae ban obe ban, melan, erane buloone kawane hebewoyae, meyae ei ehawei?’ ");
INSERT INTO set_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Reyae ufemile, ‘Reyae nana heselebe mare wamale, Rare hila rabore halaeise holona ro miyae me baei ban sele nekende kiyae mayae nare foi omokoiboinya, mayae Rare foi omokoi.’ ");
INSERT INTO set_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Nda yo ehee bukulu hubanainyendere ele kali no ban hee ban anuwaunge enayembonde. Nebeibe ro miyae wali himalainyeboke holona wali hena bona nekenayende.” ");
INSERT INTO set_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","A usaei waeisaei nanemene Yesus riyau weungeboke mo, na moisa orowate yore weumi, ");
INSERT INTO set_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mayae maeisaei, ya bee nekemakondera ((Mesir kanine Allah yae Yahudi naei bena kelu fa-fare hole molouboke u bene nekeisi-nekeisi)) ya kaban Paskah konate, Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae Yahudi ban ro miyae naei me einye kinyenaisebonde nebeisa ohaline bonaisekonde.” ");
INSERT INTO set_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nebei hee imam yun-jun bele Yahudi yun-jun bele Kayafas imam kabande nekewole kiyaele imaene arilewounge. ");
INSERT INTO set_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yesusre na maleu-maleu wae ikilenaibonde, nebeisa honaibonde meraunge nda yo kolowainye, ");
INSERT INTO set_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","nenaei mo elate, “Paskah ya kabanne komale hee omokoijae rabuhine ban, nda ro miyae Paskahre hokommende nolone aku naube yembonde bele.” ");
INSERT INTO set_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Simon u bauwaufe koukoke kiyaele imae Betania yone Yesus eke. ");
INSERT INTO set_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yesus ramanne anewole hee, maengke mbai na mene ruka pualam kolaei einye bu fololo bele roi bumana hele yae rouke bele meweufike. Nebei minyak fololo mo Yesus na yun ranne rileungeboke. ");
INSERT INTO set_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yesus na moisa orowate yo nebei mekai erekatene ikele kate na a bele elate, “Rabuhire eyeiboi rambunde nendon meke heraeyele! ");
INSERT INTO set_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nebei bu fololo mo naise haeiboube yae na roi bumana hele roweube. Nebei roi na hului hun ban wai ban yore wahaeimikoube.” ");
INSERT INTO set_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Nebeibe Yesus nebei yo naei u benere nekaimi ma isaeyeubokene weumi, “Rahene nda maengkere kena beko mokaunge? Naei u mekai mokoufeboke Reyae be hinanale. ");
INSERT INTO set_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Rabuhine ban hun ban wai ban yo mai nolone nekenayende, nebeibe Reyae maengkele nanembainye heki enekeyei. ");
INSERT INTO set_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nda bu fololo bele Raei uwa ranne rileufe, Rare molonaisehande naeibe nda maengke relahi yae Raei uwane mokoufe. ");
INSERT INTO set_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Reyae na helebe mare wamale, Nda kani kaban kela ban einye, Raei a foi faeu foi hungayende ijenne, nda maengke yae mokouboke u mekai bene nekei-nekeise elenayende hungayende.” ");
INSERT INTO set_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nebeisa Yesus na moisa orowate ro me bee oro nen bee bele nolora ro mbai na ro Yudas Iskariot imam yun-jun bokore eke, ");
INSERT INTO set_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","weumi, “Yesus mai mene kinyerembombena, mayae rahe yae rare yensele?” Imam yun-jun roi kaban me baeikoke 30 perak hele, nebei roi kaban roukate Yudasre ikainyele. ");
INSERT INTO set_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nebei heera Yudas kelai ruke mokowole Yesusre kinyemmibondere naei ya mon foinye baewole. ");
INSERT INTO set_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Paskah ya mbai nendo feu ragi ban anate bulau ya kaban heuboke mo, Yesus na moisa orowate yo mekate Yesusre hinainye, “Makeinye Weyae kena koyae Waei naei kayee Paskah raman bulau mokomansande?” ");
INSERT INTO set_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesus yae weumi, “Yerusalem yo einya ro mbai ekenekele bokore eme. Nda mekai yae wennele, ‘Guru yae ukeume, Rare honaisebonde ya nobeungeboke. Waei imaene Reyae kena kale Paskah ya kaban Raei moisa orate yo bele nanembainye mokomabondere.’ ” ");
INSERT INTO set_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Yesus ukeumi hului yae na moisa orowate yo mokaiboke. Ekate Paskah ya kaban naei rambun nanemene mokainyehake. ");
INSERT INTO set_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Huae yeuboke yae Yesus na moisa orowate ro me bee oro nen bee bele nanembainye raiboke raman anewate. ");
INSERT INTO set_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ramanne anewate wa Yesus yae weumi, “Reyae mare wamale, nana hesele ro mbai mai nolona Rare honaisebonde naei kelai ruke.” ");
INSERT INTO set_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nebei a wanen borokatene na moisa orowate yo kena beko hele hubawainye naeise naeise Yesusre hinainye, “Tuhan, reyae ban era?” ");
INSERT INTO set_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesus yae weumi, “Raei kelaise neke ro nda kolaei eise me nanembainye nono kakonde kiyae niyae. ");
INSERT INTO set_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae Allahle homofaene molaikoke huluinye hererele. Nebeibe Raei kelaise neke ro na beko hele hubannele. Nebei ro naei foi sele nda kani kelane ohonoi yaebe hongkate.” ");
INSERT INTO set_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yudas kelaise neke mokombonde kiyae Yesusre hineunge, “Guru, reyae ban era?” Yesus yae weunge, “Na hele, weyae nare eleyae.” ");
INSERT INTO set_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ramanne anewate hee Yesus feu rouke, helen foise mo Allahre ukeungera, nebei feu me yae kaiwole na moisa orowate yore wahewoumi na a bele weumi, “Yaron, anen, nda Raei uwa melen.” ");
INSERT INTO set_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nebeisa bu kolaeinya rouke, Allahre helen foise mo ukeunge, nebeisa ikeumi na a bele weumi, “Nda kolaeinya bu mayae nanemene anensimbe. ");
INSERT INTO set_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Rabuhine ban nda Raei uwa na ha. Nda ha yaere Allah a heteungekoke nibi neme ro miyaere wali himalainyeboke yo yae me baemmile a elaekei yeuboke. Ro miyae helen naei beko faeinyeremibonde naeise nda ha yae rilerebonde. ");
INSERT INTO set_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Reyae mare wamale, Nda heera benen anggur bu aneisi mo nekerende, mende Maeko mokommibonde ro miyae Raei me kelee u keleene orulenaibonde nekenate. Benen nebei ro miyae Rangkele nanembainye anggur bu anemahinde.” ");
INSERT INTO set_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ei mom-mom koi bae molainyekokera Yesus na moisa orowate yo bele alainyekoke Zaitun mokore ewate. ");
INSERT INTO set_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nebei mokone Yesus na moisa orowate yore weumi, “Na mana huae hele mayae nanemene Rare nukensebombe ma fere-fere habelemembe. Allahle homofaene mai naeise Allah yae domba wanen ahuneuboke. Nda a mekai homone molaikokene, ‘Reyae domba be neiboi ro horobondera, na domba na fere-fere here ware wembonde.’ ");
INSERT INTO set_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nebeibe Reyae nulu yo mahe yora arenundera, bere holo yae Galilea kanine erendakembe.” ");
INSERT INTO set_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petrus yae weunge, “Hiwa yo nanemene ware nukenayeibote na fere habelenayende, reyae Ware enukeiboi sele.” ");
INSERT INTO set_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesus yae weunge, “Petrus, Reyae ware wawale, nana hesele nda reniai ojo a okoikoi mo, weyae roko name hele Rare onaerae yae weumikonde.” ");
INSERT INTO set_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petrus yae weunge, “Naendae mekai horo Wangkele nanembainye haimekoube horore bae, reyae Ware onaewale a eleikoi sele.” Nebei a hului mbai na moisa orowate yo nanemene elewate. ");
INSERT INTO set_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesus na moisa orowate yo bele nanembaisa ewate, anuwau mbai na ro Getsemani nebeinye aibaleke. Nebeisa weumi, “Reyae ndire ebeli boikoise erelerene, mayae ndane mo nekembe.” ");
INSERT INTO set_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Petrus nane merau Zebedeusle kelu wa bee bele yaweumiboke nanembaisa ekate. Yesus kena beko hele hubaungene, Nauwa oinyeu wanen hineuboke kowole. ");
INSERT INTO set_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Hokolo namere weumi, “Ra kena beko hererele wanen mae hubanale. Ndane nekembe, Raei naeise Allahre ebeli bonnele.” ");
INSERT INTO set_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yesus ahau folore yae eungakeleufike mo, be are neke Naekore ebeline bowounge, “Arai, na huluinya nda ehee bukulu Reyae kaerebondere Weyae weungende. Nebeibe Raei kenare kale hului yae ebeijae, naeinya hele Waei kenare mokoungehakae hului yae ninae yeubo.” ");
INSERT INTO set_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nebeisa Yesus beufoke hokolo name bokore meke, nebeibe nda name ijongkune relaeiboke. Petrusre weunge, “Hukai mbai sului mayae name ijoko elae yae ebeli oboi hangka? ");
INSERT INTO set_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ijoko elae yae hebembe nane merau ebeli bonnele mai kena bekore haehae koyaube hakombe belene. Mayae kena koyaube Allah Naei a elelere hakombere nebeibe na hului ban, rabuhine ban nda uwa yambine.” ");
INSERT INTO set_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesus roko bee nendo eke, bowounge, “Nda ehee bukulu Reyae kaerebondere mokoungehakaena Ako Waei kenare koyae hului yae yembonde.” ");
INSERT INTO set_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yesus beufoke meke, ereumi hokolo name na ijoko ehekaei sele hubainyene, ijongkune rilekate faukate honate. ");
INSERT INTO set_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yesus are ewei, ijongkune waeumihike honowate. Yesus roko name nendo eke roko beena a hului yae Naekore ebeli boungehike. ");
INSERT INTO set_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nebeisa Yesus hokolo name ijongkune honowate bokore meke mo weumi, “Mayae namman ijongkune honaube nane merau namman none yaeube. Eren, Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae u mekai bekore mokate ro miyae naei me einye kinyenaisebonde heebe na hului yeuboke. ");
INSERT INTO set_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Annu, men, eyae ema. Raei kelaise neke kiyae meke!” ");
INSERT INTO set_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesus namman ane weumi hee, na moisa orowate me bee oro nen bee bele holona ro na ro Yudas meke. Imam yun-jun bele Yahudi kose yo bele ukaimile ro miyae holo kaban, hiwa na mene ramiyaeli hiwa o bohi-bohi bele nanembaise mewate. ");
INSERT INTO set_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yesusre kelaeise neke ro yae a bere nda yore ukeumi, “Reyae yoi bulure hunerensinde ro, nebei kiyae niyae mayae ikilembombe.” ");
INSERT INTO set_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nebei anuwaunge ekate bele, Yudas na hibi Yesusle bokore eke ro melaeyeungeboke weunge, “Guru, Wauwa bele.” Nebeisa yoi bulu hineungekoke. ");
INSERT INTO set_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesus yae weunge, “Aka baeke, mokoibone, waei haraungebokae mekae ma.” Nebei yo na hibi mekate Yesusre ikilaiboke. ");
INSERT INTO set_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nebeibe Yesus na moisa orowate holona ro mbai na ramiyaelire mo yobouboke imam kabanbe yebaei bubaei na angkaeibe neufake ruke. ");
INSERT INTO set_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesus yae weunge, “Na honoi-sonoi anuwaunge waei ramiyaeli neinye, rabuhine ban nde yae ro miyaere ramiyaeli yae hombondena, ramiyaeli yae enaisombonde. ");
INSERT INTO set_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Weyae waeisaei ban selene, Reyae na hului Maekore riyerensinde. Neyae Naei malaikat na helen 72.000 hului aei kayaare weumile mate. ");
INSERT INTO set_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Allahle homofaene nulainyekoke rambun na hului sului benaterene nebei malaikat yoni-yoni emei nekate.” ");
INSERT INTO set_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ro miyae helen mekate yore Yesus yae weumi, “Mai u benera Rare yokolo yae elaubene era, Raei ikileiboise ramiyaeli yae o bohi-bohi yae yaraukoke mekaube? Reyae na yane baei Allahre ei mom-mom imae na kaban sele kiyae na imaehounge nuweuboyale keleyamaelebe mayae Rare ikileiboi. ");
INSERT INTO set_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nebeibe nda mekai baete rambun nanemene yenjo kayaayo naei homofae einye molaikokere na hului yembonde.” Nebeisa na moisa orowate yo Yesusre nanene nukainyeboke na fere-fere habeleyeke. ");
INSERT INTO set_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yesusre ikilaiboke, na hibi hele yawainyehoke Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi holona bele Yahudi yoyo koseyo bele imam kaban Kayafasle imaene arileufike nekewate bokore yae ewate. ");
INSERT INTO set_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Yesusre yawainyehoke ewate moisa Petrus na ahau folo yae hakoumiboke imam kaban imaehounge ayeuboke. Petrus kena hele kowole Yesus yawainyehoke ate na huba enainyemokongkonde are isaeyembonderene imam kaban imaehoufe nangkele eweufike. Eke kayaayo bokone eunguweuboke nekewate. ");
INSERT INTO set_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Yesusre honaibonde naei are ruwendere, imam yun-jun bele Kayafasle imaene arileufike, hiwa yo bele elae hele relewainye ehee bukulu wonnonde na hele ban are elengkonde ro miyae ei bae mei bae baewate. ");
INSERT INTO set_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nebeibe nda yo ehee bukulure ungainyonde are helen ame-ame elewatebe, a mbai foi yae oyoloiboi mo. Nebeisa ro bee bene yeisebeuboke. ");
INSERT INTO set_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Hokolo bee yae elete, “Nda ro yae uwoumi, Reyae na hului Allahle imae kalarebonde, nebeisa ya name mo na hului benen arenunde.” ");
INSERT INTO set_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Imam kaban aunguke mo Yesusre weunge, “Nda a Waei uware ehee bukulure hayaeyetere boroukokae. Weyae wo okoi mo nekeyae?” ");
INSERT INTO set_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nebeibe Yesus a elei mo hebewole. Nebeinye imam kaban mae Yesusre weunge, “Allah Walilole bene wawale maere weimena, Weyae Wali Ondofolo, Allahle Kelu Niyae?” ");
INSERT INTO set_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesus yae weunge, “Wenaeijae warae, na hele Reyae Wali Ondofolo. Reyae na hele wawale, nda heera Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae Allah Elaelo Wakelo Na meube reufine nuwerebonde, nane merau yaku bumara mangko randa merele mayae erensele.” ");
INSERT INTO set_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nebei mekai boroukene imam kaban ikele hele kowolene, na malo yobouboke kaneukoke weumi, “Neyae Allahle mbainye yae eleukokene, aukakabe Allahre kounge! Are elenaikonde yo benen ebaeijae! Allahre aukaka kounge a mayae nanemene borokaube. ");
INSERT INTO set_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mayae naendae yae elaube?” Nda yo yae wainye, “Neyae a bekobe eleukokene herende hele!” ");
INSERT INTO set_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nda yo Yesus na be yoi euwaeki yae howainye me rulu yae rorowainye. Hiwa yo me fae yae rahuae yae bowate, ");
INSERT INTO set_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","nda wanen wainye, “Maere weimena, Wali Ondofolo, nde yae ware rahuae bote?” ");
INSERT INTO set_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petrus namman imaehounge nekewole hee, yebaei bubaei holona maengke mbai meke Petrusre weunge, “Weyae na hi niyaebe ya, Yesus Galilea kanina ro bele nanembainye orowaube.” ");
INSERT INTO set_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nebeibe Petrus oneunge a ma ro miyae bene weumi, “Waeinya a haraungeboke eleyaere, reyae onaele hele.” ");
INSERT INTO set_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Petrus nebei imaehou romau bere eke mo, maengke hi yae erekeungene, nebeinya hebate yore weumi, “Nda ro Yesus Nazaret yona ro bele nanembaisa orayeke.” ");
INSERT INTO set_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petrus nda kulunne oneunge are a holo yae koukoke eleukoke, “Reyae onaenale elale!” ");
INSERT INTO set_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Na heki ban mo nebeinye hebate ro miyae Petrusle bokore mekate wainye, “Waei a faeu eleyaene mo meyae rayeubokete, weyae na hele Na ro hi niyae.” ");
INSERT INTO set_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Petrus a olomo rorole elae yae weumi, “Reyae nebei ro onaenale hele yae wamale.” Nebei hee yae ojo mukuu a koukoke! ");
INSERT INTO set_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Yesus yae ukeunge abe Petrus bene nekeungehike. Ojo a okoikoi mo Rare onaerae a roko name eleukonde. Petrus nebei anuwaufa na kena beko hele yae eukuke, rime kali ayan buyan koweke. ");
INSERT INTO set_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Rene ya eiwo meiwo kowole hee imam yun-jun bele Yahudi yoyo kose yo bele nanemene arilaisike Yesusre honaibonde naei a hokaikoke. ");
INSERT INTO set_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Yesus na me ha wowo kainyekoke yawainyehoke nebei yo yande ikileuboke mokowole Gubernur Pilatus naei me einye kinyenainyebondere ewate. ");
INSERT INTO set_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kelaise neke kinyeumiboke Yudas, Yesus honaibonde naei a ruke boroke hee mehi hele folowole, na mena 30 perak hele ((roi kaban)) imam yun-jun bele Yahudi yoyo kose yo belere eke bukeumihike, ");
INSERT INTO set_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","elele, “Reyae beko helebe mokoubokale. Beko ban ro kelai nekale enaisombondere kinyaimiboke.” Nebeibe nebei yo yae wainye, “Maengkele elemakonde a ban, wenaeijae mo eleukonde.” ");
INSERT INTO set_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yudas nebei roi na ikele u yae Allahre ei mom-mom imae na kaban sele eise hekeleukoke ekate. Nebeisa eke nauwa nenaeijae hane heuboke hereke. ");
INSERT INTO set_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Imam yun-jun nebei roi roukatera elate, “Hilira akaura hawande anuwaunge nda roi aiboi sului. Rabuhine ban nda kelaise neke roi ro ha bele.” ");
INSERT INTO set_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nda yo a hului kolainyekokera nebei roi yae ebere helaise mokole ro naei kanibe roukate. Nebei kani yo moinya ro miyae herenatere molonatere roukate. ");
INSERT INTO set_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nebei kani meke mana yane “ha bele kani” yae royainye. ");
INSERT INTO set_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nebei wanen mae yenjo kayaayo Yeremia Yesusle naeise a eleukoke na hului yembonde. Naei a nda mekai moloukoke, “Israel kanina ro miyae are hokaikoke, Naei uware roi 30 perak hele yae mokonaibonde. ");
INSERT INTO set_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Allah yae ukeufe huluinye nebei roi yae ebere helaise mokole ro naei kanire roukate.” ");
INSERT INTO set_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Nebeisa Yesus yawainyehoke nebei yo yande ikileuboke Gubernur Pilatusle bere ekate. Gubernur Pilatus yae hineunge, “Weyae na hele Yahudi naei Ondofolo?” Yesus yae weunge, “Na hele, wenaeijae nare eleukokae.” ");
INSERT INTO set_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Imam yun-jun bele Yahudi yoyo koseyo bele ehee bukulure ungainyonde naei a hirewainyere, Yesus a mun faeu mun hebewole. ");
INSERT INTO set_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nebeinye Pilatus yae weunge, “Ndi yo yae ehee bukulure ungayewote a einyo meinyo kayete Weyae oboroiboi sele?” ");
INSERT INTO set_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yesus a mbai sambai eleikoi mo hebewolene, Pilatus fa yae bowole. ");
INSERT INTO set_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nebei hee Paskah feu ragi ban anate ya kaban na rokone baei kayekene, kawane hebate yo ro miyae helen mae kena koikoyate kiyaere Gubernur yae hayeikoyeunge. ");
INSERT INTO set_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nebei hee kawane ro mbai hebewole na ro Barabas. Na me hila u hila koweke ro bele rainyeke. ");
INSERT INTO set_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nebei rene ro miyae helen Pilatus yae nekewole anuwaunge arileufike hee, nda yore Pilatus weumi, “Mai naeise ndere mayae kena kaube reyae haisengkondere, Barabasre, Yesus Wali Ondofolo wainye kiyaere?” ");
INSERT INTO set_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatus naeisaei sele yeuboke, Yesusre ro miyae helen sele kena kowainyene, Yahudi yun-jun kena hensen kowate ikilaiboke Pilatusre kinyainyeboke. ");
INSERT INTO set_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilatus are kolainye imaene eunguweuboke hee, na miyae nda abe ukeumi ekate, “Nebei ro wali himaloungeboke Kiyaele a wangkele ehakoi eleijae. Rabuhine ban nebei Kiyaele aerene mana reniai imene beko hele hubaimeyanale.” ");
INSERT INTO set_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pilatusre rinyainyehinde Barabas hainyainyekonde Yesus honaibonde naeise imam yun-jun bele Yahudi yoyo koseyo bele ro miyae helende a moi bele hurewaimi. ");
INSERT INTO set_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilatus yae hineumi, “Mai kenara nda ro bee hebete eraumira ndere reyae haisengkondere kena kaube?” Nda yo yae wainye, “Barabas!” ");
INSERT INTO set_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatus yae weumi, “Nebei mekainya reyae rahe yae Yesus Wali Ondofolo yae rainye Kiyaere mokorembonde?” Nda yo nanemene hele kaenate, “Nare ohaline bonaikonde hele!” ");
INSERT INTO set_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Gubernur Pilatus yae nda yore weumi, “Rahe beko mokoubokene?” Nebei a wanen ukeumine nda yo kali ara nene kaenate, “Nare ohaline na bonaikonde hele!” ");
INSERT INTO set_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatus hubaunge nda nibi baele na hului ban nane merau nebei ro miyae huba rawaiboke aku nau hate. Nebeinye Pilatus bu reukoke ro miyae helen bene na me kuyeukokera mo weumi, “Nda Kiyae herende ha rangkele ban, nebei menaeijae mo elengkombe.” ");
INSERT INTO set_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nebei ro miyae helen mae Gubernur Pilatusre wainye, “Maere waeimihi homabonde. Naei ehee bukulu, meyae, nane merau maei kelu omi bele kaemabonde!” ");
INSERT INTO set_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nebeisa Pilatus nda yo yae riyewate huluinye Barabas hayeungekoke, ro miyaere ukeumi Yesusre rahuae yae bowate. Nebeisa ohaline enaibongkondere felayo naei me einye kinyeumiboke. ");
INSERT INTO set_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Gubernur Pilatusle felayo Yesusre yawainyehoke Gubernur naei obene ekate, na felayo homo kaban kaeneumikoke Yesusle bokone arileufike. ");
INSERT INTO set_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Yesus na malo kulainyekoke, malo fi kole ma yae hirainyekoke. ");
INSERT INTO set_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Nda yo isa bele hun yaraikoke, nebei kanina ondofolo hiraikoke wanen fokomare mo hainyekoke, na yunne obunainyeboke. Na mene meube reufine ondofolo naei mehukun ikainyele, nda felayo na bene oro selen-selen roraikoke aukaka yae Yesusre kowainye, “Wauwa bele Yahudi naei Ondofolo!” ");
INSERT INTO set_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Euwaeki howainye, na mena mehukun nukaisake rahuaere na yunda roko yae roko yae bowate. ");
INSERT INTO set_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Aukaka kainyekokera, nebei malo hirainyekokere mo kainyekoke, Yesus Naei malo yae benen hirainyekoke. Nebeisa nda felayo Yesus ohaline enaibongkondere yawainyehoke aibaleke ewate. ");
INSERT INTO set_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Yerusalem yora aibaleke nibi nolone ewate yae, Afrika robon reufina yo mbai Kirenena ro mbai na ro Simon hubayaeikoke bae Yesusre bonaikonde ohalire kaembondere waeli hele bewainye. ");
INSERT INTO set_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Anuwau mbai na ro Golgota, na mekai yun bo anuwau. ");
INSERT INTO set_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Nebeinye ekate yae nda felayo anggur bu rambun faere bele uwa buhae fomambonde naeise Yesus anensindere ikainyele, nebeibe felaeyeufikera anensindere ahi yae elewole. ");
INSERT INTO set_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Yesus ohaline baikokera felayo na malore wahenaikondere oye yae nihaeiboke. ");
INSERT INTO set_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nda felayo nebeinye raiboke, kayaane hebewate. ");
INSERT INTO set_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Mere nokainyele homone molaikoke rouke na yun rande buma reufine ukate. Nebeinye molaikoke, ");
INSERT INTO set_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Yesus ohalire baikoke ijenne nanembainye yokore baeyeke ro bee bele meline meubene baikoke. ");
INSERT INTO set_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ro miyae ele melere nebeinye kowate yo Yesusre aukaka yae kowainyele, yun wewe kowate, ");
INSERT INTO set_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","wainye, “Weyae Niyae are elewoyae ‘Allahre ei mom-mom imae na kaban sele kiyaere kelarebonde na hului ya name mo arenundere.’ Weyae Allahle Keluna, Wauwa hole moloibo, nebei ohali randa oyakoibo.” ");
INSERT INTO set_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Imam yun-jun bele Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi yo bele Yahudi yoyo koseyo bele aukaka nebei sului mbai Yesusre kowainye, na a bele wainye, ");
INSERT INTO set_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ro miyae hiwa yore hole moloumiyeke, nebeibe Naei uware hole omoloiboi sului. Neyae Israel ro miyae naei Ondofolona, naei foi sele ohali randa onakombonde, nebeinye meyae hila rabo nare halemande. ");
INSERT INTO set_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Neyae na hila rabo Allahre haleungeke nane merau eleweke Niyae Allahle Kelu. Nebeinya nda hee Allah kena kolena hole molonnebonde.” ");
INSERT INTO set_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nebei sului mbai Yesus naei nanembainye ohaline baikoke hokolo bee bele aukakane Yesusre kowoinye. ");
INSERT INTO set_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nebei anuwau hukai me bee oro nen bee hului ouben yeuboke oke hukai name. ");
INSERT INTO set_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Huae rai hujoko name hului Yesus Aram afaeunge kali na a kaban mae kaenele, “Eli, Eli, lama sabaktani! Na mekai: Raei Allah, Raei Allah, rahene Rare nukeufebokae?” ");
INSERT INTO set_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nebeinye hebate yo borokatene elate, “Allahle yendo kayaalo Eliabe kaeneunge.” ");
INSERT INTO set_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ro mbai u hale me hale eke, hakalu foma-foma rouke, anggur manim bele bune yaweufike, one neke, kaeungeboke, Yesusre yennele anensindere. ");
INSERT INTO set_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Hiwa yo yae elate, “Ae, na foi sele ijoko yae mo ereman, Naei hole moloiboise Elia mende era.” ");
INSERT INTO set_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesus benen a kaban mae kali kaeneukoke, nebeisa na nore mo Allahre kinyeungeboke. ");
INSERT INTO set_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Allahre ei mom-mom imae na kaban sele kiyae naei yowa heere naisake malo kaban kayeukoke bumara oke ane, oinyeu hineuboke, ruka yoni-yoni kaiwate. ");
INSERT INTO set_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nane merau ruka bulei wewe molowate, Allah Naei eleuboke wekeumi ro miyae helen heraibokera ainyuke. ");
INSERT INTO set_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yesus aungukera nda holona yo ruka bulei eisa aibaleke. Nebeisa Yerusalem yore ayeuboke ro miyae helende uwa yakawaimi. ");
INSERT INTO set_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Fela yun na u keleene yo bele Yesusle kayaane hebewate oinyeu hineubokere nane merau nanemene yaeiboke rambun erewatene buhae hele hokoumiboke, elate, “Na hele nda Kiyae Allahle Kelu.” ");
INSERT INTO set_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nebeinye miyae maengke helen ahaufa hebaiboke erewate. Nda miyae maengke Galilea kanira Yesusre hakainyekoke eise hauwainye yo. ");
INSERT INTO set_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nebei miyae maengke nolona Maria Magdalena nangkele Maria Yakobusle Yusufle nenake, nane merau Zebedeus na miyae nangkele. ");
INSERT INTO set_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Yahudi kanina yo mbai Arimatea na ro mbai eba he bele ro na ro Yusuf. Nenaeijae Yesus na moisa orowate holone hakouboke. ");
INSERT INTO set_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Be bahewoke hee Yusuf yae Yesusle here no riyeisise Gubernur Pilatusle bokore eke. Nebeinye Gubernur Pilatus a ukeumi here no nare ikainyele. ");
INSERT INTO set_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusuf nebei here nore mo rouke malo lenan maye-mayene ruleufike. ");
INSERT INTO set_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nebeisa Yusuf naei ruka bulei neme waeiboke einye nekainyele, ruka kaban olaeinyekoke romau ahaeinyekokera, Yusuf bukeufike ewole. ");
INSERT INTO set_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Nebeibe Maria Magdalena nane merau Maria hi kayeero, hokolo bee ruka bulei bene roiboke nekewote. ");
INSERT INTO set_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ya heuboke mo, Paskah raman mokoisayainye ya baeufoke mo, imam yun-jun bele Farisi holona bele nanembaisa Pilatusle bokore ekate, ");
INSERT INTO set_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","wainye, “Rowa, meyae bene nekeumehike ndi ro hereke na waline nekewole hee ame-ame bewoumi eleweke, ‘Ya name mo Reyae arenunde’. ");
INSERT INTO set_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nebeinye weimi nebei ruka bulei bene kayaa enaisebende. Rabuhine ban ya name yembonde na moisa orowate yo yae here nobe yoko yae enaitowendebe, nulu yo mahe yore aunguke yae ro miyaere nendon wabenaimile bele. Nebei mekai yembondena, naei ame-ame bewoumi na beko helebe yembonde.” ");
INSERT INTO set_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Gubernur Pilatus yae weumi, “Mai kayaayo niyae, mayae wemmile ruka bulei kayaa foi sele yae enaisebende.” ");
INSERT INTO set_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nda yo ekate kayaayo yae hakaimiboke, romau ruka yae mokaibokene me nou herawaikoke. Nebei ruka bulei kayaa yae hebewate. ");
INSERT INTO set_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabat ya moi woke, nebei mon ya mbai nendo, ya eiwo meiwo kowole hee Maria Magdalena, Maria hi kiyae, ruka bulei ereiboise ewote. ");
INSERT INTO set_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Oinyeu kaban sele hineuboke rabuhine ban Allah Naei malaikat mbai yaku bumara oke, nebei bulei romau ahaeinyekoke ruka oleungekoke, na ranne nuweuboke nekewole. ");
INSERT INTO set_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Na be yoi wili hehe wanen, na malo keleumon hele salju wanen. ");
INSERT INTO set_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ruka bulei kayaane hebewate felayo buhae hokoumiboke, oro me bae hayaeiboke, ane balewate, here no wanen mae honowate. ");
INSERT INTO set_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nebei miyae beere malaikat yae weumi, “Mayae buhae ohokoijae! Reyae raeisaei Yesus ohaline baikoke Kiyaebe mayae baeimeyaunge. ");
INSERT INTO set_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nda anuwaunge ohonoi. Mare na bere a uwombe huluinye aunguke. Men, uware nekainyele honowole anuwau ijoko memerembo. ");
INSERT INTO set_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nda hee u hale yae embe, na moisa orowate yore wemmile, ‘Neyae nulu yo mahe yora aunguke, bere holo yae Galilea yore ende. Mayae nebeinye ennerembombe.’ Nda a Neyae ukeufebe reyae wamale.” ");
INSERT INTO set_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nebei miyae-miyae u hale me hale ruka bulei ijenda alainyekoke, fe waku kowate nebeibe nane merau rei mai hubawainye. Malaikat yae ukeumi are Yesus na moisa orowate yore ungaimilerene oro yae habeleyeke. ");
INSERT INTO set_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Nebeisa habeleyeke hee yae Yesus nda miyae bee bele huhu baikoke. Yesus yae ro melaeyeumiboke weumi, “Mai foi.” Nda miyae bee Yesus na bokore mekete, oro selen-selen roroikoke, norora aeinyefoke, ei molowoinye. ");
INSERT INTO set_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesus yae weumi, “Buhae ohokoijae ebe, Raei aka baeke ware a wemmile Galilea yore yae enate, ndine Rangkele emahubayengkonde.” ");
INSERT INTO set_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nebei miyae bee nibi nolone ewete hee, felayo ruka bulei kayaare hebewate yo keli name Yerusalem yore ewate. Ruka buleinye yeuboke are imam yun-junde isaeinyaimibondere ewate. ");
INSERT INTO set_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Imam yun-jun bele Yahudi yoyo koseyo bele riyane a elaikokene hokaikoke. Kayaare hebewate felayore roi yae inyaimikondere hokaikoke ");
INSERT INTO set_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","waimi, “Nda a mekai yae wemmile, ‘Reniai nolo ijongkune honowande hee yae Yesus na moisa orowate yo yae mekate, here no yoko yae elaisake. ");
INSERT INTO set_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nda a Gubernur Pilatus borombondena, mare beko omokoi naeise meyae a moi-moi yae mokomangkonde.’ ” ");
INSERT INTO set_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nebei felayo roise mo yaraikoke are heraewaimiboke hului yae ekayelewate. Nda a mekai Yahudi ro miyae nolone nda hee namman huweimeyate. ");
INSERT INTO set_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yesus ukeumi huluinye na moisa orowate ro me bee oro nen mbai bele Galilea na moko keleumibokere kulun ukate ewate. ");
INSERT INTO set_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ndine Yesusre erekainyele nda yo ei molowainye, nebeibe arilewounge nolona hiwa yo na kena wauwau hele kowate. ");
INSERT INTO set_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesus nda yo bokore meungakeleufike mo weumi, “Allah Naei elae wake nane merau nda kani kelana elae wake nanemene hele Raei me einye kinyeufeboke. ");
INSERT INTO set_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nebei aerene nda kani kelana yo yoni-yoni embe na hubane haeinye. Na ro miyae kelemmile Raei a elalere hakonayende nekenayende. Nane merau nda yore Maekole ro yae, Reyae Allahle Kelu ro yae, Allahle Roh ro yae bu kommile. ");
INSERT INTO set_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nane merau nebei yore, mare uwamale a hului kelemmile nebei sului yae mokonate. Reyae mare na hibi mo ei haufemembe ende nda kani kela huba mokorende yane.”");
INSERT INTO set_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Allahle Kelu Yesus, Wali Ondofolo Kiyae, Naei a foi faeu foi nda na huba raweiboi. ");
INSERT INTO set_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nendahina Allahle yendo kayaalo Yesaya homofaene moloukoke. ((Nebei homo einye Allah yae Wali Ondofolore Yohanes bure koumi kiyae naeise nda a moloukoke,)) “Nda Raei burelen boi-boi ro. Waei nibi mokoisaise nare bere holo yae ufende ende. ");
INSERT INTO set_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nebei burelen boi-boi ro a kala-kala anuwaufa ro miyaere nda a kaenemmile, ‘Aei Tuhan menderene wali nibi mokonnehambe! Ende nibi kalo-kalo ran-dan hiyei ranennebombe, yeli-yeli kayeero ijen alonnehambe!’ ” ");
INSERT INTO set_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Molaikoke huluinye Yohanesbe a kala-kalane yakauboke. Ro miyaere bune koumiyeke, nda ako faeuko uwoumi, “Mai me u beko mokaubera nei hungembe bukembombe mauwa yemmile bu konayembe. Nebeisa mai me u beko Allah faeinyenembombe.” ");
INSERT INTO set_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ro miyae helen Yudea kanina yo yan honatera Yerusalem yora Yohanesle bokore a kala-kala anuwaufe hokoumeke. Na me u bekore wo kaikoke yo, Yordan wine Yohanes bu kowoumi. ");
INSERT INTO set_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohanes na malo obo yoku unta naei ma, na yolu ha obo yoku rara, neraman kesengki bele akelana madu bele. ");
INSERT INTO set_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yohanes nda abe huwoumi, “Reyae mekale eraufe, nebeibe one bele hengko bele kiyae raei moisa mende. Naei oro mehau ha niheisi kulaiboise reyae na hului ban, rabuhine ban Naei bene reyae ro ban selene. ");
INSERT INTO set_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Reyae mare bu yae kamale, nda wanen mbai nebei Kiyae mende mare Allahle Roh yae haungembe.” ");
INSERT INTO set_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yohanes bu kowoumi hee yae, Yesus Nazaret yo Galilea kaninara meke. Yordan wine Yohanes Yesusre bu koungeboke. ");
INSERT INTO set_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nebei bura yeukiteke hee yae Yesus erele yaku wekeunge, aye merpati wanen mae Allahle Roh Yesus Na uwa rande oke. ");
INSERT INTO set_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Surgara a elele, “Weyae Raei kena buhaere haewale kelu. Rare kena foise mokarae.” ");
INSERT INTO set_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nebeisa yeubokera na hibi Allahle Roh yae Yesusre yaweungehoke a kala-kala anuwaufe ewole. ");
INSERT INTO set_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Neyae a kala-kalane ya rorele u bee nekeukoke mo Setan, walobo yun, umali hubawounge. Yesus obo yoku hangkei-hangkei nolone nekewole nane merau malaikat yae ei hauwainyele. ");
INSERT INTO set_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ya mbai mo Ondofolo Herodes ukeumile Yohanesre ikilenaibonde kawane ahenainyekondere. Na heki ban mo, Yesus Galilea kanire meke, Allahle a foi faeu foi nebeinye huwoumi. ");
INSERT INTO set_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Weumi, “Allah merau raungehike ya ninae nobeungeboke Naei holona ro miyae Reyae Wali Ondofolole me kelee u keleene menayorulembonde nekenate. Mai me u beko mokoyaubera nulu kenembombe bukembombe, nda a foi faeu foi na hele yae elembe.” ");
INSERT INTO set_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ya mbai mo, Galilea bukoba bu haei yau faeisa Yesus ele melene oroweke yae ro bee erekeumi Simon naka baeke Andreasle waunge haiwote naei kalia mokoyeke huluinye. ");
INSERT INTO set_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesus yae weumi, “Mebu, rare hakoisoko! Wau kare hayaeube wanen ro miyaere hayebobe ma mare kelerekobe.” ");
INSERT INTO set_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Na hibi hele na wau nukeiboke Yesusle moisa aloinyekoke. ");
INSERT INTO set_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ewate mo Yesus erewole Zebedeusle kelu wa bee Yakobusle Yohanesle kai einye waunge mokowote. ");
INSERT INTO set_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesus nda beere kaeneumikoke na hibi na moisa hakeinyekoke. Naeko Zebedeus bele na kalia yo bele kai einye nukeimiboke hakoinyekoke ewate. ");
INSERT INTO set_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesus na moisa orowate yo bele Kapernaum yone aibaleke. Sabat ya yae nebeinya Allahre ei mom-mom imaene Yesus eweufike huba raweuboke kelewoumi. ");
INSERT INTO set_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Yesus a elewolere borowainye yo yae fa yae bowate, rabuhine ban Neyae one bele hengko bele wanen mae kelewoumi Musale walora wali heere foloukoke isaeyaeiboke kelaeimi yo wanen ban. ");
INSERT INTO set_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nebei hee yae, ro mbai nebei nekatera alo yae aungeboke kiyae kali yae kaenele, ");
INSERT INTO set_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesus Nazaret yona ro, rahere weyae mekae? Bekore mokoumebondere? Reyae raeisaei weyae Allah yae eleubokete ukete mekae Kiyae.” ");
INSERT INTO set_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Nebei walobore Yesus yae oku nekeunge, “Hileibo! Nda ro uwa eisa eituwe!” ");
INSERT INTO set_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nebei walobo nda ro nauwa nekeunge oinyeu wae hineuboke. Nele bele yae kaenewole nauwa eisa eukuke. ");
INSERT INTO set_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ro miyae nemene fa bate wa elate, “Nda rahe a usaei emebe na elae helae bele keleumi. Walobo weumi na hului borainye nane merau hukeumi na hului baleyate.” ");
INSERT INTO set_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yesus nda ma mokouboke hasale hele a eungeyoboukoke, Galilea kanina yo honate boraiboke. ");
INSERT INTO set_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Allahre ei mom-mom imaera maibaleke Yesus yae Yakobus bele Yohanes bele yaweumiboke Simonbe Andreasle imaere ewate. ");
INSERT INTO set_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Yesusre isaeyaeinyeboke Simon na miyae nenake era manse-mansene kowole. ");
INSERT INTO set_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesus nda miyae honole anuwaufe eke na mera ikeleungeboke aungunuke, nane manse-manse kowole hireungeboke aunguke anenaikonde naei eramanne mokowole. ");
INSERT INTO set_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nebeise be bahewole yae, ro miyae erana buloona koyate yo nane merau walobo yae hawaimiyeke yo nemene Yesusle bokore yauwaimi mewate. ");
INSERT INTO set_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kapernaum na ro miyae nemene imae romau bene ele yae nainyeboke. ");
INSERT INTO set_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Era buloo mahi-mahi kowate yo helen Yesus onomi iwoumi. Walobo yae hawaimiyeke yo helen na walobo hukewoumi. Yesusre rainyebokene, nebei walobo are elenatere Yesus mon eyei. ");
INSERT INTO set_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Na rene kaukau fele Yesus aunguke, imaera eukuke, aku ban nau ban anuwaufe ewole. Nebeinye Allahre ebeli ekeubowounge. ");
INSERT INTO set_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon na kahili wa bele alainyekoke baeinyeke. ");
INSERT INTO set_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Hubayaeikoke mo Yesusre wainye, “Ro miyae nemene ware mo baeyete.” ");
INSERT INTO set_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesus yae weumi, “Men, ndi yo ran yo rande oromandere. Reyae ndi yo bele yae a foi faeu foi hufemikondere mekale.” ");
INSERT INTO set_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nebei aerene Yesus Galilea kanina yo honatere oroweke. Nebei yo yanna Allahre ei mom-mom imaene a usaei uwoumi nane merau walobo hukewoumi. ");
INSERT INTO set_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","U bauwaunge koweke ro Yesusle bokore meke oro selen-selen mae roroukoke hakonnebondere na hebaen-sebaen riyewounge weunge, “Weyae kena kolena, rare na hului onomi yeufele.” ");
INSERT INTO set_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesus Na kena beko bele hubaungene me nekeunge raungehike mo weunge, “Reyae kena kale, onomi yeubondere!” ");
INSERT INTO set_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Yesus are ukeunge hee yae na uwana u bauwau u yaeiboke onomi rouke. ");
INSERT INTO set_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ukeunge endere yae a hun raungehike weunge, ");
INSERT INTO set_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Bene nekenayete nda onomi ikawalere hi hire ehuweyeijae. Oro moloubonde imam hebele kiyae naei bere ele, onomi yeubokae naei uwa yakaungebonde. Musale walora wali heere foloukoke a huluinye Allahre hili era akau erare ongkou wae felennekonde naeise obo yoku mbai yeungele.” ");
INSERT INTO set_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nda ro Yesus yae ukeunge a huluinye ehakoiboi. Naei ewole ijenne huweumiyeke. Nebeinye Yesus yo hire na u yaka yae endere kabewounge, yo moinye aku ban nau ban anuwaunge nekewole. Nebeibe anuwau hira-hira ro miyae Nare hubainyaikondere hokoumeke. ");
INSERT INTO set_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Galilea kanira ya mbemba ayorokokera, Yesus Kapernaum yore bukeufike meke. Neyae imaere bukeufike meke a yoboungekoke. ");
INSERT INTO set_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ro miyae helen sele mekate nebei imae maemae koukoke, nane merau romau moinye ro miyae helen hebewate. Yesus nebei yore ahuba huwewoumi. ");
INSERT INTO set_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ro keli hele ro hi oro mere nimewainyebe na koinye kaeibokate mewate. ");
INSERT INTO set_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ro miyae helenne Yesusle bokore enatere kabewainye. Nebeinye imaena yan Yesus hebele anuwaunga mo wewe kaikoke. Nda ro na koi ranne nokainyele oke. ");
INSERT INTO set_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesus nda yo na hila rabo halewate erekeumine, orora nimainyekoke rore weunge, “Kelu, wa beko bako ninae faeinyeubokawale!” ");
INSERT INTO set_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi yo nebei anuwaunge nekewate nebei ara boroukate bae na u bene haeyaeinye wa elate, ");
INSERT INTO set_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Buhae hokoiboi ban nda a eleukoke, Allahre aukakabe kounge, Nauwa Allah lon mae eleukoke. Ro miyae naei beko faeinyeiboise ro hi miyae hi yae na hului ban! Allah Nenaeijaere na hului.” ");
INSERT INTO set_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Na kena eisa elate a Yesus na hibi isaeyeubokene weumi, “Mai kena u einye a na hele ban elaube! ");
INSERT INTO set_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Meyae elaube, ‘Na foma-foma hele Yesus nda rore weungele, Wa beko ninae faeinyeubokawale, rabuhine ban yembonde naeise ro miyae ereiboinye. Nebeibe ehekaei kiyaebe Yesus wennele, Ainyu, wa koi kaeibo eye, rabuhine ban ro miyae erenaterene.’ ");
INSERT INTO set_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Reyae kelerembombe na hele Reyae, Allahle bokora mekale ro miyae uware yeubokale Kiyae, na hului Allahle elae yae ro miyae naei beko faeinyeremikonde.” Nebeisa orore nimainyekoke kiyaere Yesus yae weunge, ");
INSERT INTO set_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ainyu, wa koi kaeibo, waei imaere aloinyoko eye!” ");
INSERT INTO set_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ro miyae nanemene erewainye hee yae nda ro aunguke, na koi kaeuboke, eukuke ewole. Erewainye yo fa yae bowate, Allahre buma kaewainye wa elewate, “Nda yeuboke ma roko mbai ereiboi mo!” ");
INSERT INTO set_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesus benen Galilea bukoba buhaeisa ewole. Ro miyae helen Yesusle bokore hokoumeke. Yesus huba raweuboke a usaei wasaei kelewoumi. ");
INSERT INTO set_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nebeisa fowole yae Alfeusle kelu Lewi pemerintah naei roise arilate imaene erekeunge nekewole. Yesus yae weunge, “Rare hakoisobo!” Lewi ewaunguke na moisa hakoungeboke ewate. ");
INSERT INTO set_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ya mbai mo, Yesus na moisa orate yo bele Lewile imaene eramanne anewate. Nebeinye pemerintah naei roise arilewate yo bele, Farisi yae u mekai beko bele yae me baeiboke yo, Yesusle holo bele anewate, rabuhine ban nebei ma ro miyae helen Yesusre hakowainyele. ");
INSERT INTO set_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Farisi Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi holona yo yae Yesus nebei yo bele eraimi eraman nanembainye anatene, Yesus na moisa orowate yore hinewaimi, “Yesus rahene pemerintah naei roise arilate yo bele nebei u mekai beko yo bele eraman nanembainye anate?” ");
INSERT INTO set_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesus nebei a waimi boroukokene weumi, “Erana buloona yo yae Dokterre baeyaimi, nebeibe onomi yo ebaei. Reyae ro miyae beko bele yore kaeneremiyendere mekale, nauware himalainyeboke eleyate yore ban.” ");
INSERT INTO set_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Roko mbai mo, Yohanes bure koumi kiyae na moisa orowate yo bele Farisi yo bele yarele me heiboyate nekewate. Ro miyae hiwa mekate Yesusre hinewainye, “Rahene nebei yo yarele me heiboyate mon nekatebe, nebeibe wa moisa orate yo enekei?” ");
INSERT INTO set_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesus yae weumi, “Ro mbai miyae rowele ya naka baeke rei mai ikowate, naei bokone inyekewate, raman yanewate. ");
INSERT INTO set_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Na ya bele mensembonde, nebei ro naei nolora roungate yae nebei hee yaere yarele me heiboyate nekenaikonde.” ");
INSERT INTO set_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yesus benende elele, “Na mekai ban sele malo male kayengkondere malo neme yae hakande ungatere, rabuhine ban hakande uke malo neme kingkondene nebei anuwau kaban sele kanengkonde. ");
INSERT INTO set_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nebei sului mbai, hokou male anggur bu bale-balere rilembonde mokonnele ohulendene kayengkonde, nebei bu rilenate. Nebei anggur bu bale-bale hokou nemene rilembe.” ");
INSERT INTO set_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabat ya mbai Yesus Na moisa orowate bele gandum heke nolora ewate. Norone ewate, gandum ani hokayeke anayeke. ");
INSERT INTO set_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Farisi holona yo yae erekaimile mo, Yesusre wainye, “Musale walora wali heere foloukoke a hului Sabat ya yae omokoi mabe rahene wa moisa orate yo mokate?” ");
INSERT INTO set_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesus yae weumi, “Ondofolo Daud naei monine nekewate heene mokouboke u mekai mayae homone okoikoi mo? ");
INSERT INTO set_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Imam Abyatarle heena, Musale walora wali heere foloukoke a huluinya Allahre feu hili era akau era ikainyele imam mae mo anenaikondere. Nebeibe Ondofolo Daud rouke hakainyekoke yo bele anaikoke.” ");
INSERT INTO set_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Benen weumi, “Sabat ya ro miyaere mokouboke ro miyae Sabat yare mokouboke ban. ");
INSERT INTO set_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nebeinye, Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae, Sabat ya naeise Reyae naei yun niyae.” ");
INSERT INTO set_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kapernaum yone nekewate hee yae Sabat ya mbai Allahre ei mom-mom imaere Yesus eweufike. Hokoumeke nolone ro mbai na me reufi kingkouboke nangkele meweufike. ");
INSERT INTO set_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ro miyae hiwa Yesusre kemere nenainyebonderene Nare ijoko raisike erewainye Sabat ya ndi rore onomi yei bele era. ");
INSERT INTO set_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesus yae nda rore weunge, “Nda ro miyae bene meisebeinyu!” ");
INSERT INTO set_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nebeinya yore Yesus hineumi, “Musale walora wali heere foloukoke a huluinye rahebe Sabat ya mokomale? Beko yae foi yae? Hole yae molomamile, hoi-soi yae homale?” Nebei yo a ban faeu ban mo nekewate. ");
INSERT INTO set_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Na yun elae katene Yesus kena bekore yeuboke. Na kena ikele yae a hire a hire ereukoke wa nda rore weunge, “Wa me neinye!” Na mena nekeunge bele na hibi onomi rouke. ");
INSERT INTO set_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Farisi holona Allahre ei mom-mom imaera aibaleke, ekate Yesusre honaibonde naei ane Ondofolo Herodesle holona yo bele ekayelewate. ");
INSERT INTO set_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Kapernaum yora Yesus na moisa orowate yo bele Galilea bukobare ewate. Yesus rambun emere-emere mokowole borowatene ro miyae helen bolen hakainyekoke. Galilea kanira, Yudea kanira, Yerusalem yora, Idumea kanira, Yordan wi enaa reufira, Tirus yo bele Sidon yo bele yo honatera hokoumeke. ");
INSERT INTO set_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ro miyae helen hokoumeke uwa yae ainyainyekonde belene, Yesus yae na moisa orowate yore ukeumi kaikai mbai mokonainyehande are huwemmilere. ");
INSERT INTO set_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yesus yae ro miyae helen onomi iwoumine, erana buloona yo Yesusle uwa bokore eikinye meikinye Naei uware me ferere ramenainyehindere relewainye. ");
INSERT INTO set_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ro uwa miyae uwana walobo Yesusre ereungene na bene meutuwele kali yae kaenele, “Weyae Allahle kelu!” ");
INSERT INTO set_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nebeibe Yesus nda walobo yoni-yonire oku yae rorowoumi, Nauwa naei are eyakai yae uwoumi. ");
INSERT INTO set_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesus elune ike yae kenare kowoumi yore mo kaeneumikoke mekate. ");
INSERT INTO set_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Yesus yae ro me bee oro nen bee bele eleukoke, abu ako yae roumiboke weumi, “Reyae mangkele oromalere nane merau ufembe Raei ako faeukobe huwembere mare elembokamale. ");
INSERT INTO set_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Walobore hukemmile naei elae arembombe.” ");
INSERT INTO set_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ro me bee oro nen bee bele eleukoke na ro nda niyae: Simon (Yesus Petrus yae roungeboke kiyae), ");
INSERT INTO set_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedeusle kelu wa Yakobus nauwake Yohanes (nda ro bee Yesus Boanerges yae roumikoke, na mekai kule kelu wa), ");
INSERT INTO set_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andreas, Filipus, Bartolomeus, Matius, Tomas, Alfeusle fa Yakobus, Tadeus, Simon Zelot holona fa, ");
INSERT INTO set_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yudas Iskariot, Yesusre kelaise mokouboke kiyae. ");
INSERT INTO set_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesus naei elura bukaiboke imaere mekate, ro miyae helen hokoumekene eramande anenaikondere kabewainyele hele. ");
INSERT INTO set_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yesus na aka baeke wa Yesusle a boraikokene mekate yaungainyehondere, rabuhine ban ro miyae naeisa borokate Yesus na u bene beko yeuboke. ");
INSERT INTO set_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yerusalem yora mekate Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi holona yo yae elate, “Beelzebul (walobo yun) Yesusre helaukeunge. Nebei walobo yun mae walobo hiware hukeumi.” ");
INSERT INTO set_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nda a mekai elaeikokene, Yesus nebeinya ro miyaere kaeneumikoke wa, a ahuneuboke weumi, “Walobo yun na walobo akobaere ehukeyei! ");
INSERT INTO set_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Yo yan mbai na ro miyae han soi-soi wanen nekenatena, nebei yo yan here ware wembonde. ");
INSERT INTO set_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Imae mbainya na ro miyae naeise naeise kena ikele nekenatena, nebei imaera here ware wembonde. ");
INSERT INTO set_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Naei mekai mbai Setan naei yo waku wahenaikonde nenaei mo relenainyelena, naendae wanen mae elae hebende? Naei yo waku here wembonde. ");
INSERT INTO set_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Elae ro wake ro ha ikileikoinya, naei imaene rambunde yoko yae yaroukondere na hului ban sele. Nebei ro rineungekonde helere na hului.” ");
INSERT INTO set_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Na helebe Reyae wamale, u hila wa hila mahi-mahi koyate yo bele ro miyaere aukaka koyaimile bele Allah na hului faeinyemmile. ");
INSERT INTO set_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nebeibe nde naei yae Allahle Rohre aukaka konainyelena, Allah nebei yore efaeinyeiboi mo huba ban haei ban nekenende.” ");
INSERT INTO set_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesus walobo yae helaukeunge elewatene, nebeinye nda a mekai yae ukeumi. ");
INSERT INTO set_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nebei imaene Yesus ane elewole hee, nenake nauwake wa bele mekate, imae moinye hebewate, ro hire ukainyele Yesusre kaenenengkondere. ");
INSERT INTO set_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ro miyae helen Yesusre yanainyekoke nekatera wainye, “Guru, ana, wauwake wa bele mekate wangkele hubayengkombere moinye nare ekaisebate.” ");
INSERT INTO set_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesus nebei yore hineumi, “Menake bele Raei aka baeke bele nde naei?” ");
INSERT INTO set_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Na bokone yanainyekoke ro miyae helende Yesus ereumi mo elele, “Raei menake raei aka baeke nda niyae! ");
INSERT INTO set_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ro miyae Allah kenare kole huluise mokonate nebei holona yo niyae Raei aka baeke wa remaen wa menake naei.” ");
INSERT INTO set_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Roko mbai Yesus Galilea bukoba bu haei yau faeinye a usaeinye huba raweuboke kelewoumi yae, ro miyae helen bolen hokoumeke ele yae nainyebokene. Nebeinya kai yate einye Yesus nuweuboke, nebei ro miyae buhaeinye hebewate. ");
INSERT INTO set_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nebeisa Yesus a usaei helen kelewoumi a ahumbo-ahumbo yae ahunewole nda wanen mae weumi, ");
INSERT INTO set_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Boron, heke rorele mbai o hakare heraeyendere eke. ");
INSERT INTO set_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Heraeyeweke bae hiwa nibi enene balekate, aye mekate anaikoke baeufoke. ");
INSERT INTO set_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Hiwa kani ruka bele ranne balekate kani helee-heleene, u hale hele yae kitewate. ");
INSERT INTO set_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nebeibe na kambu eise eleman oi, hu kiteke bae na reu habaiboke, kala-kala yaeiboke. ");
INSERT INTO set_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Hiwa yo isa bele hun nolone balekate. Na reu hun isa bele yae auwaimine anire omokoi sului. ");
INSERT INTO set_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Hiwa yo kani foinye balewate kitewate buyae-buyae kowate, kaban yaeiboke, ani faru raka yae raka yae hurewaimile, hiwa rorele u mbai me bee bele, hiwa rorele u name bele, hiwa rorele u maehae mbai bele ani-ani faru-farune mokowate.” ");
INSERT INTO set_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesus weumi, “Mayae angkaei boraube ro miyae nebei are nou hembo!” ");
INSERT INTO set_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Na mo-mo yae ekate nda a ahumboi yae ahunebokere na moisa orowate yo me bee oro nen bee bele yae hinainyehike. ");
INSERT INTO set_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesus yae weumi, “Mare Raei me kelee u keleene nekate ro miyae holona nunna honayeke rambunbe isaeyembokamale. Nebeibe, moise woke holonare a ahumboi yaere keleremile. ");
INSERT INTO set_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nebei nibi yae, nda a Allahle yendo kayaalo Yesaya homone moloukoke na hului yembonde, ‘Neyae ijoko yae erenayendebe nane merau angkaei yae boronayendebe, nebeibe u benene isaeyeiboi. Isaeinyaibondena, nulu kenaibonde naei wali ma bukenainyehinde era, nebeinya Allah naei me u bekore faeinyemmibonde.’ ” ");
INSERT INTO set_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Na moisa orowate yore Yesus yae weumi, “Nda a ahuneubokale wamale mayae onaeubena, na yaka yeuboke benen a hi ahunerebonde ufembe mayae isaeyeiboi sului. ");
INSERT INTO set_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nebei ahumbo-ahumbo ahunebokale na mekai nda niyae: Reyae are kelaemaele nebei heke rorele o hakare heraeyele kiyae. ");
INSERT INTO set_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Hiwa yo o haka nibi enene balekate wanen. Nebei ro miyae nda a borate yo, nebeibe na hibi hele Setan, walobo yun kiyae yae na kenara yaroikoyele. ");
INSERT INTO set_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Hiwa yo o haka ruka ranne balekate wanen. Nebei ro miyae nda a waimi boratera na rei mai yae rowate. ");
INSERT INTO set_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nebeibe nda a boraikoke aerene kena bekore mokoumi rambun hubanayendene bele weitasi kaimine bele nebei are na u hale hele nukeiboyainye, nebei ro miyae na kenane nda a kambu herawennele naei elae banne. ");
INSERT INTO set_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Hiwa yo o haka isa bele hun nolone balekate wanen. Nebei ro miyae nda are borate, ");
INSERT INTO set_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","nebeibe nda wali naeise buhae isokowoumi, rabuhine ban yeisi raeiboi walire nane merau rambun helende kena kaban ikowate. Nebei meraunge Raei ako faeuko naei kena une elae ban yeiboyatene ani omokoyei. ");
INSERT INTO set_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Hiwa yo o haka kani foinye balekate wanen. Nebei ro miyae nda are borate na wali nebei suluinye mokainye. Nebeinye ani faru raka yae raka yae imokowate, u mbai me bee bele, rorele u name bele, rorele u maehae mbai bele.” ");
INSERT INTO set_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Nebeisa weumi, “Rahe londe imae hehere naengkondere releikoyanae rambun helai yae obuneiboyate, koi kelene neyainye? Nebei mekai ban sele! Imae hehere naengkonderene naei anuwaunge raisiyate. ");
INSERT INTO set_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Allah merau raungehike nunna honate rambun nemene yakanaibonde, Naei a faeu u bene foi isaeinyaibonde. ");
INSERT INTO set_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nebeinye angkaei bele yo borombe!” ");
INSERT INTO set_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Nda wali einye, aei yeyanne hului mbai Allah yae aere yeyeume hiwa bele barammekonde. Nebei aerene, boraube a u bene yolo-yolo yae nekenayembe. ");
INSERT INTO set_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mai Allahle isaei hebaen mokombombena, Allah mare benen hi baranembombe. Allahle isaei hebaen bele kiyae helen barannele. U kiyae naeinya honainyele bele enjarongkonde.” ");
INSERT INTO set_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesus na hibi weumi, “Wali Ondofolole me kelee u keleene nekate holona ro miyae nda wanen ((kabani benate)). Heke ro mbai na hekene o haka heraeyeuboke. ");
INSERT INTO set_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Heraeyeubokera na yane baei huaera, raisa, ijongkune, annundene, o haka kiteyate, kaban yeiboyate. Kiteyate nibi ma nebei ro isian. ");
INSERT INTO set_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nda kani nenaei yae mokoungeboke ani bele bewole, reu neme fae nemera, maensara akaufa, mai ani bele ijakawate. ");
INSERT INTO set_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ani nime yeiboyele yae heke ro eifolole, rabuhine ban nime yaeibokene.” ");
INSERT INTO set_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesus benen weumi, “Sawi ko wanen Raei me kelee u keleene nekate holona ro miyae eyae na hului elemakonde nane merau ahumbo-ahumbo ahunemabonde. ");
INSERT INTO set_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nda kani kelana o reu ha reu ko bele sawi ko bele, sawi ko na ninokaei sele. ");
INSERT INTO set_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nebeibe, heraeiboyatera, kitele kaban bele bae, heke einye o reu ha reu hebatera niyae na kaban sele. Na maensa akau kaban sele. Nebei alinne aye nale meikolate.” ");
INSERT INTO set_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ro miyae naei isaeise nekate huluinye Yesus Naei ako faeuko nebei wanen a yae ahunewole uwoumi. ");
INSERT INTO set_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ro miyaere kelemmilere Yesus a yae ahuneboyele mo huweumi. Nebeibe na moisa orate yo bele na mo-mo einyekate yae a ahuneboyelebe nanemene yakaikoyeumile. ");
INSERT INTO set_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nebei ya hu holo ranne oke hee yae Yesus yae na moisa orowate yore weumi, “Men, eyae nda bukoba reufire fomalere.” ");
INSERT INTO set_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kai einye Yesus bere yawole. Na moisa orate yo hawaiboke mo naeisike. Nda ro miyae hokowole nanene nukaimiboke. Kai hiwa bele hakaikoke ewate. ");
INSERT INTO set_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Na heki ban mo alu elaekei sele raweuboke. Nebei aluna ruwae yae na kai fowatere hauwoumi omboi kai ei maemae kowole. ");
INSERT INTO set_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Alu raweuboke hee kai imolina Yesus ijongkune honowole. Na moisa orowate yo Yesusre yengkainye, wainye, “Guru, beko baende naeise Weyae nou ehei sele!” ");
INSERT INTO set_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesus aunguke, alu rawelere a elae yae haeungeboke, “Heinyu!” Na hibi alu heunguke nda bukoba kalauboke yawole. ");
INSERT INTO set_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesus na moisa orowate yore weumi, “Rahene mayae buhae hokombokembe kaube? Rare hila ban rabo ban nekaube?” ");
INSERT INTO set_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nda wanen yeubokene, na moisa orowate yo buhae hokoumiboke hi yae hire hineunge, “Nda ro nde maenin, alu bele ruwae bele yae naei are hakainyekoke?” ");
INSERT INTO set_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Gerasa kani Galilea bukoba nau reufine honole, nebeinye Yesus na moisa orowate yo bele na kai ainyoke. ");
INSERT INTO set_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nebei anuwaunge ro mbai alo yae aungeboke. Maeinyoke Yesus kai eisa akowoke bele nda ro Yesusle hubainyeikondere ruka buluna bulei anuwaufa meke. ");
INSERT INTO set_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Nda ro ruka buluna bulei einye nekeweke, nauwa elaekei sele kowolene, rantai yae ikilenainyekondere na hului ban. ");
INSERT INTO set_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Roko helen oro me rantai yae ikileikoyainyele, nebeibe mere ikileikoyainye rantai hekeleikoyole orore ikileikoyainye besi insekoyole. Nebeinye ikilenainyekondere kabaeinyeke. ");
INSERT INTO set_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Na yane baei reniai rai bulei nolone bele elune bele ele mele koweke, ele kali mo kaeneweke, ruka yomo yae nauwa roroweke. ");
INSERT INTO set_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Yesus melere nahaufa erekeungene, habeleimeyele na bene ruke oro selen-selen roroukoke. ");
INSERT INTO set_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yesus yae weunge, “Walobo, nauwa bulura etuwe!” Nebeinye nebei ro kali elaekei sele kaenele Yesusre weunge, “Yesus, Allah na bumana hele Kiyaele Kelu, Weyae rahebe rare mokoufebondere? Allahle ro yae riyawale rare weitasi okoisemae!” ");
INSERT INTO set_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesus nare hineunge, “Wa ro nde?” Nebei walobo nda ro eisa weunge, “Meyae helenne, ra ro Legiun.” ");
INSERT INTO set_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Na hebaen sele nebei walobo Yesusre riyeunge nda anuwaufa nare ehukei eijae. ");
INSERT INTO set_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Elu yaeyae nebei anuwaufa na nobe obo riya kaban mbai eramanne baete anate. ");
INSERT INTO set_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nda role uwa einya walobo yae Yesusre riyainye, “Maere weime ndi obo bokore ema! Waeimehi naei uwa eise yae emambon!” ");
INSERT INTO set_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Walobo yoni-yoni yae riwainyele are Yesus ehe koumikone, nda role uwara aibaleke obo holona kowate uwane ayeuboke. Obo 2.000 hului kowate kani yaeyaera habelewate, yun mae bune mo rorowate owate, nanemene bune anewate herewate. ");
INSERT INTO set_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nda mekai yeubokere obo kayaare hebewate yo yae Gerasa kani yo kelaeunga honatere huwaimi. Nebeinye ro miyae na yora yora balaimeke, yeuboke rambunde na ijoko yae erenaibondere hokoumeke. ");
INSERT INTO set_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yesusre bokore nda yo mekate bae, na bere alo yae aungeboke ro na malo foi hireukoke uwa osaeuboke nekewole erewainyene, nanemene buhae hele hokowoumi. ");
INSERT INTO set_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Yesus nda ro nauwa walobo holonare hukeumihike a bele obo bune anewate herewate a bele na ijoko yae erewate yo yae ro miyae hokoumekere huwaimi. ");
INSERT INTO set_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nebeinye nda kanina nekate yo yae Yesusre na hebaen-sebaen riwainye nebei anuwaufa kennehinde a hire ende. ");
INSERT INTO set_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Walobo na uwanare hukeungehike ro, kainye hauwate hee Yesusre na hebaen-sebaen riwounge nare hakommibondere ehe konnekonde. ");
INSERT INTO set_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nebei riwolere Yesus ehe okoikoi. Nda a yae weunge, “Waei imae obere waei yo yande yae eye, Allah ware mokoubokete are nane merau ware yanekoi yase yae ei aubokete are huweumiyende.” ");
INSERT INTO set_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nda ro eke Dekapolis kanina yo me bee honatene, Yesus naei uware onomi ikeungele abe huwoumi. Borowate yo nanemene fa yae bowate. ");
INSERT INTO set_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesus naei bukaiboke bukoba waise reufire okate. Nebei buhaeinye ro miyae helen hokoumeke, ele yae naeinyeboke. ");
INSERT INTO set_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nebei yona Allahre ei mom-mom imae naei yun holona mbai na ro Yairus. Yesusre erekeungene bae na bene ane ruke. ");
INSERT INTO set_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Yesusre na hebaen-sebaen riyeunge, “Ra maengke buloone hereinyen-hereinyen eke kole. Herende belene, mei, raei imaere ale mere mo rameungehinde onomi yeungele.” ");
INSERT INTO set_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yairus naei imaere Yesus hakoungeboke ewote. Nebei hee, ro miyae helen bolen Yesus na moisa hakainyekoke ekinye mekinye kinyayeke. ");
INSERT INTO set_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nebei ewate nolone maengke mbai ha yae rileweke ralo yakama me bee oro hi nen bee bele yeuboke. ");
INSERT INTO set_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Roko helen dokter hiwa bokore onomire inyainyele naeise oroweke nebeibe na hului ban. Beko helen hubawounge nauwa bekore mo beweke. Na roi dokterre iwoumine baeungehoke. ");
INSERT INTO set_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Yesus yae ro miyae helen onomi yeumiyeke are nda maengke borouboke. Ro miyae helen nolora kikaweke Yesus na moisa euwaneufoke na malobe kataungehike. ");
INSERT INTO set_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Nebei mekai mokouboke rabuhine ban naei u benera elele, “Na malora mo katarensinde foi isebonde lonbe.” ");
INSERT INTO set_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Yesus na malora kataungehike hee yae ha rileweke na hibi heunguke nebeisa nauwa onomi hubaungehike. ");
INSERT INTO set_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nda maengke me kataungehike hee Yesus nauwa eisa onomire yeumi elae eukuke hubawounge. Nebeinya ro miyae helen hebatere weke ereumikoke mo hineumi, “Ra malo nde yae me kataungehike?” ");
INSERT INTO set_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Na moisa orowate yo yae Yesusre wainye, “Eramae, ro miyae wa bokone ekinye mekinye kinyate lonbe, nde yae wa malo kataungehike ane hinamae?” ");
INSERT INTO set_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nda a wainyere oboroi, Yesus ijoko reufire reufire erele na malore kataungehike kiyaere baeunge. ");
INSERT INTO set_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nda maengke naei uware yeuboke naeisaeinye, oro me oinyeu wae hineuboke. Mokouboke rambun nanemene Yesusle bene oro selen-selen roroukoke wa huweunge. ");
INSERT INTO set_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nebei a wanen huweungekokene Yesus nda maengkere weunge, “Waei hila rabo yae onomi ikete. Na foi mo eye, era buloo ban mae!” ");
INSERT INTO set_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesus nda maengkere ane weunge hee yae, Yairusle imaera kayaa ukaimile Yairusre a weise mekate yo yae wainye, “Wa maengke hereke ya! Guru rahe londe wabeungehinde ebere?” ");
INSERT INTO set_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yairusre wainye are Yesus oboroi sele hebele. Euweke Yairusre weunge, “Buhae ohokoijae, Raei elele are hila rabo mo halei!” ");
INSERT INTO set_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yairusle imaere enatere, hokolo name Petrus, Yakobus, Yohanes (Yakobus naka baeke) Yesus ehe koumikoke hakonainyekondere. Hiwa yore a hun raumihike nekewate. ");
INSERT INTO set_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Yairus naei imaene ekate Yesus erewole rime yo, holo yae wowo, aku nau bumana hele kiteuboke. Rime kali a yan bu yan kaenate. ");
INSERT INTO set_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesus eweufike rimere rimate yore weumi, “Rahene nda mekai ton aku nau wae rime yae felaufake rimaube? Nda fa eherei, ijongku lonbe honole!” ");
INSERT INTO set_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nebeibe nda yo Yesusre re yae harainye. Nebeinye nanemene hukeumihike. Hokolo name bele, nenake naeko bele, Yesus yae ukeumi nangkele nda fa honole yowaise ayeuboke. ");
INSERT INTO set_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yairus na maengke hereke honolere Yesus na mera ikeleungeboke, Aram afaeu wae weunge, “Talita kumi” na mekai, “Maengke fa, Reyae ware wawale, ‘Ainyu!’ ” ");
INSERT INTO set_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nda maengke na ralo yakama me bee oro hi nen bee bele. Yesus annundere ukeunge heera aunguke ele melene kowole, erewainye yo nanemene fa yae bowate. ");
INSERT INTO set_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Hiwa yore nda maengkere Yesus waleungeboke abe hungaimiyende belene, a elaekei sele yae Yesus a hun kolowoumi. Nebeisa weumi nda maengke eraman yenne aneuko. ");
INSERT INTO set_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yairusle maengke waleungebokera, Yesus na moisa orowate yo bele alainyekoke ewate Yesus kabande yeuboke yone aibaleke. ");
INSERT INTO set_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabat ya mo, Yesus huba raweuboke Allahre ei mom-mom imaene kelewoumi. Ro miyae helen sele borowate yo yae fa yae bowate. Hiwa yo yae elewate, “Nda nanemene makeisabe yarowole? Rahe isaei hebaenbe ikainye? Naendae wanen mae rambun emere-emere na hului mokole? ");
INSERT INTO set_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Aeisaeise nekande neyae ore ahuneweke kiyae. Meyae ranneboke nenake Maria nauwake wa Yakobus, Yoses, Yudas, Simon? Nemaen wa aengkele nekande.” Nebei yo Yesusre moi yae bulewainye. ");
INSERT INTO set_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Nebeinye Yesus yae weumi, “Yenjo kayaayo a hi a hine be hineyaimi, nebeibe na yo yanne na aka nolo baeke nolonena be ehineyei.” ");
INSERT INTO set_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nebeinye rambun emere-emere helen selere Yesus omokoikoi sului. Erana buloona yo mbembare mo, me yae nauwa randa kolowoumi onomire iwoumi. ");
INSERT INTO set_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Hila rabo ban nekewate erewoumine, Yesus fa yae bowole. Nebeisa Yesus aloungekoke, yo ran yo ranne keleumiyeke. ");
INSERT INTO set_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Na moisa orowate ro me bee oro hi nen bee belere mo kaeneumikoke, beere beere waheukoke, walobore hukenaimile naei elae kiteumiboke, yo hire yo hire ukeumi enatere. ");
INSERT INTO set_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nibire enate naei ane weumi, “Era inyale, feu, be kangke, roi, eyaroijae, o mehukun mbaibe yarongkombe embe. ");
INSERT INTO set_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Oro mehau hirengkombe, nebeibe ambelae beere eyaroijae.” ");
INSERT INTO set_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Na hibi weumi, “Emembombe yo imae mbainye ehe konaikombena, nebei imaene nekembe. Nekengkombe mo, nebei yora membalembe. ");
INSERT INTO set_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Anuwau hi embe na ro miyae mare ei ehaweinya, a wemmilere oboroinya, embalembe hee mai orona kani bahe rubommibombe. Nda iwau wanen kelemmibombe neyae me u beko hele mokaiboke!” ");
INSERT INTO set_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Na moisa orowate yo alainyekoke ewate yae ahuba huwaimiyeke ro miyae wali bekora nulu kennaimibonde bukenaibonde hele. ");
INSERT INTO set_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nda yo walobo u ranna nekai hukewaimi, era yo buloo yo helen minyak yae kolowaimi onomi iwaimi. ");
INSERT INTO set_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Rambun emere-emere Yesus mokowolene, a hina a hina yo Nare isaeyaeiboke. Nebei abe yoboungekoke Ondofolo Herodes borouboke. Ro miyae hiwa yae elate, “Neyae Yohanes bure kowoumi kiyae herekebe benen waleuboke. Nebeinye rambun emere-emere mokole.” ");
INSERT INTO set_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Hiwa yo yae elate, “Neyae Allahle yendo kayaalo Elia!” Hiwa yo elate, “Neyae yendo kayaalo hi bena yenjo kayaayo wanen.” ");
INSERT INTO set_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodes nebei a faeu elewate boroukokene elele, “Nda Yohanes bure kowoumi bere na yunde ukamaele naisake kiyae, nebeibe waleuboke ya!” ");
INSERT INTO set_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Herodes u benere nekewainye manemfa hele na miyae Herodias kenare kole hului ukeumi Yohanesre ikilaiboke kawane haeinyekoke. Rabuhine ban Yohanes na hibi-hibi Herodesre a elae yae uwounge, “Na ijen ban sele Filipus na miyae Herodias roukae!” Filipus Ondofolo Herodes na aka baeke. ");
INSERT INTO set_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nebei aerene Herodias Yohanesre ikele yae kowounge, kena hele kowole Yohanesre hombondere, nebeibe Herodes yae aheungekene mokombondere kabewounge. ");
INSERT INTO set_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ondofolo Herodes naeisaei Yohanes wali himaloungebokene nane merau Allahle holona rone, fe faewounge. Nebeinye weumi, “Yohanesle wali kayaare foi sele hebembe.” Yohanes ahubane isuwewole hee Herodes na kena osaeiboi ikowole, nebeibe kena hele borondere ikowole. ");
INSERT INTO set_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodes na ralo yakama barauboke yabe mon foi sele rouke. Nebei ya Herodes eraman bulau kaban mokoumiboke. Naei yo wakuna anuwau bele holona yo, fela yun-jun holona yo, Galilea kanina ro bele ro bele yo kaenewoumi. ");
INSERT INTO set_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nebei hee yae Herodiasle maengke meweufike, baene kowole. Ondofolo Herodes nebei kaenewoumi mekate yo bele nda maengke bae kole yae mokowoumi na kenare roweumihike. Nebeinye Herodes yae nebei maengke fare weunge, “Rahe rambun kenare kole riyeufehinde, reyae ware isete! ");
INSERT INTO set_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Na hele wawale, naendae wanen horo lon raei yo waku nekale reufire riyeufehindena, reyae ware kinyerete hakerete.” ");
INSERT INTO set_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nebei maengke fa eke nenakere ekeufinewounge, “Ana, weyae rahebe kena koyae reyae risehinde?” Nenake yae weunge, “Yohanes bure koumi kiyaele ro yunbe riyeisi!” ");
INSERT INTO set_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nebei maengke fa na hibi bukeufike Ondofolo Herodesle bokore eke weunge, “Reyae riyawale nda hee yae Yohanes bure kowoumi kiyaele yun hote einye menaiseyende!” ");
INSERT INTO set_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nebei a wanen riyeungehikene Ondofolo Herodes mehi neufake, na kena beko hele hubawounge. Nebeibe hokoumeke yo bene a holo yae heteungekoke boraibokene, nda maengke yae riyeufike rambunde ahi ewei sului. ");
INSERT INTO set_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Na hibi kayaare hebate felayo mbaise ukeungele Yohanes bure kowoumi kiyaele yun roweise. Nda ro kawa eise eke Yohanes na yun neufake. ");
INSERT INTO set_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Nebeisa hote einye Yohanesle yunde mo auboke meke nebei maengke fare ikeunge. Nebei maengke rouke nenakere ikeunge. ");
INSERT INTO set_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yohanesle moisa orowate yo hereke a angkaei boroukatene, ekate na uwa bangkare mo elaeisake a bulune aimoloufake. ");
INSERT INTO set_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesus na abu ako ukeumi ekate ahuba huwewaimile bele onomi iwaimile bele kaliara bukaiboke Yesusle bokore mekate, ekaikelewaimile ekaimokowate a nemene Yesusre huwainyekoke. ");
INSERT INTO set_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ro miyae helen ele mele kowatene, Yesus na abu ako bele ramande anenaikondere mon ban. Nebeinye Yesus yae weumi, “Men, enaei mo ema. Na hului mayae no yeiboise aku ban nau ban anuwaufe yae ema.” ");
INSERT INTO set_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Uwa monde roungaterene, kaisa hawaiboke aku ban nau ban anuwaufe ewate. ");
INSERT INTO set_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nebeibe nda yo naeisikere ro miyae helen eraimiboke nane merau enate anuwau isaeyaeiboke. Nebeinye ro miyae nebei yo honatena, yau nibira oro habelei-sabelei yae wainyehake, bere holo yae nebei anuwaufe faibaleke. ");
INSERT INTO set_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesus naei kaikaisa fainyoke yae ro miyae helen sele erewoumine kena beko hele hubawounge. Nebei ro miyae domba wanen yaweiboi ro ban. Nebeinye huba raweuboke a helen kelewoumi. ");
INSERT INTO set_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Hu akombondere yae Yesus na moisa orowate yo mekate wainye, “Be bahele nane merau nda anuwau monne, ");
INSERT INTO set_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","nda yo weimi, ‘Ai, yo hine eraman ayaneko.’ ” ");
INSERT INTO set_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nebeibe Yesus yae weumi, “Mayae raman yemmile anenaikondere ya!” Na moisa orowate yo yae wainye, “Nda ro miyae feu helen anenate. Ro mbai oko mehine name na me buhaena roi yae nebei feu hului yaromakonde. Weyae kena koyae nebei feufe emayarongkonde imamile anenaikondere?” ");
INSERT INTO set_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesus beufoke hineumi, “Mainya feu naennaen helen nen honayembe? Emerembo!” Eraikoke mo wainye, “Feu maehae mbai, ka bee honate.” ");
INSERT INTO set_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nebeisa Yesus na moisa orate yore ukeumi, “Ro miyae nanemene wemmile ke ranne riyane riyane mo nungaikonde.” ");
INSERT INTO set_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Riyane riyane rowate yo holo hi 100 roiboyate holo hi 50 roiboyate. ");
INSERT INTO set_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesus feu maehae mbai bele ka bee belere mo yaroukoke. Na be bumare weuweke Allahre helen foise mo ukeunge. Nebei feufe kayeukoke na moisa orowate yore yeumikoke ro miyaere wahenaimikondere. Nebei sului mbai ka bee kayeukoke nebei yore wahaeimikoke. ");
INSERT INTO set_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nane yo anewate wande hele yaeiboke. ");
INSERT INTO set_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Yesus na moisa orowate yo eraman kalunde mo nemene arilaisike kakali me bee oro hi nen bee bele. ");
INSERT INTO set_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Feufe anaikoke yo ro mo nanemene 5.000. ");
INSERT INTO set_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yesus na hibi na moisa orowate yore ukeumi bere holo yae Betsaida yore kaisa fonatere. Nebeisa nebeinya ro miyae helen enatere uwoumi. ");
INSERT INTO set_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Here ukera Yesus elure ebeli boikoise ewole. ");
INSERT INTO set_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Huae yeuboke ereumi na moisa orate yo kaikaisa bumoko nolone fowate, Yesus yaunge namman hebele. ");
INSERT INTO set_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yesus erewoumi nda yo na kaikai ren auwatebe, kabewainye alu bera haraungeboke rawewolene. Nebeinye yare mefo hukai name hului Yesus nda yo bokore bu randa oroumeke moi wommiyonde wanen mae mokoungeboke. ");
INSERT INTO set_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Nda yo Yesus erekainyelene nanemene kulu-kulu yaeiboke, bu randa mewolene enaelo yae elaikokene ele kali bowate. Nebeinye Yesus weumi, “Hilembo, Reyae ya, fe efaei yae!” ");
INSERT INTO set_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nebei kaikai einye eweufileukoke bele, alu na hibi kalaungeboke. Yesus na moisa orowate yo fa hele yae bowate, ");
INSERT INTO set_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","rabuhine ban Yesus naei elae wakere namman onaeite handate, erabae manemfana feu anewatere naei ijoko yae erewate. Naei u bene na hului ban sele isaeinyaibondere. ");
INSERT INTO set_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Bu habala reufine fokate, Genesaret yo isounge yaiboke yawate. ");
INSERT INTO set_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kaikaisa akowate yae ro miyae rainyeboke Yesusbe meke. ");
INSERT INTO set_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ro miyae na yore eisa bele meisa bele habelaete. Erana buloona yo Yesus ekenekele anuwaufe na ijongku honoi kewa ranne yarate mate. ");
INSERT INTO set_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yesus makeise makeise eyewole yo ei yan ei bele yo moinye bele, era yo buloo yo nebei yo yanna nai hei-sei anuwaunge relaeimi honate. Yesus elere erana buloona yo yae riyainye ehe ferere kommikondere na malo kabanne ikilenatere, na hului banna, na malo burainye mo ikilenaibonde. Ikilewate yo nanemene onomi yarowate. ");
INSERT INTO set_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Roko mbai mo Farisi holona riya mbai bele Musale walora wali heere foloukoke are isaeyaeiboke kelewaimi holona bele Yerusalem yora Yesusre hubainyaikondere mekate. ");
INSERT INTO set_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Neyae erewaimi Yesus na moisa orowate yo hiwa na me Yahudi era hena ma yae bu ekuyeikoi yae eraman eyanewate. ");
INSERT INTO set_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Farisi holona yo bele Yahudi ro miyae hiwa bele Yahudi era hena ma yae me bu kuyeikoyatera eramande eyanewate. Nebei u mekai mokate naei waline na yobe naei kamehe naeitena era hena namman ikilainyekokene.) ");
INSERT INTO set_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Neyae nai hei-sei anuwaufa imewatena nauwa bu bele kuyeikoyate wa, raman eyanewate. Era hena helen sele na yobe naei kamahe naei yae kinyaimiboke rambun me bobo hele ikilainyekoke, nda merau: kolaei, bu yai-jai anuwau, olemebe tembagara mokoiboyate, nebeise bu kuinyate mekai huba man mokoyainye. ");
INSERT INTO set_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Nebei Farisi holona bele Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi holo bele Yesusre wainye, “Rahene wa moisa orate yo aei yobe naei kamahe naeitena mokowate era henane ehakoikoi omokoi, eramande na me bu ekuyei yae anate?” ");
INSERT INTO set_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesus yae weumi, “Mayae ro miyae be bee bee yo! Mai naeise na ijen selene Allahle yenjo kayaalo Yesaya yae moloukoke a maijeukoke, Allah yae eleukoke, ‘Nda ro miyae na euwa bonei randa mo Rare buma kolonaisele, nebeibe na kena u bae ahau buhaunga hele. ");
INSERT INTO set_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Rare nendon hele ei molaise, na a usaei wasaei bae ro naei miyae naeinya era henabe roukate kelaeimi!’ ");
INSERT INTO set_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Allahle ako faeukore mayae moise yae hayaeukoke, ro naei miyae naei era hena mayae elae yae ikilauboke.” ");
INSERT INTO set_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesus na hibi a ahuneungeboke, “Mai yobe naei kamahe naeitena era henare hakoyaube, nebeibe Allah mare ukembe are moinye hayeyaube. Nebei wanen mokoyaube maisaei sele! ");
INSERT INTO set_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Musa yae a eleukoke, ‘Mai araise anare enera faisa yanemmiyembe.’ Nane merau, ‘Nde yae naekore nenakere a beko wemmilena, nebei kiyae honaibonde hele.’ ");
INSERT INTO set_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nebeibe mayae kelaeumile ro miyae naekore nenakere wemmile, ‘Arate anale, mai walire hakorebobe rambunbe roufele Allahre hili era akau erare erenjende.’ ");
INSERT INTO set_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nebei mokaibokera mayae nebei ro miyaere mon eyei sele naekore nenakere foise mokonaimilere. ");
INSERT INTO set_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nebei era hena walora Allahle ako faeukore mokaunge erabuhi ban baete. Nda wanen me u beko helen mayae mokaube.” ");
INSERT INTO set_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nebeisa ro miyae helen ahaunga hebatere Yesus kaenewoumi na bokore mewate wa weumi, “Raeinya a wamale boronsebombe nane merau nou hennele. ");
INSERT INTO set_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Rambun hiwa moisa eise ate yae ro miyae naei u mekai bekore nikire omokoiboi sului, nebeibe kena eisa u benera euwa boneisa baleimeyate rambun mae bekore nikire mokaimi. ");
INSERT INTO set_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mayae angkaei boraube ro miyae nebei are nou hembe!” ");
INSERT INTO set_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nebeisa Yesus nda ro miyae helen nukeumiboke, na moisa orowate yo bele imae mbainye ayeuboke. Nebeinye yae na moisa orowate yo yae ahumbo-ahumbo ahuneuboke uwoumi isaeyeiboi mone hinainyehike. ");
INSERT INTO set_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesus yae weumi, “Mayae namman isaeyeiboi mone. Mayae isian selene, rambun yoni-yoni ro naei miyae naei euwa moisa eise ate naei u mekai bekore nikire omokoiboi sului. ");
INSERT INTO set_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Rabuhine ban euwara ate bae kena eise eyeisi ton, yarelere yae eyewate nebeisa beko anuwaunge eyokande.” Nebei yaere Yesus kelewoumi raman nanemene eli hoho ban yaeiboke. ");
INSERT INTO set_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Benen Yesus weumi, “Ro naei miyae naei kena ura balenate rambun yaere naei u mekai bekore nikire olengkonde. ");
INSERT INTO set_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Rabuhine ban kena u eisa baleimeyate nda niyae: u bene beko, yoko kaeimae, yokore, ro miyae hoi-soise, ro miyae bele miyae molo bele mbainye hononetere, ");
INSERT INTO set_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ro miyae hiwa naei rambun kena haehae koyatere, bekore benate me u mokatere, ame-amere, bekore kena haehae hele koyate mokonatere, kena hensende, a hufuufe, u kaeise, wali yeli-yelire. ");
INSERT INTO set_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nebei beko bako nemene fomene kena ei u eisa mo ijakawate, ro miyae naei u mekai bekore nikire mokaimi.” ");
INSERT INTO set_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Galilea kanira Yesus kulun uke Tirus kanire ewole. Eke naeise isaeinyaibonde belene aibaleke yone imae mbainye eweufike, nebeibe ro miyae erekainyelene yaka haikoke. ");
INSERT INTO set_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nebei yona miyae mbai na maengke alo yae aungeboke. Yesus meke naeise nda miyae boroubokene, meke oro selen-selen mae Yesus na bene meukoroukoke. ");
INSERT INTO set_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nda miyae Yunanina, Siro Funisia kanine hongkate Yahudi yo ban. Na maengke alo yae aungebokere Yesusre na hebaen-sebaen riyeunge na walobo u rannare hukennehindere. ");
INSERT INTO set_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","((Yesus naei kenare kowole Yahudi yore na bere hakommile, Yahudi ban yore moisa.)) Nebei aerene Yesus yae weunge, “Fa-fa na berei yae raman anenaikonde uwa renaibonde wa, na ijen ban sele fa-fa naei feube yokure hainyaimile.” ");
INSERT INTO set_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nebei miyae yae weunge, “Na hele, Tuhan, nebeibe eramande anate anuwau kelene yoku honate, fa-fa anate eraman mohi-mohi balate yoku eyanewate lonbe!” ");
INSERT INTO set_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","((Yesus isaeyeuboke nebei miyae “yoku” a eleukokene, neyae merau haraungeboke “Yahudi ban ro miyae.”)) Nda miyae nebei a mekai yae ukeungene, Yesus yae weunge, “Waeinya a naijen waraene, eye, wa fa foi ikanale, na u buluna walobo eukuke ya.” ");
INSERT INTO set_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nane miyae imaere eke bae na fa ereunge ijongku honoi tanne honowole. Nebei walobo na hele nebei fa na u bulura eukuke. ");
INSERT INTO set_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesus naei Tirusra nekaikokera Sidon yo bu kelare ewate. Nebeisa Galilea bukobare bukaiboke na kelaeunge yo me bee (Yunani a faeunge Dekapolis elate) kani nolora ewate. ");
INSERT INTO set_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nebei anuwaunge ro mbai angkaei kokun nane merau a foise elei ro miyae yae yawainyehoke, Yesusle bokore mekate. Yesus Na mere nebei kiyaele uwa ranne rannehindere na hebaen-sebaen riwainye. ");
INSERT INTO set_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nebeibe Yesus nda rore mo yaweungehoke ro miyae helen hebate anuwaufa felan wanen eke mo, Yesus Na mere mo nebei role angkaei bulure nekeungele ekera, Yesus euwaeki houboke nebei role faeunge kataungehike. ");
INSERT INTO set_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nebeisa Yesus Na be yakure weuweke no yobouboke mo nebei rore Aram afaeu wae weunge, “Efata!” na mekai, “Raweuweuko!” ");
INSERT INTO set_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Yesus are ukeunge hee nda ro naengkaei bele faeu bele onomi yaeiboke, angkaei borowole are nendon wanen mae elewole. ");
INSERT INTO set_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesus yae ijokore eraiboke yore a herauwoumi nda rore onomi ikeungere hiwa yore ehuweyeijae. Yesus a hun kolowoumibe, eraiboke yo yae na hibi-hibi huwayeke ndire ndare yobainyeke. ");
INSERT INTO set_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Borowate yo fa yae bowate, elate, “Yesus nemene fomene na foi sele mokowole, fare boi-boi wanen! Ro miyae angkaeise oboroi yo mokoumi angkaei borate, are elei yo mokoumi a elate!” ");
INSERT INTO set_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nebeinye mo nekewate ro miyae helen bolen hokoumeke, holo kaban sele wokainyele. Hokoumeke yo Yesus ereweumile eraman banne, na moisa orowate yo kaeneumikoke mo weumi, ");
INSERT INTO set_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nda ro helen miyae helen arilewolene Reyae kena beko hele hubanale. Rangkele mo nekeimeyande ya name nendobe yeuboke, ramanbe baeumihoke. ");
INSERT INTO set_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nda yore na yarele bangka yae ufemile enatena, nibi nolone hokoiko-hokoiko konayende, rabuhine ban naei nolona hiwa ahaufa mewate.” ");
INSERT INTO set_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yesus na moisa orowate yo yae wainye, “Na hului ban sele nda a haei-saei a koukou wanen raman yaromakonde ro miyae helende imamile anenaikonde uwa renaibondere!” ");
INSERT INTO set_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesus yae hineumi, “Mainya feu naennaen hului honate?” Neyae wainye, “Mehine bee bele.” ");
INSERT INTO set_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesus nda ro helen miyae helen kani ranne mo nuwenaikondere ukeumi. Nebeisa nane feu mehine beere mo yaroukoke Allahre helen foise mo ukeungele. Nane feufe mo Naei me yae kayele na moisa orowate yore yeumi, nda ro miyaere wahenaimilere. ");
INSERT INTO set_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ka fele-fele name keli hubayaeikoke roukate mekate mo, Yesus helen foise mo Allahre ukeunge. Nebeisa na moisa orowate yore wahenaimikondere ukeumi. ");
INSERT INTO set_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nanemene anaikoke uwa hele raeibokate. Nebeisa na moisa orowate yo anaikoke na kalun honowatebe riya mbainye arilaisikera me baeikoke kakali mehine bee bele yaeiboke. ");
INSERT INTO set_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Eraman anaikoke yo me baeikoke bae nemene 4.000 hului. Nebeisa Yesus ukeumi nebei ro miyae helen na yore-yore ewate. ");
INSERT INTO set_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Halakokera Yesus na moisa orowate yo bele kaikainye maeisaweuboke Dalmanuta kanire fowate. ");
INSERT INTO set_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Fainyoke yona Farisi holona yo Yesus bokore mekate. Umalire hubanainyehindere nebei Farisi holona yo yae surgana rambun eme wanen kelemmibondere riyainye. ");
INSERT INTO set_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesus na kena eisa mehi yae folowole wa elele, “Rahene nda heena ro miyae rambun emere-emere mokorebondere riyaise? Reyae nda heena ro miyaere rambun emere ekeleijae hele.” ");
INSERT INTO set_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yesus nebei are riwainye yore nukeumiboke, na moisa orowate yo bele kaisa hawaiboke naisike reufire fowate. ");
INSERT INTO set_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesus na moisa orowate yo oneumikoke feu hi ebaraiboi. Naei feu mbai ken sele kaikai einye nekewole. ");
INSERT INTO set_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Bumokone fowate yae Yesus weumi, “Kayaa hebembe! Farisi holona bele Herodesle holona bele naei ragi.” ");
INSERT INTO set_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Na uware uware hinate elate, “Yesus na mekai ma rahebe haraungeboke? Eyae feu eyaroikoi mekandene era?” ");
INSERT INTO set_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Na kena u einye hubawainyere Yesus isaeyeuboke, nebeinye nda yore weumi, “Rahene mayae feu ban nounge haeube? Mayae namman Raei elae isaeyeiboi! Mai u bene namman nana yae nekeimeyayembe. ");
INSERT INTO set_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mayae raei me u mokoukokalere ijoko eraukoke angkaei boraukoke, nebeibe naei mekai isaeyeiboi mo kaube era. Bene nekenayembe, ");
INSERT INTO set_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Reyae feu maehae mbai kaiwale ro miyae 5.000 ikamaele! Nebei ikamaele anaikoke heene, na kalun kakali naennaen arilaufike?” Nebei yo yae wainye, “Me bee oro hi nen bee bele.” ");
INSERT INTO set_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesus benen weumi, “Nane merau feu mehine bee belere kaiwale, ro miyae 4.000 ikamaele anaikoke hena na kalun kakali naennaen arilaufike?” Nebei yo yae wainye, “Mehine bee bele.” ");
INSERT INTO set_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yesus yae weumi, “Nebei lonbe wa mayae namman isaeyeiboi mo koimeyaube Reyae naeinya hesele nde!” ");
INSERT INTO set_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesus na moisa orowate yo bele kaisa awayeke ekate Betsaida yone ainyoke. Betsaida yona ro mbai ijoko kumba yawainyehoke Yesusle bokore mekate. Yawainyehoke yo yae Yesusre na hebaen-sebaen riyainye mere ramenensindere. ");
INSERT INTO set_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesus nane rore mo na mera ikileungeboke yaweungehoke yo moise ekete. Nebeisa Yesus euwaekire mo mene houboke nebei role ijoko ranne raungehike. Nebeisa hineunge, “Mana naendae wanen, ndane rambun hi ijoko ereyae?” ");
INSERT INTO set_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nebei ro na ijoko bere yae erele, weunge, “Ro miyaere eramaele, nana wanen, o merau ha merau eramaele ele mele kate.” ");
INSERT INTO set_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesus na me nebei role ijoko ranne benen raungehikera ijoko na hele hele erewole ro miyae ro rowoumile. Nda ro na hele na ijoko foibe yeiboke erele. ");
INSERT INTO set_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nebeisa Yesus nebei kiyaere weunge, “Nda a huweumile belene, yo eise eijae, na hibi waei imaere yae ele.” ");
INSERT INTO set_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesus na moisa orowate yo bele Betsaida yora alainyekoke Kaisarea Filipi yo kaban yanainyekoke honate yo ran yo randa orayeke. Nibi nolone ewate yae Yesus hineumi, “Ro yae miyae yae rare nde yae elate?” ");
INSERT INTO set_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Na moisa orate yo yae wainye, “Hiwa yo yae elate, Yohanes bure kowoumi kiyae; hiwa yo yae Allahle yendo kayaalo Elia yae elate; na hiwa yo yae wa Allahle yenjo kayaalo mbai yae elate.” ");
INSERT INTO set_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yesus yae hineumi, “Mayae bae Rare nde yae elaube?” Petrus yae weunge, “Weyae Allah yae oro umaufe heraungeboke Wali Ondofolo!” ");
INSERT INTO set_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nebeisa Yesus nda yore a hun koloumi, weumi, “Ndere ndere Raei uwa naei a ehuweyeijae.” ");
INSERT INTO set_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nebeisa roko mbai nendo Yesus naei uwa beko mokonainyelere abe yakawoumi. Na moisa orowate yore weumi, “Reyae, Allahle bokora mekale ro miyae uware yeubokale Kiyae, beko helen sele hubarengkonde. Yahudi yun-jun bele, imam yun-jun bele, nane merau Musale walora wali heere foloukoke are isaeyaeiboke keleyaimile holona bele nenaisehinde nebeisa honaisebondera enaisemolonsande. Nebeibe ya name nendo nulu yo mahe yora arenunde.” ");
INSERT INTO set_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesus na uware enainyemokonde a na yaka yae yakawoumi. Nebeisa Petrus yaweungehoke felande einyakeleuboke a maleu-maleu wae weunge, “Nebei wanen are ehuweijae ya!” ");
INSERT INTO set_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nebeibe Yesus eubeufoke na moisa orowate yore ereumi wa, Petrusre oku nekeunge weunge, “Ra moisa yae eye, Setan walobo yun! Rabuhine ban waei u benera Allah yae haraungebokere ebaei, ro miyae naei u benena ma yae haranae!” ");
INSERT INTO set_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nebeisa Yesus ahaunga hebate ro miyae helen bele na moisa orowate yo bele kaeneumi naei bokore menatere. Mekate mo ane weumi, “Rare hakonsebonde kiyae, nda wali ma mokonde hele: naei bekore kena haehae koyelere ehakoyei, naei ohali kaembonde, a ufende hului hubara haeisa yanende yae Rare hakonsebonde. ");
INSERT INTO set_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Rabuhine ban nde yae releunge naei wali holere molonnebonderena, nebei kiyae naei wali hole omoloiboi. Nebeibe nde yae Raei naei a foi faeu foi aerene naei wali Rare yenselena na wali hole molonnebonde. ");
INSERT INTO set_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Na foi rahe, ro mbai nda kanina kelana rambun nemene fomene yaroukoube, naei wali bae hole omoloiboi! ");
INSERT INTO set_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Rahe rambun nda kani kela naei yae wali henare na hului beneikonde! ");
INSERT INTO set_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nda hokolona ro miyae Allah are ehakoiboi, me hila u hila bele mokate yo nolone nekate. Nde yae Raei naeise nebei yo bene fe engkondena, Reyae roko benen merele heene nare nebei sului mbai fe eremikonde. Reyae, Allahle bokora mekale ro miyae uware yeubokale Kiyae, benen merele heene Maeko Naei one hengko eisa Naei eleuboke malaikat bele ei anaisebonde memale.” ");
INSERT INTO set_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesus yae weumi, “Na helebe mare wamale, mai nolona hiwa yo ehereiboi mo nekenate Allahle yo waku nelae wake bele enayerembonde.” ");
INSERT INTO set_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ya mehine mbai nekaikokera, Yesus yae nda ro name Petrus, Yakobus, Yohanes yaweumiboke elu kaban mbaise ikate. Nebeinye na mo-mo nekewate yae Yesus na uwa ma hi yeuboke. ");
INSERT INTO set_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Yesus na malo keleumon wili halaman bowole. Nda kanina kelana malore mokate anuwaunga nebei mekai malo keleumonde ehameikoi sului. ");
INSERT INTO set_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Hokolo name erate bae, ro bee yakaiboke ane Yesus naei elate. Nebei ro bee ro raimiboke Allahle yenjo kayaayo Eliale Musale. ");
INSERT INTO set_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nebeisa Petrus yae Yesusre weunge, “Guru, nda baete foi sele hubannele, kena kokomae yae meyae fale name haendekoube Ware mbai, Musa mbai, Elia mbai.” ");
INSERT INTO set_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Fe yae waku yae hokolo name nekeumi kowatene, Petrus elengkonde a onewolene na mekai ban mae eleukoke. ");
INSERT INTO set_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Petrus ane weunge hee yae mangko meumiranoke, nebeisa bae borate abe nda wanen weumi, “Nda Raei fa kena buhaere haenale Kiyae, Nare mo boronnembe.” ");
INSERT INTO set_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Hokolo name na hibi enere faise ijoko eiwela haiwala kate, nebeibe Musale Eliale nundeiboke, Yesus nembai erainye hebele. ");
INSERT INTO set_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nebei elura owate yae wa Yesus a hun kolowoumi, weumi, “Hire hire nda erauboke era ehuweyeijae mo nekemfombe. Reyae, Allahle bokora mekale ro miyae uware yeubokale Kiyae, nulu yo mahe yora arenunde ya wa hiwa yore huwemmile.” ");
INSERT INTO set_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Yesus nebei a hun raumihikene neyae ro miyae hiware ehuwei mo nekayeke. Hokolo name na mo-mo roiboyate yae wa eisinewate naendae mekaise Yesus nulu yo mahe yora annundere eleukoke. ");
INSERT INTO set_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Hokolo name yae Yesusre hinainye, “Rahene Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi yo yae elate, ‘Wali Ondofolo emei mo Allahle yendo kayaalo Elia yae na bere hele mende?’ ” ");
INSERT INTO set_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesus yae weumi, “Nebei na hele Allahle yendo kayaalo Elia bere holo mende, Wali Ondofolo mende naeise nemene mokonnehandere. U bene nekayembe Allahle yenjo kayaayo yae naendae mekai yae a molaikoke: Reyae, Allahle bokora mekale ro miyae uware yeubokale Kiyae, roko helen beko hubarengkonde nane merau aukaka yae enaisekonde. ");
INSERT INTO set_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Na helebe Reyae mare wamale, Allahle yendo kayaalo Elia na hele meke ya, homone nulainyekoke huluinye. Ro miyae yae nare naei kena hului yae mokainyele.” ");
INSERT INTO set_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesus hokolo name bele elura nokainyele owate. Erewate bae elu orone ro miyae helen mekate Yesus na moisa orowate yo hiwa nukaimibokere ele yae naeimiboke, Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi yo bele ane kilewate. ");
INSERT INTO set_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nebei ro miyae helen hebate aiweke Yesusre erekainyele bae fa yae bate. U hale me hale Yesusle bokore habeleimeyate na a bele melaeyeimeyainye. ");
INSERT INTO set_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Na moisa orowate yore Yesus yae hineumi, “Rahe abe mayae ndi Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi yo bele kilaube?” ");
INSERT INTO set_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nebei ane hineumi yae ro miyae helen arilewounge hebate nolora ro mbai yae Yesusre weunge, “Guru, raei kelu fa waei bokore roukanale mekende, alo yae aiboyeunge kokunde yeiboyele. ");
INSERT INTO set_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Alo yae aiboyeunge hee bae nda fare a walinne hakeiboyele, neuwara olokee mo itilewate, heraa roroikoyele, na uwa kaban elaekei halaekei yeiboyele. Wa moisa orate yore nauwana alore hukenainyehindere riyeumihikalebe, nebeibe neyae na hului ban.” ");
INSERT INTO set_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesus nebeinye hebate yore weumi, “Mayae nda heena nekaube ro miyae hila ban rabo ban yo! Naendae mekai horo lon mangkele heki hele orowandebe, mayae Rare hila rabo ehalei sele. Nane merau kena beko hele hubanale, rabuhine ban mai naeise heki hele kena yae heraweumekale.” Nebeisa nebei yore weumi, “Nebei fa yawennoho meu!” ");
INSERT INTO set_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Yesusle bokore yawainyehoke ekate. Nebei walobo Yesusre erekeunge heene nda fare na uwa mokoungeboke nei-nyei kowole, ane ruke eyole meyole olewole neuwara olokee mo balaimeke. ");
INSERT INTO set_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesus nda fa naekore hineunge, “Makei hee yae nda u mekai mokoungeboke koumeke?” Naeko yae weunge, “Nebingken nekewole hee yae. ");
INSERT INTO set_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nane merau nda kole u mekai mo ban, roko mbemba walobo nda fare i ranne rowele kaisiyeungele, roko hire bune rowele kaisiyeunge honaibondere mokainyeke. Nebeinye Guru Weyae na hului mokoubondena, buhae heimeko maere hakoimebo.” ");
INSERT INTO set_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesus yae weunge, “Rahe aerene eleukokae, ‘Na hului mokoubondena’? Ro miyae yae Rare hila rabo halenselena, nemene-fomene na hului mo!” ");
INSERT INTO set_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nda fa naeko na hibi kaenele, “Tuhan, reyae hila rabo halaelebe nebeibe elae ban. Rare hakoisobo raei hila rabo elae roufe!” ");
INSERT INTO set_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesus erewole ro miyae helen u hale yae arileumeke haei bae, nda fa na uwa buluna walobore hukennehindere a elae yae weunge, “Walobo angkaei kokunde, a munde mokoungebokae kiyae, Reyae wawale, nda fa uwa bulura eituwe, benen emeijae mo!” ");
INSERT INTO set_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Walobo enduwendere na kali bele kaenewole, nda fa nauwa kaban nekeungele oro me bae yae hayeuboke. Walobo na u bulura eukukera erainye bae nebei fa here no merau honole. Ro miyae helen erainyele yo yae nanemene elate, “Nda fa hereke ya.” ");
INSERT INTO set_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nebeibe Yesus nda fare ikileungeboke na mera kaeungeboke aunguke afae yeufurekoke. ");
INSERT INTO set_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nebeisa imae mbainye ayeuboke nekewate wa, na moisa orowate yo a maehae-maehae yae Yesusre hinainye, “Rahene meyae walobore ehukeisi sului?” ");
INSERT INTO set_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesus yae weumi, “Nebei wanen walobore hukennehimbere, nenaei ma, ebeli yae helere na hului.” ");
INSERT INTO set_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nebei anuwaufa enatere Galilea kanira fowate, Yesus kena ban hiwa yo isaeinyaibondere makei ijenna ate, ");
INSERT INTO set_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","rabuhine ban Yesus naei na mo-mo fonate yae na moisa orate yore a usaei bele kelemmilerene. Yesus yae weumi, “Reyae, Allahle bokora mekale ro miyae uware yeubokale Kiyae, beko mokoiboise ro miyaere Raei kelai nenainyendere. Nebei yo yae honaisebonde. Name nenja mo nulu yo mahe yora arenunde.” ");
INSERT INTO set_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yesus Naei mekai haraungeboke uwoumilere, na moisa orowate yo onewate handawate. Nebeibe a hinenainyehindere fe yae kowainyele. ");
INSERT INTO set_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ewate Kapernaum yone aibaleke. Nebeinya imae mbainye ayeuboke wa Yesus yae na moisa orate yore hineumi, “Mayae rahe abe nibi nolone mande yae eleimeyaube?” ");
INSERT INTO set_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Fe yae hubainyelene a ban nekewate, rabuhine ban a na no bae nde yae naei nolona kabande yeuboke abe kileimeyate. ");
INSERT INTO set_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesus angken ounguweuboke mo, na moisa orowate yo kaeneumikoke wa weumi, “Nde yae rore ronainyelere kena kolena, nebei kiyae naei ro are yae mokonnele hele, nane merau ro miyae nemene naeise yebaei bubaeise yembonde.” ");
INSERT INTO set_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nebeisa Yesus fa kaei-kaei mbai roukeunge naei nolone haungeboke, hahi yae roukeungele wa weumi, ");
INSERT INTO set_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Nde yae fa kaei-kaeise Raei ro aerene foi yae ei annebondena, nebei kiyae Rare eibe haweufe. Nane merau nde yae Rare ei hawensele, nebei kiyae Rare mo ei haweufe ban, Allah, ndare ukeufe mekale Kiyae bele, ei haweunge.” ");
INSERT INTO set_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nebeisa Yohanes Yesusre weunge, “Guru, meyae ro mbai erekannele Waei ro yae walobore hukeumihike. Meyae nebei mekai mokoubokere a hun kolowannele, neyae aei holone oroinye.” ");
INSERT INTO set_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Nebeibe Yesus yae weumi, “Ahennemae! Rabuhine ban ro miyae nde maenin rambun emere-emere Raei ro yae mokombonde kiyae u hale yae Rare a beko ewei sului. ");
INSERT INTO set_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nde aengkele me kena u kena ekinyeinya, nebei kiyae aei reufine weke, aere hakoume. ");
INSERT INTO set_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Reyae Wali Ondofolore yeubokale. Nana heselebe wamale, nde yae bu nuku weyae aneufinde naeise kolaei mbai inyete Raei holone oroyae aerene, nebei kiyae na me buhae Allah enneyende.” ");
INSERT INTO set_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ro miyae fa-fa wali wanen nekate holona ro miyae Rare hila rabore halaeisele yo, wabenaimihinde beko ranne enaibalendena, nebei yo beko hele hubanainyende. Naei foi sele nebei ro miyae ruka kaban na horora ha yae bainyaisinde nau bune enaiwoyonde. ");
INSERT INTO set_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","“Naei foi sele wali hole moloubonde naise me mbai neufande, me bee herele bele. Nebei sului mbai wa kena haehaere koyae hului waei me yae bekore mokoubondena, narakare ele belene, nebei kena haehaere koyeyae hee neungele. Narakana i bulo-bulo ekebeikoi sului, nane merau uware anate hen ehereiboi sului. ");
INSERT INTO set_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na foi sele wali hole moloubonde naeise oro mbai neufande, oro bee herele bele. Nebei sului mbai wa kena haehaere koyae hului waei oro yae bekore orolena, narakare ele belene, wa kena haehaere koyeyae hee neungele. ");
INSERT INTO set_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Narakana uware anate hen eherei sului, na i bulo-bulo ekebeikoi sului. ");
INSERT INTO set_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na foi sele wali hole moloubonde naeise ijoko ani mbai keleufinde wowonde, ijoko bee herele bele. Nebei sului mbai wa kena haehaere koyae hului waei ijoko yae bekore erelena, naraka ele belene, wa kena haehaere koyeyae hee neungele. ");
INSERT INTO set_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Narakana uware anate hen eherei sului, i bulo-bulo ekebeikoi sului. ");
INSERT INTO set_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Rambun hiwa i walora yolo-yolo inyaibonde wanen mae ro miyae beko hubanainyele walora u mekai foi inyaibonde. Nebei ro miyae wanen Allah yae kenare kole, naei wanen mbai Allah hae bele heraeyeikoyate hili era akau erare kenare koyele. ");
INSERT INTO set_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Hae na yu foinya, nebei hae na foi. Nebeibe na yu u yembondena, na hului ban benen yu belere mokonainyebonde. Mai wali einye hae bele wanen mae nekembe, foi hi yae hire mokonnele.” ");
INSERT INTO set_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Kapernaum yora Yesus naei alainyekoke Yudea kanire ekate. Nebeisa Yordan wi enaa reufire ekate. Ro miyae helen sele mekate Yesusle bokone mo mewarileufike, ya-ya na wanen Yesus nda ro miyaere wali nibi ane kelewoumi. ");
INSERT INTO set_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nebeinye kelewoumile yae Farisi holona yo mekate Yesusre u malire hubanainyehinderene hinainye, “Musale walora wali heere foloukoke ma huluinye miyae na hului huremamile?” ");
INSERT INTO set_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesus yae weumi, “Musa yae rahe abe nda naeise mare ukembe?” ");
INSERT INTO set_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Farisi holona yo yae wainye, “Musa ehe koumikoke ro na miyaere na hului nennehinde. Nebei ro yae nennehinde naei homo mbai molongkonde yennele.” ");
INSERT INTO set_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesus yae weumi, “Mai kena elae yun elae nekeyaubene Musa yae nebei a moloukoke. ");
INSERT INTO set_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Allah nebei wanen u bene eharaiboi. Rabuhine ban nda kani kelana mokouboke heene, ‘Allah ro bele miyae bele mokoukoke.’ ");
INSERT INTO set_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Nebei aerene ro mbai naeko nenake nukemmibonde, nenaei yae na miyaele mbainye eneinyekende, ");
INSERT INTO set_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","na beene mbainye inyeibonde ((naei kena u aweneikonde)).’ Nebei aerene bee ban mbai mo yembonde. ");
INSERT INTO set_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nebei wanenne Allah yae mbainye mokommibonde rambun, benen ro yae miyae yae ekelareijae!” ");
INSERT INTO set_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Imaene na mo-mo nekewate yae wa, na moisa orowate yo yae nebei a mbaibe benen hinewainye. ");
INSERT INTO set_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesus yae weumi, “Nde na miyae nenensinde, benen miyae hi rowendena, nebei ro yoko kaeimae koukoke, naei miyae helere beko mokoungeboke. ");
INSERT INTO set_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nebei sului mbai, miyae mbai na molo nenensinde, benen ro hi bele eneinyekendena, yoko kaeimaebe koukoke.” ");
INSERT INTO set_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ane weumi hee yae ro miyae na fa-fa yarowaimi Yesusle bokore mewate mere kolommilere, nebeibe Yesus na moisa orowate yo a elae yae uwaimile. ");
INSERT INTO set_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesus nebei wanen hukewaimile erewolene a na ikele yae na moisa orowate yore weumi, “Raei bokore nebei fa-fa nendon waemmihi mai, a hun okolommimae! Nde naei nda fa-fa wali ma nekate yo Raei me kelee u keleene nekate holona ro miyaere yaeiboke. ");
INSERT INTO set_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nana heselebe wamale, nde yae fa-fa ((naeko nenake weimi are boroyeumi wanen Reyae weumi are oboroinya,)) Raei me kelee u keleene nekate ro miyae holone eyeisi sului.” ");
INSERT INTO set_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nebei wanen a weumikokera, Yesus nebei fa-fare mo hahi yae yarowoumi, me yun ranne kolowoumi, Allahre riwounge nebei fa-fare onomi foka yae ei hawemmile. ");
INSERT INTO set_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Alonainyekonde enatere yae ro mbai oro habelei-sabelei yae habeleimeyele Yesusle bene uwa oro selen-selen mae roroukoke. Nebeisa hineunge, “Foise mo mokoyeyae Guru, rahe me u yae mokorebonde na hului wali hena bona eitoufele?” ");
INSERT INTO set_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesus yae weunge, “Rahe ma haraungebokaene weyae Rare foi yae warae? Rabuhine ban hi yae ha yae foi u hele, Allah nembai sele foi. ");
INSERT INTO set_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Weyae Allah yae Musare ukeunge wali heere foloukoke are waeisaei, ro hoi-soi ohoijae, ro miyae bele miyae ro bele mbainye ohonoijae, yoko ebaeijae, ro miyae naei a hele ban ehuweijae, ame-ame ebeyeijae, ana araise enera faisa yaneumiyende.” ");
INSERT INTO set_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nebei ro yae weunge, “Guru, nebei a nemene na hokolona hakowale mokowale bangka mo.” ");
INSERT INTO set_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesus nebei rore erewounge na kena buhae bele hewounge wa weunge, “Mbai sele waeinya kalore molote, eye waei rambun nemene naise heukonde mo, nebei roibe keren ban nale ban nekate yore yeumikonde. Nebei yae weyae keren nale surgane hononayete. Nebeisa rare hakoufebonde!” ");
INSERT INTO set_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yesus yae ukeunge are na kenara beko hele yae hubawounge. Nda ro naei rambun helen selene, nebei anuwaufa na rei ban mai ban mae aloungekoke ewole. ");
INSERT INTO set_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesus na moisa orate yore ereumi wa weumi, “Na yabi-yabi hele keren bele nale bele ro miyae Raei me kelee u keleene nekate holona ro miyaere inyaibondere!” ");
INSERT INTO set_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Yesus yae eleukoke are na moisa orowate yo borowate fa yae bate. Yesus ahuneungeboke weumi, “Fa-fa borombo, ro miyae na yabi-yabi hele Raei me kelee u keleene nekate holona ro miyaere enaijembondere. ");
INSERT INTO set_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Imake bulure nendon wanen sele obo unta eweufiube, nebeibe keren nale nolone nekeyate yo yae Raei me kelee u keleene nekate ro miyae holone enensindere yabi-yabi hele.” ");
INSERT INTO set_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yesus yae elewoke a na moisa orowate yo borowate, fa yae bowate, hi yae hire hineunge, “Ndi a merau eleukokena, nde naei yae wali enaiyaronde.” ");
INSERT INTO set_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesus ereumi weumi, “Benate naeise Allahle me einye mo, nebeinye ro yae miyae yae na hului ban elate kayeero. Allah yae bae rahe rambun na hului ban? Nanemene na hului mo yeiboyele!” ");
INSERT INTO set_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nebeisa Petrus yae weunge, “Eramae, maei rambun nemene fomene nukandekoke hayaendekoke, Ware hakayekokete.” ");
INSERT INTO set_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesus yae weunge, “Nana heselebe wamale, nde yae raei aerene bele Raei a foi faeu foi aerene bele naei imae obe, naka baeke, naeko nenake, na kelu omi, na buro kela nukemmibondena, ");
INSERT INTO set_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nebei ro miyae holore nda hee yae rambun raka 100 yae barammibonde. Nebei rambun barammibonde nda niyae: imae obe, aka baeke, nenake, kelu omi, buro kela, nane merau weitasi konainyele. Nebeibe bena yane nda holona yo wali huba ban haei ban enaiyaronde.” ");
INSERT INTO set_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","“Na yaka inyaibonde nda heena ro bele raimi yo helen rabuhi ban mae me baemmibonde, nane merau nda heena me baei ban yo helen ro bele yae me baemmibonde.” ");
INSERT INTO set_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesus na moisa orowate yo bele alainyekoke Yerusalemde ewate. Nebei yone Yesusre beko mokonainyekonde isaeyeubokebe, neyae bera neuboke ewate. Nebei aerene nibine ewate bae na moisa orowate yo fangkengke kowate nane merau ro miyae helen hakainyekoke ewate yo fe waku kowate. Yesus na moisa orowate yore me bee oro nen bee helere mo arileumihike, Naei uwara enainyemokonde ane uwoumi, ");
INSERT INTO set_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Borombo! Mana eyae Yerusalem yore ande. Nebeinye emale yae Reyae, Allahle bokora mekale ro miyae ure yeubokale Kiyae, imam yun-jun naei nane merau Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi yo naei me einye kelai nenayende kinyenaisebonde. Nebei yo yae honaisebonde naei a hokonaikonde mo, nebeisa Allahre rore oroiboi, Yahudi ban ro miyae holona, me eise yae kinyenaisebonde. ");
INSERT INTO set_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nebei yo aukaka yae konaisele, eki hesere yae roronaisele, erahuae olenaisekonde, honaisebonde. Nebeibe molonaisehandera kanine ya bee mo honorekonde, name nenjare mo arenunde.” ");
INSERT INTO set_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nebeisa Zebedeusle fa-fa bee, Yakobusle Yohanesle Yesusle bokore mekete weinye, “Guru, meyae riyayeisite maei kenare konde rambunde mokoumebondere.” ");
INSERT INTO set_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesus yae hineumi, “Mai kenare koube rahe erabe mokorebobe mayae erebobere?” ");
INSERT INTO set_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Hokolo bee yae weinye, “Ehe koimeko Waei yo waku one bele hengko bele meungeubondene, maere waei meline meubene anuwau haumekonde.” ");
INSERT INTO set_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Nebeibe Yesus yae weumi, “Riyeube a mayae isaeyeiboi sele! Na huluinye Reyae beko yae enaisemokonde u mekai enaimokoyebe nane merau enaisehombonde wanen enaisokobe?” ");
INSERT INTO set_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nda bee yae weinye, “Meyae na hului!” Yesus yae weumi, “Na helebe eleube, Reyae beko yae enaisemokonde u mekai mare enaimokobe, enaisehombonde wanen enaisokobe. ");
INSERT INTO set_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nebeibe, anuwau meubene meline bele Raei bokone enairombonde yo, Reyae ewaheikoi sului. Nebei naeise Allah yae mokoungehake wahemmikondere.” ");
INSERT INTO set_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Hokolo bee yae Yesusre riwoinye abe na moisa orowate yo me bee hiwa borowatene, Yakobusle Yohaneslere ikele yae kowaimi. ");
INSERT INTO set_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Nebeinye Yesus nebei yo nemene kaeneumikoke mo, weumi, “Mayae maisaei nda kanina kelana ro miyae yunde nekate yo na ro miyaere me boi u boi koyaimi, nane wanen nebei yun naei yun-jun yo yae nare moi hureyaimi. ");
INSERT INTO set_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mayae nebei mekai omokoijae! Mai nolona nde kabande yembondere konde kiyae, hiwa yo naei yebaei bubaei wanen mae yembonde. ");
INSERT INTO set_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nane merau nde mai nolona bereise wanen mae nekendere kena konde kiyae, mai yebaei bubaeise yembonde hele. ");
INSERT INTO set_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Raei wali erembo! Reyae, Allahle bokora mekale ro miyae uware yeubokale Kiyae, Rare mokonaiselere mekale ban. Reyae yebaei bubaei wanen mekale, nane merau ro miyae helende hole molorebonde naeise Raei wali isemile.” ");
INSERT INTO set_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ewate Yerikho yone aibaleke. Na heki ban mo, Yesus na moisa orowate yo bele nane merau ro miyae helen hokoumeke bele nebei yora maibaleke mewate mo, ro mbai na ijoko kumba nibi enene nuweuboke a na hebaen-sebaen riwole. Na ro Bartimeus, Timeusle fa. ");
INSERT INTO set_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Borole Yesus Nazaret yona ro mele, nobaeinyekoke mo kaenele, “Yesus, Daudle kelu, rare yanekoi yase yae ei aufele ya!” ");
INSERT INTO set_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nebeibe Yesusre hakainyekoke mate ro miyae helen mae a elae hele yae hilembondere uwainye. Nebei a hun kolainyere oboroi, a elae hele kaenele, “Daudle kelu! Rare yanekoi yase yae aufele ya!” ");
INSERT INTO set_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesus hebeunguke mo weumi, “Nebei ro kaenennoko meu.” Nda ro miyae helen Bartimeusre kaenewainyele wainye, “Wa kenabe elae rowei! Ainyu! Yesus Naei bokore elere kaenete!” ");
INSERT INTO set_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nda ro u hale me hale naei malo uware feleuboke raka kiyae ruboungeboke aunguke Yesusle bokore eke. ");
INSERT INTO set_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesus yae hineunge, “Waei kena koyae rahebe ware mokoreibotere?” Nda ro ijoko kumba yae weunge, “Guru, reyae ijokore ererelere kena kale.” ");
INSERT INTO set_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesus yae weunge, “Ninae eye! Wa hila rabo haleyae yae ware onomi ikete.” Are ukeunge hee yae na hibi na ijoko erewole. Yesus ewole moisa mo hakouboke orayeke. ");
INSERT INTO set_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesus naei Yerusalem yore nobewainye mo, nebei eke nibina yo bee hele Betfage bele Betania bele Zaitun moko enene honate. Nebeinye Yesus na moisa orowate yo ro bee ukeumi Betfagere ekete. ");
INSERT INTO set_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Yesus yae nda ro beere weumi, “Mai bena yo eke honolere ebu. Nebei yone ebeubobe mo, keledai mbai ha yae wokainyelebe hanennele. Nebei keledai ro miyae yae na uwa ranne ehebeinyui mo. Nebei keledai ha bulaerenebobe yawenehobe mebe. ");
INSERT INTO set_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ro yae miyae yae hinenayebena, ‘Rahere nebei keledai ha bulaerenebobere?’ mayae bee weumile, ‘Aei yun kena koukokene, na heki ban mo menenjembe.’ ” ");
INSERT INTO set_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nda ro bee ekete mo, Yesus yae ukeumi wanen hubayeikoke. Keledai kelu nibi kaban enene imae romau bene ha wokainyele hebewole. Nebei keledai hare mo bulaereinyeboke. ");
INSERT INTO set_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nebeinya ro miyae hebate nda beere hinaimi, “Rahere mokoneboberene nebei keledai na ha bulaereungele?” ");
INSERT INTO set_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yesus yae ukeumi hului yae hokolo bee ukeimine, nebei ro miyae ehe kaimikoke nebei keledai yawainyehoke ewate. ");
INSERT INTO set_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nda keledai Yesusle bokore yawainyehoke ekate. Naei malo keledai moko ranne baikokera mo Yesus na randa yeufebeunguke. ");
INSERT INTO set_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ro miyae helen bolen mewate. Hiwa na malo nibine bewate, hiwa na buro kelana o maensa na fae bele yae insewate nibine alowate. ");
INSERT INTO set_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bere ate yo moisa mate yo nemene fomene kaenate, “Men, Allahre buma koloman! Allahle ro yae meke Kiyaere foi moi helen barannele! Aei yobe Daudle yo wakube annununde! ");
INSERT INTO set_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nebei yo waku foi moi baranne! Allah na bumana hele! Men, Nare buma koloman!” ");
INSERT INTO set_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesus naei Yerusalem yone ayeuboke Allahle ei mom-mom imae na kaban sele kiyaene eweufike. Nebei imae ei ewerekoke mewerekoke wa eukuke. Be bahewolene na moisa orowate yo me bee oro nen bee bele kulun ukate Betania yore ewate. ");
INSERT INTO set_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Rene ya heuboke Betania yora Yerusalem yore alainyekoke ewate. Nibine ewate Yesus moni hubawounge. ");
INSERT INTO set_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Yesus nahaufa erele nibi enene ara no mbai fae yae houngeboke. Nobaeinye wa ijoko robounge nda ara no ani bele era, nebeibe na no kelaeunge mekate bae ani mbai ereiboi sele. Fae bangka mo erele, rabuhine ban nebei hee ara no ani omokoinye. ");
INSERT INTO set_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yesus nda ara nore weunge, “Waeinya anibe ro miyae anenainyende bele!” Nebei a eleukoke na moisa orowate yo borowate. ");
INSERT INTO set_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nebeisa ekate Yerusalem yone mo, Yesus Allahle ei mom-mom imae na kaban sele kiyaene eweufike, nebeinya huba raweuboke ro miyae naise hewate yo hukeweumi balayeke. Yahudi naei ban roi ijarowate Yahudi naei roi yae ibewaimi yo naei rambun koloi-koloi bele, aye merpati naise hewate yo naei anuwau bele nemene kou wae beumiyeke. ");
INSERT INTO set_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Hire hare ewaeisi naei naise haete rambun bele nebei Allahle imae eisa eyaroi ei. ");
INSERT INTO set_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nebeisa Yesus nebeinya ro miyaere kelewoumi, Allahle yenjo kayaayo yae homo molaikokebe huwewaimi, “((Allah yae elele,)) ‘Raei imae obe nda kanina nemene ro miyae ebeli boi-boi anuwau wae enayelende.’ Nebeibe mayae mokaungeboke ‘yoko yo naei nalere yeuboke.’ ” ");
INSERT INTO set_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Imam yun-jun bele Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi yo bele nebei a boraiboke, nebeinye Yesusre honaibondere nibi baewate. Nebei holona Yesusre fe yae faewainye, rabuhine ban ro miyae nemene Naei a kelewoumire fa yae bowate. ");
INSERT INTO set_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Be bahewole mo, Yesus na moisa orowate yo bele Yerusalem yora aibaleke ewate. ");
INSERT INTO set_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Na rene hele, wenana nibi relahira bukaiboke ewate bae, na moisa orowate yo yae erewate bae, nane ara no kalaukoke, na kambune bele oke. ");
INSERT INTO set_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petrus wenana yeuboke bene nekeungehikene Yesusre weunge, “Guru ijoko ereibone! Olomore neungebokae ara no kalaukoke ya.” ");
INSERT INTO set_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesus yae weumi, “Na helebe wamale, Allahre mo hila rabo halennelena, ");
INSERT INTO set_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","mai kena wauwau banna, elengkombe a na hele yae hila rabo halembena, nda elu na hului wennele, ‘Raweibo naubune etuwe!’ Allah yae nebei mekaise mokonde benate yakanate. ");
INSERT INTO set_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nda abe bene nekenayembe: Mayae ebeli embombe, riyennehimbe rambun inyembere hila rabo elae yae halembe hele, nebei heere Allah enenjembe. ");
INSERT INTO set_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nane merau weyae ebelire eungebonderena, wa kena einye hire kena ikele kanaena, nebei ro miyae naei beko bako mokoubokete u benera nundeneikote wa Arai Allah surgana nekele waei beko bako faeinyeneibote. ");
INSERT INTO set_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ro miyae hi naei beko bakore u benera enundeikoinya, mai Arai surgane ekenekele Kiyae nane merau waei beko bakore efaeinyeiboi.” ");
INSERT INTO set_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesus na moisa orowate yo bele Yerusalem yore bukaiboke ekate. Yesus Allahre ei mom-mom imae na kaban sele kiyaene orowole mo, imam yun-jun, Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi yo, Yahudi yun-jun Yesusre erekainyelene nebeinye na bokore mekate. ");
INSERT INTO set_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Nda yo yae Yesusre hinewainye, “Ndele ro yae nda rambun nemene mokoyae? Wa kenare koyae huluibe mokoyae?” ");
INSERT INTO set_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesus yae beumihoke weumi, “Reyae nane merau mare are hinerensimbere. Mare hinerensimbe mayae wo konsekombe, nebeisa mo mainya a hinaufehike, ‘Ndele ro yae Reyae nda rambun wanen mokale’ Reyae ufembe. ");
INSERT INTO set_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Reyae mare hinemale, ‘Yohanes bu koumi kiyaere nde yae ukeungele bu kowoumile, Allah yae, nda ro miyae yae?’ Mayae wo konseko!” ");
INSERT INTO set_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nebei yo nenaei mo kolowainye wa elate, “ ‘Allah yae ukeunge’ a yae umande bae, bensonde wemmele ‘Rahene Yohanes bu kowoumire na helere eleikoi kowaube?’ ");
INSERT INTO set_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Nebeibe yabi-yabi hele ‘ro miyae yae ukainyele mokowole yae’ umanderebe, rabuhine ban ro helen miyae helen mae Yohanesre yendo kayaalo hele elate. Meyae nare fe faemmile.” ");
INSERT INTO set_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nebeinye wainye, “Meyae isian.” Yesus yae nebei yore weumi, “Nebei wanenna, Reyae nane merau mare eyakaiboi nde yae ukeufe nda rambun nemene mokale.” ");
INSERT INTO set_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nebei Yahudi yun-junde Yesus ahumbo-ahumbo a yae ahuneuboke weumi, “Ro mbai anggur heke mokoubokere, ruka ele yae neuboke, anggur bure ramenate naei a bulu waeuboke, kayaare hebenate naei anuwau mokouboke, roi yae mokonate yore nda anggur heke kinyeumibokera, kulun uke kolore ewole. ");
INSERT INTO set_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Anggur anire hokonate hee yae, naei kayeere yarongkonde naeise nebei heke rorele naei yebaei bubaei ukeunge hekere mokowate yo bokore eke. ");
INSERT INTO set_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nebeibe heke yo yae nda rore ikilaiboke, erahuae baikoke, na me bangka yae ukainyele beufoke ewole. ");
INSERT INTO set_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Heke rorele benen naei yebaei bubaei hire ukeunge eke. Heke yo yae na yunda baikoke, fe mokainyeboke, hukainyehike ewole. ");
INSERT INTO set_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nane heke rorele ro name nendo ukeunge ekere haiboke. Nebei moisa uwoumi ewate yo hiwa erahuae bayeke, hiwa hoi-soi yae hayeke. ");
INSERT INTO set_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Heke rorele na imaene mokowate yo erewole oloo haloo, naei kelu mbai sele kenare kounge kiyae mo nekewole. Nebeinye na kelure ukeunge heke yo bokore ewole. Heke rorele na u bene nekewainye naei fa wanenne heke yo yae nare ei molonainyele era. ");
INSERT INTO set_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Eke bae, heke yo yae erekainyele mo elate, ‘Nda niyae heke rorele naei rambunde kinyennele hakennele kiyae. Men homabon, nebei nibi yaere nare kinyennele rambun aeise inyaibonde!’ ");
INSERT INTO set_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Heke rorele na kelure mo heke yo yae ikilaiboke, haiboke, na uware mo anggur heke ele moise kainyehike eke.” ");
INSERT INTO set_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nebeise huwekokera mo Yesus yae hineumi, “Nda heke rorele na kelure heke yo yae haiboke a borombonde heene, rahebe heke yore mokommile? Mensongkonde hele nebeisa nda anggur heke hiwa yore kinyenemibonde mokonate. ");
INSERT INTO set_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Mayae Allahle homofae are isaeyaeuboke. Neinye Reyae ruka bele a ahuneuboke, nda wanen moloukoke, ‘Imaere haetena ruka mbai beko yae elaeikoke wokatebe, mana nebei ruka yae bereise yeuboke. Neyae nebei imaere kaeuboke. ");
INSERT INTO set_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nebei me u Allahle reufira mokouboke, aei ijoko bene foi eme wanen yeuboke.’ ” ");
INSERT INTO set_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Boraikoke yo isaeyaeiboke neyae heke mokate yo bele nane merau imae haete yo bele a ahuneuboke huwewoumine, Yesusre ikilenaibondere nibi mahi-mahi baewate. Nebeibe ro miyae helende fe yae faewaimine, nebei anuwaunge Yesusre nukainyeboke ewate. ");
INSERT INTO set_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","((Nebei Yahudi yun-jun isaeyaeiboke Herodian holona yo kelaeimi pajak roi pemerintahre inyainyele hele, nebeibe Farisi holona be ehineiboi. Nebei aerene)) Farisi holona bele Herodian holona bele ukaimile walangka wanen yembonde Yesusre are enainyehinensindere. ");
INSERT INTO set_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ekate mo, Yesusre hinainye, “Guru, meyae maeisaei sele Waei afaeu na ijenne mo eleyeyae, ro miyae naei kena yon-jonde ban. Allah kenare kole afaeu Weyaebe ijokore ereyei weyamae. Nebeinye riyaeyete a na ijen mae weumelere, pajak Ondofolo Kaban Kaisarre imanelena nebei me u foi, beko? ");
INSERT INTO set_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nebei pajak imanele hele, eyei yae?” Yesus nebei holo bee naei ame-ame isaeyeubokene, weumi, “Na yaka mayae umalibe hubaufe. Roi perak mbai kelensebo!” ");
INSERT INTO set_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nebei yo perak mbai kelaeinyeboke. Yesus ereuboke mo hineumi, “Ndele u nulu bele ro belebe honate?” “Kaisarle” neyae wainye. ");
INSERT INTO set_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesus yae weumi, “Nebei wanenna Kaisarle kayee Kaisarre yennele, Allahle kayee Allahre yennele.” Nebei a merau boroukatene fa yae bowate. ");
INSERT INTO set_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nebeisa Saduki holona yo, herewate yo benen ewaleiboise elewate yo, Yesusle bokore mekate mo hinewainye, ");
INSERT INTO set_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Guru, Musale walora wali heere folaikoke homofaene nda a moloukoke: Ro mbai na aka baeke na fa ban mae herendena, na miyae nale rowende naeka hereke kiyaele orona menare holensindere. ");
INSERT INTO set_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Na ako naka mbainya kelu mehine bee hele. Bena kelu miyae rouke fa ban mo hereke. ");
INSERT INTO set_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Na kelu bee nendo naekale miyae nale bele nekeikoke, naekale wanen fa ban mae hereke. Kelu name nendone naei mekai yeuboke. ");
INSERT INTO set_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nda kelu riyana fa ban mo yae heraikoke, na huba mokoikoi nda miyaebe hereke. ");
INSERT INTO set_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Na hele hereyate yo walenaibondena, nda kelu mehine bee bele nane miyae bele nekaikokena, ndele miyaere yembonde?” ");
INSERT INTO set_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesus yae weumi, “Homofae yolo-yolone molaikoke, nane merau Allah elae wake naeisa mayae isaeyeiboinye nebeinye onaeube. ");
INSERT INTO set_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Rabuhine ban herewate yo walenaibonde hee, ro miyae eyaroi miyae rore ei. Surgana malaikat wanen mae inyaibonde. ");
INSERT INTO set_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na hibi ro miyae herewate yo benen walemmile naei, Allahle Yendo Kayaalo Musa homone moloukoke mayae okoikoinye? Nebei homone isa folon i bewole reufira Allah a uwounge, ‘Reyae Abrahambe Allah, Ishakle Allah, Yakuble Allah yeubokale.’ ");
INSERT INTO set_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nebei Allah here yo naei ban, neyae wali yo naei Allah. ((Nebei aerene na yaka yeuboke nebei yo waleumikoke.)) Mai u bene ma beko helebe nekayembe.” ");
INSERT INTO set_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Saduki holona yo bele ane huwate hee, Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi ro mbai meke borowoumi. Nebei a Yesus na ijenne mo wo kowoumine, nda ro Yesusre hineunge, “Allah yae Musare ukeunge wali heere foloukoke honate a nolona makei kayeero na bereinya hele?” ");
INSERT INTO set_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesus yae weunge, “Na bereinya nda niyae, ‘Israel borom! Aei Tuhan Kiyae, Allah, Neyae Tuhan nembai sele, hi hi u hele. ");
INSERT INTO set_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Allahre buhae hennele, mai kena ura, mai u bene wa benera, mai elae wakera.’ ");
INSERT INTO set_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na bee nendo, ‘Waei uware heungele ma wangkele wali nibi mbainye oroyaube yore heumiyende.’ Nda beera hi berei wanende u hele.” ");
INSERT INTO set_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi ro yae weunge, “Guru, na ijen selebe eleyae Allah nembai sele, hi ha ehameikoi. ");
INSERT INTO set_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nebeinye ro miyae Allahre kena buhae na kena u nemene, na u bene wa bene nemene, nelae wake nemene hennele nebei sului mbai naei uware hennele wanen mangkele wali nibi mbainye oroyaube yore hemmiyende. Nebei u mekai naei berei sele, aei hili era akau era mahi-mahi Allahre ongkou wae felemangkonde na moinya.” ");
INSERT INTO set_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesus erewounge nda kiyae na ijen roukokene, Yesus yae weunge, “Raei me kelee u keleene nekate yo holone euwende naeise weyae ahau ban sele.” Nebei heera ro miyae hiwa are hinenainyelere fe yae kowate. ");
INSERT INTO set_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Allahre ei mom-mom imae na kaban sele kiyaene kelewoumi yae, nda a Yesus yae weumi, “Naendae wanen mae Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi yo yae elate, ‘Wali Ondofolo Daudle orona mena’? ");
INSERT INTO set_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Era bae Daud nenaei yae Allahle Roh aungebokene eleukoke, ‘Allah yae raei Tuhan Kiyaere weunge, meube reufine mei nuweibo, wa yokeijo nemene mokoremibonde Waei oro kele me kelene mo menai orulembonde?’ ");
INSERT INTO set_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Daud yae Wali Ondofolore ‘Tuhan mae’ elelene, eyae Nare Daudle orona mena mo yae eleikoi sului!” Nda ro helen miyae helen Yesus keleumire kena hele kate. ");
INSERT INTO set_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesus nebei yore kelewoumi mo weumi, “Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi yore kayaa-kayaa hebembe. Neyae malo koukou foi sele hirate, nai hei-seise haete anuwaunge orate, bere hinenaimilere ibaewate. ");
INSERT INTO set_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Neyae Allahle imae einye bele raman bulau anuwaunge bele rore ronaimibonde anuwaufe ibaewate. ");
INSERT INTO set_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Miyae nannale naei rambunde yaronatere ame-ame yae beyaimire yaroyate, nebeisa ro miyae bene ebeli heki kaeu-kaeu hele ibowate. Nebei yore ehee bukulu kaban emmiyende hele.” ");
INSERT INTO set_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesus Allahre ei mom-mom imae na kaban sele kiyaene roise hawate anuwau kelaeunge raiboke nekewate yae, Yesus ijoko neumiboke erewoumi roi helen holona yo roi helen sele hawate. ");
INSERT INTO set_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nebei nolone miyaenale mbai naei roi auboke, tembaga roibe fele-fele hele. ");
INSERT INTO set_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesus na moisa orowate yore kaeneumikoke mo weumi, “Na helebe wamale, ndi anuwaunge hawaikoke yo nolora ndi keren ban nale ban miyae ken helen sele auboke. ");
INSERT INTO set_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Rabuhine ban, ndi yo helen honaiminabe mekaisawate. Nda miyaenale honainye hului nanemene hele mewauboke.” ");
INSERT INTO set_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Allahre ei mom-mom imae na kaban sele kiyaera Yesus naei maibaleke ewate mo, na moisa orowate ro mbai yae weunge, “Guru, nda imae obe hebele ereibo! Na ruka foi sele ahunewate, yalaeinyeboke hele!” ");
INSERT INTO set_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesus yae weunge, “Ndi imae obe kaban-kaban mokainyehake hebate ereyae? Nanemene kerenaisonde ruka hi ran hi ranne ahungkoi hononate.” ");
INSERT INTO set_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Zaitun elune ikate. Yesus nuweuboke na ijoko nebei Allahre ei mom-mom imae na kaban sele kiyaere erewole mo, Petrus, Yakobus, Yohanes, Andreas, nenaei mo Yesusre hinainye, ");
INSERT INTO set_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Maere yakaimebona are eleukoke nanemene makei hee yae enaibende? Nebei naeise rahe iwau ma rilende?” ");
INSERT INTO set_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesus yae weumi, “Kayaa hebembe, ro miyae hiwa ame-ame yae wabenayengkombe bele. ");
INSERT INTO set_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ro miyae helen menate ame-ame yae elenate, ‘Reyae Wali Ondofolo, Allah yae ukeufe mekale.’ Nebei yo ro miyae nekai sele ame-ame yae wabenaimile. ");
INSERT INTO set_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Buloo fela kulun relennele nane merau a yo-yo buloo fela kaenainyebonde naei emborombe yane buhae ohokoijae. Nda wanen nemene inyaibonde hele. Nebeibe nebei huba mokoikoi ya ban. ");
INSERT INTO set_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nda kani kelana yo yan hi bele yo yan hi bele fela relenainyele. Onyeu, moni mai makeinye-makeinye benate, nebeibe huba mokoikoi ya namman, miyae hiyaunge fare honondere kole wanen ma bekore hubanainyele naei hengkelenbe raungehike. ");
INSERT INTO set_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Nebei hee kayaa bele yae hebembe, rabuhine ban Rare ehakoyei yo yae mare ikilenayengkombe, yo riyare kinyenayembombe, mai wali ijoko erenayengkombere. Ei mom-mom imaene erahuae yae bonayembe. Rangkele mbainye nekandene yaungayembombe gubernur yoni-yoni bene ondofolo yoni-yoni bene embe. Nebei hee yae mon rowembe Raei a foi faeu foi wemmile. ");
INSERT INTO set_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nane merau huba mokoikoi ya emei yae Raei a foi fae foi nda kani kelana nanemene hungaimile hele. ");
INSERT INTO set_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mai wali ijokore erenayengkombere ikilenayembene, emelengkombe are buhae ohokoijae. Nebei hee Allahle Roh yae u bene yakanembe hului a yae elengkombe. Nebei a elele waei a ban, Allahle Roh waei euwa walora elele. ");
INSERT INTO set_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","13","Rare hakonsebombe aerene ro miyae helen mare ikele konayembe. Ro mbai na aka baekere enaisombonde naeise kelai nenende, nane hului mbai naeko yae na kelure. Kelu omi hiwa naeko nenakere angkaei oboroiboi konate, ro miyae hiware ungaimile honate. Nebeibe kena yae heraungayende Raei elele are hila rabo halenayende ro miyaere hole eremolombonde. ");
INSERT INTO set_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Nebei ya mende heene ‘ro nansau fele kiyae’ heere naisake anuwaunge mensebenunde. Nda ro Allahle bene na beko hele nane merau Allahre ei mom-mom imae na kaban sele kiyaene u mekai u nene ma mokonnebonde. Nebei hee Yudea kanina ro miyae elure mo habelemembe hele. (Mayae nda homofae kombe yo isaeyembombe!) ");
INSERT INTO set_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nebei ro nansau beko helen mokombondene, imae kelaeunge nekaube yo mai rambun roweise imaere eijae. ");
INSERT INTO set_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Hekene mokonate yo na malo roweise imaere ebukeisi eijae. ");
INSERT INTO set_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Nebei hee bendene, emale miyae bele wayeu miyae bele beko hele hubanainyele. ");
INSERT INTO set_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Manse hele yembonde bele naeise ebeli bombe, ");
INSERT INTO set_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","rabuhine ban beko hele rambun benate. Nebei beko bako hubanainyehinde Allah nda kani kela mokoubokera meke nda hee nda waline eyeiboi mo, nane merau benen eyeiboi mo honenende. ");
INSERT INTO set_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Allah yae eleukoke holona holere molommibonde aerene bekore hubanainyehinde ya fofo mokonnebonde. Nebei mekai omokoiboi yae walire nekande yo hi yae ha yae wali orowei. ");
INSERT INTO set_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Nebei hee yae hiwa yo yae elenate, ‘Ereibo, Wali Ondofolo ndina nare, ndana nare!’ Mare ungayembena, nebei are na hele yae eleijae. ");
INSERT INTO set_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Rabuhine ban, na hele ban wali ondofolo holona bele na hele ban yenjo kayaayo bele menaiyakambonde, rambun emere-emere mokonate, Allah yae eleukoke holonare ame yae wabenaimihinde balenatere, nebeibe na hului ban. ");
INSERT INTO set_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Namman eyeiboi yae, Reyae na bere holo yae nanemene isaeyaemale. Nebei mekai yae mauwa kayaare hebembe. ");
INSERT INTO set_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Allahle homofaene ya beko huba mokonnekonde naeise nda a moloukoke, ‘Hu hehe wende ouben yembonde, oko na hehe kebengkonde, ");
INSERT INTO set_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","findelau yoni-yoni yakura balenate onate, yakuna elae wake Allah yae kusemmikonde.’ ");
INSERT INTO set_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nebei hee yae ro miyae erenaisele Reyae, Allahle bokora mekale ro miyae uware yeubokale Kiyae, elae wake bele one hengko bele kitenaisebonde mangko eisa merele. ");
INSERT INTO set_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nebeise malaikat ufemile enate Allah yae eleukoke wekeumi holona yore nda kani kelana makeinya-makeinya nemene arilenaimihinde. ");
INSERT INTO set_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ara none mo isaeyembe u bene yarombe. Yahudi kanine ara no na maensa-maensa ereiboyate rimi-rimi ibewate bele onsi efawewate belene mo, neyae isaeyeiboyate rolonsan wenjendere yabe nobeungekoke. ");
INSERT INTO set_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nebei sului mbai nda a wamale wanen mae erembe benatena, mayae isaeyembombe Reyae benen merele ya nobeungekoke hele. ");
INSERT INTO set_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Na helebe mare wamale, nda hokolo namman ehereiboi mo nda a elale nemene menaibende. ");
INSERT INTO set_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yaku bele nda kani kela bele enainundembonde, nebeibe Reyae wamale a na hibi mo hononayende. ");
INSERT INTO set_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Na huba mokoikoi ya hului hu hului raungehikere surgana malaikat yoni-yoni bele, Reyae Allahle Kelu bele, nde nde nanemene isian mo, Allah nembai ken naeisaei. ");
INSERT INTO set_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nebei yare mayae isianne kayaa-kayaa hebembe. ");
INSERT INTO set_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kayaare hebate u mekai nda wanen mae a ahunemabon: Ro mbai kolore enderene, naei imae einye kaliare mokate yore naeise naeise waheumikoke. Romau kayaana kiyaere a elae bele rorounge foi yae hebende. ");
INSERT INTO set_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","“Nebei mekai Reyae berehonde merelene ijongkune honombe yae hubaimakonde belene mayae kayaa hebembe. Rabuhine ban nebei imae rowa berehonde wanen Raei merele hee isian nekaube, huae yae, reniai yae, ojo konate hee yae, ya hembonde yae. ");
INSERT INTO set_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nda a faeu mare wamale hului mbai ro miyae nemene ufemiyende, ‘Kayaa bele yae mo hebembe mai wali mokaungehake yae nekemembe!’ ” ");
INSERT INTO set_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ya bee nekenaikonde mo Yahudi naei Paskah ya kaban bele feu ragi banne ohuleiboi anate bulau ya kaban belere konatere. Imam yun-jun bele Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi yo bele nibi baewate Yesusre na maleu-maleu wae ikilenaibonde mo na hibi honaibonde. ");
INSERT INTO set_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nenaei yae elate, “Akube yembonde belene, ya kaban komale yane omokoijae.” ");
INSERT INTO set_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Nebei hee Betania yone Yesus Simon bere u bauwaufe koukoke kiyaele imaere eke. Eramanne anewate yae, maengke mbai na mene minyak narwastu fololo kaei bele botol mbai rouke meke. Naise hembondena na roi bumana hele. Walambare mo uke kayeukoke nebei narwasture mo Yesus Na yunne rileungeboke. ");
INSERT INTO set_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nebeinya mekate yo hiwa na kenara ikele yae katene, hi yae hire weunge, “Rahe londe nda minyak narwastu meke heraeyele! ");
INSERT INTO set_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Roise heuboube bae kalia ya 300 mokokoube na roibu moi wowoube. Hun ban wai ban nekate yore na hului wahaeimikoube.” Nebei aerene nda maengkere a usaei elae yae uwainye. ");
INSERT INTO set_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nebeibe Yesus yae weumi, “Rore ronainyele u mekai foibe Rare mokoufeboke. Rahere kena beko mokaunge? Waennihi! ");
INSERT INTO set_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Hun ban wai ban yo mai nolone nekenayendene, mayae hakommilerena, hakommiyembe. Reyae bae mangkele na hibi mo enekei ya! ");
INSERT INTO set_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nda maengke naei mokouboke ma ninae mokouboke. Na ya namman mae Raei uwa molonaisehande naei bele minyak fololo foi yae ninae mokoungehake. ");
INSERT INTO set_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Reyae wamale, nana hesele nda kani kelane makeinye-makeinye Raei a foi faeu foi yobonnende, nda maengke yae mokouboke u mekai bene nekei-nekeise enaitonde, enaisuwende.” ");
INSERT INTO set_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yesus na moisa orowate yo me bee oro hi nen bee bele nolona hi na ro Yudas Iskariot. Neyae Yesusre kelaise nenendere imam yun-jun bokore eke. ");
INSERT INTO set_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nda a mekai boroukatene rei mai sele kowate, roi yae inyainyelere a hokaikoke. Nebei heera Yudas kinyemmibondere monne baewole. ");
INSERT INTO set_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","((Mesir kanine Allah yae Yahudi naei bena kelu fa-fare hole moloumiboke u bene nekeisi-nekeisi)) ya kaban Paskah feu ragi banne ehuleiboi yae eyanewate nane merau na ya mbai nendo domba kelu mbai Allahre ongkou wae ifelewainye. Nebei ya kaban naeise Yesusle moisa orowate yo hinainye, “Waei kena koyae makeinye Paskah naei raman waei kayee mokomansandere?” ");
INSERT INTO set_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nebeinye Yesus na moisa orowate yo ro beere weumi, “Yerusalem yore ebe. Nebei yone ebebobe mo ro mbai bu habuna bele kaembonde mende hubayengkombe, na moisa hakonnekobe. ");
INSERT INTO set_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Imae mbaise enensinde. Nebei imae na rorelere wennele, ‘Guru yae hinele, Ra moisa orande yo bele Paskah bulau eraman nanembainye anemakondere, makei yowabe mokoungehakae?’ ");
INSERT INTO set_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Yaungeubobe embe mo imae raka bee nendo na anuwau kaeu-kaeu na hului-sului mokainyehakebe kelenebobe. Paskah bulau naei raman aei kayee nebei anuwaunge anemakonderene, nanemene mokonnehabe.” ");
INSERT INTO set_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Hokolo bee yore eyeuboke. Nebei yone hubaiwote nanemene Yesus yae are eleukoke huluinye mo bewate. Hokolo bee Paskah bulau eraman naei anenaikondere mo mokoinyehake. ");
INSERT INTO set_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Huae mo Yesus na moisa orowate yo me bee hiwa yo bele nebei anuwaufe mekate. ");
INSERT INTO set_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ramanne nuwaikoke anewate yae, Yesus yae weumi, “Reyae na helebe wamale, ro mbai mai nolona raei kelaise nenende, nda hee nangkele eraman mbainye anande.” ");
INSERT INTO set_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Na kenara beko wanen hubainyene, Yesusre naeise naeise hinainye, “Tuhan, reyae niyae ban, era?” ");
INSERT INTO set_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesus yae weumi, “Nebei ro mayae ro me bee oro nen bee bele nolona, rangkele feu kolaei mbainye yawakonde. ");
INSERT INTO set_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Reyae, Allahle bokora mekale ro miyae uware yeubokale Kiyae, homofaene molaikoke huluinye Raei uwa ereherende. Nebeibe nebei kelaise nenende kiyae beko hele hubannende. Naei foi sele nda kiyae ohonoi yae nekeube.” ");
INSERT INTO set_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Anewate mo, feube Yesus rouke, Allahre helen foi ukeungelera nebei feu me yae kayele na moisa orowate yo waheumi, na a bele weumi, “Nda raei uwa, yaron anen.” ");
INSERT INTO set_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nebeisa kolaei anggur bu bele rouke. Allahre helen foi ukeunge, na moisa orowate yore ikeumile, nanemene nda kolaeinya bu yae anewate. ");
INSERT INTO set_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nebeisa Yesus yae weumi, “Nda Raei ha niyae. Ro helen miyae helen aerene ererilembonde. Nda ha yaere Allah are heteungekoke nibi neme, ro miyaere wali himalainyeboke yo yae me baemmile nibi, elaekei yeuboke. ");
INSERT INTO set_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mare wamale, nana hesele Reyae nda anggur bu aneisi mo nekerende, mende Maeko mokommibonde ro miyae Raei me kelee u keleene orulenaibonde nekenate. Benen nebei ro miyae Rangkele nanembainye anggur bu anemahinde.” ");
INSERT INTO set_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Paskah bulau eraman naei anaikoke baeufoke, a koi-koi a bulaunge Allahre buma kolainyekokera, Zaitun elura ewate. ");
INSERT INTO set_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nebeisa Yesus yae weumi, “Reyae raeisaei nekale mayae nemene ma fere-fere hakangkombe rare nukensebombe, rabuhine ban nebei naei Allahle yendo kayaalo Zakharia yae Raei naeise homone moloukoke elele, ‘Allah na domba kayaa rore hombonde, nane domba riyana here ware molombonde.’ ");
INSERT INTO set_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nebeibe nulu yo mahe yora ansenundera Reyae bere holo yae Galilea kanire erele.” ");
INSERT INTO set_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petrus yae weunge, “Naendae wanen horo nemene fomene Ware nukenayeukonde, reyae Ware enukeiboi sele!” ");
INSERT INTO set_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesus yae weunge, “Nda a na helebe wawale, na mana reniai ojo a roko bee okoikoi mo weyae roko name hele Rare isian mae weumikonde.” ");
INSERT INTO set_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Petrus a nana hesele hele yae weunge, “Naendae wanen horo lon reyae Wangkele nanembainye aherembonde, reyae Ware isian mae eleikoi sele!” Na moisa orowate yo hiwa nane a hului mbai elewate. ");
INSERT INTO set_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Anuwau mbai na ro Getsemani. Nebeinye Yesus na moisa orate yo bele aibaleke. Yesus yae weumi, “Ndine ebelire erembonderene mayae ndane rombo ba.” ");
INSERT INTO set_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Petrus, Yakobus, Yohanes ukeumile nangkele hakainyekoke ekate. Yesus buhae hokoungebokene na uwa kulu-kulu kowole. ");
INSERT INTO set_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Yesus yae weumi, “Ra kena beko hererele wanen mae hubanale. Nebeinye ndane mai uwa kayaa bele yae hebembe ijongku ohonoijae.” ");
INSERT INTO set_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yesus ahau holo eke mo, na uwa kani ranne eukuke Naekore riyeungehike hakonnebondere ");
INSERT INTO set_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Yesus yae weunge, “Arai, Raei Maeko, rahe rambunbe Weyae na hului ban? Beko hubarende belene Rare hole moloufebonde. Nebeibe Raei kena hului yae ban, Waei kenare koyae hului yae bende.” ");
INSERT INTO set_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nebeisa Yesus beufoke, hokolo name bokore meke ereumi bae ijongkune honate. Petrusre weunge, “Simon, ijongkube honoyae! Weyae na hului ban sele hukai mbai kayaare hebeukondere!” ");
INSERT INTO set_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Benen Yesus nda yore weumi, “U mekai beko yae wabenensimbe balembe belene, uwa kayaa-kayaa bele yae nane merau ebeli na hibi-hibi mo bonele. Mayae kena koyaube Raei a hakonsebomberebe, nebeibe mai uwa yambi hele yaeuboke.” ");
INSERT INTO set_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Roko hi eke ebeli nane a hului mbai boungehike. ");
INSERT INTO set_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Bukeufike meke bae, naei ijoko ehekaei selene hokolo name ijongkune honate. Yengkeumikoke bae, Yesusre ungainyele abe onaete handate. ");
INSERT INTO set_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Roko name nendo eke, beufoke meke mo weumi, “Mayae namman ijongkune honaube none yaube! Annu! Reyae, Allahle bokora mekale ro miyae uware yeubokale Kiyaere, bekore mokate ro miyaere kinyenaisebondere heebe meuyeuboke. ");
INSERT INTO set_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Eren, Yudas, Raei kelaise neke kiyae mele. Annu emalere!” ");
INSERT INTO set_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesus namman ane elele mo, Yudas ro me bee oro hi nen bee bele holona ro mele. Na moisa ro homo mbai imam yun-jun bele Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi yo bele Yahudi yun-jun bele yae ukaimile yo, ramiyaeli bele, o bohi-bohi bele mo mewate. ");
INSERT INTO set_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yudas, kelaise neke kiyae, a isaeyeumiboke weumi, “Yoi bulure hunerensinde kiyae na ro niyae, ikilembombe, felayo bele yae yawennehombe embe.” ");
INSERT INTO set_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Mekate bele na hibi hele Yudas meke Yesusre weunge, “Guru!” Nebeisa yoi bulure mo huneungekoke. ");
INSERT INTO set_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Yudas naei mekate ro homo mbai Yesusre ikilaiboke. ");
INSERT INTO set_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Na kelaeunge hebele ro mbai na ramiyaelire mo yobouboke imam kaban na yebaei bubaei na angkaeibe uke neufake. ");
INSERT INTO set_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","49","Yesus nda yore weumi, “Ya-ya Allahre ei mom-mom imae na kaban sele kiyae na imaehounge mai bene kelewamaelebe mayae rare ikileiboi mo. Mai u benera Rare yokolo yae elaukoke era. Raei ikileiboise ramiyaeli yae o bohi-bohi yae yaraukoke mekaube? Allahle yendo kayaalo Yesaya moloukokere waennihi na hului yeuboke.” ");
INSERT INTO set_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nebeisa Naei moisa orowate yo nanemene hakaikoke habelaeyeke, Yesusre nanene nukainyeboke. ");
INSERT INTO set_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ro hokolo fa mbai Yesusre hakowounge malo mbai mo lenan mokaiboke yae nauware feleuboke. Nda homona ewate yo yae nare ikilenaibondere, ");
INSERT INTO set_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","nebeibe na malore ikileuboke ro na mene nebei malo nukeungeboke, neyae na melan mae hakauboke ewole. ");
INSERT INTO set_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yerusalem yore ekate, Yesus yawainyehoke imam kabanbe imaere ekate. Imam yun-jun, Yahudi yun-jun, Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi yo, nemene fomene nebeinye arileufike. ");
INSERT INTO set_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petrus nahau holo Yesus imam kaban imaere yawainyehoke ewate moisa ewole, imaehoufe ewole. Nebeinye kayaare hebewate yo bele itukai kelaeunge raiboke inye akelewate. ");
INSERT INTO set_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Yesusre mere nonainyonde honaibonde naei abe, Yahudi naei yoyo koseyo nemene baete, reufi mbai imam yun-jun. Nebeibe a mbai sambai mere nonainyonde a ma ehubayeikoi. ");
INSERT INTO set_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ro miyae helen a ame-ame yae Yesus bekore mokonainyebondere huwewaimi, nebeibe naei ahuba na isohi-isohi huwewate. ");
INSERT INTO set_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ro riya mbai ainyuke Yesusre mere nonainyondere nda a ame-ame yae waimi, “Naei a nda mekai eleukoke borandeboke, ");
INSERT INTO set_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","‘Allahre ei mom-mom imae na kaban sele kiyaere nda ro miyae me yae ainyunuke Reyae kererensonde, imae hi nda ro miyae me yae ainyui kiyae na ya name mo na hului arennunde.’ ");
INSERT INTO set_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nda a ame-ame nokainyele bae nane merau isohi-isohi.” ");
INSERT INTO set_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nebeise imam kaban aunguke, Yesusre nda ro miyae arilewounge bene hineunge, “Ndi a faeu Waei randene mo nokayete, Weyae wore okoikoi!” ");
INSERT INTO set_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nebeibe Yesus a mbai sambai ewei, maleu mo hebele. Imam kaban benen hineunge, “Weyae Wali Ondofolo, Allah yae oro umaufe heraungeboke Wali Ondofolo, Allahle Kelu Niyae?” ");
INSERT INTO set_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesus yae wo koungekoke, “Reyae Niyaebe yae. Mayae nanemene enserembe Reyae, Allahle bokora mekale ro miyae uware yeubokale Kiyae, Allahle meube reufine nuwerebonde, yakuna mangko nolora merele!” ");
INSERT INTO set_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nda a wanen boroukokene, imam kaban u nene yae wa kolene na malo kanekokera, weumi, “Rahe naeise hiwa yo a elenaikondere! ");
INSERT INTO set_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Menaeijae boraube na uware Allah yae eleukoke, Allahle rore ane hele kolounge! Naendae wanen mae elaube?” Nemene fomene na bulau wae elate Yesus nauwa kabeukoke. Nebeinye na honaibonde hele. ");
INSERT INTO set_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Hiwa huba rawaiboke euwaeki yae howainye. Malo yae na ijoko felainyekoke, me rulu yae erahuae yae bate wa wainye, “Allahle yendo kayaalo yei! Roibona, nde yae ware wete?” Nebeisa kayaare hebewate yo anuwau hire yawainyehoke ekate mo, nangkele yae erahuae baikoke. ");
INSERT INTO set_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petrus nebei imaehounge namman nekele yae, maengke mbai imam kabanbe yebaei bubaei nebei nolore meke. ");
INSERT INTO set_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nda maengke Petrus inye akelewolere ereungekoke na be ijoko roungeboke wa weunge, “Weyae na hi niyaebe yae Yesus Nazaret yona Kiyae nanembaisa orowaube.” ");
INSERT INTO set_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nebeibe Petrus oneunge yae elewole, weunge, “Reyae onaele handale rahe a mabe haraungeboke warae.” Petrus aunguke aloungekoke imaehou romaufe endere yae ojo a koukoke. ");
INSERT INTO set_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nane maengke benen Petrusre erekeunge nebeinya nekewate ro miyaere weumi, “Ndi ro hi niyae Naei holo mbainye orowate.” ");
INSERT INTO set_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Nebeibe benen Petrus oneunge yae eleukoke. Na heki ban mo nebeinya hebate yo yae Petrusre wainye, “Weyae Galilea kanina rone, na hele weyae nebei holona na ro hi niyae.” ");
INSERT INTO set_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nebei mekai wainyene Petrus nauwara olomo rorole a na ikele u yae elele, “Reyae ndi ro onaenale!” ");
INSERT INTO set_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Petrus nda a mekai eleukoke heera ojo roko bee nendo koukoke. Petrus nebei hee yae Yesus yae nare ukeunge abe bene nekeungehike, “Ojo roko bee nendo a okoikoi mo, weyae roko name rare oneufekonde a eleukonde.” Petrus nebei abe bene nekeungehikene na kena moheuboke rime rimewole. ");
INSERT INTO set_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Na rene kaukau hele Yahudi yoyo koseyo nemene reufi mbai imam yun-jun, reufi mbai Yahudi yun-jun, reufi mbai Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi yo, nanembainye arilaisike Yesusre mokonainyebonde a hokaikoke. Nebeinye Yesus ha rinainyekoke, Gubernur Pilatusre kinyenainyebonderene yawainyehoke ewate. ");
INSERT INTO set_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ekate mo, Pilatus yae Yesusre hineunge, “Weyae na hele Yahudi yo naei Ondofolo?” Yesus yae weunge, “Na hele, wenaeijae eleukokae.” ");
INSERT INTO set_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Imam yun-jun eheere ungainyondere a mahi-mahi yae einyo meinyo Yesusre kainye. ");
INSERT INTO set_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Nebei aerene Pilatus benen Yesusre hineunge, “Weyae wore koukondere ahi yae eleyae? Boroyae, waei a helen sele ware ahunayete?” ");
INSERT INTO set_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nebei a elate mbai sambai Yesus wo okoikoi mone, Pilatus fa yae bowole. ");
INSERT INTO set_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Paskah roko yae roko yae kayekene, kawane isebewate yo ro mbai nebeinya ro miyae riyeisiyate huluinye Pilatus yae hayeikoyounge. ");
INSERT INTO set_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Yo hiwa na bere hee Pemerintah Romawi bele han fela kaikoke, ro miyae hiware haikokene, ikilewate kawane hebewate. Nebei nolone ro mbai na ro Barabas. ");
INSERT INTO set_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nda ro miyae Pilatusre mekai riyainye kawana hebate ro mbaise hayennekondere mokoimeyele huluinye. ");
INSERT INTO set_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Pilatus isaeyeuboke, ro miyae helen Yesusre hakoyainyene, imam yun-jun Yesusre kena hensen kowate. Nebei aerene Yesusbe kinyainyeboke. Nebeinye Pilatus nda yo helende hineumi, “Mayae kena Yahudi yo naei Ondofolo Kiyae haisengkondere?” ");
INSERT INTO set_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pilatus Yesusre hayennekondere, nebeibe imam yun-jun mae ro miyae helende moi hurewaimi Barabasbe Pilatusre rinyainyehinde hayennekondere. ");
INSERT INTO set_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatus beufoke hineumi, “Nebei wanenna Yahudi naei Ondofolore elaube kiyae rahebe mokorembonde.” ");
INSERT INTO set_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nda yo a bulau wae kaenate, “Ohaline bongko!” ");
INSERT INTO set_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatus yae hineumi, “Rahe bekobe mokouboke?” Nebei wanen bele bae nda yo kali ara nene kaenate, “Ohaline bongko!” ");
INSERT INTO set_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatus ro miyae helen kena foise mokommibonderene Barabasbe hayeungekoke. Pilatus ukeumile Yesusre erahuae baikoke, nebeisa felayore kinyeumiboke ohaline enaibongkondere. ");
INSERT INTO set_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Romawi felayo yae Yesusre yawainyehoke Gubernurle Obere ekate, felayo naei homo kaban kaenaimikoke mekate. ");
INSERT INTO set_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Aukakare konainyelere malo fi kolei ma yae Ondofolo hireikoyate wanen Yesusre wokainyele. Ondofolo-ondofolo yae fokoma obunayeke wanen isa bele yae huinyaikoke na yun ranne obunainyeboke, ");
INSERT INTO set_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ro melaeyainye, “Yahudi yo naei Ondofolo!” ");
INSERT INTO set_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Yesus na yun roko yae roko yae o bohi yae baikoke, euwaeki yae hainyeke, oro selen-selen mae bene hinainye. ");
INSERT INTO set_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nebei aukaka kowainye baeufoke mo, nebei malo fi kolei ma kaeinyeboke benen naei malo yae hirainyekoke. Nebeisa yawainyehoke Yerusalem yo moise aibaleke ohaline enaibongkondere ewate. ");
INSERT INTO set_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nibi nolone ewate yae ro mbai na ro Simon Kirene yona ro, Aleksanderle Rufusle naeko, yore enderebe felayo yae ikilainyekoke, a wake yae melewainyele nda ohali neyae kaembondere. ");
INSERT INTO set_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Anuwau mbai honole Aram afaeunge “Golgota” yae kaenewainye na mekai “yun bo”. Nebei anuwaufe Yesus yawainyehoke kitaijeke. ");
INSERT INTO set_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nebeinye ikate yae anggur bu mur yae alaeinyebokebe iwainyele anensindere na u buhae are ondere naeise. Nebeibe Yesus nebei bure ahi. ");
INSERT INTO set_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nebeisa Yesusre ohaline baikoke. Nda felayo Yesus na malore wahenaikondere ndelene ruwende, nebei naeise oye yae nihaeiboke wanen mokaiboke. ");
INSERT INTO set_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Rene hu ijoko mehine keline yae Yesus ohaline baikoke. ");
INSERT INTO set_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ohaline baikoke hereke naei aere na yun ranne homone molaikoke ukate. Nda niyae, ");
INSERT INTO set_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Yesus na meline meubene ro bee yokore kelaise rorayeke bele baikoke. ");
INSERT INTO set_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nebei mekai yaere Allahle homofaene moloukoke a na hului yeuboke, “Ro miyae beko nolone yae Nare me enaibaembonde.” ");
INSERT INTO set_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ro miyae nebei ijenne orowate yo aukaka helen kowainye na a bele uwainye, “Allahre ei mom-mom imae na kaban sele kiyae kelaubonde na ya name mo aungunundere eleukokae kiyae niyae! ");
INSERT INTO set_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Nebei a mekai elewekae lonbe, wauwa hole moloinyebo! Nebei ohali randa oyakoibo!” ");
INSERT INTO set_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nebei sului mbai imam yun-jun bele Musale walora wali heere foloukoke are kelewaimi yo bele naeise naeise aukaka yae kowainye elate, “Hiwa yore mo hole moloumiyeke, nauwa bae hole omoloiboi sului! ");
INSERT INTO set_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Wauware Yahudi naei Ondofolo nane merau Wali Ondofolo yae elewekae lonbe, mana ya na helere elemakondere maei ijoko yae eremayeibotere nda ohali bayeukokete randa oyakoibo!” Meline meubene baikoke yokoyo bee Yesusre nane merau aukaka kowoinye. ");
INSERT INTO set_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Hukai me bee oro hi nen bee bele nebei kani nemene ouben hauben meumifeleuboke honowoke oke huae rai hukai name yeuboke. ");
INSERT INTO set_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nebei hukai name yae, Yesus Aram afaeunge kaenele, “Eloi, eloi lama sabaktani” na mekai, “Raei Allah, Raei Allah, rahene rare nukeufebokae?” ");
INSERT INTO set_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nebeinye hebate yo borowainyene hiwa yo elate, “Borombo, Allahle yendo kayaalo Eliare kaeneunge!” ");
INSERT INTO set_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ro mbai u hale me hale eke hakalu bulu fele-fele bele rouke, anggur bu rileuboke, one neke, neungejeke Yesus anensindere. Nebeisa elele, “Raken! Ijokore eremambondere Elia mende ohali randa rowende hanembondere!” ");
INSERT INTO set_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesus ele kaenekokera na no u yeuboke. ");
INSERT INTO set_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Allahre ei mom-mom imae na kaban sele kiyae einya malo kaban hilowole reu bee kayeukoke, na bumara oke ane. ");
INSERT INTO set_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Yesusre baikoke ohali bene fela yun hebewole. Yesus ele kaeneukoke borouboke, na here ma erewolene, elele, “Nana hesele nda Allahle kelu!” ");
INSERT INTO set_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Miyae maengke hokowole nolone, Maria Magdalena yae, Yakobus hokolo fa kiyae na aka baeke Yoses nenake Maria yae, Salome yae. Nda wanen mokowainyelere nahaufa erewate. ");
INSERT INTO set_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nebei miyae maengke Yesus Galilea kanine nekewole heene Na wali rambun rikewainye hakowainye yo. Nebei anuwau hebatene miyae maengke helen hiwa Galilea kanira Yerusalem yore Yesus naei nanembaisa mekate yo. ");
INSERT INTO set_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Sabat ya kalia omokoi naeise, maehae mbai nenja rambun mokoisayainye. Nebeinye nekewate be bahewoke. ");
INSERT INTO set_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ro mbai Yusuf Arimatea yona ro na fe ban mae Pilatusle bokore eke Yesusle here no hilolere rowendere riwounge. Nda Yusuf Yahudi yoyo koseyo holona rore rowainye. Allah yae Wali Ondofolole me kelee u keleene nekate ro miyae holone memmikaenendere rakeyeunge kiyae. ");
INSERT INTO set_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Yesus u hale hele hereke a Pilatus borouboke bae fa yae bowole. Nebeinye fela yun kaeneungekoke meke hineunge, “Yesus ohaline baikoke Kiyae na hele hereke?” ");
INSERT INTO set_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pilatus naei fela yun bera a boroukokera, Yusufre ehe koungekoke here no na hului rowende. ");
INSERT INTO set_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nebeisa Yusuf malo lenan roi yae rouke, Yesus hereke no ruboungeboke oke, nebei malo maye-mayene ruleufikera kaeuboke bulei ruka bulunane nekeunge. Nebei bulei romaufe ahengkondere ruka kaban mae oleungekoke aheukoke. ");
INSERT INTO set_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Yesusre nekainyele anuwau Maria Magdalenale, Maria, Yoses nenakele, ijoko ninae erewoinye. ");
INSERT INTO set_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabat ya nekaikoke baeufoke hee yae, Maria Magdalena yae, Maria, Yakobus nenake yae, Salome yae, minyak fololo mo roi yae yaraikoke, Yesusle here none olenainyekonde naeise. ");
INSERT INTO set_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nebei mon ya mbai nendo Minggu ya rene hu inyukui roroweke nda miyae maengke bulei ijende ewate. ");
INSERT INTO set_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Nobaeinyekoke mo naeise naeise elate, “Bulei romaufe ruka kaban sele ahunaiboke. Nde yae hakommebonde nebei ruka olennekonde?” Nebeibe rilibore hayaete ruka kaban na nobera erewate bae nebei anuwaufa olaeinyekoke. ");
INSERT INTO set_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ruka bulu eise ayeuboke bae, nebei ruka bulu ei meube reufine ro hokolo fa mbai na malo keleumon angken mae nuweuboke nekewole, erekainyene kulu-kulu hele yaeiboke. ");
INSERT INTO set_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nda kiyae weumi, “Buhae ohokoijae. Reyae raeisaei Yesus Nazaret yona ro ohaline baikokebe mayae baeimeyaunge. Neyae oloo, herekera aunguke! Erembo, nda na uware nekainyele anuwau niyae! ");
INSERT INTO set_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nda hee embe, na moisa orowate yo bele Petrusre bele a wemmile Yesus are ukembe huluinye. Neyae Galilea kanire bere holo yae ende, nane merau nebeinye mangkele ensubayengkombe.” ");
INSERT INTO set_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nda miyae fe oinyeu wae hinaiboke kowatene, nane merau fa yae bowatene, ruka bulura maibaleke hakaikoke ewate. Buhae yae hokoumibokene, nda are hire hare ehuwei. ");
INSERT INTO set_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Minggu rene Yesus herekera aunguke ya, na bere hele Maria Magdalenare Nauwa yakaungeboke. Nda Maria kiyaele u bulura Yesus walobo mehine bee bele hukeumihike aibaleke. ");
INSERT INTO set_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maria Magdalena ijoko ereuboke rambun Yesus na kahili wa ibo insene kate nolone ekeufuwemmi. ");
INSERT INTO set_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Yesus waleuboke a borowate nane merau Maria yae ijoko erekeunge huwaimikokebe, nda yo na helere eleikoi. ");
INSERT INTO set_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nebeisa mo na moisa orowate ro bee yo hire ewote yae, Yesus na uwa ma hi yae yakaumiboke. ");
INSERT INTO set_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Hokolo bee bukeiboke Yerusalem yore meketera nebei a hiwa yore huwaimile horo lon, nebei borowate yo hi yae ha yae na helere eleikoi. ");
INSERT INTO set_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nebeisa Yesus na moisa orowate me bee oro nen mbai belere ramanne anewate haei yae na uwa meumiyakauboke. Yesus a elaekei sele yae yarewoumi, rabuhine ban naei hila rabo elae ban yaeiboke nane merau Yesus hereke aungekera erainyeboke yo yae huwaimile are na hele eleikoi. ");
INSERT INTO set_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nebeisa Yesus nebei yore weumi, “Eme, nda kani kaban kela kabande Raei a foi faeu foi ro miyaere nemene heraeyemmiyembe. ");
INSERT INTO set_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nde Rare hila rabo halenselena bu konainyebonde, Allah yae na wali hole molonnebonde. Nde yae Rare hila ban rabo banna, Allah yae me wonnonde ehee bukulu endowende. ");
INSERT INTO set_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Hila bele rabo bele yo nda rambun emere-emere mokonate: walobore Raei Ro yae hukenaimile, afaeu-afaeu eme elenate, ");
INSERT INTO set_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","naei uware beko eyeiboi naendae wanen horo rami hangkei me yae ikilenate, bu beko anenate. Ro miyae era buloone konate yore me nauwa ranne kolonaimiyende onomi yaronayende.” ");
INSERT INTO set_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Aei Tuhan Kiyae, Yesus, a weumikoke baeufokera, surgare raneuweke ewole, Allahle meube reufine eunguweuboke. ");
INSERT INTO set_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Na moisa orowate yo yae Yesusle a foi faeu foi a hine a hine huwaimiyeke. Aei Tuhan Kiyae, Yesus, nangkele yae hakowoumi, rambun emere-emere mokowate yae yakawoumi naei ako faeuko huwewate na hele yeuboke.");
INSERT INTO set_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Foi moi, Teofilus. Ro miyae helen mae nda rambun aei nolone bewatere homone uwa nihaeinyehike hauwate. ");
INSERT INTO set_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Huba ijokore eraiboke yo yae huwaime wanen, naei wanen mbai na homone hauwate. Nebei yo yae nda a heraeyaiboke. ");
INSERT INTO set_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nemene, reyae na hubara meungehaleukokale, ra ura hubawanale naei foi sele benen ware homone na foi moi yae na hubara hufeumendere. ");
INSERT INTO set_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Na bena ware kelewayete naeinya hele niyae. ");
INSERT INTO set_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ro mbai na ro Zakharia. Neyae imam Abiale riyana. Nda Zakharia imamde hebewole hee yae Herodes Yudea kanire Ondofolore hebewole. Nda Zakharia na miyae na ro Elisabet, Harunbe orona mena. ");
INSERT INTO set_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Hokolo bee ro bele miyae bele Allahle ro be ro yoinye wali himaleinyeboke yo. Allah yae Musare ukeunge wali heere foloukoke are hubara haeisa yaneinyeke. ");
INSERT INTO set_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elisabet kihone, hokolo bee na fa ban mo nekeimeke, rorele miyaenale meijeukoke. ");
INSERT INTO set_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Ya mbai mo, Abiale homona yaunga orowate yo naei mon kayee ruke hee mo, Zakharia yae imam kaliare mokowole. Allahre ei mom-mom imae na kaban sele kiyae einye o ha ongkou fololo bele ongkou felembonde naeise oye yae nihaeiboke, Zakharialena ruke. ");
INSERT INTO set_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","O ha ongkou fololo bele ongkou felewole hee, ro miyae moinye woke yo naeise naeise Allahre ebeli bowainye. ");
INSERT INTO set_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Zakharia hili era akau era ongkounge felewole hee, euweke ongkou felei-felei itukai meube reufira Allahle malaikat uwa yakaungeboke. ");
INSERT INTO set_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nebei malaikat erekeungene, kulu-kulu yeuboke, fe yae waku yae roukeunge. ");
INSERT INTO set_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nebeibe malaikat yae weunge, “Fe efaeijae, Zakharia, webeli kali boyanae Allah be hineubokete. Wa miyae Elisabet kelu mbai hononetere, Yohanes yae hele ro roubonde. ");
INSERT INTO set_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nda fa honondene, weyae rei mai aneibote kole, ro miyae woke yo nebei sului mbai konate hukelenate. ");
INSERT INTO set_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Allahle ro be ro yoinye Nare ro bele enneronde. Bu elae aneyei sele nekenende. Nenakele kou ei yahi eisa menduwende heera, Allahle Roh yae ei annebonde. ");
INSERT INTO set_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nda fa hononde Israel yoni-yoni helen sele mokommile bukenate naei Tuhan Allah a wemmile hului nekenate. ");
INSERT INTO set_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Allahle burelen boi-boi rore yembonde. Allahle yendo kayaalo Elia Allahle Roh bele elae wake bele Allahle kaliare mokowole wanen Yohanes mokonde. Ako naei mokommile bukenaibonde na kelu omi bele rei mai yae nekenate nane merau be elae u elae ro miyaere mokommile wali himalainyeboke yo isaei hebaen bele huwate are boronate. Tuhan huwemmile a hului nekenate ro miyae holo mbai neyae mokommihande.” ");
INSERT INTO set_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakharia yae weunge, “Reyae rorelebe yeubokale. Ra miyae nebei sului mbai miyaenalebe yeuboke. Naendae mekai yae nda a waraere reyae a hele yae elerekonde?” ");
INSERT INTO set_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nebei malaikat yae weunge, “Reyae malaikat Gabriel yae ware wawale. Reyae Allahle bene hebeyale. Neyae ukeufe nda rei mai bele a ware mekawawale. ");
INSERT INTO set_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nda wawale a mbai sambai weyae na helere eleikoinye, mana yara weyae a mun faeu mun yeubonde nekeumende, nda a wawale na hului menaibende erele.” ");
INSERT INTO set_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ro miyae moinye woke yo nare ereiko rakeiko yae kainye, a hin-sin mae hinate: “Rahene Zakharia nda heki nen eke wabeyole.” ");
INSERT INTO set_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Rakainye mo, Zakharia meukuke, a mun yeuboke. Ro miyae erainyere Zakharia me weije-weije yae koumi, a eleikoi sului. Nebeinye ro miyae isaeyaeiboke Zakharia era buhibe kaneungeboke. ");
INSERT INTO set_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nebeisa imam kalia mokowole hee baeufoke mo, Zakharia kulun uke imaere ewole. ");
INSERT INTO set_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nekaikoke na heki ban mo Elisabet emale yeuboke. Oko maehae mbai na imae einye mo meungekeukoke. ");
INSERT INTO set_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Nda a bae elewole, “Ro yae miyae yae kiho nekewekalene a wewe kaisekere Allah nou heufekoke. Mana yara onomi foka Allah meufeyeke.” ");
INSERT INTO set_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet emale oko mehine mbai nendo yeuboke mo, Allah Na malaikat Gabrielre ukeunge Galilea kanina Nasaret yore eke. ");
INSERT INTO set_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Gabriel ukeunge eke miyae yele maengke yele mbai na ro Mariale bokore eke. Nda maengke Yusuf rowendere a hokaikoke. Nda Yusuf Ondofolo Kaban Daudle orona mena. ");
INSERT INTO set_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nebei malaikat Mariale bokore eke mo weunge, “Allah ware onomi foka yae ei hawenewende, wangkele mbainye nekefobe.” ");
INSERT INTO set_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Malaikat nda a mekai ukeungene Maria kulu-kulu hele yeuboke. Na kena eisa elele, “Rahe a mabe nda malaikat meke haraungeboke eleukoke.” ");
INSERT INTO set_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nebeibe malaikat benende weunge, “Fe efaeijae, Maria. Allah ware onomi foka yae ei hawete. ");
INSERT INTO set_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Weyae emale yeubondera, kelu mbai honole, Yesus yae hele ro roubonde. ");
INSERT INTO set_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Neyae kaban yembonde, Allah Hubalo Mando Na Kelu yae kaenenainyele. Na yobe Ondofolo Kaban Daudle yo waku Allah Nare kinyennele. ");
INSERT INTO set_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Mende Yakuble orona mena yo naei Ondofolore yembonde, nekenende huba ban haei ban.” ");
INSERT INTO set_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nebeibe Maria yae weunge, “Reyae miyae yele maengke yele ya. Naendae wanen mae nda a rare warae benate?” ");
INSERT INTO set_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nebeibe malaikat yae weunge, “Allahlena Roh waei rande onde, Allahle elae wake mende ei aneubondene, Allah yae nda nene waewae Fare Naei Fa yae elende. ");
INSERT INTO set_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Boroibo, waka baeke Elisabet, kiho kaeneimeyainye miyaebe, emale oko mehine mbaibe yeuboke. ");
INSERT INTO set_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Rabuhine ban Allahlena rambun nemene na hului yembonde.” ");
INSERT INTO set_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nebeibe Maria yae weunge, “Reyae Allah Naei yebaei bubaei ya. Ninae lonbe nemene waei are eleyae huluinye raei u ranne yembonde.” ");
INSERT INTO set_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Na heki ban mo, Maria erambun mokoungehake kulun uke, yo mbai Yudea kanina moko nolone honolere eke. ");
INSERT INTO set_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nebei ijenne Zakhariale imae hebelene. Maria eweufike Elisabetre ro bere melaeyeungeboke. ");
INSERT INTO set_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mariale are mo Elisabet boroke bae, na kou yahi einya fa nenaeijae eiso meiso howole nane merau Allahle Roh Elisabetre ei aungeboke. ");
INSERT INTO set_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Nebeisa kaenele, “Ewole mewole miyae maengke nolora wembai onomi foka yae ei aubokete. Foi sele moi sele waei koufa yahira honole fa. ");
INSERT INTO set_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Raei Tuhan nenake weyae mekaene raei kena roweufehike. ");
INSERT INTO set_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Rone mo melaeyaerae bae, kou yahi na fa reinye oro kena me kena rorole. ");
INSERT INTO set_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Reyae Allahre ebeli banale weyae onomi foka hubaungele, rabuhine ban Allah ware uwote a nemene benate naeise hila rabo haleyaene.” ");
INSERT INTO set_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria yae weunge, “Ra kena u eisa Tuhande buma kaenale. ");
INSERT INTO set_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Reyae roweisi-roweisi kale, Allah wali holere moloufeboke Kiyaele eisa. ");
INSERT INTO set_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Me baei ban nekewekalera, Allah me baeufeboke. Raei eisa Allah Elaelo Wakelo rambun mbai kaban sele mokoubokene, mana yara huba raweuboke, ro miyae yae rare onomi foka yae ei aungeboke kiyae yae ungaisendere. Na Ro Niyae yolo-yolo hele. ");
INSERT INTO set_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ro miyae Nare hubara haeisa yanainyeke yo norona mena bele yanekoi yase yae ei haweumiyeke. ");
INSERT INTO set_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Allah Hubalo Mando rambun emere-emere mokowole, embei aiko bele yore na mehininde kolowainye bele heraeiwoumi. ");
INSERT INTO set_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ondofolo-ondofolo hiwa Na yo malo bele yae herewoumi, me baei ban yore yarowole anuwau foinye hawoumi, ");
INSERT INTO set_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Monine kowate yo raman foise narewoumi wande bewate, nda kanina kelana keren nalene arilayeke yo uwoumi na me bangka u bangka yae ewate. ");
INSERT INTO set_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Allah Naei are raufike huluinye, eyae Israel Naei yebaei bubaei nekande yore yanekoi yase yae ei haweyeume. ");
INSERT INTO set_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Maebu naei maeko natere ukeumi hului Allah Abrahamde buhae hewounge mahi eyeiboi, nebeibe huba ban haei ban ma mbai maere na orona mena bele yae hemmeyende.” ");
INSERT INTO set_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria oko name hului Elisabetle bokone nekeukoke mo, nebeisa kulun uke naei imaere ewole. ");
INSERT INTO set_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Meke ya na hului yeuboke mo, Elisabet kelu fabe hongke. ");
INSERT INTO set_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Elisabetre yaneikoi yase yae Tuhan ei hawewoungere imae ribo mbainye yo nane merau naei aka baeke borowatene, nangkele rei mai kowate. ");
INSERT INTO set_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nebei kelu fa hongkate ya mehine name mo, na ro uwa elan nenaisande naeise Allahre ei mom-mom imaere mekate. Naei yohona ro miyae naeko Zakhariale ro bu yae ronaibondere kena kowate. ");
INSERT INTO set_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Nebeibe nda fa nenake yae weumi, “Nebei ro kena ban, Yohanes yae ro romabonde.” ");
INSERT INTO set_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Nebei ro miyae yae wainye, “Waei akana baekena nda ro wanen ewei mo.” ");
INSERT INTO set_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nebeinye Zakhariare a hinenainyehindere me yae mo kowainye, “Nde yae nda fa ro romambondere?” ");
INSERT INTO set_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakharia homore molongkondere homofae riyeumihike, ikainyele, nebeinye moloukoke, “Na ro Yohanes.” Ro miyae na fangkengke bele bowate. ");
INSERT INTO set_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nebei heera Zakharia na he mabon raweuboke na a bele Allahre benen buma kolowounge. ");
INSERT INTO set_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Naei imae ribona nekewate yo euwa kaeu-kaeu mo kaeuwate. Nebeisa nda a Yudea kani mokona ro miyae bele eufureukoke borowate. ");
INSERT INTO set_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Allah nare na hele ei aungebokene, ro miyae helen nda are borowate yo a hin-sin mae hinewate, nenaeijae na kenara mo elewate, “Kabanne nda fa rahere enjembonde?” ");
INSERT INTO set_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nebei fa Yohanes naeko Zakharia, Allahle Roh yae maemae koungekoke mo Allahlena a elewole, ");
INSERT INTO set_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Men, Allahre buma koloman aei yo Israel naei Allah, rabuhine ban Neyae meke Naei holona ro miyae na beko bakore aheukoke baeufoke. ");
INSERT INTO set_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Allah Walilo mbai raneujeke, Naei yebaei bubaei Ondofolo Kaban Daudle orona menabe. ");
INSERT INTO set_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nendahina Allah Naei yenjo kayaayo walora eleukoke hului mokoukoke. ");
INSERT INTO set_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","72","Aei yobe naei kamahe naeise yanekoi yase yae ei emmihawende naeise nane merau Naei a heteungekoke a hului mokonde naeise, yokeijo aere ikele u han u hebate yo nolora Allah aere hole molommebonde. ");
INSERT INTO set_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Nebei are heteungekoke mbai nendahina Allah aei yobe Abrahamde a holo koukoke aere yokeijo nolora hole emmemolonde. Nebei nibi yae eyae na hului fe efaei yae, u mekai yolo-yolo bele wali himalanneboke bele Naei kaliare mokomayende nda no hayaende emmebaensonde.” ");
INSERT INTO set_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Zakharia yae benende elele, “Kelu, ware Allah Hubalo Mando Naei yendo kayaalo yae enaikaenete, Tuhan Naei nibi hiyei raneubonde naeise weyae bere holo ele. ");
INSERT INTO set_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Weyae Allahle holona ro miyaere weumile naei beko bako faeinyemmibonde walora wali hena bona enaiyaronde. ");
INSERT INTO set_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nda nemene Allah yanekoi yase bele Kiyae randa mo. Wali Ondofolo Allah ungende mende surgara onde hehe wanen mennaengkonde. ");
INSERT INTO set_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Onde ro miyae ouben nolone nekate yo herere buhae hokoyeumi yore hehe naemmikonde. Neyae aere rei mai yeume wali nibine oromale naeise kelemmele.” ");
INSERT INTO set_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nebei Zakharia na fa kaban bewole, na u bene wa bene maemae kowounge. Neyae a kala-kala anuwaunge ennekengkondera Israel ro miyaere uwa memmikelembonde hee. ");
INSERT INTO set_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","((Yohanes hongkate heera oko mehine mbai nekaikoke hee yae)) Kaisar Agustus ukeumi Roma kani kabanna ro miyae nemene mere nulenaibondere. ");
INSERT INTO set_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Nda roko mbai selebe me nulaiboke, Kirenius, Siria kani naei Ondofolore hebewole hee yae.) ");
INSERT INTO set_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Rore haungate naeise ro miyae naeise-naeise na yore yande bukewate mewate. ");
INSERT INTO set_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ro mbai, na ro Yusuf, Galilea kanina Nasaret yora kulun uke Yudea kanina Betlehem yore, Ondofolo Kaban Daudre hongkate yore ewole, rabuhine ban Yusuf Daudle orona menane. ");
INSERT INTO set_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yusuf Maria na miyaere yembondere ehe kaikoke kiyae bele ro haungeikonde naeise nanembaisa ekete. Nebei hee Maria emale yeuboke yae. ");
INSERT INTO set_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Betlehem yone ekete Maria naei hononde ya nobeungeboke. ");
INSERT INTO set_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Meke, Kelube na kou eme yahi emera hongke. Maria rouke malone ruleufike. Kolo imae maemae koukokene, o hote kaban sapi yae domba yae ramande anate einye nekeunge. ");
INSERT INTO set_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Yudea kanine Betlehem yo kelaeunge, domba kayaare hebate yo reniai yae na domba kayaane hebewate mo, ");
INSERT INTO set_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Allahle malaikat na uwa meumiyakauboke. Allah na u inyukui yae hehe naeumikoke. Nebei domba kayaare hebate yo fe yae waku yae maemae koumikoke. ");
INSERT INTO set_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nebeibe malaikat yae weumi, “Fe efaemmae. Reyae a foi faeu foibe roukale male mare ufembere, nane merau ro miyae nemene ufemilere. Mayae rei mai kombe nebei wanen mbai nebei ro miyae konate. ");
INSERT INTO set_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mana ya Walilo mbai Daudle yona hongkate. Neyae Tuhan Allah yae oro umau heraungeboke Wali Ondofolo Kiyae ((Yunani afaeunge)) Kristus yae kaenainye. ");
INSERT INTO set_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Iwau wanen nda ma yae erennele, fa mefa na malo yae rulenaisinde, domba naei sapi naei kere anate o hote kaban einye nenainyende.” ");
INSERT INTO set_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nebeisa nebei malaikat kelaeunge surgana malaikat felayo helen sele na hiwa yakaiboke. Allahre buma kaewainye na a bele elewate, ");
INSERT INTO set_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Allah na bumane hele ekenekele Kiyaere hili hebenayende nane merau nda kani kelana ro miyae Naei kenare koyeumi yore Allah rei mai yemmile.” ");
INSERT INTO set_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nebeisa malaikat nda domba kayaayo nukaimiboke, surgare baeiboke. Ewate mo, nda domba kayaayo naeise naeise elate, “Men, Betlehem yore ema. Allah yae meke weume a ema erembon.” ");
INSERT INTO set_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Na hibi u hale me hale nane yo kulun hayaeikoke. Ekate, Mariale Yusufle nebei fa bele hubayaeikoke, o hote kaban einye nekainyele honowole. ");
INSERT INTO set_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Erewainye bae, nda fa malaikat are huwaimi huluinye a heraeyeuboke. ");
INSERT INTO set_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nebei domba kayaayo huwaimi are borowate ro miyae nemene fa yae bowate. ");
INSERT INTO set_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nebeibe Maria nebei a faeu elayoke, naei kena einye auboke nou heungoke. ");
INSERT INTO set_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Malaikat are weumikoke borowate nane merau erewate huluinye yeubokene, nebei domba kayaayo ke faufe benen bukewate ewate, Allahre bumane kolainyeke. ");
INSERT INTO set_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Hongkatera ya mehine name mo, Yesus ro uwa elan nainyehake mo, na hibi nenake emale eyeiboi heene malaikat ukeunge hului Yesus yae Na ro baeinyehoke. ");
INSERT INTO set_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Musale walora wali heere foloukoke a hului Maria fa honoke heera ya rorele u bee Allahre ei mom-mom imaere ei sului, ((uwa ha belene)). Nebei mon moi wokene Yusufle Mariale Yesus roukainyele Allahle me einye kinyenainyebonde naeise Yerusalem yore ewate. ");
INSERT INTO set_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Allah yae Musare ukeunge wali heere foloukoke homo einye nda wanen moloukoke, “Kelu bena Kiyae Allahre kinyennebombe hele,” ");
INSERT INTO set_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","nane merau Maria uwa faeinyeiboise. Tuhan Allah Musare ukeunge wali heere foloukoke a hului, fa hononde miyae Allahre ongkou feleiboise merpati kelu bee, una, merpati aye wanen hi bee. ");
INSERT INTO set_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nebei hee Yerusalem yone ro mbai nekewole na ro Simeon, na wali himaloungeboke nekeweke. Allahle are hubara haeisa yaneungeke, nane merau Allah yae Israel ro miyae yokeijo naei me eisa memmihayengkondere ereiko rakeiko koweke. Allahle Roh yae Naei uware ei haweungeboke. ");
INSERT INTO set_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Na bere Allahle Roh yae a ukeunge neyae eherei mo nekende mende Tuhan Allah oro umaufe heraweungeboke Wali Ondofolo Kiyaere naei ijoko yae erennebonde. ");
INSERT INTO set_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Allahle Roh yae Simeonde yaweungehoke, Allahre ei mom-mom imae na kaban sele kiyae imaehoufe eke. Nebei ya Musale walora wali heere foloukoke a hului Allahre kinyeneinyebondere naeise Yesusre naekole nenakele roukeinyele nebei anuwau mbainye ayeuboke. ");
INSERT INTO set_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Nebei fare Simeon roukeunge nda a yae mo Allahre buma kaewounge, ");
INSERT INTO set_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Nemene me mokamae Allah a ukeufe hului reyae Waei kaliare mokale kiyaere mokoufebonde kena rei mai yae hererele. ");
INSERT INTO set_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Rabuhine ban Weyae ukanae meke Walilo raei ijoko yae ninae erekanale. ");
INSERT INTO set_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Weyae ro miyae nemene naei bene nda Walilo relahi yae mokoungehakae. ");
INSERT INTO set_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Neyae hehe naeyele wanen Yahudi ro miyae ban yore wali hena bona wali nibi are yakammile nane merau Israel yore Waei nene waewae kelemmile.” ");
INSERT INTO set_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Naei fa naei a Simeon mae weumi borowetene Yusufle Mariale fa yae bowote. ");
INSERT INTO set_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon Allahre riyeungehike hokolo namere onomi foka yae ei hawemmile, nebeisa Mariare weunge, “Allah nda fare eleuboke wekeunge Israel ro miyae helen ehee bukulu yemmile nane merau helen onomi fokare yemmile. Neyae Allahle bokora meke are elendebe, nebeibe ro miyae hiwa Naei a beko hungaimile. ");
INSERT INTO set_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nane merau Naei aerene waei kena une buhae kole. Neyae ro miyae helen naei nunne honate u bene nekaimi yoni-yonire yakammibonde.” ");
INSERT INTO set_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Allahle yendo kayaalo miyaenale hele mbai na ro Hana, Fanuelle fa, Aserle yohona. Na molo bele ralo yakama mehine bee bele nekeikokete mo na molo hereke. ");
INSERT INTO set_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Hana rora moloufake heera ralo yakama 84 Allahle imaene mo nekeweke. Reniai rai Allahre ei moloungeke, roko mbembe yarele me heiboyele nekeweke, na hibi-hibi ebeli boyeunge. ");
INSERT INTO set_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Yusufle Mariale na fa bele mekatera mo, Hana Allahre helen foi uwounge nane merau Allah Yerusalem yo na yokeijo me eisa hayemmikondere rakeimeyainye ro miyae nemenere nda fa naei a weumiyeke. ");
INSERT INTO set_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yusufle Mariale Allah yae Musare ukeunge wali heere foloukoke honate homo na huluinye mokoikokete mo, hokolo bee na fa bele bukaibokate Galilea kanina naei yo Nasaretre ewate. ");
INSERT INTO set_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nda fa kaban bewole, meli mekai bele. Isaei hebaen bele ma yae u mekai harannele naeise maemae koungekoke. Allah ro miyaere kena buhae aere ban mae heumi Kiyae Nangkele mbainye nekete. ");
INSERT INTO set_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Na ralone yakamane baei Yesus naekole nenakele ((Mesir Kanine Allah yae Yahudi naei bena kelu fa-fare hole molouboke u bene nekenaimihinde)) ya kaban (Paskah ya) Yerusalem yone eikate. ");
INSERT INTO set_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Naei koyate heena nda roko hibe ekate ya kabande Yesus ralo yakama me bee oro nen bee bele yeuboke ekate. ");
INSERT INTO set_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ya kabanda baeufoke mo, bukaiboke naei yore ewate. Yesus mbai nukainyeboke Yerusalem yone nekewolere naekole nenakele naeisaei ban, na kobu ewote. ");
INSERT INTO set_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Neyae elete Yesus nda ro helen miyae helen nolona mande ya. Ekate nibi nolone ya mbai yeuboke yae wa nebeisa baeinyekoke, ro nolo miyae nolore, na aka nolo baeke nolore, baei-baei baewoinye. ");
INSERT INTO set_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Baewoinye hubayeikoi mo, nebeinye hokolo bee naekole nenakele benen bukeiboke naei baeikoise Yerusalem yore ewote. ");
INSERT INTO set_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Yerusalemda kulun ukate ewate heera, baeinyemeke ya namebe yeuboke benen Yerusalemne, mekete Allahle imaene erekeinyele. Nebeinye Yahudi naei agamare kelaeimi ro nolone nuweuboke nekewole. Yesus naei a hineyeumi weyainye nane merau nebei yo hineyainye Yesus yae weumi. ");
INSERT INTO set_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nebei a nemene hinewainye na ijenne na hibi-hibi uwoumine, nebeinye arilewole yo fa yae bowate. ");
INSERT INTO set_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Naekole nenakele naei wanen ekete erekeinyele bae, fa yae bowote. Nebeisa nenake yae weunge, “Kelu, rahene kobu wanen maere mokoumebokae. Araite rangkele ware hubayeikoi mone, buhae hokoumeboke.” ");
INSERT INTO set_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nebeibe Yesus yae weumi, “Rahene mayae Rare baeufe? Mayaebe isian, nda Maekole imaene Reyae nekerele Kiyae.” ");
INSERT INTO set_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Yesus na mekai haraungebokere hokolo bee onewote. ");
INSERT INTO set_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nebei ara ukeumi bae, Yesus naekole nenakelere hakoumiboke Nasaret yore ewate. Nebeinye eke, nenakele naekole kelene ekenekewole. Nenake nda a nemene na kena einye mo heraweuboke. ");
INSERT INTO set_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesus kabande beuweke, isaei hebaende bele ma yae u mekai harannele naeise henaweke. Allah yae nane merau ro miyae yae nare kena hele kowainye. ");
INSERT INTO set_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ralo yakama me bee oro fae reufi mbai bele (15) meujeuboke Kaisar Tiberius meungekeukoke. Nebei hee yae Yudea kani naei Ondofolore Pontius Pilatus yae hebewole, Herodes yae Galilea kanire. Iturea bele Trakonitis bele kanire wa Herodes naka baeke Filipus yae, Abilene kanire Lisanias yae ikileuboke. ");
INSERT INTO set_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Imam-imam naei kaban sele Hanasle Kayafasle hebewote. Ralo yakama yae Zakhariale fa Yohanes a kala-kalane nekewole yae Allah a meke uwounge. ");
INSERT INTO set_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yohanes Yordan Wi kelaeunga kanine meke nekewole, ro miyaere Allahle a huwoumi weumi, “Mai beko bakora nulu kenayembe, kelemmibombe naeise bu konayembe, Allah mai beko bakora faeinyenengkombe.” ");
INSERT INTO set_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yendo kayaalo Yesaya Yohanesle naeise nda wanen moloukoke, “Ro mbai a kala-kalane ekekaenele, ‘Tuhanbe nibi a hiyei ranennebo. Kalo-kalo ran-dan ijen alommi. ");
INSERT INTO set_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Moko faufe mokonnele, nibi yeli-yeli yo alommile, eleiso akoibore honate nibi ro hiyei ranen. ");
INSERT INTO set_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Allah ro miyaere hole molommibonde nibire nda kanina kelana ro miyae nemene na ijoko yae erenate.’ ” ");
INSERT INTO set_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ro miyae Yohanes bure kommilere nekai mewate nebeibe Yohanes yae weumi, “Nda ro miyae mewaube rami orona mena wanen. Nde yae angkaa yobombokembene Allahlena ehee bukulu menensayembera henensombe. ");
INSERT INTO set_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mayae na hele bekora nulure kembokembe naeise kelemmilere u mekai foi mokombe. Mayae Abrahambe orona menane wali hena bona yarongkombe naeise u benera enekemmae, rabuhine ban nda rukara Allah na hului Abrahambe orona menare mokongkonde! ");
INSERT INTO set_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Rame kahu relahi mokainyehake o na kambura kahenate onatere. Nane merau Allah relahi mokoungehake ani foise omokoi yo kahenate i ranne mo hainyate.” ");
INSERT INTO set_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nebei ro miyae yae Yohanesre hinainye, “Nebei uwana rahebe meyae mokomabonde?” ");
INSERT INTO set_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nebeinye Yohanes yae weumi, “Nde na malo beena, ro miyae malo ban kate yore hakommile. Nane merau nde raman belena, ro miyae hiwa raman ban yore hakommile.” ");
INSERT INTO set_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Pajakre arileyate yo bele Yohanes bure kommilere mekate mo, wainye, “Guru, rahebe meyae mokomabonde?” ");
INSERT INTO set_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nebeibe Yohanes yae weumi, “Mare ukayembe hului yae mo pajak riyemmiyembe, mai kenana hului bele yae eriyeijae.” ");
INSERT INTO set_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nane merau felayona ro hiwa mekate hinainye, “Meyae bae rahebe mokomabonde?” Nebeibe Yohanes yae weumi, “Ro naei miyae naei roi na mera einukeijae hele, ro miyae naei ro nendon naise eiseijae. Wali waei roi buna yae nekewende.” ");
INSERT INTO set_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nda a weumikoke heera ro miyae na kena ura elate, “Nauwae nda Yohanes nebei Wali Ondofolo rakeimeyannele Kiyae niyae era?” ");
INSERT INTO set_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nebeibe Yohanes yae weumi, “Reyae mare bu yae kamale. Nekemakonde mo, Ro hi ro bele Kiyae mende. Naei oro mehau ha kulaiboise reyae na hului ban, rabuhine ban Naei bene reyae ro ban sele. Reyae mare bu yae kamale wanen Neyae mende mare Allahle Roh bele, i bele yae konembe. ");
INSERT INTO set_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Neyae ro miyae kayee memmimolonde. Nare hila rabore halaeinye yo yawemmibonde Nangkele mbainye nekenate. Naei are moise haiwate yo yarongkonde hekelengkonde ralone yakamane italo ranne enaibende.” ");
INSERT INTO set_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mehi mehi yae Yohanes ro miyaere a usaei uwoumi, a foi faeu foi huwoumi. ");
INSERT INTO set_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nebei hee Herodes Galilea kani naei Ondofolo, na aka baekele miyae na ro Herodiasbe roukene nane merau na me hilae u hilae hiwa nekai mokowolene, Yohanes yae a usaei wasaei a elae yae horoungeboke. ");
INSERT INTO set_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herodes naei me u beko benen elaeibo-elaeibo hele kowolene, Yohanesre kawane heungekoke. ");
INSERT INTO set_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Yohanes namman Herodes yae kawane eheikoi hee yae, ro miyae hiware bu kowoumi hee nane merau Yesusre koungeboke. Nebeisa Yesus Naekore ebeline bowounge mo, yaku uke raweukoke, ");
INSERT INTO set_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Allahle Roh yakura aye merpati wanen mae Naei uwa rande owole nane merau a yakura weunge, “Weyae Raei kenare kawale Kelu, Weyae Raei kenare foi mokoyarae.” ");
INSERT INTO set_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesus na ralo yakama ro rele u mbai u hine me bee bele (30) hului yae, na kalia huba raweuboke. Ro miyae yae na kena u eisa bae elewate Yesus Yusufle kelu. Yusuf Elile kelu, ");
INSERT INTO set_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli Matatle kelu, Matat Lewile kelu, Lewi Malkhile kelu, Malkhi Yanaite kelu, Yanai Yusufle kelu, ");
INSERT INTO set_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusuf Maticale kelu, Matica Amosle kelu, Amos Nahumbe kelu, Nahum Heslile kelu, Hesli Nagaite kelu, ");
INSERT INTO set_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai Maatle kelu, Maat Maticale kelu, Matica Simeite kelu, Simei Yosekhle kelu, Yosekh Yodale kelu, ");
INSERT INTO set_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda Yohananle kelu, Yohanan Resale kelu, Resa Zerubabelle kelu, Zerubabel Sealtielle kelu, Sealtiel Nerite kelu, ");
INSERT INTO set_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri Malkhile kelu, Malkhi Adile kelu, Adi Kosamle kelu, Kosam Elmadamle kelu, Elmadam Erle kelu ");
INSERT INTO set_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er Yesuale kelu, Yesua Eliezerle kelu, Eliezer Yorimbe kelu, Yorim Matatle kelu, Matat Lewile kelu, ");
INSERT INTO set_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi Simeonbe kelu, Simeon Yehudale kelu, Yehuda Yusufle kelu, Yusuf Yonambe kelu, Yonam Elyakimbe kelu, ");
INSERT INTO set_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elyakim Meleale kelu, Melea Minale kelu, Mina Matatale kelu, Matata Natanbe kelu, Natan Daudle kelu, ");
INSERT INTO set_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daud Isaite kelu, Isai Obedle kelu, Obed Boasle kelu, Boas Salmonbe kelu, Salmon Nahasonbe kelu, ");
INSERT INTO set_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahason Aminadable kelu, Aminadab Adminbe kelu, Admin Arnile kelu, Arni Hezronbe kelu, Hezron Peresle kelu, Peres Yehudale kelu, ");
INSERT INTO set_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yehuda Yakuble kelu, Yakub Ishakle kelu, Ishak Abrahambe kelu, Abraham Terahle kelu, Terah Nahorle kelu, ");
INSERT INTO set_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor Serugle kelu, Serug Rehule kelu, Rehu Pelegle kelu, Peleg Eberle kelu, Eber Salmonbe kelu, ");
INSERT INTO set_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salmon Kenanbe kelu, Kenan Arpakhsadle kelu, Arpakhsad Sembe kelu, Sem Nuhle kelu, Nuh Lamekhle kelu, ");
INSERT INTO set_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamekh Metusalahle kelu, Metusalah Henokhle kelu, Henokh Yaredle kelu, Yared Mahalaleelle kelu, Mahalaleel Kenanbe kelu, ");
INSERT INTO set_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan Enosle kelu, Enos Setle kelu, Set Adambe kelu, Adam Allahle kelu. ");
INSERT INTO set_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Allahle Roh yae Yesusre ei aungebokera Yordan Wira bukeufike ewole bele. Allahle Roh yaweungehoke a kala-kala anuwau mbaise ewote. ");
INSERT INTO set_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Nebeinye ya rorele u bee ekenekewole yae walobo yun wabeungemeke. Yesus bune ramanne anei mo nekeukokene na huba mokoikoi yare bae Yesus moni yaroungekoke. ");
INSERT INTO set_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Walobo yun mae weunge, “Na hele Weyae Allahle Keluna, nda ruka honate weimi ramande yaeibo!” ");
INSERT INTO set_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nebeibe Yesus yae weunge, “Allahle homofaene nda a moloukoke, ‘Ro miyae raman anatene mo ban wali nekate.’ ” ");
INSERT INTO set_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Nebeisa walobo yun Yesusre yaweungehoke anuwau mbai na bumare hele ekete, u hale me hale nda kanina kela Yesusre keleungeboke. ");
INSERT INTO set_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Walobo yun mae Yesusre weunge, “Nda kani kela nemenaei ondofolo anuwau bele na one hengko bele Waei me einye kinyereibotere. Nemene raei me einye mo honoimeyele meke mana yane ndere raei kenare korele huluinye nendon isende. ");
INSERT INTO set_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Rare ei moloufebondena, nemene ware kinyerete.” ");
INSERT INTO set_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesus benen beungehoke weunge, “Allahle homofaene nda a moloukoke honole, ‘Tuhan Waei Allah mbaise mo ei moloungele, Naei kaliare mo mokole!’ ” ");
INSERT INTO set_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nebeisa walobo yun Yesusre yaweungehoke ikete Yerusalem yone Allahre ei mom-mom imae na kaban kiyae maline haungeboke. Nebeisa mo weunge, “Na hele Weyae Allahle Keluna, mana ndara are honoinyihi oyo. ");
INSERT INTO set_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Allahle homofaene Waei naeise nda a moloukoke honole, ‘Allah na malaikat yoni-yonire wemmile Waei kayaa hebenate. ");
INSERT INTO set_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Woro rukane nele belene na malaikat yoni-yoni mene roungayete.’ ” ");
INSERT INTO set_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesus yae weunge, “Allahle homofaene nda a moloukoke, ‘Tuhan waei Allah, me u hire kelembondere u wabu-wabu wanen mae ewabeinyemae.’ ” ");
INSERT INTO set_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Walobo yun Yesusre mekai mahi-mahi yae meungewabeukoke baeufoke hee yae, Yesusre nembai nukeungeboke, nebeisa ya mon hine ereumeke. ");
INSERT INTO set_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Allahle Roh ikeunge elae bele Yesus Galilea kanire bukeufike ewole. Nebei kanine Yesusle a faeungekoke huwayeke. ");
INSERT INTO set_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Allahre ei mom-mom imae yoni-yonine keleumiyeke, ro miyae nemene Nare buma kaewainye. ");
INSERT INTO set_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesus Nasaret yone kaban yeuboke. Roko mbai nebei yore eke. Sabat ya mo naei mokoyate huluinye Yesus Allahre ei mom-mom imaene eke Allahle homofae kongkondere afae yae aunguke. ");
INSERT INTO set_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nare Allahle yendo kayaalo Yesaya moloukoke homofaebe ikainyele. Nda homofae na rulune ikainyelebe Yesus wekeunge Naei uwa naei a moloukoke koukoke, ");
INSERT INTO set_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Allahle Roh Rauwane keteufeboke. Allah Rare eleufeboke a foi faeu foise hun ban wai ban yore hufemiyendere. Allah Rare ukeufe mekale nda me u mokorebondere. Ikilaimikoke yore bulaereremibonde, Ijoko erei yo mokoremile ijoko erenate, Hiwa yo naei me kelene nekate yore haisemikonde, ");
INSERT INTO set_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nane merau ufemile nda ya Allah ro miyaere foi mokommile.” ");
INSERT INTO set_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nebei homore mo Yesus oleungekoke ikeunge kiyaere benen beungehoke wa, nebeisa angken ounguweuboke. Nebei imae einye ro miyae nemene ijoko Nare mo mokaiboke erewainye. ");
INSERT INTO set_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Yesus huba raweuboke ro miyaere uwoumi, “Nda homofaene a huwe a relen kolowate yembondere elayeke, mana ya mai ro be ro yoinye na hului yeuboke.” ");
INSERT INTO set_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","A foi sele elewolene, ro miyae fa yae bowate buma kaewainye elate, “Nda Yusufle fa mo. Naendae wanen mae nda ma meke mokole?” ");
INSERT INTO set_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesus yae nebei yore weumi, “Reyae isaeyeubokale mayae nda are wenselere, ‘Dokter, waei ube onomi yeinye. Meyae borowande Weyae Kapernaum yone rambun emere-emere mokowoyae. Mana weyae kabande yeubokae yone nebei wanen mae mokoikone!’ ” ");
INSERT INTO set_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yesus benende weumi, “Allahle yendo kayaalo mbai na yone yanne ro ban. ");
INSERT INTO set_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nebeibe borombo ba! Allahle yendo kayaalo Elia na wali nekewole heene ralo yakama name bohi bele ya omoloikoi mone nebei kanine moni mai nekeumi kowate. Nebei hee miyae nannale (rora molowate yo) Israel kanine nekai nekewate. ");
INSERT INTO set_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Nebeibe Elia nebei miyae nannale hile bokore ewei ei. Sarfat yore Sidon kanina miyae nannale mbaite bokore mo Allah yae ukeunge ewole. ");
INSERT INTO set_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nebei sului mbai yendo kayaalo Elisale heene Israel kanina ro miyae u bauwau (kusta) helen sele nekeumi kowate. Nebeibe, nebei kowate nolora hi yae ha yae onomi erowei mo, Siria kanina Naaman nembai sele onomi rouke.” ");
INSERT INTO set_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nebei ro miyae ei mom-mom imaene nekewate yo borokainyelene, ikelere yeumiboke. ");
INSERT INTO set_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Na riyane ainyukate Yesusre hukainyeke yo moinye ai baleke ekate a yaeyae mbai nebei yore honole kelaeunge. Nebei yo merau harainyeboke Yesusre a yaeyaene kinyenaibonde onderebe, ");
INSERT INTO set_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","nebeibe Yesus ro nolo miyae nolora waeisi-waeisi koukoke aloungekoke ewole. ");
INSERT INTO set_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nebeisa Yesus Galilea kanina Kapernaum yore eke Sabat yane Yesus ro miyaere kelewoumi. ");
INSERT INTO set_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Naei yo malo waku malo bele meke elewolene, Naei a faeu elewolere ro miyae fa yae bowate. ");
INSERT INTO set_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nebei ei mom-mom imae eise ro mbai alo yae aungeboke kiyae eweufike. Nebei ro kali yae hebeungekoke kaenewole, ");
INSERT INTO set_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Yesus Nasaretna Ro rahere maere mokoumebondere? Weyae maei hoikoise mekae? Reyae Ware raeisaei! Weyae nene waewae Kiyae Allahlera mekae!” ");
INSERT INTO set_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesus yae nebei alore weunge, “Hileibo! Nda role u bulura eituwe!” Nebeisa ro miyaele bene alo yae nebei rore kaeuboke woke na maleu-maleu wae eukuke. ");
INSERT INTO set_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nebeinya ro miyae nemene naeise-naeise elate, “Ei! A korolo ukeunge? Naei uwane kitainyeboke yae walobo yoni-yonire enaibalende hukeimeyeumi baleyate!” ");
INSERT INTO set_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yesus nda me u keleubokene Naei ro nebei kanine hurewole. ");
INSERT INTO set_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Allahre ei mom-mom imaera Yesus meukuke Simonbe imaere ewole. Simon na miyae nenake naume kaban sele ekekolene, ro miyae yae Yesus hakonnebondere riwainye. ");
INSERT INTO set_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Simon na miyae nenake honole ijende Yesus eke, nebei naume hukeungehike, na hibi foi rouke. Nebei miyae aunguke Yesus naei mekatene humfo wamfo bewole. ");
INSERT INTO set_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Be baheweke mo ro miyae era yo buloo yo nemene yauwaimi Yesusle bokore mewate. Yesus mere mo na u ranne koloumiyeke, nera buloo ninae nundayeke. ");
INSERT INTO set_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nebei alo yoni-yoni ro miyae une nekayeke nele bele balayeke kaenayeke, “Weyae Allahle Fa hele ya!” Alo yoni-yoni naeisaei Yesus Wali Ondofolone, nebei alo yoni-yonire Yesus oku yae rorowoumi a elenatere a hun kolowoumi. ");
INSERT INTO set_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ya heuboke mo Yesus a haei-saei mbainye maleu eke nekewole. Ro miyae nare baei-baei baewainye, nebeisa mekate erekainyele wainye, “Maere enukeimemae ya!” ");
INSERT INTO set_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nebeibe Yesus weumi, “Allahle holona yo Raei me kelee u keleene nekenate naei a foi faeu foi yo hi yo hi bele yae hufemiyendere, rabuhine ban nebei naeise Allah nda kani kelare ukeufe mekale.” ");
INSERT INTO set_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nebeisa Yesus Yudea kanina ei mom-mom imae hira-hira huweumiyeke. ");
INSERT INTO set_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ya mbai mo Yesus meke Genesaret bu yabainye meke hebewole, ro miyae kilin-kilin hoi-soi Allahlera a foi faeu foise angkaeise boronatere. ");
INSERT INTO set_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nebeisa Yesus euweke erele bae ka yo naei kai bee maeiyorouboke, kaisa wayakoukoke na waunge bune hukate. ");
INSERT INTO set_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesus nebei kai yatere eke, Simonbe kiyaene yeufileukoke. Nebeisa Simonde ukeunge raufe yae ebi fere neufike mo, nebei kai randa Yesus angken mae nuweuboke mo nebeinya ro miyae helen arilewolere kelewoumi. ");
INSERT INTO set_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Keleumikoke mo, Yesus Simonde weunge, “Ebi fere raufe yae neufinde imale mo, wa wau nebeinye wowonde kare haumalere.” ");
INSERT INTO set_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nebeibe Simon mae Yesusre weunge, “Tuhan, nda reniai koko lon mehi mehi hayeyandere bae, ka mbai sambai maei waunge ofoisi mo! Nebeibe weyae ukaraene reyae benen ufoyondere.” ");
INSERT INTO set_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Yesus are eleukoke huluinye wokate bae ka wau eise maemae koukoke, na wau huba raweuboke kaiwole. ");
INSERT INTO set_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Helen selene kai hina yore kaenewaimi. Kai hina yo bele mekate hakaimiboke hauwate. Nebei kai bee hawaikoke maemae koukoke, bu ike kai wanei kaneungeboke. ");
INSERT INTO set_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon nebei ma erekene meke Yesusle bene oro selen-selen mae roroukoke weunge, “Tuhan, ninae rare nukeisobone. Reyae beko yae bako yae maemae koufekoke.” ");
INSERT INTO set_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simon mae, ro hiwa nanembainye orate yo yae nda ka helen hauwatene yei yae kowate. ");
INSERT INTO set_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nebei sului mbai Simon naei holo mbainye orate yo Yakobusle Yohanesle Zebedeusle fa-fa bee bele. Nebeisa Yesus yae Simonde weunge, “Fe efaeijae Simon! Mana yara weyae rore miyaere wau hayewendere yobole Rangkele mbainye nekemale.” ");
INSERT INTO set_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nebei yo na kaise mo yobaiboke yaufe ike bae, nemene fomene nukaiboke hayaiboke Yesusre hakainyekoke. ");
INSERT INTO set_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nebei kanina yo mbainye ya mbai Yesus nekewole yae, nebeinya ro mbai u bauwau na ure nekai sele feleungeboke Yesusre erekeungene, na be are yae neke riyewounge, “Tuhan, Weyae kena kolena, rare onomi yeufele!” ");
INSERT INTO set_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesus na mere mo nekeunge nda rore kataungehike wa weunge, “Reyae kena kale, onomire rowelere.” Na hibi hele nebei u bauwau kowole u yeuboke. ");
INSERT INTO set_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesus nebei rore weunge, “Boroyae, ro hi miyae hire eisuweijae. Oro moloubonde, imamde hebele kiyaele bere ele, onomi yeuboke naei uwa yakaungebonde. Musale walora wali heere foloukoke a huluinye Allahre hili era akau erare ongkou wae felennebonde naeise obo yoku mbai yeungele. Nebei mekai yae isaeyeumibonde weyae na hele onomi roukae.” ");
INSERT INTO set_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Naendae wanende bae, Yesusle a heraeyeuboke elewate nane merau ro miyae helen sele Naei a faeu elewole borayeke naeise, nane merau nera buloo kayeke hireumiyeke onomi yaronaikonde naeise, Yesusle bokore mewate. ");
INSERT INTO set_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yesus roko helen Naekore ebeli boi-boise a haei-saeinye eyewole. ");
INSERT INTO set_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ya mbai Yesus ro miyaere kelewoumi hee yae Farisi holona yo bele Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi yo bele nebeinye raiboke borowainye. Nda yo hiwa Yerusalem yora, hiwa yo Galilea kanira, hiwa yo Yudea kanira mewate. Yesus Na uwane Allahle elae wake keteungeboke yae erana buloona yore na hului onomi iwoumi. ");
INSERT INTO set_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nekate mo, hiwa yo ro mbai oro mere nimewainyebe na ijongku honson bele kaeibokate mekate. Yesus imae einyene nebei yo relewainye Yesusle bene ranaisindere. ");
INSERT INTO set_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ro miyae ahuneubokene kaenaibonde enatere na hului ban, nebeinye kaeibokate imae malire yae ikate, yande mo wewe kaikokate na honson anuwau bele ro miyae hebate nolone Yesus hebele bene nokainyele oke. ");
INSERT INTO set_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Na hila rabo erewoumi elaekei selene nebei rore Yesus yae weunge, “Aka baeke wa beko bako faeinyeubokawale.” ");
INSERT INTO set_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nebeibe Farisi ro yoni-yoni hebate bele, Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi yo bele naeise naeise elate, “Nda ro ndebe meke Allahre aukaka mekeukounge?” Ro miyae naei beko faeinyeiboise ro hi miyae hi yae na hului ban. Allah nenaeijaere na hului. ");
INSERT INTO set_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Nebei yo na u benera hayaeinye a Yesus isaeyeubokene weumi, “Mai kena u einye a na hele ban elaube! ");
INSERT INTO set_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Mayae elaube, ‘Na foma-foma hele Yesus nda rore weungele, wa beko ninae faeinyeubokawale, rabuhine ban yembonde naeise ro miyae ereiboinye. Nebeibe ehekaei kiyaebe Yesus wennele, ainyu, wa koi kaeibo eye, rabuhine ban ro miyae erenaterene.’ ");
INSERT INTO set_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mana Reyae kelerembombere Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae nane merau Allah one hengko bele kiteufeboke yae Reyae mere mokale. Reyae na hului beko bele neban bele yore faeinyeremile.” Nebeisa oro mere nimewainye kiyaere weunge, “Ainyu, wa ijongku honson kaeibo na hibi aloinyoko wa imaere eye!” ");
INSERT INTO set_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Na hibi nebei yo naei nolone aunguke na kewa yumakere mo yaroukoke aloungekoke ewole Allahre buma kaeungeke. ");
INSERT INTO set_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nebei ro miyae euwa kaeu-kaeu mo kaeuwate Allahre buma kaewainye. Nebei yo na fa bele bowate elate, “Era emera hele mana ya nda mekai yeuboke erande.” ");
INSERT INTO set_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yesus nebei anuwaufa oro molouboke ewole yae, ro mbai na ro Matius pajakre arilate imaene nekewolebe erekeunge. Yesus yae weunge, “Rare hakoisobo!” ");
INSERT INTO set_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lewi aunguke nemene fomene nukeuboke hayeuboke Yesusre hakoungeboke. ");
INSERT INTO set_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nebeisa mo Lewi Yesusre raman bulau mbai mokouboke. Lewi naei kalia mbainye mokate yo helen arilewole nane merau ro miyae hiwa yo bele yae mekate Lewile imaene Yesus naei nanembainye raman anewate. ");
INSERT INTO set_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farisi holona yo bele Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi yo bele Yesus na moisa orowate yore waimi, “Rahene pajakre arilate yo bele ro miyae beko bakore mokoyate yo bele nanembainye alaeuboke raman anaube?” ");
INSERT INTO set_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Nebeibe Yesus yae weumi, “Onomire nekate yo onomire mokoumi rore ebaeyei, erane buloone kate yo yae baeyainye. ");
INSERT INTO set_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Wali himalainyeboke yo yae nauware elate yore Reyae kaeneremile naeise mekale ban, bekone nebanne mokate yore kaeneremile nulu kenaimibonde naeise mewale.” ");
INSERT INTO set_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nebei ro miyae Yesusre wainye, “Yohanesle moisa orowate yo, Farisi moisa orowate yo bele roko mbemba yarele me heiboyate nane merau naei ebeli bele ibowainye, nebeibe wa moisa orowate yo nendon raman anate.” ");
INSERT INTO set_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesus isaeyeuboke na heki ban mo Nare honaibonde. Neyae kani kelane nekele naeise raman bulau wanen a yae ahuneuboke weumi, “Ro mbai miyae neme rowele raman bulau mokoiboyolere hokoimeyele yo nebei ro bele nanembainye nekate yae yarele me heiboyate! Nebei mekai ban. ");
INSERT INTO set_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Raman bulau baensonde mo, nebei molo neme naei u nolo u kaisa ahaufe ende wa. Nebei hee na kahili wa na hului yarele me heiboyate nekate.” ");
INSERT INTO set_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","((Nda ahuba beene malo male bele anggur bu anuwau male bele na u mekai Musale walora wali heere foloukoke are hakainye ro miyae wanen Yesus yae a ahuneuboke. Malo neme bele anggur bu anuwau neme bele na u mekai Yesus Naei a elelere hila rabo halaeinye ro miyae wanen a ahuneuboke.)) Nebei ahuba nda mekai huwoumi, “Hangkande malo neme yae malo male ranne oboyei. Rabuhine ban nebei malo neme kingkombonde malo malere yobongkonde benen kaban sele kayengkonde. Nane merau nebei malo neme malo malene hakan ungatena nayaka yembonde. ");
INSERT INTO set_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nebei sului mbai anggur bu neme anuwau malene erileyei. Rabuhine ban nebei anggur bu kaban bende, mokonnebonde nebei bure rilate anuwau ferengkonde, beko yembondene bu rilengkonde baensonde. ");
INSERT INTO set_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nebeinye hole moloiboise anggur bu neme anuwau anggur bu neme yae rilengkombe. ");
INSERT INTO set_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nde yae anggur bu henara aneufikera mo benen anggur bu bale-balere anensindere riyewole? Nenaeijae elengkonde anggur bu hena mbai naei foi sele.” ");
INSERT INTO set_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabat ya mbai mo Yesus na moisa orowate yo bele gandum heke nolora ewate na gandum ani bele hokayeke me yae haeyeke na rabingkae balayeke nebeisa euware anayeke. ");
INSERT INTO set_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Farisi yo yae wainye, “Rahene Yahudi naei era henare mayae asasi kaube, Sabat ya yae omokoi rambunbe mayae mekaumokaube?” ");
INSERT INTO set_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Nebeibe Yesus yae weumi, “Naendae wanen, aei yobe Ondofolo kaban Daud na moisa hakainyekoke orayeke yo bele monine kowatene mokouboke u mekai mayae homone okoikoi? ");
INSERT INTO set_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Allahre ei mom-mom imae eise eweufike imam yoni-yoni yae mo anenaikonde feube yaroukoke na moisa hakainyekoke ro miyae bele ikeumi anaikoke. Musale walora wali heere foloukoke a huluinye nebei feu ro miyae hosoro anei sului.” ");
INSERT INTO set_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nebeisa Yesus weumi, “Reyae, Allahle bokora mekale ro miyae uware yeubokale Kiyae, Sabat ya na yunde yeubokale Reyae Niyae.” ");
INSERT INTO set_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabat ya hine mo Allahre ei mom-mom imae mbainye Yesus eke kelewoumi. Nebeinye ro mbai na me meube reufi nimainyekoke nangkele eweufike. ");
INSERT INTO set_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi yo bele Farisi holona bele Yesusre kemere nenainyebonderene na ijoko ranne mo erainye, Sabat yare hiwa yore onomi yemmikonde era. ");
INSERT INTO set_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nebeibe Yesus na u benere nekaimi ma isaeyeuboke. Nebeisa nebei ro na me reufire nimainyekoke kiyaere weunge, “Ainyu ndane meisebeinyu!” Nebei ro aunguke, yeufebeunguke. ");
INSERT INTO set_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nebeisa mo nebei ro miyae nebeinye arilewole yore Yesus yae weumi, “Musale walora wali heere foloukoke a huluinye rahebe Sabat yane mokomale? Foibe mokomale, bekobe mokomale? Ro miyae wali holebe molomamile, hoi-soibe homale?” ");
INSERT INTO set_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nebei ro miyae nekatere nemene ereumikoke mo, nebei rore weunge, “Wa me neinye meu.” Nebei ro na mere mo nekeunge, na hibi na me foi yeuboke. ");
INSERT INTO set_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nebeinye Musale walora wali heere foloukoke are isaeyaeikoke kelaeimi yo bele Farisi holona yo bele ikele hele kowate, arilaisike Yesusre mokonainyebondere ane kolowainye. ");
INSERT INTO set_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ya mbai Naekore ebelire bonnele naeise Yesus mokore yeuketeke, reniai koko Allahre ebeline mo boungemeke. ");
INSERT INTO set_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ya yolowole wa, na moisa orowate yore kaeneumikoke, nebei nolora ro me bee oro nen bee bele eleukoke wekeumi. Nda eleukoke yore Naei abu ako yae kaenewoumi. Nebei yo na ro nda niyae, ");
INSERT INTO set_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon (Petrus yae Yesus ro roungeboke), Andreas Simon na aka baeke, Yakobus, Yohanes, Filipus, Bartolomeus, ");
INSERT INTO set_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matius, Tomas, Yakobus Alfeusle fa kayee, Simon (Zelot yae kaenainye kiyae), ");
INSERT INTO set_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudas Yakobusle fa, meke Yudas Iskariot kelaise neke kiyae. ");
INSERT INTO set_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesus nebei ro eleukoke yo bele mokora nanembaisa okate fau mbainye waisebeuboke. Nebei faunge ro miyae Yesusre hakainyekoke yo arilewole. Nane merau ro miyae helen hokowole, Yudea kanira, Yerusalem yora, nane merau bu haeinya yo beera Tirus bele Sidon bele. ");
INSERT INTO set_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nda yo hokowole Yesus a elende boronate naeise, nane merau nera buloo katere Yesus onomire yemmile naeise mewate. Alo yae aumiboke kayeke yo mekate, Yesus onomi iwoumi. ");
INSERT INTO set_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yesusle bokore ro miyae Na uware ikilenatere waere-waere relewainye, rabuhine ban Na uwara onomi yeumi elae nebeinya ro miyae nemene onomi yeumikoke. ");
INSERT INTO set_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesus na moisa orowate yore ereumikoke mo, nebeisa weumi, “Mayae keren ban nale ban yo na hului Raei me kelee u keleene nekembene, onomi foka hubannembe! ");
INSERT INTO set_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mayae nda heena monire kaube yo Allah mare narenembe uwa rembombene, onomi foka hubannembe! Mayae nda heena rimere are kaube yo re ensarengkombene, onomi foka hubannembe! ");
INSERT INTO set_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae aerene mare ikele konayembe, hukenayembe, a beko huwayembe, ro u mekai beko bele yae kaenenayembe yo onomi foka hubannembe. ");
INSERT INTO set_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Yo koi yo bae rei mai nendon kombe, rabuhine ban mai me buhae kaban sele surgane mokoungehake. Nendahina nebei u mekai beko ma yae na yobe nebei naei yae me u mbai Allahle yenjo kayaayore mokowaimi. ");
INSERT INTO set_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Nebeibe mayae run bele kangke bele hemboni bele rela bele yo beko hele hubannembe, rabuhine ban mai foi ninae nda waline mo hubaimeyaunge. ");
INSERT INTO set_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mayae nda heena kuikui maemae bele honoimeyayembe yo beko hele hubannembe, rabuhine ban moni mai ennehubambe. Mayae nda heena re are koimeyaube yo beko hele hubannembe, rabuhine ban kena beko yae rime a yae engkombe. ");
INSERT INTO set_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mayae nda kanine eise moloimeyayembe yo beko hele hubannembe, rabuhine ban nendahina Allahle ban yenjo kayaayore naei wanen mbai aei yobe naei kamahe naei yae ei molowaimi!” ");
INSERT INTO set_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Mayae boraufele yore Reyae wamale, mai yokeijore buhae hemmiyembe, ware ikele koimeyete kiyaere me u foi yae mokoungele, ");
INSERT INTO set_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ware olomore roronete kiyaere Allah riyeungele foi yae mokonnele, ware bekore mokonete kiyae naeise Allahre ebeli boungele. ");
INSERT INTO set_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nde yae wa kahu reufi mefae ungetena, na reufi bele yeungele ungete. Wa ambelae rowendena, waeungehinde rowende nane merau malo hi bele yeungele. ");
INSERT INTO set_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Rambun hi rinyetena, na hibi nebei rambun yeungele. Waei rambun nukensandena, benen beneufonde naeise huku-huku yae okoinyemae. ");
INSERT INTO set_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ware mokonayetere kena koyae ma, naei sului mbai yae hiwa yore mokoumile. ");
INSERT INTO set_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ware kena buhaere heyayete yore mo wa kena buhae heumilena, rahe foibe rowele? U mekai bekore bakore mokoyate yo naei wanen mbai mokoyate. ");
INSERT INTO set_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nane merau ro miyae ware foise mokoyayete yore mo waei foi mokoumiyendena, rahe foibe rowele? U mekai bekore mokoyate yo nebei wanen mbai na hului mokonaikonde! ");
INSERT INTO set_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Benen benayeubonde bene yae nekenayetene elae yo wake yore wa hemboni rela yeumiyendena, rahe foibe rowele? U mekai bekore bakore mokoyate yo nebei wanen imokowate yeumira nebeisa riyeisiyaimile. ");
INSERT INTO set_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Naei sele nebei wanen ban! Wa yokeijore foi mokoumile nane merau buhae heumile. Nane merau ma hemboni rela yokeijo yae rinyetena, benen beneisote naeise u bene enekeijae. Wa me u naei wanen mokolena, Allah Hubalo Mando waei roibu hobeneikote, nane merau Allah Naei kelu omi yae ware elengkonde, rabuhine ban ro miyae helen foi eweyei yo bele u mekai bekore bakore koyate yo bele Allah foi yae mokoyeumi. ");
INSERT INTO set_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mai Ako Allah ro miyaere yanekoi yase yae ei haweyeumi wanen mae mayae yanekoi yase bele nekembe.” ");
INSERT INTO set_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Weyae hiwa yo naei bekore hului okoloijae, waei bekore hului ranayeisite bele. Ro miyae naei are weyae a hele ban mae eleijae, Allah ware beneufonde bele. Ro miyae hiwa naei beko u bene nundenayewende, nebei wanen mbai Allah waei beko faeinyeneibote. ");
INSERT INTO set_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nendon yeumiyende waheumiyendena, nebei sului mbai ware mokonayewende benen kone-kone maemae enaikitete. Mehinin mae kolole yeumilena, nebei sului mbai ware mehinin mae kolonayewende inyayewende.” ");
INSERT INTO set_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Nebeisa mo Yesus nda a ahuneuboke huwoumi, “Ijoko kumba kiyae benen ro ijoko kumba kiyaere yawennehondena, nebei bee bo einye eneibalende. ");
INSERT INTO set_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Guru mbai naei isaei bumana na fa-fa keleumira. Nebeibe isaei isaeyaeikoke fa-fa na guru u mekai wanen mbai nekenate. ");
INSERT INTO set_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Rahene wa aka baeke na ijokona kerende mo weyae eranae, nebeibe o kaban wa ijokonare bae weyae ereiboi? ");
INSERT INTO set_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Naendae wanen mae wa aka baeke na ijokona kerende rowelere weyae weungele, ‘Mei, wa ijokona keren roufei,’ nebeibe o kaban waei ijoko einyare bae weyae ehubaisi sele! Weyae faeu kai bee! Wa ijokona o kabanbe rowei! Ijoko foi erele mo wa, nebeisa wa aka baekele ijokona keren rowele.” ");
INSERT INTO set_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“O foi ha foi na ani bekore omokoiboi. Nebei sului mbai o beko ha beko ani foise omokoiboi. ");
INSERT INTO set_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nanira rowate ereiboyatera, nebeisa na no ro roiboyainye. Fonom kaiwa ara ani yae omokoiboi nane merau isa bele ora anggur ani yae omokoiboi. ");
INSERT INTO set_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nebei sului mbai u mekai foi bele ro miyae na kena une foi honainyera a foi faeu foise eleyate. U mekai beko bele ro miyae na kena une beko honatera a bekore eleyate. Na kena u einya hului mbaibe neuwara baleimeyate.” ");
INSERT INTO set_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Rahene mayae Rare kaeneyaufe, ‘Tuhan, Tuhan,’ nebeibe mai wali bae Raei a weyamale huluinye omokoyei? ");
INSERT INTO set_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ro miyae Rangkele mbainye nekate yo nane merau Raei are boraise huluinye mokate yo naeise Reyae kelerembombe. ");
INSERT INTO set_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Naei u mekai ro mbai imae ruka ranne heuboke wanen. Alune yane hu foi mekele foinyene nebei imae kusei mahei ban hebende. ");
INSERT INTO set_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ro miyae Reyae huwamaele are boraikoke mere ure omokoyei yo naeise Reyae kelerembombe. Naei u mekai ro mbai na imae ifau ranne heuboke wanen. Alune yane mende wende nebei imae kelambonde kulun ya, nemene beko yembonde.” ");
INSERT INTO set_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nebei ro miyae arilewolere nebei a weumikoke mo, Yesus na hibi Kapernaum yore ewole. ");
INSERT INTO set_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nebeinye fela yun mbai naei kena koungeke yebaei bubaei erane hereinyen-hereinyen kowole. ");
INSERT INTO set_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nebei fela yun Yesusle a borokene, Yahudi yun-junde ro keli name weumikoke Yesusle bokore enate, rinyainyehinde na yebaei bubaeise erane kolere onomi menneyendere. ");
INSERT INTO set_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ekate mo, Yesusre na kena maemae riwainye wainye, “Nda fela yun na yeisi raeiboi hului na yebaei bubaeise onomi yeungele, rabuhine ban ");
INSERT INTO set_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","maei ro miyaere kena buhae heyeumi nane merau maei ei mom-mom imae heuboke.” ");
INSERT INTO set_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesus nebei yo bele nanembaisa alainyekoke ewate. Na imaere nobewounge bae, nebei fela yun na kahili ware ukeumi ekate Yesusre ungainyele, “Tuhan, maei rowa elele naei imaere eijae, rabuhine ban neyae yeise raeiboi ban nauware ereungene. ");
INSERT INTO set_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nebei aerene renaei yae Waei bere ei sele. Weyae are mo eleiko, nda yebaei bubaei erane koyele kiyae onomi rowende. ");
INSERT INTO set_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Reyae maei fela yun hi na me kelee u keleene nekeyale nane merau raei keleena felayo hiwa rare boraise. Ro mbaise reyae ufende, ‘Eye!’ neyae ende; nane merau ro hire ufende, ‘Ndare mei!’ neyae mende. Nebei sului mbai raei yebaei bubaeise ufende, ‘Nda mokoibo!’, neyae mokombonde.” ");
INSERT INTO set_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nda a wanen boroukokene, Yesus fangkengke yae kowole. Euweke na moisa mate ro miyaere weumi, “Nda ro hele ken. Israel ro miyae nekate nolora nda role hila rabo wanen Reyae ehubayeikoi mo!” ");
INSERT INTO set_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ukeumi mekate yo naei imaere baeiboke ekate bae, nebei erane kole kiyae erainye aunguke onomibe rouke. ");
INSERT INTO set_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Na heki ban mo, Yesus Nain yore eke. Na moisa orowate yo, nane merau ro miyae helen Yesus naei nanembaisa ewate. ");
INSERT INTO set_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Meke Nain yo romau kaban nobeungeboke mo, ereumi ro miyae herebe no koloi einye kaeibokate nebei yo eisa maibaleke mate. Nda here miyaenale mbai (na molo nukengeboke) na kelu nembai sambai selebe hereke kaeibokate mate. Ro miyae helen sele hakainyekoke nda miyaenale rimeimeyelene mbainye mate. ");
INSERT INTO set_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Yesus euweke nda miyaenalere erekeungene, Na kena beko hele hubawounge weunge, “Ninae erimeijae!” ");
INSERT INTO set_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yesus ebi fere bere yae eungakeleufike mo, nebei here no kaeibokate matene na me ikileuboke. Nebei nore kaeibokate mate yo nemene hebaiboke. Yesus a weunge, “Ae, hokolo fa, Reyae ware wawale ainyu!” ");
INSERT INTO set_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nebei fa aunguke, angken nuweuboke wa a elewole. Nebeisa Yesus nenakele mene kinyeungeboke. ");
INSERT INTO set_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nebeinya ro miyae fangkengke yae bowate, Allahre buma kolowainye. Nebei yo yae elate, “Yendo kayaalo kaban mbai aei nolone meuwakauboke, Allah Na ro miyaere hakommibonde naeise meke!” ");
INSERT INTO set_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yesusle a Yudea kani nemene ninae hureukoke nane merau na kelaeunga yo bele borowate. ");
INSERT INTO set_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yohanes na moisa orowate yo Yesus na me u mokowole a Yohanesre huwainyekoke. Yohanes nebei yo mekate nolora ro bee kaeneumikoke, ");
INSERT INTO set_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ukeumile enete Yesusre nda a hineinyehinde, “Weyae na hele Allah are kolowounge kiyae niyae, meyae ro hibe rakemandere?” ");
INSERT INTO set_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Hokolo bee ekete Yesusre weinye, “Yohanes bure koumi kiyae yae maere ukeume mekende Ware hinaisitere, Weyae Allah are kolowounge Kiyae niyae, niyae ban, meyae ro hibe rakemandere?” ");
INSERT INTO set_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nebei hee erane buloone kayeke ro miyae helen sele Yesus onomi iwoumi, alo yae hauwaimi yo na alo yoni-yonire hukeumiyeke, ijoko erei yo mokowoumi ijoko erewate. ");
INSERT INTO set_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nebei aerene Yohanes yae ukeumi ekete beere Yesus weumi, “Bebo, mayae ijokore erekeube angkaeise borokeube hului yae Yohanesre huwennekobe. Ro miyae ijoko kumba nekayeke yo mana ijoko erate, oro rebeisi-rebeisi rebaeyeke yo mana ele mele kate, u bauwau kayeke yo onomi yarowate, angkaei kokun nekayeke yo mana angkaei borate, herewate yo walaeiboke, a foi faeu foi keren ban nale ban yore bele ekehuwoumi. ");
INSERT INTO set_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ro miyae Rare hakoyaise aerene ehekaei hubanainyelebe Rare moi ebulei kiyae, onomi foka hubanainyende.” ");
INSERT INTO set_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yohanes yae ukeumi mekete ro bee ewote mo, Yesus huba raweuboke ro miyae helen hebatere Yohanesle ane weumi, ");
INSERT INTO set_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","“Rahere erembomberene mayae a kala-kalare eyewaube, nebeinya kena u wauwaufe koyate holona ro mbai naei u mekai o mbai alu yae ndire ndare kuseunge wanende erembombere? ");
INSERT INTO set_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Rahere erembombere eyewaube, ro mbai malo maye-maye hireukokere erennebombere? Niyae ban! Ro miyae malo maye-mayere hirate yo bae nane merau nime kaungei nolone nekate yo ondofolo yoni-yoni naei imaena. Nebeise banna, rahere mayae eyewaube? Yenjo kayaayo mbaise erennebombere? Na hele. Reyae mare wamale, neyae Allahle yenjo kayaayo holore moi wokeumi. ");
INSERT INTO set_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Nane merau naei naeise Allahle homofaene homo molaikoke. Neyae Raei burelen boi-boi rore yeuboke naeise Allah yae Rare ukeufe are Maleakhi moloukoke, ‘Nda niyae Raei burelen boi-boi ro. Neyae Weyae mele nibi a mokoisaise nare bere holo yae ufende ende.’ ");
INSERT INTO set_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Reyae nda a na helebe mare wamale, Miyae naei kou ei yahi eisa honowate yoni-yoni nolora Yohanes bure kowoumi kiyae na bumane hele. Nebeibe ro ban sele ro miyae Raei me kelee u keleene nekate holona yo Yohanesre moi wokainye.” ");
INSERT INTO set_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nebeinye arilewole ro miyae nemene pajakre arilate yo bele Yesus huwoumi are boraikokene, Allahle wali nibi are na ijen elaikoke. Yohanes nebei yore bu koumikoke. ");
INSERT INTO set_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nebeibe Farisi holona yo bele Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi yo bele Allahlena mehinin kolowounge na wali holere molommibondere kena ban. Nebei yo Yohanes bure kommikondere ahi yae elewate. ");
INSERT INTO set_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesus benen weumi, “Rahe rambun mae nda holona ro miyaere ahundebonde elerekonde? Naei u mekai naendae wanen mae elerekonde ban? ");
INSERT INTO set_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nebei yo fa-fa rambun nai hei-sei anuwaunge roiboyate naei hokolo uneyaufe kaenaimi wanen waimi, ‘Mai naeise meyae suling ranandebokebe, nebeibe mayae bae okoi mo. Meyae here rime wanenjekebe, nebeibe mayae rime erimei mo.’ ");
INSERT INTO set_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Rabuhine ban Yohanes meke bae raman bele bu bele nendon ban aneinye, mayae elaube, ‘Alo yae aungeboke!’ ");
INSERT INTO set_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nebeisa Reyae, Allahle bokora mekale ro miyae uware yeubokale Kiyae, raman bele bu bele nendon mae analene, ro miyae elate, ‘Ndi ro erenne, raman mali bu mali ro, pajakre u bulu-bulu buleyate yo bele ro miyae beko nebande mokoyate holona yo bele kahili awaikoke.’ ");
INSERT INTO set_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Allahle isaei hebaen bele ro miyae me foi u foi mokoyatene, erenate ro miyae yae naei foi naeise elenate.” ");
INSERT INTO set_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisi holona ro mbai na ro Simon Yesusre riyeungehike meke ramande enei anengkondere. Naei imaene ekete raman anewote. ");
INSERT INTO set_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nebei yone maengke mbai na wali beko yae maemae koungekoke. Nebei ya Yesus Farisi holona ro Simonbe bokone ekete raman anewote borokene, minyak kembo fololo bele mongkon kaei-kaei yayatebe rouke Yesusle bokore eke. ");
INSERT INTO set_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Eke Yesus na moinye noro kelaeunge hebeunguke rimene rimewole. Na ijoko ibo balewate Yesusle oro ranne. Nebeinye na umaa yae rouke hobewounge kalangkondere. Nebeisa yoi yae huneungeke nane minyak kembo fololo belebe Yesus na orone heungeke. ");
INSERT INTO set_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Farisi holona ro Simon Yesusre ramande riyeungehike meke kiyae nebei wanen ereubokene na kena eisa elele, “Nda ro ramanne anende kiyae na hele Allahle yendo kayaalona, nda maengke na wali beko ma nemene isaeyembonde.” ");
INSERT INTO set_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nebeisa mo Yesus yae Simonde weunge, “Simon, Reyae a mbaise ware ufetere.” Simon mae weunge, “Guru, nendon weise.” ");
INSERT INTO set_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesus nda ahuba ahuneuboke weunge, “Ro bee, ro mbaise ekete roi riyeinyehike (nebeisa mo benen aheneikonde). Ro hi yae kalia ya 500 mokoukoube na hului yae riyeungehike, ro hi yae wa ya 50 mokoukoube na hului yae riyeungehike. ");
INSERT INTO set_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Hokolo bee aheikoi suluinye, nebei roi ikeumi ro ninae hobeukoke karo yae eleukoke. Nda ro bee nolora nde yae nebei ro roise riyeinyehike kiyaere kena buhae hele kowounge?” ");
INSERT INTO set_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon mae weunge, “Reyae bene nekeufe roi kabande rouke kiyae yae.” Yesus yae weunge, “Na helebe waei a eleukokae.” ");
INSERT INTO set_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yesus nebei maengkere ereungekoke mo, benen beufoke Simonde weunge, “Nda maengke eranae. Waei imaere Reyae mekalebe, nebeibe orore kuyeufekonde naei bu weyae omokoisai ((nda naei mokoyate era hena)). Nda maengke na ijoko ibo yae rorore kuyeyoufe benen rouke na umaa yae hobeufekoke. ");
INSERT INTO set_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Weyae rare yoi bulu ehuneisi mo, nda maengke eranae Reyae na meweufikalera Raei oro ninae yoi bulu yae huneyoufe ((ro melaeyeiboi wanen)). ");
INSERT INTO set_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Weyae Rare minyak fololo bele yae Raei yunda ehobeikoi mo, nebeibe nda maengke bu fololo bele yae Raei oro hobeufekoke. ");
INSERT INTO set_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nebeinye na beko bako helen sele faeinyeumikoke, rabuhine ban naei kena buhae kaban heufekoke. Ro miyae na beko ebi ken faeinyeungekoke, nebei ro miyae kena buhae ebi ken hemmiyende.” ");
INSERT INTO set_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nebeisa Yesus nebei maengkere euweke weunge, “Waei beko bako nemene faeinyeikokete.” ");
INSERT INTO set_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ro miyae hiwa yo nangkele raman mbainye anayoke yo naeise naeise a hin-sin mae hinate, “Nda ro maenin meke ro miyae naei beko bele mekeufaeinyeumi!” ");
INSERT INTO set_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nebeibe Yesus nebei maengkere weunge, “Rei mai yae ninae eye, Rare hila rabo halewaraene wa wali hole moloubokete!” ");
INSERT INTO set_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Na heki ban mo nebei kanina yo ebibi kaban-kaban nemene Yesus orowole a huweumiyeke, Allah merau raungehike Naei holona ro miyae Raei me kelee u keleene nekenate. Na moisa orowate yo me bee oro nen bee bele, ");
INSERT INTO set_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","miyae maengke helen, Yesus onomire iwoumi yo, nane merau alo yoni-yoni na uwara hukewoumi yo, Nare hakainyekoke. Nebei miyae maengke na ro nda niyae, Maria, Magdalena kaenenainyele (alo mehine bee belere Yesus na u bulura hukeumihike kiyae); ");
INSERT INTO set_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yohana (Khuza Ondofolo Herodesle imae eise wakun kayaare hebewole kiyaele miyae); Susana; miyae maengke hiwa helen nangkele. Nda miyae maengke naei roibu yae Yesusle holo naei wali rambunde hakowainye. ");
INSERT INTO set_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ro miyae helen Yesusle bokore yo hira yo hira hokowole. Erewole helen sele arilaisike wa, Yesus nda ahubabe ahuneuboke huwoumi, ");
INSERT INTO set_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ro mbai hekere mokondere eukuke o haka heraeyeweke hiwa nibine balayeke. Hiwa ro miyae oro yae alaeyeke, na hiwa yo aye yae anaikoke. ");
INSERT INTO set_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Hiwa kani ruka bele ranne balayeke. Nebei kani hele-helene nane merau bu banne hon ketaijeke na hibi kalayeke. ");
INSERT INTO set_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Hiwa hun isa bele kaiwa nolone balayeke, ketewatene hun nangkele ikate awainyekoke kalaukoke. ");
INSERT INTO set_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Nebeibe o haka hiwa kani foi kela foinye balayeke, ketewate, ani mokowate, faru wang-wang 100 bewate.” Nda ahubara huweumikoke baeufoke mo wa Yesus yae weumi, “Nda a boraube ro miyae nou foi hembe.” ");
INSERT INTO set_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Na moisa orowate yo Yesusre hinainye, “Nebei ahuba na no rahe mekai?” ");
INSERT INTO set_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yesus yae weumi, “Raei me kelee u keleene nekate ro miyae holo naeise na nunna honate rambun isaeyembombe naeise mare mo ikembe. Nebeibe, ro miyae hiwa naeise Allahle yendo kayaalo Yesaya nda a homone mokoukoke, ‘Neyae erenatebe, ijoko ereiboi nane merau boronatebe, isaeyeiboi.’ Nebei a hului benatene ro miyae hiware ahumbo-ahumbo yae huwamaele.” ");
INSERT INTO set_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Nebei a ahuneubokale huwaemale na mekai nda niyae, O hakare eleukokale nebei Allahle ako faeuko. ");
INSERT INTO set_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","“Nibine balayeke yo na mekai ro miyae nebei are borayeke yo. Nebei yo Rare hila rabo halenaisele belene, walobo yun mae na kena eisa meke nebei are nukeufake. ");
INSERT INTO set_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Ruka bele kani ranne balayeke yo na mekai ro miyae nebei are borayeke na kenane na foi sele hawayeke, nebeibe inyale ban kambu ban. Mon fofo nebei are na hele elenate, nebeisa walobo yun wabeisiyeumi na roko mbai balenate. ");
INSERT INTO set_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Hun isa bele nolone balayeke yo nebei niyae nebei a faeufe boraikoke ro miyae. Nebeibe nebei yo naei wali holere molommibonde aerene buhae hokoiboyoumi nane merau yeisi raeiboi walire kena haehae koyatene, nebei a faeufe ayeikoyainyene anire omokoi. ");
INSERT INTO set_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Kani foi kela foinye baleyate yo nebei niyae nebei a faeufe borowate ro miyae na kena u yolo-yolo bele, na hibi-hibi hila rabo halenayende, nebei a hului nekenate, ani nime bele mokowate.” ");
INSERT INTO set_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Hi yae ha yae ise releikoyeunge boloisiyele yae helai yae obumboi nane merau ijongku honson kelene eraisi. Imaere obere mate yo nebei hehe erenatere naei anuwaunge ambonde. ");
INSERT INTO set_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nda wali einye, aei yeyanne hului mbai Allah yae aere yeyeume hiwa bele barammekonde. Nebei aerene, boraube a u bene yolo-yolo yae nekenayembe. ");
INSERT INTO set_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Nebeinye Reyae wamale a naeise u bene foi yae nekenayembe. Mayae Allahle isaei hebaen mokombombena, Allah mare benen hi baranembombe. Allahle isaei hebaen bele kiyae helen barannele. U kiyae naei u bene nekainye hului honainyele bele enjarongkonde.” ");
INSERT INTO set_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesus nenake, na uwakewa bele naei bokore mewatebe, ro miyae helenne naei bokore menatere kabewainye. ");
INSERT INTO set_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nebeinye ro mbai eke Yesusre weunge, “Ana, wa uwakewa bele moinya ekaisebate, Wangkele hubayengkombere mekate.” ");
INSERT INTO set_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Nebeibe Yesus yae weumi, “Menakere, Raei uwakeware ufemile yo Maekole a faeufe boroyate, nebei suluinye mokoyate yo niyae.” ");
INSERT INTO set_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ya mbai mo Yesus na moisa orowate yo bele kai mbaisa hawaiboke. Nebei yore Yesus yae weumi, “Men, eyae ndi bu habala reufire fomalere.” Nebeinye nane yo kulunde mo ukate. ");
INSERT INTO set_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Au wae nekate bumoko nolore nare fowate yae, Yesus ijongkune feleungekoke. Ya alu kaban nda bu hubane raweuboke. Omboi kai eise bele hauwole bae, obulaenaikonde wanen mae kowate. ");
INSERT INTO set_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nebeinye Yesus na moisa orowate yo ekate nare yengke wainye, “Tuhan, Tuhan, eyae bune obulemakondere kande ya!” Nebeisa Yesus aunguke nebei alu rawele bele ruwae kaban belere a elae ukeungera uke kalaungeboke. ");
INSERT INTO set_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nebeisa Yesus kai einya yore weumi, “Rare hila rabo haleyaufe wauwaunge era mayae buhae hele hokombokembe!” Nebei yo na buhae bele hokowoumi fa yae bowate. Naeise naeise elate, “Nda ro nde maeninne? Alu boyene, alu ruwaene naei a bele weumi nane merau Naei ane boraiboke!” ");
INSERT INTO set_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesus na moisa orowate yo bele kaisa fokate Gerasa kanine Galilea kani bu habala reufinane. ");
INSERT INTO set_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesus yaunge akoiboise mo akouboke bae, ro mbai alo yae aungeboke meke na bokone meufebeunguke. Nda ro yo kaban mbaisabe meke, heki hele na melan mae mo oroweke, imaere nekende naeise ahi yae eleweke. Ruka ahe bulu here nore kolayeke nolone honoweke. ");
INSERT INTO set_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Roko yae roko yae alo yoni-yoni na aweiso-aweiso mo koyeunge. Naendae menen horo na me oro rantai yae rinainyekoke nane merau hiwa yo kayaa hebewatebe, hokoikoyole hayeikoyole, alo yae yaweisoyounge a kala-kala kabanire eyewote. Yesusre erekeungene, kali nekai kaenewole meke, na bene oro selen-selen mae roroukoke. Na u buluna alore Yesus ukeunge eukukene, nda ro kaenele, “Yesus Allah Hubalo Mando Na Fa, rahere rare mokoufebondere? Reyae riyawale rare beko omokoisemae!” ");
INSERT INTO set_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Nda rore Yesus yae hineunge, “Wa ro nde?” Nebei ro yae weunge, “Legiun,” rabuhine ban na u bulune alo yoni-yoni helen nekatene. ");
INSERT INTO set_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nebei alo yoni-yoni yae Yesusre riyei-tiyei riyainye benen a bulu na wauwau helere ewei eijae hele. ");
INSERT INTO set_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nebeinye moko enene obo nekai sele kate ramanne anate. Nebei aerene Yesusre wainye, “Maere waeimihi nebei obo kate uwa einye emayembon.” Nebeinye Yesus be hineumiboke. ");
INSERT INTO set_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nebeisa nane alo yoni-yoni nebei role uwara maibaleke nane obo kate u einye ayeuboke. Nebei obo habeleyate ekate a yaeyaera rorate bune wate nebeisa anaiboke. ");
INSERT INTO set_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Obo kayaare hebate yo nebei wanen erewatene, hakaikoke ewate yo eise bele yo moise bele a heraeiwate. ");
INSERT INTO set_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nebei yeubokere erenaibondere ro miyae yora yora balaimeke, Yesusle bokore mekate bae, nebei ro Yesus na u buluna alo yoni-yonire hukeumihike kiyae erainyele Yesus Noro kelaeunge nuweuboke. Ambelae hireukoke na u bene foi yeuboke. Ro miyae erewainye yo buhae yaraiboke. ");
INSERT INTO set_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Naei ijoko yae erewainye yo, ro miyae hiware Yesus na mekai nda role u bulura alo yoni-yoni hukeumihike huwewaimi. ");
INSERT INTO set_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gerasa kanina ro miyae buhae hele hokowoumine, Yesusre nebei anuwaufa endere uwainye. Nebeinye Yesus bukensindere kaisa fileukoke ewate. ");
INSERT INTO set_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Foise yeuboke ro Yesusre hakonnebondere riyewounge. Nebeibe Yesus yae weunge, ");
INSERT INTO set_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Beiso, waei yore eye. Allah ware onomi ikete a huweumiyende!” Nane ro eke Yesus na u buluna alo yoni-yoni hukeumihike a nebei yo kaban honole einye huweumiyeke. ");
INSERT INTO set_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesus benen bukeufike mewole mo, Nare rakeikoi kainye ro miyae erekainyele, ei hauwainyele. ");
INSERT INTO set_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ro mbai Allahre ei mom-mom imae yunde hebewole na ro Yairus Yesusle bokore na hibi meke. Yesusle bene oro selen-selen roroukoke riyewounge naei imaere enetere. ");
INSERT INTO set_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Na maengke ralo yakama me bee oro nen bee bele, naei mbai sambai sele kiyae, era buloone koumeke herendere eke kole. Yesus aloungekoke Yairusle imaere ewate mo, ro miyae hokoimeyele yae Yesusre uwa yae ayaeinyekoke. ");
INSERT INTO set_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nebei nolona miyae mbai ralo yakama me bee oro nen bee bele ha yae mo rileweke, hi yae ha yae onomi yeise na hului ban. ");
INSERT INTO set_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nda miyae Yesusle bokore moisa meke Na malo me yae kataungehike. Nebei hee yae ha rileweke na hibi heunguke. ");
INSERT INTO set_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesus Na uwara hubaungehikene hinele, “Nde Ra uwa kataufehike?” Nebei ro miyae mate yo neyae ban mae mo elate. Nebeinye Petrus yae weunge, “Tuhan, aei bokona ro miyae helen sele mande, Ware ayayekokete kilin-kilin hoi-soi hoimeyate.” ");
INSERT INTO set_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nebeibe Yesus yae weunge, “Ro miyae hi yae Raei uwa kataufehike ya. Reyae hubanale Raei uwana elae hi eukuke.” ");
INSERT INTO set_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nda miyae naei ura hubawoungene, na hibi oro me oinyeu hineuboke. Meke Yesusle bene oro selen-selen mae roroukoke. Nebeisa nda ro miyae matere huweumi rahene neyae Yesus na uwa kataungehike. Nane merau kataungehike heera na hibi ha heunguke. ");
INSERT INTO set_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nebeinye Yesus yae weunge, “Waei hila rabo haleyae huluinye nebeinye onomi roukae. Woro foi yae ele!” ");
INSERT INTO set_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesus ane namman elele mo, ro mbai Yairusle imaerabe mele Yairusre weunge, “Wa maengke ninae hereke. Rahe londe benen Guru waeli bengkendere!” ");
INSERT INTO set_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesus nebei a borokene Yairusre weunge, “Buhae ohokoijae! Rare hila rabo mo haleufele, wa fa annunde.” ");
INSERT INTO set_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yairus naei imaere ekate mo, Petrus yae, Yohanes yae, Yakobus yae, Yairus yae, Yairus na miyae bele Yesus ukeumi eise ayeuboke. Ro miyae a hun raumihike na moinye mo hebewate. ");
INSERT INTO set_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Moinye ro miyae arileweke nda fa hereke aerene mekate rimewainye. Nebeibe Yesus yae weumi, “Rime rimeijae. Nebei fa eherei, ijongkube honole!” ");
INSERT INTO set_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Rimere rimate yo neyae naeisaei nda maengke herekebe. Nebeinye Yesuslena a weumire neyae re yae harewainye. ");
INSERT INTO set_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nebeisa Yesus meke nane maengke hereke na mera ikileungeboke mo weunge, “Ainyu!” ");
INSERT INTO set_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nda maengke na unulu na u bulure meweufike bae na hibi waleuboke. Nebeisa Yesus ukeumi nebei fare ramande inyainyele anengkondere. ");
INSERT INTO set_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nenakele naekole fangkengke mo bowote. Nebeibe Yesus yae weumi, “Hire hare ehuweijae hele.” ");
INSERT INTO set_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesus na moisa orowate ro me bee oro nen bee bele kaeneumikoke alo yoni-yoni hukenaimiyende elae bele era yo buloo yo onomi inyaimiyende elae bele kiteumiboke. ");
INSERT INTO set_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nebeisa ukeumi ewate Allah merau raungehike Naei holona ro miyae Yesus Naei me kelee u keleene nekenate a faeu hungaimile nane merau era buloo kayeke yore onomi inyaimile. ");
INSERT INTO set_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nebeisa weumi, “Mai nibi a embe wali rambun ma mene eyaroi ei kayee nda niyae: mehukun, hokou, raman, roi, ambelae hi bele. ");
INSERT INTO set_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Makei imaene ungayembe nekembena, nebeinye mo nekembe kulun wembe embe. ");
INSERT INTO set_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Makei yone mare hukenayembena, membalembe hee mai orona kani bahere mo rubonnebombe. Nda iwau wanen kelemmibombe neyae beko hele mokaibokene.” ");
INSERT INTO set_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nebeisa Yesus na moisa orowate yo kulun ukate yo ran yo randa orayeke, Yesuslena a foi faeu foi huwaimiyeke, nane merau erane buloone kayeke yore onomi yaeimiyeke. ");
INSERT INTO set_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Herodes Galilea kanire Ondofolore hebewole hee yae Yesus mokowole a elewate borowole. Ro miyae hiwa elate Yohanes bure kowoumi kiyaebe waleuboke, hiwa yo yae elate Allahle yendo kayaalo Eliabe benen meujakauboke, hiwa yo yae elate na bena hele nekewate yenjo kayaa yo nolora hibe benen waleuboke, Herodes u bene baeiso-baeiso kowole. ");
INSERT INTO set_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes yae elele, “Yohanes mbai na yun ukamaele naeisake. Nda ro nde maenin? Helen sele naei a boroimeyale.” Herodes Yesusre ijoko erennebonde naeise relewounge. ");
INSERT INTO set_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesus na moisa orowate yo bukaiboke mekate, ekaimokowate a nemene Yesusre huwewainyele. Nebeisa Yesus na moisa orowate yo bele na mo-mo Betsaida yore ewate. ");
INSERT INTO set_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nebeinya ro miyae borokate bae Yesus na moisa mo hakowainye. Yesus ei haweumi nane merau Naei me kelee u keleene nekate ro miyae holona naeise kelewoumi. Nda yo nolora mewatena erane buloone kayeke yore onomi iwoumi. ");
INSERT INTO set_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Hu akowole hee yae wa, Yesus na moisa orowate yo mekate Yesusre wainye, “Tuhan, nda anuwau a kala-kala ya. Ro miyae weimi yo nobena-nobena honatene enate raman annayende nane merau ijongku enairelende hononate.” ");
INSERT INTO set_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nebeibe Yesus yae weumi, “Ramande mayae yemmile anenatere!” Nebei yo wainye, “Maeinya feu maehae mbai ka bee hele! Waei kenare koyae meyae raman hiwa bele emayarongkondere?” ");
INSERT INTO set_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Ro arilewole nemene 5.000 hului.) Yesus benen na moisa orowate yore weumi, “Ro miyae wemmi riyane-riyane nuwaiko, riya mbai ro miyae 50 hului yae!” ");
INSERT INTO set_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Nebeinye Yesus na moisa orowate yo naei a ukeumi huluinye ukaimile raiboke. ");
INSERT INTO set_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nebeisa Yesus nane feu bele ka belere mo yaroukoke, be bumare weuweke Naeko Allahre helen foise mo ukeunge, na hibi Naei me yae kaiwole na moisa orowate yore iwoumi ro miyae arilewolere wahenaimilere. ");
INSERT INTO set_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nebei ro miyae anewate wande hele yaeiboke. Nebeisa na kalun honowate arilaisike kakali me bee oro nen bee bele. ");
INSERT INTO set_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ya mbai Yesus ebeline nembai eke bowole mo, na moisa orowate yo Na bokore mekate. Yesus yae hineumi, “Ro miyae Rare nde yae elate?” ");
INSERT INTO set_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Na moisa orowate yo yae wainye, “Ro miyae hiwa Ware Yohanes bure koumi ro yae elate. Nebeibe hiwa yo yae Ware Allahle yendo kayaalo Elia yae elate. Na hiwa yo yae Ware bena yenjo kayaa yo nolora hibe benen aunguke yae elate.” ");
INSERT INTO set_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nebeinye Yesus yae hineumi, “Mayae bae Rare nde yae elaube?” Petrus yae weunge, “Tuhan, Wembai Allah yae oro umaufe heraweibokete Wali Ondofolo.” ");
INSERT INTO set_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesus yae weumi, “Nebei a hire hare a yaka-yaka okommimae. ");
INSERT INTO set_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Reyae, Allahle bokora mekale ro miyae uware yeubokale Kiyae, beko helen hubarengkonde hele. Yahudi yun-jun mae, imam yun-jun mae, Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi yo yae Rare moi bulenaisele. Ro miyae yae honaisebondebe, nebeibe ya name mo Reyae arenunde.” ");
INSERT INTO set_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nebeisa Yesus nebeinye ro miyae hebatere weumi, “Nde Raei moisa hakombonde kiyae, na kenare koyele wali mekai kena yae herawende hele, nebeisa Raei aerene ohaline bonaikonde ro wanen mae Rare hakonsebonde. ");
INSERT INTO set_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Rabuhine ban nde yae naei wali Raei me einye ekinyeiboinya, naei wali hole omoloiboi. Nebeibe nde yae naei wali Raei me einye kinyensebondena, nebei kiyae naei wali hole molorembonde. ");
INSERT INTO set_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Na foi rahe ro miyae mbai nda kani kelana rambun naei me einye honoube, nebeibe wali hena bona eitowei? ");
INSERT INTO set_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ro miyae nde Raei ro aerene nane merau Raei a faeu kelaemaele aerene, ro miyae bene fe kondena, nebei wanen mbai fe yae korende Reyae Maeko Allah Naei one hengko kitensebonde hehe kaban Maekole u i u nukui einye bele malaikat yolo-yolo bele surgara memale ya. ");
INSERT INTO set_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Reyae na hele wamale, mai nolona ro miyae hiwa eherei mo nekenate Allahle yo waku mende naei ijoko yae kanenainyebonde.” ");
INSERT INTO set_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesus a huwoumira ya mehine name hului mainyekeukokera Petrus, Yohanes, Yakobus, Yesus yaweumiboke Naeko Allahre ebeli boisise mokore ikate. ");
INSERT INTO set_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yesus Naekore ane bowounge mo na be yoi uke ma hire bewole nane merau malo keleumon wili halaman bewole. ");
INSERT INTO set_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Na heki ban mo ro bee yakaiboke Yesus naei ane elate. Nebei yenjo kayaayo bee na ro Musale, Eliale. ");
INSERT INTO set_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Hehe hokolo bee na une naeumikoke. Hokolo bee Yesus naei ane elate, Yerusalemne menjembondere Allah naei mehininde raungehike huluinye Yesus honaibondere. ");
INSERT INTO set_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petrus, Yohanes, Yakobus, nemene ijongkune honaiboke. Nebeisa ainyukate eraimi hokolo name na une hehe namman boumi. ");
INSERT INTO set_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kulun bowote Yesusre nukeneinyele hee yae wa, Petrus yae Yesusre weunge, “Tuhan, ndane onomi hele hubannele. Naei foi sele meyae fale name hemakondere: mbai Waei, mbai Musale, na hi Eliare.” (Petrus nebei a elewolebe onewainye rahe abe elele.) ");
INSERT INTO set_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petrus ane elewole yae, mangko meke feleumiboke na moisa orate name fe waku yae yaroumikoke. ");
INSERT INTO set_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nebeisa a mbai mangko bulura weumi, “Nda Raei Fa Niyae Reyae eleubokale wekeunge Kiyae, Nare mo boronnele.” ");
INSERT INTO set_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nda ara baeufoke bae, Yesus nembai sele nukainyekoke hebewole. Nda ijoko yae erewate rambun hokolo name ehuweyei nekayeke. ");
INSERT INTO set_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ya heuboke mo, Yesus hokolo name bele nebei mokora wayakoukokene ro miyae nekai Naei bokore mewate. ");
INSERT INTO set_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ro mbai nebei ro miyae nolora kaenele, “Guru, raei kelu fa mbai ken ijoko erenebomae ya! ");
INSERT INTO set_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Alo mele helaweunge bae, kali mo ikaenewole, na uwa nemene elae halae yeiboyole, olokee mo neuwara ibalewate. Nebei alo na uware beko hele mokoyeunge, menduwendere ahi elele! ");
INSERT INTO set_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Wa moisa orowate yore ekale nebei alore hukenainyehindere riyewamaele, nebeibe neyae na hului ban.” ");
INSERT INTO set_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesus nebei a boroukokene hebate yore weumi, “Mayae na hele Rare hila rabo ehalei holona nane merau Raei kelemale wali nibira wekaube yona mangkele mbainye mo nekemandere nane merau kena yae mo heraufendere.” Nebei fa naekore weunge, “Wa fa ndare yaweinyoho meu!” ");
INSERT INTO set_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Yaweungehoke Yesusle bokore ete mo, alo nebei fare ane woke, noro me elaeiwate, nebeibe Yesus na hibi nane alo a elae yae haeungeboke bele, nebei fa onomi yeuboke, nebeisa naekole mene ikeungele. ");
INSERT INTO set_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nebeinya ro miyae fangkengke yae bowate Allah nebei elae keleubokene. Ro miyae Yesus nebei merau mokowole erewainye ijoko kelei-kelei mo kelewate. Nebeisa Yesus na moisa orowate yore weumi, ");
INSERT INTO set_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Nda Raei a wamale angkaei foi-foi yae boron: Reyae, Allah ukeufe mekale ro miyae uware yeubokale Kiyae, u mekai beko bele ro miyae naei me einye kinyenaisebondere.” ");
INSERT INTO set_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Nebeibe na moisa orowate yo nebei a eleukokere ka yae raneumibokene onewate handawate nane merau benende hinenainyehindere buhae yae hokowoumi. ");
INSERT INTO set_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yesus na moisa orowate yo naeise naeise a kilate elate nde naei nolora naei kaban sele. ");
INSERT INTO set_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesus na u mekai kate isaeyeubokene nebeinye fa mefa ken mbai yaweungehoke meke na bokone haungeboke hebewole. ");
INSERT INTO set_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Nebeisa mo na moisa orowate yore weumi, “Nde nda fa hebelere Raei Ro einye ei hawennelena, Rare ei hawensele. Nde Rare ei hawenselena, Rare ukeufe mekale Kiyae Maeko Allahre ei hawennele. Rabuhine ban, nde mai nolora ro ban sele, nebei kiyae niyae ro bele!” ");
INSERT INTO set_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohanes yae weunge, “Tuhan, ro mbai erekannele Waei ro yae alo yoni-yonire hukeyeumi. Nebei ro aei riyana banne meyae nare ahewannele.” ");
INSERT INTO set_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesus yae Yohanesre nane merau na moisa orowate yo na hiware weumi, “Nare ahennemae! Ro miyae na me u mangkele nane hului mokonatena, nebei kiyae niyae mai kahili.” ");
INSERT INTO set_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Surgare ende ya nobewounge mo, Yesus Naei u benera haraungeboke Yerusalem yore endere. ");
INSERT INTO set_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Naei uware enainyekende naei bele inyale naei bele rambun mokoneinyehande naeise, ro bee ukeumi nibi bere Samaria kanina yo mbainye enete. ");
INSERT INTO set_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Naeisaei nekate Yesus Yerusalem yore endene, nebeinye Samaria ro miyae Yesusre ei ehawei! ((Samaria ro miyae bele Yahudi ro miyaere bele yokeijo yae nekate.)) ");
INSERT INTO set_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Na moisa orowatera ro bee Yakobusle Yohanesle nebei merau isaeyeibokene Yesusre weinye, “Tuhan, Waei kena naendae hubanae, meyae i ungannele yakura onde nda ro miyaere hukelenaibondere?” ");
INSERT INTO set_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesus beufoke are mo yareumikoke. ");
INSERT INTO set_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nebeisa yo hire yae ewate. ");
INSERT INTO set_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yesus na moisa orowate yo bele alainyekoke ewate mo, ro mbai yae meke weunge, “Tuhan, raei kena kale Weyae makeise ele rangkele mo orayendere!” ");
INSERT INTO set_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Nebeibe Yesus yae weunge, “Bulou yoku na honson bulu bele nane merau aye na nale bele. Nebeibe Reyae, Allahle bokora mekale ro miyae uware yeubokale Kiyae, uware alorebonde anuwau ban.” ");
INSERT INTO set_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nebeisa Yesus ro hire weunge, “Rare hakoisobo!” Nebeibe weunge, “Rare mon yeise maeko hereke eremolonsan.” ");
INSERT INTO set_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Nebeibe Yesus yae nebei rore weunge, “Rare hila rabore ehalei yo yae nebei here molonaisande. Weyae aloinyoko Raei me kelee u keleene nekenate ro miyae holone enaiyembonde are huweumiyendere.” ");
INSERT INTO set_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ro hi yae meke weunge, “Tuhan, raei kena kale Ware hakoreibotere, nebeibe ebi fere waeisihi wangkele orayende naeise raka baeke a isaeisemibon.” ");
INSERT INTO set_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Nebeibe Yesus yae nebei rore weunge, “Ro miyae nde naei kena ura a hokoukoke Raei a wanale hului yae nekenende nebeisa kennehinde, nebei kiyae Raei kaliare mokonde naeise na hului ban.” ");
INSERT INTO set_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tuhan Yesus benen ro 70 eleukoke wekeumi yo ukeumi anuwau Neyae ende ijende bere holo yae enate. ");
INSERT INTO set_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yesus nebei yore weumi, “Ro miyae helen sele Raeinya are boronatere kena kate, nebeibe kelei-keleise kelenaimile ro kalobe molole. Nebeinye Allahre riyennele ro miyae helen mae wemmile menate. ");
INSERT INTO set_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ninae eme! Mai kena nime hababe, nebeibe ikele hande koyate yo nolore wamale embere. ");
INSERT INTO set_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Malo huba, bekangke, oro mehau, ma mene yaroi eijae mo. Nibi nolone embena, ro hi miyae hire ro emelaeyeijae mo. ");
INSERT INTO set_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Imae mbaise emembombena, nda wanen mae wemmile, ‘Rei mai nda imae eise.’ ");
INSERT INTO set_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ro miyae na wali rei mai bele nebei imaene nekelena, neyae rei mai endowende. Ro miyae na wali rei mai ban mae nebei imaene nekelena, neyae rei mai erowei. ");
INSERT INTO set_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Imae ungayembe einye mo nekembe nane merau raman bu inyaiyembe anembe, rabuhine ban kaliare mokoyate yo na me buhae bele yaronate. Nebei imae mbainye mo nekembe, imae hira hira okoijae. ");
INSERT INTO set_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Yo mbaise embe mare na foi yae ei hawenayembene, raman bu inyayembe hului anembe. ");
INSERT INTO set_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nebei yona erane buloone kayeke yo onomi yemmiyembe nane merau a wemmile, ‘Allah merau raungehike hului Naei holona ro miyae Raei me kelee u keleene nekenate ya nobeungeboke.’ ");
INSERT INTO set_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Embe yo hira mare hukenayembena, na nibi kabanda hebembombe mo kaenemmile, ");
INSERT INTO set_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Mare isaeise imayembere, wa yona yanna kani bahe kela bahe maei orona kolowaiboke nemene nare rubannele. Nda iwau wanen kelaeyembe mayae beko hele mokowaubene. Nebeibe bene foi yae nekenayembe, Allah merau raungehike hului Naei holona ro miyae Yesus Naei me kelee u keleene nekenate ya nobeungeboke.’ ");
INSERT INTO set_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Reyae mare wamale, ‘Sodom Gomora yo bee Allah ehee bukulu hayeumikoke foma-foma bele nda yo ehee bukulu hainyemikondera.’ ");
INSERT INTO set_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Korazim yona ro miyae bele Betsaida yona bele beko hubannele! Mai nolone rambun emere-emere mokoukokale Tirus bele Sidon bele yone mokoukokale yae nendahina nebei yo naei beko bakora nulu keumiboube, nane merau rei ban mai ban malo yae hiraikoube, na yun ran ondowai yae olaeikoube nekaimeube ((nulu keiboyoumire naei iwau mokoikoyate.)) ");
INSERT INTO set_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Allah nda kani kelana ro miyae naei walire hului kolommikonde heene Tirus bele Sidon bele yona ro miyaere ehee bukulu ebi fere foma-foma bele mare hainyengkombera. ");
INSERT INTO set_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nane merau mayae Kapernaum yona ro miyae mai kenara elaube Allah mare yakure kaenengkombe, nebeibe Allah ane hele hainyengkombe.” ");
INSERT INTO set_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Nebeisa Yesus na moisa orowate yore weumi, “Ro miyae mare borayembe yo, Rare boraise. Mare hukayembe yo, Rare hukaise. Nane merau ro miyae Rare hukaise yo nebei yo Allah Rare ukeufe mekale Kiyaere hukainye.” ");
INSERT INTO set_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ro 70 eleukoke wekeumi na moisa oronate na hiwa yo bukaiboke rei nekai kaimeke. Mekate wainye, “Tuhan, Waei ro yae oku naemmilene alo yoni-yonibe maere boroiboyaime!” ");
INSERT INTO set_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesus yae weumi, “Reyae erewanale walobo yun wili weiboyole wanen mae yaku bumara ruke owole. ");
INSERT INTO set_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","U bene foi nekenayembe a kaikai bele rami bele oro yae alemembe naei elae nemene mare kitembokamale, walobo yun nelae nemene mayae na hului melennehambe. Hi yae ha yae mare bekore omokoiboi sului. ");
INSERT INTO set_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Alo yoni-yoni mai ane borowayembe aerene reibe okoijae, nebeibe mai ro surgana homofaene molaikokene reibe kom.” ");
INSERT INTO set_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nebei hee mo Yesus Allahle Roh aungeboke yae rei nekai kowole elele, “Arai, kun wau na Tuhan, Reyae ware helen foi sele wawale, rabuhine ban Weyae nebei kelewamaele rambun isaei hebaen bera fae yae felewanae, nebeibe fa-fa u mekai wanen ro miyaere yakaimeyeumi, Waei kenare koyae huluinye. ");
INSERT INTO set_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Maeko, rambun nemene ninae Raei me einye kinyeufeboke. Hi yae ha yae Reyae Allahle Kelure ro oroibo mo, Maeko nembai sele. Nane merau hi yae ha yae Maekore ro oroiboi mo, Reyae Na Kelu rembai sele, nane merau Reyae eleukokale wekamaele ro miyae na kena u einye Reyae Allahle naeise yakaremibonde.” ");
INSERT INTO set_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nebeisa Yesus euweke na moisa orowate yore na mo-mo yae weumi, “Allah yae mokole rambun yoni-yoni mai ijoko yae ereyaubene foi hubaungele. ");
INSERT INTO set_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Rabuhine ban yenjo kayaayo helen bele ondofolo yoni-yoni helen bele mayae ereyaube boroyaube rambun wanende erenaibondere relaeinyeke, nebeibe na hului ban.” ");
INSERT INTO set_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Roko mbai Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi nolona ro mbai meke umali hubannehinde naeise Yesusre weunge, “Guru, reyae wali hena bona ererowende naeise rahe me u mokorele?” ");
INSERT INTO set_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesus yae weunge, “Musale walora wali heere foloukoke homofaene rahe abe molaikoke? Waei u bene nekayete nebeinya a na mekai rahe?” ");
INSERT INTO set_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nebei ro yae weunge, “ ‘Wa kena u, welae wake, wa u bene wa bene nemene, Allahre kena buhae na maemae yae heungele. Nane merau waei uware buhae haenae wanen mbai mangkele ya-ya wali nibi mbainye oraube yore heumile.’ ” ");
INSERT INTO set_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesus yae weunge, “Na helebe eleyae. Naei wanen mae ele mokolena wali hena bona eukowende.” ");
INSERT INTO set_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nebeibe nane ro naei uware felele benen Yesusre weunge, “Raei wali nibi mbainye orande yo nde?” ");
INSERT INTO set_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesus yae weunge, “Ro mbai Yerusalem yora Yerikho yore owole. Nibi nolone owole mo yokoyo mekate rahuae yae baikoke, herendere kowole. Yokoyo nebei ro naei rambun na malo nemene yaraikoke nukainyeboke na nibine ha yae kaka yobowole. ");
INSERT INTO set_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Imam mbai naeisaei ban nebei nibi mbaisa auboke mewole. Meke nebei ro honole erekeungene, uke yaheuboke nahaufa ewole. ");
INSERT INTO set_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nebei sului mbai Imam Lewile orona mena ro mbai, nane nibi mbaisa auboke mele. Meke nane ro honole erekeungene, nane merau yaheuboke nahaufa mo ewole. ");
INSERT INTO set_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nebeisa, Samariana ro mbai kolore ewole nane nibi mbaisa mewole nebei robe erekeunge bae na kena beko bele hubawounge. ");
INSERT INTO set_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nebeinye eke na uwana ba minyak bele, anggur bele yae kuyeungekoke, malo yae aweungekoke. Nebeisa nda Samariana ro naei keledai ranne nane ro haungeboke, yaweungehoke kolo yo honate imae mbaise ewote, nebeinye holewounge. ");
INSERT INTO set_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ya heuboke mo, nebei imaena rore roi perak hele bee yeungekoke mo weunge, ‘Nda rore foi yae holeungele. Benen roi naennaen helen nen mokoungekondena, reyae merele yare ware isete.’ ” ");
INSERT INTO set_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nda ahubara huweungekoke mo Yesus nebei Musale walora wali heere foloukoke isaeyaeiboke kelaeimi holona rore hineunge, “Nda ro name nolora elale makei kiyaebe waei u benere nekete hului nebei ro name nolora nde na hele ya-ya wali nibi mbainye orate ro?” ");
INSERT INTO set_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nebei ro yae weunge, “Hakoungeboke kiyae.” Nebeinye Yesus yae weunge, “Foi, mana eye waei me u nebei wanen mae eumokonde!” ");
INSERT INTO set_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesus na moisa orowate yo bele alainyekoke ewate yae yo mbainye ayeuboke. Nebeinye maengke mbai na ro Marta ukeumi naei imaere enatere. ");
INSERT INTO set_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta nauwake mbai na ro Maria. Maria meke Yesus Na oro kelaeunge nuweuboke Na a elewolere borowole. ");
INSERT INTO set_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta mbai raman anenaikonde naei mokoisaise humfo wamfo bewoke, eke Yesusre weunge, “Tuhan, Weyae nou ehei sele Maria ereufekoke rembai nda raman kaliare mokoyale. Weinye hakonsebone!” ");
INSERT INTO set_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Tuhan Yesus yae weunge, “Marta, Marta, weyae buhae bele hokoibo-hokoibo humfo wamfo beyoyae, nda u bene nekeyayete, ndi u bene nekeyayete. ");
INSERT INTO set_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Naei berei sele na mbai ken, Maria yae nare ikileuboke. Ro miyae hi yae ha yae naei mera enukeisai.” ");
INSERT INTO set_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ya mbai Yesus eke anuwau mbainye Naekore ebeline ekebowounge. Baeufoke mo, ro mbai na moisa orowate holona yae meke weunge, “Tuhan, Yohanes naei moisa orowate yore ebeli boi-boi naeise keleumikoke wanen maere bele keleimeko.” ");
INSERT INTO set_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Nebeisa Yesus yae weumi, “Mayae Araise ebelire bonnelerena, nda ma yae harannebombe bonnele, ‘Arai, Waei ro nene waewae hele yae mokomayewende. Ro miyae Waei me kelee u keleene nekate yo yan meujebo. ");
INSERT INTO set_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Maei raman mana ya naeise maere na hului yae yeumele. ");
INSERT INTO set_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Maei beko neban faeinyeimeko, rabuhine ban meyae hiwa yo naei beko neban mokaimekokere u bene nundaimekoke. Maere wabenaimele hee, ei haweumele.’ ” ");
INSERT INTO set_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesus benen weumi, “Ro mbai mai riyara reniai nolo yae naekobaele bokore eube mo boungele, ‘Ako, waeinya feu fo name hului yeisoko ba. ");
INSERT INTO set_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Rabuhine ban raei kahili mbai kolora oroyelerabe raei imaene meke none yele, anengkonde naei ramanbe kabaennele.’ ");
INSERT INTO set_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Naekobae ekebounge kiyae nda wanen mae eleukoube, ‘Reniai nolo helebe mekae yengkarae ya! Romau nemene ninae ahaendekoke, raei kelu omi bele ijongkune honande. Rambun hi reyae ware ainyui eyei sului ya.’ ");
INSERT INTO set_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Reyae wamale, naendae wanen na akobae hele boungelere bae ainyui eraweiboi. Nebeibe nane ro fe ban koli-koli bowoubene, naekobae romau raweuboube yeungele. ");
INSERT INTO set_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Nebei aerene Reyae mare wamale, eitiyeinye, ware inyete; eihineinye baeinye, rowele; me kaba-kaba boinye, ware romau raungeibote. ");
INSERT INTO set_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Riyende kiyae rowende; baende kiyae hubainyekonde; romau me kaba-kabare bonde kiyae nare romau raungainyebonde. ");
INSERT INTO set_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Mai nolora ro nde naei fa kare riyewounge, rami yae ikeunge? ");
INSERT INTO set_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ojo rore riyewounge, a kaikai yae ikeunge? ");
INSERT INTO set_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mai wali bekobe, nebeibe mai kelu omi rambun riyayembe huluinye yeyaumi. Nebei sului mbai, mai Allah surga einye Kiyae, Naei Roh riyenainyele yore yemmile.” ");
INSERT INTO set_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ya mbai mo ro mbaite uwa bulura amunde mokounge alobe Yesus hukeungehike eukuke. Nebei alo eukukera, nda ro a elewole. Ro miyae helen sele ijoko kelei-kelei mo kelewate. ");
INSERT INTO set_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Na hiwa yo yae elate, “Beelzebul, walobo yunbe elae yae Yesus alo yoni-yonire hukeumi.” ");
INSERT INTO set_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ro miyae hiwa Yesusre umali hubanainyehinde naeise surgana iwaufe riwainye. ");
INSERT INTO set_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nebeibe Yesus nebei yo na mekai harainyebokere isaeyeubokene weumi, “Yo yan mbai na ro miyae be hun ma hun nekenatena, nebei yo yan here ware wembonde. Nebei sului mbai imae obe mbai na ro miyae naeise naeise kena ikele ikowatena, nebei ro miyae here ware wembonde. ");
INSERT INTO set_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Walobo yun na walobo akobaere hukennehindena, na yo yan here ware wembonde. Mayae elaube Reyae Beelzebulle elae yae roukale alo yoni-yoni hukamaele. ");
INSERT INTO set_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Reyae Beelzebulle elae yae roukale alo yoni-yonire hukamaelena, mai riyana yo rahe elae yae alo yoni-yonire hukaumi? Mai moisa orowate yo nenaeijae mayae ame-amebe yanaube are wayembe! ");
INSERT INTO set_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Reyae Allahle elae yae roukale alo yoni-yonire hukamaelene, Allah meraufe raungehike hului Reyae Wali Ondofolo yae mere mokamaele. ");
INSERT INTO set_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Elae bele ro naei imaene nekelena, naei rambun yaroikoise ro miyae na hului ban sele. ");
INSERT INTO set_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nebeibe ro hi naei elaekei sele meube, nebei rore heraweuboube, na fela mendare rabo haleimeyeunge mera nukeufaube, nane merau rambun nemene wahemmikonde. ");
INSERT INTO set_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ro miyae Rangkele mbainye nekemalere ahire elate yo nana hesele Raei yokeijo. Nane merau ro miyae nde Rangkele mbainye nekemalere muli oyoboinya, nebei kiyae ro miyae herebe boumi.” ");
INSERT INTO set_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Alo mbai ro uwa miyae uwara meituwele, anuwau kala-kalane yaneyele no yeiboise baeyele, ehubayeikoinya, elele, ‘Reyae benen bukerehinde raei imae nukeungebokale relahine erenekendere.’ ");
INSERT INTO set_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Bukeufike nane imae eke erewole bae, nebei imae erele mokoisai sele mokainyehake, na imaena rambun yoni-yoni hiyei ranaiboke. ");
INSERT INTO set_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nebeinye benen bukeufike eke alo mehine bee bele na u mekai beko hele yobe yaweumiboke mekate. Yaweumiboke mekatera nebei role u bulune na riyane ayeuboke nekewate. Nda ro na beko hele wali bena nekewolera.” ");
INSERT INTO set_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesus ane huwoumi yae miyae mbai nebei ro miyae hebate nolora Yesusre weunge, “Ware honokete nane merau nimere naefokete miyae mbai, onomi foka hubanende!” ");
INSERT INTO set_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Nebeibe Yesus yae weunge, “Ro miyae Allah weumi are boroyate nane merau nebei suluinye nekeyate yo onomi foka hubanainyende.” ");
INSERT INTO set_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Yesus namman ane huwoumi yae ro miyae helen hokoumeke. Yesus uwoumi, “Nda hokolo na ro miyae na wali beko hele. Rambun emere-emere keleremibondere kena kate, nebeibe Reyae nare ekelei. Allahle yendo kayaalo Yunuslena relahire benen keleremibondere. ");
INSERT INTO set_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yunus Niniwe yore kelewoumi wanen, nebei sului mbai Reyae, Allah bokora mekale ro miyae uware yeubokale Kiyae, nda heena ro miyaere kelaemale. ");
INSERT INTO set_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Miyae Ondofolo Hilo norona ahaufa mewole Ondofolo Salomole a usaeibe meke borowole. Nda hee Reyae mekahebale Ondofolo Salomole isaei hebaende moi wokanale. Nda kani kela huba mokoikoi yane, nebei miyae Ondofolo bele nda hokolona ro miyae bele nanembaisa annumbe, me nonomombe. Rabuhine ban, nebei Miyae Ondofolo, Salomole a usaeinye hakoubokene, nebeibe mayae Raei a usaei wamalere boraubebe, nebeibe ehakoiboi. ");
INSERT INTO set_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Yunus Allahlena a faeu eke Niniwe yona ro miyae uwoumine, nebei Niniwe yona yo naei beko bakora nulu keumiboke. Nda hee Reyae mekale Yunusre moi wokanale. Nda kani kela huba mokoikoi yane, Niniwe yona ro miyae bele nda hokolona ro miyae bele nanembaisa annumbe, me nonayemombe. Rabuhine ban nebei Niniwe yona ro miyae Yunusle a uwoumi boraibokera nulu keumibokene, nebeibe mayae Raei a faeu elalere boraubebe, nulu ekeiboi mo. ");
INSERT INTO set_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Isehe releungekoke kiyae nunne honate anuwau helai keleene obuneiboi sului. Isehe releikoyainye, nebei hehe naemmikonde naeise naei anuwaunge anaibonde. ");
INSERT INTO set_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mai kena una hubaunge mai ijoko wanen mokoiboyole. Rambun foi reufine mo eremembena, hehere erembe wanen mai u bene foi nekenayemembe. Rambun na beko reufine mo eremembena, ouben hauben erembe wanen u bene beko nekenayemembe. Mayae u bene beko na hibi-hibi nekenayemembena, mai kena une beko mo eremembe. ");
INSERT INTO set_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nebei aerene mai kena u kayaa foi yae hebembe, hehe naeukokebe kebengkonde bele. ");
INSERT INTO set_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mai kena une hehe mo naeikoyelena, nebei heene ouben hauben enekei sului, isehe wauwane naeyete wanen.” ");
INSERT INTO set_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesus ara huwoumi baeufoke mo, Farisi holona ro mbai yae uwounge naei imaene ramande eneyanengkondere. Yesus hakoungeboke nebei role imaene ramanne ekeyanewote. ");
INSERT INTO set_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nda Farisina ro Yesus na me bu ekuyeikoi yae raman anewolene, fa yae bowole. ((Naei era hena honoyele ramande anenatere me bu kuyeikoyatera eyanewate.)) ");
INSERT INTO set_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nebei wanen ukeungene Yesus yae weunge, “Na hele, mayae Farisi ro miyae mai kolaei bele hote bele na moi reufire mo bu kuyeyaube, nebeibe ma kena u ei bae bolu yae naba yae, beko yae bako yae maemae kongkokembe. ");
INSERT INTO set_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mayae kobu! Allah moi reufi mokouboke Kiyae mbai eise naei wanen mbai mokouboke. ");
INSERT INTO set_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mai hote ei kolaei einyabe keren ban nale ban yore hakommiyembena, ma kena ei yolo-yolo yembonde. ");
INSERT INTO set_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Mayae Farisi ro miyae beko hele hubannele, rabuhine ban mai ani era hekena yaroyaube yele era me bee kayee rora mbai Allahre yeyaunge, nebeibe ro miyae hiware na ijen ban mokoyaumi nane merau Allahre kena buhae eheyei. Nebei me ube na bereise mokomembe nane merau Allahre hili era akau era yennele naeise moise ehayeijae. ");
INSERT INTO set_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Mayae Farisi ro miyae beko hele hubannele, rabuhine ban Allahre ei mom-mom imaene mayae kena hele anuwau foise-foise baeyaube royaube. Nai hei-sei ijenne mare rore melaeinyayembere mai kena hele koyaube. ");
INSERT INTO set_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Mayae beko hele hubannele, rabuhine ban mayae here bulei auma ban na wanen. Ro miyae nebei bulei randa atebe, nebeibe kelen bele baeii bele rambun nebei kani bulune honate neyae isian.” ");
INSERT INTO set_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi holona ro mbai Yesusre weunge, “Guru, nebei a mekai huwaemae yae maei naei a bekobe huwaemae.” ");
INSERT INTO set_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesus yae weunge, “Mayae Musale walora wali heere foloukoke are isaeyaeuboke kelaeumi yo beko hele hubannele, rabuhine ban nebei wali heere foloukoke homofaena honate huluinye waumi nda wanen mae mokon, ndi wanen mae mokon, nebeibe ro miyae nebei wali mane enainyekende heene mayae nare ebi fere hara enei sele einyekewaube. ");
INSERT INTO set_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Mayae beko hele hubannele, rabuhine ban mai Allahle yenjo kayaayo na bulei ranne mayae u bene nekeise-nekeisi fale foi haeube. ");
INSERT INTO set_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nebei nibi yae mai yobe naei kamahe naei me u mayae be yae hinaube. Mai yobe naei yae haikoke, mayae bene nekeisi-nekeisi fale haeube. ");
INSERT INTO set_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nebeinye Allah Na isaei hebaen bele yae elele, ‘Raei yenjo kayaayo bele, Raei abu ako bele ufemile enate. Naei nolora hiware beko mokonaimiyende, hiware honayende.’ ");
INSERT INTO set_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Nebei aerene nda kani kela na hubare raweubokera Habelre haiboke heera huba rawembonde mende Zakhariale heene Allahle yenjo kayaayo nemene haikoke aerene, nda heena nekate ro miyaere Allah ehee bukulu hainyemikonde. (Zakharia hili era akau erare ongkoufe felate itukai bele, Allahre ei mom-mom imaene bele haiboke.) ");
INSERT INTO set_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Mayae Musale walora wali heere foloukoke homofaere isaeyaeuboke kelaeimi yo beko hele hubannele, rabuhine ban Allahle isaei hebaen naei romau einye mayae hebaube ((mayae kelaeumi)). Nebeibe mai wali nebei a huluinye aloisai mo, benen nebei wali nibine hakonate ro miyaere mayae a hun mae kolaumi!” ");
INSERT INTO set_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Yesus kulun uke heene Farisi holona ro miyae nane merau Musale walora wali heere foloukoke homofaere isaeyaeiboke kelaeimi yo, Yesusre ikele hele kowainye, walangka wanen wokainyele a mahi-mahi yae hinewainye. ");
INSERT INTO set_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ro miyae nekai sekai sele kilin-kilin hoi-soi, oro hi ran hi ranne hebayeke. Nanene hebate wa Yesus na moisa orowate yore weumi, “Farisi kelaeimi are kayaa foi yae hebembe. Rabuhine ban naei u mekai be bee bele yae nekate. Ragi ebi ken mokounge tepung kaban ohulembonde wanen Farisi yae a kelaeimi na hului mokonaimile ro miyae helen u bene beko nekenaimile. ");
INSERT INTO set_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nunna honate yo nemene ninae yakanaibonde a yakane kolonaimikonde. ");
INSERT INTO set_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Reniai yae elewaube a faeu, rai yae boronate. Ro miyaere angkaei kelaeufa a maehae-maehae yae yowa einye uwaumi, a yaka bu yakane kaenenate.” ((Nebei aerene u mekai be bee bele yae enekeijae.)) ");
INSERT INTO set_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Aka naei baeke naei, Reyae wamale, nda uwa melen honayembe hainyayembe naeise mayae buhae ohokoijae. Rohre neyae ohoiboi sului. ");
INSERT INTO set_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mana Reyae kelerembombere ndere mayae fe faennelere. Allah mbaise mo fe faennele. Neyae na hului ro miyae uwa hombondera na hibi narakare kannehinde ende. Nebei Kiyae Niyae mayae buhae hokonnembe. ");
INSERT INTO set_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Aye maehae mbaise roi na ane hele heiboyate, nebeibe Allah aye mbai sambaise enundeikoi sului. ");
INSERT INTO set_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Wa yunna umaa Allah na helen Naeisaei. Nebeinye Reyae wamale buhae ohokoijae, rabuhine ban mai yeisi raeiboi na bumana hele aye yoni-yonira.” ");
INSERT INTO set_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Reyae wamale, nde yae ro miyae naei bene Rare Wali Ondofolo yae elendena, Reyae, Allahle bokora mekale ro miyae uware yeubokale Kiyae, naei mekai mbai Allahle malaikat yoni-yoni naei bene nebei rore Raei me kelee u keleene nekate holona ro yae erelengkonde. ");
INSERT INTO set_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nebeibe nde yae ro miyae naei bene Rare Wali Ondofolo ban mae elendena, Reyae naei mekai mbai Allahle malaikat yoni-yoni naei bene nebei rore Raei me kelee u keleene nekate holona yo ban mae erelengkonde. ");
INSERT INTO set_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Nde yae Rare, Allahle bokora mekale ro miyae uware yeubokale Kiyaere, a beko faeu beko wenselena, nebei kiyae na beko mokowolere na hului faeinyerembonde, nebeibe nde yae Allahle Rohre a aukaka konnele kiyae naei beko mokowolere efaeinyeiboi sului. ");
INSERT INTO set_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ei mom-mom imae yun-jun bene, yoyo koseyo bene, mere mokaimi ro bene wauwa foi naeise olelere yaungayeufote heene a weyae buhae ohokoijae nane merau eleukonde a nemene buhae ohokoijae mo hebembe. ");
INSERT INTO set_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Rabuhine ban nebei hee Allahle Roh yae eleukonde a faeu nemene ware keleneikote.” ");
INSERT INTO set_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nebeinye arilewole ro miyae nolora ro mbai yae Yesusre weunge, “Guru, raei aka baeke weinye maekolena run kangke meyae beere nukeumiboke raei bele yae hi yensele.” ");
INSERT INTO set_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesus yae weunge, “Aka baeke, nde yae Rare roukeufe mai nolora heberenunde mai run kangkere waherekobere?” ");
INSERT INTO set_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nebeinye nekewate ro miyaere Yesus yae weumi, “Mauwa foi yae kayaa hebembe, kuikui maemaere kena haehae okoijae. Naendae wanen horore ro mbai kuikui maemae nolone nda wali heki nekeweube, nebei kuikui maemae yae nare wali foise eyei.” ");
INSERT INTO set_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nebeisa Yesus nebei ahuba ahuneuboke a huwoumi, “Ro mbai run bele kangke bele. Kani foi kela foi tanne nekewolene, nime kaungei bele na imaene honowate. ");
INSERT INTO set_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nda ro na kena eisa elele, ‘Rahebe nda hee mokorebonde? Nebei ani era, kombo mahu, nime kaungei bele honaisene kolorekonde anuwau u yeuboke.’ ");
INSERT INTO set_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nebeisa u bene nekainyekoke mo nenaeijae nauware weunge, ‘Ninae u bene nekaisehike. Nda imae kolate relahibe ufemile kelanaibonde benen naei kaban sele yae henaikonde. Nebeinye ani era kombo mahu abunerehinde hononate.’ ");
INSERT INTO set_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nebeisa wa raei uware ufende, ‘Rambun foi helen sele arilewekae, ninae na hului arilewoyae! Na hului nekewende rimolone yangkone. Mei, meyane meisire.’ ");
INSERT INTO set_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Nebeibe Allah weunge, ‘Kobu! Nda reniai sele weyae herele. Nebei rambun yoni-yoni arilewoyaebe weyae ehubaisi.’ ” ");
INSERT INTO set_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Na ahuba riyau weiboise wa Yesus yae weumi, “Na mekai naei wanen, nda kani kelane ro miyae hembonine relane mo arilenende, nebeibe Allahlena a weunge huluinye ehakoiboi.” ");
INSERT INTO set_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Nebeisa Yesus na moisa orowate yore weumi, “Reyae mare wamale, eraman bu, malo, ma wali rambunde buhae ohokoijae! ");
INSERT INTO set_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mai wali einye na bereinye kiyae raman bu ban nane merau malo ban. ");
INSERT INTO set_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Aye abara mali koyate ijoko foi yae na wali eremmikombe! Nebei aye meleme ban, kombo mahu mokoiboyole neyae einyihei, nane merau imae kaban obe kaban ban nebei kombo mahu nimere kolonatere. Nebeibe Allah nare holeyeumi! Mangkele aye bele, meyae aweukoke. ");
INSERT INTO set_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Naendae wanen, mai nolora nde buhae-buhae yae na wali hukai mbai baraungeboke? ");
INSERT INTO set_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Wali hukai mbai ken mayae ebaraikoi sului, Allah mo na huluinye, waennehimbe Allah mai wali rambun inyembe. Nebei naeise mayae buhae ohokoijae. ");
INSERT INTO set_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Eme! Arokou kitele ma ijoko foi yae erennekombe me u omokoyei, malo ehayei, nebeibe na u mokoisayeunge baengko fereisayele. Ondofolo Salomo rundo kangkelo hororebe naei u rela kiteungeboke, nda arokou ehameikoi sului. ");
INSERT INTO set_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Faunga ke hebeyate mana kitate wahenare i yae baikoube ika bangka yaeiboube. Nebeibe Allah nebei kere uwa moloumiboke foi moi sele yaeiboke. Emekai bele Allah mayae hila rabo elae ban yore uwa baengkore ferenembe rambun inyembe. ");
INSERT INTO set_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Raman bu anengkombe naeise buhae ohokoijae. ");
INSERT INTO set_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Rabuhine ban Allahre isian yo yae nebei rambun naeise rilibo hayeyate. Mai Arai Allah wali rambun yembe nibire isaeyeuboke. ");
INSERT INTO set_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nebeibe Allah merau raungehike hului Raei me kelee u keleene nekate holonare me baenembombere relennekombe. Neyae mai wali rambun nemene barannembe. ");
INSERT INTO set_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Mayae holo kaei-kaei ken buhaebe ohokoijae, rabuhine ban Arai Allah kena rei mai aungeboke Raei me kelee u keleene nekate holona yo yae ei hawennembe. ");
INSERT INTO set_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mai keren nale roi naise heiko! Nebeisa nebei roi keren ban nale ban yore waheumiyende. Ma me u foi mokombena, surgana hemboni rela wanen rambun hononayembe. Nebeinye yokoyo yae erowei, nane merau mane yae ofoloyei hononayende. ");
INSERT INTO set_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Makeinye hemboni relare honate ijen, mai kena u nebeinye mo.” ");
INSERT INTO set_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Nebeisa mo Yesus benen nda yore weumi, “Kayaa na hensen mo hebembe erabuhi yeiboi bele era. Ma malo nemene ma uwane mo kitennebombe, isehe na naeisoi yae hebembe. ");
INSERT INTO set_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Abu ako na rowa kolore eyewole rakeunge wanen mauwa mokonnehambe rakembe, mele romau me kaba-kaba bole bae na hibi romau raweiboyeunge. ");
INSERT INTO set_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Abu ako romau kayaare hebeyate yo na ijoko elae mo isebewate yae na rowa mele hee, kena rei mai ikowate. Na hele, nda wanen bele bae nebei rowa na abu akore ungemile raman mbainye anenate, naei me yae raman naei abu akore wahemmile. ");
INSERT INTO set_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Abu ako na rowa reniai nolo, na rene kaukau mende na ijoko elae mo isebewate wali ma yae hubainyaikonde, nebei hului mbai rei mai konate. ");
INSERT INTO set_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nebeibe nda a bele isaeyembo, Imaena rorele yokolo mendere hukai naeisaeinya, imae nendon yokolore ewaeisi sele. ");
INSERT INTO set_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mayae naei wanen mokoisa-mokoisa yae nekembe, rabuhine ban mayae isian ya Reyae, Allahle bokora mekale ro miyae uware yeubokale Kiyae, benen merele.” ");
INSERT INTO set_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petrus yae Yesusre hineunge, “Tuhan, maei foi naeibe Weyae ahuneubokae weyamae, ro miyae nemene foi naei?” ");
INSERT INTO set_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nebeibe Yesus yae beufoke weunge, “Abu ako na rowa a weunge huluinye imokowole nane merau isaei hebaen bele ma yae uwa haraungeboke kiyae na rowa yae kaeiboyole yunde yeiboyole. Nda ro yae yebaei bubaei hiwa yore raman yeumi na hu huluinye aneikoyate. ");
INSERT INTO set_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Na rowa meke heene nebei abu ako imae einya rambunne roi yae bu bende kiyae, onomi foka yae hubannele. ");
INSERT INTO set_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Reyae na helebe wamale, nebei wanen bendena, nebei rowa na hemboni rela nemene kayaa hebende naeise nda rore inyengkonde. ");
INSERT INTO set_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Abu ako beko kiyae bae, na kena eisa elende, ‘Nda rowa eke namman wabenende.’ Nebeinye, na yebaei bubaei huba rawembonde rone miyaene rahuae olemmile, raman bele bu elae bele anenende, yun yambi-yambi annebonde konde. ");
INSERT INTO set_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Na kobu-kobu konde hee yae na rowa mende. Nda abu akore na rowa mende yae rowende, ramiyaeli yae folongkonde, ro miyae Rare hila rabo ehalei yo nolone hannebonde. ");
INSERT INTO set_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Abu ako na rowa kenare kole naeisaeibe, nebeibe naei kena kole hului omokoikoinya nane merau nauware omokoisainya, na rowa mende heene nda abu akore rahuae elae hele bongkonde. ");
INSERT INTO set_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ro hi, na rowa kenare kole naeisaei ban nane merau ehee bukulu hainyainyele naei rambun mokombonde kiyaere, rahuae elae ban bonaikonde. Helen ikainyele kiyaera helen riyenainyele. Kayaa hebende naeise helen ikainyele kiyaera helen sele riyenainyele. ");
INSERT INTO set_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Reyae nda kani kela ise ufoyonde bolonsinde naeise mekale. Raei kena u eisa elale, nebei i boloufiube beube ya! ");
INSERT INTO set_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Reyae beko namman foronsubangkonde nane merau kena beko foronsubangkonde mende nebei beko baensonde. ");
INSERT INTO set_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mayae u bene nekayembe, Reyae rei maibe nda kani kelare roukale mekale. Nebeibe rei mai ban, ikele hanbe Reyae roukale mekale. ");
INSERT INTO set_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nda heera huba rawembonde imae mbainye ro miyae maehae mbai nekenate, bee yae name bele oinyaikonde relenainyele. ");
INSERT INTO set_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Na waere-waere, naeko yae na kelule a onyeibonde, na kelu yae naekole a onyeibonde. Nenake yae na maengkere a onyeibonde, na maengke yae nenakere a onyeibonde. Nenake yae na fau miyaere a onyeibonde, na fau miyae yae nenakere a onyeibonde.” ");
INSERT INTO set_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Nebei ro miyae arilewole yore Yesus benen weumi, “Mangko wai reufire keteijele mayae na hibi yae elaube, ‘Yare molondere,’ na hele ya moloikoyole. ");
INSERT INTO set_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nane merau alu eraunge nau reufira mele bae elaube, ‘rolonsan wendere,’ na hele rolonsan naeikoyole oyowole. ");
INSERT INTO set_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mayae maisaei nda kani kelara nane merau yakura ya mehinin alu mehinin kolaungebe, nebeibe Raei me u mokalere mayae isaeyeiboi, nane merau Allah meraufe raungehike hee Naei holona ro miyae Raei me kelee u keleene nekenate ya nobeungeboke mayae isaeyeiboi. ");
INSERT INTO set_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Mayae menaeijae foi naeise a ohoikoi! ");
INSERT INTO set_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Weyae yokeijo hi bele yoyo koseyo bene ebe mai a ranainyehinderena, u hale yae releungekonde nda ro bele foi mokokobe. Foi omokoikoinya, ware yoyo koseyo naei me einye kinyenaibote, yoyo koseyo yae Polisi naei me einye kinyenaibote. Polisi yae ikilenaibote embe ware kawane henaikote. ");
INSERT INTO set_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Reyae wamale, naei riyeyete roi aheikoi ebaeisoinya, weyae kawa eisa emeituwei sului.” ");
INSERT INTO set_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nebei heene ro miyae hebate nolora hiwa Yesusre uwainye, Galilea kanina ro miyae Allahre hili era akau era ongkoufe felewainye hee yae Pilatus houkoke. ");
INSERT INTO set_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Nebei a boroukokene Yesus yae hinewoumi weumi, “Mai u benera nekayembe hului, Galilea ro miyae nolora nebei ro miyae na wali beko helene neyae nebei wanen mae haikokate? ");
INSERT INTO set_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Reyae wamale, nebei mekai ban. Nebeibe mai beko bakora nulu ekeiboinya, mayae nane merau Allah bele wahengkombe. ");
INSERT INTO set_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nane merau mai u bene nekayembe hului, nebei ro miyae 18 Siloam imae yae oke herauwolere Yerusalem yona ro miyae nolora na wali beko helene hereke? ");
INSERT INTO set_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Reyae wamale, nebei mekai ban. Nebeibe mai beko bakora nulu ekeiboinya, mayae nane merau Allah bele wahengkombe.” ");
INSERT INTO set_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Nebeisa mo Yesus nda ahubabe ahuneuboke huwoumi, “Ro mbai anggur heke mokouboke nolone ara no mbai moloufake. Ya mbai mo nebei ro eke ara no hebelena anire kaneweke an, mbai ereiboi mo. ");
INSERT INTO set_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nebei aerene, na heke mere mokole rore weunge, ‘Eranae, nda ara no hebele ralo yakama name hele anire meungerakeukokale mbai sambai ehubayeikoi mo. Kaheinyoko ou! Na karo hele ndane hebeimeyele!’ ");
INSERT INTO set_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Nebeibe nebei heke kayaare hebele kiyae yae na roware weunge, ‘Nda ralo yakama mbaise mo eranekon hebeukoke. Reyae enera enera kani waerekonde retara einye haufekonde. ");
INSERT INTO set_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Na u bene nekainye hului bena ralo yakamane ani mokonde era. Ani wa mokondena, hebende; omokoinya, kaheungekonde ruwende.’ ” ");
INSERT INTO set_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sabat ya mo, Yesus Allahre ei mom-mom imae mbainye eweufike kelewoumi. ");
INSERT INTO set_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nebeinye miyae mbai ralo yakama 18 alo yae aungebokene buloone mo koweke. Moko buru yeuboke aufaere na hului ban. ");
INSERT INTO set_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesus nda miyaere erekeunge bae na hibi kaeneungekoke. Nda miyaere weunge, “Nda hee ninae weyae onomi roukae!” ");
INSERT INTO set_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yesus nebei miyae moko buru ranne mere mo raungehike. Nebei hee yae nda miyae na hibi na uwa benen aloukokene Allahre na hibi buma kolowounge. ");
INSERT INTO set_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yesus Sabat ya yae nda miyaere onomi ikeungene ei mom-mom imae yunde hebewole kiyae ikele nekai sele kowole. Nebeinya ro miyaere weumi, “Ya mehine mbai eyae kaliare mokomale ya. Nebei ya yae membe onomi inyayembe, Sabat ya yae emeijae!” ");
INSERT INTO set_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yesus nebei ei mom-mom imae yunde hebele kiyaere weunge, “Mayae u mekai u bee wa bee yae nekaube! Sabat yane baei mai obo yoku elera raweboyaumi yawaumi raman bune baeyate. ");
INSERT INTO set_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nda hee nda Abrahambe orona mena miyae mbai ralo yakama 18 alo yae aungeboke. Naendae wanen, nda Sabat ya yae nebei alo hukeisi eituwei sului?” ");
INSERT INTO set_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesus nda are mo ukeumi bae, na yokeijo fene kuinyei-kuinyei kuinyewate, nebeibe Yesus nda me u wanen mokouboke naei ijoko yae erewatene ro miyae hiwa rei mai kowate. ");
INSERT INTO set_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesus yae hineumi, “Raei me kelee u keleene nekate ro miyae holo rahe mekai elemakonde? ");
INSERT INTO set_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","O kaban ko heke ro rouke na hekene eke moloufake yae a ahunerebondere. Nebei o kaban na ro Yunani afaeunge mustard yae elewate. Nda o haka ko sawi ko wanen mbaibe na kaei-kaei sele. Nebeibe kitele bae nda o reu ha reu hiwa hebatera neyae na kaban sele yeiboyele, maensa akau rorole ate, aye bumana mate nebeinye no yeiboise meisebate.” ");
INSERT INTO set_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesus benen hineumi, “Raei me kelee u keleene nekate ro miyae holo rahe a yae ahunerebonde? ");
INSERT INTO set_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nebei holo nda wanen elerekonde, miyae mbai ragi ebi mo roke terigu kaban mokoungehakene nanemene alewoungele.” ");
INSERT INTO set_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yerusalemde ewole nibi na yo ran yo randa oroweke, yo ebibi, yo kaban-kabanne keleumiyeke. ");
INSERT INTO set_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Oroweke mo, ro mbai yae hineunge, “Tuhan, wali hena bonare enaiyaronde ro miyae helen, na keli name mo?” Yesus yae weumi, ");
INSERT INTO set_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Mayae relennembe romau kikira emembombe, rabuhine ban ro miyae nekai sele nebei romau kikira enayembondere relenainyele, nebeibe na hului ban. ");
INSERT INTO set_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Roko mbai nebei imae rorele annunde nebei romau ahunembonde mare na moinye nenensimbe hebembe, me kaba-kaba yae bombe wennele, ‘Rowa, romau raweibo meyae emambondere!’ “Nebei rowa yae ungembe, ‘Reyae mare onaemale ya, makeisabe meyae mekaube.’ ");
INSERT INTO set_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Mayae benen wennele, ‘Aei mbai raman anewande. Weyae mbai maei yone kelewamae.’ ");
INSERT INTO set_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Benen nane a mbai ungembe, ‘Reyae mare onaemale, makeisabe meyae mekaube. Ndara eme hasale yae beko bakore mokoyaube ro miyae!’ ");
INSERT INTO set_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Naei ya mende mayae Abraham, Ishak, Yakub, nane merau Allahle yenjo kayaayo nemene Allahle yo ei waku einye eremmile, nebeibe mare hukenayensimbe. Nebei heene mayae rime a kena beko hele kombe. ");
INSERT INTO set_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Naufa, waisa, ebunda, robonda nemene menate Allah naei yo waku mennembondene nebeinye raman bulaunge rei mai yae menaikonde. ");
INSERT INTO set_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nebeibe rore rowaimi ro miyae helen Allahle bene ro ban inyaibonde. Nane merau nda hee ro ban nekate ro miyae helen ro bele inyaibonde.” ");
INSERT INTO set_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nebei hee Farisi holona yo hiwa mekate Yesusre wainye, “Nda yora eye, yo hire yae ele, rabuhine ban Herodes ware honeubondere baete.” ");
INSERT INTO set_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Nebeibe Yesus yae weumi, “Eme, nebei ame-ame yaneyele ro isaei yennele, ‘Ereiko, nda hee bele wahena bele alo yoni-yoni Reyae hukeremile, erane buloone kayeke yo onomi isemiyende. Ya name nendo Raei kalia riyau ufebonde.’ ");
INSERT INTO set_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nebei aerene Reyae nda hee, wahenare, ya hende alorengkondere, rabuhine ban na mekai ban sele Allahle yendo kayaalo mbai sambai Yerusalem yo moinye herende. ");
INSERT INTO set_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Yerusalem, Yerusalem! Allahle yenjo kayaayo mayae howaube haiwaube! Allahle abu ako ruka yae bowaube haiwaube! Roko naennaen don ojo nafe na fa-fare noro keleene hanemikondere wanen mae mare yaufembombere relewanale, nebeibe meyae kena ban sele. ");
INSERT INTO set_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nebei wanenne nda heera mare Allah ei ehawei. Nda a isaeyembombe, nda heera Rare ereiboi mo nekemembe mende mayae elembe, ‘Tuhan Allahle Ro eisa mele Kiyaere onomi foka hubannende.’ ” ");
INSERT INTO set_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabat ya mbai mo Farisi holona ro bele rowainye ro mbai naei imaene ramande aneneikondere Yesus eke. Hiwa yo Yesusre ijoko mokaiboke erewainye. ");
INSERT INTO set_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Yesusle bokore ro mbai na uwa nemene benben baeyeke meke Yesusle bene meufebeunguke. ");
INSERT INTO set_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nebeinye nekate yora hiwa Farisi holona yo hiwa Musale walora wali heere foloukoke homofaere isaeyaeiboke kelaeimi yo. Nebei ro erekeungene, Yesus nebei yore hineumi, “Musale walora wali heere foloukoke a hului Sabat ya erane buloone kayeke yo onomi imamile, eyeijae?” ");
INSERT INTO set_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nebei yo hineumi a ban faeu ban yaeiboke. Nebeinye, Yesus nebei ro yaweungehoke meke na hibi onomi ikeunge, nebeisa ukeunge ewole. ");
INSERT INTO set_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nare ewole mo, Yesus nebei arilewole yore weumi, “Ro mbai na sapi kelu Sabat ya yae perigi einye ruweube hikoube, nde yae mai nolo mekaubera Sabat yane nare hole omoloiboi?” ");
INSERT INTO set_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nebei yo hi yae Yesusre a ebeisoi mo, a ban faeu ban yaeiboke. ");
INSERT INTO set_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nebei yo riyane kaenewoumi mekate Yesus ereumi anuwau foise-foise mo baetene, Yesus nda ahuba ahuneuboke weumi, ");
INSERT INTO set_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ro mbai raman bulau mokombondere ware kaeneikote melene, anuwau foise-foise ebaeijae. Rabuhine ban, yeisi raeiboi kaban bele hibe moisa wabengkonde mende era. Nebeinye, ");
INSERT INTO set_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","nebei imae rorele yae mende ungete, ‘Kena beko okoijae, nda angken nuwei nekeyae ndi ro kiyae melere rannehike.’ Nebeinye wa fe bele aungunde, na moinya hele angken nuwei honatene eunguweubonde. ");
INSERT INTO set_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Reyae wamale, ro hi yae ware kaeneneikote naei imaere elena, angken nuwei na moinya helene rowele. Nebeise kaenewole kiyae nenaeijae mende ungete, ‘Ako, mei ndi anuwau foinye nuweibo.’ Nebei wanende ware ro miyae arilewole nolone buma kaeneibote ");
INSERT INTO set_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nde nauwa kaendena, kerenainyekonde onde. Nde wali ara nihennehindena, ro miyae nare ro enainyeronde.” ");
INSERT INTO set_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nebeisa mo Yesus nebei imae rorelere weunge, “Raman bulau kaban, ebi mokoubondene waei kahili wafeu, aka baeke, hokolo uneyau, waei imae ribo mbainya nekaube ro miyae, hembonilo relalo, ekaenei emeijae. Rabuhine ban, benen ware kaenenayeikote. Weyae mokowamae wanen naei wanen mbai benaibonde ware mokonayete. ");
INSERT INTO set_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nebeibe raman bulau eumokoubondene keren ban nale ban yo, mera nimewaimi yo, orora nimewaimi yo, ijoko kumba yo, kaeneumile menate. ");
INSERT INTO set_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nebei wanen mokoubondena, Allah ware foi yae ei haweneite. Naendae wanen horore nebei yo ware benen ebeisoi omokoiboi sului, wali himalainyeboke ro miyae nulu yo mahe yore benen anainyunde heene, Allah waei roibu hobeneikote.” ");
INSERT INTO set_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nebei nolora ro mbai Yesus a eleukoke boroukokene, weunge, “Ro miyae Allah Naei yo waku mende yane yawemmile raman bulau Nangkele mbainye enayanende yo, onomi foka hubanainyele.” ");
INSERT INTO set_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nebeibe Yesus yae nda ahuba ahuneuboke weunge, “Ya mbai, ro mbai raman bulau kaban mokoubokere ro miyae helen homo hayewoumi. ");
INSERT INTO set_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Meraufe raungehike ya mo, nebei rorele naei abu akore ukeunge homore hayewoumi yore emmikaenendere, ‘Mem, nemene ninae mokannehake!’ ");
INSERT INTO set_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Nebeibe kaenewoumi yo menate naeise na hului ban mae a wainye. “Ro mbai nendo kiyae weunge, ‘Ikele okoijae, reyae kani manemfa roukale, ijoko ereiboise erelere hele.’ ");
INSERT INTO set_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Ro bee nendo kiyae weunge, ‘Ikele okoijae, reyae nda sapi me bee menemfa roi yae roukale, ijoko foi eremierengkonde hele.’ ");
INSERT INTO set_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Ro name nendo kiyae weunge, ‘Miyae manemfa hele roukalene reyae ei sului.’ ");
INSERT INTO set_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Nebei abu ako bukeufike eke na roware nebei a weungekoke. Na rowa nebei wanen boroubokene, ikele hele kowole. Nebeinye benen na abu akore weunge, ‘Hasale yae bukeisi eye. Nibire, a koukoufe baeumile. Hun ban wai ban yo, mera nimewaimi yo, ijoko kumba yo, oro nimewaimi yo, nemene yaweumile ndare menate.’ ");
INSERT INTO set_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Na heki ban mo nebei abu ako na roware weunge, ‘Nemene weyae ukarae huluinye mokowale, nebeibe angken nuwei hiwa namman na bangka honate.’ ");
INSERT INTO set_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Nebei bulau ro benen weunge, ‘Raei imae ei maemae kongkonde naeise eye, nibi kabanna akela nibina ele, ereumile yo u hale yae weumile ndare menate. ");
INSERT INTO set_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Reyae wawale, nebei homore waheukokamaele yora ro mbai raei imae eise raman aneikoise menensinde belene.’ ” ");
INSERT INTO set_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ro miyae helen sele Yesusle moisa mewate. Euweke erekeumi mo weumi, ");
INSERT INTO set_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Rare kena buhae heufene hakonsebonde oroyende kiyae nenake naekore, na miyae fa-fare, naei aka baekere, nane merau naei uware bele hole omoloyei yae Raei moisa ehakoiboi oroi sului. ");
INSERT INTO set_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Raei aerene ohaline bonaikonde ro Rare hakoufele wanen ehakoiboi kiyae, Raei moisa orowate holona yo ban. ");
INSERT INTO set_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ro mbai mai nolora imae mbaise hembondena, namman eheiboi mo roi na helen me baengkonde. Roi na hingkin ma nda imae hembonde riyau wennebonde. ");
INSERT INTO set_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Rabuhine ban huba yae yensebendena, erabae aehure bohi ruka ahuneukoke, erenate yo re yae harenainyele. ");
INSERT INTO set_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","A elenate, ‘Yei, nda ro na imae hewole riyau eweiboi ya!’ ");
INSERT INTO set_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Nane merau ondofolo mbai naei felayo ro nemene 10.000. Ondofolo hi kiyaele fela roroneikondere nebeibe naei felayo na helen 20.000. Nebei aerene ondofolo mbai nendo nuwembonde nou hembonde na hului nebei felayo helende melemmihande. ");
INSERT INTO set_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nauwara hubannele na hului banna, namman ahaufa nekele heene abu akore wemmile enate, foi mokonaikonde.” ");
INSERT INTO set_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Na huba mokoikoise wa Yesus yae weumi, “Mai nolora nde nerambun-rambun enukeiboi ehaiboinya, Raei moise hakonate holonane eyeisi sului. ");
INSERT INTO set_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Hae na yu foinya, nebei hae na foi. Nebeibe na yu u yembondena, na hului ban benen yu belere mokonainyebonde. ");
INSERT INTO set_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nebei hae rabuhi ban yeuboke, kani foi mokonnekondere na hului ban sele, na hibi kaenainyehinde.” “Raei wamale are boraube ro miyae nebei are nou hembe.” ");
INSERT INTO set_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ya mbai mo, Yesus huweumi are boronate naeise pajakre arilate yo nane merau u mekai beko bako bele yo arilewole. ");
INSERT INTO set_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nebeibe Farisi holona yo bele Musale walora wali heere foloukoke homofaere isaeyaeiboke kelaeimi yo bele a mulun-mulun mae elewate, “Yeu, ro miyae u mekai beko bele Neyae ei haweyeumi nane merau raman don bele mbainye anate.” ");
INSERT INTO set_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesus nda ahubabe ahuneuboke huwoumi, ");
INSERT INTO set_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ro mbai mai nolora wanen naei domba nemene 100, domba mbaibe nundeuboubena, rahebe mokouboube? Neyae nebei 99 nemene na ke faunge nukeumiboube, nebei mbai nundeuboke kiyaere baeungeweube roweungele mete. ");
INSERT INTO set_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nda domba mbai ken nundeubokere hubayeikoube baka ranne kaeuboube kena rei mai bele imaere meube. ");
INSERT INTO set_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nebeisa nebei ro naei hokolo uneyau, ro miyae naei imae ribo mbainye nekate yo kaeneumile, ‘Mem, rei maise komalere. Ra domba mbai nundeubokerabe, nebeisabe ekale roukanale mekende.’ ");
INSERT INTO set_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nebei wanen mbai ro mbai beko nolora meukuke nulu keungebokene surgana yo rei mai kaban sele kate, ro miyae 99 nulu keumibokera.” ");
INSERT INTO set_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesus benen nda ahuba ahuneuboke huwoumi, “Maengke mbai na roi perak me bee hele. Mbai nundeuboubena, isehe yae naeufoube, niheungehiube imaena retara nemene faeinyeukoube, baeube. ");
INSERT INTO set_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ereubera, naei hokolo uneyau bele imae ribo mbainye nekate yo bele kaeneumile, ‘Mem, nda heene raei imae einye rei maise komalere. Rabuhine ban raei roi perak mbai nundeubokerabe benen roukale.’ ");
INSERT INTO set_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Reyae wamale nebei wanen mbai ro mbai beko bako mokoimeyelera nulu keungebokene Allahle malaikat yoni-yoni rei mai kate.” ");
INSERT INTO set_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesus benen nda ahuba ahuneuboke weumi, “Ro mbai na kelu fa-fa bee. ");
INSERT INTO set_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Na moinya kiyae yae naekore weunge, ‘Arai, waei rambun rambun honatera raei kayee yeisoko.’ Nebeinye naeko hokolo beere naei rambun kayee moloumikoke. ");
INSERT INTO set_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mainyekeukoke mo, nda fa nebei rambun naei kayee yeungekoke yaroukoke naise heukoke, kulun uke ahaunga kanire ewole. Eke nebei kanine na roi nemene haiwole, wali na isohi-isohi bekore kena haehae kole hului nekewole. ");
INSERT INTO set_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Na roi baeungehoke hee mo, moni mai naei kaban sele nebei kanine meungeke kowate. Na wali kabewounge hele. ");
INSERT INTO set_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nebei kanina obore nareumi ro mbaite bokore eke, roi kaliare mokondere riwounge. Nda ro yae ukeunge naei obo kayaane eke hebewole. ");
INSERT INTO set_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nebei ro moni yaroungekokene, obo yae anate ramande naei kena anengkondere kowole, nebeibe hi yae ha yae nare eyei mo. ");
INSERT INTO set_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Nebeisa u bene meungenekeufike elele, ‘Yei, maekole imaena na yebaei bubaei raman aneyatera kalun-kalun bele ekaisonate, nebeibe ndane reyae monine hererelere kale! ");
INSERT INTO set_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mana ya reyae maekole bokore bukerehinde erelere maekore na yaka yae ufende, “Arai, reyae u mekai beko helebe Allahre nane merau ware mokowabale, ");
INSERT INTO set_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nebei aerene reyae waei fa yae eleikoi sului. Rare waei yebaei bubaei yae me baeufebonde.” ’ ");
INSERT INTO set_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Na hibi kulun uke naekole bokore ewole. “Nahau buhaufa hele mewole naeko naei imaera roungeboke. Naeko naei kena buhae nekai sele kowounge, habeleumeke hahi yae roukeunge yoi bulu hunewounge. ");
INSERT INTO set_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Nda fa naekore weunge, ‘Arai, Allahre nane merau ware beko nekai mokowabale. Rare na hului ban hele waei fa yae me ebaeufebondere.’ ");
INSERT INTO set_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Nebeibe naeko yae imae einye kaliare mokate yore kaeneumi, ‘Hasale yae malo naei foi sele rowemme na une menne hirengko, bula na mene mennehirengko, oro mehau norone menne hirengko. ");
INSERT INTO set_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nebeisa embe sapi hokolo fa rundun koba-koba hele rowembe nensambe, rei mai komale anemale. ");
INSERT INTO set_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nda raei fa herekerabe benen waleuboke, eungundeubokerabe benen mende hubayekoke.’ Nebeinye yo koi yo bae yoloufake kowate. ");
INSERT INTO set_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Nebei ya na fa bena kiyae na hekene yae. Hekera mokoukoke mewole imaere nobewounge bae, amin waku yo koi yo bae katebe borole. ");
INSERT INTO set_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nebei aerene, naei imae eise kaliare mokate ro hire kaeneungekoke hineunge, ‘Nda rahe erabe kate?’ ");
INSERT INTO set_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nebei ro yae weunge, ‘Wauwake mana bukeufike meke. Na fa na be foi yoi foi yae mekene naeko ukeumi sapi hokolo fa rundun koba-koba hele naendehake.’ ");
INSERT INTO set_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Na fa bena ikele hele kowole, imae eise enensindere ahi hele elewole. Naeko meke a moi-moi yae mokowounge eise enensindere. ");
INSERT INTO set_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nda fa yae weunge, ‘Arai, ralo yae yakama yae waei kaliane relei-telei relewekanale, waei a wewekarae borowekawale. Rahebe nebei wanen ware mokowekawalene rare ikarae? Raei hokolo uneyau bele yo koi yo baere amin wakure komakondere kambing mbai fere eneisai mo! ");
INSERT INTO set_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nebeibe waei fa waei rambun-rambunde eke miyae maengke nauware naise haete yore heraeyeumiboke, bukeufike meke bele, sapi foi moi nare houngebokae!’ ");
INSERT INTO set_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Naeko yae weunge, ‘Kelu, weyae rangkele mo nekeyende kiyae. Raei rambun yoni-yoni nemene waei rambun bangka mo. ");
INSERT INTO set_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Amin waku yo koi yo bae komale hele. Wauwake herekerabe waleuboke, nundeubokerabe mandehubayeukoke.’ ” ");
INSERT INTO set_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesus na moisa orowate yore nda ahuba huweumi, “Ro mbai hembonilo relalo. Naei abu ako yae nebei ro naei rambun yoni-yoni nendon heraeyele are hiwa yo yae a mainyeneke. ");
INSERT INTO set_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nebei abu ako kaeneungekoke, weunge, ‘Waei a boroukokale hului weyae u bulu-bulu bele ro. Raei rambun yoni-yoni weyae yaroukokae nane merau mokoukokae na helen homone moloiko roweime, rabuhine ban ninae weyae mokoukokae.’ ” ");
INSERT INTO set_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Nda abu ako u bene baeiso-baeiso kowole, ‘Naendae wanen mae mokorebonde? Nda ro hukensehindena, rahe kaliabe mokorele? Kani nei-nyeise reyae elae ban wake ban koyale, a ri-ti fe mo nde riyende!’ ");
INSERT INTO set_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nebeisa elele, ‘Ninae u bene nekeufehike. Hukensehinde ya bae, raei kahili naei imaere erelene ei haungaisele naeise nda me ure mokorebonde.’ ");
INSERT INTO set_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Nebei abu ako na rowa naei rambun yaraikoke yo kaeneumikoke mekate mo weumi, ‘Raei rowale rambun mayae yaraukoke nebeibe namman eheikoi ebaeisoi naennaen hului honate?’ ");
INSERT INTO set_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Ro mbai nendo yae weunge, ‘Raei minyak zaitunda helai 100.’ “Nebei abu ako yae weunge, ‘Mbae nda homo niyae 50 hele yae moloiko.’ ");
INSERT INTO set_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ro bee nendore hineunge, ‘Aka baeke, waei kayee naennaen hului?’ “Nebei ro yae weunge, ‘Raei gandum holoboi 1000.’ “Abu ako yae weunge, ‘Nda homo moloi niyae moloiko holoboi 800.’ ");
INSERT INTO set_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Naei u bene holoka koukokene, nebei u bulu-bulu u mekaise na rowa yae buma kaewounge. Nda kani kelana wali beko nibine orate ro miyae naei riyane bele a mokoi-mokoise meli mekai ayeukoke Raei are borate hakoyate yora.” ");
INSERT INTO set_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Reyae wamale, nda kani kelana rambun yoni-yoni yae ro hi miyae hire hakoumiyendere, nebei wanen maere kahili wafeufe arilewende. Here mende, nda rambun yoni-yoni erabuhi ban inyaibonde nane merau surgare eweufinde ro bele melaeinyayeibote. ");
INSERT INTO set_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ro mbai rambun ebibire kayaa foi hebende, foi yae mokondene, nebei ro mbai rambun kabande rabo halaete. Ro hi rambun ebibira kayaa foi ehebei, foi omokoinye, rambun kabande rabore ehalei sului. ");
INSERT INTO set_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nda kanina kelana rambun yoni-yoni mai mene rabore ehalei huluinya, surgana rambun yoni-yoni bele nde yae mai mene rabo halende? ");
INSERT INTO set_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ro miyae hiwa naei rambun waei menare rabore ehaleinya, nde yae waei naei rambun inyete? ");
INSERT INTO set_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ro mbai rowa bee naei kaliare omokoiboi sului. Rabuhine ban hire kena ikele konende, hire kena buhae hennele nane merau hire angkaei boronnele, hire oboroi. Nebei sului mbai Allahre boroyainye yo, roi naei yebaei bubaeise eyeiboi sului.” ");
INSERT INTO set_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisi holona yo Yesus huwoumi a angkaei yae borowate. Roise kena kaban kowatene, Yesusre aukaka kowainye. ");
INSERT INTO set_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Nebeibe Yesus weumi, “Mare ro miyae naei, bene mai wali ijen mae elembe, nebeibe Allah mai kena u ei bele isaeyeuboke. Ro miyae yae ro bele elande rambunde, Allah ro ban mae ereunge. ");
INSERT INTO set_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Musale walora wali heere foloukoke homofae bele Allahle yenjo kayaayo homone molaikoke bele a faeufe huwaimi meke Yohanes bure kowoumi kiyaele heene. Nebei heera Allah merau raungehike Naei holona ro miyae Raei me kelee u keleene nekenate a faeufe huwammi. Nda hee ro miyae elae relaeinye Raei me kelee u keleene nekate yo holone enayembondere. ");
INSERT INTO set_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nda kani kela bele yaku bele nendon mekai nundenaibonde, nebeibe Musale walora wali heere foloukokene honate a mbai sambai ehobeikoi sului. ");
INSERT INTO set_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Nde na miyae nennehinde benen miyae hibe rowendena, nebei kiyae u bekobe mokouboke. Ro mbai miyae nenainyehindebe rowende nekenetena, nebei nane merau u bekobe mokouboke.” ");
INSERT INTO set_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Nebeisa Yesus benen weumi, “Ro mbai hemboni rela, kuikui maemae nolone nekeweke. Ambelae foi-foi bun-bun neyae hireweke, nime nolo kaungei nolone nekeweke. ");
INSERT INTO set_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ro mbai naei wali a ri-ti yae riyeweke, na ro Lazarus, na uwa u bauwau wae feleungeboke koweke. Nare hemboni rela bele kiyaele imae romau bene nekainyele honowole. ");
INSERT INTO set_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Na moni kolere, hemboni rela bele kiyae anele raman mohi-mohi balatere anengkondere bele yoku yae mekate na bauwaube faeu wae efelaeiwate. ");
INSERT INTO set_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Nebeisa Lazarus hereke malaikat-malaikat yae yawainyehoke ekate surgane Abrahambe bokone hainyeboke. Hemboni rela bele kiyae nane merau hereke ai moloufake. ");
INSERT INTO set_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Narakare eke u buhae wa buhae hele hubawounge. Na ijoko narakara erewole bae, nahau felera Abrahambe erekeunge nekele Lazarus na bokone. ");
INSERT INTO set_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nda ro yae kaenele, ‘Yobe Abraham! Rare kena buhae korekomae ya. Ra u buhae kaban sele nda i nolone hubanale Lazarus wenemae na mengkamaunge bu yaweufiube meube raei faeu ranne raufehiube ya.’ ");
INSERT INTO set_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Nebeibe Abraham mae weunge, ‘Kelu, bene nekayete, wa wali heki foi yoni-yoni nemene ninae hubawekae, Lazarus yae bekobe hubawounge. Nda hee neyae ndane foi mekeufubaunge, weyae beko mekaehubanae. ");
INSERT INTO set_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nebei mo ban, nane merau aei nolone bo (a bulu) kabani hele honole. Ndana yo nebeise ofoi, nebeinya yo ndare emei!’ ");
INSERT INTO set_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Nda ro yae weunge, ‘Nebei uwana, Lazarusbe weinye maekole bokore eu. ");
INSERT INTO set_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Nebeinya maeka naei rauwake wa nemene maehae mbai. Nda u buhae wa buhae hubayanne anuwaufe emeijae hele naeise Lazarus ende angkaa yobommibonde.’ ");
INSERT INTO set_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Nebeibe Abraham mae weunge, ‘Musale walora wali heere foloukoke homofae bele Allahle yenjo kayaayo molaikoke homofae bele nemene na mena ekaisonate. Nebeinye erenate hakonate!’ ");
INSERT INTO set_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Nebeibe nda ro yae weunge, ‘Nebei homofae koi-koise neyae kena ban nekeyate. Ro mbai herende benen walembonde naei bokore endena, neyae nulu kemmibonde.’ ");
INSERT INTO set_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Nebeibe Abraham mae weunge, ‘Musalena, Allahle yenjo kayaayo naeinya honate homofaena a neyae moi yae bulenainyelena, ro miyae hereubera aungube horo londe bae neyae be ebukeisi.’ ” ");
INSERT INTO set_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesus na moisa orowate yore weumi, “Oro halunde hayaeimi rambun yakanaibonde hele, nebeibe nebei oro halunde hayemmile kiyae na wali beko hele hubannende. ");
INSERT INTO set_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Na foi sele nebei beko mulire yobombonde kiyae na bereise na horora ruka ehekaei yae na horone ha molonaisinde bumoko nolo lonne enaiwonde, nda fa-fa wanen ro miyae wali beko nibibe kelemmile bele. ");
INSERT INTO set_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ma uwa kayaa foi yae hebembe! “Waka baeke na wali ereungele bekore wenendena, a yareungekonde, nulu kennebondena, na bekore u benera nundenayengkombe. ");
INSERT INTO set_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ya mbai mehine bee bele ware beko mokoneikotena, benen nulu kennebondera a mende ungete, ‘Ikele okoisemae,’ na beko mokouboke u benera nundenayeikote.” ");
INSERT INTO set_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Na abu ako benen Yesusre wainye, “Tuhan, maei hila rabo elae yeime.” ");
INSERT INTO set_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Yesus yae weumi, “Ma hila rabo sawi ko ebi ken wanen bae o ha kabande waungele, ‘Raweibo ndi bumoko nolone yeisebe,’ na hului raweuboube yeufebeube. ");
INSERT INTO set_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ro nde yae na yebaei bubaeise ara bura meube mo weungele, ‘Mei na hibi raman mei aneiko!’? ");
INSERT INTO set_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nebei mekai ban sele. Na hele beufoube weungele, ‘Eraman koloisoko. Wambelae foi hireko, ndane mo hebewonde. Reyae raman andekonde baensonde mo, nebeisa weyae aneukonde.’ ");
INSERT INTO set_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Yebaei bubaei, abu ako, nebei naei wanen mokonatebe, nebeibe na rowa ‘helen foi’ ewei, rabuhine ban na baka ranne kaliare mo mokowate. ");
INSERT INTO set_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nebei sului mbai mayae Allah a ukembe kalia mokombe baensonde hee, elembe ‘Maei ukeume kaliare mo mokowande. Meyae yeise raeiboi ban yebaei bubaeibe nekande.’ ” ");
INSERT INTO set_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesus Yerusalem yore ewole hee, Samaria kani bele Galilea kani bele hee randa ewole. ");
INSERT INTO set_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Yo mbaise eweufike mo, ro me bee na u bauwau wae molayekene Yesusle bokore mewate. Nebei hee ro miyae u bene nekewaimi u bauwaufe era buloone foisi-foisi foyatene, nda yo nahaufa hebaiboke kaenainyekoke, ");
INSERT INTO set_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","“Yesus, Tuhan, maere yanekoi yase yae ei meimehawei!” ");
INSERT INTO set_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesus nebei yore ereumikoke mo weumi, “Eme imam-imamde mauwa onomi yaraukokere emmikelembo.” Nibine alainyekoke ewate mo, onomi yaraikoke. ");
INSERT INTO set_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nebei me bee nolora ro mbai na uwa onomi yeuboke erewoungene, bukeufike meke Allahre buma nekai kaewounge. ");
INSERT INTO set_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Meke Yesusle oro bene be are neke, helen foi uwounge. Nda Samariana ro mbai mo meke. ((Yahudi yoni-yoni Samaria ro miyaere ele moise woke yo yae elewate.)) ");
INSERT INTO set_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nebeinye, Yesus yae weumi, “Ro me bee lonbe, onomire yaeiboke yo? Na mehine keli bele makeinya ekate? ");
INSERT INTO set_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Rahene nda ele moinye robe, nembai mo bukeufike meke Allahre buma mekeukolounge?” ");
INSERT INTO set_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nebeisa Yesus nda rore weunge, “Ainyu eye. Wa hila rabo yae onomi ikete!” ");
INSERT INTO set_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ya mbai Farisi holona yo hiwa mekate Yesusre hinainye makei hee yae Allah Naei yo waku mennembonde. Yesus yae weumi, “Allah Naei yo waku mennembonde hee ro miyae nda ijoko hele ereiboi. ");
INSERT INTO set_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nane merau ro miyae hiwa yae ware ewei, ‘Mennerembo nda niyae!’ Hiwa yo yae nane merau ewei, ‘Ndi nare!’ Rabuhine ban, Allah Naei yo waku mai kena u einye honole.” ((Yesusle me kelee u keleene nekate niyae.)) ");
INSERT INTO set_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nebeisa Yesus na moisa orowate yore weumi, “Bena ya mendene mayae kena kaban kombe Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyaere erensebombere, nebeibe mayae Rare ereiboi sului. ");
INSERT INTO set_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nebei heene ro miyae a hira kaenenate, ‘Ndare erennoko! Ndire erennoko!’ Naei are oboroijae ehakoijae hele. ");
INSERT INTO set_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Wili wanen yakune wele na hehe nda kani kela nemene naeikoyole wanen mbai Raei merele ya. ");
INSERT INTO set_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Na bere holo Reyae beko nekai hubarengkonde, nebeisa nda heena ro miyae Rare moi bulenaisebonde. ");
INSERT INTO set_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Raei uwa yakarebonde heene, Allahle yendo kayaalo Nuh bere nekewole hee wanen. ");
INSERT INTO set_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nebei heene nekewate yo raman anewate, miyae yarowate iwaimi, ya-ya nebei hului mo kaimekate Nuh kai kaban einye meufileukoke heene. Nebeisa bumae yae meke yarowole bune ayaneuboke. ");
INSERT INTO set_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Nebei wanen mbai Lotle heene, ro miyae raman bu anayeke, rambun yoni-yoni nai haeyeke yarayeke, heke mokayeke, imae haeyeke. ");
INSERT INTO set_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lot Sodom yora meukuke mo, nebei ya mbai i yakura oke, ro miyae nemene howole haiwole. ");
INSERT INTO set_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Nebei wanen mbai Raei merele yane. ");
INSERT INTO set_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Nebei ya ro miyae imae bumane hebenatena, nerambun yaroikoise imae eise oijae. Nebei sului mbai hekena mokonate yo imaere ebukeijae hele. ");
INSERT INTO set_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lotle miyaene mo bene nekenayembe. Nerambun u bene nekewainyene moise yae be beufoke bae, hae rukare yeuboke. ");
INSERT INTO set_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nde na walire hole molonnebonderena, herende bae Allahle nanembainye einyekei. Nde na wali Allahle me einye kinyennebondena, herende bae Allahle nanembainye eneinyekende. ");
INSERT INTO set_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Reyae wamale, nebei reniai ro bee a honson mbainye ijongku hononete, hire rowende, hi nukennebonde. ");
INSERT INTO set_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Miyae bee melune yalenete, hire rowende, hi nukennebonde. ");
INSERT INTO set_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ro bee hekene eneimokonde, hi rowende, hi nukennebonde.” ");
INSERT INTO set_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yesus na moisa orowate yo yae hinainye, “Tuhan, makeinye?” Yesus nda a ahuneuboke weumi, “Makeinye makeinye era kaka honate, aye abara mali hubayeikoyate.” ");
INSERT INTO set_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesus Na moisa orowate yo na hibi-hibi yae Allahre ebeli bonainyende nane merau rabo ban nekatere kelemmile naeise Yesus nda ahuba ahuneuboke huwoumi, ");
INSERT INTO set_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Yo mbainye hakim mbai Allahre fe efaeyei nekeweke, rore miyaere nde ban beweke. ");
INSERT INTO set_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nebei yo mbainye miyaenale (rora moloufake) mbai roko yae roko yae nebei hakimbe bokore eibeiso meibeiso koweke weunge, ‘Raei yokeijo beko mokoufeboke rambunde benen ijen mae mokoibo!’ ");
INSERT INTO set_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Ya-ya yae oroumekere hakim nebei miyaenalere ahi yae mo weungemeke. Nebeisa hakim u bene nekainyekoke mo na kena eisa elele, ‘Reyae Allahre fe efaeyei, rore miyaere nde ban beyale. ");
INSERT INTO set_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Nebeibe nda miyaenale rare hileiko-hileiko koimeyeufene, ninae hakorembon. Ehakoiboinya, na hibi-hibi mo orommende, reyae ijongku foi ohonoiboi korele.’ ” ");
INSERT INTO set_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Nebeisa Yesus yae weumi, “Nda hakim nde ban beyele yae elele a boraube. ");
INSERT INTO set_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Naendae wanen, Allah Naei eleuboke wekeumi ro miyae nebei wanen reniai rai hileiko-hileiko kainyeweube yore ehakoiboi? Hakoiboi naeise wahenare, ya hendere yae wemmile? ");
INSERT INTO set_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Reyae wamale, Allah nebei ro miyae naeise u hale aere olende! Nebeibe Reyae, Allahle bokora mekale ro miyae uware yeubokale Kiyae, roko bee nendo merele heene, naendae wanen, Rare hila rabore halaeise yo hubaimale?” ");
INSERT INTO set_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ro miyae hiwa nauware wali himalainyeboke yae erainye, nebeibe hiwa yore u mekai beko bele yae eraimi. Nebei yore kelemmile naeise Yesus nda ahuba ahuneuboke huwoumi, ");
INSERT INTO set_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ro bee ebelire boneinyele naeise Allahre ei mom-mom imae na kaban sele kiyaene ekete. Ro hi Farisi holona, na hi kiyae pajakre arilewole ro. ");
INSERT INTO set_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisi holona ro eufebeunguke hebele naei naeise elele, ‘Allah, reyae nebei ro miyae hosoro wanen banne Ware helen foi sele wawale. Reyae yoko ebaeyei, beko omokoyei, ro naei miyae uwa mbainye ohonoi nane merau raei wali ndi ro pajakre arileyele kiyaele wanen ban. ");
INSERT INTO set_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Reyae mon mbai roko bee yarele me heiboyale nekeikoyale. Nane merau raei roibure hobeyaise rambun me bee kayeero Allah yeyawale.’ ");
INSERT INTO set_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Nebeibe pajakre arileyele kiyae yae, nahaufa hebeunguke na be kanire beufoke na beko mokowolene kena beko hubawounge yae elele, ‘Allah, reyae beko bako bele ro, rare yanekoi yase yae ei haweufele.’ ” ");
INSERT INTO set_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesus yae weumi, “Reyae wamale hokolo bee imaere ewote, pajakre yaroyele kiyaebe Allah yae nare wali himaloungeboke ro yae me baeungeboke, nebeibe Farisi holona kiyaere me ebaei. Nauware kaete ro miyaere ane enaimikolonde. Nauware ane koloyainye ro miyaere bumane emmikande.” ");
INSERT INTO set_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ro miyae na wayeu fa-fa mere herawemmile naeise yarowaimi Yesusle bokore mewate. Yesus na moisa orowate yo nebei wanen erewatene, nebei ro miyae mewatere a yae yarewaimi. ");
INSERT INTO set_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nebeibe Yesus nebei fa-fa ebibire kaenewoumi wa elele, “Raei bokore nebei fa-fa ebibi nendon waemmihi mai! Nare ahemmimae! Rabuhine ban Raei me kelee u keleene nekate holona ro miyae fa-fa u mekai wanen nekate. ");
INSERT INTO set_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nana heselebe wamale, nde yae fa-fa naeko nenake weimi are boroyeumi wanen Reyae wamaele are oboroinya, Raei me kelee u keleene nekate ro miyae holone eyeiboi sului.” ");
INSERT INTO set_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yahudi yun-jun nekatena ro mbai meke Yesusre hineunge, “Guru, u mekai foi bele Kiyae, reyae rahe me ube mokorebonde wali hena eitoufele?” ");
INSERT INTO set_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Nebeibe Yesus yae weunge, “Rahene weyae rare u mekai foi bele yae warae? U mekai foi bele ro miyae u, Allah nembai u mekai foi bele nekele. ");
INSERT INTO set_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Allah yae Musare ukeunge wali heere foloukoke are weyae isaeiwoyae, Ro miyae bele miyae ro bele uwa mbainye ohonoijae, ro miyae ohoijae, yoko ebaeijae, ro miyae naei ro nendon naeise eheyeijae, araise anare be hinenaimile.” ");
INSERT INTO set_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nda ro yae weunge, “Nebei nemene fomene na hokolora reyae mokoyale.” ");
INSERT INTO set_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nebei wanen eleukoke borokene, benen Yesus yae weunge, “Mbai sele honole niyae weyae mokoubonde hele. Waei rambun-rambun nemene naise heukonde, nebei roi keren ban nale ban yore waheumikonde. Nebeisa surgana hemboni relabe waeise enaijembonde. Nebeisa mele Rare hakoufebonde orayende.” ");
INSERT INTO set_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Yesus yae uwounge a boroukokera na hemboni rela helen selene na kena beko kaban kowole. ");
INSERT INTO set_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesus ereungekoke wa elele, “Hemboni mali rela mali ro miyae Raei me kelee u keleene nekate yo holo eise eyeiboise kabenainyekonde. ");
INSERT INTO set_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Unta jarum bulure nendon eweufiube, hemboni rela nolone nekeyate yo, Raei me kelee u keleene nekate yo holo eise neyae eyeiboise kabenainyekonde.” ");
INSERT INTO set_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ro miyae hiwa Yesus nebei a wanen eleukoke borokainyelene hinainye, “Nebei wanen mae eleyaena, makei yo yae wali hena bona enaiyaronde?” ");
INSERT INTO set_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesus yae weumi, “Ro miyae yae omokoikoi sului rambunde Allah na hului mokonde!” ");
INSERT INTO set_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nebeisa mo Petrus yae weunge, “Eramae, Ware mo hakomayete naeise maei rambun nemene nukewande haiwande.” ");
INSERT INTO set_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesus yae weumi, “Nde yae na imae obe, na miyae fa, naka baeke, nenake naeko, Raei me kelee u keleene yo holo aerene nukemmibondena, ");
INSERT INTO set_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nda kanine neyae nebei hului mbai benen helen yaronde nane merau herendera wali hena bona endowende.” ");
INSERT INTO set_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesus na moisa orowate yo me bee oro nen bee bele yore na mo-mo arileumihike mo weumi, “Eyae Yerusalem yore emalere. Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyaele naeise Allahle yenjo kayaayo homone molaikoke hului benatere. ");
INSERT INTO set_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Allahre onaeinye ro miyae naei mene Rare kinyenaisebonde. Neyae aukaka konaisele, a beko ungaisele, eki hesere roronaisele, rahuae bonaisekondera honaisebonde. ");
INSERT INTO set_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Nebeibe ya name mo Reyae walerebonde.” ");
INSERT INTO set_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yesus nebei a merau elewokere na moisa orowate yo hi yae ha yae isaeyeiboi. Na mekai harawounge nebei yore felewoumi, onewate rahe abe elewole. ");
INSERT INTO set_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesus Yerikho yo nobewounge yae, ro mbai ijoko kumba nibi enene nekewole a ri-tinye riyewole. ");
INSERT INTO set_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ro miyae helen sele mate borowolene hineumi, “Nda rahe erabe yeuboke?” ");
INSERT INTO set_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nebei yo wainye, “Nazaretna Yesusbe mele.” ");
INSERT INTO set_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nebei a boroukokene nebei ro yae kaenele, “Yesus, Ondofolo Daudle kelu! Rare yanekoi yase yae ei haweufele ya!” ");
INSERT INTO set_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nebei ro hilembonde naeise na bena hebate ro miyae a elae yae haewainye, nebeibe neyae kali laeisi-laeisi kowole, “Ondofolo Daudle kelu! Rare yanekoi yase yae ei haweufele ya!” ");
INSERT INTO set_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesus hebeunguke mo ukeumi nebei ro yawainyehoke. Naei bokore yae meke mo, Yesus yae hineunge, ");
INSERT INTO set_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Waei kena koyae rahebe ware mokoreibotere?” Nda ro yae weunge, “Tuhan, raei kena kaban sele koyale benen ijoko ererelere.” ");
INSERT INTO set_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesus weunge, “Mana onomi rowei! Wa hila rabo elae randa nda foi roukae.” ");
INSERT INTO set_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nebei ro na ijoko na hibi onomi yeuboke. Nebeisa Yesusre hakoungeboke ewote Allahre buma kaeungeke. Hebewate yo nebei wanen erewatene, naeise naeise Allahre buma kaewainye. ");
INSERT INTO set_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesus Yerikho yo einye eweufike oroweke yae, ");
INSERT INTO set_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","nebei yona ro mbai na ro Zakeus, hembonilo relalo pajakre arilate holona yo naei yun. ");
INSERT INTO set_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yesus ndebe ijoko yae erennebondere, nebeibe Zakeus oro fone nane merau ro miyae helen selene, Zakeus Yesusre erennebondere relewounge an. ");
INSERT INTO set_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nebeinye ro miyae mate nolora bere yae hakauboke o bumare neke yeuketeke, Yesus keleera mende na hului hilonnele. ");
INSERT INTO set_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesus meke nebei ijenne mo bumare euweke Zakeusbe kanekeunge weunge, “Zakeus, hasale yae oi akoibo! Reyae nda ya waei imaene erensindere.” ");
INSERT INTO set_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nebeinye Zakeus u hale me hale owakouboke, Yesusre yaweungehoke na rei bele naei imaere ewote. ");
INSERT INTO set_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nebei erewate ro miyae na a mulun-mulun bele elewate, ro wali beko lonbe naei imaere ete! ");
INSERT INTO set_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakeus Yesusle naei imaene ekete mo, hebeunguke Yesusre weunge, “Tuhan, raei hemboni rela nolora waherekondere reufi ro miyae keren ban nale ban yore isemikondere. Ro miyae nde nde reyae ame-ame yaneungekale kiyae, raeisa nare berensonde raka keli isengkonde!” ");
INSERT INTO set_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesus yae weunge, “Nda heene Allah ware hole molokokete, rabuhine ban Abrahambe wanen weyae Allah a ukete hului mokobokae. ");
INSERT INTO set_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Reyae, Allahle bokora mekale ro miyae uware yeubokale Kiyae, ro miyae wali nibi mekaisorate yore baeimeyamaele nane merau hole eremimolonde.” ");
INSERT INTO set_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","A elewolene namman nare borainye mo, Yesus nda ahuba ahuneuboke huwoumi, rabuhine ban Yerusalem yore Yesus naei nobaeinyekoke nane merau ro miyae u bene nekewaimile Yesus Yudea kani naei Ondofolore menjembonde hee nobeungeboke. ");
INSERT INTO set_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yesus yae weumi, “Ro mbai ondofolo riyana kani hire ewole. Ende ondofolore enjembondere oro umau heraungainyebondera benen bukensinde na yore yande mende. ");
INSERT INTO set_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Namman kulun ewei ei mo, na imae einya kaliare mokate ro me bee kaeneumiko mekate. Naeise naeise roi roibu oko name hobenaikonde hului yeumikoke. Nebeisa mo weumi, ‘Reyae nukerembombe heera nda roi foi yae mokombe mende reyae bukerehinde merele.’ ");
INSERT INTO set_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Nebei yona ro miyae hiwa nda rore ikele kowainyene ro hiwa ukaimile na moisa enate, ungainyele, ‘Meyae kena ban nda ro maei ondofolore nekendere.’ ");
INSERT INTO set_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Nebeibe nebei ro ondofolore nekende kiyae oro umau herawainyeboke, bukeufike naei yore ewole. Nebei roise waheumikoke yore kaeneumikoke mekate isaeise rowendere naennaen hului na roi benen baraikoke. ");
INSERT INTO set_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Ro mbai nendo meke weunge, ‘Ondo, nebei roi ikarae mokoungebokale me beere yeuboke.’ ");
INSERT INTO set_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Nebei ondofolo yae weunge, ‘Foi sele, weyae abu ako foi. Rambun ebibine rabo halawale. Nebei aerene ndi yo yan me bee waei me einye kinyereibote.’ ");
INSERT INTO set_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Ro bee nendo meke weunge, ‘Ondo, nebei roi ikarae mokoungebokale maehae mbaise yeuboke.’ ");
INSERT INTO set_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Nebei kiyaere nebei ondofolo yae weunge, ‘Yo yan maehae mbai waei me einye kinyereibote.’ ");
INSERT INTO set_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ro name nendo meke weunge, ‘Ondo, nda wa roi niyae reyae malone ruleufikale honoumeke. ");
INSERT INTO set_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Weyae nansau felene, reyae buhae hokowoufe. Waei banbe roweyae, weyae omoloikoi ijen ani eisokoyae.’ ");
INSERT INTO set_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Nebei ondofolo yae weunge, ‘Weyae ro beko hele! Waei are eleukokae huluinye mana ware mokoreibotere. Weyae waeisaei reyae ro nansau, raei banbe reyae rowale, reyae omoloyei ijenne ani eisokale. ");
INSERT INTO set_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Rahene weyae roi meli mekai bele ro miyaere eyei? Emiyemae, neyae nebei yo rambun hi yae mokouboube roi barauboube. Mele mo helen wanen mae rowele.’ ");
INSERT INTO set_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Nebei ondofolo nebeinye hebate yore weumi, ‘Na mena roi rowen, mbai nendo kiyaere yenne.’ ");
INSERT INTO set_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Nebei ro miyae hebate yae wainye, ‘Neyae naei helen sele.’ ");
INSERT INTO set_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Nebeibe benen nebei ondofolo yae weumi, ‘Reyae mare wamale, nde na mena bele honate kiyae benen helen sele baranainyele. Nde na mena ebibi yobounge kiyae, nebei rambun-rambun ebibi yobounge nemene kuyenainyekonde. ");
INSERT INTO set_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mana reyae ninae ondofolore heberelere rare ahi yae elewate yo yawemmibo mai. Ra bene nemene hongko hayengko!’ ” ");
INSERT INTO set_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nebei ahubara huwoumikoke baeufoke mo, Yesus bere neuboke Yerusalem yore ewate. ");
INSERT INTO set_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Betfage yo bele Betania yo bele Zaitun moko kelaeunge honote yo bee nobaeinyeboke mo, Yesus na moisa orowate nolora ro bee ukeumi bere enetere, ");
INSERT INTO set_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Yesus yae weumi, “Bena yore ebe,” “Nebei yone ebalebene keledai hokolo fa mbai erenele ha yae rinainyekoke. Ro mbai na randa efileikoi mo. Na ha bulaerenekobe ndare yawenehobe mebe. ");
INSERT INTO set_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ro hi miyae hi mare hinenayebena, ‘Rahere nebei keledai ha bulaereunge?’ Meyae wennele, ‘Maei Tuhan mae ukeume.’ ” ");
INSERT INTO set_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Hokolo bee ekete Yesus na are eleukoke huluinye bewate. ");
INSERT INTO set_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nebei keledai hokolo fa na hane bulaerewoinye mo, keledaise hayeunge ro meke hineumi, “Rahere nebei keledai ha bulaereunge?” ");
INSERT INTO set_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nebeibe hokolo bee yae weinye, “Maei Tuhan nda keledai randa efilengkondere hele.” ");
INSERT INTO set_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nebeisa keledai yawoinyehoke Yesusle bokore ewate. Ekate na malo nebei keledai uwa ranne hayaeinyekoke nebeisa Yesusre ikilainyeboke keledai ranne yeunguweuboke. ");
INSERT INTO set_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yesus keledai randa mei-meise mo mewole, ro miyae naei nibi ende ijende malo yae bewate. ");
INSERT INTO set_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yerusalemde nobewounge, Zaitun moko nonore owole ijenne mo, naei ijoko yae erewate Allah naei mahi-mahi mokowole bewatene na moisa orowate yo helen sele mun sobolo Allahre buma kolowainye. ");
INSERT INTO set_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Nebei yo kaenate, “Allahle ro yae meke Ondofolo, onomi foka hubannele!” Meyae ebeli bomanele surgane rei mai nekenayende nane merau Allahre hili hebenainyende. ");
INSERT INTO set_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Farisi ro miyae nebei kaenate nolone hebate Yesusre wainye, “Guru, ndi Waei moisa mate yo weumi hilaibone.” ");
INSERT INTO set_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nebeibe Yesus yae weumi, “Reyae wamale, ndi yo hilenaibondena, nda ruka ufemile kaenenate.” ");
INSERT INTO set_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesus Yerusalem yore nobewoungele wa euweke erewounge rimewounge, ");
INSERT INTO set_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","elele, “Yei, Reyae kena kaban koimeyale mayae isaeyembombe Reyae na hului rei mai isembe, nebeibe nda hee nebei a usaei nunne hononende. ");
INSERT INTO set_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ya mon mbai mende, wa yokeijo helen menate yo ele yanainyehonde na ranne honsi-honsire konate naeise kani hainyaikonde ahenayengkombe, yanenayengkombe, bohira bohira ainyayengkombe. ");
INSERT INTO set_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Allah waei hole moloiboise mekebe mayae Nare ehakoiboinye, waei ro miyae, waei kelu omi, waei imae obe, nemene ninae kuinyayengkombe, faeinyenayembombe, ruka ahunewate aene ranne ohonoi yembonde.” ");
INSERT INTO set_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nebeisa Yesus Allahre ei mom-mom imae na kaban sele kiyae eise eweufike nebeinye nai hei-sei yore hukewoumi weumi, ");
INSERT INTO set_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“Allahle homofaene nda wanen molaikoke, ‘Raei imae obe ro miyae ebeli boi-boi imaere yembonde.’ Nebeibe mayae mekaube yokoyo naei nalere maumokouboke!” ");
INSERT INTO set_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Allahle imaene mo rene huae keleumiyeke. Nebeibe imam yun-jun bele Musale walora wali heere foloukoke isaeyaeiboke kelaeimi yo bele Yahudi yun-jun bele Nare honaibondere nibi baewate. ");
INSERT INTO set_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Nebeibe nibi baewate an, rabuhine ban ro miyae helen Naei a faeu elewokene maeumikoke. ");
INSERT INTO set_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ya mbai Allahre ei mom-mom imae na kaban sele imaehounge Allahle a foi faeu foinye Yesus huwoumi yae imam yun-jun bele Musale walora wali heere foloukoke homofaere isaeyaeiboke kelaeimi yo bele Yahudi yun-jun bele ");
INSERT INTO set_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","mekate Yesusre hinainye, “Nde yae nda elae ikete?” ");
INSERT INTO set_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Nebeibe Yesus yae weumi, “Reyae benen mare hinerensimbere. ");
INSERT INTO set_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yohanes ndele ro yae bure kowoumi, Allahle ro yae, ro miyae ro yae?” ");
INSERT INTO set_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nebei ro na mo-mo arileufike elate, “Allahle ro yae elemakondena, Neyae aere wemmele, nebei wanenna rahene naei are elele huluinye mayae ehakoiboi? ");
INSERT INTO set_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Benen, ro miyae naeinya yae elemakondena, nda ro miyae boronate bae aere ruka yae hainyaimele, rabuhine ban naei u benera nekaimi Yohanes Allahle yendo kayaalo.” ");
INSERT INTO set_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nebeinye Yesusre wainye, “Meyae maeisaei ban.” ");
INSERT INTO set_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesus yae weumi, “Reyae nane merau mare ewei, ndele elae yae nda rambun emere-emere mokale.” ");
INSERT INTO set_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesus nebei ro miyae arilewolere nda ahuba ahuneuboke huwoumi, “Kani rowa mbai anggur heke mokouboke. Nebeisa roi yae mokonate yore nebei heke kinyeumiboke, kulun uke, yo hire kolone oroweke. ");
INSERT INTO set_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Anire hokonate hee, nebei kani rowa naei yebaei bubaei mbaise ukeunge ewole naei ani kayeere rowende. Nebeibe nebei hekere mokate yo yae nare rahuae baikoke hukainyehike na me bangka u bangka yae ewole. ");
INSERT INTO set_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nebei heke rowa benen yebaei bubaei hi ukeunge ewole. Nda kiyae mekere benen bowate fe mokainyeboke nebei hului mbai ukainyele na me bangka yae ewole. ");
INSERT INTO set_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nebei heke rowa yebaei bubaei name nendo ukeunge eke. Nebei heke yo herawaikoke bowate ba hainyebokera, kaeibokate heke ele moinye wokate. ");
INSERT INTO set_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Nebeisa bae nebei heke rowa yae elele, ‘Benen rahebe reyae mokorebondere. Mana raei kenare kanale fabe ufende endere. Neyae endene, ndi yo fe faenainyele era.’ ");
INSERT INTO set_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Nebeibe nebei heke rowa na kelu mewole erekainyelene nebei hekere mokate yo naeise naeise elate, ‘Naeko herendera nda hekere rowende kiyae niyae. Mem homabondere! Nda rambun rambun nukembonde aeise inyaibondere.’ ");
INSERT INTO set_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nebei fare yobaiboke ekate heke moinye haiboke.” Nebeisa Yesus yae hineumi, “Nebei heke rowa bukensinde mende bae, nebei heke yore naendae yae mokommile? ");
INSERT INTO set_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Reyae elale meube nebei heke yore houkoube hele, nebeisa nebei hekere mo roweube benen hiwa yore yemmile.” Yesus nebei a eleukoke boraikokene, nebei yo yae elate, “Meyae rabo halemale nebei wanen ebeijae!” ");
INSERT INTO set_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesus nebei ro miyaere ijoko ereumi mo wa elele, “Nebei wanen mae elaubena, nda Allahle homofaene honole a rahe naeise molaikoke? ‘Imae hei-seise isaei hebaen bele yo na hului banne wokate rukabe, mana na bereise yae erainye?’ ");
INSERT INTO set_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ro miyae nde nebei ruka ranne ruwende kiyae mohi mohi kamai kamai yembonde; nde nebei ruka yae onde wende herawembondena, kani man kela mande yembonde.” ");
INSERT INTO set_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Musale walora wali heere foloukoke homofaere isaeyaeiboke kelaeimi yo bele imam yun-jun bele na hibi Nare ikilenaikonde nibi mbai baewainye rabuhine ban naeisaei Yesus naei u naeibe nebei ahuba ahuneuboke huweyole. Nebeibe ro miyae helen erewaimine fe yae faewate. ");
INSERT INTO set_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nebei yo Yesusre naei ijoko ranne mo erainye. Ro mbembare a moi-moi yae mokaimikoke Yesusle bere ame-ame yae wali himalainyeboke yo yae enate. Yesusre melaeli roronainyele a mahi wanen elengkondena, nebei kanire ikileuboke Ondofolole me einye kinyenaibonde naeise. ");
INSERT INTO set_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nebei ro a moi-moise mokaimikoke yo ekate Yesusre wainye, “Guru, meyae maeisaei nekande Waei a faeu kelaemae nemene na hele mo. Nane merau Allah a wete hului wali nibi naeise rore miyaere na bene-bene wamae, be ijokone erei. ");
INSERT INTO set_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Mana maere na yaka yae weime, Kaisarre pajak imanele, eyeijae?” ");
INSERT INTO set_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yesus nebei yo naei holoka kate isaeyeubokene weumi, ");
INSERT INTO set_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Nebei roi mbai Rare kelensebo. Ndele me nou bele ro yun bele honole?” ");
INSERT INTO set_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nebei yo yae wainye, “Kaisarle.” Yesus yae weumi, “Nebei wanenna, Kaisarle kayee Kaisarre yennele, Allahle kayee Allahre yennele!” ");
INSERT INTO set_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nebei ro miyae nolone Yesus naei a faeu mbai sambai walangkare wainyejeke na hului ban yeuboke. Naei a eleukokene nebei yo fa yae bowate nane merau a ban faeu ban yaeiboke. ");
INSERT INTO set_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Saduki ro miyae (nda yo yae elate ro miyae heraiboke yo benen ewaleiboi) hiwa Yesusle bokore mekate. Yesusre hinainye, ");
INSERT INTO set_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Guru, Musa nda a huwe a relen aere harawoume, ‘Ro mbai miyae rowende na fa ban mae herendena, nebei ro hereke naei aka baeke hele yae nebei miyaenale nekenete, naeka naei orona menare holensindere.’ ");
INSERT INTO set_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Roko mbai ro mehine bee bele naeka nauwake nekewate. Na bena kiyae miyae rouke na fa ban mae nekeikoke neyae hereke. ");
INSERT INTO set_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nauwake bee nendo nebei miyaenale rouke nane merau fa ban mae hereke. ");
INSERT INTO set_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Nebei wanen mae mo, oke nauwake na nime kalaikoinya kiyaele nekeikoke na fa ban mae hereke. ");
INSERT INTO set_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Nebei miyae nebei sului mbai na moisa na fa ban mae hereke. ");
INSERT INTO set_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nebei ro yoni-yoni na mehine beene nemene nangkele nekaikokene, mende herewate yo benen anainyunde heene, nda miyae naei sele ndele nekenete?” ");
INSERT INTO set_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesus yae weumi, “Nda heena ro miyae yaronate, maengke rore enate. ");
INSERT INTO set_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Nebeibe bena ya fokehonolene, Allah yae wemmile anainyunde yo, benen rone miyaene kewa yumake mbainye ohonoi. ");
INSERT INTO set_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Allahle malaikat ekainyekate wanen, naei wanen enainyekende, here ehubayeikoi. Rabuhine ban heraibokera walenaibondene, nebeinye ndine Allahle kelu omire enayembonde. ");
INSERT INTO set_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Musa na yaka yae kelewoume, ro miyae herewate yo walenaibonde. Rabuhine ban isa folon i yae bewolene Musa yae Allahre nda ro yae kaenewounge, ‘Abrahambe Allah, Ishakle Allah, Yakuble Allah.’ ");
INSERT INTO set_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nebei aerene Neyae wali yo naei Allah ya, nulu mahe naei Allah ban. Allahle ro be ro yoinye ro miyae nemene wali bele nekate.” ");
INSERT INTO set_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ro mbemba Musale walora wali heere foloukoke homofaere isaeyaeiboke kelaeimi yo yae wainye, “Waei a foi sele eleukokae.” ");
INSERT INTO set_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Benende hinenainyelere, nebei yo fe yae faewainye. ");
INSERT INTO set_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesus nebei yore hineumi, “Rahene ro miyae yae Wali Ondofolo, Ondofolo Daudle orona mena yae elate? ");
INSERT INTO set_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Daud nenaeijae homofae Mazmurne moloukoke, ‘Allah yae Raei Tuhande weunge, Ra meube reufine meinyuweibo, ");
INSERT INTO set_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mende wa yokeijo nemene mokoremikonde woro keleene menayorulembonde.’ ");
INSERT INTO set_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Daud yae Tuhan mae kaeneungena, naendae wanen benen Wali Ondofolore Daudle orona mena yae elemakonde?” ");
INSERT INTO set_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nebei ro miyae Yesus ane elele borainye yae, Yesus weke na moisa orowate yore weumi, ");
INSERT INTO set_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Kayaa hebembe ndi Musale walora wali heere foloukoke homofaere isaeyaeiboke kelaeimi yo. Nare rore melaeinyaimile naeise malo koko neme yae hireikoyate. Nai hei-sei anuwaunge ate bohire bohire eyorate. Ei mom-mom imaene anuwau foise nare baeyate, nebei sului mbai raman bulau nolone. ");
INSERT INTO set_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Miyae hi na molo herele bae, naei imae einya rambun-rambun belae walae yae yaroyate. Na bekore felenaikonde naeise, Allahre ebeli koko eibainye. Allah nebei yore ehee bukulu na ehekaei sele emmiwononde.” ");
INSERT INTO set_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Roko mbai Allahre ei mom-mom imae na kaban sele kiyaene Yesus ijoko erewoumi yae run bele kangke bele nolone nekayeke yo na roi haufau anuwaunge hauwate. ");
INSERT INTO set_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Miyaenale rora moloufake mbai nane merau erewounge na wali kou kalo einye nekeyekebe meke na roi tembaga bee hele roi haufau anuwaunge haweukoke. ");
INSERT INTO set_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nebeinye Yesus yae weumi, “Reyae wamale, nda miyaenale na helen selebe neyae hauwole. ");
INSERT INTO set_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Nebei run kangke nolone nekate yo ebibibe yaraikoke mekaisawate. Nebeibe nda miyaenale naei wali hunde nekewolebe rouke mewauboke.” ");
INSERT INTO set_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Na moisa orowate yo hiwa mekate Allahre ei mom-mom imae na kaban sele kiyaena ruka baengko bele yae nane merau rambun hiwa yae uwa molainyebokene ei sele molowainye. Nebeibe Yesus yae nebei yore weumi, ");
INSERT INTO set_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Na ya bele hembonde nda imae eraunge nemene fomene kerensonde onde, ruka mbai sambai aene ranne ohonoi.” ");
INSERT INTO set_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nebei yo yae Yesusre hinainye, “Tuhan, Waei eleyae a makei ya yae yembonde? Iwau rahe ma yae rilende eremalene isaeimabonde nebei ya nobeungeboke?” ");
INSERT INTO set_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesus yae weumi, “Kayaa foi yae hebembe mare wabenayembe bele. Ro miyae helen sele Raei ro yae mekate are elenate. Nauwa naeise nda a elenate, ‘Reyae Wali Ondofolo Niyae! Huba mokoikoi ya nobeungeboke.’ Nebeibe, nebei yore oboroijae ehakoijae hele. ");
INSERT INTO set_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Buloo fela mahi-mahi naei aku borombena, buhae ohokoijae. Nebei nemene na bere yae menaibende, nebeibe huba mokoikoi ya na hibi yae ebei.” ");
INSERT INTO set_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yesus benen huwoumi, “Yo yan hi anainyunde yo yan hi bele fela relenainyele, kani hina yo anainyunde kani hina yo bele relenainyele. ");
INSERT INTO set_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Oinyeu kaban makei-makei nemene hinende, moni mai, yano o reu ha reu nenaisande ungayonde, era buloo mennende. Iwau beko bako mahi-mahi eme hele yakura benate erembe. ");
INSERT INTO set_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Nebeibe nda rambun-rambun nemene ebei mo, Raei aerene mare nemene ikilenayengkombera, weitasi konayembe. Ei mom-mom imaene yaungayembombe embe a kolonayembe nane merau kawa eise henayembe. Rare hakaufe aerene yobonayembe ondofolo kose bene yensebembe. ");
INSERT INTO set_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nebei benatene, mayae Raei naei a faeu nebei yore huwemmile. ");
INSERT INTO set_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mai kena elae yae hebembe, nebei hee naei a faeu hinenayembere mayae bukemmile naeise buhae ohokoijae. ");
INSERT INTO set_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Renaeijae isaei hebaen isembene, ma yokeijo yoni-yoni mai a faeu elembere ohoroiboi sului. ");
INSERT INTO set_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ana yae arai yae, aka yae baeke yae, yoho yongko yae, hokolo uneyau wae, mai kelai nenayende. Hiwa yo mbemba mai nolora honaikonde. ");
INSERT INTO set_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","“Rare hakonsele aerene, ro miyae nemene mare ikele konayembe. ");
INSERT INTO set_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nebeibe, mai Allahlena wali henara neyae ehobeikoi sului. ");
INSERT INTO set_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Rare hila rabo halensemembe walora wali hena bona hubayengkombe. ");
INSERT INTO set_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Felayo eremmile Yerusalem yo yanenainyekonde heene, mayae isaeyembombe nda yo na heki ban beko bendere. ");
INSERT INTO set_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nebei hee Yudea kanina ro miyae mokore habelenate. Yerusalem yo einye nekaube yo nukembombe membalembe, yo moinya yo benen yo eise eijae. ");
INSERT INTO set_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nebei ya Allah Na homofaene molaikoke honole huluinye ro miyae naei beko mokowate hului ehee bukulu hainyemikonde. ");
INSERT INTO set_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nebei ya emale miyae holona nane merau wayeu miyae holona beko hele hubanainyele. Yudea kanina nekate yo beko hele hubanainyekonde nane merau ikele han kaban me u yoni-yoni hubanaimile. ");
INSERT INTO set_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Hiwa yo ramiyaeli yae honaikonde, hiwa yo ikilenate kani hi kela hire yaungaimile enate. Allahre onaeinye yo menate Yerusalem yo ei yae anainyebonde, mende Allah huluise raungehike ya membaensonde. ");
INSERT INTO set_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Hune, okone, findelaunge, nebeinye yen mengkolonde. Nau wala kulun mendene, nda kanina kelana ro miyae fe yae waku yae yarommikonde, onenate handanate. ");
INSERT INTO set_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nda kani kelane benatere fe kaban faenatene ro miyae hokoiko-hokoiko konate, rabuhine ban kunde waufe ikilaikoke honate nemene bulenaibonde alenaibondene. ");
INSERT INTO set_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nebei hee ro miyae Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyaere elae wake bele one hengko hehe kaban bele mangko einye merele erenaisele. ");
INSERT INTO set_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nebei wanen erembe benate heene, annumbe, be bumare wemembe, ebi fere mo wali hena bona rowelere.” ");
INSERT INTO set_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Nebeisa Yesus nda ahuba ahuneuboke huwoumi, “Ara no hebele bele o hiwa hebate bele eremmiko. ");
INSERT INTO set_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Reu bu kate eraube bae elaube yakama nobeungeboke. ");
INSERT INTO set_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nebei sului mbai nda iwau hi hi erembe benate, mayae isaeyembombe ebi fere mo, Allah mare hole molonembombe. ");
INSERT INTO set_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Reyae wamale, nda hokolo namman nekenate, nda a wamale nemene menaibende. ");
INSERT INTO set_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Buma a nemene nundenate, nebeibe Raei ako faeukobe niyae mbai sambai enundeiboi mo hononayende. ");
INSERT INTO set_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mauwa kayaa foi yae hele hebembe, yo koi yo bae naeise bele bu elae naeise bele nda wali naei kena beko mokoyeumi naeise bele aerene buhae hokonayembe belene, nane merau huba mokoikoi ya mende obo yoku wali omokoisainye walangkane ikilenaikonde beko hubanainyekonde wanen mare beko hubanayembe belene. ");
INSERT INTO set_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Nda kanina ro miyae nekande nemene nebei ya hubanaimikonde. ");
INSERT INTO set_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kayaa foi yae hebembe. Allahre ebeli bonnele nebei beko bende yare mare hole molonembombe nane merau Reyae, Allahle bokora mekale ro miyae uwa yeubokale Kiyae, benen merele heene mayae buhae ohokoi yae Raei bene hebembe.” ");
INSERT INTO set_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Na yane baei Yesus Allahre ei mom-mom imae na kaban sele kiyaene eikeleumi. Huaere keisiyeunge Zaitun mokone einyekele. ");
INSERT INTO set_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Benen ya heiboyole bae, Allahre ei mom-mom imaene arilewainye ro miyae na rene mate Yesus are elende boronainyele naeise. ");
INSERT INTO set_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","((Mesir kanine Allah yae Yahudi naei bena kelu fa-fare hole molouboke u bene nekeisi-nekeisi)) ya kaban Paskah nobewounge. (Nebei heene feu ragi ban anewate.) ");
INSERT INTO set_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Nebei yona ro miyae helende fe yae faewaimine, imam yun-jun bele Musale walora wali heere foloukoke homofaere isaeyaeiboke kelaeimi yo bele Yesusre honaibondere nibibe baewate. ");
INSERT INTO set_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Yesusle moisa orowate ro me bee oro nen bee bele nolona ro mbai Yudas Iskariotle kena einye walobo yun meweufike. ");
INSERT INTO set_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nebeisa Yudas eke imam yun-jun bele Allahre ei mom-mom imae na kaban sele kiyaele kayaare hebate yun-jun bele bokore eke Yesusre kelai nenendere are kolonainyekondere. ");
INSERT INTO set_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nebei yo rei nekai kowate, Yudasre wainye, “Ware roi yae imayete.” ");
INSERT INTO set_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yudas be hineuboke, ya monbe ereumeke Yesusre kelai nenende ro miyae naeisaei ban mae kinyemmibondere. ");
INSERT INTO set_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nebei ya kaban ninae nobeungeboke. Nebei yare domba mbai hili era akau era yae Allahre ongkou feleiboyate. ");
INSERT INTO set_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesus Yohanesle Petruslere weumi, “Ebe ndire, nda ya kaban aei raman anemakondere mokonnehabe.” ");
INSERT INTO set_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nebei bee hineinye, “Tuhan, makeinye Waei kena koyae meyae raman mokomansandere?” ");
INSERT INTO set_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesus yae weumi, “Yo eise ebebobe yae ro mbai na mene bu helena kaembonde mende. Hakonnekobe na moisa ebe, neyae enensinde imaene mangkele ebebobe. ");
INSERT INTO set_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Imae rorelere wennele, ‘Aei Tuhan mae riyele makei ijenne Rangkele Raei moisa orande yo bele nda ya kaban naei raman anemakonde?’ ");
INSERT INTO set_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nebei rorele imae buma raka na wakun kaban honolebe mare kelenebobe. Rambun-rambun na hului sului nebeinye honate. Nebeinye mayae raman mokonnehabe.” ");
INSERT INTO set_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Petrusle Yohanesle aloinyekoke ekete Yesus naei are eleukoke huluinye na ijenne bewate. Nebeinye hokolo bee Paskah raman mokoinyehake. ");
INSERT INTO set_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Paskah ramande anenate hee mo, Yesus meke Na abu ako nolora nuweuboke. ");
INSERT INTO set_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nebei yore Yesus weumi, “Raei kena kaban kale Reyae namman beko ehubayeikoi yane, nda Paskah raman mbainye mangkele anemakonde. ");
INSERT INTO set_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Reyae wamale, nda heera benen reyae nda ya kabanda raman aneikoi mo nekerende, mende ro miyae Raei me kelee u keleene orulenaibonde nekenate yo Allah merau raungehike hului yae anenate. Benen nebei ro miyae Rangkele nanembainye anggur bu anemahinde.” ");
INSERT INTO set_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nebeisa kolaei anggur bure rileuboke rouke, Naeko Allahre helen foise mo ukeunge wa elele, “Nda kolaei yaron, maise maeise menaei wahen. ");
INSERT INTO set_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Bene nekenayembe, nda heera benen Reyae nda ya kabanda raman aneikoi mo nekerende, mende Maeko mokommibonde ro miyae Raei me kelee u keleene orulenaibonde nekenate. Benen nebei ro miyae Rangkele nanembainye anggur bu anemahinde.” ");
INSERT INTO set_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nebeisa, Yesus feu rouke benen Naeko Allahre helen foise ukeunge, benen Naei me yae kaiwole nebei yore iwoumi weumi, “Nda Raei uwa melen niyae, mai aerene ikembe. Rare u bene nekeisi-nekeisi wanende nda mokande wanen mae mokomembe.” ");
INSERT INTO set_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nebei wanen mbai raman anaikoke mo, anggurre anate kolaeise mo rouke weumi, “Nda kolaei einye rambun ((walora u bene nekenayembe)) mai aerene Raei ha rileubokale. Raei ha yaere Allah a heteungekoke nibi neme ro miyaere wali himalainyeboke yo yae me baemmile a elaekei yeuboke. ");
INSERT INTO set_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Nebeibe eraunge! Raei kelaise nenende kiyae Rangkele mbainye ndane nekende. ");
INSERT INTO set_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Reyae, Allahle bokora mekale ro miyae uware yeubokale Kiyae, Allah meraufe raungehike huluinye hererele, nebeibe Raei kelaise nenende kiyae beko hele hubannende!” ");
INSERT INTO set_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nebei yo naeise naeise na uware uware hinate, ndebe naei nolora nebei merau mokombonde? ");
INSERT INTO set_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yesus na moisa orowate nolora aku yeuboke. Ro ndebe naei sele naei nolora rorele yae erenainyele (fe faenainyele). ");
INSERT INTO set_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesus yae weumi, “Nda kanina kelana nekeyate ondofolo kose na ro miyaere feleyaimi nane merau nauware kaenaimile, ‘Aka kayaa baeke kayaa yo.’ ");
INSERT INTO set_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nebeibe mayae nebei wanen omokoijae. Nde mai nolora rore ronainyele kiyae, na wali fa meha wanen mae oronde. Nde ondofolo kosere nekendena, bennehonde abu ako wanen mae mokonde. ");
INSERT INTO set_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Yebaei bubaei ramande wahaeimi yo ro ban. Ondofolo kose ramanne anele kiyaere ro rainyeboke. Nebeibe Reyae yebaei bubaei yae mai nolone nekeimeyale. ");
INSERT INTO set_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Bekore meisubanale yane mayae Rangkele hebemeyande. ");
INSERT INTO set_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","Raei yo waku einye mayae nendon Rangkele mbainye raman emanende naeise nane merau Israel naei akona akona me bee oro nen bee bele na orona mena yore naei walire mayae hului kolommile naeise, Maeko yo waku mbai kinyewoufe naei wanen mbai Reyae mare yo waku mbai kinyerembe.” ");
INSERT INTO set_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesus na moisa orowate ro mbai na ro Simon. Yesus yae weunge, “Simon, Simon, boroyae! Walobo yun meke riyeufehike ware wabeneifitere. ");
INSERT INTO set_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nebeibe Simon, Reyae waei naei ebeli Allahre bowanale hila rabobe nelae yae mo hebele. Weyae benen bukeufinde Raei a ufete hului nekele ya, waei aka baeke hiwa yo naei hila rabore elae eumiyende.” ");
INSERT INTO set_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petrus yae weunge, “Tuhan, ware kawane henayeikotena, honayeibotena, raei uwa mokoungehakale Wangkele mbainye nekale.” ");
INSERT INTO set_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Nebeibe Yesus yae weunge, “Petrus, mana ya ojo mukuu a namman okoikoi mo, Rare weyae waeisaei ban mae roko name weumikonde.” ");
INSERT INTO set_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Nebeisa Yesus yae nebei yore weumi, “Na bena hele mare ukamale embe naeise. Malo huba, kakali, oro mehau nemene eyaroi eijae ukamale. Nebei hee kalo molowombe?” Nebei yo yae wainye, “Omoloiboi!” ");
INSERT INTO set_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yesus yae weumi, “Nebeibe nda heera, malo huba, kakali hononatena, nemene yarongkombe embe; nde ramiyaeli banna u hale yae na malo roi naise hembonde, nebei roi yae na hibi ramiyaeli rowende. ");
INSERT INTO set_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Allahle homofaene Raei naeise nda a molaikoke, ‘Nare u hila wa hila ro yae elenaikonde.’ Nebei a Raei uwane yembonde hele. Allahle homofaene Raei uwa naeibe molowate hului na hele benate eraube.” ");
INSERT INTO set_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yesus na moisa orowate yo yae wainye, “Tuhan, ereibo ndana ramiyaeli bee.” Yesus yae weumi, “Ninae na hului.” ");
INSERT INTO set_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesus benen naei orole wanen Yerusalem nukeungeboke na moisa orowate yo bele Zaitun mokore iwate. ");
INSERT INTO set_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ikate mo weumi, “Ebeli Allahre bonnele, walobo yun wabenensimbe balembe bele.” ");
INSERT INTO set_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nebeisa Yesus ruka yalo roko mbainya wande eukuweube hului yae nebei yo naei bokora nahau eke, oro selen-selen mae oukoroukoke Naekore ebeli bowounge, ");
INSERT INTO set_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Arai, na huluinya, nda beko Raei rande mendere ahaufe yae kinyeibo eu. Nebeibe Raei kena kale yae omokoijae, Waei kena huluinye mo mokole.” ");
INSERT INTO set_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Surgana malaikat mbai meujakauboke elae ikeunge. ");
INSERT INTO set_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesus na kena u eisa han wanen mae howote nebeinye benen Naekore ebeli bowounge. Na uwana roibu ha kibo-kibo wanen mae kani rande balewate. ");
INSERT INTO set_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ebelira boungekokera mo, Yesus benen na moisa orowate yo riyare eke. Nebei yo eke erewoumi kena beko kaban kowatene nemene u kei-keinye ijongkune mo honaiboke. ");
INSERT INTO set_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nebei yore weumi, “Rahene ijongkune mo honaube? Annu, ebelibe bonne walobo yun mare wabenensimbe balembe bele.” ");
INSERT INTO set_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesus namman nare ane elate bae, ro homo mbai nekate mewole. Yudas Yesusle moisa orowate kiyae yae be neuboke eke Yesusre yoi bulure hunennehindere. ");
INSERT INTO set_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nebeinye Yesus yae Yudasre weunge, “Yudas, wa kelai neufende naeise Rare yoi bulu yae huneufehindere?” ");
INSERT INTO set_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yesus na moisa orowate yo nda rabuhi yembonde era erewaimine Yesusre wainye, “Ramiyaeli yae folomakondere ya.” ");
INSERT INTO set_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Nebeisa Yesus na moisa orowate ro hi ramiyaeli yae uke bae, imam kaban nabu ako na angkaei meube reufibe neufake ruke. ");
INSERT INTO set_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Nebeibe Yesus yae weunge, “Ninae okoijae!” Nebeisa nebei ro nangkaeise mo ikileungeboke na hibi foi yeuboke. ");
INSERT INTO set_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nebeisa Yesus imam yun-jun bele Allahre ei mom-mom imae na kaban sele kiyae kayaare hebate yo bele uwoumi, “Rare yokolo yae elaubene era, Raei ikileiboise ramiyaeli yae o bohi-bohi yae yaraukoke mekaube? ");
INSERT INTO set_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Reyae na yane baei Allahre ei mom-mom imae na kaban sele kiyae na imaehounge nuweuboyale keleimeyamaelebe, mayae Rare ikileiboi. Nebeibe ninae, nda ya mayae ouben hauben nolone nekaube yo mai kena hului mokongkombe.” ");
INSERT INTO set_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Yesusre ikilaiboke, na hibi hele yawainyehoke imam kabanbe imaene ewate. Yesusre yawainyehoke ewate moisa Petrus na ahau folo yae hakoumiboke. ");
INSERT INTO set_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nebeinya ro miyae uware akelenate naeise imaehou nolone i ralo kaban mokaibokene nuwaikoke. Petrus na nolone eunguweuboke. ");
INSERT INTO set_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Petrus nebei imaehounge namman nekele yae, maengke mbai imam kabanbe yebaei bubaei nebei nolora meke Petrus isehe naeungekoke yae ereungekoke nabe ijoko roungeboke wa weunge, “Nda ro Yesus Nangkele mbainye orowote.” ");
INSERT INTO set_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nebeibe Petrus oneunge yae elewole, weunge, “Reyae Nare onaenale.” ");
INSERT INTO set_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Na heki ban mo ro hi Petrusre erewounge, weunge, “Weyae nane merau Naei holo mbainye orowaube.” Petrus weunge, “Reyae nebei holona ban!” ");
INSERT INTO set_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Hukai mbai nekeukoke mo, ro hi eleukoke, “Na yaka hele weyae nebei holona na ro hi niyae, rabuhine ban weyae Galilea kanina rone.” ");
INSERT INTO set_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Petrus weunge, “Waei a eleyae reyae na hele isian!” Petrus nda a mekai eleukoke hee yae ojo a koukoke. ");
INSERT INTO set_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tuhan Yesus be beufoke Petrusre na hibi ijoko ereungeboke. Petrus nebei hee yae Yesus yae ukeunge abe u bene nekeungehike, “Nda hee ojo a okoikoi mo, weyae roko name Rare oneufekonde a eleukonde.” ");
INSERT INTO set_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Petrus nebei abe u bene nekeungehikene, imaehou moise eke rime a yan bu yan rimewole. ");
INSERT INTO set_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yesusle kayaare hebate yo hiwa Nare aukaka kowainye hiwa rahuae yae bowate. ");
INSERT INTO set_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nane kayaa yo hebate yae na ijoko aheikoyainye mo hinainye, “Mana eleiko nde yae ware rahuae ukete.” ");
INSERT INTO set_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nane merau aukaka konainyele a nekai sele uwainye. ");
INSERT INTO set_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ya heuboke mo, Yahudi yun-jun bele imam yun-jun bele Musale walora wali heere foloukoke are isaeyaeiboke kelaeimi yo arileufike, Yesus yawainyehoke naei are kolainye ijenne meufebeunguke. ");
INSERT INTO set_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Nebei yo wainye, “Maere yakaimebo, Wali Ondofolo Kiyae Weyae Niyae?” Yesus yae weumi, “Mare yakarembombena, mai nolora ro mbai sambai a hele yae eleikoi. ");
INSERT INTO set_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nane merau Reyae mare hinerensimbena, mayae wo okoi. ");
INSERT INTO set_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nebeibe nda heera Reyae, Allahle bokora mekale ro miyae uware yeubokale Kiyae, ninae erele Allah Elaelo Wakelo Naei meube reufine erenuwembondere.” ");
INSERT INTO set_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Borate yo nemene hinainye, “Naendae wanen, Weyae na hele Allahle Kelu?” Yesus yae weumi, “Mayae elaube hului mbai.” ");
INSERT INTO set_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nebei yo yae elate, “Ro miyae Naeinya a hele ame lon ninae oboroijae, mana ya naei euwara na hele borokande!” ");
INSERT INTO set_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nebei are kolainye yo nemene ainyukate, Yesusre yawainyehoke Ondofolo Pilatusle bere ekate. ");
INSERT INTO set_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nebeinye ekate mo, nebei yo Nare nda a horoubokebe elate, “Nda ro erannekoke aei kanina ro miyaere nibi bekobe keleimeyeumi. Neyae weumi Kaisarre pajak omokonnemae. Nauware elele Neyae Ondofolo hi yae, Wali Ondofolo yae.” ");
INSERT INTO set_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Nebeinye Pilatus Yesusre hineunge, “Na hele Weyae Yahudi naei Ondofolo?” Yesus yae weunge, “Wenaeijae nane merau eleyae.” ");
INSERT INTO set_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nebeinye Pilatus imam yun-junde, nebei ro miyae arilewolere weumi, “Reyae nda ro naei u mekai wa mekai nane merau naei a faeu nemene ereungekokale, na foi bangka mo. Rahe randa Nare bekore mokomandere?” ");
INSERT INTO set_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Benen nebei yo waeli hele baete elate, “Yudea kanina ro miyae nemene a moi hurewoumile naei era hena hului ehakoiboi yae nekenate, na bereise Galilea kanina ro miyaere bere a nareumikoke, mana meke ndane.” ");
INSERT INTO set_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatus nebei elaikoke are boroukokene hineumi, “Nda Galileana ro?” ");
INSERT INTO set_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Galilea kanina yo Ondofolo Herodesle me einye honole. Pilatus isaeyeuboke Yesus Galileana rone, nebeinye Yesus ukainyele Ondofolo Herodesle bokore eke. Herodes nebei hee Yerusalem yore kolone oroweke. ");
INSERT INTO set_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ondofolo Herodes Yesusle a elayeke borowekene, kena kaban kowole na be ijoko erenembondere. Herodes rabo halewole Yesus rambun emere-emere naei bene mokombonde. Neyae Yesusre erewoungene naei uwa roweungehike. ");
INSERT INTO set_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nebeinye Herodes Yesusre a hi yae hineyeunge hi yae hineyeunge, nebeibe Yesus a mbai sambai ewei sele. ");
INSERT INTO set_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Imam yun-jun bele Musale walora wali heere foloukoke homofaere isaeyaeiboke kelaeimi yo bele hebewate Yesusre a elaekei sele nekainyele. ");
INSERT INTO set_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes bele naei felayo bele Yesusre mahi-mahi mokowainye, aukaka yae kowainye, ondofolo ondofolo naei yo malo yan malo haeinyeboke, benen bukainyehike Pilatusle bokore ekate. ");
INSERT INTO set_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herodes bele Pilatus bele yokeijo yae nekeyekebe, nebeibe nebei ya foi mokoikokete kahilire yeibokete. ");
INSERT INTO set_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatus imam yun-jun bele Yahudi yun-jun hiwa bele ro miyae hosoro bele arilewoumi ");
INSERT INTO set_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","weumi, “Mayae nda ro raei bokore yawaungehoke meke elaube ro miyaere a nekai huweumi akure ketembondere. Mana ya nda mai bene reyae ereungekokale, mainya beko elaube naeinye reyae ehubayeikoi mo. ");
INSERT INTO set_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes nebei sului mbai ehubaikoi, rabuhine ban ereungekokera ukeumi benen raei bokore yawainyehoke mekate. Nda ro Na me u mokolera nane merau Naei a faeu elerera erannekoke. Mayae nane merau na yaka eraube hoiboise homabondere me ure Neyae omokoiboi. ");
INSERT INTO set_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nebeinye reyae rahuaere mo ufemile bonaikondera haisengkonde ende.” ");
INSERT INTO set_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Paskah ya kabande mo naei era hena huluinye, kawane hebate ro mbai nebei yore Pilatus hayennekonde menduwende. ");
INSERT INTO set_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nebei ro miyae arilewole yo yae kaenate, “Nebei ro hombo! Maere Barabasbe hayennoko meukuwe!” ");
INSERT INTO set_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabas yo kelai yan kelai mokouboke, ro houkokene kawane haeinyekoke.) ");
INSERT INTO set_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatus kena kowole Yesusre hayennekonderene, nebei ro miyae arilewolere a roko hi bele a uwoumi. ");
INSERT INTO set_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Nebeibe nebei yo yae kaenate, “Nare ohaline bongko! Nare ohaline bongko!” ");
INSERT INTO set_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Roko name nendo Pilatus nebei hului mbai hineumihike weumi, “Rahe bekobe neyae mokouboke? Reyae mbai sambai Naeinye beko ehubayeikoi, Nare homabonde aere u hele. Nebeinye reyae ufemile Nare rahuae bonaikonde, nebeisa haisengkonde ende.” ");
INSERT INTO set_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Nebeibe nebei yo kali ara nene kaenate Yesus ohaline bonaikondere hele. Naei a yae mo herawaiboke. ");
INSERT INTO set_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Nebeinye Pilatus nebei yo Yesus herendere a kaenewatene ninae be hineumiboke. ");
INSERT INTO set_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nebei Barabas kawane hebele kiyae, yo kelai yan kelaise neungeboke kiyae riyainye huluinye Pilatus hayeungekoke meukuke. Pilatus Yesusre nebei yo naei me einye ikeumi naei kena hului yae mokowainye. ");
INSERT INTO set_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nebei yo yae Yesus yawainyehoke nibi nolone Simon Kirenena ro yo eise menensindere mewole. Simonde ikilaiboke a elae haeinyekoke ukainyele Yesus ohali kaewekebe kaembonde. ");
INSERT INTO set_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ro miyae nekai sele Yesus na moisa hakainyekoke keteijeke. Miyae maengke nane merau hakainyekoke. Naei nolora hiwa Yesusre rime rimainyejeke. ");
INSERT INTO set_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Nebeibe Yesus euweke nebei yore weumi, “Yerusalem miyae maengke! Rare rimensemae. Mauwa, mai kelu omi rimebe rimemmi. ");
INSERT INTO set_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Naei yo bei yan bei ya mendene wa, mayae elembe, ‘Foi sele moi sele miyae kihore nekeyate yo, naei kou yahira kelu omi mbai ohonoi mo. Nane merau naei nime bune fa hi enareiboi mo.’ ");
INSERT INTO set_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nebei hee yae Ro miyae elure yoise ungaimile, ‘Kereiso maere oimeherawe!’ nane merau elure yoise ungaimile, ‘maere feleimekone!’ ” ");
INSERT INTO set_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Reyae o nehi wanen, rabuhine ban Reyae beko ban bako banne, mayae niyae o kala-kala wanen, beko bako nekai mokoyaubene. Reyae o nehi wanen Kiyaere beko mokaisene, emekai wanen mare o kala-kala wanen yore beko mokonayengkombe. ");
INSERT INTO set_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Buloo kelai fela kelai ro bee nane merau yawaimiboke Yesus nanembainye ohali bonaikondere. ");
INSERT INTO set_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ikate Ro Yun Bo Ma anuwau wae wainye ijenne Yesus ohaline baikoke. Nebei ro bee na meline meubene baikoke. ");
INSERT INTO set_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesus weumi, “Arai, ndi ro miyae naei beko mokate faeinyeumibonde, rabuhine ban naei me u mokate neyae isaeyeiboi sului.” Yesus nambelae nebei felayo yae oye nihaeiboke nenaeijae mo wahaeikoke. ");
INSERT INTO set_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nebeinye hebewate yo ijoko isane erewate. Yahudi yun-jun Yesusre aukaka kowainye, wainye, “Ro miyae hiware hole moloumiyekae lonbe, nda hee Allah yae na hele eleuboke ukete nda kani kelare Wali Ondofolore mekaena, Waei uware wenaei hole moloibo!” ");
INSERT INTO set_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Kayaare hebate felayo nebei hului mbai aukaka kainye. Anggur bu faere mobe ikainyele. ");
INSERT INTO set_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Wainye, “Na hele Weyae Yahudi naei Ondofolona, Wauwa hole moloibo!” ");
INSERT INTO set_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Na yun ran bumare bohire yae homo nda a yae molaikoke, ");
INSERT INTO set_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nebei ro bee meline meubene hebete hi yae Yesusre nane aukaka bae kounge, “Na hele Weyae Wali Ondofolona, mana nda hebandera wali yeimeko!” ");
INSERT INTO set_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nebeibe na hi kayee yae weunge, “Weyae Allahre fe efaei? Nda ehee bukulu na hului mbai relannele. ");
INSERT INTO set_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nebeibe meyae bee maei me u mokondekoke huluinye yarondekoke, nebeibe nda ro u mekai beko omokoyei.” ");
INSERT INTO set_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nebeisa Yesusre weunge, “Yesus, Waei yo waku Wenaei mele neubonde heene, raei u bene bele nekenayete.” ");
INSERT INTO set_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Nebeibe Yesus yae weunge, “Reyae na hele wawale, nda heene wangkele Rangkele wali yo hena yo einye ayembonde.” ");
INSERT INTO set_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nebei hee hu yaukanne hului, nebeibe ouben hauben yeuboke hebewoke oke huae rai hujoko namene. ");
INSERT INTO set_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Hu na nukui u yeuboke, Allahle imaene malo kaban heere folaikoke uke fo beere raweukoke. ");
INSERT INTO set_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesus kali na kaban don mae kaenele, “Arai! Raei unulu Waei me einye kinyawale!” Nebei are mo eleukoke bae, na no na hibi hokoukoke. ");
INSERT INTO set_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Felayo na yun kiyae, nenaei ijoko yae erewole, Allahre buma kolowounge, “Na hele! Nda ro na hele wali himaloungeboke.” ");
INSERT INTO set_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Isare erenatere hokoweke ro miyae bewate naeise ijoko yae erewatene, imaere obere ewate na kena eisa mehi yae ekaifolowate. ");
INSERT INTO set_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yesus na kahili wafeu bele miyae maengke Galileara hakainyekoke mewate yo bele na felanda mo hebaiboke erainyoke. ");
INSERT INTO set_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ro mbai na ro Yusuf Yudea kanina Arimatea yone honole. Naei wali himaloungeboke, na foi sele nekeweke. Nebei hee neyae Yahudi yoyo koseyo holona ro mbai. ");
INSERT INTO set_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Neyae nane merau Allah Naei yo waku mennembondere rakeungeke. Yahudi naei yoyo koseyo hebewolebe, nebeibe Yesusre honaibonde a ruke neyae be ehineiboi. ");
INSERT INTO set_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yusuf eke Pilatusre riyeungehike Yesus na nore roungatere. ");
INSERT INTO set_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nebeinye Yesus na nore ohali randa rubainyeboke roukate. Malo naei foi sele mokaiboke na ro lenan nebei here no rulaisike. Ruka buleinye ekate nekainyele. Nda ruka bulei manemfa hele waeibokate. Hi yae ha yae nebei anuwaunge here no mbai eneyei. ");
INSERT INTO set_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nebei ya maehae mbai nen, Sabat ya nobeungeboke. ");
INSERT INTO set_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nebei miyae maengke Galilea kanira Yesus nangkele mbainye mewate yo Yusufre hakainyekoke nebei bulei bele Yesus naendae yae ruka buleinye nekainyele belere eraikoke. ");
INSERT INTO set_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bukaiboke imaere ekate, Yesusle uwa rilenaibonde naeise bu fololo bele mokainyehake. Musale walora wali heere foloukoke a huluinye neyae Sabat yane no yaeiboke. ");
INSERT INTO set_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Minggu ya na rene kaukau fele nebei miyae maengke naei rambun-rambun mokainyehake bele yaraikoke ruka buleise ewate. ");
INSERT INTO set_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ruka buleise ekate nebei ruka kaban bulei romaufe ahaeikoke erewate olaeinyekoke. ");
INSERT INTO set_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Na hibi eise ayeuboke bae, Yesus na no erewate an. ");
INSERT INTO set_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nebeinye hebaiboke onei-onei onewate mo, ro bee nambelae wili yae bate na bokone meisebeuboke. ");
INSERT INTO set_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nebei miyae maengke fe hele yaroumikokene na be kanire bekate. Hebate wa, nda ro bee nebei yore a weimi, “Rahene mayae wali bele nekele ro herewate yo nolore yae baeyaunge? ");
INSERT INTO set_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Neyae oloo! Neyae ninae aunguke! Galilea kanine nekeweke hee nda a mare uwombe u bene nekenayembe, ");
INSERT INTO set_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Reyae wamale, Reyae, Allahle bokora mekale ro miyae uware yeubokale Kiyaere beko bakore mokoyate yo naei me einye kinyenaisebonde, ohaline bonaisekonde, nebeisa ya name mo arenunde.’ ” ");
INSERT INTO set_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Nebei miyae maengke Yesus nebei a ukeumire u bene nekaimihike. ");
INSERT INTO set_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Nebei miyae maengke ruka buleisa baeibokate mekate mo, Yesus na moisa orowate yo ro me bee oro nen mbai bele yore ruka buleinye bewate rambun nemene huwewaimi nane merau na moisa orowate yo hiware bele huwaimi. ");
INSERT INTO set_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nebei are huwaimi miyae maengke nda na ro niyae: Maria Magdalena, Yohana, Maria Yakobus nenake kiyae, nane merau miyae maengke hiwa yo Yesus na moisa orowate yo bele. ");
INSERT INTO set_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Na moisa orowate yo yae nebei miyae maengke a huwoumire na hele ban elewate. Naei waimi are a bulaen-bulaen mae elate. ");
INSERT INTO set_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Nebeibe Petrus hakauboke ruka buleise ewole. Eke, are niheufike, nebei bulei eise erewole, Yesus Nauware rulaisike malo mo nebeinye honowole. Petrus bukeufike ewole na kena eisa hubaunge an nda wanen yeubokere. ");
INSERT INTO set_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nebei ya mbai Yesus na moisa orowate ro bee Emaus yore ewote. Yerusalem yora Emaus yore nahau 10 km hului. ");
INSERT INTO set_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nda Yerusalemne rilewole iwaube hokolo bee na oro ranne mete huweimeyete. ");
INSERT INTO set_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Eleimeyete, huweimeyete na u benera koloimeyeinyele mo, Yesus meke hokolo beere meumibarauboke nanembaisa mewate. ");
INSERT INTO set_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Erabuhi yae mokoiboyaimi wanen, Yesusre erewoinyebe, nebeibe Nare ro oroiboi. ");
INSERT INTO set_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesus yae hineumi, “Rahe ahubabe nda nibi nolone mayae bee huweimeyeube?” Hokolo bee hebeiboke na be bele kabeikoke. ");
INSERT INTO set_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Hokolo bee metera ro hi kiyae na ro Kleopas beufoke Yesusre weunge, “Wembai kolo ro era, nda Yerusalem yo einye manemfana bewate rambunde isaeyeiboi?” ");
INSERT INTO set_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesus yae hineumi, “Rahe rambun?” Hokolo bee yae weinye, “Nebei Nasaret yona ro Yesus. Neyae Allahle yendo kayaalo mbai. Naei a faeu bele Naei me u bele walora Allah na hele ukeunge meke naeise yakaungeboke nane merau ro miyae isaeyaeiboke Neyae Allahlera. ");
INSERT INTO set_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Imam yun-jun bele maei Yahudi yun-jun mae Nare honaibonde naeise Ondofolo Pilatusle me einye kinyainyeboke. Felayo yae Nare ohaline baikokate! ");
INSERT INTO set_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Maei rabo halewande hului Neyae mende maei Israel yoni-yoni Romawi naei me kelee u keleera bulaeremmele. Nebei ya yeubokera meke ya namebe yeuboke. ");
INSERT INTO set_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nane merau miyae maengke hiwa maei nolora mekate maere mokaimeboke kulu-kulu hele yaendeboke. Na rene kaukau fele ruka buleise ekate, ");
INSERT INTO set_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","nebeibe Yesus Na here no ehubayeikoi. Mekate elate, ‘Meyae ekande, malaikat mo erekammile. Nebei malaikat yae waime Yesus waleuboke.’ ");
INSERT INTO set_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Maeisa hiwa yo nane merau ruka buleise ekate, mekate elate miyae maengke a na helebe elate. Meyae mbaibe ekande, Yesusre ereiboi.” ");
INSERT INTO set_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nebeinye Yesus yae nebei beere weumi, “Mayae na kobu hele! Allahle yenjo kayaayo homone molaikoke are mayae na hele elengkombere kena wauwau kaube. ");
INSERT INTO set_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Wali Ondofolo Allah are kolowounge hului beko helen hubannekonde helera Allah yae one hengko yae kitenengkonde.” ");
INSERT INTO set_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nebeisa Naei uwa naei abe Allahle homofaene nemene molowate yakawoumi, Musale homofaera huba raweuboke meke Allahle yenjo kayaayo molaikoke homofae nemene. ");
INSERT INTO set_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Emaus yo nobewainye yae, Yesus na hibi endere uwa haraungeboke. ");
INSERT INTO set_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nebeibe hokolo bee heraweinyeboke weinye, “Be bahele ya na heki ban mo ouben yembondere, ninae lon maengkele ndane honoma.” Nebeinye Yesus eweufike nebeinye hononatere. ");
INSERT INTO set_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nanembainye nuwaikoke ramande anenatere yae, feu rouke, Naekore helen foise mo ukeunge, na hibi kayeukoke hokolo beere waheumiboke. ");
INSERT INTO set_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nebei heera hokolo bee na ijoko keleumikoke, Yesusre ro roinyeboke. Nebeibe Yesus hokolo bee naei nolora nundeuboke. ");
INSERT INTO set_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Naeise naeise hi yae hire weunge, “Ra kena roweufehike hele, Allahle homofaene a honate yakaimeyeumene!” ");
INSERT INTO set_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Na hibi hokolo bee ainyukete bukeiboke Yerusalem yore ewote. Nebeinye na moisa orowate ro me bee oro nen mbai bele ro miyae hiwa yo bele arileufike nekewate. ");
INSERT INTO set_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Nebeinye nekate yo yae hokolo beere waimi, “Tuhan nana hesele waleuboke! Simonde Na uwa yakaungeboke.” ");
INSERT INTO set_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nebeisa hokolo bee nibine ekete hubayaeikoke a huwoimi nane merau Yesus feunge kaiwole heene ro roinyeboke. ");
INSERT INTO set_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nebei bewate ahubane nare huwate mo, Yesus meke na nolone yakaiboi yae yakauboke weumi, “Onomi foka hubanne!” ");
INSERT INTO set_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nebei yo enaelo yae elewatene fe yae waku yae yaroumikoke. ");
INSERT INTO set_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nebeibe Yesus yae weumi, “Rahene fe faeube, rahene mai hila rabo elae ban yaeiboke? ");
INSERT INTO set_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Raei me bele oro bele ijoko eren. Nda Reyae hele ya! Me foi yae Raei uwa ramense ijoko foi yae erense, enaelo naei melen bo Raeinya eraufele wanen ban.” ");
INSERT INTO set_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","A huwoumira na me bele oro bele na hibi kelewoumi erewate. ");
INSERT INTO set_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Rei nekai kowatebe, nebeibe ijoko kelei-kelei mo kelewatene namman Neyae na hele waleuboke a eleikoi. Yesus yae hineumi, “Mai nolona raman ban mo mekaube?” ");
INSERT INTO set_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ka bohi inye beubokere mo roukate ikainyele. ");
INSERT INTO set_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yesus nebei ka ikainyelere mo, nebei yo naei bene hebeunguke anewole. ");
INSERT INTO set_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Yesus weumi, “Rangkele mbainye orowande heene nda abe uwamale, Musale homofae moloukoke bele Allahle yenjo kayaayo hiwa molaikoke bele Mazmurne moloukoke bele nebei a nemene hului Raei naei molowate na hele benate bangka mo.” ");
INSERT INTO set_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nebeisa Yesus elae ikeumi Allahle homofaene a na mekai harainyebokere na hului isaeinyaibonde. ");
INSERT INTO set_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Yesus yae weumi, “Allahle homofaene molaikoke hului Wali Ondofolo mende, beko hubanengkonde, herendera ya name mo walembonde. ");
INSERT INTO set_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Nda kani kela nemene forilengkonde Yerusalem yora bere huba raungaibonde nda a Wali Ondofolole Ro randa hungaimile, ‘Ro miyae nde na beko bakora nulu kennebondena, Allah naei beko bakora faeinyemmibonde.’ ");
INSERT INTO set_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mayae nemene mai ijoko yae erewaube rambun mai angkaei yae borowaube rambun yoni-yoni huwemembe. ");
INSERT INTO set_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Allah are heteungekoke huluinye Reyae mare Naeinya Roh isembere. Nebeibe mayae nda yone namman nekembe mende Allah Naei elae wake bele ketenembombe.” ");
INSERT INTO set_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yesus yaweumiboke nebei yo eisa maibaleke ekate Betania yone, Na mere mo raneuweke nebei yore onomi yae ei hawewoumi. ");
INSERT INTO set_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Namman nare onomi ei hawewoumi yae, na hibi kaeuboke surgare ewole. ");
INSERT INTO set_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nebei yo Nare ei molowainye, nebeisa uwa roweumihike yae Yerusalemde bukaiboke ewate. ");
INSERT INTO set_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Allahre ei mom-mom imae na kaban sele kiyaene nekayeke, na hibi-hibi Allahre buma kolainyeke.");
INSERT INTO set_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Nda homofae Yesus Wali Ondofolole naeise. Neyae nda kani kela beme fome hele Allahle nanembainye nekewote. Neyae Allah Naei uwa mbai nane merau Allah Naei a elele Kiyae yae kaenainye. ");
INSERT INTO set_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Na beme fome hele rambun yoni-yoni hengkelen erasi hee Neyae Allahle nanembainye nekewote. ");
INSERT INTO set_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Allah yae ukeunge huluinye Yesus Wali Ondofolo Nembai yae rambun nanemene mokoukoke, elae hi rambun mbai sambaise omokoiboi sele. ");
INSERT INTO set_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Wali Ondofolole einya nekele nebei wali no niyae. Hehe ouben haubenne naeumile yae ro miyae na foi mokonatere erenaimile. Nebei sului mbai Wali Ondofolo wali nibi kelewoumi yae ro miyae wali foi nekenatere isaeiwaimi. ");
INSERT INTO set_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Allahre onaeinye ro miyae ouben hauben nolone wanen orate. Hehe ouben haubende naeumile wanen mae ro miyae nolone Wali Ondofolo Naei wali nibi a kelewoumi. Nebei are walobo yoni-yoni hun eraisi sului. ");
INSERT INTO set_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Allah yae ro mbai ukeunge meke, na ro Yohanes. ");
INSERT INTO set_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Neyae burelende bonde robe meke. Ro miyae nemene Wali Ondofolore hila rabo halenate naeise Yohanes yae nda a huwoumi, “Wali Ondofolo mende, hehere naemmile Kiyaere yembonde, rabuhine ban Naei wali nibi a kelemmile.” ");
INSERT INTO set_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohanes bae nebei hehere naemmilere Kiyae ban, nebeibe Naei a moi neisi kiyaere yeuboke. ");
INSERT INTO set_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yesus hehere naemmilere kaenewainye Kiyae. Neyae hehe naeumile wanen Naei wali nibire ro miyae nemene kelemmilere. ");
INSERT INTO set_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nebei hehere naemmilere kaenewainye Kiyae nda kani kelane nekewole yae nda kani kela Neyae mokouboke hororebe, Neyae meke hee nda kani kelana ro miyae Nare onewainye. ");
INSERT INTO set_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Naei ro miyae bokore mekebe, nebeibe Naei ro miyae yae Nare ei aiboi. ");
INSERT INTO set_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nebeibe ro miyae nanemene eise hauwainyele yo, Naei Rore hila rabo halewainyele yo, Allahle kelu omire inyaibondere nibi mokouboke. ");
INSERT INTO set_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nebei ro miyae melen u ha u yae ohonoi nane merau ro bele miyae bele kena huluinye ban, naei sele naei kena u Allahlera honoukoke. ");
INSERT INTO set_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yesus, Allah Naei a elele Kiyae, ro miyae uware yeuboke, aei u nolo u kainye nekewole. Ako bele Kelu nene waewae eyae ijokore eranneboke Kiyae. Naei Ako Allahle bokora meke, ro miyaere kena buhae u buhae aere ban mae heumi, Naei na hele wali nibire keleumi. ");
INSERT INTO set_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohanes yae Yesusle abe ro miyae helende a kaban mae isaeiwoumi wa kaenewoumi, “Nda Kiyae naeise na bere nda a haraungebokale uwamale, ‘Raei moisa mende Kiyae, nda Niyae. Neyae ro bele enainyeronde, reyaebe ro ban. Rabuhine ban rare nda kani kelane ohonoi mo, nebei Kiyae bere meke nekewole.’ ” ");
INSERT INTO set_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Neyae ro miyaere kena buhae u buhae aere ban mae heumene, no ban hee ban aere foi mokoume. ");
INSERT INTO set_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Allah yae Naei yendo kayaalo Musale walora wali heere foloukoke abe ikeume. Nebeibe Allah yae Yesus Wali Ondofolole walora aere kena buhae aere ban mae heume nane merau Naei na hele wali nibire keleume. ");
INSERT INTO set_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ro miyae hi yae ha yae Allahre roko mbai ereiboi mo. Nebeibe Allahle Kelu mbai Naekole u mekai mbainye ekeinyekete Kiyae yae Allahlena abe aere yakaumeboke. ");
INSERT INTO set_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Naei uwa naei are hinenainyehindere, Yerusalemna Yahudi ro miyae yae imam yoni-yoni bele Lewi yohona orona mena yo hiwa bele ukaimile Yohanesle bokore enatere. Neyae Yohanesre wainye, “Weyae naeinya hesele nde?” ");
INSERT INTO set_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nebei mekai hinainyehikene Yohanes na yaka lon mae weumi, “Reyae Wali Ondofolo ban ma.” ");
INSERT INTO set_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Neyae benen hinainye, “Nebei wanenna, weyae nde? Allahle yendo kayaalo Elia era?” Nebeibe Yohanes yae weumi, “Niyae ban.” Nebei yo yae benende hinainye, “Weyae Allahle yendo kayaalo kaban mendere meyae rakanne kiyae era?” Nebeibe Yohanes yae weumi, “Niyae ban.” ");
INSERT INTO set_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nebei yo yae wainye, “Weyae naeinya hesele nde? Ukaimele yore bemabonde emamiwenderene, waei uwa naeise nde yae emalengkonde?” ");
INSERT INTO set_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohanes nauwa naeise Allahle yendo kayaalo Yesaya homone moloukoke a hului yae weumi, “Ro mbai a kala-kalara burelen eke bole, ‘Tuhanbe nibi hiyei ranembo!’ ” Reyae nebei kiyaere yeubokale. ");
INSERT INTO set_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ukaimi ekate yo nolona hiwa Farisi holona yo. ");
INSERT INTO set_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Nebei yo yae Yohanesre hinainye, “Weyae Wali Ondofolo ban, Allahle yendo kayaalo Elia ban, nane merau Allahle yendo kayaalo meyae rakanne kiyae ban donbe, ndele ro yae weyae bu kamae?” ");
INSERT INTO set_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohanes yae weumi, “Reyae bu yae kamaele. Mai nolone ro mbai hebele, mayae Nare onaeunge. ");
INSERT INTO set_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nebei Kiyae Niyae raei moisa mende. Naei oro mehau ha niheisi kulaiboise reyae na hului ban. Nare ro rowainye, nebeinye Naei bene reyae ro ban sele.” ");
INSERT INTO set_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nebei me u mokowole nemene Betania yo honole Yordan wi enaa reufi Yohanes bure kowoumi anuwaunge bewate. ");
INSERT INTO set_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ya heuboke mo, Yohanes erele Yesus naei bokore mele. Nebeinye hebate yore Yohanes yae weumi, “Erenne, ndi Kiyae Niyae Allahle Domba Kelu. Nda kani kelana ro miyae naei beko bakore faeinyeiboi naeise nda Kiyae mele naei wali yae kinyembondere. ");
INSERT INTO set_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Reyae nebei Kiyaele abe na bere nda wanen mae haraungebokale isaeiwamale, ‘Raei moisa mende Kiyae nda Niyae. Neyae ro bele ronainyele, nebeibe reyaebe ro ban. Rabuhine ban reyae nda kani kelane ohonoi mo, nebei Kiyae meke nekewole.’ ");
INSERT INTO set_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Reyae nane merau na bere oneungekokale nebei Kiyae nde. Nebeibe Neyae Israel ro miyae nolone uware yakammibonde naeise reyae bere holo bu yae koremilere mekale.” ");
INSERT INTO set_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yohanes Yesusle naeise nda wanen mae a isaeiwoumi weumi, “Reyae ereubokale Allahle Roh aye merpati wanen mae yakura oke, Naei uwa ranne oufebeunguke hebele. ");
INSERT INTO set_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Reyae isaeyeiboi nebei Kiyae nde. Nebeibe rare bu yae koremilere ukeufe Kiyae nda wanen mae ukeufe, ‘Weyae erele Allahle Roh onde ro mbai uwa ranne onsebenunde Kiyae, nebei Ro weyae bure kamae wanen mae ro miyaere Allahle Roh yae kommile.’ ” ");
INSERT INTO set_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yohanes yae eleukoke, “Nebei Role uwa ranne yeuboke iwau raei ijoko yae erewalene nda a yae isaeyaemale, nebei Kiyae Allahle Kelu Niyae.” ");
INSERT INTO set_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ya heuboke mo, Yohanes nebei anuwau mbainye na moisa orowate ro bee bele hebewate. ");
INSERT INTO set_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Erewounge, Yesus na bera mewole mo, weumi, “Erenne, ndi Niyae Allah Naei Domba Kelu Kiyae!” ");
INSERT INTO set_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Yohanes na moisa orowote ro bee nebei wanen a boroketene, na hibi Yesusle moisa hakoinyekoke. ");
INSERT INTO set_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesus ereumi hokolo bee na moisa hakoinyekoke metene, euweke mo hineumi, “Mayae rahebe baeimeyeube?” Hokolo bee yae weinye, “Rabi (na mekai, Guru), Weyae makeinye nekeyae?” ");
INSERT INTO set_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesus yae weumi, “Mebu, menaeijae meberebo.” Hokolo bee Yesusre hakoinyekoke nekewole anuwaufe ekate, nebei ya koko nanembainye nekayoke. Huae rai hukai keli hului yeuboke. ");
INSERT INTO set_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yohanes eleukoke are boroibokene Yesusre na moisa hakoinyekoke hi na ro Andreas, Simon Petrus naka baeke. ");
INSERT INTO set_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andreas na hibi naka baeke Simonde nda are wennelere baeungekoke, hubayeikokete mo weunge, “Aka baeke, meyae Wali Ondofolobe hubayaendekoke, Allah yae oro umaufe heraweungeboke Kiyae!” (Na ro Ibrani afaeunge Mesias, Yunani afaeunge Kristus.) ");
INSERT INTO set_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andreas yae Simon Petrusre yaweungehoke Yesusle bokore ekete. Yesus Simonde ereungekoke wa weunge, “Weyae Simon, Yohanesle kelu, mana yara ware Kefas yae ro ronayewete” (Kefas Aram afaeunge nanembai Petrus Yunani afaeunge bele. Kefas bele Petrus bele na mekai ruka). ");
INSERT INTO set_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ya heuboke mo, Yesus Galilea kanira kulun wende endere a eleukoke. Nebei hee yae Yesus oro molouboke bele Filipusbe hubayeikoke. Yesus yae Filipusre weunge, “Raei moisa hakoibo.” ");
INSERT INTO set_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Nebei Filipus Batsaida yona ro, nane merau Andreasle Petrusle naei yo mbai. ");
INSERT INTO set_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Nebeisa Filipus eke Natanielre hubayeikokete mo weunge, “Na bere Musa Allah a ukeunge wali heere foloukoke homone moloukoke. Musa bele Allahle yenjo kayaayo bele Wali Ondofolo naeise homone moloukoke. Nda hee meyae Nare andehubayeukoke. Neyae Yesus, Nazaret yona Yusufle kelu.” ");
INSERT INTO set_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniel yae Filipusre hineunge, “Nazaret yora foi naei kayeero na hului mende?” Filipus yae weunge, “Mei ba, wenaei ijoko yae meinyereibo.” ");
INSERT INTO set_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nataniel nahaufa melere Yesus erekeunge, Natanielle abe elele, “Erenne, Allah mere baele Israel yohona hele mele, ame-ame ban kiyae.” ");
INSERT INTO set_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniel yae Yesusre weunge, “Weyae naendae mekai yae raei u mekai ma roufebokae?” Yesus yae weunge, “Filipus ware ekaeneikoi hee, Reyae na bere erekawale weyae ara no keleene nekeyae.” ");
INSERT INTO set_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniel yae weunge, “Guru, Weyae Allahle Kelu, Israel kanina ro miyae naei Ondofolo.” ");
INSERT INTO set_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesus yae weunge, “Reyae na bere ara no keleene weyae nekeyae erekawale a eleukokale aerene Rare hila rabo halaerae. Weyae iwau emere-emere emekai bele nda yakaubokalera mokorelebe weyae ewerende.” ");
INSERT INTO set_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Benen Yesus yae weunge, “Nana heselebe wawale, Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae. Wa ijoko yae ewerende yaku wewe kongkonde Allahle malaikat yoni-yoni Raei bokore onate inyate konayende.” ");
INSERT INTO set_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ya bee nekaikoke mo, Kana yo Galilea kanine ro miyaere yeiboke eraman bulau mokaibokene Yesus nenake nebeinye nangkele. ");
INSERT INTO set_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesus na moisa orowate yo bele nebei eraman bulau mokaibokere riyaimihike ekate. ");
INSERT INTO set_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Anggur bu anewatebe baeufokene, nenake meke Yesusre weunge, “Kelu, nda yo anggur bube baeumihoke.” ");
INSERT INTO set_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesus yae weunge, “Ana, Raei uware yakarebonde ya namman donbe. Nebeise mokorebondere rahene Rare warae!” ");
INSERT INTO set_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nebeibe Yesus nenake yae nebei raman bulaunge kalia mokowate yore weumi, “Naei are ungembe huluinye nendon mokombombe.” ");
INSERT INTO set_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Rukara mokaikoke hele kaban mehinen mbai nebeinye honate, neinye bu 100 literre rileikoyate hului. Nebei hele Yahudi naei era hena hului orore mere kuinyate naei. ");
INSERT INTO set_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesus nebei raman bulaunge kaliare mokowate yore weumi, “Nebei helene bu rilengko!” Nebei yo bu rilaikoke, hele na mehinen mbainye maemae kaikoke. ");
INSERT INTO set_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Nebeisa Yesus nebei yore weumi, “Eraman bulaufe be neiboi kiyaere ebi ken rengkombe yennele hubansinde.” Nebei yo raeikoke ekate ikainyele. ");
INSERT INTO set_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Bu hosoro anggurre yeuboke hubaufike bae, ma hi wanen hubaunge (neyae isian nda yeubokere, nebei kaliare mokowate yo yae mo naeisaei). Nebeinye eraman bulaufe mokouboke ro na molore kaeneungekoke meke wa, ");
INSERT INTO set_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","weunge, “Honoyele huluinye anggur yu bele kayeero yae bere waheikoyaimi. Nebeinya ro miyae helen anenaisindene yun yambi-yambi konatera wa hungkae-hungkae wahaeimi erabe. Nebeibe weyae ayeufakae honowole nda hee yae wa yu bele kayeero na moisa wahaemae.” ");
INSERT INTO set_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Galilea kanine Kana yone Yesus rambun emere-emere mokowole nolora, nda niyae naei bere hele. Nda iwau wae naei nene waewae yakauboke nane merau Naei moisa orowate yo Nare hila rabo halewate. ");
INSERT INTO set_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nebei raman bulau baeufokera Yesus kulun uke Kapernaum yore nenake yae, nauwake wa yae nane merau na moisa orate yo bele nanembaisa ewate. Kapernaum yone ya name hului nekaikoke. ");
INSERT INTO set_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","((Mesir kanine Allah yae Yahudi naei bena kelu fa-fare hole moloumiboke hee u bene nekeisi-nekeisi naeise Yahudi ro miyae mokoiboyate)) ya kaban Paskah nobeungekokene Yesus oro molouboke Yerusalem yore ewole. ");
INSERT INTO set_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Yerusalemna Allahre ei mom-mom imae na kaban sele kiyaene hili era akau erare ongkoufe felenaibonde naei obo yoku sapi, domba, aye merpati naise hewate yo bele Yahudi naei roi yae yo meiko-meiko yo naei roise bulewate yo bele Yesus hubayaeikoke. ");
INSERT INTO set_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yesus bonde heraeyemmile naei erahuae ha yae mokouboke. Nebeisa Neyae obo yoku naise hewate yo heraewoumi, roise ei buke mei buke baete anuwau na roi bele feleisayeunge kani ranne here ware weiboyole. Nda yo bele obo yoku bele nanemene Allahle ei mom-mom imae na kaban sele kiyae houfa hukeumi baleyate. ");
INSERT INTO set_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Aye merpati naise hewate yore Yesus weumi, “Nda anuwaufa mai rambun nanemene yarongko! Maekore eise molainye imae mayae rambun nai hei-sei anuwaufe omokoijae hele!” ");
INSERT INTO set_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nebei mekai bewatene, na moisa orowate yo Allahle homofaene molaikoke abe bene nekeumihike. Nebei a nda wanen molaikoke, “Allah, Waei ei mom-mom imae kena kaban sele kale, na hibi-hibi u benene nekenaisele.” ");
INSERT INTO set_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yahudi yun-jun a elae yae Yesusre wainye, “Weyae nebei me u mokoubonde kiyae wanen naise hewate yore heraeyeumihikaere maere iwau wanen keleumebonde naeise rambun emere-emere mokoibo eremabon!” ");
INSERT INTO set_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesus yae weumi, “Allahre ei mom-mom imae nda hebele kalambo. Reyae ya name mo nda hebele ma na hului arennunde.” ");
INSERT INTO set_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Nebeibe Yahudi ro miyae yae wainye, “Ralo yakama rorele u bee mehine mbai bele (46) Allahre ei mom-mom imae na kaban sele kiyae ro miyae ainyunuke. Weyae ya name lon mae benen aungunundere?” ");
INSERT INTO set_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nebeibe Yesus Na uwa naeibe Allahre ei mom-mom imae yae ahuneuboke Yahudi ro miyaere uwoumi. ");
INSERT INTO set_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Mainyekeukoke Yesus nulu yo mahe yora aunguke hee yae wa na moisa orowate yo Allahre ei mom-mom imaere Yesus naei uwane ahuneuboke eleukokebe bene nekeumihike, nane merau Allahle homofae na a belere Yesus uwoumi a belere hila rabo halewate. ");
INSERT INTO set_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Paskah ya kaban kowate hee Yesus namman Yerusalem yone nekewole. Rambun emere-emere mokowole erewainyene, ro miyae helen na hele yae elewate nda Kiyae Niyae Wali Ondofolo. ");
INSERT INTO set_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Nebeibe Yesus yae bae nebei ro miyae naei a elatere rabore ehalei sului, rabuhine ban ro helen miyae helen naei u mekai ame-amere roumibokene. ");
INSERT INTO set_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ro miyae naei u mekai mbemba mbemba Yesusre ehuweikoisebe, nebeibe ro miyae naei u mekai Yesus naeisaei. Rabuhine ban nebei ro miyae naei kena ei bele Yesus ninae isaeyeubokene. ");
INSERT INTO set_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Yahudi naei yoyo koseyo holona ro mbai Farisi holone hakouboke na ro Nikodemus. ");
INSERT INTO set_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ya mbai be baheuboke yae Yesusle bokore meke mo weunge, “Guru, meyae maeisaei Weyae Allah yae ukete ro miyaere isaeise keleumilere mekae Kiyae, rabuhine ban Allah Ware ei haweitene nebei rambun emere-emere Weyae mokoyae. Nebei me u ma ro miyae hi yae omokoiboi sului.” ");
INSERT INTO set_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesus yae weunge, “Reyae na helebe wawale, ro miyae nde maenin wayeu fa honate wanen benen Allahlera ohonoinya, nebei kiyae Raei me kelee u keleena nekate wali foi moi ehubaikoi sului.” ");
INSERT INTO set_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemus yae weunge, “Naendae mekai yae rorele yembonde lonbe honnate? Benen honnatere nebei kiyae na hului ban nenakele kou ei yahi einye enensinde.” ");
INSERT INTO set_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesus yae weunge, “Reyae na helebe wawale, ((nulu keumiboke ro miyae na kena u ma hi hele inyaibonde. Nebei yo Allahle Roh weumi are hakainye, naei bekore kena haehae katere ehakoiboi. Naei kena ure benen eme honokate wanen inyaibonde.)) Nebei wanen bewate ro miyaere bu konaimile. Nulu ekeiboi nane merau Allahle Roh aiboi ro miyae Raei me kelee u keleene nekate ro miyae holone eyeisi sului. ");
INSERT INTO set_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ro miyaera honowate yo ro miyae u mekai yae koyate. Allahle Rohra honowate yo Allahle Roh u mekai yae koyate. ");
INSERT INTO set_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Reyae wawale, weyae benen Allahlera hononete hele a wawale aerene fa oboijae. ");
INSERT INTO set_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Allahle Roh alu wanen raweiboyolena boye naei kena hului eyewole wanen. Eyae na kulun eiborowannele, nebeibe eyae isian makeisa mele nane merau makeise endere. Nebei sului mbai Allahle Roh yae Naei kelu omi na kena u einye mokoumile.” ");
INSERT INTO set_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemus yae weunge, “Nebei a ma haraungebokae eleukokae naendae mekai yembonde?” ");
INSERT INTO set_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesus yae weunge, “Weyae Israel ro miyaere isaei hebaende kelaeumi holona ro na hi niyae. Nebeibe nebei a wawalere isian a lon mae warae! ");
INSERT INTO set_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Na helebe nda a wawale, Meyae maeisaeise nekande abe wayembe nane merau meyae ijoko yae erekande abe isaeyaeyembe. Nebeibe maei a isaeimambere mayae ro miyae na helere eleikoi kaube. ");
INSERT INTO set_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nda kani kelana ro miyae nolone baete rambun abe mare huwamalebe mayae na helere eleikoi kaube. Naendae mekai yae mare surga naei rambun are ufembene mayae na hele elengkombe? ");
INSERT INTO set_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ro miyae hi yae ha yae roko mbai surgare ei mo. Reyae, Allahle bokora mekale ro miyae uware yeubokale Kiyae, mo surgane eweufikale. ");
INSERT INTO set_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Na bere Allahle yendo kayaalo Musa yae a kala-kalane rami yae akewate ro miyae hole molommibondere rami tembagara mokaibokebe one neungejeke. Nebei sului mbai Reyae, Allahle bokora mekale ro miyae uware yeubokale Kiyae, bumane nenaisijende hele. ");
INSERT INTO set_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ro miyae nanemene Rare hila rabo halenaisele yo wali hena bona enaiyaronde naeise Reyae bumane nenaisijende. ");
INSERT INTO set_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Allah yae nda kani kelana ro miyaere kena buhae u buhae kaban hewoumi aerene Reyae Na Kelu mbai ken sele kinyeumiboke. Nde maenin mae Raei a elalere hila rabo halensele kiyae Allah bele ewaheikoi nebeibe wali hena bona endowende naeise, Reyae hererelere Allah ukeufe mekale. ");
INSERT INTO set_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ro miyaere me noremiyonde naeise ban, nebeibe naeinya hesele nda kani kelana ro miyae holere moloremibonde naeise, Allah na Kelu Reyae nda kani kelare ukeufe mekale. ");
INSERT INTO set_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nde yae Raei a elalere hila rabo halenselena, me onoyoi nekenate. Nebeibe nde yae hila rabo Raei a elalere ehaleinya, Allah yae me nokounge. Rabuhine ban nebei ro miyae Reyae Allahle Kelu mbai kende hila rabo ehaleinye. ");
INSERT INTO set_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","“Nda u mekai aerene ro miyae ehee bukulu emminoyonde: Allahle wali hena wali nibi ako faeuko hehere naemmile wanen nda kani kelare meke. Nebeibe ro miyae nebei ako faeuko ahi, nebeibe ouben hauben nolone wanen nekenatere kena kowate, rabuhine ban me u beko mokowatene. ");
INSERT INTO set_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Wali beko bako mokoyate ro miyae Allahle wali hena wali nibire ikele kainye. Nebei wali nibi Reyae kelaemaelere ahi hele, rabuhine ban hehe naeikoyele wanen naei me u mokate naei mare yakammibonde belene. ");
INSERT INTO set_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nebeibe nde na helere mo baete ro miyae Raei kelaemaele wali nibire hakoyainye. Nebei nibi yae hehe ouben hauben nolone naemmile wanen mae naei me u Allahle walora mokatere na yaka yakanaimile.” ");
INSERT INTO set_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nebeisa Yesus na moisa orowate yo bele Yerusalem yora kulun ukate Yudea kanire ewate. Ya heki ban Yudea kanine nanembainye nekewate, ro miyaere bu kowoumi. ");
INSERT INTO set_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Salim yo kelaeunga anuwau mbai na ro Ainon. Nebei ijenne Yohanes bure koumi kiyae ro miyaere bu kowoumi, rabuhine ban bu helenne nane merau ro miyae helen nebei anuwaufe bure kommilere hokoumekene. ");
INSERT INTO set_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Nebei hee Yohanes namman kawa einye eiseikoi. ");
INSERT INTO set_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yohanes na moisa orowate yo bele Yahudi ro mbai bele Yahudi naei era hena bu kui-kui naei a kenane kilewate. ");
INSERT INTO set_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nebei yo ekate Yohanesre wainye, “Guru, aengkele nanembainye hebewande Ro naei weyae are isaeiwamae Kiyae, nda hee Yordan wi bonei ndi reufine nebei Ro bu ekekoumi. Naei bokore ro miyae nemene fomene hokoyele.” ");
INSERT INTO set_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohanes yae weumi, “Ro miyae naei angken nuwei Allah wennele hului mo nuwenate. ");
INSERT INTO set_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Reyae isaeiwamale a boraukoke mo, ‘Reyae Wali Ondofolo ban, nebeibe rare ukeufele Neyae menderene bere holo yae mekale.’ ” ");
INSERT INTO set_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Yohanes nda a wanen mae ahuneuboke, “Miyae neme weiboyainye nebei rore weiboyainye kiyaele miyae. Nebei ro naei kahili wafeu na bokone ayeufake hebele ro, nane ro neme miyae neme wainyeboke rei kole a boroukokene kena foi sele hubaunge. Nebei sului mbai reyae hubanale. Nda hee nebei Ro neme mekene Raei kena rei mai yae eufemeleke. ");
INSERT INTO set_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Nebei Kiyae bereise erenainyele, rare moise yae bulenaisende.” ");
INSERT INTO set_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yohanes namman huwele, “Neyae surgara meke ro miyaene, nde maenin horo, hi yae ha yae Nare ehameikoi. Reyae nda kani kelara nulaisebokene raei isaei hebaen nda kani kelana rambun-rambun naei mo raeisaei. ");
INSERT INTO set_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yesus surgara meke Kiyae naei ijoko yae erewole naei angkaei yae borowole abe isaeyeumibe, nebeibe ro miyae keli name hele Neyae elele are hila rabo halaete. ");
INSERT INTO set_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Yesus isaeyeumi are hila rabo halaete yo na hele yae elate Allah na hele a mo weume. ");
INSERT INTO set_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Allah ndare ukeunge meke Kiyae Allahlena ako faeuko mo weumile, rabuhine ban Allahle Roh na hibi-hibi nebei Kiyaere elae yae kiteyeunge. ");
INSERT INTO set_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ako Allah na Kelure kena buhae heunge, nane merau Ako Naei me einye u einye rambun yoni-yoni na Kelu me eise kinyewounge hakewounge. ");
INSERT INTO set_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Allahle Kelu Naei a elelere hila rabo halende ro miyae wali hena bona hubayeunge. Nebeibe ro miyae nde Allahle Kelure moi bulennele wali hena bona eyereiboi. Nebei ro miyae Allah na hibi-hibi ehee bukulu hubayeunge.” ");
INSERT INTO set_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farisi holona borowate, ro miyae helen sele Yesusre hakowainye nane merau bu kowoumi. Ro miyae name keli mo Yohanesre hakowainye. ");
INSERT INTO set_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Naeinya hesele Yesus Nenaeijae ro miyaere bu okoi, na moisa orowate yo yae kowaimi. ");
INSERT INTO set_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Farisi holona nda a borokate Yesus isaeyeubokene, Yudea kani nukeungeboke beufoke Galilea kanire ewole. ");
INSERT INTO set_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Naei ende nibi Samaria kanira hele nensande fondere. ");
INSERT INTO set_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Samaria kanina yo mbai Sikarre eke. Nebei yo kelaeunge nendahina Yahudi ro miyae naei yobe kaban Yakob yae kani ebi na kelu Yusufre kinyeungeboke. ");
INSERT INTO set_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Nebeinye Yakuble rotebu (bu hele) yale. Nibi a ahau mewolene Yesus nauwa yambi koloukeungene nore yengkondere rotebu kelaunge eunuweuboke. Nebei hee hu yaukanne hului. ");
INSERT INTO set_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Nebeinye nekele yae Samariana miyae mbai bu reikoise meke. Yesus yae weunge, “Rare bu yeise anerehin.” ");
INSERT INTO set_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Yesus nembai nekele, na moisa orowate yo raman yarokoise yo eise ekate. ");
INSERT INTO set_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nebeibe nda Samaria miyae yae weunge, “Ae, na ijen ban sele weyae Yahudi ro reyae Samariana miyae lonbe bure aneufindere mekaeriyarae?” (Rabuhine ban Yahudi ro miyae yae Samaria ro miyaere ele moinya yae me baeyaimine.) ");
INSERT INTO set_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesus yae weunge, “Allah yae ro miyaere aere ban mae foi yeyeumi nane merau Reyae ware bu andehindere riyawale Kiyae Allah yae ukeufe mekale. Nebei a isaeyeubokaena, weyae Rare wali bele bu riyeufehinde, ware walire yeumi bu isete.” ");
INSERT INTO set_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Nebei miyae yae weunge, “Tuhan, nda rotebu wauwau, Weyae bure rekonde mongkon u lonbe. Makeisa nebei walire yeumi bu rowele? ");
INSERT INTO set_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Naendae wanen waei u benera nekayete Weyae kaban sele maei yobe Yakoblera? Rotebu mo kinyeumeboke, neyae, naei kelu omi, naei obo yoku, naei orona mena bele aneimeyande.” ");
INSERT INTO set_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesus yae weunge, “Nde yae nda bu anensinde benen buki ennehubande, ");
INSERT INTO set_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","nebeibe Reyae isende bu anensinde Kiyae bukire ehubasi nekenende. Reyae isende bu yae anensindera nauwa einye bu no wanen yembonde, na hibi-hibi rilennende, wali hena bona hubannende.” ");
INSERT INTO set_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nda miyae yae Yesusre weunge, “Tuhan, bukibe korele belene, nebei bu yeise, bure nda anuwaunge benen ereyei.” ");
INSERT INTO set_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesus yae weunge, “Eye, wa molo kaeneungekonde ndare mebe.” ");
INSERT INTO set_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nda miyae yae weunge, “Reyae ro ban molo ban ma.” Yesus yae benende weunge, “Na helebe eleyae, Weyae na hele ro ban molo ban. ");
INSERT INTO set_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Weyae ro maehae mbai nekaukoke, nda haeinya waei bele nekeube nebei waei ro molo ban. Nebei wanenne nda a elalene weyae na helebe eleukokae.” ");
INSERT INTO set_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nda miyae yae weunge, “Tuhan, mana na yaka hele reyae hubanale, na hele Weyae yendo kayaalo na hi niyae. ");
INSERT INTO set_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Maei yobe naei kamahe naei nekayeke nda mokone Allahre ei molainyeke, nebeibe mayae Yahudi ro miyae yae elaube Yerusalem yo mbai nebei anuwaunge mo eyae Allahre eise molomanele hele.” ");
INSERT INTO set_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesus yae weunge, “Rare hila rabo haleise! Na ya bele hu bele mende, mayae Ako Allahre nda mokone ei molonnele ban nane merau Yerusalem yone ban. ");
INSERT INTO set_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mayae Samaria ro miyae nendon rore oroiboi Allahbe ei molaunge. Meyae Yahudi ro miyae eise molannele Allah meyae rore rannele Kiyae, rabuhine ban Yahudi naei nolora aere hole molommele Kiyae mekene. ");
INSERT INTO set_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","24","Nebeibe Allah roh ma yae nekele, ro miyae kena u einye a elele borole. Nda hee Allah yae Naei na hele a ro miyae kena u einye yakayeumi. Allahre ei molonainyelere ro miyae Naei kena u einye ei molonainyele hele nane merau Neyae keleumi na hele wali nibi a hului nekenate. Nebei u mekai ma ro miyaere Allah baele.” ");
INSERT INTO set_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nda miyae yae Yesusre weunge, “Reyae raeisaei nekale Allah yae oro umaufe heraweungeboke ro Wali Ondofolo Kiyae mendere. Neyae mende heena nemene fomene ninae aere yakammekonde.” (Na ro Ibrani afaeunge Mesias.) ");
INSERT INTO set_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesus yae weunge, “Nane Kiyae mbai Reyae Niyae, wangkele are faeufe eleyonde mbai Niyae.” ");
INSERT INTO set_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nebei hee yae Yesus na moisa orowate yo baeiboke mekate. Yesus miyae mbai bele ane elete erainyene fa yae bate. Naei kena une nda a hinewainye, “Rahere baeyae? Rahe abe eleubere?” nebeibe a ewei mo hebate. ");
INSERT INTO set_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nebei miyae na habure mo nebei anuwaunge raufike, nebeisa yore habeleweke, ro miyaere weumi, ");
INSERT INTO set_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Aka naei baeke naei memerembo, ndina ro mbai Neyae Wali Ondofolo era. Raei u mekai wa mekai kowekale nanemene hele yakaufekoke.” ");
INSERT INTO set_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nebei yona ro miyae aibaleke Yesusle bokore ewate. ");
INSERT INTO set_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nebei miyae ewole mon na moisa orowate yo yae Yesusre uwainye, “Guru, eraman aneiko ba.” ");
INSERT INTO set_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nebeibe Yesus yae weumi, “Raei eraman honaisele, nebei naeise mayae maisaei ban.” ");
INSERT INTO set_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Na moisa orowate yo hi yae hire hineunge, “Naendae wanen, Neyae anengkonde eraman ro miyae roukate mekatene era?” ");
INSERT INTO set_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesus yae weumi, “Reyae andekonde eraman nda niyae: Allah Rare ukeufe mekale Naei kenare kole hului mokorekonde nane merau Rare kinyeufeboke kalia riyau ufembonde. ");
INSERT INTO set_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","((Yesus Naei kalia mokowole bele era bolu hekene moloisayate ani hokoikoyate bele ahuneungeboke.)) Mayae nda a mekai eyelewaubebe ya, ‘Benen oko keli nekemakonde anire hokomale ya mensembonde.’ Nebeibe Reyae mare wamale, enere faise ijoko eren! Nda kani kelane ro miyae heke yoni-yoni fae yangko-yangko wanen yaeiboke. Fae yangko-yangko yoni-yoni mokainyehake hokonatere yaeiboke wanen mbai ro miyae mokainyehake Raei a elalere boronate hila rabo halenate. ");
INSERT INTO set_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Nda hee anire maluwate yo na roibu yarate. Naei hokate rambun wali hena bonare enaiyaronde ro miyae. Nebei mekai yaere Allahle wali nibi kelaeimi ro miyae nemene rei mai konate. Neyae bolure molate yo bele anire maluwate yo bele wanen yaeiboke. ");
INSERT INTO set_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nebei mekai yaere nda a na hele yembonde, ‘Hi yae molonde hi yae maluwembonde.’ ");
INSERT INTO set_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Reyae ukamale mayae omoloikoi anuwaungare ensokombere. Ro miyae hiwa aimoloukoke, mayae ekaube nebei yo yae bolu molaikoke na anibe ensokombe.” ");
INSERT INTO set_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nebei Samaria kanina miyae yae elewole, “Raei u mekai wa mekai mokowale Yesus nanemene weufekoke.” Neyae a isaeiwoumine Samaria yona ro miyae helen Yesusre na hele Wali Ondofolo yae elewate. ");
INSERT INTO set_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Samaria ro miyae Yesusle bokore mekate mo Nare moi hurewainye nebei yo bokone nekendere. Nebeinye ya bee hele Yesus nebei yo bele nekaikoke. ");
INSERT INTO set_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Benen ro miyae helen sele Yesus elewole are boraikokene Nare hila rabo halewainye. ");
INSERT INTO set_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Nebei yona ro miyae nda maengkere wainye, “Meyae hila rabo halaenne weyae uwamae a aerene mo ban. Rabuhine ban menaeijae Naei euwara elewole a borandekokene nane merau maeisaei Neyae nana hesele nda kani kela hole moloiboi naei Ro.” ");
INSERT INTO set_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ya bee Sikar yone nekeukokera mo, Yesus Naei Galilea kanire ewole. ");
INSERT INTO set_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Yesus naei euwara Nenaeijae eleukoke, “Yendo kayaalo mbai na yone yanne foi yae ei ehawei, nebeinye ro miyae nare be ehinei.”) ");
INSERT INTO set_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nebei hee Galilea kanire eke bae, nebeinya ro miyae na kena u foi moi sele ei hauwainye. Paskah ya kaban Yerusalem yone ekate nenaei Yesus na me u mokowolere ijoko yae erewainye. ");
INSERT INTO set_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Nebeisa benen Yesus bukeufike Galilea kanina Kana yore honolere meke, bere bu hosoro ukeunge anggur bure yeuboke ijende. Kapernaum yona ro mbai Ondofolo Herodesle kaliare mokowole ro na kelu erane kowole. ");
INSERT INTO set_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Neyae borouboke Yesus Yudea kanira Galilea kanire mekene bae, eke Yesusre riwounge Kapernaum yore mende na fa era hereinyen-hereinyen kowole onomire inyendere. ");
INSERT INTO set_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesus nda rore weunge, “Mayae rambun emere-emere ijoko ereiboinye Reyae Wali Ondofolo yeubokalere mayae hila rabo ehalei sului.” ");
INSERT INTO set_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ondofolo Herodesle kaliare mokole ro yae weunge, “Tuhan, u hale yae mele raei fa neherei yae.” ");
INSERT INTO set_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesus yae weunge, “Eye! Wa fa ninae onomi rouke.” Nda ro Yesusle ane faeunge hakouboke na hibi ewole. ");
INSERT INTO set_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nibi nolone nare ewole mo na yebaei bubaei be huhu baikoke. Mekate wainye, “Wa fa ninae onomi rouke.” ");
INSERT INTO set_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nebeinye nda yore hineumi, “Makei haei yae uwa naume hireungeboke?” Nda yo yae wainye, “Wena rai hujoko mbainye u naume hireungeboke.” ");
INSERT INTO set_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Naeko na u bene meungenekeufike na hele nebei haei yae Yesus a ukeunge, “Wa fa onomi rouke.” Nebeinye na miyae fa-fa na imae ei obe einya yo bele nemene Yesusre hila rabo halewainye. ");
INSERT INTO set_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yudea kanira Yesus bukeufike Galilea kanine meke heera Neyae rambun emere-emere mokowolera roko bee nendo mokouboke. ");
INSERT INTO set_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Mainyekeukoke mo, Yahudi naei ya kaban na raman bulau belene, Galilea kanira Yesus kulun uke Yerusalem yore ewole. ");
INSERT INTO set_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yerusalem yore yanainyekoke ele dombare yawaimi ate romau kelaeunge bukou mbai yale, Ibrani afaeunge Betesda yae wainye. Nebeinye baengko bele norofa maehae mbai yan mae haeikoke. ");
INSERT INTO set_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Nebei anuwaunge ro miyae nekai sele era buloona yo, ijoko kumba yo, oro rebeisi-rebeisi yo, oro mere nimewaimile yo bele honate. ");
INSERT INTO set_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Rabuhine ban roko mbemba Allahle malaikat oyowole nebei bukou na bu neunge kuba eyakowole. Nde yae bere oro molombonde enensinde kiyae era buloo naendae wanen horore, na hului onomi rowende. ");
INSERT INTO set_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nebei anuwaunge ro mbai ralo yakama 38 hele era buloo koweke. ");
INSERT INTO set_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesus nebei ro honowolere erewounge hee, nebei u mekai mo yae heki hele honowekere isaeyeubokene nda rore Yesus yae hineunge, “Weyae onomi rowelere kena koyae?” ");
INSERT INTO set_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nebei ro yae weunge, “Tuhan, ndana ro miyae bu eyakowole heene rare rowensele nda bukou eise hansebonde naeise u. Renaeijae nebei bure nakeleyale hee hiwa yo moi woyaisele bena eyakoikoyate.” ");
INSERT INTO set_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesus yae weunge, “Ainyu wa kewa yumake yaroiko aloinyoko eye.” ");
INSERT INTO set_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nebei hee yae nda ro onomi rouke, na kewa yumakere mo yaroukoke aloungekoke ewole. Nda rambun Sabat ya yeuboke. ");
INSERT INTO set_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nebeinye Yahudi ro miyae yae onomire rouke rore wainye, “Mana Sabat ya. Aei Yahudi naei wali heere foloukoke homo huluinye Sabat yane kewa yumake ekaeiboi ei sului.” ");
INSERT INTO set_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nebeibe nda ro yae weumi, “Rare onomire ikeufe Ro yae a ukeufe hului ra kewa yumake yarokokale male.” ");
INSERT INTO set_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nda yo yae hinainye, “Ro nde ware ukete hului wa kewa yumakere yaroukokae aloungekokae meyae?” ");
INSERT INTO set_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nebeibe onomire rouke ro isian nde yae onomi ikeunge, rabuhine ban Yesus Nauwa ro helen miyae helen nolone euyaneukokene. ");
INSERT INTO set_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Nebeisa Allahre ei mom-mom imaene Yesus onomire ikeunge ro bele hubayeikoke mo Yesus yae weunge, “Waei uwa na hubaungehike ma na beko hele kayeerobe enaiyembonde bele era, nda hee weyae onomi roukae benen me u beko omokoyeijae.” ");
INSERT INTO set_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nebei ro isaeyeuboke Yesus yae onomi ikeunge. Nebeinye eke Yahudi ro miyae hinewainyelere Yesusle ro yakaumiboke. ");
INSERT INTO set_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Sabat ya yae nda rore Yesus onomi ikeunge aerene, Yahudi ro miyae Yesusle naeise a beko eleiko huweiko kowate. ");
INSERT INTO set_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Nebeibe nda yore Yesus yae weumi, “Maeko Allah foi naei rambun na yane baei mokoyele. Reyae nebei sului mbaibe mokale.” ");
INSERT INTO set_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yesus nebei a ukeumine, Yahudi yun-jun elae hele relewainye honaibonde nibine baewate. Nda aerene Yesusre honaibondere: Yahudi naei era henane Sabat yane omokoi kiyaebe Yesus moi woke mokouboke nane merau Allahre Yesus Naei Ako yae elele walora Allah Naei uwa mbai yae elele. ");
INSERT INTO set_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Nebeinye Yesus nda yore weumi, “Reyae na helebe wamale, Reyae Allahle Kelu. Nebeinye Raei kena hului yae rambun hire omokoi sului. Maeko yae mokole rambunde Reyae erale Kiyae mokorele, rabuhine ban Maeko yae mokole rambun Reyae mokale. ");
INSERT INTO set_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Maeko Reyae Naei Kelune buhae heufe. Naei rambun mokole nemene Rare keleyeufe. Nda rore onomi ikanalera benen rambun emere-emere emekai bele Maeko yae kelensebonde. Reyae nebei rambun eremokondene fa yae embombe. ");
INSERT INTO set_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Maeko yae ro miyae herewate yore ainyainyu kowoumi wali inyemile ma mbai Reyae kena korele ro miyaere wali isemile. ");
INSERT INTO set_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nane merau ro miyae walire Maeko yae hului okoloi. Nebeibe walire hului kolommile naeise nanemene Reyae na Kelu Niyae kinyewoufe hakewoufe. ");
INSERT INTO set_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Nebei aerene ro miyae nanemene Maekore be hinenainyele yo, nebei sului mbai Reyae Na Kelure be hinenaisele. Nde yae Reyae Na Kelure be ehineinya, nebei kiyae Ako Allah ndare ukeufe mekale Kiyaere be ehinei. ");
INSERT INTO set_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Reyae nana heselebe wamale, nde yae Raei a elale borombonde nane merau Rare ukeufe mekale Kiyaele a elelere hila rabo halendena, wali hena bona rowende, walire hului okoloi. Nebei ro miyae Allah bele waheikoke wali ma wekeunge, Reyae Wali Ondofolo yae kelaemaele wali nibine orole. ");
INSERT INTO set_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Reyae Allahle Kelu. Nana hesele Allah bele waheikoke ro miyae Raei ako faeuko enaiboronde, nane merau Raei ako faeukore hakonate yo wali neme bele hubanayende, ");
INSERT INTO set_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","rabuhine ban Maeko wali none. Nebei sului mbai Reyae Na Kelu mokoufeboke wali nore yeubokale. ");
INSERT INTO set_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Reyae Allahle bokora mekale ro miyae uware yeubokale aerene ro miyae naei wali hului koloremile naei elae Allah yae Rare kinyewoufe hakewoufe. ");
INSERT INTO set_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Enaibende naei a yakamalene, mayae fa oboijae hele. Rabuhine ban na ya bele mensembonde herewate buleinye honate ro miyae nanemene Raei a boronate, ");
INSERT INTO set_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","nebeisa a bulura menaibalende. Ro miyae u mekai foise mokayeke holona wali hena bonare emmiyende naeise amminunde. Nebeibe ro miyae u mekai bekore mokayeke holona me emminoyonde naeise amminunde. ");
INSERT INTO set_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Raei kena hului yae rambun mbai sambai omokoi sului. Maeko yae wensele huluinye ro miyae naei wali hului kolamaele. Nane merau na ijen sele Reyae wali hului kolamaele, rabuhine ban Raei kenare korele huluinye ehakoi. Maeko Rare ukeufe mekale Kiyaele kena konde huluinye mokorele. ");
INSERT INTO set_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Raei uwa naei a Renaeijae isaeisemilena, ro miyae hiwa nebei a elalere elae ban elenate. ");
INSERT INTO set_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nebeibe ro hi yae Raei uwa naeise isaeyaeyembe. Nebei kiyae yae isaeyembe a Reyae raeisaei nana hesele. ");
INSERT INTO set_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Raei uwa naei are isaeyembomberene mayae hiwa yore ukaumile Yohanes bu koumi kiyaele bokore ekate. Yohanes Raei naei a na hele isaeiwoumile. ");
INSERT INTO set_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Raei naeise ro miyae uwa walora isaeinyaimile elae ban ma. Nebeibe mai wali hole molonembombe naeise Yohanes a elewolere Reyae wamale, rabuhine ban naei a boraube. ");
INSERT INTO set_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohanesle ako faeuko isehe naeikoyole wanen mare naengkokembe. Nebeibe mayae na mon mbai ken nebei hehe naeukoke yae rei mai kenare mo molombokembera eweufike. ");
INSERT INTO set_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Raei uwa naei a faeu isaeyaemale na bereise Yohanes yae isaeiwombe a faeufa. Maeko yae Rare ukeufe kaliare namman mokale. Nebei me u yae mo keleyembe, na hele Maeko surgana Rare ukeufe mekale. ");
INSERT INTO set_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nane merau Ako Allah Rare ukeufe mekale Kiyae Raei uwa naei a Neyae isaeyembokembe, nebeibe mayae roko mbai Naei euwara a faeu na hibi yae oboroi, Naei be yoi ijoko ereiboi. ");
INSERT INTO set_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Nane merau Maekole euwara elele a faeu mai kena ei u einye ohonoi, rabuhine ban Ako Allah Rare ukeufe mekalebe, nebeibe Raei a elalere mayae hila rabo ehalei. ");
INSERT INTO set_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Allahle homofae mayae uwa niheisiyaunge yae isaei-isaei isaeyaeube. Mai u benera nekayembe, nebei homofae walora wali hena bona yarombe. Nebeibe Allahle homofaena a faeu hamaunge Raei uwa naei abe mare isaeimeyayembe. ");
INSERT INTO set_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Nebeibe mayae nebei wali hena bona yarombe naeise Raei me kelee u keleene nekembere ahi hele elaube. ");
INSERT INTO set_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Raei foi naeise nde maenin mae elenate naei Reyae ebaei. ");
INSERT INTO set_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nebeibe mai uwa naeise Reyae rombokamale. Mai kena ei u einye mayae Allahre kena buhae ehei. ");
INSERT INTO set_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Maekole Ro yae Reyae mekale, nebeibe mayae Rare ei ehawei. Nebeibe ro hi miyae hi naei ro yae mele kiyaere mayae ei haweyaumi. ");
INSERT INTO set_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mayae Rare hila rabo ehalei sului, rabuhine ban ro miyae mai uware kaenayembe naeise baeyaube nebeibe Allah Hubalo Mando uwa kaenembe naeise ebaeyei. ");
INSERT INTO set_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Ako Allahle kendan wameran bene mai u mekai beko aerene Reyae mare a ohoroi, Musa yae a horonnengkombe. Mayae u bene nekayembe naei a moloukokere hubara haeisa yanaunge walora wali hole molonembombe. ");
INSERT INTO set_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Musale are na hele yae elaukoube yae Raei a elalere na hele yae elaube. Rabuhine ban Musa Raei uwa naei a moloukoke. ");
INSERT INTO set_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Raei uwa naeise Musa yae moloukoke homona are na hele yae eleikoinye, rahe ma lon mae Reyae wamale are hila rabo ensalembe?” ");
INSERT INTO set_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Nekaikoke mo, Yesus kulun uke Galilea bukoba habala reufire foke. (Galilea bukoba nane merau Tiberias bukoba yae elate.) ");
INSERT INTO set_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ro miyae helen Yesusle moisa hakainyekoke, rabuhine ban nenaei ijoko yae erewate erana buloona yore onomi iwoumi. ");
INSERT INTO set_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Elu hinongkane Yesus ike, na moisa orowate yo bele nebeinye raiboke nekewate. ");
INSERT INTO set_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Nebei hee Yahudi naei Paskah ya kaban nobeuboke. ");
INSERT INTO set_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesus ijoko erele bae ro miyae helen Nare baeimeyainye yo Naei bokore matene, Filipusre weunge, “Ro miyae nanemene anenaikonde naei makeinya roi yae feu yaromakonde?” ");
INSERT INTO set_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Nda a mekai bae Filipusre umalibe hubannehindere hineungehike. Mokombonde naei Yesus naeisaei sele. ");
INSERT INTO set_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipus yae weunge, “Roi 200 dinar yae yarandekoube feu hului nda ro miyae hokoimeyelere na hului ban, naendae mekai horo nanemene anenaikonde naeise feu ebimbin mae wahaemmile.” ");
INSERT INTO set_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Na moisa orowate ro hi na ro Andreas, Simon Petrus naka baeke yae Yesusre weunge, ");
INSERT INTO set_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ndana fa mbai na feu maehae mbai ka bee bele honainyebe, era buhire eyeiboi sele nda ro helen miyae helende?” ");
INSERT INTO set_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Nebei anuwau ke bele. Yesus yae weumi, “Nebei ro miyae wemmi ke ranne angken mae nuwaiko.” Ro yoni-yoni mo me baeikoke nemene 5.000 hului. ");
INSERT INTO set_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesus nebei feu bele ka bele yaroukoke helen foise mo Allahre ukeunge, kaiwole, na moisa orowate yore iwoumi, neyae nda ro miyae helende wahewaimi. Nanemene anaikoke uwa raeiboke. ");
INSERT INTO set_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nanemene uwa raeibokera na moisa orowate yore weumi, “Nendon hainyate belene eraman kalun bohi-bohi honate arilensi.” ");
INSERT INTO set_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Feu maehae mbaisa nda ro miyae anaikokera kalun arilaikoke kakali me bee oro nen bee bele hawaikoke maemae kaikoke. ");
INSERT INTO set_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nebei ro miyae rambun emere-emere mokouboke erewatene elate, “Nana hesele nda Kiyae Niyae Allahle yendo kayaalo nda kani kelare mendere elewate Kiyae.” ");
INSERT INTO set_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ro miyae helen Yesusre Ondofolore ranenaijende merau kolowainyelebe Yesus isaeyeubokene, na u mbai aloungekoke elure ewole. ");
INSERT INTO set_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Rakewainye be baheubokene Yesus na moisa orowate yo bu haeise mekate, ");
INSERT INTO set_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","kaisa hawaiboke, Kapernaum yore fonatere. Reniai yeubokebe nebeibe Yesus nda yo naei bokore emei mo. ");
INSERT INTO set_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Alu elaekei selene ruwae kaban-kaban hele haiwole. ");
INSERT INTO set_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Naisike awaijeke 5-6 km hului erate bae, Yesusbe bu randa oro yae mewole naei bokore nobeimeyeungebe erekainye. Nda yo fe waku hele yaroumikoke kowate. ");
INSERT INTO set_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Nebeibe Yesus yae weumi, “Fe efaei yae, nda Reyae ya!” ");
INSERT INTO set_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Na kena rei mai aumiboke Yesus kai einye menefilengkondere riyainye hee nane merau nebei hee yae ewate anuwaunge na kai eubarauboke. ");
INSERT INTO set_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ya heuboke yae ro miyae nekai bu habala reufine nukaimiboke yo wena erewate nebei anuwaunge kai mbai sele yawole. Nebei kai Yesus Nangkele ban mae na moisa orowate yo naisikere naeisaei nekewate. ");
INSERT INTO set_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Yesus feufe helen foi eleukokera ikeumi anaikoke ijenne Tiberias yora nekate kai hiwa nebeinye yawate. ");
INSERT INTO set_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nebeinye ro helen miyae helen erewate, erabae Yesus nane merau na moisa orowate yo bele baeimikoke une, kai yawatera hauwate, kulun ukate, Yesusle baeikoise Kapernaum yore fowate. ");
INSERT INTO set_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ro miyae helen Yesusre baewainye yo bukoba reufine Yesus faisubayeikoke hee, nda yo yae hinainye, “Guru, makei hee yae weyae nda anuwaufe mekae?” ");
INSERT INTO set_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesus yae weumi, “Reyae na helebe wamale, mai mekai ma Rare baeimeyaufe bae Reyae rambun emere-emere mokalere isaeyaeuboke aerene ban, naeinya hesele mayae feu anaukoke uwa raeuboke aerene. ");
INSERT INTO set_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Eraman kakare rowele naei kalia omokoijae hele. Raman kakare eyeiboi hononende wali hena bona endowembe kaliabe mokombe. Nebei raman, Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae yae mare isembe. Ako Allah Rare kena koufe kelemmile naeise me nou heraufeboke.” ");
INSERT INTO set_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nda yo yae Yesusre hinainye, “Allah weumile rahe u mekai yae meyae haramambonde mokomambonde hele?” ");
INSERT INTO set_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesus yae weumi, “Allah wembe u mekai harannebombe nda niyae, Reyae Allah yae ukeufe mekale Kiyae yae elale are hila rabo halensembe.” ");
INSERT INTO set_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nebei yo yae wainye, “Allah ukete mekaere hila rabo halemayetere kena koyaena, rahe rambun emere-emere mokoubondere meyae ijoko eremabonde? Weyae rahebe mokoubonde? ");
INSERT INTO set_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Na bere maebu naei maeko naei a kala-kala anuwau mewatere raman manna elewate yae anaimeke. Allahle homofae einye nda wanen molaikoke, ‘Nebei yore surgana raman mae Neyae iwoumi anewate.’ ” ");
INSERT INTO set_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesus yae weumi, “Musa yae ban, naeinya hesele Maeko Allah yae nebei feu abu naei arai naeise ikeumi. Nda hee Maeko yae raman walire inyembe Kiyaebe surgara mare wahembe. ");
INSERT INTO set_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Rabuhine ban Allah yae Rare ukeufe surgara mekale. Nda kani kelana ro miyaere Reyae walire isemile naeise Allahle ramande yeubokale Kiyae.” ");
INSERT INTO set_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nebeinye Yesusre wainye, “Arai, walire yemmele raman kiyaebe maere na hibi-hibi yeumende.” ");
INSERT INTO set_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesus yae weumi, “Walire inyemile raman Reyae Niyaebe ya. Nde naei Raei me kelee u keleene nekate nane merau Raei a elalere hila rabo halaeisele benen na kena u moni buki ehubasi mo huba ban haei ban nekenayende. ");
INSERT INTO set_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nebeibe Reyae mare ukamale ma hului Rare eraufe hororebe, nebeibe Rare hila rabo ehalei kaube. ");
INSERT INTO set_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Maeko yae kinyeufeboke ro miyae nanemene Raei me kelee u keleene orulenate. Reyae nebei yore ehukei eibe eremihawende. ");
INSERT INTO set_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Rabuhine ban Raei kenare korele hului yae mokorelere ban, nebeibe Rare ukeufe mekale Kiyaele kena konde hului yae mokorelere naeise Reyae surgara okale. ");
INSERT INTO set_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Rare ukeufe mekale Kiyae Naei kenare kole nda niyae, ro miyae nanemene Rare kinyewoufe holona mbai sambai ewaeisi einyundei, nebeibe huba mokoikoi yane Reyae areminunde wali hena bona enaiyaronde. ");
INSERT INTO set_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nda niyae Maeko kenare kole ma: ro miyae nanemene Raei are nou henate Raei a elalere hila rabo halenaisele yore wali hena bona isemile nane merau nebei holonare huba mokoi yane Reyae areminunde.” ");
INSERT INTO set_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yesus yae eleukoke, “Reyae surgara okale wali bele raman Niyae.” Nebei aerene Yahudi ro miyae a mulun-mulun elewate huwate. ");
INSERT INTO set_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nebei Yahudi ro miyae yae elate, “Nebei kiyae Yesus Yusufle kelube ya, nenakele naekole aeisaei. Naendae mekainye elele, ‘Reyae surgara mewale’?” ");
INSERT INTO set_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesus yae weumi, “Maise naeise a mulun-mulun eleijae! ");
INSERT INTO set_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Rare ukeufe mekale Ako Allah mokoumile ro miyae kena konate Raei me kelee u keleene orulenate, hi yae ha yae naei kenare kole huluinye oruleisi. Nde orulensinde kiyae huba mokoikoi yane Reyae arennunde. ");
INSERT INTO set_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Allahle yenjo kayaayo naei homone molaikoke, ‘Nebei yo nanemene Allah yae emmikelende.’ Maeko yae keleumi are boronate isaeinyate ro miyae Raei me kelee u keleene orulenate. ");
INSERT INTO set_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Reyae Maeko ukeufe mekale Kiyae mo Maekore ereungebokale, hi yae ha yae Nare ijoko yae ereiboi. ");
INSERT INTO set_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Reyae nana heselebe wamale, Raei a elalere hila rabo halaete ro miyae wali hena bona bele nekenaimile. ");
INSERT INTO set_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Raei uwa walire inyembe raman Niyae. ");
INSERT INTO set_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mai abu naei arai naei a kala-kala anuwau mewatere Allah yae surgara raman manna iwoumi yae anewate hororebe nanemene maisereuboke. ");
INSERT INTO set_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Raman aneikoyate wali elaere yeyeumi wanen mbai Reyae surgara okale wali hena bona isemilere. Raman mae anengkondena wali nekende wanen mbai ro miyae Raei a elalera hila rabo halenate wali hena bona yaronate. ");
INSERT INTO set_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Reyae walire inyembe raman surgara okale. Wali inyembe ramande anende kiyae wali hena bona nekenende. Walire isembe raman Raei uwa melen niyae. Nda kani kelana ro miyae wali hole moloiboise Raei uwa kinyerembonde.” ");
INSERT INTO set_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nebei a mekai Yahudi ro miyae borokatene nenaei mo aku hate wa elate, “A koro mahi lon, naendae mekai yae naei uwa melen eyae anemakonde naeise emmekinyembonde?” ");
INSERT INTO set_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","((Yesus mekai haraungeboke Neyae weume are uwa melen bele ha bele yae ahuneuboke kelewoumi. Naei merau haraungeboke ro miyae raman bu anenate wanen mae, Naei a elendere ro miyae naei kena einye isaeinyate.)) Yesus nda ma yae kelewoumi, “Reyae na helebe wamale, Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae. Raei uwa melen aneikoinya, Raei ha aneisinya, nebei wali hena bona ban ehubaikoi sului. ");
INSERT INTO set_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ro miyae Raei uwa melen bele ha bele anele kiyae wali hena bona hubannende, nane merau huba mokoikoi yane Reyae arennunde. ");
INSERT INTO set_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Rabuhine ban Raei uwa melen raman hele nane merau Raei ha bu helere yeuboke. ");
INSERT INTO set_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nde yae Raei uwa melende bele hare bele anele kiyae Raei einye nekele nane merau Reyae naei einye nekale. ");
INSERT INTO set_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ako wali no Kiyae Rare ukeufe mekale, Naei walora Reyae wali nekale. Nebei sului mbai Raei a elalere hakoyate ro miyae uwa melende anate hare felayaete wanen Raei walora wali nekate. ");
INSERT INTO set_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Walire inyembe raman surgara oke kiyae niyae nebei mekai ma. Abu naei arai naei manna yae anewate, nanemene heraikoke. Nebeibe nde yae nane walire yemmile raman mae anengkondena, wali hena bona endowende.” ");
INSERT INTO set_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Kapernaum yona Allahre ei mom-mom imaene Yesus yae nebei a nanemene kelewoumi. ");
INSERT INTO set_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yesus na moisa orowate yo nebei a mekai boraikokera helen nda a mekai yae elate, “Nda a faeu keleume elaekei sele. Nde yae na hului angkaei alensinde boronde?” ");
INSERT INTO set_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesus na moisa orowate yo nebei a eleukoke naeise na kenara a mulun-mulun elatebe Yesus isaeyeubokene weumi, “Nebei a eleukokale mai hila rabo halaeubere kusembe? ");
INSERT INTO set_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Reyae, Allahle bokora mekale ro miyae uware yeubokale Kiyae, mekale anuwaufe benen berehonde erelene mayae erensele naendae mekai yae u bene nekenayembe? ");
INSERT INTO set_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Allahle Roh yae walire yeyeumi. Uwa melen na hele rabuhi ban yaeiboke. Allahle Roh yae Raei eleukokale a walora mare huwembe, wali hena bona inyembe. ");
INSERT INTO set_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nebeibe mai holona hiwa yo nda a elalere na helere eleikoi.” Rabuhine ban Yesus na bemere isaeyeuboke nde naei Nare hila rabo ehalei yo bele nde yae kelai nenende kiyae bele. ");
INSERT INTO set_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nebeisa Yesus benen weumi, “Hiwa yo hila rabo ehalei aerene nda a yae haraungebokale uwamale, Maeko yae ro miyae kena une omokoiboinya, hi yae ha yae Raei me kelee u keleene oruleiboi sului.” ");
INSERT INTO set_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nebei heera Yesus na moisa orowate yo helen nukainyeboke, Yesus na moisa hakonainyekonde oronayendere ahi yae elewate. ");
INSERT INTO set_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nebeisa Yesus na moisa orayeke yo me bee oro nen bee belere ereumi wa weumi, “Mai kena une nda yo nukaiseboke ate wanen embere?” ");
INSERT INTO set_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Petrus yae weunge, “Tuhan, ndere hakomanelere wamae? Waei a faeu wali hena bona bele kiyaebe wamae. ");
INSERT INTO set_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Weyae wamae a hila rabo halewande nane merau isaeyaendeboke Weyae mbaibe Allahle u mekai wanen Kiyae, Allahlera mekae.” ");
INSERT INTO set_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Na moisa orowate yore Yesus weumi, “Reyae mare me bee oro nen bee belere elengkokamale ya! Nebeibe mai nolora mbai ken na kena une walobo yae nekele.” ");
INSERT INTO set_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Simon Iskariotle kelu Yudasbe Yesus a haraungeboke weumi. Rabuhine ban naendae mekai horo Yudas na ro hi Yesus na moisa orowate me bee oro nen bee bele holonabe, nebeibe neyae Yesusre kelai nenende emmikinyembonde kiyae.) ");
INSERT INTO set_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nebeisa Yesus aloungekoke Galilea kanina yo ran yo rande oroweke. Yudea kanire mehauwae ei, rabuhine ban nebeinye Yahudi ro miyae Yesusre honaibondere nibi baewatene. ");
INSERT INTO set_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nebei hee Yahudi ro miyae naebu naei naeko naei Kanaan kanire mewate kulunna ofae hafae yae rebekan mokowate bene nekei-nekeisi mokate ya kaban nobeungekoke. ");
INSERT INTO set_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yesus nauwake wa yae wainye, “Aka, Waei moisa orate yo rambun emere-emere eumokonde erenayete naeise ndara kulun wele, Yudea kanire yae eye! ");
INSERT INTO set_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Rabuhine ban ro miyae bene rore ronainyebondere baende kiyae na me u yae mokole rambun nunne omokoi. Nebei rambun emere-emere na hele mokoyaena, nda kani kelana ro miyae bene mokoiko!” ");
INSERT INTO set_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Rabuhine ban nauwake wa hele hororebe, Yesus Wali Ondofolore yeubokene weumi are hila rabo ehalei. ");
INSERT INTO set_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nebeinye Yesus yae weumi, “Reyae Yerusalem yore erele ya namman. Nebeibe mai naeise embe hee na rokone baei mon belene na hului embe. ");
INSERT INTO set_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nda kani kelana wali beko nibine orate yo mare ikele okoi. Nebeibe Rare na ikele hele kaise, rabuhine ban naei me u na beko mo mokate a isaeyaemaelene. ");
INSERT INTO set_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mayae kena kaubena, nebei ya kaban eraman bulau Yerusalem yona mokonaibondere emene. Reyae namman nebei yore ei sului, rabuhine ban Raei ya na hului eyeiboinye.” ");
INSERT INTO set_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nebei a hului ukeumira Yesus namman Galilea kanine nekewole. ");
INSERT INTO set_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nebeibe Yesus nauwake wa kulun ukate nebei ya kabanna raman bulaufe ewate moisa Yesus aloungekoke na maleu-maleu ewole. ");
INSERT INTO set_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nebei ya kaban raman bulaufe hokowole hee Yahudi ro miyae nebei anuwaunge Yesusre baewainyele wa elate, “Aeinya kiyae baenne, makeinya eke ban?” ");
INSERT INTO set_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ro miyae hokowole yo Yesusle a a maehae-maehae elewate huwate. Hiwa yo yae elewate, “Neyae ro u mekai foi,” hiwa yo yae elewate, “Neyae ro miyaere ame-ame beumi.” ");
INSERT INTO set_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nebeibe ro miyae Yesusle are a yaka eleikoi, rabuhine ban Yahudi yun-junde buhae yae hokowoumine. ");
INSERT INTO set_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nebei ya kaban raman bulau hengkelen raisike kowate hee Yesus eke Allahre ei mom-mom imae na kaban sele kiyae na imaehounge eweufike, nebeinye a usaei wasaei kelewoumi. ");
INSERT INTO set_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yahudi ro miyae fa bate wa elate, “Nda ro naendae mekai yae isaei hebaende isaeyaete anuwaunge isaeyeikoibe isaei yae eungemeleke?” ");
INSERT INTO set_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesus yae weumi, “Raei uwa na a usaei wasaeibe kelaemale ban. Nebeibe Allah, Rare ukeufe mekale Kiyaelena abe kelaemale. ");
INSERT INTO set_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ro miyae nde Allah kenare kole mare hakonate isaeinyaibonde nda kelaemaele a usaei Allahlera, Raeisa ban. ");
INSERT INTO set_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nde yae naei uwa naei are mo elendena, nebei ro ei molonainyele naei robe baele. Nebeibe nde yae ukeunge meke kiyaele ro foise baendena nebei ro na ijen sele nane merau ame-amere ebei ro. ");
INSERT INTO set_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Allah wali heere foloukoke are Musale walora mare yengkokembe ya? Mai u benene Musa ro bele kiyae. Nebeibe mai nolona ro mbai sambai Musalena ane ehakoiboi. Rahene mayae honsebombere baeufe?” ");
INSERT INTO set_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nebei ro miyae helen mae wainye, “Ware alobe aubokete koyae! Nde yae Ware honoibotere baete?” ");
INSERT INTO set_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesus yae weumi, “((Sabat yana)) Reyae roko mbai rambun emere-emere mokoubokalebe mayae fa yae bowaube. ");
INSERT INTO set_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Na bere mai yobe mbai a ukeumi Yahudi ro nemene ro uwa elande folonate hele. Nebeisa Musa yae a ukembe kelu fa honondera ya mehine name hele yembondera ro uwa elande folonate. Nebei aerene mayae rore Sabat ya yae ro uwa elan folaumi. ");
INSERT INTO set_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Musale walora wali heere foloukoke are asasi okoinye Sabat ya yae ro uwa elan neisaise ehe kaube. Nebeibe rahene ro mbai nauwa kaban nanemene Sabat ya yae onomi ikanalere mayae ikele yae kowaufe? ");
INSERT INTO set_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ro miyae naei walire na ijen mae hului kolommi. Na kena u harainyebokere emmiyerembe na me u mo ban.” ");
INSERT INTO set_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nebeisa Yerusalem yona ro miyae hiwa yae elate, “Nda Niyaebe ya, aei yun-jun honaibondere baeinye Kiyae Niyae? ");
INSERT INTO set_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nebeibe erenne, uwa foro hele woke a elelebe aei yun-jun nare a mbai sambai ewei sele. Naendae wanen, Neyae Wali Ondofolo Kiyae Niyae aei yun-jun na hele elate era? ");
INSERT INTO set_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Wali Ondofolo mendena, Naei mende anuwau ro miyae isian bangka mo. Nda Ro naei meke anuwau aeisaei bangka mo yaendeboke. Nebei aerene meyae elande Neyae Wali Ondofolo ban.” ");
INSERT INTO set_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Allahre ei mom-mom imae na kaban sele kiyaene Yesus namman keleumi hee a elae yae kaenele, “Raei uwa mayae ro raufeboke. Raei mekale anuwau isaeyaeuboke. Mayae maisaei Raei kena huluinye emei. Rare ukeufe mekale Kiyae na hele no. Nare mayae rore oroiboi. ");
INSERT INTO set_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Reyae nebei Kiyae roungebokale, rabuhine ban Naei bokora mekale nane merau Neyae ukeufe mekale.” ");
INSERT INTO set_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nebei hee Yahudi yun-jun kena haehae hele kowate Yesusre ikilenaibondere. Nebeibe hi yae ha yae mere ikilembondere kabewainye, rabuhine ban Allah merau raungehike ikilenaibonde ya namman eyeiboinye. ");
INSERT INTO set_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nebei ya kabande hokoumeke ro miyae nolona yo helen Yesus a elewolere na hele yae elewate hila rabo halewainye, nda wanen elate, “Wali Ondofolo mende wanenna naendae mekai nda kiyae yae rambun emere-emere mokole ma nebei helen nen mokonde?” ");
INSERT INTO set_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nebei ro miyae a maehae-maehae yae nebei wanen Yesusle a elatebe Farisi holona yo borokate. Nebei aerene imam yun-jun bele Farisi holona bele yo yae Allahre ei mom-mom imae kayaare hebate yore ukaimi Yesusre ikileiboise ekate. ");
INSERT INTO set_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesus yae weumi, “Reyae na heki ban sele mangkele nanembainye nekemakonde. Nebeisa Maeko ukeufe mekale Kiyaele bokore bukerehinde erele. ");
INSERT INTO set_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mayae baensekombe, nebeibe Rare ehubayeikoi sului, rabuhine ban erele anuwau mayae maisaei banne. Raei anuwau erenekendere mayae ei sului.” ");
INSERT INTO set_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yahudi ro miyae hi yae hire hineunge, “Nda ro makeise enderene eyae baemande hororebe Nare ehubayeikoi sului yae weume. Naei merau raungehike Yahudi ro miyae mbemba ((Yahudi ban)) Yunani ro miyae nolone nekate anuwaufe endere era, nane merau Yunani ro miyaere emmikelendere? ");
INSERT INTO set_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Neyae nda a eleukoke, ‘Eyae baemandebe ehubaikoi sului’ nane merau ‘Reyae erenekende anuwau mayae ei sului.’ Nebei a rahe mekai?” ");
INSERT INTO set_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nebei raman bulau na huba mokoikoi ya naei ya kaban sele mokaiboke na ro miyae hebatere Yesus a kaban don mae kaeneumi, “Mayae ro miyae nde walire yennele bure buki kolena, mei, a elalere hila rabo halembe, nebei bu anembe. ");
INSERT INTO set_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Allahle homofaene molaikoke huluinye, nde yae Rare hila rabo haleufe nebei kiyae naei kena u eisa walire yemmile bu wi no wanen rilennende.” ");
INSERT INTO set_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Allahlena Roh enaiyaronde abe Yesus are haraungeboke huwoumi. Yesus Naei a elelere hila rabo halenate ro miyaere Allahle Roh ammibonde. Nebei hee Allahlena Roh namman emei rabuhine ban Yesusre hilire hebenainyele ya nammanne. ");
INSERT INTO set_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Yesus yae elewole a borowate nolona ro miyae hiwa yo yae elate, “Wali Ondofolo mende naeise bere holo yae mende yendo kayaalo, nda niyae hele.” ");
INSERT INTO set_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ro miyae hiwa yo yae elate, “Nda Wali Ondofolo mbai Niyaebe ya!” Hiwa yo yae elate, “Niyae ban rabuhine ban Wali Ondofolo Galilea kanira emei sului. ");
INSERT INTO set_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Allahle homofaene molaikoke huluinye Wali Ondofolo bae yobe Ondofolo kaban Daudle orona mena nane merau Daud nekewole yo yan Betlehemda mende.” ");
INSERT INTO set_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Yesusle kenane nebei holona ro miyae kayee molaikoke. ");
INSERT INTO set_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nebei ro miyae nolona hiwa yo kena hele Yesusre ikilenaibondere, nebeibe hi yae ha yae ikileiboise me fen eneyei. ");
INSERT INTO set_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Hukai hi bele nekaikoke mo, Allahre ei mom-mom imae na kaban sele kiyae naei kayaare hebate yo Yesusre ikileiboise ukaimi ekatera bukaiboke mekate hee, imam yun-jun bele Farisi holona bele yo yae hinewaimi, “Rahene mayae ndare eyaweisoi emei?” ");
INSERT INTO set_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Nebei yo yae waimi, “Era mahi hele. Nda ro miyae nekandera roko mbai Neyae elewole wanen eleikoi, maei angkaei yae oboroiboi mo!” ");
INSERT INTO set_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Farisi holona yae waimi, “Nebei mekainya Naeinya ame-ame keleumine mare mokombokembe aufakoukoke era? ");
INSERT INTO set_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Aei yun-jun holona bele Farisi holona bele ro mbai sambai nebei Kiyae Wali Ondofolore yeubokene a elelere hila rabo ehalei mo! ");
INSERT INTO set_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nebeibe nda ro miyae helen Musale walora wali heere foloukokere kobu helene Nare hila rabo halaeinye. Nebei ro miyaere olomo yae naimiboke!” ");
INSERT INTO set_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemus Farisi holona ro, na bere hele Yesusle bokore meke kiyae yae naei holonare weumi, ");
INSERT INTO set_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Aei naeise Musale walora wali heere folaikoke homone, ro miyae mbai mokouboke u mekai wa mekai nammam oboroiboi isaeyeiboi yae me onoyoi sului.” ");
INSERT INTO set_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nda yo yae Nikodemusre wainye, “Galilea kanina ro Yesus Naei kahili wa weyae na hi niyaene era? Allahle homofae eyere nane merau waeisaei yeubonde yendo kayaalo mbai Galilea kanira eyeiboi mo.” ");
INSERT INTO set_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Nebeisa ro miyae nanemene naei imae imaere hokoweke. ");
INSERT INTO set_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ro miyae nanemene imaere eufokoubokera Yesus bukeufike Zaitun mokore eke. ");
INSERT INTO set_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Na rene hele Allahle ei mom-mom imae na kaban sele kiyaere Yesus benen bukeufike eke erekainyene, ro miyae helen naei bokore mewate. Nebei imaehounge Yesus angken mae nuweuboke mo hubara raweuboke kelewoumi. ");
INSERT INTO set_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Nebeinye keleumi yae Musale walora wali heere foloukoke isaeyaeiboke kelaeimi holona bele Farisi holona bele maengke mbai miyae bele ro mbaite honowotebe hanakainyelene yawainyehoke mekate. Nda maengke ukainye na nolone afae yae hebeunguke. ");
INSERT INTO set_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Nebeisa Yesusre wainye, “Guru, nda maengke u bekone ekaimokatebe meyae hanekannele. ");
INSERT INTO set_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Musale walora wali heere foloukoke homofaene honole huluinye bae, nda maengke wanen ruka yae haimangkonde herende. Mana naendae wanen mae Waeinye a nebei naeise eleyae?” ");
INSERT INTO set_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Yesus a na ijen ban elengkondene fe mokonainyebonde naeise nebei yo walangkabe wokate. Nda a hinainyere Yesus oboroi wanen, be are niheufike, na me kala-kala yae kanine homo molole. ");
INSERT INTO set_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Na hibi mo wainyene Yesus be weuweke wa weumi, “Mai nolona nekaube na uware beko ban hubanende kiyaena, nebei kiyae yae bere ruka rowende ndi maengkere wende.” ");
INSERT INTO set_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nebei ara ukeumi mo Yesus benen be are yae niheufike kanine homone molowole. ");
INSERT INTO set_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Yesus nebei wanen a ukeumile borokatene nebei ijenda rorele yoni-yoni bere hokolo moisa here ware molowole mbemba mbemba yae mo keungekoke. Yesus nebei hebele maengke bele mo nebei ijenne hebewote. ");
INSERT INTO set_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Nebeisa Yesus uwa aloukokera nda maengkere weunge, “Nane yo makeinya ate? Hi yae ha yae ware me onoyoi mo?” ");
INSERT INTO set_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nda maengke yae weunge, “Tuhan, hi yae me onoyoi mo.” Yesus yae weunge, “Nebeinya Reyae nane wanen ware me onoyoi. Eye! Nda heera benen beko bako omokoyeijae.” ");
INSERT INTO set_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ro miyae benen Yesusle bokore hokomeke mo Yesus yae weumi, “Reyae Niyae nda kani kela hehere naemaele Kiyae. Hehe nibi reniai nolore hehe naeikoyole wanen mae, nde yae Raei moisa hakonsele kiyae wali hena bona nibibe kelaenale. Neyae ouben hauben nibine benen oroi.” ");
INSERT INTO set_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Farisi holona yae wainye, “Waei uwa naei a lon wenaei lon mae isaeyaemae. Nebei mekainya Waei a isaeyaemae na ijen ban.” ");
INSERT INTO set_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesus yae weumi, “Raei uwa naei a Renaeijae isaeisemile hororebe, nebei a isaeyaemaele na hele. Rabuhine ban Reyae raeisaei makeisa mekale nane merau makeise erelere. Nebei naeise mayae maisaei ban sele. ");
INSERT INTO set_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ro miyae erate ma yae mayae wali hului ikolowaumi. Reyae ro miyae hire wali hului erasi. ");
INSERT INTO set_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ro miyae naei wali hului rarensindena, Reyae na ijen selebe mokoremile, rabuhine ban Rare ukeufe mekale Maeko nanembainye nekendene. Reyae rembai mo rambun omokoi sului. ");
INSERT INTO set_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mai wali heere foloukoke hului bae ro bee yae eleikoke a amere eleikoi. ");
INSERT INTO set_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nebeinye Raei uwa naei a isaeyaemaelere Renaei isaeyaemale nane merau Rare ukeufe mekale Maeko yae isaeyembe. Nebei aerene na helere yeuboke.” ");
INSERT INTO set_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Are weumi yo yae wainye, “Waei Ako makeinye nekele?” Yesus yae weumi, “Mayae Rare onaeufena, Maekore nebei sului onaeunge. Rare mayae raufeboube yae nebei sului mbai mayae Maekore raungeboube.” ");
INSERT INTO set_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Allahle ei mom-mom imae na kaban sele kiyae einya roi haufau anuwau kelaeunge hebewole hee yae nebei a faeu nanemene uwoumile. Hi yae ha yae Yesusre ikileiboise me eneyei mo, rabuhine ban Allah meraufe raungehike Yesusre ikilenaibonde ya nammanne. ");
INSERT INTO set_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesus benen weumi, “Reyae erelere nane merau mayae rare ensebaembe, nebeibe u mekai beko bako yae mokoyembene, enserembe. Reyae erele anuwaufe mayae ei sului.” ");
INSERT INTO set_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yahudi ro miyae elate, “Nda a yae eleukoke, ‘Reyae erele anuwaufe mayae ei sului.’ Naendae wanen, Nauwa Nenaeijae hombonderene era?” ");
INSERT INTO set_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nebeisa Yesus weumi, “Mai anuwau arane, nda kani kela ranna yo. Raei anuwau bumarane, Reyae nda kani kelana ban. ");
INSERT INTO set_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nebeinye mai u mekai beko bako mokaube einye heremembe a ukamale. Raei uwa naeise Renaeijae yakaubokalere mayae hila rabo ehaleinya mai u mekai beko mokaube huluinye heremembe.” ");
INSERT INTO set_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Yesusre wainye, “Weyae naeinya hesele nde?” Yesus yae weumi, “Raei uwa yakaimeyamale hului Niyae be ya. ");
INSERT INTO set_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mai wali hului kolorengkombe naeise a helen sele Reyae na hului ufengkombe. Nebeibe Rare ukeufe mekale Kiyae na helene elewole a Reyae borokale hului yae nda kani kelana yore yakaremibonde.” ");
INSERT INTO set_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yesus yae Naeko Allahle abe uwoumire nda yo onewate handawate. ");
INSERT INTO set_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Onaete aerene Yesus weumi, “Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae. Mayae bumane enseranenjembe hee ya wa mayae Raei uwa hele isaeyembombe. Nane merau mayae isaeyembombe Reyae mokale rambun mbai sambai Raei uwana yae omokoiboi. Maeko yae kelewoufe a huluinye Reyae elale. ");
INSERT INTO set_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Rare ukeufe mekale Maeko ei haweimeyeufe, Renaei mo nukenaisebonde nekerele naeise Neyae ewaeisi. Maeko kena foise mokorende naei na hibi-hibi mokoyanalene.” ");
INSERT INTO set_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesus nebei a huwoumi yae ro miyae helen nebei a eleukokere na hele yae elewate, Nare hila rabo halewainyele. ");
INSERT INTO set_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yahudi ro miyae Yesusre hila rabo halewainyele elewate yore Yesus weumi, “Aka naei baeke naei, Reyae kelaemale are na hibi hila rabo halemembena, mayae Raei moisa hakaufekoke holona yore yembombe, ");
INSERT INTO set_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","nane merau Raei na hele wali nibi are isaeyembombe. Nebei a yae mokonembombe mayae benen yebaei bubaei ban.” ");
INSERT INTO set_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nebei yo yae wainye, “Meyae Abrahambe orona mena yo, roko mbai hiwa yo naei yebaei bubaeise eyeiboi mo. Rahene nebei a wanen don mae haraungebokae wamae, ‘Mayae yebaei bubaei ban yo bande yengkombe’?” ");
INSERT INTO set_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesus yae weumi, “Nda a na helebe wamale, bekore mokoyate ro miyae na bekore kena haehae kate reufi na yebaei bubaeise yaeiboke. ");
INSERT INTO set_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nane merau yebaei bubaei nebei imae einye na hibi mo enekeyei, naei kelu hele yae nebei imaene na hibi nekenende. ");
INSERT INTO set_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nebei aerene Reyae Allahle Kelu yae yebaei bubaeisa bulaerenembombena, weyae na hele Musale walora wali heere foloukoke a hului ehee bukulu hainyembera me rubombokembe. ");
INSERT INTO set_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Reyae isaeyeubokale mayae Abrahambe orona mena, nebeibe Reyae elale ako faeukore ahi yae elaube aerene mayae honsebombe nibibe baeube. ");
INSERT INTO set_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Maeko kelewoufe huluibe mare wamale. Nebeibe mai arai naeitera boraube huluibe mayae mokaube.” ");
INSERT INTO set_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Nebei yo yae wainye, “Maei yobe Abraham!” Nebeibe Yesus yae weumi, “Mayae na hele Abrahambe orona mena yaeuboube yae, mayae na hele Abraham mokowole bune wane hamaungele mokaube. ");
INSERT INTO set_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nebeibe mayae bukaungehike, Rare honsebombere relaeunge. Reyae Allahle na hele a weufere boroukokalebe, mare huwamale aerene mayae nebei u mekai beko haraungeboke. Abraham nebei u mekai wanen omokoiboi mo. ");
INSERT INTO set_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mai arai naei mokowate u mekai lonbe mayae mokaube.” Nebei yo yae wainye, “Meyae kai fa-fa ban. Maei ako mbai Allah Niyae.” ");
INSERT INTO set_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesus yae weumi, “Allah mai Akore yeuboube yae, Rare kena buhae haeufele. Rabuhine ban Reyae mai Allah yae elaube Kiyaele bokora mekale. Raei kena hului yae emei, nebeibe Neyae ukeufene mekale. ");
INSERT INTO set_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Rahene Reyae elale are isaeyeiboi mo kaube? Rabuhine ban Raei wamale are mayae boronsebombere kena ban. ");
INSERT INTO set_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Walobo yun kiyae mai ako! Nebeinye mai ako yae kena kole huluise mokombere kena haehae hele kaube. Na bere hele mai ako walobo yun kiyae ro miyae hoi-soi ro, nane merau Allah ukeunge na hele are ehakoiboi nekeimeyele. Naei uwana na hele naeise une. Neyae ame-ame nore yeuboke. ((Ame-ame bende heene na afaeu fele yelewole,)) rabuhine ban neyae ame-ame naei akone. ");
INSERT INTO set_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nebeibe Allah weufe na hele are Reyae wamale aerene mayae na hele yae eleikoi, hila rabo Rare ehalei. ");
INSERT INTO set_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Mai nolona hi yae Raei u mekai beko mokoubokalere keleubona! Nebei u mekai beko u lonna, rahene Raei a elalere mayae na hele yae eleikoi, hila rabo Rare ehalei? ");
INSERT INTO set_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Allah yae eleukoke wekeumi holona ro miyae Allahle a elelere borate. Mayae Allahle holona banne, nebei a elelere oboroi kaube.” ");
INSERT INTO set_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yahudi ro miyae yae Yesusre wainye, “Na ijen sele meyae elande, ‘Weyae Samariana ro, alo yae aubokete kiyae’!” ");
INSERT INTO set_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesus yae weumi, “Rare alo yae aiboi, Maekole ako faeuko hubara haeisa yananalebe. Nebeibe mayae Rare hubara haeisa eyanei. ");
INSERT INTO set_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Reyae uware kaenaisele naeise ebaei. Allah yae uwa kaenaisele naeise baele, Neyae mbai wali huluise kolommiyende Kiyae. ");
INSERT INTO set_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Na helebe Reyae wamale, nde Reyae ufende are hubara haeisa yanennelena, Allah bele ewahei nekenende.” ");
INSERT INTO set_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yahudi ro miyae yae wainye, “Nda hee yae wa meyae isaeyaendeboke Weyae alo yae ayeubokete koyae! Rabuhine ban Abraham naei uwa nane merau Allahle yenjo kayaayo nanemene heraiboke. Nebeibe Weyae eleyae, ‘Nde Reyae wamale are hubara haeisa yanennele kiyae here ehubayeikoi nekende.’ ");
INSERT INTO set_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Abraham nane merau Allahle yenjo kayaayo nanemene heraiboke. Naendae wanen, Waei uware nde maenin bele kiyae yae hului kolanae? Weyae maei ako Abraham nekewolera Waei uware kaban mae hubanae?” ");
INSERT INTO set_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesus yae weumi, “Raei uware Renaei kaerelena, rabuhi ban isebonde. Raei uware kaensele Kiyae Maeko Niyae, mai Allah yae elaube Kiyae. ");
INSERT INTO set_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mayae nebei Allahre ro oroiboi hororebe, nebeibe Reyae Nare ro roungebokale. Reyae Nare oroiboi a yae ufembena mainya wanen ame-ame bele rore isebonde. Nebeibe Reyae Allahre ro roungebokale, Neyae elele a huluinye hubara haeisa yananale. ");
INSERT INTO set_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mai ako Abraham mae Reyae nda kani kelane merenekende yare erembondere kena hele koweke. Nebei yare neyae ereuboke nane merau kena rei mai sele kowole.” ");
INSERT INTO set_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yahudi ro miyae yae wainye, “Waei ralo yakama namman 50 eyeiboi mo maei ako Abrahamde erekanae a lon mae eleyae?” ");
INSERT INTO set_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesus yae weumi, “Nana hesele, Abraham namman ohonoi ya ((Rare rowaise,)) ‘Reyae nekewale.’ ” ");
INSERT INTO set_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nebeisa Yahudi ro miyae ruka yarowate Yesusre hekelenainyelere. Nebeibe Yesus Nauwa nunde yae ewaheukoke. Allahre ei mom-mom imae na kaban sele kiyae imaehoufa eukuke ewole. ");
INSERT INTO set_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesus aloungekoke ewole hee ro mbai na hongkatera ijoko kumba yeubokebe erekeunge. ");
INSERT INTO set_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Yesus na moisa orowate yo yae hinainye, “Guru, rahene nda ro ijoko kumba yae hongkate, nenaei beko mokoubokene, ako yae nake yae beko mokeibokene?” ");
INSERT INTO set_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesus yae weumi, “Nda ro kumbare yeuboke bae nenaeijae nane merau ako nake yae mokaikoke beko aerene ban. Naeinya hesele Allahlena elae naei uwa einye mokombondene na hului ro miyae erembombe naeise. ");
INSERT INTO set_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Hu na naeukoke hebele yae Rare ukeufe mekale Kiyaele kalia mokomande hele. Rabuhine ban na heki ban mo be bahembondene ro miyae mbai sambai kaliare omokoiboi sului. ");
INSERT INTO set_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nda kani kela einye namman nekale hee, Reyae nda kani kela hehere naerensonde Kiyae.” ");
INSERT INTO set_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesus nebei a ukeumira euwaeki kanine houboke, kani bele aleungekoke mo nebei role ijokone hobeungekoke. ");
INSERT INTO set_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Nebeisa nda rore weunge, “Eye, wa be yoi Siloamna bu yale yae hobeukonde.” (“Siloam” na mekai “ukeunge eke”) Nebei ro eke Yesus yae ukeunge hului yae mokoubokene ijoko erewole yae beufoke ike. ");
INSERT INTO set_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nebeibe imae ribo mbainye nekewate yo bele nda ro bere a ri-tise riyeweke erewainye, ro miyae bele hinewaimi elate, “Naendae wanen, nda ro niyaebe ya, angken mae nuweiboyole a ri-tise riyeweke kiyae?” ");
INSERT INTO set_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ro miyae hiwa yo yae elate, “Nebei kiyae mbai niyae.” Hiwa yo elate, “Niyae ban. Nda kiyae nebei rolena wanen.” Nebei ro nenaeijae weumi, “Reyae niyaebe ya!” ");
INSERT INTO set_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nebei yo yae hinainye, “Rahe ma yae wa ijoko onomi rokae?” ");
INSERT INTO set_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nda ro yae weumi, “Yesus yae wainye Kiyae euwaeki houboke kani bele aleungeboke raei ijokone hobeufekokera bune kuisekondere Siloam bu yalere ukeufe ekale. Nebei a ukeufe huluinye mokoubokalene ra ijoko na hului erale.” ");
INSERT INTO set_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nebei yo yae nda rore hinainye, “Makeinya nebei Ro eke?” Nda ro yae weumi, “Reyae isian ma.” ");
INSERT INTO set_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Are hinewainye yo yae bere kumbare nekewole kiyaere yawainyehoke Farisi holona yo bokore ekate. ");
INSERT INTO set_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Sabat ya yae Yesus euwaeki houboke, kani bele aleungeboke nda role ijoko foise mokoungeboke. ");
INSERT INTO set_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nebei aerene Farisi holona yo yae nebei rore hinainye, “Naendae mekai yae waei ijoko foise mokouboke?” Nda ro yae weumi, “Kani rebe raei ijokone hobeufokera nebeisa ijoko bune kuyeukokale. Nda hee raei ijoko na hului erale.” ");
INSERT INTO set_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Farisi holona hiwa yo yae elate, “Nda Ro Yahudi era hena huluinye Sabat ya omokoi rambunbe mokolene, Allah yae ukeunge meke Kiyae ban.” Hiwa yo yae elate, “Naendae mekai yae beko bako bele ro miyae yae rambun emere-emere na hului mokonde?” Nebei aerene nda yo nenaei mo aku kiteuboke hate. ");
INSERT INTO set_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nebeisa Farisi holona yo yae nebei rore benen wainye, “Waei ijoko foi mokouboke aerene nebei Kiyaele naeise, weyae rahe ma yae eleyae?” Nebei ro yae weumi, “Raei u benera nekeufe nebei Kiyae yendo kayaalo.” ");
INSERT INTO set_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nebeibe Yahudi agama yun-jun nebei ro bere kumba nekewolera nda hee ijoko erele a uwoumire na helere eleikoi kowate. Nebeinye nenake naeko kaenaimikoke mekete, uwaimi, ");
INSERT INTO set_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","“Ijoko kumba yae hongkaubere eleube fa nda niyae? Naendae mekai yae nda hee ijoko erele?” ");
INSERT INTO set_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nebei fa nenake naekole yae weimi, “Maeisaeise nekende neyae maei fa nane merau ijoko kumba yae hongkande. ");
INSERT INTO set_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nebeibe nda hee ijoko erele naeise nane merau foise mokoungeboke naeise meyae isian hele. Roijandobe yeuboke ya! Naei uwa naei are nenaeijae hinennihi eleuko!” ");
INSERT INTO set_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Yahudi agama yun-jun fe kowaimi aerene nenakele naekole nda hului yae eleikoke. Rabuhine ban Yahudi agama yun-jun a hokaikoke, ro miyae yoni-yoni nde yae Yesusre Wali Ondofolo yae elengkonde kiyae Allahre ei mom-mom imaera hukenainyehinde. ");
INSERT INTO set_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nebei aerene nenake naeko nda a lon mae eleikoke, “Roijando yeuboke lonbe, nare hinennihine.” ");
INSERT INTO set_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Bere kumbare nekewole ro benen kaenainyekoke mo wainye, “Meyae maeisaei nebei Ro beko bako bele Ro ya. Allahre hilire hebeungelere, meyae wayete are be hineibone!” ");
INSERT INTO set_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nda ro yae weumi, “Reyae raeisaei ban nebei Kiyae ro foi, ro beko. Nebeibe raeisaeise nekale, bere reyae ijoko kumba nekewale, nda hee reyae ijoko erale.” ");
INSERT INTO set_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nebei yo yae benen wainye, “Rahebe nebei Kiyae ware mokoubokete? Naendae mekai yae nebei Kiyae wa ijokore foi mokoubokete?” ");
INSERT INTO set_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nebei ro yae weumi, “Mare ninae reyae huwengkokamale, nebeibe mayae oboroi kowaube. Rahene nebei are benen borombere kaube? Mayae kena kaube na moisa orate holonare yembombere era?” ");
INSERT INTO set_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Yahudi ro miyae nda rore na a haufau bele okainye wa wainye, “Weyae niyae nebei Kiyaele moisa oraube holona. Meyae bae Musale moisa orande holona! ");
INSERT INTO set_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Meyae maeisaei Allahlena ako faeuko bae Musare uwounge. Nebeibe nda Kiyae meke anuwau naeise maeisaei ban sele!” ");
INSERT INTO set_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nebei ro yae weumi, “Mahi hele naei meke anuwaufe maisaei ban sele elaube, erabae nebei Kiyae yae raei ijoko kumba nekewalere foi mokoufeboke erale. ");
INSERT INTO set_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Eyae aeisaei beko bako bele ro miyae naei are Allah oboroyei. Ro miyae Allahle u mekai wanen nekate nane merau Allah kena kole hului mokate yo bele naei are mo Allah eiborowoumi. ");
INSERT INTO set_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nda kani kelana mokoubokera ro miyae hi yae ijoko kumba yae hongkate ro miyaere onomi ikeunge ijoko na hului erewole naeise roko mbai oboroiboi mo nekemeyande. ");
INSERT INTO set_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nebei Ro Allahle bokora emei yae, nda mokouboke mare Neyae omokoiboi sului.” ");
INSERT INTO set_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nebei yo yae wainye, “Naendae wanen, weyae u mekai beko hongkayete fa lonbe maere weyae keleumekondere?” Nebei heera ei mom-mom imaera moise hukainyehike eukuke. ");
INSERT INTO set_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yahudi agama yun-jun mae nda rore ei mom-mom imaera hukainyehike a Yesus borokene, nebei rore baeungeke, hubayekoke mo weunge, “Allahle bokora meke ro miyae uware yeubokale Kiyaere hila rabo halaenae?” ");
INSERT INTO set_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nebei ro yae weunge, “Nebei Kiyae nde? Reyae na hului hila rabo Nare mo halerendere rare isaeyerebomae.” ");
INSERT INTO set_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesus yae weunge, “Weyae eranae nane merau nda hee wangkele are eleube Kiyae Niyae.” ");
INSERT INTO set_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nda ro yae weunge, “Tuhan, reyae Ware hila rabo halaewale.” Nebeisa Yesusre ei molounge. ");
INSERT INTO set_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesus yae weunge, “U mekai beko yakaremilera wali hului koloi-koloi naeise Reyae nda kani kelare mekale. Raei kalia mokale yae kumba nekate ro miyaere ijoko erenate nane merau ijoko erate ro miyae kumba inyaibonde.” ");
INSERT INTO set_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Nebei anuwaunge Farisi holona hebate yo Yesus nebei mekai a haraungeboke eleukokene, Yesusre hinainye, “Waei u benera nekayete meyae nane merau kumba?” ");
INSERT INTO set_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesus yae weumi, “Mayae ijoko kumba nekaube yae, mai me u beko aerene ehee bukulu eyaroikoi. Nebeibe mayae ijoko eraube yae elaubena, mai beko bako namman honayembe aerene ehee bukulu enyarongkombe.” ");
INSERT INTO set_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","((Yesus Naei me kelee u keleene nekate ro miyaere ei haweumi naeise kelemmibondere obo yoku dombane ahuneuboke.)) Yesus nda wanen mae huwoumi, “Reyae na helebe mare wamale, nde domba nekate fale eise na romaufa eyeisi, nebeibe nibi hira enensindena, nebei kiyae na hele yoko ro yoko miyae. ");
INSERT INTO set_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nebeibe domba yae nekate fale eise na romaufa enensinde ro miyae nebei kiyae niyae dombare holemmile ro. ");
INSERT INTO set_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nebei kiyae enensindere fale kayaare hebele kiyae nebei falena romau rawennebonde nane merau nebei domba yoni-yoni holemmile kiyaele a faeuko ronainyebonde. Mbemba mbemba na ro yae kaenemmile nane merau yawemmibonde, falera enaibalende. ");
INSERT INTO set_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Domba yoni-yoni yawemmibonde enaibalende hee, holemmile kiyae bera ende. Nebei domba yoni-yoni holemmile kiyaele a faeuko ronainyebondene, na moisa hakonainyekonde enate. ");
INSERT INTO set_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Domba yoni-yoni ro hi miyae hire ehakoiboi, eme ro miyae na faeuko oroiboinye na fere-fere habelenate.” ");
INSERT INTO set_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesus nda a ahuneuboke huweumire na mekai ma haraungebokere nda yo onaete handate. ");
INSERT INTO set_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nebei aerene benen Yesus weumi, “Nda a na helebe wamale, domba nekate falena romau Reyae Niyae. ");
INSERT INTO set_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Reyae nammam emei heena ro miyae hiwa mekate nauware Allah yae eleuboke Wali Ondofolo Kiyae yae elate. Nebei ro miyae nanemene na hele yoko ro yoko miyae. Domba yoni-yoni nebei yo naei a faeukore onaetene, waimi are oboroi nekate. ");
INSERT INTO set_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Reyae niyae na romau. Nde yae domba fale romaufa eise eyeisi wanen mae Allahle ro miyae holore Raei walora enduwende menensinde kiyaere Reyae hole molorembonde. Domba romaufa moise aibaleke ke fau foinye eraman enanende wanen mae Raei kelaemaele a walora ro miyae wali foi hubanainyele. ");
INSERT INTO set_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Yokolo holona ro miyae domba yokore baenatere honatere, nane merau bekore mokonaimibondere eimewate. Nebei wanen mbai nauwa Wali Ondofolore ame-ame elate ro miyae hiwa yo naei hila rabo bekore mokonaimibonde naeise eimewate. Nebeibe Raei are hakonaisele yo wali hena bona nane merau wali na foi sele moi sele enaiyaronde naeise Reyae mekale. ");
INSERT INTO set_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Reyae domba yoni-yonire na foi yae holamaele Kiyaere yeubokale. Domba yoni-yoni hole moloremibonderene Raei uwa kinyeremibonde. ");
INSERT INTO set_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ro miyae hiwa roise abunende naeise domba yoni-yoni kayaare hebate. Nebei wanen ro miyae han bele yoku mende erenainyelene, nebei domba yoni-yoni nukenaimibonde na fere habelenayende. Nebei han bele yoku domba yoni-yonire yokunende, here ware bonaimile. ");
INSERT INTO set_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Roise abunate naeise domba yoni-yoni kayaare hebele kiyae na fere bele habeleweube, rabuhine ban nebei domba yoni-yoni naei banne, kena buhae ehei. ");
INSERT INTO set_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Reyae domba yoni-yoni na foi yae holaemaele kiyaere yeubokale. Maeko Rare ro roufe nane merau Reyae Maekore ro ranale. Nebei mekai mbai domba yoni-yonire Reyae ro ramaele nane merau nebei domba yoni-yoni Rare ro raise. Nebei domba yoni-yoni na wali hole moloiboise Raei uwa yae kinyeumibokale. ");
INSERT INTO set_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Raei domba yoni-yoni hiwa kani hine nekate. Nda domba yaweremibonde hele. Neyae domba holo mbai nendo wanen mbai Raei a elerelere boronate. Nebei holo nanemene holo mbainye inyaibonde, na holeumi ro mbai yembonde. ");
INSERT INTO set_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Nda hee Raei wali kinyamalera bena honoifoyole ya benen roufele aerene Maeko kena buhae Rare heufe. ");
INSERT INTO set_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ro miyae hi yae ha yae Raei wali mera enukeisai sului, Raei kena kale hului yae kinyamale. Maeko elae ikeufe. Nebei elae walora Reyae na hului Raei wali kinyerebonde, nebeisa benen roufele. Nebei naeise Maeko a ukeufe.” ");
INSERT INTO set_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Nebei a mekai Yesus eleukokene, Yahudi ro miyae holo beere wahaeikoke. ");
INSERT INTO set_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ro miyae helen elate, “Neyae alobe aungeboke kole, nane merau keube aungeboke kole. Rahere nebei kiyaele a elelere mayae boraunge?” ");
INSERT INTO set_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Nebeibe hiwa yo yae elate, “Alo yae aiboyainye ro miyae nda a wanende eleikoi sului. Walobo lonbe na huluinye ijoko kumba ro miyaere mokonnebonde ijoko kelengkonde erende?” ");
INSERT INTO set_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","((Na bere hele Yerusalem yona Allahre ei mom-mom imae na kaban sele kiyaere Yahudi naei yokeijo yae roukate, nane merau nebei heena nebei anuwau ne neufike honowole. Yahudi felayo benen hole molainyeboke, foi mokaiboke.)) Nebei bene nekeisi-nekeisi ya kabande na heki ban mokonaibonde hee, alu hin manse meungeke. ");
INSERT INTO set_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Nebei ei mom-mom imaena anuwau mbai Salomole yowa yae elewate, nebeise Yesus ele melene koweke. ");
INSERT INTO set_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yahudi ro miyae arilewole Yesusre yanainyekoke wa hinainye, “Rahene maere heki koko hele Waei naeise kena wauwau komayewetere waeumihikae. Weyae nana hesele Wali Ondofolona, maere a yaka faeu yaka yae weimene!” ");
INSERT INTO set_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesus yae weumi, “Reyae nebei naeise a ukamalebe ya, nebeibe Reyae wamale a na helere mayae eleikoi kaube. Rambun emere-emere Reyae Maekole ro yae mokale. Nebei yae Raei uwa naei are isaeyembe. ");
INSERT INTO set_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nebeibe Reyae Wali Ondofolo yeubokalere mayae na helere eleikoi, rabuhine ban mayae Raei domba holone emeyeisinye. ");
INSERT INTO set_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Raei domba holona yo Raei a faeukore boraise. Reyae nebei yore raemaele nane merau Raei moisa hakaisele. ");
INSERT INTO set_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nebei holona ro miyaere Reyae wali hena bona yaemaele, beko eibei nekenayende. Hi yae ha yae nebei ro miyae Raei mera einyukeisai sului. ");
INSERT INTO set_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Maeko nebei holonare kinyeufeboke Kiyae ehameikoi sului, nane merau hi yae ha yae nebei ro miyae holonare Maekole me eisa enukeisai sului. ");
INSERT INTO set_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Rangkele Maekole nanembainye nekende.” ");
INSERT INTO set_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Nebei a elewolene Yahudi ro miyae benen ruka yaraikoke Yesusre hekelenainyelere. ");
INSERT INTO set_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Nebeibe Yesus yae weumi, “Maeko yae ukeufe rambun emere-emere helen mokoukokale, ro miyaere yakamaele. Nda mokowalere makei kayeero aerene Rare ruka yae hekelenselere?” ");
INSERT INTO set_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yahudi ro miyae wainye, “Weyae rambun emere-emere mokowoyae aerene meyae ruka yae haimayetere ban ma. Naeinya hesele weyae Allahre aukaka kanaene. Weyae nda ro miyae nekande mabe, nebeibe Wauwa mokanae Allahle na hului mbai eleyae aerene.” ");
INSERT INTO set_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesus yae weumi, “Mai wali heere foloukoke homone molaikoke, ‘Allah yae elele mayae naei mekai allah.’ ");
INSERT INTO set_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Eyae aeisaei Allahle homona molaikoke yoni-yoni nanemene enaibende. Nebeinye Allahle ako faeukore boroyate na helere eleyate yore allah yae ro royeimi. ");
INSERT INTO set_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Rahene mayae Allahle Kelu yae Raei uware elale aerene Allahre aukaka kanale yae elaube, erabae Maeko yae Rare eleufeboke ukeufe nda kani kelare mekale. ");
INSERT INTO set_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Allahlena rambun emere-emere omokoinya, Reyae a elerelere na hele yae eleijae nane merau hila rabo ehalensemae. ");
INSERT INTO set_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nebeibe Reyae rambun emere-emere mokalena, nebei mokalebe na hele yae elen! Nebei mekai yaere maisaei nekembe nane merau isaeyembombe Maeko Rangkele mbai, nane merau Reyae Maekole mbainye nekayende naendae wanen hororebe Raei a elalere hila rabo ehalei.” ");
INSERT INTO set_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yahudi ro miyae benen Yesusre ikilenaibondere relewainyebe. Nebeibe Yesus nda yo naei me ikilainyebokera eufaeuboke ewole. ");
INSERT INTO set_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nebeisa Yesus bukeufike eke bere Yohanes bure kowoumi Yordan wi reufine Yesus ekenekewole. ");
INSERT INTO set_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ro miyae helen Yesusle bokore mewate yo yae elate, Yohanes bure kowoumi kiyae rambun emere-emere omokoikoibe, nebeibe nda Ro naei a elewole nanemene nana hesele. ");
INSERT INTO set_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Nebei anuwaunga ro miyae Yesusle are na hele yae elewate, hila rabo halewainyele. ");
INSERT INTO set_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Ro mbai na ro Lazarus, nemaen wa bee Maria nauwake Martale, Betania yone nekewate. Nebei Maria Yesusle orore minyak fololo bele rilennebonde na umaa yae hobennekonde kiyae. Roko mbai neneu Lazarus erane ruke honowole. ");
INSERT INTO set_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Nebeinye nemaen wa bee Yesusre isaeinyainyebondere ukeimile ekate, “Tuhan, Weyae kenare kanae kiyae, erane kole ya.” ");
INSERT INTO set_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Lazarus erane kole a Yesus borouboke mo elele, “Nebei era buloo ekekole herende naeise ban, nebeibe nda wanen yembonde yae Allahre hili enainyehebende. Nebei wanen maere Reyae Allahle Kelu hili enaisehebende.” ");
INSERT INTO set_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Nda name: Marta yae, Maria yae, Lazarus yae, Yesus na hele kena buhae heumiyeke. ");
INSERT INTO set_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lazarus erane kole naeise Yesus borouboke hororebe, nebei heera mehauwae na kena herawemmiboke nebei anuwaunge ya bee hele nekeukoke. ");
INSERT INTO set_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nebeisa wa Yesus yae Naei moisa orowate yore weumi, “Mem, eyae Yudea kanire benen bukemabonde emalere.” ");
INSERT INTO set_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Nebeibe na moisa orowate yo yae wainye, “Guru, manemfa fere nebei kanina Yahudi ro miyae Ware ruka yae hainyayeikotere kowate. Nebei anuwau londe yae benen bukeufinde elere wamae?” ");
INSERT INTO set_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","((Yesus Naei wali nibi keleumi naeise Allah merau raungehike bele hehe bele ahuneuboke)) hineumi, “Rai hukai na heki me bee oro nen bee bele huluibe ya. Nebei hee yae ro miyae eyewole kiyae enaleisi sului, rabuhine ban nda kani kelana hehe yae naeikoyeungene. ");
INSERT INTO set_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nebeibe ro miyae huae yae oro nende kiyae naleise-naleisi konende, rabuhine ban na uwana hehe banne.” ");
INSERT INTO set_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Naei wanenda Yesus ukeumira nebeisa benen weumi, “Aei kahili Lazarus ijongkune eke honole. Nebeibe Reyae nda hee nebei yengkeikoise erelere.” ");
INSERT INTO set_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Na moisa orowate yo yae wainye, “Tuhan, Lazarus ijongkune honolena, neyae onomi rowende lonbe.” ");
INSERT INTO set_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesus Lazarus hereke abe haraungeboke uwoumibe, nebeibe na moisa orowate yo yae onaeikoke. Lazarus ijongkune ekehonole yae naei u benera nekewaimi. ");
INSERT INTO set_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nebeinye na yaka yae Yesus weumi, “Lazarus hereke ya. ");
INSERT INTO set_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Reyae helen foi yae elale nebeise yeuboke ya Rangkele ban, mai foi naeisene. Emale, menaei ijoko yae erembombe wa Reyae Wali Ondofolo yeubokalere hila rabo halembe. Mem, mana eyae Lazarusle bokore ema.” ");
INSERT INTO set_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomas, nane merau Didimus yae kaenewainye kiyae, naei kahili hiwa yore weumi, “Eyae nanembainye emaherembonde naeise mem, hakomangkon ema.” ");
INSERT INTO set_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesus nebei anuwaunge eke hee nebeinya ro miyae eleuboke, “Lazarus ruka buleinye aitaufike ya keli nendobe yeuboke.” ");
INSERT INTO set_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania yo Yerusalem yo kelaeunge honole nahau km 3 hului. ");
INSERT INTO set_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Martale Mariale neneu hereke kena beko nekewotere, Yahudi ro miyae helen kena foi yeise hokoumeke. ");
INSERT INTO set_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Yesus mewolere Marta boroubokene, ei aiboise eke, nebeibe Mariabe imaene nekewole. ");
INSERT INTO set_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta yae Yesusre weunge, “Tuhan, nebei ya weyae ndane nekemae yae reneu eherei sele. ");
INSERT INTO set_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nebeibe nda hee reyae raeisaei sele, Allahre riyeungehinde rambun Ware inyete hele.” ");
INSERT INTO set_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesus yae Martare weunge, “Weneu benen walembonde.” ");
INSERT INTO set_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta yae weunge, “Reyae raeisaei nda kani kela hubare ennemokonde ya, ro miyae anyainyu kommile heene, neyae annunde.” ");
INSERT INTO set_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesus yae weunge, “Reyae niyae ro miyae herewate areminunde bele wali isemile bele Kiyae. Nde yae Rare hila rabo halensele kiyae hereube horore benen walembonde. ");
INSERT INTO set_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nane merau ro miyae na waline nekele hee Raei a elalere hila rabo haleufena eherei ohonoyei. Naendae wanen, nda a wawalere weyae hila rabo haleyae?” ");
INSERT INTO set_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta yae weunge, “Tuhan, reyae Ware hila rabo halaewale, Weyae Allahle Kelu, Wali Ondofolo nda kani ei kela eise mendere elewate Kiyae.” ");
INSERT INTO set_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta nebei wanen ara ukeunge mo Mariale weise na hibi aloungekoke ewole. Eke Maria nangkaei kelaeufa weunge, “Guru, ndane ekenekele, waei a elelene nebeinye Waei kaeneikoise male.” ");
INSERT INTO set_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nebei wanen a ukeungene Maria u hale me hale aunguke na hibi aloungekoke eke Yesusre eisubayeikokete. ");
INSERT INTO set_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Neyae eke hee Yesus namman nda yo eise emeyeisi. Martale hubayeikokete anuwaunge mo namman nekewole. ");
INSERT INTO set_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yahudi ro miyae imaene Mariare kena foise mokainye yo nanembainye nekatera erainye Maria u hale yae aunguke aloungekoke elene, nda yo na moisa hakoinyekoke. Naei u benera nekewaimi bulei tande ele, rimere endimendere. ");
INSERT INTO set_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Yesus nekewole anuwaufe Maria eke hee, Yesusre erekeunge oro helen-selen mae noro bene roroukoke weunge, “Tuhan, nebei hee yeuboke Weyae ndane yae, reneu eherei sele ya!” ");
INSERT INTO set_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesus erewounge Maria rimewole nane merau Yahudi ro miyae Mariare hakainyekoke mewate yo erewoumi rimewatene, na kena moheuboke beko hele hubawounge. ");
INSERT INTO set_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Nebeinye Yesus yae hineumi, “Makei ijenne molaufake?” Nda yo yae wainye, “Tuhan, mei, ijoko meyereibo!” ");
INSERT INTO set_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nebeisa Yesus na rime bele rimewole. ");
INSERT INTO set_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yahudi ro miyae nebeinye hebewate yo yae elate, “Erenne, Lazarusre na kena buhae helebe heunge.” ");
INSERT INTO set_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nebeibe hebewate ro miyae nolona hiwa yo yae elate, “Neyae mbai kumbana yore mokowoumi ijoko erewate. Neyae na hului eherei naeise hee neungehaube, Lazarusre onomi yeungele. Rahene Neyae foi mokoiboise heki hele emei?” ");
INSERT INTO set_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesus kena beko hele hubawounge yae molaisake ruka bulei kelaeufe eke. Nebei bulei ahe rukabe halaeikoke, ruka kaban mae na romaufe ahaeikoke. ");
INSERT INTO set_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesus yae weumi, “Nebei ruka wenne!” Nebeibe Marta nane ro hereke nemaen mae weunge, “Tuhan, ya keli nendobe bulei einye mo honoimeyele, na u kelen bele yeuboke era!” ");
INSERT INTO set_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Nebeibe Yesus yae Martare weunge, “Reyae ware a wewekawalebe ya, weyae hila rabo halelena, Allahle nene waewae weyae ijoko ereubonde.” ");
INSERT INTO set_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nane rukare mo wekainyele. Nebeisa Yesus na be yakure yae weuweke mo Naekore ebeline bounge, “Arai, helen foi sele wawale Weyae boroyaraene. ");
INSERT INTO set_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Reyae raeisaei sele Raei ebeli kali Weyae na rokone baei boroyarae, nebeibe nda ro miyae helen arilewole Ware foi oroiboi. Nda a bawale, Weyae Rare ukarae mekalere hila rabo bele halenate naeise Raei riyeufikale a hului mokoibo.” ");
INSERT INTO set_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nebei wanen ebeli bowoungera kali na kaban mae kaeneunge, “Lazarus, ainyu meituwe!” ");
INSERT INTO set_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nda ro hereke norona mena malo lenan rinyainyekoke bele na be yoise felainyeboke malo bele aunguke meukuke. Yesus yae weumi, “Malo rinewainyele bulaerenneko, nenaei waennehimbe ende.” ");
INSERT INTO set_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nebeinye helen sele Yahudi ro miyae Mariare eise mekaisauwainye yo Yesus mokoukokere erekate hee Nare hila rabo halewainyele. ");
INSERT INTO set_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nebeibe hiwa yo Farisi holona bokore ekate, Yesus yae mokouboke a nemene huwaimikoke. ");
INSERT INTO set_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Nebeinye Farisi holona bele imam yun-jun bele Yahudi naei yoyo koseyo kaenaimikoke, riyane arileufike nekewate wa waimi, “Nda ro rambun emere-emere mokolene, eyae rahe yae mokomambondere? ");
INSERT INTO set_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nda mokolere eyae na hibi waemansindena, ro miyae nanemene Nare mo hila rabo halenainyele. Nebeisa ondofolo kaban na felayo menate ((Yesus nda kani naei Ondofolore ranenaijendere fe faenatene)), Allahre ei mom-mom imae na kaban sele kiyae bele aei yo yan bele beko mokonainyebonde.” ");
INSERT INTO set_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nebei yoyo koseyo riyare nekewate nolona ro mbai na ro Kayafas. Nebei ralo yakama naei imam yoni-yoni naei yunde neyae nekewole kiyae yae weumi, “Mayae maisaei ban mo! ");
INSERT INTO set_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nane merau na foi naeise uwa ehubaisi kaube. Ro miyae aerene naei foi sele ro mbai herende. Nebei mekai yaere nda yo kaban yan kaban beko omokoiboi.” ");
INSERT INTO set_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Naeinya hesele Kayafas nda a eleukoke naei u benena ban. Nebeibe imam yunde nebei ralo yakamane nekewolene, Yesus Yahudi ro miyae aerene herende abe Allahle Roh walora nuleungekoke. ");
INSERT INTO set_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Nane merau Yahudi ro miyaere mo ban, nebeibe Allahle fa-fa here ware waeibokere arilemmihindere nane merau mbainye mokommibondere Yesus herende. ");
INSERT INTO set_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nebei aerene nebei yara Yahudi yun-jun Yesusre honaibondere na merau huba rawaiboke. ");
INSERT INTO set_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nebeinye Yesus Yahudi ro miyae helen bene eyakaiboi mo, a kala-kala kelaeunge kulun uke, yo mbai na ro Efraim nebeise eke. Na moisa orowate yo bele nebei anuwaunge ekainyekewate. ");
INSERT INTO set_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nebei hee Yahudi naei ya kaban Paskah nobeungekokene ro miyae helen nebei ya kaban namman mae naei era hena huluinye nauwa yolo-yolo mokoiboise na yora yora Yerusalem yore mo hokoweke. ");
INSERT INTO set_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Yerusalem yore hokoweke yo ekate Allahre ei mom-mom imae na kaban sele kiyaene mo Yesusre baewainye. Hi yae hire hineunge, “Naendae hubanae, nauwa nda ya kabande emei era?” ");
INSERT INTO set_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nda a wanen elate, rabuhine ban nebei hee imam yun-jun bele Farisi holona bele a ukaimile, neyae Yesusre ikilenaibonde naeise nde yae Yesus ennekende anuwau naeisaeinya, nda yore isaeinyaimibonde hele. ");
INSERT INTO set_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ya mehine mbai Paskah ya bere mo kolowainye, Yesus Betania yore eke. Nebei anuwaunge Lazarus herekera Yesus yae waleungeboke kiyaele yo. ");
INSERT INTO set_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yesus ei moloiboise eraman bulau mokaiboke, Marta mbai ei hawewounge. Lazarus na ro hi Yesus naei raman nanembainye nuwaikoke anewate. ");
INSERT INTO set_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Nebeisa Maria meke minyak narwastu fololo bele liter bohi mbai roi na bumana hele kayee rouke meke, Yesus noro ranne rileungeboke mo, nauma yae norore hobewounge. Nebei imae ei minyak narwastu fololo roroukoke hebewole. ");
INSERT INTO set_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nebeibe Yudas Iskariot Yesusle moisa orowate holona ro mbai, Yesusre kelai nennebonde kiyae yae weunge, ");
INSERT INTO set_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Nebei minyak fololo bele naise heuboube roi kaban roweube. Nebei roi ro mbai na kalia ralo yakama mbai na roibu hului roweube. Nebei roi yae ro miyae kounge kalone nekeyate yore na hului eumiyeube. Rahene nebei wanen omokoiboi?” ");
INSERT INTO set_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kounga kalona yore u bene nekeumine Yudas nda a wanen eleukoke ban, nebeibe neyae yokolone. Yesusle moisa orowate holona yo naei roi kayaa hebewole ro Yudas niyae. Roko mbemba na mene yaeinye roibe naei u mbai naei rambunde rowele. ");
INSERT INTO set_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nebeibe Yesus yae weunge, “Karo, rabuhire eyeiboi. Allah merau raungehike Rare molonaisele yare nebei me ube mokole. ");
INSERT INTO set_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ro miyae kounga kalona yo mangkele mbainye mo nekemembe, nebeibe Reyae mangkele mo na hibi enekeyei.” ");
INSERT INTO set_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yahudi ro miyae helen sele borokate Yesus nebei imaene ekenekele, nebei hee yae haleuboke ewate. Nebei yo ewate Yesusre baeinyeke mo ban, nebeibe nane Lazarus herekera Yesus waleungeboke, nebei ijoko ereiboise bele ewate. ");
INSERT INTO set_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Nebeinye imam yun-jun mae Lazarusle bele honaibondere merau rainyehike, ");
INSERT INTO set_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","rabuhine ban Lazarus waleuboke aerene Yahudi ro miyae helen nebei yun-jun naeisa moi kaeinyehike Yesusre hila rabo halewainyelene. ");
INSERT INTO set_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ya heuboke mo nebei ya kaban naei raman bulau konate ro miyae helen hokoumeke yo borowate Yesus Yerusalemde be raungehike mele. ");
INSERT INTO set_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Nebeinya hoyeu nihewate, eisa haweyainye wa kaenate, “Allahre buma koloman! Tuhan Allahle Ro einye meke Kiyae onomi foka yae ei enainyehawende! Israel ro miyae naei Ondofolo onomi foka yae ei enainyehawende!” ");
INSERT INTO set_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesus keledai kelu hubayekoke randa yeufileukoke. Allahle homofaena molaikoke huluinye yeuboke, ");
INSERT INTO set_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ereinye, Sion yona ro miyae buhae ohokoijae, mai Ondofolo mele, keledai kelu randa hebeunguke mele.” ((Yerusalem nane merau Sion mae uwainyele.)) ");
INSERT INTO set_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Nebei hee Yesus na moisa orowate yo nda bewatere u bene orowei kowate. Nebeibe Yesus herekera meke benen bumane ike heera wa u bene nekaimihike, na hele nebei ro miyae yae ei molowainyere nemene fomene Allahle homofaene Naei naeise molaikoke honate. ");
INSERT INTO set_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lazarusre ruka buleisa Yesus kaeneungekoke meukuke nane merau herekera waleungebokere nenaei ijoko yae erewate yo helen nebei a faeube eleiko ramumbo kate. ");
INSERT INTO set_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ro miyae helen Yesus nebei iwau emere-emere mokoubokere borowatene, Yesusre hubainyaikondere mewate. ");
INSERT INTO set_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Nebei aerene Farisi ro miyae hi yae hire naeise naeise elate, “Eyae rabuhi-rabuhire omokoiboi sului ya. Eren, nda kani kelana ro miyae nemene Nare mo hakainyekoke.” ");
INSERT INTO set_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Yerusalem yore ya kaban mokaibokere ei mom-momde hokoweke ro miyae nolone hiwa Yunani kanina ro miyae. ");
INSERT INTO set_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Filipus Galilea kanina Betsaida yona ro nebei yo mekate mo wainye, “Aka baeke, meyae kena haehae hele kande Yesus Naei hubaimakondere.” ");
INSERT INTO set_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipus eke nebei a Andreasre isaeyeungeboke, nebeisa hokolo bee ekete Yesusre ukeinyele. ");
INSERT INTO set_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesus yae weumi, “Allahle bokora mekale ro miyae uware yeubokale Kiyaere hilire hebenaisele hee na hului meujeuboke. ");
INSERT INTO set_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Reyae nana hesele wamale, gandum ko kani einye emoloisai nane merau ehereinya ko mbai mo nekende. Nebeibe herendena, benen kitende, ko nekai sele emmokonde. ");
INSERT INTO set_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ro miyae nde naei wali bekore kena kole kiyae na wali hole omoloiboi sului. Nebeibe nde yae nda kani kelana wali bekore na kenara ikele yae kole kiyae, na wali hole moloungeboke nane merau wali hena bona rowende. ");
INSERT INTO set_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ro miyae Raei kaliare mokate yo Raei moisa hakonaikonde hele nane merau Reyae erenekende ijenne nebei u mekai ma yo nangkele. Nde yae Raei kaliare mokole kiyae, Maeko yae nebei kiyaere ennekaende. ");
INSERT INTO set_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Nda hee Raei kena u eisa isasa alolo kale. Nebei aerene nda a lon mae ebeli borensinde, ‘Ako Raei uwa rande menaibende bele nda hee yae Rare hole moloisobo’? Nebei mekai ban, rabuhine ban nebei ehee bukulu kaerebonde aerene Reyae ndare mekale. ");
INSERT INTO set_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ako, Wa Ro hili hensende mokoibo ba! Waei kena koyae hului Rare mokoufele.” Surgara a beufoke weunge. ((Yesus rambun emere-emere mokowolene Allah yae nda are eleukoke borowate,)) “Kelu, Raei nene waewae ro miyaere kelewamale nane merau benen keleremikonde.” ");
INSERT INTO set_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nebei anuwaunge hebewate ro miyae a eleukokere borowatene elate, “Nebei kube neke.” Nebeibe hiwa yo yae elate, “Ku ban, malaikatbe, nebei kiyaere a weunge!” ");
INSERT INTO set_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesus yae weumi, “Nebei a borauboke Raei foi naei ban, naeinya hesele mai foi naei abe eleukoke. ");
INSERT INTO set_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nda kani kelana ro miyae naei walire hului kolommikonde ya na hului meuyeuboke. Nane merau walobo yun hukennehinde ya na hului meuyeuboke. ");
INSERT INTO set_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nebeibe Rare nda kani kelara bumane nenaisijende hee yae, ro miyae nanemene Rare hila rabo halenaisele naeise yoboremile.” ");
INSERT INTO set_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesus ohaline enaibongkonde herende naei abe nda ma yae haraungeboke eleukoke. ");
INSERT INTO set_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nebei ro miyae helen mae wainye, “Musale walora wali heere foloukoke homonane huwaimene borowande Wali Ondofolo mende Kiyae wali huba ban haei ban nekenende. Naendae wanenne Weyae eleyae, ‘Allahle bokora meke ro miyae uware yeuboke Kiyae nda kani kelara bumane enainyejende?’ Allahle bokora meke ro miyae uware yeuboke Kiyae eleyae naeinye hele nde?” ");
INSERT INTO set_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesus yae weumi, “Nda hee ferere Reyae hehere naemmile Kiyae mai nolone nekande. Nebeinye Reyae hehere naemale Kiyae namman nekale yae Allahle isaei hebaende onaeinye yo wanen mayae yembombe belene, Raei a elale huluinye nekembe. Allahre onaeinye yo yae wali nibi foi isaeyeiboi. Nebei yo ouben hauben nolone orate wanen nekate. ");
INSERT INTO set_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Reyae hehere naemale Kiyae mai waline namman nekande hee yae Rare hila rabo halensele. Nebei mekai yaere mayae na hului Reyae hehere naemale Kiyaele kelu omire yembombe.” Nebei ara weumikokera Yesus nauware nunne enahengkonde anuwaufe ewole. ");
INSERT INTO set_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesus roko helen sele rambun emere-emere nda yo naei ijoko bene mokowole hororebe, nebeibe nda yo Yesusre hila rabo ehalei nekate. ");
INSERT INTO set_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nebei mekai yaere Allahle yendo kayaalo Yesaya yae nda a moloukoke na hului yaeiboke, “Tuhan, ro miyae keli name mo meyae humande are na hele yae elenaikonde nane merau hila rabo halenate. Nane merau Tuhan, ro miyae keli name mo Waei elae wakere yakaumibokae?” ");
INSERT INTO set_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Na bere Yesaya a eleukoke hului nebei yo na hele eleikoi, hila rabo ehalei rabuhine ban neyae nda Allah eleukoke are moloukoke, ");
INSERT INTO set_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Wali noube enainyehembondene Reyae onomibe isemile bele, nda ro miyae ijoko yae ereiboi sului naeise nane merau na u benera isaeyeiboi sului naeise Allah yae ijoko kumba mokommibonde na kena elae mokommibonde.” ");
INSERT INTO set_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yesusle uwa naeibe Allahle yendo kayaalo Yesaya yae nuleungekoke, rabuhine ban Yesus Wali Ondofolole nene waewaere neyae ijoko yae ereuboke. ");
INSERT INTO set_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nebei a moloukoke hororebe ro miyae helen bele Yahudi yun-jun nolona hiwa yo bele fa kangkin bewate, Yesusre hila rabo halewainye. Nebeibe nda yo a yaka faeu yaka yae elenaikondere fe yae kowate. Rabuhine ban nda yo buhae hokowoumi Yesusre hila rabo halaeinye aerene Farisi holona yo yae ahenaimikonde Allahre ei mom-mom imaere oroi belene. ");
INSERT INTO set_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Nebei holona yo Allah yae nare kaemmile naeise kena ban, ro miyae yae nare kaenaimilere kena hele kaikoke. ");
INSERT INTO set_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Hokoumeke ro miyae helende Yesus kaeneumi, “Rare hila rabo halaeise ro miyae Rare hila rabo halensele mo ban, nane merau Rare ukeufe mekale Kiyaere hila rabo halennele. ");
INSERT INTO set_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nebei kiyae Rare ijoko erensele heene, Rare ukeufe mekale Kiyaere nane merau ijoko erennele. ");
INSERT INTO set_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ro miyae hila rabo halaeisele yo yae Allahre onaeinye holona yo naei wali oubenne orate wanen enekei naeise Reyae hehere naemaele Kiyae nda kani kelare hehe wanen mekale. ");
INSERT INTO set_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Raei a elalere borate yo nebeibe wali nebei suluinye ehakoiboi omokoinya, nebei wali mare Reyae hului okoloi. Rabuhine ban nda kani kelana ro miyae naei walire hului koloi-koloise mekale ban, naeinya hele holere moloremibondere mekale. ");
INSERT INTO set_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nde yae Raeinya a faeu wamalere borondere ahi yae elende nane merau Rare nensehindena, Raei euwara elale a faeu wa huba mokoikoi yane ehee bukulu mere emminonde kiyae niyae. ");
INSERT INTO set_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Rabuhine ban Raei elale a faeu Raei uwana a ban. Nebeibe Ako ukeufe mekale Kiyae mare ufembere ukeufe abe, nebei hului yae mare wamale. ");
INSERT INTO set_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nane merau Reyae raeisaei sele Ako ufembere ukeufe a faeu wae wali hena bonare inyembe. Nebeibe Reyae elale a Maeko yae keleufekoke hului yae mare huwamale.” ");
INSERT INTO set_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Paskah raman bulau nobeungeboke hee Yesus naeisaei yeuboke nda kani kela nukembonde Naekole bokore ende hee na hului yeuboke. Naei holona ro miyaere nda kani kelana nekate yore kena buhae u buhae nekai sele hewoumi nane merau na hibi mo Naei herende yare kena buhae heumiyeumi. ");
INSERT INTO set_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesus na moisa orowate yo bele huaena ramanne namman anewate. Walobo yun Yudas Iskariot, Simonbe kelu, Yesusre kelai nenende naeise kena haweungekoke. ");
INSERT INTO set_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesus naeisaei Naeko yae rambun nemene fomene Naei me kelee u keleene kinyeungekoke. Nane merau Neyae Allahlera nda kani kelare meke benen bukensinde Allahle bokore yae ende naeise Yesus naeisaei. ");
INSERT INTO set_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ramande anewate anuwaunge Yesus aunguke moi malo keuboke bu hobei naei malo yae na hehaei ranne heuboke. ");
INSERT INTO set_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nebeisa bu anuwau mbainye rileuboke na moisa orowate yore huba raweuboke oro bune koimaeyeumi, malo hehaei rande ikileuboke yae norona bure hobeumaeyeumi. ");
INSERT INTO set_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Meke Simon Petruslene mo, Yesusre weunge, “Tuhan, na man ban sele Weyae lon mae raei orore bu kuyeufekondere!” ");
INSERT INTO set_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesus yae weunge, “Nda heena me u mokawale weyae isaeyeiboi, ya hire weyae isaeyeubonde.” ");
INSERT INTO set_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petrus yae Yesusre weunge, “Tuhan, raei oro weyae bu ekuyeijae hele!” Nebeibe Yesus yae weunge, “Reyae waei oro bu ekuyeikoinya, Raei orale wali nibine wangkele ban.” ");
INSERT INTO set_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Petrus yae weunge, “Tuhan, nebei wanenna raei oro mo ban nane merau me bele yun bele nemene kuyeiseko!” ");
INSERT INTO set_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesus yae Petrusre weunge, “Ro miyae naei uwa bure koiboyole kiyae na uwa nemene ninae yoloiboyole. Nebeinye benen nare bu ekuyei. Noro fen mo kuyennekonde. Mayae yolauboke yo, nebeibe nemene ban.” ");
INSERT INTO set_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Nauware kelai nenende kiyae isaeyeubokene, nda a eleukoke, “Meyae ninae yolauboke, nebeibe nemene ban.” ");
INSERT INTO set_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesus nda yo naei oro bu kuyeumikoke baeufoke mo, na malo hireukokera benen nekewole anuwaunge eunguweuboke. Nebeisa mo weumi, “Naendae wanen, nda me u ma manemfa mare mokombokamale isaeyaeuboke? ");
INSERT INTO set_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mayae Rare Guru yae Tuhan mae kaenaufe. Mai a na ijenbe waufe, Reyae Niyae. ");
INSERT INTO set_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Reyae mai Guru bele Tuhan bele Kiyae yae moro bu kuyeukokamalene, mayae nebei sului mbai yae maise naeise oro bu kuyemembe. ");
INSERT INTO set_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Reyae nda me u mare kelaemale. Reyae mokoubokale hului nebei bune wane hamennele mokomembe. ");
INSERT INTO set_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nda a faeu nana heselebe wamale, yebaei bubaei ro ban nekate, naei yun ro bele. Nane merau ukeunge ende kiyae naei anuwau bumana hele, eke elele kiyae naei anuwau ana hele. ");
INSERT INTO set_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nda wamale nemene maisaeinye mayae emmokombena, mai naeise foi sele rambun benate.” ");
INSERT INTO set_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Yesus benen weumi, “Reyae elerekonde a mayae nemene naei ban. Reyae mare eleubokamale, mai wali ma raeisaei. Nebeibe Allahle homofaena molaikokere na hului yembondere nda rambun bende, ‘Rangkele nanembainye eramande anande kiyae oro seme kaembonde nebeisa oro yae elensehande’ ((wanen Rare kelaise nenende)). ");
INSERT INTO set_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nebei rambun embendene Reyae Wali Ondofolo yeubokalere na hele yae emelembe naeise, nda hee nebei naeise eyeiboi mo yae Reyae mare wamale. ");
INSERT INTO set_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nda a faeu na helebe wamale, nde Reyae ufende ende ro miyaere ei anebondena, neyae Rare ei haweufe. Nane merau nde Rare ei hawensele kiyae, neyae ukeufele mekale Kiyaere eibe haweunge.” ");
INSERT INTO set_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesus nda a faeufe eleukokera wa na kenara beko hele hubawounge. Nebeisa weumi, “Nda a faeu na helebe wamale, mai nolora ro mbai Raei kelai nenende.” ");
INSERT INTO set_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Naei moisa orowate yo ijoko na ure-ure erewate fa yae bowate, onewate ndele abe elele. ");
INSERT INTO set_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Reyae ((Yohanes)), Yesus kena buhae heufe kiyae, Yesusle bokone nuweubokale nekewale. ");
INSERT INTO set_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Petrus rare me yae isaei ikeufe Yesusre hinerensindere, “Ndebe naei sele Yesus elele?” ");
INSERT INTO set_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Reyae Yesusle bokore nakeleufikale mo hinanale, “Tuhan, naei sele nde?” ");
INSERT INTO set_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesus yae weumi, “Reyae feu bu kolaeinye yaufehindera isende ro, nebei kiyae niyae.” Nebeisa Yesus feufe mo rouke nebei bu kolaeinya einye yaweufike mo, Yudas Iskariot Simonde kelure ikeungele. ");
INSERT INTO set_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yudas feufe mo me ikileuboke bae, walobo yun na kena einye eweufike. Yesus yae weunge, “Waei benere nekete rambun hasale yae mokoibo!” ");
INSERT INTO set_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nebeinye ramanne nuwaikoke anewate yo hi yae ha yae isaeyeiboi sele rahene Yesus nda a ma faeu ma haraungeboke Yudasre ukeunge. ");
INSERT INTO set_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yudas nebei holona roi kayaa hebele kiyae. Nebei aerene hiwa yo yae Yesus nda a mekai haraungeboke ukeungele eraman bulau naei raman bele roi yae rowende naeise yae u benera nekaimi, nebei banna kounga kalonare yeumikonde naei abe weunge era na u benera nekaimi. ");
INSERT INTO set_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yudas nebei feufe mo rouke na hibi aloungekoke eukuke. Nebei hee reniai yeuboke. ");
INSERT INTO set_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudas eukuke ewole mo, Yesus yae weumi, “Reyae Allahle bokora mekale ro miyae uware yeubokale Kiyae hili hebenaisele nane merau Allahre Raei walora hili hebenainyele naei hee hubabe raweuboke. ");
INSERT INTO set_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Allahre Raei eisa hili hebenainyelena, nebei sului mbai Rare Allah Naei eisa hili hebensele, nane merau na hibi mokombonde. ");
INSERT INTO set_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Mayae Raei kelu omi wanen yo, Reyae mangkele heki enekeikoi sului. Mayae Rare baensekombe, nebeibe Reyae Yahudi ro miyaere weumikokale a mbaibe benende mare wamale, Reyae erele anuwau mayae nebeise emei sului. ");
INSERT INTO set_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Reyae nda a eme mare ufembe, maise naeise kena buhae u buhae eise meise hembe. Reyae mare heyamale wanen mbai maise naeise hemmiyembe hele. ");
INSERT INTO set_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Maise naeise kena buhae hemembe walora ro miyae hiwa naeisaei inyaibonde mayae Raei moisa oraube yo.” ");
INSERT INTO set_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Petrus yae Yesusre weunge, “Tuhan, Weyae makeise elere?” Yesus yae weunge, “Reyae erele anuwau nda hee weyae Raei moisa ehakoiboi sului. Nebeibe bena ya fokehonole Raei moisa eufehakoubonde.” ");
INSERT INTO set_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petrus yae benen hineunge, “Tuhan, rahe lonne nda hee yae waei moisa ehakoiboi sului yae warae? Waei aerene honaisebondena reyae be hinale.” ");
INSERT INTO set_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesus yae weunge, “Nana hesele weyae Raei aerene herelere kena koyae? Nebeibe Reyae nda na helebe wawale, ojo mukuu roko name a okoikoi mo, weyae Raei naeise roko name eleukonde, ‘Nare onaenaele.’ ” ");
INSERT INTO set_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesus yae weumi, “((Reyae erelere wamalene)) mai kena u isasa alalo okoijae hele. Allah Naei a elelere mayae hila rabo haleyaunge. Nebei mekai mbai Raei a elalere hila rabo halensele. ");
INSERT INTO set_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Maekole imae ei obe ei nekei-nekei anuwau helen ekaisonate. Nebei anuwau u yae rahe londe Reyae a yaka faeu yaka yae mare wemele? Mayae ennekembe anuwau mokoisaise Reyae Maekole bokore erelere. ");
INSERT INTO set_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Mayae ennekembe anuwau mokorensandera, Reyae benen berehonde merele. Rabuhine ban Reyae erenekende anuwaufe yawerembombe emale mangkele nebeinye nanembainye emanekende naeise. ");
INSERT INTO set_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Reyae erele anuwau mayae nebei anuwaufe eke nibi maisaei yaeuboke.” ");
INSERT INTO set_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas yae weunge, “Tuhan, Weyae ele anuwau meyae maeisaei ban sele lonbe. Naendae mekai yae nebei anuwaufe eke nibi meyae isaeimabonde?” ");
INSERT INTO set_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesus yae weumi, “Reyae Allahle bokore eke nibi Kiyae bele na hele no wali no. Ro miyae Raei walora mo Ako Allahre ronainyebonde, nibi hi u hele. ");
INSERT INTO set_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Rare ro raufeboube yae mayae nane merau Maekore ro raungeboube. Nda heera mayae Maekore ro raungeboke nane merau Nare eraungeboke.” ");
INSERT INTO set_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipus yae weunge, “Tuhan, Ako Allahle uwa maere kelemebomae. Nebei na hului yae elande.” ");
INSERT INTO set_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesus yae weunge, “Filipus, heki hele maengkele nanembaisa orandeke nebeibe Rare oroiboi a lon mae weyae eleyae! Nde yae Rare ijoko ereufekokena nebei kiyae Ako Allahre ijoko erekeunge. A koro mahi lon weyae warae, ‘Ako Allah maere keleimebo!’ ");
INSERT INTO set_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Reyae Maeko Allahle einye nane merau Maeko Allah Raei einye elale are na helere eleikoi koyae? Reyae wamale a faeu Raei u benena a faeu ban. Naeinya hesele Maeko Allah Raei uwa einye nekele Kiyae nebei rambun emere-emere mokole. ");
INSERT INTO set_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Reyae Maeko Allahle einye Maeko Allah Raei einye naeise Reyae wamale are hila rabo halembe. Nda a wamale aerene na hele eleikoinya, rambun emere-emere Reyae mokale eraube aerene nebei are na hele elengko. ");
INSERT INTO set_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Reyae nana heselebe wamale, nde yae Raei a elalere hila rabo haleufe kiyae, Reyae rambun emere-emere mokale ma na hului emmokonde. Raei mokalera neyae emekai bele emmokonde, rabuhine ban Reyae Maeko Allahle bokore erelerene. ");
INSERT INTO set_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nane merau rahe rambun aerene mayae Raei Ro eisa yae Maeko Allah riyennelena, mai rambun riyembe huluinye Reyae mokorebonde. Nebei nibi yae Raei walora Maeko Allahre hili enainyehebende. ");
INSERT INTO set_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Rambun nemene mayae Raei ro eisa riyembena, Reyae mokorembonde. ");
INSERT INTO set_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Mayae kena buhae Rare henselena, Raei wamale a huluinye hakombombe mokombe. ");
INSERT INTO set_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Mare holenemembe Ro hi Kiyae Ako Allahre riyerensinde, Neyae mare inyembe. Nebei Kiyae yae mare huba ban haei ban holenemembe naeise. ");
INSERT INTO set_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Neyae Allahle Roh, na hele no Kiyae. Nda kani kelana wali beko nibine orate ro miyae nebei Roh Kiyaere ei ehawei sului, rabuhine ban nebei holona yo Nare ereiboi nane merau ro oroiboinye. Nebeibe mayae nebei Kiyaere ro raungeboke, rabuhine ban Neyae mangkele nekaube nane merau mai einye Neyae ennekende. ");
INSERT INTO set_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mare ako ban nake ban fa-fa wanen nekembere Reyae ewaeisi. Reyae erelera benen mai bokore berehonde merele. ");
INSERT INTO set_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Na heki ban mo nda kani kelana wali beko nibine orate yo Rare benen ereiboi, nebeibe mayae na hului Rare enserembe. Reyae wali hena bona bele nekalene, mayae nane merau wali hena bona nekemembe. ");
INSERT INTO set_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nebei hee yae mayae isaeyembombe Reyae Maekole einye nekale nane merau mayae Raei einye nekaube, Reyae maei einye nekale. ");
INSERT INTO set_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nde yae Raei a elale boronde mokonde kiyae, Rare kena buhaebe heufe. Rare kena buhaere hensele kiyaere Maeko kena buhae ennehende. Reyae nebei sului mbai nare kena buhae herende nane merau Raei uwa naeise kelerembonde.” ");
INSERT INTO set_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yudas Iskariot nakobae Yudas yae Yesusre hineunge, “Tuhan, rahebe bewatene nda kani kelana wali beko nibine orate ro miyae Wauwa eyakaiboi, maere mo yakaumebondere?” ");
INSERT INTO set_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesus yae weunge, “Rare kena buhaere haeise ro miyae, Reyae kelaemaele a usaei wasaei huluinye hakonde mokonde. Maeko nebei kiyaere kena buhae hennele. Meyae nebei kiyaele bokore ale, nanembainye emanekende. ");
INSERT INTO set_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nde yae Rare kena buhae eheinya nebei kiyae Reyae kelaenale a usaei wasaei huluinye omokoi yae nekende. Nebei ako faeuko huwamale boraube Raei kenara ban, nebeibe Rare ukeufele mekale Maeko Allah Kiyaelena. ");
INSERT INTO set_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Reyae namman mangkele nanembainye nekande hee yae nda a nanemene wamale. ");
INSERT INTO set_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nebeibe Ako Allahle Roh, mare holenembe Kiyae, Raei Ro yae wennele mende. Nebei Kiyae yae mare kelenembe nane merau mokonembe Reyae kelewamale a usaei wasaei nanemene mai u benene nekenayembe. ");
INSERT INTO set_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Reyae rei mai onomi foka mai kena einye nukamale. Rei mai onomi foka Raei uwana bele ma yae yaemale. Reyae yaemale rei mai onomi foka nda kani kelana wali beko nibine orate ro miyae yae yayembe wanen ban. Mai kena u isasa alalo okoijae, buhae ohokoijae. ");
INSERT INTO set_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Mayae borowaube Reyae nda abe uwamale, Reyae erele nebeibe mai bokore berehonde merele. Mayae na hele Rare kena buhae henselena, Reyae nda hee Ako Allahle bokore erelerene mayae rei mai engkombe, rabuhine ban Ako Allah buma reufina, Reyae ana. ");
INSERT INTO set_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nanemene namman eyeiboi yae nda a uwamale. Nebei nibi huluinye enaibende hee, Rare hila rabo ensehalembe. ");
INSERT INTO set_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Benen ebi fere mo Reyae mare kelerembe, rabuhine ban nda kani kelana wali beko nibine orate ro miyae naei yun melene. Nebeibe Raei uwara nebei kiyae elae ban sele. ");
INSERT INTO set_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Nebeibe na man sele nda kani kelana ro miyae isaeinyate Reyae Ako Allahre kena buhae haenale nane merau Ako Allah ukeufe huluinye nanemene mokale.” Yesus yae weumi, “Raei a elale hubabe mokanale. Mayae annu, eyae nda anuwaufa alomangkonde emalere.” ");
INSERT INTO set_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","((Yesus yae anggur o ha bele Naei wali nibine oronate yo naei wali ma bele a ahuneuboke.)) Neyae nda wanen huwewoumi, “Anggur yoni-yoni maensa akaufe rorokate ekate na no hele Reyae Niyae. Maeko anggur no melemere raufike, holele, narele Kiyae Niyae. ");
INSERT INTO set_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Raei uwane roraikoke maensa akau anire omokoi yo Maeko yae folongkonde. Ani wang-wang mokonate naeise, anire kate maensa akau Neyae faeinyemmibonde. ");
INSERT INTO set_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Reyae kelewamale a walora mare faeinyembokamale. ");
INSERT INTO set_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nebeinye, mayae Rangkele mbainye nane merau Reyae mangkele mbainye nekemale. Anggur no hebelene ororoiboi maensa akau nenaei ani omokoi sului, roraiboke maensa akau mo ani kate. Nebei sului mbai Rangkele mbainye enekeinya mayae anire omokoi sului. ");
INSERT INTO set_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Reyae anggur no niyae, mayae maensa akau. Nde yae Rangkele mbainye nane merau Reyae nangkele mbainye nekale kiyae, ani wang-wang engkonde. Rabuhine ban Raei uwane ororoiboinya, mayae rambun mbai omokoiboi sului. ");
INSERT INTO set_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nde Rangkele mbainye enekei kiyae, maensa akau kikauboke wanen yeuboke. Nebei maensa heke ele moinye hayaete kala-kala baete. Nebei wanen maensa akaufe ro miyae yae arilenaisinde italo ranne hainyaikonde benate. ");
INSERT INTO set_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Rangkele mbainye nekemalena, nane merau Reyae huwamale a usaei wasaei hubara haeise yanembena, kenare kaube rambun Maekore riyennele hului mare inyembe. ");
INSERT INTO set_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mayae ani helen emmokombena, Maekore hili enainyehebende. Mai me u mokaube yae emmiyakambe mayae Raei moisa hakaufekoke maube yo. ");
INSERT INTO set_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Maeko yae Rare kena buhae heimeyeufe wanen mbai Reyae naei mekai mare kena buhae heimeyamale. Nebeinye mai wali Reyae kena buhaere haemale holona yo naei u mekai ma wanen mae nekembe. ");
INSERT INTO set_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Maeko weufe are Reyae hubara haeisa yananalene, Maeko Rare kena buhae heufe einye namman nekale. Nebei sului mbai Reyae wamale a hubara haeisa yanennelena, Reyae kena buhaere haemaele ma yae nekemembe. ");
INSERT INTO set_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Raeinya rei mai mai kena ei u einye hubannele nane merau mai kena ei u einye rei mai melei-melei emmelende naeise nebei a Reyae mare isaeyaemale. ");
INSERT INTO set_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Reyae wamale a nda niyae, Mai holona yore hi yae hire kena buhae hennele, Reyae mare kena buhae heimeyamale wanen mbai. ");
INSERT INTO set_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ro miyae mbai na kena buhae emekai bele kiyae, kena buhaere heumi holona yo aerene naei walire hole omoloi. ");
INSERT INTO set_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Reyae wamale a hubara haeisa yanennelena, Reyae kena buhaere haemale yo yae mare me baerele. ");
INSERT INTO set_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","“Mare benen Raei yebaei bubaei yae ekaenei. Rabuhine ban rowa mbai naei uwa naei are na yebaei bubaeise ehuweikoi sului. Nebeibe mare kena buhaere haemale holona yae Reyae kaenamale, rabuhine ban Maeko yae elewole a nanemene Reyae borowale hului mare nebei abe isaeyaemale. ");
INSERT INTO set_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mayae Rare elaeufeboke ban nebeibe Reyae mare elembokamale, Raei holona yae me baemale. Reyae mare ukamale embe kakare eyeiboi ani foibe helen emmokombe. Nebei u mekai mokembena, rambun Raei Ro yae Ako Allahre riyennele yoni-yonire Neyae mare inyembe. ");
INSERT INTO set_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nda a Reyae elae yae wamale, maise naeise kena buhae hennele. ");
INSERT INTO set_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Nda kani kelana wali beko nibine orate ro miyae mare ikele konayembena, maisaei nekembe nebei yo na bere Rare ikele kowaise. ");
INSERT INTO set_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Mayae nda kani kelana wali beko nibine orate holona yo yae me baeyembena, naei holonane mare kena buhae henayembe. Mayae nebei holona yo naei ban nebeibe Reyae mare elembokamalene, nebei wali beko nibira wekaunge. Nebei aerene wali beko nibine orate yo mare ikele kayembe. ");
INSERT INTO set_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Reyae uwamale are bene foi yae nekenayembe. Yebaei bubaei yoni-yoni na rowale na metete ban. Wali beko nibine orate yo hiwa Rare weitasi kowaisene, nebei wanen mbai mare weitasi konayembe. Ro miyae hiwa Raei ako faeuko huwamaele huluinye hakowaisene, nebei wanen mbai mayae huwembe are hakonate. ");
INSERT INTO set_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Reyae Wali Ondofolo yeubokalere mayae na hele elaube aerene nebei yo yae mare u mekai beko mokonayembe, rabuhine ban Rare ukeufe mekale Kiyae nda yo yae oroiboinye. ");
INSERT INTO set_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Reyae ndare emei yae nane merau nda holona yore Allahle wali nibi naeise eweikoi yae, nebei ro miyae me beko u beko bele yo yae me ebaeiboi. Nebeibe nda hee nebei ro miyae naei u mekai beko bako mokatera weyei naeise a ban. ");
INSERT INTO set_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nde yae Rare ikele konselena, Maekore ikele kounge. ");
INSERT INTO set_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nebei holona yo nolone ro hi miyae hi yae roko mbai omokoiboi sului rambun Reyae omokoikoinya, nebei holona yore u beko bako bele yae me ebaei. Nebeibe nda hee rambun emere-emere mokowale nanemene nebei ro miyae erewate hororebe, nebeibe neyae Rare ikele kowaise nane merau Maekore ikele kowainye. ");
INSERT INTO set_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nebeibe Rare nebei holona ro miyae ikele kaise yae wali heere foloukoke homofae a naei naeise na hului yeuboke. Nebei homofae nda wanen molaikoke, ‘Nda yo aere ban mae Rare ikele kaise.’ ");
INSERT INTO set_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Mare holenemembe Kiyaere Reyae Maekolera mai bokore ufende mende. Nebei Roh na hele no yeuboke, Maeko wennele abe mokole. Nebei Roh yae Raei naei a isaeinyemile. ");
INSERT INTO set_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mayae naei mekai mbai ro miyae nanemenere Raei naei a isaeinyemile, rabuhine ban mayae na bemere hele kaenengkokamale homo mbainye orandeke nekande aerene. ");
INSERT INTO set_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Raei wali nibira wemembe belene, nane a nemene Reyae huwamale. ");
INSERT INTO set_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Mare Allahle ei mom-mom imaera hukenayembe. Na ya bele mensembonde ro miyae mai holona yore honatene, na uwa hubannele Allahre foibe mokounge. ");
INSERT INTO set_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nebei holona yo Ako Allahle Rangkelere ro oroiboi aerene nebei u mekai ma mokonate. ");
INSERT INTO set_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nebei a wamale hului enaibendene, mayae bene nekenayembe Reyae nebei a mare wengkokamale naeise, Reyae nda hee yae nebei are mare wamale. Mayae namman homo mbainye Rangkele orowandene, nebei benate naei a faeu Reyae mare na bere holo yae ehuweikoi. ");
INSERT INTO set_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nebeibe nda hee Rare ukeufe mekale Kiyaele bokore erelere. Mai nolona hi yae Rare ehineisi, ‘Makeise weyae elere?’ ");
INSERT INTO set_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Reyae a wamale aerene mayae kena beko u beko kaube. ");
INSERT INTO set_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Na helebe mare wamale, mai foi naeisene Reyae erelere. Rabuhine ban Reyae einya, mare holenembe Kiyae mai bokore emei sului. Nebeibe Reyae erelena, nebei Kiyae Reyae ufende mai bokore mende. ");
INSERT INTO set_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Neyae mende heena nda kani kelana wali beko nibine orate ro miyae naei kena einya nda naeise isaeyemmile: naei me u beko mokoimeyate naei, wali na helere haranainyende naei, walire hului emmikolonde naei. ");
INSERT INTO set_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Allahle Roh nebei holona yore me u bekobe mokate naeise isaeinyemile, rabuhine ban Raei a elalere hila rabo ehaleinye. ");
INSERT INTO set_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Allahle Roh nebei holona yore Reyae wali himaloungeboke yae nekewale naeise isaeinyemile, rabuhine ban Reyae Maekole bokore mekalene benen berehonde erele mayae Rare ereiboi sului. ");
INSERT INTO set_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Allahle Roh nebei u mekai beko bele holona yore Allah naei walire hului emmikolonde naeise isaeinyemile, rabuhine ban walobo yun nda kani kelana wali beko nibine orate yo naei yun kiyae Allah ehee bukulu wokeungene. ");
INSERT INTO set_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Raeinya a helen sele mare ufengkomberebe, nebeibe nda hee mayae onembe handambe belene, Reyae ehuweikoi. ");
INSERT INTO set_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nebeibe Allahle Roh, na hele no Kiyae mende ya wa, Neyae na hele wali nibine yawenembe. Rabuhine ban Naei uwa naei abe elei, nebeibe a wennele Kiyaelena boronde abe enelende. Nane merau bena yane enaibende naei Neyae mare isaeinyembe. ");
INSERT INTO set_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Neyae Rare hili ensehebende, rabuhine ban Raeisa yarongkondebe mare isaeinyembe. ");
INSERT INTO set_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Maekole me einye honainye rambun yoni-yoni nanemene Raei bangka mo. Nebei aerene Reyae wamale, nebei Roh Raeisa yarongkonde huluibe mare isaeinyembe. ");
INSERT INTO set_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ya na heki ban mo erelerene, Raei be ijoko mayae erei nekembe, nane merau ya na heki ban mo mayae benen Raei be ijoko enserembe.” ");
INSERT INTO set_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Nebei a ma borowatene Yesus na moisa orowate hiwa yo naeise naeise hinate, “Neyae nda a eleukoke, ‘na heki ban mo Raei be ijoko mayae ereiboi benen ya na heki ban mo benen Raei be ijoko mayae enserembe,’ nane merau, ‘Reyae Maekole bokore erelere.’ Rahe mekaibe elele ban?” ");
INSERT INTO set_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Na hibi mo nda yo naeise naeise hinate rahe naeibe Yesus yae a yae haraungeboke weume, “Ya na heki ban mo.” Neyae onaete hele. ");
INSERT INTO set_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesus naeisaei nda yo onaeitene kena kate Nare hinenainyehindere. Nebeinye Yesus yae weumi, “Reyae a eleukokale, ya na heki ban mo Raei be ijoko mayae eyerei nane merau ya na heki ban mo benen Raei be ijoko mayae enserembe. Nebei a haraungebokale wamalebe mai nolone hi yae hire hineunge? ");
INSERT INTO set_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Na helebe Reyae wamale, Nda kani kelana wali beko nibine orate ro miyae na kena rei mai sele enainyehubande, nebeibe mayae kena beko u beko hubannelene rime nei-nyei engkombe. Nebeibe mai kena beko u beko engkombe embaensonde hee mayae kena rei mai menjembombe hubannele. ");
INSERT INTO set_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Miyae mbai fare honondere hiyau kole hee kena beko u beko hubaunge. Nebeibe fa honolera na kena beko u beko haneikoyeunge, rabuhine ban ro miyae mbai nda kani kelane hongke, rei mai yae na kena aungebokene. ");
INSERT INTO set_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mayae nebei sului mbai, nda hee mayae kena beko u beko yae ambokembe kaube. Nebeibe Reyae berehonde merele mangkele benen hubaimakondene, mai kena u rei mai ennehubambe. Nebei rei mai ro miyae hi yae mai kenara einyukeisai sului. ");
INSERT INTO set_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nebei yara rambun yoni-yoni benen Rare eriyeyei. Na heselebe Reyae wamale, Raei Ro eisa riyennele rambunde Maeko mare inyembe. ");
INSERT INTO set_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mayae roko mbai Raei Ro yae Maekore eriyeisi mo nekeimeyaube. Rambun riyenne, mayae enjarombe. Nebei mekai yaere mai kena einya rei mai ennehubambe melei-melei enaimelende. ");
INSERT INTO set_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Nda are nanemene Reyae a ahumbo-ahumbo yae mo mare huwamale. Na ya bele mensembonde Reyae a ahumbo-ahumbo yae benen mare ehuwei. Nebeibe Maekole u mekai naeise na yaka-yaka yae mare hufembe. ");
INSERT INTO set_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nebei heera mayae Raei Ro eisa rambun riyennele, nebeibe benen mai naeise Maekore erendiyendere Reyae a elei. ");
INSERT INTO set_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Mayae Rare kena buhae haeufe nane merau Reyae Maekole bokora ukeufe mekalere mayae na hele yae elaube aerene Maeko Nenaeijae mare kena buhae hembe. ");
INSERT INTO set_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Reyae Maekole bokora nda kani kela eise mekale. Nda hee Reyae nda kani kela nukerebonde, mekale anuwau Maekole bokore benen berehonde erelere.” ");
INSERT INTO set_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Na moisa orowate yo yae Yesusre wainye, “Nda hee ya wa na yaka-yaka yae weyae wamae, a ahumbo-ahumbo yae ehuwei. ");
INSERT INTO set_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nda hee yae wa meyae isaeyaendeboke Weyae benate rambun waeisaei bangka mo. Ro miyae u bene nekaime rambun Weyae waeisaei mo, erabae nebei ro miyae Ware a ehineikoi. Nebei mekainye Weyae Allahlera mekae naeise na hele yae elande.” ");
INSERT INTO set_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesus yae nda yore weumi, “Nda hee mayae nebei are hila rabo halaeufe! ");
INSERT INTO set_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nebeibe nda hee mare here ware ungayembe yabe meufeuboke. Maise naeise mewaube imae obere yae bukembombe embe, nane merau mayae nukensebombe Renaei mo nekerele. Nebeibe Rembai ban, rabuhine ban Maeko Rangkele mbainye nekende. ");
INSERT INTO set_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Mayae rei mai onomi foka Raei einye enjarombe naeise Reyae nane a nanemene mare isaeyaemale. Nda kani kela einye me beko u beko hubannele, weitasi konayembe. Nebeibe mai kena u elae hebembe, rabuhine ban nda kani kela beko mere nulaiboke yo meleumihakamaele.” ");
INSERT INTO set_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nebei a usaei wasaei huba mokoungekokera, Yesus yakure yae be weuweke wa elele, “Arai, nda hee na ya na hului meujeuboke, Ako Reyae Wa Kelu Niyae Ware hili ereisebeite naeise Rare hili hebeise! ");
INSERT INTO set_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Rabuhine ban Weyae kinyewarae ro miyaere wali hena bona isemile naeise Weyae Rare elae ikarae ro miyae nemene fomene mere mokoremile. ");
INSERT INTO set_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Wali hena bonana u mekai nda niyae: Weyae Allah hele mbai mo rore ronayete nane merau Yesus Wali Ondofolo, Reyae Niyae, Weyae ukarae mekale Kiyae rore ronaisele. ");
INSERT INTO set_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Arai, Weyae ukarae kalia Reyae riyau weubokale walora nda kani kela ranne Ware hili hebawale. ");
INSERT INTO set_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Arai, nda kani kela omokoi heene Waei bene Reyae nene waewae bele hebewale. Nda hee Wa kendan wameran bene nebei nene waewae mbai bele yae buma kaeisebo. ");
INSERT INTO set_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Arai nda kani kelana Rare kinyewarae ro miyaere Waei u mekai isaeiwamaele. Nebei yo Arai mere mokamae holona nebeisa Rare kinyeufebokae. Nebei holona yo Waei ako faeuko wamaele huluinye hakoimeyate. ");
INSERT INTO set_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Neyae nda hee yae wa isaeyaeiboke Rare iwarae rambun nanemene Arai Waeisa bangka mo. ");
INSERT INTO set_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Arai, Waei ako faeuko Rare ukarae hufemilere na hului weumikokale. Nebei holona yo Waei ako faeukore hila rabo halewate nane merau Reyae Waei bokora mekalere isaeyaeiboke. Nda holona na hele yae elate, Arai, Weyae Rare ukarae nda kani kelare mewale. ");
INSERT INTO set_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Arai, Raei ebeli Ware bawale nda kani kelana wali beko nibine orate ro miyae naei ban. Naeinya hesele Rare kinyeufeboke ro miyaere ebeli bawale. Rabuhine ban nebei yo Arai Weyae mere mokamae holona. ");
INSERT INTO set_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Rare kinyewarae yoni-yoni Arai Waei bangka mo. Arai, Weyae mere mokamae holona Raei bangka mo. Nane merau nebei yo eisa Arai Rare hili hebarae. ");
INSERT INTO set_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nda hee Reyae nda kani kelara Waei bokore erelere, Rare kinyewarae holona ndane nukeremibonde nekenatere. Arai nene waewae bele Kiyae, nebei ro miyaere Waei Ro walora ei haweumile. Waei Ro eisa elae Weyae Rare ikaerae. Wangkele Rangkele mbainye nekende wanen nebei holona yo mbaise nekenate naeise Waei Ro eisa elae yae ei haweumile. ");
INSERT INTO set_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nebei yo bele mbainye nekewande hee, Arai Waei Ro elae yae Rare kinyeufebokae yae nebei ro miyae hole moloumiyekale, kayaa hebeumiyekale. Yudas Allah bele waheneikonde kiyae mo Reyae hole omoloi. Nebei mekai yaere Waei homofae molaikoke abe na hului yembonde. ");
INSERT INTO set_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Nda hee Reyae Waei bokore male. Raei rei mai naei uwane melei-melei eremimelende naeise, Rare kinyeufebokae yo bele mbainye nekewande hee nane a weumi. ");
INSERT INTO set_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Arai, Waei ako faeuko nebei yore Reyae weumikokalere aisakoukokene, nda kani kelana wali beko nibine orate yo yae nare ikele kaimi. Rabuhine ban Reyae nda kani kelana wali beko nibine orate holona ro miyae ban nane merau nebei holona yo nebei sului mbai nda kani kelana wali beko nibine orate holona ro miyae ban. ");
INSERT INTO set_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Arai, nebei holona yo nda kani kelara yaroukonde naei abe Reyae riyawale ban. Nebeibe Raei ebeli bawale nebei yo hole moloumile, u mekai beko yae walobo yun beko emmimokombonde belene. ");
INSERT INTO set_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Raeinya wanen nebei holona yo nda kani kelana wali beko nibine orate holona yo ban. ");
INSERT INTO set_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Arai, Waei u mekai wanen nebei holona yore Waei ako faeuko yae na u mekai yolo-yolo mokoumibo. Waei ako faeuko na hele no. ");
INSERT INTO set_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nda kani kelare Arai ukarae mekale wanen, Reyae nebei holonare ukamaele nda kani kelana wali beko nibine orate holona yo nolore enatere. ");
INSERT INTO set_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nane merau nebei holona aerene Raei u mekai yolo-yolo yae nekerele Waei u mekai wanen mbai. Nebei mekai yaere nebei holona yo naei u mekai Aei hului mbai yae nekenate. ");
INSERT INTO set_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Arai, Reyae Ware bawale nebei holona yo naeise mo ban. Nebeibe ro miyae Raei naeise hungatene hiwa yo Rare hila rabo halenaisele yo naeise bele ebeli bawale, ");
INSERT INTO set_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","nebei yo nanemene mbaise inyaibondene. Nda kani kelana wali beko nibine orate ro miyae na hele yae elenate, ‘Weyae Rare ukarae nda kani kelare mekale’ naeise, Arai Weyae Raei einye nekeyae Reyae Waei einye nekale wanen mbai nebei yo bele Aei einye nekenatere waeimihi. ");
INSERT INTO set_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Eyae mbaise yendeboke wanen nda yo mbaise inyaibonde naeise, Arai Raei nene waewae kiteufebokaebe nda yore kinyewamaele. ");
INSERT INTO set_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nebei holona yo u bene mbai mo nekenaimile nane merau wali nibi mbai mo oronate naeise, Reyae naei einye nekerele Weyae Raei einye nekele. Nda nibi yae nda kani kelana wali beko nibine orate ro miyae isaeinyaibonde, Weyae Rare ukarae mekale nane merau isaeinyaibonde, Weyae Rare kena buhae haerae wanen Rare kinyeufeboke yore kena buhae haemaele. ");
INSERT INTO set_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Arai, nda kani kela omokoiboi heena Weyae Rare kena buhae heufekokaene nene waewae bele kiteufebokae. Rare kinyeufebokae holona yo, Reyae erenekende anuwaunge nanembainye emanekendere nane merau nda holona yo Raei nene waewaere ijoko enayerendere kena kale. ");
INSERT INTO set_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Arai, Weyae wali himaloungeboke Kiyae nda kani kelana wali beko nibine orate ro miyae Ware oroiboibe, nebeibe Reyae Ware rore roubokawale. Nda ro miyae isaeyaeiboke Arai Weyae nda kani kelare ukarae mekale. ");
INSERT INTO set_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Waei kena buhae Rare haerae wanen mbai nebei yore Weyae kena buhae heumile naeise nane merau Reyae naei kena u einye nekerele naeise, Arai, Wa ro nebei yore isaeyeumibokale nane merau isaeisemile.” ");
INSERT INTO set_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesus Naeko Allahre ebeli boungekokera mo, na moisa orowate yo bele eramande anewate imaera maibaleke alainyekoke Kidron wi reufire ekate. Nebeinya o ha zaitun heke mbainye Yesus na moisa orowate yo bele ayeuboke. ");
INSERT INTO set_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yudas, kelai rorele nebei anuwau naeisaei, rabuhine ban Yesus na moisa orowate yo bele roko helen nebeinye eyarilesiyate. ");
INSERT INTO set_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nebei anuwaufe Yudas yae felayo homo mbai bele imam yun-jun bele Farisi bele yae ukaimile abu ako yo belere yaweumiboke. Nebei homona yo yae kaijeu wa isehe roraiboke bele na fela menda bele yaraikoke ewate. ");
INSERT INTO set_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesus na uwa ranne benate naeise isaeyeubokene, nebei yo naei bokore yae eunakeleufike mo hineumi, “Mayae ndere baeimeyaunge?” ");
INSERT INTO set_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nda yo yae wainye, “Yesus, Nazaret yona ro.” Yesus weumi, “Reyae nda Niyae.” Yudas kelai rorele nebei nolone nangkele hebate. ");
INSERT INTO set_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesus ukeumi, “Nda Reyae Niyae.” Nebei hee nane yo moise yae kewainyele ane balewate. ");
INSERT INTO set_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Benen Yesus hineumi, “Mayae ndebe baeimeyaunge?” Nane yo yae wainye, “Yesus, Nazaret yona ro.” ");
INSERT INTO set_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesus yae weumi, “Reyae nda Niyae yae wamale. Mayae nana hesele Rare baeimeyaufena, hiwa yo waemmihi ai.” ");
INSERT INTO set_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Nebei a ma eleukoke na bere ukeumile a na hului yembonde naeise. Neyae nda a eleukoke, “Arai, Rare kinyewarae yo mbai sambai Reyae ewaeisi Rangkele ewaheikoi.” ");
INSERT INTO set_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Nebeinye Simon Petrus ramiyaeli bele rowewekene na ramiyaelire mo nokeyobouboke imam kaban na yebaei bubaeibe nangkaei meube reufibe neufake ruke. Nebei yebaei bubaei na ro Malkhus. ");
INSERT INTO set_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesus euweke Petrusre weunge, “Wa ramiyaeli na anuwaufe noinyo! Bu faere bele anerehinde wanen mae Maeko yae me u ehee bele ukeufe mokorebonde. Waei u bene nekayete nebei me u Reyae omokoi era?” ");
INSERT INTO set_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nebeisa nebei fela yun na keleena yo bele Yahudi yae ukaimile ekate abu ako yo bele Yesusre ikilaibokate ha yae na me rinainyekoke. ");
INSERT INTO set_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Na bere Yesus yawainyehoke Kayafas na miyae naeko Hanasle bere ekate. Nebei ralo yakama Kayafas imam kabande nekewole. ");
INSERT INTO set_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Na bere Kayafas mbai Yahudi yun-junde a usaei weumikoke, Na foi bele yo kaban yan kabande hole molombonde naeise karo ro mbai herende. ");
INSERT INTO set_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Petrus bele reyae Yohanes rangkele nanembaisa Yesusre hakannekoke ewande. Imam kaban rare naeisaeinye, rangkele yae Yesus yawainyehoke ewate, homo mbaisa imam kabanbe obere ayandeboke. ");
INSERT INTO set_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Nebeibe Petrus mbaibe moinye na romau kelaeunge hebewole. Nebeinye reyae moise eukukale, romau kayaare hebewole maengke fare a elendekoke mo, Petrus yaweungehokale eise endeuboke. ");
INSERT INTO set_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nda maengke fa Petrusre weunge, “Naendae wanen, weyae na hi ndi Ro naei moisa oraube kiyae niyae?” Petrus yae weunge, “Reyae niyae ban!” ");
INSERT INTO set_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nebei hee hin manse meungeke hubawainye, Allahle ei mom-mom imae kayaa yo bele nebei imaena yebaei bubaei yo bele italo kolaibokatene akelewate. Petrus nangkele nebei italo mbainye akelewate. ");
INSERT INTO set_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Imam kaban huba raweuboke na moisa orowate yo naei a bele naei meke a usaei kelewoumi naei a bele Yesusre hinewounge. ");
INSERT INTO set_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesus yae weunge, “Ro miyae nemene naei bene na yaka yae eyelewale. Yahudi ro miyae nanemene arileisiyele anuwau yoni-yonine keleyamaele. Allahle ei mom-mom imaene bele Allahre ei mom-mom imae na kaban sele kiyaene bele keleyamaele, nun-nun wanen mae eleikoi mo. ");
INSERT INTO set_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Naendae wanenne weyae Rare hinarae? Raei ako faeukore kelewamaele borowate yore hineimi. Neyae naeisaei rahe erabe elewekale.” ");
INSERT INTO set_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesus nebei a wanen eleukokene kayaare hebate nolora ro mbai Yesusre na bera mefae yae uke na a bele weunge, “Ae, mehinin ban sele ya, Weyae nebei wanen a yae imam kabande wanae!” ");
INSERT INTO set_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesus yae weunge, “Raei a faeu na ijen ban eleukokalena, na ijen ban kayeero keleisebo! Nebeibe Reyae na ijen nda a eleukokalena, rahene weyae Rare mefae yae ukarae?” ");
INSERT INTO set_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nebeisa Hanas ro miyaere ukeumile, Yesusre yawainyehoke, na me na ha rinaikoke bele yae imam kaban Kayafasle bokore yae ekate. ");
INSERT INTO set_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Petrus nane italo kelaeunge mo namman hebewole. Nebeinya ro miyae yae wainye, “Weyae nda Ro Na moisa oraube na ro hi niyae era?” Nebeibe Petrus isian mae eleukoke weumi, “Reyae niyae ban!” ");
INSERT INTO set_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Imam kaban na yebaei bubaei na angkaeise neufake kiyae yohona yae Petrusre weunge, “Weyae niyaebe ya? Zaitun heke einye ndi ro bele nanembembane erekawale hebewoube!” ");
INSERT INTO set_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petrus benen weumi, “Reyae ban ma.” Nebei haei yae ojo mukuu a koukoke. ");
INSERT INTO set_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Na rene kaukau hele Kayafasle imaera Yesus yawainyehoke gubernur imae einya are kolainye obere ekate. Yahudi ro miyae agama huluinye nauwa niki bele inyaibonde belene, nebei imae eise ei, rabuhine ban Paskah ya kabanna eraman bulau nangkele anenaikonderene. ");
INSERT INTO set_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nebei wanenne Pilatus moise eukuke hineumi, “Naendae wanen me u bekobe mokoubokene mayae nda rore ahunaunge?” ");
INSERT INTO set_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Nda yo yae wainye, “Arai Gubernur, Neyae beko omokoiboi yae bae rahe londe waei bokore yawannehoube mande?” ");
INSERT INTO set_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatus yae weumi, “Yawennoho, menaeijae embe hinennele. Mai wali heere foloukoke honole huluinye ehee bukulu yennele.” Nane Yahudi ro miyae yae wainye, “Nebeibe ro hoi-soise maere ewaeisi tonbe.” ");
INSERT INTO set_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nda wanen maere Yesus naei herende ma naei a eleukoke na hului yembonde. ");
INSERT INTO set_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatus are kolainye obere beufoke eke Yesusre kaeneungekoke mo hineunge, “Weyae na hele Yahudi naei Ondofolo?” ");
INSERT INTO set_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesus yae weunge, “Nda a ma faeu ma hinarae waei kenarabe hinarae, ro miyae hiwa yo yae Raei naeise ukayetene hinarae?” ");
INSERT INTO set_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatus yae weunge, “Weyae eraerae reyae Yahudi ban ro! Waei ro miyae bele imam yoni-yoni bele yae Ware raei me eise yae kinyaiseboke. Rahe me ube weyae mokoubokaene?” ");
INSERT INTO set_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesus yae weunge, “Raei yo waku nda kani kelana ban ma. Nda kani kelana yae bae, Rare Yahudi naei me eise kinyaiseboube aerene Raei holona yo han fela relaeinyele. Na hele Raei yo waku nda kani kelana ban, anuwau hina.” ");
INSERT INTO set_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilatus yae hineunge, “Nebei wanenna, Weyae Ondofolo era?” Yesus yae weunge, “Wenaeijae a ijenbe warae Reyae Ondofolo. Nebei aerene hongkaisele nane merau nebei aerene na hele naei are isaeisemibondere nda kani kelare mekale. Ro miyae na hele naei a isaeyaemaelere kena kate yo Raei a boraisele.” ");
INSERT INTO set_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatus yae hineunge, “Na hele naei a rahe era?” Nebei are mo hineungekoke, Pilatus imae eisa eukuke Yahudi ro miyaere weumi, “Reyae Naeinya beko mbai sambai ehubaikoi sele. ");
INSERT INTO set_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nebeibe mai era hena honoyelene huluinye nda wanen: Paskah ya kaban mae kawana hebate ro mbai reyae hayeikoyanale. Mayae kena kaube mai naeise reyae ‘Yahudi naei Ondofolo’ haisengkondere?” ");
INSERT INTO set_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Nebei yo kali ara nene kaenate wainye, “Neyae ban, maere Barabasbe hayeinyeko!” Barabas fa kangkin kowole ro. ");
INSERT INTO set_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nebeisa Pilatus eise eweufike ukeumile Yesusre rahuaere bonatere. ");
INSERT INTO set_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Felayo yae o isa bele na maensa yae ondofolo yoni-yoni hirate ma wanen fokoma wanen mbai mokaiboke roukate Yesus na yun danne obunainyeboke. Nebeisa malo fi kolei ma yae, nebei kanina ondofolo hirewate wanen, hirainyekoke. ");
INSERT INTO set_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Hi yae mele aukaka yae kounge ro melaeyeunge weunge: “Onomi foka, Yahudi naei Ondofolo!” Weyeunge rombae na mefae bele eiwele. ");
INSERT INTO set_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Nebeisa Pilatus benen eukuke nane Yahudi ro helen miyae helen hebatere weumi, “Eren, Reyae mana mai bere yoise Yesusre yaufensonde menduwende. Mayae maisaei nekembe, reyae Naeinya beko mbai sambai ehubaikoi sele.” ");
INSERT INTO set_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Nebeisa Yesus yawainyehoke meukuke na malo fi kolei ma yae hirainyekoke, na yun fokoma isa bele yae obunainyeboke. Pilatus yae weumi, “Mai ro niyae erennebo!” ");
INSERT INTO set_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Imam yun-jun bele na abu ako yo bele aiweke Yesusre erekainyele bae kaenate, “Ohaline bongko! Ohaline bongko!” Pilatus yae weumi, “Yawennoho eme, menaeijae ohaline bongkombe. Nauware elaube beko mbai sambai reyae ehubaikoinye.” ");
INSERT INTO set_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yahudi ro miyae yae wainye, “Maei wali heere folaikoke honaime huluinye bae Neyae herende hele, rabuhine ban Naei uware Allahle Kelu yae eleukokene.” ");
INSERT INTO set_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nebei a boroukokene Pilatus buhae hele hokoungeboke. ");
INSERT INTO set_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Pilatus beufoke are kolainye obere eweufike, ukeumile Yesus yawainyehoke, ekate mo hineunge, “Weyae naei sele makeinye ro?” Nebeibe Yesus a mbai sambai ewei. ");
INSERT INTO set_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Nebeinye benen Pilatus yae weunge, “Weyae rangkele a faeu mbainye elei? Weyae oneyaene Ware bulaereibote naeise nane wanen ohaline boreikote naeise raei me einye mo honole?” ");
INSERT INTO set_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesus yae weunge, “Allah nebei rambun ware ekinyeiboinya, weyae Raei uwa rande me ikileiboi hesele. Nebeinye Rare waei me einye kinyeubokete kiyae na beko bako kabani hesele, waeisa.” ");
INSERT INTO set_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilatus nda a wanen boroukoke bae, Yesusre bulaerennekondere relewoungele. Nebeibe Yahudi ro miyae kali kaenate, “Weyae nebei kiyae bulaereungekondena, weyae nda kani kaban na Ondofolo Kaisarle kahili ban. Ro miyae nde yae nauware ondofolo yae elendena, neyae Kaisarle yokeijo.” ");
INSERT INTO set_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilatus nebei a ma faeu ma boroukokene, ukeumile Yesus yawainyehoke eibaleke. Anuwau mbai na ro “Ruka Felaeikoke Anuwau” (Ibrani afaeu wae na ro Gabata) wali hului koloi-koloi ro naei angken nuwei ranne nuweuboke. ");
INSERT INTO set_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Nebei hee hu yaukanne ike (12) hului Paskah mon na uwa mokoisayaimi ya. Pilatus yae Yahudi ro miyaere weumi, “Nda maei Ondofolo niyae.” ");
INSERT INTO set_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Nda yo yae kaenate, “Hombo! Hombo! Ohaline bongko!” Pilatus yae hineumi, “Rahene mai Ondofolo ohaline borekondere waufe?” Imam yun-jun mae wainye, “Kaisar mbai ken maei Ondofolo.” ");
INSERT INTO set_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Nebeisa ohaline bonaikonde naeise Pilatus nda yore kinyeumiboke. Nebeinye felayo Yesusre yawainyehoke ewate. ");
INSERT INTO set_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesus nenaeijae ohali na bakane kaeuboke aloungekoke anuwau na ro Yun Bo meke (“yun bo” Ibrani afaeunge “Golgota”). ");
INSERT INTO set_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Nebei anuwaunge Yesus ohaline baikoke. Ro bee bele nanembainye baikoke, hi na meli reufine hi na meubene Yesus na nolone. ");
INSERT INTO set_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Yesusre baikoke ohaline Pilatus ukeumi nda raka homo ma molonaikonde mo ungate, ");
INSERT INTO set_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Nebei raka homo Yahudi ro miyae helen kowate, rabuhine ban Yesus ohalire baikoke anuwau yora ahau ban, nane merau nebei homo Ibrani, Latin, Yunani afaeu wae molaikokene. ");
INSERT INTO set_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Imam yun-jun mae Pilatusre wainye, “ ‘Yahudi ro miyae naei ondofolo’ naei yae omoloijae. Nda wanen mae molokomae, ‘Nda ro eleweke, Reyae Yahudi ro miyae naei ondofolo.’ ” ");
INSERT INTO set_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Nebeibe Pilatus yae weumi, “Moloukokale hului yae naei mekai hononde.” ");
INSERT INTO set_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Yesus ohaline baikokera nebei felayo yae Na malo yaraikoke. Nebei malobe kelire wahaeikoke naeise naeise mbemba yaraikoke. Yesus Na uwa kelaeunge malo kaban rokate. Nebei malo bumara oke ane ehaikoi. ");
INSERT INTO set_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Nebeinye nda felayo hi yae hire weunge, “Nda malo bohi-bohi yae efoloijae. Men, eyae oye nihemakonde mo haimakonde neyae kelemmebonde ndelere yembonde.” Nebei ma mokaiboke yae wa Allahle homone molaikoke a na hului yembonde. Nebei homo nda wanen molaikoke, “Raei malobe neyae wahaeikoke nane merau raei malo kabande oye yae nihaeiboke.” Nebei felayo nebei mekai yae mokaikoke. ");
INSERT INTO set_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesusre baikoke ohali kelaeunge Yesus nenake bele, Yesus nenake nauwake bele, Maria Klopasle miyae bele, Maria Magdalena bele, nebei anuwaunge hebate. ");
INSERT INTO set_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Nenake bele reyae Yohanes na moisa orowole kenare koufeke kiyae bele hebande Yesus erekeume heera, nenakere weunge, “Ana, nda waei fa.” ");
INSERT INTO set_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nebeisa Yesus rare eweke weufe, “Ndi Ana niyae.” Nebei heera Yesus nenake raei imaene ei haweungekale. ");
INSERT INTO set_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesus naeisaei, benate rambun nanemene na hului yaeiboke. Allahle homofae molaikoke na huluise mokonnebonderene, Yesus elele, “Reyae bukibe kale ya.” ");
INSERT INTO set_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Nebeinye anggur bu faere mo honole. Nebeinye hebate yo yae kolaei mbai nebei bu yalene hakalune yawaisike. O ha mbai na ro hysop na maensa mbai nihaeiboke nebei hakalu roukate mo Yesus anensinde naeise euwa boneise yae mokainyeboke. ");
INSERT INTO set_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesus felaeyeufike heera elele, “Ninae na hului yaeiboke.” Nebeisa na yun are noke, no u yeuboke hereke. ");
INSERT INTO set_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Sabatre mokoisayainye yane yeubokene, nane merau nda kulunne sabat Paskah ya kaban rukene, Yahudi yun-jun ohaline baikoke here no na hibi hilonatere ahi hele elewate. Nebeinye Yahudi yun-jun ekate Pilatusre riyainyehike ohaline hilate yo u hale herenate naeise, noro isenaikondera here no are yae onate. ");
INSERT INTO set_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Felayo yae ekate Yesus naei nanembainye ohaline baikoke ro bee naei oro bo beere nihaeikoke. ");
INSERT INTO set_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Yesus hilolere mekate bae erainye hereke. Nebeinye Yesusle oro bo eniheikoi. ");
INSERT INTO set_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Nebeibe felayona ro mbai yae na mena menda yae Yesus na kelengkera neke, na hibi ha bele bu bele balewate. ");
INSERT INTO set_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nda wanen yeubokere reyae Yohanes ijoko yae ereubokale kiyae yae nda are huwamale. Nebei are mayae hila rabo bele yae halembe naeise reyae na helebe huwamale. ");
INSERT INTO set_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Allahle homona molaikokere na huluise mokonainyebonde naeise, nebei u mekai mokaiboke. Nda wanen Allahle homofaene molaikoke, “Yesus nauwana bo mbai sambai einyiheikoi.” ");
INSERT INTO set_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Nebei homo einye nane merau molaikoke, “Nda yo mendare nekate kiyaere ijoko enainyekanende.” ");
INSERT INTO set_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ro mbai Yusuf Arimatea yona Yahudi ro miyae, fene nunda-nunda Yesusre hakoungeke oroweke. Nebei hee, neyae Pilatusre riwounge Yesusle here no are onde naeise. Pilatus ehe koungekoke. Nebeinye here no roweise ekate. ");
INSERT INTO set_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemus, na bere Yesusle bokore reniai yae meke kiyae, nebeinye nangkele mekete. Nikodemus yae nda minyak fololo bele mur bele gahara bele 30 kilogram hului rouke eke. ");
INSERT INTO set_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Yahudi ro miyae here nore mokayeke hului yae hokolo bee Yesusle here nore minyak fololo bele yae rileinyekoke, malo lenan ((roi bumane yaroikoyate)) yae ruleisike mo, kaeiboke ewote. ");
INSERT INTO set_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yesusre ohaline baikoke anuwaunge heke mbai honole. Nebei heke einye rukara bulei mbai neme hele waeiboke. Nebei anuwau roko mbai here no erasi mo. ");
INSERT INTO set_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nebei ya Yahudi ro miyae Sabat ya naeise mokainyehake yane nane merau nda ruka bulei nobene, Yesus na here no nebeinye raisike. ");
INSERT INTO set_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Nebei mon ya mbai nendo na rene kaukau fele hu enaeikoi mo Maria Magdalena ruka buleise elewole. Na ijoko erele bae ruka buleise ahaeikoke ruka kaban wekainyele. ");
INSERT INTO set_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Maria Magdalena noro mo habeleweke Simon Petrus bele reyae Yohanes Yesus na moisa orowole ro hi kenare kowoufe kiyae bele baeikoise eke, hubayaendekoke mo weume, “Tuhan Nauwa raisike ruka buleisa rokate. Meyae isian makeinye Yesus aitasike ban.” ");
INSERT INTO set_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Nebeinye Petrusle rangkele ruka buleise ekende. ");
INSERT INTO set_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Meyae nanembaisa hakendekokebe, reyae hasale helene Petrusre moi wokanale. Reyae na bere yae nebei ahe buleise ekale. ");
INSERT INTO set_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Reyae ei eyeisi, na moisa hebale. Ruka bulei eise erale bae malo lenan uware rulainyehike mo nebeinye honole. ");
INSERT INTO set_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Petrus moisa meumeruke na hibi ruka bulei eise neke eweufike. Ijoko erele bae malo uware rulaisike mo nebeinye honole. ");
INSERT INTO set_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Nane merau nebei malo Yesus na yunne rinainyekoke anuwau nenaei enene oleukoke eke honole. ");
INSERT INTO set_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nebeisa Reyae ruka bulei eise eweufikale. Yeuboke rambunde ijoko erewale nane merau hila rabo halewale Yesus waleuboke. ");
INSERT INTO set_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Nda heki koko nekaimeke Allahle homofae einya Yesus nulu yo mahe yora annunde hele naeise elaikoke meyae namman isaeyeiboi mo kandemeke.) ");
INSERT INTO set_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Nebeisa Petrusle rangkele nebei ruka buleisa bukendeboke, nekewande anuwaufe ewonde. ");
INSERT INTO set_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Nebeibe Maria Magdalena ruka bulei kelaeunge hebewole na rime bele rimewole. Rimene rimele ijoko ruka bulei eise uwa niheufike erele. ");
INSERT INTO set_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Malaikat bee hele malo keleumon mae hireikoke, Yesusle here nore raisike anuwaunge angken mae roibokebe erekeumi, hi yun wene hi oro wene. ");
INSERT INTO set_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nebei malaikat bee yae hineinye, “Ana, rahene rimeyae?” Maria yae malaikat beere weumi, “Raei Tuhanbe nda bulei eisa roukate. Reyae isian makeinye ainyeneke ban.” ");
INSERT INTO set_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nebei a mekaisa eleukokera Maria na moise euweke erele bae Yesusbe na moinye hebele, nebeibe oroiboi sele nebei Yesus. ");
INSERT INTO set_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesus yae weunge, “Ana, rahene weyae rimeyae? Ndebe weyae baenae?” Maria yae u bene nekewainye heke kayaa ro yae eleukokene weunge, “Arai, weyae nda anuwaufa here no rokae a hine eitaufikaena, rare weise makeinye weyae eungenekae. Reyae nebei anuwaufa eitoufele.” ");
INSERT INTO set_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesus yae weunge, “Maria.” Na ro yae roungebokene Maria euweke Yesusre Ibrani afaeu wae weunge, “Rabuni!” (Na mekai “isaei hebaen bele ro”.) ");
INSERT INTO set_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesus yae weunge, “Rare me ikileisemae ba, rabuhine ban Reyae Ako Allahle bokore namman einye. Nebeibe Raei aka baeke wa bokore ele mo nda wanen mae weumile, ‘Raei Maeko mai Arai, Raei Allah mai Allahle bokore erelere.’ ” ");
INSERT INTO set_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Nebeisa Maria Magdalena eke, na moisa orowate yore weumi, “Reyae aei Tuhan erekanale.” Nane merau Yesus yae ukeunge a nare weumikoke. ");
INSERT INTO set_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nebei mon ya mbai nendo be baheuboke yae Yesus na moisa orowate yo imae mbainye arileufike. Yahudi yun-jun fene, na imaena romau nanemene ahunaikoke. Nebei hee yae Yesus na nolone meufebenguke weumi, “Rei mai foi moi mai kena une kombe.” ");
INSERT INTO set_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Na me bele na kelengke belene keleumi. Na moisa orowate holona naei Tuhan erekainyelene, rei mai sele kate. ");
INSERT INTO set_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Roko bee nendo Yesus a weumi, “Rei mai foi moi mai kena une kombe. Maeko yae ukeufe mekale wanen nebei sului mbai Reyae mare ufembe embere.” ");
INSERT INTO set_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nebeisa eufou mauwoumi wa weumi, “Allahlena Roh yaroungko. ");
INSERT INTO set_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mayae ro miyae naei u mekai beko u benera emmihanembe, Allah nebei sului mbai faeinyemmile. Ro miyae naei u mekai beko mayae u benera ehaneinya, Allah nebei sului mbai efaeinyeiboi.” ");
INSERT INTO set_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomas nane merau Didimus yae uwainye kiyae me bee oro nen bee bele Yesus na moisa orowate yo na hi niyae. Yesus meke hee hiwa yo arilaisike ya Tomas nangkele ban. ");
INSERT INTO set_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Nebei yo yae Tomasre wainye, “Meyae Tuhande ijoko eranneboke.” Nebeibe Tomas weumi, “Reyae namman na mena paku nou ereiboinya, na mena paku bulune raei me eneyeinya, nane merau na kelengke bulune me eneyeinya, reyae na helere eleikoi sele.” ");
INSERT INTO set_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Mon mbai nekaikoke mo, Yesus na moisa orowate yo benen nebei imae mbainye Tomas nangkele yae arilaisike. Romau nanemene ahunaikoke hororebe benen Yesus na nolone meufebengukera ane melaeyeumi, “Rei mai foi moi mai kena une kombe.” ");
INSERT INTO set_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nebeisa Yesus yae Tomasre weunge, “Nda Raei me niyae ereibo, waei me kala-kala neinye, nane merau waei me kala-kala kelengkera neinye. Nebei nibi yaere weyae ame-ame yae elei, na hele yae mo elele.” ");
INSERT INTO set_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas yae Yesusre weunge, “Raei Tuhan, Raei Allah.” ");
INSERT INTO set_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesus yae Tomasre weunge, “Rare erekaeraene weyae na hele yae eleukokae. Ro miyae namman ereiboibe nebeibe na hele yae enayelende yo, onomi foka yae hubanainyende.” ");
INSERT INTO set_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesus na moisa orowate yo bene rambun emere-emere helen mokoweke, erayeke nda homo molandekokene omoloikoi. ");
INSERT INTO set_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Yesus Allah yae oro umaufe heraweungeboke Wali Ondofolo Kiyae nane merau Allahle Kelu mayae na hele yae elembe naeise, nane merau Nare hila rabo halennele yae mayae wali neme nekembe naeise, nda rambun yaeiboke kayeero hiwa nda homone moloukokale. ");
INSERT INTO set_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Mainyekeukoke mo, meyae na moisa orowande yore roko hibe Tiberias bukoba habalane Yesus Na uwa yakaumiboke nda wanen. ");
INSERT INTO set_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ya mbai nda yo arilandehike nekande: Simon Petrus, Tomas Didimus yae wainye kiyae, Nataniel Kana yona Galilea kanine, Zebedeusle fa-fa, Yesus na moisa orowate ro hi, reyae Yohanes. ");
INSERT INTO set_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Petrus yae weume, “Reyae kare baerendere.” Meyae hiwa yae wanne, “Maengkele hakomakondere.” Kaisa andehaweuboke awandeke. Nebeibe reniai koko baendemeke ka mbai sambai (efoisi mo) ikileiboi. ");
INSERT INTO set_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Hu inyukui rorowole yae, erewannele Yesus buhaeinye meufebeunguke, nebeibe meyae isian nebei kiyae Yesus. ");
INSERT INTO set_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesus yae weume, “Ei fa-fa, mayae ka bele?” Meyae wanne, “U hele ya.” ");
INSERT INTO set_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yesus yae weume, “Ma kai meube reufire yae ma wau womo. Mayae ka bele yembombe.” Meyae na wau kai meube reufire wokande. Yobomabondere na hului ban, rabuhine ban ka helen selene. ");
INSERT INTO set_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Reyae Yesus kena helere koufe kiyae yae Petrusre wanale, “Ndi aei Tuhan.” Petrus ndi naei Tuhan a borouboke hee bae, malo mbai kulaubokene nebei malore hireukoke honoungehike buna. ");
INSERT INTO set_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Meyae Yesus na moisa orowande hiwa yo kaisa nda wau ka yae maemae koukoke bele Petrusle moisa ohore yobandemaekae. Nebei ijen ohora 100 meter hului mo. ");
INSERT INTO set_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Meyae kaisa akowande hee ijoko erande isen ranne ka bele feu bele honate. ");
INSERT INTO set_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesus yae maere weume, “Mainya ka manemfa ikilaukoke bele hiwa ndare yarongko mem ba.” ");
INSERT INTO set_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Petrus kainye eweufileukoke. Na wau ka kaban-kaban maemae koukokere mo ohore yae yobouboke meke. Nanemene 153 hele. Nebei helen suluibe na wau ekaneikoi. ");
INSERT INTO set_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesus yae weume, “Mem, eraman memane.” Na moisa orowande yo nolona hiwa kena kowande nda are hinemansinde, “Weyae nde?” Nebeibe na hului ban. Rabuhine ban meyae maeisaei nebei Kiyae na hele aei Tuhan. ");
INSERT INTO set_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nebeisa Yesus maei bokore eungakeleufike feu bele ka bele yarowole wahewoume. ");
INSERT INTO set_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesus here nolora aungunukera nda roko name nendobe na moisa orowande yore uwa yakaumeboke. ");
INSERT INTO set_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Meyae eraman anandekokera Yesus yae Simon Petrusre hineunge, “Simon, Yohanesle kelu, waei kena buhae emekai bele Rare haerae nda yora?” Petrus yae weunge, “Na hele Tuhan, Weyae waeisaei reyae Ware kena buhae haewale.” Yesus yae weunge, “Raei obo yoku domba kelu u mekai wanen ro miyaere raman yeumile.” ");
INSERT INTO set_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesus roko bee nendobe Petrusre hineunge, “Simon Yohanesle kelu, weyae Rare kena buhae emekai bele haerae?” Petrus yae weunge, “Na hele Tuhan, Weyae waeisaei reyae Ware kena buhae haewale.” Yesus yae weunge, “Raei domba u mekai wanen ro miyaere hole moloumiyende.” ");
INSERT INTO set_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesus roko name nendobe Petrusre hineunge, “Simon Yohanesle kelu, weyae Rare kena buhae haerae?” Yesus nebei a ma roko name nendo hineungene, Petrus kena beko hele hubaunge. Petrus yae weunge, “Tuhan, nanemene waeisaei bangka mo. Reyae Ware kena buhae haewale naeise waeisaei.” Yesus yae weunge, “Raei domba u mekai wanen ro miyaere raman yeumile. ");
INSERT INTO set_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Reyae na helebe wawale, hokolo fa nekewoyae hee wa yolu ha wenaeijae ikilewoyae nane merau ele mele makeise makeise waei kena hului yae eyewoyae. Nebeibe rorele meuyeubonde hee hiwa yore wa me neumiyende ha rinenayeikote, weyae kenare okoi anuwaufe yaungayeisote embe.” ");
INSERT INTO set_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Petrus rahe ma yae enserendene Allahre hili ennehebende abe Yesus isaeyeungeboke. Nebeisa Yesus yae Petrusre weunge, “Raei moisa hakoibo.” ");
INSERT INTO set_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petrus na moise weke bae ereunge reyae, Yesus kena buhaere heufe kiyae, na moinye hakoubokale. (Reyae nane merau huae eramanne anewande heene Yesusle uwane baraubokale, are hineungehikale, “Nde yae Ware kelai nende?”) ");
INSERT INTO set_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Rare erekeufene Petrus yae Yesusre hineunge, “Tuhan, rahe ma yae nauware enjembonde?” ");
INSERT INTO set_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesus yae weunge, “Reyae kena kale neyae na wali mo nekenende Reyae merele hene era, nebei wangkele elakonde a ban. Nebeibe weyae Raei moisa hakoisobo.” ");
INSERT INTO set_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Nebei a eleukokebe Yesusle einye aka baeke holo nolone reyae eherei mo nekerele a eungeyoboukoke. Yesus yae nebei mekaibe eleukoke banbe, nebeibe nda a wanende Petrusre ukeunge, “Reyae kena kale na wali mo nekeube merele era, nebei waei a ban.” ");
INSERT INTO set_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Reyae niyae, nebei bewate rambunde huweukokale nane merau moloukokale. Meyae maeisaei nda a eleukokale na hele. ");
INSERT INTO set_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesus yae mahi-mahi mokowole, na helen omoloikoi. Nanemene mokoukoke na hubara rawandeboube mbemba mbemba mandemolokoube yae, reyae hubanale nda homo moloukoke yoni-yoni hononatere nda kani kela anuwau ban yeuboube.");
INSERT INTO set_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Onomi foka Teofilus, reyae ((Lukas)) na bere ware homofae mbaise moloukokale ikawale kiyae. Nebei einye Yesus Na me u meke mokowole bele Na a faeu meke kelewoumi bele huba raweubokera meke Allah yae surgare raneuweke iwole yane nemene yakaukokawale. Namman surgare ei yae, Na abu ako eleukoke yo na me u mokonayende naei a usaei wasaei Allahle Roh walora keleumikoke baeufoke. ");
INSERT INTO set_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Neyae na hele waleubokere kelemmibondere, hereke heera ya rorele u bee Na abu akore roko yae roko yae Nauwa yakaumikoke. Nebei mon mae Naei me kelee u keleene orulenaibonde nekenate ro miyae holona naei are Yesus kelewoumi. ");
INSERT INTO set_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ya mbai nangkele ramanne anewate mo, Yesus nda a ukeumi, “Yerusalem yora kulun ewei ei. Nebeibe Allah are heteungekoke ((Roh)) inyembere mayae rakembe, nebei Roh mbai Reyae bere ukamale. ");
INSERT INTO set_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Bere Yohanes mare bu yae kongkokembe, nekemakonde ya heki ban mo, Allah mare Naei Roh yae konengkombe.” ");
INSERT INTO set_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Yesus Na abu ako bele nanembainye arileufike nekate mo, Nare hinainye, “Tuhan, nda hee yae Weyae Israel naei yo waku benen aungenundere?” ");
INSERT INTO set_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Nebeibe Yesus yae weumi, “Nebei Maekole isaei ya, mayae isaeyeiboi sului. Nebei ya bele hu bele Maeko Nenaeijae Nelae wake hului yae merau raungehike.” ");
INSERT INTO set_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Nebeibe Allahle Roh mai uwane anembombe hee mayae nemene elae rowembe. Mayae Raei mekai ma nekale naei are yakammiyembe Yerusalem yora, Yudea kani nemene, nane merau Samaria kanira embe nda kani kela na hubane haeinye ennehalengkombe. ");
INSERT INTO set_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nebei ara weumikoke baeufoke mo, Na abu ako naei bene Yesus raneuweke iwolene, kanewainye mo, mangko yae meumiaheukoke. ");
INSERT INTO set_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Yesus kaeiboke yelene namman kanewainye bele, ro bee na malo keleumon mae hireikoke na abu ako bokone meijakaiboke. ");
INSERT INTO set_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Hokolo bee yae weimi, “Ae, Galilea kanina ro miyae, rahene nebeinye hebaube mai ijoko yakure mo kanaube? Nane Yesus mbai mayae ijokore eraunge surgare mai nolora raneuweke ele wanen mbai Neyae benen bukensinde mende.” ");
INSERT INTO set_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Nebeisa nane yo Zaitun mokora baeiboke Yerusalem yore ewate. Nebei moko na ahau honole Yerusalemda noro bele eyewate. ");
INSERT INTO set_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Yerusalemde okate mo, nekewate imae bumana yowane yaeikiteke. Nebeinye arileufike ro nda niyae: Petrus, Yohanes, Yakobus, Andreas, Filipus, Tomas, Bartolomeus, Matius, Yakobus Alfeusle kelu, Simon (Zelot yae kaenainye kiyae), Yudas Yakobusle fa kayee. ");
INSERT INTO set_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Miyae maengke na hiwa yo bele Maria Yesus nenake nane merau Yesus naubake wa bele nemene Allahre ebelire bonainyelere nanembainye arileisiyele bainye. ");
INSERT INTO set_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ya mbai mewarileufike nekewate mo, (ro miyae Yesusre hila rabo halewainye yo rorele u mehine mbai bele (120) hului) Petrus are elendere aunguke, ");
INSERT INTO set_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","weumi, “Aka naei baeke naei, Allahle homofaena molowate a na bangka mo na hului benate hele. Na berei Allahle Roh yae Daudle euwara Yudas yae bene nembonde Yesusre ikilenaibonde naeise a raufike. ");
INSERT INTO set_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yudas aei holo mbainye orowande, neyae aengkele mbainye kaliare mokowande.” ");
INSERT INTO set_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Nda Yudas kelaise neuboke roi yae kani mbai rouke. Nebei anuwaunge bumara ruke hereke, na yarele kayeukoke, na kabiya nemene maibaleke. ");
INSERT INTO set_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Yerusalem yona ro miyae nemene nebei a naeisaei bangka mone, naei afaeu wae nebei anuwau ro bainyehoke, “Akeldama” na mekai “Ha Kani.” ");
INSERT INTO set_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Petrus yae weumi, “Mazmur homofaene nda a moloukoke, ‘Ninae lon, naei nekele anuwau aku ban nau ban yeubo. Hi yae ha yae nebei anuwaunge enekeijae.’ “Nane merau nda a hi moloukoke, ‘Ninae lon naei angken nuwei hi yae yennuwembonde.’ ");
INSERT INTO set_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Nebeinye ro mbai roumale aengkele mbainye Yesus herekera waleuboke naei are humamiyendere. Nebei ro Yohanes bure kowoumi heera meke Yesus aei nolora raneuweke iwole heene, makeise-makeise Yesus orowekene aengkele homo mbainye hakoumeboke orandeke.” ");
INSERT INTO set_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nebeinye arilewole yo nolora ro bee yaraikoke. Ro hi ro na ro Yusuf nane merau Barsabas yae weyainye (Yustus yae kaeneyainye), na hi ro Matias. ");
INSERT INTO set_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Nebeisa Allahre nda ebeli bainyehike, “Tuhan, ro naei miyae naei kena u ei Weyae waeisaei bangka mo. Waei abu ako mande homora Yudas naei angken nuwei nukeuboke eufereke. Nebeinye Ware bayete, Yudas na u mekai beko mokouboke huluinye ennekende anuwaufe eke a bulure mokondere nda ro bee yarandekokera ro hi eleuboke kiyae maere keleimebo.” ");
INSERT INTO set_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nebeisa hokolo bee naei ro oye nihaeiboke Matiaslene ruke. Nebeinye Matiasre roukate Yesusle abu akore me bee oro nen mbai belere hakoumiboke. ");
INSERT INTO set_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Meke Yahudi naei ya kaban Pentakosta meuyeuboke hee, Yesusre hila rabore halaeinye ro miyae nanemene anuwau mbainye mo arilewole. (Nebei ya Yesus aungukera ya rorele u bee mehine mbai bele (46) hului yeuboke.) ");
INSERT INTO set_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mewarileufike bele yakura borate alu baeijo kulun wanen neke owole. Nekate imae nebei kulun mae kili haka aunguke hebele. ");
INSERT INTO set_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Erewate bae, i faeu wanen bolaiboke arilewole yo naei uwa ranne fayeke hebayeke. ");
INSERT INTO set_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Nebei ro miyae nemene Allahle Roh yae mekai aumibokera afaeu mahi-mahi huba rawaiboke elewate. ");
INSERT INTO set_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nebei hee Yahudi ro miyae Allahle are hubara haeisa yanewainye holona kani hine-hine nekayeke yo nemene Yerusalem yone nekewate. ");
INSERT INTO set_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nebei kulun oke borowatene, ro miyae helen sele eleumeke. Yesusre hila rabo halaeinye yo naei afaeu wae elewate eleumeke yo borowatene, nebei yo onei-onei yae onewate, ");
INSERT INTO set_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","fa yae bowate, ijoko kelei-kelei mo kelewate elate, “Nda Galilea kanina ro bangka mo, nebeibe afaeu mahi-mahi yae elate! ");
INSERT INTO set_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Rahe mabe yeubokene meyae borammile maei mewande yo yoni-yoni naei afaeu wae elate? ");
INSERT INTO set_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Eyae ro miyae nda kanira mewande: hiwa Partiara, Mediara, Elamda, Mesopotamiara, Yudeara, Kapadokiara, Pontusra, Asiara, ");
INSERT INTO set_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigiara, Pamfiliara, Mesirra, Libia kani Kirene kelaeunga; aei nolora hiwa Romara. ");
INSERT INTO set_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Hiwa Yahudi ro miyae, hiwa yo hi ro miyaebe Yahudi naei agamane kate yo, hiwa Kreta yokobara mewate, hiwa Arab kanira mewate. Nebei yo Allah rambun emere-emere mokole naei a aei afaeunge-afaeunge huwate, na yaka hele borande.” ");
INSERT INTO set_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Borowate yo onei-onei yae onewate nane merau fa yae bowate yae naeise naeise hinate, “Nda naei sele naendae wanen?” ");
INSERT INTO set_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Nebeibe hiwa yo a wewe wanen mae kaimi elate, “Ae, anggur bu anaisike yae nekeumine yun yambi-yambi kate!” ");
INSERT INTO set_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nebei a wewe kaimi a borokatene, Petrus nane merau abu ako me bee oro nen mbai bele afae yae hebaiboke. Petrus yae huba raweuboke nebeinye arilewole ro miyaere a kaban don mae kaenele weumi, “Aka naei baeke naei Yahudi ro miyae nane merau Yerusalemne nekaube yo nemene, nda a isaeisembombere mangkaei foi-foi yae boron. ");
INSERT INTO set_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nda yo yun yambi-yambi okoi, mai u benere nekayembe wanen ban. Rabuhine ban nda na rene hele, menemfa fere hukai mehine kelibe yeuboke. ");
INSERT INTO set_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nendahina Allahle yendo kayaalo Yoel yae ndane baete naeise nda a moloukoke: ");
INSERT INTO set_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Allah yae a weume, moinya yane Raei Roh ro miyaere isemile. Mai kelu omi kelune maengkene Reyae ufemile a faeu ungaimile. Mai ro hokolo fa benate rambunde ijoko ka yae raneremibonde enairende. Mai rorele yo benate rambunde Reyae isemile imene naline enaisononde. ");
INSERT INTO set_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Nebei ya, Raei yebaei bubaei kelune maengkene Raei Roh aremibonde. Reyae ufemile a faeu ungaimile. ");
INSERT INTO set_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Yakune Reyae iwau mahi-mahi keleremile nane merau iwau mahi-mahi hele Reyae nda kani kelane mokorele benate, ha bele, i bele, nane merau ongkou na kobane-kobane. ");
INSERT INTO set_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Hu wende ouben kika yembonde, oko wende ha hasai wanen yembonde. Tuhan Naei ya kaban nane merau Naei one hengko hehe bele kitennebonde ya namman emei hee yae nebei iwau yoni-yoni benate. ");
INSERT INTO set_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nde yae Tuhan hole ennemolombondere riyennehindena, wali hena bona endowende.’ ");
INSERT INTO set_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Aka naei baeke naei Israel ro miyae nda wamale are boron, Allah na yaka hele yakambokembe, Yesus Nasaret yona Ro Naei bokore ukeunge eke. Mayae maisaei Allah Naei walora rambun emere-emere mokoimeyele nane merau iwau mahi-mahire keleimeyele. ");
INSERT INTO set_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Allah merau raungehike huluinye be hineuboke, Yesus mai me einye kinyeuboke. Mayae na hibi ro miyae nansau bele hakayengkokembe ohali ranne hauboke. ");
INSERT INTO set_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nebeibe herewate yo nolora Allah yae waleungeboke. Neyae herera beko hubaungekoke nebeibe Allah raneungejeke, rabuhine ban Neyae here yae eheraweiboi ohonoi Kiyae. ");
INSERT INTO set_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Yesus yae Allahre a eleukoke naeise Ondofolo Kaban Daud nda a moloukoke, ‘Reyae erekanale Tuhan Allah Raei bene mo nekeimeyele. Raei meube reufine hebelene, Rare ekuseikoi emaheikoi. ");
INSERT INTO set_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","Weyae Rare nendon mae nulu yo mahe yone enukeiboi. Reyae Waei eleuboke wekarae Kiyaele u melen u ha nendon mae kakare bendere Weyae ewaeisi. Nebei aerene Raei kena roweufehike. Reyae rabo elae halerende Weyae eleukokae a huluinye mokowende. ");
INSERT INTO set_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Weyae Rare wali nibi naei na helebe keleufebokae. Weyae Rangkele mbainye orondene Raei kena roweufiyeufe.’ ");
INSERT INTO set_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Aka naei baeke naei, aei yobe Daud naei uwa naeise na yaka lon mae reyae hufembe. Neyae hereke aimoloufake. Na bulei aei nolone namman honoimeyele meke mana yane. ");
INSERT INTO set_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Daud neyae yendo kayaalo, nane merau naeisaei Allah a holo yae heteungekoke naei orona mena ro hi erengkonde Daudle yo anuwaufe yennuwembonde. ");
INSERT INTO set_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Allah rahebe mokongkonde neyae naeisaei nekele. Nebei aerene Daud nendahina nda a nuleungekoke elele, Allah Wali Ondofolo herendera nulu yo mahe yone Nare enukeiboi nane merau Naei u melen u ha nendon mae kanine beko ebei. ");
INSERT INTO set_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Nda Yesus mbai herekerabe Allah yae waleungeboke nebei rambun-rambun bewatere nemene enaei ijoko yae erewande. ");
INSERT INTO set_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nda hee Allah Naei kendan wameran meube reufine na bumane haungeboke. Allah are heteungekoke hului Naei Roh ikeunge. Aka naei baeke naei, mana mayae boraube nane merau eraube rambun, nebei Roh mbaibe mana Yesus yae maei uwane kiteumeboke. ");
INSERT INTO set_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Daud surgare naei uwa ei nebeibe Daud yae eleukoke, ‘Allah yae raei Tuhande weunge: Raei meube reufine meinyuweibo, ");
INSERT INTO set_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","merele wa yokeijore nemene mokoremikonde woro keleere mo menayorulembonde.’ ");
INSERT INTO set_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Nebei wanen mayae Israel ro miyae nda are isaeyembombe, Yesus mayae ohaline baukoke Kiyae mbaibe Allah yae Tuhande raneuweke nane merau Wali Ondofolore oro umau heraungeboke.” ");
INSERT INTO set_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nebeinye hebate ro miyae nda a borokatene, na kena beko bele hubawainye. Petrus bele abu ako hiwa belere hinewaimi, “Aka naei baeke naei, rahebe meyae mokomabonde?” ");
INSERT INTO set_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petrus yae weumi, “Aka naei baeke naei, Allah yae mai beko bakora faeinyenembonde naeise, nulu kenembombe, Yesus Wali Ondofolole Ro yae bu konayembe. Allahle Roh mare ei anembombe hele. ");
INSERT INTO set_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Allah nebei a heteungekoke mai foi naeise, mai orona mena foi naeise, nane merau ahaunge nekate ro miyae Allah yae emmikaenengkonde yo foi naeise.” ");
INSERT INTO set_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petrus nebei a wanende huwoumira benen nda a usaei weumiyoke, “Allahlena ehee bukulu nda hokolo me hilae u hilaere kate yo naei ranne wokera mauwa enfaembombe.” ");
INSERT INTO set_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ro miyae helen sele Petrus yae huwoumi are na hele yae elewate, hila rabo halewate, na hibi bu kaimikoke. Ro miyae hilare rabore halewate yo helen sele bewole. Nebei ya mo ro miyae nemene 3.000 baraikoke. ");
INSERT INTO set_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Menemfa hila rabo halewate ro miyae Yesus Naei abu ako kelewaime a usaei uwa nihaeinyehike yae boraimeke nane merau homo mbainye oraimeke wali mbainye nekaimeke. Tuhande bene nekeisi-nekeisi raman bulau mokaimeke nane merau Allahre ebeli bainyemeke. ");
INSERT INTO set_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ro miyae nemene fomene na kena u einye yei yae kaimeke nane merau roko helen Yesus Naei abu ako rambun emere-emere mokowate. ");
INSERT INTO set_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Hila rabore halaete yo na hibi riya mbainye mo arilewole, rambun-rambun naei yae eleikoi, nemenaeise bewate. ");
INSERT INTO set_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Rambun-rambun, keren nale, roi naise hewate. Nebei roi ro miyae nemene na kalore molowoumi huluinye wahewaimi. ");
INSERT INTO set_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Na yane baei Allahre ei mom-mom imae na kaban sele kiyaele imaehounge mo ongko riya nekayeke. Na kena nime kena haba yae nane merau na rei mai yae imae hira-hira raman bulau anayeke. ");
INSERT INTO set_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Allahre buma kaewainye, nane merau ro miyae nemene nare kena hele kowaimi. Na yane baei, Allah wali holere molowoumile ro miyae holonare barawoumine. ");
INSERT INTO set_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ya mbai nekewate hu oke hujoko namene, ebeli boi-boi hee mo, Petrusle, Yohanesle, Allahre ei mom-mom imae na kaban sele kiyaere ewote. ");
INSERT INTO set_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Romau mbai na ro, “Buhi Wahi”. Nebeinye ro mbai na hongkatera noro nimainyekoke honowekebe. Na yane baei Allahre ei mom-mom mate yore a ri-tise riyemmile naeise, hiwa yo yae kaeiboyate mate, nebei ijenne eisaiboyainye. ");
INSERT INTO set_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Petrusle Yohanesle Allahre ei mom-mom imaere meneyembondere erekeumi mo, nebei kiyae hokolo beere erabuhire inyenyelere riwoumi. ");
INSERT INTO set_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Hokolo bee na ijoko mokoiboke ereinyekoke mo, Petrus yae weunge, “Maere ereime!” ");
INSERT INTO set_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nebei ro hokolo beere ereumi, na kena eisa elele rambun hire inyeiselere era. ");
INSERT INTO set_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nebeibe Petrus yae weunge, “Reyae roi ban hele. Nebeibe raei mena honole rambun ware isetere. Yesus, Nasaret kanina ro, Wali Ondofolo Naei Ro yae ainyu oroye!” ");
INSERT INTO set_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Petrus na me meube reufira ikileungeboke bae nane ro ewaunguke. Nebei heera noro bele oro hakalu bele elae halae yaeiboke. ");
INSERT INTO set_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Nebeisa honoisi yae honoungehike yeufebeukoke, ele mele, bohire ele bohire mele kowole. Foi roukera Petrusle Yohanesle moisa hakoumiboke Allahre ei mom-mom imaere ayeuboke, aloungekoke ewole, honsi-honsi koweke, Allahre buma koloungeke. ");
INSERT INTO set_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ro miyae erewainye nda ro oro aunguke orowole Allahre buma kaewounge. ");
INSERT INTO set_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ro miyae isaeyaeiboke elewate nda kiyae mbai Allahre ei mom-mom imae romau “Buhi Wahi” ne a ri-tise riyewole kiyae onomi rouke erewainyene, fa hele bowate. ");
INSERT INTO set_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nda ro Petrusle Yohaneslere hokoumiboke melae-melae beweke ikileukoke nebeinye obe mbai na ro “Salomole Obe” yae elate ijende. Hokolo name ekate bele ro miyae fa yae bowatene habelewate ele yae naimiboke. ");
INSERT INTO set_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petrus nebei yore erewoumi bae weumi, “Israel ro miyae yoni-yoni, rahene nda wanen mokandere mayae rambun eme hele yae elaube? Rahene ma ijoko maere mo ereyaumele? Mai u benera nekayembe nda rore maeinya elae yae onomi ikannele. Na hele ban. ");
INSERT INTO set_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Aei yobe naei kamahe naei ei molowainye Allah, Abrahambe Allah, Ishakle Allah, Yakuble Allah, nebei Allah mbai meke na yebaei bubaei Yesusre buma kaeungeboke. Nebei Yesus mbaibe mayae hombombere kowaubene Pilatusre ikaungele. Pilatus hayennekondere mayae ahi yae elewaube. ");
INSERT INTO set_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Neyae Allah yae eleuboke wekeunge Kiyae nane merau wali himaloungeboke Kiyaebe, nebeibe mayae Nare ahine. Pilatusre yoyae-yoyae molowaunge ro miyae hoi-soise howole robe ukaungele baleungekoke meukuke. ");
INSERT INTO set_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ro miyae nemene naei wali no Kiyaere mayae haubokaube, nebeibe menaei ijoko yae erewande nulu yo mahe yora Allah benen waleungeboke. ");
INSERT INTO set_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nda ro eraunge Yesusle Ro einye hila rabo halaennele walora mai bene nda ro onomire rouke. ");
INSERT INTO set_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Aka naei baeke naei, reyae isaeyeubokale mai ondofolo kose bele mangkele onewaube handawaubene Yesusre beko mokowaunge. ");
INSERT INTO set_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Allah nendahina yenjo kayaayo naei euwara are nuleungekoke Wali Ondofolo beko hubannekonde hele. Mai me u mokowaube walora Allah Naei a na ijenne maijeuboke. ");
INSERT INTO set_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","20","Allah mai beko bakore faeinyenembombe naeise, nane merau wali rei mai bele inyemile naeise, nane merau nendahina a koloukoke hului Yesus Wali Ondofolo mai bokore Allah yae wennele mende naeise, mayae Israel ro miyae beko bakora nulu kenembombe nane merau Allahlere be bembo. ");
INSERT INTO set_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Yesus surgane mo nekenfonde, Allahle yenjo kayaayo u mekai yolo-yolo bele yo naei euwara nendahina a heteungekoke huluinye Allah nemene fomene neme mokonnebondera Yesus bukensinde mende. ");
INSERT INTO set_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Musa nane merau Yesusle naeise a eleukoke, ‘Allah yendo kayaalo mbai raeinya wanen ro hi mai nolora ranenjende. Nebei yendo kayaalole a menelende nemene nou hembe. ");
INSERT INTO set_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nda yendo kayaalo yae menelende a oboroi kiyae, Allahle homone mate yo nolora hukenainyehinde.’ ");
INSERT INTO set_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Allahle yenjo kayaayo Semuelle heera benen na moisa yakaiboke yo nemene nda heena mekannekande Yesus Wali Ondofolole abe nulainyemeke. ");
INSERT INTO set_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Allahle yenjo kayaayo naei a nulainyemeke nane merau aei yobe naei kamahe naeise Allah are heteumikoke, mayae Israel ro miyae foi naeise. Allah aei yobe Abrahamde nda wanen mae ukeunge, ‘Waei orona mena walora nda kani kelana ro miyae nemene onomi foka enaiyaronde.’ ");
INSERT INTO set_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Allah Na Yebaei Bubaei Yesus Wali Ondofolore oro umau heraweungeboke heera, na bemere ukeunge mayae Israel ro miyae bokore meke mai u mekai beko mokoimeyaungera nulu kenembe walora onomi foka yae ei hawenembe naeise.” ");
INSERT INTO set_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petrusle Yohanesle ro miyae arilewolere namman ane weimi yae, imam-imam bele Allahre ei mom-mom imae na kaban sele kiyae kayaare hebate na yun bele Saduki ro miyae bele hokolo bee naei bokore mekate. ");
INSERT INTO set_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Petrusle Yohanesle yae kelewoimi Yesus herekera aungukene, na yaka yeuboke Yesusle walora ro miyae herate yo walenaibonde. Nebeise mekate yo na kena ikele, ki yae bewate. ");
INSERT INTO set_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Nebei yo hokolo beere ikilaikoke ekate kawa einye haeimikoke. Be baheubokene, hokolo bee na nebeinye ahaeimikoke hebeimeke ya heuboke. ");
INSERT INTO set_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Nebeibe ro miyae helen hokolo bee yae kelewoimi a borowate yo na hele yae elewate. Nane merau hila rabo halewate yo holona ro yoni-yoni baraikoke, nemene 5.000 hului yeuboke. ");
INSERT INTO set_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ya heuboke mo, Yahudi yun-jun bele Musale walora wali heere foloukoke homofaere isaeyaeiboke kelaeimi yo bele Yerusalemne riya arileufike nekewate. ");
INSERT INTO set_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Hanas imam kabande nebei hee nekewole, Kayafas yae, Yohanes yae, Aleksander yae, nane merau imam kaban Hanasle imae mbainya nekate yo bele nane merau hakaimiboke. ");
INSERT INTO set_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Petrusle Yohanesle nebei yo bere yawaimiboke ekete wa hinewaimi, “Ndele elae yae, ndele ro yae ndi ro na u nimainyekoke kiyaere mayae onomi ikeunge?” ");
INSERT INTO set_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Petrus, Allahle Roh yae aungebokene weumi, “Mayae Yahudi yun-jun arilaufike, ");
INSERT INTO set_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","mayae nda ro kena nime haba yae foi mokenneboke nane merau onomi naendae wanen mae rouke are maere hinemmehimberene mana ya ndare yawaumeboke mekende? ");
INSERT INTO set_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Mayae nane merau Israel ro miyae yoni-yoni nda a mayae isaeyembombere borombo: Nebei Nasaret na ro Yesus Wali Ondofolo Kiyaele ro yae nda ro onomi fokare rouke mana mai bene meke hebele eraunge. Mayae nebei Yesusre ohaline baukoke, nebeibe Allah benen waleungeboke. ");
INSERT INTO set_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Nda Yesus mbaibe homofae yolo-yolone molaikoke, ‘Mayae imae hei-seise isaei hebaen bele yo na hului banne wokate rukabe Allah yae nebei imae naei berei rukare mokouboke.’ ");
INSERT INTO set_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nda kani kela ewole mewole ro miyaere wali hena bona yemmile naei elae Allah yae Yesusle me einye kinyewounge, nebei wanen elae hire hare eyei.” ");
INSERT INTO set_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Hokolo bee buhae ohokoiboi ban mae a na bene-bene uwoiminye nane merau neyae isaei eisaeyeikoi ro hosorone, nebei yoyo koseyo fa yae bowate, a nou hewate, nda ro bee Yesusle moisa orowate yo. ");
INSERT INTO set_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Onomire rouke ro bele Petrusle Yohanes bele nanembainye hebatene, nebeinye yoyo koseyo a ban faeu ban yaeiboke. ");
INSERT INTO set_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Hokolo name nebei riyare nekate obe eisa ukaimile aibaleke. Nebeisa na mo-mo riyane arileufike, naeise naeise elate, ");
INSERT INTO set_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Naendae wanen mae nda beere mokomamibondere? Amere eleikoi sului. Eyae nemene aeisaei bangka mo nane merau Yerusalemna ro miyae nemene isaeyaeiboke hokolo bee yae rambun mbai eme hele mokoiboke. ");
INSERT INTO set_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Nda abe heraeinyaimile bele, men, hokolo beere a romou han mae komamikonde benen ro miyae hiware Yesusle ro ehuweyeijae hele.” ");
INSERT INTO set_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Petrusle Yohanesle benen ukaimile eise meyeuboke, a elae yae waimi, “Benen Yesusle ro eitoi yae nane merau ekeleyeijae!” ");
INSERT INTO set_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nebeibe hokolo bee yae beiboke weimi, “Menaeijae hului rannehi, Allahle ro be ro yoinye mainya a waume bele Allah a weume bele, makeibe meyae hakakonde? ");
INSERT INTO set_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Rabuhine ban menaei ijoko yae erewonde bele angkaei yae borowonde bele rambunde naendae mekai yae eyelei anekendere?” ");
INSERT INTO set_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Hokolo beere a huku-huku kowaimi wa benen hayaeimikoke. Nebei yoyo koseyo hokolo beere ehee bukulure inyaimilere nibi ban erewate. Rabuhine ban ro mbai onomi roukene ro miyae helen sele Allahre buma kaewainye. ");
INSERT INTO set_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Onomire rouke kiyae na ralo yakama rorele u bee moi hayeukoke. ");
INSERT INTO set_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Petrusle Yohanesle hayaeimikokera homo mbainye orajeke yo bokore ekete, imam yun-jun bele Yahudi yoyo koseyo bele uwaimi a nemene huwoimi. ");
INSERT INTO set_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Hokolo bee yae elewote boraikokera nebei yo na kena mbai yae na a bulau wae Allahre ebeli bowainye, wainye, “Allah, kun wau bu yau neinya honate rambun-rambun Waei me yae mokowoyae. ");
INSERT INTO set_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Waei Roh yae Wa yebaei bubaei maei yobe Daudle euwara Weyae nda a elewoyae, ‘Rahene ro miyae na kanira-kanira aku ketele erabuhire eyeiboi mehinin mewalobe kolainye? ");
INSERT INTO set_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Nda kanina kelana ondofolo yoni-yoni felare relenainyelere mokoisa-mokoisa nekate, ro miyae mere mokaimi yo mbainye mo arilele Allahre nane merau Naei eleuboke Wali Ondofolore kerenainyekondere.’ ");
INSERT INTO set_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Nda Daud eleukoke a wanenbe yeuboke. Nda yo einya ondofolo bee Herodesle Pontius Pilatusle nane merau Yahudi ro miyae ban bele Israel ro miyae bele nemene riya nekaikoke. Yesus, Waei yebaei bubaei yolo-yolo renden, Waei Wali Ondofolore eleubokae Kiyaere bekore mokonainyebondere. ");
INSERT INTO set_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Neyae mokaiboke rambun nebei nemene Waei elae randa nane merau Waei are eleukokae huluinye yaeiboke. ");
INSERT INTO set_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Mana Allah Waei ijoko yae eramae maere a huku-huku kowaime. Meyae Waei yebaei bubaei Waei ako faeukore huwemamiyendere maere be kaleimeha. ");
INSERT INTO set_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Allah Waei me neinye meu, Yesus, Waei yebaei bubaei nene waewae nekele Kiyaele Ro walora era yo buloo yo onomi yeumile, rambun emere-emere mokole.” ");
INSERT INTO set_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Allahre ebeli bainyehike mo, na nekate ijen oinyeu wae hinewole. Nebei yo arilewole nemene Allahle Roh yae maemae koumikoke nane merau Allahle ako faeukore buhae hokoiboi ban mae ro miyaere huwaimi. ");
INSERT INTO set_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nebei ro miyae hilare rabore halewate yo nemene na kena mbai u mbai. Nebei nolora hi yae naei rambun naei uwa mbai naei yae eleikoi. Nemene na mena-mena rambun honate nemenaei bangka mo. ");
INSERT INTO set_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Elae wake kaban sele nebei abu ako naei uwane keteumiboke. Nebei elae walora isaeyaeimiyeke, Tuhan Yesus herekera waleuboke. Allah nebei yore kena buhae kaban aere ban mae hewoumi. ");
INSERT INTO set_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nebei nolora hi yae rambun kalo omoloiboi, rabuhine ban roko mbemba imae bele kani bele yo naei imae, kani, roi naise heiboyate na roise mo rowate mate ");
INSERT INTO set_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Yesus na abu ako naei bene raisiyaimi. Neyae hire-hire kalore molounge huluinye wahewaimi. ");
INSERT INTO set_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Nebei sului mbai Yusuf, Lewile orona mena Siprus yokobana ro. Yesus na abu ako yae nare nane merau Barnabas yae kaenainyeke. (“Barnabas” na mekai “kena hara roroyeumi kiyae”.) ");
INSERT INTO set_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Neyae nane merau naei kani roi naise heuboke. Nebei roi rouke meke nebei abu ako naei mene ikeumi. ");
INSERT INTO set_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ro hi na ro Ananias na miyae Safirale naei kani mbai roi naise heiboke. ");
INSERT INTO set_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananias kanina heiboke, na roibe bohi naei uwa naeise heraweuboke bohi rouke meke mere mokowaimi abu akore ikeumi. Nda wanen mokoubokere na miyae naeisaei. ");
INSERT INTO set_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Nebeinye Petrus yae weunge, “Ananias, walobo yun meke waei kena ei nemene ikileuboke. Waei kanina heubokae roi waei kayee bele nunne raufikae. Weyae mehauwae Allahle Rohre ame-amebe beungekokae. ");
INSERT INTO set_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Roi naise eheiboi hee yae nebei kani waei. Meke naise heubokae heera nebei hului mbai roi waei. Waei kena eisa nebei merau beko helebe raungehikae. Rore miyaere baemae ban, Allahre weyae baenae!” ");
INSERT INTO set_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nebei ara boroukoke bae, Ananias ruke oke na hibi hereke. Ro miyae nebei iwaufe borowate yo buhae hele hokowoumi. ");
INSERT INTO set_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Nebeisa hokolo fa-fa mbemba mekate Ananias na nore mo malone rulaisike, nebeisa kaeiboke kanine aimoloufake. ");
INSERT INTO set_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Hujoko name hului nekaikoke mo, Ananias na miyae meweufike, yeuboke rambunde neyae isian. ");
INSERT INTO set_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petrus yae riyeungehike, “Mana rare weise wa molo bele mai kanina heubokeubena roi naei kaban sului nda niyae?” “Na hele, naei roi kaban sului niyae,” Ananias na miyae yae elele. ");
INSERT INTO set_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Nebeisa Petrus yae weunge, “Rahene mayae bee a mbainye eleukoke Allahle Rohre wabeunge? Ereimibo! Wa molole no moloisase ekate yo bukaiboke romaunge hebate, benen ware kaenayeubote enatere.” ");
INSERT INTO set_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Petrus ane uwounge hee yae Ananias na miyae ruke oke noro kelene hereke. Nebei hokolo fa-fa mayeuboke erekainyele na no u yeuboke. Nebeisa kaeibokate ekate na molole kelaeunge molaisakate. ");
INSERT INTO set_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Hila rabore halewate holona yo bele ro miyae hiwa nda iwau rilewolere angkaei borowate yo bele nemene buhae hele hokoumiboke kowate. ");
INSERT INTO set_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Yesusle abu ako yae ro miyae nolone rambun emere-emere roko helen mokowate. Hila rabore halaete yo nemene na kena mbai yae Allahre ei mom-mom imaena “Salomole obe” nebeinye mo arileisiyate inyekewate. ");
INSERT INTO set_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Naendae wanen horore ro miyae woke yo nda riyana yore hubara haeisa yanewaimi, hiwa yo nebei holone enayembondere buhae yae hokowoumi. ");
INSERT INTO set_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Nebeibe Tuhan Yesusre hilare rabore halewainye yo rone miyaene emerei-emerei emerewole. ");
INSERT INTO set_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Petrus mende me ekatasinya, u alin fere nennebonde naeise, ro miyae era buloone kayeke yo na aka baeke yae na ijongku honson ranne kaewate nibi enene relewaimi honowate. ");
INSERT INTO set_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Yerusalem yo kaban honole enena fainya yo yoni-yonira ro miyae nekai hokowole. Nda ro miyae era buloone kayeke yo bele alo yae hawaimiyeke yo bele yawaimi mewate yo nemene onomi yarowate. ");
INSERT INTO set_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Nebeisa imam kaban bele naei homone yaunge orowate Saduki holona yo bele kena hensen sele kowatene, me u mokonaibonde merau rainyehike ");
INSERT INTO set_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Yesusle abu ako riyana orowate yore ikilaikoke, kawane ahaeimikoke. ");
INSERT INTO set_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nebeibe reniai yae Allahle malaikat meke nebei kawa romau yoni-yoni raweukoke, nebeisa Yesusle abu akore mo nemene yaweumiboke aibaleke. ");
INSERT INTO set_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Malaikat yae nebei abu akore weumi, “Eme, Allahre ei mom-mom imae na kaban sele kiyaena imaehounge ensebembombe, Wali Ondofolore hila rabo enainyehalende walora wali neme rowembe a faeu ro miyae helende huwemmile.” ");
INSERT INTO set_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nebei abu ako malaikat yae ukeumi a huluinye hakaikoke, na rene kaukau fele ekate Allahre ei mom-mom imae na kaban sele kiyae na imaehounge rore miyaere ekaikelewaimi. Nebei hee mbai, imam kaban bele naei homona yaunga orate yo bele ukaimile ekate. Yahudi yoyo koseyo (Yahudi yun-jun nemene) kaenaimikoke riyane arileufike nekewate yae felayore ukaimile kaware enate nebei abu akore yaungaimibonde na bere menatere. ");
INSERT INTO set_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nebeibe felayo ekate bae, nebei kawa einye hebewate abu ako ehubayeikoi mo. Nda yo bukaiboke ekate riyane arileufike yore isaeyaeimiboke, ");
INSERT INTO set_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","waimi, “Ekarande kawa romau ahunaikoke hului hebate. Kayaayo na romau bene hebate. Nebeibe kawa romau rawandeboke bae, nebei yo oloo.” ");
INSERT INTO set_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nebei Allahre ei mom-mom imaena kayaayo na yunde hebele kiyae bele imam yun-jun bele nda a borokatene bae, buhae yaraiboke na kena ura elate, “Rahe erabe benen menjembonde”. ");
INSERT INTO set_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nebeisa mo ro mbai meke weumi, “Eren mayae kawane haeumikoke yo ndina, Allahre ei mom-mom imae na imaehounge ekaisebate, benen ro miyaere ekaikelaeimi!” ");
INSERT INTO set_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nebeinye, Allahre ei mom-mom imae kayaare hebele yun na keleena felayo bele ekate, nebei abu ako yawaimiboke. Ro helen miyae helen ijokore raisike erate, nendon ruka yae nebei felayore hekelenaimile belene, nda kulunne nebei abu ako na mekai yae yawaimiboke. ");
INSERT INTO set_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Imam kaban mae nebei abu ako na riyane a hinenaimikonde naeise, Yahudi yoyo koseyo bere yawaimiboke ekate. ");
INSERT INTO set_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Neyae weumi, “Nebei Ro kelaeumi meyae mare hee nekayembe. Nebeibe nda Yerusalem yo eise mainya a usaei yae eufureukoke. Mayae na hibi-hibi mo kelaeumi meyae nda Yesus Kiyaere handeboke.” ");
INSERT INTO set_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Nebeibe Petrus bele abu ako hiwa yo bele waimi, “Meyae Allahre mo boromande hele, ro miyaere ban! ");
INSERT INTO set_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yesus, mayae ohaline baukoke hereke Kiyae mbai, aei yobe naei kamahe naeite Allah yae benen waleungeboke. ");
INSERT INTO set_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Allah Naei meube me yae anuwau reufine raneujeke. Israel ro miyae naei beko bakora nulu kenaimile yore na beko bakora faeinyemmibonde naeise, Allah yae Naei Kelure nane merau Walilore raneujeke. ");
INSERT INTO set_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Meyae niyae, nebei a faeufe huweimeyande yo. Meyae nane merau Allahlena a weumi huluinye hakoyate ro miyaere Allah Naei Roh yeyeumi yae, nebei a faeufe huweimeyeumi.” ");
INSERT INTO set_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Yahudi yoyo koseyo arilewole yo nebei a borowatene, ikele hele kowate, nebei abu akore honaikondere merau kolowainye. ");
INSERT INTO set_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Nebeibe Farisi holona ro mbai nebei yoyo koseyo nekate riyana na ro Gamaliel, Musale walora wali heere foloukoke homofaere isaeyeuboke kelaeimi holona ro bele ro. Neyae aunguke wa ukeumi, nebei abu ako ebi fere yaungaimibonde moinye enainyekende. ");
INSERT INTO set_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Nebeisa wa, riyana arileufike nekate yore weumi, “Aka naei baeke naei Israel ro miyae, nda yore mokommile me u bene foi yae nekenayengkombe. ");
INSERT INTO set_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Rabuhine ban, na bena hele ro mbai na ro Teudas elaeyeuboke meke, nauware kaewole. Ro miyae 400 hului nare hakainyekoke, nebeibe haiboke. Na moisa orowate yo here ware weuboke nane merau huba ban haei ban euweuboke. ");
INSERT INTO set_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Na heki ban mo, Yudas Galilea kanina ro yeuyakauboke ro holo mbai yaweumiboke yo kelai yan kelai mokowate. Neyae nane merau haiboke, na moisa orowate yo here ware weuboke. ");
INSERT INTO set_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nebei aerene reyae a usaei wamale, rabuhi-rabuhi nda ro miyaere omokoijae, hayemmikonde. Naei a kelaeimi ro miyae naeinyana, rabuhi ban yembonde nenaei nundembonde. ");
INSERT INTO set_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Naei a kelaeimi Allahlena, mayae nare hun eraisi sului. Nendon Allahle yokeijore yengkombe bele.” ");
INSERT INTO set_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Gamaliellena a huluinye mo nebei yoyo koseyo hakaikoke. Yesusle abu akore kaenaimikoke mekate, ukaimile rahuaere mo baikoke, nebeisa a elae yae waimi, “Benen Yesusle Ro ehuweijae.” Nebeisa hayaeimikoke. ");
INSERT INTO set_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Yesusle Ro aerene beko hubanainyele yo yae Allah nare me baeumiboke aerene, nebei abu ako yoyo koseyo bera na rei yae mai yae aibaleke ewate. ");
INSERT INTO set_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Na yane baei Allahre ei mom-mom imae na kaban sele kiyae imaehounge nane merau ro miyae naei imaene-imaene Yesus na hele Allah yae oro umaufe heraungeboke Wali Ondofolo na a foi faeu foi kelewaimi. ");
INSERT INTO set_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nebei hee yae Yesusre hakainyekoke yo benen helen sele baraimekene, Yahudi ro miyae Yunani afaeufe elate yo bele, Yahudi yondowa bele rilibo-rilibo haiwate. Yahudi Yunani afaeufe elate yo yae waimi, “Ya-ya raman ro miyaere wahaeumi hee, maei miyae nannalere eyeyei.” ");
INSERT INTO set_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nebei aerene nebei abu ako me bee oro nen bee bele Yesusre hakowainye hiwa yo bele kaenaimikoke mewarileufike wa, waimi, “Eyae ramanne mo humfo wamfo bemale, benen Allahle ako faeukore kelemamilere mon ban yembondere na mekai ban sele. ");
INSERT INTO set_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nebeibe aka naei baeke naei, mai nolora ro mehine bee bele isaei hebaen ma yae uwa harainyeboke nane merau Allahle Roh yae aumiboke yo elengko. Nda yo yaromakonde, yarele naeise neyae me mokonaimele. ");
INSERT INTO set_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Meyae wa Allahre ebeli boi-boise nane merau Wali Ondofolole walora wali nibi are kelemamiyende.” ");
INSERT INTO set_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nebei yo mewarileufike na rei mai yae abu ako yae elewate are be hinaibokera ro mbai na ro Stefanus Wali Ondofolole are hila rabo haleweke nane merau Allahle Roh bele aungeboke kiyae roukate. Nane merau nda yo bele yaraikoke: Filipus, Prokhorus, Nikanor, Timon, Parmenas, Nikolaus Antiokhia yona ro Yahudi agamane eweufike. ");
INSERT INTO set_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Nebei ro mehine bee Yesusle abu ako bere yawaimiboke ekate mo, ebeli Allahre bainyehike nane merau na mere nebei yo ranne kolaimikoke. ");
INSERT INTO set_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Allahle a faeu hurewole nane merau Yerusalem yona Yesusle moisa hakowainye yo u hale hele emerei-emerei emerewole. Imam-imam helen solo Yesusle are hila rabo halewate. ");
INSERT INTO set_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stefanus, Allah kena buhae aere ban mae heunge ro nane merau Allahle elae kiteungeboke ro, nebeinye ro miyae nolona rambun emere-emere roko helen mokowole. ");
INSERT INTO set_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Nebeinya Yahudi ro miyae Kirene yona yo bele, Aleksandriana yo bele, Kilikia kanina yo bele, Asia kanina yo bele, naei homo “ei mom-mom imaena yebaei bubaei ban” yae kaenewainye. Stefanus naei a hin-sin eibeko meibeko na waere-waere relewainye. ");
INSERT INTO set_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Stefanus yae weumi are hi yae ha yae ame-amere eleikoi sului nane merau kou kalo ehubaikoi sului. A faeufe elewolere isaei hebaen bele nane merau Allahle Roh yae nauwa keteungeboke. ");
INSERT INTO set_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Nebeinye ekate, ro miyae hiware a moi-moi yae mokaimikoke nda wanen are enayelengkondere, “Naei a ma elewole borowannele Allahre nane merau Musalere aukakabe koumi.” ");
INSERT INTO set_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Nebei nibi yae nda holona yo mokowaimi ro miyae hosoro bele Yahudi yun-jun bele Musale walora wali heere foloukoke isaeyaeiboke kelaeimi yo bele Stefanusre ikilaiboke, Yahudi yoyo koseyo riyane nekenate bere yobaiboke ekate. ");
INSERT INTO set_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Nebeisa ro miyae hiwa yawaimiboke, a na hele ban Stefanusle u rande hainyainyelere. Nebei yo yae elate, “Nda ro Allahre ei mom-mom imae na yolo-yolo anuwaufe nane merau Musale walora wali heere foloukoke homofaere aukaka na hibi-hibi koimeyeumi. ");
INSERT INTO set_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Maei angkaei yae borowande neyae huwoumi, ‘Nda Allahre ei mom-mom imae Yesus Nasaretna Kiyae yae mengkelambonde. Nebei sului mbai Musalena era hena aere kinyeumeboke yoni-yoni Neyae mennebensonde.’ ” ");
INSERT INTO set_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Yahudi naei yoyo koseyo arilewole nekate yo Stefanusre kang-kang mae kanainye, erainyele bae Stefanus na be malaikat be wanen mae hebele. ");
INSERT INTO set_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Imam kaban mae Stefanusre hineunge, “Ndi a ahunaiboke elate na hele?” ");
INSERT INTO set_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stefanus yae weumi, “Aka naei baeke naei nane merau arai naei yoni-yoni mewaube mana borombo! Aei yobe Abraham Haran kanire ei mo Mesopotamia kanine nekewole hee yae, Allah nene waewae bele Kiyae yae meke weunge, ");
INSERT INTO set_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘Waei yo yan bele waka baeke wa bele nukeibo. Reyae kelereibote kanire elere.’ ");
INSERT INTO set_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Nebeinye Abraham Kasdim kani nukeungeboke kulun uke Haran yo Siria kanire ewole. Abraham naeko herekera Allah Abrahamde benen ukeunge nda Israel kanine meke, mayae nekaube kani mbai. ");
INSERT INTO set_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nebei hee Allah Abrahamde nda kani reufi mbai sambai eyei, nebeibe Allah Abrahamde a heteungekoke nda kani nekande Abraham bele naei orona mena belere emmiyende, erabae nebei hee Abraham fa ban nekewole. ");
INSERT INTO set_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Allah nda a Abrahamde uwounge, ‘Waei orona mena meiko-meiko ro miyae wanen mae yo hi kanine enainyekende. Nebei yo naei me keleene nekenayende meuboi auboise konaimiyende na heki ralo yakama 400 enainyekengkonde. ");
INSERT INTO set_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nebeibe Reyae meuboi auboise konaimile yore ehee bukulu isemile. Nebeisa waei orona mena menaibalende menate nda kanine Rare ei menaisemolonde.’ ");
INSERT INTO set_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nebeisa Allah Abrahamde ukeunge nebei a heteungekokere na hele hila rabo halenayendere kelenaimile naeise, Abraham naei uwa nane merau norona mena bele kelu fa-fare ro u elan folonaimile. Abraham na kelu Ishak honokatera ya mehine name mo, na ro u elan neungehake. Ishak na kelu Yakub. Yakub na kelu wa me bee oro nen bee bele, aei Yahudi yoni-yoni yae arai henare wammile. ");
INSERT INTO set_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Nebeibe aei arai hena naubake Yusufre kena hensen mae ikele yae kowainyene, roi naise haeiboke Mesir kanine, yebaei bubaeise eke nekewole. Nebeibe Allah kayaa hebeungeke, ");
INSERT INTO set_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Nane merau na kena bekore koweke nolora hole moloungeke. Firaun, Mesir kani naei ondofolo, Allah na kena mokoungeboke Yusufre foi mokoungeke. Isaei hebaen na bumana hele Yusufre Allah ikeungene, Firaun Yusufre raneujeke Mesir naei kani kelare nane merau Firaunbe imae eise neyae me mokommilere. ");
INSERT INTO set_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Na heki ban mo, moni mai kaban sele Mesir kani bele Kanaan kani belene meungeke kowate. Ro miyae weijei kaeiboi ban kowate aei yobe naei raman baeumihoke. ");
INSERT INTO set_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yakub borowole Mesir kanina gandum bele. Nebeinye na fa-fare (aei arai sena naei elande yore) ukeumi roko mbai nendo ekate. ");
INSERT INTO set_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Roko bee nendone ekate Yusuf na aka baeke ware naei u yakaumiboke weumi, ‘Reyae Yusuf niyae.’ Nebeisa wa, Mesir naei ondofolo Yusuf naei imae mbai obe mbainya yore ro roumiboke. ");
INSERT INTO set_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Na heki ban mo Yusuf naeko Yakubre nane merau naei imaena ekainyekate ro miyae fa-fa nemene 75 menatere kayaa ukeumi ekate. ");
INSERT INTO set_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakub kulun uke Mesir kanire ewole, nekeweke nebei kanine hereke. Nebei sului mbai aei arai hena naei nebei kani mbainye molowate. ");
INSERT INTO set_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Na no yaraikoke ekate, Sikhem kanine Abraham mae Hemorle fa-fa naeisa roi yae rouke bulei mbainye molowate. ");
INSERT INTO set_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Abrahamde heteungekoke a yoni-yoni Allah na huluise mokonnebonde hee nobewounge yae, aei yobe naei Mesir kanine na ro miyae emerewole. ");
INSERT INTO set_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nebeisa ondofolo mbai, Yusufre naeisaei ban kiyae, Mesir kanire ondofolore ike nekewole. ");
INSERT INTO set_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nebei ondofolo ike aei ro miyaere eiweitasi kowole. Aei yobe naei hurengkonde belene waeli hele bewoumi nebei heena honowate wayeu fa-fa hainyate nane merau honate. ");
INSERT INTO set_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Nebei hee yae Musa hongkate, kelu kin foi hamai foi bu yae bu yae yawoungene, oko name Musa naekole nenakele imaene mo meinyarekoke. ");
INSERT INTO set_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Nebeisa Musa a moi bu moinya aitaufike yae Firaunbe maengke yae eke eungerouke, naei fa hele wanen mae naraweke. ");
INSERT INTO set_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mesir kani naei isaei hebaen yoni-yoni Musare kelaeinyeke ane faeunge mene une mokowole nemene na foi mo. ");
INSERT INTO set_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Musa ralo yakama rorele u bee yeuboke mo, na kena roukeunge na yoho Israel ro miyae na u mekai ekainyekate ma ereiboise ewole. ");
INSERT INTO set_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Eke bae, erele naei yona ro mbaise Mesirna ro yae rahuae bowolene, naei yona rore hakouboke nebei Mesirna rore houboke. ");
INSERT INTO set_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Musa naei u benera nekewainye elele, ‘Maei yoho naeisaei Allah rare ukeufe naei hayeikoise mekale,’ nebeibe na yoho naeisaei ban. ");
INSERT INTO set_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ya heuboke mo, nebei wanen mbai Musa meke Israelna ro bee hanne howotere foise mokoneikondere uwoumi, ‘Aka baeke naei bee! Mayae bee aka baeke hele ya. Rahene ma ure-ure boube?’ ");
INSERT INTO set_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Nebeibe hande yobouboke ro yae Musare weunge, ‘Nde yae ware maei be yun be yebae hebelere nane merau maei walire huluise koloumele rore roukayete? ");
INSERT INTO set_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Wenana Mesirna rore houbokae wanen rare houfebondere mekae?’ ");
INSERT INTO set_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nebei wanen borokene, Musa Mesir kanira hakauboke ewole Midian kanine meiko-meiko ro wanen mae nekeweke. Nebei kanina miyaebe rouke, kelu bee honoungekoke. ");
INSERT INTO set_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Nekeukoke ralo yakama rorele u bee mo, Sinai moko kelaeunga a kala-kalane o kaei-kaei ken mbai i yae boloufike bewole nolora malaikat mbai Musale bokore meke. ");
INSERT INTO set_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musa nebei wanen erewolene u bene baeiso-baeiso kowole. Isaeise rowendere nebei i kelaeufe nobewounge hee, Allahlena a weungebe borowole, ");
INSERT INTO set_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Waei yobe Abraham, Ishak, Yakub, naeite Allah Reyae Niyae.’ Musa fene wakune oinyeu wae hineuboke kowole, nebei i bewolere na ijoko erei. ");
INSERT INTO set_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Nda abe borole, ‘Nda kani orore hebeyae ijen yolo-yolone woro mehau hireukokae keiko. ");
INSERT INTO set_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ninae fere Raei ro miyae Mesir kanine nekate naei beko mainyehubaukoke naei ereukokamaele nane merau naei ele kali boroubokamaele. Nebei aerene nare haisemikonde naeise Reyae mewakoubokale. Mana mei, Reyae ware ufete benen Mesir kanire bukeufinde elere.’ ");
INSERT INTO set_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Nda Musa mbai Israel yoni-yoni yae ahi yae elewate wainye, ‘Nde yae ware maei be yun be yebaere hebelere nane merau maei walire huluise koloumele rore roukayete?’ Nebei Musa mbaise i faeu bulura malaikat yae Allahlena are uwounge aei yobe naei be yun be yebaere yembonde nane merau holere molommibonde kiyae. ");
INSERT INTO set_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Nebei Musa mbai yae Israel ro miyaere Mesir kanira yaweumiboke maibaleke. Allah Musale walora Mesir kanine bele, bukoba kaban haisai yalene, nane merau mewate a kala-kalane ralo yakama rorele u bee rambun emere-emere meumokoukoke. ");
INSERT INTO set_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Nda Musa mbai yae Israel ro miyaere uwoumi, ‘Allah yendo kayaalo mbai raeinya wanen ro hi mai nolora wennele mende.’ ");
INSERT INTO set_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Nda Musa mbai aei yobe naei kamahe naei Israel ro miyae nolone a kala-kalane nekewole nane merau Sinai mokone ike malaikat yae are uwounge. Eyae wali nibi foi nekemale naeise, wali heere foloukoke a faeufe Allah nebei Musa mbaise ukeunge. ");
INSERT INTO set_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Nebei wanen mokowolere aei yobe naei kamahe naei yoni-yoni ijoko erewainye hororebe, naei are angkaei oboroi kowate. Musare ahi yae elewate na kena u kowate benen Mesirre bukenate enatere. ");
INSERT INTO set_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Harunde wainye, ‘Maere ei moloi-moloise rambun hi mokoimebo. Nebei rambun yaere maere yawemmebonde emale. Rahebe nebei Musa aere Mesirra yaweumeboke mandebaleke kiyaele uwa ranne yeuboke meyae maeisaei ban.’ ");
INSERT INTO set_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Nebeisa sapi kelu be nulu hoime bahere enaimihononde naei mbai mokaiboke. Obo yoku hili era akau erare ongkoufe felenate naeise yarowate mewate nane merau naei me yae mokaiboke rambunde ei molonainyelere yo koi yo bae yae kowainye. ");
INSERT INTO set_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nebeinye Allah moi buleumiboke nane merau waeumihike nenaeijae yakuna findelaufe maskare, okore, hure, ei molaimiyeke. Nebei naeise nda a yenjo kayaayo homofaene molaikoke, ‘Israel yoni-yoni, ralo yakama rorele u bee bele a kala-kalane mai obo yoku hili era akau erare bae Rare ongkoufe felaufene! ");
INSERT INTO set_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Hoime bahe Molokle fale bele findelau walobo Refanbe hoime bahe bele mai me yae mokauboke rambun-rambunde eise molommilere yaraweke oraweke. Nebei aerene Reyae mare Babel yo ahau buhau ekehonolene haisengkombere.’ ");
INSERT INTO set_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Aei yobe naei kamahe naei a kala-kala nekewate heene, Allah eise memmihawende anuwau einyekate ijenne neyate. Nebei anuwau na ma Allah yae Musare keleungeboke huluinye neyate. ");
INSERT INTO set_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Nebei anuwau bele yae Yosua aei yobe naeite orona menare yaweumiboke, aei kani nekandena nekewate yo aei bene Allah hukeumihikere nukenaisandere ekate hee, nebei anuwau bele nemene rowayeke. Nebei anuwau Ondofolo Daud nekewole heene namman honoumeke. ");
INSERT INTO set_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daudle wali Allah kena hele kowounge nane merau Allahre riyewounge kena kongkondena, Yakub yae bumare kaewounge Allahle imae nembonde. ");
INSERT INTO set_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Nebeibe Daudle kelu Ondofolo Salomo yae Allah nekenende imae heuboke. ");
INSERT INTO set_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Nebeibe Allah ro miyae yae haeiboke imaene enekei. Allah nebei a elewole naeise Naei yenjo kayaayo homone nda wanen molaikoke, ");
INSERT INTO set_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Surga Raei kendan wameran niyae, kani kela Raei oro hensen anuwau. Rahe imaebe mayae Rare hensebombere? Makei anuwaunge Reyae u no isebonde? ");
INSERT INTO set_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nda kani kelana rambun nemene fomene Reyae mokowale.’ ");
INSERT INTO set_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Aka naei baeke naei, ma yun elaekei sele. Mai u bene Allahre isian nekeyate ro miyae wanen. Mayae Allahle are oboroyei. Allahle Rohre moi yae mo buleyaunge, mai yobe naei yae kowate wanen. ");
INSERT INTO set_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Allah na yenjo kayaayo nemene fomene mai yobe naei yae weitasi kowaimi! Wali himaloungeboke Kiyae mendere a nulaiboke yenjo kayaayo haikoke. Nebei ro walire himaloungeboke Kiyae mbai Yesus Niyae. Menaeijae kelai nekaube hauboke. ");
INSERT INTO set_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Malaikat-malaikat walora Allah wali heere foloukoke a mare yae yengkokembe, nebeibe mayae ehakoikoi hele.” ");
INSERT INTO set_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Yahudi yoyo koseyo Stefanus elewole a nemene boraikokera na u bele hubainyehike na ikele han romou fefere Stefanusre kowainye. ");
INSERT INTO set_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Nebeibe Stefanus Allahle Roh yae maemae koungekoke kiyae. Na ijoko yakure kanele bae Allah Naei one hengko hehe naeukokebe ereke nane merau ro bele anuwau Allahle meube reufine Yesus hebele erewole. ");
INSERT INTO set_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Stefanus yae weumi, “Mai ijoko bumare kanen! Raei ijoko erale surga wekeunge. Yesus, Allah bokora meke ro miyae uware yeuboke Kiyaere eranale Allahle meube reufine hebele.” ");
INSERT INTO set_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Nebei are borate yo naengkaei ahunaikoke, na kali bele kaenewate Stefanusre na kulun bainye habelekainyele ikilaiboke, ");
INSERT INTO set_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","yobaiboke, yo moise ekate, ruka yae ekaihaiwainye. Stefanusre rukare haiwainye yo naei malobe hokolo fa mbai na ro Saulus noro wene mo kolowate. ");
INSERT INTO set_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Na rukane haiwainye yae Stefanus kaenele, “Tuhan Yesus, Ra unulu roweise!” ");
INSERT INTO set_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Nebeisa oro selen-selen mae oukoroukoke kali na kaban mae kaenele, “Tuhan, nda beko nebei yo ranne ehayeijae!” Nebei are mo eleukoke na hibi na no hokoukoke. ");
INSERT INTO set_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulus nebei haibokere be hineumiboke. Nebei heera huba rawaiboke Yerusalem na jemaat einye ro miyaere weitasi kowaimilene, nebei abu ako riyana yo mo Yerusalem yone nekewate, ro miyae nemene Yesusre hila rabore halewainye yo helen heraeyeuboke, hiwa Yudea kanire bele Samaria kanire bele habelaeyeke. ");
INSERT INTO set_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Allahle a elelere ei hawainye yo hiwa mekate Stefanusle no elaisake kanine aimoloufake nane merau na kena hele yae rime rimewainye. ");
INSERT INTO set_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Nebeibe Saulus huba raweuboke jemaatna ro miyaere herere wemmilere nibi mahi-mahi baewole, imaera obera eleiso akoibo kowole rone miyaene yobowole kawane mo hewoumi. ");
INSERT INTO set_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Nebei ro miyae heraeyeuboke ewate yo Yesuslena a foi faeu foi ewate ijenne na hibi huwaimiyeke. ");
INSERT INTO set_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ro mbai na ro Filipus Samaria kanina yo mbaise eke, Yesus na hele Allah yae oro umaufe heraungeboke Wali Ondofolo Kiyaele ane nebei yona ro miyaere huwoumi. ");
INSERT INTO set_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Nebei ro miyae Filipus ane uwoumi borowate bele rambun emere-emere mokowole bele erewatene, ro miyae helen sele nda a elewokere maeumikoke borayoke. ");
INSERT INTO set_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Alo yoni-yoni hukewoumi, naei nekewate u bulura ele kali bele bayeke balayeke. Oro me nimaimikoke yo bele oro rebeisi-rebeisi kayeke yo bele helen onomi yarowate. ");
INSERT INTO set_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Nebei yona ro miyae rei sele kowate. ");
INSERT INTO set_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Nebei yona ro mbai na ro Simon. Neyae heki hele Samaria ro miyaere mokoumiyeke na buloo aerere maekoyeumi ijoko kelei-kelei mo kelaeinyeke. Nenaeijae weumi, “Reyae nda woke ro hosoro nekate wanen ban ma.” ");
INSERT INTO set_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Nebei yona ro miyae ebi kaban nare mo borainyeke, elate, “Nda ro walobore yeuboke, na ro Elae Kaban.” ");
INSERT INTO set_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ya heki hele naei me u mahi-mahi mokoumeke erewainyene, Samaria ro miyae na moisa mo hakowainye. ");
INSERT INTO set_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Nebeibe Filipus yae Allah merau raungehike Naei holona ro miyae Yesusle me kelee u keleene nekenate naei a foi faeu foi huwoumi. Nebei ro miyae nana hesele yae elewate yo Filipus na hibi bu kowoumi. ");
INSERT INTO set_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon nane merau nebei a na hele yae elewole, hila rabo halewole, bu koungeboke. Bura yeuketeke heera Simon na hibi Filipusre hakoungeboke oroyeke. Filipus rambun emere-emere mokowolere Simon erewole, yei yae kowole. ");
INSERT INTO set_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Samariana ro miyae Allahle a faeufe ((Yesusle naeise)) hila rabo halewate a Yesusle abu ako Yerusalemna nekate yo borokate. Nebeinye Petrusle Yohaneslere ukaimile Filipusle bokore ekete. ");
INSERT INTO set_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Petrusle Yohanesle ekete, Samaria ro miyaere Allahle Roh ei ammibonde naeise Allahre riyeinyehike. ");
INSERT INTO set_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Rabuhine ban, Samaria ro miyae nolone Allahle Roh hile rande oi mo, nebei yo manemfa fere Yesusle ro yae mo bu kaimikoke. ");
INSERT INTO set_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nebeisa Petrusle, Yohanesle nda Samaria ro miyaere me koloimikoke wa, Allahle Roh ei aumiboke. ");
INSERT INTO set_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simon erewole Petrusle Yohanesle na me ndi ro miyae ranne koloikoyaimine, Allahle Roh yemmi. Nebeinye Simon roise mo rouke Petrusle Yohanesle bokore eke, ");
INSERT INTO set_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","weumi, “Rare nebei mokoube elae yeise. Ro miyae nde-nde raei mere rarensinde kiyae, Allahle Roh na hibi rowende.” ");
INSERT INTO set_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Nebeibe Petrus yae weunge, “Allahlena rambun era yeumere roi yae na hului rowele u bene lon mae eleyae eye, wa roi bele beko yebobe! ");
INSERT INTO set_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Waei kena u yolo-yolo ban mae nekeyaene, maei Wali Ondofolole kaliare mokande ro homora weyae oroi sului. ");
INSERT INTO set_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nebei u bene bekora nulu keweubo, Tuhande ebeli boinye, Neyae waei u bene beko nekeyayetera faeinyeneubote era. ");
INSERT INTO set_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Wa kena une bae kena hensen mae maemae kokokete nane merau u mekai beko yoni-yoni yae aefokete nekeyae.” ");
INSERT INTO set_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon mae Petrusle Yohaneslere weumi, “Mayae bee, rare hakoisobo. Tuhande ebeli bonnihi mayae are eleube raei u rande yae emeijae.” ");
INSERT INTO set_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Hokolo bee Allahle a faeu isaeyeimiyeke nane merau huweimiyekera Yerusalem yore bukeiboke ewote. Nane merau Samaria kanina yo ebibi helen honatere ewote hee yae Yesuslena a foi faeu foi huweimiyeke. ");
INSERT INTO set_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Allahle malaikat mbai yae Filipusre meke weunge, “Ainyu aloinyeko! Yerusalem yora Gaza kanire eke nibi halaikoyole ijen ebun reufire yae fole.” ");
INSERT INTO set_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filipus na hibi kulun uke ewole mo, nibi nolone ro mbai huhu boikoke. Nebei ro Etiopia kanire ikileuboke miyae Ondofolo Kandakena kiyae na hemboni relare ikileuboke ro, Yerusalemde Allahre ei moloikoise eke. ");
INSERT INTO set_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Nebei ro na yore bukeufike kereta einye nekeimeyele Allahle yendo kayaalo Yesayale homofaebe koimeyele. ");
INSERT INTO set_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Allahle Roh yae Filipusre weunge, “Ndi kereta mele kelaeufe yae nobeinyebo.” ");
INSERT INTO set_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipus nebei kereta mele bokore yae hakauboke eke. Borole bae na ranna nekele ro yendo kayaalo Yesayale homofaebe koimeyele. Filipus yae nebei rore hineunge, “Weyae nebei homo koimeyeyaebe elale, na mekai haraungeboke waeisaei yeubokae?” ");
INSERT INTO set_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Nebei ro yae beufoke weunge, “Isaeyeiboi! Ro miyae hi yae rare keleufekoubere, reyae isaeyebole.” Nebeisa Filipusre riyeunge na kereta ranne yeukiteke nanembainye roiboke. ");
INSERT INTO set_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Neyae Allahle homofaena nda kayeerobe koimeyele, “Domba nenaisandere yaweisoyainye ate wanen Nare yawainyehoke, domba kelu na mane folainye a ban faeu ban yeiboyole hebele wanen mae, nebei sului mbai Neyae a mun faeu mun hebende. ");
INSERT INTO set_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ro ban ro miyae wanen mae naei uwane enainyehayende nane merau ro miyae walire hului koloyaimi wanen ban mae Nare enainyekolonde. Nda kani kelara Na no enaitowendene, nde yae Norona mena naei a nou ensende.” ");
INSERT INTO set_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Nebei Etiopiana ro yae Filipusre hinewounge, “Nda yendo kayaalo ndele abe elele, naei uwabe elele, hiwa yo naei?” ");
INSERT INTO set_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filipus nebei koimeyele homofae ijenda huba raweuboke nebei rore Yesuslena a foi faeu foi huwounge. ");
INSERT INTO set_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ewote nibi nolone bu koba mbai kelaeunge mo, nebei Etiopiana ro yae weunge, “Ndire ereibo, bu koba nare yale! Bu koufebondere raei kena kale, nebeibe raei walina rahebe kalo moloufe?” ");
INSERT INTO set_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipus yae weunge, “Wali Ondofolo Naei a elelere hila rabo elae halelena, reyae na hului bu koreibote.” Nebei Etiopiana ro yae weunge, “Reyae, Yesus Wali Ondofolo Kiyaere hila rabo nana hele halaenale, Neyae Allahle Kelu.” ");
INSERT INTO set_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Nebeinye kereta imoli mokoitore ukeunge yauboke. Nebeisa hokolo bee bure oyakoikoke, na hibi bu koungeboke. ");
INSERT INTO set_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Hokolo bee bura yeiketeke heera Allahle Roh Filipusre kaeubokene, Etiopiana ro Filipusre ehubayeikoi. Etiopiana ro na yore na rei sele koweke ewole. ");
INSERT INTO set_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipus mbaibe Asdod yone uwa euwakauboke. Filipus oro molouboke yo ran yo randa ewole Yesuslena a foi faeu foi bele mo huweumiyeke eke Kaisarea yone. ");
INSERT INTO set_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Nebei hee Saulus kena rokeunge Yesusre hakainyekoke ro miyaere honde hayendere u huku-huku kowoumi. Yerusalem yona imam kabanbe bokore eke, ");
INSERT INTO set_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Damsyik yona Yahudi naei ei mom-mom imae naei yun-junde yemmile homo riyeungehike. Nebei homone a wemmile naei yona Yesusre hakainyekoke ro miyae hiwa Saulus hubainyaikondena, neyae ikilengkonde, Yerusalemde yawemmile enatere. ");
INSERT INTO set_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Damsyik yore nobewounge bele, yakura hehe Saulusre naeungekoke. ");
INSERT INTO set_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Saulus ane ruke bele, borole a mbai nare weunge, “Saulus, Saulus! Rahe aerene Rare weitasi koimeyarae?” ");
INSERT INTO set_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saulus yae hineunge, “Tuhan, Weyae wende?” Beungehoke weunge, “Reyae Yesus, weyae weitasire koimeyarae Kiyae. ");
INSERT INTO set_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Mana ainyu Damsyik yore eyeisi. Weyae mokoubonde rambun nebei yone ungayekote.” ");
INSERT INTO set_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saulus naei homo mbainye mate yo onei-onei onewate. A bae boratebe, nebeibe ro miyae mbai sambai ijokore ereiboi. ");
INSERT INTO set_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulus aunguke na ijoko keleukoke, nebeibe na ijoko rambun mbai sambai ereiboinye Damsyik yore me yae ikilainyekoke ewate. ");
INSERT INTO set_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ya name ijoko erei mo meungekeukoke, nane merau raman bu anei mo meungekeukoke. ");
INSERT INTO set_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damsyik yone Yesusre hakainyekoke na ro mbai na ro Ananias. Na ijoko raneungeboke erewole yae, Ananiasre Tuhan mae meke weunge, “Ananias!” Ananias yae weunge, “Tuhan, reyae borale.” ");
INSERT INTO set_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Tuhan mae weunge, “Nda hee yae na hibi kulun wele Yudasle imae nibi mbai na ro ‘ijen foijen selene hebelere’ eye. Ro mbai Tarsus yona na ro Saulus nebei ijende eumihineukonde. Nebei ro namman Rare ebeline boimeyeufe. ");
INSERT INTO set_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Saulus na ijoko raneungeboke yae erele ro mbai na ro Ananias, meke na me na u randa koloungekoke benen na ijoko kelengkonde erendere.” ");
INSERT INTO set_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias yae benen weunge, “Tuhan, reyae borale nda ro Waei eleubokae wekaemae ro miyaere beko nekai sele Yerusalem yona mokoimeyeumi. ");
INSERT INTO set_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Mana ndana meke. Imam yun-jun mae homo ikainyele ndare meke Ware eise moloyayete ro miyaere ikilendere.” ");
INSERT INTO set_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nebeibe Tuhan mae Ananiasre weunge, “Eyeise mo eye! Reyae nare eleubokale Raei burelen boi-boise orondere. Ro miyae kani hi kela hina Yahudi ban yo belere naei ondofolo-ondofolo belere Israel ro miyae belere Raei are huwemmiyendere. ");
INSERT INTO set_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Reyae erengkelembonde Raei Ro aerene neyae beko helen hubannekonde.” ");
INSERT INTO set_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Na hibi Ananias eke nebei imaere eke eweufike na mere mo Saulusle ranne koloungekoke weunge, “Aka baeke Saulus, Tuhan Yesus ndare mewoyae nibi nolone erekanae Kiyae yae ukeufe waei bokore mekale. Wa ijoko keleukonde erelere nane merau Allahle Roh ware ei aneibote.” ");
INSERT INTO set_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ane uwounge hee Saulus na ijokora ka ningkei wanen mae kulauboke ruke. Na hibi na ijoko yoloungekoke erewole. Neyae aunguke mo, bu koungeboke. ");
INSERT INTO set_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Nebeisa raman aneukoke wa, na u elae rouke. Yesusre hakainyekoke ro miyae Damsyik yona nekewate yo bokone Saulus ya name keli hului meungekeukoke. ");
INSERT INTO set_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nebeisa Saulus na hibi ei mom-mom imaene eyeisiyele huweumi Yesus na hele Allahle Kelu. ");
INSERT INTO set_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ro miyae nemene Saulus nebei a wanen elewolene fa yae bowate. Nenaeijae elate, “Nda ro mbai Yesusre eise moloyainye ro miyae Yerusalemna yore bekore mokowoumi kiyae. Naendae wanen, ndare meke Yesusre hakainyekoke ro miyaere ikilende imam yun-jun bokore yobonde enatere?” ");
INSERT INTO set_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saulus nebei ro miyaere kelewoumi Yesus na hele Wali Ondofolo. Nebei a faeu elewole ro miyaere kena hauwoumine, Damsyik yona Yahudi ro miyae u bene baeiso-baeiso kowate naendae wanen mae Sauluslena a elelere na hele, na hele ban mae elenate. ");
INSERT INTO set_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ya heki holo mainyekeukoke mo, Yahudi ro miyae merau rainyehike Saulusre honaibondere. ");
INSERT INTO set_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Nebeibe Saulus nebei merau kolowainyelebe isaeyeuboke. Reniai rai nebei yo elere naeibokene romau kaban-kabanne Saulusre honaibondere ereiko rakeiko kowainye. ");
INSERT INTO set_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Nebeibe reniai ya mbai, Saulus na moisa orate yo yae ela kaban einye aiboke. Yo elere naeiboke ranna ha yae nokainyele owole. ");
INSERT INTO set_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulus Yerusalem yone eke nebeinya Yesusre hakainyekoke ro miyae bele mbainye yaungaibonderebe, nebeibe nare fe yae faewainye. Neyae elate Saulus u rundunbe bole. ");
INSERT INTO set_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Mainyekeukokera Saulusle bokore Barnabas meke Yesusle abu ako naei bokore yaweungehoke ekete. Saulus Damsyik yore ewole heene Tuhande erekeunge bele Tuhan Naei a Saulusre uwounge bele nane merau Yesusle ro yae Damsyik yone fere efaei sele kelewoumi bele nemene Barnabas huwewoumi. ");
INSERT INTO set_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Nebei wanenne Saulus nebei yo bele nanembainye nekewate. Nane merau Yerusalem yo reufire-reufire Yesusle Ro yae Saulus fe efaei sele Allahle a faeufe kelewoumi. ");
INSERT INTO set_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Yahudi ro miyae Yunani afaeu wae elate yo bele naeise naeise a eibeko meibeko kowate, nebeibe Saulusre honaibondere relewainye. ");
INSERT INTO set_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Yesusre hakainyekoke ro miyae hiwa nebei a wanen borokate bae, Saulusre yawainyehoke Kaisarea yore ekate, nebeisa Tarsus yore hawainyekoke ewole. ");
INSERT INTO set_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Saulus eke wa, nebei Yesusre hakainyekoke ro miyae Yudea kanina, Galilea kanina, Samaria kanina nemene buhae osaeiboke. Allahle Roh yae nebei ro miyae naei kena ure hara rorowoumi nane merau elae wake ikeumi. Tuhan mae weumi are ei hauwainye nane merau nebei holona ro miyae emerei-emerei emerewole. ");
INSERT INTO set_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Nebei hee Petrus yo ran yo randa oroweke. Roko mbai Lida yore eke, nebeinya Yesus Naei eleuboke wekeumi ro miyaere hubainyaikondere. ");
INSERT INTO set_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Lida yona ro mbai na ro Eneas. Noro me nimainyekoke na kewa ran yun make ranne mo honoweke ralo yakama mehine name bele. ");
INSERT INTO set_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petrus yae Eneasre weunge, “Eneas, Yesus Wali Ondofolo ware onomi ikete. Ainyu wa kewa yun make yaroiko.” Petrus ane uwounge hee Eneas na hibi ewaunguke. ");
INSERT INTO set_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ro miyae Lida yona Saron yona nemene Eneas oro bele orowolere erewainyele yo nemene Tuhan Yesusre na hele yae elewate hila rabo halewainye. ");
INSERT INTO set_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Yope yona miyae mbai na ro Tabita. Nda miyae Yesusre hila rabo haleungeke. (Na ro Yunani afaeunge Dorkas.) Naei me u foi sele mokoweke nane merau hun ban wai ban ro miyaere roko helen hakoumiyeke. ");
INSERT INTO set_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Nebei hee era meukoukokera mo hereke. Nebei no bu kainyebokera, yowa imae bumana rakane yaeinyeneke honowole. ");
INSERT INTO set_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yope yore Lida yora ahau banne Petrus Lida yone ekenekele a Yope yona Yesusre hakainyekoke ro miyae borokate hee, ro bee ukaimile Petrusle bokore ekete, weinye, “U hale yae weyae hakoumebonde emalere!” ");
INSERT INTO set_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Petrus aunguke hakoiboise mo hakoumiboke. Petrusre yawainyehoke yowa buma rakana kayeere ikate. Nebeinya miyae nannale (rora molaikoke) yo nemene mekate Petrusre yanainyekoke, na rimahili bele haiwate nane merau Dorkas na waline nekewole heene malo yoni-yoni hawoumi bele Petrusre kelewainye. ");
INSERT INTO set_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petrus nebei yore ukeumi moise ai baleke mo, nembai oro selen-selen mae roroukoke Allahre ebeli bowounge. Nebeisa Dorkasle no honolere be beufoke weunge, “Tabita, ainyu!” Dorkas na ijoko keleukoke, Petrusre erekeunge hee na hibi angken nuweuboke. ");
INSERT INTO set_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petrus na me nekeunge Dorkas mera ikileungeboke na hibi aungenuke. Nebei yona Yesusre hila rabo halewainye ro miyae bele nebei miyae nannale bele kaeneumikoke mekate, Dorkasre mo na mene kinyeumiboke. ");
INSERT INTO set_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nda iwau rileuboke Yope yona ro miyae bele borowate. Nebeinye ro miyae helen Yesusre na hele yae elewate hila rabo halewainye. ");
INSERT INTO set_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Nebei yona ro mbai na ro Simon obo yoku rare haweke kiyaele bokone Petrus ya heki ban nekeukoke. ");
INSERT INTO set_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kaisarea yone ro mbai na ro Kornelius nekewole. Neyae Yahudi ro ban. Buloo felare be yun be yebaere hebewate nolora neyae Italia homo naei yunde hebewole. ");
INSERT INTO set_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kornelius Allahle are hubara haeisa yaneungeke nane merau Nare ei moloungeke. Nebei sului mbai naei imae ei obe einya yo. Ro miyae koufe kalore molowoumi yore eisako meisako nekai hakoumiyeke. Na yane baei Allahre ebeli bainyeke. ");
INSERT INTO set_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ya mbai huae rai hujoko oke name hului yae na ijoko raneungeboke erewole Allahle malaikat na yaka yae erewounge meke weunge, “Kornelius.” ");
INSERT INTO set_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kornelius nebei malaikatre erekeunge na fe bele faewounge weunge, “Erabuhi wanen, Tuhan?” Nebei malaikat yae weunge, “Webeli kali boyeyae bele waei yei wahei kounga kalona yore yeyaemae bele nemene Allah be hineubokete nane merau Allah waei bene nekeungehike. ");
INSERT INTO set_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Mana ro miyae weimi Yope yore ai. Nebeinya ro mbai na ro Simon Petrus, ungainyele ndare mende. ");
INSERT INTO set_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Simon obo yoku rare hale kiyaele imae buhaeinya ekehebelene Simon Petrus ekenekele.” ");
INSERT INTO set_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nebei malaikat Korneliusle are elete kiyae ewole mo, Kornelius na yebaei bubaei ro bee bele Korneliusle naei u kayaare hebeyate na robe na wali Allahle are hubara haeisa yaneungeke bele kaneumikoke mekate. ");
INSERT INTO set_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kornelius nebei ime wanen ma kaeneungeboke ahubare mo huweumikokera, hokolo namere mo ukeumi oro molaiboke Yope yore ewate. ");
INSERT INTO set_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ya heuboke rai sului hokolo name Yope yo nobewainye yae wa, Petrus imae bumare yeuketeke Allahre ebelire bonnelere. ");
INSERT INTO set_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nebeisa moni yaroungekoke ramande anengkondere kenabe kowole. Nebeibe ramanne mokowate yae, Petrus na ijoko ranainyeboke ime wanen mae erele. ");
INSERT INTO set_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Yaku raweuboke bulura malo wanen kaeu mau ha yae na rayee kelira bayaeikoke, nda kanire nokainyele ole. ");
INSERT INTO set_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Neinye obo yoku mahi-mahi nda kanina oro kelire koyate yo, ara foyate yo, aye yoni-yoni. ");
INSERT INTO set_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Nebeisa a mbai weunge, “Petrus, ainyu! Foloi anei!” ");
INSERT INTO set_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Nebeibe Petrus yae weunge, “Na hului ban, Tuhan! Meyae Yahudi ro miyae naei era hena huluinye nebei obo yoku eli hohore nekeyande nane merau u nenere koyande raman. Reyae ya mbai aneikoi mo nekeyale.” ");
INSERT INTO set_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Nebei a mbaibe benende weunge, “Allah yae onomire mokoungeboke rambun weyae elire enekeijae.” ");
INSERT INTO set_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Naei wanen mbai roko name nendo keleungekokera nebei malo benende kaeuboke bumare ewole. ");
INSERT INTO set_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petrus u bene baeiso-baeiso kowole, rahe naeise nda wanen keleuboke erekole. Petrus namman u benene nekainye bele, Kornelius yae ukeumi ro name mekate. Simonbe imae kelaeiboke bene mekaisebate. ");
INSERT INTO set_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Nebeinya yore kaenaimikoke mo hinaimi, “Simon Petrus nda imaene nekele?” ");
INSERT INTO set_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Namman Petrus nebei ime kaneungebokere na mekaise isaeyembondere u bene baeiso-baeiso kole yae, Allahle Roh yae a weunge, “Simon, ro name ware baeimeyayete. ");
INSERT INTO set_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ainyu oyakoibo nebei ro namere hakoimibo eme. Buhae ohokoijae, nebei yo Reyae ukamaele mekate.” ");
INSERT INTO set_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Nebeinye Petrus owakouboke, weumi, “Reyae nda niyae mayae baeufe kiyae. Rabuhi wanenbe ndare mekaube?” ");
INSERT INTO set_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Hokolo name yae wainye, “Fela yunde hebele kiyae Kornelius yae maere ukeume ndare mekande. Neyae ro mbai na wali himaloungeboke nane merau Allahle are hubara haeisa yaneyeunge. Yahudi ro miyae nemene nare ereibo kaneibo koyainye, naei ebeli Allahre bowounge Allah wo koungekokene. Allah Na malaikat yae meke, Korneliusre ukeunge ware rinyeufinde naei imaere elere. Malaikat yae ukeunge waeinya a faeu elelere Kornelius borombondere.” ");
INSERT INTO set_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Hokolo name Petrus yaweumiboke, nebei imaene reniai ya mbai ijongku hononaikondere. Ya heuboke mo, Petrus hokolo name bele nanembaisa alainyekoke ewate. Yopena Yesusre hakainyekoke ro miyae hiwa nangkele hakaimikoke ewate. ");
INSERT INTO set_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ya bee nendo Kaisarea yone aibaleke. Kornelius naei aka baeke, naei hokolo uneyau keke haha nemene kaenewoumi, Petrus naeise ereiko rakeiko kowaimi. ");
INSERT INTO set_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petrus meke bae, Kornelius ara hele ruke Petrusre rore melaeyennebondere. ");
INSERT INTO set_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Nebeibe Petrus yae weunge, “Ainyu! Wangkele rangkele na hului mbai.” ");
INSERT INTO set_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Korneliusle ane eleyete bele Petrus imae eise eweufike. Nebeinye erele ro miyae helen sele arilewole. ");
INSERT INTO set_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Petrus nebei yore weumi, “Mayae nemene maisaei bangka mo, meyae Yahudi ro miyae wali heere foloukoke huluinye Yahudi ban ro miyae bele mbainye enekei nane merau mbainye a elei. Nebeibe Allah meke rare keleufeboke ro miyae nde-nde nemene reyae niki bele kanau bele yae nane merau ele moise yae woke a yae eleyeijae. ");
INSERT INTO set_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Nebei aerene weyae ukamae ekatere reyae na rilibo ban mae mekale. Mana ya reyae isaeisebonderene a hinereisitere, ‘Rahere weyae kaeneufekokae mekale?’ ” ");
INSERT INTO set_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornelius yae weunge, “Ya keli moise wokandene hu oke nda hujoko name hului yae raei imaene Allahre ebeline bowanale. Raei bene ro mbai yakaiboi yae yakauboke, nambelae wili haleman. ");
INSERT INTO set_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Neyae weufe, ‘Kornelius! Waei ebeli kali bowanae Allah boroubokete. Nebei sului mbai waei yei wahei rore miyaere kounga kalona yore yeyaemae Allah u bene nekeungehike. ");
INSERT INTO set_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Nebei aerene mana ro hiwa weumile Yope yore enate Simon obo yoku rare hale kiyaele imae buhaeinye ekehebelene ekenekele. Ro mbai na ro Simon Petrus ungainyele ndare mende.’ ");
INSERT INTO set_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nebei meraunge reyae na hibi ro ukamaele waei yaweisoise ekate. Weyae kena foinyene ndare mewoyae. Mana ya meyae nemene ndane Allahle bene arilewounge nekande. Allah rahebe a uwote maere weumele boromalere mekannekande.” ");
INSERT INTO set_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Petrus yae weumi, “Nda hee yae wa reyae isaeyeubokale Allah na hele ro miyaere be ijokone ereyei. ");
INSERT INTO set_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Allahle are hubara haeisa yaneyainye nane merau me u foise mokoyate ro miyae Allah ei ammibonde, makei yona bele ban. ");
INSERT INTO set_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Aka naei baeke naei, maisaei nekaube Israel ro miyaere mo nda a foi faeu foi Allah uwoumi, ‘Yesus Wali Ondofolo nemene naei Tuhan, Naei walora ro miyae na hului kena foi u foi bele nekenate.’ ");
INSERT INTO set_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Aka naei baeke naei, Yudea kanine bewate rambun yoni-yoni mayae maisaei nekaube. Galilea kanira huba raweuboke Yohanes a faeu huwoumi, ‘Mayae nulu kembokembere kelembonde naeise bu konayengkombe.’ ");
INSERT INTO set_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nane merau Allah yae Yesus Nasaretna Rore Naei Roh bele Naei elae wake bele uwa kiteungeboke. Allah Nangkele mbainye nekewotene, Yesus makeise-makeise orowole na me u foise mo mokowole, nane merau walobo yunbe me kelee u keleene nekayekene era buloo kayeke ro miyaere onomi yeumiyeke. ");
INSERT INTO set_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Neyae Israel kani nemene nane merau Yerusalem yone rambun mahi-mahi mokowolere meyae ijoko yae erewande. Naendae wanen hororebe Neyae foi mokowolerebe, nebeibe ohaline baikoke haiboke. ");
INSERT INTO set_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Nebeibe ya name mo Allah yae mahe yora waleungeboke, benen Nauwa ro miyaere yakawoumi. ");
INSERT INTO set_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ro miyae nemene ban, nebeibe meyae Allah bera eleuboke wekeume ro miyae Yesus benen waleuboke heera Nangkele raman bu anewande yo yae mo, ijoko erannekoke. ");
INSERT INTO set_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nane merau Neyae maere ukeume Naei a foi faeu foise nane merau Nembai sele Allah yae a ukeunge herewate yo bele wali nekate yo bele naei wali hului kolommibonde naei a, ro miyaere huwemamiyendere. ");
INSERT INTO set_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Allahle yenjo kayaayo yae Naei a faeube isaeyaeimekoke. Nebei yo yae elewate, nde yae Yesus Naei abe elelere hila rabo halennelena, na beko neban ennefaeinyembonde.” ");
INSERT INTO set_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petrus namman ane elele yae, nebei ro miyae angkaeise borate yo nemene Allahle Roh yae oke aumiboke. ");
INSERT INTO set_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Allahle Roh Yahudi ban ro miyaere aumibokene, Yope yona Yahudi ro miyae hiwa Petrusre hakainyekoke mewate yo nemene fa yae bowate. ");
INSERT INTO set_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Rabuhine ban, neyae borowate nebei ro miyae afaeu mahi-mahi elewate, Allahre buma kolowainyene. Nebeisa Petrus yae elele, ");
INSERT INTO set_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Eremmibo, nda yo aeinya wanen mbai Allahle Rohbe yaraikoke. Rahene nare bu nendon okoi?” ");
INSERT INTO set_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Petrus ukeumi Yesusle Ro yae bu konaimikonde. Nebeisa Petrusre riyainyehike nangkele ya heki ban nekenaikonde. ");
INSERT INTO set_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Yesusle abu ako bele Yudea kanina ro miyae Yesusre hakainyekoke yo nemene bele Yahudi ban ro miyae Allahle a faeufe ((Yesusle naeise)) na hele elewate are angkaei boraiboke. ");
INSERT INTO set_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Petrus Yerusalemde eke heene, nebei Yahudi ro miyae Allahre hakainyekoke yo yae a yarewainye, ");
INSERT INTO set_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","wainye, “Rahere Yahudi ban yo naei imaere oroyae nane merau raman bele mbainye ekawanaube?” ");
INSERT INTO set_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Nebei a elayokene, Petrus nebei me u ebi kaban mokowole naei yeiboise yeubokera yakawoumi, ");
INSERT INTO set_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","weumi, “Reyae Allahre Yope yone ebeline bowanale hee, raei ijoko beufehoke erewale malo wanen kaeu mau ha yae na rayee kelira bayaeikoke yakura nda kanire nokainyele owole, raei bokone yauboke. ");
INSERT INTO set_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Eise wekale hilowale, neinye obo yoku mahi-mahi nda kanina oro kelire koyate yo, ele moise woke koyate yo, rami yoni-yoni, aye yoni-yoni einye mo erewamaele. ");
INSERT INTO set_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nebeisa borowale a mbai rare uwoufe, ‘Petrus, ainyu! Foloi anei!’ ");
INSERT INTO set_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Nebeibe reyae beufokale wanale, ‘Tuhan, nebei meyae elire hohore, u nenere koyande raman, reyae ya mbai aneikoi mo nekeyale.’ ");
INSERT INTO set_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Nebeibe yakura borowale a faeu mbai benen rare weufe, ‘Allah onomire iwoumi rambun weyae eli yae u bene enekeijae!’ ");
INSERT INTO set_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Nebei wanen mbai roko name ereukokale, nemene na hibi kaeuboke yakure ewole. ");
INSERT INTO set_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Nebei hee yae, ro name Kaisarea yora ukaimile raei weise reyae nekewale imaere mekate. ");
INSERT INTO set_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Allahle Roh yae ukeufe mekate yore weyae na hibi hakoumibondere. Neyae Yahudi ban ro miyaene, weyae buhae ohokoijae! Nebei jemaatna aka baeke mehine mbai rare hakaisekoke Kaisarea yore ewande. Meyae nemene Korneliusle imaene andeuboke. ");
INSERT INTO set_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Nebeisa Kornelius naei imae einye malaikat meke yakaungeboke ahubabe maere huwewoume. Nebei malaikat yae Korneliusre weunge, ‘Ro hiwa weimi ai, Simon Petrus Yope yona ekenekele kiyaere ungainyele mende. ");
INSERT INTO set_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Nebei kiyae mende a ungengkombe yae weyae nane merau waei imae mbai obe mbainye nekeyaube yo bele wali hole molonembombe.’ ” ");
INSERT INTO set_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Petrus benen ahuba ahuneungeboke huwewoumi, “Nebei ya ane huba raweubokale uwamaele mo, Allahle Roh aere aumeboke wanen mbai nebei are borowate yore aumiboke. ");
INSERT INTO set_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nebeisa wa reyae u bene nekaisehike Yesus roko hi eleukoke, ‘Yohanes bu yae kowoumi, nebeibe mayae Allahle Roh yae konengkombe.’ ");
INSERT INTO set_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nebei aerene reyae isaeyeubokale, eyae Yesusre hila rabo halewannera Naei Roh ikeume. Nebei wanen mbai Yahudi ban ro miyaere Allah Naei Roh yeyeumi. Nebeinye reyae Allahre hee eneisai sului!” ");
INSERT INTO set_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nebei ahuba boraikokene, benen aku ohoi yeuboke. Nebei ro miyae Allahre bumare mo kolowainye. Nenaeijae elate, “Nebei wanenna Yahudi ban ro miyaere Allah waeumihike na beko bakora nulu emmikembonde yo wali hena bonare enaijaronde!” ");
INSERT INTO set_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stefanus haiboke heera, Yesusre hakainyekoke ro miyae beko hele hubawainyene, a hine a hine heraeyeuboke ewate. Hiwa nda anuwaufe yae habeleyeke: Fenisia kanine, Siprus yokobane, Siria kanina Antiokhia yone. Nebei yo Yesuslena a foi faeu foi Yahudi ro miyaere mo kelaeimiyeke. ");
INSERT INTO set_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Nebeibe nda nolona Yesusre hakainyekoke ro miyae hiwa Siprus yokobara, hiwa Kirene kanina ro miyae Antiokhia yore ekate. Yahudi holona ban Yunani ro miyaere Tuhan Yesuslena a foi faeu foi kelaemiyeke. ");
INSERT INTO set_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Allah yae ei aumibokene, nebeinye ro miyae helen Yesusre hila rabo halewainye nane merau Tuhan mae elewole a huluinye hakowainye. ");
INSERT INTO set_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Nda wanen bewole a eungeyouboke Yerusalem yona jemaat boraibokene, Barnabasre ukainyele Antiokhia yore eke. ");
INSERT INTO set_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Barnabas eke erewole nebeinya ro miyae Allah na hele kena buhae aere ban mae hewoumine rei sele kowole. Barnabas yae a usaei uwoumi Tuhan are weumi huluinye na hibi-hibi nekenayende. ");
INSERT INTO set_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Nda Barnabas na u mekai foi sele nane merau Allahle Roh yae maemae koungekoke. Yesus Naei a elelere na hibi-hibi hila rabo hele halewolene. Nebei yona ro miyae helen sele yaweumiboke Yesusre hila rabo halenainyelere. ");
INSERT INTO set_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Nebeisa Barnabas kulun uke Saulusle baeikoise Tarsus yore eke. ");
INSERT INTO set_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Saulusre hubayeikoke mo, na hibi yaweungehoke Antiokhia yore ekete. Nebei yona Yesusre hila rabore halaeinye yo nolone ralo yakama mbai nekeikoke. Ro miyae helen Yesusle are keleimiyeke. Antiokhia yone Yesusre hakainyekoke mewate yore huba rawaiboke Kristen ro miyae yae kaenewaimi. ");
INSERT INTO set_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Nebei hee yae Allah are weumi huwate yo mbemba Yerusalem yora Antiokhia yore ekate. ");
INSERT INTO set_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Nebei yo nolona mbai na ro Agabus. Allahle Roh yae a weunge walora a relen harewole, nda kani kela Israel moni mai kaban sele memminendere. (Na hele Ondofolo Klaudius yae hebewole hee yae yeuboke.) ");
INSERT INTO set_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Yesusre hakainyekoke yo a mbainye elaikoke naeise-naeise rambun ufekoke huluinye rambun-rambun arilewate Yudea kanina Yesusre hakainyekoke ro miyaere inyaimilere. ");
INSERT INTO set_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Elaikoke hului mokaikokene, Saulusle Barnabasle nebei rambun arilaisike bele ukaimile Yudea kanina jemaat naei be yun be yebae bokore ekete. ");
INSERT INTO set_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ondofolo Herodes nebei hee yae Yesusre hakainyekoke yore meuboi auboise kommilere hiwa yo ikileukoke. ");
INSERT INTO set_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ondofolo Herodes yae ukeumi Yohanes na aka baeke Yakobusre rame yae haiboke. ");
INSERT INTO set_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Yahudi ro miyae yae nda wanen mokowolere erewate kena hele kowatene, benen Herodes yae ukeumi Petrus bele ikilenaibonde. Israel naei yobe naei kamahe naei Mesir kanine roti ragi ban anaikoke bene nekei-nekei ya kabanne ((Paskah)) kowate ya yae yeuboke. ");
INSERT INTO set_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Petrusre ikilaiboke na hibi kawane ahaeinyekoke, felayo raka keli naei kayaare hebewate. Raka mbai ro keli. Herodes merau raungehike Paskah ya kaban baensondera wa, nebei yona are kolaimi yo bene Petrusre a hinenainyele. ");
INSERT INTO set_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Nebeinye Petrus kawane mo ahaeinyekoke hebeumeke, nebeibe Yesusre hakainyekoke riya mbai imae mbainye Petrusle naeise Allahre ebeli na hibi-hibi mo bowainye. ");
INSERT INTO set_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ya hembonde Petrusre a koloikoise yawennehonde enate reniai Petrus rantai bee yae na me rinainyekoke kayaayo ro bee hele nolone ijongku honoumeke. Kawa romaunge, kayaa yo hiwa nane merau kayaa ayaeisake. ");
INSERT INTO set_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Allah na malaikat Petrus honole ijenne yakaiboi meungeyakauboke. Nebei ijenne hehe naeukoke. Malaikat Petrusre me yae neungehike aunguke, “Ainyu hasale yae!” Petrus na mene rame ha rinewainye rubouboke ruke. ");
INSERT INTO set_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Nebeisa malaikat yae weunge, “Wa ambelae bele oro mehau bele hireiko.” Malaikat ukeunge huluinye Petrus nambelae bele oro mehau bele hireukokera malaikat benen weunge, “Ninae hireukokaena, rare hakoisobo.” ");
INSERT INTO set_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petrus nebei malaikatre hakoungeboke na hibi moinya meibaleke. Malaikat yae mahi-mahi mokowolere Petrus isian, na ijoko ka yae raneungeboke na be baete yae mo na u benera nekewainye. ");
INSERT INTO set_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ekete kayaa yo raka mbai bee bele moi wokete, yore enayembonde besi yae mokaiboke romau kaban be rainyehike. Nebei romau kaban nenaeijae wekeunge, hokolo bee eibalekete, nibi fofo mbaisa aloinyekoke hee, nebei malaikat nundeiboi yae nundeuboke Petrusre nukeungeboke. ");
INSERT INTO set_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Petrus naei une yeuboke naeise nebeisa wa u bene rouke, nebeisa elewole, “Mana reyae isaeyeubokale. Herodesle me eisa nane merau Yahudi naei nun yoko yae merau kolowainye eisa Allah nana hesele Na malaikatre ukeunge raei hayeikoise meke.” ");
INSERT INTO set_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","U bene nekainyekoke mo, Petrus aloungekoke Yohanes (nane merau Markus yae kaeneyainye) nenake Mariale imaere eke. Nebeinye ro miyae helen arilewole Allahre ebeline bowainye. ");
INSERT INTO set_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Bere bohina romaufa Petrus me kaba-kaba boukoke mo, maengke mbai, yebaei bubaei, na ro Rode meke romaufe rawennebondere. ");
INSERT INTO set_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Petrusle a faeuko roungeboke, Rode rei yae aungebokene eise hakauboke eke, nebei romau bae eraweiboi. Nebei ro miyae einye nekate yore weumi, “Petrus moinya meke hebele.” ");
INSERT INTO set_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Nebei yo yae wainye, “Weyae keube koyae!” Naendae wanen hororebe Rode a na helene mo elae hebewole weumi ndi Petrus hele eke hebelebe, nebei yo yae wainye. “Nebei naei malaikat ya!” ");
INSERT INTO set_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Nebeinye kolowainye, Petrus me kaba-kaba na boi-boi mo bowoke. Nebei ro miyae mekate romau rawaiboke Petrusre erekainyelene fangkengke yae bowate. ");
INSERT INTO set_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Are hinenainyelerebe, Petrus me kaukau koumikoke. Nebeisa Allah na mekai kawa eisa yaweungehoke meibaleke ahubane huwoumi weumi, “Embe, Yakobus nane merau aei aka baeke hiwa yore huwemmikombe.” Baeufoke bae, Petrus benen anuwau hire yae ewole. ");
INSERT INTO set_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ya heuboke na rene hele, nebei kayaa yo nolone aku keteuboke elate, “Petrusre rahe yae meke mokoungeboke?” ");
INSERT INTO set_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Nebeinye Ondofolo Herodes ro miyaere ukeumi Petrusre baewainye, nebeibe ehubayeikoi. Ondofolo Herodes nebei kayaare hebewate yore a hineumikokera ukeumi honaikondere. Nebeisa Herodes Yudea kanira eke Kaisarea yone eke nekewole. ");
INSERT INTO set_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Tirus bele Sidon bele yona ro miyae bele Ondofolo Herodes bele heki hele kena ikele nekaimeke. Herodesle me keleene honole kanina raman nebei yo bee naeisa roi yae yaroyeumine, Herodesle bokore ekate foise mokonaikondere. Nebei yo bee na ro hiwa ekate Ondofolo Herodesle imae eise mere mokole ro na ro Blastus, a moi-moi yae mokainyekoke nare hakoumiboke. Nebeisa Ondofolo Herodesle bokore mekate. ");
INSERT INTO set_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Are elaikoke ya, Herodes na yo malo yan malo keteungeboke ike na kendan wameranne yeunguweuboke, na ro miyae arilewole bene a na kaban mae kaenele. ");
INSERT INTO set_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Borowainye ro miyae naeise-naeise kaenate, “Nda walobo a faeukobe elele, ro hele miyae hele naei a faeuko ban!” ");
INSERT INTO set_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Allahre ei omoloiboi nebeibe naei uwa yae kaeubokene, Allah Na malaikat meke Ondofolo Herodesre me fae uke, na kendan wameranne hen mae kana yae nau nemene folaiboke, hereke. ");
INSERT INTO set_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Allahlena a foi faeu foi hurewole nane merau Yesusre hakowainye ro miyae emerei-emerei emerewole. ");
INSERT INTO set_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabasle Saulusle Antiokhiana yo naeinya rambun Yudeana Jemaat yun-junde waheimikoke baeufokera hokolo bee benen Yerusalem yora bukeibokete, Yohanes Markusre yawainyehoke nanembaisa ewate. ");
INSERT INTO set_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiokhia jemaatna ro miyae nolora hiwa Allah a weumi huwaimi meli mekai bele hiwa hiwa ro miyaere isaeise kelaeimi meli mekai bele. Nda na ro niyae: Barnabas, Simeon (u elan nokombi yae iwewainye), Lukius (Kirene yona ro), Menahem (Ondofolo Herodesle nanembainye narewate), nane merau Saulus. ");
INSERT INTO set_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ya mbai Allahre ei molowainye nane merau yarele me haeiboke nekewate yae, Allahle Roh yae a weumi, “Reyae mokoungehakale rambun mokoneyende naeise Barnabasle Saulusle kinyenseko.” ");
INSERT INTO set_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Yarele me haeiboke nekewate nane merau Allahre ebeli bainyekoke wa, hokolo bee Saulusle Barnabasle u ranne me kolaimikokera ukaimile ewote. ");
INSERT INTO set_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Allahle Roh yae ukeumi ewotene, hokolo bee Barnabasle Saulusle oro moloiboke Seleukia yore ewote. Ekete mo, na hibi bu wakara Siprus yokobare ewote. ");
INSERT INTO set_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ekete Salamis yone mo, Yahudi naei ei mom-mom imaene Allahle ako faeuko kelewoimi. Yohanes Markus hokolo bee hakoi-sakoise nangkele hakoumiboke ewate. ");
INSERT INTO set_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Siprus yokoba oroikoke yaneikoke, ekete Pafos yone. Nebei yone Yahudina ro mbai na ro Bar-Yesus hubayaeikoke. Na yun buloo maemae koungekoke. Nauware yendo kayaalo yae elewole. ");
INSERT INTO set_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Sergius Paulus Siprus yokobare Gubernur hebewole kiyae, nda Bar-Yesusre naei kahili. Nda Gubernur isaei bele hebaen bele ro. Allahlena ako faeuko borombondere kena hele kowolene, hokolo bee Barnabasle Sauluslere kaeneumikoke. ");
INSERT INTO set_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Nebeibe hokolo beere Elimas yae (Bar-Yesus na ro Yunani afaeunge) ahei-ahei yae ahewoumi, Gubernur Sergius Paulusre mokowounge Yesusre na hele yae eleijae. ");
INSERT INTO set_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Naendae mekaisebe, Saulus (nane merau Paulus yae kaenainye kiyaere) Allahle Roh yae maemae koungekoke eke Elimasre na ijoko bele keleungekoke weunge, ");
INSERT INTO set_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Ei, walobo yunbe kelu, foise moise horoyae kalayae, ame-ame na no. Allahlena na hele wali nibire weyae mekae horoyae kalayae. Makei yare me no yele? ");
INSERT INTO set_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Mana erei Allah ehee bukulure inyetere! Wa ijoko roroneukonde hu ijoko ereiboi yae ya heki holo meungekeukonde.” Nebei hee, Elimas na ijoko hubawounge mangko nokombi wanen mae feleungeboke. Elimas meka-meka baewole ro miyaere ikilembonde nare yawenainyehonde enatere baewoumi. ");
INSERT INTO set_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gubernur Sergius Paulus nebei wanen yeuboke erewolene, Yesusre hila rabo halewounge, Yesusle a faeufe borowole eme hele yae elewole. ");
INSERT INTO set_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pafos yora Paulus na kahili wa riyana bele Pamfilia kanina Perga yore ekate. Ndane Yohanes Markus, Paulus naeise nukeumiboke bukeufike Yerusalem yore ewole. ");
INSERT INTO set_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Paulus naei Perga yora alainyekoke Pisidia kanina Antiokhia yore ewate. Sabat yane Allahre ei mom-mom imaene ayeuboke nuwaikoke nekewate. ");
INSERT INTO set_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Musale walora wali heere foloukoke homo nane merau Allahle yenjo kayaayo molaikoke homone raikoke baeufoke mo, ei moloi-moloi imaena yun-jun mae Paulus nane merau na kahili wa riya nare waimi, “Aka naei baeke naei, mayae na huluinya nda ro miyae na kena ure hara rorommilena, nebei a faeu huwengko.” ");
INSERT INTO set_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paulus aunguke me yae isaei ikeumi wa, huba raweuboke huwoumi, “Aka naei baeke naei Israel yoni-yoni, nane merau aei aka naei baeke naei Yahudi ban ro miyae Allahle are faeufe boroyaube hakoyaunge yo, rare boronsobo! ");
INSERT INTO set_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel yoni-yoni naei Allah aei yobe naei kamahe naeise eleumiboke wekeumi. Mesir kanine meiko-meiko yo wanen mae ekainyekewate hee yae Allah mokoumiboke yoho kabande yeuboke. Allah Naei elae wake kaban mae Israel yaweumiboke Mesir kanira maibaleke. ");
INSERT INTO set_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ralo yakama rorele u bee a kala-kalane naei u mekai wa mekai beko nekaimekere Allah kena yae herauweumeke. ");
INSERT INTO set_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Nebeisa Kanaan kanina nekewate ondofolo mehine bee na ro miyae bele Allah houkoke hayeukokera nebei kani Israelre kinyewoumi. ");
INSERT INTO set_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Mesir kanire ayeubokera mekate Kanaan kanire mayeuboke, nemene fomene me baeimeke na heki ralo yakama 450. “Kanaan kani waheumikoke baeufoke mo, Allah walire hului kolaimi yore kinyeumikoke. Walire hului kolaimi yo naei huba mokoikoinya kiyae Allahle yendo kayaalo Semuel niyae. ");
INSERT INTO set_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Nebei heene Israel Ondofolore riyewate. Kisle kelu Saul Benyaminbe orona menabe Allah kinyeumiboke. Ondofolore ralo yakama rorele u bee meufebeukoke. ");
INSERT INTO set_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Saul Ondofolora kereungekoke oke mo, Daudre raneuweke benen nebei anuwaufe haungeboke mokowole. Daudle naeise Allah nda wanen mae eleukoke, ‘Isaite fa Daud erekanale Raei kenane eweufike. Raei kenare kale neyae mokombonde.’ ");
INSERT INTO set_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Daudle orona menara Israel naei Walilo Yesus Wali Ondofolo raneujeke, Allah are heteungekoke huluinye. ");
INSERT INTO set_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesus namman Naei kalia huba eraweiboi omokoi hee yae, Yohanes Israel ro miyaere a kaenewoumi weumi, ‘Mai beko bakora nulu kenayembe, bu kombombe.’ ");
INSERT INTO set_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yohanes mokoukoke kaliare riyaufe bonnele hee, rore miyaere weumi, ‘Mai u benera nekayembe rare nde yae elaube? Reyae nebei mayae rakaunge Wali Ondofolo ban ma. U bene nekenayembe, nebei Ro raei moisa mende, Naei oro mehaufe reyae ekulaikoi sului, rabuhine ban Naei bene reyae yeisi raeiboi ban.’ ");
INSERT INTO set_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Aka naei baeke naei Abrahambe orona mena yo nane merau aka naei baeke naei Yahudi ban yo Allahle are boroyaube hakoyaube yo ndane mekaufebaube yoni-yoni, Allahlena wali hole molommebonde a faeu ukeume huwemamilere. ");
INSERT INTO set_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Yesus mbai Wali Ondofolo Niyae Yerusalem yona nekewate ro miyae bele naei be yun be yebaere hebewate yo bele onewate handawate. Allahle yenjo kayaayo naei a faeu molowate Sabat ya yae kayeke borayeke. Nebei a faeu hului neyae isaei eyeiboi yae Yesusre haibokate. ");
INSERT INTO set_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Naendae wanen horo Nare honaibondere nibi baewate an, nebeibe ekate Pilatusre riyewainye nare honaibondere. ");
INSERT INTO set_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Allahle homofae molaikoke hului nemene maimokoukokera, nebei ohali randa roukate, rukara buleinye nekainyele. ");
INSERT INTO set_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Nebeibe herera Allah benen waleungeboke. ");
INSERT INTO set_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ya helen ro miyae nangkele Galilea kanira Yerusalem yore mewate yore naei u yakawoumi. Nebei yo mbai naei ijoko yae erewate are Israel yoni-yonire ungaimiyendere. ");
INSERT INTO set_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Aka naei baeke naei, nda a foi faeu foi mare mekaiwayembe. Allah aei yobe naei kamahe naeise a heteumikoke hului Yesus herekera waleungeboke, aei foi naeise. Homofae Mazmur fasal bee nendone nda a Yesusle naeise molaikoke, ‘Weyae Raei fa, mana yara Reyae waei Araise yeubokale.’ ");
INSERT INTO set_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Allah Yesusre herendera walennebonde, benen here hubayeikoi mo nekenende naei a nendahina Naei yendo kayaalo Yesayale homofaene nda wanen moloukoke, ‘Reyae Ondofolo Daudre are heteungekokale rambun yoni-yoni Ware isete nane merau onomi foka yae ei hawerewende.’ ");
INSERT INTO set_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Nane merau nebei homofae Mazmur mbai anuwau hine Allah naeise nda wanen moloukoke, ‘Waei eleubokae wekanae Kiyae Nauware nendon kanine kaka bende naeise Weyae ewaeisi.’ ");
INSERT INTO set_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Ondofolo Daud Allah ukeunge rambun-rambun mokoukoke baeufoke mo, hereke na yobe naei kamahe naeite bulei kelaeunge molaisake. Ondofolo Daud na u melen nemene kanine beko yaeiboke. ");
INSERT INTO set_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Nebeibe Yesus mbai Allah yae herekera waleungeboke, Nauwa kakare eyeiboi. ");
INSERT INTO set_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Nebeinye, aka naei baeke naei, mayae isaeisembombere Yesusle walora Allah beko bakore faeinyembonde a huwayembe. ");
INSERT INTO set_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Musale walora wali heere foloukoke hakowainye walora wali himalainyeboke yo yae me ebaei sului, nebeibe nde naei Yesusre hila rabo halenainyele yo wali himalainyeboke yo yae me baemmile. ");
INSERT INTO set_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Nebeinye wamale, aka naei baeke naei, angkaei foi yae borombe. Nda Allah yae elewole a Allahle yenjo kayaayo homofaene molaikoke hului mai nolone menjembonde belene, mauwa kayaa hebembe, ");
INSERT INTO set_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Ro miyae aukakare koyaube yo, ijoko foi yae eren, ijoko kelei-kelei mo engkelembera enserembombe! Mayae nekembe heene, Reyae merele rambun hi mokorebonde, nebeibe mayae na hele eleikoi sului. Ro miyae kelekokayembe hororebe, mayae namman a helere eleikoi.’ ” ");
INSERT INTO set_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paulusle Barnabasle ei moloi-moloi imaera meibaleke yae, nebeinya ro miyae hokolo beere uwaimile benen nebei a mbaise bena Sabat yane ahuneneinyebonde. ");
INSERT INTO set_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ro miyae nebei ei moloi-moloi imaera maibaleke bae, hokolo beere na moisa hakowaimi. Hiwa Yahudi ro miyae, hiwa Yahudi ban ro miyae nebeibe Yahudi agamane ayeuboke. Paulusle Barnabasle a usaei uwoimi Allah kena buhae aere ban heumine Naei a weumi huluinye nekenate. ");
INSERT INTO set_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Are rainyehike Sabat yane, ro miyae nebei yo einya helen wanen arilewole, Allahle ako faeukore boronatere mewate. ");
INSERT INTO set_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nebeibe Yahudi ro miyae ijoko erewate ro miyae helen sele mewatene, kena hensen sele kowate. Paulus elewole are aukaka yae kowainye. ");
INSERT INTO set_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Nebeibe hokolo bee, Paulusle Barnabasle, buhae ohokoiboi benen elayeiboke a na yaka-yaka yae uwaimi, “Na hele Allahle ako faeuko na bere hele mare kelemayengkombere. Nebeibe maei are moi bulewaume nane merau menaeijae a hokaukoke mayae wali hena bona eyaroinye, meyae nda hee mare nukemayembombe Yahudi ban ro miyae naeise emalere. ");
INSERT INTO set_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Rabuhine ban, Tuhan are ukeume, ‘Reyae ware eleubokawale, ro miyae Yahudi ban yore isehe wanen mae naeumihombere. Nda kani kelana ro miyae nemene wali hena a faeufe huwemmiyembe.’ ” ");
INSERT INTO set_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Yahudi ban ro miyae nebei are borokate hee, rei aumiboke kowate Tuhan Yesuslena ako faeuko na hele elewate. Nebei ro miyae Allah a hokoukoke hului wali hena bonare enaijaronde yo, Yesusre hila rabo halewainye. ");
INSERT INTO set_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Tuhan Yesuslena ako faeuko nebei kanine heraeyeuboke huwayeke. ");
INSERT INTO set_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Nebeibe na yona miyae maengke Allahre enera raisa yaneyainye yo bele rore raimi yo belere Yahudi ro miyae yae Paulusle Barnabasle naeise a beko huwaimikoke. Nebei Yahudi ro miyae hiwa yore moi hurewaimi hokolo beere weitasi kowaimile nane merau nebei kanira hukaimihike. ");
INSERT INTO set_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Nebei yo u mekai beko hele mokowatene isaeise roungate naeise nebeinya ro miyae bene Paulusle Barnabasle noro mehaunga kani bahe ruboinyeboke, nebeisa Ikonium yore ewote. ");
INSERT INTO set_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Yesusre hakainyekoke ro miyae Antiokhia yona yo rei mai bele nane merau Allahle Roh yae aumiboke bele maemae koumikoke. ");
INSERT INTO set_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Hokolo beere Antiokhia yone mokowaimi wanen mbai Ikonium yone mokowaimi. Yahudi naei ei moloi-moloi imaere hokolo bee ete eikeleimine, Yahudi ro miyae bele Yahudi ban ro miyae bele nebei a faeu elewote na kena une akaibokene, Yesusre na hele yae elewate, hila rabo halewainye. ");
INSERT INTO set_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Yahudi ro miyae hiwa, Yesusre hila rabo ehalei yo yae, Yahudi ro miyae ban yore a huwaimikoke Yesusre hakainyekoke mate yore ikele konaimilere. ");
INSERT INTO set_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Nebei aerene Paulusle Barnabasle Ikonium yone heki holo nekeikoke. Allah ro miyaere kena buhae aere ban mae heumine Yesusre ukeunge meke a foi faeu foi be yae rabuleiboke huwewoimi. Nebei a faeu na hele yeubokere yakambonde naeise, Allah hokolo beere Naei elae wake kiteumiboke nane merau rambun emere-emere roko helen mokowote. ");
INSERT INTO set_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Nebei yona ro miyae holo beere kayee waheukoke. Hiwa Yahudi ro miyaere hakaimikoke, hiwa yo Paulusle Barnabaslere hakaimikoke. ");
INSERT INTO set_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Nebei Yahudi ro miyae bele Yahudi ban ro miyae bele naei be yun be yebaere hebewate yo bele merau kolainyemeke hokolo beere beko mokonaimikondere ruka yae hainyaimikondere. ");
INSERT INTO set_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Merau kolowainye hokolo bee isaeyeibokene, u hale yae hakaikoke Likaonia kanina yo bee Listrale Derbele nane merau nebeinya yo hiwa enena honate belere yae ewote. ");
INSERT INTO set_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Hokolo bee benen Yesuslena a foi faeu foi nebeinya ro miyaere ekeikelewoimi. ");
INSERT INTO set_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra yone ro mbai na honokatera noro nimainyekoke honoweke. Noro elae banne ele mele okoyei nekeweke. ");
INSERT INTO set_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Nda ro Paulus are eyelele ijenne nuweiboyole borounge, Paulus na ijoko erewounge nda ro na hila rabo randa na hului onomi rowende. ");
INSERT INTO set_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Paulus ijoko ereungekoke mo a na kaban don mae weunge, “Wenaei oro yae ainyu hebeiko!” Nebei ro honoungehike na hibi nenaei oro yae ele mele kowole. ");
INSERT INTO set_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ro miyae helen sele Paulus nebei rore aungenuke ele mele kowole erewatene, Likaonia afaeunge kali yae elate kaenate, “Kunna waunga yo rore miyaere waijeukoke.” ");
INSERT INTO set_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Nebeinye Barnabasre Zeus yae na ro baeinyehoke nane merau Paulus are elewole kiyaene Hermes yae na ro baeinyehoke. ");
INSERT INTO set_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Walobo Zeusle naei ei moloi-moloi imae Listra yo kelaeunge hebelena imam sapi mukuure mo yaweumiboke, o kui ha kui hokowole, nebei yona romau kabande eke. Nebei yona ro miyaere hakoumiboke nanembainye Paulusle Barnabaslere hili era akau erare hebenaimilere. ");
INSERT INTO set_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Barnabasle Paulusle nebei wanen mokonaibondere isaeyeibokene, hokolo bee malore mo kaneikokete nebei ro miyae hebate nolore yae hakaikoke ete wa kaenete, ");
INSERT INTO set_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Rahene maere nda wanen mokaume? Meyae ro miyae mangkele na hului mbai. Aka naei baeke naei, meyae Yesuslena a foi faeu foi mare umayemberene ndare mekande. Rabuhi ban rambun hayennekombe. Allah nda yaku bele kani kela bele nane merau neinya rambun nemene mokouboke Kiyae a wembe huluinye nekembe. ");
INSERT INTO set_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Na bere hele nekewate ro miyaere Allah waeumihike wali naei kenana hului nekayeke. ");
INSERT INTO set_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Nebeibe Allah u mekai foise mokoyele Kiyae naeise aere isaeyemmele. Ya bumara moloyele ikembe nane merau ani foi era foi na ralone yakamane yeyembe walora Neyae kena nime haba mokowembe. Rei mai bele eraman era bele yae mai kenare moloyembe.” ");
INSERT INTO set_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Nebei a Paulusle Barnabasle weimi hororebe, hili era akau era hebenaimilere mekate yo a hun koloi-koloi an. ");
INSERT INTO set_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Na heki ban nekeikoke mo, Antiokhia yona bele Ikonium yona bele Yahudi ro miyae Listra yore mekate, nebei yona ro miyaere a huwaimikoke nare hakaimikoke. Nebei yo Paulusre ruka yae hayaeinyekokera na hibi ara muli yae yobayeke. Na u benera Paulus hereke yae elaikokene, yo moinye wokate honowole. ");
INSERT INTO set_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Nebeibe Yesusre hakainyekoke ro miyae na u ele yae naeinyeboke hebewate hee Paulus aunguke benen Listra yo eise eweufike. Ya heuboke mo Barnabasle nanembaisa kulun ukete Derbe yore ewote. ");
INSERT INTO set_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Hokolo bee Derbe yone Yesuslena a foi faeu foi huwoimi. Ro miyae helen sele Yesusre hila rabo halewainye. Nebeisa Listra yo bele Ikonium yo bele Antiokhia yo belere bukeiboke ewote. ");
INSERT INTO set_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Nebei yona Yesusre hakainyekoke ro miyae na hila rabo aiminuke nane merau moi hurewaimi Yesuslena a elelere hila rabo halainyele wali ma yae nekenayende. Paulusle Barnabasle nebei yore weimi, “Yesusle me kelee u keleene nekate holonare emayembonde naeise beko helen hubamangkonde hele.” ");
INSERT INTO set_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Jemaatre bewate yone Paulusle Barnabasle nebei jemaat naei be yun be yebae yaroikoyote. Nebeisa ebeli meiboyainye nane merau yarele me heiboyainye mon nekeikoyatere wa, nebei be yun be yebae Tuhan rabore halaeinye Kiyaele me einye kinyeiboyainye. ");
INSERT INTO set_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Paulusle Barnabasle benen aloinyekoke ewote Pisidia kanira mo Pamfilia kanine ekete. ");
INSERT INTO set_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Perga yone Yesuslena a foi faeu foi huweimikokera, Atalia yore ekete. ");
INSERT INTO set_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Atalia yora bu wakara beiboke Antiokhia yo Siria Kanire ewote. Na bere nebei anuwaunge Paulusle Barnabaslere kaliare mokonete naeise Allah kena buhae aere ban mae heumi Kiyaele me einye kinyaikoke nebei kaliabe nda hee yae riyau mekeiboinye. ");
INSERT INTO set_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Antiokhia yore ekete hee, nebei yona Yesusre hakainyekoke ro miyae arilaimihike. Hokolo bee naei wali walora Allah me u mokowole ahuba bele Allah nibi wekeunge Yahudi ban ro miyae na hului Yesusre hila rabo halenainyele ahuba bele huwewoimi. ");
INSERT INTO set_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Nebei yona Yesusre hakowainye yo nolone heki nekeikoke. ");
INSERT INTO set_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ro miyae mbemba Yudea kanira mekate Antiokhia yona Yesusre hila rabore halaeinye yore kelewaimi, “Musa kelewoumi era hena huluinye ro uwa elan ofoloikoinya mai wali hole omoloiboi sului.” ");
INSERT INTO set_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paulusle Barnabasle nebei yo bele akure yeuboke howate. Nebei are Yesusle abu ako na hiwa bele nane merau nebeinya jemaat na be yun be yebae bele enayelengkonde naeise, Paulusle Barnabasle na ro hiwa bele yaraikoke Yerusalem yore enatere. ");
INSERT INTO set_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Antiokhia Jemaatna yo bele yo moinye ekate mo “Moro foi yae embe,” a waimiyeke, nebei yo riyana kulun ukate Fenisia kanira Samaria kanire ewate. Nebei kani beene huwaimi, “Yahudi ban ro miyae helen Yesusre hakowainye.” Yesusre hakainyekoke ro miyae nebei a borowatene rei sele kowate. ");
INSERT INTO set_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Yerusalem yone mekate hee, nebei jemaatna ro miyae bele Yesusle abu ako bele nane merau nebei jemaatna be yun be yebae bele na foi sele ei hauwaimile, hokolo bee walora Allah me u mokowole yoni-yoni nemene a huwaimi. ");
INSERT INTO set_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Nebeinye Farisi holona ro hiwa Yesusre hakainyekoke yo yae afae yae yaeisureukoke, elate, “Yahudi ban ro miyae Yesusre hila rabo halaeinye yo na ro uwa elan folonaimikonde hele nane merau Musale walora wali heere foloukoke are hakonate hele.” ");
INSERT INTO set_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Yesusle abu ako bele nebeinya jemaatna be yun be yebae bele nebei are kolonainye naeise riya mewarileufike. ");
INSERT INTO set_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Heki hele isaei hira-hira elayoke wa Petrus afae yae aunguke weumi, “Aka naei baeke naei, mayae nemene maisaei ya naennaen hului moise hayaendekokene, Allah yae mai nolora rare eleufeboke Yahudi ro miyae ban yore Yesuslena a foi faeu foi keleremile boronate nane merau na hului Yesusre hila rabo halenainyele. ");
INSERT INTO set_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ro miyae naei kena einyere royeumi Allah Naei Roh aere ikeume hului mbai nare ikeumi. Nda nibi yaere, meyae isaeyaendeboke Allah nare buhae heumikoke. ");
INSERT INTO set_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Allah be ijokore ereyei. Na hila rabo halaete walora na beko bako faeinyeumiboke. ");
INSERT INTO set_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Eyae nane merau aei yobe naei kamahe naei Musale walora wali heere foloukoke a huluinye enekei tonbe. Rahene mayae Yahudi ban ro miyaere waumile wali heere foloukoke a hului nekenate hele walora Allahre umalibe hubaunge? ((Rabuhine ban Allah nebei a ewei!)) ");
INSERT INTO set_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Nebei wanen mae omokoijae hele. Eyae hila rabo halaende Yesus Wali Ondofolo kena buhae aere ban mae heumene wali hole molommebonde, Yahudi ban ro miyae hului mbai.” ");
INSERT INTO set_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Paulusle Barnabasle walora Yahudi ban ro miyae nolone roko helen Allah rambun emere-emere mokowole ahuba huwoumine, nebeinye arilewole yo koro ban yaeiboke. ");
INSERT INTO set_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Hokolo bee huwoumi a baeufoke mo, Yakobus yae weumi, “Aka naei baeke naei, rare boronsobo. ");
INSERT INTO set_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon manemfa aere weumekoke, Allah na bere hele Yahudi ban ro miyae nolora ro miyae hiwa eleukoke wekeumi Naei holona ro miyaere inyaibondere. Nebei me u walora Allah keleumeboke Neyae Yahudi ban ro miyaere nou heumi. ");
INSERT INTO set_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Allah na yenjo kayaayo nebei a eleukoke mbaibe homofaene nda wanen moloukoke, ");
INSERT INTO set_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Reyae merele Daud na yo waku ruke honole benen arennunde. Na ro miyae nemene arileremihinde nane merau mokoremibonde benen yoho mbai yae nekenate. ");
INSERT INTO set_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","18","Tuhan Allah nendahina merau raungehike are ro miyaere isaeyeumi Kiyae yae nda a eleukoke, arileremihinde ro miyae Tuhan kenare kole huluise baenainyele nane merau Yahudi ban ro miyae Raei me kelee u keleene menainyekende yo.’ ” ");
INSERT INTO set_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yakobus benen weumi, “Raei u benere nekaise nebei Yahudi ban ro miyae Allahle wali nibire oronate yore eyae oro halun ehayeijae. ");
INSERT INTO set_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Men, nda a usaei ma yae homone molomakonde imamilere. Hoimere bahere eise molaimina raman aneijae. Yoko kaeimae nemene hee rorombe. Obo yoku ha einye heikoyeunge herele na melen aneijae, nane merau ha aneijae.” ");
INSERT INTO set_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Rabuhine ban aei yobe naete kamahe naete heera meke nda heene bele na Sabatne baei ei moloi-moloi imaene Musale walora wali heere foloukoke a huweimeyate nane merau nebei homofaena mai yone-yone huweimeyate boroimeyaube. ");
INSERT INTO set_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Yesus naei abu ako bele nebei jemaatna be yun be yebae bele nane merau nebei jemaatna yo nanemene a hokaikoke ro hiwa naei nolora yaronaikonde Barnabasle Pauluslere hakonaimikonde nanembaise Antiokhia yore enatere. Yudas Barsabas yae wainye kiyaele Silaslere yaraikoke. Hokolo bee Yerusalem yore Yesusre hakainyekoke aka baeke naei be yun be yebae holona ro bele yo. ");
INSERT INTO set_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Homo mbai molaikoke nebei yo na mene ikaimile roungayendere. Nebei homone nda a molaikoke, Aka naei baeke naei Yahudi ban ro miyae, Antiokhia yona, Siria kanina, Kilikia kanina, ekaunekaube yo! Meyae Yesus Na abu ako bele, jemaatna be yun be yebae bele, nane merau mai aka baeke wa bele naeise, onomi foka mare a melaeyayembe. ");
INSERT INTO set_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Meyae a borowande ro hiwa maei nolora mai bokore ekate nane merau naeinya a usaei kelewayembere mayae onei-onei onaeube, erabae mai keleikoise meyae ro miyae mbai ewei ei mo. ");
INSERT INTO set_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nebeinye meyae riya nekandekoke kena mbai yae ro hiwa yarandekoke nane merau ukammile buhaere haemmile Paulusle Barnabasle enete homone hakoneikonde mai bokore enatere ");
INSERT INTO set_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Hokolo bee Paulusle Barnabasle na wali buhae hokoiboi ban mae aei Tuhan Yesus Wali Ondofolole kaliare mokowote. ");
INSERT INTO set_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Meyae homona molowande a naei euwa yae ungayembe naeise Silasle Yudasle mai bokore ukammile ate. ");
INSERT INTO set_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Allahle Roh nda a yakaumeboke nane merau meyae kena foi hubannele mare Yahudi naei era hena yoni-yoni hakongkombere waeli ebei, nda holonabe emmokombe: ");
INSERT INTO set_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Hoimere bahere eise molonaimile na raman aneijae, ha aneijae, obo yoku ha einye hekoyeunge herele na melen aneijae, yoko kaeimae hee rorombe. Nda me u moi hayennekombena, mayae na foi sele hubannele. Nda heene, onomi foka! ");
INSERT INTO set_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","“Oro foi embe” a waimiyeke, nebei yo kulun ukate Antiokhia yore ewate. Nebei yona jemaat nanemene arilaimihike mo, nebei homo na mene ikaimile. ");
INSERT INTO set_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Nebei homofaene kaikokera jemaat na kena rei mai sele kowate, rabuhine ban nebei a na kena u harare roroumine. ");
INSERT INTO set_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yudasle Silasle Allah weumi a hungeimile na meli mekai bele. Naei a eleikoke walora Antiokhia yona Yesusre hakainyekoke yo naei kena u bele naei hila rabo bele ainyunuke. ");
INSERT INTO set_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Yudasle Silasle Antiokhia yone heki holo nekeikoke mo, Antiokhiana yo yae ukeumi benen onomi foka yae bukaimiboke Yerusalemna Jemaat nolore enetere. ");
INSERT INTO set_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Nebeibe Silas naei kena kowole Antiokhia yone nekendere. ");
INSERT INTO set_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulusle Barnabasle Antiokhia yone heki holo nekeikoke. Hokolo bee nane merau ro miyae hiwa helen baraikoke nanembainye Tuhan Na wali nibi are huwaimi nane merau kelewaimi. ");
INSERT INTO set_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ya heki ban nekaikoke mo Paulus yae Barnabasre weunge, “Mei, naei foi sele eyae bukabon aei aka baeke Yesusre hakainye ro miyae Tuhanbe wali nibi are kelewammile yone yanne nekeyate na wali mare ijoko eramiyendere bukabonde alere.” ");
INSERT INTO set_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas yae Yohanes Markusre yawennehondere kena kowole. ");
INSERT INTO set_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Nebeibe Paulus na kenara hubawounge Markus ehakoijae, rabuhine ban Paulus naeise roko mbai na kalia riyau eweiboi yae Pamfilia yone nukeumiboke. ");
INSERT INTO set_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Hokolo bee Markusle kenane a oyeiboke kilewotene, kayee moloikoke. Barnabas Markusre yaweungehoke Siprus yokobare ewote. ");
INSERT INTO set_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paulus Silasre yaweungehoke. Antiokhia yona Yesusre hakainye aka baeke hokolo beere Allah kena buhae aere ban heumi Kiyaele me einye kinyaimibokera kulun ukete ewote. ");
INSERT INTO set_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Paulusle Silasle Siria kani bele Kilikia kani bele yaneyeke yae jemaat-jemaatna ro miyae na hila rabo halewatere harane roroimiyeke. ");
INSERT INTO set_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulus Derbe yore ekera, nebeisa Listra yore eke. Nebeinye Yesusre hakoungeboke ro mbai na ro Timotius. Nenake Yahudi maengke Yesusre hakainye holona, nebeibe naeko Yunanina ro. ");
INSERT INTO set_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listra bele Ikonium bele yona ro miyae elewate Timotius ro u mekai foi. ");
INSERT INTO set_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulus kena kowole Timotius nare hakonnebondere. Nebeinye Timotiusle ro u elan Paulus neungehake, rabuhine ban nebei yona Yahudi ro miyae naeisaei Timotius naeko Yunaninane. Yahudi era hena huluinye nebei me u mokouboke. ");
INSERT INTO set_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Paulusle Timotiusle oroyeke yo yoni-yonine ro miyaere Yesusle abu ako bele Yerusalemna Jemaatna be yun be yebae bele are hokaikoke huluinye enaihakonde naeise, nebei a isaeiwoimi. ");
INSERT INTO set_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Nebei a isaeiwoimine nebei jemaat yoni-yoni na hila rabo hara rorowoimi nane merau na yane baei nebei holona ro miyae emerei-emerei emerewole. ");
INSERT INTO set_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paulus nanembaisa orate yo bele Yesuslena a foi faeu foi Asia kanire kelenaimikondere Allahle Roh ewaeisinye, ekate Frigia kani bele Galatia kani belene yanewate. ");
INSERT INTO set_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ekate Misia kanina hee ranne Bitinia kanire enayembondere, nebeibe Allahle Roh yae ewaeisi. ");
INSERT INTO set_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Nebei aerene Misia kanine enekei, nebeibe Troas yore ewate. ");
INSERT INTO set_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Troas yone reniai yae, Paulus naijoko ranainyeboke erewole, Makedonia kanina ro mbai meke na bene hebeunguke weunge, “U hale yae maere meime hakoibone!” ");
INSERT INTO set_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paulus nebei wanenda ereke bae, meyae na hibi rambunde mo mokannehake Makedonia kanire emalere. Menaeijae kena une hubannekoke Allah aere moibe hureume Yesuslena a foi faeu foi nebei ro miyaere umamiyendere. ");
INSERT INTO set_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Meyae bu waka kabanda ewande Troas yora nandehike, ekande Samotrake yone. Ya heuboke mo Neapolis yone andenoke. ");
INSERT INTO set_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Neapolis yora mo, Filipi yore oro yae ekande. Makedonia kani Roma naei keleene nekate, na yo bereinya Filipi niyae. Meyae ya keli name hului nebei yone nekandekoke. ");
INSERT INTO set_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sabat ya yeuboke mo, maei u benera nekewaime Yahudi ro miyae Allahre ebelire bonainyele naeise wi enene arilensinderene, meyae yo ele naeiboke moi wokande nebei wi enere ewande, nebei anuwaunge randeboke miyae maengke hokoumeke yo bele ane elewande. ");
INSERT INTO set_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Nebei miyae maengke nolora hi na ro Lidia Tiatira yona miyae malo maye-maye fi kolei ma naise hele nane merau Allahre eise moloyeungene. Allah na kena u kuseungekoke, Paulus yae elewole are na hele elewole. ");
INSERT INTO set_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Lidia nane merau naei imaena obena ro miyae bele bu kaimikoke. Nebeisa maere naei imaere emalere waeli hele beumoke weume, “Aka naei baeke naei, reyae nana hesele Yesusre hila rabo halanale a yae mayae elaubena, mana ya mayae raei imaene ensonombere.” Na hibi-hibi weumeyokene, ehe kannekoke naei imaene ekansonowande. ");
INSERT INTO set_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ya mbai nebei ebeli boi-boi anuwaufe ewande yae, maengke mbaibe hubayaendekoke. Nda maengke yebaei bubaeise nekeyele. Alo yae aungebokene, rambun-rambun bena yane enaibendere na hului elende. Ro miyae naei wali neyae mehinin kolowoumine, naei rowa-roware roi nekai arileumiyeke. ");
INSERT INTO set_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Nebei maengke Paulus maengkele mewande moisa na hibi-hibi mo hakoumeboke. Na kali bele kaeneumeke elele, “Nda ro miyae Allah Hubalo Mandole yobe mate! Wali hole molombombe mekai keleikoise mate!” ");
INSERT INTO set_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nda maengke na rokone baei meukaeneukokene, Paulus na kena herauke an. Nebeinye Paulus beufoke nebei alore weunge, “Yesus Wali Ondofolole Ro yae ware wawale, nebei maengkele u bulura eituwe!” Na hibi are ukeungera nebei alo eukuke. ");
INSERT INTO set_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Nebei maengke na rowa-rowa isaeyaeiboke roise yarate nibibe aheumikokene, Paulusle Silaslere ikilaikoke naise haete anuwaunge Filipi yona yoyo koseyo naei bere muli yae yobayeke hukaimiyeke ewate. ");
INSERT INTO set_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Nebei yo benen Paulusle Silaslere yawaimiboke ekate Roma naei ondofolo kose yo bene haimikoke waimi, “Nda Yahudina ro bee mekete aei yo ei mokoinyeboke aku nekai keteuboke. ");
INSERT INTO set_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Neyae ro miyaere moi huraimi eyae Roma ro miyae yae wali heere folaikoke asasi konate naei era henare hakonaimilere kelaeimi.” ");
INSERT INTO set_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Nebeinya ro miyae helen nangkele yae Paulusle Silaslere habelekaimile. Filipi mere mokowaimi yo yae ukaimile hokolo bee uwana malore mo kayaeimikokera rahuae bowate. ");
INSERT INTO set_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Rahuae olaeimikokera yawaimiboke ekate kawa einye aimiheukoke. Kawa imae yunde hebele kiyae ukainyele kayaa foi yae hebemmile. ");
INSERT INTO set_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Nebei wanen mae a ukainyelene, nda kawa yun Paulusle Silaslere yaweumiboke, einya hele yowane aheumikoke. Eneibalende belene, hokolo bee naei oro o bulune hireumiboke benen noro randa o hi yae heraweukoke. ");
INSERT INTO set_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Reniai nolo hului kawa einya hebate yo, Paulusle Silasle Allahre ebeli bowoinye nane merau hobolo mandu yae buma kaewoinyere maeumikoke borowaimi yae, ");
INSERT INTO set_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","oinyeu kabani hele hineuboke, nebei kawa imae aehu bele nene kowole. Nebei kawa romau nemene rawaikoke. Kawa einya yore ikilewaimi rantai yoni-yoni bulaerewate. ");
INSERT INTO set_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nebei kawa imae yunde hebele kiyae kulu-kulu yeuboke aunguke. Nebei kawa romau nemene rawaikoke erewolene, nane merau kawa einya hebate yo hakaikoke aibaleke u bene nekewainyene, na ure hombondere na ramere mo nekeyobouboke. ");
INSERT INTO set_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Nebeibe Paulus kali na kaban don mae kaeneunge, “Wauwa ohoijae! Meyae nemene ndane namman nekande!” ");
INSERT INTO set_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Nebei kawa imae yunde hebele kiyae, isehe ((lampu)) ukeumi rokate mekatera riyeumihike hakauboke eise eke, noro me oinyeu hineuboke kowole wa Paulusle Silasle bene ane ruke. ");
INSERT INTO set_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Nebeisa ho