﻿USE sofia;
DROP TABLE IF EXISTS sofia.ses_vpl;
CREATE TABLE ses_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ses_vpl WRITE;
INSERT INTO ses_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Šintinoo ga, Irkoy na beenaa nda laboo taka. ");
INSERT INTO ses_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Laboo sii nda taka kul, nga koonoo no. Kubay goo guusu beeroo boŋ, de Irkoy Hundoo cindi ka dira-dira haroo boŋ. ");
INSERT INTO ses_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Irkoy nee: «Gaayoo ma bangay!» De gaayoo bangay. ");
INSERT INTO ses_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Irkoy dii kaŋ gaayoo boori. A na gaayoo nda kubaa fay kʼi kaa cere ra. ");
INSERT INTO ses_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Irkoy na gaayoo maaɲoo daŋ «zaaroo», de a na kubaa maaɲoo daŋ «cijinoo». Cijin foo kaa, subbaahi foo kaa. Woo ti zaari jinaa. ");
INSERT INTO ses_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Irkoy nee koyne: «Farru beeri ma tee haroo ra kaŋ ga haroo fay ihinka!» ");
INSERT INTO ses_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Irkoy na farroo tee. A na farroo tee ka beene haroo nda ganda haroo fay. Woo kaŋ a nʼa har tee. ");
INSERT INTO ses_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Irkoy na farroo din maaɲoo daŋ «beenaa». Cijin foo kaa, subbaahi foo kaa. Woo ti zaari hinkantoo. ");
INSERT INTO ses_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Irkoy nee koyne: «Haroo kaŋ goo beenaa se ganda ma marga nongu foo hala daw kogaa ma bangay!» Woo kaŋ a nʼa har tee. ");
INSERT INTO ses_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Irkoy na daw kogaa maaɲoo daŋ «laboo», de a na hari margantaa maaɲoo daŋ «teekoo». Irkoy dii kaŋ a boori. ");
INSERT INTO ses_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Irkoy yee ka nee: «Laboo ma dumari firzi hay. Subu kul ma nga dumiyoo hay. Tuuri dumi foo kul kaŋ ga ŋandi ma nga izoo hay, affoo kul nga dumiyoo ma bara a ga.» Woo kaŋ a nʼa har tee. ");
INSERT INTO ses_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Dumari firzi fatta laboo cire. Subu dumi kul na nga dumiyoo hay. Tuuri kul na nga izoo hay. Dumi kul, nga dumiyoo goo a ga. Irkoy dii kaŋ a boori. ");
INSERT INTO ses_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Cijin foo kaa, subbaahi foo kaa. Woo ti zaari hinzantoo. ");
INSERT INTO ses_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Irkoy nee koyne: «Hayayaŋ kaŋ ga gaay noo ma tee farroo ra kaŋ ti beenaa ka cijinoo nda zaaroo fay, i ma tee tammaasayaŋ waatey, nda zaarey, nda jiirey se. ");
INSERT INTO ses_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Beenaa farroo ra, hayey wey ma laboo noo gaay!» Woo kaŋ a nʼa har tee. ");
INSERT INTO ses_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Irkoy na haya hinkaa tee kaŋ ga gaay noo. Ibeeroo kaŋ ga zaaroo gongu nda ikacca kaŋ ga cijinoo gongu. A na handarawey mo tee. ");
INSERT INTO ses_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","A nʼi daŋ beenaa farroo ra hala i ma laboo noo gaay. ");
INSERT INTO ses_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","I ma dii zaaroo nda cijinoo ra, de i ma gaayoo nda kubaa fay kʼi kaa cere ra. Irkoy dii kaŋ a boori. ");
INSERT INTO ses_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Cijin foo kaa, subbaahi foo kaa. Woo ti zaari taacantoo. ");
INSERT INTO ses_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Irkoy nee koyne: «Haroo ma too nda hundikoyni. Cirawyaŋ ma deeši laboo boŋ beenaa farroo here!» ");
INSERT INTO ses_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Irkoy na adabba beerey nda hundikoyney kaŋ ga ɲuuti haroo ra, a nʼi kul taka, affoo kul nda nga dumoo. A na cirawey kaŋ ga deeši mo kul taka, dumi nda dumi. Irkoy dii kaŋ a boori. ");
INSERT INTO ses_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Irkoy na albarka daŋ i ra ka nee: «Hayey kaŋ ga huna haroo ra ma hay ka cere hay ka boobo ka teekoo harey too. Cirawey mo ma hay ka cere hay laboo ga!» ");
INSERT INTO ses_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Cijin foo kaa, subbaahi foo kaa. Woo ti zaari guwantoo. ");
INSERT INTO ses_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Irkoy nee koyne: «Hundikoyni dumi kul ma fatta laboo cire: adabba, nda labukoy, nda ganjihooga dumi kul!» Woo kaŋ a nʼa har tee. ");
INSERT INTO ses_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Takaa woo nda Irkoy na ganjihooga, nda adabba, nda labukoy kul tee, affoo kul nda nga dumoo. Irkoy dii kaŋ a boori. ");
INSERT INTO ses_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Irkoy nee: «Ir ma boro tee, a ma hima nda ir. A ma tee ir cine! A ma tee jineboro teekoo hamiisaa se, nda beenaa ciraw, nda adabba, nda laboo kul, nda labukoy kul kaŋ ga ziilam-ziilam laboo ga.» ");
INSERT INTO ses_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Irkoy na boro taka hala a ma hima nda nga. Nga himakasinaa no kaŋ a nʼa taka. A nʼi taka kʼi tee aru nda woy. ");
INSERT INTO ses_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Woo banda ga, Irkoy na albarka daŋ i ra, a nee i se: «Wa hay, war ma cere hay ka boobo. Wa laboo too, war mʼa laama. Teekoo hamiisaa, nda beenaa ciraw, nda adabba kul kaŋ ga ziilam-ziilam laboo ga, war ma tee i se jineboro.» ");
INSERT INTO ses_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Irkoy nee koyne: «Nga ne, subu kul kaŋ goo laboo ga kaŋ ga dumi tee, nda tuuri kul kaŋ ga ize nda dumi tee, ay gʼi noo war se, i ma tee war meehunaa. ");
INSERT INTO ses_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Laboo adabba kul, nda beenaa ciraw kul, nda labukoy kul kaŋ ga ziilam-ziilam laboo ga, maanaa hundikoyni kul, ay gʼi noo subu firzoo kul, a ma tee ngi meehunaa.» Woo kaŋ a nʼa har tee. ");
INSERT INTO ses_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Irkoy na hayey kul laasaabu kaŋ a nʼi tee. A dii kaŋ i hanse ka boori. Cijin foo kaa, subbaahi foo kaa. Woo ti zaari idduwantoo. ");
INSERT INTO ses_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Takaa woo nda beenaa, nda laboo, nda haya kul kaŋ goo i ra takandi ka ben. ");
INSERT INTO ses_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Jirbi iyyantoo hane takaroo goyoo kul kaŋ Irkoy nʼa tee ben, de mo jirbi iyyantoo din hane a hunanzam nga goyoo kul kaŋ a nʼa tee ra. ");
INSERT INTO ses_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","A na albarka daŋ zaari iyyantoo ra kʼa yeeti jere ga, zama zaaroo din ra a hunanzam nga takaroo goyoo kul ra kaŋ a nʼa tee. ");
INSERT INTO ses_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Woo ti beenaa nda laboo takaroo fillaa. Waatoo kaŋ Irkoy Abadantaa na beenaa nda laboo tee, ");
INSERT INTO ses_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ba saaji tuuri kaccu foo sii laboo boŋ. Saaji dumari mo mana zay, zama Irkoy Abadantaa mana ncirɲi kaŋandi laboo boŋ jina. Boro mo sii no kaŋ ga laboo beeri. ");
INSERT INTO ses_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Amma harandaŋ ga tun laboo cire kaŋ ga laboo beeneheroo kul haŋandi. ");
INSERT INTO ses_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Labuhamni no Irkoy Abadantaa nʼa zaa laboo ra ka aru hanse jina, a duu ka hundi funsu niiney ra. Aroo tee hundikoyni. ");
INSERT INTO ses_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Woo banda ga, Irkoy Abadantaa na saddiɲa duma gandaa ra kaŋ se i ga nee Edeŋ. Edeŋ woo sii kala waynahunay here. A na aroo kaŋ a nʼa hanse gorandi a ra. ");
INSERT INTO ses_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Irkoy Abadantaa na tuuri kul kaŋ nga gunayanoo ga boori zayandi laboo ra kaŋ ga ize hay kaŋ ga boori ŋaayan se. Saddiɲaa gamoo ra a na tuuriɲaa hinka zayandi: tuuroo kaŋ ga hunayan noo nda tuuroo kaŋ ga boro noo lakkal ka ihenna nda ifutu kaa cere ra. ");
INSERT INTO ses_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Isa foo fatta Edeŋ gandaa ra kaŋ ga saddiɲaa haŋandi. No din ra isaa haroo fay ka tee kabe taaci. ");
INSERT INTO ses_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Isa jinaa maaɲoo ti Pišoŋ, a ga gandaa kaŋ maaɲoo ti Hawila kul kuubi kʼa bere. Ganda no kaŋ ra wura goo. ");
INSERT INTO ses_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Wura alhakiikaa bara gandaa din ra. Deeli dumi kaŋ maaɲoo ti bedeliyom nda tondoo kaŋ maaɲoo ti oniks mo goo a ra. ");
INSERT INTO ses_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Isa kabe hinkantoo maaɲoo ti Gihoŋ, a ga gandaa kaŋ maaɲoo ti Kuš kul kuubi kʼa bere. ");
INSERT INTO ses_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Isa hinzantoo maaɲoo ti Tigir. Nga ti haroo kaŋ ga zuru Asiri gandaa se waynahunay here. Isa taacantoo maaɲoo ti Efrat. ");
INSERT INTO ses_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Irkoy Abadantaa na aroo zaa kʼa gorandi saddiɲaa ra hala a mʼa beeri, a mʼa hawgay. ");
INSERT INTO ses_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Irkoy Abadantaa na aroo noo yaamar ka nee a se: «Tuuri kul kaŋ goo saddiɲaa ra, nʼga hin ka izey ŋaa, ");
INSERT INTO ses_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","kala tuuroo kaŋ ga boro noo lakkal ka ihenna nda ifutu kaa cere ra. Tuuroo din, masi izoo ŋaa, zama han kul kaŋ nʼnʼa ŋaa, šikka sii nʼga buu.» ");
INSERT INTO ses_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Irkoy Abadantaa nee nga boŋ se: «A si boori aru ma cindi nga foo. Ay ga faabakaw tee a se, nga cine hangasine.» ");
INSERT INTO ses_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Irkoy Abadantaa kaŋ na labu zaa ka ganjihooga kul nda ciraa kul hanse, a nʼi ka koy aroo do hala nga ma dii maaɲey kaŋ a gʼi daŋ i ga. Hundikoyni kul maaɲoo kaŋ aroo nʼa noo a se, nga nda a ga ciyandi. ");
INSERT INTO ses_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Aroo na maa daŋ adabba kul ga, a daŋ ciraa kul ga, a daŋ ganjihooga kul ga. Amma a mana duu i ra faabakaw kaŋ ga tee a se nga cine hangasine. ");
INSERT INTO ses_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Irkoy Abadantaa na aroo kaŋandi jirbi koma ra. Kaŋ aroo goo ma jirbi kul, Irkoy na aroo caraw birey affoo kaa, de a na bašoo yeeti dogoo ra. ");
INSERT INTO ses_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Irkoy Abadantaa na caraw biriyoo kaŋ a nʼa kaa aroo ra bere kʼa tee woy kʼa ka koy aroo do. ");
INSERT INTO ses_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Kaŋ aroo dii a kul, a kaati ka nee: «Nhuu, woo ti hamoo kaŋ hun ay hamoo ra, kuroo kaŋ hun ay kuroo ra. Woo, maaɲoo kaŋ ga huru a ga, ti ‹woy›, zama aru ra a hun.» ");
INSERT INTO ses_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Woo ka kate, aru ma hun nga ɲaa nda nga baabaa do ka denji nga wandoo ga, de i ga tee gaaham folloku. ");
INSERT INTO ses_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ihinkaa kul, aroo nda nga wandoo, cindi gaa koonu bila nda i ma haw. ");
INSERT INTO ses_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ganjihoogawey kul kaŋ Irkoy Abadantaa nʼi tee, gondi caram ka bisa i kul. Gondoo na woyoo hãa ka nee: «Cimi da no kaŋ tuuri kul kaŋ goo saddiɲaa ra, Irkoy nee war masi izoo ŋaa?» ");
INSERT INTO ses_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Woyoo tuuru gondoo se ka nee: «Tuuri kul kaŋ goo saddiɲaa ra, ir ga hin ka izoo ŋaa. ");
INSERT INTO ses_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Amma tuuroo kaŋ goo saddiɲaa gamoo ra, Irkoy nee ir se kaŋ ir masi izoo ŋaa, ir masi ba tuku a do nda ir si baa ir ma buu.» ");
INSERT INTO ses_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Gondoo nee woyoo se: «Kalaa, kalaa! War si buu baffoo. ");
INSERT INTO ses_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Hayaa kaŋ no manʼti kala Irkoy ga bay kaŋ han kaŋ war nʼa ŋaa war moɲey ga hay. War ga tee sanda nga, war ga ihenna nda ifutu kaa cere ra.» ");
INSERT INTO ses_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Woyoo dii kaŋ tuuroo izoo ga boori ŋaayan se. Nga gunayanoo ga boori, de mo boro ga alhawa a se, zama lakkal no a ga noo. A na tuuroo ize foo kosu, a nʼa ŋaa. Nga banda ga, nga kurɲoo kaŋ goo a bande, a nʼa noo, de nga mo nʼa ŋaa. ");
INSERT INTO ses_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Dogoo din da ngi boro hinkaa kul lakkaley zunbu ka bay kaŋ gaa koonu no ngi goo. I na jeejay fitayaŋ kaa kʼi daŋ-daŋ cere ga, i ma tee lenpe ngi affoo kul se. ");
INSERT INTO ses_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Aroo nda woyoo maa Irkoy Abadantaa cee jindoo kaŋ goo ma dira-dira saddiɲaa ra waatoo kaŋ cijinoo hew baanaa ga fara. I koy tugu Irkoy Abadantaa se saddiɲaa tuurey gamey ra. ");
INSERT INTO ses_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Amma Irkoy Abadantaa na aroo cee, a nʼa hãa ka nee: «Man ra ni goo?» ");
INSERT INTO ses_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","A nʼa zaabi ka nee: «Ya nka maa ni cee jindoo saddiɲaa ra, ay hunbur, zama ay goo gaa koonu. Woo se ay koy tugu.» ");
INSERT INTO ses_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Irkoy Abadantaa nee aroo se: «May ka ni bayrandi kaŋ ni goo gaa koonu? Ni nka tuuroo izoo ŋaa kaŋ ay na ni yaamar masʼa ŋaa?» ");
INSERT INTO ses_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Aroo nʼa zaabi ka nee: «Woyoo kaŋ nʼnʼa noo ya ne, nga kʼay noo tuuroo izoo, woo ka kate yʼa ŋaa.» ");
INSERT INTO ses_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Irkoy Abadantaa nee woyoo se: «Cin ti woo kaŋ nʼnʼa tee?» Woyoo nʼa zaabi ka nee: «Gondoo kʼay darga, woo ka kate yʼa ŋaa.» ");
INSERT INTO ses_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Irkoy Abadantaa nee gondoo se: «Woo kaŋ nʼnʼa tee sabbu se, nʼga laali adabba kul nda ganjihooga kul gamey ra. Hõ banda ga, ni gundoo ga nʼga dira, labutaasi no nʼga ŋaa ni hunaroo kul ra. ");
INSERT INTO ses_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ay ga iberitaray daŋ ni nda woyoo game, ay gʼa daŋ ni hayroo nda nga hayroo game. A ga ni boŋoo motti, ni mo ga ceekoroo motti.» ");
INSERT INTO ses_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","A nee woyoo se: «Ay ga farayan boobo tonton ni alhaamidutaraa hottaa ga. Kala hottay hala nʼga hay. Ni kurɲoo se nʼga alhawa, amma nga no ma ni juwal.» ");
INSERT INTO ses_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","A nee aroo se: «Nʼna haŋajer ni wandoo se, de mo nʼna tuuroo izoo ŋaa kaŋ ay na ni yaamar masʼa ŋaa, woo se laboo ga laali ni maaganda se. Farayan nda nʼga duu ni meeŋaaroo ni hunaroo kul ra. ");
INSERT INTO ses_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Karji nda ngorfu ga zayandi ma ne. Nʼga dumarey ŋaa kaŋ ga zay saajey ra. ");
INSERT INTO ses_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ni sungaa ra nʼga duu ni meeŋaaroo hala ma yee laboo kaŋ ra ni zandi, zama labu ti ni, de mo laboo ra nʼga yee.» ");
INSERT INTO ses_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Aroo kaŋ maaɲoo ti Adama na nga wandoo maaɲoo daŋ Haawa (maanaa «hunayan»), zama nga ti hundikoyni kul kaŋ ti boro ɲaa. ");
INSERT INTO ses_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Irkoy Abadantaa na kuuru bankaarayyaŋ tee Adama nda nga wandoo se kʼi daŋ i ga. ");
INSERT INTO ses_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Woo banda ga, Irkoy Abadantaa nee: «Sohõ kaŋ boraa tee sanda ir kaŋ ga ihenna nda ifutu kaa cere ra, ir ma hawgay a masi deebe ka tuuroo kaŋ ga hunayan noo izoo kosu kʼa ŋaa ka huna hala abada.» ");
INSERT INTO ses_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Irkoy Abadantaa nʼa fattandi Edeŋ saddiɲaa ra hala a ma koy laboo beeri kaŋ ra a zandi. ");
INSERT INTO ses_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","A nʼi gaaray i ma koy taray. A na almalaykayaŋ kaŋ se i ga nee šerib nda takuba kaŋ ra nuune ga fatta kaŋ ga bere-bere, gorandi Edeŋ saddiɲaa waynahunay kaboo ga hala i ma borey ganji i ma koy tuuroo kaŋ ga hunayan noo do. ");
INSERT INTO ses_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adama gorokasinay nda nga wandoo Haawa. Woyoo tee alhaamidu, a na ize daŋ aduɲɲa ra kaŋ maaɲoo ti Kabila. Haawa nee: «Ay duu izʼaru Abadantaa albarkaa ra.» ");
INSERT INTO ses_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Woo banda ga, a yee ka ize daŋ aduɲɲa ra kaŋ maaɲoo ti Habila. Habila tee alman kurkaw, Kabila tee beerikaw. ");
INSERT INTO ses_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Waatiyaŋ banda ga, Kabila na faari-izeyaŋ tee sargari Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Habila, nga mo, kate nga almanoo gunde jinawey, de a na ham henney noo a se. Habila nda nga sargaroo kan Abadantaa se. ");
INSERT INTO ses_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Amma Kabila nda nga sargaroo mana kan a se. Kabila hanse ka futu hala ndumoo nka bibi cere ra. ");
INSERT INTO ses_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Abadantaa nee Kabila se: «Macin se nʼga futu, macin se nʼga bibandi? ");
INSERT INTO ses_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Nda nʼna taka henna tee kaŋ ga hima, nʼga ni boŋoo jer! Amma nda mana taka henna tee, zunuboo ga daaru ni hugoo miɲoo ga. A ga alhawa nga ma duu ni, amma ni, ma hin a!» ");
INSERT INTO ses_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kabila na šenni fur nga armaa Habila ga kaŋ ngi ma koy hawsaa ra. Waatoo kaŋ i too hawsaa ra, a sar ka gum Habila ga, a nʼa wii. ");
INSERT INTO ses_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Kaŋ woo tee, Abadantaa na Kabila hãa ka nee: «Man ni armaa Habila?» A nʼa zaabi ka nee: «Ay si bay. Ni nka maa agay no mʼay armaa lakkal wala?» ");
INSERT INTO ses_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Irkoy nee a se: «Cin ti woo kaŋ nʼnʼa tee? Ni armaa kuroo na ni wurru za laboo ga hala ay do. ");
INSERT INTO ses_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Sohõ nʼga laali, de laboo ga garsaka ma ne, nga kaŋ na ni armaa kuroo haŋ kaŋ ni kaboo nʼa doori. ");
INSERT INTO ses_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Nda nʼna laboo beeri, nʼsi duu nga albarkaa. Nʼga tee soomasoomante kaŋ ga windi-windi aduɲɲa ra.» ");
INSERT INTO ses_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kabila nee Abadantaa se: «Ay zukandoo ga hanse ka tiŋ ya ne. ");
INSERT INTO ses_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Nga ne, hõ nʼnʼay gaaray kʼay kaa laboo ga. Ay ga hima ka tugu ma ne. Ay ga tee soomasoomante kaŋ ga windi-windi aduɲɲa ra. Boro kul kaŋ duu agay gʼay wii.» ");
INSERT INTO ses_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Abadantaa nʼa zaabi ka nee: «Boro kul kaŋ na ni wii, ga zukandi cee iyye ka faasa ma ne.» Woo banda ga, Abadantaa na tammaasa daŋ Kabila ga hala boro kaŋ dii a masʼa wii. ");
INSERT INTO ses_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kabila hun Abadantaa jine, a koy goro gandaa kaŋ se i ga nee Nodu kaŋ goo Edeŋ se waynahunay. ");
INSERT INTO ses_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kabila gorokasinay nda nga wandoo. Woyoo tee alhaamidu, a duu nga boŋ, izʼaroo maaɲoo ti Henok. Kabila na koyra foo gorandi. A na koyraa maaɲoo daŋ Henok kaŋ ti nga izʼaroo maaɲoo. ");
INSERT INTO ses_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Henok ti Irad baabaa, Irad ti Mehuyahel baabaa, Mehuyahel ti Metušahel baabaa, Metušahel ti Lemek baabaa. ");
INSERT INTO ses_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lemek hiiji wande hinka. Ijinaa maaɲoo ti Ada, ihinkantoo ti Sila. ");
INSERT INTO ses_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada na Yabal hay. Kurkey kaŋ goo hukkumey cire saajoo ra kaagʼaroo ti Yabal. ");
INSERT INTO ses_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yabal kaynʼaroo maaɲoo ti Yubal. Yubal woo, nga ti kuntijikarkey nda laatikarkey kaagʼaroo. ");
INSERT INTO ses_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Sila mo na ize foo daŋ aduɲɲa ra kaŋ maaɲoo ti Tubal-Kayeŋ. Tubal-Kayeŋ no ma alhan nda guuru deŋyan dumi kul tee. Nga woymaa ti Naama. ");
INSERT INTO ses_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lemek nee nga wandey se: «Ada nda Sila, wa maa ya ne! Lemek wandey, wa haŋajer ay šennoo se! Boro kaŋ nʼay maray, ay gʼa wii. Zankaaru kaŋ nʼay kar, ay gʼa wii. ");
INSERT INTO ses_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kabila ga faasandi cee iyye, Lemek cee woyye cindi iyye (77).» ");
INSERT INTO ses_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adama yee ka duu nga wandoo ga izʼaru foo kaŋ Haawa na maaɲoo daŋ Seti (maanaa «sufuray»), zama a nee: «Irkoy yee ka doonandi ya ne izʼaru kaŋ yee Habila dogoo ra kaŋ Kabila nʼa wii.» ");
INSERT INTO ses_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seti mo duu izʼaru foo kaŋ a na maaɲoo daŋ Enoš. Zamanoo din ra, borey šintin ka Abadantaa maaɲoo cee. ");
INSERT INTO ses_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adama hayroo taarikoo ne. Hanoo kaŋ Irkoy na boro taka, a nkʼa tee a ma hima nda nga. ");
INSERT INTO ses_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Hanoo kaŋ Irkoy na aru nda woy taka, a na albarka daŋ i ra, a na maaɲey daŋ «boro». ");
INSERT INTO ses_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Waatoo kaŋ ra Adama too jiiri zangu nda waranza (130), nga no a duu izʼaru foo sanda nga cine. Nga himakasinaa no. Maaɲoo kaŋ a nʼa daŋ a ga ti Seti. ");
INSERT INTO ses_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Seti hayyanoo banda ga, Adama huna jiiri zangu yaaha (800). A na izʼaruyaŋ nda ize woyyaŋ hay. ");
INSERT INTO ses_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adama duu jiiri zangu yagga nda waranza (930) aloomur jina, a faati. ");
INSERT INTO ses_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Waatoo kaŋ Seti duu jiiri zangu nda igguu (105), a na Enoš hay. ");
INSERT INTO ses_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enoš hayyanoo banda ga, Seti huna jiiri zangu yaaha nda iyye (807). A na izʼaruyaŋ nda ize woyyaŋ hay. ");
INSERT INTO ses_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Seti duu jiiri zangu yagga nda iwoy cindi hinka (912) aloomur jina, a faati. ");
INSERT INTO ses_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Waatoo kaŋ Enoš duu jiiri woyyagga (90), a na Kenaŋ hay. ");
INSERT INTO ses_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kenaŋ hayyanoo banda ga, Enoš huna jiiri zangu yaaha nda iwoy cindi guu (815). A na izʼaruyaŋ nda ize woyyaŋ hay. ");
INSERT INTO ses_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enoš duu jiiri zangu yagga nda igguu (905) aloomur jina, a faati. ");
INSERT INTO ses_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Waatoo kaŋ Kenaŋ duu jiiri woyye (70), a na Malalel hay. ");
INSERT INTO ses_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Malalel hayyanoo banda ga, Kenaŋ huna jiiri zangu yaaha nda woytaaci (840). A na izʼaruyaŋ nda ize woyyaŋ hay. ");
INSERT INTO ses_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenaŋ duu jiiri zangu yagga nda iwoy (910) aloomur jina, a faati. ");
INSERT INTO ses_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Waatoo kaŋ Mahalalel duu jiiri woydu cindi guu (65), a na Yered hay. ");
INSERT INTO ses_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Yered hayyanoo banda ga, Mahalalel huna jiiri zangu yaaha nda waranza (830). A na izʼaruyaŋ nda ize woyyaŋ hay. ");
INSERT INTO ses_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalalel duu jiiri zangu yaaha nda woyyagga cindi guu (895) aloomur jina, a faati. ");
INSERT INTO ses_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Waatoo kaŋ Yered duu jiiri zangu nda woydu cindi hinka (162), a na Henok hay. ");
INSERT INTO ses_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Henok hayyanoo banda ga, Yered huna jiiri zangu yaaha (800). A na izʼaruyaŋ nda ize woyyaŋ hay. ");
INSERT INTO ses_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yered duu jiiri zangu yagga nda woydu cindi hinka (962) aloomur jina, a faati. ");
INSERT INTO ses_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Waatoo kaŋ Henok duu jiiri woydu cindi guu (65), a na Metusala hay. ");
INSERT INTO ses_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Metusala hayyanoo banda ga, Henok na Irkoy gana jiiri zangu hinza (300). A na izʼaruyaŋ nda ize woyyaŋ hay. ");
INSERT INTO ses_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Henok duu jiiri zangu hinza nda woydu cindi guu (365) aloomur. ");
INSERT INTO ses_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Henok na Irkoy gana, boro mana dii a koyne, zama Irkoy kʼa zaa kʼa ka koy nga do. ");
INSERT INTO ses_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Waatoo kaŋ Metusala duu jiiri zangu nda woyyaaha cindi iyye (187), a na Lemek hay. ");
INSERT INTO ses_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lemek hayyanoo banda ga, Metusala huna jiiri zangu iyye nda woyyaaha cindi hinka (782). A na izʼaruyaŋ nda ize woyyaŋ hay. ");
INSERT INTO ses_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metusala duu jiiri zangu yagga nda woydu cindi yagga (969) aloomur jina, a faati. ");
INSERT INTO ses_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Waatoo kaŋ Lemek too jiiri zangu nda woyyaaha cindi hinka (182), a na izʼaru foo hay. ");
INSERT INTO ses_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","A na maaɲoo daŋ Nuhu (maanaa «bineyaynandi»). Lemek nee: «Woo gʼir biney yaynandi laboo kaŋ Abadantaa nʼa laali goy šendaa ra.» ");
INSERT INTO ses_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nuhu hayyanoo banda ga, Lemek huna jiiri zangu guu nda woyyagga cindi guu (595). A na izʼaruyaŋ nda ize woyyaŋ hay. ");
INSERT INTO ses_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lemek duu jiiri zangu iyye nda woyye cindi iyye (777) aloomur jina, a faati. ");
INSERT INTO ses_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nuhu goo nda zangu guu (500) kaŋ a na Sem, nda Šam, nda Žafet hay. ");
INSERT INTO ses_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Waatoo kaŋ nbunadam šintin ka hay ka cere hay laboo ga, i duu ize woyyaŋ. ");
INSERT INTO ses_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Irkoy izʼarey dii kaŋ nbunadam ize woyey ga boori, de i na woyey hiiji kaŋ i nʼi suuba i ra. ");
INSERT INTO ses_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Abadantaa nee: «Hundoo kaŋ ay nʼa noo nbunadam se si cindi a ra hala abada, zama a manʼti kala faatante. Nga aloomuroo ga tee jiiri zangu nda waranka (120).» ");
INSERT INTO ses_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Zamanoo din ra, boro doogoyaŋ goo laboo ga. I ga bara waatoo kaŋ Irkoy izʼarey koy goro nda nbunadam ize woyey ka duu i ga izeyaŋ. Ngi ti cee jinaa wongaari forantey. ");
INSERT INTO ses_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Abadantaa dii kaŋ nbunadam borolaalataraa hanse ka boobo laboo ra, de mo zaaroo kul nga binoo miilewey manʼti kala ifutu. ");
INSERT INTO ses_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Woo se Abadantaa nimsi nda haya kaŋ se nga na borey tee laboo boŋ, de mo binoo hanse ka maray. ");
INSERT INTO ses_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Abadantaa nee: «Borey kaŋ ay nʼi taka, ay gʼi tuusu kʼi kaa laboo boŋ, kʼa dii za nbunadam hala alman, hala labukoy, hala beenaa ciraw, zama ay nimsi nda haya kaŋ se ay nʼi tee.» ");
INSERT INTO ses_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Amma Nuhu duu alhormo Abadantaa do. ");
INSERT INTO ses_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Woo ti Nuhu fillaa. Nuhu manʼti kala boro šerrante kaŋ ga henan nga alwaddaa ra. A na Irkoy gana. ");
INSERT INTO ses_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Izʼaru hinza no Nuhu nʼi hay kaŋ maaɲey ti Sem, nda Šam, nda Žafet. ");
INSERT INTO ses_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Irkoy do, nbunadam hasara, laboo too nda ngi kurimunyanoo. ");
INSERT INTO ses_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Irkoy dii kaŋ laboo hasara, zama takahaya foo kul kaŋ goo laboo boŋ na fondo futu zaa. ");
INSERT INTO ses_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Woo banda ga, Irkoy nee Nuhu se: «Ay na anniyaa zaa ka benandi nda hundikoyney kul, zama i na laboo too nda ngi kurimunyanoo. Ay ga ngi nda laboo halaci. ");
INSERT INTO ses_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Amma ni, sunduku beeri tee nda bundu yakuwante kaŋ ga tee ma ne harihii. Ma hugu-huguyaŋ tee sundukoo ra. Ma gundoo nda tarayheroo kul yon nda yonhaya. ");
INSERT INTO ses_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Takaa ne kaŋ nda nʼga hima kʼa tee: hiyoo ma duu kabedaaru zangu hinza (300) kuuyan. A ma duu kabedaaru woyguu (50) hayyan. A ma duu kabedaaru waranza (30) kayyan. ");
INSERT INTO ses_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ma zanfun kaŋ ga sawa nda kabedaaru foo hayyan kaa beeneheroo ra. Sundukoo caraa ga ma miɲoo kaa. Ma sooro hinka cin gundoo ra. ");
INSERT INTO ses_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Nga ne, agay, ay ga hari beeri foo kaŋandi laboo boŋ hala a ma takahaya kul kaŋ hundi goo niinoo ra kaŋ goo aduɲɲa ra halaci. Haya kul kaŋ goo laboo boŋ ga dere. ");
INSERT INTO ses_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Amma ni, ay ga ni noo amaana. Nʼga huru sundukoo kaŋ nʼnʼa tee harihii ra, ni nda ni izʼarey, nda ni wandoo, nda ni nzurawey kaŋ ti ni izey wandey. ");
INSERT INTO ses_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Takahaya kul kaŋ ra hundi goo, ma ihinka-hinka daŋ ni bande hiyoo ra, woy nda aru, hala i ma hin ka huna ni bande. ");
INSERT INTO ses_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Ma woy nda aru zaa cirawey dumey kul ra, nda almaney dumey kul ra, nda labukoyey dumey kul ra. I ga kaa ni do, hala i ma hin ka huna. ");
INSERT INTO ses_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","De mo haya kul kaŋ ti ŋaayan kaŋ ga bara, mʼa zaa ni bande, hala a ma tee ni nda ey se šilfandaa.» ");
INSERT INTO ses_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Hayey kul kaŋ Irkoy nʼi har, Nuhu nʼi tee. A nʼi tee nda takaa kaŋ nda Irkoy nʼa yaamar. ");
INSERT INTO ses_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Woo banda ga, Abadantaa nee Nuhu se: «Huru harihiyoo ra, ni nda ni hugoo borey kul, zama ay do, ni hinne ti šerrante ni alwaddaa ra. ");
INSERT INTO ses_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Adabbawey kul kaŋ ga halal, dumi foo kul, ma woy nda aru iyye-iyye zaa i ra. Wey kaŋ ga harram, dumi foo kul, ma woy nda aru foo zaa i ra. ");
INSERT INTO ses_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Beenaa cirawey mo, ma woy nda aru iyye-iyye zaa i ra hala ngi dumoo masi dere laboo boŋ. ");
INSERT INTO ses_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Zama ne nda jirbi iyye ay ga ncirɲi zumandi laboo boŋ kaŋ ga kara cijin nda zaari hala jirbi woytaaci (40). Haya kul kaŋ ti hundikoyni kaŋ ay nʼa tee kaŋ goo laboo boŋ, ay gʼa tuusu.» ");
INSERT INTO ses_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Hayey kul kaŋ Abadantaa nʼi yaamar, Nuhu nʼi tee. ");
INSERT INTO ses_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Jiiri zangu iddu (600) bara Nuhu se waatoo kaŋ hari beeroo kaa ka laboo daabu. ");
INSERT INTO ses_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nuhu nda nga izʼarey, nda nga wandoo, nda nga izʼarey wandey huru hiyoo ra ka hun hari beeroo cire. ");
INSERT INTO ses_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Adabbawey kul, wey kaŋ ga halal nda wey kaŋ ga harram, nda cirawey nda haya kul kaŋ ga ziilam-ziilam laboo ga, ");
INSERT INTO ses_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ihinka-hinka, woy nda aru, kaa Nuhu do ka huru a bande harihiyoo ra, sanda takaa kaŋ nda Irkoy nʼa yaamar. ");
INSERT INTO ses_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Jirbi iyye banda ga, hari beeroo kaa ka laboo daabu. ");
INSERT INTO ses_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nuhu jiiri zangu idduwantoo (600to) ra, handu hinkantoo jirbi woy cindi iyyantoo (17to) ga, hanoo din, laboo cire guusu beeroo miɲey kul bagu nda hari, beenaa mo miɲey feeri. ");
INSERT INTO ses_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ncirɲoo kaŋ laboo boŋ cijin nda zaari hala jirbi woytaaci (40). ");
INSERT INTO ses_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Hanoo din hunday no Nuhu nda nga izʼarey kaŋ ti Sem, nda Šam, nda Žafet, nda Nuhu wandoo, nda nga izʼarey wande hinza huru harihiyoo ra, ");
INSERT INTO ses_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ngi nda hooga dumi kul, nda adabba dumi kul, nda labukoy kaŋ ga ziilam-ziilam laboo ga dumi kul, nda ciraw dumi kul nda hayey kul kaŋ goo nda fata ka deeši. ");
INSERT INTO ses_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Takahaya kul kaŋ hundi goo a ra, kaa ihinka-hinka Nuhu do ka huru a bande harihiyoo ra. ");
INSERT INTO ses_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Dumi foo kul woy nda aru ka huru hiyoo ra sanda takaa kaŋ nda Irkoy na Nuhu yaamar. Woo banda ga, Abadantaa na harihiyoo miɲoo daabu a ga. ");
INSERT INTO ses_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Hari beeroo woo kara laboo ga jirbi woytaaci (40). Haroo hanse ka boobo, de a na hiyoo doyandi kʼa jer laboo ga. ");
INSERT INTO ses_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Haroo hanse ka tonton ka boobo laboo ga, de hiyoo cindi ka doy haroo boŋ. ");
INSERT INTO ses_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Haroo cindi a ga hanse ka tonton ka boobo laboo ga. Haroo na tondi hondu beerey kul kaŋ goo aduɲɲa ra daabu. ");
INSERT INTO ses_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Haroo na tondi hondey daabu, de mo a bisa ey nda kabedaaru woy cindi guu (15). ");
INSERT INTO ses_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Hundikoyni kul kaŋ ga ziilam-ziilam laboo ga, za cirawey hala adabbawey, hala hoogawey nda haya kul kaŋ ga ɲuuti laboo ga nda nbunadamey kul halaci. ");
INSERT INTO ses_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Haya kul kaŋ hundi goo niinoo ra kaŋ goo labu kogaa boŋ kul buu. ");
INSERT INTO ses_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Irkoy na haya kul kaŋ ti hundikoyni kaŋ goo laboo ga tuusu kʼi derandi, ma dii za nbunadam hala adabba, hala labukoy, hala ciraa, i kul tuusandi ka dere laboo boŋ. Nuhu nda wey kaŋ goo a bande hinne ka hallasi. ");
INSERT INTO ses_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Haroo cindi laboo boŋ jirbi zangu nda woyguu (150). ");
INSERT INTO ses_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Woo banda ga, Irkoy ɲeli Nuhu nda hoogawey nda adabbawey kul ga kaŋ goo a bande harihiyoo ra. Irkoy na hew foo funsu laboo boŋ kaŋ na haroo zumandi. ");
INSERT INTO ses_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Laboo cire guusu beeroo miɲey nda beenaa miɲey daabu, de ncirɲoo kay. ");
INSERT INTO ses_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Kayna-kayna haroo ga yee ganda laboo ga. Hala a ga too jirbi zangu nda woyguu (150) kul haroo cindi a ga yee ganda ka kacca. ");
INSERT INTO ses_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Handu iyyantoo jirbi woy cindi iyyantoo (17to) ra, hiyoo koy kay gandaa kaŋ maaɲoo ti Ararat tondi hondey boŋ. ");
INSERT INTO ses_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Haroo cindi de a ga zunbu hala handu woyantoo (10to) ga. Handu woyantoo (10to) din zaari jinaa, tondi hondey boŋey šintin ka fatta. ");
INSERT INTO ses_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Jirbi woytaaci (40) banda ga, Nuhu na zanfunoo feeri kaŋ a nʼa kaa hiyoo beeneheroo ra. ");
INSERT INTO ses_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","A na gaaru-gaaru foo donto, a deeši ka koy, amma cee boobo gaaru-gaaroo ga koy a ga yee kate, hala waatoo kaŋ ra haroo ben laboo ga. ");
INSERT INTO ses_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Woo banda ga, Nuhu yee koyne ka tuuzun foo donto ka dii wala haroo yee ganda laboo ga. ");
INSERT INTO ses_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Amma tuuzunoo mana hin ka duu nongu kaŋ ra nga ga kay. A yee kate hiyoo do, zama haroo na laboo kul daabu. Nuhu na nga kaboo šerre, a na tuuzunoo dii, a nʼa daŋ nga bande hiyoo ra. ");
INSERT INTO ses_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","A batu hala jirbi iyye koyne, a duu ka yee ka tuuzunoo donto a ma koy. ");
INSERT INTO ses_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Tuuzunoo yee kate a do almaaroo ra, hiino zaytuɲaa fita gani foo goo miɲoo ra. Waatoo din Nuhu bay kaŋ haroo yee ganda. ");
INSERT INTO ses_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","A yee koyne ka batu hala jirbi iyye, a duu ka tuuzunoo donto, tuuzunoo mana yee kate a do koyne. ");
INSERT INTO ses_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nuhu jiiri zangu iddu nda affaantoo (601to) handu jinaa zaari jinaa, nga no haroo kogu ka ben laboo ga. Nuhu na hiyoo daabirjoo kaa a ga, de a dii kaŋ laboo kogu. ");
INSERT INTO ses_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Handu hinkantoo jirbi waranka cindi iyyantoo (27to) hane, laboo kogu karbaši. ");
INSERT INTO ses_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Woo banda ga, Irkoy šelaŋ Nuhu se ka nee: ");
INSERT INTO ses_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«Fatta hiyoo ra, ni nda ni wandoo, nda ni izʼarey nda ngi wandey. ");
INSERT INTO ses_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Hundikoyni dumi kul kaŋ goo ni bande, nda cirawey, nda almaney, nda labukoyey kul kaŋ ga ziilam-ziilam laboo ga, mʼi ka fatta ni bande hiyoo ra. I ma ɲuuti laboo ga, i ma hay ka cere hay, ka boobo laboo ga!» ");
INSERT INTO ses_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Nuhu nda nga izʼarey nda nga wandoo nda nga izey wandey fatta a bande. ");
INSERT INTO ses_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Adabbawey kul, nda labukoyey kul, nda cirawey kul, nda haya kul kaŋ ga ɲuuti laboo ga, dumi foo kul fatta cere bande hiyoo ra. ");
INSERT INTO ses_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nuhu na sargari tonadoo cin Abadantaa maaɲoo ga. Nuhu zaa adabba halalantey nda ciraw halalantey ra, a nʼi tee sargari kukurante sargari tonadogoo boŋ. ");
INSERT INTO ses_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Abadantaa maa sunnaaraa kaana, de a nee nga boŋ se: «Ay si yee ka laboo danga nbunadam sabbu se, ba nda nbunadam binoo miilewey manʼti kala ifutu za nga zankataraa ga. Ay si yee ka hundikoyney kul halaci sanda takaa kaŋ agay ne kʼa tee. ");
INSERT INTO ses_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Kullihinne laboo ga bara, dumayan nda hegayyan, yayni nda konni, kaydiya nda jiyaw, cijin nda zaari si ben.» ");
INSERT INTO ses_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Irkoy na albarka daŋ Nuhu nda nga izʼarey ra ka nee i se: «Wa tonton, war ma hay ka cere hay, de war ma laboo too. ");
INSERT INTO ses_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Hõ banda ga, war ga tee hunburhaya nda jitandikaw laboo adabba kul se, nda ciraa kul, nda hundikoyni kul kaŋ ga ɲuuti laboo ga, nda teekoo hamiisa kul. Wey kul ay nʼi daŋ war kabey ra. ");
INSERT INTO ses_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Haya kul kaŋ ga huna, a ga ɲuuti, ga tee war meehunaa sanda subu firzoo takaa. Ay nʼi kul noo war se. ");
INSERT INTO ses_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Amma war masi ham ŋaa kaŋ ra hundi goo, maanaa hamoo nda nga kuroo. ");
INSERT INTO ses_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Amma mo, war kuroo kaŋ ti war hunaroo, boro kul kaŋ a nʼa mun, ay gʼa hãa nda a. A ma tee adabba wala adamize. Adamize foo kul ay gʼa hãa nda nga cinaa hundoo. ");
INSERT INTO ses_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Boro kaŋ na adamize kuroo mun, Adamize no ma kaa ka nga mo kuroo mun, zama Irkoy nka boro taka hala a ma hima nda nga. ");
INSERT INTO ses_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","War, wa duu izeyaŋ, war ma hay ka cere hay. War ma laboo too, war ma boobo a ra.» ");
INSERT INTO ses_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Irkoy yee ka šelaŋ Nuhu nda nga izʼarey kaŋ goo a bande se ka nee: ");
INSERT INTO ses_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«Agay, ay ga war noo agay amaanaa, war nda war hayroo kaŋ ga kaa war dumawey ga, ");
INSERT INTO ses_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","nda hundikoyney kul kaŋ goo war bande, a ma tee ciraw, wala adabba, wala ganjihooga kul, nda haya kul kaŋ fatta ni bande harihiyoo ra, nda ganjihooga kul. ");
INSERT INTO ses_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ay ga war noo agay amaanaa kaŋ hari beeri si yee ka hundikoyney kul benandi, de hari beeri si yee ka tee kaŋ ga laboo halaci.» ");
INSERT INTO ses_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Irkoy nee koyne: «Agay amaanaa kaŋ goo agay nda war game, nda hundikoyni kul kaŋ goo war bande, nda alwaddawey kul kaŋ ga kaa borey, nga tammaasaa ti ");
INSERT INTO ses_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","kaŋ ay nʼay beenegondoo daŋ duulawey ra. A ga tee amaana tammaasa agay nda laboo game. ");
INSERT INTO ses_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Waati kul kaŋ ay na duulawey marga laboo se beene, de ay nʼay beenegondoo bangandi duulawey ra, ");
INSERT INTO ses_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ay ga hongu agay amaanaa kaŋ goo agay, nda war, nda takahaya hundikoyney kul game. Ncirɲi si yee ka tee hari beeri ka takahayey kul halaci. ");
INSERT INTO ses_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Beenegondoo ga bangay duulawey ra, ay gʼa guna hala ya duu ka hongu amaana abadantaa kaŋ goo agay kaŋ ti Irkoy nda takahaya hundikoyney kul game kaŋ goo laboo ga.» ");
INSERT INTO ses_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Irkoy nee Nuhu se: «Woo ti amaanaa tammaasaa kaŋ ay nʼa daŋ agay nda hundikoyney kul game kaŋ goo laboo ga.» ");
INSERT INTO ses_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nuhu izʼarey kaŋ fatta harihiyoo ra manʼti kala Sem, nda Šam, nda Žafet. Šam ti Kanaŋ baabaa. ");
INSERT INTO ses_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Nuhu izʼaru hinzaa no ka hay ka laboo too nda boro. ");
INSERT INTO ses_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuhu ti beerikaw jinaa kaŋ na alaneb faari tee. ");
INSERT INTO ses_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","A na alaneboo hari mooraa haŋ, a suu, de a kay nga gaa koonoo nga hukkumoo ra. ");
INSERT INTO ses_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Šam kaŋ ti Kanaŋ baabaa, dii nga gaa koonoo, de a koy a filla taray nga arma hinkaa se. ");
INSERT INTO ses_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Woo banda ga, Sem nda Žafet na burmusoo zaa kʼa daŋ ngi jesey ga, i dira ka huru nda banda-banda kʼa gum. I mana dii ngi baabaa gaa koonoo, zama i nka duma bere ka huru a kone. ");
INSERT INTO ses_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Waatoo kaŋ suuyanoo ben Nuhu bande, a maa haya kaŋ nga izʼaru kaccaa nʼa tee. ");
INSERT INTO ses_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Woo ka kate, a nee: «Ay na Kanaŋ laali. Yala a ma tee nga armey baɲɲey baɲɲaa!» ");
INSERT INTO ses_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Nuhu yee koyne ka tonton ka nee: «Albarka ma bara Abadantaa se kaŋ ti Sem Koyoo! Yala Kanaŋ ma tee Sem baɲɲaa! ");
INSERT INTO ses_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Yala Irkoy ma Žafet feeri! Yala alaafiyaa ma bara Sem nda Žafet hukkumey nda cere game! De mo Kanaŋ ma tee ngi baɲɲaa!» ");
INSERT INTO ses_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Hari beeroo banda ga, Nuhu huna jiiri zangu hinza nda woyguu (350). ");
INSERT INTO ses_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nuhu aloomuroo kul kaŋ a duu a, manʼti kala jiiri zangu yagga nda woyguu (950). Woo banda ga, a faati. ");
INSERT INTO ses_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Nuhu izʼarey kaŋ ti Sem, nda Šam, nda Žafet hayroo ti wey. I duu izeyaŋ hari beeroo kaŋyanoo banda ga. ");
INSERT INTO ses_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Žafet izʼarey ti: Gomer, nda Magog, nda Maday, nda Yawaŋ, nda Tubal, nda Mešek, nda Tiras. ");
INSERT INTO ses_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomer izʼarey ti: Aškenaz, nda Rifat, nda Togarma. ");
INSERT INTO ses_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yawaŋ izʼarey ti: Eliša, nda Tarsis, nda Kiti borey, nda Rodaŋ borey. ");
INSERT INTO ses_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Borey wey ka zamna-zamna gungey ra, ngi laamaa foo kul nda nga šennoo, nda ngi alaayan beerey, nda ngi dumey. ");
INSERT INTO ses_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Šam izʼarey ti: Kuš, nda Misirayim, nda Put, nda Kanaŋ. ");
INSERT INTO ses_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kuš izʼarey ti: Seba, nda Hawila, nda Sabata, nda Raama, nda Sabateka. Raama izʼarey ti Šeba, nda Dedaŋ. ");
INSERT INTO ses_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuš na Namuruz mo hay. Namuruz ti boro jinaa kaŋ tee wongaari laboo ga. ");
INSERT INTO ses_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Namuruz tee hookaw beeri Abadantaa do. Woo ra šennoo hun kaŋ ga nee: «Hookaw beeri no Abadantaa do, sanda Namuruz.» ");
INSERT INTO ses_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Koyra jina-jinawey kaŋ a nʼi laama ti Babel, nda Erek, nda Akad, nda Kalne kaŋ goo gandaa ra kaŋ maaɲoo ti Šineyar. ");
INSERT INTO ses_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Gandaa woo ra Namuruz bisa ka koy Asiri gandaa ra. A na koyrawey cin kaŋyaŋ ti: Niniwe, nda Rehobot, nda Kala, ");
INSERT INTO ses_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","nda koyra beeroo kaŋ ti Reseŋ kaŋ goo Niniwe nda Kala gamoo ra. ");
INSERT INTO ses_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misirayim ti Lud borey hayragoo, nda Anam borey, nda Lehab borey, nda Naftuwa borey, ");
INSERT INTO ses_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","nda Patrus borey, nda Kasalu borey, nda Kaftor borey. Filisti borey mana hun kala Kasalu borey ga. ");
INSERT INTO ses_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaŋ na Sidoŋ hay, nga ti nga izʼaru jinaa, nga dumaa ga, a na Heti hay. ");
INSERT INTO ses_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Nga ga Žebus borey, nda Amor borey, nda Girgaši borey, ");
INSERT INTO ses_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","nda Hewi borey, nda Arki borey, nda Sini borey, ");
INSERT INTO ses_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","nda Arwad borey, nda Semar borey, nda Hamat borey hun. Wey kul banda ga, Kanaŋ borey alaayan beerey say-say. ");
INSERT INTO ses_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kanaŋ borey gandaa hirroo ti ka hun za koyraa kaŋ maaɲoo ti Sidoŋ, Gerar kaboo here, hala Gaaza. Ka yee kʼa dii fondaa kaŋ ga koy koyrawey ra kaŋ ti Sodom, nda Gomor, nda Aduma, nda Seboyim here hala Leša. ");
INSERT INTO ses_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Wey ti Šam hayroo. Alaayan beeri foo kul goo cere bande, wey kaŋ ga šenni follokaa šelaŋ goo cere bande ngi laamawey nda ngi gandawey ra. ");
INSERT INTO ses_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem kaŋ ti Žafet beerʼaroo, duu izʼaruyaŋ. Eber nda nga izʼarey kul hayragoo ti nga. ");
INSERT INTO ses_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem izʼarey ti: Elam, nda Ašur, nda Arfazad, nda Lud, nda Aram. ");
INSERT INTO ses_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram izʼarey ti: Utus, nda Hul, nda Geter, nda Maš. ");
INSERT INTO ses_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfazad na Šela hay, Šela na Eber hay. ");
INSERT INTO ses_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber duu izʼaru hinka. Affoo maaɲoo ti Peleg (maanaa «zamna»), zama nga waatoo ra laboo zamnandi. Armaa maaɲoo ti Yokutaŋ. ");
INSERT INTO ses_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yokutaŋ na Almodad hay, nda Šelef, nda Hasarmawet, nda Yera, ");
INSERT INTO ses_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","nda Hadoram, nda Uzal, nda Dikla, ");
INSERT INTO ses_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","nda Obal, nda Abimayel, nda Šeba, ");
INSERT INTO ses_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","nda Ofir, nda Hawila, nda Yobab. Wey kul manʼti kala Yokutaŋ izʼaruyaŋ. ");
INSERT INTO ses_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ngi gorodogoo ti, mʼa dii za Meša, Sefar kaboo here, hala waynahunay tondi hondey do. ");
INSERT INTO ses_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Wey ti Sem hayroo. Alaayan beeri foo kul goo cere bande, wey kaŋ ga šenni follokaa šelaŋ goo cere bande ngi laamawey nda ngi gandawey ra. ");
INSERT INTO ses_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Wey ti Nuhu izʼarey alaayan beerey, alwadda ka kaa alwadda, ganda ka kaa ganda. Borey wey ga gandawey hun, ka zamna-zamna laboo ga hari beeroo kaŋyanoo banda ga. ");
INSERT INTO ses_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Zaman tee kaŋ aduɲɲa kul, šenni follokaa, nda kalima follokey no i gʼa šelaŋ. ");
INSERT INTO ses_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Kaŋ adamizey saraysaray ka koy waynahunay here, i dii taraŋtaraŋ foo kaŋ goo gandaa ra kaŋ maaɲoo ti Šineyar. I na no din tee ngi gorodogoo. ");
INSERT INTO ses_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","I nee cere se: «Wa kaa, ir ma ferawyaŋ kar kʼi ton nuune ra.» I mana tondi ka cina, feraw nda i cina. Guduroŋ ti hayaa kaŋ ga ferawey kanji cere ga. ");
INSERT INTO ses_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","I nee cere se koyne: «Wa kaa, ir ma koyra cin ir boŋ se kaŋ ra soorohugu kuku goo kaŋ boŋoo ga too beenaa. Ir ma maa tee ir boŋ se hala ir masi duu ka say-say laboo kul boŋ.» ");
INSERT INTO ses_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Abadantaa zunbu ka dii koyraa nda soorohugu kukoo kaŋ adamizey nʼi cin. ");
INSERT INTO ses_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Woo banda ga, a nee nga boŋ se: «Nga ne, i tee jama foo, i ga šenni follokaa šelaŋ. Woo ti šintinoo hinne! Sohõ haya sii no kaŋ gʼi ganji i ma haya tee kaŋ i baa. ");
INSERT INTO ses_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Wa kaa, ir ma zunbu ka ngi šennoo ɲaami cere ra hala affoo kul masi maa nga ceroo šennoo.» ");
INSERT INTO ses_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","No din ra Abadantaa na borey say-say laboo kul ga, de i tun koyraa cinayanoo ga. ");
INSERT INTO ses_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Woo se i ga nee a se Babel, zama no din ra Abadantaa na aduɲɲa kul šennoo ɲaami cere ra. No din mo ra Abadantaa na adamizey say-say laboo kul ga. ");
INSERT INTO ses_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Sem hayroo ne. Jiiri hinka hari beeroo kaŋyanoo banda ga, Sem na Arfazad hay, a goo nga jiiri zangoo (100) ra. ");
INSERT INTO ses_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Sem huna jiiri zangu guu (500) Arfazad hayyanoo banda ga. A duu izʼaruyaŋ nda ize woyyaŋ. ");
INSERT INTO ses_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfazad goo nda jiiri waranza cindi guu (35) waatoo kaŋ ra a na Šela hay. ");
INSERT INTO ses_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arfazad huna jiiri zangu taaci nda ihinza (403) Šela hayyanoo banda ga. A duu izʼaruyaŋ nda ize woyyaŋ. ");
INSERT INTO ses_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Kaŋ Šela duu jiiri waranza (30), a na Eber hay. ");
INSERT INTO ses_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Šela huna jiiri zangu taaci nda ihinza (403) Eber hayyanoo banda ga. A duu izʼaruyaŋ nda ize woyyaŋ. ");
INSERT INTO ses_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Kaŋ Eber duu jiiri waranza cindi taaci (34), a na Peleg hay. ");
INSERT INTO ses_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eber huna jiiri zangu taaci nda waranza (430) Peleg hayyanoo banda ga. A duu izʼaruyaŋ nda ize woyyaŋ. ");
INSERT INTO ses_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Kaŋ Peleg duu jiiri waranza (30), a na Rehu hay. ");
INSERT INTO ses_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Peleg huna jiiri zangu hinka nda yagga (209) Rehu hayyanoo banda ga. A duu izʼaruyaŋ nda ize woyyaŋ. ");
INSERT INTO ses_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Kaŋ Rehu duu jiiri waranza cindi hinka (32), a na Serug hay. ");
INSERT INTO ses_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Rehu huna jiiri zangu hinka nda iyye (207) Serug hayyanoo banda ga. A duu izʼaruyaŋ nda ize woyyaŋ. ");
INSERT INTO ses_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Kaŋ Serug duu jiiri waranza (30), a na Nahor hay. ");
INSERT INTO ses_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Serug huna jiiri zangu hinka (200) Nahor hayyanoo banda ga. A duu izʼaruyaŋ nda ize woyyaŋ. ");
INSERT INTO ses_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Kaŋ Nahor duu jiiri waranka cindi yagga (29), a na Tera hay. ");
INSERT INTO ses_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nahor huna jiiri zangu nda iwoy cindi yagga (119) Tera hayyanoo banda ga. A duu izʼaruyaŋ nda ize woyyaŋ. ");
INSERT INTO ses_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Kaŋ Tera duu jiiri woyye (70), a na Ibirim, nda Nahor, nda Haraŋ hay. ");
INSERT INTO ses_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tera hayroo ne. Tera na Ibirim, nda Nahor, nda Haraŋ hay. Haraŋ na Lotu hay. ");
INSERT INTO ses_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haraŋ mana faati kala koyraa kaŋ ra a hayandi kaŋ ti Ur koyraa ra kaŋ goo Kalde gandaa ra. A faati baaboo kaŋ ti Tera jine. ");
INSERT INTO ses_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ibirim nda Nahor na wandeyaŋ zaa. Ibirim wandoo maaɲoo ti Saray. Nahor wanoo maaɲoo ti Milka kaŋ ti Haraŋ ize woyoo. Haraŋ ti Milka nda Yisika baabaa. ");
INSERT INTO ses_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saray manʼti kala woy gun, a sii nda ize. ");
INSERT INTO ses_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera na nga izʼaroo Ibirim zaa, nda nga haamaa Lotu kaŋ ti Haraŋ izʼaroo, nda nga nzura woyoo Saray kaŋ ti Ibirim wandoo. I hun Ur kaŋ goo Kalde ka koy gandaa ra kaŋ maaɲoo ti Kanaŋ. Kaŋ i too Karaŋ, i na no din tee ngi gorodogoo. ");
INSERT INTO ses_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Aloomuroo kaŋ Tera duu a manʼti kala jiiri zangu hinka nda igguu (205). A mana faati kala Karaŋ. ");
INSERT INTO ses_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Abadantaa nee Ibirim se: «Fatta ni gandaa, nda ni dumoo, nda ni baabaa hugoo ka koy gandaa ra kaŋ ay gʼa cebe ma ne. ");
INSERT INTO ses_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ay ga ni tee dumi beeri. Ay ga albarka daŋ ni ra. Ay ga ni maaɲoo noo addawla. Ma tee albarkahaya borey se! ");
INSERT INTO ses_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Borey kaŋ ga gaara ma ne, ay ga albarka daŋ i ra, amma boro kaŋ na ni danga, ay gʼa laali. Ni bande, aduɲɲa alaayan beerey kul ga duu albarka.» ");
INSERT INTO ses_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Ibirim koy nda takaa kaŋ nda Abadantaa nʼa har a se. Lotu koy a bande. Kaŋ Ibirim ga fatta Karaŋ, jiiri woyye cindi guu (75) bara a se. ");
INSERT INTO ses_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","A koy nda nga bande nga wandoo Saray, nda nga armaa izʼaroo Lotu, nda nga almanoo, nda boro kul kaŋ goo maaɲoo ga kaŋ i duu ey Karaŋ. I tun ka koy gandaa kaŋ maaɲoo ti Kanaŋ. Waatoo kaŋ i too no din, ");
INSERT INTO ses_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ibirim dira gandaa ra ka too hala koyraa kaŋ maaɲoo ti Šekem, More tuuriɲaa beeroo do. Zamanoo din Kanaŋ borey no ma goro gandaa ra. ");
INSERT INTO ses_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Amma Abadantaa bangay Ibirim se, a nee a se: «Ni hayroo se ay ga gandaa woo noo.» Ibirim na sargari tonadoo cin Abadantaa kaŋ bangay a se maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Woo banda ga, a dira ka koy tondi hondoo here kaŋ goo koyraa kaŋ maaɲoo ti Betel waynahunay kaboo here. A na nga hukkumoo cin Betel kaŋ goo waynakaŋay nda koyraa kaŋ se i ga nee Ayi kaŋ goo waynahunay game. A na sargari tonadoo cin Abadantaa maaɲoo ga, a na Abadantaa maaɲoo cee. ");
INSERT INTO ses_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Woo banda ga, Ibirim yee ka saraysaray ka koy Negew gandaa ra. ");
INSERT INTO ses_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Heray foo tee gandaa ra. Heraa laalayanoo se, Ibirim naaru ka doo Misira gandaa ra ka goro ka waati tee no din. ");
INSERT INTO ses_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Waatoo kaŋ i ga baa ka huru Misira gandaa ra, a nee nga wandoo Saray se: «Aywa! Ay ga bay kaŋ woy borya ti ni. ");
INSERT INTO ses_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Nda Misira borey dii ni, i ga nee kaŋ ay wandoo ti ni. I gʼay wii, i ga ni naŋ ma huna. ");
INSERT INTO ses_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ay gʼa wiri ni ga, ma nee i se kaŋ ay woymaa ti ni! Nga ra i ga kula ay ra. Ni alhormaa ra, ay hundoo ga cindi ay ra.» ");
INSERT INTO ses_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Waatoo kaŋ Ibirim too Misira gandaa ra, Misira borey dii kaŋ woyoo ga hanse ka boori. ");
INSERT INTO ses_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Waatoo kaŋ Firawuuna cee-cirey na woyoo laasaabu, i koy a šifa Firawuuna se. Woo banda ga, woyoo zandi ka koy Firawuuna hugoo do. ");
INSERT INTO ses_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Woyoo sabbu se, Firawuuna na Ibirim dii nda diiyan henna. A nʼa noo alman buuna, nda ibeeri, nda farka aruyaŋ, nda baɲɲayaŋ, nda koŋŋayaŋ, nda farka woyyaŋ, nda yooyaŋ. ");
INSERT INTO ses_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Amma Abadantaa na dori beeriyaŋ ka Firawuuna nda nga hugoo borey kar, Saray kaŋ ti Ibirim wandoo maaganda se. ");
INSERT INTO ses_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Firawuuna ciya Ibirim se, a nee a se: «Cin ti woo kaŋ nʼnʼa tee ya ne? Macin se manʼay bayrandi kaŋ ni wandoo no? ");
INSERT INTO ses_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Macin se ni nee kaŋ ni woymaa no, hala agay ne kʼa zaa ka nee ay gʼa tee wande? Sohõ ni wandoo ne, a zaa, ma koy!» ");
INSERT INTO ses_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Firawuuna na nga borey yaamar kaŋ i ma Ibirim fattandi. A ma koy nda wandoo nda haya kul kaŋ goo a kone. ");
INSERT INTO ses_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ibirim hun Misira gandaa ra ka žigi ka koy Negew, nga, nda nga wandoo, nda nga haya kul kaŋ goo maaɲoo ga, nda Lotu. ");
INSERT INTO ses_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ibirim goo nda adabba boobo, nda nzorfu kaaray boobo, nda wura boobo. ");
INSERT INTO ses_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","A saraysaray ka hun Negew ka koy hala Betel, nongoo kaŋ ra a jin ka nga hukkumoo cin kaŋ goo Betel nda Ayi game, ");
INSERT INTO ses_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","hala nongoo kaŋ ra a na sargari tonadoo jinaa tee. De mo no din ra Ibirim na Abadantaa maaɲoo cee. ");
INSERT INTO ses_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lotu kaŋ goo a bande mo goo nda alman buuna nda ibeeri nda hukkumyaŋ. ");
INSERT INTO ses_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ngi affoo kul adabbawey ga hanse ka boobo, i si hin ka cindi cere bande, gandaa si hin kʼi zaa, zama a ga kacca i se. ");
INSERT INTO ses_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Koyne mo Kanaŋ borey nda Ferezi borey goo gandaa din da ra. Han foo alfitina huru Ibirim almaney kurkey nda Lotu waney game. ");
INSERT INTO ses_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ibirim nee Lotu se: «Ay gʼa wiri ni ga, alfitina masi huru agay nda ni game. A masi huru ay kurkey nda ni waney game, zama ir kul ti hugu follokaa borey. ");
INSERT INTO ses_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Gandaa kul goo ni jine! Ir ma fay. Nda nʼna hawsaa zaa, ay ga gurmaa zaa. Nda nʼna gurmaa zaa, ay ga hawsaa zaa.» ");
INSERT INTO ses_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lotu na nga boŋoo jer, a dii Žurdeŋ isaa ganganoo kul. A ga tay pataku. Woo ti za Abadantaa mana Sodom nda Gomor halaci. Nongoo din ga hima nda Abadantaa saddiɲaa. Ma nee Misira gandaa. A ga koy too hala koyraa kaŋ maaɲoo ti Sohar. ");
INSERT INTO ses_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lotu na Žurdeŋ isaa ganganoo kul suuba nga boŋ se, de a koy waynahunay kaboo here. Takaa woo nda i fay ka hun cere ga. ");
INSERT INTO ses_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ibirim goro Kanaŋ. Lotu koy goro ganganoo koyrawey ra. A na nga hukkumoo cin Sodom koyraa jeroo ga. ");
INSERT INTO ses_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodom borey manʼti kala boro laalayaŋ. Zunubu teekaw beeriyaŋ no Abadantaa do. ");
INSERT INTO ses_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Waatoo kaŋ Lotu hun Ibirim bande, woo din banda ga, Abadantaa nee Ibirim se: «Ni boŋoo jer ka guna, za nongoo kaŋ ra ni goo hala hawsa, nda gurma, nda dandi, nda dangay, ");
INSERT INTO ses_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","zama gandaa kul kaŋ nʼgʼa honnay, ay gʼa noo ni nda ni hayroo se hala abada. ");
INSERT INTO ses_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ay ga ni hayroo tee sanda labutaasi. A ga boobo hala nongu kaŋ ra nda boro ga hin ka labutaasi kabu kul, a ga hin ka ni hayroo kabu. ");
INSERT INTO ses_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Tun ni boŋ ga, ma gandaa kuuyanoo nda nga hayyanoo kul dira, zama ay gʼa noo ma ne.» ");
INSERT INTO ses_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ibirim koy nga hukkumoo cin ka goro boraa kaŋ maaɲoo ti Mamre, tuuriɲaa beerey do kaŋ goo koyra kaŋ se i ga nee Hebroŋ. No din ra a na sargari tonadoo cin Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Waatoo kaŋ ra Šineyar gandaa kokoyoo ti Amrafel, Elasar koyraa kokoyoo ti Aryok, Elam gandaa kokoyoo ti Kedorlawomer, Goyim gandaa kokoyoo ti Tidal, ");
INSERT INTO ses_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","zamanoo din no, i marga ka Bera wongu kaŋ ti Sodom kokoyoo, nda Birša kaŋ ti Gomor kokoyoo, nda Šinab kaŋ ti Aduma kokoyoo, nda Šemeber kaŋ ti Seboyim kokoyoo, nda Bela kaŋ se i ga nee Sohar, kokoyoo. ");
INSERT INTO ses_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Wey kul na cere marga Sidim gandaa gooroo ra kaŋ ti teeko Ciiri-ciirantaa. ");
INSERT INTO ses_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","I na jiiri woy cindi hinka (12) tee, i goo Kedorlawomer cire, amma jiiri woy cindi hinzantoo (13to) ga, i ture. ");
INSERT INTO ses_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Jiiri woy cindi taacantoo (14to) ra, Kedorlawomer nda kokoyey kaŋ marga ka koy Refa borey wongu koyraa ra kaŋ maaɲoo ti Ašitorot-Karanayim. I na Zuz borey wongu koyraa ra kaŋ maaɲoo ti Haam. I na Emu borey wongu Šawe-Kiryatayim. ");
INSERT INTO ses_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","I na Hori borey wongu ngi tondi hondoo ga kaŋ ti Seyir gandaa. I nʼi gaaray hala El-Paraŋ kaŋ goo saajoo jeroo ga. ");
INSERT INTO ses_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Woo banda ga, i yee ngi ceebandawey ra, i too En-Mišpat kaŋ ti koyraa kaŋ maaɲoo ti Kadeš. Ngi wongoo too Amalek borey gandaa kul nda Amor borey kaŋ ga goro Hasasoŋ-Tamar. ");
INSERT INTO ses_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Sodom, nda Gomor, nda Aduma, nda Seboyim, nda Bela kaŋ se i ga nee Sohar, kokoyey kul fatta ka marga ka koy i wongu Sidim gandaa sosooroo ra. ");
INSERT INTO ses_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Wey kaŋ i koy wongu manʼti kala Kedorlawomer kaŋ ti Elam kokoyoo, nda Tidal kaŋ ti Goyim kokoyoo, nda Amrafel kaŋ ti Šineyar kokoyoo, nda Aryok kaŋ ti Elasar kokoyoo. Kokoy taaci no kaŋ ga igguu wongu. ");
INSERT INTO ses_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Sidim gandaa sosooroo kul ti guusuyaŋ kaŋ ga too nda guduroŋ. Sodom nda Gomor kokoyey zuru, de i kaŋ guusey din ra. Wey kaŋ cindi zuru ka koy tondi hondoo here. ");
INSERT INTO ses_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Wongaarey na Sodom nda Gomor almanoo nda ngi meehunaa kul zaa kʼi ka koy. ");
INSERT INTO ses_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","I na Ibirim arma izʼaroo mo kaŋ ti Lotu nda nga almanoo kul zaa ka koy, zama a mana cindi ka goro kala Sodom. ");
INSERT INTO ses_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Boro foo kaŋ zuru koy alhabaroo too Ibirim se kaŋ ti Ebere. Ibirim si goro kala tuuriɲaa beerey do kaŋ Mamre wane nda ey kaŋ ti Amor boro kaŋ ti Eškol nda Aner armaa kaŋyaŋ amaana goo ngi nda Ibirim game. ");
INSERT INTO ses_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Waatoo kaŋ Ibirim maa kaŋ i na nga boraa tee kasa-ize ka koy, a na nga hugu-ize wongaari boro zangu hinza nda iwoy cindi yaaha (318) zaa. I nʼi gaaray hala koyraa ra kaŋ maaɲoo ti Dan. ");
INSERT INTO ses_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","A na wongu-izey zamna, ka nga iberey gande cijinoo ra, nga nda nga tamey. I nʼi kar kʼi gaaray hala koyraa kaŋ se i ga nee Hoba kaŋ goo Damas se hawsa here. ");
INSERT INTO ses_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","A yee kate nda almanoo kul, a yee kate nda nga boraa Lotu nda nga almanoo, nda woyey nda jamaa kaŋ i bay kʼi boy ka koy. ");
INSERT INTO ses_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Waatoo kaŋ Ibirim na Kedorlawomer nda kokoyey kaŋ marga wongu ka hin, Sodom kokoyoo dira ka koy a kubay Šawe sosooroo ra kaŋ ti Kokoyoo sosooroo. ");
INSERT INTO ses_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melšizedek kaŋ ti Zalem kokoyoo, kate ŋaayan nda alaneb hari moora. A mana cindi ka tee kala Irkoy Jerantaa sargari juwalkaw. ");
INSERT INTO ses_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","A gaara Ibirim se ka nee: «Irkoy Jerantaa kaŋ wane beenaa nda laboo ma albarka daŋ Ibirim ra! ");
INSERT INTO ses_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Albarka ma bara Irkoy Jerantaa se kaŋ na ni torrokey kaŋandi ni kaboo ra!» Ibirim na nga hayey azakkaa noo a se. ");
INSERT INTO ses_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sodom kokoyoo nee Ibirim se: «Ay noo borey, de ma almanoo zaa ni boŋ se!» ");
INSERT INTO ses_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Amma Ibirim na Sodom kokoyoo zaabi ka nee: «Ay gʼay kaboo jer ka žee nda Abadantaa kaŋ ti Irkoy Jerantaa kaŋ na beenaa nda laboo taka, ");
INSERT INTO ses_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ay si haya kul zaa ni jinawey ra, ba sana wala šilli, soko ma kaa ka nee: ‹Agay ka Ibirim tee almankoyni.› ");
INSERT INTO ses_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ay boŋ se, ay si haya kul zaa nda manʼti woo kaŋ aru soogey nʼa ŋaa. Borey mo kaŋ hanga ay bande ka koy wongu kaŋ ti Aner, nda Eškol, nda Mamre, ngi, i ma ngi bagaa zaa!» ");
INSERT INTO ses_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Hayey wey banda ga, Abadantaa na šenni har Ibirim se bangayyan ra ka nee a se: «Masi hunbur haya kul, Ibirim! Agay no ma tee ma ne koray. Ni sufuraa ga hanse ka beeri.» ");
INSERT INTO ses_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ibirim zaabi ka nee: «Ay Koyoo, Abadantaa, hayaa kaŋ nʼgʼa noo ya ne koyne, cin no a gʼa hanse ya ne? Agay ne ma aduɲɲa naŋ bila ize. Eliyezer, Damas boraa no mʼay tubu?» ");
INSERT INTO ses_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ibirim nee koyne: «Ni ne manʼay noo hayyan, nga ne ay tamoo kaŋ ti ay hugu-izoo no mʼay tubu.» ");
INSERT INTO ses_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Amma Abadantaa na šenni har Ibirim se ka nee: «Boraa kaŋ nʼnʼa har si ni tubu, amma boraa kaŋ ga hun ni hamoo ra, nga no ma tee ni tubukaa.» ");
INSERT INTO ses_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","A na Ibirim ka koy taraa ra, a nee a se: «Beenaa guna, ma handarawey kabu, nda nʼga hin ka ngi hinnaa bay.» A yee ka nee a se: «Takaa woo no ni hayroo booboyanoo ga ti a.» ");
INSERT INTO ses_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ibirim naanay Abadantaa, de a kabandi a se šerretaray. ");
INSERT INTO ses_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","A nee a se koyne: «Agay ti Abadantaa kaŋ na ni kaa Ur koyraa kaŋ goo Kalde gandaa ra, ka ni noo gandaa woo a ma tee ni wane.» ");
INSERT INTO ses_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ibirim zaabi ka nee: «Ay Koyoo, Abadantaa, macin no mʼay ka hakiika ka bay kaŋ ay ga duu a?» ");
INSERT INTO ses_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Irkoy nee a se: «Haw woy-ize foo kaŋ goo nda jiiri hinza soolu ya ne, nda hancin foo kaŋ goo nda jiiri hinza, nda gaaru foo kaŋ goo nda jiiri hinza, nda gubaguba foo, nda tuuzun-ize foo.» ");
INSERT INTO ses_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ibirim kate adabbawey kul, a na affoo kul dunbu gamoo ga, de a na jere foo kul tenjandi affaa. Amma cirawey hunday, a manʼi zamna. ");
INSERT INTO ses_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Jigaarayaŋ zunbu adabba bukawey boŋ, amma Ibirim nʼi gaaray. ");
INSERT INTO ses_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Waynaa kaŋyanoo ga, jirbi koma foo na Ibirim kaŋandi, de mo hunburay beeri nʼa dii kubaa ra. ");
INSERT INTO ses_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Irkoy nee Ibirim se: «Ma bay kaŋ ni hayroo ga koy taabuši ganda ra kaŋ manʼti nga wanoo. I ga tee baɲɲayaŋ no din, i gʼi žilla jiiri zangu taaci (400). ");
INSERT INTO ses_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Amma ay ga dumoo ciiti kaŋ nʼi daŋ baɲɲataray. Woo din banda ga, i ga fatta ka koy nda alman boobo. ");
INSERT INTO ses_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ni, nʼga koy ni hayragey gar alaahara nda alaafiya. Žeenayyan henna banda ga, nʼga suturandi. ");
INSERT INTO ses_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Ni hayroo si yee kate ne ra kala hala alwadda taaci banda ga, zama waatoo din no Amor borey layboo mana too jina ya ne nongu kaŋ ga a si bisa.» ");
INSERT INTO ses_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Waatoo kaŋ waynaa kaŋ, kubaa beeri, de alforon foo ga dullu, nuune ga fatta a ra ka koy huru alman foorantey game. ");
INSERT INTO ses_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Hanoo din, Abadantaa na amaana daŋ nga nda Ibirim game. A nee a se: «Ay na gandaa woo noo ni hayroo se. Mʼa dii za Misira isaa ga hala Efrat isa beeroo, ");
INSERT INTO ses_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","gandaa woo manʼti kala Keni borey, nda Kenaz borey, nda Kadumone borey, ");
INSERT INTO ses_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","nda Heti borey, nda Ferezi borey, nda Refa borey, ");
INSERT INTO ses_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","nda Amor borey, nda Kanaŋ borey, nda Girgaši borey, nda Žebus borey gandaa.» ");
INSERT INTO ses_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Saray kaŋ ti Ibirim wandoo, mana duu a se ize. Saray goo nda koŋŋa foo kaŋ Misira boro no, maaɲoo ti Hažatta. ");
INSERT INTO ses_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Saray nee Ibirim se: «Sohõ kaŋ Abadantaa nʼay ganji ya duu ize, marga nda ay koŋŋaa. A ga hin ka tee a ma duu ya ne izʼaru.» Ibirim yadda Saray hoyraa. ");
INSERT INTO ses_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Saray kaŋ ti Ibirim wandoo, na nga koŋŋaa Hažatta, Misira boraa, zaa kʼa noo nga kurɲoo Ibirim se a ma marga nda a. Woo kaa ka gar kaŋ Ibirim goo nda goray jiiri woy (10) gandaa ra kaŋ se i ga nee Kanaŋ. ");
INSERT INTO ses_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","A marga nda Hažatta. A tee alhaamidu. Kaŋ a maate kaŋ nga ga tee boro hinka kul, a šintin ka donda nga koyoo Saray. ");
INSERT INTO ses_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Woo se Saray nee Ibirim se: «Ay kaynandiyanoo ga kaŋ ni boŋ. Agay kʼay koŋŋaa daŋ ni kaboo ra, amma za a maate kaŋ nga ga tee alhaamidu a mma donda agay. Yala Abadantaa ma ciiti agay nda ni game.» ");
INSERT INTO ses_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ibirim na Saray zaabi ka nee: «Ni koŋŋaa ne, a goo ni kaboo ra, haya tee a se kaŋ kan ma ne.» Saray na Hažatta gurzugay hala nongu kaŋ ra a zuru a ga. ");
INSERT INTO ses_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Abadantaa almalayka foo nʼa gar saajoo ra hari foo jesoo ga kaŋ goo fondaa here kaŋ ga koy saajoo ra kaŋ maaɲoo ti Šur. ");
INSERT INTO ses_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","A nʼa hãa ka nee: «Hažatta, Saray koŋŋaa, man ra ni hun, man ra nʼga koy?» A nʼa zaabi ka nee: «Ay koyoo Saray se ay goo ma zuru.» ");
INSERT INTO ses_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Almalaykaa nee a se: «Yee ni koyoo do, ma ni boŋ yeeti a se ganda.» ");
INSERT INTO ses_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","A nee a se: «Ay ga ni hayroo boobandi nda takaa kaŋ nda a si hin ka kabandi nga booboyanoo se.» ");
INSERT INTO ses_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Abadantaa almalaykaa nee a se koyne: «Ni tee alhaamidu, nʼga izʼaru foo daŋ aduɲɲa ra kaŋ nʼga maaɲoo daŋ Isimayel (maanaa ‹Irkoy ga maa›), zama Abadantaa maa ni binekankamyanoo. ");
INSERT INTO ses_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ni izʼaroo ga tee sanda ganjifarka. A ga kay ka borey kul wongu, borey kul ga kay kʼa wongu. Amma a ga goro jere ga nga armey se ka huna nga hinne.» ");
INSERT INTO ses_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Abadantaa kaŋ šelaŋ Hažatta se, Hažatta na maaɲoo daŋ «ni ti El-Roy» (maanaa «ni ti Koyoo kaŋ ga dii agay»), zama a nee nga boŋ se: «Cimi da no kaŋ ay dii ne ra woo kaŋ dii agay!» ");
INSERT INTO ses_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Woo se i na dayoo kaŋ goo Kadeš nda Bered gamoo ra maaɲoo daŋ Ber-Lahay-Roy (maanaa «Hundikoynoo kaŋ ga dii agay dayoo»). ");
INSERT INTO ses_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hažatta duu izʼaru foo Ibirim se. Ibirim na izʼaroo kaŋ Hažatta duu a a se, maaɲoo daŋ Isimayel. ");
INSERT INTO ses_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ibirim sii nda kala jiiri woyyaaha cindi iddu (86) waatoo kaŋ Hažatta duu a se Isimayel. ");
INSERT INTO ses_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Waatoo kaŋ Ibirim duu jiiri woyyagga cindi yagga (99), Abadantaa bangay Ibirim se, a nee a se: «Agay ti Irkoy, Hini-kul-koyoo. Ma dira ay fondaa ra, ma henan. ");
INSERT INTO ses_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ay ga ni noo agay amaanaa. Ay ga hanse ka ni hayyanoo boobandi.» ");
INSERT INTO ses_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ibirim sujudu, de Irkoy šelaŋ a se ka nee: ");
INSERT INTO ses_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«Agay, agay amaanaa ne kaŋ ay gʼa noo ma ne: nʼga tee dumi boobo se hayraa. ");
INSERT INTO ses_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Nʼsi yee ka ciyandi nda Ibirim (maanaa «baaba kaŋ jerandi»), ni maaɲoo ga tee Ibirahima (maanaa «boro boobo baaba»), zama ay na ni tee dumi boobo hayraa. ");
INSERT INTO ses_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ay ga ni noo hayyan boobo-boobo. Ay ga ni tee dumiyaŋ, de mo kokoyyaŋ ga hun ni ga. ");
INSERT INTO ses_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Agay amaanaa ga cindi agay nda ni game, nda ni hayroo kaŋ goo ni dumaa ga, alwaddawey kul ra. A ga tee amaana kaŋ si tun hala ya tee ni nda ni hayroo kaŋ ga kaa ni dumaa ga kul se Koy. ");
INSERT INTO ses_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ay ga ni noo, ni nda ni hayroo kaŋ ga kaa ni dumaa ga, gandaa kaŋ ra ni ne ka koy goro. Kanaŋ gandaa kul nʼgʼa mayray hala abada. Ay ga tee ni hayroo Koyoo.» ");
INSERT INTO ses_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Irkoy nee Ibirahima se: «Ni, ma agay amaanaa dii, ni nda ni hayroo kaŋ ga kaa ni dumaa ga, alwaddawey kul ra. ");
INSERT INTO ses_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Agay amaanaa ne kaŋ ni nda ni hayroo kaŋ ga kaa ni dumaa ga, gʼa kayandi: aru kul kaŋ goo war ra ga hima ka hurubangu. ");
INSERT INTO ses_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","War hurubanguyanoo ga tee agay nda war game amaanaa tammaasaa. ");
INSERT INTO ses_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Alwadda ka kaa alwadda, zankaaru kul ga hima ka hurubangu nga jirbi yaahantoo hane. A ma teendi baɲɲa kul se kaŋ hayandi ni hugoo ra. A ma teendi baɲɲa kul kaŋ nʼnʼa day nda nooru kaŋ manʼti ni alkabiilaa. ");
INSERT INTO ses_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Baɲɲa kaŋ hayandi ni hugoo ra nda boraa kaŋ ni nkʼa day nda ni nooroo, i kul ma hurubangu. Agay amaanaa ma tee war hamey ra amaana kaŋ si tun. ");
INSERT INTO ses_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Aru jofolo kaŋ nga toošidogoo mee kuuroo mana dunbu, boraa ga hun nga jamaa ra, zama a na agay amaanaa hoo.» ");
INSERT INTO ses_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Irkoy nee koyne Ibirahima se: «Saray, ni wandoo, masi yee kʼa cee nda Saray, hõ banda ga, maaɲoo ga tee Sarata (maanaa «boŋkoyni woy»). ");
INSERT INTO ses_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ay ga albarka daŋ a ra, de ay ga ni noo nga mo ga izʼaru foo. Albarka ga huru a ra, de a ga tee dumi boobo se kaaga woy. Dumi boobo kokoyyaŋ si hun kala nga ga.» ");
INSERT INTO ses_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ibirahima sujudu, a haaru, de a nee nga boŋ se: «Taka foo nda aru kaŋ goo nda jiiri zangu (100) ga ize daŋ aduɲɲa ra? De Sarata kaŋ goo nda jiiri woyyagga (90), taka foo nda a ga ize daŋ aduɲɲa ra?» ");
INSERT INTO ses_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Woo banda ga, Ibirahima nee Irkoy se: «Yala ma Isimayel noo aloomur!» ");
INSERT INTO ses_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Amma Irkoy nʼa zaabi ka nee: «Šikka sii kaŋ ni wandoo Sarata ga duu ma ne izʼaru foo, de nʼga maaɲoo daŋ Isiyaka (maanaa «haaruyan»). Ay gʼa noo agay amaanaa, sanda amaana kaŋ si tun nga hayroo kaŋ goo dumaa ga se. ");
INSERT INTO ses_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Isimayel here, hayaa kaŋ nʼnʼa ŋaaray, ay nʼa yakubar: ay ga albarka daŋ a ra. Ay gʼa noo hayyan, ay gʼa noo hayyan boobo. A ga boŋkoyni woy cindi hinka (12) hay, de ay gʼa tee hayraa dumi beeri se. ");
INSERT INTO ses_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Amma agay amaanaa Isiyaka ga, a ga tabati kaŋ Sarata ga duu a ma ne yeeši alwaatoo woo da cine ga.» ");
INSERT INTO ses_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Kaŋ a šelaŋ ka ben a bande, Irkoy žigi Ibirahima se beene. ");
INSERT INTO ses_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ibirahima na nga izoo Isimayel dii, nda baɲɲey kul kaŋ hayandi nga hugoo ra, nda arey kul kaŋ a nʼi day nda nga nooroo, nda arey kul kaŋ goo nga hugoo ra, a nʼi kul daŋbangu zaari follokaa din da ra nda takaa kaŋ nda Irkoy nʼa har a se. ");
INSERT INTO ses_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ibirahima sii nda kala jiiri woyyagga cindi yagga (99) waatoo kaŋ a ga hurubangu. ");
INSERT INTO ses_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Nga izoo Isimayel sii nda kala jiiri woy cindi hinza (13) waatoo kaŋ a ga hurubangu. ");
INSERT INTO ses_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Zaari follokaa ra Ibirahima nda nga izoo Isimayel kul hurubangu. ");
INSERT INTO ses_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Nga hugoo arey kul, nda baɲɲey kaŋ hayandi a do, nda wey kaŋ manʼti nga alkabiilaa kaŋ a nʼi day nda nga nooroo, i kul huru a bande bangu. ");
INSERT INTO ses_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Abadantaa bangay Ibirahima se tuuriɲaa beerey jeroo ga kaŋ ti Mamre wane. Ibirahima goo ma goro nga hukkumoo miɲoo ga zaarikayaa ra. ");
INSERT INTO ses_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","A na nga boŋoo jer, de a dii aru hinza kaŋ si mooru a ga, goo ma kay. Za a dii ey, kul a zuru ka hun nga hukkumoo miɲoo ga kʼi kubay, a gunguma i se hala ganda. ");
INSERT INTO ses_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","A nee ngi affoo se: «Ay koyoo, ay gʼa wiri ni ga, alhormo tee ya ne, masi bisa ka mooru ni tamoo ga, mana kay a do. ");
INSERT INTO ses_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Naŋ i ma kate hari kayna, war ma war cewey ɲumay, de war ma hunanzam tuuroo cire. ");
INSERT INTO ses_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ay ga kate war se ŋaayan kayna hala war ma duu gaabi, nga banda ga, war ma koy war diraa ra, zama woo se ay na war zumandi agay do kaŋ ti war tamoo.» Yawey nʼa zaabi ka nee: «A boori, haya tee kaŋ nʼnʼa har.» ");
INSERT INTO ses_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ibirahima zuru ka koy nga hukkumoo do ka Sarata gar, a nee: «Cahã! Ma farin hamni mudu hinza zaa, mʼa loobu, mʼa tee wijila.» ");
INSERT INTO ses_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Woo banda ga, Ibirahima zuru ka koy nga almaney do, a na haw-ize foo dii kaŋ hamoo ga ban, a ga naasu. A nʼa noo zankaaru foo se kaŋ nʼa hanse nda cahãyan. ");
INSERT INTO ses_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ibirahima yee ka waahoonu nda waa gani zaa, nda haw-izoo hamoo kaŋ hansandi, a nʼi daŋ nga yawey jine. Ibirahima ga kay jere ga waatoo kaŋ i ga ŋaa tuuroo cire. ");
INSERT INTO ses_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","I nee a se: «Man Sarata, ni wandoo?» A zaabi ka nee: «A goo no, hukkumoo cire.» ");
INSERT INTO ses_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Yawey affoo nee: «Šikka sii kaŋ ay ga yee kate yeeši dimmaa woo da ga, Sarata ni wandoo ga duu izʼaru.» Sarata goo dumaa ga hukkumoo miɲoo ga, a ga haŋajer. ");
INSERT INTO ses_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ibirahima nda Sarata žen, ngi jiirey boobo, de mo Sarata hun hayyan. ");
INSERT INTO ses_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sarata haaru nga binoo ra ka nee: «Sohõ kaŋ ay žen, man ra ay ga duu alhawa? Ay koyoo mo manʼti kala aru žeena.» ");
INSERT INTO ses_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Abadantaa na Ibirahima hãa ka nee: «Macin se Sarata ga haaru ka nee: ‹Taka foo! Cimi da no kaŋ ay ga hin ka duu ize, agay kaŋ žen?› ");
INSERT INTO ses_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Haya goo no kaŋ ga mongu Abadantaa se wala? Alwaatoo kaŋ ay nʼa kayandi, yeeši dimmaa woo ga, ay ga yee kate ni do, Sarata ga duu izʼaru.» ");
INSERT INTO ses_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sarata na šennoo yankar ka nee: «Ya na haaru.» Hunburay ka kate a mʼa har. Abadantaa nʼa zaabi ka nee: «Ni haaru kay.» ");
INSERT INTO ses_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Woo banda ga, yawey na fondaa sanbu. Koyraa kaŋ se i ga nee Sodom, nga no i nʼa tenje ka koy. Ibirahima hanga ey kʼi dum. ");
INSERT INTO ses_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Abadantaa nee nga boŋ se: «Ay ga haya tugu Ibirahima se kaŋ ay gʼa tee wala? ");
INSERT INTO ses_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Šikka sii kaŋ Ibirahima ga tee dumi beeri gaabante. Nga ra, aduɲɲa gandawey kul ga duu albarka. ");
INSERT INTO ses_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ya nkʼa suuba hala a ma nga izey nda nga hugoo borey kaŋ goo dumaa ga yaamar i ma Abadantaa fondaa gana ka goy nda šerretaray nda cimi. Woo ra Abadantaa ga Ibirahima noo hayaa kaŋ a bay kʼa har a se.» ");
INSERT INTO ses_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Woo banda ga, Abadantaa nee Ibirahima se: «Hayey kaŋ borey gʼi har Sodom nda Gomor ga hanse ka boobo, ngi zunubey hanse ka laala ");
INSERT INTO ses_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","hala nongu kaŋ ra ay ga zunbu ka dii wala hayey kaŋ ay ga maarʼey da no i gʼi tee. Nda cimi no wala manʼti cimi no, ay ga bay.» ");
INSERT INTO ses_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Arey hun no din ka koy Sodom. Amma Ibirahima cindi a ga kay Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ibirahima man kate, de a nee: «Adiši nʼga išerrante halaci ifutu bande wala? ");
INSERT INTO ses_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","A ga hin ka tee boro šerrante woyguu (50) goo koyraa ra: adiši nʼga ngi mo halaci? Nʼsi yaafa koyraa se boro woyguu (50) šerrantaa kaŋ goo a ra maaganda se? ");
INSERT INTO ses_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Woo manʼti ni goyoo: ka boro šerrantey halaci ifutawey bande taka kaŋ ra išerrantey nda ifutawey kul ma tee afolloku. Woo manʼti ni goyoo! Ni kaŋ ga aduɲɲa kul ciiti, manʼti cimi nda nʼga ciiti wala?» ");
INSERT INTO ses_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Abadantaa zaabi ka nee: «Nda ay na boro woyguu (50) šerrante gar Sodom ra, ngi maaganda se ay ga koyraa kul yaafa.» ");
INSERT INTO ses_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ibirahima nee koyne: «Ay yadda ka šelaŋ ay Koyoo se, agay kaŋ manʼti kala labu nda boosu yaada. ");
INSERT INTO ses_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","A ga hin ka tee boro woyguu (50) šerrantey din boro guu mʼi kuma. Boro guu se nʼga koyraa kul halaci wala?» A nee: «Nda ay na boro woytaaci cindi guu (45) gar no din, ay si koyraa halaci.» ");
INSERT INTO ses_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ibirahima šelaŋ koyne ka nee: «A ga hin ka tee boro woytaaci (40) bara no?» A nʼa zaabi ka nee: «Boro woytaacaa (40) maaganda se ay sʼa tee.» ");
INSERT INTO ses_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ibirahima nee koyne: «Yala ay Koyoo masi futu, ay ga šelaŋ koyne. A ga hin ka tee boro waranza (30) šerrante bara no din?» A nee: «Nda ay na boro waranza (30) gar no din, ay si haya kul tee koyraa se.» ");
INSERT INTO ses_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ibirahima nee: «Ay duu bine ka šelaŋ ay Koyoo se. A ga hin ka tee boro waranka (20) bara no din.» A nʼa zaabi ka nee: «Ay sʼa halaci boro warankaa (20) maaganda se.» ");
INSERT INTO ses_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ibirahima nee koyne: «Yala ay Koyoo masi futu, ay cee kokorantaa ti woo kaŋ ay ga šelaŋ. A ga hin ka tee boro woy (10) goo no din.» A nʼa zaabi ka nee: «Ay sʼa halaci boro woyaa (10) maaganda se.» ");
INSERT INTO ses_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Waatoo kaŋ Abadantaa šelaŋ ka ben Ibirahima bande, a koy, Ibirahima mo yee nga do. ");
INSERT INTO ses_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Almaaroo ra, almalayka hinkaa too Sodom. A gar kaŋ Lotu goo ma goro koyraa miɲoo ga. Kaŋ Lotu dii ey kul, a koy i kubay ka nga ndumoo gunguma ganda. ");
INSERT INTO ses_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","A nee i se: «Ay gʼa wiri war ga, ay koyey, war ma kaa ka kani war tamoo hugoo ra, war ma war cewey ɲumay, nga banda ga, war ma biya ka tun ka war fondaa zaa.» I nʼa zaabi ka nee: «Kalaa, kalaa! Ir ga kani farroo ra.» ");
INSERT INTO ses_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Amma Lotu nʼi gaabi hala i yadda ka koy nga do. A hina i se, a na takulayaŋ tee bila dolobiri, i ŋaa. ");
INSERT INTO ses_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","I mana kani jina kaŋ Sodom arey kaa ka hugoo kuubi kʼa bere, zankey nda boro beerey, koyraa arey kul. ");
INSERT INTO ses_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","I na Lotu cee ka nee a se: «Man arey kaŋ huru ni do hõ cijinoo? I fattandi hala ir ma kani nda ey!» ");
INSERT INTO ses_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lotu fatta i do hugoo miɲoo ga jina, a na ganboo daabu, ");
INSERT INTO ses_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","de a nee i se: «Agʼarmey, ay gʼa wiri war ga, war masi haya futu kul tee! ");
INSERT INTO ses_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Wa maa ya ne! Ay goo nda ize woy hinka kaŋ mana bay ka marga nda aru, ay ga kate ey war se, war ma haya tee i se kaŋ war baa, amma arey wey, war masi haya kul tee i se, zama agay do i zunbu!» ");
INSERT INTO ses_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","I nʼa zaabi ka nee: «Koy ka tun no!» I nee a se koyne: «Ni cee-ka-dirakaw, sohõ fondaa no nʼga baa mʼa cebe ir se! A boori, sohõ ir ga haya tee ma ne kaŋ ga bisa woo kaŋ ir ga kaa kʼa tee i se.» Woo banda ga, i na Lotu tuti nda gaabi ka koy ganboo wurje. ");
INSERT INTO ses_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Amma almalayka hinkaa na Lotu dii kʼa daŋ ngi bande hugoo ra, de i na hugoo miɲoo daabu ngi ga. ");
INSERT INTO ses_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","I na danawtaray ka arey kar kaŋ goo hugoo miɲoo ga, mʼa dii za zankey hala ibeerey, i na hugoo miɲoo ceeci hala i fara. ");
INSERT INTO ses_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Arey nee Lotu se: «May ti ni boro kaŋ goo ne koyne? A ma tee ni nzuraa, ni izʼarey, ni ize woyey nda haya kul kaŋ ti ni wane kaŋ goo koyraa woo ra, mʼa ka fatta ne ra, ");
INSERT INTO ses_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","zama ir ga nongoo woo halaci. Haya kaŋ se, goy laaley kaŋ ga harandi a ga hanse ka boobo Abadantaa do. Abadantaa nkʼir sanba ir mʼa halaci.» ");
INSERT INTO ses_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lotu fatta ka koy arey kaŋ na nga ize woyey cewey dii kaŋ ti nga nzurawey do ka nee i se: «Wa tun ka hun ne, zama Abadantaa ga koyraa halaci!» Amma nga nzurawey do a mma hooray. ");
INSERT INTO ses_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Za subbaahi biya, nga no almalaykey na Lotu gaabi ka nee a se: «Tun, ma ni wandoo nda ni ize woy hinkaa kaŋ goo ne ka koy hala koyraa zunuboo kaŋ ga zunbu a boŋ masi ni halaci!» ");
INSERT INTO ses_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Amma Lotu gay hala a ga koy. Aru hinkaa nʼa dii nda kaboo, nga nda nga wandoo nda nga ize woy hinkaa, zama Abadantaa ga baa nga mʼa hallasi. I nʼa ka fatta, de i nʼa naŋ koyraa dumaa ga. ");
INSERT INTO ses_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Kaŋ i nʼi fattandi ka ben aru hinkaa affoo nee Lotu se: «Zuru ka ni hundoo ceeci! Masi ɲeli ni dumaa ga, de mo masi kay laamaa kul ra! Zuru ka koy tondi hondoo here nda nʼsi baa ma halaci!» ");
INSERT INTO ses_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lotu nʼi zaabi ka nee: «Kalaa, ay koyoo! ");
INSERT INTO ses_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Nʼna alhormo tee ni tamoo se, ni boori a se ka hundoo hallasi. Agay ya, ay si hin ka zuru ka too hala tondi hondoo do, ay ga hunbur bonaa woo ma zunbu ay boŋ, ya buu. ");
INSERT INTO ses_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Nʼga dii koyraa kaccaa woo? A ga hanse ka man, ay ga hin ka zuru ka too no din. Naŋ, ay ma zuru ka koy lafa no din. A ga kacca, de ay hundoo ga hallasi.» ");
INSERT INTO ses_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","A nʼa zaabi ka nee: «Ay na woo mo tee ma ne, koyraa kaŋ ga ni goo, ay sʼa halaci. ");
INSERT INTO ses_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Zuru ka koy no din, zama ay si hin ka haya kul tee nda mana too no din jina!» Woo se i na koyraa din maaɲoo daŋ Sohar (maanaa «ikaccaa»). ");
INSERT INTO ses_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Waynaa mma fatta kaŋ Lotu ga huru Sohar. ");
INSERT INTO ses_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Abadantaa na ganjibaali nda nuune tee ncirɲi kʼa zumandi Sodom nda Gomor boŋ. Hayaa woo mana hun kala Abadantaa do beenaa ra. ");
INSERT INTO ses_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","A na koyrawey wey, nda laamaa, nda borey kaŋ goo i ra, nda suboo kul halaci. ");
INSERT INTO ses_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Lotu wandoo ɲeli nga dumaa ga, kul a bere ka tee ciiri boro assuura. ");
INSERT INTO ses_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ibirahima biya ka tun ka koy nongoo kaŋ ra a cindi ka kay Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","A na Sodom, nda Gomor, nda laamaa gandaa kul honnay, de a ga dii dullu beeri kaŋ ga tun gandaa boŋ kaŋ ga hima nda alforon dullu. ");
INSERT INTO ses_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Waatoo kaŋ Irkoy ga laamaa koyrawey halaci, a hongu Ibirahima, a na Lotu hallasi balaawoo ra kaŋ a nʼa kaŋandi koyrawey boŋ kaŋ ra Lotu cindi nda goray. ");
INSERT INTO ses_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lotu hun Sohar ka žigi ka koy goro tondi hondoo boŋ, nga nda nga ize woy hinkaa, zama a mma hunbur Sohar goraa. Nga nda nga ize woyey cindi ka goro tondi guusu foo ra. ");
INSERT INTO ses_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ize woy beeroo nee ikaccaa se: «Ir baabaa žen, aru sii gandaa ra kaŋ ga marga nda ir sanda borey kul takaa. ");
INSERT INTO ses_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Kaa, ir mʼir baabaa haŋandi alaneb hari moora, de ir ma kani nda a hala ir ma duu a se hayyan!» ");
INSERT INTO ses_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Cijinoo din da ra, i na ngi baabaa haŋandi alaneb hari moora. Ize woy beeroo koy marga nda a, amma Lotu mana bay nga izoo kaniyanoo nda tunyanoo kul ga. ");
INSERT INTO ses_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Subaa ra, ize woy beeroo nee ikaccaa se: «Cijin agay ka marga nda baaba, ir mʼa haŋandi koyne alaneb hari moora hõ cijinoo, de ma koy kani a bande hala ir ma duu a se hayyan.» ");
INSERT INTO ses_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Cijinoo din ra koyne, i na ngi baabaa haŋandi alaneb hari moora. Ize woy kaccaa koy marga nda a, amma Lotu mana bay nga izoo kaniyanoo nda tunyanoo kul ga. ");
INSERT INTO ses_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Lotu ize woy hinkaa kul tee ngi baabaa se alhaamidu. ");
INSERT INTO ses_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ize woy beeroo duu izʼaru foo kaŋ a na maaɲoo daŋ Mowab: nga ti Mowab borey kaŋ ga bara ba hõ, hayragoo. ");
INSERT INTO ses_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ize woy kaccaa mo duu izʼaru foo kaŋ a na maaɲoo daŋ Ben-Ammi: nga ti Amoŋ borey kaŋ ga bara ba hõ, hayragoo. ");
INSERT INTO ses_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ibirahima gana ka hun nongoo kaŋ ra a goo ka koy goro Negew gandaa ra. A mana goro kala Kadeš nda Šur gamoo ra. Nga banda ga, a goro ka waati tee koyra kaŋ se i ga nee Gerar. ");
INSERT INTO ses_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ibirahima mma nee borey se kaŋ Sarata manʼti kala nga woymaa. Gerar kokoyoo kaŋ ti Abimelek na Sarata zaa. ");
INSERT INTO ses_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Cijinoo ra, Irkoy kaa handiri ra Abimelek do, de a nee a se: «Nʼga buu woyoo woo kaŋ nʼnʼa taa maaganda se, zama wande waani no.» ");
INSERT INTO ses_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Woo kaa ka gar kaŋ Abimelek mana too woyoo do. A nee: «Ay Koyoo! Adiši nʼga dumi šerrante mo wii wala? ");
INSERT INTO ses_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Manʼti nga hunday ka nee ya ne kaŋ nga woymaa no? Woyoo mo nee ya ne kaŋ nga armaa no. Kaŋ ay ga woo tee ay binoo ga kaaray, ay kabey ga henan.» ");
INSERT INTO ses_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Handiroo ra Irkoy tuuru a se ka nee: «Ay ga bay bine kaaray nda ni goy. Agay no ka ni ganji ma kaŋ zunubu ra ay jine, woo se ay mana naŋ ma too a do. ");
INSERT INTO ses_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Sohõ aroo woo wandoo yeeti a ga, zama annabi no, a ga Irkoy ŋaaray ma ne, de ni hundoo ga cindi ni ra. Amma nda manʼa yeeti, ma bay kaŋ ni nda ni jamaa kul ga buu!» ");
INSERT INTO ses_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimelek biya ka tun, a ciya nga tamey kul se ka hayey wey kul filla i se. I hanse ka hunbur. ");
INSERT INTO ses_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abimelek ciya Ibirahima se, a nee a se: «Cin ti woo kaŋ nʼnʼa tee ir se? Cin ti haya futaa kaŋ ay nʼa tee ma ne kaŋ se nʼga agay nda ay laamaa daŋ zunubu beeroo woo jine? Nʼna hayaa tee ya ne kaŋ si teendi.» ");
INSERT INTO ses_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimelek nee Ibirahima se koyne: «Macin bara ni do kaŋ se nʼna woo tee?» ");
INSERT INTO ses_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ibirahima nʼa zaabi ka nee: «Ya nka nee ay boŋ se: ‹Irkoy hunburay sii nongoo woo ra, i gʼay wii ay wandoo maaganda se.› ");
INSERT INTO ses_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Koyne mo nda cimi, ay woymaa no. Ay baabaa ize woyoo no, amma ir manʼti ɲaa foo, woo se a tee ya ne wande. ");
INSERT INTO ses_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Waatoo kaŋ Irkoy nʼay ka fatta kʼay moorandi ay baabaa hugoo, ay nee Sarata se: ‹Borohennataray tee ya ne, nongu kul kaŋ ra ir koy ma nee kaŋ ni armaa ti agay.›» ");
INSERT INTO ses_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abimelek na alman buuna nda ibeeri, nda baɲɲayaŋ, nda koŋŋayaŋ zaa kʼi noo Ibirahima se. A na nga wandoo Sarata mo yeeti a se. ");
INSERT INTO ses_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Woo banda ga, Abimelek nee a se: «Ay gandaa ne ni jine, goro nongu ra kaŋ kan ma ne.» ");
INSERT INTO ses_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","De a nee Sarata se: «Nga ne, ay na ni armaa noo nzorfu kaaray tamma boŋ zenber foo (1.000). Woo ti tammaasaa kaŋ ga cebe borey kul kaŋ goo ni bande se kaŋ nʼga henan hayaa woo kaŋ tee ra.» ");
INSERT INTO ses_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Ibirahima na Irkoy ŋaaray, de Irkoy na Abimelek nda nga wandoo, nda nga koŋŋey noo baani, de i duu ka hin ka ize daŋ aduɲɲa ra. ");
INSERT INTO ses_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Haya kaŋ se Abadantaa nka Abimelek hugu kul tee boro gunyaŋ, Ibirahima wandoo kaŋ ti Sarata maaganda se. ");
INSERT INTO ses_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Abadantaa mana dirɲa Sarata, sanda takaa kaŋ nda a nʼa har, a nʼa noo hayaa kaŋ a bay ka nee nga gʼa tee a se. ");
INSERT INTO ses_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sarata tee boro hinka, alwaatoo hunday kaŋ Irkoy nʼa kayandi ga, Ibirahima žeenayyanoo ra, a duu a se izʼaru. ");
INSERT INTO ses_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Izʼaroo kaŋ Sarata duu a a se, Ibirahima na maaɲoo daŋ Isiyaka (maanaa «haaruyan»). ");
INSERT INTO ses_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ibirahima na Isiyaka daŋbangu nga jirbi yaahantoo hane sanda takaa kaŋ nda Irkoy nʼa yaamar. ");
INSERT INTO ses_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Jiiri zangu (100) bara Ibirahima se waatoo kaŋ nga izoo Isiyaka ga huru aduɲɲa ra. ");
INSERT INTO ses_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sarata nee: «Irkoy nʼay ɲaalandi kʼay haarandi, boro kul kaŋ maarʼa mo ga haaru ay bande.» ");
INSERT INTO ses_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","A nee koyne: «May no ma yadda ka nee Ibirahima se kaŋ Sarata ga kaa ka naanandi! Nga ne, nga žeenayyanoo ra ay duu a se izʼaru.» ");
INSERT INTO ses_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Zankaaroo beeri, a hun fafa. Hanoo kaŋ Isiyaka ga hun fafa, Ibirahima na hoyandi beeri tee. ");
INSERT INTO ses_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Sarata dii izʼaroo kaŋ Hažatta, Misira woyoo duu a, Ibirahima se, goo ma hooray. ");
INSERT INTO ses_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","A nee Ibirahima se: «Koŋŋaa woo nda nga izʼaroo gaaray, zama koŋŋaa woo izʼaroo nda ay wanoo kaŋ ti Isiyaka si tubu cere bande.» ");
INSERT INTO ses_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Šennoo woo hanse ka Ibirahima dor nga izoo Isimayel maaganda se. ");
INSERT INTO ses_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Amma Irkoy nee Ibirahima se: «Masi dor zankaa nda ni koŋŋaa se. Haya kul kaŋ Sarata nʼa har ma ne, ma yadda a se, zama Isiyaka no ma duu ma ne hayyan kaŋ ra ni maaɲoo si dere. ");
INSERT INTO ses_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Amma koŋŋaa woo mo izʼaroo, ay gʼa tee dumi beeri, zama ni hayroo no.» ");
INSERT INTO ses_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ibirahima biya ka tun, a na ŋaayan zaa kʼa noo Hažatta se nda hunbar kaŋ ra hari goo kaŋ a nʼa fur jesoo ga. A na zankaa mo noo a se, de a nʼa naŋ a ma koy. A koy, de a dere Ber-Šeba saajoo ra. ");
INSERT INTO ses_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Waatoo kaŋ hunbaroo haroo ben, a na zankaa fur tuuri kaccu foo cire. ");
INSERT INTO ses_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","A koy goro kʼa tenje, a goo a se haya kaŋ ga koy too kabedaaru zangu hinka (200) cine, zama a nee nga boŋ se: «Ay si baa ya dii zankaa buuyanoo!» Hažatta goro kʼa tenje ka hẽe, a na nga jindoo jer ka hẽe. ");
INSERT INTO ses_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Irkoy maa zankaa jindoo. Irkoy almalayka foo ciya Hažatta se za beenaa ra ka nee a se: «Macin ka duu ni, Hažatta? Masi hunbur, zama Irkoy maa zankaa jindoo, nongoo kaŋ ra a goo. ");
INSERT INTO ses_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Tun ni boŋ ga! Ma yee ka zankaa zaa, mʼa dii ni kaboo ra, zama ay gʼa tee dumi beeri!» ");
INSERT INTO ses_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Irkoy na Hažatta moɲey feeri, de a na day foo honnay, a koy nga hunbaroo too hari a ra ka nga izoo haŋandi. ");
INSERT INTO ses_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Irkoy goo zankaaroo bande, a beeri, a cindi saajoo ra, a tee birawkarkaw. ");
INSERT INTO ses_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","A cindi Paraŋ saajoo ra, ɲaŋoo nʼa hiijandi Misira gandaa woy foo. ");
INSERT INTO ses_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Zaman follokaa din ra, Abimelek nda nga wongu-izey jineboraa kaŋ ti Pikol kaa Ibirahima do ka nee a se: «Irkoy goo ni bande hayey kul kaŋ nʼgʼi tee ra. ");
INSERT INTO ses_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Sohõ žee ya ne, ne ra, nda Irkoy, kaŋ nʼsʼay zanba, nʼsʼay izey nda ay haamawey zanba. Takaa kaŋ nda ay na alhormo tee ma ne, takaa din da nda mʼa tee agay nda gandaa se kaŋ ra ni kaa ka goro ka waati tee!» ");
INSERT INTO ses_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ibirahima nʼa zaabi ka nee: «Ay gʼa žee ma ne.» ");
INSERT INTO ses_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","A na dayoo šennoo tee Abimelek se kaŋ nga tamey nʼa mayray nda gaabi. ");
INSERT INTO ses_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelek nʼa zaabi ka nee: «Ay si boraa bay kaŋ na woo tee, ni mo mana bay ka alhabar daŋ ay ra. Ya na bay ka maarʼa nda manʼti hõ.» ");
INSERT INTO ses_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ibirahima na alman buuna nda ibeeri zaa kʼi noo Abimelek se. I na cere noo amaana. ");
INSERT INTO ses_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ibirahima na feeji woy-ize kaccu boŋ iyye zaa nga boŋ alman buuney ra kʼi daŋ jere ga. ");
INSERT INTO ses_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelek nee Ibirahima se: «Macin ti alman kaccu iyyaa woo kaŋ nʼnʼi daŋ jeraa ga addaliloo?» ");
INSERT INTO ses_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","A nʼa zaabi ka nee: «Yadda ka feeji woy-ize kaccu boŋ iyyaa woo taa ay kaboo ra hala i ma tee seedetaray kaŋ agay ka dayoo woo fanši.» ");
INSERT INTO ses_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Woo se i na nongoo din maaɲoo daŋ Ber-Šeba (maanaa «žeeyanoo dayoo»), zama no din ra i žee cere se. ");
INSERT INTO ses_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","I na cere noo amaana Ber-Šeba. Woo banda ga, Abimelek tun, nga nda Pikol kaŋ ti nga wongu-izey jineboraa, de i yee Filisti borey gandaa ra. ");
INSERT INTO ses_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ibirahima na tuuri foo kaŋ se i ga nee tamaris duma Ber-Šeba, de a na Abadantaa kaŋ ti Koyoo kaŋ ga bara hala abada maaɲoo cee. ");
INSERT INTO ses_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ibirahima goro ka waati kuku tee Filisti borey gandaa ra. ");
INSERT INTO ses_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Hayey wey banda ga, Irkoy na Ibirahima sii ka dii. A nee a se: «Ibirahima!» Ibirahima nʼa zaabi ka nee: «Agay ne.» ");
INSERT INTO ses_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Irkoy nee a se: «Ni izʼaroo zaa, ni ize bajja follokaa Isiyaka kaŋ nʼga hanse ka bagʼa. Fatta ka koy gandaa ra kaŋ se i ga nee Moriya, no din ra ay ga tondi hondu foo silbay ma ne, tondi hondoo din boŋ mʼa tee ya ne sargari kukurante.» ");
INSERT INTO ses_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ibirahima biya ka tun, a na nga farkaa soolu, a na nga tam hinka nda nga izoo Isiyaka zaa ka koy nga bande. A na tuuri zafa sargari kukurantaa se, de a tun ka koy nongoo kaŋ Irkoy nʼa silbay a se ra. ");
INSERT INTO ses_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Jirbi hinza diray banda ga, Ibirahima na nongoo honnay. ");
INSERT INTO ses_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ibirahima nee nga tamey se: «Wʼay batu ne ra nda farkaa. Agay nda zankaa ga koy beene ka sujudu, nga banda ga, ir ga willi kate war do.» ");
INSERT INTO ses_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ibirahima na sargari kukurantaa tuuroo zaa, a nʼa jeeje nga izoo Isiyaka boŋ. A na nuune diinandihayaa nda huryaa dii nga kaboo ra. Ngi boro hinkaa dira cere bande ka koy. ");
INSERT INTO ses_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isiyaka na šenni fur nga baabaa ga ka nee a se: «Baaba!» A nʼa zaabi ka nee: «Naam, ay izoo.» A nee a se: «Nuune diinandihayaa ne, tuuroo ne, man sargaroo feejoo?» ");
INSERT INTO ses_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ibirahima nʼa zaabi ka nee: «Ay izoo, Irkoy hunday no ma sargaroo feejoo doonandi.» Ngi boro hinkaa dira cere bande ka koy. ");
INSERT INTO ses_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Waatoo kaŋ i too nongoo kaŋ Irkoy nʼa silbay a se ra, Ibirahima na sargari tonadogoo cin. A na tuuroo kanandi a boŋ. A na nga izoo Isiyaka haw kʼa kanandi tuuroo boŋ kaŋ goo sargari tonadogoo boŋ. ");
INSERT INTO ses_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Woo banda ga, Ibirahima deebe ka huryaa zaa hala nga ma nga izoo koosu. ");
INSERT INTO ses_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Amma beenaa ra, Abadantaa almalaykaa ciya a se ka nee: «Ibirahima! Ibirahima!» A nʼa zaabi ka nee: «Agay ne.» ");
INSERT INTO ses_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Almalaykaa nee a se: «Ni kaboo masi ziira zankaa do, de mo masi baffoo tee a se, zama sohõ ay bay kaŋ nʼga hunbur Irkoy, ni ize bajja follokaa, manʼa ka wanji a se!» ");
INSERT INTO ses_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ibirahima na nga boŋoo jer, de a na gaaru foo honnay nga dumaa ga kaŋ hilley kotay tuuri kaccu foo ra. Ibirahima koy gaaroo dii kʼa tee sargari kukurante nga izoo dogoo ra. ");
INSERT INTO ses_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ibirahima na nongoo din maaɲoo daŋ «Abadantaa ga doonandi». Woo se borey ga nee hõ zaaroo: «Abadantaa ga doonandi nga tondi hondoo boŋ.» ");
INSERT INTO ses_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Cee hinkantoo Abadantaa almalaykaa ciya za beenaa ra Ibirahima se, ");
INSERT INTO ses_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ka nee a se: «Ay ga žee nda agay hunday, agay Abadantaa ka šelaŋ ka nee: ‹Zama de ni ne ka woo tee, mana ni ize bajja follokaa wanji ya ne, ");
INSERT INTO ses_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ay ga albarka boobo daŋ ni ra. Ay ga hanse ka ni hayroo boobandi sanda handarawey kaŋ goo beenaa ra wala labutaasi gurunbey kaŋ goo teekoo miɲoo ga. Ni hayroo ga žigi nga iberey boŋ. ");
INSERT INTO ses_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ni hayroo bande aduɲɲa gandawey kul ga duu albarka, zama nʼna haŋajer ya ne.›» ");
INSERT INTO ses_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ibirahima yee nga tamey do. I hanga cere bande ka koy Ber-Šeba, zama no din no Ibirahima goo nda goray. ");
INSERT INTO ses_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Woo banda ga, boroyaŋ kaa ka deede Ibirahima se ka nee: «Milka mo duu izʼaruyaŋ ni armaa Nahor se: ");
INSERT INTO ses_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","nga gunde jinaa ti Utus, Utus armaa ti Buz, nda Kemuwel kaŋ ti Aram baabaa, ");
INSERT INTO ses_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","nda Kesed, nda Hazo, nda Pildaš, nda Yidilaf nda Betuwel.» ");
INSERT INTO ses_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuwel ti Rebeka baabaa. Wey ti izʼaru yaahaa kaŋ Milka duu ey Nahor se kaŋ ti Ibirahima armaa. ");
INSERT INTO ses_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nga wahayoo kaŋ maaɲoo ti Rehuma, mo duu izʼaruyaŋ kaŋyaŋ ti Teba, nda Gaham, nda Tahaš, nda Maaka. ");
INSERT INTO ses_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarata huna jiiri zangu nda waranka cindi iyye (127): woo ti Sarata aloomuroo. ");
INSERT INTO ses_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sarata mana faati kala Kiryat-Arba, maanaa Hebroŋ kaŋ goo gandaa ra kaŋ se i ga nee Kanaŋ. Ibirahima kaa ka goro ka Sarata suturayanoo tee, de mo kʼa hẽe. ");
INSERT INTO ses_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ibirahima tun nga bukaa do ka koy Heti borey here ka šelaŋ i se ka nee: ");
INSERT INTO ses_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","«Ay manʼti kala taabuši, ay manʼti kala bisakaw war gamey ra. Wʼay noo doo yʼa tee saaray hala ay gʼay wandoo sutura.» ");
INSERT INTO ses_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Heti borey na Ibirahima zaabi ka nee: ");
INSERT INTO ses_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«Haŋajer ir se, ir koyoo! Ni manʼti kala boŋkoyni kaŋ Irkoy nʼa daŋ ir gamey ra. Ni bukaa sutura ir saarawey kul ihennaa ra. Boro sii ir ra kaŋ ga ni ganji ma ni bukaa sutura nga saaraa ra.» ");
INSERT INTO ses_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ibirahima man ka gunguma gandaa borey se kaŋ ti Heti borey. ");
INSERT INTO ses_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","A šelaŋ i se ka nee: «Nda war anniyaa no kaŋ war ga baa yʼay bukaa sutura nongoo kaŋ ra ay goo ra, wa yadda ya ne, ka koy hayaa kaŋ ay gʼa wiri ŋaaray Eferoŋ do kaŋ ti Sohar izʼaroo. ");
INSERT INTO ses_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","A ma Makupela tondi guusoo kaŋ ti nga wane yeeti ya ne kaŋ goo nga faaroo miɲoo ga. A mʼa yeeti ya ne, yʼa noo nga hayoo, hala a ma tee ya ne war gamey ra saaray.» ");
INSERT INTO ses_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Eferoŋ goo Heti borey gamey ra. Eferoŋ Heti boraa na Ibirahima zaabi Heti borey nda borey kul kaŋ kaa koyraa miɲoo ga, jiney ra, ka nee: ");
INSERT INTO ses_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","«Kalaa, ay koyoo, yadda ya ne! Ay ga ni noo faaroo yaada, tondi guusoo kaŋ goo a ra mo, ay gʼa noo ma ne yaada. Ay gʼa noo ma ne ay gandaa borey jiney ra. Ni bukaa sutura.» ");
INSERT INTO ses_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ibirahima gunguma gandaa borey se. ");
INSERT INTO ses_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Ganda borey jine a šelaŋ Eferoŋ se ka nee: «Ay gʼa wiri ni ga, maa ya ne. Naŋ ya faaroo hayoo bana. Mʼa taa hala ya hin kʼay bukaa sutura a ra.» ");
INSERT INTO ses_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Eferoŋ na Ibirahima zaabi ka nee: ");
INSERT INTO ses_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«Ay koyoo, agay nda ni game, faari kaŋ nzorfu kaaray tamma boŋ zangu taaci (400) ga duu a, manʼti baffoo! Ni bukaa sutura.» ");
INSERT INTO ses_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ibirahima yadda Eferoŋ šennoo se, de a na tamma nzorfey neeši a se kaŋ a nʼa har Heti borey jiney ra. A na nzorfu tamma boŋ zangu taacaa (400) kaŋ ga sawa nda yooboo barmaa bana a se kaaray. ");
INSERT INTO ses_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Takaa woo nda Eferoŋ faaroo kaŋ goo Makupela kaŋ ga Mamre tenje, faaroo nda tondi guusoo kaŋ goo a ra nda tuuri kul kaŋ goo faaroo nda nga carawey ga, ");
INSERT INTO ses_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","i kul tee Ibirahima halaalaa Heti borey nda borey kul kaŋ kaa koyraa miɲoo ga, jiney ra. ");
INSERT INTO ses_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Woo banda ga, Ibirahima na Sarata, nga wandoo, sutura tondi guusoo kaŋ goo Makupela faaroo ra kaŋ ga Mamre tenje, maanaa Hebroŋ, Kanaŋ gandaa ra. ");
INSERT INTO ses_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Faaroo nda tondi guusoo kaŋ goo a ra hun Heti borey maaɲey ga ka huru Ibirahima maaɲoo ga. Ibirahima nʼa tee bukaw suturadoo. ");
INSERT INTO ses_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ibirahima žen, nga jiirey boobo. Abadantaa na albarka daŋ a ra nongoo kul here. ");
INSERT INTO ses_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ibirahima nee nga tamoo se kaŋ žen nga hugoo tamey kul kaŋ kone nga almanoo kul goo: «Ay gʼa wiri ni ga, ni kaboo daŋ ay ceehamoo cire, ");
INSERT INTO ses_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ay ga ni žeendi nda Abadantaa kaŋ ti beenaa nda laboo Koyoo, hala masi wande zaa ay izoo se Kanaŋ borey ize woyey ra kaŋ gamey ra ay goo ma goro. ");
INSERT INTO ses_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Amma ma koy ay gandaa ra, ay borey do, ma wande zaa ay izoo Isiyaka se.» ");
INSERT INTO ses_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Baɲɲaa nee a se: «A ga hin ka tee woyoo si baa nga ma hanga agay ka kaa gandaa woo ra. Adiši ya ni izoo yeeti ganda kaŋ ra ni hun ra wala?» ");
INSERT INTO ses_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ibirahima nʼa zaabi ka nee: «Hawgay, masʼay izoo yeeti no din! ");
INSERT INTO ses_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Abadantaa kaŋ ti beenaa Koyoo kaŋ nʼay kaa ay baabaa hugoo ra nda ay gandaa ra, nga kaŋ šelaŋ ka žee ya ne kaŋ nga ga gandaa woo noo ay hayroo se, nga hunday ga nga almalaykaa daŋ ni jine. De mo no din ra nʼga wande zaa ay izoo se. ");
INSERT INTO ses_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Nda woyoo wanji ka hanga ni, žeeyanoo hun ni jindoo ga. Hayaa kaŋ ay gʼa har ma ne de ti masʼay izoo yeeti no din.» ");
INSERT INTO ses_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Baɲɲaa na nga kaboo daŋ Ibirahima, nga koyoo ceehamoo cire ka žee a se kaŋ nga ga hayaa tee kaŋ a nʼa har. ");
INSERT INTO ses_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","A na yoo boŋ woy (10) zaa nga koyoo yoowey ra kʼi jeeje nda nga koyoo arzaka henney kʼi ka koy. A tun ka koy hala Mezopotami kaŋ ti Nahor koyraa. ");
INSERT INTO ses_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Kaŋ a too no din, a na yoowey sonbandi koyraa dumaa ga, dayoo jeroo ga, alaasar baanaa ra, dimmaa kaŋ ga woyey ga koy gur. ");
INSERT INTO ses_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Woo banda ga, a nee: «Abadantaa, ay koyoo Ibirahima Koyoo, ay ga ni ŋaaray ma ni alhormaa cebe ay koyoo Ibirahima se kʼay kubayandi hõ nda woo kaŋ ay gʼa ceeci. ");
INSERT INTO ses_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Agay ne hari zaadogoo ra, koyraa zankawoyey ga fatta ka kaa ka gur. ");
INSERT INTO ses_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Yala woy soogaa kaŋ se ay ga nee: ‹Ni hooboo šiiri ya ne hala ay ga haŋ› kaŋ ga tuuru ya ne ka nee: ‹Haŋ, ay ga ni yoowey mo noo i ma haŋ!› Woo din ti boraa kaŋ nʼnʼa jisi ni tamoo Isiyaka se. Takaa woo ra ay ga bay kaŋ nʼga alhormo tee ay koyoo se.» ");
INSERT INTO ses_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","A mana šelaŋ ka ben jina kaŋ Rebeka fatta kate nga hooboo goo jesoo ga. A manʼti kala Betuwel ize woyoo. Betuwel manʼti kala Milka nda Nahor kaŋ ti Ibirahima armaa, izʼaroo. ");
INSERT INTO ses_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Woy soogaa ga hanse ka boori, a si aru bay, aru mana bay ka marga nda a. A zunbu hari zaadogoo ra ka nga hooboo too ka žigi. ");
INSERT INTO ses_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Baɲɲaa zuru kʼa kubay ka nee a se: «Hinžee ya ne, de mʼay noo hari kayna ni hooboo ra hala ay ga haŋ.» ");
INSERT INTO ses_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","A nʼa zaabi ka nee: «Haŋ, ay koyoo.» A na nga hooboo zumandi nda cahãyan kʼa noo a ma haŋ. ");
INSERT INTO ses_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Waatoo kaŋ a nʼa haŋandi ka ben, a nee a se: «Ay ga gur ni yoowey mo se, hala ngi jawoo ma hun.» ");
INSERT INTO ses_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Woo banda ga, a cahã ka koy nga hooboo haroo doori almaney haŋ jinaa ra. A yee ka zuru ka koy dayoo ga ka gur, a gur yoowey kul se. ");
INSERT INTO ses_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Aroo cindi a ga dangay kʼa guna, a ga baa nga ma bay wala Abadantaa na nga diraa boryandi wala a manʼa boryandi. ");
INSERT INTO ses_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Waatoo kaŋ yoowey haŋ ka ben, aroo na wura niinekorbay foo kaŋ ga too tamma jere tiŋyan nda wura kabehiiri hinka kaŋ ga too tamma boŋ woy (10) tiŋyan zaa. ");
INSERT INTO ses_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","A nee a se: «May ize ti ni? Ay gʼa wiri ni ga, mʼa bayrandi ya ne. Nongu goo ni baabaa hugoo ra kaŋ ra agay nda ay borey ga hin ka cijinoo tee wala?» ");
INSERT INTO ses_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","A nʼa zaabi ka nee: «Betuwel izoo ti agay. Betuwel ti izʼaroo kaŋ Milka duu a Nahor se.» ");
INSERT INTO ses_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","A yee ka nee a se: «Subu nda fita boobo goo ir do, nongu goo no kaŋ ra war ga hin ka cijinoo tee.» ");
INSERT INTO ses_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Woo banda ga, aroo sujudu Abadantaa se, ");
INSERT INTO ses_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","de a nee: «Albarka ma bara Abadantaa se, ay koyoo Ibirahima Koyoo, nga kaŋ mana nga alhormo naanayantaa kaa ay koyoo bande! Abadantaa nʼay gongu hala ay koyoo armey hugoo ra.» ");
INSERT INTO ses_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Woy soogaa zuru ka koy hugey do, nga ɲaa here, ka hayey filla. ");
INSERT INTO ses_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeka goo nda armaa foo kaŋ maaɲoo ti Labaŋ. Labaŋ zuru ka fatta ka koy aroo do, dayoo jeroo ga. ");
INSERT INTO ses_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Waatoo kaŋ a dii niinekorbaa nga woymaa ga nda kabehiirey kaŋ goo kabey ra, a maa nga woymaa Rebeka ga šelaŋ ka nee: «Woo no aroo nʼa har ya ne.» A zuru ka koy aroo do, de a nʼa gar a ga kay yoowey do, dayoo jeroo ga. ");
INSERT INTO ses_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Labaŋ nee a se: «Kaa, ni kaŋ Abadantaa na albarka daŋ ni ra! Macin se nʼga cindi taray? Ay na hugoo haabu, ay na doo hanse yoowey se.» ");
INSERT INTO ses_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Aroo koy huru hugoo ra, i na yoowey jeejaa kaa i boŋ. I kate yoowey se subu nda fita. I kate hari tamoo se kaŋ nda nga nda arey kaŋ goo a bande ga ngi cewey ɲumay. ");
INSERT INTO ses_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Woo banda ga, i na ŋaayan gorandi a se. Amma a nee: «Ay si ŋaa nda manʼti ya nka hayaa har kaŋ goo ay do jina.» A nee a se: «Šelaŋ!» ");
INSERT INTO ses_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Waatoo din a šelaŋ ka nee: «Ibirahima tamoo ti agay. ");
INSERT INTO ses_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Abadantaa hanse ka albarka daŋ ay koyoo ra, a tee beerante. A nʼa noo alman buuna nda ibeeri, nzorfu kaaray nda wura, baɲɲayaŋ nda koŋŋayaŋ, yooyaŋ nda farkayaŋ. ");
INSERT INTO ses_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sarata, ay koyoo wandoo, nga žeenayyanoo ra a duu a se izʼaru foo. Izoo din no, ay koyoo nʼa noo haya kul kaŋ goo nga maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ay koyoo nkʼay žeendi ka nee: ‹Kanaŋ borey kaŋ gandaa ra ay goo nda goray, masi woy zaa ay izoo se ngi ize woyey ra. ");
INSERT INTO ses_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Amma ma koy ay baabaa hugoo ra, ay alaayan beeroo do, ka wande zaa ay izoo se.› ");
INSERT INTO ses_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ay nee ay koyoo se: ‹A ga hin ka tee woyoo si baa nga ma hanga agay.› ");
INSERT INTO ses_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","A nʼay zaabi ka nee: ‹Abadantaa kaŋ fondaa ra ay ga dira ga nga almalaykaa daŋ ni jine. A ga ni diraa boryandi, de nʼga woy zaa ay izoo se, ay alaayan beeroo ra, ay baabaa hugoo do. ");
INSERT INTO ses_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Žeeyanoo si hun ni jindoo ga kala nda ni koy ay alaayan beeroo do. Nda i manʼa noo ma ne mo, a hun ni ga.› ");
INSERT INTO ses_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Hõ ay too hari zaadogoo do, de ay nee: ‹Abadantaa, ay koyoo Ibirahima Koyoo, ay gʼa wiri ni ga, mʼay diraa boryandi kaŋ ra ay goo! ");
INSERT INTO ses_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Agay ne ma kay hari zaadogoo jeroo ga, nda woy soogo fatta ka kaa ka gur dayoo ga, de ay nee a se: “Suuri, mʼay noo hari kayna ni hooboo ra.” ");
INSERT INTO ses_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","De a nʼay zaabi ka nee: “Haŋ, ni yoowey mo ay ga gur i se.” Yala woo ma tee woyoo kaŋ Abadantaa nʼa jisi ay koyoo izoo se.› ");
INSERT INTO ses_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ya na šelaŋ ka ben ay binoo ra kaŋ Rebeka da ne ka fatta kate nga hooboo goo jesoo ga, a ga zunbu haroo ga ka koy gur. Ay nee a se: ‹Suuri, mʼay noo hari ya haŋ.› ");
INSERT INTO ses_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Dogoo din da a na nga hooboo zumandi, a nee: ‹Haŋ, ay ga ni yoowey mo haŋandi.› Ay haŋ, a na yoowey mo haŋandi. ");
INSERT INTO ses_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ay nʼa hãa ka nee: ‹May ize ti ni?› A zaabi ka nee: ‹Betuwel kaŋ ti Nahor izʼaroo kaŋ Milka duu a a se, izoo ti agay.› Waatoo din ay duu ka niinekorbaa daŋ niinoo ga, ay na kabehiirey daŋ kabey ga. ");
INSERT INTO ses_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Woo banda ga, ay sujudu Abadantaa se. Ay na albarka tee a se, nga kaŋ ti ay koyoo Ibirahima Koyoo kaŋ nʼay gongu fondo hennaa ga hala yʼay koyoo armaa ize woyoo zaa nga izʼaroo se. ");
INSERT INTO ses_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Sohõ, nda war ga baa war ma alhormo naanayante tee ay koyoo se, war mʼa har ya ne. Nda manʼti nga, war mʼa har ya ne hala ya bay kabe kaŋ ga ay ga koy.» ");
INSERT INTO ses_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Labaŋ nda Betuwel nʼa zaabi ka nee: «Woo mana hun kala Abadantaa do. Cin no ir ga hin kʼa har ma ne ifutu wala ihenna ra? ");
INSERT INTO ses_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka ne ni jine, a zaa ka koy. A ma tee ni koyoo izoo se wande, sanda takaa kaŋ nda Abadantaa nʼa kayandi.» ");
INSERT INTO ses_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Waatoo kaŋ Ibirahima tamoo maa ngi šenney, a sujudu Abadantaa se. ");
INSERT INTO ses_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","A na nzorfu hiiriyaŋ nda wura hiiriyaŋ nda darbayyaŋ fattandi kʼi noo Rebeka se. A na gomni beeriyaŋ tee armaa nda ɲaŋoo se. ");
INSERT INTO ses_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Woo banda ga, tamoo nda borey kaŋ goo a bande ŋaa, i haŋ, i duu ka kani. Subbaahoo ra, i tun, tamoo nee: «Wʼay naŋ ya yee ay koyoo do.» ");
INSERT INTO ses_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Armaa nda ɲaŋoo zaabi ka nee: «Naŋ woy soogaa ma goro ir bande haya kayna, ba nda jirbi woy (10) de no, nga banda ga, a ma koy.» ");
INSERT INTO ses_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","A nʼi zaabi ka nee: «War masʼay gayandi, zama Abadantaa nʼay diraa boryandi. Wa naŋ ya yee ka koy ay koyoo do.» ");
INSERT INTO ses_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","I nʼa zaabi ka nee: «Wa naŋ ir ma ciya zankawoyoo se, ka nga hunday hãa.» ");
INSERT INTO ses_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","I ciya Rebeka se, i nʼa hãa ka nee: «Nʼga baa ma šerre aroo bande sohõ da wala?» A nʼi zaabi ka nee: «Ay ga koy.» ");
INSERT INTO ses_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","I na ngi woymaa Rebeka nda woyoo kaŋ nʼa biiri naŋ i ma koy nda Ibirahima tamoo nda nga borey. ");
INSERT INTO ses_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","I gaara Rebeka se, i nee: «Ir woymaa, yala ma tee boro zenberyaŋ hala cee zenber woyyaŋ se hayraa. De mo ni hayroo ma nga iberey koyrawey taa.» ");
INSERT INTO ses_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rebeka nda nga koŋŋey tun, i žigi yoowey boŋ ka hanga tamoo. Takaa woo nda tamoo na Rebeka zaa ka koy. ");
INSERT INTO ses_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isiyaka yee kate dayoo do kaŋ se i ga nee Ber-Lahay-Roy. A si goro kala Negew. ");
INSERT INTO ses_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Alaasar foo Isiyaka fatta ka koy hawsaa ra ka miile. Waati foo a na boŋoo jer, a dii yooyaŋ kaŋ goo ma kaa. ");
INSERT INTO ses_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka mo na nga boŋoo jer, a na Isiyaka honnay, de a sar ka zunbu ka hun yoowaa boŋ. ");
INSERT INTO ses_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","A nee tamoo se: «May ti aroo woo hawsaa ra kaŋ goo ma dira ka kaa kʼir kubay?» Baɲɲaa nʼa zaabi ka nee: «Ay koyoo Isiyaka no.» A na nga sanfitoo zaa kʼa gum nga boŋ. ");
INSERT INTO ses_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Baɲɲaa na hayey kul filla Isiyaka se kaŋ nga nʼi tee. ");
INSERT INTO ses_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isiyaka na Rebeka dii ka koy nga ɲaa Sarata hukkumoo ra. A tee a se wande, a bagʼa. Woo ka Isiyaka binoo yaynandi ɲaŋoo buuyanoo dumaa ga. ");
INSERT INTO ses_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ibirahima yee ka wande foo zaa kaŋ maaɲoo ti Ketura. ");
INSERT INTO ses_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Woyoo duu a se hayyan. Maaɲey ti: Zimraŋ, nda Yokušaŋ, nda Medaŋ, nda Majaŋ, nda Yišbak, nda Šuwa. ");
INSERT INTO ses_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokušaŋ na Šeba nda Dedaŋ daŋ aduɲɲa ra. Dedaŋ izey ti: Ašur borey, nda Letuš borey, nda Leyun borey. ");
INSERT INTO ses_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Majaŋ izʼarey ti: Efa, nda Efer, nda Hanok, nda Abida, nda Elda. Wey kul ti Ketura izeyaŋ nda nga haamayaŋ. ");
INSERT INTO ses_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Hayaa kul kaŋ goo Ibirahima maaɲoo ga, a nʼa noo Isiyaka se. ");
INSERT INTO ses_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Izʼarey kaŋ wahayey duu ey a se, a nʼi noo gomniyaŋ za a ga huna. Amma a nʼi moorandi nga izoo Isiyaka, kʼi sanba ganda ra kaŋ goo waynahunay kaboo here. ");
INSERT INTO ses_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Aloomuroo kaŋ Ibirahima duu a manʼti kala jiiri zangu nda woyye cindi guu (175). ");
INSERT INTO ses_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Woo banda ga, hundoo hun, a faati. A duu aloomur kuku, a koy nga hayragey gar alaahara. ");
INSERT INTO ses_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Nga izey Isiyaka nda Isimayel nʼa sutura Makupela tondi guusoo ra kaŋ goo faaroo ra, Mamre jeroo ga. A manʼti kala Eferoŋ wane kaŋ ti Sohar Heti boraa izʼaroo. ");
INSERT INTO ses_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Faaroo no kaŋ Ibirahima nʼa day Heti borey ga. No din ra Ibirahima nda nga wandoo Sarata suturandi. ");
INSERT INTO ses_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ibirahima buuyanoo banda ga, Irkoy na albarka daŋ nga izoo Isiyaka ra. Isiyaka gorodogoo ti nongoo kaŋ se i ga nee Ber-Lahay-Roy. ");
INSERT INTO ses_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Isimayel, Ibirahima izoo, hayroo ne. Isimayel ti izʼaroo kaŋ Hažatta, Misira boraa kaŋ ti Sarata koŋŋaa, duu a, Ibirahima se. ");
INSERT INTO ses_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Isimayel izʼarey ti wey, ngi maaɲey ne, alwadda ka kaa alwadda. Isimayel izʼaru jinaa ti Nebayot, nga banda ga, Kedar, nda Adbel, nda Mibsam, ");
INSERT INTO ses_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","nda Mišma, nda Duma, nda Masa, ");
INSERT INTO ses_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","nda Hadad, nda Tema, nda Yetur, nda Nafiš, nda Kedma. ");
INSERT INTO ses_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Wey ti Isimayel izʼarey, ngi maaɲey, nda ngi koyrawey, nda ngi gorodogey. Ngi ti ngi alkabiilawey boŋkoyni woy cindi hinkaa (12). ");
INSERT INTO ses_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Aloomuroo kaŋ Isimayel duu a manʼti kala jiiri zangu nda waranza cindi iyye (137). Hundoo hun, a faati ka koy nga hayragey gar alaahara. ");
INSERT INTO ses_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Isimayel hayroo si goro kala za Hawila hala Šur kaŋ goo Misira tenje ka koy Ašur gandaa here. Isimayel nda nga armey kul si goro nda cere. ");
INSERT INTO ses_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Isiyaka, Ibirahima izoo, hayroo ne. Ibirahima na Isiyaka daŋ aduɲɲa ra. ");
INSERT INTO ses_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Jiiri woytaaci (40) bara Isiyaka se waatoo kaŋ ra a ga hiiji Rebeka kaŋ ti Betuwel izoo, Aram boraa kaŋ goo Padaŋ-Aram. Nga ti Labaŋ, Aram boraa woymaa. ");
INSERT INTO ses_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isiyaka na Abadantaa ŋaaray nga wandoo se kaŋ manʼti kala woy gun. Abadantaa na nga ŋaarayroo taa. Rebeka, nga wandoo tee alhaamidu. ");
INSERT INTO ses_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Izey ga cere tuti gundoo ra. Rebeka nee: «Nda takaa woo no, cin no ay ga ti a?» A koy Abadantaa ibaayoo ceeci. ");
INSERT INTO ses_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Abadantaa nʼa zaabi ka nee: «Dumi hinka bara ni gundoo ra. Jama hinka ga hun ni gundoo ra kaŋ ga fay. Jama faa goo nda gaabi ka bisa ceroo. Ibeeroo ga yee ikaccaa cire.» ");
INSERT INTO ses_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Hanoo kaŋ ra a duu nga boŋ, nga ne, ntaway aruyaŋ ka cindi gundoo ra. ");
INSERT INTO ses_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ijinaa kaŋ kaa, nga kul no ma ciray. Gaahamoo kul ti hinbiri ma nee burmusu, i na maaɲoo daŋ Eso (maanaa «hinbiri»). ");
INSERT INTO ses_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Nga banda ga, armaa kaa, de kaboo ga Eso ceekoroo dii. I na maaɲoo daŋ Yakuba (maanaa «ceekore diikaa»). Waatoo kaŋ i ga hayandi, Isiyaka sii nda kala jiiri woydu (60). ");
INSERT INTO ses_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Zankey beeri, Eso tee aru kaŋ ga hanse ka wan hooyan, a ga baa hawsa koyyan. Amma Yakuba tee boro alaafiyante kaŋ ga goro hugey do. ");
INSERT INTO ses_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isiyaka si baa kala Eso, zama hamey kaŋ a gʼi hoo ga kan miɲoo ra. Amma Rebeka si baa kala Yakuba. ");
INSERT INTO ses_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Han foo Yakuba goo ma maafe hina, Eso kaa ka hun hawsaa ra, a dusu, a heray. ");
INSERT INTO ses_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Eso nee Yakuba se: «Ay gʼa wiri ni ga, naŋ ya gona iciraa woo ra, maafe ciraa woo ra, zama ay dusu, ay ga baa ka buu nda heray.» Šennoo woo ka kate i daŋ a ga Edom (maanaa «iciray»). ");
INSERT INTO ses_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakuba nee a se: «Kala ma ni izejinawtaraa neere ya ne jina.» ");
INSERT INTO ses_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Eso zaabi ka nee: «Nga ne, ay ga baa ka buu, macin no ay gʼa tee izejinawtaray se?» ");
INSERT INTO ses_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Woo banda ga, Yakuba nee: «A žee ya ne jina!» A žee a se, a na nga izejinawtaraa neere Yakuba se. ");
INSERT INTO ses_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Yakuba na Eso noo dunguri dumi maafe nda takula. A ŋaa, a haŋ jina, a tun ka koy. Takaa woo nda Eso na nga izejinawtaraa kaynandi. ");
INSERT INTO ses_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Heray foo tee gandaa ra kaŋ manʼti heray jinaa kaŋ tee Ibirahima waati. Isiyaka koy koyraa ra kaŋ se i ga nee Gerar, Abimelek do kaŋ ti Filisti borey kokoyoo. ");
INSERT INTO ses_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Abadantaa bangay a se, a nee: «Masi doo Misira gandaa ra, goro gandaa ra kaŋ ay gʼa har ma ne. ");
INSERT INTO ses_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ma goro ka waati tee no din ra. Ay goo ni bande. Ay ga albarka daŋ ni ra, zama ni nda ni hayroo se ay ga gandawey wey kul noo. Ay ga žeeyanoo too kaŋ ay nʼa žee ni baabaa Ibirahima se. ");
INSERT INTO ses_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ay ga ni hayroo boobandi sanda handarawey kaŋ goo beenaa ra. Ay gʼa noo gandawey wey kul. Ni hayroo bande aduɲɲa gandawey kul ga duu albarka, ");
INSERT INTO ses_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","zama Ibirahima na haŋajer ya ne. A nʼay talfey, nda ay yaamarey, nda ay hantumey, nda ay ašariyawey dii.» ");
INSERT INTO ses_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Woo ka kate Isiyaka goro Gerar. ");
INSERT INTO ses_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Waati kaŋ nongoo din borey nʼa hãa nda wandoo kaŋ goo a bande, a mma nee i se nga woymaa no. A ga hunbur ka nee i se nga wandoo no, zama a ga huzun nongoo din borey masi koy nga wii Rebeka maaganda se, zama woy no kaŋ ga boori. ");
INSERT INTO ses_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isiyaka goro ka gay no din ra. Han foo Abimelek kaŋ ti Filisti borey kokoyoo, guna nda funeetaraa, de a dii kaŋ Isiyaka goo ma nga wandoo Rebeka mooru-mooru. ");
INSERT INTO ses_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimelek ciya Isiyaka se, a nee: «Šikka sii kaŋ woyoo woo ni wandoo no. Taka foo nda nʼga yadda ka nee ni woymaa no?» Isiyaka nʼa zaabi ka nee: «Ya nkʼa har ya si koy buu nga maaganda se.» ");
INSERT INTO ses_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimelek nee: «Cin ti woo kaŋ nʼnʼa tee ir se? Haya kayna gandaa boro foo masi marga nda ni wandoo mʼir daŋ haya ra.» ");
INSERT INTO ses_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Abimelek na gandaa kul gagay ka nee: «Boro kul kaŋ tuku aroo woo do wala nga wandoo, a waazibi boraa ma wiiyandi.» ");
INSERT INTO ses_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Woo banda ga, Isiyaka na faari tee gandaa din ra, jiiroo woo, woo kaŋ a nʼa duma cine zangu (100) no a nʼa hegay, zama Abadantaa na albarka daŋ a ra. ");
INSERT INTO ses_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","A tee alman, nga almanoo mma koy de a ga tonton hala nongu kaŋ ra a tee almankoyni beeri. ");
INSERT INTO ses_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","A goo nda alman buuna nda ibeeri kuryaŋ, nda tam booboyaŋ. Filisti borey canse Isiyaka ga. ");
INSERT INTO ses_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Dayey kul kaŋ nga baabaa tamey nʼi fanši, nga baabaa Ibirahima waati, Filisti borey nʼi too nda labu kʼi lutu. ");
INSERT INTO ses_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimelek nee Isiyaka se: «Fatta ir gandaa ra, zama nʼga hin ir.» ");
INSERT INTO ses_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isiyaka hun no din. A koy goro Gerar gooroo ra, no din ra a cindi. ");
INSERT INTO ses_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","A na dayey fanši koyne kaŋ teendi nga baabaa Ibirahima waati, amma Ibirahima buuyanoo banda ga, Filisti borey nʼi lutu. Maa follokey kaŋ baaboo nʼa daŋ i ga, nga no a nʼi tunandi. ");
INSERT INTO ses_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isiyaka tamey fanši gooroo ra, i duu no din hari henna. ");
INSERT INTO ses_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Gerar koyraa kurkey yenje Isiyaka kurkey bande ka nee i se: «Ir wane haroo!» Isiyaka na dayoo maaɲoo daŋ Esek (maanaa «yenjeyan»), zama i nka yenje a bande. ");
INSERT INTO ses_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Isiyaka tamey na day foo fanši koyne kaŋ nga mo i yenje a bande a ga. A na maaɲoo daŋ Sitina (maanaa «citiyan»). ");
INSERT INTO ses_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","A hun no din ka koy, a na day foo fanši koyne kaŋ yenje mana tee a ga. A na maaɲoo daŋ Rehobot (maanaa «feeriyan»). A nee: «Sohõ Abadantaa nʼir feeri, ir ga tonton ka boobo gandaa ra.» ");
INSERT INTO ses_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Woo banda ga, a tun no din ka koy Ber-Šeba. ");
INSERT INTO ses_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Abadantaa bangay a se cijinoo ra ka nee: «Agay ti ni baabaa Ibirahima Koyoo. Masi hunbur, zama ay goo ni bande. Ay ga albarka daŋ ni ra, ay ga ni hayroo boobandi, Ibirahima, ay tamoo maaganda se.» ");
INSERT INTO ses_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","No din ra Isiyaka na sargari tonadoo cin ka Abadantaa maaɲoo cee. A na nga hukkumoo cin. Isiyaka tamey na day foo fanši no din. ");
INSERT INTO ses_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Han foo Abimelek nda nga ceroo Ahuzat nda nga wongu-izey jineboraa kaŋ ti Pikol hun Gerar ka koy a do. ");
INSERT INTO ses_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isiyaka nee i se: «Macin ti addaliloo kaŋ se war ga kaa ay do, war kaŋ konna agay, war nʼay gaaray war do?» ");
INSERT INTO ses_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","I nʼa zaabi ka nee: «Ir nka dii nda cimi kaŋ Abadantaa goo ni bande. Woo se ir nee kaŋ žeeyan ma huru ir nda ni game. Ir ma žee ka cere noo amaana. ");
INSERT INTO ses_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Žee kaŋ nʼsi haya laala tee ir se sanda takaa kaŋ nda ir mana ni laazaaba. Ihenna de no ir nʼa tee ma ne, de mo ir na ni naŋ ma koy nda alaafiyaa. Sohõ Abadantaa na albarka daŋ ni ra!» ");
INSERT INTO ses_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Isiyaka na hoyandi beeri tee i se, i ŋaa, i haŋ. ");
INSERT INTO ses_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Subaa ra, i biya ka tun, i žee cere se. Isiyaka nʼi naŋ i ma koy, i hun a do nda alaafiyaa. ");
INSERT INTO ses_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Zaaroo din da Isiyaka tamey kaa a do kʼa noo dayoo kaŋ i nʼa fanši alhabar. I nee a se: «Ir duu hari.» ");
INSERT INTO ses_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","A na dayoo maaɲoo daŋ Šiba (maanaa «žeeyan»). Woo se hala hõ koyraa maaɲoo ti Ber-Šeba (maanaa «žeeyanoo dayoo»). ");
INSERT INTO ses_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Waatoo kaŋ Eso duu jiiri woytaaci (40) a hiiji Žudit kaŋ ti Beri, Heti boraa, izoo nda Basemat kaŋ ti Eloŋ, Heti boraa, izoo. ");
INSERT INTO ses_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Woy hinkaa woo na Isiyaka nda Rebeka hundoo maray. ");
INSERT INTO ses_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Žeenay kaa Isiyaka ga, nga moo gunaa kuma hala nongu kaŋ ra a si dii koyne. A ciya nga izʼaru jinaa Eso se, a nee a se: «Ay izoo!» A nʼa zaabi ka nee: «Agay ne, ay baabaa!» ");
INSERT INTO ses_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isiyaka šelaŋ a se ka nee: «Nga ne, ay žen, ay sʼay buuyanoo zaaroo bay. ");
INSERT INTO ses_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Sohõ ay gʼa wiri ni ga, ma ni hoo jinawey zaa kaŋ ti ni tongaa nda ni biraa, ma koy hawsaa ra ka ham hoo ya ne. ");
INSERT INTO ses_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Mʼa hina hala a ma tee ya ne ŋaayan kaana, de ma kate a ya ne yʼa ŋaa hala ay hundoo ma ɲaali, ya gaara ma ne za ya na buu.» ");
INSERT INTO ses_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebeka maa hayaa kaŋ Isiyaka nʼa har nga izoo Eso se. Eso koy hawsaa ra ka ham hoo. ");
INSERT INTO ses_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka šelaŋ Yakuba, nga izoo se ka nee: «Aywa, ay maa ni baabaa goo ma šelaŋ ni armaa Eso se ka nee: ");
INSERT INTO ses_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‹Ham hoo kate ya ne, mʼa tee ya ne ŋaayan kaana, ya ŋaa. Ay ga gaara ma ne Abadantaa jine za ya na buu.› ");
INSERT INTO ses_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Sohõ ay izoo, haŋajer šennoo se kaŋ ay gʼa har ma ne. ");
INSERT INTO ses_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Koy alman buuney ra, ma hancin-ize henna boŋ hinka dii kate ya ne hala yʼi tee ŋaayan kaana, sanda woo kaŋ ga kan ni baabaa se. ");
INSERT INTO ses_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Mʼa ka koy ni baabaa se, de a ga ŋaa hala a ma duu ka gaara ma ne za a mana buu.» ");
INSERT INTO ses_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Amma Yakuba nee nga ɲaa Rebeka se: «Aywa, Eso, agʼarmaa ya gaahamoo kul ti hinbiri, agay binde mma yuttu. ");
INSERT INTO ses_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","A ga hin ka tee ay baabaa mʼay dadaba, de ya tee a se zanbante, ya kate ay boŋ ga dangayan kaŋ manʼti gaarayan.» ");
INSERT INTO ses_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ɲaŋoo nʼa zaabi ka nee: «Ay izoo, nda a na ni danga, a ma kaŋ ay boŋ. Haŋajer ay šennoo se ma koy kate ey.» ");
INSERT INTO ses_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","A koy, a nʼi dii, a kate ey nga ɲaa se. Ɲaŋoo nʼi tee ŋaayan kaana sanda woo kaŋ ga kan baaboo se. ");
INSERT INTO ses_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Woo banda ga, Rebeka na nga ize jinaa Eso bankaarawey kul ihennaa zaa kaŋ ga jisi a do hugoo ra. A nʼi daŋ nga ize hinkantoo Yakuba ga. ");
INSERT INTO ses_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Hanciney kuurey, a nʼi ka kabey nda jindoo nongey kaŋ ga yuttu daabu. ");
INSERT INTO ses_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Woo banda ga, a na ŋaayan kaanaa nda takulaa kaŋ a nʼi hanse daŋ nga izoo Yakuba kaboo ra. ");
INSERT INTO ses_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","A too nga baabaa do, a nee a se: «Ay baabaa!» A nʼa zaabi ka nee: «Naam, ay ize foo ti ni?» ");
INSERT INTO ses_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakuba na nga baabaa zaabi ka nee: «Agay no Eso, ni ize jinaa. Ay na hayaa tee kaŋ nʼnʼa har. Tun, ma goro, mʼay hamoo ŋaa, ma gaara ya ne.» ");
INSERT INTO ses_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isiyaka nee nga izoo se: «Cin ti woo? Ni ya cahã ka duu, ay izoo!» A na zaabi ka nee: «Haya kaŋ no, Abadantaa, ni Koyoo kʼay kubayandi nda a.» ");
INSERT INTO ses_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isiyaka nee Yakuba se: «Man kate ya ni dadaba, ay izoo, hala ya bay wala ni ti ay izoo Eso wala manʼti ni no.» ");
INSERT INTO ses_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakuba man nga baabaa Isiyaka ga, a nʼa dadaba, de a nee: «Jinde šennoo manʼti kala Yakuba jindoo, amma kabey manʼti kala Eso kabey.» ");
INSERT INTO ses_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","A manʼa bay, zama kabey kul ti hinbiri sanda nga armaa Eso waney takaa. A baa ka gaara a se. ");
INSERT INTO ses_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","A nee koyne: «Ay izoo Eso no wala?» Yakuba nʼa zaabi ka nee: «Ayyo, agay no.» ");
INSERT INTO ses_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Isiyaka nee: «Ay noo hamoo kaŋ nʼnʼa hoo, yʼa ŋaa, ya gaara ma ne!» A nʼa noo a se, a ŋaa. A kate a se alaneb hari moora, a haŋ. ");
INSERT INTO ses_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Baaboo nee a se: «Man kate, de mʼay summu, ay izoo.» ");
INSERT INTO ses_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","A man, de a nʼa summu. Isiyaka maa nga izoo darbawey hewoo. A gaara a se. A nee: «Wa guna, ay izoo hewoo ga hima nda faari kaŋ Abadantaa na albarka daŋ a ra hewoo. ");
INSERT INTO ses_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Yala Irkoy ma ni noo beenaa gomnoo nda laboo albarkaa. Alkama nda alaneb hari masi jaŋ ni do! ");
INSERT INTO ses_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Yala alkabiilayaŋ ma yee ni cire! Dumiyaŋ ma gunguma ma ne! Ma tee ni armey boŋkoynoo, de mo ni ɲaa-izey ma gunguma ma ne! Boro kaŋ na ni danga ga laali, boro kaŋ gaara ma ne ga duu albarka!» ");
INSERT INTO ses_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isiyaka nka gaara ka ben Yakuba se, Yakuba fatta nga baabaa do, dogoo din da Eso kaa ka hun hoodogoo ra. ");
INSERT INTO ses_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Nga mo na ŋaayan kaana foo tee kaŋ a kate a nga baabaa se. A nee nga baabaa se: «Ay baabaa, tun ka ni izoo hamoo kaŋ a nʼa hoo ŋaa, ma gaara a se.» ");
INSERT INTO ses_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Baaboo nʼa hãa ka nee: «May ti ni?» A nʼa zaabi ka nee: «Agay no, ni ize jinaa, Eso.» ");
INSERT INTO ses_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isiyaka hanse ka jijiri hunburay se, de a nee: «May ti boraa kaŋ na ham hoo ka kate a ya ne? Ay nʼa kul ŋaa za mana too kate. Ay gaara a se. De mo gaararoo ga cindi a bande.» ");
INSERT INTO ses_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Waatoo kaŋ ra Eso maa nga baabaa šenney, a na kaati beeri tee, binoo hanse ka maray, de a nee nga baabaa se: «Ay baabaa, gaara ya ne, agay mo!» ");
INSERT INTO ses_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Isiyaka nʼa zaabi ka nee: «Ni armaa kaa nda carmay, de a duu gaararoo kaŋ nʼga hima ka duu a.» ");
INSERT INTO ses_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Eso nee: «Hayaa kaŋ se i na maaɲoo daŋ Yakuba (maanaa ‹zanbante›), nga se a nʼay zanba cee hinka? A na izejinawtaraa taa ay kone, sohõ nga ne ka koy nda gaararoo kaŋ ay ga hima ka duu a!» A yee ka nee: «Mana gaarari kul jisi ya ne?» ");
INSERT INTO ses_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isiyaka na Eso zaabi ka nee: «Guna, ay nʼa tee ni boŋkoynoo, ay na nga armey kul tee nga tamey. Ay nʼa noo alkamaa nda alaneb haroo. Sohõ macin no ay ga hin kʼa tee ma ne, ay izoo?» ");
INSERT INTO ses_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Eso nee nga baabaa se: «Gaararoo woo hinne bara ma ne, ay baabaa? Ay baabaa, gaara ya ne!» Eso na nga jindoo jer ka hẽe. ");
INSERT INTO ses_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Baaboo nʼa zaabi ka nee: «Guna, ni gorodogoo ga mooru labu albarkantey nda beenaa gomnoo. ");
INSERT INTO ses_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ni takubaa nda nʼga huna, nʼga yee ni armaa cire, amma nʼga kaa ka duu ni boŋ. Tiŋay-zaa-bundoo kaŋ a ga daŋ ni boŋ, nʼgʼa kaa ni jindoo ga.» ");
INSERT INTO ses_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Eso konna Yakuba, gaararoo maaganda se kaŋ baaboo nʼa tee a se. Eso nee nga boŋ se: «Ay baabaa buuyanoo waatoo man, ay ga agʼarmaa Yakuba wii.» ");
INSERT INTO ses_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Rebeka duu šenney kaŋ hun nga ize jinaa Eso miɲoo ra alhabaroo. A daŋ i ma ciya nga ize hinkantoo Yakuba se, a nee a se: «Aywa, ni armaa Eso ga baa nga ma faasa nga boŋ se ka ni wii. ");
INSERT INTO ses_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Sohõ ay izoo, haŋajer ay šennoo se, tun ka zuru ka koy lafa Labaŋ jeroo ga kaŋ ti agʼarmaa kaŋ goo koyraa ra kaŋ maaɲoo ti Karaŋ. ");
INSERT INTO ses_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ma jirbiyaŋ tee a do hala han kaŋ ni armaa binoo ma zunbu. ");
INSERT INTO ses_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Hala waati kaŋ ni dooraa hun ni armaa binoo ra, a ma dirɲa hayaa kaŋ nʼnʼa tee nga se. Waatoo din ay ga sanba ma ne ma yee kate. Cin se ay ga jaŋ war boro hinkaa kul han follokaa ra?» ");
INSERT INTO ses_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebeka nee Isiyaka se: «Ay konna hunayan, Heti ize woyey sabbu se. Nda Yakuba na woy zaa, sanda wey dumey, Heti ize woyey ra, gandaa ize woyey ra, macin no hunayan gʼa nafa ya ne?» ");
INSERT INTO ses_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isiyaka ciya Yakuba se, a gaara a se jina, a duu kʼa yaamar ka nee: «Masi woy zaa Kanaŋ borey ize woyey ra. ");
INSERT INTO ses_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Tun ni boŋ ga, ma koy Padaŋ-Aram, Betuwel do kaŋ ti ni ɲaa baabaa. No din ra ma woy zaa ni ɲaa armaa kaŋ ti Labaŋ, ize woyey ra. ");
INSERT INTO ses_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Yala Irkoy, Hini-kul-koyoo ma albarka daŋ ni ra, a ma ni noo hayyaŋ ka ni boobandi. Nʼga tee dumi boobo. ");
INSERT INTO ses_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Yala a ma ni noo Ibirahima albarkaa, ni nda ni hayroo kul, hala ma gandaa mayray kaŋ Irkoy nʼa noo Ibirahima se kaŋ ra ni koy goro.» ");
INSERT INTO ses_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Takaa woo nda Isiyaka na Yakuba sanba Padaŋ-Aram, Labaŋ do kaŋ ti Betuwel, Aram boraa, izoo. Labaŋ mma tee arma Rebeka se kaŋ ti Yakuba nda Eso ɲaa. ");
INSERT INTO ses_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Eso dii kaŋ Isiyaka gaara Yakuba se, a nʼa sanba Padaŋ-Aram hala a ma wande zaa no din, kaŋ a ga gaara a se mo, a nʼa yaamar ka nee: «Masi woy zaa Kanaŋ borey ize woyey ra.» ");
INSERT INTO ses_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","A dii kaŋ Yakuba maa nga baabaa nda nga ɲaa se, de mo a koy Padaŋ-Aram. ");
INSERT INTO ses_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Woo ka kate Eso ma faham kaŋ Kanaŋ borey ize woyey si kan nga baabaa Isiyaka se. ");
INSERT INTO ses_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Woo banda ga, Eso koy Isimayel do. A yee ka hiiji woy foo. Woyoo manʼti kala Isimayel, Ibirahima izʼaroo ize woyoo, maaɲoo ti Mahalat, Nebayot woymaa no. ");
INSERT INTO ses_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakuba hun koyraa ra kaŋ se i ga nee Ber-Šeba ka koy Karaŋ. ");
INSERT INTO ses_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","A too nongu foo ra kaŋ ra a kani, zama waynaa kaŋ. A na tondi foo sanbu kʼa tee furkanga, a kani no din da. ");
INSERT INTO ses_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","A handiri. Handiroo ra, a dii kali-kali kaŋ ga kay laboo ga, boŋoo goo beenaa ra, de Irkoy almalaykey ga žigi, i ga zunbu kali-kaloo boŋ. ");
INSERT INTO ses_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","De Abadantaa ga kay boŋoo boŋ ka nee: «Agay ti Abadantaa, ni baabaa Ibirahima Koyoo, Isiyaka Koyoo, gandaa woo kaŋ ra ni goo ma kani, ay gʼa noo ni nda ni hayroo se. ");
INSERT INTO ses_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ni hayroo ga boobo sanda labutaasi. Ni laboo laamaa ga koy too gandaa kanjey kul: kʼa dii dangay nda dandi here ka koy hawsa nda gurma here. Ni nda ni hayroo ra, aduɲɲa alaayan beerey kul ga duu albarka. ");
INSERT INTO ses_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Nga ne, ay goo ni bande, ay ga ni hawgay nongu kul kaŋ ra nʼga koy. Ay ga ni ka yee kate gandaa woo ra. Ay si ni naŋ, ay ga hayaa tee kaŋ ay nʼa har ma ne.» ");
INSERT INTO ses_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yakuba tun jirboo ra, de a nee: «Šikka sii kaŋ Abadantaa goo nongoo woo ra, agay, ya na bay!» ");
INSERT INTO ses_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","A jiti, de a nee koyne: «Nongoo woo ga boro hunburandi! Ne manʼti nongu kul kala Irkoy hugoo, ne ti beenaa miɲoo!» ");
INSERT INTO ses_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yakuba biya ka tun, a na tondoo zaa kaŋ cindi boŋoo cire, a nʼa kayandi kʼa tee hongandihaya, a na jii doori tondoo boŋoo boŋ. ");
INSERT INTO ses_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","A na nongoo din maaɲoo daŋ Betel (maanaa «Irkoy hugoo»), amma cee jinaa koyraa maaɲoo ti Luz. ");
INSERT INTO ses_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yakuba na meefur foo zaa ka nee: «Nda Irkoy goo ay bande, nda a nʼay hawgay fondaa kaŋ ra ay goo ma dira ra, nda a nʼay noo ŋaayan kaŋ ay gʼa ŋaa, nda bankaarayyaŋ kaŋ ga huru ay ga, ");
INSERT INTO ses_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","nda ay yee nda baani ay baabaa hugoo do, nga ra Abadantaa ga tee ya ne Koy. ");
INSERT INTO ses_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","De mo tondoo woo kaŋ agay ne kʼa kayandi kʼa tee hongandihaya, ga tee Irkoy hugoo. Gomni kul kaŋ nʼgʼa noo ya ne, ay ga azakkaa noo ma ne.» ");
INSERT INTO ses_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakuba yee ka fondaa zaa, a koy waynahunay izey gandaa here. ");
INSERT INTO ses_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","A dii day foo hawsaa ra, alman buuna kur hinza ga kani miɲoo ga, zama dayoo din ra i ga almaney haŋandi. Tondoo kaŋ ga dayoo miɲoo daabu ga tiŋ. ");
INSERT INTO ses_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Waati kaŋ alman kurey kul marga jina, nga no i ga tondoo gunguray kʼa kaa dayoo miɲoo ga ka almaney haŋandi. Woo banda ga, i ga tondoo yeeti dayoo miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakuba šelaŋ i se kʼi hãa wala man wane nda ey. I nʼa zaabi ka nee: «Karaŋ koyraa wane nda ir.» ");
INSERT INTO ses_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","A nee i se: «War ga Labaŋ bay, Nahor haamʼaroo?» I nʼa zaabi ka nee: «Ir gʼa bay.» ");
INSERT INTO ses_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","A nee i se: «A ga saabu wala?» I nʼa zaabi ka nee: «A ga saabu. Rašel, nga ize woyoo ne ma kaa nda alman buuney.» ");
INSERT INTO ses_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","A nee koyne: «Zaaroo ya ga kuu, waatoo mana too kaŋ ra almaney ga margandi. Wa almaney haŋandi ka koy i kur.» ");
INSERT INTO ses_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","I nee: «Ir si hin kala waati kaŋ alman kurey kul marga jina, nga no kurkey ga tondoo gunguray kʼa kaa dayoo miɲoo ga ka almaney haŋandi.» ");
INSERT INTO ses_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","A goo ma šelaŋ i bande da kaŋ Rašel ne ma kaa nda nga baabaa almaney, zama kurkaw no. ");
INSERT INTO ses_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Waatoo kaŋ Yakuba dii Rašel, nga hasaa Labaŋ ize woyoo, nda Labaŋ almaney, Yakuba man ka tondoo gunguray kaŋ goo dayoo miɲoo ga. A na Labaŋ nga hasaa almaney haŋandi. ");
INSERT INTO ses_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Woo banda ga, a na Rašel summu, de a na nga jindoo jer ka hẽe. ");
INSERT INTO ses_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yakuba filla Rašel se kaŋ baaboo boro ti nga, nga manʼti kala Rebeka izoo. Rašel zuru ka koy a har nga baabaa se. ");
INSERT INTO ses_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Dogoo din da kaŋ Labaŋ maa Yakuba, nga woymaa izoo alhabaroo, a zuru ka koy a kubay, a nʼa naagu nga gandoo ra kʼa summu, de a nʼa ka koy nga hugoo do. Yakuba na hayey kul filla Labaŋ se. ");
INSERT INTO ses_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Labaŋ nee a se: «Šikka sii kaŋ ay hamoo nda ay kuroo ti ni!» Yakuba goro a do hala handu foo too. ");
INSERT INTO ses_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Labaŋ nee koyne Yakuba se: «Manʼti kaŋ se ay boraa ti ni, nga se nʼga goy ya ne yaada! Ni goy hayoo kayandi ya ne.» ");
INSERT INTO ses_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Woo kaa ka gar kaŋ Labaŋ goo nda ize woy hinka, ijinaa maaɲoo ti Leya, ihinkantoo maaɲoo ti Rašel. ");
INSERT INTO ses_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leya goo nda mootondi hennayaŋ, amma Rašel goo nda kunturu henna nda ndum henna. ");
INSERT INTO ses_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakuba na Rašel bajoo zaa nga binoo ra. A nee: «Ay ga goy ma ne jiiri iyye, ay banaa ti Rašel, ni ize woy hinkantoo.» ");
INSERT INTO ses_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labaŋ zaabi ka nee: «Ay baa yʼa noo ma ne nda yʼa noo aru foo se, cindi ay do.» ");
INSERT INTO ses_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Yakuba goy jiiri iyye hala nga ma duu Rašel, i tee moɲoo ra sanda jirbi kaynayaŋ taka kaŋ nda a ga bagʼa. ");
INSERT INTO ses_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Jiiri iyyaa banda ga, Yakuba nee Labaŋ se: «Ay noo ay wandoo, zama waatoo kaŋ ga ir huru too, ay ga baa yʼa hiiji.» ");
INSERT INTO ses_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Labaŋ na nongoo din borey kul marga, a na hoyandi beeri tee. ");
INSERT INTO ses_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Amma waatoo kaŋ cijinoo too, a na nga ize woyoo Leya zaa kʼa ka koy Yakuba do, Yakuba gorokasinay nda a. ");
INSERT INTO ses_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Labaŋ na nga koŋŋaa Zilpa noo nga izoo Leya se, a ma tee a se koŋŋa. ");
INSERT INTO ses_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Subbaahoo ra, nga ne, Leya no. Yakuba nee Labaŋ se: «Cin ti woo nʼnʼa tee ya ne! Ni bay Rašel se ay goy ma ne? Cin se nʼnʼay darga?» ");
INSERT INTO ses_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labaŋ zaabi ka nee: «Ir nongoo kaniroo ra, boro si kayne hiijandi ka beere naŋ. ");
INSERT INTO ses_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Jirbi iyyaa benandi nda a, nga banda ga, ir ga ni noo affaa nda nʼga goy ya ne koyne jiiri iyye.» ");
INSERT INTO ses_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Hayaa kaŋ a nʼa har, Yakuba nʼa tee. A na jirbi iyyaa tee nda Leya jina, Labaŋ nʼa noo nga ize woyoo Rašel a ma hiiji a. ");
INSERT INTO ses_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labaŋ na nga koŋŋaa Bilha noo nga izoo Rašel se, a ma tee a se koŋŋa. ");
INSERT INTO ses_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakuba gorokasinay nda Rašel mo kaŋ a bagʼa nda Leya. A yee ka jiiri iyye taaga goy Labaŋ se. ");
INSERT INTO ses_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Kaŋ Abadantaa dii kaŋ Yakuba ga baa Rašel ka bisa Leya, woo se a na Leya noo hayyan, amma Rašel a nʼa tee woy gun. ");
INSERT INTO ses_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leya tee boro hinka, a na izʼaru foo daŋ aduɲɲa ra. A na maaɲoo daŋ Rubeŋ (maanaa «wa guna izʼaru»). A nee: «Zama Abadantaa dii ay naajoo. Sohõ ay kurɲoo ga baa agay.» ");
INSERT INTO ses_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","A yee ka tee boro hinka, a duu izʼaru. A nee: «Zama Abadantaa dii ay baji jaŋaa, nga se a nʼay noo izoo woo.» A na maaɲoo daŋ Simewoŋ (maanaa «a ga maa»). ");
INSERT INTO ses_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","A yee ka tee boro hinka, a duu izʼaru foo. A nee: «Nhuu, sohõ ay kurɲoo ga didiji ay ga, zama ay duu a se izʼaru hinza.» Woo se a na maaɲoo daŋ Lewi (maanaa «a ga didiji»). ");
INSERT INTO ses_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","A yee ka tee boro hinka, a na izʼaru foo daŋ aduɲɲa ra. A nee: «Hiino ay ga albarka tee Abadantaa se!» Woo se a na maaɲoo daŋ Žuda (maanaa «a ga albarka tee»). Woo banda ga, a mana duu ize. ");
INSERT INTO ses_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Waatoo kaŋ Rašel dii kaŋ nga si duu ize Yakuba se, a canse nga woymaa ga, de a nee Yakuba se: «Ay noo zanka, nda manʼti nga, ay ga buu!» ");
INSERT INTO ses_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakuba futu Rašel ga, de a nee: «Agay ti Irkoy kaŋ na ni ganji hayyan?» ");
INSERT INTO ses_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rašel nee a se: «Ay koŋŋaa Bilha ne, marga nda a, a ma hay ay maaɲoo ga, woo ra ize kaŋ a gʼa hay ga tee ay wane.» ");
INSERT INTO ses_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","A nʼa noo Bilha, nga koŋŋaa, sanda wande. Yakuba marga nda a. ");
INSERT INTO ses_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilha tee boro hinka, a na izʼaru hay Yakuba se. ");
INSERT INTO ses_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rašel nee: «Irkoy ciiti ya ne, a maa ay šennoo se kʼay noo izʼaru.» Woo se a na maaɲoo daŋ Dan (maanaa «a ciiti»). ");
INSERT INTO ses_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Koŋŋaa yee koyne ka tee boro hinka, a na nga izʼaru hinkantoo hay Yakuba se. ");
INSERT INTO ses_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rašel nee: «Ay na yenje šenda tee ay woymaa bande, ay hin a. A na zankaa maaɲoo daŋ Neftali (maanaa ‹ay yenjaa›).» ");
INSERT INTO ses_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Waatoo kaŋ Leya dii kaŋ nga gay nga mana hay, a na Zilpa nga koŋŋaa zaa kʼa noo Yakuba se, a ma tee a se sanda wande. ");
INSERT INTO ses_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Nga koŋŋaa na izʼaru hay Yakuba se. ");
INSERT INTO ses_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leya nee: «Woo ti gomni!» A na maaɲoo daŋ Gad (maanaa «gomni»). ");
INSERT INTO ses_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Koŋŋaa duu Yakuba se nga izʼaru hinkantoo. ");
INSERT INTO ses_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leya nee: «Woo ti agʼarrahamaa! Sohõ woyey ga nee ya ne arrahamantaa.» A na maaɲoo daŋ Ašer (maanaa «arrahama»). ");
INSERT INTO ses_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Han foo Rubeŋ koy faarey ra, alkamaa hegaa waati, a duu tuuri-ize fooyaŋ kaŋ ga woy gun safar, a kate ey nga ɲaa Leya se. Rašel nee Leya se: «Ay gʼa wiri ni ga, ay noo ni izoo tuuri-izey ra kaŋ ga woy gun safar.» ");
INSERT INTO ses_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","A nʼa zaabi ka nee: «A mana wasa ma ne kaŋ nʼnʼay kurɲoo taa, ay izoo tuuri-izey mo nʼga baa mʼi taa wala?» Rašel nee: «A boori! A ga kani ni do hõ cijinoo, mʼay noo ni izoo tuuri-izey.» ");
INSERT INTO ses_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Almaaroo ra, kaŋ Yakuba kaa ka hun faarey do, Leya fatta kʼa kubay ka nee a se: «Agay do nʼga kani, zama ay na kaniyanoo day nda ay izoo tuuri-izey.» Cijinoo din a kani a do. ");
INSERT INTO ses_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Irkoy yadda Leya se, a tee boro hinka, a na nga izʼaru guwantoo daŋ aduɲɲa ra Yakuba se. ");
INSERT INTO ses_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leya nee: «Irkoy nʼay bana, zama ay nʼay koŋŋaa noo ay kurɲoo se.» A na zankaa maaɲoo daŋ Isakar (maanaa «ay banaa»). ");
INSERT INTO ses_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","A yee koyne ka tee boro hinka, a duu nga izʼaru idduwantoo Yakuba se. ");
INSERT INTO ses_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","A nee: «Agay, Irkoy nʼay noo nooyan henna. Hõ banda ga, ay kurɲoo gʼay beerandi, zama izʼaru iddu no ay nʼi hay a se.» A na zankaa maaɲoo daŋ Zabuloŋ (maanaa «beeray»). ");
INSERT INTO ses_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","A gay jina, a na ize woy foo hay, a na maaɲoo daŋ Dina. ");
INSERT INTO ses_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Irkoy ɲeli Rašel ga, a maa a se, a nʼa faaba a ma duu ize. ");
INSERT INTO ses_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","A tee boro hinka, a duu izʼaru. A nee: «Irkoy nʼay haawoo kaa.» ");
INSERT INTO ses_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","A na zankaa maaɲoo daŋ Isufi (maanaa «a ma tonton»). A nee: «Yala Abadantaa ma izʼaru foo tonton ya ne!» ");
INSERT INTO ses_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Waatoo kaŋ Rašel na Isufi daŋ aduɲɲa ra, Yakuba nee Labaŋ se: «Ay naŋ ya koy, ya yee ay do, ay gandaa ra. ");
INSERT INTO ses_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ay noo ay wandey nda ay izey kaŋ se ay goy ma ne, ay ga baa ya koy, zama ni hunday ga bay takaa kaŋ nda ay goy ma ne.» ");
INSERT INTO ses_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Labaŋ nʼa zaabi ka nee: «Nda ni nka hin ka alhormo tee ya ne, ma cindi ay do! Ay gunandoo ra ay dii kaŋ ni maaganda se Abadantaa na albarka daŋ ay ra.» ");
INSERT INTO ses_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","A nee koyne: «Ni goy hayoo kayandi ya ne, ay gʼa bana.» ");
INSERT INTO ses_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakuba nee a se: «Nʼga takaa bay kaŋ nda ay goy ma ne, nda takaa kaŋ ni alman kuroo ti a ay kone, ");
INSERT INTO ses_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","zama ikaynaa kaŋ cindi ma ne za ya na kaa ni do, ne ka boobo. Agay bande Abadantaa na albarka daŋ ni ra. Sohõ waati foo no ay ga goy ay hugoo hunday se?» ");
INSERT INTO ses_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","A nʼa zaabi ka nee: «Macin no yʼa noo ma ne?» Yakuba nee a se: «Masʼay noo haya kul, amma nda ni yadda woo kaŋ ay gʼa har ma ne, ay ga yee ka šintin ka ni alman buuney kur kʼi hawgay. ");
INSERT INTO ses_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ay ga dira ni almaney kul bande hõ ka feeji-izey kul kaŋ ga tonbi goo wala žeeri, nda feeji-ize bibey kul, nda hancin-izey kaŋ ga žeeri goo, nda wey kaŋ ga tonbi goo hanciney ra: wey din no ma tee ay banaa. ");
INSERT INTO ses_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Suba nʼga bay ay laadirtaraa ga, waati kaŋ ni kaa kʼay banaa laasaabu. Hancin kul kaŋ ni dii a ay waney ra kaŋ ga tonbi sii, žeeri sii, nda feeji bibey, ma bay ya nkʼi zay.» ");
INSERT INTO ses_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labaŋ zaabi ka nee: «Ay yadda, a ma tee woo kaŋ nʼnʼa har.» ");
INSERT INTO ses_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Amma zaari follokaa din da ra, Labaŋ na jindaarey kaŋ ga caaray goo, nda hanciney kul kaŋ ga tonbi goo, nda wey kul kaŋ ra ikaaray goo, nda wey kul kaŋ ga bibi feeji-izey ra, a nʼi kul daŋ jere ga jina, a nʼi daŋ nga izʼarey kabey ra. ");
INSERT INTO ses_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Woo banda ga, a na jirbi hinza diray daŋ nga nda Yakuba game. Yakuba cindi, a ga Labaŋ almaney jerey kur. ");
INSERT INTO ses_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yakuba na tuuri kabe ganiyaŋ zaa kaŋ ga hima nda turaariɲaa kabeyaŋ, nda affooyaŋ kaŋ ga hima nda kangawɲaa kabeyaŋ, nda affooyaŋ koyne kaŋ ga hima nda miliya kabeyaŋ. A nʼi feferi ka žeeri-žeeriyaŋ kaa kokošoo ga hala bundu kaaraa fatta. ");
INSERT INTO ses_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Woo banda ga, tuuri kabey kaŋ a nʼi feferi, a nʼi jisi almaney hari haŋ jinawey ra, ngi moɲey cire. I ga marga nda cere waati kaŋ i kaa ka haŋ. ");
INSERT INTO ses_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Almaney ga marga nda cere tuuri kabey jerey ga. Waati kaŋ i hay i ga duu izeyaŋ kaŋ ga caaray wala tonbi wala žeeri goo. ");
INSERT INTO ses_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Feejey kaŋ Yakuba nʼi daŋ jere ga, a nʼi tenjandi Labaŋ alman kurey kaŋ ga tonbi goo nda ibibey. Takaa woo nda a na alman marga nga boŋ se. A mana naŋ i ma birji Labaŋ waney ra. ");
INSERT INTO ses_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Waati kul kaŋ feeji gaabantey ga marga nda cere, Yakuba ga tuuri kabe feferantey daŋ almaney moɲey cire hari haŋ jinawey ra, hala i ma duu ka marga nda cere jerey ga. ");
INSERT INTO ses_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Alman faabey, a sʼi daŋ i se, woo ra ifaabey ti Labaŋ wane, igaabantey ti nga wane. ");
INSERT INTO ses_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Takaa woo nda Yakuba tee almankoyni beeri. A duu alman buuna boobo, nda koŋŋayaŋ, nda baɲɲayaŋ, nda yooyaŋ, nda farkayaŋ. ");
INSERT INTO ses_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Han foo Yakuba maa Labaŋ izʼarey ga nee: «Yakuba nʼir baabaa hayey kul zaa. Ir baabaa hayey nda a na almanoo woo kul tee.» ");
INSERT INTO ses_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakuba dii kaŋ Labaŋ anniyaa bere, a mana yee ka tee sanda cee jinaa takaa. ");
INSERT INTO ses_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Koyne mo Abadantaa nee Yakuba se: «Yee ni hayragey gandaa ra, ni dumoo do, ay goo ni bande.» ");
INSERT INTO ses_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Woo banda ga, Yakuba sanba ka ciya Rašel nda Leya se i ma kaa hawsaa ra nga alman buuney do. ");
INSERT INTO ses_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","A nee i se: «Ay ga dii kaŋ war baabaa anniyaa bere, a mana yee ka tee sanda cee jinaa takaa, amma Irkoy kaŋ ay baabaa gʼa gana goo ay bande. ");
INSERT INTO ses_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","War hunday ga bay kaŋ ay goy war baabaa se nda ay hinoo kul, ");
INSERT INTO ses_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","nga, a nʼay tee hoorayhaya, cee woy (10) a gʼay banaa barmay, amma Irkoy mana yadda nga goy futaa ma duu agay. ");
INSERT INTO ses_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Waatoo kaŋ ra a ga nee: ‹Tonbikoyney ga tee ni banaa›, almaney kul tonbikoyni no i ga hay. Nda a nee: ‹Icaarawey ga tee ni banaa›, almaney kul ga icaarante hay. ");
INSERT INTO ses_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Irkoy ka war baabaa almaney taa kʼi noo ya ne. ");
INSERT INTO ses_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Waati kaŋ alman hinka ga marga, ay gʼay boŋoo jer ka dii handiri ra kaŋ alman arey kaŋ ga marga nda woyey manʼti kala icaarayyaŋ, nda tonbikoyniyaŋ, nda žeerikoyniyaŋ. ");
INSERT INTO ses_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Irkoy almalaykaa nee ya ne handiroo ra: ‹Yakuba!› Ay zaabi ka nee: ‹Naam.› ");
INSERT INTO ses_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","A nee ya ne: ‹Ni boŋoo jer ka guna, alman arey kul kaŋ ga marga nda woyey manʼti kala icaarayyaŋ, nda tonbikoyniyaŋ, nda žeerikoyniyaŋ, zama ay dii haya kul kaŋ Labaŋ nʼa goy ni ga. ");
INSERT INTO ses_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Agay ti Betel Koyoo, nongoo kaŋ ra nʼna tondoo kaŋ nʼnʼa kayandi kʼa sinji yon, nongoo kaŋ ra nʼna allaahidu zaa ya ne. Sohõ tun ni boŋ ga, ma fatta gandaa woo ra, de ma yee gandaa kaŋ ra ni hayandi.›» ");
INSERT INTO ses_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rašel nda Leya zaabi ka nee a se: «Ir mma bara nda baa nda tubuhaya ir baabaa hugu ra koyne wala? ");
INSERT INTO ses_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Manʼti a nkʼir tee sanda yawyaŋ wala, zama a nʼir neere? A nʼir hayoo ŋaa, a nʼa ŋaa! ");
INSERT INTO ses_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Šikka sii, almanoo kul kaŋ Irkoy nʼa taa ir baabaa kone, ir nda ir izey wane. Sohõ haya kul kaŋ Irkoy nʼa har ma ne, mʼa tee.» ");
INSERT INTO ses_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Yakuba tun, a na nga izey nda nga wandey žigandi yoowey boŋ. ");
INSERT INTO ses_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","A na nga almaney gongu ka koy nda haya kul kaŋ goo a se, nda wey kaŋ a duu ey Padaŋ-Aram, de a koy nga baabaa Isiyaka do Kanaŋ gandaa ra. ");
INSERT INTO ses_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Woo kaa ka gar kaŋ Rašel na nga baabaa toorey zay waatoo kaŋ a koy alman buuney kosu. ");
INSERT INTO ses_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakuba na Labaŋ, Aram boraa lakkaloo zay, a zuru a ga bila nda a ma haya kul har a se. ");
INSERT INTO ses_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","A zuru, nga nda haya kul kaŋ goo maaɲoo ga. A tun ka koy Efrat isaa deŋ ka bisa ka koy tondi hondey kaŋ se i ga nee Galad. ");
INSERT INTO ses_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Jirbi hinzantoo ra, Labaŋ duu alhabar kaŋ Yakuba zuru. ");
INSERT INTO ses_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Labaŋ na nga borey zaa kʼa gaarandi, jirbi iyye diray no a nʼa tee hala a ga duu a Galad tondi hondey ra. ");
INSERT INTO ses_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Amma cijinoo ra, Irkoy bangay Labaŋ, Aram boraa se handiri ra ka nee a se: «Hawgay, masi ba šenni henna har Yakuba se soko ifutu.» ");
INSERT INTO ses_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Labaŋ too Yakuba. A gar kaŋ Yakuba na nga hukkumey cin tondi hondey ra. Labaŋ mo na nga waney cin, nga nda nga borey, Galad tondi hondey ra. ");
INSERT INTO ses_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Labaŋ nee Yakuba se: «Cin ti woo nʼnʼa tee? Cin se nʼnʼay lakkaloo zay ka koy nda ay ize woyey ma nee koŋŋayaŋ kaŋ ni duu ey wongu ra! ");
INSERT INTO ses_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Macin se ni tugu ka zuru, nʼnʼay zanba, de mo mana haya kul har ya ne? Nda a gar ni nkʼa har ya ne, ya mma ni naŋ ma koy nda ɲaali, nda dooniyaŋ, nda dunduŋ, nda kuntiji hẽeni. ");
INSERT INTO ses_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Koyne mo mana naŋ ya ba ay haamawey nda ay ize woyey summu! Lakkal jaŋante goy no nʼnʼa tee. ");
INSERT INTO ses_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ay goo nda hini ka haya hasara war se, amma Koyoo kaŋ ni baabaa gʼa gana šelaŋ ya ne cijin ka nee: ‹Hawgay, masi ba šenni henna har Yakuba se soko ifutu.› ");
INSERT INTO ses_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Sohõ kaŋ ni goo ma koy, zama nʼga buura ni baabaa hugoo ga, macin se nʼnʼay toorey zay?» ");
INSERT INTO ses_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakuba zaabi ka nee Labaŋ se: «Ya nka hunbur, zama ay hongu kaŋ nʼga hin ka ni ize woyey taa ay kone nda gaabi. ");
INSERT INTO ses_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Amma boraa kaŋ kone ni dii ni toorey, a masi huna! Ir armey jine, fisi ka dii hayaa kaŋ ti ni wane, mʼa zaa.» Yakuba si bay kaŋ Rašel na toorey zay. ");
INSERT INTO ses_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Labaŋ huru Yakuba hukkumoo ra, nda Leya wanoo ra, nda koŋŋa hinkaa waney ra, amma a mana duu haya kul. Kaŋ a fatta Leya hukkumoo ra kul, a koy Rašel wanoo ra. ");
INSERT INTO ses_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Amma Rašel nka toorey zaa kʼi tugu yoowaa gaaroo ra, de a goro i boŋ. Labaŋ na hukkumoo kul fisi, amma a mana duu ey. ");
INSERT INTO ses_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rašel nee nga baabaa se: «Masi dor, ay koyoo nda ay mana hin ka tun ma ne, woyey alaadaa maaganda se.» Labaŋ yee ka ceeci, a mana duu toorey. ");
INSERT INTO ses_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yakuba futu, a citi Labaŋ ga ka nee a se: «Man hooyanoo kaŋ ay nʼa tee, man zunuboo kaŋ se nʼga zuru ay bande? ");
INSERT INTO ses_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Nʼnʼay jinawey kul fisi, macin no ni dii a kaŋ ti ni hugoo wane? A kaa taray, ay borey nda ni borey jine hala i ma ciiti ir boro hinkaa game! ");
INSERT INTO ses_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Jiiri warankaa (20) kaŋ ay nʼa tee ni do ra, ni feejey wala ni hanciney mana bay ka zama, ya na bay ka gaarey kaŋ goo ni almaney ra hamey ŋaa. ");
INSERT INTO ses_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ya na bay ka kate ma ne alman kaŋ ganjihooga nʼa wii, agay no ma mursaa zaa. Nʼgʼay banandi woo kaŋ zayandi zaari here nda woo kaŋ zayandi cijin here. ");
INSERT INTO ses_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Zaari here konnoo gʼay kar, cijin here hargoo gʼay kar. Jirbi jaŋay ga duu agay. ");
INSERT INTO ses_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Jiiri waranka (20) no ay nʼa tee ni hugoo do! Ay goy ma ne jiiri woy cindi taaci (14) ni ize woy hinkaa maaganda se, jiiri iddu ay ga ni alman buuney kur, de mo nʼnʼay banaa barmay cee woy (10). ");
INSERT INTO ses_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Nda manʼti Koyoo kaŋ ay kaagaa gʼa gana, Ibirahima Koyoo, Koyoo kaŋ Isiyaka ga hunbur a, goo ay bande, hõ gar nʼnʼay naŋ ya koy nda ay kabe kooney. Amma Irkoy dii ay farayanoo nda goy šendaa kaŋ ay nʼa tee, a na ciitoo dunbu cijin.» ");
INSERT INTO ses_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labaŋ na Yakuba zaabi ka nee: «Woyey wey manʼti kala ay ize woyey, ngi izey manʼti kala ay haamawey, almaney wey manʼti kala agay wane. Hayey kul kaŋ nʼga dii ey manʼti kala agay wane. Sohõ macin no ay gʼa tee ay ize woyey nda ay haamawey kaŋ i nʼi daŋ aduɲɲa ra se? ");
INSERT INTO ses_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Kaa, ir ma cere noo amaana, agay nda ni, ir ma seede daŋ agay nda ni gamoo ra.» ");
INSERT INTO ses_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Yakuba na tondi foo zaa a nʼa kayandi kʼa tee hongandihaya. ");
INSERT INTO ses_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","A nee nga borey se: «Wa tondiyaŋ marga.» I na tondey zaa kʼi marga cere boŋ, i ŋaa no din ra tondey boŋ. ");
INSERT INTO ses_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labaŋ na nongoo maaɲoo daŋ Yegar-Sahaduta (maanaa «tondi margantaa kaŋ ga tee seede»). Yakuba na nongoo maaɲoo daŋ Galed (maanaa «tondi margantaa kaŋ ga seede»). ");
INSERT INTO ses_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labaŋ nee: «Hõ banda ga, tondi margantaa manʼti kala seede ir game!» Woo se a na nongoo maaɲoo daŋ Galed. ");
INSERT INTO ses_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","I ga nongoo cee koyne nda Mispa (maanaa «hawgaydogoo»), zama Labaŋ nee: «Yala Abadantaa ma agay nda ni kul hawgay ir masi amaanaa woo hoo waati kaŋ ir hun cere mo cire. ");
INSERT INTO ses_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Nda nʼnʼay ize woyey žilla, nda nʼna woy fooyaŋ daŋ i ga, hawgay manʼti boro no ma seede ir gamey ra, Irkoy ti seedaa kaŋ goo agay nda ni game!» ");
INSERT INTO ses_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Labaŋ nee koyne Yakuba se: «Nʼga dii tondi margantaa woo, nʼga dii tondoo kaŋ ga kay kaŋ ay nʼa daŋ agay nda ni game. ");
INSERT INTO ses_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Tondi margantaa ma tee seede, tondoo woo kaŋ ga kay ma tee seede kaŋ ay si bisa tondi margantaa nda tondoo kaŋ ga kay ga ka koy ifutu tee ma ne, ni mo si bisa i ga ka kaa ay heroo ra ka ifutu tee ya ne. ");
INSERT INTO ses_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Yala Ibirahima Koyoo nda Nahor Koyoo kaŋ ti ngi baabaa Koyoo ma ciiti ir game! Yakuba žee nda Koyoo kaŋ nga baabaa Isiyaka ga hunbur a.» ");
INSERT INTO ses_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yakuba na alman koosu kʼa tee sargari tondi hondey ra, a na nga borey kul cee kʼi ŋandi. I ŋaa cere bande, i na cijinoo tee no din ra. ");
INSERT INTO ses_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Labaŋ biya ka tun, a na nga haamawey nda nga ize woyey summu, a gaara i se jina, a willi nga do. ");
INSERT INTO ses_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yakuba na nga naarumaa fondaa zaa, Irkoy almalaykayaŋ nʼa kubay. ");
INSERT INTO ses_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Kaŋ Yakuba dii ey kul, a nee: «Woo ti Irkoy jamaa!» De a na nongoo din maaɲoo daŋ Mahanayim (maanaa «jama hinkaa»). ");
INSERT INTO ses_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yakuba na dontokawyaŋ sanba nga jine, nga armaa Eso do, Seyir gandaa ra, Edom hawsaa ra. ");
INSERT INTO ses_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","A nʼi yaamar ka nee: «Hayaa ne kaŋ war gʼa har ay koyoo Eso se, wa nee a se: ‹Ni tamoo Yakuba nee, nda manʼti hõ, nga gay nga ga goro ka waati tee Labaŋ do. ");
INSERT INTO ses_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","A nee nga duu hawyaŋ, nda farkayaŋ, nda alman buunayaŋ, nda baɲɲayaŋ, nda koŋŋayaŋ, nga sanba kʼa bayrandi nga koyoo se kaŋ ti ni hala ma alhormo tee nga se.›» ");
INSERT INTO ses_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Dontokey yee kate Yakuba do ka nee a se: «Ir koy ni armaa Eso do, nga mo goo ma ni kubay nda aru boro zangu taaci (400) kaŋ goo a bande.» ");
INSERT INTO ses_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Yakuba hanse ka hunbur, binoo dunbu. A na nga borey, nda alman buuney, nda ibeerey, nda nga yoowey fersi, fersi hinka. ");
INSERT INTO ses_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","A nee nga boŋ se: «Nda Eso kaŋ affoo boŋ kʼa kar, affaa kaŋ cindi ga hin ka hallasi.» ");
INSERT INTO ses_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Woo banda ga, Yakuba nee: «Irkoy, ay kaagaa Ibirahima Koyoo nda ay baabaa Isiyaka Koyoo! Abadantaa nee ya ne: ‹Yee ni gandaa ra, ni dumoo do, ay ga gomni tee ma ne.› ");
INSERT INTO ses_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ay ga hanse ka kacca anneemaa kul nda laadiryanoo kul kaŋ nʼnʼa tee ni tamoo se, zama hanoo kaŋ ay ga Žurdeŋ isaa woo deŋ, haya kul sii ay kone nda manʼti kala ay goboo, amma hõ jama hinka bara ya ne. ");
INSERT INTO ses_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ay gʼa wiri ni ga, mʼay hallasi agʼarmaa kaboo ra, Eso kaboo ra, zama ay ga hunbur a ma kaa ka agay, nda woyey, nda zankey kar. ");
INSERT INTO ses_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ni binde, ni nka nee ya ne: ‹Ay ga gomni tee ma ne, ay ga ni hayroo boobandi sanda teekoo labutaasoo kaŋ hinnaa si kabandi.›» ");
INSERT INTO ses_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","A na cijinoo tee no din ra a na gomni kaa nga almanoo kaŋ goo a kone ra kʼa noo nga armaa Eso se: ");
INSERT INTO ses_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","hancin boŋ zangu hinka (200) nda jindaaru boŋ waranka (20), nda feeji boŋ zangu hinka (200), nda gaaru boŋ waranka (20), ");
INSERT INTO ses_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","nda yoo boŋ waranza (30) kaŋ ga naanandi nda ngi izey, nda haw kobsi woytaaci (40), nda yaaru kobsi woy (10), nda farkey woy boŋ waranka (20), nda farkey aru boŋ woy (10). ");
INSERT INTO ses_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","A nʼi fay kur nda kur kʼi noo nga tamey se ka nee i se: «Wa koy ay jinoo ra, war ma alman kurey moorandi cere ka dira.» ");
INSERT INTO ses_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","A na ijinaa yaamar ka nee a se: «Nda Eso agʼarmaa na ni kubay, de a na ni hãa ka nee: ‹May wane ni? Man ra nʼga koy? May wane wey kaŋ goo ni jine?›, ");
INSERT INTO ses_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","mʼa zaabi ka nee: ‹Ni tamoo Yakuba wane nda ey. Hayaa no kaŋ a nʼa sanba nga koyoo Eso se. Nga hunday goo ir dumaa ga, a goo ma kaa.›» ");
INSERT INTO ses_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Yaamar follokaa no a nʼa tee ihinkantoo se nda ihinzantoo nda borey kul kaŋ ga dira almaney dumawey ga, a nee i se: «Woo no war gʼa har ay koyoo Eso se nda war nʼa kubay. ");
INSERT INTO ses_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","War ma nee a se: ‹Ni tamoo Yakuba hunday ne ma kaa, a goo ir dumaa ga.› Zama a nka nee nga boŋ se: ‹Ay ga binoo yaynandi nda hayaa woo kaŋ ga koy ay jine, woo banda ga, ay gʼa tenje, a ga hin ka tee a mʼay barraku.›» ");
INSERT INTO ses_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Almaney koy jinoo ra, de a na cijinoo din tee farroo ra. ");
INSERT INTO ses_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Yakuba tun cijinoo ra, a na nga wande hinkaa, nda nga koŋŋa hinkaa, nda nga zanka woy cindi faa (11) zaa ka koy bisa ka isaa yawdogey deŋ kaŋ ti Yabok. ");
INSERT INTO ses_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","A nʼi zaa ka haroo deŋ nda haya kul kaŋ ti nga wane. ");
INSERT INTO ses_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Yakuba cindi nga hinne. Aru foo gurgay a bande hala moo boo. ");
INSERT INTO ses_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Kaŋ aroo bay kaŋ nga si hin a kul, gurgaa ra a na Yakuba kar baggal biroo ga hala a goyri. ");
INSERT INTO ses_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","A nee: «Ay naŋ ya koy, zama moo boo.» Yakuba zaabi ka nee a se: «Ay si ni naŋ nda mana gaara ya ne.» ");
INSERT INTO ses_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","A nʼa hãa ka nee: «Macin ti ni maaɲoo?» A nee a se: «Yakuba.» ");
INSERT INTO ses_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","A yee ka nee a se: «Ni maaɲoo si yee ka tee Yakuba, Izirayel nda i ga ni cee (maanaa ‹a gurgay Irkoy bande›), zama ni nka gurgay Irkoy bande nda borey bande, ni hin.» ");
INSERT INTO ses_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakuba nʼa hãa ka nee: «Ay gʼa wiri ni ga, ni maaɲoo har ya ne.» A nʼa zaabi ka nee: «Macin se nʼgʼay hãa nda ay maaɲoo?» A gaara a se dogoo din da ra. ");
INSERT INTO ses_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yakuba na nongoo din maaɲoo daŋ Penuwel (maanaa «Irkoy ndumoo»). A nee: «Zama ay dii Irkoy moo nda moo, de woo kul ra ay hundoo hallasi.» ");
INSERT INTO ses_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Waynaa kay waatoo kaŋ a ga fatta Penuwel. A ga solli cewoo ga. ");
INSERT INTO ses_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Woo se hala hõ Izirayel borey si baggal biri ham ŋaa, zama nongoo kaŋ ga Yakuba baggal biroo ga dobu maray. ");
INSERT INTO ses_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakuba na nga boŋoo jer, de a ga Eso honnay kaŋ goo ma kaa, aru boro zangu taaci (400) goo a bande. A na zankey zamna Leya, nda Rašel, nda koŋŋa hinkaa game. ");
INSERT INTO ses_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","A na koŋŋey nda izey daŋ jine, Leya nda nga waney goo dumawey ga, Rašel nda Isufi goo banda. ");
INSERT INTO ses_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Nga hunday huru jiney ra, a ga dira a ga gunguma hala ganda cee iyye hala nga armaa do. ");
INSERT INTO ses_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Eso zuru kʼa kubay, a na nga boŋ warra jindoo ga kʼa naagu nga gandoo ra kʼa summu, i hẽe. ");
INSERT INTO ses_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Kaŋ Eso na nga boŋoo jer, a dii woyey nda zankey, a nee: «Mayyaŋ ti wey ni bande?» Yakuba zaabi ka nee: «Zankey no kaŋ Irkoy nʼi doonandi ni tamoo se.» ");
INSERT INTO ses_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Koŋŋey nda ngi izey man, i gunguma. ");
INSERT INTO ses_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Leya mo nda nga izey man, i gunguma. Isufi nda Rašel man, i gunguma. ");
INSERT INTO ses_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Eso yee ka nee: «Macin no nʼgʼa tee almaney wey se kaŋ ay nʼi kubay?» A nʼa zaabi ka nee: «Ni kaŋ ti ay koyoo do, ay ga baa ya duu alhormo.» ");
INSERT INTO ses_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Amma Eso nee: «Ay wanoo gʼay wasa, agʼarmaa, gaabu i ga.» ");
INSERT INTO ses_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakuba zaabi ka nee: «Suuri, masi woo tee! Alhormo tee ya ne, ma beeraa woo taa ay ga, zama takaa kaŋ nda nʼnʼay kubay ga hima nda Irkoy kubayyan, ni yadda ay ga. ");
INSERT INTO ses_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Gomnoo dii kaŋ kaa ma ne, zama Irkoy ka doonandi ya ne, haya kul goo ya ne.» Yakuba na Eso gaabi, a nʼa taa. ");
INSERT INTO ses_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Eso nee: «Ir ma koy, ir ma hanga cere, ay ga dira ni bande.» ");
INSERT INTO ses_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","A nʼa zaabi ka nee: «Ay koyoo, nʼga bay kaŋ zankey sii nda gaabi, feejiyaŋ nda hawyaŋ kaŋ ga naanandi goo ay ga, nda ir nʼi cahãndi zaari folloku, almaney kul ga halaci. ");
INSERT INTO ses_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ay gʼa wiri ni ga, ay koyoo ma koy nga tamoo jine. Agay, ay ga dira mossoyaada almaney kaŋ goo ay jine cewey bande nda zankey cewey bande hala ya too ni do, ay koyoo gandaa ra kaŋ se i ga nee Seyir.» ");
INSERT INTO ses_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Eso nee: «Adiši ay ga borey jere foo naŋ ni bande.» Yakuba nʼa zaabi ka nee: «Ay koyoo, masi woo tee, alhormo de no ay gʼa wiri ni ga!» ");
INSERT INTO ses_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Zaaroo din kul ra, Eso na Seyir gandaa fondaa zaa. ");
INSERT INTO ses_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yakuba hunday naaru ka koy Sukot here. A na hugu cin nga boŋ se, a na tendeyaŋ tee almaney se: woo se i ga nee nongoo din se Sukot (maanaa «tendeyaŋ»). ");
INSERT INTO ses_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Woo banda ga, Yakuba too nda baani Šekem koyraa ra kaŋ goo Kanaŋ gandaa ra, kaŋ a ga hun Padaŋ-Aram. A na nga hukkumoo cin koyraa miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","A na farroo jeroo kaŋ ra a na nga hukkumoo cin day nzorfu kaaray tamma boŋ zangu (100) Hamor izey ga kaŋ ti Šekem baabaa. ");
INSERT INTO ses_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","De no din ra a na sargari tonadoo cin kʼa kayandi kaŋ a na maaɲoo daŋ «El kaŋ ti Izirayel Koyoo». ");
INSERT INTO ses_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Han foo Dina kaŋ ti ize woyoo kaŋ Leya duu a Yakuba se, fatta ka koy Šekem koyraa laamaa zankawoyey guna. ");
INSERT INTO ses_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Koyraa laamaa boŋkoynoo kaŋ maaɲoo ti Hamor Hewi boraa, izʼaroo kaŋ maaɲoo ti Šekem dii a. A nʼa dii ka marga nda a nda gaabi. ");
INSERT INTO ses_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Woo banda ga, Šekem na Dina, Yakuba ize woyoo bajoo zaa nga binoo ra. A baa zankawoyoo, a šelaŋ a se hala binoo ma kani nga ga. ");
INSERT INTO ses_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Šekem nee nga baabaa Hamor se: «Ay hiijandi zankawoyoo woo.» ");
INSERT INTO ses_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakuba maa kaŋ a gum nga ize woyoo Dina boŋ. Izʼarey koy nda nga almaney hawsaa ra, a mana haya kul har hala waatoo kaŋ ra i yee kate. ");
INSERT INTO ses_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamor, Šekem baabaa, fatta ka koy Yakuba do ka šelaŋ a se. ");
INSERT INTO ses_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Waatoo kaŋ Yakuba izey kaa ka hun hawsaa ra, i maa alhabaroo. Biney maray, i hanse ka futu hayaa kaŋ se Šekem na goy futaa woo tee Izirayel hugoo ra, ka kani nda Yakuba ize woyoo, woo ti haya kaŋ si hima ka tee. ");
INSERT INTO ses_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamor šelaŋ i se ka nee: «Šekem, ay izʼaroo na war ize woyoo bajoo zaa nga binoo ra, ay gʼa wiri war ga, war mʼa noo a se hiijay. ");
INSERT INTO ses_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Wa waafaku nda ir, war gʼir noo war woyey hiijay se, war mo ma hiiji ir waney. ");
INSERT INTO ses_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Wa goro ir bande, gandaa goo war jine. Wa cindi, war ma day ka bara, war ma duu nonguyaŋ.» ");
INSERT INTO ses_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Šekem mo nee woyoo baabaa nda armey se: «Wa alhormo tee ya ne! Hayaa kaŋ war gʼa har, ay gʼa noo war se. ");
INSERT INTO ses_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Wa hiijay alman boobo daŋ ay ga nda gomni beeri, haya kul kaŋ war nʼa har, ay gʼa noo, wa yadda de kʼay noo woyoo ya hiiji a.» ");
INSERT INTO ses_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Yakuba izʼarey na carmay ka tuuru Šekem nda nga baabaa Hamor se, zama Šekem nka gum ngi woymaa Dina boŋ. ");
INSERT INTO ses_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","I nee i se: «Ir si hin ka woo tee kʼir woymaa noo aru se kaŋ ti jofolo, haawi no ir se. ");
INSERT INTO ses_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Hayaa folloku ga ir ga yadda war se kaŋ ti, nda war nʼir takaa tee ka arey kul kaŋ goo war ra daŋbangu. ");
INSERT INTO ses_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Woo ra ir ga war noo ir ize woyey hiijay se, de ir ga war waney zaa, ir ga goro war bande ka tee jama folloku. ");
INSERT INTO ses_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Amma nda war si baa war ma haŋajer ir se ka hurubangu, ir gʼir woymaa zaa ka koy.» ");
INSERT INTO ses_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ngey šenney kan Hamor nda nga izoo Šekem se. ");
INSERT INTO ses_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Aru soogaa mana gay kaŋ a na hayaa tee, zama a ga baa Yakuba ize woyoo. Koyne mo a ga hanse ka bara nda meešenni borey kul do nga baabaa hugoo ra. ");
INSERT INTO ses_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamor nda Šekem, nga izoo, koy ngi koyraa miɲoo ga ka šelaŋ ngi koyraa borey se ka nee: ");
INSERT INTO ses_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«Borey wey goo ir bande nda alaafiyaa, i ma cindi ir gandaa ra ka day ka bar. Nga ne, ir gandaa ga hay, i ma doo zaa. Ir ga ngi woyey zaa ka hiiji ey, ir mo gʼi noo ir waney. ");
INSERT INTO ses_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Nga binde, borey wey nee kaŋ hayaa folloku ra ngi ga goro ir bande ka tee jama folloku: hayaa manʼti kala aru kul kaŋ goo ir ra ma hurubangu sanda ngi takaa. ");
INSERT INTO ses_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ngi alman kurey, nda ngi hayey, nda ngi adabbawey kul si tee ir wane wala? Ir ma yadda hinne hala i ma goro ir bande.» ");
INSERT INTO ses_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Borey kul kaŋ kaa koyraa miɲoo ga na haŋajer ka yadda Hamor nda nga izoo Šekem se. Aru kul kaŋ kaa koyraa miɲoo ga hurubangu. ");
INSERT INTO ses_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Jirbi hinzantoo hane, kaŋ i ga hanse ka dor, Yakuba izʼaru hinka, Simewoŋ nda Lewi kaŋ ti Dina armey, affoo kul na nga takubaa zaa, i kaŋ koyraa ra kaŋ ga hongu nga goo alaafiya ra, de i na arey kul wii. ");
INSERT INTO ses_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","I na Hamor nda nga izoo Šekem mo wii nda takubaa, i na Dina fattandi Šekem hugoo ra, de i nʼa ka koy. ");
INSERT INTO ses_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Yakuba izʼarey jerey kaa ka bukawey hayey zaa, i na koyraa kom kaŋ ra i gum ngi woymaa boŋ. ");
INSERT INTO ses_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","I na ngey alman buuney, nda ibeerey, nda farkey, haya kul kaŋ goo i se koyraa ra, nda haya kul kaŋ goo i se hawsaa ra, i nʼi taa. ");
INSERT INTO ses_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","I na ngey almanoo, nda zankey nda woyey kul zaa ka haya kul kom kaŋ goo ngi hugey ra. ");
INSERT INTO ses_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yakuba nee Simewoŋ nda Lewi se: «War nʼay tooɲe kʼay tee konnayhaya Kanaŋ borey nda Ferezi borey se kaŋ goo gandaa ra. Ay sii nda boro boobo, i ga marga ka kaa ay ga, i gʼay kar hala ya dere sõy, agay nda ay hugoo.» ");
INSERT INTO ses_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","I nʼa zaabi ka nee: «A ga hima kʼir woymaa tee sanda woykuuru wala?» ");
INSERT INTO ses_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Han foo Irkoy nee Yakuba se: «Tun ni boŋ ga, žigi ka koy Betel, ma goro no din. Ma sargari tonadoo cin no din ni Koyoo maaɲoo ga kaŋ bangay ma ne waatoo kaŋ nʼga zuru ni armaa Eso se.» ");
INSERT INTO ses_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Yakuba nee nga alaayaney nda nga borey kul se: «Wa koy waaney derandi kaŋ goo war kone, tooru doo sii ne ra, wa war boŋ henanandi ka kaaray, war ma darbay barmay. ");
INSERT INTO ses_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ir ma tun ka žigi ka koy Betel, no din ra ay ga sargari tonadoo cin ir Koyoo maaɲoo ga kaŋ nʼay zaabi ay binemarayyanoo zaaroo hane, de mo kaŋ cindi ay bande ay naarumaa ra.» ");
INSERT INTO ses_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","I na Yakuba noo koy waaney kul kaŋ cindi i kone nda korbawey kaŋ cindi haŋawey ra. Yakuba nʼi fiji tuuriɲaa beeroo cire kaŋ goo Šekem jeroo ga. ");
INSERT INTO ses_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Woo banda ga, i koy. Koyrawey kaŋ goo jere ga, Irkoy nʼi hunburandi hala nongu kaŋ ra i mana Yakuba izey gaarandi. ");
INSERT INTO ses_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakuba nda borey kul kaŋ goo a bande too Luz kaŋ se i ga nee Betel kaŋ goo Kanaŋ gandaa ra. ");
INSERT INTO ses_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","No din ra a na sargari tonadoo cin, de a na nongoo cee nda El-Betel (maanaa «Betel Koyoo»), zama no din ra Irkoy na nga boŋ cebe a se waatoo kaŋ a ga zuru nga armaa se. ");
INSERT INTO ses_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Debora faati kaŋ ti Rebeka biirikaa. A suturandi Betel se ganda, tuuri beeroo cire, de i na maaɲoo daŋ «Hẽeney tuuri beeroo». ");
INSERT INTO ses_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Waatoo kaŋ Yakuba kaa ka hun Padaŋ-Aram, Irkoy bangay a se koyne, a na albarka daŋ a ra. ");
INSERT INTO ses_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Irkoy nee a se: «Ni maaɲoo ti Yakuba, amma hõ banda ga, ni maaɲoo si yee ka tee Yakuba, a ga tee Izirayel.» Takaa woo nda a na Izirayel maaɲoo daŋ a ga. ");
INSERT INTO ses_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Irkoy nee a se koyne: «Agay ti Irkoy, Hini-kul-koyoo. Hay, ma boobo! Dumi nda dumi booboyaŋ ga hun ni ga, nʼga kokoyyaŋ hay. ");
INSERT INTO ses_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Gandaa kaŋ ay nʼa noo Ibirahima nda Isiyaka se, ay gʼa noo ma ne. Ni hayroo kaŋ ga cindi ni dumaa ga, ay gʼi noo gandaa din.» ");
INSERT INTO ses_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Woo banda ga, Irkoy žigi ka hun nongoo kaŋ ra a šelaŋ a bande ra. ");
INSERT INTO ses_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakuba na hongandihaya foo kayandi nongoo kaŋ ra Irkoy šelaŋ a se, hongandihayaa tondi nda a nʼa tee kaŋ a na sargari hari-hari doori a boŋ ka jii doori a ga. ");
INSERT INTO ses_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yakuba na nongoo kaŋ ra Irkoy šelaŋ a bande maaɲoo daŋ Betel (maanaa «Irkoy hugoo»). ");
INSERT INTO ses_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Yakuba nda nga borey hun Betel. Diray cindi ngi nda koyraa game kaŋ se i ga nee Efrata, waatoo kaŋ Rašel ga duu nga boŋ, a hanse ka fara hala a ga zumandi. ");
INSERT INTO ses_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Hayyanoo taamaroo ra, hayandikaa nee a se: «Bine tee, zama izʼaru no ni yee ka duu.» ");
INSERT INTO ses_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Waatoo kaŋ hundoo ga baa ka hun, zama hundi gurzugaa ra a goo, a na zankaa maaɲoo daŋ Ben-Oni (maanaa «agʼalmasiiba izoo»), amma baaboo nʼa cee nda Benžameŋ (maanaa «ay kabe gumaa izoo»). ");
INSERT INTO ses_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rašel faati, a suturandi Efrata fondaa ra. Efrata da ti Betelehem. ");
INSERT INTO ses_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakuba na tondi foo kayandi kʼa tee hongandihaya saaraa boŋ. Rašel saaraa hongandihayaa no kaŋ ga bara hala hõ zaaroo. ");
INSERT INTO ses_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Woo banda ga, Izirayel gana, a na nga hukkumoo cin nongu foo kaŋ se i ga nee Migdal-Eder dumaa ga. ");
INSERT INTO ses_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Izirayel goraa ra, nongoo din ra, Rubeŋ koy marga nda Bilha kaŋ ti nga baabaa wahayoo. Izirayel maarʼa. Yakuba sii nda kala izʼaru woy cindi hinka (12). ");
INSERT INTO ses_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Leya izʼarey ti: Yakuba ize jinaa kaŋ ti Rubeŋ, nga banda ga, Simewoŋ, nda Lewi, nda Žuda, nda Isakar, nda Zabuloŋ. ");
INSERT INTO ses_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rašel izʼarey ti: Isufi nda Benžameŋ. ");
INSERT INTO ses_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Bilha, Rašel koŋŋaa, izʼarey ti: Dan nda Neftali. ");
INSERT INTO ses_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Zilpa, Leya koŋŋaa, izʼarey ti: Gad nda Ašer. Wey ti Yakuba izʼarey kaŋ a duu ey Padaŋ-Aram. ");
INSERT INTO ses_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakuba koy nga baabaa Isiyaka do Mamre kaŋ goo Kiryat-Arba kaŋ se i ga nee Hebroŋ kaŋ ra Ibirahima nda Isiyaka goro ka waati tee. ");
INSERT INTO ses_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isiyaka duu jiiri zangu nda woyyaaha (180) aloomur. ");
INSERT INTO ses_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Isiyaka hundoo hun, a faati. A duu aloomur kuku, a koy nga hayragey gar alaahara. Nga izʼarey Eso nda Yakuba nʼa sutura. ");
INSERT INTO ses_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Eso kaŋ se i ga nee koyne Edom, hayroo ne. ");
INSERT INTO ses_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Eso mana nga wandey zaa kala Kanaŋ gandaa ize woyey ra: Ada kaŋ ti Eloŋ Heti boraa ize woyoo, nda Oholibama, Ana ize woyoo kaŋ ti Siboŋ Hewi boraa ize woyoo. ");
INSERT INTO ses_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Wey banda ga, Basemat kaŋ ti Isimayel ize woyoo, Nebayot woymaa. ");
INSERT INTO ses_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada duu Eso se Elifaz, Basemat duu Rehuwel, ");
INSERT INTO ses_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama duu Yewuš, nda Yalam, nda Kora. Wey ti Eso izʼarey kaŋ a duu ey Kanaŋ gandaa ra. ");
INSERT INTO ses_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Han foo Eso na nga wandey, nda nga izʼarey, nda nga ize woyey, nda nga hugoo borey kul, nda nga alman kurey, nda nga adabbawey, nda gomni kul kaŋ a duu a Kanaŋ gandaa ra, a nʼi zaa ka koy goro ganda foo here kaŋ ga mooru nga armaa Yakuba. ");
INSERT INTO ses_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Zama hayaa kaŋ se ngi almaney ga hanse ka boobo hala nongu kaŋ ra i si hin ka goro cere ra. Gandaa kaŋ ra i goo ma goro si hin kʼi zaa ngi almaney maaganda se. ");
INSERT INTO ses_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Woo ka kate Eso goro tondi hondey ra kaŋ ti Seyir gandaa. Eso da se i ga nee Edom. ");
INSERT INTO ses_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Eso ti Edom borey baabaa, nga hayroo ne kaŋ goo tondi hondey ra kaŋ ti Seyir gandaa. ");
INSERT INTO ses_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Eso izʼarey maaɲey ne: nga wandoo Ada izʼaroo ti Elifaz, nga wandoo Basemat izʼaroo ti Rehuwel. ");
INSERT INTO ses_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifaz izʼarey ti: Temaŋ, nda Omar, nda Sefo, nda Gatam, nda Kenaz. ");
INSERT INTO ses_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna ti wahayoo kaŋ Elifaz, Eso izʼaroo nʼa zaa hiijay se. A duu a se Amalek. Wey ti Ada, Eso wandoo haamawey. ");
INSERT INTO ses_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Rehuwel izʼarey ti: Nahat, nda Zera, nda Šamma nda Miza. Wey ti Basemat, Eso wandoo haamawey. ");
INSERT INTO ses_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Oholibama kaŋ ti Eso wandoo manʼti kala Ana, Siboŋ ize woyoo, ize woyoo, nga izey ne: a duu Eso se Yewuš, nda Yalam, nda Kora. ");
INSERT INTO ses_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Alkabiilawey boŋkoyney kaŋ hun Eso izʼarey ra maaɲey ti: Elifaz, Eso izʼaru jinaa izʼarey maaɲey ne: boŋkoynoo kaŋ maaɲoo ti Temaŋ, nda boŋkoynoo Omar, nda boŋkoynoo Sefo, nda boŋkoynoo Kenaz, ");
INSERT INTO ses_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","nda boŋkoynoo Kora, nda boŋkoynoo Gatam, nda boŋkoynoo Amalek. Wey ti boŋkoyney kaŋ hun Elifaz ga Edom gandaa ra, i manʼti kala Ada haamʼarey. ");
INSERT INTO ses_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Rehuwel kaŋ ti Eso izʼaroo, izʼarey maaɲey ne: boŋkoynoo Nahat, nda boŋkoynoo Zera, nda boŋkoynoo Šamma nda boŋkoynoo Miza. Wey ti boŋkoyney kaŋ hun Rehuwel ga Edom gandaa ra. I manʼti kala Basemat, Eso wandoo haamʼarey. ");
INSERT INTO ses_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Oholibama kaŋ ti Eso wandoo, hayroo ti: boŋkoynoo Yewuš, nda boŋkoynoo Yalam, nda boŋkoynoo Kora. Wey ti boŋkoyney kaŋ hun Oholibama ga, Eso wandoo kaŋ ti Ana ize woyoo. ");
INSERT INTO ses_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Wey ti Eso izʼarey nda ngi alkabiilawey boŋkoyney. Eso da se i ga nee Edom. ");
INSERT INTO ses_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Seyir kaŋ ti Hori boraa kaŋ bay ka goro gandaa ra, hayroo ne: Lotaŋ, nda Šobal, nda Siboŋ, nda Ana, ");
INSERT INTO ses_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","nda Dišoŋ, nda Eser, nda Dišaŋ. Wey ti Hori borey boŋkoyney, Seyir hayroo, Edom gandaa ra. ");
INSERT INTO ses_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotaŋ izʼarey ti Hori nda Hemam. Lotaŋ woymaa ti Timna. ");
INSERT INTO ses_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Šobal izʼarey ti: Aliwaŋ, nda Manahat, nda Ebal, nda Šefo, nda Onam. ");
INSERT INTO ses_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Siboŋ izʼarey ti Aya nda Ana. Ana follokaa no ka duu hari saajoo ra, waatoo kaŋ a koy nga baabaa Siboŋ farkey kur. ");
INSERT INTO ses_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana izey ti: Dišoŋ nda Oholibama kaŋ ti Ana ize woyoo. ");
INSERT INTO ses_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dišoŋ izʼarey ti: Hemdaŋ, nda Ešbaŋ, nda Yitraŋ, nda Keraŋ. ");
INSERT INTO ses_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eser izʼarey ti: Bilhaŋ, nda Zawaŋ, nda Akaŋ. ");
INSERT INTO ses_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dišaŋ izʼarey ti Utus nda Araŋ. ");
INSERT INTO ses_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Hori borey boŋkoyney ne: boŋkoynoo Lotaŋ, nda boŋkoynoo Šobal, nda boŋkoynoo Siboŋ, nda boŋkoynoo Ana, ");
INSERT INTO ses_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","nda boŋkoynoo Dišoŋ, nda boŋkoynoo Eser, nda boŋkoynoo Dišaŋ. Wey ti Hori borey boŋkoyney, alkabiila nda alkabiila Seyir gandaa ra. ");
INSERT INTO ses_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Za kokoy mana Izirayel borey laama, kokoyey kaŋ laama Edom gandaa ra maaɲey ne: ");
INSERT INTO ses_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, Bewor izʼaroo na Edom laama. Nga koyraa maaɲoo ti Dinhaba. ");
INSERT INTO ses_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Waatoo kaŋ Bela buu, Zera izʼaroo Yobab kaŋ ga hun Bosra huru dogoo ra. ");
INSERT INTO ses_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Waatoo kaŋ Yobab buu, Hušam huru dogoo ra, a si hun kala Temaŋ borey gandaa ra. ");
INSERT INTO ses_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Waatoo kaŋ Hušam buu, Bedad izʼaroo Hadad huru dogoo ra. Nga no ka Majaŋ borey kar ka hin ey Mowab gandaa ra. Nga koyraa maaɲoo ti Awit. ");
INSERT INTO ses_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Waatoo kaŋ Hadad buu, Samla kaŋ ga hun Masreka huru dogoo ra. ");
INSERT INTO ses_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Waatoo kaŋ Samla buu, Šawul kaŋ ga hun Rehobot kaŋ goo Efrat isaa miɲoo ga huru dogoo ra. ");
INSERT INTO ses_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Waatoo kaŋ Šawul buu, Akbor izʼaroo Bal-Hanaŋ huru dogoo ra. ");
INSERT INTO ses_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Waatoo kaŋ Bal-Hanaŋ, Akbor izʼaroo buu, Hadar huru dogoo ra, nga koyraa maaɲoo ti Pawu. Wandoo maaɲoo ti Mehetabel. Mehetabel ti Matred ize woy. Matred ti Me-Zahab ize woy. ");
INSERT INTO ses_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Boŋkoyney kaŋ hun Eso ga maaɲey ne, affoo kul nda nga alaayan beeroo, nda nga gorodogoo, nda nga maaɲoo: Timna, nda Alewa, nda Yetet, ");
INSERT INTO ses_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","nda Oholibama, nda Ela, nda Pinoŋ, ");
INSERT INTO ses_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","nda Kenaz, nda Temaŋ, nda Mibsar, ");
INSERT INTO ses_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","nda Magdiyel, nda Iram. Wey ti Edom boŋkoyney, affoo kul nda nga gorodogoo gandaa kaŋ i nʼa mayray ra. Eso ti Edom borey kaagaa. ");
INSERT INTO ses_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakuba goro Kanaŋ gandaa ra, nongoo kaŋ ra baaboo bay ka cindi. ");
INSERT INTO ses_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Yakuba hayroo fillaa ti woo. Waatoo kaŋ Isufi goo nda jiiri woy cindi iyye (17), a ga koy almaney kur, nga nda nga armey. Zankaa woo ga hanga nga baabaa foo izey bande kaŋ ti Bilha nda Zilpa izʼarey. A ga ngi šenni laaley ka too ngi baabaa do. ");
INSERT INTO ses_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Woo kaa ka gar Izirayel ga baa Isufi ka bisa nga zankey kul, zama nga žeenayyanoo ra a duu a, a na darbay caarante foo tee a se. ");
INSERT INTO ses_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Kaŋ nga armey ga dii kaŋ ngi baabaa ga bagʼa ka bisa ngey kul, i konna a, de i si hin ka šelaŋ a se nda baji. ");
INSERT INTO ses_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Isufi handiri, de a nʼa deede nga armey se, woo yee ka kate i ma konna a ka tonton. ");
INSERT INTO ses_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","A nee i se: «Wa maa handiroo kaŋ ay nʼa tee se! ");
INSERT INTO ses_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ir mma goo ma jeeni terenjiyaŋ haw faarey ra kaŋ dogoo din da ay terenjoo tun ka kay nga boŋ ga, war waney gʼa kuubi kʼa bere, de i ga gunguma jinoo ra.» ");
INSERT INTO ses_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Nga armey nʼa zaabi ka nee: «Macin! Ni mmʼir laama sanda kokoy? Ni mmʼir juwal sanda boŋkoyni wala?» I yee ka konna a ka tonton nga handirey nda nga šenney maaganda se. ");
INSERT INTO ses_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","A yee ka handiri koyne, de a nʼa filla nga armey se. A nee: «Ay na handiri foo tee koyne. Handiroo ra ay dii waynaa nda handoo nda handaray woy cindi foo (11) ga gunguma ya ne.» ");
INSERT INTO ses_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","A nʼa deede nga baabaa nda nga armey se. Baaboo citi a ga ka nee: «Cin handiri ti woo? Adiši agay, nda ni ɲaa, nda ni armey no ma kaa ka gunguma ma ne?» ");
INSERT INTO ses_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Isufi armey canse a ga, amma baaboo gaabu šennoo ga. ");
INSERT INTO ses_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Han foo Isufi armey koy ngi baabaa almaney kur koyraa here kaŋ se i ga nee Šekem. ");
INSERT INTO ses_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Izirayel nee Isufi se: «Manʼti Šekem here no ni armey ga koy kur? Kaa, ya ni sanba i do.» A nʼa zaabi ka nee: «Agay ne, ay baabaa!» ");
INSERT INTO ses_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Izirayel nee a se: «Ay gʼa wiri ni ga, koy ma dii wala ni armey nda almaney ga saabu, ma kaa ka ngi alhabar tee ya ne.» Takaa woo nda a nʼa sanba Hebroŋ gooroo ra, Isufi koy Šekem here. ");
INSERT INTO ses_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Aru foo nʼa kubay saajoo ra, a dere. Aroo nʼa hãa ka nee: «Macin no nʼgʼa wiri?» ");
INSERT INTO ses_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","A nʼa zaabi ka nee: «Agʼarmey no ay gʼi wiri. Ay gʼa wiri ni ga, nda nʼga nongoo bay kaŋ ra i koy almaney kur, mʼa har ya ne.» ");
INSERT INTO ses_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Aroo nee a se: «I hun ne ra, ay ga maa i ga nee ngi ma koy koyraa here kaŋ se i ga nee Dotaŋ.» Isufi hanga nga armey ceebandawey, a duu ey Dotaŋ. ");
INSERT INTO ses_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Za a mana too kate i do, i gʼa honnay nongu mooro ra, i marga ka waafaku ka nee ngi mʼa wii. ");
INSERT INTO ses_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","I nee cere se: «Handirey baabaa ne ma kaa. ");
INSERT INTO ses_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Wa kaa, ir mʼa wii, ir mʼa warra dayey wey affoo ra, de ir ma nee kaŋ ganjihooga kʼa ŋaa. Waatoo din ir ga dii haya kaŋ nga handirey ga ti a!» ");
INSERT INTO ses_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Rubeŋ maa šennoo, a baa nga mʼa hallasi kabey ra. A nee: «Ir masi hundoo kaa.» ");
INSERT INTO ses_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","A yee ka nee i se: «War masi kuri mun. Wʼa warra dayoo woo ra kaŋ ne saajoo ra, amma war masʼa wii.» A nka baa nga mʼa hallasi kʼa ka yee baaboo do. ");
INSERT INTO ses_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Waatoo kaŋ Isufi too kate nga armey do, i na nga darbaa kaa jindoo ra, darbay caarantaa kaŋ goo a ga. ");
INSERT INTO ses_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","I nʼa dii, i nʼa warra dayoo ra. Hari sii a ra, nga koonoo no. ");
INSERT INTO ses_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Woo banda ga, i goro ka ŋaa. I na Isimayel borey dirakawyaŋ honnay i ga kaa, ngi nda ngi yoo jeejewey ka hun Galad ka doo Misira gandaa ra. Jeejewey manʼti kala day-day, nda jii, nda dugu. ");
INSERT INTO ses_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Kaŋ Žuda dii ey, a nee nga armey se: «Macin no ir ga duu a nda ir nʼir armaa wii kʼa tugu? ");
INSERT INTO ses_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Wa kaa, ir mʼa neere Isimayel borey se, ir masʼa wii, zama ir armaa no kaŋ ti ir hamoo.» I yadda a se. ");
INSERT INTO ses_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Waatoo kaŋ Majaŋ maamalakawyaŋ ga bisa, Isufi armey nʼa cendi kʼa kaa dayoo ra kʼa neere Isimayel borey se nzorfu kaaray tamma boŋ waranka (20). Borey din koy nda a Misira gandaa ra. ");
INSERT INTO ses_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Woo banda ga, Rubeŋ yee kate dayoo do, de a dii kaŋ Isufi sii a ra, a na nga darbawey kaŋ goo jindoo ra kottu. ");
INSERT INTO ses_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","A yee nga armey do ka nee i se: «Zankaa sii no! Sohõ cin no ay ga ti a?» ");
INSERT INTO ses_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","I na Isufi darbaa zaa, i na jindaaru foo koosu, de i na darbaa miti kuroo ra. ");
INSERT INTO ses_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","I na darbay caarantaa sanba ngi baabaa do ka nee a se: «Woo ti hayaa kaŋ ir duu a! Guna wala ni izʼaroo darbaa no wala manʼti nga no.» ");
INSERT INTO ses_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","A nʼa bay, de a nee: «Ay izoo darbaa no! Ganjihooga kʼa ŋaa, Isufi wiiyandi!» ");
INSERT INTO ses_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yakuba na nga jinde bankaarawey kottu. A na nga gamoo haw nda saaku kasa, de a na waati kuku tee a ga nga izoo hẽe. ");
INSERT INTO ses_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Nga izʼarey nda ize woyey kul tun ka koy ka binoo yaynandi, amma a wanji ka dangay. A nee: «Hẽenoo ra ay ga koy agʼizʼaroo gar alaahara.» A cindi a ga hẽe. ");
INSERT INTO ses_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Woo kaa ka gar Majaŋ borey na Isufi neere Misira gandaa ra Potifar se kaŋ ti Firawuuna goykaw beerey affoo, nga lakkalkey jineboraa. ");
INSERT INTO ses_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Zaman follokaa ra, Žuda hibi nga armey ga ka koy goro Adulam boraa do kaŋ maaɲoo ti Hira. ");
INSERT INTO ses_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","No din ra Žuda dii Kanaŋ aru foo kaŋ maaɲoo ti Šuwa, ize woyoo. A hiiji a, a gorokasinay nda a. ");
INSERT INTO ses_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","A tee alhaamidu, a na izʼaru foo daŋ aduɲɲa ra kaŋ Žuda na maaɲoo daŋ Er. ");
INSERT INTO ses_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","A yee ka gunde zaa, a na izʼaru daŋ aduɲɲa ra kaŋ a na maaɲoo daŋ Onaŋ. ");
INSERT INTO ses_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","A yee ka izʼaru daŋ aduɲɲa ra kaŋ a na maaɲoo daŋ Šela. Žuda sii kala Kezib waatoo kaŋ izoo woo ga hayandi. ");
INSERT INTO ses_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Jiiriyaŋ banda ga, Žuda na Er hiijandi kaŋ ti nga izʼaru jinaa, woyoo maaɲoo ti Tamar. ");
INSERT INTO ses_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Er, Žuda ize jinaa manʼti kala boro futu Abadantaa se. Abadantaa nʼa wii. ");
INSERT INTO ses_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Žuda nee Onaŋ se: «Nʼga hima ka hiiji ni albora woyoo hala ma duu hayyan ni armaa se.» ");
INSERT INTO ses_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Amma Onaŋ faham kaŋ izey kaŋ a gʼi hay si huru nga maaɲoo ga, woo se waati kul kaŋ a ga marga nda woyoo, a mma naŋ almaaniyoo ma mun laboo ra hala nga masi duu nga armaa se hayyan. ");
INSERT INTO ses_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Hayaa kaŋ Onaŋ nʼa tee manʼti kala ifutu Abadantaa se, a na nga mo wii. ");
INSERT INTO ses_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Žuda nee nga nzura woyoo Tamar se: «Koy goro ni baabaa hugoo ra, masi hiiji hala ay izʼaroo Šela ma beeri.» A nka hunbur Šela masi koy buu sanda nga armey takaa, nga se a na šennoo woo har. Tamar koy goro nga baabaa hugoo ra. ");
INSERT INTO ses_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Waati kuku banda ga, Šuwa ize woyoo kaŋ ti Žuda wandoo, faati. Buuyanoo goraa banda ga, Žuda nda nga ceroo Hira, Adulam boraa, žigi ka koy Timna ka almaney kosu. ");
INSERT INTO ses_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Boroyaŋ na Tamar noo alhabar ka nee: «Ni kurɲoo baabaa ne ma žigi ka koy Timna ka nga almaney kosu.» ");
INSERT INTO ses_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tamar na nga woy gorori darbawey kaa ka tungu gum nga ga, ka nga boŋ tugu. A koy goro Enayim koyraa miɲoo ga, Timna fondaa ra, zama a ga dii kaŋ Šela beeri, amma i mana nga noo a se hiijay. ");
INSERT INTO ses_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Kaŋ Žuda dii a kul, a nʼa himandi nda woykuuru, zama a nka nga ndumoo gum. ");
INSERT INTO ses_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","A šiiri ka koy a do fondaa ra, a nee a se: «Naŋ ya kani nda ni.» A si bay wala nga nzura woyoo no. A nʼa zaabi ka nee: «Macin no nʼgʼa noo ya ne nda ay nʼay boŋ noo ma ne?» ");
INSERT INTO ses_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","A nee a se: «Ay ga hancin-ize foo sanba ma ne agʼalmaney ra.» Woyoo nee a se: «A boori, nda nʼgʼay noo tolme hala nʼgʼa sanba.» ");
INSERT INTO ses_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","A nee a se: «Macin no nʼga baa yʼa tolme?» A nʼa zaabi ka nee: «Ni karfoo nda nga korbaa kaŋ ti ni tammaasaa, nda ni kabe goboo.» A nʼi noo a se, a marga nda a, a nʼa tee boro hinka. ");
INSERT INTO ses_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","A tun ka koy, a na tungoo kaa ka woy gorori darbawey yeeti nga ga. ");
INSERT INTO ses_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Žuda na nga ceroo, Adulam boraa, sanba nda hancin-izoo a ma nga hayey kaŋ a nʼi tolme taa woyoo kone. Amma a mana dii a. ");
INSERT INTO ses_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","A na borey kaŋ goo no din hãa ka nee: «Man woyoo kaŋ ga izefututaray tee Enayim fondaa ra?» I nʼa zaabi ka nee: «Woy kul sii ne ra kaŋ ga izefututaray tee.» ");
INSERT INTO ses_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","A yee Žuda do ka nee: «Ya na dii a, koyne mo ba nongoo din borey nee kaŋ woy kul sii no din kaŋ ga nga boŋ neere.» ");
INSERT INTO ses_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Žuda nee: «A ma gaabu hayey kaŋ goo a kone ir masi koy kayna. Nga ne, ay na hancin-izoo sanba, amma mana dii a.» ");
INSERT INTO ses_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Handu hinza cine banda ga, boroyaŋ na Žuda bayrandi ka nee: «Tamar, ni izoo wandoo na woykuurutaray tee, de woykuurutaraa ra a tee boro hinka.» Žuda nee: «Wʼa fattandi, i mʼa ton.» ");
INSERT INTO ses_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Waatoo kaŋ i gʼa ka fatta, a nʼi ma nee nga nzuraa se: «Boraa kaŋ nʼay tee boro hinka wane nda jinawey wey.» A yee ka nee: «Guna wala nʼga boraa bay kaŋ wane nda karfoo, nda nga korbaa, nda goboo woo.» ");
INSERT INTO ses_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Žuda nʼi bay, a nee: «A goo nda cimi nda agay, zama ya nʼa noo agʼizʼaroo Šela se.» Woo banda ga, a mana yee ka marga nda a. ");
INSERT INTO ses_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Waatoo kaŋ a ga baa ka hay, i gar kaŋ ntaway aruyaŋ no a ga duu. ");
INSERT INTO ses_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Kaŋ a ga duu nga boŋ, ize faa na nga kaboo kaa taray, hayandikaa na kaboo dii ka šilli ciray zaram haw a ga ka nee: «Woo ka jin ka fatta.» ");
INSERT INTO ses_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Amma a na nga kaboo yeeti, de armaa ne ka huru aduɲɲa ra. Hayandikaa nee: «Gaabi nda ni ne ka fatta!» I na maaɲoo daŋ Peres (maanaa «fatta nda gaabi»). ");
INSERT INTO ses_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Nga banda ga, armaa fatta kate kaŋ šilli ciraa goo kaboo ga. I na maaɲoo daŋ Zera (maanaa «waynaa cirayyanoo»). ");
INSERT INTO ses_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","I na Isufi ka doo Misira. Misira aru foo kaŋ maaɲoo ti Potifar kaŋ ti Firawuuna goykaw beerey affoo, nga lakkalkey jineboraa, a nʼa day Isimayel borey ga kaŋ nʼa ka doo no din. ");
INSERT INTO ses_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Abadantaa goo Isufi bande, haya kul kaŋ ra a huru ga boori. A cindi nga koyoo, Misira boraa, hugoo ra. ");
INSERT INTO ses_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Nga koyoo dii kaŋ Abadantaa goo a bande, de mo haya kul kaŋ ra a huru Abadantaa gʼa hanse. ");
INSERT INTO ses_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","A na alhormo tee Isufi se, a tee a se cee-cire maana. Potifar na nga hugoo talfi a ga, a na nga hayey kul daŋ kaboo ra. ");
INSERT INTO ses_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Za kaŋ a na nga hugoo nda nga hayey kul daŋ kaboo ra, Abadantaa na albarka daŋ Misira boraa hugoo ra Isufi maaganda se. Abadantaa na albarka daŋ Potifar hayey kul ra, nda nga hugoo ra, nda nga faarey ra. ");
INSERT INTO ses_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Hayey kul kaŋ goo maaɲoo ga, a nʼi naŋ Isufi kaboo ra. Nga hunday si huga nda haya kul kala nga ŋaahayaa. Isufi goo nda kunturu henna nda ndum henna. ");
INSERT INTO ses_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Hayey wey banda ga, Isufi goo woo da ra kaŋ nga koyoo wandoo na moo daŋ a ra. Woyoo nee a se: «Marga nda agay.» ");
INSERT INTO ses_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","A wanji, de a nee a se: «Guna, ay koyoo si haya kul bay nga hugoo se, hayey kul a manʼi daŋ kala ay kaboo ra. ");
INSERT INTO ses_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","A mana bisa agay hugoo woo ra, a manʼay ganji haya kul nda manʼti ni kaŋ ti nga wandoo. Taka foo nda ay ga zunubu beeroo woo tee ka Irkoy kuta?» ");
INSERT INTO ses_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Takaa kul kaŋ nda a gʼa har Isufi se zaari ka kaa zaari, a wanji ka marga nda a, ka kani nda a. ");
INSERT INTO ses_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Han foo Isufi huru hugoo ra ka nga goyey tee, a gar kaŋ hugu-ize kul sii no, ");
INSERT INTO ses_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","woyoo na Isufi dii nda nga darbaa ka nee: «Kani nda agay!» A na nga darbaa naŋ kaboo ra, a zuru ka taray gaarandi. ");
INSERT INTO ses_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Waatoo kaŋ a dii kaŋ a na nga darbaa naŋ nga kaboo ra ka zuru ka koy taray, ");
INSERT INTO ses_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","a ciya nga hugoo borey se ka nee i se: «Wa guna, a mana kate ir se kala Ebere kaŋ ma kaa ka hooray ir ra. A nka gum ay ga, de ay na jinde jer ka kaati ka ciya. ");
INSERT INTO ses_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Kaŋ a maa kaŋ ay ga kaati ka ciya, a na nga darbaa naŋ ay jeroo ga, a zuru ka koy taray.» ");
INSERT INTO ses_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","A na Isufi darbaa jisi nga jeroo ga hala waatoo kaŋ kurɲoo yee kate hugey. ");
INSERT INTO ses_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","A na filla follokaa deede a se ka nee: «Ebere baɲɲaa kaŋ ni kate a ir do kaa ay do ka hooray ay ra. ");
INSERT INTO ses_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Amma kaŋ ay kaati ka ciya kul, a na nga darbaa naŋ ay jeroo ga ka zuru ka koy taray.» ");
INSERT INTO ses_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Waatoo kaŋ Isufi koyoo ga maa wandoo deedaa ra, a ga nee: «Woo ti hayaa kaŋ ni baɲɲaa nʼa tee ya ne», Isufi koyoo too met nda futay. ");
INSERT INTO ses_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Isufi koyoo nʼa dii, a nʼa daŋ kasaa ra, nongoo kaŋ ra kokoyoo kasa-izey ga daabandi. A cindi no din, kasaa ra. ");
INSERT INTO ses_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Amma Abadantaa goo Isufi bande, a na nga hennayyanoo cebe a se, ka borohennataray daŋ kasahugoo jineboraa binoo ra Isufi se. ");
INSERT INTO ses_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Kasa hugoo jineboraa na kasa-izey kul kaŋ goo kasaa ra daŋ Isufi kaboo ra, haya kul kaŋ i gʼa tee, nga no mʼa juwal. ");
INSERT INTO ses_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Haya kul kaŋ goo Isufi kaboo ra, kasahugoo jineboraa si huga nda a, zama a ga bay kaŋ Abadantaa goo Isufi bande, de mo haya kul kaŋ ra Isufi na kabe daŋ, Abadantaa gʼa boryandi. ");
INSERT INTO ses_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Hayey wey banda ga, aroo kaŋ ga huga nda Misira kokoyoo haŋhayaa nda aru kaŋ ga huga nda nga ŋaahayaa na laybu tee ngi koyoo se kaŋ ti Misira kokoyoo. ");
INSERT INTO ses_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Firawuuna futu nga goykaw beerey hinkaa ga kaŋ ti nga haŋhaya hansekey jineboraa nda ŋaahaya hansekey jineboraa. ");
INSERT INTO ses_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","A nʼi dii kʼi daŋ nga lakkalkey jineboraa hugoo ra kaŋ goo kasaa ra, nongoo kaŋ ra Isufi daabandi. ");
INSERT INTO ses_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Lakkalkey jineboraa nʼi naŋ Isufi kaboo ra, a mʼi hawgay, i na waati tee kasaa ra. ");
INSERT INTO ses_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Han foo Misira kokoyoo haŋhaya hansekaa nda ŋaahaya hansekaa kaŋ daabandi kasaa ra, handiri cijin folloku, affoo kul nda nga handiroo nda nga almaganaa. ");
INSERT INTO ses_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Isufi biya ka kaa i do, de a dii kaŋ i ga huzun. ");
INSERT INTO ses_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","A na Firawuuna goykaw hinkaa kaŋ goo a bande kasaa ra hãa ka nee: «Macin se war ndumey si feeri hõ?» ");
INSERT INTO ses_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","I nʼa zaabi ka nee: «Ir nka handiri, amma boro kul sii ne kaŋ gʼi feeri.» Isufi nee i se: «Manʼti Irkoy kone almaganaa goo wala? Wʼi filla ya ne.» ");
INSERT INTO ses_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Haŋhaya hansekey jineboraa na nga handiroo deede Isufi se ka nee: «Ay handiroo ra, ay dii alanebɲaa foo kaŋ ga kay ay jine. ");
INSERT INTO ses_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Alanebɲaŋoo woo, kabe hinza bara a ga. Kaŋ a boosu kul, a na izeyaŋ hay kaŋ nin. ");
INSERT INTO ses_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Firawuuna potoo goo ay kaboo ra, ay ga alaneb-izey kaa, ay gʼi motti potoo ra, de ay nʼa šerre Firawuuna se.» ");
INSERT INTO ses_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Isufi nee a se: «Handiroo almaganaa ne, tuuri kabe hinzaa manʼti kala jirbi hinza. ");
INSERT INTO ses_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ne nda jirbi hinza Firawuuna ga ciya ma ne, a ga ni yeeti ni goyoo ra. Nʼga potoo šerre a se sanda takaa kaŋ ni cindi kʼa tee waatoo kaŋ nʼga tee boro kaŋ ga huga nda nga haŋhayaa. ");
INSERT INTO ses_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Amma ma hongu agay waati kaŋ ni hayey boori. Ma borohennataray tee ya ne kʼay misoo hẽe Firawuuna do, a mʼay fattandi hugoo woo ra. ");
INSERT INTO ses_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Gaabi nda i nʼay ka zuru ka hun Eberewey gandaa ra, ne mo ra, ya na haya kul tee kaŋ ga hima nda guusoo woo huruyanoo.» ");
INSERT INTO ses_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ŋaahaya hansekey jineboraa dii kaŋ handiroo almaganaa ga boori, a nee Isufi se: «Agay mo, ay handiroo ra, ay dii dika hinzaa kaŋ ra takula ga huru ga deke-deke cere gʼay boŋoo boŋ. ");
INSERT INTO ses_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Dikaa kaŋ goo beene, haya kul kaŋ ti ŋaayan kaŋ ga huru alforon ra Firawuuna se kul goo a ra, de cirawey gʼi ŋaa dikaa ra ay boŋoo boŋ.» ");
INSERT INTO ses_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Isufi zaabi ka nee: «Almaganaa ne, dika hinzaa manʼti kala jirbi hinza. ");
INSERT INTO ses_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Ne nda jirbi hinza Firawuuna ga ni boŋoo kaa ni jindoo ga ka ni deeji bundu boŋ, cirawey ga kaa ka ni hamoo ŋaa.» ");
INSERT INTO ses_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Jirbi hinzantoo sawa nda hanoo kaŋ ra Firawuuna hayyanoo jiiri bereyanoo too, a na hoyandi tee nga borey kul se. A na haŋhaya hansekey jineboraa nda ŋaahaya hansekey jineboraa cee borey gamey ra. ");
INSERT INTO ses_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Firawuuna na haŋhaya hansekey jineboraa yeeti nga goyoo ra, ka potoo šerre a se. ");
INSERT INTO ses_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ŋaahaya hansekey jineboraa, a nʼa deeji kʼa wii sanda takaa kaŋ nda Isufi na handirey feeri i se. ");
INSERT INTO ses_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Haŋhaya hansekey jineboraa mana yee ka hongu Isufi, a dirɲa a. ");
INSERT INTO ses_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Jiiri hinka banda ga, Firawuuna na handiri foo tee. Handiroo ra, a mma kay isaa miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","A dii haw henna naasa iyye žigi ka hun haroo ra, de i huru suboo ra kʼa ŋaa. ");
INSERT INTO ses_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ngi banda ga, haw iyye žigi ka hun haroo ra, i ga meeri, i ga faabu, de i koy kay ijinawey jerey ga isaa miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Haw iyye meera faabey na haw iyye boryaa naasey gon. Woo banda ga, Firawuuna moɲey hay. ");
INSERT INTO ses_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","A yee ka jirbi, de a handiri koyne. Handiroo ra, a dii jeeni iyye kaŋ ga too i ga boori, i zay kaari follokaa ga. ");
INSERT INTO ses_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Jeeni iyye koga ɲoomayaŋ kaŋ dandi hew konnaa nʼi ton, tun dumawey ga. ");
INSERT INTO ses_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Jeeni iyye ɲoomey na jeeni iyyaa gon kaŋyaŋ ga too i ga boori. Firawuuna tun, de a gar kaŋ handiri ra nga goo. ");
INSERT INTO ses_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Subbaahoo ra, Firawuuna lakkaloo tun, de a daŋ i ma ciya kottekoyney nda bayraykoyney kul se kaŋ goo Misira ra. Firawuuna na nga handirey deede i se, amma boro kul mana hin kʼi feeri a se. ");
INSERT INTO ses_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Haŋhaya hansekey jineboraa šelaŋ Firawuuna se ka nee: «Hõ ay ga hongu ay laybey kaŋ ay nʼi tee ka bisa. ");
INSERT INTO ses_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Han foo ni kaŋ ti Firawuuna futu ni borey ga, nʼnʼay daŋ kasaa ra lakkalkey jineboraa hugoo ra, agay nda ŋaahaya hansekey boŋkoynoo. ");
INSERT INTO ses_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ir affoo kul na handiri foo tee cijin follokaa da ra, agay nda a, affoo kul nda wanoo almaganaa. ");
INSERT INTO ses_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ebere aru sooga foo kaŋ ti lakkalkey jineboraa tamoo, cindi ir bande no din ra. Ir nʼir handirey deede a se, a na affoo kul noo nga almaganaa. ");
INSERT INTO ses_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Hayey tee nda takaa kaŋ nda a nʼa feeri ir se. Nʼnʼay yeeti ay goyoo ra, nʼna ŋaahaya hansekey boŋkoynoo deeji kʼa wii.» ");
INSERT INTO ses_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Firawuuna daŋ i ma ciya Isufi se. I nʼa fattandi kasaa ra nda cahãyan. A mulle, a na darbay barmay jina, a koy Firawuuna do. ");
INSERT INTO ses_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Firawuuna nee Isufi se: «Ay na handiri foo tee, amma boro kul sii ne kaŋ gʼa feeri. Ay maa kaŋ ni, nʼga hin ka handiri feeri nda ni maa a se.» ");
INSERT INTO ses_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Isufi na Firawuuna zaabi ka nee: «Manʼti agay no! Irkoy no ma ni noo zaabi kaŋ ga ni binoo yaynandi.» ");
INSERT INTO ses_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Firawuuna nee Isufi se: «Guna, ay handiroo ra, ya mma goo ma kay isaa miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","De haw iyye henna naasa ne ka žigi ka hun haroo ra ka suboo ŋaa. ");
INSERT INTO ses_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ngi dumaa ga, haw iyye žigi ka hun haroo ra, ifaranteyaŋ, i ga meeri, i ga faabu. Ya na bay ka dii ngi dumi ɲoomayaŋ Misira gandaa kul ra. ");
INSERT INTO ses_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Haw iyye meera faabey na haw iyye jinawey gon kaŋ ga naasu. ");
INSERT INTO ses_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Haw naasey gonandi, amma boro si bay wala i huru haw faabey gundey ra. Ngi azzaatey ga meeri sanda cee jinaa. Woo banda ga, kul ay moɲey hay. ");
INSERT INTO ses_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ay dii koyne jeeni iyye kaŋ ga too, i ga boori, i zay kaari follokaa ga. ");
INSERT INTO ses_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ngi banda ga, jeeni iyye koga ɲoomayaŋ zay kaŋ dandi hew konnaa nʼi ton. ");
INSERT INTO ses_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Jeeni ɲoomey na jeeni boryey gon. Ay nʼa filla kottekoyney se, amma boro kul sii ne kaŋ gʼa feeri ya ne.» ");
INSERT INTO ses_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Isufi nee Firawuuna se: «Ni handirey manʼti kala afolloku. Hayaa kaŋ Irkoy gʼa tee, nga no a nʼa bayrandi ni kaŋ ti Firawuuna se. ");
INSERT INTO ses_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Haw iyye henney manʼti kala jiiri iyye. Jeeni iyye boryey mo manʼti kala jiiri iyye. Handiri follokaa no. ");
INSERT INTO ses_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Haw iyye meera faabey kaŋ žigi ka koy ijinawey banda ga manʼti kala jiiri iyye. Jeeni iyye koga ɲoomey kaŋ dandi hew konnaa nʼi ton, manʼti kala jiiri iyye heray. ");
INSERT INTO ses_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Hayaa da kaŋ ay nʼa har ma ne no, Irkoy nka hayaa cebe ma ne kaŋ a gʼa tee. ");
INSERT INTO ses_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Nga ne, jiiri iyyaa woo kaŋ goo ma kaa, duuray beeri ga tee Misira gandaa kul ra. ");
INSERT INTO ses_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Amma nga dumaa ga, jiiri iyye heray ga kaa kaŋ ga borey dirɲandi duuraa kaŋ Misira gandaa bay ka duu a. Heraa ga gandaa tuusu. ");
INSERT INTO ses_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Heraa gaaboo se, boro si ba bay wala duuray bay ka tee gandaa ra. ");
INSERT INTO ses_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ni handiroo kaŋ filla cee hinka manʼti kala hayaa no kaŋ Irkoy nʼa kayandi, koyne mo Irkoy gʼa tee nda cahãyan. ");
INSERT INTO ses_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Sohõ aru lakkalkoyni ceeci kaŋ ga faham, mʼa daŋ Misira gandaa jine. ");
INSERT INTO ses_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ma daŋ gandaa ra kaŋ boroyaŋ ma kay ka Misira gandaa hegaa zamna guu kul affoo jisi jere ga, jiiri iyyaa duuraa waati. ");
INSERT INTO ses_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Jiiri henney wey kaŋ goo kaa ra, i ma ngi taasoo kul marga. Ma yaamar noo kaŋ alkamaa ma fanjandi, koyrawey huna se, i mʼi lakkal. ");
INSERT INTO ses_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Woo kaŋ margandi ga jisi gandaa se, nga ra waati kaŋ jiiri iyyaa heraa kaa Misira gandaa ra, heraa masi gandaa benandi.» ");
INSERT INTO ses_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Šennoo woo kan Firawuuna nda nga borey se. ");
INSERT INTO ses_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Firawuuna nee i se: «War ga hongu ir ga duu aroo woo cine kaŋ Irkoy Hundoo goo a ra wala?» ");
INSERT INTO ses_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","A nee Isufi se: «Sohõ kaŋ Irkoy na hayey wey kul bayrandi ma ne, boro sii no kaŋ goo nda lakkal ka faham sanda ni. ");
INSERT INTO ses_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Nʼga huru ay laamaa jine, gandaa kul ga haŋajer ma ne. Kokoytaray fuulaa hinne no mʼay ka bisa ni.» ");
INSERT INTO ses_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","A nee Isufi se koyne: «Guna! Ay na ni daŋ Misira gandaa kul jine.» ");
INSERT INTO ses_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Firawuuna na nga korbaa kaa kʼa daŋ Isufi kaboo ra. A na šukka baana bankaarayyaŋ daŋ a ga, a na wura hiiri daŋ jindoo ra. ");
INSERT INTO ses_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","A nʼa kaarandi nga bari torka hinkantoo ga. Borey goo a jine, i ga kaati ka nee: «Wa kobi-kobi!» Takaa woo nda a nʼa daŋ Misira gandaa kul jine. ");
INSERT INTO ses_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Firawuuna nee Isufi se koyne: «Agay ti Firawuuna, amma boro kul si nga kaboo wala nga cewoo ɲuuti Misira gandaa kul ra nda manʼti ni nka baa.» ");
INSERT INTO ses_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Firawuuna na Isufi maaɲoo daŋ Safnat-Paneya. A na koyraa kaŋ se i ga nee On sargari juwalkaa kaŋ maaɲoo ti Poti-Fera, ize woyoo, Asanat hiijandi Isufi se. Isufi koy Misira gandaa yaara. ");
INSERT INTO ses_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Woo kaa ka gar kaŋ Isufi sii nda kala jiiri waranza (30) kaŋ a ga koy kay Firawuuna, Misira gandaa kokoyoo jine. A hun Firawuuna do ka koy Misira kul kuubi. ");
INSERT INTO ses_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Jiiri iyyaa duuraa ra, hegay beeri tee. ");
INSERT INTO ses_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Isufi na jiiri iyyaa taasoo kul marga Misira gandaa ra. A nʼi fanji koyrawey ra. Koyra foo kul a na faarey kaŋ gʼa kuubi taasoo daŋ a ra. ");
INSERT INTO ses_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Isufi na alkama boobo marga sanda teekoo labutaasi gurunbey, a mana yee kʼa kabu nga booboyanoo se. ");
INSERT INTO ses_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Za jiiroo kaŋ heraa tee mana kaa, On sargari juwalkaa kaŋ ti Poti-Fera ize woyoo Asanat duu Isufi se izʼaru hinka. ");
INSERT INTO ses_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Isufi na ijinaa maaɲoo daŋ Manase (maanaa «dirɲandikaa»), a nee: «Zama Irkoy nʼay dirɲandi ay farayanoo kul kaŋ ay nʼa tee ay baabaa hugoo ra.» ");
INSERT INTO ses_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ihinkantoo a na maaɲoo daŋ Efrayim (maanaa «hayyaŋ»), a nee: «Zama Irkoy nʼay noo hayyaŋ gandaa kaŋ ra ay hottu.» ");
INSERT INTO ses_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Jiiri iyyaa duuraa kaŋ tee Misira gandaa ra ben. ");
INSERT INTO ses_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Woo banda ga, jiiri iyyaa heraa šintin ka kaa sanda takaa kaŋ nda Isufi nʼa har. Heraa huru gandawey kul ra, amma Misira gandaa kul goo nda taasu. ");
INSERT INTO ses_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Waatoo kaŋ Misira gandaa kul heray, i kaati ka Firawuuna ŋaaray a ma ngi noo taasu. Firawuuna nʼi zaabi ka nee: «Wa koy Isufi do, hayaa kaŋ a nʼa har, war mʼa tee.» ");
INSERT INTO ses_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Heraa huru gandawey kul ra, Isufi na jinay fanjidogey feeri ka taasu neere Misira borey se. Heraa mma koy de a ga tonton Misira gandaa ra. ");
INSERT INTO ses_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Gandawey kul here no borey ga hun ka kaa Misira ka taasu day Isufi do, zama heraa mma koy de a ga tonton gandawey kul ra. ");
INSERT INTO ses_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yakuba dii kaŋ alkama goo Misira gandaa ra, a nee nga izʼarey se: «Macin se war ga goro ka cere guna?» ");
INSERT INTO ses_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","A nee koyne: «Wa guna, ay maa kaŋ alkama neerante goo Misira. Wa doo no din ka day ir se, ir masi koy buu.» ");
INSERT INTO ses_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Isufi armey boro woy (10) doo Misira ka koy taasu day. ");
INSERT INTO ses_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Yakuba mana Benžameŋ kaŋ ti Isufi armaa, sanba i bande, zama a ga hunbur albasi ma duu a. ");
INSERT INTO ses_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Izirayel izʼarey koy alkama day, i sawa nda borey jerey kaŋ koy day, zama heraa goo Kanaŋ gandaa ra. ");
INSERT INTO ses_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Isufi no ma gandaa kul laama. Nga no ma taasoo neere gandaa borey kul se. Isufi armey kaa, de i gunguma jinoo ra ka ngi ndumey sinji laboo ra. ");
INSERT INTO ses_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Kaŋ Isufi dii nga armey, kul a nʼi bay, amma a na nga boŋ tee i se ceewaani. A šendandi i ga, a nee i se: «Man ra war hun?» I nʼa zaabi ka nee: «Kanaŋ gandaa ra ir hun, ka kaa ka taasu day.» ");
INSERT INTO ses_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Isufi na nga armey bay, amma ngi, i manʼa bay. ");
INSERT INTO ses_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Isufi hongu handirey kaŋ nga nʼi tee nga armey ga. A nee i se: «Monnokawyaŋ ti war! Gandaa kanje faabey no war kaa kʼi laasaabu, woo se war kaa!» ");
INSERT INTO ses_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","I nʼa zaabi ka nee: «Kalaa, kalaa! Ir koyoo, ni tamey nka kaa ka taasu day. ");
INSERT INTO ses_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ir kul ti baaba foo, boro šerranteyaŋ ti ir, ni tamey mana bay ka tee monnokawyaŋ.» ");
INSERT INTO ses_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","A nee i se: «Abada, war nka kaa ka gandaa kanje faabey laasaabu.» ");
INSERT INTO ses_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","I nʼa zaabi ka nee: «Ni tamey manʼti kala arma boro woy cindi hinka (12) kaŋ kul ti baaba folloku Kanaŋ gandaa ra. Ir kul ikaccaa goo ir baabaa jeroo ga, affoo mo goo no kaŋ mana cindi.» ");
INSERT INTO ses_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Isufi nee i se: «Woo da ti hayaa kaŋ ay nʼa har war se, monnokawyaŋ ti war. ");
INSERT INTO ses_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","War ga siyandi, ay ga žee nda Firawuuna hunaroo kaŋ war si hun ne ra nda war kul ikaccaa mana kaa ne. ");
INSERT INTO ses_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Wa war affoo sanba, a ma koy war armaa ceeci, de cindey ga tee kasa-ize hala ya dii wala war šenney ga laadir. Nda manʼti nga sii a ra, ay ga žee nda Firawuuna hunaroo kaŋ monnokawyaŋ ti war!» ");
INSERT INTO ses_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Woo banda ga, a nʼi dii kasaa ra jirbi hinza. ");
INSERT INTO ses_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Jirbi hinzantoo hane Isufi nee i se: «Wa hayaa tee kaŋ ay gʼa har hala war ma duu ka huna. Boro ti agay kaŋ ga hunbur Irkoy! ");
INSERT INTO ses_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Nda war, boro šerranteyaŋ ti war, war affoo ma cindi kasaa ra, cindey ma koy nda alkama hugey borey se kʼi ŋandi. ");
INSERT INTO ses_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","De a ma kate ya ne war kaynoo hala ya war šenney sii, nga ra war si duu ka buu.» Woo kaŋ a nʼa har i nʼa tee. ");
INSERT INTO ses_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","I nee cere se: «Nda cimi, ir armaa alhakoo goo ir ga, zama ir dii nga binemarayyanoo waatoo kaŋ a gʼir suurandi, amma ir mana yadda! Woo ti hayaa kaŋ se bonaa woo kaŋ ir boŋ.» ");
INSERT INTO ses_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rubeŋ šelaŋ ka nee i se: «Ay mana nee war se war masi haya laala tee zankaa se wala? Amma war mana haŋajer ya ne. Sohõ ir ga hundoo alhakoo bana.» ");
INSERT INTO ses_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","I si bay wala Isufi ga maa ngi se, zama mandikaw no a nʼa daŋ ngi gamey ra. ");
INSERT INTO ses_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Isufi hibi i ga ka koy hẽe. A yee kate ka šelaŋ i se. Nga banda ga, a na Simewoŋ zaa i ra kʼa daabu jiney ra. ");
INSERT INTO ses_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Isufi daŋ kaŋ i ma ngi saakey too i se nda alkama, de i ma affoo kul nooroo daŋ nga saakoo ra, i mʼi noo šilfanda. Woo kaŋ a nʼa har i nʼa tee. ");
INSERT INTO ses_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","I na alkama jeeje ngi farkey ga, de i koy. ");
INSERT INTO ses_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Nongoo kaŋ ra i na cijinoo tee, ngi affoo na nga saakoo feeri ka nga farkaa noo ŋaayan, de a dii kaŋ nooroo goo saakoo miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","A nee nga armey se: «Ay nooroo yee ay ga, nga ne ay saakoo ra.» Biney dunbu, de i ga jijiri ka nee cere se: «Cin ti woo kaŋ Irkoy nʼa tee ir se?» ");
INSERT INTO ses_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","I koy ngi baabaa Yakuba do, Kanaŋ gandaa ra, de i na haya kul filla a se kaŋ tee ngi ga. ");
INSERT INTO ses_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","I nee a se: «Boraa kaŋ ti gandaa din boŋkoynoo šendandi ir ga. A nʼir dii nda boroyaŋ kaŋ kaa ka gandaa monno. ");
INSERT INTO ses_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ir nee a se: ‹Boro šerranteyaŋ ti ir, ir manʼti monnokawyaŋ. ");
INSERT INTO ses_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ir manʼti kala arma woy cindi hinka (12) kaŋ kul ti baaba folloku. Ir affaa mana cindi, ir kul ikaccaa goo ir baabaa do Kanaŋ gandaa ra.›» ");
INSERT INTO ses_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Boŋkoynoo nee ir se: «Takaa ne kaŋ nda ay ga bay wala boro šerranteyaŋ ti war. Wa war armey affoo naŋ ay kaboo ra, wa haya zaa kaŋ nda war ga war hugey borey ŋandi. ");
INSERT INTO ses_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Wa koy, de war ma kate ya ne war kaynoo. Woo ra ay ga bay kaŋ manʼti monnokawyaŋ ti war, boro šerranteyaŋ ti war. Ay ga war armaa yeeti war ga, de waatoo din war ga hin ka koy nongu kaŋ kan war se gandaa ra.» ");
INSERT INTO ses_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Waatoo kaŋ i ga taasey kaa saakey ra, nga ne, affoo kul nga nooroo hawaroo goo nga saakoo ra. Kaŋ ngi nda ngi baabaa dii nooru hawarey, kul i hunbur. ");
INSERT INTO ses_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Yakuba nee i se: «War gʼay izey kaa ay cire! Isufi mana cindi, Simewoŋ dere, sohõ war ga baa war ma Benžameŋ dii! Hayaa kul si kaŋ kala agay boŋ.» ");
INSERT INTO ses_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Rubeŋ nee nga baabaa se: «A noo ya ne, ay gʼa ka yee kate ni do. Nda ay mana yee kate nda Benžameŋ, mʼay izʼaru hinkaa wii.» ");
INSERT INTO ses_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Amma a nee: «Ay izʼaroo si doo war bande, nga armaa nka buu, nga foo ka cindi. Nda albasi duu a diraa ra, binehẽeni nda war gʼay žeenayyanoo zumandi alaahara.» ");
INSERT INTO ses_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Heraa laala Kanaŋ gandaa ra. ");
INSERT INTO ses_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Waatoo kaŋ Yakuba hugoo borey na alkama kaŋ i nʼa ka hun Misira, ŋaa ka ben, Yakuba nee nga izʼarey se: «Wa yee ka koy ŋaayan day ir se.» ");
INSERT INTO ses_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Žuda nʼa zaabi ka nee: «Aroo din bayrandi ir se kaaray kaŋ ir masi too kate nga do nda ir armaa sii ir bande. ");
INSERT INTO ses_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Nda nʼga yadda, ir armaa ma hanga ir bande, ir ga doo ka ŋaayan day ma ne. ");
INSERT INTO ses_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Amma nda nʼsʼa sanba ir bande, ir si doo, zama aroo nka nee ir se kaŋ, nda ir armaa sii ir bande, ir masi too kate nga do.» ");
INSERT INTO ses_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Izirayel nee: «Macin se war na goy futaa woo tee ya ne ka bayrandi aroo se kaŋ war goo nda arma foo koyne?» ");
INSERT INTO ses_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","I nʼa zaabi ka nee: «Aroo nka hanse kʼir hãa ir nda ir hugoo, a nee: ‹War baabaa ga huna wala? War goo nda arma foo koyne wala?› Ir mo tuuru a se nda taka kaŋ nda a nʼir hãa. Ir mma bay wala a ga nee ir mʼir armaa ka doo kate?» ");
INSERT INTO ses_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Žuda nee nga baabaa Izirayel se: «Naŋ zankaa ma hanga ay bande hala ir ma duu ka tun ka koy, ir masi koy buu nda heray, ir, nda ni, nda ir zankey. ");
INSERT INTO ses_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Agay no nʼgʼay bay, agay nda mʼa hãa. Nda ay manʼa ka yee kate ni do, nda ay manʼa daŋ ni kaboo ra, ni alhakoo ma hanga agay hala abada. ");
INSERT INTO ses_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Nda a gar ir nka koy za waatoo din, sohõ kaa ka gar ir yee koyne!» ");
INSERT INTO ses_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ngi baabaa Izirayel nee i se: «Nda woo no, takaa ne kaŋ war gʼa tee: wa gandaa hayaa suubanteyaŋ zaa kʼi ka doo aroo do i ma tee a se gomni: jii, nda yuu, nda day-day, nda dugu, nda maatiga, nda amand. ");
INSERT INTO ses_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Wa nooroo kaŋ war nʼa gar war saakey miɲey ga ka koy war bande kʼa yeeti, a ga hin ka tee boraa nka firka. War ma nooru taaga zaa ka koy koyne. ");
INSERT INTO ses_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Wa war armaa zaa, ka tun ka yee aroo do. ");
INSERT INTO ses_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Yala Irkoy, Hini-kul-koyoo ma war noo alhormo aroo woo do, hala a ma naŋ war armaa faa nda Benžameŋ ma yee kate war bande. Nda ay ga hima ka jaŋ ay izey, ya jaŋ ey.» ");
INSERT INTO ses_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Armey na gomney zaa, i na nooroo kaŋ i ga hima kʼa ka koy cine hinka zaa, i na Benžameŋ mo zaa ka koy. I tun ka doo Misira ka koy Isufi do. ");
INSERT INTO ses_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Za kaŋ Isufi dii i bande Benžameŋ, a nee nga goykaa kaŋ ga nga hugoo ga talfi se: «Arey wey ka koy hugey do, ma alman wii, ma hina, hõ zaarikayoo i ga cirkosu ay do.» ");
INSERT INTO ses_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Aroo na hayaa tee kaŋ a nʼa har, a nʼi ka koy Isufi hugoo do. ");
INSERT INTO ses_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Amma arey hunbur, zama i nkʼi ka koy Isufi hugoo do, i nee: «Nooroo kaŋ i nʼa yeeti ir saakey ra cee jinaa, nga se i kate iri ne ra, ka kaŋ ir ga, kʼir gurzugay, kʼir tee sanda baɲɲayaŋ, kʼir farkey kom.» ");
INSERT INTO ses_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","I man Isufi goykaa ka šelaŋ a se hugoo miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","I nee a se: «Suuri boŋkoynoo, ir cee jinaa kaŋ ir doo ka kaa ka ŋaayan day ne ra, ");
INSERT INTO ses_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","kaŋ ir ga willi ir do, fondaa ra, nongoo kaŋ ra ir na cijinoo tee, ir nʼir saakey feeri, de ir kaa ka gar kaŋ boro foo kul nga nooroo goo saakoo miɲoo ga, nooroo hinnaa hunday kaŋ ir nʼa bana, nga dumoo no ir yee ka kate a ir bande. ");
INSERT INTO ses_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ir doo kate nda nooru taaga ka taasu day. Ir si bay boro kaŋ ka nooroo daŋ ir saakey ra.» ");
INSERT INTO ses_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Aroo zaabi ka nee: «Baani ma kaa war ga, war masi hunbur! War Koyoo no, war baabaa Koyoo ka almanoo din daŋ war saakey ra, war nooroo mo, ay duu a.» A na Simewoŋ fattandi i se. ");
INSERT INTO ses_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Aroo nʼi daŋ Isufi hugoo ra. I kate i se hari, i na ngey cewey ɲumay, i na ngi farkey noo ŋaayan. ");
INSERT INTO ses_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","I na ngi gomney soolu hala Isufi ga kaa zaarikay, zama i duu alhabar kaŋ nga do ngi ga cirkosu. ");
INSERT INTO ses_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Kaŋ Isufi too kate hugey do, i na gomney noo a se kaŋ i kate ey nga hugoo do, i gunguma jinoo ra hala ganda. ");
INSERT INTO ses_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","A nʼi hãa wala taka foo ti ngi gaahamey takaa. A nee i se: «War baabaa žeenaa kaŋ war bay ka nga alhabaroo tee ya ne ga huna hala sohõ? A ga saabu?» ");
INSERT INTO ses_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","I nʼa zaabi ka nee: «Ni tamoo, ir baabaa ga huna, a ga saabu.» De i sonbu ka gunguma a se. ");
INSERT INTO ses_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Isufi dii nga armaa Benžameŋ kaŋ nga nda a ga tee ɲaa foo, a nee: «War kaynoo kaŋ war na nga šennoo tee ya ne ti woo wala?» Hãayanoo banda ga, a nee: «Irkoy ma albarka daŋ ni ra, ay zankaa!» ");
INSERT INTO ses_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Isufi armaa faajoo hanse ka hin a, moɲey too nda mundawey, a cahã ka fatta ka koy huru hugu foo ra, a hẽe no din. ");
INSERT INTO ses_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Woo banda ga, a na nga moɲey ɲumay, a fatta kate. A na nga binoo naagu ka šelaŋ ka nee i ma ŋaayaney gorandi. ");
INSERT INTO ses_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ŋaayanoo waati Isufi foo nda nga bagaa, armey jerey nda ngi bagaa, Misira borey kaŋ ga ŋaa a bande mo nda ngi bagaa, zama Misira boro nda Ebere si ŋaa cere bande, almuhal no Misira borey se. ");
INSERT INTO ses_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","I na armey gorandi i mʼa tenje, kʼa dii ibeeroo ga ka koy koddaa ga. I ga cere guna nda almunkar. ");
INSERT INTO ses_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Isufi nʼi noo ŋaayanyaŋ kaŋ goo jinoo ra, Benžameŋ bagaa bisa cindey waney hala cee guu. I haŋ, i ɲaali a bande. ");
INSERT INTO ses_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Isufi nee aroo se kaŋ ga nga hugoo ga talfi: «Borey wey saakey too nda taasu hala nongu kaŋ ga a si bisa, de ma affoo kul nooroo daŋ nga saakoo miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Mʼay potoo, nzorfu guuru potoo, nda taasoo nooroo, mʼi daŋ i kul ikaccaa saakoo miɲoo ga.» A na hayaa tee kaŋ Isufi nʼa har a se. ");
INSERT INTO ses_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Za moo boo, nga no i na arey din nda ngi farkey naŋ i ma koy. ");
INSERT INTO ses_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","I fatta koyraa ra, i mana mooru kaŋ Isufi nee nga hugoo talfikaa se: «Tun ni boŋ ga, hanga arey din, nda ni toorʼey, ma nee i se: ‹Cin se war ga goy hennaa bana nda ifutu? ");
INSERT INTO ses_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Manʼti nga ti hayaa kaŋ nda ay koyoo ga haŋ, hayaa kaŋ nda a ga gunandi wala? Woo kaŋ war nʼa tee manʼti kala goy futu!›» ");
INSERT INTO ses_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","A toorʼey, a na šenni follokey har i se. ");
INSERT INTO ses_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","I nʼa zaabi ka nee: «Macin se ay koyoo ga šenney wey dumey har? Ni tamey ga mooru goyoo woo dumi teeyan! ");
INSERT INTO ses_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Nga ne, nooroo kaŋ ir nʼa gar ir saakey miɲey ga, ir nʼa ka kaa ma ne ka hun Kanaŋ gandaa ra. De taka foo nda ir ga yadda ka zay ni koyoo hugoo ra, a ma tee nzorfu kaaray wala wura! ");
INSERT INTO ses_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Yala boraa kaŋ kone nʼna potoo gar ni tamey ra, ma buu, ir mo ga tee ay koyoo baɲɲey.» ");
INSERT INTO ses_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","A nʼi zaabi ka nee: «Ay yadda hayaa kaŋ war nʼa har, amma boraa kaŋ kone a duwandi no ma tee ay baɲɲaa! War borey jerey ga henan.» ");
INSERT INTO ses_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Affoo kul ga cahã ka nga saakoo zumandi kʼa feeri. ");
INSERT INTO ses_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Aroo fisi, a mana šintin nda kala i kul ibeeroo ka koy ben nda i kul ikaccaa. Potoo duwandi Benžameŋ saakoo ra. ");
INSERT INTO ses_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","I na ngi darbawey kottu, affoo kul na nga farkaa jeejaa yeeti a ga, i willi koyraa ra. ");
INSERT INTO ses_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Žuda nda nga armey koy Isufi hugoo do, i nʼa gar no din, de i gunguma jinoo ra hala ganda. ");
INSERT INTO ses_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Isufi nee i se: «Cin ti goyoo kaŋ war nʼa tee? War nka si bay kaŋ ay cine ga wan ka gunandi ka dii hayey kaŋ ga kaa ka tee?» ");
INSERT INTO ses_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Žuda zaabi ka nee: «Macin no ir ga nee ma ne, ay koyoo? Macin no ir gʼa har, taka foo nda ir gʼir boŋ henanandi? Irkoy na ni tamey laybey fatawandi. Sohõ ir ga tee ma ne baɲɲa, ir nda boraa kaŋ kone potoo duwandi.» ");
INSERT INTO ses_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Isufi zaabi ka nee: «Ay ga mooru woo teeyan! Boraa kaŋ kone potoo duwandi no ma tee ya ne baɲɲa, war, wa žigi ka koy war baabaa do nda baani.» ");
INSERT INTO ses_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Žuda man Isufi do ka nee: «Ay koyoo, alhormo tee ya ne! Ni tamoo ma hin ka šelaŋ ma ne, ay koyoo, masi futu ni tamoo ga, zama nʼga sawa nda Firawuuna. ");
INSERT INTO ses_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ay koyoo, ni nka ni tamey hãa ka nee: ‹War baabaa ga huna wala? War goo nda arma foo koyne wala?› ");
INSERT INTO ses_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ir na ni zaabi, ir koyoo ka nee: ‹Ir baabaa ga huna, a žen. Ir goo nda arma foo kaŋ a duu a nga žeenayyanoo ra. Zankaa din armaa faati, nga hinne ka cindi ɲaŋoo se, baaboo ga hanse ka bagʼa.› ");
INSERT INTO ses_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Waatoo din ni nee ni tamey se: ‹Wʼa doori kate ya ne, ay ga baa ya dii a.› ");
INSERT INTO ses_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ir na ni zaabi, ay koyoo ka nee: ‹Zankaa si hin ka hun baaboo do. Nda a hun baaboo do, kul baaboo ga buu.› ");
INSERT INTO ses_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Amma ni nee ni tamey se: ‹Nda war kaynoo mana doo war bande, war si hin ka dii agay koyne.› ");
INSERT INTO ses_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Waatoo kaŋ ir žigi ka koy ni tamoo, ir baabaa do, ir na ni, ay koyoo šenney har a se. ");
INSERT INTO ses_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Jirbiyaŋ banda ga, ir baabaa nee ir se: ‹Wa yee ka koy ŋaayan day ir se.› ");
INSERT INTO ses_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ir nʼa zaabi ka nee: ‹Ir si hin ka doo. Nda ir kaynoo ga hanga ir bande, ir ga doo, zama ir si hin ka dii aroo nda manʼti ir kaynoo mma bara ir bande.› ");
INSERT INTO ses_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ay baabaa, ni tamoo nee ir se: ‹War ga bay kaŋ ay wandoo mana duu ya ne kala izʼaru hinka. ");
INSERT INTO ses_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Affaa hun ay kone, de ay nee: “Šikka sii kaŋ ganjihooga nʼa wii!” De mo ya na dii a hala nongoo kaŋ ra ay goo. ");
INSERT INTO ses_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Nda war na woo mo taa ay kone, de albasi duu a, war gʼay žeenayyanoo zumandi nda hottay alaahara.› ");
INSERT INTO ses_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Sohõ, nda ay koy ni tamoo, ay baabaa do bila aru soogaa kaŋ ga nga hundoo hanse ka denji, ");
INSERT INTO ses_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","nda a dii kaŋ zankaa sii ir bande, kul a ga buu! De ni tamey gʼir baabaa, ni tamoo zumandi nga žeenayyanoo ra nda binehẽeni alaahara. ");
INSERT INTO ses_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Zama agay, ni tamoo nka nga boŋ tolme zankaa dogoo ra ay baabaa se, ay nee a se: ‹Nda ay manʼa ka yee kate ma ne, ay zunuboo ga cindi waati kul, ay baabaa.› ");
INSERT INTO ses_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Sohõ ay koyoo, ay gʼa wiri ni ga, ni tamoo ma tee ma ne baɲɲa aru soogaa dogoo ra, nga hunday ma žigi ka koy nga armey bande. ");
INSERT INTO ses_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Taka foo nda ay ga hin ka žigi ka koy ay baabaa do nda zankaa sii ay bande? Yala ya si dii bonaa kaŋ gʼay baabaa kar!» ");
INSERT INTO ses_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Isufi mana yee ka hin ka nga boŋ dii borey kul kaŋ gʼa kuubi kʼa bere jine. A wurru ka nee: «Wa borey kul fattandi.» Boro kul sii no waatoo kaŋ Isufi ga nga boŋ bayrandi nga armey se. ");
INSERT INTO ses_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","A na nga jindoo jer ka hẽe hala nongu kaŋ ra Misira borey maarʼa, Firawuuna hugoo mo maarʼa. ");
INSERT INTO ses_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","A nee nga armey se: «Agay no Isufi. Ay baabaa ga huna hala sohõ wala?» Amma armey mana hin ka tuuru a se, zama i zalba jinoo ra. ");
INSERT INTO ses_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Isufi nee nga armey se: «Wa man kate ay ga.» I man kate. A yee ka nee: «Agay no Isufi, war armaa kaŋ war nʼa neere Misira. ");
INSERT INTO ses_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Sohõ war masi war boŋ dor, war masi futu nda hayaa kaŋ se war nʼay neere ne ra. War hallasiroo se Irkoy nʼay sanba ne ra war jine. ");
INSERT INTO ses_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Jiiri hinka ne kaŋ heraa goo gandaa ra, de mo jiiri guu koyne kaŋ beeriyan si tee, hegayyan si tee. ");
INSERT INTO ses_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Irkoy nkʼay sanba war jine hala war masi duu ka ben gandaa ra, amma hala war boro boobo ma hallasi. ");
INSERT INTO ses_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Adiši, manʼti war kʼay sanba ne ra, Irkoy kʼay sanba. A nʼay tee Firawuuna se baaba, a nʼay tee boŋkoyni nga hugoo kul boŋ, a nʼay noo ya Misira gandaa kul laama. ");
INSERT INTO ses_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Wa cahã ka žigi ka koy ay baabaa do, war ma nee a se: ‹Ni izoo Isufi nee ir ma nee ma ne kaŋ Irkoy na nga tee Misira kul se boŋkoyni, ma doo kate nga jeroo ga, masi gay! ");
INSERT INTO ses_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Nʼga goro Gošeŋ gandaa ra, ay jeroo ga, ni nda ni izey nda ni haamawey, nda ni alman buuney, nda ibeerey, nda haya kul kaŋ goo ni maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ne ra, ay ga ni ŋandi, zama heray ga tee koyne jiiri guu, hala masi koy kaŋ fara ra ni, nda ni alaayaney, nda haya kul kaŋ goo ni maaɲoo ga.› ");
INSERT INTO ses_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Nga ne, war dii nda war moɲey, agʼarmaa Benžameŋ dii nda nga moɲey kaŋ agay hunday no ka šelaŋ war se. ");
INSERT INTO ses_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Wʼay beeraa kul kaŋ ay duu a Misira deede ay baabaa se nda haya kul kaŋ war dii a. War ma cahã ka doo kate nda ay baabaa ne ra.» ");
INSERT INTO ses_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Isufi na nga boŋ warra nga armaa Benžameŋ jindoo ga ka hẽe. Benžameŋ mo na jindoo dii ka hẽe. ");
INSERT INTO ses_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","A na nga armey kul naagu nga gandoo ra ka hẽe i bande. Woo banda ga, nga armey duu ka šelaŋ a bande. ");
INSERT INTO ses_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Alhabaroo too Firawuuna hugoo do kaŋ Isufi armey kaa. Woo tee hayaa kaŋ kan Firawuuna nda nga borey se. ");
INSERT INTO ses_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Firawuuna nee Isufi se: «Nee ni armey se kaŋ hayaa kaŋ i ga hima kʼa tee manʼti kala i ma ngi adabbawey jeeje ka koy Kanaŋ gandaa ra. ");
INSERT INTO ses_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","I ma ngi baabaa nda ngi alaayaney zaa ka kaa ka goro ay jeroo ga. Ay ga baa yʼi noo nongu henna-henney kaŋ goo Misira gandaa ra. De mo i ga gandaa ŋaayan suubantey ŋaa. ");
INSERT INTO ses_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ni, ay na ni yaamar ma nee i se: ‹Hayaa ne kaŋ war mʼa tee: war ma bari torkayaŋ zaa Misira gandaa ra war izey nda war wandey se. War ma war baabaa žigandi ka kaa. ");
INSERT INTO ses_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","War masi nimsi nda hayey kaŋ war gʼi naŋ, zama nongu henna-henney kaŋ goo Misira gandaa kul ra ga tee war wane.›» ");
INSERT INTO ses_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Izirayel izʼarey na hayaa tee kaŋ harandi i se. Isufi nʼi noo torkayaŋ sanda takaa kaŋ nda Firawuuna nʼa yaamar, a nʼi noo šilfandayaŋ fondaa se. ");
INSERT INTO ses_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","A na affoo kul noo jingar darbay. A na Benžameŋ noo nzorfu kaaray tamma boŋ zangu hinza (300) nda jingar darbay guu. ");
INSERT INTO ses_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","A na farkey aru boŋ woy (10) jeeje nda haya henna-henney kaŋ goo Misira, nda farkey woy boŋ woy (10) kaŋ i na alkama jeeje i ga, nda taasu, nda meehunayyaŋ, a nʼi sanba nga baabaa diraa se. ");
INSERT INTO ses_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Waatoo kaŋ a ga nga armey naŋ i ma koy, a nee i se: «War masi yenje fondaa ra!» ");
INSERT INTO ses_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","I žigi ka hun Misira ka too Kanaŋ gandaa ra ngi baabaa Yakuba do. ");
INSERT INTO ses_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","I bayrandi a se kaŋ Isufi ga huna, nga no ma Misira gandaa kul laama. Amma Yakuba binoo kay, zama a mana naanay ey. ");
INSERT INTO ses_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Woo banda ga, i na hayey kul filla a se kaŋ Isufi nʼi har ngi se. Koyne mo Yakuba dii torkawey kaŋ Isufi nʼi sanba hala i ma kate nga, woo ka kate ngi baabaa lakkaloo ma zunbu. ");
INSERT INTO ses_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Izirayel nee: «Isufi, agʼizʼaroo ga huna, woo wasa ya ne! Ay ga koy, de ay ga dii a za ya na buu!» ");
INSERT INTO ses_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Izirayel koy nda haya kul kaŋ goo maaɲoo ga. A too Ber-Šeba, no din ra a na almanyaŋ koosu kʼi tee sargari nga baabaa Isiyaka Koyoo maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Cijinoo ra, Irkoy šelaŋ Izirayel se bangayyan ra ka nee: «Yakuba, Yakuba!» A zaabi ka nee: «Agay ne.» ");
INSERT INTO ses_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Irkoy nee a se: «Agay ti Irkoy, ni baabaa Koyoo. Masi hunbur ka doo Misira, zama ay ga ni tee dumi beeri no din ra. ");
INSERT INTO ses_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Agay hunday ga doo ni bande Misira, de mo agay zaati no ma yee ka ni žigandi ka hun no din. Isufi no ma ni moɲey mooru.» ");
INSERT INTO ses_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Yakuba hun Ber-Šeba. Izirayel izey na ngi baabaa Yakuba, nda ngi izey, nda ngi wandey žigandi bari torkawey boŋ kaŋ Firawuuna nʼi sanba nga kateyanoo se. ");
INSERT INTO ses_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","I na ngi alman kurey nda gomney zaa kaŋ i duu ey Kanaŋ gandaa ra. Yakuba koy nda nga bande nga hayroo kul Misira, ");
INSERT INTO ses_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","nga izʼarey, nda nga haamʼarey, nda nga ize woyey, nda nga haama woyey, nda nga hayroo kul. I too a bande Misira. ");
INSERT INTO ses_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Izirayel izey maaɲey ne: Yakuba nda nga hayroo kaŋ koy Misira. Yakuba ize jinaa ti Rubeŋ. ");
INSERT INTO ses_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rubeŋ izʼarey ti: Hanok, nda Palu, nda Hesroŋ, nda Karmi. ");
INSERT INTO ses_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simewoŋ izʼarey ti: Yemuwel, nda Yamin, nda Ohad, nda Yakin, nda Sohar, nda Šawul kaŋ ti Kanaŋ woyoo izʼaroo. ");
INSERT INTO ses_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lewi izʼarey ti: Geršoŋ, nda Kehat, nda Merari. ");
INSERT INTO ses_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Žuda izʼarey ti: Er, nda Onaŋ, nda Šela, nda Peres, nda Zera. Er nda Onaŋ mana buu kala Kanaŋ gandaa ra. Peres izʼarey manʼti kala Hesroŋ nda Hamul. ");
INSERT INTO ses_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakar izʼarey ti: Tola, nda Puwa, nda Yob, nda Šimroŋ. ");
INSERT INTO ses_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zabuloŋ izʼarey ti: Sered, nda Eloŋ, nda Yalel. ");
INSERT INTO ses_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Leya hayroo ti wey kaŋ a duu ey Yakuba se Padaŋ-Aram, nda Dina nga ize woyoo. Ngi izʼarey nda ngi ize woyey kul cere ra hinnaa manʼti kala boro waranza cindi hinza (33). ");
INSERT INTO ses_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gad izʼarey ti: Sefoŋ, nda Hagi, nda Šuni, nda Esiboŋ, nda Eri, nda Arodi, nda Areli. ");
INSERT INTO ses_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ašer izʼarey ti: Yimna, nda Yišwa, nda Yišwi, nda Beriya, nda Sera ngi woymaa. Beriya izʼarey ti: Heber nda Malkiyel. ");
INSERT INTO ses_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Zilpa kaŋ Labaŋ nʼa noo nga ize woyoo Leya se, hayroo ti wey kaŋ a duu ey. Ize boro woy cindi iddu (16) no a duu ey Yakuba se. ");
INSERT INTO ses_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Rašel, Yakuba wandoo izʼarey ti: Isufi nda Benžameŋ. ");
INSERT INTO ses_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Isufi duu Misira gandaa ra izʼarey kaŋ Poti-Fera kaŋ ti On sargari juwalkaa ize woyoo kaŋ ti Asanat nʼi hay a se: Manase nda Efrayim. ");
INSERT INTO ses_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benžameŋ izʼarey ti: Bela, nda Beker, nda Ašibel, nda Gera, nda Naamaŋ, nda Ehi, nda Roš, nda Mupim, nda Hupim, nda Ardu. ");
INSERT INTO ses_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Rašel hayroo ti wey kaŋ a duu ey Yakuba se. I kul cere ra manʼti kala boro woy cindi taaci (14). ");
INSERT INTO ses_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan izʼaroo ti Hušim. ");
INSERT INTO ses_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Neftali izʼarey ti: Yasiyel, nda Guni, nda Yeser, nda Šilem. ");
INSERT INTO ses_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Bilha kaŋ Labaŋ nʼa noo nga ize woyoo Rašel se, hayroo ti wey. A duu Yakuba se zankayaŋ, i kul cere ra manʼti kala ize boro iyye. ");
INSERT INTO ses_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Yakuba hugoo borey kul kaŋ hun a ga kaŋ koy a bande Misira, manʼti kala boro woydu cindi iddu (66) kaŋ nga izʼarey wandey sii i ra. ");
INSERT INTO ses_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Isufi izʼaru hinkaa kaŋ hayandi Misira nda Yakuba hugoo borey kul kaŋ koy a bande Misira manʼti kala boro woyye (70). ");
INSERT INTO ses_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakuba nka Žuda sanba nga jine Isufi do ka alhabar tee a se kaŋ nga goo ma koy Gošeŋ. Kaŋ i too Gošeŋ gandaa ra, ");
INSERT INTO ses_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Isufi na nga bari torkaa soolu ka žigi a boŋ ka koy nga baabaa Izirayel kubay Gošeŋ. Za a dii a, a na nga boŋ warra jindoo ga, a gay a ga jindoo dii ka hẽe. ");
INSERT INTO ses_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Izirayel nee Isufi se: «Sohõ, nda a baa ya buu, zama ay dii ni, ay dii kaŋ nʼga huna!» ");
INSERT INTO ses_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Isufi nee nga armey nda nga baabaa hugoo borey se: «Ay ga žigi ka koy alhabar daŋ Firawuuna ra ka nee a se: ‹Agʼarmey nda ay baabaa hugoo borey kul kaŋ goo Kanaŋ gandaa ra kaa ay jeroo ga. ");
INSERT INTO ses_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","I manʼti kala kurkawyaŋ, zama alman no i gʼa biiri. I kate ngi bande ngi alman buuney, nda ibeerey, nda haya kul kaŋ goo maaɲey ga.› ");
INSERT INTO ses_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Waati kaŋ Firawuuna na war cee ka nee: ‹Macin ti war goymiɲoo?› ");
INSERT INTO ses_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","War mʼa zaabi ka nee: ‹Ni tamey manʼti kala kurkawyaŋ za ngi zankataraa ga hala hõ, ir nda ir baabey kul.› Takaa woo ra war ga goro Gošeŋ gandaa ra, zama kuryan manʼti kala almuhal Misira borey se.» ");
INSERT INTO ses_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Isufi koy alhabar daŋ Firawuuna ra, a nee a se: «Ay baabaa, nda ay armey, nda ngi alman buuney, nda ibeerey, nda haya kul kaŋ goo maaɲey ga kaa ka hun Kanaŋ gandaa ra. Ngi ne Gošeŋ gandaa ra.» ");
INSERT INTO ses_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","A na boro guu zaa nga armey ra ka koy Firawuuna do. ");
INSERT INTO ses_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Firawuuna nee nga armey se: «Macin ti war goymiɲoo?» I na Firawuuna zaabi ka nee: «Ni tamey kaŋ ti ir nda ir kaagey manʼti kala kurkawyaŋ.» ");
INSERT INTO ses_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","I nee Firawuuna se koyne: «Ir nka kaa ka goro gandaa woo ra, zama nongu sii kaŋ ra ni tamey ga ngi almaney kur, heraa laala Kanaŋ gandaa ra. Sohõ naŋ ni tamey ma goro ka waati tee Gošeŋ gandaa ra.» ");
INSERT INTO ses_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Firawuuna nee Isufi se: «Ni baabaa nda ni armey kaa ni do, ");
INSERT INTO ses_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Misira gandaa ne ni jine. Ni baabaa nda ni armey gorandi gandaa nongu henna-hennaa ra. I ma goro Gošeŋ gandaa ra. Nda nʼga goykaw hennayaŋ bay i ra, mʼi daŋ agʼalmaney jine, i ma tee i se jineboro.» ");
INSERT INTO ses_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Isufi kate nga baabaa Yakuba kʼa cebe Firawuuna se. Yakuba gaara Firawuuna se. ");
INSERT INTO ses_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Firawuuna nee Yakuba se: «Jiiri marje bara ma ne?» ");
INSERT INTO ses_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakuba na Firawuuna zaabi ka nee: «Ay yawtaraa jiirey manʼti kala zangu nda waranza (130). Ay hunaroo jiirey ga kacca i ga laala, i mana too jiirey kaŋ ay kaagey duu ey ngi yawtaraa ra.» ");
INSERT INTO ses_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Yakuba yee ka gaara Firawuuna se, de a hun a do. ");
INSERT INTO ses_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Isufi na nga baabaa nda nga armey gorandi, de a nʼi noo doo Misira gandaa ra, gandaa nongu henna-hennaa ra, Ramses laamaa ra, nda takaa kaŋ nda Firawuuna nʼa yaamar. ");
INSERT INTO ses_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","A na nga baabaa, nda nga armey, nda nga baabaa hugoo borey kul noo ŋaayan, affoo kul a laasaabu kʼa noo haya kaŋ ga wasa nga borey hinnaa se. ");
INSERT INTO ses_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ŋaayan sii gandaa kul ra, zama heraa hanse ka laala. Misira nda Kanaŋ gandaa fara heraa maaganda se. ");
INSERT INTO ses_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Isufi na Misira nda Kanaŋ gandaa nooroo kul marga kaŋ nda borey na alkamaa day. A na nooroo woo kul ka koy Firawuuna hugoo ra. ");
INSERT INTO ses_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Waatoo kaŋ nooroo ben Misira nda Kanaŋ gandaa ra, Misira borey kul kaa Isufi do ka nee a se: «Ir noo taasu. Macin se ir ga buu nongu kaŋ ra ni goo, zama ir nooroo ben.» ");
INSERT INTO ses_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Isufi zaabi ka nee: «Nda war nooroo ben, wa kate war almaney, ay gʼi barmay war se nda taasu.» ");
INSERT INTO ses_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","I kate ngi almaney Isufi do. A na ngi baryey, nda alman buuney, nda ibeerey, nda farkey barmay i se nda taasu. A na jiiroo din tee a ga almaney kul barmay i se nda taasu. ");
INSERT INTO ses_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Waatoo kaŋ jiiroo woo ben, yeeši i kaa a do ka nee a se: «Ir koyoo, ir si hin kʼa tugu ma ne kaŋ ir noorey ben, alman kurey yee ni maaɲoo ga, haya kul mana cindi kaŋ ir ga kate a ma ne, kala ir kunturey nda ir faarey, ir koyoo. ");
INSERT INTO ses_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Macin se ir nda ir faarey ga faati nongu kaŋ ra ni goo? Ir nda ir faarey day nda taasu, woo ra ir nda ir faarey ga tee Firawuuna wane. Ir noo dumi hala ir ma huna ir masi koy buu, laboo mo masi koy hasara.» ");
INSERT INTO ses_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Takaa woo nda Isufi na Misira faarey kul day Firawuuna se, zama Misira borey affoo kul nka nga faaroo neere heraa kaŋ ga koy de, a ga tonton se. Misira gandaa tee Firawuuna wane. ");
INSERT INTO ses_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Isufi na borey daŋ koyrawey ra, mʼa dii Misira gandaa boŋ faa ga ka koy affaa ga. ");
INSERT INTO ses_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Sargari juwalkey hinne faarey no a manʼi day, zama haya no kaŋ Firawuuna nʼa zaa nga jindoo ga sargari juwalkey se. Ngi meehunaa si hun kala Firawuuna do, woo se i mana ngey faarey neere. ");
INSERT INTO ses_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Isufi nee borey se: «Ay na war nda war faarey day Firawuuna se. Dumi ne, war mʼa say faarey ra. ");
INSERT INTO ses_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Nda hegaa tee, zamna guu kul war ga affoo noo Firawuuna se, war ma itaacaa zaa kʼa tee dumi faarey se nda ŋaayan war hugey borey nda war izey se.» ");
INSERT INTO ses_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","I nʼa zaabi ka nee: «Nʼnʼir hundey hallasi. Yala ir ma duu alhormo ni do, ir koyoo ka tee Firawuuna se baɲɲa.» ");
INSERT INTO ses_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Isufi nʼa tee yaamar kaŋ ga bara hala hõ kaŋ Misira faari zamna guu kul affaa ti Firawuuna wane. Sargari juwalkey hinne waney no Firawuuna sʼi mayray. ");
INSERT INTO ses_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Izirayel goro Misira gandaa ra, Gošeŋ gandaa ra. I tee no din ra almankoyni, i duu izeyaŋ, de i hanse ka boobo. ");
INSERT INTO ses_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakuba huna jiiri woy cindi iyye (17) Misira gandaa ra. Aloomuroo kaŋ Yakuba duu a manʼti kala jiiri zangu nda woytaaci cindi iyye (147). ");
INSERT INTO ses_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Waatoo kaŋ Izirayel man buuyan, a na nga izoo Isufi cee, a nee a se: «Ay gʼa wiri ni ga, alhormo tee ya ne, ma ni kaboo daŋ ay ceehamoo cire ka allaahidu zaa ya ne nda baji nda laadirtaraa kaŋ nʼsʼay sutura Misira. ");
INSERT INTO ses_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Waati kaŋ ay koy ay hayragey gar alaahara, mʼay zaa ka hun Misira ka koy ay sutura ay hayragey hugoo ra.» Isufi zaabi ka nee: «Woo kaŋ nʼnʼa har, nga no ay gʼa tee.» ");
INSERT INTO ses_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yakuba nee: «A žee ya ne.» Isufi žee a se. Woo banda ga, Izirayel sujudu nga daaroo boŋoo ga. ");
INSERT INTO ses_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Hayey din kaŋ tee banda ga, boroyaŋ kaa ka nee Isufi se: «Ma bay, ni baabaa sii nda baani.» Isufi na nga izʼaru hinkaa kaŋ ti Manase nda Efrayim zaa nga bande. ");
INSERT INTO ses_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Boroyaŋ na alhabar daŋ Yakuba ra ka nee a se: «Ni izʼaroo Isufi ne ma kaa ni do.» Izirayel na gaabi daŋ nga boŋ ra, a goro daaroo boŋ. ");
INSERT INTO ses_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yakuba nee Isufi se: «Irkoy, Hini-kul-koyoo bangay ya ne Luz, Kanaŋ gandaa ra, a gaara ya ne. ");
INSERT INTO ses_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","A nee ya ne: ‹Nga ne, ay ga ni noo hayyan, ay ga ni boobandi, ay ga ni tee dumi boobo. Ay ga gandaa woo noo ni hayyanoo se ni banda ga, a mʼa mayray hala abada.› ");
INSERT INTO ses_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Sohõ izʼaru hinkaa kaŋ ni duu ey za ya na kaa ni do Misira gandaa ra, i ga tee ay wane. Efrayim nda Manase ga tee ay wane sanda Rubeŋ nda Simewoŋ. ");
INSERT INTO ses_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Amma ni hayroo kaŋ nʼgʼa hay dumawey ga, ga tee ni wane. Ngi armey bagaa ra i ga tubu. ");
INSERT INTO ses_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Agay, nʼga bay, waatoo kaŋ ay ga kaa ka hun Padaŋ, Rašel buu ay kaboo ra, Kanaŋ gandaa ra. Diray cindi ir nda koyraa game kaŋ se i ga nee Efrata. No din ra ay nʼa sutura, Efrata fondaa ra. Efrata da ti Betelehem.» ");
INSERT INTO ses_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Izirayel dii Isufi izʼarey, de a nee: «Mayyan ti wey?» ");
INSERT INTO ses_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Isufi na nga baabaa zaabi ka nee: «Izʼarey no kaŋ Irkoy nʼi noo ya ne, ne ra.» Yakuba nee: «Ay gʼa wiri ni ga, i manandi agay hala ay ga gaara i se.» ");
INSERT INTO ses_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Žeenayyanoo na Izirayel moɲey kokoorandi hala nongu kaŋ ra a si dii koyne. A nʼi manandi a ga. Yakuba nʼi summu, a nʼi naagu nga gandoo ra. ");
INSERT INTO ses_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Izirayel nee Isufi se: «Ya na hongu wala ay ga dii ni koyne, amma nga ne, Irkoy nʼay cebe ba ni hayroo.» ");
INSERT INTO ses_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Isufi nʼi kaa nga baabaa cewey boŋ, a na nga ndumoo sinji laboo ra ka gunguma. ");
INSERT INTO ses_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Woo banda ga, Isufi na ngi boro hinkaa kul zaa, Efrayim goo Isufi kabe gumaa here, Izirayel kabe waawaa ga, Manase goo nga kabe waawaa here, Izirayel kabe gumaa ga. A nʼi manandi a ga. ");
INSERT INTO ses_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Izirayel na nga kabe gumaa šerre kʼa fur Efrayim kaŋ ti kayne boŋoo ga, a na nga kabe waawaa fur Manase boŋoo ga. A nka nga kabey bere cere se, zama Manase ti beere. ");
INSERT INTO ses_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","A gaara Isufi se jina, a nee: «Yala Irkoy kaŋ fondaa ra ay hayragey Ibirahima nda Isiyaka dira, yala Irkoy kaŋ nʼay kur za ay huru aduɲɲa ra hala hõ, ");
INSERT INTO ses_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","yala almalaykaa kaŋ nʼay hallasi ifutu kul ra, ma albarka daŋ zankey wey ra. Yala ay maaɲoo nda ay hayragey Ibirahima nda Isiyaka maaɲey ma ciya i ga. Yala i ma boobo gandaa ra kʼa too!» ");
INSERT INTO ses_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Isufi dii kaŋ nga baabaa na nga kabe gumaa fur Efrayim boŋoo ga, a mana kan a se. A na nga baabaa kaboo zaa ka nee nga gʼa kaa Efrayim boŋoo ga ka fur Manase wanoo ga. ");
INSERT INTO ses_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Woo banda ga, a nee nga baabaa se: «Manʼti takaa woo no, ay baabaa! Zama woo ti beere, ni kabe gumaa fur boŋoo ga.» ");
INSERT INTO ses_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Baaboo wanji, a nee: «Ay ga bay, ay izoo, ay ga bay, a ga tee jama, nga mo ga tee boro beeri. Amma nga kaynoo ga beeri nda a, de nga hayroo ga dumi boobo tee.» ");
INSERT INTO ses_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Hanoo woo, a gaara i se, de a nee: «War maaɲey nda Izirayel borey ga gaara ka nee: ‹Irkoy ma ni tee sanda Efrayim nda Manase!›» Takaa woo nda a na Efrayim daŋ Manase jine. ");
INSERT INTO ses_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Izirayel nee Isufi se: «Agay ne buuyan mee ga, Irkoy goo war bande, de a ga war yeeti war hayragey gandaa ra. ");
INSERT INTO ses_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Agay, ay ga ni noo Šekem kaŋ ay nʼa taa nda ay takubaa nda ay biraa Amor borey kone. A ga tee ma ne tontoni ka bisa ni armey.» ");
INSERT INTO ses_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yakuba ciya nga izʼarey se, a nee i se: «Wa marga, ay ga hayey filla war se kaŋ ga kaa ka tee zamaney kaŋ ga kaa ra. ");
INSERT INTO ses_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Wa marga ka haŋajer, Yakuba izʼarey, wa maa war baabaa Izirayel se. ");
INSERT INTO ses_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rubeŋ, ni ti ay izʼaru jinaa, agʼalfaydaa nda ay gaabi jina-jinawey ra ay duu ni, ni beeraa nda ni hinoo bisa ni armey waney. ");
INSERT INTO ses_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Nʼga zarga sanda hari, woo se nʼsi tee jineboraa koyne! Zama ni žigi ni baabaa kanidogoo boŋ, nʼnʼa kaynandi. A žigi ay daaroo boŋ! ");
INSERT INTO ses_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simewoŋ nda Lewi manʼti kala armayaŋ kaŋ anniyawey manʼti kala kurimunyan. ");
INSERT INTO ses_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ay hundoo sii ngi ceretaraa ra, ay binoo sii ngi margaroo ra, zama ngi futuyanoo ra i na aruyaŋ wii, ngi hooraa ra i na yaaruyaŋ malal. ");
INSERT INTO ses_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ngi hottayyanoo ma laali, zama a ga koron. Ngi futuyanoo ma laali, zama a ga laala. Ay gʼi say Yakuba gandaa ra. Ay gʼi say-say Izirayel gandaa kul ra. ");
INSERT INTO ses_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Žuda, ni, ni armey ma ni saabu, ni kaboo ga ni iberey gungumandi, de mo ni baaba-izey ga sujudu ni jine. ");
INSERT INTO ses_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Žuda manʼti kala ganjihayla-ize, nʼga hun hoodogoo ra, ay izʼaroo. A ga kani ka hunanzam sanda ganjihayla aru wala sanda ganjihayla woy. May no ma yadda kʼa tunandi? ");
INSERT INTO ses_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Kokoytaray goboo si hun Žuda kone. Boŋkoynitaray goboo si hun kaboo ra, hala nga koy cimi-cimoo kaayanoo ga, nga kaŋ se gandawey kul borey ga yee ganda. ");
INSERT INTO ses_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Žuda ga nga farkaa haw alanebɲaŋoo ga, alanebɲaa hennaa ga nga farka-izoo ga hawa. Alaneb hari mooraa ra a ga nga bankaaraa ɲumandi, alaneb-izoo hari ciraa ra a ga nga darbay beeroo ɲumandi. ");
INSERT INTO ses_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Moɲey nere nda alaneb hari moora, de hiɲey kaaray nda waa. ");
INSERT INTO ses_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zabuloŋ ga goro teekoo miɲoo ga, a goo harihiyey guraa ga, nga laamaa ga koy hala Sidoŋ here. ");
INSERT INTO ses_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakar manʼti kala farka gaabikoyni kaŋ ga kani kaley gamey ra. ");
INSERT INTO ses_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","A dii kaŋ hunanzamdoo ga boori, gandaa ga kan. A na nga jesoo gaaru ka jere. A ga baɲɲataray goy tee. ");
INSERT INTO ses_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan ga ciiti nga dumoo se sanda Izirayel alkabiila foo. ");
INSERT INTO ses_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan ga tee gandakarfu kaŋ goo fondaa ra, a ga tee gondi kaŋ goo lolaa ra kaŋ ga bari cee ɲama hala bari kaarukaa ma kaŋ nda banda. ");
INSERT INTO ses_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Abadantaa, ay ga ni hallasiroo batu. ");
INSERT INTO ses_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad, bone teekawyaŋ ga marga a ga, amma nga, a gʼi dii nda banda. ");
INSERT INTO ses_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Ašer do ŋaayan henna ga hun, nga do kokoy ŋaayaney ga hun. ");
INSERT INTO ses_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Neftali manʼti kala jeeri kaŋ sii boro mayray ra. A ga ize hennayaŋ hay. ");
INSERT INTO ses_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Isufi manʼti kala yaaru, yaaru kaŋ goo hari jere ga, yaaruyaŋ kaŋ goo tondi hondu jese ga. ");
INSERT INTO ses_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Birawkarkey nʼa tooɲe, i nʼa kar, i nʼa yenje, ");
INSERT INTO ses_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","amma nga biraa alfaydaa ga gay, nga kabey goo nda gaabi, Hinikoyoo kaŋ ti Yakuba Koyoo kabey bande, Kurkaa kaŋ ti Izirayel Tondoo, maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Ni baabaa Koyoo ga ni faaba, Hini-kul-koyoo ga albarka daŋ ni ra. Nʼga duu beenaa haroo albarkaa, nda laboo cire guusu beeroo haroo albarkaa, nʼga duu ni almaney nda ni hayroo albarkaa. ");
INSERT INTO ses_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ni baabaa gaararey ga bisa ay hayragey waney, i ga too hala hondey kaŋ ga bara waati kul. Yala i ma tabati Isufi boŋoo ga, nga armey boŋkoynoo teɲaa ga! ");
INSERT INTO ses_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benžameŋ manʼti kala ganjihanši kaŋ ga kotta. Subbaahoo ra, a ga hayaa ŋaa kaŋ a duu a, cijinoo ra, a ga nga alganiimaa zamna.» ");
INSERT INTO ses_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Izirayel alkabiila woy cindi hinkaa (12) kul ti woo. Šenney ti wey kaŋ ngi baabaa nʼi har i se nga gaararoo ra. A gaara i se affoo kul nda nga gaararoo. ");
INSERT INTO ses_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Woo banda ga, Yakuba na nga izʼarey yaamar ka nee: «Ay ga koy ay hayragey gar alaahara, war mʼay sutura ay baabey jerey ga, tondi guusoo ra kaŋ goo Eferoŋ Heti boraa faaroo ra, ");
INSERT INTO ses_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Makupela faaroo tondi guusoo ra kaŋ ga Mamre tenje, Kanaŋ gandaa ra. Faaroo no kaŋ Ibirahima nʼa day Eferoŋ Heti boraa ga kʼa tee saaray. ");
INSERT INTO ses_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","No din ra Ibirahima nda nga wandoo Sarata suturandi. No din ra Isiyaka nda nga wandoo Rebeka suturandi. No din ra ay na Leya sutura. ");
INSERT INTO ses_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Faaroo nda tondi guusoo kaŋ goo a ra mana dayandi kala Heti borey ga.» ");
INSERT INTO ses_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Waatoo kaŋ Yakuba na nga izʼarey yaamar ka ben, a na nga cewey marga nga daaroo ra, hundoo hun, a koy nga hayragey gar alaahara. ");
INSERT INTO ses_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Isufi gum nga baabaa ndumoo boŋ, a hẽe a ga, a nʼa summu. ");
INSERT INTO ses_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Isufi na safarkey, nga tamey yaamar i ma nga baabaa yon. I na Izirayel yon. ");
INSERT INTO ses_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","I na jirbi woytaaci (40) tee a ra, zama woo ti jirbey kaŋ kayandi yonyan se. Misira borey nʼa hẽe jirbi woyye (70). ");
INSERT INTO ses_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Waatoo kaŋ nga buuyanoo goraa jirbey bisa, Isufi šelaŋ Firawuuna hugoo borey se ka nee: «Wa alhormo tee ya ne, ay gʼa wiri war ga, war mʼay dontaa ka too Firawuuna do ka nee a se: ");
INSERT INTO ses_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‹Ay baabaa nkʼay žeendi ka nee kaŋ nga ne, buuyan mee ga, nga saaraa kaŋ nga nʼa soolu Kanaŋ gandaa ra, no din ra ya nga sutura.› Sohõ ay ga baa ya žigi ka koy ay baabaa sutura, de ya yee kate.» ");
INSERT INTO ses_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Firawuuna zaabi ka nee: «Žigi ka koy ni baabaa sutura sanda takaa kaŋ nda a na ni žeendi.» ");
INSERT INTO ses_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Isufi žigi ka koy nga baabaa sutura. Firawuuna borey kul, nda nga hugoo boro beerey, nda Misira gandaa boro beerey kul žigi ka koy a bande, ");
INSERT INTO ses_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","nda Isufi hugoo kul, nda nga armey, nda nga baabaa hugoo borey. Haya kul mana cindi Gošeŋ gandaa ra kala zankey hinne, nda ngi alman buuney, nda ngi ibeerey. ");
INSERT INTO ses_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Bari torkayaŋ nda bari kaarukawyaŋ hanga Isufi bande. Hayey kaŋ hanga a bande ga hanse ka boobo. ");
INSERT INTO ses_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Waatoo kaŋ i too taasu kar ganganoo do kaŋ se i ga nee Atadu kaŋ goo Žurdeŋ isaa se banda, no din ra i na buuyanoo hẽe, hẽeni beeri šenda-šenda, de a na nga baabaa buuyanoo goro jirbi iyye. ");
INSERT INTO ses_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Gandaa gorokey kaŋ ti Kanaŋ borey dii takaa kaŋ nda i na buuyanoo hẽe Atadu ganganoo ra, de i nee: «Woo ti buuyan beeri Misira borey se!» Woo se i na ganganoo din maaɲoo daŋ Abel-Misirayim (maanaa «buuyanoo goraa kaŋ Misira borey nʼa tee»), a goo Žurdeŋ isaa se banda. ");
INSERT INTO ses_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Izirayel izʼarey nʼa tee nda takaa kaŋ nda a nʼi yaamar. ");
INSERT INTO ses_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Nga izʼarey nʼa ka koy Kanaŋ gandaa ra, i nʼa sutura tondi guusoo ra kaŋ goo Makupela faaroo ra. Faaroo no kaŋ Ibirahima nʼa day Eferoŋ Heti boraa ga kaŋ ga Mamre tenje, kʼa tee saaray. ");
INSERT INTO ses_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Waatoo kaŋ Isufi na nga baabaa sutura ka ben, a yee Misira, nga nda nga armey, nda borey kul kaŋ žigi a bande ka koy baaboo sutura. ");
INSERT INTO ses_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Kaŋ Isufi armey dii kaŋ ngi baabaa buu, i nee cere se: «Sohõ, nda Isufi konna ir, a ga hin ka ifutaa kul kaŋ ir bay kʼa tee a se bana ir ra!» ");
INSERT INTO ses_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","I donto ka nee Isufi se: «Za ni baabaa mana buu a na yaamar foo noo ka nee: ");
INSERT INTO ses_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‹Wa nee Isufi se kaŋ ay gʼa wiri a ga a ma nga armey hooyanoo nda ngey zunuboo yaafa i se, zama goy futu no i nʼa tee ma ne!› Adiši sohõ ni baabaa Koyoo tamey hooyanoo yaafa i se!» Kaŋ Isufi maa šenney wey kul, a hẽe. ");
INSERT INTO ses_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Nga armey hunday kaa ka gunguma jinoo ra ka nee: «Nga ne, ir ga tee ma ne baɲɲa.» ");
INSERT INTO ses_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Isufi nʼi zaabi ka nee: «War masi hunbur! Agay ti Irkoy wala? ");
INSERT INTO ses_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","War, war miile ka ifutu tee ya ne, amma Irkoy nʼa bere kʼa tee ihenna, hala hayaa kaŋ ne ka tee ma duu ka teendi. Jama beeri ma duu hallasiyan. ");
INSERT INTO ses_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Sohõ war masi hunbur, ay ga war nda zankey ŋandi.» Šenni henney wey nda a na biney yaynandi. ");
INSERT INTO ses_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Woo banda ga, Isufi cindi Misira, nga nda nga baabaa hugoo borey. Isufi huna jiiri zangu nda iwoy (110). ");
INSERT INTO ses_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","A dii Efrayim izʼarey nda izʼarey izey. A dii mo Makir kaŋ ti Manase izʼaroo, izey, i hayandi cewey boŋ. ");
INSERT INTO ses_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Isufi nee nga armey se: «Agay ne buuyan mee ga. Irkoy si dirɲa war, a ga war ka žigi ka hun gandaa woo ra, ka war ka koy gandaa ra kaŋ a žee nga gʼa noo Ibirahima, nda Isiyaka, nda Yakuba se.» ");
INSERT INTO ses_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Woo banda ga, Isufi na Izirayel izey žeendi ka nee: «Waati kaŋ Irkoy hongu war, war mʼay birey ka žigi ka hun ne.» ");
INSERT INTO ses_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Isufi buu nga jiiri zangu nda iwoyaa (110) ga. I nʼa yon, i nʼa daŋ bukawey ceesu foo ra Misira.");
INSERT INTO ses_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Izirayel izey kaŋ huru Yakuba bande Misira, affoo kul nda nga alaayaney, maaɲey ne: ");
INSERT INTO ses_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubeŋ, nda Simewoŋ, nda Lewi, nda Žuda, ");
INSERT INTO ses_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","nda Isakar, nda Zabuloŋ, nda Benžameŋ, ");
INSERT INTO ses_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","nda Dan, nda Neftali, nda Gad, nda Ašer. ");
INSERT INTO ses_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Borey kul kaŋ hun Yakuba ga hinnaa manʼti kala boro woyye (70). Isufi goo Misira ka ben. ");
INSERT INTO ses_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Woo banda ga, Isufi buu, armey kul buu, alwaddaa din borey kul buu. ");
INSERT INTO ses_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Amma Izirayel borey duu hayyan boobo, ka gooru, ngi hinnaa tonton, i hanse ka duu gaabi. I na gandaa too. ");
INSERT INTO ses_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Kokoy taaga kaa ka Misira laama kaŋ si Isufi bay. ");
INSERT INTO ses_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Kokoyoo nee nga jamaa se: «Nga ne, Izirayel borey jamaa boobo nda ir, i gaabi nda ir. ");
INSERT INTO ses_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Ir ma hawgay, ir ma lakkal daŋ ka taka tee kaŋ ra i masi tonton. A ga hin ka tee, nda wongu tun, i ga tee affoo ngi nda ir iberey kʼir wongu jina ka gandaa naŋ.» ");
INSERT INTO ses_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Woo se Misira borey na boroyaŋ daŋ Izirayel jamaa jine kaŋ gʼi torro, i nʼi daŋ waazibi goyyaŋ ra. I na koyrayaŋ kaŋ ti jinay fanjidooyaŋ cin Firawuuna se, koyrawey maaɲey ti: Pitom nda Ramses. ");
INSERT INTO ses_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Amma kaŋ i gʼi torro kul i mma tonton, i ga boobo. I konna Izirayel borey. ");
INSERT INTO ses_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Misira borey na Izirayel borey daŋ tamtaray šenda ra. ");
INSERT INTO ses_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","I na tamtaray šendaa kʼi konnandi aduɲɲa. I ga labu goy, i ga feraw kar, i ga goy dumi kul tee faarey ra. Goyey kul kaŋ ra i nʼi daŋ manʼti kala tamtaray šenda. ");
INSERT INTO ses_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Misira kokoyoo šelaŋ Eberewey hayandikey se, affoo maaɲoo ti Šifra, affaa maaɲoo ti Puwa. ");
INSERT INTO ses_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","A nee i se: «Nda war ga Ebere woyey hayandi, de war ga dii kaŋ izʼaru no, war mʼa wii, nda ize woy no, war mʼa naŋ a ma huna.» ");
INSERT INTO ses_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Amma hayandikey ga hunbur Irkoy, i mana hayaa tee kaŋ Misira kokoyoo nʼa har i se. I na zankaarey naŋ i ma huna. ");
INSERT INTO ses_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Misira kokoyoo ciya hayandikey se, a nee i se: «Cin se war na woo tee, ka zankaarey naŋ i ma huna?» ");
INSERT INTO ses_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Hayandikey nee Firawuuna se: «Ebere woyey nda Misira woyey manʼti affoo, Ebere woyey ga sahã, hala hayandikaa ga too kate i do gar i duu ngi boŋ ka ben.» ");
INSERT INTO ses_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Irkoy na haya henna tee hayandikey se. Jamaa mo tonton, i hanse ka duu gaabi. ");
INSERT INTO ses_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Zama hayandikey hunbur Irkoy, a nʼi noo hayyan. ");
INSERT INTO ses_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Firawuuna na nga jamaa kul yaamar ka nee: «Izʼaru kul kaŋ hayandi, war mʼa warra isaa ra, amma ize woy, war mʼa naŋ a ma huna.» ");
INSERT INTO ses_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Lewi hugoo boro na Lewi ize woy foo hiiji. ");
INSERT INTO ses_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Woyoo tee gunde, a na izʼaru hay. A dii kaŋ zankaa ga boori, a nʼa tugu handu hinza. ");
INSERT INTO ses_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Amma kaŋ a too nongu kaŋ ra a si hin kʼa tugu koyne, a na seji tee nda subu, a nʼa yon nda guduroŋ nda yonhaya. A na zankaa kanandi a ra kʼa fur isaa miɲoo ga subey game. ");
INSERT INTO ses_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Zankaa woymaa ga kay nongu mooro ra ka guna haya kaŋ ga kaa ka duu a. ");
INSERT INTO ses_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Firawuuna ize woyoo doo isaa ga ka koy ɲumay, woy soogey kaŋ goo a bande ga yaara-yaara jaboo ga. A dii sejoo subey game, a daŋ nga koŋŋaa ma koy a zaa kate. ");
INSERT INTO ses_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","A nʼa feeri, de a dii zankaa. Zankaaru no kaŋ goo ma hẽe. A hinna a se, a nee: «Eberewey zanka no.» ");
INSERT INTO ses_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Woymaa nee Firawuuna ize woyoo se: «Nʼga baa ya koy naanandikaw ceeci ma ne Ebere woyey ra hala a ma zankaa naanandi ma ne?» ");
INSERT INTO ses_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Firawuuna ize woyoo nee a se: «Ayyo». Woy soogaa koy zankaa ɲaa cee kate. ");
INSERT INTO ses_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Firawuuna ize woyoo nee woyoo se: «Zankaa woo zaa, ma cindi kʼa naanandi ya ne, ay ga ni bana.» Woyoo na zankaa zaa ka cindi kʼa naanandi. ");
INSERT INTO ses_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Waatoo kaŋ zankaa beeri, woyoo kate a Firawuuna ize woyoo se. A tee nga izoo, a na maaɲoo daŋ Musa (maanaa «a nka zandi»), a nee: «Zama haroo ra ay nʼa zaa.» ");
INSERT INTO ses_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Waatoo kaŋ Musa beeri, han foo a fatta ka koy nga armey do, a dii waazibi goyey kaŋ ra i goo. A dii Misira aru foo kaŋ ga Ebere aru kar, nga armey affoo no. ");
INSERT INTO ses_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","A na jine nda banda guna, a dii kaŋ boro sii no, a na Misira aroo kar kʼa wii kʼa tugu labutaasoo ra. ");
INSERT INTO ses_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Subaa ra, a fatta koyne, nga ne, a dii Ebere boro hinka kaŋ ga yenje. A nee boraa kaŋ tooɲe se: «Macin se nʼga ni ceroo kar?» ");
INSERT INTO ses_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","A nee: «May ka ni tee ir boŋkoynoo nda ir alkaaloo? Ni mma baa mʼay wii sanda takaa kaŋ nda bi nʼna Misira aroo wii?» Musa hunbur, a nee nga boŋ se: «Hayaa bayrandi.» ");
INSERT INTO ses_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Waatoo kaŋ Firawuuna maa šennoo, a ceeci ka Musa wii. Amma Musa zuru ka hun Firawuuna ra ka koy goro Majaŋ gandaa ra. A goro day foo jere. ");
INSERT INTO ses_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Majaŋ gandaa sargari juwalkaa goo nda ize woy iyye, i ga kaa ka gur ka ngi hari haŋ jinawey too ka ngi baabaa almaney haŋandi. ");
INSERT INTO ses_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Amma kurkawyaŋ kaa kʼi gaaray, de Musa tun ka faasa i se ka ngi almaney noo hari i ma haŋ. ");
INSERT INTO ses_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Waatoo kaŋ i yee ngi baabaa Rehuwel do, a nee i se: «War ya yee kate tanba hõ?» ");
INSERT INTO ses_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","I nee: «Misira aru foo kʼir kaa kurkey kabey ra, ba hari nga kʼa gur ir se ka almaney haŋandi.» ");
INSERT INTO ses_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","A nee nga ize woyey se: «Man aroo goo? Macin se war nʼa naŋ? Wʼa cee, a ma kaa ka ŋaa!» ");
INSERT INTO ses_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Musa yadda ka goro aroo do, a na Musa noo nga ize woyoo kaŋ maaɲoo ti Sefora. ");
INSERT INTO ses_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","A na izʼaru foo daŋ aduɲɲa ra, Musa na maaɲoo daŋ Geršom (maanaa «ka koy goro no din»), a nee: «Ya nka koy goro labu waani ra.» ");
INSERT INTO ses_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Waati kukoo woo ra Misira kokoyoo buu. Izirayel borey hottu, i kaati, de ngi goyoo hottaa kaatiroo ka faaba ceeci žigi ka too Irkoy do. ");
INSERT INTO ses_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Irkoy maa ngi hẽenoo, a hongu nga amaanaa kaŋ goo nga, nda Ibirahima, nda Isiyaka, nda Yakuba game. ");
INSERT INTO ses_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Irkoy na Izirayel borey guna, a dii ngi takaa. ");
INSERT INTO ses_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Musa ga nga nzuraa Žetro kaŋ ti Majaŋ gandaa sargari juwalkaa almaney kur. A na almaney ka koy saajoo dumaa ga, a too Irkoy tondi hondoo do kaŋ se i ga nee Horeb. ");
INSERT INTO ses_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Abadantaa almalaykaa bangay a se nuune deene ra, saabayɲaa game. A ga saabayɲaŋoo guna, nga ne, a ga dii, amma nuunaa si saabayɲaŋoo diinandi. ");
INSERT INTO ses_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Musa nee: «Ay ga kuubi ka koy bangayyan beeroo woo guna, macin se saabayɲaŋoo si ton.» ");
INSERT INTO ses_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Abadantaa dii kaŋ a goo ma kuubi ka koy guna, Irkoy goo saabayɲaŋoo gamoo ra, a nʼa cee ka nee: «Musa! Musa!» A nee: «Agay ne.» ");
INSERT INTO ses_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Irkoy nee: «Masi man kate ne, ni taamey kaa ni cewey ra, zama nongoo kaŋ ra ni goo ma kay manʼti kala labu henanante.» ");
INSERT INTO ses_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","A nee koyne: «Ay manʼti kala ni baabaa Koyoo, Ibirahima Koyoo, Isiyaka Koyoo, Yakuba Koyoo.» Musa na nga ndumoo daabu, zama a ga hunbur nga ma Irkoy guna. ");
INSERT INTO ses_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Abadantaa yee ka nee: «Ay dii, ay dii ay jamaa torraa Misira gandaa ra, ngi kaatiroo kaŋ i gʼa tee ngi waazibi goyey juwalkey maaganda se, ay maarʼa, ay ga bay kaŋ i goo hottay ra. ");
INSERT INTO ses_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Ay zunbu ka kaa kʼi kaa Misira borey hinoo cire kʼi žigandi ka koy ganda henna hayante ra kaŋ ra waa nda yuu ga tee hari, Kanaŋ borey gorodogoo, nda Heti borey gorodogoo, nda Amor borey gorodogoo, nda Ferezi borey gorodogoo, nda Hewi borey gorodogoo, nda Žebus borey gorodogoo no. ");
INSERT INTO ses_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Sohõ nga ne, Izirayel borey kaatiroo too kate hala ay do, ay dii torraa kaŋ Misira borey nʼa daŋ i ga. ");
INSERT INTO ses_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Sohõ koy, ay ga ni sanba Firawuuna do, mʼay jamaa Izirayel borey kaataray Misira.» ");
INSERT INTO ses_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Musa nee Irkoy se: «May ti agay kaŋ ga koy Firawuuna do ka Izirayel borey fattandi Misira?» ");
INSERT INTO ses_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Irkoy nee: «Ay goo ni bande, silbaa ne kaŋ ga cebe kaŋ agay ka ni sanba: waati kaŋ nʼna jamaa fattandi Misira, war ga Irkoy gana tondi hondoo woo boŋ.» ");
INSERT INTO ses_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Musa nee Irkoy se: «Aywa, nda ay koy Izirayel borey do ka nee i se: ‹War baabey Koyoo kʼay sanba war do.› Nda i nee ya ne: ‹Macin ti maaɲoo?›, macin no ay gʼa har i se?» ");
INSERT INTO ses_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Irkoy nee Musa se: «Agay ti a ga bara.» A nee a se: «Nee Izirayel borey se: ‹“A ga bara” kʼay sanba war do.›» ");
INSERT INTO ses_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Irkoy yee ka nee Musa se: «Nee Izirayel borey se: ‹Abadantaa, war baabey Koyoo, Ibirahima Koyoo, Isiyaka Koyoo, Yakuba Koyoo kʼay sanba war do. Woo ti ay maaɲoo hala abada. Woo ti ay maaɲoo kaŋ ga ciyandi zaman ka kaa zaman.› ");
INSERT INTO ses_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Koy ma Izirayel boro beerey marga, ma nee i se: ‹Abadantaa, war baabey Koyoo, Ibirahima Koyoo, Isiyaka Koyoo, Yakuba Koyoo bangay ya ne, a nee: “Ay dii war, ay ga haya bay kaŋ goo war ga Misira.”› ");
INSERT INTO ses_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ay nee: ‹Ay ga torraa zaa war ga kaŋ Misira borey nʼa daŋ war ga ka war ka koy Kanaŋ borey gandaa ra, nda Heti borey gandaa ra, nda Amor borey gandaa ra, nda Ferezi borey gandaa ra, nda Hewi borey gandaa ra, nda Žebus borey gandaa ra, ganda kaŋ ra waa nda yuu ga tee hari.› ");
INSERT INTO ses_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","I ga haŋajer ni šennoo se, ma huru, ni nda Izirayel boro beerey Misira kokoyoo do, war ma nee a se: ‹Abadantaa, Eberewey Koyoo bangay ir se, sohõ ir gʼa wiri ni ga, mʼir naŋ ir ma jirbi hinza diray tee ka koy saajoo ra ka sargari kaa Abadantaa, ir Koyoo maaɲoo ga.› ");
INSERT INTO ses_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Amma ay ga bay kaŋ Firawuuna, Misira kokoyoo si war naŋ war ma koy nda manʼti a nka waazibi a ga. ");
INSERT INTO ses_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Ay gʼay kaboo šerre ka Misira kar nda kayfey kul kaŋ ay gʼi tee i game. Woo banda ga, a ga war naŋ war ma koy. ");
INSERT INTO ses_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Ay ga jamaa woo noo alhormo Misira borey do. Waati kaŋ war ga koy, war si koy kabe koonu. ");
INSERT INTO ses_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Woy foo kul ma nga taalammaa nda nga gorokasinaa wiri nzorfu jinay, nda wura jinay, nda bankaaray, war mʼi daŋ war izʼarey nda war ize woyey ga, war ma Misira borey kabey koonandi.» ");
INSERT INTO ses_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Musa zaabi ka nee: «Nga ne, i si naanay agay, i si haŋajer ay šennoo se, i ga nee: ‹Abadantaa mana bangay ma ne.›» ");
INSERT INTO ses_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Abadantaa nee a se: «Macin bara ni kaboo ra?» A nee: «Gobu.» ");
INSERT INTO ses_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Abadantaa nee: «A warra ganda». A nʼa warra ganda, a tee gondi, Musa zuru a jine. ");
INSERT INTO ses_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Abadantaa nee Musa se koyne: «Ni kaboo šerre kʼa dii nda nsunfaa.» A na nga kaboo šerre kʼa dii, a bere ka tee gobu kaboo ra. ");
INSERT INTO ses_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Abadantaa nee: «Woo ga kate i ma naanay kaŋ ngi baabey Koyoo, Ibirahima Koyoo, Isiyaka Koyoo, Yakuba Koyoo bangay ma ne.» ");
INSERT INTO ses_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Abadantaa nee a se koyne: «Ni kaboo fur ni gandey ga.» A nʼa fur a ga, waatoo kaŋ a nʼa kaataray, nga ne, a jiray, a kaaray ma nee waa. ");
INSERT INTO ses_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","A nee koyne: «Ni kaboo yeeti ni gandey ga.» A nʼa yeeti gandey ga, a nʼa kaataray, nga ne, kaboo yee nga taka žeenaa ga. ");
INSERT INTO ses_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Abadantaa nee: «Nda a tee i mana naanay ni ka yadda tammaasa jinaa ga, i ga naanay ihinkantoo maaganda se. ");
INSERT INTO ses_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Nda a tee tammaasa hinkaa woo kul ga i mana naanay, i mana haŋajer ni šennoo se, ma isaa haroo zaa mʼa doori laboo ra, haroo kaŋ nʼnʼa zaa isaa ra ga bere ka tee kuri laboo ra.» ");
INSERT INTO ses_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Musa nee Abadantaa se: «Ya ay Koyoo, ay manʼti boro kaŋ ga šenni ga faala, manʼti bi, manʼti biifoo, manʼti za ni šintin ka šelaŋ ni tamoo se, zama ay miɲoo ga tiŋ, ay deenoo ga tiŋ.» ");
INSERT INTO ses_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Abadantaa nee a se: «May ka adamize noo mee? May ka benbaw wala lutu, boro kaŋ ga dii wala danaw tee? Manʼti agay no Abadantaa? ");
INSERT INTO ses_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Sohõ koy, agay, ay goo ni miɲoo bande, ay ga hayaa cawandi ma ne kaŋ nʼga hima kʼa har.» ");
INSERT INTO ses_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Musa nee: «Ya ay Koyoo, ay gʼa wiri ni ga, boro tana sanba kaŋ ni baa.» ");
INSERT INTO ses_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Abadantaa futu Musa ga, a nee: «Ni armaa Haruna, Lewi boraa, a nka sii no? Ay ga bay kaŋ nga, a ga waana šenni, nga ne, a goo ma fatta ka ni kubay. Nda a dii ni, binoo ga ɲaali. ");
INSERT INTO ses_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Nʼga šelaŋ a se, ma šenney daŋ miɲoo ra. Agay, ay goo ni miɲoo nda nga miɲoo bande. Ay ga hayaa cawandi war se kaŋ war ga hima kʼa tee. ");
INSERT INTO ses_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","A ga šelaŋ jamaa se ni dogoo ra, nga, a ga tee ni miɲoo, ni, nʼga tee a se irkoy. ");
INSERT INTO ses_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ma goboo woo dii ni kaboo ra, nga nda nʼga tammaasa kayfantey tee.» ");
INSERT INTO ses_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Musa yee nga nzuraa Žetro do ka nee a se: «Suuri naŋ ya koy, ya yee agʼarmey do Misira gandaa ra hala ya dii wala i ga huna.» Žetro nee Musa se: «Ma koy nda baani.» ");
INSERT INTO ses_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Abadantaa nee Musa se Majaŋ gandaa ra: «Koy, ma yee Misira, zama arey kul buu kaŋ ceeci ngi ma ni hundoo kaa.» ");
INSERT INTO ses_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Musa na nga wandoo nda nga izʼarey zaa, a nʼi žigandi farkayaŋ boŋ, a yee Misira gandaa ra. Musa na Irkoy goboo dii nga kaboo ra. ");
INSERT INTO ses_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Abadantaa nee Musa se koyne: «Waatoo kaŋ nʼna fondaa zaa ka willi Misira, gaabandi kayfey kul kaŋ ay nʼi daŋ ni kaboo ra, mʼi tee Firawuuna jine. Agay, ay ga binoo šendandi, a si jamaa naŋ i ma koy. ");
INSERT INTO ses_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Nee Firawuuna se: ‹Hayaa ne kaŋ Abadantaa nʼa har, a nee: “Izirayel manʼti kala ay izʼaroo, ay ize jinaa. ");
INSERT INTO ses_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Ay nee ma ne: ‘Ay izʼaroo naŋ hala a ma koy sargari kaa ya ne. Nda ni wanji kʼa naŋ a ma koy, nga ne, ay ga ni izʼaroo wii, ni ize jinaa.’”›» ");
INSERT INTO ses_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Fondaa ra, nongoo kaŋ ra i na cijinoo tee, Abadantaa kaa Musa ga, a ceeci nga mʼa wii. ");
INSERT INTO ses_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","No din no Sefora na tondi mee kaana foo zaa ka nga izʼaroo daŋbangu, ka kuuru futaa ka tuku Musa cewey ga. A nee: «Nda cimi, ni manʼti kala ya ne kuri kurɲe.» ");
INSERT INTO ses_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Abadantaa nʼa naŋ. A mana nee a se «kuri kurɲe» kala daŋbanguyanoo maaganda se. ");
INSERT INTO ses_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Abadantaa nee Haruna se: «Koy Musa kubay saajoo ra.» A koy, a na Musa kubay Irkoy tondi hondoo do, a nʼa naagu nga gandey ra. ");
INSERT INTO ses_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Musa na Abadantaa šenney kul har Haruna se kaŋ a na nga sanba nga mʼi har nda tammaasawey kul kaŋ a nʼi noo nga se nga mʼi tee. ");
INSERT INTO ses_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Musa nda Haruna koy, i na Izirayel boro beerey kul marga. ");
INSERT INTO ses_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Haruna na šenney kul har kaŋ Abadantaa nʼi har Musa se, a na tammaasawey tee jamaa jine. ");
INSERT INTO ses_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Jamaa naanay. Waatoo kaŋ i maa kaŋ Abadantaa ɲeli Izirayel borey ga, a dii ngi torraa, i gunguma ka sujudu. ");
INSERT INTO ses_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Hayey wey banda ga, Musa nda Haruna huru Firawuuna do, i nee a se: «Hayaa ne kaŋ Abadantaa, Izirayel Koyoo nʼa har, a nee: ‹Ay jamaa naŋ i ma koy, hala i ma jingar tee ay maaɲoo ga saajoo ra.›» ");
INSERT INTO ses_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Firawuuna nee: «Abadantaa ti may kaŋ se ay ga haŋajer ka yadda ka Izirayel naŋ a ma koy? Ay si Abadantaa bay, ay si Izirayel naŋ a ma koy mo.» ");
INSERT INTO ses_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Musa nda Haruna nee: «Eberewey Koyoo bangay ir se, ir gʼa wiri ni ga, mʼir naŋ ir ma jirbi hinza diray tee ka koy saajoo ra ka sargari kaa Abadantaa, ir Koyoo maaɲoo ga, hala a masi koy sorfa kʼir kar wala a ma takuba kʼir kar.» ");
INSERT INTO ses_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Misira kokoyoo nee i se: «Musa nda Haruna, cin se war ga baa war ma jamaa kaa nga goyoo ra? Wa koy war waazibi goyey ra.» ");
INSERT INTO ses_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Firawuuna nee koyne: «Sohõ kaŋ gandaa jamaa boobo, nga no war ga nee i ma ngi waazibi goyey naŋ.» ");
INSERT INTO ses_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Hanoo din hunday, Firawuuna šendandi waazibi goyey juwalkey nda jamaa goy juwalkey ga ka nee: ");
INSERT INTO ses_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«War masi yee ka jamaa noo subu i ma feraw kar sanda takaa kaŋ war cindi kʼa tee, ngi hunday ma koy subu kuuna ngi boŋ se! ");
INSERT INTO ses_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Wa daŋ kaŋ i ma feraw kar sanda hinnaa kaŋ i cindi kʼa tee. War masi haya kul kaa hinnaa ra! Zama fuyyanteyaŋ no, woo se i ga kaati ka nee: ‹Ir ma koy, ir ma sargari kaa ir Koyoo se!› ");
INSERT INTO ses_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Goyoo woo ma tee arey se jeraw, i masi duu ngi boŋ, i masi haŋajer taari šenney se.» ");
INSERT INTO ses_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Jamaa waazibi goyey juwalkey nda nga goy juwalkey fatta ka šelaŋ jamaa se ka nee: «Firawuuna nee: ‹Ay si war noo subu koyne, ");
INSERT INTO ses_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","wa koy war hunday, war ma subu ceeci nongu kaŋ ra war ga duu. Haya kul si hun war goyoo ra.›» ");
INSERT INTO ses_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Jamaa say Misira gandaa kul ra ka subu hamni kuuna. ");
INSERT INTO ses_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Waazibi goyey juwalkey gʼi šiita ka nee: «Wa war goyoo tee ka timme, woo kaŋ kayandi zaari kul war mʼa tee, wa tee sanda waatoo kaŋ subu goo no takaa.» ");
INSERT INTO ses_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","I na Izirayel borey goy juwalkey kar kaŋ Firawuuna waazibi goyey juwalkey nʼi daŋ jamaa jine. I nee goy juwalkey se: «Cin se war mana war goyoo timmandi ka feraw kar bi nda hõ sanda cee jinaa takaa?» ");
INSERT INTO ses_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Izirayel borey goy juwalkey huru Firawuuna do ka hẽe a ga ka nee a se: «Macin se nʼga woo daŋ ni tamey ga? ");
INSERT INTO ses_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","I si ni tamey noo subu koyne, de i ga nee i se: ‹Wa feraw kar!› Nga ne, i ga ni tamey kar. Ni jamaa tooɲe.» ");
INSERT INTO ses_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","A nee: «War manʼti kala fuyyanteyaŋ, fuyyanteyaŋ! Woo se war ga nee: ‹Ir ma koy sargari kaa Abadantaa maaɲoo ga.› ");
INSERT INTO ses_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Sohõ wa koy goy, i si war noo subu, amma war ga feraw hinna follokaa kar.» ");
INSERT INTO ses_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Izirayel borey goy juwalkey dii kaŋ ngi takaa laala, zama i nee: «War masi kumandi ferawey hinnaa ra kaŋ war ga hima kʼa kar zaari foo kul.» ");
INSERT INTO ses_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Waatoo kaŋ i fatta Firawuuna do, i koy Musa nda Haruna kubay kaŋ gʼi batu. ");
INSERT INTO ses_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","I nee i se: «Abadantaa ma war guna, a ma war ciiti. Zama war nʼir gaakurey hottandi Firawuuna nda nga borey do. War nkʼi noo takuba i mʼir wii.» ");
INSERT INTO ses_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Musa yee Abadantaa do, a nee: «Ay Koyoo, macin se nʼna jamaa woo torro? Macin se nʼnʼay sanba? ");
INSERT INTO ses_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Za ay huru Firawuuna do ka šelaŋ a se ni maaɲoo ga, a na jamaa torro, de mana ni jamaa hallasi.» ");
INSERT INTO ses_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Abadantaa nee Musa se: «Sohõ nʼga kaa ka dii hayaa kaŋ ay gʼa tee Firawuuna se, kabe gaabante gʼa gaabi a ma Izirayel borey naŋ i ma koy, kabe gaabante gʼa gaabi a mʼi gaaray kʼi fattandi nga gandaa ra.» ");
INSERT INTO ses_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Irkoy šelaŋ Musa se, a nee a se: «Agay ti Abadantaa. ");
INSERT INTO ses_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Ay bangay sanda Irkoy, Hini-kul-koyoo Ibirahima, nda Isiyaka, nda Yakuba se, amma ya nʼay boŋ bayrandi i se sanda Abadantaa. ");
INSERT INTO ses_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ay na agay amaanaa mo kaŋ goo ir game gorandi kaŋ i ga duu Kanaŋ gandaa, gandaa kaŋ ra i koy goro ka tee yaw. ");
INSERT INTO ses_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ay maa mo Izirayel borey kaŋ Misira borey nʼi tee tam hẽenoo. Ay hongu agay amaanaa. ");
INSERT INTO ses_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Woo maaganda se nee Izirayel borey se: ‹Agay ti Abadantaa, ay ga Misira waazibi goyey zaa war boŋ. Ay ga war kaa ngi tamtaraa ra. Ay ga war feeri nda ay hinoo nda ciiti beeriyaŋ. ");
INSERT INTO ses_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ay ga war dii ay jamaa, ay ga tee war Koyoo. War ga kaa ka bay kaŋ agay ti Abadantaa, war Koyoo kaŋ ga war feeri ka Misira waazibi goyey zaa war boŋ. ");
INSERT INTO ses_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ay ga war daŋ gandaa ra kaŋ ay nʼay kaboo jer ka žee kʼa noo Ibirahima, nda Isiyaka, nda Yakuba se, ay gʼa tee war mayray. Agay ti Abadantaa.›» ");
INSERT INTO ses_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Musa na taka follokaa ka šelaŋ Izirayel borey se, amma i mana haŋajer a se takaa kaŋ nda biney hun nda goy šendaa maaganda se. ");
INSERT INTO ses_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«Huru, ma šelaŋ Firawuuna, Misira kokoyoo se hala a ma Izirayel borey naŋ i ma fatta nga gandaa ra.» ");
INSERT INTO ses_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Musa šelaŋ Abadantaa jine ka nee: «Nga ne, Izirayel borey mana haŋajer ya ne, taka foo nda Firawuuna ga haŋajer ya ne? Šenni si faala ay ga.» ");
INSERT INTO ses_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Abadantaa šelaŋ Musa nda Haruna se, a nʼi noo yaamaryaŋ Izirayel borey nda Firawuuna, Misira kokoyoo se, hala a ma Izirayel borey naŋ i ma fatta Misira gandaa ra. ");
INSERT INTO ses_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Izirayel borey hugu boŋey maayaŋ ne: Rubeŋ ti Izirayel ize jinaa, nga izʼarey maaɲey ti: Hanok, nda Palu, nda Hesroŋ, nda Karmi. Wey ti Rubeŋ alaayan beerey kaagey. ");
INSERT INTO ses_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simewoŋ izʼarey ti: Yemuwel, nda Yamin, nda Ohad, nda Yakin, nda Sohar, nda Sawul kaŋ ti Kanaŋ gandaa woyoo izʼaroo. Wey ti Simewoŋ alaayan beerey kaagey. ");
INSERT INTO ses_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Lewi izʼarey maaɲey, alwadda ka kaa alwadda ti: Geršoŋ, nda Kehat, nda Merari. Lewi duu jiiri zangu nda waranza cindi iyye (137) aloomur. ");
INSERT INTO ses_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Geršoŋ izʼarey ti: Libni nda Šimeyi, ka sawa nda ngi alaayan beerey kaagey. ");
INSERT INTO ses_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kehat izʼarey ti: Amram, nda Yisehar, nda Hebroŋ, nda Uziyel. Kehat duu jiiri zangu nda waranza cindi hinza (133) aloomur. ");
INSERT INTO ses_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari izʼarey ti: Mahili nda Muši. Wey ti Lewi alaayan beerey kaagey, alwadda ka kaa alwadda. ");
INSERT INTO ses_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram hiija nga hawaa Žokebed, a duu a se Haruna nda Musa. Amram duu jiiri zangu nda waranza cindi iyye (137) aloomur. ");
INSERT INTO ses_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Izahar izʼarey ti: Kora, nda Nefeg, nda Zikri. ");
INSERT INTO ses_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uziyel izʼarey ti: Mišel, nda Elisafaŋ, nda Sitri. ");
INSERT INTO ses_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Haruna hiija Elišeba, Aminadab ize woyoo, Nahišoŋ woymaa no. A duu a se Nadab, nda Abihu, nda Eleyazar, nda Itamar. ");
INSERT INTO ses_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kora izʼarey ti: Asir, nda Elkana, nda Abiyasaf. Wey ti Kora alaayan beerey kaagey. ");
INSERT INTO ses_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleyazar, Haruna izʼaroo hiija Putiyel ize woy foo. A duu a se Pinehas. Wey ti Lewi hugey borey hugu boŋey ka sawa nda ngi alaayan beerey kaagey. ");
INSERT INTO ses_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Haruna follokaa nda Musa follokaa se Abadantaa šelaŋ ka nee: «Wa Izirayel borey fattandi Misira gandaa ra hugu nda hugu.» ");
INSERT INTO ses_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Musa nda Haruna ti borey kaŋ šelaŋ Firawuuna, Misira kokoyoo se, hala i ma Izirayel borey fattandi Misira. ");
INSERT INTO ses_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Hanoo kaŋ Abadantaa šelaŋ Musa se Misira gandaa ra, ");
INSERT INTO ses_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Abadantaa nee Musa se: «Agay ti Abadantaa, hayey kul kaŋ ay nʼi har ma ne har Firawuuna, Misira kokoyoo se.» ");
INSERT INTO ses_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Musa nee Abadantaa se: «Nga ne, šenni si faala ay ga, taka foo nda Firawuuna ga haŋajer ya ne?» ");
INSERT INTO ses_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Abadantaa nee Musa se: «Guna, ay na ni tee irkoy Firawuuna se, Haruna ni armaa ga tee ni annaboo. ");
INSERT INTO ses_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ni no ma hayey kul har kaŋ nda ay ga ni yaamar, ni armaa Haruna ga šelaŋ Firawuuna se hala a ma Izirayel borey naŋ i ma koy ka fatta nga gandaa ra. ");
INSERT INTO ses_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Agay, ay ga Firawuuna binoo šendandi, ay gʼay tammaasawey nda ay kayfey boobandi Misira gandaa ra. ");
INSERT INTO ses_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Firawuuna si haŋajer war se, ay gʼay kaboo šerre Misira ga, ay gʼay wongu-izey, ay jamaa, Izirayel borey fattandi Misira gandaa ra nda ciiti beeriyaŋ. ");
INSERT INTO ses_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Misira borey ga kaa ka bay kaŋ agay ti Abadantaa waati kaŋ ay nʼay hinoo cebe Misira ga, de ay na Izirayel borey fattandi i game.» ");
INSERT INTO ses_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Musa nda Haruna na takaa tee kaŋ nda Abadantaa nʼi yaamar, i na takaa din da tee. ");
INSERT INTO ses_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Musa sii nda kala jiiri woyyaaha (80), Haruna goo nda jiiri woyyaaha cindi hinza (83) waatoo kaŋ i ga šelaŋ Firawuuna se. ");
INSERT INTO ses_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Abadantaa nee Musa nda Haruna se: ");
INSERT INTO ses_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«Nda Firawuuna šelaŋ war se ka nee: ‹Wa kayfi tee ir ma dii›, ma nee Haruna se: ‹Ni goboo zaa mʼa warra Firawuuna jine.› Goboo ga bere ka tee gandakarfu.» ");
INSERT INTO ses_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Musa nda Haruna huru Firawuuna do, i na takaa din da tee, takaa kaŋ nda Abadantaa nʼi yaamar. Haruna na nga goboo warra Firawuuna nda nga borey jine, goboo bere ka tee gandakarfu. ");
INSERT INTO ses_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Firawuuna mo na nga bayraykoyney nda cerkawey cee, de ngi mo, Misira gandaa gunandikey na ngi kottewey ka takaa din da tee. ");
INSERT INTO ses_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Affoo kul na nga goboo warra, i bere ka tee gandakarfu. Haruna goboo na ngi gobey gon. ");
INSERT INTO ses_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Amma Firawuuna binoo šendi, a mana haŋajer i se sanda takaa kaŋ nda Abadantaa nʼa har. ");
INSERT INTO ses_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Abadantaa nee Musa se: «Firawuuna binoo šendi, a wanji ka jamaa naŋ i ma koy. ");
INSERT INTO ses_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Koy suba subbaahi Firawuuna do, nga ne, a ga fatta ka koy haroo ga, mʼa kubay isaa miɲoo ga, ma goboo dii ni kaboo ra kaŋ bere ka tee gondi. ");
INSERT INTO ses_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ma nee a se: ‹Abadantaa, Eberewey Koyoo kʼay sanba ni do, a nee: “Ay jamaa naŋ i ma koy hala i ma sargari kaa ya ne saajoo ra.” Nga ne, hala sohõ mana haŋajer. ");
INSERT INTO ses_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Hayaa ne kaŋ Abadantaa nʼa har, a nee: “Woo ra nʼga kaa ka bay kaŋ agay ti Abadantaa: nga ne, ay ga isaa haroo kar nda goboo kaŋ goo ay kaboo ra, de haroo ga bere ka tee kuri. ");
INSERT INTO ses_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Hamiisawey kaŋ goo isaa ra ga buu, de isaa ga funbu. Misira borey si yee ka hin ka isaa haroo haŋ.”›» ");
INSERT INTO ses_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Abadantaa nee Musa se: «Nee Haruna se: ‹Ni goboo zaa kʼa šerre Misira harey ga, isawey ga, nda isa kabey ga, nda hari kaydogey ga, nda hari margadogey ga. I ga bere ka tee kuri, Misira gandaa kul ga tee kuri, ba haroo kaŋ goo bundu tuwey nda tondi tuwey ra ga bere ka tee kuri.›» ");
INSERT INTO ses_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Musa nda Haruna na takaa din da tee, takaa kaŋ nda Abadantaa nʼa yaamar. A na nga goboo jer ka isaa harey kar, Firawuuna jine nda nga borey jine. Isa harey kul bere ka tee kuri. ");
INSERT INTO ses_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Hamiisa kaŋ goo isaa ra buu. Isaa funbu, Misira borey si hin ka isaa haroo haŋ. Misira gandaa kul tee kuri. ");
INSERT INTO ses_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Amma Misira kottekoyney na ngi kottewey ka taka follokaa tee. Firawuuna binoo šendi, a mana haŋajer i se, sanda takaa kaŋ nda Abadantaa nʼa har. ");
INSERT INTO ses_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Firawuuna na banda bere ka huru nga hugoo ra, a mana tee a se baffoo. ");
INSERT INTO ses_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Misira borey kul koy fanša isaa miɲey bande hala ngi ma duu hari ka haŋ, zama i si hin ka isaa haroo haŋ. ");
INSERT INTO ses_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Abadantaa isaa karyanoo banda ga, jirbi iyyaa timme. ");
INSERT INTO ses_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","Abadantaa nee Musa se: «Huru Firawuuna do, nee a se: ‹Hayaa ne kaŋ Abadantaa nʼa har, Abadantaa nee: “Ay jamaa naŋ i ma koy hala i ma sargari kaa ya ne. ");
INSERT INTO ses_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","Nda ni wanji kʼi naŋ i ma koy, nga ne, agay, ay ga ni gandaa kul kar nda nbala. ");
INSERT INTO ses_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","Isaa ga too nda nbala, i ga žigi ka huru ni windoo ra, nda ni hugoo kaŋ ra nʼga kani, ni daaroo boŋ, nda ni borey hugey ra, nda ni jamaa kul game. I ga huru ni alforoney nda ni laajin diibidogey ra. ");
INSERT INTO ses_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","Nbalawey ga žigi ka koy ni, nda ni jamaa, nda ni borey ga.”›» ");
INSERT INTO ses_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Abadantaa nee Musa se: «Nee Haruna se: ‹Ni kaboo nda ni goboo kaŋ goo a ra šerre isawey, nda isaa kabey, nda hari kaydogey ga, de ma nbalawey žigandi Misira gandaa ga.›» ");
INSERT INTO ses_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Haruna na nga kaboo šerre Misira harey ga, nbalawey žigi ka koy ka Misira gandaa daabu. ");
INSERT INTO ses_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Kottekoyney na ngi kottewey ka taka follokaa tee, i na nbalawey žigandi Misira gandaa ga. ");
INSERT INTO ses_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Firawuuna na Musa nda Haruna cee, a nee: «Wa Abadantaa ŋaaray a ma nbalawey moorandi agay nda ay jamaa ga, de ay ga jamaa naŋ i ma koy, i ma sargari kaa Abadantaa maaɲoo ga.» ");
INSERT INTO ses_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Musa nee Firawuuna se: «Ay ga beeray daŋ ni ga ka ni noo ma waatoo har kaŋ ra nʼga baa ya Irkoy ŋaaray ni, nda ni borey, nda ni jamaa se, hala nbalawey ma mooru ni, nda ni hugey, taka kaŋ ra i ma cindi isaa hinne ra.» ");
INSERT INTO ses_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","A nee: «Suba.» Musa nee: «Woo kaŋ nʼnʼa har ga tee hala ma bay kaŋ Abadantaa, ir Koyoo cine sii. ");
INSERT INTO ses_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Nbalawey ga mooru ni, nda ni hugey, nda ni borey, nda ni jamaa ga, i si cindi kala isaa hinne ra.» ");
INSERT INTO ses_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Musa nda Haruna fatta Firawuuna do. Musa kaati ka Abadantaa ŋaaray nbalawey kaŋ a kate ey Firawuuna ga maaganda se. ");
INSERT INTO ses_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Abadantaa na hayaa tee kaŋ Musa nʼa wiri a ga. Nbalawey buu hugey, nda batumawey, nda faarey ra. ");
INSERT INTO ses_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","I nʼi marga zuku nda zuku, gandaa funbu. ");
INSERT INTO ses_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Firawuuna dii kaŋ takaa hanse, a na nga binoo šendandi, a mana haŋajer i se sanda takaa kaŋ nda Abadantaa nʼa har. ");
INSERT INTO ses_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Abadantaa nee Musa se: «Šelaŋ Haruna se ka nee: ‹Ni goboo šerre, ma laboo kar, a ga bere ka tee ndeŋ Misira gandaa kul ra.›» ");
INSERT INTO ses_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","I na takaa din da tee. Haruna na nga kaboo kaŋ ra nga goboo goo šerre, a na laboo kar, a tee ndeŋ adamizey nda adabbawey ga. Laboo kusaa kul bere ka tee ndeŋ Misira gandaa kul ra. ");
INSERT INTO ses_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Kottekoyney ceeci ka taka follokaa tee nda ngi kottewey, ka ndeŋyaŋ tee, amma i mongu. Ndeŋey goo adamizey nda adabbawey ga. ");
INSERT INTO ses_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Kottekoyney nee Firawuuna se: «Irkoy kaboo no.» Amma Firawuuna binoo šendi, a mana haŋajer i se sanda takaa kaŋ nda Abadantaa nʼa har. ");
INSERT INTO ses_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Abadantaa nee Musa se: «Tun subbaahi biya, ma koy kay Firawuuna jine, nga ne, waati kaŋ a fatta ka koy haroo ga, ma nee a se: ‹Hayaa ne kaŋ Abadantaa nʼa har, Abadantaa nee: “Ay jamaa naŋ i ma koy hala i mʼay gana. ");
INSERT INTO ses_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Nda manʼay jamaa naŋ i ma koy, nga ne, ay ga hamniyaŋ kaŋ ga ɲama sanba ni, nda ni borey, nda ni jamaa, nda ni hugey ga. Misira borey hugey ga too nda hamney, i ga ba laboo too kaŋ ga i goo. ");
INSERT INTO ses_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Amma hanoo din, ay ga fayyan daŋ ngi nda Gošeŋ gandaa game kaŋ ra ay jamaa goo, taka kaŋ ra no din hamni kul sii a ra, hala ma bay kaŋ agay, Abadantaa, ay goo gandaa ra. ");
INSERT INTO ses_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ay ga fayyan daŋ ay jamaa nda ni jamaa game kʼay jamaa kaa kabe ra. Suba tammaasaa woo ga teendi.”›» ");
INSERT INTO ses_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Abadantaa nʼa tee nda takaa din da: hamney kaŋ ga ɲama kur kaa Firawuuna hugoo, nda nga borey hugey, nda Misira gandaa kul ra. Hamney kaŋ ga ɲama na gandaa hasara. ");
INSERT INTO ses_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Firawuuna ciya Musa nda Haruna se, a nee: «Wa koy sargari kaa war Koyoo se gandaa ra.» ");
INSERT INTO ses_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Musa nee: «A si hima ir ma woo tee, zama sargaroo kaŋ ir gʼa kaa Abadantaa, ir Koyoo maaɲoo ga manʼti kala almuhal Misira borey se. Nga ne, nda ir ga haya kaa sargari kaŋ ti almuhal Misira borey se, i sʼir warra nda tondi kʼir wii wala? ");
INSERT INTO ses_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Jirbi hinza diray no ir gʼa tee ka koy saajoo ra ka sargari kaa Abadantaa, ir Koyoo maaɲoo ga sanda takaa kaŋ nda a gʼa har ir se.» ");
INSERT INTO ses_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Firawuuna nee: «Ay ga war naŋ war ma koy sargari kaa Abadantaa, war Koyoo maaɲoo ga saajoo ra. Amma war masi hanse ka mooru, war ma Irkoy ŋaaray ya ne.» ");
INSERT INTO ses_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Musa nee: «Za ay fatta ni do, ay ga Abadantaa ŋaaray ma ne, za suba hamney kaŋ ga ɲama ga mooru Firawuuna, nda nga borey, nda nga jamaa. Amma Firawuuna ma fay nda ka ɲooɲo ka wanji ka jamaa naŋ i ma koy sargari kaa Abadantaa maaɲoo ga.» ");
INSERT INTO ses_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Musa fatta Firawuuna do, a na Abadantaa ŋaaray. ");
INSERT INTO ses_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Abadantaa na hayaa tee kaŋ Musa nʼa wiri a ga. A na hamney kaŋ ga ɲama moorandi Firawuuna nda nga borey, nda nga jamaa. Ba affoo mana cindi. ");
INSERT INTO ses_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Amma Firawuuna na nga binoo šendandi hiino mo, a mana jamaa naŋ i ma koy. ");
INSERT INTO ses_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Abadantaa nee Musa se: «Huru Firawuuna do, nee a se: ‹Hayaa ne kaŋ Abadantaa, Eberewey Koyoo nʼa har, a nee: “Ay jamaa naŋ i ma koy hala i mʼay gana. ");
INSERT INTO ses_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Nda ni wanji kʼi naŋ i ma koy, nda nʼgʼi dii hala sohõ, ");
INSERT INTO ses_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","nga ne, Abadantaa kaboo ga too ni almaney do kaŋ goo saajoo ra, sorfa beeri ga ni baryey, nda ni farkey, nda ni yoowey, nda ni hawey, nda ni feejey, nda ni hanciney kar. ");
INSERT INTO ses_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Abadantaa ga fayyan daŋ Izirayel almaney nda Misira waney game, taka kaŋ ra haya kul kaŋ ti Izirayel borey wane, ba affoo si buu.”›» ");
INSERT INTO ses_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Abadantaa na waati kayandi ka nee: «Suba Abadantaa gʼa tee gandaa ra.» ");
INSERT INTO ses_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Abadantaa nʼa tee suba ra sanda takaa kaŋ nda a nʼa har, Misira almaney kul buu, amma Izirayel borey jawdoo adabba ba affoo mana buu i ra. ");
INSERT INTO ses_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Firawuuna daŋ ka alhabar ceeci, a gar kaŋ ba alman foo mana buu Izirayel jawdoo ra. Woo kul, a na bine šenday, a mana jamaa naŋ i ma koy. ");
INSERT INTO ses_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Abadantaa nee Musa nda Haruna se: «Wa war kabey too nda boosu hinadogoo ra, Musa mʼa warra beenaa here Firawuuna jine. ");
INSERT INTO ses_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","A ga tee kusaw Misira gandaa kul ra. Misira gandaa kul ra a ga futtayaŋ kaŋ ga dori fattandi adamizey nda almaney ga.» ");
INSERT INTO ses_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","I na hinadogoo boosoo zaa ka kay Firawuuna jine. Musa nʼa warra beenaa here. A tee futtayaŋ kaŋ ga dori fattandi adamizey nda almaney ga. ");
INSERT INTO ses_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Kottekoyney mana hin ka kay Musa jine futtawey maaganda, zama futtawey goo kottekoyney nda Misira borey kul ga. ");
INSERT INTO ses_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Abadantaa na Firawuuna binoo šendandi, a mana haŋajer i se. A teendi nda takaa kaŋ nda Abadantaa nʼa har Musa se. ");
INSERT INTO ses_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Abadantaa nee Musa se: «Tun subbaahi biya, ma koy Firawuuna jine, ma nee a se: ‹Hayaa ne kaŋ Abadantaa, Eberewey Koyoo nʼa har, a nee: “Ay jamaa naŋ i ma koy hala i mʼay gana. ");
INSERT INTO ses_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Hiino ay gʼay albalaawey kul sanba ni, nda ni borey, nda ni jamaa ga hala ma bay kaŋ ay cine sii laboo kul ga. ");
INSERT INTO ses_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Nda a gar ya nkʼay kaboo šerre ka ni kar nda sorfa, ni nda ni jamaa, nʼga dere laboo ga. ");
INSERT INTO ses_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Nda ay na ni naŋ ma bara hala sohõ, addaliloo manʼti kala hala ya ni cebe ay gaaboo, ay maaɲoo ma harandi laboo kul ga. ");
INSERT INTO ses_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Nʼnʼay jamaa ganji, ni wanji i ma koy. ");
INSERT INTO ses_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Nga ne, suba dimmaa woo da cine ga, ay ga gari laalayaŋ doori kaŋ cine mana bay ka tee Misira gandaa ra za a gorandi hala hõ.” ");
INSERT INTO ses_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Sohõ, sanba ka daŋ i ma ni almaney nda haya kul kaŋ ti ni wane kaŋ goo saajoo ra lanbandi. Adamize kul nda adabba kul kaŋ goo saajoo ra kaŋ mana kaa hugey, garoo ga kaŋ i boŋ, i ga buu.›» ");
INSERT INTO ses_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Firawuuna borey ra, wey kaŋ hunbur Abadantaa šennoo na ngi tamey nda ngi adabbawey lanbandi ka huru hugey ra. ");
INSERT INTO ses_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Borey kaŋ mana Abadantaa šennoo daŋ assal na ngi tamey nda ngi adabbawey naŋ saajoo ra. ");
INSERT INTO ses_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Abadantaa nee Musa se: «Ni kaboo jer beenaa here hala Misira gandaa kul ra gari ma kaŋ adamizey, nda adabbawey, nda suboo kul ga kaŋ goo Misira.» ");
INSERT INTO ses_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Musa na nga goboo šerre beenaa here, Abadantaa na jiŋjiŋyaŋ nda gari sanba, nuune zunbu laboo ga. Abadantaa na gari sanba Misira gandaa ra. ");
INSERT INTO ses_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Gari doo kaŋ nuune goo a bande kaŋ laalayanoo cine mana bay ka tee Misira gandaa kul ra za a tee ganda. ");
INSERT INTO ses_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Misira gandaa kul ra, haya kul kaŋ goo saajoo ra, garoo nʼi kar, za adamize hala adabba. Garoo na faarey subey kul kar, a na faarey tuurey kul kayri. ");
INSERT INTO ses_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Gošeŋ gandaa hinne kaŋ ra Izirayel borey goo ra, garoo mana kaŋ a boŋ. ");
INSERT INTO ses_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Firawuuna daŋ i ma ciya Musa nda Haruna se, a nee i se: «Hiino ay na zunubu tee, Abadantaa ga cum, agay nda ay jamaa ka tooɲe. ");
INSERT INTO ses_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Wa Abadantaa ŋaaray ya ne hala jiŋjiŋyan beerey nda garey ma kay, ay ga war naŋ war ma koy, war si cindi ne koyne.» ");
INSERT INTO ses_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musa nee a se: «Waati kaŋ ay fatta koyraa ra, ay gʼay kabey jer Abadantaa here, jiŋjiŋyaney ga ben, garey si yee ka kaŋ hala ma bay kaŋ laboo manʼti kala Abadantaa wane. ");
INSERT INTO ses_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Amma ay ga bay kaŋ ni nda ni borey, war si hunbur Abadantaa, ir Koyoo hala sohõ.» ");
INSERT INTO ses_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Leŋoo nda oržoo hasara, zama oržoo goo jeenoo ga, leŋoo boosu. ");
INSERT INTO ses_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Amma alkamaa nda taasu dumi foo kaŋ ga hima nda alkama mana hasara, zama i mana zay jina. ");
INSERT INTO ses_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Musa fatta Firawuuna do, a fatta koyraa ra, a na nga kabey jer Abadantaa here, jiŋjiŋyaney nda garey kay. Ncirɲoo mana yee ka doo laboo ga. ");
INSERT INTO ses_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Waatoo kaŋ Firawuuna dii kaŋ ncirɲoo, nda jiŋjiŋyaney, nda garey kay, a na zunubu tee koyne, a na nga binoo šendandi, nga nda nga borey. ");
INSERT INTO ses_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Firawuuna binoo šendi. A mana Izirayel borey naŋ i ma koy. A teendi nda takaa kaŋ nda Abadantaa nee Musa mʼa har. ");
INSERT INTO ses_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Abadantaa nee Musa se: «Huru Firawuuna do, zama agay ka nga nda nga borey biney šendandi hala ya duu kʼay tammaasawey wey daŋ i jine, ");
INSERT INTO ses_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","hala ma duu ka deede ni izey nda ni izey izey se takaa kaŋ nda ay na Misira borey bere-bere nda takaa kaŋ nda ay nʼay tammaasawey daŋ i jine. Nga ra war ga bay kaŋ agay ti Abadantaa.» ");
INSERT INTO ses_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Musa nda Haruna huru Firawuuna do, i nee a se: «Hayaa ne kaŋ Abadantaa, Eberewey Koyoo nʼa har, a nee: ‹Hala waati foo no nʼga ni boŋ yeeti ya ne ganda? Ay jamaa naŋ i ma koy hala i mʼay gana. ");
INSERT INTO ses_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Nda ni wanji kʼay jamaa naŋ i ma koy, nga ne, suba ay ga ndooyaŋ sanba ni laamaa ga. ");
INSERT INTO ses_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","I ga gandaa laboo kul daabu hala nongu kaŋ ra boro si yee ka dii a. Haya kaŋ garoo nʼa naŋ, woo kaŋ cindi war se kaŋ a mana duu a, i gʼa ŋaa. Tuuri kul kaŋ goo ma zay war se saajoo ra, i gʼi ŋaa. ");
INSERT INTO ses_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","I ga ni hugey too, i ga ni borey hugey too, i ga Misira borey kul hugey too. Ni baabey nda ni baabey kaagey mana bay ka dii woo cine za hanoo kaŋ i kaa laboo ga hala hõ.›» Musa na nga boŋ kuubi ka fatta Firawuuna do. ");
INSERT INTO ses_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Firawuuna borey nee a se: «Hala waati foo no boraa woo gʼir torro ka ben? Arey wey naŋ i ma koy hala i ma Abadantaa, ngi Koyoo gana. Hala sohõ mana bay kaŋ Misira goo ma halaci wala?» ");
INSERT INTO ses_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","I kate Musa nda Haruna Firawuuna do, a nee i se: «Wa koy Abadantaa, war Koyoo gana. May nda may no ma koy?» ");
INSERT INTO ses_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musa nee: «Ir ga koy, ir nda soogey nda boro žeeney, ir ga koy nda ir izʼarey nda ir ize woyey, ir ga koy nda ir alman buuney nda ibeerey, zama jingar ti woo ir se Abadantaa maaɲoo ga.» ");
INSERT INTO ses_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Firawuuna nee i se: «Nda ay na war naŋ war ma koy, war nda war zankey, Abadantaa ma bara war bande! War ma bay kaŋ ifutu no war gʼa miile. ");
INSERT INTO ses_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","A si tee nda takaa woo. Adiši war kaŋ ti arey, wa koy Abadantaa gana, zama woo din no war gʼa ceeci.» Woo ga, i nʼi gaaray ka hun Firawuuna do. ");
INSERT INTO ses_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Abadantaa nee Musa se: «Ni kaboo šerre Misira gandaa ga ka ciya ndoowey se. I ma zunbu ka koy Misira gandaa ga, i ma gandaa suboo kul ŋaa, woo kul kaŋ garoo nʼa naŋ.» ");
INSERT INTO ses_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Musa na nga goboo šerre Misira gandaa ga, Abadantaa na dandi hew tunandi kaŋ na gandaa kul dii zaaroo kul nda cijinoo kul. Subbaahoo ra, dandi hewoo kate ndoowey. ");
INSERT INTO ses_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Ndoowey kaa Misira gandaa kul ga, i zunbu laboo kul boŋ nda booboyan. Ngi booboyanoo cine mana bay ka tee hala sohõ, a si tee koyne ngi banda ga. ");
INSERT INTO ses_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","I na gandaa kul daabu, gandaa tee kubay. I na gandaa suboo nda tuuri-izey kul ŋaa kaŋ garoo nʼi naŋ. Haya firzi kul mana cindi tuurey ga wala faarey subey ga Misira gandaa kul ra. ");
INSERT INTO ses_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Nda cahãyan Firawuuna na Musa nda Haruna cee ka nee: «Ay na zunubu tee Abadantaa, war Koyoo se, ay duu war ga zunubu. ");
INSERT INTO ses_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ay zunuboo yaafa ya ne hiino koyne. Wa Abadantaa, war Koyoo ŋaaray hala a ma suuri ka buuyanoo woo moorandi ay ga.» ");
INSERT INTO ses_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Musa fatta Firawuuna do, a na Abadantaa ŋaaray. ");
INSERT INTO ses_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Abadantaa na hewoo bere kʼa tee dangay hew beeri kaŋ na ndoowey zaa kʼi warra Kakaarey teekoo ra. Ba affoo mana cindi Misira laamaa kul ga. ");
INSERT INTO ses_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Amma Abadantaa na Firawuuna binoo šendandi, a mana naŋ Izirayel borey ma koy. ");
INSERT INTO ses_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Abadantaa nee Musa se: «Ni kaboo šerre beenaa here, kubay ma kaa Misira gandaa ga, kubay bibi tik.» ");
INSERT INTO ses_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Musa na nga kaboo šerre beenaa here, kubay beeri tee Misira gandaa kul ra jirbi hinza. ");
INSERT INTO ses_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Borey si hin ka dii cere. Jirbi hinza boro kul si hun nga dogoo ra. Amma Izirayel borey kul, nongoo kaŋ ra i goro, gaay goo no. ");
INSERT INTO ses_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Firawuuna na Musa cee ka nee a se: «Wa koy Abadantaa gana. War alman buuna nda ibeerey hinne no ma cindi. War zankey mo ma koy war bande.» ");
INSERT INTO ses_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Musa nee: «Nʼgʼir noo sargari kukuranteyaŋ nda sargari tanayaŋ kaŋ ir gʼi kaa Abadantaa, ir Koyoo maaɲoo ga wala? ");
INSERT INTO ses_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Ir jawdey ga koy ir bande, ba boŋ foo si cindi. Zama ngi ra ir ga zaa ka Abadantaa, ir Koyoo gana. Ir hunday si bay woo kaŋ ir ga hima kʼa kaa Abadantaa maaɲoo ga nda manʼti ir nka too no din.» ");
INSERT INTO ses_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Amma Abadantaa na Firawuuna binoo šendandi, a manʼi naŋ i ma koy. ");
INSERT INTO ses_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Firawuuna nee a se: «Hun ay jine, hawgay, ay masi yee ka dii ni ay jine, han kul kaŋ ay dii ni ay jine, nʼga buu!» ");
INSERT INTO ses_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musa nee: «Ni kʼa har, nʼsi yee ka dii agay ni jine.» ");
INSERT INTO ses_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Abadantaa nee Musa se: «Ay ga balaawu foo sanba koyne Firawuuna nda Misira ga. Woo banda ga, a ga war naŋ war ma hun ne. Waati kaŋ a na war naŋ war ma koy ka ben, a ga ba war gaaray kaaray ka hun ne. ");
INSERT INTO ses_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Aywa, nee jamaa se kaŋ aru kul ma nga taalammaa wiri nzorfu jinayyaŋ nda wura jinayyaŋ, woy kul ma nga taalammaa wiri nzorfu jinayyaŋ nda wura jinayyaŋ.» ");
INSERT INTO ses_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Abadantaa na jamaa noo alhormo Misira borey do. Musa hunday duu beeray beeri Misira gandaa ra Firawuuna borey nda jamaa do. ");
INSERT INTO ses_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Musa nee: «Hayaa ne kaŋ Abadantaa nʼa har, a nee: ‹Cijinoo gamoo ra ay ga fatta ka koy Misira game. ");
INSERT INTO ses_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Gunde jinaa kul ga buu Misira gandaa ra, ka šintin nda Firawuuna kaŋ ga goro kokoytaraa ra gunde jinaa ka koy hala koŋŋa kaŋ goo fufutondoo jine gunde jinaa, nda adabbawey gunde jinawey kul. ");
INSERT INTO ses_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Kaati beeri ga tee Misira gandaa kul ra kaŋ mana bay ka tee, nga cine si tee koyne. ");
INSERT INTO ses_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Amma Izirayel borey kul do, ba hanši si kaati boro wala adabba ga hala war ma bay kaŋ Abadantaa ga fayyan daŋ Misira nda Izirayel game.› ");
INSERT INTO ses_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Waatoo din ni borey kul ga doo kate ay do ka gunguma ya ne ka nee: ‹Fatta, ni nda jamaa kul kaŋ goo ni bande›, woo banda ga, ay ga fatta.» Musa too nda futay, a fatta Firawuuna do. ");
INSERT INTO ses_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Abadantaa nee Musa se: «Firawuuna si haŋajer war se, hala ay kayfey ma boobo Misira gandaa ra.» ");
INSERT INTO ses_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musa nda Haruna na kayfey wey kul tee Firawuuna jine, amma Abadantaa na Firawuuna binoo šendandi, a mana naŋ Izirayel borey ma fatta nga gandaa ra. ");
INSERT INTO ses_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Abadantaa šelaŋ Musa nda Haruna se Misira gandaa ra ka nee: ");
INSERT INTO ses_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«Handoo woo ga tee war se handey ijinaa. A ma tee war se jiiroo handu jinaa. ");
INSERT INTO ses_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Wa šelaŋ Izirayel jamaa kul se ka nee: ‹Handoo woo jirbi woyantoo (10to) ra, war hugu foo kul ma alman foo zaa, hugu foo kul alman foo. ");
INSERT INTO ses_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Nda hugoo ga hanse ka kacca alman foo se, i mʼa zaa, ngi nda ngi taalammaa kaŋ ga hanse ka man ngi hugoo, ka sawa nda boro hinnaa. Almanoo ma zamnandi ka sawa nda woo kaŋ boro kul gʼa ŋaa. ");
INSERT INTO ses_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","A ma tee alman kaŋ ga malal sii, aru kaŋ goo nda jiiri foo. War mʼa zaa feeji-izey wala hancin-izey ra. ");
INSERT INTO ses_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","War mʼa dii hala handoo woo jirbi woy cindi taacantoo (14to) ga. Hanoo din, almaaroo ra Izirayel jamaa margaroo kul mʼa koosu. ");
INSERT INTO ses_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Hugey kaŋ ra i gʼa ŋaa, i ma zaa kuroo ra kʼa daŋ hugoo miɲoo caraw hinkaa nda beeneheroo ga. ");
INSERT INTO ses_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Cijinoo din i ma hamoo ŋaa. I mʼa kukuray nuune ra kʼa ŋaa nda takulayaŋ kaŋ ra dolobiri sii, i mʼa ŋaa nda subu hottayaŋ. ");
INSERT INTO ses_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","War masi haya kul ŋaa a ra kaŋ mana nin wala kaŋ hinandi hari ra. War mmʼa kukuray nuune ra, nga nda nga boŋoo, nda kobsey, nda teeley. ");
INSERT INTO ses_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Haya kul masi kani a ra hala suba. Nda haya kani a ra hala suba, war mʼa ton nuune ra kʼa tee boosu. ");
INSERT INTO ses_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Takaa ne kaŋ nda war gʼa ŋaa: gamahaw ma war centey haw, war taamey ma bara war cewey ra, war gobey ma bara war kabey ra. War mʼa ŋaa nda cahãyan. Woo ti Borcintaraa jingaroo Abadantaa maaɲoo ga.› ");
INSERT INTO ses_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Cijinoo din ra, ay ga Misira gandaa kul dira. Ay ga gunde jinaa kul wii Misira gandaa ra za adamize hala adabba. Ba Misira koyey kul, ay gʼi ciiti. Agay ti Abadantaa. ");
INSERT INTO ses_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Amma kuroo ga tee tammaasa war se hugey ga kaŋ ra war goo. Nda ay dii kuroo, ay ga bisa war ga, de albalaawoo kaŋ ga borey halaci si too war do waati kaŋ ay ga Misira gandaa kar. ");
INSERT INTO ses_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Zaaroo din ma tee war se hongandihaya. War mʼa tee jingar Abadantaa maaɲoo ga. A ma tee hantum kaŋ si tun war alwaddawey se.» ");
INSERT INTO ses_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","«War ma jirbi iyye tee war ga takula ŋaa kaŋ ra dolobiri sii. Za zaari jinaa war ma dolobiri kaa war hugey ra. Zama boro kul kaŋ na haya ŋaa kaŋ ra dolobiri goo zaari jinaa ka koy hala zaari iyyantoo, boraa ga hun Izirayel jamaa ra. ");
INSERT INTO ses_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Zaari jinaa war ga margari henanante tee. Jirbi iyyantoo mo war ga margari henanante tee. Zaarey din goy kul si teendi nda manʼti ŋaayan hinayan hala borey kul ma ŋaa. ");
INSERT INTO ses_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","War ma Takulawey kaŋ ra dolobiri sii jingaroo tee, zama zaaroo din hunday no ay na war kaŋ ti wongu-izey fattandi Misira gandaa ra. War ma zaaroo din kayandi, hantum kaŋ si tun no war alwaddawey se. ");
INSERT INTO ses_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Handu jinaa, zaari woy cindi taacantoo (14to) cijinoo ra, war ma takula ŋaa kaŋ ra dolobiri sii hala handoo jirbi waranka cindi faantoo (21to) cijinoo ra. ");
INSERT INTO ses_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Jirbi iyye dolobiri masi garandi war hugey ra. Zama boro kul kaŋ na haya ŋaa kaŋ ra dolobiri goo, a ma tee yaw wala ganda-ize, boraa ga hun Izirayel jamaa ra. ");
INSERT INTO ses_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","War masi haya kul ŋaa kaŋ ra dolobiri goo. War gorodogey kul ra war ma takula ŋaa kaŋ ra dolobiri sii.» ");
INSERT INTO ses_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Musa ciya Izirayel boro beerey kul se, a nee i se: «Wa koy feeji dii ka sawa nda war alaayan beerey hinnaa, war ma Borcintaraa jingaroo feejoo koosu. ");
INSERT INTO ses_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","War ma izopu tuuri kabe foo zaa kʼa sufa kuroo ra kaŋ goo jinaa ra kʼa daŋ hugoo miɲoo beeneheroo nda caraw hinkaa ga. War ra, boro kul masi bisa nda hugoo miɲoo hala subaa ra. ");
INSERT INTO ses_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Abadantaa ga bisa gandaa ra ka Misira borey kar. Nda a ga dii kuroo hugoo miɲoo beeneheroo nda caraw hinkaa ga, Abadantaa ga bisa hugoo miɲoo ga, a si naŋ halacikaa ma huru war hugey ra ka kara. ");
INSERT INTO ses_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","War ma gaabu šennoo woo ga, hantum no ni nda ni hayroo se hala abada. ");
INSERT INTO ses_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Waati kaŋ war huru gandaa ra kaŋ Abadantaa gʼa noo war se sanda takaa kaŋ nda a nʼa har, war ma alaadaa woo dii. ");
INSERT INTO ses_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Nda war izey na war hãa ka nee: ‹Macin ti alaadaa woo almaganaa war se?› ");
INSERT INTO ses_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Wa nee: ‹Borcintaraa jingaroo kaŋ teendi Abadantaa maaɲoo ga sargaroo no, nga kaŋ waatoo kaŋ a ga Misira borey kar, a bisa Izirayel borey hugey ga Misira, a nʼir hugey hallasi.›» Jamaa gunguma ka sujudu. ");
INSERT INTO ses_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Izirayel borey koy, i nʼa tee nda takaa kaŋ nda Abadantaa na Musa nda Haruna yaamar, i nʼa tee nda takaa din da. ");
INSERT INTO ses_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Cijinoo gamoo ra, Abadantaa na Misira gandaa gunde jinawey kul kar kʼi wii, kʼa zaa za Firawuuna kaŋ ga goro kokoytaraa ra gunde jinaa hala kasa-izoo kaŋ goo kasaa ra gunde jinaa, nda adabba kul gunde jinaa. ");
INSERT INTO ses_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Firawuuna tun cijinoo ra, nga, nda nga borey, nda Misira borey kul. Kaati beeri tee Misira ra, zama hugu sii no kaŋ ra bukaw sii. ");
INSERT INTO ses_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Cijinoo din ra, Firawuuna na Musa nda Haruna cee ka nee: «Wa tun, wa fatta ka hun ay jamaa game, war nda Izirayel borey. Wa koy Abadantaa gana sanda takaa kaŋ nda war nʼa har. ");
INSERT INTO ses_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","War almaney mo, ibuuney nda ibeerey, wʼi zaa ka koy sanda takaa kaŋ nda war nʼa har. Wa koy, war ma gaara ya ne mo.» ");
INSERT INTO ses_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Misira borey na jamaa cahãndi kʼi naŋ i ma fatta gandaa ra, zama i nee: «Nda manʼti woo, ir kul ga buu.» ");
INSERT INTO ses_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Jamaa na ngi laajinoo ka koy a mana tun jina, i na ngi jinawey kaŋ ra i ga diiba daŋ ngi zaarawey ra kʼi fur ngi jesey ga. ");
INSERT INTO ses_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Izirayel borey na hayaa tee kaŋ Musa nʼa har. I na Misira borey wiri nzorfu jinayyaŋ, nda wura jinayyaŋ, nda darbayyaŋ. ");
INSERT INTO ses_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Abadantaa na jamaa noo alhormo Misira borey do kaŋ nʼi noo woo kaŋ i nʼa wiri. Takaa woo nda i na Misira borey kabey koonandi. ");
INSERT INTO ses_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Izirayel borey hun Ramses ka koy Sukot. I ga too aru zenber zangu iddu (600.000) cine kaŋ goo cee ga, zankey sii a ra. ");
INSERT INTO ses_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Boro boobo dumi-dumiyaŋ žigi ka koy i bande, nda alman buuna nda ibeeri jawdi beeri. ");
INSERT INTO ses_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","I na laajinoo kaŋ i nʼa ka hun Misira ton kʼa tee takula kaŋ ra dolobiri sii. A mana tun, zama i nkʼi gaaray ka hun Misira, i mana hin ka batu, i mana hin ka šilfanda mo zaa ngi boŋ se. ");
INSERT INTO ses_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Waatoo hinnaa kaŋ Izirayel borey nʼa tee Misira manʼti kala jiiri zangu taaci nda waranza (430). ");
INSERT INTO ses_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Jiiri zangu taaci nda waranzaa (430) benantaa ga, zaaroo din hunday no Abadantaa jamaa kul fatta Misira gandaa ra. ");
INSERT INTO ses_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Cijinoo no kaŋ ra Abadantaa hanna hala nga mʼi fattandi Misira gandaa ra. Cijin no kaŋ kayandi Abadantaa maaɲoo ga. Izirayel borey alwaddawey kul ga hanna cijinoo din cine. ");
INSERT INTO ses_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Abadantaa yee ka nee Musa nda Haruna se: «Borcintaraa jingaroo ašariyawey ne: yaw kul masi ŋaa a ra. ");
INSERT INTO ses_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Tam kul, aru kaŋ dayandi nda nooru, nda nʼnʼa daŋbangu, woo banda ga, a ma ŋaa a ra. ");
INSERT INTO ses_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Boro kaŋ ga waati tee ni do nda goykaw kaŋ ga banandi masi ŋaa a ra. ");
INSERT INTO ses_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Hugey ra a ga ŋandi. Hamoo ra, haya kul masi fatta taray. War masi biri kul kayri a ra. ");
INSERT INTO ses_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Izirayel jamaa kul ma jingaroo tee. ");
INSERT INTO ses_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Nda taabuši goo war game kaŋ ga baa nga ma Borcintaraa jingaroo tee Abadantaa maaɲoo ga, kala aru kul kaŋ goo boraa do ma hurubangu. Woo ra a ma man ka jingaroo tee, a ga tee ma nee ganda-ize. Amma boro kul kaŋ ti jofolo masi ŋaa a ra. ");
INSERT INTO ses_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Ašariya follokaa ga zuru ganda-ize nda taabuši ga.» ");
INSERT INTO ses_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Izirayel borey kul nʼa tee nda takaa kaŋ nda Abadantaa na Musa nda Haruna yaamar, i nʼa tee nda takaa din da. ");
INSERT INTO ses_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Zaaroo din hunday Abadantaa na Izirayel borey jamaa fattandi Misira gandaa ra hugu nda hugu. ");
INSERT INTO ses_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«Gunde jinaa kul yeeti ya ne jere ga. Izirayel borey ra, haya kul kaŋ ti gunde jinaa adamizey nda adabbawey ra, agay wane nda ey.» ");
INSERT INTO ses_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Musa nee jamaa se: «Wa hongu zaaroo din kaŋ ra war fatta Misira, tamtaray hugoo ra, Abadantaa na war fattandi no din nda nga kabe gaabantaa. Woo se boro kul masi takula ŋaa kaŋ ra dolobiri goo. ");
INSERT INTO ses_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Hõ, Abib handoo ra war ga fatta Misira. ");
INSERT INTO ses_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Waati kaŋ Abadantaa na ni daŋ Kanaŋ borey, nda Heti borey, nda Amor borey, nda Hewi borey, nda Žebus borey gandaa ra kaŋ a žee ni kaagey se kaŋ nga gʼa noo ma ne, ganda kaŋ ra waa nda yuu ga tee hari ma alaadaa woo tee handoo woo ra. ");
INSERT INTO ses_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Jirbi iyye ma takula ŋaa kaŋ ra dolobiri sii, jirbi iyyantoo hane jingar ga teendi Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Jirbi iyye takula kaŋ ra dolobiri sii ma ŋandi. Takula kaŋ ra dolobiri goo masi diyandi ni do, dolobiri masi diyandi ni do ni laboo kul ga. ");
INSERT INTO ses_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Zaaroo din ma filla ni izoo se ka nee: ‹Ay si woo tee kala hayaa kaŋ Abadantaa nʼa tee ya ne maaganda se waatoo kaŋ ay fatta Misira.› ");
INSERT INTO ses_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Jingaroo woo ga tee tammaasa ni kaboo ga, a ga tee hongandihaya ni teɲaa ga, hala Abadantaa ašariyaa ma bara ni miɲoo ra, zama nga ka war fattandi Misira nda nga kabe gaabantaa. ");
INSERT INTO ses_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Ma alaadaa woo tee jiiri ka kaa jiiri nga waatoo ra kaŋ kayandi jiiri ka kaa jiiri. ");
INSERT INTO ses_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Waati kaŋ Abadantaa na ni daŋ Kanaŋ borey gandaa ra sanda takaa kaŋ nda a nʼa žee ni nda ni kaagey se, de a nʼa noo ma ne, ");
INSERT INTO ses_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ma haya kul kaŋ ti gunde jinaa noo Abadantaa maaɲoo ga, adabbaa gunde jinaa mo kaŋ ni duu a, nda aru no, Abadantaa wane nda a. ");
INSERT INTO ses_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Amma farka-ize gunde jinaa kul, mʼa barmay nda alman buuna. Nda nʼsi baa mʼa barmay, ma jindebandaa kayri. Adamize izʼaru jinaa mo kul, ma nga hayoo taa. ");
INSERT INTO ses_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Nda suba ni izoo na ni hãa ka nee: ‹Macin se woo ga teendi?›, nee a se: ‹Abadantaa nkʼir fattandi Misira nda nga gaabi albarkantaa, tamtaray hugoo ra. ");
INSERT INTO ses_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Kaŋ Firawuuna muray ka wanji kʼir naŋ ir ma koy, Abadantaa na gunde jinaa kul wii Misira gandaa ra, za adamize gunde jinaa hala adabba gunde jinaa. Woo maaganda se gunde jinaa aru kul, ay gʼa sarga Abadantaa maaɲoo ga, amma ay izʼaru kul kaŋ ti gunde jinaa, ay ga nga hayoo taa.› ");
INSERT INTO ses_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","A ga tee ma ne tammaasa ni kaboo ga, a ma tee hongandihaya ni teɲaa ga, zama Abadantaa nʼir fattandi Misira nda nga kabe gaabantaa.» ");
INSERT INTO ses_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Waatoo kaŋ Firawuuna na jamaa naŋ i ma koy, Irkoy manʼi ka bisa nda Filisti borey gandaa, ba kaŋ se nga ti fondo dunbaa. Zama Irkoy nee: «Jamaa masi koy dii wongoo, i ma nimsi ka yee Misira.» ");
INSERT INTO ses_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Irkoy na jamaa ka bere ka koy saajoo fondaa ra kʼi gongu Kakaarey teekoo here. Izirayel borey žigi ka hun Misira gandaa ra cere bande, wongu-ize ka koy wongu-ize. ");
INSERT INTO ses_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Musa na Isufi birey zaa nga bande, zama a nkʼa šendandi Izirayel borey ga kʼi žeendi ka nee: «Irkoy ga hongu war, war mʼay birey ka žigi war bande ka hun ne.» ");
INSERT INTO ses_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","I hun Sukot ka koy ngi hukkumey cin Etam, saajoo miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Abadantaa ga dira jiney ra zaari here duula kaŋ ga kay i jine ra kʼi gongu fondaa ra. Cijin here a ga nuune kaŋ ga kay kʼi noo gaay. Woo ra i ga dira cijin nda zaari. ");
INSERT INTO ses_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Zaari here duulaa kaŋ ga kay si hun jamaa jine, cijin here nuunaa kaŋ ga kay si hun i jine. ");
INSERT INTO ses_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","«Nee Izirayel borey se i ma yee ka koy goro Pi-Hayrot tenje kaŋ goo Migdol nda teekoo game. War ma war hukkumey gorandi Bal-Sefoŋ tenje kaŋ goo teekoo miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Firawuuna ga miile kaŋ Izirayel borey ga dere gandaa ra, saajoo daabu i ga. ");
INSERT INTO ses_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Ay ga Firawuuna binoo šendandi, a gʼi gaarandi, amma Firawuuna nda wongu-izey kul ga tee haya kaŋ ra ay maaɲoo ga jer. Woo ra Misira borey ga bay kaŋ agay ti Abadantaa.» I na takaa din da tee. ");
INSERT INTO ses_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","I na Misira kokoyoo bayrandi kaŋ jamaa zuru. Firawuuna nda nga borey na anniya barmay, i nee: «Cin ti woo kaŋ ir nʼa tee? Ir na Izirayel borey naŋ i ma hun ir goyoo ra!» ");
INSERT INTO ses_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","A na nga bari torkawey hanse, a na nga jamaa zaa nga bande. ");
INSERT INTO ses_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","A na torka zangu iddu (600) suubanteyaŋ ka koy nga bande nda Misira torkawey jerey kul, ngi affoo kul sooje jalakoyniyaŋ goo a boŋ. ");
INSERT INTO ses_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Abadantaa na Firawuuna, Misira kokoyoo binoo šendandi, a na Izirayel borey gaarandi, ka gar i nka fatta, haya kul manʼi ganji. ");
INSERT INTO ses_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Misira borey nʼi gaarandi, baryey kul, nda Firawuuna torkawey, nda nga bari kaarukey, nda nga wongu-izey toorʼey nongoo kaŋ ra i goro teekoo miɲoo ga, Pi-Hayrot here, Bal-Sefoŋ tenje. ");
INSERT INTO ses_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Kaŋ Firawuuna man ey, Izirayel borey na ngi moɲey jer, nga ne, Misira borey goo dumawey ga. Izirayel borey hanse ka hunbur, i kaati ka Abadantaa cee. ");
INSERT INTO ses_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","I nee Musa se: «Saaray nka sii Misira kaŋ se ni kate ir saajoo ra ir ma buu? Macin ti woo kaŋ nʼnʼa tee kʼir kaa Misira? ");
INSERT INTO ses_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Waatoo kaŋ ir goo Misira, ir mana nee ma ne kaŋ mʼir naŋ, ir yadda ir ma tee tam Misira borey se? Zama ir baa ir ma tee i se tam ka bisa ir ma buu saajoo ra.» ");
INSERT INTO ses_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Amma Musa nee jamaa se: «War masi hunbur, wa batu ka dii Abadantaa hallasiroo kaŋ a ga kate a hõ war se! Zama Misira borey kaŋ war ga dii ey hõ, war si yee ka dii ey koyne hala abada. ");
INSERT INTO ses_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Abadantaa no ma wongu war dogey ra. War, wa dangay de ka guna.» ");
INSERT INTO ses_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Abadantaa nee Musa se: «Macin se nʼga kaati kʼay cee? Nee Izirayel borey se i ma fondaa zaa. ");
INSERT INTO ses_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ni, ma ni goboo jer, ma ni kaboo šerre teekoo ga, mʼa fersi, hala Izirayel borey ma bisa teekoo gamoo ra labu kogaa ga. ");
INSERT INTO ses_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Nga ne, agay, ay ga Misira borey biney šendandi hala i ma duu ka huru dumawey ga. Woo ra ay ga Firawuuna nda nga wongu-izey kul, nda nga bari torkawey, nda nga bari kaarukey kʼay daržaa cebe. ");
INSERT INTO ses_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Waati kaŋ ay na Firawuuna, nda nga torkawey, nda nga bari kaarukey kʼay daržaa cebe, waatoo din Misira borey ga bay kaŋ agay ti Abadantaa.» ");
INSERT INTO ses_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Irkoy almalaykaa kaŋ cindi ka dira Izirayel jamaa jine hun jiney ra ka yee dumawey ga. Duulaa kaŋ ga kay kaŋ cindi i jine, yee ngi banda here. ");
INSERT INTO ses_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","A koy huru Misira borey gorodogoo nda Izirayel gorodogoo game. Misira here duulaa tee kubay, Izirayel here duulaa ga gaay noo cijinoo ra. Boro foo kul mana too ceroo do cijinoo kul. ");
INSERT INTO ses_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Musa na nga kaboo šerre teekoo ga, Abadantaa na dandi hew beeri foo tunandi cijinoo kul ka teekoo kogandi, haroo fersi. ");
INSERT INTO ses_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Izirayel borey koy teekoo gamoo ra labu kogaa ga, haroo tee i se cete, kabe guma nda iwaawa here. ");
INSERT INTO ses_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Misira borey nʼi gaarandi, i huru dumawey ga, Firawuuna baryey kul, nda nga torkawey, nda nga bari kaarukey huru dumawey ga teekoo gamoo ra. ");
INSERT INTO ses_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Za moo mana boo, duulaa kaŋ ga kay nda nuunaa kaŋ ga kay ra Abadantaa na Misira borey wongu-izey guna, a nʼi ɲaami. ");
INSERT INTO ses_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","A na torkawey cewey kaa ka ngi zuraa šendandi. Misira borey nee: «Ir ma zuru ka mooru Izirayel, zama Abadantaa no ma Misira wongu i se.» ");
INSERT INTO ses_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Abadantaa nee Musa se: «Ni kaboo šerre teekoo ga, hala haroo ma yee kate Misira borey, nda ngi bari torkawey, nda ngi bari kaarukey ga.» ");
INSERT INTO ses_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Musa na nga kaboo šerre teekoo ga. Waatoo kaŋ moo ga baa ka boo, teekoo yee nga doo žeenaa ra. Misira borey zuru teekoo jine, Abadantaa nʼi kaŋandi teekoo gamoo ra. ");
INSERT INTO ses_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Haroo yee kate ka bari torkawey, nda bari kaarukey kaŋ goo Firawuuna wongu-izey kul ra kaŋ huru teekoo ra Izirayel borey banda ga, haroo daabu i ga, ba affoo i ra mana cindi. ");
INSERT INTO ses_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Amma Izirayel borey bisa teekoo gamoo ra labu kogaa ga, haroo tee i se cete kabe guma nda iwaawa here. ");
INSERT INTO ses_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Hanoo din, Abadantaa na Izirayel hallasi Misira borey kaboo ra. Izirayel dii Misira borey bukawey teekoo miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Kaŋ Izirayel dii gaaboo kaŋ nda Abadantaa na Misira borey halaci, jamaa hunbur Abadantaa, i naanay Abadantaa nda nga tamoo Musa. ");
INSERT INTO ses_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Waati follokaa ra Musa nda Izirayel borey na doonoo woo don Abadantaa maaɲoo ga. I nee: «Ay ga don Abadantaa maaɲoo ga, zama a na nga hinoo cebe, baryoo nda kaarukaa, a nʼi warra teekoo ra. ");
INSERT INTO ses_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Abadantaa ti ay gaaboo nda ay doonoo addaliloo. A tee ya ne hallasiyan. Nga ti ay Koyoo, ay gʼa saabu. Nga ti ay baabaa Koyoo, ay ga maaɲoo jer. ");
INSERT INTO ses_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Abadantaa manʼti kala wongaari. Abadantaa ti maaɲoo. ");
INSERT INTO ses_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","A na Firawuuna bari torkawey nda nga wongu-izey warra haroo ra. Wongu-ize jalakoyni suubantey yoole Kakaarey teekoo ra. ");
INSERT INTO ses_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Haroo bondawey nʼi daabu, i dere hari guusey ra ma nee tondiyaŋ. ");
INSERT INTO ses_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Abadantaa, ni kabe gumaa na ni hinoo cebe. Abadantaa, ni kabe gumaa ka iberoo motti. ");
INSERT INTO ses_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ni kokoytaraa beeriyanoo ra nʼga borey warra ganda kaŋ ture ni ga. Nʼga ni futuyanoo nuunaa sanba kaŋ gʼi ton ma nee subu. ");
INSERT INTO ses_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Ni hunsaroo gaaboo na haroo marga. Bondawey kay ma nee lalaba. Hari guusey kay teekoo gamoo ra. ");
INSERT INTO ses_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Iberoo nee: ‹Ay gʼi gaarandi, ay ga duu ey, ay ga alganiimaa zamna, ay gʼa tee woo kaŋ ay baa, ay gʼay takubaa hoobu, ay kaboo gʼi halaci.› ");
INSERT INTO ses_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Nʼna ni hewoo funsu, teekoo daabu i ga. I sundu ma nee badila hari beerey ra. ");
INSERT INTO ses_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Koyey ra, may ti ni cine koy, Abadantaa? May no ma too ni henanyan ra? May ka si hunbur ni? May no ma too ni beeray ra? May no ma too ni kayfi teeyan ra? ");
INSERT INTO ses_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Nʼna ni kabe gumaa šerre, laboo nʼi gon. ");
INSERT INTO ses_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ni arrahamaa nda nʼna ni jamaa gongu, jamaa kaŋ nʼnʼa feeri. Ni hinoo ra, nʼga huru i jine ka koy nda ey ni gorodoo henanantaa ra. ");
INSERT INTO ses_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Jamawey maarʼa, i jijiri. Hunburay duu Filisti gandaa borey. ");
INSERT INTO ses_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Waatoo din Edom boŋkoyney zalba. Mowab alwakiiley, jijiriyan duu ey. Kanaŋ gandaa gorokey kul biney hasara. ");
INSERT INTO ses_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Jitiyan nda hunburay kaŋ i boŋ. Ni kabe gaabantaa jine i tee suk ma nee tondi, i si hin ka šelaŋ hala waati kaŋ ni jamaa ga dira ka bisa, Abadantaa, hala waati kaŋ ni jamaa kaŋ nʼnʼa sawal, dira ka bisa. ");
INSERT INTO ses_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Nʼga huru i jine kʼi gorandi tondi hondoo boŋ kaŋ ti ni wane, nongoo kaŋ ni, Abadantaa nʼa hanse a ma tee ni gorodogoo, a ma tee ni nongu henanantaa kaŋ ni, ir Koyoo, ni kaboo nʼa gorandi. ");
INSERT INTO ses_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Abadantaa, nʼga laama waati kul hala abada.» ");
INSERT INTO ses_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Waatoo kaŋ Firawuuna baryey, nda nga torkawey, nda nga bari kaarukey huru teekoo ra, Abadantaa na teekoo haroo yee katandi kʼa gum i boŋ. Amma Izirayel borey bisa teekoo gamoo ra labu kogaa ga. ");
INSERT INTO ses_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Annabi Maryama kaŋ ti Haruna woymaa na dunduŋoo zaa, woyey kul fatta ka hanga a, i ga hooray nda dunduŋoo, i ga gan. ");
INSERT INTO ses_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Maryama ga tuuru ka nee i se: «Wa don Abadantaa maaɲoo ga, a na nga hinoo cebe. Baryoo nda nga kaarukaa, a nʼi warra teekoo ra.» ");
INSERT INTO ses_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Musa na Izirayel ka hun Kakaarey teekoo do ka koy Šur saajoo ra. I dira jirbi hinza saajoo ra i mana duu hari. ");
INSERT INTO ses_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","I too Mara, amma i mana hin ka Mara haroo haŋ, zama a mma hottu. Woo se i na nongoo maaɲoo daŋ Mara (maanaa «hottay»). ");
INSERT INTO ses_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Jamaa ŋuunuŋuunu Musa ga ka nee: «Macin no ir gʼa haŋ?» ");
INSERT INTO ses_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","A kaati ka Abadantaa cee, Abadantaa na bundu dumi cebe a se. Musa nʼa warra haroo ra, haroo bere ka tee haya kaŋ si hottu. No din ra a na ašariyayaŋ nda yaamaryaŋ gorandi jamaa se. No din da ra a nʼi sii. ");
INSERT INTO ses_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","A nee: «Nda nʼga haŋajer ka boori Abadantaa, ni Koyoo šennoo se, nda nʼga haya tee kaŋ ga henan a jine, nda nʼga haŋajer nga ašariyawey, nda nʼga nga yaamarey kul dii, wircey kaŋ ay nʼi daŋ Misira borey ra, ba affoo si duu ni, zama agay ti Abadantaa kaŋ ga ni noo gaaham baani.» ");
INSERT INTO ses_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Izirayel borey too Elim, no din ra hariɲaa woy cindi hinka (12) goo, nda teenayɲaa woyye (70). I goro no din haroo jeroo ga. ");
INSERT INTO ses_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Izirayel borey jamaa kul hun Elim. Kaŋ i fatta Misira gandaa ra handu hinkantoo jirbi woy cindi guwantoo (15to) ra, i too Sin saajoo ra kaŋ goo Elim nda Sinay tondi hondoo game. ");
INSERT INTO ses_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Saajoo ra, Izirayel borey jamaa kul ŋuunuŋuunu Musa nda Haruna ga. ");
INSERT INTO ses_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Izirayel borey nee i se: «Nda ba ir nka buu Abadantaa kaboo ra Misira gandaa ra, kaŋ ir ga goro ham hina kusey jere, ir ga takula ŋaa hala ir ma kungu! War nʼir ka kaa saajoo woo ra ka jamaa woo kul naŋ i ma buu nda heray.» ");
INSERT INTO ses_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Abadantaa nee Musa se: «Ay ga ŋaayan tee ncirɲi ka hun beenaa ra kʼa doori war boŋ. Zaari kul jamaa ga fatta ka ngi zaaroo ŋaahayaa kuuna hala yʼi sii ka dii wala i ga agʼašariyaa dii wala i sʼa dii. ");
INSERT INTO ses_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Jirbi idduwantoo hane, woo kaŋ i na kuuna, i gʼa hina. Jirbi idduwantoo wanoo ga tee zaari hinka cine wane.» ");
INSERT INTO ses_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Musa nda Haruna nee Izirayel borey kul se: «Hõ wiciroo war ga kaa ka bay kaŋ Abadantaa ka war fattandi Misira gandaa ra. ");
INSERT INTO ses_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Subbaahoo ra, war ga kaa ka dii Abadantaa daržaa. Zama a maa ŋuunuŋuunuyanoo kaŋ war nʼa tee nga, Abadantaa ga. Ir ti may hala war ma ŋuunuŋuunu ir ga?» ");
INSERT INTO ses_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Musa nee: «War ga kaa ka bay waati kaŋ wiciroo ra Abadantaa ga war noo ham, subbaahoo ra, a ga war noo takula war ma ŋaa ka kungu. Zama Abadantaa maa ŋuunuŋuunuyanoo kaŋ war nʼa tee nga ga. Ir ti macin? Manʼti ir ga war ga ŋuunuŋuunu, Abadantaa ga war ga ŋuunuŋuunu.» ");
INSERT INTO ses_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Musa nee Haruna se: «Nee Izirayel borey jamaa kul se: ‹Wa koy kay Abadantaa jine, zama a maa war ŋuunuŋuunuyanoo.›» ");
INSERT INTO ses_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Kaŋ Haruna goo ma šelaŋ Izirayel borey jamaa se, i bere saajoo here, nga ne, Abadantaa daržaa bangay duulaa ra. ");
INSERT INTO ses_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","«Ay maa Izirayel borey ŋuunuŋuunuyanoo. Šelaŋ i se ka nee: ‹Almaari, war ga ham ŋaa, subbaahoo ra war ga kungu takula ra. Woo ra war ga kaa ka bay kaŋ agay ti Abadantaa, war Koyoo.›» ");
INSERT INTO ses_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Wiciroo ra, jerfendayyaŋ kaa ka jamaa kaloo kul daabu, subbaahoo ra, harandaŋ ga jamaa kaloo kuubi kʼa bere. ");
INSERT INTO ses_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Waati kaŋ harandaŋoo boosu, nga ne, saajoo ga daabu nda haya baana kaŋ ga kakasu, a ga ban, a ga hima nda ma nee gari-ize buuna-buunayaŋ kaŋ goo laboo boŋ. ");
INSERT INTO ses_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Izirayel borey dii a, i na cere hãa ka nee: «Macin ti woo?» Zama i mana bay haya kaŋ no. Musa nʼi zaabi ka nee: «Takulaa no kaŋ Abadantaa nʼa noo a ma tee war se ŋaayan. ");
INSERT INTO ses_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Hayaa ne kaŋ Abadantaa nʼa yaamar: ‹Boro kul ma hayaa zaa kaŋ a ga hin kʼa ŋaa. War ma liitar taaci cine zaa boro foo kul se. Boro foo kul ma zaa borey se ka sawa nda borey hinnaa kaŋ goo nga hukkumoo cire.›» ");
INSERT INTO ses_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Izirayel borey na takaa din da tee. I kuuna, affooyaŋ iboobo, affooyaŋ ikaccu. ");
INSERT INTO ses_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Woo banda ga, i nʼa kabu nda liitar. Woo kaŋ na iboobo kuuna, a mana boobo a se, woo kaŋ na ikaccu kuuna, a mana kacca a se. Boro foo kul na woo kaŋ a ga hin kʼa ŋaa kuuna. ");
INSERT INTO ses_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Musa nee i se: «Boro kul masi haya kanandi ŋaahayaa ra hala subbaahi.» ");
INSERT INTO ses_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Amma i mana haŋajer Musa se, boroyaŋ na haya kanandi ŋaahayaa ra hala subbaahoo ra. Nooni tun a ra, a funbu. Musa futu i ga. ");
INSERT INTO ses_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Subbaahi ka kaa subbaahi i ga hayaa kuuna kaŋ boro kul ga hin kʼa ŋaa. Nda waynaa koron, a ga menne. ");
INSERT INTO ses_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Jirbi idduwantoo hane i ga woo kaŋ i ga doona kʼa kuuna cine hinka kuuna, boro foo kul liitar yaaha. Jamaa boŋkoyney kul kaa kʼa filla Musa se. ");
INSERT INTO ses_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Musa nee i se: «Woo ti hayaa kaŋ Abadantaa nʼa har. Suba ti hunanzamzaaroo, hunanzamzaari henanante Abadantaa maaɲoo ga. Wa hayaa hina kaŋ ga hima ka hina, war ma hayaa zargandi kaŋ ga hima ka zargandi. Woo kaŋ cindi, war mʼa jisi war boŋ se hala suba.» ");
INSERT INTO ses_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","I nʼa jisi hala suba sanda takaa kaŋ nda Musa nʼa yaamar. A mana funbu, nooni mana tun a ra. ");
INSERT INTO ses_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Musa nee: «Wʼa ŋaa hõ, hunanzamzaari no Abadantaa maaɲoo ga, hõ haya si duwandi taray. ");
INSERT INTO ses_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","War ga ŋaahaya kuuna jirbi iddu, amma jirbi iyyantoo manʼti kala hunanzamzaaroo. Haya sii no.» ");
INSERT INTO ses_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Woo kul, jirbi iyyantoo hane jamaa ra boroyaŋ fatta ka koy kuuna, amma i mana duu haya kul. ");
INSERT INTO ses_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Abadantaa nee Musa se: «Hala waati foo no war ga yadda kʼay yaamarey nda ay ašariyawey dii? ");
INSERT INTO ses_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","War ma bay kaŋ hunanzamzaaroo kaŋ Abadantaa nʼa noo war se maaganda se, jirbi idduwantoo hane a ga war noo jirbi hinka ŋaahayaa. Jirbi iyyantoo hane boro kul ma cindi nga do, boro kul masi fatta.» ");
INSERT INTO ses_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Jirbi iyyantoo jamaa hunanzam. ");
INSERT INTO ses_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Izirayel hugoo borey na ŋaahayaa din maaɲoo daŋ «man». A ga hima nda hayni gurunbu. A ga kaaray, nga tenbaa ga hima nda furme kaŋ teendi nda yuu. ");
INSERT INTO ses_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa nee: «Hayaa ne kaŋ Abadantaa nʼa yaamar: ‹War ma mudu foo too a ra war alwaddawey se, hala i ma dii takulaa kaŋ nda ay na war huna saajoo ra waatoo kaŋ ay na war fattandi Misira gandaa ra.›» ");
INSERT INTO ses_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Woo banda ga, Musa nee Haruna se: «Jinay foo zaa, mʼa too nda man liitar taaci, mʼa jisi Abadantaa jere, hala ma man jisi war alwaddawey se.» ");
INSERT INTO ses_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Sanda takaa kaŋ nda Abadantaa na Musa yaamar, Haruna nʼa jisi seedetaraa sundukoo jine, hala a ma duu ka jisandi. ");
INSERT INTO ses_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Izirayel borey na manoo ŋaa jiiri woytaaci (40) hala i ga too gandaa kaŋ ra boro goo. I na manoo ŋaa hala waatoo kaŋ i too Kanaŋ gandaa šintinoo ga. ");
INSERT INTO ses_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Mudu foo ga sawa nda neešihaya foo kaŋ se i ga nee efa zamna woyaa (10) affoo. ");
INSERT INTO ses_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Izirayel borey jamaa kul hun Sin saajoo ra ka kay nongu nda nonguyaŋ ra ka sawa nda Abadantaa yaamaroo. I goro Refidim, amma hari sii no din kaŋ jamaa gʼa haŋ. ");
INSERT INTO ses_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Jamaa yenje nda Musa ka nee: «Ir noo hari ir ma haŋ». Musa nee i se: «Macin se war ga yenje nda agay? Macin se war ga Abadantaa sii?» ");
INSERT INTO ses_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","No din ra hari jaw duu jamaa, i ŋuunuŋuunu Musa ga ka nee: «Cin se nʼnʼir žigandi ka hun Misira kʼir, nda ir izey, nda ir jawdey naŋ ir ma buu nda jaw?» ");
INSERT INTO ses_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Musa kaati ka Abadantaa cee ka nee: «Macin no yʼa tee jamaa woo se? Ne nda kayna i gʼay warra nda tondi kʼay wii.» ");
INSERT INTO ses_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Abadantaa nee Musa se: «Bisa jamaa jine, ma boroyaŋ zaa Izirayel boro beerey ra, goboo kaŋ nda nʼna isaa kar zaa ni kaboo ra ma koy. ");
INSERT INTO ses_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Nga ne, ay ga kay ni jine tondoo ga kaŋ goo Horeb jeroo ga. Ma tondoo kar, hari ga fatta a ra, jamaa ga haŋ.» Musa na yaamaroo din tee Izirayel boro beerey jine. ");
INSERT INTO ses_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Yenjaa kaŋ Izirayel borey nʼa tee nda siiyanoo maaganda kaŋ i nʼa tee Abadantaa se ka nee: «Abadantaa goo ir game wala a sii ir game?» Woo maaganda a na nongoo maaɲoo daŋ Masa (maanaa «siiyan») nda Meriba (maanaa «yenje»). ");
INSERT INTO ses_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Amalek borey koy Izirayel borey wongu Refidim. ");
INSERT INTO ses_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Musa nee Žozuwe se: «Aruyaŋ suuba ir se, ma fatta ka Amalek borey wongu. Suba agay, ay ga kay hondoo boŋoo boŋ, Irkoy goboo goo ay kaboo ra.» ");
INSERT INTO ses_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Žozuwe nʼa tee nda takaa kaŋ nda Musa nʼa har a se, a koy Amalek borey wongu. Amma Musa, nda Haruna, nda Hur žigi hondoo boŋoo ga. ");
INSERT INTO ses_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Kullihinne Musa kabey goo beene, Izirayel ga hin, nda a na nga kabey zumandi, Amalek borey ga hin. ");
INSERT INTO ses_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Kaŋ Musa kabey fara, i na tondi zaa kʼa daŋ a cire a ma goro a ga. Haruna nda Hur goo carawey ga i ga kabey gaa, affoo goo caraw foo ga, affaa goo caraw faa ga. Kabey cindi takaa din da hala waynaa kaŋyanoo ga. ");
INSERT INTO ses_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Žozuwe na nga takubaa ka hin Amalek nda nga jamaa. ");
INSERT INTO ses_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Abadantaa nee Musa se: «Woo hantum citaabu ra, a ma tee hongandihaya. Daŋ Žozuwe haŋaa ra kaŋ ay ga Amalek borey benandi hala nongu kaŋ ra aduɲɲa ra boro si yee ka hongu ey.» ");
INSERT INTO ses_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Musa na sargari tonadoo foo cin, a na maaɲoo daŋ «Abadantaa ti ay liiliwaloo». ");
INSERT INTO ses_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","A nee: «Zama i na Abadantaa kokoy gorodogoo wongu, woo manʼti kala wongu Abadantaa nda Amalek borey game zaman ka kaa zaman.» ");
INSERT INTO ses_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Žetro, Majaŋ gandaa sargari juwalkaw, Musa nzuraa, maa hayaa kul kaŋ Irkoy nʼa tee Musa nda Izirayel Irkoy jamaa se, maanaa takaa kaŋ nda Abadantaa na Izirayel fattandi Misira. ");
INSERT INTO ses_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Žetro, Musa nzuraa na Sefora, Musa wandoo zaa nga bande, waatoo kaŋ Musa nʼa sanba baaboo do banda ga. ");
INSERT INTO ses_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","A kate Sefora izʼaru hinkaa. Affoo maaɲoo ti Geršom (maanaa «ka koy goro no din»), zama a nka nee: «Ya nka koy goro labu waani ra.» ");
INSERT INTO ses_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Affaa maaɲoo ti Eliyezer (maanaa «ay Koyoo ti hallasikaw»). A nee: «Zama ay baabaa Koyoo ka kaa kʼay hallasi kʼay waa Firawuuna takuba.» ");
INSERT INTO ses_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Žetro, Musa nzuraa koy nda Musa izʼarey nda nga wandoo Musa do saajoo kaŋ ra a ga goro, Irkoy tondi hondoo jere. ");
INSERT INTO ses_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","A donto ka nee Musa se: «Agay no Žetro ni nzuraa, ay ga kaa ni do, nda ni wandoo, nda nga izʼaru hinkaa kaŋ goo a bande.» ");
INSERT INTO ses_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Musa fatta ka koy nga nzuraa kubay, a gunguma a se, a nʼa summu. I na cere foo, i huru hukkumoo ra. ");
INSERT INTO ses_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Musa na takaa filla nga nzuraa se kaŋ Abadantaa nʼa tee Firawuuna nda Misira se Izirayel maaganda, nda faraa kul kaŋ duu ngey fondaa ra, nda takaa kaŋ nda Abadantaa na ngi kaa kabe ra. ");
INSERT INTO ses_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Žetro ɲaali nda gomnoo kul kaŋ Abadantaa nʼa tee Izirayel se kʼi kaa Misira borey kabey ra. ");
INSERT INTO ses_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Žetro nee: «Albarka ma bara Abadantaa se kaŋ na war kaa Misira borey nda Firawuuna kaboo ra, kaŋ na jamaa kaa Misira borey kabey ra! ");
INSERT INTO ses_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ay bay sohõ kaŋ Abadantaa bisa koyey kul, zama a na nga jamaa hallasi waatoo kaŋ Misira borey gʼi kabekunafutay.» ");
INSERT INTO ses_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Žetro, Musa nzuraa na sargari kukurante nda sargari tanayaŋ kaa Irkoy se. Haruna nda Izirayel boro beerey kul kaa ka ŋaa Musa nzuraa bande Irkoy jine. ");
INSERT INTO ses_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Subaa ra, Musa goro ka jamaa ciiti. Jamaa cindi Musa jine za subbaahi hala cijinoo ra. ");
INSERT INTO ses_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Musa nzuraa dii hayaa kul kaŋ a gʼa tee jamaa se, a nee a se: «Macin ti woo kaŋ nʼgʼa tee jamaa se? Macin se nʼga goro ni hinne, amma jamaa ga kay ni jine za subbaahi hala cijinoo ra?» ");
INSERT INTO ses_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musa nee nga nzuraa se: «Jamaa mma kaa ay do ya Irkoy ibaayoo ceeci i se. ");
INSERT INTO ses_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Nda haya huru i game, i mma kaa ay do ya ciiti i game, ay gʼi bayrandi Irkoy yaamarey nda nga ašariyawey.» ");
INSERT INTO ses_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Musa nzuraa nee a se: «Takaa kaŋ nʼgʼa tee si boori. ");
INSERT INTO ses_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Nʼga ni boŋ farandi, ni nda jamaa kaŋ goo ni bande. Goyoo ga hanse ka tiŋ ma ne, ni hinne si hin kʼa tee. ");
INSERT INTO ses_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Sohõ, haŋajer ay šennoo se, ay ga ni noo hoyray foo, Irkoy goo ni bande. Ni no ma tuuru jamaa maaɲoo ga Irkoy jine, ni no ma jamaa almušakkawey ka koy Irkoy jine. ");
INSERT INTO ses_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Ma borey fahamandi yaamarey nda ašariyawey. Mʼi bayrandi fondaa kaŋ i ga hima ka hanga a, nda haya kaŋ i ga hima kʼa tee. ");
INSERT INTO ses_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ni, ma aru alkadaranteyaŋ suuba jamaa ra kaŋ ga hunbur Irkoy, laadiranteyaŋ kaŋ si zanba. I daŋ jamaa jine: boro zenber foo (1.000) kul ma affoo daŋ i jine, boro zangu (100) kul ma affoo daŋ i jine, boro woyguu (50) kul ma affoo daŋ i jine, boro woy (10) kul ma affoo daŋ i jine. ");
INSERT INTO ses_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Waati kul ngi no ma jamaa ciiti. Haya kul kaŋ ga beeri, i mʼa ka kaa ni do, amma haya kaŋ ga kacca, i mʼa ciiti ngi hunday. Kaa jeraa ra kaŋ goo ni boŋ, i ga ni faaba kʼa zaa. ");
INSERT INTO ses_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Nda nʼna woo tee, nda Irkoy na ni yaamar nda woo, nʼga hin ka kay jeraa cire, jamaa woo kul ga koy ngi dogoo ra nda baani.» ");
INSERT INTO ses_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musa na nga nzuraa hoyrawey dii, a na hayaa kul tee kaŋ a nʼa har a se. ");
INSERT INTO ses_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Musa na aru alkadaranteyaŋ suuba Izirayel kul ra kʼi tee boŋkoyniyaŋ jamaa se, boro zenber foo (1.000) boŋkoyni foo, boro zangu (100) boŋkoyni foo, boro woyguu (50) boŋkoyni foo, nda boro woy (10) boŋkoyni foo. ");
INSERT INTO ses_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Ngi no ma jamaa ciiti waati kul. Haya kaŋ šendi, i gʼa ka too Musa do. Amma haya kaccu kul, i gʼa ciiti ngi hunday. ");
INSERT INTO ses_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Musa na nga nzuraa naŋ a ma koy, nzuraa koy nga gandaa ra. ");
INSERT INTO ses_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Izirayel borey handu hinzantoo Misira gandaa fattaroo banda ga, zaari jinaa i too Sinay saajoo ra. ");
INSERT INTO ses_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","I nka hun Refidim ka koy Sinay saajoo ra, i goro saajoo din ra. Izirayel goro no din tondi hondoo tenje, ");
INSERT INTO ses_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","amma Musa žigi ka koy Irkoy do. Abadantaa nʼa cee tondi hondoo boŋ ka nee a se: «Ma nee Yakuba hugoo borey se, ma bayrandi Izirayel borey se ka nee: ");
INSERT INTO ses_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‹War dii hayaa kaŋ ay nʼa tee Misira borey se, sanda takaa kaŋ nda dutal ga nga izey zaa nga fatawey ra, ay na war zaa ka kate war ay do. ");
INSERT INTO ses_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Sohõ, nda war haŋajer ay šennoo se ka boori, war na agay amaanaa dii, war ga tee agay hunday bagaa jamawey kul ra, zama agay wane nda laboo kul. ");
INSERT INTO ses_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","War ga tee ya ne kokoy sargari juwalkawyaŋ nda dumi henanante.› Wey ti šenney kaŋ nʼgʼi har Izirayel borey se.» ");
INSERT INTO ses_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Musa kaa, a na jamaa boro beerey cee, a na šenney wey kul daŋ i jine kaŋ nda Abadantaa nʼa yaamar. ");
INSERT INTO ses_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Jamaa kul nʼa zaabi cere bande ka nee: «Haya kul kaŋ Abadantaa nʼa har ma ne, ir gʼa tee.» Musa na jamaa šenney ka yee Abadantaa do. ");
INSERT INTO ses_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Abadantaa nee Musa se: «Ay ga kaa ni do duula kubayante ra, hala waati kaŋ ay ga šelaŋ ni bande jamaa ma maa, hala i ma naanay ni hala abada.» Musa na jamaa šenney ka too Abadantaa do. ");
INSERT INTO ses_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Abadantaa nee Musa se: «Koy jamaa do, mʼi daŋ jere ga ya ne hõ nda suba. I ma ngi darbawey ɲumandi. ");
INSERT INTO ses_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","I ma soolu jirbi hinzantoo se, zama jirbi hinzantoo ra Abadantaa ga zunbu Sinay tondi hondoo ga jamaa kul jine. ");
INSERT INTO ses_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Hirriyaŋ daŋ tondi hondoo kuubi-ka-beraa ga kaŋ ga jamaa si bisa, nee i se: ‹Wa hawgay war masi žigi tondi hondoo ga, war masi tuku carawey ga.› Boro kul kaŋ tuku tondi hondoo ga, a waazibi boraa ma wiiyandi. ");
INSERT INTO ses_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Kabe kul masi tuku boraa ga, amma i mʼa warra nda tondi kʼa wii wala i mʼa hay nda yaaji. A ma tee adabba wala boro, a masi huna. Waati kaŋ hilloo na hẽeni kuku tee, i ma žigi tondi hondoo ga.» ");
INSERT INTO ses_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Musa zunbu tondi hondoo ga ka kaa jamaa do. A na jamaa yeeti jere ga Irkoy se, i na ngi darbawey ɲumandi. ");
INSERT INTO ses_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","A nee jamaa se: «War ma soolu jirbi hinzantoo se. War masi too woy do.» ");
INSERT INTO ses_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Jirbi hinzantoo hane, kaŋ moo boo, jiŋjiŋyaŋ, nda meliyaŋ, nda duula kubayante goo tondi hondoo boŋ, hilli jinde beeri hẽe. Alžamaa kul kaŋ goo jamaa kaloo ra jijiri. ");
INSERT INTO ses_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Musa na jamaa ka fatta ka koy Irkoy kubay jamaa kaloo dumaa ga. I kay tondi hondoo cire. ");
INSERT INTO ses_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Sinay tondi hondoo kul ka tee dullu, zama Abadantaa mana zunbu kala nuune ra. Dulloo žigi ni mma nee alforon beeri dullu. Tondi hondoo kul hanse ka jijiri. ");
INSERT INTO ses_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Hilloo jindoo mma koy de a ga beeri, Musa ga šelaŋ, Irkoy gʼa zaabi jiŋjiŋyan ra. ");
INSERT INTO ses_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Abadantaa zunbu Sinay tondi hondoo ga, tondi hondoo boŋoo boŋ. Tondi hondoo boŋoo boŋ Abadantaa ciya Musa se, Musa žigi. ");
INSERT INTO ses_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Abadantaa nee Musa se: «Zunbu ka kašeta jamaa ga, i masi bisa hirrey ga ka koy Abadantaa do ka dii, nda i nʼa tee, iboobo ga buu i ra. ");
INSERT INTO ses_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ba sargari juwalkey kaŋ ga hin ka man Abadantaa, ga hima ka ngi boŋ yeeti jere ga Irkoy se, hala Abadantaa masʼi wii.» ");
INSERT INTO ses_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musa nee Abadantaa se: «Jamaa si hin ka žigi Sinay tondi hondoo ga, zama ni nka kašeta ir ga ka nee: ‹Ma hirriyaŋ daŋ tondi hondoo se, mʼa daŋ jere ga ya ne.›» ");
INSERT INTO ses_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Abadantaa nee a se: «Koy ma zunbu, hiino ma žigi, Haruna ma žigi ni bande. Amma sargari juwalkey nda jamaa masi hirrey hoo ka žigi ka koy Abadantaa do, nda i nʼi hoo, a gʼi wii.» ");
INSERT INTO ses_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Musa zunbu jamaa do kʼa har i se. ");
INSERT INTO ses_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Šenney ne kaŋ Irkoy nʼi har, a nee: ");
INSERT INTO ses_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","«Agay ti Abadantaa, ni Koyoo kaŋ na ni fattandi Misira gandaa ra, tamtaray hugoo ra. ");
INSERT INTO ses_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Masi koy tana gana ay banda ga. ");
INSERT INTO ses_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Masi tooru hanse, masi bii tee kaŋ ga hima nda haya kaŋ goo beene beenaa ra, wala ganda laboo ga, wala haroo ra laboo cire. ");
INSERT INTO ses_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Masi sujudu koyey wey se, masʼi gana, zama agay, Abadantaa, ni Koyoo manʼti kala Koy kaŋ ga canse ma ne, ka baaba kaŋ konna agay layboo ka hanga hala nga izey alwadda hinzantoo ka koy itaacantoo ga. ");
INSERT INTO ses_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Amma ay ga agay arrahamaa cebe alwadda zenberyaŋ se kaŋ ga baa agay, de i gʼay yaamarey dii. ");
INSERT INTO ses_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Masi Abadantaa, ni Koyoo maaɲoo cee bila addalil, zama Abadantaa si boro naŋ kaŋ ga nga maaɲoo cee bila addalil. ");
INSERT INTO ses_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Ma hanse ka hongu hunanzamzaaroo, a ma yeetandi jere ga ya ne. ");
INSERT INTO ses_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Jirbi iddu ma goy, ma ni almušakkawey kul tee. ");
INSERT INTO ses_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Amma jirbi iyyantoo, hunanzamzaari no Abadantaa, ni Koyoo maaɲoo ga. Masi almušakka kul tee, ni, nda ni izʼaroo, nda ni ize woyoo, takaa din da ni baɲɲaa, nda ni koŋŋaa, nda ni adabbaa, nda taabuši kaŋ goo ni koyrawey ra. ");
INSERT INTO ses_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Zama jirbi iddu ra Abadantaa na beenaa, nda laboo, nda teekoo nda haya kul kaŋ goo i ra tee. Amma jirbi iyyantoo hane a hunanzam. Woo se Abadantaa na albarka daŋ hunanzamzaaroo ra, a nʼa yeeti jere ga. ");
INSERT INTO ses_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Ma ni baabaa nda ni ɲaa beerandi hala ma duu aloomur gandaa ra kaŋ Abadantaa, ni Koyoo gʼa noo ma ne. ");
INSERT INTO ses_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Masi boro wii. ");
INSERT INTO ses_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Masi zina. ");
INSERT INTO ses_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Masi zay. ");
INSERT INTO ses_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Masi taari seedetaray tee ni cinaa ga. ");
INSERT INTO ses_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Masi haya kaŋ goo ni cinaa hugoo ra boonay. Masi ni cinaa wandoo boonay, wala nga baɲɲaa, wala nga koŋŋaa, wala nga hawoo, wala nga farkaa, wala haya kul kaŋ ti cinaa wane.» ");
INSERT INTO ses_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Jamaa kul maa jiŋjiŋyanoo, i dii nuune deeney, i maa hilloo jindoo, i dii tondi hondoo kaŋ ga dullu. Kaŋ jamaa dii wey, i jijiri, i kay nongu mooro ra. ");
INSERT INTO ses_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","I nee Musa se: «Šelaŋ ir se ni hunday, ir ga maa ma ne, amma Irkoy masi šelaŋ ir se hala ir masi koy buu.» ");
INSERT INTO ses_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musa nee jamaa se: «War masi hunbur, zama Irkoy nka kaa ka war sii, hala nga hunburaa ma bara war ra, war masi zunubu tee.» ");
INSERT INTO ses_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Jamaa kay nongu mooro ra. Musa man duula bibi tik kaŋ ra Irkoy cindi. ");
INSERT INTO ses_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Abadantaa nee Musa se: «Nee Izirayel borey se: ‹War hunday dii kaŋ beenaa ra ay goo kaŋ ay šelaŋ war bande. ");
INSERT INTO ses_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","War masi koy tee ay banda ga, war masʼa tee nda nzorfu kaaray, war masi koy tee war boŋ se nda wura.› ");
INSERT INTO ses_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Ma labu sargari tonadoo tee ka ni sargari kukurantey, nda ni alaafiya teendi sargarey, nda ni alman buuney sargari, nda ni alman beerey sargari kaa. Nongu kul kaŋ ra ay nʼay maaɲoo bayrandi, ay ga kaa ni do, ay ga albarka daŋ ni ra. ");
INSERT INTO ses_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Amma nda nʼna sargari tonadoo cin ya ne nda tondi, masʼa cin nda tondi kaŋ i na hoy. Zama nda nʼnʼi hoy nda guuru, nʼga sargari tonadogoo kaynandi. ");
INSERT INTO ses_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Masi dira tintim boŋ ka koy sargari tonadogoo ra, hala ni gaa koonoo masi koy fatta.» ");
INSERT INTO ses_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","«Hantumey kaŋ kayandi ne kaŋ mʼi daŋ i jine: ");
INSERT INTO ses_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","‹Nda nʼna Ebere tam day, a ma goy jiiri iddu, jiiri iyyantoo ra a ma hun ni do ka duu borcintaray bila nda a ma haya kul bana. ");
INSERT INTO ses_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Nda nga hinne ka huru ni do, a ga fatta nga hinne. Nda a gar a goo nda wande, nga nda wandoo ga fatta. ");
INSERT INTO ses_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Nda nga koyoo kʼa noo wande, de wandoo duu a se izʼaruyaŋ nda ize woyyaŋ, woyoo nda nga izey ga tee nga koyoo wane. Nga, a ga fatta nga hinne. ");
INSERT INTO ses_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Amma nda tamoo bayrandi ka nee: “Ay ga baa ay koyoo, nda ay wandoo, nda ay izey, ay si baa ya koy ka duu borcintaray.” ");
INSERT INTO ses_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Woo ra nga koyoo ga kate a Irkoy jine, a gʼa kayandi ganboo wala ganboo caraa ga, koyoo ga haŋaa fun nda sulba. Woo banda ga, a ga tee a se tam hala abada.› ");
INSERT INTO ses_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Nda mo, aru na nga ize woyoo neere sanda koŋŋa, a si hun koŋŋataraa ra sanda takaa kaŋ nda tamey ga hun. ");
INSERT INTO ses_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Nda woyoo si kan koyoo se, ka gar nga maaɲoo ga a goo, a mʼa naŋ a ma dayandi kʼa kaa kabe ra, a sii nda fondo kʼa neere dumi waani se, a nkʼa zanba. ");
INSERT INTO ses_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Nda a nʼa noo nga izʼaroo se, a ga alaadaa tee a se kaŋ ga teendi ize woy se. ");
INSERT INTO ses_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Nda a na ize woy foo zaa koyne nga boŋ se, a si kumandi ŋaahayaa, nda bankaaraa, nda gorokasinaa ra. ");
INSERT INTO ses_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Nda a si haya hinza woo tee a se, a ma hun a kone bila nda a ma nooru bana.» ");
INSERT INTO ses_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","«Boro kaŋ na boro kar kʼa wii, a waazibi boraa ma wiiyandi. ");
INSERT INTO ses_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Amma nda a mana muray kʼa wii, Irkoy alwaadoo no, ay ga nongu cebe ma ne kaŋ ra a ma zuru ka koy tugu. ");
INSERT INTO ses_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Nda boro na nga cinaa kabekunafutay kʼa wii nda carmay, ba boraa goo ay sargari tonadogoo ra, mʼa kaa no din hala i mʼa wii. ");
INSERT INTO ses_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Boro kaŋ na nga ɲaa wala nga baabaa kar, a waazibi boraa ma wiiyandi. ");
INSERT INTO ses_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Boro kaŋ na boro haamay, nda a na boraa neere wala a duwandi kaboo ra, a waazibi boraa ma wiiyandi. ");
INSERT INTO ses_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Boro kaŋ na nga ɲaa wala nga baabaa kaynandi, a waazibi boraa ma wiiyandi. ");
INSERT INTO ses_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Nda aruyaŋ yenje, de affoo na nga ceroo kar nda tondi wala a na nga kaboo kunkuni kʼa kar, amma boraa mana buu, a nka kaŋ, a maray. ");
INSERT INTO ses_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","Woo banda ga, nda a ga hin ka dibi gobu ga ka fatta taray, i si haya kul tee boraa se kaŋ nʼa kar, amma waatoo kaŋ a gʼa tee a si goy, boraa kaŋ nʼa maray gʼa bana, de mo a gʼa safar hala a ma duu baani. ");
INSERT INTO ses_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Nda boro na nga baɲɲaa wala nga koŋŋaa kar nda gobu hala a buu kaboo ra, a waazibi bukaa ma faasandi. ");
INSERT INTO ses_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Amma nda a huna zaari foo wala ihinka, bukaa si faasandi, zama nga almanoo no. ");
INSERT INTO ses_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Nda aruyaŋ gurgay, de i too alhaamidukoyni do, woo kate woyoo hay, albasi mana duu a, woo banda ga, woyoo kurɲoo ga hayaa har kaŋ arey mʼa bana. I gʼa bana ka sawa woo kaŋ ciitoo nʼa kayandi. ");
INSERT INTO ses_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Amma nda albasi tee, a ga hima ka banandi, hundi no ma hundi bana, ");
INSERT INTO ses_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","moo no ma moo bana, hiɲe no ma hiɲe bana, kabe no ma kabe bana, cee no ma cee bana, ");
INSERT INTO ses_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","tonyan no ma tonyan bana, maraydoo no ma maraydoo bana, žabari ndella no ma žabari ndella bana. ");
INSERT INTO ses_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Nda boro na nga baɲɲaa wala nga koŋŋaa kar moɲoo ga hala moɲoo hasara, a mʼa taŋ a ma borcin, moɲoo kaŋ hasara maaganda. ");
INSERT INTO ses_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Nda nga baɲɲaa wala nga koŋŋaa hiɲoo no a nʼa kaŋandi, a mʼa taŋ a ma borcin, hiɲoo kaŋ kaŋ maaganda. ");
INSERT INTO ses_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Nda haw na nga hilley ka aru wala woy kar hala a buu, hawoo ga warrandi nda tondi ka buu, hamoo si ŋandi, hawoo koyoo ga henan. ");
INSERT INTO ses_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Amma nda hawoo doona ka kara, de i na alhabar daŋ koyoo ra, amma a mana lakkal tee a se, de a na aru wala woy wii, hawoo ga warrandi nda tondi ka buu, koyoo mo ga wiiyandi. ");
INSERT INTO ses_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Nda i na zukandi daŋ hawoo koyoo ga, haya kul kaŋ i nʼa daŋ a ga, a gʼa bana nga hundoo dogoo ra. ");
INSERT INTO ses_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Nda hawoo na nga hilley ka zankaaru wala zankawoy kar kʼa wii, ašariya follokaa no ma zurandi a ga. ");
INSERT INTO ses_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Nda hawoo na baɲɲa wala koŋŋa kar kʼa wii, hawoo koyoo ga nzorfu kaaray tamma boŋ waranza (30) bana boraa se, hawoo ga warrandi nda tondi ka buu. ");
INSERT INTO ses_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Nda boro na nga guusoo naŋ a mana daabu, wala boro kaŋ na guusu fanši bila nda a mʼa daabu, nda haw wala farka kaŋ a ra, ");
INSERT INTO ses_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","guusoo koyoo gʼa bana, a ga nga hayoo alkadaroo bana adabbaa koyoo se, adabba bukaa ga tee guusoo koyoo wane. ");
INSERT INTO ses_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Nda boro hawoo na nga hilley ka boro tana hawoo kar hala a buu, hawoo kaŋ ga huna, i mʼa neere, i ma nooroo zamna. Haw bukaa mo i mʼa zamna. ");
INSERT INTO ses_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Amma nda borey ga bay kaŋ haw no kaŋ doona ka kara, ka gar koyoo mana lakkal tee a se, a ga waazibi a ga a ma haw bana hawoo dogoo ra, haw bukaa ma tee nga wane. ");
INSERT INTO ses_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","Nda boro na haw wala feeji zay, nda a nʼa koosu wala a nʼa neere, a ga haw guu bana hawoo dogoo ra, feeji taaci feejoo dogoo ra.» ");
INSERT INTO ses_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","«Nda zay diyandi kaboo goo jinaa ra, a karandi hala a buu, nga kuroo alhakoo si banandi. ");
INSERT INTO ses_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Amma nda a diyandi ka gar waynaa fatta, nga kuroo alhakoo ga banandi. A ga waazibi zayoo ga a ma bana, nda a sii nda haya kul, a ga neerandi nga zaytaraa maaganda. ");
INSERT INTO ses_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Nda adabbaa kaŋ a nʼa zay duwandi kaboo ra a ga huna, a ma tee haw, wala farka, wala feeji, a ga nga cine hinka bana.» ");
INSERT INTO ses_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","«Nda boro na nga adabbaa naŋ a ma ŋaa faari wala alaneb faari ra, nda a naŋ nga adabbaa ma ŋaa faari waani ra, a gʼa bana nda nga faaroo haya henney, wala nga alaneb faaroo haya henney. ");
INSERT INTO ses_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Nda nuune tun, de a koy karjiyaŋ kaŋ ga faari kuubi ka too jeeney do, wala alkama kaŋ ga kay, wala faari ton, boraa kaŋ na nuunaa diinandi, šikka sii a ga hayey bana kaŋ a nʼi ton. ");
INSERT INTO ses_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Nda boro na nooru wala jinay talfi boro ga, de i zayandi a do, nda zayoo duwandi, a ga nga cine hinka bana. ");
INSERT INTO ses_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Nda zayoo mana duwandi, hugoo koyoo ga kay Irkoy jine ka bayrandi kaŋ nga kaboo mana too nga cinaa almanoo do. ");
INSERT INTO ses_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Cere hooyan šenni kul, a ma tee haw, wala farka, wala feeji, wala bankaaray, wala haya kul kaŋ dere, de boro foo kul nee: ‹Agay wane›, ngi boro hinkaa ga koy Irkoy jine. Boraa kaŋ Irkoy dunbandi kaŋ a tooɲe ga hayaa cine hinka bana nga cinaa se. ");
INSERT INTO ses_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Nda boro na farka, wala haw, wala feeji, wala adabba dumi kul kaŋ no talfi nga cinaa ga, de adabbaa buu, wala nga nongu kayri, wala a zayandi bila seede, ");
INSERT INTO ses_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","boraa kaŋ ga i na adabbaa talfi ga žee Abadantaa maaɲoo ga kaŋ nga mana too adabbaa do. Almanoo koyoo ga yadda, boraa si bana. ");
INSERT INTO ses_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Amma nda cimi no kaŋ almanoo zayandi a ga, a gʼa bana koyoo se. ");
INSERT INTO ses_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Nda ganjihooga ka almanoo wii, a ga seedetaraa too, a si almanoo bana. ");
INSERT INTO ses_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Nda boro na alman hii nga cinaa ga, de nga nongu kayri wala a buu koyoo dumaa ga, a ga hima kʼa bana. ");
INSERT INTO ses_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Nda koyoo jinoo ra a tee, a sʼa bana. Nda a nka sufurayandi, sufuray hayoo de no a gʼa bana.» ");
INSERT INTO ses_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","«Nda aru na woy soogo kaŋ si aru bay kaŋ mana wirandi darga ka kani nda a, a waazibi a ga a ma nga hiijaa almanoo bana ka tee kurɲoo. ");
INSERT INTO ses_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Nda baaboo wanji kʼa noo a se, a ga nooru bana sanda woy soogo kaŋ si aru bay hiijaa almanoo. ");
INSERT INTO ses_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Cerkaw woy masi naŋ a ma huna. ");
INSERT INTO ses_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Boro kaŋ marga nda adabba, a waazibi a ma wiiyandi. ");
INSERT INTO ses_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Boro kaŋ na sargari kaa koy maa ga kaŋ manʼti Abadantaa hinne se, a waazibi i ma boraa halaci sõy. ");
INSERT INTO ses_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Masi yaw žilla wala kʼa torro, zama Misira gandaa ra war nka tee yaw. ");
INSERT INTO ses_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Masi woy kaŋ kurɲoo buu žilla, masi alyatim žilla. ");
INSERT INTO ses_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Nda nʼnʼi žilla, nda i tilasu ka kaati kʼay cee, šikka sii ay ga maa ngi kaatiroo se. ");
INSERT INTO ses_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Ay futuyanoo ga tun, ay ga war wii nda takuba. War wandey ga tee woyyaŋ kaŋ kurɲey buu, war izʼarey ga tee alyatim. ");
INSERT INTO ses_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Nda nʼna nooru garaw ay jamaa boro se, jaŋantaa kaŋ goo ni bande, masi borey kaŋ ga garaw noo takaa tee a se, masi albaha ceeci a ga. ");
INSERT INTO ses_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Nda a waazibi ma ni cinaa bankaaraa dii sanda tolme, mʼa yeeti a se za waynaa mana kaŋ. ");
INSERT INTO ses_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Zama woo din hinne ti nga gumtaafaa, nga bankaaraa kaŋ nda a ga nga kunturoo daabu. Macin nda a ga gum ka kani? Nda a tee a kaati kʼay cee, ay ga maa a se, zama agay, ay ga tamalla. ");
INSERT INTO ses_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Masi Irkoy kaynandi. Boŋkoyni kaŋ goo ni jamaa ra, masʼa danga. ");
INSERT INTO ses_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Masi gay mana baa kaa ya ne ni hegaa nda ni alaneb haroo ra. Mʼay noo ni izʼaru jinaa. ");
INSERT INTO ses_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Ma takaa din da tee ni alman beeroo nda ibuunaa se. A ma cindi ɲaŋoo bande jirbi iyye, jirbi yaahantoo hane, mʼa noo ya ne. ");
INSERT INTO ses_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","War ma tee boro henananteyaŋ ya ne: alman kaŋ ganjihooga nʼa wii saajoo ra, war masi hamoo ŋaa. War mʼa warra hanšey se.» ");
INSERT INTO ses_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","«Masi šenni kaŋ manʼti cimi ka dira. Masi seede bine konna tee ka boro kaŋ tooɲe faaba. ");
INSERT INTO ses_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Masi hanga jamaa bande kaŋ ga baa ngi ma ifutu tee. Ciiti ra, masi hanga jamaa bande za i ga boobo se ka šerretaraa šiirandi. ");
INSERT INTO ses_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Masi boro yalaafante ndumoo guna kʼa faaba ciiti ra. ");
INSERT INTO ses_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Nda ni kaŋ ni iberoo hawoo wala farkaa ga kaŋ dere, masi goro manʼa ka koy a do. ");
INSERT INTO ses_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Nda ni dii boro kaŋ ga konna ni farkaa ga gurfa jeejaa maaganda, masʼa naŋ, masi goro manʼa faaba jeejaa ra. ");
INSERT INTO ses_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Masi talka kaŋ goo ni jamaa ra cimoo taa a kone ciiti ra. ");
INSERT INTO ses_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Ma mooru haya kaŋ ti taari. Masi boro kaŋ mana haya kul tee wii, masi boro šerrante wii, zama tooɲante, ay sʼa dii boro šerrante. ");
INSERT INTO ses_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Masi sufuray taa, zama sufuraa mma diikey tee danaw, a ga šikka daŋ šerrantey ga. ");
INSERT INTO ses_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Masi yaw torro, war hunday ga yaw hunaroo bay, zama war tee yaw Misira gandaa ra.» ");
INSERT INTO ses_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","«Jiiri iddu ma ni laboo beeri, ma faari-izey hegay. ");
INSERT INTO ses_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Amma jiiri iyyantoo ga ma laboo naŋ a ma hunanzam. Ni jamaa talkey ga haya ŋaa kaŋ i duu a ra, woo kaŋ i gʼa naŋ ganjihoogawey gʼa ŋaa. Takaa din da no mʼa tee ni alaneb faaroo nda ni zaytuɲaŋoo se. ");
INSERT INTO ses_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Jirbi iddu goy kaŋ goo ma ne, mʼa tee, amma jirbi iyyantoo ma hunanzam, hala ni hawoo nda ni farkaa ma hunanzam, hala ni koŋŋaa izʼaroo nda ni yawoo ma hunsar. ");
INSERT INTO ses_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","War ma hayey dii henna kaŋ ay nʼi har war se, war masi koy tanayaŋ maaɲey cee, boro masi maa maaɲey ni miɲoo ra.» ");
INSERT INTO ses_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","«Cee hinza jiiroo ra ma jingar tee ay maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Ma Takulawey kaŋ ra dolobiri sii jingaroo kayandi. Jirbi iyye Abib handoo ra ma takula ŋaa kaŋ ra dolobiri sii sanda takaa kaŋ nda ay na ni yaamar. Zama handoo din ra ni fatta Misira. Boro si kaa ay jine kabe koonu. ");
INSERT INTO ses_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Ma Hegaa jingaroo kayandi, dumiyoo kaŋ nʼnʼa say faarey ra goyoo ize jina-jinawey no. Jiiroo benantaa ga, ma Faari-izey kaayanoo jingaroo tee waati kaŋ nʼna ni faarey goyey hegaa tee. ");
INSERT INTO ses_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Jiiroo ra cee hinza ni arey ma kay ni Koyoo, Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Sargaroo kuroo kaŋ nʼgʼa kaa, takula kaŋ ra dolobiri goo masi hanga a. Jingaroo hamoo maanoo masi cindi za cijinoo ra hala subbaahi. ");
INSERT INTO ses_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Ma kate ni faaroo ize jina-jinawey Abadantaa, ni Koyoo hugoo ra. Masi hancin-ize hina ɲaŋoo wawaa ra.» ");
INSERT INTO ses_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","«Nga ne, ay ga almalayka sanba ni jine, a ma ni hawgay naarumaa ra ka ni ka koy nongoo kaŋ ay nʼa hanse ma ne ra. ");
INSERT INTO ses_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","A beerandi, ma maa šennoo se, masʼa kakaw. A si war hooyanoo muɲe. Zama ay maaɲoo goo a ga. ");
INSERT INTO ses_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Nda nʼga maa šennoo se ka boori, de nʼga haya kul tee kaŋ ay gʼa har ma ne, ay ga tee ni iberey iberoo, ni yenjekey yenjekaa. ");
INSERT INTO ses_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Waati kaŋ ay almalaykaa huru ni jine ka ni ka koy Amor borey do, nda Heti borey do, nda Ferezi borey do, nda Kanaŋ borey do, nda Hewi borey do, nda Žebus borey do, ay gʼi derandi. ");
INSERT INTO ses_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Masi sujudu ngi koyey se, masʼi gana, masi ngi takawey tee. Mʼi warra ganda ka tondey kaŋ i nʼi kayandi kʼi gana kayri. ");
INSERT INTO ses_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","War ma Abadantaa, war Koyoo gana, a ga albarka daŋ war ŋaahayaa nda war haroo ra, de ay ga wirci moorandi ni ga. ");
INSERT INTO ses_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ni gandaa ra, gunde hasaraw si tee, woy si gun, ay ga ni noo aloomur. ");
INSERT INTO ses_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Ay gʼay hunburaa ka koy ni jine, jama kul kaŋ ra ni huru, ay ga lakkaloo ɲaami, de ay ga ni iberey kul zurandi ni jine. ");
INSERT INTO ses_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ay ga binbin laalayaŋ sanba ni jine, i ga Hewi borey, nda Kanaŋ borey, nda Heti borey gaaray ni jine. ");
INSERT INTO ses_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Ay sʼi gaaray ni jine jiiri folloku ra, gandaa masi koy tee farru koonu, ganjihoogawey masi koy boobo ka yee ni ga. ");
INSERT INTO ses_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ay gʼi gaaray ni jine kayna-kayna, waati kaŋ ni duu hayyan, gandaa ma yee ni mayray ra. ");
INSERT INTO ses_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Ay ga ni laboo kanjey kayandi Kakaarey teekoo ga ka koy Filisti borey teekoo nda saajoo ka koy Efrat isaa ga. Zama ay ga gandaa borey daŋ ni kaboo ra, de nʼgʼi gaaray ni jine. ");
INSERT INTO ses_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Amaana masi huru ni nda i game, a masi huru ni nda ngi koyey game. ");
INSERT INTO ses_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","I masi goro war gandaa ra hala i masi kaa ka koy war tusa war ma zunubu tee ay ga, zama woo ra ngi koyey no nʼgʼi gana, de a ga tee ma ne kumsay.» ");
INSERT INTO ses_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Abadantaa nee Musa se: «Žigi ka kaa ay do tondi hondoo boŋ, ni nda Haruna, nda Nadab, nda Abihu, nda Izirayel boro beerey ra, boro woyye (70), war ma sujudu ya ne nongu mooro ra. ");
INSERT INTO ses_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Musa hinne ma man kate ay do. I masi man kate, jamaa masi žigi kate a bande.» ");
INSERT INTO ses_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Musa koy Abadantaa šenney kul nda hantumey kaŋ kayandi kul har jamaa se. Jamaa tee jinde foo ka tuuru ka nee: «Šenney kul kaŋ Abadantaa nʼi har, ir gʼi tee.» ");
INSERT INTO ses_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Musa na Abadantaa šenney kul hantum. A tun subbaahi biya ka sargari tonadoo cin tondi hondoo cire, a na tondi woy cindi hinka (12) kayandi Izirayel alkabiila woy cindi hinkaa (12) maaɲey ga. ");
INSERT INTO ses_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","A na Izirayel aru soogoyaŋ sanba i ma koy sargari kukuranteyaŋ nda yaaruyaŋ sarga Abadantaa maaɲoo ga i ma tee alaafiya teendi sargaroo. ");
INSERT INTO ses_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Musa na kuroo jeroo zaa, a nʼa daŋ potiyaŋ ra, jere faa a nʼa say-say sargari tonadogoo ga. ");
INSERT INTO ses_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","A na amaanaa citaaboo zaa, a nʼa caw jamaa se. I nee: «Haya kul kaŋ Abadantaa nʼa har, ir ga haŋajer a se, ir ga dira nda a.» ");
INSERT INTO ses_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Musa na kuroo zaa, a nʼa say-say jamaa ga ka nee: «Amaanaa kaŋ Abadantaa nʼa daŋ war nda nga game šenney kaŋ a nʼi har here, amaanaa din kuroo ne.» ");
INSERT INTO ses_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Woo banda ga, Musa, nda Haruna, nda Nadab, nda Abihu, nda Izirayel boro beerey ra, boro woyye (70) žigi tondi hondoo boŋ. ");
INSERT INTO ses_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","I dii Izirayel Koyoo. Cewey cire, ni mma nee safir tondi kanante, nga henanyanoo ga hima nda beenaa zaati. ");
INSERT INTO ses_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Borey wey ti Izirayel boro kayantey, Irkoy mana nga kaboo šerre ka haya futu kul tee i se. I dii Irkoy, i ŋaa, i haŋ. ");
INSERT INTO ses_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Abadantaa nee Musa se: «Žigi ka kaa ay do tondi hondoo boŋ, ma cindi no din. Ay ga ni noo tondi walhawey, maanaa ašariyaa nda yaamaroo kaŋ ay nʼi hantum ka jamaa cawandi.» ");
INSERT INTO ses_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Musa tun, nga nda nga banda hunoo Žozuwe, Musa žigi Irkoy tondi hondoo boŋ. ");
INSERT INTO ses_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Za i mana koy, a nee boro beerey se: «Wa ir batu ne ra hala waati kaŋ ir willi kate war do. Nga ne, Haruna nda Hur goo war bande, boro kaŋ duu almušakka ma koy i do.» ");
INSERT INTO ses_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Musa žigi tondi hondoo boŋ, duulaa na hondoo daabu. ");
INSERT INTO ses_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Abadantaa daržaa cindi Sinay tondi hondoo boŋ, duulaa na Sinay tondi hondoo daabu jirbi iddu. Jirbi iyyantoo hane, a na Musa cee duulaa gundoo ra. ");
INSERT INTO ses_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Abadantaa daržaa tee Izirayel borey moɲey cire ma nee nuune kaŋ ga gona kaŋ ga dii tondi hondoo boŋoo ga. ");
INSERT INTO ses_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Musa huru duulaa gundoo ra ka žigi tondi hondoo boŋ. Musa cindi hondoo boŋ zaari woytaaci (40) nda cijin woytaaci (40). ");
INSERT INTO ses_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«Nee Izirayel borey se i ma baa kaa ya ne. Borey kul kaŋ kabey ga don, war mʼay bagaa dii i ga. ");
INSERT INTO ses_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Bagaa kaŋ war gʼa dii i ga manʼti kala: wura, nda nzorfu kaaray, nda alhan, ");
INSERT INTO ses_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","nda šukka bula, nda iciray henna, nda iciray zaram, nda šukka baana, nda hancin hinbiri, ");
INSERT INTO ses_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","nda gaaru kuuruyaŋ kaŋ cirayandi, nda ayu kuuruyaŋ, nda akasiya bundu, ");
INSERT INTO ses_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","nda jii fitilla gorodogoo se, nda haya hew kaanayaŋ yonyan jiyoo nda dugu hew kaanaa se. ");
INSERT INTO ses_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Oniks tondi nda tondi dumiyaŋ kaŋ ga huru beene kaayi-izoo nda albaytoo ra. ");
INSERT INTO ses_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","I ma nongu henanante cin ya ne hala ya goro i game. ");
INSERT INTO ses_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Ay ga Irkoy gorodogoo fasaloo cebe ma ne nda jinawey dumey kul kaŋ ga huru a ra. War mʼi kul tee ka sawa nda ngi fasaloo.» ");
INSERT INTO ses_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","«I ma sunduku cin nda akasiya bundu, nga kuuyanoo ma tee kabedaaru hinka nda jere, hayyanoo ma tee kabedaaru foo nda jere, nga kayyanoo kabedaaru foo nda jere. ");
INSERT INTO ses_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Mʼa daabu nda wura alhakiika, gundoo nda tarayheroo ma daabandi. Ma wura kunga daŋ miɲoo bande. ");
INSERT INTO ses_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ma wura mennandi ka korbay taaci tee kaŋ nʼgʼi daŋ cee taacaa ga, korbay hinka caraw foo ga, korbay hinka caraw faa ga. ");
INSERT INTO ses_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Ma akasiya bunduyaŋ tee gobu kʼi daabu nda wura. ");
INSERT INTO ses_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Ma gobey daŋ sundukoo caraw foo kul korbawey ra kʼa zaa. ");
INSERT INTO ses_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Gobey ma cindi sundukoo korbawey ra, i masi hun sundukoo ga. ");
INSERT INTO ses_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ma seedetaraa hantumoo kaŋ ay gʼa noo ma ne jisi sundukoo ra. ");
INSERT INTO ses_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Woo banda ga, ma daabirji tee nda wura alhakiika. Nga kuuyanoo ma tee kabedaaru hinka nda jere, hayyanoo ma tee kabedaaru foo nda jere. ");
INSERT INTO ses_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Ma almalayka hinka tee kaŋ se i ga nee šerib. Mʼi kar wura ra, mʼi daŋ daabirjoo boŋ hinkaa ga. ");
INSERT INTO ses_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Ma šerib foo tee boŋ foo ga, ma šerib foo tee boŋ faa ga. War ma šeribey tee daabirjoo hunday ra, daabirjoo boŋ hinkaa ga. ");
INSERT INTO ses_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Šeribey ma ngi fatawey hay beene, i ga ngi fatawey ka daabirjoo daabu. Ngi ndumey ma cere tenje, i ma daabirjoo guna. ");
INSERT INTO ses_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Ma daabirjoo fur sundukoo ga jina ma seedetaraa hantumoo kaŋ ay gʼa noo ma ne jisi sundukoo ra. ");
INSERT INTO ses_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","No din ra ay gʼay boŋ bayrandi ma ne, sundukoo daabirjoo se beene šerib hinkaa game kaŋ goo seedetaraa sundukoo boŋ, ay ga hayaa kul har ma ne kaŋ ay gʼa noo ma ne Izirayel borey se.» ");
INSERT INTO ses_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","«Ma taabal tee nda akasiya bundu, kuuyanoo ma tee kabedaaru hinka, hayyanoo ma tee kabedaaru foo, kayyanoo ma tee kabedaaru foo nda jere. ");
INSERT INTO ses_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Mʼa daabu nda wura alhakiika, ma wura kunga daŋ miɲoo bande. ");
INSERT INTO ses_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Ma jejebu tee kaŋ hayyanoo ga too kabetaami foo, ma wura kunga ka jejeboo kul kuubi kʼa bere. ");
INSERT INTO ses_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Ma wura korbay taaci tee a se, ma korbawey daŋ kanje taacaa ga kaŋ goo cee taacaa ga. ");
INSERT INTO ses_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Korbawey ma man jejeboo, ngi ra gobey ga huru ka taabaloo zaa. ");
INSERT INTO ses_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Ma akasiya bunduyaŋ tee gobu kʼi daabu nda wura ka taabaloo zaa. ");
INSERT INTO ses_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Ma nga taasawey, nda nga potey, nda nga jinawey, nda nga sargari-kaa-potey kaŋ nda sargari hari-harey ga doorandi tee. Mʼi tee nda wura alhakiika. ");
INSERT INTO ses_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Taabaloo ga, ma takulayaŋ daŋ kaŋ ga jisandi ay jine waati kul.» ");
INSERT INTO ses_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","«Ma fitilla gorodoo tee nda wura alhakiika. Fitilla gorodogoo ma karandi, cewoo, nda kunturoo, nda potey, nda nga dobey, nda nga kutukuryey ma tee a bande affoo. ");
INSERT INTO ses_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Kabe iddu ma fatta carawey ga, ihinza ma fatta fitilla gorodogoo caraw foo ga, ihinza ma fatta caraw faa ga. ");
INSERT INTO ses_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Kabe foo ga, poti hinza goo kaŋ ga hima nda tuuri-izoo kaŋ se i ga nee amand kaŋ ra dobu nda kutukurya goo. Kabe faa ga, poti hinza goo kaŋ ga hima nda amand kaŋ ra dobu nda kutukurya goo kabe hinkantoo ga. Takaa din da ti kabe idduwaa kaŋ ga fatta fitilla gorodogoo ga. ");
INSERT INTO ses_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Fitilla gorodogoo hunday ga poti taaci goo kaŋ ga hima nda amand kaŋ ra dobuyaŋ nda kutukuryayaŋ goo. ");
INSERT INTO ses_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Dobu foo goo kabe hinkaa jinaa cire kaŋ ga fatta kunturoo ga, dobu foo goo kabe hinkaa hinkantoo cire kaŋ ga fatta a ga, dobu foo goo kabe hinkaa hinzantoo cire kaŋ ga fatta a ga. Takaa din da a ma teendi kabe idduwaa se kaŋ ga fatta fitilla gorodogoo ga. ");
INSERT INTO ses_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Ngi dobey nda kabey ma tee kunturoo bande affoo, a kul ma tee goy kaŋ karandi nda wura alhakiika. ");
INSERT INTO ses_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Fitilla iyye tee a se, fitillawey ma daŋandi a ga, i ma gaay noo jinoo ra. ");
INSERT INTO ses_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Kanbey kaŋ ga fitillaa zaaraa boosoo dunbu nda dugu canbey ma tee nda wura alhakiika. ");
INSERT INTO ses_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Wura alhakiika kilo waranza (30) nda i ma nga nda jinawey din kul tee. ");
INSERT INTO ses_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Hawgay, mʼa tee sanda fasaloo kaŋ cebandi ma ne tondi hondoo boŋ.» ");
INSERT INTO ses_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","«Irkoy gorodogoo, mʼa tee nda kaymi taafe zuu woy (10) šukka baana yakuwante, nda ibula, nda iciray henna, nda iciray zaram. Ma almalaykayaŋ kaŋ se i ga nee šerib kay zuwey ga, a ma tee assana goykaw goy. ");
INSERT INTO ses_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Zuu foo kul kuuyanoo ma tee kabedaaru waranka cindi yaaha (28), hayyanoo ma tee kabedaaru taaci. Zuwey kul ma tee deede foo. ");
INSERT INTO ses_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Zuu guu ma huru cere ga, zuu guu faa mo ma huru cere ga. ");
INSERT INTO ses_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Ma karfuyaŋ kaŋ teendi nda šukka bula daŋ zuu guu margari jinaa zuu koraa miɲoo ga. Ma taka follokaa tee zuu guu margari hinkantoo zuu koraa miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Ma karfu woyguu (50) daŋ zuu guu jinaa ga, ma karfu woyguu (50) daŋ zuu guu hinkantoo zuu koraa miɲoo ga. Karfey ma cere tenje. ");
INSERT INTO ses_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Ma kanjihaya woyguu (50) tee nda wura, ma zuwey daŋ cere ga nda kanjihayey, a ma tee hukkum folloku. ");
INSERT INTO ses_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Woo banda ga, ma zuuyaŋ tee nda hancin hinbiri kaŋ ga tee hukkum kaŋ goo Irkoy gorodogoo ga. Zuwey ma tee iwoy cindi foo (11). ");
INSERT INTO ses_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Zuu foo kul kuuyanoo ma tee kabedaaru waranza (30), hayyanoo ma tee kabedaaru taaci. Zuu woy cindi faa (11) ma tee deede foo. ");
INSERT INTO ses_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Ma zuu guu marga cere ga, ma zuu iddu marga cere ga, ma zuu idduwantoo taabu hukkumoo jineheroo ga. ");
INSERT INTO ses_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Ma karfu woyguu (50) daŋ zuu guu margari jinaa zuu koraa miɲoo ga, ma karfu woyguu (50) daŋ zuu guu margari hinkantoo miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Ma kanjihaya woyguu (50) tee nda alhan, ma kanjihayey daŋ karfey ra ka hukkumoo daŋ cere ga hala a ma tee afolloku. ");
INSERT INTO ses_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Hayaa kaŋ ga cindi zuwey ra ga doo ganda, jeroo din kaŋ cindi ga doo Irkoy gorodogoo dumaa ga. ");
INSERT INTO ses_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Zuu guwaa kuuyanoo bande, kabedaaru foo ga doo Irkoy gorodogoo caraw hinkaa bande kʼa daabu. ");
INSERT INTO ses_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Gaaru kuuruyaŋ kaŋ cirayandi tee kunta kʼi gum hukkumoo ga. Kuntaa ga, ma kunta kaŋ teendi nda ayu kuuruyaŋ daŋ a ga. ");
INSERT INTO ses_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Woo banda ga, ma bundu tefayyaŋ kaŋ ga kay tee Irkoy gorodogoo se nda akasiya bundu. ");
INSERT INTO ses_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Bundu foo kul kuuyanoo ma tee kabedaaru woy (10), affoo kul hayyanoo ma tee kabedaaru foo nda jere. ");
INSERT INTO ses_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Bundu tefay hinka tee kaŋ ga cere tenje, affoo kul cee hinka ga dobu a ga, ma takaa din da tee Irkoy gorodogoo bundey kul se. ");
INSERT INTO ses_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Ma bundey wey tee Irkoy gorodogoo se, ma bundu waranka (20) tee gurma kaboo here. ");
INSERT INTO ses_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Ma nzorfu kaaray ka feraw woytaaci (40) kar kaŋyaŋ guusu goo i ra, i goo bundu tefay warankaa (20) cire, bundu foo kul cee hinkaa goo feraw hinka guusey ra. ");
INSERT INTO ses_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Irkoy gorodogoo caraw faa mo ma bundu tefay waranka (20) tee hawsa kaboo here, ");
INSERT INTO ses_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","nda ngi nzorfu kaaray feraw woytaacaa (40), feraw hinka ma huru bundu foo kul cire. ");
INSERT INTO ses_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Irkoy gorodogoo kuneheroo se, dangay kaboo here, ma bundu iddu tee a se. ");
INSERT INTO ses_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Irkoy gorodogoo kuneheroo ra, ma bundu hinka tee kanjey se. ");
INSERT INTO ses_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Gandaheroo goo cere ga, beeneheroo korbay gʼi dii cere ga henna, takaa din da no ihinkaa ga ti a kaŋ goo kanje hinkaa ga. ");
INSERT INTO ses_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Woo ra bundu tefay yaahaa nda ngi nzorfu kaaray ferawey goo, feraw woy cindi iddu (16) no, feraw hinka goo bundu foo kul cire. ");
INSERT INTO ses_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Woo banda ga, ma akasiya bundu tee gaaru-gaaruyaŋ, igguu Irkoy gorodogoo caraw foo bundu tefawey se. ");
INSERT INTO ses_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Igguu Irkoy gorodogoo caraw faa bundey se, igguu nga gorodogoo kuneheroo se kaŋ goo dangay caraa here. ");
INSERT INTO ses_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Gaaru-gaaroo kaŋ goo gamoo ra ma huru bundu tefawey kuuyanoo gamoo ra, a ma hun boŋ foo ga ka koy boŋ faa ga. ");
INSERT INTO ses_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Ma wura ka bundu tefawey daabu, ma korbawey tee nda wura kaŋ ga gaaru-gaarey dii, ma wura ka gaaru-gaarey daabu. ");
INSERT INTO ses_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Ma Irkoy gorodogoo cin kʼa kayandi nda hantumoo kaŋ kayandi, kaŋ harandi ma ne tondi hondoo boŋ. ");
INSERT INTO ses_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Ma rido tee nda šukka bula, nda iciray henna, nda iciray zaram, nda šukka baana yakuwante. Ma almalaykayaŋ kaŋ se i ga nee šerib kay a ga, a ma tee assana goykaw goy. ");
INSERT INTO ses_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Mʼa daŋ akasiya bundu ganji taaci ga kaŋ wura gʼi daabu, korbawey ma teendi nda wura, i ma huru nzorfu kaaray feraw taaci ra. ");
INSERT INTO ses_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Ma ridowoo daŋ kanjihayey cire, ridowoo dumaa ga ma seedetaraa sundukoo daŋ, ridowoo no ma huru nongu henanantaa nda nongu henanantey ihenanantaa game. ");
INSERT INTO ses_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Ma daabirjoo daŋ seedetaraa sundukoo ga nongu henanantey ihenanantaa ra. ");
INSERT INTO ses_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Ma taabaloo jisi ridowoo se tarayhere, ma fitilla gorodogoo daŋ taabaloo tenje, Irkoy gorodogoo se gurma kaboo here, ma taabaloo jisi hawsa here. ");
INSERT INTO ses_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Ma rido tee hukkumoo miɲoo se, a ma teendi nda šukka bula, nda iciray henna, nda iciray zaram, nda šukka baana yakuwante, maale kʼa kay. ");
INSERT INTO ses_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Ma akasiya ganji bundu guu tee ridowoo se, ma wura kʼi daabu, korbawey kaŋ gʼa dii ma teendi nda wura. Ma alhan mennandi ka feraw guu tee a se.» ");
INSERT INTO ses_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","«Ma sargari tonadogoo tee nda akasiya bundu, nga kuuyanoo ma tee kabedaaru guu, hayyanoo ma tee kabedaaru guu. Sargari tonadogoo caraw taacaa kul ma sawa. Nga kayyanoo ma tee kabedaaru hinza. ");
INSERT INTO ses_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ma hilliyaŋ tee nga kanje taacaa ra. Nga nda nga hilley kul ma tee affoo, mʼa daabu nda alhan. ");
INSERT INTO ses_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Ma barmayaŋ tee sargari tonadogoo boosey se, nda nga pelley, nda nga kusey, nda nga furšeti beerey, nda nga dugu canbey. Nga jinawey kul ma teendi nda alhan. ");
INSERT INTO ses_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Ma ham tonaguuru kaŋ ti alhan kaŋ ma nee sankay tee sargari tonadogoo se, ma alhan korbay taaci daŋ tonaguuroo kanjey ga. ");
INSERT INTO ses_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Mʼa daŋ sargari tonadogoo miɲoo cire, za gamoo ga hala ganda. ");
INSERT INTO ses_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Ma gobuyaŋ tee sargari tonadogoo se, i ma tee akasiya bundu gobuyaŋ, mʼi daabu nda alhan. ");
INSERT INTO ses_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Nga gobey ma huru korbawey ra, gobey ma huru sargari tonadogoo caraw hinkaa ga, i gʼa zaa. ");
INSERT INTO ses_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Mʼa tee nda bundu, gundoo koonoo no. Mʼa tee nda takaa kaŋ nda a cebandi ma ne tondi hondoo boŋ.» ");
INSERT INTO ses_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","«Ma Irkoy gorodogoo batumaa tee. Gurma kaboo here, kunta šukka baana yakuwanteyaŋ kaŋ ga too kabedaaru zangu (100) ma huru caraw foo ga. ");
INSERT INTO ses_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Ma batumaa ganji warankaa (20) nda nga feraw warankaa (20) tee a se nda alhan. Korbawey nda hawahayey ma teendi nda nzorfu kaaray. ");
INSERT INTO ses_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Hawsa kaboo here mo, kuntayaŋ ma huru a ga kaŋ kuuyanoo manʼti kala kabedaaru zangu (100). Ma ngi ganji warankaa (20) nda ngi alhan feraw warankaa (20) tee a se. Korbawey nda ngi hawahayey ma teendi nda nzorfu kaaray. ");
INSERT INTO ses_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Batumaa hayyanoo dangay kaboo here, kuntayaŋ kaŋ manʼti kala kabedaaru woyguu (50) ma huru a ga, ngi, nda ngi ganji woyaa (10), nda ngi cee woyaa (10). ");
INSERT INTO ses_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Batumaa hayyanoo dandi kaboo here, waynahunay kaboo ga, a ma tee kabedaaru woyguu (50). ");
INSERT INTO ses_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Kunta kabedaaru woy cindi guu (15) ma bara caraw foo ga, ngi, nda ngi ganji hinzaa, nda ngi feraw hinzaa. ");
INSERT INTO ses_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Caraw faa mo se, kuntayaŋ kaŋ manʼti kala kabedaaru woy cindi guu (15) ma huru a ga, ngi, nda ngi ganji hinzaa, nda ngi feraw hinzaa. ");
INSERT INTO ses_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Ma rido kaŋ goo nda kabedaaru waranka (20) daŋ batumaa miɲoo ga. A ma tee nda šukka bula, nda iciray henna, nda iciray zaram, nda šukka baana yakuwante, maale kʼa kay. A ma duu ganji taaci nda feraw taaci. ");
INSERT INTO ses_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Batumaa ganjey kul kaŋ gʼa kuubi, ngi hawahayey ma teendi nda nzorfu kaaray, ngi korbawey ma teendi nda nzorfu kaaray, ngi ferawey ma teendi nda alhan. ");
INSERT INTO ses_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Batumaa ma duu kabedaaru zangu (100) kuuyan, nda kabedaaru woyguu (50) hayyan, kayyanoo ma tee kabedaaru guu, zaaraa kaŋ gʼa kuubi kʼa bere manʼti kala nda šukka baana yakuwante, bundey ferawey ma tee nda alhan. ");
INSERT INTO ses_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Goy jinawey kul kaŋ ga alhaadimay Irkoy gorodogoo ra, nda Irkoy gorodogoo sukahayey, nda batumaa sukahayey kul ma teendi nda alhan.» ");
INSERT INTO ses_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","«Ni, ma Izirayel borey yaamar i ma kate ma ne fitilla gorodogoo se jii alhakiika kaŋ mana hun kala zaytu musayante ra, hala fitilla ma dii waati kul. ");
INSERT INTO ses_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Haruna nda nga izʼarey mʼa hanse cere kubayyan hukkumoo ra, ridowoo se tarayhere, seedetaraa sundukoo jine, hala a ma dii za cijinoo ra hala subbaahoo ra Abadantaa jine. Hantum kaŋ si tun no Izirayel borey alwaddawey se.» ");
INSERT INTO ses_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","«Ni, Haruna ni armaa manandi ni, nga nda nga izʼarey, Izirayel borey game, hala i ma sargari juwalkaw goyoo tee ya ne: Haruna nda nga izʼarey Nadab, nda Abihu, nda Eleyazar, nda Itamar. ");
INSERT INTO ses_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Ma bankaaray henananteyaŋ tee ni armaa Haruna se, i ma tee darža tammaasa nda taalam. ");
INSERT INTO ses_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ma šelaŋ boro lakkalkoyney kul se kaŋ ay nʼi too nda hundi lakkalkoyni, i ga bankaarayyaŋ tee Haruna se hala a ma yeetandi jere ga ya ne, hala a ma sargari juwalyan goyoo tee ya ne. ");
INSERT INTO ses_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Bankaarawey ne kaŋ i gʼi tee: albaytoo, nda beene kaayi-izoo, nda forkiya, nda darbay kaŋ kayandi, nda fatala, nda gamahaw, i ma bankaaray henananteyaŋ tee ni armaa Haruna se, nda nga izʼarey hala a ma sargari juwalyan goyoo tee ya ne. ");
INSERT INTO ses_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","I ma wura, nda šukka bula, nda iciray henna, nda iciray zaram, nda šukka baana yakuwante zaa ka bankaarawey tee. ");
INSERT INTO ses_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","I ma beene kaayi-izoo tee nda wura, nda šukka bula, nda iciray henna, nda iciray zaram, nda šukka baana yakuwante, a ma tee assana goykaw goy.» ");
INSERT INTO ses_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","«Beene kaayi-izoo beene mee hinkaa, karfu-ize hinka ma huru i ga kaŋ gʼi dii cere ga. ");
INSERT INTO ses_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Beene kaayi-izoo gamahawoo kaŋ ga huru a ga, ma goyandi nda taka follokaa: wura, nda šukka bula, nda iciray henna, nda iciray zaram, nda šukka baana yakuwante. ");
INSERT INTO ses_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Ma oniks tondi hinka zaa, ma Izirayel borey maaɲey hantum i ga. ");
INSERT INTO ses_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Ngi maa iddu ma huru tondi foo ga, maa iddu jerey ma huru tondi faa ga, ka sawa nda ngi hayandiroo jiirey. ");
INSERT INTO ses_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Tondi hinkaa ga, ma Izirayel borey maaɲey hantum nda takaa kaŋ nda boro kaŋ ga tondi hoy gʼa tee, sanda tammaasa kaŋ teendi tondi ra. Tondi hinkaa ma gorandi wura ga. ");
INSERT INTO ses_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Ma tondi hinkaa fur beene kaayi-izoo karfu-izey ga, i ma tee honganditondi Izirayel borey maaɲey ga. Maaɲey goo Haruna jese hinkaa ga, i ma tee hongandihaya Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Ma wura fasal ka tondi naagudooyaŋ tee ");
INSERT INTO ses_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","nda wura alhakiika šešeri hinka, i ma tee sanda karfuyaŋ kaŋ nka bibirandi. Ma wura šešeri bibirantey haw tondi naagudogey ga.» ");
INSERT INTO ses_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","«Ma albaytoo tee ciitoo se, a ma tee assana goykaw goy, a ma teendi nda beene kaayi-izoo takaa, mʼa tee nda wura, nda šukka bula, nda iciray henna, nda iciray zaram, nda šukka baana yakuwante. ");
INSERT INTO ses_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Caraw taacaa kul ma sawa, a ma taabandi ka tee ihinka, nga kuuyanoo ma tee kabetaami foo, nga hayyanoo ma tee kabetaami foo. ");
INSERT INTO ses_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Mʼa hanse nda tondi kaŋ gorandi haya ra, a ma tee tondi sorro taaci: sorro jinaa ma teendi nda sarduwan, nda topaz, nda emerod. ");
INSERT INTO ses_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Sorro hinkantoo ma teendi nda tirkuwaz, nda safir, nda luulu. ");
INSERT INTO ses_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Sorro hinzantoo ma teendi nda opal, nda agat, nda ametist. ");
INSERT INTO ses_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Sorro taacantoo ma teendi nda krisolit, nda oniks, nda žasp. Tondey wey ma gorandi ngi wura naagudogey ra. ");
INSERT INTO ses_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Tondey ma sawa nda Izirayel borey maaɲey, i ma tee iwoy cindi hinka (12) sanda ngi maaɲey. Maaɲey ma žeerandi i ga sanda tammaasa, affoo kul nda nga maaɲoo, zama alkabiila woy cindi hinka (12) no. ");
INSERT INTO ses_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Ma wura alhakiika šešeri kaŋ teendi sanda karfu bibiranteyaŋ daŋ albaytoo ga. ");
INSERT INTO ses_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Ma wura korbay hinka daŋ albaytoo ga, ma korbay hinkaa woo daŋ albaytoo kanje hinkaa ga. ");
INSERT INTO ses_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Ma wura karfu hinkaa daŋ korbay hinkaa ga kaŋ goo albaytoo kanjey ga. ");
INSERT INTO ses_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Ma karfu boŋ hinkaa haw tondi naagudoo hinkaa ga kʼi haw beene kaayi-izoo karfu-izey ga jineheroo ga. ");
INSERT INTO ses_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Ma wura korbay hinka tana tee kaŋ mʼi daŋ albaytoo kanje hinkaa ga, miɲoo ga beene kaayi-izoo gundoo ra. ");
INSERT INTO ses_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Ma wura korbay hinka tana tee koyne mʼi haw beene kaayi-izoo karfu-izey ga ganda, jinehere nongoo kaŋ ga i ga hawa jeroo ga, beene kaayi-izoo gamahawoo se beene. ");
INSERT INTO ses_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","I ma karfu bula ka albaytoo korbawey dii beene kaayi-izoo waney ga hala albaytoo ma cindi beene kaayi-izoo gamahawoo ga, albaytoo masi hun dogoo ra beene kaayi-izoo ga. ");
INSERT INTO ses_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Waati kaŋ Haruna ga huru nongu henanantaa ra, gandey ga ciitoo albaytoo goo kaŋ ga Izirayel borey maaɲey goo. Takaa woo ra a gʼi daŋ Abadantaa jine sanda hongandihaya hala abada. ");
INSERT INTO ses_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ma alkurraa goy jinawey kaŋ ti Urim nda Tumim jisi ciitoo albaytoo ra, hala i ma bara Haruna gandey ga waati kaŋ a ga huru ka kay Abadantaa jine. Izirayel borey ciitoo ga cindi Haruna gandey ga Abadantaa jine hala abada.» ");
INSERT INTO ses_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","«Woo banda ga, ma forkiyaa tee kaŋ ga huru beene kaayi-izoo cire, a kul ma teendi nda šukka bula. ");
INSERT INTO ses_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Fun kaŋ ga tee jinde ga hun gamoo ra, funoo miɲoo bande kunga ma huru, maale kʼa kay, woo ga tee a se sanda guuru darbay jinde hala a masi kottu. ");
INSERT INTO ses_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Forkiyaa gandahere miɲoo ga, ma grenad-ize šukkayaŋ, ibula, nda iciray henna, nda iciray zaram daŋ, ma wura guuru-izeyaŋ kaŋ ga hẽe daŋ i game miɲoo kul bande. ");
INSERT INTO ses_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Wura guuru-ize foo, grenad-ize foo, wura guuru-ize foo, grenad-ize foo, forkiyaa miɲoo kul bande. ");
INSERT INTO ses_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Haruna gʼa daŋ waati kaŋ a ga nga goyoo tee. Boro ga maa guuru-izey hẽenoo waati kaŋ a ga huru nongu henanantaa ra Abadantaa jine, nda waati kaŋ a ga fatta hala a masi koy buu. ");
INSERT INTO ses_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Woo banda ga, ma wura alhakiika teɲa taalam tee, ma žeeri ka hantum a ra sanda tammaasa kaŋ ga nee: ‹A yeetandi jere ga Abadantaa se.› ");
INSERT INTO ses_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Ma teɲa taalamoo daŋ nda karfu bula fatalaa ga, a ma huru fatalaa jineheroo ga. ");
INSERT INTO ses_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","A ma huru Haruna teɲaa ga. Zunubey kaŋ Izirayel borey gʼi tee haya henanantey kaayanoo ra, Haruna gʼi jeeje nga ga. Woo maaganda se ay ga yadda Izirayel borey sargari henanantey ga kaŋ i gʼi kaa ya ne. Teɲa taalamoo ma cindi teɲaa ga hala Abadantaa ma ngi sargarey taa. ");
INSERT INTO ses_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Ma šukka baana ka darbay beeroo tee. Ma fatala tee nda šukka baana. Ma gamahaw tee kaŋ maale kʼa kay. ");
INSERT INTO ses_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Ma darbay beeriyaŋ tee Haruna izʼarey se, ma gamahawyaŋ tee i se, ma fuulayaŋ tee i se, i ma tee darža nda beeray tammaasa. ");
INSERT INTO ses_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Ma darbawey daŋ ni armaa Haruna nda nga izʼarey ga, mʼi yon, mʼi gorandi goyoo ra, mʼi yeeti jere ga ya ne, hala i ma sargari juwalkaw goyoo tee ya ne. ");
INSERT INTO ses_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Ma leŋ šukka npogoyaŋ tee i se hala i masi gaa koonu, a mʼi dii centey ga ka koy ceehamey ga. ");
INSERT INTO ses_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Haruna nda nga izʼarey gʼi daŋ waati kaŋ i ga huru cere kubayyan hukkumoo ra wala ka too sargari tonadogoo ra waati kaŋ i ga ngi sargari juwalyan goyoo tee nongu henanantaa ra. Woo ra i si zunubu zaa, i si buu. Hantum kaŋ si tun no nga nda nga hayroo se nga dumaa ga.» ");
INSERT INTO ses_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","«Takaa ne kaŋ nʼgʼa tee ka Haruna nda nga izʼarey yeeti jere ga hala i ma sargari juwalkaw goyoo tee ya ne: ma yaaru foo zaa, nda gaaru hinka kaŋ ga malal sii, ");
INSERT INTO ses_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ma takula zaa kaŋ ra dolobiri sii, nda wijilayaŋ kaŋ ra dolobiri sii kaŋ loobandi nda jii, nda furmeyaŋ kaŋ ra dolobiri sii kaŋ yonandi nda jii. Mʼi tee nda alkama farin hamni. ");
INSERT INTO ses_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Mʼi daŋ dika ra, ma dikaa, nda yaaroo, nda gaarey kaa sargari. ");
INSERT INTO ses_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Ma Haruna nda nga izʼarey ka koy cere kubayyan hukkumoo miɲoo ga, mʼi ɲumay nda hari. ");
INSERT INTO ses_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Ma darbawey zaa, ma darbay beeroo daŋ Haruna ga, forkiyaa kaŋ goo beene kaayi-izoo cire, nda beene kaayi-izoo, nda albaytoo, ma gamoo haw nda beene kaayi-izoo gamahawoo. ");
INSERT INTO ses_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Ma fatalaa didiji boŋoo ga, ma teɲa taalam henanantaa daŋ fatalaa ga. ");
INSERT INTO ses_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Woo banda ga, ma yonyan jiyoo zaa kʼa mun boŋoo ga kʼa yon. ");
INSERT INTO ses_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Ma Haruna izʼarey manandi, ma darbawey daŋ i ga. ");
INSERT INTO ses_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Ma gamey haw nda gamahawoo, Haruna nda nga izʼarey ma fuula daŋ i ga. Sargari juwalkawtaraa ga tee ngi wane, a ga tee hantum kaŋ si tun, ma Haruna nda nga izʼarey gorandi goyoo ra. ");
INSERT INTO ses_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Ma yaaroo ka koy cere kubayyan hukkumoo jine, Haruna nda nga izʼarey ga ngi kabey fur boŋoo ga. ");
INSERT INTO ses_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Ma yaaroo koosu Abadantaa jine, cere kubayyan hukkumoo miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Ma zaa yaaroo kuroo ra, mʼa daŋ sargari tonadogoo hilley ga nda ni kabe-izoo, ma kuroo cindoo kul doori sargari tonadogoo gandahere. ");
INSERT INTO ses_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Ma maanoo kul zaa kaŋ ga teeley daabu, nda tasa-izoo kaŋ goo tasaa ga, nda dumay-ɲaa-guuri hinkaa, nda maanoo kaŋ goo i ga. Mʼi kul dullandi sargari tonadogoo ga. ");
INSERT INTO ses_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Ma yaaroo hamoo, nda kuuroo, nda nga teeley žiibey, mʼi ton jamaa kaloo se taray. Zunubu sargari no. ");
INSERT INTO ses_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Ma gaaru jinaa zaa, Haruna nda nga izʼarey ma ngi kabey fur boŋoo ga. ");
INSERT INTO ses_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Ma gaaroo koosu, ma kuroo zaa kʼa say-say sargari tonadogoo carawey bande. ");
INSERT INTO ses_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Ma gaaroo dunbu nongu-nongu. Ma teeley nda kobsey ɲumay kʼi fur nongey nda boŋoo boŋ. ");
INSERT INTO ses_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Ma gaaroo kul dullandi sargari tonadogoo boŋ, sargari kukurante no Abadantaa se, sunnaara kaana, sargari tonante no Abadantaa se. ");
INSERT INTO ses_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Ma gaaru hinkantoo zaa, Haruna nda nga izʼarey ma kabey fur gaaroo boŋoo ga. ");
INSERT INTO ses_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Ma gaaroo koosu, ma zaa kuroo ra kʼa daŋ Haruna haŋa gumaa deenoo ga nda nga izʼarey haŋa gumaa deeney ga, ma daŋ kabe gumaa kobaaroo ga, nda cee gumaa cew-ize beeroo ga. Ma kuroo say-say sargari tonadogoo carawey bande. ");
INSERT INTO ses_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Ma zaa kuroo ra kaŋ goo sargari tonadogoo ga, ma zaa yonyan jiyoo ra kʼi say-say Haruna nda nga darbawey ga, nda nga izʼarey ga nda ngi darbawey ga. A ga daŋandi jere ga ya ne, nga nda nga darbawey, nda nga izʼarey nda ngi darbawey. ");
INSERT INTO ses_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Ma gaaroo maanoo zaa, nda šuwalaa, nda maanoo kaŋ ga teeley daabu, nda tasa-izoo, nda dumay-ɲaa-guuri hinkaa nda maanoo kaŋ goo i ga, nda cee gumaa, zama sargari no kaŋ ga teendi sargari juwalkey gorandiyanoo goyoo ra se. ");
INSERT INTO ses_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Ma takula zaa, nda wijila, nda furme takulawey kaŋ ra dolobiri sii dikaa ra kaŋ goo Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Mʼi kul daŋ Haruna kabey ra nda nga izʼarey kabey ra, mʼi zinji sanda sargari zinji-zinjante Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Mʼa taa kabey ra kʼa dullandi sargari tonadogoo boŋ, sargari kukurantaa boŋ, a ma tee sunnaara kaana Abadantaa se. Sargari tonante no Abadantaa se. ");
INSERT INTO ses_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Ma Haruna gorandiyanoo goyoo ra gaaroo gandoo zaa kʼa zinji kʼa tee sargari zinji-zinjante Abadantaa jine. A ga tee ni bagaa. ");
INSERT INTO ses_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Ma gaaroo gandoo kaŋ tee sargari zinji-zinjante nda cewoo kaŋ jerandi yeeti jere ga ya ne. Nongey wey kul mana hun kala sargaroo kaŋ i nʼa kaa Haruna nda nga izʼarey gorandiyanoo goyoo ra se. ");
INSERT INTO ses_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","A ma tee Haruna nda nga izʼarey wane, a ma tee hantum kaŋ si tun Izirayel borey do. Sargari no kaŋ ga jer Abadantaa maaɲoo ga kaŋ hun ngi alaafiya teendi sargarey ra. ");
INSERT INTO ses_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Haruna dumaa ga bankaaray henanantey ga tee izʼarey waney, hala i mʼi daŋ ka yonandi nda ka yeetandi jere ga goyoo se. ");
INSERT INTO ses_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Izʼarey ra, woo kaŋ ga huru dogoo ra ga bankaarawey daŋ jirbi iyye, boraa kaŋ ga huru cere kubayyan hukkumoo ra ka goyoo tee nongu henanantaa ra. ");
INSERT INTO ses_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Ma gorandiyanoo goyoo ra gaaroo zaa, ma hamoo hina nongu henanante ra. ");
INSERT INTO ses_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Haruna nda nga izʼarey ma gaaroo hamoo nda takulaa kaŋ goo dikaa ra ŋaa cere kubayyan hukkumoo miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","I ma hayey ŋaa kaŋ nda zunubu tuusuyanoo teendi, ngi gorandiyanoo goyoo ra se nda ngi yeetiyanoo jere ga ya ne. Boro tana kul masʼi ŋaa, zama haya henananteyaŋ no. ");
INSERT INTO ses_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Nda haya cindi gorandiyanoo goyoo ra hamoo wala takulaa ra hala suba, mʼa ton nuune ra kʼa tee boosu. A masi ŋandi, zama haya henanante no. ");
INSERT INTO ses_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Takaa woo no nʼgʼa tee Haruna nda nga izʼarey se, sanda takaa kaŋ nda ay na ni yaamar. Jirbi iyye no nʼgʼa tee ngi gorandiyanoo goyoo ra. ");
INSERT INTO ses_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Zaari kul ma yaaru kaa zunubu sargari, zunubu tuusuyanoo se. Ma sargari tonadogoo henanandi ka zunubu tuusuyanoo tee a se, woo banda ga, mʼa yon kʼa yeeti jere ga ya ne. ");
INSERT INTO ses_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Jirbi iyye ma zunubu tuusuyanoo tee sargari tonadogoo se kʼa yeeti jere ga ya ne, sargari tonadogoo ga tee nongu kaŋ ga hanse ka henan. Haya kul kaŋ too sargari tonadogoo ga, ga henan.» ");
INSERT INTO ses_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","«Hayaa kaŋ nʼgʼa sarga sargari tonadogoo boŋ manʼti kala: feeji-ize hinka kaŋ goo nda jiiri foo. Zaari kul, han kul mʼa tee. ");
INSERT INTO ses_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Ma feeji-ize jinaa kaa subbaahi, ma ihinkantoo kaa almaari. ");
INSERT INTO ses_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Koyne mo feeji-ize jinaa bande ma farin hamni kilo hinza loobu nda jii liitar foo nda jere kaŋ mana hun kala zaytu musayante ra nda alaneb hari moora liitar foo nda jere sanda sargari hari-hari. ");
INSERT INTO ses_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ma feeji hinkantoo kaa almaari. Mʼa kaa sanda takaa kaŋ nda nʼga subbaahi taasu sargaroo kaa, nda sargari hari-hari follokaa, sunnaara kaana sargari tonante no Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","War masi fay nda ka sargari kukurantey wey kaa Abadantaa jine cere kubayyan hukkumoo miɲoo ga war alwaddawey ra, nongoo kaŋ ra ay ga war kubay ka šelaŋ ma ne. ");
INSERT INTO ses_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","No din ra ay ga Izirayel borey kubay, ay daržaa ga hukkumoo yeeti jere ga ya ne. ");
INSERT INTO ses_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Ay ga cere kubayyan hukkumoo nda sargari tonadogoo yeeti jere ga ya ne. Ay ga Haruna nda nga izʼarey yeeti jere ga ya ne hala i ma sargari juwalkaw goyoo tee ya ne. ");
INSERT INTO ses_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ay ga goro Izirayel borey game, ay ga tee ngi Koyoo. ");
INSERT INTO ses_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Woo ra i ga bay kaŋ agay ti Abadantaa, ngi Koyoo kaŋ nʼi fattandi Misira gandaa ra hala ya duu ka goro i game, agay kaŋ ti Abadantaa, ngi Koyoo.» ");
INSERT INTO ses_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","«Ma sargari tonadoo tee kaŋ ga nʼga dugoo dullandi. Mʼa tee nda akasiya bundu. ");
INSERT INTO ses_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Kuuyanoo ma tee kabedaaru foo, hayyanoo ma tee kabedaaru foo, caraw taacaa kul ma sawa. Nga kayyanoo ma tee kabedaaru hinka. Nga nda nga hilley kul ma tee affoo. ");
INSERT INTO ses_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ma sargari tonadogoo kul daabu nda wura alhakiika, beeneheroo, nda carawey kuubi-ka-beraa, nda hilley. Ma wura kunga daŋ miɲoo bande. ");
INSERT INTO ses_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Ma wura korbay hinka daŋ kungaa cire. Mʼi daŋ caraw hinkaa ga kabe hinkaa ga kaŋ ra gobey kaŋ nda i gʼa zaa ga huru. ");
INSERT INTO ses_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Ma akasiya bunduyaŋ tee gobu kʼi daabu nda wura. ");
INSERT INTO ses_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ma sargari tonadogoo daŋ ridowoo tenje kaŋ goo seedetaraa sundukoo jine, a ma tenje nda sundukoo daabirjoo kaŋ goo seedetaraa boŋ, nongoo kaŋ ra ay ga ni kubay. ");
INSERT INTO ses_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Haruna ma dugu hew kaana dullandi. Subbaahi ka kaa subbaahi, waati kaŋ a koy fitillawey soolu, nga no a mʼa dullandi a ga. ");
INSERT INTO ses_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Almaari kul, nda Haruna koy fitillawey diinandi no a ga dugoo dullandi. Dugoo no kaŋ ga cindi Abadantaa jine war alwaddawey se. ");
INSERT INTO ses_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","War masi dugu tana dullandi a ga, war masi sargari kukurante kaa a ga, war masi taasu sargari kaa a ga, war masi sargari hari-hari doori a ga. ");
INSERT INTO ses_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Haruna ga zunubu tuusuyanoo tee nga hilley ga cee foo jiiroo ra nda zunubu sargaroo kuroo. Cee foo jiiroo ra no a ga zunubu tuusuyanoo tee a ga. A ma alaadaa woo tee war alwaddawey ra. Dugu dullandidogoo manʼti kala haya kaŋ ga hanse ka henan Abadantaa se.» ");
INSERT INTO ses_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","«Waati kaŋ nʼna Izirayel borey kabu ka ngi hinnaa bay, affoo kul ga haya bana Abadantaa se nga hundoo hayoo se, hala waati kaŋ nʼga kabuyanoo tee bone masi duu ey. ");
INSERT INTO ses_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Hayaa ne kaŋ borey kul kaŋ ga kabandi gʼa bana: Nzorfu kaaray tamma jere ka sawa nda nongu henanantaa nzorfu kaaray tammaa alkadaroo. Nzorfu kaaray tamma foo manʼti kala garam woy cindi hinka (12). Nzorfu kaaray tamma jeraa ma tee haya kaŋ kaandi Abadantaa se. ");
INSERT INTO ses_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Boro kul kaŋ kabandi kaŋ goo nda jiiri waranka (20) nda ka žigi, ga hinnaa woo kaa Abadantaa se sanda baa. ");
INSERT INTO ses_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Almankoyni si haya noo kaŋ bisa nzorfu kaaray tamma jere, talka si haya noo kaŋ kacca nda nzorfu kaaray tamma jere waati kaŋ war ga hinnaa woo kaa Abadantaa se sanda baa hala war ma war hundey hallasi. ");
INSERT INTO ses_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Ma nooroo dii Izirayel borey ga, mʼa noo cere kubayyan hukkumoo goyoo se. Abadantaa jine a ga tee hongandihaya Izirayel borey se, hala a ma war hundey hallasi.» ");
INSERT INTO ses_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","«Ma alhan taasa beeri tee, nda nga hayaa kaŋ ga a ga goro ma tee nda alhan, alwala jinay no. Mʼa daŋ cere kubayyan hukkumoo nda sargari tonadogoo game. Ma hari daŋ a ra. ");
INSERT INTO ses_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Haruna nda nga izʼarey ga ngi kabey nda ngi cewey ɲumay a ra. ");
INSERT INTO ses_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Waati kaŋ i ga huru cere kubayyan hukkumoo ra, i ga hari ka ɲumay hala i masi duu ka buu, wala waati kaŋ i man sargari tonadogoo do ka ngi goyoo tee kaŋ ti ka sargari tonante dullandi Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","I ga ngi kabey nda ngi cewey ɲumay hala i masi duu ka buu. Hantum kaŋ si tun no i se, Haruna nda nga hayroo se ngi alwaddawey ra.» ");
INSERT INTO ses_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","«Ni, haya hew kaana alhakiikayaŋ zaa kaŋ ti: mir hari-hari kilo guu, alkalfa hew kaana kilo hinka nda jere, waakonde hew kaana kilo hinka nda jere. ");
INSERT INTO ses_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","Nda kas hew kaana kilo iddu ka sawa nda nongu henanantaa nzorfu kaaray tammaa alkadaroo, nda zaytu jii liitar iddu. ");
INSERT INTO ses_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Ma hayey wey ɲaami kʼi hanse i ma tee jii yonyan henanantaa se, a ma tee turaari teekaw goy. A ga tee jii yonyan henanantaa se. ");
INSERT INTO ses_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Mʼa ka cere kubayyan hukkumoo yon, nga nda seedetaraa sundukoo, ");
INSERT INTO ses_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","nda taabaloo nda nga jinawey kul, nda fitilla gorodogoo nda nga jinawey kul, nda dugu dullandidogoo, ");
INSERT INTO ses_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","nda sargari kukurantey tonadogoo nda nga jinawey kul, nda taasa beeroo nda hayaa kaŋ ga a ga goro. ");
INSERT INTO ses_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Ma hayey wey yeeti jere ga ya ne, i ga tee hayayaŋ kaŋ ga hanse ka henan. Haya kul kaŋ tuku i ga, ga henan. ");
INSERT INTO ses_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Ma Haruna nda nga izʼarey yon, mʼi yeeti jere ga ya ne, hala i ma sargari juwalkaw goyoo tee ya ne.» ");
INSERT INTO ses_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","«Nee Izirayel borey se: ‹Woo manʼti kala yonyan henanantaa jiyoo kaŋ jisandi ya ne war alwaddawey se. ");
INSERT INTO ses_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","A masi doorandi boro kul gaahamoo ga, boro kul masi nga dumoo tee, a ga henan, a ga tee war se haya henanante. ");
INSERT INTO ses_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Boro kul kaŋ na nga dumoo tee kʼa daŋ boro tana ga, boraa ga hun nga jamaa ra.›» ");
INSERT INTO ses_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Abadantaa nee Musa se: «Dugu hew kaaney zaa kaŋ ti: storaks, nda jingam hew kaana, nda galbanum hew kaana, nda dugu alhakiika, i kul tiŋyaney ma sawa. ");
INSERT INTO ses_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Mʼi tee dugu ɲaamante, turaari teekaw goy, ciiri-ciirante, a ga henan, a yeetandi jere ga ya ne. ");
INSERT INTO ses_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Ma haya tee a ra hamni kaŋ ga huru cere kubayyan hukkumoo ra, seedetaraa sundukoo jine, nongoo kaŋ ra ay ga ni kubay, war se haya no kaŋ ga hanse ka henan. ");
INSERT INTO ses_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Haya kaŋ ti dugoo woo, war masi nga dumoo hanse war boŋ se, a ma tee ma ne haya henanante Abadantaa se. ");
INSERT INTO ses_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Boro kaŋ na nga dumoo tee ka maa hewoo, boraa ga hun nga jamaa ra.» ");
INSERT INTO ses_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«Nga ne, ay na Besalel cee nda nga maaɲoo, Uri izʼaroo no, Hur haamaa, Žuda alkabiilaa boro no. ");
INSERT INTO ses_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Ay nʼa too met nda Irkoy Hundoo, nda lakkal, nda bayray, nda goy fahamay dumi kul. ");
INSERT INTO ses_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","A ga wan ka haya taagayaŋ fattandi, wura goyyan ra, nda nzorfu, nda alhan. ");
INSERT INTO ses_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","A ga wan ka tondi hoy kʼa caara kʼa gorandi haya ra, ka bundu goy, ka haya dumi kul tee. ");
INSERT INTO ses_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Nga ne, agay, ay na Oholiyab, Ahisamak izʼaroo, Dan alkabiilaa boro tonton a ga. Bayraykoyni kul, ay na bayray daŋ binoo ra. Hayey kul kaŋ nda ay na ni yaamar i mʼi tee kaŋ ti: ");
INSERT INTO ses_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","cere kubayyan hukkumoo, nda seedetaraa sundukoo, nda sundukoo daabirjoo kaŋ goo a boŋ, nda hukkumoo jinawey kul, ");
INSERT INTO ses_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","nda taabaloo nda nga jinawey kul, nda fitilla gorodoo henanantaa nda nga jinawey kul, nda dugu dullandidogoo, ");
INSERT INTO ses_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","nda sargari kukurantey tonadogoo nda nga jinawey kul, nda taasa beeroo nda hayaa kaŋ ga a ga goro, ");
INSERT INTO ses_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","nda bankaaray cere-cerantey, nda sargari juwalkaa Haruna bankaaray henanantey, nda nga izʼarey bankaarawey kaŋ nda i ga sargari juwalyan goyoo tee, ");
INSERT INTO ses_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","nda yonyan jiyoo, nda dugu hew kaana kaŋ ga teendi nongu henanantaa se. I gʼa tee nda takaa kul kaŋ nda ay na ni yaamar.» ");
INSERT INTO ses_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«Ni, šelaŋ Izirayel borey se ka nee: ‹War ma hanse ka hunanzamzaarey beerandi. Tammaasa no agay nda war game war alwaddawey se, hala borey ma bay kaŋ agay ti Abadantaa kaŋ ga war henanandi. ");
INSERT INTO ses_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Adiši war ma hunanzamzaaroo beerandi, zama zaari henanante no war se. Boro kaŋ nʼa kaynandi, a waazibi boraa ma wiiyandi. Boro kul kaŋ na goy tee hanoo din, boraa din ga hun nga jamaa ra.› ");
INSERT INTO ses_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Jirbi iddu goy ma teendi, iyyantoo manʼti kala hunanzamzaaroo. Hunanzamzaaroo manʼti kala zaari henanante Abadantaa maaɲoo ga kaŋ ra boro ga hunanzam. Boro kul kaŋ na goy tee hunanzamzaaroo hane, a waazibi boraa ma wiiyandi. ");
INSERT INTO ses_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Izirayel borey ma hunanzamzaaroo beerandi. I ma hunanzamzaaroo tee ngi alwaddawey ra. A ma tee amaana abadante. ");
INSERT INTO ses_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Zaaroo din ga tee tammaasa kaŋ goo agay nda Izirayel borey game hala abada. Zama jirbi iddu ra Abadantaa na beenaa nda laboo tee, jirbi iyyantoo ra a hunanzam, a na nga faraa kaa.» ");
INSERT INTO ses_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Waatoo kaŋ a šelaŋ ka ben Musa bande Sinay tondi hondoo ga, a nʼa noo seedetaraa walha hinkaa, tondi walhawey kaŋ Irkoy nʼi hantum nda nga kabe-izoo. ");
INSERT INTO ses_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Waatoo kaŋ Izirayel borey dii kaŋ Musa gay a mana zunbu tondi hondoo boŋ, jamaa marga Haruna jere ka nee a se: «Tun ma koyyaŋ tee ir se kaŋ ga dira ir jine, zama Musa din, boraa din kaŋ nʼir žigandi ka hun Misira gandaa ra, ir si bay haya kaŋ ka duu a.» ");
INSERT INTO ses_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Haruna nee i se: «Wa wura haŋakorbawey kaa kaŋ goo war wandey haŋawey ra, nda war izʼarey, nda war ize woyey, war ma kate ey ya ne.» ");
INSERT INTO ses_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Jamaa kul na wura haŋakorbawey kaa kaŋ goo ngi haŋawey ra ka kate ey Haruna do. ");
INSERT INTO ses_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","A na wuragoo dii kabey ra ka guurey baaba kʼa kayri kʼa mennandi kʼa tee yagaw. Woo banda ga, i nee: «Izirayel, ni Koyoo ne kaŋ na ni žigandi ka hun Misira gandaa ra.» ");
INSERT INTO ses_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Kaŋ Haruna dii woo, a na sargari tonadoo foo cin a jine. Haruna kaati ka nee: «Suba ir ga jingar tee Abadantaa maaɲoo ga.» ");
INSERT INTO ses_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Subaa ra, i biya ka tun ka sargari kukuranteyaŋ nda alaafiya teendi sargariyaŋ kaa. Jamaa goro ka ŋaa ka haŋ, nga banda ga, i tun ka hooray. ");
INSERT INTO ses_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Abadantaa šelaŋ Musa se ka nee: «Cahã ka zunbu, zama ni jamaa kaŋ nʼnʼa žigandi ka hun Misira gandaa ra hasara. ");
INSERT INTO ses_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","I cahã ka fondaa naŋ kaŋ ay nʼi yaamar i mʼa dii. I na guuru mennandi kʼa tee yagaw ngi boŋ se ka sujudu a se, ka sargari kaa a se, i nee mo: ‹Izirayel, ni Koyoo ne kaŋ na ni žigandi ka hun Misira gandaa ra.›» ");
INSERT INTO ses_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Abadantaa nee Musa se: «Ay dii jamaa woo, nga ne, jamaa no kaŋ hiɲoo ga šendi. ");
INSERT INTO ses_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Sohõ ay naŋ hala ay futuroo ma zunbu i ga, hala yʼi halaci, amma ay ga ni tee dumi beeri.» ");
INSERT INTO ses_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Amma Musa na nga Koyoo, Abadantaa suurandi ka binoo yaynandi ka nee: «Abadantaa, macin se ni futuroo kaŋ ni jamaa ga kaŋ nʼnʼi fattandi Misira gandaa ra nda gaabi albarkante nda kabe gaabante? ");
INSERT INTO ses_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Nda nʼna takaa woo tee, Misira borey ga nee: ‹A manʼi fattandi kala nda anniya laala, kʼi wii tondi hondey ra, kʼi derandi laboo ga.› Ay Koyoo, ni futay beeroo naŋ, ma nimsi ka ifutaa naŋ kaŋ nʼgʼa baa kʼa tee ni jamaa se. ");
INSERT INTO ses_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Hongu ni tamey Ibirahima, nda Isiyaka, nda Izirayel kaŋyaŋ se ni žee ni maaɲoo ga, ni nee i se: ‹Ay ga war hayroo boobandi sanda beenaa handarawey, gandaa kaŋ ay nʼa har se: “Ay gʼa noo war hayroo se”, i gʼa tubu hala abada.›» ");
INSERT INTO ses_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ifutaa kaŋ Abadantaa nee nga gʼa tee nga jamaa se, a nimsi, a tun a ga. ");
INSERT INTO ses_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Musa na banda bere ka zunbu tondi hondoo boŋ, seedetaraa walha hinkaa goo kaboo ra. Walhaa banda hinkaa kul ga hantum goo, a goo caraw foo ga, a goo caraw faa ga. ");
INSERT INTO ses_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Walhawey, Irkoy goyoo no, hantumoo, Irkoy hantumoo no kaŋ žeerandi walhawey ga. ");
INSERT INTO ses_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Kaŋ Žozuwe maa jamaa kaatiyanoo jindoo, a nee Musa se: «Wongu jinde goo jamaa kaloo ra.» ");
INSERT INTO ses_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Amma Musa nee: «Manʼti hinyan jinde no, manʼti boro kaŋ i hin a jinde no, hayaa kaŋ ay ga maarʼa, dooni jinde no!» ");
INSERT INTO ses_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Za Musa man jamaa kaloo, a ga yagaa honnay, a ga dii jamaa kaŋ ga gan. Musa futuroo tun. A na walhawey warra kʼi kaa nga kaboo ra, a nʼi kayri tondi hondoo cire. ");
INSERT INTO ses_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","A na yagaa kaŋ i nʼa tee dii kʼa ton nuune ra. A nʼa dur hala a tee hamni, a nʼa say haroo boŋ kʼa haŋandi Izirayel borey se. ");
INSERT INTO ses_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Musa nee Haruna se: «Macin no jamaa nʼa tee ma ne kaŋ se ni kate i ga zunubu beeroo woo?» ");
INSERT INTO ses_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Haruna nee: «Ay koyoo futuroo masi tun! Ni hunday ga jamaa bay, nʼga bay kaŋ i ga cahã ifutu teeyan se. ");
INSERT INTO ses_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","I nka nee ya ne: ‹Koyyaŋ tee ir se kaŋ ga dira ir jine, zama Musa din, boraa din kaŋ nʼir žigandi ka hun Misira gandaa ra, ir si bay haya kaŋ ka duu a.› ");
INSERT INTO ses_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Waatoo din ay nee i se: ‹May bara nda wura? I nʼi kaa ngi ga kʼi noo ya ne, ay nʼi warra nuunaa ra, de yagaa woo bangay.›» ");
INSERT INTO ses_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Musa dii kaŋ jamaa dere, zama Haruna nkʼi naŋ derandiyan fondaa ra, hala ngi iberey ma haaru i ra. ");
INSERT INTO ses_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Musa kay jamaa kaloo miɲoo ga, a nee: «Borey kaŋ goo Abadantaa bande ma kaa ay do.» Lewi izʼarey kul marga a do. ");
INSERT INTO ses_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","A nee i se: «Hayaa ne kaŋ Abadantaa, Izirayel Koyoo nʼa har, a nee: ‹Boro foo kul ma nga takubaa daŋ centoo ga, war ma koy jamaa kaloo kul yaara hugu nda hugu, war affoo kul ma nga armaa, nda nga ceroo, nda nga boro maanaa wii.›» ");
INSERT INTO ses_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Lewi izʼarey na hayaa tee kaŋ Musa nʼa har, hanoo din, jamaa ra, aru zenber hinza (3.000) cine kaŋ ka buu. ");
INSERT INTO ses_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Musa nee: «Hõ war yeetandi jere ga Abadantaa se, zama war affoo kul na nga izʼaroo, nda nga armaa wii, hala albarka ma huru war ra hõ.» ");
INSERT INTO ses_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Subaa ra, Musa nee jamaa se: «War na zunubu beeri tee, amma sohõ ay ga žigi ka koy Abadantaa do, a ga hin ka tee ya duu taka kaŋ nda war zunubey ga tuusandi.» ");
INSERT INTO ses_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Musa yee Abadantaa do ka nee: «Ya Abadantaa, jamaa woo na zunubu beeri tee, i na wura koyyaŋ tee ngi boŋ se. ");
INSERT INTO ses_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Sohõ, nda ni yadda, ngi zunuboo yaafa i se. Nda manʼti woo, ay maaɲoo tuusu kʼa kaa ni citaaboo ra kaŋ nʼnʼa hantum.» ");
INSERT INTO ses_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Amma Abadantaa nee Musa se: «Boraa kaŋ na zunubu tee ya ne no ay ga maaɲoo tuusu kʼa kaa ay citaaboo ra. ");
INSERT INTO ses_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Sohõ koy, ma jamaa gongu ka koy nongoo kaŋ ay nʼa har ma ne ra. Nga ne, agay almalaykaa no ma dira ni jine. Han kul kaŋ ay tun i se ay gʼi zukandi ngi zunuboo se.» ");
INSERT INTO ses_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Abadantaa na jamaa kar, zama a na yagaa tee, woo kaŋ Haruna nʼa tee. ");
INSERT INTO ses_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Abadantaa šelaŋ Musa se ka nee: «Hun ne, ni nda jamaa kaŋ nʼnʼi žigandi ka hun Misira gandaa ra, žigi ka koy gandaa ra kaŋ ay nʼa žee Ibirahima, nda Isiyaka, nda Yakuba se ka nee: ‹Ay gʼa noo ni hayroo se.› ");
INSERT INTO ses_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ay ga almalayka sanba ni jine, ay ga Kanaŋ borey, nda Amor borey, nda Heti borey, nda Ferezi borey, nda Hewi borey, nda Žebus borey gaaray. ");
INSERT INTO ses_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Žigi ka koy gandaa kaŋ ra waa nda yuu ga tee hari. Ay si koy war bande, hala ya si koy ni halaci fondaa ra, zama ni manʼti kala jama kaŋ hiɲoo ga šendi.» ");
INSERT INTO ses_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Kaŋ jamaa maa alhabar laalaa woo, biney maray, boro kul mana yee ka taalam daŋ. ");
INSERT INTO ses_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Abadantaa nee Musa se: «Šelaŋ Izirayel borey se ka nee: ‹War manʼti kala jamaa hiɲešenda, nda ay koy war bande alwaati kayna, ay ga ni halaci. Ni taalamey kaa, ay ga dii haya kaŋ no ay gʼa tee ma ne.›» ");
INSERT INTO ses_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Za i hun Horeb tondi hondoo do, Izirayel borey na ngi taalamey kaa. ");
INSERT INTO ses_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Musa ga hukkumoo zaa kʼa cin jamaa kaloo se taray, nongu mooro ra, a na maaɲoo daŋ «cere kubayyan hukkumoo». Boro kul kaŋ ga Abadantaa ceeci si fatta ka koy kala cere kubayyan hukkumoo din do kaŋ goo jamaa kaloo se taray. ");
INSERT INTO ses_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Waati kaŋ Musa koy hukkumoo here, jamaa kul ga tun, affoo kul ga kay nga hukkumoo miɲoo ga, a ga Musa guna hala a ma huru hukkumoo ra. ");
INSERT INTO ses_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Nda Musa huru hukkumoo ra, duulaa kaŋ ga kay i jine ga zunbu ganda ka kay hukkumoo miɲoo ga, Irkoy šelaŋ Musa bande. ");
INSERT INTO ses_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Jamaa kul ga dii duulaa kaŋ ga kay i jine cere kubayyan hukkumoo miɲoo ga, jamaa kul ga sujudu, affoo kul nga hukkumoo miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Abadantaa šelaŋ Musa bande mee nda mee, sanda takaa kaŋ nda boro ga šelaŋ nga ceroo bande. Woo banda ga, Musa yee jamaa kaloo ra, amma nga banda hunoo Žozuwe, aru sooga no kaŋ ti Nun izʼaroo mana hun hukkumoo kuneheroo ra. ");
INSERT INTO ses_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musa nee Abadantaa se: «Guna, ni nee ya ne: ‹Jamaa woo žigandi›, amma mana boraa har ya ne kaŋ nʼgʼa hangandi ay bande. Ni no ka nee ya ne mo: ‹Ay ga ni bay nda ni maaɲoo, koyne mo ay na alhormo tee ma ne.› ");
INSERT INTO ses_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Sohõ, alhormo tee ya ne, ay gʼa wiri ni ga, ma ni fondawey bayrandi ya ne hala ya ni bay, woo ra ay ga bay kaŋ nʼna alhormo tee ya ne. Masi dirɲa gandaa woo borey, ni jamaa no.» ");
INSERT INTO ses_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Abadantaa nee: «Agay hunday no ma koy ni bande, ay ga ni noo hunanzamay.» ");
INSERT INTO ses_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Musa nee a se: «Nda ni hunday si koy, masi naŋ ir ma žigi ka hun ne. ");
INSERT INTO ses_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Nda nʼsi koy ir bande, taka foo nda ir ga bay kaŋ nʼna alhormo tee ya ne, agay nda ni jamaa? Manʼti kaŋ se nʼga koy ir bande, nga se ir, agay nda ni jamaa, ir ga fay nda jama kul kaŋ goo laboo ga?» ");
INSERT INTO ses_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Abadantaa nee Musa se: «Šennoo kaŋ ni ne kʼa har, ay gʼa tee, zama nʼna alhormo tee ya ne, ay ga ni bay nda ni maaɲoo.» ");
INSERT INTO ses_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Musa nee: «Ay gʼa wiri ni ga, ma ni daržaa cebe ya ne!» ");
INSERT INTO ses_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Abadantaa nee Musa se: «Ay gʼay borohennataraa kul bisandi ni jine, ay ga Abadantaa maaɲoo cee ni jine. Ay ga alhormo tee boro kaŋ se ay baa ya alhormo tee, ay ga tamalla boro kaŋ se ay baa ya tamalla.» ");
INSERT INTO ses_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","A nee koyne: «Nʼsi hin ka dii ay ndumoo, zama adamize si hin ka dii ay ndumoo a ma yee ka huna.» ");
INSERT INTO ses_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Abadantaa nee: «Nga ne, nongu foo ne ay jeroo ga, kaa ka kay tondoo boŋ. ");
INSERT INTO ses_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Waati kaŋ ay daržaa ga bisa, ay ga ni daŋ tondoo guusoo ra, ay gʼay kaboo ka ni gum hala ya bisa. ");
INSERT INTO ses_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Woo banda ga, ay gʼay kaboo kaa no, de nʼga dii ay dumaa here. Amma agay ndumoo, boro si hin ka dii a.» ");
INSERT INTO ses_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Abadantaa nee Musa se: «Tondi walha hinka hoy sanda ijinawey, ay ga šenney hantum i ga kaŋ cindi ijinawey ga kaŋ nʼnʼi kayri. ");
INSERT INTO ses_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Soolu suba subbaahi se, za subbaahi ma žigi Sinay tondi hondoo boŋ ka kay ay jine, hondoo boŋoo ga. ");
INSERT INTO ses_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Boro kul masi žigi ni bande, de mo boro masi bara tondi hondoo din kul ga, alman buuna nda ibeeri kul masi kur hondoo din here.» ");
INSERT INTO ses_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Musa na tondi walha hinkaa hoy sanda ijinawey. A biya ka tun, a žigi Sinay tondi hondoo boŋ sanda takaa kaŋ nda Abadantaa nʼa yaamar. A na tondi walha hinkaa zaa nga kaboo ra. ");
INSERT INTO ses_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Abadantaa zunbu ka kaa duulaa ra. Abadantaa na nga boŋ maaɲoo cee. ");
INSERT INTO ses_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Abadantaa bisa Musa jine, a nee: «Abadantaa, Abadantaa, Irkoy tamallakoyoo kaŋ ga alhormo tee, kaŋ si cahã ka futu, kaŋ ga too met nda borohennataray nda laadirtaray, ");
INSERT INTO ses_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","kaŋ ga nga arrahamaa cebe alwadda zenberyaŋ se, a ga laybu, nda hooyan, nda zunubu yaafa, amma a si ifutu dii ihenanante. A ga baabey laybey hangandi izey nda haamawey hala alwadda hinzantoo ka koy itaacantoo ga.» ");
INSERT INTO ses_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Musa cahã ka gunguma laboo ra ka sujudu ");
INSERT INTO ses_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","ka nee: «Alhormo tee ya ne, ay Koyoo, ay Koyoo ma dira ir game. Jama hiɲešenda no, ir zunubey nda ir laybey yaafa ir se, ir tee ni tubuhayaa.» ");
INSERT INTO ses_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Abadantaa nee: «Nga ne, ay ga amaana daŋ agay nda war game. Ni jamaa kul jine ay ga kayfiyaŋ tee kaŋ cine mana bay ka teendi laboo kul ga, a mana teendi ganda kul ra. Jamaa kaŋ ga ni kuubi ka ni bere ga dii Abadantaa teegoyoo, teegoy kaŋ ga boro hunburandi no ay gʼa tee ma ne. ");
INSERT INTO ses_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Lakkal daŋ hayaa se kaŋ nda ay ga ni yaamar hõ. Nga ne, ay ga Amor borey, nda Kanaŋ borey, nda Heti borey, nda Ferezi borey, nda Hewi borey, nda Žebus borey gaaray ni jine. ");
INSERT INTO ses_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Hawgay masi amaana daŋ ni nda gandaa kaŋ ra nʼga huru borey game, i masi koy tee war game kumsay. ");
INSERT INTO ses_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","War ma ngi sargari tonadogey kayri, war ma ngi tondey kaŋ i nʼi kayandi kʼi gana hasara, war ma ngi Ašera toorey zafa. ");
INSERT INTO ses_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Masi sujudu koy tana se, zama Abadantaa kaŋ maaɲoo ti ‹Canse›, Koy no kaŋ ga canse ma ne. ");
INSERT INTO ses_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Amaana kul masi huru ni nda gandaa din borey game hala waati kaŋ i ga izefututaray tee ngi koyey bande, de i ga sargari kaa i se, nda i na ni cee, masi ŋaa. ");
INSERT INTO ses_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Nda nʼna ngi ize woyey zaa ni izʼarey se, ngi ize woyey ga izefututaray tee nda ngi koyey, i ga war izʼarey tuti i ma izefututaray tee ngi koyey bande. ");
INSERT INTO ses_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Masi guuru mennandi kʼa tee koy. ");
INSERT INTO ses_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","War ma Takulawey kaŋ ra dolobiri sii jingaroo kayandi. Jirbi iyye war ma takula ŋaa kaŋ ra dolobiri sii, sanda takaa kaŋ nda ay na ni yaamar, waatoo kaŋ kayandi Abib handoo ra. Zama Abib handoo ra ni fatta Misira. ");
INSERT INTO ses_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Gunde jinaa kul ti agay wane, haya kul kaŋ ti aru ni adabbawey, alman beeri nda ibuuna ra. ");
INSERT INTO ses_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Amma farka gunde jinaa, mʼa barmay nda alman buuna, nda manʼa barmay, ma jindebandaa kayri. Ni izʼarey gunde jinawey, ma ngi hayoo noo. Boro si kaa ay jine kabe koonu. ");
INSERT INTO ses_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Jirbi iddu ma goy, amma jirbi iyyantoo ma hunanzam, ba beerumaa nda hegaa waati no ma hunanzam. ");
INSERT INTO ses_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","War ma Jirbiiyyewey jingaroo tee, alkamaa jeeni ize jina-jinawey se, war ma Hegaa jingaroo tee jiiroo benantaa ga. ");
INSERT INTO ses_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Cee hinza jiiroo ra, ni borey ra, aru kul ga kaa ka kay ni Koyoo jine, Abadantaa, Izirayel Koyoo. ");
INSERT INTO ses_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Zama ay ga dumey gaaray ni jine, ay ga tonton ni gandaa hirrey ga kʼi beerandi. Waati kaŋ ni žigi ka koy kay Abadantaa, ni Koyoo jine cee hinza jiiroo ra, boro kul si kaa ni dumaa ga ka ni gandaa taa. ");
INSERT INTO ses_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Masʼay sargaroo kuroo nda takula kaŋ ra dolobiri goo kaa cere bande. Borcintaraa jingaroo sargaroo masi cindi za cijinoo ra hala subbaahi. ");
INSERT INTO ses_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Ma kate Abadantaa, ni Koyoo hugoo do ni faaroo ize jina-jinawey. Masi hancin-ize hina ɲaŋoo wawaa ra.» ");
INSERT INTO ses_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Abadantaa nee Musa se: «Šenney wey hantum. Šenney wey nda ay ga amaana daŋ agay, nda ni, nda Izirayel game.» ");
INSERT INTO ses_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","No din ra Musa na zaari woytaaci (40) nda cijin woytaaci (40) tee Abadantaa bande. A mana haya ŋaa, a mana haya haŋ. A na amaanaa šenni woyaa (10) hantum walhawey ga. ");
INSERT INTO ses_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Waatoo kaŋ Musa zunbu ka hun Sinay tondi hondoo boŋ, seedetaraa walhawey hinkaa goo kaboo ra kaŋ a ga zunbu, a si bay kaŋ nga ndumoo mma dii garaw waatoo kaŋ nga nda Abadantaa ga šelaŋ. ");
INSERT INTO ses_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Haruna nda Izirayel borey ga Musa guna, nga ne, nga ndumoo ga dii garaw, i hunbur ka man a. ");
INSERT INTO ses_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Amma Musa ciya i se. Haruna nda jamaa boŋkoyney kul kaa a do, Musa šelaŋ i se. ");
INSERT INTO ses_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Woo banda ga, Izirayel borey kul man kate, a na yaamarey kul har i se kaŋ Abadantaa nʼi har nga se Sinay tondi hondoo ga. ");
INSERT INTO ses_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Kaŋ Musa šelaŋ i bande ka ben, a na sanfiti gum nga ndumoo ga. ");
INSERT INTO ses_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Amma waati kaŋ a ga huru ka koy Abadantaa do ka šelaŋ a bande, a ga sanfitoo kaa nga ga hala nga fattaroo ga. Nda a fatta, a ga hayaa deede Izirayel borey se kaŋ yaamarandi. ");
INSERT INTO ses_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Izirayel borey ga Musa ndumoo guna, i dii kaŋ a ga dii garaw, Musa ga sanfitoo yeeti nga ndumoo ga hala waati kaŋ a yee ka huru ka koy Abadantaa do ka šelaŋ. ");
INSERT INTO ses_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musa na Izirayel borey jamaa kul marga, a nee i se: «Hayey ne kaŋ Abadantaa nʼi yaamar i ma teendi. ");
INSERT INTO ses_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Jirbi iddu goy ma teendi, amma jirbi iyyantoo ma tee war se zaari henanante, farakaayan, hunanzamzaari kaŋ ga teendi Abadantaa se. Boro kul kaŋ goy hanoo din, boraa ga wiiyandi. ");
INSERT INTO ses_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Hunanzamzaaroo hane, nongu kul kaŋ ra war nʼa tee gorodoo, war masi nuune diinandi.» ");
INSERT INTO ses_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Musa šelaŋ Izirayel borey jamaa kul se ka nee i se: «Hayaa ne kaŋ Abadantaa nʼa yaamar: ");
INSERT INTO ses_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","‹Wa hayayaŋ kaa kʼi noo Abadantaa se, bine henna kul ma haya noo Abadantaa se: wura, nda nzorfu kaaray, nda alhan, ");
INSERT INTO ses_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","nda šukka bula, nda iciray henna, nda iciray zaram, nda šukka baana yakuwante, nda hancin hinbiri, ");
INSERT INTO ses_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","nda gaaru kuuruyaŋ kaŋ cirayandi, nda ayu kuuruyaŋ, nda akasiya bundu, ");
INSERT INTO ses_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","nda jii fitilla gorodogoo se, nda turaari hew kaanayaŋ yonyan jiyoo nda dugu hew kaanaa se, ");
INSERT INTO ses_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","nda oniks tondi, nda tondi dumiyaŋ kaŋ ga huru beene kaayi-izoo nda albaytoo ra. ");
INSERT INTO ses_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","War ra, bayraykoyni kul ma kaa ka hayey kul tee kaŋ Abadantaa nʼi yaamar: ");
INSERT INTO ses_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Irkoy gorodogoo nda nga hukkumoo, nda kuntaa kaŋ ga gum a ga, nda nga kanjihayey, nda nga bundu tefawey, nda nga gaaru-gaarey, nda nga ganjey, nda nga ferawey, ");
INSERT INTO ses_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","sundukoo nda nga gobey, nda daabirjoo, nda zaaraa kaŋ ga tee rido, ");
INSERT INTO ses_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","nda taabaloo nda nga gobey, nda nga jinawey kul, nda takulawey kaŋ jisandi Irkoy jine, ");
INSERT INTO ses_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","nda fitilla gorodogoo nda nga jinawey, nda fitillawey nda jiyoo kaŋ gʼi diinandi, ");
INSERT INTO ses_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","nda dugu dullandidogoo nda nga gobey, nda yonyan jiyoo, nda dugu hew kaanaa, nda Irkoy gorodogoo miɲoo ridowoo, ");
INSERT INTO ses_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","nda sargari kukurantey tonadogoo nda nga ham tonaguuroo kaŋ ti alhan, nda nga gobey, nda nga jinawey kul, nda taasa beeroo nda hayaa kaŋ ga a ga goro, ");
INSERT INTO ses_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","batumaa kuntawey, nda nga ganjey, nda nga ferawey, nda batumaa miɲoo ridowoo, ");
INSERT INTO ses_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","nda Irkoy gorodogoo sukahayey, nda batumaa sukahayey, nda ngi karfey, ");
INSERT INTO ses_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","nda bankaaray cere-cerantey kaŋ nda goyoo ga teendi nongu henanantaa ra, nda sargari juwalkaa Haruna bankaaray henanantey, nda nga izʼarey bankaarawey kaŋ nda i ga sargari juwalyan goyoo tee.›» ");
INSERT INTO ses_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Izirayel borey jamaa kul hun Musa do. ");
INSERT INTO ses_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Borey kul kaŋ biney ga boori kabey ga don man ka haya noo Abadantaa se cere kubayyan hukkumoo cinayanoo, nda goyey kul kaŋ ga tee a ra, nda bankaaray henanantey teeyanoo se. ");
INSERT INTO ses_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Arey nda woyey kul kaŋ biney ga boori kate hiiri, nda niinekorbay, nda haŋakorbay, nda kabekorbay, nda jindehiiri. I kul kate wura jinay dumi kul kʼi tee sargari zinji-zinjante Abadantaa se. ");
INSERT INTO ses_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Boro kul kaŋ do šukka bula, wala iciray, wala iciray zaram, wala šukka baana yakuwante, wala hancin hinbiri, wala gaaru kuuruyaŋ kaŋ cirayandi, wala ayu kuuruyaŋ goo, kate ey. ");
INSERT INTO ses_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Boro kul kaŋ na haya noo sanda nzorfu kaaray wala alhan ga kate a Abadantaa do. Boro kul kaŋ do akasiya bundu goo kate a goy dumi kul kaŋ ga teendi se. ");
INSERT INTO ses_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Woy bayraykoyni kul na haabu bii kʼa tee šukka bulaa, nda iciraa, nda iciray zaramoo, nda šukka baana yakuwantaa ka kate ey. ");
INSERT INTO ses_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Woy lakkalkoyni kul na hancin hinbiri bii. ");
INSERT INTO ses_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Jamaa boŋkoyney kate sardoniks tondi, nda tondi dumiyaŋ kaŋ ga huru beene kaayi-izoo nda albaytoo ra. ");
INSERT INTO ses_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","I kate turaari hew kaanayaŋ, nda jii fitilla gorodogoo se, nda yonyan jiyoo se, nda dugu hew kaaney se. ");
INSERT INTO ses_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Izirayel borey, woy nda aru kabedoonawey kul kate haya goyoo kul se kaŋ nda Abadantaa na Musa kʼi yaamar. Sargari no kaŋ i nʼa noo nda ngi boŋ Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Musa nee Izirayel borey se: «Wa guna, Abadantaa na Besalel cee nda nga maaɲoo, Uri izʼaroo no, Hur haamaa, Žuda alkabiilaa boro no. ");
INSERT INTO ses_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","A nʼa too met nda Irkoy Hundoo, nda lakkal, nda bayray, nda fahamay, goy dumi kul ra, ");
INSERT INTO ses_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ka haya taagayaŋ fattandi wura goyyan, nda nzorfu kaaray goyyan, nda alhan goyyan ra. ");
INSERT INTO ses_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","A ga wan ka tondi hoy kʼa caara kʼa gorandi haya ra, ka bundu goy, ka assana goyyan dumi kul tee. ");
INSERT INTO ses_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","A daŋ binoo ra mo a ma cawandi, nga nda Oholiyab, Ahisamak izʼaroo no, Dan alkabiilaa boro no. ");
INSERT INTO ses_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","A nʼi too met nda lakkal hala i ma hin ka tondi fasalyan dumi kul tee, ka assana goykaw goy dumi kul tee, ka maale goy dumi kul tee, ka šukka bula, nda iciray henna, nda iciray zaram, nda šukka baana yakuwante kay, ka goy dumi kul tee, ka haya taagayaŋ fattandi.» ");
INSERT INTO ses_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Besalel, nda Oholiyab, nda lakkalkoyni kul kaŋ Abadantaa nʼi noo lakkal nda fahamay hala i ma nongu henanantaa goyey kul tee, i nʼi tee ka sawa nda Abadantaa yaamaroo. ");
INSERT INTO ses_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Musa ciya Besalel, nda Oholiyab, nda lakkalkoyni kul kaŋ Abadantaa na lakkal daŋ binoo ra se, kaŋyaŋ yadda ka goyey tee. ");
INSERT INTO ses_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Musa nʼi noo sargaroo kul kaŋ Izirayel borey nʼa kaa nongu henanantaa cinayanoo goyey se. Subbaahi ka kaa subbaahi borey ga kate a se ngi faabaroo. ");
INSERT INTO ses_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Lakkalkoyney kul kaŋ goo ma goy nongu henanantaa ra na ngi goyoo naŋ affoo-foo, ");
INSERT INTO ses_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","i šelaŋ Musa se ka nee: «Jamaa ga hanse ka kate jinay ka bisa woo kaŋ Abadantaa nʼa yaamar goyoo teeyanoo se.» ");
INSERT INTO ses_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Musa daŋ i ma fee ngi kaloo ra ka nee: «Woy wala aru masi yee ka goy ka kate haya nongu henanantaa cinaroo se.» I kay, i mana yee ka kate haya. ");
INSERT INTO ses_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Zama jinawey kaŋ goo no goyoo se ga wasa hala haya ma cindi. ");
INSERT INTO ses_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Goykey ra, bayraykoyni beerey na Irkoy gorodogoo tee nda kaymi taafe zuu woy (10) šukka baana yakuwante, ibula, nda iciray henna, nda iciray zaram. I na almalaykayaŋ kaŋ se i ga nee šerib kay zuwey ga, assana goykaw goy no. ");
INSERT INTO ses_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Zuu foo kul kuuyanoo ga too kabedaaru waranka cindi yaaha (28), hayyanoo ga too kabedaaru taaci. Zuwey kul ti deede foo. ");
INSERT INTO ses_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","I na zuu guu daŋ cere ga jina, i yee ka igguu faa mo daŋ cere ga. ");
INSERT INTO ses_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","I na karfuyaŋ kaŋ teendi nda šukka bula daŋ zuu guu margari jinaa zuu koraa miɲoo ga, taka follokaa no i nʼa tee zuu guu margari faa miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","I na karfu woyguu (50) daŋ zuu guu jinaa ga, i na karfu woyguu (50) daŋ zuu guu hinkantoo zuu koraa miɲoo ga. Karfey ga cere tenje. ");
INSERT INTO ses_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","I na wura kanjihaya woyguu (50) tee, i na zuwey daŋ cere ga nda kanjihayey, woo ra a tee hukkum folloku. ");
INSERT INTO ses_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Woo banda ga, i na zuuyaŋ nda hancin hinbiri tee kʼi tee hukkum kaŋ goo Irkoy gorodogoo boŋ. Zuwey manʼti kala iwoy cindi foo (11). ");
INSERT INTO ses_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Zuu foo kul kuuyanoo manʼti kala kabedaaru waranza (30), hayyanoo kabedaaru taaci. Zuu woy cindi faa (11) ti deede foo. ");
INSERT INTO ses_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","I na zuu guu marga cere ga, i na zuu iddu marga cere ga. ");
INSERT INTO ses_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","I na karfu woyguu (50) daŋ zuwey margari jinaa zuu koraa miɲoo ga, i na karfu woyguu (50) daŋ zuu beerey margari hinkantoo miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","I na alhan kanjihaya woyguu (50) tee ka hukkumoo daŋ cere ga hala a ma tee afolloku. ");
INSERT INTO ses_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","I na kunta kaŋ ga hukkumoo gum tee nda gaaru kuuruyaŋ kaŋ cirayandi, i na kunta kaŋ teendi nda ayu kuuruyaŋ daŋ a ga. ");
INSERT INTO ses_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Woo banda ga, i na bundu tefayyaŋ kaŋ ga kay tee Irkoy gorodogoo se nda akasiya bundu. ");
INSERT INTO ses_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Bundu foo kul goo nda kabedaaru woy (10) kuuyan, affoo kul goo nda kabedaaru foo nda jere hayyan. ");
INSERT INTO ses_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","I na bundu tefay hinka tee kaŋ ga cere tenje, affoo kul cee hinka ga dobu a ga. Takaa woo nda Irkoy gorodogoo bundu tefawey kul teendi. ");
INSERT INTO ses_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","I na bundey wey tee Irkoy gorodogoo se, i na bundu waranka (20) tee gurma kaboo here. ");
INSERT INTO ses_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","I na nzorfu kaaray feraw woytaaci (40) kar kaŋyaŋ guusu goo i ra, i goo bundu tefay warankaa (20) cire, bundu foo kul cee hinkaa goo feraw hinka guusey ra. ");
INSERT INTO ses_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Irkoy gorodogoo caraw faa mo i na bundu tefay waranka (20) tee hawsa kaboo here, ");
INSERT INTO ses_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","nda ngi nzorfu kaaray feraw woytaacaa (40), feraw hinka goo bundu foo kul cire. ");
INSERT INTO ses_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Irkoy gorodogoo kuneheroo se, dangay kaboo here, i na bundu iddu tee. ");
INSERT INTO ses_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Irkoy gorodogoo kuneheroo ra, i na bundu hinka tee kanjey se. ");
INSERT INTO ses_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Gandaheroo goo cere ga, beeneheroo korbay gʼi dii cere ga henna. I na taka follokaa tee ihinkaa se kaŋ goo kanje hinkaa ga. ");
INSERT INTO ses_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Bundu tefay yaahaa nda ngi nzorfu kaaray ferawey bara no, feraw woy cindi iddu (16) no, feraw hinka goo bundu foo kul cire. ");
INSERT INTO ses_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Woo banda ga, i na akasiya bundu tee gaaru-gaaruyaŋ, igguu Irkoy gorodogoo caraw foo bundu tefawey se. ");
INSERT INTO ses_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Igguu Irkoy gorodogoo caraw faa bundey se, igguu nga gorodogoo kuneheroo se kaŋ goo dangay caraa here. ");
INSERT INTO ses_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Gaaru-gaaroo kaŋ goo gamoo ra, i nʼa daŋ bundu tefawey kuuyanoo gamoo ra, a ma hun boŋ foo ga ka koy boŋ faa ga. ");
INSERT INTO ses_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","I na bundu tefawey daabu nda wura, i na wura ka ngi korbawey tee kaŋ ga gaaru-gaarey dii, gaaru-gaarey mo daabandi nda wura. ");
INSERT INTO ses_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Woo banda ga, i na ridowoo tee nda šukka bula, nda iciray henna, nda iciray zaram, nda šukka baana yakuwante. I na almalaykayaŋ kaŋ se i ga nee šerib kay a ga, assana goykaw goy no. ");
INSERT INTO ses_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","I na ganji taaci tee a se nda akasiya bundu, i nʼi daabu nda wura, korbayyaŋ teendi nda wura. I na nzorfu kaaray mennandi ka feraw taaci tee ganjey se. ");
INSERT INTO ses_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","I na rido tee hukkumoo miɲoo se, a teendi nda šukka bula, nda iciray henna, nda iciray zaram, nda šukka baana yakuwante, maale kʼa kay. ");
INSERT INTO ses_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","I na nga ganji guwaa nda ngi korbawey tee ka ngi boŋey nda ngi hawahayey daabu nda wura. Ngi feraw guwaa teendi nda alhan. ");
INSERT INTO ses_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Besalel na sundukoo tee nda akasiya bundu, nga kuuyanoo manʼti kala kabedaaru hinka nda jere, hayyanoo kabedaaru foo nda jere, nga kayyanoo kabedaaru foo nda jere. ");
INSERT INTO ses_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","A na gundoo nda dumaa daabu nda wura alhakiika, a na wura kunga daŋ miɲoo bande. ");
INSERT INTO ses_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","A na wura mennandi ka korbay taaci tee cee taacaa se. Korbay hinka caraw foo ga, ihinka caraw faa ga. ");
INSERT INTO ses_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","A na akasiya bunduyaŋ tee gobu kʼi daabu nda wura. ");
INSERT INTO ses_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","A na gobey daŋ korbawey ra sundukoo carawey ga ka sundukoo zaa nda ey. ");
INSERT INTO ses_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","A na daabirji tee nda wura alhakiika. Nga kuuyanoo ti kabedaaru hinka nda jere, hayyanoo ti kabedaaru foo nda jere. ");
INSERT INTO ses_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","A na almalayka hinka tee kaŋ se i ga nee šerib. A nʼi kar wura ra, a nʼi daŋ daabirjoo boŋ hinkaa ga. ");
INSERT INTO ses_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","A na šerib foo tee boŋ foo ga, a na affoo tee boŋ faa ga. A na šeribey tee daabirjoo hunday ra, daabirjoo boŋ hinkaa ga. ");
INSERT INTO ses_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Šeribey ga ngi fatawey hay beene, i ga ngi fatawey ka daabirjoo daabu. Ngi ndumey ga cere tenje, i ga daabirjoo guna. ");
INSERT INTO ses_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Woo banda ga, a na taabaloo tee nda akasiya bundu, kuuyanoo ti kabedaaru hinka, hayyanoo kabedaaru foo, kayyanoo kabedaaru foo nda jere. ");
INSERT INTO ses_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","A nʼa daabu nda wura alhakiika ka wura kunga daŋ miɲoo bande. ");
INSERT INTO ses_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","A na jejebu tee kaŋ hayyanoo ga too kabetaami foo, a na wura kunga ka jejeboo kul kuubi kʼa bere. ");
INSERT INTO ses_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","A na wura mennandi ka korbay taaci tee a se, a na korbawey daŋ kanje taacaa ga kaŋ goo cee taacaa ga. ");
INSERT INTO ses_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Korbawey ga man jejeboo, ngi ra gobey ga huru ka taabaloo zaa. ");
INSERT INTO ses_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","A na gobey tee nda akasiya bunduyaŋ kʼi daabu nda wura ka taabaloo zaa. ");
INSERT INTO ses_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","A na jinawey tee kaŋ goo taabaloo ga: taasawey, nda potey, nda sargari-kaa-potey, nda gullawey kaŋ nda sargari hari-harey ga doorandi. A nʼi tee nda wura alhakiika. ");
INSERT INTO ses_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","A na fitillaa canboo tee nda wura alhakiika. Fitilla gorodogoo karandi, cewoo, nda kunturoo, nda potey, nda nga dobey, nda nga kutukuryey tee a bande affoo. ");
INSERT INTO ses_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Kabe iddu goo carawey ga, ihinza goo fitilla gorodogoo caraw foo ga, ihinza goo caraw faa ga. ");
INSERT INTO ses_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Kabe foo ga, poti hinza goo kaŋ ga hima nda tuuri-izoo kaŋ se i ga nee amand kaŋ ra dobu nda kutukurya goo. Kabe faa ga, poti hinza goo kaŋ ga hima nda amand kaŋ ra dobu nda kutukurya goo kabe hinkantoo ga. Takaa din da ti kabe idduwaa kaŋ ga fatta fitilla gorodogoo ga. ");
INSERT INTO ses_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Fitilla gorodogoo hunday ga poti taaci goo kaŋ ga hima nda amand kaŋ ra dobuyaŋ nda kutukuryayaŋ goo. ");
INSERT INTO ses_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Dobu foo goo kabe hinkaa jinaa cire kaŋ ga fatta kunturoo ga, dobu foo goo kabe hinkaa hinkantoo cire kaŋ ga fatta a ga, dobu foo goo kabe hinkaa hinzantoo cire kaŋ ga fatta a ga. Takaa din da ma teendi kabe idduwaa se kaŋ ga fatta a ga. ");
INSERT INTO ses_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Ngi dobey nda kabey tee kunturoo bande affoo, a kul tee goy kaŋ karandi nda wura alhakiika. ");
INSERT INTO ses_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","A na fitilla iyyaa, nda kanbey kaŋ ga ngi zaarawey boosey dunbu, nda dugu canbey tee nda wura alhakiika. ");
INSERT INTO ses_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Wura alhakiika kilo waranza (30) nda a na nga fitilla gorodogoo nda nga jinawey kul tee. ");
INSERT INTO ses_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Woo banda ga, a na dugu dullandidogoo tee nda akasiya bundu. Kuuyanoo manʼti kala kabedaaru foo, hayyanoo kabedaaru foo, caraw taacaa kul ga sawa. Nga kayyanoo manʼti kala kabedaaru hinka. Nga nda nga hilley kul ti affoo. ");
INSERT INTO ses_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","A na nga, nda nga beeneheroo, nda carawey kuubi-ka-beraa, nda hilley daabu nda wura alhakiika. A na wura kunga daŋ miɲoo bande. ");
INSERT INTO ses_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","A na wura korbay hinka daŋ kungaa cire. A nʼi daŋ caraw hinkaa ga kabe hinkaa ga kaŋ ra gobey kaŋ nda i gʼa zaa ga huru. ");
INSERT INTO ses_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","A na akasiya bunduyaŋ tee gobu kʼi daabu nda wura. ");
INSERT INTO ses_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","A na yonyan jii henanantaa, nda dugu hew kaana alhakiikaa tee, turaari teekaw goy no. ");
INSERT INTO ses_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Besalel na sargari kukurantey tonadogoo tee nda akasiya bundu. Caraw taacaa kul ga sawa, nga kuuyanoo manʼti kala kabedaaru guu, hayyanoo kabedaaru guu, nga kayyanoo kabedaaru hinza. ");
INSERT INTO ses_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","A na hilliyaŋ tee nga kanje taacaa ra. Nga nda nga hilley kul tee affoo, a nʼa daabu nda alhan. ");
INSERT INTO ses_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","A na sargari tonadogoo jinawey kul tee: nga barmawey, nda nga pelley, nda nga kusey, nda nga furšeti beerey, nda nga dugu canbey. Nga jinawey kul mana teendi nda kala alhan. ");
INSERT INTO ses_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","I na ham tonaguuru kaŋ ti alhan kaŋ ma nee sankay tee sargari tonadogoo miɲoo cire, za gamoo ga hala ganda. ");
INSERT INTO ses_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","A na alhan mennandi ka korbay taaci tee kʼi daŋ alhan tonaguuroo kanje taacaa ga i ma tee nongoo kaŋ ra gobey ga huru. ");
INSERT INTO ses_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","A na akasiya bundey tee kʼi daabu nda alhan. ");
INSERT INTO ses_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","A na gobey daŋ korbawey ra sargari tonadogoo carawey ga kʼa zaa, a teendi nda bundu, gundoo koonoo no. ");
INSERT INTO ses_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","A na alhan taasa beeroo tee, a na hayaa kaŋ ga a ga goro tee nda alhan, nda woyey kaŋ ga goy cere kubayyan hukkumoo miɲoo ga dijey. ");
INSERT INTO ses_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Woo banda ga, a na batumaa tee. Gurma kaboo here, batumaa kunta šukka baana yakuwanteyaŋ goo kaŋ kuuyanoo manʼti kala kabedaaru zangu (100). ");
INSERT INTO ses_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Ngi ganji warankaa (20) nda ngi feraw warankaa (20) manʼti kala alhan. Ganjey korbawey nda hawahayey manʼti kala nzorfu kaaray. ");
INSERT INTO ses_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Hawsa kaboo here, kabedaaru zangu (100), nda ngi ganji warankaa (20), nda ngi alhan cee warankaa (20). Ganjey korbawey nda ngi hawahayey manʼti kala nzorfu kaaray. ");
INSERT INTO ses_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Dangay kaboo here, kuntayaŋ kaŋ kuuyanoo manʼti kala kabedaaru woyguu (50), ngi ganji woyaa (10), nda ngi feraw woyaa (10), nda ganjey korbawey nda hawahayey manʼti kala nzorfu kaaray. ");
INSERT INTO ses_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Dandi kaboo here, waynahunay kaboo ga, kabedaaru woyguu (50). ");
INSERT INTO ses_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Kunta kabedaaru woy cindi guu (15) bara caraw foo ga, ngi nda ngi ganji hinzaa, nda ngi feraw hinzaa. ");
INSERT INTO ses_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Caraw faa mo se, ka koy batumaa miɲoo boŋ foo ga ka koy boŋ faa ga, kunta kabedaaru woy cindi guu (15), nda ngi ganji hinzaa, nda ngi feraw hinzaa goo. ");
INSERT INTO ses_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Batumaa kuntawey kul kaŋ gʼa kuubi manʼti kala šukka baana yakuwante. ");
INSERT INTO ses_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Ganjey ferawey manʼti kala alhan, ganjey korbawey nda hawahayey manʼti kala nzorfu kaaray. Ganjey boŋey mana daabandi nda kala nzorfu kaaray. Batumaa ganjey kul, nzorfu kaaray hawahayayaŋ no mʼi dii cere ga. ");
INSERT INTO ses_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Batumaa miɲoo ridowoo, maale kʼa kay, šukka bula, nda iciray henna, nda iciray zaram, nda šukka baana yakuwante nda a teendi. Ridowoo kuuyanoo manʼti kala kabedaaru waranka (20), nga kayyanoo manʼti kala kabedaaru guu. Ridowoo kayyanoo nda batumaa kuntawey hayyanoo kul ti deede foo. ");
INSERT INTO ses_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Nga ganji taacaa, nda nga cee taacaa manʼti kala alhan, korbawey nda ngi hawahayey manʼti kala nzorfu kaaray, ngi boŋey mana daabandi nda kala nzorfu kaaray. ");
INSERT INTO ses_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Irkoy gorodogoo sukahayey nda batumaa sukahayey kul manʼti kala alhan. ");
INSERT INTO ses_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Woo ti jinawey hinnaa kaŋ huru Irkoy gorodogoo cinayanoo ra kaŋ ti seedetaraa gorodogoo, kaŋ teendi ka sawa nda Musa yaamaroo. Lewi borey goyoo, sargari juwalkaa Haruna izʼaroo Itamar ti goyoo jinehunoo. ");
INSERT INTO ses_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Besalel, Uri izʼaroo, Hur haamaa kaŋ ti Žuda alkabiilaa boro na hayey kul tee kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Oholiyab, Ahisamak izʼaroo kaŋ ti Dan alkabiilaa boro goo a bande, assana goykaw no, maale goy no a ga tee, a ga šukka bula, nda iciray henna, nda iciray zaram, nda šukka baana kay. ");
INSERT INTO ses_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Wuragoo kul kaŋ tee sargari zinji-zinjante ka huru nongu henanantaa cinayanoo goyey kul ra manʼti kala ton foo cine ka sawa nda nongu henanantaa wura tammaa alkadaroo. ");
INSERT INTO ses_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Nzorfu kaaraa kaŋ borey kaŋ kabandi jamaa ra kate a manʼti kala ton hinza nda jere cine ka sawa nda nongu henanantaa nzorfu kaaray tammaa alkadaroo. ");
INSERT INTO ses_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Woo ga sawa nda boro foo kul beka tamma foo kaŋ alkadaroo ti nzorfu kaaray tamma jere ka sawa nda nongu henanantaa nzorfu kaaray tammaa alkadaroo. Arey kul kaŋ kabandi kaŋ goo nda jiiri waranka (20) nda ka žigi, maanaa boro zenber zangu iddu nda zenber hinza nda zangu guu nda woyguu (603.550). ");
INSERT INTO ses_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Ton hinza no ka mennandi ka tee nongu henanantaa ferawey nda ridowoo ganjey ferawey, feraw zangu (100) mana teendi nda kala ton hinza, feraw foo kul kilo waranza (30). ");
INSERT INTO ses_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","A na nzorfu kaaray tamma boŋ zenber foo nda zangu iyye nda woyye cindi guwaa (1.775) ka ganjey korbawey tee, i na boŋey daabu, i na hawahayey daŋ cere ga. ");
INSERT INTO ses_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Alhanoo hinnaa kaŋ Izirayel borey nʼa noo sargari zinji-zinjante manʼti kala ton hinka nda jere cine. ");
INSERT INTO ses_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","A na wey tee feraw cere kubayyan hukkumoo miɲoo se, a na alhan sargari tonadogoo, nda alhan ham tonaguuroo tee, nda sargari tonadogoo jinawey kul, ");
INSERT INTO ses_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","nda batumaa ferawey, nda batumaa miɲoo ferawey, nda hukkumoo sukahayey kul kaŋ gʼa kuubi. ");
INSERT INTO ses_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Šukka bulaa, nda iciray hennaa, nda iciray zaramoo nda i na bankaaray cere-cerantey tee kaŋ nda goyoo ga teendi nongu henanantaa ra nda Haruna bankaaray henanantey, sanda takaa kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","I na beene kaayi-izoo tee nda wura, nda šukka bula, nda iciray henna, nda iciray zaram, nda šukka baana yakuwante. ");
INSERT INTO ses_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","I na wuragey kar kʼi tefayandi, i nʼi dunbu-dunbu sanda šilli kʼi daŋ šukka bulaa, nda iciraa, nda iciray zaramoo ra, nda šukka baana yakuwantaa ra, assana goykaw goy no. ");
INSERT INTO ses_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","I na karfu-izeyaŋ tee a se kaŋ gʼi dii cere ga, ka mee hinkaa dii cere ga. ");
INSERT INTO ses_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Beene kaayi-izoo nda nga gamahawoo kaŋ goo a se beene kul mana tee kala affoo, nga nda beene kaayi-izoo kul mana teendi kala nda haya follokey no: wura, nda šukka bula, nda iciray henna, nda iciray zaram nda šukka baana yakuwante, sanda takaa kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","I na oniks tondiyaŋ kaŋ gorandi wura ra soolu, i na Izirayel borey maaɲey žeeri a ga sanda tammaasa. ");
INSERT INTO ses_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","I nʼi daŋ beene kaayi-izoo karfu-izey ga kʼi tee honganditondi Izirayel borey se sanda takaa kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Woo banda ga, i na albaytoo tee sanda takaa kaŋ nda i na beene kaayi-izoo tee, i nʼa tee nda wura, nda šukka bula, nda iciray henna, nda iciray zaram, nda šukka baana yakuwante, assana goykaw goy no. ");
INSERT INTO ses_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Caraw taacaa kul ga sawa, i nʼa taabu ihinka, nga kuuyanoo ga too kabetaami foo, nga hayyanoo ga too kabetaami foo. Albaytoo taabandi ihinka. ");
INSERT INTO ses_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","I nʼa taalam nda tondi sorro taaci: sorro jinaa mana teendi nda kala sarduwan, nda topaz, nda emerod. ");
INSERT INTO ses_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Sorro hinkantoo mana teendi nda kala tirkuwaz, nda safir, nda luulu. ");
INSERT INTO ses_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Sorro hinzantoo mana teendi nda kala opal, nda agat, nda ametist. ");
INSERT INTO ses_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Sorro taacantoo mana teendi nda kala krisolit, nda oniks, nda žasp. Tondey si gorandi kala ngi wura gorandihayey ra. ");
INSERT INTO ses_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Tondey ga sawa nda Izirayel borey maaɲey, i manʼti kala iwoy cindi hinka (12) sanda maaɲey. I nʼi žeeri sanda tammaasa, affoo kul nda nga maaɲoo, zama alkabiila woy cindi hinka (12) no. ");
INSERT INTO ses_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","I na wura alhakiika šešeri kaŋ teendi sanda karfu bibiranteyaŋ daŋ albaytoo ga. ");
INSERT INTO ses_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","I na wura gorandihaya hinka nda wura korbay hinka tee. I na korbay hinkaa daŋ albaytoo kanje hinkaa ga. ");
INSERT INTO ses_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","I na wura karfu hinkaa haw korbay hinkaa ga kaŋ goo albaytoo kanjey ga. ");
INSERT INTO ses_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Woo banda ga, i na karfey boŋ hinkaa haw gorandihaya hinkaa ga kʼi haw beene kaayi-izoo karfu-izey ga jineheroo ra. ");
INSERT INTO ses_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","I na wura korbay hinka tana tee kʼi daŋ albaytoo kanje hinkaa ga, miɲoo ga beene kaayi-izoo gundoo ra. ");
INSERT INTO ses_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","I na wura korbay hinka tana tee koyne kʼi haw beene kaayi-izoo karfu-izey ga ganda, jinehere nongoo kaŋ ga i ga hawa jeroo ga, beene kaayi-izoo gamahawoo se beene. ");
INSERT INTO ses_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","I na karfu bula ka albaytoo korbawey dii beene kaayi-izoo waney ga hala albaytoo ma cindi beene kaayi-izoo gamahawoo ga, albaytoo masi hun dogoo ra beene kaayi-izoo ga, sanda takaa kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Forkiyaa kaŋ ga huru beene kaayi-izoo cire teendi, maale kʼa kay, a kul mana teendi nda kala šukka bula. ");
INSERT INTO ses_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Funoo kaŋ i nʼa kaa forkiyaa gamoo ra ga kate a ma tee sanda guuru darbay, funoo miɲoo bande kunga goo hala a masi kottu. ");
INSERT INTO ses_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Forkiyaa gandahere miɲoo ga i na grenad-ize šukkayaŋ, ibula, nda iciray henna, nda iciray zaram yakuwante daŋ. ");
INSERT INTO ses_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","I na guuru-izeyaŋ kaŋ ga hẽe tee nda wura alhakiika kʼi daŋ forkiyaa miɲoo kul bande grenad-izey game. ");
INSERT INTO ses_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Guuru-ize foo, grenad-ize foo, guuru-ize foo, grenad-ize foo, forkiyaa miɲoo kul bande, ka goyoo tee sanda takaa kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Woo banda ga, i na šukka baana darbay beerey tee Haruna nda nga izʼarey se, maale kʼi kay. ");
INSERT INTO ses_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","I na fatalaa tee nda šukka baana, i na fuulawey tee nda šukka baana, i na npogawey tee nda šukka baana. I mana teendi nda kala šukka baana yakuwante. ");
INSERT INTO ses_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Gamahawoo i nʼa tee nda šukka baana yakuwante, nda šukka bula, nda iciray henna, nda iciray zaram, maale kʼa kay, sanda takaa kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","I na teɲa taalam henanantaa tee, i nʼa tee nda wura alhakiika, i na hantum kar a ga kaŋ ga tee sanda tammaasa kaŋ ga nee: «A yeetandi jere ga Abadantaa se». ");
INSERT INTO ses_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Woo banda ga, i na karfu bula haw a ga kʼa dii fatalaa ga, sanda takaa kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Takaa woo nda Irkoy gorodogoo kaŋ ti cere kubayyan hukkumoo goyoo kul ben. Izirayel borey na hayaa kul tee ka sawa nda woo kaŋ nda Abadantaa na Musa yaamar, i nʼa tee nda takaa din da. ");
INSERT INTO ses_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","I koy nda Irkoy gorodogoo Musa do: hukkumoo nda nga jinawey kul, nda kanjihayey, nda bundu tefawey, nda hayey kaŋ ga gaaru-gaaru, nda ganjey, nda ferawey. ");
INSERT INTO ses_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Nda kuntaa kaŋ teendi nda gaaru kuuruyaŋ kaŋ cirayandi, nda kuntaa kaŋ teendi nda ayu kuuruyaŋ, nda zaaraa kaŋ ga tee rido. ");
INSERT INTO ses_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Nda seedetaraa sundukoo nda gobey, nda daabirjoo. ");
INSERT INTO ses_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Nda taabaloo nda nga jinawey kul, nda takulawey kaŋ jisandi Irkoy jine. ");
INSERT INTO ses_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Nda fitilla gorodoo henanantaa, nda fitillawey cere bande, nda nga jinawey kul, nda jiyoo kaŋ gʼi diinandi. ");
INSERT INTO ses_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Nda wura sargari tonadogoo, nda yonyan jiyoo, nda dugu hew kaanaa, nda ridowoo kaŋ goo hukkumoo miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Nda alhan sargari tonadogoo, nda nga alhan ham tonaguuroo, nda nga gobey, nda nga jinawey kul, nda taasa beeroo nda hayaa kaŋ ga a ga goro. ");
INSERT INTO ses_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Nda batumaa kuntawey, nda nga ganjey, nda nga ferawey, nda batumaa miɲoo ridowoo, nda nga karfey, nda nga sukahayey, nda jinawey kul kaŋ ga hima ka huru Irkoy gorodogoo kaŋ ti cere kubayyan hukkumoo goyoo ra. ");
INSERT INTO ses_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Nda bankaaray cere-cerantey kaŋ nda i ga goyoo tee nongu henanantaa ra, nda sargari juwalkaa Haruna bankaaray henanantey, nda nga izʼarey bankaarawey kaŋ nda i ga sargari juwalyan goyoo tee. ");
INSERT INTO ses_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Izirayel borey na goyoo kul tee sanda takaa kul kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Musa dii goyoo kul, nga ne, i nʼa tee nda takaa kaŋ nda Abadantaa nʼa yaamar, i nʼa tee nda takaa din da. Musa gaara i se. ");
INSERT INTO ses_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«Handu jinaa zaari jinaa ma Irkoy gorodogoo kaŋ ti cere kubayyan hukkumoo cin. ");
INSERT INTO ses_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Ma seedetaraa sundukoo daŋ a ra, ma ridowoo kʼa jejebu. ");
INSERT INTO ses_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Ma kate taabaloo, ma hayey hanse a ga kaŋ ga hima ka hansandi. Ma kate fitilla gorodogoo, ma fitillawey daŋ a ga. ");
INSERT INTO ses_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ma wura dugu dullandidogoo daŋ sundukoo jine, ma ridowoo daŋ Irkoy gorodogoo miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Ma sargari kukurantey tonadogoo daŋ Irkoy gorodogoo kaŋ ti cere kubayyan hukkumoo, miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Ma taasa beeroo daŋ cere kubayyan hukkumoo nda sargari tonadogoo game, ma hari daŋ a ra. ");
INSERT INTO ses_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ma batumaa kuubi-ka-beraa kayandi, ma ridowoo daŋ batumaa miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Ma yonyan jiyoo zaa ka hugoo nda haya kul kaŋ goo a ra yon, ma nga nda nga jinawey kul yeeti jere ga ya ne, a ga tee haya henanante. ");
INSERT INTO ses_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ma sargari kukurantey tonadogoo nda nga jinawey kul yon, mʼa yeeti jere ga ya ne hala a ma tee haya kaŋ ga hanse ka henan. ");
INSERT INTO ses_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ma taasa beeroo yon, nga nda hayaa kaŋ ga a ga goro, mʼa yeeti jere ga ya ne. ");
INSERT INTO ses_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Ma Haruna nda nga izʼarey manandi cere kubayyan hukkumoo miɲoo ga, mʼi ɲumay nda hari. ");
INSERT INTO ses_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ma bankaaray henanantey daŋ Haruna ga, mʼa yon, de mʼa yeeti jere ga ya ne hala a ma sargari juwalkaw goyoo tee ya ne. ");
INSERT INTO ses_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ma nga izʼarey mo manandi ka darbay beerey daŋ i ga. ");
INSERT INTO ses_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Mʼi yon sanda ngi baabaa takaa hala i ma ngi sargari juwalyan goyoo tee ya ne, ngi yonyanoo ga tee hayaa kaŋ ga kate i ma ngi sargari juwalyan goyoo tee ya ne hala abada ngi alwaddawey ra.» ");
INSERT INTO ses_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Musa na hayey kul tee nda takaa kaŋ nda Abadantaa nʼa yaamar. A nʼa tee nda takaa din da. ");
INSERT INTO ses_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Jiiri hinkantoo handu jinaa zaari jinaa Irkoy gorodogoo cinandi. ");
INSERT INTO ses_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Musa na Irkoy gorodogoo cin, a na ferawey daŋ, a na bundu tefawey kayandi, a na gaaru-gaarey daŋ, a na ganjey kayandi. ");
INSERT INTO ses_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","A na hukkumoo daŋ Irkoy gorodogoo ga, a na hukkumoo daabandoo daŋ a ga sanda takaa kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","A na seedetaraa hantumoo zaa kʼa daŋ sundukoo ra, a na sundukoo gobey daŋ, a na daabirjoo gum a ga. ");
INSERT INTO ses_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","A na sundukoo ka koy Irkoy gorodogoo ra, a na zaaraa daŋ kaŋ ga tee rido, ka seedetaraa sundukoo jejebu sanda takaa kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","A na taabaloo daŋ cere kubayyan hukkumoo ra, Irkoy gorodogoo hawsa kaboo here, ridowoo se tarayhere. ");
INSERT INTO ses_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","A na takulawey hanse kʼi daŋ cere bande Abadantaa jine, sanda takaa kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","A na fitilla gorodogoo daŋ cere kubayyan hukkumoo ra, a ga taabaloo tenje, Irkoy gorodogoo gurma kaboo here. ");
INSERT INTO ses_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","A na fitillawey daŋ Abadantaa jine sanda takaa kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","A na wura sargari tonadogoo daŋ cere kubayyan hukkumoo ra, ridowoo jinoo ra. ");
INSERT INTO ses_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","A na dugu hew kaanaa dullandi a ga, sanda takaa kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","A na ridowoo daŋ hugoo miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","A na sargari kukurantey tonadogoo daŋ cere kubayyan hukkumoo hugoo miɲoo ga, a na sargari kukurantaa kaa a ga, a na taasu sargaroo kaa, sanda takaa kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","A na taasa beeroo daŋ cere kubayyan hukkumoo nda sargari tonadogoo game, a na hari daŋ a ra ka alwala. ");
INSERT INTO ses_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Musa, nda Haruna nda nga izʼarey na ngi kabey nda ngi cewey ɲumay a ra. ");
INSERT INTO ses_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Waati kaŋ i ga huru cere kubayyan hukkumoo ra, nda waati kaŋ i ga too sargari tonadogoo do, i ga ɲumay, sanda takaa kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","A na batumaa cin ka Irkoy gorodogoo nda sargari tonadogoo kuubi kʼa bere, a na ridowoo daŋ batumaa miɲoo ga. Takaa woo nda Musa na goyoo tee kʼa benandi. ");
INSERT INTO ses_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Duulaa na cere kubayyan hukkumoo gum, de Abadantaa daržaa na Irkoy gorodogoo too. ");
INSERT INTO ses_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Musa mana hin ka huru cere kubayyan hukkumoo ra, zama duulaa cindi a ga, de Abadantaa daržaa na Irkoy gorodogoo too. ");
INSERT INTO ses_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Waati kaŋ duulaa tun Irkoy gorodogoo boŋ, nga no Izirayel borey ga koy jine ngi naarumaa ra. I ga koy nongu nda nongu. ");
INSERT INTO ses_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Nda duulaa mana tun, i si koy hala han kaŋ a tun. ");
INSERT INTO ses_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Zama zaari here Abadantaa duulaa goo Irkoy gorodogoo boŋ, cijin here nuune ga dii duulaa ra, Izirayel hugoo borey kul jine, woo teendi ngi naarumaa kul ra, nongu ka koy nongu.");
INSERT INTO ses_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Abadantaa na Musa cee cere kubayyan hukkumoo do ka šelaŋ a se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","«Šelaŋ Izirayel borey se, nee i se: ‹Nda boro foo war ra ga baa nga ma adabba tee sargari Abadantaa maaɲoo ga, a mʼa kaa alman beerey wala ibuuney ra. ");
INSERT INTO ses_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Nda hayaa kaŋ a gʼa kaa manʼti kala haw-ize sargari kukurante, a ma tee aru kaŋ ga malal sii, a ma sargaroo kaa cere kubayyan hukkumoo miɲoo ga hala Abadantaa ma duu kʼa taa. ");
INSERT INTO ses_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","A ma nga kaboo fur sargari kukurantaa almanoo boŋoo ga, Abadantaa gʼa taa, ka nga zunubey tuusu. ");
INSERT INTO ses_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","A ma haw-izoo koosu Abadantaa jine. Haruna izʼarey, sargari juwalkey ma kate kuroo kʼa say-say sargari tonadogoo carawey bande kaŋ goo cere kubayyan hukkumoo miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Boraa ma hawoo fooru kʼa dunbu-dunbu. ");
INSERT INTO ses_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Sargari juwalkaa Haruna izʼarey ma nuune daŋ sargari tonadogoo boŋ ka tuuri kanandi nuunaa boŋ. ");
INSERT INTO ses_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Haruna izʼarey, sargari juwalkey ma ham dunbu-dunbantey, nda boŋoo, nda maanoo kanandi tuurey boŋ nuunaa ga kaŋ goo sargari tonadogoo boŋ. ");
INSERT INTO ses_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","A ma teeley nda kobsey ɲumay nda hari, sargari juwalkaa mʼi kul dullandi sargari tonadogoo boŋ. Sargari kukurante no, sargari tonante kaŋ sunnaaraa ga kan Abadantaa se. ");
INSERT INTO ses_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Nda nga sargaroo si hun kala alman buuney ra ka tee sargari kukurante, a ma tee feeji wala hancin, aru kaŋ ga malal sii. ");
INSERT INTO ses_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","A mʼa koosu sargari tonadogoo hawsa caraa here hukkumoo tenje Abadantaa jine. Haruna izʼarey, sargari juwalkey ma kuroo say-say sargari tonadogoo carawey bande. ");
INSERT INTO ses_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","A mʼa dunbu-dunbu, boŋoo nda maanoo goo a ra. Sargari juwalkaa mʼi kanandi tuurey boŋ nuunaa ga kaŋ goo sargari tonadogoo boŋ. ");
INSERT INTO ses_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","A ma teeley nda kobsey ɲumay nda hari. Sargari juwalkaa mʼi kul dullandi kʼi sarga sargari tonadogoo boŋ. Sargari kukurante no, sargari tonante kaŋ sunnaaraa ga kan Abadantaa se. ");
INSERT INTO ses_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Nda nga sargaroo si hun kala cirawey ra ka tee sargari kukurante Abadantaa se, a ma tee gubaguba wala tuuzun-ize. ");
INSERT INTO ses_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Sargari juwalkaa mʼa sarga sargari tonadogoo boŋ, a ma boŋoo kaa kʼa dullandi sargari tonadogoo boŋ, de kuroo ma doorandi sargari tonadogoo caraa ga. ");
INSERT INTO ses_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","A ma zunduroo dogu, nga nda hayey kaŋ goo a ra kʼi warra sargari tonadogoo jeroo ga, waynahunay here, nongoo kaŋ ra i ga boosey daŋ. ");
INSERT INTO ses_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","A ma fatawey nda cere game kottu bila i ma hun cere ga. Sargari juwalkaa mʼa dullandi sargari tonadogoo tuuroo boŋ kaŋ goo nuunaa ra. Sargari kukurante no, sargari tonante kaŋ sunnaaraa ga kan Abadantaa se.›» ");
INSERT INTO ses_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","«‹Nda boro ga baa ma taasu sargari tee Abadantaa maaɲoo ga, sargaroo ma tee farin hamni, a ma jii doori a boŋ ka dugu fur a ga. ");
INSERT INTO ses_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","A mʼa ka koy Haruna izʼarey se kaŋ ti sargari juwalkey. A ma nga kaboo too farin hamnoo ra kʼa haŋandi nda jii, nda dugoo kul. Sargari juwalkaa mʼa dullandi sargari tonadogoo boŋ sanda hongandihaya. Sargari tonante no kaŋ sunnaaraa ga kan Abadantaa se. ");
INSERT INTO ses_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Taasu sargaroo cindoo, Haruna nda nga izʼarey ma duu a. Baa no kaŋ ga hanse ka henan, zama a mana hun kala sargari tonantey ra Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Nda nʼga baa ma taasu sargari kaa kaŋ tonandi alforon ra, a ma tee farin hamni, wijilayaŋ kaŋ loobandi nda jii bila dolobiri nda furmeyaŋ kaŋ yonandi nda jii bila dolobiri. ");
INSERT INTO ses_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Nda ni taasu sargaroo mma tonandi guuru boŋ, a ma tee farin hamni kaŋ loobandi nda jii bila dolobiri. ");
INSERT INTO ses_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Mʼa dunbu-dunbu ka jii doori a boŋ. Woo ti taasu sargari. ");
INSERT INTO ses_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Nda ni taasu sargaroo mma tonandi pol ra, a ma tee nda farin hamni nda jii. ");
INSERT INTO ses_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Ma koy nda taasu sargaroo kaŋ hansandi hayey wey ra Abadantaa do, i mʼa noo sargari juwalkaa se, a ma koy nda a sargari tonadogoo ra. ");
INSERT INTO ses_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Sargari juwalkaa ma hayaa kaa sargaroo ra kaŋ ga tee hongandihaya, a mʼa dullandi sargari tonadogoo boŋ. Sargari tonante no kaŋ sunnaaraa ga kan Abadantaa se. ");
INSERT INTO ses_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Taasu sargaroo cindoo, Haruna nda nga izʼarey ma duu a. Baa no kaŋ ga hanse ka henan, zama a mana hun kala sargari tonantey ra Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Taasu sargari kul kaŋ war gʼa tee Abadantaa maaɲoo ga, dolobiri si hima ka huru a ra. Abada dolobiri dumi kul wala yuu dumi kul masi huru war sargari tonantey ra Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Dumaray-ize jina-jinawey, war mʼi tee sargari Abadantaa maaɲoo ga, amma i masi tonandi sargari tonadogoo boŋ sanda sunnaara kaana. ");
INSERT INTO ses_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Taasu sargari kul, ma ciiri fur a boŋ. Masi naŋ ciiroo ma kuma, zama ciiri ti amaanaa tammaasaa ni nda ni Koyoo game. Ma ciiri daŋ sargari kul ga. ");
INSERT INTO ses_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Nda nʼga baa ma dumari-ize jina-jinawey tee sargari Abadantaa maaɲoo ga, mʼa tee nda jeeniyaŋ kaŋ kukurandi nuune ra, ma taasoo tutubu kʼa kaa, a ma tee ni dumaray-ize jina-jinawey taasu sargari. ");
INSERT INTO ses_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Ma jii doori a boŋ ka dugu fur a ga. Woo ti taasu sargari. ");
INSERT INTO ses_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Sargari juwalkaa ma taasu tutubantaa jere foo, nda jii, nda dugoo kul dullandi sanda hongandihaya. Sargari tonante no Abadantaa maaɲoo ga.›» ");
INSERT INTO ses_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","«‹Nda boro sargaroo si hun kala hawey ra ka tee alaafiya teendi sargaroo, nda aru no wala woy, a ma tee alman kaŋ ga malal sii, a mʼa ka koy Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","A ma nga kaboo fur nga sargaroo boŋoo ga kʼa koosu cere kubayyan hukkumoo miɲoo ga. Haruna izʼarey, sargari juwalkey ma kuroo say-say sargari tonadogoo carawey bande. ");
INSERT INTO ses_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Alaafiya teendi sargaroo woo ra a ma nonguyaŋ kaa Abadantaa maaɲoo ga kʼi tee sargari tonante. Nongey ti: maanoo kaŋ ga teeley daabu, nda teeley maanoo kul, ");
INSERT INTO ses_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","nda dumay-ɲaa-guuri hinkaa, nda maanoo kaŋ gʼi daabu kaŋ ga koy hala caraa ga, nda tasa-izoo kaŋ goo tasaa ga, a mʼa kaa dumay-ɲaa-guurey bande. ");
INSERT INTO ses_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Haruna izʼarey mʼi dullandi sargari tonadogoo boŋ nda sargari kukurantaa kaŋ goo nuunaa tuurey boŋ. Sargari tonante no kaŋ sunnaaraa ga kan Abadantaa se. ");
INSERT INTO ses_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Nda nga sargaroo si hun kala alman buuney ra ka tee alaafiya teendi sargaroo Abadantaa maaɲoo ga, aru no wala woy, a ma tee alman kaŋ ga malal sii. ");
INSERT INTO ses_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Nda boraa sargaroo ti feeji, a mʼa ka koy Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","A ma nga kaboo fur sargaroo boŋoo ga kʼa koosu cere kubayyan hukkumoo jine. Haruna izʼarey ma kuroo say-say sargari tonadogoo carawey bande. ");
INSERT INTO ses_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Alaafiya teendi sargaroo woo ra a ma maanoo nonguyaŋ kaa Abadantaa maaɲoo ga kʼi tee sargari tonante. Nongey ti: šuwalaa timmantaa, a mʼa kaa hala birigaaroo ga, nda maanoo kaŋ ga teeley daabu, nda teeley maanoo kul, ");
INSERT INTO ses_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","nda dumay-ɲaa-guuri hinkaa, nda maanoo kaŋ gʼi daabu kaŋ ga koy hala caraa ga, nda tasa-izoo kaŋ goo tasaa ga, a mʼa kaa dumay-ɲaa-guurey bande. ");
INSERT INTO ses_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Sargari juwalkaa mʼi dullandi sargari tonadogoo boŋ. Ŋaayan no kaŋ tee sargari tonante Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Nda nga sargaroo ti hancin, boraa mʼa ka koy Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","A ma nga kaboo fur almanoo boŋoo ga kʼa koosu cere kubayyan hukkumoo jine. Haruna izʼarey ma kuroo say-say sargari tonadogoo carawey bande. ");
INSERT INTO ses_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Sargaroo woo ra a ma nonguyaŋ kaa Abadantaa maaɲoo ga kʼi tee sargari tonante. Nongey ti: maanoo kaŋ ga teeley daabu, nda teeley maanoo kul, ");
INSERT INTO ses_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","nda dumay-ɲaa-guuri hinkaa, nda maanoo kaŋ gʼi daabu kaŋ ga koy hala caraa ga, nda tasa-izoo kaŋ goo tasaa ga, a mʼa kaa dumay-ɲaa-guurey bande. ");
INSERT INTO ses_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Sargari juwalkaa mʼi dullandi sargari tonadogoo boŋ. Ŋaayan no kaŋ tee sargari tonante kaŋ sunnaaraa ga kan. Maanoo kul ti Abadantaa wane. ");
INSERT INTO ses_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Hantum kaŋ si tun ne war alwaddawey se, nongu kul kaŋ ra war goro: war masi maani kul ŋaa, war masi kuri kul ŋaa.›» ");
INSERT INTO ses_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","«Šelaŋ Izirayel borey se ka nee: ‹Nda boro firka ka zunubu tee ka yaamarey kul kaŋ ga bara affoo hoo kaŋ Abadantaa nʼa gay a masʼa tee, amma a na affoo hoo i ra, ");
INSERT INTO ses_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","nda sargari juwalkaa kaŋ yonandi no ka zunuboo tee, de nga bande a na jamaa kaŋandi zunubu ra, nga zunuboo kaŋ a nʼa tee se, a ma yaaru kaŋ ga malal sii tee zunubu sargari Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","A ma yaaroo ka koy cere kubayyan hukkumoo miɲoo ga Abadantaa jine. A ma nga kaboo fur yaaroo boŋoo ga, a mʼa koosu Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Sargari juwalkaa kaŋ yonandi ma zaa yaaroo kuroo ra kʼa ka koy cere kubayyan hukkumoo do. ");
INSERT INTO ses_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","A ma nga kabe-izoo sufa kuroo ra kʼa say-say cee iyye Abadantaa jine, nongu henanantaa ridowoo jine. ");
INSERT INTO ses_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","A ma zaa kuroo ra kʼa daŋ dugu hew kaaney dullandidogoo hilley ga kaŋ goo Abadantaa jine, cere kubayyan hukkumoo ra. A ma yaaroo kuroo cindoo kul doori sargari kukurantey tonadogoo gandahere kaŋ goo cere kubayyan hukkumoo miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","A ma zunubu sargaroo yaaroo maanoo kul kaa, maanoo kaŋ ga teeley daabu nda maanoo kul kaŋ goo teeley ga, ");
INSERT INTO ses_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","nda dumay-ɲaa-guuri hinkaa, nda maanoo kaŋ gʼi daabu kaŋ ga koy hala caraa ga, nda tasa-izoo kaŋ goo tasaa ga, a mʼa kaa dumay-ɲaa-guurey bande, ");
INSERT INTO ses_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","sanda takaa kaŋ nda i gʼi kaa alaafiya teendi sargaroo yaaroo ra. Sargari juwalkaa mʼi dullandi sargari kukurantey tonadogoo boŋ. ");
INSERT INTO ses_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Amma yaaroo kuuroo, nda nga bašoo kul, nda boŋoo, nda kobsey, nda teeley nda ngi žiiboo, ");
INSERT INTO ses_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","yaaru timmantaa, a mʼa ka koy jamaa kaloo se taray nongu henanante kaŋ ra i ga boosey mun, de a mʼa ton tuuri nuune boŋ, nongoo kaŋ ra i ga boosey mun ra a ga tonandi.›» ");
INSERT INTO ses_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","«‹Nda Izirayel jamaa kul firka ka zunubu tee bila nda i ma bay, de i na yaamarey kul kaŋ ga bara affoo hoo kaŋ Abadantaa nʼi gay i masʼa tee, i duu zunubu. ");
INSERT INTO ses_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Waati kaŋ zunuboo kaŋ i nʼa tee ka yaamaroo hoo bayrandi, jamaa ma yaaru kaa zunubu sargari, de i mʼa ka koy cere kubayyan hukkumoo jine. ");
INSERT INTO ses_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Jamaa boro beerey ma ngi kabey fur yaaroo boŋoo ga Abadantaa jine, de affoo i ra mʼa koosu jinoo ra. ");
INSERT INTO ses_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Sargari juwalkaa kaŋ yonandi ma zaa yaaroo kuroo ra ka kate nda a cere kubayyan hukkumoo ra. ");
INSERT INTO ses_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","A ma nga kabe-izoo sufa kuroo ra kʼa say-say cee iyye Abadantaa jine, ridowoo ga. ");
INSERT INTO ses_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","A ma zaa kuroo ra kʼa daŋ sargari tonadogoo hilley ga Abadantaa jine, cere kubayyan hukkumoo ra. A ma kuroo cindoo kul doori sargari kukurantey tonadogoo cewey ga kaŋ goo cere kubayyan hukkumoo miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","A ma maanoo kul kaa kʼa dullandi sargari tonadogoo boŋ. ");
INSERT INTO ses_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","A ma yaaroo tee sanda takaa kaŋ a nʼa tee zunubu sargaroo yaaroo se. Woo no a mʼa tee a se. Sargari juwalkaa ma zunubu tuusuyanoo tee i se, de i ga yaafandi. ");
INSERT INTO ses_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","A ma yaaroo ka fatta ka koy jamaa kaloo se taray kʼa ton sanda takaa kaŋ nda a na ijinaa ton. Zunubu sargari no jamaa se.›» ");
INSERT INTO ses_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","«‹Nda boŋkoyni na zunubu tee ka firka ka yaamarey kul kaŋ ga bara affoo hoo kaŋ Abadantaa, nga Koyoo nʼa gay a masʼa tee, a duu zunubu. ");
INSERT INTO ses_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Nda a bay zunuboo ga kaŋ nga nʼa tee, a ma hancin kaa sargari, aru kaŋ ga malal sii. ");
INSERT INTO ses_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","A ma nga kaboo fur hancinoo boŋoo ga, a mʼa koosu nongoo kaŋ ra i ga sargari kukurantey almaney koosu Abadantaa jine. Zunubu sargari no. ");
INSERT INTO ses_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Sargari juwalkaa ma nga kabe-izoo ka zaa zunubu sargaroo kuroo ra, a mʼa daŋ sargari kukurantey tonadogoo hilley ga, a ma kuroo cindoo doori sargari kukurantey tonadogoo gandahere. ");
INSERT INTO ses_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","A ma maanoo kul dullandi sargari tonadogoo boŋ sanda alaafiya teendi sargaroo maanoo. Sargari juwalkaa ma zunubu tuusuyanoo tee boŋkoynoo se nga zunuboo se, de a ga yaafandi.›» ");
INSERT INTO ses_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","«‹Nda gandaa ra, jamaa boro foo na zunubu tee ka firka ka yaamarey affoo hoo kaŋ Abadantaa nʼa gay a masʼa tee, a duu zunubu. ");
INSERT INTO ses_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Nda a bay nga zunuboo ga kaŋ nga nʼa tee, a ma hancin woy kaŋ ga malal sii kaa sargari nga zunubu kaŋ a nʼa tee se. ");
INSERT INTO ses_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","A ma nga kaboo fur zunubu sargaroo almanoo boŋoo ga, a mʼa koosu nongoo kaŋ ra i ga sargari kukurantey almaney koosu. ");
INSERT INTO ses_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Sargari juwalkaa ma nga kabe-izoo ka zaa kuroo ra, a mʼa daŋ sargari kukurantey tonadogoo hilley ga, a ma kuroo cindoo kul doori sargari tonadogoo gandahere. ");
INSERT INTO ses_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","A ma maanoo kul kaa, sanda takaa kaŋ nda i ga alaafiya teendi sargaroo maanoo kaa, a mʼa dullandi sargari tonadogoo boŋ, a ga tee sunnaara kaana Abadantaa se. Sargari juwalkaa ma zunubu tuusuyanoo tee a se, de a ga yaafandi. ");
INSERT INTO ses_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Nda feeji no a kate a ma tee zunubu sargari, a ma tee woy kaŋ ga malal sii. ");
INSERT INTO ses_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","A ma nga kaboo fur zunubu sargaroo almanoo boŋoo ga, a mʼa koosu kʼa tee zunubu sargari, nongoo kaŋ ra i ga sargari kukurantey almaney koosu. ");
INSERT INTO ses_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Sargari juwalkaa ma nga kabe-izoo zaa zunubu sargaroo kuroo ra, a mʼa daŋ sargari kukurantey tonadogoo hilley ga, a ma kuroo cindoo kul doori sargari tonadogoo gandahere. ");
INSERT INTO ses_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","A ma maanoo kul kaa, sanda takaa kaŋ nda i ga alaafiya teendi sargaroo feejoo maanoo kaa, a mʼa dullandi sargari tonadogoo boŋ sargari tonantey bande Abadantaa maaɲoo ga. Sargari juwalkaa ma zunubu tuusuyanoo tee a se nga zunuboo se kaŋ a nʼa tee, de a ga yaafandi.›» ");
INSERT INTO ses_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","«‹Nda boro maa dangayan, a dii hayaa kaŋ se dangayanoo teendi wala a bay, a ga tee seede, nda a wanji kʼa har, a na zunubu tee, a ga nga layboo zaa. ");
INSERT INTO ses_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Boro kaŋ tuku haya kul kaŋ no ga kaŋ ga harram, a ma tee hooga jifa harramante, wala adabba biirante jifa harramante, wala gandako jifa harramante, ba nda a mana bay, boraa hunday žiibi, a duu zunubu. ");
INSERT INTO ses_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Wala mo boro, nda a tuku adamize žiibi ga, a ma tee žiibi dumi kul kaŋ no kaŋ ga boro žiibandi, ba nda a mana bay, nda a kaa ka bay, a duu zunubu. ");
INSERT INTO ses_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Boro kaŋ goo ma šelaŋ bila nda lakkal hala a žee, haya kul kaŋ ga no, a ma tee ihenna wala ifutu, ba nda a mana bay, nda a kaa ka bay, a duu zunubey wey affoo. ");
INSERT INTO ses_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Boro kaŋ duu zunubey wey affoo, a ma hayaa har kaŋ zunuboo no a nʼa tee. ");
INSERT INTO ses_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Woo banda ga, a ma nga tooɲe sargaroo noo Abadantaa maaɲoo ga, nga zunuboo kaŋ a nʼa tee maaganda se alman buuna woy, maanaa feeji woy wala hancin woy, no ma tee zunubu sargari. Woo ga, sargari juwalkaa ma zunubu tuusuyanoo tee a se nga zunuboo se.›» ");
INSERT INTO ses_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","«‹Nda boro hinoo si too alman buuna kʼa sarga zunuboo kaŋ a nʼa tee se, a ma kate gubaguba hinka wala tuuzun-ize hinka Abadantaa maaɲoo ga kʼi tee tooɲe sargari, affoo ma tee zunubu sargari, affaa ma tee sargari kukurante. ");
INSERT INTO ses_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","A ma kate ey sargari juwalkaa se, zunuboo wanoo, a mʼa kaa sargari jina, a ma boŋoo kaa jindoo ga bila nda a mʼa dogu. ");
INSERT INTO ses_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Sargari juwalkaa ma zaa zunubu sargaroo ciraa kuroo ra kʼa say-say sargari tonadogoo caraa ga, de kuroo cindoo ma doorandi sargari tonadogoo gandahere, zunubu sargari no. ");
INSERT INTO ses_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Ciraw hinkantoo, a mʼa tee sargari kukurante ka sawa nda hantumoo kaŋ kayandi. Sargari juwalkaa ma zunubu tuusuyanoo tee a se nga zunuboo se kaŋ a nʼa tee, de a ga yaafandi. ");
INSERT INTO ses_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Nda boraa kaŋ na zunubu tee hinoo si too gubaguba hinka wala tuuzun-ize hinka, a ma farin hamni kilo hinza sarga, a ma tee zunubu sargari. A masi jii doori a boŋ, a masi dugu fur a ga, zama zunubu sargari no. ");
INSERT INTO ses_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","A mʼa ka koy sargari juwalkaa do, sargari juwalkaa ma nga kaboo too zanboo ra kaŋ ga tee hongandihaya kʼa dullandi sargari tonadogoo boŋ, nga nda sargari tonantey Abadantaa maaɲoo ga, zunubu sargari no. ");
INSERT INTO ses_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Sargari juwalkaa ma zunubu tuusuyanoo tee a se nga zunuboo se kaŋ a nʼa tee ka yaamarey wey affoo hoo, de a ga yaafandi. Woo kaŋ cindi, sargari juwalkaa ma duu a sanda taasu sargaroo.›» ");
INSERT INTO ses_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","«Nda boro firka ka tooɲe ka zunubu tee ka hayey kaŋ jisandi Abadantaa maaɲoo ga dii, a ma tooɲe sargari tee Abadantaa maaɲoo ga ka gaaru zaa alman buuney ra kaŋ ga malal sii kaŋ alkadaroo kaŋ kayandi ga too nzorfu kaaray tammaa alkadaroo, a ma sawa nda nongu henanantaa nzorfu tammaa. Almanoo ma tee tooɲe sargari. ");
INSERT INTO ses_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Tooɲaa kaŋ a nʼa tee nongu henanantaa se, a mʼa hanse ka hayaa yeeti ka affoo tonton igguu foo kul ga, a mʼa noo sargari juwalkaa se. Sargari juwalkaa ma zunubu tuusuyanoo tee a se nda nga gaaroo kʼa sarga kʼa tee tooɲe sargari, de a ga yaafandi. ");
INSERT INTO ses_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Nda boro kaŋ na zunubu tee ka yaamarey kul kaŋ ga bara affoo hoo kaŋ Abadantaa nʼa gay a masʼa tee bila nda a ma bay, a duu zunubu, de a ga nga layboo zaa. ");
INSERT INTO ses_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","A ma gaaru kaŋ ga malal sii zaa alman buuney ra kaŋ nga alkadaroo kaŋ kayandi ga too, a ma tooɲe sargari tee kʼa ka koy sargari juwalkaa do. Sargari juwalkaa ma firkayanoo kaŋ boraa nʼa tee bila nda a ma bay zunubu tuusuyanoo tee a se, de a ga yaafandi. ");
INSERT INTO ses_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Tooɲe sargari no, zama boraa din, šikka sii a duu zunubu Abadantaa do.» ");
INSERT INTO ses_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","«Boro kaŋ na zunubu tee ka Abadantaa tooɲe ka nga gandaa boro zanba jinay jisante ga, a nka nondi a se wala zaytaray jinay no, wala a nka nga gandaa boro kom, ");
INSERT INTO ses_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","wala a na haya kurma kaŋ dere, de a na yankar, wala a žee taari ga, zunubey kul kaŋ adamize gʼi tee, affoo ga, ");
INSERT INTO ses_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","waati kaŋ boraa na zunuboo woo tee, a tooɲe, a ma jinaa kaŋ a nʼa zay, wala a nʼa kom, wala jinay no kaŋ i nʼa talfi a ga, wala a nka haya derante kurma, a mʼa yeeti. ");
INSERT INTO ses_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","Wala mo a ma tee haya kul kaŋ ga a taari ka žee. A mʼa yeeti a ga timme, ka affoo tonton igguu foo kul ga kʼa noo koyoo se, zaaroo kaŋ ra a ga tooɲe sargaroo kaa. ");
INSERT INTO ses_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","Woo banda ga, a ma kate nga tooɲe sargaroo Abadantaa maaɲoo ga: a ma koy nda sargari juwalkaa se gaaru kaŋ ga malal sii kaŋ nga alkadaroo ga too, a ma tee tooɲe sargari, a mʼa kaa alman buuney ra. ");
INSERT INTO ses_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","Sargari juwalkaa ma zunubu tuusuyanoo tee a se Abadantaa jine, de tooɲe dumi kul kaŋ no a nʼa tee ka duu zunubu ga yaafandi.» ");
INSERT INTO ses_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","«Haruna nda nga izʼarey yaamar ka nee: ‹Sargari kukurante ašariyaa ne: sargari kukurantaa, nga, a ma cindi sargari tonadogoo denjoo daŋdogoo ra cijinoo kul hala moo ma boo, sargari tonadogoo nuunaa ma cindi ka dii a boŋ. ");
INSERT INTO ses_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Woo banda ga, sargari juwalkaa ma nga leŋ šukka kaayi beeroo daŋ, de a ma nga leŋ šukka npogaa daŋ nga ga. A ma sargari kukurantaa kaŋ nuunaa nʼa ton sargari tonadogoo boŋ boosoo zaa kʼa daŋ sargari tonadogoo jeroo ga. ");
INSERT INTO ses_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Woo banda ga, a ma nga darbawey kaa ka darbay fooyaŋ daŋ. A ma boosoo ka koy jamaa kaloo se taray nongu ra kaŋ ga henan. ");
INSERT INTO ses_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Nuunaa ma cindi ka dii sargari tonadogoo boŋ, a masi buu. Sargari juwalkaa ma tuurey diinandi a boŋ, subbaahi kul ka sargari kukurantaa hanse, ka alaafiya teendi sargarey maaney dullandi. ");
INSERT INTO ses_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Nuunaa ga hima ka dii sargari tonadogoo boŋ alwaati kul, a masi buu. ");
INSERT INTO ses_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Taasu sargaroo ašariyaa ne: Haruna izʼarey mʼa sarga Abadantaa jine, sargari tonadogoo tenje. ");
INSERT INTO ses_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","A ma nga kaboo too taasu sargaroo hamni baanaa ra, nda nga jiyoo ra, nda dugoo kul kaŋ goo taasu sargaroo ga. A mʼa dullandi sargari tonadogoo boŋ. Sargari no kaŋ sunnaaraa ga kan, nga hongandihayaa no Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Woo kaŋ ga cindi a ra, Haruna nda nga izʼarey mʼa ŋaa, a ma ŋandi bila dolobiri, nongu henanante ra. I mʼa ŋaa cere kubayyan hukkumoo batumaa ra. ");
INSERT INTO ses_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","A masi hinandi nda dolobiri. Ngi bagaa no kaŋ ay nʼa noo i se sargari tonantey ra. Haya no kaŋ ga hanse ka henan, sanda zunubu sargari nda sanda tooɲe sargari. ");
INSERT INTO ses_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Aru kul kaŋ goo Haruna izey ra mʼa ŋaa. Yaamar kaŋ si tun no war alwaddawey se, sargari tonantey here Abadantaa maaɲoo ga. Haya kul kaŋ tuku a ga, ga yeetandi jere ga Irkoy se.›» ");
INSERT INTO ses_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Abadantaa yee ka šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","«Sargaroo ne kaŋ Haruna nda nga izʼarey mʼa kaa Abadantaa maaɲoo ga hanoo kaŋ i gʼa yon: farin hamni kilo hinza kaŋ ga tee taasu sargari alwaati kul, jere foo subbaahoo, jere faa cijinoo ra. ");
INSERT INTO ses_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Hamnoo ma hansandi guuru boŋ nda jii. Ma kate a, a ɲaami nda jii. Ma taasu sargaroo kaa a ma tee dunbu-dunbante kaŋ sunnaaraa ga kan Abadantaa se. ");
INSERT INTO ses_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Haruna izʼarey ra, sargari juwalkaa kaŋ ga yonandi ka huru dogoo ra ma sargaroo woo tee. Yaamar kaŋ si tun no, a kul ma dullandi Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Sargari juwalkaw taasu sargaroo kul ma tonandi hala a ma ben, a masi ŋandi.» ");
INSERT INTO ses_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Abadantaa yee ka šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","«Šelaŋ Haruna nda nga izʼarey se ka nee: ‹Zunubu sargaroo ašariyaa ne: nongoo kaŋ ra i ga sargari kukurantaa almanoo koosu, nga ra i ma zunubu sargaroo almanoo koosu Abadantaa jine. Haya no kaŋ ga hanse ka henan. ");
INSERT INTO ses_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Sargari juwalkaa kaŋ ga sargaroo kaa zunuboo se mʼa ŋaa, nongu henanante ra a ma ŋandi, cere kubayyan hukkumoo batumaa ra. ");
INSERT INTO ses_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Haya kul kaŋ tuku hamoo ga, ga henan. Nda kuroo ra haya say darbay ga, hayaa kaŋ ga a say mʼa ɲumandi nongu henanante ra. ");
INSERT INTO ses_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Labu kusoo kaŋ ra a hinandi ma kayrandi. Nda alhan kusu ra a hinandi, a ma žiirandi ka leelandi nda hari. ");
INSERT INTO ses_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Aru kul kaŋ goo sargari juwalkey hugey borey ra mʼa ŋaa. Haya no kaŋ ga hanse ka henan. ");
INSERT INTO ses_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Amma zunubu sargari kul kaŋ kuroo ra haya katandi cere kubayyan hukkumoo ra nongu henanantaa ra zunubu tuusuyanoo se masi ŋandi. A ma tonandi nuune ra ka tee boosu.›» ");
INSERT INTO ses_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","«‹Tooɲe sargaroo ašariyaa ne: haya no kaŋ ga hanse ka henan. ");
INSERT INTO ses_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Nongoo kaŋ ra i ga sargari kukurantaa almanoo koosu, nga ra i ma tooɲe sargaroo almanoo koosu, kuroo ma say-sayandi sargari tonadogoo carawey bande. ");
INSERT INTO ses_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Sargari juwalkaa ma maanoo kul sarga, nda šuwalaa, nda maanoo kaŋ ga teeley daabu, ");
INSERT INTO ses_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","nda dumay-ɲaa-guuri hinkaa, nda maanoo kaŋ gʼi daabu kaŋ ga koy hala caraa ga, nda tasa-izoo kaŋ goo tasaa ga, a mʼa kaa dumay-ɲaa-guurey bande. ");
INSERT INTO ses_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Sargari juwalkaa mʼi dullandi sargari tonadogoo boŋ sanda sargari tonante Abadantaa maaɲoo ga, tooɲe sargari no. ");
INSERT INTO ses_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Aru kul kaŋ goo sargari juwalkey hugey borey ra mʼa ŋaa. Nongu henanante ra a ma ŋandi. Haya no kaŋ ga hanse ka henan. ");
INSERT INTO ses_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Takaa kaŋ ti zunubu sargaroo, nga da ti tooɲe sargaroo, ašariyaa follokaa bara i se. Sargari juwalkaa kaŋ ga zunubu tuusuyanoo tee, nga no ma duu a. ");
INSERT INTO ses_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Sargari juwalkaa kaŋ na boro sargari kukurantaa tee, sargari kukurantaa kaŋ a nʼa kaa kuuroo, sargari juwalkaa no ma duu a, nga wane nda a. ");
INSERT INTO ses_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Taasu sargari kul kaŋ ga hinandi alforon ra wala haya kul kaŋ ga hansandi pol ra wala guuru boŋ, sargari juwalkaa kaŋ gʼa tee, nga no ma duu a. ");
INSERT INTO ses_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Taasu sargari kul kaŋ loobandi nda jii wala bila jii, Haruna izʼarey, ngi no ma duu a, i kul ma sawa a ra.›» ");
INSERT INTO ses_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","«‹Alaafiya teendi sargarey kaŋ ga teendi Abadantaa maaɲoo ga ašariyaa ne: ");
INSERT INTO ses_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","nda boro nʼa kaa albarka daŋyan se, a mʼa tee wijilayaŋ kaŋ ra dolobiri sii kaŋ loobandi nda jii, nda furmeyaŋ kaŋ ra dolobiri sii kaŋ yonandi nda jii, nda farin hamni kaŋ ɲaami nda jii ka tee wijila kaŋ loobandi nda jii albarka daŋyanoo kaŋ ti alaafiya teendi sargaroo bande. ");
INSERT INTO ses_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Nga albarka daŋyan sargaroo bande a ma furme tunanteyaŋ kaa alaafiya teendi sargaroo. ");
INSERT INTO ses_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Sargarey wey ra, dumi foo kul nongu foo ga hun Abadantaa maaɲoo ga, sargari juwalkaa kaŋ na alaafiya teendi sargaroo kuroo say-say, nga no ma duu a. ");
INSERT INTO ses_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Nga albarka daŋyanoo kaŋ ti alaafiya teendi sargaroo hamoo ma ŋandi hanoo hunday kaŋ a nʼa kaa, haya kul masi cindi hala suba subbaahoo ra. ");
INSERT INTO ses_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Nda boraa sargaroo manʼti kala meefur wala sargari kaŋ a gʼa kaa nda nga boŋ, nga sargaroo ma ŋandi zaaroo kaŋ a gʼa kaa, woo kaŋ ga cindi a ra ma ŋandi subaa ra. ");
INSERT INTO ses_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Woo kaŋ ga cindi sargaroo hamoo ra jirbi hinzantoo hane ma tonandi nuune ra ka tee boosu. ");
INSERT INTO ses_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Nda alaafiya teendi sargaroo hamoo ra haya ŋandi jirbi hinzantoo hane, sargaroo si taandi, boraa kaŋ nʼa kaa, a si duu nga nafaa, haya hasarante no, boro kaŋ nʼa ŋaa ga nga layboo zaa. ");
INSERT INTO ses_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Hamoo kaŋ too haya do kaŋ ga harram masi ŋandi, a ma tonandi nuune ra ka tee boosu. Hamoo hunday, boro kul kaŋ ga henan gʼa ŋaa. ");
INSERT INTO ses_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Amma boro kaŋ na alaafiya teendi sargaroo hamoo ŋaa kaŋ ti Abadantaa wane, nga žiiboo goo a ga, boraa din ga hun nga jamaa ra. ");
INSERT INTO ses_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Nda boro tuku haya kul kaŋ no ga kaŋ ga harram, adamize žiibi, wala alman harramante, wala haya wangante kul kaŋ ga harram, de a na alaafiya teendi sargaroo hamoo ŋaa kaŋ ti Abadantaa wane, boraa din ga hun nga jamaa ra.›» ");
INSERT INTO ses_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","«Šelaŋ Izirayel borey se ka nee: ‹War masi haw, wala feeji, wala hancin kul maanoo ŋaa. ");
INSERT INTO ses_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Jifa wala adabba kaŋ hooga nʼa wii maanoo ga hin ka yantasu hanse, amma war masʼa ŋaa kul. ");
INSERT INTO ses_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Zama boro kul kaŋ na alman maanoo ŋaa kaŋ ga tee sargari tonante Abadantaa maaɲoo ga, boraa kaŋ nʼa ŋaa ga hun nga jamaa ra. ");
INSERT INTO ses_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","War masi kuri kul ŋaa, nongu kul kaŋ ra war goro, a ma tee ciraw kuri wala alman kuri. ");
INSERT INTO ses_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Boro kul kaŋ na kuri kul kaŋ no ŋaa, boraa din ga hun nga jamaa ra.›» ");
INSERT INTO ses_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Abadantaa yee ka šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","«Šelaŋ Izirayel borey se ka nee: ‹Boro kaŋ na nga alaafiya teendi sargaroo daŋ Abadantaa jine, a ma Abadantaa bagaa kaŋ nda a ga hima kaa nga alaafiya teendi sargaroo ra. ");
INSERT INTO ses_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Nga kaboo ma kate sargari tonantey Abadantaa maaɲoo ga. A ma kate maanoo nda caraa kʼa zinji sanda sargari zinji-zinjante Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Sargari juwalkaa ma maanoo dullandi sargari tonadogoo boŋ. Caraa, Haruna nda nga izʼarey ma duu a. ");
INSERT INTO ses_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","War alaafiya teendi sargarey ra, war ma almanoo cee gumaa noo sargari juwalkaa se. ");
INSERT INTO ses_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Haruna izʼarey ra, boro kaŋ ga alaafiya teendi sargaroo kuroo nda maanoo sarga no ma duu almanoo cee gumaa sanda nga bagaa. ");
INSERT INTO ses_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Gandoo kaŋ hun sargari zinji-zinjantaa ra nda cewoo kaŋ hun sargaroo ra kaŋ i nʼa kaa, ay nʼi zaa Izirayel borey do kʼi noo sargari juwalkaa Haruna nda nga izʼarey se sanda yaamar kaŋ si tun.›» ");
INSERT INTO ses_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Woo ti bagaa kaŋ Haruna nda nga izʼarey ga duu a ngi yonyanoo se sargari tonantey ra Abadantaa maaɲoo ga, za hanoo kaŋ i ga man ka ngi sargari juwalyan goyoo tee Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Hayaa no kaŋ Abadantaa nʼa zaa Izirayel borey do kʼi yaamar hanoo kaŋ ra a nʼi yon. Hantum kaŋ si tun no ngi alwaddawey se. ");
INSERT INTO ses_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Woo ti sargari kukurantaa, nda taasu sargaroo, nda zunubu sargaroo, nda tooɲe sargaroo, nda sargari juwalkaa gorandiyanoo goyoo ra sargaroo, nda alaafiya teendi sargaroo ašariyaa ");
INSERT INTO ses_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","kaŋ Abadantaa na Musa yaamar Sinay tondi hondoo boŋ, Sinay saajoo ra hanoo kaŋ ra a na Izirayel borey yaamar i ma sargariyaŋ kaa nga maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","«Haruna zaa, nga nda nga izʼarey, nda darbawey, nda yonyan jiyoo, nda zunubu sargaroo yaaroo, nda gaaru hinkaa, nda takulawey kaŋ ra dolobiri sii dikaa. ");
INSERT INTO ses_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Ma alžamaa kul cee cere kubayyan hukkumoo miɲoo ga.» ");
INSERT INTO ses_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Hayaa kaŋ Abadantaa nʼa yaamar, Musa nʼa tee, alžamaa marga cere kubayyan hukkumoo miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Musa nee alžamaa se: «Hayaa ne kaŋ Abadantaa yaamar a ma teendi.» ");
INSERT INTO ses_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Woo banda ga, Musa na Haruna nda nga izʼarey manandi kʼi ɲumay nda hari. ");
INSERT INTO ses_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","A na kaayoo daŋ Haruna ga, a na centoo haw nda gamahawoo, a na forkiyaa daŋ a ga, a na beene kaayi-izoo kaŋ ga kotay kaayoo ga daŋ a ga, a na gamahawoo haw nda kaayi-izoo gamahawoo kʼa kuubi kʼa bere. ");
INSERT INTO ses_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","A na albaytoo daŋ gandey ga ka alkurraa goy jinawey kaŋ ti Urim nda Tumim daŋ albaytoo ra. ");
INSERT INTO ses_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","A na fatalaa didiji boŋoo ga, de fatalaa jineheroo ga, a na wura hiiri henanantaa daŋ, sanda takaa kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Woo banda ga, Musa na yonyan jiyoo zaa ka Irkoy gorodogoo nda haya kul kaŋ goo a ra yon kʼi daŋ jere ga Irkoy se. ");
INSERT INTO ses_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","A zaa a ra ka say-saya cee iyye sargari tonadogoo ga, a na sargari tonadogoo, nda nga jinawey kul, nda hanfi beeroo nda hayaa kaŋ ga a ga goro yon kʼi daŋ jere ga Irkoy se. ");
INSERT INTO ses_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","A na yonyan jiyoo doori Haruna boŋoo boŋ, a nʼa yon kʼa daŋ jere ga Irkoy se. ");
INSERT INTO ses_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Musa na Haruna izʼarey manandi, a na kaayi beeriyaŋ daŋ i ga, a na centey haw nda gamahaw, a na fuula daŋ i ga sanda takaa kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","A na zunubu sargaroo yaaroo manandi, Haruna nda nga izʼarey na ngi kabey fur zunubu sargaroo yaaroo boŋoo ga. ");
INSERT INTO ses_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","A koosandi, Musa na nga kabe-izoo ka zaa kuroo ra kʼa daŋ sargari tonadogoo hilley ga, carawey bande, a na sargari tonadogoo henanandi, a na kuroo cindoo doori sargari tonadogoo gandahere kʼa daŋ jere ga Irkoy se ka zunubu tuusuyanoo tee a se. ");
INSERT INTO ses_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","A na maanoo kul kaŋ ga teeley daabu, nda tasa-izoo, nda dumay-ɲaa-guuri hinkaa, nda ngi maanoo zaa kʼi dullandi sargari tonadogoo boŋ. ");
INSERT INTO ses_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Yaaroo, nda kuuroo, nda hamoo, nda žiiboo, a nʼi ton nuune ra jamaa kaloo se taray kʼi tee boosu, sanda takaa kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","A na sargari kukurantaa gaaroo manandi, Haruna nda nga izʼarey na kabe fur gaaroo boŋoo ga. ");
INSERT INTO ses_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","A koosandi, Musa na kuroo say-say sargari tonadogoo carawey bande. ");
INSERT INTO ses_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Feejoo dunbu-dunbandi, Musa na boŋoo, nda ham dunbu-dunbantey, nda maaney dullandi. ");
INSERT INTO ses_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Teeley nda kobsey ɲumandi nda hari, Musa na gaaroo kul dullandi sargari tonadogoo boŋ: sargari kukurante no kaŋ sunnaaraa ga kan, sargari tonante no Abadantaa maaɲoo ga sanda takaa kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Woo banda ga, Musa na gaaru hinkantoo manandi, sargari juwalkaa gorandiyanoo goyoo ra gaaroo kaŋ ga tee sargari no. Haruna nda nga izʼarey na ngi kabey fur gaaroo boŋoo ga. ");
INSERT INTO ses_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","A koosandi, Musa zaa kuroo ra, a nʼa daŋ Haruna haŋa gumaa deenoo ga, a daŋ nga kabe gumaa kobaaroo ga nda nga cee gumaa cew-ize beeroo ga. ");
INSERT INTO ses_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Musa na Haruna izʼarey manandi, a zaa kuroo ra kʼa daŋ ngi haŋa gumaa deeney ga, a daŋ ngi kabe gumaa kobaarey ga nda ngi cee gumaa cew-ize beerey ga. Woo banda ga, Musa na kuroo cindoo say-say sargari tonadogoo carawey bande. ");
INSERT INTO ses_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","A na maanoo, nda šuwalaa, nda maanoo kul kaŋ ga teeley daabu, nda tasa-izoo, nda dumay-ɲaa-guuri hinkaa nda ngi maanoo, nda cee gumaa zaa. ");
INSERT INTO ses_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Takulawey kaŋ ra dolobiri sii dikaa kaŋ ga jisi Abadantaa jine ra, a na wijila, nda wijila takula foo kaŋ loobandi nda jii, nda furme foo zaa a ra kʼi daŋ maaney nda cee gumaa ga. ");
INSERT INTO ses_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","A na wey kul daŋ Haruna nda nga izʼarey kabey ra, a nʼi zinji sanda sargari zinji-zinjante Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Woo banda ga, Musa nʼi kaa kabey ra, a nʼi dullandi sargari tonadogoo ga sargari kukurantaa boŋ kʼi tee sargari juwalkaa gorandiyanoo goyoo ra sargari, sargari tonante no kaŋ sunnaaraa ga kan Abadantaa se. ");
INSERT INTO ses_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Musa na almanoo caraa zaa kʼa zinji sanda sargari zinji-zinjante Abadantaa jine, sargari juwalkaa gorandiyanoo goyoo ra feejoo woo, nga ti Musa bagaa sanda takaa kaŋ nda Abadantaa nʼa yaamar. ");
INSERT INTO ses_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Musa na yonyan jiyoo zaa, nda kuroo kaŋ goo sargari tonadogoo boŋ, a say-saya Haruna nda nga darbawey ga, nga izʼarey nda ngi darbawey ga a bande, a na Haruna nda nga darbawey, nda nga izʼarey nda ngi darbawey a bande daŋ jere ga Irkoy goyoo se. ");
INSERT INTO ses_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Woo banda ga, Musa nee Haruna nda nga izʼarey se: «Wa hamoo hina cere kubayyan hukkumoo miɲoo ga, war mʼa ŋaa no din, nga nda takulaa kaŋ goo sargari juwalkaa gorandiyanoo goyoo ra dikaa ra sanda takaa kaŋ nda ay yaamar ka nee: ‹Haruna nda nga izʼarey mʼi ŋaa.› ");
INSERT INTO ses_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Hamoo nda takulaa cindoo, war mʼi ton nuune ra kʼi tee boosu. ");
INSERT INTO ses_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Woo banda ga, jirbi iyye war si hun cere kubayyan hukkumoo miɲoo ga, hala han kaŋ war daŋyanoo jere ga zaarey ma timme, zama jirbi iyye no war gʼa tee hala war daŋyanoo jere ga Irkoy goyoo se ga tabati. ");
INSERT INTO ses_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Hayaa kaŋ ir nʼa tee hõ, Abadantaa nʼa yaamar, hala war ma duu zunubu tuusuyan. ");
INSERT INTO ses_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","War ma cindi jirbi iyye cere kubayyan hukkumoo miɲoo ga cijin nda zaari, war ma hayaa dii kaŋ Abadantaa nʼa noo war se war mʼa dii hala war masi duu ka buu, zama woo ti hayaa kaŋ nda ay yaamarandi.» ");
INSERT INTO ses_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Haruna nda nga izʼarey na hayey kul tee kaŋ Abadantaa na Musa kʼi yaamar. ");
INSERT INTO ses_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Jirbi yaahantoo hane, Musa na Haruna, nda nga izʼarey, nda Izirayel boro beerey cee. ");
INSERT INTO ses_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","A nee Haruna se: «Yagaw zaa zunubu sargaroo se, nda gaaru sargari kukurantaa se kaŋ ga malal sii, ma kate ey Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Ma šelaŋ Izirayel borey se ka nee: ‹Wa jindaaru zaa zunubu sargaroo se, wa yagaw, nda feeji-ize kaŋyaŋ goo nda jiiri foo zaa, malal masi bara i ra, sargari kukurantaa se. ");
INSERT INTO ses_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Ma yaaru nda gaaru zaa alaafiya teendi sargaroo se kʼa kaa Abadantaa jine nda taasu sargari kaŋ loobandi nda jii, zama hõ Abadantaa ga bangay war se.›» ");
INSERT INTO ses_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Hayey kaŋ nda Musa nʼi yaamar, i nʼi zaa kate cere kubayyan hukkumoo jine, alžamaa kul man kate ka kay Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Musa nee: «Hayaa ne kaŋ Abadantaa nʼa yaamar war mʼa tee, de Abadantaa daržaa ga bangay war se.» ");
INSERT INTO ses_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Musa nee Haruna se: «Man sargari tonadogoo, ma ni zunubu sargaroo nda ni sargari kukurantaa kaa, ma zunubu tuusuyanoo tee ni nda jamaa se. Woo banda ga, ma jamaa sargaroo kaa, ma zunubu tuusuyanoo tee i se sanda takaa kaŋ nda Abadantaa na yaamar.» ");
INSERT INTO ses_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Haruna man kate sargari tonadogoo do, a na yagaa koosu kaŋ ti nga boŋ zunubu sargaroo. ");
INSERT INTO ses_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Haruna izʼarey kate a se kuroo, a na kabe-izoo sufa kuroo ra, a nʼa daŋ sargari tonadogoo hilley ga, a na kuroo cindoo doori sargari tonadogoo gandahere. ");
INSERT INTO ses_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","A na zunubu sargari maanoo, nda dumay-ɲaa-guurey, nda tasa-izoo kaŋ hun tasaa ga dullandi sargari tonadogoo boŋ sanda takaa kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Amma bašoo nda kuuroo, a nʼi ton nuune ra jamaa kaloo se taray kʼi tee boosu. ");
INSERT INTO ses_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Haruna na gaaroo koosu sargari kukurantaa se. Nga izʼarey nʼa noo kuroo, a nʼa say-say sargari tonadogoo carawey bande. ");
INSERT INTO ses_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","I nʼa noo sargari kukurantaa kaŋ dunbu-dunbandi, nda boŋoo, de a nʼi dullandi sargari tonadogoo boŋ. ");
INSERT INTO ses_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","A na teeley nda kobsey ɲumay kʼi dullandi sargari tonadogoo boŋ, sargari kukurantaa boŋ. ");
INSERT INTO ses_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Woo banda ga, a kate jamaa sargaroo: a na zunubu sargaroo jindaaroo dii kaŋ hun jamaa se, a nʼa koosu kʼa tee zunubu sargari, sanda cee jinaa takaa. ");
INSERT INTO ses_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","A kate sargari kukurantaa, a nʼa tee sanda takaa kaŋ hantumoo kaŋ kayandi nʼa har. ");
INSERT INTO ses_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","A kate taasu sargaroo, a na nga kaboo too a ra, a nʼa dullandi sargari tonadogoo boŋ ka tonton subbaahoo sargari kukurantaa ga. ");
INSERT INTO ses_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","A na alaafiya teendi sargaroo yaaroo nda gaaroo koosu kaŋ hun jamaa se. Nga izʼarey nʼa noo kuroo, a nʼa say-say sargari tonadogoo carawey bande. ");
INSERT INTO ses_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","I nʼa noo yaaroo nda gaaroo maaney, nda šuwalaa, nda hayaa kaŋ ga teeley daabu, nda dumay-ɲaa-guurey, nda tasa-izoo. ");
INSERT INTO ses_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","I na maaney daŋ carawey ga, i na maaney dullandi sargari tonadogoo boŋ. ");
INSERT INTO ses_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Haruna na carawey nda kabe gumaa zinji kʼi tee sargari zinji-zinjante Abadantaa jine sanda takaa kaŋ nda Musa nʼa yaamar. ");
INSERT INTO ses_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Haruna na nga kabey šerre jamaa here ka gaara i se. Woo banda ga, kaŋ a na zunubu sargaroo nda sargari kukurantaa nda alaafiya teendi sargaroo kaa ka ben, a zunbu ganda. ");
INSERT INTO ses_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Musa nda Haruna huru cere kubayyan hukkumoo ra. Kaŋ i fatta, i gaara jamaa se, de Abadantaa daržaa bangay alžamaa kul se. ");
INSERT INTO ses_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Nuune hun Abadantaa do ka sargari kukurantaa nda maaney ton sargari tonadogoo boŋ. Jamaa kul dii a, i kaati nda ɲaali, i na ngi ndumey ka sujudu. ");
INSERT INTO ses_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Haruna izʼarey, Nadab nda Abihu, affoo kul na nga dugu canboo zaa, i na nuune daŋ a ra ka dugu fur a boŋ, i na nuune kaŋ si bisa i se daŋ Abadantaa jine kaŋ a manʼi yaamar nda a. ");
INSERT INTO ses_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Nuune hun Abadantaa do, a nʼi halaci, i buu Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Musa nee Haruna se: «Woo ti hayaa kaŋ Abadantaa nʼa har ka nee: ‹Borey kaŋ ga too kate ay do, ay ma henanandi i do. Jamaa kul jine ya jeerandi.›» Woo banda ga, Haruna dangay. ");
INSERT INTO ses_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Musa ciya Mišel nda Elisafaŋ se, Uziyel izʼarey, Haruna baabaa armaa, ka nee i se: «Wa man kate ka war armey kaa nongu henanantaa jine kʼi ka koy jamaa kaloo se taray.» ");
INSERT INTO ses_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","I man kate, de i nʼi ka koy ngi kaayi beerey ra gorodogoo se taray sanda takaa kaŋ nda Musa nʼa har. ");
INSERT INTO ses_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Musa nee Haruna, nda nga izʼarey Eleyazar, nda Itamar se: «War masi war boŋey feeri, war masi war kaayey kottu hala war masi duu ka buu, hala Irkoy masi futu jamaa kul ga. Amma war armey, Izirayel hugoo borey kul ma borey hẽe kaŋ Abadantaa nʼi ton. ");
INSERT INTO ses_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","War masi hun cere kubayyan hukkumoo miɲoo ga hala war masi duu ka buu, zama Abadantaa yonyan jiyoo goo war ga.» I na hayaa tee kaŋ Musa nʼa har. ");
INSERT INTO ses_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Abadantaa šelaŋ Haruna se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«War masi alaneb hari moora haŋ, war masi harifutu haŋ, ni nda ni izʼarey ni bande, waati kaŋ war ga koy huru cere kubayyan hukkumoo ra hala war masi duu ka buu. Hantum kaŋ si tun no war alwaddawey se, ");
INSERT INTO ses_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","nga ra war ma haya henanante nda haya koonu fay kʼi kaa cere ra, ka iharramante nda ihalalante kaa cere ra, ");
INSERT INTO ses_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","ka Izirayel borey cawandi yaamarey kul kaŋ Abadantaa na Musa kʼi yaamar.» ");
INSERT INTO ses_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Musa nee Haruna, nda Eleyazar, nda Itamar, nga izʼarey kaŋ cindi se: «Wa taasu sargaroo zaa, woo kaŋ cindi sargari tonantey ra Abadantaa maaɲoo ga, wʼa ŋaa bila dolobiri sargari tonadogoo jeroo ga, zama haya no kaŋ ga hanse ka henan. ");
INSERT INTO ses_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","War mʼa ŋaa nongu henanante ra, zama woo ti ni bagaa nda ni izʼarey bagaa kaŋ war ga duu a sargari tonantey ra Abadantaa maaɲoo ga, zama woo nda ay yaamarandi. ");
INSERT INTO ses_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","War ma gandoo kaŋ hun sargari zinji-zinjantaa ra nda cewoo kaŋ hun sargaroo ra kaŋ i nʼa kaa ŋaa nongu henanante ra, ni, nda ni izʼarey, nda ni ize woyey mʼi ŋaa cere bande. Zama i nka nondi ma ne sanda ni bagaa, nda ni izey bagaa Izirayel borey alaafiya teendi sargarey ra. ");
INSERT INTO ses_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","I ma kate cewoo kaŋ hun sargaroo ra kaŋ i nʼa kaa, nda gandoo kaŋ hun sargari zinji-zinjantaa ra, nda sargari tonantey maaney, kʼi zinji sanda sargari zinji-zinjante Abadantaa jine. Wey din, ni nda ni izʼarey ni bande wane nda ey, i ga tee baa duumante sanda takaa kaŋ nda Abadantaa na yaamar.» ");
INSERT INTO ses_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Musa na zunubu sargari jindaaroo alhabar hãa, amma nga ne, a tonandi. A futu Eleyazar nda Itamar ga, Haruna izʼarey kaŋ cindi, a nee: ");
INSERT INTO ses_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","«Cin se war mana zunubu sargaroo ŋaa nongu henanante ra? Zama haya no kaŋ ga hanse ka henan. Abadantaa nkʼa noo war se hala war ma jamaa layboo zaa ka zunubu tuusuyanoo tee i se nga jine. ");
INSERT INTO ses_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Nga ne, kuroo mana katandi nongu henanantaa gundoo ra, taka kul kaŋ no, war hima kʼa ŋaa nongu henanantaa ra sanda takaa kaŋ nda ay nʼa yaamar.» ");
INSERT INTO ses_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Haruna nee Musa se: «Nga ne, hõ i na ngi zunubu sargaroo kaa nda ngi sargari kukurantaa Abadantaa jine. Hayey wey tee ay ga, nda ay na zunubu sargaroo ŋaa hõ, a ga kan Abadantaa se wala?» ");
INSERT INTO ses_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Musa maarʼa, de a kan a se. ");
INSERT INTO ses_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Abadantaa šelaŋ Musa nda Haruna se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","«Wa šelaŋ Izirayel borey se ka nee: ‹Adabbawey kul kaŋ goo laboo ga, wey kaŋ war ga hin kʼi ŋaa ti: ");
INSERT INTO ses_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","almaney kaŋ ga goyaw ra, war ga hin ka haya kul ŋaa kaŋ ceetaamey ga faya, de ceetaamey ga fersi ihinka. ");
INSERT INTO ses_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Amma wey kaŋ si ŋandi wey kaŋ ga goyaw ra nda wey kaŋ ceetaamey ga faya ra ti: yoo, zama a ga goyaw, amma ceetaamey si faya. A ga harram war se, ");
INSERT INTO ses_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","nda tondoo-ntabay, zama a ga goyaw, amma ceetaamey si faya. A ga harram war se, ");
INSERT INTO ses_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","nda ntabay, zama a ga goyaw, amma ceetaamey si faya. A ga harram war se, ");
INSERT INTO ses_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","nda nbirŋa, zama ceetaamey ga faya, de ceetaamey ga fersi ihinka, amma a si goyaw. A ga harram war se. ");
INSERT INTO ses_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","War masi ngi hamey ŋaa, war masi tuku ngi jifaa ga. I ga harram war se. ");
INSERT INTO ses_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Wey kaŋ war ga hin kʼi ŋaa hayey kul kaŋ goo haroo ra ne: wey kul kaŋ goo nda ziihaya nda kokoši kaŋ goo haroo ra, a ma tee teekoo wala isaa, war ga hin kʼi ŋaa. ");
INSERT INTO ses_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Amma haya kul kaŋ sii nda ziihaya nda kokoši kaŋ goo teekoo nda isaa ra, haya kul kaŋ ga ɲuuti haroo ra, nda adabba kul kaŋ goo haroo ra, i ga tee war se haya wangante. ");
INSERT INTO ses_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","I ma tee war se haya wangante, war masi ngi hamey ŋaa, war ma wanga ngi jifawey. ");
INSERT INTO ses_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Haya kul kaŋ goo haroo ra kaŋ sii nda ziihaya nda kokoši ga tee war se haya wangante. ");
INSERT INTO ses_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Cirawey ra, wey kaŋ war mʼi wanga ey, war masʼi ŋaa, haya wanganteyaŋ no, manʼti kala jigaara, nda jigaara kaabekoyni, nda taši, ");
INSERT INTO ses_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","nda algabu ciray, nda algabu bibi dumi nda dumi, ");
INSERT INTO ses_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","nda gaaru-gaaru dumi kul, ");
INSERT INTO ses_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","nda taatagay, nda cirawfutu, nda jufuleele, nda gabu dumi nda dumi, ");
INSERT INTO ses_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","nda duuricanba, nda miri-miri-ngondiya, nda cirawfutu beeri, ");
INSERT INTO ses_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","nda cirawfutu kaaray, nda saajoo cirawfutu, nda jigaara, ");
INSERT INTO ses_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","nda alwaaliya, nda cirawkaaray dumi nda dumi, nda ciraw zunbukoyni, nda atafirfir. ");
INSERT INTO ses_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Fatakoyni kaccu kul kaŋ ga dira cee taaci ga, ga tee war se haya wangante. ");
INSERT INTO ses_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Amma hayey kaŋ war ga hin kʼi ŋaa fatakoyney ra kaŋ ga dira cee taaci ga ti wey kaŋ ngi ceetaamey se beene i goo nda cee taabanteyaŋ kaŋ nda i ga sar laboo ga. ");
INSERT INTO ses_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Hayey kaŋ war ga hin kʼi ŋaa ti ndoo dumi beeri nda dumi kaccu nda cirilondi dumi beeri nda dumi kaccu. ");
INSERT INTO ses_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Amma fatakoyni cindey kul kaŋ goo nda cee taaci ga tee war se haya wangante.›» ");
INSERT INTO ses_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","«‹Hayayaŋ ne kaŋ ga war žiibandi, boro kul kaŋ tuku ngi jifaa ga, ga žiibi hala almaaroo ra. ");
INSERT INTO ses_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Boro kul kaŋ na ngi jifaa affoo zaa, ma nga bankaarawey ɲumandi, a ga žiibi hala almaaroo ra. ");
INSERT INTO ses_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Adabba kul kaŋ ceetaamey ga faya, amma ceetaamey si fersi ihinka, a si goyaw, a ga harram war se. Boro kul kaŋ tuku a ga, ga žiibi. ");
INSERT INTO ses_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Haya kul kaŋ ga dira nga ceetaamey ga adabbawey kaŋ goo nda cee taaci ra, ga harram war se, boro kul kaŋ tuku ngi jifaa ga, ga žiibi hala almaaroo ra. ");
INSERT INTO ses_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Boro kul kaŋ na ngi jifaa zaa, ma nga bankaarawey ɲumandi, a ga žiibi hala almaaroo ra. I ga harram war se. ");
INSERT INTO ses_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Hayey kaŋ ga harram war se gandakoyey ra kaŋ ga ɲuuti laboo ga ti: minay, nda nceŋ, nda agazirim dumi nda dumi, ");
INSERT INTO ses_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","nda ncita, nda cilimtaala, nda nkuura, nda jingam, nda daamamolooli. ");
INSERT INTO ses_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Wey ga harram war se gandakoyey kul ra, boro kul kaŋ tuku ngi bukawey ga, ga žiibi hala almaaroo ra. ");
INSERT INTO ses_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Nda a buu ka kaŋ, haya kul kaŋ ga no ga žiibi, a ma tee bundu gamal, wala bankaaray, wala kuuru, wala bolbol, jinay kul kaŋ ga yantasu hanse, a ma huru hari ra, a ga žiibi hala almaaroo ra. Woo banda ga, a ga henan. ");
INSERT INTO ses_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Labutuu kul kaŋ ra ngi affoo kaŋ, haya kul kaŋ goo a ra ga žiibi, war ma labutuwoo kayri. ");
INSERT INTO ses_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Ŋaayan kul kaŋ ga ŋandi kaŋ labutuwoo din haroo too a do ga žiibi. Haŋhaya kul kaŋ ga haŋandi kaŋ goo jinay kul kaŋ ra no ga žiibi. ");
INSERT INTO ses_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Jinay kul kaŋ ga ngi jifaa affoo kaŋ, ga žiibi, a ma tee alforon wala feema, i ma kayrandi, i ga harram, i ma harram war se. ");
INSERT INTO ses_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Amma hariɲaa wala day kaŋyaŋ ti hari kanidoo ga halal, amma boro kaŋ tuku ngi jifaa ga, ga žiibi. ");
INSERT INTO ses_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Nda ngi jifaa affoo kaŋ dumi boŋ kaŋ ga dumandi, dumiyoo ga halal. ");
INSERT INTO ses_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Nda a gar i na hari daŋ dumiyoo ga, ngi jifaa affoo kaŋ a ga, a ga harram war se. ");
INSERT INTO ses_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Nda adabbawey kaŋ ga tee war se ŋaahaya affoo jifa, boro kaŋ tuku jifaa ga, ga žiibi hala almaaroo ra. ");
INSERT INTO ses_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Boro kaŋ na jifaa ŋaa ma nga bankaarawey ɲumandi, a ga žiibi hala almaaroo ra, boro mo kaŋ na jifaa zaa ma nga bankaarawey ɲumandi, a ga žiibi hala almaaroo ra. ");
INSERT INTO ses_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Gandako kul kaŋ ga ɲuuti laboo ga, manʼti kala haya wangante, a masi ŋandi. ");
INSERT INTO ses_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Hayey kul kaŋ ga dira gundey ga, nda wey kul kaŋ ga dira cee taaci ga, nda wey kul kaŋ goo nda cee boobo ka ɲuuti laboo ga gandakoyey ra, war masʼi ŋaa, zama haya wanganteyaŋ no. ");
INSERT INTO ses_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","War masi war boŋ tee haya wangante nda gandakoyey wey kaŋ ga ɲuuti, war masi war boŋ žiibandi nda ey, i masi war žiibandi ngi bande. ");
INSERT INTO ses_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Zama agay ti Abadantaa, war Koyoo. Wa war boŋ daŋ jere ga Irkoy se ka tee nga boro henananteyaŋ, zama ay ga henan. War masi war boŋ žiibandi nda gandakoyey kaŋ ga ziilam-ziilam laboo ga affoo. ");
INSERT INTO ses_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Zama agay ti Abadantaa kaŋ na war žigandi ka hun Misira gandaa ra, hala ya tee war se Irkoy. War ma henan, zama ay ga henan.›» ");
INSERT INTO ses_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Woo ti adabbawey nda cirawey ašariyaa, nda hayey kul kaŋ ga ziilam-ziilam haroo ra, nda wey kul kaŋ ga ɲuuti laboo ga, ");
INSERT INTO ses_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","nga ra haya harramante nda ihalalante ga fayandi ka hun cere ra, hoogaa kaŋ ga ŋandi nda woo kaŋ si ŋandi here. ");
INSERT INTO ses_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","«Šelaŋ Izirayel borey se ka nee: ‹Nda woy na gunde zaa, a duu nga boŋ izʼaru, a ga žiibi jirbi iyye, a ga žiibi sanda waati kaŋ a ga dii nga gaaham žiiboo. ");
INSERT INTO ses_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Jirbi yaahantoo hane, zankaa ma hurubangu. ");
INSERT INTO ses_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Woyoo ma jirbi waranza cindi hinza (33) goro, hala waati kaŋ nga kuroo žiiboo ma ben a ga. A masi tuku haya henanante kul do, a masi koy nongu henanantaa ra, hala han kaŋ nga henanandiyanoo jirbey timme. ");
INSERT INTO ses_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Amma nda woy no a duu a, a ga žiibi jirbiiyye hinka, a ga žiibi sanda waati kaŋ a ga dii nga gaaham žiiboo. Woo banda ga, a ma goro jirbi woydu cindi iddu (66), hala waati kaŋ kuroo žiiboo ma ben a ga. ");
INSERT INTO ses_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Waati kaŋ nga henanandiyanoo jirbey timme, izʼaru wala ize woy no a duu a, a ma koy nda a sargari juwalkaa do, cere kubayyan hukkumoo miɲoo ga, jiiri foo feeji-ize, a ma tee sargari kukurante, nda tuuzun-ize, wala gubaguba ka tee zunubu sargari. ");
INSERT INTO ses_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Sargari juwalkaa mʼi sarga Abadantaa jine, a ma henanandiyanoo tee a se, de a ga henan, zama nga kuroo kay. Woo ti woy kaŋ na izʼaru wala ize woy hay ašariyaa. ");
INSERT INTO ses_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Nda a sii nda hini ka duu feeji, a ma gubaguba hinka wala tuuzun-ize hinka zaa, affoo sargari kukurantaa se, affaa zunubu sargaroo se. Sargari juwalkaa ma henanandiyanoo tee a se, de a ga henan.›» ");
INSERT INTO ses_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Abadantaa šelaŋ Musa nda Haruna se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","«Nda adamize kuuroo ga funsu-ize wala doridoo kogo wala ndella kaaray goo, de a tee kuuroo ra dori sanda jiray, i mʼa ka koy sargari juwalkaa Haruna wala nga izʼarey sargari juwalkey affoo do. ");
INSERT INTO ses_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Sargari juwalkaa ma doroo laasaabu kaŋ goo kuuroo ga. Nda doroo dogoo hinbiroo bere ka kaaray, de doroo ga hima nda a guusu ka bisa kuuroo, jiray dumi dori no. Sargari juwalkaa mʼa guna, de a ma bayrandi kaŋ a žiibi. ");
INSERT INTO ses_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Nda ndellaa kaŋ goo kuuroo ga, ga kaaray, de a si hima nda a guusu ka bisa kuuroo, hinbiroo mana bere ka kaaray. Sargari juwalkaa ma dorikoynoo daabu jirbi iyye. ");
INSERT INTO ses_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Sargari juwalkaa mʼa laasaabu jirbi iyyantoo hane, nda a gar kaŋ nga do doroo cindi nga takaa ga, a mana daaru kuuroo ga, sargari juwalkaa ma yee kʼa daabu jirbi iyye koyne. ");
INSERT INTO ses_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Sargari juwalkaa mʼa guna koyne jirbi iyyantoo hane, nda a gar kaŋ doroo goo ma dere, a mana daaru kuuroo ga, sargari juwalkaa ma bayrandi kaŋ a henan. Doridoo kogo no, a ma nga bankaarawey ɲumandi, de a ga henan. ");
INSERT INTO ses_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Amma nda doridoo kogaa daaru kuuroo ga ka tonton sargari juwalkaa laasaaburoo nda ka bayrandi kaŋ a henan banda ga, a ma nga boŋ cebe sargari juwalkaa se koyne. ");
INSERT INTO ses_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Sargari juwalkaa mʼa laasaabu, nda a gar kaŋ doridoo kogaa daaru kuuroo ga, sargari juwalkaa ma bayrandi kaŋ a žiibi, jiray dumi no. ");
INSERT INTO ses_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Nda jiray dumi dori fatta boro ga, i mʼa ka koy sargari juwalkaa do. ");
INSERT INTO ses_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Sargari juwalkaa mʼa laasaabu, nda a gar kaŋ funsu-ize kaaray goo kuuroo ga, de a na hinbiroo kaarayandi, ham zay doo goo funsoo ga, ");
INSERT INTO ses_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","jiray no kaŋ nin kuuroo ga. Sargari juwalkaa ma bayrandi kaŋ a žiibi. A masʼa daabu, zama a žiibi. ");
INSERT INTO ses_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Nda jiraa hanse ka kuuroo dii, nda jiraa na boraa kaŋ ga doroo goo kuuroo kul daabu kʼa dii boŋoo ka koy cewey ga, wey kul kaŋ sargari juwalkaa ga dii a, ");
INSERT INTO ses_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","sargari juwalkaa mʼa laasaabu, nda a gar kaŋ jiraa na gaahamoo kul daabu, a ma bayrandi kaŋ boraa kaŋ ga doroo goo henan. Nga kul ka kaaray, a henan. ");
INSERT INTO ses_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Amma han kaŋ i dii ham zay a ga, a ga žiibi. ");
INSERT INTO ses_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Nda sargari juwalkaa na hamoo kaŋ zay guna, a ma bayrandi kaŋ a žiibi. Hamoo kaŋ zay ga žiibi, jiray dumi no. ");
INSERT INTO ses_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Amma nda hamoo kaŋ zay bere ka yee ka tee ikaaray, a ma yee sargari juwalkaa do. ");
INSERT INTO ses_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Sargari juwalkaa mʼa laasaabu, nda a gar kaŋ doroo bere ka tee ikaaray, sargari juwalkaa ma bayrandi kaŋ boraa kaŋ ga doroo goo henan. A henan. ");
INSERT INTO ses_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Nda futta fatta kuuroo ga, de a duu baani, ");
INSERT INTO ses_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","nongoo kaŋ ra futtaa tee, funsu-ize kaaray, wala nda ndella kaaray kaŋ moɲoo ga ciray fatta a ra, boraa ma nga boŋ cebe sargari juwalkaa se. ");
INSERT INTO ses_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Sargari juwalkaa mʼa laasaabu, nda a gar kaŋ a ga hima nda a guusu ka bisa kuuroo, nga hinbiroo bere ka tee ikaaray, sargari juwalkaa ma bayrandi kaŋ a žiibi. Jiray dumi dori no kaŋ fatta futtaa ga. ");
INSERT INTO ses_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Nda sargari juwalkaa nʼa guna, nda a gar kaŋ hinbiri kaaray sii a ga, a mana guusu ka bisa kuuroo, a goo ma dere, sargari juwalkaa mʼa daabu jirbi iyye. ");
INSERT INTO ses_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Nda a daaru ka tonton kuuroo ga, sargari juwalkaa ga bayrandi kaŋ a žiibi, dori no. ");
INSERT INTO ses_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Amma nda ndellaa cindi nga dogoo ra, a mana daaru, futtaa ndellaa no, sargari juwalkaa ma bayrandi kaŋ a henan. ");
INSERT INTO ses_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Nda nongu kaŋ ton goo kuuroo ga, de tondogoo silbaa manʼti kala ndella kaaray moo ciray wala ikaaray, ");
INSERT INTO ses_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","sargari juwalkaa mʼa laasaabu, nda a gar kaŋ hinbiroo bere ka tee ikaaray ndellaa ra, de a ga hima nda a guusu ka bisa kuuroo, jiray no, a fatta tondogoo ga, sargari juwalkaa ma bayrandi kaŋ a žiibi, jiray dori no. ");
INSERT INTO ses_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Nda sargari juwalkaa nʼa guna, nda a gar kaŋ hinbiri kaaray sii ndellaa ra, a si hima nda a guusu ka bisa kuuroo, a goo ma dere, sargari juwalkaa mʼa daabu jirbi iyye. ");
INSERT INTO ses_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Sargari juwalkaa mʼa guna jirbi iyyantoo hane. Nda ndellaa daaru kuuroo ga ka tonton, sargari juwalkaa ma bayrandi kaŋ a žiibi, jiray dori no. ");
INSERT INTO ses_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Amma nda ndellaa cindi nga dogoo ra, a mana daaru kuuroo ga, a goo ma dere, tonyan futta no. Sargari juwalkaa ma bayrandi kaŋ a henan, zama nongoo kaŋ ton ndellaa no. ");
INSERT INTO ses_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Nda aru wala woy duu dori nga boŋoo wala nga toonaa ga, ");
INSERT INTO ses_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","sargari juwalkaa ma doroo laasaabu, nda a gar kaŋ a ga hima nda a guusu ka bisa kuuroo, hinbiri kara say-sayante goo a ga. Sargari juwalkaa ma bayrandi kaŋ a žiibi, forgo no, boŋ wala toono jiray dumi no. ");
INSERT INTO ses_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Nda sargari juwalkaa na forgaa doroo guna, nda a gar kaŋ a si hima nda a guusu ka bisa kuuroo, hinbiri bibi sii a ga, sargari juwalkaa ma boraa kaŋ ga forgo doroo goo daabu jirbi iyye. ");
INSERT INTO ses_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Sargari juwalkaa ga doroo guna jirbi iyyantoo hane, nda a gar kaŋ forgaa mana daaru, hinbiri kara sii a ga, de a si hima nda a guusu ka bisa kuuroo, ");
INSERT INTO ses_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","boraa ma cebu, amma a masi forgaa dogoo cebu, sargari juwalkaa ma forgokoynoo daabu jirbi iyye koyne. ");
INSERT INTO ses_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Sargari juwalkaa ga forgaa guna jirbi iyyantoo hane, nda a gar kaŋ a mana daaru kuuroo ga, a si hima nda a guusu ka bisa kuuroo, sargari juwalkaa ma bayrandi kaŋ a henan. Boraa ma nga bankaarawey ɲumandi, de a ga henan. ");
INSERT INTO ses_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Amma nda forgaa daaru kuuroo ga ka tonton, nga henanandiyanoo banda ga, ");
INSERT INTO ses_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","sargari juwalkaa mʼa laasaabu, nda a gar kaŋ forgaa daaru kuuroo ga, sargari juwalkaa masi hinbiri kara ceeci, a žiibi. ");
INSERT INTO ses_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Nda nga do, forgaa cindi nga dogoo ra, de hinbiri bibiyaŋ zay a ra, forgaa ben. A henan, sargari juwalkaa ma bayrandi kaŋ a henan. ");
INSERT INTO ses_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Nda aru wala woy duu ndellayaŋ nga kuuroo ga, ndella kaarayyaŋ, ");
INSERT INTO ses_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","sargari juwalkaa mʼa laasaabu, nda a gar kaŋ nga kuuroo ga ndella kaaray kaŋ goo ma dere goo, ndella de no kaŋ fatta kuuroo ga, a henan. ");
INSERT INTO ses_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Nda aru boŋ hinbirey hun, a taylel, a henan. ");
INSERT INTO ses_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Nda nga boŋoo jineheroo hinbirey ka hun, teɲa se beene ka taylel, a henan. ");
INSERT INTO ses_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Nda taylel dogoo jine wala banda, dori kaaray kaŋ moɲoo ga ciray goo a ra, jiray no kaŋ fatta taylel dogoo jine wala bandaheroo ra. ");
INSERT INTO ses_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Sargari juwalkaa mʼa laasaabu, nda a gar kaŋ doroo futtaa manʼti kala ikaaray kaŋ moɲoo ga ciray kaŋ goo tayleloo jineheroo wala bandaheroo ra, a ga hima nda jiray kaŋ goo kuuroo ra, ");
INSERT INTO ses_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","jiraykoyni no, a žiibi. Sargari juwalkaa ma bayrandi kaŋ nga kul ka žiibi, boŋoo ga nga doroo goo. ");
INSERT INTO ses_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Jiraykoynoo kaŋ ga doroo goo ma darbay kottayaŋ daŋ, a ma nga boŋoo feeri, a ma nga kaaboo daabu, a ma kaati ka nee: ‹Žiibi, žiibi!› ");
INSERT INTO ses_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Waatoo kul kaŋ doroo goo a ga, a ga žiibi. A žiibi, a ma goro nga hinne, a ga goro jamaa kaloo se taray. ");
INSERT INTO ses_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Nda bankaaray ga fuune fatta, a ma tee haabu darbay wala leŋ šukka darbay, ");
INSERT INTO ses_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","a ma tee šukka wala šukka kaŋ kayandi, leŋ wala haabu, a ma tee kuuru wala jinay kul kaŋ no kaŋ teendi kuuru ra, ");
INSERT INTO ses_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","nda ndellaa manʼti kala ifirzi wala iciray darbaa, wala kuuroo, wala šukkaa, wala šukkaa kaŋ kayandi, wala jinay kul kaŋ teendi kuuru ra ga, fuune ndella no, a ma cebandi sargari juwalkaa se. ");
INSERT INTO ses_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Sargari juwalkaa ma ndellaa laasaabu, a ma jinaa kaŋ ga ndellaa huru daabu jirbi iyye. ");
INSERT INTO ses_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Jirbi iyyantoo hane, a ma ndellaa guna, nda a daaru darbaa, wala šukkaa, wala šukkaa kaŋ kayandi, wala kuuroo, wala jinay kul kaŋ teendi kuuru ra ga, ndellaa manʼti kala fuune kaŋ nin, a žiibi. ");
INSERT INTO ses_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Darbaa, wala šukkaa, wala šukkaa kaŋ kayandi, haabu wala leŋ, a ma tee jinay kul kaŋ teendi kuuru ra kaŋ ga ndellaa goo, ma tonandi, zama fuune kaŋ nin no. Hayaa ma tonandi nuune ra ka tee boosu. ");
INSERT INTO ses_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Nda sargari juwalkaa nʼa laasaabu, nda a gar kaŋ ndellaa mana daaru darbaa, wala šukkaa, wala šukkaa kaŋ kayandi, wala jinay kul kaŋ teendi kuuru ra ga, ");
INSERT INTO ses_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","sargari juwalkaa ma yaamar kaŋ hayaa ma ɲumandi kaŋ ga ndellaa huru, de a ma yee kʼa daabu jirbi iyye koyne. ");
INSERT INTO ses_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Sargari juwalkaa mʼa guna ɲumandiyanoo banda ga, nda a gar kaŋ ndellaa mana alhaali barmay, a mana daaru, a žiibi, a ma tonandi nuune ra ka tee boosu. Guusu no kaŋ tee darbaa jine wala bandaheroo ra. ");
INSERT INTO ses_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Nda sargari juwalkaa nʼa guna, nda a gar kaŋ ndellaa goo ma dere ɲumandiyanoo banda ga, a mʼa dunbu kʼa kaa darbaa, wala kuuroo, wala šukkaa, wala šukkaa kaŋ kayandi ga. ");
INSERT INTO ses_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Nda a yee ka fatta darbaa, wala šukkaa, wala šukkaa kaŋ kayandi, wala jinay kul kaŋ teendi kuuru ra ga, fuune no kaŋ goo ma bangay. Ma jinaa kaŋ ga ndellaa huru ton nuune ra kʼa tee boosu. ");
INSERT INTO ses_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Darbaa, wala šukkaa, wala šukkaa kaŋ kayandi, wala jinay kul kaŋ teendi kuuru ra kaŋ nʼnʼa ɲumandi ka ndellaa kaa, ma ɲumandi koyne, a henan.» ");
INSERT INTO ses_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Woo ti fuune ndella kaŋ huru haabu wala leŋ darbay, wala šukka, wala šukka kaŋ kayandi, wala jinay kul kaŋ teendi kuuru ra ga ašariyaa hala boraa ma bayrandi kaŋ a henan wala a žiibi. ");
INSERT INTO ses_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","«Jiraykoyni ašariyaa ne nga henanandiyanoo hane: waati kaŋ i nʼa ka koy sargari juwalkaa do, ");
INSERT INTO ses_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","sargari juwalkaa ma koy jamaa kaloo se taray, a mʼa laasaabu, nda a gar kaŋ jiraykoynoo duu baani nga jiraa doroo ra, ");
INSERT INTO ses_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","sargari juwalkaa ma yaamar kaŋ i ma kate boraa kaŋ ga hima ka henan se: ciraw hunante halalante hinka, nda sedere bundu, nda šilli ciray zaram, nda izopu bundu. ");
INSERT INTO ses_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Sargari juwalkaa ma yaamar kaŋ i ma ciraw faa koosu labu kusu kaŋ ra hari henna goo boŋ. ");
INSERT INTO ses_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Ciraw hunantaa, a mʼa zaa, nga nda sedere bundoo, nda šilli ciray zaramoo, nda izopu bundoo, a mʼi sufa ciraa kaŋ koosandi hari hennaa boŋ kuroo ra. ");
INSERT INTO ses_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","A ma say-saya cee iyye jiraykoynoo ga kaŋ ga hima ka henan nga jiraa ra. Woo banda ga, a ma bayrandi kaŋ a henan, de a ma ciraw hunantaa taŋ saajoo ra. ");
INSERT INTO ses_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Boraa kaŋ ga hima ka henan ma nga bankaarawey ɲumay, a ma nga hinbirey kul cebu, a ma ɲumay haroo ra, de a ga henan. Woo banda ga, a ga hin ka huru jamaa kaloo ra, amma a ma cindi hukkumoo se taray jirbi iyye. ");
INSERT INTO ses_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Jirbi iyyantoo hane, a ma nga hinbirey kul cebu, boŋoo, nda kaaboo, nda moo beene hinbirey, a ma nga hinbiroo kul cebu, a ma nga bankaarawey ɲumandi, a ma nga gaahamoo ɲumay nda hari, de a ga henan. ");
INSERT INTO ses_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Jirbi yaahantoo hane, a ma feeji aru-ize hinka kaŋ ga malal sii, nda feeji woy-ize kaŋ goo nda jiiri foo kaŋ ga malal sii, nda farin hamni kilo yagga cine kaŋ loobandi nda jii ka tee taasu sargari, nda jii liitar jere zaa. ");
INSERT INTO ses_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Sargari juwalkaa kaŋ ga henanandiyanoo tee ma boraa kaŋ ga hima ka henan nda hayey wey daŋ Abadantaa jine cere kubayyan hukkumoo miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Sargari juwalkaa ma feeji aru-ize faa dii kʼa tee tooɲe sargari, nga nda liitar jeraa jiyoo, a mʼi zinji kʼi tee sargari zinji-zinjante Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","A ma feeji aru-izoo koosu nongoo kaŋ ra zunubu sargaroo nda sargari kukurantaa koosandi, nongu henanante ra, zama takaa kaŋ ti zunubu sargaroo, nga da ti tooɲe sargaroo, sargari juwalkaa ma duu a, haya no kaŋ ga hanse ka henan. ");
INSERT INTO ses_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Sargari juwalkaa ma zaa tooɲe sargaroo kuroo ra kʼa daŋ boraa kaŋ ga hima ka henan haŋa gumaa deenoo ga, nda nga kabe gumaa kobaaroo ga, nda cee gumaa cew-ize beeroo ga. ");
INSERT INTO ses_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Sargari juwalkaa ma zaa liitar jeraa jiyoo ra kʼa doori nga kabe waawaa ra, ");
INSERT INTO ses_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","a ma nga kabe gumaa kabe-ize foo sufa jiyoo ra kaŋ goo kabe waawaa ra, a ma nga kabe-izoo ka zaa jiyoo ra kʼa say-say cee iyye Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Sargari juwalkaa ma zaa jii cindoo ra kaŋ goo nga kaboo ra kʼa daŋ boraa kaŋ ga hima ka henan haŋa gumaa deenoo ga, nda nga kabe gumaa kobaaroo ga, nda nga cee gumaa cew-ize beeroo ga, tooɲe sargaroo kuroo boŋ. ");
INSERT INTO ses_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Jiyoo cindoo kaŋ goo sargari juwalkaa kaboo ra, a mʼa fur boraa kaŋ ga hima ka henan boŋoo ga, a ma henanandiyanoo tee a se Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Sargari juwalkaa ma zunubu sargaroo kaa, a ma henanandiyanoo tee a se kʼa henanandi ka žiiboo kaa a ga. Woo banda ga, a ma sargari kukurantaa almanoo koosu. ");
INSERT INTO ses_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Sargari juwalkaa ma sargari kukurantaa nda taasu sargaroo kaa sargari tonadogoo ga. Sargari juwalkaa ma henanandiyanoo tee boraa se, de a ga henan. ");
INSERT INTO ses_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Nda boro ga talka, de nga hinoo si too hayey wey, a ma feeji aru-ize foo kaa tooɲe sargari kʼa tee sargari zinji-zinjante ka henanandiyanoo tee a se. A ma farin hamni kilo hinza kaŋ loobandi nda jii zaa kʼa kaa taasu sargari nda jii liitar jere, ");
INSERT INTO ses_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","nda gubaguba hinka wala tuuzun-ize hinka kaŋ nga hinoo ga toorʼa, affoo zunubu sargari se, affaa sargari kukurante se. ");
INSERT INTO ses_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Nga henanandiyanoo jirbi yaahantoo hane, a ma kate ey sargari juwalkaa do cere kubayyan hukkumoo miɲoo ga Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Sargari juwalkaa ma tooɲe sargaroo feeji aru-izoo dii nda liitar jeraa jiyoo, a mʼi zinji kʼi tee sargari zinji-zinjante Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","A ma tooɲe sargaroo feejoo koosu, a ma zaa tooɲe sargaroo kuroo ra kʼa daŋ boraa kaŋ ga hima ka henan haŋa gumaa deenoo ga, nda nga kabe gumaa kobaaroo ga, nda cee gumaa cew-ize beeroo ga. ");
INSERT INTO ses_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Sargari juwalkaa ma doori jiyoo ra nga kabe waawaa ra. ");
INSERT INTO ses_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Kabe gumaa kabe-ize foo, a mʼa ka zaa jiyoo ra kaŋ goo kabe waawaa ra, a mʼa say-say cee iyye Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Jiyoo kaŋ goo sargari juwalkaa kaboo ra, a ma daŋ a ra boraa kaŋ ga hima ka henan haŋa gumaa deenoo ga, nda nga kabe gumaa kobaaroo ga, nda cee gumaa cew-ize beeroo ga, nongoo kaŋ ra tooɲe sargaroo kuroo jisandi. ");
INSERT INTO ses_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Woo kaŋ cindi jiyoo ra kaŋ goo sargari juwalkaa kaboo ra, a mʼa fur boraa kaŋ ga hima ka henan boŋoo ga ka henanandiyanoo tee a se Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Woo banda ga, nga nda nga hinagoo, a ma gubagubawey affoo wala tuuzun-izey affoo sarga. ");
INSERT INTO ses_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Nga hinagoo ra, a ma affoo kaa zunubu sargari se, affaa sargari kukurante, taasu sargaroo bande. Sargari juwalkaa ma henanandiyanoo tee boraa se kaŋ ga hima ka henan Abadantaa jine.» ");
INSERT INTO ses_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Woo ti ašariyaa boro se kaŋ ga jiray doroo goo, de nga hinoo si too henanandiyanoo hayey. ");
INSERT INTO ses_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Abadantaa šelaŋ Musa nda Haruna se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","«Waati kaŋ war huru Kanaŋ gandaa ra kaŋ ay gʼa noo war se a ma tee war mayraa, nda ay na fuune ndella daŋ hugu ra kaŋ goo gandaa ra kaŋ ti war mayraa, ");
INSERT INTO ses_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","boraa kaŋ wane nda hugoo ma koy a bayrandi sargari juwalkaa se ka nee: ‹Ay dii ndella dumi ay hugoo ra.› ");
INSERT INTO ses_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Sargari juwalkaa ma yaamar kaŋ i ma jinawey fattandi hugoo ra za nga mana kaa ka ndellaa guna, hala hayey kaŋ goo hugoo ra kul masi koy harram. Woo banda ga, sargari juwalkaa ma huru ka hugoo laasaabu. ");
INSERT INTO ses_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","A ma ndellaa laasaabu, nda a gar kaŋ ndella guusa firziyaŋ wala icirayyaŋ goo hugoo cetewey ga, i ga hima nda i guusu cetewey ra, ");
INSERT INTO ses_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","sargari juwalkaa ma fatta hugoo ra, waati kaŋ a too hugoo miɲoo ga, a ma hugoo daabu jirbi iyye. ");
INSERT INTO ses_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Jirbi iyyantoo hane, sargari juwalkaa ma yee ka koy a guna, nda a gar kaŋ ndellaa daaru hugoo cetewey bande, ");
INSERT INTO ses_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","sargari juwalkaa ma yaamar kaŋ i ma tondey kaa kaŋ ga ndellaa goo, i mʼi warra koyraa banda ga nongu harramante ra. ");
INSERT INTO ses_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","A ma hugoo gundoo kuubi kʼa bere kʼa koosu. Laboo kaŋ koosandi, i mʼa mun koyraa banda ga nongu harramante ra. ");
INSERT INTO ses_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","I ma tondi tanayaŋ zaa kʼi daŋ ijinawey dogey ra. I ma labu tana ka hugoo sanfa. ");
INSERT INTO ses_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Nda ndellaa yee ka kaa ka fatta hugoo ra, tondey kaayanoo, nda koosuyanoo, nda sanfayanoo banda ga, ");
INSERT INTO ses_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","sargari juwalkaa ma yee ka koy a guna, nda a gar kaŋ ndellaa daaru hugoo ga, fuune no kaŋ nin, a harram. ");
INSERT INTO ses_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","I ma hugoo, nda nga tondey, nda bundey, nda hugoo laboo kayri, i mʼi ka koy koyraa dumaa ga nongu harramante ra. ");
INSERT INTO ses_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Boro kaŋ huru hugoo ra waatey kaŋ a ga daaba ra, ga žiibi hala almaaroo ra. ");
INSERT INTO ses_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Boro kaŋ kani hugoo ra ma nga darbawey ɲumandi. Boro kaŋ ŋaa hugoo ra ma nga darbawey ɲumandi. ");
INSERT INTO ses_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Amma nda sargari juwalkaa yee ka huru kʼa guna, nda a gar kaŋ ndellaa mana daaru hugoo ga nga sanfayanoo banda ga, sargari juwalkaa ma bayrandi kaŋ hugoo henan, ndellaa dere. ");
INSERT INTO ses_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Hugoo zunubu tuusuyanoo se a ma ciraw hinka, nda sedere bundu, nda šilli ciray zaram, nda izopu bundu zaa. ");
INSERT INTO ses_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","A ma ciraw faa koosu labu kusu boŋ, labu kusu kaŋ ra hari henna goo boŋ. ");
INSERT INTO ses_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","A ma sedere bundoo, nda izopu bundoo, nda šilli ciray zaramoo, nda ciraw hunantaa zaa kʼi sufa ciraa kaŋ koosandi kuroo nda hari hennaa ra. A ma say-saya cee iyye hugoo ga. ");
INSERT INTO ses_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","A ma hugoo zunubu tuusuyanoo tee nda ciraa kuroo nda hari hennaa, nda ciraw hunantaa, nda sedere bundoo, nda izopu bundoo, nda šilli ciray zaramoo. ");
INSERT INTO ses_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","A ma ciraw hunantaa taŋ koyraa banda ga, saajoo ra. A ma henanandiyanoo tee hugoo se, de a ga henan.» ");
INSERT INTO ses_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Woo ti jiray dori wala fuune ndella dumi kul kaŋ no, nda forgo, ");
INSERT INTO ses_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","nda bankaaray ndella, nda hugu ndella, ");
INSERT INTO ses_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","nda funsu, nda futta, nda ndella kaaray ašariyaa, ");
INSERT INTO ses_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","ka bayrandi waati kaŋ haya žiibi nda waati kaŋ haya henan. Woo ti jiray nda fuune ašariyaa. ");
INSERT INTO ses_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Abadantaa šelaŋ Musa nda Haruna se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","«Šelaŋ Izirayel borey se ka nee: ‹Aru kul kaŋ nga harimundogoo ga mandi, nga mandiroo gʼa žiibandi. ");
INSERT INTO ses_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Hayaa ne kaŋ ga kate nga mandiroo mʼa žiibandi: nga harimundogoo ma mandi wala a ma mandiroo dii, nga žiiboo no. ");
INSERT INTO ses_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Daari kul kaŋ ga boraa kaŋ ga mandi kani ga žiibi, haya kul kaŋ ga a goro ga žiibi. ");
INSERT INTO ses_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Boro kaŋ tuku nga daaroo ga ma nga bankaarawey ɲumandi, a ma nga boŋ ɲumay nda hari, a ga žiibi hala almaaroo ra. ");
INSERT INTO ses_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Boro kaŋ goro jinay ga kaŋ ga boraa kaŋ ga mandi doona ka goro, boraa ma nga bankaarawey ɲumandi, a ma nga boŋ ɲumay nda hari, a ga žiibi hala almaaroo ra. ");
INSERT INTO ses_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Boro kaŋ tuku boraa kaŋ ga mandi gaahamoo ga, boraa ma nga bankaarawey ɲumandi, a ma nga boŋ ɲumay nda hari, a ga žiibi hala almaaroo ra. ");
INSERT INTO ses_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Nda boraa kaŋ ga mandi tufa boro ga kaŋ ga henan, boraa ma nga bankaarawey ɲumandi, a ma nga boŋ ɲumay nda hari, a ga žiibi hala almaaroo ra. ");
INSERT INTO ses_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Kaarumay kul kaŋ ga boraa kaŋ ga mandi žigi, ga žiibi. ");
INSERT INTO ses_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Boro kul kaŋ tuku haya kul kaŋ no ga kaŋ bay ka cindi a cire, a ga žiibi hala almaaroo ra. Boro kul kaŋ na jinawey wey affoo zaa, ma nga bankaarawey ɲumandi, a ma nga boŋ ɲumay nda hari, a ga žiibi hala almaaroo ra. ");
INSERT INTO ses_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Boro kul kaŋ ga boraa kaŋ ga mandi tuku, a mana nga kabey ɲumay, boraa ma nga bankaarawey ɲumandi, a ma nga boŋ ɲumay nda hari, a ga žiibi hala almaaroo ra. ");
INSERT INTO ses_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Labu jinay kaŋ ga boraa kaŋ ga mandi tuku, ma kayrandi, bundu jinawey ma leelandi nda hari. ");
INSERT INTO ses_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Waati kaŋ boraa kaŋ ga mandi, mandiroo kay, a ma jirbi iyye kabu nga henanandiyanoo se, a ma nga bankaarawey ɲumandi, a ma nga gaahamoo ɲumay hari dandidoo hari ra, de a ga henan. ");
INSERT INTO ses_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Jirbi yaahantoo hane, a ma gubaguba hinka wala tuuzun-ize hinka zaa, a ma kaa Abadantaa jine cere kubayyan hukkumoo miɲoo ga kʼi noo sargari juwalkaa se. ");
INSERT INTO ses_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Sargari juwalkaa mʼi sarga, affoo zunubu sargari, affaa sargari kukurante. Sargari juwalkaa ma henanandiyanoo tee a se Abadantaa jine nga mandiroo se. ");
INSERT INTO ses_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Nda aru almaaniyoo mun a ga, a ma nga gaahamoo kul ɲumay nda hari, a ga žiibi hala almaaroo ra. ");
INSERT INTO ses_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Bankaaray nda kuuru kul kaŋ ga almaaniyoo huru ma ɲumandi nda hari, a ga žiibi hala almaaroo ra. ");
INSERT INTO ses_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Nda woy nda aru marga nda cere, i ma ngi boŋ ɲumay nda hari, i ga žiibi hala almaaroo ra. ");
INSERT INTO ses_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Nda woy ga mandi, nga mandiroo manʼti kala nga gaaham žiiboo, a ma cindi nga žiiboo ra jirbi iyye, boro kul kaŋ tuku a ga, ga žiibi hala almaaroo ra. ");
INSERT INTO ses_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Haya kul kaŋ ga a kani waatoo kaŋ a goo nga žiiboo ra, ga žiibi. Haya kul kaŋ ga a goro ga žiibi. ");
INSERT INTO ses_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Boro kul kaŋ tuku nga daaroo ga ma nga bankaarawey ɲumandi, a ma nga boŋ ɲumay nda hari, a ga žiibi hala almaaroo ra. ");
INSERT INTO ses_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Boro kul kaŋ tuku jinay kul kaŋ ga woyoo doona ka goro, a ma nga bankaarawey ɲumandi, a ma nga boŋ ɲumay nda hari, a ga žiibi hala almaaroo ra. ");
INSERT INTO ses_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Nda haya goo daaroo boŋ wala jinaa ga, haya kul kaŋ no kaŋ ga a doona ka goro, boro kaŋ tuku a ga, ga žiibi hala almaaroo ra. ");
INSERT INTO ses_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Aru kaŋ marga nda woyoo, woyoo gaaham žiiboo ga huru a ga, a ga žiibi jirbi iyye. Daari kul kaŋ ga a kani ga žiibi. ");
INSERT INTO ses_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Nda woy ga kuri mandi jirbi boobo kaŋ manʼti nga gaaham žiiboo waatoo, wala a ga mandi ka gay ka bisa nga gaaham žiiboo waatoo, waatoo kul kaŋ a ga mandi, a ga žiibi sanda nga gaaham žiiboo waatoo. ");
INSERT INTO ses_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Daari kul kaŋ ga a kani jirbey kul kaŋ ra a ga mandi ga tee sanda nga gaaham žiiboo daaroo. Jinay kul kaŋ ga a goro ga žiibi sanda nga gaaham žiiboo takaa. ");
INSERT INTO ses_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Boro kul kaŋ tuku hayey wey ga, ga žiibi, a ma nga bankaarawey ɲumandi, a ma nga boŋ ɲumay nda hari, a ga žiibi hala almaaroo ra. ");
INSERT INTO ses_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Nda nga mandiroo kay, a ma jirbi iyye kabu, woo din banda ga, a ga henan. ");
INSERT INTO ses_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Jirbi yaahantoo hane, a ma gubaguba hinka wala tuuzun-ize hinka zaa kʼi ka koy sargari juwalkaa do cere kubayyan hukkumoo miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Sargari juwalkaa ma affoo kaa zunubu sargari, affaa sargari kukurante. Sargari juwalkaa ma henanandiyanoo tee a se Abadantaa jine nga gaaham žiiboo mandiroo se. ");
INSERT INTO ses_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","War ma Izirayel borey moorandi ngi žiiboo, i masi duu kʼay gorodogoo kaŋ goo i game žiibandi ka buu ngi žiiboo ra.›» ");
INSERT INTO ses_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Woo ti boro kaŋ ga mandi wala boro kaŋ nga almaaniyoo mun a ga kʼa žiibandi, ");
INSERT INTO ses_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","wala woy kaŋ ga dor nga gaaham žiiboo maaganda se, boro kul, aru wala woy kaŋ ga mandi, wala aru kaŋ marga nda woy kaŋ ga žiibi, ašariyaa. ");
INSERT INTO ses_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Haruna izʼaru hinkaa kaŋ man kate Abadantaa jine, ngi buuyanoo banda ga, Abadantaa šelaŋ Musa se. ");
INSERT INTO ses_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Abadantaa nee Musa se: «Šelaŋ ni armaa Haruna se, a masi huru alwaati kul nongu henanantaa ra, ridowoo dumaa ga, daabirjoo jine kaŋ goo sundukoo ga, hala a masi koy buu, zama ay ga bangay duulaa ra sundukoo daabirjoo se beene. ");
INSERT INTO ses_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Takaa ne kaŋ nda Haruna ga hima ka huru nongu henanantaa ra: a ma yaaru zaa zunubu sargaroo se, nda gaaru sargari kukurantaa se. ");
INSERT INTO ses_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","A ma šukka kaŋ se i ga nee leŋ kaayi henanante daŋ nga ga, a ma leŋ šukka npogo daŋ, a ma nga centoo haw nda leŋ šukka gamahaw, a ma leŋ šukka fatala didiji nga boŋoo ga, bankaaray henananteyaŋ no. A ma nga gaahamoo ɲumay nda hari jina a mʼi daŋ. ");
INSERT INTO ses_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","A ma jindaaru hinka taa Izirayel borey jamaa kone kʼi tee zunubu sargari, nda gaaru foo sargari kukurante se. ");
INSERT INTO ses_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Haruna ma zunubu sargaroo yaaroo sarga nga boŋ se, a ma zunubu tuusuyanoo tee nga boŋ nda nga hugoo se. ");
INSERT INTO ses_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","A ma jindaaru hinkaa zaa kʼi daŋ Abadantaa jine cere kubayyan hukkumoo miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Haruna ma alkurra kar jindaaru hinkaa ga ka dii woo kaŋ Abadantaa ga duu a nda woo kaŋ Azazel ga duu a. ");
INSERT INTO ses_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Haruna ma kate jindaaroo kaŋ alkurraa kate Abadantaa ma duu a, a ma tee zunubu sargari. ");
INSERT INTO ses_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Jindaaroo kaŋ alkurraa kate Azazel ma duu a, nga hunantaa ma jisandi Abadantaa jine hala i ma zunubu tuusuyanoo tee a ga kʼa sanba saajoo ra Azazel do. ");
INSERT INTO ses_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Haruna ma zunubu sargaroo yaaroo kaa nga boŋ se, a ma zunubu tuusuyanoo tee nga boŋ nda nga hugoo se. A ma zunubu sargari yaaroo koosu nga boŋ se. ");
INSERT INTO ses_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","A ma dugu canboo too nda denji ciray sargari tonadogoo ra kaŋ goo Abadantaa jine, a ma nga kabe hinkaa too nda dugu hew kaana hamni, a mʼi ka koy ridowoo dumaa ga. ");
INSERT INTO ses_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","A ma dugoo daŋ nuunaa ra kaŋ goo Abadantaa jine hala dugoo dulloo ma daabirjoo kaŋ goo seedetaraa sundukoo boŋ daabu, hala Haruna masi koy buu. ");
INSERT INTO ses_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","A ma zaa yaaroo kuroo ra kʼa say-say nda nga kabe-izoo sundukoo daabirjoo jineheroo ga waynahunay here. A ma nga kabe-izoo ka zaa kuroo ra kʼa say-say cee iyye sundukoo daabirjoo jine. ");
INSERT INTO ses_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","A ma zunubu sargaroo jindaaroo koosu kaŋ hun jamaa se, a ma kuroo ka koy ridowoo dumaa ga, a ma takaa tee kuroo se kaŋ a nʼa tee yaaroo wanoo se, a ma say-saya sundukoo daabirjoo ga nda sundukoo daabirjoo jine. ");
INSERT INTO ses_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","A ma henanandiyanoo tee nongu henanantaa se Izirayel borey žiibey nda ngi hooyaney ra, maanaa ngi zunubey kul. A ma taka follokaa tee cere kubayyan hukkumoo se kaŋ goo i bande ngi žiibey gamey ra. ");
INSERT INTO ses_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Adamize kul masi bara cere kubayyan hukkumoo ra waati kaŋ a koy zunubu tuusuyanoo tee nongu henanantaa ra hala waati kaŋ a fatta. Woo banda ga, a ma zunubu tuusuyanoo tee nga boŋ, nda nga hugoo, nda Izirayel jamaa kul se. ");
INSERT INTO ses_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","A ma fatta sargari tonadogoo here kaŋ goo Abadantaa jine, a ma zunubu tuusuyanoo tee a se. A ma zaa yaaroo kuroo nda jindaaroo kuroo ra kʼi daŋ sargari tonadogoo hilley ga, carawey bande. ");
INSERT INTO ses_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","A ma nga kabe-izoo ka zaa kuroo ra kʼa say-say cee iyye. A mʼa henanandi ka hun Izirayel borey žiibey ra. ");
INSERT INTO ses_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Waati kaŋ a na zunubu tuusuyanoo tee nongu henanantaa, nda cere kubayyan hukkumoo, nda sargari tonadogoo se ka ben, a ma kate jindaaru hunantaa. ");
INSERT INTO ses_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Haruna ma nga kabe hinkaa fur jindaaru hunantaa boŋoo ga, a ma Izirayel borey laybey kul har a ga, nda ngi hooyaney kul, nda ngi zunubey kul, a mʼi daŋ jindaaroo boŋoo ga. A mʼa taŋ, aru foo kaŋ kayandi mʼa ka koy saajoo ra. ");
INSERT INTO ses_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Jindaaroo ga ngi laybey kul zaa ka koy nongu ra kaŋ ra boro sii. Aroo ma jindaaroo taŋ a ma koy saajoo ra. ");
INSERT INTO ses_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Haruna ma huru cere kubayyan hukkumoo ra ka leŋ šukka bankaarawey kaŋ a nʼi daŋ waatoo kaŋ a ga huru nongu henanantaa ra, kaa kʼi jisi no din. ");
INSERT INTO ses_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","A ma nga gaahamoo ɲumay nda hari nongu henanante ra, a ma nga bankaarawey daŋ. Woo banda ga, a ma fatta ka nga sargari kukurantaa kaa ka jamaa sargari kukurantaa kaa, a ma zunubu tuusuyanoo tee nga boŋ nda jamaa se. ");
INSERT INTO ses_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","A ma zunubu sargaroo maanoo dullandi sargari tonadogoo boŋ. ");
INSERT INTO ses_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Boraa kaŋ na jindaaroo taŋ a ma koy Azazel do ma nga bankaarawey ɲumandi, a ma nga gaahamoo ɲumay nda hari, woo banda ga, a ga hin ka huru jamaa kaloo ra. ");
INSERT INTO ses_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","I ma zunubu sargaroo yaaroo nda zunubu sargaroo jindaaroo kaŋyaŋ ra kuroo kaandi ka koy nongu henanantaa ra ka henanandiyanoo tee ka koy jamaa kaloo se taray ka ngi kuurey, nda hamey, nda ngi teeley žiibey ton nuune ra kʼi tee boosu. ");
INSERT INTO ses_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Boraa kaŋ nʼi ton ma nga bankaarawey ɲumandi, a ma nga gaahamoo ɲumay nda hari, woo banda ga, a ga hin ka huru jamaa kaloo ra. ");
INSERT INTO ses_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Hantum kaŋ si tun ne war se: handu iyyantoo jirbi woyantoo (10to) ra, war ma meehaw, war masi goy kul tee, a ma tee ganda-ize wala yaw kaŋ ga waati tee war do. ");
INSERT INTO ses_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Zama hanoo din, i ga zunubu tuusuyanoo tee war se hala war ma duu ka henan, de war ga henan war zunubey kul ra Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","A ma tee war se hunanzamzaari kaŋ bisa hunanzamzaarey jerey, war ma meehaw. Hantum kaŋ si tun no. ");
INSERT INTO ses_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Sargari juwalkaa kaŋ yonandi, kaŋ gorandi sargari juwalyanoo goyoo ra ka huru nga baabaa dogoo ra no ma zunubu tuusuyanoo tee. A ma leŋ šukka darbawey daŋ, darbay henanantey. ");
INSERT INTO ses_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","A ma henanandiyanoo tee nongu henanantey ihenanantaa se, a ma henanandiyanoo tee cere kubayyan hukkumoo nda sargari tonadogoo se, a ma zunubu tuusuyanoo tee sargari juwalkey nda alžamaa kul se. ");
INSERT INTO ses_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Woo ma tee war se hantum kaŋ si tun hala zunubu tuusuyanoo ma teendi Izirayel borey se ngi zunubey kul se cee foo jiiroo ra.» A nʼa tee nda takaa kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","«Šelaŋ Haruna, nda nga izʼarey, nda Izirayel borey kul se, nee i se: ‹Hayaa ne kaŋ Abadantaa nʼa yaamar: ");
INSERT INTO ses_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","“Boro kul kaŋ Izirayel hugoo borey ra ga yaaru, wala feeji, wala hancin koosu jamaa kaloo ra, wala a gʼa koosu kaloo se taray, ");
INSERT INTO ses_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","de a manʼa ka koy cere kubayyan hukkumoo miɲoo ga kʼa kaa sargari Abadantaa maaɲoo ga, Abadantaa gorodogoo jine, i gʼa hãa nda kuroo din. A na kuri mun, boraa din ga hun nga jamaa ra, ");
INSERT INTO ses_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","hala Izirayel borey ma duu ka kate ngi sargarey kaŋ i goo mʼi kaa saajoo ra. I ma kate ey Abadantaa maaɲoo ga, cere kubayyan hukkumoo miɲoo ga, sargari juwalkaa do, i mʼi kaa alaafiya teendi sargaroo Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Sargari juwalkaa ma kuroo say-say Abadantaa sargari tonadogoo boŋ, cere kubayyan hukkumoo miɲoo ga, a ma maanoo dullandi kʼa tee sunnaara kaana Abadantaa se. ");
INSERT INTO ses_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","I masi yee ka ngi sargarey kaa jindaaru toorey maaɲey ga kaŋ bande i ga izefututaray tee. Woo ma tee i se hantum kaŋ si tun ngi alwaddawey se.”› ");
INSERT INTO ses_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Nee i se: ‹Boro kul kaŋ Izirayel hugoo borey ra, wala yawey kaŋ ga waati tee i do ra, na sargari kukurante wala sargari kaa, ");
INSERT INTO ses_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","de a mana kate a cere kubayyan hukkumoo miɲoo ga kʼa sarga Abadantaa maaɲoo ga, boraa din ga hun nga jamaa ra. ");
INSERT INTO ses_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Boro kul kaŋ Izirayel hugoo borey ra, wala yawey kaŋ ga waati tee i do ra, na kuri dumi kul kaŋ no ŋaa, ay gʼay ndumoo bere boraa se, de ay gʼa kaa nga jamaa ra. ");
INSERT INTO ses_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Zama hundikoyni hunaroo sii kala nga kuroo ra, agay, ay na war noo yaamar, kuroo kaŋ goo sargari tonadogoo boŋ ma zunubu tuusuyanoo tee war boŋ hundey se, zama kuri ra, gaaham hunaa goo, a ga zunubu tuusuyanoo tee. ");
INSERT INTO ses_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Woo se ay nee Izirayel borey se: “War ra, boro kul masi kuri ŋaa. Yawoo mo kaŋ ga waati tee war do masi kuri ŋaa.” ");
INSERT INTO ses_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Boro kul kaŋ Izirayel borey ra, wala yawey kaŋ ga waati tee i do ra na adabba wala ciraw kaŋ ga ŋandi hoo kʼa dii, a ma kuroo mun kʼa daabu nda labu. ");
INSERT INTO ses_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Zama hundikoyni kul, nga kuroo ti hundoo. Woo se ay nee Izirayel borey se: “War masi hundikoyni kul kuroo ŋaa, zama hundikoyni kul hundoo ti nga kuroo. Boro kul kaŋ nʼa ŋaa ma tuusandi.” ");
INSERT INTO ses_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Boro kul kaŋ no kaŋ na jifa wala adabba kaŋ hooga nʼa wii ŋaa, a ma tee ganda-ize wala yaw, boraa ma nga bankaarawey ɲumandi, a ma nga boŋ ɲumay nda hari, a ga žiibi hala almaaroo ra. Woo banda ga, a ga henan. ");
INSERT INTO ses_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Nda a manʼi ɲumay, a mana nga gaahamoo ɲumay, a ga nga layboo zaa.›» ");
INSERT INTO ses_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","«Šelaŋ Izirayel borey se, nee i se: ‹Agay ti Abadantaa, war Koyoo. ");
INSERT INTO ses_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","War masi teegoyoo tee kaŋ ga teendi Misira gandaa kaŋ ra war goro, war masi teegoyoo tee kaŋ ga teendi Kanaŋ gandaa kaŋ ra ay goo ma koy nda war. War masi hanga ngey hantumey. ");
INSERT INTO ses_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","War mʼay hantumey kaŋ kayandi ka goy, war mʼay hantumey dii kʼi ka dira. Agay ti Abadantaa, war Koyoo. ");
INSERT INTO ses_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Wʼay hantumey nda ay hantumey kaŋ kayandi dii, boro kaŋ gʼi ka goy ga huna nda ey. Agay ti Abadantaa. ");
INSERT INTO ses_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Aru kul masi too nga boro maanaa do ka dii nga gaa koonoo ka marga nda a. Agay ti Abadantaa. ");
INSERT INTO ses_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Masi ni baabaa kaynandi ka dii ni ɲaa gaa koonoo ka marga nda a. Ni ɲaa no, masi dii nga gaa koonoo ka marga nda a. ");
INSERT INTO ses_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Masi dii ni baabaa wandoo gaa koonoo ka marga nda a, ni baabaa gaa koonoo no. ");
INSERT INTO ses_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Masi dii ni woymaa gaa koonoo ka marga nda a, ni baabaa ize woyoo wala ni ɲaa ize woyoo, a hayandi hugoo ra wala hugu tana ra a hayandi. ");
INSERT INTO ses_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Masi dii ni izʼaroo ize woyoo wala ni ize woyoo ize woyoo gaa koonoo ka marga nda a, zama ni haawoo no. ");
INSERT INTO ses_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Masi dii ni baabaa wandoo ize woyoo kaŋ ni baabaa duu a a ga, gaa koonoo ka marga nda a, ni woymaa no. ");
INSERT INTO ses_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Masi dii ni baabaa woymaa gaa koonoo ka marga nda a, ni baabaa boro maana no. ");
INSERT INTO ses_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Masi dii ni ɲaa woymaa gaa koonoo ka marga nda a, zama ni ɲaa boro maana no. ");
INSERT INTO ses_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Masi dii ni baabaa armaa gaa koonoo ka marga nda a, masi too nga wandoo do, ni ɲaa no. ");
INSERT INTO ses_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Masi dii ni nzura woyoo gaa koonoo ka marga nda a, ni izʼaroo wandoo no, masi dii nga gaa koonoo ka marga nda a. ");
INSERT INTO ses_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Masi dii ni armaa wandoo gaa koonoo ka marga nda a, ni armaa haawoo no. ");
INSERT INTO ses_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Masi dii woy nda nga ize woyoo gaa koonoo ka marga nda a. Masi nga izʼaroo ize woyoo zaa ka marga nda a, masi nga ize woyoo ize woyoo zaa ka dii nga gaa koonoo ka marga nda a, boro maanayaŋ no, almuhal ti woo. ");
INSERT INTO ses_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Ni wandoo hunaroo ga, masi nga woymaa zaa ka dii nga gaa koonoo ka marga nda a, a ga kate waccetaray. ");
INSERT INTO ses_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Masi too woy do ka dii nga gaa koonoo ka marga nda a waati kaŋ a ga dii nga gaaham žiiboo. ");
INSERT INTO ses_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Masi marga nda ni gandaa boro wandoo, a ga ni žiibandi. ");
INSERT INTO ses_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Ni hayroo ra, masi boro kul tee sargari tooroo kaŋ maaɲoo ti Molok se. Masi ni Koyoo maaɲoo kaynandi. Agay ti Abadantaa. ");
INSERT INTO ses_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Masi kani nda aru sanda takaa kaŋ nda boro ga kani nda woy. Almuhal no. ");
INSERT INTO ses_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Masi kani nda adabba kul kaŋ no ka ni boŋ žiibandi a bande. Woy masi kay adabba jine ka marga nda a, haya futu-futu no. ");
INSERT INTO ses_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","War masi hayey wey affoo kul ka war boŋ žiibandi, zama dumey kaŋ ay goo mʼi gaaray war jine na ngey boŋ žiibandi nda hayey wey kul. ");
INSERT INTO ses_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Gandaa žiibi, ay nʼa noo nga zunuboo gurzugaa, gandaa na nga izey yeeri. ");
INSERT INTO ses_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Amma war, war mʼay hantumey nda ay hantumey kaŋ kayandi dii. Ganda-ize nda yaw kaŋ ga waati tee war do, war masi almuhaley wey affoo kul tee. ");
INSERT INTO ses_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Almuhaley wey kul borey kaŋ goro war jine gandaa ra nʼi tee. Gandaa bere ka žiibi. ");
INSERT INTO ses_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Gandaa masi koy war yeeri waati kaŋ war nʼa žiibandi takaa kaŋ nda a na gandaa yeeri kaŋ na war jin ka kaa. ");
INSERT INTO ses_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Boro kul kaŋ na almuhaley wey affoo tee, borey kaŋ gʼi tee ga hun ngi jamaa ra. ");
INSERT INTO ses_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","War ma hayaa dii kaŋ ay na noo war se war mʼa dii, taka kaŋ ra war masi alaada almuhalantey tee kaŋ teendi za war mana kaa. War masi war boŋ žiibandi i bande. Agay ti Abadantaa, war Koyoo.›» ");
INSERT INTO ses_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","«Šelaŋ Izirayel borey jamaa kul se, nee i se: ‹Wa henan, zama agay, Abadantaa, war Koyoo ga henan. ");
INSERT INTO ses_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","War affoo kul ma hunbur nga ɲaa nda nga baabaa, war mʼay hunanzamzaarey dii. Agay ti Abadantaa, war Koyoo. ");
INSERT INTO ses_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","War masi bere toorey here, war masi irkoyyaŋ tee war boŋ se nda guuru mennante. Agay ti Abadantaa, war Koyoo. ");
INSERT INTO ses_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Nda war ga alaafiya teendi sargaroo kaa Abadantaa maaɲoo ga, war mʼa kaa nda taka kaŋ ra a ma taandi. ");
INSERT INTO ses_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","A ma ŋandi hanoo kaŋ ra war nʼa kaa wala subaa ra, woo kaŋ cindi jirbi hinzantoo hane ma tonandi nuune ra ka tee boosu. ");
INSERT INTO ses_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Nda boro ŋaa a ra jirbi hinzantoo hane, haya hasarante no, a si taandi. ");
INSERT INTO ses_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Boro kaŋ ŋaa a ra ga nga layboo zaa, zama a na haya kaynandi kaŋ yeetandi jere ga Abadantaa se. Boraa woo ga hun nga jamaa ra. ");
INSERT INTO ses_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Waati kaŋ war ga war gandaa hegaa tee, masi ni faaroo hegay hala kanjey ra, masi hayey marga kaŋ ga hima ka kurma-kurmandi ni hegaa ra. ");
INSERT INTO ses_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Ni alaneb faaroo izey kaŋ cindi a ra hegaa banda ga, masʼi kaa, masi izey kaŋ kaŋ kurma-kurma. Mʼi naŋ talkey nda yawey se. Agay ti Abadantaa, war Koyoo. ");
INSERT INTO ses_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","War masi zay, war masi war gandaa boro zanba, war masi war gandaa boro hiila. ");
INSERT INTO ses_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","War masi žee taari ga nda ay maaɲoo, nda nʼnʼa tee, nʼga ni Koyoo maaɲoo kaynandi. Agay ti Abadantaa. ");
INSERT INTO ses_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Masi ni cinaa kom, masʼa zay. Ni goykaa banaa masi kani ni do hala subaa ra. ");
INSERT INTO ses_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Masi lutu danga, masi haya daŋ danaw jine kaŋ gʼa kaŋandi. Ma hunbur ni Koyoo. Agay ti Abadantaa. ");
INSERT INTO ses_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Masi borey fay-fay ciiti ra: masi talkaa ndumoo guna, masi almankoynoo jer. Ma ni gandaa boro ciiti nda šerretaray. ");
INSERT INTO ses_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Masi huru ka fatta ni jamaa ra ka miimanda. Masi kayandi ni cinaa kuroo ma mun. Agay ti Abadantaa. ");
INSERT INTO ses_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Masi ni armaa harram ni binoo ra. Masi goro mana ni gandaa boro daŋ fondaa ra, nga ra nʼsi nga zunuboo zaa. ");
INSERT INTO ses_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Masi faasa ni boŋ se, masi dooray dii ni binoo ra ni ɲaa-izey se, amma ma baa ni cinaa sanda takaa kaŋ nda nʼga baa ni boŋ. Agay ti Abadantaa. ");
INSERT INTO ses_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Wʼay hantumey dii. Ni adabbaa ra, masi ihinka kaŋ manʼti dumi foo marga nda cere. Masi dumi cine hinka say ni faaroo ra. Masi darbay daŋ kaŋ šilli dumi hinka nda a kayandi. ");
INSERT INTO ses_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Nda aru marga nda woy, ka gar kaŋ koŋŋa no kaŋ cewoo diyandi, a mana dayandi, a mana sawalandi, i ma zukandi, amma i masi wiiyandi, zama woyoo mana sawalandi. ");
INSERT INTO ses_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Aroo ma kate nga tooɲe sargaroo Abadantaa maaɲoo ga, cere kubayyan hukkumoo miɲoo ga, gaaru tooɲe sargaroo se. ");
INSERT INTO ses_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Sargari juwalkaa ma zunubu tuusuyanoo tee a se Abadantaa jine nda tooɲe sargaroo gaaroo nga zunuboo kaŋ a nʼa tee se, de nga zunuboo kaŋ a nʼa tee ga yaafandi. ");
INSERT INTO ses_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Waati kaŋ war huru gandaa ra, war na tuuri dumi kul kaŋ ga ŋandi duma, war ma izoo guna sanda haya kaŋ žiibi. A si bisa war se. Jiiri hinza a masi ŋandi. ");
INSERT INTO ses_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Jiiri taacantoo ra, ngi izey kul ga tee haya henanante ka Abadantaa saabu. ");
INSERT INTO ses_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Jiiri guwantoo ra, war ma izey ŋaa hala i ma boosu ka tonton war se. Agay ti Abadantaa, war Koyoo. ");
INSERT INTO ses_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","War masi haya kul ŋaa nda nga kuroo. War masi kotte, war masi gunandi. ");
INSERT INTO ses_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","War masi war boŋ hinbirey carawey kaa, masi ni kaaboo miɲoo kosu, ");
INSERT INTO ses_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","war masi tooru-tooruyaŋ kaa war gaahamoo ga bukaw se, war masi tammaasa žeeri war ga. Agay ti Abadantaa. ");
INSERT INTO ses_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Masi ni izoo kaynandi kʼa tee woykuuru, hala gandaa masi koy tee woykuuru, a masi too nda almuhal. ");
INSERT INTO ses_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","War mʼay hunanzamzaarey dii, war mʼay nongu henanantaa beerandi. Agay ti Abadantaa. ");
INSERT INTO ses_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","War masi bere borey here kaŋ ga bukawey cee kʼi hãa, i ga haya har kaŋ ga kaa ka tee, war masʼi ceeci, war masi koy žiibi i bande. Agay ti Abadantaa, war Koyoo. ");
INSERT INTO ses_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Ma aladabu hinbiri kaaraykoyni jine, ma boro žeena beerandi, ma hunbur ni Koyoo. Agay ti Abadantaa. ");
INSERT INTO ses_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Nda yaw ga waati tee ni bande war gandaa ra, war masʼa šiita. ");
INSERT INTO ses_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Yawoo kaŋ ga waati tee war bande, war mʼa dii sanda ganda-ize cimi, ma bagʼa sanda takaa kaŋ nda nʼga baa ni boŋ, zama war tee yaw Misira gandaa ra. Agay ti Abadantaa, war Koyoo. ");
INSERT INTO ses_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","War masi borey fay-fay ciiti ra, wala haya kuuyan neešiyan ra, wala haya tiŋay neešiyan ra, wala mudu ra. ");
INSERT INTO ses_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Basikiloo ma šerre, neeša tondey ma šerre, kilowoo ma šerre, liitaroo ma šerre. Agay ti Abadantaa, war Koyoo kaŋ na war fattandi Misira gandaa ra. ");
INSERT INTO ses_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","War mʼay hantumey kul nda ay hantumey kaŋ kayandi kul dii, war mʼi ka goy. Agay ti Abadantaa.›» ");
INSERT INTO ses_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","«Izirayel borey, nee i se: ‹Boro kul kaŋ Izirayel borey ra, wala yawey kaŋ ga waati tee Izirayel ra, nga hayroo ra a na affoo noo Molok se, a waazibi boraa ma wiiyandi. Gandaa borey mʼa warra nda tondi kʼa wii. ");
INSERT INTO ses_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Agay, ay gʼay ndumoo bere boraa din se, de ay gʼa kaa nga jamaa ra, zama nga hayroo ra a na affoo noo Molok maaɲoo ga kʼay nongu henanantaa žiibandi kʼay maa henanantaa kaynandi. ");
INSERT INTO ses_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Nda gandaa borey na ngi moɲey daabu aroo woo kaŋ nga hayroo ra, a na affoo noo Molok maaɲoo ga teegoyey ga, i manʼa wii, ");
INSERT INTO ses_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ay gʼay ndumoo bere boraa din nda nga alaayan beeroo se, nga nda borey kul kaŋ ga izefututaray tee a bande, ka izefututaray tee Molok bande, ay gʼi kaa ngi jamaa ra. ");
INSERT INTO ses_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Boro kaŋ bere borey here kaŋ ga bukawey cee kʼi hãa, i ga haya har kaŋ ga kaa ka tee ka marga i bande ka izefututaray tee, ay gʼay ndumoo bere boraa din se, de ay gʼa kaa nga jamaa ra. ");
INSERT INTO ses_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Wa war boŋ henanandi ka tee henananteyaŋ, zama agay ti Abadantaa, war Koyoo. ");
INSERT INTO ses_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Wʼay hantumey dii, war mʼi ka goy. Agay ti Abadantaa kaŋ ga war henanandi. ");
INSERT INTO ses_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Boro kul kaŋ na nga baabaa wala nga ɲaa danga šikka sii ga wiiyandi. A na nga baabaa wala nga ɲaa danga, nga hundoo alhakoo goo a ga. ");
INSERT INTO ses_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Nda aru na zina nda woyhiiji, a marga nda nga cinaa wandoo, aru nda woy zinateeroo šikka sii ga wiiyandi. ");
INSERT INTO ses_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Aru kaŋ kani nda nga baabaa wandoo, a dii nga baabaa gaa koonoo ka marga nda a, ngi boro hinkaa kul šikka sii ga wiiyandi. Ngi hundey alhakey goo i ga. ");
INSERT INTO ses_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Aru kaŋ kani nda nga izʼaroo wandoo, ngi boro hinkaa kul šikka sii ga wiiyandi, haya futu-futu no i nʼa tee. Ngi hundey alhakey goo i ga. ");
INSERT INTO ses_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Aru kaŋ kani nda aru sanda takaa kaŋ nda boro ga marga nda woy, ngi boro hinkaa kul na almuhal tee, šikka sii i ga wiiyandi. Ngi hundey alhakey goo i ga. ");
INSERT INTO ses_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Aru kaŋ na woy nda nga ɲaa zaa hiijay, almuhal no, i ma tonandi nuune ra ka tee boosu, aroo nda woyoo, hala almuhaloo woo dumoo masi teendi war do. ");
INSERT INTO ses_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Aru kaŋ kani nda adabba, šikka sii a ga wiiyandi, war ma adabbaa mo wii. ");
INSERT INTO ses_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Woy kaŋ man adabba ka marga nda a, ma woyoo nda adabbaa wii. Šikka sii i ga wiiyandi, ngi hundey alhakey goo i ga. ");
INSERT INTO ses_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Aru kaŋ na nga woymaa zaa hiijay, baaboo ize woyoo wala ɲaŋoo ize woyoo, de a dii nga woymaa gaa koonoo ka marga nda a, woymaa dii nga armaa gaa koonoo ka marga nda a, haawi no, i ma tuusandi ka hun ngi ɲaa-izey moɲey cire. A dii nga woymaa gaa koonoo ka marga nda a, a ga nga layboo zaa. ");
INSERT INTO ses_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Aru kaŋ kani nda woy kaŋ goo ma dii nga gaaham žiiboo, a dii nga gaa koonoo ka marga nda a, a na woyoo kuroo mandiroo fatawandi, de woyoo na nga kuri mandiroo fatawandi. Ngi boro hinkaa kul ga hun ngi jamaa ra. ");
INSERT INTO ses_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Masi dii ni ɲaa woymaa wala ni baabaa woymaa gaa koonoo ka marga nda a, zama boro kaŋ na woo tee na nga boro maanaa fatawandi. Ngi boro hinkaa ga ngi layboo zaa. ");
INSERT INTO ses_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Aru kaŋ kani nda nga hasaa wandoo, a dii nga hasaa gaa koonoo ka marga nda a, ngi zunuboo ga hanga ey, i ga buu bila ize. ");
INSERT INTO ses_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Aru kaŋ na nga armaa wandoo zaa hiijay, taka žiibi no, a dii nga armaa gaa koonoo ka marga nda a, i si duu ize. ");
INSERT INTO ses_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","War mʼay hantumey nda ay hantumey kaŋ kayandi kul dii, war mʼi ka goy hala gandaa kaŋ ra ay goo ma war daŋ war ma goro masi koy war yeeri. ");
INSERT INTO ses_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","War masi dira dumey kaŋ ay gʼi gaaray war jine hantumey bande, zama i na hayey wey kul tee, ay konna ey. ");
INSERT INTO ses_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Ay nee war se: “War no ma ngi laboo mayray, agay no kʼa noo war se, war mʼa mayray, ganda no kaŋ ra waa nda yuu ga tee hari.” Agay ti Abadantaa, war Koyoo kaŋ na war nda gandawey fay kʼi kaa cere ra. ");
INSERT INTO ses_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","War ma adabba halalantey, nda iharramantey, nda ciraw harramantey, nda ihalalantey fay kʼi kaa cere ra, hala war masi war boŋ tee haya wangante nda adabbawey, wala cirawey, wala haya kul kaŋ ga ziilam-ziilam laboo ga, kaŋyaŋ ay nʼi fay kʼi kaa cere ra ka bayrandi kaŋ i ga harram. ");
INSERT INTO ses_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Wa tee henananteyaŋ ya ne, zama agay, Abadantaa, ay ga henan. Ay na war nda gandawey fay ka war kaa cere ra hala war ma tee ay mayraa. ");
INSERT INTO ses_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Aru wala woy kaŋ ga bukawey cee kʼi hãa, wala i ga gunandi, šikka sii i ga wiiyandi, i ma tondi warra kʼi wii. Ngi hundey alhakey goo i ga.›» ");
INSERT INTO ses_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Abadantaa nee Musa se: «Šelaŋ sargari juwalkey, Haruna izʼarey se, nee i se: ‹Sargari juwalkaw masi nga boŋ žiibandi nda bukaw nga borey ra, ");
INSERT INTO ses_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","nda manʼti nga boro maana no, nga ɲaa, wala nga baabaa, wala nga izʼaroo, wala nga ize woyoo, wala nga armaa. ");
INSERT INTO ses_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","Nga woymaa gundoo kaŋ si aru bay, kaŋ mana hiiji, nga se, a ga hin ka nga boŋ žiibandi. ");
INSERT INTO ses_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Nda aruhiiji no, a masi nga boŋ žiibandi nga borey ra ka nga boŋ kaynandi. ");
INSERT INTO ses_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","I masi taylel kaa ngi boŋey ra, i masi ngi kaabey kanjey cebu, i masi tooru-tooruyaŋ kaa ngi gaahamoo ga. ");
INSERT INTO ses_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","I ma tee henananteyaŋ ngi Koyoo maaɲoo ga, i masi ngi Koyoo maaɲoo kaynandi, zama ngi no ma kate sargari tonantey Abadantaa maaɲoo ga, ngi Koyoo ŋaahayaa: i ma henan. ");
INSERT INTO ses_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","I masi woykuuru wala woy kaŋ maaɲoo hasara zaa hiijay, i masi woy zaa kaŋ kurɲoo nʼa fay, zama sargari juwalkaw ga henan, a yeetandi jere ga nga Koyoo se. ");
INSERT INTO ses_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Mʼa dii sanda henanante, zama nga no ma ni Koyoo ŋaahayaa ka too, a ma tee ma ne henanante, zama ay ga henan, agay kaŋ ti Abadantaa no ma war henanandi. ");
INSERT INTO ses_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Nda sargari juwalkaw ize woy na nga boŋ hasara ka tee woykuuru, a na nga baabaa kaynandi, woykaynaa ma tonandi nuune ra ka tee boosu. ");
INSERT INTO ses_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Sargari juwalkaw beeroo kaŋ bisa nga armey, woo kaŋ boŋoo ga yonyan jiyoo doorandi, woo kaŋ yeetandi jere ga ka darbawey henanantey daŋ, a masi nga boŋoo feeri, a masi nga kaayey kottu. ");
INSERT INTO ses_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","A masi koy bukaw kul here, ba nda nga baabaa wala nga ɲaa no, a masi nga boŋ žiibandi. ");
INSERT INTO ses_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","A masi hun nongu henanantaa ra, a masi nga Koyoo nongu henanantaa kaynandi, zama nga Koyoo yonyan jiyoo goo a ga kʼa daŋ jere ga nga se. Agay ti Abadantaa. ");
INSERT INTO ses_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Woy kaŋ si aru bay no a mʼa zaa hiijay. ");
INSERT INTO ses_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","A masi woy kaŋ kurɲoo buu, wala woykurunbu, wala woy kaŋ maaɲoo hasara nda woykuurutaray zaa hiijay. A ma woy zaa kaŋ si aru bay, nga borey ra. ");
INSERT INTO ses_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","A masi nga hayroo kaynandi nga jamaa ra, zama agay ti Abadantaa kaŋ gʼa henanandi.›» ");
INSERT INTO ses_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Abadantaa yee ka šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","«Nee Haruna se: ‹Ni hayroo ra, ngi alwaddawey ra, aru kul kaŋ malal goo a ga masi nga Koyoo ŋaahayaa ka too. ");
INSERT INTO ses_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Zama aru kul kaŋ ga malal goo masi man, a ma tee danaw aru wala bongu, wala niine šiira, wala boro kaŋ cewey bisa cere, ");
INSERT INTO ses_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","wala aru kaŋ cewoo wala kaboo kayri, ");
INSERT INTO ses_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","wala koomakoyni, wala boro dungurya, wala aru kaŋ kaaray goo moɲoo ra, wala kursakoyni, wala teɲacindikoyni, wala aru kaŋ maamey tutubandi. ");
INSERT INTO ses_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Sargari juwalkaa Haruna, nga hayroo ra, aru kul kaŋ ga malal goo masi man ka sargari tonantey kaa Abadantaa maaɲoo ga. Malal bara a ga, a masi man kate nda nga Koyoo ŋaahayaa. ");
INSERT INTO ses_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","A ga hin ka nga Koyoo ŋaahayaa ŋaa, hayayaŋ kaŋ ga hanse ka henan, nda hayayaŋ kaŋ ga henan. ");
INSERT INTO ses_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Amma a masi koy ridowoo here, a masi man sargari tonadogoo, zama malal goo a ga. A masʼay nongu henanantey kaynandi, zama agay ti Abadantaa kaŋ gʼi henanandi.›» ");
INSERT INTO ses_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Woo no Musa nʼa har Haruna nda nga izʼarey nda Izirayel borey kul se. ");
INSERT INTO ses_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","«Šelaŋ Haruna nda nga izʼarey se kaŋ i ma sargarey dii ka boori kaŋ Izirayel borey gʼi daŋ ya ne jere ga, hala i masi koy ay maa henanantaa kaynandi. Agay ti Abadantaa. ");
INSERT INTO ses_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Nee i se: ‹War alwaddawey ra, war hayroo ra, boro kul kaŋ goo žiibi ra kaŋ man kate sargari henanantey do kaŋ Izirayel borey gʼi daŋ jere ga Abadantaa se, boraa din ga hun ay jine. Agay ti Abadantaa. ");
INSERT INTO ses_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Boro kul kaŋ Haruna hayroo ra, a tee boro kaŋ ga jiray dumi goo wala nga harimundogoo ga mandi masi ŋaa sargari henanantey ra hala waati kaŋ a henan. Takaa din da, boro kaŋ tuku boro ga kaŋ bukaw tukuyan kʼa žiibandi, wala aru kaŋ nga almaaniyoo mun a ga, ");
INSERT INTO ses_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","wala boro kaŋ tuku gandako kul kaŋ no ga kaŋ gʼa žiibandi, wala adamize ga ka nga boŋ žiibandi nda žiibi dumi kul kaŋ no, ");
INSERT INTO ses_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","boro kaŋ tuku a ga, ga žiibi hala almaaroo ra. A masi ŋaa sargari henanantey ra nda a mana nga gaahamoo ɲumay nda hari. ");
INSERT INTO ses_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Waynaa kaŋyanoo ga, a ga henan, woo banda ga, a ma ŋaa sargari henanantey ra, zama nga ŋaahayaa no. ");
INSERT INTO ses_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","A masi jifa wala adabba kaŋ hooga nʼa wii ŋaa ka nga boŋ žiibandi nda a. Agay ti Abadantaa. ");
INSERT INTO ses_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","I mʼay talfoo dii, i mʼa dii hala i masi zunubu zaa ka buu ay yaamaroo kaynandiyanoo sabbu se. Agay ti Abadantaa kaŋ gʼi henanandi. ");
INSERT INTO ses_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Boro tana kul masi sargari henanante ŋaa. Boro kaŋ ga waati tee sargari juwalkaw do nda sargari juwalkaa goykaa masi sargari henanante ŋaa. ");
INSERT INTO ses_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Amma nda sargari juwalkaa na nga nooroo ka boro day, a ma tee nga mayraa, boraa din ga hin kʼa ŋaa, nga nda boro kaŋ hayandi nga hugoo ra, ngi no ma hin ka ŋaa nga ŋaahayaa ra. ");
INSERT INTO ses_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Nda sargari juwalkaw ize woyoo tee ceewaani wande, a masi sargari ŋaa kaŋ hun sargari henanantey ra. ");
INSERT INTO ses_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Amma nda sargari juwalkaw ize woyoo tee woy kaŋ kurɲoo buu wala woykurunbu, a mana duu ize, de a yee nga baabaa hugoo do sanda waatoo kaŋ a ga zanka, a ma ŋaa nga baabaa ŋaahayaa ra. Boro tana kul masi ŋaa a ra. ");
INSERT INTO ses_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Nda boro firka ka sargari henanante ŋaa, a ma hayaa hinnaa bana sargari juwalkaa se ka affoo tonton igguu foo kul ga. ");
INSERT INTO ses_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Sargari juwalkey masi Izirayel borey sargari henanantey kaynandi kaŋ i nʼi kaa Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","I gʼi jerandi zunubu kaŋ ga hima ka hansandi nda i na ngi sargari henanantey ŋaa, zama agay ti Abadantaa kaŋ gʼi henanandi.›» ");
INSERT INTO ses_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Abadantaa yee ka šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","«Šelaŋ Haruna nda nga izʼarey nda Izirayel borey kul se, nee i se: ‹Izirayel hugoo borey kul nda yaw kaŋ goo Izirayel ra kaŋ na nga sargari kukurantaa kaa Abadantaa maaɲoo ga, a ma tee meefur kul kaŋ no se wala sargari kaŋ a nʼa kaa nda nga boŋ haya kul kaŋ no se, ");
INSERT INTO ses_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","hala a ma duu ka taandi, a ma aru kaŋ ga malal sii sarga hawey, wala feejey, wala hanciney ra. ");
INSERT INTO ses_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","War masi kate alman kul kaŋ ga malal goo, zama a si taandi war se. ");
INSERT INTO ses_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Nda boro na alman beeri wala ibuuna kaa alaafiya teendi sargaroo Abadantaa maaɲoo ga, a ma tee meefur no a ga bana wala a mmʼa kaa nda nga boŋ, hala adabbaa ga taandi, kala a ma tee haya kaŋ ga malal sii. Malal masi bara a ga. ");
INSERT INTO ses_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Adabba danaw, wala ceekayra, wala haya kaŋ nongu dunbu a ra, wala dori goo kuuroo ga, wala kursakoyni, wala teɲacindikoyni, wey, war masʼi kaa sargari Abadantaa maaɲoo ga. War masi sargari tee i ra kʼa kaa sargari tonadogoo ga kʼa tee sargari tonante Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Nʼga hin ka haw, wala alman buuna kaŋ cewey bisa cere wala cee faa ga dunbay kaa sargari nda ni boŋ, amma a si hin ka tee meefur sargari, a si taandi. ");
INSERT INTO ses_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","War masi alman kaŋ foorey kukuši, wala i tutubu, wala i dogandi, wala i dunbandi kaa sargari Abadantaa maaɲoo ga. War masi woo tee war gandaa ra. ");
INSERT INTO ses_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Ba yaw, war masi adabbawey wey cine taa a kone kʼi kaa ŋaayan war Koyoo maaɲoo ga. Nda taali wala malal goo i ga, i si taandi war se.›» ");
INSERT INTO ses_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Abadantaa yee ka šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","«Nda haw, wala feeji, wala hancin hayandi, a ma cindi jirbi iyye ɲaŋoo bande, za jirbi yaahantoo hane nda waatey kaŋ goo dumaa ga, a ga taandi nda nʼnʼa kaa sargari tonante Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","War masi haw wala alman buuna, nga nda nga izoo koosu zaari follokaa ra. ");
INSERT INTO ses_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Nda war na albarka daŋyan sargari kaa Abadantaa maaɲoo ga, war mʼa kaa taka kaŋ ra a ma duu ka taandi war se. ");
INSERT INTO ses_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","A ma ŋandi zaari follokaa ra, haya kul masi cindi a ra hala subaa ra. Agay ti Abadantaa. ");
INSERT INTO ses_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","War mʼay yaamarey dii, war mʼi ka goy. Agay ti Abadantaa. ");
INSERT INTO ses_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","War masʼay maa henanantaa kaynandi, hala ay ma zandi henanante Izirayel borey game. Agay ti Abadantaa kaŋ ga war henanandi, ");
INSERT INTO ses_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","kaŋ na war fattandi Misira gandaa ra hala ya tee war se Irkoy. Agay ti Abadantaa.» ");
INSERT INTO ses_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","«Šelaŋ Izirayel borey se, nee i se: ‹Abadantaa jingarey ti waatey kaŋ ra war ma margari henananteyaŋ kayandi, ay jingarey ne: ");
INSERT INTO ses_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Jirbi iddu goy ma teendi, amma jirbi iyyantoo ti hunanzamzaaroo kaŋ bisa hunanzamzaarey jerey, margari henanante ma tee. Goy kul masi teendi a ra. Hunanzamzaari no Abadantaa maaɲoo ga, nongu kul kaŋ ra war goro. ");
INSERT INTO ses_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Abadantaa jingarey ne, margari henanantey no kaŋ war mʼi tee waatoo kaŋ kayandi ra: ");
INSERT INTO ses_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Handu jinaa, jirbi woy cindi taacantoo (14to), almaaroo ra, nga ti Borcintaraa jingaroo Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Handoo din jirbi woy cindi guwantoo (15to) ti Takulawey kaŋ ra dolobiri sii jingaroo Abadantaa maaɲoo ga. Jirbi iyye war ma takula ŋaa kaŋ ra dolobiri sii. ");
INSERT INTO ses_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Zaari jinaa war ma margari henanante tee, war masi goy šenda kul tee. ");
INSERT INTO ses_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","War ma jirbi iyye tee war ga sargari tonanteyaŋ kaa Abadantaa maaɲoo ga. Jirbi iyyantoo hane war ma margari henanante tee, war masi goy šenda kul tee.›» ");
INSERT INTO ses_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Abadantaa yee ka šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","«Šelaŋ Izirayel borey se, nee i se: ‹Waati kaŋ war huru gandaa ra kaŋ ay gʼa noo war se, de war na hegaa tee, war ma kate sargari juwalkaa se war hegaa jeeni terenji jinaa. ");
INSERT INTO ses_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","A ma terenjoo zinji Abadantaa jine, hala a ma duu ka taandi war se. Sargari juwalkaa mʼa zinji hunanzamzaaroo subaa ra. ");
INSERT INTO ses_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Hanoo kaŋ ra war ga terenjoo zinji, war ma feeji-ize kaŋ ga malal sii kaŋ goo nda jiiri foo kaa sargari kukurante Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","War ma taasu sargari, farin hamni kilo iddu kaŋ loobandi nda jii daŋ a bande, a ma tee sargari tonante Abadantaa maaɲoo ga kaŋ sunnaaraa ga kan. War ma alaneb hari moora liitar foo nda jere kaa sargari hari-hari. ");
INSERT INTO ses_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","War masi takula ŋaa, war masi taasu gurunbu haagante ŋaa, war masi jeeni ŋaa hala hanoo hunday kaŋ ra war kate war Koyoo maaɲoo ga nga sargaroo. Hantum kaŋ si tun no war alwaddawey se, nongu kul kaŋ ra war goro.›» ");
INSERT INTO ses_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","«‹War ma kabu za hunanzamzaaroo subaa ra, za hanoo kaŋ ra war kate jeeni terenjoo kaŋ tee sargari zinji-zinjantaa: yoobu iyye timmante ma teendi. ");
INSERT INTO ses_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","War ma kabu jirbi woyguu (50) ka koy hala hunanzamzaari iyyantoo subaa ra, hanoo din, war ma taasu sargari taaga kaa Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","War ma takula hinka ka hun war nongoo kaŋ ra war goro kʼi tee sargari zinji-zinjante, ihinkaa kul ma hansandi nda farin hamni kilo iddu cine. Dolobiri ma huru i ra ka tonandi. Ŋaayan jinaa no kaŋ ga nondi Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Takulaa bande war ma kate feeji-ize iyye kaŋyaŋ goo nda jiiri foo kaŋ ga malal sii, nda yaaru foo, nda gaaru hinka. I ma tee sargari kukurante Abadantaa maaɲoo ga. Taasu sargaroo, nda sargari hari-haroo ma tee sargari tonante kaŋ sunnaaraa ga kan Abadantaa se. ");
INSERT INTO ses_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","War ma jindaaru foo kaa zunubu sargaroo se, nda feeji-ize hinka kaŋyaŋ goo nda jiiri foo, i ma tee alaafiya teendi sargaroo. ");
INSERT INTO ses_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Sargari juwalkaa mʼi zinji nda takula jina-jinawey, i ma tee sargari zinji-zinjante Abadantaa jine feeji-ize hinkaa bande. I ga henan, i ga yeetandi jere ga Abadantaa se, sargari juwalkaa ma duu ey. ");
INSERT INTO ses_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Hanoo din hunday no war ma kayandi ka margari henanante tee, war masi goy šenda kul tee. Hantum kaŋ si tun no, nongu kul kaŋ ra war goro, war alwaddawey se. ");
INSERT INTO ses_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Waati kaŋ war ga war gandaa hegaa tee, masi ni faaroo hegay hala kanjey ra. Masi hayey marga kaŋ ga hima ka kurma-kurmandi ni hegaa ra. Mʼi naŋ talkey nda yawey se. Agay ti Abadantaa, war Koyoo.›» ");
INSERT INTO ses_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Abadantaa yee ka šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","«Šelaŋ Izirayel borey se ka nee: ‹Handu iyyantoo zaari jinaa, zaaroo kaŋ ra war ga hunanzam, a ma tee hongandihaya kaŋ ra war ma kaati ka ciya ka margari henanante tee. ");
INSERT INTO ses_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","War masi goy šenda kul tee, war ma kate Abadantaa maaɲoo ga sargari tonante.›» ");
INSERT INTO ses_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Abadantaa yee ka šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","«De mo handu iyyantoo jirbi woyantoo (10to) ti Zunubu tuusuyanoo zaaroo, war ma margari henanante tee, war ma meehaw, war ma sargari tonante kaa Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","War masi goy kul tee hanoo din, zama zunubu tuusuyan zaari no ka war zunubey tuusu Abadantaa, war Koyoo jine. ");
INSERT INTO ses_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Zama boro kul kaŋ mana meehaw hanoo din hunday ra, ga hun nga jamaa ra. ");
INSERT INTO ses_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Boro kul kaŋ na goy kul kaŋ no tee hanoo din, boraa din, ay gʼa halaci nga jamaa game. ");
INSERT INTO ses_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","War masi goy kul tee. Hantum kaŋ si tun no war alwaddawey se, nongu kul kaŋ ra war goro. ");
INSERT INTO ses_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Hunanzamzaaroo no kaŋ bisa hunanzamzaarey jerey, war ma meehaw. Handoo jirbi yaggantoo cijinoo ka koy cijin faa ma tee war hunanzamzaaroo.» ");
INSERT INTO ses_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Abadantaa yee ka šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","«Šelaŋ Izirayel borey se ka nee: ‹Handu iyyantoo jirbi woy cindi guwantoo (15to) ga, Tendewey jingaroo ga teendi jirbi iyye Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Zaari jinaa margari henanante ma tee, war masi goy šenda kul tee. ");
INSERT INTO ses_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","War ma jirbi iyye tee kaŋ ra war ga sargari tonante tee Abadantaa maaɲoo ga. Jirbi yaahantoo ra war ma margari henanante tee, war ma sargari tonante kaa Abadantaa maaɲoo ga, margari kokorante no, war masi goy šenda kul tee. ");
INSERT INTO ses_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Wey ti Abadantaa jingarey kaŋ war mʼi kayandi sanda margari henananteyaŋ hala war ma sargari tonanteyaŋ kaa Abadantaa maaɲoo ga, nda sargari kukuranteyaŋ, nda taasu sargariyaŋ, nda sargari tanayaŋ, nda sargari hari-hariyaŋ, ngi affoo kul ma nondi zaaroo kaŋ kayandi ra. ");
INSERT INTO ses_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Sargarey wey ga tonton ka teendi Abadantaa hunanzamzaarey ga, war sargarey ga, nda war meefurey kul ga, nda sargarey kul ga kaŋ war gʼi kaa nda war boŋ Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Amma handu iyyantoo jirbi woy cindi guwantoo (15to), waati kaŋ war na gandaa faari-izey hegay ka ben, war ma jingar tee Abadantaa maaɲoo ga jirbi iyye. Zaari jinaa ma tee zaari kaŋ ra war ga hunanzam, jirbi yaahantoo mo ma tee hunanzamzaari. ");
INSERT INTO ses_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Zaari jinaa war ma tuuri henney izeyaŋ, nda teenayɲaa sarbayyaŋ, nda tuuri guzubu kabeyaŋ, nda isa tuuri kaŋ ga hima nda turaariɲaa kabeyaŋ zaa ka hooray tee Abadantaa, war Koyoo jine jirbi iyye. ");
INSERT INTO ses_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Jiiri kul war ma jingaroo woo tee Abadantaa maaɲoo ga jirbi iyye. Hantum kaŋ si tun no war hayroo se. War ma jingaroo tee handu iyyantoo ra. ");
INSERT INTO ses_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","War ma goro tende cire jirbi iyye, boro kul kaŋ ti ganda-ize Izirayel ra ma goro tende ra, ");
INSERT INTO ses_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","hala war hayroo ma bay kaŋ ay na Izirayel borey gorandi tendeyaŋ ra waatoo kaŋ ay nʼi fattandi Misira gandaa ra. Agay ti Abadantaa, war Koyoo.›» ");
INSERT INTO ses_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Takaa woo nda Musa na Abadantaa jingarey har Izirayel borey se. ");
INSERT INTO ses_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","«Izirayel borey yaamar i ma kate ma ne fitilla gorodogoo se jii alhakiika kaŋ mana hun kala zaytu musayante ra, hala fitilla ma dii waati kul. ");
INSERT INTO ses_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Seedetaraa ridowoo se taray, cere kubayyan hukkumoo ra, waati kul Haruna mʼa hanse Abadantaa jine, za cijinoo ra hala subbaahi. Hantum kaŋ si tun no war alwaddawey se. ");
INSERT INTO ses_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","A ma fitillawey hanse fitilla gorodoo henanantaa ga waati kul Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Ma farin hamni zaa, ma wijila woy cindi hinka (12) hina, affoo kul ma tee kilo iddu cine. ");
INSERT INTO ses_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Mʼi tee hodadda hinka, hodadda foo kul ize iddu ma bara a ra, taabal henanantaa ga Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Hodadda foo kul, ma dugu alhakiika daŋ a ga, a ma tee hongandihaya takulaa kaŋ ti wijila dogoo ra, sargari tonante Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Hunanzamzaari kul hane, a mʼi kanandi Abadantaa jine waati kul, i ma hun Izirayel borey do. Amaana kaŋ si tun no. ");
INSERT INTO ses_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Haruna nda nga izʼarey ma duu ey, i mʼi ŋaa nongu henanante ra, zama i ga tee a se haya kaŋ ga hanse ka henan sargari tonantey ra kaŋ i gʼi kaa Abadantaa maaɲoo ga. Yaamar kaŋ si tun no.» ");
INSERT INTO ses_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Izirayel woy foo izʼaroo kaŋ baaboo ti Misira boro kaa Izirayel borey do, Izirayel woyoo izʼaroo nda Izirayel aru foo na cere kar jamaa kaloo ra. ");
INSERT INTO ses_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Izirayel woyoo izʼaroo na Abadantaa maaɲoo wow kʼa kaynandi. I kate a Musa do. Ɲaŋoo maaɲoo ti Šelomit, Dibiri kaŋ goo Dan alkabiilaa ra ize woyoo no. ");
INSERT INTO ses_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","I nʼa dii kʼa lakkal hala i ga kaa ka dii hayaa kaŋ Abadantaa meešennoo gʼa har. ");
INSERT INTO ses_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Abadantaa yee ka šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","«Wa aroo kaŋ nʼay kaynandi fattandi jamaa kaloo se taray, borey kul kaŋ maa hayaa kaŋ a nʼa har ma ngi kabey fur boŋoo ga, de jamaa kul ma tondi warra kʼa wii. ");
INSERT INTO ses_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Ma šelaŋ Izirayel borey se ka nee: ‹Boro kul kaŋ na nga Koyoo kaynandi, nga zunuboo gʼa hanga a. ");
INSERT INTO ses_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Boro kaŋ na Abadantaa maaɲoo kaynandi, šikka sii boraa ga wiiyandi: jamaa kul ga hima kʼa warra nda tondi kʼa wii. A ma tee yaw wala ganda-ize, nda a na Irkoy wow a ma wiiyandi. ");
INSERT INTO ses_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Nda boro mo na boro kul kaŋ no kar hala a buu, šikka sii koyoo ga wiiyandi. ");
INSERT INTO ses_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Boro kaŋ na adabba kar hala a buu mʼa bana, hundi no ma hundi bana. ");
INSERT INTO ses_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Nda boro na nga gandaa boro malal, a ma banandi a ra sanda takaa kaŋ a nʼa tee. ");
INSERT INTO ses_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Kayri no ma kayri bana, moo no ma moo bana, hiɲe no ma hiɲe bana. I mʼa malal sanda takaa kaŋ nda a na boraa malal. ");
INSERT INTO ses_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Boro kaŋ na adabba kar hala a buu mʼa bana, amma boro kaŋ na boro kar hala a buu ma wiiyandi. ");
INSERT INTO ses_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Hantum folloku kaŋ kayandi no yaw nda ganda-ize se, zama agay ti Abadantaa, war Koyoo.›» ");
INSERT INTO ses_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Musa šelaŋ Izirayel borey se, i na boraa kaŋ na Irkoy kaynandi fattandi jamaa kaloo se taray, i nʼa warra nda tondi kʼa wii. Izirayel borey na tee nda takaa kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Abadantaa šelaŋ Musa se Sinay tondi hondoo boŋ ka nee: ");
INSERT INTO ses_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","«Šelaŋ Izirayel borey se, nee i se: ‹Waati kaŋ war huru gandaa ra kaŋ ay gʼa noo war se, war ma laboo taŋ a ma duu hunanzamay Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Jiiri iddu ma saya ni faaroo ra, jiiri iddu ma ni alaneb faaroo tuurey kabey hanse, ma gandaa faari-izey hegay. ");
INSERT INTO ses_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Amma jiiri iyyantoo ma tee hunanzamay jiiri, jiiri kaŋ ra laboo ga hunanzam, hunanzamay Abadantaa maaɲoo ga: masi saya ni faaroo ra, masi ni alaneb faaroo tuurey kabey hanse. ");
INSERT INTO ses_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Masi hayaa hegay kaŋ kaŋ ka hun ni hegay kokorantaa ra ka zay, masi alaneb-izey kosu ni alaneb faaroo kaŋ tuurey kabey mana hansandi ra: a ma tee hunanzam jiiri laboo se. ");
INSERT INTO ses_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Haya kaŋ laboo na hay nga hunanzam waatoo ra ma tee meehunay, ni, nda ni baɲɲaa, nda ni koŋŋaa, nda goykaa kaŋ nʼgʼa bana, nda boraa kaŋ ga waati tee ni do, ");
INSERT INTO ses_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","nda ni almaney, nda hoogawey kaŋ goo ni gandaa ra, nga faari-izey kul ma tee meehunay.›» ");
INSERT INTO ses_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","«‹Ma hunanzam jiiri iyye kabu, jiiri iyye hala cee iyye, hunanzam jiiri iyye ga sawa nda jiiri woytaaci cindi yagga (49). ");
INSERT INTO ses_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Woo banda ga, handu iyyantoo, jirbi woyantoo (10to), ma hilloo hẽenandi ka boori, Zunubu tuusuyanoo zaaroo, hilloo ma hẽenandi war gandaa kul ra. ");
INSERT INTO ses_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","War ma jiiri woyguwantoo (50to) kayandi jiiri henanante, war ma gandaa borey kul sawalyanoo bayrandi. A ma tee war se Sawalyanoo jiiri, boro kul ma yee nga mayrawey ra, boro foo kul ma koy nga alaayan beeroo do. ");
INSERT INTO ses_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Jiiri woyguwantoo (50to) din ma tee war se Sawalyanoo jiiri. War masi saya, war masi hayey hegay kaŋ zay nda ngi boŋ. War masi alaneb faaroo hegay kaŋ tuurey kabey mana hansandi, ");
INSERT INTO ses_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","zama Sawalyanoo jiiroo no, a ma tee war se haya henanante. War ma war faari-izey ŋaa. ");
INSERT INTO ses_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Sawalyanoo jiiroo woo ra war boro foo kul ma yee nga mayrawey ra. ");
INSERT INTO ses_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Nda war ga maamala, ma neere ni gandaa boro se wala ma day ni gandaa boro ga, war boro kul masi nga gandaa boro zanba. ");
INSERT INTO ses_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Nda nʼga day ni gandaa boro ga, ma laasaabu za Sawalyanoo jiiri koraa, a ma hegaa jiirey laasaabu ka neere ma ne. ");
INSERT INTO ses_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Nda jiirey boobo, hayoo ma tonton, nda jiirey kacca hayoo ma kacca, zama hegaa hinnaa nda a ga neere ma ne. ");
INSERT INTO ses_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","War affoo kul masi nga gandaa boro zanba, ma hunbur ni Koyoo, zama agay ti Abadantaa, war Koyoo.›» ");
INSERT INTO ses_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","«‹War mʼay hantumey ka goy, war mʼay hantumey kaŋ kayandi dii, war mʼi ka goy, woo ra war ga goro gandaa ra alaafiya ra. ");
INSERT INTO ses_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Gandaa ga war noo nga gomnoo, war ga ŋaa ka kungu, war ga goro a ra nda alaafiyaa. ");
INSERT INTO ses_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Nda war nee: “Macin no ir gʼa ŋaa jiiri iyyantoo, zama ir si saya, ir si ir faari-izey hegay?” ");
INSERT INTO ses_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","ay gʼay albarkaa zumandi war boŋ jiiri idduwantoo ra, a ga jiiri hinza faari-ize noo. ");
INSERT INTO ses_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Nda war saya jiiri yaahantoo ra, war ga faari-ize žeenaa ŋaa hala jiiri yaggantoo ga. Hala nga faari-ize taagaa ma tee, war ma ižeenaa ŋaa.›» ");
INSERT INTO ses_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","«‹Labu masi neerandi hala abada, zama agay wane nda gandaa, zama yawyaŋ ti war, boroyaŋ kaŋ kaa ka waati tee ay do. ");
INSERT INTO ses_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Gandaa kul kaŋ war gʼa mayray, war ma fondoyaŋ kayandi laboo yeetiyanoo se. ");
INSERT INTO ses_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Nda ni armaa tee talka, de a ga baa nga ma nga laboo jeroo neere, boraa kaŋ goo nda fondo a ma yeetandi a se ti nga boro maanaa, a ma kaa, nga armaa laboo ma yeetandi a se kaŋ a gʼa neere. ");
INSERT INTO ses_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Amma nda boraa sii nda boro kul kaŋ goo nda fondo kaŋ se a ga yeetandi, de nga hinoo ga too a ma yeetandi a se, ");
INSERT INTO ses_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","a ma kabu za jiiroo kaŋ a neerandi, a ma haya kaŋ tonton a ga yeeti boraa kaŋ se a nʼa neere, de a ga yee nga mayrawey ra. ");
INSERT INTO ses_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Nda nga hinoo si too a ma yeetandi a se, hayaa kaŋ a nʼa neere ma cindi boraa kaŋ nʼa day kaboo ra hala Sawalyanoo jiiroo ga. Sawalyanoo jiiroo ga, hayaa ma taŋandi, boraa kaŋ nʼa neere, a ma yee nga mayrawey ra. ");
INSERT INTO ses_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Nda boro na hugu neere koyra kaŋ cete gʼa kuubi ra, a ma duu fondo ka yeetandi a se neereroo ga ka koy jiiri foo. Jiiri foo no a mʼa tee kaŋ ra a goo nda fondo a ma yeetandi a se. ");
INSERT INTO ses_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Nda hugoo kaŋ goo koyraa ra kaŋ cete gʼa kuubi mana yeetandi hala jiiri faa timme, a ma cindi boraa kaŋ nʼa day nda nga hayroo se, a si taŋandi Sawalyanoo jiiroo ga. ");
INSERT INTO ses_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Amma koyra kanbey kaŋ mana kuubandi nda cete hugey nda gandaa saajey kul ti takaa foo. Fondo goo i se ka yeetandi, Sawalyanoo jiiroo ga, i ma taŋandi. ");
INSERT INTO ses_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Amma Lewi borey koyrawey nda hugey kaŋ ti ngi wane, Lewi borey goo nda fondo hala abada i ma yeetandi i se. ");
INSERT INTO ses_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Lewi borey ra, hugu ga hin ka yeetandi ngi affoo se. Hugu kaŋ neerandi koyra ra kaŋ a gʼa mayray, ma taŋandi Sawalyanoo jiiroo ga. Zama Lewi borey koyrawey hugey ga tee ngi mayraa Izirayel borey game. ");
INSERT INTO ses_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Faarey kaŋ ga Lewi borey koyrawey kuubi kʼi bere si neerandi, zama ngi mayraa no hala abada.›» ");
INSERT INTO ses_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","«‹Nda ni armaa tee talka, a tilasu ni jeroo ga, mʼa faaba, ba nda yaw wala boro kaŋ ga waati tee ni do no hala a ma duu ka huna ni jeroo ga. ");
INSERT INTO ses_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Masi albaha wiri a ga, masi tontoni wiri, ma hunbur ni Koyoo hala ni armaa ma duu ka huna ni jeroo ga. ");
INSERT INTO ses_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Masi ni nooroo garaw a se ka albaha ceeci, masʼa noo meehunay ka nee a mʼa bana nda tontoni. ");
INSERT INTO ses_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Agay ti Abadantaa, war Koyoo kaŋ na war fattandi Misira gandaa ra ka war noo Kanaŋ gandaa hala ya tee war se Irkoy.›» ");
INSERT INTO ses_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","«‹Nda ni armaa tee talka ni jeroo ga, de a na nga boŋ neere ma ne, masʼa daŋ baɲɲa goy ra. ");
INSERT INTO ses_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","A ma tee ma ne sanda goykaw, sanda boro kaŋ ga waati tee ni do. A ma goy ma ne hala Sawalyanoo jiiroo ga. ");
INSERT INTO ses_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Waatoo din a ma hun ni do, nga nda nga izey, a ma yee nga alaayan beeroo do, nga baabey mayrawey ra. ");
INSERT INTO ses_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Zama ay baɲɲey no kaŋ ay nʼi fattandi Misira gandaa ra, i si neerandi sanda takaa kaŋ nda boro ga baɲɲa neere. ");
INSERT INTO ses_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Masi hini šenda fur a ga, ma hunbur ni Koyoo. ");
INSERT INTO ses_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Amma baɲɲa nda koŋŋa kaŋ nʼga kaa ka duu a, gandawey kaŋ ga war kuubi ra, gandawey din ga war ma baɲɲayaŋ nda koŋŋayaŋ day. ");
INSERT INTO ses_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","War ga hin ka yaw kaŋ ga waati tee war do mo izey day, nda ngi alaayan beerey kaŋ goo war do, i hayandi war gandaa ra, i ma tee war mayraa. ");
INSERT INTO ses_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","War mʼi naŋ i ma tee tubuhaya war izey kaŋ ga kaa war dumawey ga se, i mʼi mayray. War ga hin kʼi dii sanda baɲɲa hala abada. Amma war armey, Izirayel borey, war affoo kul masi hini šenda fur nga armaa ga. ");
INSERT INTO ses_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Nda yaw wala boro kaŋ ga waati tee ni do tee almankoyni, de ni armaa tee talka jeroo ga, de a na nga boŋ neere yawoo se wala boraa kaŋ ga waati tee ni do se, wala yawoo alaayan beeri se, ");
INSERT INTO ses_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","kaŋ a na nga boŋ neere banda ga, a goo nda fondo i mʼa yeeti. Nga armey affoo ga hin ka nga hayoo bana. ");
INSERT INTO ses_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Nga baabaa armaa, wala nga baabaa armaa izoo, wala nga boro maana kaŋ nga alaayan beeroo ra ga hin ka nga hayoo bana, wala nda a duu hini, a ga hin ka nga boŋ hayoo bana. ");
INSERT INTO ses_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","A ma kabu boraa kaŋ nʼa day bande za jiiroo kaŋ a na nga boŋ neere hala Sawalyanoo jiiroo ga. Nooroo kaŋ a gʼa bana sii kala jiirey bande kaŋ a nʼa tee. Jiirey ma taabandi nda zaari foo goy hay. ");
INSERT INTO ses_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Nda jiiri boobo no ka cindi, a ma haya beeri yeeti hinna kaŋ nda a dayandi ra ka sawa nda jiirey. ");
INSERT INTO ses_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Nda jiiri boobo mana cindi Sawalyanoo jiiroo se, a ma kabu a bande ka hinna yeeti ka sawa nda jiirey. ");
INSERT INTO ses_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","A ma tee sanda goykaw kaŋ jiiri ka kaa jiiri a ga goy. Boraa kaŋ do a goo masi hini šenda fur a ga ni moɲey cire. ");
INSERT INTO ses_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Nda a manʼa yeetandi nda takawey wey affoo, a ma fatta Sawalyanoo jiiroo ga, nga nda nga izey. ");
INSERT INTO ses_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Zama agay se Izirayel borey ga tee baɲɲayaŋ. Ay baɲɲey no kaŋ ay nʼi fattandi Misira gandaa ra. Agay ti Abadantaa, war Koyoo.›» ");
INSERT INTO ses_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","«War masi tooruyaŋ tee, war masi assuura kaŋ ga hima nda haya wala tondi kayandi kʼa tee tooru, war masi tondi fasal kʼa daŋ war gandaa ra ka sujudu a se, zama agay ti Abadantaa, war Koyoo. ");
INSERT INTO ses_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","War mʼay hunanzamzaarey dii, war mʼay nongu henanantaa beerandi. Agay ti Abadantaa. ");
INSERT INTO ses_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Nda war ga dira ay hantumey bande, nda war gʼay yaamarey dii, war gʼi ka goy, ");
INSERT INTO ses_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ay ga ncirɲey sanba war se ngi waatoo ga, laboo ga nga duuraa noo, faarey tuurey ga ize tee. ");
INSERT INTO ses_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","War ga taasoo kar hala alaneboo hegaa ga, alaneboo hegaa ga koy hala sayyanoo ga, war ga war ŋaahayaa ŋaa hala war ma kungu, de war ga goro war gandaa ra nda alaafiya. ");
INSERT INTO ses_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Ay ga baani daŋ gandaa ra, war ga kani, boro kul si war dirgasandi. Ay ga hooga laaley derandi war gandaa ra. Takuba si too war gandaa do. ");
INSERT INTO ses_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","War ga war iberey gaaray, takuba gʼi kaŋandi war jine. ");
INSERT INTO ses_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Boro guu war ra ga zangu (100) gaaray i ra, zangu (100) war ra ga zenber woy (10.000) gaaray, takuba ga war iberey kaŋandi war jine. ");
INSERT INTO ses_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Ay ga bere war here, ay ga war noo hayyan ka war boobandi, ay ga gaabu agay amaanaa ga war se. ");
INSERT INTO ses_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","War ga hegay žeenaa ŋaa, war ga ižeenaa fattandi itaagaa se. ");
INSERT INTO ses_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ay gʼay gorodogoo daŋ war game, ay hundoo si konna war. ");
INSERT INTO ses_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Ay ga dira war game, ay ga tee war se Irkoy, war ga tee ay jamaa. ");
INSERT INTO ses_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Agay ti Abadantaa, war Koyoo kaŋ na war fattandi Misira gandaa ra hala war masi yee ka tee i se baɲɲa, ay na tiŋay-zaa-bundoo kayri hala war ma hin ka war boŋey jer ka dira. ");
INSERT INTO ses_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Amma nda war si haŋajer ya ne, nda war si yaamarey din kul ka goy, ");
INSERT INTO ses_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","de mo nda war wanji ay hantumey, nda war hundoo konna ay hantumey kaŋ kayandi hala nongu kaŋ ra war sʼay yaamarey kul ka goy ka agay amaanaa dunbu, ");
INSERT INTO ses_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","agay mo, hayaa ne kaŋ ay gʼa tee war se: ay ga hunburay, nda ɲomyan, nda gaaham konni kaŋ ga war moɲey ŋaa ka war hundey laazaaba sanba war ga, war ga war dumiyoo say, amma a ga tee yaada, zama war iberey no mʼi ŋaa. ");
INSERT INTO ses_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Ay gʼay ndumoo bere war se: war ga karandi war iberey jine, borey kaŋ ga konna war ga kaa ka žigi ka koy war ga. War ga zuru bila nda boro ma war gaaray. ");
INSERT INTO ses_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Nda wey kul tee war mana haŋajer ya ne, ay ga tonton ka war zukandi hala cee iyye war zunubey maaganda se. ");
INSERT INTO ses_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Ay ga war binebeeritaraa kaŋ ti war gaaboo kayri, ay ga war beenaa tee sanda guuru, war laboo ga tee sanda alhan. ");
INSERT INTO ses_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","War gaaboo ga ben yaada ra, war laboo si nga duuraa noo, gandaa tuurey si ize tee. ");
INSERT INTO ses_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Nda war si yadda ay ga, war si baa war ma haŋajer ya ne, ay ga war kar cee iyye ka tonton sanda woo kaŋ war zunubey ga hima nda a. ");
INSERT INTO ses_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Ay ga ganjihoogayaŋ sanba war ga, i ga war izey wii, i ga war almaney halaci, i ga war hinnaa kaccandi, war fondawey ga tee saaji. ");
INSERT INTO ses_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Nda hayey wey kul mana war daŋ fondaa ra, nda war si yadda ay ga, ");
INSERT INTO ses_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","agay mo si yadda war ga, ay ga war kar mo cee iyye war zunubey maaganda se. ");
INSERT INTO ses_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Ay ga kate war ga takubaa kaŋ ga faasa amaanaa se, waati kaŋ war koy lanba war koyrawey ra, ay ga sorfa sanba war game, war ga kaŋ war iberey kabey ra. ");
INSERT INTO ses_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Waati kaŋ ay na war jaŋandi ŋaayan, woy boro woy (10) ga war takulaa ton alforon folloku ra, i ga war boro foo kul noo nga bagaa takulaa. War ga ŋaa, amma war si kungu. ");
INSERT INTO ses_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Nda woo kul, war mana haŋajer ya ne, war si dira ay bande, ");
INSERT INTO ses_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ay si yadda war ga, ay ga futu, agay, ay ga war zukandi mo cee iyye war zunubey maaganda se. ");
INSERT INTO ses_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","War ga war izʼarey hamey ŋaa, war ga war ize woyey hamey ŋaa. ");
INSERT INTO ses_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Ay ga war tooru ganadogey halaci, ay ga war dugu dullandidogey kayri, ay ga war bukawey daŋ toorey kaŋ ti bukawyaŋ ga. Ay hundoo ga konna war. ");
INSERT INTO ses_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Ay ga war koyrawey tee saaji, ay ga war nongu henanantey tee saaji, ay si yee ka maa war dugu sunnaara kaaney. ");
INSERT INTO ses_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Agay, ay ga gandaa tee saaji hala nongu kaŋ ra war iberey kaŋ ga kaa ka goro a ra, ga alaabiina. ");
INSERT INTO ses_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","War, ay ga war say gandawey ra, ay ga takuba ka war gaaray. War gandaa ga halaci, war koyrawey ga tee saaji. ");
INSERT INTO ses_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Waatoo din, laboo naŋyanoo kul ra, a ga nga hunanzamzaarey tee, waatoo kaŋ war goo war iberey gandaa ra, waatoo din laboo ga hunanzam, a ga nga hunanzamzaarey bana. ");
INSERT INTO ses_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Zaarey kul kaŋ a naŋandi, a ga hunanzam, zama a mana hunanzam war hunanzamzaarey ra waatey kaŋ ra war ga goro no din. ");
INSERT INTO ses_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Borey kaŋ ga cindi war ra, ay ga alkubutaray daŋ biney ra nga iberey gandawey ra, tuuri fita kaŋ hewoo na zaa jindoo gʼi zurandi. I ga zuru sanda takaa kaŋ nda boro ga zuru takuba se. I ga kaŋ ka gar boro manʼi gaaray. ");
INSERT INTO ses_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","I ga kaŋ cere boŋ ma nee takuba kʼi gaaray, ka gar boro manʼi gaaray. War si hin ka kay war iberey jine, ");
INSERT INTO ses_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","war ga halaci gandawey ra, war iberey gandaa ga war gon. ");
INSERT INTO ses_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Borey kaŋ ga cindi war ra hamey ga ben ngi laybey maaganda se war iberey gandawey ra. Ngi baabey laybey mo se ngi hamey ga ben. ");
INSERT INTO ses_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Woo banda ga, i ga ngi zunubey nda ngi baabey zunubey har kaaray, tooɲerey kaŋ i nʼi tee ya ne, nda takaa kaŋ nda i mana yadda ay ga. ");
INSERT INTO ses_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Woo se agay mo si yadda ngi ga, ay nʼi ka koy ngi iberey gandaa ra. Nda i na ngi bine beerey yeeti ganda, nda i na ngi zunubey garaa bana, ");
INSERT INTO ses_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ay ga honga agay amaanaa kaŋ ay nʼa noo Yakuba se, nda agay amaanaa mo kaŋ ay na noo Isiyaka se. Ay ga honga agay amaanaa mo kaŋ ay nʼa noo Ibirahima se, ay ga honga laboo. ");
INSERT INTO ses_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","I ga hima ka gandaa naŋ hala gandaa ma nga hunanzamzaarey tee waatoo kaŋ ra a naŋandi dumawey ga. I ga ngi zunubey garaa bana, zama haya kaŋ se i wanji ay hantumey kaŋ kayandi, de ngi hundey konna ay hantumey. ");
INSERT INTO ses_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Amma ba waati kaŋ i goo ngi iberey gandaa ra, ay si wanji ey, ay si konna ey ka benandi nda ey ka agay amaanaa kaa ir game, zama agay ti Abadantaa, ngi Koyoo. ");
INSERT INTO ses_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Ngi se ay ga hongu amaanaa kaŋ ay nʼa tee ngi hayragey bande kaŋ ay nʼi fattandi Misira gandaa ra, gandawey borey moɲey cire ka tee ngi Koyoo. Agay ti Abadantaa.» ");
INSERT INTO ses_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Wey ti yaamarey, nda hantumey kaŋ kayandi, nda ašariyawey kaŋ Abadantaa nʼi daŋ nga nda Izirayel borey game Sinay tondi hondoo boŋ Musa bande. ");
INSERT INTO ses_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","«Šelaŋ Izirayel borey se, nee i se: ‹Nda boro na adamizeyaŋ meefur zaa Abadantaa maaɲoo ga, i ga tee Abadantaa wane nda alkadaroo kaŋ kayandi. ");
INSERT INTO ses_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Nda aru no kaŋ goo nda jiiri waranka (20) ka koy jiiri woydu (60), alkadaroo kaŋ kayandi ma tee nzorfu kaaray tamma boŋ woyguu (50), a ma sawa nda nongu henanantaa nzorfu tammaa. ");
INSERT INTO ses_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Nda woy no, alkadaroo ma tee nzorfu tamma waranza (30). ");
INSERT INTO ses_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Boro kaŋ goo nda jiiri guu ka koy waranka (20), nda aru no, alkadaroo ma tee nzorfu tamma boŋ waranka (20), nda woy no, a ma tee nzorfu tamma boŋ woy (10). ");
INSERT INTO ses_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Boro kaŋ goo nda handu foo ka koy jiiri guu, nda aru no, alkadaroo ma tee nzorfu tamma boŋ guu, nda woy no, alkadaroo ma tee nzorfu tamma hinza. ");
INSERT INTO ses_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Boro kaŋ goo nda jiiri woydu (60) ka koy, nda aru no, alkadaroo ma tee nzorfu tamma boŋ woy cindi guu (15), nda woy no, alkadaroo ma tee nzorfu tamma boŋ woy (10). ");
INSERT INTO ses_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Nda boraa kaŋ na meefuroo zaa ga hanse ka talka alkadaroo banayanoo se, i mʼa ka koy sargari juwalkaa do. Sargari juwalkaa ma alkadaroo kayandi a se. A ma alkadaroo kayandi meefur zaakaa se ka sawa nda haya kaŋ nga hinoo ga toorʼa. ");
INSERT INTO ses_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Nda adabbawey ra i na sargari kaa Abadantaa maaɲoo ga, haya kul kaŋ ga nondi i ra Abadantaa maaɲoo ga ma henan. ");
INSERT INTO ses_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","A masi barmayandi, affoo masi huru dogoo ra, ilaala masi huru ihenna doo ra, ihenna masi huru ilaala doo ra. Nda adabba foo barmayandi mo nda affoo, nga nda woo kaŋ huru dogoo ra ma yeetandi jere ga Abadantaa se. ");
INSERT INTO ses_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Nda adabba harramante kul kaŋ no kaŋ si hin ka hun sargari Abadantaa maaɲoo ga, i ma adabbaa ka koy sargari juwalkaa do. ");
INSERT INTO ses_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Sargari juwalkaa ma alkadaroo kayandi, nda ihenna no wala ilaala, alkadaroo kaŋ a nʼa daŋ no ma cindi. ");
INSERT INTO ses_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Nda koyoo ga hanse ka baa a ma yeetandi nga se, nga hayoo alkadaroo, igguu foo kul affoo ma tonton a ga. ");
INSERT INTO ses_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Nda boro na nga hugoo yeeti jere ga, a ma tee henanante Abadantaa se, sargari juwalkaa ma alkadaroo kayandi, nda ihenna no wala ilaala no. Alkadaroo kaŋ sargari juwalkaa nʼa daŋ no ma diyandi. ");
INSERT INTO ses_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Nda boraa kaŋ na hugoo yeeti jere ga Irkoy se, ga baa nga hugoo ma yeetandi nga se, nooroo alkadaroo, igguu foo kul a ma affoo tonton a ga, a ma tee nga mayraa. ");
INSERT INTO ses_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Nda boro na faari foo kaa nga almanoo ra kʼa yeeti jere ga Abadantaa se, nga alkadaroo si sawa nda kala hinnaa kaŋ ga hin ka saya a ra, kilo zangu hinza (300) cine orž kul ga sawa nda nzorfu kaaray tamma boŋ woyguu (50). ");
INSERT INTO ses_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Nda za Sawalyanoo jiiroo ra a na nga faaroo yeeti jere ga Abadantaa se, nga alkadaroo ma cindi nga takaa ga. ");
INSERT INTO ses_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Amma nda Sawalyanoo jiiroo banda ga, a na nga faaroo yeeti jere ga Abadantaa se, sargari juwalkaa ma faaroo hayoo kabu ka sawa nda jiirey hinnaa kaŋ cindi Sawalyanoo jiiroo se. A ma haya kaa alkadaroo ra. ");
INSERT INTO ses_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Nda boraa kaŋ na faaroo yeeti jere ga Abadantaa se, ga hanse ka baa a ma yeetandi nga se, nga hayoo igguu foo kul a ma affoo tonton a ga, a ma tee nga mayraa. ");
INSERT INTO ses_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Nda faaroo mana yeetandi boraa se, nda a neerandi boro tana se, a si hin ka yeetandi a se koyne. ");
INSERT INTO ses_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Nda faaroo taŋandi Sawalyanoo jiiroo ga, a ma yeetandi jere ga Abadantaa se sanda faari kaŋ kayandi Irkoy hinne se, a ma tee sargari juwalkey mayraa. ");
INSERT INTO ses_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Nda a na faari kaŋ a nʼa day, amma a manʼa tubu, yeeti jere ga Abadantaa se, ");
INSERT INTO ses_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","sargari juwalkaa ma alkadaroo hayoo kabu a se hala Sawalyanoo jiiroo ga. Hanoo din, aroo ma alkadaroo hayoo bana kaŋ kayandi, a ma tee haya kaŋ yeetandi jere ga Abadantaa se. ");
INSERT INTO ses_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Sawalyanoo jiiroo ga, faaroo ma yeetandi boraa se kaŋ ga a dayandi, boraa kaŋ bay kʼa mayray. ");
INSERT INTO ses_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Alkadar kul kaŋ nʼnʼa daŋ ma sawa nda nongu henanantaa nzorfu kaaray tammaa. Nzorfu kaaray tamma foo kul ti garam woy cindi hinka (12). ");
INSERT INTO ses_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Adabba gunde jinaa, boro kul si hima kʼa yeeti jere ga Abadantaa se, zama adabbaa gunde jinaa, Abadantaa wane nda a ka ben, a ma tee haw, wala feeji, wala hancin, Abadantaa wane. ");
INSERT INTO ses_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Nda adabba harramante no, a ga hin ka barmayandi, igguu foo kul affoo ma tonton alkadaroo ga. Nda a mana barmayandi, a ma neerandi nda nga alkadaroo. ");
INSERT INTO ses_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Haya kul kaŋ boro nʼa kayandi Abadantaa hinne se, nga mayrawey ra, a si hin ka neerandi, a si hin ka barmayandi, a ma tee boro, wala adabba, wala faari nga almanoo ra. Haya kul kaŋ kayandi Irkoy hinne se ga yeetandi jere ga Abadantaa maaɲoo ga, a ga hanse ka henan. ");
INSERT INTO ses_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Adamize kul kaŋ nondi hala abada Abadantaa se, si hin ka barmayandi, šikka sii a ga wiiyandi. ");
INSERT INTO ses_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Laboo azakkaa kul ti Abadantaa wane, a ma tee laboo dumiyoo, wala tuuri-ize, a ga yeetandi jere ga Abadantaa se. ");
INSERT INTO ses_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Nda boro ga hanse ka baa haya ma barmayandi nga se azakkaa ra, igguu foo kul a ma affoo tonton a ga. ");
INSERT INTO ses_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Alman beeri wala ibuuney azakkaa kaŋ kabandi, alman woy (10) kul affoo ma yeetandi jere ga Abadantaa se. ");
INSERT INTO ses_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","I masi guna ka dii wala almanoo ga boori wala a si boori, a masi barmayandi. Nda a barmayandi mo, nga nda woo kaŋ huru dogoo ra ma yeetandi jere ga Abadantaa se. I masi yeetandi boro se.›» ");
INSERT INTO ses_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Wey ti yaamarey kaŋ Abadantaa nʼi har Musa se Sinay tondi hondoo boŋ, a mʼi noo Izirayel borey se.");
INSERT INTO ses_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Abadantaa šelaŋ Musa se cere kubayyan hukkumoo ra Sinay saajoo ra, jiiri hinkantoo kaŋ ra Izirayel borey fatta Misira gandaa ra handu hinkantoo zaari jinaa. A nee: ");
INSERT INTO ses_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","«Ni nda Haruna ma Izirayel borey jamaa kul kabu alaayan beeri ka koy alaayan beeri, hugu ka koy hugu, ka arey kul maaɲey hantum affoo-foo. ");
INSERT INTO ses_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Arey kul kaŋ goo nda jiiri waranka (20) nda ka žigi, kaŋyaŋ ga hin ka koy wongu Izirayel se, ni nda Haruna mʼi kabu, wongu-ize ka koy wongu-ize. ");
INSERT INTO ses_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Alkabiila foo kul aru foo kaŋ ti hugu boŋ ma hanga war. ");
INSERT INTO ses_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Arey kaŋ ga hanga war maaɲey ne: Rubeŋ alkabiilaa ra, Elisur kaŋ ti Šedewur izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Simewoŋ alkabiilaa ra, Šelumiyel kaŋ ti Surišaday izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Žuda alkabiilaa ra, Nahišoŋ kaŋ ti Aminadab izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Isakar alkabiilaa ra, Netaniyel kaŋ ti Suwar izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Zabuloŋ alkabiilaa ra, Eliyab kaŋ ti Heloŋ izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Isufi izʼarey: Efrayim alkabiilaa ra, Elišama kaŋ ti Amihud izʼaroo. Manase alkabiilaa ra, Gamliyel kaŋ ti Pedasur izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Benžameŋ alkabiilaa ra, Abidaŋ kaŋ ti Žedewoni izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Dan alkabiilaa ra, Ahiyezer kaŋ ti Amišaday izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Ašer alkabiilaa ra, Pagiyel kaŋ ti Okraŋ izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Gad alkabiilaa ra, Elyasaf kaŋ ti Dehuwel izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Neftali alkabiilaa ra, Ahira kaŋ ti Enaŋ izʼaroo.» ");
INSERT INTO ses_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Wey ti borey kaŋ ciyandi jamaa ra. I manʼti kala ngi baabey alkabiilawey boŋkoyney. Izirayel wongu-ize jamawey jineborey no. ");
INSERT INTO ses_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Musa nda Haruna na arey wey kaŋ suubandi nda ngi maaɲey tonton ngi ga. ");
INSERT INTO ses_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Handu hinkantoo zaari jinaa i na jamaa kul marga. I na borey kabu alaayan beeri ka koy alaayan beeri, hugu ka koy hugu. Arey kaŋ goo nda jiiri waranka (20) nda ka žigi, i na maaɲey hantum affoo-foo. ");
INSERT INTO ses_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Sanda takaa kaŋ nda Abadantaa na Musa yaamar, Musa na kabuyanoo tee Sinay saajoo ra. ");
INSERT INTO ses_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Izirayel izʼaru jinaa kaŋ ti Rubeŋ hayroo kabandi boro foo kul nda nga alaayan beeroo, boro foo kul nda nga hugoo borey maaɲey. Arey kul kaŋ goo nda jiiri waranka (20) nda ka žigi kabandi affoo-foo, wey kul kaŋ ga hin ka koy wongu. ");
INSERT INTO ses_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Arey kaŋ kabandi Rubeŋ alkabiilaa ra manʼti kala zenber woytaaci cindi iddu nda zangu guu (46.500). ");
INSERT INTO ses_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Simewoŋ hayroo kabandi boro foo kul nda nga alaayan beeroo, boro foo kul nda nga hugoo borey maaɲey. Arey kul kaŋ goo nda jiiri waranka (20) nda ka žigi kabandi affoo-foo, wey kul kaŋ ga hin ka koy wongu. ");
INSERT INTO ses_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Arey kaŋ kabandi Simewoŋ alkabiilaa ra manʼti kala zenber woyguu cindi yagga nda zangu hinza (59.300). ");
INSERT INTO ses_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Gad hayroo kabandi boro foo kul nda nga alaayan beeroo, boro foo kul nda nga hugoo borey maaɲey. Borey kaŋ goo nda jiiri waranka (20) nda ka žigi kabandi affoo-foo, wey kul kaŋ ga hin ka koy wongu. ");
INSERT INTO ses_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Arey kaŋ kabandi Gad alkabiilaa ra manʼti kala zenber woytaaci cindi guu nda zangu iddu nda woyguu (45.650). ");
INSERT INTO ses_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Žuda hayroo kabandi boro foo kul nda nga alaayan beeroo, boro foo kul nda nga hugoo borey maaɲey. Borey kul kaŋ goo nda jiiri waranka (20) nda ka žigi kabandi affoo-foo, wey kul kaŋ ga hin ka koy wongu. ");
INSERT INTO ses_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Arey kaŋ kabandi Žuda alkabiilaa ra manʼti kala zenber woyye cindi taaci nda zangu iddu (74.600). ");
INSERT INTO ses_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Isakar hayroo kabandi boro foo kul nda nga alaayan beeroo, boro foo kul nda nga hugoo borey maaɲey. Borey kul kaŋ goo nda jiiri waranka (20) nda ka žigi kabandi affoo-foo, wey kul kaŋ ga hin ka koy wongu. ");
INSERT INTO ses_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Arey kaŋ kabandi Isakar alkabiilaa ra manʼti kala zenber woyguu cindi taaci nda zangu taaci (54.400). ");
INSERT INTO ses_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Zabuloŋ hayroo kabandi boro foo kul nda nga alaayan beeroo, boro foo kul nda nga hugoo borey maaɲey. Borey kul kaŋ goo nda jiiri waranka (20) nda ka žigi kabandi affoo-foo, wey kul kaŋ ga hin ka koy wongu. ");
INSERT INTO ses_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Arey kaŋ kabandi Zabuloŋ alkabiilaa ra manʼti kala zenber woyguu cindi iyye nda zangu taaci (57.400). ");
INSERT INTO ses_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Isufi hayroo here, Efrayim hayroo kabandi boro foo kul nda nga alaayan beeroo, boro foo kul nda nga hugoo borey maaɲey. Borey kul kaŋ goo nda jiiri waranka (20) nda ka žigi kabandi affoo-foo, wey kul kaŋ ga hin ka koy wongu. ");
INSERT INTO ses_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Arey kaŋ kabandi Efrayim alkabiilaa ra manʼti kala zenber woytaaci nda zangu guu (40.500). ");
INSERT INTO ses_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Manase hayroo kabandi boro foo kul nda nga alaayan beeroo, boro foo kul nda nga hugoo borey maaɲey. Borey kul kaŋ goo nda jiiri waranka (20) nda ka žigi kabandi affoo-foo, wey kul kaŋ ga hin ka koy wongu. ");
INSERT INTO ses_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Arey kaŋ kabandi Manase alkabiilaa ra manʼti kala zenber waranza cindi hinka nda zangu hinka (32.200). ");
INSERT INTO ses_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Benžameŋ hayroo kabandi boro foo kul nda nga alaayan beeroo, boro foo kul nda nga hugoo borey maaɲey. Borey kul kaŋ goo nda jiiri waranka (20) nda ka žigi kabandi affoo-foo, wey kul kaŋ ga hin ka koy wongu. ");
INSERT INTO ses_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Arey kaŋ kabandi Benžameŋ alkabiilaa ra manʼti kala zenber waranza cindi guu nda zangu taaci (35.400). ");
INSERT INTO ses_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Dan hayroo kabandi boro foo kul nda nga alaayan beeroo, boro foo kul nda nga hugoo borey maaɲey. Borey kul kaŋ goo nda jiiri waranka (20) nda ka žigi kabandi affoo-foo, wey kul kaŋ ga hin ka koy wongu. ");
INSERT INTO ses_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Arey kaŋ kabandi Dan alkabiilaa ra manʼti kala zenber woydu cindi hinka nda zangu iyye (62.700). ");
INSERT INTO ses_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Ašer hayroo kabandi boro foo kul nda nga alaayan beeroo, boro foo kul nda nga hugoo borey maaɲey. Borey kul kaŋ goo nda jiiri waranka (20) nda ka žigi kabandi affoo-foo, wey kul kaŋ ga hin ka koy wongu. ");
INSERT INTO ses_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Arey kaŋ kabandi Ašer alkabiilaa ra manʼti kala zenber woytaaci cindi foo nda zangu guu (41.500). ");
INSERT INTO ses_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Neftali hayroo kabandi boro foo kul nda nga alaayan beeroo, boro foo kul nda nga hugoo borey maaɲey. Borey kul kaŋ goo nda jiiri waranka (20) nda ka žigi kabandi affoo-foo, wey kul kaŋ ga hin ka koy wongu. ");
INSERT INTO ses_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Arey kaŋ kabandi Neftali alkabiilaa ra manʼti kala zenber woyguu cindi hinza nda zangu taaci (53.400). ");
INSERT INTO ses_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Wey ti borey kaŋ Musa, nda Haruna, nda Izirayel borey boŋkoyni woy cindi hinkaa (12) nʼi kabu, aru foo kul hun hugu foo ra. ");
INSERT INTO ses_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Izirayel borey kul kaŋ kabandi, boro foo kul nda nga hugoo, borey kul kaŋ goo nda jiiri waranka (20) nda ka žigi, wey kul kaŋ ga hin ka koy wongu Izirayel se, ");
INSERT INTO ses_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","ngi kul ti zenber zangu iddu nda zenber hinza nda zangu guu nda woyguu (603.550). ");
INSERT INTO ses_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Lewi alkabiilaa borey mana laasaabandi ngi kabuyanoo ra. ");
INSERT INTO ses_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Abadantaa nka šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«Lewi alkabiilaa hinne no masʼa kabu Izirayel borey bande. ");
INSERT INTO ses_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Ma seedetaraa gorodogoo nda hayey kaŋ goo a ra nda nga jinawey kul talfi Lewi borey ga. Ngi, i ma seedetaraa gorodogoo nda nga jinawey zaa ka huga nda ey ka goro kʼa kuubi kʼa bere. ");
INSERT INTO ses_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Nda Irkoy gorodogoo ga gana, ngi no mʼa feeri, nda nga gorodogoo kay ngi no mʼa cin. Boro tana kaŋ man Irkoy gorodogoo šikka sii ga wiiyandi. ");
INSERT INTO ses_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Izirayel borey affoo kul ma zunbu nga kaloo ra, affoo kul nga liiliwaloo cire, wongu-ize ka koy wongu-ize. ");
INSERT INTO ses_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Lewi borey ga goro ka seedetaraa gorodogoo kuubi kʼa bere hala futayyanoo masi kaŋ Izirayel borey jamaa ga. Lewi borey no ma huga nda seedetaraa gorodogoo goyoo.» ");
INSERT INTO ses_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Izirayel borey na hayey tee nda takaa kaŋ nda Abadantaa na Musa yaamar, i nʼi tee nda takaa din da. ");
INSERT INTO ses_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Abadantaa šelaŋ Musa nda Haruna se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","«Izirayel borey affoo kul ma goro nga liiliwaloo cire, nga hugoo borey tammaasaa jere. I ma goro ka cere kubayyan hukkumoo kuubi kʼa bere kʼa tenje. ");
INSERT INTO ses_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Wey kaŋ ga goro dandi here, waynahunay kaboo ga, ga goro wongu-ize ka koy wongu-ize Žuda kaloo liiliwaloo cire, Žuda borey boŋkoynoo ti Nahišoŋ, Aminadab izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Nga wongu-izey hinnaa ti aru zenber woyye cindi taaci nda zangu iddu (74.600). ");
INSERT INTO ses_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Nga jeroo ga Isakar alkabiilaa ga goro, Isakar borey boŋkoynoo ti Netaniyel, Suwar izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Nga wongu-izey hinnaa ti aru zenber woyguu cindi taaci nda zangu taaci (54.400). ");
INSERT INTO ses_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Woo banda ga, Zabuloŋ alkabiilaa, Zabuloŋ borey boŋkoynoo ti Eliyab, Heloŋ izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Nga wongu-izey hinnaa ti aru zenber woyguu cindi iyye nda zangu taaci (57.400). ");
INSERT INTO ses_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Žuda kaloo borey hinnaa ti aru zenber zangu nda zenber woyyaaha cindi iddu nda zangu taaci (186.400), wongu-ize ka koy wongu-ize. Ngi ti boro jina-jinawey kaŋ ga tun ka koy. ");
INSERT INTO ses_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Gurma here, Rubeŋ kaloo wongu-izey ga goro ngi liiliwaloo cire, wongu-ize ka koy wongu-ize. Rubeŋ borey boŋkoynoo ti Elisur, Šedewur izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Nga wongu-izey hinnaa ti aru zenber woytaaci cindi iddu nda zangu guu (46.500). ");
INSERT INTO ses_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Nga jeroo ga Simewoŋ alkabiilaa ga goro. Simewoŋ borey boŋkoynoo ti Šelumiyel, Surišaday izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Nga wongu-izey hinnaa ti aru zenber woyguu cindi yagga nda zangu hinza (59.300). ");
INSERT INTO ses_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Ngi banda ga, Gad alkabiilaa goo. Gad borey boŋkoynoo ti Elyasaf, Rehuwel izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Nga wongu-izey hinnaa ti aru zenber woytaaci cindi guu nda zangu iddu nda woyguu (45.650). ");
INSERT INTO ses_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Rubeŋ alkabiilaa kaloo borey hinnaa ti aru zenber zangu nda zenber woyguu cindi foo nda zangu taaci nda woyguu (151.450), wongu-ize ka koy wongu-ize. Ngi ti boro hinkantey kaŋ ga tun ka koy. ");
INSERT INTO ses_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Woo banda ga, cere kubayyan hukkumoo ga koy, Lewi borey kaloo goo kaley jerey game. I si koy nda kala kali ka koy kali, affoo kul ga koy nda nga dogoo nda ngi liiliwaloo. ");
INSERT INTO ses_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Dangay here, Efrayim kaloo wongu-izey ga goro ngi liiliwaloo cire, wongu-ize ka koy wongu-ize. Efrayim borey boŋkoynoo ti Eliša, Amihud izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Nga wongu-izey hinnaa ti aru zenber woytaaci nda zangu guu (40.500). ");
INSERT INTO ses_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Nga jeroo ga Manase alkabiilaa goo, Manase borey boŋkoynoo ti Gamliyel, Pedasur izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Nga wongu-izey hinnaa ti aru zenber waranza cindi hinka nda zangu hinka (32.200). ");
INSERT INTO ses_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Ngi banda ga, Benžameŋ alkabiilaa goo. Benžameŋ borey boŋkoynoo ti Abidaŋ, Žedewoni izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Nga wongu-izey hinnaa ti aru zenber waranza cindi guu nda zangu taaci (35.400). ");
INSERT INTO ses_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Borey kaŋ goo Efrayim kaloo ra hinnaa ti zenber zangu nda zenber yaaha nda zangu (108.100), wongu-ize ka koy wongu-ize. Ngi ti boro hinzantey kaŋ ga tun ka koy. ");
INSERT INTO ses_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Hawsa here, Dan kaloo wongu-izey ga goro ngi liiliwaloo cire, wongu-ize ka koy wongu-ize. Dan borey boŋkoynoo ti Ahiyezer, Amišaday izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Nga wongu-izey hinnaa ti aru zenber woydu cindi hinka nda zangu iyye (62.700). ");
INSERT INTO ses_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Nga jeroo ga Ašer alkabiilaa ga goro, Ašer borey boŋkoynoo ti Pagiyel, Okraŋ izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Nga wongu-izey hinnaa ti aru zenber woytaaci cindi foo nda zangu guu (41.500). ");
INSERT INTO ses_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Ngi banda ga, Neftali alkabiilaa goo. Neftali borey boŋkoynoo ti Ahira, Enaŋ izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Nga wongu-izey hinnaa ti aru zenber woyguu cindi hinza nda zangu taaci (53.400). ");
INSERT INTO ses_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Dan kaloo borey kul hinnaa ti zenber zangu nda zenber woyguu cindi iyye nda zangu iddu (157.600). Ngi ti boro kokorantey kaŋ ga tun ka koy, liiliwal ka koy liiliwal.» ");
INSERT INTO ses_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Izirayel borey kaŋ kabandi kaley ra hugu ka koy hugu nda wongu-ize ka koy wongu-ize hinnaa kul cere ra ti zenber zangu iddu nda zenber hinza nda zangu guu nda woyguu (603.550). ");
INSERT INTO ses_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Lewi borey mana laasaabandi Izirayel borey kabuyanoo ra, sanda takaa kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Izirayel borey na hayey tee nda takaa kaŋ nda Abadantaa na Musa yaamar. Taka follokaa nda i ga ngi kaley tee ngi liiliwaley cire. Taka follokaa nda i ga tun ka koy, alaayan beeri ka koy alaayan beeri, hugu ka koy hugu. ");
INSERT INTO ses_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Haruna nda Musa hayrey ne waatoo kaŋ Abadantaa ga šelaŋ Musa se Sinay tondi hondoo ga. ");
INSERT INTO ses_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Haruna izʼarey maaɲey ne: Nadab ti izʼaru jinaa, nga banda ga, Abihu, nda Eleyazar, nda Itamar. ");
INSERT INTO ses_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Wey ti Haruna izʼarey maaɲey, sargari juwalkawyaŋ no kaŋ yonandi ka yeetandi jere ga sargari juwalyan se. ");
INSERT INTO ses_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nadab nda Abihu buu Abadantaa jine waatoo kaŋ i na nuune kaŋ si bisa daŋ Abadantaa jine Sinay saajoo ra. I sii nda ize. Eleyazar nda Itamar na sargari juwalyan goyoo tee ngi baabaa Haruna hinoo cire. ");
INSERT INTO ses_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","«Lewi alkabiilaa manandi kʼi kayandi sargari juwalkaa Haruna jere, i mʼa gaa goyoo ra. ");
INSERT INTO ses_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","I ma goyey tee Haruna nda jamaa kul se cere kubayyan hukkumoo jine, i ma goyey tee kaŋ goo Irkoy gorodogoo ra. ");
INSERT INTO ses_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","I ga hawgay nda cere kubayyan hukkumoo jinawey kul, goyey kaŋ i gʼi tee Irkoy gorodogoo ra, i sʼi tee kala Izirayel borey maaɲey ga. ");
INSERT INTO ses_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Ma Lewi borey noo Haruna nda nga izʼarey se Izirayel borey maaɲey ga. ");
INSERT INTO ses_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Ma Haruna nda nga izʼarey daŋ i ma sargari juwalyan goyoo tee. Boro tana kaŋ man šikka sii ga wiiyandi.» ");
INSERT INTO ses_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Abadantaa yee ka šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","«Nga ne, agay, ay na Lewi borey zaa Izirayel borey gunde jinawey kul dogey ra. Lewi borey manʼti kala agay wane. ");
INSERT INTO ses_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Zama gunde jinaa kul manʼti kala agay wane, hanoo kaŋ ay na Misira borey gunde jinawey kar kʼi wii, ay na Izirayel borey gunde jinawey yeeti ay boŋ se jere ga, a ma tee adamizey wala adabbawey. Agay wane nda ey, agay ti Abadantaa.» ");
INSERT INTO ses_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Abadantaa šelaŋ Musa se Sinay saajoo ra ka nee: ");
INSERT INTO ses_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","«Lewi izʼarey kabu hugu ka koy hugu, alaayan beeri ka koy alaayan beeri, ma arey kul kabu kaŋ goo nda handu foo nda ka žigi.» ");
INSERT INTO ses_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Musa na kabuyanoo tee ka sawa nda Abadantaa yaamaroo, a nʼa tee nda takaa kaŋ nda a hantumandi. ");
INSERT INTO ses_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Lewi izʼarey maaɲey ne: Geršoŋ, nda Kehat, nda Merari. ");
INSERT INTO ses_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Geršoŋ izʼarey maaɲey ne, alaayan beeri ka koy alaayan beeri: Libni nda Šimeyi. ");
INSERT INTO ses_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Kehat izʼarey ne, alaayan beeri ka koy alaayan beeri: Amram, nda Yisehar, nda Hebroŋ, nda Uziyel. ");
INSERT INTO ses_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Merari izʼarey ne, alaayan beeri ka koy alaayan beeri: Mahili nda Muši. Wey ti Lewi alaayan beerey kaŋ kabandi hugu nda hugu. ");
INSERT INTO ses_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Geršoŋ hayroo manʼti kala Libni alaayan beeroo nda Šimeyi alaayan beeroo. Wey ti Geršoŋ alaayan beerey. ");
INSERT INTO ses_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Borey kaŋ kabandi i ra kʼa dii arey kaŋ goo nda handu foo nda ka žigi hinnaa ti zenber iyye nda zangu guu (7.500). ");
INSERT INTO ses_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Geršoŋ borey alaayan beerey si goro kala Irkoy gorodogoo dumaa ga, waynakaŋay here. ");
INSERT INTO ses_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Geršoŋ borey hugoo boŋkoynoo manʼti kala Elyasaf, Layel izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Cere kubayyan hukkumoo goyoo kaŋ talfandi Geršoŋ hayroo ga ti: Irkoy gorodogoo, nda hukkumoo nda nga daabandoo, nda ridowoo kaŋ goo cere kubayyan hukkumoo miɲoo ga, ");
INSERT INTO ses_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","nda batumaa kuntawey, nda batumaa miɲoo ridowoo kaŋ ga Irkoy gorodogoo kuubi kʼa bere nda sargari tonadogoo, nda karfey kaŋ goo no goyoo kul se. ");
INSERT INTO ses_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Kehat hayroo ti: Amram borey alaayan beeroo, nda Yisehar borey alaayan beeroo, nda Hebroŋ borey alaayan beeroo, nda Uziyel borey alaayan beeroo. Wey ti Kehat borey alaayan beerey. ");
INSERT INTO ses_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Nda nʼna arey kul kabu kaŋ goo i ra kaŋ goo nda handu foo nda ka žigi, ngi hinnaa manʼti kala zenber yaaha nda zangu iddu (8.600), maanaa wey kaŋ ga goy nongu henanantaa ra. ");
INSERT INTO ses_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Kehat izʼarey alaayan beerey si goro Irkoy gorodogoo se kala gurma here caraa ga. ");
INSERT INTO ses_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Kehat borey alaayan beerey hugoo boŋkoynoo ti Elisafaŋ kaŋ ti Uziyel izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Goyoo kaŋ talfandi i ga manʼti kala: sundukoo, nda taabaloo, nda fitilla gorodogoo, nda sargari tonadogey, nda jinawey kaŋ ga goyey tee nongu henanantaa ra, nda ridowoo, nda goyey kul kaŋ jinawey wey gʼi tee. ");
INSERT INTO ses_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Lewi borey boŋkoyni beeroo ti Eleyazar kaŋ ti sargari juwalkaa Haruna izʼaroo. Nga bara borey jine kaŋ ga goy nongu henanantaa ra. ");
INSERT INTO ses_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Merari hayroo ti: Mahili borey alkabiilaa nda Muši borey alaayan beeroo. Wey ti Merari alaayan beerey. ");
INSERT INTO ses_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Nda nʼna arey kul kabu kaŋ goo i ra kaŋ goo nda handu foo nda ka žigi, ngi hinnaa manʼti kala zenber iddu nda zangu hinka (6.200). ");
INSERT INTO ses_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Merari borey alaayan beerey hugoo boŋkoynoo ti Suriyel kaŋ ti Abihel izʼaroo. I si goro Irkoy gorodogoo se kala hawsa here caraa ga. ");
INSERT INTO ses_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Hayey kaŋ talfandi Merari izʼarey ga ti Irkoy gorodogoo bundu tefawey, nda nga gaaru-gaarey, nda nga ganjey, nda nga ferawey, nda nga jinawey kul, nda goyoo kul kaŋ goo a ra, ");
INSERT INTO ses_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","nda batumaa ganjey kaŋ gʼa kuubi kʼa bere, nda ngi ferawey, nda sukahayey, nda ngi karfey. ");
INSERT INTO ses_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Musa, nda Haruna, nda Haruna izʼarey no ma goro Irkoy gorodogoo jine dandi here, i ga goro cere kubayyan hukkumoo jine waynahunay here. Ngi no ma goy nongu henanantaa ra Izirayel borey maaɲey ga. Boro tana kaŋ man šikka sii ga wiiyandi. ");
INSERT INTO ses_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Lewi borey kul kaŋ Musa nda Haruna nʼi kabu alaayan beeri nda alaayan beeri ka sawa nda Abadantaa yaamaroo kʼa dii arey kul kaŋ goo nda handu foo nda ka žigi, ngi hinnaa manʼti kala zenber waranka cindi hinka (22.000). ");
INSERT INTO ses_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Abadantaa nee Musa se: «Izirayel borey izʼaru gunde jinawey kul kabu, kʼa dii wey kaŋ goo nda handu foo nda ka žigi, mʼi kabu ka maaɲey hantum. ");
INSERT INTO ses_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Agay ti Abadantaa, ma Lewi borey daŋ ya ne jere ga Izirayel borey gunde jinawey dogey ra, ma Lewi borey adabbawey daŋ ya ne jere ga Izirayel borey adabba gunde jinawey dogey ra.» ");
INSERT INTO ses_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Musa na izʼaru gunde jinawey kul kabu Izirayel borey ra, sanda takaa kaŋ nda Abadantaa nʼa yaamar. ");
INSERT INTO ses_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Izʼaru gunde jinawey kaŋ goo nda handu foo nda ka žigi kaŋ kabandi i ra hinnaa ti zenber waranka cindi hinka nda zangu hinka nda woyye cindi hinza (22.273). ");
INSERT INTO ses_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","«Lewi borey daŋ Izirayel borey gunde jinawey dogey ra, Lewi borey adabbawey daŋ Izirayel borey waney dogey ra. Lewi borey manʼti kala agay wane, agay ti Abadantaa. ");
INSERT INTO ses_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Izirayel borey gunde jinawey tonton nda boro zangu hinka nda woyye cindi hinza (273) ka bisa Lewi borey. Takaa ne kaŋ nda ngi yeetiyanoo ga teendi: ");
INSERT INTO ses_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","ma nzorfu kaaray tamma boŋ guu dii ngi boro foo kul ga, ka sawa nda nongu henanantaa nzorfu kaaray tammaa kaŋ ti garam woy cindi hinka (12). ");
INSERT INTO ses_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Ma nooroo noo Haruna nda nga izʼarey se a ma tee izʼaru gunde jinaa boobey yeetiyanoo hayoo.» ");
INSERT INTO ses_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Musa duu ngi hayoo izʼaru jina boobey kaŋ Lewi borey nʼi day ga. ");
INSERT INTO ses_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Nooroo kaŋ a nʼa dii Izirayel borey gunde jinawey ga ti nzorfu kaaray tamma boŋ zenber foo nda zangu hinza nda woydu cindi guu (1.365) ka sawa nda nongu henanantaa nzorfu kaaray tammaa. ");
INSERT INTO ses_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Woo banda ga, Musa na yeetiyanoo nooroo noo Haruna nda nga izʼarey se, ka sawa nda Abadantaa yaamaroo, sanda takaa kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Abadantaa šelaŋ Musa nda Haruna se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","«Lewi izʼarey ra, wa Kehat izʼarey kabu alaayan beeri ka koy alaayan beeri, hugu ka koy hugu, ");
INSERT INTO ses_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","kʼa dii wey kaŋ goo nda jiiri waranza (30) nda ka žigi ka koy jiiri woyguu (50), wey kul kaŋ ga hin ka goy cere kubayyan hukkumoo ra. ");
INSERT INTO ses_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Goyoo ne kaŋ Kehat izʼarey gʼa tee cere kubayyan hukkumoo ra: I ga huga nda hayey kaŋ ga hanse ka henan. ");
INSERT INTO ses_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Nda jamaa kaloo ga gana, Haruna nda nga izʼarey ga zaaraa kaŋ ti rido kaa ka seedetaraa sundukoo gum nda a. ");
INSERT INTO ses_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","I ga ayu kuuru kunta daŋ a ga, i ga zaara kaŋ kul ti ibula daaru a ga, woo banda ga, i ga nga gobey daŋ a ga. ");
INSERT INTO ses_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","I ga zaara bula daaru takulawey kaŋ jisandi Irkoy jine taabaloo ga, i ga taasawey, nda potey, nda sargari-kaa-potey, nda sargari hari-harey gullawey daŋ a ga. Takulawey kaŋ ga sargandi waati kul ma bara a boŋ. ");
INSERT INTO ses_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","I ga zaara ciray zaram gum hayey wey kul ga, i gʼi gum nda ayu kuuru kunta, i ma nga gobey daŋ a ga. ");
INSERT INTO ses_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Woo banda ga, i ga zaara bula zaa ka gaayoo fitilla gorodogoo, nda nga fitillawey, nda kanbey kaŋ ga ngi zaarawey boosey dunbu, nda nga dugu canbey, nda jinawey kul gum kaŋ ra jii ga huru kaŋ goo no fitillawey goyoo se. ");
INSERT INTO ses_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","I ma nga nda nga jinawey kul daŋ ayu kuuru kunta ra jina i mʼa daŋ jeejehayaa ga kaŋ gʼa zaa. ");
INSERT INTO ses_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","I ma zaara bula daaru wura sargari tonadogoo ga, i mʼa gum nda ayu kuuru kunta, woo banda ga, i ma nga gobey daŋ a ga. ");
INSERT INTO ses_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","I ma jinawey kul zaa kaŋ nda borey ga goy nongu henanantaa ra, i mʼi daŋ zaara bula ra, woo banda ga, i mʼi daŋ ayu kuuru kunta ra jina i mʼi daŋ jeejehayaa ga kaŋ gʼi zaa. ");
INSERT INTO ses_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","I ga sargari tonadogoo boosey kaa, i ma zaara ciray, ciray henna daaru sargari tonadogoo ga. ");
INSERT INTO ses_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","I ma jinawey kul kaŋ nda i ga goyey tee fur a boŋ, dugu canbey, nda furšeti beerey, nda pelley, nda kusey, maanaa sargari tonadogoo jinawey kul. Woo banda ga, i ma ayu kuuru kunta gum i boŋ, i ga nga gobey daŋ a ga. ");
INSERT INTO ses_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Waati kaŋ jamaa kaloo ga gana, waati kaŋ Haruna nda nga izʼarey na nongu henanantaa nda nga jinawey kul gum ka ben, Kehat izʼarey ga kaa kʼa zaa. Amma i si too haya henanantaa do, nda manʼti woo, i ga buu. Woo ti hayaa kaŋ Kehat izʼarey gʼa zaa cere kubayyan hukkumoo ra ka koy. ");
INSERT INTO ses_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Eleyazar, sargari juwalkaa Haruna izʼaroo, ga huga nda fitillaa jiyoo, nda dugu hew kaanaa, nda taasu sargaroo kaŋ ga hun zaari kul, nda yonyan jiyoo. Nga no ma huga nda Irkoy gorodogoo kul nda hayey kul kaŋ goo a ra, nongu henanantaa nda nga jinawey.» ");
INSERT INTO ses_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Abadantaa šelaŋ Musa nda Haruna se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","«War masi yadda Kehat borey alaayan beerey ma fay ka hun Lewi borey ra. ");
INSERT INTO ses_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Hayaa kaŋ war gʼa tee i se hala i ma cindi hunayan ra i masi koy buu waati kaŋ i too nongu henanantey ihenanantaa do ti Haruna nda nga izʼarey ma affoo kul daŋ nga goyoo ra nda jeejaa kaŋ affoo kul gʼa zaa. ");
INSERT INTO ses_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","I masi huru ba waati kayna ka dii haya henanantey, nda i nʼa tee i ga buu.» ");
INSERT INTO ses_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","«Geršoŋ izʼarey mo kabu hugu ka koy hugu, alaayan beeri ka koy alaayan beeri, ");
INSERT INTO ses_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","kʼa dii wey kaŋ goo nda jiiri waranza (30) nda ka žigi ka koy jiiri woyguu (50), wey kul kaŋ ga hin ka goy cere kubayyan hukkumoo ra. ");
INSERT INTO ses_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Goyoo kaŋ nda Geršoŋ borey alaayan beerey ga huga nda ngi jeejaa ne: ");
INSERT INTO ses_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","I ma Irkoy gorodogoo kaymi taafe zuwey nda cere kubayyan hukkumoo zaa, nda nga daabandoo nda ayu kuuroo kuntaa kaŋ goo a ga, nda ridowoo kaŋ goo cere kubayyan hukkumoo miɲoo ga, ");
INSERT INTO ses_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","nda batumaa kuntawey, nda batumaa miɲoo ridowoo kaŋ ga Irkoy gorodogoo nda sargari tonadogoo kuubi kʼa bere, nda ngi karfey nda jinawey kul kaŋ goo a ga. Goyey wey ka talfandi i ga. ");
INSERT INTO ses_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Geršoŋ borey ga ngi goyey kul tee ka sawa nda Haruna nda nga izʼarey yaamaroo, a ma tee ngi jeejaa wala ngi goyey. War ma ngi jeejewey kul laasaabu kʼi har i se. ");
INSERT INTO ses_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Woo ti goyoo kaŋ talfandi Geršoŋ borey izʼarey alaayan beerey ga cere kubayyan hukkumoo ra. I ma ngi goyey tee Itamar, sargari juwalkaa Haruna izʼaroo hinoo cire.» ");
INSERT INTO ses_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","«Ma Merari izʼarey kabu, alaayan beeri ka koy alaayan beeri, hugu ka koy hugu, ");
INSERT INTO ses_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","kʼa dii wey kaŋ goo nda jiiri waranza (30) nda ka žigi ka koy jiiri woyguu (50), wey kul kaŋ ga hin ka cere kubayyan hukkumoo goyoo tee. ");
INSERT INTO ses_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Jeejaa kaŋ i gʼa zaa goyoo kaŋ talfandi i ga cere kubayyan hukkumoo ra ti: Irkoy gorodogoo bundu tefawey, nda nga gaaru-gaarey, nda nga ganjey, nda nga ferawey, ");
INSERT INTO ses_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","nda batumaa kaŋ gʼa kuubi ganjey nda ngi ferawey, nda ngi sukahayey, nda ngi karfey, nda ngi jinawey kul nda goyoo kul kaŋ ga teendi a ra. Affoo kul nda nga maaɲoo jinawey ma cebandi a se kaŋ a ga huga nda a kʼa zaa ka koy. ");
INSERT INTO ses_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Woo ti goyoo kaŋ talfandi Merari borey izʼarey alaayan beerey ga cere kubayyan hukkumoo ra Itamar, sargari juwalkaa Haruna izʼaroo hinoo cire.» ");
INSERT INTO ses_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Musa, nda Haruna, nda jamaa boŋkoyney na Kehat izey kabu alaayan beeri ka koy alaayan beeri, hugu ka koy hugu, ");
INSERT INTO ses_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","kʼa dii wey kaŋ goo nda jiiri waranza (30) nda ka žigi ka koy jiiri woyguu (50), wey kul kaŋ ga hin ka goy cere kubayyan hukkumoo ra. ");
INSERT INTO ses_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Arey kaŋ kabandi i ra alaayan beeri ka koy alaayan beeri hinnaa ti zenber hinka nda zangu iyye nda woyguu (2.750). ");
INSERT INTO ses_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Wey ti borey kaŋ kabandi Kehat alaayan beeroo ra, borey kul kaŋ goy cere kubayyan hukkumoo ra, Musa nda Haruna nʼi kabu ka sawa nda yaamaroo kaŋ Abadantaa nʼa noo Musa se. ");
INSERT INTO ses_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Borey kaŋ kabandi Geršoŋ izʼarey ra alaayan beeri ka koy alaayan beeri, hugu ka koy hugu, ");
INSERT INTO ses_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","kʼa dii wey kaŋ goo nda jiiri waranza (30) nda ka žigi ka koy jiiri woyguu (50), wey kul kaŋ ga hin ka goy cere kubayyan hukkumoo ra, ");
INSERT INTO ses_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","arey kaŋ kabandi i ra alaayan beeri ka koy alaayan beeri, hugu ka koy hugu hinnaa ti zenber hinka nda zangu iddu nda waranza (2.630). ");
INSERT INTO ses_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Wey ti borey kaŋ kabandi Geršoŋ izʼarey alaayan beerey ra, borey kul kaŋ goy cere kubayyan hukkumoo ra, Musa nda Haruna nʼi kabu ka sawa nda Abadantaa yaamaroo. ");
INSERT INTO ses_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Borey kaŋ kabandi Merari izʼarey alaayan beerey ra, alaayan beeri ka koy alaayan beeri, hugu ka koy hugu, ");
INSERT INTO ses_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","kʼa dii wey kaŋ goo nda jiiri waranza (30) nda ka žigi ka koy jiiri woyguu (50), wey kul kaŋ ga hin ka goy cere kubayyan hukkumoo ra, ");
INSERT INTO ses_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","arey kaŋ kabandi i ra alaayan beeri ka koy alaayan beeri hinnaa ti zenber hinza nda zangu hinka (3.200). ");
INSERT INTO ses_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Wey ti borey kaŋ kabandi Merari izʼarey alaayan beerey ra, borey kul kaŋ goy cere kubayyan hukkumoo ra, Musa nda Haruna nʼi kabu ka sawa nda yaamaroo kaŋ Abadantaa nʼa noo Musa se. ");
INSERT INTO ses_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Lewi borey kul kaŋ Musa, nda Haruna, nda Izirayel boŋkoyney nʼi kabu alaayan beeri ka koy alaayan beeri, nda hugu ka koy hugu, ");
INSERT INTO ses_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","kʼa dii wey kaŋ goo nda jiiri waranza (30) nda ka žigi ka koy jiiri woyguu (50), wey kul kaŋ ga hin ka goy nda wey kul kaŋ ga hin ka haya jeeje cere kubayyan hukkumoo ra, ");
INSERT INTO ses_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","arey kaŋ kabandi i ra hinnaa ti zenber yaaha nda zangu guu nda woyyaaha (8.580). ");
INSERT INTO ses_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","I kabandi ka sawa nda Abadantaa yaamaroo kaŋ a nʼa noo Musa se a mʼa har i se, ka affoo kul noo nga goyoo nda nga jeejaa. I nʼi kabu nda takaa kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","«Izirayel borey yaamar i ma jiraykoyni, wala boro kaŋ harimundogoo ga mandi, wala boro kaŋ bukaw nʼa žiibandi kaa jamaa kaloo ra. ");
INSERT INTO ses_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","War mʼi kaa, arey nda woyey, war mʼi kaa jamaa kaloo ra, i masi ngi kaloo kaŋ game ay goo ma goro žiibandi.» ");
INSERT INTO ses_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Izirayel borey nʼa tee, i nʼi kaa jamaa kaloo ra. I nʼa tee nda takaa kaŋ nda Abadantaa nʼa har Musa se. ");
INSERT INTO ses_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","«Nee Izirayel borey se: ‹Nda aru wala woy na zunubu tee kaŋ adamizey gʼa tee ka Abadantaa tooɲe, boraa woo duu zunubu, ");
INSERT INTO ses_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","borey ma yadda kaŋ ngi na zunubu tee, boraa kaŋ tooɲe a ma hayaa kul yeeti boraa se kaŋ a nʼa tooɲe, ka hayaa affoo tonton igguu foo kul ga. ");
INSERT INTO ses_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Nda boraa nka buu, de boro sii no kaŋ se i gʼa noo dogoo ra, hayaa ma yeetandi Abadantaa se, maanaa sargari juwalkaa se. Woo banda ga, boraa ga gaaru mo noo nga zunubu tuusuyanoo se kaŋ nda sargari juwalkaa ga zunubu tuusuyanoo tee a se.› ");
INSERT INTO ses_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Haya kul kaŋ Izirayel borey nʼa kaa ngi sargarey ra kʼa daŋ sargari juwalkaa kaboo ra, haya henanantey kul kaŋ i nʼi ka too sargari juwalkaa do, nga wane nda ey. ");
INSERT INTO ses_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Haya kul kaŋ boro foo kul nʼa yeeti jere ga Irkoy se ga tee sargari juwalkaa wane, haya kaŋ boro foo kul nʼa noo a se ga tee nga wane.» ");
INSERT INTO ses_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","«Šelaŋ Izirayel borey se, nee i se: ‹Nda aru wandoo nʼa zanba a mana laadir a here, ");
INSERT INTO ses_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","a kani nda aru foo bila nda kurɲoo ma bay, kurɲoo mana hakiika ka bay. A na nga boŋ žiibandi tuguyan ra, seede sii no, boro kul manʼa gar a ra. ");
INSERT INTO ses_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Nda canseyan huru aroo ra, a canse nga wandoo ga, ka gar woyoo na nga boŋ žiibandi, wala nda aroo canse, a canse nga wandoo ga, ka gar a mana nga boŋ žiibandi, ");
INSERT INTO ses_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","aroo ma koy nda nga wandoo sargari juwalkaa do, ka sargaroo kaa kaŋ ti orž farin kilo hinza, a masi jii doori a boŋ, a masi dugu daŋ a ga, zama canseyan taasu sargari no, taasu sargari kaŋ ti hongandihaya no kaŋ ga laybu hongandi. ");
INSERT INTO ses_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Sargari juwalkaa ga woyoo manandi kʼa kayandi Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Sargari juwalkaa ga hari henanante zaa labu canbu ra, a ga zaa Irkoy gorodogoo gandaa laboo ra kʼa daŋ haroo ra. ");
INSERT INTO ses_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Sargari juwalkaa ga woyoo kayandi Abadantaa jine, a ga boŋoo hinbiroo feeri, woo banda ga, a ga taasu sargari kaŋ ti hongandihayaa daŋ kaboo ra kaŋ ti canseyan taasu sargaroo. Hari hottaa kaŋ ga kate dangayan boro ga, goo sargari juwalkaa kaboo ra. ");
INSERT INTO ses_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Sargari juwalkaa ga woyoo žeendi. A ga nee woyoo se: “Nda aru kul mana kani nda ni, ka gar ni goo ni kurɲoo hinoo cire, mana ni kurɲoo zanba ka ni boŋ žiibandi, ma hallasi dangaroo ra kaŋ hari hottaa woo gʼa daŋ boro ga. ");
INSERT INTO ses_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Amma nda ni kaŋ goo ni kurɲoo hinoo cire, cimi no kaŋ nʼna ni kurɲoo zanba, nʼna ni boŋ žiibandi, de aru kaŋ manʼti ni kurɲoo kani nda ni…” ");
INSERT INTO ses_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Woo banda ga, Sargari juwalkaa ga woyoo žeendi ka dangaroo har, a ga nee woyoo se: “Abadantaa ma ni laali ka ni tee tammaasa futu ni jamaa game, waati kaŋ a na ni tee woy gun, a na ni gundoo funsandi.” ");
INSERT INTO ses_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Nda ni goyoo no, dangayan haroo woo ma huru ni teeley ra ka ni gundoo funsandi ka ni tee woy gun. Woyoo ga nee: “Amin, amin.” ");
INSERT INTO ses_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Sargari juwalkaa ga dangarey wey hantum tiira ra kʼi tuusu hari hottaa ra. ");
INSERT INTO ses_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","A ga hari hottaa kaŋ ga kate dangayan boro ga noo woyoo se a mʼa haŋ, a ga huru gundoo ra kʼa hottandi. ");
INSERT INTO ses_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Sargari juwalkaa ga canseyan taasu sargaroo taa woyoo kone, a gʼa zinji Abadantaa jine ka koy nda a sargari tonadogoo ra. ");
INSERT INTO ses_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Sargari juwalkaa ga kabe mee foo zaa taasu sargaroo ra sanda hongandihaya, a gʼa dullandi sargari tonadogoo boŋ. Woo banda ga no, a ga woyoo noo haroo a mʼa haŋ. ");
INSERT INTO ses_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Waati kaŋ a nʼa haŋandi haroo ka ben, nda a gar a na nga boŋ žiibandi, nda a mana laadir nga kurɲoo se, hari hottaa kaŋ ga kate dangayan boro ga, ga huru gundoo ra kʼa hottandi. Gundoo ga funsu, a ga tee woy gun, de woyoo woo ga tee dangahaya nga jamaa game. ");
INSERT INTO ses_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Amma nda woyoo mana nga boŋ žiibandi, nda a ga henan, taaroo ga hun a ga, a ga duu hayyan. ");
INSERT INTO ses_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Woo ti canseyan ašariyaa woy se kaŋ goo nga kurɲoo hinoo cire ka nga kurɲoo zanba ka nga boŋ žiibandi, ");
INSERT INTO ses_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","wala aru kaŋ canseyan huru a ra ka canse nga wandoo ga, a ma woyoo kayandi Abadantaa jine, sargari juwalkaa ga ašariyaa woo kul zurandi a ga. ");
INSERT INTO ses_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Laybu sii aroo ga, amma woyoo ga tuuru nga layboo se.›» ");
INSERT INTO ses_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","«Nee Izirayel borey se: ‹Nda aru wala woy na meefur cere-cerante zaa ka nga boŋ yeeti jere ga Abadantaa se, ");
INSERT INTO ses_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","boraa ga nga boŋ gagay alaneb hari moora nda harifutu. A si binegar haŋ kaŋ teendi nda alaneb hari moora, a si binegar haŋ kaŋ teendi nda harifutu. A si hari kul haŋ kaŋ teendi nda alaneb, a si alaneb-ize taya ŋaa, a si nga ize kogo ŋaa. ");
INSERT INTO ses_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Waatoo kul kaŋ a ga nga boŋ yeeti jere ga, a si haya ŋaa kaŋ hun alanebɲaa ra, a ma tee guley hala kuuroo. ");
INSERT INTO ses_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Alwaatoo kul kaŋ a na nga boŋ yeeti jere ga, šiini si zuru boŋoo ra hala waatoo kaŋ a nʼa kayandi ka nga boŋ yeeti jere ga Abadantaa se ma ben, a ga henan, a ga naŋ nga boŋoo hinbirey ma zay nda ngi boŋ. ");
INSERT INTO ses_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Alwaatoo kul kaŋ a na nga boŋ yeeti jere ga Abadantaa se, a si man bukaw here. ");
INSERT INTO ses_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Ba baaboo, wala ɲaŋoo, wala armaa, wala woymaa ka buu a si nga boŋ žiibandi, zama nga boŋ yeetiyanoo jere ga nga Koyoo se bara boŋoo ga. ");
INSERT INTO ses_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Alwaatoo kul kaŋ a na nga boŋ yeeti jere ga, a ga henan Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Nda boro jirsi ka buu jeroo ga, boŋoo kaŋ ti nga boŋ yeetiyanoo jere ga silbaa žiibi, a ga nga boŋoo cebu nga henanandiyanoo hane, maanaa a ga nga boŋoo cebu jirbi iyyantoo hane. ");
INSERT INTO ses_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Jirbi yaahantoo hane a ga kate gubaguba hinka wala tuuzun-ize hinka sargari juwalkaa do cere kubayyan hukkumoo miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Sargari juwalkaa ga affoo kaa zunubu sargari, a ga affoo kaa sargari kukurante, a ga zunubu tuusuyanoo tee a se zunuboo kaŋ huru a ga bukaa maaganda. Hanoo din, boraa ga nga boŋoo yeeti jere ga Irkoy se. ");
INSERT INTO ses_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Boraa ga nga boŋ yeeti jere ga Abadantaa se taaga. A ga kate jiiri foo feeji-ize a ma tee tooɲe sargari. Waati jinaa kaŋ a nʼa tee si kabu, zama nga boŋ yeetiyanoo jere ga žiibi. ");
INSERT INTO ses_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Boraa kaŋ na nga boŋ yeeti jere ga, nga ašariyaa ne: Hanoo kaŋ nga boŋ yeetiyanoo jere ga waatoo timme, i gʼa ka koy cere kubayyan hukkumoo miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Sargaroo kaŋ a gʼa kaa Abadantaa se ti: feeji aru-ize kaŋ goo nda jiiri foo kaŋ ga malal sii kaŋ ga tee sargari kukurante, feeji woy-ize kaŋ goo nda jiiri foo kaŋ ga malal sii kaŋ ga tee zunubu sargari, nda gaaru kaŋ ga malal sii kaŋ ga tee alaafiya teendi sargari, ");
INSERT INTO ses_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","nda takula kaŋ ra dolobiri sii dika foo, nda wijilayaŋ kaŋ farin hamnoo diibandi nda jii, nda furme kaŋ ra dolobiri sii kaŋ yonandi nda jii, nda ngi taasu sargaroo, nda ngi sargari hari-haroo. ");
INSERT INTO ses_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Sargari juwalkaa gʼi kaa sargari Abadantaa jine, a ga boraa zunubu sargaroo nda boraa sargari kukurantaa kaa. ");
INSERT INTO ses_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","A ga gaaroo, nda takulawey kaŋ ra dolobiri sii dikaa kaa sargari Abadantaa se sanda alaafiya teendi sargari kaŋ bande taasu sargaroo nda sargari hari-haroo sargandi. ");
INSERT INTO ses_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Boraa kaŋ yeetandi jere ga, ga nga boŋoo cebu cere kubayyan hukkumoo miɲoo ga, a ga nga boŋoo hinbiroo zaa kʼa fur nuunaa ga kaŋ goo alaafiya teendi sargaroo cire. ");
INSERT INTO ses_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Sargari juwalkaa ga gaaroo kaŋ tonandi kabe foo zaa, nda wijila foo kaŋ ra dolobiri sii kaŋ goo dikaa ra, nda furme foo kaŋ ra dolobiri sii, a gʼi daŋ boraa kaŋ na nga boŋ yeeti jere ga kaboo ra nga boŋoo cebuyanoo banda ga. ");
INSERT INTO ses_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Woo banda ga, sargari juwalkaa gʼi zinji kʼi tee sargari zinji-zinjante Abadantaa jine, haya henanante no kaŋ sargari juwalkaa wane nda a, nga, nda feejoo gandoo kaŋ hun sargari zinji-zinjantaa ra, nda cewoo kaŋ hun sargaroo ra kaŋ a nʼa kaa. Woo banda ga, boraa kaŋ na nga boŋ yeeti jere ga, ga hin ka alaneb hari moora haŋ. ");
INSERT INTO ses_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Woo ti boro kaŋ na meefur zaa ka nga boŋ yeeti jere ga ašariyaa. Wey ti hayey kaŋ a ga hima kʼi kaa Abadantaa maaɲoo ga nga boŋ yeetiyanoo jere ga se, bila nda hayey kaŋ a ga hin kʼi tee nda nga boŋ ma kabandi. A ga hayaa noo kaŋ kayandi meefuroo kaŋ a nʼa zaa se ka sawa nda boŋ yeetiyan jere ga ašariyaa.›» ");
INSERT INTO ses_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","«Nee Haruna nda nga izʼarey se: ‹Takaa ne kaŋ nda war ma gaara Izirayel borey se. War ma nee i se: ");
INSERT INTO ses_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“Yala Abadantaa ma albarka daŋ ni ra, a ma ni hawgay. ");
INSERT INTO ses_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Yala Abadantaa ma nga ndumoo annuuraa daŋ ni ga, a ma alhormo tee ma ne. ");
INSERT INTO ses_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Yala Abadantaa ma ɲeli ni ga, a ma ni noo alaafiya.” ");
INSERT INTO ses_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","I mʼay maaɲoo har Izirayel borey ga nda takaa woo, ay ga albarka daŋ i ra.›» ");
INSERT INTO ses_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Hanoo kaŋ Musa na Irkoy gorodogoo cin ka ben, a nʼa yon kʼa yeeti jere ga Irkoy se, nga nda nga jinawey kul. A na sargari tonadogoo nda nga jinawey kul yon kʼi yeeti jere ga Irkoy se. ");
INSERT INTO ses_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Izirayel alwakiiley nda hugu boŋey kate ngi gomney. Alkabiilawey boŋkoyney no kaŋ na kabuyanoo juwal. ");
INSERT INTO ses_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Gomney kaŋ i kate ey Abadantaa jine ne: bari torka gumante iddu nda haw woy cindi hinka (12). Boŋkoyni hinka kul marga ka torka foo noo, boŋkoyni foo kul na haw foo noo. I nʼi ka too Irkoy gorodogoo jine. ");
INSERT INTO ses_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","«Gomney kaŋ i ga kate ey ma ne dii, i ga huru cere kubayyan hukkumoo goyoo ra. Mʼi noo Lewi borey se, affoo kul nda woo kaŋ ga a ga too nga goyoo se.» ");
INSERT INTO ses_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Musa na torkawey nda hawey dii kʼi daŋ Lewi borey kabey ra. ");
INSERT INTO ses_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","A na Geršoŋ izʼarey noo torka hinka nda haw taaci ka sawa nda woo kaŋ ga i ga too ngi goyoo se. ");
INSERT INTO ses_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","A na Merari izʼarey noo torka taaci nda haw yaaha ka sawa nda woo kaŋ ga i ga too ngi goyoo se kaŋ i gʼa tee Itamar kaŋ ti sargari juwalkaa Haruna izʼaroo hinoo cire. ");
INSERT INTO ses_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","A mana Kehat izʼarey noo, zama goyoo kaŋ talfandi i ga manʼti kala ka jinay henanantey zaa ngi jesey ga. ");
INSERT INTO ses_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Boŋkoyney kate ngi gomney sargari tonadogoo se kaŋ ga talfandi Irkoy ga hanoo kaŋ ra a ga yonandi. I kate ey sargari tonadogoo jine. ");
INSERT INTO ses_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Abadantaa nee Musa se: «Zaari foo kul boŋkoyni foo ma kaa ka nga gomnoo noo sargari tonadogoo se kaŋ ga talfandi Irkoy ga.» ");
INSERT INTO ses_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Zaari jinaa, boraa kaŋ kate nga gomnoo ti Nahišoŋ kaŋ ti Aminadab izʼaroo, Žuda alkabiilaa boro. ");
INSERT INTO ses_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Nga gomnoo manʼti kala: nzorfu kaaray taasa kaŋ tiŋaa ti kilo foo nda jere cine, nda nzorfu kaaray kusu kaŋ tiŋaa ti garam zangu yaaha (800) cine ka sawa nda nongu henanantaa nzorfu kaaray tammaa alkadaroo. I kul ga too nda farin hamni kaŋ loobandi nda jii taasu sargaroo se, ");
INSERT INTO ses_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","nda wura poti foo kaŋ tiŋaa ti garam zangu (100) cine kaŋ ga too nda dugu. ");
INSERT INTO ses_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Yaaru foo, nda gaaru foo, nda feeji-ize foo kaŋ goo nda jiiri foo sargari kukurantaa se, ");
INSERT INTO ses_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","nda jindaaru foo zunubu sargaroo se, ");
INSERT INTO ses_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","alaafiya teendi sargaroo se haw hinka, nda gaaru guu, nda jindaaru guu, nda feeji-ize guu kaŋ goo nda jiiri foo. Woo ti Nahišoŋ kaŋ ti Aminadab izʼaroo gomnoo. ");
INSERT INTO ses_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Zaari hinkantoo, Netaniyel kaŋ ti Suwar izʼaroo, Isakar alkabiilaa boŋkoynoo kate nga gomnoo. ");
INSERT INTO ses_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Nga gomnoo manʼti kala: nzorfu kaaray taasa kaŋ tiŋaa ti kilo foo nda jere cine, nda nzorfu kaaray kusu kaŋ tiŋaa ti garam zangu yaaha (800) cine ka sawa nda nongu henanantaa nzorfu kaaray tammaa alkadaroo. I kul ga too nda farin hamni kaŋ loobandi nda jii taasu sargaroo se, ");
INSERT INTO ses_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","nda wura poti foo kaŋ tiŋaa ti garam zangu (100) cine kaŋ ga too nda dugu. ");
INSERT INTO ses_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Yaaru foo, nda gaaru foo, nda feeji-ize foo kaŋ goo nda jiiri foo sargari kukurantaa se, ");
INSERT INTO ses_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","nda jindaaru foo zunubu sargaroo se, ");
INSERT INTO ses_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","alaafiya teendi sargaroo se haw hinka, nda gaaru guu, nda jindaaru guu, nda feeji-ize guu kaŋ goo nda jiiri foo. Woo ti Netaniyel kaŋ ti Suwar izʼaroo gomnoo. ");
INSERT INTO ses_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Zaari hinzantoo, Eliyab kaŋ ti Heloŋ izʼaroo, Zabuloŋ alkabiilaa boŋkoynoo kate nga gomnoo. ");
INSERT INTO ses_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Nga gomnoo manʼti kala: nzorfu kaaray taasa kaŋ tiŋaa ti kilo foo nda jere cine, nda nzorfu kaaray kusu kaŋ tiŋaa ti garam zangu yaaha (800) cine ka sawa nda nongu henanantaa nzorfu kaaray tammaa alkadaroo. I kul ga too nda farin hamni kaŋ loobandi nda jii taasu sargaroo se, ");
INSERT INTO ses_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","nda wura poti foo kaŋ tiŋaa ti garam zangu (100) cine kaŋ ga too nda dugu. ");
INSERT INTO ses_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Yaaru foo, nda gaaru foo, nda feeji-ize foo kaŋ goo nda jiiri foo sargari kukurantaa se, ");
INSERT INTO ses_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","nda jindaaru foo zunubu sargaroo se, ");
INSERT INTO ses_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","alaafiya teendi sargaroo se haw hinka, nda gaaru guu, nda jindaaru guu, nda feeji-ize guu kaŋ goo nda jiiri foo. Woo ti Eliyab kaŋ ti Heloŋ izʼaroo gomnoo. ");
INSERT INTO ses_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Zaari taacantoo, Elisur kaŋ ti Šedewur izʼaroo, Rubeŋ alkabiilaa boŋkoynoo kate nga gomnoo. ");
INSERT INTO ses_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Nga gomnoo manʼti kala: nzorfu kaaray taasa kaŋ tiŋaa ti kilo foo nda jere cine, nda nzorfu kaaray kusu kaŋ tiŋaa ti garam zangu yaaha (800) cine ka sawa nda nongu henanantaa nzorfu kaaray tammaa alkadaroo. I kul ga too nda farin hamni kaŋ loobandi nda jii taasu sargaroo se, ");
INSERT INTO ses_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","nda wura poti foo kaŋ tiŋaa ti garam zangu (100) cine kaŋ ga too nda dugu. ");
INSERT INTO ses_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Yaaru foo, nda gaaru foo, nda feeji-ize foo kaŋ goo nda jiiri foo sargari kukurantaa se, ");
INSERT INTO ses_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","nda jindaaru foo zunubu sargaroo se, ");
INSERT INTO ses_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","alaafiya teendi sargaroo se haw hinka, nda gaaru guu, nda jindaaru guu, nda feeji-ize guu kaŋ goo nda jiiri foo. Woo ti Netaniyel kaŋ ti Suwar izʼaroo gomnoo. ");
INSERT INTO ses_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Zaari guwantoo, Šelumiyel kaŋ ti Surišaday izʼaroo, Simewoŋ alkabiilaa boŋkoynoo kate nga gomnoo. ");
INSERT INTO ses_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Nga gomnoo manʼti kala: nzorfu kaaray taasa kaŋ tiŋaa ti kilo foo nda jere cine, nda nzorfu kaaray kusu kaŋ tiŋaa ti garam zangu yaaha (800) cine ka sawa nda nongu henanantaa nzorfu kaaray tammaa alkadaroo. I kul ga too nda farin hamni kaŋ loobandi nda jii taasu sargaroo se, ");
INSERT INTO ses_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","nda wura poti foo kaŋ tiŋaa ti garam zangu (100) cine kaŋ ga too nda dugu. ");
INSERT INTO ses_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Yaaru foo, nda gaaru foo, nda feeji-ize foo kaŋ goo nda jiiri foo sargari kukurantaa se, ");
INSERT INTO ses_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","nda jindaaru foo zunubu sargaroo se, ");
INSERT INTO ses_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","alaafiya teendi sargaroo se haw hinka, nda gaaru guu, nda jindaaru guu, nda feeji-ize guu kaŋ goo nda jiiri foo. Woo ti Šelumiyel kaŋ ti Surišaday izʼaroo gomnoo. ");
INSERT INTO ses_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Zaari idduwantoo, Elyasaf kaŋ ti Dehuwel izʼaroo, Gad alkabiilaa boŋkoynoo kate nga gomnoo. ");
INSERT INTO ses_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Nga gomnoo manʼti kala: nzorfu kaaray taasa kaŋ tiŋaa ti kilo foo nda jere cine, nda nzorfu kaaray kusu kaŋ tiŋaa ti garam zangu yaaha (800) cine ka sawa nda nongu henanantaa nzorfu kaaray tammaa alkadaroo. I kul ga too nda farin hamni kaŋ loobandi nda jii taasu sargaroo se, ");
INSERT INTO ses_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","nda wura poti foo kaŋ tiŋaa ti garam zangu (100) cine kaŋ ga too nda dugu. ");
INSERT INTO ses_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Yaaru foo, nda gaaru foo, nda feeji-ize foo kaŋ goo nda jiiri foo sargari kukurantaa se, ");
INSERT INTO ses_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","nda jindaaru foo zunubu sargaroo se, ");
INSERT INTO ses_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","alaafiya teendi sargaroo se haw hinka, nda gaaru guu, nda jindaaru guu, nda feeji-ize guu kaŋ goo nda jiiri foo. Woo ti Elyasaf kaŋ ti Dehuwel izʼaroo gomnoo. ");
INSERT INTO ses_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Zaari iyyantoo, Elišama kaŋ ti Amihud izʼaroo, Efrayim alkabiilaa boŋkoynoo kate nga gomnoo. ");
INSERT INTO ses_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Nga gomnoo manʼti kala: nzorfu kaaray taasa kaŋ tiŋaa ti kilo foo nda jere cine, nda nzorfu kaaray kusu kaŋ tiŋaa ti garam zangu yaaha (800) cine ka sawa nda nongu henanantaa nzorfu kaaray tammaa alkadaroo. I kul ga too nda farin hamni kaŋ loobandi nda jii taasu sargaroo se, ");
INSERT INTO ses_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","nda wura poti foo kaŋ tiŋaa ti garam zangu (100) cine kaŋ ga too nda dugu. ");
INSERT INTO ses_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Yaaru foo, nda gaaru foo, nda feeji-ize foo kaŋ goo nda jiiri foo sargari kukurantaa se, ");
INSERT INTO ses_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","nda jindaaru foo zunubu sargaroo se, ");
INSERT INTO ses_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","alaafiya teendi sargaroo se haw hinka, nda gaaru guu, nda jindaaru guu, nda feeji-ize guu kaŋ goo nda jiiri foo. Woo ti Elišama kaŋ ti Amihud izʼaroo gomnoo. ");
INSERT INTO ses_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Zaari yaahantoo, Gamliyel kaŋ ti Pedasur izʼaroo, Manase alkabiilaa boŋkoynoo kate nga gomnoo. ");
INSERT INTO ses_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Nga gomnoo manʼti kala: nzorfu kaaray taasa kaŋ tiŋaa ti kilo foo nda jere cine, nda nzorfu kaaray kusu kaŋ tiŋaa ti garam zangu yaaha (800) cine ka sawa nda nongu henanantaa nzorfu kaaray tammaa alkadaroo. I kul ga too nda farin hamni kaŋ loobandi nda jii taasu sargaroo se, ");
INSERT INTO ses_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","nda wura poti foo kaŋ tiŋaa ti garam zangu (100) cine kaŋ ga too nda dugu. ");
INSERT INTO ses_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Yaaru foo, nda gaaru foo, nda feeji-ize foo kaŋ goo nda jiiri foo sargari kukurantaa se, ");
INSERT INTO ses_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","nda jindaaru foo zunubu sargaroo se, ");
INSERT INTO ses_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","alaafiya teendi sargaroo se haw hinka, nda gaaru guu, nda jindaaru guu, nda feeji-ize guu kaŋ goo nda jiiri foo. Woo ti Gamliyel kaŋ ti Pedasur izʼaroo gomnoo. ");
INSERT INTO ses_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Zaari yaggantoo, Abidaŋ kaŋ ti Žedewoni izʼaroo, Benžameŋ alkabiilaa boŋkoynoo kate nga gomnoo. ");
INSERT INTO ses_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Nga gomnoo manʼti kala: nzorfu kaaray taasa kaŋ tiŋaa ti kilo foo nda jere cine, nda nzorfu kaaray kusu kaŋ tiŋaa ti garam zangu yaaha (800) cine ka sawa nda nongu henanantaa nzorfu kaaray tammaa alkadaroo. I kul ga too nda farin hamni kaŋ loobandi nda jii taasu sargaroo se, ");
INSERT INTO ses_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","nda wura poti foo kaŋ tiŋaa ti garam zangu (100) cine kaŋ ga too nda dugu. ");
INSERT INTO ses_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Yaaru foo, nda gaaru foo, nda feeji-ize foo kaŋ goo nda jiiri foo sargari kukurantaa se, ");
INSERT INTO ses_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","nda jindaaru foo zunubu sargaroo se, ");
INSERT INTO ses_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","alaafiya teendi sargaroo se haw hinka, nda gaaru guu, nda jindaaru guu, nda feeji-ize guu kaŋ goo nda jiiri foo. Woo ti Abidaŋ kaŋ ti Žedewoni izʼaroo gomnoo. ");
INSERT INTO ses_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Zaari woyantoo (10to), Ahiyezer kaŋ ti Amišaday izʼaroo, Dan alkabiilaa boŋkoynoo kate nga gomnoo. ");
INSERT INTO ses_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Nga gomnoo manʼti kala: nzorfu kaaray taasa kaŋ tiŋaa ti kilo foo nda jere cine, nda nzorfu kaaray kusu kaŋ tiŋaa ti garam zangu yaaha (800) cine ka sawa nda nongu henanantaa nzorfu kaaray tammaa alkadaroo. I kul ga too nda farin hamni kaŋ loobandi nda jii taasu sargaroo se, ");
INSERT INTO ses_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","nda wura poti foo kaŋ tiŋaa ti garam zangu (100) cine kaŋ ga too nda dugu. ");
INSERT INTO ses_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Yaaru foo, nda gaaru foo, nda feeji-ize foo kaŋ goo nda jiiri foo sargari kukurantaa se, ");
INSERT INTO ses_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","nda jindaaru foo zunubu sargaroo se, ");
INSERT INTO ses_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","alaafiya teendi sargaroo se haw hinka, nda gaaru guu, nda jindaaru guu, nda feeji-ize guu kaŋ goo nda jiiri foo. Woo ti Ahiyezer kaŋ ti Amišaday izʼaroo gomnoo. ");
INSERT INTO ses_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Zaari woy cindi faantoo (11to), Pagiyel kaŋ ti Okraŋ izʼaroo, Ašer alkabiilaa boŋkoynoo kate nga gomnoo. ");
INSERT INTO ses_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Nga gomnoo manʼti kala: nzorfu kaaray taasa kaŋ tiŋaa ti kilo foo nda jere cine, nda nzorfu kaaray kusu kaŋ tiŋaa ti garam zangu yaaha (800) cine ka sawa nda nongu henanantaa nzorfu kaaray tammaa alkadaroo. I kul ga too nda farin hamni kaŋ loobandi nda jii taasu sargaroo se, ");
INSERT INTO ses_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","nda wura poti foo kaŋ tiŋaa ti garam zangu (100) cine kaŋ ga too nda dugu. ");
INSERT INTO ses_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Yaaru foo, nda gaaru foo, nda feeji-ize foo kaŋ goo nda jiiri foo sargari kukurantaa se, ");
INSERT INTO ses_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","nda jindaaru foo zunubu sargaroo se, ");
INSERT INTO ses_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","alaafiya teendi sargaroo se haw hinka, nda gaaru guu, nda jindaaru guu, nda feeji-ize guu kaŋ goo nda jiiri foo. Woo ti Pagiyel kaŋ ti Okraŋ izʼaroo gomnoo. ");
INSERT INTO ses_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Zaari woy cindi hinkantoo (12to), Ahira kaŋ ti Enaŋ izʼaroo, Neftali alkabiilaa boŋkoynoo kate nga gomnoo. ");
INSERT INTO ses_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Nga gomnoo manʼti kala: nzorfu kaaray taasa kaŋ tiŋaa ti kilo foo nda jere cine, nda nzorfu kaaray kusu kaŋ tiŋaa ti garam zangu yaaha (800) cine ka sawa nda nongu henanantaa nzorfu kaaray tammaa alkadaroo. I kul ga too nda farin hamni kaŋ loobandi nda jii taasu sargaroo se, ");
INSERT INTO ses_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","nda wura poti foo kaŋ tiŋaa ti garam zangu (100) cine kaŋ ga too nda dugu. ");
INSERT INTO ses_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Yaaru foo, nda gaaru foo, nda feeji-ize foo kaŋ goo nda jiiri foo sargari kukurantaa se, ");
INSERT INTO ses_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","nda jindaaru foo zunubu sargaroo se, ");
INSERT INTO ses_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","alaafiya teendi sargaroo se haw hinka, nda gaaru guu, nda jindaaru guu, nda feeji-ize guu kaŋ goo nda jiiri foo. Woo ti Ahira kaŋ ti Enaŋ izʼaroo gomnoo. ");
INSERT INTO ses_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Izirayel borey boŋkoyney gomney kaŋ i kate ey sargari tonadogoo se kaŋ ga talfandi Irkoy ga yonyanoo hane ti: Nzorfu kaaray taasa woy cindi hinka (12), nda nzorfu kaaray kusu woy cindi hinka (12), nda wura poti woy cindi hinka (12). ");
INSERT INTO ses_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Nzorfu taasa foo kul tiŋaa ti nzorfu kaaray tamma boŋ zangu nda waranza (130), kusu foo kul tiŋaa ti nzorfu kaaray tamma boŋ woyye (70). Nzorfu kaaraa kul kaŋ na jinawey wey tee tiŋaa manʼti kala zenber hinka nda zangu taaci (2.400) ka sawa nda nongu henanantaa nzorfu kaaray tammaa alkadaroo, ");
INSERT INTO ses_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","nda wura poti woy cindi hinka (12) kaŋ ga too nda dugu, affoo kul tiŋaa ti nzorfu kaaray tamma boŋ woy (10) ka sawa nda nongu henanantaa nzorfu kaaray tammaa alkadaroo. Potey kul tiŋaa cere ra manʼti kala wura tamma zangu nda waranka (120). ");
INSERT INTO ses_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Adabbawey kul kaŋ kayandi sargari tonantaa se ti: yaaru kobsi woy cindi hinka (12), nda gaaru boŋ woy cindi hinka (12), nda feeji-ize boŋ woy cindi hinka (12), nda taasu sargarey, jindaaru boŋ woy cindi hinka (12) zunubu sargaroo se. ");
INSERT INTO ses_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Adabbawey kul kaŋ kayandi alaafiya teendi sargaroo se ti: haw kobsi waranka cindi taaci (24), gaaru boŋ woydu (60), nda jindaaru boŋ woydu (60), nda feeji-ize boŋ woydu (60) kaŋ goo nda jiiri foo. Woo ti gomnoo kaŋ nondi sargari tonadogoo se kaŋ ga talfandi Irkoy ga, nga yonyanoo banda ga. ");
INSERT INTO ses_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Waati kaŋ Musa huru cere kubayyan hukkumoo ra ka šelaŋ Irkoy bande, a ga maa jinde kaŋ ga šelaŋ nga se daabirjoo se beene kaŋ goo seedetaraa sundukoo boŋ, almalayka hinkaa kaŋ se i ga nee šerib hinkaa game. Takaa woo nda Irkoy ga šelaŋ a bande. ");
INSERT INTO ses_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","«Nee Haruna se: ‹Nda nʼga fitillawey daŋ fitilla gorodogoo ra, ma naŋ fitilla iyyaa kul gaayoo ma dii fitilla gorodogoo jine.›» ");
INSERT INTO ses_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Haruna nʼa tee nda taka follokaa. A na fitillawey daŋ taka kaŋ ra gaayoo goo fitilla gorodogoo jine sanda takaa kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Takaa ne kaŋ nda fitilla gorodogoo teendi: a tee goy kaŋ karandi nda wura, za cewoo hala kutukuryey wura no kaŋ karandi. I nʼa tee nda fasaloo kaŋ Abadantaa nʼa cebe Musa se. ");
INSERT INTO ses_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«Lewi borey kaa Izirayel borey ra, mʼi henanandi. ");
INSERT INTO ses_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Takaa ne kaŋ nda nʼgʼi henanandi: Ma zunubu yaafayan haroo say-say i ga, i ma šiini zaa ka ngi gaahamey hinbirey kul kaa, i ma ngi bankaarawey ɲumay. Woo banda ga, i ga henan. ");
INSERT INTO ses_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","I ma yaaru foo zaa ngi bande nda nga taasu sargaroo kaŋ ti farin hamni kaŋ loobandi nda jii, nʼga yaaru hinkante dii kaŋ ga tee zunubu sargari. ");
INSERT INTO ses_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Ma Lewi borey ka koy cere kubayyan hukkumoo jine, ma Izirayel borey jamaa kul marga. ");
INSERT INTO ses_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Ma Lewi borey manandi Abadantaa jinoo ra, de Izirayel borey ma ngi kabey fur i boŋ. ");
INSERT INTO ses_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Woo banda ga, Haruna ga Lewi borey zaa Izirayel borey ra kʼi cebe sanda sargari Abadantaa jine, i ga Abadantaa goyoo tee. ");
INSERT INTO ses_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Lewi borey ga ngi kabey fur yaarey boŋey ga. I gʼi kaa sargari, affoo ga tee zunubu sargari, affaa ga tee sargari tonante Abadantaa se ka zunubu tuusuyanoo tee Lewi borey se. ");
INSERT INTO ses_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Ma Lewi borey kayandi Haruna nda nga izʼarey jine kʼi tee sargari kaŋ cebandi Abadantaa se. ");
INSERT INTO ses_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Izirayel borey ra, ma Lewi borey daŋ ya ne jere ga i ma tee ay wane. ");
INSERT INTO ses_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Woo banda ga, Lewi borey ga koy cere kubayyan hukkumoo goyoo tee. Mʼi henanandi, i ma tee sargari kaŋ cebandi. ");
INSERT INTO ses_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Zama i nka nondi ya ne, nda cimi i nondi ya ne Izirayel borey ra. Ay gʼi dii gunde jinawey kul dogey ra, maanaa Izirayel borey gunde jinaa kul. ");
INSERT INTO ses_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Izirayel borey gunde jinaa kul ti agay wane, a ma tee adamize wala adabba. Hanoo kaŋ ay na gunde jinawey kul kar Misira gandaa ra, nga no ay nʼi yeeti jere ga ya ne. ");
INSERT INTO ses_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Ay na Lewi borey zaa Izirayel borey gunde jinawey kul dogey ra, ");
INSERT INTO ses_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","de ay nʼi noo Haruna nda nga izʼarey se Izirayel borey ra. Lewi borey nka nondi i se hala i ma goyey tee kaŋ ga teendi cere kubayyan hukkumoo ra Izirayel borey maaɲey ga nda ka zunubu tuusuyanoo tee i se. Woo ra albasi si duu Izirayel borey nda i man nongu henanantaa ga.» ");
INSERT INTO ses_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Musa, nda Haruna, nda Izirayel jamaa kul na hayaa kul tee Lewi borey se sanda takaa kaŋ nda Abadantaa na Musa yaamar Lewi borey here. Woo no Izirayel borey nʼa tee i se. ");
INSERT INTO ses_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Lewi borey na ngi boŋ henanandi, i na ngi bankaarawey ɲumay. Haruna nʼi tee sargari kaŋ cebandi Abadantaa jine, a na zunubu tuusuyanoo tee i se kʼi henanandi. ");
INSERT INTO ses_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Woo banda ga, Lewi borey koy ngi goyoo šintin cere kubayyan hukkumoo ra Haruna nda nga izʼarey jine. I na hayaa kul tee Lewi borey se kaŋ Abadantaa na Musa yaamar Lewi borey here a ma teendi i se. Woo no i nʼa tee i se. ");
INSERT INTO ses_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«Lewi borey here hayey ne: nda Lewi boro duu jiiri waranka cindi guu (25) nda boro kaŋ bisa a, a ma huru cere kubayyan hukkumoo goyoo ra. ");
INSERT INTO ses_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Za a duu jiiri woyguu (50), a ga goyoo naŋ, a si goy koyne. ");
INSERT INTO ses_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","A ga nga armey faaba kaŋ ga goyoo tee cere kubayyan hukkumoo ra, amma a si goyoo tee. Woo ti takaa kaŋ nʼgʼa tee Lewi borey here haya kaŋ ti ngi goyey.» ");
INSERT INTO ses_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Abadantaa šelaŋ Musa se Sinay saajoo ra, ngi fattaroo banda ga Misira gandaa ra jiiri hinkantoo handu jinaa, a nee: ");
INSERT INTO ses_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","«Izirayel borey ma Borcintaraa jingaroo tee nga waatoo kaŋ kayandi ra. ");
INSERT INTO ses_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Handoo woo jirbi woy cindi taacantoo (14to) no, almaaroo ra, war ma jingaroo tee nga waatoo kaŋ kayandi ra. War mʼa tee ka sawa nda hayey kul kaŋ hantumandi a ga nda nga hantumey kaŋ kayandi kul.» ");
INSERT INTO ses_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Musa šelaŋ Izirayel borey se i ma Borcintaraa jingaroo tee. ");
INSERT INTO ses_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","I na jingaroo tee handu jinaa jirbi woy cindi taacantoo (14to) almaaroo ra Sinay saajoo ra. Izirayel borey na hayey tee nda takaa kaŋ nda Abadantaa na Musa yaamar, i nʼi tee nda takaa din da. ");
INSERT INTO ses_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Amma aruyaŋ goo no kaŋ bukaw nʼi žiibandi, hanoo din, i si hin ka Borcintaraa jingaroo tee. Zaari follokaa ra i koy Musa nda Haruna do. ");
INSERT INTO ses_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Arey nee a se: «Bukaw nʼir žiibandi maaganda se, macin se ir si hin kʼir sargaroo kaa Abadantaa se waatoo kaŋ kayandi ra, Izirayel borey game?» ");
INSERT INTO ses_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Musa nee i se: «Wa kay ne hala ya maa hayaa kaŋ Abadantaa gʼa yaamar war šennoo ra.» ");
INSERT INTO ses_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","«Šelaŋ Izirayel borey se ka nee: ‹War alwaddawey kul ra, nda bukaw na boro žiibandi, wala a goo naarumay ra nongu mooro ra, a ma Borcintaraa jingaroo tee Abadantaa se. ");
INSERT INTO ses_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","I sʼa tee kala handu hinkantoo zaari woy cindi taacantoo (14to) almaaroo ra. I mʼa ŋaa nda takulayaŋ kaŋ ra dolobiri sii nda subu hottayaŋ. ");
INSERT INTO ses_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Haya kul masi kani a ra hala suba, biri kul masi kayri a ra. Jingaroo ma teendi ka sawa nda hayaa kul kaŋ hantumandi Borcintaraa jingaroo ga. ");
INSERT INTO ses_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Nda aru kaŋ ga henan, a sii naarumay ra mana Borcintaraa jingaroo tee, a ga hun nga jamaa ra, zama a mana sargari kaa Abadantaa se waatoo kaŋ kayandi ra. Aroo woo, nga zunuboo ga hanga a. ");
INSERT INTO ses_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Nda yaw goro war do kaŋ ga Borcintaraa jingaroo tee Abadantaa maaɲoo ga, a ga hanga hantumoo kaŋ kayandi Borcintaraa jingaroo here. Haya follokaa no ma hantumandi yaw nda ganda-ize se.›» ");
INSERT INTO ses_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Hanoo kaŋ seedetaraa hukkumoo kaŋ ra Irkoy gorodogoo goo cinandi ka ben, duulaa nʼa gum, za cijinoo hala subbaahoo ra a goo Irkoy gorodogoo ga sanda nuune alhaali. ");
INSERT INTO ses_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Takaa woo da waati kul, duulaa gʼa gum, cijin here a ga tee nuune alhaali. ");
INSERT INTO ses_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Waati kaŋ duulaa tun hukkumoo boŋ, Izirayel borey ga tun ka koy, nongu kaŋ ra duulaa kay, i ga goro. ");
INSERT INTO ses_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Abadantaa yaamaroo ga Izirayel borey ga tun ka koy, nga yaamaroo ga i ga goro. Waatoo kul kaŋ duulaa goo Irkoy gorodogoo boŋ i ga goro. ");
INSERT INTO ses_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Nda duulaa gay a ga kay Irkoy gorodogoo boŋ jirbi booboyaŋ, Izirayel borey ga Abadantaa goyoo tee, i si tun ka koy. ");
INSERT INTO ses_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Nda duulaa mana kay Irkoy gorodogoo boŋ kala jirbi kaynayaŋ, i ga goro Abadantaa yaamaroo ga i ga goro no din, nga yaamaroo ga i ga tun ka koy. ");
INSERT INTO ses_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Nda duulaa si kay kala cijinoo ra ka koy subbaahi, nda duulaa tun subbaahoo ra, i ga koy. Nda duulaa tun cijin foo nda zaari foo banda ga, i ga tun ka koy. ");
INSERT INTO ses_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Nda duulaa kay Irkoy gorodogoo boŋ jirbi hinka, wala handu foo, wala waati kuku, Izirayel borey ga goro no din. I si koy, nda duulaa tun, i ga koy. ");
INSERT INTO ses_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Abadantaa yaamaroo ga i ga goro, nga yaamaroo ga i ga tun ka koy. I ga Abadantaa goyoo tee ka sawa nda yaamaroo kaŋ nda Abadantaa na Musa kʼi yaamar. ");
INSERT INTO ses_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","«Laati beeri hinka tee, mʼi tee nda nzorfu kaaray kaŋ karandi. Ngi nda nʼga jamaa cee i ma marga nda ka ngi tun-ka-koyyanoo ngi kaley ra ka koy bayrandi. ");
INSERT INTO ses_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Nda laati beerey hẽe, jamaa kul ma kaa ka marga ni jere cere kubayyan hukkumoo miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Nda laati beeri folloku ka hẽe, boŋkoyney kaŋ ti Izirayel wongu-ize jamawey jineborey ga marga ni jeroo ga. ");
INSERT INTO ses_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Nda war na laatoo ka kaati beeri tee, borey kaŋ ga goro dandi here ga tun ka koy. ");
INSERT INTO ses_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Nda war na laatoo kar ka kaati beeri tee cee hinkantoo, kaley kaŋ goo gurma here ga koy. Laatoo karyan jinde beeroo ga tee ngi tun-ka-koyyanoo se. ");
INSERT INTO ses_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","War ga laati kar ka jamaa marga, amma jindoo masi beeri. ");
INSERT INTO ses_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Haruna izʼarey kaŋ ti sargari juwalkey no ma hilley hẽenandi, hantum kaŋ si tun ti woo war alwaddawey se. ");
INSERT INTO ses_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Nda war gandaa ra war koy war iberi gande kaŋ kaa ka war wongu, war ga laatey kar jindey ma beeri. Woo ra Abadantaa, war Koyoo ga hongu war, de war ga hallasi war torrokey ra. ");
INSERT INTO ses_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","War ɲaali zaarey hane, nda war jingarey hane, nda handey kayyaney hane war ma laatey kar war sargari kukurantey, nda alaafiya teendi sargarey bande. Woo ra war Koyoo ga honga war. Agay ti Abadantaa, war Koyoo.» ");
INSERT INTO ses_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Jiiri hinkantoo handu hinkantoo jirbi warankantoo (20to), duulaa tun seedetaraa hukkumoo boŋ. ");
INSERT INTO ses_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Izirayel borey hun Sinay saajoo ra ka kay nongu nda nonguyaŋ ra. Duulaa kay Paraŋ saajoo ra. ");
INSERT INTO ses_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Cee jinaa ti woo i ma koy ka sawa nda yaamaroo kaŋ nda Abadantaa na Musa kʼi yaamar. ");
INSERT INTO ses_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Žuda borey wongu-izey ka jin ka tun ka koy ngi liiliwaloo cire, wongu-ize ka koy wongu-ize. Ngi wongu-izey boŋkoynoo ti Nahišoŋ kaŋ ti Aminadab izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Isakar borey alkabiilaa wongu-izey boŋkoynoo ti Netaniyel kaŋ ti Suwar izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Zabuloŋ borey alkabiilaa wongu-izey boŋkoynoo ti Eliyab kaŋ ti Heloŋ izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Irkoy gorodogoo feerandi, Geršoŋ izʼarey nda Merari izʼarey kʼa zaa ka koy. ");
INSERT INTO ses_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Woo banda ga, Rubeŋ alkabiilaa wongu-izey koy ngi liiliwaloo cire, wongu-ize ka koy wongu-ize. Ngi wongu-izey boŋkoynoo ti Elisur kaŋ ti Šedewur izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Simewoŋ borey alkabiilaa wongu-izey boŋkoynoo ti Šelumiyel kaŋ ti Surišaday izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Gad borey alkabiilaa wongu-izey boŋkoynoo ti Elyasaf kaŋ ti Dehuwel izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Woo banda ga, Kehat borey na nongu henanantaa zaa ka koy. Borey jerey na Irkoy gorodogoo cin hala i ga kaa. ");
INSERT INTO ses_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Ngi banda ga, Efrayim borey wongu-izey koy ngi liiliwaloo cire, wongu-ize ka koy wongu-ize. Efrayim wongu-izey boŋkoynoo ti Elišama kaŋ ti Amihud izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Manase borey alkabiilaa wongu-izey boŋkoynoo ti Gamliyel kaŋ ti Pedasur izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Benžameŋ borey alkabiilaa wongu-izey boŋkoynoo ti Abidaŋ kaŋ ti Žedewoni izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Ngi kul banda ga, Dan borey wongu-izey kaŋ ga kaley kul bandaheroo hawgay tun ka koy ngi liiliwaloo cire, wongu-ize ka koy wongu-ize. Dan borey wongu-izey boŋkoynoo ti Ahiyezer kaŋ ti Amišaday izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Ašer borey alkabiilaa wongu-izey boŋkoynoo ti Pagiyel kaŋ ti Okraŋ izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Neftali borey alkabiilaa wongu-izey boŋkoynoo ti Ahira kaŋ ti Enaŋ izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Takaa woo ti Izirayel borey koyyanoo takaa, wongu-ize ka koy wongu-ize. Taka follokaa nda i ga tun ka koy. ");
INSERT INTO ses_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Musa nee Hobab se kaŋ ti Rehuwel nga nzuraa, Majaŋ boraa izʼaroo: «Ir ga koy gandaa ra kaŋ Abadantaa nee: ‹Ay gʼa noo war se.› Kaa ir bande, ir ga gomni tee ma ne, zama Abadantaa mana šelaŋ kala Izirayel gomnoo se.» ");
INSERT INTO ses_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hobab nee: «Ay si koy, ay si koy kala ay gandaa ra nda ay dumoo do.» ");
INSERT INTO ses_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Musa yee ka šelaŋ ka nee: «Suuri, masi hun ir bande, zama nʼga nongey bay kaŋ ra ir ga hin ka goro saajoo ra, nʼga tee ir moɲey. ");
INSERT INTO ses_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Nda ni hanga ir bande, gomnoo kaŋ Abadantaa gʼa tee ir se, nʼga duu a ra.» ");
INSERT INTO ses_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","I tun ka hun Abadantaa tondi hondoo cire ka jirbi hinza diray tee. Abadantaa amaanaa sundukoo koy i jine jirbi hinzaa diraa ra ka hunanzamdoo ceeci i se. ");
INSERT INTO ses_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Abadantaa duulaa goo i boŋ zaari here waati kaŋ i tun ka hun ngi kaloo ra. ");
INSERT INTO ses_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Sundukoo koyyanoo ga, Musa ga nee: «Tun Abadantaa, hala ni iberey ma say, borey kaŋ ga konna ni ma zuru ni jine.» ");
INSERT INTO ses_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Waati kaŋ a kay, Musa ga nee: «Yee kate Abadantaa, ka goro Izirayel wongu-ize jama zenberey game.» ");
INSERT INTO ses_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Han foo jamaa ŋuunuŋuunu futay Abadantaa ga. Abadantaa maarʼa, a futu, nga nuunaa dii jamaa gamey ra ka ngi kaloo boŋ faa halaci. ");
INSERT INTO ses_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Jamaa kaati ka Musa cee. Musa na Abadantaa ŋaaray, nuunaa kay. ");
INSERT INTO ses_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","I na nongoo din maaɲoo daŋ Tabera (maanaa «nuune»), zama Abadantaa nuunaa dii Izirayel game. ");
INSERT INTO ses_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Dumi fooyaŋ kaŋ goo Izirayel borey game hanse ka boonay ŋaayan. Izirayel borey mo yee koyne ka hẽe ka nee: «May no mʼir noo ham ir mʼa ŋaa? ");
INSERT INTO ses_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Ir ga hongu hamiisawey kaŋ ir gʼi ŋaa yaada Misira, nda konkonburey, nda moley, nda albašar fitawey, nda albašarey, nda layoo. ");
INSERT INTO ses_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Sohõ ir goo ma ɲom, haya kul sii no, ir si dii haya kul kala ŋaahayaa kaŋ se i ga nee man.» ");
INSERT INTO ses_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Man si hima nda kala hayni gurunbu, nga alhaaloo ma nee deeli. ");
INSERT INTO ses_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Jamaa ga fatta ka koy a kuuna, i gʼa fufu fufutondi ga wala i mʼa dur tinda ra. A ga hinandi kusu ra wala i mʼa tee furme. Nga tenbaa ma nee takula kaŋ teendi jii ra. ");
INSERT INTO ses_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Waati kaŋ harandaŋoo kani jamaa kaloo ga cijinoo ra, nga no manoo ga zunbu kaloo ga. ");
INSERT INTO ses_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Musa ga maa jamaa ga hẽe, i marga alaayan beeri nda alaayan beeri, affoo kul nga hukkumoo miɲoo ga. Abadantaa hanse ka futu, woo din mana kan Musa se. ");
INSERT INTO ses_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Musa nee Abadantaa se: «Macin se nʼgʼay maray, agay ni baɲɲaa? Macin se mana alhormo tee ya ne, hala nongu kaŋ ra nʼga jamaa woo kul jeejaa fur ay ga? ");
INSERT INTO ses_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Agay ka jamaa woo kul gundoo zaa wala? Agay kʼi hay wala, kaŋ se nʼga nee ya ne: ‹I dii ni gandoo ra sanda takaa kaŋ nda zanka zaakaw ga zanka zaa ka koy nda a gandaa ra kaŋ nʼna žee kaŋ nʼgʼa noo ngi baabey se›? ");
INSERT INTO ses_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Man ra ay ga duu ham kʼa noo jamaa woo kul se? Zama i ga hẽe ay ga ka nee: ‹Ir noo ham kaŋ ir gʼa ŋaa!› ");
INSERT INTO ses_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Agay foo si hin ka jamaa woo zaa, a ga hanse ka tiŋ ya ne. ");
INSERT INTO ses_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Nda woo no nʼgʼa tee ya ne, alhormo tee ya ne, adiši ay wii, ya si dii bonaa woo kaŋ goo kaa ay ga.» ");
INSERT INTO ses_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Abadantaa nee Musa se: «Izirayel aru beerey kaŋ nʼgʼi dii jamaa boro beerey nda jamaa goy juwalkey, ngi boro woyye (70) marga ya ne i ra. Mʼi ka koy cere kubayyan hukkumoo miɲoo ga, i ma kay no din ni bande. ");
INSERT INTO ses_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Ay ga zunbu ka šelaŋ ni bande no din, Hundoo kaŋ goo ni ga, ay ga zaa a ra kʼa daŋ i ga, nga ra i ga jamaa jeejaa zaa ni bande, nʼsʼa zaa ni hinne. ");
INSERT INTO ses_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Ma nee jamaa se: ‹Suba se, wa war boŋ daŋ jere ga Irkoy se, war ga ham ŋaa, zama war hẽe Abadantaa haŋawey ra ka nee: “May no mʼir noo ham ir mʼa ŋaa? Ir cindi ka maakaani Misira!” Abadantaa ga war noo ham war ma ŋaa. ");
INSERT INTO ses_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","War gʼa ŋaa, manʼti zaari foo, manʼti zaari hinka, manʼti zaari guu, manʼti zaari woy (10), manʼti zaari waranka (20), ");
INSERT INTO ses_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","amma handu foo timmante, hala waati kaŋ a fatta nda war niiney, a na war biney kaa, zama war wanji Abadantaa ga kaŋ goo war game, war hẽe a ga ka nee: “Macin se ir hun Misira?”›» ");
INSERT INTO ses_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Musa nee: «Jamaa kaŋ game ay goo manʼti kala wongu-ize boro zenber zangu iddu (600.000) kaŋ goo cee ga, ni nee: ‹Ay gʼi noo ham i ma ŋaa handu foo timmante.› ");
INSERT INTO ses_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Ba nda boro na alman buuna nda ibeeri koosu i se, a ga wasa i se wala? Wala boro ma teekoo hamiisa kul dii kate i se, a gʼi wasa wala?» ");
INSERT INTO ses_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Abadantaa nee Musa se: «Abadantaa kaboo mma dunbay wala? Sohõ nʼga kaa ka dii wala šennoo kaŋ ay nʼa har ma ne ga tee wala a si tee.» ");
INSERT INTO ses_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Musa fatta ka koy Abadantaa šenney har jamaa se. Woo banda ga, a na aru woyye (70) marga Izirayel boro beerey ra i ma cere kubayyan hukkumoo kuubi kʼa bere. ");
INSERT INTO ses_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Abadantaa zunbu kate duulaa ra ka šelaŋ a bande. Irkoy Hundoo kaŋ goo Musa ga, Abadantaa zaa a ra kʼa daŋ boro beeri woyyaa (70) ga. Za Hundoo huru i ga, i šintin ka annabitaray tee, amma manʼti waati kuku. ");
INSERT INTO ses_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Aru hinka kaŋ affoo maaɲoo ti Eldad, affaa maaɲoo ti Medad cindi kaloo ra. Irkoy Hundoo zunbu ngi mo ga, maaɲey goo boro beerey ra kaŋ hantumandi, amma i mana fatta ka koy cere kubayyan hukkumoo miɲoo ga, i ga annabitaray tee jamaa kaloo ra. ");
INSERT INTO ses_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Zankaaru foo zuru ka koy Musa do kʼa filla a se ka nee: «Eldad nda Medad goo ma annabitaray tee jamaa kaloo ra.» ");
INSERT INTO ses_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Žozuwe, Nun izʼaroo kaŋ ga goy Musa bande za nga zankataraa, zaabi ka nee: «Ay koyoo Musa, i kayandi.» ");
INSERT INTO ses_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Musa nee a se: «Ni mma canse ya ne? Jalla, nda a gar ba Abadantaa jamaa kul ti annabiyaŋ, nda a gar ba Abadantaa nka nga Hundoo daŋ i ga!» ");
INSERT INTO ses_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Woo banda ga, Musa willi jamaa kaloo ra, nga nda Izirayel boro beerey. ");
INSERT INTO ses_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Abadantaa na hew tunandi, hewoo na jerfendayyaŋ ka hun za teekoo here ka kaa kʼi kaŋandi jamaa kaloo ra, kʼa kuubi kʼa bere, caraw foo zaari foo diray kuuyan, caraw faa zaari foo diray kuuyan, i goo cere boŋ laboo ga ka jer beene kabedaaru hinka. ");
INSERT INTO ses_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Jamaa tun zaaroo din kul nda cijinoo kul, nda subaa zaaroo kul ka jerfendawey kuuna. Boro kaŋ mana haya kul kuuna nga no ma kilo zenber hinka (2.000) jerfenday kuuna. I nʼi daaru ka jamaa kaloo kuubi kʼa bere. ");
INSERT INTO ses_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Hamoo goo miɲey ra, i manʼa kaama jina kaŋ Abadantaa futayyanoo kaa jamaa ga. Abadantaa na balaawu futu beeri ka jamaa kar. ");
INSERT INTO ses_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","I na nongoo din maaɲoo daŋ Kiworot-Hataawa (maanaa «boonay futaa saaraa»), zama no din ra jamaa kaŋ boonay futu fijandi. ");
INSERT INTO ses_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Jamaa hun Kiworot-Hataawa ka koy Haserot, de i goro no din. ");
INSERT INTO ses_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Maryama nda Haruna šelaŋ Musa ga woyoo kaŋ ti Ecopi boro kaŋ a nʼa zaa maaganda, zama Ecopi woy no a hiiji a. ");
INSERT INTO ses_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","I nee: «Musa hinne miɲoo nda Abadantaa ga šelaŋ? A si šelaŋ nda ir mo miɲey wala?» Abadantaa maarʼa. ");
INSERT INTO ses_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Musa ti aru kaŋ ga hanse ka nga boŋ yeeti ganda, nga boŋ-yeeti-gandayanoo cine mana tee laboo ga. ");
INSERT INTO ses_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Dogoo din da Abadantaa nee Musa, nda Haruna, nda Maryama se: «War boro hinzaa ma fatta ka koy cere kubayyan hukkumoo here.» Ngi boro hinzaa fatta ka koy. ");
INSERT INTO ses_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Abadantaa zunbu duula kaŋ ga kay ra ka kay cere kubayyan hukkumoo miɲoo ga. A ciya Haruna nda Maryama se, ngi boro hinkaa man kate. ");
INSERT INTO ses_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","A nee: «Wa maa ay šenney se. Nda Abadantaa annabi goo war ra, bangayyan ra ay gʼay boŋ cebe a se, handiri ra ay ga šelaŋ a bande. ");
INSERT INTO ses_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Amma manʼti takaa din no ay tamoo Musa bande, ay hugoo kul ra boro laadirantaa no. ");
INSERT INTO ses_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Ay ga šelaŋ a se mee nda mee, bangayyan ra, ay si šenni daabu a se. A ga dii Abadantaa azzaatoo. Adiši macin se war mana hunbur ka šelaŋ Musa ga, ay tamoo ga?» ");
INSERT INTO ses_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Abadantaa futu i ga, a koy. ");
INSERT INTO ses_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Duulaa hun cere kubayyan hukkumoo ga. Nga ne, Maryama jiray, a kaaray ma nee waa. Haruna bere ka Maryama guna, nga ne, Maryama jiray. ");
INSERT INTO ses_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Woo banda ga, Haruna nee Musa se: «Suuri, ay koyoo, masi zunuboo dii ir se kaŋ ir nʼa tee hollokomtaray ra. ");
INSERT INTO ses_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Ay gʼa wiri ni ga, a masi tee sanda ize bukaw kaŋ hayandi, hamoo jeroo hasara kaŋ a fatta ɲaŋoo gundoo ra.» ");
INSERT INTO ses_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Musa kaati ka Abadantaa cee ka nee: «Irkoy, ay gʼa wiri ni ga, a noo baani!» ");
INSERT INTO ses_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Abadantaa nee Musa se: «Nda baaboo nka tufa moɲey ga, a nka si haw jirbi iyye? Aywa, a ma hun jamaa kaloo ra jirbi iyye, nga banda ga, a ga yee ka huru jamaa ra.» ");
INSERT INTO ses_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","I na Maryama kaa jamaa kaloo ra jirbi iyye. Jamaa mana koy hala waatoo kaŋ Maryama yee ka huru jamaa ra. ");
INSERT INTO ses_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Woo banda ga, jamaa tun Haserot ka koy goro Paraŋ saajoo ra. ");
INSERT INTO ses_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«Aruyaŋ sanba i ma koy Kanaŋ gandaa kaŋ ay gʼa noo Izirayel borey se monno. Alkabiila foo kul aru foo ga sanbandi i ra, a ma gar affoo kul i ra manʼti kala boŋkoyni.» ");
INSERT INTO ses_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Musa nʼi sanba za Paraŋ saajoo ra ka sawa nda Abadantaa yaamaroo. Arey wey kul manʼti kala Izirayel borey boŋkoyniyaŋ. ");
INSERT INTO ses_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Ngi maaɲey ne: Woo kaŋ hun Rubeŋ alkabiilaa ra ti Šamuwa, Zakkur izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Woo kaŋ hun Simewoŋ alkabiilaa ra ti Šafat, Hori izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Woo kaŋ hun Žuda alkabiilaa ra ti Kaleb, Yefune izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Woo kaŋ hun Isakar alkabiilaa ra ti Yigal, Isufi izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Woo kaŋ hun Efrayim alkabiilaa ra ti Hoze, Nun izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Woo kaŋ hun Benžameŋ alkabiilaa ra ti Palti, Rafu izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Woo kaŋ hun Zabuloŋ alkabiilaa ra ti Gadiyel, Sodi izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Woo kaŋ hun Isufi alkabiilaa ra, maanaa Manase alkabiilaa here ti Gaddi, Susi izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Woo kaŋ hun Dan alkabiilaa ra ti Amiyel, Gemali izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Woo kaŋ hun Ašer alkabiilaa ra ti Setur, Minkaylu izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Woo kaŋ hun Neftali alkabiilaa ra ti Nahibi, Wofisi izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Woo kaŋ hun Gad alkabiilaa ra ti Gehuwel, Maki izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Wey ti arey maaɲey kaŋ Musa nʼi sanba i ma koy gandaa monno. Musa na Hoše kaŋ ti Nun izʼaroo maaɲoo daŋ Žozuwe. ");
INSERT INTO ses_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Musa nʼi sanba i ma koy Kanaŋ gandaa monno. A nee i se: «Wa koy nda Negew gandaa ka žigi ka koy tondi hondoo ra. ");
INSERT INTO ses_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Wa gandaa guna, haya kaŋ ti nga takaa, jamaa kaŋ goo a ra, gaabi goo i ra wala a sii i ra, i ga boobo wala i si boobo. ");
INSERT INTO ses_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Ka dii gandaa kaŋ ra i goro, a ga boori wala a si boori. Ka dii koyrawey kaŋ ra i goro, koyra buuna-buunayaŋ no wala koyrayaŋ no kaŋ kuubandi nda cete. ");
INSERT INTO ses_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Ka dii gandaa, nga laboo ga boori wala a si boori, tuuri goo a ra wala a sii a ra. Wa bine tee, war ma kate gandaa tuuri-izey.» Alaneb-ize jina-jinawey waatoo no. ");
INSERT INTO ses_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","I žigi ka koy gandaa monno, za Tisin saajoo hala Rehob ka koy Hamat miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","I žigi Negew ka koy hala Hebroŋ kaŋ ra Ahimaŋ, nda Šešay, nda Talmay kaŋyaŋ ti Anak hayrey goo. Hebroŋ cinandi jiiri iyye Sowaŋ jine kaŋ goo Misira. ");
INSERT INTO ses_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","I too hala Eškol gooroo do kaŋ i na alanebɲaa kabe kaŋ ga alaneb-izeyaŋ fafa beeri foo goo dunbu, boro hinka kʼa zaa nda bundu. I na grenad-izeyaŋ nda jeejayyaŋ mo zaa. ");
INSERT INTO ses_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","I na nongoo din maaɲoo daŋ Eškol gooroo (maanaa «fafaa gooroo»), tuuri-izey fafaa kaŋ Izirayel borey nʼa dunbu maaganda se. ");
INSERT INTO ses_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Kaŋ i koy gandaa monno, jirbi woytaaci (40) banda ga, i yee kate. ");
INSERT INTO ses_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Kaŋ i kaa, i koy Musa, nda Haruna, nda Izirayel jamaa kul do kaŋ goo Kadeš, Paraŋ saajoo ra. I deede i se, ngi nda jamaa kul, i nʼi cebe gandaa tuuri-izey. ");
INSERT INTO ses_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","I deede ka nee: «Ir koy gandaa ra kaŋ ra nʼnʼir sanba, nda cimi, ganda no kaŋ ra waa nda yuu ga tee hari, nga tuuri-izey ne. ");
INSERT INTO ses_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Amma jamaa kaŋ goo gandaa ra ga gaabi, koyrawey cete gʼi kuubi, i ga hanse ka beeri, ir dii ba Anak hayrey no din. ");
INSERT INTO ses_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalek borey goro Negew gandaa ra. Heti borey, nda Žebus borey, nda Amor borey goo tondi hondey ra. Kanaŋ borey si goro kala teekoo miɲoo ga nda Žurdeŋ isaa miɲoo ga.» ");
INSERT INTO ses_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kaleb na jamaa kaŋ mana yadda Musa se miɲey daabu, a nee: «Ir ma žigi ka koy gandaa dii, šikka sii ir ga hin ey.» ");
INSERT INTO ses_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Amma arey kaŋ žigi ka koy a bande nee: «Ir si hin ka žigi ka koy jamaa din ga, zama i ga hin ir.» ");
INSERT INTO ses_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","I šintin ka gandaa kaŋ i koy a monno maa futu har Izirayel borey jine. I nee: «Gandaa kaŋ ir nʼa yaara beene nda ganda kʼa monno, manʼti kala gandaa kaŋ ga nga gorokey ŋaa. Borey kul kaŋ ir dii ey a ra manʼti kala boro kukuyaŋ. ");
INSERT INTO ses_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Ir dii no din boro doogey kaŋ ti Anak borey kaŋ hun boro doogey dumoo ra. Ir tee ir boŋ moɲey cire ikaccuyaŋ sanda ndooyaŋ, takaa din da nda ir hima moɲey cire.» ");
INSERT INTO ses_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Jamaa kul na ngi jindey jer ka kaati. Borey na cijinoo tee i ga hẽe. ");
INSERT INTO ses_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Izirayel borey kul šintin ka ŋuunuŋuunu Musa nda Haruna ga, jamaa kul nee: «Nda a gar ba ir nka buu Misira gandaa ra! Nda a gar ba ir nka buu saajoo woo ra! ");
INSERT INTO ses_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Cin se Abadantaa gʼir daŋ gandaa woo ra nda i gʼir wii nda takuba? Ir wandey nda ir izey ga diyandi? Ir ma yee Misira mana baa ir se wala?» ");
INSERT INTO ses_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","I nee cere se: «Ir ma boŋkoyni tee ir boŋ se, ir ma yee Misira.» ");
INSERT INTO ses_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Musa nda Haruna kaŋ laboo ra ngi boŋey ga Izirayel jamaa borey kul jine. ");
INSERT INTO ses_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Žozuwe, Nun izʼaroo nda Kaleb, Yefune izʼaroo kaŋ goo borey ra kaŋ koy gandaa monno na ngi darbawey kottu, ");
INSERT INTO ses_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","de i nee Izirayel borey jamaa kul se: «Gandaa kaŋ ir nʼa yaara beene nda ganda kʼa monno, nda cimi a ga hanse ka boori. ");
INSERT INTO ses_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Nda ir takaa ga kan Abadantaa se, a gʼir daŋ gandaa din ra, a gʼa noo ir se. Ganda no kaŋ ra waa nda yuu ga tee hari. ");
INSERT INTO ses_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Hayaa kaŋ no ti war masi ture Abadantaa ga, war masi hunbur gandaa din borey, zama ir gʼi tee loomo foo. Ngi hawgaykaa hun i bande, ir binde, Abadantaa goo ir bande, war masi hunbur ey.» ");
INSERT INTO ses_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Jamaa kul nee i mʼi warra nda tondi kʼi wii. Dogoo din da Abadantaa daržaa bangay Izirayel borey kul se cere kubayyan hukkumoo do. ");
INSERT INTO ses_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Abadantaa nee Musa se: «Waati foo no jamaa woo ga fay nda ay kaynandiyanoo? Tammaasawey kul kaŋ ay nʼi tee i game, waati foo no i ga naanay agay? ");
INSERT INTO ses_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ay ga sorfa kʼi kar, ay gʼi tuusu, de ay ga ni tee dumi beeri gaabante ka bisa ey.» ");
INSERT INTO ses_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Musa nee Abadantaa se: «Misira borey ga maa woo. Nʼna jamaa woo žigandi kʼi kaa i game nda ni gaaboo, ");
INSERT INTO ses_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","i nʼa har gandaa woo borey se. I maa kaŋ ni, Abadantaa, ni goo jamaa woo game, ni, Abadantaa, nʼga bangay moo nda moo, ni duulaa ga kay i boŋ, nʼga dira i jine duula kaŋ ga kay i jine ra zaari here, cijin here nuune kaŋ ga kay i jine ra. ");
INSERT INTO ses_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Nda nʼna jamaa woo wii sanda boro folloku, gandawey kaŋ maa ni maaɲoo ga nee: ");
INSERT INTO ses_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‹Abadantaa nka mana hin ka jamaa daŋ gandaa ra kaŋ a žee nga gʼa noo i se, woo maaganda se a nʼi halaci saajoo ra.› ");
INSERT INTO ses_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Sohõ ay gʼa wiri ni ga, ay Koyoo, ma ni gaaboo cebe ni hinoo ra sanda takaa kaŋ nda nʼnʼa har ka nee: ");
INSERT INTO ses_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‹Abadantaa si cahã ka futu, nga borohennataraa ga beeri, a ga laybu nda hooyan yaafa. A si goy futu teekaw dii sanda boro kaŋ mana ifutu tee. A ga baabey laybey hangandi izey hala alwadda hinzantoo nda itaacantoo ga.› ");
INSERT INTO ses_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Ay gʼa wiri ni ga, ma jamaa woo layboo yaafa i se ni borohennataray beeroo ra sanda takaa kaŋ nda ni yaafa jamaa woo se za Misira hala ne.» ");
INSERT INTO ses_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Abadantaa nee: «Ay yaafa i se ni šennoo maaganda. ");
INSERT INTO ses_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Amma ay ga žee ay hunaroo ga nda Abadantaa daržaa kaŋ ga laboo kul too ga, ");
INSERT INTO ses_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","borey kul kaŋ dii ay daržaa nda tammaasawey kaŋ ay nʼi tee Misira nda saajoo ra kaŋyaŋ nʼay sii cee woy (10), de mo i mana haŋajer ay šennoo se, ");
INSERT INTO ses_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","abada i si dii gandaa kaŋ ay žee kaŋ ay gʼa noo ngi baabey se. Wey kul kaŋ nʼay kaynandi si dii gandaa. ");
INSERT INTO ses_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Amma Kaleb, ay tamoo kaŋ ra anniya tana goo, kaŋ hanga agay nga fondawey kul ra, ay gʼa daŋ gandaa ra kaŋ ra a koy, nga hayroo ga duu a. ");
INSERT INTO ses_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Amalek borey nda Kanaŋ borey si goro kala gooroo ra. Suba, wa kuubi ka koy saajoo ra, Kakaarey teekoo here.» ");
INSERT INTO ses_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Abadantaa šelaŋ Musa nda Haruna se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","«Hala waati foo no jama laalaa woo ga ŋuunuŋuunu ay ga ka ben? Ay maa ŋuunuŋuunuyanoo kaŋ Izirayel borey nʼa tee ay ga. ");
INSERT INTO ses_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Nee i se: ‹Ay hunaroo ga, agay Abadantaa ka šelaŋ ka nee: “Ay ga war bana ka sawa nda hayaa kaŋ war nʼa daŋ ay haŋaa ra. ");
INSERT INTO ses_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","War kunturey ga kaŋ ka buu saajoo woo ra. Wey kul kaŋ kabandi, kʼa dii za wey kaŋ goo nda jiiri waranka (20) nda ka žigi kaŋ ŋuunuŋuunu ay ga, ");
INSERT INTO ses_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","šikka sii war si huru gandaa ra kaŋ ay nʼay kaboo jer ka žee ka war gorandi a ra. Kaleb, Yefune izʼaroo nda Žozuwe, Nun izʼaroo hinne no ma huru a ra. ");
INSERT INTO ses_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","War zanka kaccey kaŋ war nee kaŋ iberey gʼi dii, ay ga kate nda ey gandaa ra, i ga kaa ka gandaa bay kaŋ ga war wanji. ");
INSERT INTO ses_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Amma war, war kunturey ga kaŋ ka buu saajoo woo ra. ");
INSERT INTO ses_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","War izey ga tee kurkaw saajoo ra jiiri woytaaci (40), i ga war izefututaraa zaa hala waati kaŋ war kunturey kul kaŋ ka buu saajoo ra. ");
INSERT INTO ses_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Ka sawa nda jirbi hinnaa kaŋ war nʼa tee war ga gandaa monno, maanaa jirbi woytaaci (40), war ga war layboo zaa jiiri woytaaci (40), jiiri foo kul ga sawa nda zaari foo, woo ra war ga bay haya kaŋ ti ka wanji ay ga. ");
INSERT INTO ses_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Agay, Abadantaa kʼa har, takaa woo no ay gʼa tee jama laalaa woo kul se kaŋ yenje nda agay, i kul ga halaci saajoo woo ra i ga buu.”›» ");
INSERT INTO ses_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Arey kaŋ Musa nʼi sanba i ma koy gandaa monno, ngi yee kateyanoo ga, i na gandaa maa futaa har ka jamaa kul daŋ ŋuunuŋuunuyan ra. ");
INSERT INTO ses_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Borey kaŋ na gandaa maa futu har, Abadantaa na balaawu kʼi kar, i buu a jine. ");
INSERT INTO ses_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Žozuwe, Nun izʼaroo nda Kaleb, Yefune izʼaroo hinne ka cindi hundi ra arey ra kaŋ koy gandaa monno. ");
INSERT INTO ses_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Musa na šenney wey har Izirayel borey kul se, jamaa biney hanse ka maray. ");
INSERT INTO ses_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","I ga tun subbaahi biya ka žigi tondi hondoo boŋoo ga ka nee: «Nga ne, ir ga žigi ka koy nongoo ra kaŋ ga Abadantaa šelaŋ, zama ir na zunubu tee.» ");
INSERT INTO ses_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Musa nee: «Macin se war ga Abadantaa šenney hoo? Woo si haya kul hanse war se. ");
INSERT INTO ses_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","War masi žigi ka koy, zama Abadantaa sii war game. War masi koy naŋ war iberey ma war kar. ");
INSERT INTO ses_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Amalek borey nda Kanaŋ borey goo war jine, i ga war wii nda takuba, zama war hun Abadantaa bande, Abadantaa sii war bande.» ");
INSERT INTO ses_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","I fooma ka žigi tondi hondoo boŋoo boŋ, amma Abadantaa amaanaa sundukoo nda Musa mana hun jamaa kaloo game. ");
INSERT INTO ses_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Amalek borey nda Kanaŋ borey kaŋ ga goro tondi hondoo din boŋ zunbu kʼi kar kʼi gaaray hala Horma. ");
INSERT INTO ses_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","«Šelaŋ Izirayel borey se ka nee i se: ‹Nda war huru gandaa ra kaŋ ra war ga kaa ka goro kaŋ ay gʼa noo war se, ");
INSERT INTO ses_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","nda war ga sargari tonante kaa Abadantaa se, a ma tee sargari kukurante, wala meefur sargari, wala sargari kaŋ nʼnʼa kaa nda ni boŋ, wala jingarey sargari, a ma tee adabba wala alman buuna ra no nʼnʼa kaa hala a ma tee sunnaara hew kaana Abadantaa se: ");
INSERT INTO ses_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","boro kaŋ ga nga sargaroo kaa Abadantaa maaɲoo ga ma taasu sargari kar a ga kaŋ ti farin hamni kilo hinza kaŋ loobandi nda jii liitar foo nda jere, ");
INSERT INTO ses_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","nda alaneb hari moora sanda sargari hari-hari liitar foo nda jere, sargari kukurantaa nda feeji-ize foo kul kaŋ sargandi se. ");
INSERT INTO ses_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Nda gaaru no, ma farin hamni kilo iddu loobu nda jii liitar hinka kʼi tee taasu sargari kʼi kar a ga, ");
INSERT INTO ses_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","nda alaneb hari moora sargari hari-hari liitar hinka, a ma tee sunnaara kaana Abadantaa se. ");
INSERT INTO ses_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Nda yagaw no nʼnʼa kaa Abadantaa se sargari kukurante wala meefur sargari wala alaafiya teendi sargari, ");
INSERT INTO ses_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","war ga taasu sargari kaŋ ti farin hamni kilo yagga kaŋ loobandi nda jii liitar hinza daŋ yagaa bande, ");
INSERT INTO ses_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","nda alaneb hari moora liitar hinza sargari hari-hari tonton a ga. Sargari tonante no kaŋ sunnaaraa ga kan Abadantaa se. ");
INSERT INTO ses_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Woo no ma teendi yaaru foo kul se, nda gaaru foo kul se, nda feeji foo kul se, nda hancin foo kul se. ");
INSERT INTO ses_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Adabba hinna kul kaŋ war gʼa sarga, war ma woo tee affoo kul se, hinna kul kaŋ no. ");
INSERT INTO ses_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Ganda-ize kul ga sargari kaa nda takaa woo nda a na sargari tonante kaa kaŋ ga tee sunnaara kaana Abadantaa se. ");
INSERT INTO ses_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Nda yaw ga waati tee war do, wala boro goro war game zaman boobo, a ga sargari tonante kaa kaŋ sunnaaraa ga kan Abadantaa se, a mʼa tee nda takaa kaŋ nda war gʼa tee. ");
INSERT INTO ses_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Jamaa ra, ašariya folloku bande i ga hanga, war nda yawoo kaŋ ga waati tee war game, hantum kaŋ si tun no war alwaddawey ra, a ga ti a war nda yawoo se Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Ašariya foo nda hantum foo kaŋ kayandi bara war nda yawoo se kaŋ ga waati tee war game.›» ");
INSERT INTO ses_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","«Šelaŋ Izirayel borey se, nee i se: ‹Waati kaŋ war huru gandaa kaŋ ra ay ga war daŋ, ");
INSERT INTO ses_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","de war na gandaa ŋaahayaa ŋaa, war ma baa kaa Abadantaa se. ");
INSERT INTO ses_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Za laajinoo diibandi, war ma wijila jinaa tee ay bagaa, war mʼa kaa ya ne baa sanda takaa kaŋ nda baa ga hun ya ne taasu kar ganganoo ra. ");
INSERT INTO ses_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","War alwaddawey ra, war laajiney kul war ma wijila jinaa tee baa Abadantaa se.›» ");
INSERT INTO ses_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","«‹Nda war firka ka zunubu tee ka yaamarey kul hoo kaŋ Abadantaa nʼi har Musa se, ");
INSERT INTO ses_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","haya kul kaŋ Abadantaa nʼa har war se nda Musa miɲoo, za hanoo kaŋ Abadantaa na war noo yaamarey hala war alwaddawey ra. ");
INSERT INTO ses_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Nda haya no kaŋ jamaa moɲey mana dii a, a teendi firkayan ra, jamaa kul ga yagaw foo kaa sargari kukurante sanda sunnaara kaana Abadantaa se, nda nga taasu sargaroo, nda nga sargari hari-haroo ka sawa nda woo kaŋ ašariyaa nʼa kayandi, nda jindaaru foo zunubu sargaroo se. ");
INSERT INTO ses_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Sargari juwalkaa ga Izirayel borey jamaa kul zunubu tuusuyanoo tee, de i ga yaafandi, zama firkayan no, de mo i kate ngi sargaroo kaŋ ti sargari tonante Abadantaa se, nda ngi zunubu sargaroo Abadantaa se ngi firkayanoo maaganda. ");
INSERT INTO ses_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Izirayel borey jamaa kul nda yaw kaŋ ga waati tee i do kul ga yaafandi, zama firkayanoo zunbu jamaa kul ga. ");
INSERT INTO ses_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Nda boro folloku ka firka ka zunubu tee, a ma hancin kaŋ goo nda jiiri foo kaa zunubu sargari. ");
INSERT INTO ses_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Sargari juwalkaa ga zunubu tuusuyanoo tee boraa se kaŋ firka ka zunubu tee Abadantaa jine. Waati kaŋ zunubu tuusuyanoo teendi a se, a ga yaafandi. ");
INSERT INTO ses_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Ganda-ize Izirayel borey ra nda yaw kaŋ ga waati tee gamey ra, ašariya follokaa no boro se kaŋ firka. ");
INSERT INTO ses_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Amma boro kaŋ muray ka zunubu tee i ra na Abadantaa wow, a ma tee ganda-ize wala yaw, a ga hun nga jamaa ra. ");
INSERT INTO ses_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Zama a na Abadantaa šennoo kaynandi, a na nga yaamaroo hoo, boraa woo šikka sii a ga hun borey ra, nga layboo goo a ga.›» ");
INSERT INTO ses_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Waatoo kaŋ Izirayel borey goo saajoo ra, i na aru foo dii kaŋ ga tuuri kuuna hunanzamzaaroo hane. ");
INSERT INTO ses_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Borey kaŋ nʼa dii kate a Musa, nda Haruna, nda jamaa kul do. ");
INSERT INTO ses_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","I gaabu a ga, zama hayaa kaŋ i ga hima kʼa tee a se mana kayandi ka ben. ");
INSERT INTO ses_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Abadantaa nee Musa se: «Aroo woo šikka sii ga wiiyandi. Jamaa kul mʼa warra nda tondi kʼa wii jamaa kaloo se taray.» ");
INSERT INTO ses_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Jamaa kul nʼa ka koy jamaa kaloo se taray, i nʼa warra nda tondi, a buu sanda takaa kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","«Šelaŋ Izirayel borey se, nee i se kaŋ ngi alwaddawey ra i ma ngi bankaarawey miɲey buzu-buzandi, i ma karfu bula daŋ ngi bankaarawey miɲey buzu-buzey ga. ");
INSERT INTO ses_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","‹Buzu-buzu no war se, nda war dii a kul war ma hongu Abadantaa yaamarey kul kʼi ka dira. War si hanga bine-ibaayey nda moo-ibaayey kaŋyaŋ nda war ga izefututaray tee. ");
INSERT INTO ses_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Woo ra war ga hongu yaamarey kul, de war gʼi ka dira. Wa tee boro henananteyaŋ war Koyoo se. ");
INSERT INTO ses_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Agay ti Abadantaa, war Koyoo kaŋ na war fattandi Misira gandaa ra hala ya tee war se Irkoy. Agay ti Abadantaa, war Koyoo.›» ");
INSERT INTO ses_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Kora kaŋ ti Yisehar izʼaroo kaŋ ti Kehat izʼaroo kaŋ ti Lewi izʼaroo na Rubeŋ izʼaruyaŋ zaa kaŋ ti Dataŋ, nda Abiram kaŋyaŋ ti Eliyab izʼarey, nda On kaŋ ti Pelet izʼaroo, Rubeŋ hayroo no. ");
INSERT INTO ses_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","I ture Musa ga, ngi nda Izirayel borey ra aru zangu hinka nda woyguu (250), jamaa boŋkoyney no kaŋ jamaa nʼi suuba, i goo nda maa. ");
INSERT INTO ses_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","I marga ka tee mee foo Musa nda Haruna ga ka nee i se: «A wasa! Zama jamaa kul manʼti kala henananteyaŋ, de Abadantaa goo i game. Macin se war ga war boŋ jer beene Abadantaa jamaa se?» ");
INSERT INTO ses_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Kaŋ Musa maa woo, a kaŋ laboo ra nga boŋoo ga. ");
INSERT INTO ses_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","A šelaŋ Kora nda nga jamaa kul se ka nee: «Suba subbaahi Abadantaa ga bayrandi boro kaŋ ti nga wane nda boro kaŋ ga henan. A gʼa manandi nga. Boraa kaŋ a nʼa suuba, a gʼa manandi nga. ");
INSERT INTO ses_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Hayaa ne kaŋ war mʼa tee: Kora nda nga jamaa kul, wa dugu canbuyaŋ zaa. ");
INSERT INTO ses_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Suba war ma nuune daŋ i ra ka dugu daŋ i ra Abadantaa jine. Aroo kaŋ Abadantaa gʼa suuba, nga ti henanante. Lewi izʼarey, a wasa yaada.» ");
INSERT INTO ses_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Musa nee Kora se: «Lewi izʼarey, ay gʼa wiri war ga, war ma haŋajer. ");
INSERT INTO ses_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","A mana wasa war se kaŋ Izirayel Koyoo na war fay ka war kaa Izirayel jamaa ra, ka naŋ war ma man nga ka Abadantaa gorodogoo goyoo tee ka kay jamaa jine ka goy i se? ");
INSERT INTO ses_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","A naŋ war ma man nga, ni nda ni armey kul, Lewi izʼarey nda ni, de mo war ga sargari juwalkawtaraa ceeci. ");
INSERT INTO ses_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Woo se ni nda ni jamaa kul, war tee mee foo Abadantaa ga. Haruna ti may kaŋ ga war ga ŋuunuŋuunu?» ");
INSERT INTO ses_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Musa daŋ ka ciya Dataŋ nda Abiram kaŋ ti Eliyab izʼarey se. Amma i nee: «Ir si žigi ka koy. ");
INSERT INTO ses_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","A mana wasa ma ne mʼir kaa ganda kaŋ ra waa nda yuu ga tee hari ka koy ir wii saajoo ra? Kala ma tee ir boŋkoynoo mo? ");
INSERT INTO ses_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Nda cimi manʼti ganda kaŋ ra waa nda yuu ga tee hari ra nʼnʼir ka koy. Manʼir noo faariyaŋ nda alaneb faariyaŋ sanda tubuhaya. Ni mma baa ma borey wey moɲey danandi? Ir si žigi ka koy.» ");
INSERT INTO ses_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Musa hanse ka futu, a nee Abadantaa se: «Masi ngi sargaroo guna. Ay mana ba farka folloku dii i ga, ay mana ifutu tee ngi affoo kul se.» ");
INSERT INTO ses_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Musa nee Kora se: «Ni nda ni jamaa kul ma kaa Abadantaa jine suba, ni, nda ngey, nda Haruna. ");
INSERT INTO ses_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Boro foo kul ma nga dugu canboo zaa, a ma dugu daŋ a ra kʼa kaa sargari Abadantaa jine. A ga tee dugu canbu zangu hinka nda woyguu (250), takaa din da, ni nda Haruna, boro foo kul nda nga dugu canboo.» ");
INSERT INTO ses_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Boro foo kul na nga dugu canboo zaa, i na nuune daŋ i ra, i na dugu daŋ i ra, i koy kay cere kubayyan hukkumoo miɲoo ga Musa nda Haruna bande. ");
INSERT INTO ses_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Kora na jamaa kul marga i ma Musa nda Haruna gande cere kubayyan hukkumoo miɲoo ga. Abadantaa daržaa bangay jamaa kul se. ");
INSERT INTO ses_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Abadantaa šelaŋ Musa nda Haruna se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","«Wa fay nda jamaa woo, war ma hun i game, moomiti foo ay gʼi timmandi.» ");
INSERT INTO ses_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","I kaŋ laboo ra ngi boŋey ga, i nee: «Ya Irkoy, baahunantey kul hundey Koyoo, boro folloku ka zunubu tee, woo ga, nʼga futu jamaa kul ga wala?» ");
INSERT INTO ses_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","«Šelaŋ jamaa se ka nee: ‹Wa mooru nongoo kul here Kora, nda Dataŋ, nda Abiram gorodogey.›» ");
INSERT INTO ses_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Musa tun ka koy Dataŋ nda Abiram do, Izirayel boro beerey hanga a. ");
INSERT INTO ses_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","A šelaŋ jamaa se ka nee: «Ay gʼa wiri war ga, war ma mooru aru laaley wey hukkumey. Haya kul kaŋ ti ngi wane, war masi tuku a ga hala ngi zunubey masi koy koy nda war.» ");
INSERT INTO ses_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","I mooru nongoo kul here Kora, nda Dataŋ, nda Abiram gorodogey. Dataŋ nda Abiram fatta ka koy kay ngi hukkumey miɲey ga, ngi, nda ngi wandey, nda ngi izʼarey, nda ngi zanka kaccey. ");
INSERT INTO ses_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Musa nee: «Woo ra war ga bay kaŋ Abadantaa kʼay sanba ya teegoyey wey kul tee, ya nʼi tee nda ay bine-ibaayoo. ");
INSERT INTO ses_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Nda borey wey buu sanda takaa kaŋ nda adamizey kul ga buu, nda hayey kaŋ ga duu borey ga duu ngi mo, adiši manʼti Abadantaa kʼay sanba. ");
INSERT INTO ses_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Amma nda Abadantaa na kayfi tee kaŋ mana bay ka diyandi, nda laboo na nga miɲoo hay ka haya kul kaŋ ti ngi wane gon, de i ga zunbu alaahara i ga huna, woo ra war ga bay kaŋ borey wey na Abadantaa kaynandi.» ");
INSERT INTO ses_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Musa mma goo ma šenney wey har ka ben kaŋ laboo feeri i cire. ");
INSERT INTO ses_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Laboo na nga miɲoo feeri kʼi gon, ngi nda ngi hugey borey, nda Kora borey kul, nda ngi almanoo kul. ");
INSERT INTO ses_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","I ga huna i zunbu alaahara, ngi nda haya kul kaŋ ti ngi wane. Laboo nʼi daabu, i hun jamaa game. ");
INSERT INTO ses_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Izirayel borey kul kaŋ cindi kʼi kuubi kʼi bere zuru kaŋ i maa ngi kaatiyanoo, i nee: «Laboo masi koy gum ir boŋ.» ");
INSERT INTO ses_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Nuune hun Abadantaa do ka aru zangu hinka nda woyguwaa (250) ton kʼi tee boosu kaŋ goo ma dugoo sarga. ");
INSERT INTO ses_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«Nee Eleyazar, sargari juwalkaa Haruna izʼaroo se a ma dugu canbey kaa nuunaa ra, a ma koy nuunaa kaŋ goo i ra mun nongu mooro ra, zama canbey tee henananteyaŋ. ");
INSERT INTO ses_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Borey wey kaŋ na zunubu tee, hundey hun i ra, ngi dugu canbey ma tefayandi kʼi ka sargari tonadogoo daabu. Zama i nʼi sarga Abadantaa se, woo se i tee haya henananteyaŋ, woo se i ga tee tammaasa Izirayel borey se.» ");
INSERT INTO ses_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Sargari juwalkaa Eleyazar na alhan dugu canbey kaŋ borey kaŋ ton kate ey zaa, i nʼi tefayandi ka sargari tonadogoo daabu nda ey. ");
INSERT INTO ses_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Hongandiyan no Izirayel borey se, hala aru tana, maanaa kaŋ mana hun Haruna hayroo ra, masi kaa ka dugu dullandi Abadantaa jine ka tee sanda Kora nda nga jamaa cine, ka sawa nda woo kaŋ Abadantaa nee Musa mʼa har Haruna se. ");
INSERT INTO ses_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Subaa ra, Izirayel jamaa kul ŋuunuŋuunu Musa nda Haruna ga ka nee: «War no ka Abadantaa jamaa wii.» ");
INSERT INTO ses_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Kaŋ jamaa goo ma marga ka tee mee foo Musa nda Haruna ga, Musa nda Haruna bere cere kubayyan hukkumoo here. Nga ne, duulaa nʼa daabu, de Abadantaa daržaa bangay. ");
INSERT INTO ses_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Musa nda Haruna too kate cere kubayyan hukkumoo jine. ");
INSERT INTO ses_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","«Wa hun jamaa woo ra, moomiti foo ay gʼi timmandi!» I kaŋ laboo ra ngi boŋey ga. ");
INSERT INTO ses_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Musa nee Haruna se: «Dugu canboo zaa, nuune daŋ a ra kaŋ hun sargari tonadogoo ra, ma dugu daŋ a ra, ma cahã ka koy zunubu tuusuyanoo tee jamaa se, zama Abadantaa futuyanoo tun, bonaa šintin.» ");
INSERT INTO ses_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Haruna na dugu canboo zaa sanda takaa kaŋ nda Musa nʼa har, a zuru jamaa game, nga ne, bonaa šintin jamaa ra. A na dugu daŋ ka zunubu tuusuyanoo tee jamaa se. ");
INSERT INTO ses_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Haruna kay bukawey nda baahunantey game, bonaa kay. ");
INSERT INTO ses_vpl VALUES ("NU17_14","005_17_14","NUM","17","14","14","Borey kaŋ buu bonaa ra manʼti kala boro zenber woy cindi taaci nda zangu iyye (14.700) kaŋ sii wey kaŋ buu Kora wanoo ra. ");
INSERT INTO ses_vpl VALUES ("NU17_15","005_17_15","NUM","17","15","15","Haruna willi Musa jere cere kubayyan hukkumoo miɲoo ga. Bonaa kay. ");
INSERT INTO ses_vpl VALUES ("NU17_16","005_17_16","NUM","17","16","16","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU17_17","005_17_17","NUM","17","17","17","«Šelaŋ Izirayel borey se kaŋ ngi hugu foo kul i ma kate ma ne bundu foo, ngi boŋkoyney affoo kul ma kate ma ne bundu foo, hugu ka koy hugu, maana bundu woy cindi hinka (12). Ma boŋkoyni foo kul maaɲoo hantum nga bundoo ga. ");
INSERT INTO ses_vpl VALUES ("NU17_18","005_17_18","NUM","17","18","18","Ma Haruna maaɲoo hantum Lewi bundoo ga, zama hugu boŋ foo kul, bundu foo ti nga wane. ");
INSERT INTO ses_vpl VALUES ("NU17_19","005_17_19","NUM","17","19","19","Mʼi jisi cere kubayyan hukkumoo ra, seedetaraa sundukoo jine, nongoo kaŋ ra ay ga war kubay. ");
INSERT INTO ses_vpl VALUES ("NU17_20","005_17_20","NUM","17","20","20","Aroo kaŋ ay gʼa suuba bundoo no ma fita tee, woo no ay gʼa tee ka Izirayel borey ŋuunuŋuunuyanoo kaŋ i gʼa tee war se benandi.» ");
INSERT INTO ses_vpl VALUES ("NU17_21","005_17_21","NUM","17","21","21","Musa na šennoo har Izirayel borey se, ngi boŋkoyney kul nʼa noo bundu foo-foo, boŋkoyni foo kul bundu foo, hugu ka koy hugu, maana bundu woy cindi hinka (12). Haruna bundoo goo ngi bundey ra. ");
INSERT INTO ses_vpl VALUES ("NU17_22","005_17_22","NUM","17","22","22","Musa na bundey jisi Abadantaa jine seedetaraa hukkumoo ra. ");
INSERT INTO ses_vpl VALUES ("NU17_23","005_17_23","NUM","17","23","23","Subaa ra, kaŋ Musa huru seedetaraa hukkumoo ra, Haruna bundoo Lewi hugoo borey se zay ka fita tee, a boosu ka kutukuryayaŋ tee, ka ba amand izeyaŋ hay kaŋ nin. ");
INSERT INTO ses_vpl VALUES ("NU17_24","005_17_24","NUM","17","24","24","Musa na bundey kul kaa Abadantaa jine kʼi cebe Izirayel borey kul se. I dii ey, boro foo kul na nga bundoo zaa. ");
INSERT INTO ses_vpl VALUES ("NU17_25","005_17_25","NUM","17","25","25","Abadantaa nee Musa se: «Willi nda Haruna bundoo seedetaraa hukkumoo jine hala a ma tee turantey se hongandiyan. Woo ra nʼga ngi ŋuunuŋuunuyanoo benandi ay ga, i masi buu.» ");
INSERT INTO ses_vpl VALUES ("NU17_26","005_17_26","NUM","17","26","26","Musa nʼa tee. Hayaa kaŋ nda Abadantaa nʼa yaamar, a nʼa tee nda takaa din da. ");
INSERT INTO ses_vpl VALUES ("NU17_27","005_17_27","NUM","17","27","27","Izirayel borey nee Musa se: «Nga ne, a ben ir se, ir mursu, ir kul mursu, ");
INSERT INTO ses_vpl VALUES ("NU17_28","005_17_28","NUM","17","28","28","zama boro kul kaŋ man Abadantaa gorodogoo ga buu. Adiši ir kul no ma ben nda takaa woo wala?» ");
INSERT INTO ses_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Abadantaa nee Haruna se: «Ni, nda ni izʼarey, nda ni baabaa hugoo ni bande ga laybey zaa kaŋ teendi nongu henanantaa ga, amma ni nda ni izʼarey ni bande ga laybey zaa kaŋ teendi war sargari juwalkawtaraa here. ");
INSERT INTO ses_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Ma man, ni, nda ni armey, nda Lewi alkabiilaa, nda ni baabaa alkabiilaa hala i ma kara ni ga ka ni gaa ka goy. Ni nda ni izʼarey, war ma bara seedetaraa hukkumoo jine. ");
INSERT INTO ses_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","I ga ni goyoo tee, i ga hukkumoo kul goyoo tee, amma i si man nongu henanantaa jinawey, nda sargari tonadogoo, nga ra war si buu, ngi mo si buu. ");
INSERT INTO ses_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","I goo ni jere ka goyey tee, i ga cere kubayyan hukkumoo goyey kul tee. Boro tana kul si man war. ");
INSERT INTO ses_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","War ma kay nda nongu henanantaa goyey nda sargari tonadogoo goyey, woo ra futuyanoo si yee ka kaŋ Izirayel borey ga. ");
INSERT INTO ses_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Agay, nga ne, ay na war armey kaŋ ti Lewi borey zaa Izirayel borey ra, i nka tee nooyan kaŋ nondi Abadantaa se hala i ma cere kubayyan hukkumoo goyey tee. ");
INSERT INTO ses_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Ni nda ni izʼarey, war ga war sargari juwalkawtaraa goyoo tee haya kul kaŋ ti sargari tonadogoo here nda haya kul kaŋ goo ridowoo se kunehere, woo ti war goyoo. War sargari juwalkawtaraa ti goyoo kaŋ ay nʼa tee war se nooyan. Boro tana kaŋ man ma wiiyandi.» ");
INSERT INTO ses_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Abadantaa nee Haruna se: «Sargarey kaŋ ga nondi ya ne, nga ne, agay, ay na ni daŋ ma huga nda ey, ay gʼi noo ma ne. Izirayel borey sargari henanantey kaŋ i gʼi kaa ya ne, ay gʼi noo ni nda ni izʼarey se i ma tee war bagaa, yaamar no kaŋ si tun. ");
INSERT INTO ses_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Nga ne, woo kaŋ nʼga duu a hayey kaŋ hanse ka henan kaŋ mana tonandi ra ti: ngi sargarey kul, maanaa ngi taasu sargarey kul, nda ngi zunubu sargarey kul, nda ngi tooɲe sargarey kul kaŋ i gʼi kaa ya ne, ni nda ni izʼarey wane nda hayey wey kaŋ ga hanse ka henan. ");
INSERT INTO ses_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Ma hayey wey ŋaa sanda hayayaŋ kaŋ ga hanse ka henan. Aru kul ga hin kʼi ŋaa. I ga tee ma ne haya kaŋ ga henan. ");
INSERT INTO ses_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Hayey ne kaŋ ga tee ni wane koyne: Hayey kul kaŋ Izirayel borey gʼi noo, nda sargari zinji-zinjante kul, ay gʼi noo ma ne, ni, nda ni izʼarey, nda ni ize woyey ni bande, yaamar no kaŋ si tun. Ni hugoo boro kul kaŋ ga henan ga hin kʼa ŋaa. ");
INSERT INTO ses_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Hegaa ize jina-jinawey kaŋ i gʼi noo Abadantaa se, haya kul kaŋ ti i ra jii henna, nda alaneb hari henna, nda alkama henna, ay gʼi noo ma ne. ");
INSERT INTO ses_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Tuuri-ize jina-jinawey kaŋ ga hayandi ngi laboo ga kaŋ i gʼi kaa Abadantaa se ga tee ni wane. Ni hugoo boro kul kaŋ ga henan ga hin kʼi ŋaa. ");
INSERT INTO ses_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Haya kul kaŋ kayandi agay hinne se Izirayel ra ga tee ni wane. ");
INSERT INTO ses_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Woyey gunde jinawey kul, a ma tee adamizey ra wala adabbawey ra, woo kaŋ i nʼa kaa Abadantaa se ga tee ni wane. Amma borey gunde jinawey nda alman harramantey gunde jinawey, mʼi naŋ ka ngi hayoo taa. ");
INSERT INTO ses_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Wey kaŋ ga hima ka naŋandi, za i duu handu foo, ma ngi hayoo taa ka sawa nda hayoo kaŋ kayandi kaŋ nzorfu kaaray tamma boŋ guu ka sawa nda nongu henanantaa nzorfu kaaraa alkadaroo kaŋ affoo ga too garam woy cindi hinka (12). ");
INSERT INTO ses_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Amma hawey gunde jinaa, nda feejey gunde jinaa, nda hanciney gunde jinaa, masʼi naŋ, masi ngi hayoo taa, zama haya henananteyaŋ no. Ma ngi kuroo say-say sargari tonadogoo ga, ma ngi maanoo dullandi kʼa tee sargari tonante, a ma tee sunnaara kaana Abadantaa se. ");
INSERT INTO ses_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Ngi hamoo ga tee ni wane sanda gandoo kaŋ hun sargari zinji-zinjante ra nda cee gumaa. ");
INSERT INTO ses_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Sargarey kul kaŋ Izirayel borey gʼi kaa Abadantaa maaɲoo ga, ay gʼi noo ma ne, ni, nda ni izʼarey, nda ni ize woyey se ni bande sanda war baa abadantaa. Amaana ciiri-ciirante kaŋ si tun no ma ne Abadantaa jine ni nda ni hayroo se ni bande.» ");
INSERT INTO ses_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Abadantaa nee Haruna se: «Nʼsi duu nongu kul Izirayel borey gandaa ra, nʼsi duu i game baa. Agay ti ni bagaa nda ni tubuhayaa Izirayel borey game.» ");
INSERT INTO ses_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Nga ne, Lewi izʼarey ay nʼi noo Izirayel azakkaa kul sanda tubuhaya ngi goyoo kaŋ i gʼa tee maaganda se, cere kubayyan hukkumoo goyoo kaŋ i gʼa tee. ");
INSERT INTO ses_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Izirayel borey si yee ka man cere kubayyan hukkumoo i masi koy zunubu jeeje ngi boŋ ga ka buu. ");
INSERT INTO ses_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Lewi borey ga cere kubayyan hukkumoo goyoo tee, ngi no ma ngi layboo zaa. Hantum kaŋ si tun no war alwaddawey se. I si duu tubuhaya Izirayel borey game. ");
INSERT INTO ses_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Zama azakkaa kaŋ Izirayel borey gʼa kaa Abadantaa se, ay gʼa noo Lewi borey se sanda tubuhaya, woo se ay nee kaŋ i si duu tubuhaya Izirayel borey game. ");
INSERT INTO ses_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","«Šelaŋ Lewi borey se, nee i se: ‹Waati kaŋ war duu Izirayel borey hayey azakkaa kaŋ i gʼa kaa kaŋ ay gʼa noo war se sanda tubuhaya, war ga baa kaa Abadantaa se a ra kaŋ ti azakkaa azakkaa. ");
INSERT INTO ses_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Bagaa woo ga sawa nda Izirayel borey wanoo kaŋ i gʼa kaa attamoo ra kaŋ goo taasu kar ganganoo ra, nda alaneb hari kaŋ ga hun alaneb-ize mottidogoo ra. ");
INSERT INTO ses_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Takaa follokaa da azakkawey kaŋ hun Izirayel borey hayey, war mo, war ma baa kaa a ra kʼa noo Abadantaa se. Woo kaŋ war gʼa kaa Abadantaa se si nondi kala sargari juwalkaa Haruna se. ");
INSERT INTO ses_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Haya kul kaŋ nondi war se, war ma haya timmantaa kaa a ra kʼa noo Abadantaa se nga bagaa. Hayey kul ihenney, war mʼi daŋ jere ga a se.›» ");
INSERT INTO ses_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","«Ma nee i se koyne: ‹Nda war na haya kul ihennaa kaa Abadantaa se, woo kaŋ ga cindi ga tee war wane sanda woo kaŋ hun taasu kar ganganoo ra nda alaneb-ize mottidogoo ra. ");
INSERT INTO ses_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","War ga hin kʼa ŋaa nongu kul ra, war nda war hugoo borey. War banaa no goyoo kaŋ war gʼa tee cere kubayyan hukkumoo ra maaganda. ");
INSERT INTO ses_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Zunubu si huru war ga nda war na ihenney kaa, war si Izirayel borey sargari henanantey kaynandi, war si buu.›» ");
INSERT INTO ses_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Abadantaa šelaŋ Musa nda Haruna se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","«Hayaa ne kaŋ hantumandi ašariyaa ra kaŋ Abadantaa nʼa yaamar. Nee Izirayel borey se i ma kate ma ne haw woy ciray kaŋ ga timme, malal sii a ga, tiŋay-zaa-bundu mana bay ka huru a ga. ");
INSERT INTO ses_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","War mʼa noo sargari juwalkaa Eleyazar se, a gʼa ka fatta jamaa kaloo ra, i gʼa koosu Eleyazar jinoo ra. ");
INSERT INTO ses_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Sargari juwalkaa Eleyazar ga nga kabe-izoo ka zaa kuroo ra, a ga kuroo say-say cee iyye cere kubayyan hukkumoo jineheroo here. ");
INSERT INTO ses_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Haw woyoo ga tonandi jinoo ra. I ga kuuroo, nda hamoo, nda kuroo, nda žiiboo ton. ");
INSERT INTO ses_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Sargari juwalkaa ga sedere bundu zaa, nda izopu bundu, nda šilli ciray zaram, a gʼi warra nuunaa ra kaŋ ga hawoo ton. ");
INSERT INTO ses_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Sargari juwalkaa ga nga bankaarawey nda nga gaahamoo ɲumay nda hari jina, woo banda ga, a ga hin ka huru jamaa kaloo ra. Sargari juwalkaa ga žiibi hala almaaroo ra. ");
INSERT INTO ses_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Boraa kaŋ na haw woyoo ton ga nga bankaarawey nda gaahamoo ɲumay nda hari. A ga žiibi hala almaaroo ra. ");
INSERT INTO ses_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Boro kaŋ ga henan ga hawoo boosoo kuuna ka koy a mun jamaa kaloo se taray nongu henanante ra. A ga jisandi Izirayel borey jamaa se henanandiyan haroo maaganda. Zunubu sargari no. ");
INSERT INTO ses_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Boraa kaŋ na hawoo boosoo kuuna ga nga bankaarawey ɲumay, a ga žiibi hala almaaroo ra. Hantum kaŋ si tun no Izirayel borey nda yaw kaŋ ga waati tee i do se.» ");
INSERT INTO ses_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","«Boro kul kaŋ tuku bukaw ga, adamize bukaw kul kaŋ no, boraa ga žiibi jirbi iyye. ");
INSERT INTO ses_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","A ga nga zunuboo kaa nda henanandiyanoo haroo jirbi hinzantoo nda iyyantoo hane, woo banda ga, a ga henan. Nda a mana nga zunuboo kaa jirbi hinzantoo nda iyyantoo hane, a si henan. ");
INSERT INTO ses_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Boro kaŋ tuku bukaw ga, adamize bukaw, de a mana nga zunuboo kaa, boraa na Abadantaa gorodogoo žiibandi, a ga hun Izirayel jamaa ra. Haya kaŋ se henanandiyan haroo mana say-sayandi a ga, a ga žiibi. Nga žiiboo ga cindi a ga. ");
INSERT INTO ses_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Ašariya foo ne, nda boro buu hukkum ra: boro kul kaŋ huru hukkumoo ra nda boro kul kaŋ goo a ra ga žiibi jirbi iyye. ");
INSERT INTO ses_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Jinay kul kaŋ goo a ra kaŋ miɲoo ga feeri, daabirji sʼa dii ka boori, ga žiibi. ");
INSERT INTO ses_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Boro kul kaŋ tuku bukaw ga saajoo ra, a ma tee takuba kʼa wii wala a nka buu nda nga boŋ, wala a tuku adamize biriyaŋ ga, wala saaray ga, boraa ga žiibi jirbi iyye. ");
INSERT INTO ses_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Boraa kaŋ na nga boŋ žiibandi, i ga zaa a se zunubu sargaroo kaŋ tonandi boosoo ra kʼa daŋ jinay ra ka hari henna fur a boŋ. ");
INSERT INTO ses_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Boro kaŋ ga henan ga izopu bundu zaa kʼa sufa haroo ra, a gʼa say-say hukkumoo ga, nda jinawey kul ga nda borey kaŋ goo no ga, nda boraa kaŋ tuku boro kaŋ i nʼa wii ga wala a nka buu nda nga boŋ birey ga, wala saaray ga. ");
INSERT INTO ses_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Boraa kaŋ ga henan ga haroo say-say boraa kaŋ ga žiibi ga jirbi hinzantoo nda jirbi iyyantoo hane, a ga zunubu kaa jirbi iyyantoo hane. A ma nga bankaarawey ɲumandi, a ma nga boŋ ɲumay nda hari. Almaaroo ra, a ga henan. ");
INSERT INTO ses_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Boro kaŋ ga žiibi, de a mana nga zunuboo kaa ga hun jamaa ra, zama a nka Abadantaa nongu henanantaa žiibandi. Haya kaŋ se henanandiyan haroo mana say-sayandi a ga, a ga žiibi. ");
INSERT INTO ses_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Hantum kaŋ si tun no Izirayel borey se. Boraa kaŋ na henanandiyan haroo say-say ga nga bankaarawey ɲumandi. Boro kaŋ tuku henanandiyan haroo ga, ga žiibi hala almaaroo ra. ");
INSERT INTO ses_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Haya kul kaŋ ga boro žiibaa tuku ga žiibi. Boro kaŋ tuku boro žiibaa ga, ga žiibi hala almaaroo ra.» ");
INSERT INTO ses_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Izirayel borey jamaa kul too Tisin saajoo ra handu jinaa, jamaa goro Kadeš. No din ra Maryama buu, no din ra a suturandi. ");
INSERT INTO ses_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Hari sii no jamaa se, borey marga ka tee mee foo Musa nda Haruna ga. ");
INSERT INTO ses_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Jamaa na yenje ceeci Musa ga. I nee: «Jalla, nda a gar ba ir nka buu waatoo kaŋ ir armey buu Abadantaa jine! ");
INSERT INTO ses_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Cin se war kate Abadantaa jamaa saajoo woo ra, hala ir ma buu a ra, ir nda ir jawdey? ");
INSERT INTO ses_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Cin ka kate war nʼir žigandi ka hun Misira, hala ir ma kaa nongu laalaa woo ra? Manʼti nongu no kaŋ ra ir ga hin ka beeri, jeejayɲaa sii no, alanebɲaa sii no, grenadɲaa sii no, ba haŋ hari sii no.» ");
INSERT INTO ses_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Musa nda Haruna mooru jamaa ka koy cere kubayyan hukkumoo miɲoo ga. I kaŋ laboo ra ngi boŋey ga, de Irkoy daržaa bangay i se. ");
INSERT INTO ses_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","«Goboo zaa ma jamaa marga, ni nda Haruna, ni armaa. War ma šelaŋ tondoo se jiney ra, tondoo ga nga haroo doori. Ma hari fattandi i se tondoo ra, ma jamaa nda ngi jawdoo haŋandi.» ");
INSERT INTO ses_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Musa na goboo zaa kaŋ goo Abadantaa jine, sanda takaa kaŋ nda a nʼa yaamar. ");
INSERT INTO ses_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Musa nda Haruna na jamaa marga tondoo tenje. Musa nee i se: «Ay gʼa wiri war ga, wa haŋajer, turantey. Tondoo woo ra ir ga hari kaa war se wala?» ");
INSERT INTO ses_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Woo banda ga, Musa na nga kaboo jer ka tondoo kar nda nga goboo cee hinka. Hari boobo fatta, jamaa nda ngi jawdey haŋ. ");
INSERT INTO ses_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Abadantaa nee Musa nda Haruna se: «Hayaa kaŋ se war mana naanay agay kʼay henanyanoo cebe Izirayel borey se, war si jamaa woo daŋ gandaa ra kaŋ ay nʼa noo i se.» ");
INSERT INTO ses_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Nga ti Meriba (maanaa «yenje») haroo kaŋ ra Izirayel borey na yenje ceeci Abadantaa ga kaŋ na nga henanyanoo cebe i game. ");
INSERT INTO ses_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Musa na dontokawyaŋ sanba ka hun Kadeš ka koy Edom kokoyoo do, i ma nee a se: «Ni armaa Izirayel nee: ‹Nʼga šendawey kul bay kaŋ duu ir. ");
INSERT INTO ses_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Ir baabey doo Misira, ir goro no din waati kuku. Misira borey nʼir žilla, ir nda ir baabey. ");
INSERT INTO ses_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Ir kaati ka Abadantaa cee, a na haŋajer ir jindey se, a na almalayka sanba kʼir kaa Misira. Ir ne Kadeš kaŋ ti koyra kaŋ goo ni gandaa benantaa ga. ");
INSERT INTO ses_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Ir gʼa wiri ni ga, naŋ ir ma bisa nda ni gandaa, ir si bisa nda faarey, ir si bisa nda alaneb faarey, ir si dayey harey haŋ. Ir ga hanga kokoyoo fondaa, ir si šiiri ka koy kabe guma here wala kabe waawa here hala ir ma bisa ni gandaa ga.›» ");
INSERT INTO ses_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Edom nee a se: «Nʼsi bisa nda ay do, nda manʼti woo, ay ga fatta ka ni kubay nda takuba.» ");
INSERT INTO ses_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Izirayel borey nee a se: «Ir ga žigi ka koy nda fondo beeroo, nda agay nda ay adabbawey haŋ ni haroo ra, ay ga nga hayoo bana. Manʼti haya foo no, ya mma baa de ya bisa hinne.» ");
INSERT INTO ses_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","A nee: «Nʼsi bisa.» Woo banda ga, Edom fatta ka Izirayel borey kubay nda wongu-ize boobo nda gaabi. ");
INSERT INTO ses_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Takaa woo nda Edom wanji Izirayel borey ma bisa nga gandaa laboo ra. Izirayel borey na fondo tana zaa. ");
INSERT INTO ses_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Izirayel borey hun Kadeš, jamaa kul kaa Hor tondi hondoo do. ");
INSERT INTO ses_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Abadantaa nee Musa nda Haruna se Hor tondi hondoo do, nongoo kaŋ ga nga nda Edom gandaa ka fay: ");
INSERT INTO ses_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","«Haruna ga koy nga hayragey gar alaahara, a si huru gandaa ra kaŋ ay nʼa noo Izirayel borey se, zama war ture ay yaamaroo ga Meriba haroo do. ");
INSERT INTO ses_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Haruna nda nga izʼaroo Eleyazar zaa mʼi ka žigi Hor tondi hondoo ga. ");
INSERT INTO ses_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Haruna bankaarawey kaa a ga, mʼi daŋ nga izʼaroo Eleyazar ga. Haruna ga koy nga hayragey gar alaahara, no din ra a ga buu.» ");
INSERT INTO ses_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Musa na hayaa tee kaŋ nda Abadantaa nʼa yaamar. I žigi Hor tondi hondoo ga jamaa kul jine. ");
INSERT INTO ses_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Musa na Haruna darbawey kaa a ga kʼi daŋ nga izʼaroo Eleyazar ga. Haruna buu no din da tondi hondoo boŋoo boŋ. Woo banda ga, Musa nda Eleyazar zunbu ka hun tondi hondoo boŋ. ");
INSERT INTO ses_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Jamaa kul dii kaŋ Haruna hundoo hun, Izirayel hugoo borey kul na Haruna hẽe jirbi waranza (30). ");
INSERT INTO ses_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Arad koyraa kokoyoo kaŋ ti Kanaŋ boro kaŋ ga goro Negew maa kaŋ Izirayel borey goo ma kaa nda Atarim fondaa here. A na Izirayel borey wongu, a na affooyaŋ daŋ baɲɲataray. ");
INSERT INTO ses_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Izirayel na allaahidu zaa Abadantaa se, i nee: «Nda nʼna jamaa woo daŋ ir kabey ra, ir ga ngi koyrawey halaci sõy.» ");
INSERT INTO ses_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Abadantaa na haŋajer Izirayel šennoo se, a na Kanaŋ borey daŋ kabey ra. I na ngi nda ngi koyrawey halaci sõy, de i na nongoo maaɲoo daŋ Horma (maanaa «halaci sõy»). ");
INSERT INTO ses_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","I hun Hor tondi hondoo do ka Kakaarey teekoo fondaa zaa ka Edom gandaa kuubi. Fondaa ra, jamaa biney hun. ");
INSERT INTO ses_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","I šelaŋ Irkoy nda Musa ga ka nee: «Cin se war gʼir žigandi ka hun Misira? Hala ir ma buu saajoo woo ra wala? Zama ŋaayan sii ne, hari sii ne, ir biney hun nda ŋaayan takaa-takaa woo.» ");
INSERT INTO ses_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Woo ga, Abadantaa na gondi naajikoyniyaŋ sanba jamaa ga. I na jamaa ɲama, de boro boobo buu Izirayel jamaa ra. ");
INSERT INTO ses_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Jamaa kaa Musa do ka nee: «Ir na zunubu tee ka šelaŋ Abadantaa ga, ka šelaŋ ni ga. Abadantaa ŋaaray hala a ma gondey moorandi ir.» Musa na Irkoy ŋaaray jamaa se. ");
INSERT INTO ses_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Abadantaa nee Musa se: «Gondi naajikoyni tee, mʼa jer bundu ga, boro kul kaŋ gondi nʼa ɲama, nda a nʼa guna, koyoo ga huna.» ");
INSERT INTO ses_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Musa na alhan gondi tee kʼa daŋ bundoo ga. Boro kaŋ gondi nʼa ɲama, de a na alhan gondoo guna, koyoo ga huna. ");
INSERT INTO ses_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Izirayel borey koy, i goro Obot. ");
INSERT INTO ses_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","I hun Obot ka koy goro Iye-Abarim, saajoo ra kaŋ ga tenje Mowab, waynahunay here. ");
INSERT INTO ses_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","I hun no din ka koy goro Zered gooroo ra. ");
INSERT INTO ses_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","I hun no din ka koy goro Arnoŋ isaa jere foo here kaŋ ga bisa saajoo ra ka hun Amor borey laboo ga, zama Arnoŋ ti Mowab gandaa hirri foo kaŋ goo Mowab nda Amor borey game. ");
INSERT INTO ses_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Woo maaganda se Abadantaa wongey citaaboo ra i ga nee: «Waheb kaŋ goo Sufa gandaa ra, nda Arnoŋ isaa harey, ");
INSERT INTO ses_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","nda haroo kaŋ hun ka koy Ar laboo here ka koy jeesi Mowab gandaa hirroo ga.» ");
INSERT INTO ses_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","I hun no din ka koy Ber (maanaa «day»), no din ra dayoo goo kaŋ ga Abadantaa nee Musa se: «Jamaa marga, ay gʼi noo hari.» ");
INSERT INTO ses_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Woo se Izirayel don ka nee: «Dayoo, hari fattandi! Wa don a se! ");
INSERT INTO ses_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Day kaŋ boŋkoyney nʼa fanši, jamaa boro kayantey nʼa fanši nda ngi laamaa gobey, nda ngi gobey!» I hun saajoo ra ka koy Matana, ");
INSERT INTO ses_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","i hun Matana ka koy Nahaliyel, i hun Nahaliyel ka koy Bamot, ");
INSERT INTO ses_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","i hun Bamot ka koy sosooroo ra kaŋ goo Mowab gandaa ra, Pisiga tondi hondoo boŋoo jeroo ga kaŋ ga boro ga saajoo honnay. ");
INSERT INTO ses_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Izirayel borey na dontokawyaŋ sanba Sihoŋ kaŋ ti Amor borey kokoyoo do ka nee a se: ");
INSERT INTO ses_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","«Naŋ ya bisa nda ni gandaa. Ir si hun fondaa ra ka bisa nda faarey, ir si bisa nda alaneb faarey, ir si dayey harey haŋ. Ir ga hanga kokoyoo fondaa hala ir ma bisa ni gandaa ra.» ");
INSERT INTO ses_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Sihoŋ mana yadda Izirayel borey ma bisa nda nga gandaa laboo. Sihoŋ na nga jamaa kul marga ka koy Izirayel kubay saajoo ra, a too Yahas, no din ra i na Izirayel wongu. ");
INSERT INTO ses_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Izirayel nʼa kar kʼa wii nda takuba ka ngi gandaa taa, kʼa dii za Arnoŋ isaa hala Yabok isaa ka koy Amoŋ borey gandaa hirroo ga, zama Amoŋ borey gandaa hirroo nka cinandi nda cete. ");
INSERT INTO ses_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Izirayel goro Amor borey koyrawey ra, i goro ba Hešboŋ koyraa nda nga koyra kanbey kul. ");
INSERT INTO ses_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Hešboŋ manʼti kala Sihoŋ kaŋ ti Amor borey kokoyoo koyraa. Nga no ka Mowab kokoyoo kaŋ goo no cee jinaa wongu, a na nga gandaa kul taa a kone hala Arnoŋ isaa do. ");
INSERT INTO ses_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Woo se donkey ga nee: «Wa kaa Hešboŋ! Sihoŋ koyraa ma cinandi ka kay, ");
INSERT INTO ses_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","zama nuune fatta Hešboŋ, nuune deeneyaŋ hun Sihoŋ koyraa ra, a na Ar koyraa kaŋ goo Mowab gon, Arnoŋ isaa hodaddawey jineborey. ");
INSERT INTO ses_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Ni bone, Mowab, Kemoš jamaa, ni dere! A na nga izʼarey tee cindiyaŋ, a na nga ize woyey daŋ koŋŋataray Sihoŋ se kaŋ ti Amor borey kokoyoo. ");
INSERT INTO ses_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Ir nʼi hay nda biraw, Hešboŋ halaci hala Diboŋ. Ir na hasaraw tee i se hala Nofa kaŋ ga too Medeba.» ");
INSERT INTO ses_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Takaa woo nda Izirayel goro Amor borey gandaa ra. ");
INSERT INTO ses_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Musa na boroyaŋ sanba i ma Yazer koyraa guna. Woo banda ga, i na nga koyra kanbey dii. Amor borey kaŋ goo no din, i nʼi gaaray kʼi kaa no. ");
INSERT INTO ses_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","I bere ka žigi ka koy nda Bašaŋ gandaa fondaa. Og kaŋ ti Bašaŋ kokoyoo, nga nda nga jamaa kul kʼi kubay kʼi wongu Edreyi. ");
INSERT INTO ses_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Abadantaa nee Musa se: «Masi hunbur a, ay nʼa daŋ ni kaboo ra, nga, nda nga jamaa kul, nda nga gandaa. Ma hayaa tee a se kaŋ nʼnʼa tee Sihoŋ se kaŋ ti Amor borey kokoyoo kaŋ goro Hešboŋ.» ");
INSERT INTO ses_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","I nʼa kar, nga, nda nga izʼarey, nda nga jamaa kul, i mana baahunante kul naŋ a se. I na nga gandaa dii. ");
INSERT INTO ses_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Izirayel borey, i koy goro Mowab ganganey ra kaŋ goo Žurdeŋ isaa banda ga, Žeriko tenje. ");
INSERT INTO ses_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Balak, Sipor izʼaroo dii hayaa kul kaŋ Izirayel borey nʼa tee Amor borey se. ");
INSERT INTO ses_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Mowab borey hanse ka hunbur jamaa jine, zama i ga hanse ka boobo. Mowab borey jijiri nda hunburay Izirayel borey jine. ");
INSERT INTO ses_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Mowab nee Majaŋ boro beerey se: «Sohõ jamaa woo ga hayaa kul kaama kaŋ gʼir kuubi kʼir bere, sanda takaa kaŋ nda haw ga hawsaa suboo kaama. Balak, Sipor izʼaroo ti Mowab kokoyoo waatoo din. ");
INSERT INTO ses_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","A na dontokawyaŋ sanba Balam kaŋ ti Bewor izʼaroo do Petor koyraa ra kaŋ goo Efrat isaa jere, nga gandaa ra ka ciya a se. A nee i ma nee a se: ‹Jamaa foo goo ne kaŋ hun Misira, nga ne, a na gandaa too, a goro ay tenje. ");
INSERT INTO ses_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Sohõ kaa, ay gʼa wiri ni ga, jamaa woo danga ya ne, zama i ga hin agay. A ga hin ka tee woo ra ya hin kʼi kar kʼi fattandi gandaa ra, zama ay ga bay kaŋ boro kaŋ se ni gaara, tee albarkante, boro kaŋ nʼnʼa danga, laali.›» ");
INSERT INTO ses_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Mowab boro beerey nda Majaŋ gandaa boro beerey tun ka koy nda ngi bande gomniyaŋ gunandikaa se. I too Balam do ka Balak šenney har a se. ");
INSERT INTO ses_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balam nee i se: «Wa cijinoo tee ne ra, ay ga war noo zaabi, zaaboo kaŋ Abadantaa gʼa har ya ne.» Mowab boŋkoyney cindi a do. ");
INSERT INTO ses_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Irkoy kaa Balam do, a nee: «May ti borey wey kaŋ goo ni do?» ");
INSERT INTO ses_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balam nee Irkoy se: «Sipor kaŋ ti Mowab kokoyoo izʼaroo kaŋ se i ga nee Balak kʼi sanba ay do i ma nee: ");
INSERT INTO ses_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‹Nga ne, jamaa kaŋ hun Misira na gandaa too, sohõ kaa kʼi danga ya ne, a ga hin ka tee yʼi wongu kʼi gaaray.›» ");
INSERT INTO ses_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Irkoy nee Balam se: «Masi koy i bande, masi jamaa din danga, zama albarkanteyaŋ no.» ");
INSERT INTO ses_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Balam tun subbaahoo ra, a nee Balak boŋkoyney se: «Wa koy war gandaa ra, zama Abadantaa wanji ya hanga war.» ");
INSERT INTO ses_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Mowab boŋkoyney koy Balak gar ka nee: «Balam wanji ka kaa ir bande.» ");
INSERT INTO ses_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balak yee koyne ka boŋkoyniyaŋ sanba kaŋyaŋ boobo nda cee jinaa waney i goo nda maa nda ey. ");
INSERT INTO ses_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","I too Balam do ka nee a se: «Balak, Sipor izʼaroo nee: ‹Ay gʼa wiri ni ga, haya kul masi ni ganji ma kaa ay do. ");
INSERT INTO ses_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Zama ay na beeray jisi ma ne, de mo haya kul kaŋ nʼnʼa har, ay gʼa tee. Kaa, ay gʼa wiri ni ga, jamaa woo danga ya ne.›» ");
INSERT INTO ses_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Balam na Balak tamey zaabi ka nee: «Ba nda Balak nʼay noo nga hugoo mee foo nzorfu kaaray nda wura, ay si hin ka Abadantaa, ay Koyoo šennoo hoo ka haya kaccu wala ibeeri tee. ");
INSERT INTO ses_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Sohõ ay gʼa wiri war ga, war mo ma cindi ne hõ cijinoo hala ya hayaa bay kaŋ Abadantaa gʼa har ya ne koyne.» ");
INSERT INTO ses_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Irkoy kaa Balam do cijinoo ra, a nee a se: «Nda arey wey nka kaa ka ni cee, koy ma hanga ey. Amma hayaa hinne kaŋ ay nʼa har ma ne no nʼgʼa tee.» ");
INSERT INTO ses_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balam tun subbaahoo ra, a na nga farka woyoo soolu, a koy Mowab boŋkoyney bande. ");
INSERT INTO ses_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Irkoy futu, zama Balam koy. Abadantaa almalaykaa kay fondaa ra kʼa gagay. Balam žigi nga farka woyoo ga, nga tam hinkaa goo a bande. ");
INSERT INTO ses_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Farka woyoo dii Abadantaa almalaykaa ga kay fondaa ra, a na nga takubaa hoobu kʼa dii kaboo ra. Farkaa na fondaa naŋ ka koy faarey ra. Balam na farkaa kar kʼa daŋ fondaa ra. ");
INSERT INTO ses_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Abadantaa almalaykaa kay fondo šiita ra kaŋ goo alaneb faarey game. Cete goo caraw hinkaa kul ga. ");
INSERT INTO ses_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Waatoo kaŋ farkaa dii Abadantaa almalaykaa, a na nga boŋ naagu cetaa ga ka Balam cewoo naagu cetaa ga. A yee koyne kʼa kar. ");
INSERT INTO ses_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Abadantaa almalaykaa koy jine koyne ka huru nongu kaŋ ra fondo sii ka bisa nda kabe guma wala iwaawa here. ");
INSERT INTO ses_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Waatoo kaŋ farkaa dii Abadantaa almalaykaa, a kani Balam cire. Balam futu, a na farkaa kar nda nga goboo. ");
INSERT INTO ses_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Abadantaa na farkaa šelaŋandi, farkaa nee Balam se: «Macin no ay nʼa tee ma ne kaŋ se nʼgʼay kar cee hinza?» ");
INSERT INTO ses_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balam na farkaa zaabi ka nee: «Ni mmʼay ɲooɲo, nda a gar takuba mma bara ay kaboo ra, šikka sii sohõ gar ay na ni wii.» ");
INSERT INTO ses_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Farkaa nee Balam se: «Manʼti ni farkaa ti agay kaŋ ga nʼga žigi waati kul hala hõ? Ay doona ka takaa woo tee ma ne wala?» A nee: «Kalaa». ");
INSERT INTO ses_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Woo banda ga, Abadantaa na Balam moɲey feeri. A dii Abadantaa almalaykaa ga kay fondaa ra, nga takubaa hoobandi, a goo kaboo ra, Balam gunguma ka sujudu hala ganda. ");
INSERT INTO ses_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Abadantaa almalaykaa nee a se: «Macin se nʼna ni farkaa kar cee hinza? Nga ne, agay ka fatta ka ni gagay, zama ay dii kaŋ naarumaa woo kaŋ ra ni goo, halaciyan fondo no. ");
INSERT INTO ses_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Farkaa dii agay, a hibi ay ga cee hinza. Nda a gar a nka mana hibi ay ga, ni no ay ga ni wii, nga, ay gʼa naŋ a ma huna.» ");
INSERT INTO ses_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balam nee Abadantaa almalaykaa se: «Ay na zunubu tee, ya na bay wala ni mma kay fondaa ra kʼay batu. Sohõ nda haya ti woo kaŋ si kan ma ne, ay ga yee.» ");
INSERT INTO ses_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Abadantaa almalaykaa nee Balam se: «Ni nda arey wey ma koy, amma hayaa hinne kaŋ ay gʼa har ma ne no nʼgʼa har.» Balam koy nda Balak boŋkoyney. ");
INSERT INTO ses_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balak maa kaŋ Balam kaa, a fatta ka koy a kubay hala Mowab koyraa ra kaŋ goo Arnoŋ isaa hirroo do, nga laboo se jine. ");
INSERT INTO ses_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balak nee Balam se: «Manʼti agay ka sanba ka ciya ma ne, macin se mana cahã ka kaa? Nʼga hongu, ya nka si hin ka beeray tee ma ne?» ");
INSERT INTO ses_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balam nee Balak se: «Nga ne, ay kaa ka dii ni, sohõ ay ga hin ka haya har kaŋ ay baa wala? Ay ga šennoo har kaŋ Irkoy nʼa daŋ ay miɲoo ra.» ");
INSERT INTO ses_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Balam koy Balak bande, i too Kiryat-Husot. ");
INSERT INTO ses_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balak na alman beeri nda ibuuna kaa sargari, a sanba i ra Balam nda boŋkoyney kaŋ goo a bande se. ");
INSERT INTO ses_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Suba subbaahoo ra, Balak na Balam zaa ka žigi ka koy Bamot-Bal, no din ra a dii Izirayel jamaa jere foo. ");
INSERT INTO ses_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balam nee Balak se: «Sargari tonadoo iyye cin ya ne, ne ra, ma yaaru kobsi iyye nda gaaru boŋ iyye soolu ya ne.» ");
INSERT INTO ses_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak na hayaa tee kaŋ Balam nʼa har. Balak nda Balam na yaaru foo nda gaaru foo kaa sargari, sargari tonadoo foo kul boŋ. ");
INSERT INTO ses_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Balam nee Balak se: «Kay ni sargari kukurantaa jere, ay ga hibi, a ga hin ka tee Abadantaa ma kaa kʼay kubay. Ay ga hayaa har ma ne kaŋ a nʼa cebe ya ne.» A koy hondu foo boŋ. ");
INSERT INTO ses_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Irkoy na Balam kubay, Balam nee a se: «Ay na sargari tonadoo iyyaa kayandi, ay na yaaru foo nda gaaru foo kaa sargari, sargari tonadoo foo kul ga.» ");
INSERT INTO ses_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Abadantaa na šenni foo daŋ Balam miɲoo ra, a nee a se: «Yee Balak do ka šelaŋ a se nda takaa woo.» ");
INSERT INTO ses_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Balam yee Balak do, a nʼa gar a ga kay nga sargari kukurantaa jere, nga nda Mowab boŋkoyney kul. ");
INSERT INTO ses_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Balam na nga yaasay šennoo har ka nee: «Balak nʼay ka hun Siiri gandaa ra, Mowab kokoyoo nʼay ka hun waynahunay tondi hondey do, a nee: ‹Kaa ka Yakuba danga ya ne, kaa ka futu Izirayel ga.› ");
INSERT INTO ses_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Taka foo nda ay ga boro danga kaŋ Irkoy manʼa laali? Taka foo nda ay ga futu boro ga kaŋ Abadantaa mana futu a ga? ");
INSERT INTO ses_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Ay goo tondey boŋ ay ga dii a, ay goo hondey boŋ ay gʼa honnay. Nga ne, jamaa no kaŋ gorodogoo goo jere ga, de mo a si nga boŋ daŋ gandawey ra. ");
INSERT INTO ses_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","May no ma hin ka Yakuba kaŋ ga hima nda labutaasi kabu, ka ba Izirayel zamna taacaa affoo hinnaa har? Yala ya buu nda takaa kaŋ nda boro šerrantey ga buu, yala ay kokoroo ma hima nda ngi wanoo.» ");
INSERT INTO ses_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balak nee Balam se: «Cin ti woo kaŋ nʼnʼa tee ya ne? Ay kate ni hala ma agay iberey danga, amma nga ne, ni nka gaara i se!» ");
INSERT INTO ses_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Balam nʼa zaabi ka nee: «Ay si hima ka hawgay ka hayaa har kaŋ Abadantaa nʼa daŋ ay miɲoo ra wala?» ");
INSERT INTO ses_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balak nee a se: «Ay gʼa wiri ni ga, kaa ay bande ka koy nongu tana ra kaŋ ra nʼga dii ey, jere foo de no nʼga dii a, nʼsi dii a kul. No din ra mʼa danga ya ne.» ");
INSERT INTO ses_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","A na Balam ka koy hala nongoo kaŋ ga boro ga kay ka guna, Pisiga tondi hondoo boŋoo ga. A na sargari tonadoo iyye cin, a na yaaru foo nda gaaru foo kaa sargari, sargari tonadoo foo kul boŋ. ");
INSERT INTO ses_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balam nee Balak se: «Kay ne ni sargari kukurantaa jeroo ga, agay, ay ga koy Irkoy kubay.» ");
INSERT INTO ses_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Abadantaa kaa ka Balam kubay ka šenni daŋ miɲoo ra, a nee a se: «Yee Balak do, ma šelaŋ a se nda takaa kaŋ nda ay gʼa har ma ne.» ");
INSERT INTO ses_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","A yee Balak do, a nʼa gar a ga kay nga sargari kukurantaa jeroo ga, nga nda Mowab boŋkoyney. Balak nee a se: «Macin no Abadantaa nee?» ");
INSERT INTO ses_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Balam na nga yaasay šennoo har ka nee: «Balak, tun, ma maa, haŋajer ya ne, Sipor izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Irkoy manʼti adamize kaŋ ga hin ka taari, a manʼti boro kaŋ ga hin ka nimsi. Haya kaŋ a nʼa har, a sʼa tee wala? Šenni kaŋ a nʼa har, a sʼa too wala? ");
INSERT INTO ses_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Ay yadda ka gaara, a na albarka daŋ, ay si hin kʼa tunandi. ");
INSERT INTO ses_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","A mana dii ifutu Yakuba ra, a mana dii imeera Izirayel ra. Abadantaa, nga Koyoo goo a bande. Kobiroo kaŋ ga teendi kokoy se ga teendi a do. ");
INSERT INTO ses_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Irkoy nʼi fattandi Misira, a ga hima nda ganjihaw hilley. ");
INSERT INTO ses_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Kotte mana daŋandi Yakuba se, gunandiyan mana teendi Izirayel se. Nda waatoo too, takaa kaŋ Irkoy gʼa tee ga harandi Yakuba nda Izirayel se. ");
INSERT INTO ses_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Nga ne, jama no kaŋ ga tun sanda ganjihayla woy, a ga kay sanda ganjihayla aru. A si kani nda a mana hamoo kaŋ a nʼa dii ŋaa, ka wey kaŋ a nʼi wii kuroo haŋ.» ");
INSERT INTO ses_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Balak nee Balam se: «Nda nʼsʼa danga, adiši masi gaara a se!» ");
INSERT INTO ses_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balam nʼa zaabi ka nee: «Ay manʼa har ma ne kaŋ haya kul kaŋ Abadantaa nʼa har, ay gʼa tee wala?» ");
INSERT INTO ses_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balak nee Balam se: «Ay gʼa wiri ni ga, kaa, ay ga ni ka koy nongu tana ra, a ga hin ka tee no din ra Irkoy do a ga boori ma jamaa danga ya ne.» ");
INSERT INTO ses_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balak na Balam ka koy Pewor tondi hondoo boŋoo boŋ kaŋ goo saajoo se beene. ");
INSERT INTO ses_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balam nee Balak se: «Sargari tonadoo iyye cin ya ne, ne ra, ma yaaru kobsi iyye nda gaaru boŋ iyye soolu ya ne.» ");
INSERT INTO ses_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak na hayaa tee kaŋ Balam nʼa har. A na yaaru foo nda gaaru foo kaa sargari, sargari tonadoo foo kul boŋ. ");
INSERT INTO ses_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Balam dii kaŋ a ga kan Abadantaa se nga ma gaara Izirayel jamaa se. A mana koy sanda cee jinawey kaŋ a ga nee nga mma koy gunandi. A bere ka saajoo tenje. ");
INSERT INTO ses_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Balam na nga boŋoo jer, de a ga dii Izirayel borey ga goro alkabiila nda alkabiila. Waatoo din Irkoy Hundoo kaa Balam ga. ");
INSERT INTO ses_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Balam na nga yaasay šennoo har ka nee: «Balam, Bewor izʼaroo šennoo ti woo, aroo kaŋ moɲey hay šennoo ti woo. ");
INSERT INTO ses_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Boraa kaŋ ga maa Irkoy šenney, šennoo ti woo, boraa kaŋ ga dii Hini-kul-koyoo bangayyanoo, boraa kaŋ ga sujudu, de moɲey ga feera. ");
INSERT INTO ses_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Ya Yakuba, ni hukkumey ga boori, ni gorodogey ga boori, Izirayel. ");
INSERT INTO ses_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","I ga koy ni mma nee hari beeri bisadoo, sanda saddiɲayaŋ kaŋ goo isa mee ga, sanda alowe dumariyaŋ kaŋ Abadantaa nʼi duma, sanda sedere tuuriyaŋ kaŋ goo haroo miɲoo bande. ");
INSERT INTO ses_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Hari no ma doo ka hun nga sowey ra, nga dumiyoo, hari beeriyaŋ no mʼa haŋandi. Nga kokoyoo goo kokoyoo Agag se boŋ, nga laamaa goo ma duu gaabi. ");
INSERT INTO ses_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Irkoy nʼa fattandi Misira gandaa ra, a ga hima nda ganjihaw hilley. A goo ma nga torrokey gandawey derandi, a goo ma birey kayri, a goo mʼi hay nda nga birawey. ");
INSERT INTO ses_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","A ga gunguma, a ga kani sanda ganjihayla aru, sanda ganjihayla woy. May no ma yadda kʼa tunandi? Albarka ma huru boraa ra kaŋ ga gaara ma ne, boraa ma laali kaŋ ga ni danga.» ");
INSERT INTO ses_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Balak futu Balam ga. A na nga kabey kar cere ga ka nee Balam se: «Ya nka ciya ma ne hala ma agay iberey danga, amma ni ne ka gaara i se kaaray hala cee hinza. ");
INSERT INTO ses_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Sohõ zuru ka koy ni do, ay nee kaŋ ay ga beeray doori ni boŋ, amma Abadantaa na daržaa woo ganji ma ne.» ");
INSERT INTO ses_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balam nee Balak se: «Ay mana šelaŋ ni dontokey se kaŋ nʼnʼi sanba ay do ka nee: ");
INSERT INTO ses_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‹Ba nda Balak nʼay noo nga hugoo mee foo nzorfu kaaray nda wura, ay si hin nda ay boŋ ka Abadantaa yaamaroo hoo ka ihenna wala ilaala tee. Haya kaŋ Abadantaa nʼa har, nga no ay gʼa har.› ");
INSERT INTO ses_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Sohõ ay ga koy ay jamaa here. Kaa, ay a ga hayaa har ma ne kaŋ jamaa woo ga kaa kʼa tee ni jamaa se waatey kaŋ ga kaa ra.» ");
INSERT INTO ses_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Balam na nga yaasay šennoo har ka nee: «Balam, Bewor izʼaroo šennoo ti woo, aroo kaŋ moɲey hay šennoo ti woo. ");
INSERT INTO ses_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Boraa kaŋ ga maa Irkoy šenney, šennoo ti woo, boraa kaŋ ga Koy Jerantaa bayraa bay, boraa kaŋ ga dii Hini-kul-koyoo bangayyanoo, boraa kaŋ ga sujudu, de moɲey ga feera. ");
INSERT INTO ses_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Ay ga dii a, amma manʼti sohõ da, ay gʼa gaaya, amma manʼti nda maanay. Handaray fatta Yakuba ra, kokoy gobu fatta Izirayel ra. A ga Mowab borey kar lakkaley ga kʼi say, a ga Seti izey kul kar boŋkurunbey ga kʼi say. ");
INSERT INTO ses_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","A hin Edom gandaa kʼa tee nga wane, a hin nga iberoo kaŋ ti Seyir gandaa kʼa tee nga wane. Izirayel ga gaabi beeri fattandi. ");
INSERT INTO ses_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Boraa kaŋ fatta Yakuba ra no ma goro hinoo ra. Koyraa baahunantey kaŋ cindi, a gʼi halaci.» ");
INSERT INTO ses_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Balam dii Amalek, a na nga yaasay šennoo har ka nee: «Amalek bisa gandawey kul, amma nga kokoroo manʼti kala a ma dere.» ");
INSERT INTO ses_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Balam dii Keni borey, a na nga yaasay šennoo har ka nee: «Ni gorodogoo ga gaabi, ni tejoo sii kala tondi boŋ. ");
INSERT INTO ses_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Amma Keni borey ga tonandi ka tee boosu waati kaŋ Ašur ga ni daŋ baɲɲataray.» ");
INSERT INTO ses_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Balam na nga yaasay šennoo har ka nee: «Woo ti bone. May no ma huna waati kaŋ Irkoy na woo tee? ");
INSERT INTO ses_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Amma harihii beeriyaŋ ga kaa ka hun Kitim gandaa ra, i ga žigi ka koy Asiri borey ga, i ga žigi ka koy Eber borey ga, ngi mo ga dere.» ");
INSERT INTO ses_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Woo banda ga, Balam tun ka koy, a willi nga do, Balak mo na nga fondaa zaa ka koy. ");
INSERT INTO ses_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Izirayel goro Šitim. Jamaa šintin ka izefututaray tee nda Mowab ize woyey. ");
INSERT INTO ses_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Woyey din na jamaa cee kate i ma sargari kaa ngi koyey se. Jamaa ŋaa, de mo i sujudu ngi koyey jine. ");
INSERT INTO ses_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Izirayel borey hanga Bal kaŋ ti Pewor koyoo. Abadantaa futu Izirayel ga. ");
INSERT INTO ses_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Abadantaa nee Musa se: «Izirayel jamaa boŋkoyney kul dii kʼi deeji Abadantaa jine waynaa tenje hala Abadantaa futay laalaa ma mooru Izirayel ga.» ");
INSERT INTO ses_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Musa nee Izirayel alkaaley se: «War affoo kul ma nga borey wii kaŋ hanga Bal kaŋ ti Pewor koyoo.» ");
INSERT INTO ses_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Nga ne, Izirayel borey ra, aru foo kaa ka Majaŋ woy foo cebe nga armey se, Musa jine nda Izirayel borey jamaa kul jine. Woo gar i goo ma hẽe cere kubayyan hukkumoo miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Sargari juwalkaa Haruna izʼaroo Eleyazar izʼaroo Pinehas dii woo, a tun jamaa game ka yaaji zaa nga kaboo ra. ");
INSERT INTO ses_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","A hanga Izirayel aroo din bande hala hukkumoo gundoo ra, a na boro hinkaa kul hay, Izirayel aroo nda Majaŋ woyoo, a na woyoo hay gundoo ra. Kaŋ a na woo tee, bonaa kaŋ duu Izirayel borey kay. ");
INSERT INTO ses_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Bonaa na boro zenber waranka cindi taaci (24.000) wii. ");
INSERT INTO ses_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","«Sargari juwalkaa Haruna izʼaroo Eleyazar izʼaroo Pinehas nʼay futuroo kuubi kʼa kaa Izirayel borey here. Zama alhawa cansantaa kaŋ goo ay ra, nga bara a ra. Woo se ay alhawa cansantaa mana koy ka Izirayel borey tuusu kʼi wii. ");
INSERT INTO ses_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Woo maaganda se nee a se: ‹Ay ga agay amaanaa zaa a se kʼa noo alaafiya.› ");
INSERT INTO ses_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Nga nda nga hayroo kaŋ goo dumaa ga, ga duu amaana sargari juwalkawtaraa here kaŋ a gʼa tee hala abada, zama a na alhawa cansante cebe nga Koyoo se, de mo a na zunubu tuusuyanoo tee Izirayel borey se.» ");
INSERT INTO ses_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Izirayel aroo kaŋ i na nga nda Majaŋ woyoo wii maaɲoo ti Zimri. Salu kaŋ ti Simewoŋ hugu foo boŋkoyni izʼaroo no. ");
INSERT INTO ses_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Majaŋ woyoo kaŋ wiiyandi maaɲoo ti Kozbi, Sur ize woy no. Sur manʼti kala Majaŋ alkabiila foo boŋkoyni. ");
INSERT INTO ses_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","«Majaŋ borey wongu. Wʼi kar, ");
INSERT INTO ses_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","zama i nka kay war se iberi doo ra. I na war zanba ka war derandi Pewor šennoo ra nda Kozbi šennoo ra, ngi woymaa kaŋ ti Majaŋ boŋkoyni foo ize woyoo kaŋ wiiyandi bonaa zaaroo Pewor šennoo maaganda se.» ");
INSERT INTO ses_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Bonaa woo banda ga, Abadantaa nee Musa nda sargari juwalkaa Haruna izʼaroo kaŋ ti Eleyazar se: ");
INSERT INTO ses_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","«Wa Izirayel borey jamaa kul kabu, wey kaŋ goo nda jiiri waranka (20) nda ka žigi, hugu ka koy hugu, kaŋyaŋ ga hin ka koy wongu Izirayel se.» ");
INSERT INTO ses_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Musa nda sargari juwalkaa Eleyazar šelaŋ Izirayel borey se Mowab ganganey ra, Žurdeŋ isaa jere, Žeriko tenje, ka nee i se: ");
INSERT INTO ses_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","«Wey kaŋ goo nda jiiri waranka (20) nda ka žigi ma kabandi, sanda takaa kaŋ nda Abadantaa na Musa yaamar.» Izirayel borey kaŋ fatta Misira gandaa ra ti: ");
INSERT INTO ses_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Rubeŋ ti Izirayel ize jinaa. Rubeŋ hayroo ti: Hanok, nga ga Hanok borey alaayan beeroo hun. Palu, nga ga Palu borey alaayan beeroo hun. ");
INSERT INTO ses_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hesroŋ, nga ga Hesroŋ borey alaayan beeroo hun. Karmi, nga ga Karmi borey alaayan beeroo hun. ");
INSERT INTO ses_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Wey ti Rubeŋ borey alaayan beerey. Borey kaŋ kabandi i ra manʼti kala boro zenber woytaaci cindi hinza nda zangu iyye nda waranza (43.730). ");
INSERT INTO ses_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Palu hayroo ti Eliyab. ");
INSERT INTO ses_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Eliyab hayroo ti Nemuwel, nda Dataŋ, nda Abiram. Dataŋ woo da, nda Abiram woo da ti borey kaŋ se jamaa ciya i ma tee ngi se jineboro. I waafaku nda Kora borey ka yenje Musa nda Haruna bande waatoo kaŋ Kora borey yenje Abadantaa bande. ");
INSERT INTO ses_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Laboo na nga miɲoo feeri ka ngi nda Kora gon waatoo kaŋ Kora jamaa ga buu. Nuunaa na boro zangu hinka nda woyguu (250) ton kʼi tee boosu. I tee tammaasa. ");
INSERT INTO ses_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Woo kul, Kora izey mana buu. ");
INSERT INTO ses_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Simewoŋ hayroo, alaayan beeri ka koy alaayan beeri ti: Nemuwel, nga ga Nemuwel borey alaayan beeroo hun. Yamin, nga ga Yamin borey alaayan beeroo hun. Yakin, nga ga Yakin borey alaayan beeroo hun. ");
INSERT INTO ses_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zera, nga ga Zera borey alaayan beeroo hun. Sawul, nga ga Sawul borey alaayan beeroo hun. ");
INSERT INTO ses_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Wey ti Simewoŋ borey alaayan beerey, i manʼti kala boro zenber waranka cindi hinka nda zangu hinka (22.200). ");
INSERT INTO ses_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Gad hayroo, alaayan beeri ka koy alaayan beeri ti: Sefoŋ, nga ga Sefoŋ borey alaayan beeroo hun. Hagi, nga ga Hagi borey alaayan beeroo hun. Šuni, nga ga Šuni borey alaayan beeroo hun. ");
INSERT INTO ses_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Ozini, nga ga Ozini borey alaayan beeroo hun. Eri, nga ga Eri borey alaayan beeroo hun. ");
INSERT INTO ses_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arod, nga ga Arod borey alaayan beeroo hun. Areli, nga ga Areli borey alaayan beeroo hun. ");
INSERT INTO ses_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Wey ti Gad hayroo alaayan beerey. Borey kaŋ kabandi i ra manʼti kala boro zenber woytaaci nda zangu guu (40.500). ");
INSERT INTO ses_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Žuda hayroo ti: Er nda Onaŋ, amma Er nda Onaŋ buu Kanaŋ gandaa ra. ");
INSERT INTO ses_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Žuda hayroo, alaayan beeri ka koy alaayan beeri ti: Šela, nga ga Šela borey alaayan beeroo hun. Peres, nga ga Peres borey alaayan beeroo hun. Zera, nga ga Zera borey alaayan beeroo hun. ");
INSERT INTO ses_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Peres hayroo ti: Hesroŋ, nga ga Hesroŋ borey alaayan beeroo hun. Hamul, nga ga Hamul borey alaayan beeroo hun. ");
INSERT INTO ses_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Wey ti Žuda alaayan beerey. Borey kaŋ kabandi i ra manʼti kala boro zenber woyye cindi iddu nda zangu guu (76.500). ");
INSERT INTO ses_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Isakar hayroo, alaayan beeri ka koy alaayan beeri ti: Tola, nga ga Tola borey alaayan beeroo hun. Puwa, nga ga Puwa borey alaayan beeroo hun. ");
INSERT INTO ses_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Yašub, nga ga Yašub borey alaayan beeroo hun. Šimroŋ, nga ga Šimroŋ borey alaayan beeroo hun. ");
INSERT INTO ses_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Wey ti Isakar alaayan beerey. Borey kaŋ kabandi i ra manʼti kala boro zenber woydu cindi taaci nda zangu hinza (64.300). ");
INSERT INTO ses_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Zabuloŋ hayroo, alaayan beeri ka koy alaayan beeri ti: Sered, nga ga Sered borey alaayan beeroo hun. Eloŋ, nga ga Eloŋ borey alaayan beeroo hun. Yalel, nga ga Yalel borey alaayan beeroo hun. ");
INSERT INTO ses_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Wey ti Zabuloŋ borey alaayan beerey. Borey kaŋ kabandi i ra manʼti kala boro zenber woydu nda zangu guu (60.500). ");
INSERT INTO ses_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Isufi hayroo, alaayan beeri ka koy alaayan beeri ti: Manase nda Efrayim. ");
INSERT INTO ses_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Manase hayroo ti: Makir, nga ga Makir borey alaayan beeroo hun. Makir ka Galad hay. Galad, nga ga Galad borey alaayan beeroo hun. ");
INSERT INTO ses_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Galad hayroo ti: Yezer, nga ga Yezer borey alaayan beeroo hun. Helek, nga ga Helek borey alaayan beeroo hun. ");
INSERT INTO ses_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asriyel, nga ga Asriyel borey alaayan beeroo hun. Šekem, nga ga Šekem borey alaayan beeroo hun. ");
INSERT INTO ses_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Šemida, nga ga Šemida borey alaayan beeroo hun. Hefer, nga ga Hefer borey alaayan beeroo hun. ");
INSERT INTO ses_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Selofad kaŋ ti Hefer izʼaru mana duu izʼaruyaŋ, ize woyyaŋ de no a duu. Selofad ize woyey maaɲey ti: Mahila, nda Nowa, nda Hogla, nda Milka, nda Tirsa. ");
INSERT INTO ses_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Wey ti Manase alaayan beerey. Borey kaŋ kabandi i ra manʼti kala boro zenber woyguu cindi hinka nda zangu iyye (52.700). ");
INSERT INTO ses_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Efrayim hayroo, alaayan beeri ka koy alaayan beeri ti: Šutela, nga ga Šutela borey alaayan beeroo hun. Beker, nga ga Beker borey alaayan beeroo hun. Tahaŋ, nga ga Tahaŋ borey alaayan beeroo hun. ");
INSERT INTO ses_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Šutela hayroo ti: Eraŋ, nga ga Eraŋ borey alaayan beeroo hun. ");
INSERT INTO ses_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Wey ti Efrayim hayroo alaayan beeroo. Borey kaŋ kabandi i ra manʼti kala boro zenber waranza cindi hinka nda zangu guu (32.500). Wey ti Isufi hayroo, alaayan beeri ka koy alaayan beeri. ");
INSERT INTO ses_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Benžameŋ hayroo, alaayan beeri ka koy alaayan beeri ti: Bela, nga ga Bela borey alaayan beeroo hun. Ašibel, nga ga Ašibel borey alaayan beeroo hun. Ahiram, nga ga Ahiram borey alaayan beeroo hun. ");
INSERT INTO ses_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Šufam, nga ga Šufam borey alaayan beeroo hun. Hufam, nga ga Hufam borey alaayan beeroo hun. ");
INSERT INTO ses_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Bela hayroo ti: Ardu nda Namaŋ. Ardu, nga ga Ardu borey alaayan beeroo hun nda Namaŋ kaŋ ga Namaŋ borey alaayan beeroo hun. ");
INSERT INTO ses_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Wey ti Benžameŋ hayroo, alaayan beeri ka koy alaayan beeri. Borey kaŋ kabandi i ra manʼti kala boro zenber woytaaci cindi guu nda zangu iddu (45.600). ");
INSERT INTO ses_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Dan hayroo, alaayan beeri ka koy alaayan beeri ti: Šuham, nga ga Šuham borey alaayan beeroo hun. Wey ti Dan alaayan beerey, alaayan beeri ka koy alaayan beeri. ");
INSERT INTO ses_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Šuham borey alaayan beerey, borey kaŋ kabandi i ra manʼti kala boro zenber woydu cindi taaci nda zangu taaci (64.400). ");
INSERT INTO ses_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Ašer hayroo, alaayan beeri ka koy alaayan beeri ti: Yimna, nga ga Yimna borey alaayan beeroo hun. Yišwi, nga ga Yišwi borey alaayan beeroo hun. Beriya, nga ga Beriya borey alaayan beeroo hun. ");
INSERT INTO ses_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Beriya hayroo ti: Heber, nga ga Heber borey alaayan beeroo hun. Malkiyel, nga ga Malkiyel borey alaayan beeroo hun. ");
INSERT INTO ses_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Ašer ize woyoo maaɲoo ti Sera. ");
INSERT INTO ses_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Wey ti Ašer hayroo alaayan beerey. Borey kaŋ kabandi i ra manʼti kala boro zenber woyguu cindi hinza nda zangu taaci (53.400). ");
INSERT INTO ses_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Neftali hayroo, alaayan beeri ka koy alaayan beeri ti: Yasiyel, nga ga Yasiyel borey alaayan beeroo hun. Guni, nga ga Guni borey alaayan beeroo hun. ");
INSERT INTO ses_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Yeser, nga ga Yeser borey alaayan beeroo hun. Šilem, nga ga Šilem borey alaayan beeroo hun. ");
INSERT INTO ses_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Wey ti Neftali alaayan beerey, alaayan beeri ka koy alaayan beeri. Borey kaŋ kabandi i ra manʼti kala boro zenber woytaaci cindi guu nda zangu taaci (45.400). ");
INSERT INTO ses_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Borey kaŋ kabandi Izirayel borey ra manʼti kala boro zenber zangu iddu nda zenber foo nda zangu iyye nda waranza (601.730). ");
INSERT INTO ses_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","«Alkabiilawey wey game gandaa ga zamnandi ka tee ngi tuboo. Ngi bagawey sii kala borey hinnaa bande. ");
INSERT INTO ses_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Alkabiila beeri ga duu doo beeri, alkabiila kaccu ga duu doo kaccu. Alkabiila foo kul ga duu doo ka sawa nda nga borey hinnaa kaŋ kabandi. ");
INSERT INTO ses_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Woo kul, alkurra ma karandi ka gandaa zamna, ngi baabey alkabiila foo kul borey ga duu nga bagaa. ");
INSERT INTO ses_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Alkurraa kaŋ ga karandi no ma cebe tuboo kaŋ ga nondi alkabiila beerey se nda ikaccey se.» ");
INSERT INTO ses_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Borey kaŋ kabandi Lewi borey ra, alaayan beeri ka koy alaayan beeri ti: Geršoŋ, nga ga Geršoŋ borey alaayan beeroo hun. Kehat, nga ga Kehat borey alaayan beeroo hun. Merari, nga ga Merari borey alaayan beeroo hun. ");
INSERT INTO ses_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Lewi alaayan beerey ti: Libni borey alaayan beeroo, nda Hebroŋ borey alaayan beeroo, nda Mahili borey alaayan beeroo, nda Muši borey alaayan beeroo, nda Kora borey alaayan beeroo. Kehat ka Amram hay. ");
INSERT INTO ses_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amram wandoo maaɲoo ti Žokebed kaŋ ti Lewi ize woy. Lewi manʼa hay kala Misira gandaa ra. A duu Amram se Haruna, nda Musa, nda Maryama ngi woymaa. ");
INSERT INTO ses_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Izey kaŋ Haruna duu ey ti: Nadab, nda Abihu, nda Eleyazar, nda Itamar. ");
INSERT INTO ses_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadab nda Abihu buu, zama nuune kaŋ si bisa no i nʼa daŋ Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Borey kaŋ kabandi Lewi borey ra, kʼa dii arey kul kaŋ goo nda handu foo nda ka žigi manʼti kala boro zenber waranka cindi hinza (23.000). I mana kabandi Izirayel borey ra, zama i mana duu tubu Izirayel borey cindey bande. ");
INSERT INTO ses_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Wey ti borey kaŋ Musa nda sargari juwalkaa Eleyazar nʼi kabu Mowab ganganey ra, Žurdeŋ isaa jere, Žeriko tenje. ");
INSERT INTO ses_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Boro kul sii borey wey ra kaŋ Musa nda sargari juwalkaa Haruna nʼa kabu waatoo kaŋ i na Izirayel borey kabu Sinay saajoo ra. ");
INSERT INTO ses_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Zama Abadantaa nka nee: «I ga buu saajoo ra.» Boro kul mana cindi i ra nda manʼti Yefune izʼaroo Kaleb, nda Nun izʼaroo Žozuwe hinne. ");
INSERT INTO ses_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Isufi izʼaroo kaŋ ti Manase, nga alaayan beerey boro goo no kaŋ maaɲoo ti Selofad. Selofad ti Hefer izʼaroo, Hefer ti Galad izʼaroo, Galad ti Makir izʼaroo, Makir ti Manase izʼaroo. Selofad ize woyey maaɲey ti: Mahila, nda Nowa, nda Hogla, nda Milka, nda Tirsa. ");
INSERT INTO ses_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Han foo ize woyey kaa ka kay Musa nda sargari juwalkaa Eleyazar jine, nda boŋkoyney, nda jamaa kul jine cere kubayyan hukkumoo miɲoo ga. I nee: ");
INSERT INTO ses_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","«Ir baabaa buu saajoo ra, nga, a sii jamaa ra kaŋ ture Abadantaa ga Kora borey bande. Nga boŋ zunuboo kʼa wii, de mo izʼaru sii a se. ");
INSERT INTO ses_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Macin se ir baabaa maaɲoo ga hun nga alaayan beeroo ra, kaŋ se a mana duu izʼaru wala? Ir noo doo ir baabaa armey game.» ");
INSERT INTO ses_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Hayaa kaŋ i nʼa ceeci, Musa koy a daŋ Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","«Selofad ize woyey goo nda cimi, i noo doo kaŋ ga tee ngi wane ngi baabaa armey game, ma ngi baabaa tuboo noo i se. ");
INSERT INTO ses_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Šelaŋ Izirayel borey se ka nee: ‹Nda aru buu bila nda a ma izʼaru naŋ, wa nga tuboo noo nga ize woyoo se. ");
INSERT INTO ses_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Nda a sii nda ize woy, wa nga tuboo noo nga armey se. ");
INSERT INTO ses_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Nda a sii nda arma, wa nga tuboo noo baaboo armey se. ");
INSERT INTO ses_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Nda baaboo sii nda arma, war ma nga tuboo noo nga boro maanaa se nga alaayan beeroo ra. Nga no ma tuboo zaa. A ga tee Izirayel borey se hantum kaŋ kayandi hantumante, sanda takaa kaŋ nda Abadantaa nʼa har Musa se.›» ");
INSERT INTO ses_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Abadantaa nee Musa se: «Žigi Abarim tondi hondoo woo boŋ, ma gandaa guna kaŋ ay nʼa noo Izirayel borey se. ");
INSERT INTO ses_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Nʼga dii a, nga banda ga, ni mo, nʼga koy ni hayragey gar alaahara sanda takaa kaŋ nda ni armaa Haruna koy i gar, ");
INSERT INTO ses_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","zama war wanji ay yaamaroo ga Tisin saajoo ra. Waatoo kaŋ jamaa yenje nda agay, war manʼay henanyanoo cebe i se waatoo kaŋ i ga hari wiri.» Maanaa Meriba haroo kaŋ goo Kadeš, Tisin saajoo ra. ");
INSERT INTO ses_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Musa šelaŋ Abadantaa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","«Abadantaa baahunantey kul hundey Koyoo, aru daŋ jamaa jine ");
INSERT INTO ses_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","kaŋ ga huru i jine ngi koyyanoo nda ngi kaayanoo ga, kaŋ gʼi ka koy, a gʼi ka yee kate, hala jamaa masi tee sanda alman kur kaŋ sii nda kurkaw.» ");
INSERT INTO ses_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Abadantaa nee Musa se: «Žozuwe kaŋ ti Nun izʼaroo zaa, aru no kaŋ ra ay Hundoo goo, ma ni kaboo fur a ga. ");
INSERT INTO ses_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Mʼa kayandi sargari juwalkaa Eleyazar jine nda jamaa kul jine, kʼa gorandi goyoo ra kaŋ ay nʼa talfi a ga borey kul jine. ");
INSERT INTO ses_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Mʼa noo ni hinoo ra, hala Izirayel borey jamaa kul ma haŋajer a se. ");
INSERT INTO ses_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","A ma kay sargari juwalkaa Eleyazar jine kaŋ ga Irkoy ibaayoo ceeci a se nda alkurraa goy jinawey kaŋ ti Urim Abadantaa jine. Eleyazar yaamaroo ga, Žozuwe nda Izirayel borey jamaa kul ga koy, nga yaamaroo ga, i ga yee kate.» ");
INSERT INTO ses_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Musa na hayaa tee kaŋ nda Abadantaa nʼa yaamar. A na Žozuwe zaa kʼa kayandi sargari juwalkaa Eleyazar jine nda jamaa kul jine. ");
INSERT INTO ses_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Musa na nga kabey fur a boŋ kʼa gorandi goyoo ra nda takaa kaŋ nda Abadantaa nʼa har Musa se. ");
INSERT INTO ses_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","«Yaamaroo woo har Izirayel borey se: ‹Sargarey kaŋ war gʼi kaa ya ne, wa hawgay war mʼi kaa waatoo kaŋ kayandi ra, ay ŋaahayaa nda sargari tonantey kaŋ sunnaaraa ga kan ya ne.› ");
INSERT INTO ses_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Ma nee i se: ‹Sargari tonantaa ne kaŋ war gʼa kaa Abadantaa maaɲoo ga: feeji-ize kaŋ goo nda jiiri foo kaŋ ga malal sii, ize hinka zaari kul sanda sargari kukurante kaŋ ga kaandi waati kul. ");
INSERT INTO ses_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Ma feeji-ize foo kaa sargari subbaahi, ma ihinkantoo kaa almaari. ");
INSERT INTO ses_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Taasu sargaroo se ma farin hamni kilo hinza loobu nda zaytu musayante jii liitar foo nda jere. ");
INSERT INTO ses_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Woo ti sargari kukurantaa kaŋ ga kaandi waati kul, a mana kayandi ka teendi kala Sinay tondi hondoo do. Sunnaara kaana no, sargari tonante no Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Sargari hari-haroo ma tee alaneb hari moora liitar foo nda jere kaŋ ma tonton feeji-ize foo kul ga. Nongu henanantaa ra nʼga harifutu sargari hari-haroo doori Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Feeji-ize hinkantoo ma sargandi almaaroo ra, mʼa tee sanda subbaahoo taasu sargaroo nda nga sargari hari-haroo. Sargari tonante no kaŋ sunnaaraa ga kan Abadantaa se.›» ");
INSERT INTO ses_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","«‹Hunanzamzaaroo hane war ma feeji-ize hinka kaŋ ga malal sii sarga. Taasu sargaroo se war ma farin hamni kilo iddu loobu nda jii, ka sargari hari-haroo daŋ a ga. ");
INSERT INTO ses_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Hunanzamzaaroo sargari kukurantaa no, a ga teendi hunanzamzaari foo kul hane, a ga huru sargari kukurantaa ga kaŋ ga teendi waati kul nda nga sargari hari-haroo.›» ");
INSERT INTO ses_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","«‹War handey zaari jinaa, war ma yaaru hinka, nda gaaru foo, nda feeji-ize iyye kaŋyaŋ goo nda jiiri foo kaa sargari kukurante Abadantaa maaɲoo ga, malal kul masi bara i ga. ");
INSERT INTO ses_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Farin hamni kilo yagga kaŋ loobandi nda jii ka tee taasu sargari ga huru yaaru foo kul ga. Farin hamni kilo iddu kaŋ loobandi nda jii ka tee taasu sargari ga huru gaaroo ga. ");
INSERT INTO ses_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Farin hamni kilo hinza kaŋ loobandi nda jii ka tee taasu sargari ga huru feeji-ize foo kul ga. Sargari kukurante no kaŋ sunnaaraa ga kan Abadantaa se. Sargari tonante no Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Sargari hari-harey kaŋ ga hanga adabbawey ti: yaaru foo kul alaneb hari moora liitar hinza, gaaru foo kul alaneb hari moora liitar hinka, feeji-ize foo kul alaneb hari moora liitar foo nda jere. Woo ti handu sargari kukurantaa, handu ka kaa handu, jiiroo handey ra. ");
INSERT INTO ses_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Koyne mo war ma jindaaru foo kaa zunubu sargari, a ma nondi Abadantaa se, a ga huru waati kul sargari kukurantaa nda nga sargari hari-haroo ga.›» ");
INSERT INTO ses_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","«‹Jiiroo handu jinaa jirbi woy cindi taacantoo (14to) ma Borcintaraa jingaroo tee Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Handoo woo jirbi woy cindi guwantoo (15to) ga tee jingaroo, war ga takula kaŋ ra dolobiri sii ŋaa jirbi iyye. ");
INSERT INTO ses_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Zaari jinaa, margari henanante ma tee, war masi goy šenda kul tee. ");
INSERT INTO ses_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","War ma yaaru hinka, nda gaaru foo, nda feeji-ize iyye kaŋyaŋ goo nda jiiri foo, i ma tee adabbayaŋ kaŋ ga malal sii, kaa sargari tonante kaŋ ma tee sargari kukurante Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","War ma farin hamni loobu nda jii kʼa daŋ affoo kul ga sanda taasu sargari: kilo yagga ma huru yaaroo ga, kilo iddu ma huru gaaroo ga, ");
INSERT INTO ses_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","kilo hinza ma huru feeji-ize iyyaa affoo kul ga, ");
INSERT INTO ses_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","nda jindaaru foo zunubu sargaroo se, ka zunubu tuusuyanoo tee war se. ");
INSERT INTO ses_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","War ga wey sarga ka tonton subbaahoo sargari kukurantaa ga, maanaa sargaroo kaŋ ga hun waati kul. ");
INSERT INTO ses_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","War mʼi sarga zaari kul hala jirbi iyye sanda sargari tonante kaŋ sunnaaraa ga kan Abadantaa se. I ga sargandi ka tonton sargari kukurantaa ga kaŋ ga hun waati kul nda nga sargari hari-haroo ga. ");
INSERT INTO ses_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Jirbi iyyantoo hane margari henanante ma tee, war masi goy šenda kul tee.›» ");
INSERT INTO ses_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","«‹Tuuri-ize jina-jinawey zaaroo kaŋ ra war ga taasu sargari taaga kaa Abadantaa maaɲoo ga, waatoo kaŋ war ga war Jirbiiyyewey jingaroo tee, war ma margari henanante tee, war masi goy šenda kul tee. ");
INSERT INTO ses_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","War ma sargari kukurante kaa kaŋ ga tee sunnaara kaana Abadantaa se. A ma tee yaaru hinka, nda gaaru foo, nda feeji-ize iyye kaŋyaŋ goo nda jiiri foo. ");
INSERT INTO ses_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","War ma farin hamni loobu nda jii kʼa daŋ i ga sanda taasu sargari, farin hamni kilo yagga ma huru yaaru foo kul ga, farin hamni kilo iddu ma huru gaaru foo kul ga, ");
INSERT INTO ses_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","farin hamni kilo hinza ma huru feeji-ize foo kul ga. ");
INSERT INTO ses_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","War ma jindaaru kaa ka zunubu tuusuyanoo tee war se. ");
INSERT INTO ses_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","War ga sargarey wey kaa ka tonton sargari kukurantaa ga kaŋ ga hun waati kul nda nga taasu sargaroo. I ma tee adabbayaŋ kaŋ ga malal sii. War ma ngi sargari hari-harey kaa.›» ");
INSERT INTO ses_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Handu iyyantoo zaari jinaa, war ma margari henanante tee, war masi goy šenda kul tee. A ga tee war se zaari kaŋ ra war ga laati kar. ");
INSERT INTO ses_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","War ma sargari kukurante kaa sanda sunnaara kaana Abadantaa maaɲoo ga, a ma tee yaaru foo, nda gaaru foo, nda feeji-ize boŋ iyye kaŋyaŋ goo nda jiiri foo, i ma tee adabbayaŋ kaŋ ga malal sii. ");
INSERT INTO ses_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Ngi taasu sargaroo ma tee farin hamni kaŋ loobandi nda jii. Kilo yagga ma huru yaaroo ga, kilo iddu ma huru gaaroo ga, ");
INSERT INTO ses_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","kilo hinza ma huru feeji-ize iyyaa affoo kul ga. ");
INSERT INTO ses_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","War ma jindaaru foo kaa zunubu sargari ka zunubu tuusuyanoo tee war se ");
INSERT INTO ses_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","kaŋ sii handu kul sargari kukurantaa ra, nda nga taasu sargaroo, nda sargari kukurantaa kaŋ ga hun waati kul, nda nga taasu sargaroo, nda ngi sargari hari-harey. I ma teendi ka sawa nda woo kaŋ kayandi. Sargari tonante no kaŋ sunnaaraa ga kan Abadantaa se. ");
INSERT INTO ses_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Handu iyyantoo din jirbi woyantoo (10to), war ma margari henanante tee ka meehaw, war masi goy kul tee. ");
INSERT INTO ses_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","War ma sargari kukurante kaŋ sunnaaraa ga kan kaa Abadantaa se, a ma tee yaaru foo, nda gaaru foo, nda feeji-ize boŋ iyye kaŋyaŋ goo nda jiiri foo, i ma tee adabbayaŋ kaŋ ga malal sii. ");
INSERT INTO ses_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Ngi taasu sargaroo ma tee farin hamni kaŋ loobandi nda jii: kilo yagga ma huru yaaroo ga, kilo iddu ma huru gaaru foo kul ga, ");
INSERT INTO ses_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","kilo hinza feeji-ize iyyaa affoo kul ga. ");
INSERT INTO ses_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","War ma jindaaru foo kaa zunubu sargari kaŋ manʼti woo kaŋ hun zunubu tuusuyanoo se, nda sargari kukurantaa kaŋ ga hun waati kul, nda nga taasu sargaroo, nda ngi sargari hari-harey. ");
INSERT INTO ses_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Handu iyyantoo jirbi woy cindi guwantoo (15to) hane, war ma margari henanante tee, war masi goy šenda kul tee. War ma jingar tee Abadantaa maaɲoo ga jirbi iyye. ");
INSERT INTO ses_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","War ma sargari kukurante kaa, a ma tee sargari tonante kaŋ sunnaaraa ga kan Abadantaa se, a ma tee yaaru kobsi woy cindi hinza (13), nda gaaru hinka, nda feeji-ize boŋ woy cindi taaci (14) kaŋyaŋ goo nda jiiri foo, i ma tee adabbayaŋ kaŋ ga malal sii. ");
INSERT INTO ses_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Ngi taasu sargaroo ma tee farin hamni kaŋ loobandi nda jii. Kilo yagga ma huru yaaru kobsi woy cindi hinzaa (13) affoo kul ga, kilo iddu ma huru gaaru hinka affoo kul ga. ");
INSERT INTO ses_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","Kilo hinza ma huru feeji-ize woy cindi taacaa (14) affoo kul ga. ");
INSERT INTO ses_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","War ma jindaaru foo kaa zunubu sargari kaŋ manʼti waati kul sargari kukurantaa, nda nga taasu sargaroo, nda nga sargari hari-haroo. ");
INSERT INTO ses_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Zaari hinkantoo hane, war ma yaaru kobsi woy cindi hinka (12) kaa sargari, nda gaaru hinka, nda feeji-ize boŋ woy cindi taaci (14) kaŋyaŋ goo nda jiiri foo, i ma tee adabbayaŋ kaŋ ga malal sii. ");
INSERT INTO ses_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","War ma yaarey, nda feeji-izey, nda gaarey taasu sargaroo nda ngi sargari hari-haroo mo kaa, affoo kul nda nga hinnaa nda woo kaŋ kayandi. ");
INSERT INTO ses_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","War ma jindaaru foo mo kaa zunubu sargari kaŋ manʼti waati kul sargari kukurantaa, nda nga taasu sargaroo, nda ngi sargari hari-harey. ");
INSERT INTO ses_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Zaari hinzantoo hane, war ma yaaru kobsi woy cindi foo (11) kaa sargari, nda gaaru hinka, nda feeji-ize boŋ woy cindi taaci (14) kaŋyan goo nda jiiri foo, i ma tee adabbayaŋ kaŋ ga malal sii. ");
INSERT INTO ses_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","War ma yaarey, nda feeji-izey, nda gaarey taasu sargaroo nda ngi sargari hari-haroo mo kaa, affoo kul nda nga hinnaa nda woo kaŋ kayandi. ");
INSERT INTO ses_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","War ma jindaaru foo mo kaa zunubu sargari kaŋ manʼti waati kul sargari kukurantaa, nda nga taasu sargaroo, nda nga sargari hari-haroo. ");
INSERT INTO ses_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Zaari taacantoo hane, war ma yaaru kobsi woy (10) kaa sargari, nda gaaru hinka, nda feeji-ize boŋ woy cindi taaci (14) kaŋyaŋ goo nda jiiri foo, i ma tee adabbayaŋ kaŋ ga malal sii. ");
INSERT INTO ses_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","War ma yaarey, nda feeji-izey, nda gaarey taasu sargaroo nda ngi sargari hari-haroo mo kaa, affoo kul nda nga hinnaa nda woo kaŋ kayandi. ");
INSERT INTO ses_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","War ma jindaaru foo mo kaa zunubu sargari kaŋ manʼti waati kul sargari kukurantaa, nda nga taasu sargaroo, nda nga sargari hari-haroo. ");
INSERT INTO ses_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Zaari guwantoo hane, war ma yaaru kobsi yagga kaa sargari, nda gaaru hinka, nda feeji-ize boŋ woy cindi taaci (14) kaŋyaŋ goo nda jiiri foo, i ma tee adabbayaŋ kaŋ ga malal sii. ");
INSERT INTO ses_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","War ma yaarey, nda feeji-izey, nda gaarey taasu sargaroo nda ngi sargari hari-haroo mo kaa, affoo kul nda nga hinnaa nda woo kaŋ kayandi. ");
INSERT INTO ses_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","War ma jindaaru foo mo kaa zunubu sargari kaŋ manʼti waati kul sargari kukurantaa, nda nga taasu sargaroo, nda nga sargari hari-haroo. ");
INSERT INTO ses_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Zaari idduwantoo hane, war ma yaaru kobsi yaaha kaa sargari, nda gaaru hinka, nda feeji-ize boŋ woy cindi taaci (14) kaŋyaŋ goo nda jiiri foo, i ma tee adabbayaŋ kaŋ ga malal sii. ");
INSERT INTO ses_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","War ma yaarey, nda feeji-izey, nda gaarey taasu sargaroo nda ngi sargari hari-haroo mo kaa, affoo kul nda nga hinnaa nda woo kaŋ kayandi. ");
INSERT INTO ses_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","War ma jindaaru foo mo kaa zunubu sargari kaŋ manʼti waati kul sargari kukurantaa, nda nga taasu sargaroo, nda nga sargari hari-harey. ");
INSERT INTO ses_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Zaari iyyantoo hane, war ma yaaru kobsi iyye kaa sargari, nda gaaru hinka, nda feeji-ize woy boŋ cindi taaci (14) kaŋyaŋ goo nda jiiri foo, i ma tee adabbayaŋ kaŋ ga malal sii. ");
INSERT INTO ses_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","War ma yaarey, nda gaarey, nda feeji-izey taasu sargaroo nda ngi sargari hari-haroo mo kaa, affoo kul nda nga hinnaa nda woo kaŋ kayandi ngi here. ");
INSERT INTO ses_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","War ma jindaaru foo mo kaa zunubu sargari kaŋ manʼti waati kul sargari kukurantaa, nda nga taasu sargaroo, nda nga sargari hari-haroo. ");
INSERT INTO ses_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Zaari yaahantoo hane, war ma margari kokorante tee, war masi goy šenda kul tee. ");
INSERT INTO ses_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","War ma sargari kukurante kaa, a ma tee sargari tonante kaŋ sunnaaraa ga kan Abadantaa se, a ma tee yaaru foo, nda gaaru foo, nda feeji-ize boŋ iyye kaŋyaŋ goo nda jiiri foo, i ma tee adabbayaŋ kaŋ ga malal sii. ");
INSERT INTO ses_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","War ma yaaroo, nda gaaroo, nda feeji-izey taasu sargaroo nda ngi sargari hari-haroo mo kaa, affoo kul nda nga hinnaa nda woo kaŋ kayandi. ");
INSERT INTO ses_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","War ma jindaaru foo mo kaa zunubu sargari kaŋ manʼti waati kul sargari kukurantaa, nda nga taasu sargaroo, nda nga sargari hari-haroo. ");
INSERT INTO ses_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Wey ti hayey kaŋ war gʼi kaa Abadantaa maaɲoo ga war jingarey hane. Sargarey wey sii war meefur sargarey ra, nda sargarey kaŋ war nʼi kaa nda war boŋ, nda war sargari kukurantey, nda war taasu sargarey, nda war sargari hari-harey, nda war alaafiya teendi sargarey ra. ");
INSERT INTO ses_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Musa na hayey kul har Izirayel borey se kaŋ nda Abadantaa nʼa yaamar. ");
INSERT INTO ses_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Musa šelaŋ Izirayel borey alkabiilawey boŋkoyney se ka nee: «Yaamaroo ne kaŋ Abadantaa nʼa har, a nee: ");
INSERT INTO ses_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","‹Nda aru na meefur zaa Abadantaa se, wala a žee ka allaahidu zaa nga jindoo ga, a masi nga šennoo yankar, hayaa kaŋ hun miɲoo ra, a ma woo din da tee.›» ");
INSERT INTO ses_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","Waati kaŋ woy ga tee hondiyaw, a goo nga baabaa do, de a na meefur zaa Abadantaa se, a na allaahidu daŋ nga jindoo ga, ");
INSERT INTO ses_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","de baaboo maa meefuroo nda hayaa kaŋ a nʼa daŋ nga jindoo ga, de baaboo dangay, a mana haya kul har a se, nga meefurey kul goo dogey ra, hayey kul kaŋ a nʼi daŋ nga jindoo ga goo dogoo ra. ");
INSERT INTO ses_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Amma nda hanoo kaŋ baaboo maarʼa, a nʼa ganji, meefurey kul, nda allaahidey kul kaŋ a nʼi daŋ nga jindoo ga kul sii no. Abadantaa ga yaafa a se, zama baaboo nʼa ganji. ");
INSERT INTO ses_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","Nda woy soogaa meefuroo, wala allaahidoo kaŋ a nʼa zaa, šenni yaada ra a nʼa har kʼa daŋ nga jindoo ga, nga banda ga, a hiiji, ");
INSERT INTO ses_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","kurɲoo maarʼa, de kurɲoo dangay, a mana haya kul har a se hanoo kaŋ a maarʼa, nga meefurey goo dogey ra, allaahidey kaŋ a nʼi daŋ nga jindoo ga goo dogey ra. ");
INSERT INTO ses_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Amma nda hanoo kaŋ kurɲoo maarʼa, a nʼa ganji, a na meefuroo tunandi, a na šenni yaadaa tunandi kaŋ a nʼa daŋ nga jindoo ga, Abadantaa ga yaafa a se. ");
INSERT INTO ses_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Amma woy kaŋ kurɲoo buu nda woy kaŋ fay, hayey kul kaŋ a nʼi daŋ nga jindoo ga goo dogey ra. ");
INSERT INTO ses_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","Amma nda woyhiiji na meefur zaa, wala a žee ka allaahidu daŋ nga jindoo ga, ");
INSERT INTO ses_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","nda kurɲoo maarʼa, a mana haya kul har a se, de a manʼa ganji, woyoo meefurey kul goo dogey ra, allaahidu kul kaŋ a nʼa daŋ nga jindoo ga goo dogey ra. ");
INSERT INTO ses_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Amma nda kurɲoo, hanoo hunday kaŋ a maarʼey, a nʼi tunandi kaaray, meefurey kul nda allaahidey kul kaŋ a nʼi daŋ nga jindoo ga sii dogey ra koyne. Kurɲoo nʼi tunandi, Abadantaa ga yaafa a se. ");
INSERT INTO ses_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Meefur kul nda allaahidu kul kaŋ woy nʼa zaa, wala woyoo kayandi ka nga boŋ dii haya ga, kurɲoo ga hin ka yadda a ga wala a mʼa tunandi. ");
INSERT INTO ses_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Nda kurɲoo dangay, a mana haya kul har a se hala subaa ra, meefurey kul nda allaahidey kul kaŋ woyoo nʼi daŋ nga jindoo ga, a yadda i ga, zama hanoo kaŋ a maarʼa, a mana haya kul har a se ");
INSERT INTO ses_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Nda hanoo kaŋ a maarʼa bisa jina a duu kʼi tunandi, a ga woyoo layboo zaa. ");
INSERT INTO ses_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","Wey ti yaamarey kaŋ Abadantaa nʼi har Musa se kurɲe nda wande game, wala baaba nda nga ize woy hondiyaa kaŋ goo a do. ");
INSERT INTO ses_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","«Koy faasa Izirayel borey se ka ngi alhakoo kaa Majaŋ borey ra. Woo banda ga, nʼga koy ni hayragey gar alaahara.» ");
INSERT INTO ses_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Musa šelaŋ jamaa se ka nee: «War ra, aruyaŋ ma wongu jinayyaŋ zaa ka koy Majaŋ borey wongu, ka Majaŋ borey goy futaa alhakoo kaa i ra Abadantaa maaɲoo ga. ");
INSERT INTO ses_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","War ma aru zenber foo (1.000) zaa alkabiila foo kul ra, Izirayel alkabiilawey kul ra kʼi sanba i ma koy wongu.» ");
INSERT INTO ses_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Izirayel boro zenberey ra, i na aru zenber foo (1.000) suuba alkabiila foo kul ra, maanaa wongu-ize zenber woy cindi hinka (12.000). ");
INSERT INTO ses_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Musa nʼi sanba wongoo ra, alkabiila foo kul aru zenber foo (1.000). A na Pinehas, sargari juwalkaa Eleyazar izʼaroo kaŋ ga nongu henanantaa jinawey nda laati beerey kaŋ ga ciya zaa nga kabey ra hangandi i bande. ");
INSERT INTO ses_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","I koy Majaŋ gandaa wongu nda takaa kaŋ nda Abadantaa na Musa yaamar ka arey kul wii. ");
INSERT INTO ses_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Majaŋ borey kokoy guu goo borey ra kaŋ i nʼi wii. Kokoyey ti: Ewi, nda Rekem, nda Sur, nda Hur, nda Reba kaŋ ti Majaŋ kokoy guu. I na Balam, Bewor izʼaroo mo wii nda takuba. ");
INSERT INTO ses_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Izirayel borey na Majaŋ gandaa woyey nda ngi izey kul dii kʼi tee baɲɲayaŋ. I na ngi adabbawey, nda ngi alman kurey, nda ngi almanoo kul taa. ");
INSERT INTO ses_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","I na ngi koyrawey kul kaŋ ra i ga goro nda ngi koyra buuna-buunawey kul ton nuune ra kʼi tee boosu. ");
INSERT INTO ses_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Alganiimaa kul nda hayaa kul, borey nda adabbawey i nʼi zaa ka koy. ");
INSERT INTO ses_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","I koy nda baɲɲey kaŋ i duu ey wongoo ra nda alganiimaa Musa, nda sargari juwalkaa Eleyazar, nda Izirayel borey jamaa do kaŋ goo ma goro Mowab ganganey ra, Žurdeŋ isaa jere, Žeriko tenje. ");
INSERT INTO ses_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Musa, nda sargari juwalkaa Eleyazar, nda jamaa boŋkoyney kul fatta kʼi kubay jamaa kaloo se taray. ");
INSERT INTO ses_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Musa futu wongu-izey jineborey ga kaŋ goo boro zenber foo-foo (1.000) jine, nda wey kaŋ goo boro zangu foo-foo (100) jine kaŋyaŋ hun wongoo ra ka kaa. ");
INSERT INTO ses_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Musa nee i se: «War na woyey kul naŋ i ma huna wala?» ");
INSERT INTO ses_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Nga ne, ngi no Pewor šennoo ra i na Izirayel borey darga Balam šennoo sabbu se kʼi tusa i ma laadir jaŋay tee Abadantaa ga. Woo ka kate bonaa kaŋ Abadantaa jamaa ga. ");
INSERT INTO ses_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Sohõ wa zankaarey kul wii, war ma woyey kul wii kaŋ marga nda aru. ");
INSERT INTO ses_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Amma woy soogey kul kaŋ mana bay ka marga nda aru, wʼi naŋ i ma huna war se. ");
INSERT INTO ses_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","War ma jirbi iyye tee jamaa kaloo se taray, boro kul kaŋ na boro wii, wala a tuku bukaw ga, war ma war zunubey kaa jirbi hinzantoo nda iyyantoo hane, war nda war baɲɲey. ");
INSERT INTO ses_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","War ma bankaarawey kul, nda kuuru jinawey kul, nda hancin hinbiri jinawey kul, nda bundu jinawey kul henanandi. ");
INSERT INTO ses_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Sargari juwalkaa Eleyazar nee wongu-izey kaŋ koy wongoo ra se: «Hayaa ne kaŋ hantumandi ašariyaa ra kaŋ Abadantaa nʼa yaamar Musa se: ");
INSERT INTO ses_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Wura, nda nzorfu kaaray, nda alhan, nda guuru, nda kobinjaama, nda badila hinne, ");
INSERT INTO ses_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","haya kul kaŋ nuune si haya hasara a se, war mʼa daŋ nuune ra a ma henan. Amma henanandi hari no ma haya henanandi kaŋ si hin ka huru nuune ra. War mʼa daŋ haroo din da ra. ");
INSERT INTO ses_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","War ma war bankaarawey ɲumay jirbi iyyantoo hane, war ga henan. Woo banda ga, war ga hin ka huru kaloo ra.» ");
INSERT INTO ses_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","«Ni, nda sargari juwalkaa Eleyazar, nda jamaa hugu boŋey kul, war ma hayaa kabu kaŋ duwandi wongoo ra, adamize nda adabba. ");
INSERT INTO ses_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Alganiimaa zamna ihinka wongu-izey kaŋ koy wongu nda jamaa kul game. ");
INSERT INTO ses_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Wongu-izey kaŋ koy wongu ma haya kaa ngi bagaa ra kʼa noo Abadantaa se. War ma affoo-foo kaa zangu guu (500) foo kul ra, a ma tee adamizey, wala adabba beerey, wala farkey, wala adabba buuney. ");
INSERT INTO ses_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","War mʼi kaa ngi bagaa ra, mʼi noo sargari juwalkaa Eleyazar se i ma tee Abadantaa bagaa. ");
INSERT INTO ses_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Izirayel borey jamaa bagaa, ma affoo-foo zaa woyguu (50) foo kul ra, a ma tee adamizey, wala adabba beerey, wala farkey, wala adabba buuney, wala adabbawey kul ra, mʼi noo Lewi borey se kaŋ ga huga nda Abadantaa gorodogoo goyoo.» ");
INSERT INTO ses_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Musa nda sargari juwalkaa Eleyazar na hayaa tee kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Hayey kaŋ duwandi wongoo ra, woo kaŋ cindi alganiimaa ra kaŋ wongu-izey nʼi dii manʼti kala alman buuna boŋ zenber zangu iddu nda zenber woyye cindi guu (675.000), ");
INSERT INTO ses_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","nda alman beeri kobsi zenber woyye cindi hinka (72.000), ");
INSERT INTO ses_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","nda farka boŋ zenber woydu cindi foo (61.000), ");
INSERT INTO ses_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","nda adamizeyaŋ woy zenber waranza cindi hinka (32.000) kaŋyaŋ mana bay ka marga nda aru. ");
INSERT INTO ses_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Jeroo kaŋ ti borey kaŋ koy wongu bagaa manʼti kala: adabba buuna boŋ zenber zangu hinza nda zenber waranza cindi iyye nda zangu guu (337.500), ");
INSERT INTO ses_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","adabba buuna boŋ zangu iddu nda woyye cindi guu (675) nondi Abadantaa se i ra. ");
INSERT INTO ses_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Adabba beeri kobsi zenber waranza cindi iddu (36.000), adabba kobsi woyye cindi hinka (72) nondi Abadantaa se i ra. ");
INSERT INTO ses_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Farka boŋ zenber waranza nda zangu guu (30.500), farka boŋ woydu cindi foo (61) nondi Abadantaa se i ra. ");
INSERT INTO ses_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Boro zenber woy cindi iddu (16.000), boro waranza cindi hinka (32) nondi Abadantaa se i ra. ");
INSERT INTO ses_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Bagaa kaŋ nondi Abadantaa se, Musa nʼa noo sargari juwalkaa Eleyazar se sanda takaa kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Jeroo kaŋ ti Izirayel borey bagaa nda wongu-izey wanoo kaŋ Musa nʼi kaa cere ra, ");
INSERT INTO ses_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","woo kaŋ ga tee jamaa bagaa ti: adabba buuna boŋ zenber zangu hinza nda zenber waranza cindi iyye nda zangu guu (337.500), ");
INSERT INTO ses_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","nda adabba beeri kobsi zenber waranza cindi iddu (36.000), ");
INSERT INTO ses_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","nda farka boŋ zenber waranza nda zangu guu (30.500), ");
INSERT INTO ses_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","nda boro zenber woy cindi iddu (16.000). ");
INSERT INTO ses_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Jeroo kaŋ nondi Izirayel borey se ra Musa na affoo zaa woyguu (50) foo kul ra kʼa noo Lewi borey se kaŋ ga huga nda Abadantaa gorodogoo goyoo. Musa nʼa tee nda takaa kaŋ nda Abadantaa nʼa yaamar. ");
INSERT INTO ses_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Wongu-ize jamawey jineborey, wongu-ize zenber foo-foo (1.000) jineborey, maanaa wongu-ize zenber foo-foo (1.000) boŋkoyney, nda wongu-ize zangu (100) boŋkoyney man Musa. ");
INSERT INTO ses_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","I nee a se: «Ni tamey na wongaarey kabu kaŋ goo ir hinoo cire, ba affoo mana hun i ra. ");
INSERT INTO ses_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Ir affoo kul, wura jinawey kaŋ ir duu ey ra, ga zeɲi, nda kabehiiri, nda kabekorbay kaŋ ga tammaasa daŋ, nda haŋakorbay, nda jindehiiri kaa Abadantaa se sargari hala zunubu tuusuyanoo ma teendi ir se Abadantaa jine.» ");
INSERT INTO ses_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Musa nda sargari juwalkaa Eleyazar duu taalam jinawey wey kul kaŋ teendi nda wura. ");
INSERT INTO ses_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Wuragoo kul kaŋ wongu-ize zenber foo-foo (1.000) boŋkoyney nda wongu-ize zangu foo-foo (100) boŋkoyney nʼi kaa Abadantaa se tiŋaa manʼti kala kilo zangu nda woyye (170) cine. ");
INSERT INTO ses_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Wongu-izey affoo kul, hayaa kaŋ a nʼa zaa, a nʼa dii nga boŋ se. ");
INSERT INTO ses_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Musa nda sargari juwalkaa Eleyazar na wongu-ize zenber foo-foo (1.000) boŋkoyney nda wongu-ize zangu foo-foo (100) boŋkoyney wuragoo dii ka koy nda ey cere kubayyan hukkumoo ra i ma tee Izirayel borey hongandihayaa Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Rubeŋ izʼarey nda Gad izʼarey goo nda adabba boobo-booboyaŋ. I dii Yazer gandaa nda Galad gandaa, nga ne, gandaa ga boori adabba se. ");
INSERT INTO ses_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Gad izʼarey nda Rubeŋ izʼarey koy Musa, nda sargari juwalkaa Eleyazar, nda jamaa boŋkoyney do ka nee: ");
INSERT INTO ses_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","«Atarot, nda Diboŋ, nda Yazer, nda Nimra, nda Hešboŋ, nda Elale, nda Sebam, nda Nebo, nda Bewoŋ, ");
INSERT INTO ses_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","gandaa woo kaŋ ga Abadantaa na Izirayel borey noo hini manʼti kala kurdoo henna. Aywa, ir goo nda adabba.» ");
INSERT INTO ses_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","I nee: «Alhormo tee ir se, gandaa woo ma nondi ir se a ma tee ir wane, masi naŋ ir ma bisa ka Žurdeŋ isaa deŋ.» ");
INSERT INTO ses_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Musa nee Gad izʼarey nda Rubeŋ izʼarey se: «War armey ga koy wongu, amma war hunday ga goro ne ra! ");
INSERT INTO ses_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Macin se war ga Izirayel borey biney kaa i masi bisa ka koy gandaa ra kaŋ Abadantaa nʼa noo i se? ");
INSERT INTO ses_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Woo da no war baabey nʼa tee waatoo kaŋ i goo Kadeš-Barneya, ay nʼi sanba i ma gandaa guna. ");
INSERT INTO ses_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","I žigi ka koy hala Eškol gooroo ra, gandaa gunayanoo banda ga, i na Izirayel borey biney kaa hala i masi duu ka huru gandaa ra kaŋ Abadantaa nʼa noo i se. ");
INSERT INTO ses_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Hanoo din, Abadantaa futu i ga, a žee ka nee: ");
INSERT INTO ses_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‹Arey kaŋ hun Misira kaŋ goo nda jiiri waranka (20) nda ka žigi, abada i si dii gandaa kaŋ ay žee kaŋ ay gʼa noo Ibirahima, nda Isiyaka, nda Yakuba se, zama i manʼay gana nda fondaa, ");
INSERT INTO ses_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","nda manʼti Kaleb, Yefune izʼaroo kaŋ ti Kenaz boro nda Žozuwe, Nun izʼaroo hinne kaŋ nʼay gana nda fondaa.› ");
INSERT INTO ses_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Abadantaa futu Izirayel ga, a nʼi yaarandi saajoo ra jiiri woytaaci (40) hala waatoo kaŋ ra alwaddaa din borey kul ben kaŋ na goy futu tee Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","War mo, war tun kate war baabey dogey ra ka tee zunubu teekawyaŋ ka tonton Abadantaa futuyanoo ga Izirayel here! ");
INSERT INTO ses_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Zama nda war wanji ka hanga a, a ga Izirayel borey naŋ i ma gay saajoo ra koyne, de war ga tee addalil kaŋ na jamaa woo kul halaci.» ");
INSERT INTO ses_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Arey din man Musa ka nee: «Ir ga baa ir ma kaliyaŋ cin ne ra ir alman buuney se nda koyrayaŋ ir izey se. ");
INSERT INTO ses_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Dogoo din da ir ga wongu jinayyaŋ zaa ka huru Izirayel borey jine kʼi ka koy hala ngi dogoo ra. Ir izey hinne ga goro koyra gaabanteyaŋ ra, gandaa din borey maaganda se. ");
INSERT INTO ses_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Ir si yee ir hugey do nda manʼti Izirayel borey affoo kul nka duu nga tuboo. ");
INSERT INTO ses_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Ir si tubu kul dii i ga Žurdeŋ isaa se banda, zama ir duu ir tuboo Žurdeŋ isaa se ne da here waynahunay here.» ");
INSERT INTO ses_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Musa nee i se: «Nda war na woo tee, nda war na wongu jinawey zaa Abadantaa jine ka koy wongu, ");
INSERT INTO ses_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","nda war kul na wongu jinawey zaa ka Žurdeŋ isaa deŋ ka bisa Abadantaa jine ka nga iberey kul gaaray kʼi kaa a jine, ");
INSERT INTO ses_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","nda war koy wongu ka hin gandaa din kʼa daŋ Abadantaa cire, woo banda ga, war ga yee. Woo ra war ga henan Abadantaa here, war ga henan Izirayel here. Gandaa woo ga tee war wane Abadantaa jine. ");
INSERT INTO ses_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Amma nda war mana woo tee, nga ne, war na zunubu tee Abadantaa ga, de war ma bay kaŋ war ga duu war zunuboo alhakoo. ");
INSERT INTO ses_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Adiši war ma koyrayaŋ cin war izey se, ka kaliyaŋ tee war alman buuney se, de war ma hayaa tee kaŋ war miɲey nʼa har.» ");
INSERT INTO ses_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Gad izʼarey nda Rubeŋ izʼarey nee Musa se: «Haya kaŋ ir koyoo nʼa har, ni tamey gʼa tee. ");
INSERT INTO ses_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Ir izey nda ir wandey, nda ir alman kurey, nda ir adabbawey kul ga cindi ne, Galad koyrawey ra. ");
INSERT INTO ses_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Ni tamey, borey kul kaŋ na wongu jinawey zaa ga bisa Abadantaa jine wongoo ra, sanda takaa kaŋ nda ni kaŋ ti ir koyoo nʼa har.» ");
INSERT INTO ses_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Musa šelaŋ sargari juwalkaa Eleyazar, nda Žozuwe, Nun izʼaroo, nda Izirayel borey alkabiilawey hugu boŋey se Rubeŋ nda Gad borey takaa ga. ");
INSERT INTO ses_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Musa nee i se: «Nda Gad izʼarey nda Rubeŋ izʼarey na Žurdeŋ isaa deŋ war bande, nda i kul na wongu jinawey zaa ka wongu Abadantaa jine, ka kate war hin gandaa, war mʼi noo Galad gandaa a ma tee ngi wane. ");
INSERT INTO ses_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Amma nda i mana wongu jinawey zaa ka deŋ war bande, i ma duu doo war game Kanaŋ gandaa ra.» ");
INSERT INTO ses_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Gad izʼarey nda Rubeŋ izʼarey zaabi ka nee: «Haya kaŋ Abadantaa nʼa har ni tamey se, ir gʼa tee. ");
INSERT INTO ses_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Ir ga wongu jinawey zaa Abadantaa jine ka bisa Kanaŋ gandaa ra, amma ir bagaa tuboo si tee kala Žurdeŋ se ne da here.» ");
INSERT INTO ses_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Musa na Amor borey kokoyoo Sihoŋ laamaa nda Bašaŋ kokoyoo Og laamaa, maanaa gandaa, nda nga koyrawey, nda ngi laboo, nda koyrawey kaŋ gʼi kuubi kʼi bere noo Gad izʼarey, nda Rubeŋ izʼarey, nda Manase kaŋ ti Isufi izʼaroo alkabiila jeraa se. ");
INSERT INTO ses_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Gad izʼarey na Diboŋ, nda Atarot, nda Aroyer koyrawey cin taaga, ");
INSERT INTO ses_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","nda Atorot-Šofaŋ, nda Yazer, nda Yogboha, ");
INSERT INTO ses_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","nda Bet-Nimra, nda Bet-Haraŋ, i nʼi tee koyra gaabanteyaŋ, i na kaliyaŋ tee ngi alman buuney se. ");
INSERT INTO ses_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Rubeŋ izʼarey na Hešboŋ, nda Elale, nda Kiryatayim koyrawey cin taaga, ");
INSERT INTO ses_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","nda Nebo, nda Bal-Mewoŋ, koyrawey kaŋ i na maaɲey barmay, nda Sibma. I na maa daŋ koyrawey kaŋ i nʼi cin ga. ");
INSERT INTO ses_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Makir kaŋ ti Manase izʼaroo, izʼarey koy Galad gandaa taa. Amor borey kaŋ goo a ra, i nʼi gaaray. ");
INSERT INTO ses_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Musa na Galad gandaa noo Makir, Manase izʼaroo se, i goro a ra. ");
INSERT INTO ses_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Yahir kaŋ ti Manase izʼaru koy ngi koyra buuna-buunawey taa i kone, a na maaɲoo daŋ Yahir koyra buuna-buunawey. ");
INSERT INTO ses_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Noba mo koy Kenat koyraa nda koyra kanbey taa ka nga boŋ maaɲoo Noba daŋ a ga. ");
INSERT INTO ses_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Izirayel borey naarumaa ra ka fatta Misira gandaa ra, wongu-ize ka koy wongu-ize, Musa nda Haruna ti ngi jineborey. Nongey kaŋ ra i kay-kay ti wey. ");
INSERT INTO ses_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Ngi fattaroo ra, Musa na nongey hantum kaŋ ra i kay-kay Abadantaa yaamaroo ga. Nongey ne kaŋ ra i kay-kay ngi naarumaa ra: ");
INSERT INTO ses_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","I tun Ramses handu jinaa ra, handu jinaa jirbi woy cindi guwantoo (15to) hane. Borcintaraa jingaroo subaa ra, Izirayel borey fatta, haya kul manʼi ganji Misira borey kul jine. ");
INSERT INTO ses_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Ka gar Misira borey goo ma ngi borey fiji kaŋ Abadantaa nʼi kar i ra, maanaa gunde jinawey kul. Abadantaa ka nga ciitoo kaŋandi ngi koyey boŋ. ");
INSERT INTO ses_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Izirayel borey hun Ramses ka koy goro Sukot. ");
INSERT INTO ses_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","I hun Sukot ka koy goro Etam kaŋ goo saajoo miɲoo ga. ");
INSERT INTO ses_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","I hun Etam ka kuubi ka willi ka koy Pi-Hayrot kaŋ goo Bal-Sefoŋ tenje, ka goro Migdol jine. ");
INSERT INTO ses_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","I hun Pi-Hayrot ka bisa teekoo game ka koy saajoo here. I na jirbi hinza diray tee Etam saajoo ra ka koy goro Mara. ");
INSERT INTO ses_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","I hun Mara ka koy too Elim. Hariɲaa woy cindi hinka (12) nda teenayɲaa woyye (70) goo Elim, no din ra i goro. ");
INSERT INTO ses_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","I hun Elim ka koy goro Kakaarey teekoo jere. ");
INSERT INTO ses_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","I hun Kakaarey teekoo jere ka koy goro Sin saajoo ra. ");
INSERT INTO ses_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","I hun Sin saajoo ra ka koy goro Dofka ");
INSERT INTO ses_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","I hun Dofka ka koy goro Aluš. ");
INSERT INTO ses_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","I hun Aluš ka koy goro Refidim. Jamaa mana duu haŋ hari no din. ");
INSERT INTO ses_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","I hun Refidim ka koy goro Sinay saajoo ra. ");
INSERT INTO ses_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","I hun Sinay saajoo ra ka koy goro Kiworot-Hataawa. ");
INSERT INTO ses_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","I hun Kiworot-Hataawa ka koy goro Haserot. ");
INSERT INTO ses_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","I hun Haserot ka koy goro Ritma. ");
INSERT INTO ses_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","I hun Ritma ka koy goro Rimoŋ-Peres. ");
INSERT INTO ses_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","I hun Rimoŋ-Peres ka koy goro Libna. ");
INSERT INTO ses_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","I hun Libna ka koy goro Risa. ");
INSERT INTO ses_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","I hun Risa ka koy goro Keheleta. ");
INSERT INTO ses_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","I hun Keheleta ka koy goro Šefer tondi hondoo do. ");
INSERT INTO ses_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","I hun Šefer tondi hondoo do ka koy goro Harada. ");
INSERT INTO ses_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","I hun Harada ka koy goro Makelot. ");
INSERT INTO ses_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","I hun Makelot ka koy goro Tahat. ");
INSERT INTO ses_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","I hun Tahat ka koy goro Tera. ");
INSERT INTO ses_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","I hun Tera ka koy goro Mitka. ");
INSERT INTO ses_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","I hun Mitka ka koy goro Hašmona. ");
INSERT INTO ses_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","I hun Hašmona ka koy goro Moserot. ");
INSERT INTO ses_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","I hun Moserot ka koy goro Bene-Yakaŋ. ");
INSERT INTO ses_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","I hun Bene-Yakaŋ ka koy goro Hor-Gidgad. ");
INSERT INTO ses_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","I hun Hor-Gidgad ka koy goro Yotbata. ");
INSERT INTO ses_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","I hun Yotbata ka koy goro Abirona. ");
INSERT INTO ses_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","I hun Abirona ka koy goro Esiyoŋ-Geber. ");
INSERT INTO ses_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","I hun Esiyoŋ-Geber ka koy goro Tisin saajoo ra, maanaa Kadeš. ");
INSERT INTO ses_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","I hun Kadeš ka koy goro Hor tondi hondoo do, Edom gandaa benantaa ga. ");
INSERT INTO ses_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Sargari juwalkaa Haruna žigi Hor tondi hondoo boŋ Abadantaa yaamaroo ga. A buu no din Izirayel borey fattaroo Misira gandaa ra banda ga jiiri woytaacantoo (40to), handu guwantoo, zaari jinaa ra. ");
INSERT INTO ses_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Haruna sii nda kala jiiri zangu nda waranka cindi hinza (123) waatoo kaŋ a buu Hor tondi hondoo boŋ. ");
INSERT INTO ses_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Arad kokoyoo kaŋ ti Kanaŋ boro kaŋ ga goro gurma here Kanaŋ gandaa ra maa Izirayel borey kaayanoo. ");
INSERT INTO ses_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","I hun Hor tondi hondoo do ka koy goro Salmona. ");
INSERT INTO ses_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","I hun Salmona ka koy goro Punoŋ. ");
INSERT INTO ses_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","I hun Punoŋ ka koy goro Obot. ");
INSERT INTO ses_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","I hun Obot ka koy goro Iye-Abarim kaŋ goo Mowab gandaa hirroo ga. ");
INSERT INTO ses_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","I hun Iye-Abarim ka koy goro Diboŋ-Gad. ");
INSERT INTO ses_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","I hun Diboŋ-Gad ka koy goro Almoŋ-Diblatayim. ");
INSERT INTO ses_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","I hun Almoŋ-Diblatayim ka koy goro Abarim tondi hondey do Nebo tondi hondoo tenje. ");
INSERT INTO ses_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","I hun Abarim tondi hondey do ka koy goro Mowab ganganey ra, Žurdeŋ isaa jere, Žeriko tenje. ");
INSERT INTO ses_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","I koy goro Žurdeŋ isaa jere, kʼa dii Bet-Yešimot hala Abel-Šitim, Mowab ganganey ra. ");
INSERT INTO ses_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Mowab ganganey ra kaŋ goo Žurdeŋ isaa jere, Žeriko tenje, Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","«Šelaŋ Izirayel borey se, nee i se: ‹Waati kaŋ war na Žurdeŋ isaa deŋ ka huru Kanaŋ gandaa ra, ");
INSERT INTO ses_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","war ma gandaa borey kul gaaray war jine, war ma ngi tondi toorey kul derandi, ka assuurawey kaŋ i nʼi tee nda guuru mennante kaŋ i gʼi gana kul derandi, ka tooru ganadogey kul halaci. ");
INSERT INTO ses_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","War ma gandaa mayray, ka goro a ra, zama war se ay na gandaa woo noo a ma tee war mayray. ");
INSERT INTO ses_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","War ma alkurra kar ka gandaa kaŋ ti war tuboo zamna, alaayan beeri foo kul nda nga bagaa. Alkabiila beeri, war ma baa beeri kaa a se. Alkabiila kaccu, war ma baa kaccu kaa a se. Affoo kul ga duu nongoo kaŋ ga a kaŋ alkurraa ra. War ga duu baa ka sawa nda war baabey alkabiilawey. ");
INSERT INTO ses_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Amma nda war mana gandaa borey gaaray war jine, wey kaŋ war nʼi naŋ i ra ga tee karji war moɲey ra nda naaji war carawey ra. I ga war farandi gandaa kaŋ ra war ga goro. ");
INSERT INTO ses_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Nda woo mana tee, hayaa kaŋ ay baa yʼa tee i se, ay gʼa tee war se.›» ");
INSERT INTO ses_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","«Izirayel borey yaamar, ma nee i se: ‹Waati kaŋ war huru Kanaŋ gandaa ra, nongoo kaŋ ga tee war se tubuhaya ne: Kanaŋ gandaa nda nga hirrey. ");
INSERT INTO ses_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Gurma here kaboo ga šintin Tisin saajoo do Edom jere. War gurma here hirroo ga šintin dandi here teeko Ciiri-ciirantaa benantaa ga. ");
INSERT INTO ses_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","War hirroo ga kuubi ka koy žigi Dontoney žigidogoo gurma here ka bisa Tisin ka koy too Kadeš-Barneya gurma here, a ga koy Hasar-Adar ka bisa nda Asmoŋ. ");
INSERT INTO ses_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Kʼa dii Asmoŋ ka koy kuubi Misira gooroo here ka too teekoo do. ");
INSERT INTO ses_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Dangay here war gandaa hirroo ga tee teeko Beeroo. Nga ti war dangay here hirroo. ");
INSERT INTO ses_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Hawsa here war gandaa hirroo ga šintin teeko Beeroo ga ka koy hala Hor tondi hondoo do. ");
INSERT INTO ses_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Kʼa dii za Hor tondi hondoo do ka too Hamat miɲoo ga hala hirroo ma too Sedad here. ");
INSERT INTO ses_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Hirroo ga koy Zifroŋ here ka too Hasar-Enaŋ. Woo ti war hirroo hawsa here. ");
INSERT INTO ses_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Waynahunay here war ma hirroo kayandi kʼa dii Hasar-Enaŋ ka koy Šefam. ");
INSERT INTO ses_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Hirroo ga zunbu ka hun Šefam ka koy Ribla here, dandi here Ayin, a ga zunbu ka koy tuku Genezaret haroo guraa dandi here. ");
INSERT INTO ses_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Koyne mo a ga zunbu ka koy Žurdeŋ isaa here ka koy too teeko Ciiri-ciirantaa do. Takaa woo no war gandaa ga ti a, nga nda nga hirrey kaŋ gʼa kuubi.›» ");
INSERT INTO ses_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Musa na Izirayel borey yaamar ka nee: «Woo ti gandaa kaŋ war ga alkurra kar ka duu a, gandaa kaŋ Abadantaa nee nga gʼa noo alkabiila yaggaa nda jeraa se. ");
INSERT INTO ses_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Zama Rubeŋ borey alkabiilaa izey, hugu ka koy hugu, nda Gad borey alkabiilaa izey, hugu ka koy hugu duu ngi bagaa tuboo. Manase alkabiila jeraa mo duu nga bagaa. ");
INSERT INTO ses_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Alkabiila hinkaa woo nda alkabiila jeraa duu ngi bagaa tuboo Žurdeŋ isaa se ne da here, Žeriko jere dandi here, waynahunay here.» ");
INSERT INTO ses_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","«Arey kaŋ ga gandaa zamna war game maaɲey ne: sargari juwalkaa Eleyazar, nda Žozuwe, Nun izʼaroo. ");
INSERT INTO ses_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","War ma boŋkoyni foo-foo zaa alkabiila foo kul ra i ma gandaa zamna. ");
INSERT INTO ses_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Boŋkoyney maaɲey ne: Žuda alkabiilaa ra, Kaleb, Yefune izʼaroo, ");
INSERT INTO ses_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Simewoŋ borey alkabiilaa ra, Šemuwel, Amihud izʼaroo, ");
INSERT INTO ses_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Benžameŋ alkabiilaa ra, Elidad, Kisloŋ izʼaroo, ");
INSERT INTO ses_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Dan borey alkabiilaa ra, boŋkoynoo Buki, Yogli izʼaroo, ");
INSERT INTO ses_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Isufi borey, Manase izʼarey alkabiilaa ra, boŋkoynoo Haniyel, Efod izʼaroo, ");
INSERT INTO ses_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Efrayim borey alkabiilaa ra, boŋkoynoo Kemuwel, Šiftaŋ izʼaroo, ");
INSERT INTO ses_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Zabuloŋ borey alkabiilaa ra, boŋkoynoo Elisafaŋ, Parnak izʼaroo, ");
INSERT INTO ses_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Isakar borey alkabiilaa ra, boŋkoynoo Paltiyel, Azaŋ izʼaroo, ");
INSERT INTO ses_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Ašer borey alkabiilaa ra, boŋkoynoo Ahihud, Šelomi izʼaroo, ");
INSERT INTO ses_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Neftali borey alkabiilaa ra, boŋkoynoo Pedahel, Amihud izʼaroo.» ");
INSERT INTO ses_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Wey ti arey kaŋ Abadantaa nʼi yaamar i ma Kanaŋ gandaa zamna Izirayel borey game, a ma tee ngi tuboo. ");
INSERT INTO ses_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Abadantaa šelaŋ Musa se Mowab ganganey ra, Žurdeŋ isaa jere, Žeriko tenje ka nee: ");
INSERT INTO ses_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","«Izirayel borey yaamar ngi tuboo ra i ma koyrayaŋ noo Lewi borey se kaŋ ra i ga goro, war mʼi noo hawsa mo koyrawey dumawey ga. ");
INSERT INTO ses_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Koyrawey ga tee ngi wane, i ga goro i ra, hawsawey ga tee ngi adabbawey, nda ngi kabehayey, nda ngi almaney wane. ");
INSERT INTO ses_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Koyrawey hawsawey kaŋ war gʼi noo Lewi borey se ma hun cetaa tarayhere ga kʼa kuubi kʼa bere ma tee kabedaaru zenber foo (1.000). ");
INSERT INTO ses_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","War ma neeši koyraa se taray, dandi here kaboo ma tee kabedaaru zenber hinka (2.000), gurma here kaboo ma tee kabedaaru zenber hinka (2.000), dangay here kaboo ma tee kabedaaru zenber hinka (2.000), hawsa here kaboo ma tee kabedaaru zenber hinka (2.000). Koyraa goo gamoo ra. Wey ti ngi koyrawey hawsawey. ");
INSERT INTO ses_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Koyrawey kaŋ war gʼi noo Lewi borey se ra, war mʼi noo koyra iddu kaŋ ga boro ga nga boŋ talfi kaŋ ra boro kaŋ na boro wii ga hin ka zuru ka koy, nda koyra woytaaci cindi hinka (42) tana kʼi tonton i ga. ");
INSERT INTO ses_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Koyrawey kul kaŋ war gʼi noo Lewi borey se manʼti kala koyra woytaaci cindi yaaha (48) nda ngi hawsawey. ");
INSERT INTO ses_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Koyrawey wey kaŋ war gʼi kaa Izirayel borey tuboo ra kʼi nondi, wey kaŋ goo nda iboobo ga iboobo noo, wey kaŋ goo nda ikaccu ga ikaccu noo. Alkabiila foo kul ga Lewi borey noo ka sawa nda tuboo kaŋ a duu a beeriyanoo.» ");
INSERT INTO ses_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Abadantaa šelaŋ Musa se ka nee: ");
INSERT INTO ses_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","«Šelaŋ Izirayel borey se, nee i se: ‹Waati kaŋ war na Žurdeŋ isaa deŋ ka huru Kanaŋ gandaa ra, ");
INSERT INTO ses_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","war ma koyrayaŋ suuba kaŋyaŋ ga tee war se koyrayaŋ kaŋyaŋ ga boro ga nga boŋ talfi. Boro kaŋ firka ka boro wii ga zuru ka koy a ra. ");
INSERT INTO ses_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Koyrawey wey ga tee war se nongu kaŋ ra boro ga nga boŋ talfi ka hallasi boraa kaŋ ga ni ceeci. Boro wiikaa si buu nda a mana kaa jina jamaa jine ka ciitandi. ");
INSERT INTO ses_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Koyrawey kaŋ war gʼi noo ra, koyra iddu ga tee koyrayaŋ kaŋ ga boro ga nga boŋ talfi. ");
INSERT INTO ses_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","War ma koyra hinza zaa Žurdeŋ isaa se ne da here, war ma koyra hinza zaa Kanaŋ gandaa ra. Wey no ma tee koyrawey kaŋ ga boro ga nga boŋ talfi. ");
INSERT INTO ses_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Koyra idduwaa woo ga tee Izirayel borey se koyrayaŋ kaŋ ga boro ga nga boŋ talfi, nda yawey, nda borey kaŋ ga waati tee i do kaŋ goo i game. Boro kul kaŋ firka ka boro wii ga hin ka zuru ka koy nga boŋ talfi no din. ");
INSERT INTO ses_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Nda boro na guuru haya ka boro kar, de boraa buu, boro wiikaw no, boro wiikaa šikka sii ga wiiyandi. ");
INSERT INTO ses_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Nda a nʼa kar nda tondi kaŋ ga hin kʼa wii, de a buu, boro wiikaw no, boro wiikaa šikka sii ga wiiyandi. ");
INSERT INTO ses_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Nda a nʼa kar nda bundu haya kaŋ ga hin kʼa wii, de a buu, boro wiikaw no, boro wiikaa šikka sii ga wiiyandi. ");
INSERT INTO ses_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Bukaa faasakaa, nga no ma boro wiikaa wii, za a nʼa kubay, a mʼa wii. ");
INSERT INTO ses_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Nda boro na boro tuti nda konnaray, nda miile futay kʼa warra nda haya, de a buu, ");
INSERT INTO ses_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","wala nda a na kabe kʼa kar nda binefutay, de a buu, boraa kaŋ kara šikka sii ga wiiyandi, boro wiikaw no, boraa kaŋ ga hima ka faasa bukaa se, nga no ma boro wiikaa wii za a nʼa kubay. ");
INSERT INTO ses_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","Amma nda boro mana bay a na boro tuti bila konnaray, wala a nʼa warra nda haya kul kaŋ no bila miile futay, ");
INSERT INTO ses_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","wala nda a na tondi kaŋandi a boŋ bila nda murayyan kaŋ ga hin kʼa wii, de a buu, ka gar manʼti nga iberoo no, de mo a si ceeci nga ma ifutu tee a se, ");
INSERT INTO ses_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","jamaa ga ciiti boraa kaŋ kara nda bukaa faasakaa game ka sawa nda hantumey kaŋ kayandi wey. ");
INSERT INTO ses_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Jamaa ga boro wiikaa kaa bukaa faasakaa kaboo ra. Jamaa gʼa ka yee koyraa ra kaŋ ra a zuru ka koy nga boŋ talfi. A ga cindi no din hala waati kaŋ ra sargari juwalkaw beeroo kaŋ yonandi nda jii henanantaa buu. ");
INSERT INTO ses_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Nda boro wiikaa bisa koyraa kaŋ ra a zuru ka nga boŋ talfi hirrey ga, ");
INSERT INTO ses_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","de bukaa faasakaa duu a koyraa kaŋ ga a na nga boŋ talfi hirrey banda ga, nda bukaa faasakaa na boro wiikaa wii, i sʼa hãa nda nga kuroo alhakoo. ");
INSERT INTO ses_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Zama boro wiikaa mma hima ka cindi koyraa ra kaŋ ga a na nga boŋ talfi hala waati kaŋ sargari juwalkaw beeroo buu. Sargari juwalkaw beeroo buuyanoo banda ga, a ga hin ka yee nga boŋ laboo ra. ");
INSERT INTO ses_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Woo ti hantum kaŋ kayandi hantumante war alwaddawey se, nongu kul kaŋ ra war goro. ");
INSERT INTO ses_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Boro kul kaŋ na boro wii, boro wiikaa ga wiiyandi seedeyaŋ meešennoo ga. Boro folloku seedetaraa si wasa ka boro zukandi hala a ma buu. ");
INSERT INTO ses_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","War masi yadda ka alhaku dii ka boro wiikaa kaŋ ga hima ka buu naŋ, šikka sii a ga wiiyandi. ");
INSERT INTO ses_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","War masi yadda ka alhaku dii kʼa noo fondo a ma zuru ka koy nga boŋ talfi koyraa ga, de a ma duu ka yee kate ka goro labu follokaa ra sargari juwalkaa buuyanoo banda ga. ");
INSERT INTO ses_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","War masi gandaa kaynandi kaŋ ra war ga goro, zama kuri no ma gandaa kaynandi. Boro si hin ka kuroo kaŋ mun gandaa ra zunuboo tuusu nda manʼti kala nda boraa kaŋ nʼa mun kuroo. ");
INSERT INTO ses_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Masi gandaa žiibandi kaŋ ra war ga goro, kaŋ game ay ga goro. Zama agay ti Abadantaa, ay ga goro Izirayel borey game.›» ");
INSERT INTO ses_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Manase izʼaroo Makir, Makir izʼaroo Galad, Galad izʼarey alaayan beerey kaŋyaŋ ti Isufi izʼarey alaayan beerey ra man Musa, nda boŋkoyney, nda Izirayel borey hugu boŋey do ka šelaŋ i se. ");
INSERT INTO ses_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","I nee: «Ir koyoo, Abadantaa nka ni yaamar ma alkurra kar ka Izirayel borey noo gandaa sanda ngi tuboo. Abadantaa na ni yaamar mo mʼir armaa Selofad tuboo noo nga ize woyey se. ");
INSERT INTO ses_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Nda i hiiji Izirayel borey alkabiila tana foo izey aru, ngi tuboo ga hun ir baabey tuboo ra ka koy tonton alkabiilaa kaŋ ra i ga koy huru wanoo ga. Woo ra tuboo kaŋ alkurraa nʼa noo ir se, haya ga hun a ra. ");
INSERT INTO ses_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Waati kaŋ Izirayel borey Sawalyanoo jiiroo too, ngi tuboo ga tonton alkabiilaa kaŋ wane nda ey tuboo ga, ngi tuboo ga hun ir baabey alkabiilaa tuboo ra.» ");
INSERT INTO ses_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Musa na Izirayel borey yaamar nda hayaa kaŋ Abadantaa nʼa har. A nee: «Isufi borey alkabiilaa ga cum. ");
INSERT INTO ses_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Šennoo ne kaŋ Abadantaa nʼa har Selofad ize woyey se: ‹I ma hiiji boro kaŋ i baa, amma i ma tee ngi baabaa alaayan beeroo ra boro wande, ");
INSERT INTO ses_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","hala Izirayel borey ra, tubu si hun alkabiila foo kone ka koy tee affoo wane. Izirayel borey affoo kul ga hawa nga alkabiilaa tuboo ga. ");
INSERT INTO ses_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Ize woy kul kaŋ duu tubu Izirayel borey alkabiilawey ra ma hiiji boro kaŋ goo baaboo alkabiilaa alaayan beeri ra hala Izirayel boro kul ma nga baabey tuboo tubu. ");
INSERT INTO ses_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Tubuhaya kul si hun alkabiilaa foo kone ka koy alkabiilaa tana do, Izirayel borey alkabiila foo kul ma hawa nga tuboo ga.›» ");
INSERT INTO ses_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Selofad ize woyey nʼa tee nda takaa kaŋ nda Abadantaa na Musa yaamar. ");
INSERT INTO ses_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Mahila, nda Tirsa, nda Hogla, nda Milka, nda Nowa, Selofad ize woyey hiiji ngi baabaa armey izʼarey. ");
INSERT INTO ses_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","I mana hiiji kala Manase kaŋ ti Isufi izʼaroo, izʼarey alaayan beerey ra, woo ra ngi tuboo cindi ngi baabaa borey alaayan beeroo ra. ");
INSERT INTO ses_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Wey ti yaamarey nda hantumey kaŋ kayandi kaŋ nda Abadantaa na Musa kʼi yaamar a mʼi noo Izirayel borey se Mowab ganganey ra, Žurdeŋ isaa jere, Žeriko tenje.");
INSERT INTO ses_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Šenney ti wey kaŋ Musa nʼi har Izirayel kul se Žurdeŋ isaa se banda, saajoo ra, Ganganoo gandaa ra, Suf tenje, Paraŋ nda Tofel, nda Labaŋ, nda Haserot, nda Di-Zahab game. ");
INSERT INTO ses_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Jirbi woy cindi foo (11) diray ti ka hun Horeb tondi hondoo do ka bisa Seyir gandaa tondi hondoo here ka koy Kadeš-Barneya. ");
INSERT INTO ses_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Jiiri woytaacantoo (40to) handu woy cindi faantoo (11to) zaari jinaa ra, Musa šelaŋ Izirayel borey se nda takaa hunday kaŋ nda Abadantaa nʼa yaamar a mʼa har i se. ");
INSERT INTO ses_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Woo teendi kaŋ a na Amor borey kokoyoo Sihoŋ kaŋ ga goro Hešboŋ, nda Bašaŋ gandaa kokoyoo Og kaŋ ga goro Aštarot koyraa ra nda Edreyi koyraa ra kar ka hin ey. ");
INSERT INTO ses_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Kaŋ i goo Žurdeŋ isaa se banda, Mowab gandaa ra, waatoo din no Musa šintin ka ašariyaa woo fahamandi Izirayel borey se. A nee: ");
INSERT INTO ses_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","«Horeb tondi hondoo do, Abadantaa, ir Koyoo nee ir se: ‹War hanse ka gay tondi hondoo woo jere. ");
INSERT INTO ses_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Wa kuubi ka koy, wa huru Amor borey tondi hondoo ra nda ngi taalammey kul do Ganganoo gandaa ra, tondi hondoo ra, hondey gandaa here ra, gurmaa ra, teekoo guraa ga, Kanaŋ borey gandaa nda Libaŋ, ka koy hala Efrat isa beeroo do. ");
INSERT INTO ses_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Guna, ay na gandaa daŋ war jine, wa huru, gandaa ma tee war wane kaŋ Abadantaa nʼa žee war baabey Ibirahima, nda Isiyaka, nda Yakuba se kaŋ nga gʼa noo ngi nda ngi hayroo kaŋ ga kaa dumawey ga se.›» ");
INSERT INTO ses_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","«Alwaatoo din, ay nee war se: ‹Agay hinne si hin ka war zaa. ");
INSERT INTO ses_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Abadantaa, war Koyoo na war boobandi, nga ne, hõ war ga boobo sanda beenaa handarawey. ");
INSERT INTO ses_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Yala Abadantaa, ir baabey Koyoo ma war boobandi cee zenber (1.000) ka bisa hõ hinnaa, de a ma albarka daŋ war ra nda takaa kaŋ nda a nʼa har war se. ");
INSERT INTO ses_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Taka foo nda agay hinne ga hin ka war šugullawey nda war yenjewey jeejaa zaa? ");
INSERT INTO ses_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Wa aru lakkalkoyniyaŋ suuba war ra kaŋyaŋ goo nda bayray, kaŋyaŋ ga bayrandi war alkabiilawey ra, ay gʼi daŋ war jine sanda alwakiiliyaŋ.› ");
INSERT INTO ses_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","War nʼay zaabi ka nee: ‹Woo kaŋ ni nee ir mʼa tee ga boori.› ");
INSERT INTO ses_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Woo ra ay na war alkabiilawey boŋkoyney zaa, aru lakkalkoyniyaŋ kaŋ ga bayrandi, ay nʼi daŋ war jine sanda boro zenber foo (1.000) se boŋkoyni, nda boro zangu foo (100) se boŋkoyni, nda boro woyguu (50) se boŋkoyni, nda boro woy (10) se boŋkoyni, nda war alkabiilawey goy juwalkey. ");
INSERT INTO ses_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Waati follokaa din da ra, ay na war alkaaley yaamar ka nee i se: ‹War ma haŋajer war armey se, war ma ciiti nda šerretaray aru nda nga armaa wala yaw game kaŋ goo a do. ");
INSERT INTO ses_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","War masi boro guna ciitiyan ra. War ma haŋajer ikaccaa nda ibeeroo se. War masi hunbur adamize kul, zama ciitiyan manʼti kala Irkoy wane. Haya kaŋ šendi war se, war ma kate a ay do hala ya maarʼa.› ");
INSERT INTO ses_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Alwaatoo woo, hayey kul kaŋ war ga hima kʼi tee, ay nʼi kul har war se.» ");
INSERT INTO ses_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","«Woo banda ga, Abadantaa, ir Koyoo yaamaroo ga, ir hun Horeb tondi hondoo do ka saaji beeri hunburantaa woo kul kaŋ war dii a dunbu ka bisa, ka hanga fondaa kaŋ ga koy Amor borey tondi hondey do, ir too Kadeš-Barneya. ");
INSERT INTO ses_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Ay nee war se: ‹War too Amor borey tondi hondoo do kaŋ Abadantaa, ir Koyoo gʼa noo ir se. ");
INSERT INTO ses_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Guna, Abadantaa, ni Koyoo na gandaa daŋ ni jine, žigi ka koy mʼa zaa a ma tee ni wane sanda takaa kaŋ nda Abadantaa, ni baabey Koyoo nʼa har ma ne. Masi hunbur, ni binoo masi dunbu.› ");
INSERT INTO ses_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","War man agay ka nee: ‹Ir ma aruyaŋ sanba ir jine i ma gandaa lawre, i ma alhabar tee ir se kaŋ ra ir ga duu fondaa kaŋ nda ir ga žigi ka koy, nda koyrawey kaŋ ra ir ga huru.› ");
INSERT INTO ses_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Šennoo woo kan ya ne, ay na aru woy cindi hinka (12) zaa war ra, alkabiila foo, aru foo. ");
INSERT INTO ses_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","I koy, i žigi tondi hondoo ga, de i too hala Eškol gooroo do kaŋ i nʼa monno. ");
INSERT INTO ses_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","I zaa gandaa tuuri-izey ra ka kate ey ir se, šennoo kaŋ i nʼa har ti: ‹Ganda henna no kaŋ Abadantaa, ir Koyoo gʼa noo ir se.› ");
INSERT INTO ses_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Amma war mana baa war ma žigi ka koy, war ture Abadantaa, war Koyoo yaamaroo ga. ");
INSERT INTO ses_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","War ŋuunuŋuunu war hukkumey cire, war nee: ‹Abadantaa mma konna ir, woo se a nʼir fattandi Misira gandaa ra hala nga mʼir daŋ Amor borey kabey ra i mʼir halaci.› ");
INSERT INTO ses_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Man ra ir ga žigi ka koy? Ir armey nʼir biney hasara ka nee: ‹Jama beeri no kaŋ borey bisa ir kayyan, koyra gaabanteyaŋ no kaŋ cetewey ga too beenaa, ir dii a ra ba Anak boroyaŋ.› ");
INSERT INTO ses_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Ay nee war se: ‹War biney masi dunbu, war masi hunbur ey.› ");
INSERT INTO ses_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Abadantaa, war Koyoo kaŋ ga dira war jine, a ga wongu war se, sanda takaa kaŋ nda a nʼa tee war jine Misira ");
INSERT INTO ses_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","nda saajoo ra kaŋ ra ni dii kaŋ Abadantaa, ni Koyoo na ni zaa sanda takaa kaŋ aru ga nga izʼaroo zaa, fondaa kul kaŋ ra war dira hala war ma too kate nongoo woo ra. ");
INSERT INTO ses_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Amma woo kul, war mana war naanaa daŋ Abadantaa, war Koyoo ra ");
INSERT INTO ses_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","kaŋ ga dira war jine fondaa ra ka nongu ceeci war se kaŋ ra war ga goro. Cijin here, a ga huru war jine nuune ra ka fondaa kaarandi war se kaŋ ra war ga hima ka dira. Zaari here, a ga huru duula ra ka fondaa cebe war se. ");
INSERT INTO ses_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Abadantaa maa war ŋuunuŋuunuyaney, nga futuroo ra a žee ka nee: ");
INSERT INTO ses_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","‹Alwaddaa woo boro laaley, abada boro kul si dii ganda hennaa kaŋ ay žee kaŋ ay gʼa noo war baabey se, ");
INSERT INTO ses_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","nda manʼti Kaleb, Yefune izʼaroo hinne, a ga dii a, ay gʼa noo nga nda nga izʼarey se gandaa kaŋ ra a dira, zama a na Abadantaa gana nda fondaa.› ");
INSERT INTO ses_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Agay mo, Abadantaa futu ay ga war maaganda se. A nee: ‹Ni mo, nʼsi huru a ra. ");
INSERT INTO ses_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Žozuwe, Nun izʼaroo kaŋ ga goy ma ne ga huru a ra. A tee boro kaŋ nin, zama nga no ma Izirayel borey daŋ gandaa woo ra, a mʼa noo i se sanda tubu. ");
INSERT INTO ses_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","War izey kaŋ war nee: “Iberey gʼi dii”, war izʼarey kaŋ hõ i si ihenna nda ilaala kaa cere ra, ngi no ma huru a ra, ngi se ay gʼa noo, ngi no mʼa mayray. ");
INSERT INTO ses_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Amma war, wa willi ka koy saajoo ra ka Kakaarey teekoo fondaa zaa.› ");
INSERT INTO ses_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","War nʼay zaabi ka nee: ‹Ir na zunubu tee Abadantaa ga, ir ga žigi ka koy wongu nda takaa kaŋ nda Abadantaa, ir Koyoo nʼir yaamar.› War na war wongu jinawey zaa war centey ga, war naanay kaŋ a ga faala war se ka žigi tondi hondoo ra. ");
INSERT INTO ses_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Amma Abadantaa nee ya ne: ‹Nee i se: “War masi žigi ka koy, war masi wongu, zama ay sii war game, woo ra war masi koy naŋ war iberey ma war kar.”› ");
INSERT INTO ses_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Ay šelaŋ war se, amma war mana haŋajer, war wanji Abadantaa yaamarey ga, war fooma ka žigi tondi hondoo ra. ");
INSERT INTO ses_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Woo ra Amor borey kaŋ goo tondi hondoo ra fatta ka war kubay, ka war gaaray sanda takaa kaŋ ayuuhamney gʼa tee, za Seyir hala Horma, i na war kar. ");
INSERT INTO ses_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","War yee kateroo ga, war hẽe Abadantaa jine, amma Abadantaa mana maa war hẽeney se, a mana haŋajer war se. ");
INSERT INTO ses_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Woo ra war goro Kadeš ka waati kuku tee no din.» ");
INSERT INTO ses_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","«Woo banda ga, ir kuubi ka koy saajoo here ka Kakaarey teekoo fondaa zaa, sanda takaa kaŋ nda Abadantaa nʼa har ya ne. Ir gay ir ga Seyir gandaa tondi hondoo kuubi kʼa bere jirbi boobo.» ");
INSERT INTO ses_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","«Abadantaa šelaŋ ya ne ka nee: ");
INSERT INTO ses_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","‹War gay war ga tondi hondoo woo kuubi kʼa bere, sohõ, wa kuubi ka koy hawsa here. ");
INSERT INTO ses_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Jamaa noo yaamaroo woo ka nee: “War ga bisa nda war armey gandaa hirroo, Eso borey kaŋ ga goro Seyir. I ga hunbur war, amma war ma hanse ka hawgay. ");
INSERT INTO ses_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","War masi yenje wiri i ga, zama ay si war noo ngi gandaa ra ba ceetaami doo. Zama Eso se ay na Seyir tondi hondoo noo a ma tee nga halaalaa. ");
INSERT INTO ses_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Ŋaayanoo kaŋ war gʼa ŋaa i do, war mʼa day nda nooru. Ba haroo kaŋ war gʼa haŋ, war mʼa day nda nooru.” ");
INSERT INTO ses_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Zama Abadantaa, ni Koyoo nka albarka daŋ ni kabe goyoo kul ra, a na ni diraa hawgay saaji beeroo woo ra. Jiiri woytaaci (40) ti woo kaŋ Abadantaa goo ni bande, haya kul mana ni gaza.› ");
INSERT INTO ses_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Woo banda ga, ir nʼir armey, Eso borey kaŋ ga goro Seyir gandaa ra naŋ ka koy. Ir mooru Ganganoo gandaa fondaa, nda Elat, nda Esiyoŋ-Geber koyrawey, ka kuubi ka koy Mowab saajoo fondaa ra. ");
INSERT INTO ses_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Abadantaa nee ya ne: ‹War masi Mowab wiri, war masi wongu ceeci i ga, zama ay si ni noo haya kul mʼa mayray nga gandaa ra, zama Lotu izʼarey se ay na Ar noo i mʼa mayray.› ");
INSERT INTO ses_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","Cee jinaa, Emi borey no ma goro no din, jama beeri, i ga boobo, i goo nda kayyan sanda Anak borey. ");
INSERT INTO ses_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Ngi mo nda Anak borey ga laasaabandi Refa boro. Amma Mowab borey si nee i se kala Emi borey. ");
INSERT INTO ses_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Cee jinaa, Hori borey no ma goro Seyir gandaa ra. Eso borey na kabey kokobu kʼi halaci, ka goro ngi dogoo ra, sanda takaa kaŋ Izirayel nʼa tee gandaa kaŋ goo a kone se, woo kaŋ Abadantaa nʼa noo a se. ");
INSERT INTO ses_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","‹Sohõ, wa tun ka koy Zered haroo deŋ.› Ir na Zered haroo deŋ. ");
INSERT INTO ses_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Jiiri waranza cindi yaaha (38) no ir nʼa tee diray ra, ka hun Kadeš-Barneya hala Zered haroo deŋyanoo, hala waatoo kaŋ ra wongu-izey alwaddaa kul ben jamaa kaloo ra, sanda takaa kaŋ nda Abadantaa nʼa žee i se. ");
INSERT INTO ses_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Abadantaa hunday kaboo ka tun i ga kʼi benandi jamaa kaloo ra, hala i kul dere pat. ");
INSERT INTO ses_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Waatoo kaŋ wongu-izey kul buu ka ben jamaa game, ");
INSERT INTO ses_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","Abadantaa šelaŋ ya ne ka nee: ");
INSERT INTO ses_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","‹Hõ nʼga bisa nda Mowab gandaa hirroo, Ar here. ");
INSERT INTO ses_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Nʼga too Amoŋ borey hirroo tenje. Masʼi wongu, masi yenje wiri i ga, zama ay si ni noo haya kul mʼa mayray Amoŋ borey gandaa ra, zama Lotu izʼarey se ay nʼa noo i mʼa mayray.› ");
INSERT INTO ses_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","Gandaa din mo bay ka laasaabandi Refa borey wane, Refa borey ka cindi ka goro a ra. Amoŋ borey si nee i se kala Zamzum borey, ");
INSERT INTO ses_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","jama beeri, i ga boobo, i goo nda kayyan sanda Anak borey. Abadantaa nʼi halaci Amoŋ borey jine. Amoŋ borey nʼa kabey kokobu ka goro dogey ra. ");
INSERT INTO ses_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Woo da no Abadantaa nʼa tee Eso borey se kaŋ ga goro Seyir gandaa ra kaŋ a na Hori borey halaci i jine. I na kabey kokobu ka goro dogey ra hala hõ. ");
INSERT INTO ses_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Awi borey kaŋ cindi ka goro koyrawey ra hala Gaaza, Kaftor borey kaŋ hun Kaftor nʼi halaci ka goro dogey ra.» ");
INSERT INTO ses_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","«Wa tun ka koy Arnoŋ isaa deŋ. Guna, ay na Sihoŋ, Amor boraa kaŋ ti Hešboŋ kokoyoo nda nga gandaa daŋ ni kaboo ra. Za sohõ da, mʼa zaa, ma wongu wiri a ga. ");
INSERT INTO ses_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Hõ ay ga šintin ka ni hunburaa daŋ jamawey kul ra kaŋ goo aduɲɲa ra, nda i maa ni alhabaroo, i ga jijiri, biney ga dunbu ni jine. ");
INSERT INTO ses_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Ay na dontokawyaŋ sanba nda alaafiyaa šenniyaŋ ka hun Kedemot saajoo ra ka koy Sihoŋ, Hešboŋ kokoyoo do ka nee a se: ");
INSERT INTO ses_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","‹Ay ga baa ya bisa nda ni gandaa, fondaa de bande ay ga hanga, ay si šiiri kabe guma here wala iwaawa here. ");
INSERT INTO ses_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Ŋaahayaa kaŋ ay gʼa ŋaa, mʼa neere ya ne, haroo kaŋ ay gʼa haŋ, mʼa neere ya ne. Ya mma baa de ya bisa. ");
INSERT INTO ses_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","Woo no Eso borey kaŋ ga goro Seyir gandaa ra, nda Mowab borey kaŋ ga goro Ar nʼa tee ya ne. Ni mo, takaa woo da tee ya ne hala waati kaŋ ay na Žurdeŋ isaa deŋ ka bisa ka huru gandaa ra kaŋ Abadantaa, ir Koyoo gʼa noo ir se.› ");
INSERT INTO ses_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Amma Sihoŋ, Hešboŋ kokoyoo mana yadda ir ma bisa nda nga do, zama Abadantaa, ni Koyoo nka hiɲoo šendandi, ka binoo kogandi hala nga mʼa noo ma ne sanda takaa kaŋ nda a goo ni kaboo ra hõ. ");
INSERT INTO ses_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Abadantaa nee ya ne: ‹Guna, za sohõ da ay šintin ka Sihoŋ nda nga gandaa daŋ ni kaboo ra. Za sohõ da, nga gandaa zaa a ma tee ni wane.› ");
INSERT INTO ses_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Sihoŋ nda nga jamaa kul fatta kʼir kubay kʼir wongu Yahas. ");
INSERT INTO ses_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Abadantaa, ir Koyoo nʼa noo ir se, ir na nga, nda izʼarey, nda nga jamaa kul kar. ");
INSERT INTO ses_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Alwaatoo din, ir na nga koyrawey kul dii kʼi halaci sõy, arey, nda woyey, nda zankey, ir mana baahunante kul naŋ. ");
INSERT INTO ses_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Adabbawey nda alganiimaa kaŋ ir duu a koyrawey kaŋ ir nʼi dii ra de bara ir kone. ");
INSERT INTO ses_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Ka hun Aroyer kaŋ ti koyra kaŋ goo Arnoŋ haroo miɲoo ga nda koyraa kaŋ goo gooroo ra ka koy hala Galad, koyra sii no kaŋ ga gaabi ir se. Abadantaa, ir Koyoo nʼi kul daŋ ir kabey ra. ");
INSERT INTO ses_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Amma mana man Amoŋ borey gandaa here, nda nongey kul kaŋ goo Yabok haroo miɲoo ga, nda koyrawey kaŋ goo tondi hondey ra, nda haya kaŋ ir Koyoo nʼir yaamar ir masi too a do.» ");
INSERT INTO ses_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","«Woo banda ga, ir kuubi ka žigi ka koy nda Bašaŋ fondaa. Og, Bašaŋ kokoyoo nʼir kubay, nga nda nga jamaa kul kʼir wongu Edreyi. ");
INSERT INTO ses_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Abadantaa nee ya ne: ‹Masi hunbur a, ay nʼa daŋ ni kaboo ra, nga, nda nga jamaa kul, nda nga gandaa. Ma hayaa tee a se kaŋ nʼnʼa tee Sihoŋ, Amor borey kokoyoo se kaŋ goro Hešboŋ.› ");
INSERT INTO ses_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Abadantaa, ir Koyoo na Og, Bašaŋ kokoyoo daŋ ir kabey ra koyne nda nga jamaa kul. Ir nʼa kar, ir mana baahunante kul naŋ. ");
INSERT INTO ses_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Waatoo woo ra, ir na nga koyrawey kul dii, ba koyra foo sii no kaŋ ir manʼa dii: koyra woydu (60) no, maanaa Argob koyraa laamaa kul, Argob sii kala Bašaŋ laboo ra kaŋ goo kokoyoo Og laamaa ra. ");
INSERT INTO ses_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Koyrawey wey kul, cete kukuyaŋ no mʼi kuubi kʼi bere, nda ganbuyaŋ kaŋ kufalandi. Koyra booboyaŋ mo goo no kaŋ ga cete sii. ");
INSERT INTO ses_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Ir nʼi halaci sõy sanda takaa kaŋ ir nʼa tee Sihoŋ, Hešboŋ kokoyoo se. Ir na koyra foo kul halaci sõy, arey, nda woyey, nda zankey. ");
INSERT INTO ses_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Amma ir na adabbawey kul nda alganiimawey kaŋ ir duu ey koyrawey ra zaa ir boŋ se.» ");
INSERT INTO ses_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","«Waatoo din ra, ir na Amor borey kokoy hinkaa gandawey taa i kone Žurdeŋ isaa se banda, kʼa dii za Arnoŋ isaa miɲoo hala Hermoŋ tondi hondoo do. ");
INSERT INTO ses_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","Sidoŋ borey mma Hermoŋ cee nda Siryoŋ, Amor borey ga nee a se Senir. ");
INSERT INTO ses_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Ir na ganganoo koyrawey kul taa, nda Galad kul, nda Bašaŋ kul, ka koy hala Salka nda Edreyi, Bašaŋ koyrawey kaŋ goo Og laamaa ra. ");
INSERT INTO ses_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","Og, Bašaŋ kokoyoo hinne ka cindi Refa borey ra. Nga daaroo mana teendi nda kala guuru. Nga kuuyanoo manʼti kala kabedaaru yagga, nga hayyanoo kabedaaru taaci, aru kabedaaru. Daaroo sii kala Amoŋ borey galloo ra kaŋ se i ga nee Raba. ");
INSERT INTO ses_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Waatoo din, ir na gandaa woo mayray. Ka hun za Arnoŋ haroo miɲoo kaŋ ti Aroyer gandaa, nda Galad tondi hondoo jeroo, nda nga koyrawey, ay nʼi noo Rubeŋ borey nda Gad borey se. ");
INSERT INTO ses_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Manase alkabiila jeraa se ay na Galad cindoo noo nda Bašaŋ kul kaŋ ti Og laamaa, maanaa Argob koyraa laamaa kul. Bašaŋ kul mma ciyandi Refa borey nongu. ");
INSERT INTO ses_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Yahir, Manase boro na Argob laamaa kul dii hala Gešur borey nda Maaka borey gandaa hirroo ga. A na nga maaɲoo daŋ Bašaŋ ga kaŋ se i ga nee Yahir koyra buuna-buunawey hala hõ. ");
INSERT INTO ses_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Ay na Galad noo Makir se. ");
INSERT INTO ses_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Ay na Rubeŋ borey nda Gad borey noo nongoo kaŋ ga hun Galad ka koy hala Arnoŋ isaa do, isaa gamoo ti nga hirroo ka koy hala Yabok isaa kaŋ ti Amoŋ borey gandaa hirroo, ");
INSERT INTO ses_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","nda Ganganoo gandaa, maanaa Žurdeŋ isaa guraa. Ka hun Genezaret haroo do ka koy Ganganoo gandaa din teeko Ciiri-ciirantaa do, Pisiga tondi hondoo zunbudogey cire, dandi here. ");
INSERT INTO ses_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","Waatoo din ra, ay na war yaamar ka nee: ‹Abadantaa, war Koyoo na gandaa woo daŋ war kabey ra hala a mʼa tee war wane. War kul, wongaarey, war ma wongu jinawey zaa ka bisa war armey jine kaŋ ti Izirayel borey. ");
INSERT INTO ses_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","War wandey, nda war zankey, nda war adabbawey hinne no ma goro war koyrawey ra kaŋ ay nʼi noo war se, ay ga bay kaŋ war goo nda adabba booboyaŋ. ");
INSERT INTO ses_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","War ma woo tee hala waati kaŋ Abadantaa na war armey noo hunanzamay sanda war, ngi hunday ma duu gandaa kʼa mayray kaŋ Abadantaa, war Koyoo gʼa noo i se Žurdeŋ isaa jere faa ga. Woo banda ga, war ga willi, boro foo kul ga kaa ka goro nga dogoo ra kaŋ ay nʼa noo war se.› ");
INSERT INTO ses_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","Alwaatoo din ra, ay na Žozuwe yaamar ka nee: ‹Ni moɲey dii haya kul kaŋ Abadantaa, war Koyoo nʼa tee kokoy hinkaa woo se. Takaa woo da no Abadantaa gʼa tee laamawey kul kaŋ ra nʼga bisa. ");
INSERT INTO ses_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","War masi hunbur ey, Abadantaa, war Koyoo hunday no ma wongu war se.›» ");
INSERT INTO ses_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","«Waatoo din ay na Abadantaa suurandi ka nee: ");
INSERT INTO ses_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","‹Ay Koyoo, Abadantaa, ni šintin ka agay, ni tamoo cebe ni jeeraa nda ni kabe gaabantaa. May ti koyoo kaŋ goo beenaa ra nda laboo ga kaŋ ga hin ka goy tee kaŋ ga hima nda ni hinoo teegoyey? ");
INSERT INTO ses_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Naŋ ya bisa, ay gʼa wiri ni ga, hala ya dii ganda hennaa kaŋ goo Žurdeŋ isaa se banda, tondi hondu henney wey nda Libaŋ gandaa.› ");
INSERT INTO ses_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Amma Abadantaa futu ay ga war maaganda se, a mana haŋajer ya ne. Abadantaa nee ya ne: ‹A wasa, masi yee ka šelaŋ ya ne hayaa woo ga! ");
INSERT INTO ses_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Žigi Pisiga tondi hondoo ga, ni moɲey jer dangay here, nda hawsa here, nda gurma here, nda dandi here, guna nda ni moɲey, zama nʼsi bisa Žurdeŋ isaa woo ga. ");
INSERT INTO ses_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Žozuwe noo yaamaryaŋ, a noo gaabi, ma bine daŋ a ra, nga no ma huru jamaa woo jine, nga no ma gandaa kaŋ nʼga dii a noo jamaa se a ma tee nga tuboo.› ");
INSERT INTO ses_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Ir cindi gooroo ra, Bet-Pewor koyraa tenje.» ");
INSERT INTO ses_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","«Aywa sohõ Izirayel, haŋajer hantumey nda hantumey kaŋ kayandi se kaŋ ay gʼi cawandi war se war ma duu ka dira nda ey, hala war ma huna, war ma huru gandaa ra kʼa mayray kaŋ Abadantaa, war baabey Koyoo gʼa noo war se. ");
INSERT INTO ses_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","War masi haya kul tonton šennoo ga kaŋ ay gʼa noo war se, war masi haya kul kaa a ra. War ma Abadantaa, war Koyoo yaamarey dii kaŋ ay gʼi noo war se. ");
INSERT INTO ses_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","War moɲey dii hayaa kaŋ Abadantaa nʼa tee Bal kaŋ ti Pewor koyoo šennoo ra. Abadantaa, ni Koyoo na borey kul kaŋ hanga Bal-Pewor bande halaci war game. ");
INSERT INTO ses_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Amma war kaŋ hawa Abadantaa, war Koyoo ga, war kul ga huna hõ. ");
INSERT INTO ses_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Nga ne, ay na hantumyaŋ nda hantumyaŋ kaŋ kayandi cawandi war se nda takaa kaŋ nda Abadantaa, ay Koyoo nʼay yaamar, hala war mʼi ka dira gandaa game kaŋ ra war ga huru kʼa mayray. ");
INSERT INTO ses_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","War mʼi dii, war mʼi ka dira, woo ra dumey kaŋ ga maa hantumey wey kul ga dii kaŋ war goo nda lakkal nda bayray. I ga nee: ‹Gandaa beeroo woo manʼti kala dumi kaŋ goo nda lakkal, a ga faham.› ");
INSERT INTO ses_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Ganda beeri foo bara no kaŋ goo nda koy kaŋ ga man a sanda takaa kaŋ nda Abadantaa, ir Koyoo ga man ir waati kul kaŋ ir nʼa cee? ");
INSERT INTO ses_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Ganda beeri foo bara no kaŋ goo nda yaamar nda hantum šerranteyaŋ kaŋ kayandi sanda ašariyaa woo kul kaŋ ay gʼa daŋ war jine hõ?» ");
INSERT INTO ses_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","«Amma ni boŋ hawgay, ma ni boŋ lakkal ni hunaroo kul ra, masi koy dirɲa hayey kaŋ ni moɲey dii ey i ma hun ni binoo ra. Mʼi bayrandi ni izey se nda ni izey izey se. ");
INSERT INTO ses_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Hongu hanoo kaŋ ni kay Abadantaa, ni Koyoo jine Horeb, waatoo kaŋ Abadantaa nee ya ne: ‹Jamaa marga ay jere. Ay ga baa i ma maa ay šenney kʼi denden, hala i ma wan ka hunbur agay waatoo kul kaŋ i gʼa tee laboo ga, de i mʼi cawandi ngi izey se.› ");
INSERT INTO ses_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Hanoo din, war kaa ka man, war kay tondi hondoo cire. Hondoo kul no ma dii nda nuune hala beenaa ra, kubay nda duula bibi tik goo no. ");
INSERT INTO ses_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Abadantaa šelaŋ war se nuune game. War maa šenniyaŋ, war mana dii gaaham, jinde de no. ");
INSERT INTO ses_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","A na nga amaanaa daŋ war jine, amaanaa kaŋ a nee war mʼa dii, yaamar woyaa (10). A nʼi hantum tondi walha hinka ga. ");
INSERT INTO ses_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Alwaatoo din, Abadantaa nʼay yaamar ya war cawandi hantumyaŋ nda hantumyaŋ kaŋ kayandi hala war mʼi ka dira gandaa ra kaŋ war goo ma bisa ka koy a mayray.» ");
INSERT INTO ses_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","«Hanoo kaŋ Abadantaa šelaŋ war se nuunaa game Horeb, war mana dii gaaham kul, woo se wa war boŋ hawgay, ");
INSERT INTO ses_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","war masi koy war boŋ hasara ka tooru hanse, koy kul kaŋ assuuraa no, a ma tee aru dumi, wala woy, ");
INSERT INTO ses_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","wala a ma tee adabba dumi kaŋ goo laboo ga, dumi kul kaŋ no, a ma tee ciraw fatakoyni dumi kaŋ ga deeši, dumi kul kaŋ no, ");
INSERT INTO ses_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","a ma tee haya dumi kaŋ ga ziilam-ziilam laboo ga, dumi kul kaŋ no, a ma tee hamiisa dumi kaŋ goo harey ra laboo cire, dumi kul kaŋ no. ");
INSERT INTO ses_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Masi ni moɲey jer beene ka waynaa guna, wala handoo, wala handarawey, wala haya kul kaŋ goo beenaa ra. Masi naŋ ma sujudu i se kʼi gana, hayey wey, Abadantaa, ni Koyoo nkʼi noo dumey kul kaŋ goo nongu kul kaŋ no aduɲɲa ra. ");
INSERT INTO ses_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Amma war, Abadantaa nka war zaa ka war kaa Misira ra kaŋ ga hima nda guuru mennandi alforon, hala war ma tee nga jamaa, nga tuboo, sanda takaa kaŋ war gʼa tee hõ. ");
INSERT INTO ses_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Abadantaa futu ay ga war maaganda se, a žee kaŋ ay si bisa Žurdeŋ isaa ga, de mo ay si huru ganda hennaa ra kaŋ Abadantaa, ni Koyoo gʼa noo ma ne sanda tubu. ");
INSERT INTO ses_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Zama agay, ay ga buu gandaa woo ra, ay si Žurdeŋ isaa deŋ, amma war, war gʼa deŋ, de war ga ganda hennaa woo mayray. ");
INSERT INTO ses_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Wa war boŋ hawgay, war masi koy dirɲa amaanaa kaŋ Abadantaa, war Koyoo nʼa daŋ nga nda war game, ka koy tooru hanse, a ma tee kunturu kul kaŋ no kaŋ Abadantaa, ni Koyoo na ni yaamar masʼa tee. ");
INSERT INTO ses_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Zama Abadantaa, ni Koyoo manʼti kala nuune beeri, Koy no kaŋ ga canse. ");
INSERT INTO ses_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Waati kaŋ ni duu ize nda haamayaŋ, waati kaŋ war gay gandaa ra, nda war na war boŋ hasara, nda war na tooru hanse, kunturu dumi kul kaŋ no, nda war na goy futu tee Abadantaa, ni Koyoo jine kaŋ nʼa futandi, ");
INSERT INTO ses_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","aywa, hõ ay ga beenaa nda laboo cee i ma tee war se seede, war ga cahã ka dere gandaa ra kaŋ war gʼa mayray Žurdeŋ isaa deŋyanoo banda ga, war si duu aloomur: war ga halaci sõy. ");
INSERT INTO ses_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Abadantaa ga war say-say dumey ra, boro hinna kaccu no ma cindi gandawey kaŋ ra Abadantaa ga war ka koy. ");
INSERT INTO ses_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","No din ra war ga koyyaŋ gana kaŋ adamize kabe kʼi tee, bundu nda tondi kaŋyaŋ si hin ka dii, i si hin ka maa, i si hin ka ŋaa, i si hin ka maa haya hew. ");
INSERT INTO ses_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Woo ga, no din war ga Abadantaa, ni Koyoo ceeci, nʼga duu a nda nʼgʼa ceeci nda ni binoo kul nda ni hundoo kul. ");
INSERT INTO ses_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Waati kaŋ ni goo binemarayyan ra, de hayey wey kul duu ni, waatey kaŋ ga kaa ra nʼga yee kate Abadantaa, ni Koyoo ga, nʼga haŋajer šennoo se. ");
INSERT INTO ses_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Zama Abadantaa, ni Koyoo manʼti kala Koy tamallante. A si ni naŋ, a si ni halaci, a si dirɲa amaanaa kaŋ a nʼa žee ni baabey se.» ");
INSERT INTO ses_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","«Ay gʼa wiri ni ga, hãa, waatey kaŋ bisa ra, zaarey kaŋ na ni jin, za hanoo kaŋ Irkoy na adamize taka laboo ga, aduɲɲa boŋ foo ka koy boŋ faa ga, wala haya teendi kaŋ ga too woo beeriyan? Boro bay ka maa woo cine? ");
INSERT INTO ses_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Dumi goo no kaŋ bay ka maa koy jinde a ga šelaŋ nuune game wala, sanda takaa kaŋ ni, ni maarʼa, de nʼga huna? ");
INSERT INTO ses_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Koy bay ka siiyan, nda tammaasayaŋ, nda kayfiyaŋ, nda wongu, nda kabe gaabante, nda hini, nda teegoy beeri hunburante tee ka koy ganda taa ganda tana kone, sanda hayaa kul kaŋ Abadantaa, war Koyoo nʼa tee war se Misira ni moɲey cire? ");
INSERT INTO ses_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Ni, i na hayey kaarandi ma ne, hala ma duu ka bay kaŋ Abadantaa hinne ti Koy, koy foo sii no kala nga. ");
INSERT INTO ses_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","A na ni mandi nga jindoo kaŋ hun beenaa ra ka ni cawandi. Laboo ga, a na ni cebe nga nuune beeroo, nuunaa gamoo ra, ni maa nga šenney. ");
INSERT INTO ses_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Zama a baa ni baabey, a na ngi hayroo suuba dumawey ga, nga hunday ka ni kaa Misira nda nga hini beeroo. ");
INSERT INTO ses_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","A na dumey kaŋ boobo nda ni, i gaabi nda ni gaaray ni jine, hala nga ma kate ni ka ngi gandaa noo ma ne a ma tee ma ne tubu, sanda takaa kaŋ a gʼa tee hõ. ");
INSERT INTO ses_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Hõ ma bay, ma miile a ga kaŋ Abadantaa ti Irkoy kaŋ goo beenaa ra, beene, nda laboo ga, ganda. Koy tana sii no. ");
INSERT INTO ses_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Ma nga hantumey nda nga yaamarey dii kaŋ nda ay ga ni yaamar hõ, hala ma duu ka duu gomni, ni nda ni izey ni dumaa ga, de mo ma duu aloomur laboo ga kaŋ Abadantaa, ni Koyoo gʼa noo ma ne hala abada.» ");
INSERT INTO ses_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Waatoo din, Musa na koyra hinza daŋ jere ga Žurdeŋ isaa se banda, waynahunay kaboo here, ");
INSERT INTO ses_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","hala i ma tee nongu kaŋ ra boro kaŋ na nga cinaa wii bila murayyan, manʼti konnaray se, boraa ma hin ka zuru ka koy nga boŋ talfi koyrawey wey affoo ga, a ma huna. ");
INSERT INTO ses_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Koyrawey manʼti kala: Beser kaŋ goo saajoo ganganoo ra ma tee Rubeŋ borey wane, Ramot-Galad ma tee Gad borey wane, Golaŋ kaŋ goo Bašaŋ gandaa ra ma tee Manase borey wane. ");
INSERT INTO ses_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Woo ti ašariyaa kaŋ Musa nʼa daŋ Izirayel borey jine. ");
INSERT INTO ses_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Wey ti seedetarawey, nda hantumey, nda hantumey kaŋ kayandi kaŋ Musa nʼi har Izirayel borey se waatoo kaŋ i fatta Misira. ");
INSERT INTO ses_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","Woo mana teendi kala Žurdeŋ isaa se banda, Bet-Pewor koyraa tenje, Amor borey kokoyoo Sihoŋ gandaa ra kaŋ si goro kala Hešboŋ, Musa nda Izirayel borey hin a kaŋ i fatta Misira. ");
INSERT INTO ses_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","I na nga gandaa dii, i na Og, Bašaŋ kokoyoo gandaa mo dii. Amor borey kokoy hinkaa woo mana laama kala Žurdeŋ isaa se banda, waynahunay kaboo here, ");
INSERT INTO ses_vpl VALUES ("DT4_48","006_4_48