﻿USE sofia;
DROP TABLE IF EXISTS sofia.seh_vpl;
CREATE TABLE seh_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES seh_vpl WRITE;
INSERT INTO seh_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kutoma kwa Mphangwa Zadidi za Yezu Kirixtu, Mwana wa Mulungu, ");
INSERT INTO seh_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ninga mudazilembera mporofeta Izaiya kuti: “Ine ndiri kutuma mwanankati wanga patsogolo pako toera akusasanyire njira.” ");
INSERT INTO seh_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Iye ali kukhuwa n'thando mbalonga kuti: ‘Sasanyirani njira toera Mbuya apite nayo na kundendemeza miseu yace.’” ");
INSERT INTO seh_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ndi tenepa kubulukira kudacita Djuwau Batixta n'thando, mbakhatambirisa anthu batixmu na kuapanga kuti achunyuke kudawa kwawo. ");
INSERT INTO seh_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Anthu onsene a ku cisa ca ku Djudeya na a ku nzinda wa Djerusalema akhaenda kuna Djuwau Batixta, mbakhadambula kudawa kwawo, iye mbakhaatambirisa batixmu n'nyanza ya Djorodani. ");
INSERT INTO seh_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Djuwau akhabvala nguwo za kucitwa na uweya wa pinyama pinacemerwa kamero, mbakhamanga bhande ya nthembe n'cuno mwace, mbakhadya nthete na uci wa n'tsanga. ");
INSERT INTO seh_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Mbakhalonga kuna mbumba kuti: “Nduli mwanga anabwera munthu unango na mphambvu zikulu za utongi za kupiringana ine. Pontho ine sine munthu wakukwanisa kunsudzula mithambo ya ntsapato zace. ");
INSERT INTO seh_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ine ndisakutambirisani batixmu na madzi. Mbwenye Iye anakutambirisani batixmu na Nzimu wa Mulungu.” ");
INSERT INTO seh_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Pa ntsiku zenezo, Yezu akhabuluka ku nzinda wa Nazareti, ku dziko ya Galileya, mbaenda katambiriswa batixmu na Djuwau Batixta mu nyanza ya Djorodani. ");
INSERT INTO seh_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Pa ndzidzi ukhabuluka Yezu m'madzi iye aona kudzulu kwafunguka, penepo Nzimu wa Mulungu mbukhachita ninga nkhangaiwa, mbumphamira. ");
INSERT INTO seh_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Na tenepo, kudzulu kwabveka fala mbilonga kuti: “Iwe ndiwe mwana wanga wakufunika, ananditsandzaisa.” ");
INSERT INTO seh_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Buluka penepo, na mwansanga Yezu aendeswa n'thando na Nzimu wa Mulungu. ");
INSERT INTO seh_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Mwenemu Yezu akhala ntsiku makumanai mbakhaleserwa na Sathani. Iye akhakhala na pinyama pya n'tsanga, anju za Mulungu mbizikhamphatira basa. ");
INSERT INTO seh_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Pakumala kupitiswa Djuwau Batixta n'kaidi, Yezu abwerera ku Galileya kalonga Mphangwa Zadidi za Mulungu. ");
INSERT INTO seh_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Iye akhalonga tenepa: “Ndzidzi wakwana. Umambo wa Mulungu uli dhuzi, chunyukani kudawa kwanu, mutawire Mphangwa Zadidi.” ");
INSERT INTO seh_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yezu mukhapita iye na mu mbale mwa nyanza ya Galileya, aona anyakokota awiri mu ubale mwawo mbakhagwisira kokota yawo n'nyanza. Iwo madzina awo ndi Simau Pedhru na Andereya. ");
INSERT INTO seh_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yezu aapanga tenepa: “Nditowereni, ndikuciteni asakumedza a anthu.” ");
INSERT INTO seh_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Iwo pa ndzidzi ubodzi ene asiya makokota awo mbantowera. ");
INSERT INTO seh_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Pakufamba pang'ono patsogolo, Yezu aona amuna anango awiri muubale mwawo. Akhali Tiyago na Djuwau, ana a Zebhedheu, mbakhasona makokota awo m'bote. ");
INSERT INTO seh_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Penepo pene Yezu aacemera. Iwo asiya baba wawo Zebhedheu na anyabasa ace m' bote, mbaenda mbatowera Yezu. ");
INSERT INTO seh_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Buluka penepo Yezu na anyakupfundza ace aenda ku nzinda wa kafaranaumi. Nsabudu mwace apita n'nyumba ya kuphembera, mbatoma kupfundzisa. ");
INSERT INTO seh_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Anthu akhamubva mapfundzisiro ace akhadzumatirwa napyo, thangwi iye akhalonga tayu ninga anyakudziwisa a mwambo, mbwenye ninga ntongi. ");
INSERT INTO seh_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Pa ndzidzi unowu aoneka penepo mamuna m'bodzi akhali na nzimu wa kuipa, iye mbakhuwa kuti: ");
INSERT INTO seh_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yezu wa ku Nazareti musafunanji kuna ife? Imwe Mbuya mwabwera kudza katifudza? Ine ndisakudziwani Mbuya, kuti imwe ndimwe ani. Imwe ndimwe wakulungama wa Mulungu!” ");
INSERT INTO seh_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yezu aupwekera nzimu wa kuipa mbaupanga tenepa: “Matama! Buluka muna munthu uyu!” ");
INSERT INTO seh_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Penepo nzimu wa kuipa wabhoma mamuna na mphambvu zonsene, mbukhuwa mbubuluka muna iye. ");
INSERT INTO seh_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Anthu onsene adzumatirwa napyo, mbabvundzana okha-okha kuti: “Ninji penepi? Cipfundzo cipsa? Lang'anani iye ana mphambvu za kutonga na mizimu ene ya kuipa, iyo mbimbvera.” ");
INSERT INTO seh_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Na thangwi eneyo mbiri yace Yezu yafika na mwansanga mu dziko yonsene ya Galileya. ");
INSERT INTO seh_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Na mwansanga, Yezu abuluka mu nyumba ya kuphembera mbaenda pabodzi na Tiyago na Djuwau, mpaka ku nyumba kwa Simau Pedhru na Andereya. ");
INSERT INTO seh_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Pidafika Yezu, iwo ampangirwatu kuti mebzala wace Pedhru ali kugona thangwi aferuka. ");
INSERT INTO seh_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yezu aenda pakhakhala iye mbamphata nkono wace mbamulamusa. Penepo nthenda yawangiratu, iye mbatoma kuaphatira basa. ");
INSERT INTO seh_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Na maulo, mukhacita dzuwa sanza, anthu akhabweresa atenda azinji na anango akakhala na mizimu ya kuipa. ");
INSERT INTO seh_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mbumba yonsene ya mu nzinda yagumanyikana pa nsuwo wa nyumba. ");
INSERT INTO seh_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Iye awangisa anthu azinji akhali na nthenda zakusyana-syana, pontho na kuthamangisa mizimu ya kuipa mizinji. Iyo mizimu ya kuipa ikhandziwa mbani Yezu. Ndi thangwi eneyo Iye aikhondesa kuti ilonge. ");
INSERT INTO seh_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Na macibese, m'bambakuca, Yezu alamuka mbaenda mbuto yace ekha kaphembera. ");
INSERT INTO seh_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simau Pedhru aenda na andzace kasaka Yezu. ");
INSERT INTO seh_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Na tenepo, pidan'gumana iwo alonga tenepa: “Anthu onsene asakusakani.” ");
INSERT INTO seh_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yezu aapanga tenepa: “Tendeni m'pisa pinango pya dhuzi-dhuzi, toera ndiapangembo Mphangwa Zadidi. Thangwi ndadzera penepyo.” ");
INSERT INTO seh_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Yezu akhaenda mbuto zonsene za Galileya, mbakhalonga Mphangwa Zadidi m'manyumba a kuphembera, na kubulusa mizimu ya kuipa. ");
INSERT INTO seh_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Penepo abwera mamuna m'bodzi nyamatanya kuna Yezu, an'godamira mbamphemba tenepa: “Mbuya mungafuna, munandiwangisa.” ");
INSERT INTO seh_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yezu am'bvera ntsisi zikulu mban'gwedza na manja ace mbampanga kuti: “Ndisafuna, nthenda yako yawanga.” ");
INSERT INTO seh_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Pa ndzidzi ubodzi ene matanya amala, mamuna awanga. ");
INSERT INTO seh_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Buluka penepo, Yezu amuendesa mbampanga na mphambvu zonsene kuti: ");
INSERT INTO seh_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Leka kupanga munthu penepyo. Ndoko kuna nyantsembe toera akudinkhe. Ungamala upereke ntsembe idalonga Mozesi, toera anthu adziwe kuti iwe wawangadi.” ");
INSERT INTO seh_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mbwenye mamuna uyu pidabuluka iye penepo, atoma kulonga pa kweca pinthu pizinji, mbakhamwaza mphangwa za pyonsene pikhadacitika. Na thangwi eneyo Yezu akhacimwana kupita m'mizinda na kutsandzaya. Mbwenye akhakhala kunja m'mbuto za kubisala. Anthu akhabuluka m'mbuto zonsene mbakhaenda kuna Iye. ");
INSERT INTO seh_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Pa kupita ntsiku pang'ono, Yezu abwerera pontho ku Kafaranaumi. Penepo anthu abva kuti Yezu ali pa nyumba. ");
INSERT INTO seh_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Na tenepo anthu azinji agumanyikana kweneko, mbapacimwana kuoneka mbuto na pa nsuwo pene, Iye mbakhaapfundzisa fala ya Mulungu. ");
INSERT INTO seh_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Amuna anango abwera kuna Iye na nyampfutete m'bodzi mbakhatembetwa na amuna anai. ");
INSERT INTO seh_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mbwenye iwo akhacimwana pita na iye mpaka kufika kuna Yezu, na thangwi ya mwinji wa anthu. Na tenepo akwira pa ntsoyi, mbafudza ku khundu ikhakhala Yezu, mbafungula benga mbachitisa na penepo ntenda akhabweresa iwo pa khangala. ");
INSERT INTO seh_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yezu pidaona iye cikhulupiriro cikhali na anthu awa, alonga tenepa kuli ntenda: “Mwananga, kudawa kwako kwalekererwa.” ");
INSERT INTO seh_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Penepo, anyakudziwisa anango a mwambo akhakhala pantsi, pidabva iwo penepyo atoma kunyerezera mu ntima mwawo mbalonga tenepa: ");
INSERT INTO seh_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Thangwi yanji mamuna uyu asalonga tenepa? Iye asaxola Mulungu! Thangwi analekerera kudawa ndi Mulungu basi, nkhabe munthu unango.” ");
INSERT INTO seh_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pa ndzidzi ubodzi ene, Yezu adziwa nkati mwace pikhanyerezera iwo, mbaapanga kuti: “Thangwi yanji musanyerezera pinthu penepi m'mitima mwanu?” ");
INSERT INTO seh_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Mphyanji pinanensa kulonga kuna nyampfutete: “Kudawa kwako kwalekererwa, peno ndimpange kuti: Lamuka, kwata khangala yako, ndoko ku nyumba kwako?” ");
INSERT INTO seh_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Mbwenye toera mudziwe kuti Ine Mwana wa Munthu ndina mphambvu zakulekerera kudawa pantsi pano, ampanga nyampfutete kuti: ");
INSERT INTO seh_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Lamuka, kwata khangala yako, ndoko ku nyumba kwako.” ");
INSERT INTO seh_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Mamuna alamuka na mwansanga, akwata khangala yace mbaenda pyace, anthu onsene mbamuona. Onsene adzumatirwa na pidaona iwo, mbapasa mbiri Mulungu mbalonga kuti: “Cipo tidzati kupiona pinthu ninga ipi!” ");
INSERT INTO seh_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yezu abuluka pontho mbaenda ku gombe ya nyanza ya Galileya. Penepo mwinji wa anthu wanfendedzera, iye mbatoma kuapfundzisa. ");
INSERT INTO seh_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pikhafamba iye aona Levi, mwana wa Alufeu, akhali nawa pa nyumba ikhakumbuswa misonkho mbampanga kuti: “Nditowere!” Levi alamuka, mbantowera. ");
INSERT INTO seh_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mukhadya Yezu na anyakupfundza ace ku nyumba kwa Levi, azinji anyakukumbusa misonkho na anyakudawa, akhadya nawo pabodzi, thangwi mbazinji akhantowera. ");
INSERT INTO seh_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Anyakudziwisa a mwambo a nsoka wa afarisi, pikhaona iwo kuti Yezu ali kudya pabodzi na “anyakudawa” pontho na anyakukumbusa misonkho, abvundzisa anyakupfundza a Yezu kuti: “Thangwi yanji iye asadya, mbamwa pabodzi na anyakukumbusa misonkho na ‘anyakudawa’?” ");
INSERT INTO seh_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yezu mudabva iye penepyo aatawira kuti: “Angumi nkhabe saka nyakukondza, mbwenye atenda ndiwo ana saka nyakukondza. Ine sidabwera kudza kacemera akulungama tayu, mbwenye ndabwera kacemera anyakudawa.” ");
INSERT INTO seh_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ntsiku inango anyakupfundza a Djuwau Batixta na afarisi akhapimana ca kudya. Penepo anthu anango aenda kabvundza Yezu kuti: Ndi thangwi yanji anyakupfundza a Djuwau na afarisi asamphembera mbapimana ca kudya, ako mbakhonda citambo penepyo? ");
INSERT INTO seh_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yezu aatawira tenepa: “Pisacitika kuti adacemerwa ku phwandu ya banja apimane ca kudya mwanacinthu banja wa mamuna mbali na iwo? Nkhabe citika.” ");
INSERT INTO seh_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mbwenye zinafika ntsiku zinafuna kukwatirwa iwo mwali wa mamuna pakati pawo, ntsiku zenezi iwo anati apimane ca kudya. ");
INSERT INTO seh_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nkhabe munthu anaikha cigamba ca nguwo ipsa pa nguwo yakusakala. Thangwi cigamba cipsa cinathimiza pandula nguwo ya kusakala piringana benga ya kale. ");
INSERT INTO seh_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Pontho nkhabe citika kukwata vinyu ipsa mbuikha n'khali zakale, gopera vinyu ipsa ingawira inadza kakuka mbiswa nkhali, mbiluzika nkhali na vinyu ene. Mbwenye vinyu ipsa isafunika iyikhwembo nkhali zipsa. ");
INSERT INTO seh_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ntsiku inango ya Sabudu, Yezu na anyakupfundza ace akhapita na pakati pa munda wa tirigu. Pikhaenda iwo, anyakupfundza ace atoma kusaka tirigu. ");
INSERT INTO seh_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mbwenye afarisi abvundzisa Yezu kuti: “Kodi ndi thangwi yanji anyakupfundza ako asacita pire pinakhondeswa na mwambo kucitiwa ntsiku ya Sabudu?” ");
INSERT INTO seh_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Mbwenye Iye aatawira tenepa: “Kodi imwe mudaona tayu pidalembwa na thangwi ya pidacita mambo Dhavidhi na andzace ntsiku inango pikhakhala iwo na njala mbasowa ca kudya?” ");
INSERT INTO seh_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Dhavidhi apita n'nyumba ya Mulungu, pa ndzidzi ukhakhala Abhiatari ninga nkhulu wa anyantsembe, mbadya iye mbapasambo andzace mikate ikhadaikhirwa ntsembe Mulungu. Mbwenye mwambo usalonga kuti mikate eneyo isadyiwa na anyantsembe basi. ");
INSERT INTO seh_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yezu athimiza pontho na kuapanga tenepa: “Sabudu yacitwa thangwi ya munthu, mbwenye munthu hadacitwa thangwi ya sabudu tayu.” ");
INSERT INTO seh_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Na tenepo, Ine Mwana wa Munthu, ndine Mbuya mphaka na ntsiku ya Sabudu ene. ");
INSERT INTO seh_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yezu apita pontho n'nyumba ya kuphembera. Mwenemo agumana mamuna m'bodzi wakulamala djanja. ");
INSERT INTO seh_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Iwo akhamulan'ganisa Yezu toera kumuona ngakhala anamwangisa ntsiku ya sabudu, toera ampase thangwi. ");
INSERT INTO seh_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Penepo Yezu ampanga mamuna nyakulamala kuti: “Lamuka, bwera pano pakati.” ");
INSERT INTO seh_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Buluka penepo aabvundza kuti: “Ndi ninji pinatawiriswa kucita ntsiku ya sabudu? Kucita udidi peno uipi? Kupulumusa munthu peno kupha?” Mbwenye nkhabe munthu adantawira. ");
INSERT INTO seh_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yezu alang'ana anthu akhali nkhundu mwace na kuipirwa pontho na kutsukwala na thangwi ya kuuma kwawo mitima, mbampanga nyakulamala kuti: “Fungula djanja yako.” Iye afungula, djanja yawanga. ");
INSERT INTO seh_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Na tenepo, afarisi abuluka mbatoma kubverana na anthu a nsoka wa Herodhi, kusaka njira ya kupha nayo Yezu. ");
INSERT INTO seh_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yezu abuluka na anyakupfundza ace mbaenda ku nyanza, anthu azinji a ku Galileya mbakhantowera. ");
INSERT INTO seh_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Na kubveka pyonsene pikhacita Iye, anthu azinji a ku Djudeya, na a ku Djerusalema, na a ku Idhumeya, na a ku pisa pya ntunda unango wa nyanza ya Djorodani, na a m'pisa pya dhuzi na Tiru na Sidhoni, akhaenda kuna Iye. ");
INSERT INTO seh_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Na thangwi ya mwinji wa anthu, Yezu apanga anyakupfundza ace kuti ansakire bote, toera akhonde kupfinyana na anthu. ");
INSERT INTO seh_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Thangwi Iye akhawangisa anthu azinji. Na tenepo atenda onsene akhabhomana kusaka kuti ankhuye. ");
INSERT INTO seh_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Penepo, ale akhali na mizimu ya kuipa, angaona Yezu, akhan'gwera pa myendo pace mbamulambira mbakhakhuwa tenepa: “Imwe Mbuya ndimwe Mwana wa Mulungu.” ");
INSERT INTO seh_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mbwenye Yezu aikhondesa mizimu ya kuipa na mphambvu zonsene kuti ikhonde kumulonga. ");
INSERT INTO seh_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Buluka penepo Yezu akwira pa phiri mbacemera ale akhafuna iye. Iwo abwera dhuzi na Iye. ");
INSERT INTO seh_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Na tenepo Yezu asankhula amuna khumi na awiri, toera akhale nawo na kuatuma kwenda mbamwaza Mphangwa Zadidi, ");
INSERT INTO seh_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","pontho toera akhale na mphambvu za kuthamangisa mizimu ya kuipa. ");
INSERT INTO seh_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Madzina awo mbawa: “Simau, anacemerwa Pedhru, ");
INSERT INTO seh_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Tiyago na Djuwau, ana a Zebhedheu, iwo asadziwika na dzina ya Bhoanerijes, kweneko nkhubveka ana njazi.” ");
INSERT INTO seh_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andereya, Filipi, Bhatolomeu, Mateu, Tomee, Tiyago, mwana wa Alufeu, Tadeu, Simau, akhali wa nsoka wa ndale wa atongi a dziko, ");
INSERT INTO seh_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na ule ene Djuda Xikariyote, adasandukira Yezu. ");
INSERT INTO seh_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Na tenepo, Yezu apita n'nyumba, mwinji wa anthu mbugumanyikana pontho penepo, Iye na anyakupfundza ace mbakhacimwana na kudya kwene. ");
INSERT INTO seh_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Abale ace Yezu pidabva iwo penepyo, aenda kuti akamphate adze naye na mphambvu. Thangwi anthu anango akhalonga kuti Yezu ana nsala. ");
INSERT INTO seh_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Anyakudziwisa a mwambo akhadabuluka ku Djerusalema, akhalonga kuti: “Yezu ana Bhelizebhu nkulu wa mizimu ya kuipa. Ndiye nkulu onowu wa mizimu ya kuipa anampasa mphambvu za kuthamangisa mizimu ya kuipa.” ");
INSERT INTO seh_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Na tenepo Yezu acemera anthu onsene mbaapanga na misanje kuti: “Kodi Sathani anathamangisika ekha ene? ");
INSERT INTO seh_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Umambo ungagawika, mbumenyana okha-okha unamalisira kufudzika. ");
INSERT INTO seh_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nkati mwa ubale mungaoneka kugawana, mbamenyana okha-okha, ubale unowu unamalisira kufudzikambo. ");
INSERT INTO seh_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Sathani angapwazika mbagawika ekha ene, nkhabe kudza kaoneka, anafudzika. ");
INSERT INTO seh_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Mbava angafuna kuswa nyumba ya munthu wa mphambvu toera kum'bera pinthu pyace, pa kutoma asam'manga. Angamala penepo anakwanisa kum'bera pya n'nyumba mwace. Pezi pene nkhabe kwanisa kum'bera pinthu pyace. ");
INSERT INTO seh_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ndimo mwene Ine ndinakupangani kuti: Kudawa na kuxola kunacita munthu kuna Mulungu, kusakwanisika kulekererwa, ");
INSERT INTO seh_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","mbwenye ule anaxola Nzimu wa Mulungu cipo nkhabe kudza kalekererwa. Thangwi madawi enewa nkhabe kumala.” ");
INSERT INTO seh_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yezu alonga ipi thangwi iwo akhalonga kuti: “Iye ana nzimu wa kuipa.” ");
INSERT INTO seh_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Na tenepo, pidafika mai wace na abale ace Yezu, akhala pa khundu pa nsoka wa anthu, mbancemeresa. ");
INSERT INTO seh_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Akhalipo anthu azinji akhakhala pantsi n'khundu mwa Yezu. Penepo anango ampanga kuti: lang'anani “Mai wanu na abale anu ali kule, asakusakani.” ");
INSERT INTO seh_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Na tenepo Yezu aatawira kuti: “Mbani mai wanga, mbani abale anga?” ");
INSERT INTO seh_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Penepo Yezu alang'ana anthu akhakhala pantsi n'khundu mwace, mbalonga tenepa: “Awa ndiwo mai wanga na abale anga. ");
INSERT INTO seh_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Thangwi ule anacita kufuna kwa Mulungu, onowu ndiye m'bale wanga wa mamuna, mwana nkazi wanga na mai wanga.” ");
INSERT INTO seh_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yezu atoma pontho kupfundzisa m'mbale mwa gombe. Penepo, na kugumanyikana kwa mwinji ukulu wa anthu nkhundu mwace, Iye apakira m'bote, akhala pantsi, mbafedza kutali pang'ono na gombe. Bote ikhakhala m'bara, mbwenye mbumba yonsene ikhakhala pa n'gombe. ");
INSERT INTO seh_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Iye akhaapfundzisa na misanje pinthu pizinji, mbakhalonga tenepa: ");
INSERT INTO seh_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Bveserani! Mamuna m'bodzi aenda kabzala mbeu ku munda kwace. ");
INSERT INTO seh_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Mukhawaza iye, mbeu zinango zagwa n'jira, mbalame mbazidzonkhona zonsene. ");
INSERT INTO seh_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mbeu zinango zagwa pa miyala pakhakhala mataka pang'ono. Penepo mbeu zamera na mwansanga, na thangwi ya kucepa kwa mataka. ");
INSERT INTO seh_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Mbwenye pidagaka dzuwa, zamala kupya mbiziuma thangwi michichi ikhadacepa. ");
INSERT INTO seh_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mbeu zinango zagwa pakati pa minga. Minga yakula, mbeu za cimwana kufantsa. Na tenepo, zacimwana kubala misapu. ");
INSERT INTO seh_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mbwenye mbeu zinango zagwa pa mataka adidi. Zenezo zamera mbazikula mbazibala misapu makumatatu, makumatanthatu mpaka kufika dzana pa mbeu ibodzi. ");
INSERT INTO seh_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Pakumalisa Yezu alonga tenepa: “Ana makutu a kubva, mbabve!” ");
INSERT INTO seh_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Pidasala Iye ekha, anyakupfundza khumi na awiri, pabodzi na anthu anango akhali nkhundu mwace, amphemba kuti aapange usalonganji nsanje onowu. ");
INSERT INTO seh_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yezu aatawira tenepa: “Kuli imwe Mulungu afuna kukudziwisani pyakubisala pya umambo wace, mbwenye kuli anthu a kunja pyonsene anapipfundziswa na misanje. ");
INSERT INTO seh_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Toera kuona mbaona, mbakhonda kudzindikira. Kubva mbabva, mbakhonda kupibvesesa. Pontho toera akhonde kuzungunuka kuna Mulungu, iye mbaalekerera kudawa kwawo.” ");
INSERT INTO seh_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Na tenepo Yezu aabvundza kuti: “Ngakhala imwe nkhabe kuubvesa nsanje uyu, misanje inango munaibvesesa tani? ");
INSERT INTO seh_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nyakubzala, asabzala fala ya Mulungu. ");
INSERT INTO seh_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mbeu zidagwa njira, ndi ale adabva fala, mbwenye na mwansanga asabwera Sathani mbabulusa fala ikhadabzalwa nkati mwa iwo. ");
INSERT INTO seh_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Anthu anango alandana na mbeu idagwa pa mataka a miyala. Angaibva fala asaitambiriratu na kukomerwa. ");
INSERT INTO seh_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mbwenye asakhala ndzidzi pang'ono, thangwi nkhabe michichi. Nyatwa zingaagwera, peno angachingwa na thangwi ya fala ya Mulungu, asaisieratu. ");
INSERT INTO seh_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Anangombo alandana na mbeu idagwa pakati pa minga. Iwo asabva fala ya Mulungu, ");
INSERT INTO seh_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","mbwenye na kukula kwa pinthu pya kunyerezera pya pa dziko, na pya mpfuma na pinango pizinji pya kusirira, penepyo pisacita kuti fala ya Mulungu ikhonde kufantsa na kubala misapu. ");
INSERT INTO seh_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pontho anthu anango alandana na mbeu idagwa pa mataka adidi. Asabva fala ya Mulungu, mbaitawira, mbabala misapu inango makumatatu, inango makumatanthatu, mpaka kufika dzana, pa mbeu ibodzi.” ");
INSERT INTO seh_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yezu athimiza na kuapfundzisa pontho tenepa: “Alipo munthu anagasa nyale mbaigudumira na n'goro peno mbaiikha pantsi pa talimba? Nkhabe citika. Mbwenye asaiyikha pa kweca toera imwinikire pyadidi.” ");
INSERT INTO seh_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Thangwi pyonsene pidabisala pinati pioneke. Pontho na pire pyonsene pinacitwa ncibiso-biso pinati pidziwike. ");
INSERT INTO seh_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ana makutu a kubva, mbabve. ");
INSERT INTO seh_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yezu athimiza pontho mbalonga tenepa: “Bvesesani mwadidi pire pinabva imwe! Na n'dida unapimira imwe andzanu, munadza kapimirwambo sawa-sawa, pontho mbamuthimizirwa pinango. ");
INSERT INTO seh_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Thangwi ule anapyo, anatambira pontho pinango. Mbwenye ule adasowa, anakwatirwa na ping'ono pyene pina iye!” ");
INSERT INTO seh_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yezu alonga pontho kuti: “Umambo wa Mulungu walandana na mamuna m'bodzi anawadza mbeu m'munda. ");
INSERT INTO seh_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Munthu, na masiku peno na masikati, asagona peno ali m'maso, asacimwana kudziwa kumera na kukula kunacita mbeu. ");
INSERT INTO seh_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Thangwi ndiwo mataka okhene anapasa misapu. Pa kutoma asabuluka masamba, thimize asathumburuka, pakumalisa asabala ngala ya kudzala na mbeu. ");
INSERT INTO seh_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mbeu zingatokota munthu asazibvuniratu, thangwi wafika ndzidzi wa kubvuna.” ");
INSERT INTO seh_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yezu athimiza basi na kulonga tenepa: “Tinaulandanisa nanji Umambo wa Mulungu? Peno tinausangiza na nsanje wanji?” ");
INSERT INTO seh_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Umambo walandana na mbeu inacemerwa muxtarda, mbeu ing'ono kakamwe piringana mbeu zonsene zinabzaliwa pa mataka. ");
INSERT INTO seh_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mbwenye ingabzalwa isamera mbikula, mbivata piringana miti inango. Pontho isakhala na nthawi zikulu kakamwe, mbalame za kudzulu mbazikwanisa kumanga ntsanza mwenemu. ");
INSERT INTO seh_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Na tenepo, Yezu akhaapfundzisa fala ya Mulungu na misanje mizinji ninga iyi ikhakwanisa iwo kubva. ");
INSERT INTO seh_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Na mbumba, Yezu akhalonga nawo na misanje basi, mbwenye angakhala ekha ene na anyakupfundza ace, akaachululira pyonsenene. ");
INSERT INTO seh_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ntsiku eneyo, mukhadoka dzuwa, Yezu apanga anyakupfundza ace kuti: “Tiwambukeni tiende ntunda unango wa nyanza.” ");
INSERT INTO seh_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Na tenepo, iwo aisiya mbumba, mbapakira m'bote mukhakhala Yezu mbaenda naye. Penepo mabote anango mbakhantowerambo. ");
INSERT INTO seh_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Penepo caoneka conzi cikulu ca mphepo, mabimbi mbakhamenya bote, iyo mbikhatoma dzala na madzi. ");
INSERT INTO seh_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yezu akhagona pyace n'nduli mwa bote mbakhatsamira nsago. Anyakupfundza ace amulamusa mbapanga tenepa: “Mpfundzisi tiri kufa ife!” ");
INSERT INTO seh_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Iye alamuka mbapwekera mphepo mbalonga kuna nyanza kuti: “Matama! Pfulika!” Penepo mphepo ya matama, mabimbi mbamaliratu. ");
INSERT INTO seh_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Penepo Yezu aabvundza anyakupfundza ace kuti: “Musagoperanji tenepa? Na lero musati kundikhulupira?” ");
INSERT INTO seh_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Iwo akhagopadi pikulu pyene mbakhalonga okha-okha tenepa: “Mbani onowu anabverwa na mphepo na mabimbi ene”. ");
INSERT INTO seh_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Buluka penepo Yezu na anyakupfundza ace afika ntunda unango wa nyanza ya Galileya, ku cisa ca Djerasa. ");
INSERT INTO seh_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Pa ndzidzi unowu udachita Yezu m' bote, abulukirambo na m'masiye mamuna m'bodzi akhali na mizimu ya kuipa, mbakhabwera kuna Yezu. ");
INSERT INTO seh_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mamuna uyu akhakhala m'masiye. Penepo nkhabe munthu akhankoza kumphata peno kum'manga na unyolo. ");
INSERT INTO seh_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Thangwi iye akhaphatiwa kazinji kene, mbakhamangwa na unyolo myendo na mikono ene. Mbwenye iye akhathumula basi pyonsene. Na tenepo nkhabe munthu akhakwanisa kunkunda. ");
INSERT INTO seh_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ntsiku zonsene, masiku na masikati akhafamba mbakhuwa n'zinthumbi na m'mapiri, mbakhaphekeka ekha na myala. ");
INSERT INTO seh_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Penepo iye na kuona Yezu na kutali, anthamangira mbamulambira, ");
INSERT INTO seh_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","mbakhuwa tenepa: “Yezu Mwana wa Mulungu wa kudzulu kakamwe, usafunanji na ine? Ndisakupanga na dzina ya Mulungu kuti ukhonde kundionesa nyatwa.” ");
INSERT INTO seh_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Penepyo, ndi thangwi Yezu akhadampanga kuti: “Buluka, muna munthu uyu iwe nzimu wa kuipa!” ");
INSERT INTO seh_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Pontho Yezu ambvundza kuti: “Iwe dzina yako ndiwe ani?” Iye atawira kuti: “Dzina yanga ndine Lejiau, thangwi ndife azinji.” ");
INSERT INTO seh_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Na tenepo, iye akhathimiza basi na kumphemba Yezu kuti akhonde kuithamangisa pa cisa cineci. ");
INSERT INTO seh_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Apo penepo, ukhalipo nkumbi ukulu wa nkhumba ukhasodza pa phiri. ");
INSERT INTO seh_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Na tenepo, mizimu ya kuipa yaphemba kuna Yezu kuti: “Tisiyeni pyathu tikhapite mu nkumbi wa nkhumba”. ");
INSERT INTO seh_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Penepo Yezu aitawirisa. Na tenepo, mizimu ya kuipa yabuluka muna munthu, mbiipita mu nkumbi wa nkhumba. Nkumbi onowu ukhathamangira ku pikwi piwiri, izo za numpha pa nkhomole mbazigwa n'nyanza, mbazimala kufa m'madzi. ");
INSERT INTO seh_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Penepo, akumbidzi a nkhumba onsene amala kuthawa mbaenda mbamwaza mphangwa zenezi mu nzinda na m'pisa. Anthu azinji aenda kaona ninji pikhadacitika. ");
INSERT INTO seh_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mudafika iwo pana Yezu, aona mamuna onowu akhakhala na mizimu mizinji ya kuipa, mbali mwadidi, na ndzeru zace za kubaliwa, mbakhakhala pantsi nawa na nguwo zace m'manungo. Anthu na kupiona adzumatirwa napyo. ");
INSERT INTO seh_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Apo ale akhadapiona na maso awo, atoma kulonga pyonsene kuna anthu, pire pikhadacitika kuna mamuna akhali na mizimu ya kuipa, pontho na pidacitika kuna nkumbi wa nkhumba. ");
INSERT INTO seh_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Na tenepo, anthu atoma kumphemba Yezu kuti iye abuluke n'dziko mwawo. ");
INSERT INTO seh_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ndzidzi ukhapakira Yezu m'bote, abwera mamuna ule akhakhala na mizimu yakuipa, kudza kamphemba Yezu kuti aende naye pabodzi. ");
INSERT INTO seh_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Mbwenye Yezu akhonda mbampanga kuti: “Ndoko kwanu. Ndoko kaapange abale ako pinthu pyonsene pidakucitira Mbuya, na ntsisi zidakubvera iye.” ");
INSERT INTO seh_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Na tenepo mamuna abuluka mbaenda ku Dhekapoli, (ndiko kubveka mizinda khumi) mbalonga pyonsene pikhadancitira Yezu. Penepo anthu onsene adzumatirwa napyo. ");
INSERT INTO seh_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yezu abwerera pontho na bote kwenda ntunda unango wa nyanza. Penepo anthu azinji atoma kugumanyikana pontho n'khundu mwace, pa gombe. ");
INSERT INTO seh_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Penepo, mamuna m'bodzi anacemerwa Djairo, m'bodzi wa atsogoleri wa nyumba ya kuphembera, pidaona iye Yezu, an'godamira pa myendo pace, ");
INSERT INTO seh_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","mbamphemba na kudembetera, mbalonga kuti: “Mwananga wa nkazi ali kufa. Bwerani mudze kamuikha manja toera awange, pontho apulumuke.” ");
INSERT INTO seh_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Penepo Yezu aenda naye. Mwinji wa anthu ukhantowerera mbakhapfinyana naye. ");
INSERT INTO seh_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Penepo akhalipo n'kazi m'bodzi akhadza mbadwala utenda wakubuluka ciropa, pa pyaka khumi na piwiri mbali nawo. ");
INSERT INTO seh_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Abvunga pinthu pyace pyonsene pikhali na iye na kusaka kukondziwa. Mbwenye nthenda ikhacimwanika kuwanga mbaona pezi nyatwa na akondzi, thangwi nthenda ikhanyanyiratu kakamwe. ");
INSERT INTO seh_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nkazi na kubva mbiri ya Yezu, abwera na kupapatula pakati pa mwinji wa anthu, mbafendedzera Yezu n'nduli mwace, mbankhuya nguwo zace. ");
INSERT INTO seh_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Thangwi iye akhalonga ekha ene kuti: “Ndingakwanisa kunkhuya nguwo zace basi, ndinawanga.” ");
INSERT INTO seh_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Pa ndzidzi ubodziyene, ciropa casiya kubuluka. Penepo iye abvadi kuti nthenda yawanga. ");
INSERT INTO seh_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Penepo pene, Yezu abva kuti mphambvu zace zapunguka muna iye. Na tenepo, iye azungunuka kuna mbumba, mbabvundzisa kuti: “Mbani adakhuya nguwo zanga?” ");
INSERT INTO seh_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Anyakupfundza ace antawira mbalonga kuti: “Imwe musaona kuti mbumba yonsene iyi isapfinyana na imwe. Musabvundza pyanu tenepa kuti mbani adandikhuya?” ");
INSERT INTO seh_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mbwenye Yezu akhalang'anisa basi nkhundu mwace, toera aone mbani akhadankhuya. ");
INSERT INTO seh_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Na tenepo, nkazi na kudzindikira pyonsene pidacitika kuna iye, agwa pa myendo pa Yezu, mbakhatetemera na kugopa mbalonga pyonsene. ");
INSERT INTO seh_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Penepo Yezu ampanga nkazi kuti: “Mwananga, kukhulupira kwako kwakupulumusa. Ndoko na ntendere, nthenda yako yawanga.” ");
INSERT INTO seh_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yezu mbadzati kumala kulonga afika anthu anango a pa nyumba ya ntsogoleri ule wa nyumba ya kumphembera, anacemerwa Djairo, iwo mbampanga kuti: “Mwana wanu wa nkazi afa.” Lekani kunsanyabve Mpfundzisi. ");
INSERT INTO seh_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mbwenye Yezu akhonda kutsalakana pyonsene ipi, mbampanga Djairo kuti: “Leka gopa, khulupira basi.” ");
INSERT INTO seh_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Penepo Yezu abuluka na Pedhru na amuna awiri mu ubale mwawo, anacemerwa Tiyago na Djuwau, mbakhonda kuperekerwa na anthu anango. ");
INSERT INTO seh_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pidafika iwo pa nyumba ya ntsogoleri wa nyumba ya kuphembera, agumana mwinji wa anthu mbukhakhuwa na kulira. ");
INSERT INTO seh_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yezu apita n'nyumba, mbabvundza anthu akhali mwenemu kuti: “Nkhuwo onowu na ciriro ceneci nchanji? Ntsikana hadafa tayu, mbwenye ali kugona”. ");
INSERT INTO seh_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mbwenye anthu atoma kunseka. Penepo Iye aabulusisa anthu onsene akhali n'nyumba, mbapita iye basi, na anyakupfundza ace atatu, na baba na mai wace mwana, mpaka ku mbuto kukhakhala mwana. ");
INSERT INTO seh_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yezu amphata manja ace mwana, mbampanga kuti: “Talita kumi!” Uku ndiko kubveka kuti: “Ntsikana, Ine ndisakupanga, lamuka!” ");
INSERT INTO seh_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Penepo pene, ntsikana akakhala na pyaka khumi na piwiri pya kubalwa, alamukiratu mbafamba. Anthu onsene adzumatirwa napyo pikulu kakamwe. ");
INSERT INTO seh_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Mbwenye Yezu aapanga kuti akhonde kupanga munthu penepyo. Pa kumala penepo aapanga kuti ampase mwana ca kudya. ");
INSERT INTO seh_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yezu na anyakupfundza ace abuluka penepo mbaenda ku nzinda udabalwa iye. ");
INSERT INTO seh_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pakufika ntsiku ya sabudu, Yezu atoma kupfundzisa mu nyumba ya kuphembera. Azinji anthu akhambvesera pikhapfundzisa iye, akhadzuma mbakhalonga kuti: “Pyabuluka kupi pyonsene ipi? Apaswa na ani udziwisi unowu? Asacita tani pirengo penepyo? ");
INSERT INTO seh_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kodi siye unowu tayu karapintero mwana wa Mariya? Pontho abale ace aamuna siwo ale anacemerwa Tiyago, Zuze, Djuda na Simau? Anakazi ace siwo ale anakhala na ife kuno tayu?” Na tenepo iwo onsene akhampwaza. ");
INSERT INTO seh_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Mbwenye Yezu aapanga kuti: “Mporofeta asafuniwa mbuto zonsene. Mbwenye nkhabe kufuniwa ku dziko kwace, pakati pa abale ace a dzindza na abale a pa nyumba.” ");
INSERT INTO seh_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Na tenepo, Yezu akhakhonda kucita pirengo ku Nazareti. Mbwenye akhatawira kuangisa atenda anango na kuaikha manja basi. ");
INSERT INTO seh_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yezu adzumatirwa nawo na thangwi ya kukhonda kutawira kwawo. Na tenepo anyerezera pyace kwenda kapfundzisa anthu anango a nkhundu. ");
INSERT INTO seh_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yezu acemera anyakupfundza ace khumi na awiri, mbaatuma awiri-awiri, pontho na kuapasa mphambvu za kuthamangisa mizimu ya kuipa. ");
INSERT INTO seh_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Penepo Yezu aapanga kuti: “Pa ulendo wanu kwatani mpsimbo basi. Lekani kukwata nkate, budu peno kobiri n'cunu mwanu. ");
INSERT INTO seh_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Bvalani nsapato zanu, mbwenye lekani kukwata nguwo inango ya papezi. ");
INSERT INTO seh_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mungapita n'nyumba, khalani mwenemu mpaka ntsiku ya kubuluka kwanu. ");
INSERT INTO seh_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mungakhonda kutambirwa na anthu panafika imwe, pontho iwo mbakhonda kukubverani, bulukani pyanu. Mungabuluka, gubudzani pfumbi ya manyalo anu, ninga umboni wa kuapikirira.” ");
INSERT INTO seh_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Na tenepo, anyakupfundza a Yezu abuluka mbaenda mbalonga kuna anthu kuti achunyuke kudawa kwawo. ");
INSERT INTO seh_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Akhabulusa mizimu mizinji ya kuipa, akhawangisa atenda azinji na kuadzodza mafuta. ");
INSERT INTO seh_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Pyonsene ipyo pyafika m'makutu mwa mambo Herodhi, thangwi mbiri ya Yezu ikhadafika monsene. Anthu anango akhalonga kuti: “Djuwau Batixta alamuka pa kufa. Ndi thangwi eneyo Yezu anamphambvu za kucita pirengo penepyo. ");
INSERT INTO seh_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Anango akhalonga kuti ndi Eliya. Anangombo akhalonga kuti ndi mporofeta, ninga m'bodzi wa aporofeta akale.” ");
INSERT INTO seh_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mbwenye Herodhi mudabva iye pyonsene ipi, alonga kuti: “Ndimo mwene uyu ndiyedi Djuwau Batixta, ule akhadagwandisa ine nsolo. Alamuka pa kufa.” ");
INSERT INTO seh_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Thangwi Herodhi akhadamangisadi Djuwau Batixta mbamuikhisa n'kaidi. Penepyo apicita na thangwi ya Herodhia, nkazi wa m'bale wace Herodhi anacemerwa Filipi. Iye Herodhi akhadankwata mbakhala nkazi wace. ");
INSERT INTO seh_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Na thangwi eneyo, Djuwau Batixta akhadampanga Herodhi kuti: “Mwambo nkhabe kutawirisa tayu kuti ucite banja na nkazi wa m'bale wako.” ");
INSERT INTO seh_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Na tenepo iye Herodhia, atoma kupitirwa na nyongo na Djuwau Batixta, mbakhafuna kumphesa, mbwenye akhapicimwana. ");
INSERT INTO seh_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Thangwi iye Herodhi akhagopa Djuwau Batixta, pontho akhambvunulira, na kudziwa kuti Djuwau akhali munthu wa kulungama pontho akhali munthu wa Mulungu. Na tenepo, Herodhi pikhamubva iye mbalonga, akhadzudzumika napyo, mbwenye akhakomerwa basi na kumubva. ");
INSERT INTO seh_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ntsiku idacita Herodhi caka, acita phwandu ikulu kakamwe mbacemeresa akulu-akulu a utongi, na akulu a anyankhondo, na amambo a ku dziko ya Galileya. Penepo Herodhia, nkazi wace Herodhi aona njira ya kupita nayo. ");
INSERT INTO seh_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mudapita n'thando mwana wace Herodhia wa nkazi mbabvina pikulu kakamwe, atsandzaisa Herodhi, na akulu onsene akhali penepo. Mambo ampanga ntsikana kuti: “Phemba pinafuna iwe, ine ndinakupasa.” ");
INSERT INTO seh_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Na tenepo, Herodhi alonga pontho na kudumbira kuti: “Ndinakupasa pyonsene pinandiphemba iwe, na phindi ene ya dziko yanga ungapifuna.” ");
INSERT INTO seh_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mwana ntsikana abuluka mbaenda kabvundza mai wace kuti: “Ndina phemba anji?” Mai wace antawira kuti: “Phemba nsolo wa Djuwau Batixta.” ");
INSERT INTO seh_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Na tenepo ntsikana abwera na mwansanga mbaenda kuna mambo Herodi mbaphemba kuti: “Ndisafuna kuti mundipase cincino pano, nsolo wa Djuwau Batixta, m'mbale.” ");
INSERT INTO seh_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Penepo mambo atsukwala napyo pikulu. Mbwenye acimwa kunkhondera na thangwi ya cidumbiriro cikhadacita iye pa maso pa akulu onsene akhali pa phwandu. ");
INSERT INTO seh_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Na tenepo, mambo atuma nyankhondo wace na mwansanga toera am'bweresere nsolo wa Djuwau. Penepo nyankhondo alamuka mbaenda kagwanda nsolo wa Djuwau n'kaidi, ");
INSERT INTO seh_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","mbauikha m'mbale mbaupasa ntsikana. Iye ntsikana mbaenda kapasambo mai wace. ");
INSERT INTO seh_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Anyakupfundza a Djuwau Batixta na kubva mphangwa zenezi, aenda kakwata manungo a nyakwenda mbaenda kaaikhisa. ");
INSERT INTO seh_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Anyakupfundza a Yezu abwerera mbaenda kampanga Yezu pyonsene pidacita iwo na pidapfundzisa iwo. ");
INSERT INTO seh_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Penepo pakhagumanika anthu azinji. Awa akhafika awa akhaenda. Yezu na anyakupfundza ace akhausowa ndzidzi wa kudya. Na tenepo, Iye aapanga anyakupfundza ace kuti: “Tendeni pa khundu, pathu tekha, tikhapume pang'ono.” ");
INSERT INTO seh_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Na tenepo, iwo abuluka onsene mbakwira m'bote mbaenda pa mbuto ibodzi, yawo okha. ");
INSERT INTO seh_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mbwenye anthu azinji aaona kubuluka kwawo, mbaadzindikira kuti ndiwo. Penepo, anthu abuluka m'mizinda yonsene mbaenda mbathamanga na myendo mpaka pa mbuto eneyo, anyakupfundza a Yezu mbadzati kufika kweneko. ");
INSERT INTO seh_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pakuchita m'bote, Yezu aona mwinji ukulu wa anthu, mbaabvera ntsisi, thangwi akhakhala ninga mabira akusoweka nkumbidzi. Na tenepo atoma kuapfundzisa pinthu pizinji. ");
INSERT INTO seh_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pikhadoka dzuwa, anyakupfundza a Yezu abwera kuna Iye mbalonga kuti: “Dzuwa iri kudoka, pontho, muno ndi n'thando. ");
INSERT INTO seh_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Apangeni anthu kuti aende pyawo m'pisa pya dhuzi, aende kagule pya kudya. Thangwi pano nkhabe ca kudya.” ");
INSERT INTO seh_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Mbwenye Yezu atawira kuti: “apaseni imwe ca kudya.” Mphapo anyakupfundza ace antawira kuti: “Toera kugula mikate inakwana kuli anthu onsene awa, tisafunika tikhale na madzana mawiri a kobiri.” ");
INSERT INTO seh_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Penepo Yezu aapanga kuti: “Ndokoni mukhaone, muna mikate mingasi?” Iwo aenda kaona mbantawira kuti: “ife tina mikate mixanu, na nyama ziwiri za m'madzi.” ");
INSERT INTO seh_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Na tenepo, Yezu apanga mbumba kuti ikhale pantsi nsoka-nsoka, pa tsanga ya cimbanjiri. ");
INSERT INTO seh_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Penepo onsene akhala pantsi mbagumanyana misoka ya makumaxanu ya anthu, inango ya dzana ya anthu. ");
INSERT INTO seh_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Pa kumala, Yezu akwata mikate ire mixanu na nyama ziwiri zire za m'madzi mbalang'ana kudzulu apereka takhuta mbaimenya-menya. Buluka penepo, aipasa anyakupfundza ace toera iwo aigawirembo mbumba. Pa kumala akwatambo nyama mbagawirambo anthu. ");
INSERT INTO seh_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Onsene adya mbakhuta. ");
INSERT INTO seh_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Penepo anyakupfundza alokotera mapindi adasala a mikate na a nyama za m'madzi, mbadzaza nawo pitundu khumi na piwiri. ");
INSERT INTO seh_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nsoka udadya ukhali wa pikwi pixanu pya amuna. ");
INSERT INTO seh_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Buluka penepo, Yezu aapanga anyakupfundza ace kuti apakire m'bote, atsogole aende ku dziko ya Bhetisaidha, Iye mbasala mbapanganizana na mbumba. ");
INSERT INTO seh_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pidamala Iye kupanga mbumba kuti iyende pyayo, akwira pa phiri kwenda kaphembera. ");
INSERT INTO seh_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pakudoka dzuwa, bote ikhagumanika pakati pa nyanza, mbwenye Yezu akhakhala ekha ene pa ntunda. ");
INSERT INTO seh_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Mangwana mwace, m'bambakuca, Yezu aona kuti anyakupfundza ace aneta na kucapa bote yawo, thangwi akhaenda kukhabuluka mphepo. Na tenepo Yezu aenda kuna iwo mbakhafamba padzulu pa madzi. Mudafika iye dhuzi acita ninga asafuna kuapitirira. ");
INSERT INTO seh_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Anyakupfundza ace na kumuona mbafamba padzulu pa madzi, atoma kukhuwa na kugopa. Thangwi akhanyerezera kuti ndi ciphoko. ");
INSERT INTO seh_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Na mwenemo onsene akhadamuona, atutumuka napyo. Mbwenye Yezu aapangiratu kuti: “khalani na cipapo! Ndine pano, lekani kugopa.” ");
INSERT INTO seh_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Penepo Yezu akwira m'bote mbakhala pabodzi na anyakupfundza ace, mphepo mbimatama. Na tenepo anyakupfundza onsene adzumatirwa napyo mbamala ndzeru. ");
INSERT INTO seh_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Thangwi cirengo ca mikate hakhadzati kucibvesesa. Pontho mitima yawo ikhadauma. ");
INSERT INTO seh_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pidawambuka Yezu na anyakupfundza ace ntunda unango wa Djenezareti, atsamisa bote yawo pa gombe mbaimangira. ");
INSERT INTO seh_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pidapandira iwo m'bote, penepo pene anthu andzindikira Yezu. ");
INSERT INTO seh_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Na tenepo, iwo abuluka mbaenda mbathamanga m'pisa mule monsene, mbakhadzesa atenda awo m'makha, mbakhaakwata mbaeda nawo m'mbuto zikhabva iwo kuti Yezu ali kweneku. ");
INSERT INTO seh_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Mbuto zonsene zikhafamba Yezu, kutomera m'mizinda, peno m'pisa peno m'minda, anthu onsene akhadzesa atenda mphambano, mbakhaphemba Yezu kuti aasiye atenda awo ankhuye nguwo zace basi. Na tenepo atenda onsene akhan'khuya akhawangiswadi. ");
INSERT INTO seh_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ntsiku inango afarisi, na anyakudziwisa anango a mwambo akhabuluka ku Djerusalema, agumanyikana pabodzi pene na Yezu. ");
INSERT INTO seh_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Iwo aona anyakupfundza anango a Yezu mbakhadya na manja akuswipa. Uku nkhubveka, mbasati kusamba manja. ");
INSERT INTO seh_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Thangwi madjuda onsene na afarisi, nkhabe kudya mbasati kusamba pyadidi manja, toera kutoeza mwambo udapfunziswa iwo na ambuya awo. ");
INSERT INTO seh_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Na tenepo, angabuluka kunsika nkhabe kudya mbasati samba. Pontho asatoeza mitemo inango mizinji ninga, kutsukwa kwa makhomicho, milinga, na pyombo pinango pya nkuwa na matalimba.) ");
INSERT INTO seh_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Na tenepo, afarisi na anyakudziwisa a mwambo abvundzisa Yezu kuti: “Thangwi yanji anyakupfundza ako nkhabe kutoeza ntemo wa akulu athu akale, mbadya mbakhonda samba manja?” ");
INSERT INTO seh_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yezu aatawira tenepa: “Anyauthambi! Ndimo mwenedi pikhalonga mporofeta Izaiya na thangwi yanu, mbalemba tenepa: ‘Mbumba iyi isandilemedza na milomo yawo basi, mbwenye mitima yawo iri kunja kwa ine. ");
INSERT INTO seh_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Asandilambira pa pezi, mbapfundzisa myambo ya anthu’, mbikhala ninga ndi matongero a Mulungu. ");
INSERT INTO seh_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Imwe musapwaza matongero a Mulungu mbamutoeza myambo ya anthu.” ");
INSERT INTO seh_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yezu alonga pontho tenepa: “Imwe kazinji kene musakoza kusiya pang'ono matongero a Mulungu, toera kutoeza myambo yanu inapfundzisa imwe. ");
INSERT INTO seh_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Thangwi Mozesi apfundzisa tenepa: ‘Lemedza baba wako na mai wako.’ Mbalonga pontho kuti: ‘Ule anaxola baba wace peno mai wace, asatongwa kuti aphiwe.’ ");
INSERT INTO seh_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mbwenye imwe musapfundzisa kuti munthu angalonga kuna mai wace peno baba wace kuti: ‘pinthu pikhafuna imwe kutambira na ine mphya Korobhani, (khorobhani nkhubveka, ndi ntsembe ya Mulungu),’ ");
INSERT INTO seh_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","munthu onowu imwe musankhondesa kuti aleke kucitabve pinatongwa iye kucitira baba wace na mai wace. ");
INSERT INTO seh_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Tenepa, imwe musafudza fala ya Mulungu, mbamuicinja na mitemo yanu, idacita imwe. Pontho musacita pinthu pizinji pinango pyakulandana na penepyo.” ");
INSERT INTO seh_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yezu aucemera pontho mwinji wa anthu mbaupanga tenepa: “Bveserani mwonsene mupiyikhe m'makutu pire pyonsene pinafuna kukupangani ine kuti: ");
INSERT INTO seh_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Pyonsene pinabuluka kunja mbapipita muna munthu nkhabe ‘kumpsipisa’. Mbwenye cire cinabuluka mu ntima, ceneco ndico ‘cinapsipisa’ munthu. ");
INSERT INTO seh_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ana makutu a kubva, mbabve!” ");
INSERT INTO seh_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yezu mudamwazana iye na mbumba, apita n'nyumba, anyakupfundza ace mbambvundza kuti usalongeranji nsanje onowu. ");
INSERT INTO seh_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Iye aapanga tenepa: “Na imwe ene mudapibvesesambo tayu? Imwe nkhabe dziwa kuti pire pinapita na pa mulomo pa munthu nkhabe ‘kumpsipisa’?” ");
INSERT INTO seh_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Thangwi penepyo nkhabe pita mu ntima, mbwenye pisaenda n'cifu pingamala mbapibuluka kunja. Na mafala awa, Yezu akhapangiza kuti pyakudya pyonsene pya ceneswa. ");
INSERT INTO seh_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Iye athimiza pontho kulonga tenepa: “Cinabuluka muna munthu ndico ‘cinampsipisa’. ");
INSERT INTO seh_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Thangwi mu ntima mwace ndimo munabuluka manyerezero a kuipa ninga lukwali, umbava, upandu, upombo, ");
INSERT INTO seh_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kusirira, kuipa ntima, uthambi, bibvu, pseda, kupikuza, kuzuda na kusoweka ndzeru. ");
INSERT INTO seh_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Pyonsene ipi pya kuipa pisabuluka mu ntima mwa munthu. Penepyo ndipyo ‘pinampsipisa.’” ");
INSERT INTO seh_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yezu abuluka mbaenda m'pisa pya dhuzi na nzinda wa Tiru na wa Sidhonya. Iye akhafuna tayu kuti anthu andziwe kuna iye. Na tenepo, apita n'nyumba, mbwenye acimwana kubisala n'dzidzi ukulu ene. ");
INSERT INTO seh_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nkazi m'bodzi, akhali na mwana wace wa nkazi akhali na nzimu wa kuipa, na kubva mbiri ya Yezu, na mwansanga aenda kan'godamira pa myendo pace. ");
INSERT INTO seh_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nkazi akhali wa dzindza ya agerego, wa ku dziko ya Siro Finisya. Akaphemba kuna Yezu kuti aubuluse nzimu wa kuipa ukhali na mwana wace. ");
INSERT INTO seh_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Mbwenye Yezu antawira tenepa: “cakutoma siya ana adye akhute. Thangwi si pyadidi tayu bulusa nkate wa ana, mbatipasa pinchinja pya anambwa.” ");
INSERT INTO seh_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nkazi atawira tenepa: “Ande Mbuya, mbwenye pinchinja pya anambwa pisadya mbipilokotera umbwera-mbwera wa mikate unagwisa ana, pa thando panadya iwo.” ");
INSERT INTO seh_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Na tenepo, Yezu ampanga kuti: “Na thangwi ya matawiriro adacita iwe, ndoko. Nzimu wa kuipa wabuluka muna mwana wako.” ");
INSERT INTO seh_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Mudaenda nkazi ku nyumba kwace, agumana mwana wace ali lamba pa talimba, thangwi nzimu wa kuipa ukhadabuluka kale muna iye. ");
INSERT INTO seh_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yezu abuluka pontho m'pisa pya pa dhuzi na nzinda wa Tiru, mbagwanda na pa nzinda wa Sidhonya mpaka ku nyanza ya Galileya na cisa ca Dhekapoli. ");
INSERT INTO seh_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Kweneko anthu andzesera mamuna m'bodzi wa kukhonda kubva, pontho iye akhalonga mwadidi mwene tayu. Iwo amphemba kuti amuikhe djanja. ");
INSERT INTO seh_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yezu am'bulusa mamuna pakati pa mbumba mbamuikha pyala m'makutu mwace. Buluka penepo aphula mata pang'ono mbaikha pa lirimi ya mamuna. ");
INSERT INTO seh_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Na tenepo, alang'ana kudzulu, mbapuma na mphambvu, mbalonga tenepa: “Efata!” Ndiko kubveka: “Fungulika!” ");
INSERT INTO seh_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Makutu a mamuna ule afunguka, pa ndzidzi ubodzi-bodzi lirimi yace yasudzuka, mbatoma kulonga mwadidi mwene. ");
INSERT INTO seh_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Penepo, Yezu aakhondesa anthu onsene kumwaza mphangwa zenezi. Mbwenye pikaakhondesa iye, anthu akhanyanyeratu kulonga pikhadacitika. ");
INSERT INTO seh_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Na tenepo, onsene akhabva akhadzumatirwa napyo mbalonga tenepa: “Onani pyonsene asacitadi pyadidi kakamwe! Asacita kuti anakhonda kubva abve, na anakhonda kulonga alonge!” ");
INSERT INTO seh_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Pa kupita ntsiku pang'ono, wagumanyikana pontho mwinji wa anthu. Na thangwi ya kusoweka ca kudya, Yezu acemera anyakupfundza ace mbaapanga kuti: ");
INSERT INTO seh_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Ndina ntsisi na mwinji wa anthu awa, thangwi ana ntsiku zitatu na Ine, pontho pano nkhabe ca kudya. ");
INSERT INTO seh_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ndingaabweza m'midzi mwawo tenepa na njala, ana komoka n'njira. Thangwi anango abuluka kutali. ");
INSERT INTO seh_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Mbwenye anyakupfundza ace antawira kuti: “Tinaigumana kupi mikate yace inakwana anthu onsene awa, n'thando ninga muno?” ");
INSERT INTO seh_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yezu aabvundza kuti: “Muna mikate mingasi penepo?” Iwo atawira kuti: “Tina mikate minomwe.” ");
INSERT INTO seh_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Na tenepo, Yezu aipanga mbumba kuti ikhale pantsi. Buluka penepo, akwata mikate minomwe ire mbapereka takhuta kuna Mulungu, aimenya mbaipasa anyakupfundza ace toera iwo aigawirembo mbumba. Iwo penepyo apicita. ");
INSERT INTO seh_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Zikhalipombo nyama pang'ono za m'madzi. Yezu azikwata mbapereka takhuta kuna Mulungu, mbazipasa anyakupfundza ace, toera iwo azigawirembo mbumba. ");
INSERT INTO seh_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Onsene adya mbakhuta. Pa kumala akwanisa kudzaza pitundu pinomwe na mapindi adasala a mikate. ");
INSERT INTO seh_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Anthu adadya akhathamangira ku pikwi pinai. Pa kumala penepo Yezu aibweza mbumba mbienda. ");
INSERT INTO seh_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Buluka penepo, Yezu akwira m'bote na anyakupfundza ace mbaenda cisa ca Dhalimanuta. ");
INSERT INTO seh_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Afarisi abwera mbatoma kuketesana na Yezu. Toera kumulesera, amphemba cidzindikiro ca kudzulu. ");
INSERT INTO seh_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Mbwenye Yezu anentseka pikulu mbalonga kuti: “Thangwi yanji anthu awa asaphemba cidzindikiro ca pirengo? Mphapo Ine ndinakupangani pa kweca kuti anthu enewa, iwo nkhabe kudza kacitirwa cidzindikiro cibodzi.” ");
INSERT INTO seh_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Penepo Yezu aasiya, mbapakira pyace pontho m'bote, mbaenda ntunda unango wa nyanza. ");
INSERT INTO seh_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Anyakupfundza a Yezu akhadaduwala kukwata mikate. Iwo akhali na nkate ubodzi basi m'bote. ");
INSERT INTO seh_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Penepo Yezu aacenjeza mbalonga kuti: “Citani mphole na nsunga wa afarisi na wa Herodi”. ");
INSERT INTO seh_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Na tenepo, anyakupfundza na kubva penepyo akhaketesana okha-okha, mbakhalonga kuti: “Iye ali kulonga tenepa thangwi ife nkhabe mikate”. ");
INSERT INTO seh_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yezu na kubva kuketesana kukhacita iwo, aabvundza kuti: “Thangwi yanji muli kuketesana na thangwi ya kusowa mikate? Mudzati basi kupidziwa na kupibvesesa pidalonga ine? Ndi thangwi yanji muli kuuma mitima tenepa mbamukhonda kubvesesa? ");
INSERT INTO seh_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Muna maso mbwenye nkhabe kuona? Muna makutu mbwenye nkhabe kubva? Imwe nkhabe kukumbuka, ");
INSERT INTO seh_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","mikate mixanu idagawirene anthu akukwana pikwi pixanu? Pitundu pingasi pidadzaza imwe na mapindi a kusala?” Iwo atawira kuti: “khumi na piwiri.” ");
INSERT INTO seh_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Pontho nkhabe kukumbuka, kuti Ine ndagawa mikate minomwe kuna anthu akukwana pikwi pinai? Pitundu pingasi pyakudzala na mapindi a mikate adagumanya imwe?” Iwo atawira kuti: “Pinomwe”. ");
INSERT INTO seh_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yezu aabvundza kuti: “Mphapo imwe mudzati basi kupibvesa tayu?” ");
INSERT INTO seh_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Buluka penepo Yezu na anyakupfundza ace afika ku dziko ya Bhetisaidha. Penepo anthu anango abweresa dzimola m'bodzi, mbaphemba Yezu kuti ankhuye. ");
INSERT INTO seh_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Penepo Yezu aphata nkono wa dzimola mbamulamusa mbaenda naye kunja kwa cisa. Kweneko Yezu aphula mata mbankhwaza m'maso mwace, ansandzika manja mbambvundza kuti: “Usaona pinthu?” ");
INSERT INTO seh_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mamuna afungula maso ace mbalonga kuti: “Ande ndiri kuona anthu. Mbwenye ndiri kuaona ninga miti yakufamba”. ");
INSERT INTO seh_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Na tenepo, Yezu asandzika pontho manja m'maso mwa mamuna. Kubulukira penepo, mamuna awanga, mbatoma kuona mwadidi na kutali, pyonsene pikhali nkhundu mwace. ");
INSERT INTO seh_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Penepo Yezu ampanga kuti: “Leka kupitabve n'cisa. Ndoko ku nyumba kwako!” ");
INSERT INTO seh_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Pa kumala penepo, Yezu abuluka na anyakupfundza ace mbaenda mpisa pya Sezareya na pya Filipi. Mukhaenda iwo n'jira, Yezu aabvundzisa kuti: “Kodi anthu asalonga kuti Ine ndine ani?” ");
INSERT INTO seh_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Iwo atawira kuti: “Anango asakulongani kuti Ndimwe Djuwau Batixta, anango ndiwo asalonga kuti ndimwe Eliya, anangombo ndiwo asalonga kuti ndimwe m'bodzi wa aporofeta”. ");
INSERT INTO seh_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yezu athimiza pontho na kuabvundza kuti: “Imwembo musandilonga Ndine ani?” Penepo pene Pedhru antawira kuti: “Imwe Ndimwe Misiya”. ");
INSERT INTO seh_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Penepo, Yezu aakhondesa kuti aleke kupanga munthu unango pinthu penepyo. ");
INSERT INTO seh_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Na tenepo, Yezu atoma kupfundzisa anyakupfundza ace mbaapanga kuti: “Ine Mwana wa Munthu ndisafunika kuti ndione nyatwa zizinji, ndinadza kakhondiwa na mathubu, na akulu aanyantsembe, na anyakudziwisa a mwambo onsene. Pontho ndinadza kaphiwa, mbwenye pakupita ntsiku zitatu ndinadza kalamuka pa kufa.” ");
INSERT INTO seh_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iye akhalonga penepyo pa kweca. Penepo Pedhru ancemera Yezu pa khundu, mbansandika. ");
INSERT INTO seh_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Mbwenye Yezu azungunuka mbalang'ana anyakupfundza ace, mbasandika Pedhru na kumulongera kuti: “Buluka iwe Sathani, pa maso panga! Thangwi iwe usadziwa manyerezero a anthu basi, mbwenye nkhabe dziwa kunyerezera kwa Mulungu”. ");
INSERT INTO seh_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Na tenepo, Yezu acemera mbumba yonsene pabodzi na anyakupfundza ace, mbaapanga tenepa: “Ule anafuna kunditowera asatongwa akhondeke ekha ene, akwate ntanda wace anditowere. ");
INSERT INTO seh_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Thangwi onsene anafuna kukoya upulumuki wace anauluza. Mbwenye analuza upulumuki wace na thangwi yanga na ya Mphangwa Zadidi, anauwina. ");
INSERT INTO seh_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Thangwi pinaphedzeranji munthu kuwina dziko yonsene ya pantsi, mbaluza nzimu wace? ");
INSERT INTO seh_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Peno ndi ninji cinafuna kupereka munthu kuti acinje na nzimu wace? ");
INSERT INTO seh_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Na tenepo, munthu anakhala na manyadzo na Ine pontho na mafala anga, pa midzidzi ino ya anthu a kuipa na anyakudawa, Ine Mwana wa Munthu ndinakhalambo na manyadzo na iye ndingadza kabwera na mbiri ya Baba wanga pabodzi pene na anju zace zakulungama.” ");
INSERT INTO seh_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yezu athimiza na kulonga kuti: “Dziwani kuti pano alipo anthu anango anafuna ona Umambo wa Mulungu mbubwera na mphambvu, iwo mbasati kufa.” ");
INSERT INTO seh_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pa kupita ntsiku zitanthatu, Yezu akwatana na Pedhru, na Tiyago, na Djuwau, okha ene, mbakwira nawo pa phiri yakulapha kakamwe. Penepo Yezu asanduka makhaliro ace pa maso pawo. ");
INSERT INTO seh_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nguwo zace zikhadaceneratu kakamwe mbaziyetimira. Nkhabe munthu wakudziwisa kufula pa dziko ino, anakwanisa kufula mbazicenesa tenepale. ");
INSERT INTO seh_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Penepo anyakupfundza ace atatu, aona Eliya na Mozesi mbakhaceza na Yezu. ");
INSERT INTO seh_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Na tenepo, Pedhru alonga kuti: “Mpfundzisi, mphyadidi tikhale pyathu pano! Ife tinamanga makumbi matatu. Ibodzi yanu, ibodzi ya Mozesi, ibodzi ya Eliya”. ");
INSERT INTO seh_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pedhru hakhapidziwa tayu pikhalonga iye, thangwi iwo onsene akhagopa. ");
INSERT INTO seh_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Penepo pene khole ibodzi ya kudzulu, yaagudumira. Pa khole pabveka fala ikhalonga tenepa: “Uyu ndi Mwana Wanga wakufunika. Mbvereni!” ");
INSERT INTO seh_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Pa ndzidzi ubodzi-bodzi, anyakupfundza ace alang'ana n'khundu adaonabve munthu unango tayu, mbwenye aona Yezu basi. ");
INSERT INTO seh_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mukhachita iwo pa phiri, Yezu aapanga kuti aleke kupanga munthu pire pyonsene pidaona iwo, mpaka kufikira kuti Ine Mwana wa Munthu ndalamuka pa kufa. ");
INSERT INTO seh_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Iwo acita ninga mudaapangira Yezu, mbwenye akhaketesana okha-okha na kufuna kudziwa kuti isabvekanji fala eneyi ya “kulamuka pa kufa”. ");
INSERT INTO seh_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Na tenepo, iwo abvundzisa Yezu kuti: “Thangwi yanji anyakudziwisa a mwambo asalonga kuti Eliya ndiye anafuna toma kubwera?” ");
INSERT INTO seh_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yezu aatawira tenepa: “Ndimo mwene Eliya ndiye anafuna toma bwera, toera adze kasasanyire pyonsene. Na tenepo, thangwi yanji mphapo Bukhu ya Mulungu isalonga kuti Ine Mwana wa Munthu ndisafunika kuti ndidze kaone nyatwa zikulu mbandikhondiwa? ");
INSERT INTO seh_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mbwenye Ine ndinakupangani kuti Eliya abwera kale. Imwe mwancitira pyonsene pikhafuna imwe, ninga mudalemberwa ipyo m'Bukhu ya Mulungu pa thangwi yace.” ");
INSERT INTO seh_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mudafika iwo dhuzi na anyakupfundza andzawo anango, aona mwinji wa anthu ukhadaazungulira. Penepo anyakudziwisa a mwambo akaketesana nawo. ");
INSERT INTO seh_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Penepo pene, mbumba yonsene pidaona iwo Yezu, yatutumuka mbithamanga kwenda kam'mwanyika. ");
INSERT INTO seh_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Na tenepo, Yezu abvundza kuti: “Ninji pinaketesana imwe?” ");
INSERT INTO seh_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mamuna m'bodzi pakati pa anthu antawira tenepa: “Mpfundzisi, ndakudzeserani mwana wanga wa mamuna thangwi iye ana nzimu wa kuipa, unancimwanisa kulonga. ");
INSERT INTO seh_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kazinji kene nzimu wa kuipa ungamphata, usangwisa pantsi. Penepo asatoma buluka mapobvu n'kanwa, mbaluma mano, manungo ace mbauma. Ine ndaphemba anyakupfundza anu kuti aubuluse nzimu onowu wa kuipa, mbwenye iwo aucimwana”. ");
INSERT INTO seh_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yezu atawira tenepa: “Imwe anthu akusowa cikhulupiro! Ndinakhala na imwe mpaka lini? Mpaka lini ndinakuonerani nyatwa? M'bwereseni pano mphale”. ");
INSERT INTO seh_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Na tenepo, iwo andzesera. Nzimu wa kuipa na kuona Yezu, penepo pene am'bhoma mphale na mphambvu mbagwa pantsi, mbatoma kubulumunda na kubuluka mapobvu n'kanwa. ");
INSERT INTO seh_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Penepo, Yezu abvundza baba wace mwana kuti: “Atoma nayo lini nthenda eneyo mwana wako?” Iye antawira kuti: “Atoma nayo mbali mwana.” ");
INSERT INTO seh_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Kazinji kene nzimu wa kuipa usangwisa pa moto, na m'madzi, toera kumupha. Mbwenye mungakwanisa Mbuya tibverenimbo ntsisi mutiphedze.” ");
INSERT INTO seh_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yezu antawira tenepa: “Mungakwanisa? Nkhabe cinthu cinacimwanika kuna munthu anakhulupira.” ");
INSERT INTO seh_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Penepo pene, baba wace mphale akhuwa mbalonga tenepa: “Ine ndisatawira, mbwenye ndiphedzeni ndikhale na cikhulupiro!” ");
INSERT INTO seh_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yezu na kuona mwinji wa anthu ukhanfendedzera, aupwekera nzimu wa kuipa mbaupanga kuti: “Iwe nzimu wa kukhonda kubva na kulonga, buluka muna mwana uyu. Leka kupita pontho muna iye”. ");
INSERT INTO seh_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nzimu wa kuipa wakhuwa mbubhoma mwana na mphambvu, mbubuluka muna iye mbansiya akomoka. Na thangwi eneyi, anthu onsene akhali penepo, akhalonga kuti mwana afa. ");
INSERT INTO seh_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mbwenye Yezu amphata mwana pa nkono mbamulamusa, iye mbalimira. ");
INSERT INTO seh_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Pidapita Yezu n'nyumba, anyakupfundza ace ambvundza pa khundu tenepa: “Thangwi yanji ife tacimwana kuubulusa nzimu onowu?” ");
INSERT INTO seh_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Iye aatawira tenepa: “Mizimu ninga na iyi isabuluka basi na maphembero na kupimana ca kudya.” ");
INSERT INTO seh_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yezu na anyakupfundza ace abuluka penepo mbapita na ku Galileya. Mbwenye iye akhafuna tayu kudziwika na munthu kukhakhala iye. ");
INSERT INTO seh_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Thangwi iye akhapfundzisa anyakupfundza ace, mbaapanga tenepa: “Ine Mwana wa Munthu ndinati ndiperekwe m'manja mwa anthu. Iwo anandipha, mbwenye pakupita ntsiku zitatu Ine ndinalamuka pa kufa.” ");
INSERT INTO seh_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Anyakupfundza ace akhapibvesa mwadidi tayu pikhalonga iye, mbwenye akhagopa kumbvundzisa. ");
INSERT INTO seh_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yezu na anyakupfundza ace afika ku nzinda wa Kafaranaumi. Pikhakhala iwo pa nyumba, Yezu abvundza anyakupfundza ace khumi na awiri tenepa: “Ndi ninji pikhadza imwe mbamuketesana na njira?” ");
INSERT INTO seh_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mbwenye iwo amatama, thangwi n'jira akhadza mbaketesana kuti mbani nkulu pa nsoka wawo. ");
INSERT INTO seh_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Penepo Yezu akhala pantsi, aacemera anyakupfundza ace khumi na awiri, mbaapanga tenepa: “Ule anafuna khala wakutoma, anakhala wakumalisa, pontho anakhala nyabasa wa onsene.” ");
INSERT INTO seh_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Penepo akwata mwana m'bodzi mbamuikha pakati pawo.Yezu ankhumbatira mbalonga kuna anyakupfundza ace tenepa: ");
INSERT INTO seh_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ule anatambira mwana ninga uyu na dzina yanga, asatambira Ine ene. Ulembo ananditambira, asatambira Ine, na ule ene adandituma.” ");
INSERT INTO seh_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Penepo Djuwau ampanga Yezu tenepa: “Mpfundzisi, taona mamuna mbakhabulusa mizimu ya kuipa na dzina yanu, mbwenye ife tankhondesa, thangwi iye si ndzathu tayu.” ");
INSERT INTO seh_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yezu aatawira tenepa: “Nsiyeni pyace, lekani kunkhondesa. Thangwi nkhabe munthu anakwanisa cita pirengo na dzina yanga, pa ndzidzi ubodzi-bodzi mbandilonga pontho kuipa. ");
INSERT INTO seh_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Thangwi ule anakhonda kutipokanya, onowu ngwathu. ");
INSERT INTO seh_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kumbukani kuti ule anakupasani ndiko ibodzi ya madzi na dzina yanga na thangwi ya kuti imwe ndimwe a Kirixtu, ndimo mwene ndinakupangani kuti iye nkhabe kudza kaluza m'bairo wace.” ");
INSERT INTO seh_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yezu aapanga pontho kuti: “Ule anacita kuti m'bodzi wa ana awa adanditawira apite n'kudawa, mphyadidi kum'mangira libwe nkhosi mwace mbaponyiwa m'bara. ");
INSERT INTO seh_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Mphapo ngakhala manja ako asakucitisa kuti udawe, agwande. Thangwi mphyadidi pyako upite kudzulu na manja mabodzi, kupita kukhala na manja ako mawiri, mbuponyiwa mu mbuto ya moto wa kukhonda kuthima. ");
INSERT INTO seh_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Mpfunye za mwenemo nkhabe kufa, pontho moto wace nkhabe thima. ");
INSERT INTO seh_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ngakhala ndi mwendo wako udakucitisa kuti udawe, ugwande. Thangwi mphyadidi pyako upite kudzulu mbudalamala, kupita kukhala na myendo yako miwiri, mbuponyiwa mu mbuto ya moto. ");
INSERT INTO seh_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Mpfunye za mwenemu nkhabe kufa, pontho moto wace nkhabe thima. ");
INSERT INTO seh_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ngakhala ndi diso yako inakucitisa kuti udawe, ibuluse.Thangwi mphyadidi pyako upite mu umambo wa Mulungu na diso ibodzi, kupita kukhala na maso mawiri mbuponyiwa mu mbuto ya moto. ");
INSERT INTO seh_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mpfunye za mwenemu nkhabe kufa, pontho moto wace nkhabe thima. ");
INSERT INTO seh_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Thangwi m'bodzi na m'bodzi anadza kaikhwa munyu wa moto. ");
INSERT INTO seh_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Munyu ngwadidi. Mbwenye ungakhonda lungula unadza kadzipisa tani? Khalani na munyu nkati mwanu mbamukhala na ntendere m'bodzi na m'bodzi.” ");
INSERT INTO seh_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yezu abuluka penepo mbaenda cisa ca Djudeya, ntunda unango wa nyanza ya Djorodani. Penepo mwinji wa anthu watoma pontho kudzala nkhundu mwa Yezu. Na tenepo, Yezu atoma kuapfundzisa pontho anthu ninga nsambo wace. ");
INSERT INTO seh_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Afarisi anango afendedzera Yezu toera kumulesera mbambvundzisa kuti: “kodi mwambo wathu usatawirisa kuti mamuna amwalane na nkazi wace?” ");
INSERT INTO seh_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yezu aatawira mbaabvundzisa kuti: “kodi Mozesi akupanganinji?” ");
INSERT INTO seh_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Iwo atawira mbalonga kuti: “Mozesi atawirisa kuti mamuna alembe tsamba ya kumwalana na nkazi wace, angamala mbampereka mwawo.” ");
INSERT INTO seh_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Penepo Yezu aapanga kuti: “Mozesi akutawirisani mwambo unowu na thangwi ya kuuma kwanu mitima. ");
INSERT INTO seh_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Mbwenye pa kutoma kwa pinthu pyonsene, Mulungu ‘aacita mamuna na nkazi.’ ");
INSERT INTO seh_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Na thangwi eneyo mamuna anasiya baba wace na mai wace, mbadza kaphatana na nkazi wace, ");
INSERT INTO seh_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","uwiri wawo anadza kakhala munthu m'bodzi basi’. Penepo iwo hanakhalabve anthu awiri tayu, mbwenye m'bodzi basi. ");
INSERT INTO seh_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Na tenepo, ale adaphatanizwa na Mulungu, munthu mbaleke kuamwaza.” ");
INSERT INTO seh_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pidafika iwo ku nyumba, anyakupfundza abvundzisa pontho Yezu na thangwi ibodzi ene. ");
INSERT INTO seh_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yezu aatawira tenepa: “Mamuna anamwalana na nkazi wace, mbakwatana na unango, asacita upombo mbadawisira nkazi wace. ");
INSERT INTO seh_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Sawa-sawa na nkazi angakhondana na mamuna wace, mbakwatana na mamuna unango, asacitambo upombo mbadawisira mamuna wace.” ");
INSERT INTO seh_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Buluka penepo, anthu anango akhadza na ana awo kuna Yezu toera Iye aapase nkhombo. Mbwenye anyakupfundza ace Yezu akaakhondesa. ");
INSERT INTO seh_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mphapo Yezu na kupiona asirizwa napyo mbalonga kuti: “Asiyeni ana abwere kuna ine. Lekani kuakhondesa. Thangwi Umambo wa Mulungu ngwa anthu adalandana na iwo. ");
INSERT INTO seh_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ndimo mwene, dziwani kuti ule anakhonda kutambira Umambo wa Mulungu ninga mwana ng'ono cipo nkhabe kudza kapitamo.” ");
INSERT INTO seh_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Pa kumala, Yezu aakhumbatira ana ang'ono, aapasa nkhombo mbaasandzika manja. ");
INSERT INTO seh_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Pidabuluka Yezu penepo, abwera na kuthamanga mamuna m'bodzi kuna Yezu, mban'godamira mbabvundza kuti: “Mpfundzisi wadidi, ndisafuna ndicitenji toera kukhala na upulumuki wa kukhonda kumala?” ");
INSERT INTO seh_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yezu antawira kuti: “Thangwi anji usandicemera wadidi? Wadidi ndi Mulungu ekha basi. Nkhabebve unango. ");
INSERT INTO seh_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Pontho iwe usadziwa matongero analonga tenepa: ‘Leka kupha munthu, leka kucita upombo, leka kuba, leka kukhala nyamaso wa pezi, leka kunyengeza andzako, lemedza baba wako na mai wako.’” ");
INSERT INTO seh_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Penepo mamuna antawira mbalonga tenepa: “Mpfundzisi, ine ndatomera mbandiri mwana na kuwakoya matongero enewa onsene.” ");
INSERT INTO seh_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yezu amulang'ana na kunfuna konsene, mbapanga tenepa: “Casala cinthu cibodzi kuna iwe.” Ndi ici: “Ndoko kagulise pyonsene pina iwe, kobiri yace pasa anyakucherenga, tenepa unakhala na mpfuma kudzulu. Ungamala, bwera unditowere.” ");
INSERT INTO seh_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mphapo iye na kubva mafala enewa, abuluka na kutsukwala mbaenda pyace, thangwi akhakhala na mpfuma zizinji. ");
INSERT INTO seh_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Na tenepo, Yezu alang'ana anyakupfundza ace akhali nkhundu mwace mbalonga kuti: “Pisanentsadi kakamwe kuti mpfumi apite mu Umambo wa Mulungu!” ");
INSERT INTO seh_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Anyakupfundza adzumatirwa na mafala enewa. Mbwenye Yezu athimiza basi na kulonga kuti: “Ananga, pisanentsadi kakamwe kupita mu Umambo wa Mulungu! ");
INSERT INTO seh_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kupita kwa mpfumi mu Umambo wa Mulungu, pisanentsa kakamwe kupiringana kupita kwa cinyama cinacemerwa kamero mu benga ya ntsingano.” ");
INSERT INTO seh_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Anyakupfundza na kubva mafala enewa adzumatirwa nawo pikulu kakamwe, mbakhabvundzana okha-okha kuti: “Pingakhala ndi tenepa, mbani anakwanisa kupulumuka?” ");
INSERT INTO seh_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yezu aalang'ana anyakupfundza ace mbaapanga kuti: “Ndimo mwene. Kuna anthu pisacimwanika. Mbwenye kuna Mulungu nkhabe. Thangwi kuna Mulungu pyonsene pisakwanisika.” ");
INSERT INTO seh_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Na tenepo, Pedhru alonga kuna Yezu kuti: “Lang'anani, ife tasiya pyonsene mbatikutowerani.” ");
INSERT INTO seh_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Penepo Yezu atawira mbalonga kuti: “Ande, ndimo mwene. Mbwenye nkhabe munthu anasiya nyumba yace, abale ace aamuna, abale ace aakazi, baba, mai, ana, peno minda yace, na thangwi yanga na ya Mphangwa Zadidi, ");
INSERT INTO seh_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","mbakhonda kutambira pa midzidzi ino, dzana na madzana a zinyumba, dzana na madzana a abale amuna, abale aakazi, amai, ana, dzana na madzana a minda, na kuidiwa. Pontho mbakhonda kutambira upulumuki wa kukhonda kumala pa midzidzi inafuna kudza. ");
INSERT INTO seh_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mbwenye azinji akutoma ndzidzi uno, anadza kakhala akumalisira. Na ale akumalisira ndzidzi uno, anadza kakhala akutoma.” ");
INSERT INTO seh_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yezu na anyakupfundza ace khumi na awiri, akhaenda ku Djerusalema. Iye kutsogolo, anyakupfundza ace mbakhantowera. Anyakupfundza ace akhadadzumatirwa na Iye, anangombo akhaenda na iwo akhagopa. Na tenepo, Yezu akwata pontho anyakupfundza ace mbaenda nawo pa khundu, mbatoma kuapanga pire pikhafuna kudza kacitika kuna Iye kuti: ");
INSERT INTO seh_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Lang'anani, ife tiri kwenda ku Djerusalema. Kweneko Ine Mwana wa Munthu ndinadza kaperekwa kuna akulu aanyantsembe na anyakudziwisa a mwambo. Iwo ananditongera kufa, mbandipereka m'manja mwa ale adakhonda kukhala madjuda. ");
INSERT INTO seh_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Anthu enewa anadza kandisingirira, anadza kandiphulira mata, anadza kandikwapula na kundipha. Mbwenye pa ntsiku ya citatu, Ine ndinadza kalamuka pa kufa.” ");
INSERT INTO seh_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Penepo Tiyago na Djuwau, ana a Zebhedheu, aenda kuna Yezu mbampanga kuti: “Mpfundzisi, tisaphemba kuti muticitire pinafuna kukumphembani ife.” ");
INSERT INTO seh_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yezu aatawira mbaabvundza kuti: “Musafunanji kuti ndikucitireni?” ");
INSERT INTO seh_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Iwo atawira kuti: “Tisafuna kuti mungakhala mu Umambo wanu wa mbiri mutisiye, m'bodzi akhale ku nkono wanu wa madyo unango ku nkono wa bzere.” ");
INSERT INTO seh_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Mbwenye Yezu aatawira kuti: “Imwe nkhabe kupidziwa pinaphemba imwe. Imwe munakwanisa kumwa ndiko ibodzi ene ya nyatwa inamwa Ine? Peno na kutambira batixmu ibodzi ene inatambira Ine?” ");
INSERT INTO seh_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Iwo atawira kuti: “Ande tinakwanisa.” Penepo Yezu aapanga kuti: “Ndimo mwene munadza kamwa ndiko ibodzi ene ya nyatwa inafuna kumwa Ine, na kutambira batixmu ibodzi ene. ");
INSERT INTO seh_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Mbwenye pya kukhala m'bodzi ku nkono wanga wa madyo, peno unango ku nkono wanga wa bzere, penepyo si 'pyanga tayu. Thangwi mbuto zenezi ndi za ale adasasanyirwa mbuto zenezi.” ");
INSERT INTO seh_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Anyakupfundza anango khumi, na kubva penepyo, aipirwa na Tiyago na Djuwau. ");
INSERT INTO seh_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Na tenepo, Yezu aacemera onsene mbaapanga kuti: “Ninga musadziwa, ale analongwa kuti mbatongi, asaaponderera mbumba. Pontho akulu awo ana mphambvu za kuatonga. ");
INSERT INTO seh_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mbwenye pakati panu mbapikhonde kukhala tenepa. Ule anafuna kukhala nkulu muna imwe, mbaphatire andzace basa. ");
INSERT INTO seh_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Pontho ule anafuna kukhala wakutoma pakati panu, mbapicite nyabasa wa onsene. ");
INSERT INTO seh_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Thangwi sawa-sawa na Ine Mwana wa Munthu, sidabwera kudza kaphatirwa tayu, mbwenye ndabwera kudza kaphatira anthu na kuafera toera iwo apulumuke.” ");
INSERT INTO seh_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yezu na anyakupfundza ace afika ku nzinda wa Djeriko. Pikhabuluka iye mu nzinda pabodzi na mbumba izinji na anyakupfundza ace, agumana m'mbale mwa njira, dzimola m'bodzi dzina yace ndi Bharitimeu, mwana wa Timeu, mbakhaphemba ca kudya. ");
INSERT INTO seh_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Dzimola pikhabva iye mbapilongwa kuti ndi Yezu wa ku Nazareti akhapita na njira, atoma kukhuwa mbalonga kuti: “Yezu Mwana wa Dhavidhi ndibverenimbo ntsisi!” ");
INSERT INTO seh_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Anthu azinji akham'matamisa. Mbwenye iye akhakhuwiratu kakamwe mbakhalonga kuti: “Yezu, Mwana wa Dhavidhi ndibverenimbo ntsisi!” ");
INSERT INTO seh_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Penepo Yezu alimira mbalonga kuti: “Ncemereni.” Iwo aenda kancemera mbampanga kuti: “Wangisira! Lamuka! Yezu asakucemera.” ");
INSERT INTO seh_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Na tenepo dzimola ataya cakufinika cace, alamuka na mwansanga, mbaenda kuna Yezu. ");
INSERT INTO seh_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Penepo Yezu ambvundza kuti: “Kodi usafuna ndikucitirenji?” Iye antawira kuti: “Mpfundzisi, ndisafuna ndione pontho!” ");
INSERT INTO seh_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yezu ampanga kuti: “Ndoko. Kukhulupira kwako kwakuangisa.” Pa ndzidzi ubodzi ene dzimola atoma kuona pontho, mbatowera Yezu pa ulendo wace. ");
INSERT INTO seh_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Mukhafika iwo dhuzi na Djerusalema, ku cisa ca Bhetifadji na ca Bhetanya, dhuzi na phiri ya Mulivera, Yezu atuma anyakupfundza ace awiri, ");
INSERT INTO seh_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","na mphangwa izi: “Ndokoni n'cisa ciri patsogolo panu. Pinacita imwe pite mwenemo, munagumana mwana buru wakumangirwa kuti asati pakirwa na munthu. Nsudzuleni mubwere naye kuno. ");
INSERT INTO seh_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mungabvundziwa na munthu mbalonga kuti: ‘Ndi thangwi yanji munacita penepi?’ Apangeni kuti: ‘Mbuya asanfuna angamala anakubwereserani.’” ");
INSERT INTO seh_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Iwo aenda mbagumana mwana buru ali njira, wakumangirirwa pa nsuwo ukulu wa kunja. Mukhansudzula iwo, ");
INSERT INTO seh_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","anthu anango akakhala penepo aabvundza kuti: “Ninji pinacita imwe? Musansudzuliranji mwana buru?” ");
INSERT INTO seh_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Anyakupfundza atawira ninga mukhadapangirwa iwo na Yezu.Tenepa Iwo aasiya mbaenda. ");
INSERT INTO seh_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Anyakupfundza ankwata mwana buru mbaenda naye kuna Yezu. Mbakwata nguwo zawo mbaziikha pa nsana pa mwana buru, buluka penepo Yezu mbampakira. ");
INSERT INTO seh_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Anthu azinji akhathasika pyakubvala pyawo n'njira, anango akhaikha pantsi masandzo akhagwanda iwo m'minda. ");
INSERT INTO seh_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Anthu akhaenda patsogolo, na ale akhabwera n'nduli mwa Yezu, akhakhuwa tenepa: “Hosana!” “Mbasimbwe ule anadza na dzina ya Mbuya!” ");
INSERT INTO seh_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Mbusimbwe umambo unafuna kudza wa baba wathu Dhavidhi!” “Hosana Mulungu wa kudzulu!” ");
INSERT INTO seh_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yezu afika mu Djerusalema, mbapita n'nyumba ikulu ya ntsembe. Alang'anisa pyonsene nkhundu mwace, mbabuluka kwenda ku cisa ca Bhetanya na anyakupfundza ace khumi na awiri, thangwi dzuwa ikhadoka. ");
INSERT INTO seh_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mangwana mwace, mukhabwerera iwo buluka ku Bhetanya, Yezu abva njala. ");
INSERT INTO seh_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Iye aona na kutali muti wa nsambvu mbudadzala na masamba. Aenda penepo kwenda kaona ngakhala wabala misapu. Mudafika iye dhuzi agumana masamba basi, thangwi ndzidzi wa misapu ukhadzati kwana. ");
INSERT INTO seh_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Na tenepo, Yezu alonga kuna muti kuti: “Na lini nsapo wako unadza kadyiwa pontho na munthu.” Penepo anyakupfundza ace amubva pikhalonga iye penepyo. ");
INSERT INTO seh_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yezu na anyakupfundza ace pidafika iwo ku Djerusalema, Iye apita pa thando ya Nyumba ya ntsembe, mbatoma kuthamangisa onsene ale akhagula na akhagulisa. Penepo afudza mbuto zawo zikhacinjira iwo kobiri mbabhoma mipando ya ale akhagulisa nkhangaiwa. ");
INSERT INTO seh_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Nkhabe munthu m'bodzi akhasiya iye kuti agwande na malonda ace mu Nyumba ikulu ya ntsembe. ");
INSERT INTO seh_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Buluka penepo iye atoma kupfundzisa anthu onsene kuti: “Pidalembwa tayu m'Bukhu ya Mulungu kuti: ‘nyumba yanga inadza kacemerwa nyumba ya kuphembera ya madzindza onsene?’ Mbwenye imwe musaisanduza kuti ikhale mbuto yakubisalira mambava.” ");
INSERT INTO seh_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Akulu aanyantsembe, na anyakudziwisa a mwambo mudabva iwo penepyo atoma kusaka njira ya kupha nayo Yezu. Mbwenye akhan'gopa, thangwi mbumba ikhadadzumatirwa pikulu na mapfundzisiro ace. ");
INSERT INTO seh_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Mudadoka dzuwa, Yezu na anyakupfundza ace abuluka mu nzinda. ");
INSERT INTO seh_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mangwana mwace na macibese, Yezu na anyakupfundza ace, mudapita iwo dhuzi na muti wa nsambvu, auona kuti iwo wamala kuuma na michici ene. ");
INSERT INTO seh_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Na tenepo, Pedhru akumbukira pire pikhadacitika, mbalonga tenepa kuna Yezu: “Lang'anani Mpfundzisi! Nsambvu udapikirira imwe, waumadi!” ");
INSERT INTO seh_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Penepo Yezu aapanga kuti: “Khulupirirani Mulungu! ");
INSERT INTO seh_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Thangwi mungapanga phiri iyi kuti: ‘Buluka penepo, uende kagwe m'bara’, mbamuleka kupenula m'mitima mwanu, mbwenye mbamunyindira kuti pinacitika pinalonga imwe, ipyo pinacitikadi. ");
INSERT INTO seh_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Thangwi ya ipyo ine ndinakupangani kuti: Pyonsene pinaphemba imwe na maphembero, nyindirani kuti mwamala kupitambira. Na mwenemo, pyonsene pinacitika. ");
INSERT INTO seh_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Na tenepo mungakhala muli kuphembera, lekererani ale adakudawisirani, toera Baba wanu wa kudzulu akulekererenimbo kudawa kwanu. ");
INSERT INTO seh_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Mbwenye mungakhonda kulekerera andzanu, Baba wanu wa kudzulu nkhabe kudza kakulekereranimbo kudawa kwanu.” ");
INSERT INTO seh_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Pa kumala, Yezu na anyakupfundza ace abwerera pontho ku Djerusalema. Pikhafamba Yezu mu Nyumba ya ntsembe, afendedzerwa dhuzi na akulu aanyantsembe na anyakudziwisa a mwambo na atsogoleri aanyakuphembera. ");
INSERT INTO seh_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Penepo iwo ambvundza kuti: “Imwe musacita penepyo na mphambvu za utongi wa ani? Mbani akupasani mphambvu toera kucita pinthu penepyo?” ");
INSERT INTO seh_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yezu aatawira tenepa: “Ine ndisafuna ndikubvundzenimbo cinthu cibodzi. Mungakwanisa kunditawira, ndinakupangani mbani adandipasa mphambvu toera kucita pinthu penepyo. ");
INSERT INTO seh_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ndipangeni! Batixmu ya Djuwau ikhali ya kudzulu peno ya anthu?” ");
INSERT INTO seh_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Penepo iwo atoma kuketesana okha-okha mbalonga tenepa: “Tingalonga kuti nja kudzulu, iye anatibvundza kuti thangwi yanji mphapo mwakhonda kuntawira Djuwau? ");
INSERT INTO seh_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Apo tilonge kuti ndi ya anthu...” Penepo iwo akhagopa mbumba thangwi onsene akhandziwadi kuti Djuwau akhali mporofeta. ");
INSERT INTO seh_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Na thangwi eneyo iwo antawira tenepa: “Ife nkhabe kupidziwa.” Na tenepo Yezu alonga kuti: “Ine nkhabe kukupanganimbo mbani adandipasa mphambvu toera kucita pinthu penepyo.” ");
INSERT INTO seh_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Buluka penepo Yezu atoma kulonga na misanje kuti: “Mamuna m'bodzi acheka miti yace ya mauva mbaicitira mpanda. Mbacita mbuto ibodzi yakukamuliramo mauva, toera kucita vinyu, pontho na kumanga cirindo cakuonerera pyonsene. Pa kumala penepo, akwata munda mbaurikisa na anthu anango anyakulima. Pidamala iye mbaenda ulendo wace. ");
INSERT INTO seh_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Pidakwana iwo ndzidzi wa mauva, mwanacinthu munda atuma nyabasa wace m'bodzi kuna anyakulima, toera iye aende katambire phindi yace ya mauva. ");
INSERT INTO seh_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mbwenye iwo anyakulima amphata nyabasa unowu mbam'menya, mbam'bweza cimanja-manja. ");
INSERT INTO seh_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Na tenepo, mwanacinthu munda atuma pontho nyabasa unango m'bodzi. Mbwenye anyakulima amphata nyabasa unowu, mbam'menya munsolo mbantikana. ");
INSERT INTO seh_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Penepo, mwanacinthu munda atuma pontho unango, mbwenye iwo amupha. Na tenepo, azinji adatumwa pa nsoka wawo, anango aphekeswa, anango aphiwa. ");
INSERT INTO seh_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Mwanacinthu munda akhadasala na mwana wace m'bodzi ekha basi wa kufunika, toera kuntuma. Pakumalisa, iye antuma mwana wace mbalonga ekha ene kuti: ‘Mwananga uyu anati amulemedze.’ ");
INSERT INTO seh_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Mbwenye anyakulima na kumuona mwana, atoma kulonga okha ene m'bodzi na m'bodzi kuti: ‘Uyu ndiye mwanacinthu unthaka. Tendeni timuphe, unthaka ukhale wathu.’ ");
INSERT INTO seh_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Na tenepo, iwo amphata mwana, mbamupha, mbantaya kunja kwa munda wa mauva. ");
INSERT INTO seh_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Penepo, Yezu abvundza kuti: Ndi ninji pinafuna kucita mwana cinthu munda? Iye anabwera mbaapha amuna ale, mbakwata munda mbaupasa anyakulima anango. ");
INSERT INTO seh_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Imwe mudapiona tayu pidalembwa m'Bukhu ya Mulungu pinalonga kuti: Mwala udakhondwa na anyakumanga nyumba, wadza kakhala mwala wakufunika kakamwe? ");
INSERT INTO seh_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Penepyo pyabuluka kuna Mbuya. Ndi pinthu pinatidzumisa.” ");
INSERT INTO seh_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Akulu a madjuda akhapidziwa kuti nsanje uyu ukhalongera iwo. Na tenepo, akhafuna kum'manga Yezu mbwenye akhagopa mbumba. Na thangwi eneyo ansiya, iwo mbaenda pyawo. ");
INSERT INTO seh_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pa kumala, madjuda atuma afarisi anango na anthu a pa nsoka wa Herodhi, toera kwenda kasaka thangwi kuna Yezu ya kumpambazira nayo. ");
INSERT INTO seh_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Pidafika iwo pana Yezu ampanga tenepa: “Mpfundzisi, ife tisadziwa kuti imwe ndimwe munthu wa kulungama na wa kukhonda kubva manyengerero a anthu anango, pontho imwe nkhabe kutonga mbamulang'ana makhaliro a munthu. Mbwenye musapfundzisa pya maso pinafuna Mulungu. Mphapo tipangeni, pisatongwa kuti ife tipereke nsonkho kuna mambo wa ku Roma? ");
INSERT INTO seh_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pisatongwa peno nkhabe?” Mbwenye Yezu aadzindikira uthambi wawo, mbaatawira tenepa: “Thangwi yanji musafuna kundilesera? Bweresani kobiri ibodzi ya ndzaya ndiione.” ");
INSERT INTO seh_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Iwo am'bweresera kobiri. Penepo Yezu aabvundza kuti: “Kodi dzina na nkhope iyi iri pa kobiri ndja ani?” Iwo antawira kuti: “Ndja mambo wa ku Roma.” ");
INSERT INTO seh_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Na tenepo, Yezu aapanga kuti: “Pya mambo pasani mambo, pya Mulungu pasanimbo Mulungu.” Penepo iwo adzumatirwa na kutawira kudacita Yezu. ");
INSERT INTO seh_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nsoka unango wa madjuda unacemerwa Asadhusi, ale anakhonda kuti munthu nkhabe lamuka pa kufa, abwera kuna Yezu mbampanga kuti: ");
INSERT INTO seh_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mpfundzisi, Mozesi, atisiyira mwambo wa kuti: Pa banja angatoma kufa mamuna mbasiya nkazi mbadzati bala naye, m'bale wa mamuna asatongwa kuti acite banja na manferwa wa nkazi, toera abale naye, ansiyire dzindza. ");
INSERT INTO seh_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mphapo ninji pidacitika? Akhalipo amuna anomwe muubale mwawo. Wa nkulo afa mbasiya nkazi wace mbadzati kubala naye. ");
INSERT INTO seh_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Penepo m'bale wace waciwiri akwata manferwa mbampitisa n'nyumba. Mbwenye iye afambo, mbadzati kubala naye mwana. Penepyo pyacitikambo sawa-sawa na m'bale wace wa citatu. ");
INSERT INTO seh_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mphapo pa onsene anomwe mu ubale mwawo acita banja na nkazi m'bodzi ene, mbafa onsene mbakhonda kubala naye mwana. Pa kumalisira nkazi afambo. ");
INSERT INTO seh_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Mphapo, pa ntsiku ya kulamuka kwa anthu onsene pa kufa, nkazi onowu anakhala wa ani pa abale anomwe? Thangwi onsene, acita banja na nkazi m'bodzi ene?” ");
INSERT INTO seh_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yezu atawira kuti: “Imwe mwadodomeka, thangwi ya kukhonda kudziwa kwanu mafala a Mulungu, na mphambvu zace! ");
INSERT INTO seh_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Thangwi anyakufa angalamuka pa kufa, nkhabe kudza kacitabve banja. Mbwenye anakhala ninga anju za kudzulu. ");
INSERT INTO seh_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na thangwi ya kulamuka kwa anthu pa kufa, imwe mudzati kupiona pidalembwa m'bukhu ya Mozesi, pidalonga Mulungu pa thundudzi ya kugaka mbampanga kuti: ‘Ine ndine Mulungu wa Abharaamu, ndine Mulungu wa Izaki, ndine Mulungu wa Djakobu?’ ");
INSERT INTO seh_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Mphapo iye si Mulungu wa anthu a kufa tayu. Mbwenye ndi Mulungu wa a m'maso. Imwe mwadodomeka pikulu kakamwe!” ");
INSERT INTO seh_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","M'bodzi wa anyakudziwisa a mwambo afendedzera dhuzi mbabva pikhaketesana iwo. Penepo, na kubva kuti Yezu akhatawira mwadidi, ambvundza kuti: “Kodi mbapi matongero makulu kakamwe kupita onsene?” ");
INSERT INTO seh_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yezu antawira kuti: “Matongero makulu kakamwe kupita onsene mbawa: ‘Bveserani imwe mbumba ya Izirayeli! Mbuya Mulungu wathu, ndiye basi Mbuya wathu. ");
INSERT INTO seh_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Funa Mbuya Mulungu wako na ntima wako onsene, na upulumuki wako onsene, na ndzeru zako zonsene, na mphambvu zako zonsene.’ ");
INSERT INTO seh_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Matongero aciwiri makulu kakamwe mbawa: ‘Funa ndzako ninga iwe ene.’ Nkhabebve matongero anango makulu anapita awa matongero mawiri.” ");
INSERT INTO seh_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Penepo, nyakudziwisa wa mwambo alonga kuna Yezu kuti: “Ande, Mpfundzisi! Pinalonga imwe kuti Mulungu ndi m'bodzi basi ekha, nkhabebve unango kunja kwace, ndimo mwenedi. ");
INSERT INTO seh_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Pontho kufuna Mulungu na ntima wathu onsene, na ndzeru zathu zonsene, na mphambvu zathu zonsene, pontho na kufuna ndzako ninga iwe ene, mphyadidi kakamwe kupiringana kupisa ntsembe za pinyama na kucita ntsembe zinango.” ");
INSERT INTO seh_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yezu na kuona kuti nyakudziwisa wa mwambo atawira mwa ndzeru, ampanga kuti: “Iwe uli dhuzi na Umambo wa Mulungu.” Bulukira penepo nkhabebve munthu akhakhala na cipapo ca kumbvundza. ");
INSERT INTO seh_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Mukhapfundzisa Yezu mu Nyumba ya Ntsembe, abvundzisa tenepa: “Kodi ndi thangwi yanji anyakudziwisa a mwambo asalonga kuti, Kirixtu ndi mwana wa Dhavidhi? ");
INSERT INTO seh_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Thangwi iye ene Dhavidhi, alonga na mphambvu za Nzimu wa Mulungu kuti: ‘Mbuya alonga kuna Mbuya wanga kuti: Khalani ku nkono wanga wa madyo, mpaka ntsiku inaikha ine anyamalwa anu pantsi pa manyalo anu.’ ");
INSERT INTO seh_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Lang'anani, iye ene Dhavidhi asancemera ‘Mbuya’. Apo pinacitika tani penepi kuti Kirixtu akhale mwana wace?” Penepo mbumba ikhambvesera na kukomerwa. ");
INSERT INTO seh_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yezu akhapanga mbumba kuti: “Citani mphole na anyakudziwisa a mwambo. Thangwi iwo asafuna pikulu kakamwe kufamba na nguwo zakulapha m'manungo, na kumwanyikwa na anthu m'mphambano. ");
INSERT INTO seh_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Pontho iwo asafuna kusankhula mipando ya kutoma angapita m'manyumba a kuphembera na m'mbuto za phwandu. ");
INSERT INTO seh_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Pontho ndi anthu ana nsambo wa kukwata ndzidzi ukulu na kuphembera m'manyumba mwa akazi adaferwa na amuna awo, toera kuatapata na kwabera pinthu pyawo. Enewa anadza kaoneswa nyatwa zikulu.” ");
INSERT INTO seh_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ntsiku inango Yezu akakhala mu Nyumba ya Ntsembe. Iye akakhala pantsi dhuzi na mbuto ikaikhira anthu miyoni yawo mbakhalang'ana maikhiro akhacita mbumba kobiri zawo. Penepo anthu azinji akupfuma akaikhambo kobiri zawo zizinji. ");
INSERT INTO seh_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Penepo afikambo nkazi m'bodzi wakucherenga adaferwa na mamuna wace, mbaikhambo kobiri zace ziwiri za ntengo ung'ono. ");
INSERT INTO seh_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Na tenepo, Yezu acemera anyakupfundza ace mbaapanga tenepa: “Ine ndisakupangani kuti pa anthu onsene adapereka miyoni yawo, adapereka pikulu kupita onsene, ndi nkazi uyu wa manferwa. ");
INSERT INTO seh_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Thangwi onsene abulusa pinthu pyawo mbapisala pinango. Mbwenye nkazi uyu na ucherengi wace, abulusa pyonsene pikhakhala na iye.”");
INSERT INTO seh_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Mukhabuluka Yezu pa thando ya Nyumba ya Ntsembe, m'bodzi wa anyakupfundza ace ampanga tenepa: “Mpfundzisi, lang'anani kubalika kwa nyumba izi na myala zidamangwa na izo!” ");
INSERT INTO seh_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Mbwenye Yezu atawira tenepa: “Iwe usaziona, nyumba zikulu izi? Pano nkhabe mwala ubodzi unafuna sala padzulu pa mwala unango. Pyonsene ipi pinamala kugomolwa.” ");
INSERT INTO seh_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yezu akakhala nawa pa phiri ya Mulivera, mbakhalang'ana ku Nyumba ya Ntsembe, pa ndzidzi ukhabvundziwa iye pa khundu na Pedhru, na Tiyago, na Djuwau, na Andereya, kuti: ");
INSERT INTO seh_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Pinacitika lini penepi? Ndi cidzindikiro canji cinadza kafuna kuoneka toera kupangiza kutoma kwa pinthu penepyo pyonsene?” ");
INSERT INTO seh_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yezu atoma kuapfundzisa mbalonga tenepa: “Cenjerani toera mukhonde nyengezwa na anthu. ");
INSERT INTO seh_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Thangwi azinji anadza kabwera na dzina Yanga mbalonga kuti: ‘Ine ndine Misiya!’ Tenepa iwo anati anyengeze anthu azinji. ");
INSERT INTO seh_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mphapo lekani kugopa mungabva pya nkhondo peno mabvabva a nkhondo. Thangwi pyonsene ipi pinacitika, mbwenye si kumala kwa pinthu tayu. ");
INSERT INTO seh_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Dziko na dziko inadza kamenyana, pontho umambo na umambo unadza kamenyana. Mbuto zizinji zinadza kaoneka citeketeke na njala. Apo pinthu penepyo ndi kutoma kwa nyatwa. ");
INSERT INTO seh_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Imwe musafuna mucenjere, thangwi munadza kaperekwa m'mbuto za kutongera miseru, mbamukwapulwa na michamu mu nyumba zawo za kuphembera. Na thangwi yanga, munati muendeswe pa maso pa utongi na pa amambo, toera mukhale amboni anga. ");
INSERT INTO seh_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Thangwi pyonsene ipi mbipidzati kucitika, pa kutoma pisafunika kuti Mphangwa Zadidi zimwazwe madziko onsene a pantsi pano. ");
INSERT INTO seh_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mungadza kamangwa mbamuperekwa m'manja mwa anyakutonga, lekani kugopa kuti munadza kalonganji kweneko. Ndzidzi ungafika longani pire basi pinadza kakupangani Mulungu ndzidzi onowu.Thangwi simwe tayu anadza kafuna kulonga, mbwenye ndi Nzimu wa Mulungu. ");
INSERT INTO seh_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Anthu azinji anadza kapereka abale awo ene toera aphiwe, pontho a baba na a mai anadza kacitambo pibodzi-bodzi kuna anawo. Ana anadza kaidambo a baba awo na a mai awo, mbaapha. ");
INSERT INTO seh_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Anthu onsene anakuidani na thangwi yanga. Mbwenye ule anapirira mpaka pakumalisa, anapulumuswa. ");
INSERT INTO seh_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yezu athimiza pontho na kulonga kuti: ‘Imwe mungadza kaona cinthu ca kuipa cinafudza pya Mulungu’ mbacikhala pa mbuto ya kukhondeswa - anaona mafala awa, mbaabvesese pinalongera iwo - na tenepo anagumanika mu Djudeya mbathawire m'mapiri. ");
INSERT INTO seh_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ule anagumanika pa ntsoyi ya nyumba yace, mbaleke kuchita toera kubulusa pinthu n'nyumba mwace. ");
INSERT INTO seh_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ule anagumanika ku munda, mbaleke bwerera ku nyumba kudza kakwata nguwo zace. ");
INSERT INTO seh_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ana nyatwa ikulu kakamwe ale akazi anagumanika na pa thupi, na ale amai anayamwisa pa ntsiku zenezo! ");
INSERT INTO seh_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Phemberani kuna Mulungu, kuti nyatwa zenezo zileke kucitika pa ndzidzi wa khoni. ");
INSERT INTO seh_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Thangwi pa ntsiku zenezo nyatwa zinadza kakhala zikulu, kuti cipo zidzati kuoneka, kutomera padacita Mulungu dziko mpaka lero. Pontho cipo nkhabe kudza kaonekabve. ");
INSERT INTO seh_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Pontho Mbuya mbadakhonda kuzigwandira ntsiku zenezi, nkhabe m'bodzi akhafuna kupulumuswa! Mbwenye na thangwi ya ale adasankhula Iye, azigwandira ntsiku zenezi. ");
INSERT INTO seh_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Mphapo mungabva munthu mbakupangani kuti: ‘lang'anani Misiya ali pano!’ peno ‘Misiya ali kule!’ lekani kumbvera. ");
INSERT INTO seh_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Thangwi anadza kabulukira a misiya a uthambi na maporofeta a uthambi. Iwo anadza kakwanisa kucita pirengo na pinango pinthu pyakudzumisa, toera pingakwanisika, ananyengere na anyakusankhulwa ene a Mulungu. ");
INSERT INTO seh_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Na thangwi eneyo, cenjerani. Ndisakucencezani pyonsene ipi mbipidzati kucitika. ");
INSERT INTO seh_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Mbwenye ntsiku zenezo za nyatwa ‘dzuwa inaswipa, mwezi nkhabe kudza kagakabve. ");
INSERT INTO seh_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Nyenyezi za kudzulu zinagwa pantsi, pontho pinthu pyonsene pya mphambvu za kudzulu pinatekenyeka.’ ");
INSERT INTO seh_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Na tenepo, Ine Mwana wa Munthu, ndinadza kaonekera mbandichita m'makole na mphambvu zikulu za kutonga, na mbiri. ");
INSERT INTO seh_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Penepo, Ine Mwana wa Munthu ndinadza katuma anju zanga, mbandigumanya anyakusankhulwa anga a makhundu manai a dziko, mpaka kudadhroma mataka na thambo. ");
INSERT INTO seh_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Kwatirani luso na pinakupfundzisani muti wa nsambvu. Mungaona nthawi zace mbaziphwikira, imwe musadziwa kuti malimwe ali dhuzi. ");
INSERT INTO seh_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Na tenepo, sawa-sawambo mungaona pinthu penepyo mbipicitika, dziwani kuti Iye ali dhuzi pontho ali pa nsuwo. ");
INSERT INTO seh_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ndinakupangani kuti pinthu pyonsene ipi pinati picitike, anthu a midzidzi ino mbadzati kumala. ");
INSERT INTO seh_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Thambo na mataka pinadza kamala. Mbwenye mafala anga nkhabe kudza kamala. ");
INSERT INTO seh_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Na thangwi ya ntsiku na ndzidzi unafuna kucitika pinthu penepi, nkhabe munthu anapidziwa. Kutomera kuna anju za kudzulu mpaka kuna Mwana, nkhabe m'bodzi anapidziwambo, mbwenye ndiye basi Baba anapidziwa. ");
INSERT INTO seh_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Lang'anirani! Khalani mbamudacenjera! Thangwi imwe nkhabe kupidziwa unafika lini ndzidzi onowu. ");
INSERT INTO seh_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Pinakhala ninga mamuna m'bodzi adabuluka pa nyumba mbacita ulendo wa kutali. Mbwenye mbadzati kwenda, abulusa ntemo wace, mbagawiza mabasa anyabasa ace, mbapanga nyakuonera pa nsuwo kuti aonere. ");
INSERT INTO seh_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Na tenepo lang'anirani, thangwi nkhabe kupidziwa kuti anabwera lini mwana cinthu nyumba. Peno na maulo, peno chitichiti, peno m'bambakuca, peno na macibese. ");
INSERT INTO seh_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kuti iye angabwera na mwansanga, akhonde kukugumanani mbamugona. ");
INSERT INTO seh_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Penepi pinakupangani ine, ndisapanga anthu onsene kuti: Lang'anirani!” ");
INSERT INTO seh_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Zikhadasala ntsiku ziwiri basi kuti ifike ntsiku ya phwandu ya Paxkwa na ntsiku inango ikhadya iwo mikate yakusowa cimera. Akulu aanyantsembe na anyakudziwisa a mwambo akhasaka njira ya kumanga nayo Yezu n'cibiso-biso na kumupha. ");
INSERT INTO seh_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Mbwenye iwo akhalonga kuti: “Penepyo mbitilekeni kupicita pa ndzidzi wa phwandu, gopa mbumba inatizungunukira.” ");
INSERT INTO seh_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yezu akhakhala ku cisa ca Bhetanya, ku nyumba ya Simau, akhacemerwa nyamatanya. Na tenepo, pa ndzidzi ukhadya Yezu, afika nkazi m'bodzi na ntete wace wakucitwa na alabhaxtu, wakudzala na mafuta akununkhira, akucitwa na nardu wadidi a ntengo ukulu. Nkazi auswa ntete mbaaikha mafuta munsolo mwa Yezu. ");
INSERT INTO seh_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Anthu anango akhali penepo, atoma kuipirwa napyo mbakhalonga okha-okha kuti: “Thangwi yanji asabvunga mafuta onsene awa?” ");
INSERT INTO seh_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Iwo atoma kunsandika nkazi mbamulongera kuti: “Mafuta awa akhakwanira guliswa na ntengo wa kupiringana madzana matatu a kobiri, kobiri eneyo mbipaswa anyakucherenga.” ");
INSERT INTO seh_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mbwenye Yezu aapanga kuti: “Nsiyene nkazi acite pinafuna iye! Munansanyeranji? Iye andicitira cinthu cadidi kakamwe. ");
INSERT INTO seh_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Anyakucherenga munakhala nawo midzidzi yonsene, pontho munakwanisa kuaphedza ntsiku zonsene zinafuna imwe. Mbwenye ine nkhabebve kudza kakhala na imwe midzidzi yonsene tayu. ");
INSERT INTO seh_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nkazi uyu acita pidakwanisa iye kucita. Adzodza nyapantsi manungo anga na mafuta akununkhira, mbindidzati kufa, kuasasanyira kuti aikhwe n'nthumbi. ");
INSERT INTO seh_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ndimo mwene ndinakupangani kuti mbuto zonsene za pantsi zinafuna kulongwa Mphangwa izi Zadidi, pinati pilongwembo pyonsene pidacita nkazi uyu, pontho anthu anati ankumbuke.” ");
INSERT INTO seh_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Penepo, m'bodzi wa anyakupfundza khumi na awiri, anacemerwa Djuda Xikariyoti, aenda kalonga na akulu anyantsembe, toera kumpereka Yezu m'manja mwawo. ");
INSERT INTO seh_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Na thangwi eneyo, iwo akomerwa napyo pikulu mbampikirira kumpasa kobiri. Kubulukira penepo, Djuda atoma kusaka njira ya kupereka nayo Yezu. ");
INSERT INTO seh_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ntsiku ya kutoma ya phwandu ikhadya iwo mikate ya kusoweka cimera, ndiyo ntsiku ikhapha iwo ana mabira, toera kukumbuka phwandu yawo ya Paxkwa. Penepo, anyakupfundza a Yezu ambvundzisa kuti: “Musafuna tikusasanyireni kupi phwandu ya Paxkwa?” ");
INSERT INTO seh_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Na tenepo, Yezu atuma anyakupfundza ace awiri, mbaapanga kuti: “Ndokoni mu nzinda. Mwenemu anadza kuna imwe mamuna m'bodzi na nkhali ya madzi. Ntowereni. ");
INSERT INTO seh_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Mungafika longani na momba nyumba inafuna iye pita kuti: Mpfundzisi ali kubvundza kuti: Ndi ipi mbuto inafuna ine kudyera phwandu ya Paxkwa na anyakupfundza anga? ");
INSERT INTO seh_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Penepo iye anakupangizani mbuto ikulu ya ndzulu. Mwenemu munagumana pyonsene pinafunika. Sasanyirani mwenemu phwandu yathu ya Paxkwa.” ");
INSERT INTO seh_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Na tenepo, anyakupfundza ace abulukadi mbapita mu nzinda, mbagumanadi pyonsene ninga mudalongera Yezu. Mwenemu iwo atoma kusasanyira phwandu yawo ya Paxkwa. ");
INSERT INTO seh_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mukhadoka dzuwa Iye abwera na anyakupfundza ace khumi na awiri. ");
INSERT INTO seh_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Pikhadya iwo, Iye alonga kuti: “Ndimo mwene ndisakupangani kuti m'bodzi wanu, anadya na ine pano anati andisandukire.” ");
INSERT INTO seh_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Mphapo iwo akhala mbadatsukwala pikulu, mbatoma m'bodzi na m'bodzi kubvundzisa Yezu kuti: “kodi ndine, Mbuya?” ");
INSERT INTO seh_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Penepo Yezu atawira kuti: “Ndi m'bodzi wanu, ule anadya na ine mu mbale ibodzi ene. ");
INSERT INTO seh_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ndimo mwene. Ine Mwana wa Munthu ndinati ndife, ninga mudalemberwa ipyo m'Bukhu ya Mulungu na thangwi yanga. Mbwenye nyatwa ndi yace ule adandisandukira Ine Mwana wa Munthu! Pikhali pyadidi mbadakhonda kubaliwa pyace.” ");
INSERT INTO seh_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Pikhadya iwo, Yezu akwata nkate mbapereka takhuta, aumenya, mbaugawiza anyakupfundza ace, mbalonga kuti: “Kwatani, awa ndi manungo anga.” ");
INSERT INTO seh_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pa kumala akwata ndiko, mbapereka takhuta, mbaipasa anyakupfundza ace, onsene mbamwa. ");
INSERT INTO seh_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Penepo Yezu aapanga kuti: “Ici ndi ciropa canga ca cipangano cipsa, cinacololekera anthu azinji. ");
INSERT INTO seh_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Dziwani kuti ine sinadza kamwabve vinyu iyi tayu, mpaka ntsiku inadza kamwa ine vinyu ipsa mu Umambo wa Mulungu.” ");
INSERT INTO seh_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pa kumala kuimba nyimbo, aenda ku phiri ya Mulivera. ");
INSERT INTO seh_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Penepo Yezu apanga anyakupfundza ace kuti: “Imwe mwonsene munati mundithawe. Thangwi pyalembwa m'Bukhu ya Mulungu, kuti: ‘Ndinapha nkumbidzi, mabira mbamala kubalalika.’ ");
INSERT INTO seh_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Mbwenye pa kumala kulamuka kwanga pa kufa ndinatsogola kwenda ku Galileya.” ");
INSERT INTO seh_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Penepo Pedhru atawira mbalonga kuti: “Peno andzanga anakuthawani. Mbwenye ine cipo ndinakuthawani.” ");
INSERT INTO seh_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Mbwenye Yezu antawira tenepa: “Dziwa kuti lero ene, masiku ano, dzongwe mbidzati kulira kawiri, iwe unati undikhonde katatu.” ");
INSERT INTO seh_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Mbwenye Pedhru athimiza pontho na kulonga na mphambvu kuti: “Pingafunika kuti ine ndife pabodzi na imwe, ndinafa. Mbwenye nkhabe kudza kakukhondani.” Penepo andzace onsene atawirambo sawa-sawa. ");
INSERT INTO seh_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Pakubuluka penepo, Yezu na anyakupfundza ace aenda ku mbuto ibodzi inacemerwa Djesimani. Kweneko Yezu aapanga anyakupfundza ace kuti: “Ine ndiri kwenda kaphembera, imwe bangani mbamukhala pano.” ");
INSERT INTO seh_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Penepo Yezu akwatana na Pedhru, na Tiyago, na Djuwau. Na tenepo, Yezu atoma kubva kunentseka na kutsukwala mu ntima. ");
INSERT INTO seh_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Penepo iye alonga tenepa: “Ntima wanga usabva kutsukwala kwa kufa. Khalani pano mbamulang'anira.” ");
INSERT INTO seh_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Penepo Yezu aenda patsogolo pang'ono, agwa pantsi mbaphembera kuna Mulungu tenepa: Mbuya, pingakwanisika ndisaphemba kuti mundithawisire ndzidzi uno wa nyatwa. ");
INSERT INTO seh_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Pontho akhaphembera tenepa: “Imwe Baba, nkhabe cinthu cinacimwanika kuna imwe. Ndithawisireni ndiko iyi ya nyatwa kuna ine, apo lekani kucita kufuna kwanga, mbwenye ninga munafunira imwe.” ");
INSERT INTO seh_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Buluka penepo, Yezu abwerera mbagumana anyakupfundza ace atatu mbakhagona. Penepo Yezu alonga kuna Pedhru kuti: “Simau, uli kugona? Nkhabe kwanisa kulang'anira pa ndzidzi ubodzi basi? ");
INSERT INTO seh_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Lang'anirani mbamuphembera, toera mukhonde kukundwa na manyengerero. Thangwi nzimu una mphambvu za kupirira, mbwenye manungo nkhabe.” ");
INSERT INTO seh_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Penepo Yezu abwerera pontho, mbaphembera, mbakhalonga mafala mabodzi ene. ");
INSERT INTO seh_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pa kumala, abwera kuna anyakupfundza ace, aagumana pontho mbakhagona, thangwi maso awo akhadadzala na citulo. Na tenepo, iwo akhasowa cakulonga kuna Yezu. ");
INSERT INTO seh_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yezu pidabwerera iye pontho kacitatu kuna anyakupfundza ace, aapanga tenepa: “Kodi imwe muli kupuma mbamugona pyanu basi? Pyakwana! Wafika ndzidzi wa kuperekwa kwa Ine Mwana wa Munthu m'manja mwa anyakudawa. ");
INSERT INTO seh_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Lamukani, tendeni! Thangwi ali kufika ule adandisandukira!” ");
INSERT INTO seh_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yezu mbadzati kumala kulonga afika Djuda, m'bodzi wa anyakupfundza khumi na awiri a Yezu. Iye afika pabodzi na mwinji wa anthu ukhali na masupada na miti. Iwo akhadatumwa na akulu aanyantsembe, na anyakudziwisa a mwambo na mathubu. ");
INSERT INTO seh_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Djuda, nyakusandukira Yezu, akhadabverana na amuna cidzindikiro ca kuti: “Ule ana mpsompsona ine ndiye ene. M'mangeni mumphatisise muende naye.” ");
INSERT INTO seh_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Pidafika iye Djuda dhuzi na Yezu alonga kuti: “Mpfundzisi!” Mbampsompsona. ");
INSERT INTO seh_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Na tenepo, amuna amphata Yezu mbam'manga. ");
INSERT INTO seh_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mbwenye m'bodzi wa ale akhali na Yezu abulusa supada mbagwanda nayo khutu ya nyabasa m'bodzi wa nyantsembe wa nkulu. ");
INSERT INTO seh_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Penepo Yezu aabvundza anthu kuti: “Mwatani munandidzera na masupada, na miti, kudza kandimanga ninga ine ndine mbava? ");
INSERT INTO seh_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ine ndikhali na imwe ntsiku zonsene mbandipfundzisa mu nyumba ya ntsembe, imwe mudandimanga tayu! Mbwenye pisafunika kuti Bukhu ya Mulungu isimbisiswe.” ");
INSERT INTO seh_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Na tenepo anyakupfundza ace onsene ansiya, iwo mbathawa. ");
INSERT INTO seh_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mphale m'bodzi akhadabvala n'kumi basi m'manungo mwace, akhatowera Yezu. Penepo anango akhafuna kum'manga. ");
INSERT INTO seh_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Mbwenye mphale adula n'kumi wace mbathawa cipezi-pezi. ");
INSERT INTO seh_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Buluka penepo iwo ankwata Yezu mpaka ku nyumba kwa nkulu wa anyantsembe. Na tenepo, agumanyikana akulu onsene aanyantsembe, na mathubu, na anyakudziwisa a mwambo. ");
INSERT INTO seh_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedhru akhaenda mbatowera Yezu na kutali, mpaka kupita mu mpanda wa nyumba ya nkulu wa anyantsembe. Mwenemo iye akhala pantsi mbakhaotha moto pabodzi na anyabasa. ");
INSERT INTO seh_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Na tenepo, akulu aanyantsembe na akulu anango onsene anyakutonga miseru, akhasaka mathangwi akuphesa nawo Yezu, mbwenye akhaasowa. ");
INSERT INTO seh_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Anthu azinji akhamulongera pya uthambi. Mbwenye pyonsene pikhalonga m'bodzi na m'bodzi wawo, pikhasyana. ");
INSERT INTO seh_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Penepo anango akhalamuka mbakhalonga uthambi wawo tenepa: ");
INSERT INTO seh_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ife tamubva mbakhalonga kuti: ‘Ine ndinati ndifudze nyumba iyi ya ntsembe ya kucitwa na anthu. Mbwenye pa ntsiku zitatu ndinamanga pontho inango ya kukhonda kucitwa na anthu.’” ");
INSERT INTO seh_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mbwenye pa pyonsene ipi, uthambi wawo ukhasiyana basi. ");
INSERT INTO seh_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Penepo, nyantsembe wa nkulu kakamwe, alamuka pakati pa onsene, mbambvundzisa Yezu kuti: “Kodi iwe khabe kutawira pinthu pinakulongera iwo?” ");
INSERT INTO seh_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mbwenye Yezu athimiza basi na kumatama, mbakhonda kutawira cinthu. Na tenepo, nyantsembe wa nkulu ambvundzisa pontho Yezu kuti: “Iwe ndiwedi Misiya, Mwana wa Mulungu wa kusimbwa?” ");
INSERT INTO seh_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Apo Yezu antawira kuti: “NDINE. Munati mundione Ine Mwana wa Munthu, mbandikhala pa nkono wa madyo wa Mulungu wa mphambvu zonsene, mbandibwera padzulu pa makole.” ");
INSERT INTO seh_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Penepo nkulu wa anyantsembe apandula ekha ene nguwo zace na kuipirwa, mbalonga kuti: “Thangwi anji tinafuna pontho nyamaso? ");
INSERT INTO seh_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mwabva mwekha kuxola kudacita iye Mulungu! Muli kuona tani?” Iwo onsene, atawirira kuti Yezu aphiwe. ");
INSERT INTO seh_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Na tenepo, anango atoma kumphulira mata Yezu, amphopa maso ace, mbakham'menya na maxoko, mbakhalonga kuti: “Lotera!” Mbani akumenya? Penepo anyabasa amphata mbam'menya kunkhope na manja. ");
INSERT INTO seh_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedhru mbali pantsi, mu mpanda, abulukira mwenemo nyabasa m'bodzi wa nkazi, wa nkulu wa anyantsembe. ");
INSERT INTO seh_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Iye nyabasa wa nkazi pidaona iye Pedhru mbakhaotha moto amulang'anisa mbampanga kuti: “Iwe ukhali pabodzi na Yezu wa ku Nazareti.” ");
INSERT INTO seh_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Mbwenye Pedhru akhonda mbalonga kuti: “Sinandziwa unowu tayu. Pontho ine nkhabe kupidziwa pinalonga iwe.” Na tenepo, Pedhru abuluka mbaenda m'berere. Pa ndzidzi onowu dzongwe yatoma kulira. ");
INSERT INTO seh_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nkazi unowu pidaona iye Pedhru mwenemu atoma pontho kumulongera kuli anthu akhali penepo kuti: “Mamuna uyu ndi m'bodzi wawo.” ");
INSERT INTO seh_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mbwenye Pedhru akhonda pontho. Pa kupita ndzidzi pang'ono anthu akhali penepo atoma kunthonya mbapanga pontho kuti: “Ndimo mwene iwe ndiwedi m'bodzi wawo, thangwi ndiwembo wa ku Galileya!” ");
INSERT INTO seh_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Penepo Pedhru atoma kupasika dzedze ekha ene mbakhadumbira kuti: “Ine nkhabe kundziwa mamuna uyu analonga imwe.” ");
INSERT INTO seh_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pa ndzidzi unowu, dzongwe yalira pontho kaciwiri. Penepo, Pedhru akumbuka pire pikhadalonga Yezu kuti: “Dzongwe yaciwiri mbidzati kulira, iwe unadza kandikhonda katatu.” Na tenepo Pedhru atoma kulira. ");
INSERT INTO seh_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mangwana mwace na macibese ene, akulu aanyantsembe pabodzi na mathubu, na anyakudziwisa a mwambo, na onsene nsoka wa nyumba yakutongera miseru, agumanyikana toera abverane kuti anancita tani Yezu. Pidamala iwo kum'manga, ankwata mbaenda kampereka kuna Piratu. ");
INSERT INTO seh_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Piratu ambvundza Yezu tenepa: “Kodi iwe ndiwe mambo wa madjuda?” Iye antawira kuti: “Analonga penepi ndiwe.” ");
INSERT INTO seh_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Akulu aanyantsembe akhampambazira pinthu pizinji. ");
INSERT INTO seh_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Na tenepo, Piratu ambvundza pontho kuti: “Kodi iwe nkhabe tawira cinthu? Lang'ana pyonsene ipi pinakupambazira iwo!” ");
INSERT INTO seh_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mbwenye Yezu nkhabe cibodzi cidatawira iye. Na tenepo, Piratu adzumatirwa napyo pikulu kakamwe. ");
INSERT INTO seh_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ungafika ndzidzi wa phwandu ya Paxkwa, Piratu akhali na nsambo wace wakubulusa munthu m'bodzi n'kaidi, ule anafuna mbumba kuti abuluswe. ");
INSERT INTO seh_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Pa ndzidzi onowu akhalipo nkaidi, mamuna m'bodzi akhacemerwa Bharabhasi. Iye akhadafungirwa mwenemo pabodzi na andzace thangwi ya kupha munthu pa cikuti. ");
INSERT INTO seh_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mwinji wa anthu wabwera mbutoma phemba kuti Piratu abuluse munthu m'bodzi n'kaidi, ninga nsambo unakhala iwo mbacita. ");
INSERT INTO seh_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Penepo, Piratu aabvundza tenepa: “Musafuna kuti ndikubulusireni mambo wa madjuda?” ");
INSERT INTO seh_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Thangwi iye akhapidziwa kuti akulu aanyantsembe akhadampereka Yezu m'manja mwace na thangwi ya bibvu. ");
INSERT INTO seh_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mbwenye akulu aanyantsembe akhanyengerera mbumba kuti iphembe Piratu toera abuluse Bharabhasi n'kaidi, mbasiya Yezu. ");
INSERT INTO seh_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Na tenepo, Piratu aabvundza pontho kuti: “Musafuna ndincitenji mphapo mamuna uyu anacemera imwe mambo wa madjuda?” ");
INSERT INTO seh_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Penepo, mbumba yakhuwa kuti: “Nkhomereni pa ntanda!” ");
INSERT INTO seh_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Piratu aabvundza kuti: “Adawanji iye?” Mbwenye mbumba ikhakhuwiratu kakamwe kuti: “Nkhomereni pa ntanda!” ");
INSERT INTO seh_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Penepo Piratu na kufuna kukoma kuna mbumba, aabulusira n'kaidi Bharabhasi. Pidamala iye akwapulisa Yezu na n'chamu mbampereka kuti akhomerwe pa ntanda. ");
INSERT INTO seh_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Buluka penepo, anyankhondo ankwata Yezu mbaenda naye nkati mwa nyumba ya ntongi, mwenemo agumanyikana anyankhondo onsene. ");
INSERT INTO seh_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pa kumala, ambvazika nguwo za umambo, mbaluka nthimba ya minga mbamuikha munsolo mwace. ");
INSERT INTO seh_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Mbatoma kum'mwanyika tenepa: “Dondowe mambo wa madjuda!” ");
INSERT INTO seh_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Penepo akham'menya na mpsimbo munsolo mwace mbakhamphulira mata, mbagodama patsogolo pace ninga nkhumulambira. ");
INSERT INTO seh_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pidamala iwo kunsingirira, an'dulisa nguwo za umambo mbambvazika pontho nguwo zace. Penepo ankwata mbaenda naye kunja toera akankhomere pa ntanda. ");
INSERT INTO seh_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Mamuna m'bodzi wa ku Sirene anacemerwa Simau, baba wa Alixande na Rufu, akhapita na penepo, buluka ku munda. Anyakhondo ankakamiza kuti akwate ntanda. ");
INSERT INTO seh_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Na tenepo, iwo ankwata Yezu mbaenda naye ku mbuto ibodzi inacemerwa Gologota. Ndiko kubveka mbuto ikhataiwa madudu a misolo ya anthu a kufa. ");
INSERT INTO seh_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Na tenepo, iwo ampasa vinyu ya kubvungazwa na ntombwe unacemerwa mira, mbwenye Iye akhonda kuimwa. ");
INSERT INTO seh_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ankhomera pa ntanda, mbagawa nguwo zace, mbamenya ntsango toera adziwe cinafuna kwata munthu m'bodzi na m'bodzi. ");
INSERT INTO seh_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ukhali ndzidzi wa cipfemba wa macibese mudankhomera iwo pa ntanda. ");
INSERT INTO seh_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Padzulu pa ntanda pakhadalembwa, thangwi idakhomererwa Yezu, na mafala awa: Mambo wa madjuda. ");
INSERT INTO seh_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Akhomerwambo pa ntanda pabodzi na Yezu mambava mawiri, m'bodzi ku khundu yace ya madyo, unango ku khundu ya bzere. ");
INSERT INTO seh_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Na tenepo, pyasimbisiswa pikhadalembwa kale ene m'Bukhu ya Mulungu kuti: “Iye alengeswa ninga m'bodzi wa anthu a kuipa mitima.” ");
INSERT INTO seh_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Anthu onsene akhapita na penepo akhansingirira mbakhasukusa misolo, mbakhantikana tenepa: “Ha! lang'anani ule akhalonga kuti anakwanisa kufudza Nyumba ya Ntsembe, mbaimanga pontho pa ntsiku zitatu! ");
INSERT INTO seh_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Apo chita mphapo pa ntanda upulumusike wekha ene.” ");
INSERT INTO seh_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Akulu aanyantsembe na anyakudziwisa a mwambo, akhansingirirambo mbakhalonga okha-okha kuti: “Iye apulumusa andzace, mbwenye asacimwana pulumusika ekha ene. ");
INSERT INTO seh_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kirixtu, mambo wa Izirayeli chita cincino pa ntanda tikuone, toera tikutawire!” Penepo, ale akhadakhomerwa pabodzi na Yezu, akhantikanambo. ");
INSERT INTO seh_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Pa ndzidzi khumi na uwiri wa masikati, dziko yonsene yatoma kudzala na cidima mpaka pa ndzidzi utatu wa kumaulo. ");
INSERT INTO seh_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Pa ndzidzi wa citatu wa kumaulo, Yezu akhuwa na mphambvu mbalonga tenepa: “Eloi, Eloi, lama sabaktani?” Kweneku ndi kubveka tenepa: “Mulungu wanga, Mulungu wanga, thangwi yanji wandisiya?” ");
INSERT INTO seh_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Anthu anango akhali penepo abva penepyo mbalonga tenepa: “Bveserani! Iye Asacemera Eliya!” ");
INSERT INTO seh_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Penepo, mamuna m'bodzi aenda mbathamanga, mbatotesa thonje mu vinyu ya kuxaxa mbaipfeka pa ntete, mbapasa Yezu kuti amwe, mbalonga tenepa: “Nsiyeni timuone ngakhala Eliya anabwera kam'bulusa penepo!” ");
INSERT INTO seh_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Mbwenye Yezu akhuwa pontho na mphambvu, mbafa. ");
INSERT INTO seh_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Penepo nguwo ikhadasitira mbuto ya Mulungu n'nyumba ya ntsembe, yapanduka nakati-nakati, kutomera kudzulu mpaka pantsi. ");
INSERT INTO seh_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Na tenepo, nkulu wa anyankhondo a ku Roma akhali patsogolo pa ntanda udakhomerwa Yezu, na kubva kukhuwa na kufa kudacita iye, alonga tenepa: “Ndimo mwene, mamuna uyu akhali Mwana wa Mulungudi!” ");
INSERT INTO seh_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Penepo akhalipombo akazi anango mbakhalang'anisa na kutali. Pa nsoka pawo akhagumanika Mariya Madhalena, Salomee, na Mariya, mai wace Tiyago ng'ono wace Zuze. ");
INSERT INTO seh_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Akazi enewa akhadza mbaperekera Yezu na kumphedza mukhali iye ku Galileya. Pontho penepo akhalipombo akazi anango azinji akhadaenda na iye ku Djerusalema. ");
INSERT INTO seh_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Mukhadoka dzuwa, mukhasasanyira iwo ntsiku ya Sabudu, kweneku nkhulongera ntsiku ya cixanu ca kumaulo, ");
INSERT INTO seh_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Zuze wa ku Arimateya, munthu wa mbiri pa nsoka wa anyakutonga miseru, pontho akhadikhirambo Umambo wa Mulungu, aenda na cipapo consene kuna Piratu, mbaphemba manungo a Yezu. ");
INSERT INTO seh_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Piratu adzumatirwa napyo mudabva iye kuti Yezu afa. Penepo, acemeresa nkulu wa anyankhondo a ku Roma mbambvundzisa ngakhala Yezu afa kalene. ");
INSERT INTO seh_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pidamala iye kupangiwa na nkulu wa anyankhondo, apereka manungo a Yezu kuna Zuze wa ku Arimateya. ");
INSERT INTO seh_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Na tenepo, Zuze aenda kagula nguwo yakucena, mbabulusa manungo a Yezu pa ntanda, mbanfinikiza nayo. Buluka penepo, aenda kaikha manungo mu nthumbi ikhadakumbwa pa mwala. Pidamala iye abulumundisa mwala ukulu, mbafunga nawo pa nsuwo wa nthumbi. ");
INSERT INTO seh_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mariya Madhalena, na Mariya mai wace Zuze, aona padaikhwa manungo a Yezu. ");
INSERT INTO seh_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Mudapita ntsiku ya sabudu, Mariya Madhalena, na Salomee, na Mariya mai wace Tiyago, agula mafuta akununkhira toera kadzodza nawo manungo a Yezu. ");
INSERT INTO seh_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","N'dimingu na macibese ene, mukhabuluka dzuwa, iwo aenda ku nthumbi. ");
INSERT INTO seh_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Mukhaenda iwo na njira akhabvundzana tenepa: “Mbani anafuna kutibulusira mwala udafunga nthumbi?” ");
INSERT INTO seh_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Iwo akazi akhalonga penepyo, thangwi mwala ukhali ukulu kakamwe. Mbwenye mudafika iwo, aona kuti mwala ukhadabuluswa kalene. ");
INSERT INTO seh_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Na tenepo, apita n'nthumbi, mbaona mphale m'bodzi akhadabvala nguwo za kucena, akhali nawa ku khundu ya madyo. Penepo, iwo atutumuka mbagopa pikulu kakamwe. ");
INSERT INTO seh_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mbwenye mphale aapanga tenepa: “Lekani gopa! Musasaka Yezu wa ku Nazareti adakhomerwa pa ntanda? Iye alamuka pa kufa. Nkhabemo muno. Lang'anani pakhadaikhwa Iye apa. ");
INSERT INTO seh_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Cincino ndokoni mukhampange Pedhru na anyakupfundza ace anango kuti: Iye ali kutsogola kwenda ku Galileya. Kweneko munaenda kamuona ninga mudalongera Iye.” ");
INSERT INTO seh_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Na tenepo, akazi athawa mbabuluka pa nthumbi mbakhadzadzamira na kugopa. Na thangwi ya kugopa kukhali na iwo, acimwana kupanga munthu cinthu. ");
INSERT INTO seh_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yezu alamuka pa kufa ntsiku ya Dimingu na macibese ene, mbaonekera pa kutoma kuna Mariya Madhalena, ule akhadabulusa Iye mizimu minomwe ya kuipa. ");
INSERT INTO seh_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mariya Madhalena aenda kalonga kuna andzace Yezu. Iwo akhatsukwala mbakhalira. ");
INSERT INTO seh_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mudapibva iwo mbapilongwa kuti Yezu ali m'maso, pontho kuti akhadaonekera kuna Mariya Madhalena, iwo akhonda kupitawira. ");
INSERT INTO seh_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Buluka penepo, Yezu aonekera pontho na makhaliro anango kuli anyakupfundza ace awiri, mbakhaenda kunja kwa nzinda. ");
INSERT INTO seh_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Iwo abwerera mbaenda kalonga penepyo kuna anyakupfundza anango. Mbwenye iwo akhonda kupitawira pire pidalongwa na andzawo awiri. ");
INSERT INTO seh_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pakumalisira, Yezu aonekera pontho kuli anyakupfundza ace khumi na m'bodzi pikhadya iwo. Yezu aasandika na thangwi ya kukhonda kukhulupira kwawo, pontho na upoka wawo wa kukhonda kutawira pinalonga andzawo akhadaona Yezu wakulamuka pa kufa. ");
INSERT INTO seh_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Yezu aapanga tenepa: “Ndokoni pa dziko yonsene ya pantsi pano, mbamumwaza Mphangwa Zadidi kuna anthu onsene. ");
INSERT INTO seh_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ule anatawira mbatambira batixmu anapulumuka, mbwenye ule anakhonda kutawira, anatongwa. ");
INSERT INTO seh_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kuli ale anatawira anadza kapaswa mphambvu za kucita pirengo ninga ipi: Na dzina yanga, anathamangisa mizimu ya kuipa, analonga malongero mapsa, ");
INSERT INTO seh_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","anaphata nyoka, angamwa ntombwe wa kupha munthu, nkhabe kuacita pya kuipa, pontho angamphemberera atenda mbaasandzika manja, iwo ana wanga.” ");
INSERT INTO seh_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pa kumala kulonga penepyo na anyakupfundza ace, Mbuya Yezu akwatiwa mbaenda kudzulu, mbakhala ku khundu ya nkono wa madyo wa Mulungu. ");
INSERT INTO seh_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Na tenepo, anyakupfundza a Yezu aenda mbamwaza Mphangwa Zadidi m'makhundu onsene. Mbuya akhaapedza na pirengo toera kusimbisisa mphangwa zikhalonga iwo kuti ndizodi. ");
INSERT INTO seh_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Anthu azinji acita mphambvu za kulemba pinthu pidacitika pakati pathu, ");
INSERT INTO seh_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ninga mudapipangwa ife na ale akhali anyamaso kutomera pa kutoma, pontho mbakhala anyabasa a fala ya Mulungu. ");
INSERT INTO seh_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Na tenepo, ine ndapipfundza pyonsene ncidikho-dikho kutomera pa kutoma. Pakumala, ndaona kuti mphyadidi ndikulembereni imwe wakulemebza Tiyofilu, cibodzi na cibodzi, pyonsene ninga mudacitikira ipyo, ");
INSERT INTO seh_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","toera mukhonde kupenula pinthu pidapfundziswa imwe. ");
INSERT INTO seh_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Pa n'dzidzi wa Herodhi mambo wa Djudeya, akhalipo nyantsembe m'bodzi akhacemerwa Zakariya. Iye akhali m'bodzi wa nsoka wa anyantsembe wa Abiya. Nkazi wace akhali Zabere. Iye Zabere akhalimbo wa dzindza ya Arau. ");
INSERT INTO seh_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zakariya na nkazi wace akhali anthu akulungama pa maso pa Mulungu. Iwo akhabvera mwakukwana myambo na matongero onsene a Mbuya. ");
INSERT INTO seh_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mbwenye iwo hakhali na ana tayu, thangwi Zabere hakhabala tayu. Pontho mamuna na nkazi, akhadakulupala. ");
INSERT INTO seh_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ntsiku inango, pa n'dzidzi ukhakhala nsoka wa Zakariya m'basa, iye akhacita basa yace ya unyantsembe patsogolo pana Mulungu. ");
INSERT INTO seh_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ninga nsambo wa anyantsembe, iye asankhulwa toera apite mu Nyumba ya Mbuya, kuti aende kapisa pinthu pyakununkhira pinacemerwa isensu. ");
INSERT INTO seh_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Pa n'dzidzi ukhapiswa isensu, mbumba yonsene ikhaphembera kunja. ");
INSERT INTO seh_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Na tenepo, anju wa Mbuya abulukira pana Zakariya, mbalimira ku khundu ya madyo ya guwa ikhapisirwa isensu. ");
INSERT INTO seh_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakariya na kuona anju, atutumuka mbagopa. ");
INSERT INTO seh_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mbwenye anju ampanga kuti: “Leka gopa, Zakariya! Mulungu abva maphembero ako. Nkazi wako Zabere anadza kabala mwana wa mamuna, dzina yace iwe unadza kanthula Juwau. ");
INSERT INTO seh_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kunaoneka kukomerwa na kutsandzaya muna iwe, na anangombo azinji anatsandzaya na kubaliwa kwace. ");
INSERT INTO seh_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Thangwi iye anakhala nkulu pa maso pa Mbuya. Pontho iye nkhabe kudza kamwa vinyu na pya kumwa pinango pya kuledzeresa. Anati adzale na Nzimu wa Mulungu kutomera m'mimba mwa mai wace. ");
INSERT INTO seh_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Na tenepo, anati aabweze pontho anthu azinji a mbumba ya Izaraeli aenda kuna Mbuya Mulungu wawo. ");
INSERT INTO seh_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Iye anaenda patsogolo pa Mbuya, mu nzimu na mphambvu ninga za Eliya, toera abweze mitima ya ababa kuna anawo, na kuna anthu akukhonda kubvera abwerere mwakulungama, kuti asasanyire mbumba toera iphatire basa Mbuya.” ");
INSERT INTO seh_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Mphapo Zakariya abvundzisa anju mbalonga kuti: “Ndinapidziwa tani pinthu penepi kuti ndimo mwenedi? Thangwi ine na nkazanga, tonsene ndife mankhalamba.” ");
INSERT INTO seh_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Anju antawira tenepa: “Ine ndine Gabhiriyeli, ndiri pa maso pa Mulungu midzidzi yonsene. Iye andituma ndilonge na iwe toera ndikupase mphangwa izi zadidi. ");
INSERT INTO seh_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Cincino iwe unakhala bewewe. Unacimwana kulonga mpaka ntsiku inacitika penepi. Thangwi wapokanya mafala anga, anadza kafuna kucitika n'dzidzi wace ungakwana.” ");
INSERT INTO seh_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mukhacitika penepyo, mbumba yonsene ikhadikhira Zakariya, mbwenye ikhadzumatirwa na kuona kudembuka kukhacita iye mu Nyumba ya Mulungu. ");
INSERT INTO seh_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pa kubuluka kwace Zakariya mu Nyumba ya Mulungu, abuluka mbali bewewe mbakhacimwana kulonga. Penepo mbumba yonsene yadzindikira kuti piripo pikhadaoneswa iye na Nzimu wa Mulungu n'kati mwa Nyumba ya Mulungu. Na tenepo, Zakariya akhakwanisa kulonga na mbumba na manja basi. ");
INSERT INTO seh_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Pidamala izo ntsiku zace za basa mu Nyumba ya Mulungu, Zakariya abuluka mbaenda ku nyumba kwace. ");
INSERT INTO seh_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pakumala penepo, Zabere nkazi wa Zakariya akhala na pa thupi. Na tenepo, amala myezi mixanu, mbakhakhala pa nyumba. ");
INSERT INTO seh_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Iye akhalonga tenepa: “Izi ndi nkhombo za Mbuya! Cincino Iye andionambo toera kundimwaza manyadzo patsogolo pa mbumba.” ");
INSERT INTO seh_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Zabere pikhakhala iye na pa thupi ya myezi mitanthatu, Mulungu atuma anju Gabhiriyeli, kuti aende ku nzinda ubodzi unacemerwa Nazareti ku dziko ya Galileya, ");
INSERT INTO seh_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kuti aende kalonge na mwali m'bodzi anacemerwa Mariya, akhadasembwa na Zuze, mwana wa dzindza ya mambo Dhavidhi. ");
INSERT INTO seh_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Anju afendedzera Mariya, am'mwanyika mbampanga tenepa: “Makolokoto iwe wakudzala na nkhombo! Mbuya ali na iwe.” ");
INSERT INTO seh_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Apo Mariya na kupibva, adzumatirwa pikulu kakamwe, mbakhasaka kudziwa kuti mamwanyikiro enewa asalonganji? ");
INSERT INTO seh_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mbwenye anju ampanga kuti: “Leka kugopa Mariya, thangwi Mulungu asafuna kukupasa nkhombo zace! ");
INSERT INTO seh_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Iwe unati ukhale na pa thupi mbubala mwana wa mamuna, dzina yace unadza kanthula Yezu. ");
INSERT INTO seh_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Iye anakhala nkulu, mbadza kacemerwa Mwana wa Mulungu wa nkulu kakamwe. Mulungu Mbuya anadza kampasa umambo wa baba wace Dhavidhi. ");
INSERT INTO seh_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Pontho Iye anadza katonga kwenda na kwenda mbumba ya Djakobo. Umambo wace nkhabe kudza kamala.” ");
INSERT INTO seh_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mphapo Mariya alonga kuna anju kuti: “Pinacitika tani penepi, thangwi ine ndisati kudziwa mamuna?” ");
INSERT INTO seh_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Anju antawira tenepa: “Nzimu wa Mulungu unabwera muna iwe. Pontho mphambvu za Mulungu wa nkulu kakamwe zinakugudumira na n'thundzi wace. Na thangwi eneyo, mwana anafuna kudza kabalwa, anadza kacemerwa wakulungama, pontho anadza kacemerwa Mwana wa Mulungu. ");
INSERT INTO seh_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Pontho m'bale wako Zabere, anati akhale na mwana wa mamuna pa unkhalamba wace. Ule akhalongwa kuti nkhabe kubala, lero iye ana pa thupi, mwezi uno ndi wacitanthatu. ");
INSERT INTO seh_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Thangwi kuna Mulungu nkhabe cinthu cinacimwanika.” ");
INSERT INTO seh_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Penepo Mariya antawira tenepa: “Ndiri pano ine n'dzakazi wa Mbuya. Mphapo mbapicitike pyapyo kuna ine ninga mudapilongera imwe.” Na tenepo, anju aenda pyace. ");
INSERT INTO seh_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Pa ntsiku zenezo, Mariya acita ulendo wace na mwansanga, mbaenda ku nzinda ubodzi ukhagumanika ku cisa ca mapiri, ku dziko ya Djudeya. ");
INSERT INTO seh_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Kweneko, iye apita n'nyumba ya Zakariya mbamwanyika Zabere. ");
INSERT INTO seh_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Zabere na kubva kumwanyikwa kudacitwa iye na Mariya, mwana athaula m'mimba mwace. Na tenepo, Zabere adzala na Nzimu wa Mulungu, ");
INSERT INTO seh_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","mbalonga na mphambvu kuti: “Iwe ndiwe wakusimbwa pakati pa akazi, pontho mwana anafuna kudza kabala iwe ndi wakusimbwambo! ");
INSERT INTO seh_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Mbwenye ndine ani ine kuti ndidze kaoniwa na mai wace Mbuya wanga? ");
INSERT INTO seh_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Pa n'dzidzi ubodzi ene udabva ine kumwanyikwa na iwe, mwana wanga atoma kuthaula m'mimba mwanga na kukomerwa. ");
INSERT INTO seh_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kutsandzaya ndi kwako iwe Mariya adatawira kuti pinacitika pidakupanga Mbuya!” ");
INSERT INTO seh_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Na tenepo, Mariya alonga kuti: “Ntima wanga usakuza Mbuya. ");
INSERT INTO seh_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Pontho nzimu wanga usasekera Mulungu, Mpulumusi wanga, ");
INSERT INTO seh_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","thangwi iye akumbukambo ine n'dzakazi wace, munthu wakukhonda kukwanira. Apo kutomera lero mpaka kutsogolo, madzindza onsene anati andicemere nkazi wakudzala na nkhombo. ");
INSERT INTO seh_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Thangwi Mulungu wa mphambvu acita pinthu pikulu kakamwe kuna ine. Wakulungama ndiyo dzina yace. ");
INSERT INTO seh_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ntsisi zace asazipangiza kuna ale anan'gopa, pa dzindza na dzindza. ");
INSERT INTO seh_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Iye acita pinthu pikulu na nkono wace, mbamwaza ale akhanyerezera pya umbirimi n'kati mwa mitima yawo. ");
INSERT INTO seh_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Agwisa amambo a mphambvu m'mipando mwawo ya umambo, mbakwiza anthu akupwazika. ");
INSERT INTO seh_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Akhutisa anyanjala na pinthu pyadidi, mbwenye athamangisa anyakupfuma cimanja-manja. ");
INSERT INTO seh_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Aphedza n'dzakazi wace Izaraeli, mbakumbukira ntsisi zace ");
INSERT INTO seh_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","kuna Abharaamu na dzindza yace kwenda na kwenda, ninga mudapikirira Iye a mbuya athu.” ");
INSERT INTO seh_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariya akhala na Zabere dhuzi na kuthamangira myezi mitatu, buluka penepo mbabwerera ku nyumba kwace. ");
INSERT INTO seh_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Pidakwana izo ntsiku zace za kubala, Zabere abala mwana wa mamuna. ");
INSERT INTO seh_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Abale ace na anthu anango a pa cisa, abva kuti Mulungu ambvera ntsisi zikulu, mbaenda onsene kancitira makolokoto. ");
INSERT INTO seh_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pa ntsiku yacisere, anthu aenda kansidza cimwenyi mwana, mbakhafuna kumpasa dzina ya Zakariya, dzina ya baba wace mwana. ");
INSERT INTO seh_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mbwenye mai wace atawira mbalonga tenepa: “Nkhabe! Iye anacemerwa Juwau.” ");
INSERT INTO seh_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Penepo iwo antawira nkazi kuti: “Ku dzindza kwako nkhabe munthu ana dzina eneyi.” ");
INSERT INTO seh_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Na tenepo, iwo atoma kulonga na manja na baba wace mwana, toera adziwe dzina yanji inafuna ine kupasa mwana wace. ");
INSERT INTO seh_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakariya aphemba citabwa kuti alemberepo dzina ya mwana. Penepo iye alemba tenepa: “Dzina yace ndi Juwau.” Na tenepo, onsene adzumatirwa napyo. ");
INSERT INTO seh_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Pa n'dzidzi ubodzi-bodzi, Zakariya atoma kulonga pontho mwadidi ninga mwakale, mbatoma kukuza Mulungu. ");
INSERT INTO seh_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Anthu onsene a pacisa atoma kugopserwa pikulu. Na tenepo, mphangwa zenezo zamwazika n'cisa consene ca m'mapiri a ku Djudeya. ");
INSERT INTO seh_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Onsene akhabva mbapilongwa penepyo akhabvundzisana tenepa: “Kodi mwana uyu anadza kakhala ani?” Thangwi mphambvu za Mbuya zikhali na iye. ");
INSERT INTO seh_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Penepo Zakariya, babace mwana, adzazwa na Nzimu wa Mulungu mbatoma kulonga pinthu na nzimu ubodzi-bodzi kuti: ");
INSERT INTO seh_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Mbasimbwe Mbuya, Mulungu wa Izaraeli, thangwi iye abwera kudza kaona na kupulumusa mbumba yace. ");
INSERT INTO seh_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Iye atidzesera upulumuki wa mphambvu wa dzindza ya n'dzakazi wace Dhavidhi. ");
INSERT INTO seh_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","(Ninga mudapilongera Mulungu kale na kale na milomo ya aporofeta ace akulungama,) ");
INSERT INTO seh_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","mbatipulumusa mwa anyamalwa athu na m'manja mwa onsene anatizonda, ");
INSERT INTO seh_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","toera kupangiza a mbuya athu ntsisi zace, pontho na kukumbuka cibverano cace ca kulungama, ");
INSERT INTO seh_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","na cidumbiriro cidacita Iye kuna baba wathu Abharaamu, ");
INSERT INTO seh_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ca kutiombola m'manja mwa anyamalwa athu, toera timphatire basa na kukhonda kugopa, ");
INSERT INTO seh_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","mwakulungama na mwa udidi pa maso pace, ntsiku zathu zonsene. ");
INSERT INTO seh_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Iwe mwana wanga, unati ucemerwe mporofeta wa Mulungu wa nkulu kakamwe. Unaenda patsogolo pa Mbuya toera unsasanyire njira, ");
INSERT INTO seh_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","toera kupasa mbumba yace udziwisi wa upulumuki, unabulukira pa kulekererwa kwa madawi awo, ");
INSERT INTO seh_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","na thangwi ya ntsisi zikulu za Mulungu wathu, zinacita kuti atigasire dzuwa ya kudzulu, ");
INSERT INTO seh_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","toera kumwinikira ale anakhala n'cidima na ali mu nthundzi wa kufa, pontho toera kulondeza myendo yathu mu njira ya ntendere.” ");
INSERT INTO seh_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mwana akhakula mbawanga mu nzimu. Pontho akhala n'thando mpaka ntsiku idabulukira iye pakweca, kuna mbumba ya Izaraeli. ");
INSERT INTO seh_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Pa n'dzidzi unowu, mambo Sezari Aguxtu wa ku Roma, amwaza ntemo n'dziko mwace wa kulonga kuti mbumba yonsene isatongwa ilemberwe. ");
INSERT INTO seh_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Uku ndi kulemberwa kwakutoma kwa anthu, kudacitika pa n'dzidzi ukhatonga mambo Kirinu dziko ya Sirya. ");
INSERT INTO seh_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Na tenepo, anthu onsene akhaenda ku mizinda yawo ya kubaliwa, toera akhalemberwe. ");
INSERT INTO seh_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Zuze, na thangwi ya kukhala wa dzindza ya Dhavidhi, abulukambo ku nzinda wa Nazareti, ku dziko ya Galileya, mbaenda ku dziko ya Djudeya, ku nzinda wa Bheleya, kudabaliwa mambo Dhavidhi. ");
INSERT INTO seh_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Kweneko, Zuze aenda pabodzi na nkazi wace Mariya mbali na pa thupi, toera akhalemberwembo. ");
INSERT INTO seh_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Pa n'dzidzi ukhakhala iwo ku Bheleya, wakwanambo n'dzidzi kuti mwana abaliwe. ");
INSERT INTO seh_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Na tenepo, Mariya abala mwana wace wa utombo wa mamuna. Penepo mai wace anfinikiza na nguwo, mban'gonesa n'cimwadiya cikhadyera pifuyo, thangwi nyumba ya kufikira alendo ikhadadzala. ");
INSERT INTO seh_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Pa cisa ceneco, akhalipo akumbidzi n'thando, mbakhaonera pifuyo pyawo na masiku. ");
INSERT INTO seh_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Penepo anju wa Mbuya aabulukira, mbiri ya Mbuya yayetimira nkhundu mwawo, iwo mbagopa pikulu kakamwe. ");
INSERT INTO seh_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Mbwenye anju aapanga kuti: “Lekani kugopa! Ndakudzeserani Mphangwa Zadidi zakutsandzaisa pikulu kakamwe kuna anthu onsene. ");
INSERT INTO seh_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Thangwi lero, mu nzinda wa Dhavidhi, abalwa Mpulumusi wanu Kirixtu Mbuya. ");
INSERT INTO seh_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Imwe munandzindikira na ici: Munagumana mwana wa ng'ono adabalwa cincino adafinikizwa na nguwo, mbagoneswa n'cimwadiya cakudyera pifuyo.” ");
INSERT INTO seh_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Na mwansanga, wabulukira mwinji wa anyankhondo a kudzulu, pabodzi na anju, mbakhakuza Mulungu na mafala awa: ");
INSERT INTO seh_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Mbiri kuna Mulungu wa kudzulu, ntendere pa dziko kuna anthu ale anafuniwa na Iye.” ");
INSERT INTO seh_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Anju pidabwerera izo mbazyenda kudzulu, akumbidzi atoma kulonga okha-okha tenepa: “Tendeni ku Bheleya tikhaone ipi pidacitika, pontho tikhaone pidatipanga Mbuya.” ");
INSERT INTO seh_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Na tenepo, iwo athamanga mbaenda kweneku, mbagumana Mariya na Zuze, mwana mbakhagona n'cimwadiya cikhadyera pifuyo. ");
INSERT INTO seh_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Pidamala iwo kumuona, alonga kuna anthu onsene, pire pikhadapangwa iwo na anju, pa thangwi ya mwana unowu. ");
INSERT INTO seh_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Apo anthu onsene adapibva pikhalonga akumbidzi, adzumatirwa napyo. ");
INSERT INTO seh_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mbwenye Mariya akhapikoya pinthu pyonsene pikhabva iye, mbakhapinyerezera mwadidi mu ntima mwace. ");
INSERT INTO seh_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Na tenepo, akumbidzi abwerera mbakhapasa mbiri na kukuza Mulungu pa pyonsene pikhabva iwo na pikhaona iwo, ninga mukhadapipangirwa iwo. ");
INSERT INTO seh_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mudakwana izo ntsiku zisere toera kusidza mwana cimwenyi, athuliwa dzina ya Yezu, dzina ikhadapaswa iye na anju, mai wace mbadzati kukhala na pa thupi. ");
INSERT INTO seh_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mudakwana iwo n'dzidzi wa kuceneswa, ninga mudalongera mwambo wa Mozesi, Zuze na Mariya ankwata mwana mbaenda naye ku Djerusalema, toera ampereke patsogolo pana Mbuya, ");
INSERT INTO seh_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(ninga mudalemberwa ipyo mu mwambo wa Mbuya kuti: “Ana a utombo onsene acimuna, asatongwa aperekwe m'manja mwa Mbuya.”) ");
INSERT INTO seh_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Pontho toera kupereka ntsembe za ana madjiwa awiri, peno ana nkhangaiwa awiri, ninga munalongera mwambo wa Mbuya. ");
INSERT INTO seh_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Apo ku Djerusalema, akhalipo mamuna m'bodzi akhacemerwa Simiyau. Iye akhali munthu wakulungama mbakhalemedza Mulungu, pontho akhadikhira kumatamiswa kwa mbumba ya Izaraeli. Nzimu wa Mulungu ukhakhala na iye. ");
INSERT INTO seh_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Pontho Nzimu wa Mulungu ukhadampangiza kuti iye nkhabe kufa, mbadzati kumuona Kirixtu adapikirirwa na Mbuya. ");
INSERT INTO seh_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Simiyau, akwatwa na Nzimu wa Mulungu, mbaenda mu Nyumba ya Mulungu. Baba wace na mai wace, pidankwata iwo mwana mbaenda naye mu Nyumba ya Mulungu toera kancitira pinalonga mwambo, ");
INSERT INTO seh_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simiyau akwata mwana m'manja mwace mbakuza Mulungu, mbalonga tenepa: ");
INSERT INTO seh_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Cincino, siyani n'dzakazi wanu aende pyace na ntendere ninga mudampikirira imwe. ");
INSERT INTO seh_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Thangwi ndamuona ndekha na maso anga Mpulumusi, ");
INSERT INTO seh_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","adasasanyira imwe pa maso pa mbumba zonsene. ");
INSERT INTO seh_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Cieza toera mwinikira mbumba zidakhonda kukhala madjuda, pontho na kupasa mbiri mbumba yanu ya Izaraeli.” ");
INSERT INTO seh_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Baba wace na mai wace mwana, akhala akudzumatirwa na pire pikhalongwa na thangwi ya mwana. ");
INSERT INTO seh_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simiyau aphemba kuna Mulungu kuti aapase nkhombo, mbalonga kuna Mariya mai wace Yezu kuti: “Mwana uyu asankhulwa kalene na Mulungu toera kugwisa na kulamusa anthu azinji a dziko ya Izaraeli. Pontho mwana unowu anati akhale cidzindikiro ca Mulungu ca kukhonda kubverana. ");
INSERT INTO seh_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Na tenepo, manyerezero mazinji a m'mitima mwawo anadza kadziwika, pontho iwe unadza katsukwala ninga munthu adalaswa na tarasada mu ntima.” ");
INSERT INTO seh_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Akhalipo penepo mporofeta wa nkazi akhacemerwa Yana mwana wa Fanweli, wa dzindza ya Azeri. Iye akhali nkhalamba. Akhadaferwa na mamuna akhadakhala na iye pyaka pinomwe basi pa banja. ");
INSERT INTO seh_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Na tenepo, iye akhala na uzice wa kuferwa na mamuna mpaka pyaka makumasere na pinai. Akhalambira Mulungu wace, mbakhaphembera na kupimana ca kudya, masiku na masikati mbakhakhonda buluka mu Nyumba ya Mulungu. ");
INSERT INTO seh_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Pidafika iye mwenemu, pa n'dzidzi unowu ene, atoma kupereka takhuta kuna Mulungu, mbalonga na thangwi ya Mwana kuna anthu onsene akhadikhira kuombolwa kwa Djerusalema. ");
INSERT INTO seh_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Pakumala kucita pyonsene pya Mwambo wa Mbuya, Zuze na Mariya abwerera kwenda ku nzinda wawo wa Nazareti, ku dziko ya Galileya. ");
INSERT INTO seh_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Na tenepo, Mwana akhakula mbakhakhala na mphambvu, mbadzala na udziwisi. Pontho nkhombo za Mulungu zikhali na Iye. ");
INSERT INTO seh_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Pa pyaka pyonsene, baba wace na mai wace Yezu akhaenda ku Djerusalema, pa phwandu ya Paxkwa. ");
INSERT INTO seh_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yezu mudacita Iye pyaka khumi na piwiri, aenda na baba wace na mai wace ku phwandu ya Paxkwa ku Djerusalema, ninga nsambo wawo. ");
INSERT INTO seh_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Mudamala phwandu ya Paxkwa, pa kubwerera kwenda ku nyumba kwawo, Yezu akhadasalikira ku Djerusalema, baba wace na mai wace mbakhonda dziwa cinthu. ");
INSERT INTO seh_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Baba wace na mai wace, na kunyerezera kuti Iye ali kubwera na andzace njira, amala ntsiku ya mumphu mbakhafamba. Na tenepo, iwo atoma kunsaka pakati pa abale na pa anthu a pa cisa. ");
INSERT INTO seh_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pidansowa iwo, abwerera ku Djerusalema kansaka. ");
INSERT INTO seh_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Pa kupita ntsiku zitatu, iwo an'gumana mu Nyumba ya Mulungu, mbali nawa pakati pa anyakudziwisa a mwambo, mbakhaabvesera na kuabvundzisa. ");
INSERT INTO seh_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Penepo anthu onsene akhamubva akhadzumatirwa na thangwi ya ndzeru zace, pontho na matawiriro ace mibvundzo. ");
INSERT INTO seh_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Baba wace na mai wace pidamuona iwo, adzumatirwambo napyo. Penepo mai wace ampanga kuti: “Mwananga, Thangwi yanji wacita penepi kuna ife? Babako na ine tikhadatsukwala pikulu na kukusaka.” ");
INSERT INTO seh_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Apo Yezu antawira tenepa: “Thangwi yanji mukhandisaka? Imwe nkhabe kupidziwa kuti Ine ndisatongwa ndicite pinthu pya Babanga?” ");
INSERT INTO seh_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mbwenye iwo acimwana kupibvesesa pikhalonga Yezu. ");
INSERT INTO seh_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Na tenepo, Yezu abwerera pabodzi na baba wace na mai wace, kwenda ku Nazareti. Yezu akhali mwana wakuabvera. Mbwenye mai wace Yezu akhapikoya pyonsene ipi mu ntima mwace. ");
INSERT INTO seh_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Apo Yezu akhakula pa udziwisi, na pa thupi, na pa nkhombo, pa maso pa Mulungu na pa maso pa anthu. ");
INSERT INTO seh_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Pa caka ca cikhumi na pixanu ca umambo wa Tibheryo Sezari, Ponsyo Pilato mbali ntongi wa Djudeya, Herodhi mbali ntongi wa Galileya, m'bale wace Herodhi anacemerwa Filipi mbali ntongi wa Itureya na Tarakonite, Lizanya mbali ntongi wa Abhileni, ");
INSERT INTO seh_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anasi na Kaifasi mbali akulu aanyantsembe. Ndi caka ceneco cidalonga Mbuya n'thando kuna Juwau mwana Zakariya. ");
INSERT INTO seh_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Juwau afamba cisa consene dhuzi na nyanza ya Djorodani, mbakhamwaza mphangwa izi: “Tambirani batixmu, ninga cidzindikiro ca kuchunyuka toera kulekererwa kudawa.” ");
INSERT INTO seh_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ipi pyacitika ninga mudapilembera mporofeta Izaiya m'bukhu mwace mbalonga tenepa: “Alipo anakhuwa n'thando kuti: ‘Sasanyirani njira toera Mbuya apite nayo. Nfungulireni miseu ya kulungama. ");
INSERT INTO seh_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Magowa onsene anatutirwa. Mapiri na nthunda zonsene zinazerezwa. Miseu ya magurayi inalungamiswa, njira za makolong'ondo zinazerezwa. ");
INSERT INTO seh_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Anthu onsene anati aone kupulumusa kwa Mulungu.’” ");
INSERT INTO seh_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Juwau akhapanga mwinji wa anthu ukhabwera katambira Batixmu kuna iye, mbalonga tenepa: “Dzindza ya nyoka! Mbani akupangani kuti muthawe nyatwa zinafuna kudza? ");
INSERT INTO seh_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Citani pinthu pinapangiza kuti imwe mwachunyukadi. Lekani kunyerezera mbamulonga mwekhene m'bodzi na m'bodzi kuti: ‘Ife ndife ana a dzindza ya Abharaamu.’ Thangwi ine ndisakupangani kuti Mulungu ana mphambvu za kusanduza myala iyi, kuti ikhale ana a dzindza ya Abharaamu! ");
INSERT INTO seh_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mbadzo yamala kusasanyirwa toera kugwanda nayo miti na michici ene. Na tenepo, muti onsene unakhonda kubala misapu yadidi, unagwandiwa mbuponyiwa pa moto.” ");
INSERT INTO seh_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Penepo mbumba ikhabvundzisa Juwau Bhatixta mbilonga kuti: “Mphapo tisatongwa ticitenji?” ");
INSERT INTO seh_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Apo Juwau aatawira tenepa: “Ana nguwo ziwiri, mbapasembo ibodzi ndzace adaisowa. Pontho ule ana ca kudya mbagawirane na ule adasowa ca kudya.” ");
INSERT INTO seh_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Penepo, anango anyakukumbusa misonkho afikambo kuna Juwau toera kutambira batixmu, mbambvundza kuti: “Mpfundzisi, ndi ninji pinatongwa ife kucita?” ");
INSERT INTO seh_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juwau aatawira tenepa: “Kumbusani ntengo unalonga mwambo basi.” ");
INSERT INTO seh_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Na tenepo, anyakhondo anango akhabvundzisambo kuti: “Kodi ife, tisatongwa ticitenji?” Penepo Juwau aatawira kuti: “Lekani kukwatira munthu kobiri yace na mphambvu, peno kumulongera pya uthambi. Mbwenye komerwani na ntengo wanu unatambira imwe.” ");
INSERT INTO seh_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Na tenepo, mbumba yatoma kukhala na cidikhiro cikulu, mbakhanyerezera kuti panango Juwau Bhatixta ndiye Kirixtu. ");
INSERT INTO seh_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Penepo Juwau aapanga anthu onsene kuti: “Ine ndisakutambirisani batixmu na madzi, mbwenye ali kubwera munthu wa mphambvu ya utongi kakamwe kupita ine. Pontho ine sine munthu kuti ndinakwanisa kunsudzula mithambo ya ntsapato zace. Unowu anakutambirisani batixmu na Nzimu wa Mulungu na moto. ");
INSERT INTO seh_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Iye ana foxolo m'manja mwace toera kucenesa pa mbuwa, na kuikha tirigu n'cikwa. Mbwenye anapisa maudzu na moto wakukhonda kuthima.” ");
INSERT INTO seh_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Juwau akhalanga mbumba na mafala anango mazinji, na kuapanga Mphangwa Zadidi. ");
INSERT INTO seh_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Mbwenye iye asandika Herodhi na thangwi ya Herodhiya, nkazi wa m'bale wace Herodhi, pontho na thangwi ya pyonsene pya kuipa pikhacita iye. ");
INSERT INTO seh_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pontho Herodhi adza kathimiza kucita pya kuipa pikulu kakamwe, pa kupitisa Juwau n'kaidi. ");
INSERT INTO seh_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Pidamala mbumba yonsene kutambira batixmu, Yezu aendambo katambira batixmu. Apo penepo, Yezu pikhaphembera iye, thambo yafunguka. ");
INSERT INTO seh_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Na tenepo, Nzimu wa Mulungu waoneka mbuchita buluka kudzulu ninga nkhangaiwa, mbumphamira. Penepo, kudzulu kwabuluka fala, mbilonga tenepa: “Iwe ndiwe Mwana wanga wakufunika, ananditsandzaisa.” ");
INSERT INTO seh_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yezu pidatoma Iye kuphata basa, akhatamangira pyaka makumatatu pya kubalwa. Iye akhali mwana wa Zuze, ninga mukhanyerezera anthu. Zuze akhali mwana wa Eli, ");
INSERT INTO seh_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli akhali mwana wa Matati, Matati mwana wa Levi, Levi mwana wa Meliki, Meliki mwana wa Djanai, Djanai mwana wa Zuze, ");
INSERT INTO seh_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Zuze akhali mwana wa Matatiya, Matatiya mwana wa Amosi, Amosi mwana wa Naumi, Naumi mwana wa Esili, Esili mwana wa Nagai, ");
INSERT INTO seh_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai akhali mwana wa Maate, Maate mwana wa Matatiya, Matatiya mwana wa Semeyi, Semeyi mwana wa Zuze, Zuze mwana wa Djuda, ");
INSERT INTO seh_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Djuda akhali mwana wa Juwanaa, Juwanaa mwana wa Resa, Resa mwana wa Zorobhabheli, Zorobhabheli mwana wa Salatiyeli, Salatiyeli mwana wa Neri, ");
INSERT INTO seh_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri akhali mwana wa Meliki, Meliki mwana wa Adhi, Adhi mwana wa Koza, Koza mwana wa Elimadha, Elimadha mwana wa Eri, ");
INSERT INTO seh_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eri akhali mwana wa Djoswee, Djoswee mwana wa Eliyezeri, Eliyezeri mwana wa Djorimi, Djorimi mwana wa Matati, Matati mwana wa Levi, ");
INSERT INTO seh_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi akhali mwana wa Simiyau, Simiyau mwana wa Djuda, Djuda mwana wa Zuze, Zuze mwana wa Djonani, Djonani mwana wa Eliakimu, ");
INSERT INTO seh_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakimu akhali mwana wa Meleya, Meleya mwana wa Mena, Mena mwana wa Matata, Matata mwana wa Nata, Nata mwana wa Dhavidhi, ");
INSERT INTO seh_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dhavidhi akhali mwana wa Djese, Djese mwana wa Obhedhi, Obhedhi mwana wa Bhowazi, Bhowazi mwana wa Salomau, Salomau mwana wa Naasomi, ");
INSERT INTO seh_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasomi akhali mwana wa Aminadhabhi, Aminadhabhi mwana wa Adhimimi, Adhimimi mwana wa Arini, Arini mwana wa Exzoromi, Exzoromi mwana wa Peresi, Peresi mwana wa Djuda, ");
INSERT INTO seh_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Djuda akhali mwana wa Djakobo, Djakobo mwana wa Izaki, Izaki mwana wa Abharaamu, Abharaamu mwana wa Tera, Tera mwana wa Nakori, ");
INSERT INTO seh_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakori akhali mwana wa Seruge, Seruge mwana wa Ragauu, Ragauu mwana wa Faleki, Faleki mwana wa Ebheri, Ebheri mwana wa Sala, ");
INSERT INTO seh_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala akhali mwana wa Kainaa, Kainaa mwana wa Arifaxadhe, Arifaxadhe mwana wa Semi, Semi mwana wa Nowa, Nowa mwana wa Lameki, ");
INSERT INTO seh_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameki akhali mwana wa Metusalemi, Metusalemi mwana wa Enoki, Enoki mwana wa Jaredi, Jaredi mwana wa Maalaleeli, Maalaleeli mwana wa Kainaa, ");
INSERT INTO seh_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainaa akhali mwana wa Enosi, Enosi mwana wa Seti, Seti mwana wa Adhamu, Adhamu mwana wa Mulungu. ");
INSERT INTO seh_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yezu abuluka mu nyanza ya Djorodani wakudzala na Nzimu wa Mulungu, mbakwatiwa kwenda n'thando na Nzimu ubodzi-bodzi wa Mulungu. ");
INSERT INTO seh_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Mwenemu n'thando, Yezu anyengererwa na Sathani ntsiku makumanai. Pa ntsiku zenezi, nkhabe cinthu cidadya iye. Na tenepo, pakumala ntsiku zenezo iye abva njala. ");
INSERT INTO seh_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Penepo Sathani ampanga kuti: “Ngakhala iwe ndiwe Mwana wa Mulungu, panga mwala uyu kuti usanduke ubwere nkate.” ");
INSERT INTO seh_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Mbwenye Yezu antawira tenepa: “Pyalembwa m'Bukhu ya Mulungu kuti: ‘Munthu nkhabe kukhala m'maso na ca kudya basi tayu.’” ");
INSERT INTO seh_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Penepo Sathani ankwata Yezu mbaenda naye pa mbuto ya kulapha, mbampangiza n'dzidzi ubodzi ene, umambo onsene wa pa dziko, ");
INSERT INTO seh_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","mbampanga kuti: “Ine ndinakupasa mphambvu ya utongi na mbiri yonsene iyi. Thangwi pyonsene ipi ndapasiwa, pontho ndinakwanisa kupasa anafuna ine. ");
INSERT INTO seh_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Na tenepo, ungandilambira, pyonsene ipi pinakhala pyako.” ");
INSERT INTO seh_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yezu antawira tenepa: “Pyalembwa kuti: Lambira Mbuya Mulungu wako, mbuphatira Iye ekha basi.” ");
INSERT INTO seh_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pakumala penepo, Sathani ankwata Yezu mbaenda naye ku Djerusalema, mbankwiza padzulu kakamwe pa Nyumba ya Mulungu mbampanga tenepa: “Ngakhala iwe ndiwe Mwana wa Mulungu, numpha ugwe pantsi.” ");
INSERT INTO seh_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Thangwi pyalembwa kuti: “Mulungu anatuma anju zace, na thangwi yako toera akukoye. ");
INSERT INTO seh_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Pontho, iwo anakugampha na manja awo, toera ukhonde kuphekeka pa mwala.” ");
INSERT INTO seh_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yezu antawira tenepa: “Pyalongwa kuti: ‘Leka kulesera Mbuya Mulungu wako.’” ");
INSERT INTO seh_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Pakumala manyengerero onsene awa, Sathani ansiya Yezu mbadikhira n'dzidzi unango. ");
INSERT INTO seh_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Na tenepo, Yezu abwerera ku Galileya wakudzala na mphambvu za Nzimu wa Mulungu, mbiri yace mbibvekera n'cisa ceneco consene. ");
INSERT INTO seh_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Iye akhapfundzisa n'nyumba za kuphembera, anthu onsene mbakhansimba. ");
INSERT INTO seh_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yezu aenda ku Nazareti kudakula iye. Ntsiku ya Sabudu, Iye apita n'nyumba ya kumphembera ninga nsambo wace. Penepo, Iye alamuka toera kuona pidalembwa mu Bukhu ya Mulungu. ");
INSERT INTO seh_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Na tenepo, Yezu apasiwa bukhu ya mporofeta Izaiya. Aifungula, mbagumana mbuto ikhadalembwa tenepa: ");
INSERT INTO seh_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Nzimu wa Mbuya uli na ine, thangwi iye andidzoza toera ndilonge Mphangwa Zadidi kuna anyakucherenga. Iye andituma toera ndikhadziwise adamangwa kuti asudzulwa, pontho kuti madzimola akwanise kuona, na kuombola anyakupondererwa. ");
INSERT INTO seh_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Pontho na kudziwisa caka ca ntsisi za Mbuya.” ");
INSERT INTO seh_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Na tenepo, afunga Bukhu mbaibweza pontho kuna nyabasa wa mwenemu, mbakhala pyace pantsi. Onsene akhali mu nyumba ya kumphembera atoma kumulang'anisa. ");
INSERT INTO seh_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Penepo, Yezu atoma kuapanga kuti: “Lero pyasimbiswa ipi pidamala imwe kubva m'Bukhu ya Mulungu.” ");
INSERT INTO seh_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Onsene atoma kunsimba Yezu mbakhadzumatirwa na mafala ace adidi akhabuluka pa mulomo pace, mbwenye akhabvundza kuti: “Kodi siye unowu tayu mwana wa Zuze?” ");
INSERT INTO seh_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Na tenepo, Yezu aapanga kuti: “Ndimo mwene, imwe munati mundilongere nsanje unalonga kuti: ‘Iwe nkondzi, kondzeka wekha. Citambo muno n'dziko mwako, pire pidabva ife kuti wapicita mu Kafaranaumi.’” ");
INSERT INTO seh_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yezu athimiza pontho mbalonga kuti: “Ndimo mwene ndisakupangani kuti: Nkhabe mporofeta m'bodzi anatambirwa mwadidi ku dziko kwace.” ");
INSERT INTO seh_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ndimo mwene, ndinakudziwisani kuti: “Pa midzidzi ya Eliya, akhalipo akazi azinji adaferwa na amuna awo mu dziko ya Izaraeli, caka cidaoneka cilala cidamala pyaka pitatu na hafu, mbakuoneka njala ikulu n'dziko yonsene. ");
INSERT INTO seh_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Apo nkhabe nkazi m'bodzi adaferwa na mamuna wace wa ku Izaraeli, adatumirwa Eliya. Mbwenye iye atumiwa kwenda ku dziko inango kuna nkazi m'bodzi basi adaferwa na mamuna wace, wa ku Sarapeta, ku cisa ca Sidhoni. ");
INSERT INTO seh_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Pontho akhalipombo anyamatanya azinji ku Izaraeli pa midzidzi ya mporofeta Elizeu, mbwenye nkhabe m'bodzi wawo adawangiswa. Adadza kawangiswa ndi Namani basi wa ku dziko ya Sirya.” ");
INSERT INTO seh_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Anthu onsene akhali n'nyumba ya kuphembera, aipirwa pikulu na kubva penepyo. ");
INSERT INTO seh_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Na tenepo, anthu onsene alamuka mbanthamangisa mu nzinda, mbankwata mpaka padzulu pa phiri pakhadamangwa nzinda unowu, toera am'bhomere pantsi. ");
INSERT INTO seh_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mbwenye Yezu apita na pakati pawo mbaenda pyace. ");
INSERT INTO seh_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Na tenepo, Yezu aenda ku Kafaranaumi ku nzinda wa Galileya, mbatoma kupfundzisa mbumba ntsiku ya Sabudu. ");
INSERT INTO seh_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Anthu onsene akhadzumatirwa na kupfundzisa kukhacita Yezu, thangwi akhalonga na utongi onsene. ");
INSERT INTO seh_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","N'nyumba ya kuphembera, akhalipo mamuna m'bodzi akhadaphatwa na Sathani, nzimu wa kuipa, mbakhakhuwa na mphambvu zonsene tenepa: ");
INSERT INTO seh_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Xi! Musafunanji na ife, Yezu wa ku Nazareti? Mwabwera kudza katifudza? Ine ndisakudziwani kuti ndimwe ani. Ndimwe wakulungama wa Mulungu. ");
INSERT INTO seh_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Penepo Yezu aupwekera nzimu wa kuipa, mbaupanga kuti: “Matama! Buluka muna munthu!” Na tenepo, nzimu wa kuipa wam'bhoma munthu pantsi, pa maso pa anthu onsene, mbubuluka m'manungo mwace, munthu mbakhonda kuphekeka. ");
INSERT INTO seh_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Onsene anthu adzumatirwa napyo mbakhalonga okha-okha tenepa: “Mafala anji enewa anatonga na Iye mizimu ya kuipa na mphambvu na utongi, iyo mbibulukadi!” ");
INSERT INTO seh_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Na tenepo, mbiri yace Yezu ikhabvekera m'pisa pyonsene pya dhuzi. ");
INSERT INTO seh_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yezu abuluka ku nyumba ya kuphembera, mbaenda ku nyumba ya Simau. Mebzala wace Simau akhadaferuka pikulu pyene. Iwo aphemba kuna Yezu kuti amphedze. ");
INSERT INTO seh_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yezu alimira nkhundu mwa ntenda, akotama mbapwekera nthenda, iyo mbinsiya. Pa n'dzidzi ubodzi-bodzi ntenda alamuka, mbatoma kuaphatira basa. ");
INSERT INTO seh_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Mukhadoka dzuwa, mbumba ikhadzesa onsene akhakhala na nthenda zawo za kusiyana-siyana, kuna Yezu. Penepo Iye akhaawangisa na kuaikha manja m'bodzi na m'bodzi. ");
INSERT INTO seh_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Pontho, anthu azinji akhabuluka mizimu ya kuipa, mbikhakhuwa tenepa: “Iwe ndiwe Mwana wa Mulungu!” Mbwenye Yezu akhaipwekera mbakhaikhondesa kulonga, thangwi iyo ikhadziwa kuti Iye ndi Kirixtu. ");
INSERT INTO seh_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pidaca kunja Yezu abuluka mbaenda kakhala kutsanga ekha ene. Apo mbumba yatoma kunsaka. Mudafika iwo pakhakhala Iye, ankakamiza kuti akhonde kuasiya. ");
INSERT INTO seh_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mbwenye Yezu aapanga tenepa: “Pisafunika kuti ine ndiendembo kamwaza Mphangwa Zadidi za Umambo wa Mulungu m'mizinda inango.Thangwi ndipyo pidatumirwa Ine.” ");
INSERT INTO seh_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Na tenepo, Yezu akhaenda basi mbalonga Mphangwa Zadidi m'manyumba a kuphembera a dziko ya Djudeya. ");
INSERT INTO seh_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ntsiku ibodzi Yezu akhali dhuzi na pa gombe ya nyanza ikulu ya Galileya. Penepo mbumba ikhapfinyana toera kubva fala ya Mulungu. ");
INSERT INTO seh_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yezu aona mabote mawiri m'madzi, dhuzi na gombe, akhadasiyiwa na anyakokota. Anacinthu akhadabuluka kwenda katsuka makokota awo. ");
INSERT INTO seh_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Na tenepo, Yezu apakira m'bote ibodzi ikhali ya Simau, mbaphemba Simau kuti abhome pang'ono bote yace pa nyanza. Mwenemu, Yezu akhala nawa na matako mbatoma kupfundzisa mbumba. ");
INSERT INTO seh_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pidamala Yezu kupfundzisa, apanga Simau kuti: “Kwata bote yako uyende pakati pa boo. Penepo, iwe na andzako gwisirani makokota anu.” ");
INSERT INTO seh_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Apo Simau atawira tenepa: “Mpfundzisi, ife taphata basa masiku onsene, nkhabe nyama ibodzi idaphata ife. Mbwenye thangwi ndimwe adandipanga, ndinaagwisira.” ");
INSERT INTO seh_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Pidagwisira iwo makokota awo m'madzi, aphata nyama zizinji, za kuti makokota akhatoma kupanduka. ");
INSERT INTO seh_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Na tenepo, iwo acita cizindikiro ca kucemera andzawo akhali m'bote inango, toera adze kaaphedze. Iwo andzawo abwera mbadzaza mabote mawiri ene na nyama, mpaka kufikira dhuzi na kufuna kulobzeka. ");
INSERT INTO seh_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simau Pedhru na kuona pyonsene ipi pidacitika, agodama pa myendo pa Yezu mbalonga tenepa: “Mbuya, thaukani pana ine thangwi ndine munthu wa kudawa.” ");
INSERT INTO seh_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Thangwi Simau na anango akhali na iye pabodzi, akhadzumatirwa na ntengo wa nyama za m'madzi zikhadapha iwo. ");
INSERT INTO seh_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Tiyago na Juwau, ana a Zebhedheu, ale akhali andzace Simau, adzumatirwambo. Na tenepo, Yezu ampanga Simau kuti: “Leka kugopa! Kutomera lero mpaka kutsogolo, iwe unati ukhale nyakokota wa anthu.” ");
INSERT INTO seh_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Penepo, amuna awa akwewa mabote awo mbaatsamisa pa gombe, mbasiya pyonsene mbatowera Yezu. ");
INSERT INTO seh_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yezu pikhakhala Iye mu nzinda ubodzi, agwanda mamuna m'bodzi wakudzala na matanya m'manungo monsene. Nyamatanya pidaona iye Yezu, agodama patsogolo pace mbafikisa nkhope yace pantsi, mbamphemba tenepa: “Mbuya, mungafuna munandiwangisa!” ");
INSERT INTO seh_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yezu afuthula nkono wace, ankhuya mbalonga tenepa: “Ande Ine ndisafuna. Iwe wawanga.” Pa n'dzidzi ubodzi-bodzi, matanya amala. ");
INSERT INTO seh_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Na tenepo, Yezu ampanga kuti: “Bvesera! Leka kupanga munthu penepi. Mbwenye ndoko kuna nyantsembe toera akudinkhe. Ungamala ndoko ukhapereke ntsembe idalonga Mozesi, toera kupangiza anthu onsene kuti iwe wawangadi.” ");
INSERT INTO seh_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mbwenye mbiri yace Yezu ikhamwazikiratu m'mbuto zonsene. Na tenepo, anthu azinji akhabwera kamubva na kuwangiswa nthenda zawo. ");
INSERT INTO seh_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mphapo Yezu akhabuluka mbaenda n'thando kwenda kaphembera. ");
INSERT INTO seh_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ntsiku ibodzi, pikhapfundzisa Yezu, akhalipo penepo afarisi na anyakudziwisa a mwambo akhabuluka m'pisa pyonsene pya ku Galileya, pya ku Djudeya na pya ku Djerusalema, mbakhakhala pantsi. Apo mphambvu za Mbuya zikhakhala na Yezu toera kuwangisa nthenda. ");
INSERT INTO seh_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Amuna anango angasi adzesa mamuna m'bodzi nyanfutete pa khangala, mbakhasaka kuti apite naye n'nyumba toera amuikhe patsogolo pa Yezu. ");
INSERT INTO seh_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Mbwenye iwo acimwana kupita naye n'kati, na thangwi ya mwinji wa anthu. Na tenepo, akwira naye pa ntsoyi, mbanchitisa na pa benga na khangala yace ene, mpaka pakati pa mwinji wa anthu, patsogolo pa Yezu. ");
INSERT INTO seh_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yezu na kuona cikhulupiriro ca amuna awa, ampanga nyampfutete kuti: “Mamunawe, kudawa kwako kwalekererwa!” ");
INSERT INTO seh_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Apo anyakudziwisa a mwambo na afarisi atoma kudungunya mbalonga tenepa: “Kodi mbanimbo mamuna unowu anaxola Mulungu tenepa? Nkhabe munthu anakwanisa kulekerera kudawa. Mulungu basi ndiye ana mphambvu zenezi.” ");
INSERT INTO seh_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Mphapo Yezu na kudziwa pire pikhanyerezera iwo aatawira, mbaapanga tenepa: “Thangwi yanji imwe musanyerezera penepyo m'mitima mwanu? ");
INSERT INTO seh_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ninji pinanentsa maka? Kulonga kuna ntenda kuti: ‘Kudawa kwako kwalekelerwa’ peno kumpanga kuti: ‘Lamuka uyende?’ ");
INSERT INTO seh_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mbwenye dziwani kuti, Ine Mwana wa Munthu, ndina mphambvu pantsi pano za kulekerera kudawa. Penepo ampanga nyampfutete kuti: ‘Lamuka. Kwata khangala yako, ndoko ku nyumba kwako.’” ");
INSERT INTO seh_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Pa n'dzidzi ubodzi ene, iye alamuka pa maso pa anthu onsene, mbakwata khangala yace, mbaenda ku nyumba mbakhapasa mbiri Mulungu. ");
INSERT INTO seh_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Onsene adzumatirwa napyo. Na kugopa konsene apasa mbiri Mulungu mbalonga tenepa: “Lero taona pinthu pya kudzumisa!” ");
INSERT INTO seh_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pakumala penepo Yezu abuluka mbaona mamuna m'bodzi nyakukumbusa misonkho, akhacemerwa Levi. Iye akhakhala nawa pa mbuto ikhapimirwa misonkho. Penepo Yezu ampanga kuti: “Nditowere.” ");
INSERT INTO seh_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi alamuka mbasiya pyonsene, mbantowera. ");
INSERT INTO seh_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Na tenepo, Levi, ancitira Yezu phwandu ikulu kakamwe ku nyumba kwace. Penepo akhalipombo anyamisonkho, na anthu anango azinji, mbakhadya nawo. ");
INSERT INTO seh_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mbwenye afarisi na ale anyakudziwisa a mwambo a nsoka wawo, akhadungunya kuna anyakupfundza a Yezu, mbalonga tenepa: “Thangwi yanji imwe musadya mbamumwa pabodzi na anyakukumbusa misonkho, na anango anthu anyakudawa?” ");
INSERT INTO seh_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Apo Yezu aatawira tenepa: “Angumi nkhabe kufuna nkondzi, mbwenye atenda. ");
INSERT INTO seh_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ine sidadza kacemera anyakulungama tayu, mbwenye ndadzera anyakudawa kuti achunyuke.” ");
INSERT INTO seh_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Na tenepo, iwo ampanga Yezu kuti: “Kazinji kene anyakupfundza a Juwau Bhatixta asaphembera na kupimana ca kudya. Sawa-sawambo na anyakupfundza a afarisi. Mbwenye anu nkhabe. Asadya mbamwa pyawo.” ");
INSERT INTO seh_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Mbwenye Yezu aapanga tenepa: “Pisacitika kuti adacemerwa ku phwandu ya banja, apimane ca kudya mwali wa mamuna mbali nawo pabodzi? ");
INSERT INTO seh_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mbwenye zinafika ntsiku zinafuna kukwatirwa iwo mwali wa mamuna pakati pawo. Ntsiku zenezo iwo anati apimane ca kudya!” ");
INSERT INTO seh_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yezu alonga pontho nsanje na mafala awa: “Nkhabe munthu anagwanda phindi ibodzi ya nguwo ipsa toera aikhe cigamba pa nguwo ya kale. Angacita penepyo anaibvunga nguwo ipsa. Pontho phindi ya cigamba cipsa, nkhabe kukhala mwadidi pa nguwo ya kale. ");
INSERT INTO seh_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Pontho nkhabe munthu anaikha vinyu ipsa n'nkhali za kale. Angacita penepyo, nkhali zinamala kusweka, vinyu inataika pontho, nkhali mbizibvungika. ");
INSERT INTO seh_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Na tenepo, pisafunika kuti vinyu ipsa, iyikhwe n'nkhali zipsa. ");
INSERT INTO seh_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Pontho nkhabe munthu anamala kumwa vinyu ya kale mbakomerwa na vinyu ipsa, thangwi asalonga tenepa: ‘Vinyu ya kale ndiyo yadidi kakamwe.’” ");
INSERT INTO seh_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ntsiku ibodzi ya Sabudu, mukhapita Yezu na pa minda ya tirigu, anyakupfundza ace atoma kupuruza tirigu, mbakhaiting'inda na manja awo, mbakhadya. ");
INSERT INTO seh_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Na tenepo, afarisi anango abvundzisa mbalonga kuti: “Thangwi yanji imwe musacita pire pinakhondeswa kucita ntsiku ya Sabudu?” ");
INSERT INTO seh_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yezu aatawira kuti: “Imwe mudaona tayu pidalembwa m'bukhu na thangwi pidacita Dhavidhi pidabva iye njala, pabodzi na andzace? ");
INSERT INTO seh_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Iye apita n'Nyumba ya Mulungu, akwata mikate ya ntsembe, aidya mbaipasambo andzace. Apo penepyo ndi pinthu pinakhondesiwa na mwambo wathu. Thangwi anatawirirwa kudya mikate eneyo mbanyantsembe basi.” ");
INSERT INTO seh_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Na tenepo, Yezu aapanga kuti: “Ine Mwana wa Munthu Ndine anatonga Sabudu.” ");
INSERT INTO seh_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nsabudu inango, Yezu apita n'nyumba ya kuphembera mbatoma kupfundzisa. Mwenemu mukhali na mamuna m'bodzi akhadalamala manja ace a nkono wa madyo. ");
INSERT INTO seh_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Afarisi na anyakudziwisa a mwambo, akhasaka thangwi ya kupambazira nayo Yezu. Na tenepo, akhamulang'anisa, toera amuone ngakhala Iye anamuwangisa ntsiku ya Sabudu. ");
INSERT INTO seh_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mbwenye Yezu akhadziwa manyerezerero awo. Na tenepo, apanga mamuna akhadalamala manja kuti: “Lamuka, bwera ukhale dzololo pakati apa.” Iye alamuka mbakhala dzololo. ");
INSERT INTO seh_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Penepo Yezu aapanga kuti: “Ine ndisafuna ndikubvundzeni ici: Ndi ninji pinatawirirwa na mwambo kucita ntsiku ya Sabudu? Kucita udidi, peno kucita kuipa? Kupulumusa munthu peno kunsiya mbafa?” ");
INSERT INTO seh_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Na tenepo, Yezu alang'ana onsene akhali nkhundu mwace, mbampanga mamuna kuti: “Fungula manja ako.” Iye afungula manja ace, manja mbawanga. ");
INSERT INTO seh_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mbwenye anthu aipirwa pikulu kakamwe, mbatoma kuketesana okha-okha na kusaka kuti ndi ninji pinafuna iwo kuncita Yezu. ");
INSERT INTO seh_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pa ntsiku zenezo, Yezu akwira pa phiri kwenda kaphembera. Penepo, akhala masiku onsene mbakhaphembera Mulungu. ");
INSERT INTO seh_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pidaca kunja, Yezu acemera anyakupfundza ace, mbasankhula khumi na awiri pakati pawo. Enewa, Yezu aathula atumwi. Iwo madzina awo mbawa: ");
INSERT INTO seh_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simau, adapasa Iye dzina ya Pedhru, na Andereya m'bale wace Pedhru, Tiyagu na Juwau, Filipi na Bharatolomeu, ");
INSERT INTO seh_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateu na Tomee, Tiyagu mwana wa Alufeu, Simau nyakutowerera mwambo wa Mulungu, ");
INSERT INTO seh_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Djuda mwana wa Tiyagu, pontho na Djuda Xikariyote, ule adasandukira Yezu. ");
INSERT INTO seh_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yezu achita pa phiri pabodzi pene na iwo, mbalimira pa mbuto ya kusoweka makata. Penepo akhalipo anyakupfundza ace azinji, na mwinji wa anthu akhabuluka mu Djudeya monsene, mu Djerusalema na anthu akhali dhuzi na gombe ya Tiru na ya Sidhoni. ");
INSERT INTO seh_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Iwo akhadabwera kuna Yezu toera kudza kamubva na kukondziwa nthenda zawo. Ale akhanentseka na mizimu ya kuipa akhawangiswambo. ");
INSERT INTO seh_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Anthu onsene akhasaka kunkhuya, thangwi mphambvu zikhabuluka muna Yezu zikhawangisa onsene. ");
INSERT INTO seh_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yezu alang'ana anyakupfundza ace mbaapanga kuti: “Anyakutsandzaya ndimwe anyakucherenga, thangwi Umambo wa Mulungu. ndi wanu. ");
INSERT INTO seh_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Anyakutsandzaya ndimwe muna njala cincino, thangwi munati mukhute. Anyakutsandzaya ndimwe muna lira cincino, thangwi munati museke. ");
INSERT INTO seh_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Anyakutsandzaya ndimwe, mungaidwa, mungathamangiswa, mungatikanwa, pontho na kulongwa kuti ndimwe anthu a kuipa, na thangwi ya Ine Mwana wa Munthu. ");
INSERT INTO seh_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Tsandzayani mbamukomerwa pikulu kakamwe ntsiku eneyi, thangwi kudzulu mwakoyerwa muwoni wanu ukulu kakamwe. Thangwi a mbuya awo anthu enewa acitambo pibodzi-bodzi kuna aporofeta.” ");
INSERT INTO seh_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Mbwenye muna nyatwa imwe apfumi, thangwi mwamala matamiswa kale. ");
INSERT INTO seh_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Muna nyatwa imwe mudakhuta cincino, thangwi munati mukhale na njala. Muna nyatwa imwe munaseka cincino, thangwi munati mubulire mbumulira. ");
INSERT INTO seh_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Muna nyatwa imwe, mungasimbwa na anthu onsene, thangwi ambuya awo asimbambo aporofeta a uthambi. ");
INSERT INTO seh_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Mbwenye ine ndisakupangani imwe munandibva kuti: “Funani anyamalwa anu, citirani udidi kuna ale anakuzondani. ");
INSERT INTO seh_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Acitireni udidi ale anakupasani dzedze, phembererani ale anakucitani kuipa. ");
INSERT INTO seh_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Munthu anakumenya khundu ibodzi ya nkhope, mpasembo khundu inango. Munthu anakukwatira kapoti wako, nsiye akukwatirembo na kamiza ene ya m'bwalo. ");
INSERT INTO seh_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Onsene anakuphemba cinthu apase. Pontho munthu anakukwatira cako leka kumphemba kuti akubwezere. ");
INSERT INTO seh_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Citirani andzanu pyonsene pire pinafuna imwe kuti iwo akucitirenimbo. ");
INSERT INTO seh_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ngakhala imwe musafuna basi ale anakufunani, ndi muwoni wanji unadikhira imwe kutambira kuna Mulungu? Thangwi anyakudawa asafunambo ale anaafuna. ");
INSERT INTO seh_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Pontho ngakhala imwe musacita udidi kuna ale basi anakucitani udidi, ndi muwoni wanji unadikhira imwe kutambira kuna Mulungu? Thangwi anthu anyakudawa asacitambo sawa-sawa. ");
INSERT INTO seh_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Pontho, ngakhala imwe musabwerekesa ale basi anadikhira imwe kuti iwo anadza kakubwerezerani, ndi muwoni wanji unadikhira imwe kutambira kuna Mulungu? Thangwi anyakudawa asabwerekesanambo, mbadikhira kuti abwezerwe pyonsene. ");
INSERT INTO seh_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Mphapo funani anyamalwa anu, acitireni udidi, muabwerekese mbamukhonda kudikhira kubwezerwa cinthu. Na tenepo, muwoni wanu unadza kakhala ukulu, pontho imwe munadza kakhala ana a Mulungu wa nkulu kakamwe, thangwi Iye ndi wadidi kuna ale anakhonda kucita takhuta na anyakuipa mitima. ");
INSERT INTO seh_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Khalani anthu a ntsisi ninga Baba wanu ndi wa ntsisi. ");
INSERT INTO seh_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Lekani kutonga andzanu, tenepa imwe nkhabe kudza katongwa na Mulungu. Lekani kukonesa andzanu, na tenepo imwe nkhabe kudza kakoneswa na Mulungu. Lekererani andzanu, tenepa imwe munadza kalekererwambo na Mulungu. ");
INSERT INTO seh_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pasani andzanu, tenepa Mulungu anadza kakupasanimbo, na n'dida wadidi, wakukhomerwa mbautsindirwa, pontho wa kudzala na mubvu. Thangwi na n'dida ubodzi-bodzi unapimira imwe andzanu, Mulungu anakupimiranimbo unowu.” ");
INSERT INTO seh_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Pontho Yezu alonga nsanje uyu: “Kodi pisacitika dzimola na dzimola kuphatana nsenzi? Pingacitika, onsene nkhabe kudza kagwa n'djenje? ");
INSERT INTO seh_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nkhabe nyakupfundza anapita mpfundzisi wace. Mbwenye iye nyakupfundza, angamala kupfundzambo pyonsene mwadidi, anakhala sawa-sawa na mpfundzisi wace. ");
INSERT INTO seh_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Thangwi yanji usalang'ana cirombo cing'ono ciri n'diso mwa m'bale wako, mbukhonda kuona nkhuni iri n'diso mwako?” ");
INSERT INTO seh_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Unakwanisa tani kupanga m'bale wako kuti: “M'bale, ndisiye ndikubuluse cirombo ciri n'diso mwako, ngakhala iwe nkhabe kwanisa kuona nkhuni iri n'diso mwako? Nyauthambi! Cakutoma bulusa nkhuni iri n'diso mwako. Na tenepo, ungamala, unaona mwadidi toera kubulusambo cirombo ciri n'diso mwa m'bale wako. ");
INSERT INTO seh_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Nkhabe muti wadidi unabala misapu ya kuipa. Sawa-sawambo na muti wa kuipa, nkhabe kubala misapu yadidi. ");
INSERT INTO seh_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Thangwi miti yonsene isadziwika na misapu yace. Nkhabe kucitika kuti munthu achode malembe, pa miti ya minga, peno mauva pa psepse. ");
INSERT INTO seh_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Munthu wadidi, asalonga pinthu pyadidi pidakoya iye mu ntima mwace. Munthu wa kuipa, asalonga pinthu pya kuipa pidakoya iye mu ntima mwace.Thangwi mulomo wace usalonga pire pidadzala mu ntima mwace. ");
INSERT INTO seh_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Thangwi yanji imwe musandicemera ‘Mbuya, Mbuya’ mbamukhonda kucita pinalonga Ine? ");
INSERT INTO seh_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ine ndinakupangizani mbani adalandana na ule anabwera kuna ine, mbabva mafala anga na kuacita. ");
INSERT INTO seh_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Iye alandana na mamuna m'bodzi adamanga nyumba yace pamwala. Akumba madjenje akuzika, mbaikha nchici. Madzi adzala mbamenya nyumba, mbwenye iyo hidatekenyeka tayu, thangwi ikhadamangwa mwadidi. ");
INSERT INTO seh_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mbwenye ule anabva mafala anga mbakhonda kuacita, alandana na mamuna adamanga nyumba yace mbakhonda kuikumbira mwadidi na kuiyikha nchici. Na tenepo, madzi pidamenya iwo nyumba ire, iyo yagwa, mbifudzikiratu yonsene.” ");
INSERT INTO seh_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yezu pidamala iye kulonga penepyo kuna mbumba, apita mu nzinda wa Kafaranaumi. ");
INSERT INTO seh_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mu nzinda unowu mukhali na nkulu m'bodzi wa anyankhondo a mu dziko ya Roma, akhali na nyabasa wace akhafuna iye kakamwe. Nyabasa unowu akhadwala pikulu kakamwe, dhuzi na kufuna kufa. ");
INSERT INTO seh_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Iye nkulu wa anyankhondo pidabva iye na thangwi ya Yezu, atuma atsogoleri a kuphembera a madjuda kuti aende kaphemba Yezu, toera abwere kamuwangisira nyabasa wace. ");
INSERT INTO seh_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Atsogoleri a madjuda pidafika iwo kuna Yezu amphemba na kudembetera mbankakamiza kuti: “Ndimo mwene. Mamuna uyu asafunika mumphedze. ");
INSERT INTO seh_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Thangwi asafuna dziko yathu, pontho atimangira nyumba yathu ya kuphembera.” ");
INSERT INTO seh_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Na tenepo, Yezu aenda na iwo. Mbwenye pidafika iye dhuzi na nyumba, nkulu wa anyankhondo atuma axamwali ace angasi kuna Yezu na mphangwa izi: “Mbuya, lekani kunentseka.Thangwi Ine sine munthu kuti ndikutambireni n'nyumba mwanga. ");
INSERT INTO seh_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Pontho sine munthu kuti ine ndionane na imwe nkhope na nkhope. Mbwenye longani fala ibodzi basi, nyabasa wanga anawanga. ");
INSERT INTO seh_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Thangwi Ine ndiri nawombo atsogoleri anga anabverene. Inembo ndisabverwa na anyankhondo anga. Na tenepo, ndisapanga nyankhondo wanga m'bodzi kuti: Ndoko kule, iye asaenda. Unangombo mbandimpanga kuti: Bwera kuno, iye asabwera. Pontho ndisapanga nyabasa wanga kuti: Cita ici, iye asacita.” ");
INSERT INTO seh_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yezu adzumatirwa pikulu na kubva penepyo. Penepo azungunuka kuna mbumba ikhantowera mbaipanga kuti: “Ine ndisakupangani kuti cipo ndidzati kuona munthu ana cikhulupiriro cikulu ninga ici, muno mu Izaraeli!” ");
INSERT INTO seh_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Na tenepo, amuna akhadatumwa abwerera kwenda ku nyumba, mbagumana nyabasa awanga. ");
INSERT INTO seh_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pa kupita n'dzidzi pang'ono, Yezu aenda ku nzinda ubodzi unacemerwa Naimi, pabodzi na anyakupfundza ace na mbumba ikulu ya anthu. ");
INSERT INTO seh_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Mukhapita Yezu dhuzi na nsuwo ukulu wa nzinda, mwinji wa anthu ukhabulukambo na mwana wa kufa kwenda naye ku masiye. Mwana unowu akhali m'bodzi basi wa nkazi adaferwa na mamuna wace. ");
INSERT INTO seh_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mbuya pidaona iye manferwa, ambvera ntsisi ikulu kakamwe, mbampanga kuti: “Leka kulira.” ");
INSERT INTO seh_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Penepo, Yezu aifendedzera dhuzi baulu mbaikhuya, anthu akhatembeta baulu mbalimira. Na tenepo, Yezu alonga kuna nyakufa kuti: “Iwe mphale, lamuka!” ");
INSERT INTO seh_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Penepo mphale akhala pantsi mbatoma kulonga, Yezu mbampasa mai wace. ");
INSERT INTO seh_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Anthu onsene agopserwa pikulu kakamwe, mbakhakuza Mulungu mbalonga kuti: “Xi! Lang'anani mporofeta wa nkulu adalamuka pakati pathu! Mulungu abwera kabvunulira mbumba yace.” ");
INSERT INTO seh_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Mbiri eneyi ya Yezu, yamwazika mu Djudeya monsene, na m'pisa pyonsene pya dhuzi. ");
INSERT INTO seh_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Anyakupfundza a Juwau Bhatixta ampanga pyonsene ipi. Na tenepo, Juwau Bhatixta acemera anyakupfundza awiri, ");
INSERT INTO seh_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","mbaatuma kwenda kuna Yezu kambvundzisa kuti: “Akhalongwa kuti anadza kabwera ndiwe, peno tisatongwa kudikhira unango?” ");
INSERT INTO seh_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Penepo iwo aenda, mpaka kuna Yezu, mbampanga kuti: “Juwau Bhatixta atituma toera kukubvundzani ngakhala ndimwe ene ule akhadikhirwa kufika, peno tisatongwa kudikhira unango?” ");
INSERT INTO seh_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Pa n'dzidzi unoule Yezu awangisa anthu azinji akhanenseka na pya kuipa, na nthenda zikulu, na mizimu ya kuipa, pontho akhawangisa madzimola azinji. ");
INSERT INTO seh_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Na tenepo, Yezu aatawira mbaapanga kuti: “Bwererani mukhalonge kuna Juwau, pire pidaona imwe na pidabva imwe. Madzimola ali kuona, anyakulamala ali kufamba, anyamatanya ali kuwangiswa, anakhonda kubva ali kubva, anthu a kufa ali kulamuka, pontho Mphangwa Zadidi za Mulungu zirikulongwa kuli anyakucherenga. ");
INSERT INTO seh_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mbatsandzaye ale analeka pita n'kudawa na thangwi yanga.” ");
INSERT INTO seh_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pidamala iwo kwenda anyakupfundza a Juwau, Yezu atoma kulonga kuna mbumba na thangwi ya Juwau kuti: “Kodi mwaenda kaonanji n'thando? Ntete wakutekenyeka na mphepo? ");
INSERT INTO seh_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Apo ndi ninji pidaenda imwe kaona? Mamuna wakubvalira mwadidi? Mphapo ale anabvalira mwadidi mbakhala na makhaliro adidi, anthu enewa asakhala m'manyumba mwa amambo. ");
INSERT INTO seh_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mwaenda kaonanji mphapo? Mporofeta? Ande, ine ndisakupangani kuti imwe mwaona munthu wa kupiringana mporofeta.” ");
INSERT INTO seh_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Thangwi uyu ndi ule akhalongwa m'malemba a m'Bukhu ya Mulungu kuti: “Ndinatuma ntumwi wanga patsogolo pako, toera akusasanyire njira.” ");
INSERT INTO seh_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Pontho Yezu athimiza na kulonga kuti: “Pakati pa anthu onsene adabaliwa na nkazi, nkhabe nkulu wa kupiringana Juwau. Mbwenye ule anakhala ng'ono mu Umambo wa Mulungu, unowu ndiye nkulu kupiringana Juwau.” ");
INSERT INTO seh_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Pontho mbumba yonsene, na ale ene anyakukumbusa misonkho akhadatambira batixmu na Juwau, mudabva iwo mafala a Yezu, adzindikira kuti njira ya Mulungu ndi ya kulungama. ");
INSERT INTO seh_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mbwenye afarisi na anyakudziwisa a mwambo apikhonda pire pikhafuna Mulungu kuna iwo, mbakhonda kutambiriswa batixmu na Juwau. ");
INSERT INTO seh_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Na thangwi eneyo Yezu athimiza pontho mbalonga kuti: “Kodi ndinaalandanisa na ani anthu a ntsiku zino? Anthu enewa alandana na ani?” ");
INSERT INTO seh_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Iwo anthu enewa alandana na ana ang'ono akhakhala nawa-nawa pa mphambano mbakhakhuwa kuna andzawo kuti: “Ife takuimbirani citoliro, mbwenye imwe mwakhonda kubvina. Takuimbirani nyimbo za paciriro, mbwenye imwe mwakhonda kulira.” ");
INSERT INTO seh_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Thangwi abwera Juwau Bhatixta akhapimana ca kudya na kukhonda kumwa vinyu. Mbwenye imwe mwalonga kuti iye ana nzimu wa kuipa. ");
INSERT INTO seh_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ndabwerambo Ine Mwana wa Munthu ndisadya mbandimwa, mbwenye imwe musalonga kuti: “Lang'anani mamuna uyu! Ndi wa kudyesa na wa kumwesa! Pontho ndi xamwali wa anyakukumbusa misonkho na anyakudawa.” ");
INSERT INTO seh_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Mbwenye udziwisi wa Mulungu, usadziwika na anyakupfundza ace onsene. ");
INSERT INTO seh_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nfarisi m'bodzi acemera Yezu toera aende kadya naye. Yezu aenda ku nyumba kwa nfarisi, mbakhala pa thando toera adye. ");
INSERT INTO seh_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mu nzinda unowu akhalipo nkazi m'bodzi wa mbiri ya kuipa. Apo pidapibva iye kuti Yezu ali kudya ku nyumba kwa nfarisi, aendambo kweneko na ntete wace wa mafuta a kudzola, akununkhira. ");
INSERT INTO seh_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Penepo nkazi akhala kunduli kwa Yezu, mbakhamulirira pa myendo pace. Iye atoma kuntotesa myendo yace na misozi. Pidamala iye penepo mbaipukuta misozi na tsisi yace, mbatoma kumpsompsona myendo, mbakhaidzodza mafuta. ");
INSERT INTO seh_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nfarisi akhadacemera Yezu, na kuona pyonsene ipi, atoma kulonga ekha na mu ntima mwace kuti: Mamuna uyu mbadakhaladi mporofeta, mbadandziwa nkazi unowu anan'gwedza kuti ndi nyakudawa. ");
INSERT INTO seh_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Penepo Yezu ampanga nfarisi kuti: “Simau, ndisafuna kukupanga pinthu.” Apo Simau antawira kuti: “Longani Mpfundzisi.” ");
INSERT INTO seh_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yezu alonga tenepa: “Akhalipo amuna awiri akhadakwata mangawa kuna munthu m'bodzi. Mamuna m'bodzi akwata mangawa a ntengo a madzana maxanu a mbondo. Unango akhadakwata mbondo makumaxanu. ");
INSERT INTO seh_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Mbwenye pakati pawo nkhabe m'bodzi akhali na kobiri yakukwanira kuti alipe nayo mangawa. Na thangwi eneyo mwanacinthu kobiri aalekerera mangawa onsene, muwiri mwawo mwene. Apo pa awiri awa, mbani anadza kafuna maka-maka mwanacinthu kobiri?” ");
INSERT INTO seh_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Penepo Simau antawira kuti: “Ine kuona kwanga, ndisanyerezera kuti ndi ule akhali na mangawa makulu.” Apo Yezu antawira kuti: “Ande, wanyerezera mwadidi.” ");
INSERT INTO seh_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Na tenepo, Yezu azungunuka kuna nkazi, mbapanga Simau kuti: “Usamuona nkazi uyu? Ine ndapita n'nyumba mwako, iwe wacimwana kundipasa madzi kuti nditsuke nawo myendo yanga. Mbwenye iye anditsuka na misozi yace, pontho mbandipukuta na tsisi yace. ");
INSERT INTO seh_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Pidafika Ine, iwe wacimwana kundimpsompsona. Mbwenye iye nkhabe kupuma tayu na kundimpsompsona myendo yanga, kutomera n'dzidzi udapita Ine muno. ");
INSERT INTO seh_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Iwe wacimwana kundidzoza mafuta munsolo mwanga, mbwenye iye andidzoza myendo yanga na mafuta akununkhira. ");
INSERT INTO seh_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Na tenepo, Ine ndisakupanga kuti kufuna kukulu kudapangiza iye, kusapangizambo kuti kudawa kwace kuzinji kwalekererwa. Mbwenye munthu analekererwa pang'ono mafuniro ace mbakucepambo.” ");
INSERT INTO seh_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Penepo Yezu ampanga nkazi kuti: “Kudawa kwako kwalekererwa.” ");
INSERT INTO seh_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Apo anthu ale akhadya na iye pabodzi pa thando, atoma kulonga okha-okha kuti: “Mbanimbo unowu analekerera na kudawa kwene?” ");
INSERT INTO seh_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mbwenye Yezu ampanga nkazi kuti: “Kukhulupira kwako kwakupulumusa. Ndoko na ntendere!” ");
INSERT INTO seh_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pakumala penepo, Yezu akhafamba nzinda na nzinda, cisa na cisa, kwenda mbalonga Mphangwa zadidi za Umambo wa Mulungu. Anyakutumwa ace khumi na awiri akhaenda nawo pabodzi. ");
INSERT INTO seh_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Pa nsoka unowu akhalipombo akazi anango akhadawangiswa nthenda zawo za mizimu ya kuipa na nthenda zinango. Akazi enewa mbawa: Mariya, anacemerwa Madhalena, ule akhadabulusiwa na Yezu mizimu minomwe ya kuipa. ");
INSERT INTO seh_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Na Juwana, nkazace Kuza, ule akhali nyabasa wa nkulu wa utongi wa mambo Herodhi, Suzana, na akazi anango azinji. Akazi enewa, akhaphedza Yezu na anyakupfundza ace ene, na mpfuma zawo. ");
INSERT INTO seh_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Anthu azinji a mizinda ya kusiyana-siyana akhabwera kuna Yezu. Penepo Yezu atoma kulonga nsanje uyu: ");
INSERT INTO seh_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Mamuna m'bodzi abuluka kwenda kabzala mbeu m'munda mwace. Pikhawaza iye, mbeu zinango zagwera njira. Mwenemu izo zapwandiwa mbazidzonkhonwa na mbalame. ");
INSERT INTO seh_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Mbeu zinango zagwera padzulu pa myala. Na tenepo, pidatoma izo kumera, zauma na thangwi ya kusoweka ntota. ");
INSERT INTO seh_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mbeu zinango zagwera pakati pa minga, zakula pabodzi mbizimala kudyiwa na minga. ");
INSERT INTO seh_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mbwenye mbeu zinango zagwera pa mataka a ndimo. Izo zakula mbazibala misapu dzana pa mbeu ibodzi.” Penepo Yezu athimiza na kulonga kuti: “Ana makutu a kubva mbabve!” ");
INSERT INTO seh_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Anyakupfundza ace Yezu ambvundzisa kuti: “Usalongeranji nsanje unowu?” ");
INSERT INTO seh_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Apo Yezu aatawira tenepa: “Kuna imwe, Mulungu afuna kuti akudziwiseni pinthu pyakubisala pya Umambo wace. Mbwenye anango asapangiwa na misanje. Penepyo toera kuti iwo aone mbakhonda kuonesesa, abve mbakhonda kubvesesa.” ");
INSERT INTO seh_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Nsanje uyu usalongera ipi: “Mbeu ndi fala ya Mulungu. ");
INSERT INTO seh_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mbeu idagwa m'bale mwa njira, ndi anthu anabva fala ya Mulungu, mbwenye asabwera Sathani mbabulusa fala m'mitima mwawo toera akhonde kutawira Mulungu mbacimwana kupulumuswa. ");
INSERT INTO seh_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mbeu idagwa padzulu pa myala ndi ale anabva fala ya Mulungu mbaitambira na kukomerwa. Mphapo na thangwi ya kusoweka michici, asakwanisa kutawira pa n'dzidzi ung'ono basi. Mbwenye pa n'dzidzi wa kuleserwa, asasiya pyonsene. ");
INSERT INTO seh_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mbeu idagwa pakati pa minga, ndi ale anabva fala ya Mulungu, mbwenye pakumala ntsiku pang'ono, asabwerera na thangwi ya makhaliro a padziko, na mpfuma, na udidi wa pa dziko. Na tenepo, misapu inabala iwo, nkhabe tokota. ");
INSERT INTO seh_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mbeu idagwa pa mataka a ndimo, ndi anthu anabva fala ya Mulungu mbaikoya na ntima wadidi na wakunyindirika. Na tenepo, anthu enewa asabala misapu na kupirira.” ");
INSERT INTO seh_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Nkhabe munthu anagasa nyale, angamala mbaigudumira na citomba, peno mbaiyikha pantsi pa talimba. Mbwenye isaiyikha pa mbuto ya kuti anthu onsene anapita aone cieza. ");
INSERT INTO seh_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Thangwi pyonsene pidabiswa pinati pioneke. Pontho pyonsene piri n'cibiso-biso pinati pidziwike na kupangizika pa kweca. ");
INSERT INTO seh_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Na tenepo, lang'anani mbamucita mphole-mphole na mabvero anu a pinthu penepyo.Thangwi ule anapyo, anati apaswe pontho pinango. Mbwenye ule adasowa pinthu, anabulusirwa na pire pyene pinanyerezera iye kuti anapyo. ");
INSERT INTO seh_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mai wace na abale ace Yezu aenda kaonana naye, mbwenye akhacimwana kunfendedzera dhuzi, na thangwi ya mwinji wa anthu. ");
INSERT INTO seh_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Na tenepo, munthu m'bodzi aenda kampanga Yezu kuti: “Mai wanu na abale anu ali kunja uku, asafuna kuonana na imwe.” ");
INSERT INTO seh_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Mbwenye Yezu atawira mbalonga kuti: “Mai wanga na abale anga ndi ale anabva fala ya Mulungu, mbacita pinalonga iyo.” ");
INSERT INTO seh_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ntsiku inango Yezu apita m'bote pabodzi na anyakupfundza ace, mbaapanga tenepa: “Tendeni ntunda unango wa nyanza.” Na tenepo, iwo aenda. ");
INSERT INTO seh_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Pikhawambuka iwo nyanza, Yezu aphatwa na citulo mbagona. Penepo caoneka conzi cikulu n'nyanza, anthu mbakhafuna lobzeka, thangwi bote ikhadzala na madzi. ");
INSERT INTO seh_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Na tenepo, anyakupfundza ace Yezu anfendedzera dhuzi mbamulamusa, mbampanga kuti: Mpfundzisi, Mpfundzisi, tiri kufa ife! Yezu alamuka mbalonga kuna mphepo na kuna conzi kuti pimatame. Pyonsene pyamatama. ");
INSERT INTO seh_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Penepo Yezu aapanga anyakupfundza ace kuti: “Kukhulupira kwanu kuli kupi?” Mbwenye iwo akhadadzumatirwa, mbagopa, mbakhalonga okha-okha kuti: “Ndianimbo mamuna unowu ana mphambvu za kutonga mphepo na mabimbi ene, pyonsene mbapimbvera?” ");
INSERT INTO seh_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Buluka penepo Yezu na anyakupfundza ace awambuka mbafika pa cisa ca Djeraza, cikhalang'anisana na Galileya ku ntunda unango wa nyanza. ");
INSERT INTO seh_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yezu mudachita iye m'bote, abwera kuna Iye mamuna m'bodzi wa mu nzinda unowu, akhadadzala na mizimu ya kuipa. Iye akhala ntsiku zizinji mbali cipezi-pezi, pontho akhakhonda kukhala pa nyumba, mbwenye akhakhala m'masiye. ");
INSERT INTO seh_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Mamuna unowu pidaona iye Yezu, akhuwa mbagwa patsogolo pace, mbalonga na mphambvu kuti: “Yezu, Mwana wa Mulungu wa nkulu! Musafunanji imwe Mbuya na ine? Ndisaphemba mukhonde kundithabusa!” ");
INSERT INTO seh_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Iye alonga penepyo, thangwi Yezu akhadaupanga nzimu wa kuipa kuti ubuluke muna mamuna ule. Kazinji kene nzimu wa kuipa ukhamphata mamuna uyu, mpaka kufikira mangiwa myendo na mikono ene na unyolo. Mbwenye mamuna uyu akhauthumula basi unyolo, nzimu wa kuipa mbukhankwata kwenda naye kutali na anthu. ");
INSERT INTO seh_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Na tenepo, Yezu ambvundza kuti: “Kodi iwe dzina yako ndiwe ani?” Iye atawira kuti: “Dzina yanga ndine mwinji.” Thangwi akhali na mizimu mizinji m'manungo mwace. ");
INSERT INTO seh_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Apo iyo mizimu ya kuipa ikhaphemba Yezu kuti akhonde kuiyendesa n'djenje ya cidima. ");
INSERT INTO seh_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Penepo pa dhuzi ukhalipo nkumbi ukulu wa nkhumba ukhasodza pa phiri. Mizimu ya kuipa yaphemba Yezu kuti aisiye ipite m'manungo mwa nkumbi wa nkhumba. Yezu aitawirira kuti ipite. ");
INSERT INTO seh_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Mizimu ire yabuluka muna mamuna, mbipita muna nkumbi wa nkhumba. Penepo izo zatoma kuthamanga mbizichitira pa phiri mpaka kugwera n'nyanza, mbizifa zonsene m'madzi. ");
INSERT INTO seh_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Apo akumbidzi a nkhumba na kuona pyonsene ipi pidacitika, athawa mbaenda mbalonga mphangwa zenezi mu nzinda na m'pisa. ");
INSERT INTO seh_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Na tenepo, mbumba yaenda ku mbuto eneyi kwenda kaona pikhadacitika. Pidafika iwo dhuzi na Yezu, aona kuti mamuna ule akhadabuluswa mizimu ya kuipa ali nawa nkhundu mwa Yezu, amala bvala nguwo, pontho mbali na ndzeru zace zakubaliwa. Na kupiona, iwo agopserwa napyo. ");
INSERT INTO seh_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ale adapyona, alonga kuna mbumba kuwangiswa kudacitwa mamuna akhali na mizimu ya kuipa. ");
INSERT INTO seh_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Na tenepo, mbumba yonsene ya pa cisa ca Djeraza yaphemba Yezu kuti abuluke pa cisa ceneci, thangwi iwo akhagopa pikulu kakamwe. Penepo, Yezu apita m'bote mbaenda pyace. ");
INSERT INTO seh_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mamuna akhadabuluswa mizimu ya kuipa akhaphemba Yezu kuti aende naye pabodzi. Mbwenye Yezu am'bweza mbampanga kuti: ");
INSERT INTO seh_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Bwerera ku nyumba kwako ulonge pire pyonsene pidakucitira Mulungu.” Na tenepo, mamuna aenda mu nzinda onsene kwenda mbalonga pire pyonsene pidancitira Yezu. ");
INSERT INTO seh_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pakubwerera kwace Yezu, anthu azinji antambira na kukomerwa, thangwi akhan'dikhira. ");
INSERT INTO seh_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Na tenepo, afika mamuna m'bodzi anacemerwa Djairo. Iye akhali ntsogoleri wa nyumba ya kumphembera. Apo iye agwa patsogolo pa Yezu mbamphemba pikulu kuti aende naye ku nyumba kwace. ");
INSERT INTO seh_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Thangwi mwana wace m'bodzi basi wa nkazi, akhathamangira pyaka khumi na piwiri pya kubaliwa, akhali dhuzi na kufuna kufa. Apo Yezu mukhaenda iye, akhaenda mbapfinyana na mwinji wa anthu. ");
INSERT INTO seh_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Pakati pa anthu enewa afikambo nkazi m'bodzi akhali na utenda wakubuluka ciropa pa pyaka khumi na piwiri. Iye akhadabvunga pyonsene pikhali na iye kuna anyakukondza, mbwenye nkhabe munthu m'bodzi akhadankwanisa kumuwangisa. ");
INSERT INTO seh_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Apo nkazi aenda n'nduli mwa Yezu mbankhuya nguwo zace. Penepo pene ciropa casiya kubuluka, iye mbawangiratu. ");
INSERT INTO seh_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Penepo Yezu abvundzisa kuti: “Mbani adandikhuya?” Onsene akhonda. Apo Pedhru antawira mbalonga kuti: “Mpfundzisi, ndi anthu adadzala, anapfinyana na imwe.” ");
INSERT INTO seh_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mbwenye Yezu athimiza na kulonga kuti: “Alipo adandikhuya. Thangwi ndisabva mphambvu zanga zabuluka muna ine.” ");
INSERT INTO seh_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Na tenepo, nkazi na kuona kuti aoniwa, acimwana kubisa. Abwera na kutetemera kuna Yezu, mban'gwera patsogolo pace, mbalonga pa maso pa anthu onsene, thangwi yanji ankhuya pontho na kuwangiswa kwa nthenda yace pa n'dzidzi ubodzi ene. ");
INSERT INTO seh_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Penepo Yezu ampanga kuti: “Mwananga, kukhulupira kwako kwakuwangisa. Ndoko na ntendere.” ");
INSERT INTO seh_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yezu mbadzati kumalisira kulonga, afika mwanankate m'bodzi wa ku nyumba ya Djairo, mbalonga kuti: “Mwana wanu wa nkazi afa. Lekani kunsanyabve Mpfundzisi.” ");
INSERT INTO seh_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yezu pidabva iye penepyo apanga Djairo ntsogoleri wa nyumba ya kuphembera, kuti: “Leka kugopa. Khulupira basi, mwana wako ana pulumuka.” ");
INSERT INTO seh_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yezu pidafika iye ku nyumba kwa Djairo, akhondesa anthu kupita na iye n'nyumba. Mbwenye atawirisa kupita na Pedhru na Juwau na Tiyagu basi ene, pontho na baba na mai wa mwana. ");
INSERT INTO seh_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Onsene akhali penepo, akhalira mbakhakhuwa na thangwi ya mwana. Mbwenye Yezu aapanga kuti: “Lekani kulira. Mwana hadafa tayu, ali kugona.” ");
INSERT INTO seh_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Penepo onsene atoma kunseka, thangwi iwo akhapidziwa kuti mwana akhadafadi. ");
INSERT INTO seh_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mbwenye Yezu amphata manja ace mwana, mbampanga na kukhuwa kuti: “Ntsikana, lamuka!” ");
INSERT INTO seh_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Penepo ntsikana apulumuka mbalamukiratu. Na tenepo, Yezu apanga anthu kuti ampase ca kudya. ");
INSERT INTO seh_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Baba wace na mai wace mwana adzumatirwa napyo pikulu. Mbwenye Yezu aapanga kuti akhonde kupanga munthu pire pidacitika. ");
INSERT INTO seh_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yezu acemera atumwi ace khumi na awiri, mbaapasa mphambvu na utongi wa kuthamangisa mizimu yonsene ya kuipa, pontho na kuwangisa nthenda. ");
INSERT INTO seh_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Na tenepo, aatuma kwenda mbalonga Umambo wa Mulungu na kuwangisa atenda. ");
INSERT INTO seh_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Penepo aapanga kuti: “Pa ulendo wanu lekani kukwata cinthu tayu ninga: mpsimbo, budu, ca kudya, peno kobiri. Pontho lekani kukwata nguwo ziwiri. ");
INSERT INTO seh_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","N'nyumba inapita imwe, khalani mwenemu mpaka buluka kwanu. ");
INSERT INTO seh_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mungakhonda kutambirwa mu nzinda unapita imwe, pa kubuluka kwanu mwenemu gubudzani pfumbi ya m'myendo mwanu, ninga cidzindikiro ca kuapangiza kuti pidacita iwo mphya kuipa.” ");
INSERT INTO seh_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Na tenepo, iwo abuluka mbaenda m'pisa na m'pisa mbalonga Mphangwa Zadidi, na kuwangisa atenda mbuto zonsene. ");
INSERT INTO seh_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Mambo Herodhi, ntongi wa Galileya abva mbapilongwa pyonsene pikhacitika, pontho akhakhala wakudzudzumika, thangwi anango akhalonga kuti Juwau Bhatixta alamuka pa akufa. ");
INSERT INTO seh_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Anango akhalonga kuti ndi Eliya akhadaonekera. Anangombo ndiwo akhalonga kuti ndi m'bodzi wa aporofeta akale akhadalamuka pa kufa. ");
INSERT INTO seh_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mbwenye Herodhi alonga kuti: “Juwau, ine ndan'gwandisa nsolo. Mphapo ndi ani mamuna unowu anabva ine mbalongwa na thangwi ya pinthu penepi?” Pontho Herodhi akhafuna kuona Yezu. ");
INSERT INTO seh_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Pakubwerera kwa anyakutumwa a Yezu, alonga kuna Iye pyonsene pidacita iwo. Na tenepo, Yezu aakwata mbaenda nawo ku nzinda unacemerwa Bhetisaidha, ");
INSERT INTO seh_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mbwenye mwinji wa anthu na kubva penepyo atoma kutowera Yezu. Iye aatambira mbakhaapanga pya Umambo wa Mulungu na kuwangisa nthenda za ale akhafuna kuwangiswa. ");
INSERT INTO seh_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pikhadoka dzuwa, anyakupfundza khumi na awiri a Yezu aenda kuna iye mbampanga kuti: “Asiyeni anthu awa aende pyawo, toera akwanise kwenda m'pisa na mbuto zinango za pa dhuzi, kuti akhasake ca kudya na pakukhala. Thangwi muno ndi n'thando.” ");
INSERT INTO seh_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mbwenye Yezu aatawira kuti: “Apaseni ndimwe anthu ca kudya.” Apo iwo antawira tenepa: “Pano ife tina mikate mixanu, na nyama ziwiri basi za m'madzi. Peno tiagulire ndife anthu onsene awa ca kudya.” ");
INSERT INTO seh_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Akhalipo penepo amuna akhathamangira ku pikwi pixanu.) Mbwenye Yezu aapanga anyakupfundza kuti: “Igaweni mbumba muikhalise pantsi nsoka-nsoka wa makumaxanu wa anthu.” ");
INSERT INTO seh_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Anyakupfundza acita ninga mudapangirwa iwo, mbaikhazika mbumba yonsene pantsi. ");
INSERT INTO seh_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Penepo Yezu akwata mikate mixanu na nyama ziwiri za m'madzi, mbalang'ana kudzulu mbapereka takhuta, mbaimenya. Pakumala, aipasa anyakupfundza ace, toera iwombo aigawize mbumba. ");
INSERT INTO seh_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Penepo onsene adya mbakhuta. Pakumala anyakupfundza alokotera mapindi adasala mbadzaza nawo pitundu khumi na piwiri. ");
INSERT INTO seh_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ntsiku ibodzi Yezu akhaphembera pa khundu, pabodzi na anyakupfundza ace. Na tenepo, Yezu aabvundza kuti: “Kodi anthu asalonga kuti ine ndine ani?” ");
INSERT INTO seh_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Iwo antawira kuti: “Anango asalonga kuti imwe ndimwe Juwau Bhatixta, anango ndiwo analonga kuti ndimwe Eliya. Pontho anangombo ndiwo analonga kuti imwe ndimwe m'bodzi wa aporofeta akale adalamuka pa kufa.” ");
INSERT INTO seh_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yezu aabvundzisa pontho kuti: “Kodi imwembo musalonga kuti ine ndine ani?” Pedhru antawira kuti: “Imwe ndimwe Kirixtu adatumwa na Mulungu.” ");
INSERT INTO seh_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Na tenepo, Yezu aakhondesa kuti akhonde kupanga na munthu ene m'bodzi pinthu penepyo. ");
INSERT INTO seh_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Pontho iye athimiza na kulonga kuti: “Ine Mwana wa Munthu, ndisafunika kuti ndione nyatwa ikulu, pontho ndikhondiwe na atsogoleri aanyakuphembera, na akulu aanyantsembe na anyakudziwisa a mwambo, mbandiphiwa, pa kupita ntsiku zitatu ndinalamuka pa kufa.” ");
INSERT INTO seh_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Buluka penepo aapanga onsene kuti: “Munthu anafuna kunditowera mbakhonde kucita kufuna kwace, mbakwate ntanda wace ntsiku na ntsiku, anditowere. ");
INSERT INTO seh_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Thangwi ule anafuna kuwinika ekha ene, analuza. Mbwenye ule analuzika na thangwi yanga, anawina. ");
INSERT INTO seh_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mphapo pinaphedzera anji kuna munthu anawina dziko yonsene, iye mbamalisira kutaika peno kufudzika? ");
INSERT INTO seh_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Apo munthu anakhala na manyadzo na Ine peno na mafala anga, mbadziwe kuti Ine Mwana wa Munthu, ndinadza kakhalambo na manyadzo na iye, ndingabwera na mbiri yanga na ya Baba, na za maanju akulungama. ");
INSERT INTO seh_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ndimo mwene, ine ndisakupangani kuti alipo pano pakati panu anafuna kuona Umambo wa Mulungu, mbadzati kufa.” ");
INSERT INTO seh_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Dhuzi na kuthamangira ntsiku zisere, Yezu abuluka mbakwira pa phiri kwenda kaphembera, pabodzi na anyakutumwa ace Pedhru, Juwau na Tiyago. ");
INSERT INTO seh_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Penepo, pikhaphembera Iye, nkhope yace yaphinduka, nguwo zace zacena kakamwe mbaziyetimira. ");
INSERT INTO seh_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Na tenepo, abulukira amuna awiri mbatoma kulonga na Yezu. Akhali Mozesi na Eliya. ");
INSERT INTO seh_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Iwo abulukira na cieza ca mbiri, mbakhalonga pya thangwi ya kufa kwa Yezu, kukhafuna kusimbiswa ku Djerusalema. ");
INSERT INTO seh_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedhru na andzace akhadaphatwa na citulo. Mbwenye pidalamuka iwo aona mbiri ya Yezu, na amuna awiri akhali na iye. ");
INSERT INTO seh_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mphapo Mozesi na Eliya pikhabuluka iwo, Pedhru alonga kuna Yezu mbampanga kuti: “Mpfundzisi, mphyadidi tikhale pyathu pano! Timangeni makumbi matatu: Ibodzi yanu, ibodzi ya Mozesi, ibodzi ya Eliya.” (Apo Pedhru akhapidziwa tayu pikhalonga iye.) ");
INSERT INTO seh_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pedhru mbadzati kumala kulonga pinthu penepyo, yabwera khole ya kudzulu mbiagudumira. Penepo anyakupfundza a Yezu agopa pikulu na kuona kuti khole yaagudumira. ");
INSERT INTO seh_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Na tenepo, pa khole pabveka fala ikhalonga kuti: “Uyu ndi mwana wanga wakufunika. Mbvereni!” ");
INSERT INTO seh_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Pakubveka fala eneyo, Yezu agumanika kuti ali ekha ene. Pa midzizi eneyo anyakupfundza a Yezu apikoya mu ntima mwawo pinthu penepi, mbakhonda kupanga munthu pire pikhadaona iwo. ");
INSERT INTO seh_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mangwana mwace, pidachita iwo pa phiri, mwinji ukulu wa anthu wabwera kagumana na Yezu. ");
INSERT INTO seh_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Penepo, mamuna m'bodzi pakati pa mbumba, akhuwa kuna Yezu mbalonga kuti: “Mpfundzisi, ndisakuphembani kuti mundionerembo mwana wanga, thangwi mwana wanga ndi m'bodzi basi. ");
INSERT INTO seh_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ulipo nzimu wa kuipa unamphata. Na mwansanga iye asakhuwa mbum'bhoma pantsi, mbatoma kutatamuka na kubuluka mapobvu nkanwa. Funa kunsiya usanentsa, usansiya nkhabe mphambvu. ");
INSERT INTO seh_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ine ndaphemba anyakupfundza anu kuti aubuluse, mbwenye iwo aucimwana.” ");
INSERT INTO seh_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yezu atawira kuti: “Dzindza ya kuipa na ya kusowa cikhulupiro! Ine ndinakhala na imwe mpaka lini? Ndinakhala na imwe mbandipirira mpaka lini? Bwera naye pano mwana wako.” ");
INSERT INTO seh_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Penepo mwana pikhafika iye dhuzi, aphatwa pontho na nzimu ule wa kuipa, mbun'gwisa pantsi mbatoma kutatamuka. Mbwenye Yezu authamangisa, mbamuwangisa mwana, mbampasa baba wace. ");
INSERT INTO seh_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Na tenepo, onsene adzumatirwa nazo mphambvu zikulu za Mulungu. Pa n'dzidzi unowu ukhadzumatirwa anthu onsene na thangwi ya pinthu pikhacita Yezu, iye apanga anyakupfundza ace kuti: ");
INSERT INTO seh_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Bveserani mwadidi pinafuna ine kukupangani. Ine Mwana wa Munthu ndinati ndiperekwe m'manja mwa anthu.” ");
INSERT INTO seh_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mbwenye anyakupfundza ace akhacimwana kuabvesesa akhalongeranji mafala enewa. Iwo akhadaabisirwa toera akhonde kuabvesesa. Pontho akhagopa kumbvundzisa na thangwi ya mafala enewa. ");
INSERT INTO seh_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Anyakupfundza a Yezu atoma kuketesana okha-okha kuti adziwe ndi ani pakati pawo, nkulu wa onsene. ");
INSERT INTO seh_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Mbwenye Yezu akhapidziwa pikhanyerezera iwo mu ntima mwawo. Na tenepo, akwata mwana m'bodzi mbamulimisa n'khundu mwace, ");
INSERT INTO seh_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","mbalonga kuti: “Anatambira mwana uyu wang'ono na dzina yanga, asatambira ine. Apo ule ananditambira, asatambira ule adandituma. Thangwi ule anapicepesa pakati panu, unowu ndiye anadza kakhala nkulu kupita onsene.” ");
INSERT INTO seh_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Penepo Juwau alonga kuti: “Mpfundzisi, taona mamuna m'bodzi mbakhathamangisa mizimu ya kuipa na dzina yanu. Mbwenye ife tankhondesa kucita penepyo, thangwi iye si ndzathu tayu.” ");
INSERT INTO seh_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Na tenepo, Yezu apanga Juwau pabodzi na anyakupfundza anango kuti: “Lekani kun'khondesa. Thangwi anakhonda kukuzondani, unowu ali na imwe.” ");
INSERT INTO seh_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yezu na kuona kuti n'dzidzi wace wa kwenda kudzulu uli kufika, atonga ekha ene kwenda ku Djerusalema. ");
INSERT INTO seh_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Na tenepo, Yezu atuma anankate angasi mbaasogolesa. Iwo aenda mbafika ku cisa cibodzi ca dziko ya Samariya, toera akwanise kusasanyira mbuto yakufikira. ");
INSERT INTO seh_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mbwenye anthu a kucisa cenecire akhonda kuntambira, thangwi iwo aona kuti Yezu akhaenda ku Djerusalema. ");
INSERT INTO seh_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Apo anyakupfundza ace Yezu, Tiyago na Juwau, na kupiona penepyo, alonga mbapanga Yezu kuti: “Kodi Mbuya musafuna kuti ife titume moto wa kudzulu udze kaapise?” ");
INSERT INTO seh_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mbwenye Yezu azungunuka kuna iwo mbaasandika (kuti: “imwe nkhabe dziwa ndi nzimu wanji una imwe. Thangwi ine Mwana wa Munthu sidabwera kudza kapha anthu tayu, mbwenye toera kaapulumusa.”) ");
INSERT INTO seh_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Na tenepo, aenda ku cisa cinango. ");
INSERT INTO seh_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yezu na anyakupfundza ace pikhaenda iwo na njira, mamuna m'bodzi ampanga kuti: “Mbuya, ine ndinakutowerani mbuto zonsene zinaenda imwe.” ");
INSERT INTO seh_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Mphapo Yezu antawira tenepa: “Minyenga ina mphako zawo, mbalame za kudzulu zinantsanza zawo, mbwenye Ine Mwana wa Munthu, nkhabe pa kutsamira nsolo.” ");
INSERT INTO seh_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Penepo Yezu apanga mamuna unango kuti: “Nditowere.” Mbwenye iye antawira tenepa: “Mbuya ndisiyeni pa kutoma ndikhaikhise baba wanga.” ");
INSERT INTO seh_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Apo Yezu antawira kuti: “Siya anyakufa aikhane okha-okha. Mbwenye iwe ndoko ukhalonge Umambo wa Mulungu.” ");
INSERT INTO seh_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Apo unangombo alonga tenepa: “Mbuya, ine ndinakutowerani. Mbwenye pa kutoma ndisiyeni ndikhapangane abale anga.” ");
INSERT INTO seh_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Mphapo Yezu antawira kuti: “Munthu onsene anatoma kulima na ng'ombe mbalang'ana n'nduli, unowu nkhabe kufunika mu Umambo wa Mulungu.” ");
INSERT INTO seh_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Buluka penepo, Mbuya athonya anyakupfundza ace anango makumanomwe na awiri, mbaatuma patsogolo pace kuti aende awiri-awiri, m'mizinda na m'pisa mukhafuna kupita iye. ");
INSERT INTO seh_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yezu aapanga tenepa: “Pyakubvuna pyainjipa, mbwenye anyabasa acepa. Na thangwi eneyi, phembani kuna mwanacinthu munda, kuti atume anyabasa toera adze kabvune.” ");
INSERT INTO seh_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ndokoni! Ine ndisakutumani ninga mabira pakati pa mibindzi. ");
INSERT INTO seh_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Lekani kukwata cikhwama, peno malikofa, peno ntsapato. Pontho lekani kulimira n'jira mbamumwanyikana na anthu. ");
INSERT INTO seh_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Mungapita n'nyumba, pa kutoma longani tenepa: “Ntendere mbukhale pa nyumba ino.” ");
INSERT INTO seh_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ngakhala mwenemu muna munthu wa ntendere, nsiyireni ntendere wanu. Mbwenye ngakhala nkhabemo munthu wa ntendere, kwatani pyanu ntendere wanu. ");
INSERT INTO seh_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Khalani nyumba ibodzi ene. Dyaani, mbamumwa pire pinapaswa imwe. Thangwi nyabasa asafunika atambiriswe. Lekani kucinja cinja nyumba. ");
INSERT INTO seh_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Mungapita mu nzinda mbamutambirwa mwadidi, dyaani pire pinakupasani iwo. ");
INSERT INTO seh_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Wangisani atenda anagumanika mu nzinda unowu, mbamuapanga anthu a mwenemu kuti: “Umambo wa Mulungu uli dhuzi na imwe.” ");
INSERT INTO seh_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mbwenye mungapita mu nzinda mbamukhonda kutambirwa mwadidi, ndokoni na m'miseu mikulu yonsene mbamulonga tenepa: ");
INSERT INTO seh_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Na pfumbi ene ya nzinda iri m'myendo mwathu ife tinakugubudzirani! Mbwenye dziwani kuti Umambo wa Mulungu uli dhuzi!” ");
INSERT INTO seh_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yezu athimiza na kulonga pontho kuti: “Ine ndisakupangani kuti, ntsiku inadza katongwa anthu, Mulungu anadza kacepesa nyatwa zikhafuna pasa iye nzinda wa Sodhoma, kupiringana nzinda unowu.” ");
INSERT INTO seh_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Unanyatwa iwe nzinda wa Korazini! Unanyatwa iwe nzinda wa Bhetisaidha. Thangwi pirengo pidacitika mwenemu, mbapidacitika m'mizinda ya Tiru na Sidhonya, anthu a mizinda eneyi mbadachunyuka kale cino kudawa kwawo, mbabvala masakha, mbakwata dotha mbadzola. ");
INSERT INTO seh_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mbwenye ntsiku inadza katongwa anthu, Mulungu anadza kakhala na ntsisi zikulu na Tiru na Sidhonya, kupiringana imwe Korazini na Bhetisaidha! ");
INSERT INTO seh_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Iwembo nzinda wa Kafaranaumi, usanyerezera kuti unakwira mpaka kudzulu? Nkhabe. Unati uponyiwe n'djenje ya anyakufa! ");
INSERT INTO seh_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ule anakubverani, ali kubvera ine. Ule anakukhondani, asakhonda ine. Ulembo anandikhonda, asakhonda ule adandituma. ");
INSERT INTO seh_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Anyakupfundza makumanomwe na awiri ale, abwera kuna Yezu na kukomerwa pikulu kakamwe, mbalonga tenepa: “Mbuya, na dzina yanu, na mizimu ene ya kuipa ikhatibverambo!” ");
INSERT INTO seh_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yezu aapanga kuti: “Ine ndaona Sathani mbakhabuluka kudzulu mbagwa pantsi ninga njazi. ");
INSERT INTO seh_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Lang'anani. Ine ndakupasani mphambvu za kuponda nyoka na makong'a, na za kukunda nazo mphambvu zonsene za nyamalwa. Nkhabe cinakwanisa kukucitani kuipa. ");
INSERT INTO seh_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mphapo lekani kukomerwa na thangwi ya kukubverani kunacita mizimu ya kuipa. Mbwenye komerwani thangwi madzina anu alembwa kudzulu.” ");
INSERT INTO seh_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Pa n'dzidzi unowu, Yezu atsandzaya mu Nzimu wa Mulungu mbalonga tenepa: “Ndisapereka takhuta kuna imwe Baba, Mbuya wa kudzulu na pantsi! Thangwi mwapangiza kuna ale adakhonda kupfundza, pire pidabisira imwe anyakudziwisa na anyakupfundza, mbumupipangiza ana ang'ono. Ande Baba, penepyo pyacitika na kufuna kwanu. ");
INSERT INTO seh_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Pinthu pyonsene ndapipaswa na Baba wanga. Ndiye Baba basi anandziwa Mwana, nkhabe unango anandziwa. Babambo, nkhabe munthu unango anandziwa. Anandziwa ndi Mwana basi, na ale anafuna Iye kuti andziwe.” ");
INSERT INTO seh_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Na tenepo, Yezu azungunuka kuna anyakupfundza ace, mbalonga na iwo okha basi kuti: “Mbatsandzaye ale anakwanisa kuona pire pinaona imwe! ");
INSERT INTO seh_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ndisakupangani kuti aporofeta azinji, na amambo azinji, akhafuna kuti apyonembo penepi pinaona imwe, mbwenye apicimwana. Pontho akhafunambo kuti abvembo pinabva imwe ipi, mbwenye acimwana kupibva.” ");
INSERT INTO seh_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nyakudziwisa m'bodzi wa mwambo akhafuna kulesera Yezu, alamuka mbambvundza kuti: “Mpfundzisi, ndisafuna ndicitenji toera ndikhale na upulumuki wakukhonda kumala?” ");
INSERT INTO seh_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yezu atawira tenepa. “Ndi ninji pidalembwa mu Mwambo wa Mulungu? Iwembo usapyona tani?” ");
INSERT INTO seh_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Mamuna atawira tenepa: “Funa Mbuya Mulungu wako, na ntima wako onsene, na upulumuki wako onsene, na mphambvu zako zonsene, na ndzeru zako zonsene. Pontho ufune ndzako ninga iwe ene.” ");
INSERT INTO seh_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yezu ampanga tenepa: “Ndimwe mwene. Watawira mwadidi. Cita penepyo, unapulumuka.” ");
INSERT INTO seh_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mbwenye nyakudziwisa wa mwambo, na kufuna kumpangiza udziwisi wace, ambvundza tenepa: “Mbani ndzanga?” ");
INSERT INTO seh_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yezu antawira kuti: “Mamuna m'bodzi akhabuluka ku Djerusalema mbaenda ku Djeriko. Pikhaenda iye na njira, aphatwa na mapanga. Iwo an'dula nguwo zace, am'menya, mbansiya akomoka. ");
INSERT INTO seh_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Pa n'dzidzi unowu nyantsembe m'bodzi akhabwerambo na njira ibodzi-bodzi. Mudamuona iye, ancalira mbaenda pyace. ");
INSERT INTO seh_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Sawa-sawambo na mamuna m'bodzi wa dzindza ya Levi, apitambo na penepo. Amulang'ana, ancalirambo mbaenda pyace. ");
INSERT INTO seh_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Mbwenye mamuna m'bodzi wa ku Samariya akhapitambo na njira eneyo, afika mpaka penepo. Mudamuona iye ambvera ntsisi. ");
INSERT INTO seh_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Anfendedzera dhuzi, mbantsuka pironda pyace na mafuta na vinyu mbapimanga na nguwo. Buluka penepo, anthukula mbampakiza pa buru yace, mbaenda naye mpaka pa nyumba ya kufikira alendo, mbansasanya mwadidi.” ");
INSERT INTO seh_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Mangwana mwace, abulusa kobiri ziwiri za parata, apasa mwanacinthu nyumba, mbampanga tenepa: “Ndionerenimbo mamuna uyu. Mungadza kabvunga kobiri inango ya kupiringana iyi na thangwi yace, ndinadza kakubwezerani ndingabwerera.” ");
INSERT INTO seh_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Penepo, Yezu ambvundza nyakudziwisa wa mwambo kuti: “Kuona kwako, mbani ndzace mamuna uyu adaphatwa na mapanga, pa utatu wawo apa?” ");
INSERT INTO seh_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Iye atawira kuti: “Ndi ule adambvera ntsisi.” Yezu ampanga tenepa: “Iwembo ndoko kacita pibodzi-bodzi.” ");
INSERT INTO seh_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yezu na anyakupfundza ace apitiriza na ulendo wawo, mbafika pa cisa cibodzi padatambirwa iwo pa nyumba ya nkazi m'bodzi anacemerwa Marta. ");
INSERT INTO seh_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","M'bale wace Marta anacemerwa Mariya, akhakhala pa myendo ya Mbuya mbakhabvesera mafala ace. ");
INSERT INTO seh_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mbwenye Marta akhazunguzika na basa izinji ya pa nyumba. Na tenepo, afedza dhuzi na Yezu mbambvundza kuti: “Kodi Mbuya, muli kuona tayu kuti m'bale wanga ali kundisiyira ndekha basa? Mpangeni adze kandimphedzembo.” ");
INSERT INTO seh_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Penepo Yezu antawira tenepa: “Marta! Marta! Iwe uli kunentseka mbupingizika na pinthu pizinji. ");
INSERT INTO seh_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Mbwenye cinafunika ndi cibodzi basi. Mariya asankhula cinthu cadidi. Cinthu ceneci nkhabe anafuna kunkwatira.” ");
INSERT INTO seh_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ntsiku inango Yezu akhaphembera pa mbuto ibodzi. Pidamala Iye, nyakupfundza wace m'bodzi amphemba mbalonga kuti: “Mbuya, tipfundzisenimbo kuphembera, ninga pidacita Juwau Bhatixta apfundzisa anyakupfundza ace.” ");
INSERT INTO seh_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yezu antawira kuti: Mungafuna kuphembera, phemberani tenepa: “Baba, dzina yanu mbikhale na mbiri. Mbubwere Umambo Wanu. ");
INSERT INTO seh_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tipaseni ca kudya cinafuna ife ca ntsiku zonsene. ");
INSERT INTO seh_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tilekerereni kudawa kwathu, thangwi ifembo tisalekerera onsene ale anatidawisira. Pontho lekani kutisiya mbatigwa n'kudawa.” ");
INSERT INTO seh_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Na tenepo, Yezu alonga kuna anyakupfundza ace kuti: “Lang'anani, ngakhala m'bodzi wanu aenda ku nyumba kwa xamwali wace pa chitichiti ya masiku, mbamphemba kuti: ‘Xamwali, ndibwerekembo mikate mitatu, ");
INSERT INTO seh_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","thangwi ndafikirwa na xamwali wanga m'bodzi mulendo, apo ine nkhabe cinthu ca kumpasa.’ ");
INSERT INTO seh_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Mphapo ndiye tani xamwali wace mbantawira n'kati mwa nyumba mbalonga kuti: ‘Leka kundinyangula! Nsuwo wamala fungwa, ine na ananga tiri kugona. Na tenepo, nkhabe kwanisa kuti ine ndilamuke, toera ndikupase mikate.’ ");
INSERT INTO seh_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ine ndisakupangani kuti: ‘Munthu uyu angakhonda kulamuka toera kumpasa nkate thangwi ndi xamwali wace, mbwenye na thangwi ya kun'nyangula kunacita xamwali wace, anati alamuke mbampasa pyonsene pinafuna iye.’ ");
INSERT INTO seh_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Na thangwi ya ipyo, ndisakupangani kuti: ‘Phembani, munapasiwa. Sakani, munapigumana. Menyani nsuwo, munanfungulirwa. ");
INSERT INTO seh_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Thangwi ule anaphemba anapaswa. Ule anasaka, anapigumana. Pontho ule anamenya nsuwo anafungulirwa.’ ");
INSERT INTO seh_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Mbani pakati panu, baba m'bodzi anapasa mwana wace nyoka, angamphemba nyama ya m'madzi? ");
INSERT INTO seh_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Peno kong'a, angaphemba dzai? ");
INSERT INTO seh_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ngakhala imwe anthu a kuipa musakwanisa kupasa ana anu pinthu pyadidi, ndiye tani Baba wanu wa kudzulu? Iye anakwanisambo kupasa Nzimu wa Mulungu kuna ale anauphemba.” ");
INSERT INTO seh_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yezu akhathamangisa nzimu wa kuipa muna munthu wa bewewe. Pidabuluka nzimu wa kuipa, mamuna atoma kulonga, mbumba yonsene mbidzumatirwa. ");
INSERT INTO seh_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mbwenye anango alonga tenepa: “Ndi Bhelizebhu, nkulu wa mizimu ya kuipa, anampasa mphambvu mamuna uyu, za kuthamangisa mizimu ya kuipa.” ");
INSERT INTO seh_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Anango, toera kumulesera Yezu, amphemba kuti acite cirengo cinapangiza kuti ana mphambvu za kudzulu. ");
INSERT INTO seh_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mbwenye Yezu na kudziwa manyerezero awo aapanga kuti: “Umambo onsene ungagawika okha-okha, unamalisira kufudzika. Sawa-sawa na mudzi, ungagawika okha-okha, unamalisirambo kufudzika. ");
INSERT INTO seh_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Mphapo Sathani angagawika ekha, umambo wace unakhala tani na mphambvu? Ndisalonga penepi thangwi imwe musalonga kuti ine ndisathamangisa mizimu ya kuipa na mphambvu za Bhelizebhu. ");
INSERT INTO seh_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ngakhala ine ndisathamangisa mizimu ya kuipa na mphambvu za Bhelizebhu, ana anu asaithamangisa na mphambvu za ani? Na thangwi eneyi iwo anati akutongeni. ");
INSERT INTO seh_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mbwenye ngakhala ine ndisathamangisa mizimu ya kuipa na mphambvu za Mulungu, penepi pisapangiza kuti Umambo wa Mulungu wafika kuna imwe. ");
INSERT INTO seh_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Mamuna angakhala na mphambvu pontho mbakhala na piphano, mbaonera nyumba yace, pinthu pyace pyonsene pinakoyeka mwadidi. ");
INSERT INTO seh_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mbwenye angafikirwa na munthu unango wa mphambvu zikulu kupita iye, mbankunda, anampokosera piphano pyace pyonsene pikhanyindira iye, mbagawa pinthu pyonsene pidam'bera iye. ");
INSERT INTO seh_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Anakhonda kukhala na ine, asandizonda. Apo ule anakhonda kundiphedza kugumanya, asamwaza. ");
INSERT INTO seh_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Nzimu wa kuipa ungabuluka muna munthu, usaenda mbundzendza-ndzendza n'thando, toera usake pa kupuma.Tenepa, angakhonda kuigumana mbuto eneyo, usalonga kuti: ‘Ndina bwerera kwenda ku nyumba kwanga kudabuluka ine.’ ");
INSERT INTO seh_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Iwo ungafika usagumana nyumba yamala kupsairwa na kusasanyirwa mwadidi. ");
INSERT INTO seh_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Na tenepo, unabuluka mbuenda kakwata mizimu inango minomwe ya kuipa kakamwe kupiringana iye, mbiyenda yonsene kakhala mwenemu. Penepo makhaliro ace munthu ule, anakhala a kuipa kakamwe kupiringana makhaliro ace a kutoma.” ");
INSERT INTO seh_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yezu pidamala Iye kulonga penepyo, nkazi m'bodzi akhali pakati pa mbumba, akhuwa mbalonga kuti: “Mbatsandzaye nkazi adakubala na adakuyamwisa!” ");
INSERT INTO seh_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Mbwenye Yezu antawira kuti: “Anthu akutsandzaya kakamwe ndi ale anabva fala ya Mulungu, mbaikoya.” ");
INSERT INTO seh_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Pidagumanyikana mbumba, Yezu atoma kulonga tenepa: “Anthu a ntsiku zino mbakuipa! Asaphemba cizindikiro ca cirengo. Mbwenye nkhabe cizindikiro cinango cinafuna iwo kuona, cakupiringana cirengo ca mporofeta Djona.” ");
INSERT INTO seh_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Thangwi sawa-sawa ninga mporofeta Djona akhali cidzindikiro ca Mulungu kuli mbumba ya ku nzinda wa Ninivi, Inembo Mwana wa Munthu, ndinakhalambo cidzindikiro kuli anthu a ntsiku zino. ");
INSERT INTO seh_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ntsiku ya kutongwa kwa anthu, mambo wa nkazi wa khundu ya ku bangwe anati akonese anthu a ntsiku zino. Thangwi iye abwera mbabulukira kutali toera kudza kabva udziwisi wa Salomau. Mphapo ine ndisakupangani kuti munthu ali pano, ndi nkulu kakamwe kupita Salomau. ");
INSERT INTO seh_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Pontho ntsiku ya kutongwa kwa dziko ya pantsi pano, Mbumba ya ku Ninivi inalamuka mbikukoneswani. Thangwi iwo achunyuka kudawa kwawo, pidabva iwo mphangwa za Mulungu na Djona. Mphapo Ine ndisakupangani kuti munthu ali pano, ndi nkulu kakamwe kupita Djona. ");
INSERT INTO seh_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yezu athimiza pontho mbalonga kuti: “Nkhabe munthu anagasa nyale mbaiyikha pa kubisala, peno mbaigudumira na combo. Mbwenye asaiyikha pa kweca, toera anthu anapita akwanise kuona. ");
INSERT INTO seh_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Maso akhala ninga nyale ya manungo. Ngakhala maso ako mbadidi, manungo onsene asakhala na cieza cikulu. Mbwenye maso angakhala mbakuipa, manungo ako onsene anakhala n'cidima. ");
INSERT INTO seh_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Na tenepo, citani mphole-mphole, kuti cieza ciri n'kati mwanu cikhonde kudza cidima. ");
INSERT INTO seh_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ngakhala manungo ako onsene adzala na cieza, pontho nkhabe khundu ibodzi ya manungo iri n'cidima, manungo enewa anayetimira mbakhala ninga asamwanikirwa na cieza ca nyale.” ");
INSERT INTO seh_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yezu pidamala Iye kulonga penepyo, nfarisi m'bodzi ankwata kuti aende kadye naye ku nyumba kwace. Yezu aenda, mbakhala pantsi toera adye. ");
INSERT INTO seh_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mbwenye nfarisi adzumatirwa, na kuona kuti Yezu hadasamba manja tayu pa kufuna kudya. ");
INSERT INTO seh_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Na tenepo, Mbuya Yezu alonga kuti: “kodi imwe afarisi, musatsuka kunja kwa khomicho na kwa mbale. Mbwenye imwe n'kati mwanu mwadzala na umbava na kuipa. ");
INSERT INTO seh_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Imwe madzemwa! Adacita kunja siye m'bodzi ene adacita n'kati tayu? ");
INSERT INTO seh_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pasani anyakucherenga pina imwe n'kati mwa mbale. Na tenepo, munaona kuti pyonsene pina imwe pinaceneswa.” ");
INSERT INTO seh_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Muna nyatwa imwe afarisi! Thangwi musapereka ca cikhumi ca n'dimba mwanu, misapu yakununkhira, na ukhaindi onsene wa masamba a kudya, mbwenye musasiya kucita pyakulungama, mbamukhonda kufuna Mulungu. Ande, citani penepyo pya kupereka ca cikhumi, mbwenye mukhonde kusiya ipi. ");
INSERT INTO seh_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Muna nyatwa imwe afarisi! Thangwi musafuna mipando ya kutoma n'kati mwa nyumba za kuphembera, pontho musafuna kumwanyikwa na kulemebza m'mphambano. ");
INSERT INTO seh_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Muna nyatwa imwe! Thangwi mwakhala ninga nthumbi za kukhonda kuoneka pa kweca, mbazipwandiwa na anthu na kukhonda kudziwa kuti pana pinthu. ");
INSERT INTO seh_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Na tenepo, nyakudziwisa m'bodzi wa mwambo, alonga kuna Yezu kuti: “Mpfundzisi, pinalonga imwe tenepa, musaxola na ife ene.” ");
INSERT INTO seh_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Penepo Yezu antawira tenepa: “Na imwe ene, anyakudziwisa a mwambo muna nyatwambo! Thangwi musakwatisa andzanu mitolo ya kulemera kakamwe, iwo mbacimwana kuikwata. Pontho imwe mbamucimwana kulamusa na cala cene cibodzi toera kuaphedza. ");
INSERT INTO seh_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Muna nyatwa imwe! Thangwi musacitira nthumbi maporofeta adaphiwa na ambuyanu. ");
INSERT INTO seh_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Na tenepo, imwe musacita umboni kuti mwapitawirira pidacita a mbuya anu. Thangwi iwo apha maporofeta, imwe mwaasasanyira nthumbi zawo.” ");
INSERT INTO seh_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Na thangwi eneyo, Mulungu na kudziwisa kwace alonga kuti: “Ndinati ndiatumire maporofeta na atumwi. Apo iwo, anango anaapha, anango anaazonda.” ");
INSERT INTO seh_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Na thangwi eneyi, anthu a ntsiku za lero anati atawirire ciropa ca maporofeta onsene adaphiwa kutomera pa kutoma kwa pantsi. ");
INSERT INTO seh_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kutomera pa kufa kwa Abheli mpaka kwa Zakariya, ule adaphiwa mu Nyumba ya Mulungu, pakati-nakati, uku ciguwa uku mbuto ya kucena. Ande ine ndisakupangani kuti mbumba ya ntsiku za lero, anati apitawirire pyonsene ipi. ");
INSERT INTO seh_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Muna nyatwa imwe, anyakudziwisa a mwambo! Thangwi musakoya cavi ca udziwisi wa Mulungu. Na tenepo, imwe nkhabe funa kupita, pontho musakhondesa andzanu kupita. ");
INSERT INTO seh_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yezu pidabuluka Iye penepo, anyakudziwisa a mwambo na afarisi atoma kumulongera na kuipirwa mbakhambvundzisa pinthu pizinji, ");
INSERT INTO seh_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","toera asake mathangwi akubuluka pa mulomo pace, akumpambazira nawo. ");
INSERT INTO seh_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Pa n'dzidzi unowu ung'ono, pikwi na pikwi pya anthu pyagumanyikana, mpaka kufikira pondana okha-okha. Na tenepo, Yezu, pa kutoma apanga anyakupfundza ace kuti: “Cenjerani na ntombwe wa kutupisa mikate wa afarisi. Penepi ndi kubveka kuti: Na uthambi wawo. ");
INSERT INTO seh_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nkhabe cinthu cidabisala cinakhonda kudza kadziwika, peno cidagudumirwa mbacikhonda kudza kaoneka. ");
INSERT INTO seh_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Thangwi pyonsene pinalonga imwe n'cibiso-biso pinadza kabveka pakweca. Na pyonsene pinalonga imwe ciwere-were n'nyumba, pinadza kalongwa pa ntsoyi.” ");
INSERT INTO seh_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yezu athimiza na kulonga kuti: “Axamwali anga, Ine ndisakupangani kuti: Lekani kugopa ale anapha manungo, angamala mbacimwana kucita pinango. ");
INSERT INTO seh_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mbwenye ine ndisakupangani ndi ani anafuna imwe kugopa. Gopani Mulungu, anacita kuti angamala kupha manungo, ana mphambvu za kuaponya mu infernu. Ande, ndinathimiza na kukupangani kuti: Gopani Mulungu!” ");
INSERT INTO seh_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Kodi nkhabe guliswa mbalame zixanu na pikobiri piwiri? Mbwenye Mulungu nkhabe ibodzi inaduwala Iye. ");
INSERT INTO seh_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Na tsisi yanu ene ya munsolo, yonsene yamala kulengeswa. Lekani kugopa. Thangwi imwe muli kufunika pikulu kakamwe kupiringana mbalame zizinji. ");
INSERT INTO seh_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yezu alonga pontho kuti: Ule anandicitira umboni pa maso pa anthu, Inembo Mwana wa Munthu, ndinancitirambo umboni pa maso pa, anju za Mulungu. ");
INSERT INTO seh_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mbwenye ule anandikhonda pa maso pa anthu, iye anadza kakhondiwambo na Mwana wa Munthu pa maso pa anju za Mulungu. ");
INSERT INTO seh_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Onsene ale anandilonga kuipa ine Mwana wa Munthu, anadza kalekererwa. Mbwenye ale anaxola Nzimu wa Mulungu, nkhabe kudza kalekererwa. ");
INSERT INTO seh_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Mungakwatiwa kwenda n'nyumba za kuphembera peno pa maso pa anyakutonga na pa akulu-akulu a utongi, lekani kunentseka kuti munaatawira tani, peno munalonga tani. ");
INSERT INTO seh_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Thangwi pa n'dzidzi unowu, Nzimu wa Mulungu unakupfundzisani pinafuna imwe kulonga. ");
INSERT INTO seh_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mamuna m'bodzi akhakhala pakati pa mbumba alonga kuna Yezu kuti: “Mpfundzisi, pangani m'bale wanga kuti ndigawane naye unthaka udatisiyira baba wathu.” ");
INSERT INTO seh_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mbwenye Yezu antawira tenepa: “Mamunawe, mbani adandisankhula kuti ndikhale ntongi wa nseru wanu, peno nyakugawa unthaka wanu?” ");
INSERT INTO seh_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Na tenepo, Yezu aapanga onsene kuti: “Bveserani. Citani mphole na kuumirwa! Thangwi upulumuki wa munthu, huli na kuinjipa kwa pinthu pyace tayu.” ");
INSERT INTO seh_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Na tenepo, Yezu aapanga nsanje uyu: “Munda wa mamuna m'bodzi m'mpfumi wabuluka phoso izinji. ");
INSERT INTO seh_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Iye atoma kunyerezera mbalonga ekha ene kuti: ‘Ndinacita tani? Ine nkhabe mbuto yakukwanisa kukoya phoso yanga yonsene.’ ");
INSERT INTO seh_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Na tenepo, iye alonga kuti: ‘Ha! Ndapidziwa pinafuna cita ine. Ndinafudza pyete pyanga pyonsene, mbandimanga pinango pikulu. Mwenemu ndinadza kakoya phoso yanga na pyonsene pina ine.’ ");
INSERT INTO seh_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ndingamala ndinalonga ndekhene kuti: ‘Iwe una pyakudya pya kuinjipa m'pyete mwako, pinakwana kuti umale napyo pyaka pizinji. Cincino puma pyako. Dya, mwa pyako, mbutsandzaya!’ ");
INSERT INTO seh_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Mbwenye Mulungu ampanga tenepa: ‘Dzemwawe!’ Masiku ano iwe unafa. Mbani mphapo anafuna sala na pyonsene pidasasanyira iwe?” ");
INSERT INTO seh_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yezu amalisira na kulonga tenepa: “Penepi ndipyo pinacitika na ale anasasanya mpfuma yawo toera aphedzeke, mbwenye pa maso pa Mulungu mbacherengi.” ");
INSERT INTO seh_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Penepo Yezu apanga anyakupfundza ace kuti: “Na tenepo, ine ndisakupangani kuti lekani kunentseka na makhaliro anu pa thangwi ya cinafuna imwe kudya, peno na manungo anu pa thangwi ya cinafuna imwe kubvala. ");
INSERT INTO seh_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Pinafunika pikulu kakamwe ndi upulumuki kupiringana ca kudya, na manungo kupiringana nguwo.” ");
INSERT INTO seh_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Lang'anani makhungubwe. Iwo nkhabe kubzala, nkhabe kubvuna, nkhabe pyete, nkhabe pikwa. Mbwenye Mulungu asaapasa ca kudya. Imwe musafunika pikulu kakamwe kupiringana mbalame! ");
INSERT INTO seh_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mbani pakati panu ananentseka na kufuna kwace mbakwanisa kuthimizira pang'ono pyaka pyace? ");
INSERT INTO seh_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mphapo ngakhala imwe nkhabe kukwanisa kucita cing'ono ici basi, thangwi yanji musanentseka na pinango? ");
INSERT INTO seh_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Lang'anani kukula kunacita maluwa: Iwo nkhabe phata basa, peno kusasanya nguwo zawo. Mbwenye ine ndisakupangani kuti Salomau, munthu wakupfuma kakamwe, hakhadabvala nguwo zakubalika ninga za luwa ibodzi iyi tayu. ");
INSERT INTO seh_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Imwe anthu akukhulupira pang'ono, ngakhala Mulungu asabvazika tenepa maluwa a munda anacita kuti lero alipo, mangwana aponyiwa pa moto, ndiye tani kuna imwe, nkhabe kudza kakubvazikani? ");
INSERT INTO seh_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Lekani kunentseka na kusaka kuti munadyanji, peno munamwanji. ");
INSERT INTO seh_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Thangwi anasaka penepi ndi ale anthu a pa dziko ino. Mbwenye imwe, Baba Wanu asadziwa pyonsene pire pinafuna imwe. ");
INSERT INTO seh_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Cakutoma sakani Umambo wa Mulungu, pyonsene ipi munadza kathimizirwa. ");
INSERT INTO seh_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yezu athimiza na kulonga kuti: “Lekani kugopa tayu imwe nkumbi ung'ono! Thangwi Baba wanu asakomerwa na kukupasani Umambo wace. ");
INSERT INTO seh_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Gulisani pyonsene pina imwe mukwate kobiri eneyi muipase anyakucherenga. Citani pikhwama pya kuti nkhabe kusakala, mbamukoya mpfuma yanu kudzulu. Kweneku iyo nkhabe kudza kamala. Thangwi kweneku mambava nkhabe kwanisa kuiba, pontho ucenje nkhabe kwanisa kuidya. ");
INSERT INTO seh_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Thangwi pana mpfuma yanu, penepo ndipo pana ntima wanu.” ");
INSERT INTO seh_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yezu athimiza pontho na kulonga kuti: “Khalani mbamudasasanyira na nyale zanu zakugaka. ");
INSERT INTO seh_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Khalani ninga anyabasa anadikhira mbuya wawo, adaenda ku phwandu ya banja, kuti angabwera mbamenya nsuwo, iwo anfungulire na mwansanga. ");
INSERT INTO seh_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mbatsandzaye ale anyabasa anagumanwa mbalan'ganira na mbuya wawo pakubwera kwace. Ndinakupangani kuti, iye ene mbuya wawo, anasasanyikambo kuti aaphatire basa. Anaapanga kuti akhale pa thando, iye mbabweresa pyakudya mbaapasira.” ");
INSERT INTO seh_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Pontho mbatsandzaye anyabasa anagumanwa mbakhalang'anira, mbuya wawo angabwera pa chitichiti peno m'bambakuca! ");
INSERT INTO seh_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Mbwenye kumbukani kuti mbidakhala mwanacinthu nyumba asaudziwa n'dzidzi unafuna kufika mbava, mbadasiya tayu kuti mbava aswe nyumba yace. ");
INSERT INTO seh_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Na imwembo, khalani mudasasanyira, thangwi Ine Mwana wa Munthu ndinafika pa n'dzidzi unakhonda imwe kudikhira. ");
INSERT INTO seh_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Na tenepo, Pedhru abvundza kuti: “Mbuya nsanje unowu musapanga ife basi, peno musapangambo anthu onsene?” ");
INSERT INTO seh_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mbuya atawira tenepa: “Mbani mphapo, nyabasa wakukhulupirika na wa ndzeru adaikhwa na mbuya wace, kuti aonerere anyabasa ace na kuapasa ca kudya n'dzidzi ungakwana?” ");
INSERT INTO seh_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mbatsandzaye nyabasa unowu anagumanwa mbaphata tenepa basa, pa kubwera kwa mbuya wace. ");
INSERT INTO seh_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ndinakupangani kuti mbuya wace anampasa cidzo ca kuonerera mpfuma yace yonsene. ");
INSERT INTO seh_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ndiye tani mphapo nyabasa uyu mbadanyerezera tenepa: “Mbuya wanga asadembuka na kubwera.” Na tenepo, mbatomba kucita kuipa anyabasa andzace amuna na akazi, mbadya mbamwa, mbaledzera pyace. ");
INSERT INTO seh_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Penepo, mbuya wace anadza kabwera ntsiku ikhakhonda iye kudikhira, pa n'dzidzi unakhonda iye kudziwa. Iye anamuonesa nyatwa ikulu mbamuikha mbuto ibodzi ene na anyakukhonda kutawira. ");
INSERT INTO seh_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ule nyabasa anadziwa ndi ninji pinafuna mbuya wace, mbwenye mbakhonda kusasanyira kuti acite pinafuna iye, anati aoneswe nyatwa na michamu mizinji. ");
INSERT INTO seh_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mbwenye ule anadodomeka na thangwi ya kukhonda kudziwa pinafuna mbuya wace, unowu anaoneswa nyatwa na michamu pan'gono basi. Anapasiwa pizinji anaphembwa pizinji. Ananyindirwa pikulu, anamphembwambo pikulu. ");
INSERT INTO seh_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yezu athimiza na kulonga kuti: “Ine ndabwera kudza kagasa moto pa dziko. Ndi pikhafuna ine kuti ugake! ");
INSERT INTO seh_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mbwenye ndisatongwa nditambire batixmu ya nyatwa. Na tenepo, ntima wanga nkhabe kukhurudzika, penepi mbapidzati kucitika! ");
INSERT INTO seh_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Imwe musanyerezera kuti ndabweresa ntendere pa dziko? Nkhabe, sidabweresa ntendere tayu, mbwenye ndabweresa phambulo. ");
INSERT INTO seh_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Thangwi kutomera lero kwenda kutsogolo, mudzi una anthu axanu, anagawana. Atatu anazondana na awiri, awiri anazondana na atatu. ");
INSERT INTO seh_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Baba anadza kazondana na mwana wace wa mamuna, mwana wa mamuna anadza kazondana na baba wace. Mai anadza kazondana na mwana wace wa nkazi, na mwanambo wa nkazi anadza kazondana na mai wace. Mebzala anadza kazondana na nkwenya wace, nkwenyambo anadza kazondana na mebzala wace.” ");
INSERT INTO seh_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yezu alongambo pontho kuna mbumba kuti: Imwe mungaona khole mbaikwira kumadokero a dzuwa, musalonga tenepa: “Lero mulungu anabvumba.” Iye asabvumbadi. ");
INSERT INTO seh_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Mungabva mphepo ya bangwe mbimenya, musalonga tenepa: “Lero kuna pisa.” Kunja mbakupisadi. ");
INSERT INTO seh_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Imwe anyauthambi! Musakwanisa kuchulula pidzindikiro pya kudzulu na pya pantsi. Mphapo ndi thangwi yanji musacimwana kuchulula pidzindikiro pya n'dzidzi uno? ");
INSERT INTO seh_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Yezu athimiza na kulonga tenepa: “Thangwi yanji imwe munakhonda dziwa mwekhene pinthu pyakulungama? ");
INSERT INTO seh_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ngakhala iwe uli kwenda katongesana na nyamalwa wako ku luwani, saka kusekesana naye n'jira, toera ndzako akhonde kukukwata kwenda nawe kuna ntongi, iyembo ntongi akupereke kuna nsupai, nsupaimbo mbakufungira n'kaidi. ");
INSERT INTO seh_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ndisakupanga kuti iwe nkhabe buluka mwenemu mbudzati kumalisa kulipa mangawa ako onsene.” ");
INSERT INTO seh_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Pa n'dzidzi unoule anthu anango abwera kuna Yezu mbampanga na thangwi ya amuna a ku Galileya, akhadaphiwa na mambo Piratu pa n'dzidzi ukhaikha iwo ntsembe kuna Mulungu. Na tenepo, ciropa cawo cabvungazikana na ciropa ca ntsembe. ");
INSERT INTO seh_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Penepo Yezu aatawira mbaapanga kuti: “Kodi imwe musanyerezera kuti magalileu awa, ndiwo adadawa pikulu kakamwe kupita magalileu anango na thangwi ya nyatwa zenezi zidaona iwo? ");
INSERT INTO seh_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Simo tayu. Mbwenye ine ndisakupangani kuti: Monsene imwe mungakhonda kuchunyuka kudawa kwanu, munafambo sawa-sawa ninga iwo. ");
INSERT INTO seh_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Peno musanyerezera kuti anthu ale khumi na asere a ku cisa ca Silowee, adafa thangwi ya kugwerwa na nyumba ya kulapha, ndiwo ana thangwi ikulu kupita onsene anango akhakhala mu Djerusalema? ");
INSERT INTO seh_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Simo tayu. Ine ndisakupangani kuti monsene imwe mungakhonda kuchunyuka, munafa sawa-sawa ninga iwo.” ");
INSERT INTO seh_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Na tenepo, Yezu alonga nsanje uyu kuti: “Mamuna m'bodzi akhali na munda wace wa mauva. Mwenemu mukhali muti ubodzi wa nsambvu. Mudaenda iye kasaka misapu ya nsambvu uyu, hadakugumanamo pinthu tayu.” ");
INSERT INTO seh_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Na thangwi eneyo apanga mamuna akhaonera munda kuti: “Pyapita pyaka pitatu mbandikhadza pano kasaka misapu pa nsambvu uyu, mbandikhonda kugumana cinthu. Thangwi yanji tisausiya mbaupatisa munda pa pezi? Ugwande pyako.” ");
INSERT INTO seh_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mbwenye nyabasa antawira kuti: “Mbuya, tomani kuusiya pontho caka cibodzi. Ine ndinaukuwirira n'khundu mwace mbandiuyikhira pinthu pyakupasa ndimu. ");
INSERT INTO seh_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ungabala caka cinafuna kudza, mphyadidi. Ungakhonda bala, munautema pyanu.” ");
INSERT INTO seh_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ntsiku ibodzi ya Sabudu, Yezu akhapfundzisa mu nyumba ya kuphembera. ");
INSERT INTO seh_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Akhalipo mwenemu nkazi m'bodzi akhadwala pa pyaka khumi na pisere, na thangwi ya nzimu wa kuipa. Iye akhafamba na kukotama mbakhacimwana kufuthula nsana wace. ");
INSERT INTO seh_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Apo Yezu pidamuona iye nkazi ancemera mbampanga kuti: “Nkaziwe, nthenda yako yawanga.” ");
INSERT INTO seh_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Na tenepo, Yezu amuikha manja, penepo pene nsana wace wadzongoka, mbatoma kukuza Mulungu. ");
INSERT INTO seh_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mbwenye ntsogoleri wa nyumba ya kuphembera aipirwa na kuona kuti Yezu awangisa munthu ntsiku ya Sabudu, mbapanga mbumba kuti: “Ziripo ntsiku zitanthatu zakuphata basa, bwerani ntsiku zenezi toera muwangiswe. Mbwenye lekani kubwera ntsiku za Sabudu.” ");
INSERT INTO seh_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Penepo Yezu antawira kuti: “Anyauthambi! Mbani pakati panu anakhonda kufungulira ng'ombe peno buru yace n'thanga ntsiku ya Sabudu, toera kwenda kaimwesa madzi? ");
INSERT INTO seh_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mphapo nkazi uyu wa dzindza ya Abharaamu adamangwa na Sathani pyaka khumi na pisere, nkhabe kukwanira kuti iye akwanise kusudzulwa nthenda yace ntsiku ya Sabudu?” ");
INSERT INTO seh_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Pakumala kulonga penepyo, anyamalwa onsene a Yezu akhala na manyadzo na kutawira kudacita Iye. Mbwenye mbumba yonsene yakomerwa na pinthu pya kudzumisa pikhacita Yezu. ");
INSERT INTO seh_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Na tenepo, Yezu alonga kuti: “Walandana nanji Umambo wa Mulungu? Ndinaulandanisa nanji? ");
INSERT INTO seh_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Walandana na mbeu ibodzi ing'ono-ng'ono, idakwatiwa na mamuna m'bodzi mbaibzala m'munda mwace. Mbeu yakula mbikhala muti, mbalame za kudzulu mbazimanga ntsandza zawo n'nthawi mwace.” ");
INSERT INTO seh_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yezu athimiza mbalonga kuti: “Ndinaulandanisa nanji Umambo wa Mulungu? ");
INSERT INTO seh_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Umambo wa Mulungu walandana na ntombwe wa kutupisa mikate unakwata nkazi mbaubvungaza na ntsengwa zitatu za ufa, mpaka kufikira ufa onsene watupa.” ");
INSERT INTO seh_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Buluka penepo, Yezu akhafamba mbapfundzisa nzinda na nzinda, cisa na cisa, pa kwenda kwace ku Djerusalema. ");
INSERT INTO seh_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Munthu m'bodzi abvundzisa kuti: “Mbuya, ndi pang'ono anafuna kudza kapulumuka?” Yezu antawira kuti: ");
INSERT INTO seh_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Citani mphambvu toera mupite na nsuwo ung'ono. Thangwi ndisakupangani kuti azinji anati asake kupita, mbwenye anati apicimwane.” ");
INSERT INTO seh_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mwanacinthu nyumba angalamuka mbafunga nsuwo, imwe munati mukhale kunja, mbumumenya nsuwo mbumulonga kuti: “Mbuya, tifungulireni nsuwo.” Mbwenye iye anatawira kuti: “Nkhabe kukudziwani. Pontho nkhabe kukudziwani ndimwe a kupi.” ");
INSERT INTO seh_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Na tenepo, imwe munati mulonge kuti: “Tadya, mbatimwa pabodzi na imwe. Pontho imwe mwapfundzisa m'miseu mwathu.” ");
INSERT INTO seh_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mbwenye iye anakutawirani kuti: “Ine nkhabe kukudziwani. Pontho nkhabe kukudziwani ndimwe a kupi. Bulukani pano, imwe monsene munacita pya kuipa.” ");
INSERT INTO seh_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Penepo panadza kaoneka kulira na kukukuta mano, mungaona Abharaamu, Izaki na Djakobo na maporofeta onsene mu Umambo wa Mulungu, imwe mbumukhala kunja. ");
INSERT INTO seh_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Anthu azinji anabulukira kumabulukira dzuwa, na kumadokero a dzuwa, na kumalolo na ku bangwe, mbaenda kakhala pa phwandu, mu Umambo wa Mulungu. ");
INSERT INTO seh_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ndimo mwene, alipo anango akumalisira anati akhale akutoma. Alipombo anango akutoma, anati akhale akumalisira. ");
INSERT INTO seh_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Pa n'dzidzi unoule afarisi anango anfendezera Yezu mbampanga kuti: “Buluka pano uyende pyako, thangwi Herodhi asafuna kukupha.” ");
INSERT INTO seh_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yezu aatawira tenepa: “Ndokoni mukhalonge kuna n'nyenga ule kuti Ine, lero na mangwana ndisathamangisa mizimu ya kuipa na kuwangisa atenda. Mphapo nkucauno, ndinamalisa basa yanga.” ");
INSERT INTO seh_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Apo Yezu athimiza na kulonga kuti: Mbwenye ine ndisafunika ndifambe lero, mangwana na nkucauno. Thangwi nkhabe funika kuti mporofeta afe kunja kwa Djerusalema. ");
INSERT INTO seh_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Iwe Djerusalema, Djerusalema! Usapha pyako aporofeta, pontho mbumenya na myala ale atumwi adakutumira Mulungu! Kangasi mbandifuna gumanya mbumba yako yonsene, ninga nkhuku isagumanya anapiye ace m'mapapido mwace, iwe mbukhonda! ");
INSERT INTO seh_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Lang'anani nyumba yanu inasiyiwa. Pontho ndisakupangani kuti cipo imwe nkhabe kudza kandionabve tayu, mpaka n'dzidzi unadza imwe kalonga kuti: “Mbasimbwe ule anadza na dzina ya Mbuya.” ");
INSERT INTO seh_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ntsiku inango ya Sabudu, mudapita Yezu n'nyumba mwa nkulu wa afarisi kuti aende kadya, anthu onsene akhamulang'anisa. ");
INSERT INTO seh_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Patsogolo pace pakhakhala na mamuna m'bodzi akhali na nthenda ya kubzimba. ");
INSERT INTO seh_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Penepo, Yezu abvundzisa kuna anyakudziwisa a mwambo na kuna afarisi kuti: “Kodi mwambo wathu usatawirisa kuwangisa munthu ntsiku ya Sabudu peno nkhabe?” ");
INSERT INTO seh_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mbwenye iwo amatama. Na tenepo, Yezu amphata mamuna manja ace mbamuwangisa, mbampanga kuti ndoko pyako. ");
INSERT INTO seh_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Buluka penepo Yezu aabvundza kuti: “Ngakhala m'bodzi wanu ana mwana wace peno ng'ombe yace idagwa mu ncera, nkhabe kwenda kaibulusa na mwansanga ntsiku ya Sabudu?” ");
INSERT INTO seh_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Iwo acimwana kuntawira. ");
INSERT INTO seh_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yezu pikhalang'anisa Iye anyaphwandu kusankhula kukhacita iwo mbuto za kutoma pa thando ya kudya, alonga nsanje wa kuti: ");
INSERT INTO seh_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Ungacemerwa na munthu ku phwandu ya banja, leka kukhala pa mbuto ya kutoma. Thangwi panango alipombo unango adacemerwa, munthu wa mbiri kupiringana iwe. ");
INSERT INTO seh_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Mphapo, ule adakucemerani pa uwiri wanu funa akupange tenepa: “Buluka penepo upase ndzako mbuto.” Penepo, iwe unakhala na manyadzo, mbuenda kakhala pa mbuto yakumalisira. ");
INSERT INTO seh_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mbwenye iwe ungacemerwa, khala pa mbuto ya kumalisira. Ule adakucemera anabwera kudza kakupanga kuti: “Xamwali, bwera kuno kutsogolo.” Na tenepo, unalemedzeka pikulu pa maso pa onsene adacemerwa pa phwandu. ");
INSERT INTO seh_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Thangwi ule anapikuza, anadza kacepeswa. Ulembo anapicepesa, anadza kakuzwa. ");
INSERT INTO seh_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Buluka penepo, Yezu apanga ule adancemera kuti: Iwe ungafuna kucita phwandu na masikati, peno na masiku, leka kucemera axamwali ako, peno abale ako, peno a dzindza yako, peno andzako anyakupfuma anakhala na iwe dhuzi pa cisa. Thangwi ntsiku inango, iwo anadza kakucemerambo. Na tenepo, anakubwezera udidi onsene udacita iwe. ");
INSERT INTO seh_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mbwenye iwe ungacita phwandu, cemera anyakucherenga, anyakulamala, anyakuchikama na madzimola. ");
INSERT INTO seh_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tenepa iwe unadza katsandzaya, thangwi iwo anacimwana kukubwezera pire pidaacitira iwe. Mbwenye Mulungu, anakupasa muwoni wako pa kulamuka pa kufa kwa anyakulungama. ");
INSERT INTO seh_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Munthu m'bodzi akhakhala na iwo pa thando ya kudya, mudabva iye penepi, alonga kuna Yezu kuti: Mbatsandzaye ale anadza kadya phwandu ya Umambo wa Mulungu. ");
INSERT INTO seh_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Mbwenye Yezu alonga kuti: Mamuna m'bodzi acita phwandu ikulu mbacemeresa anthu azinji. ");
INSERT INTO seh_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Mudakwana n'dzidzi wa phwandu, atuma nyabasa wace toera aende kapanga ale akhadacemerwa kuti: “Bwerani, thangwi pyonsene pyamala kusasanyirwa!” ");
INSERT INTO seh_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Mbwenye m'bodzi na m'bodzi atoma kuphemba kulekererwa. Wakutoma alonga tenepa: “Ndagula munda wanga, na tenepo ndisafunika ndiyende kauona. Ndisaphemba kuti mundilekerere.” ");
INSERT INTO seh_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Unango alonga tenepa: “Ndagula ng'ombe khumi zakulima nazo. Funa ndikhazyone kuphata kwazo basa. Ndisaphemba kuti mundilekerere.” ");
INSERT INTO seh_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Unango alonga tenepa: “Ndamala kupaswa banja lero. Na thangwi eneyo ndinacimwana kwendako.” ");
INSERT INTO seh_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Nyabasa abwerera mbaenda kalonga pyonsene kuna mbuya wace. Na tenepo, mbuya wace aipirwa pikulu kakamwe, mbalonga kuti: “Ndoko na mwansanga m'miseu na m'misika ya mu nzinda ukhacemere anyakucherenga, madzimola, anyakulamala na anyakuchikama.” ");
INSERT INTO seh_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mudabwerera nyabasa, alonga tenepa: “Mbuya, ndamala kucita pyonsene pidandipanga imwe, mbwenye mbuto iciripo basi.” ");
INSERT INTO seh_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Penepo, mbuya wace ampanga tenepa: “Ndoko m'miseu na n'njira zinango za cigwagwa. Akakamize anagumana iwe mwenemu kuti abwere, toera nyumba yanga idzale. ");
INSERT INTO seh_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mbwenye ine ndisakupangani kuti nkhabe m'bodzi adacemera ine pa kutoma, anadza kalawira phwandu yanga.” ");
INSERT INTO seh_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Penepo, mwinji wa anthu ukhatowera Yezu. Iye azungunuka mbalonga tenepa: ");
INSERT INTO seh_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ule anafuna kunditowera, mbakhonda kundifuna kupiringana baba wace na mai wace, nkazace, anace amuna na akazi, abale ace amuna na akazi, peno mbakhonda kundifuna kupiringana iye ene, nkhabe kwanisa kukhala nyakupfundza wanga. ");
INSERT INTO seh_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Pontho ule anakhonda kukwata ntanda wace mbanditowera, nkhabe kwanisa kukhala nyakupfundza wanga.” ");
INSERT INTO seh_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ngakhala m'bodzi wanu asanyerezera kumanga nyumba ya kulapha pikulu kakamwe, cakutoma nkhabe kukhala pantsi mbatoma kuona pinafuna kubvunga iye, toera angamala aone ngakhala kobiri zace zinakwana? ");
INSERT INTO seh_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Thangwi angakhonda kucita penepi, iye anaikha nchici, mbwenye anacimwana kuimalisa nyumba. Penepo, onsene adaona pidacitika, anatoma kunseka mbalonga tenepa: ");
INSERT INTO seh_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Mamuna uyu aitoma nyumba, mbwenye acimwana kuimalisa!” ");
INSERT INTO seh_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Peno mbani mambo, kuti angafuna buluka kwenda ku nkhondo kamenyana na mambo ndzace, pa kutoma nkhabe khala pantsi mbatoma kunyerezera kuti na anyakhondo pikwi khumi, ndinakwanisa kumenyana na ule anadza na pikwi makumawiri? ");
INSERT INTO seh_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Angakhonda kucita penepi, anamalisira kutuma mwana nkate kuna mambo ndzace mbaciri kutali, kuti abverane naye pya ntendere. ");
INSERT INTO seh_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Na tenepo, nkhabe m'bodzi wanu anakwanisa kukhala nyakupfundza wanga, angakhonda kusiya pyonsene pina iye. ");
INSERT INTO seh_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Munyu ndi cinthu cadidi, mbwenye ungakhonda kulungula si munyubve tayu. ");
INSERT INTO seh_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nkhabe basabve ibodzi inafuna kucita iwo, peno pa mataka, peno kupasa ndimu mataka. Unakwatwa mbutayiwa kunja. “Ule ana makutu a kubva, mbabve.” ");
INSERT INTO seh_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Onsene anyakukumbusa misonkho na anyakudawa, akhafendedzera Yezu toera abve pikhalonga iye. ");
INSERT INTO seh_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mbwenye afarisi na anyakudziwisa a mwambo, akhadungunya mbalonga tenepa: “Mamuna uyu asatambira anyakudawa, mbadya nawo pabodzi!” ");
INSERT INTO seh_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Na tenepo, Yezu aapanga nsanje uyu: ");
INSERT INTO seh_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Mbani pakati panu ana dzana ya mabira, ingataika ibodzi, mbakhonda kwenda kaisaka mpaka kuigumana, mbasiya makumapfemba na mapfemba n'thando? ");
INSERT INTO seh_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Angaigumana, asaikwata mbaiyikha pa phewa na kukomerwa, ");
INSERT INTO seh_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","mbaenda nayo ku nyumba. Angafika, asacemera axamwali ace na andzace a pa cisa, mbalonga tenepa: “Tsandzayani pabodzi na ine, thangwi bira yanga ikhadataika, ndaigumana.” ");
INSERT INTO seh_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ine ndisakupangani kuti ndi sawa-sawambo na kudzulu. Kunagumanika kutsandzaya kukulu kakamwe na thangwi ya nyakudawa m'bodzi adachunyuka kudawa kwace, kupiringana kutsandzaya kukhali na iwo na anthu makumapfemba na apfemba akulungama akusowa mathangwi akuchunyuka. ");
INSERT INTO seh_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Peno mbani nkazi anakhala na kobiri khumi za ndzaya-ndzaya, angataikirwa na ibodzi, mbakhonda gasa nyale, na kupsaira n'nyumba mwace, mbaisaka mpaka kuigumana? ");
INSERT INTO seh_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Angaigumana, anacemeresa axamwali ace, na andzace a pa cisa mbaapanga tenepa: “Tsandzayani pabodzi na ine, thangwi ndaigumana kobiri yanga ikhadataika. ");
INSERT INTO seh_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ndinakupangani kuti tenepa ndi sawa-sawambo na anju za Mulungu, zisatsandzaya na thangwi ya munthu m'bodzi nyakudawa angachunyuka.” ");
INSERT INTO seh_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yezu alonga pontho kuti: “Mamuna m'bodzi akhali na anace amuna awiri. ");
INSERT INTO seh_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mwana wa ng'ono alonga tenepa kuna baba wace: ‘Baba, ndipaseni cincino, phindi yanga ya unthaka.’ Na tenepo, iye aagawaniza anace awiri ene mpfuma yace. ");
INSERT INTO seh_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mudapita ntsiku pang'ono, mwana wa ng'ono agumanya pyace pyonsene, mbaenda dziko inango ya kutali. Kweneko aenda kabvunga pyace pyonsene pikhakhala na iye, na makhaliro ace a kuipa akhacita iye. ");
INSERT INTO seh_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Mudamala iye kubvunga pyace pyonsene, mwaoneka njala ikulu n'dziko eneyo, iye mbatoma kuthabuka. ");
INSERT INTO seh_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Na thangwi eneyo, asaka basa kwa munthu m'bodzi wa kweneku, munthu unowu mbamuendesa kumunda kwace kuti akhadyese nkhumba. ");
INSERT INTO seh_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Kweneko, na njala ikakhala na iye, akhafuna kuti adye pyace pikhadya nkhumba, mbwenye na penepyo pyene nkhabe akhampasa. ");
INSERT INTO seh_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ekha-ekha, anyerezera tenepa: ‘Mbangasi anyabasa a baba ana phoso ya kukwana, ine ndiri kuno mbandifa na njala!’ ");
INSERT INTO seh_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ndinalamuka mbandibwerera kuna baba wanga, ndikhampange tenepa: ‘Baba, ndadawa kudzulu na kuna imwe. ");
INSERT INTO seh_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Sidakwana kucemerwa pontho mwana wanu tayu. Nditambireni ninga m'bodzi wa nyabasa wanu.’ ");
INSERT INTO seh_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Buluka penepo alamuka mbabwerera pontho kuna baba wace. Mbali kutali, baba wace amuona. Na ntsisi zikulu na mwana wace, anthamangira mbankhumbatira na kumpsompsona. ");
INSERT INTO seh_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mwana alonga tenepa. ‘Baba, ndadawa kudzulu na kuna imwe. Sidakwana kuti mundicemera pontho mwana wanu.’ ");
INSERT INTO seh_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Mbwenye baba apanga anyabasa ace tenepa: ‘Cimbizani! Bweresani nguwo zadidi kakamwe mumbvazike. Muikheni mphete ibodzi n'cala mwace, mbamumbvazika ntsapato m'myendo mwace. ");
INSERT INTO seh_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Bweresani pontho mwana ng'ombe wa kunenepa, mumuphe ticite phwandu pontho tisekere. ");
INSERT INTO seh_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Thangwi mwana wanga uyu akhadafa, lero alamuka. Akhadataika, lero agumanika.’ Mbatoma kucita phwandu yawo. ");
INSERT INTO seh_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Mukhacitwa penepi, mwana wa nkulu akhali ku munda. Mudabwerera iye mbafika dhuzi na pa nyumba, abva anthu ali kuimba mbakhabvina. ");
INSERT INTO seh_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Na tenepo, acemera nyabasa m'bodzi mbambvundza kuti: ‘Ndi ninji pinacitika?’ ");
INSERT INTO seh_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nyabasa atawira tenepa: ‘M'bale wako abwera. Baba wako apha mwana ng'ombe wa kunenepa, thangwi antambira wa m'maso pontho na manungo ace a kuwanga.’ ");
INSERT INTO seh_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mwana wa nkulu aipirwa pikulu kakamwe, mbakhonda na kupita kwene. Na tenepo, baba wace abuluka kunja mbakhankakamiza kuti apite. ");
INSERT INTO seh_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Mbwenye iye atawira tenepa: ‘Ndina pyaka pizinji mbandikuphatirani basa ninga bichu mbandikhonda kupwaza mwambo ubodzi wanu. Na tenepo, mudzati kundipasambo mbuzi ene ibodzi, toera ine ndicitembo phwandu na axamwali anga. ");
INSERT INTO seh_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Mbwenye mwana wanu uyu adamala kubvunga pyanu pyonsene, na akazi anyalukwali, lero abwera, imwe mwamphera mwana ng'ombe wa kunenepa!’ ");
INSERT INTO seh_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Baba antawira tenepa: ‘Mwananga, iwe usakhala na ine ntsiku zonsene, pontho pyonsene pina ine mphyakombo. ");
INSERT INTO seh_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mbwenye tikhafunika ticite phwandu toera kupangiza kukomerwa kwathu. Thangwi m'bale wako uyu akhadafa, lero alamuka. Akhadataika, lero agumanika.’” ");
INSERT INTO seh_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yezu aapanga anyakupfundza ace kuti: “Akhalipo mpfumi m'bodzi wa mamuna akhakhala na nyabasa wace m'bodzi akhamuonera mpfuma zace. Ntsiku ibodzi apangiwa kuti: ‘Nyabasa wako asabvunga mpfuma zako.’” ");
INSERT INTO seh_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Na tenepo, iye ancemera nyabasa wace mbambvundza kuti: “Ndi ninji penepi pinakhala ine kubva kuna iwe? Sasanyira basa yako, thangwi ndisafuna kukubulusa basa.” ");
INSERT INTO seh_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Penepo nyabasa atoma kunyerezera ekha ene kuti: “Kodi ndinacita anji ndingabuluswa basa? Lima, ine nkhabe kwanisa. Kwenda mbandiphemba ca kudya, ndisabva manyadzo. ");
INSERT INTO seh_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ha! Ndapidziwa pinafuna kucita ine, kuti ndingathamangiswa pa basa ndione anthu akunditambira m'manyumba mwawo.” ");
INSERT INTO seh_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Na tenepo, atoma kucemeresa anyamangawa onsene a mbuya wace. Penepo abvundzisa wakutoma kuti: “Iwe una mangawa a ntengo wanji na mbuya wanga?” ");
INSERT INTO seh_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Iye atawira kuti: “Ndina mangawa a nkhali dzana za mafuta a kudya.” Penepo nyabasa ampanga kuti: “Kwata tsamba yako, khala pantsi na kucimbiza, lemba makumaxanu.” ");
INSERT INTO seh_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Buluka penepo abvundzisa nyamangawa waciwiri kuti: “Iwembo una mangawa a ntengo wanji?” Iye atawira kuti: “Ndina mangawa a masakha dzana a tirigu.” Penepo nyabasa ampanga kuti: “Kwata tsamba yako, lemba makumasere.” ");
INSERT INTO seh_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Mbuya wa nyabasa uyu ansimba nyabasa wace wa kuipa na thangwi ya kucenjera kwace. Thangwi ana a dziko ino acenjera pikulu kakamwe pa kubverana kwawo, kupita ana a cieza. ");
INSERT INTO seh_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Na thangwi, eneyo ine ndisakupangani kuti dziwani kuziphatisa basa mpfuma za dziko ino ya kuipa, kuti muone axamwali, toera mudze katambirwe mu nyumba za kwenda na kwenda, mpfuma zanu zingadza kamala. ");
INSERT INTO seh_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ule anakhulupirika pa pinthu ping'ono, anakhulupirikambo pa pinthu pikulu. Mphapo anakhonda kukhulupirika pa pinthu ping'ono, anacimwanikambo kukhulupirika pa pinthu pikulu. ");
INSERT INTO seh_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Thangwi imwe mungakhonda kukhulupirika pa mpfuma za dziko ino, mbani anafuna kukukhulupirani pa mpfumadi ya maso? ");
INSERT INTO seh_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Pontho mungakhonda kukhulupirika na pinthu pya andzanu, mbani anafuna kukupasani pinthu pyanu? ");
INSERT INTO seh_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nkhabe munthu anakwanisa kuphatira a mbuya awiri. Thangwi unamalisira kuida m'bodzi mbufuna unango. Peno unalemedza m'bodzi mbupwaza unango. Apo lekani kuphatira Mulungu, uku mbamuphatira pontho kobiri. ");
INSERT INTO seh_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Afarisi, anthu akuumirwa na kobiri, akhabva pyonsene ipi, mbakhasingirira Yezu. ");
INSERT INTO seh_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Na tenepo, Yezu aapanga kuti: “Imwe musapangizika ninga adidi pa maso pa anthu. Mbwenye Mulungu asaidziwa mitima yanu.Thangwi pire pinanyerezera anthu kuti ndi pinthu pikulu kakamwe, pa maso pa Mulungu ndi pinthu pyakunyanyasa.” ");
INSERT INTO seh_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mwambo wa Mozesi na pipfundzo pya aporofeta pikhaphata basa mpaka pa midzidzi ya Juwau Bhatixta. apo kutomera pa midzidzi eneyo kwenda kutsogolo, Mphangwa Zadidi za Umambo wa Mulungu, zirikumwazwa. Pontho, anthu onsene asasaka kupitamo na mphambvu mu Umambo unowu. ");
INSERT INTO seh_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kubulusa phindi ing'ono basi pa mwambo wa Mulungu, pisanentsa pikulu kakamwe kupiringana kumalisa pantsi na kudzulu. ");
INSERT INTO seh_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Mamuna onsene anamwalana na nkazi wace mbakwata unango mbacita naye banja, ali kucita upombo. Ulembo anacita banja na nkazi wa kukhondiwa na mamuna wace, ali kucitambo upombo. ");
INSERT INTO seh_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yezu athimiza na kulonga kuti: “Akhalipo mamuna m'bodzi mpfumi akhabvala nguwo za ntengo ukulu, pontho akhakhala mbacita phwandu ntsiku zonsene. ");
INSERT INTO seh_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Pa nsuwo pa mpfumi, pakhali na mamuna m'bodzi wa kucherenga, na pironda m'manungo, dzina yace ndi Lazaru, mbakhaphemba ca kudya. ");
INSERT INTO seh_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Iye akhafuna kudya manyezo akhagwa pa thando pakhadya mpfumi. Na anambwa ene akhadza kam'myanguta pironda pyace. ");
INSERT INTO seh_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Mudakwana ntsiku yace, nyakucherenga afa mbakwatiwa na anju za Mulungu kwenda dhuzi na Abharaamu. Buluka penepo, mpfumi adza kafambo mbaenda kaikhwa. ");
INSERT INTO seh_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mu mbuto ya nyatwa mukhakhala mpfumi, pidathukula iye maso, aona na kutali Abharaamu, mbali pabodzi na Lazaru nkhundu mwace. ");
INSERT INTO seh_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Na tenepo, mpfumi akhuwa mbalonga kuti: ‘Baba Abharaamu, ndibverenimbo ntsisi! Nditumirenimbo Lazaru abvike ntsonga ya cala cace m'madzi, toera adze kandithondolese lirimi yanga. Thangwi ndiri kuona nyatwa kakamwe m'moto muno.’ ");
INSERT INTO seh_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Mbwenye Abharaamu antawira tenepa: ‘Mwananga, kumbuka kuti pikhakhala iwe m'maso, watambira pinthu pyadidi, mbwenye Lazaru akhatambira pinthu pya kuipa. Na tenepo, cincino iye pano ali kutsandzaya, mbwenye iwe uli kuonambo nyatwa. ");
INSERT INTO seh_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Pontho pakati apa, kubulukira kweneko kuna iwe mpaka pano, pana djenje ikulu kakamwe. Na tenepo, nkhabe kwanisika kuti ale anafuna buluka kuna imwe adze kuna ife, peno ale anafuna buluka kuna ife adze kuna imwe.’ ");
INSERT INTO seh_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Penepo mpfumi alonga kuti: ‘Ngakhala ndi tenepo, Baba Abharaamu, ndisakuphembani kuti munditumirembo Lazaru aende ku nyumba kwa baba wanga. ");
INSERT INTO seh_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Thangwi ine ndina abale anga axanu. Na tenepo, nsiyeni kuti aende kaacenjeze, toera iwo akhonde kubwerambo pa mbuto ino ya nyatwa.’ ");
INSERT INTO seh_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abharaamu antawira tenepa: ‘Abale ako ana Mwambo wa Mozesi na mabukhu a maporofeta. Mbaabvere.’ ");
INSERT INTO seh_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Apo mpfumi antawirambo kuti: ‘Baba Abharaamu, penepyo nkhabe kwana. Mbwenye munthu wakulamuka pa kufa, angaenda kalonga nawo, iwo anachunyuka kudawa kwawo.’ ");
INSERT INTO seh_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Mbwenye Abharaamu antawira kuti: ‘Iwo angacimwana kubvera Mozesi na aporofeta, pinacimwanikiratu kakamwe kuti iwo abvere munthu wakulamuka pa kufa.’” ");
INSERT INTO seh_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yezu alonga kuna anyakupfundza ace kuti: Ndimo mwene pinthu pyonsene pinagwisa anthu nkudawa, pinati picitike. Mbwenye dzedze nja ule anacita kuti pinthu penepi picitike. ");
INSERT INTO seh_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Pikhali pyadidi amangirirwe mwala ukulu wa libwe nkhosi mwace, mbaponyiwa pakati pa bara, kupiringana kupitisa nkudawa mwana wang'ono ninga uyu. ");
INSERT INTO seh_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Citani mphole! “Ngakhala m'bale wako adawa, nsandike. Iye angachunyuka, mulekerere. ");
INSERT INTO seh_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Angakudawisira kanomwe pa ntsiku, iye mbabwera kuna iwe kanomwe, mbalonga tenepa: ‘Ndachunyuka.’ Iwe mulekerere.” ");
INSERT INTO seh_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Anyakutumwa aphemba Yezu kuti: “Mbuya, tithimizireni kukhulupira kwathu!” ");
INSERT INTO seh_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Iye aatawira tenepa: “Mbumudakhala na cikhulupiro ca thunga ya mbeu ing'ono, munakwanisa kulonga kuna muti wa nsambvu uyu kuti: ‘Dulika uyende kachekeke m'bara,’ iwo unakubverani.” ");
INSERT INTO seh_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Mbani mwa imwe angakhala na nyabasa m'bodzi anamphatira basa ya kulima kumunda, peno ya kukumbiza mabira, iye angafika buluka kumunda mbampanga kuti: ‘Bwera pa thando, utome kudya?’” ");
INSERT INTO seh_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nkhabe kucitika! Anampanga kuti asasanyike atome kumphikira pya kudya, adye, amwe. Angamala anadza kampanga kuti adyembo mbamwambo. ");
INSERT INTO seh_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Musanyerezera kuti iye ana pereka takhuta kuna nyabasa, thangwi ya kuncitira pidantuma iye? Nkhabe. ");
INSERT INTO seh_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Na tenepo, imwe musafuna mucite pibodzi-bodzi. Mungamala kucita pyonsene pidatumwa imwe, longani tenepa: “Ife ndife anyabasa ene pyathu. Thangwi tacita pire basi pidapangwa ife kuti tipicite.” ");
INSERT INTO seh_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Mukhaenda Yezu ku Djerusalema, apita na m'madire mwa Samariya na Galileya. ");
INSERT INTO seh_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Mukhapita iwo n'cisa cibodzi, anyamatanya khumi aenda kuna Iye, mbalimira na kutali, ");
INSERT INTO seh_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","mbakhuwa tenepa: Yezu, Mpfundzisi, tibvereni ntsisi! ");
INSERT INTO seh_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yezu aalang'ana mbaapanga tenepa: Ndokoni mukaapangize anyantsembe kuti akudingeni! Mukhaenda iwo, awangiswa. ");
INSERT INTO seh_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","M'bodzi wawo, mudaona iye kuti awangiswa, abwerera mbakhakuza Mulungu na mphambvu zonsene. ");
INSERT INTO seh_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Agodama pa myendo pa Yezu, mbapereka takhuta. Unowu akhali wa ku Samariya. ");
INSERT INTO seh_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Na tenepo, Yezu ambvundza kuti: Kodi si khumi tayu adawangiswa? Anango apfemba ali kupi? ");
INSERT INTO seh_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ndi thangwi yanji abwerera kakuza Mulungu ndi nfambi basi? ");
INSERT INTO seh_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Na tenepo, Yezu ampanga kuti: “Lamuka, ndoko pyako. Kukhulupira kwako kwakupulumusa.” ");
INSERT INTO seh_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Afarisi anango, abvundzisa Yezu kuti: “Umambo wa Mulungu unafika lini?” Iye atawira tenepa: “Umambo wa Mulungu nkhabe bwera mbuoneka.” ");
INSERT INTO seh_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nkhabe anadza kalonga kuti: ‘Lang'anani! Uli pano.’ Peno ‘Uli kule.’ Thangwi Umambo wa Mulungu uli pakati panu.” ");
INSERT INTO seh_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Buluka penepo, iye apanga anyakupfundza ace kuti: “Unadza kafika n'dzidzi wa kuti imwe munati mufune kuona ntsiku ibodzi ya kubwera kwa Ine Mwana wa Munthu, mbwenye nkhabe kudza kaiona.’ ");
INSERT INTO seh_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Anango anakupangani kuti: ‘Lang'anani ali pano, peno lang'anani ali pale.’ Mbwenye lekani kwenda mbamuatowera. ");
INSERT INTO seh_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Thangwi sawa-sawa ninga njazi isacetuma buluka pa nkhomu ibodzi ya kudzulu mpaka ku nkhomu inango, tenepa pinacitikambo ntsiku inadza kabwera Ine Mwana wa Munthu. ");
INSERT INTO seh_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mbwenye pa kutoma, Ine ndisafunika ndithabuke, pontho ndikhondiwe na anthu a ntsiku zino. ");
INSERT INTO seh_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ninga pidacitika pa ntsiku za Nowa, tenepa pinacitikambo pa ntsiku za Ine Mwana wa Munthu. ");
INSERT INTO seh_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Anthu onsene akhadya, akhamwa. Amuna akhacita mabanja, akazi akhaperekwa m'mabanja, mpaka ntsiku idapita Nowa mu arka. Na tenepo, madzi adzala, onsene mbamala kufa na madzi. ");
INSERT INTO seh_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Pibodzi-bodzi pyacitikambo pa n'dzidzi wa Loti. Anthu akhadya, akhamwa, akhagula mbakhagulisa, akhacheka, pontho akhamanga nyumba. ");
INSERT INTO seh_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Mbwenye pa ntsiku idabuluka Loti mu Sodhoma, kudzulu kwabvumba moto na myala ya kugaka, mbumala kupha onsene. ");
INSERT INTO seh_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Na tenepo, pinacitikambo sawa-sawa ntsiku inafuna kubulukira Ine Mwana wa Munthu. ");
INSERT INTO seh_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ntsiku eneyo, ule ali pa ntsoyi ya nyumba yace, mbaleke chita toera akakwate pinthu pyace n'kati mwa nyumba. Sawa-sawa na ule ali ku munda, mbaleke bwerera n'nduli. ");
INSERT INTO seh_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kumbukani nkazi wa Loti! ");
INSERT INTO seh_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Munthu anasaka kukoya upulumuki wace, anauluza. Mbwenye ule analuza upulumuki wace, anaugumana. ");
INSERT INTO seh_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ndinakupangani kuti masiku enewa, anthu awiri anagumanika ali kugona pa talimba ibodzi ene, m'bodzi anakwatiwa, m'bodzi anasiyiwa. ");
INSERT INTO seh_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Akazi awiri anagumanika ali kupeya pabodzi pene, m'bodzi anakwatiwa, m'bodzi anasiyiwa. ");
INSERT INTO seh_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Amuna awiri anagumanika ali kumunda, m'bodzi anakwatiwa, m'bodzi anasiyiwa.” ");
INSERT INTO seh_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Na tenepo, anyakupfundza ace ambvundza kuti: “Mbuya, pinacitika kupi penepi?” Iye atawira tenepa: “Pale panagumanika cinthu ca kufa, ndipo panagumanyikana malezi.” ");
INSERT INTO seh_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Na tenepo, Yezu alonga kuna anyakupfundza ace nsanje ubodzi toera kuapangiza kuti asafunika aphembere mbakhonda kuneta. ");
INSERT INTO seh_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Iye atoma kulonga tenepa: “Akhalipo mu nzinda ubodzi nyakutonga miseru m'bodzi wakukhonda kugopa Mulungu, pontho akhali munthu akhakhonda kulemedza andzace. ");
INSERT INTO seh_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mu nzinda unowu, akhalipombo nkazi m'bodzi adaferwa na mamuna wace, akhaenda kazinji kene kuna nyakutonga miseru unowu, mbakhalonga tenepa: ‘Nditongerenimbo nseru wanga una ine na nyamalwa wanga.’” ");
INSERT INTO seh_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nyakutonga miseru amala ntsiku zingasi mbakhakhonda. Mbwenye pa kumalisa alonga ekha ene kuti: “Ine nkhabe gopa Mulungu, pontho nkhabe munthu m'bodzi analemedza ine pantsi pano. ");
INSERT INTO seh_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Mbwenye na thangwi ya kundinyangula kunandicita manferwa uyu, ine ndinati ndin'gwandire nseru wace, toera akhonde kudza kandisanya pontho.” ");
INSERT INTO seh_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Penepo Mbuya athimiza pontho na kulonga kuti: “Bvani pinalonga ntongi uyu wa kuipa. ");
INSERT INTO seh_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nkhulongera kuti Mulungu nkhabe kudza kagwanda miseru ya anthu ace adasankhula iye, anan'dembetera masiku na masikati? Musanyerezera kuti Iye anaasiya mbadikhira n'dzidzi ukulu ene? ");
INSERT INTO seh_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ine ndisakupangani kuti Mulungu anaitonga miseru ya mbumba yace na mwansanga. Mphapo Ine Mwana wa Munthu ndingabwera, nkhulongera kuti ndinati ndigumane kukhulupira pantsi pano?” ");
INSERT INTO seh_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Kuna ale akhanyerezera okhene kuti mbakulungama, mbakhapwaza andzawo, Yezu aalongera nsanje uxu. ");
INSERT INTO seh_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Amuna awiri aenda kaphembera mu Nyumba ya Mulungu. M'bodzi akhali nfarisi, m'bodzi akhali nyakukumbusa misonkho.” ");
INSERT INTO seh_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nfarisi alimira mbakhaphembera na mu ntima mwace tenepa: “Oh! Mulungu, ndisapereka takhuta kuli imwe, thangwi ine ndasiyana na anthu anango ninga awa: Mambava, a kuipa, na anyaupombo. Pontho ndasiyana na uyu nyakukumbusa misonkho. ");
INSERT INTO seh_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ine ndisapimana ca kudya kawiri pa sumana, pontho pa pinthu pyanga pyonsene pina wina ine, ndisabulusa ca cikhumi.” ");
INSERT INTO seh_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Mbwenye nyakukumbusa misonkho akhala kutali, mbakhacimwana na kulang'ana kwene kudzulu, mbwenye akhamenya cifuwa cace mbakhalonga kuti: “Mulungu wanga, ndibverenimbo ntsisi, thangwi ndine nyakudawa!” ");
INSERT INTO seh_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yezu amalisa na kulonga tenepa: “Ine ndisakupangani kuti uyu nyakukumbusa misonkho, ndiye basi adalekererwa na Mulungu. Ndzace nkhabe.Thangwi ule anapikuza anadza kacepeswa. Apo ule anapicepesa anadza kakuzwa.” ");
INSERT INTO seh_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Penepo, anthu anango akhabweresa ana ang'ono kuna Yezu toera aaphemberere. Anyakupfundza a Yezu na kupiona penepyo, atoma kuasandika anthu enewa. ");
INSERT INTO seh_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Mbwenye Yezu acemera ana mbadza dhuzi na Iye, mbalonga kuti: “Asiyeni ana abwere kuna Ine, lekani kuakhondesa, thangwi Umambo wa Mulungu ndi wa ale adalandana na iwo.” ");
INSERT INTO seh_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ndimo mwene Ine ndisakupangani kuti: “Ule anakhonda tambira Umambo wa Mulungu ninga mwana, nkhabe kudza kapitamo.” ");
INSERT INTO seh_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mamuna m'bodzi wa mbiri ambvundza kuti: “Mpfundzisi wadidi, ndisafuna ndicitenji toera ndikhale na upulumuki wakukhonda kumala?” ");
INSERT INTO seh_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yezu antawira kuti: “Thangwi yanji usandicemera wadidi?” Wadidi ndi Mulungu basi, nkhabe unango. ");
INSERT INTO seh_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Iwe usadziwa matongero analonga kuti: “Leka kucita upombo, leka kupha munthu, leka kuba, leka kukhala nyamaso wa uthambi, lemedza baba wako na mai wako.” ");
INSERT INTO seh_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Apo mamuna antawira tenepa: “Penepi pyonsene, ine ndisapikoya kutomera mbandiri mwana.” ");
INSERT INTO seh_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yezu pidabva Iye penepyo, ampanga tenepa: “Wasala na cinthu cibodzi. Gulisa pyonsene pina iwe, kobiri yace mbuipasa anyakucherenga.Tenepa unakhala na mpfuma kudzulu. Ungamala bwera, unditowere.” ");
INSERT INTO seh_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Mamuna na kubva penepyo, atsukwala pikulu thangwi akhali mpfumi wa nkulu kakamwe. ");
INSERT INTO seh_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yezu na kumuona kutsukwala kwace alonga tenepa: “Pisanentsa pikulu kakamwe kuti apfumi apite mu Umambo wa Mulungu! ");
INSERT INTO seh_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ndimo mwene, pisanentsa pikulu kakamwe kupitisa mpfumi mu Umambo wa Mulungu, kupiringana kupitisa cinyama cikulu cinacemerwa kamelo mu benga ya ntsingano.” ");
INSERT INTO seh_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Anthu adabva penepyo atoma kubvundzisa kuti: “Na tenepo, mbani anakwanisa kupulumuka?” ");
INSERT INTO seh_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Apo Yezu atawira kuti: “Pinacimwanika kuna anthu, kuna Mulungu pisakwanisika.” ");
INSERT INTO seh_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Penepo Pedhru alonga kuti: “Lang'anani! Ife tasiya pyonsene mbatikutowerani!” ");
INSERT INTO seh_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yezu atawira tenepa: “Ndimo mwene Ine ndisakupangani kuti: ule anasiya nyumba yace, nkazi wace, abale ace, ababa ace, peno ana ace na thangwi ya Umambo wa Mulungu, ");
INSERT INTO seh_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","anati atambire kazinji kene pikulu kakamwe midzidzi ino, pontho mbatambira upulumuki wakukhonda kumala pa midzidzi inafuna kudza.” ");
INSERT INTO seh_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Penepo Yezu akwata anyakupfundza ace khumi na awiri mbaenda nawo pa khundu, mbaapanga kuti: “Bveserani! Ife tirikwenda ku Djerusalema. Kweneko pinacitika pyonsene pidalemba aporofeta na thangwi yanga, Ine Mwana wa Munthu.” ");
INSERT INTO seh_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ine ndinati ndiperekwe m'manja mwa anthu adakhonda kukhala madjuda. Iwo anati andisingirire, mbanditikana, na kundiphulira mata. ");
INSERT INTO seh_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Pontho anati andimenye na n'chamu, angamala mbadza kandipha. Mbwenye ntsiku ya citatu ndinadza kalamuka pa kufa. ");
INSERT INTO seh_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Mbwenye anyakupfundza acimwana kupibvesesa pinthu penepyo. Thangwi pikhalongera mafala enewa, pikhali pinthu pyakubisala kuna iwo, pontho iwo hakhapidziwa tayu ndi ninji pikhalongera Yezu. ");
INSERT INTO seh_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yezu mukhafika iye dhuzi na nzinda wa Djeriko, agumana dzimola m'bodzi mbali nawa pantsi mu mbale mwa njira, mbakhaphemba anthu akhapita. ");
INSERT INTO seh_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Mukhabva iye mbumba mbikhapita, iye abvundzisa kuti ndi ninji penepi. ");
INSERT INTO seh_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Apo anthu antawira kuti ndi Yezu wa ku Nazareti ali kupita. ");
INSERT INTO seh_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Na tenepo, dzimola atoma kukhuwa mbakhalonga kuti: Yezu Mwana wa Dhavidhi, ndibverenimbo ntsisi! ");
INSERT INTO seh_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Anthu akhaenda kutsogolo akhansandika mbakham'matamisa. Mbwenye iye akhakhuwiratu kakamwe na mphambvu, mbakhalonga kuti: Yezu, Mwana wa Dhavidhi, ndibverenimbo ntsisi! ");
INSERT INTO seh_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yezu alimira, mbancemeresa. Mphapo pidafika iye dhuzi Yezu ambvundza kuti: ");
INSERT INTO seh_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Usafuna kuti ndikucitirenji?” Iye atawira kuti: “Mbuya ine ndisafuna ndione.” ");
INSERT INTO seh_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yezu ampanga kuti: “Ona, wawanga! Kukhulupira kwako kwakupulumusa.” ");
INSERT INTO seh_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Pa n'dzidzi ubodzi ene, mamuna atoma kuona, mbapasa mbiri Mulungu, mbatoma kutowera Yezu. Na tenepo, anthu onsene adapyona penepyo atoma kusimba Mulungu. ");
INSERT INTO seh_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yezu apita mu Djeriko, mbakhagwanda na mu nzinda. ");
INSERT INTO seh_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mwenemu mukhali na mamuna m'bodzi wa kupfuma, dzina yace ndi Zakeu, nkulu wa anyakukumbusa misonkho. ");
INSERT INTO seh_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Iye akhafuna kuona Yezu, mbwenye akhacimwana thangwi ya mwinji wa anthu, pontho iye akhadabvira. ");
INSERT INTO seh_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Na tenepo, Zakeu athamanga kutsogolo kwa mbumba, mbakwira m'muti wa nsambvu toera amuone, thangwi Yezu akhafuna kupita na penepo. ");
INSERT INTO seh_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Mudafika Yezu penepo, alang'ana n'dzulu mbalonga kuna Zakeu kuti: “Zakeu, chita na mwansanga thangwi lero ndisafuna ndikhale n'nyumba mwako.” ");
INSERT INTO seh_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Na tenepo, Zakeu achita na mwansanga, mbantambira na kukomerwa. ");
INSERT INTO seh_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Onsene adaona penepyo, atoma kudungunya mbalonga kuti: “Mamuna uyu aenda kaphemba dalo ku nyumba kwa nyakudawa!” ");
INSERT INTO seh_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Mbwenye Zakeu alamuka, mbalonga kuna Mbuya kuti: “Lang'anani Mbuya, kutomera lero ndinagawa pakati mpfuma yanga, phindi inango mbandiipasa anyakucherenga. Pontho ngakhala ndabera munthu, ndinam'bwezera kanai pa pidankwatira ine.” ");
INSERT INTO seh_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Na tenepo, Yezu alonga kuti: “Lero upulumuki wapita n'nyumba ino, thangwi mamuna uyu ndi wa dzindza ibodzi ene ya Abharaamu.” ");
INSERT INTO seh_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Thangwi Ine Mwana wa Munthu, ndabwera kakwata na kupulumusa ule adataika. ");
INSERT INTO seh_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yezu alonga nsanje ubodzi kuli ale akhabva pikhalonga iye, thangwi akhali dhuzi na ku Djerusalema. Pontho, mbumba ikhanyerezera kuti Umambo wa Mulungu una fika na mwansanga. ");
INSERT INTO seh_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Na tenepo, Yezu aapanga kuti: “Mamuna m'bodzi wa dzindza yakubvekera, abuluka mbaenda ku dziko inango ya kutali, toera kweneko aende kapaswe cidzo ca umambo, angamala abwerere.” ");
INSERT INTO seh_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Na tenepo, acemera anyabasa ace khumi, aapasa kobiri khumi, mbaapanga tenepa: “Ifambiseni kobiri iyi mpaka kubwera kwanga.” ");
INSERT INTO seh_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mbwenye anthu anango a n'dziko mwace, akhanzonda. Na tenepo, atuma anthu n'nduli mwace, kuti aende kalonge kukhaenda iye, na mphangwa izi: “ife nkhabe kunfuna mamuna unowu kuti akhale mambo wathu.” ");
INSERT INTO seh_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Mamuna aupaswa umambo, mbabwerera ku nyumba. Penepo, acemeresa anyabasa ace akhadapasa iye kobiri, toera adziwe kuti awina ntengo wanji. ");
INSERT INTO seh_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Wa kutoma afika mbalonga tenepa: “Mbuya, kobiri yanu ire idandipasa imwe, ine ndawina nayo zinango khumi.” ");
INSERT INTO seh_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Mbuya wace atawira tenepa: “Wacita pyadidi. Iwe ndiwe nyabasa wadidi! Na kundibvera kudacita iwe pa pinthu ping'ono, iwe unatonga mizinda khumi.” ");
INSERT INTO seh_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Nyabasa waciwiri abwera mbalonga tenepa: “Mbuya, na kobiri yanu ire idandipasa imwe, ine ndawina nayo zinango zixanu.” ");
INSERT INTO seh_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Mbuya wace ampanga tenepa: “Iwe unadza katongambo mizinda mixanu.” ");
INSERT INTO seh_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nyabasa unango afika mbalonga tenepa: “Mbuya, kobiri yanu ndi iyi. Ine ndaimangira pa cinguwo mbandiibisa. ");
INSERT INTO seh_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ndikhakugopani, thangwi ndimwe munthu wakunentsa. Musabulusa panakhonda ikha imwe, pontho musabvuna pidakhonda bzala imwe.” ");
INSERT INTO seh_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Mbuya wace atawira tenepa: “Iwe ndiwedi nyabasa wakuipa! Ndinakutonga na mafala ako pontho. Iwe ukhapidziwa kuti ndine munthu wa kunentsa. Ndisabulusa pidakhonda ikha ine, pontho ndisabvuna pidakhonda bzala ine. ");
INSERT INTO seh_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ndi thangwi yanji mphapo, wa khonda kuiyikha kobiri yanga n'nyumba zinakoyera anthu kobiri? Na tenepo, pa kubwerera kwanga pa ulendo, mbidaitambira na m'bairo.” ");
INSERT INTO seh_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Mbapanga ale akhakhala penepo kuti: “Mpokosereni kobiri yace muipase ule ana kobiri khumi.” ");
INSERT INTO seh_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Iwo atawira tenepa: “Mbuya, iye anazo kale kobiri khumi!” ");
INSERT INTO seh_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Mbuya wawo aapanga tenepa: “Ndinakupangani kuti ule anapyo, anapaswa pinango. Mbwenye ule adapisowa, na ping'ono pyene pina iye anapipokoserwa.” ");
INSERT INTO seh_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Cincino, ndibwereseni kuno anyamalwa anga, ale akakhonda kuti ine ndikhale mambo wawo. Apheni pa maso panga. ");
INSERT INTO seh_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yezu mudamala Iye kulonga penepyo, atsogola kwenda ku Djerusalema. ");
INSERT INTO seh_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Mukhafika Iye dhuzi na m'pisa pya Bhetifaji na pya Bhetanya, pa phiri inacemerwa Mulivera, atuma anyakupfundza ace awiri, mbaapanga tenepa: ");
INSERT INTO seh_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ndokoni mpaka pa cisa ciri kutsogolo kwanu. Pa n'dzidzi unapita imwe, munagumana mwana buru wa kumangirwa, kuti asati pakirwa na munthu. Nsudzuleni, mudze naye kuno. ");
INSERT INTO seh_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mungabvundziwa na munthu kuti: “musansudzuliranji?” Longani kuti: “Mbuya asanfuna.” ");
INSERT INTO seh_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Iwo aenda, mbagumana pyonsene ninga mudapipangwa iwo na Yezu. ");
INSERT INTO seh_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Mukhansudzula iwo mwana buru, anacinthu abvundzisa kuti: “Thangwi yanji musasudzula mwana buru?” ");
INSERT INTO seh_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Iwo atawira tenepa: “Mbuya asanfuna.” ");
INSERT INTO seh_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Na tenepo, iwo ankwata mwana buru mpaka kuna Yezu. Akwata nguwo zawo mbaziyikha pa nsana wa mwana buru, mbaphedza Yezu kupakira. ");
INSERT INTO seh_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Mukhaenda Iye, mbumba ikhaenda mbithasika nguwo zawo n'jira. ");
INSERT INTO seh_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Mukhafika Yezu dhuzi na panterero wa phiri ya Mulivera, mwinji onsene wa anyakupfundza ace, atoma kukuza Mulungu na mphambvu na kukomerwa konsene, na thangwi ya pirengo pyonsene pikhadaona iwo, ");
INSERT INTO seh_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","mbakhakhuwa tenepa: “Wakusimbwa ndi Mambo anabwera na dzina ya Mbuya!” “Ntendere kudzulu, na mbiri kuna Mulungu!” ");
INSERT INTO seh_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Penepo, afarisi anango akhali pakati pa mbumba, alonga kuna Yezu kuti: “Mpfundzisi, matamisa anyakupfundza ako!” ");
INSERT INTO seh_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yezu atawira tenepa: “Ine ndisakupangani kuti iwo angamatama, myala inakhuwa!” ");
INSERT INTO seh_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yezu mudafika iye dhuzi na Djerusalema, aona nzinda, mbatoma kuulirira. ");
INSERT INTO seh_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Mbalonga tenepa: “Ha! Djerusalema! Mbudadziwa pyako lero ene cire cinadzesa ntendere! Mbwenye cincino iwe nkhabe kwanisa kupiona penepi na maso ako. ");
INSERT INTO seh_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Zinafika ntsiku za kuti anyamalwa ako anakucitira mpanda, mbakuzungulira nawo na kukufungira m'makhundu onsene. ");
INSERT INTO seh_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Pontho anakugwisa pantsi iwe na ana ako ene. Nkhabe kudza kasala mwala padzulu pa mwala unango, thangwi iwe wakhonda kudzindikira n'dzidzi udadza kakupulumusa Mulungu.” ");
INSERT INTO seh_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Buluka penepo, Yezu apita mu Nyumba ya Mulungu, mbatoma kuthamangisa ale akhagulisa mwenemu. ");
INSERT INTO seh_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Iye alonga tenepa: Pyalembwa M'bukhu ya Mulungu kuti: “Nyumba yanga inadza kakhala nyumba ya kuphembera.” Mbwenye imwe mwaisanduza kuti ikhale mbuto ya kubisalira mambava. ");
INSERT INTO seh_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ntsiku zonsene, Yezu akhapfundzisa mu Nyumba ya Mulungu. Mbwenye akulu aanyantsembe, na anyakudziwisa a mwambo, pabodzi na atsogoleri a mbumba, akhafuna kumupha. ");
INSERT INTO seh_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Mbwenye akhasaka kuti anapicita tani penepi. Thangwi mbumba yonsene ikhakomerwa na kubva mafala ace. ");
INSERT INTO seh_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ntsiku inango, Yezu akhali n'Nyumba ya Mulungu mbakhapfundzisa mbumba, na kumwaza Mphangwa Zadidi. Na tenepo, afika penepo akulu aanyantsembe, na anyakudziwisa a mwambo na atsogoleri a mbumba, ");
INSERT INTO seh_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","mbambvundza kuti: “Tipange. Uli kucita pinthu penepi na utongi wa ani? Mbani akupasa utongi unowu?” ");
INSERT INTO seh_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yezu atawira tenepa: Ine ndisafuna ndikubvundzenimbo. Ndipangeni: ");
INSERT INTO seh_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","“Batixmu ya Juwau ikhali ya kudzulu peno ya anthu?” ");
INSERT INTO seh_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Penepo iwo atoma kuketesana okha-okha mbalonga tenepa: “Tingalonga kuti ndi ya kudzulu, Iye anadza kabvundza kuti: Mphapo ndi thangwi yanji imwe mwankhonda kuntawira Juwau?” ");
INSERT INTO seh_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Mbwenye tingalonga kuti ndi ya anthu, mbumba yonsene iyi inatimenya na myala. Thangwi iwo asatawira kuti Juwau akhali mporofetadi. ");
INSERT INTO seh_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Na thangwi eneyo, iwo atawira tenepa: “Ife nkhabe kupidziwa kuti ikhali ya ani.” ");
INSERT INTO seh_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Na tenepo, Yezu aapanga kuti: “Ine nkhabe kukupanganimbo kuti ndisacita pinthu penepi na utongi wa ani.” ");
INSERT INTO seh_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Buluka penepo, Yezu alonga kuna mbumba nsanje uyu: “Mamuna m'bodzi alima munda wace wa mauva, aulikisa na anyakulima, mbacita ulendo mbakhala ntsiku zizinji. ");
INSERT INTO seh_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Pidakwana iwo n'dzidzi wa kuchoda mauva, iye atuma n'dzakazi wace m'bodzi kuti akhatambire misapu ya mauva. Mbwenye anyakulima am'menya, mbam'bweza cimanja-manja. ");
INSERT INTO seh_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mwanacinthu atuma n'dzakazi unango. Mbwenye iwo am'menya pontho, mban'nyadzisa, mbam'bweza cimanja-manja. ");
INSERT INTO seh_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Na tenepo, iye atuma n'dzakazi unango wa citatu. Mbwenye anyakulima amphekesambo, mbanthamangisa. ");
INSERT INTO seh_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Penepo mwanacinthu munda alonga kuti: ‘Ndinacitanji?’ Ndinatuma mwana wanga wa pa ntima, panango iwo angamuona, anamulemedza.” ");
INSERT INTO seh_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Mbwenye anyakulima mudaona iwo mwana, abverana tenepo: “Uyu ndiye anafuna kudya unthaka. Mbatimupheni, unthaka ukhale wathu.” ");
INSERT INTO seh_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Na tenepo, iwo ankwata mbaenda naye kunja kwa munda, mbamupha. Mphapo ndi ninji pinafuna kucita mwanacinthu munda? ");
INSERT INTO seh_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Iye anabwera, mbapha amuna onsene ale, mbakwata munda mbaupasa anyakulima anango. Na tenepo, mbumba mudabva iyo penepyo yalonga kuti: “Penepi mbapileke kucitika!” ");
INSERT INTO seh_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Mbwenye Yezu aalang'anisa mwadidi mwene, mbaabvundza kuti: “Mphapo pisalongeranji pidalembwa mu Bukhu ya Mulungu kuti: ‘Mwala udakhondiwa na anyakumanga nyumba, ndiwo mwala udadza kawangisa nyumba?’ ");
INSERT INTO seh_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Onsene anagwa padzulu pa mwala unowu ananyedzeka, mbwenye ule anagwerwa nawo, anapeeka mbadza pfumbi.” ");
INSERT INTO seh_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Anyakudziwisa a mwambo na akulu aanyantsembe, akhapidziwa kuti nsanje unowu ukhalongera iwo. Penepo pene, iwo akhafuna kum'manga Yezu, mbwenye akhagopa mbumba. ");
INSERT INTO seh_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Na tenepo, atoma kunzonda. Atuma amuna kuti aende kancite mibvundzo, mbakhala ninga anthu anyakuphembera mwadidi, kuti amuone ngakhala anadodomeka pang'ono pa malongero ace, toera iwo akwanise kuona thangwi ya kumpereka m'manja mwa utongi wa ku Roma. ");
INSERT INTO seh_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Amuna enewa ambvundza tenepa: “Mpfundzisi, tisadziwa kuti pire pinalonga imwe na pinapfundzisa imwe, ndimo mwene.Tisadziwambo pontho kuti imwe nkhabe kutonga mbamulang'ana makhaliro a munthu. Mbwenye musapfundzisa njira ya Mulungu mwakulungama.” ");
INSERT INTO seh_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Apo tipangeni: “Pisatawiriswa kulipa nsonkho kuna mambo wa ku Roma, peno nkhabe?” ");
INSERT INTO seh_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Mbwenye Yezu, na kupidziwa pya uthambi pikhanyerezera iwo, alonga tenepa: ");
INSERT INTO seh_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ndipangiseni kobiri ibodzi. Dzina iyi na nkhope iyi idaikhwa penepo nja ani?” Iwo atawira kuti: “Nja mambo wa ku Roma!” ");
INSERT INTO seh_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Penepo Yezu aapanga tenepa: “Pya mambo, pasani mambo. Pya Mulungu, pasani Mulungu.” ");
INSERT INTO seh_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Iwo acimwana kuona mafala a kumphata nawo pa maso pa anthu. Na tenepo, amatama, mbadzumatirwa na matawiriro adacita Yezu. ");
INSERT INTO seh_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Asadhusi anango, ale akhapfundzisa kuti anthu nkhabe kulamuka pa kufa, afika dhuzi na Yezu, mbalonga tenepa: ");
INSERT INTO seh_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Mpfundzisi, Mozesi atisiyira mwambo udalembwa tenepa: “Mamuna angafa, mbakhonda kusiya mwana, m'bale wace wa mamuna asatongwa ankwate manferwa wa nkazi, acite naye banja, toera abale naye ana, ansiyire dzindza.” ");
INSERT INTO seh_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Apo akhalipo amuna anomwe mu ubale mwawo. Wa kutoma, asemba nkazi mbacita banja, mbafa mbakhonda kunsiya na ana. ");
INSERT INTO seh_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Waciwiri, ");
INSERT INTO seh_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","na wa citatu, na anango, acitikambo naye banja. Onsene pa unomwe pawo afa mbakhonda kunsiya na ana. ");
INSERT INTO seh_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pa kumalisira nkazi adza kafambo. ");
INSERT INTO seh_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Mphapo, pa ntsiku ya kulamuka kwa anyakufa, nkazi unowu anadza kakhala wa ani pa amuna enewa anomwe? Thangwi onsene akhadacita naye banja. ");
INSERT INTO seh_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yezu atawira tenepa: “Pantsi pano, ndipo panacita amuna mabanja, akazi mbaperekwa m'mabanja. ");
INSERT INTO seh_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Mbwenye anthu ale adakwanira kuti apite ku dziko ya kudzulu mbalamuka pa kufa, nkhabe kudza kacitabve banja, peno perekwa m'mabanja.” ");
INSERT INTO seh_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Thangwi anadza kakhala ninga maanju, pontho hanadza kafabve tayu. Anakhala ana a Mulungu, thangwi ndi anthu a kulamuka pa kufa. ");
INSERT INTO seh_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Pontho Mozesi apipangiza kale, padalemba iye pa thangwi ya thundudzi, mbacemera Mbuya kuti ndi Mulungu wa Abharaamu, Mulungu wa Izaki, na wa Djakobo. ");
INSERT INTO seh_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Penepi pisapangiza kuti Mulungu ndi Mulungu wa amaso, si Mulungu wa anyakufa tayu. Thangwi kuna Iye onsene ali m'maso. ");
INSERT INTO seh_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Anyakudziwisa anango a mwambo alonga tenepa: “Mwatawira mwadidi Mpfundzisi!” ");
INSERT INTO seh_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Penepo nkhabe munthu unango akhakhala na cipapu ca kumbvundzisa pontho. ");
INSERT INTO seh_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Na tenepo, Yezu aabvundza kuti: “Pisalongerwanji kuti Kirixtu ndi Mwana wa Dhavidhi?” ");
INSERT INTO seh_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Thangwi iye ene Dhavidhi alonga m'bukhu ya Masalimu tenepa: “Mbuya alonga kuna Mbuya wanga kuti: Khala pantsi, ku khundu ya nkono wanga wa madyo, ");
INSERT INTO seh_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mpaka pana ikha ine anyamalwa ako pantsi pa manyalo ako, ninga cinthu cakupondera.” ");
INSERT INTO seh_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Na tenepo, ngakhala Dhavidhi asancemera “Mbuya,” anakhala tani pontho mwana wace? ");
INSERT INTO seh_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yezu mukhabveserwa Iye na mbumba yonsene, apanga anyakupfundza ace kuti: ");
INSERT INTO seh_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Citani mphole na anyakudziwisa a mwambo. Iwo asafuna kufamba na nguwo za ntengo ukulu, pontho asakomerwa pikulu kakamwe kumwanyikwa mu mphambano, na kukhala m'mipando ya kutoma mu nyumba za kuphembera, na mbuto za kulemebza m'maphwandu. ");
INSERT INTO seh_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Asatapata pinthu pya akazi adaferwa na amuna awo, mbaadhoba na maphembero a kulapha kakamwe. Anthu enewa, anati athabuswe pikulu kakamwe. ");
INSERT INTO seh_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yezu alang'ana mbaona apfumi mbakhaikha miyoni yawo n'combo cinaikhirwa miyoni. ");
INSERT INTO seh_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Mwenemu Yezu aonambo nkazi m'bodzi wakucherenga adaferwa na mamuna wace, mbaikhambo pikobiri pyace piwiri. ");
INSERT INTO seh_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Penepo Yezu alonga kuti: “Ndimo mwene, Ine ndisakupangani kuti nkazi uyu wakucherenga apasa pikulu kakamwe kupita onsene. ");
INSERT INTO seh_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Thangwi onsene awa abulusa mbasala na pinango. Mbwenye nkazi uyu, na ucherengi wace onsene, abulusa pyonsene pikhakhala na iye, pikhafuna kumpulumusa.” ");
INSERT INTO seh_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Anthu anango akhalonga na thangwi ya kubalikiswa kudacitwa Nyumba ya Mulungu na myala yadidi ya kubalika, pontho na miyoni ikhaperekwa kuna Mulungu. Mbwenye Yezu alonga kuti: ");
INSERT INTO seh_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Zinafika ntsiku kuti pyonsene ipi pinaona imwe, pinati pibodolwe. Nkhabe mwala ubodzi unafuna sala padzulu pa unango. ");
INSERT INTO seh_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Penepo iwo atoma kumbvundzisa Yezu kuti: “Mpfundzisi, penepyo pinacitika lini? Pontho ndi cidzindikiro canji cinafuna kudza kaoneka, toera kupangiza n'dzidzi unafuna kucitika pinthu penepyo?” ");
INSERT INTO seh_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yezu aatawira kuti: “Cenjerani toera mukhonde kunyengezwa na anthu. Thangwi azinji anati abwere na dzina yanga mbalonga kuti: ‘Ine ndine Misiya,’ pontho ‘wafika n'dzidzi.’ Lekani kuatowerera. ");
INSERT INTO seh_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Pontho lekani kugopa mungabva mbapilongwa pya nkhondo na pya kusandukirana. Thangwi pinthu penepyo pisafunika kuti picitike pa kutoma. Mbwenye si kulongera kumala kwa pantsi kunafikiratu n'dzidzi unowu tayu.” ");
INSERT INTO seh_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Na tenepo, Yezu athimiza na kulonga kuti: “Dzindza na dzindza inadza kamenyana. Pontho dziko na dziko inadza kamenyana. ");
INSERT INTO seh_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Mu mbuto zizinji munadza kabveka piteketeke, njala na miliri. Pontho pinadza kaoneka pinthu pya kugopsa, na kuonekambo pidzindikiro pizinji kudzulu. ");
INSERT INTO seh_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Mbwenye pinthu pyonsene ipi mbapidzati kucitika, munazondiwa mbamumangwa. Na tenepo, munatongiwa m'manyumba a kuphembera, pontho mbakufungirani n'kaidi. Pontho imwe munati muperekwe m'manja mwa amambo na atongi, na thangwi ya dzina yanga. ");
INSERT INTO seh_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Penepyo pinakucitani kuti imwe mukhale na n'dzidzi wa kundilongera umboni. ");
INSERT INTO seh_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mbwenye Khurudzikani. Lekani kunentseka na kusaka kuti munadza kaitawira tani miseru yanu. ");
INSERT INTO seh_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Thangwi ine ndinakupasani mafala na ndzeru za kuti iwo anyamalwa anu onsene, anacimwana kukupokanyani peno kukukonesani. ");
INSERT INTO seh_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Imwe munati musandukirwe na ababanu, abale anu, na abale a dzindza, na axamwali. Pontho andzanu anango anati aphiwe na iwo. ");
INSERT INTO seh_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Anthu onsene anati akuideni na thangwi yanga. ");
INSERT INTO seh_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mbwenye nkhabe tsisi ibodzi ya munsolo mwanu inafuna kutaika. ");
INSERT INTO seh_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mungawangisira, munapulumuka. ");
INSERT INTO seh_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Mphapo mungaona nzinda wa Djerusalema mbuzungulirwa na anyakhondo, dziwani kuti iwo uli dhuzi na kufudzika. ");
INSERT INTO seh_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Na tenepo, ale anagumanika mu Djudeya, mbathawire m'mapiri. Anagumanika mu nzinda mbabuluke. Alembo anagumanika m'minda, mbaleke kupita mu nzinda. ");
INSERT INTO seh_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Thangwi ntsiku zenezo ndi za nyatwa, toera pisimbiswe pyonsene pidalembwa m'Bukhu ya Mulungu. ");
INSERT INTO seh_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ntsiku zenezi zinati zikhale za nyatwa ikulu kuna ale amai ana pa thupi, na ale ana yamwisa ana! Thangwi kunaoneka kutsukwala kukulu pa dziko, pontho Mulungu anadzesa nyatwa ikulu kakamwe kuna mbumba eneyi. ");
INSERT INTO seh_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Azinji anati aphiwe na tarasada, anango anakwatiwa mbaendeswa madziko onsene a pantsi ninga anyan'kaidi. Pontho mbumba idakhonda kukhala madjuda inati itapate dziko ya Djerusalema, mpaka kufikira wamala n'dzidzi wawo wa kutapata. ");
INSERT INTO seh_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Pinaoneka pidzindikiro pa dzuwa, pa mwezi na pa nyenyezi. Pontho pantsi pano madziko onsene anatsukwala mbagopa na kutitimira kukulu kwa mabimbi a m'bara. ");
INSERT INTO seh_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Anthu azinji anati akomoke na kugopa pire pinafuna kudza kacitika pa dziko. Thangwi mphambvu za kudzulu zinatekenyeka. ");
INSERT INTO seh_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Na tenepo, anthu anati andione Ine Mwana wa Munthu mbandicita padzulu pa khole na mphambvu, na mbiri ikulu. ");
INSERT INTO seh_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Pinthu penepyo pingatoma kucitika, khalani dzololo mulamuse misolo yanu mulang'ane kudzulu, thangwi muli dhuzi na kupulumuswa.” ");
INSERT INTO seh_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Pakumala kulonga penepyo Yezu alonga nsanje uyu: “Lang'anani muti wa nsambvu na miti inango yonsene. ");
INSERT INTO seh_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Mungaiona mbitoma kuphwikira masamba ace, imwe ene musadziwiratu kuti malimwe ali dhuzi. ");
INSERT INTO seh_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Tenepambo, mungapyona pinthu penepyo mbapicitika, dziwanimbo kuti Umambo wa Mulungu uli dhuzi.” ");
INSERT INTO seh_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ndimo mwene, ine ndisakupangani kuti pyonsene ipi pinati picitike, anthu a ntsiku za lero mbadzati kumala. ");
INSERT INTO seh_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kudzulu na pantsi panamala, mbwenye mafala anga cipo anadza kamala. ");
INSERT INTO seh_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Yezu amalisira na kulonga kuti: “Cenjerani! Lekani kudzudzumika na maphwandu a pa dziko, peno na pya kuledzeresa, peno na pinthu pinango pya dziko ino, toera mukhonde kututumuswa nayo ntsiku eneyo ingafika. ");
INSERT INTO seh_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Thangwi ntsiku eneyo inadzera anthu onsene a pantsi pano. ");
INSERT INTO seh_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Na tenepo, lang'anirani midzidzi yonsene mbamuphembera, toera mukhonde kugumana napyo pyonsene pinafuna kucitika, pontho mukhale dzololo pa maso pa Ine Mwana wa Munthu.” ");
INSERT INTO seh_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yezu akhapfundzisa anthu ntsiku zonsene mu Nyumba ya Mulungu. Mbwenye na masiku akhaenda kakhala pa phiri ya Mulivera mpaka mangwana mwace. ");
INSERT INTO seh_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Na macibese ene, mbumba yonsene ikhaenda kuna Yezu, mu Nyumba ya Mulungu kwenda kambvesera. ");
INSERT INTO seh_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ikhali dhuzi phwandu ya Paxkwa, inacemerwa phwandu ya mikate ya kukhonda kuphikwa na mitombwe ya kutupisa. ");
INSERT INTO seh_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Akulu aanyantsembe, na anyakudziwisa a mwambo, akhasaka kuti anampha tani Yezu, thangwi iwo akhagopa mbumba. ");
INSERT INTO seh_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Na tenepo, Sathani apita muna Djuda anacemerwa Xikaryote, m'bodzi wa anyakupfundza khumi na awiri a Yezu. ");
INSERT INTO seh_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Apo iye Djuda aenda kaonana na akulu aanyantsembe, na atsogoleri a anthu anaonera Nyumba ya Mulungu, mbabverana nawo njira ya kumpereka Yezu m'manja mwawo. ");
INSERT INTO seh_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Penepo, iwo akomerwa pikulu kakamwe mbabverana kuti anampasa kobiri. ");
INSERT INTO seh_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Djuda apitawirira mbatoma kusaka n'dzidzi wa kunsandukira Yezu, mbumba mbikhonda kupidziwa. ");
INSERT INTO seh_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Na tenepo, yafika ntsiku ya phwandu ya mikate ya kusoweka ntombwe wa kutupisa, ntsiku ikhatongwa madjuda kupha bira ya Paxkwa. ");
INSERT INTO seh_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yezu atuma Pedhru na Juwau mbaapanga kuti: “Ndokoni mukatisasanyire cinafuna ife kudya pa Paxkwa.” ");
INSERT INTO seh_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Mphapo iwo abvundzisa kuti: “Mbuya, musafuna kuti tiende kaisasanyire kupi?” ");
INSERT INTO seh_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yezu aatawira tenepa: “Mungapita mu nzinda, munagumana na mamuna m'bodzi na nkhali yace ya madzi. Imwe ntowereni mpaka n'nyumba inapita iye.” ");
INSERT INTO seh_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Penepo munampanga mwanacinthu nyumba kuti: “Mpfundzisi asabvundzisa kuti ndi ipi mbuto inafuna dyera Iye phwandu ya Paxkwa na anyakupfundza ace?” ");
INSERT INTO seh_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Iye anakupangizani mbuto ibodzi ikulu ya ndzulu idamala kupakwa na pyombo pyonsene. Mwenemu sasanyirani phwandu ya Paxkwa. ");
INSERT INTO seh_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Anyakupfundza ace aenda, mbagumana pyonsene ninga mudaapangira Yezu. Na tenepo, iwo atoma kusasanyira phwandu ya Paxkwa. ");
INSERT INTO seh_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pidakwana iwo n'dzidzi, Yezu aenda kadya na atumwi ace khumi na awiri. ");
INSERT INTO seh_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Penepo aapanga tenepa: “Ande, ndikhafunadi pikulu kakamwe kudya na imwe pabodzi phwandu iyi ya Paxkwa, mbandidzati kuona nyatwa! ");
INSERT INTO seh_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Thangwi ndisakupangani kuti, cipo Ine ndinadza kadya pontho phwandu iyi, mpaka ntsiku inafuna kudza kacitika iyo mu Umambo wa Mulungu.” ");
INSERT INTO seh_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Penepo, Yezu akwata ndiko ya vinyu, mbapereka takhuta kuna Mulungu, mbalonga kuti: “Kwatani ici, gawanani monsene. ");
INSERT INTO seh_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Thangwi Ine ndisakupangani kuti, cipo Ine ndinadza kamwa pontho vinyu iyi, mpaka ntsiku inafuna kudza kafika Umambo wa Mulungu.” ");
INSERT INTO seh_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Pakumala penepyo, akwata nkate mbapereka takhuta kuna Mulungu. Pidamala Iye aumenya, mbaupasa anyakupfundza ace mbalonga kuti: “Ici ndi manungo anga anaperekwa na thangwi yanu. Citani ipi toera mundikumbukire.” ");
INSERT INTO seh_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Pidamala iwo siyali, acita pibodzi-bodzi. Akwata ndiko, mbalonga tenepa: “Ndiko iyi ndi cibverano cipsa mu ciropa canga, cidacololekera na thangwi yanu. ");
INSERT INTO seh_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Mbwenye lang'anani, ule anafuna kundisandukira, ali pano na Ine pa thando ya kudya. ");
INSERT INTO seh_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ndimo mwene, Ine Mwana wa Munthu ndinati ndife, ninga mudapitongera Mulungu. Mbwenye nyatwa ntsace ule anandisandukira!” ");
INSERT INTO seh_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Penepo anyakupfundza ace atoma kubvundzana okha-okha kuti: “Mbani pakati pathu anafuna kunsandukira?” ");
INSERT INTO seh_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Pontho pakati pa anyakupfundza a Yezu paonekambo mphoka inango, ya kufuna kudziwa mbani nkulu pakati pawo. ");
INSERT INTO seh_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yezu aapanga tenepa: “Amambo a dziko ino, ana mphambvu za kuponderera mbumba. Pontho ale anatonga, asafuna kuti acemerwe anthu adidi.” ");
INSERT INTO seh_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mbwenye imwe si tenepo tayu. Pisatongwa kuti nkulu pakati panu akhale ninga mwana, pontho ntongi akhale ninga nyabasa. ");
INSERT INTO seh_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mphapo mbani nkulu? Ndi ule anakhala pa thando ya kudya, peno ndi ule anandzesera ca kudya? Ande, ndi ule anakhala pa thando ya kudya. Mbwenye pakati panu Ine ndakhala ninga ule anadzesa ca kudya pa thando. ");
INSERT INTO seh_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Imwe ndimwe munakhala na ine pabodzi pa kuleserwa kwa nyatwa zanga. ");
INSERT INTO seh_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Na tenepo, thangwi Baba wanga andipasa umambo, Ine ndinakupasanimbo umambo ubodzi-bodzi, ");
INSERT INTO seh_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","toera imwe mukwanise kudya mbamumwa pa thando yanga ya kudya, n'kati mwa Umambo wanga, na kukhala m'mipando ya umambo, mbamutonga madzindza khumi na mawiri a Izaraeli. ");
INSERT INTO seh_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yezu athimiza na kulonga kuti: “Simau, Simau. Sathani aphemba kuti akupepeteni ninga tirigu. ");
INSERT INTO seh_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Mbwenye Ine ndakuphemberera kuna Mulungu kuti kukhulupira kwako kukhonde kumala. Na tenepo, ungazungunuka pontho kuna Ine mbundikhulupira, apasembo mphambvu abale ako.” ");
INSERT INTO seh_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Mbwenye Pedhru antawira kuti: “Ine ndiri dzololo kuti ndipite n'kaidi, na kufa pabodzi na imwe.” ");
INSERT INTO seh_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yezu ampanga kuti: “Pedhru, Ine ndinakupanga kuti lero ene, iwe unati undikhonde katatu, kuti nkhabe kundidziwa, dzongwe mbidzati kulira.” ");
INSERT INTO seh_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Na tenepo, Yezu aabvundza anyakupfundza ace kuti: “Kodi pidakutumani Ine mbamukhonda kukwata cikhwama, peno budu, peno nsapato, ciripo cikhadasowa imwe?” Iwo antawira kuti: “Nkhabe!” ");
INSERT INTO seh_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Mbwenye Yezu aapanga kuti: “Mphapo cincino, ule ana cikhwama peno budu, mbaikwate. Pontho ule adasowa tarasada, mbagulise kapoti yace, toera na kobiri eneyo agule nayo tarasada ibodzi.” ");
INSERT INTO seh_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Thangwi Bukhu ya Mulungu yalonga tenepa: “Iye alengeswa ninga m'bodzi wa mapanga.” Apo Ine ndisakupangani kuti penepyo pisatongwa pisimbiswe muna Ine. Ande, pidalembiwa na thangwi yanga, pisafuna pisimbiswe. ");
INSERT INTO seh_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Penepo anyakupfundza ace ampanga tenepa: “Mbuya, tinawo pano matarasada mawiri.” Yezu aatawira kuti: “Akwana!” ");
INSERT INTO seh_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yezu abuluka mbaenda pa phiri ya mulivera, pabodzi pene na anyakupfundza ace, ninga nsambo wace. ");
INSERT INTO seh_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pidafika iye pa mbuto eneyo, Yezu aapanga anyakupfundza ace kuti: “Phemberani, kuti mukhonde kugwa m'manyengerero a kuipa.” ");
INSERT INTO seh_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Na tenepo, Yezu aenda pang'ono pa khundu, nsindzo unakwana dhuzi na mathanyo makumatatu. Penepo, agodama mbatoma kuphembera, ");
INSERT INTO seh_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","mbalonga tenepa: “Baba, mungafuna ndibulusireni ndiko iyi ya nyatwa! Mphapo lekani kucita kufuna kwanga, mbwenye kufuna kwanu.” ");
INSERT INTO seh_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Na tenepo, anju wa kudzulu abulukira mbampasa mphambvu. ");
INSERT INTO seh_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yezu pakati pa kutsukwala kukulu, atoma kuphembera na mphambvu zonsene. Penepo akhabuluka kaluma, mbikhadjodja pantsi ninga mathoto a ciropa. ");
INSERT INTO seh_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pakumala kuphembera, Yezu alamuka mbaenda kuna anyakupfundza ace. Penepo, aagumana mbakhagona na thangwi ya kutsukwala. ");
INSERT INTO seh_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Na tenepo, Iye aabvundza kuti: “Thangwi yanji musagona?” Lamukani muphembere toera mukhonde kugwa m'manyengerero a kuipa. ");
INSERT INTO seh_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yezu mbadzati kumala kulonga, wafika mwinji wa anthu, ukhatsogolerwa na Djuda, m'bodzi wa anyakupfundza khumi na awiri a Yezu. Iye afika dhuzi na Yezu toera kumpsompsona. ");
INSERT INTO seh_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Mbwenye Yezu ampanga kuti: “Kodi iwe Djuda, usandigulisa Ine Mwana wa Munthu na mpsompsono?” ");
INSERT INTO seh_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ale akhakhala na Yezu, pidaona iwo pikhafuna kucitika, alonga tenepa: “Mbuya, tiateme na matarasada?” ");
INSERT INTO seh_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","M'bodzi wawo aphekesa nyabasa wa nkulu wa anyantsembe, mban'gwanda khutu ya madyo. ");
INSERT INTO seh_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Mbwenye Yezu atawira kuti: “Siyani, pyakwana.” Mbakhuya khutu ya mamuna, mbamuwangisa. ");
INSERT INTO seh_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Penepo Yezu abvundza kuna akulu aanyantsembe, kuna akulu anyakuonera Nyumba ya Mulungu, na kuna atsogoleri a madjuda akhadza mbansaka, kuti: “Thangwi yanji mwabwera na matarasada, na miti, ninga ndine phanga? ");
INSERT INTO seh_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ine ndikhakhala na imwe ntsiku zonsene mu Nyumba ya Mulungu, mbwenye imwe mudandiphata tayu. Apo uno ndiwo n'dzidzi wanu na wa mphambvu za cidima.” ");
INSERT INTO seh_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Na tenepo, am'manga mbankwata mbaenda naye ku nyumba ya nkulu wa anyantsembe, Pedhru mbakhantowera na kutali. ");
INSERT INTO seh_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Mbwenye mudagasa iwo moto pakati pa thando onsene mbakhala pantsi, Pedhru akhalambo pantsi nawo pabodzi. ");
INSERT INTO seh_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nyabasa m'bodzi wa nkazi, amuona Pedhru mbakhaotha moto. Iye amulang'anisisa mbalonga tenepa: “Mamuna uyu akhali pabodzi na Yezu.” ");
INSERT INTO seh_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Mbwenye Pedhru akhonda, mbalonga kuti: “Nkaziwe, ine nkhabe kun'dziwa.” ");
INSERT INTO seh_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Thimize pang'ono, munthu unango amuona mbalonga tenepa: “Iwe ndiwembo m'bodzi wawo.” Pedhru antawira kuti: “Mamunawe, sine tayu!” ");
INSERT INTO seh_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Mudapita n'dzidzi ubodzi, unango alonga tenepa: “Ndimo mwenedi, mamuna uyu akhali naye pabodzi, thangwi ndi wa kugalileyambo.” ");
INSERT INTO seh_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pedhru atawira tenepa: “Mamunawe, ine nkhabe kupidziwa pinalonga iwe.” Mukhalonga iye penepyo, dzongwe ya lira. ");
INSERT INTO seh_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Mbuya azungunuka mbalang'anisisa Pedhru. Penepo Pedhru akumbuka fala ikhadapangwa iye na Mbuya kuti: “Lero, dzongwe mbidzati kulira, iwe unandikhonda katatu.” ");
INSERT INTO seh_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pedhru abuluka penepo mbalira pikulu kakamwe. ");
INSERT INTO seh_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Amuna akhaonera Yezu, atoma kunsingirira mbakham'menya. ");
INSERT INTO seh_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Akhanfunga maso ace, mbakhambvundza kuti: “Cincino iwe mporofeta, lotera! Mbani adakumenya?” ");
INSERT INTO seh_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Iwo akhamulongera mafala anango mazinji akuxola. ");
INSERT INTO seh_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pidaca kunja, agumanyikana akulu-akulu a mbumba, na anango akulu aanyantsembe, na anyakudziwisa a mwambo, mbadzesa Yezu mu nyumba ya kutongera miseru. ");
INSERT INTO seh_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Iwo ambvundzisa kuti: “Ngakhala iwe ndiwe Kirixtu, tipange.” Penepo Yezu aatawira tenepa: “Ndingakupangani, imwe nkhabe kunditawira. ");
INSERT INTO seh_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Pontho ine ndingakubvundzani, imwe nkhabe kunditawira mbvundzo wanga. ");
INSERT INTO seh_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Mbwenye kutomera cincino mpaka kutsogolo, Ine Mwana wa Munthu, ndinati ndikhale ku nkono wa madyo wa Mulungu wa mphambvu.” ");
INSERT INTO seh_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Onsene ambvundza kuti: “Na tenepo, iwe ndiwe Mwana wa Mulungu?” Iye aatawira tenepa: “Imwe ndimwe munalonga kuti ine ndine.” ");
INSERT INTO seh_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Na tenepo, iwo alonga kuti: “Tisafuniranji pontho amboni anango? Tamala kubva tekha mbalonga na mulomo wace.” ");
INSERT INTO seh_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Na tenepo, nsoka wawo onsene walamuka, mbakwata Yezu mbaenda naye kuna Piratu. ");
INSERT INTO seh_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Kweneko atoma kumpambazira kuti: “Mamuna uyu tamphata mbakhanyengerera mbumba yathu kuti icite cikuti, mbakhaikhondesa kuti ileke kubulusa nsonkho kuna mambo wa ku Roma, mbakhalonga kuti iye ndi Kirixtu Mambo.” ");
INSERT INTO seh_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Penepo Piratu abvundza Yezu kuti: “Iwe ndiwe mambo wa madjuda?” Yezu atawira tenepa: “Ndimwe analonga penepi.” ");
INSERT INTO seh_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Na tenepo, Piratu alonga kuna akulu aanyantsembe na kuna mbumba kuti: “Nkhabe thangwi idaona ine kuti ndikonese nayo mamuna uyu.” ");
INSERT INTO seh_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Mbwenye iwo akhathimiza basi na kulonga kuti: “Iye asakuwizira mbumba mu Djudeya muno monsene na mapfundzisiro ace, kuti icite cikuti, kutomera ku Galileya mpaka kuno.” ");
INSERT INTO seh_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Piratu na kubva dzina ya Galileya, abvundzisa ngakhala Yezu ngwa ku Galileya. ");
INSERT INTO seh_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Mudabva iye kuti Yezu ngwa ku cisa cinatongwa na Erodhi, amuendesa kuna Erodhi, thangwi Erodhi n'dzidzi unowu akhalimbo mu Djerusalema. ");
INSERT INTO seh_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Erodhi mudaona iye Yezu akomerwa pikulu kakamwe, thangwi akhamubva mbakhalongwa, mbamala ntsiku zizinji mbakhasaka kuti amuone. Iye akhafuna kuti amuone mbacita cirengo cibodzi. ");
INSERT INTO seh_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Na tenepo, ambvundza pinthu pizinji, mbwenye Yezu nkhabe cibodzi cidatawira iye. ");
INSERT INTO seh_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Akulu aanyantsembe, na anyakudziwisa a mwambo akhakhalambo penepo, mbakhampambazira pinthu pikulu. ");
INSERT INTO seh_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Na tenepo, Erodhi, pabodzi na anyankhondo ace, atoma kunsingirira Yezu mbakhampwaza. Ambvazika nguwo za kubalika mbam'bweza pontho kuna Piratu. ");
INSERT INTO seh_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Erodhi na Piratu akhali anyamalwa, mbwenye kubulukira ntsiku eneyo, adza kakhala axamwali. ");
INSERT INTO seh_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Piratu acemeresa akulu aanyantsembe, na atsogoleri a madjuda, na mbumba, ");
INSERT INTO seh_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","mbaapanga tenepa: “Imwe mwandidzesera mamuna uyu mbamulonga kuti akhakuwizira mbumba kuti icite cikuti. Mbwenye ine ndambvundzisa kazinji kene pa maso panu, nkhabe thangwi ibodzi idagumana ine, pa pyonsene pinansumira imwe. ");
INSERT INTO seh_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Na iyembo Erodhi nkhabe thangwi ibodzi idagumana iye. Na thangwi eneyo am'bweza pontho kuna ife. Na tenepo, pisapangiza kuti mamuna uyu nkhabe cibodzi cidacita iye, kuti aphiwe naco. ");
INSERT INTO seh_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Na mwenemu, ine ndinankwapulisa na michamu, ndingamala ndinansiya mbaenda pyace.” ");
INSERT INTO seh_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Piratu akhali na nsambo wace wa kukhuca munthu m'bodzi n'kaidi, pa phwandu ya Paxkwa. ");
INSERT INTO seh_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Mbwenye anthu onsene akhuwa pabodzi pene, mbalonga tenepa: “Mbaphiwe! Tibulusirene Bharabhasi!” ");
INSERT INTO seh_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Bharabhasi akhadafungirwa n'kaidi na thangwi ya cikuti cikhadacitika mu nzinda, pontho iye akhadapha munthu. ");
INSERT INTO seh_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Piratu, na kufuna kubulusa Yezu, alonga pontho na mwinji wa anthu. ");
INSERT INTO seh_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Mbwenye iwo athimiza na kukhuwa kuti: “Nkhomereni pa ntanda! Nkhomereni pa ntanda!” ");
INSERT INTO seh_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Kacitatu, Piratu athimiza na kuapanga kuti: “Ndi pyanji pya kuipa pidacita munthu uyu? Ine nkhabe kuona thangwi kuti Iye aphiwe nayo. Ndinankwapulisa, ndingamala ndinsiye aende pyace.” ");
INSERT INTO seh_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Mbwenye iwo athimiza na kukhuwa na mphambvu kuti Yezu akhomerwe. Penepo iwo kukhuwa kwawo kwakunda. ");
INSERT INTO seh_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Na tenepo, Piratu aatawirisa kuti acite kufuna kwawo. ");
INSERT INTO seh_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Piratu abulusa ule akhafuna iwo, akhadafungirwa n'kaidi na thangwi ya cikuti, pontho na thangwi ya kupha munthu, mbaapasa Yezu ninga mukhafunira iwo. ");
INSERT INTO seh_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Mukhankwata iwo, akakamiza mamuna m'bodzi akhacemerwa Simau, wa dziko ya Sirene, akhabuluka kumunda, mbankwatisa ntanda pa phewa pace toera aende nawo n'nduli mwa Yezu. ");
INSERT INTO seh_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Mwinji wa anthu ukhantowera, pabodzi na akazi akhadungunya mbakhalira na thangwi yace. ");
INSERT INTO seh_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Na tenepo, Yezu azungunuka kuna akazi mbaapanga kuti: “Akazi a Djerusalema! Lekani Kundilira. lirikani mwekha na ananu!” ");
INSERT INTO seh_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Thangwi unafika n'dzidzi unadza kafuna imwe longa kuti: “Mbatsandzaye akazi adakhonda paswa kubala, pontho na zimimba zidakhonda kubala ana, na mabere a kuti cipo adzati kuyamwisa!” ");
INSERT INTO seh_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Na tenepo, anati alonge kuna mapiri kuti: “Tigwereni.” Pontho analonga kuna pimapiri kuti: “Tigudumireni!” ");
INSERT INTO seh_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Thangwi ngakhala asacita ipi na muti uwisi, ndiye tani kuna muti wa kuuma? ");
INSERT INTO seh_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Akwatiwambo amuna awiri, mapanga, kuti aende kaphiwe pabodzi na Yezu. ");
INSERT INTO seh_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Mudafika iwo pa mbuto inacemerwa Kavera, ankhomera penepo pabodzi pene na mapanga. M'bodzi khundu yace ya madyo, m'bodzi khundu yace ya bzere. ");
INSERT INTO seh_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Penepo Yezu alonga kuti: “Baba, alekerereni, thangwi nkhabe kupidziwa pinacita iwo.” Na tenepo, iwo pakumala kumenya cibutha, agawana nguwo za Yezu. ");
INSERT INTO seh_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mbumba ikhakhala penepo, ikhalang'anisa pyonsene pire. Atsogoleri a madjuda akhasingirira Yezu mbalonga tenepa: “Iye apulumusa anango, mbapulumusikembo ekha ngakhala ndiyedi Kirixtu adasankhulwa na Mulungu.” ");
INSERT INTO seh_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Anyankhondo akhansingirirambo. Iwo akhafika dhuzi na Yezu mbakhampasa vinyu ya kudjamuka, ");
INSERT INTO seh_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","mbalonga tenepa: “Ngakhala iwe ndiwe mambo wa madjuda, pulumusika wekha ene!” ");
INSERT INTO seh_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Pa ntanda, padzulu pa nsolo wace, pakhadalembwa mafala awa: “UYU NDI MAMBO WA MADJUDA.” ");
INSERT INTO seh_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","M'bodzi wa mapanga akhadakhomerwa pa ntanda, akhatikanambo Yezu mbalonga tenepa: “Iwe siwe Kirixtu tayu? Pulumusika mphapo wekha, mbupulumusambo ife!” ");
INSERT INTO seh_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mbwenye ndzace ansandika mbalonga tenepa: “Iwe nkhabe gopa Mulungu? Iwe uli kuthabuswa sawa-sawa ninga iye. ");
INSERT INTO seh_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ife tina thangwi ya kuthabuswa nayo. Mbwenye iye nkhabe ca kuipa cibodzi cidacita iye.” ");
INSERT INTO seh_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Na tenepo, alonga kuna Yezu kuti: “Mbuya, ndikumbukirenimbo mungadza kapita mu Umambo Wanu!” ");
INSERT INTO seh_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yezu atawira tenepa: “Ndimo mwene ndisakupanga kuti lero, iwe unadza kakhala na ine m'paraizu.” ");
INSERT INTO seh_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Dhuzi na n'dzidzi utatu wa kumaulo, dziko yonsene yagudumirwa na cidima cikulu, mpaka kufikira n'dzidzi utatu wa ku maulo. ");
INSERT INTO seh_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Dzuwa ya thima, nguwo ikhasitira mbuto ya Mulungu n'Nyumba ya Mulungu, yapanduka pakati-nakati. ");
INSERT INTO seh_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Penepo, Yezu akhuwa na mphambvu, mbalonga tenepa: “Baba ndiri kupereka nzimu wanga m'manja mwanu.” Mudamala iye kulonga penepyo, afa. ");
INSERT INTO seh_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nkulu wa anyakhondo a ku Roma, mudaona iye pidacitika, apasa mbiri Mulungu mbalonga tenepa: “Ndimo mwene, mamuna uyu akhali wakulungamadi!” ");
INSERT INTO seh_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Mbumba yonsene ikhadagumanyikana penepo toera kuona pikhacitika, mudaona iwo penepyo abuluka mbakhamenya cifuwa, na kutsukwala. ");
INSERT INTO seh_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Mbwenye onsene akhandziwa Yezu, na akazi ene akhantowerera kubulukira ku Galileya, akhakhala kutali mbakhalang'anisa pinthu penepi. ");
INSERT INTO seh_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Akhalipo mamuna m'bodzi akhacemerwa Zuze. Iye akhali m'bodzi wa nsoka wa akulu anyakutonga miseru, munthu wadidi na wakulungama. ");
INSERT INTO seh_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Iye akhadakomerwa tayu na kugwandiwa kwa nseru, pontho na pidacita andzace. Zuze akhali wa ku nzinda wa Arimateya, ku Djudeya, iye akhadikhira Umambo wa Mulungu ");
INSERT INTO seh_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Iye aenda kuna Piratu kaphemba manungo a Yezu. ");
INSERT INTO seh_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Na tenepo, aabulusa manungo a Yezu pa ntanda, mbaafinikiza na nguwo yadidi ya kucena. Penepo aaikha nthumbi ibodzi ikhadakumbwa pa mwala, kuti cipo ikhadadzati kuikhwa munthu. ");
INSERT INTO seh_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Penepi pyacitika ntsiku ya cixanu, ntsiku ya kusasanyira, thangwi Sabudu ikhafuna kutoma. ");
INSERT INTO seh_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Akazi akhaperekera Yezu kubulukira ku Galileya, aenda pabodzi na Zuze mbaonambo kuikhwa kudacitwa manungo a Yezu n'nthumbi. ");
INSERT INTO seh_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Buluka penepo, abwerera mbaenda ku nyumba kwawo kasasanyira mafuta akununkhira, toera akhadzodze manungo a Yezu. Mbwenye n'Sabudu, iwo apuma, ninga mukhalongera mwambo. ");
INSERT INTO seh_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Pa ntsiku ya kutoma ya sumana, m'bambakuca, akazi aenda ku nthumbi ikhadaikhwa Yezu, na mafuta akununkhira akhadasasanyira iwo. ");
INSERT INTO seh_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Iwo agumana mwala wabuluswa pa nthumbi. ");
INSERT INTO seh_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Mbwenye mudapita iwo, hadaagumana manungo a Mbuya Yezu tayu. ");
INSERT INTO seh_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Iwo adzumatirwa napyo, mbacimwana kudziwa pikhafuna iwo kucita. Na mwansanga, aona amuna awiri na nguwo zikhayetimira ninga dzuwa, mbalimira nkhundu mwawo. ");
INSERT INTO seh_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Na kugopa kukhacita iwo, akazi atsolomisa nkhope zawo pantsi, amuna mbaapanga tenepa: “Thangwi yanji imwe musasaka pakati pa anyakufa, munthu ali m'maso?” ");
INSERT INTO seh_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Iye nkhabepo pano! Alamuka pa kufa! Kumbukani pikhakupangani Iye mbali na imwe ku dziko ya Galileya kuti: ");
INSERT INTO seh_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Ine Mwana wa Munthu ndisafunika kuti ndiperekwe m'manja mwa amuna anyakudawa, ndikhomerwe pa nthanda toera ntsiku ya citatu ndilamuke pa kufa.” ");
INSERT INTO seh_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Na tenepo, iwo akumbuka mafala a Yezu. ");
INSERT INTO seh_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Mudabwerera iwo buluka ku nthumbi, akazi alonga pinthu pyonsene ipi kuna anyakutumwa khumi na m'bodzi, na kuna onsene anango. ");
INSERT INTO seh_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Akazi adalonga pinthu penepi kuna atumwi a Yezu ndi awa: Mariya Madhalena, Juwana, Mariya mai wace Tiyagu, na akazi anango akhakhala na iwo. ");
INSERT INTO seh_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mbwenye iwo akhaapokanya akazi. Pikhalonga iwo, akhaabva ninga madzemwa. ");
INSERT INTO seh_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mbwenye Pedhru alamuka, mbathamanga kwenda ku nthumbi. Mudakotama iye aona nguwo basi. Abuluka mbabwerera na kudzumatirwa na pidacitika. ");
INSERT INTO seh_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ntsiku ibodzi ene, anyakupfundza awiri a Yezu akhaenda ku cisa cibodzi cinacemerwa Mausi. Kubulukira ku Mausi mpaka ku Djerusalema, pakhali na nsindzo khumi na ubodzi wa makilometuru. ");
INSERT INTO seh_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Mukhaenda iwo na njira, akhaenda mbalonga na thangwi ya pyonsene pikhadacitika. ");
INSERT INTO seh_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mukhaceza iwo mbakhaketesana, Iye ene Yezu aafendedzera dhuzi mbakhaenda nawo pabodzi. ");
INSERT INTO seh_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Iwo akhamuona, mbwenye akhacimwana kundzindikira. ");
INSERT INTO seh_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yezu aabvundza tenepa: “Mphyanji pinafamba imwe mbumuketesana na njira?” Iwo alimira na kutsukwala. ");
INSERT INTO seh_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","M'bodzi wawo anacemerwa Keleopa, ambvundza kuti: “Ndiwe wekha basi nfambi mu Djerusalema muno, anacimwana kudziwa pinthu pinacitika mwenemu ntsiku zino?” ");
INSERT INTO seh_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Iye abvundzisa kuti: “Pinthu pyanji?” Iwo atawira tenepa: “Pidacitika na Yezu wa ku Nazareti. Iye akhali mporofeta wa mphambvu pa mafala na pa mabasa, patsogolo pa Mulungu na pa anthu onsene. ");
INSERT INTO seh_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Akulu aanyantsembe pabodzi na atongi athu, ampereka toera aphiwe, mbankhomera pa ntanda. ");
INSERT INTO seh_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Na tenepo, ife tikhadikhira kuti Iye ndiye anadza kafuna kuombola Izaraeli. Pontho na lero kwapita ntsiku zitatu penepyo mbapidamala kucitika kale. ");
INSERT INTO seh_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Akazi anango a pa nsoka wathu, lero atitutumusa. Abesa na macibese ene mbaenda ku nthumbi. ");
INSERT INTO seh_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Kweneko iwo hadaagumana manungo ace tayu. Abwerera mbatipanga kuti ninga ndoto, aona maanju adaapanga kuti Yezu ali m'maso. ");
INSERT INTO seh_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Andzathu anango aenda ku nthumbi, mbagumana pyonsene sawa-sawa ninga mukhadapilongera akazi, mbwenye Yezu hadamuona tayu.” ");
INSERT INTO seh_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yezu aapanga tenepa: “Pisakunentsani tani kubvesesa, pontho mbamudembuka na kutawira pire pyonsene pidalongwa na maporofeta! ");
INSERT INTO seh_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kodi pikhafunika tayu kuti Kirixtu aone nyatwa zenezi toera apite mu mbiri yace?” ");
INSERT INTO seh_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Na tenepo, atoma kuapanga pyonsene pidalembwa m'Bukhu ya Mulungu na thangwi yace, kutomera m'mabukhu a Mozesi na m'mabukhu a maporofeta onsene. ");
INSERT INTO seh_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Pakufika dhuzi na cisa cikhaenda iwo, Yezu acita ninga funa apitirire. ");
INSERT INTO seh_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Mbwenye iwo ankakamiza mbampanga kuti: “khalani na ife thangwi n'dzidzi wa pita, dzuwa iri kudoka.” Na tenepo, Iye apita toera akhale na iwo. ");
INSERT INTO seh_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Mukhakhala iwo pa thando ya kudya, Yezu akwata nkate mbapereka takhuta, mbaumenya mbaapasa. ");
INSERT INTO seh_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Na tenepo, maso awo afunguka mbandzindikira, mbwenye Yezu azambazika pa maso pawo. ");
INSERT INTO seh_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Iwo akhalonga okha-okha kuti: “Kodi mukhaabva tayu mafala ace akhagaka m'mitima mwathu ninga moto mukhalonga Iye n'jira, mbakhatipanga pidalembwa m'bukhu ya Mulungu?” ");
INSERT INTO seh_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Iwo alamuka na mwansanga mbabwerera kwenda ku Djerusalema. Kweneko agumana atumwi khumi na m'bodzi na anango akhadagumanyikana, ");
INSERT INTO seh_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","mbakhalonga kuti: “Ndimo mwene! Mbuya alamukadi pa kufa, pontho abulukira kuna Simau!” ");
INSERT INTO seh_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Na tenepo, ale awiri atoma kulonga pire pidaacitikira njira, pontho mbakhalonga kuti afikira tani kundzindikira pa n'dzidzi ukhamenya Iye nkate. ");
INSERT INTO seh_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mukhalonga iwo pinthu penepyo, Iye ene Yezu abulukira pakati pawo mbalonga kuti: “Ntendere mbukhale na imwe!” ");
INSERT INTO seh_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Iwo atutumuka, pontho mbagopa mbanyerezera ninga asaona ciphoko. ");
INSERT INTO seh_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yezu aapanga kuti: Ndi thangwi yanji musadzudzumika, pontho ndi thangwi yanji musapenula m'mitima mwanu? ");
INSERT INTO seh_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Lang'anani manja anga na myendo yanga. Ndine ene! Ndiphateni muone. Nzimu nkhabe nyama pontho nkhabe magogodo ninga kuona kunandicita imwe. Ine ndinapyo. ");
INSERT INTO seh_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Pakumala kulonga penepyo, aapangiza manja ace na myendo yace. ");
INSERT INTO seh_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Na kukhonda kutawira kwawo, na thangwi ya ku dzumatirwa na kukomerwa kukhabva iwo, Yezu abvundza kuti: “Imwe munaco pano cinthu ca kudya?” ");
INSERT INTO seh_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Iwo ampasa phindi ibodzi ya nyama ya kuocha ya m'madzi, ");
INSERT INTO seh_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Iye aikwata mbaidya pa maso pawo. ");
INSERT INTO seh_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Penepo aapanga kuti: “Ndi penepi pikhakupangani ine mbandiri na imwe. Pikhafunika kuti picitike pyonsene pidalembwa na thangwi yanga mu Mwambo wa Mozesi, m'mabukhu a maporofeta na m'mabukhu a Masalimu.” ");
INSERT INTO seh_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Na tenepo, aapasa kudzindikira toera akwanise kubvesesa mwadidi pidalembwa m'Bukhu ya Mulungu. ");
INSERT INTO seh_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Mbaapanga tenepa: “Pyalembwa kuti Kirixtu anati aone nyatwa, mbalamuka pa kufa ingafika ntsiku ya citatu, ");
INSERT INTO seh_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","pontho kuti na dzina Yace, zimwazwe m'madziko onsene, mphangwa za kuchunyuka toera kulekererwa kudawa, kutomera mu Djerusalema. ");
INSERT INTO seh_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Imwe ndimwe amboni a pinthu penepi. ");
INSERT INTO seh_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ine ndinakutumirani cipikiriro ca Baba wanga. Mbwenye khalani mu nzinda mpaka kudzabza na mphambvu za kudzulu.” ");
INSERT INTO seh_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yezu aakwata mbaenda nawo mpaka dhuzi na nzinda wa Bhetanya, kweneko Iye alamusa manja mbaamphemberera. ");
INSERT INTO seh_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Yezu mukhaapasa Iye nkhombo, aasiya, Iye mbakwira kudzulu. ");
INSERT INTO seh_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Na tenepo, iwo amulambira mbabwerera na kutsandzaya kukulu mpaka ku Djerusalema. ");
INSERT INTO seh_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Iwo akhakhala mu Nyumba ya Mulungu midzidzi yonsene mbakhakuza Mulungu. ");
INSERT INTO seh_vpl VALUES ("J11_1","092_1_1","1JN","1","1","1","Pire pikhalipo kutomera pa kutoma, pire pidabva ife, pire pidaona ife na maso athu, pire pidadingisa ife pontho manja athu mbapiphata, ipi tisapilonga pa thangwi ya Fala ya upulumuki. ");
INSERT INTO seh_vpl VALUES ("J11_2","092_1_2","1JN","1","2","2","Upulumuki unowu wabulukira. Ife tauona, pontho ndi unowu unacitira ife umboni, mbatikupangani upulumuki wakukhonda kumala ukhali na Baba, pontho mbubulukira kuna ife. ");
INSERT INTO seh_vpl VALUES ("J11_3","092_1_3","1JN","1","3","3","Ife tisakupangani pire pidaona ife na pidabva ife, toera muphatanembo na ife. Kuphatana kwathu ndi na Mulungu Baba, pontho na Mwana wace Yezu Kirixtu. ");
INSERT INTO seh_vpl VALUES ("J11_4","092_1_4","1JN","1","4","4","Pontho tisakulemberani pinthu ipi toera kutsandzaya kwathu kudzadziswe. ");
INSERT INTO seh_vpl VALUES ("J11_5","092_1_5","1JN","1","5","5","Apo mphangwa zidabva ife kuna Kirixtu zinakupangani ife ndi izi: Mulungu ndi cieza. Muna Iye nkhabemo cidima na pang'ono pene. ");
INSERT INTO seh_vpl VALUES ("J11_6","092_1_6","1JN","1","6","6","Na tenepo, tingalonga kuti taphatana na Mulungu khundu inango mbatifamba n'cidima, dziwani kuti tiri kulonga uthambi mbatikhonda kucita pya ndimo mwene. ");
INSERT INTO seh_vpl VALUES ("J11_7","092_1_7","1JN","1","7","7","Mbwenye tingafamba mu cieza, ninga Iye ali mu cieza, ife tonsene taphatana m'bodzi na m'bodzi, pontho ciropa ca Yezu Mwana wa Mulungu, cinatitsuka kudawa konsene. ");
INSERT INTO seh_vpl VALUES ("J11_8","092_1_8","1JN","1","8","8","Tingalonga kuti ife nkhabe kudawa, tiri kunyengezana tekha ene, pontho muna ife nkhabemo pya ndimo mwene. ");
INSERT INTO seh_vpl VALUES ("J11_9","092_1_9","1JN","1","9","9","Mbwenye tingadambula kudawa kwathu kuna Mulungu, Iye ndi wa kukhulupirika na wakulungama, toera kulekerera kudawa kwathu, na kutitsuka kuipa konsene. ");
INSERT INTO seh_vpl VALUES ("J11_10","092_1_10","1JN","1","10","10","Tingalonga kuti cipo tidzati kudawa, tisalonga kuti Mulungu ndi nyauthambi, pontho mafala ace nkhabemo muna ife. ");
INSERT INTO seh_vpl VALUES ("J12_1","092_2_1","1JN","2","1","1","Ananga, ndisakulemberani tsamba iyi toera mukhonde kugwa n'kudawa. Mbwenye munthu m'bodzi angadawa, tinaye munthu wa kutibvunulira patsogolo pana Baba. Ndiye Yezu Kirixtu, Wakulungama. ");
INSERT INTO seh_vpl VALUES ("J12_2","092_2_2","1JN","2","2","2","Iye ndi ntsembe inafudza madawi athu. Pontho si yakufudza madawi athu basi tayu, mbwenye na madawimbo a anthu onsene. ");
INSERT INTO seh_vpl VALUES ("J12_3","092_2_3","1JN","2","3","3","Tingabvera matongero ace, tisapangiza kuti tisan'dziwadi Mulungu. ");
INSERT INTO seh_vpl VALUES ("J12_4","092_2_4","1JN","2","4","4","Ule analonga kuti: “Ine ndisan'dziwa”, mbwenye mbakhonda kubvera matongero ace, unowu ndi nyauthambi. Pontho nkhabemo pya ndimo mwene muna iye. ");
INSERT INTO seh_vpl VALUES ("J12_5","092_2_5","1JN","2","5","5","Mbwenye munthu anabvera mafala ace, kufuna kwa Mulungu kwadzala muna iye. Na tenepo, tisadziwa kuti tiri muna Iye. ");
INSERT INTO seh_vpl VALUES ("J12_6","092_2_6","1JN","2","6","6","Ule analonga kuti ali kukhala muna Iye, asatongwa kuti afambe ninga Iye. ");
INSERT INTO seh_vpl VALUES ("J12_7","092_2_7","1JN","2","7","7","Axamwali anga akufunika, matongero awa anakulemberani ine, si mapsa tayu, mbwenye ndi matongero akale ali na imwe kutomera pakutoma. Ndizo Mphangwa zidabva imwe. ");
INSERT INTO seh_vpl VALUES ("J12_8","092_2_8","1JN","2","8","8","Mbwenye ipi pinakulemberani ine, ndi matongero mapsa. Matongero enewa mba ndimo mwene muna Iye na muna imwe. Thangwi cidima ciri kumala, cieza cakukwana ciri kuyetimira. ");
INSERT INTO seh_vpl VALUES ("J12_9","092_2_9","1JN","2","9","9","Munthu analonga kuti ali kukhala mu cieza, mbwenye mbaida m'bale wace, unowu adzati kubuluka n'cidima. ");
INSERT INTO seh_vpl VALUES ("J12_10","092_2_10","1JN","2","10","10","Mphapo ule anafuna m'bale wace, unowu ali mu cieza. Na tenepo, muna iye nkhabe cinthu ca kun'gwegwedusa. ");
INSERT INTO seh_vpl VALUES ("J12_11","092_2_11","1JN","2","11","11","Mbwenye ule anaida m'bale wace, ali n'cidima, pontho asafamba n'cidima. Na tenepo, nkhabe dziwako kunaenda iye, thangwi cidima campasa udzimola. ");
INSERT INTO seh_vpl VALUES ("J12_12","092_2_12","1JN","2","12","12","Ananga, ndisakulemberani ipi thangwi kudawa kwanu kwalekererwa, na thangwi ya dzina ya Yezu. ");
INSERT INTO seh_vpl VALUES ("J12_13","092_2_13","1JN","2","13","13","Ababa na amai, ndisakulemberani ipi thangwi imwe musan'dziwa ule akhalipo kale dziko mbidzati kucitwa. Imwe aphale na atsikana, ndisakulemberani thangwi mwankunda Sathani. ");
INSERT INTO seh_vpl VALUES ("J12_14","092_2_14","1JN","2","14","14","Ananga, ndakulemberani thangwi musan'dziwa Baba. Ndakulemberani imwe ababa na amai, thangwi imwe musandziwa ule akhalipo kale dziko mbidzati kucitwa. Ndakulemberani imwe aphale na atsikana thangwi imwe ndimwe a mphambvu. Na tenepo mphangwa za Mulungu zina imwe, pontho mwankunda Sathani. ");
INSERT INTO seh_vpl VALUES ("J12_15","092_2_15","1JN","2","15","15","Lekani kufuna dziko, pontho na pinthu piri n'dziko. Thangwi munthu anafuna dziko, nkhabe kufuna Mulungu Baba. ");
INSERT INTO seh_vpl VALUES ("J12_16","092_2_16","1JN","2","16","16","Thangwi pyonsene piri pa dziko ninga pinasirira nyama, pinasirira maso, pontho na kupikuza thangwi ya mpfuma, penepi pidabuluka kuna Baba tayu, mbwenye pyabuluka pa dziko. ");
INSERT INTO seh_vpl VALUES ("J12_17","092_2_17","1JN","2","17","17","Dziko, na pyonsene pire pinasirira iyo pinamala. Mbwenye ule anacita kufuna kwa Mulungu, anakhala kwenda na kwenda. ");
INSERT INTO seh_vpl VALUES ("J12_18","092_2_18","1JN","2","18","18","Ananga, uno ndi n'dzidzi wakumalisa. Pontho ninga mwapibva kuti nyamalwa wa Kirixtu ali kubwera, apo lero dziwani kuti ali kuoneka azinji anyamalwa a Kirixtu. Na thangwi eneyo, tisadziwa kuti uno ndi n'dzidzi wakumalisa. ");
INSERT INTO seh_vpl VALUES ("J12_19","092_2_19","1JN","2","19","19","Iwo abuluka muna ife, mbwenye akhali andzathudi tayu. Thangwi mbadakhala andzathu, mbadakhala na ife. Mbwenye na thangwi ya kubuluka kwawo, pisapangiza kuti onsene akhali andzathu tayu. ");
INSERT INTO seh_vpl VALUES ("J12_20","092_2_20","1JN","2","20","20","Mbwenye imwe mwadzobza na Mulungu, pontho monsene musadziwa. ");
INSERT INTO seh_vpl VALUES ("J12_21","092_2_21","1JN","2","21","21","Sirikukulemberani na thangwi ya kukhonda dziwa kwanu pinthu pya ndimo mwene tayu, mbwenye thangwi musapidziwa, pontho thangwi musadziwa kuti pinthu pyonsene pya ndimo mwene nkhabe kubala uthambi. ");
INSERT INTO seh_vpl VALUES ("J12_22","092_2_22","1JN","2","22","22","Mbani nyauthambi? Ndi ule anakhonda kuti Yezu si Kirixtu tayu. Unowu ndiye nyamalwa wa Kirixtu, ule anakhonda Baba na Mwana ene. ");
INSERT INTO seh_vpl VALUES ("J12_23","092_2_23","1JN","2","23","23","Onsene anakhonda Mwana, unowu nkhabembo Baba. Mbwenye ule anamulonga pakweca, unowu ana Baba. ");
INSERT INTO seh_vpl VALUES ("J12_24","092_2_24","1JN","2","24","24","Imwembo koyani m'mitima mwanu pyonsene pidabva imwe kutomera pakutoma. Pire pyonsene pidabva imwe kutomera pa kutoma mungakhala napyo m'mitima mwanu, imwe munati mukhalembo pabodzi na Mwana pontho na Baba. ");
INSERT INTO seh_vpl VALUES ("J12_25","092_2_25","1JN","2","25","25","Pidatipikirira Iye ndi ipi: Upulumuki wakukhonda kumala. ");
INSERT INTO seh_vpl VALUES ("J12_26","092_2_26","1JN","2","26","26","Ine ndisakulemberani pinthu ipi, na thangwi ya ale anafuna kukunyengererani. ");
INSERT INTO seh_vpl VALUES ("J12_27","092_2_27","1JN","2","27","27","Pa thangwi yanu, kudzobza kudatambira imwe kuna iye kuli muna imwe, pontho nkhabe funika munthu akupfundziseni. Mbwenye ninga kudzobza kwace kudatambira imwe muna Iye nkhwa ndimo mwene si kwa uthambi tayu, kunakupfundzisani pa thangwi ya pinthu pyonsene. Khalani muna Iye ninga mudakupfundzisirani Iye. ");
INSERT INTO seh_vpl VALUES ("J12_28","092_2_28","1JN","2","28","28","Ananga, cincino khalani muna Kirixtu, toera Iye angapangizika tin'nyindire, tikhonde kupasika manyadzo pa maso pace, pa kubwera kwace. ");
INSERT INTO seh_vpl VALUES ("J12_29","092_2_29","1JN","2","29","29","Ngakhala imwe musadziwa kuti Yezu ndi wakulungama, dziwanimbo kuti onsene ale anacita pyakulungama abalwa na Mulungu. ");
INSERT INTO seh_vpl VALUES ("J13_1","092_3_1","1JN","3","1","1","Lang'anani kutifuna kukulu kudacita Baba, na kuticita kuti ife ticemerwe ana a Mulungu. Ndimo mwene ndifedi ana a Mulungu. Ndi thangwi eneyo dziko nkhabe kutidziwa, thangwi iyo nkhabe kun'dziwambo tayu. ");
INSERT INTO seh_vpl VALUES ("J13_2","092_3_2","1JN","3","2","2","Axamwali akufunika, ife cincino ndife ana a Mulungu, pontho pidzati kudziwika kuti tinadza kakhala tani. Mbwenye tisadziwa kuti Kirixtu angadza kapangizika, ife tinadza kalandana naye. Thangwi tinadza kamuona kukhala kudacita iye. ");
INSERT INTO seh_vpl VALUES ("J13_3","092_3_3","1JN","3","3","3","Mphapo munthu onsene ana cidikhiro ceneci muna Kirixtu, asatongwa kuti akhale wakulungama, sawa-sawa ninga Kirixtu ndi wakulungama. ");
INSERT INTO seh_vpl VALUES ("J13_4","092_3_4","1JN","3","4","4","Munthu onsene anacita kudawa, anumpha Mwambo wa Mulungu. Ndimo mwene, kudawa nkhunumpha Mwambo. ");
INSERT INTO seh_vpl VALUES ("J13_5","092_3_5","1JN","3","5","5","Imwe musapidziwa kuti Kirixtu abwera kudza kabulusa madawi athu, pontho muna Iye nkhabe kudawa. ");
INSERT INTO seh_vpl VALUES ("J13_6","092_3_6","1JN","3","6","6","Onsene ale anakhala muna Kirixtu, nkhabe kukhala n'kudawa. Onsene ale anakhala n'kudawa, adzati kumuona, pontho adzati kun'dziwa. ");
INSERT INTO seh_vpl VALUES ("J13_7","092_3_7","1JN","3","7","7","Ananga, lekani kunyengezwa na munthu. Ule anacita pinthu pyakulungama ndi wakulungama, sawa-sawa ninga Kirixtu ndi wakulungama. ");
INSERT INTO seh_vpl VALUES ("J13_8","092_3_8","1JN","3","8","8","Apo ule anakhala mbadawa, unowu ndi munthu wa Sathani. Thangwi Sathani adza mbadawa kutomera kale na kale. Ndi thangwi eneyo Mwana wa Mulungu abwera, toera kufudza mabasa a Sathani. ");
INSERT INTO seh_vpl VALUES ("J13_9","092_3_9","1JN","3","9","9","Onsene adabalwa na Mulungu nkhabe kukhala mbacita kudawa, thangwi mbeu ya Mulungu iri muna iye. Na tenepo, unowu nkhabe kwanisa kukhala mbacita kudawa, thangwi abalwa na Mulungu. ");
INSERT INTO seh_vpl VALUES ("J13_10","092_3_10","1JN","3","10","10","Na mwenemu, tisadziwa mbani ana a Mulungu, peno mbani ana a Sathani. Onsene ale anakhonda kucita pinthu pyakulungama, na onsene anakhonda kufuna m'bale wace, hadabuluka kuna Mulungu tayu. ");
INSERT INTO seh_vpl VALUES ("J13_11","092_3_11","1JN","3","11","11","Izi ndizo mphangwa zidabva imwe kutomera pa kutoma kuti: Tifunane m'bodzi na m'bodzi. ");
INSERT INTO seh_vpl VALUES ("J13_12","092_3_12","1JN","3","12","12","Mbatilekeni kukhala ninga Kainu, munthu wa Sathani adapha m'bale wace. Apo thangwi yanji iye apha m'bale wace? Amupha thangwi mabasa ace akhali akuipa, mbwenye mabasa a m'bale wace akhali akulungama. ");
INSERT INTO seh_vpl VALUES ("J13_13","092_3_13","1JN","3","13","13","Abale anga, lekani kudzudzumika mungazondiwa na dziko. ");
INSERT INTO seh_vpl VALUES ("J13_14","092_3_14","1JN","3","14","14","Tisadziwa kuti ife tabuluka pa kufa, mbwenye cincino tapulumuka thangwi tisafuna abale athu. Mphapo ule anakhonda funa m'bale wace, ali n'kufa. ");
INSERT INTO seh_vpl VALUES ("J13_15","092_3_15","1JN","3","15","15","Munthu onsene anazonda m'bale wace ndi phanga. Pontho imwe musadziwa kuti phanga nkhabe upulumuki wakukhonda kumala muna iye. ");
INSERT INTO seh_vpl VALUES ("J13_16","092_3_16","1JN","3","16","16","Na mwenemu, ife tisadziwa ndi ninji kufunana, thangwi Yezu Kirixtu apereka upulumuki wace na thangwi yathu. Na tenepo, ife tisatongwambo kupereka upulumuki wathu na thangwi ya abale athu. ");
INSERT INTO seh_vpl VALUES ("J13_17","092_3_17","1JN","3","17","17","Munthu wa kupfuma mbaona m'bale wace ali kucherenga mbakhonda kumphedza, munthu unowu analonga kuti asafuna Mulungu? ");
INSERT INTO seh_vpl VALUES ("J13_18","092_3_18","1JN","3","18","18","Ananga, kufunana kwathu mbukuleke kukhala kwa mafala na mulomo basi tayu, mbwenye mbukukhale kwa mabasa na mwa ndimo mwene. ");
INSERT INTO seh_vpl VALUES ("J13_19","092_3_19","1JN","3","19","19","Na tenepo, tinadziwa kuti ife ndife a ndimo mwene, pontho tinakhurudzisa ntima wathu patsogolo pana Mulungu, ");
INSERT INTO seh_vpl VALUES ("J13_20","092_3_20","1JN","3","20","20","ntima wathu ungatipanga kuti tadawa. Mulungu ndi nkulu kakamwe kupita ntima wathu, pontho asadziwa pinthu pyonsene. ");
INSERT INTO seh_vpl VALUES ("J13_21","092_3_21","1JN","3","21","21","Axamwali anga akufunika, ntima wathu ungakhonda kutipanga kuti tadawa, tina cinyindiro patsogolo pana Mulungu. ");
INSERT INTO seh_vpl VALUES ("J13_22","092_3_22","1JN","3","22","22","Pontho pyonsene pinaphemba ife anatipasa, thangwi tisabvera matongero ace pontho tisacita pinafuna Iye. ");
INSERT INTO seh_vpl VALUES ("J13_23","092_3_23","1JN","3","23","23","Matongero ace ndi awa: Kuti titawire dzina ya Yezu Kirixtu Mwana wace, pontho tifunane m'bodzi na m'bodzi, ninga mudatipangira Iye. ");
INSERT INTO seh_vpl VALUES ("J13_24","092_3_24","1JN","3","24","24","Ale anabvera matongero a Mulungu, asakhala muna Mulungu, Mulungumbo asakhala muna iwo. Na tenepo, tisadziwa kuti Iye asakhala muna ife, na thangwi ya Nzimu udatipasa Iye. ");
INSERT INTO seh_vpl VALUES ("J14_1","092_4_1","1JN","4","1","1","Axamwali akufunika, lekani kubvera mizimu yonsene, mbwenye ilang'aniseni mwadidi toera muione ngakhala yabuluka kuna Mulungu. Thangwi aporofeta azinji a uthambi ali kubalalika n'dziko muno. ");
INSERT INTO seh_vpl VALUES ("J14_2","092_4_2","1JN","4","2","2","Nzimu wa Mulungu imwe munakwanisa kuudzindikira tenepa: Nzimu onsene unalonga kuti Yezu Kirixtu acitika munthu, nzimu unowu wabuluka kuna Mulungu. ");
INSERT INTO seh_vpl VALUES ("J14_3","092_4_3","1JN","4","3","3","Mbwenye nzimu onsene unakhonda kulonga penepi, hudabuluka kuna Mulungu tayu. Unowu ndi nzimu wa nyamalwa wa Kirixtu, ule udabva imwe kale kuti uli kubwera, apo cincino uli pano pa dziko. ");
INSERT INTO seh_vpl VALUES ("J14_4","092_4_4","1JN","4","4","4","Ananga, imwe ndimwe a Mulungu, pontho mwaikunda mizimu ya uthambi. Thangwi ule ali muna imwe ana mphambvu kupita ule ali pa dziko. ");
INSERT INTO seh_vpl VALUES ("J14_5","092_4_5","1JN","4","5","5","Iwo abuluka n'dziko. Na thangwi eneyo, pire pinalonga iwo pisabuluka n'dziko, pontho dziko isaabvera. ");
INSERT INTO seh_vpl VALUES ("J14_6","092_4_6","1JN","4","6","6","Ife tabuluka kuna Mulungu, pontho onsene ale anadziwa Mulungu asatibvera. Mbwenye ule anakhonda buluka kuna Mulungu, nkhabe kutibvera. Na tenepo tisakwanisa kudzindikira Nzimu wa ndimo mwene, na nzimu wa uthambi. ");
INSERT INTO seh_vpl VALUES ("J14_7","092_4_7","1JN","4","7","7","Axamwali akufunika, mbatifunaneni m'bodzi na m'bodzi, thangwi kufunana kusabuluka kuna Mulungu. Ule anafuna ndzace, abalwa na Mulungu, pontho asan'dziwa Mulungu. ");
INSERT INTO seh_vpl VALUES ("J14_8","092_4_8","1JN","4","8","8","Mphapo ule anakhonda kufuna ndzace nkhabe kun'dziwa Mulungu, thangwi Mulungu ndi kufunana. ");
INSERT INTO seh_vpl VALUES ("J14_9","092_4_9","1JN","4","9","9","Mulungu apangiza kufuna kwace pakati pathu tenepa: Atuma Mwana wace m'bodzi ekha pa dziko, toera iye aticite kuti tikhale m'maso. ");
INSERT INTO seh_vpl VALUES ("J14_10","092_4_10","1JN","4","10","10","Kufunana kwacitika tenepa: Sife adafuna Mulungu tayu, mbwenye ndiye adatifuna mbatitumira Mwana wace, toera kufudza madawi athu. ");
INSERT INTO seh_vpl VALUES ("J14_11","092_4_11","1JN","4","11","11","Axamwali anga akufunika, na kutifuna kudaticita Mulungu, ifembo tisatongwa tifunane m'bodzi na m'bodzi. ");
INSERT INTO seh_vpl VALUES ("J14_12","092_4_12","1JN","4","12","12","Cipo nkhabe munthu adaona Mulungu. Mphapo tingafunana m'bodzi na m'bodzi, Mulungu anakhala muna ife, pontho kufuna kwace kunadzaleratu kakamwe muna ife. ");
INSERT INTO seh_vpl VALUES ("J14_13","092_4_13","1JN","4","13","13","Ife tisadziwa kuti tiri muna Mulungu, Iyembo ali muna ife, thangwi Iye atipasa Nzimu wace. ");
INSERT INTO seh_vpl VALUES ("J14_14","092_4_14","1JN","4","14","14","Na tenepo, ife tamuona, pontho tisaenda mbatilonga umboni kuti Baba atuma Mwana wace, toera akhale Mpulumusi wa dziko. ");
INSERT INTO seh_vpl VALUES ("J14_15","092_4_15","1JN","4","15","15","Munthu analonga pakweca kuti Yezu ndi Mwana wa Mulungu, munthu unowu Mulungu anakhala muna iye, iyembo anakhala muna Mulungu. ");
INSERT INTO seh_vpl VALUES ("J14_16","092_4_16","1JN","4","16","16","Na tenepo, ife tisadziwa kutifuna kunaticita Mulungu, pontho kutifuna kweneku tisanyindirako. Mulungu ndi kufunana. Onsene anakhala mwa kufunana ali muna Mulungu, pontho Mulungu ali muna iye. ");
INSERT INTO seh_vpl VALUES ("J14_17","092_4_17","1JN","4","17","17","Na tenepo, kufunana kwadzala pakati pathu toera ntsiku ya kutongwa tikhale na kunyindira. Thangwi pa dziko ino ndife sawa-sawa ninga Yezu. ");
INSERT INTO seh_vpl VALUES ("J14_18","092_4_18","1JN","4","18","18","Pana kufunana nkhabe gumanika kugopa. Pontho kufunana kwakukwana kusamalisa kugopa. Thangwi ale anagopa, asagopa nyatwa. Ule anagopa nkhabe kufunana kwakukwana. ");
INSERT INTO seh_vpl VALUES ("J14_19","092_4_19","1JN","4","19","19","Ife tisanfuna, thangwi Iye ndiye adatifuna pakutoma. ");
INSERT INTO seh_vpl VALUES ("J14_20","092_4_20","1JN","4","20","20","Munthu analonga kuti: “Ine ndisafuna Mulungu”, mbwenye mbaida m'bale wace, unowu ndi nyauthambi. Thangwi munthu anakhonda funa m'bale wace anaona iye na maso ace, anacimwana kufuna Mulungu anakhonda kuona iye. ");
INSERT INTO seh_vpl VALUES ("J14_21","092_4_21","1JN","4","21","21","Mulungu atisiyira matongero awa: Kuti ule anafuna Mulungu, mbafunembo m'bale wace. ");
INSERT INTO seh_vpl VALUES ("J15_1","092_5_1","1JN","5","1","1","Munthu onsene anatawira kuti Yezu ndi Kirixtu, unowu abalwa na Mulungu. Pontho munthu onsene anafuna Baba, mbafunembo Mwana wace. ");
INSERT INTO seh_vpl VALUES ("J15_2","092_5_2","1JN","5","2","2","Tingafuna Mulungu mbatibvera matongero ace, penepi ndipyo pinapangiza kuti tisaafuna ana a Mulungu. ");
INSERT INTO seh_vpl VALUES ("J15_3","092_5_3","1JN","5","3","3","Thangwi kufuna Mulungu nkhubvera matongero ace, pontho matongero ace nkhabe lemera. ");
INSERT INTO seh_vpl VALUES ("J15_4","092_5_4","1JN","5","4","4","Thangwi ule anabalwa na Mulungu asakunda dziko. Tisakwanisa kukunda dziko na kukhulupira kwathu. ");
INSERT INTO seh_vpl VALUES ("J15_5","092_5_5","1JN","5","5","5","Ndi ani anakwanisa kukunda dziko? Ndi ule basi anatawira kuti Yezu ndi Mwana wa Mulungu. ");
INSERT INTO seh_vpl VALUES ("J15_6","092_5_6","1JN","5","6","6","Yezu Kirixtu ndi unowu adabwera na madzi na ciropa. Si na madzi basi tayu, mbwenye ndi na madzi na ciropa. Pontho Nzimu wa Mulungu ndiwo unacita umboni, thangwi Nzimu wa Mulungu ndi wa ndimo mwene. ");
INSERT INTO seh_vpl VALUES ("J15_7","092_5_7","1JN","5","7","7","Piripo pinthu pitatu pinacita umboni kudzulu. Baba, Fala na Nzimu wa Mulungu. Pitatu ipi, pisabverana. ");
INSERT INTO seh_vpl VALUES ("J15_8","092_5_8","1JN","5","8","8","Pontho pitatu ipi ndipyo pinacita umboni pa dziko. Nzimu wa Mulungu, madzi na ciropa. Pitatu ipi, ndi cinthu cibodzi basi. ");
INSERT INTO seh_vpl VALUES ("J15_9","092_5_9","1JN","5","9","9","Ife tisatawira umboni wa anthu, mbwenye umboni wa Mulungu ndiwo ukulu, thangwi ndi umboni unacitira iye Mwana wace. ");
INSERT INTO seh_vpl VALUES ("J15_10","092_5_10","1JN","5","10","10","Munthu anatawira Mwana wa Mulungu anawo umboni unowu mu ntima mwace. Mbwenye ule anakhonda kutawira Mulungu, asacita Mulungu ninga ndi nyauthambi. Thangwi asakhonda umboni udatipasa Mulungu na thangwi ya Mwana wace. ");
INSERT INTO seh_vpl VALUES ("J15_11","092_5_11","1JN","5","11","11","Umboni wa Mulungu ndi uyu: Kuti Mulungu atipasa upulumuki wakukhonda kumala. Upulumuki unowu uli muna Mwana wace. ");
INSERT INTO seh_vpl VALUES ("J15_12","092_5_12","1JN","5","12","12","Ule ana Mwana wa Mulungu, anawo upulumuki. Mbwenye anasowa Mwana wa Mulungu, nkhabe upulumuki. ");
INSERT INTO seh_vpl VALUES ("J15_13","092_5_13","1JN","5","13","13","Ine ndakulemberani pyonsene ipi, toera imwe mudatawira dzina ya Mwana wa Mulungu, mudziwe kuti munawo upulumuki wakukhonda kumala. ");
INSERT INTO seh_vpl VALUES ("J15_14","092_5_14","1JN","5","14","14","Cinyindiro cina ife muna Iye ndi ici: Kuti tingamphemba cinthu ninga munafunira Iye, Iye asatibva. ");
INSERT INTO seh_vpl VALUES ("J15_15","092_5_15","1JN","5","15","15","Pontho tingadziwa kuti Iye asatibva pa pyonsene pinamphemba ife, tisadziwa kuti tapasiwa pyonsene pidamphemba ife. ");
INSERT INTO seh_vpl VALUES ("J15_16","092_5_16","1JN","5","16","16","Munthu anaona m'bale wace mbacita kudawa kunakhonda kubala kufa, mbamphemberere, Mulungu anampulumusa. Penepi ndisalongera kuna ale kuti kudawa kwawo nkhabe kubala kufa. Thangwi kulipo kudawa kunabala kufa. Sirikulonga enewa tayu. Kuna anthu enewa, lekani kuaphemberera. ");
INSERT INTO seh_vpl VALUES ("J15_17","092_5_17","1JN","5","17","17","Pinthu pyonsene pyakukhonda kulungama ndi kudawa. Mbwenye kulipo kudawa kunakhonda kubala kufa. ");
INSERT INTO seh_vpl VALUES ("J15_18","092_5_18","1JN","5","18","18","Tisadziwa kuti onsene adabalwa na Mulungu nkhabe kukhala n'kudawa, thangwi Mwana wa Mulungu anaakoya. Na tenepo, Sathani nkhabe kuacita kuipa. ");
INSERT INTO seh_vpl VALUES ("J15_19","092_5_19","1JN","5","19","19","Tisadziwa kuti ife ndife a Mulungu, pontho dziko yonsene isatongwa na Sathani. ");
INSERT INTO seh_vpl VALUES ("J15_20","092_5_20","1JN","5","20","20","Tisadziwambo kuti Mwana wa Mulungu abwera mbatipasa ndzeru toera tidziwe Mulungu wa ndimo mwene. Pontho ife tiri muna Mulungu wa ndimo mwene, muna Mwana wace Yezu Kirixtu. Yezu Kirixtu unowu, ndiye Mulungudi na upulumuki wakukhonda kumala. ");
INSERT INTO seh_vpl VALUES ("J15_21","092_5_21","1JN","5","21","21","Ananga, citani mphole na alungu apezi. ");
INSERT INTO seh_vpl VALUES ("J21_1","093_1_1","2JN","1","1","1","Ine ntsogoleri, ndisalemba tsamba iyi kuna mai adasankhulwa, na kuna anace anafunikadi na ine kakamwe. Sine basi tayu anaafuna, mbwenye asafuniwambo na onsene ale anadziwa pya ndimo mwene, ");
INSERT INTO seh_vpl VALUES ("J21_2","093_1_2","2JN","1","2","2","na thangwi ya pya ndimo mwene pinakhala muna ife, pontho piri na ife kwenda na kwenda. ");
INSERT INTO seh_vpl VALUES ("J21_3","093_1_3","2JN","1","3","3","Ntsisi, kukoma ntima, na ntendere wa Mulungu Baba na wa Mwana wace Yezu Kirixtu, mbapikhale na ife mwa ndimo mwene na mwakufunana. ");
INSERT INTO seh_vpl VALUES ("J21_4","093_1_4","2JN","1","4","4","Ndakomerwa pikulu kakamwe pidagumana ine anako anango mbafamba mwakulungama, ninga munalongera mwambo udatambira ife kuna Baba. ");
INSERT INTO seh_vpl VALUES ("J21_5","093_1_5","2JN","1","5","5","Cincino ndisakuphembani mai, kuti tifunane m'bodzi na m'bodzi. Si kuti ndiri kukulemberani mwambo upsa tayu. Mbwenye mwambo unowu ndiwo ukhali na ife kutomera pa kutoma. ");
INSERT INTO seh_vpl VALUES ("J21_6","093_1_6","2JN","1","6","6","Kufunana ndi uku: Kuti tifambe ninga munalongera matongero ace. Ninga mwaabva kale na kale, matongero ace ndi awa: Kuti mufambe na kufunana kweneku. ");
INSERT INTO seh_vpl VALUES ("J21_7","093_1_7","2JN","1","7","7","Ndimo mwene, alipo anyauthambi azinji asabulukira pa dziko, mbakhonda kuti Yezu Kirixtu acitika munthu. Anthu enewa ndiwo anyauthambi na anyamalwa a Kirixtu. ");
INSERT INTO seh_vpl VALUES ("J21_8","093_1_8","2JN","1","8","8","Citani mphole, gopa munadza kaluza misapu ya basa yathu, mbwenye toera mupaswe m'bairo wanu wamumphu. ");
INSERT INTO seh_vpl VALUES ("J21_9","093_1_9","2JN","1","9","9","Onsene ale anakhonda kukhala mu cipfundzo ca Kirixtu mbwenye mbabuluka kunja, enewa nkhabe Mulungu. Ule anakhala mu cipfundzo ca Kirixtu, ana Baba pontho ana Mwana. ");
INSERT INTO seh_vpl VALUES ("J21_10","093_1_10","2JN","1","10","10","Munthu anadza kuna imwe mbakhonda kudza na cipfundzo ceneci, lekani kuntambira pa nyumba panu, pontho lekani kum'mwanyika. ");
INSERT INTO seh_vpl VALUES ("J21_11","093_1_11","2JN","1","11","11","Thangwi ule anam'mwanyika anaphatana na iye pa mabasa ace a kuipa. ");
INSERT INTO seh_vpl VALUES ("J21_12","093_1_12","2JN","1","12","12","Ndina pizinji kuti ndikulembereni, mbwenye sikhafuna kuti ndicite kupilemba pa tsamba tayu. Thangwi ndisadikhira kudza kakuonani toera ndilonge na imwe nkhope na nkhope, toera kutsandzaya kwathu kudzadziswe. ");
INSERT INTO seh_vpl VALUES ("J21_13","093_1_13","2JN","1","13","13","Ana a mwana-nkazi wako wakusankhulwa, asakuwangisa. ");
INSERT INTO seh_vpl VALUES ("J31_1","094_1_1","3JN","1","1","1","Ine ntsogoleri, ndisalemba tsamba iyi kuna wakufunika Gayo, unowu anafuna ine kakamwe. ");
INSERT INTO seh_vpl VALUES ("J31_2","094_1_2","3JN","1","2","2","Xamwali wanga wakufunika, ndisaphembera kuti ukhale manungo akuwanga, pyonsene pikufambire mwadidi, ninga nzimu wako uli mwadidi. ");
INSERT INTO seh_vpl VALUES ("J31_3","094_1_3","3JN","1","3","3","Ndatsandzaya pikulu kakamwe mudatambira ine abale anango mbandipanga na thangwi ya kukhulupira kwako, na kufamba mwa ndimo mwene kunacita iwe. ");
INSERT INTO seh_vpl VALUES ("J31_4","094_1_4","3JN","1","4","4","Nkhabe kutsandzaya kunango kwa ine, kunapiringana kubva kudacita ine kuti ananga ali kufamba mwakulungama. ");
INSERT INTO seh_vpl VALUES ("J31_5","094_1_5","3JN","1","5","5","Xamwali wanga wakufunika, iwe ndiwe wakukhulupirika pa pire pinacita iwe kuli abale, iwo mbakhala anthu anakhonda iwe kudziwa. ");
INSERT INTO seh_vpl VALUES ("J31_6","094_1_6","3JN","1","6","6","Iwo acita umboni pa maso pa abale anyakutawira Yezu, mbalonga na thangwi ya kukoma ntima kwako. Mphyadidi uwaphedze kufamba pa ulendo wawo, toera Mulungu atsandzaye napyo. ");
INSERT INTO seh_vpl VALUES ("J31_7","094_1_7","3JN","1","7","7","Thangwi na dzina ya Yezu, iwo abuluka, mbakhonda tawira kuphebza cinthu cibodzi na ale adakhonda kutawira Yezu. ");
INSERT INTO seh_vpl VALUES ("J31_8","094_1_8","3JN","1","8","8","Thangwi tisatongwa tiatambire na ntsisi abale ninga enewa, toera tikhale anthu akuphatana pa kuphata basa ya kumwaza pya ndimo mwene. ");
INSERT INTO seh_vpl VALUES ("J31_9","094_1_9","3JN","1","9","9","Ndalemba tsamba kuna abale anyakutawira Yezu, mbwenye Dhiyoterefi, na kufuna kwace ukulu pa nsoka wawo, akhonda kutitambira. ");
INSERT INTO seh_vpl VALUES ("J31_10","094_1_10","3JN","1","10","10","Na tenepo, ine ndingafika kweneku ndinansandika, na thangwi ya pinacita iye na mafala ace a kuipa anatilongera iye. Mbwenye iye nkhabe komerwa basi na penepi tayu. Abale angafika kweneku iye nkhabe kuatambira. Pontho munthu unango angafuna kuatambira, iye asan'khondesa mpaka kufikira kun'thamangisa pa nsoka wa abale anyakutawira Yezu. ");
INSERT INTO seh_vpl VALUES ("J31_11","094_1_11","3JN","1","11","11","Xamwali wanga wakufunika, leka towerera pya kuipa, mbwenye towerera pyadidi. Ule anacita pyadidi ndi wa Mulungu, mbwenye ule anacita pya kuipa adzati kuona Mulungu. ");
INSERT INTO seh_vpl VALUES ("J31_12","094_1_12","3JN","1","12","12","Mbwenye Dhemetiryo, anthu onsene asansimba. Pyamaso pinaphata iye pisancitira umboni. Na ifeenembo tisancitira umboni. Pontho iwe usadziwa kuti umboni wathu ndi wa ndimo mwene. ");
INSERT INTO seh_vpl VALUES ("J31_13","094_1_13","3JN","1","13","13","Ndikhali na pinthu pizinji pya kufuna kukulembera, mbwenye sinafuna cita kupilemba tayu, ");
INSERT INTO seh_vpl VALUES ("J31_14","094_1_14","3JN","1","14","14","thangwi ndisafuna kudza kakuona cincino. Na tenepo, tinadza kaceza mwadidi tingadza kaonana nkhope na nkhope. ");
INSERT INTO seh_vpl VALUES ("J31_15","094_1_15","3JN","1","15","15","Ntendere mbukhale na iwe. Axamwali a kuno asakuwangisa. Wangisambo axamwali a kweneko, m'bodzi na m'bodzi. ");
ALTER TABLE seh_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
