﻿USE sofia;
DROP TABLE IF EXISTS sofia.sch_vpl;
CREATE TABLE sch_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sch_vpl WRITE;
INSERT INTO sch_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Hi ngei hih Abraham jâisuon, David jâisuon Jisua Khrista richibulngei an ni. ");
INSERT INTO sch_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","6a","Abraham renga Rêng David tena, anuoia anghin richibulngei hah adônin mintâng ani: Abraham'n Isaac a neia, Isaac'n Jakob a neia, Jakob'n Judah le a lâibungngei a neia; hanchu Judah'n Perez le Zerah a nei ngeia, (an nu chu Tamar ani) Perez'n Hezron a neia; Hezron'n Ram a neia, Ram'n Amminadab a neia, Amminadab'n Nahshon a neia; Nahshon'n Salmon a neia; Salmon'n Boaz a neia, (a nu chu Rahab ani) Boaz'n Obed a neia, (a nu chu Ruth ani) Obed'n Jesse a neia; Jesse'n Rêng David a nei ani. ");
INSERT INTO sch_vpl VALUES ("MT1_6b","070_1_6b","MAT","1","6b","11","David zora renga Israel mipui ngei Babylon suoka intânga an om tena anuoia anghin an richibulngei hah adônin mintâng ani: David'n Uriah lômnu leh Solomon a neia; Solomon'n Rehoboam a neia; Rehoboam'n Abijah a neia; Abijah'n Asa a neia; Asa'n Jehoshaphat a neia; Jehoshaphat'n Jehoram a neia; Jehoram'n Uzziah a neia; Uzziah'n Jotham a neia; Jotham'n Ahaz a neia; Ahaz'n Hezekiah a neia; Hezekiah'n Manasseh a neia; Manasseh'n Amon a neia; Amon'n Josiah a neia; Josiah'n Jehoiachin le a lâibungngei a nei ngei ani. ");
INSERT INTO sch_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Hanchu, Babylon suoka an intâng suonûk renga Jisua suok tena hi anuoia angin richilbulngei adônin mintâng ani: Jehoiachin'n Shealtiel a neia; Shealtiel'n Zerubbabel a neia; Zerubbabel'n Abiud a neia; Abiud'n Eliakim a neia; Eliakim'n Azor a neia; Azor'n Zadok a neia, Zadok'n Achim a neia; Achim'n Eliud a neia; Eliud'n Eleazar a neia; Eleazar'n Matthan a neia, Matthan'n Jacob a neia; Jacob'n, Joseph, Mary inneipuipu hah a neia; ha Mary renga han Jisua Messiah an ti hih ajuong inzir ani, ");
INSERT INTO sch_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Masikin, Abraham renga David tena ruol sômleiminli ania; David renga Babylon tieng suoka an tuong ngei tena ruol sômleiminli ania; ma renga hah Messiah ânzir tena ruol sômleiminli ani. ");
INSERT INTO sch_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Mahih Jisua Khrista ajuong inzir tie chu ani. A nu Mary hah Joseph han ava bieka, in-annei mân, Ratha Inthiengin nâi a vonga, ");
INSERT INTO sch_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Joseph hah zoratina mi diktak ani sikin mipui rietin Mary hah mâimôkshak rang nuom maka; masikin inrûktên an inbiekna setin mâkchien rangin a mintuo ani. ");
INSERT INTO sch_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Hima roi hah a mindon lâitakin, a ramangin Pumapa Vântîrton inkhat a kôm a juong inlâra, a kôm han, “Joseph, David jâisuon, Mary hih lômnua nei rang chi no roh. Amanu nâivong hih Ratha Inthieng renga kêng ani. ");
INSERT INTO sch_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Amanu han Nâipasal nei a ta, male a riming Jisua ni phuo rang ani. Ama han a mingei an nunsienangei renga a sanminring ngei rang sikin,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Atûn hin Pumapa'n dêipu manga a lei misîr hah adikin ahong tung theina ranga hima ngei murdi hih ahong oma, ");
INSERT INTO sch_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Dôngmate inthienghiei hah inrâi a ta nâipasal nei atih, male a riming Immanuel phuo an tih,” (ma omtie chu, “Ei kôm Pathien aom tina ani.”) ");
INSERT INTO sch_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Masikin, Joseph ânthoi lehan, Pumapa vântîrtonin a tipe anghan, Mary hah lômnûn a nei zoi. ");
INSERT INTO sch_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Aniatachu, a nâivong hah a nei mâka chu ompui mah. Hanchu, Joseph'n a riming hah Jisua a phuo zoi ani. ");
INSERT INTO sch_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Rêng Herod ânlal lâihan Judea rama Bethlehem khopuia Jisua ajuong inzira. Ânzirsuo, harenghan, ârsi tienga lekha inchû ngâi mivârngei senkhat nisuotieng renga Jerusalema an juonga ");
INSERT INTO sch_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Khotieng mo Judangei rêng ajuong inzir nâitesen hah a om? Nisuo tienga ama ârsi kin mua, ama chubaimûk rangin kin juong ani,” an tia. ");
INSERT INTO sch_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ma roi hah Rêng Herod'n a rietin chu, a mulungjîng sabaka, Jerusalema mi murdi khom an mulung ajîng sa ani. ");
INSERT INTO sch_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ochaisingei le Balam minchupungei murdi munkhatin a koibûm ngeia, an kôm han, “Khotieng mo Messiah ânzir rang?” tiin a rekel ngeia. ");
INSERT INTO sch_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Hanchu, anni han a kôm, “Judea ram Bethlehem khopuia,” tiin an thuona, Dêipu'n hi anghin a lei mizieka: ");
INSERT INTO sch_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Judah ram sûnga Bethlehem, nangma Judah khopuilienngei lâia achîntak ni tet mak che; na sûng renga ruoipu alân zir rang ani, ki mi Israelngei ruoi rangpu hah.” ");
INSERT INTO sch_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Masikin Herod'n nisuo tienga mivârngei hah a koi ngeia, ârsi ânlang zora tak hah anni renga a man theina rangin inrûktên ântongpui ngei zoi. ");
INSERT INTO sch_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Hanchu hi chong hih bê'n anni hah Bethlehem'a a tîr ngei: “Se ungla, nâite hah asadimin va rok ungla, nin mûn chu mi hong ril nôk roi, masikin keima khom ama chubaimûk ke se theina rangin,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Hanchu an mâka, male an lampuia an sea, nisuo tienga ârsi dên hah an mu nôka. Ârsi hah an mûn chu an râiasân sabaka, idôr taka râisân mo an ni zoi! Nâite omna chung ridîn aphâk mâka chu inngam loiin an moton a ruoi ngei banga. ");
INSERT INTO sch_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Insûnga an va lûta, male a nu Mary leh nâite hah an va mua, khûkinbilin chubai an mûk zoi. Neinunpêk ranga an chôi, rângkachak, bero le myrrh (murrah) an kaisuoa, a kôm an pêk zoi. ");
INSERT INTO sch_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Hanchu, Herod kôm tieng se nôk khâiloi rangin an ramangin Pathien'n inningna a pêk ngei sikin lampui danga an ram tieng an kîrnôk zoi. ");
INSERT INTO sch_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Hanchu, anni ngei hah an mâk suole chu, Pumapa vântîrton inkhat Joseph kôm ramangin ajuong inlâra, a kôm han, “Herod'n nâite that rangin a rok rang kêng. Masikin inthoi inla, nâite le a nu hah tuong inla, Egypt rama rotpui ngei roh, hong nôk rangin nang ki ril mâka chu mahan omchien roi,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Joseph ânthoia nâite le a nu a tuong ngeia, hani jân renghan Egypt ram an pan kelen zoi. ");
INSERT INTO sch_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Herod thi mâka chu mahan an omchien zoi. Pumapa'n dêipu bâia, “Ka nâipasal chu Egypt ram renga ko koi suok,” a lei ti hah ajuongtung dikna rangin maha ahong om ani. ");
INSERT INTO sch_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herod'n nisuo tienga mivârngei han an huong ti a rietin chu a ningathik sabaka. Mivârngei kôm renga ârsi ânlang zora roi a riet dungjûiin Bethlehem le a revêla nâipang pasal kumnik nuoitienga murdi chu that riei rangin chong a pêk zoi. ");
INSERT INTO sch_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Dêipu Jeremiah'n a lei misîr: ");
INSERT INTO sch_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramah khuoa in-iek miring rietin aoma, Rangâisie taka chap miring hah. Rachel'n a nâingei ranga a châ; amanu hah tâi thei khâi mak an thi pe zoi sikin,” ti hah ahongtung zoi ani. ");
INSERT INTO sch_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herod a thi suole chu, Pumapa vântîrton inkhat Egypt rama Joseph kôm ramangin ânlâra, ");
INSERT INTO sch_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","a kôm, “Inthoi inla, nâite le a nu hah tuong inla, Israel rama se nôk ta roi, nâite that ranga bôkngei hah an thi zoi,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Hanchu, Joseph ânthoia, nâite le a nu a tuonga Israel rama an se nôk zoi. ");
INSERT INTO sch_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Aniatachu, Archelaus a pa Herod ruthûlin Judea rama rêng a chang ti Joseph'n a rietin chu ha taka se hah a chia. A ramangin rilin a om nôka, masikin Galilee ramhuol tiengkâng han an sea ");
INSERT INTO sch_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","khopui inkhat Nazareth an tia han anva om zoi. Hanchu dêipungeiin, “Ama hah Nazareth mi tîng an tih,” tia an lei ti hah adikin ahongtung ani. ");
INSERT INTO sch_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ma zora han Baptispu John, Judea ramchâra a honga male tânghâi a phuta, ");
INSERT INTO sch_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Nin nunsienangei renga inhei ta roi, Invân Rêngram anâi zoi,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","John hih ani, Dêipu Isaiah'n: “Ramchâra mi inkhat tânghâi han, ‘Pumapa rang lamlien sin ungla, a lôna rang lampui khom mintûn roi!’” tia a chungroi a lei misîr hah ani. ");
INSERT INTO sch_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","John a puonsilngei hah ût mula sin ania, savun kongkhit a khita, a sâk ngâi chu khâimimsiengei le rama khuoilutui ani. ");
INSERT INTO sch_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalem renga, Judea ramhuol pumpui renga, le Jordan tuidung revêla ramtin renga mingei a kôm an honga. ");
INSERT INTO sch_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","An nunsienangei an phuonga, male ama'n Jordan tuidunga a Baptis ngei zoi. ");
INSERT INTO sch_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","John'n Phariseengei le Sadduceengei tamtak a kôm Baptis chang rangin an hong a mu lehan an kôm, “Murûl richingei, Pathien sepna juong chulna rang renga hih rotpai theina rangin tumo nangni ril? ");
INSERT INTO sch_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nin sietna renga nin inhei zoi ti riettheina rangin sinngei hah tho roi. ");
INSERT INTO sch_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Male Abraham richisuonpârngei kêng kin ni tiin sepna renga rotpai thei rangin mindon no roi. Nangni ki ril, Pathien'n hi lungngei khom hih Abraham richisuonpârngei a min chang thei! ");
INSERT INTO sch_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Thingkungngei a ruzung renga phûr rangin reipui min râkchien sai kêng ani zoi; thingkung murdi mara sân ânra loi kai chu phûr an ta, meia vôrpai an tih. ");
INSERT INTO sch_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Keima'n chu nin insîr zoi ti rietna rangin tuiin nangni ka Baptis ngâia, aniatachu ku nûka juong rangpu'n chu Ratha Inthieng le meiin nangni baptis a tih. Ama chu keima nêka roiinpui uol ok ani; keima chu a kekok chôi rangin luo inhoi mu-ung. ");
INSERT INTO sch_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Bungei jâpna rangin relei a dôna, a ruijôl jâp minsâi liei a ta, a butakngei kai chu sapang sûnga thun a ta, arishi chu mei thithei ngâiloia hâl minmang a tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ma zora lâihan John kôm Baptis chang rangin Jisua'n Galilee ram renga Jordan dunga a honga, ");
INSERT INTO sch_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Aniatachu, John'n khap rang a bôka, a kôm, “Nangman kêng mi ni Baptis anânga,” John'n, “kho angin mo ko kôm te no honga!” a tia. ");
INSERT INTO sch_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Hannirese Jisua'n a kôm, “Atûn hin asa ti chien roh. Ma angdênin Pathien'n a minnângngei murdi chu ei tho rang ani,” tiin a thuona. Hanchu John a jôt zoi ani. ");
INSERT INTO sch_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jisua Baptis a chang suo, harenghan, tui renga a hong jôka. Hanchu ama rangin invân ajuon onga, male Pathien Ratha hah vasu angin a juongchuma a chunga chuongin a mua. ");
INSERT INTO sch_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Hanchu, invân renga rôl ajuon ringa, “Mahih ka Nâipasal moroitak, a chunga ku mulung atâiriem ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Male Jisua hah Diabol methêma a om rangin Ratha'n ramchâra a tuong zoi. ");
INSERT INTO sch_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Sûn sômminli jân sômminli sâk sâkloiin a om suolechu Jisua hah a vonchâm zoia. ");
INSERT INTO sch_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Hanchu Diabol a honga, a kôm, “Pathien Nâipasal ni nîn chu, hi lungngei hih vâipôl chang rangin chongpêk roh,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Hannirese, Jisua'n a kôm han, “Pathien Lekhabu'n Miriem hi vâipôl korongin ring no nia, Pathien bâia chong hongsuokin kêng an a ring rang ani,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Hanchu Diabol'n Jisua hah, Khopuilien Inthieng Jerusalema a tuonga, Biekin sîpinsângtaka a mindinga, ");
INSERT INTO sch_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","male a kôm, “Pathien Nâipasal ni nîn chu nangma nethenin inchôm inla, Pathien Lekhabu'n ati anghan: ‘Nu chungroia chu Pathien'n a vântîrtonngei chongpêk ngei a ta; an kutngei leh nang lei modong an tih, masikin ne kengei luo khom lunga nên sûi loina rangin,’ ” a tia. ");
INSERT INTO sch_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jisua'n a kôm, “Aniatachu Pathien Lekhabu'n, Pumapa na Pathien minsin no roh, ti khom ânziek sa,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Male, Diabol hah muol insângtaka a tuonga rammuola rêngramngei murdi le an roiinpuinangei a min mua. ");
INSERT INTO sch_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","A kôm, “khûkinbilin chubai mi ni mûkin chu hi ngei murdi hih nang pêk let ki tih,” a ti pea. ");
INSERT INTO sch_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Male Jisua'n a kôm, “Soitan, rotpai roh! Pathien Lekhabu'n, ‘Pumapa na Pathien vai chubaimûk inla, ama sin vai tho roh a ti!’” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Masuole chu Diabol'n Jisua a mâka; male vântîrtonngei an juonga, ama an juong san zoi. ");
INSERT INTO sch_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jisua'n, John an sûr ti a riet lechu, Galilee rama a thengpata. ");
INSERT INTO sch_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nazareth a mâka, Capernaum khopuia ava om zoia, mahah Galilee Dîl pang Zebulun le Naphtali ramhuola om ani. ");
INSERT INTO sch_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Mahi dêipu Isaiah lei ti hah ahongtung adikna ranga ani: ");
INSERT INTO sch_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zebulun ram le Naphtali ram, tuipui panna lampuia, Jordan râl kângkhat tieng, Galilee, Jentailngei ram! ");
INSERT INTO sch_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ijîng nuoia om mingei han vâr roiinpuitak mûng an ta. Thina ram ijîng nuoia omngei chunga han vâr hah hong êl atih.” ");
INSERT INTO sch_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ma zora renga hah Jisua'n, “Nin nunsienangei renga inhei ta roi, Invân Rêngram hih anâi zoi sikin!” tiin thurchi misîr a phut kelen zoi. ");
INSERT INTO sch_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisua'n Galilee dîl pang rûla a chai anghan ngasûrpungei lâibungsa inik a mu ngeia, Simon (Peter an ti) le anâipa Andrew, dîla lên leh nga an sûra. ");
INSERT INTO sch_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jisua'n an kôm, “Ko kôm hong ungla, miriem sûrna chang nangni minchu ki tih,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Voikhat rengin an lênngei an mâkraka, an jûi kelen zoi. ");
INSERT INTO sch_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ava se nôk uol vietin chu lâibungsa adang, Zebedee nâipasalngei Jacob le John ava mu ngei nôka. Anni ngei hah an pa Zebedee leh an rukuong sûnga an lei oma, an lênngei an lei sina. Jisua'n a koi ngeia, ");
INSERT INTO sch_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","male voikhat rengin rukuong le an pa mâkrakin, an jûi kelen zoi. ");
INSERT INTO sch_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisua'n Galilee ram pumpuia a sea, synagog in sûng ngeia a minchua, Rêngram Thurchi Sa a misira, mingei lâia natna le damloina jât tamtak a mindama. ");
INSERT INTO sch_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ama chungroi hah Syria ram pumpuia ânthang zoia, masikin mingei han damloi murdi, natna jât tamtak le intaknangei renga an hong tuong ngeia: ramkhori sûrngei, risangol inveingei, phalkhatthi ngei, hah Jisua'n a lei mindam ngei pak ani. ");
INSERT INTO sch_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Galilee ram le Khopui Sôm ngei renga, Jerusalem renga, Judea ram renga le Jordan râla ramngei renga mipui tamtak ama an jûi zoi ani. ");
INSERT INTO sch_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisua'n loko ngei hah a mûn chu muol chunga a kala, mahan ânsunga. A ruoisingei a kôla an hong intûpa, ");
INSERT INTO sch_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","male anni ngei hah a minchu phut zoi: ");
INSERT INTO sch_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ratha tienga inrienga ânriet ngei chu satvur anni; Invân Rêngram an ta ani sikin. ");
INSERT INTO sch_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Rathanvâingei chu satvur anni; Pathien'n rathanngamna a pêk ngei rang ani! ");
INSERT INTO sch_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Rangâiinchînngei chu satvur anni; Pathien chonginkhâm an la man rang ani! ");
INSERT INTO sch_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Pathien'n a minnângngei sin ranga ôina lientak dônngei chu satvur anni; Pathien'n mulungchukna a pêk ngei rang ani! ");
INSERT INTO sch_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mulungjûrpuina dôn ngei chu satvur anni; Pathien mulungjûrpuina an chang rang ani! ");
INSERT INTO sch_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mulung inthiengngei chu satvur anni; Pathien an la mu rang ani! ");
INSERT INTO sch_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Inngêina ranga sintho ngei chu satvur anni; Pathien'n ama nâingei tiin a la koi ngei rang ani! ");
INSERT INTO sch_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Pathien'n a minnângngei sin sikin nuomlona tuong ngei chu satvur anni; Invân Rêngram an ta ani!” ");
INSERT INTO sch_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ku nûkjûingei nin nina sika min nangni an êroa, an nunuom nangni an loa, milak saloi ngeiin nangni an nôn tika chu satvur nin ni. ");
INSERT INTO sch_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nin râiminsân ungla, nin ta rangin râisânman lientak invâna darin aom sikin. Nin motona lei om dêipungei hah khom nunuomlona an lei tuong ngâi ani.” ");
INSERT INTO sch_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mitin ta rangin michi angin nin ni. Aniatachu michi hih a âlna ahong dongin chu min âl nôk thei ni khâi mak. Mangmunboi ahong changa, masikin an paia, mingeiin an sirpol ngâi ani. ");
INSERT INTO sch_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Nangni ngei hah rammuol pumpui rangin vâr angin nin ni. Tângsîpa khopui aom chu inthup thei ngâi mak. ");
INSERT INTO sch_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Tutên châti mochokin khuriâi nuoia dar ngâi mak ngei; manêkin chu in sûnga mi murdi a êlminvârna rangin châtidarna kêng an dar ngâi ani. ");
INSERT INTO sch_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ma angdên han nin vâr hah mingei makunga vâr ngêt rese, hankêng nin neinun sa tho ngei hah mûng an ta, male invâna om nin Pa minpâk thei an tih. ");
INSERT INTO sch_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Moses le Dêipungei Balam minchûnangei minboi ranga juongin ni be no roi. Ma ngei hah minboi ranga juong ni mu-unga, an minchûnangei ajuongtung dikna ranga kêng ki ni. ");
INSERT INTO sch_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Pilchung le invân a om kâr chu Balam chong ânziek ahâng chînte mo, miziek dukriekte mo hi boi no nih, neinunngei murdi mongna ahongtung mâka chu ti hi riettit roi. ");
INSERT INTO sch_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Masikin tukhomin hi chongpêkngei lâia achîntak khom jômloiin, ma angdênin tho sa rangin midangngei khom a minchûn chu invân Rêngrama chu mi chîntak nîng a tih. Nikhomrese tukhomin Balam a jôma, ma angdênin tho sa rangin mi a minchûa anin chu invân Rêngrama chu mi lien nîng a tih. ");
INSERT INTO sch_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Hanchu, Pathien lungdo sinna lama Balam minchupungei le Phariseengei nêkin taksôn-omin nin om vaiin kêng invân Rêngrama nin lût thei rang tiin nangni ki ril ani. ");
INSERT INTO sch_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Tienlâia mingei kôm chu, ‘Mi that no roh; tukhom mi that chu roijêkna makunga inding a tih,’ tiin an ril ngâi ti nin riet. ");
INSERT INTO sch_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ania, atûn keiman chu: Tukhom a lâibungpa chunga a taksîn chu roijêkna makunga tuongin om a tih, tukhom a lâibungpa kôm, ‘Mangmunboipa!’ ti chu roijêkna makunga tuongin om a tih, male tukhom a lâibungpa kôm mangmunboi, amopa ti chu meidîla se rangin ichi aom ani. ");
INSERT INTO sch_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Masikin mâichâm motona Pathien kôm neinunpêk ne pêk rang lâitak khomin na lâibungpa'n nu chunga mulung hoiloina a dôn iti ni riettitin chu, ");
INSERT INTO sch_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","mâichâm motona ne neinunpêk ne pêk rang hah mâk inla, inrangin sênla, na lâibungpa leh inngêina va sin bak inla, masuole chu hongkîr nôk inla Pathien kôma ne neinunpêk rang hah pêk roh. ");
INSERT INTO sch_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Mîn dabi thôn nang an doia roijêkna muna nang an tuongin chu zora ala om sûngin nin bâiinkhamna hah inngêipui roh, roijêkna mun nin tung mân. Amuna voikhat pai na va tungin chu, ama'n roijêkpu kuta nang bâng a ta, misûrngei kuta nang bâng a ta, male jêl-ina khum nini rang ani. ");
INSERT INTO sch_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nangni ki ril, poisate tena luo lei nu thuon mâka chu ma muna han om tit ni tih. ");
INSERT INTO sch_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Inrê no roh, an lei ti hah nin riet. ");
INSERT INTO sch_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ania, atûn Keiman chu: tukhomin nupang midit enin a ena, amanu hah luo rang a nuomin chu a mulungrîla amanu leh han an inrêa, theiloi changin aom zoi, tiin nangni ki ril ani. ");
INSERT INTO sch_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Masikin ni mit chang tieng han nang aminpalin chu kêlpai inla, vôrpai kelen roh! Na takpum, pumpuia meidîla se nêkin chu na takpuma abâk inkhat ânsam hah chu nata rangin asa uol. ");
INSERT INTO sch_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nu kut changtieng nang aminpalin chu tanpai inla, pai kelen roh! Na takpum, pumpuia meidîla se nêkin chu na takpuma abâk inkhat ânsam hah chu nata rangin asa uol ani.” ");
INSERT INTO sch_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“‘Tukhom a lômnu a mâkin chu mâkna lekha a pêk rang ani,’ an ti sa. ");
INSERT INTO sch_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Hannirese atûn Keiman chu: tukhom pasalin a lômnu hah roi danga niloiin, taksôn omloina sika a mâka anin chu a lômnu hah inrê a minchang ani; male mi lômnu mâksai inneipui nôkpu chu amanu hah a inrêpuiin theiloi a changsa ani, ti nangni ki ril ani. ");
INSERT INTO sch_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Tienlâia mingei kôm chu, ‘No chonginkhâm hah set nôn la, Pumapa makunga nên khâmna hah tho roh,’ an ti, tiin nin riet sa. ");
INSERT INTO sch_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Aniatachu atûn keiman chu, chonginkhâm nin sin zorân inkhâmna ite mang no roi. Invân sâmin khom, khomâkinsâm no roi, Pathien Rêngsukmun ani sikin; ");
INSERT INTO sch_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","pilchung sâmin khom, khomâkinsâm no roi, a ke darna ani sikin. Jerusalem sâmin khom, khomâkinsâm no roi, ma khi Rêng roiinpuitak khopui ani sikin. ");
INSERT INTO sch_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nin lu sâmin khom khomâkinsâm no roi, samsang inkhat luo hih nin minchek thei le nin minhâng thei aom loi sikin. ");
INSERT INTO sch_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","‘Ani’ nônchu ‘Nimak’ vai ti roi, mapêna nin ti hah chu Saloipa Inkhat renga hong kêng ani.” ");
INSERT INTO sch_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“‘Mit ruthûla mit,’ ‘hâ ruthûla hâ,’ an ti hah nin riet. ");
INSERT INTO sch_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Aniatachu atûn keiman chu: nin chunga asaloi tho ngei chunga phubaluok no roi. Tukhomin ni bieng chang tieng a bênin chu, voi tienga ni bieng khom minbên sa roh. ");
INSERT INTO sch_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tukhom nu sûng kancholi lâk rang a râivala roijêkna muna nang tuong rang a bôkin chu na kâncholiinchuol khom pêk sa roh. ");
INSERT INTO sch_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mi'n a puok kilometer khat pêl rangin nang a tiin chu kilometer inik pêlpe roh. ");
INSERT INTO sch_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mi'n neinun imini nang a zong zorân chu, maha a kôm pêk roh; mi lâkâi nang a zongpu hah lei min pûk roh.” ");
INSERT INTO sch_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Na malngei lungkham inla, na râlngei mumâk roh,” an ti iti nin riet. ");
INSERT INTO sch_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Aniatachu atûn keiman chu: nin râlngei lungkham ungla, an nunuom nangni lo ngei hah chubai tho pe roi, ");
INSERT INTO sch_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","masikin invâna nin Pa nâingei nin hongni theina rangin. Ama'n misiengei le misangei chunga a nisa hah ân-angbangin a min suok ngâia, asa sinngei le asie sinngei chunga khom ruo a min juong pe ngei ngâi. ");
INSERT INTO sch_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nang lungkhamngei vai nu lungkham ngeiin te ithomo Pathien'n râisânman nang a pêk ranga? Mahah chu sum rusuongpungei khomin an tho ngâi! ");
INSERT INTO sch_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Hanchu, nin malngei kôm vai nin chongin te imo aliek nin tho uola? Mahah chu sonongngei khomin an tho ngâi! ");
INSERT INTO sch_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Invâna nin Pa asa akipphar anghan nangni khom nan satna hah akipphar ngêt rang ani! ");
INSERT INTO sch_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Nin sakhuo sintumngei nin sinngei hah miriem mitmua, mi mu rangin sin no roi. Ma neinunngei hah mi mu rangin nin sinin chu, invâna nin Pa kôm renga ite râisânman man no tunui. ");
INSERT INTO sch_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Masikin miriem a nângngei neinun nin pêkin, maha alienin minlang no roi, asarothol ngeiin mi minpâkna an chang theina rangin inkhôm inngeia le lamlienngeia an tho ngâi anghan tho no roi. Nangni ki ril an râisânman chu an man suozoi. ");
INSERT INTO sch_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Hannirese, nangni chu miriem intakngei nin sanin, nin ruol satakngei khomin an riet loi rang lamin tho roi. ");
INSERT INTO sch_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Hanchu, inrûka sin tho nîng nin ta, male inrûka nin sintho mu ngâipu nan Pa han râisânman nangni pêk a tih.” ");
INSERT INTO sch_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Chubai nin tho zorân, asarotholngei angin tho no roi! Mîn an mu theina rangin inkhôm inngeia le lamlien sîrngeia indinga chubaitho an minlut ngâi, adiktakin nangni ki ril, an râisânman chu pêkin an omsuo zoi. ");
INSERT INTO sch_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Aniatachu nangni chu chubai nin thôn, nin khâltana lût ungla, inkhâr khâr ungla, male mita mutheiloi nin Pa kôm chubaitho roi. Hanchu, inrûka nin sintho mu ngâipu, nin Pa han râisânman nangni pêng a tih.” ");
INSERT INTO sch_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Chubai nin tho zorân, sonongngei anghan chongkâmboi ngei mang no roi, anni ngei han an chubai tho sôt sikin an pathien'n riet uol rangin an mindon ngâi ani. ");
INSERT INTO sch_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Anni angin om no roi. Nin ngên mân nin Pa'n nin nâng chu a rietsai kêng ani. ");
INSERT INTO sch_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Hanchu, mahi nin chubai tho rang lam chu ani: ‘Kan Pa invana mi: Nirming inthieng mirit om rese. ");
INSERT INTO sch_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Na Rêngram juong tung rese; nu lungdo invâna mîn an sin angin nuoia mîn sin rese ngei. ");
INSERT INTO sch_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Anîngtina kin nâng ngâi dôr sâk avien hin mi pêk roh. ");
INSERT INTO sch_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kin chunga sin minchâingei kin ngâidam anghan, nang khomin kin minchâinangei mi ngâidam roh. ");
INSERT INTO sch_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Sietna ranga methêmna tieng mi tuong nônla, Asaloina renga chu mi mojôk roh,’ tiin. ");
INSERT INTO sch_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Nin chunga midangngei tho minchâi ngei nin ngâidamin chu, invâna nin Pa khomin nangni ngâidam a tih. ");
INSERT INTO sch_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Aniatachu midangngei nin ngâidam nônchu, nin tho minchâina ngei nin Pa'n nangni ngâidam no nih. ");
INSERT INTO sch_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Bu nin ngêi zorân, asarotholngei anghan inngûi mêl pêl no roi. Anni chu mi mitmua bu ngêia an inlang theina rangin an inngûi ngâi ani. Adiktakin nangni ki ril, an râisânman chu an man suozoi. ");
INSERT INTO sch_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nangni chu bu nin ngêi zora khomin nin mâi phie ungla, nin sam khûi roi, ");
INSERT INTO sch_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","hankêng nin bungêi hah midangngeiin riet thei noni ngeia, mita mutheiloi nin Pa vaiin riet a tih. Male inrûka nin sintho mu ngâipu nin Pa han râisânman nangni a pêk rang ani.” ");
INSERT INTO sch_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Pila, arenge le aêkin asiet theina, inrungeiin an murûk theina hin ninta rangin rochon mintûp no roi. ");
INSERT INTO sch_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Manêkin invâna, arenge le thîr-êkin asiet thei khâiloina le inrungei khomin an murûk thei khâiloina muna ninta rangin rochon mintûp roi. ");
INSERT INTO sch_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","No rochon omna muna han zoratin nu mulungrîl om atih.” ");
INSERT INTO sch_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Mitngei hih takpum ranga châti angin ani. Nin mitngei hah asân chu nin takpum pumpui vârin sip a ta; ");
INSERT INTO sch_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Aniatachu nin mitngei hah asa nônchu nin takpum pumpui ajîngkhap rang ani. Masikin nin sûnga vâr hah ajîng nisenla, kho dôra jîngindên mo ani rang!” ");
INSERT INTO sch_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Tutên puma inik tîrlâm chang thei noni ngei; ama han inkhat mumâk a ta; inkhat lungkham a tih, aninônchu, ama han inkhat midituol a ta, inkhat heng a tih. Pathien le sum sintho molop thei no tunui. ");
INSERT INTO sch_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Masika han, nangni ki ril, nin ringna rangin imo ka sâkin ke nêk rang, aninônchu takpum rangin imo ki sillin ko bom rang tiin nin kângmindoi no roi. Sâknêk rangin ringna alut uol ok nimak mo? Sil le bom nêkin takpum alut uol nimak mo? ");
INSERT INTO sch_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Chunga vuong vangei khi en roi; chimu tû mak ngeia, bu ât uol mak ngeia, sasiera bu mintûp uol mak ngei; hankhoma Invâna om nin Pa'n a donsui ngei tit ngâi! Nangni vâng chu, vangei nêkin nin lut uol ok nimak mo? ");
INSERT INTO sch_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Tumo nin ringna chungroia a kângmindoi sika a ringna minsei uol thei rang nin ni? ");
INSERT INTO sch_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ithomo sil le bom rang sikin nin mulung nin min kâng? Rama pârngei insôn tie so en ta u: an ta rangin sin khom tho uol mâk ngeia, puon khom không mak ngei. ");
INSERT INTO sch_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","“Aniatachu, nangni ki ril, Rêng Solomon luo a neina murdi leh ânvô khomin hima pârngei mêlsa inkhat dôr hih enhoi mak. ");
INSERT INTO sch_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ram sûl avien a oma, nangtûka aboi nôka lungthu meia tuorip rang sûl luo hah ma angtak han Pathien'n a minvôn anînle, sil le bom khom nangni pêk uol ngêt no ni mo? Idôra taksônna chîn dôn mo nin ni! ");
INSERT INTO sch_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Masikin, khotieng renga mo ka sâk, ke nêk rang le ki sil ko bom rang ahong suok rang? Tiin nin kângmindoi no roi. ");
INSERT INTO sch_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","“(Sonongngei chu ma neinunngei vai hah kêng an mindon ngâi.) Ma neinunngei murdi hah nin nâng tiin invâna nan Pa'n a riet let ngâi ani. ");
INSERT INTO sch_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Manêkin chu, neinun dang dangngei nêkin Pathien Rêngram le nangnia a minnângngei hah mindon bak ungla, hanchu, ma neinunngei murdi ha chu nangni a pêk sa rang ani. ");
INSERT INTO sch_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Masikin nangtûka rangin nan kângmindoi no roi; maha khom kângdoinangei ahun rang dôr a dôna. Sûn zeta intaknangei a hongchôi ngâi pêna chu bôk rang nâng mak.” ");
INSERT INTO sch_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Mi chungroi jêk no ungla, Pathien'n nin chungroi jêk no nih, ");
INSERT INTO sch_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","mi chungroi nin jêk angdênin Pathien'n nin chungroi jêk a ta, male midangngei chunga balam nin mang anghan nin chunga khom a mang rang ani. ");
INSERT INTO sch_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Hanchu, ithomo ni mita thingbong om hah mindon loiin nu sûngsuok mita ronok chînte om hah nu mu hi? ");
INSERT INTO sch_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Inmo ni mita thingbong om chienin nu sûngsuok kôm, ‘Rangâihoitakin, ni mita ronok chînte hah nang pai pe rong,’ ni ti ngam? ");
INSERT INTO sch_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nangma asarothol! Ni mita thingbong hah pai bak inla, hanchu, nu sûngsuok mita ronok chînte aom pai rangin ânthârlakin mu thei ni tih. ");
INSERT INTO sch_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Uingei kôm neinun inthieng hah pêk no ungla, hong inhei an ta nangni pêt an tih. Vokngei makunga khom nin lungmantam hah vôr no roi, an kên chîlpol an tih.” ");
INSERT INTO sch_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Zong ungla pêkin om nin tih, rok ungla man nin tih; tôk roi, inkhâr nangni mo-ong pe nîng atih. ");
INSERT INTO sch_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tukhom a zong kai chu pêk nîng an ta, a rok kaiin chu man an ta, a tôk kai chu inkhâr mo ong pe nîng atih. ");
INSERT INTO sch_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nangni pangei lâia tukhomin nin nâingei vâipôl nangni zong senla ngei, lung nin pêk rang mini? ");
INSERT INTO sch_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Aninônchu, nga nangni zong senla ngei, murûl nin pêk rang mini? ");
INSERT INTO sch_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nangni misie ngeiin luo nin nâingei neinun sa pêk nin rietin te, invâna nin Pa vângin chu a zongngei kôm neinun sa a pêk mintam bâk rang na! ");
INSERT INTO sch_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Mîn nin chunga an sin rang nin nuom tak hah mi chunga khom sin roi: mahi Moses Balam le dêipungei minchûna omtie chu ani.” ");
INSERT INTO sch_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Mokot ân-epa han lût roi, meidîl mokot chu ânzara, a lampui khom ahoia, a se khom tamtak an ni sikin. ");
INSERT INTO sch_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Aniatachu ringna mokot chu ân-epa, asena lampui khom ântaka, aman ngei khom mi tômte an ni.” ");
INSERT INTO sch_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Dêipu dikloingei renga indîn roi; pêntieng chu belri angin nin kôm an honga, ania an sûngtieng chu melangngei tatak angin an ni. ");
INSERT INTO sch_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ma ngei hah chu an sinthoa riet kelen nin tih. Riling rângngei han grape inra ngâi maka, riling kungngeia khom theichangngei inrâ ngâi maka. ");
INSERT INTO sch_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Thingkung asa chu amara khom asa ngâi, thingkung saloi chu amara khom asiet ngâi ani. ");
INSERT INTO sch_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Thingkung adamin chu amara siet ngâi maka, thingkung adamloiin chu amara sa ngâi mak ani. ");
INSERT INTO sch_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Thingkung murdi amara saloi chu an phûra meia an vôrpai ngâi. ");
INSERT INTO sch_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Masikin dêipu dikloingei chu an sinthoa riet thei nin tih. ");
INSERT INTO sch_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Pumapa, Pumapa, mi ti papai murdi invân Rêngrama lût noni ngeia, invâna ka Pa lungdo sinngei kai kêng an lût rang ani. ");
INSERT INTO sch_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Roijêk Nikhuo ahong tungin chu mi tamtakin, ‘Pumapa, Pumapa! Ni rimingin Pathien thurchi kin misîr ngâia, ramkhoringei kin rujûl ngâia, sininkhêl khom mun tamtaka kin sin ngâi!’ la tîng an tih. ");
INSERT INTO sch_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ma tikin chu keiman an kôm, ‘Nangni riet tet ngâi mu-ung. Ko kôm renga rotpai roi, nangni misiengei!’ la tîng ki tih. ");
INSERT INTO sch_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Masikin tukhomin hi ko chongngei hih a rieta jôm chu mivâr lungpui chunga in sinpu angin ani. ");
INSERT INTO sch_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ruo ajuonga, tui ahong liena, phâivuo ahong râta, ma in hah ahong nama. Aniatachu inlet mak, lungpui chunga sin ani sikin. ");
INSERT INTO sch_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Hannirese, tukhom hi ko chongngei a rieta, jômloi chu amo sietsâi chunga in sin angin ani. ");
INSERT INTO sch_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ruo ajuonga, tui ahong liena, phâivuo ahong râta, ma in hah ahong nama, ânleta. Ânlet tie khom ana sabak ani!” ");
INSERT INTO sch_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jisua'n ma neinunngei hah a misîr suole chu loko ngeiin a minchuna hah an kamâm sabak ani. ");
INSERT INTO sch_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ama chu Balam minchupungei angin niloiin; manêkin chu, rachamneina leh mi a minchu ani. ");
INSERT INTO sch_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisua hah tâng renga a juong chum lehan chu mipui tamtakin an jûia. ");
INSERT INTO sch_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Hanchu a kôm mi phâr inkhat a honga, a makunga khûkinbilin, “Pu, nu nuomin chu, mi ni minthieng thei,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jisua'n a kut a hongsôna, a tôna, “Ku nuom, Inthieng ta roh!” tiin a thuona. Harenghan a phâr hah ahon thieng kelena. ");
INSERT INTO sch_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Male Jisua'n a kôm han, “Rangâi roh! Tute ril no roh, hannirese, Ochai kôm thengpat inla, va min en roh; hanchu mi murdîn na damzoi, ti an rietna rangin Moses'n inbôlna pêk ranga a lei khâmsai hah va pêk roh a tipea.” ");
INSERT INTO sch_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisua capernaum khuoa a hong lûtin chu, Rom râlmi ruoipu ahon tongpuia san rangin ânvûia: ");
INSERT INTO sch_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Pu, ki tîrlâm damloiin insûnga jâlmuna sînginsa theiloiin ana sabakin aom,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jisua'n, “Hong ka ta mindam ki tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ruoipu han a kôm, “O Pu, ma anghan nimak,” tiin a thuona. “Ki ina chu nu lûtna ngâi jât nimak. Chongbâi korongin tiin la ki tîrlâm dam kelen a tih. ");
INSERT INTO sch_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kei khom ruoipu inchungtak rachamneina nuoia om ki nia, male ku nuoia khom râlmingei an oma. Mi inkhat kôm, ‘Se roh!’ tiin chong ke pêkin chu a se ngâia, midang inkhat kôm ‘Hong roh!’ tiin chong ke pêkin chu a hong ngâi; male ki tîrlâm kôm khom, ‘Mahi sin roh!’ ki tiin chu a sin ngâi.” ");
INSERT INTO sch_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jisua'n ma chong hah a rietin chu a kamâm sabaka, loko a jûingei kôm han, “Nangni ki ril, Israelngei lâia khom tute hima dôra taksônna dôn hi chu la mu tet ngâi mu-ung. ");
INSERT INTO sch_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Adiktakin nangni ki ril, nisuo tieng le nitâk tieng renga mi tamtak hong an ta, Abraham, Isaac, Jacob ngei kôm invân Rêngrama ruolhoia insung an tih. ");
INSERT INTO sch_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Aniatachu Rêngram nâingei hah chu pêntieng ijînga paiin om an ta, male mahan chap le hâ rielin om an tih.” ");
INSERT INTO sch_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Male Jisua'n râlmi ruoipu tîrlâm kôm han, “Ni ina se ta roh, ni iem angin nata rangin sin nîng atih,” a tia. Hanchu ma mit misim kongkâr han râlmi ruoipu tîrlâm hah a dam zoi. ");
INSERT INTO sch_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jisua hah Peter ina a sea, Peter tarpi jâlmuna jâlin ritun damloiin a juong mua. ");
INSERT INTO sch_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Amanu kut hah a tôn pea, a mintun hah a mathâna, male ânthoia a sin a tho pe zoi ani. ");
INSERT INTO sch_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kholoi ahong nînchu, mipui ngeiin, Jisua kôm ramkhori sûr mi tamtak an hong tuonga. Jisua'n chongbâiin ratha saloi ngei hah a notpaia, male damloi murdi khom an dam sa zoi. ");
INSERT INTO sch_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Dêipu Isaiah'n, “Ama lelên ei natna ngei a lâk paia, ei damloina ngei a pêl zoi,” tia alei misîr hah ahong tung adik theina rangin maha a tho ani. ");
INSERT INTO sch_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jisua'n mipui ngei an hong ûm a mûn chu, dîl râl tienga inkân rangin a ruoisingei chong a pêk ngeia. ");
INSERT INTO sch_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Balam minchupu a kôm ahonga. “Minchupu,” “Ne sena muntina nangma leh se rangin inthoksai ki ni zoi,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jisua'n a kôm han, “Sialngei kuo an dôna, vangei khomin rubu an dôna, aniatachu Miriem Nâipasal chu a lu minngamna rang luo dôn mak,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Midang inkhat, ruoisi lâia mi han a kôm, “Pu, insûnga mi min se nôk inla, ka pa la vaphûm bak hi rong,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jisua'n a kôm han, “Ni jûi roh, mithi ngeiin an mithi champui chu phûm rese ngei,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jisua rukuong chunga a chuonga, a ruoisingei khom ama leh an se sa. ");
INSERT INTO sch_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Inningloiin phâivuopui râttak hah dîl ahong dea, male rukuong hah ngîm rang dôrin tuidâr ânsoka. Aniatachu Jisua chu a lei inphara. ");
INSERT INTO sch_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ruoisingei hah a kôm an sea, an va kaithoia. “Pumapa, mi sanmojôk ta roh! kin thi rang kêng ani zoi!” an tia. ");
INSERT INTO sch_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jisua'n an kôm han, “Ithomo nin chi bâka?” “Nin taksôna dôn khom hi idôrtaka chîn mo ani zoi!” tiin a thuona. Hanchu ânthoia, phâivuopui le tuidârinsok hah mong rangin chong a pêka, male chu ânthim ngung zoi. ");
INSERT INTO sch_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Mi murdi'n an kamâm sabaka, “Hi mi hih kho anga miriem mo ani hi? Phâivuopui le tuidârinsok ten khom a chong an jôm hi!” an tia. ");
INSERT INTO sch_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Dîl râl tieng Gadara rama Jisua a hongtung lehan, ramkhori sûr mi inik thân renga hongsuok ngeiin an intongpuia, Ma ngei hah chi an om sikin ma lampuia han tute se ngam ngâi mak ngeia. ");
INSERT INTO sch_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Harenghan anni hah an in-ieka, “Pathien Nâipasal, imo mi lo rang ni ti? Zora khâm atung mân dûk mi tho ranga juong mo ni ni?” an tia. ");
INSERT INTO sch_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ala bâkloina han vok pâlpa sâk rok an oma. ");
INSERT INTO sch_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Masikin ramkhoringei han, “Mi ni rujûl rangin chu vok pâlngei sûnga son mi min se roh,” tiin Jisua an ngêna. ");
INSERT INTO sch_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jisua'n, “Se roi,” a tipe ngeia; hanchu an jôka, vokngei sûnga an va lûta. Vok pâl murdi hah dîl rakham rôlsora an tânna, dîla an tâkriei zoi ani. ");
INSERT INTO sch_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Vok donsûi mingei hah an tânna, khopui sûnga an sea, a thurchi anrêngin an va misîra, ramkhori sûrngei chunga neinun omtie ngei murdi khom hah an va misîr zoia. ");
INSERT INTO sch_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Masikin khopui renga mi murdi Jisua intongpui rangin an suoka; male an va mua anin chu, an ram renga jôkpai rangin an ngên zoi. ");
INSERT INTO sch_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisua rukuonga a chuonga, dîl râl rakânin a omna khopui tieng a kîr nôka, ");
INSERT INTO sch_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","mahan mi senkhat ngeiin phalkhatthi a jâlmun leh a kôm an hong rojôna. Jisua'n taksôn an dôntie hah a mua, phalkhatthipa kôm han, “Ka nâipasal rathanngam takin om roh! na nunsiengei ngâidam ani zoi,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Hanchu Balam minchupu senkhat ngeiin an mulungrîlin, “Hi mi hin Pathien a rilsiet kêng!” an tia. ");
INSERT INTO sch_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jisua'n an mulungrîla an mindon ngei hah a lei rieta, masikin an kôm han, “Ithomo ma anga neinun saloi hah nin mulungrîla nin mindon? ");
INSERT INTO sch_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","‘Nu nunsiengei ngâidam ani zoi,’ nônchu, ‘Inthoi inla, lôn ta roh,’ ti hih kho hi mo a ti abai uol? ");
INSERT INTO sch_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Miriem Nâipasal hih pilchunga nunsiengei ngâidam theina rachamneina a dôn, ti nangni lei min mu rong” a tia. Masikin phalkhatthipa kôm han, “Inthoi inla, na jâlmun luok inla, ni ina se ta roh!” a tipea. ");
INSERT INTO sch_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ha mi hah ânthoia male a ina a se zoi. ");
INSERT INTO sch_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mipui ngei han maha an mûn chu, an chia, miriemngei kôma ma anga rachamneina pêkpu Pathien an minpâk zoi ani. ");
INSERT INTO sch_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisua'n ha mun hah a mâka, a senân sum rusuongpu inkhat a riming Matthew an ti, a sukmuna ânsung lâitak a mua, a kôm, “Ni jûi roh,” a tipea. Matthew hah ânthoia, a jûi kelen zoi. ");
INSERT INTO sch_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jisua hah Matthew ina bu a nêk lâitakin, sum rusuongpu tamtakngei le mitelloi ngei an honga, Jisua le a ruoisingei dosânga bu an nêkpui ngei sa zoi. ");
INSERT INTO sch_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pharisee senkhat ngeiin maha an mûn chu a ruoisingei kôm han, “Ithomo nangni minchupu'n hi anga mingei leh bu a nêka hi?” tiin an rekel ngeia. ");
INSERT INTO sch_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jisua'n an chong hah a lei rieta, an kôm han, “Mi dam ngeiin doctor nâng ngâi mak ngeia, mi damloi ngei vaiin kêng an nâng ngâi. ");
INSERT INTO sch_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Pathien lekhabu'n: ‘Lungkhamna kêng ku nuom, inbôlna sa ngei nuom mu-ung,’ a ti hih, se ungla a omtie va riet roi. Midikngei ralam ranga juong ni mu-unga, midikloingei ralam ranga juong kêng ki ni,” tiin a thuon ngeia. ");
INSERT INTO sch_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Male, Baptispu John nûkjûi ngei Jisua kôm an honga, “Ithomo keini le Phariseengei hin bungêi kin tho bang ngâia, na ruoisingei rêkinte an ngêi tet ngâi loi?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jisua'n an kôm han, “Inneina sâknêk thona taka khuolmingei hah moipumapa an kôm aom sûngin an beimindong rangin nin mindon mini? Ni thei no ni! Hannirese, an kôm renga moipumapa an tuong pai pe nikhuo la tung ata, ma tikin chu bu la ngêi an tih. ");
INSERT INTO sch_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Tutên puon muruo hah puon thar hâr leh chitpho ngâi mak ngeia, puon thar hah inchirup ata, puon an ongna hah manêkin lien uol nôk atih. ");
INSERT INTO sch_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tutên uain thar savun ûm muruoa thun ngâi mak ngeia, thun ngân senla, uain thar han savun ûm hah mûtkhoi ata, uain le savun ûm hah mangnaboi chang atih. Manêkin chu uain thar chu savun ûm thara an thuna, an ruonin asa ngâi a tia.” ");
INSERT INTO sch_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisua'n hi chong hih a misîr lâitakin, Juda ruoipu inkhat a honga, a makunga, khûkinbilin a kôm han, “Ka nâinupang atûn renghan a thia; aniatachu hong inla, a chunga nu kut minngam inla, hong ring nôk a tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Masikin Jisua ânthoia male a jûia, a ruoisingei khom ama leh an se sa. ");
INSERT INTO sch_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Nuvengte inkhat kum sômleinik hulloia damloinu han Jisua nûka a honga male a puonmor a tôna. ");
INSERT INTO sch_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Amanu nanâkin “A puon morte luo khom tôn inlang chu dam kelen ki tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jisua ânhei titira male amanu hah a mua, a kôm, “Ka nâinupang rathanngam takin om roh! na taksônna hih na dampuina ani,” a tia. Ha mit misim kongkâr han nuvengtenu hah a hong dam zoi. ");
INSERT INTO sch_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Hanchu, Jisua hah ruoipu ina han a lûta. Berlem tum ngâi ngei le mithi-uop mipui kuorchok omngei hah ava mûn chu an kôm han, ");
INSERT INTO sch_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","nin rêngin “Jôkpai roi! Nupangte hih athi nimaka, a in kêng!” a tia. Hanchu anni han ama hah an munuisana. ");
INSERT INTO sch_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Hannirese, mipui ngei an notpai ngei suole harenghan, Jisua hah nupangte omna khâltana han a lûta a kut a sûr pea nupangte hah a hon thoi zoi. ");
INSERT INTO sch_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ma roi hah ma ram pumpuia han ânthang zit zoi. ");
INSERT INTO sch_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisua'n ma mun hah a mâka, ava sên chu mitcho inikin an jûia, “David Nâipasal, inrieng mi mu roh!” tiin ân in-ieka. ");
INSERT INTO sch_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jisua insûnga a lûtin chu, mitcho inik ngei hah a kôm an honga, male Jisua'n an kôm, “Nangni mindam thei ki tih, ti nin iem mo?” tiin a rekel ngeia. “O kin iem, Pu!” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Male Jisua'n an mitngei a tôna, an kôm, “Nin iem anghan nin chunga tung rese!” a tia. ");
INSERT INTO sch_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Hanchu an mit ahong vâr pe ngei zoi. Jisua'n, “Mahi tute kôm ril no roi!” tiin chong a be ngei sabaka. ");
INSERT INTO sch_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Hannirese, anni ngei hah an sea, ma ram pumpuia han Jisua chungroi hah an va mazarzit zoi ani. ");
INSERT INTO sch_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ha mingei hah an mâkin chu, mi senkhat ramkhori sûr chong theiloi inkhat Jisua kôm an hong tuonga. ");
INSERT INTO sch_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Aniatachu ramkhori hah notpai ani suole, harenghan ma miriem hah a hong chong thei zoia, mi murdi'n an kamâm sabak zoi. “Israelngei lâia hima anga mi reng hih la mu ngâi mak me!” an tia. ");
INSERT INTO sch_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Aniatachu Phariseengeiin chu, “Ramkhoringei an ulientakpa'n kêng Jisua hih ramkhori rujûl theina ranak a pêk ani hi,” an tia. ");
INSERT INTO sch_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisua'n khopuingei le khuo chîn ngeia a chai titira. Synagog inngeia a minchua, Rêngram Thurchi Sa a misîra, damloi murdi le natna jât tamtakngei a mindama. ");
INSERT INTO sch_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Mipui ngei hah a mûn chu, a mulungrîla anni ngei inriengmunân a sipa, belringei ahôlpu boi angin, kângdoiin le san rang boiin an om anni sikin. ");
INSERT INTO sch_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Masikin a ruoisingei kôm han, “Bu ât rang chu atam sabaka, aniatachu, a mintûp ranga sinthopungei chu tômte an ni. ");
INSERT INTO sch_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Masikin a bu ât ranga sinthopu ngei a juongtîrna rangin bu pumapa kôm han chubai tho roi,” a ti. ");
INSERT INTO sch_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisua'n a ruoisi sômleinik ngei hah a koitûp ngeia, ratha saloi ngei rujûlpai theina le damloina le ri murdi mindam theina ranak a pêk ngeia. ");
INSERT INTO sch_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Tîrton sômleinik ngei riming chu hi ngei hih an ni: Amotontaka Simon (Peter an ti) le a nâipa Andrew; Jebedee nâipasal inik Jacob le a nâipa John, ");
INSERT INTO sch_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip le Bartholomew; Thomas le chôiruol rusuongpu Mathew; Alphaeus nâipasal Jacob le Thaddaeus; ");
INSERT INTO sch_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Canan mi Simon le a minsûrpu Judas Iscariot ngei an ni. ");
INSERT INTO sch_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Hi miriem sômleinik ngei hih Jisua'n a tîr ngeia, an kôm hi angin a ril ngeia: “Jentailngei rama le Samari mingei khopuingeia chu se no roi. ");
INSERT INTO sch_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Manêkin, Israel mingei lâia belri inmangngei kôm nin se rang ani. ");
INSERT INTO sch_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Se ungla, ‘Invân Rêngram chu anâi zoi!’ tiin va misîr roi. ");
INSERT INTO sch_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Damloingei mindam ungla, athi ngei kaithoi ungla, aphârngei minthieng ungla, ramkhoringei rujûlpai roi. Manboia nin man ania, manboi nanâkin pêk roi. ");
INSERT INTO sch_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nin pepa rângkachak sumdâr mo, ruphâi mo, sumsen mo chôi no roi; ");
INSERT INTO sch_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","nin chaina rangin cholite mo, kancholi bob mo, kekok bob mo, khiengrol bob mo chôi no roi. Sinthopungei chu an nângngei hah pêk rang ani. ");
INSERT INTO sch_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Khopuia mo, khochinna mo nin lûtin nangni mintung rang nuoma nangni lei phâm mi rok ungla, ma mun hah nin mâknôk mâka chu ama kôm han om tit roi. ");
INSERT INTO sch_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Insûng nin lûtin chu, ‘Nin chunga rathanngamna om rese,’ ti roi. ");
INSERT INTO sch_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ma ina omngei han nangni an lei modômin chu nin rathanngamna chibaimûkna hah an chunga tung rese; hannirese nangni an lei modôm nôn chu nin chibai chongbâi hah lâk mikhîr nôk roi. ");
INSERT INTO sch_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Male, kho in khoma, kho khuo khoma nangni an lei phâm noa, nin chong an rangâi nôn chu ma mun hah mâkrak ungla, nin kea pildi hah không mathâk roi. ");
INSERT INTO sch_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Adiktakin nangni ki ril, Roijêk Nikhuon chu ha khopuia mingei tuong rang nêkin chu Pathien'n Sodom le Gomora khopuia mingei tuong rang chu inriengmuna minlang uol a tih!” ");
INSERT INTO sch_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Rangâi roi! Melang pâl kâra belri om angin nangni ki tîr ani. Murûlngei anghan vârin le vasu-ngei anghan nuninêmin nin om ngêt rang ani. ");
INSERT INTO sch_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Aniatachu indîn roi, nangni sûra, roijêknamuna nangni tuonga, synagog inngeia nangni vîk rang an om rang sikin. ");
INSERT INTO sch_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Keima sika roijêkpungei le rêngngei makunga lân ding nin tih, anni le Jentailngei Thurchi Sa nin misîr pe ngei theina rangin. ");
INSERT INTO sch_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nin chung roijêk ranga nangni an tuong tika, imo nin ti rang aninônchu kho angin mo nin ti rang lei mindonin nan kângmindoi no roi; azora ahong tungin chu nin ti rang hah pêkin om nin tih. ");
INSERT INTO sch_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Chong nin ti rang ngei hah nangni nin chong nino nia; nin Pa Ratha renga juongin nangnia a chong rang ani. ");
INSERT INTO sch_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Miriemngeiin an lâibungngei nanâk khom that rangin la minsûr an ta, ma angdên han pangei khomin an nâingei la minsûr sâng an ta; nâingei khomin an nulepangei doi an ta male that ngei an tih. ");
INSERT INTO sch_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Keima sikin mitinin nangni mumâk an tih. Aniatachu tukhom among dêna tuongdierpu chu sanminringin om an tih. ");
INSERT INTO sch_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Khopui inkhata an nuom nangni an lôn chu khopui danga rotpat roi. Adiktakin nangni ki ril, Miriem Nâipasal a juong mân Israel rama khopuingei murdia nin sintho zoi no tunui. ");
INSERT INTO sch_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Inchulâi hah a minchupu nêkin lien uol mak; suok khom a pu nêkin lien uol mak. ");
INSERT INTO sch_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Masikin inchulâi hah a minchupu angin hong om rang hah a mulung a minchuk rang ani, tîrlâm khom a pu angin hong om rang hah a mulung achuk rang ani. In pumapa luo Beelzebul, tiin an koiin te, a in mingei vang chu khodôra riming saloi uolin mo an koi rang ni zoi!” ");
INSERT INTO sch_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Masikin miriemngei hah chi no roi. Atûna thupa om murdi lân lang let ata, ippa om murdi la phuong nîng atih. ");
INSERT INTO sch_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ajînga nangni ki ril hih sûnkhovâra misîr ungla, kuor kunga nin riet hih inchungsîpa chuongin tânghâi roi. ");
INSERT INTO sch_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Taksa thata ratha that theiloi ngei chu chi no ungla; manêk han Pathien meidîla taksa le ratha anruona that theipu hah chi roi. ");
INSERT INTO sch_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Invâ inik poisakhatin nin rochôk thei, nikhomrese, an lâia inkhat luo nin Pa rachamin ninôn chu pilchunga tak noni ngei. ");
INSERT INTO sch_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ma anghan nangni rang khom nin samsang tena khom tellet kêng ani. ");
INSERT INTO sch_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Masikin chi no roi; invâ tamtakngei nêkin nin lût uol ok kêng! ");
INSERT INTO sch_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Tutu loko rieta ni thop kai chu kei khom invâna ka pa makunga thop ki tih. ");
INSERT INTO sch_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Aniatachu tutu loko rieta ni heng kai chu invâna ka Pa makunga heng ki tih. ");
INSERT INTO sch_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Rammuola hin inngêina minlêng ranga juongin mi mindon no roi. Inngêina minlêng ranga juong ni mu unga, khandai minlêng ranga juong kêng ki ni. ");
INSERT INTO sch_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nâipasalngeiin an pangei mindoi rang, nâinupangngeiin an nungei mindoi rang, moi ngeiin an tarpingei mindoi ranga juong kêng ki ni; ");
INSERT INTO sch_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","na râl saloitakngei chu ni insûng mingei nanâk nîng an tih. ");
INSERT INTO sch_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Tutu keima nêka an nungei mo, an pangei mo lungkham uol ngei chu ku ruoisi rangin chuk mak ngei; tutu keima nêka an nâipasalngei mo, an nâinupangngei mo lungkham uol ngei chu ka ruoisi rangin chuk mak ngei. ");
INSERT INTO sch_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Tutu an khros ruputa ku nûk jûiloi ngei chu ku ruoisi rangin chuk mak ngei. ");
INSERT INTO sch_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tutu an ringna man rang bôk ngei kaiin chu machân an ta; aniatachu, keima rang sika an ringna machân ngei kaiin chu man uol an tih. ");
INSERT INTO sch_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Tukhom nangni modôm chu keima ni modôm ani, tukhom keima ni pom chu mitîrpu a pom ani. ");
INSERT INTO sch_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Tukhom Pathien tîrlam hah Pathien tîrlam anina sikin a lei modômin chu Pathien tîrlam, râisânman chang sâng a tih. Tukhom misa hah misa anina sikin a lei pomin chu misa râisânman chang sâng a tih. ");
INSERT INTO sch_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Tukhom ku nûkjûi ngei lâia a chîntak khom ka ruoisi anina sikin tuidâi kilât khat khom lei min nêk chu, nangni ki ril, râisânman chu man ngêt a tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisua'n hi rilnangei hih a ruoisi sômleinik ngei kôm a pêk suolechu, ma mun hah a mâka, male a revêla khopuingeia minchu rang le thurchi misîr rangin a se zoia. ");
INSERT INTO sch_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Baptispu John'n Jisua sintho ngei hah jêl ina a lei rietin chu, a ruoisingei senkhat Jisua kôm a tîra. ");
INSERT INTO sch_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Jisua kôm han, “Ni ril roh, ‘John'n a juong rangpu a ti hah nini mo?’ Aninônchu mi dang kin la sabei rang mo?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jisua'n an kôm, “Se nôk ungla, neinun nin mu le nin riet ngei hih John kôm va ril roi: ");
INSERT INTO sch_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","mitcho ngeiin an mu thei zoi, kholrangeiin an lôn thei zoi, vun ri saloitak ngei minthieng ani zoi, kuorsêtngei khom an riet thei zoi, athi ngei minring nôk ani zoi, inriengngei kôm Thurchi Sa misîr ani zoi. ");
INSERT INTO sch_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tutu ku chungroia mulungokchâna neiloi ngei chu satvur an ni!” tiin a ani thuon ngeia. ");
INSERT INTO sch_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","John ruoisingei hah an se nôkin chu, Jisu a'n lokongei kôm han John chungroi a misîra: “John kôm ramchâra nin se lâihan imo mu rangin nin sabei ha? Phâivuo'n sûlngei asêm minkûm hah mo? ");
INSERT INTO sch_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Imo en rangin nin se? Mi puon innêmngei leh invo mo? Ma anga ânvo ngâi mingei chu rêng-ina kêng an om ngâi! ");
INSERT INTO sch_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ni ril roi, imo en rangin nin se? Dêipu mo? Ani tatak, aniatachu, dêipu nêka lien uol ok nin mu hi te. ");
INSERT INTO sch_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","John chungroi rang hi kêng Pathien Lekhabu'n, ‘Pathien'n ki tîrlam no motona na lampui mo-ong rangin tîr ki tih,’ a lei ti hah ani. ");
INSERT INTO sch_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Adiktakin nangni ki ti, Baptispu John nêka lien uol tute lân zir ngâi mak ngei. Hannirese, invân Rêngrama a chintakpu khom John nêkin chu alien uol ani. ");
INSERT INTO sch_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Baptispu John'n a thurchi a misîr lâi renga aviensûn tena invân Rêngram chu rangrâta doina ngei atuong ngâia, mi tukdullien ngeiin ma ram hah lâk rang an pût ngâi. ");
INSERT INTO sch_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Dêipungei murdi le Moses Balam chong han John juong om dênin, Rêngram Thurchi an misîra; ");
INSERT INTO sch_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","an thurchi misîr nin iem nuomin chu, a juong rang chongphuonga lei om chu, John hih Elijah ani. ");
INSERT INTO sch_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Hanchu, kuor nin dônin chu rangai roi! ");
INSERT INTO sch_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Atûn lâia thoitharngei hih ile mo ki mintêk rang? Nâipangngei bazar muna insungngei angin an ni, pâl khatin pâl dangngei an mi-ieaka, ");
INSERT INTO sch_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Inneina miringhoi nangni kin tum pea, aniatachu, lâm mak cheia! Chûlna la kin tho khomin chap mak chei!’ ");
INSERT INTO sch_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","John a juong lâihan bu a ngêia, uain nêk maka, mitinin, ‘Ama chu ramkhori sûr kêng an tia!’ ");
INSERT INTO sch_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Miriem Nâipasal chu a juonga, a sâka, a nêka, mitinin, ‘Hi mi hih en ta u! Bu mudupa le uain mudupa, sum rusuongngei leh midikloi ngei malpa so!’ an tia. Nikhomrese, Pathien vârna chu adik iti a mara han minlangin aom ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jisua'n sininkhêl a thona khopuingeia mingei han an nunsienangei renga inhei mak ngeia, masikin ha khopuingei hah a ngo ngeia. ");
INSERT INTO sch_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Korazin, nu chungroi arik bah na! Bethsaida, khom nu chungroi arik bah na! Nangnia sininkhêl sina omngei hah Tyre le Sidon'a lei sin nisenla chu, ma taka mingei han an nunsiena ngei renga an inhei minlangnân thoilapuon insilin ruvuta an inbuolna sôt atih zoi! ");
INSERT INTO sch_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Adiktakin nangni ki ril, Roijêk Nikhuon chu Pathien'n nangni nêkin chu Tyre le Sidon mingei chunga mulungjûrpuina minlang uol atih! ");
INSERT INTO sch_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nangma, Capernaum rang khom! nangma nethenin invân dênin indomsâng rang nu nuom mini? Meidîla vôrpai nîng ni tih! Nu sûnga sininkhêl sina omngei hah Sodom'a lei sin nisenla chu aviensûn tena hin la om tit atih! ");
INSERT INTO sch_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nang ki ril, Roijêk Nikhuon chu Pathien'n nangma nêkin chu Sodom chunga mulungjûrpuina minlang uol atih!” a tia. ");
INSERT INTO sch_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ma zora lâihan Jisua'n, “Pa, invân le pilchung Pumapa! mivâr, mitheingei kôma ni ip hah mi inmôlngei kôm ni minlang sikin no kôm râisânchong ki ril. ");
INSERT INTO sch_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ani, Pa, ma anga hongni rang hah nu lungdo tak ani. ");
INSERT INTO sch_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Neinunngei murdi ka Pa'n ni pêk zoi. Pa tiloiin chu tutên Nâipasal hah riet mak ngei, male Nâipasal tiloiin chu tutên Pa khom riet mak ngei, Nâipasalin ân phuongna ranga a thang ngeia tiloiin chu. ");
INSERT INTO sch_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Nangni, puok rik pêla sôlngei, nin rêngin ko kôm hong ungla, keima'n inngamna nangni pêk ki tih. ");
INSERT INTO sch_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ki ringkol lâk ungla pêl roi, male ko kôm inchû roi, ratha han nuninnêm tak le rangâiinchîn tak ki ni sikin; inngamna man nin tih. ");
INSERT INTO sch_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ki ringkol nangni ke pêk rang chu apêl ahoia, ku puok khom ajânghiei ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sûn sôtbâkloi suolechu Sabbathnin Jisua bubilngeia a lôna. A ruoisingei an von achâma, masikin buvûingei chinin an chipa. ");
INSERT INTO sch_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Phariseengeiin an mu'n chu, Jisua kôm, “En ta, Sabbathnia nu ruoisingeiin an tho hih ei Balamin ai khap ani!” an tia. ");
INSERT INTO sch_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jisua'n an kôm, “David le a mingeiin an vonchâm lâia an tho hah nin la pore tet ngâiloi mo? ");
INSERT INTO sch_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ama hah Pathien ina a lûta, ama le a mingeiin Pathien kôma pêksai vâipôl, an sâk ranga Balamin ai khap ochaingei vaiin an sâk ranga phala omngâi vâipôl hah an sâk ani. ");
INSERT INTO sch_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Aninônchu, adiktakin Sabbathni racham ochai Biekina omngâi ngeiin Sabbathni balam an minchâi ngâia, hannoma, theiloiintum ngâi mak ngei ti Moses Balam lekhabu nin la pore loi mo? ");
INSERT INTO sch_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nangni ki ril, mahin neinun imini Biekin nêka roiinpui uol aom. ");
INSERT INTO sch_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Pathien lekhabu'n, ‘Inbôlna nuom mu-unga moroina kêng ku nuom,’ ai ti hih a omtie nin riet minthâr tatak nisenla chu minchâinaboi mingei hah theiloi mintum no tunui; ");
INSERT INTO sch_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Miriem Nâipasal hih Sabbathni Pumapa ani sikin,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisua'n ha mun hah mâkin synagog ina a lûta, ");
INSERT INTO sch_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","mahan mi inkhat kut phalkhatthi alei oma. Mi senkhat Jisua a tho minchâi tia nôn nuom ngei an lei om sa, masikin anni han a kôm, “Sabbathnia mi mindam hih ei Balamin a khap mo?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jisua'n an kôm, “Nin lâia tumakhatin belri inkhat dôn senla male Sabbathni han khur inthûka tâk pe senla, juong rûtin nin kelsuo loi rang mo? ");
INSERT INTO sch_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Miriem chu belri nêkin a lut uol ok ani! Masikin, Sabbathnia tumini san rangin ei Balamin mi phal ani,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Male kut phalkhatthipa kôm han, “Nu kut phar roh,” a tipea. A kut a phara, kângkhat tienga angin a hong dam phar zoi. ");
INSERT INTO sch_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Hanchu Phariseengei hah an rota male Jisua that rangtie an mintuo zoi. ");
INSERT INTO sch_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","An that rangtie an phan chungroi hah Jisua'n a rietin chu ha mun renga hah a rota; lokongeiin a nûk an jûi zoi. Damloi ngei murdi a mindam ngeia ");
INSERT INTO sch_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","male ama chungroi tute kôm misîr loi rangin chong a pêk ngeia. ");
INSERT INTO sch_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Masikin, Pathien'n dêipu Isaiah kôma alei ti hah ajuong tung adik theina rangin mahi a tho ani: ");
INSERT INTO sch_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Mahi ki tîrlâm, ka thangsaipu hah, ku lungkhampu, le a chunga ku mulungtâiriempu hah ani. A chunga ka ratha tîr ka ta, male ama'n namtinngei kôm ko roijêkna phuong a tih. ");
INSERT INTO sch_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ama chu makhal nonia, hanchu in-iek uol nonia; aninônchu lamlienngeia khom ruhulum tho noni. ");
INSERT INTO sch_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ama'n sûl ânkûichara om hah khiekpai nonia, hanchu châti athi vavâng hah khom thatrip no nih. Roijêkdikna han a zoi mâka chu khan tit a ta, ");
INSERT INTO sch_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","male mingei murdi'n ama chunga han an sabeina minngam an tih.” ");
INSERT INTO sch_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Hanchu mi senkhat ngeiin Jisua kôm han mi inkhat a mitcho le ramkhori sûr sikin chong theiloi an hong tuonga. Jisua'n ama hah a mindama, masikin ama hah a chong theia, a mu thei zoi ani. ");
INSERT INTO sch_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Jisua sintho hah lokongei murdi'n an kamâm sabaka, “Ama hih David Nâipasal ni thei ni mo?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Maha Phariseengeiin an rietin chu, “Hi mi hin ramkhoringei a rujûl theina chu an rêngpa Beelzebul'n ranak a pêk sikin ani,” tiin chong an mele. ");
INSERT INTO sch_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jisua'n imo an mindon hah a rieta, masikin an kôm, “Kho ram khom apâlpâlin an insema an indoi inlômin chu sôi ngâi mak. Kho khopui khom, aninônchu insûngmingei khom apâlpâlin an insenna an indoi inlômin chu an inlet rang ani. ");
INSERT INTO sch_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Masikin soitan rama khom pâl khatin pâl dang an doiin chu, pâl an insen tina nîng ata, male ânlet kelen rang ani! ");
INSERT INTO sch_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Beelzebul'n ranak ni pêk sikin ramkhori ngei ku rujûl thei nin tia. Asa, nônchu, nin nûkjûi ngei hah tumo ranak a pêk ngeia anni ngei han an rujûlpai ngâi? Nin nûkjûingei nanâkin an lei tho ngâi han nin tho minchâina a minlang ani! ");
INSERT INTO sch_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nimak, mahi Beelzebul nimaka, Pathien Ratha kêng ramkhori rujûlpai theina ranak ni pêk, mahin Pathien Rêngram nin kôm a juong tung zoi ti a minlang ani. ");
INSERT INTO sch_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Tutên mi rât ina lûtin a neinunngei lâk pe thei no nih, mi rât hah a khit bak nônchu; hanchu a in hah minram pe thei a tih. ");
INSERT INTO sch_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Tutu keima ranga niloi kai chu atatakin mi doi ani; tutu a mintûp ni sanloipu chu ataktakin chekaminchâi ani. ");
INSERT INTO sch_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Masikin nangni ki ril, mingei an sietna murdi le Pathien doia asaloi an ti ngei murdi chu ngâidam thei nîng ata; aniatachu, Ratha Inthieng doia asaloi an ti ngei chu ngâidam nino nih. ");
INSERT INTO sch_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Tutu Miriem Nâipasal doia asaloi an ti ngei chu ngâidam thei nîng ata; aniatachu, tutu Ratha Inthieng doia asaloi an ti ngei chu atûn le tuonsôtin ngâidam nino nih. ");
INSERT INTO sch_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Mara sa dôn rangin chu thingkung adam nin dôn ngêt anâng; thingkung damloi nin dônin chu mara saloi dôn nin tih. Thingkung chu a marân riet thei ani. ");
INSERT INTO sch_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Murûlngei nangni asaloi lei ni chienin kho-angin mo chongsa nin tho thei ranga? Mulung sûnga sipa liem hah kêng bâiin ai suo ngâi ani. ");
INSERT INTO sch_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mi sân a rochonkok renga neinun sa a kaisuo ngâia; mi saloiin chu a rochonkoka neinun saloi a kaisuo ngâi. ");
INSERT INTO sch_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Nangni ki ril, Roijêk Nikhuon chu mitinin chongkâmboi an tho ngei hah la misîr let an tih. ");
INSERT INTO sch_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Minchâinaboi mo ni ni aninônchu theiloiintum mo ni ni minthârna rangin no chongngei hah mangin nu chungroi jêk nîng atih.” ");
INSERT INTO sch_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Hanchu Balam minchupu senkhat le Pharisee senkhat ngeiin a kôm, “Minchupu, sininkhêl no tho mu rang kin nuom,” an tia. ");
INSERT INTO sch_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jisua jâminzalin an kôm, “Atûnlâia mingei idôrtaka saloi le Pathien dônloi mo nin ni zoi!” Sininkhêl tho rangin mi nin ngêna? Nimak! Dêipu Jonah sininkhêl tho tiloiin chu sininkhêl dang nangni pêk ni no nih. ");
INSERT INTO sch_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonah hah sûnthum jân thum ngapui vonsûnga a oma, ma angdên han Miriem Nâipasal hih sûnthum jân thum pil inthûk sûnga aom rang ani. ");
INSERT INTO sch_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Roijêk Nikhuon chu Nineveh mingei hah inding an ta, nangni nôn an tih; anni chu Jonah thurchi misîr an rieta; an sietnangei renga an inhei sikin; male nangni ki ril, Jonah nêka lien uol mahin aom! ");
INSERT INTO sch_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Roijêk Nikhuon chu Rêngnu Sheba hah inding a ta, nangni nôn a tih, Rêng Solomon vâr minchûna rangâi rangin a ram latak renga a hong sikin; adiktakin nangni ki ril, Solomon nêka lien uol mahin aom! ");
INSERT INTO sch_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ratha saloi hah mi sûng renga a jôkin chu inngâmna mun rokin tui boina rama a chai titira, aman loi tika chu, ");
INSERT INTO sch_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘ki ina kîr nôk ki tih’ a tia. Hanchu a kîr nôka, a in atongrieiin, phiet minsâivarin, le cherêl irin ava mua. ");
INSERT INTO sch_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Hanchu, a jôkpaia ratha dang sari ama nêka puoloi uol a hong tuong ngeia, mahan an lûta, an om zoi. Masuole chu ha miriem nunchan hah aphuta nêkin a puoloi uol ok zoi. Hima ang hin atûnlâia mi saloi ngei chunga ala tung rang ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Mipui ngei kôm han Jisua ala chong lâitakin, a nû le lâibungngei an hong tunga. Ama chongpui nuomin, pêntieng an indinga. ");
INSERT INTO sch_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Masikin ha muna mi inkhatin a kôm, “En ta, nu nû le na lâibungngei nang chongpui rang an nuoma pêntieng nang an ngâk,” a ti pea. ");
INSERT INTO sch_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jisua'n a kôm, “Tumo ku nû? Tumo ka lâibungngei?” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Male a ruoisingei tieng a khînna, “En roi! Hi ngei hih ku nû le ka lâibungngei an ni! ");
INSERT INTO sch_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tutu invâna Ka Pa lungdo sinngei hih ka lâibungngei, ka sarnungei, ku nû ngei an ni,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mani sûn nanâk han Jisua hah in mâkin dîl rakham tieng a sea, mahan minchu rangin ânsunga. ");
INSERT INTO sch_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Loko ahong intûp hah an tamrai sikin rukuonga ânsunga, loko ngei chu dîl rakhama an indinga. ");
INSERT INTO sch_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Chongmintêkngei mangin neinun tamtak a misîr pe ngei. “Rangai ta u, voikhat chu mi inkhatin burît rangin a sea. ");
INSERT INTO sch_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Loilâia sachi a rethea, senkhat lampui kôla achula, vâ ngei an honga an sâkripa. ");
INSERT INTO sch_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Senkhat lungpherpha chunga pil inphânna achula, pil abitloi sikin a hongkei kelena. ");
INSERT INTO sch_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Aniatachu nisa ahôn sânga, alumin bukung innoinarte hah a em minthêma, aruzung mathâk hah ânthûkpe loi sikin achârrip zoi. ");
INSERT INTO sch_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Sachi senkhatngei chu riling râng kâra achula, riling hah ahong insôna, adîp min mang riei zoi. ");
INSERT INTO sch_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Aniatachu, senkhat chu pil sana achula, senkhat razan, senkhat sômrukin, senkhat sômthumin ahong inra zoi.” ");
INSERT INTO sch_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Male Jisua'n chongkhârnan an kôm, “Kuor nin dônin chu rangâi roi!” a tia. ");
INSERT INTO sch_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Hanchu ruoisingei hah Jisua kôm an honga, mipui ngei kôm thurchi ni misîrin “Ithomo chongmintêk na mang ngâia?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jisua'n an kôm, “Invân Rêngram chonginthup roia rietna chu nin kôm pêk ani zoia, midang ngei kôm chu pêk nimak. ");
INSERT INTO sch_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tukhom neinun imini a dônsai kai chu pêk sa nîng ata, masikin ahundôr nêka tam dôn a tih; hannirese tukhom neinun ite dônloi chu a dônsai te hah khom lâk pe rip nîng a tih. ");
INSERT INTO sch_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","An kôm chongmintêk manga ko chongpui ngei ngâina abitak chu an ena an mu loina rang, le an rangâia, aniatachu an rietthei loina ranga ani. ");
INSERT INTO sch_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Masikin dêipu Isaiah lei ril hah an chunga ahong tung ani: ‘Hi mingei hin rangâi an ta aniatachu rietthei noni ngei; en, en an ta aniatachu mu thei noni ngeia, ");
INSERT INTO sch_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","an mulungngei alên môl zoia, an kuorngei an lei min sêt zoia, male an mitngei khom an lei sîng zoi sikin. Ninosenla, chu an mitin mûng an ta, an kuorin riet an ta, an mulungbôk ngeiin rietthei an ta, Pathien'n, ko kôm an hon heia, ke lei mindam ngei duoi mo tâk,’ a tia. ");
INSERT INTO sch_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Nangni rangin, idôra satvur mo nin ni zoi! Nin mitin a mua, nin kuorin a riet ani. ");
INSERT INTO sch_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Adiktakin nangni ki ril, nin mu hih dêipu tamtakngei le Pathien mi tam takngei mu rang an nuom sabaka, aniatachu mu thei mak ngei, nin riet khom hih a riet an nuom sabaka, hannirese riet thei mak ngei ani.” ");
INSERT INTO sch_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Hanchu, rangâi ungla, sachirethepa chongmintêk omtie hih inchu roi. ");
INSERT INTO sch_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tutu khom Rêngram thurchi rieta, aniatachu rietminthârna dônloi chu sachi lampui kôla chul angin an ni. Misie hah a honga, an mulungrîla rethea om hah a lâkpai pe ngei ngâi. ");
INSERT INTO sch_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Sachi lungpherpha chunga pil inphânna chul chu thurchi hah a riet lehan râisântaka pom kelen ngei hih an ni. ");
INSERT INTO sch_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Aniatachu ruzung inthûk amathâk loi sikin om sôt ngâi maka; ma thurchi sikin imokhat intakna mini nuomlona mini ahong om tena chu an mâk nôk kelen ngâi. ");
INSERT INTO sch_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Sachi, riling râng kâra chul chu thurchi lei rietsai ngei an ni; hannirese hi taksa ringnuna hoina le nei rang nuomna roia kangdôina ngeiin chongtak hah adîpa, mara dôn ngâi mak ngei. ");
INSERT INTO sch_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Hanchu sachi pil sana chul chu thurchi hah an rieta, male a rietthei ngei hah an ni. An mara ngei senkhat razan, senkhat sômrukin, senkhat sômthumin an hong pung ngâi,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisua'n chongmintêk dang a rilngei nôka: “Invân Rêngram chu ma ang hin ani. Mi inkhatin a loia sachi sa rethepa leh mintêk ani. ");
INSERT INTO sch_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Jân khat chu mi an inriei suole, a râl ahonga, bu lâia han bu rothol arthea, a rotpat nôka. ");
INSERT INTO sch_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Hanchu bu hah a hong mônga, ahong vuiin chu bu rothol khom ahong inlang sa zoi. ");
INSERT INTO sch_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Loi pumapa tîrlâmngei hah an honga, a kôm, ‘Pu, no loia sachi sa nerthe hah; bu rothol so kho renga hong om mini?’ an tia. ");
INSERT INTO sch_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ama'n an kôm, ‘mahah chu râlngei lei tho kêng,’ tiin a thuona. Anni han, ‘bu rotholngei so va chuon unglang nu nuom mo?’ tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Nâng mak,’ bu rothol nin chuonin chu butak khom nin phôidelsa rang kêng tiin a thuon ngeia. ");
INSERT INTO sch_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Bu ât zora dên mâka chu butak le arothol anruonin munkhatin insôn rese ngei. Hanchu bu ât ngâingei kôm bu arothol hah phoipaia, khita, hâl baka masuole butak hah ka sasiera thun rangin chong la be ta rong a tia.” ");
INSERT INTO sch_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisua'n chongmintêk dang a misîr pe ngei nôka, “Invân Rêngram chu min ancham ru a chôia, a loia a rethe ang hi ani. ");
INSERT INTO sch_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mahi chimuru murdi lâia a chîntak ani, aniatachu, ahong lien tikin chu chimu dang ngei nêka alientak ani ngâi. Thingkung ahong changa, masikin vâ ngei an honga, amachanga han rubu an phan ngâi,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jisua'n chongmintêk dang a misîr nôka: “Invân Rêngram chu nuvengte inkhatin chol a lâka vâipôl her sômminli leh athoi mâka tâidôna a minpola a bil angin ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ha ngei murdi hah Jisua'n lokongei kôm chongmintêkin a ril ngeia; chongmintêk mang loiin chu an kôm han ite misîr mak. ");
INSERT INTO sch_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Mahi a thona bi chu dêipu'n alei misîr: “An kôm chong ki rillin chongmintêk mang ka ta; Khuonsieng renga neinun inthupngei hah misîr pe ngei ki tih,” ti hah ahong tung adikna ranga ani. ");
INSERT INTO sch_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisua'n lokongei hah mâkin insûnga a lûtin chu a ruoisingei an honga, a kôm, “Loia bu rothol chongmintêk roi hah khoi tina mo mi ril roh,” an tia. ");
INSERT INTO sch_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jisua'n an kôm, “Mi sachi sa rethepu hah Miriem Nâipasal ania; ");
INSERT INTO sch_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","loi chu rammuol hih ani; Sachi sa chu Rêngram nâingei hih an ni, bu rothol chu Misie nâingei an ni; ");
INSERT INTO sch_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","male râl, bu rothol rethepu hah chu Diabol ani. Bu ât zora chu rammuol mongna rang nikhuo ania, bu âtpu ngei hah vântîrtonngei an ni. ");
INSERT INTO sch_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Bu rotholngei hah an mintûpa, meia an hâl angdên han rammuol mong tika chu ala tung rang ani: ");
INSERT INTO sch_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Miriem Nâipasal'n a vântîrtonngei hah tîr a ta, a Rêngram renga mi sietna sin ngâi ngei le saloi sin ngâi ngei chu minchun an ta, ");
INSERT INTO sch_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","mei thithei ngâiloia han pai ngei an ta, mahan chap an ta, an rakam riel an tih. ");
INSERT INTO sch_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Hanchu Pathien mingei chu an Pa Rêngrama nisa angin vâr an tih zoi. Rangâi roi, kuor nin dônnin chu! ");
INSERT INTO sch_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Invân Rêngram chu mi inkhatin loilâia rochon phûm inrûkten amu suoka; a phûm nôka, a râisân rai sikin a sea, a dônngei murdi ava juor leta, a kîr nôka male ma loi hah a rochôk angin ani. ");
INSERT INTO sch_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Invân Rêngram chu mi inkhatin lungmantam satak a roka, ");
INSERT INTO sch_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","lungmantam satak hah a mûn chu, a sea, a dônngei murdi ava juor leta, male ma lungmantam hah a rochôk angin ani. ");
INSERT INTO sch_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Invân Rêngram chu ngasûrpu senkhat ngeiin an lên dîla an vôra, nga jât da-dang an sûr angin ani nôk. ");
INSERT INTO sch_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Lên hah asipmat tena chu dîl rakhama an kaisuoa, mahan nga insem rangin an insunga: asa murdi chu koka an thuna asaloi kai chu an paia. ");
INSERT INTO sch_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Rammuol mong tika chu ma anghan la nîng atih: vântîrtonngei juong suok an ta, misangei lâi renga misaloingei hah mintûp an ta ");
INSERT INTO sch_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","mei thithei ngâiloia han pai an ta, mahan chap an ta, an hâ riel an tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jisua'n an kôm, “Ma neinungei murdi hah nin rietthei mo?” tiin a rekel ngeia. “O, kin rietthei,” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ama'n an kôm, “Ma omtie chu, Balam minchupungei murdi invân Rêngrama ruoisi changngei kai chu, in pumapa a rochondarna khâltan renga neinun thar le neinun muruo a kaisuo angin ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisua'n ma chongmintêkngei hah a misîr suolechu ma mun hah a mâka, ");
INSERT INTO sch_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","a omna ngâi khopui tieng a kîr nôka. synagog ina a minchua, a thurchi misîr ariet murdi'n chu an kamâm sabaka, “Hima anga vârna hih kho renga a man mo?” male “Sininkhêl sintheina hih kho renga a man mo?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","“Hi mi hih thing kutthiempu nâipasal hah nimak mo? Mary hah a nu nimak mo? A lâibungngei khom, Jacob, Joseph, Simon le Judas ngei nimak mo? ");
INSERT INTO sch_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","A sarnungei khom hitaka om nimak ngei mo? Kho renga mo hi ngei murdi hih a man?” ");
INSERT INTO sch_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Male ama hah an heng zoi. Jisua'n an kôm, “Dêipu chu a khopui sûnga le a insûngmingei lâia tiloiin chu muntina an mirit ngâi,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Taksônna an dônloi sikin ma mun han chu sininkhêl sin mintam ok mak ani. ");
INSERT INTO sch_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ma zora han Galilee rama, rêng Herod'n Jisua chungroi a lei rieta. ");
INSERT INTO sch_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","A sinthopu ulienngei kôm han, “Hi mi hih Baptispu John, a hong ring nôk ngêt ani rang.” “Masikin kêng hi sininkhêl sintheina ranak hih a dôn,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Motona han Herod'n John hah a lei minsûra, a khita jêl-ina alei khum ani. Ma anga a thona bitak chu a lâibungpa Philip lômnu Herodias sika ani. ");
INSERT INTO sch_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Baptispu John han Herod kôm, “Herodias lômnua ne nei hih dik mak!” a lei tipea. ");
INSERT INTO sch_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod'n ama hah that rang a jôta, aniatachu Juda mipui ngei a chi ani, John hah Dêipu'n an lei be sikin. ");
INSERT INTO sch_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herod suokni han Herodias nâinupang hah mipui ngei makunga a lâma. Herod hah a râisân tataka ");
INSERT INTO sch_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","a kôm han chonginkhâmin, “Ikhom no zong kai chu nang pêk rangin chong kên khâm!” a tia. ");
INSERT INTO sch_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Hanchu a nû'n a tipe lam angin, “Hi muna hin atûn mâirânga Baptispu John lu mi pêk roh!” tiin Herod kôm han a ngêna. ");
INSERT INTO sch_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Rêngpa han a mulungdûk atong sabak zoia, nikhomrese, a khuolmi ngei makunga chong a lênkhâm zoi sikin, a ngên lam anghan tho pe rangin chong a pêk ngeia. ");
INSERT INTO sch_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Hanchu jêl-ina han John lu hah a min tan ngei zoi. ");
INSERT INTO sch_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","A lu hah mâirânga an hong chôia, nupangte kôm an pêka, amanu han a nû kôm a chôi zoi. ");
INSERT INTO sch_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","John ruoisingei an honga, a ruok hah an chôia, an phûm zoi; hanchu an sea, Jisua an va misîr pe zoi ani. ");
INSERT INTO sch_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisua'n John chungroi a rietin chu, ma mun hah a mâka, rukuongin a theivaiin mun inthimngangna a se zoi. Ma roi hah mipuingeiin an rieta, masikin an khopuingei ha mâkin ama omna tâng tieng an jûia. ");
INSERT INTO sch_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jisua rukuong renga a jôka, mipui ngei hah a mu'n chu inrieng amu ngei tataka, male damloi ngei hah a mindama. ");
INSERT INTO sch_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mani kholoi han a ruoisingei an honga a kôm, “Nisa laka ase ok zoia, mahi mun inthimngang kêng ani; Mipui ngei hih tîrpai ngei inla, khosûngngeia se rese ngei, anthenin sâk rang rochôk rese ngei,” an ti pea. ");
INSERT INTO sch_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jisua'n an kôm, “An se rang nâng maka, nangnin an sâk rang imakhat pêk ngei roi!” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Anni han a kôm, “Hitaka kin dôn chu anrêngin vâipôl rangnga le nga inik vai kêng,” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Hanchu Jisua'n, “Hin ko kôm hong chôi roi,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mipui ngei hah durba chunga insung rangin chong a pêk ngeia; hanchu, vâipôl rangnga le nga inik hah a lâka, invân tieng tangin Pathien kôm râisânchong a rila. Vâipôlngei hah a khoia, ruoisingei kôm a pêka, male ruoisingei han mipui ngei kôm an sem zoia. ");
INSERT INTO sch_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mi murdi'n an sâka, an khoptanga, an sâk minieng tabong sômleinik an la rût minsipa. ");
INSERT INTO sch_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Asâkngei mijôn chu nupangngei le nâipangngei telloiin mi isâng rangnga dôr an ni. ");
INSERT INTO sch_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Male Jisua'n mipui ngei hah a minchînna, a ruoisingei rukuonga a min chuong ngeia, dîl râl kângkhat tieng alei min se ngeia. ");
INSERT INTO sch_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Mipui ngei a min se ngei suolechu a thenin tâng chunga chubaitho rangin a sea. Kholoi a hongnin chu, mahan Jisua atheivaiin a oma; ");
INSERT INTO sch_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ma zora han rukuong hah dîla alazanna a om zoia, phâivuo'n ale tieng asêm sikin, tuidârinsokin kângkhat tieng khom, kângkhat tieng khom a soka. ");
INSERT INTO sch_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Jînga dâr thum le dâr ruk kongkâra Jisua tui chunga lônnin, a ruoisingei kôm a honga. ");
INSERT INTO sch_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tui chunga a hong lôn an mûn chu an chia. “Mirluoi kêng!” tiin, ichin an iniek rarâka. ");
INSERT INTO sch_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jisua'n a hong rokôkngei kelena, “Nin rathamathâk no roi!” chi no roi, “Keima kêng ki ni!” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Hanchu Peter a hong chonga. “Pumapa, nangma ni ni tatakin chu, tui chunga no kôm hong rangin chong ni pêk roh,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jisua'n, “Hong roh!” tiin a thuona. Masikin Peter hah rukuong renga a jôka, Jisua kôm panin tui chunga a lôn phut zoia. ");
INSERT INTO sch_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Hannirese, phâivuo rât hah a mûn chu a chia, tuia a ngim phut zoi. “Pumapa, ni mojôk roh!” tiin a chapa. ");
INSERT INTO sch_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jisua a hong tung kelena male a muturap kelen zoia, a kôm, “Na taksônna dôn hah achîn bâkna! Ithomo ni iem zoi loi?” a tipea. ");
INSERT INTO sch_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","An ruonin rukuong sûnga an lûta, phâivuo khom ânthim ruoi zoi. ");
INSERT INTO sch_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Male rukuong sûnga ruoisingei han Jisua chubai an mûk zoi. “Pathien Nâipasal tatak kêng ni ni!” an tia. ");
INSERT INTO sch_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Dîl râl tieng an inkânin chu Genesaret ram an hong tunga, ");
INSERT INTO sch_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ma taka mingei han Jisua hah an lei riet kelena. Masikin ma revêla ram murdia han mi an tîra, damloi murdi hah Jisua kôm an hong tuonga. ");
INSERT INTO sch_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Damloi ngei hah a puon morte luo mintôn ngei rangin an ngêna; male a tôn murdi chu an dam pak zoi ani. ");
INSERT INTO sch_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Hanchu Jerusalem renga pharisee le Balam minchupungei senkhat Jisua kôm an honga male a kôm. ");
INSERT INTO sch_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ithomo nu ruoisingeiin ei pipungei chongmâk ngei hih an jôm ngâiloi? Sâk an sâk rang khomin balam angin an kut rusûk ngâi mak ngei!” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jisua'n an kôm, “Ithomo Pathien chongpêk jômloiin nin theia chongmâk nin jûi hih? ");
INSERT INTO sch_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Pathien'n, ‘Nu nû le na pa mirit tho roh,’ male ‘Tukhom a nû mo, a pa mo, khomâksâm chu that rang ani,’ a ti ani. ");
INSERT INTO sch_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Hannirese, nangnin chu tutu a nu mo, a pa mo, sanna rang imini neinun a dôna, aniatachu, ‘Mahi Pathien ta kêng ani zoi a tiin chu,’ ");
INSERT INTO sch_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","a nû mo, a pa mo mirit a tho rang nâng khâi mak nin ti ngâia. Ma ang han, nin chongmâk nin jôm theina rangin Pathien chongpêk chu itên nin be ngâiloi ani. ");
INSERT INTO sch_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nangni asarotholngei! Isaiah'n nin chungroi alei misîr hah adik bâkna!”: ");
INSERT INTO sch_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Hi mingei hin an chongbâiin min mirita, aniatachu an mulungrîl chu adiktakin kei renga alazan. ");
INSERT INTO sch_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","An miriem minchuna balamngei hah ka balamngei anghan an be sikin min biekna hih anni rangin kamnângloi kêng ani, Pathien'n a ti!” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Hanchu Jisua'n lokongei hah a kôm a koi ngeia, an kôm, “Rangâi ungla, rietthei roi! ");
INSERT INTO sch_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mi bâia lût han a minnim ngâi ni maka; manêkin chu a bâi renga hong suok han kêng a minnim ngâi,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Male a ruoisingei an honga, a kôm, “No chong han Phariseengei mulung amophop ti ni riet mo?” an tia. ");
INSERT INTO sch_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jisua'n, “Kung murdi invâna ka Pa phun niloi chu phôipaiin om an tih,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","“An chungroia nin kângmindoi no roi! Anni ngei hah mitcho ngei ruoipu mitcho an nia; mitcho hah mitcho nanâkin a kairuoiin chu an ruonin khura tâk an tih,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Peter a chonga, “Ma chong omtie hih mi rilminthâr pe roh,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jisua'n an kôm, “Midangngei nêkin atûnten la vâr uol mak chei. ");
INSERT INTO sch_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nin rietthei loi mo ani? I neinun khom miriem bâia lût murdi chu a phûnga a lûta, masuole chu a nômsena ajôkpai ngâi ani. ");
INSERT INTO sch_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Aniatachu neinunngei bâi renga hong suok chu mulungrîl renga hong suok ania, ma neinunngei hah kêng miriem minnim ngâi. ");
INSERT INTO sch_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","A mulungrîl renga mindonna saloi ngei ahong suoka, mangei han kêng a ruoia mi thatnangei, inrênangei, hur inditnangei, inrunangei, mi huongnangei le adikloi teta midang êronangei a musuok ngâi ani. ");
INSERT INTO sch_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Hi neinunngei hih, miriem minnim ngâi chu ani. Aniatachu an ti anghan nin kutngei rusûk loia sâknêk nin sâk hin chu miriem minnim ngâi mak,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisua'n ha mun hah mâkin Tyre le Sidon khopuilienngei kôla ramhuol revêla a sea. ");
INSERT INTO sch_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ha rama om Canaan nuvengte inkhat a kôm a honga, “David Nâipasal! Inrieng ni mu roh, pu! Ka nâinupang ramkhori'n a sûra, changrangintak sabakin aom ani,” tiin ânieka. ");
INSERT INTO sch_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Hannirese, Jisua'n chongbâi khat luon thuon mak. A ruoisingei a kôm an honga, “Hi nu hih tîrpai ta roh! Ei nûk mi jûia, michok chuchur!” tiin an ngêna. ");
INSERT INTO sch_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Male Jisua'n, “Israel mingei lâia belri inmangngei kôm vai kêng tîr ki ni,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ha chong hah nuvengtenu han a rietin chu a honga, a ke bula an boka. “Pu, ni san roh!” a tia. ");
INSERT INTO sch_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jisua'n, “Nâingei vâipôl lâk pea uingei kôma pêk chu dik mak,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nuvengtenu han a kôm, “Pu, maha chu adik, aniatachu uingei khomin an pungei dosâng nuoia vâipôl hâr atâk chu an sâk ngâi mo ka ta,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Masikin Jisua'n a kôm, “Nuvengtenu taksônna lientak dôn ni ni! Nu nuom tak hah na ta rangin sinin om a tih,” a tipea. Male a nâinupang hah ma zoratak han a hong dam pe zoi ani. ");
INSERT INTO sch_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisua'n ha mun renga hah a sea, Galilee dîl kôla a lôna. Tânga a kala male ân sung zoi. ");
INSERT INTO sch_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mipui tamtak a kôm an honga, kholra, mitcho, achôp, chongtheiloi le damloi dang tamtak Jisua ke bula an hong tuonga; a lei mindam ngei leta. ");
INSERT INTO sch_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Mipui ngei han chongtheiloi hong chong, ân-ûng a hong dam, kholra hong lônthei le mitcho hong muthei ngei hah an mûn chu an kamâm sabaka, hanchu Israel Pathien an minpâk zoi ani. ");
INSERT INTO sch_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Hanchu Jisua'n a ruoisingei a koia, an kôm, “Mipui ngei hih sûnthum ko kôm an om zoia, atûn hin ite sâk rang an dônloi sikin ku lungkham ngei tatak. Bungêiin tîrpai ngei rang nuom mu-ung, aninôn chu lampuia châmsôl invei an tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ruoisingei han a kôm, “Hi dôra mipui vâi minkhopna rangin hi ramchâra hin khonmo sâknêk ei man ranga?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jisua'n, “Vâipôl idôrmo nin dôn?” tiin a rekela; Anni han “Vâipôltâp sari” le “ngate atômte,” an tia. ");
INSERT INTO sch_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Masikin Jisua'n mipui ngei hah nuoia insung rangin chong a pêka. ");
INSERT INTO sch_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Male vâipôltâp sari le nga hah a lâka, Pathien kôm râisânchong rilin a khoia, ruoisingei kôm a pêka; male ruoisingei han mipui ngei kôm an pêka. ");
INSERT INTO sch_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","An rêngin an sâka an khoppaka. Hanchu ruoisingei han an sâk minieng arnôi tabông sari an rût minsipa. ");
INSERT INTO sch_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Asâkngei hah nupangngei le nâipangngei telloiin mi isâng minli an ni. ");
INSERT INTO sch_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Masuole chu Jisua'n mipui ngei a tîrpai ngei suolechu rukuonga a chuonga, Magadan ramhuol tieng a se zoi ani. ");
INSERT INTO sch_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Pharisee le Sadducee senkhatngei Jisua kôma hong ngeiin ama min-ôk rang an nuoma, masikin Pathien'n ama a pom, tih riet theina rangin sininkhêl thôn minlang rangin an ngêna. ");
INSERT INTO sch_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nikhomrese, Jisua'n an kôm, “Nisa ahong tâkin chu, ‘kôlkung asen sikin khuo ahoi rang kêng nin ti ngâi.’ ");
INSERT INTO sch_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Male jînga chu, ‘Kôl asena, invân ânnîm sikin ruo ajuong rang kêng,’ nin ti ngâi. Invân enin khuohoi rang le hoiloi rang nin leiphuong theia, aniatachu, atûnlâia minsinnangei hi chu minlen thei mak chei! ");
INSERT INTO sch_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Atûnlâi mingei hih idôrtaka saloi le pathienboi mo an ni zoi! Minsinna mi nin zong na? Nimak! Jonah minsinna hi vai kêng nin kôma minsinna nangni pêk rang chu ani zoi,” tiin a thuona. Masikin a mâk ngeia male a rotpat zoi. ");
INSERT INTO sch_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ruoisingei hah dîl râl an rakânin chu, vâipôl chôi rang an hong mingila. ");
INSERT INTO sch_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jisua'n an kôm, “Singthei roi; Phariseengei le Sadduceengei chol renga indîn roi,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Anni han, “Vâipôl ei hong chôi loi sika mahi a ti ani,” tiin an lâia an injêk phut zoi. ");
INSERT INTO sch_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jisua'n an misîrngei hah a rieta, an kôm, “Ithomo nin vâipôl hong chôi loi roi hah nin lâia nangni nanâkin nin jêk bang? Idôra taksônna chîn dôn mo nin ni zoi! ");
INSERT INTO sch_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nin la rietthei tet loi mini? Mi isâng rangnga ngei ta ranga vâipôltâp rangnga ko khoi lâia hah nin riet khâiloi mo? An sâk minieng tabong izetmo nin rût minsip ha? ");
INSERT INTO sch_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Mi isâng minli ngei ranga vâipôltâp sari chungroi rek ha te? An sâk minieng tabong izetmo nin rût minsip ha? ");
INSERT INTO sch_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nônte ithomo nin kôm vâipôl roi misîr mu-ung ti nin riet thei loi? Nangni nanâkin Phariseengei le Sadduceengei chol renga indîn roi!” a tia. ");
INSERT INTO sch_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Male ruoisingei han vâipôla chol mang ngâi renga indîn rang ni loiin, Phariseengei le Sadduceengei minchuna renga indîn ranga inningna ani ti an riet thei zoi. ");
INSERT INTO sch_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisua hah Caesarea Philippi khopui kôla ramhuola a sea, mahan a ruoisingei kôm, “Miriem Nâipasal hih mingeiin tumo ani an ti?” tiin a rekel ngeia. ");
INSERT INTO sch_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","“Senkhatin chu Baptispu John ani,” Adangngeiin chu “Elijah ani,” senkhat nôkin chu “Jeremiah aninônchu dêipu tumakhat mini, nang an ti,” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Nangnîn rêkte?” ama'n, “Tumo ki ni nin ti?” tiin a rekel ngeia. ");
INSERT INTO sch_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Peter'n a kôm, “Messiah, Pathien ring Nâipasal hah ni ni,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jisua'n a kôm, “Simon John nâipasal, na ta rangin asa bâk na! Hi chongtak hih munisi renga no kôm ahong nimaka, invâna om ka Pa'n adiktakin nang a pêk ani. ");
INSERT INTO sch_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Masikin Peter; lungpui ni ni, ti nang ki ril. Hi lungpui chunga hin ko koiindang minding ka ta, thina khomin mene no nih. ");
INSERT INTO sch_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Invân Rêngram chabi nang pêk ka ta; pilchunga na khap kai chu invâna khom khap nîng a ta, pilchunga na phal kai chu invâna khom phal ani rang ani,” a tipea. ");
INSERT INTO sch_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Male Messiah ani ti tute ril loi rangin ruoisingei hah chong a pêk ngei zoi. ");
INSERT INTO sch_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ma zora renga chu Jisua'n a ruoisingei kôm ânthârlakin a misîr phut zoia, an kôm, “Jerusalema ke se ngêt rang ani, upangei, Ochaisingei le Balam minchupungei kuta tuong ok ki tih. Thatin om ka ta, nikhomrese, sûnthum suolechu aringin kaithoiin om ki tih,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Peter'n ama hah atheiin a tuonga, a kôm, “Pathien'n maha akhap, Pumapa!” ama'n, “Mahah nu chunga tung tet no nih!” tiin a ngoa. ");
INSERT INTO sch_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jisua ânheia Peter kôm, “Soitan, ko kôm renga rotpai roh! ka lampui ni ni chakal, ni mindonngei hih Pathien renga hong suok ni maka, munisi nina renga ani sikin,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Male Jisua'n a ruoisingei kôm, “Tutu mi jûi a nuomin chu ama taksa rang mingilin a khros ruputin mi jûi rese. ");
INSERT INTO sch_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tukhom a ringna mojôk a nuom kaiin machân an ta; aniatachu, keima sika an ringna machân kaiin man an tih. ");
INSERT INTO sch_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mi'n rammuol hih apumin dôn senla, an ringna chu machân ta senla ngei, imo alâp an man ranga? Man noni ngei! An ringna man nôkna rangin ite pêk rang an dôn loi sikin. ");
INSERT INTO sch_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Miriem Nâipasal hih a Pa roiinpuinan invôn a vantîrtonngei leh a juong rang kêng ani zoi, ma tikin chu mitinin an sintho dungjûiin râisânman a pêk rang ani. ");
INSERT INTO sch_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Adiktakin nangni ki ril, hi taka om senkhatngei hih Miriem Nâipasal Rêng angin a juong an mu mâka chu thi loi rang an om,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Sûnruk suole chu Jisua'n Peter le a lâibungngei Jacob le John a tuong ngeia, an theivaiin muol insângna a se pui ngeia. ");
INSERT INTO sch_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","An mit muchungin Jisua mêl a hong inthûla: a mâi nisa angin a hong vâra, a puonsilngei khom ântêrrakin ahong cheka. ");
INSERT INTO sch_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Male ruoisingei inthum han Moses le Elijah ngeiin Jisua an chongpui an mua. ");
INSERT INTO sch_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Hanchu Peter'n Jisua kôm, “Pumapa, hitaka om hih ei ta rangin idôra asa mo ni zoi! Nu nuomin chu puon-in inthum sin ka ta, nangma rang inkhat, Moses rang inkhat male Elijah rang inkhat,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ala chonglâitakin, sûm vârin ajuong mukhu ngeia, sûmlâi renga rôl ajuon ringa, “Ama hih ka Nâipasal moroitak, a chunga ku mulungtâiriem ani, a he rangâi roi!” a tia. ");
INSERT INTO sch_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ruoisingei han rôl hah an rietin chu, an chi rai sikin pila an inbokraka. ");
INSERT INTO sch_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jisua an kôm a honga, a tôn ngeia, “Inthoi roi, chi no roi,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Masikin an ena, Jisua telloiin chu tute adang mu mak ngei. ");
INSERT INTO sch_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Muol chung renga an juong chumin chu, Jisua'n an kôm, “Miriem Nâipasal hih thina renga ânthoinôk mâka chu nin neinun mu hih tute ril no roi,” tiin chong a pêk ngei zoi. ");
INSERT INTO sch_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Male ruoisingei han Jisua kôm, “Ithomo Balam minchupungeiin Elijah a juong bak rang ani, an ti?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jisua'n, “Adiktakin Elijah a juong bak rang ani,” male “jâttin ama'n cherêl let a tih. ");
INSERT INTO sch_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Hannirese, nangni ki ril, Elijah chu a juongsai piel kêng ani zoi, mingeiin lei riet mak ngei, an nunuom an lei lo zoi. Ma angdênin Miriem Nâipasal khom an nunuom an lo rang ani,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Male ruoisingeiin Baptispu John chungroi an kôm a misîr ani, ti an hong riet zoi. ");
INSERT INTO sch_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mipui ngei kôm an kîr nôkin chu mi inkhat Jisua kôm a honga, a makunga khûkinbilin, ");
INSERT INTO sch_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","male “Pu, ka nâipasal chunga inriengmu roh! Ama chu risangol invei ania, a tuong ok zoia, voizet mo meia le tuia ânlet zoia. ");
INSERT INTO sch_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nu ruoisingei kôm ko hong tuonga, aniatachu mindam thei mak ngei,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jisua'n, “Kho anga iemnaboi rai le mi dikloi mo nin ni zoi! Idôr sôt mo nin kôm ko om rang? Idôr sôt mo nangni ko donsui thei ranga? Pasalte hah ko kôm hong tuong roi!” a tia. ");
INSERT INTO sch_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jisua'n ramkhori hah chong a pêka, male pasalte sûng renga hah a hong jôkpaia, ma zoratak han a dam kelen zoi. ");
INSERT INTO sch_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Male ruoisingei hah Jisua kôm an honga, “Ithomo keinin te ramkhori hah kin rujûlpai theiloi?” tiin mi riet loiin an rekel chiena. ");
INSERT INTO sch_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jisua'n an kôm, “Taksônna ahundôr nin dônloi sika ani.” “Adiktakin nangni ki ti, taksônna ancham ru te dôr nin dônin chu hi muol kôm hin, ‘Hi renga hih soson vânthon roh!’ tîng nin ta, inthon atih. Neinun nâm nin thothei let rang ani! ");
INSERT INTO sch_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Aniatachu, hi anga hih chu chubaithona le bungêi tinôn chu itên rujûlpai thei nimak,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ruoisingei hah an rêngin Galilee rama munkhatin an hong suokin chu, Jisua'n an kôm, “Miriem Nâipasal hih mingei kuta min sûrin om a ta, ");
INSERT INTO sch_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","anni han ama that an tih; aniatachu sûnthum suole chu aringin kaithoiin om a tih,” a tia. Ruoisingei chu beidong takin an om zoi ani. ");
INSERT INTO sch_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jisua le a ruoisingei Capernaum an hong tungin chu biekin chôiruol rusuongpu ngeiin Peter kôm an honga, “Nangni Minchupu hin biekin chôiruol a chôi ngâi mo?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Peter'n “A chôi ngâi,” tiin a thuona. Peter hah insûnga a lûtin chu, Jisua'n a lei rokôk masa, “Simon kho angin mo ni mindonlam? Hi rammuola rêngngei kôm hin tumo choîtumngei aninônchu chôiruolngei a chôi ngâi? A ramsûngmingei mo, ramdangmingei mo?” ");
INSERT INTO sch_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peter'n, “Ramdangmingei,” tiin a thuona. Jisua'n, “Asa, mahah aomtie chu a ramsûngmingei chu an chôi nâng mak, tiin chong a mele ani. ");
INSERT INTO sch_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Aniatachu hi mingei mulunghoiloi rang hi nuom mak me. Masikin dîla senla rukuoi vavôr roh. Nga no thok masatak bâia han nangma le keima rang biekin chôiruol rukbak rang sumthîr man ni tih. Mahah hong chôi inla, ei chôitum hah an kôm pêk ngei roh,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ma zora han ruoisingei Jisua kôm an honga, “Invân Rêngrama tumo alientak?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Masikin Jisua'n nâipangte a koia, an makunga a minding pe ngeia, an kôm, ");
INSERT INTO sch_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Adiktakin nangni ki ti, nin hong inthûla, nâipangte ngei angin nin om nônchu invân Rêngrama lût thei tet no tunui. ");
INSERT INTO sch_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Invân Rêngrama alientak chu amananâkin nuninêma hi nâipangte anga hong om hih ani. ");
INSERT INTO sch_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Male tukhom ki riming sika hi nâipangte anga lei modôm chu keima mi modôm an ni.” ");
INSERT INTO sch_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Tukhomin ka chunga taksônna dônngei lâia nâipangte inkhat khom hih a minpalin chu a ringa bu nôina lung lienpa minlîn tuikhanglien inthûk taka inchôm senla ata rangin sa uol atih. ");
INSERT INTO sch_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mingei an taksônna minmang pe ngâi neinunngei sikin rammuol rangin ichi aom bâk na! Inpalna ngei chu om bang a ta, aniatachu, inpalna ngei min ompu chungroi chu ichi aombâk na! ");
INSERT INTO sch_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nu kutin mo, ne ke'n mo, nang aminpalin chu tan pai inla, pai kelen roh! Kut inik mo, ke inik mo dôna kumtuong meidîla nang pai nêkin chu kut boi mo, ke boia mo ringna han lût chu na ta rangin asa uol. ");
INSERT INTO sch_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ni mit khomin nang aminpalin chu kêlpai inla, pai kelen roh! Mit inik dôna meidîla nang pai nêkin chu inkhat vai dôna ringna taka lût chu na ta rangin asa uol ani.” ");
INSERT INTO sch_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“En roi, hi mi chînte ngei lâia inkhat luo hih mumâkloi rangin indîn roi. Invâna an vântîrtonngei hih invâna ka Pa makunga an om tit ngâi ti nangni ki ril. ");
INSERT INTO sch_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Miriem Nâipasal hi ânmang ngei roka, sanminring rang piela juong ani. ");
INSERT INTO sch_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Mi inkhatin belri razakhat dôn senla, an lâia inkhat inmang rese, kho angin mo a tho rangin nin mindôn? Sômkuoleikuo ngei hah muol panga bu min sâk a ta, male sêng a ta, ânmangpu hah va rok a tih. ");
INSERT INTO sch_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nangni ki ril, ava manin chu sômkuoleikuo ânmangloi ngei nêkin inkhatpu chunga han a râisân uol ok a tih. ");
INSERT INTO sch_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ma angdênin, hi mi chînte ngei lâia inkhat inmang khom hih nin Pa invâna omin nuom mak. ");
INSERT INTO sch_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Na lâibungpa nang doiin sietna a sinin chu, senla a minchâina min mûn la, dâirekin nin ruona riet rang vaiin ril roh. No chong a rangâiin chu na lâibungpa hah ne mene nôk nîng a tih. ");
INSERT INTO sch_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Aniatachu no chong a rangâi nôn chu midang inkhat mini, inik mini tuong sân la, masikin Pathien lekhabu'n a ti anghan, saloinônna chong nâm hah rietpuipungei mi inik mo, inthum mo bâia mindet ani theina rangin. ");
INSERT INTO sch_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Hanchu an chong khom arngâi non chu, neinun murdi koiindang kôm min tung roh. Azoinataka chu koiindang chong khom a rangâi nuom nôn chu ha mi hah chu sonong anghan mini, sum rusuongpu angin mini be roh. ");
INSERT INTO sch_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Masikin nin rêngin nangni ki ril: pilchunga nin khap kai invâna khap nîng a ta, pilchunga nin phal kai invâna phal nîng atih. ");
INSERT INTO sch_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Nangni ki ril uol sa: pilchunga hin mi inikin nin ngênna han nin inruolin chu, invâna ka Pa'n nangni tho pe a tih. ");
INSERT INTO sch_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mi inik mo, inthum mo ki riminga an hong intûpna muna han anni leh ko om ngâi sikin,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Male Peter hah Jisua kôm a honga, “Pumapa ka lâibungpa'n ku chunga sietna sin bang senla, voizet mo ka ngâidam rang? Voi sari mo?” tiin a rekela. ");
INSERT INTO sch_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jisua'n a kôm, “Nimak, voi sari ni loiin, voi sômsari mun sari tena,” tiin a thuona, ");
INSERT INTO sch_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Invân Rêngram chu, voikhat chu rêngpa inkhatin a tîrlâmngei kôm an sum thurchi enmindik ranga masatpu angin ani sikin. ");
INSERT INTO sch_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","A hong enmindik phutin chu mi inkhat talent isângsôm intâng a kôm an hong tuonga. ");
INSERT INTO sch_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ma tîrlâm han a lakâi pêk rang ahundôr a dônloi sikin rêngpa han ama, a lômnu, a nâingei leh a dôn murdi juorin, a lakâi thuon rangin chong a pêka. ");
INSERT INTO sch_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tîrlâm han rêngpa makunga khûkinbilin ânboka. ‘Ka chunga nu phûkminsei viet inla, anrêngin nang thuon let ki tih!’ tiin ânvûia. ");
INSERT INTO sch_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Rêngpa han inrieng a mua, hanchu a lakâi hah a ngâidam phara, a min se zoi. ");
INSERT INTO sch_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Hanchu ha mi hah a jôkpaia, a tîrlâm champui ngei lâia inkhat duli razakhat intâng ava mua. Ava sûrrapa, a ringôn a sôm pea, Na lakâi hah ni thuon ta roh!” a tia. ");
INSERT INTO sch_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","A tîrlâm champui hah ânbôka, “Ku chunga nu phûkminsei viet inla, nang thuon ki tih!” tiin ânvuia. ");
INSERT INTO sch_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Hannirese nuom maka; manêkin a lakâi a thuon mâka chu intâng ina a khum zoi. ");
INSERT INTO sch_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tîrlâm dang ngeiin a sintho lam hah an mûn chu an mulunghoi maka, rêngpa kôm an sea, neinun nâm an va misîr pea. ");
INSERT INTO sch_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Masikin rêngpa han tîrlâm hah a koia, a kôm, Nangma tîrlâm kâmnângloi! nên vûi sikin na lakâi murdi nang ka ngâidam ani. ");
INSERT INTO sch_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Keiman nu chunga moroina ko dôn anghan, nang khomin ni tîrlâm champui chunga moroina no dôn rang kêng ani, a tipea. ");
INSERT INTO sch_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Rêngpa hah atakasi sabaka, male ha tîrlâm hah a lakâi a thuon suo mâka rangin intâng ina a khum zoi. ");
INSERT INTO sch_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jisua'n, “Ma angdênin mitinin nin lâibungngei nin mulungrîl tatak renga nin ngâidam nônchu invâna ka Pa khomin nin chunga ma angdênin thông a tih,” tiin chongkhârnân a ti ani. ");
INSERT INTO sch_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisua'n ha chongngei hah a misîr suole chu Galilee ram renga a suoka, Jordan Tuidung râla Judea rama a sea. ");
INSERT INTO sch_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mipui tamtakin an jûia, male ma muna han a mindam ngeia. ");
INSERT INTO sch_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Pharisee senkhatngei a kôm an honga, ama min ôk rang pûtin, “I-ihsika khomin min a lômnu a mâk hih ei Balamin aphal mo?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jisua'n an kôm, Pathien lekhabu'n, “Aphut renga miriemngei Mizirpu'n Pasal le nupang a sin, a ti hah nin pore ngâiloi mini? ");
INSERT INTO sch_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Mapêna, Pathien'n, ‘Hi sika hin pasalin a nu le a pa mâk a ta, a lômnu leh inruol an ta, male, an ruonin takpum khat hongni an tih,’ a ti ani. ");
INSERT INTO sch_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Masikin mi inik nikhâi mak ngeia, pumkhat kêng an ni zoi. Pathien'n munkhata a mozomsai chu miriemin an sensâi tet rang nimak,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Phariseengei han a kôm, “Nônte ithomo Moses'n pasalin inmâkna lekha miziekin a lômnu a pêkin chu inmâk a phalin amanu hah tîrpaiin aom ngâia?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jisua'n an kôm, “Moses'n nin lômnungei mâk rang nangni a phal pena chu nin mulung ânngara minchu nin intak rai sika ani. Hannirese, sinphuta han chu ma anghin nimak. ");
INSERT INTO sch_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Hanchu, keima nangni ki ril chu, tukhom pasalin a lômnu hah roi danga niloiin, taksôn omloina sika a mâka anin chu a lômnu hah inrê a minchang ani; male mi lômnu mâksai inneipui nôkpu chu amanu hah a inrêpuiin theiloi a chang sa ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","A ruoisingeiin a kôm, “Lômpa le lômnu kongkâra ma anghan anin chu innei loi asa uol,” an tia. ");
INSERT INTO sch_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jisua'n an kôm, “Hi minchuna hih mitin chunga mang rang nimaka, Pathien'n a pêk ngei chunga vai mang nîng atih, tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Pasalin innei theiloina abi chu adadang aom: senkhat, chu neiloi rang piela suok an ni; senkhat chu ha anga ranga miriemin an sin khom an om; senkhat chu invân Rêngram sikin an neiloi ani. Tukhom hi minchuna pom thei kaiin chu pom rese ngei,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mi senkhatin nâipangtengei Jisua kôm an chunga a kut a minngam theina rang le chubai tho pe ngei theina rangin an hong tuonga, aniatachu, ruoisingeiin an lei ngoa. ");
INSERT INTO sch_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jisua'n an kôm, “Nâipangtengei ko kôm min hong ungla khap no roi, invân Rêngram chu hi anga mingei ta ani sikin,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","An chunga a kut a minngama male chu a se zoi. ");
INSERT INTO sch_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Voikhat chu mi inkhat Jisua kôm a honga, “Minchupu, kumtuong ringna ka man theina rangin imo sin sa ki sin rang?” tiin a rekela. ");
INSERT INTO sch_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","“Ithomo asa thurchi mini rekel?” Jisua'n, “Asa chu mi Inkhat vai kêng aom. Ringna han lût nu nuomin chu chongpêkngei hah jôm roh,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ama han, “Kho chongpêkngei ha mo?” tiin a rekela. Jisua'n, “Mi that no roh; inrê no roh; inru no roh; dikloitakin mi nôn no roh; ");
INSERT INTO sch_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","nu nû le na pa mirit roh; nangma nên lungkham angin nu bungmingei lungkham roh,” ti ngei hi tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ruolthartepa han, “Ma chongpêkngei nâm ha chu ko jôm suolet zoi. Imo ki sin rang ala nâng?” a tia. ");
INSERT INTO sch_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jisua'n a kôm, “Asa akiphara om nu nuomin chu senla, no dôn murdi juor inla, ma sum hah inriengngei kôm pêk roh, male chu invâna rochon dôn ni tih; masuole chu hong inla, mi hong jûi roh,” a tipea. ");
INSERT INTO sch_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ruolthartepa'n ha chong hah a rietin chu ngâisiet takin a rot zoi, mi neipa ani sikin. ");
INSERT INTO sch_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Hanchu Jisua'n a ruoisingei kôm, “Adiktakin nangni ki ril: mineingei rangin chu invân Rêngrama lût ântak sabak rang ani. ");
INSERT INTO sch_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nangni ki ril nôk: mineingei Pathien Rêngrama lût nêkin chu ût simphuoi kuora lût bai uol atih,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Hi chong hih, ruoisingeiin an rietin chu, an kamâm tataka, “Nônte, tumo saminringin aom thei rang?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jisua'n anni enlakin an kôm, “Mahih miriem rangin chu nithei maka, aniatachu Pathien rangin chu neinun murdi anithei let,” tiin a thuon ngeia. ");
INSERT INTO sch_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Male Peter a hong chonga. A kôm, “En roh, keinin jâttin mâkin nang kin jûia. Imo kin man rang?” a tia. ");
INSERT INTO sch_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jisua'n an kôm, “Adiktakin nangni ki ril, Ruol Thar hong om ranga Miriem Nâipasal a rêngsukmun roiinpuitaka ânsung tikin chu nangni ku nûkjûi ngâi sômleinik ngei khom rêngsukmunngeia insung nin ta, Israel jât sômleinik ngei chunga roijêk nin tih. ");
INSERT INTO sch_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Hanchu tutu keima sika inngei mo, lâibungngei mo, sarnungei mo, pa mo, nu mo, nâingei mo, loi ngei mo, amâkpu ngei chu abâk razakhatin man an ta, kumtuong ringna khom pêk sa nîng an tih. ");
INSERT INTO sch_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Aniatachu, atûna amasatakngei khom nûkintatak la nîng an ta, male nûkintatak ngei khom amasatak la nîng an tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Invân Rêngram chu mi inkhatin a grapebila mi senkhat inloa sintho rang rokin jîng renga ajôkpai angin ani. ");
INSERT INTO sch_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ama'n a sinthopungei hah asûna duli pêk ngei rangin a jôta, male a grapebila sintho rangin a tîr ngei zoi. ");
INSERT INTO sch_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Jîng dâr kuo ânringin chu bazar muna a se nôka, mahan mi senkhat ite tho loia an inding ava mua, ");
INSERT INTO sch_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","masikin an kôm, ‘Nangni khom se ungla, grapebila va sin ungla, rathaman asadên nangni pêk ki tih,’ a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Masikin an se zoi. Hanchu sûn dâr sômleinik le chonûk dâr thuma khom ma angdênin a thoa. ");
INSERT INTO sch_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kholoi dâr rangnga ânring rangtôn bazar muna ava se nôka, mi senkhat ite sin loia ânding chien ava mu ngei nôka. An kôm, ‘Ithomo ite sin loiin mahin sûn nin min hek?’ tiin a rekel ngeia. ");
INSERT INTO sch_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Anni han a kôm, ‘tutên mi min lo mak ngei,’ tiin an thuona. Asa, hanchu, nangni khom se ungla grapebila sin va tho roi,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Kholoi ahong nîn chu, a pumapa han a sum vongpu kôm han, “Sinthopu ngei hah koi inla, anûktaka hong inlopu ngei renga phutin amasataka hong inlopu ngei dênin an rathaman pêk ngei roh,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Kholoi dâr rangnga sintho koppu ngei ha chu duli chit pêk an nia. ");
INSERT INTO sch_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Masikin motontaka sintho koppu ngei hah an hongin chu atam uol man rangin an mindona; hannirese anni khom duli chit kêng pêk an ni. ");
INSERT INTO sch_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","An sum hah an lâka, a pumapa chunga an chier phut zoi. ");
INSERT INTO sch_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Hi mi nûktaka hôn lo ngei hi chu dâr khat vai an sinna ania, keini chu nisa luma sûntuonin kin sina, hannoma, keini mi ni pêk dôr nanâk anni khom ne pêka!” an tia. ");
INSERT INTO sch_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","A pumapa han, an lâia inkhat kôm han, “ ‘Rangâi ta, mal,’ nang huong mu-ung. Ikhomnirse asûna duli loa sintho ranga no jôt ani. ");
INSERT INTO sch_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Atûn na rathaman lâk inla, ni ina se roh. Nangma nang ke pêk dôr hih hi anûktaka a hon lopu khom hih pêk ku nuom ani. ");
INSERT INTO sch_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ka sum chu ki ti lamtaka mang rangin rachamneina dôn mu-ung mo? Aninônchu ka mannarloi sikin na narsa mini?” a tipea. ");
INSERT INTO sch_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Hanchu Jisua'n, “Masikin anûktak ngei hah amotontak la nîng an ta, amotontak ngei hah anûktak la nîng an tih,” tiin chongkhârnân a tia. ");
INSERT INTO sch_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisua Jerusalem tena se lâihan, ruoisingei sômleinik hah an theiin a tuong ngeia, lampuia an lôn pumin inrûkten an kôm, ");
INSERT INTO sch_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Rangâi ta u, Jerusalema ei se rang ania, mahan Miriem Nâipasal hi Ochaisingei le Balam minchupungei kuta minsûrin om a tih. Thi rangin theiloimintum an ta, ");
INSERT INTO sch_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","hanchu Jentailngei kuta pêk an ta, anni han munui inzanân mang an ta, vîk an ta, khrosa jêmdel an tih; hannirese sûnthum suole chu aringin kaithoiin om a tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Hanchu Jebedee lômnu hah a nâipasal inik ngei leh Jisua kôm an honga, amakunga khûkinbilin, a lungkhamna a zonga. ");
INSERT INTO sch_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jisua'n a kôm, “Imo nu nuom?” tiin amanu hah a rekela. Amanu han, “Hi ka nâipasal inik ngei hih Rêng nini tika na chang tieng inkhat no voitieng inkhat min sung rangin chong mênkhâm pe roh,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jisua'n, nâipasalngei kôm han, “Nin zong hih nin riet loi ani, Tuongna kilât ki nêk rang hih nin nêk thei rang mo?” a tia. “Thei kin tih,” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jisua'n an kôm, “Ki kilât chu nêk tatak nan ta,” hannirese, “tumo ka chang tieng le ko voi tienga ânsung rang chu keiman zen rangin racham dôn mu-ung. Hi munngei hih chu ka Pa'n a mintuo pe ngei ta rang kêng ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ruoisi dang sômngei han ma chong hah an rietin chu, lâibung inik ngei chunga an ningathik zoia. ");
INSERT INTO sch_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Masikin Jisua'n an rêngin a koitûp ngeia, an kôm, “Jentailngei chunga roijêkpua an phunngei chu an chunga an inlaltatak ngâia, an ruoipungei khom an chunga rachamneina an dôn ok ngâi iti nin riet. ");
INSERT INTO sch_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nikhomrese, nin lâia chu ma anghin ani rang nimak. Tukhomin alien a nuomin chu, nin tîrlâm ani bak ngêt rang ani; ");
INSERT INTO sch_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Mapêna, nin lâia tukhomin amotontak ani nuomin chu nin tîrlâm a chang bak ngêt rang ani. ");
INSERT INTO sch_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Miriem Nâipasal luo mana min a sin an tho pe rangin juong maka, mi sin tho pe rang le mi tamtak rattan ranga a ringna pêk rangin kêng a juong ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jisua le a ruoisingei Jericho hah an mâkin chu, mipui tamtakin an jûia. ");
INSERT INTO sch_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Mitcho inik lampui kôla insungin Jisua a hongvun iti an rietin chu, “David Nâipasal! Kin chunga inrieng mi mu roh, Pu!” tiin an in-ieka. ");
INSERT INTO sch_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mipui ngei han dâirek rangin an ngo ngeia. Aniatachu anni han, “David Nâipasal! Kin chunga inrieng mimu roh, Pu!” tiin an iniek minring uola. ");
INSERT INTO sch_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jisua ânngama a koi ngeia, “Imo nangni rangin ni min tho nin nuom?” tiin a rekel ngeia. ");
INSERT INTO sch_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","“Pu, mitvârna mi ni pêk rang hih kin nuom ani!” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jisua'n an chunga inriengmuna a dôna, an mitngei hah a tôn pe ngeia, voikhatrengin an hong mu thei kelena, a nûk an jûi zoi ani. ");
INSERT INTO sch_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jisua le a ruoisingei Jerusalem an hongtung rangtôn Olive Muola Bethphage khuo an hongtunga. Mahan Jisua'n a ruoisingei lâia mi inik a tîr ngeia, ");
INSERT INTO sch_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","an kôm, “Nin motona khuo son se ungla, sakuording, akôla ate leh ânthung mu kelen nin tih. Sût ungla, ko kôm hong kai roi. ");
INSERT INTO sch_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Tukhomin nin kôm imini an ti khomin, ‘Pumapa'n amin nâng kêng,’ tiin ril ngei roi; hanchu nangni hong min chôi kelen a tih,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Dêipu'n a lei ti sai ahongtung dik theina ranga mahah ahong om ani: ");
INSERT INTO sch_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Zion khopuilien hah ril roh, En ta, ne rêng hah no kôm a hong zoi ani! Ama hah rangâiinchîn takin sakuording chunga chuongin, male sakuording ate innoi chunga chuongin,” ti hih. ");
INSERT INTO sch_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Masikin ruoisingei hah an va sea, Jisua'n tho ranga a tipe ngei ang han an va thoa: ");
INSERT INTO sch_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Sakuording leh ate hah an hong kaia, an chunga han an puonngei an dâpa, male Jisua a chuonga. ");
INSERT INTO sch_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mipui tamtakin lampuia an puonngei an dâpa; adangngeiin thingbuo an tuka, lampuia an dâpa. ");
INSERT INTO sch_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Mipui Jisua moton tienga lônngei le a nûk tienga jûingei han, “David Nâipasal minpâkin om rese! Pumapa riminga juongpu chu Pathien'n satvur rese! Pathien minpâkin om rese!” tiin an in-ieka. ");
INSERT INTO sch_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jisua hah Jerusalem a lûtin chu, khopuilien pumpui anrêngin anin tirnata, “Hi mi hih tu mini?” tiin mipui ngeiin an rekela. ");
INSERT INTO sch_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Lokongei han, “Hi mi hih Dêipu Jisua, Galilee ram Nazareth renga ani,” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisua hah Biekina a lûta, Biekin sûnga neinun juorngei le rochôkngei murdi a rujûlpai ngeia. Sumthûlngei dosângngei le pharvali juorngei sukmunngei khom a nammelet pe ngeia, ");
INSERT INTO sch_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","male an kôm, “Pathien lekhabua Pathien'n, ‘Ki in chu chubaithona in tîng an tih,’ tiin ânziek ani. Hannirese nangnin chu inru ngei inthupna khûrin kêng nin sin hi!” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Biekina han mitcho ngei le kholrangei a kôm an honga, a lei mindam ngeia. ");
INSERT INTO sch_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ochaisingei le Balam minchupungeiin sinkamâmruoi a sinngei le nâipangngei Biekina, “David Nâipasal kôm Hosanna, Minpâkin om rese!” tia an in-iek hah an mûn chu an ningathik zoia. ");
INSERT INTO sch_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Masikin Jisua kôm, “Hi mingei an ti hih ni riet mo?” tiin an rekela. Jisua'n, “Adiktakin ki riet, Minpâkna akipphar pêk rangin nâipangngei le nâitesenngei nin minchu zoi, ti hih nin la pore tet ngâiloi mini?” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Hanchu Jisua'n anni ngei hah a mâka, khopuilien renga Bethany'a a sea, mahan jân a riek zoi. ");
INSERT INTO sch_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Anangtûk jînga chu khopuilien tieng a kîr nôkin Jisua a vonchâm zoia. ");
INSERT INTO sch_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Lampui kôla theichang kung ava mua, male ava pana, hannirese abuongei tiloiin chu ite man mâka. Masikin theichang kung kôm han, “Inra nôk tet khâi no roh!” a tipea. Voikhat rengin theichang kung hah ahong thêm zoi. ");
INSERT INTO sch_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ruoisingeiin maha an mua, an kamâmzala, “Kho angin mo theichang kung hih athêmpiel kelen hi?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jisua'n an kôm, “Adiktakin nangni ki ril, iemna nin dôna mulungokchâna nin dôn tet nônchu hi theichang kung chunga ko tho ang hin tho thei nin tih. Mahi vai niloiin hi muol kôm khom hin, ‘Inthon inla, tuikhangliena juon pai roh,’ ti ungla juon pai atih. ");
INSERT INTO sch_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nin iemin chu, chubaithoa nin ngên murdi chu man nin tih,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisua hah Biekina a hong nôka, a minchu lâitakin, Ochaisingei le upangei an honga a kôm, “Tu rachamin mo hi neinunngei hih ni sin? Tumo hi racham nang pêk?” an tia. ");
INSERT INTO sch_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jisua'n an kôm, “Chongrekel inkhat kei khomin nangni lei rekel rong, ni nin thuon theiin chu, tu rachamin mo hi neinunngei hih ki sin nangni ril ki tih. ");
INSERT INTO sch_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","John Baptisma hah kho renga rachamneina mo: Pathien renga mo, miriem renga mo?” a tia. Anni le anni an inkhal zoia, “Imo ei ti rang hi? ‘Pathien renga tiin ei thuon lakin,’ ama'n ei kôm, ‘Ithomo John hah nin iem loi?’ mi tîng a ta. ");
INSERT INTO sch_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","‘Miriem renga ei ti lakin,’ mipui ngeiin imo minlo rang ei chi, mipui ngeiin John hah Dêipua an be sikin,” an tia. ");
INSERT INTO sch_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Masikin Jisua kôm, “Riet mak me.” tiin an thuona. Jisua'n an kôm, “Kei khomin tu rachama mo hi neinunngei hih ki sin, nangni ril uol noning,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Atûn, Imo nin mindon? Tienlâia han mi inkhatin nâipasal inik a dôna. A nâi ulienpu kôm ava sea, a kôm, ‘Ka Nâipasal, avien chu grapebila senla, sin va tho roh,’ a tia. ");
INSERT INTO sch_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘Ama han nuom mu-ung,’ tiin a thuona, aninâka chomolte suole chu a mindon a thûla male a se zoia. ");
INSERT INTO sch_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Male inkhat kôm han khom a sea, ma angdênin ava ti nôka. Ama han, ‘O, Pa,’ sêng ki tih, tiin a thuona. Hannirese se maka. ");
INSERT INTO sch_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ha mi inik ngei han tu ha mo an pa nuomlam a sin uol?” a tia. “Ulienpu han,” tiin an thuona. Masikin Jisua'n an kôm, “Nangni ki ril: sum rusuongpungei le notizuorngei hin Pathien Rêngrama lût nangni an khêl rang ani hi. ");
INSERT INTO sch_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Baptispu John'n lampui dik nin jûi rang nangni a juong min mua, ama lei iem mak cheia; sum rusuongpungei le notizuorngeiin chu an lei iem ani. Nangni chu nin mu suonûk khomin nin mulungbôkngei thûlin ama iem mak chei.” ");
INSERT INTO sch_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jisua'n an kôm nanâk, chongmintêk dang rangâi nôk roi a tia. “Voikhat chu tu mini ram pumapa a oma, hah mi han grapebil a thoa, bêr a minkula, grape epna rang khur a choia, a ngâkna rang in insâng a sina. Hanchu grapebil hah inlo mingei ngâk rang ngei kuta bângin, ram danga khuolchai a se zoia. ");
INSERT INTO sch_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Grape mara pot zora ahong tungin chu, ânlo mingei kôm han a chang rangtum va lâk rangin a suokngei a tîra. ");
INSERT INTO sch_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ânlo mingei han a suokngei hah an lei sûra, inkhat an jêma, inkhat an thata, inkhat lung leh an dênga. ");
INSERT INTO sch_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Atharin suok dangngei motona nêka tam uolin a tîr nôka, motona ngei angdênin an lei tho nôk rêka. ");
INSERT INTO sch_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Anûktaka chu, ‘Ka nâipasal hi chu lei jâ ngêt an tih,’ tiin a nâipasal hah an kôm a tîra. ");
INSERT INTO sch_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Hannirese, ânlo mingei han a nâipasal hah an lei mûn chu, ‘Hi mi hih a pumapa nâipasal ani. Hong roi lei that rei u, male a rochon ei man rang ani!’ an tia. ");
INSERT INTO sch_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Masikin an sûra, grapebil pêntieng an vôrpaia, ama hah an that zoi.” ");
INSERT INTO sch_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Atûn, grapebil pumapa a hong tikin, ha ânlo mingei hah imo hong lo ta nih?” tiin Jisua'n a rekela. ");
INSERT INTO sch_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Anni han a kôm, “Ha mi saloi ngei hah that ngei ngêt a ta, grapebil hah ânlo mingei adang, amara pot zora diktaka changrangtum a pêk ngâi rangpu kôm pêng a tih,” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jisua'n an kôm, Pathien Lekhabu'n, “In sinpu ngeiin lung mangmunboi anga an hengpai hah, akila lung kâmomtak achang zoi. Ma hah Pumapa tho ania; ei mitmua hin kamâmom ani! a ti hih nin pore ngâiloi mo?” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jisua'n a bôksa nôka, “Masikin nangni ki ril, Pathien Rêngram hih nin kôm renga lâkpai nîng ata, amara musuo rang mingei kôm pêk nîng atih. ");
INSERT INTO sch_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Tutu hi lung chunga ânpal chu ahârhârin om an ta, hi lungin adel vâng chu innôichit an tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ochaisingei le Phariseengeiin Jisua chongmintêk misîr hah an rietin chu, an chungroi a misîr ani ti an riet zoia. ");
INSERT INTO sch_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Masikin ama sûr rang an pût zoi. Aniatachu anni ngei han mipui ngei an chia, mipui ngeiin Jisua hah dêipu'n an be sikin. ");
INSERT INTO sch_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisua'n mipui ngei a rokôka, chongmintêk a mang nôka. ");
INSERT INTO sch_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Invân Rêngram chu rêngpa inkhatin a nâipasal ranga inneina ruolhoi tho leh mintêk ani. ");
INSERT INTO sch_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Bukhalâi ot rangin a mîsiel ngei koi rangin a tîrlâmngei a tîra, hannirese hong nuom mak ngeia. ");
INSERT INTO sch_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Masikin tîrlâm dangngei a tîr nôka, a mi sielngei kôm hi anghin ti rangin chong a be ngeia: ‘Atûn hin bukhalâi ot rangin ki sinsiem suozoi; ke sechalngei le ke serâttuoi vai minthâi ngei ka thata, neinunngei murdi sinsiem suo ani zoi. Inneina bukhalâi ot rangin hong ta roi!’ ti rangin. ");
INSERT INTO sch_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Aniatachu siela omngei han itên lei be mak ngeia, male an sadâi chita an sina: inkhat a loia a sea, inkhat chu a dôra a sea. ");
INSERT INTO sch_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Midang ngeiin tîrlâmngei hah an sûrrapa an jêm ngeia, an that ngei zoi. ");
INSERT INTO sch_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Rêngpa hah a taksi sabaka; masikin a râlmingei a tîra, ha mithatpungei hah a min thatngeia, male an khopuilien khom a min hâl pe ngei zoia. ");
INSERT INTO sch_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Hanchu a tîrlâmngei a koia, an kôm, Inneina bukhalâi chu minsûk suo ani zoia, aniatachu ki mi sielngei hah a nêk ruo nimak ngei. ");
INSERT INTO sch_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Atûn chu lamliena se ungla, mi nin mu murdi bukhalâi ot rangin hong koi roi, a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Masikin tîrlâmngei hah lamlienngeia an sea, mi an mu murdi, misa le misie; an hong koibûma, inneina in hah mipuiin an sip zoia. ");
INSERT INTO sch_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Rêngpa hah khuolmingei en rangin ava lûta, inneina puon insil loi mi inkhat ava mua. ");
INSERT INTO sch_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Rêngpa han a kôm, ‘Mala, inneina puon insil loiin khoangin mo asûnga no hong lût?’ tiin a rekela. Hannirese ha mi han ite ti maka. ");
INSERT INTO sch_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Male rêngpa han a tîrlâmngei kôm, ‘A kut le ke khit ungla, pêntieng ajîngna vôrpai roi. Mahan chap a ta a hâ riel a tih,’” a tia. ");
INSERT INTO sch_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Hanchu Jisua'n, “Mi siela om chu tamtak an nia, aniatachu, thanga om chu atômte kêng an ni,” tiin chongkhârnân a tia. ");
INSERT INTO sch_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Phariseengei hah an jôkpaia male Jisua chongrekelin min ôk rang chang an mintuo zoi. ");
INSERT INTO sch_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Hanchu an ruoisi senkhatngei le Herod pâla mi senkhatngei a kôm an tîra, ha mingei han, “Minchupu, chongtak ni misîr ngâi ti kin riet. Tute lunghâng tho uol ngâi mak chea, tute mindona chungroia khom kângdoina dôn loiin miriemngei ta rangin Pathien lungdo chongtak hah ni minchu ngâia. ");
INSERT INTO sch_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Hanchu, ni ril ta, imo ni mindon? Roman Rêng Ceasar kôma chôiruol pêk hih ei Balamin ânkal mo, ânkal loi mo?” an tia. ");
INSERT INTO sch_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nikhomrese, Jisua'n asaloi an mintuo hah a riet chiena, an kôm, “Nangni Asarotholngei! ithomo ni min ôk rang nin pût hi? ");
INSERT INTO sch_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Chôiruol chôi ranga sumthîr hah ni min en ta u!” a tia. Sumthîr hah a kôm an hong chôia, ");
INSERT INTO sch_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","male a rekel ngeia, “Tu mâi rimil le tu riming ngei mo an ni hi?” a tia. ");
INSERT INTO sch_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Anni han “Ceasar” tiin an thuona. Masikin Jisua'n an kôm, “Asa, hanchu, Ceasar ta chu Ceasar kôm pêk ungla, Pathien ta chu Pathien kôm pêk roi,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Mahi an rietin chu an kamâm tataka; ama an mâka an rotpat zoi ani. ");
INSERT INTO sch_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mani sûn nanâk han, Sadducee senkhatngei Jisua kôm an honga mingei hih thina renga inthoi nôk no ni ngei an tia. ");
INSERT INTO sch_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Anni han, “Minchupu, ‘Moses'n mi nâi neiloiin a lômnu thisan senla, a nâipa'n ha meithâi hah luo nôk ngêtin a upa ta rangin nâi a nei pe rang ani,’ a tia. ");
INSERT INTO sch_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Atûn hin, kin lâia lâibungrêng sari an oma; ulientakin in a neia, nâi neiloiin a thia, masikin a lômnu hah a nâipa kôm a mâka. ");
INSERT INTO sch_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","A nâipa iniknapu chunga khom ma anghan a hong om nôka, a inthumnapu chunga khom, azoinataka sarinapu dênin an luo paka. ");
INSERT INTO sch_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Anûktaka chu nupangnu khom a thi zoia. ");
INSERT INTO sch_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Atûn, mithi ngei inthoi nôk tika han tu lômnu tak mo ani rang ani zoi? An rêngin laka an luo paka,” an tia. ");
INSERT INTO sch_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jisua'n an kôm, “Idôra dikloi ngei mo nin ni zoi! Pathien Lekhabu nônchu Pathien sinthotheina nin riet loi sika kêng ani. ");
INSERT INTO sch_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Mithi ngei aringin an inthoinôk tika chu invâna vântîrtonngei angin om an ti zoi, innei khâi noni ngei. ");
INSERT INTO sch_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Atûn ithingei aringa an inthoinôkna roi: Pathien'n nangni a misîr pe hah nin la pore tet ngâiloi mini?” a tia ");
INSERT INTO sch_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Pathien'n, “Keima Abraham Pathien, Isaac Pathien, Jacob Pathien ki ni,” a tia. “Ama chu iringngei Pathien kêng ani, ithingei Pathien nimak,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mipui ngei han mahi an rietin chu, a minchûna hah an kamâm tatak zoi ani. ");
INSERT INTO sch_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jisua'n Sadduceengei hah a makhal mindokngei tih Phariseengeiin an rietin chu a pâlin an honga, ");
INSERT INTO sch_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","an lâia Balam minchupu inkhatin chongrekelin min ôk rang a bôka. ");
INSERT INTO sch_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Minchupu, Balama hin kho chongpêk tak himo a roiinpuitak?” tiin a rekela. ");
INSERT INTO sch_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jisua'n a kôm, “ ‘Pumapa na Pathien chu nu mulungrîl murdi'n, na ratha murdi'n, nu mulungbôk murdi'n lungkham mu roh iti hi,’ ani tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mahih chongpêk roiinpuitak le a kâmomtak ani. ");
INSERT INTO sch_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Chongpêk inikna kâmom nôk ân angpui chu: ‘Nangma nên lungkham anghan nu bungmingei lungkham mu roh’ iti hih ani. ");
INSERT INTO sch_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moses Balam pumpui le dêipungei minchûna ngei murdi khom hi chongpêk inik chunga hin ânngam let ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Pharisee senkhatngei munkhatin an intûp laiin, Jisua'n an kôm, ");
INSERT INTO sch_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Messiah chungroi hih imo nin mindon? Tu richisuonpâr mo ani?” tiin a rekel ngeia. “Ama chu David jâisuona mi ani,” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jisua'n an kôm, “Nônte, ithomo Ratha han David hah ‘Pumapa’ tiin a min koi? David'n, ");
INSERT INTO sch_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Pumapa han ka Pumapa kôm a tia: Ka chang tieng insung tit roh Na râlngei ne kepha nuoia ka dar suo mâka chu,’ a ti ani. ");
INSERT INTO sch_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","David'n, ‘Pumapa’ tiin a koiin te, i angin mo Messiah hah David richisuonpâr ani thei rang?” a tia. ");
INSERT INTO sch_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Tutên Jisua hah thuon thei mak ngeia, male mani sûn renga chu tutên ite chongrekel rang ngam khâi mak ngei. ");
INSERT INTO sch_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Hanchu, Jisua'n mipuingei le a ruoisingei kôm chong a rila. ");
INSERT INTO sch_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Balam minchupungei le Phariseengei hih Moses Balamngei rilminthârpu ngei ni ranga phal an ni. ");
INSERT INTO sch_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Masikin itho ranga nangni an be murdi chu nin jômin nin jûi rang ani; Hannirese, an omchan chu jûi no roi, an misîr ngei hih an mang ngâi loi sikin. ");
INSERT INTO sch_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Puok arik le apêl intak takngei an siema, mingei chunga an bâng ngâia, aniatachu, ha mingei sanna rangin an kutpârngei luo mang nuom ngâi mak ngei. ");
INSERT INTO sch_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","An sintho murdi khom miriem mu rangin kêng an sin ngâi. An machalngei le an bânngei khitna hih Pathien chong miziek ngei hih en ta u, an inrol bâk na! An kâncholiinchuol minvona ngei khom hih en ta u, asei bâk na! ");
INSERT INTO sch_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ruolhoi thona muna munhoi tatakna ngei le synagog ngeia sukmun asa an ngên ngâia; ");
INSERT INTO sch_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Bazar mun ngeia min chubai an mûk le ‘Minchupu’ tia an koingei an minlut ngâia. ");
INSERT INTO sch_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nangni chu ‘Minchupu’ tiin koi ni tet no tunui, urêng korong nin nia, minchupu inkhat mang nin dôn sikin. ");
INSERT INTO sch_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Pilchung hin tute O, Pa, ti no roi, Pa inkhat mamang invâna nin dôn sikin. ");
INSERT INTO sch_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","‘Ruoipu’ ti khomin koi ni no tunui. Messiah mang hih nin ruoipu ani sikin. ");
INSERT INTO sch_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nin lâia a roiinpuitak chu nin tîrlâm ani rang ani. ");
INSERT INTO sch_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tutu a omlien kai chu chîn an ta, a omchîn kai chu minlutin om an tih.” ");
INSERT INTO sch_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Nangni Balam minchupungei le Pharisee asarotholngei! Nin chung arik! Invân Rêngram inkhâr hah mingei nin khâr pea; nangni laka lût uol mak cheia mi a lût rang ngei khom nin khap ngâi. ");
INSERT INTO sch_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Nangni Balam minchupungei le Pharisee asarotholngei! Nin chung arik! Meithâingei sum nin sâk pea, mi huongnân asôt zazan chubai nin tho ngâi; masikin nin dûk tuong rik uol ok atih! ");
INSERT INTO sch_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Nangni Balam minchupungei le Pharisee asarotholngei! Nin chung arik! Mi inkhat insîrna rangin tuikhanglien le ram pumpui nin sir ngâia; a hong inletin chu ha mi hah nangni nêka bâknika dûkmuna se rangin nin tho ngâi! ");
INSERT INTO sch_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Nangni ruoipu mitcho, Tukhom Biekin dêna khomâkinsâm chu ite nâng ngâi maka; aniatachu tukhom Biekina rângkachak dêna khomakinsâm chu anângna aom.” Ti ngâi ngei nin chung arik. ");
INSERT INTO sch_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mitcho inmôlngei! Imo akâm aom uol, rângkachak mo aninônchu rângkachak inthieng Biekin hah mo? ");
INSERT INTO sch_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mapêna Tukhom mâichâm dêna khomakinsâm chu ite anângna omaka, ania mâichâm chunga neinunpêk dêna khomakinsâm chu anângna aom, nin ti sa ngâi. ");
INSERT INTO sch_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Idôra mitcho nin ni! Imo akâmaom uol, neinunpêk minthieng ngâipu mâichâm ha mo, mo neinunpêk ha mo? ");
INSERT INTO sch_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Masikin tukhom mâichâm le a chunga neinunpêk aom murdi'n ânsâmdelsa ani. ");
INSERT INTO sch_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Tukhom Biekin dêna khomâkinsâm kaiin chu Biekin leh a sûnga Pathien om hah dênin ân sâm ania; ");
INSERT INTO sch_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","male tukhom invân dêna khomâkinsâm chu Pathien sukmun le a chunga insungpu dênin ân sâm ani. ");
INSERT INTO sch_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Nangni Balam minchupungei le Pharisee asarotholngei! Nin chung arik! Sâkruo avâng ngâi chimungei, lêngmesêr le sâkbakhêr tenah khom sômakhat nin pêk ngâia, hannirese, Balama akâm aom uol, dikna ngei le mulungjûrpuina le iemomna ngei jôm rangin chu lunghâng tho ngâi mak chei. Hi ngei hih nin jôm rang ani, adangngei khom mathân uol loiin. ");
INSERT INTO sch_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ruoipu mitcho ngei! Nin tui nêkna thoihir chu nin rithît minsâia, ania saringsei chu nin movol ngâi ani. ");
INSERT INTO sch_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Nangni Balam minchupungei le Pharisee asarotholngei! Nin chung arik! Nin kilât le nin mâirâng pêntieng nin minsâia, a sûngtieng chu, inrûksâkna le indînloi nân ai sip ani. ");
INSERT INTO sch_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Pharisee mitcho ngei! Kilât sûngtieng hah minsâi bak ungla, hanchu apêntieng khom sâi sâng atih! ");
INSERT INTO sch_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Nangni Balam minchupungei le Pharisee asarotholngei! Thân lung, nôtminvâra apêntieng chu en ahoi zata, hannirese, asûngtieng chu ru le ruok athûa sip angha nin ni. ");
INSERT INTO sch_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ma anghan mitin mitmua pêntieng chu asa anghan nin inlanga, hannirese, nin sûngtieng chu asarotholna le sietnangeia sipmat nin ni. ");
INSERT INTO sch_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Nangni Balam minchupungei le Pharisee asarotholngei! Nin chung arik! Dêipungei thân nin sinsiama, midikngei riettit nân lungngei nin minvo ngâia; ");
INSERT INTO sch_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","male ei richibulngei om lâia han ei lei omsai nikhom senla, dêipungei thisen an musuok han chu inchel no ih, nin ti ngâi. ");
INSERT INTO sch_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Masikin Dêipungei lei that ngei richia mi nin ni ti nin minlang chak ani. ");
INSERT INTO sch_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Se ungla, nin richibulngeiin an lei phut hah minzoi roi. ");
INSERT INTO sch_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nangni murûlngei le murûl nâingei! Dûkmuna se ranga jêkmasatna renga inmo jôk thei rangin nin insabei? ");
INSERT INTO sch_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Masikin nangni ki ril, nin kôm dêipungei, mivârngei, minchupungei juongtîr ka ta, an lâia senkhat chu that nin ta, senkhat chu jêmdel nin ta, senkhat chu synagog ngeia jêm nin ta, khopui ankhat renga khopui ankhata rujûlpai nin tih. ");
INSERT INTO sch_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Masikin midiktak Abel thisen renga Biekin le mâichâm kâra Barakia nâipasal, theiloinaboi, Zakaria nin that thisen tena han, pilchunga midikngei thatna sika dûktuongna chu nin chunga la chul atih. ");
INSERT INTO sch_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Adiktakin nangni ki ril: ha mingei thatna sika dûktuongna ngei murdi chu atûna mingei chunga chul let atih. ");
INSERT INTO sch_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalem, Jerusalem! Dêipungei thata, Pathien'n no kôma thangthei a hongtîr ngei lung leh a dêng thatpu! Ârpuinu'n ate ngei a mantha nuoia ai opbûm ngâi anghan ni mingei anrêngin voizet mo ka bân nuoia opbûm rang ko bôka, hankhoma nuom mak che! ");
INSERT INTO sch_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Masikin nin Biekin hah mâkrakin, a korongin om atih. ");
INSERT INTO sch_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nangni ki ril, ‘Pumapa riminga hong chu Pathien'n satvur rese,’ nin ti mâka chu atûn renga ni mu nôk khâi no tunui a tia.” ");
INSERT INTO sch_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Hanchu, Jisua hah a jôka, Biekin renga a se lâiin Biekin min en rangin a ruoisingei a kôm an honga. ");
INSERT INTO sch_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ama han an kôm, “En roi, Adiktakin nangni ki ril, hitaka lung inkhat luo khom hih amuna om no nih; anrêngin paiin om riei an tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Hanchu, Jisua Oliv tângah ânsung lâiin, a ruoisingeiin a theiin an hong intongpuia. “Mi ril ta, hi ngei hih itika mo ai tung rang,” male “Nu juong nôkna rang le rammuol mongna rang minsinna hah imo ai ni rang,” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jisua'n an kôm han, “Tutên nangni an huong loina rangin, indîn roi. ");
INSERT INTO sch_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Mi tamtakin, ‘Messiah hah ki ni!’ tiin keima riming songin hong an ta, mi tamtak lei huong an tih. ");
INSERT INTO sch_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nin kôla indoina roi riet nin ta, ala takna indoina roi inthang la riet nin tih, nikhomrese, nin jâmminzal no roi. Ha neinunngei hah chu ahongtung ngêt rang ani, nikhomrese amongna chu lani no nih. ");
INSERT INTO sch_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nam le nam indoi an ta, ram le ram indoi an tih. Muntina mâitâm chul ata, ningnu innîk atih. ");
INSERT INTO sch_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ha ngei hah nâiha aphut chak ang hah ani. ");
INSERT INTO sch_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Hanchu, dûk nangni min tuong rang le nangni that rangin nangni la sûr an tih. Keima sikin nam tinin nangni la mumâk an tih. ");
INSERT INTO sch_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ma tika chu mi tamtakin an taksônna la mâng an ta, lân sûr inlôm an ta, lân mumâk inlôm an tih. ");
INSERT INTO sch_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Male, dêipu dikloi tamtak hong suok an ta, mi tamtak la huong an tih. ");
INSERT INTO sch_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Hanchu, sietna ala pung rang sikin mi tamtak lungkhamna la dâi atih. ");
INSERT INTO sch_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nikhomrese, tutu among dêna diera tuong chu sanminringin om an tih. ");
INSERT INTO sch_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Male, hi ‘Rêngram Thurchi Sa’ hih namtin rietna rangin rammuol pumpuia misîrin la om a ta; male, amongna hong tung atih.” ");
INSERT INTO sch_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Hanchu, ‘Intakna Ichiom Tak,’ dêipu Daniel ramanga lei misîr hah mûng nin ta, mun inthienga han inding a tih.” (Apore murdi'n aomtie riet rese ngei!) ");
INSERT INTO sch_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Male Judea rama om ngei hah tânga rot ngêt rese ngei. ");
INSERT INTO sch_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mi a inchunga om khom insûnga a neinun kaisuo rangin chum no rese. ");
INSERT INTO sch_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Mi loia om khom a puon lâk rangin kîr no rese. ");
INSERT INTO sch_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ha ni han chu nâivongngei le nu nâite pomlâingei chung chu ântak bâk rang na! ");
INSERT INTO sch_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nin rot rang zora hah phalbia mo, sabbathni'n mo ani loina rangin Pathien kôm chubaitho roi. ");
INSERT INTO sch_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ha zora dûktongna ichiruoi inthang om rang ha chu rammuol insieng renga atûn tena la om ngâi maka, om nôk tet khâi no nih. ");
INSERT INTO sch_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nikhomsenla, Pathien'n ha sûn ngei hah a minbong zoi; ni no senla vang chu tute ringsuok thei noni ngei. A mi zenngei sikin Pathien'n ha sûn ngei hah minbong a tih. ");
INSERT INTO sch_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Male, tukhomin nin kôm, ‘En ta, Messiah chu hin a om!’ aninônchu ‘Soson a om!’ an ti khomin iem no roi. ");
INSERT INTO sch_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Messiah rothol ngei le dêipu dikloi ngei an la suok rang ani; ha ngei han thei vang senla ngei chu Pathien zen mingei luo an huong theina rangin minsinna sininkhêl le sin kamâmruoi thông an tih. ");
INSERT INTO sch_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Rangâi roi! Azora ahongtung mân nangni ki lei ril ani. ");
INSERT INTO sch_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Aninônchu, nin kôm, ‘En ta, ramchâra aom!’ an ti khomin mahan se no roi; aninônchu hin ânthup an ti khomin iem no roi. ");
INSERT INTO sch_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Miriem Nâipasal juong nôk rang chu kôlinleka dapdaptingei sak tieng renga thang tieng tenah ahonginlek anga han ani rang sikin. ");
INSERT INTO sch_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Kho munah khom saruok omna murdia sêlkuru khom intûp an tih.” ");
INSERT INTO sch_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ha intakna nikhuongei zoiin chu nisa jîng a ta, thâ vâr khâi nonih, invân renga ârsi ngei tâk a ta, invân sinthotheina ngei hah inphêthet'n om an tih. ");
INSERT INTO sch_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Masuole chu Miriem Nâipasal minsinna hah invâna inlang ata; pilchunga mi murdi'n Miriem Nâipasal invâna sûm chunga sinthotheina le inlal taka juong an mu tikin chu chap an tih. ");
INSERT INTO sch_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Bekul miring inring tak tum nîng ata, hanchu, a vântîrtonngei hah rammuol rikil minlia tîr a ta, kôlkung renga kangkhat tienga kôlkung dênin a mi zenngei mintûp atih.” ");
INSERT INTO sch_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ha chongmintêk hah theichang kunga inchu roi. Amachang ahong ringa, ahong innoia, abuo ahong incherin chu kholum ahong nâi zoi tiin nin riet ngâi. ");
INSERT INTO sch_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ha angdênin, ma neinunngei murdi hah nin mu'n chu, a zora ahong nâi zoi, ânphut rang ani zoi ti riet roi. ");
INSERT INTO sch_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Atûnlâia mingei hih an thi riei mân, hi ngei nâm hih tung let atih ti riettit roi. ");
INSERT INTO sch_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Pilchung le invân boi a ta, ko chong chu boi no nih.” ");
INSERT INTO sch_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Hannirese, ha nikhuo le a zora ha chu Pa telloiin chu tutên riet mak ngei; Invâna vântîrtonngei khomin, Nâipasal khomin. ");
INSERT INTO sch_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Miriem Nâipasal juong nôkna chu Noah damlâi angdên han nîng atih. ");
INSERT INTO sch_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tuilien mân, sûn ngeiah han chu Noah rukuonga a lût ni dênin an sâka an nêka, lômnu, lômpa an innei ngâia. ");
INSERT INTO sch_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tui ahongliena, an rêngin an inmang riei mâka chu imo ahongtung ite riet mak ngei. Miriem Nâipasal juong nôkna chu ha ang takah han nîng atih. ");
INSERT INTO sch_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ha tikin chu mi inik loia sin an ta inkhat tuongin om a ta, inkhat mâkin om a tih. ");
INSERT INTO sch_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nupang inik sasum kunga sângsukin om an ta, inkhat mâkin om a ta, Inkhat tuongin om a tih. ");
INSERT INTO sch_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Masikin inning chien roi, itiknimo nin Pumapa a juong rang riet mak chei. ");
INSERT INTO sch_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","In pumapa'n inru hong rang zora hah riet senla chu, lei meng a ta, a neinunngei min muruk no nih, ti hih riet roi. ");
INSERT INTO sch_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Masikin nangni khom intûng chienin om roi, nin tûng loi zora takin Miriem Nâipasal a juong rang sikin.” ");
INSERT INTO sch_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Tîrlâm taksônom avâr tak, a pun a insûng cherêla, tîrlâm dangngei zora tina an sâk sem pe ranga ulien a minchang chu tumo nini? ");
INSERT INTO sch_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","A pu'n a honga, ha anga sin thoa tîrlâm a hong mu ha chu a râisân ani, ");
INSERT INTO sch_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Adiktakin nangni ki ril, a pu han a neinun murdi chunga ajêkpu minchang a tih. ");
INSERT INTO sch_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Hannirese, tîrlâm saloi anîn chu, a mulungin ‘Ku pu chu hong vak no nih’ tîng a ta, ");
INSERT INTO sch_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","a tîrlâm champuingei lei jêm a ta, ju inrûingei kâra lei nêkin lei sâk a tih. ");
INSERT INTO sch_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Male, ha tîrlâm hah a tûng loi lâitak le a riet loi zora takin a pu hong suok pe atih. ");
INSERT INTO sch_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","A pu han ât nôinek a ta, asarotholngei chang anga han minchang a tih, Mahan chap a ta, a hâ riel a tih.” ");
INSERT INTO sch_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Ma tikin chu, Invân Rêngram hah dôngmate sôm ngei an châtingei chôia, moipumapa don ranga se ngei leh mintêk nîng atih zoi. ");
INSERT INTO sch_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","An lâia mi rangnga hah an inmôla, mi rangnga hah an vâr ani. ");
INSERT INTO sch_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ânmôlngei han, an châtingei an chôia, a tui chôi sa mak ngeia, ");
INSERT INTO sch_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","avârngei han chu an châtingei an chôia, a ûma han a tui khom an chôi sa. ");
INSERT INTO sch_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Moipumapa hah a juong innu sikin an in alênmua, an lei inphara. ");
INSERT INTO sch_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Jânchimrip takah chu ‘Moipumapa a juong zoi! Adon rangin hong suok ta roi’ tia iniek rahang a juong om zoia; ");
INSERT INTO sch_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","hanchu, dôngmate sôm ngei hah an inthoia, an châtingei an minsûka. ");
INSERT INTO sch_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Male, ânmôlngei han avârngei kôm han, ‘Nin châtitui hah mi pêk sa roi ba! kin châti athi rang kêng’ an tia. ");
INSERT INTO sch_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Avâr rangnga ngei han, ‘Nangni pêk thei noning ung. Keini leh nangni rangin chu hun nonih. Dôrah se ungla, va rochok roi,’ tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Hanchu, dôngmate inmôlngei hah châtitui rochôk rangin an sea, hanchu an se kârin moipumapa hah a juong zoia. Dôngmate rangnga ânthok ngei chu ama leh inbiek ruolhoi tho rangin an lûta, in an khâr zoi. ");
INSERT INTO sch_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Nûkah chu dôngmate dangngei khom an hongtung zoia, O pu, o pu, mi min lût roh! Tiin an in-ieka. ");
INSERT INTO sch_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Moipumapa han, Nangni minlût tet no ning! Nangni riet ngâi mu-ung tiin a thuona.” ");
INSERT INTO sch_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Male Jisua'n chongkhârnân, “Intûng chienin om roi, a nikhuo le azora hah nin riet loi sikin,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ma tikin chu Invân Rêngram hah mi inkhat khuol a chai rangtoa, a tîrlâmngei a koia, a rochonngei enkol leh mintêk nîng atih zoi. ");
INSERT INTO sch_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","An thei lam ang chitin a pêka, inkhat kôm sum isâng rangnga a pêka, inkhat isângnik a pêka, inkhat kôm isâng khat a pêka. Hanchu, khuolchai rangin ânphet zoi. ");
INSERT INTO sch_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tîrlâm isâng rangnga changpu ha chu a se kelena, ava minpunga, isâng rangnga dang ava suo nôka. ");
INSERT INTO sch_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ha anga han tîrlâm isâng nik a changpu ha chu a sea, adang isâng nik a muphung nôka, ");
INSERT INTO sch_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","hannirese, tîrlâm isângkhat a changpu ha chu a sea, khur a choia, a pu sum hah athupa. ");
INSERT INTO sch_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Asôtzan suoleh chu tîrlâmngei an pu hah a hongkîr nôka, an kôm a sum thurchi a minthâr zoia. ");
INSERT INTO sch_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tîrlâm, isâng rangnga changpu hah a honga, isâng rangnga dang a hong pêka, o pu isâng rangnga mi ni pêk hah en ta! hi isâng rangnga adang ke lei man nôk hi a tia. ");
INSERT INTO sch_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","A pu han a kôm, No tho minsa, nangma tîrlâm asa le iemom, atômte chunga taksônomin no om sikin, atampa chunga khom a enkolpu'n nang minchang ki tih. Hong inla, ka râisânna hong chang sa roh! a tia. ");
INSERT INTO sch_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Hanchu tîrlâm isâng nik changpu hah a honga, O pu, isâng nik mi ni pêk hah en ta! Hi isâng nik dang ke lei man nôk hi! a tia. ");
INSERT INTO sch_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","A pu han a kôm, No tho minsa, nangma, tîrlâm asa le taksônom! Atômte chunga taksônom ni ni sikin, atampa chunga khom a enkolpu'n nang min om ki tih. Hong inla, ka râisânna hong chang sa roh!” a tia. ");
INSERT INTO sch_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Hanchu tîrlâm isâng khat changpu hah a honga, O pu, mi inngartak ni ni ti ki riet; nu tu loina khoma na ât ngâia, sachi ne rethe loina munna khom bu ni mintûp ngâia. ");
INSERT INTO sch_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ki chia, masikin ke sea, pil rilah nu sum hah ka va thup ani. En ta hi nata nanâk hah, a tia. ");
INSERT INTO sch_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","A pu han a kôm han, “Nangma tîrlâm puoloi le thaboipa! Ka tu loina khoma ka âtta, sachi kerthe loina khoma bu ki mintûp ngâi ti ni riet na? ");
INSERT INTO sch_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ha anghan aninte, ithomo ku sum hah sumsiena inah ne lei sie loi, nino senla chu, ko hong nôka hin ku sum hih apung leh ka man rang kêng ai ni. ");
INSERT INTO sch_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Atûn chu sum hih a kôm renga lâk ungla, isâng sôm dônpu kôm pêk roi. ");
INSERT INTO sch_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tutu a dôn chu pêk mintam uol nîng a ta, dôn ok a tih; tutu a dôn loi kai chu ai dôn chêtte khom lâk pe rip nîng a tih. ");
INSERT INTO sch_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Hi tîrlâm mangmunboi hih pêntieng ajîngna vôrpai roi; mahan chap a ta, a hâ riel a tih,” tiin a rila. ");
INSERT INTO sch_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Miriem Nâipasal hih vântîrtonngei murdi leh inlal taka a juong tikin chu Rêngsukmuna insung a ta, ");
INSERT INTO sch_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","male a makunga namtina mingei intûp an tih. Hanchu, belrihôlpu'n kêl le belri a sensâi anghan pâl nikin sensâi a tih. ");
INSERT INTO sch_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Midikngei hah a changtieng dar a ta, adangngei hah a voitieng dar a tih. ");
INSERT INTO sch_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Hanchu Rêng han a chang tienga mingei kôma han, Hong roi ka pan sat ai vur ngei! Hong ungla, rammuol inzir renga nin ta ranga rêngram minsûk hih hong luo ta roi. ");
INSERT INTO sch_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ko von achâmin sâk mi nin pêka, ku tuiânrâlin nêk rang mi nin pêka; khuolmi ki nîn nin ina mi nin mintunga. ");
INSERT INTO sch_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Dierboiin ko omin puon mi nin min sila; ka damloi zorân mi nin donsûia, intâng ina ko om khomin mi nin pan ngâi,” la tîng a tih. ");
INSERT INTO sch_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Midikngei han, “Pumapa tikhanmo no vonchâmin nang kin mua, sâk nang kin pêka, tui inrâlin nang kin mua nêk rang nang kin pêk? ");
INSERT INTO sch_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Tikhanmo khuolmin nang kin mua, kin inah nang kin mintunga, dierboiin nang kin mua, puonsil rang nang kin pêk? ");
INSERT INTO sch_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Tikhanmo damloiin mo, intâng ina mo nang kin mua, nang kan pan ngâia?” ");
INSERT INTO sch_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Rêng han an kôm, “Nangni ki ril, hi ku sûngsuok achîntak ngei lâia mi inkhat chunga nin sin hah ku chunga nin sin ani,” tiin la tîng a tih. ");
INSERT INTO sch_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Hanchu a voi tienga mingei kôm han chu, Nangni chu Pathien khomâksâmna nuoia om roi! Diabol le a tîrtonngei ta ranga sin kumtuong meiah han se ta roi! ");
INSERT INTO sch_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ko von achâmin sâk mi pêk mak cheia, ku tui ânrâlin nêk rang mi pêk mak cheia; ");
INSERT INTO sch_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Khuolmi kinîn nin inah mi mintung mak cheia, dierboiin ko omin puon ni min sil mak cheia, damloiin le intâng ina ko om khomin mi pan ngâi mak chei,” la tîng a tih. ");
INSERT INTO sch_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Hanchu anni han an kôm, “Pumapa tikhanmo no von achâmin mo, tui ânrâlin mo, khuolmin mo, dierboiin mo, damloiin mo, intâng ina mo nang kin mua, ni sin nang kin tho pe ngâi loi?” Tiin la thuon an tih. ");
INSERT INTO sch_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Rêng han an kôm, “Nangni ki ril, hi mi chînte ngei lâia inkhat chunga nin sin nuom loi chu ku chunga nin sin loi ani,” la tîng a tih. ");
INSERT INTO sch_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Hi mingei hih kumtuong dûktuongna sêng an ta, hannirese, midikngei chu kumtuonga ringna han sêng an tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Hanchu Jisua'n ha chongngei murdi hah a ril zoiin chu a ruoisingei kôm, ");
INSERT INTO sch_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Sûnnik suoleh, Kalkân kût hong om atih iti nin rieta. Miriem Nâipasal hih jêmdel rangin pêk nîng atih,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Hanchu ochaisingei le Upangei hah Ochai Inlal Caiaphas inpuia intongna an neia, ");
INSERT INTO sch_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","inrûkin an sûra, an that rang lam an mintuoa. ");
INSERT INTO sch_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nikhomrese, “Kût sûngin chu ni no rese, mipui lâia injêlna tete om duoi nih,” an tia. ");
INSERT INTO sch_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Hanchu, Jisua hah Bethany'a aphârpa Simon inah a oma. ");
INSERT INTO sch_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jisua bu a nêk lâitakin, nupang inkhat alabaster bilôrin sariek mirimhoi man luttak ahong chôia, a luah a buok pea. ");
INSERT INTO sch_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ruoisingeiin an mu inchu an ningathika. “Irangmo hi anga a inchek hi? ");
INSERT INTO sch_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Hi mirimhoi hih man tamtaka zuora, inriengngei kôma sem thei kêng ani,” an tia. ");
INSERT INTO sch_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisua'n an ti ngei hah a rieta, an kôm, “Ithomo hi nupangnu hih nin rokôk? kata rangin sin asa le enhoi tak ai tho ani. ");
INSERT INTO sch_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Inriengngei chu nin kôma om tit an nia, hannirese, kei chu nin kôma om bang noning. ");
INSERT INTO sch_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Hi sariek mirimhoi ka takpuma ai buok hih phûm ranga ni sinsiamna ranga ai tho ani. ");
INSERT INTO sch_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Atûn, chongdiktak nangni ki ril, rammuol pumpuia thurchisa an misîrna nâma, hi nupangnu sintho khom hih ama riettitna rangin misîr sa ngâi an tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Masuole Ruoisi sômleinik ngei lâia inkhat a riming Judas Iscariot an ti hah ochaisingei kôm a sea ");
INSERT INTO sch_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Male ama'n, “Jisua nangni ki minsûr inte imo mi nin pêk rang?” a tia. Anni han sumdâr sômthum an tela ama an pêka. ");
INSERT INTO sch_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Masuo renga chu Judas han Jisua an kuta a pêk theina rangin chuminrên a rok tit zoi. ");
INSERT INTO sch_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Cholboivâipôl Kût ni sûn motontakah han, ruoisingei an honga, Jisua kôm, “Kalkân Kût hih khotieng mo va minsûk unglang nu nuom?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ama han an kôm, “khopuiliena mi inkhat kôm se ungla, a kôm. ‘Minchupu'n ko zora anâi zoia; ku ruoisingei leh Kalkân Kût ni inah mang kin tih,’ a ti va ti roi,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jisua'n an kôm he a be lam angtakin an thoa, Kalkân Kût hah an va minsûk zoia. ");
INSERT INTO sch_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kholoi ahong nînchu, Jisua le ruoisi sômleinik hah khalâi ottin an insung lâiin. ");
INSERT INTO sch_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Khalâi an ot lâitakin Jisua'n an kôm, “Nangni ki ril, nin lâia mi inkhat hin ni minsûr a tih,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Hanchu ruoisingei mulung dûkatonga, a kôm, “Pumapa, keima mo mi ni ti?” tiin inkhat inkhatin an rekel paka. ");
INSERT INTO sch_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jisua'n an kôm, “Khênga vâipôl mi pûrpuipu hin ni minsûr a tih. ");
INSERT INTO sch_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Pathien Lekhabu'n ai ti anghan, Miriem Nâipasal hih thîng a tih, nikhomrese, Miriem Nâipasal minsûrpu chung chu arik bâk rang na! Ha miriem ha chu ânzir tetloi nisenla ata rangin sa uol a tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","A minsûr rangpu Judas hah a hongchonga, “Minchupu, keima mo mini ti tatak?” tiin a rekela. Jisua'n a kôm, “Nên ti hate” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Hanchu an sâk lâitakin, Jisua'n vâipôl a lâka, râisânchong a ril zoiin chu a khoia, a ruoisingei kôm a pêka, an kôma, “Lâk ungla, sâk roi, hi hih ka taksa ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Masuole chu, kilât a lâka, Pathien kôm râisânchong a ril zoiin chu an kôm a pêka, “Nêk roi, nin rêngin; ");
INSERT INTO sch_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ma hih ki thisen mi tamtak nunsie ngâidamna ranga suok rang, Pathien chonginkhit mindet rang chu ani. ");
INSERT INTO sch_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nangni ki ril, Ka Pa Rêngrama nangni leh uain thar ke nêk ni atung mâka chu hi uain hih nêk nôk khâi no ning,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Masuole chu la inkhat an thoa, an tho suolechu Oliv tâng tieng an se zoi. ");
INSERT INTO sch_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Hanchu Jisua'n an kôm, “Avien jân lelea hin nin rêngin rot let nin ta, ni mâk riei nin tih, Pathien Lekhabu'n, ‘Pathien'n belrihôlpu hah that an ta, belringei hah chekinchâi chit an tih,’ a ti sikin. ");
INSERT INTO sch_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","nikhomrese, kên thoinôk suoleh Galilee rama nin motona lei sêng ki tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peter'n a kôm, “Adangngeiin nang mâk riei khomrese ngei, keiman chu nang mâk tet no ning!” a tia. ");
INSERT INTO sch_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jisua'n Peter kôm, “Nang ki ril, avien jân ârkhuong mân nangma'n voithum keima hih riet ngâi mu-ung ni tîng ni tih,” a tipea. ");
INSERT INTO sch_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peter'n a kôm, “Ni thina thisa rang khom nînlang ma anghan ti tet no ning,” tiin a thuona. Ruoisi dangngei khomin ha angdên han an ti paka. ");
INSERT INTO sch_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Hanchu Jisua hah a ruoisingei leh munkhatin Gethsemani an tina han an sea, Jisua'n an kôm, “Soson chubai ka va tho sûngkâr chu hin lên sung roi,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Peter le Jebedee nâipasal inik ngei hah a tuonga, Rathainvâina le mulungdûk tongnân ahong sipa, ");
INSERT INTO sch_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","male an kôm, “ka mulungdûk atong raia athi rang dôrin kêng ki ni zoi. Hin om ungla mên ning pui roi,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Hanchu, mântieng ava se uol vieta, pila ânboka, chubai a thoa, “O Pa, anitheiin chu, hi tuongna kilât hih ko kôm renga ni khâi pai pe roh! Nikhomrese, keima racham niloiin nangma racham ni rese,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Masuole chu a hongkîr nôka, ruoisi inthum ngei hah an inin a hong mua; Peter kôm, “Inmo nangni inthum hite dârkâr khat luo khom mi inningpui thei loi tie hi? ");
INSERT INTO sch_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Huongna nin lût loina rangin intûng chienin chubai roi. Ratha'n chu a nuoma, taksa'n ai phari loi ani” a tia. ");
INSERT INTO sch_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Hanchu, avoiniknân Jisua a se nôka, a chubai nôka, “O pa hi tuongna kilât hi ke nêk loia pai thei aninônchu nangma racham ni rese,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","A hong nôkin chu ruoisingei hah ain dênin a mu nôka; an mitngei reng an meng zoi loi sikin. ");
INSERT INTO sch_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jisua'n a mâk ngei nôka, a voithumnân a ti nanâk hah tiin chubai a tho nôka. ");
INSERT INTO sch_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Male ruoisingei kôm a hong nôka, an kôm, “Atûn tena inngamin nin la in bang na? En ta u, Miriem Nâipasal hih mi nunsiengei kuta pêk rang zora ahongtung zoi. ");
INSERT INTO sch_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Inthoi ungla, sêng ei ti zoi. En ta u, ni sûr rangpu hih ahong nâi zoi!” a tia. ");
INSERT INTO sch_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Hanchu, Jisua a chong la mong loiin ruoisi sômleinik ngei lâia Judas hah a hong tunga. Ama lômin Ochaisingei le Upangei hongtîr mipui, khandai le tôkmol chôiin an hong sa. ");
INSERT INTO sch_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","A minsûr rangpu han, “A bieng ku tum takhah nin rokpu nîng a tih, sûr kelen roi!” tiin minsinna a lei pêksai ani. ");
INSERT INTO sch_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas hah Jisua kôm a se pata, a kôm, “Minchupu, nu chunga rathanngamna om rese,” tiin a bieng a tuma. ");
INSERT INTO sch_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jisua'n a kôm, “Mal, no hongna abi tho kelen roh!” a ti pea, Hanchu an honga, Jisua hah an sûr zoi. ");
INSERT INTO sch_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jisua kôma om ngei lâia inkhatin a khandai a leka Ochai Inlaltak, a tîrlâmpa kuor a tukthâk pea. ");
INSERT INTO sch_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jisua'n a kôm, “Na khandai hah a koka thun nôk ta roh. khandai a lek ngei chu khandai nanâkin thîng an tih. ");
INSERT INTO sch_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ka Pa kôm sanna ko zong theia, ama'n voikhatrengin vântîrton isâng ruk pâl sômleinik nêka tam a juongtîr thei iti ni riet loi mini? ");
INSERT INTO sch_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nikhomrese, ngên ta inlang, i angin mo Pathien chong hih hi anga hong iom rang hih ai tung thei ranga?” a tia. ");
INSERT INTO sch_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Hanchu, Jisua'n lokongei kôm han, “Khandai leh tôkmol chôiin inru sûr rang leh in-ang bangin misûr rangin nin hong na? Nîngtin Biekinah kên sunga, ki minchu ngâia, mahan misûr mak cheia. ");
INSERT INTO sch_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nikhomrese, dêipungei chong miziek ngei hah ahong tung dik theina rangin, hi ngei murdi hih a hong iom ani hi,” a tia. Hanchu, ruoisingei murdi'n ama an mâk raka an rêngin an rot riei zoi. ");
INSERT INTO sch_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Hanchu, Jisua sûrngei han, Ochai Inlaltak Caiaphas inah Balam minchupungei le Upangei lei intûpna han an tuong zoia. ");
INSERT INTO sch_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Peter'n alazanin a jûia, Ochai Inlaltak in khalâi dênin a jûia. Khalâidung a lûta a mongna mu rang nuomin a rungpungei kâra han ânsunga. ");
INSERT INTO sch_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Jisua an that theina rangin Ochaisingei le roijêkpu murdi han theiloi an mintum theina rang abi an roka; ");
INSERT INTO sch_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","nikhomrese, mu mak ngei, mi tamtak hongin a chungroia milak ril khom senla ngei. Anûktakah mi inik an honga, ");
INSERT INTO sch_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","male, “Hi mi hin, Biekin hih setin sûnthumin ki sin nôk thei,” a ti an tia. ");
INSERT INTO sch_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ochai Inlaltak hah ândinga, Jisua kôm, “Hi nang an nônna roia hin ite thuonna ni nei loi rang mo?” a tia. ");
INSERT INTO sch_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nikhomrese, Jisua chu a dâireka. Ochai Inlaltak han arkôk nôka, “Pathien aring rimingin nang ki ti; ni ril roh, Pathien Nâipasal Messiah hah nini mo?” a tia. ");
INSERT INTO sch_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jisua'n a kôm, “Ni na ti hate. Mahah ninôn khom nang ki ril; atûn renga Miriem Nâipasal hih Râtinchung chang tienga, insunga, invâna sûm chunga juong la mûng nin tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ochai Inlal han a puonsilngei a potkhêra, “Pathien a rilsiet zoi; Rietpuipu dang nâng khâi mak meh! Pathien a rilsiet tie chu nin riet zoi! ");
INSERT INTO sch_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","I angin mo nin mindon?” a tia. Anni han, “A tho minchâi, athi ngêt rang ani” an tia. ");
INSERT INTO sch_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Hanchu a mâia an michila male an jêma; senkhatin, ");
INSERT INTO sch_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Ni ril roh, Messiah, Tumo nang a jêm?” tiin an bêna. ");
INSERT INTO sch_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Hanchu, Peter hah rukul sûng khalâiah ânsunga, Ochai Inlaltak tîrlâm dôngmate inkhat a honga, a kôm, “Nang khom, Jisua Galilee rama mi kôm no om ngâi,” a tipea. ");
INSERT INTO sch_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Hannirese, an rênga makunga a minlêma. “I thurchi mo nin misîr reng riet mu-ung” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Rukul mokot pêntieng ava jôka, tîrlâm dôngmate dangin a lei mu nôka. Ha takah omngei kôma han, “Hi mi hih, Nazareth Jisua kôma a om ngâi” a tia. ");
INSERT INTO sch_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Peter'n a minlêm nôka, “Khomâk insâmin ki ti ani, ha mi hah riet mu-ung!” a ti nôka. ");
INSERT INTO sch_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Chomolte suoleh chu hataka inding ngei hah Peter kôm an honga, a kôm, “Nang khom an lâia mi nini khet, No chong lam renga hin ei riet thei!” an tipea. ");
INSERT INTO sch_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Male Peter'n an kôm, “Chongdik rillin khomâk kên sâm ani! Adik nônchu Pathien'n dûk ni mintong rese! Ha mi hah riet tet mu-ung!” a tia. Masuolechu âr akhuong kelen zoi, ");
INSERT INTO sch_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","male Peter han, Jisua'n a kôma, “Âr akhuong mân voithum ni minlêm ni tih,” ai tipe chong hah a hong rietsuok nôka. A jôka a chap ngu-ngui zoi. ");
INSERT INTO sch_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Jîng ahongnin chu Ochaisingei murdi le Upangei han Jisua that rang lampui an sinna. ");
INSERT INTO sch_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Zingjirûiin an khita, an tuonga, Pilat, Rom râiôt kôm an pêka. ");
INSERT INTO sch_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","A minsûrpu Judas han, Jisua theiloi an mintum ti a riet inchu ânsîra, a sumdâr sômthum hah Ochaisingei le Upangei kôm a hongchôi nôka. ");
INSERT INTO sch_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Midik thi ranga ki minsûr ha chu ki minchâi sabak kêng ani zoi,” a tia. Anni han a kôm han, “Mahah kan ta rangin imo asena. Maha chu nangma sintho kêng!” an tipea. ");
INSERT INTO sch_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas han ma sumdâr hah Biekin sunga a paia, a rota; hanchu, a sea, avan khâi that zoi. ");
INSERT INTO sch_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ochaisingei han sum hah an rûta, “Mahih chu thisen man sum ani sikin Biekina sum darna munna dar rangin chu inthieng mak” an tia. ");
INSERT INTO sch_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Hanchu, an inruola, ramdangmingei phûmna mun rangin Bêlvuokpu mun an rochôka. ");
INSERT INTO sch_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Masikin ma mun hah atûn tena (Akeldama) “Thisen Mun” an ti tit zoi. ");
INSERT INTO sch_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Hanchu Dêipu Jeremiah'n, “sumdâr sômthum hah an lâka Israelngeiin ama man ranga adôr an masat hah, ");
INSERT INTO sch_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","male Pumapa chongpêk anghan, bêlvuokpu mun man rangin sum hah an mang zoi,” ai ti hah ahong dik zoi ani. ");
INSERT INTO sch_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisua hah Rom râiôt makunga ândinga, râiôt'n, “Judangei rêng nini mo?” tiin chong a rekela, Jisua'n, “Ni ni, ni ni ti zoi hate,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Hannirese, Ochaisingei le Upangeiin an nônna roia chu itên thuon mak. ");
INSERT INTO sch_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Masikin, Pilat'n a kôm, “Nang an nônna roi hih ni riet loi mini?” a tia. ");
INSERT INTO sch_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Nikhomrese, bâikhat luo khomin thuon maka, Râiôt chu asân a kamâma. ");
INSERT INTO sch_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Hanchu Rom râiôt han Kalkân Kût zora racham mi intâng inkhat lokongei an ti tak a mojôk pe ngei ngâia, ");
INSERT INTO sch_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ha lâia han mi intâng, riming inthang tak Barabbas an ti hah a oma. ");
INSERT INTO sch_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Masikin lokongei an hong intûp inchu Pilat han an kôm, “Tu himo nangni mojôk pe inlang nin nuom? Barabbas himo, Jisua Messiah an tipu himo?” tiin a rekela. ");
INSERT INTO sch_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Juda rachamneipungei han Jisua hah an narsa sika a kutah an hong pêk ani ti ânthârtakin a rieta. ");
INSERT INTO sch_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Hanchu Pilat hah roijêkna munah ânsung lâitakin a lômnûn, “Ha midik chunga han ite tho no roh, jânin han ka ramangin ama sikin ku tuong ok kêng” tiin chong a hong bea. ");
INSERT INTO sch_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ochaisingei le Upangeiin Barabbas mojôka Jisua that ranga Pilat kôma ngên rangin mipui ngei an methêma. ");
INSERT INTO sch_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Hannirese Pilat'n mipui ngei kôm han, “Hi mi inik ngei lâia hin tu himo nangni mojôk pe ronga nin nuom?” tiin a rekela. Anni han, “Barabbas” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilat'n an kôm, “Hanchu, Jisua Messiah an ti hih, imo ko lo rang ani zoi?” tiin a rekel ngeia. “Khrosa jêmdel roh” tiin an thuona ");
INSERT INTO sch_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nikhomrese, Pilat'n an kôm, “Imo ai tho minchâi?” tiin a rekel ngeia. “Khrosa jêmdel roh!” tiin an rât dodôrin an inieka. ");
INSERT INTO sch_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilat'n ite anêmna om no nia, injêlna vai kêng ai suok rang ti amun chu tui a lâka, lokongei makunga a kut a rusuka, an kôm, “Hi miriem thina hin ite theiloina dôn mu-ung! Mahih nin sintho kêng ani!” a tia. ");
INSERT INTO sch_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Loko murdi'n, “Hi mi thina sika dûk chu keini le kin nâingei chungah chul rese!” an tia. ");
INSERT INTO sch_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Hanchu Pilat'n Barabbas hah a mojôk pe ngeia; male Jisua hah a jêm suolechu Khrosa jêmdel rangin an kutah a pêk ngei zoi. ");
INSERT INTO sch_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Hanchu, Pilat râlmingei'n Jisua hah râiôt inpuia an tuonga, an pâla mi murdi a kôla an intûpa. ");
INSERT INTO sch_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","A puonngei an lîk pea, puon senduk an minsila. ");
INSERT INTO sch_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Male, riling tapor an phana, an min khuma, a kut chang tieng khiengrol an min chôia; a makungah khûkinbilin, “Juda ngei Rêng ring sôt roh!” tiin an phengsana. ");
INSERT INTO sch_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","An michila, a khiengrol hah an suta, a luah an tôka. ");
INSERT INTO sch_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Hanchu, an phengsan suolechu puon senduk hah an lâk nôka, ama puon dên hah an minsil nôka. Hanchu, Khrosa jêmdel rangin an tuong zoi. ");
INSERT INTO sch_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Hanchu, an se lâiin Cyrene khuo mi inkhat a riming Simon an tonga, râlmingei'n Jisua Khros ruput rangin an dândea. ");
INSERT INTO sch_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Golgotha, “Luru Mun” an ti hah an hong tunga, ");
INSERT INTO sch_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Mahan Jisua hah uain, tuikha leh inpol an pêka, a tem zoiin chu nêk nuom maka. ");
INSERT INTO sch_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Hanchu, Khrosa an jêmdela, male, taruosânin a puonsilngei an insema. ");
INSERT INTO sch_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Masuole chu, mahan insungin, an enna. ");
INSERT INTO sch_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","A lu chungah an nônna miziek, “Hi mi hih Jisua, Judangei Rêng ani,” tiin an târa. ");
INSERT INTO sch_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Hanchu, ama leh lômin inru inik a voitieng inkhat, a changtieng inkhat an jêmdel sa. ");
INSERT INTO sch_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Hanchu, ânlôi murdi'n an lu thukin Jisua an deia. ");
INSERT INTO sch_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Biekin set na ta, sûnthumin ni minding nôk rang na! Pathien Nâipasal ni nîn chu ne theiin insaninjôk roh! Khros lêr renga juong chum ta roh!” an tia. ");
INSERT INTO sch_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ma angdên han, Ochaisingei le Balam minchupungei le Upangei khomin ama an deia: ");
INSERT INTO sch_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Mi dangngei laka a minjôk ngâia, ama chu injôk thei maka! Israelngei rêng ni mak mo? Atûn Khros lêr renga juong chum rese chu iem ei tih! ");
INSERT INTO sch_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Pathien a iema, Pathien Nâipasal'n ânbea. Tho lei en rei u, Pathien'n atûn a minjôk nuom mo!” an tia. ");
INSERT INTO sch_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Inru, ama leh an jêmdel ngei khomin ha angdênin an dei sa. ");
INSERT INTO sch_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Hanchu sûn dâr sômleinik renga kholoi dârthum tenah chu rammuol ajîng khapa. ");
INSERT INTO sch_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Dârthumin chu Jisua rôl inring takin ânieka, “Eloi, Eloi, lema Sabacthani?” a tia. Mahah aomtie chu, “Ka Pathien, Ka Pathien, ithomo nina mâksan?” tina ani. ");
INSERT INTO sch_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ha munah ânding senkhat ngeiin mahah an rieta, “Elizah ai koi kêng” an tia. ");
INSERT INTO sch_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Hanchu, an lâia mi inkhatin a tâna sponj a lâka, uain thûra a michia, tôkmol mongah a târa, hong min nêk rang a thoa. ");
INSERT INTO sch_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Hannirese, mi dang ngeiin, “La ngâk roh, a minjôk rangin Elizah mo a juong lei en bak hi rei” an tia. ");
INSERT INTO sch_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jisua rôl inring takin âniek nôka, arang achat zoi. ");
INSERT INTO sch_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Hanchu, Biekina puonjâr hah alu renga among dênin akêr pata. Masuole chu pilchung ânnîka, lungpuingei an koia, ");
INSERT INTO sch_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","thânngei ahôn onga, Pathien mi tamtak alei thi ngei hah kaithoiin an oma. ");
INSERT INTO sch_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Thânngei hah an mâka, Jisua, thina renga ân thoinôk suoleh Khopuilien Inthiengah an lûta mahan mi tamtak kôm an inlâr zoi. ");
INSERT INTO sch_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Râlmi ulien le a kôla râlmi aom Jisua thîr ngei han, ningnu innîk le neinun om tie ngei hah an mûn chu an chia, “Hi mi hih Pathien Nâi ani khêt!” an tia. ");
INSERT INTO sch_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ma munah han nupang tamtak, Galilee ram renga Jisua nûkjûia asan ngâi ngei han alazanna renga an thîra. ");
INSERT INTO sch_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ha ngei hah Mary Magdalene ngei Jacob le Joseph nu Mary ngei le Jebedee lômnu ngei an ni. ");
INSERT INTO sch_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kholoi ahong nin chu mineipa Arimathea khuo mi a riming Joseph a hong tunga; ama khom Jisua ruoisi a lei nia. ");
INSERT INTO sch_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pilat makunga ava sea Jisua ruok hah ava zonga, ruok hah Joseph kôm pêk rangin Pilat'n chong a pêka. ");
INSERT INTO sch_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Masikin Joseph han ruok hah a musuma puoninnêm athar leh a thoma, ");
INSERT INTO sch_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","male thân lunga iver zoisuobila han a min jâla. Hanchu thân bâi hah lung alienpa leh a hîp zoiin chu a sea. ");
INSERT INTO sch_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mary Magdalene le Mary dang hah thân tieng mâithakin an insunga. ");
INSERT INTO sch_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Anangtûkah Sabbathni sûnin chu Ochaisingei le Phariseengei hah Pilat kôm an honga, ");
INSERT INTO sch_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","male a kôm, “O pu, ha milaka han aring lâiin, ‘Sûnthum suoleh chu inthoinôk ki tih’ a ti kin riet. ");
INSERT INTO sch_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Masikin thân hah sûnthum sûng chu asadima ngâk rangin chong pêk roh, a ruoisingeiin an sea, an va muruka, mipui lâia, ‘Thina renga ânthoinôk zoi’ an ti thei loina rangin. Ma anghan aninônchu hi huongna nûktak hih motona nêkin siet uol nih,” an tia. ");
INSERT INTO sch_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilat'n an kôm, “Râlmi tuong ungla,” male “se ungla thân hah nin thei lam dôra asân min ngâk roi,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Hanchu an sea, thân lung hah sîn thôn, a ngâk rang ngei hah an min ngâk ngei zoi. ");
INSERT INTO sch_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabbathni ahong heka, Pathienni jînga khuo ahongvâra, Mary Magdalene le Mary dang hah thân en rangin an sea. ");
INSERT INTO sch_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Inningloiin ningnu râttak ahong innîka, invân renga Pumapa Vântîrton a juonga; lung hah a muluoi paia a chungah ânsunga. ");
INSERT INTO sch_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","A mêl chu kôlinlek ang ania, a puonsilngei khom rodokang anga chek ani. ");
INSERT INTO sch_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Râlmi a ngâkngei han an chi rai zoi sikin an innîka, athi anghan an oma. ");
INSERT INTO sch_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Vântîrton han nupangngei kôm, “Nangni chu chino roi, Jisua an jêmdelpu hah nin rok ani ti ki riet. ");
INSERT INTO sch_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Hin om khâi maka; ai ti anghan ân thoinôk zoi. Hin hong ungla, a jâlna hih hong en roi. ");
INSERT INTO sch_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Atûn inrangtakin se ungla, a ruoisingei kôm, Thina renga ân thoinôk zoi, Galilee rama nin motona a lei se; mason mûng nin tih! Nangni ki ril hih riettit roi” a tia. ");
INSERT INTO sch_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Hanchu, ichi le râisânna sipin, thân renga an se lalaia, ruoisingei varil rangin an tân zoi. ");
INSERT INTO sch_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Inningloiin Jisua'n anni hah a tonga, an kôm, “Nin chunga rathanngamna om rese” a tia. Hanchu, a kôm an honga, a kepha an sûra, chubai an mûka. ");
INSERT INTO sch_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jisua'n an kôm, “Chino roi, se ungla, Galilee rama se rangin ku sûngsuokngei varil roi; mason ni mûng an tih” a tia. ");
INSERT INTO sch_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nupangngei hah lama an lôn lâitakin thân ngak râlmi senkhatngei hah khopuiliena an kîr nôka, neinun om tie murdi hah ochaisingei an va rila. ");
INSERT INTO sch_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ochaisingei hah Upangei leh anin mua lungvâr an thoa; râlmingei kôm han sum tamtatak an pêka, ");
INSERT INTO sch_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","an kôm, “Jâna kin inkârin a ruoisingei an honga, a ruok an hong muruk ani, tiin misîr roi. ");
INSERT INTO sch_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Râiôt han ha thurchi hah a lei riet lekhom, theiloina dôn mak chei tiin nangni rilpui kin ta, ite nin mulung nin minjîngna rang omak,” an tia. ");
INSERT INTO sch_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Râlmingei han sum hah an lâka, chong an be lam angtakhan an tho zoi. Masikin atûn tenah ha thurchi hah Judangei lâia an la ril minlum bang ngâi ani. ");
INSERT INTO sch_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Hanchu ruoisi sômleikhat ngei hah Galilee rama tâng inkhata Jisua'n se roi a tipe ngeina han an sea. ");
INSERT INTO sch_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ama an mûn chu chubai an mûka, senkhatin iem tatak no khom senla ngei. ");
INSERT INTO sch_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jisua'n ahong nâia, an kôm, “Pilchunga le Invâna rachamneina murdi ko kôm pêk ani zoi. ");
INSERT INTO sch_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Hanchu, muntina mingei murdi kôm se ungla, ku ruoisîn sin ngei ungla: Pa, Nâipasal le Ratha Inthieng rimingin Baptis ngei ungla, ");
INSERT INTO sch_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","chong nangni ke pêk murdi jôm rangin ril ngei roi. Male Keima zoratin rammuol mong dênin nin kôma om tit ki tih,” a tia.");
INSERT INTO sch_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Pathien Nâipasal Jisua Khrista Thurchi Sa chungroi chu mahi ani. ");
INSERT INTO sch_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Dêipu Isaiah Lekhabua: “Pathien'n, ‘Na lampui sinsiem rangin ka thangtheipu no motona tîr ka ta.’ ");
INSERT INTO sch_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ramchâra mi inkhat tânghâi han, ‘Pumapa lamlien sin ungla; a lôna rang lampui mintûn roi!’” tia ânziek anghan ânphut ani. ");
INSERT INTO sch_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Masikin John hah Baptis tho le thurchi misîrin ramchâra han a juong ani. Mingei kôm han, “Nin sietnangei renga insîr ungla, baptisma chang roi,” hanchu, “Pathien'n nin sietnangei nangni ngâidam atih” tiin a misîr ngâia. ");
INSERT INTO sch_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Judea ram le Jerusalem khopui renga mi tam tak John thurchi misîr rangâi rangin an sea. An sietnangei an phuonga, male ama'n Jordan dunga a Baptis ngei zoi. ");
INSERT INTO sch_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","John'n ûtmul puonngei ânsila, savun kongkhit a khita, a sâk chu khâimimsie, le rama khuoilutui ani. ");
INSERT INTO sch_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Mingei kôm han, “Ku nûka juong rangpu hi chu keima nêka roiinpui uol ok ania, kei chu inkûna a kekokrûi sût rang luo inhoi mu-ung. ");
INSERT INTO sch_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Keima chu tui leh nangni ka Baptis ngâia, ama'n chu Ratha Inthiengin nangni Baptis atih,” a tia. ");
INSERT INTO sch_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Galilee ramhuola Nazareth khuo renga Jisua hongna la sôt bâkloiin, Jordan dunga John'n Baptis a thoa. ");
INSERT INTO sch_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jisua hah tui renga a hong jôk harenghan, invân ân-onga male Ratha Inthieng pharvali angati a chunga juong chum a mua. ");
INSERT INTO sch_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Male invân renga rôlin, “Nangma ka Nâipasal moroitak ni ni, nu chunga ka râiasântatak ani” ti chong ajuong tunga. ");
INSERT INTO sch_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Voikhatrengin Ratha'n ramchâra a min se zoia, ");
INSERT INTO sch_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","mahan Soitan methêmin sûn sômminli a oma. Mahan ram sângei khom an oma, aniatachu vântîrtonngei han an juong san ngâi. ");
INSERT INTO sch_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","John hah intâng ina an khum suole chu, Jisua hah Pathien renga Thurchi Sa misîr rangin Galilee rama a sea. ");
INSERT INTO sch_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Azora diktak hah ahongtung zoi,” male, “Pathien Rêngram khom anâi zoi! Nin sietnangei renga insîr ungla male Thurchi Sa hi iem ta roi!” tiin a misîra. ");
INSERT INTO sch_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisua'n Galilee dîl panga a lôn lâiin ngasûrpu inik Simon le a nâipa Andrew lên lei vôr hah a mua. ");
INSERT INTO sch_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jisua'n an kôm, “Ni jûi ungla, miriem sûr rangin nangni minchu ki tih” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Marenghan an lênngei an mâkraka male an jûi kelen zoi. ");
INSERT INTO sch_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","A se nôk uol vietin chu lâibungsa dang Zebedee nâipasalngei, Jacob le a nâipa John a mu nôka. An lênngei sinsiemin rukuong chunga an lei oma. ");
INSERT INTO sch_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jisua'n anni ngei hah a mu ngei lehan, a koi ngeia; an pa Zebedee hah inlo mingei kôm rukuonga an mâka, male Jisua leh an se kelen zoi. ");
INSERT INTO sch_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jisua le a ruoisingei hah Capernaum khopuia an honga, Sabbathni sûn anîn chu Jisua Synagog taka a lûta, male mi a minchu kelen zoia. ");
INSERT INTO sch_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","A minchu lam ariet mingei han kamâm aom sabak an tia, Balam minchupungei angin niloiin; manêkin, rachamneitakin anni ngei ha a minchu sikin. ");
INSERT INTO sch_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Masuole han, ramkhori sûr mi inkhat synagog han a honga an iek raka, ");
INSERT INTO sch_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ha mi han, “Nazareth Jisua, keini renga imo na nuom aom? Mi minmang ranga hong mo ni ni? Nang ki riet Pathien thangtheipu inthieng ni ni!” a tia. ");
INSERT INTO sch_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jisua'n ratha kôm han, “Dâirek inla, male ha miriem sûng renga hah hong jôk pai roh!” tiin chong a pêka. ");
INSERT INTO sch_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ratha saloi han amapa hah anîkbit suole chu inringtakin ân ieka, male a sûng renga a hong jôk pai zoia. ");
INSERT INTO sch_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Mingei han kamâm aom sabak an tia, “Ma hih imo ani hi? Mahi minchuna thar mo ani? Ratha saloingei khom rachamneitakin chong a pêk ngeia, male a chong an jôm kelen hi?” Inkhat le inkhat anin rekel inlôma. ");
INSERT INTO sch_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Masikin Galilee ramhuol pumpuia Jisua thurchi ânthang zit zoi. ");
INSERT INTO sch_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jisua le a ruoisingei, Jacob le John telsân Synagog renga an jôka, male Simon le Andrew ina rangin an thengpata. ");
INSERT INTO sch_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon tarpi hah ritun damloiin jâlmuna a lei oma; Jisua ava tungin chu harenghan, amanu damloi roi hah an lei rila. ");
INSERT INTO sch_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Amanu kôm han a sea, a kuta a mutua, sanin a kaithoia. Amanu mintun hah a dama, male amanu han an sin a tho pe ngei zoi. ");
INSERT INTO sch_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Masuole chu kholoi ahong nia male nisa ahong tâkin chu, mingeiin Jisua kôm damloi murdi le ramkhori sûr ngei an hong tuonga. ");
INSERT INTO sch_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Khopui sûnga mingei nâm inkot kôla an hong intûpa. ");
INSERT INTO sch_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jisua'n ri jât tamtak ngei a mindama male ramkhori tamtak a rujûlpaia. Ramkhoringei han ama an riet sikin, ite an ti rangin phal ngei mak. ");
INSERT INTO sch_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Anangtûk jînga chu avâr mân rengin Jisua ânthoia, in renga hah a jôka. Khopui renga mun inthimna a sea, mahan chubaithona ava manga. ");
INSERT INTO sch_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Hannirese Simon le a champuingei han ama an hong roka, ");
INSERT INTO sch_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","male an va mu lehan, a kôm, “Mitinin nang an rok,” an tipea. ");
INSERT INTO sch_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Hannirese Jisua'n an kôm, “Hi revêla khuo dangngeia khom hin ei se ngêt rang ani. Hi ngei hin khom thurchi ki misîr rang anâng ani, maha ku juongna abi ani sikin,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Masikin synagogngeia thurchi misîrin le ramkhoringei rujûlpaiin Galilee ram pumpuia a chai zoia. ");
INSERT INTO sch_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jisua kôm mi inkhat vun ri dôn a honga, khûkinbilin, male san rang a ngêna, “Nu nuomin chu mi ni minthieng thei,” a tia. ");
INSERT INTO sch_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jisua'n inriengmunân asipa, male a kut ahong sôna, male a tôna, “Ka nuom,” hong, “Inthieng ta roh!” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Voikhatrengin a pangphâr hah ahong boi kelena, male ânthieng zoi. ");
INSERT INTO sch_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jisua'n chongnazatin a tipea, a tîr kelena, ");
INSERT INTO sch_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","a kôm a ti suole, “Rangâi roh, hi roi hih tute ril tet no roh duo. Hannirese ochai kôm thengpat inla va min mu roh; masuole chu mitinin nên thieng nôk zoi ti an riet minthârna rangin Moses chongpêka inbôlna pêk ranga ati hah pêk roh” a tipea. ");
INSERT INTO sch_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Hannirese amapa hah a jôka, ma thurchi hah muntina a phuong minzara. Adikin, a ril minlum rai sikin Jisua chu ânlangin khopuia lût thei khâi maka, mun inthim ngeia a va oma, male muntin renga a kôm mingei an hong ngâi ani. ");
INSERT INTO sch_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Sûn tômte suole chu Jisua Capernaum taka a se nôka, male ina a om ti roi ânthanga. ");
INSERT INTO sch_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Masikin mi tamtak an hong intûpa, inkhâr pêntieng luo mun tong khâi maka. Jisua'n an kôm thurchi a misîr lâitakin ");
INSERT INTO sch_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","phalkhatthi inkhat mi minlîn a kôm an hong rojôna. ");
INSERT INTO sch_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nikhomrese loko an tam rai sikin a kôma hong tungpui thei mak ngeia, masikin Jisua omna ridîn taka inchung an phêna. An phên zoiin chu phalkhatthipu hah a jâmpher leh an juong musuma. ");
INSERT INTO sch_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jisua'n an taksôn tie hah a mua, phalkhatthipa kôm han, “Ka nâipasal, ni sietnangei ngâidam ani zoi,” a tia. ");
INSERT INTO sch_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Balam minchupungei senkhat ma muna insung ngei han an mindonna, ");
INSERT INTO sch_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Hi mi hin ithomo hi anga a chong ngam hi? Pathien a rilminsiet ani! Pathien vai ke sietnangei ngâidam thei!” an tia. ");
INSERT INTO sch_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Harenghan Jisua'n an mindon hah a rieta, an kôm, “Ithomo ma anghan nin mindonna? ");
INSERT INTO sch_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Phalkhatthi kôm han, ‘Ni sietnangei ngâidam ani zoi,’ ti le ‘Inthoi inla, na jâmpher luok inla lôn ta roh,’ ti hih kho hi mo a ti abai uol? ");
INSERT INTO sch_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Hanchu, philchung hin Miriem Nâipasal'n sietnangei ngâidam theina racham a dôn ti nangni lei min mu rong” a tia. Masikin phalkhatthi kôm han, ");
INSERT INTO sch_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Inthoi inla, na jâmpher luok inla, ni ina se ta roh!” tiin nang ki ril a tia. ");
INSERT INTO sch_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","An rêngin an enchungchakin ama hah ânthoia, a jâmpher a luoka, a se kelen zoia. An rêngin an kamâm sabaka, Pathien an minpâka, “Hima anga neinun hih chu la mu tet ngâi mak me!” an tia. ");
INSERT INTO sch_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisua Galilee dîl panga a se nôka. Loko ngei a kôm an sea, male a minchu ngei phut zoia. ");
INSERT INTO sch_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","A sena sumrusuongpa Levi Alphaeus nâipasal, a office taka ânsung a mua. Jisua'n a kôm, “Ni hong jûi roh,” a tipea. Levi ânthoia, male ama a jûi zoi. ");
INSERT INTO sch_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Chomolte suole chu Levi ina bukhalâi an ota. Sumrusuong ngâi mi tamtak le mitelloingei Jisua an jûia, male mi tamtakin Jisua le a ruoisingei bukhalâi otna dosânga an inchela. ");
INSERT INTO sch_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Phariseengei le Balam minchupungei senkhatin, Jisua chu mitelloingei le sumrusuongpungei leh bu a nêk an mûn chu a ruoisingei kôm, “Khoitho mo ma anga mingei lâia bu a nêk?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jisua'n an chong hah a lei rieta, an kôm, “Adamngeiin doctor nâng ngâi mak ngeia, aniatachu adamloi ngei chu doctor an nâng ngâi. Midikngei ralam ranga juong ni ma-unga, mitelloingei ralam ranga juong ke ki ni,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Zora khat chu Baptispu John nûkjûingei le Phariseengei han bu an ngêia. Mingei senkhatin Jisua kôm an honga, a kôm, “Ithomo John nûkjûingei le Pharisee ruoisingei hi bu an ngêi ngena, aniatachu nu ruoisingei hi an ngêi ngâi loi?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jisua'n an kôm, “Inneina khuolmingei ha bungêi rangin nin lei sabei mini?” Ni thei no ni! Mâkpa hah an kôma aom kâr chu bungêi no ni ngei. ");
INSERT INTO sch_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Hannirese an kôm renga mâkpa ha an tuong pai nikhuo la tung a ta, ma tika chu la ngêi an tih. ");
INSERT INTO sch_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Tutên puon muruo chitphonân puon thar relek mang ngâi mak ngei, mang ngân khom senla athar han amuruo hah minchîrup a ta chet uol atih. ");
INSERT INTO sch_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tutên uain thar khom savun ûm muruo taka thun ngâi mak ngei, thun ngân khom senla, uain thar han savun ûm hah mût khoi a ta, uain le savun ûm le mangmunboi chang atih. Manêkin, uain thar chu savun ûm thara ngêt thun nîng atih” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabbathnin Jisua bubilngei senkhata a lôna. A ruoisingeiin ama leh an lôn pumin buvûingei ha an china ");
INSERT INTO sch_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Masikin Phariseengeiin Jisua kôm, “En ta, nu ruoisingeiin Sabbathnia an tho hi! Mahi ei Balamin akhap ani,” an tia. ");
INSERT INTO sch_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jisua'n an kôm, “David'n sâk rang ânsam lâihan a tho hah nin la pore tet ngâi loi mini? Ama le a miriemngei an vonchâm sabaka, ");
INSERT INTO sch_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","masikin David han Pathien ina a lûta, Pathien kôma pêksai vâipôl hah a sâka. Mahi Abiathar Ochai Inlaltak a chang lâihan ani. Ei Balam dungjûiin chu ha vâipôl hah Ochaingei vai ke an sâk thei ngâi ani, aniatachu David'n a sâka male a miriemngei khom a sem ngei sa.” ");
INSERT INTO sch_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Male Jisua'n, “Sabbathni chu miriemngei sana ranga sin ania, miriem chu Sabbathni ranga sin nimak. ");
INSERT INTO sch_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Masikin Miriem Nâipasal hih Sabbathni a Pumapa khom ani” tiin chong a khâr zoi. ");
INSERT INTO sch_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Hanchu Jisua ha Synagog a se nôka, mahan mi inkhat a kut phalkhatthi a lei oma. ");
INSERT INTO sch_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Sabbathni ani sikin Jisua râlngeiin a tho minchâia an nôn theina rangin; Sabbathni mi a mindam pupui mo tiin mi senkhat ngeiin an en richika. ");
INSERT INTO sch_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jisua'n kut phalkhatthi kôm han, “Moton tieng hong inding roh,” a tipea. ");
INSERT INTO sch_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Hanchu Jisua'n mingei kôm han, “Ei Balamin Sabbathnin imo ei tho rangin mi phal? San rang mo, aninônchu minna rang mo? Mi ringna mojôk rang mo, aninônchu mi minmang mo?” tiin a rekel ngeia. Hannirese ite ti mak ngeia. ");
INSERT INTO sch_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jisua'n an tieng a en ngeia a taksi oka, aniatachu an mulungngar raina le an dikloi raina hah a riet sikin asân a jâm a manzala. Hanchu amapa kôm han, “Nu kut lâng roh” a tipea. A kut a lânga male a dam nôk zoia. ");
INSERT INTO sch_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Masikin Phariseengei hah synagog renga an jôka, Herod pâla mi senkhatngei leh an intonga, Jisua an that rang lam mintuonangei an sin zoia. ");
INSERT INTO sch_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jisua le a ruoisingei ha Galilee dîl tieng an se kelena, male loko tamtakin ama an jûi sa. Anni ngei ha Galilee ram renga, Judea ram renga, ");
INSERT INTO sch_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem renga, Idumea ram renga, Jordan râl nisuo tieng renga, male Tyre le Sidon khopuilienngei kôlrevêla hong ngei an ni. Hi mingei murdi hih Jisua neinun tho ngei an lei riet sika hong an ni. ");
INSERT INTO sch_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Lokongei an tam rai sika han ama an neng loina rangin Jisua'n a ruoisingei kôm, ama rang rukuong inkhat lei dar rangin chong a be ngeia. ");
INSERT INTO sch_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Mi tamtak a mindama, male ana ngei murdi ama an tôn theina rangin an inbûmlula. ");
INSERT INTO sch_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Male an sûnga ramkhori dôn ngei khomin ama an mu racham inbokin, “Nangma ha Pathien Nâipasal ni ni!” tiin an iniek ngâi. ");
INSERT INTO sch_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jisua'n ramkhoringei kôm han, tumo ani ha tute kôm an misîr loina rangin chongnazatin, chong a pêk ngei zoi. ");
INSERT INTO sch_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Hanchu Jisua muol chunga a kala, ama'n a nuom ngei kai a koia. Anni ngei ha an jûia, ");
INSERT INTO sch_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","male sômleinik ngei a thanga, “Mangei ha tîrtonngei tiin riming a phuoa, an kôm, ko kôma om rangin nangni ka thang zoi ani,” male, “Thurchi misîr rang khomin nangni tîr suok ka ta, ");
INSERT INTO sch_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","male ramkhoringei rujûlpai theina rachamneina khom dôn nin tih,” tiin a ril ngeia. ");
INSERT INTO sch_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Sômleinik a thang ngei ha hi ngei hih an ni: Simon (Jisua'n, Peter tia riming a phuo pe ha); ");
INSERT INTO sch_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedee nâipasal Jacob le a nâipa John (Jisua'n, Boanerges tia riming a phuo pe ngei ha, maha aomtie chu “Khuonri Miriemngei tina ani”); ");
INSERT INTO sch_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrew, Philip, Bartholomew, Matthew, Thomas, Alphaeus nâipasal Jacob, Thaddeaus, Canan mi Simon (an ram lungkham le inpâkpui ngâipu,) ");
INSERT INTO sch_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","male a minsûrpu Judas Iscariot. ");
INSERT INTO sch_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Hanchu Jisua ha in tieng a kîr sir zoia. Lokongei hah an juong intûp nôka, Jisua le a ruoisingei ha sâknêk zora luo man mak ngeia. ");
INSERT INTO sch_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Mingeiin, “Achâng ke ani zoi!” an ti roi ha a insungmingei an riet lehan, ama tuong rangin an inthoka. ");
INSERT INTO sch_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Balam minchupu senkhat Jerusalem renga juong ngei han, “A sûnga Beelzebul a dôn ani! Ramkhoringei ulientak kêng, ramkhori rujûlpai theina rangin sinthotheina a kôma pêk ngâi” an tia. ");
INSERT INTO sch_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Masikin Jisua'n anni hah a koia, chongmintêkin a chongpui ngeia; “Kho angin mo Soitan'n Soitan a rujûl thei ranga? ");
INSERT INTO sch_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Rambung khom athenin apâlin insenin inkhat le inkhat an indoi inlômin chu, ma rambung hah inlet atih. ");
INSERT INTO sch_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Insûngkuo khom athenin apâlin insenin inkhat le inkhat an indoi inlômin chu, ma insûngkuo hah inlet atih. ");
INSERT INTO sch_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Masikin Soitan rêngram khom athenin apâlin an insenin chu, ma hah asôt dier no nia, inlet a ta male ânmang rang ani. ");
INSERT INTO sch_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Tutên mi rât ina lûtin a neinunngei lâk pe thei ngâi mak ngei, mi rât hah an khitbel masa vaiin ke; a neinunngei an muruk thei ngâi. ");
INSERT INTO sch_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Adiktakin nangni ki ril mingei hih an sietnangei murdi le asaloi neinunngei an ti ngei murdi chu la ngâidam thei nîng a ta. ");
INSERT INTO sch_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Aniatachu tukhom Ratha Inthieng doia asaloi neinunngei a ti ngei hah chu ngâidamin om tet no ni, kumtuonga sietna a sin ani sikin” a tia. ");
INSERT INTO sch_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(Mahi Jisua'n mingei senkhatin, “Ratha saloi a dôn” an ti sika a ti ani.) ");
INSERT INTO sch_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Hanchu Jisua nû le lâibungngei an hongtunga. Khalâia an indinga, ama koi rangin mi an tîra. ");
INSERT INTO sch_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jisua rihîlin lokongei an insunga, male ha ngei han a kôm, “En roh, Nu nû le na lâibungngei le na sarnungeiin nang an roka, khalâia son an oma, nang intongpui rang an nuom,” an tipea. ");
INSERT INTO sch_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jisua'n an kôm, “Tu mo ku nû? Tu ngei mo ka lâibungngei?” Tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","A rihîla an sung ngei hah a en ngeia, an kôm, “En ngei roi! Hi ngei hih ku nû le ka lâibungngei an ni! ");
INSERT INTO sch_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tukhom Pathien nuom lama sintho ngei kai chu ka lâibungngei, ka sarnungei, le ku nûngei an ni” a tia. ");
INSERT INTO sch_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Galilee dîl kôla Jisua'n a minchu nôka, mipuingei a kôma juong intûp ngei hah an tam rai sikin rukuonga a chuonga, ânsunga, mipuingei hah chu tui rakham asortea tânga han an indinga. ");
INSERT INTO sch_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Anni ngei minchuna rangin chongmintêkngei mangin neinun tamtak ngei a misîr pe ngeia, an kôm han: ");
INSERT INTO sch_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Rangâi roi! voikhat chu mi inkhatin burît rangin a sea. ");
INSERT INTO sch_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Loia han sachi a rethea, senkhat lampui kôla achula, vângei an honga male an sâk ripa. ");
INSERT INTO sch_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Senkhat lungpherpha pil ânphâna chunga achula, pil ânphân sikin ahong mông kelena, ");
INSERT INTO sch_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Hanchu, nisa ahong insângin chu akung innoinar ngei ha a em minjuota, aruzung amathâk hah ânthûk loi sikin akângrip kelena. ");
INSERT INTO sch_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Senkhat chu riling kâra achula, riling han akungngei ha adîpa, male inra thei khâi mak ngei. ");
INSERT INTO sch_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Aniatachu senkhat chu pil sana achula, akungngei ahong kêia, ahong insôna, avûia: senkhat sômthumin, senkhat sômrukin, male senkhat raza khatin ahong pung zoi” a tia. ");
INSERT INTO sch_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Male Jisua'n a chongkharnân an kôm “Kuor nin dônin chu rangâi roi!” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jisua athenin aom lehan, a ruoisingei sômleinik le midang senkhat ngei ma chong riet ngei han a kôm an honga male ha chongmintêkngei hah rilminthâr pe ngei rangin an ngêna. ");
INSERT INTO sch_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jisua'n an kôm, “Pathien Rêngram chonginthup riettheina nin kôm pêk ani zoi.” Hannirese, “Midangngei pêntienga omngei rangin chu, neinunngei murdi chongmintêkngei vaiin misîr pe an nia, ");
INSERT INTO sch_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Masikin an en, an en khomin an mu loina rangin le; an rangâi an rangâi khomin, an rietthei loina rangin. Ma anghan an thôn chu, Pathien tieng inhei nôk an ta, male ama'n lei ngâidam ngei thei atih’” a tia. ");
INSERT INTO sch_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Hanchu Jisua'n an kôm, “Hi chongmintêk hih nin rietthei loi mo? Hanchu, kho angin mo chongmintêk dangngei ngân khom nin rietthei ranga? ");
INSERT INTO sch_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Sachirethêpa han Pathien chong a rethe ngâi. ");
INSERT INTO sch_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mi senkhat ngei chu, sachi lampui kôla chul angin an nia; chong hah an riet harenghan, Soitan a honga an mulungrîla om hah a lâk pe ngei ngâi. ");
INSERT INTO sch_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Midang senkhat ngei chu sachi lungpherpha chunga chul angin an ni. Thurchi hah an riet harenghan, râisântakin an pom kelen ngâia. ");
INSERT INTO sch_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Hannirese, ruzung inthûk an mathâk loi sikin om sôt ngâi maka. Thurchi sika intakna mini nuomlona mini, ahong om lehan chu anin let nôk kelen ngâi. ");
INSERT INTO sch_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mi senkhat ngei chu sachi riling kâra achul angin an ni. Ma ngei hah chu thurchi rangâipu ngei hah an nia, ");
INSERT INTO sch_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","aniatachu an ringnuna kângdoinangei, rammuol hoina le neinangei le jât dadang an ôinangei ahong lûta chong hah adîpa, amara musuo ngâi mak. ");
INSERT INTO sch_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Hannirese mi senkhat ngei chu pil asana achul ngei angin an ni. Chong hah an rieta, an poma, male ânra ngâi: senkhat sômthumin, senkhat sômrukin, senkhat raza khatin an hong pung zoi, a tia.” ");
INSERT INTO sch_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisua'n a chong a la zombanga, “Tumo châti hongchôia adarna muna dar loiin, bêl nuoia mo, aninônchu jâlmun nuoia mini a dar ngâia? adarna munna ke an va dar ngâi nimak mo? ");
INSERT INTO sch_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ânthup murdi tâng la musuo nîng a ta, hîpa om ngei murdi lîkpai la nîng atih. ");
INSERT INTO sch_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Hanchu, kuor nin dônin chu rangâi roi!” a tia. ");
INSERT INTO sch_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Hanchu Jisua nanâkin an kôm, “Nin chong rangâi hih asadimin mindon roi! Midangngei nin jêkna balamngei nanâk hah Pathien'n nangni jêkna rangin mang a tih, manêkin nangni min rik pe uol a tih. ");
INSERT INTO sch_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tu tukhom imini dônpu ngei chu bôk pêk sa nîng a ta, male tukhom ite dôn loi ngei chu an dôn viette khom ha lâk pe rip nîng atih,” a tia. ");
INSERT INTO sch_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jisua'n thurchi a la misîr banga, an kôm, “Pathien Rêngram chu hi anghin ani.” Mi inkhatin a loia chimu a rethea. ");
INSERT INTO sch_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Hanchu a sea, a van ngama jânna a inna, ânthoia sûn ngei ha a va manga, a riet loi kârin chimu hah ahong kêia, ahong insôn zoia. ");
INSERT INTO sch_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Pil ha athenin akungngei hah aminsôna, amara amin dôna; amotona akung ahong inlang ngâi, hanchu avûia, male anûktaka aramala sip buvûi ahong oma. ");
INSERT INTO sch_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Bu hah amin tena chu, ha mi han ât zora ahong tung zoi sikin a kôite lâkin bu ât aphut ngâi anghan ani, a tia. ");
INSERT INTO sch_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jisua'n an kôm, “Pathien Rêngram hih imo a-ang ei ti rang ân zoi? Khoi chongmintêk mangin mo ei rilminthâr rang ani zoi? ");
INSERT INTO sch_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mi inkhatin ancham ru rammuola chimu murdi lâia achîntak ramal khat a lâka, pila a tua. ");
INSERT INTO sch_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Chomolte suole chu ahong mônga, chimu murdi lâia alientak ahongni ngâi. Machang lientak ngei ahong dôna, male vângei an honga male adâilîm han rubungei an phana mahan an riek thei ang ha ani” a tia. ");
INSERT INTO sch_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ma anghin Jisua'n mingei kôm han chongmintêk tamtak mangin, an rietthei rang do-dôrin a thurchi a misîr pe ngei ngâia. ");
INSERT INTO sch_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Chongmintêk niloiin chu an kôm, thurchi misîr ngâi maka; hannirese, a ruoisingei leh vai an om zorân chu jâttin a rilminthâr pe ngei ngâi ani. ");
INSERT INTO sch_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mani nanâka han kholoi ahongnin chu Jisua'n a ruoisingei kôm, “Dîl râl tieng son vân kân ei ti u” a tia. ");
INSERT INTO sch_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Masikin lokongei ha an mâka; Jisua a lei insungna rukuonga han ruoisingei hah an lûta, ama khom an tuonga. Mahan rukuong dangngei khom an om sa. ");
INSERT INTO sch_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Inningloi rengin phâivuopui râttak ahong thoa, tuidârinsok khom hah rukuonga a lûta asip vâng zoia. ");
INSERT INTO sch_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jisua chu lukham khamin rukuong remei tienga han a lei ina. Ruoisingei han an kaithoia male a kôm, “Minchupu kin thi rang ani zoi, itên ni mindon loi mini?” an tia. ");
INSERT INTO sch_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jisua ânthoia, phâivuopui hah a ngoa, “Mong roh!” male tuidârinsok kôm han, “Omchien roh!” a tia. Phâivuopui hah amonga, male adâingang zoi. ");
INSERT INTO sch_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Hanchu Jisua'n a ruoisingei kôm “Ithomo ma angtaka nin chi hi? Taksônna reng nin la dônloi mo?” a tia. ");
INSERT INTO sch_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Aniatachu an chi sabaka, male inkhat le inkhat kôm, “Hi mi hih tumo ani hi? Phâivuopui le tuidârinsok tena khomin a chong an don hi?” anin ti inlôma. ");
INSERT INTO sch_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jisua le a ruoisingei hah Galilee dîl râl kângkhat tieng, Gerasa ram an hong tunga. ");
INSERT INTO sch_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jisua hah rukuong renga a hong jôk harenghan, mahan thânngei renga hong suok mi inkhatin ântôngpuia. Ha mi hah a sûnga ratha saloi dôn ania ");
INSERT INTO sch_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","male thânngeia om ngâi ani. Tutên Zingjirûi lienpa leh luo khit thei mak ngeia; ");
INSERT INTO sch_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Vêl tamtak a kutngei le a kengei an lei khita, aniatachu a kengei an khitna Zingjirûingei le thîrkolngei hah a pot sata, a khiek chit ngâia. A rât rai sikin tutên an mene theiloi ani. ");
INSERT INTO sch_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Sûna le jâna, thânngeia le tângngeia han ân ieka, amananâkin lungngei leh an ât ngâi. ");
INSERT INTO sch_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Alazan renga Jisua a hong mua; masikin a hong tânna, amakunga ânboka, ");
INSERT INTO sch_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","male rôl inringtakin ân ieka, “Jisua, Pathien Ânchung Tak Nâipasal, khoimo mi lo rang ni ti? Dûk mi tho tet loi rangin, Pathien rimingin nang ke ngên!” a tia. ");
INSERT INTO sch_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(Mahi a tina abi chu Jisua'n, a kôm, “Ratha saloi amapa sûng renga hih hong jôk roh!” a lei ti zoi sika ani.) ");
INSERT INTO sch_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Masikin Jisua'n a kôm, “Imo ni riming!” tiin arkela. A kôm han, “Ki riming chu ‘Mob’ kin tam sabak ani” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Male ha ram renga hah ratha saloingei a rujûlpai loina rangin Jisua kôm han a ngênrîta. ");
INSERT INTO sch_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ma mun kôla muol panga han vok pâl tamtak sâk rok an oma. ");
INSERT INTO sch_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Masikin ratha saloingei han, “Vokngei kôm son mi tîr inla, male an sûnga mi min lût roh” tiin Jisua kôm an ngêna. ");
INSERT INTO sch_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","A min se ngeia, male ratha saloingei hah amapa sûng renga an jôk paia, vokngei sûnga han an va lûta. Vokpâlngei hah anrêngin isângnik dôr an nia, anrêngin rôlsora an tânna, dîla an inchôma, an thi let zoi. ");
INSERT INTO sch_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Vok donsûipungei hah an tânna, khopui le vokvâinamun ngeia han ma thurchi hah an va misîra. Mingei han neinun ahongtung ha en rangin an se zoia, ");
INSERT INTO sch_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","male Jisua kôm an tung lehan, ramkhoringei an sûrpu hah puon silin mulungbôk sing vanga insungin an va mua; male anrêngin an chi zoi. ");
INSERT INTO sch_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Amupu ngei han ramkhori sûrpa chunga neinun ahongtung le vokngei chungroi ha mingei an lei rila. ");
INSERT INTO sch_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Masikin anni ngei han Jisua hah an ram mâk rangin an ngên zoia. ");
INSERT INTO sch_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jisua rukuonga a chuong rangtôn ramkhoringei sûrpa han Jisua kôm, “No kôm hong rong ba!” tiin a ngêna. ");
INSERT INTO sch_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Hannirese Jisua'n phal maka. Manêkin, “Ni insûngmingei kôm senla, Pumapa'n sin nang a tho pe tie le idôrmo nang lungkham tie hih va ril ngei roh” a tipea. ");
INSERT INTO sch_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Masikin amapa hah a sea, Khopui Sôm ngei han a chaia, Jisua'n ata ranga sin a tho pe ngei hah a misîra, ha a misîr a riet ngei murdi'n kamâmruoi sabak an tia. ");
INSERT INTO sch_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisua'n rukuong leh dîl râl kângkhat tieng rakânin a se nôka, dîl panga loko tamtak a kôm an hong intûpa. ");
INSERT INTO sch_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Synagog taka ulienpu a riming Jairus a hongtunga, male Jisua a mu lehan, Jisua ke kunga ânboka, a kôm, ");
INSERT INTO sch_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","male “Ka nâinupangte hih ana sabaka. Masikin rangâihoitakin juong inla, a hong dam nôka a ring theina rangin a chunga nu kutngei ni juong minngam pe roh!” tiin a ngênrîta. ");
INSERT INTO sch_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Hanchu Jisua hah ama lehan an sea. Loko tamtakin an jûia, an ep rai sikin an innengin an innenga. ");
INSERT INTO sch_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mahan nuvengte inkhat kum sômleinik thisuoka damloi a oma, ");
INSERT INTO sch_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","doctorngei tamtakin an donsûi suonûk khomin la dam thei maka. A sum dôn murdi a heklet zoia, hannirese dam nêkin inrikin ânrik pe uola. ");
INSERT INTO sch_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Hanu han Jisua chungroi a rieta, masikin lokongei kâra Jisua nûka a honga, ");
INSERT INTO sch_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","a mulungrîlin, “A puonngei luo khom tôn inlang, dam kelen ki tih” a tia. ");
INSERT INTO sch_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Amanu han a puonmor a tôna, male a thisuok ha harenghan among pita; a natna hah mindam ani zoi tiin, ânriet kelen zoia. ");
INSERT INTO sch_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jisua'n a sûng renga sinthotheina ajôk ti a riet kelena, masikin lokongei tieng a hônheia, an kôm, “Tumo ku puonngei a tôn?” Tiin a rekel ngeia. ");
INSERT INTO sch_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","A ruoisingeiin a kôm, “Lokongeiin madôr nang an neng hih nu mu nimak mo; itho mo tumo ku puon a tôn ni ti hih?” an tipea. ");
INSERT INTO sch_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Hannirese Jisua'n chu a puon tônpu mu rangin a en titira. ");
INSERT INTO sch_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","nuvengtenu han a chunga neinun ahongtung hah ânrietin chu, chi leh innîk pumin a honga, a ke kunga khûkinbilin, male a thurchi hah adiktakin a ril leta. ");
INSERT INTO sch_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jisua'n a kôm, “Ka nâinupang, na taksônnân nang amindam zoi, rathânngamtakin senla, na natna renga hong damriem ta roh,” a tipea. ");
INSERT INTO sch_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jisua ala chonglâitakin, thangtheipungei senkhat Jairus in renga an honga, Jairus kôm, “Na nâinupang chu athi suo zoi, ithomo Minchupu na la minjêl banga?” an tia. ");
INSERT INTO sch_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jisua'n chu an chong hah lunghâng tho maka, Jairus kôm han, “Chi nônla, iem ngit roh” a tipea. ");
INSERT INTO sch_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Hanchu Peter, Jacob le a nâipa John telloin chu tute ama jûi rangin phal maka. ");
INSERT INTO sch_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jairus ina an va tungin chu, Jisua'n rahang râttaka chap ngei le an ieka, ânrum ngei hah a va mu ngeia. ");
INSERT INTO sch_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","In sûnga a lûta, an kôm, “Itho mo nin chapa? Ithomo nin inngûia? Hi nupangte hi athi nimaka a in kêng ani!” a tia. ");
INSERT INTO sch_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Anni han ama an munuisana, masikin an rêngin a nottuor ngei leta, nupangte a nû le a pa male a ruoisi inthum ngei leh nupangte jâlna khâltana han an lûta. ");
INSERT INTO sch_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nupangte kut hah a sûra male a kôm, “Talitha koum” a tia, maha, “Nupangte, inthoi roh nang ki ti!” tina ani. ");
INSERT INTO sch_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Hanchu, ha nupangte hah harenghan a hong inthoia, a lôn thei kelen zoia. (Amanu hah kum sômleinik nupangte ani.) Ha anghan ahongni lehan, an kamâm sabaka. ");
INSERT INTO sch_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Aniatachu Jisua'n tute ril tet loi rangin chongpêk inngartak a pêk ngeia, male “An kôm han a sâk rang imakhat pêk roi,” a tia. ");
INSERT INTO sch_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisua'n ha mun hah a mâka, a omna ngâi khopui tieng a se nôka, a ruoisingei khomin an jûi tita. ");
INSERT INTO sch_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabbathnin chu Synagog taka mi a minchua. Mahan mi tamtak an oma; male a chongril hah an riet lehan anrêngin kamâm aom tatak an tia, “Hi mi hin hi ngei nâm hih kho renga mo a man hi?” an tia. “A kôm, khoi vârna mo pêkin aom hih? Kho angin mo sininkhêlngei a sin thei hi? ");
INSERT INTO sch_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Mary nâipasal, mistri sin ngâi, a lâibungngei khom Jacob, Joseph, Juda le Simon ngei nimak mo? A sarnungei khom ei kôma an om ngâi nimak ngei mo?” an tia. Male chu ama hah an hengpai zoia. ");
INSERT INTO sch_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jisua'n an kôm, “Dêipungei chu an omna ngâi khopui le a sûngsuokngei le a insûngmingei lâia tiloiin chu muntina an jâ ngei ngâi a tia.” ");
INSERT INTO sch_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ha muna han chu mi damloi ngei tômte chunga a kutngei minngamin a mindam tiloiin chu ite sininkhêlngei sin thei khâi mak. ");
INSERT INTO sch_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Mingei han taksônna an dôn loi sikin a jâmminzal sabaka. Hanchu Jisua'n ha revêla khuongei han a chai titira, mingei ha a minchu tira. ");
INSERT INTO sch_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ruoisi sômleinik ngei hah a koi mintûp ngeia inik, inikin a tîrsuoka. Ratha saloingei chunga rachamneina a pêk ngeia, ");
INSERT INTO sch_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","male an kôm, “Nin khuolchaina khiengrol tiloiin chu ite vâipôl khom, kutdo choli khom, nin pepngeia sum khom chôi no roi. ");
INSERT INTO sch_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kebunngei chu bun ungla, hannirese, kâncholi inshak chu chôi no roi” tiin chong a pêk ngeia. ");
INSERT INTO sch_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Amananâkin an kôm, “Nangni an lei modômna ina han om ungla ma mun hah nin mâk, mâka chu madên han om tit roi. ");
INSERT INTO sch_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Hanchu tu khopui khom mingeiin nangni an modôm noa, nin chong an rangâi nônchu mâkrak ungla, nin ke rabab akop ngei hah không liei roi. Maha anni rangin inning roi tina nîng atih.” ");
INSERT INTO sch_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Masikin an sea, male mingeiin an sietnangei renga an insîr theina rangin thurchi an misîra. ");
INSERT INTO sch_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ramkhoringei tamtak an rujûl pâia, male damloi tamtak ngei olive sariek an pola an mindam ngei zoi. ");
INSERT INTO sch_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Hanchu Jisua riming muntina ânthang zit zoi sikin Rêng Herod'n a lei rieta. Mingei senkhatin chu, “Baptispu John hah a hong ring nôk zoi! Masika han hi sininkhêlngei sin theina ranak hi a dôn ani,” an tia. ");
INSERT INTO sch_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nikhomrese, adangngeiin chu, “Ama hih Elijah ani” an tia. Midangngei an ti nôk chu “Tiena dêipungei angin, ama hih dêipu inkhat ani” an tia. ");
INSERT INTO sch_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mahah a lei rieta, Herod'n chu, Baptispu John ani! “A lu ka tana nikhomrese, a hong ring nôk ani!” a tia. ");
INSERT INTO sch_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herod lelên John hah a minsûra, khitbelin jêl ina a lei khum ani. Herod'n ma anga a thona chu, Herodias hi a nâipa Philip lômnu nikhomsenla a lômnu a minchang sika ani. ");
INSERT INTO sch_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","John'n Herod kôm, “Na nâipa lômnu in ne neipui nôk hih Balam nimak!” tiin a lei ril tit ngâia. ");
INSERT INTO sch_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Masikin Herodias han John a mumâka that ngêt rang a bôka hannirese, Herod sikin that thei maka. ");
INSERT INTO sch_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herod'n John hah mi sa le mi inthieng ani ti a riet sikin a chia, masikin a mojôk ngâi ani. John chongril a riet racham asân injêlpui ngâi khomsenla, a chongril rangâi rang a nuom ngâi ani. ");
INSERT INTO sch_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Azoinataka chu Herod suokni ahong tungin chu, sorkar ulienngei, râlmi ulienngei le Galilee rama mi lienngei rangin bukhalâi otna a minsûka, ha ni han chu Herodias'n chuminrên a mana. ");
INSERT INTO sch_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodias nâinupang a hong lûta, a lâma, Herod le a khuolmingei râiaminsân pe ngei oka. Masikin rêngpa han nupangte kôm han, “Imo dôn rang nu nuom? Nu nuom tak nang pêk ki tih” a tia. ");
INSERT INTO sch_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Chonginkhâm tamtak dônin a kôm, “Kho khoi khom mi ni zong kai chu ke rêngram phalkhat tena khom nang pêk rangin chong kên khâm!” a tia. ");
INSERT INTO sch_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Masikin nupangte hah a jôka, a nû kôm, “Imo mo ko zong rang?” tiin a va rekela. A nu'n, “Baptispu John lu” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nupangte hah innottakin a kîra, rêngpa kôm han, “Atûn Baptispu John a lu mâirânga mi ni pêk rangin ku nuom” tiin a zonga. ");
INSERT INTO sch_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Masikin rêngpa hah ân ngûikhak zoia, aniatachu a khuolmingei makunga inkhâmnangei a lei tho sika han mângti thei khâi maka. ");
INSERT INTO sch_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Masikin rêngpa han a rungpu inkhat a tîr kelena, John lu hong lâk rangin chong a pêka. Rungpu han ânphêt kelena, male jêl ina a sea. John lu ava tana; ");
INSERT INTO sch_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","hanchu mâirânga a hong chôia, nupangte kôm a pêka, nupangte han a nû kôm ava pêk zoia. ");
INSERT INTO sch_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ma roi hah a ruoisingeiin an riet lehan an honga, John ruok hah an chôia, male an phûm zoi. ");
INSERT INTO sch_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tîrtonngei hah an kîr nôka male Jisua an intongpuia, male an sintho murdi le an minchu sai murdi Jisua kôm an rila. ");
INSERT INTO sch_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Mingei ha ase le ahong an tam rai sikin Jisua le a ruoisingei chu bunêk zora luo man mak ngeia. Masikin an kôm, “Tho ei theivaia ei om theina rangin mun senkhata chomola nin inngam theina rang muna se rei u” a tia. ");
INSERT INTO sch_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Masikin mun inthimngangna panin an theiviekin rukuonga an se zoia. ");
INSERT INTO sch_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nikhomrese, mingei tamtakin an selâi an mua, anni ngei ti an riet kelena; masikin khopuingei murdi renga mingei hah tâng tieng renga an tânna, Jisua le a ruoisingei hah an lei chomtan ngeia. ");
INSERT INTO sch_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jisua hah rukuong renga a juong chum lehan, loko tamtak a mu ngeia, male belri a hôlpu boi angin an ni sikin, anni ngei rangin a mulungrîla inriengmuna leh asipa. Masikin neinun tamtak ngei a minchu ngei phut zoi. ");
INSERT INTO sch_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kholoi ahongni lehan, a ruoisingei hah Jisua kôm an honga, male a kôm, “Mahi mun inthimngang ke ania, nisa khom ase ok zoia. ");
INSERT INTO sch_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mingei hih tîr pai ngei inla, male akôl kienga loingeia mo, khuongeia mo, anninanâkin an sâkruo imakhat an rochôk theina rangin” an tia. ");
INSERT INTO sch_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jisua'n an kôm, “Nangnin sâkruo imakhat pêk ngei roi,” tiin a thuon ngeia. Annin a kôm, “Anni ngei vâi theina rangin vâipôl chunga duli razannik kin va thâm rangin nu nuom mo?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Masikin Jisua'n an kôm, “Vâipôl kho dôr mo nin dôn? Se ungla, va en roi” tiin a rekel ngeia. An dôn dôr hah an riet lehan, “Vâipôl rangnga le nga inik” tiin an rila. ");
INSERT INTO sch_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Hanchu Jisua'n mingei nâm hah apâl apâlin sensâi ungla, durba chunga min sung ngei rangin ruoisingei a ril ngeia. ");
INSERT INTO sch_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Masikin mingei hah apâl apâlin, raza khat pâlin le sômrangnga pâlin an min sung ngeia. ");
INSERT INTO sch_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Hanchu Jisua'n vâipôl rangnga ngei le nga inik hah a lâka, invân tieng tangin Pathien kôm râisânchong a rila. Vâipôl hah a khoia, mingei hah sem pe ngei rangin a ruoisingei kuta a pêk ngeia. Nga khom hah anrêngin sem ngei rangin a pêk ngei sa zoi. ");
INSERT INTO sch_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mitinin an sâka male an khop chita. ");
INSERT INTO sch_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Hanchu an sâk minieng vâipôl hâr le nga ronôi hah tabong sômleinik ruoisingeiin an rût min sipa. ");
INSERT INTO sch_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","A vâi ngei mijôn hah mi ulien kai isâng rangnga an ni. ");
INSERT INTO sch_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Lokongei a minchîn suole harenghan varâl tienga Bethsaida khuoa, a motona lei se rangin a ruoisingei rukuonga a min chuong ngeia. ");
INSERT INTO sch_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Mingei hah chonghoiin a mathân suole chu chubaitho rangin muol chunga a se zoia. ");
INSERT INTO sch_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kholoi ahongni lehan, rukuong hah dîl ânlâina taka aoma, Jisua chu atheivaiin tânga han aoma. ");
INSERT INTO sch_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Phâivuo hah anôk tieng asêm sikin, a ruoisingeiin an rukuong jâp hah an mulungjîng okin a mua; masikin jîng kôlinsaluom rangtôn dîl chunga lônin an tieng a hong pana, anni ngei khêlpai rang angin aoma, ");
INSERT INTO sch_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","hannirese anni han tui chunga a lôn an mua. “Mirluoi kêng ani!” tiin an mindonna, male an iniek raka. ");
INSERT INTO sch_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ama an mu lehan an rêngin an rathatâka. Harenghan Jisua'n an kôm, “Hâitakin om roi!” ama'n, “Keima ke ki ni, chi no roi!” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Hanchu an kôm rukuonga han a chuong sa zoia, male phâivuo hah amonga. Ruoisingei chu an kamâm sabaka, ");
INSERT INTO sch_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","mi isâng rangnga a vâina roi aomtie diktak hah an rietthei loi sikin; an mulungbôkngei han amanphâk loi ani. ");
INSERT INTO sch_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Dîl râl an inkânna, Genesaret rama an tunga, mahan an rukuong an thunga. ");
INSERT INTO sch_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Rukuong renga an chuma, mingeiin harenghan Jisua ani ti an riet kelena. ");
INSERT INTO sch_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ha ram pumpuia mingei hah an hong tân leta; a omna an rietna tena a kôm damloingei an jâmphera jâl pumin an hong rojôna. ");
INSERT INTO sch_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Male Jisua a sena muntina, khuongeia mo, khopuingeia mo, loingeia mo, bazar munngeia khom damloingei an hong tuonga, a puonmor luo tôn thei rangin phalna an ngênna. Male a tôn ngei murdi chu an dam pak ani. ");
INSERT INTO sch_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Jerusalem renga hong phariseengei le Balam minchupungei senkhat ngeiin Jisua kôla an hong intûpa. ");
INSERT INTO sch_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ha ngei han a ruoisingei senkhatin kut innima sâk an sâk an mua, maha, Phariseengeiin mingei an tho ranga an tipe lamtaka an rusûk loi sika ani. ");
INSERT INTO sch_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Phariseengei le Judangei murdi'n chu an pipungei renga an man chongmâk hah an jûia: an kutngei, balam takin an rusûk noa anin chu ite sâk ngâi mak ngeia; ");
INSERT INTO sch_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","bazar renga neinun an hong chôi ngei murdi khom an rusûk masa nônchu sâk ngâi mak ngei. Male balam adang tamtak an man ngei hah an sûr mindet tit khom aom sa; ma ngei hah kilâtngei, bêlngei, sumsen khuriâingei, male jâlmunngei rusûk min sâi rang ti ngei ha ani.) ");
INSERT INTO sch_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Masikin phariseengei le Balam minchupungei han Jisua kôm, “Ithomo nu ruoisingeiin pipungei chongmâk jôm loiin kutngei innim pumin sâk an sâk hi?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jisua'n an kôm, “Isaiah'n nin chungroi a leiphuong hah adik ani!” A miziek anghan, asarotholngei nin ni: “Hi mingei hin an chongbâingei leh min minpâka, aniatachu an mulungrîlngei chu keima renga alazan ani. ");
INSERT INTO sch_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Miriem minchuna balamngei hah ka balamngei anghan an mindon sikin chubai min mûkna hih anni rangin kâmnângloi kêng ani, Pathien'n a ti, tia lei inziek anghan!” ");
INSERT INTO sch_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Pathien chongpêk nin henga, miriem minchunangei nin jôm ani hi” a tia. ");
INSERT INTO sch_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Male a la zombanga an kôm, “Nin minchuna nin jôm theina ranga Pathien chongpêkngei nin heng hi chu vârna lampui nin dôn ani hi. ");
INSERT INTO sch_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses'n, ‘Nu nû le na pa jâ roh,’ male ‘Tukhom a nû mo a pa mo khomâksâm chu that ning atih,’ tiin chong a lei pêka. ");
INSERT INTO sch_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Aniatachu nangni rêkin chu, mîn a nû mo, a pa mo imini san rang anângin chu ‘Ma hih Korban ani’ tiin nin minchu ngâi, (maha aomtie chu, Pathien ta ani zoi tina ani), ");
INSERT INTO sch_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","an nû mo an pa ngei rangin mo khoite sintho rangin jôt khâi ngâi mak choia. ");
INSERT INTO sch_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ma angdên han balam muruo nin minchu banga hin Pathien chong amin mang ngâia. Hi anga sin nin tho adang khom tamtak ala om sa” a tia. ");
INSERT INTO sch_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Hanchu Jisua'n lokongei hah vêlkhat a koi nôk ngeia, an kôm, “Nin rêngin ko chong rangâi ungla, male rietthei roi. ");
INSERT INTO sch_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Pêntieng renga miriem sûnga lûta ama minnim thei ite omak. Manêkin miriem sûng renga hong suok ngei hi ke miriem minnim ngâi ani.” ");
INSERT INTO sch_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Lokongei hah mâkin insûnga a lût lehan, ha chong hah rilminthâr rangin a ruoisingeiin an ngênna. ");
INSERT INTO sch_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jisua'n an kôm, “Midangngei nêkin la vâr uol mak chei.” “Ite pêntieng renga nin sûnga lûtin nangni aminnim thei om mak, ti hih nin la rietthei loi mo? a tipe ngeia, ");
INSERT INTO sch_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","asikchu nin mulungrîla lût loiin, nin phûngpuia a lûta, male nin nôm sena tieng ajôk ngâi” a tia. (Ma hih Jisua'n sâkruo murdi chu ânthieng let tia minthârnân a ti ani.) ");
INSERT INTO sch_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Male a la ti banga, “Nin sûng renga hong suok ha ke nangni minnim ngâi. ");
INSERT INTO sch_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Asûng tieng renga, nin mulungrîl renga kêng, mindonna saloi ahong suoka nunchan saloi neinunngei tho rangin nangni ruoi ngâia, inruna, mi thatna, ");
INSERT INTO sch_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","inrêna, inruokna, saloi murdi tho nuomna; huongna, hurna, narsana, êrona, inpâkna, le inmôlna ngei aminsuok ngâi, ");
INSERT INTO sch_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ma saloi neinunngei murdi hah nin sûng tieng renga ahong suoka, male nangni aminnim ngâi ani” a tia. ");
INSERT INTO sch_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Hanchu Jisua'n Galilee ramhuol mâkin Tyre khopuilien kôla a sea. In inkhata a lûta, tutên an riet rang khom jôt maka, aniatachu ama hah inthupin om thei maka. ");
INSERT INTO sch_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nuvengte inkhat, a nâinupang a sûnga ratha saloi dôn han, Jisua thurchi a riet lehan harenghan a honga a kebula ânboka. ");
INSERT INTO sch_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ma nuvengtenu hah Jentail mi ania, Syria rama Phoenikia ramhuol sûnga suok ania. Amanu han a nâinupang sûnga ramkhori rujûlpai pe rangin Jisua kôm a ngênna. ");
INSERT INTO sch_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Hannirese, Jisua'n a kôm, “Nâingei khop bak rese ngei. Nâingei bu lâk pea male uingei kôma vôr chu dik mak,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nuvengtenu han a kôm, “Pu” ani chu ani, hannirese, “nâingeiin dosâng nuoia bu ramal an mathâk hah uingeiin an sâk ngâi nimak mo!” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Masikin Jisua'n amanu kôm han, “Ma thuona chongbâi sikin, ni ina se nôk inla, na nâinupang chu ramkhori mâkin va mu ni ti zoi!” a tipea. ");
INSERT INTO sch_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Amanu hah a ina a sea, a nâinupang chu ramkhori mâkin jâlmuna jâlin ava mu zoi. ");
INSERT INTO sch_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Hanchu Tyre ram renga Jisua a jôk nôka, Sidon khopui sirin Khopui sôm ngei ramhuol hah palin Galilee dîl a tunga. ");
INSERT INTO sch_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mi senkhatin kuorsêt le chongloi a kôm an hong tuonga. Amapa chunga han a kutngei minngam rangin Jisua an ngênna. ");
INSERT INTO sch_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Masikin amapa hah Jisua'n lokongei lâi renga atheivaiin a tuonga, a kutruolngei leh a kuor sûng ngei hah a tôn pea, a michil pea, a melei khom a tôn pea. ");
INSERT INTO sch_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Hanchu Jisua'n invân tieng enin phûkasâna ânhûmma, a kôm, “Ephatha” a tia, mahah “In-ong roh!” tina ani. ");
INSERT INTO sch_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Harenghan, a kuorngei a hongvâra, a melei inkhitna ngei ahong insûta, ânthar vangin a chong thei zoi. ");
INSERT INTO sch_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Hanchu Jisua'n mingei kôm han tute ril tet loi rangin chong a pêk ngeia; hannirese misîr loi ranga a khap ngei dôr hah an ril minlum uola. ");
INSERT INTO sch_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Male ariet ngei murdi'n kamâmruoi sabak an tia, “Neinuntin a sin murdi hih idôra asa mo ani zoi!” anni han, “Kuorsêt khom a minvâr pea, chongloi khom a min chong thei hi, kamâm aom bah!” an tia. ");
INSERT INTO sch_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Chomolte suole chu loko dang tamtak an hong intûp nôka. Ite an sâk rang an dônloi sikin Jisua'n a ruoisingei a koia, an kôm, ");
INSERT INTO sch_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Hi mingei hih ko kôm sûnthum an om zoia, male atûn hin ite sâk rang an dôn khâiloi sikin lungkham ku mu ngei tataka. ");
INSERT INTO sch_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Bungêiin an ina ki min se ngei lakin lamlâia chamsôlinvei an ta, senkhat vâng chu an hongna alazan ani sikin” a tia. ");
INSERT INTO sch_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","A ruoisingeiin a kôm, “Hi ramchâra hin hi mingei vâina rangin tumo sâk an hun rang dôr aman zoi ranga?” an tipea. ");
INSERT INTO sch_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jisua'n, “Vâipôl kho dôr mo nin dôn?” tiin a rekel ngeia. Anni han “Vâipôl tâp sari” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ama han lokongei hah pila insung rangin chong a pêk ngeia. Hanchu vâipôl tâp sari hah a lâka Pathien kôm râisânchong a rila, a khoia, lokongei sem pe rangin a ruoisingei kôm a pêk ngeia; male a ruoisingeiin an sema. ");
INSERT INTO sch_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nga chînte atômte khom an dôn sa. Jisua'n ma chunga han khom râisânchong a ril nôka, male sem pe ngei rangin a ruoisingei kôm a pêk sa zoi. ");
INSERT INTO sch_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Mitinin an khop dodôrin an sâka, asâk ngei ha mi isâng minli dôr an ni. Hanchu an sâk minieng arnôingei hah tabong sari an la rût min sipa. Jisua'n mingei ha a tîr pai ngeia ");
INSERT INTO sch_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","male a ruoisingei leh rukuonga an chuong kelena Dalmanutha ramhuola an se zoi. ");
INSERT INTO sch_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pharisee senkhat ngei Jisua kôm an honga, an inkhalpuia. Ama min ôk rang an nuoma, masikin Pathien'n ama a pom ti minlangna rangin sininkhêl min mu ngei rangin an ngêna. ");
INSERT INTO sch_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Hannirese Jisua'n a mulungrîl sûnga a chapa, “Ithomo atûnlai mingei hin sininkhêl an ngên hi? Nimak, nangni ki ril! Atûnlai mingei kôm hin ma anga riet theina reng hi pêk ni no nih!” a tia. ");
INSERT INTO sch_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Anni hah a mâka, rukuonga a chuong nôka, male dîl varâl tieng ân kân zoi. ");
INSERT INTO sch_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ruoisingei han vâipôl an hun rang dôr chôi rangin an mingila male rukuonga han vâipôl tâp khat vai an dôna. ");
INSERT INTO sch_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jisua'n, “Singthei roi,” male “Phariseengei le Herod chol renga indîn roi” tiin inningna a pêk ngeia. ");
INSERT INTO sch_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Anninanâk han, “Vâipôl ei dôn loi sika, mahi a ti kêng ani rang,” tiin an lâia an injêk khôm phut zoia. ");
INSERT INTO sch_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jisua'n an ti hah a lei rieta, an kôm, “Ithomo vâipôl nin dônloi roi nin injêk khôma? Nin la rietthei tet loi mini? Nin mulungbôkngei ânmôl sabak zoi mini? ");
INSERT INTO sch_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mitngei nin dôn chakin nin mu thei loi mini? Kuorngei nin dôn chakin nin riet thei loi mini? Nin riettit khâiloi mini ");
INSERT INTO sch_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","mipui isâng rangnga ngei ta rangin vâipôl tâp rangnga ko khoi lâi ha? An sâk minieng vâipôl ronôingei tabong izet mo nin rût minsip ha?” tiin a rekel ngeia. “Tabong sômleinik” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Male Jisua'n an kôm, “Mipui isâng minli ngei ta rangin vâipôl tâp sari ko khoi lâihan,” an sâk “minieng vâipôl ronôingei hah tabong izet mo nin rût minsip ha?” tiin a rekel ngei nôka. “Tabong sari” tiin an thuon nôka. ");
INSERT INTO sch_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Male ama'n “Atûn ten nin la rietthei loi mo?” tiin a rekel ngeia. ");
INSERT INTO sch_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Bethsaida taka an hong tunga, mahan mingei senkhatin Jisua kôm mi mitcho an hong tuonga, male a tôn pe ngei rangin an ngênna. ");
INSERT INTO sch_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jisua'n mitchopa kut hah a sûra, khuo pêntieng a se puia. A mitngei a michil pe suole chu, Jisua'n a chunga a kutngei a minngama male a kôm, “Nu mu thei mo ni zoi?” tiin a rekela. ");
INSERT INTO sch_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ha mi hah a tanga, “O, miriemngei chu ku mua, hannirese, thingkungngei an lôn titir anghan ke ku mu” a tia. ");
INSERT INTO sch_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jisua'n mitchopa mitngei han a kutngei a minngam nôka. Ma zora han chu mitchopa han a en ngita, a mitngei ahong vâr zoia, male jâttin a mu minthâr thei let zoi. ");
INSERT INTO sch_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Hanchu Jisua'n, “Khuo sûnga hin lût khâi no roh” tiin chong a bêa, in tieng a tîr zoi. ");
INSERT INTO sch_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Hanchu Jisua le a ruoisingei hah an jôka, Caesarea Philipi kôla khuongeia han an sea. Lampuia han an kôm, “Mi ril roi, mingeiin tumo ani min ti?” tiin a rekel ngeia. ");
INSERT INTO sch_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Anni han, “Senkhatin chu Baptispu John ani,” male “midangngei chu Elijah ani, senkhatngei nôkin chu dêipu inkhatlam ani” nang an ti, tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Hanchu, an kôm han, “Nangni rêkte tumo ani mi nin ti?” tiin a rekel ngeia. Peter'n a kôm, “Messiah ni ni” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Hanchu Jisua'n an kôm han, “Ku chungroi hih tute kôm ril no roi” tiin chong a pêk ngei zoi. ");
INSERT INTO sch_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Hanchu Jisua'n a ruoisingei a minchu ngeia, an kôm, “Miriem Nâipasal hi la tuong sabak ngêt a ta, upangei, ochaisingei le Balam minchupungeiin hengpai an tih. That an ta, aniatachu sûnthum suole chu aringin inthoinôk atih,” a tia. ");
INSERT INTO sch_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ma roi hih ânthârvangin a ril ngeia. Masikin Peter'n ama hah athenin a tuonga, a ngoa. ");
INSERT INTO sch_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Hannirese Jisua'n ânheia, a ruoisingei tieng a ena, male “Soitan, keima renga rotpai roh,” ama'n, “Ni mindonngei hih Pathien renga niloiin miriem nina renga ke ani,” tiin Peter a ngoa. ");
INSERT INTO sch_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Hanchu Jisua'n lokongei le a ruoisingei a koia, an kôm, “Tutu khom mi jûi a nuomin chu ama le ama inmingil ngêtin a khros ruputin mi jûi rese. ");
INSERT INTO sch_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tukhom a ringna mojôk a nuomin chu machân a ta; hannirese, tukhom keima sika le thurchisa sika a ringna machân ngei chu mojôk nîng an tih. ");
INSERT INTO sch_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mîn rammuol hih apumin dôn senla, a ringna chu machân senla, ata rangin imo an lâpna aom ranga? Mangmunboi ani! ");
INSERT INTO sch_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mîn a ringna a man nôkna rangin ite a pêk thei rang om mak. ");
INSERT INTO sch_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tukhomin atûnlâi nikhuo saloi le pathienboi mingei kôma keima le ki minchuna chong inzakpui chu, Miriem Nâipasal a Pa roiinpuina insila a vântîrton inthieng ngei leh an juong tika chu ha mi hah inzakpui atih” a tia. ");
INSERT INTO sch_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Male a la ti banga an kôm han, “Nangni ki ril, hi taka om senkhat ngei hih chu Pathien Rêngram hah a sinthotheina leh a juong tung an mu mâka chu thi no ni ngei” a tia. ");
INSERT INTO sch_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sûnruk suole chu Jisua'n Peter, Jacob le John a tuong ngeia, an theivaiin an omna muol insânga han a ruoi ngeia. An mitmu chungchakin Jisua mêl ahong inthûla, ");
INSERT INTO sch_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","male a puonsilngei khom achekin ântêrdapa rammuola mîn tutên madôr ha rusûk minsâi thei no ni ngei. ");
INSERT INTO sch_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Hanchu ruoisi inthum ngei han Elijah le Moses'n Jisua an chongpuilâitak an mua. ");
INSERT INTO sch_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peter'n Jisua kôm, “Minchupu, hi taka om hi ei ta rangin idôra asa mo ni zoi! Puon in inthum sin kin ta nangma rang inkhat, Moses rang inkhat, Elijah rang inkhat sin kin tih” a tia. ");
INSERT INTO sch_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ama le adangngei ha an chi rai sikin a ti rang tak khom riet mak ngeia. ");
INSERT INTO sch_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Hanchu sûmphâi ajuong oma anni ngei hah sûmphâiin ajuong mukhu ngeia, sûmphâi renga hah chong ajuong inringa, “Ama hih ka Nâipasal moroitak ani, a chong rangâi roi!” a tia. ");
INSERT INTO sch_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Inrangin an en titira hannirese tute an kôla adang mu khâi mak ngeia; Jisua vai ke an kôm aom zoi. ");
INSERT INTO sch_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Muol chung renga an juong chuma Jisua'n an kôm, “Miriem Nâipasal hi thina renga ânthoinôk mâka chu nin neinun mu hi tute kôm ril no roi duo” tiin chong a bê ngeia. ");
INSERT INTO sch_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","A chongbe ha an jôma, aniatachu ma roi ha an lâia, “‘Thina renga inthoinôk’ ti hih khoi tina mi hi?” tiin an injêk khôm phut zoi. ");
INSERT INTO sch_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Male anni han Jisua kôm, “Ithomo Balam minchupungeiin, Elijah a juong bak rang an ti?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ama'n an kôm, “Neinun murdi cherêl rangin Elijah chu a juong bak ngêt rang ani. Hankhoma, ithomo Pathien Lekhabu'n, Miriem Nâipasalin la tuong ok a ta, hengpaiin la om atih, a tia? ");
INSERT INTO sch_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nikhomrese, nangni ki ril Elijah chu a juong suo kêng ani zoi, male a chungroi Pathien Lekhabu'n ati anghan mingeiin a chunga an nuom lamtakin an lo zoi,” a tia. ");
INSERT INTO sch_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ruoisingei kôm an juong tungin chu an kôla loko tamtak ngei le Balam minchupungei senkhatin an lei inkhalpui lâitak an juong mua. ");
INSERT INTO sch_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mingei han Jisua an mu lehan an kamâm sabaka, male ama tieng an tânna chibai an va pêka. ");
INSERT INTO sch_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jisua'n a ruoisingei kôm, “Anni ngei lehan khoi thurchi mo nin lei inkhal ha?” tiin a rekel ngeia. ");
INSERT INTO sch_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Lokongei lâia mi inkhatin a kôm, “Minchupu, ka nâipasal ratha saloi a dôna male a chongloi sikin no kôm ko hong tuong tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ratha saloi ahong tôn racham nuoia ânlet kelen ngâia, a cherhuon a suoka, a hâ a riela, angarjêt ngâi. Ratha saloi ha rujûlpai rangin nu ruoisingei ke ngênna, aniatachu thei mak ngei,” a tia. ");
INSERT INTO sch_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jisua'n an kôm, “Kho anga mi iemnaboi mo nin ni! Idôrsôt mo nin kôm omin nangni ko donsûi thei ranga? Pasalte hah ko kôm hong tuong roi!” a tia. ");
INSERT INTO sch_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ama ha Jisua kôm an hong tuonga. Ratha saloi han Jisua a hong mûn chu pasalte hah a nunuom alo bita, masikin nuoia ân leta, a vânluoi ahônluoia, a cherhuon a suoka. ");
INSERT INTO sch_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jisua'n a pa kôm, “Hi anga a om phutna hih khotik renga mo ani zoi?” tiin a rekela. “Nâipang a chang renga” tiin chong a melea. ");
INSERT INTO sch_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Ratha saloi hin ama that rang pûtin vêl tamtak meia le tuia a meleta. Ne thei ngâiin chu inrieng mi mu inla, mi san roh!” tiin a rila. ");
INSERT INTO sch_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jisua'n a kôm, “Ani,” “nangmananâkin ni ni theiin chu! Taksônna dôn mingei ta rangin chu neinuntin anithei let,” a tia. ");
INSERT INTO sch_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","A pa han harenghan, ân ieka, “Taksônna ko dôn, hannirese hun zoi mak. Taksônna ko dôn uol theina rangin mi san roh!” a tia. ");
INSERT INTO sch_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jisua'n lokongei ama tieng an hong nâi titir a mua, masikin ratha saloi kôm han, “Ratha kuorsêt le chongloi,” ama han, “Pasalte sûng renga hong jôk roh, male a sûnga lût nôk tet khâiloi rangin chong nang ke pêk!” a tia. ");
INSERT INTO sch_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ratha saloi hah ân ieka, pasalte hah a vôrra a nunuom a lo bita, male a hong jôk paia. Pasalte hah athi angin angarzata, male mitinin, “Ama hih athi zoi!” an tia. ");
INSERT INTO sch_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Hannirese Jisua'n a kuta a sûra, a kaithoia, male ânding zoi. ");
INSERT INTO sch_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Masuole Jisua in sûnga a lûta, a ruoisingeiin inrûkten an rekela, “Ithomo keinin ratha saloi ha kin rujûlpai theiloi?” an tia. ");
INSERT INTO sch_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jisua'n an kôm, “Ma jât hi chu chubaithona niloiin chu, itên rujûl thei nimak,” tiin a thuon ngeia. ");
INSERT INTO sch_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jisua le a ruoisingeiin ha mun hah an mâka male Galilee ram palin an sea. Jisua'n a omna tutên an riet rangin nuom maka, ");
INSERT INTO sch_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","“Miriem Nâipasal hih a that rangpu ngei kuta bangin om atih. Nikhomrese, sûnthum suole chu aringin inthoinôk atih” ti chong hih a ruoisingei a minchu ngei sikin. ");
INSERT INTO sch_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Aniatachu hi minchuna aomtie hih rietthei mak ngeia, male ama rekel rang khom an chia. ");
INSERT INTO sch_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Hanchu Capernaum an hong tunga, insûnga an lût suole chu a ruoisingei kôm, “Lampuia han khoi roi mo nin rila nin inkhal hah?” tiin a rekel ngeia. ");
INSERT INTO sch_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Hannirese anni han thuon mak ngeia, lampuia an hong inkhalna hah ei lâia hin tumo alientak rang? ti roi hah ani sikin. ");
INSERT INTO sch_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jisua ânsunga, ruoisi sômleinik ngei hah a koia, male an kôm, “Tukhom alientak ani nuomin chu achîntak changin mi murdi tîrlâm ani masa ngêt rang ani” a tia. ");
INSERT INTO sch_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Hanchu nâipangte a koia, an motona a minding pe ngeia, a kuo ira, an kôm, ");
INSERT INTO sch_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Tukhom ki riming sika hi anga nâipangte inkhat khom a modômpu chu, keima mi modôm ania; male tukhom keima mi modômpu chu, keima mi modôm vai niloiin ni tîrpu khom a modôm sa ani” a tia. ");
INSERT INTO sch_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","John'n a kôm, “Minchupu, mi inkhat ni riminga ramkhoringei rujûl kin mua, male ei pâla mi ani loi sikin kin hong khap” a tia. ");
INSERT INTO sch_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jisua'n an kôm, “Ama ha khap rang pût no roi,” tute ki riminga sininkhêl a sina harenghan ku chungroia neinun saloi ngei ti thei kelen rang reng omak ngei, tiin a ril ngeia. ");
INSERT INTO sch_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tukhom mi chakal loi chu ei tienga kop ani. ");
INSERT INTO sch_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Adiktakin nangni ki ril, tukhom ki mi nin ni sika tuidâi kilât khat khom nangni a min nêkin chu râisânman a man ngêt rang ani. ");
INSERT INTO sch_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Tukhom keima taka taksônna dôn mi achînte ngei lâia inkhat khom a taksônna minmang pe chu a ringa bunôinalung lienpa orrin tuikhangliena inchôm senla ata rangin sa uol atih.” ");
INSERT INTO sch_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Masikin nu kutin na taksônna aminmangin chu tan pai roh! Kutngei inik dôna dûkmun meidîla, mei thi tet ngâiloia se nêkin chu kut boia ringna taka lût nata rangin asa uol. ");
INSERT INTO sch_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Male ne kengei han na taksônna aminmangin chu, tan pai kelen roh! Kengei inik dôna dûkmuna paia om nêkin chu ke boia ringna taka lût chu nata rangin asa uol. ");
INSERT INTO sch_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Male ni mitin na taksônna aminmangin chu kêl pai roh! Mitngei inik dôna dûkmuna paia om nêkin chu mit inkhat dôna Pathien Rêngrama lût nata rangin asa uol. ");
INSERT INTO sch_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ha muna han chu anni ngei sâk ngâi, “rulungngei ha khom thi tet ngâi mak ngeia, mei khom thi tet ngâi mak.” ");
INSERT INTO sch_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Inbôlna michi alin aminthieng ngâi anghan mi murdi meiin la minthieng nîng an tih.” ");
INSERT INTO sch_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Michi hih a ala; aniatachu a alna hah adongin chu ile mo nin min al nôk ranga? “Nin lâia malinchangna michi dôn ungla, male insûk irrin om roi” a tia. ");
INSERT INTO sch_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Hanchu Jisua'n ha mun hah a mâka, Judea ramhuola a sea, male Jordan Tuidung râl ânkânna lokongei apâlpa a kôm an hong intûp nôka, a tho tit ngâi anghan anni ngei ha a lei minchu ngeia. ");
INSERT INTO sch_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Phariseengei senkhat an honga, ama min ôkna rangin, “Mîn a lômnu mâk rangin ei Balamin aphal mo?” mi ril roh, tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jisua'n an kôm, “Moses'n inmo Balam nangni a pêk?” tiin chongrekel leh a thuon ngeia. ");
INSERT INTO sch_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Anni han, “Moses'n chu pasalin inmâkna lekha a mizieka male a lômnu tîr pai rangin inmâk hih a phal ngâi ani” ti hih an thuona chu ani. ");
INSERT INTO sch_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jisua'n an kôm, “Minchu nin intak rai sika Moses'n hi Balam hih nangni rangin a miziek, a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Aniatachu rammuol insieng phut renga Pathien Lekhabu'n ati anghan, ‘Pathien'n pasal le nupang’ a sin ngei ani. ");
INSERT INTO sch_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Masika han pasalin a nû le a pa mâk a ta, male a lômnu leh inlop an ta, ");
INSERT INTO sch_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","male inik hah takpum inkhat hongni an ti zoi.’ Masikin inik ni khâi mak ngeia, inkhat an hongni zoi ani. ");
INSERT INTO sch_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Hanchu Pathien'n munkhata a minzom sai chu miriemin an minsen rang nimak,” a tia. ");
INSERT INTO sch_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","In sûng an lût lehan a ruoisingeiin ma roi hah Jisua an rekela. ");
INSERT INTO sch_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ama han an kôm, “Tukhom a lômnu a mâka, male nupang dang inneipui chu a lômnu doiin a inrê ani. ");
INSERT INTO sch_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma angdênin, nupang khomin a pasal mâkin pasal dang inneipui chu a inrê ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jisua'n an chunga kutngei a minngama satavur theina rangin mi senkhatin a kôm nâipangtengei an hong tuonga, aniatachu ruoisingeiin mingei hah an lei ngokhuma. ");
INSERT INTO sch_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jisua'n maha a mu lehan a ningathika, a ruoisingei kôm, “Nâipangtengei ko kôm min hong ungla, khap no roi, Pathien Rêngram chu hi anga mingei ta ani sikin. ");
INSERT INTO sch_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Adiktakin nangni ki ril tukhom nâipangte angin Pathien ram a modôm nônchu Pathien Rêngram lût tet no ni,” a tia. ");
INSERT INTO sch_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Hanchu nâipangtengei a kuoa, an chung chita a kutngei minngamin, male satavur ngei zoi. ");
INSERT INTO sch_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jisua'n se nôk ranga kalchôichakin, mi inkhat a hong tânna, amakunga khûkinbilin, a kôm, “Minchupu Sa, ringinlon ka chang theina rangin imo ki sin rang?” tiin a rekela. ");
INSERT INTO sch_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jisua'n a kôm, “Ithomo asa mi ni tia?” “Pathien pêna chu tute mi sa om mak ngei. ");
INSERT INTO sch_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Balam chongpêkngei ha chu ni riet duo: ‘Mi that no roh; inrê no roh; inru no roh; adikloitakin tute bâtu tho no roh; mi huong no roh; nu nû le na pa jâ roh ti ngei hih’” a tia. ");
INSERT INTO sch_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Hapa han a kôm, “Minchupu ma Balam chongpêkngei nâm ha chu ka nâipangte renga ke lei jôm sai kêng” a tia. ");
INSERT INTO sch_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jisua'n amapa hah a en ngita, lungkhamna tak dônin a kôm, “Inkhat mamang na lân sam. Senla no dôn murdi zuor inla, male a sum hah inrieng ngei pêk inla, male invâna rochon dôn ni tih; hanchu hong inla, mi hong jûi roh” a tipea. ");
INSERT INTO sch_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Amapa han ha chong hah a riet lehan, a mâimôk pe oka, mineipa ani sikin, innguikhakin a rot zoi. ");
INSERT INTO sch_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jisua'n a ruoisingei a vêng ngeia male an kôm “Anei ngei Pathien Rêngrama lûtna rangin khodôra ântak mo ani zoi!” a tia. ");
INSERT INTO sch_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ruoisingei han a chongril hah jâmzal aom sabak an tia, hannirese Jisua'n a la tibanga an kôm, “Ka nâingei, Pathien Rêngrama lût rang hi idôra ântak mo ani zoi! ");
INSERT INTO sch_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Minei ngei Pathien Rêngrama lût nêkin chu simphuoi kuora ût lût rang bai uol ok atih” a tia. ");
INSERT INTO sch_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Haten hanchu ruoisingeiin an jâmânzal phar zoia, male inkhat le inkhat annin rekel inlôma, “Hanchu, tumo sanminjôkin aom thei rang?” an tia. ");
INSERT INTO sch_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jisua'n anni ngei hah a en ngita, an kôm, “Maha miriem rangin chu nitheimaka, aniatachu Pathien rangin chu anithei ani; Pathien rangin chu neinuntin hih anithei let ani” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Hanchu Peter'n a kôm, “En ta, keini chu neinuntin kin mâka, male nang kin jûi ani hi” a tia. ");
INSERT INTO sch_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jisua'n an kôm, “Ani,” nangni ki ril tukhom keima sika le thurchisa sika, in mo, lâibungngei mo, sarnungei mo, nû mo, pa mo, nâingei mo, loingei mo amâk ngei chu, ");
INSERT INTO sch_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","hi damsûng renga hin inngei mo, lâibungngei mo, sarnungei mo, nûngei mo, pangei mo, nâingei mo, loingei mo, abâk razan man a ta, male mi nuomlonangei khom tuong sa a ta; male zora la hong tung ranga ringinlon khom man sa atih. ");
INSERT INTO sch_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","“Aniatachu atûna amotontaka om mi tam ngei chu anûktaka la om an ta, male anûktaka om mi tam ngei chu amotontaka la om an tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jisua le a ruoisingei Jerusalem tena se rangin lampuia an oma, Jisua moton ânsa, ruoisingei hah kamâmnân an sipa; a nûkjûi mingei han an chia. Jisua'n, ruoisingei hah an theiviekin a tuong ngei nôka, male a chunga neinun ahongtung rang ngei hah a misîr pe ngei nôka. ");
INSERT INTO sch_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Rangâi roi, Jerusalem tena ei se rang ania, mahan Miriem Nâipasal hi ochaisingei le Balam minchupungei kuta bangin om atih. Thi rangin theiloimintum an ta masuole chu Jentailngei kuta bang an ta, ");
INSERT INTO sch_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","anni ngei han innuinân mang an ta, michil an ta, jêm an ta, that an tih; hannirese sûnthum suole chu aringin inthoinôk a tih” a tia. ");
INSERT INTO sch_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Hanchu Zebedee nâipasalngei Jacob le John, Jisua kôm an honga, “Minchupu, imini sin mi ni tho pe rangin kin nuom aom,” an tia. ");
INSERT INTO sch_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jisua'n an kôm, “Maha imo ani?” tiin a rekel ngeia. ");
INSERT INTO sch_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Anni han, a kôm, “Ne Rêngram roiinpuitaka ne rêngsukmuna nên sung tika na changtieng inkhat voitieng inkhat mi ni min sung rangin kin nuom ani” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jisua'n an kôm, “Nin ngên hi nin riet loi ani. Dûktuongna kilât ke nêk ngêt rang hi nin nêk thei rang mo? Ka baptisma chang rang khom nin chang thei rang mo?” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Anni han, “Thei kin tih” tiin an thuona. Jisua'n an kôm, “Ki kilât nêk rang chu nêk nin ta, ka baptisma chang rang khom chang thei nin tih. ");
INSERT INTO sch_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Aniatachu ka changtieng mo, ko voitieng mo tumo an sung rang thang rangin chu rachamnei mu-ung. Ha munngei hah chu Pathien'n tu ngei rang mo a minsûk pe ngei kôm han pêk ngei atih,” tiin a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ma roi hah ruoisi dang sôm ngeiin an lei rieta Jacob le John chunga an lei nuor zoia. ");
INSERT INTO sch_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Masikin Jisua'n anrêngin munkhatin a koi ngeia, an kôm, “Jentailngei chunga roijêkpu an phun ngei chu an chunga an inlal sabak ngâia, male an ruoipungei khom an chunga racham an nei tatak ngâi ti khom nin riet. ");
INSERT INTO sch_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nikhomrese, nin lâia chu ma anghin ani rang nimak. Nin lâia tukhomin alien rang a nuomin chu nin tîrlâm ani bak ngêt rang ani; ");
INSERT INTO sch_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","male nin lâia tukhomin amotontak ani nuomin chu mi murdi suok ani bak ngêt rang ani. ");
INSERT INTO sch_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Miriem Nâipasal luo mana mîn a sin an tho pe rangin juong maka; mi sin tho pe rangin le mi tamtak ngei ratan ranga a ringna pêk rangin ke a juong ani” a tia. ");
INSERT INTO sch_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jericho an hong tunga, Jericho renga Jisua le a ruoisingei leh loko tamtak ngei mâkin an se lâiin kutdo Timaius nâipasal Bartimaeus lampui kôla a lei insunga. ");
INSERT INTO sch_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nazareth Jisua ani ti a riet lehan ân ieka, “Jisua! David Nâipasal, inrieng mi mu roh ba!” a tia. ");
INSERT INTO sch_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Mi tamtakin dâirek rangin an ngokhuma, aniatachu ama'n, “David Nâipasal, inrieng mi mu roh!” tiin ânring uolin ân ieka. ");
INSERT INTO sch_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jisua ânngama male, “Ama hah hong koi roi” a tia. Masikin mitchopa hah an va koia, a kôm, “Tâihieiin om roh!” anni han, “Inthoi roh, nang a koi!” an tipea. ");
INSERT INTO sch_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Masikin a puon a vôr paia, inrangtakin ân chôma, male Jisua kôm a hong zoi. ");
INSERT INTO sch_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jisua'n a kôm, “Khoimo nang ko tho pe rangin nu nuom?” tiin a rekela. Mitchopa han a kôm, “Minchupu, mu nôk thei rangin ku nuom” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jisua'n a kôm, “Se ta roh, na taksônnân nang amindam zoi ani” tiin a rila. Voikhatrengin a mu thei kelena, male lampuia han Jisua a jûi zoi. ");
INSERT INTO sch_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jerusalem an hong tung rangtôn Bethphage le Bethany khopuingei kôla Olive Muol an hong tungin chu Jisua'n a ruoisingei lâia mi inik an motona a tîr ngeia, ");
INSERT INTO sch_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","hi rilnangei leh an kôm, “Nin motona khuo son se ungla, nin tung harenghan, sakuordingte inthung, tute la chuongna ngâiloi mu nin tih. Sût ungla, mahin hong kai roi. ");
INSERT INTO sch_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Male tukhomin itho mo ma anghin nin thoa, tiin nangni an rekel khomin, Pumapa'n a min nâng kêng, hong thak nôk kelen a tih ti roi” a tia. ");
INSERT INTO sch_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Masikin an sea lamliena inkhâr pêntienga sakuordingte inthung an va mua. Maha an sût lehan, ");
INSERT INTO sch_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","hataka ânding senkhat ngeiin, “Ithomo sakuordingte hah nin sûta?” tiin an rekel ngeia. ");
INSERT INTO sch_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jisua'n a ril ngei anghan an thuona, male lokongei han an min se ngei zoi. ");
INSERT INTO sch_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Sakuordingte hah Jisua kôm an hong kaia, a chunga an puonngei an dâpa male Jisua a chuonga. ");
INSERT INTO sch_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mi tamtakin an puonngei lampuia an dâpa, adangin loilâija sasôl an va tuka an dâp sa zoi. ");
INSERT INTO sch_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Amoton tienga se ngei le a nûk tienga a jûi mingeiin, “Hosanna! Pumapa riminga juongpu chu Pathien'n satvur rese! ");
INSERT INTO sch_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Rêng David Rêngram juong tung rang ha, ei pa'n satvur rese! Pathien minpâkin om rese! Ânchungtaka khin Hosanna!” tiin an inieka. ");
INSERT INTO sch_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jisua'n Jerusalem a tungin chu Biekin sûnga a lûta, male neinun nâm a ena. Aniatachu kholoi ahongni zoi sikin ruoisi sômleinik ngei leh Bethany taka an se zoi. ");
INSERT INTO sch_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Anangtûka chu Bethany renga an hong kîr nôka, Jisua a von ahong cham pea. ");
INSERT INTO sch_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","“Alazana renga theichang kung abuongei hah ava mua, masikin amara tete mo ka man” tiin ava pana. Hannirese ava tungin chu, theichang ânra zora ani loi sikin abuongei tiloiin chu ite adang mu maka. ");
INSERT INTO sch_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jisua'n theichang kung kôm han, “Tutên na mara sâk man khâi no rese ngei!” a tia. Male a ruoisingei khomin a chong ha an rieta. ");
INSERT INTO sch_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusalem an tung lehan, Jisua Biekina ava lûta, Biekina neinun juorngei le rochôkngei hah a rujûlpai ngeia. Sum thûlngei dosângngei le pharvali juorngei sukmunngei khom a nammelet pe ngeia, ");
INSERT INTO sch_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","male Biekin khalâidung han tutên neinun chôi rangin phal khâi maka. ");
INSERT INTO sch_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Hanchu mingei kôm han Pathien Lekhabua, “‘Ki Biekin chu namtinngei ta ranga chubaithona in ani,’ tiin ânziek nimak mo? Aniatachu nangni ngei rêkin chu inrungei inthupna in ke nin minchang hi!” tiin a minchu ngeia. ");
INSERT INTO sch_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Mahi ochaisingei le Balam minchupungeiin an rieta, masikin Jisua thatna rang lampui an rok zoia. Lokongei ha a minchuna hah kamâm aom sabak an ti sikin ama hah an chia. ");
INSERT INTO sch_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Hanchu, kholoi ahongni lehan, Jisua le a ruoisingei hah khopuilien an mâk zoia. ");
INSERT INTO sch_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Anangtûk jînga chu ha lampuia an lôn chungin theichang kung hah aruzungngei dênin athîn an mua. ");
INSERT INTO sch_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peter'n neinun ahongtung ha a riet nôka male a kôm, “Minchupu, en ta theichang kung khomâk na sâm hah athi phar zoi!” a tia. ");
INSERT INTO sch_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jisua'n an kôm, “Pathien taksôn roi,” tiin a thuon ngeia. ");
INSERT INTO sch_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Adiktakin nangni ki ril; tukhomin hi tâng hih, “Inthon inla tuikhangliena van pai roh” ti senla, mulunglâiinlakna boiin iemtakin a tiin chu, a ti anghan hongtung atih, ama rangin sinin om atih. ");
INSERT INTO sch_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Masika han nangni ki ril: i-ih khom chubaithoa nin ngên ngei murdi chu maha nin man sai angin iem ungla, male nin zong ngei murdi chu pêkin om nin tih. ");
INSERT INTO sch_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Male chubaitho ranga nin inding tika, “Tu chunga khom nourna nin dôn khomin ngâidam roi, masika han invâna nin Pa khomin nin minchâinangei hah nangni a ngâidam rang ani.” ");
INSERT INTO sch_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jerusalema an tung nôka. Biekina a lônlâitakin ochaisingei, Balam minchupungei le upangei Jisua kôm an honga ");
INSERT INTO sch_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","a kôm, “Tu rachamin mo hi neinunngei hih ni sin? Ma anga rachamneina hi tumo nang pêk?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jisua'n an kôm, “Kei khomin chongbâi khat nangni rekel ka ta, male mi nin thuonin chu, tu rachamin mo hi neinunngei hih ki sin nangni ril ki tih, tiin a thuon ngeia. ");
INSERT INTO sch_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ni ril roi, John Baptisma tho theina racham hah kho renga mo: Pathien renga mo miriem renga mo?” ");
INSERT INTO sch_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","An lâia anninanâkin an inkhal phut zoia: “Imo ei ti rang? ‘Pathien renga,’ tiin ei thuon lakin, ama'n ‘Itho mo, John hah nin iem loi?’ Mi tîng a ta. ");
INSERT INTO sch_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Aniatachu, ‘Miriem renga, ei tiin chu’ ” (Mitinin John hah dêipu tatakin an lei bê sikin, mipuingei laka an chia.) ");
INSERT INTO sch_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Masikin Jisua an thuona chu, “Riet mak meh,” an tia. Jisua'n an kôm, hanchu, “Kei khomin tu rachamin mo hi neinunngei hih ki sin nangni ril uol no ning,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Hanchu Jisua'n chongmintêkin an kôm a misîra, “Voikhat chu mi inkhatin grapebil a thoa, bêr a minkula, grape epna rang khur a choia, male angâkna rang in insâng a sina. Hanchu inlo mingei kôm a chuon inlo rangin a pêk ngeia, ram danga khuolchai a se zoia. ");
INSERT INTO sch_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Grape pot zora ahongnin chu a chang rangtum lâk rangin inlo mingei kôm a suok inkhat a tîra. ");
INSERT INTO sch_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Inlo mingeiin a suok hah an lei sûra, an jêma, kut korongin an min se zoi. ");
INSERT INTO sch_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Hanchu a pumapa'n suok dang a tîr nôka; inlo mingei han a lu an lei mophop pea mâimôk an lei shak bita. ");
INSERT INTO sch_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","A pumapa han suok dang a tîr nôk rêka, amapa hah chu an lei thata; male ma angdênin adang tamtak ngei khom senkhat an lei jêma, senkhat an lei thata. ");
INSERT INTO sch_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ha mi han tîr ranga a dôn chu a nâpasal lelê a moroitak vai ha ani zoia; ‘Ka nâipasal hi chu lei jâ ngêt an tih’ tiin a nâipasal hah anûktaka a tîra. ");
INSERT INTO sch_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Hannirese ha inlo mingei han inkhat le inkhat kôm, ‘Hipa hih a pumapa nâipasal ani hi. Hong roi, ama hih that rei u, male a rochon hih ei ta ani rang!’ an tia. ");
INSERT INTO sch_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Masikin a nâipasal hah an sûra, an thata a ruok khom grapebil pêntieng an paia. ");
INSERT INTO sch_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Hanchu, kho angin mo grapebil pumapa han a lo ngei rang ni zoi?” tiin Jisua'n a rekela. “Hong a ta, ha mingei hah that a ta, grapebil hah donsûi rangin midangngei kut chunga pêk ngei atih.” ");
INSERT INTO sch_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Adiktakin hi Pathien lekhabu hih nin pore loi mini? “‘In sinpungeiin lung mangmunboi anga an hengpai hah akila lung kâmnâng tak achang zoi. ");
INSERT INTO sch_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Maha Pumapa tho ania; ma hih ei mitmua kamâmaruoi sabak na!’” ti hih a tia. ");
INSERT INTO sch_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ma chongmintêk hah anni ngei demnân a misîr ani ti an riet sikin; Juda ruoipungeiin Jisua sûr rangin an pûta. Hannirese lokongei hah an chia, masikin ama an mâka, male an rot zoi. ");
INSERT INTO sch_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Chongrekelngei leh min ôk rangin phariseengei senkhat le Herod pâla mi senkhat ngei a kôm an tîra. ");
INSERT INTO sch_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Anni ngei hah a kôm an honga, “Minchupu, chongtak ni misîr ngâi ti kin rieta, mingeiin imo an mindon rang kângdoi loiin, tute dingmun lunghâng tho loiin, hannirese mingei rangin Pathien lungdo ni minchu ngâia, Rom Rêng Caesar kôma chôiruol pêk rangin ei Balamin ânkalpui mo? Kin pêk ngei rang mo, kin pêk ngei loi rang mo?” mi ril roh, an tia. ");
INSERT INTO sch_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Aniatachu Jisua'n an huongvâr tho hah a riet chiena, male an kôm, “Ithomo ni min ôk rang nin tho hi? Duli sumthîr inkhat hah hong chôi ngân hi roi, lei en rong,” tiin a thuon ngeia. ");
INSERT INTO sch_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Inkhat an hongchôi pea, an kôm han, “Tu mâisuo le tu riming mo ani hi?” tiin a rekel ngeia. Anni ngei han, “Caesar” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Masikin Jisua'n an kôm, “Asa, hanchu Ceasar ta chu Caesar pêk ungla, male Pathien ta chu Pathien pêk roi,” a tipe ngeia. Male Jisua chunga han an kamâm sabak zoi. ");
INSERT INTO sch_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Hanchu mingei inthoinôkna omak ti ngâi Sadduceengei Jisua kôm an honga, male ");
INSERT INTO sch_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Minchupu, Moses balam hih kin ta rangin a mizieka: ‘Mîn nâingei nei loiin a lômnu a thisanin chu, a nâipa han ha meithâi hah a luo ngêt rang ani, nâingei an neia athipu ulienpa nâingeia bê ani theina rangin.’ ");
INSERT INTO sch_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Voikhat chu lâibung sari an oma; ulientakin in a neia male nâingei nei loiin a thia. ");
INSERT INTO sch_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Hanchu inikna han ma nupang ha a luo nôka, male nâingei nei loi dênin a thi nôka. Lâibung inthumna khom ma angdên ania, ");
INSERT INTO sch_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","male anrêngin: ma lâibung sari ngei han ma nupang hah an luo paka, tutên nâingei nei pui loiin an thisan rieia. Anûktaka chu nupangnu khom hah a thia. ");
INSERT INTO sch_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Atûn, mithi ngei nâm aringin an inthoinôk nikhuo tikin tu lômnu tak mo ani rang ani zoi? Ma sari ngei laka han amanu hah anrêngin an luo paka” an tia. ");
INSERT INTO sch_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jisua'n an kôm, “Idôra dikloi mo nin zoi! Male itho sika mo nin riet mo?” Ma ha Pathien lekhabu le Pathien sinthotheina nin riet loi sika ani. ");
INSERT INTO sch_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Athi ngei aringin an inthoinôk tika chu, invâna vântîrtonngei angin om an ta, innei no ni ngei. ");
INSERT INTO sch_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Atûn mithi ngei kaithoia an om rang roi chu, Moses lekhabua chîmbuka meichuong chungroia han Pathien'n Moses kôm, “‘Keima Abraham Pathien, Isaac Pathien, Jacob Pathien ki ni,’ tia ânziek hah nin la pore tet ngâi loi mini? ");
INSERT INTO sch_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","‘Ama chu aring ngei Pathien ke ani, mithi ngei Pathien nimak. Nin minchâi phar zoi!’” tiin a thuon ngeia. ");
INSERT INTO sch_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Balam minchupu inkhatin an injêkhômna hah a rieta. Jisua'n Sadduceengei hah thuonna satak a pêk ngei hah a mûn chu a honga, masikin Jisua kôm, “Chongpêkngei murdi lâia khotak hi mo akâmomtak?” tiin arkela. ");
INSERT INTO sch_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jisua'n a kôm, “Akâmomtak chu ma hih ani: ‘Israelngei rangâi roi! Pumapa ei Pathien vai hih Pumapa ani. ");
INSERT INTO sch_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Pumapa na Pathien chu nu mulungrîl murdi leh, na ratha murdi leh, nu mulungbôk murdi leh, na râtna murdi leh lungkham roh.’ ");
INSERT INTO sch_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Inikna chongpêk akâmom nôk chu ma hih ani: ‘Nangma nên lungkham anghan nu bungmingei lungkham roh’ ti hi. Hi Chongpêk inik ngei nêka roiinpui uol reng omak” tiin Jisua'n a thuona. ");
INSERT INTO sch_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Balam minchupu han Jisua kôm, “Ani ai duo, Minchupu! Mahi adik, ni ti anghan, Pumapa vai hih Pathien ania male ama pêna chu pathien dang reng omak. ");
INSERT INTO sch_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Male Pathien chu nu mulungrîl murdi leh, nu mulungbôk murdi leh, na râtna murdi leh nu lungkham ngêt rang ania; male nangma nên lungkham anghan nu bungmingei hah nu lungkham ngêt rang ani. Pathien kôma mâichâma sâ pumhâl inbôlnangei le inbôlna adangngei nêkin khom ma chongpêk inik ngei jôm hih akâmom uol ani” a tia. ");
INSERT INTO sch_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jisua'n inthârtakin a thuon ti a rieta, male a kôm, “Pathien Rêngram renga la mak che,” a tipea. Masuole chu tutên Jisua kôm chongrekel rangin ngam khâi mak ngei. ");
INSERT INTO sch_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisua'n Biekina a minchu ngei lâihan an kôm, “Kho angin mo Balam minchupungeiin Messiah chu David richisuonpâr ani rang an ti thei?” ");
INSERT INTO sch_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David ha Ratha Inthieng mangin: “Pumapa'n ku Pumapa kôm: Ka changtieng insung tit roh na râlngei ne kepha nuoia ka dar mâka chu” a ti ani. ");
INSERT INTO sch_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David han ama hah “‘Pumapa’ a tia; masikin kho angin mo Messiah hih David richisuonpâr ani thei ranga?” a tia. Loko tamtakin Jisua chongril hah râisântakin an rangâia. ");
INSERT INTO sch_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","A minchu ngei anghan, an kôm, “Balam minchupungei renga indîn roi, anni chu kâncholiinchuol hâka lêng an nuom ngâia, bazar muna mîn an jâ ngeia chibai an pêk ngei rangin an nuoma, ");
INSERT INTO sch_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Synagogngeia sukmun asatak ngei, le khohoithona munngeia, mun hoitak ngei an thang ngâi. ");
INSERT INTO sch_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Meithâingei sum an sâka an inngei an muruka, male mi huongna rangin asôt tatakin chubai an tho ngâia. Masika han an dûktuongna hah intak uol ok atih” a tia. ");
INSERT INTO sch_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisua Biekina sumsiena kôla ânsunga, mingeiin asûnga an tholôm thâk ngei hah a ena. Minei tamtakin sum tam tatak an thâka; ");
INSERT INTO sch_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","hanchu meithâi inriengte a honga male damali inik a thâka, maha poisa khat dôr ani. ");
INSERT INTO sch_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","A ruoisingei a koitupa male an kôm, “Nangni ki ril; tholôm dôngna tholôm thâk ngei murdi nêkin hi meithâi inriengte hih a thâk min tam uol tak ani. ");
INSERT INTO sch_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Midangngeiin chu an nei minieng, an mang minieng ngei an thâka; aniatachu amanu hih chu, ânrieng anghan, a dôn nâm a thâkripa—a ringna ranga a dôn nâm te hah a pêkrip zoi,” a tia. ");
INSERT INTO sch_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisua Biekin renga a hong jôk lâihan a ruoisingei lâia mi inkhatin a kôm, “Minchupu, en ta! Lungngei le inngei kamâm aom tie hi!” a tia. ");
INSERT INTO sch_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jisua'n a kôm, “Hi in roiinpui ngei hi nu mu na? Lung inkhat luo amuna hin mâkin om no nia; anrêngin misim zit la nîng atih,” a tia. ");
INSERT INTO sch_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jisua chu Biekin mâi tienga Olive Muola ânsung lâihan a kôm, Peter, Jacob, John le Andrew inrûkin a kôm an honga. ");
INSERT INTO sch_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Mahi khotika mo ahong om rang? Male ma neinunngei ha ahongtungna rangin imo minsina aom rang? Mi ril roh,” an tia. ");
INSERT INTO sch_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jisua'n an kôm, “Tutên nangni an huong loina rangin inning roi,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mi tamtakin, “Khrista ki ni!” tiin ki rimingin hong an ta, mi tamtak huong an tih. ");
INSERT INTO sch_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Male anâina mo, alazana mo râl ruhu thurchi ngei nin riet khomin nin jâmminzal no roi. Ma anga neinunngei hah chu aom ngêt rang ani, hannirese amongna chu la ni tak no ni. ");
INSERT INTO sch_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Jâtngei le Jâtngei lân doi an ta, ramngei le ramngei lân doi an tih, rêngramngei le rêngramngei lân doi an tih. Muntina ningnungei hong a ta, mâitâmngei la chul atih. Ma neinunngei ha nâiha aphutna ngei angin ani rang. ");
INSERT INTO sch_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Nangninanâkin nin inning ngêt rang ani. Sûrin la om nin ta, male roijêknamuna tuongin la om nin tih. Synagogngeia jêmpol la ni nin ta; keima jârin rêngngei le roijêkpungei makunga Thurchi Sa misîr pe ngei rangin lân ding nin tih.” ");
INSERT INTO sch_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Aniatachu amongna ahong tung mân, Thurchisa hih mi murdi kôm misîrin aom bak ngêt rang ani. ");
INSERT INTO sch_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Male sûrin nin oma, male roijêknamuna tuongin nin om tikin, nin ti rang lei mindonin azora aphâk mân nin jâmminzal no roi; azora taka, i-ih khom nangni pêka aom tak hah ti roi. Chong nin ti rang ngei hah nangni nin chong ni no nia; anni ngei hah Ratha Inthieng renga ajuong rang ani. ");
INSERT INTO sch_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mîn a lâibungngei nanâk khom that rangin la minsûr a ta, male pa khomin ma angdênin a nâingei la minsûr sa a ta, nâingei khomin an nulepangei doi an ta, male that an tih. ");
INSERT INTO sch_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Keima sikin mitinin nangni la mumâk an tih. Aniatachu tukhom among dêna tuongdierpu chu sanminringin om atih. ");
INSERT INTO sch_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“‘Intakna Ichi Omtak’ ha ânding loina rang muna ânding la mu nin tih.” (aporepungei ranga minrietna: mahi aomtie rietthei rese ngei!) “Hanchu Judea rama om ngei hah tângngei chunga han rot ngêt rese ngei.” ");
INSERT INTO sch_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","In chunga ompu khomin chumin a chôi rang a in sûnga neinun juong lâk rangin azora minhek tet no rese. ");
INSERT INTO sch_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Loia ompu khomin a puon va lâk rangin in sûnga kîr tet no rese. ");
INSERT INTO sch_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Nupang nâivong ngei le nâitesen pomlâi nûngei rangin chu ma nikhuongei hah khodôra ichiruoi mo ani rang! ");
INSERT INTO sch_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ma zora hah phalbia atung loina rangin Pathien kôm chubaitho roi. ");
INSERT INTO sch_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ma nikhuongeia intaknangei ha chu Pathien'n rammuol a sinphut renga avien sûn tena rammuolin a lei riet ngâi murdi nêkin ânchungtak ani rang sikin. Ma anga neinun ha chu khotiklâi khomin om nôk tet khâi no ni. ");
INSERT INTO sch_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Aniatachu ma nikhuongei hah Pumapa'n a minbong ania; ninorese chu tute ring thei no ni ngei. Nikhomrese, a thangsai a mingei sikin ma nikhuongei hah a minbong ani. ");
INSERT INTO sch_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Hanchu, tukhomin nin kôm, ‘En ta, hin Messiah aom!’ aninônchu, ‘En ta, son aom!’ an ti khomin maha iem no roi. ");
INSERT INTO sch_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Messiah rotholngei le dêipu dikloingei an inlang rang sikin. Pathien'n a thangsai a mingei tena khom anitheiin chu an huong theina rangin sininkhêlngei le kamâmruoi neinunngei tho an tih. ");
INSERT INTO sch_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nangni chu inningchienin om roi! Azora ahong tung mân khokhoi khom nangni ke lei ril let zoi ani. ");
INSERT INTO sch_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ma intakna nikhuongei le azora avun suo nûkin chu nisa hah hong jîng a ta, tha khom vâr khâi no nia, ");
INSERT INTO sch_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ârsingei khom invân renga joungtâk an ta, male munronga sinthotheinangei khom an omnangei renga inthîn pai atih. ");
INSERT INTO sch_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Hanchu Miriem Nâipasal hih sinthotheina inlaltak le roiinpuitak leh sumngei lâia khin juong inlang atih. ");
INSERT INTO sch_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ama'n philchung kôlkil minlia, kôlmong kângkhat renga kôlmong kângkhat dênin rammuol pumpuia, Pathien'n a thangsai a mingei mintûp rangin a vântîrtonngei tîr atih. ");
INSERT INTO sch_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Theichang kungin nangni minchu rese. Amachangngei ahong ema, ahong innoia male abuongei ahong incherin chu kholum hih anâi zoi ti nin riet ngâi. ");
INSERT INTO sch_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ma angdênin, nangni khomin ma neinunngei hah ahongtung nin mu tika chu azora ahong nâi zoi, ânphut rang ani zoi tiin nin riet rang ani. ");
INSERT INTO sch_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ma neinunngei murdi hah atûnlâia mingei hih an thi riei mân ahongtung rang tiin riettit roi. ");
INSERT INTO sch_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Pilchung le invân inmang pai a ta, hannirese ko chongbâingei chu inmang pai tet no ni. ");
INSERT INTO sch_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Nikhomrese, anikhuo aninônchu azora chu khotika mo ahongtung rang, invâna vântîrtonngei khomin, Nâipasal khomin, tutên riet mak ngei; Pa vai kêng a riet ani. ");
INSERT INTO sch_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Azora hah khotika mo ahongtung rang nin riet loi sikin, inningchien ungla, intûngchienin om roi. ");
INSERT INTO sch_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Maha chu mîn a in a mâka, a tîrlâmngei rachamneina a pêk ngeia, an sintho rang a pêk ngei chita, inkhârôtpu khom inningchiena om ranga chong a mâk pea, ram lataka khuolse angin ani. ");
INSERT INTO sch_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Masikin inningchienin om roi, in pumapa hong rang zora hah kholoia mo, jânchima mo, ârkhuona mo, jînga mo, ahongtung rang nin riet loi sikin. ");
INSERT INTO sch_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Inningloiin a hong duoi khomin, a inin nangni hong mu tet no rese. ");
INSERT INTO sch_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Hanchu, nin kôma ki ti hih mi murdi kôm ki ti ani: inningchienin om roi!” a tia. ");
INSERT INTO sch_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kalkân kût le Cholboi Vâipôl Kût rang sûnnik motona ochaisingei le Balam minchupungeiin Jisua inrûktea sûra male that rang lampui an rok banga. ");
INSERT INTO sch_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","“Khohoi sûngin chu ei tho tet rang nimak,” aninônchu “mingei lâia injêlna om duoi ni,” an tia. ");
INSERT INTO sch_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisua chu Bethany taka Simon phârpa ina a oma, Jisua bunêk lâitakin, nuvengte inkhat nard sariek mirimhoi man luttak alabaster bilôr sipmat a hongchôia. Amanu han bilôr hah a khoia male a lu chunga a buoka. ");
INSERT INTO sch_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ha muna om mingei senkhatin chu an ningathika, “Khoitho mo hi sariek mirimhoi hih an minpâmchien hi? ");
INSERT INTO sch_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Duli razan thum nêka tama juora asum hah inrieng ngei pêk thei ke ani duo!” an tia. Male amanu hah asân an chierkhum zoi. ");
INSERT INTO sch_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Hannirese, Jisua'n an kôm, “Amanu hah atheiin mâk roi! Khoitho mo nin jêl hi? Ka ta rangin neinun satak le enhoitak a tho ani. ");
INSERT INTO sch_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mi inrieng ngei chu nin kôma an omtit rang an nia, male nin nuom titika nin san thei. Aniatachu keima chu nin kôm hin omtit no ning. ");
INSERT INTO sch_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Amanu hih a theidôrin a tho ania; ka takpum hih phûm ranga lei cherêla mirimhoi a lei buok ani. ");
INSERT INTO sch_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Atûn hin, adiktakin nangni ki ril, rammuol pumpuia Thurchisa an misîrna muntina hinu sintho khom hi an riettitna rangin misîr sa ngâi an tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Hanchu ruoisi sômleinik ngei lâia mi inkhat, Judas Iscariot han Jisua a minsûr theina rangin ochaisingei kôm ava sea. ");
INSERT INTO sch_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","A ti rang an lei rieta an râiasân sabaka, male sum pêk rangin an inkhâma. Masikin Judas han Jisua ha an kuta a bâng theina rangin chuminrên a rok zoi. ");
INSERT INTO sch_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Khohoia Cholboi Vâipôl bukhalâi otni sûn masatak han, Kalkân Kût bukhalâi otna ranga belritengei an that ngâi ni han a ruoisingeiin a kôm, “Nangma rangin Kalkân Kût bukhalâi hih khonmo nang va minsûk pe unglang nu nuom?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Hanchu a ruoisingei mi inik hi rilnangei lehin a tîr ngeia: an kôm, “Khopuiliena se ungla, male pasal tui-ûm rokot nangni intongpui atih. Ama hah jûi ungla ");
INSERT INTO sch_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","a lûtna taka in pumapa kôm han: ‘Minchupu'n, khonmo ku ruoisingei le Kalkân Kût kin sâkna rang khâltan hih?’ a ti, va ti roi. ");
INSERT INTO sch_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Hanchu ama rengin khâltan chunginchuon inzar lienpa, neinun aom sai, mintuodir sai nangni min mûng a ta, mahan eini rangin va minsûk roi,” a tia. ");
INSERT INTO sch_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ruoisingei ha an inphêta, khopuilien han an sea, Jisua'n a ril ngei anghan neinun murdi ha an va mua; Kalkân Kût bukhalâi hah an va minsûk zoi. ");
INSERT INTO sch_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kholoi ahongni lehan, Jisua hah ruoisi sômleinik ngei leh an se zoia. ");
INSERT INTO sch_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Dosânga bukhalâi an ot lâitakin Jisua'n, “Nangni ki ril; nin lâia mi inkhat, ko kôma sâk mi sâkpuipu lelê hin ni minsûr atih” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ruoisingei an mulungdûk atông pe ngeia, male inkhat suole inkhat adônin, “Adiktakin keima mo mi ni tina?” tiin an rekel paka. ");
INSERT INTO sch_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jisua'n an kôm, “Nangni sômleinik ngei lâia inkhat, mâirânga a vâipôl mi michie puipu hi ani. ");
INSERT INTO sch_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Pathien Lekhabu'n, Miriem Nâipasal hih a thi ranga a lei ti anghan a thi rang ania; hannirese Miriem Nâipasal minsûrpu chungroi chu ântak sabak rang! Ma miriem rangin chu ânzir loi nisenla chu ama rangin asa uol rang ani!” tiin a thuon ngeia. ");
INSERT INTO sch_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","An sâk lâitakin, Jisua'n vâipôl hâr a lâka, chubaithôn râisânchong a rila, maha a khoia, male a ruoisingei kôm maha a pêk ngeia. “Lâk ungla sâk roi,” ama'n, “ma hih ka taksa ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Hanchu kilât a lâka, Pathien kôm râisânchong a rila, male maha a pêk ngeia; male anrêngin an nêk pak zoi. ");
INSERT INTO sch_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jisua'n an kôm, “Ma hih ki thisen mi tamtak ranga asuok, Pathien chonginkhitna athar mindetna ani. ");
INSERT INTO sch_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nangni ki ril, Pathien Rêngrama uain thar ke nêk ni atung mâka chu hi uain hih nêk nôk khâi noning” a tia. ");
INSERT INTO sch_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Hanchu minpâkna lâ inkhat an thoa, Olive Muola an se zoi. ");
INSERT INTO sch_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisua'n an kôm, “Nin rêngin rot riei nin ta, ni mâk riei nin tih, Pathien lekhabu'n, ‘Pathien'n belrihôlpu hah that a ta, belringei ha chekinchâi chit an tih’ ati sikin. ");
INSERT INTO sch_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Aninâkachu aringin kên thoinôk suole chu Galilee rama nin motona lei se ki tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peter'n a kôm, “Adangngei nâmin nang mâksan riei khomsenla ngeia, keiman chu nang mâksan tet no ning!” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jisua'n Peter kôm, “Nang ki ril avien jân voinik ârkhuong mân nangman voithum mi ipdel ni tih,” a tipea. ");
INSERT INTO sch_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Peter'n chong angar uolin a thuona, a kôm, “Ni thina thisa rang khom ni ronga nang ipdel tet noning!” a tia. Male ruoisi adangngei nâm khomin ma angdênin an ti paka. ");
INSERT INTO sch_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Gethsemani an ti mun hah an hong tunga, male Jisua'n a ruoisingei kôm, “Chubai ko tho sûngkâr chu mahin lei insung roi,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Peter, Jacob le John ngei hah a kôm a tuong ngeia, asân rathânvaiin a mulungdûk atong tataka, ");
INSERT INTO sch_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","male an kôm, “Ku mulungdûk ana rai sikin thi rang angin ke ko om zoi. Mahin om ungla male inningchienin om roi” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Amoton tieng ava se uol vieta, pila ânboka, male ha tuongna rang zora ha anitheiin chu a lôi theina rangin chubai a thoa. ");
INSERT INTO sch_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Pa,” “O ka Pa! Nangma rangin chu neinunngei murdi anithei let. Hi tuongna kilât hih ko kôm renga mi khâi pai pe roh. Aniatachu keima ka racham niloiin nangma na racham tak nirse,” tiin chubai a thoa. ");
INSERT INTO sch_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Hanchu a hongkîra, male ruoisi inthum ngei hah an innin a hong mu ngeia, Peter kôm han “Simon, na la in tit mo? Konta khat luo amengin nin om thei loi mo?” ");
INSERT INTO sch_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Male an kôm, “Huongna nin lût loina rangin inningchienin om ungla, male chubaitho roi. Ratha'n chu a nuoma, hannirese taksân chu phâri mak” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Vêlkhat a va se nôka, male chongbâingei a ti dên hah va tiin chubai ava tho nôka. ");
INSERT INTO sch_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Hanchu a ruoisingei tieng a hongkîr nôka, male an lei in dênin a hong mu ngei nôka; an mitngei reng meng thei khâi maka. Male a kôm ti rang khom riet khâi mak ngei. ");
INSERT INTO sch_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Avoithumna a hongkîr nôkin chu an kôm, “Atûn ten khom sôlinngamin nin la in dêna? Ahun zoi! Azora ahong tung zoi! En ta u, atûn Miriem Nâipasal hih mi nunsiengei sinthotheina kuta bangin aom rang ani. ");
INSERT INTO sch_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Inthoi ungla, se ei tih u zoi. En ta u, mahin mi minsûr rangpu hih a hong nâi zoi!” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisua a la chong lâitakin, a ruoisi sômleinik ngei lâia Judas hah a hongtung kelena. Ama leh ochaisingei, Balam minchupungei le upangei leh lokongei an hongtîr ngeia, khandaingei le molbongngei chôiin an hongtunga. ");
INSERT INTO sch_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","A minsûr rangpu han, “A bieng ku tum tak hah nin rokpu hah ani, sûr ungla male tuong kelen roi, enkol roi” tiin minsinna a lei ril ngei sai ani. ");
INSERT INTO sch_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas a hongtung harenghan, Jisua kôm ava se kelena, “Minchupu!” tiin a bieng a tum pea. ");
INSERT INTO sch_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Masikin Jisua hah an sûra male an khitbel zoi. ");
INSERT INTO sch_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Hataka inding ngei lâia mi inkhatin a khandai a kêlsuoa male Ochai Inlaltak suok, a kuor a tukthâk pe zoi. ");
INSERT INTO sch_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Hanchu Jisua'n anni ha a rokôka, an kôm “khandaingei le molbongngei chôiin balampalpu sûr rang angin mi sûr rangin nin hong mo hi? ");
INSERT INTO sch_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Anîngtin Biekina nangni minchu rangin nin kôm ko om ngâia, hannirese mi sûr mak choia. Aniatachu Pathien Lekhabungei ahongtung adik ngêtna ranga ani hi,” a tia. ");
INSERT INTO sch_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Hanchu a ruoisingei han ama an mâk raka, male an tân khip zoi. ");
INSERT INTO sch_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ruotharte inkhat, rosompuon leh vai invôn Jisua a jûia. Ama khom sûr sa rang an pûta, ");
INSERT INTO sch_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","hannirese a puon hah mâkrakin a korongin a tânpat zoi. ");
INSERT INTO sch_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Hanchu Jisua hah Ochai Inlaltak ina an tuonga, mahan ochaisingei nâm le Balam minchupungei le upangei khom an hong intûp sa kelena. ");
INSERT INTO sch_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peter'n alazanna renga a jûia, Ochai Inlaltak khalâidung dênin a sea. Mahan a rungpungei lâia mei ava uota. ");
INSERT INTO sch_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ochaisingei le roijêkpungei murdi han Jisua an that theina rangin a minchâina an man theina rang abi an mazama, aniatachu ite man mak ngei. ");
INSERT INTO sch_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Rietpuipungei tamtakin Jisua doiin milakin an nônna, hannirese, an nônna thurchingei hah intok thei mak. ");
INSERT INTO sch_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Mi senkhat an indinga male Jisua doiin milakin an nônna: ");
INSERT INTO sch_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Hi mi hin, miriemin an lei sin ‘Biekin hih set ka ta, male sûnthumin adang inkhat kuta sin niloi in minding ki tih’ a ti kin riet” an tia. ");
INSERT INTO sch_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nikhomrese, ma an nônna thurchingei hah khom intok uol maka. ");
INSERT INTO sch_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ochai Inlaltak hah an renga an moton han a vândinga, male Jisua kôm chong a rekela, “Nang an nônna roia hin ite thuonna no dôn loi rang mo?” a tia. ");
INSERT INTO sch_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Aniatachu Jisua chu a dâireka, male chongbâi khat luo ti maka. Avêlin Ochai Inlaltak han a kôm, “Nangma ha Satvura om Pathien Nâipasal, Messiah hah ni ni mo?” tiin a rekel nôka. ");
INSERT INTO sch_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jisua'n a kôm, “Ki ni,” male, “Miriem Nâipasal hih Râtinchung chang tieng insungin, invâna sûmngei lâia juong nin rêngin la mûng nin tih!” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ochai Inlaltak han a puonsilngei a potkhêra, male “Rietpuipu adang reng nâng khâi mak meh! ");
INSERT INTO sch_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Pathien ânti le a rilsiet ti chu nin riet zoia. Imo nin roimasat?” a tia. An rêngin ama an doia: ama hih theiloina a dôna male that rang piel ani an ti paka. ");
INSERT INTO sch_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Senkhat ngeiin a mâi an michil phuta, a mâi an hîp pea, male an jêma. A kôm, “Mi ril roh tumo nang a jêm!” an tia. Male rungpungei han an tuonga male ama an bên zoi. ");
INSERT INTO sch_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Peter hah thangtienga khalâidunga a la om lâihan Ochai Inlaltak tîrlâm dôngmate inkhat a honga. ");
INSERT INTO sch_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Peter mei lei uot hah a mu lehan a enririna, a kôm, “Nangma, khom Nazareth Jisua leh munkhata om ngâi ni ni nah” a tipea. ");
INSERT INTO sch_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Hannirese Peter'n a ipdela, “Riet mu-ung Khoimo ni ti reng rietthei mu-ung,” tiin a thuona, male mokot pêntieng ava jôka. Masuole han âr akhuong kelen zoi. ");
INSERT INTO sch_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tîrlâm dôngmate han a va mu nôka, a kôla inding ngei kôm han, “Hipa hih khom an lâia mi inkhat ani sa!” a ti nôka. ");
INSERT INTO sch_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Aniatachu Peter'n a ipdel nôk rêka. Chomolte suole chu a kôla inding ngeiin Peter kôm, “Galilee rama mi ni ni sa sikin nang khom an lâia mi ni ni khet,” tiin an deia. ");
INSERT INTO sch_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Hanchu Peter'n an kôm, “Chongtak rilin khomâk kên sâm ani! Adik nônchu Pathien'n dûk ni tho rese! Ma miriem nin ti chungroi hah riet reng riet tatak ngâi mu-ung!” a tia. ");
INSERT INTO sch_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Masuole han âr voinikna ahong khuong nôk zoia, male Jisua'n Peter kôm han, “Âr voinik akhuong mân nangman voithum keima hi riet ngâi mu-ung ni ti rang,” a tipe chong hah a hong rietsuok nôka. Male a mulungakoi pea, a chap ngu-ngûi zoi. ");
INSERT INTO sch_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Jînga inmânin innottakin, ochaisingei ha upangei le Balam minchupungei, le Roijêkpungei murdi leh an intônga male mintuonangei an sina. Jisua ha zingjirûi leh an khita an tuong paia, male Pilat kuta an bânga. ");
INSERT INTO sch_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilat'n chong a rekela, a kôm, “Judangei rêngpa ni ni mo?” a tia. Jisua'n, “Nangman ke mi ni ti duo” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ochaisingei han abi tamtakin Jisua an nônna, ");
INSERT INTO sch_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","masikin Pilat'n Jisua kôm chong a rekel nôka, “Nangman nu thuonloi rang mo? nang an nônnangei nâm hih rangâi roh!” a tia. ");
INSERT INTO sch_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Avêlin Jisua'n chongbâi khat luo ti rang nuom maka, male Pilat'n a kamâm sabak zoia. ");
INSERT INTO sch_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pilat'n chu Kalkân Kût zora zeta mi intâng ina aom inkhat mingeiin an ngên tak ha a mojôk pe ngei ngâi a baisi ani. ");
INSERT INTO sch_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ma zora han mi inkhat a riming Barabbas hah, mi ânhelngei pâla mi, le loko injêlna kâra mi that sika intâng ina a oma. ");
INSERT INTO sch_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Lokongei an intûpa male anni ranga a lei tho pe ngei ngâi anghan tho rangin an ngên lâihan, ");
INSERT INTO sch_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilat'n an kôm, “Judangei rêngpa hih nangni mojôk pe inlang nin jôt mo?” tiin a rekel ngeia. ");
INSERT INTO sch_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ochaisingei han an narsa sika Jisua hah a kut chunga an hong bâng ani ti a riet minthâra. ");
INSERT INTO sch_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Aninâkachu Ochaisingei han mipuingei hah Barabbas a mojôk pe ngei ranga ngên rangin an misiet ngeia. ");
INSERT INTO sch_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Hanchu Pilat'n an kôm, “Aninte, Judangei rêngpa nin tipu hih imo ko lo rang ani zoi?” tiin a rekel ngei nôka. ");
INSERT INTO sch_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Anni han, “Khrosa jêmdel roh!” tiin an iniek nôka. ");
INSERT INTO sch_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Hannirese Pilat'n an kôm, “Imo a tho minchâi?” tiin a rekel ngei nôka. Anni ngei han, “Khrosa jêmdel roh!” tiin ânring uolin an inieka. ");
INSERT INTO sch_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilat'n lokongei râiminsân a nuoma, masikin Barabbas hah a mojôk pe ngeia. Hanchu Jisua hah a vîka male Khrosa jêmdel rangin an kuta a bâng zoia. ");
INSERT INTO sch_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Râlmingei han Jisua hah râiôt inmâi khalâidunga an tuong lûta, an champui ngei murdi an koi mintûpa. ");
INSERT INTO sch_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Jisua hah puon senduk an minsila, riling amachangngei hah tapor an phana, male a lua an minkhuma. ");
INSERT INTO sch_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Hanchu ama chibai an pêka: “Judangei Rêngpa, ringsôt roh!” an tia. ");
INSERT INTO sch_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","A lua tôkmol leh an jêma, an michila, khûkinbilin chibai an mûka. ");
INSERT INTO sch_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Munuiinjanân an sin suole chu puon senduk hah an lîka, male a puonngei nanâk hah an minsil nôka. Hanchu khrosa jêmdel rangin an tuong zoi. ");
INSERT INTO sch_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Hanchu lampuia mi inkhat ram renga khopuilien hongpan a riming Simon an intôngpuia, male râlmingeiin Jisua khros ruput rangin an dânderita. (Simon hah Cyrene Kurini mi, Alexander le Rufus ngei an pa ani.) ");
INSERT INTO sch_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jisua hah Golgotha an ti muna han an tuonga maha aomtie chu “Luru Mun” tina ani. ");
INSERT INTO sch_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ha muna han a pang ânhipna rangin uain murra loi leh ânpol pêk rangin an pûta, aninâkachu Jisua'n nêk jôt mâka. ");
INSERT INTO sch_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Hanchu khrosa an jêmdela, male a puonsilngei hah an insema, kho ahâr ha mo an chang rang chit rietna rangin taruo an sânna. ");
INSERT INTO sch_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jisua an jêmdel zora hah jîng dâr kuo inringa ani. ");
INSERT INTO sch_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ama doia an nônna minrietna chong hah “Judangei Rêngpa” tiin a lu chunga an târra. ");
INSERT INTO sch_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jisua leh munkhatin mi inru inik a changtieng inkhat, male a voitieng inkhat an jêmdel sa. ");
INSERT INTO sch_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ma angdên han, Pathien lekhabu'n, “Ama khom mi puoloingei lâia telsân aom zoi” ati hah ahong tung zoi ani. ");
INSERT INTO sch_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Hataka mingei ânloi murdi'n an lu an thuka Jisua an êroa, “Ohoi! Biekin set na ta, sûnthumin ni minding nôk rang na! ");
INSERT INTO sch_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Atûn khros renga juong chum inla, nethenin insan mojôk roh ba!” an tia. ");
INSERT INTO sch_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ha angdênin ochaisingei le Balam minchupungei khomin Jisua an phengsana, “Midangngei chu a mojôk thei ngâia, hannirese ama le ama chu insan mojôk thei mak! ");
INSERT INTO sch_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tho atûn chu Messiah, Israelngei rêngpa hih khros lêr renga a juong chum lei en rei u, male ama ei iem rang ani!” an tia. Ama leh an jêmdel sa mi inik ngei khomin Jisua an êro sa zoi. ");
INSERT INTO sch_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Sûnchima konta inthum sûng chu rammuol ajîng khapa. ");
INSERT INTO sch_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Chonûk dâr inthum inring han chu Jisua rôl inringtakin ân-ieka, “Eloi, Eloi, lama sabakthani?” a tia, maha, “Ka Pathien, ka Pathien, Ithomo mi ni mâksana?” tina ani. ");
INSERT INTO sch_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ha muna omngei senkhatin a he an rieta, male “Rangâi ta u, Elijah a koi ke!” an tia. ");
INSERT INTO sch_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","An lâia mi inkhat a tânna, patjôn, uain thûra a michiejûta, tôkmol monga a târra. Hanchu Jisua ner a hong min tônna, male “La ôt rei u! Khros renga ama musum rangin Elijah mo a juong pe lei en rei u!” a tia. ");
INSERT INTO sch_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jisua'n rôl inringtakin ân-ieka, a rangachat zoi. ");
INSERT INTO sch_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Hanchu, Biekina puondal dûnga om hah inikin achung renga among dênin akêr phata. ");
INSERT INTO sch_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Râlmi ulien khros motona ândingpu hah Jisua a rangachat tie hah a mua “Hi mi hih Pathien Nâipasal ani khet!” a tia. ");
INSERT INTO sch_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ha muna, nupang senkhat ngei khom alazanna renga thîrin an oma; ma ngei hah Mary Magdalene, Mary Jacob nâipang le Joseph ngei an nû, le Salome ngei an ni. ");
INSERT INTO sch_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ma ngei hah Jisua Galilee rama a om lâihan an jûi ngâia, male an san ngâi ani. Nupang tamtak Jerusalema ama leh a se ngei khom hah an om sa. ");
INSERT INTO sch_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Kholoi ahongnin chu Arimathea mi Joseph a hongtunga. Ama hah Roijêkpungei lâia jâ omtak ania, Pathien Rêngram juong tung rang lei ngâkpu ani. Maha Incherêlni (maha, Sabbathni motona sûn hah ani), masikin Joseph'n hâitakin Pilat kôm a va sea Jisua ruok ha ava zonga. ");
INSERT INTO sch_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilat'n Jisua chu a thi zoi tiin a riet lehan a kamâm tataka, râlmi ulien inkhat a koia, Jisua thina asôt zoi mo? tiin a rekela. ");
INSERT INTO sch_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Râlmi ulien bâi renga chong ânthârin a riet suole chu a ruok hah Joseph chôi rangin a phal pe zoia. ");
INSERT INTO sch_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Joseph'n rosompuon a rochôka, ruok hah a musuma, rosompuon lehan a tuoma, lungpuia hel thânkhura han a min jâla. Hanchu thân kotbâi hah lung lienpa muluoiin a hîpa. ");
INSERT INTO sch_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mary Magdalene le Joseph nû Mary han Jisua ruok an min jâlna hah an ena, an mu chien zoi ani. ");
INSERT INTO sch_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabbathni avun suole chu Mary Magdalene, Jacob nû Mary, le Salome ngei han Jisua ruok sariek va pol rangin mirimhoi an rochôka. ");
INSERT INTO sch_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pathienni jînga nisa suok chakin thâna an va sea. ");
INSERT INTO sch_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Lampuia han, “Thân kotbâia lung hah tumo mi muluoi pai pe rang hi?” tiin annin kereng inlôma. ");
INSERT INTO sch_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Maha lung lienpa ani sikin. Hanchu an hong ena, lung hah lei muluoi saiin an mua. ");
INSERT INTO sch_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Masikin thân sûnga han an lûta, ruotharte inkhat puonchek insilin chang tienga insungin an mua, male an inlâiraka. ");
INSERT INTO sch_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ama'n an kôm, “Inlâirak no roi,” Nazareth Jisua an jêmdelpu hah nin rok ani ti ki riet. Ama hah mahin om khâi maka, ânthoinôk zoi! En ta u, an min jâlna hi. ");
INSERT INTO sch_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Atûn, se ungla, hi thurchi hih a ruoisingei le Peter kôm han: “Galilee rama nin motona se a ta; ‘nangni a lei ril sai anghan mason mu nin tih’ tiin va ril ngei roi” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Masikin an jôk paia, beidong le rathatâk pumin thân renga an tânna. An chi rai sikin, tute kôm ite ti mak ngei.  ");
INSERT INTO sch_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Masuole chu Pathienni jînga thina renga ânthoinôka Mary Magdalene, a sûng renga ramkhoringei sari a rujûlpai pe nu kôm han amotontaka Jisua ânlâra. ");
INSERT INTO sch_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Amanu hah a sea, a champuingei ava ril ngeia. Anni ngei hah ngâisie le chapin an lei oma; ");
INSERT INTO sch_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","male amanu han Jisua chu aring nôk zoia, male mu khom ku mu khet, a tipe ngei lâihan anni ngei han amanu hah iem mak ngei. ");
INSERT INTO sch_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Masuole han an lâia mi inik ram tieng panin an sea, lampuia mêl dang uolin an kôm ânlâra. ");
INSERT INTO sch_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Anni hah an hongkîra, ruoisi dangngei an hong rila, aniatachu maha khom anni ngei han iem uol mak ngei. ");
INSERT INTO sch_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Anûktaka chu, Jisua'n ruoisi sômleikhat ngei bu an nêk lâitakin an kôm ânlâr nôka. Ânthoinôk suole amu ngei chong taksôn loiin an mulung angar sabak sika le iemna reng an dôn loi sikin a ngo ngeia. ");
INSERT INTO sch_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ama'n an kôm, “Rammuol pumpuia se ungla, mi murdi kôm Thurchisa hih va misîr roi a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tukhom ama iema Baptisma chang ngei chu sanminjôkin om an ta; tukhom a iem loi ngei chu theiloi intumin om an tih. ");
INSERT INTO sch_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Iempungei chu sininkhêlngei sintheina ranak pêk nîng an ta: ki rimingin ramkhoringei rujûlpai an ta; chong tharin chong an tih; ");
INSERT INTO sch_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","an kutngei leh murûlngei an sûr khomin, aninônchu tûr an nêk khomin itên minna ngei thei no nia; mi damloi ngei chunga an kutngei minngam an ta, male dam kelen an tih” a tia. ");
INSERT INTO sch_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pumapa Jisua'n a chongpui ngei suole chu, invâna khin lâkpaiin aoma, Pathien chang tieng a hong insung zoia. ");
INSERT INTO sch_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ruoisingei hah an sea male muntina thurchi an va misîr zoia, male Pumapa khomin anni ngei lehan sin a thopui ngeia, an thurchi misîr hah adik ti rietnân sininkhêlngeiin a mindet tir zoi. ");
INSERT INTO sch_vpl VALUES ("MK16_21","071_16_21","MRK","16","21","21","Nuvengtengei hah Peter le a malngei kôm an sea, male rila an om murdi hah abongkikin an misîr pe ngeia. ");
INSERT INTO sch_vpl VALUES ("MK16_22","071_16_22","MRK","16","22","22","Masuole han, Jisua nanâkin a ruoisingei ha kumtuong Sanminringna aringtit chongbe inthieng hah nisuo renga nitâk dênin misîr rangin a tîr ngei zoi.");
INSERT INTO sch_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Moroitak Theophilus, ei lâia roi juong tung, mi tamtak ngeiin theidôr miziek rangin an pûta. ");
INSERT INTO sch_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Aphut renga ha neinunngei amu ngeiin kin lei ril le chong lei phuong anghan an miziek ani. ");
INSERT INTO sch_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Masikin nangma Mirittak, abul renga jâttin ânthârlaka sûiin adônin inthârlakin nata rangin miziek ronga ki ti ani. ");
INSERT INTO sch_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Tienna thurchi nang an lei ril hah adiktak ani iti na riet theina rangin. ");
INSERT INTO sch_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judea rama Herod rêngin an lallâiin, ochai a riming Zakariah a oma, ama hah ochai Abijah rûia mi ania, a lômnu riming chu Elizabeth ania, Aaron ochairûia mi ani. ");
INSERT INTO sch_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","An ruonin Pathien mitmun mi diktakin an omma, demnaboiin Pumapa balam le a chong jômin an om ani. ");
INSERT INTO sch_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Hannisenla Elizabeth aching sikin nâi nei maka, an ruonin an tar ok zoia. ");
INSERT INTO sch_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Hanchu sûnkhat chu Zakariah hah nîngtina asin ngâi angin Biekina ochai sin a thoa. ");
INSERT INTO sch_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ochaingei balam angin mirimhoi hâl rangin taruo sânin ama hah thangin a oma, masikin Pumapa Biekina a sea. ");
INSERT INTO sch_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mirimhoi a hâl lâiin mipui ngeiin apêntieng chubai an lei thoa. ");
INSERT INTO sch_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mirimhoi hâlna mâichâm changtienga han, Pumapa vântîrton indingin a kôm a juong inlâra. ");
INSERT INTO sch_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakariah'n amu lehan rolo innîkin a chia. ");
INSERT INTO sch_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Hannisenla, vântîrton han a kôma, “Zakariah chi no roh, ne ngênna Pathien'n a rieta, no lômnu Elizabeth'n nâi nang nei pe a ta a riming John ni phuo rang ani. ");
INSERT INTO sch_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","A suokin chu nangma le mi tamtak mulungrîl râisân atih. ");
INSERT INTO sch_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Pumapa mitmûn milien nîng a ta, uain le jûngei reng nêk no nia. A suokni renga Ratha Inthiengin sip a ta, ");
INSERT INTO sch_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Isreal mi tamtak Pumapa an Pathien tieng hong tuong nôk a tih. ");
INSERT INTO sch_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Dêipu Elijah anghan rât le hâitakin Pumapa motona sêng a tih. Pangei le nâingei minmun nôk a ta, chongjômloi mingei mindonna satna tieng min hei a ta, Pumapa mingei ata rangin min thokdiem a tih” a tia. ");
INSERT INTO sch_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakariah'n vântîrton kôma han, “mahah inmo ki riet rang? keima laka ka tar zoia, ko lômnu khom a tar zoia,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Vântîrton han, “Pathien makunga inding ngâi Gabriel ki nia, hi thurchi nang ril rang piela juongtîr ki ni. ");
INSERT INTO sch_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Hi chong azora taka juong tung rang ni iemloi sikin, ajuong tung mâka chu chong theiloiin dâirekin om ni tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mipui ngeiin kholâia an lei ngâka, Biekin sûnga Zechariah a om sôt rai sikin an lei kamâma. ");
INSERT INTO sch_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","A hong jôk tena chu a chong thei khâiloi sikin Biekina inlârna ai mu iti an rieta, a kut leh vai a chong zoia. ");
INSERT INTO sch_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Biekina a sin rang a zoi suole chu a in tieng a kîr zoia. ");
INSERT INTO sch_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Môrkhat suoleh chu a lômnu Elizabeth nâi a vong zoia, thâ rangnga tuol suok loiin a oma. ");
INSERT INTO sch_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Anûktaka Pumapa'n mi san nôk zoi, ki riming siet, sût minthelna rangin” a tia. ");
INSERT INTO sch_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabeth nâivong, atha ruk nân chu Pathien'n a vântîrton Gabriel Galilee ram Nazareth khopuia a tîra. ");
INSERT INTO sch_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Rêng David rûia mi Joseph lômnu biek dôngmate Mary kôma chong juong ichôiin. ");
INSERT INTO sch_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mary kôma a lûta, “Nu chunga ratha inngamna om rese! Pumapa nu chunga a om, sat nang a vur ok” a tia. ");
INSERT INTO sch_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ha chong hah a rieta anîn chu imo ani zoi, tiin a mulung a minjîng oka. ");
INSERT INTO sch_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Hanchu, vântîrton han, “Mary chi no roh, Pathien'n ai minlut tak mi nini. ");
INSERT INTO sch_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nâivong na ta, nâipasal nei na ta, a riming Jisua ni phuo rang ani. ");
INSERT INTO sch_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mi lien nîng a ta, Ânchungtaka Pathien nâi tîng an tih. Pumapa Pathien'n David anghan Rêng minchang a tih. ");
INSERT INTO sch_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jakob richingei chunga rêngin om a ta, ânlalna ramin mong tik nei khâi no nih” a tia. ");
INSERT INTO sch_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Hanchu Mary'n vântîrton kôma, “Mahah kho angin mo anithei ranga? dôngmate kêng ka lani hite” a tia. ");
INSERT INTO sch_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Vântîrton han a thuona, “Ratha Inthieng nu chunga juong a ta, Pathien Ratha nu chunga om a tih. Masikin kêng nâite inthieng khom Pathien Nâipasala be ani rang. ");
INSERT INTO sch_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nu juorpuinu Elizabeth khom aching an iti hah, a tar ok khoma a nâivongna thâ ruk ani zoi. ");
INSERT INTO sch_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Asikchu Pathien chu ite a tho theiloi omak,” a ti pea. ");
INSERT INTO sch_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Hanchu, Mary'n, “Pumapa tîrlâmnu ki ni, ni ti lam angtakin ku chunga tung rese,” a tia. Masuole chu vântîrton han ama amâk zoi. ");
INSERT INTO sch_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Masuole inrangin Mary ânthoka, Judea rama khopui inkhata a se zoia. ");
INSERT INTO sch_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zakariah ina a lûta, Elizabeth chibai amûka. ");
INSERT INTO sch_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabeth'n Mary chibaimûk a riet lehan a sûnga nâite hah singânsa, Elizabeth Ratha Inthiengin a sipa. ");
INSERT INTO sch_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Hanchu rôl inring takin ânieka, “Nang chu nupang lâia mi satvur tak ni nia, na nâivong rang khom hih satvur ani. ");
INSERT INTO sch_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ka Pumapa nûn ni na hongpan hih i ang tak mo ai ni zoi hi? ");
INSERT INTO sch_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nu chibaimûk ki riet lehan ku sûnga nâite râisânin ânchôm ani. ");
INSERT INTO sch_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Pumapa chongbê na chunga tung rang ni iem sikin mi satvur ni ni” a tia. ");
INSERT INTO sch_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Hanchu Mary'n “ka mulungin Pumapa a minpâka, ");
INSERT INTO sch_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ki ringnân khom Minringpu Pathien chunga a râisân ok zoi. ");
INSERT INTO sch_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","A tîrlâmnu intem tie a riettit sikin! Atûn renga chu mitinin satvur ni tîng an tih. ");
INSERT INTO sch_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Sinthothei Pathien han ku chunga sin lientak a thoa, A riming khom ânthieng ani. ");
INSERT INTO sch_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ruol athar renga ruol thoithar nôk idênin, Ama mirit ngei chu a moroi ngâia, ");
INSERT INTO sch_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","A bân ranak an chunga a jâra, Mi inpâk ngei chu an mintuona ngei leh chekaminchâi ngâia. ");
INSERT INTO sch_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","An sukmun renga rêng alien ngei a kaisuma, Rangâichîn ngei chu a domsâng zoia. ");
INSERT INTO sch_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Vonchâmngei chu neinun sân a vâi minkhopa, Ânchongngei chu kut korongin a min rot ngei zoia. ");
INSERT INTO sch_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ei richibulngei kôma a chonginkhâm anghan, A tîrlâm Isrealngei san rangin a juong zoi. ");
INSERT INTO sch_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Abraham le a richingei kumkhuon a moroi tie riettitna rangin” a tia. ");
INSERT INTO sch_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mary hah Elizabeth kôm thâ thum a oma, hanchu a in tieng a se nôk zoi. ");
INSERT INTO sch_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elizabeth nâinei zora ahong chukin chu nâipasal a neia, ");
INSERT INTO sch_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","A bungmingei le a suongsuokngeiin, Pumapa'n lungkham a mu ok iti an rieta, an râisân puia. ");
INSERT INTO sch_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Hanchu, sûnriet anîn chu nâite sertan rangin an honga, a pa riming pêlin Zakariah nanâk phuo rang an tia, ");
INSERT INTO sch_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Hannisenla, a nûn “nithei nonih, a riming chu John kêng” a tia. ");
INSERT INTO sch_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Annin, “Hi anga riming hih nin suongsuokngei lâia khom la om ngâi mak” an tipea. ");
INSERT INTO sch_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Maleh a pa kôm han kut leh an chongpuia, nâite riming hah imo ai phuo nuom, tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakariah'n a miziekna rang neinun a zonga, a riming chu John ani tiin a mizieka; an kamâm sabaka. ");
INSERT INTO sch_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Harenghan, Zakariah hah a hong chong thei zoia, Pathien a minpâk kelen zoi. ");
INSERT INTO sch_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","An kôl revêla om ngei murdi'n an chia, ha thurchi hah Judea tângram muntina ânthang zoia. ");
INSERT INTO sch_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ariet nâmin hi nâite hih i ang takin mo a hong ni rang na? Pumapa sinthotheina ranak laka a chunga a oma, an tia. ");
INSERT INTO sch_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","John a pa Zakariah hah Ratha Inthiengin a sipa, Pathien chong a phuonga. ");
INSERT INTO sch_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Pumapa, Isreal Pathien chu minpâk ei tih u, A mingei san rangin a juonga, a mojôk ngei zoi. ");
INSERT INTO sch_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","A tîrlâm David richi renga jôkna riki mi pêk zoi. ");
INSERT INTO sch_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Zora sôt tak renga dêipungei kôma a lei khâm anga han, ");
INSERT INTO sch_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ei râlngei le mi demngei renga mi mojôka, ");
INSERT INTO sch_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","A chongkhâm inthieng ei richibulngei kôma minlang rang ai ti riet titin. ");
INSERT INTO sch_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Ei richibul Abraham kôma a chongkhâm ei râlngei renga mi san minjôka, chi loia a sin ei tho theina rang le, ");
INSERT INTO sch_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ei damsûnga a mitmua inthieng le adika ei om theina rangin. ");
INSERT INTO sch_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nangma ka nâi, Ânchungtaka Dêipu nang tîng an ta, A lampui sin rangin, Pumapa motona sêng ni tih. ");
INSERT INTO sch_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","A mingei an sietna ngâidama omin, Sanminringna chong ril ni tih. ");
INSERT INTO sch_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ei Pathien chu mi lungkham thei le moroithei ania, Masikin ei rangin sanminringna khuovâr mi minsuok pe a ta; ");
INSERT INTO sch_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Thina dâilîm ijîngna nuioa omngei, Invân renga êlminvâr a ta, Ei kalchôina rathangamna lampui tieng mi tuong a tih” a tia. ");
INSERT INTO sch_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Hanchu, nâite hah taksa le ratha tieng a hong insôn tira, Isreal mingei lâia ânlâr mâka chu ramchâra a om ani. ");
INSERT INTO sch_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Malâiahan, Rêng Caesar Augustus Rom sorkar ramop murdi riming miziek rangin chong a pêka. ");
INSERT INTO sch_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Hi intelnapui motontak hi syria rama Kuirinius governor chang lâitak ani. ");
INSERT INTO sch_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mitinin anni khopui chita riming miziek rangin an sea. ");
INSERT INTO sch_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Joseph khom David inkuo le a richia mi ani sikin, a lômnu biek Mary inrâidîm lehan Galilee ram Nazareth khopui renga Judea ram, David suokna, Bethlehem khopuia riming miziek rangin an sea. ");
INSERT INTO sch_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Hanchu, Bethlehem'a an om lâitakin nâi nei zorân a hong de zoia. ");
INSERT INTO sch_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nâilutîr pasal a neia, puon leh a thoma, khuol tung in an keng khâiloi sikin sa bukhênga a min jâl zoi. ");
INSERT INTO sch_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ma rama han, belrihôlngei jâna an belri ngâkin rajâia an oma. ");
INSERT INTO sch_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Pumapa vântîrton a juong inlâra, Pumapa roiinpuina vârin a êla, rolo innîkin an chia. ");
INSERT INTO sch_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Vântîrtonin, “chi no roi, Thurchisa râisân omtak ninta rang le mitin ta rang ku juong mintung kêng. ");
INSERT INTO sch_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Avien hin David khopuia Minringpu, Pumapa Khrista a suok zoi. ");
INSERT INTO sch_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Sîn nin tho theina rang chu, nâitesen, puona thom sakhênga jâlin mûng nin tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Harenghan, vântîrton kôma han, invân râlmingei tamtak an juong oma, Pathien an minpâka. ");
INSERT INTO sch_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Invân Ânchung taka Pathien Roiinpui rese. Philchunga a râisânna ngei chunga inngêina lêng rese,” an tia. ");
INSERT INTO sch_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Hanchu, vântîrtonngeiin an mâk ngei lechu, belrihôlngei han, Pumapa'n mi ril, neinun juongtung a en rangin, Bethlehem'a se ei ti u, an tia. ");
INSERT INTO sch_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Hanchu, an se laia, Mary le Joseph le sakhênga jâl nâite hah an va mua. ");
INSERT INTO sch_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Vântîrtonin, nâite chungroi ai rilngei hah belrihôlngeiin an ril ngeia, ");
INSERT INTO sch_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","a riet ngei murdi'n kamâm a om tatak an tia. ");
INSERT INTO sch_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mary'n ha chong ngei hah a mulungrîla mindonin a vong tita. ");
INSERT INTO sch_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Vântîrtonin a rilngei lam takin jâttinrêng an va mua, an riet sikin Pathien minpâk pumin an kîr nôk zoi. ");
INSERT INTO sch_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Hanchu sertan rang ni sûn riet a hong chukin chu, sûnga a om lâia vântîrtonin ai phuo sai, a riming, Jisua an phuo zoia. ");
INSERT INTO sch_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moses balam chongpêk angin minthieng rang ni ahong chukin chu, Joseph le Mary'n an nâite Pumapa kôma minlang rangin Jerusalem Biekina an hong puia. ");
INSERT INTO sch_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Balam lekhabua, “Nâilutîr pasal kai chu Pumapa ta rang ani,” itia ânziek anghan. ");
INSERT INTO sch_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Pumapa balam anghan vasu bop khat mo, pharvali bop khat mo, an pêk sa rang ani. ");
INSERT INTO sch_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ma zora han Jerusalema a riming Simeon an ti a oma, ha mi hah mi sa, Pathien minlut mi tak ania, Isreal jôk rang ni ngâkin, a chunga Ratha Inthieng a oma. ");
INSERT INTO sch_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Pumapa chonginkhâm, Messiah a mu mâka thi no nih, itia inkhâm ani. ");
INSERT INTO sch_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ratha ruoiin Simeon hah Biekina a sea. Balam anga achunga sin rangin a nû le a pa'n nâite Jisua, Biekina an hong puia. ");
INSERT INTO sch_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon'n nâite a poma, Pathien kôm râisânchong a rila; ");
INSERT INTO sch_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Pumapa, atûn chu no chongkhâm angin, Ni tîrlâm hih rathangamin ni na man se rang ani zoi. ");
INSERT INTO sch_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ki mit lelên na sanminringna a mu zoi, ");
INSERT INTO sch_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Mitin mu ranga ni mintuo hah. ");
INSERT INTO sch_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nu lungdo, Jentailngei kôma inlang rang vâr le Ni mi Isrealngei roiinpuina rang chu” a tia. ");
INSERT INTO sch_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nâite chungroi Simeon'n ai misîr hah a nu le a pa'n an kamâm sabak ani. ");
INSERT INTO sch_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Hanchu Simeon'n, sat a vura, a nu Mary kôma, “Hi nâite hih Pathien ithang, Isreal lâia mi tamtak inmangna rang le jôkna rang ani. Pathien sînthona mi tamtak ngei makhal rang nîng a tih. ");
INSERT INTO sch_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Mi mindonna inthup minlang a ta, khandai angai angin ngâisietnân na mulung sunkhoi a tih,” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Mahan dêipu meithâi atar inkhat, a riming Anna an ti, Asher rûia mi, Phanuel nâinupang a oma. kum sari vai inneiin a oma, kum sômriet minli meithâiin a oma. Biekin mâk loiin a sûn a jânin bu ngêia Pathien Biekina, chubai thôn a om ngâia. ");
INSERT INTO sch_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ma zora taka han a hongtunga, Pathien kôm râisânchong a rila, Jerusalem jôkna ranga Pathien lei ngâk ngei kôma khom nâipang Jisua thurchi a misîr pe sa zoi. ");
INSERT INTO sch_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Pumapa balam chongpêka, an thotum an tho zoiin chu Joseph le Mary hah Galilee rama, an khuo Nazareth'a an kîr nôk zoi. ");
INSERT INTO sch_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Hanchu, nâite hah a hong liena a hong rât tira, vârnân a sipa, Pathien satvurnangei a chunga a oma. ");
INSERT INTO sch_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kumtin, Jisua nû le pa Kalkân kût mang rangin Jerusalema an se ngâia. ");
INSERT INTO sch_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jisua hah kum sômleinik a hong nîn chu, kûta an hong se puia. ");
INSERT INTO sch_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kût aheka anîn chu an juongkîr pui nôka, ania Jisua chu Jerusalema ala châma, a nû le a pa lakin riet mak ngeia. ");
INSERT INTO sch_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","A lômngei lâia se nîng a tih, tiin an mindona, sûnkhat lam an se suoleh, a ruolngei le an sûngsuokngei kâra an rok titira, ");
INSERT INTO sch_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","anitachu, mu mak ngeia, a rok rangin Jerusalema an kîr nôka. ");
INSERT INTO sch_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","A sûnthum nin chu, Biekina Juda minchupungei kôma insungin, an chong rangâi le chong rekelin an va mu zoia. ");
INSERT INTO sch_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","A vâr taka a chongthuon lam a riet murdi'n an kamâma, ");
INSERT INTO sch_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","A nû le a pan an va mûn chu an kamâma, a nûn a kôma, “Nâia khoithomo hi anga mi no tho, kângdoi takin na pa leh nang kin lei rok bang kêng ani zoi” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","“Ithomo minin rok? Ka Pa ina ko om rang hih nin riet loi mini?” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Hannisenla a thuonna hah a mindona chang riet mak ngeia. ");
INSERT INTO sch_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Hanchu, an kôm Nazareth'a a sea, an chong jômin a oma, a nûn chu neinun omtie ngei nâm a mulungrîla a vong tit ani. ");
INSERT INTO sch_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Hanchu Jisua hah taksa tieng le vârna tieng a hong insôn tir tira, Pathien le miriem mitlûtin a hong om tir zoi. ");
INSERT INTO sch_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Hanchu, Teberius Caesar Rêng chang a kum sômleirangana, Pontius Pilat Judea rama governor ania, Herod Galilee rama ânlal lâiin, A nâipa Philip, Iturea le Trachonitis rama ânlal lâiin, Abilene rama Lysanias ânlal lâia han, ");
INSERT INTO sch_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Annas le Caiaphas ngei hah Ochai Inlal annia. Ma zora lâia han ramchâra Zakaria nâipasal John kôma Pathien chong a juong tunga. ");
INSERT INTO sch_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Hanchu, John'n Jordan Tuidung pang revêl ramtina a se titira, “Nin sietnangei renga insîr ungla baptisma chang roi, hanchu Pathien'n nin sietnangei nangni ngâidam a tih” tiin chong a rila. ");
INSERT INTO sch_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Dêipu Isaiah lekhabua miziek anghan: “Ramchâra mi inkhat iniek rôl han, Pumapa lampui sin ungla, a lôna rang, A lampuingei mintûn roi. ");
INSERT INTO sch_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Vakuong tin minsip nîng ata, Muol, tang tin mincham nîng atih, Lampui akôi ngei mintûn nîng ata, Lampui anthir ngei minnâm nîng atih. ");
INSERT INTO sch_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Hanchu mitinin Pathien sanmingringna mûng an tih.” ");
INSERT INTO sch_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Hanchu, John kôm baptis chang rangin mipuingei an honga, an kôm, “Murûlngei o!” “Pathien dûk juong mintung rang renga jôk rangin tumo nangni ril? ");
INSERT INTO sch_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nin sietnangei nin insîr tatak iti nin nunchana minlang roi, Ei richibul Abraham kêng aninga ti khâi no roi, Pathien'n hi lungngei khom hih Abraham richisuonpârngei a minchang thei. ");
INSERT INTO sch_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Thingkung tin aruzung idêna phûr rangin reipui a om chit ani zoi. Thingkung tin mara sa ânra loi nâm chu phûrpaia meia pai nîng atih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mipuingei han, “Hanchu, Imo kin tho rang ani zoi,” an tia. ");
INSERT INTO sch_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ama'n a thuona, “Kâncholi abop a dônngeiin a dônloingei sem ungla, sâkruo a dônngeiin a dônloingei sem ngei roi” a tia. ");
INSERT INTO sch_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Sum rusuongpungei senkhat baptisma chang rangin an honga, a kôma, “Minchupu, imo kin tho rang?” an tia. ");
INSERT INTO sch_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","“Balam pêna chu rusuong no roi” a tia. ");
INSERT INTO sch_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Râlmingei khom an honga a kôm, “Keinite imo kin tho rang?” an tia. An kôma, “Tute sum rangrâtin lâk no ungla, dikloiin mi nôn no ungla, nin loa han nin mulung minchuk roi,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mipuingeiin John chungroia sabeina neiin, Messiah ai ni duoi mini tiin an mindona. ");
INSERT INTO sch_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Hanchu, John'n, “Keiman chu tuiin nangni ka baptis ngâia, keima nêka roiinpui uol mi a juong ani. Keima chu a kekok sût rang luon inhoi mu-ung. Ama han Ratha Inthieng le meiin nangni baptis a tih,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","“A jâpna rang relei a chôia, jâp a ta, butak hah sapanga thun a ta, arishi kai chu mei thi ngâiloia hâl minmang a tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","An om lam thûlna rang mohôknân lam tamtakin thurchi Sa a ril ngeia. ");
INSERT INTO sch_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Herod'n neinun tamtak saloi a tho pênah, a nâipa Philip lômnu Herodias lômnua a nei sikin John'n a ngoa. ");
INSERT INTO sch_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ma nêka saloi uol thôn, Herod'n, John hah intâng ina a khum zoi. ");
INSERT INTO sch_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Hanchu mipui murdi baptisma an chang zoiin, Jisua khom baptisma a changa. Chubai a tho lâitakin, invân ân onga. ");
INSERT INTO sch_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Pharvali angin, Ratha Inthieng a chunga a juongchuma, Invân renga chong ajuon ringa, “Ka nâipasal moroitak ni ni, na chunga ku mulung arâisân ok,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jisua'n a sin a phuta han kum sômthum a nia. Mi mindonin chu Joseph nâipasal ania. Ama hah Heli nâipasal ania, ");
INSERT INTO sch_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ama hah Mathat nâipasal ania, Ama hah Levi nâipasal ania, Ama hah Melchi nâipasal ania, Ama hah Janna nâipasal ania, Ama hah Joseph nâipasal ani. ");
INSERT INTO sch_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ama hah Mattathias nâipasal ania, Ama hah Amos nâipasal ania, Ama hah Nahum nâipasal ania, Ama hah Esli nâipasal ania, Ama hah Naggai nâipasal ania, ");
INSERT INTO sch_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ama hah Maath nâipasal ania, Ama hah Mattathias nâipasal ania, Ama hah Semein nâipasal ania, Ama hah Josech nâipasal ania, Ama hah Joda nâipasal ania, ");
INSERT INTO sch_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ama hah Joanan nâipasal ania, Ama hah Rhesa nâipasal ania, Ama hah Zerubbabel nâipasal ania, Ama hah Shealtiel nâipasal ania, Ama hah Neri nâipasal ani. ");
INSERT INTO sch_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ama hah Melchi nâipasal ania, Ama hah Addi nâipasal ania, Ama hah Cosam nâipasal ania, Ama hah Elmadam nâipasal ania, Ama hah Er nâipasal ani. ");
INSERT INTO sch_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ama hah Joshua nâipasal ania, Ama hah Eliezer nâipasal ania, Ama hah Jorim nâipasal ania, Ama hah Matthat nâipasal ania, Ama hah Levi nâipasal ania, ");
INSERT INTO sch_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ama hah Simeon nâipasal ania, Ama hah Judah nâipasal ania, Ama hah Joseph nâipasal ania, Ama hah Jonam nâipasal ania, Ama hah Eliakim nâipasal ani. ");
INSERT INTO sch_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ama hah Melea nâipasal ania, Ama hah Menna nâipasal ania, Ama hah Mattatha nâipasal ania, Ama hah Nathan nâipasal ania, Ama hah David nâipasal ani. ");
INSERT INTO sch_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ama hah Jesse nâipasal ania, Ama hah Obed nâipasal ania, Ama hah Boaz nâipasal ania, Ama hah Salmon nâipasal ania, Ama hah Nahshon nâipasal ania, ");
INSERT INTO sch_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ama hah Aminadab nâipasal, Ama hah Admin nâipasal ania, Amah hah Arni nâipasal ania, Ama hah Hezron nâipasal ania, Ama hah Perez nâipasal ania, Ama hah Judah nâipasal ania, ");
INSERT INTO sch_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ama hah Jokob nâipasal ania, Ama hah Isaac nâipasal ania, Ama hah Abraham nâipasal ania, Ama hah Terah nâipasal ania, Ama hah Nahor nâipasal ania, ");
INSERT INTO sch_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ama hah Serug nâipasal ania, Ama hah Reu nâipasal ania, Ama hah Peleg nâipasal ania, Ama hah Eber nâipasal ania, Ama hah Shelah nâipasal ania, ");
INSERT INTO sch_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ama hah Cainan nâipasal ania, Ama hah Arphaxad nâipasal ania, Ama Shem nâipasal ania, Ama hah Noah nâipasal ania, Ama hah Lamech nâipasal ania, ");
INSERT INTO sch_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ama hah Methusela nâipasal ania, Ama hah Enoch nâipasal ania, Ama hah Jared nâipasal ania, Ama hah Mahalaleel nâipasal ania, Ama hah Kenan nâipasal ania, ");
INSERT INTO sch_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ama hah Enosh nâipasal ania, Ama hah Seth nâipasal ania, Ama hah Adam nâipasal ania, Ama hah Pathien nâipasal ani. ");
INSERT INTO sch_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ratha Inthienga sipin, Jisua hah Jordan dung renga a hongkîra, Ratha ruoiin ramchâra han a se zoia. ");
INSERT INTO sch_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Mahan Diabolin, sûn sômminli a methêma, ma zora han ite a sâk loi sikin a von achâm sabak zoia. ");
INSERT INTO sch_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Diabolin, a kôma, “Pathien Nâi ni nîn chu hi lung hih vâipôl manchang roh,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jisua'n a thuona, “Pathien lekhabu'n, vaîpôl riemin miriem ring thei nonih ati,” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Hanchu, Diabolin, muol insângpa taka a tuong nôka, rammuol pumpuia rêngramngei phûkhatin a min ena. ");
INSERT INTO sch_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","A kôma, “Hi ngei chunga rachamneinangei le rochonngei hi nang pêk ki tih, ko kôma ipêk ani zoi, ku nunuom kôm ke pêk thei. ");
INSERT INTO sch_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Chubai ni mûk inla anrêngin nang pêk let ki tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jisua'n, “Pumapa na Pathien mang chubai mûk inla, ama sin mang tho roh ati,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Hanchu, Diabolin Jerusalema a tuonga, Biekin sîp ânzumna taka a dara, “Pathien Nâi ni nîn chu inchôm roh, ");
INSERT INTO sch_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Lekhabu'n, Pathien'n a vântîrtonngei nang dom rangin juongtîr a ta, ");
INSERT INTO sch_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","an kutin nang dom an ta, ne ke khom lungin inde no tinih ati,” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jisua'n, Lekhabua, “Pumapa na Pathien minsin no roh, ai ti kêng,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","A methêmna rang murdia a methêm zoiin chu, Diabolin chuminrên danga rangin a mâk zoi. ");
INSERT INTO sch_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Hanchu, Jisua hah Ratha Inthieng sinthotheina neiin Galilee rama a kîr nôka, ha ram sûnga han a thurchi ânthang zoia. ");
INSERT INTO sch_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Inkhom inngeia mi a minchu ngeia, mi murdi minpâkin a oma. ");
INSERT INTO sch_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Hanchu, Jisua hah a seilienna khuo Nazereth'a a sea, Sabathnia a tho ngâi lamin Synagog taka a sea, Pathien lekhabu pore rangin ândinga. ");
INSERT INTO sch_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Dêipu Isaiah lekhabu an pêka, lekha zuot hah a phara, hi miziek omna hih a porea. ");
INSERT INTO sch_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Inriengngei kôma Thurchisa misîr rangin mi thangsuok sikin, Pumapa ratha ka chunga a om, Suoka ântâng ngei kôma jôkna chong min phuong rangin ni tîr ani. Mitcho ngei mit vâr nôkna rang le mi nuomlo ngei jôkna rangin, ");
INSERT INTO sch_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Pumapa'n a mingei an jôkna rang zora a hongtung zoi iti phuongsa rangin,” iti hih. ");
INSERT INTO sch_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Hanchu Jisua'n lekha hah a juota, adarpu a pêka, ânsunga, Inkhom ina mi murdi mit ama chunga korong an ena. ");
INSERT INTO sch_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Hanchu an kôma, “Hi lekhabu nin kôma porea om hih avien hin adikin nin kôma a hongtung zoi,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","A chongbâi suok lungkham chong misîrin, an mulungrîl a tôna, kamâm a om an tia, “Hi mi hih Joseph nâipasal nimak mo?” an tia. ");
INSERT INTO sch_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Hanchu an kôm, nangnin hi chongmintêk, “Doctor, nethenin indam roh, Capernaum'a ni sinthongei, kin lei riet ngei khom hah hin na khuoa hin sin roh, ni la ti ngêt nin tih” a tia. ");
INSERT INTO sch_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jisua'n, “Adiktakin nangni ki ti, Dêipu, tutên anni khuoa modôm ngâi mak ngei,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Rangâi ta u, hih adik ani, Elijah zora lâiin Isreal rama meithâi tamtak an oma, kumthum in-ang ruo juong loiin a oma, an ram pumpui mâitâm achula. ");
INSERT INTO sch_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Isreal rama meithâi inkhat Sidon rama Zarephath khuomi kôma tiloi chu Elijah hah tute kôma itîr ni mak. ");
INSERT INTO sch_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Dêipu Elisha zora lai khomin Isreal rama mi phâr tamtak an oma, hannisenla, tute dam loiin, Syria rama Naaman mang kêng mindamin a om,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Synagog mipuingei han, a chong hah an rietin chu an ningthik oka, ");
INSERT INTO sch_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","an inthoia, an khopui rôlsora namthâk rangin khopui renga an mojôk paia. ");
INSERT INTO sch_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Hannisenla, mipuingei lâi renga a relpaia, a rotpat zoi. ");
INSERT INTO sch_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Hanchu, Jisua Galilee rama Capernaum khopuia a sea, Sabathnin mingei a minchua. ");
INSERT INTO sch_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Rachamnei taka a minchu sikin an kamâm oka. ");
INSERT INTO sch_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Synagog taka han mi inkhat ramkhori ratha dôn a oma, rôl inring takin ânieka. ");
INSERT INTO sch_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“O! Nazereth Jisua, Imo lo rang mini ti? Mi minmang ranga hong mo nini? Nang ki riet, Pathien tîrton inthieng nini!” a tia. ");
INSERT INTO sch_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jisua'n, “Dairek inla, a sûng renga hong jôk roh!” a tia. Ramkhori han an makunga, a minjuon raka, min na loiin a sûng renga a hong jôk zoia. ");
INSERT INTO sch_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","An rêngin an kamâma, “Khoi chongbai tak mo ani zoi? roinei le rachamneia ramkhoringei chong a pêka an hongjôk hi,” an intia. ");
INSERT INTO sch_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Hanchu ha rama han mun tina Jisua riming ânthang zoia. ");
INSERT INTO sch_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Hanchu, Jisua Synagog renga a jôka, Simon ina a sea. Simon tarpi ritun inrik taka nân a lei oma, ama rangin Jisua an ngên pea. ");
INSERT INTO sch_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","A kôla avan dinga, a ritun hah a ngoa, a natna, harenghan a hong boia, ânthoia anni ngei sin a tho pe ngei zoi. ");
INSERT INTO sch_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Hanchu kholoi nisa tak nûkin, natna tin renga damloingei Jisua kôma an hong tuonga, an chung chita a kut a minngama a mindam ngei rieia. ");
INSERT INTO sch_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Hanchu “Pathien Nâipasal nini,” itia iniekin ramkhoringei khom mingei sûng renga an jôkpai zoia, Messiah ani iti an riet sikin, Jisua'n ramkhoringei hah an chong rang phal ngei mak. ");
INSERT INTO sch_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Hanchu khuo ahongvârin chu, khopui a mâka mun inthimna a sea, mipuingeiin an roka, an mûn chu, anni mâk loia la châm rangin an pûta. ");
INSERT INTO sch_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Hannisenla, Jisua'n an kôma, “Pathien Rêngram Thurchisa hih khopui adadangei khoma misîr rang piela itîr kêng ki ni,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Hanchu, Galilee rama Synagog tina thurchi a misîr zoi. ");
INSERT INTO sch_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Sûnkhat chu, Jisua Genesaret dîl rakhama ândinga, mipuingeiin Pathien chong rangâi rangin an neng ruruia. ");
INSERT INTO sch_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Tuipanga, ngasûrpungeiin an lên an rusûk kâra an lei mâk rukuong inik a mua. ");
INSERT INTO sch_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Simon rukuong lelea han a chuonga, a kôm, tuipang renga intôl viet rangin a ngêna, hanchu, rukuonga ânsunga, mipuingei a minchu ngeia. ");
INSERT INTO sch_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","A chong zoiin chu Simon kôma, “Tui inthûkna tieng rukuong min se inla, nga sûr rangin nin lênngei vôr roi,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","“Pumapa, jân sôt kin vôra ite man makme, nikhomrese, no chongpêkin lênngei vor nôk ki tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Hanchu an vôra anin chu, nga tam sabak an khuma, an lênngei achet vavânga. ");
INSERT INTO sch_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Asân rangin rukuong danga an lômngei kutin an jâpa, an honga rukuong inika a ngim vang dôr an thun minsip ruruoia. ");
INSERT INTO sch_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Hanchu, Simon Peter'n neinun omtie a mûn chu, Jisua rukuonga khûkinbilin ânboka, “Pumapa, mi mâksan roh, mi nunsie kêng kin ni,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ama le a malngeiin an nga sûr tamrai sikin, an kamâm oka. ");
INSERT INTO sch_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Simon champui, Zebedee nâingei, Jacob le John khomin kamâm a om an ti saa. Hanchu, Jisua'n Simon kôma, “Chi no roh, atûn renga chu miriem sûr ni tih zoi,” a tipea ");
INSERT INTO sch_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","An rukuongngei tuipanga an kaisuoa, neinun murdi mâk rieiin Jisua an jûi zoi ani. ");
INSERT INTO sch_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Voikhat chu, Jisua khopui khata a om lâiin, mi inkhat aphârin atuom a oma, Jisua a mûn chu, a mâiruotin ânboka, “O Pu, nu nuoma anin chu ni na manthieng thei,” tiin a ngêna. ");
INSERT INTO sch_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jisua'n a kut le a tôna, “Ku nuom hong inthieng ta roh,” a tia. Harenghan aphâr hah a boipe riei zoia. ");
INSERT INTO sch_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Hanchu, Jisua'n a kôma, “Tute ril no roh, ania ochaingei kôm van en inla, mi murdi'n na dam zoi iti an rietna rangin, Moses Balam anghan inbôlna pêk roh,” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Hannisenla, Jisua thurchi ânthang uol uola, a chongril rangâi rang le an natnangei mindam rangin mipuingei Jisua kôma an hong intûpa. ");
INSERT INTO sch_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Hannisenla mun inthimna a sea ava chubai ngâia. ");
INSERT INTO sch_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Sûnkhat chu Jisua'n mi a minchua, a kôla Phariseengei le Balam minchupungei an insunga, Galilee le Judea ram khopui renga le Jerusalem renga hong an nia. Mi mindam theina rangin Pumapa Ratha Jisua chunga a oma, ");
INSERT INTO sch_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Phalkhatthi inkhat a jâlmun leh an hong rojôna, in sûnga Jisua makunga se rang an bôka. ");
INSERT INTO sch_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ania, mipui tam sikin lût thei mak ngeia. Masikin, in chung tieng an kal puia, inchung an mo-onga aridîn taka, Jisua makunga a jâlmun leh an juong musuma. ");
INSERT INTO sch_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Hanchu, Jisua'n an taksôn tie a mua, a kôma, “Ni sietnangei ngâidam ani zoi,” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Hanchu Balam minchupungei le Phariseengei han, “Ma angtaka Pathien rilminsiet hih tumo ai ni! Pathien mang kêng nunsie ngâidam thei,” anin tia. ");
INSERT INTO sch_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jisua'n an mindonna a rieta, “Ithomo ma anga nin mindon? ");
INSERT INTO sch_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ni sietna ngâidam ani zoi iti le, inthoi inla lôn roh iti hih khomo a ti abai uol? ");
INSERT INTO sch_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Miriem Nâipasal hin rammuola hin nunsie ngâidam theina ranak a dôn iti nangni minlang pe ki tih,” a tipe ngeia. Hanchu, phalkhatthipa kôma han, “Inthoi inla nu puonpha lak inla, na ina se ta roh nang ki ti,” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Harenghan, an motona ânding lita, a jâlna puonpha a lâka, Pathien minpâk pumin a in tieng a se zoi. ");
INSERT INTO sch_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","An rêngin kamâmin an chia, “Avien chu hi ang taka neinun inkhêl ei mu hih,” tiin, Pathien an minpâk zoi. ");
INSERT INTO sch_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Masuole chu, Jisua a sea, sumrusuong ngâi a riming Levi Office a insung a mua, Jisua'n a kôma, “Ni jûi roh,” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Hanchu neinun murdi mâkin a jûi zoia. ");
INSERT INTO sch_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Hanchu, Levi'n Jisua rang a ina bukhalai otna a thoa, sumrusuong ngâi mi tamtak le mipuingei a siela. ");
INSERT INTO sch_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Hanchu pharisee senkhat le Balam minchupu senkhat ngeiin Jisua ruoisingei an makhal ngeia, “Ithomo sumrusuong ngâi ngei le nunsaloi ngei leh nin sâka, nin nêk ngâi” an tia. ");
INSERT INTO sch_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jisua'n an kôm, “Mi adam ngeiin doctor nâng ngâi mak ngeia, damloi ngeiin kêng an nâng ngâi. ");
INSERT INTO sch_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Midik ngei ralam ranga juong ni mu unga, mi nunsie ngei ralam ranga juong kêng ki ni,” tiin a thuon ngeia. ");
INSERT INTO sch_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Mi senkhatin Jisua kôma, “John ruoisingeiin bungêiin an chubai ngâia, Pharisee ruoisingei khomin ha anga han an tho ngâia, hannisenla, na ruoisingeiin chu ngêi ngâi mak ngeia?” an tia. ");
INSERT INTO sch_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jisua'n an kôma, “Inneina khuolmingei hah moipumapa an kôm a om kâr chu bu nin min ngêi thei rang mini? Ni thei no nih. ");
INSERT INTO sch_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Hannisenla, an kôm renga moipumapa an tuongpai nikhuo la tung a ta, ha tikin chu la ngêi an tih” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jisua'n hi khom hih a misîra, “Tutên puon thar khêrin puon muruo chetpho ngâi mak ngei, pho ngân senla, athar han kaiset a ta, puon hâr thar le puon muruo hah inmun no nih. ");
INSERT INTO sch_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tutên uain thar savun ûm muruoa thun ngâi mak ngei, thun ngân ta senla, uain thar han savun ûm hah mûtkhoi a ta, inbuokpai a ta, savun ûm khom siet a tih. ");
INSERT INTO sch_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Masikin, uain thar chu savun ûm thara thun an tih. ");
INSERT INTO sch_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Tutên uain muruo nêk nûkin athar nuom ngâi mak, uain muruo asa uol sikin,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jisua'n Sabath nîn loilâi a pala, a ruoisingeiin buvûi an china, an kutin an muoi minsâia, an sâka. ");
INSERT INTO sch_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pharisee senkhat ngeiin, “Ithomo, ei Balamin Sabathnia tho loi ranga ai ti hah, nin thoa?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jisua'n an kôma, “David le a mingeiin an vonchâm lâia an itho hah nin pore ngâi loi mini? ");
INSERT INTO sch_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Pathien Ina a sea, Pathien ranga ipêk, Ochaingei tiloiin chu tûte sâk rang Balam niloi vâipôl a laka, a sâka, a mingei a minsâk hah?” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Hanchu Jisua'n, “Miriem Nâipasal hih Sabathni Pumapa ani” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Hanchu, Sabathni danga chu Jisua Synagog taka a sea, a minchu ngeia, mahan mi inkhat kut changtienga phalkhatthi a oma. ");
INSERT INTO sch_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Balam minchupungei senkhat le Pharisee senkhat ngeiin Jisua an nôn theina rang abi rokin Sabathnin a mindam le a mindam loi an enrichika. ");
INSERT INTO sch_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jisua'n an mindonna a rieta, damloi kôma, “Inding inla moton tieng hin hong roh,” a tia, hanchu ânthoia ânding zoia. ");
INSERT INTO sch_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Hanchu Jisua'n an kôma, “Ei Balamin Sabathnia, asa rangin mo, dûk mintong rangin mo? mi phal. Mi ringna min jôk rangin mo, minmang rangin mo?” a tia. ");
INSERT INTO sch_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","An rêngin a en titira, hanchu, a kôma, “Nu kut phar roh” a tia. A phara, a kut a dam pe zoia. ");
INSERT INTO sch_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Hanchu, an taksi oka, Jisua chunga an tho thei rang lam an inkereng zoia. ");
INSERT INTO sch_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ma zora han Jisua chubai tho rangin muol chunga a sea, mahan, Pathien kôm jânkhovârin chubai a thoa. ");
INSERT INTO sch_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Hanchu khuo a hong vârin chu a ruoisingei a koibûma, an lâia mi sômleinik a thanga, Tîrton, ai be ngei chu, ");
INSERT INTO sch_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon (Peter, ai phuo) le a nâipa Andrew; Jacob le John, Philip le Bartholomew, ");
INSERT INTO sch_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mathew le Thomas, Alpheaus nâipasal Jacob le Simon (zelot an ti) ");
INSERT INTO sch_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jacob nâipasal Judas le a minsûrpu, Judas Iscariot ngei anni. ");
INSERT INTO sch_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Hanchu, Jisua le tîrtonngei hah muol chung renga an juong chuma, a ruoisi tamtak ngei leh mun inchamna an indinga, ha muna han mipui tamtak Judea ram murdi renga, Jerusalem renga, tuikhanglien pang khopuilienngei, Tyre le Sidon renga mingei an oma. ");
INSERT INTO sch_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","A chongril rangâi rang le an natna ngei mindam ranga hong anni. Ratha saloi ngeiin dûk an mintong ngei khom an honga an dama. ");
INSERT INTO sch_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","A sinthotheina a jôk sikin, mipui murdi'n ama tôn rangin an bôka, an rêngin an dam pak zoi. ");
INSERT INTO sch_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisua'n, a ruoisingei a ena, a tia, “Nangni ânriengngei chu satvur nin ni, Pathien Rêngram nin ta ani sikin. ");
INSERT INTO sch_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nangni atûna vonchâmngei, chu satvur nin ni, Nin la khop rang sikin. Nangni atûna a chapngei, chu satvur nin ni, Nan lân nui rang sikin!” ");
INSERT INTO sch_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Miriem Nâipasal sika, mingeiin nangni an mumâka, nangni an henga, nangni an êroa, puoloingei nangni an ti tena, chu satvur nin ni. ");
INSERT INTO sch_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ma anghan a hong tungin chu râisânin lâm roi. Invâna, râisânman luttak nin rangin dara a om sikin. Asikchu an richibulngei khomin dêipungei chunga ma angdên han an lei tho ngâi ani.” ");
INSERT INTO sch_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ania, nangni atûna ânchongngei, nin chung ântak, nunkhohoi nin mang zoi sikin! ");
INSERT INTO sch_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nangni atûna akhopngei, nin chung ântak, Nan la châm rang sikin! Nangni atûna ânnui ngei nin chung ântak, Inngûia nan la chap rang sikin!” ");
INSERT INTO sch_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Mi tinin nangni an minpâk tenan chu nin chung ântak, ha ang dêna han an richibulngei khomin dêipu dikloingei an lei manpâk ngâi ani.” ");
INSERT INTO sch_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ke he ariet murdi'n, nan râlngei lungkham ungla, nangni mumâk ngei satna rang tho pe ngei roi. ");
INSERT INTO sch_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","khomâk nangni sâm ngei satvur ungla, dûk nangni tho ngei chubai tho pe roi. ");
INSERT INTO sch_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mîn na mâi a bêna anîn chu, kângkhat tieng khom do pe sa roh, mîn na kâncholi chung a lâka anîn chu asûnga khom pêk sa roh. ");
INSERT INTO sch_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mîn neinun nang an zonga anîn chu pêk roh, na ta an lâk khomin zong khâi no roh. ");
INSERT INTO sch_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nu chunga na nuomlam an tho angin mi chunga tho roh. ");
INSERT INTO sch_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Mi lungkham nangni mu ngei vai lungkham nin mun te, inmo satvurna nan man ranga? mi nunsiengeii luo anni lungkham amu ngei chu anni khomin an lungkham ngâi. ");
INSERT INTO sch_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nin chunga sin sa tho ngei vai chunga sin sa nin thoa aninte inmo satvurna nin man ranga? Mi nunsiengeiin luo ha anga han chu an tho ngâi. ");
INSERT INTO sch_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Man nôk ranga na sabei ngei kôma vai ne pêka aninte, inmo satvurna na man ranga? Mi nunsiengeiin luo, abipui man nôkna rangin chu, mi nunsiengei kôma an pêk ngâi! ");
INSERT INTO sch_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ni thei no nih! Na râlngei lungkham inla, an satna rang sin pe ngei roh, ite man nôk rangin sabei loiin mintâng ngei roh. Hanchu, râisânman alien man nan ta, Ânchungtak Pathien nâingei nîng nin tih. Ama chu râisânna chang riet loi ngei le mi nunsiengei a lungkham ngâi. ");
INSERT INTO sch_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nin pa'n mi a lungkham angin nangni khomin lungkham roi.” ");
INSERT INTO sch_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Midang jêk no ungla, Pathien'n nangni jêk no nih. Midang dem no ungla, Pathien'n nangni dem no nih. Mi ngâidam ungla, Pathien'n nangni ngâidam a tih. ");
INSERT INTO sch_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pêk ungla, hanchu, Pathien'n nangni pêng a tih, mintena sa, namdên êt, le inîkin, min liemin, nin kuta akeng theidôrin nangni pêng a tih. Mi nin minte pena nanâka han Pathien'n nangni minte pênah a tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jisua'n hi chongmintêk hih a rila, “Mitcho inkhatin mitcho adang ruoi thei mak; a ruoia anîn chu an ruonin khursodopa tâk an tih. ");
INSERT INTO sch_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Minchupu nêkin ânchûpu lien uol maka, han, ânchupu khom a zoi tikin chu minchupu ang a tih. ");
INSERT INTO sch_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ithomo, ni mita thingbong a om mindon bak loia, na lâibungpa mita ronok a om hah ne en? ");
INSERT INTO sch_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Inmo ni mita thingbong mu loiin, na lâibungpa kôma, ni mita ronok nang lei kêl pe rong ni ti thei ranga? Asarotholngei, Ni mita thingbong kêl bak inla, hanchu, na lâibungpa mita ronok mu minthâr thei ni tih.” ");
INSERT INTO sch_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Thingkung adamin mara saloi inra maka, thingkung damloiin mara sa inra ngâi mak. ");
INSERT INTO sch_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Thingkung tin an mara chita ei riet; riling rânga theichang pot ngâi mak chea, riling ranga grape pot ngâi mak che. ");
INSERT INTO sch_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mi sân chu a mulung sûnga neinun sa a kelsuoa, mi nunsien chu a mulung sûnga neinun saloi a kelsuo ngâi, mulung sûnga asip hah kêng bâiin a misîrsuok ngâi.” ");
INSERT INTO sch_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ithomo ko chongbe jôm loia, Pumapa, Pumapa, mi nan ti? ");
INSERT INTO sch_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Tukhom ko kôma honga, ko chong rangâia ko chongjôm chu imo ai ang nangni ril ki tih. ");
INSERT INTO sch_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ha mi hah chu a in sin lungpui chunga a lungphûm inthûk taka phun ang hah ani. Tuilienin a suka, innîk maka, adet ngita sin ani sikin. ");
INSERT INTO sch_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ania, tutukhom ke he rieta, ko chong jôm loi chu, lungphûm loia in sina, tuilienin asuka, achim kelena, ânphôi chit ang hah ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Hanchu, Jisua'n mingei kôma chong a ril zoiin chu Capernaum'a khuoa a sea. ");
INSERT INTO sch_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Rom râlmi ruoipu tîrlâm midit tak dam maka, a thi vavânga. ");
INSERT INTO sch_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Hanchu, Jisua'n thurchi a rieta anin chu a juonga a tîrlâm mindam ranga ngên rangin Juda Upangei a tîra. ");
INSERT INTO sch_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jisua kôma an honga, “Hi mi hih na san thei ruo ani. ");
INSERT INTO sch_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Kin mingei lung a min khama, kin synagog khom mi sin pe ani” tiin an ngên rîta. ");
INSERT INTO sch_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Hanchu Jisua'n, anni ngei hah a jûi zoia. In a tung rangtôn chu, râlmi ruoipu'n a malngei a tîra, “O pu, intak takin hong no roh, ki ina mini pan rangin inhoi mu-ung. ");
INSERT INTO sch_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Mapêna keima ngêt no kôma hong rang khomin inhoi mu-ung. Hê vai minchôi inla ki tîrlâm chu dam a tih. ");
INSERT INTO sch_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Keikhom kenêka ulien chong nuoia om ki ni. Ko chong nuoia râlmingei an oma, inkhat kôm, ‘Se roh’ ki tiin a sea, ‘Hong roh,’ ki tiin a honga, Ki tîrlâm kôm, ‘Hih sin roh’ ki tiin a sin ngâi” a tia. ");
INSERT INTO sch_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Hanchu, Jisua'n a rieta anin chu kamâm aom a tia, mipui ama jûi ngei a en titira, an kôma, “Nangni ki ril, hi angtaka taksônna hi chu Isrealngei lâia luo la mu ngâi mu-ung” a tia. ");
INSERT INTO sch_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Thangthei ngeiin ruoipu in an hong kîrnôk inchu tîrlâm hah a damin an hong mu zoi. ");
INSERT INTO sch_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Chomolte suole chu Jisua, Nain khopuia a se zoia, a ruoisingei le mipuingeiin an jûia. ");
INSERT INTO sch_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Hanchu, khopui mokot an tungin chu, mithi an hong rojôna. Ma athipa hah meithâinu nâikhât ania, male A khopuia mi tamtak ngei khom a kôma an oma. ");
INSERT INTO sch_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Hanchu, Pumapa'n ama amûn chu inrieng amu oka, a kôm, “Chap no roh” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Hanchu ava nâia, a tolâi a tôna, a rojôn ngei an inngama, Jisua'n, “Ruotharte, inthoi roh nang ki ti,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Hanchu, mithi hah ânsung lita, a chonga. Hanchu, Jisua'n a nû kôm a pêk nôk zoi. ");
INSERT INTO sch_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","An rêngin an chia, Pathien an minpâka, “Ei lâia dêipu roiinpui tak a juong inlanga, a mingei mi minjôk rangin Pathien a juong zoi,” an tia. ");
INSERT INTO sch_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Hi Jisua thurchi hih Judea ram pumpuia le a kôlrevêla ânthang zit zoi. ");
INSERT INTO sch_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","John ruoisingeiin Jisua thurchi John an rila, hanchu a ruoisingei mi inik a koia, ");
INSERT INTO sch_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Pumapa kôm a tîr ngeia, “a juong rang Messiah hah mo ni ni, mo midang kin la tûng rang mo?” itia rekel rangin. ");
INSERT INTO sch_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Hanchu, Jisua kôma an honga, “Baptispu John'n, a juong rangpu hah nini mo, midang kin la tûng rang mo? a ti” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ma lâitaka han, Jisua'n, mi tamtak damloingei, an natnangei, ramkhori sûrngei a mindam ngeia, mitchongei mit a minvâr pea. ");
INSERT INTO sch_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Hanchu, John ruoisingei kôma, “Se nôk ungla, John kôma, nin mu ngei le nin riet ngei hah va ril roi, mitchongeiin an mu theia, kholrangei an lôn thei zoi, aphârngei an inthienga, kuorsetngei kuor avâra, mithingei aringin an inthoi nôka, inriengngei kôma Thurchi Sa misîr ani zoi. ");
INSERT INTO sch_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Iem zoiloina nei loi ngei chu satvur anni,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","John ruoisingei an se zoiin chu, Jisua'n John chungroi mipuingei kôma a misîra. “A kôma ramchâra nin se lâia han imo mu rangin nin sabei? phâivuon ai sêm sûl innîk ngei mo? ");
INSERT INTO sch_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Imo a en ranga nin se? Puon innêm insil mi mo? Ha anga insil ngâi ngei le ningnuoma lêng ngei chu rêng inah kêng an om ngâi. ");
INSERT INTO sch_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ni ril ta u, imo a en ranga nin se? Dêipu na? O, ani, Dêipu nêka lien uol nin mu zoi. ");
INSERT INTO sch_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","John hih Pathien lekhabua, ‘Ki tîrton no motona na lampui sin rangin tîr ki tih,’ ai ti chu ani. ");
INSERT INTO sch_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nangni ki ril John hih mi murdi lâia alientak chu ani. Ania, Pathien Rêngrama achîntak khom John nêkin chu a lien uol.” ");
INSERT INTO sch_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","John chongril mipuingeiin an rangâia, aliekin sumrusuong ngâi ngeiin Pathien chong an jôma, a kôma baptisma an changa. ");
INSERT INTO sch_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ania Balam minchupungei le phariseengeiin chu anta ranga Pathien mintuo an henga, John baptisma khom chang mak ngei. ");
INSERT INTO sch_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jisua'n, “Atûnlâi ruolthoitharngei hih imo an ang? Ilemo ki mintêk rang ani zoi? ");
INSERT INTO sch_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nâipangngei bazar muna insunga, senkhatin inneina berlem nangni kin tum pea, lâm mak cheia, chûlna la kin tho khomin chap mak cheia, itia in hêt inlôm angha anni. ");
INSERT INTO sch_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Baptispu John a juonga, bungêiin uain khom nêk maka, ramkhori kêng nin tia. ");
INSERT INTO sch_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Miriem Nâipasal a juonga, a sâkin a nêka, rolruokpa, sumrusuongpungei le mi nunsiengei malpa nin tia. ");
INSERT INTO sch_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","A modôm ngei rangin chu, Pathien vârna, chongdik minlangna ani” a tia. ");
INSERT INTO sch_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Pharisee inkhatin Jisua bu nêk rangin a siela, Jisua a sea, bu nêk rangin ânsunga. ");
INSERT INTO sch_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ma khopuia han nupang inkhat nunsie a oma. Jisua Pharisee ina bu a nêk iti a rietin chu, sariek mirimhoi alabastar bilôr a hongchôia. ");
INSERT INTO sch_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jisua nûktieng a ke bula ândinga, a chapa, a mitrithîn a kengei a mindûi pea. A samin a kengei a hûia, a ke a tuma, sariek mirimhoi a buoka. ");
INSERT INTO sch_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pharisee han a mulungrîlin, “Hi mi hih dêipu dik anîn chu, a tônnu, nupang saloi ani tie hih riet a tih” a tia. ");
INSERT INTO sch_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jisua'n a kôma, “Simon, nang ril rang ke nei” a tia. Simon'n, “O, Minchupu ni ril roh” a tia. ");
INSERT INTO sch_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jisua'n a kôma, “Mi inikin lâkâi pêk ngâipu kôm sumdâr an intânga, inkhatin razaranga, inkhatin sômranga. ");
INSERT INTO sch_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","An thuon theiloi sikin an ruonin a ngâidam ngeia, a tu han mo lungkham uol nih?” a tia. ");
INSERT INTO sch_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon'n a thuona, “Ki iem lamin chu a ngâidam tam uolpu hah” a tia, Jisua'n, “Ni ti mindik” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Male chu, nupangnu tieng mâi athaka, Simon kôma, “Hi nupangnu hih nu mu mo? Ni ina ko honga, ka ke rusûkna rang tui ni pêk mak chea, ama'n chu a mit rithîn ke kengei a rusûka, a samin a hûi minhula, ");
INSERT INTO sch_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ni tumin ni lei don mak che, ama chu ko hong renga ka kengei a tum bâng mak. ");
INSERT INTO sch_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Olive sariek ku lua buok mak chea, ama'n chu ka kengei sariek a pol minzo zita. ");
INSERT INTO sch_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Masikin nang ki ril, lungkhamna lien a minlang han a nunsiena tamtak ngei hah ngâidam ani zoi, iti a minthâr. Masikin, tukhom ngâidamna chînin chu lungkhamna chîn a minlang” a tia. ");
INSERT INTO sch_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Male, Jisua'n nupangnu kôma, “Ni sietnangei ngâidam ani zoi” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","A kôma insung ngeiin, Hi anga nunsie ngei tena ngâidam thei hih tumo ai ni? anin tia. ");
INSERT INTO sch_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ania, Jisua'n nupangnu kôma, “Na taksônnân nang a sanminjôk zoi, rathanngam takin se ta roh” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Hanchu, môrkhat suole chu, Jisua'n Galilee ram khopuingei le khuongei nâma Pathien Rêngram Thurchi Sa misîrin a chaia. Ruoisi sômleinik ngeiin an jûia. ");
INSERT INTO sch_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nupang senkhat ramkhori sûr renga an natnangeia a dam, Mary Magdalene, a sûng renga ramkhori sari a rujûlpai pe, ");
INSERT INTO sch_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Herod office'a sin milien Chuza lômnu Joanna ngei, Susanna ngei, le midang nupang tamtak ngeiin an jûi saa. Hi mingei hin an sumin Jisua le a ruoisingei an san ngei ngâi ani. ");
INSERT INTO sch_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Khopui ankhat renga adanga mipuingei Jisua kôm an hong intûpkhôma, Jisua'n chongmintêkin a ril ngeia. ");
INSERT INTO sch_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Mi inkhat a bu rît rangin a loilâia a sea. Sachi a rethea, senkhat lampui kôla achula, vangeiin an sâk ripa. ");
INSERT INTO sch_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Senkhat lungpherpha pil chunga achula, a hong mônga, pil an zit loi sikin a rôp nôk ripa. ");
INSERT INTO sch_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Senkhat chu riling kâra achula, ahong thuora, rilingin adîp thata. ");
INSERT INTO sch_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Senkhat chu pil sana achula, a hong insôna, abâk raza chitin an hong inra zoi. Hanchu hi chongngei hih a rila, Jisua'n, Kuor nin dônin chu rangâi roi, a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","A ruoisingeiin hi chongmintêk omtie, Jisua an rekela. ");
INSERT INTO sch_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jisua'n, “Pathien Rêngram chong inthup riettheina nin kôma ipêk ani. Ania midangngei rangin chu, an ena an mu loina rang le an rangâia an rietminthâr loina rangin, chongmintêk vaiin misîr pe rang ani” tiin a thuon ngeia. ");
INSERT INTO sch_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Chongmintêk omtie chu hi anghin ani; Sachi chu Pathien chong ani. ");
INSERT INTO sch_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Sachi lampui kôla chul chu, chong chu an rieta, ania, an iem loina rang le minringa an om loina rangin Soitanin an chong riet hah an mulungrîl renga a lâk pe ngâia. ");
INSERT INTO sch_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Lung chung pila chul chu, an chong riet râisân takin an poma, nikhomrese, an nia han rujung inthuk nei loiin, an chunga minsinna a hongtung tena chu an inlet nôk ngâia. ");
INSERT INTO sch_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Riling kâra chul chu, chong an rieta, aniatachu, hi ringnun hoiinhâina le inchongna ngei hin lungkâng a pêka, adîpa, amara reng min phâk ngâi mak. ");
INSERT INTO sch_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pil sana chul chu, chong an riet hah mulungrîla asadimin an dara, an jôma, an inra mâka dier ngei hah anni” a tia. ");
INSERT INTO sch_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Tutên châti mochokin bêl nuoia dar ngâi mak ngei, jâlmun nuoia khom dar ngâi mak ngei. A lût murdi'n an mu theina rangin a darna muna kêng an dar ngâi. ");
INSERT INTO sch_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ânthup murdi khom tâng minsuok nîng a ta, ihîpa om murdi khom avâra la minlangsuok nîng atih. ");
INSERT INTO sch_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Singthei roi, inmo nin rangâi, asikchu, a dônngei chu bôkpe sa nîng a ta, a dônloi chu a dôn vieta ai mindon te ha khom la lâk pe rip an tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Hanchu, a nû le a lâibungngei Jisua kôma an honga, ania mipui sikin a kôma tung thei mak ngeia. ");
INSERT INTO sch_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mi inkhatin, “Na nû le na lâibungngeiin nang mu nuomin pêntieng an inding” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Hanchu, Jisua'n an kôma, “Ka nû le ka lâibungngei chu Pathien chong rangâia a jômngei hih anni” a tia. ");
INSERT INTO sch_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sûnkhat chu Jisua le a ruoisingei rukuonga an chuonga, “Dîl râl tieng son lenkân rei u” a tia, hanchu an inphêta. ");
INSERT INTO sch_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Hanchu an se lâiin, Jisua chu a ina. Inningloiin phâivuopui a hong thoa, an rukuong tuiin a sip vavânga, rolo innîkin an oma. ");
INSERT INTO sch_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Hanchu, ruoisingei Jisua kôma an sea, an kaithoia, “Minchupu, Minchupu! Kin thi suo rang kêng ani zoi” an tia. Hanchu, Jisua ânthoia, Phâivuopui le tuidârinsok hah chong a pêka, an dâiruom zoia. ");
INSERT INTO sch_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Hanchu, a ruoisingei kôma, “Khonmo, nan taksônna a om?” a tipe ngeia. Kamâmin an chia, Khoi anga miriem mo hi? Phâivuopui le tuidârinsokngei khom chong a pêka a chong an ijôm hi, anin tia. ");
INSERT INTO sch_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Hanchu Jisua le a ruoisingei hah Galilee dîl râl, Gerasa, ram an tunga. ");
INSERT INTO sch_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jisua'n tuipânga a lôn lehan, khopui renga mi inkhat, ramkhori sûr ân tongpuia. Ha mi hah zora sôttak renga, dierboiin, ina khom om ngâi loiin thâna lei om ngâi ania. ");
INSERT INTO sch_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jisua a mûn chu ânieka, a ke bula ânboka, ânring takin, Jisua Pathien Ânchungtak Nâipasal, imo ni lo rang ni ti? Dûk ni mintong no roh, tiin a ngêna. ");
INSERT INTO sch_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jisua'n ratha innim hah chong a pêk sika ma angtaka ai ti ani. Vêl tamtak an sûra, lung ina an khum ngâia, a kut le a ke zingjirûiin an khita chu a potsata, ramkhori han ramchâr tieng han a rujûl ngâi ani. ");
INSERT INTO sch_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jisua'n, “Imo ni riming?” tiin a rekela, “Ki riming chu, Mob” tiin a thuona, a sûnga ramkhori tamtak an lût sikin. ");
INSERT INTO sch_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Hanchu, ramkhoringei han, khurmongboia tîr loina rangin Jisua an ngêna. ");
INSERT INTO sch_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Hanchu, ha muol panga han vok pâl sâk rokin an oma, ramkhoringeiin ha vokngei sûnga lût rangin Jisua an ngêna, a phalpe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Mipa sûng renga an jôka, vokngei sûnga an lût zoia. Rôlsôr dîl rakhama an tâna, tuia an tâka an thi let zoi. ");
INSERT INTO sch_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Hanchu, vok avâipungei han neinun omtie an rietin chu, an sea khopuia le loia mingei an va ril ngeia. ");
INSERT INTO sch_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Hanchu, neinun omtie en rangin mingei an suoka, Jisua kôm an hongin chu, ramkhori sûrpu hah, puon silin, ruthuok kipin Jisua ke bula insungin an mua, an rêngin an chia. ");
INSERT INTO sch_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Hanchu, amu nâmin a dam tie mingei kôma an rila, ");
INSERT INTO sch_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ha Gerasa rama mingei han an chi sikin Jisua hah an kôm renga rot rangin an ngêna, hanchu Jisua rukuonga a chuonga a mâk ngei zoi. ");
INSERT INTO sch_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ramkhori a sûng renga a jôka a dampu han, Jisua kôm nang jûi ki tih, a tia. ");
INSERT INTO sch_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Hanniresea, Jisua'n, “Ni ina senla, nu chunga Pathien sintho tie va misîr roh” a tipea. Hanchu, a sea, khopui sûng pumpuia a chunga Jisua sintho tie hah a misîr zoi. ");
INSERT INTO sch_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Hanchu, Jisua dîl râl tieng a hongtung nôkin chu, mipuingei ama lei ngak sikin an lei modôma. ");
INSERT INTO sch_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ha khuoa synagog ruoipu Jairus a honga, Jisua ke bula ânboka, a ina se rangin a ngêna. ");
INSERT INTO sch_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","A nâikhât nâinupang, kum sômleinik mi, a thi vavâng sikin. Hanchu, Jisua a sên chu mipuingeiin an ûmhura. ");
INSERT INTO sch_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nupang inkhat kum sômleinik piel, hulloi inrik a oma, ai dôn murdi doctora a thâm let zoia, tute lakin mindam thei mak ngeia. ");
INSERT INTO sch_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mipuingei kâra Jisua nûktieng a honga, a puonmor a tôna, harenghan a dam kelena. ");
INSERT INTO sch_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jisua'n, “Tumo ni tôn?” a tia. Kei chu ni mu-ung an ti chita. Hanchu Peter'n a kôma, “Minchupu, hi dôra mipuiin nang an uop hite” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ania, Jisua'n “tuminin chu min tôn, Keima renga sinthotheina ajôk” a tia. ");
INSERT INTO sch_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nupangnu ani ti rietsuok ani zoi, ti ânriet tena chu, innîk pumin mipuingei makunga, Jisua ke bula inbokin, a tôna harenghan a dam kelen roi hah misîr zoi. ");
INSERT INTO sch_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Hanchu, Jisua'n a kôma, “Ka nâinupang, na taksônnân nang a mindam zoi, rathanngam takin se ta roh” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisua'n ha a ti lâitakin, ruoipu in renga thangthei a honga, Jairus kôma, “Na nâinupang a thi zoi, Minchupu jêl khâi no roh” a tia. ");
INSERT INTO sch_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jisua'n a rieta, Jairus kôma, “Chino roh, iem ngit roh, dam a tih,” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","In ava tungin chu Peter, John, Jacob, nâite nû le pa pêna chu tute dang a kôma lût phal maka. ");
INSERT INTO sch_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Hataka om murdi nâite chûlin an chapa, Jisua'n, “Chap no roi, athi ni mak, a in kêng” a tia. ");
INSERT INTO sch_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Hanchu, nâite hah a thi ani iti an riet sikin an munuisana. ");
INSERT INTO sch_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Hanchu, Jisua'n a kut a sûra, “Ka nâite, hong inthoi roh” a tia. ");
INSERT INTO sch_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Hanchu, a ringna a juong kîra, harenghan a hon thoia, Jisua'n “sâk rang imokhat pêk roi” a tia. ");
INSERT INTO sch_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","A nû le a pa'n kamâm om an ti tataka; nikhomrese, Jisua'n chu a sintho hah tute ril loi rangin chong a pêka zoi. ");
INSERT INTO sch_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisua'n ruoisi sômleinik ngei hah a koibûma, an kôma, ramkhori rujûlpai theina le natnangei mindam theinangei le rachamneina a pêk ngeia. ");
INSERT INTO sch_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Male chu, Pathien Rêngram thurchi misîr rang le damloingei mindam rangin a tîrsuok ngei zoia. ");
INSERT INTO sch_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Hanchu, an kôma, “Khuolchaina rangin ite chôi no roi, sunrol mo, cholite mo, sum mo, bu mo, kancholi insak mo,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","“Nangni an lei modômna ina han, om tit ungla, ma khopui nin mâk nôk mâka chu. ");
INSERT INTO sch_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mi'n nangni an lei modôm nônchu, anni rilnân nin kea pildi hah khôngpai roi.” ");
INSERT INTO sch_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Hanchu rouisingei an sea, muntina thurchisa misîrin khuotina an chaia, damloingei an mindam tir zoi. ");
INSERT INTO sch_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Hanchu Galilee rama roijêkpu, Herod'n neinun omtie ngei a rieta anîn chu a mulung a jînga, senkhatin Baptispu John kêng a ring nôk an tipe sikin, ");
INSERT INTO sch_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Senkhatin Elijah kêng a juong inlâr nôk zoi, an ti, senkhatin tienlâia dêipu tumakhat kêng a ring nôk zoi an tia. ");
INSERT INTO sch_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herod'n John lu laka ka tan zoia, hi ang taka thurchi ki riet hih tumo ai ni? tiin Jisua mu rangin a nuoma. ");
INSERT INTO sch_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Hanchu, tîrton sômleinik ngei an hongkîr nôkin chu an sin va tho Jisua an rila. Hanchu, a kôm a tuong ngeia, Bethsaida khopuia atheiin a sepui ngei zoi. ");
INSERT INTO sch_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mipuiin an rietin chu an jûia. A modôm ngeia, Pathien Rêngram thurchi a misîr pe ngeia, mindam anâng ngei kai chu a mindam ngeia. ");
INSERT INTO sch_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Hanchu, kholoi ahong nîn chu, ruoisi sômleinik ngei an honga, a kôma, “Mipui ngei hih min se ngei ta roh, khopui sûnga le akôlrevêla bu le riamun an man theina rangin, ei omna lak mun inthim kêng ani” an tia. ");
INSERT INTO sch_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ania Jisua'n an kôma, “Nangnin sâkruo pêk ngei roi” a tipe ngeia. “Annin, vâipôl tâp rangnga le nga inik mang kêng kin nei. ");
INSERT INTO sch_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Hi dôra pasal isâng rangnga sâk rang hih a rochôk rangin kin se rang mini?” tiin an thuona. Hanchu, Jisua'n a ruoisingei kôma, “Mipui hi sômranga ngân abukin min sung ngei roi,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Hanchu, a ruoisingeiin a he bê angin mipui ngei hah an minsung ngeia. ");
INSERT INTO sch_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Hanchu, Jisua'n vâipôl rangnga le nga inik hah a lâka, invân tieng a tanga, Pathien kôm râisânchong a rila, a khoia, hanchu mipui ngei sem rangin a ruoisingei a pêka. ");
INSERT INTO sch_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Hanchu, anrêngin an khop dodôrin an sâk suonûkin, an sâk minieng, tâidôn sômleinik ruoisingeiin an rût minsip ani. ");
INSERT INTO sch_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Sûnkhat chu, Jisua'n atheiin chubai a thoa, a ruoisingei an honga, an kôma, “Mipuingeiin tumo min ti ngâi?” tiin a rekela. ");
INSERT INTO sch_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","“Senkhatin, ‘Baptispu John’ senkhatin ‘Elijah,’ senkhatin tienlâia dêipu tumakhat, a juong nôk nang an ti ngâi,” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Hanchu, “nangnin te tumo minin ti?” tiin a rekel ngeia. Peter'n, “Messiah Pathien na ni” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Hanchu, Jisua'n hi chong hih tute kôma misîr tet loi rangin chong a be ngeia. ");
INSERT INTO sch_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","An kôma, “Miriem Nâipasal hi upangei, Ochaisingei, Balam minchupungeiin hengpai an ta, dengmanthei ok an tih. That an ta, ania, sûnthum suole chu a ringin inthoi nôk a tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Hanchu an rênga kôma, “Tutu, ni jûi a nuoma anîn chu ama in mingilin, anîngtin a khros ruputin ni jûi rese. ");
INSERT INTO sch_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tutu, a ringna minjôk a nuom kaiin chu machân a ta, ania, keima sika a ringna machân kaiin ring an tih. ");
INSERT INTO sch_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mîn rammuol hih apumin nei senla, a theiin inmangin mo, machânin mo om ta senla ata rangin imo ânlap! ");
INSERT INTO sch_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mîn keima le ka thurchi inzakpui chu, Miriem Nâipasal khomin, a roiipuina leh Pa roiinpuina leh vântîrton inthieng ngei leh a juong tikin inzakpui a tih. ");
INSERT INTO sch_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Hitaka senkhat ngei hin Pathien rêngram an mu mâka chu thi noni ngei iti riettit roi” a tia. ");
INSERT INTO sch_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Hi chong a misîr zoia, hapta khat suole chu, Jisua'n Peter, John le Jacob ngei hah muol chunga chubai tho rangin a tuong ngeia. ");
INSERT INTO sch_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Hanchu, chubai a tho lâitakin a mâi ânthûla, a mêl le a puonsilngei khom avâr intêrrakin a oma. ");
INSERT INTO sch_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Harenghan mi inik an juong oma, an chongpuia, Moses le Elijah an ni. ");
INSERT INTO sch_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Invân roiinpuinân an juong inlâra, Pathien bôkna len ranga, Jerusalema Jisua thi rang tie an misîra. ");
INSERT INTO sch_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peter le a champui ngei chu an inphara, an inthoiin chu Jisua roiinpuina le a kôma mi inik inding ngei an mua. ");
INSERT INTO sch_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mingei han Jisua an mak rangtôn chu, Peter'n a kôma, “Hitaka om hi eita rangin asa, puon in inthum nata rang inkhat, Moses rang inkhat le Elijah rang inkhat sin kin tih” a tia. (ha a chong ti hah asadimin riet minthâr mak) ");
INSERT INTO sch_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","A la chong lâitakin sûmin a juong minlia, an chunga sûmin a juong mukhûn chu ruoisingeiin an chia. ");
INSERT INTO sch_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Sûm renga rôlin, “Ama hih ka Nâipasal ka thangsuok chu ani, a chong rangâi roi” a tia. ");
INSERT INTO sch_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Rôl amongin chu, Jisua vai a om zoia. ruoisingei han an neinun mu tute ril loiin an ip tita. ");
INSERT INTO sch_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Anangtûka Jisua le ruoisi inthum ngei hah muol chung renga an juong chumin chu mipui tamtak ngeiin an lei dona. ");
INSERT INTO sch_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Hanchu, mipuingei lâia mi inkhatin, “Minchupu, ka nâipasal, ke neisun hi en ta,” tia ngênin ân-ieka. ");
INSERT INTO sch_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","“Ramkhorin a sûra, a minleta, a cherhuon asuoka, a minna, inningloiin a min ieka, a vôr raka darnân a min se ngâia. ");
INSERT INTO sch_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","A rujûlpai rangin nu ruoisingei ke ngên ngei lakin thei mak ngeia” a tia. ");
INSERT INTO sch_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jisua'n, “Iemna neiloi le mi puoloingei o! Iten sôt mo nin kôma omin nangni ko donsûi ranga? Na nâipasal hah hin hong tuong roh” a tia. ");
INSERT INTO sch_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Hanchu nâipang hah a hongin chu, ramkhori han a nîka pila inngil rakin a vôra. Jisua'n ramkhori hah chong a pêka, nâipang hah a mindama, a pa kôma a pêk zoi. ");
INSERT INTO sch_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Pathien sinthotheina roiinpui hah mipui ngei murdi'n an kamâm ok ani. Mipui ngeiin Jisua sinthongei an kamâm lâiin, a ruoisingei kôma, ");
INSERT INTO sch_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Nangni ki ril rang hih mingil no roi, Miriem Nâipasal hih miriemngei kôma ipêk nîng a tih” a tia. ");
INSERT INTO sch_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ania, ruoisingei lakin ai ti omtie hah rietthei mak ngeia. An riet thei loina ranga chong inthup ania, ama laka an chi sikin rekel ngam mak ngeia. ");
INSERT INTO sch_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Hanchu, ruoisingei han ei lâia tumo a lien rang tak tiin inkhalna an neia. ");
INSERT INTO sch_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jisua'n an mindonna a rieta, nâipangte a kaia, a kôla a mindinga. ");
INSERT INTO sch_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","An kôma, “Tutu, hi nâipangte ki riminga modôm chu, keima ni modôm ani; tutu keima ni modôm chu ni tîrpu modôm ani. Nin lâia a chintak hi a lientak ani,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","John'n, “Minchupu, mi inkhatin ni rimingin, ramkhori a rujûlpaia, ei pâla mi ani loi sikin, kan khap” a tia. ");
INSERT INTO sch_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jisua'n a kôma le adangngei kôma, “Khap no roi nangni chakal loi chu nin tienga kop ani” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jisua invâna a kal rang ni a hong nâia anîn chu, Jerusalema se rangin a mulungin a bôka, a se kelen zoi. ");
INSERT INTO sch_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","A motona thangthei a tîra, ata ranga neinuntin lei cherêl rangin Samari khuo inkhata an lûta. ");
INSERT INTO sch_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ania, Jerusalema se anni iti an rietminthâr sikin lei modôm mak ngeia. ");
INSERT INTO sch_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Hanchu, ruoisi Jacob le John'n an rietin chu a kôma, “Pumapa, anni ngei minmangna rangin Elijah angin invân renga mei koisumna rangin mini nuom mo?” an tia. ");
INSERT INTO sch_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jisua an tieng ânheia, a ngo ngeia. ");
INSERT INTO sch_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Male Jisua le a ruoisingei chu khuo danga an se zoi. ");
INSERT INTO sch_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Hanchu, lampuia an lôn lâiin, mi inkhatin Jisua kôma, “Na sêna muntina nang jûi ki tih” a tia. ");
INSERT INTO sch_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jisua'n a kôma, “Sialngei'n kuo an dôna, vangeiin rubu an dôna, ania, Miriem Nâipasal chu a lu minngamna rang luo mun dôn mak” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Hanchu midang kôma, “Ni jûi roh” a tipea. Ania ha mi han, “Pumapa, sêng ka ta, ka pa la phûm bak ki tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jisua'n a kôma, “A thi ngeiin an mithi champui ngei phûm rese ngei, nang chu sênla, Pathien Rêngram thurchi va misîr roh” a tia. ");
INSERT INTO sch_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mi dangin a kôma, “Pumapa, nang jûi ki tih, ania, ki inmingei chong hoiin ni manthân bak roh” a tia. ");
INSERT INTO sch_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Hanchu Jisua'n a kôma, “Tutu, âl kaina taka kut bânga, nûk tienga en chu, Pathien Rêngrama ranga mi nithei mak” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Masuole chu, Pumapa'n, midang sômsarileinik a thanga, abop abopin an sena rang khopuitina le muntina, ama motona a tîra. ");
INSERT INTO sch_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","An kôma, “Bu ât rang atama, ania a mintûp ranga sin rang mi an tôm, Masikin, a bu mintûp ranga sintho rang mi tîr rangin bu pumapa kôm ngên roi.” ");
INSERT INTO sch_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Se roi! Melang lâia belrite om anga han nangni ki tîr ani. ");
INSERT INTO sch_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Sumkok mo, cholite mo, kekok mo, chôi no roi; lampuia khom tute chibai no roi. ");
INSERT INTO sch_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","In nin lûtna kipa, ‘Hi ina hin rathanngamna om rese’ ti bak roi. ");
INSERT INTO sch_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Rathanngamna midit mi an oma anîn chu nin rathanngamna chibai hah an chunga om a tih; an om nôn chu nin chibai hah lâk kîr nôk roi. ");
INSERT INTO sch_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nin tungna ina han omtit ungla, nangni an pêk murdi sâk ungla, nêk roi, sinthopu chu lo pêk rang ani sikin. In tin lôrdul no roi. ");
INSERT INTO sch_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Khopui nin lûta nangni an modôma anîn chu, nangni an pêk kai chu sâk roi. ");
INSERT INTO sch_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ma khuoa damloi ngei mindam ungla, an kôma, ‘Pathien Rêngram nin kôma ajuong nâi zoi’ tipe ngei roi. ");
INSERT INTO sch_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Khopui nin lûtna nâm nangni an modôm nôn chu, lampuia jôkpai ungla, ");
INSERT INTO sch_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","nin khopuia pildi, kin kea kop tena khom nin chunga kin khôngthâk nôk vang ania, ‘Pathien Rêngram chu nin kôm ajuong nâi zoi!’ tipe ngei roi, a tia. ");
INSERT INTO sch_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nangni ki ril, Pathien Roijêk Nikhuo tika chu, ma khopuingei tuong rang nêkin chu, Sodom chu ajâi om uol atih!” ");
INSERT INTO sch_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Korazin, na chungroi arik bah na! Bethsaida, khom na chung roi arik bah na! Nangnia sininkhêl itho ngei hah Tyre le Sydon khuoa tho nisenla chu, thoila puon insilin, pildi inpolin an sietnangei insîr an tih. ");
INSERT INTO sch_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Roijêk Nîn chu nin tuong rang nêkin Tyre le Sydon chu ajâi om uol an tih. ");
INSERT INTO sch_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nangma Capernaum khom, nethenin invân idênin nên pâk rang mini? Dûkmuna kêng vôrpai na ni rang.” ");
INSERT INTO sch_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jisua'n a ruoisingei kôma, “Tutu nin chong rangâi chu ko chong rangâi ani, tutu nangni heng chu ni heng ani, tutu ni heng chu ni tîrpu heng ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Hanchu, sômsarileinik ngei hah râisân takin an hong kîra, “Pumapa, ni rimingin ramkhoringei tena kin chong an jôm” an tia. ");
INSERT INTO sch_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jisua'n a thuon ngeia, “Soitan, invân renga kôlinlek anga juong tâk ku mu,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","An kôma, “Rangâi roi, murûlngei le âinuvet chunga lôn theina le râlngei roineina chunga rachamneina nangni ke pêk, itên nangni minna thei noni ngei,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","“Ania ramkhoringeiin nin chong an jôm sikin nan râiminsân no roia, Invâna nin riming mizieka a om sikin nan râiminsân roi” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ma zora han Jisua Ratha Inthiengin a sipa, “O Pa, invân le pilchung Pumapa, mivâr, mi theithiem ngei kôma ni ip, mi inmôlngei kôma nu phuong sikin nang ki minpâk. Ani, O Pa, maha nu lungdo le na nuomlam tak ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ka Pa'n neinun murdi ni pêk zoi. Tutên, Pa ti loiin chu Nâipasal riet mak. Tutên Nâipasal ti loiin chu Pa khom riet mak, Nâipasalin ânphuongna ngei tiloiin chu. ");
INSERT INTO sch_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Hanchu, Jisua ruoisingei tieng ân heia, inrûkten, “Hi ngei nin mu hih idôra mi satvur mo nin ni! ");
INSERT INTO sch_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Dêipungei, rêngngei tamtakin nin mu ngei hih mu rang an nuoma chuh mu mak ngei, nin iriet ngei a riet an nuoma chuh riet mak ngei,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Balam minchupu inkhat Jisua minvak rangin a honga, a kôma, “Minchupu, Kumtuong ringna ka manna rangin imo ki sin rang?” a tia. ");
INSERT INTO sch_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jisua'n a thuona, “Lekhabu'n imo ati? Imo no pore ngâi?” a tia. ");
INSERT INTO sch_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Hanchu ama'n, “Pumapa na Pathien chu, nu mulung murdi'n, ni ringna murdi'n, na râtna murdi'n ni mindonna murdi'n lungkham roh. Nangma lung nên kham anghan nu bungmingei lungkham roh ati,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jisua'n a kôma, “Ni ti mindik, ha angtak han thô inla, ring ni tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Hannisenla, Balam minchupu hah theiintum nuomin, Jisua kôma, “Tumo ku bungngei?” a tia. ");
INSERT INTO sch_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Hanchu, Jisua'n a thuona, “Hanchu voikhat, mi inkhat Jerusalem renga Jericho'a a sea, inru ngei a tonga, an jêmpola, an tôk bita, a thi vângin an mâk raka. ");
INSERT INTO sch_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Hanchu ha lampuia han ochai inkhat a juong sea, ha mi hah a mûn chu lam dang tieng a piela. ");
INSERT INTO sch_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ma ang nanâk han, Levi mi a juonga, a ena, hanchu lamsîr tieng a piela. ");
INSERT INTO sch_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Hanchu, Samari mi inkhat han ha lampuia lônin a honga, a mûn chu lungkham a mua. ");
INSERT INTO sch_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","A kôm ava pana, a sâbengei sariek le uain a buoka, a thom pea, a sakuording chunga a minchuonga, khuol tung ina a tuonga, a donsûi zoia. ");
INSERT INTO sch_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","A nangtûka chu, sum dârnik a kelsuoa, khuol tung in enkolpu a pêka, ‘Lei donsûi inla,’ a chunga na thâm kai chu ko hong kîr nôk tika nang thuon ki tih” a tia. ");
INSERT INTO sch_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jisua'n, a kôma, “Inthum ngei lâia han atu tak ha mo inru ngei tongpu bungmi ani ranga ni iem?” a tia. ");
INSERT INTO sch_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Balam minchupu han a kôma, “inriengmupu tak hah” tiin a thuona. Jisua'n, “Sênla, nang khom ha ang tak han tho roh,” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Hanchu, Jisua le a ruoisingei an khuol se nân, khuo inkhata an lûta, nupang a riming Martha a ina a modôm ngeia. ");
INSERT INTO sch_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","A juorpuinu riming chu Mary ani, ama han Pumapa ke bula insungin, a chongril a rangâia. ");
INSERT INTO sch_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ania, Martha chu sinthôn ânpol oka, a honga, “Pumapa, kênzirpui nûn ke theivaia sintho ranga ni mâkrak hih ni mindon pe mak che mo hi?” ni hong san rangin tipe roh! a tia. ");
INSERT INTO sch_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pumapa'n amanu kôma, “Martha, Martha, neinun tamtak ni mindon sika nênjêl kêng. ");
INSERT INTO sch_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Inkhat vai kêng ai nâng, Mary hin neinun dik a thanga, a kôm renga isut nôk rang ni khâi mak,” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Sûnkhat chu Jisua'n, mun inkhata chubai a thoa. A zoiin chu, a ruoisi inkhatin, “Pumapa, John'n a ruoisingei chubai tho a minchu ngei ngâi angin keini khom chubai tho mi minchu roh,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Hanchu, Jisua'n an kôma, “Chubai nin thoa anîn chu hi ang hin ti roi: ‘Kin Pa: Ni riming inthieng mirit om rese; Ne Rêngram juong tung rese. ");
INSERT INTO sch_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nîngtin kin sâk rang anâng ngei mi pêk roh. ");
INSERT INTO sch_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kin sietnangei mi ngâidam roh, Keini khomin, kin chunga saloi tho ngei kin ngâidam ngâi sikin, Minsinna intakna mi tuong no roh,’ ” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Hanchu, Jisua'n a ruoisingei kôma, “Tumakhatin, jânchima a malpa ina se senla, ‘Mal, vâipôl tâpthum ni lei sem roh. ");
INSERT INTO sch_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ka malpa khuola a honga, ite man sâk rang lak nei mu-unga!’” ti senla. ");
INSERT INTO sch_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","A malpan in sûng renga, “Ni hong jêl khâi no roh, inkhâr ka kal zoia, ka nâingei leh kin jâl kêng ani zoi. Inthoiin ite nang pêk thei khâi no ning!” ti ta senla. ");
INSERT INTO sch_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Hanchu, a mal ni nia, inthoiin nang a hong pêk no nâka, inzak loia ne ngênrît sikin inthoiin nu nuom dôr nang hong pêk a tih, a tia. ");
INSERT INTO sch_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Masikin nangni ki ti, zong roi, ipêk nîng nin tih, rok roi man nin tih, tôk roi inkhâr mo-ong pe nîng nin tih. ");
INSERT INTO sch_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Asikchu, tutu a zong kai chu ipêk nîng an ta, a rok kaiin chu man an ta, a tôk kai chu inkhâr mo-ong pe nîng an tih. ");
INSERT INTO sch_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nangni lâia pangei hin, nin nâingeiin ngâ nangni zong rese ngei, murûl pêk ung mo? ");
INSERT INTO sch_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Nôn chu, ârtui nangni zong rese ngei, âinuvet pêk ung mo? ");
INSERT INTO sch_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nangni misaloi ngeiin luo, nin nâingei neinun sa pêkna chang nin rietin te, nin Pa invâna omin vângin chu a nâingei idôra mo Ratha Inthieng ai pêk ok rang na! a zongpu murdi chu” a tia. ");
INSERT INTO sch_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Hanchu, Jisua'n ramkhori chong theiloi inkhat a rujûlpaia, a jôk suole chu miriem chong theiloi hah a chong thei zoia. Mipuingei han an kamâm sabaka. ");
INSERT INTO sch_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ania, mi senkhatin chu, ramkhori rêngpa, Beelzebul kêng, rujûlpai theina ranak a pêk ani, an tia. ");
INSERT INTO sch_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Senkhatin chu ama min ôkna rangin, Pathien renga sininkhel sin rangin an tia. ");
INSERT INTO sch_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ania, Jisua'n an mindonna a rieta, masikin an kôma, “Kho ram khom insena anni le anni indoi kai chu ram an tih, insûngkuo khom anni le anni indoi kai chu inmang an tih. ");
INSERT INTO sch_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Soitan rêngram khom pâl sinin anni le anni an indoiin te, inmo ânding ranga? Inmo, Beelzebulin rachamneina a pêka ramkhoringei a rujûlpai ngei ni nan ti thei,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ma anga Beelzebul sika ku rujûlpai ngâi anin le, nin nûkjûi ngeiin tu sikin mo an rujûlpai ngâi? Anni han nin dikloi ani iti nangni an minthâr ani. ");
INSERT INTO sch_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Hanchu, Pathien rachama ramkhoringei ka rujûlpai ngâi anin chu, Pathien Rêngram nin kôma ajuongtung tatak ani zoi a minthâr ani. ");
INSERT INTO sch_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Mi râtin râlrovo kipa, a in a ngâkin chu, a neinuntin mojôkin a om ngâi. ");
INSERT INTO sch_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ania ama nêka rât uolin a hong doia, a menên chu, ân tûngna râlrovo nâm a lâk pea, a neinun ai lâk pe khom a sem minzar ngâi. ");
INSERT INTO sch_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Tutu keima tienga kop loi kai chu midoi ania, tutu ni mintûp pui loi kai chu a chekminchâi ani.” ");
INSERT INTO sch_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ratha saloi hah, mi sûng renga a jôkpaia anîn chu, tui boina rama inngam mun rokin a chai titira, a man loi tena chu, “Ki ina kîrnôk ki tih” a tia. ");
INSERT INTO sch_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","A hongkîr nôkin chu, in phiet min saia cherêl diem a mua. ");
INSERT INTO sch_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Hanchu a se nôka, ratha saloi dang sari, ama nêka puoloi uol a hong tuonga, an lûta, an om ngâi. Masikin ma miriem omdân anûka hah chu a motona nêkin a siet uol ngâi. ");
INSERT INTO sch_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisua'n ha chong hah a misîr zoiin chu, mipui lâi renga nupang inkhat a hêta, “Nupang nang a vonga nang a donsûinu chu satvur ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jisua'n a thuona, “Pathien chong rieta a jôm ngei chu satvur anni uol,” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Mipuingeiin an ûmhur lâiin Jisua'n, atûnlai mingei hih idôra siet mo anni zoi? Sininkhêl an zonga, hannisenla, Jonah minsinna pênna chu ite minsinna dang ipêk ni no nih. ");
INSERT INTO sch_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nineveh, khuo mingei ranga dêipu Jonah minsinna ai ni anga han atûnlâi mingei rangin chu, Miriem Nâipasal hih minsinna nîng a tih. ");
INSERT INTO sch_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Roijêk Nîn chu Thang tienga Rêngnu Sheba lân ding a ta, atûnlâi mingei theiloimintum a tih. Rêng Solomon vârna rangâi rang pielin ram latak renga a hong sikin. Nangni ki ril Rêng Solomon nêka lien uol hin a om. ");
INSERT INTO sch_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Roijêk Nîn chu Nineveh mingei khom hong inding an ta, theiloi nangni min tum an tih. Jonah chong a rila an sietna renga an insîr sikin. Nangni ki ril Jonah nêka lien uol hin a om, a tia. ");
INSERT INTO sch_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Tutên, châti mockokin, thupin bêl nuoia dar ngâi mak, a darna muna kêng an dar ngâi, mi a lût murdi'n avâr an mu theina rangin. ");
INSERT INTO sch_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nin mitngei hi nin takpuma meivâr ang ani. Nin mit avârin chu, nin takpum khom a vâr iema, nin mit a sieta anîn chu nin takpum khom a jîngkhap ani. ");
INSERT INTO sch_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Masikin, singthei roi, nin vâr ajîng loina rangin. ");
INSERT INTO sch_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Hanchu, châtiin, nangni ai êlminvâr iem ngâi anga han nin takpum abâk ajîngna boi riekin, nin pumin vâr iem a tih. ");
INSERT INTO sch_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Hanchu, Jisua a chong zoiin chu, Pharisee inkhatin ama leh bu nêk rangin a siela, male a sea, bu nêk rangin ânsunga. ");
INSERT INTO sch_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Pharisee han, Jisua kut rusûk loia khalâi a ot a mûn chu a kamâm oka. ");
INSERT INTO sch_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Hanchu, Pumapa'n a kôma, “Nangni Phariseengei, kilât le bukhêng apêntieng nin minsâia, ania, nin sûng tieng chu huongna le sietna sip ani. ");
INSERT INTO sch_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mo ngei, apêntienga sinpu, Pathien'n asûng tieng khom ai sin nimak mo? ");
INSERT INTO sch_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ni kilât le bukhênga om hah inriengngei pêk inla hanchu, neinuntin inthieng let a tih.” ");
INSERT INTO sch_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Nangni Phariseengei nin chung ântak bah na! nin neinun manvâng, lêngmesêr, chimu murdi, sômakhat Pathien nin pêka, hannisenla, indikna le lungkhamna chu nin seleta, ha tak hah kêng nin sintum, adangngei khom selet uol loiin. ");
INSERT INTO sch_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Nangni Phariseengei nin chung ântak bah na! Inkhom ina sukmun asa nin midita, bazar muna mingei nangni an jâ nin rangâi minluta. ");
INSERT INTO sch_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Nin chung ântak bah na! Thân muruo sîntholoi mîn riet loia a chunga an lôn ang hah nin ni,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Hanchu, Balam minchupu lâia inkhatin, a kôma, “Minchupu, ma ni ti hah keini khom mi na êrona kêng” a tia. ");
INSERT INTO sch_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jisua'n a thuona, “Nangni, Balam minchupungei khom nin chung ântak, mi chunga pêl ântak, puok rik nan bânga, a pêlpui rangin chu nin kutmitin le luo tôn mak chei. ");
INSERT INTO sch_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Nin chung ântak bah na! Nin richibul ngeiin an ithat dêipungei thân nin sinsiema. ");
INSERT INTO sch_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nin richibul ngeiin dêipungei an lei that hah nangnin khom nin pompui minennân an thânngei nin sinsiema. ");
INSERT INTO sch_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Masikin, Pathien vârnân, Dêipungei le Thangtheingei tîr ka ta, senkhatngei that an ta, senkhatngei dûk mintong an tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Masikin rammuol insieng renga dêipungei an lei that sikin, atûnlâi mingei hih dûk mintong nîng an tih. ");
INSERT INTO sch_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abel an that renga Zakariah dênin, ama vâng chu mâichâm le Muninthieng kâra that ani. Nangni ki ti, masik piela han atûnlâi mingei dûk mintong nîng an tih. ");
INSERT INTO sch_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Balam minchupungei khom nin chung ântak bah na! Rietna inkhâr in ongna chabi nin vonga, nangni lak lût no tunuia, a lût rang a nuomngei tena nin khapa. ");
INSERT INTO sch_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Hanchu, Jisua'n ha mun a mâkin chu, Balam minchupungei le Phariseengeiin an dema chong rekel tamtak an rekela. ");
INSERT INTO sch_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Thuonna minchâi a neia sûr theina rangin an muruong chien ani. ");
INSERT INTO sch_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mipui isâng tamtak, inkhat le inkhat insirpolin Jisua an bôma. Jisua'n a ruoisingei kôma, “Pharisee asarotholngei chol renga singthei roi. ");
INSERT INTO sch_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Jâttin ihîpa om la phong nîng a tih, a ipa om khom la phuongsuok nîng a tih. ");
INSERT INTO sch_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Masikin, ajînga nin ti ngei hah sûn khovâra lân phuong nîng a ta, khâltan sûnga kuor kunga nin ti ngei hah inchunga chuongin tânghâi la nîng a tih,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ka malngei nangni ki ril, ei takpum that suonûka, ite mi lo thei khâiloi chu chi no roi. ");
INSERT INTO sch_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Tumo nin chiruo nangni ril ki tih. Thi nûk khoma, dûkmuna nangni pai theina rachamnei ani sikin, Pathien chi roi, ani, nangni ki ti, Ama vai chi roi. ");
INSERT INTO sch_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Invate rangnga poisa nikin an juor ngâi ni mak mo? Ania, Pathien'n chu inkhat te luo hah mingil ngâi mak. ");
INSERT INTO sch_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nin lu chunga nin samngei tena khom itelvar kêng. Masikin, chi no roi, invate tamtak nêkin nin lut uol. ");
INSERT INTO sch_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nangni ki ril, tutu lôko rieta ni thop kai chu, Miriem Nâipasal khomin Pathien vântîrtonngei makunga thop a tih. ");
INSERT INTO sch_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Tutu lôko rieta ni hengpai kaichu, Miriem Nâipasal khomin vântîrtonngei makunga hengpai a tih. ");
INSERT INTO sch_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Tutu Miriem Nâipasal rilsiet chu ngâidam nîng a ta, Ratha Inthieng rilsiet chu ngâidam nino nih.” ");
INSERT INTO sch_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Hanchu, nin roi jêk rangin synagog mo, governor makunga mo, roijêkpungei makunga mo, nangni an tuong tikin, inmo ki thuon rang, imo ki ti rang, tiin nin mulung min jîng no roi. ");
INSERT INTO sch_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Nin ti rang chu a zora tika Ratha Inthiengin nangni ril a tih.” ");
INSERT INTO sch_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mipui lâia mi inkhatin Jisua kôma, “Minchupu, Ka lâibungpa kôm, kin pa rochon mi mâk pe mi sem rangin tipe roh,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jisua'n a thuona, “Mala, nangni inik chungroi jêk rang le nin rochon sem rangin tumo roineina mi pêk?” a tia. ");
INSERT INTO sch_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Hanchu, an rênga kôma, “Singthei roi, ôinangei murdi renga indîn thei roi, asikchu, rochon, neinangei hih miriem ringna abitak nimak, idôr khom nei resea,” a tipe ngei. ");
INSERT INTO sch_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Male, Jisua'n hi chongmintêk hih a ril ngeia, “Mi aneipa inkhat hin a loia chimu tamtak a minvânga, ");
INSERT INTO sch_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Inmo ko tho rang ani zoi, o, ka bu le bâl darna rang dôn khâi mu-ung hi,” tiin a mindona. ");
INSERT INTO sch_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Hi anghin tho ki tih, ka sasier set ka ta, anêka lien uol sin ki tih, mahan ke neinun murdi dar ki tih. ");
INSERT INTO sch_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Maleh, ka ratha kôma, “Ratha, kum tamtak rang neinun sa nu bûm zoi sikin, sâk inla nêk roh, ningbei riemin om roh tipe ki tih” a tia. ");
INSERT INTO sch_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ania, Pathien'n a kôma, “Amo, avien jân reng ni ringna aboi rang kêng ani zoi, hi neinun ni isuo ngei hih tuta rang tak mini?” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Hanchu Jisua'n, “Pathien tieng nei loia, eini ta rang vaia rochon a bûm chu ha anga han nîng a tih” a tia. ");
INSERT INTO sch_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jisua'n a ruoisingei kôma, masikin nangni ki ti, nin taksa sâk nêk rang, nin sil nin bom rang nin kâng mindoi no roi. ");
INSERT INTO sch_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Sâk nêk rang nêkin ringna alut uol, silbom rang nêkin takpum alut uol. ");
INSERT INTO sch_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Invatengei en ta u, chimu khom tu mak ngei, bu khom ât mak ngei, sasier khom nei mak ngei, hankhoma Pathien'n a vâia, vangei nêkin nin lut uol ok. ");
INSERT INTO sch_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Tumo a kângdoi sika a ringna a min sôt thei uola? ");
INSERT INTO sch_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ma ngeite luo nin tho thei loiin, imo neinun dang vângte nin kâng nin mindoi? ");
INSERT INTO sch_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ram pârngei en ta u, sin khom tho mak ngei, puon khom không mak ngei. Ania nangni ki ril, ma dôra anei, rêng Solomon luo han hi pârte hih phâk mak. ");
INSERT INTO sch_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Pathien kêng loisûl puon minsil, sûl aviena oma nangtûka lungthua hâl rip rang. Nangni vâng chu, nangni minsil no ni mo? Nin taksônna achîn bah na! ");
INSERT INTO sch_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Masikin nin sâk nin nêk rang mindonin nin kângmindoi no roi. ");
INSERT INTO sch_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Jentailngeiin ma ang roi chu an mindon ngâi. Nin Pa'n nin inâng chu a riet let. ");
INSERT INTO sch_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Manêkin a Rêngram mindon bak ungla hanchu ha neinunngei ha chu nangni pêng a tih. ");
INSERT INTO sch_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Chi no roi, lôm achînte ngei, nin Pa'n a Rêngram nangni pêk rang a nuom. ");
INSERT INTO sch_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nin neinun murdi zuor ungla, inrieng ngei pêk roi. Sumkok chettheiloia thun ungla, invâna achiem thei khâiloina ranga, inrungeiin an murûk thei khâiloina, rengên a siet thei khâiloina ranga ninta rangin rochon bûm roi. ");
INSERT INTO sch_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","No rochonngei omna kipa nu mulungrîl khom om tit a tih. ");
INSERT INTO sch_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Nin puon insilin, nin kong khitin, nin châti mochokin, tiklâi khomin intûng chienin om roi, ");
INSERT INTO sch_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","tîrlâm, an pu innei ruolhoi renga juong rang lei ngâk chien anghan. A juongleh, inkhâr a tôka mo-ong kelen rangin. ");
INSERT INTO sch_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tîrlâm, an pu juonga intûng chiena om ai juong mu chu mi satvur anni. Nang ki ril, a kong khit a ta, insung a ta, ngâk a tih. ");
INSERT INTO sch_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Jânchima mo, arkhuona mo, a juonga intûng chiena ai mu ngei chu mi satvur anni. ");
INSERT INTO sch_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Mahih riettit roi, in pumapa'n inru hong rang riet senla chu a in minset no nih. ");
INSERT INTO sch_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Masikin nangni khom intûng chienin om roi, nin tûng loi lâitakin Miriem Nâipasal juong a tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peter'n, “Pumapa, hi chongmintêk hih keini rang vai mo ni ti, mi murdi rang mo?” a tia. ");
INSERT INTO sch_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Pumapa'n a thuona, “tîrlâm iem om avâr tak, a pûn a insûng a cherêla, tîrlâm dang ngei azora kipa, an sâk a sem pe ranga uliena ai be chu tumo nini? ");
INSERT INTO sch_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","a pu a honga, ha anga lei tho tîrlâm ai mu chu mi satvur ani. ");
INSERT INTO sch_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Adiktakin nangni ki ril, ha tîrlâm tak hah a pun neinun enkolpun sin a tih. ");
INSERT INTO sch_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Hannisenla ha tîrlâm han a mulungin, ku pu la juong vak no nih, tiin a tîrlâmpa ngei, a tîrlâmnu ngei jêm senla, sâkin nêkin lênrûi senla, ");
INSERT INTO sch_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ha tîrlâm hah ân ningloi, ân tûngloi kârin, a pu juong a ta, tuk nôinek a ta, a iemloi ngei rangtum minchang a tih. ");
INSERT INTO sch_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Tîrlâm a pu nuomlam riet chaka intûng loia, sin nuomloi chu na takin jêmpol nîng a tih. ");
INSERT INTO sch_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Hannirese, riet loi sika, tôkmol sâkna rak tho minchâi chu jâmin jêm nîng a tih. Tutu atam an pêk kôma atam zong an ta, atam uol an ipêk kôma chu atam uol rok an tih. ");
INSERT INTO sch_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Pilchung mei leh hâl ranga juong kini, atûn khom kâng kelen tarse ku nuom. ");
INSERT INTO sch_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Baptisma ka chang ranga om hih, ânzoi mâka chu ki ning ânîp bah! ");
INSERT INTO sch_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Rammuola inngeina min lêng ranga juongin mo mi nin tûng? Inngêina min lêng ranga juong ni mu unga, insenna min lêng ranga juong kêng kini. ");
INSERT INTO sch_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Atûn renga insûngkuo inkhata mi rangnga insen an ta, inthum ngeiin inik ngei doi an ta, inik ngeiin inthum ngei doi an tih. ");
INSERT INTO sch_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Pa ngeiin an nâingei, nâingeiin an pangei, nungeiin an nâinupangngei, nâinupangngeiin an nungei, tarpingeiin an moingei, moingeiin an tarpingei doi an tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jisua'n mipui ngei kôma khom, “Nitâk tieng sûm a jînga anîn chu ruo a juong rang kêng nin tia, juong khom a juong ngâi. ");
INSERT INTO sch_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Hanchu thînthi a hong sêma anîn chu alum rang kêng nin tia, alum khom alum ngâi. ");
INSERT INTO sch_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Asarotholngei o! phil le invân nin ena, khuo om rang tie nin riet theia, ania, atûnlâi zora om tie ithomo nin riet thei loi?” a tia. ");
INSERT INTO sch_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ithomo nin theiin neinun dik sin rang nin mindon loi? ");
INSERT INTO sch_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mîn roijêkmuna nang an kai rangin chu, ha mi lehhan roijêkmun tung mân inngêina sinpui roh, aninôn chu, roijêkpu makunga nang kai a ta, intâng ina nang khum an tih. ");
INSERT INTO sch_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nang ki ril, poisa apêkte luo ne pêk let mâka chu mahan om ni tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ma lâiahan mi senkhatngei an oma, ha ngei han Galilee mingei Pathien kôma an inbôl lâia Pilat'n, mi a that thurchi Jisua an rila. ");
INSERT INTO sch_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jisua'n a thuona, “Ha anga, ithata an om hah Galilee rama midang ngei nêkin a nunsie uolin nin mindon mo?” ");
INSERT INTO sch_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","“Ni tet mak! Nangni ki ril, nangni khom nin sietna nin insîr nônchu, anni ngei angin nin thi var rang. ");
INSERT INTO sch_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Mi sômleiriet ngei Siloam in insâng achima athi ngei hah Jerusalema midang ngei murdi nêkin an saloi uolin nin be mo? ");
INSERT INTO sch_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ni tet mak! Nangni ki ril nin sietna nin insîr nônchu anni ngei anghan thîng nin tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Hanchu, Jisua'n hi chongmintêk hih a misîra, “Mi inkhatin a grape ruhuona theichang kung a linga. A mara a juong ena man maka. ");
INSERT INTO sch_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Hanchu, ruhuon enkolpu kôma, ‘En roh, kumthum piel hih hi theichang kunga hin amara ku juong roka, inkhat luo man mu-ung.’ Phûrpai roh, ithomo mun ai luo tit ranga,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ania ruhuon enkolpu han, “O pu, kumkhat mamang la om hi rese, a revêl tuk ka ta, a urna rangin vur ki tih. ");
INSERT INTO sch_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nakuma ânrân chu sa ok a ta, ânra nôn chu phûrpai roh” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sabathni voikhat chu Jisua'n, synagog ina a minchua. ");
INSERT INTO sch_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ramkhori sûr nupang inkhat kum sômleiriet damloi a oma, inkona injîk thei loi ani. ");
INSERT INTO sch_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Hanchu, Jisua'n a mûn chu a koia, “Nuvengtenu na natna renga no jôk zoi” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","A chunga a kut a minngama, harenghan ân jîkzata, Pathien a minpâk zoi. ");
INSERT INTO sch_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Hanchu, Jisua'n Sabathnîn mi a mindam sikin synagog taka ulienpu a ning a thika, mipui ngei kôma, “Sûnruk sin ei thona rang a om, ha nia han hong ungla dam roi, Sabathnîn chu ni no rese” a tia. ");
INSERT INTO sch_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Pumapa'n a thuona, “Nangni, asarotholngei, nin serâtchal mo, nin sakuording mo, Sabathnin sûntin tui min nêk rangin nin tuong ngâi ni mak mo? ");
INSERT INTO sch_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Hi nupang, Abraham jâisuon, kum sômleiriet, satanin ai khit hih, Sabathnin min jôk rang ni mak mo?” a tia. ");
INSERT INTO sch_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","A chongthuon han a râlngei mâimôk an tonga, mipui lakin a sininkhêl sin sikin an râisâna. ");
INSERT INTO sch_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jisua'n a rekela, “Pathien Rêngram hih imo ai ang? Ileh mo ki mintêk rang? ");
INSERT INTO sch_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ancham ru, mi inkhatin a lâka loilâia a tua. A kung ahonn insôna, thingkung ahong changa, a machangngeia han vangeiin rubu an phan anghan ani” a tia. ");
INSERT INTO sch_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jisua'n a rekel nôka, “Ileh mo Pathien Rêngram ki mintêk rang ani zoi? ");
INSERT INTO sch_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nupang inkhat chol a lâka, vâipôl, liter sômminli leh a minpola athoi mâka tâidôna ai bil angha ani” a tia. ");
INSERT INTO sch_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jisua'n Jerusalema a se malamin, khopuingei le khuotengeia mi a minchu ngeia. ");
INSERT INTO sch_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Tumakhatin, O pu, mi tômte vai mo sanminjôka om rang? tiin a rekela. ");
INSERT INTO sch_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Jisua'n a thuona, “Inkot in-epa lût rang ranak song roi, mi tamtakin bôk an ta chu lût thei no ni ngei. ");
INSERT INTO sch_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","A in pumapa ânthoia inkhâr akal suole chu, pêntieng indingin inkhâr tôk nin ta, ‘A pumapa, inkhâr mi mo-ong pe roh’ tîng nin ta, ama lakin, ‘Khotienga mi mo nin ni, nangni riet mu-ung, ko kôm renga rotpai roi,’ nangni tîng a tih. ");
INSERT INTO sch_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Maleh, nangnin, munkhatin ei sâka, ei nêka, kin khopuia khom mi ni minchu ngâi duo! la tîng nin tih.” ");
INSERT INTO sch_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nikhomrese, ama han, “Khotienga mi mo nin ni, nangni riet ngâi mu-ung, Ko kôm renga rotpai roi, mipuoloi ngei nangni ti nôk a tih.” ");
INSERT INTO sch_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Ipaia nin om tikin chu chapin, hâ riel nin ta, Abraham ngei Isaac ngei, Jokob ngei le dêipungei murdi chu Pathien Rêngrama omin mûng nin tih. ");
INSERT INTO sch_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Mingei sak le thang, sim le mâr renga hongin Pathien Rêngram ruolhoia insung an tih. ");
INSERT INTO sch_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Hanchu atûna nûktak ânta ngei khom hih motontak la nîng an ta, motontak ngei khom nûktak la nîng an tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ha lâitaka han, Pharisee senkhat an honga, Jisua kôma, “Jôk inla hi mun renga hih mun danga rot ta roh, Herod'n nang that rang ai ti kêng,” an tipea. ");
INSERT INTO sch_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jisua'n, “Se ungla ha sial hah varil roi, avien, nangtûk ramkhori rujûlpai ka ta, a sûnthum nîn ki sin zoi ki tih.” ");
INSERT INTO sch_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ikhomnisenla, avien, nangtûk, hatûk ke se tit rang ani, Jerusalem pêntieng dêipu that ngâi ni mak an tia. ");
INSERT INTO sch_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O, Jerusalem, Jerusalem! Dêipungei thatpu, no kôma Pathien'n a hongtîr ngei lung leh dêng thatpu, ârpuinûn a mantha nuoia ate ngei ai op ngâi anghan, voizet mo nang opbûm rang ko bôk zoi, ania nuom mak che. ");
INSERT INTO sch_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Masikin, Pumapa riminga hong chu ‘Pathien'n satvur rese’ nin ti mâka chu nin Biekin ram a ta, ni mu nôk khâi no tunui,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabathni voikhat chu, Pharisee ulien inkhat ina Jisua bu nêk rangin a siela, mîn an enrichika. ");
INSERT INTO sch_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mi inkhat a ke, a bânngei inthing, Jisua kôma a honga. ");
INSERT INTO sch_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jisua'n, Balam minchupungei le Phariseengei kôma, “Ei Balamin Sabathni mi mindam a phal mo, phal mak mo?” tiin a rekel ngeia. ");
INSERT INTO sch_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Hanchu an dâireka, Jisua'n damloi hah a sûra, a mindama, a min se zoia. ");
INSERT INTO sch_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Hanchu, Jisua'n an kôma, tumakhatin a nâipasal mo, a seratchal mo, Sabathnin tuikhura tâk senla, Sabathni nikhomrese, kelsuo kelen no tunui mo? a tia. ");
INSERT INTO sch_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Hannisenla ha chong hah tutên thuon thei mak ngei. ");
INSERT INTO sch_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","An mi siel ngei mi senkhatin sukmun asa an thang, a mûn chu Jisua'n hi chongmintêk hih a ril ngeia. ");
INSERT INTO sch_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Mîn inneina ruolhoia nangni an sielin, sukmun asana insung no roi.” nin nêka mi lien uol an sielin chu, ");
INSERT INTO sch_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","in pumapa no kôma hongin, “Ama hi mun ot roh” tîng a ta mâimôk takin mun innuoina insung ni tih. ");
INSERT INTO sch_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Manêk han, nang an siela anîn chu mun innuoina insung inla, a pumapa hong a ta, no kôma, “Mala, mun asana hong insung roh tîng a ta, hanchu, khuolmingei makunga mirit lông ni tih. ");
INSERT INTO sch_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Omlien ngei kai intem an ta, omchîn ngei chu minlutin om an tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jisua'n a sielpu kôma khom, “Sûna mo, jâna mo, ruolhoi no tho tikin chu, na malngei mo, na lâibungngei mo, nu sûngsuokngei mo, nu bunga minei ngei mo, siel no roh, nônchu nang siel nôk an ta, nang thuon nôk an tih. ");
INSERT INTO sch_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ruolhoi no thôn chu inriengngei, a ôingei, kholrangei, mitchongei siel roh, ");
INSERT INTO sch_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","nang an thuon theiloi sikin sat nang vur sâng a tih, midikngei inthoi nôk tika Pathien'n nang thuon a tih,” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Hanchu, a khêng otpui inkhatin a chongril a rieta, a kôma, “Pathien Rêngrama ruolhoia insung rang ngei chu idôra râisân a om rang mo na!” a tia. ");
INSERT INTO sch_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jisua'n a kôma, “Mi inkhatin ruolhoi roiinpui tak a minsûka, mi tamtak a siela, ");
INSERT INTO sch_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","anêk zora tikin chu a mi siel ngei kôma, ‘Hong ta roi jâttin ânzoi zoi,’ iti rangin a tîrlâm a tîra. ");
INSERT INTO sch_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Hanchu an rêngin inlêmna an nei chita, A motontak han a kôma, ‘Loi ko rochôka, a en ke se rang, ni muduol roh,’ a tia. ");
INSERT INTO sch_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mi dangin, seratchal bop rangnga ko rochôka, a enmindik rangin ke se rang ani, ni lei muduol roh,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Mi dangin, “inkenei suobil kêng ania, masikin hong thei no ning,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ma tîrlâm hah a se sirin chu a pu a rila. A pumapa hah a takasia, a tîrlâm kôm, “Se lalai inla, kotmâingeia, lamlienngeia, inriengngei, a ôingei, mitchongei, kholrangei hongtuong ngei roh,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Tîrlâm han a kôma, “O, pu ni ti anghan ko thoa, ania, mun tamtak a la tong” a tia. ");
INSERT INTO sch_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Hanchu a pûn, a tîrlâm kôma han, “Sênla, lamliena, lamkêma mingei, ki in sipna rangin hongtuong lût roh. ");
INSERT INTO sch_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nang ki ril, mi ki siel ngei han tutên ka ruolhoia sâk noni ngei a ti,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Voikhat chu mipui tampa Jisua leh an inruoia, an tieng ânheia, an kôma, ");
INSERT INTO sch_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Tutu a nû le a pa, a lômnu le a nâingei, a lâibungngei le a sarnungei, le ama takpum nêka, lungkham mi mu uol nônchu, ko kôma hongin ku ruoisi nithei no nih. ");
INSERT INTO sch_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Tukhom ama khros ruputa mi jûi loipu chu ka ruoisingei nithei no nih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tumakhatin in insâng sin rang bôk senla, insungin a sin zoina rang sum a dôn le dônloi mindon bak a tih. ");
INSERT INTO sch_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Lungphûm a phûm suole, zoi thei khâi tano senla, a mu nâmin munuisan an tih. ");
INSERT INTO sch_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","A in sin a phut nâka chu, zoi thei khâi mak tîng an tih. ");
INSERT INTO sch_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Hanchu, tu rêng mo, a mi isângsôm leh rêng danga mi isângsômnik leh ama doi ranga juong, a ngam rang le ngamloi rang, insungin a mindon bak loi rang? ");
INSERT INTO sch_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","A doi ngamloi rangin chu, alazana an la om lâiin, inngêina sin rangin thangthei tîr a tih. ");
INSERT INTO sch_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ma anghan, tutu nangni khom a nei murdi a mâk riei nônchu ku ruoisi ni thei no tunui. ");
INSERT INTO sch_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Michi hi asa, ania, a alna boi ta senla chu, min al nôk thei ni khâi mak. ");
INSERT INTO sch_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Pil rang khomin, ur rang khom sa mak, vôrpai rang vai kêng. Kuor nin dônin chu rangâi roi,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Sûnkhat chu sumrusuongpungei mi tamtak le mi nunsiengei Jisua kôm chong rangâi rangin an honga. ");
INSERT INTO sch_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Phariseengei le Balam minchupungeiin, “Hi mi hin, mi nunsiengei a modôma, munkhatin sâk khom an sâkpui ngâi,” tiin an chiera. ");
INSERT INTO sch_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Masikin, Jisua'n hi chongmintêk hih a rila. ");
INSERT INTO sch_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Nin kâra inkhatlam hin belri razakhat nei ungla, inkhat inmang senla imo a tho rang? Sômkuoleikuo hah sûla mâng a ta, ânmang hah aman mâka rok noni mo? ");
INSERT INTO sch_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","A manin chu râisân takin a dâra hong ruputin a ina hongpui a tih. ");
INSERT INTO sch_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Hanchu a ruolngei, a bungmingei koitûp a ta, ke belri inmang ka man nôk zoia, ka râiasân. Masikin, râisânna mi tho pui roi tîng a tih. ");
INSERT INTO sch_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ma anghan, nangni ki ril, mi sômkuoleikuo insîr nâng khâiloi ngei nêkin mi nunsie inkhat insîr sikin invâna râisânna a om uol ngâi. ");
INSERT INTO sch_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Nupang inkhatin sumdâr sôm nei senla, inkhat minmang senla, imo tho ni? Châti mochokin a in phiet a ta, a man nôk mâka takintâi takin rok a tih. ");
INSERT INTO sch_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","A man nôkin chu a chamnungei le a bungmingei koitûp a ta, an kôma, ku sumdâr minmang ka man nôk zoi ka râiasân, râisânna mi thopui roi tîng a tih. ");
INSERT INTO sch_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nangni ki ril, ma anghan mi nunsie inkhat insîr sikin Pathien vântîrtonngei an râiasân ngâi. ");
INSERT INTO sch_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jisua'n, “Mi inkhatin nâipasal inik a neia; ");
INSERT INTO sch_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","nâipang uolin a pa kôma, ‘O, pa rochon ka chang rangtum chu atûn mi pêk ta roh,’ a tia. Hanchu, a rochon hah a nâingei an ruonin a sem pe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","A nâipang uol han, sûntomte suole chu a changtum murdi a juora a lâk rieia. Hanchu a in mâkin ram lataka a sea, nuomninga omin a sum a hekpe zoia. ");
INSERT INTO sch_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Hanchu, a sum a hekpe suole chu, ha rama han mâitâm achula, ite sâk rang nei khâi maka. ");
INSERT INTO sch_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Hanchu, ha rama mi inkhat ava pana, ama han a vokngei enkol rangin a loia a tîra. ");
INSERT INTO sch_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Vokngei sâk ngâi bê hôkngei sâk rangin a ôi zoia, ania, tutên ama a sâk rang pêk mak ngeia.” ");
INSERT INTO sch_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Nangkana, a honng inrietsuok le chu, ‘Ka pa ina inlo mingei bu nêk zoiloi pêna a nei intam tia laka, kei lakate hin vonchâmin ki thi rang na! ");
INSERT INTO sch_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Inthoi ka ta ka pa kôma se nôk ki tih, a kôma, O pa, Pathien chunga le nangma chunga ku nunsie zoi. ");
INSERT INTO sch_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Na nâia be rangin luo chuk khâi mu-ung, no kôma inlo mi inkhat angin mi be ta roh,’ tîng ki tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Hanchu ânthoia, a pa kôma a se zoia. Lâtaka a la om lâiin a pa'n a lei mua, lungkham amu oka, a tâna, a kola, a tuma. ");
INSERT INTO sch_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Hanchu, ‘O pa, Pathien chunga le nangma chunga, ku nunsie zoi, na nâia be rangin chuk khâi mu-ung,’ a tia. ");
INSERT INTO sch_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Hannisenla a pa'n, a suokngei kôma, Innot takin rovo satak min hak roi, a kutruola kutsabi minbun ungla, a kea kekok minbun roi. ");
INSERT INTO sch_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Serat tuoi sa tak that ungla, râisânna ruolhoi sâk ei tih. ");
INSERT INTO sch_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Hi ka nâipasal hih, a thia ân thoinôk ani; ânmanga man nôk ani,” a tia. Hanchu râisânna ruolhoi an phut zoi. ");
INSERT INTO sch_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Hanchu a nâi ulien uolpu chu loia a oma, in a hongtung rangin chu, berlem miring le lâm rahang a rieta, ");
INSERT INTO sch_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Hanchu tîrlâm inkhat a koia, Imo ani zoi? tiin a rekela. ");
INSERT INTO sch_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Hanchu, a kôma, “Na nâipa a hongkîr nôka, nin pa'n a ring a dama amu nôk sikin râisânnân serat tuoi thâitak a thata, ruolhoi a tho ani,” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Hanchu, a ulienpa chu a taksi sabaka, ina khom lût nuom khâi maka, hanchu a pa a hongsuoka, a methêma. ");
INSERT INTO sch_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ania a pa kôma, “En roh, hi ten kum hih nata rangin tîrlâm sinin ki sina, no chong khom jôm loiin om ngâi mu-ung. Ania imo mini pêk ngâia? Ka malngei leh ruolhoi thona rangin, kêlte luo mi pêk ngâi mak che. ");
INSERT INTO sch_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Hannisenla, hi na nâi norchon notizuorngei kôma ânchêk suole a hongkîr nôkin chu, serat tuoi thâitak na thatpui,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","A pân a kôma, “ka nâipasal ko kôma omtit kêng nini, ki nei murdi hih nata kêng. ");
INSERT INTO sch_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ania, râisâna ei mang rang kêng ani, na nâipa hih a thia a ring nôk kêng ani, ânmanga ei man nôk ani sikin,” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisua'n a ruoisingei kôma, “Mineipa inkhatin a tîrlâm, a rochon enkolpu a neia, a pu sum ânchêk tiin a pu kôma an nôna. ");
INSERT INTO sch_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Masikin a pûn a koia a kôma, Nu chung roi ki riet hih inmo ani? Nu sum enkol, a roi an rêngin miziekin mi pêk roh, atûn renga chu sum enkolpu chang thei khâi no tinih,” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ha tîrlâm han, “ku pûn ki sinna ni minmâkin imo ki sin rang? pil tuk laka rât mu-unga, kutdo laka kên zaka,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Hanchu, ki sin hih ni minmâk tika, malngeiin an ina min man om theina rang chang ki riet zoi, a tia. ");
INSERT INTO sch_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Hanchu, a pu sum ântângngei nâm a koia, amotontakpa kôma, “idôrmo nêntâng?” a tia. ");
INSERT INTO sch_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ama han, “Olive sariek ûm razakhat” a tia. A kôma, “hi nêntângna lekha, thuon inla, sômrangngân miziek roh,” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Midang a rekel nôka, nangte idôr mo nêntâng? a tia. “Bu tumbu isângkhat” a tia. “Hi nêntângna lekha, razarietin miziek roh” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Hanchu, a pu sum enkolpu dikloi, a milak thei tie ânpâka, avâr nâingei nêkin rammuol nâingei hi atûnlai roia chu an vâr uol, a tia. ");
INSERT INTO sch_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jisua'n, “Nangni ki ril, rammuol rochonin ruol sin no ungla, aboi tikin kumtuong ina nin om theina rangin,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Tutu atômte chunga iemom chu atam chunga khom iem aom ngâi, tutu atômte chunga iemomloi chu atam chunga khom iemom ngâi mak. ");
INSERT INTO sch_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Rammuol rochona luo iem nin om nônte, tumo rochon tak vâng hate nangni minrâk ranga? ");
INSERT INTO sch_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Midang ta chunga luo iem nin om thei nônte, ninta hah tumo nangni pêk ranga? ");
INSERT INTO sch_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Tîrlâm inkhatin pu inik sin tho pe thei no nih. Inkhat heng a ta inkhat midit a tih, nônchu, inkhat sûr a ta, inkhat mathân a tih. Pathien le sum sin minlop thei no tunui,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Hanchu, Pharisee, sum rangâiminlut ngei han a chong murdi an rieta, an chiera. ");
INSERT INTO sch_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jisua'n an kôma, “Mi mitmua a dikin nin inlanga, ania, Pathien'n nin mulung a riet. Miriemin neinun aliena ai be hih Pathien mitmûn chu akâmboi ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Moses Balam le dêipungei lekha ngei han Baptispu John tena hah a huoma, masuo renga chu Pathien Rêngram Thurchi Sa an misîra, mitinin rangrâta lût rangin an pût chita. ");
INSERT INTO sch_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ania, Balam chong, miziek minhâng chînte boi nêkin invân le pil aboi abai uol. ");
INSERT INTO sch_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Tutu a lômnu a mâka, midang a neiin chu a inrê ani, mi imâknu neipu khom a inrê ani.” ");
INSERT INTO sch_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Mineipa inkhat a oma, puon mantam ngei silin nîngtinin hoiinhâia lêngin a om ngâia. ");
INSERT INTO sch_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Inrieng inkhat, a riming Lazarus a vun pânin a tuom, mineipa inkot bula an hongtuong ngâi, a oma. ");
INSERT INTO sch_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Mineipa dosâng nuoia bu ramal tâk nêk rang a nuoma, uingei lakin apân an miliek pe ngâia. ");
INSERT INTO sch_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Inriengte hah a thia, invânram ruolhoia Abraham kôla insung rangin vântîrtonngeiin an tuonga. Mineipa khom a thia an phûma. ");
INSERT INTO sch_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ithi khuoa ana tuongin a oma, a hong tanga lâtaka Lazarus, Abraham kôla insung a hong mua. ");
INSERT INTO sch_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Hanchu ân-ieka, “O pa, Abraham lungkham ni mu inla, Lazarus a kutpâra, tui mindui senla, ke melei mindâi rangin ni juongtîr pe roh, hi meia hin ana ki rietrai zoi sikin,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ania, Abraham'n, Ka nâipasal, ni ring lâiin, neinunsa murdi na changa, Lazarus rêk chu asaloi murdi ai chang hah riet roh bah, ania atûn ama chu, hoi takin a oma, nang chu ana tuongin no om zoi ani. ");
INSERT INTO sch_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Mapêna tutu anuom khomin, hi tieng renga ha tieng inkân thei loina rang le ha tieng renga hi tieng kânga hôn kân thei loina rangin ei kâra hin pil achat inthûk a om kêng,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Hanchu mineipa han, “O pa, Abraham, Lazarus hah ka pa insûngkuoa ni tîr pe rangin nang ki ngên. ");
INSERT INTO sch_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Lâibung rangnga ke neia, hi natna muna an hong loina rangin ni juong ril pe rese,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham'n, “Na lâibungngei ril rang chu Moses le dêipungei an nei mo ka ta, ha ngei chong hah rangâi rese ngei,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Mineipa han, O, pa Abraham, mavai han chu chuk thei no nih, athi renga ânthoi ngei an kôma se vaiin kêng an sietna an insîr rang,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ania, Abraham'n, Moses le dêipungei hê an lâk nônchu, athi renga inthoinôkin se senla ngei khoma, taksôn uol noni ngei,” a tipe. ");
INSERT INTO sch_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisua'n a ruoisingei kôma, inpalna hih omloi thei nimak, ania inpalna min ompu chung chu ântak bah na! ");
INSERT INTO sch_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Hi mi chînte ngei lâia inkhatlam minpal chu, a minpalpu ringa han bunôilung minlîn tuikhangliena vôrpai ni senla, ata rangin sa uol a tih. ");
INSERT INTO sch_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Singthei roi, na lâibungin nunsie a thôn chu ngo roh, ânsîrin chu ngâidam roh. ");
INSERT INTO sch_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","nu chunga sûnkhatin voi sari saloi a thôn, voi sari kênsîr tiin, no kôm a hongin chu, na ngâidam ngêt rang ani. ");
INSERT INTO sch_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ruoisingei han a kôma, “Pumapa, kin taksônna mi min detpe uol roh,” an tia. ");
INSERT INTO sch_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Hanchu, Pumapa han, “Ancham ru dôra hih taksônna nin neia anîn chu hi thingtheimu kung hih hong inphôi inla, tuikhangliena hong inphun roh, tîng nin ta nin he rangâi kelen atih,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Hanchu, nin lâia tumakhatin, tîrlâm pil tukin mo, belri hôlin mo, nei ungla, chuon a hong tungin, ‘Bukhalâi hong ot kelen roh’ tumo a ti rang nin nia? ");
INSERT INTO sch_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Manêkin, ‘Ku bukhalâi ni do bak inla, rovo tho inla, ka sâk ke nêk suo mâka ni ngâk roh, masuole nêk ni tih,’ tumo a ti loi ranga? ");
INSERT INTO sch_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Suokin chong a jôm sikin tumo râisânchong a ril ngâi? ");
INSERT INTO sch_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ma ang tak han, nin sintum nin sin suonûk khomin, tîrlâm papai kêng ei ni, ei sintum ei sin chak kêng nin ti rang ani.” ");
INSERT INTO sch_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Hanchu, Jisua'n Jerusalem a se malamin, Samaria le Galilee kâra ramria a lôna. ");
INSERT INTO sch_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Khuo inkhat a lûtin chu miphâr sômin an intongpuia. Lâtaka an indinga, ");
INSERT INTO sch_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","an inieka, “Jisua Minchupu, inrieng mi mu roh!” an tia. ");
INSERT INTO sch_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jisua'n a mu ngeia an kôma, “Se ungla, ochaingei kôma vân en roi” a tipe ngeia. Lampuia chu an dam zoia. ");
INSERT INTO sch_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Inkhatin chu a dam zoi iti a rietin chu, rôl inringtakin, Pathien minpâk pumin a hongkîr nôka. ");
INSERT INTO sch_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jisua ke bula inbokin râisânchong a rila, ha mi hah Samaria mi ani. ");
INSERT INTO sch_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jisua'n, “A damngei hah mi sôm nin nia, adang ikuo ngei hah khonmo an om? ");
INSERT INTO sch_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ithomo hi ramdangmi vai himo Pathien minpâk ranga hongkîr nôk?” a tia. ");
INSERT INTO sch_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Hanchu, a kôma, “Inthoi inla se ta roh, na taksônna hin nang a mindam ani,” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pharisee senkhat ngeiin Pathien Rêngram juongtung rang roi an rekela, Jisua'n, “Pathien Rêngram chu mu theiin juongtung no nih. ");
INSERT INTO sch_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Tutên ‘En roh,’ hin kêng a om, son kêng a om ti no nih. Pathien Rêngram chu nin lâia kêng a om,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Hanchu, a ruoisingei kôma, “Miriem Nâipasal ringlâi sûn hi sûnkhat te luo nin mu nuom ni, la om a tih; ania mu khâi no tunui.” ");
INSERT INTO sch_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mîn nin kôma, “ ‘En roh sô soh!’ ‘En roh hi hih,’ tîng an tih, ania, a en rangin vase no roi. ");
INSERT INTO sch_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Invâna kôl ânleka, kôlkung renga kôlmong dêna ai vâr ngâi anghan, Miriem Nâipasal juong ni lechu, nîng a tih. ");
INSERT INTO sch_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ania, ma mâna han tuong ok a ta, atûnlâi mingei hengpaiin om a tih.” ");
INSERT INTO sch_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noah zora lâia anghan Miriem Nâipasal zora khom nîng a tih. ");
INSERT INTO sch_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noah, rukuonga a lûta, tuilienin a that riei mâka chu mitinin an sâkin an nêka, nupang pasal omsiet an tho ngâi. ");
INSERT INTO sch_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lot zora anghan mi tinin an sâkin an nêkin, an rochôka, an juora, an linga, in an sin ngâia. ");
INSERT INTO sch_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lot'n Sodom a mâk nin chu mei leh kât invân renga a juonga, a that riei ani. ");
INSERT INTO sch_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ma anghan, Miriem Nâipasal juong inlâr nîn chu juong om a tih. ");
INSERT INTO sch_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ha nîn chu inchunga ompûn, a neinun lâk rangin chum no rese. Ha angdênin, loia om khomin a ina hongkîr no rese. ");
INSERT INTO sch_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot lômnu riettit ngâi roi. ");
INSERT INTO sch_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tutu a ringna mojôk rang bôk kaiin machân an ta, a machân kaiin jôk an tih. ");
INSERT INTO sch_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nangni ki ril, ha ni jânin chu, jâlmun khata mi inik jâl an ta, inkhat tuong nîng a ta, inkhat mâk nîng a tih. ");
INSERT INTO sch_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nupang inikin sângsuk an ta, inkhat tuong nîng a ta, inkhat mâk nîng a tih. ");
INSERT INTO sch_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Loia mi inik om an ta, inkhat tuong nîng a ta, inkhat mâk nîng a tih, a tia. ");
INSERT INTO sch_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Hanchu, ruoisingeiin, “Pumapa khotieng mo?” an tia. Jisua'n, “Ithi ruok omna kipa sêlkurungei intûp an tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Hanchu, sabei mindong loia chubai an tho tit rang ani iti rilna rangin hi chongmintêk hih Jisua'n a misîra. ");
INSERT INTO sch_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Khopui inkhata hin roijêkpu, Pathien khom chiloi, mi lien khom chiloi inkhat a oma. ");
INSERT INTO sch_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ha khou nanâka han meithâi inkhat a oma, ân dôipui chunga phuba lâk ranga ngênin a se bang ngâia. ");
INSERT INTO sch_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Zora sôtzan chu roijêkpu han nuom pe maka, ania nûka a mulungin, ‘Pathien le mi lien chi no khom inlang, ");
INSERT INTO sch_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","hi meithâi hin chakal ni tho banga, hi anga hin a hong banga anîn chu nûka chu ni la minjêl chit a tih. Masikin a phuba lei luokpui rong,’ a tia.” ");
INSERT INTO sch_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Pumapa'n, a chongril ala zoma, “Rangâi ta u, imo ha roijêkpu saloi han ai ti. ");
INSERT INTO sch_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Masikin, Pathien'n a mingei sanna ngêna, sûntin, jântina chapngei chungroi mindon noni mo? San minnu ni mo? ");
INSERT INTO sch_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nangni ki ril, an nuomnan inrang takin mindon pe a tih. Ania, Miriem Nâipasal a juong tikin rammuola taksônna mu ni mo?” a tia. ");
INSERT INTO sch_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ama le ama ka sa intia, midang esêl ngâi ngei kôma hi chongmintêk hih a misîra. ");
INSERT INTO sch_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Voikhat chu mi inikin Biekina chubai tho rangin an sea. Inkhat chu Pharisee ania inkhat chu sumrusuongpu ani. ");
INSERT INTO sch_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Pharisee chu athenin ândinga chubai a thoa, “Pathien, kei chu midang ngei angin mi ranghuol ngâi, dikloi, inrê mi khom kini loi sikin, râisânchong ki ril. So, sumrusuongpu anga khom ki niloi sikin râisânchong ki ril. ");
INSERT INTO sch_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Hapta tin sûnnik bu ke ngêi ngâia, ke nei murdi a sômakhat nang ke pêk ngâi,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ania, sumrusuongpu chu lâtaka indingin, invân tieng luo tang ngam loiin, a rôp ruchumin, “Pathien, mi nunsie ki ni, inrieng ni mu roh,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jisua'n nangni ki ril, “Pharisee mi ni loiin, sumrusuongpu chu Pathien mita theiintumin, a in tieng a se zoi. Tutu omlien kaichu intem an ta, intem kaichu minlutin om an tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Mi senkhatin, an nâitengei Jisua kôma, an chunga kut minngam rangin an tuonga. Hanchu, ha anga tho rang hah ruoisingeiin an lei mûn chu an lei ngoa. ");
INSERT INTO sch_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Hannisenla, Jisua'n nâipangte ngei a kôma a koia, an kôma, “Nâipangtengei ko kôma hong rese ngei, khap no roi, Pathien Rêngram chu hi anga nâipangte ngei ta kêng. ");
INSERT INTO sch_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Diktakin ki ti, tutu nâipangte'n Pathien Rêngram ai modôm anga modôm loiin chu asûnga lût tet no nih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Juda ruoipu'n Jisua a rekela, “Minchupu sa, kumtuong ringna ka manna rangin imo ko tho rang?” a tia ");
INSERT INTO sch_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jisua'n a kôma, “Ithomo asa mini ti? Pathien pênna chu tute misa omak. ");
INSERT INTO sch_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Chongpêk hah, ni riet duo, Inrê no roh, mi that no roh, inru no roh, dikloiin mi nôn no roh, na nû le na pa mirit roh,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ama han, “Ha chongpêkngei murdi hah chu ka nâipangte lâi renga ko jôm kêng ani” a tia. ");
INSERT INTO sch_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Mahah Jisua'n a riet lehan a kôma, “Neinun inkhat tho rang na la nâng, Ne nei murdi juor inla, asum hah inriengngei sem ngei roh, hanchu, invâna rochon nei ni tih, male chu hong inla ni jûi roh,” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Mahah ama'n a riet lehan, ânngûi oka, miriem neipa ani sikin. ");
INSERT INTO sch_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Hanchu, Jisua'n ânngûi a mûn chu, “Minei ngei Pathien Rêngrama lût rang ântak bah na! ");
INSERT INTO sch_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ut simphuoi kuora lût rang ântak nêkin mineingei invân rêngrama lût rang intak uol a tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","A chongril riet ngei nâmin, “Hanchu tumo sanminjôk nithei ranga?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jisua'n, “Miriem ranga nitheiloi hih Pathien rangin chu nithei ani,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Male Peter'n a kôma, “En roh! kin inngei mâkin nang kin jûi hih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jisua'n an kôma, “O, ani, adiktakin nangni ki ril, tutu Pathien Rêngram sika a in mo, a lômnu mo, a nu le pa mo, a lâibungngei mo, a sarnungei mo, a nâingei mo, mâk kai chu, ");
INSERT INTO sch_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","anêka tam uolin atûna ringlâi le zora la hong ranga kumtuong ringna khom la man ngêt a tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Hanchu ruoisi sômleinik ngei hah Jisua'n atheiin a tuong ngeia an kôma, “Rangâi ta u, Jerusalema ei se rang ania mahan, Miriem Nâipasal chungroi dêipungei lei miziek hah tung a tih. ");
INSERT INTO sch_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Jentailngei kuta pêk an ta, esêl an ta, munuisan an ta, michilkhum an tih. ");
INSERT INTO sch_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Jêm an ta, that an tih, ania, sûnthum suole aringin inthoi nôk a tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ania, ruoisingei han a chong reng rietthei mak ngeia, a chong ti hah anni rangin chu chong inthup ani sikin Jisua'n imo ai ti riet mak ngei. ");
INSERT INTO sch_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Hanchu, Jisua'n Jericho a tung rangin lampui kôla mitcho inkhat ânsunga, kut a doa. ");
INSERT INTO sch_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Mipui rahang a rietin chu, “Imo hi? tiin a rekela. ");
INSERT INTO sch_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","“Nazereth Jisua a hongvun ani,” an tipea. ");
INSERT INTO sch_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ânieka, “Jisua! David Nâipasal, inrieng ni mu roh” a tia. ");
INSERT INTO sch_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Moton tienga om mipui ngeiin, “Dâirek roh” tiin an ngoa. Ania ama'n ânring uolin, “David Nâipasal! inrieng mi mu roh,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Masikhan Jisua ân ngama, mitcho hah hongtuong rangin chong a pêka. A hongnâia anîn chu Jisua'n a rekela. ");
INSERT INTO sch_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Imo nang ki tho pe ranga ni nuom?” a tia. “O pu, amu nôk ku nuom,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jisua'n a kôma, “Anîn chu muthei roh, na taksôn nân nang a mindam ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Harenghan a muthei kelen zoia, Pathien minpâk pumin Jisua a jûi zoia. Mipui ngeiin mahah an mûn chu an rêngin Pathien an minpâk zoi. ");
INSERT INTO sch_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Hanchu, Jisua'n Jericho lûtin apala. ");
INSERT INTO sch_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mahan sumrusuongpungei ulientak a riming Zacchaeus an ti mineipa a oma. ");
INSERT INTO sch_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jisua hah i-anga mi mini, mu rang a nuoma, ania miriem dungbong ania, mipui tamrai sikin mu thei maka. ");
INSERT INTO sch_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Hanchu Jisua'n ma lampui a hongvun rang sikin, mipui moton tieng Jisua mu rangin a tâna, Theichangpui kunga a kala. ");
INSERT INTO sch_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jisua'n ha mun a hong phâka anîn chu a tanga a kôma, “Zacchaeus juong chum lai roh, avien chu ni ina kêng ku tung ngêt rang,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zacchaeus hah innot takin a juong chuma, râisân takin a ina a mintung zoi. ");
INSERT INTO sch_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mipui a mu ngei nâmin an chiera, “Mi nunsie ina kêng tung rangin a se rek zoi so,” an tia. ");
INSERT INTO sch_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Hanchu, Zacchaeus ândinga, Pumapa kôma, “Rangâi roh, O Pu! Ke neinun in-ang ânriengngei pêk ka ta, hanchu tutu, lei huong ta khom inlang, abâk minlîn thuon nôk ki tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jisua'n a kôma, “Avien, hi ina hin sanminringna a tung zoi, hi mi khom hih Abraham richi ani sikin. ");
INSERT INTO sch_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Miriem Nâipasal hih ânmangngei roka sanminring rang piela juong ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Hanchu, ha a chongril an rangâi lâiin Jerusalem anâi zoi sik le Pathien Rêngram juong inlang kelen ranga an sabei sikin chongmintêk a misîra. ");
INSERT INTO sch_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Hi chong hih a rila, “Mi lien inkhatin rêng changna roi hong lâka hongkîr nôk rangin ram lâtaka a sea. ");
INSERT INTO sch_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","A se rangtôn chu a suokngei sôm a koia, rângkachak sumdâr a pêk chita, ‘ko hong nôk mâka lei muphung roi’ a tia. ");
INSERT INTO sch_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ania, a ram mingeiin an hengpaia, a nûka palâi an tîra, ‘Hi mi hih kin rêng rangin nuom makme an ti,’” a tia. ");
INSERT INTO sch_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Hanchu, rêng an minchang zoiin a hongkîr nôka, idodôr mo an lei muphung rekel rangin a suokngei hah a makunga a koitûpa. ");
INSERT INTO sch_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Amotontakpu a honga, “O, Pu, mina pêk hah rângkachak sumdâr sômin ku muphung,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","A kôma, “No tho min sa, tîrlâm sa ni ni, neinun tômte chunga iem no om sikin, kholien sôm ngei chunga ulienin nang min chang ki tih,” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","A tîrlâm inikna a honga a kôma, “O Pu, inkhat mina pêk hah rângkachak sumdâr rangngan ku muphung,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Hanchu, ama kôma han, “Nang khom khopuilien rangnga ngei chunga ulienin om roh,” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Hanchu, adang a honga, “O Pu, en ta, na rângkachak sumdâr mi na pêk hah mâihûinân ku sûna ka darchien. ");
INSERT INTO sch_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mi inngar tak nini sikin nang ki chi ani. Na darloi khom na lâka, nu tuloi khom na ât ngâi” a tia. ");
INSERT INTO sch_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","A kôma, tîrlâm saloi ni ni, no chong nanâkin theiloi nang amintum. Mi inngar tak ki nia, ka darloi khom ka lâk ngâia, ku tuloi khom ka ât ngâi ni rieta, ");
INSERT INTO sch_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","anînte, ithomo ku sum hih a pungna ina ne lei dar loi, ko hong nôka hin apung leh ka man rang kêng ani, a tia. ");
INSERT INTO sch_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Hanchu, a kôla inding ngei kôma han, “A rângkachak sumdâr lâk pe ungla, sôm adônpu pêk roi,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Hanchu, ama'n a kôma, “O Pu, anîn chu rângkachak sumdâr sôm a dôn mo ka ta,” an tia. ");
INSERT INTO sch_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ama han an kôma, “Nangni ki ril, tutu a nei viet kai chu pêk mintam uol nîng a ta, a nei loi kai chu ai dôn viete khom hah lâk pe rip nîng a tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","“Hi ka râlngei, an rêng ranga minuom loi kai chu hong tuong ungla ka makunga that roi a ti” a tia. ");
INSERT INTO sch_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ma chong hah a misîr zoiin chu Jerusalem panin moton ânsa. ");
INSERT INTO sch_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Bethphage le Bethany khuo kôl Olive muol a tungin chu, an motona a ruoisi inik a tîra, ");
INSERT INTO sch_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“nin motona khuoa son vase ungla, nin lûtin, tute la chuongna ngâi loi sakuording te inthung mûng nin tih, sût ungla hin hongkai roi. ");
INSERT INTO sch_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tukhomin ithomo nin sût tiin an rekelin chu, Pumapa'n a nâng ani tipe roi,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Hanchu, an sea Pumapa'n a ti lam ang takin an va mua, ");
INSERT INTO sch_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Sakuordingte an sûtin chu a pumangeiin, “Ithomo nin sût?” an tia. ");
INSERT INTO sch_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Hanchu an kôma, “Pumapa'n ai nâng ani,” an tia. ");
INSERT INTO sch_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Sakuording te hah Jisua kôma an kaia, a chunga an puonngei an dâpa, Jisua an min chuonga. ");
INSERT INTO sch_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","A sena rang lampuia khom an puonngei an dâp tira. ");
INSERT INTO sch_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Hanchu, Jerusalem tung ranga Olive muol chum rangin chu a ruoisingeiin a sininkhêl sin an mu sikin rôl inring takin Pathien an minpâka. ");
INSERT INTO sch_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Pumapa riminga hong rêngpa chu Pathien'n satvur rese, invâna inngêina lêngin Pathien roiinpui rese,” an tia. ");
INSERT INTO sch_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mipui lâia Pharisee senkhatin Jisua kôma, “Minchupu, nu ruoisingei dâirek rangin ril roh,” an tia. ");
INSERT INTO sch_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jisua'n an kôma, “Nangni ki ril, hi ngei hih an dâirekin chu, lungngei tena luo an iniek rang ani,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Hanchu, an tung rangtôn chu, khopui hah a mua a châa. ");
INSERT INTO sch_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Ratha'nngamna chong hih avienni tena luo hin ni riet nita senla chu O! Aniatate mu thei khâi mak chea. ");
INSERT INTO sch_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Zora hongtung a tih, na râlngeiin nu rukul bula pil minpôngin nang huolvêl an ta, kil tina nang khap tit an tih. ");
INSERT INTO sch_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nu rukul sûnga ni mingei le nang minmang chit an tih, nu sûnga lung inchuon reng hôi no ni ngei; nang minring ranga Pathien juonglâi ni riet loi sikin,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Hanchu, Jisua'n Biekina ava lûta, neinun juorngei hah a rujûla. ");
INSERT INTO sch_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","An kôma, “Lekhabua miziekin Pathien'n, Ki in chu chubai thona in tîng an tih, a tia. Ania nangni rêkin chu inrungei khurin kêng nin sin hi,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jisua'n anîngtin Biekina a ril ngei ngâia. Ochaisingei, Balam minchupungei le mipui ruoipungeiin that rang an bôka. ");
INSERT INTO sch_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Hannisenla, mipui ngeiin ningsiet taka a chongril an rangâia bâikhat luo minsam rang an nuom ngâiloi sikin, a tho rang lam man mak ngei. ");
INSERT INTO sch_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Sûnkhat chu Jisua'n Biekina mingei a minchua, Thurchi Sa a misîr pe ngei lâiin, Ochaisingei, Balam minchupungei le upangei an honga, ");
INSERT INTO sch_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","a kôma, “Tu rachamin mo hi sin ngei hih no tho, tumo rachamneina nang a pêk?” miril roh an tipea. ");
INSERT INTO sch_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jisua'n an kôma, “Kei khom chong inkhat nangni rekel rong. Ni ril roi, ");
INSERT INTO sch_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","John han, Pathien rachamin mo, miriem rachamin mo mi a Baptis ngâi?” a tia. ");
INSERT INTO sch_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","An thenin an inkhala, “Imo ie ti rang? Pathien rachamin, ei ti lakin, itho mo John hah nin iem loi? mi tîng a ta. ");
INSERT INTO sch_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Miriem rachamin ei ti lakin, hi mipui ngei hin lungin mi dêng an tih, John hah dêipu ani itia an pom sikin, an tia. ");
INSERT INTO sch_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Masikin, riet mak meh” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Hanchu, Jisua'n an kôma, “kei khomin tu rachamin mo hi sinngei hih ko tho nangni ril uol no ning,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jisua'n hi chongmintêk hi mipui ngei a rila, “Mi inkhatin grape ruhuon a thoa, a donsûingei kôma a chuon inlo rangin a pêka, asôtzan va châm rangin ram danga a sea. ");
INSERT INTO sch_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Hanchu grape ramal zora a hong nîn chu a changtum lâk rangin a enkolngei kôma a tîrlâm inkhat a tîra. A enkolngeiin, a tîrlâm hah an jêma, kut korongin an min se nôka. ");
INSERT INTO sch_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Hanchu, tîrlâm dang a tîr nôka, ama khom hah an lei jêma, mâimôk ânsak bita, kut korongin an tîr nôka. ");
INSERT INTO sch_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tîrlâm dang, a inthumna a tîr nôka, ama khom hah an lei mophop nenga, an vôrpaia. ");
INSERT INTO sch_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Masuole chu grape ruhuon pumapa han, ‘Inmo ko tho rang ani zoi?’ ka nâi moroitak tîr ka ta, ama chu lei jâ ngêt an tih, a tia. ");
INSERT INTO sch_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Hannisenla, ruhuon enkolpungei han an lei mu lehan, ‘Hi mi hih a pumapa nâi ani. That ei ti u, hanchu a rochon ei ta nîng a tih’ tiin an inruola ");
INSERT INTO sch_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Hanchu ruhuon pêntieng an kelsuoa, an that zoia. Jisua'n, ‘A pumapa han ruhuon enkolpungei hah imo lo ta nih?’” a tia. ");
INSERT INTO sch_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Hong a ta, ha mingei hah that a ta, grape ruhuon hah a enkolpu dangngei pêk a tih,” a tia. Ha chong hah an rieta anîn chu, “Madôrpa chu tho noni ngei nga” an tia. ");
INSERT INTO sch_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jisua'n a en ngeia, an kôma, “Lekhabu'n ai ti hih imo atina? In sin ngeiin an hengpai mangmunboia an ibe hah, a kila lung kâmomtak a chang zoi,” iti hih. ");
INSERT INTO sch_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Tutu ha lung chunga inpal kai chu koichit an ta, ha lungin a dêng ngei vângchu innôi indichit an tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Balam minchupungei le Ochaisingeiin ma mun renghan Jisua sûr kelen rang an bôka. Hi chongmintêk hih anni demna ani iti an riet sikin. Ania, mipui laka an chia. ");
INSERT INTO sch_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Masikin chuminrên an roka, isûra, racham le ranak dônpu Rom Governor kuta an pêk theina rangin mi senkhat misa anga inlêma, Jisua enrichik rangin mi an tîra. ");
INSERT INTO sch_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Mangei han a kôma, “Minchupu, ni ti ngei le ni minchuna ngei hih adik. Tute zenuol nei loiin Pathien lungdo chongtak ni minchu ngâi iti kin riet. ");
INSERT INTO sch_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Hanchu, Rom Rêng Caesar kôma chôiruol kin chôi hih ei balamin ani mo, ni mak mo? Mi ril roh” an tia. ");
INSERT INTO sch_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Hannisenla an boti hah a rieta. ");
INSERT INTO sch_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","An kôma, “Sumdâr hah ni min en ta u, tu rimil le tu riming mo a chuong?” a tia. Anni han, “Rom Rêng, Caesar,” an tia. ");
INSERT INTO sch_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Mahah anîchu, “Caesar ta chu Caesar pêk ungla, Pathien ta chu Pathien pêk roi hana,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Hanchu, mipui makunga ite chong achâina sûr mak ngeia, a chongthuon lam hah an kamâma, an dâirek zoi. ");
INSERT INTO sch_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Hanchu Saducees senkhat, inthoinôkna omak ti ngâi ngei an honga, Jisua kôma, ");
INSERT INTO sch_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Minchupu, Moses'n, tukhomin a lâibungpân lômnu nei senla, nâi nei loiin thi ta rese, a nâipa'n, ha nupang hah luo nôkin a ulienpa richi rang a min nei rang ani, tiin a mizieka. ");
INSERT INTO sch_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Voikhat chu, urêng pasal sari an oma, a ulientakin lômnu a neia, nâi nei loiin a thia. ");
INSERT INTO sch_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","A innik nân ma nupang hah a luo nôka, ");
INSERT INTO sch_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","a inthum nân a luo nôka, ha angdêna han a sarina dênin an luoa, nâi nei loiin an thi rieia. ");
INSERT INTO sch_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Anûktaka nupangnu khom hah a thi zoia. ");
INSERT INTO sch_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Inthoinôk tikin te atu lômnu tak mo ai ni rang ani zoi? An urêngin laka lômnûn an nei chita,” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jisua'n “Atûnlai mingei an innei ngâi, ");
INSERT INTO sch_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Hannisenla, thina renga inthoinôk theiruo ngei le zora la hong ranga lêng theiruo ngei chu lômnu lômpa innei khâi noni ngei. ");
INSERT INTO sch_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Vântîrtonngei angin om an ta, thi thei khâi noni ngei. Thina renga an inthoinôk zoi sikin, Pathien nâingei nîng an ti zoi. ");
INSERT INTO sch_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moses khomin ânthârlakin athia ânthoinôk rang roi chu chîmbuk akânga han Pumapa chu ‘Abraham Pathien, Isaac Pathien, le Jacob Pathien’ tiin a rila. ");
INSERT INTO sch_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ama chu aring ngei Pathien ania, athi ngei Pathien nimak, ma taka han chu mi murdi an ring let sikin,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Balam minchupu senkhatin, “Minchupu, nu thuona adik” an tia. ");
INSERT INTO sch_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Masuole chu ite rekel ngam khâi mak ngei. ");
INSERT INTO sch_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jisua'n, Messiah hih inmo David Nâipasal ani thei rangtie? ");
INSERT INTO sch_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David lele han Lapuibua, “Pumapa han ku Pumapa kôm, Ka changtieng insung roh; ");
INSERT INTO sch_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Na râlngei ki sirphân Ka dar mâka chu” a tia. ");
INSERT INTO sch_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“David lele khomin ‘Pumapa’ a ti rêka, hante inmo Messiah hah David suonpâr ani thei rangtie,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Lokongei chong an rangâi lâiin, a ruoisingei kôma, ");
INSERT INTO sch_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Balam minchupungei renga singthei roi. Kâncholiinchuol inhaka lêng an nuom ngâia, bazar muna chubai inmûk, Synagog-a sukmun hoi, ruolhoi jôla sukmun asa ngên ngâi anni. ");
INSERT INTO sch_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Meithâingei sum an sâka, mi huongnân sôt tatak an chubai ngâi; ha ngei han an tuong rang na uol a tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisua'n a en titira, Biekina chôiruol dôngna, minei ngeiin an chôiruol thâk a mua. ");
INSERT INTO sch_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Meithâi inriengte'n sumdâr chînte inik a thâklâi khom a mu saa. ");
INSERT INTO sch_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","“Mi dadangngei nêkin hi meithâi inriengte hin a thâk mintam uol. ");
INSERT INTO sch_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Mi dangngei chu an nei minieng kêng an pêk, ania, ama'n chu ai dônsunte, kêng ai pêkrip,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ruoisi senkhat ngeiin Biekin lung ânvo enhoi tie le Pathien kôma an neinunpêk an misîr lâiin, Jisua'n an kôma, ");
INSERT INTO sch_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Nikhuo la hong tung a tih, nin mu ngei murdi amuna oma, lung inchuon reng om no nih,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Anni han a kôma, “Minchupu, mahah tika mo ai ni rang? Ahongtung rang zora rietna minsinna imo a om rang?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jisua'n, “Nangni an huong loina rangin singthei roi. Mi tamtakin Khrista ki ni, azora atung zoi kêng, keima riming pêlin hong an ta, ha mingei hah jûi no roi. ");
INSERT INTO sch_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Hanchu, indoi, insuol roi nin riet tikin chi no roi, mahah a tung masa ngêt rang ani, a zoinatak chu la tung kelen no nih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Nam dang le nam dang, ram dang le ram dang indoi an ta; ");
INSERT INTO sch_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Muntina ningnupui, mâitâm, ripui lêng a ta, invâna neinun kamâmruoi le ichiom ngei inlang a tih. ");
INSERT INTO sch_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Nikhomrese, ma ngei tungmân han nangni sûr an ta, an nuom nangni lông an ta, synagog taka nin roijêk rangin pêng an ta, lung ina nangni khum an tih. Keima sikin rêngngei, roijêkpungei makunga nangni tuong an tih. ");
INSERT INTO sch_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mahah nin ranga Thurchi Sa rilna zora sa nîng a tih. ");
INSERT INTO sch_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Lei riet roi, inmo ênpiel rang, inmo ei thuon rangtie tiin nin kângmindoi no roi. ");
INSERT INTO sch_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nin râlngeiin an sût theiloi rang dôrin chong theina le vârna nangni pêng ki tih. ");
INSERT INTO sch_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nin nû, nin pa, nin lâibung, nin sûngsuok, nin ruolngeiin nangni minsûr an ta, senkhat chu nangni that an tih. ");
INSERT INTO sch_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Keima sikin mitinin nangni mumâk an tih. ");
INSERT INTO sch_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ania, nin sam sangkhat te luo inmang no nih, ");
INSERT INTO sch_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Adetin inding ungla insaninjôk nin tih. ");
INSERT INTO sch_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Hanchu, râlmingeiin Jerusalem an huol nin mu tikin chu a siet rang ani zoi iti riet ta roi. ");
INSERT INTO sch_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Matikin chu Judea rama om ngei chu tânga rot rese ngei, asûnga om ngeiin chu suoksan rese ngei, rama om ngei chu khopuiliena lût no rese ngei. ");
INSERT INTO sch_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Lekhabua ânziek atung indikna rangin ha nikhuongei chu, ‘Phuba luok ni nîng a tih.’ ");
INSERT INTO sch_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nupang nâivongngei le nû nâi rununêk dônngei rangin chu nikhuo intak inthangtak nîng a tih, dûktongna inthang, hi rama hin a juong tung rang sik le Pathien taksina hi mingei chunga atung rang sikin. ");
INSERT INTO sch_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Senkhat khandaiin thîng an ta, Adangngei ram tina suokin tuongin om an tih. Hanchu an zora achuk mâka Jerusalem chu Jentailngei sirdênin om a tih.” ");
INSERT INTO sch_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Hanchu, nisa, thâ, ârsi ngeia khin minsinna om a ta, tuikhanglien rahang le tui insôn sikin pilchunga khom jâttin dengthei, lungjîng mintung a tih. ");
INSERT INTO sch_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Pilchung pumpuia ichi juong tung mindonin mingei jâmzalin inzal neng an ta, invân-lâijôla neinun bulpui ngei rujûlpai nîng a tih. ");
INSERT INTO sch_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Male Miriem Nâipasal inlang a ta, roineina le roiinpui takin sûm lâia juong a tih. ");
INSERT INTO sch_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Hanchu, ha ngei hah a juong tung phutin chu inding ungla, tang roi, nin jôkna rang anâi zoi sikin.” ");
INSERT INTO sch_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Hanchu, hi chongmintêk hih Jisua'n a rila, “Theichang kung le thingkung dadang ngei mindon roi. ");
INSERT INTO sch_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","A hong incher innoi nin mûn chu, kholum anâi iti nin riet ngâi. ");
INSERT INTO sch_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ha anghan, ha ngei hong tung nin mûn chu, Pathien Rêngram a juong tung rang ani zoi iti rieng nin tih. ");
INSERT INTO sch_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Atûnlâi mingei an thi riei mân ngêtin hi neinunngei hih juongtung a tih, iti riet roi. ");
INSERT INTO sch_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Pil le invân boi a ta, ko chong chu boi no nih.” ");
INSERT INTO sch_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Singthei roi, aninon chu, sâk akhoprai le ju inrûi le ringlâi nunkhohoi mindonnân nin mulung sip rai a ta, ha nikhuo hah juong tungrak a tih, ");
INSERT INTO sch_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","chânga inôk anghan. Ha anghan pilchung muntina mi murdi chunga tung a tih ");
INSERT INTO sch_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ha intakna juong tung rang adamriema nin pal theina rang, ranak nin dôn theina rang le Miriem Nâipasal makunga nin inding theina rangin indînin khotiklâi khomin chubai tho tit ngâi roi,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jisua'n ha sûnngei hah Biekina minchûn a minhek ngâia, kholoi a hong nin chu Olive muola a jân mang rangin a se ngâi. ");
INSERT INTO sch_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Anîngtin, jînga a chongril rangâi rangin a kôma Biekina mi murdi an hong ngâi. ");
INSERT INTO sch_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Hanchu, cholboi vâipôl ruolhoi, Kalkânkût ruolhoi an iti hah anâi zoia. ");
INSERT INTO sch_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ochaisingei le Balam minchupungeiin mipui an chi sikin inrûka Jisua that rang lam an roka. ");
INSERT INTO sch_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ruoisi sômleinik ngei lâia Judas Iscariot an iti ngâi sûnga Soitan a lûta. ");
INSERT INTO sch_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Hanchu Ochaisingei le Inkhomin ulienngei kôm a sea, Jisua an sûr theina rang lam a vân kerengpuia. ");
INSERT INTO sch_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Anni han an râisân oka, sum pêk rangin an inkhâma. ");
INSERT INTO sch_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Hanchu, Judas a nuoma, mipui riet loi kâra minsûr rang chuminrên a rok zoi. ");
INSERT INTO sch_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Hanchu, cholboivâipôl ruolhoi, Kalkân kût khalâiot, belrite that rang ni a hong tunga. ");
INSERT INTO sch_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jisua'n hi chong minchôiin Peter le John a tîra. “Se ungla eini sâk rang Kalkân kût va minsûk roi,” a tia ");
INSERT INTO sch_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Hanchu a kôma, “Khonmo kin minsûk rang?” an tia. ");
INSERT INTO sch_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","An kôma, “khopuilien nin lût lehan, mi inkhat bêla tui chôi tong nin ta, a lûtna ina jûipat roi. ");
INSERT INTO sch_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Hanchu, in pumapa kôma, ‘Minchupu'n ku ruoisingei leh Kalkân kût kin sâkna rang khâltan khonmo a ti?’ ti roi. ");
INSERT INTO sch_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Hanchu, chunginchuon khâltan inzar tak, neinun nâm omsai, nangni min mûng a ta, mahan minsûk roi,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Hanchu an sea, Pumapa'n an kôma a ti lam angin jâtinrêng an mua, mahan kalkân kût an mintuo zoi ani. ");
INSERT INTO sch_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Hanchu, asâk zora ahong nîn chu a tîrton sômleinik ngei leh khalâi a ota. ");
INSERT INTO sch_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","An kôma, “Ku tuong mân, hi Kalkân kût hih nangni sâkpui rang ku nuom sabak ani. ");
INSERT INTO sch_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nangni ki ril, Pathien Rêngrama a tatakin ani mâka chu sâk khâi no ning,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Male, kilât a lâka, Pathien kôma râisânchong a ril zoiin chu an kôma, “Hihi lâk ungla buong roi. ");
INSERT INTO sch_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nangni ki ril, Pathien Rêngram a juong tung mâka chu hi uain hih buong khâi no ning,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Male, vâipôl a lâka, Pathien kôma râisânchong a ril zoiin chu a khoia, a pêk ngeia an kôma, “Hihi ka taksa, ninta ranga ipêk ani. Mi nin riettitna rangin tho ngâi roi” a tia. ");
INSERT INTO sch_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ha angin, an sâk zoiin chu, kilât a lâka, “Hi kilât hih Pathien chongtung thar ki thisena sînthona, ninta ranga bun suok ani,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Hannisenla, en ta u, ni minsûr rangpu chu ka khalâi otpuipu hih ani. ");
INSERT INTO sch_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Pathien mintuo anghan, Miriem Nâipasal chu thîng a tih, ania, a minsûrpu chung chu ântak bah na! ");
INSERT INTO sch_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Hanchu an lâia tutakin mo, ma anga tho rang ai ni rang ani zoi? tiin an inrekel inlôma. ");
INSERT INTO sch_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Hanchu, ruoisingei lâia a tutak mo alientaka be rang tiin inkhalna a oma. ");
INSERT INTO sch_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jisua'n an kôma, “Jentail rêngngei chu an mingei chunga racham an neia, racham a nei ngei chu ‘mipui ngei mal’ an ti ngâia. ");
INSERT INTO sch_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ania, nangni chu ha anghan nino tunui, nin lâia alientak chu nâipang uolin om senla, ruoipu rang chu tîrlâm angin om rese. ");
INSERT INTO sch_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Tumo alien uol, bu nêk ranga insungpu mo, bukhalâi dôpu mo? Bu nêkpu nîng a tih. Ania, kei chu nin lâia tîrlâm angin ko oma.” ");
INSERT INTO sch_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Huong ranga methêmna ko tong kâra ni ompui ngei nin ni. ");
INSERT INTO sch_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ka Pa'n racham ni pêk anghan, racham nangni pêk ki tih. ");
INSERT INTO sch_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ke Rêngrama ko dosânga sâk nan ta, nêk nan ta, Rêngsukmuna insungin Isreal jât sômleinik ngei chunga roijêk nin tih.” ");
INSERT INTO sch_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simon, Simon, rangâi ta! Butak le arishi an jâp ngâi anga nangni minsîna asa le sie nangni kidik rangin Soitanin phalna a man zoi. ");
INSERT INTO sch_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Hannisenla, na taksônna ânsam loina rangin nangni ku chubai pe, ki tieng ni kîr tikin na lâibungngei ni mindet rang ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Peter'n a thuona, “Pumapa, no kôma intâng ina intâng rang le athi rang khomin kên phal,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jisua'n, “Peter, nang ki ril, avienjân hin, voithum riet ngâi mu-ung ni ti mâka chu âr khuong no nih,” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Hanchu, Jisua'n an kôma, “Sumkok, choli, kekok, boia nangni ki tîr lâia han imo nin insama?” tiin a rekela, “Ite insam mak me” an tia. ");
INSERT INTO sch_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jisua'n atûn chu, sumkok, choli, anei khomin chôi ta roi, khandai nei loi khomin a kâncholi zuor senla rochôk rese. ");
INSERT INTO sch_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nangni ki ril, Lekhabu'n, “Ama chu mi nunsiengei lâia telsa ani zoi” itia ku chung roi miziek hah, ku chunga ai tung indik rang ani. ");
INSERT INTO sch_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ruoisingeiin a kôma, “Pumapa, en ta, hin khandai inik a om” an tia. Ahun a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Hanchu, a tho ngâi lam angin, khopuilien a mâka, Olive muola a sea, ruoisingei khomin an jûia. ");
INSERT INTO sch_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Amun an tungin chu an kôma, “Huongna nin lût loina rangin chubai roi” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Hanchu, an kôm renga lunga dêngphâkna tena a vân thîna, khûkinbilin chubai a thoa. ");
INSERT INTO sch_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“O Pa, nu nuomin chu hi dengtheina kilât hih ko kôm renga khâi roh. Nikhomrese, keima racham ni loiin, na racham tak ni rese” a tia. ");
INSERT INTO sch_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Hanchu, vântîrton invân renga a kôma a juong inlâra, râtna a juong pêka. ");
INSERT INTO sch_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ngâisiet inrikin, ningsiet uolin a chubaia, a rathan khom thisen angin pila a masara. ");
INSERT INTO sch_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Hanchu, chubai thona renga inthoiin ruoisingei kôma a sea, sabeidonga a inin a va mu ngeia. ");
INSERT INTO sch_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","An kôma, “Ithomo nin in? Inthoi ungla, huongna nin tâk loina rangin chubai roi,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisua a la chong lâiin ruoisi sômleinik ngei lâia Judas hong tuong mipui an hong tunga, Jisua tum rangin a kôma a honga. ");
INSERT INTO sch_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jisua'n a kôma, “Judas, Miriem Nâipasal hi atumin minsûr rang ni ti mo?” a tia. ");
INSERT INTO sch_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Hanchu, a kôma ruoisi om ngei han, neinun omtie an mûn chu a kôma, “Pumapa, kin khandai mang ni ung mo?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Hanchu an lâia inkhatin Ochai Inlaltak tîrlâm a chang tienga kuor a leng pea. ");
INSERT INTO sch_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ania, Jisua'n “Ahun zoi” a tia. Ha mi kuor hah a tôna a mindam pe zoi. ");
INSERT INTO sch_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Hanchu, a kôma hong Ochaisingei, Biekin ulienngei, upangei, a sûr ranga hong ngei kôma Jisua'n, “Khandaingei, tôkmolngei ichôiin, puoloi sûr rang leh in-ang bangin nin hong na? ");
INSERT INTO sch_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nîngtin Biekina nin kôm ko oma, ni sûr rang ti mak cheia. Ania, ijîng rachamneinân roi ajêk lâi hih nin sin tho zora ani,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Hanchu, Jisua an sûra, Ochai Inlaltak ina an tuonga, Peter'n alazanin a jûia. ");
INSERT INTO sch_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","In khalâidung alâitak han mei an thoa, mei rihila insungruma mei uot ngei lâia han Peter khom a vân sunga. ");
INSERT INTO sch_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nupang tîrlâm inkhatin mei kunga ânsung a mua, a mitjuoka, “Hi mi khom hih Jisua kôma om ngâi mi ani,” a tia ");
INSERT INTO sch_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Peter'n, “Nupang, ama hah riet luo riet ngâi mu-ung” tiin a minlêma. ");
INSERT INTO sch_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Anangkan uola chu mi inkhatin Peter kôma, “Nang khom an lâia mi ni ni” a tia. Peter'n, “Miriem, kei chu ni mu-ung” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Hanchu dârkârkhat suole chu midangin, “Ite okchâna boi riekin hi mi khom hih Jisua kôma om ngâi ani, Galilee mi ani sikin” ati ngita. ");
INSERT INTO sch_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ania Peter'n, “Miriempa, ni ti ngei hah riet mu-ung” tiin a thuona. Harenghan a la chong lâi takin âr akhuong zoia. ");
INSERT INTO sch_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Hanchu Pumapa hah ânheia, Peter a en ngita. Hanchu, Peter'n Pumapa'n a kôma, “Avien jân âr akhuong mân voithum ni ipdel ni tih,” ai tipe hah a rietsuoka. ");
INSERT INTO sch_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Hanchu, Peter a jôkpaia, a chap ngungui zoi. ");
INSERT INTO sch_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Hanchu, a sûrngei han Jisua tusiem thonân an manga, an jêma. ");
INSERT INTO sch_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","A mâi an hîp pea, “Ti roh, tumo nang a jêm?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","A chunga demna chong tamtak an thoa. ");
INSERT INTO sch_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Hanchu, khuo avâr lehan, upangei, Ochaisingei, Balam minchupungei an intûpa, an roijêkna Jisua an hong tuonga, ");
INSERT INTO sch_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","a kôma, “Ni ril roh, Messiah nini mo?” an tia. Jisua'n, “Nangni ril khom inlang iem no tunui,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","“Chong nangni rekel khom inlang ni thuon no tunui. ");
INSERT INTO sch_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ania, atûn renga Miriem Nâipasal hih Râtinchung Pathien chang tieng insung a tih zoi” a tia. ");
INSERT INTO sch_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","An rêngin, “Nônte Pathien Nâipasal mo na ni,” an tia. An kôma, “Ani mi nin ti zoi hate” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Hanchu, “Ite rietpuipu dang nâng khâi mak me, eini rengin a ti ei riet zoi,” an tia. ");
INSERT INTO sch_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Hanchu, ântûpngei murdi an inthoia, Pilat makunga Jisua an tuonga. ");
INSERT INTO sch_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","“Hi mi hin, kin mingei anôk tieng a ruoia, Caesar kôma khom chôiruol chôi no roi,” a tipea. “Mapêna, ama reng Messiah rêng ki ni ântia, kin sûr ani,” tiin an nôna. ");
INSERT INTO sch_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilat'n, “Judangei rêng mo nani?” tiin a rekela. Hanchu, “Ani, mi ni ti zoi hate” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Hanchu, Pilat'n, Ochaisingei le mipui ngei kôma, “Hi mi hih theiloi mintumna rang abi reng mu mu-ung” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Hannisenla, anni han, “Galilee ram renga phutin hi mun dên rakin Judea ram pumpuia, a minchua, a minjêla,” tiin an nôn uol uola. ");
INSERT INTO sch_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Hanchu, Pilat'n ha chong hah a riet lehan, “Galilee mi mo ni ni” tiin a rekela. ");
INSERT INTO sch_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Galilee rama mi ani iti a rietin chu, Herod kôma a tîra; Herod khom Jerusalema a om lâitak ani. ");
INSERT INTO sch_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jisua a mûn chu a râisân oka, a thurchi a lei rieta, amu rang a nuomna a lei sôt zoi sikin. Jisua sininkhêl mu rang khom a sabei sa ani. ");
INSERT INTO sch_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Masikin, Herod'n chong rekelna tamtak a neia, ania, Jisua'n thuon maka. ");
INSERT INTO sch_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ochai Inlalngei le Balam minchupungei mântieng an hôn thîna, Jisua an nôn uol uola. ");
INSERT INTO sch_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herod le a râlmingeiin Jisua an phenênga, esêl takin tusiem thonân an manga; male kancholi inchuol an minhaka, Pilat kôm an tîr nôk zoi. ");
INSERT INTO sch_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Hâni lelea han Herod le Pilat hah mal an inchanga, ma mâna han chu râla lei om an ni. ");
INSERT INTO sch_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Hanchu, Pilat'n Ochaisingei, ruoipungei, mipui ngei a koitûpa. ");
INSERT INTO sch_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","An kôma, “Hi mi hin mipui ngei aletieng a ruoisiet, tiin ko kôm nin hong tuonga, ania, hin nin makung renga ke ena, nin nôn lam angin ite theiloina man mu-ung. ");
INSERT INTO sch_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herod khomin a theiloina man maka, masikin ei kôma a hongtîr nôk ani. Athina rang dôrin hi mi hin ite tho minchâina nei mak. ");
INSERT INTO sch_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Masikin jêm ka ta mojôk ki tih” a tia. ");
INSERT INTO sch_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(Kalkân kût rachamin Pilat'n mi intâng inkhat an rangin a mojôk pe ngâi ani) ");
INSERT INTO sch_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Mipui ngeiin an hêta, “That roh, kin rangin Barabbas mi mojôk pe roh” an tia. ");
INSERT INTO sch_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabbas chu khopuia injêlna le mithat sika jêlina intâng ani. ");
INSERT INTO sch_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilat'n chu Jisua mojôk rang a nuom sikin, mipui ngei kôma atharin a ti nôka. ");
INSERT INTO sch_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Hannisenla, an hêtkhuma, “Khrosa jêmdel roh, Khrosa jêmdel roh” an tia. ");
INSERT INTO sch_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilat'n, avoithumnân, an kôma, “Imo a tho minchâina? Athina rangin a minchâina mu mu-ung! jêm ka ta, mojôk ki tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Hannisenla, rôl inring theidôrin, Jisua chu khrosa jêmdel rangin an ti ngita. Hanchu an iniekin a mene zoia. ");
INSERT INTO sch_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","An ngên lam angin Pilat'n aroi a masata; ");
INSERT INTO sch_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","an nuom lam angin, injêlna sika mithata intângpu a mojôk pea, Jisua chu an ning an nuoma an lo rangin an kôma a pêk ngei zoi. ");
INSERT INTO sch_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Hanchu, râlmingeiin Jisua an tuonga, an se lâiin a riming Simon Cyrene mi khosûng renga khopuilien hong pan an tonga. An sûra, khros an min ruputa, Jisua nûka an min lôna. ");
INSERT INTO sch_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Mipui tamtakin an jûia, an lâia nupang senkhat ngei chu an châa, an chapa. ");
INSERT INTO sch_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jisua'n an tieng ânheia, “Jerusalem nupangngei o, micha no roi, nangni le nin nâingei rangin chap roi. ");
INSERT INTO sch_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Nikhuo a hong tung tir zoi, mingeiin, ‘nupang a chingngei, nâi vong ngâi loi ngei, nâi neiloingei chu an ralvân asa pe bah na!’ la tîng an tih. ");
INSERT INTO sch_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ha tikin chu mingeiin muolngei kôma, ‘Ni del roh,’ la tîng an tih. Muolngei kôma, ‘Ni thup roh’ la tîng an tih. ");
INSERT INTO sch_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Thing aringa luo hi ang takin a thôn te, achâr vanga te i ang takin mo tho ta nih,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Hanchu, midang inik, mipuoloi, ama leh that sa rangin an tuonga. ");
INSERT INTO sch_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Hanchu, “Luru mun” an ti mun an tungin chu mahan Jisua khrosa an jêmdela, mipuoloi inik a voitieng inkhat a chang tieng inkhat. ");
INSERT INTO sch_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jisua'n, “O Pa, ngâidam ngei roh, imo an tho an riet loi kêng,” a tia. Hanchu taruo sânin a puon an insema. ");
INSERT INTO sch_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Hanchu mipui indingin an thîra, Juda ruoipungeiin, “Mi dangngei chu a mojôk ngâia, Pathien ithang, ani tatakin chu, a thenin jôk rese” tiin an êroa. ");
INSERT INTO sch_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Râlmingei khomin an khorâia; a kôma an honga ju thûr an pêka. ");
INSERT INTO sch_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","A chunga, “Judangei rêng na nîn chu ne theiin jôk roh bah!” an tia. ");
INSERT INTO sch_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","A chunga, “Hi mi hih Judangei Rêng ani” iti miziek a oma. ");
INSERT INTO sch_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mipuoloi inkhat an makhâi han êro chongin a kôma, “Messiah nimak che mo? jôk inla, keini khom mi mojôk sa roh” a tia. ");
INSERT INTO sch_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Inkhatpa han a ngoa a kôma, “Pathien ni chi loi mo? Ama leh in-ang banga dûk min mintong hih. ");
INSERT INTO sch_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Eini chu ei sintho man ei man rangtum piel ei man ani, aniatachu, ama chu ite tho minchâina nei mak,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Hanchu, Jisua kôma, “Jisua Rêngin nu juong tikin ni riettit roh,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Hanchu, Jisua'n a kôma, “Chong kên khâm, avien ko kôma Paridise'a om ni tih,” a tipea. ");
INSERT INTO sch_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Hanchu, sûnlâi dâr sômleinik renga kholoi dârthum dênin, nisa avâr ân ngama, ram pumpui a jîngkhap zoi. ");
INSERT INTO sch_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Hanchu, Biekina puonjâr hah inikin a kêrphata. ");
INSERT INTO sch_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jisua'n rôl inring takin ânieka, “O Pa, na kuta ka ratha ka bâng,” a tia. Mahah a ti zoiin chu a rang achat zoi. ");
INSERT INTO sch_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Hanchu, râlmi ulienpu han neinun omtie a mûn chu, “Inkhel loiin midik ani khet” tiin Pathien a minpâk zoia. ");
INSERT INTO sch_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ha enhoi ithîra mipui intûpngei han neinun omtie an mûn chu, ngâisieta rôp ruchumin an in tieng an kîr nôk zoi. ");
INSERT INTO sch_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jisua mêlrietngei le nupangngei murdi Galilee ram renga ama hong jûingeiin lâtaka indingin an thîra. ");
INSERT INTO sch_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Hanchu Judea ram, Arimathea khuo mi a riming Joseph a oma. Ama hah midik, mi mirit om, Pathien Rêngram juong tung rang lei ngâk mi ania. Roijêkpungei lâia mi inkhat nikhomrese an roi masat lam le an sintho lam nuom loi mi ani. ");
INSERT INTO sch_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Pilat kôma a sea Jisua ruok a zonga. ");
INSERT INTO sch_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Hanchu ruok hah a musuma, rosom puonin a thoma, thân, lungkuo ihel tute la minjâlna ngâi loia a min jâla. ");
INSERT INTO sch_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Hanchu, sûn rangnga ni ania, Sabath ni phut rang ani zoia. ");
INSERT INTO sch_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galilee ram renga nupang Jisua hong jûi ngei hah Joseph ngei leh an sea, thân le Jisua ruok an dar tie khom an mua. ");
INSERT INTO sch_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Hanchu ina an sea, mirimhoi le sariekngei ruok pol rangin an sinsiema. Balam angin Sabathnin chu an ingam zoi. ");
INSERT INTO sch_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Pathienni jîng, inmâna, nupangngeiin mirimhoi an sin hah chôiin thâna an sea. ");
INSERT INTO sch_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Thân kotbâia lung hah inluoipai sân an va mua. ");
INSERT INTO sch_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Hanchu, an lûta, ania, Pumapa Jisua ruok chu mu khâi mak ngei. ");
INSERT INTO sch_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Mahan mulungjîngin an indinga, harenghan, mi inik puon chek insilin an kôla an juong indinga. ");
INSERT INTO sch_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nupangngei han rolo innîkin nuoia an inbok raka, anni han an kôma, “Ithomo mi ring hah mithingei lâia nin irok? ");
INSERT INTO sch_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Hin om khâi maka, ânthoinôk zoi. Galilee rama a om lâia nin kôma ai ti ngei hah riettit roi. ");
INSERT INTO sch_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Miriem Nâipasal hih mi nunsie ngei kuta ipêk nîng a ta, jêmdel an ta, a sûnthum nîn a ringin inthoi nôk a tih” an tia. ");
INSERT INTO sch_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Hanchu, nupangngei han ai ti ngei hah an rietsuok nôka, ");
INSERT INTO sch_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","thân renga an kîra, neinun omtie ngei chu ruoisi sômleikhat ngei le midangngei an rila. ");
INSERT INTO sch_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nupangngei hah Mary Magdalene, Joanna, le Mary, Jacob nungei anni. Anni le nupang adang an kôma omngei han tîrtonngei hah an ril ani. ");
INSERT INTO sch_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ania nupangngei chongril hah, chongkâmboi an tia, taksôn mak ngei. ");
INSERT INTO sch_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Nikhomrese, Peter chu ân thoilita, thân tieng a tâna, ân kûna, rosom puon injuot tiloi chu ite dang mu maka. Hanchu, neinun omtie ngei kamâmin in tieng a kîr nôk zoi. ");
INSERT INTO sch_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ma ni nanâk han Jisua jûi ngâi mi inik Emmau khuoa an sea, Jerusalem renga kilometer sômleikhat dôra la ani. ");
INSERT INTO sch_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","An ruonin neinun omtie ngei hah an misîra. ");
INSERT INTO sch_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ha anga an chonga an misîr lâiin, Jisua lelên a hong nâia an kôma a lôna. ");
INSERT INTO sch_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","An mua chu riet minthâr mak ngei. ");
INSERT INTO sch_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ama'n an kôma, “Lampuia nin misîr hah ithurchi mini?” a tia. Hanchu mâi inngûi riemin an indinga. ");
INSERT INTO sch_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Hanchu, a riming Cleopas han a kôma, “Jerusalema sûnkhat vai mo no om? Sûntômte lei vuna neinun omtie ngei hah ni riet loi mo?” tiin a rekela. ");
INSERT INTO sch_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“I neinun mo?” a tia. “Nazareth Jisua chunga neinun tungngei hah; ha mi hah Pathien le mitin mindon khoma jâttinrêng ai ti le ai sin, racham inei dêipu ania, ");
INSERT INTO sch_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","kin Ochaisingei le ruoipungeiin that rangin an pêka, an jêmdela. ");
INSERT INTO sch_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ama hah Isreal minjôk rang mi nîng a tih iti kin tûnga. Mapêna, ha anga neinun tungna hah avien hin a sûnthumni ani zoi. ");
INSERT INTO sch_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kin champui nupang senkhat, jînga thân va en ngeiin kin mulung an minjînga. ");
INSERT INTO sch_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","A ruok mu loiin an hongkîr nôka, vântîrton inlâr kin mua, a ring nôk zoi an ti, an hong tia. ");
INSERT INTO sch_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Hanchu, kin champui senkhat ngeiin thâna an va sea, nupangngei ti lam anghan an va mua, ama chu mu khâi mak ngei” an tia. ");
INSERT INTO sch_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Male, Jisua'n an kôma, “Amo ngei o, dêipungei neinuntin an lei rilngei hah idôra a iem innu mo nin ni? ");
INSERT INTO sch_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Messiah han ha ngei murdi tuongin a roiinpuina ai lût rang nimak mo?” a tia ");
INSERT INTO sch_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Hanchu, Jisua'n ama chungroi, Moses lekhabu renga dêipungei lei miziek lekhabungei a rilminthâr pe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Hanchu, an sêna rang khuo an hong nâi zoia, Jisua hah la se bang rang angin a oma, ");
INSERT INTO sch_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nikhomrese bâiin an sûra, “Kin kôma om ta roh, sûn aheka ajîng rang kêng ani zoi” an tia. Hanchu an kôma om rangin a se zoi. ");
INSERT INTO sch_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Hanchu, an kôma sâk rangin ânsung lâiin vâipôl a lâka, sat a vura, a khoia, a pêk ngeia. ");
INSERT INTO sch_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Hanchu an mit a hong vâra, an rietminthâr zoia, hannirese, an mitmu renga ânmang nôk kelena. ");
INSERT INTO sch_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","“Lampuia ei kôma, Mi chongpuia, lekhabungei mi rilminthâr pe lâia han mei a kâng angin om mak me mo?” tiin an inrekela. ");
INSERT INTO sch_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Harenghan, an inthoia, Jerusalema an kîr nôka, ruoisi sômleikhat ngei le Adangngei lei intûp an va mua. ");
INSERT INTO sch_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","“Pumapa chu ânthoinôk tatak; Simon kôma khom ânlâr zoi” an lei tia. ");
INSERT INTO sch_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Hanchu, ha inik ngei khom han, lampuia neinun omtie le vâipôl a khoia Pumapa an rietminthâr tie an rilminthâr ngei zoi. ");
INSERT INTO sch_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Hanchu, mi inik ngei han an la ril lâitakin, harenghan Pumapa lele an lâia ândinga an kôma, “Nin chunga ratha'ngamna om rese” a tia. ");
INSERT INTO sch_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","An jâminzal sabaka, khori an mûn an mindona. ");
INSERT INTO sch_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Hanniresea, an kôma, “Ithomo nin mulung nin minjînga? Ithomo nin mulunga iem zoiloina nin inei? ");
INSERT INTO sch_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ka kut, ke kephangei en ta u, keima nanâk hah ki ni hih! Ni tôn ungla, en roi, minin mu anghan khori'n taksa le ru nei mak” a tia. ");
INSERT INTO sch_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Hanchu, mahah a ti zoiin chu, a kut le a kephangei a min en ngeia. ");
INSERT INTO sch_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","An râisân rai sikin taksôn thei kelen mak ngeia, an kamâm sabak lâiin an kôma, “Asâk ruo imokhat mo nan nei?” tiin a rekel ngeia. ");
INSERT INTO sch_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Nga suong sai tangkhat an pêka. ");
INSERT INTO sch_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Alâka, an mu chungin a sâka. ");
INSERT INTO sch_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Hanchu, an kôma, “Hi chongngei lele hih ani, nin kôma ko om lâia ku chungroi Moses Balam lekhabua miziek, Dêipungei miziek, Minpâkna labua miziek, a hongtung dik rang nangni ke lei ril ngâi hah,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Hanchu, lekhabua ânziekngei an riet theina rangin an mulungrîlngei a mo-ong pe ngeia. ");
INSERT INTO sch_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","An kôma, “hi angin miziek ani, Messiah han dûk tuong a ta, sûnthum suole thina renga inthoi nôk a tih. ");
INSERT INTO sch_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ama rimingin insîrna le nunsie ngâidamna thurchi Jerusalem renga namtin kôma misîr nîng a tih. ");
INSERT INTO sch_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ha neinunngei murdi rietpuipu nin ni. ");
INSERT INTO sch_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Hanchu, ka Pa ânkhâm hah keima rengin nin chunga juongtîr ki tih, hannirese, chungtieng renga sinthotheina nin chunga a chum mâka chu khopuilien ha nin ngâk tit rang ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Hanchu, khopuilien renga Bethany dênin a ruoi ngeia, mahan a bân a phara, sat a vur ngeia. ");
INSERT INTO sch_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ha anga sat a vur lâitakin, ânsenpui ngeia, ama chu invâna tuongin a om zoi. ");
INSERT INTO sch_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Hanchu chubai an mûka, râisân takin Jerusalema an kîrnôk zoi. ");
INSERT INTO sch_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Hanchu, Biekina Pathien kôma râisânchong rilin an zorangei murdi an mang zoi.");
INSERT INTO sch_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Aphutna taka han chong alei oma; ma chong ha Pathien kôm aoma, Chong ha ke Pathien ani. ");
INSERT INTO sch_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Aphutna tak renga han chong hah Pathien kôm ke aom ani. ");
INSERT INTO sch_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Neinunngei murdi Pathien sin riempet an nia, ama sin loi neinun inkhat luo omak. ");
INSERT INTO sch_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ma Chong ha ke ringna bulpui ani, male ma ringna hah munisi ngei minvârpu ani. ");
INSERT INTO sch_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ma vâr han ijîng a êlminvâra, ijîng han lei khap thei mak. ");
INSERT INTO sch_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Pathien'n a thangtheipu inkhat a juong tîra, a riming chu John ani, ");
INSERT INTO sch_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ha mi han vâr thurchi mingei min riet ranga juong ani, ama sikin mitinin an iem theina rangin. ");
INSERT INTO sch_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ama hah vâr chu nimaka; vâr thurchi mingei min riet ranga juong ani. ");
INSERT INTO sch_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mahi vâr diktak chu ani; rammuola a juonga mingei murdi minvârpu hi. ");
INSERT INTO sch_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Chong hah rammuola aoma, male Pathien'n Chong mangin rammuol ha sin khomsenla, rammuolin lei riet thei maka. ");
INSERT INTO sch_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","A mingei nanâk kôm a juonga, aniatachu a mingeiin lei modôm mak ngei. ");
INSERT INTO sch_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Hankhoma ama modôm ngei kai le ama iem ngei chu Pathien nâi nina a pêk ngei zoi. ");
INSERT INTO sch_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ha mingei hah chu thisena inzir nimak ngeia, taksa nuomlama ânzir khom nimak ngeia, munisi ngei pa nuomlama ânzir khom ni uol mak ngei; Pathien ha kêng an Pa ani. ");
INSERT INTO sch_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Hanchu, Chong hah munisi juong changin, moroina le chongtaka sipin ei lâia a juong om zoi. A roiinpuina ei mua, Pathien Nâikhât roiinpuina a man hah. ");
INSERT INTO sch_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","John'n a chungroi a misîra, ân ieka, Hi mi thurchi hih ki misîr ani, “Ku nûka juong rangpu hi keima nêka lien uol ani, kên zir mâna a lei om sai ani sikin,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","A lungkham satvurna akipin ei rêngin ei changa, moroina chunga moroi nôkna. ");
INSERT INTO sch_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Pathien'n Balam chongpêk Moses a pêka, aniatachu moroina le chongtak chu Jisua Khrista sikin ahong om ani. ");
INSERT INTO sch_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tutên Pathien la mu mak ngeia. A Nâikhât vai, Pathien ân angpui le Pa tienga om ngêt han, a thurchi a min riet zoi. ");
INSERT INTO sch_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalema Juda rachamneipungei han, “John, hah tumo ani?” ti rekel rangin ochaingei le Levi richisuonpârngei an tîra. ");
INSERT INTO sch_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","John'n ânthârtakin, “Messiah chu ni mu-ung” a lei tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“Nônte, Tumo ni ni? Elijah mo ni ni?” tiin an rekela. “Ni mu-ung,” tiin a thuon ngeia. “Dêipu mo ni ni?” tiin an rekela. “Ni mu-ung,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","“Nônte tumo ni ni? mi hongtîr ngei chong kin mele theina rangin mi ril roh. Nu thurchi hi i angin mo ni ti?” an tia. ");
INSERT INTO sch_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","John'n dêipu Isaiah chong mangin a thuona: “Keima hi ramchâra mi inkhat tânghâipu ha ki ni: Pumapa lônna rang lampui mintûn roi!” ");
INSERT INTO sch_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ma thangtheipungei, Phariseengei hongtîr ngei han John an rekel nôka, ");
INSERT INTO sch_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","hanchu “Messiah ni ni noa, Elijah mo, Dêipu mo luo ni ni nônte ithomo mi na baptis ngâia?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","John'n a thuona, “Keiman chu tui leh ka baptis'a, hannirese nin lâia hin nin riet loi mi inkhat ânding chiena. ");
INSERT INTO sch_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ama hah ku nûka a juong rang ania, kei chu a kekokrûi sût rang luon inhoi mu-ung,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Mangei hah Bethany khuo nisuo tieng Jordan tuidung râla, John'n a baptisna ngâi muna atung ani. ");
INSERT INTO sch_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Anangtûka chu John'n Jisua a kôm hongin a mua male, “En ta u, Pathien Belrite rammuol sietna pêl rangpu soh,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Hi mi chungroi hih ani, “Mi ku nûka a juong a oma, aniatachu keima nêka lien uol ani, keima kên zir mâna a omsai ani sikin, ki ti hah. ");
INSERT INTO sch_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Tumo ani rang riet mu-ung, nikhomsenla, Israel mingei min riet rangin tuia baptis rangin ku juong ani.” ");
INSERT INTO sch_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Male John'n hi thurchi hih a misîra: “Ratha hah invân renga juong chumin vasu angin a chunga a juong chum ku mu. ");
INSERT INTO sch_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Atûntena keiman chu la riet thei mu-ung, nikhomrese tuia mi baptis ranga mi tîrpu Pathien'n, Ratha hah invân renga juong chumin mi inkhat chunga chuongin mini mûng na ta; ama hih Ratha Inthienga leh mi baptis rangpu ha ani.” ");
INSERT INTO sch_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","John'n, “Ama hah ku mu zoi, Nangni ki ril, ama hah Pathien Nâipasal ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Anangtûka chu mahan John ha a ruoisi inik ngei lehan ânding nôka, ");
INSERT INTO sch_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jisua lôn lâitak a mu lehan. “En ta u, Pathien Belrite soh!” a tia. ");
INSERT INTO sch_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ma ruoisi inik ngei han a thurchi misîr an rieta Jisua leh an se kelena. ");
INSERT INTO sch_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jisua ân heia, an hongjûi a mûn chu an kôm, “Khoimo nin rok?” a tipe ngeia. Anni han, “Rabbi, khonmo no om ngâi,” tiin an thuona. (Rabbi ti chu “Minchupu” tina ani). ");
INSERT INTO sch_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ama han, “Hong ungla en roi,” tiin a thuona. (ma zora ha chonûktieng dâr minli inring dôr ani.) Masuole chu an jûia a omna an mua, male mani sûna zora kai chu ama leh an mang minhek zoi. ");
INSERT INTO sch_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","An lâia inkhat ha chu Andrew, Simon Peter lâibungpa ani. ");
INSERT INTO sch_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ama han a upa Simon a mu kelena a kôm, “Messiah hah kin mu zoi,” a tia. (hi chongbâi aomtie chu “Khrista” tina ani.) ");
INSERT INTO sch_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Hanchu ama'n Simon hah Jisua kôm a tuonga. Jisua'n Simon hah a lei ena, “Ni riming chu Simon, John nâipasal ni ni, hannirese Kephas, tiin nang koi an ti zoi,” a tia. (Ma hih Peter tina leh munkhat ania, aomtie chu “lungpui” tina ani.) ");
INSERT INTO sch_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Anangtûka chu Jisua Galileea se rangin a masata, Philip a mua, “Ni jûi roh a tipea!” ");
INSERT INTO sch_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Philip ha Andrew le Peter omna khopui Bethsaida mi ani.) ");
INSERT INTO sch_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Philip han Nathanael a mua a kôm, “A thurchi Moses'n Balam lekhabua a lei miziek le dêipungei khomin an miziek Joseph nâipasal Nazareth Jisua hah kin mu zoi,” tiin a rila. ");
INSERT INTO sch_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nathanael'n a kôm, “Nazareth taka neinun sa asuok thei mini?” tiin a rekela. Philip'n a kôm, “Hongin la, en roh,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jisua'n Nathanael a kôma hong a mua, a chungroi a misîra, “Ama hi Israel mi diktak; dikloina reng dôn loi ani!” a tia. ");
INSERT INTO sch_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathanael'n, “Kho angin mo mi ni riet?” tiin a rekela. Jisua'n a kôm, “Philip'n nang a koi mân theichang kung nuoia no om lâihan nang ku mu zoi,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathanael'n a kôm, “Minchupu,” “Pathien Nâipasal ni ni! Israelngei Rêngpa ni ni!” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jisua'n a tia, “Theichang kung nuoia no om lâia nang ku mu kêng ani zoi nang ki ti sikin ni iem mini? Hi nêka neinun roiinpui uol ok la mûng ni tih!” a tipea. ");
INSERT INTO sch_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Male Jisua'n an kôm, “Chongtak nangni ki ril: invân ajuon onga, Miriem Nâipasal chunga vântîrtonngei an juong chum le an kal, la mûng nin tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Sûnnik suole chu Galilee ram sûnga Cana khopuia inneina aoma. Jisua nû khom mahan a oma, ");
INSERT INTO sch_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jisua le a ruoisingei khom inneina han an siel ngei sa. ");
INSERT INTO sch_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Uain an hun khâiloi lehan, Jisua nû han a kôm, “Uain an insam zoi kêng hi,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","“Khoimo ko tho rang mi ni ril rang nâng mak,” Jisua'n, “Ko zora la tung mak.” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jisua nû han tîrlâmngei kôm han, “Nangni a bê murdi tho roi,” tiin a ril ngeia. ");
INSERT INTO sch_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Judangei rusûk minsâi balam an dôn anghan lung tuibêl uruk mahan aoma, an sika liter razakhat keng theina chit an ni. ");
INSERT INTO sch_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jisua'n tîrlâmngei kôm, “Tuibêlngei han tui min sip roi,” a tia, anni ngei han an min sipmata, ");
INSERT INTO sch_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","male an kôm, “Atûn chu thâl ungla, moiruoipu kôm se pui roi,” tiin a ril ngeia. Ama kôm han tui ha an chôia, ");
INSERT INTO sch_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","maha uain ahong chang zoia, moiruoipu khom han a tem vika. Uain ha kho renga hong mini riet mak (aniatachu, tui thâla an mang, tîrlâmngeiin chu an rieta); masikin mâkpa hah a koia, ");
INSERT INTO sch_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","male a kôm, “Mitinin uain sa an sem baka, nûk tieng khuolmingeiin an buong suo nûkin chu uain sa bâkloi an sem ngâia. Aniatachu, nangman chu atûn tena uain sa na la sem banga!” a tipea. ");
INSERT INTO sch_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Hi sininkhêl hih Jisua'n Galilee rama Cana khopuia motontaka a sin ani; mahan a roiinpui tie ân phuonga a ruoisingeiin ama an iem zoia. ");
INSERT INTO sch_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Masuole chu, Jisua le a nû, a lâibungngei, male a ruoisingei Capernaum tieng an sea, mahan môrkhat chu an om zoi. ");
INSERT INTO sch_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Judangei Kalkân Kût anâi zoia, masikin Jisua Jerusalema a sea. ");
INSERT INTO sch_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Mahan Pathien Biekina serâtngei, kêl le belringei khom, male pharvali juorngei le sumthûlngâingei an dosângngei kôla an insung a mua. ");
INSERT INTO sch_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Masikin rûiruol a jêmna rang a sina, kêl, belringei le serâtngei an reng rêngin Pathien Biekin renga a mojôk ngei heta; sumthûlngâingei an sumdârngei khom a cheknôineka, an dosângngei khom a nam melet pe ngeia, ");
INSERT INTO sch_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","male pharvali juorngei kôm han chong a pêk ngeia, “Mangei hih hi mun renga hin chôipai roi! Ka Pa in hih sadâi munin sin khâi no roi!” a tia. ");
INSERT INTO sch_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","“O Pathien, ni in ranga kên pêkna hin, ku sûnga hin mei angin mi kâng ani,” tia ânziek ha a ruoisingei han an rietsuok nôk zoi. ");
INSERT INTO sch_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Juda rachamneipungei han chongrekel leh a kôm an hong kîr nôka, “Hima anga tho rangin racham no dôn tiin i sininkhêl thôn mo, mi ni min mu rang?” an tia. ");
INSERT INTO sch_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jisua'n an kôm, “Hi Biekin hih set ungla, male sûnthumin sin minding nôk ki tih,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Hanchu Judangei han, “Hi Biekin sinna rangin kum sômminli leiruk anânga! Nangman sûnthumin ni sinminding nôk thei rang mo?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Aniatachu Jisua'n biekin a ti hah ama takpum ke a tina ani. ");
INSERT INTO sch_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Masikin thina renga ân thoinôkin chu, a ruoisingeiin hi thurchi hih a lei misîr suozoi, ani ti an riet suoka, Pathien lekhabua chong le Jisua'n a lei ti sai ngei ha an iem zoi. ");
INSERT INTO sch_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jisua Kalkân Kûta Jerusalema aom lâiin mi tamtakin a sininkhêl tho hah an mu sikin ama an iem zoia. ");
INSERT INTO sch_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Hannirese Jisua'n ha mi ngei hah a riet ngei let sikin an chunga taksôn zoi maka. ");
INSERT INTO sch_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Mangei mulungrîlngeia han khoimo aom ama'n a riet var sikin tutên, mangei chungroi hah an ril rang nâng mak. ");
INSERT INTO sch_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Hanchu Phariseengei pâl kâra mi inkhat a riming Nicodemus Judangei ruoipu aoma. ");
INSERT INTO sch_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Jân khat chu Jisua kôm a sea, a kôm, “Rabbi, Pathien juongtîr Minchupu ni ni ti kin riet. Pathien an chunga aom nônchu tutên nangma angin sininkhêlngei hih tho thei no ni ngei,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jisua'n, “Chongdiktak nang ki ril: tutu khom a suok nôk nônchu Pathien Rêngram mu thei no ni ngei,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemus'n a rekela, “Kho angin mo mi ulien a chang suo nûkin a suok nôk thei rang? A nû sûnga lûtin voinik suok thei no nih!” a tia. ");
INSERT INTO sch_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jisua'n, “Chongdiktak nang ki ril ani. Tukhom tui le Ratha'n a suok nôk nônchu Pathien Rêngram lût thei no nih. ");
INSERT INTO sch_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Taksân ânzir kai chu taksa mi an nia, Ratha'n ânzir kai chu ratha mi an ni. ");
INSERT INTO sch_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nu suok nôk rang kêng ki ti hih kamâm aom ti no roh. ");
INSERT INTO sch_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Phâivuo hih anuomna ti-tieng asêma; arahang khom ni riet, aniatachu khotieng renga hong mo, khotieng mo ase rang riet mak che. Ma angdên hah ani, tukhom Ratha'n a suok nôk nônchu,” a tipea. ");
INSERT INTO sch_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemus'n, “Kho angin mo anithei ranga?” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jisua'n a kôm, “Israelngei lâia minchupu lien ni nia, hima roi hih ni riet minthâr theiloi mini? ");
INSERT INTO sch_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Chongdiktak nang ki ril: kin ti hih kin riet ania, kin mu hih kin ril ani; hannoma, kin thurchi misîr tutên pom nuom mak chei. ");
INSERT INTO sch_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Rammuola neinunngei chungroi ki misîr luo nin iem nônchu; i angin mo invân neinunngei chungroi ki misîr hin nin iem thei ranga? ");
INSERT INTO sch_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Invân renga juong chumpu, Miriem Nâipasal tiloiin chu, tute invâna lei hong se sai la om mak ngei.” ");
INSERT INTO sch_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moses'n ramchâra sumdâr murûl a târ anghan Miriem Nâipasal khom târin a om ngêt rang ani, ");
INSERT INTO sch_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","masika han tukhom ama iem kai chu kumtuong ringna an dôn theina rangin. ");
INSERT INTO sch_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Pathien'n rammuol a lungkham tatak sikin a Nâipasal khât a pêka, masika han tukhom ama iem kai chu thi loia kumtuong ringna an dôn theina rangin. ");
INSERT INTO sch_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Pathien'n rammuol theiloi mintum rangin a Nâipasal juongtîr maka, rammuol sanminring rangin kêng a juongtîr ani. ");
INSERT INTO sch_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Tukhom Nâipasal a iem kai chu theiloi intumin om no ni ngeia, tukhom a iem loi ngei chu atûn renga theiloi changin an om zoi, Pathien Nâikhât an iem loi sikin. ");
INSERT INTO sch_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mahi theiloi intumna chu ani: vâr ha rammuola ajuonga, aniatachu, mingeiin avâr nêkin ajîng an midit uola, an sinthongei hah asaloi sikin. ");
INSERT INTO sch_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tukhom sin saloi tho ngei nâmin chu avâr an henga, avâra hong ngâi mak ngei; asaloi an thongei hah minlang an nuom loi sikin. ");
INSERT INTO sch_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Aniatachu, adik sinpu ngeiin chu Pathien chongjômna sintho an ni ti avârin a minlang theina rangin avâra an hong ngâi. ");
INSERT INTO sch_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Masuole chu, Jisua hah a ruoisingei leh Judea ramhuola an sea, mahan môrkhat an lâia omin baptis a thoa. ");
INSERT INTO sch_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","John khomin Aenon, Salim khuo kôla han mi a baptis ngâia, ma muna han tui atam sikin. Mingei a kôm an sea, male ama'n a lei baptis ngei ngâia. ");
INSERT INTO sch_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Ma zora han John ha intângna ina la khum mak ngei.) ");
INSERT INTO sch_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Hanchu John ruoisi senkhatngei le Juda inkhat rusûk minsâina balam roia an inkhala. ");
INSERT INTO sch_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Masikin John kôm an sea, “Minchupu, Jordan râl nisuo tienga no kôma om, a chungroi ni misîr ngâi hah na la riet mo? Asa, atûnhin, ama'n mi a baptis'a mi murdi ama tieng kêng an se suo zoi!” an tia. ");
INSERT INTO sch_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","John'n a thuona, “Miriemin ite dôn mak me, Pathien'n a pêk ani nônchu. ");
INSERT INTO sch_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‘Keima hi Messiah ni mu-ung, aniatachu, a motona tîr ki ni’ ti hih nangni ngei reng hi ki rietpuipu nin ni. ");
INSERT INTO sch_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Moi puma chu mâkpa hah ani; hannirese mâkpa mal, a kôla ândinga a he a rangâichaka, a rôl a rietin chu a râisân tatak ngâi. Ma angdên han ka râisâna mikhipin aom ani. ");
INSERT INTO sch_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ama chu a hôn lal tetet ngêt rang ania, keima chu ko hôn tem tetet rang ani.” ");
INSERT INTO sch_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Chung tieng renga juongpu chu mi murdi nêka ânchungtak ani. Pila inzir chu pilchung mi ani, pilchung roi a misîr ngâi, hannirese, invân renga juongpu chu mi murdi nêka an chungtak ani. ");
INSERT INTO sch_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","A mu le a riet ngei a misîra, hannoma, tutên a thurchi misîr pom mak ngei. ");
INSERT INTO sch_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Aniatachu, a thurchi misîr a pom kai chu Pathien chu mi diktak ani ti a nammindet ani. ");
INSERT INTO sch_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Pathien tîrpu'n chu Pathien chong a misîr ngâi, Pathien'n ama Ratha akipin a pêk sikin. ");
INSERT INTO sch_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Pa'n a Nâipasal a lungkham ngâia, neinunngei murdia a racham nuoia a dar let zoi. ");
INSERT INTO sch_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Tukhom Nâipasal a iem kaiin chu kumtuong ringna an dôn zoi; tukhom Nâipasal chongjômloi chu ringna dôn no ni ngeia, Pathien dûkmintongna nuoia kêng an om rang. ");
INSERT INTO sch_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Phariseengei han John nêkin Jisua ruoisi atam uol, ama'n tui leh mi a baptis a min tam uol ti an riet zoia. ");
INSERT INTO sch_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Adikin, Jisua'n chu tute baptis maka; a ruoisingei vaiin ke mi an baptis ngâi ani.) ");
INSERT INTO sch_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Masikin Jisua'n ha anga an ti hah a rietin chu Judea ram a mâka Galilee tieng a kîr nôka; ");
INSERT INTO sch_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","a se tieng Samaria ram palin a se rang anâng ani. ");
INSERT INTO sch_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Samaria ram sûnga han khopui inkhat Sychar an ti han a hong tunga, Jacob'n a nâi Joseph mun a pêkna kôl hah ani. ");
INSERT INTO sch_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jacob tuikuong khom mahan aoma, Jisua'n a lam lônna a sôl sikin ha tuikuong kôla han ânsung raka, ma hah sûnchimripa ani. ");
INSERT INTO sch_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Samaria nupang inkhat tuithâl rangin a honga, male Jisua'n a kôm, “Tui nêk rang mi pêk roh,” a tipea. ");
INSERT INTO sch_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(A ruoisingei chu sâkruo rochôk rangin khopui sûnga an sea). ");
INSERT INTO sch_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nupangnu han a kôm, “Nangma Juda mi ni nia, keima Samaria nupang ki nia, kho-angin mo tui nêk rang mi ni zong hi?” (Judangei han khuri mo, khuriâi mo, Samaria mingeiin an mangna chu mang ngâi khâi mak ngei.) ");
INSERT INTO sch_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Hanchu Jisua'n a thuona, “Pathien neinunpêk le buong rang mi pêk roh tipu hi ni riet nisenla chu, nangman keng a kôm zong na ta; hanchu, ama'n ringna-tui nang a pêk rang ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Nupangnu han a kôm, “Pu, tui thâlna laka ite dôn mak chea, tuikuong lak ânthûk zana. Khotieng mo ringna-tui na man rang? ");
INSERT INTO sch_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Kin pu Jacob'n hi tuikuong hih mi pêka; ama le a nâingei le a sâ vâi ngei murdi khom ma renga hih an lei nêk ngâi ani. Kin pu Jacob nêkin no roiinpui uol mo?” ");
INSERT INTO sch_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jisua'n a thuona, “Tutu khom hi tui nêk ngei chu an tui lân râl nôk a ta, ");
INSERT INTO sch_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Hannirese, tukhom an kôma tui ke pêk rang a nêk ngei kai chu an tui inrâl nôk tet khâi no nih. Keiman tui ke pêk rang chu, an sûnga tuinâr hong chang a ta, tuinâr han ringna-tui le kumtuong ringna pêk atih,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nupangnu han a kôm, “Pu, ma tui hah ni pêk roh! ku tui ânrâl khâi loina rang le hi tena lâ tuithâl ko hong khâi loina rangin,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jisua'n ha nu kôm han, “Sênla, no lômpa va koi inla, hong nôk roh,” a tipea. ");
INSERT INTO sch_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nupangnu'n a kôm, “Lômpa la dôn mu-ung,” tiin amanu han a thuona. Jisua'n chong a melea, “Lômpa dôn mu-ung, ni ti hih, ni ti mindik ani. ");
INSERT INTO sch_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Pasal rangnga in ne neipui zoia, male atûna no ompuipa khom hih no lômpa tatak nimak. Chongdiktak ni ni ril ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nupangnu han a tia, “Pu, dêipu ni ni ti ki riet.” ");
INSERT INTO sch_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","“Kin Samari richibulngeiin chu hi tânga hin Pathien chubai an mûk ngâi, aniatachu, nangni Judangeiin chu Jerusalema Pathien chubai kin mûk ngâi ani, nin ti ngâi.” ");
INSERT INTO sch_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jisua'n, nupangnu kôm han a tipea, “Nupangnu, keima mi iem roh, hi tâng le Jerusalem ngêt ni loi khomin mingeiin Pa chubai an mûk zora la tung atih. ");
INSERT INTO sch_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nangni Samari mingeiin chu nin riet loi chubai nin mûk ngâi; aniatachu keini Judangeiin chu kin riet ke chubai kin mûk ngâi ani, sanminringna hih Judangei renga hong suok kêng ani sikin. ");
INSERT INTO sch_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Hannirese azora atung rang ani zoi, male atûn khom atung tir ani zoi, ma tikin chu Pathien chubaimûk ngeiin Ratha le Chongtakin Pa chubaimûk an tih, Pa'n ma anga mingei ha ama chubaimûk rangin a nuom ngâi ani. ");
INSERT INTO sch_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Pathien chu Ratha ania, ama chubai mûk ngeiin Ratha le chongtakin chubai an mûk rang ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nupangnu han a kôm, “Messiah la juong atih, ti ki riet, a juong tikin chu neinunngei murdi mi ril atih,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jisua'n a thuona, “Keima nang chongpuipa hih, ama hah ki ni,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ma lâitak han a ruoisingei an hong kîr nôka, nupang leh an chong an mua an kamâm sabaka. Aniatachu, tutên ha nu kôm han, “Imo no zong?” aninônchu ama kôm, “Ithomo nupang no chongpuia?” tiin khom ite rekel mak ngei. ");
INSERT INTO sch_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Hanchu nupangnu hah a tuibêl mâkrakin khopui sûnga a kîra, male mingei kôm, ");
INSERT INTO sch_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ki sin lei tho ngei murdi a ril thei let mi inkhat a oma, hong en ta u, Messiah ni thei ni mo?” a tia. ");
INSERT INTO sch_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Masikin khopui renga an honga Jisua kôm an va se zoi. ");
INSERT INTO sch_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ma zoratak han ruoisingeiin, “Minchupu, sâk-sâk bak hi roh!” tiin an lei ngêna. ");
INSERT INTO sch_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nikhomsenla Jisua'n, “Nin riet loi bu nêk rang ko dôn,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Masikin ruoisingei han anni leh anni anin rekela, “Mîn bu an hong chôi pe mini?” an tia. ");
INSERT INTO sch_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jisua'n an kôm, “Mi tîrpu lungdo sin le a sin zoi rang hi ku bu tuitak ani, a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nangnin chu, ‘Bu âtna rang tha minli ala om nin tia.’ Aniatachu nangni ki ril, loingei so en sabak ta u; atûn renga ât rangin bungei an min zoi! ");
INSERT INTO sch_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","A âtpu'n chu rathaman a man ngâia, kumtuong ringna dêna om rangin amara a mintûp ngâi; masikin a lingpu le a âtpu an râisân ânruol theina rangin. ");
INSERT INTO sch_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","‘Mi inkhatin a linga, mi dangin a ât ngâi,’ ti hi adik ani. ");
INSERT INTO sch_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nin sin loina muna nangni ki tîr; mi dangin an sina, an sin sai hah nin ât ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nupangnu han, “Ki sin lei tho ngei murdi ni ril let,” tiin a thurchi a misîr pe ngei sikin Samari khopui mingei, mi tamtakin Jisua an iem zoi. ");
INSERT INTO sch_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Masikin, Samari mingei ha Jisua kôm an honga, an kôm om rangin an ngêna, male Jisua'n ha khopui han sûnnik a châm zoi. ");
INSERT INTO sch_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Midang tamtakin khom a thurchi misîr sikin an iem sa zoia, ");
INSERT INTO sch_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","male anni ngei han nupangnu kôm, “Atûn chu mi ni misîr pe sika ni loiin keini lelên a thurchi misîr kin rieta, hi mi hih rammuol sanminringpu ani khet ti kin riet zoi,” an tia. ");
INSERT INTO sch_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ma khopui han sûnnik a châm suole chu a mâka Galilee rama a se zoi. ");
INSERT INTO sch_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jisua'n ama rang nanâk ân tia, “Dêipungei chu an ram nanâka chu miritin om ngâi mak ngei,” tiin. ");
INSERT INTO sch_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galilee rama a tungin chu mipuingeiin an lei phâm tataka, Jerusalema Kalkân Kût han inchelin Jisua sintho ngei murdi ha an mu sikin. ");
INSERT INTO sch_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Hanchu, Jisua ha Galilee rama Cana khuoa tui uain a min changna han a hong nôka, sorkâr ulien inkhat a oma, a nâipasal Capernaum khuoa dam loiin a om ani. ");
INSERT INTO sch_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jisua Judea ram renga Galilee rama a hong ti a riet lehan a kôm a sea, Capernaum khuoa sea, a nâipasal juong mindam rangin Jisua a ngêna, a nâipasal hah a thi vang zoi ani. ");
INSERT INTO sch_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jisua'n an kôm, “Sininkhêlngei le neinun kamâmomngei nin mu nônchu tutên iem no tu nui,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Sorkâr ulien han, “Pu, ka nâipasal a thi mân ni juong pe roh,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jisua'n a kôm, “Se nôk ta roh, na nâipasal a dam zoi!” a tipea. Ha mi han Jisua chongngei ha iem pumin a se zoi. ");
INSERT INTO sch_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Hanchu a in a pan lâiin lampuia a tîrlâmngei leh annin tonga, “Na nâipasal a dam zoi!” an tipea. ");
INSERT INTO sch_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ama'n an kôm, a nâipasal lei dam zora tak hah a rekel ngeia, annin a kôm, “Mazan chonûktieng dârkhat inring han a mintun a lei mathân zoi,” an tipea. ");
INSERT INTO sch_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Hanchu, a pa han Jisua'n a kôm, “Na nâipasal a dam zoi,” a tipe zora tak hah ani ti a riet zoi. Masikin ama le a inmingei anrêngin an iem zoi ani. ");
INSERT INTO sch_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ma hah Jisua'n Judea ram renga Galilee rama a hong suo nûka a sininkhêl sin avoinikna ani. ");
INSERT INTO sch_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Masuole chu, Jisua Jerusalema Judah sakhuo tienga khohoi aom sikin a sea. ");
INSERT INTO sch_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem Belri Mokot kôla han dîl inkhat aoma, Hebrew chongin Bethzatha an ti ngâi; ma dîl han bokrop rangnga aoma. ");
INSERT INTO sch_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ma bokropngei han damloi ngei loko tamtak an jâla mitcho ngei, kholra ngei le phalkhatthi ngei, tui singânsa zora an ngâka, ");
INSERT INTO sch_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","a kakâra dîl han vântîrton, a juonga, tui ha a juong chek ngâi. Ma tui singânsa zora han dîla a lût masatak chu i-anga natna khomnirese an dam ngêt ngâi. ");
INSERT INTO sch_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mi inkhat kum sômthum leiriet damloi a oma. ");
INSERT INTO sch_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jisua'n a jâlin ava mua, male zora sôt tak renga damloia om ani ti a rieta; masikin a kôm, “Dam rang no jôt mo?” tiin a rekela. ");
INSERT INTO sch_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Hanchu damloipu han, “Pu, tui singânsa zora dîla mi juong thak rang lak dôn mu-ung; ke se khomin mîn, min khêl nôk ngâi,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jisua'n a kôm, “Inthoi inla, na jâmpher louk inla, lôn ta roh,” a tipea. ");
INSERT INTO sch_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ha mi han voikhatrengin a hong dam kelena; a jâmpher chôiin a lôn phut kelen zoi. Ma nikhuo hah sabbathni ania, ");
INSERT INTO sch_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","masikin Juda rachamneipungeiin a dampu kôm han, “Avien hin sabbathni kêng ani, jâmpher chôia lôn hi ei balam nimak,” an tipea. ");
INSERT INTO sch_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ama han an kôm, “Ni mindampu'n, ‘Na jâmpher louk inla, lôn ta roh’ mi ti kêng,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Anni ngei han, “Hi anga tho ranga nang rilpu hah tumo ani?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Hannirese, ha a dampu han Jisua hah tumo ani riet mak, ha muna han mipui an tam sikin Jisua chu a rotpat zoi. ");
INSERT INTO sch_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Chomol suole chu, Jisua'n ama hah Biekina a mua male a kôm, “Rangâi roh, na dam zoi ani; masikin nunsie tho nôk khâi no roh, nu chunga natna saloi uol hong tung nih,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Masuole chu ha mi han Juda rachamneipungei kôm a mindampu chu Jisua ani ti ava ril ngeia. ");
INSERT INTO sch_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Masikin sabbathni mi a mindam an ti sikin Jisua hah dûk an mintong zoi. ");
INSERT INTO sch_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jisua'n an kôm, “Ka Pa'n sin a tho tit ngâia, male kei khom sin ko tho ngêt rang ani,” tiin a thuon ngeia. ");
INSERT INTO sch_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ma anghan a ti sikin Juda rachamneipungeiin that rang an bôk uol nôk zoi; Sabbathni balam a siet ti vai niloiin, Pathien hah a Pa angin a bêa, ama khom Pathien leh ân-angin ânbê ti sika khom ani. ");
INSERT INTO sch_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Masikin Jisua'n a thuon ngeia, “Chongdik tak nangni ki ril: Nâipasal athenin ite tho thei maka; a Pa sintho a mu ngei kai vai ke a tho ngâi. Pa'n sin a tho kai ke Nâipasal khomin a tho ngâi ani. ");
INSERT INTO sch_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Pa'n Nâipasal a lungkhama male a tho murdi a min mu ngâi ani. Hi nêka neinun roiinpui a tho rang khom la min mûng atih, male nin rêngin nin la kamâm rang ani. ");
INSERT INTO sch_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Pa'n mithi a kaithoia ringna a pêk ngei anghan, Nâipasal khomin a nuom kai chu a min ring ngâi. ");
INSERT INTO sch_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Pa'n tute roijêk pe ngâi maka. Roijêk rangin Nâipasal kôm kêng rachamneina akipin a pêk zoia, ");
INSERT INTO sch_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","masikin mi murdi'n Pa mirit an tho anghan Nâipasal khom mirit an tho theina rangin. Tukhom Nâipasal mirit tho loi kai chu Pa a tîrpu mirit tho loi ani. ");
INSERT INTO sch_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Chongdik tak nangni ki ril: Tukhom ko chong rieta mi tîrpu iem kaiin chu kumtuong ringna an dôn zoi. Theiloi changin om mak ngeia, thina renga an jôka ringna han an lût zoi ani. ");
INSERT INTO sch_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Chongdik tak nangni ki ril: azora atung rang ani zoi, atûn khom atung tir zoi, male mithi ngeiin Pathien Nâipasal rôl riet an ta, a riet ngei kai chu hong ring an tih. ");
INSERT INTO sch_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Pa ha ringna nâr ani anghan, Nâipasal khom ringna nârin a sin ani. ");
INSERT INTO sch_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Male Miriem Nâipasal ani sikin a kôm roijêk rangin rachamneina a pêk ani. ");
INSERT INTO sch_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ma hi kamâm no roi; azora atung rang ani zoi, ma tikin chu mithi ngeiin a rôl riet an ta, ");
INSERT INTO sch_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","male an thânngei renga hôn thoi an ta: sin sa tho ngei chu ringna changin inthoi nôk an ta, sin saloi tho ngei chu theiloi changin inthoi nôk an tih. ");
INSERT INTO sch_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Ke thena rachamneinân ite tho thei mu unga; Pathien'n ni ril lam anghan roi ke jêk ani, masikin ko roijêk chu adik ani. Keima ku nuom hi sin rangin bôk mu unga, mi tîrpu lungdo kêng sin rang ko bôk ani. ");
INSERT INTO sch_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Ku thurchi nanâk misîr ronga, ku thurchi misîr ha adik tiin pom thei ni no ni. ");
INSERT INTO sch_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Aniatachu ku thurchi mi aminrietpu chu mi dang ania, male ama'n ku thurchi a misîr hah adik ti ki riet. ");
INSERT INTO sch_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nangnin John kôm thangtheipungei nin tîra, ama han chongtak ruthûlin chong nangni a lei rila. ");
INSERT INTO sch_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Munisi rietpuipu ko dôn ngêt rang ki ti nimaka; mahi sanminringa nin om theina ranga ki ti ani. ");
INSERT INTO sch_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","John hah châti vârtak le ân-ângtak angin ani, male zora bongkit vai mang rang nin nuom ani anghan. ");
INSERT INTO sch_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Hannirese, rietpuipu ko dôn hi chu John minrietna chong nêkin a roiinpui uol: Khoimo ko tho, ma hah, Pa'n sintho ranga mi pêk ani, ki sintho ngêt hin Pa mi tîr ani ti ku thurchi a minriet ani. ");
INSERT INTO sch_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Male Pa mi tîrpu khom han a minriet zoi, nangnin chu khotik lâi khomin a rôl la riet ngâi mak chei, a mêl khom la mu mak chei, ");
INSERT INTO sch_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","male a chong khom nin mulungrîlngeia vong ngâi mak chei, a tîrpu hi nin iem loi sikin. ");
INSERT INTO sch_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Asûnga kumtuong ringna aom ti nin sabei sikin, Pathien Lekhabungei ha nin pore ngâi. Male Pathien Lekhabungei han ku thurchi an misîr ani! ");
INSERT INTO sch_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Hankhoma, ringna nin dôna rangin ko kôm hong jôt ngâi mak chei. ");
INSERT INTO sch_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Munisi minpâkna rok mu-ung. ");
INSERT INTO sch_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Aniatachu kho anga miriem mo nin ni nangni ki riet, male nin mulungrîlngei han Pathien lungkhamna dôn mak chei ti ki riet. ");
INSERT INTO sch_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ka pa rachamneina leh ku juong ani, hannirese mi modôm mak choia; nikhomrese, tumakhatin ama rachamin hong rese chu lei modôm nin tih. ");
INSERT INTO sch_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Pathien inkhat vai renga minpâkna man rang nuom mak choia, inkhat le inkhat inpâk inlôm kêng nin min luta; nônte, kho angin mo mi nin iem rang? ");
INSERT INTO sch_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nikhomrese, keiman Pa makunga nangni doi ki tih tiin mindon no roi. Nangni doi rang chu mi inkhat aom, nin sabeipu Moses ha. ");
INSERT INTO sch_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moses nin iem tatakin chu, kei khom mi nin iem rang ani; ama han ku chungroi kêng a miziek sikin. ");
INSERT INTO sch_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Aniatachu a miziek nin iem nônchu, kho angin mo ko chong nin iem thei ranga?” a tia. ");
INSERT INTO sch_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Masuole chu, Jisua Galilee dîl râl inkânin a se zoi. (Tiberias dîl khom an ti sa ngâi). ");
INSERT INTO sch_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Damloi ngei chunga a sininkhêlngei an mu sikin loko tamtakin an jûia. ");
INSERT INTO sch_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jisua hah muola a kala male a ruoisingei leh an insunga. ");
INSERT INTO sch_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Judangei Kalkân kût zora ha anâi zoia. ");
INSERT INTO sch_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jisua'n akôl akieng a hong ena, loko tamtakin ama tieng an hong pan a mua, masikin Philip kôm han, “Hi mingei sâk rang vâipôl khonmo ei rochôk rang?” a tia. ");
INSERT INTO sch_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Hi chong hi Philip minsina ranga a ti ani, adiktakin chu imo a tho rang lam ama'n a riet sai ani.) ");
INSERT INTO sch_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Philip'n a kôm, “Mitinin achîn tete min chang ngei rang khomin sumdâr duli razannik man vâipôlin luo hun no ni ngei,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","A ruoisingei adang inkhat, Simon Peter lâibungpa Andrew'n a tia, ");
INSERT INTO sch_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Barli vâipôl pêk rangnga le nga inik a dôn pasalte inkhat hi hin aom. Aniatachu hi dôra mingei sâk rangin chu hun no ni ngei,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jisua'n, “Mipuingei hah minsung roi,” tiin a ril ngeia. (Ma mun han durba tamtak aom.) Mipuingei ha an insung zoia; mi isâng rangnga dôr an ni. ");
INSERT INTO sch_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jisua'n vâipôl hah a lâka, Pathien kôm râisânchong a rila, male mipui ânsungngei hah a sem pe ngeia; ma angdên han nga khom a sem nôka, an nuom do-dôr a sem pe ngeia. ");
INSERT INTO sch_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","An khoptang suo nûkin a ruoisingei kôm, “Ite inpai riek loi rangin an sâk minieng; khom rûtvar roi,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Masikin barli vâipôl rangnga sâk ngei, an sâk minieng ha tabong sômleinik an la rût min sipa. ");
INSERT INTO sch_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ha mingei han Jisua sininkhêl sin hah an mûn chu, “Hi mi hih dêipu tatak, rammuola juong rangpu ha ani khet!” an tia. ");
INSERT INTO sch_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Anni ngei hah hongin, ama hah rangrâta sûrin rêng minchang rang an bôk ti Jisua'n a rieta; masikin athenin muola a se nôk zoi. ");
INSERT INTO sch_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kholoi ahong nin chu, Jisua ruoisingei hah dîla an juong sea, ");
INSERT INTO sch_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","rukuonga an chuonga, dîl râl Capernaum tieng an pana. Jân ahong ni tena khom Jisua hah an kôm la hong tung maka. ");
INSERT INTO sch_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Hanchu phâivopui hong rângin ahong sêma male tuidâr ahôn soka. ");
INSERT INTO sch_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Hanchu ruoisingei han kilometer rangnga mini, uruk mini an hong jâpin chu Jisua hah tui chunga lônin rukuong tieng a hong panin an mua, an lei chia. ");
INSERT INTO sch_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jisua'n an kôm, “Chi no roi, keima kêng ki ni!” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Hanchu râisântakin rukuonga han an min chuonga, male rukuong leh an va pana, tângkôl hah harenghan an tung kelen zoi. ");
INSERT INTO sch_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Anangtûka chu dîl râl kângkhat tienga mipui a omngei han rukuong inkhat vai mahan aom ti an rieta. Jisua chu a ruoisingei leh rukuonga chuong loiin, anni ngei ha mâkin anthenin an se ti an riet zoia. ");
INSERT INTO sch_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Pumapa'n râisânchong a ril suole lokongeiin vâipôl an sâkna mun kôla han rukuong dang ngei Tiberias renga an hong tunga. ");
INSERT INTO sch_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Mipuingeiin Jisua le a ruoisingei chu ha muna han om khâi mak ngei ti an rietin chu anni khom rukuonga chuongin Capernauma, Jisua rok rangin an se zoi. ");
INSERT INTO sch_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Mipuingei han Jisua dîl râla an hong mûn chu a kôm, “Minchupu, khotik han mo hi tieng râl no hong tung?” an tia. ");
INSERT INTO sch_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jisua'n an kôm, “Chongdiktak nangni ki ril: sininkhêlngei nin riet sika mi nin rok ni loiin, vâipôl nin sâk man sika mi nin rok kêng, tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Vâipôl asiet nôk thei ngâi rangin sin no ungla; manêkin chu kumtuong ringna vâipôl adier rangin sin roi. Hi vâipôl hih Miriem Nâipasalin nangni a pêk rang ani, Pathien, Pa, han ama sînthona a chunga adar zoi sikin.” ");
INSERT INTO sch_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Masikin anni ngei han a kôm, “Pathien lungdo kin sin theina rangin imo kin tho rang?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jisua'n a thuon ngeia, “Pathien'n khoimo sin ranga nangni a nuom chu a tîrpu iem hih ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Anni ngei han a kôm, “I sininkhêl mo ni sin rang, kin mua nang kin iem theina rangin? Imo no tho rang? ");
INSERT INTO sch_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Kin richibulngei chu ramchâra han manna an sâk ngâia, Pathien lekhabu'n ati anghan, ‘Invân renga vâipôl sâk rang a pêk ngei,’” tiin chong an thuona. ");
INSERT INTO sch_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jisua'n an kôm, “Chongdiktak nangni ki ril,” “Moses'n vâipôl nangni a pêk hah invân renga nimaka; Ka Pa'n kêng invân renga vâipôl diktak nangni a pêk. ");
INSERT INTO sch_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Pathien'n vâipôl nangni a pêk chu invân renga a juong chuma rammuol ranga a ringna pêkpu hih ani.” ");
INSERT INTO sch_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Anni ngeiin, “Pu, ma vâipôl hah mi pêk bang roh,” an tia. ");
INSERT INTO sch_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jisua'n an kôm, “Keima hih ringna vâipôl ki ni.” “Tukhom ko kôma hong ngei chu an vonchâm no nia; tukhom keima mi iem ngei chu an tui inrâl khâi no ni. ");
INSERT INTO sch_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Atûn hin, nangni ki ril, mi nin mua aniatachu mi iem mak chei. ");
INSERT INTO sch_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Pa'n mi pêk ngei kai chu ko kôm hong an tih. Ko kôma hong kai chu tute rujûl tet noning, ");
INSERT INTO sch_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ku lungdo sin ranga invân renga juong ni mu unga, mi tîrpu lungdo sin ranga juong kêng ki ni. ");
INSERT INTO sch_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ma hih mi tîrpu lungdo chu ani, mi pêk ngei murdi tute minmang loiin nikhuo nûktaka chu aringin kaithoi inlang, ti hih. ");
INSERT INTO sch_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ka Pa'n a nuom tak chu tukhom Nâipasal mua a iem ngei murdi'n chu kumtuong ringna dôn senla ngei, keiman nikhuo nûktaka, mangei hah kaithoi ngei inlang ti hi ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","“Invân renga vâipôl juong chum ki ni,” a ti sikin mipuingei hah an chierlul zoi. ");
INSERT INTO sch_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Masikin anni ngei han, “Hi mi hih Joseph nâipasal Jisua hah nimak mo? A nû le a pa khom ei rieta. Nônte, kho angin mo, invân renga juong chum ki ni a ti thei hi?” an tia. ");
INSERT INTO sch_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jisua'n an kôm, “Nin thenin chier kekêng no roi. ");
INSERT INTO sch_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Pa mi tîrpu'n a kaikuoi nônchu tute ko kôm hong thei no ni ngei; male keiman nikhuo nûktaka chu kaithoi ngei ki tih. ");
INSERT INTO sch_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Dêipungei lekhabua, ‘Pathien'n mitin la minchu ngei atih,’ tiin an miziek ani. Mitin Pa chong rieta ânchu ngei kai chu ko kôm an hong ngâi. ");
INSERT INTO sch_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mahi tutên Pa an mu zoi ki tina nimaka; Pa kôm renga juongpu vaiin kêng Pa ha a mu ani. ");
INSERT INTO sch_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Chongdiktak nangni ki ril: tukhom a iem kai chu kumtuong ringna an dôn zoi. ");
INSERT INTO sch_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Keima hih ringna vâipôl ki ni. ");
INSERT INTO sch_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nin richibulngeiin ramchâra manna hah an sâka chu an thi dên ani. ");
INSERT INTO sch_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Aniatachu, invân renga vâipôl juong chum hi chu tukhomin an sâka anîn chu thi khâi no ni ngei. ");
INSERT INTO sch_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Keima hi vâipôl aring invân renga juong chum ki ni. Tukhomin hi vâipôl hih a sâkin chu kumtuongin ring tit atih. Vâipôl ke pêk rang chu ka taksa hi ani, rammuol ringna ranga ke pêk chu” a tia. ");
INSERT INTO sch_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Masikin Judangei ha taksîn an inkhal phut zoia. “Kho angin mo hi miriempa hin a taksa ei sâk rangin mi pêk thei ranga?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jisua'n an kôm, “Chongdiktak nangni ki ril: Miriem Nâipasal taksa hih nin sâk noa, a thisen khom nin buong nônchu nin thethenin ring thei no tunui. ");
INSERT INTO sch_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Tukhom ka taksa a sâka, ki thisen a buong kai chu kumtuong ringna an dôn zoi, male anni ngei ha keiman nikhuo nûktaka kaithoi ngei ki tih. ");
INSERT INTO sch_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ka taksa hi bu diktak a nia; ki thisen hi buong ruo tak ani. ");
INSERT INTO sch_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Tukhom ka taksa sâka, ki thisen buong ngei kai chu keima ko kôm an om banga, male kei khom an kôm ko om bang ngâi. ");
INSERT INTO sch_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Pa aring han mi tîra, male Pa jâra ring ki ni sa. Ma angdên han ka taksa sâk ngei kai chu keima jârin ring an tih. ");
INSERT INTO sch_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ma hih invân renga vâipôl juong chum chu ani; nin pilepungeiin vâipôl an sâka an thi nôk angha nimak. Tukhom hi vâipôl sâk ngei kai chu kumtuongin ringtit an ti.” ");
INSERT INTO sch_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Hi chong hih Jisua'n Capernaum synagog taka a minchu lâia a ti ani. ");
INSERT INTO sch_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","A nûkjûi tamtak ngeiin hi chong hih an rietin chu, “Hi minchuna hih chong ngartak kêng ani. Tumo a rangâi thei ranga?” an tia. ");
INSERT INTO sch_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Tutên ril loiin, a ruoisingei hah ma roia han an chier ani, ti Jisua'n a mulungrîlin a rieta, an kôm, “Hi roi sika hin nin mulung amin hoiloi mini? ");
INSERT INTO sch_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Nônte, chongkhatin, Miriem Nâipasal hih motona a omna ngâia a kîr nôk nin mu tika kho angin mo nin tho rang? ");
INSERT INTO sch_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ringna pêkpu chu Pathien Ratha ania; munisi ranak chu ite a mangna omak. Nin kôma ki misîr chongngei hih ringna pêkpu Pathien Ratha ani. ");
INSERT INTO sch_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Hannoma senkhat chu iem mak chei,” a tia. (Jisua'n aphut renga tu ngei mo a iem loi rang le tu lelên mo a minsûr rang a riet chien sai ani.) ");
INSERT INTO sch_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Male a bôksa nôka, “Hi sika hin kêng, Pa'n a thop nônchu tute ko kôm hong thei no ni ngei ki ti ani.” ");
INSERT INTO sch_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Masika han Jisua nûkjûi ngei mi tamtakin nûkkîr an thoa, ama jûi khâi mak ngei. ");
INSERT INTO sch_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Masikin Jisua'n ruoisi sômleinik ngei kôm, “Nangni khom rot rang nin jôt mo?” tiin a rekel ngeia. ");
INSERT INTO sch_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Peter'n a kôm, “Pumapa, tu kôm mo kin rot ranga? Kumtuong ringna chongngei laka nangman no dôna. ");
INSERT INTO sch_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Male atûn chu kin iema, Pathien renga juong Mi Inthieng ni ni ti kin riet zoi,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jisua'n a kôm, “Nangni sômleinik ngei hih keiman nangni ka thang nimak mo? Hannoma nin lâia mi inkhat hih diabol kêng ani!” tiin chong a mele. ");
INSERT INTO sch_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ama han Judas, Simon Iscariot nâipasal chungroi a misîr ani. Judas hah ruoisi sômleinik ngei lâia mi nikhomsenla, ama a minsûr rang ani sikin. ");
INSERT INTO sch_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Masuole chu, Jisua'n Galilee rama a chaia; Juda rachamneipungeiin that rang an bôk sikin Judea rama chu chai nuom khâi mak. ");
INSERT INTO sch_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Judangei Kâirêng khohoi zora anâi zoia, ");
INSERT INTO sch_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","masikin Jisua lâibungngei han a kôm, “Hi mun hih mâk inla, Judea rama se roh, masika han nu nûkjûi ngeiin ni sintho an mu theina rangin, an tia. ");
INSERT INTO sch_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ama riming inthang rang nuompu chu tutên a sintho thup ngâi mak. Hi neinunngei hih ni sin anînchu rammuol pumpuiin nu chungroi riet rese bah!” an tia. ");
INSERT INTO sch_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(A lâibungngei luon ama iem mak ngei.) ");
INSERT INTO sch_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jisua'n an kôm, “Keima rangin chu azora diktak la tung mak. Zora pai hih nangni rangin chu adik ani. ");
INSERT INTO sch_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Rammuolin nangni mumâk maka, aniatachu keima chu mi mumâk ngâi, a sintho ngei ha sa mak tiin ki ril ngâi sikin. ");
INSERT INTO sch_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Khohoia nangni lei se roi, kei chu khohoia la se thei no ning, ko zora diktak ala tung loi sikin,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ma chong hah a ti suole khom ama chu Galilee rama a la om bang. ");
INSERT INTO sch_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","A lâibungngei khohoia an se suole chu Jisua khom a se sa; ânlangin chu se maka, inrûkin a se zoi. ");
INSERT INTO sch_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Juda rachamneipungeiin khohoia han ama an roka, “Khonmo aom?” tiin an rekel titira. ");
INSERT INTO sch_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mipuingeiin a chungroia an inkereng chichiena; senkhatin, “Miriem sa kêng,” an tia. Adang ngeiin, “Nimak, ama kêng mingei lamnôk tieng a tuong ngâi,” an tia. ");
INSERT INTO sch_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Hannirese Juda rachamneipungei an chi sikin tutên ânlangin chu a chungroi misîr ngam mak ngei. ");
INSERT INTO sch_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Khohoi ha inang dôr an mang tena chu Jisua Biekina a sea mingei a minchu phut zoi. ");
INSERT INTO sch_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Juda rachamneipungei han an kamâm sabaka, “Hi mi hi ânchuna boi tetin kho angin mo madôr a riet thei hi!” an tia. ");
INSERT INTO sch_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jisua'n a thuona, “Ki minchuna chong hih keima kata nimaka, aniatachu Pathien mi tîrpu renga juong kêng ani. ");
INSERT INTO sch_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tutu khom Pathien lungdo a sin nuom kai chu hi minchuna chong hih Pathien renga juong mo, aninônchu ka rachama ko chong mo riet an tih. ");
INSERT INTO sch_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Tukhom ama rachama chongpu chu ama roiinpuina man rang a pût ani. Hannirese, a tîrpu roiminpui rang a nuompu'n chu dikna a dôna, male ama sûnga han dikloina reng omak. ");
INSERT INTO sch_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses'n Balam nangni a pêk nimak mo? Hannirese Balam hah tutên jôm mak chei. Ithomo ni that rang nin bôk hi?” a tia. ");
INSERT INTO sch_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mipuingei han, “Ramkhori nang a sûr ngihi! Tumo nang that rang a bôk?” tiin lokongeiin an thuona. ");
INSERT INTO sch_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jisua'n an kôm, “Sininkhêl inkhat ko thoa, nin rêngin nin kamâm sabaka. ");
INSERT INTO sch_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses'n nin nâipasalngei sertan rangin chong nangni a pêka (Moses'n a phut nimaka, nin richibulngeiin kêng an phut ani), masikin Sabbathnin pasalte ser nin tan ngâi ani. ");
INSERT INTO sch_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Moses Balam asiet loina rangin Sabbathni khom pasalte sertan nin tho ngâi anînte, keiman Sabbathnia mi ki mindam phar sikin ithomo ku chunga nin takasi? ");
INSERT INTO sch_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Pêntienga ânlang rang vaiin roijêk mong ungla, male adiktakin roijêk roi,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalema mi senkhatin an tia, “Hi mi hih rachamneipungeiin that ranga an pût ha nimak mo? ");
INSERT INTO sch_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","En ta u! Mipui rietin thurchi a misîra, male tutên rokôk mak ngei! Ama hih Messiah ani tiin rachamneipu ngeiin an riet tatak zoi mini? ");
INSERT INTO sch_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Aniatachu Messiah a juong tika chu kho renga mo a juong tutên riet no ni ngei. Hi mi hi chu a hongna ei rêngin ei riet-iem ani,” an tia. ");
INSERT INTO sch_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jisua'n Biekina a minchu lâihan rôl inringtakin a tia, “Tumo ki ni le kho renga hong mo ki ni nin riet tatak mo zoi? Ka rachama juong ni mu-ung. Mi tîrpu chu mi diktak ani. Nangnin chu ama ha riet mak choia, ");
INSERT INTO sch_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","aniatachu keiman chu ama ha ki rieta, a kôm renga juong le ama mi tîr ki ni sikin,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Hanchu ama hah sûr rang an pût zoia, aniatachu, azora ala tung loi sikin tutên an kut musum mak ngei. ");
INSERT INTO sch_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Hannirese mipui lâia mi tamtakin chu ama an iem zoi, “Messiah a juong tika hi mi hin a sin nêka tam sininkhêlngei sin thei ni mo?” an tia. ");
INSERT INTO sch_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Phariseengeiin Jisua chungroia mipuingei an inkereng chichiena chong an rieta, masikin ochaisingei le Phariseengeiin Jisua sûr rangin rungpungei an tîra. ");
INSERT INTO sch_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jisua'n an kôm, “Chomolte nin kôm la om ka ta, masuole chu mi tîrpu kôm sêng ki tih, a tia. ");
INSERT INTO sch_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nangnin mi rok nin ta, mi mu no tunui, ke sena ranga nin se thei loi sikin.” ");
INSERT INTO sch_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Juda rachamneipungei han anni nanâkin, “Ei mu thei loina rangin khotieng mo se rang a ti? Ei mingei omna Greek khopuilienngeia sea, male Greekngei juong minchu rang a ti mini? an tia. ");
INSERT INTO sch_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Nangnin mi rok nin ta mi mu no tunui, ke sena ranga hong thei no tunui, a ti hih khoimo a tina?” an tia. ");
INSERT INTO sch_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Khohoi chîn rang ni le nikhuo lupuitak ni han Jisua ândinga, rôl inringtakin, “Tukhom a tui ânrâl kai chu ko kôm hong senla ngeia, nêk rese ngei, male ");
INSERT INTO sch_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Pathien lekhabu'n ati anghan, tukhom mi iem kai chu a sûng renga ‘Ringna-pêk’ tuinârngei luong suok atih,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Mahi Jisua'n ama iem ngeiin Ratha an chang rang chungroi a misîrna ani. Ma zora han Ratha pêk la nimaka; Jisua ha roiinpuia kaithoi ala ni loi sikin. ");
INSERT INTO sch_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Mingei lâia senkhatin ha chong hah an rietin chu, “Hi mi hih Dêipu tatak kêng ani ngihi!” an tia. ");
INSERT INTO sch_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Adangngeiin chu, “Ama hih Messiah kêng ani!” an tia. Hannirese adangngeiin chu, “Messiah chu Galilee ram renga hong suok no nih! an tia. ");
INSERT INTO sch_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Pathien lekhabu'n ati anghan Messiah chu Rêng David jâisuon renga nîng a ta, David omna khopui Bethlehema a suok rang ani,” an tia. ");
INSERT INTO sch_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Masikin Jisua sikin mipuingei lâia insenna aom zoia. ");
INSERT INTO sch_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mi senkhatin sûr rang an bôka, aniatachu tutên a chunga an kut musum mak ngei. ");
INSERT INTO sch_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Mi rungpungei ha an hong kîr nôka, Ochaisingei le Phariseengei han an kôm, “Ithomo nin hong tuong loi?” tiin an rekel ngeia. ");
INSERT INTO sch_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Mi rungpungei han an thuona, “Hipa anga thurchi misîr reng la om ngâi mak ngei!” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Phariseengeiin an kôm, “Nangni khom huongin nin om sa mo ni zoi?” tiin an rekel ngeia. ");
INSERT INTO sch_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“Rachamneipungei le Phariseengei lâia mi inkhat luon ama an iem zoi ti nin riet mo? ");
INSERT INTO sch_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Hi mipuingei hih Moses Balam riet mak ngei, masikin Pathien khomâksâmna nuoia om kêng an ni!” ");
INSERT INTO sch_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Phariseengei lâia mi inkhat Nicodemus, motona Jisua intongpui ranga sêpu ha a oma. Ama'n midangngei kôm, ");
INSERT INTO sch_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ei Balam dungjûiin chu tukhom a chongbâi suok ei riet mân le a sintho ei mu mân chu theiloi minchang thei ngâi mak me,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","“Asa,” anni ngei han a kôm, “Nang khom Galilee ram renga hong mo ni ni? Pathien Lekhabungei pore inla dêipu Galilee ram renga hong suok ngâi mak ti riet ni tih,” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Hanchu mitinin an ina an sea, aniatachu, Jisua chu Olive tânga a sea. ");
INSERT INTO sch_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Anangtûk jînga ânmânin Biekina a se nôka. Mipuingei murdi a kôm an hôn tûpa; ânsunga anni ngei ha a minchu ngei phut zoia. ");
INSERT INTO sch_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Balam minchupungei le Phariseengei han nupangnu ânrê lâitaka an sûrnu hah an hong tuonga, male an rênga an moton han amanu hah an mindinga. ");
INSERT INTO sch_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jisua kôm, “Minchupu, hi nupangnu hih ânrê lâitaka kin sûr ani. ");
INSERT INTO sch_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ei Balamin Moses chongpêk angin chu hi nupangu hih lung leh dêng that ngêt rang ani. Atûn hin, nangman kho angin mo ni ti?” an tia. ");
INSERT INTO sch_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ma hah ama min ôkna ranga an ti ani, demna an man theina rangin. Aniatachu Jisua ân kûna, a kutruol leh pil a mizieka. ");
INSERT INTO sch_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ma anga indingin chong an rekel anghan ânthoi lita, male an kôm, “Nin lâia nunsie tho loitakin motontaka lung leh amanu hah dêng bak roi,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Hanchu ân kûn nôka, a kutruol leh pil a miziek nôka. ");
INSERT INTO sch_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","A chong hah an rietin chu, a ulien dônin inkhat inkhatin, an rot riei zoia. Jisua hah athenin an mâk raka, nupangnu hah ma muna a lân ding chien lehan. ");
INSERT INTO sch_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jisua hah a hôn dinga, nupangnu kôm han, “Khonmo an om suo zoi? Tutên theiloi nang mintum rang om khâi mak ngei na?” a tia. ");
INSERT INTO sch_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Amanu han a thuona, “Pu, tutên theiloi mi mintum mak ngei,” a tia. Jisua'n a kôm, “Asa, nônchu, kei khom theiloi nang mintum uol mu-ung. Se roh, hannirese nunsie tho nôk khâi no roh,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jisua'n Phariseengei kôm a chong nôka. “Keima hi rammuol vâr ki ni,” a tia. “Tukhom mi jûi murdi chu ringna vâr dôn an ta, ijînga lôn tet no ni ngei.” ");
INSERT INTO sch_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Phariseengeiin a kôm, “Atûn hin nu thurchi nanâk kêng ni misîr; nu thurchi misîr dik mak,” an tia. ");
INSERT INTO sch_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","“Nimak,” Jisua'n an kôm, “Ku thurchi nanâk misîr khom ronga, ki misîr hih adik kêng. Keima chu kho renga mo ku juong le kho tieng mo ke se rang khom ki riet. Nangni chu kho renga mo ku juong aninônchu, kho tieng mo ke se rang riet mak chei. ");
INSERT INTO sch_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nangnin chu taksa balam angtakin roi nin tan ngâia; keiman chu tu roi te tan ngâi mu-ung. ");
INSERT INTO sch_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ke lei tanna khom om senla, ko roi tanna chu dik atih; asikchu ke theivaia om ni mu unga; Pa mi tîrpu ko kôm a om sikin. ");
INSERT INTO sch_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nin Balam lekhabua khom rietpuipu inik an inruola, imo an ti tak chu adik, tiin miziekin aom ani. ");
INSERT INTO sch_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Keiman ku thurchi nanâk ki misîra, male Pa mi tîrpu khomin ku thurchi a misîr sa ngâi,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Anni ngei han, “Khomo na Pa?” tiin ama an rekela., “Nangnin mi riet mak choia, ka Pa khom riet uol mak chei. Mi nin riet nisenla chu ka Pa khom riet nin ti zoi,” tiin Jisua'n a thuon ngeia. ");
INSERT INTO sch_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jisua'n hi ngei murdi hih Biekina chôiruol dôngna an darna mun khâltan sûnga a minchu lâia a ti ani. Tutên ama hah sûr mak ngei azora ala tung loi sikin. ");
INSERT INTO sch_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisua'n an kôm, “Ke sepat rang kêng ani zoi; nangnin mi rok nin ta chu, nin sietnangei han thîng nin tih. Ke sena ranga se thei no tunui,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Masikin Juda rachamneipungeiin, “Ke sena ranga se thei no tunui a ti hih amananâkin inthat rang a tina mini?” an tia. ");
INSERT INTO sch_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jisua'n a thuon ngeia, “Nangni chu hi rammuola mi nin ni. Kei chu chung tieng renga juong ki ni. Nangni chu hi rammuol renga nin ni, hannirese kei chu hi rammuol renga ni mu-ung. ");
INSERT INTO sch_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Masika han nin sietnangei han thîng nin tih, tiin nangni ki ril ani. Male ‘Keima hih tumo Ki ni’ mi nin iem nônchu nin sietnangei han thi lelê nin tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Anni ngei han, “Tumo ni ni?” tiin an rekela. Jisua'n, “Aphut renga nangni ki ril ani. ");
INSERT INTO sch_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nin chungroia hin misîr rang tamtak, nangni demna rang tamtak ko dôn. I-ih khomnirese, mi tîrpu chu mi diktak ani, ama renga ki riet kai ke rammuola ki ril ngâi ani.” ");
INSERT INTO sch_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jisua'n an kôm, Pa chungroi kêng a misîr ani ti riet thei mak ngeia. ");
INSERT INTO sch_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Masikin an kôm, “Miriem Nâipasal hih nin makhâi tika ‘Ama hah Keima ki ni’; ti le keima ka rachamin ite tho mu unga, Pa'n mi minchu kai ke ki misîr ani tiin riet sa nin tih. ");
INSERT INTO sch_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Male mi tîrpu chu ko kôm a oma; ke thenin mi mâkrak maka, a lungdo ki sin bang ngâi sikin,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jisua'n thurchi a misîr ngei hah mi tamtakin an rieta, ama an iem zoi. ");
INSERT INTO sch_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Masikin Jisua'n ama iem Judangei kôm han, “Ki minchuna nin jômin chu ku ruoisi diktak ngei nin ni rang; ");
INSERT INTO sch_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","chongtak riet nin ta, chongtak han nangni mojôk atih,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Anni ngei han, “Abraham richisuonpârngei kêng kin ni, tute suoka la om mak me. ‘Suok renga nangni mojôk atih,’ ni ti hih khoi tina mini?” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jisua'n an kôm, “Chongdiktak nangni ki ril: tukhom nunsie tho chu nunsie suok ani. ");
INSERT INTO sch_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Suok chu insûngmi ni tit ngâi mak, aniatachu Nâipasal chu kumtuongin a om ngâi. ");
INSERT INTO sch_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nâipasalin suok nangni a mojôk vaiin kêng nin jôk tatak rang. ");
INSERT INTO sch_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Abraham richisuonpârngei nin ni ti ki riet. Hannoma nangnin ma that rangin nin pût ani, ki minchuna chong nin pom loi sikin. ");
INSERT INTO sch_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Keiman ki misîr hih ka Pa mi min mu ani, nangni khom nin pa ngei nangni an ril anghan nin misîr ngâi.” ");
INSERT INTO sch_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Anni ngei han, “Kin pa chu Abraham ani,” tiin an thuona. Jisua'n an kôm, “Abraham nâi diktak ngei nin ni nisenla chu a lei tho ngâi anghan nin tho rang ani,” tiin chong a mele ngeia. ");
INSERT INTO sch_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","“Ki sin lei tho ngei murdi chu Pathien renga chongdik ki riet ngei nangni ril hih ani, aniatachu atûn hin ma that rangin nin pût chien ani. Abraham'n chu ma anghin tho ngâi mak! ");
INSERT INTO sch_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nangni chu nin pa ngei lei tho ngâi anghan nin tho ani,” a tia. Anni ngei han, “Pathien vai kêng kin Pa dôn chu, keini hih a nâi diktak ngei kin ni,” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jisua'n an kôm, “Pathien nin Pa ani tatakin chu, mi nin lungkham rang ania; Pathien renga juong ki ni sikin atûn hin nin lâia ko om ani. Keima rachama juong ni mu unga, ama tîr kêng ki ni, a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ithomo ki misîr hih nin riet thei tet loi? Ku thurchi misîr hih nin mulungrîla nin mindon loi sika ani. ");
INSERT INTO sch_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nin pa Diabol nâingei nin ni, male nin pa lungdo jûi nin nuom ani. Ama chu aphut renga mi that ngâi ani, male chongdik tieng khom inchel ngâi mak, dikna reng a dôn loi sikin. Milak a tho tikin ama lungdoa a tho ani ngâi, milakpa ani sikin, milak ngei murdi pa khom ani sa. ");
INSERT INTO sch_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Hannirese keima chu chongtak kêng ki misîr ngâi, masika han nin iem ngâi loi ani. ");
INSERT INTO sch_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nin lâia tumo sietna tienga theiloi mi min chang thei rang? Chongtak ki misîr khomin ithomo nin iem loi? ");
INSERT INTO sch_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tukhom Pathien renga juong chu Pathien chong a pom ngâia. Nikhomrese nangni chu Pathien renga nin ni loi sikin, a chong khom nin rangâi loi ani.” ");
INSERT INTO sch_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Anni ngei han a kôm, “Nangma hih Samari mi male ramkhori no dôn kin ti hah dik mak mo?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jisua'n an kôm, “Ramkhori dôn mu-ung. Ka Pa ki mirita, aniatachu, nangnin mi nin êsêl ani hi. ");
INSERT INTO sch_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Keima rang nanâk miritna rok ni mu unga. Aniatachu, a rokpu le ku ruthûla a jêkpu mi inkhat a om kêng. ");
INSERT INTO sch_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Chongtak nangni ki ril ani: tukhom ko chong jômpu chu thi tet no nih.” ");
INSERT INTO sch_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Anni ngei han a kôm, “Ramkhori no dôn khet tiin kin riet minthâr zoi! Abraham a thi zoia, dêipungei khom an thi suozoi, hannoma nangman chu ‘Ko chong jômpu chu thi tet no ni,’ ni tia, an tipe. ");
INSERT INTO sch_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Kin Pa Abraham nêkin ni lien uol mo? Ama khom a thi zoi; dêipungei khom an thi suozoi. A tutak hamo ani angin nên bê?” an tia. ");
INSERT INTO sch_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jisua'n an kôm, “Keima nanâkin miritna a rok ninlang, ha miritna hah chu ite ni no ni. Kin Pathien nin ti, ka Pa hah mirita mi min ompu chu ani, tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nangnin chu ama hah riet tet mak chei, keiman chu ki riet ani. Ama riet mu-ung ki tiin chu nangni angin milak ki ni rang ani. Hannirese, ama ki rieta a chong khom ko jôm ngâi. ");
INSERT INTO sch_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nin pa Abraham'n ku juong a mu rang sikin a râiasân oka, ma anghan a mu tataka, a râiasân sabak ani.” ");
INSERT INTO sch_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Anni ngei han a kôm, “Kum sômrangnga luo la kâi mak che ngah, Abraham nu mu na?” an tia. ");
INSERT INTO sch_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jisua'n an kôm, “Chongdik kêng nangni ki ril,” tiin a thuon ngeia, “Abraham ân zir mân khom, ‘Keima’ chu ko om zoi.” ");
INSERT INTO sch_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Hanchu a dêngna rang lung an rûta, hannirese Jisua ân thupa, Biekin renga a jôkpai zoi. ");
INSERT INTO sch_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jisua a lôn lâitakin, asuok renga mitcho pasal inkhat a mua. ");
INSERT INTO sch_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","A ruoisingeiin a kôm, “Minchupu, hi mi hih tu sietna sika mitchoa ânzir mo? Ama sietna sika mo, a nulepangei sietnangei sika mo?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jisua'n an kôm, “Hi pa mitchona hih a sietnangei sika aninônchu a nulepangei sietnangei sika khom ni uol mak. Pathien sinthotheina ranakrât a chunga mu theia aomna ranga ani. ");
INSERT INTO sch_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Sûn ani lâi hin, mi tîrpu sin ei tho rang ania; jân ajîng rang kêng ani zoi, ma tikin chu tutên sin tho thei khâi no ni ngei. ");
INSERT INTO sch_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Rammuola ko om kâr chu rammuol minvârpu ki ni,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ma hah a ti suole chu, Jisua'n pil a michila, a michil leh han dielnâng a sinna; dielnâng hah a mit ngeia a pol pea, ");
INSERT INTO sch_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","male a kôm, “Sênla, Siloam dîla na mâi va phia roh,” a tia. (Siloam riming aomtie chu “Tîr” tina ani.) Ma anghan ha mi hah a sea, a mâi a va phia, a mit avârin a hong kîr nôk zoi ani. ");
INSERT INTO sch_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Hanchu a bungmingei le a kutdo lâi a lei mu ngâi ngei han, “Hi mi hih ânsunga a kutdo ngâipu ha nimak mo?” an tia. ");
INSERT INTO sch_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Mi senkhatin chu, “Hi mi hih ani,” an tia, aniatachu adangngeiin chu, “Hi mi hih nimak; ânphuopui kêng ani,” an tia. Masikin amananâkin, “Ha mi hah ki ni,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Anni ngei han, “Kho angin mo ni mit ahong vâr nôk?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ama han, “Mi inkhat Jisua an ti pu han dielnâng a sina, ki mita a pola, male Siloam dîla sênla, na mâi va phia roh a tia. Ma anghan ke sea, ka mâi ka va phia suo renghan chu ku mu thei kelen ani,” tiin a thuon ngeia. ");
INSERT INTO sch_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“Ama hah khonmo aom?” tiin an rekela. Ama han, “Riet mu-ung” tiin a thuon ngeia. ");
INSERT INTO sch_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Hanchu mitcho lei ni pu ha Phariseengei kôm an tuonga. ");
INSERT INTO sch_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jisua'n dielnâng a sina a mit jîng a mindam pe ni ha Sabbathni ani. ");
INSERT INTO sch_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Phariseengeiin a mit hong vâr pe nôk chang ha an rekel nôka. Ama han, “Ki mita dielnâng a pola, ka mâi ka va phia male atûn chu ko hong mu thei zoi ani,” tiin a ril ngeia. ");
INSERT INTO sch_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Pharisee senkhatin chu, “Hi sin thopu hih Pathien renga juong ni thei no ni, Sabbathni Balam a jôm loi sikin,” an tia. Senkhat nôkin chu, “Kho angin mo mi nunsien, hi anga sininkhêlngei hih a sin thei ranga?” an tia. Male an lâia insenna aom zoi. ");
INSERT INTO sch_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Masikin Phariseengeiin ha mi hah vêlkhat an rekel nôka, “Ki mitcho mi minvâr pe, ni tia, asa, nangman te kho angin mo ama chungroi hih ani ni ti?” Ama han, “Dêipu ani,” tiin a thuon ngeia. ");
INSERT INTO sch_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","I-ih khomnirese Juda rachamneipungei han ha mi hah mitchôn ân zira, atûn chu a mu thei zoi ani ti iem thei mak ngei sikin a nulepangei an koia, ");
INSERT INTO sch_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","male an kôm, “Hi mi hih nin nâipasal mo? Asuok renga a mitcho nin ti pu ha mo ani hi; kho angin mo atûn hin a hong mu thei nôk hi?” tiin an rekel ngeia. ");
INSERT INTO sch_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","A nulepangei han, “Hi mi hih kin nâipasal ani, asuok renga a mitcho ani ti khom kin riet. ");
INSERT INTO sch_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Aniatachu kho angin mo a mit ahong vâr pe, le tumo a mindam pe chu riet mak me. Ama rekel roi; ulien kêng ani zoi, male amananâkin thuon rese!” ");
INSERT INTO sch_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","A nulepangei han Juda rachamneipungei an chi sikin ma anghan an ti ani. Tukhomin Jisua ha Messiah ani tiin an iema anîn chu Synagog renga notpai rang tiin an lei inruol sai ani. ");
INSERT INTO sch_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Masika han kêng a nulepangei, “Ulien ke ani zoi, ama rekel roi!” an tina ani. ");
INSERT INTO sch_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Mitchopa hah a voiniknân an koi nôka, male a kôm, “Pathien makunga chongdik ril rangin chonginkhâm roh! Nang mindampu hah mi nunsie ani tiin kin riet zoi,” an tia. ");
INSERT INTO sch_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ama han an kôm, “Mi nunsie ani mo niloi mo ite riet mu unga. Ki riet chu mitcho ki nia, atûn chu ku mu thei zoi,” tiin a thuon ngeia. ");
INSERT INTO sch_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Anni ngei han, “Khoimo nang a tho pe? Kho angin mo ni mitcho a mindam?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ama han an kôm, “Michin khom nangni ki ril zoi. Ithomo a riet nin nuom nôka? Nangni khom a ruoisingei chang nin nuom mini?” tiin a thuon ngeia. ");
INSERT INTO sch_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Anni ngei han khomâk an sâma, “Nangma hih ama ruoisi ni ni, keini chu Moses ruoisingei kêng kin ni, an tia. ");
INSERT INTO sch_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Moses kôm Pathien a lei chong ti kin riet; i-ih khomnirse hi mi rang hih chu kho renga hong mo ani khom riet mak me!” an tia. ");
INSERT INTO sch_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ha mi han, “Ma tak hah neinun kamâm aomna! Nangni chu kho renga mo ani khom riet mak chei, aniatachu ki mitjîng mi minvâr pe ani! tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Pathien'n mi nunsiengei chong rangâi ngâi mak ti ei rieta; ama jâ ngei le a lungdo sin ngei chong chu a rangâi ngâi. ");
INSERT INTO sch_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Rammuol insieng phut renga tutên mitcho saia suok a mit a minvâr pe ti la riet ngâi mak me. ");
INSERT INTO sch_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Hi mi hih Pathien renga juong ni no rese chu hi anga sin hih tho thei no nih.” ");
INSERT INTO sch_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Anni ngei han, “Nangma nunsie'a ânzir le hong lien hin mi minchu rang no bôk mo?” tiin an thuona. Male ama hah Synagog renga an notpai zoi. ");
INSERT INTO sch_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jisua'n ha mi hah notpai ani zoi, ti a rietin chu ava roka, a kôm, “Miriem Nâipasal hih ni iem mo?” tiin a rekela. ");
INSERT INTO sch_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ama han, “Pu, tumo ani ni ril roh, ki iem theina rangin!” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jisua'n a kôm, “Ama hah nu mu sai kêng, male atûna nang chongpuipa hih ama hah ani,” a tipea. ");
INSERT INTO sch_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ha mi han, “Pumapa, ki iem!” a tia, male Jisua kebula khûk ân bila. ");
INSERT INTO sch_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jisua'n, “Hi rammuola hin roijêk ranga juong ki ni, masikin mitcho ngei an mit a vârna rang le mitvâr ngei an mitchona rangin,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Phariseengei senkhat a kôla om ngei han ma chong hah an rieta male a kôm, “Adiktakin keini khom hi mitcho kin ni sa ni tina nimak mo?” tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jisua'n an kôm, “Mitcho nin ni nisenla chu theiloina dôn no tu nui; hannirese kin mu thei nin ti sikin nin theiloina ala om bang ani.” tiin a thuon ngei. ");
INSERT INTO sch_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jisua'n a tia, “Chongdik tak nangni ki ril: mi tukhom belrirukul kotbâia lût loia lam dang tienga kala lût chu inru le râtlâksong ani. ");
INSERT INTO sch_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Mi tukhom kotbâi tieng renga lût chu belrihôlpu ani. ");
INSERT INTO sch_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kotbâi ngâkpu han kotbâi a mo-ong pea; belringeiin a rôl an rieta, a belringei chu an riming chitin a koia, a ruoi ngei ngâi. ");
INSERT INTO sch_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","A kaisuo ngei suole chu ama moton ânsa pe ngeia, male a rôl an riet sikin, belringeiin a nûk an jûi ngâi. ");
INSERT INTO sch_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Midang chu tute jûi no ni ngei; a rôl an riet loi sikin, jûi nêkin tân pe pat an tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisua'n hi chongmintêk hi a misîr pe ngeia, hannirese imo a tina riet mak ngei. ");
INSERT INTO sch_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Masikin Jisua'n a ti nôka, “Chongdiktak nangni ki ril: Keima hi belringei ranga kotbâi ki ni. ");
INSERT INTO sch_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ko motona lei juong ngei murdi chu inru ngei le râtlâksong ngei an nia, belringei khomin an chong rangâi ngâi mak ngei. ");
INSERT INTO sch_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Keima hih kotbâi ki ni. Tukhom keima taka lût chu sanminringin om an tih; asûnga lût an ta, jôk an ta, sûlring man sâng an tih. ");
INSERT INTO sch_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Inru chu muruk rang, that rang le sietminmang rang vaiin kêng an hong ngâi. Kei chu ringna nin dôna ranga ringna akipdira nin dôna ranga juong ki ni. ");
INSERT INTO sch_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Keima hi belrihôlpu sa, a belringei ta ranga a ringna phal nuom ki ni. ");
INSERT INTO sch_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Inlo mi, belrihôlpu dikloi le belringei khom ata aniloi sikin, melang hong a mûn chu belringei a mâkraka male a tân pata; masikin melangin belringei a peta, chek a minchâinek ngâi. ");
INSERT INTO sch_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Inlo mi han a tân pata asikchu ama hah inlo mi le belringei rangin lunghâng a dôn loi sikin. ");
INSERT INTO sch_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Keima hi belrihôlpu sa ki ni. Pa'n mi riet anghan kei khom Pa ki rieta, ma-angdên han ke belringei chu ki rieta anni ngei khomin min riet ani. An ta ranga thi khom hih ku nuom ani. ");
INSERT INTO sch_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Hi belrirukula la om loi belri dang khom ka la dôn sa. Mangei ha khom la hongtuong sa ka ta, anni ngei han ke he rangâi an ta, male belri pâlkhat la hongni an tih, belrihôlpu inkhat lehan. ");
INSERT INTO sch_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Man nôk ranga ki ringna pêk rang ku nuom sikin, Pa'n mi lungkham ngâi ani. ");
INSERT INTO sch_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Tutên ki ringna hi mi lâk pe thei noni ngei. Keima rachamin kêng ke pêk rang ani. A pêk thei ki nia, male a lâk nôk thei khom ki ni. Mahi kêng tho rangin ka Pa'n chong mi pêk ani.” ");
INSERT INTO sch_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Hi chongngei sika hin mipuingei lâia insenna aom nôk zoi. ");
INSERT INTO sch_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Mi tamtakin, “Ramkhori sûr! Achâng kêng! Ithomo a chong nin rangâi pea?” an tia. ");
INSERT INTO sch_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Aniatachu adangngeiin chu, “Ramkhori sûr chu ma anghin chong thei no nih! Kho angin mo ramkhorin mi mitcho amin vâr pe thei ranga?” an tia. ");
INSERT INTO sch_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ma zora hah phalbi lâi ania, Biekin ranga Inpêklet khohoi Jerusalema an mang lâitak ani. ");
INSERT INTO sch_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jisua chu Solomon bokropa han a vân lôi a hôn lôia, ");
INSERT INTO sch_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","mingei ha a kôla an hôn tûpa, “Idôr sôt mo mulung okchân mi ni dar rang? Ânthârtakin mi ril roh: Messiah mo ni ni?” an tia. ");
INSERT INTO sch_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jisua'n a thuona, “Nangni ki ril zoi duo, aniatachu mi iem mak chei. Ka Pa rachamneinân a sin ko tho hin ku ruthûlin nangni a min riet ania; ");
INSERT INTO sch_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","hannirese iem no tunui, ke belringei nin ni loi sikin. ");
INSERT INTO sch_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ke belringeiin chu ko rôl an riet ngâi; kei khomin ki riet ngei, male annin min jûi ngâi. ");
INSERT INTO sch_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","An kôm kumtuong ringna ke pêk ngeia, male anni ngei hah thi tet khâi no ni ngei. Tutên keima renga mi sut thei no ni ngei. ");
INSERT INTO sch_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Anni ngei ni pêkpu ka Pa hah neinunngei murdi nêkin ânlal uol ani, male tutên Pa donsûina renga mi sut thei no ni ngei. ");
INSERT INTO sch_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Pa le keima chu inkhat kin ni.” ");
INSERT INTO sch_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Hanchu mingeiin ama dêngna rang lung an rût nôka. ");
INSERT INTO sch_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jisua'n an kôm, “Pa'n sin ranga mi pêk sin sa tamtak nin mitmua ki sin zoia, akhotak sika ha mo lung leh ni dêng rang nin bôkna reng hi?” a tia. ");
INSERT INTO sch_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Anni ngei han, “Sin sa sikin lung leh nang dêng rang nuom mak mea, aniatachu Pathien riming ni rilminsiet! sikin le miriem ni ni ngonga Pathien'n nên bê sikin ani,” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jisua'n a thuona, “Nin Balam lekhabua Pathien'n a tia, ‘pathienngei nin ni,’ tiin ânziek nimak mo. ");
INSERT INTO sch_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ei riet anghan Pathien lekhabua ati kai chu tuonsôtin adik ngâi ania; male Pathien'n a chong a min tungna ngeia khom han pathienngei a ti ani. ");
INSERT INTO sch_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Keima rang chu Pa'n mi thanga rammuola mi juongtîr ani. Nônte, kho angin mo Pathien Nâipasal ki ni ki ti sika hin Pathien ni rilminsiet mi nin ti hi? ");
INSERT INTO sch_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ka Pa'n sin ranga mi nuom neinunngei ha ki sin ani nônchu mi iem no roi. ");
INSERT INTO sch_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Hannirese ki sin anîn chu keima mi nin iem no khomin, ki sinthongei luo hi iem roi bah, Pa keima kôm a om male keima Pa kôm ko om ti nin riet minthâr theina rangin,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jisua sûr rang an pût nôkrêka, aniatachu an kut renga a jôkpai pe ngeia. ");
INSERT INTO sch_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Hanchu Jisua hah Jordan Tuidung râla motona John'n mi a baptisna ngâi mun tieng han a sea, male mahan a om zoi. ");
INSERT INTO sch_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mi tamtak a kôm an honga. “John'n ite sininkhêlngei sin mak,” aniatachu, “Hipa chungroi a lei misîr murdi chu adik ani,” an tia. ");
INSERT INTO sch_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Male mahan mi tamtakin ama an iem zoi. ");
INSERT INTO sch_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mi inkhat a riming Lazarus, Bethany khopuia om hah damloiin a oma. Bethany hah Mary le a zuorpuinu Martha ngei omna khopui ani. ");
INSERT INTO sch_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Hi Mary hih Pumapa kea mirimhoi buoka male a sam leh a ke hûi pe nu hah ani, damloia om Lazarus hah a nuchapa ani.) ");
INSERT INTO sch_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","A sarnungeiin Jisua kôm, “Pumapa, na malpa lungkham hih dam mak,” tiin chong an muthuona. ");
INSERT INTO sch_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jisua'n maha a riet lehan, “Hi Lazarus natna hih thina rang nimaka; Pathien roiinpuina ranga ania, hi sika hin Pathien Nâipasal khom roiinpuiin ala om rang ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisua'n Martha le a zuorpuinu le Lazarus ngei hah a lungkham ngei tataka. ");
INSERT INTO sch_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Hannoma damloi thurchi hah a riet suo nûkin a omna mun han sûnnik ala om nôka. ");
INSERT INTO sch_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Hanchu a ruoisingei kôm, “Judea rama se nôk ei ti u zoi,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","A ruoisingeiin a kôm, “Minchupu, nikhatni renghan mingeiin lung leh nang dêng rang an tia, hannoma la se nôk rêk rang ni mintuo mini?” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jisua'n a tia, “Sûnkhatin konta sômleinik aom nimak mo?” Masikin tukhomin sûn khovâra an lônin chu invâi ngâi mak ngeia, hi rammuol vâr hih an mu sikin. ");
INSERT INTO sch_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Aniatachu, jân jînghamin an lônin chu an invâi ngâi, vâr an dôn loi sikin. ");
INSERT INTO sch_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jisua'n hi chong hih a tia, hanchu a bôksa nôka, “Ei malpa Lazarus chu a in zoi, hannirese ama kaithoi rangin ke se rang ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ruoisingeiin, “Pumapa, a in anînchu, hong dam nôk atih zoi,” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jisua'n chu Lazarus a thi zoi a tina ani. aniatachu, annîn chu in ngâi balama a in mini tiin an bôka. ");
INSERT INTO sch_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Masikin Jisua'n ânthârin a ril ngeia, “Lazarus a thi zoi, ");
INSERT INTO sch_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","hannirese a kôm ko om loi ha nangni rang sikin ka râiasân ani, nin iem theina rangin. Tho a kôm se ei tih u zoi.” ");
INSERT INTO sch_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Thomas (Ânphîr an ti) han a champui ruoisingei kôm, “Tho Minchupu kôm ei rêngin se sa ei ta, ama leh ei thi theina rangin!” a tia. ");
INSERT INTO sch_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jisua a hongtungin chu, Lazarus ha sûn minli moton han an phûm zoi ti a rieta. ");
INSERT INTO sch_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bethany hah Jerusalem renga kilometer inthum nêka nâi uol ani, ");
INSERT INTO sch_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","male Judangei mi tamtakin Mary le Martha ngei an nuchapa thi chungroia mathâi rangin an honga. ");
INSERT INTO sch_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Martha'n Jisua a hong ti a rietin chu ama intongpui rangin a jôka, aniatachu Mary chu insûnga a lei oma. ");
INSERT INTO sch_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martha'n Jisua kôm, “Pumapa, hin no om nisenla chu ku nuchapa hi thi no nih! ");
INSERT INTO sch_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Aniatachu atûn khom Pathien kôm no zong kai chu nang pêk a tih, ti ki riet,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jisua'n a kôm, “Nu nuchapa inthoinôk atih,” tiin a rila. ");
INSERT INTO sch_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Amanu han, “Sûn nûktaka chu inthoi nôk a tih, ti ki riet,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jisua'n amanu kôm han, “Keima hi inthoinôkna le ringna ki ni. Tukhom mi iem kai chu thi khomsenla ngei ring an tih; ");
INSERT INTO sch_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","male tukhom a ringa keima mi iem chu thi tet no ni ngei. Ma hih ni iem mo?” a tia. ");
INSERT INTO sch_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Amanu han a kôm, “Ani, Pumapa!” ki iem. “Nangma hih Messiah, Pathien Nâipasal, rammuola juong rangpu ha ni ni ti ki iem tatak,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Martha'n hi chong hih a ti suole chu a zuorpuinu Mary a theia om hah inrûktên ava koia. “Minchupu hin a oma, nang a koi,” tiin a rila. ");
INSERT INTO sch_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Hi chong hih Mary a rietin chu innottakin ânthoia, ama leh intong rangin a sea. ");
INSERT INTO sch_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Jisua ha khuo sûnga la hongtung maka. Martha leh an intongna muna han a la om.) ");
INSERT INTO sch_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Insûnga Mary mathâi ranga ompui mipuingei han Mary innotin ânthoia, a jôk an mûn chu thânna chap rangin a se mini tiin an mindona, an jûi zoi. ");
INSERT INTO sch_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mary hah Jisua omna a hongtunga, ava mu renghan a ke bula an bokraka. “Pumapa,” hin, “no om nisenla chu ku nuchapa hi thi no nih!” a tia. ");
INSERT INTO sch_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jisua'n Mary chap le a hong jûi mipuingei chap ha a mun chu asân a mulung a jûrpuia, a rîl tieng ân nûkka. ");
INSERT INTO sch_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Ama hah khonmo nin phûm?” tiin a rekel ngeia. “Pumapa, hong inla hong en roh,” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jisua a chap zoi. ");
INSERT INTO sch_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Mipuingei han, “En ta u, idôrtaka a lungkham mini na!” an tia. ");
INSERT INTO sch_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Aniatachu senkhatin, “Mitchopa ha mitvârna a pêk nimak mo? Lazarus khom hi thi loiin a dar thei loi mini?” an tia. ");
INSERT INTO sch_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jisua ha arîl tieng ânnuk nôka, thâna a sea, thân khur ha ânpûk, lung leh alûtna hah an hîp ani. ");
INSERT INTO sch_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jisua'n, “Lung hi thînpai roi!” tiin a dânde ngeia. Martha, a thipa sarnu han, “Pumapa, a mirim asie rang kêng ani zoi, an phûmna sûn minli piel ani zoi!” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jisua'n amanu kôm han, “Ni iemin chu Pathien roiinpuina mu ni tih, nang ki ti nimak mo?” a tia. ");
INSERT INTO sch_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Lung hah an thînpai zoia. Jisua a tanga, “Pa, ko chong na rangâi sikin ka râiasân. ");
INSERT INTO sch_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ko chong na rangâi bang ngâi ti ki riet, hannirese mahi chu hi taka om mipuingei hin nangma mi ni tîr ki ni, ti an iem theina rangin nang ki ti ani.” ");
INSERT INTO sch_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ma ha a ti suole chu, rôl inringtakin a koisama, “Lazarus hong jôk roh!” a tia. ");
INSERT INTO sch_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ama hah a kutngei le kengei thân puonngeiin intuomchienin, a mâi khom puon leh intuomchienin a hong jôk zoia. Jisua'n an kôm, “Sût ungla, male min se roi,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mi tamtak Mary hong pan ngei han, Jisua sintho hah an mua, male ama an iem kelen zoi. ");
INSERT INTO sch_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Aniatachu, mi senkhatin chu an kîr nôka, Phariseengei kôm Jisua sintho hah an va misîr pe ngeia. ");
INSERT INTO sch_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Masikin Phariseengei le ochaisingei, roijêkpungei leh an intonga, “Imo ei tho rang ani zoi? Hipa hin sininkhêl a sin ngei hih en ta u! ");
INSERT INTO sch_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Hima anghin ei min se bangin laka mitinin hong iem an ta, hanchu Roman rachamneipungei juong an ta, ei Biekin le ei jât le nam min juong sietminmang pe rang kêng!” an tia. ");
INSERT INTO sch_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","An lâia mi inkhat, a riming Caiaphas hah, ma kuma Ochai Inlaltak han an kôm, “Nin mo babâka! ");
INSERT INTO sch_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mi murdi thia, jât le nam pumpui ânmang nêkin chu mi inkhat thi hah asa uol ti nin riet loi mini?” a tia. ");
INSERT INTO sch_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Adikin, chu ama thena mulungbôka a ti nimaka; ha kuma Ochai Inlaltak ani sikin Jisua hah Juda mipuingei ruthûla a thi rang hah a lei ril masa ani. ");
INSERT INTO sch_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","male anni rang vai niloiin, Pathien mi chekinchâia om ngei pâl khata a molom theina rangin khom ani sa. ");
INSERT INTO sch_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Hani renga chu Juda rachamneipungeiin Jisua an that rang chang an mintuo bang ani. ");
INSERT INTO sch_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Masikin Jisua khom ânlangin chu Judea rama lêng khâi maka, ramchâr kôla khopui inkhat a riming Ephraim an tia han a sea, a ruoisingei leh an va om zoi. ");
INSERT INTO sch_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Kalkân Kût anâi zoi sikin mi tamtakin ram sûng pumpui renga inthieng-inthâr rangin khohoi phâk mân Jerusalema an sea. ");
INSERT INTO sch_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jisua an rok titira, Biekina an intûp lâiin inkhat le khat annin rekela, “Imo nin mindon? Khohoia hong tatak no ni mo, a hong rang mo?” ");
INSERT INTO sch_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ochaisingei le Phariseengeiin ama an sûr theina rangin tukhomin a omna an rietin chu an misîr ngêt rang ani tiin chong an pêk ngei zoi ani. ");
INSERT INTO sch_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Kalkân kût rang sûnruk motona Jisua chu thina renga a kaithoi Lazarus omna Bethany khuoa a sea. ");
INSERT INTO sch_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ama rangin kholoibu nêk rang an mintuo pea, Martha hah bu-an, semin a san ngeia, Lazarus chu dosânga Jisua bukhalâi otpui ngei lâia inkhat ani. ");
INSERT INTO sch_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Hanchu Mary'n nard sariek mirimhoi man luttak liter in-ang a hong chôia, Jisua ke a buoka, a sam leh a ke a hûi pea. Ha sariek mirimhoi han insûng pumpui asip zit zoi. ");
INSERT INTO sch_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jisua ruoisingei lâia inkhat Judas Iscariot, ama a minsûr rangpu han, ");
INSERT INTO sch_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Hi sariek mirimhoi hih ithomo duli razanthumin juorin male inrieng ngei kôm a pêk loi?” a tia. ");
INSERT INTO sch_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Hi chong hih inrieng ngei rang lunghâng ân shak sika a ti nimaka, inru ani sika ani. Ha mi han sumkok a chôia asûnga sum hah ama rangin a lâk ngâi sikin ani. ");
INSERT INTO sch_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Aniatachu, Jisua'n a kôm, “Rokôk no roh! a dôn hih phûma ko om nia rangin rê rese. ");
INSERT INTO sch_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Inrieng ngei chu nin kôma om tit rang an ni, kei chu nin kôm om bang no ning,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Mi tamtakin Bethany khuoa Jisua a om ti an rietin chu Jisua mu rangin le Lazarus Jisua'n thina renga a kaithoi nôkpu mu sa rangin an sea. ");
INSERT INTO sch_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Hanchu Ochaisingei han Lazarus khom that sa rangin an bôka, ");
INSERT INTO sch_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ama sika Juda tamtakin anni ngei hengin Jisua an iem zoi sikin. ");
INSERT INTO sch_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Anangtûka chu Kalkân kût khohoia hong loko tamtakin Jisua Jerusalema a hong ti an rieta. ");
INSERT INTO sch_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Masikin letûmbuongei an chôia ama lamdon rangin an sea, “Hosanna! Pumapa riminga juongpu chu Pathien'n satvur rese! Pathien'n Israel Rêngpa satvur rese!” tiin an inieka. ");
INSERT INTO sch_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jisua'n sakuording inkhat a mua, a chunga a chuonga, Pathien Lekhabu'n ati anghan, ");
INSERT INTO sch_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Chi no roh, Zion khopuilien! Ne Rêng hah sakuordingte, chunga chuongin a hong ani.” ");
INSERT INTO sch_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ha chong hah aphut han chu a ruoisingeiin riet thei mak ngeia; aniatachu Jisua inlaltakin inthoiin a om suo tena chu Pathien Lekhabu'n ama chungroi a lei miziek ani ti le a chunga ha anga han an lei tho ti an riet zoi. ");
INSERT INTO sch_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jisua'n Lazarus thân renga a koi suoka, thina renga a kaithoi lâia mipui om ngei han a thurchi an misîr tir zoia. ");
INSERT INTO sch_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ha sininkhêl hah an riet sikin mipui ngeiin an lei don ani. ");
INSERT INTO sch_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Hanchu Phariseengei han, “En ta u, ite chang khâi mak me! En roi, rammuol pumpuiin ama kêng an jûi zoi hi!” an tia. ");
INSERT INTO sch_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Khohoia Pathien chubaimûk ranga Jerusalema hong se ngei lâia han Greekngei senkhat an oma. ");
INSERT INTO sch_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Anni ngei han Philip (Galilee rama Bethsaida khuo mi) kôm an sea, “Pu, Jisua mu kin nuom,” tiin an ngêna. ");
INSERT INTO sch_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Philip a sea male Andrew ava rila, male anruonin an sea, Jisua an va rila. ");
INSERT INTO sch_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jisua'n an kôm, “Miriem Nâipasal inlaltaka a om zora atung zoi. ");
INSERT INTO sch_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Chongdiktak nangni ki ril: buhûm pila a tâka athi nônchu aramalin aom chien ngâi, athin vai kêng tamtakin ânra ngâi. ");
INSERT INTO sch_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Tukhom an ringna moroi kaiin machân an ta, tukhom rammuola an ringna min pâm loi kaiin kumtuong ringna dôn tit an tih. ");
INSERT INTO sch_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tukhom ki sintho nuom kaiin chu mi jûi ngêt rese ngei, masikin ki sinthopu ngei chu ko omna an om sa theina rangin. Tukhom ki sintho ngâi kai chu ka Pa'n mirit tho ngei atih. ");
INSERT INTO sch_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Atûn hin ku mulung akâng male imo ki ti rang ani zoi? ‘Pa, hi zora hih ku chunga mi mintung pe no roh ki ti rang mini’? Aniatachu, hi dûktuong rang piela juong ki ni, masika han hi dûktuongna zora hih palin ke se rang ani. ");
INSERT INTO sch_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Pa, ni riming roiinpuina juong mintung roh!” a tia. Hanchu invân renga rôl ajuon ringa, “Ko roiinpuina ku juong mintung zoi, la juong mintung nôk ki tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Lokongei a kôla ânding ngei han ma rôl hah an rieta, male an lâia senkhatin, khuonri kêng ani an tia, adangngeiin chu, “Vântîrtonin a chongpui kêng!” an tia. ");
INSERT INTO sch_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Aniatachu Jisua'n an kôm, “Ma rôl ha keima ranga ajuon ring nimaka, nangni ngei rang kêng ani. ");
INSERT INTO sch_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Atûn hin hi rammuol roijêkin aom rang zora ani zoi; hi rammuol roijêkpu khom hi atûn, pai nîng atih. ");
INSERT INTO sch_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Pilchung renga makhâiin ko om tikin chu mi murdi ki tieng kaikuoi ki tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Hi chong hih thina a tuong rangtie riet theina ranga a ti ani.) ");
INSERT INTO sch_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mipuingeiin a kôm, “Kin Balam lekhabu'n Messiah chu tuonsôtin ring tit atih” tiin mi ril ngâi. Hanchu, kho angin mo nangman, “Miriem Nâipasal hi târin om atih, ni ti thei? Hi Miriem Nâipasal hih tumo ani?” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jisua'n a thuona, “Vâr hi chomolte chu nin lâia la om nîng atih. Vâr nin dôn lâiin lêng roi, masika han ijîngin nangni adê loina rangin; tukhom ijînga a lônin chu a sena riet ngâi mak. ");
INSERT INTO sch_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Vâr nin dôn lâihin vâr hi iem ta roi, avâr mingei nin ni theina rangin,” a tia. Jisua'n hi chong hih a ti suole chu a thengpata, an mu thei loina ranga a vânthup zoi. ");
INSERT INTO sch_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","An mitmua sininkhêlngei tamtak a sin suonûk khomin anni ngei han ama iem mak ngeia, ");
INSERT INTO sch_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","masikin dêipu Isaiah lei ti hah ahong tung adik theina rangin: “Pumapa, kin thurchi misîr tumo a iema? Tu chunga mo Pumapa'n arnak a minlang?” ");
INSERT INTO sch_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Male masika hi an iem thei loi ani, Isaiah nanâkin a tia: ");
INSERT INTO sch_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Pathien'n an mit a mincho pe ngeia male an mulungbôkngei khom a min môl pe ngei sa, masikin an mitin an mu loina rang, le an mulungbôkngei khomin an rietthei loina rangin, male ko kôm an hônhei nôk duoia, ke lei mindam ngei theina rangin, Pathien'n a tia.” ");
INSERT INTO sch_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiah han Jisua roiinpuina a mu le a thurchi a misîr sikin hi chong hih a ti ani. ");
INSERT INTO sch_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nikhomsenla Juda rachamneipu tamtak ngeiin Jisua an iem zoia; hannirese Phariseengei sikin misîr minlang ngam mak ngeia, ma anghan ani nônchu synagog renga khâipaiin an om rang ani. ");
INSERT INTO sch_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Pathien pomna nêkin munisi pomna an min lut uol ani. ");
INSERT INTO sch_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jisua'n rôl inringtakin a tia, “Tukhom mi iempu chu keima mi iem vai niloiin mi tîrpu khom a iem sa ani. ");
INSERT INTO sch_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Tukhom keima mi mu chu mi tîrpu khom a mu sa ani. ");
INSERT INTO sch_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Rammuola hin vâr angin ku juong ani, masikin tukhom mi iem ngei murdi chu ijînga an om loina rangin. ");
INSERT INTO sch_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Tukhom ku thurchi misîr a rieta a jôm loi khom nisenla, keiman an roijêk no ning. Rammuol roijêk ranga juong ni mu unga, rammuol sanminring ranga juong kêng ki ni. ");
INSERT INTO sch_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Tukhom keima me henga, ku thurchi misîr pomloi ngei chu anni ngei roijêk rangin mi inkhat aom. Ku thurchi misîr ha sûn nûktaka chu anni ngei roijêkpu la ning atih! ");
INSERT INTO sch_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mahi adik ani, asikchu Keima ka rachamin ite misîr ngâi mu unga, ka Pa mi tîrpu'n kêng ki ti rang le ki misîr rang chong mi pêk ngâi ani. ");
INSERT INTO sch_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Male a chongpêk ngei chu kumtuong ringna ani ti ki riet. Masikin ki ti ngei hi Pa'n mi ril lam angtakin ki misîr ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Kalkân kût khohoi rang ni motontet ahong ni zoia. Jisua'n hi rammuol hih mâkin Pa kôm a se rang zora atung zoi ti a rieta. Ama ta ngei lelê, hi rammuola om, a lungkham ngâi ngei hah among ni dênin a lungkham ngei tita. ");
INSERT INTO sch_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jisua le a ruoisingei jânbu an nêk han. Diabol'n Simon Iscariot nâipasal Judas mulungrîla Jisua minsûr rangin mindonna a lei dar chien zoia. ");
INSERT INTO sch_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisua hah, Pa'n rachamneina murdi a pêk, ti le Pathien renga juong ania, Pathien kôm se nôk rang ani ti a rieta. ");
INSERT INTO sch_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Masikin bukhalâi otna dosâng kung renga ânthoia, a chunghak kâncholi a kheka, male inhûinapuon a lâka, a kong a khita. ");
INSERT INTO sch_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Hanchu dabôra tui a sunga, ruoisingei kengei a rusûk phut zoia, a konga puon lehan a hûi pe ngeia. ");
INSERT INTO sch_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simon Peter kôm a honga, ama han, “Pumapa nangman ke kengei nursûk rang mo?” a tia. ");
INSERT INTO sch_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jisua'n a kôm, “Ki sintho hi atûn chu la riet mak che, hannirese nangkana chu la riet ni tih,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peter'n a kôm, “Nangman chu khotiklâi khom ka kengei rusûk tet no ti nih!” a tia. Jisua'n a kôm, “Ne kengei kursûk nônchu ku ruoisi ni khâi no tinih,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Peter'n a kôm, “Pumapa, nônchu ke kengei vai rusûk nônla, ku kutngei le ku lu khom rusûk sa roh!” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jisua'n a tia, “Tukhom tui ânbuol sai chu asâi zoi ani, a kengei tilloiin chu adang arsûk rang nâng khâi maka. Nin lâia mi inkhat tiloiin chu nin rêngin nin sâivar zoi.” ");
INSERT INTO sch_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Jisua'n a minsûr rangpu ha a riet chien sai ani; sikin, “Nin lâia mi inkhat, tiloiin chu, nin rêngin nin sâivar zoi,” a ti ani) ");
INSERT INTO sch_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jisua'n an kengei arsûk suole chu a chunghak kâncholi a haka male a mun nanâka dosâng tieng a kîr nôka. “Nin chunga ki sintho hih nin riet thei mo?” tiin a rekel ngeia. ");
INSERT INTO sch_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Nangnin Minchupu le Pumapa mi nin tia, nin ti mindik ani, asikchu ni khom ki ni tatak ani. ");
INSERT INTO sch_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Keima, nin Pumapa le Minchupu'n luo nin kengei ku rusûk ani, Ma anghan, nangni khom nin kengei nin rusûk inlôm rang ani. ");
INSERT INTO sch_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nin chunga ko tho anghin nangni khomin nin tho theina rangin nangni ki min mu ani. ");
INSERT INTO sch_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Chongdiktak nangni ki ril: suokngei hih an pu nêkin lien mak ngeia, thangtheipungei khom a tîrpu nêkin lien mak ngei. ");
INSERT INTO sch_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Atûn chu ma chongdik hah nin riet zoi, nin jômin chu nin râisân tatak atih! ");
INSERT INTO sch_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Nin renga nin thurchi misîr mu-ung, ka thang ngei chu keiman ki riet. Hannirese Pathien Lekhabu'n, ‘Ku bu nêkpu han mi doi zoi,’ a ti ha ahong dik ngêt anâng ani. ");
INSERT INTO sch_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Masikin mahi atûn ahongtung mân nangni ke lei ril ani, ahongtung tika khom ‘Ama ha Keima hi Ki Ni,’ tiin mi nin iem theina rangin. ");
INSERT INTO sch_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Chongdiktak nangni ki ril: tukhom ki mi tîr lei pom chu keima khom mi pom sa ania; male tukhom mi pom chu mi tîrpu khom a pom ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisua'n ma chong hah a ti suole chu a mulung dûk a min tonga, “Chongdiktak nangni ki ril: nin lâia mi inkhatin mi minsûr atih,” tiin ânlangiemin a phuonga. ");
INSERT INTO sch_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ruoisingei han tu lelê mo a tina tak an riet loi sikin jâminzal takin annîn en inlôma. ");
INSERT INTO sch_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ruoisingei lâia mi inkhat Jisua'n a lungkham ngâipu hah Jisua kôla ânsunga. ");
INSERT INTO sch_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Hapa kôm han Simon Peter'n, “Tutak mo a ti, rekel ta,” tiin kut leh tônin a chongpuia. ");
INSERT INTO sch_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Masikin ama ha Jisua tieng ân thîna, “Pumapa, tu lelê mo ani?” tiin a rekela. ");
INSERT INTO sch_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jisua'n a kôm, “Vâipôl hârte michie ka ta, ke pêk tak hah ning atih,” tiin a thuona. Masikin vâipôl hârte a lâka, a michie-a, Simon Iscariot nâipasal Judas kôm a pêk zoi. ");
INSERT INTO sch_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas'n vâipôl hârte ha a lâk suo, harenghan a sûnga han Soitan alût kelen zoi. Jisua'n a kôm, “No tho rang tak hih tholai roh!” a tipea. ");
INSERT INTO sch_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Dosâng rihîla om adangngei han tutên ithomo ma anghan Jisua'n a tipe riet mak ngei. ");
INSERT INTO sch_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ruoisingei senkhatin chu Judas han sum a kol sikin, Jisua'n khohoia mang rang neinun ânsam rochôk roh a tipe mini, aninônchu inrieng ngei imini pêk roh a tipe mini tiin an bôka. ");
INSERT INTO sch_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas han vâipôl hâr hah a lâka, a rotpat kelen zoi, ma zora hah jân ani. ");
INSERT INTO sch_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas a rotpat suole chu Jisua'n an kôm a tia, “Atûn chu Miriem Nâipasal roiinpuina ânlang zoia, ama sikin Pathien roiinpuina khom ânlang zoi ani. ");
INSERT INTO sch_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Male ama renga Pathien roiinpuina ânlangin chu, Pathien khomin ama renga han Miriem Nâipasal roiipuina minlang atih, male ama'n voikhat rengin tho kelen atih. ");
INSERT INTO sch_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ka nâingei, nin lâia zora sôt om khâi no ning. Mi en nin ta; aniatachu Juda rachamneipungei ki tipe ngei anghan nangni ki tipe ani, ‘Ke sena ranga se thei no tunui.’ ");
INSERT INTO sch_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Male atûn hin chongpêk athar nangni ke pêk ani: inkhat le inkhat inlungkham inlôm roi. Nangni ku lungkham anghan nin inlungkham ngêt rang ani. ");
INSERT INTO sch_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Inkhat le inkhat nin inlungkham inlômin chu ku ruoisingei nin ni tiin mi murdi'n riet an tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Peter'n, “Pumapa, khotieng mo ne se rang?” tiin a rekela. “Ke sena ranga atûn chu mi la jûi thei no tunui,” aniatachu, “nakana chu mi la jûi nin tih,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peter'n, “Pumapa, ithomo atûn hin chu nang ku jûi thei loi rang?” tiin a rekela, “Nangma rang sikin chu ki ringna khom pêk ki tih!” a tia. ");
INSERT INTO sch_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jisua'n a kôm, “Keima rang sikin ni ringna ne pêk tatak rang na? Chongdiktak nang ki ril: ârkhuong mân voithum, ama hih riet ngâi mu-ung, ni ti rang ani,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jisua'n, “Nin kângmindoi no ungla male nin jâminzal no roi, Pathien iem roi male kei khom mi iem sa roi. ");
INSERT INTO sch_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ka Pa ina omna khâltan tamtak aom, ninta rangin mun sin ke se rang ani. Om no senla chu nangni ki ril loi rang ani. ");
INSERT INTO sch_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Male ninta rang mun ko hong sin suole chu juongkîr nôk ka ta, ko kôm nangni tuong ki tih, ko omna nangni khom nin om sa theina rangin. ");
INSERT INTO sch_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ke sena rang lampui khom nin riet.” ");
INSERT INTO sch_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thomas'n a kôm, “Pumapa, ne sena rang riet mak me; masikin kho angin mo mataka sena rang lampui ha kin riet ranga?” a tia. ");
INSERT INTO sch_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jisua'n a thuona, “Keima hi lampui, chongtak le ringna ki ni; keima taka se loi chu tute Pa kôm tung ngâi mak ngei. ");
INSERT INTO sch_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Atûn chu mi nin riet zoi,” a tipe ngeia, “Ka Pa khom nin riet sa rang ani zoi, male atûn renga chu ama nin riet zoia male mu khom nin mu sa zoi ani.” ");
INSERT INTO sch_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philip'n a kôm, “Pumapa, Pa hah keini mi min mu ta; kinta rangin chu hun atih,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jisua'n a thuona, “Philip, hi dôr sôt hih nin kôm ko oma; hannoma mi la riet mak che mo? Tukhom mi mu chu Pa a mu ani. Hanchu, ithomo, ‘Pa hah keini mi min mu ta ni tia’? ");
INSERT INTO sch_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Keima Pa kôm ko oma male Pa khom ko kôm aom hih ni iem loi mini? Nin kôma chong ki ti ngei hah keima renga hong suok nimak,” Pa, ko kôma omtit ngâipu han a sin a tho kêng ani. Jisua'n a ruoisingei kôm a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Keima Pa kôm ko oma, Pa ko kôm aom ki ti hin mi iem roi. Ani nônchu, ki sintho ngei sik luo hin mi iem roi. ");
INSERT INTO sch_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Chongdiktak nangni ki ril: tukhom mi iem ngei chu ki sintho anghin la sin an tih; ani, hima nêka neinun roiinpui uol ngei khom la sin an tih, Pa kôm ke se rang ani sikin. ");
INSERT INTO sch_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Male khokhoi khom ki riminga nin zong kai chu sin ki tih, Nâipasal sika Pa roiinpuina ânlang theina rangin. ");
INSERT INTO sch_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nangnin ki rimingin i-ikhom mi nin zong kai chu tho ki tih. ");
INSERT INTO sch_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Nangnin mi nin lungkhamin chu ko chongpêkngei jôm nin tih. ");
INSERT INTO sch_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Pa kôm zong ka ta, ama'n Sanpu dang nangni pêk atih; tuonsôta nin kôma om rangin. ");
INSERT INTO sch_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ama ha Ratha diktak, Pathien chongtak minlang ngâipu ani. Rammuolin chu modôm thei maka, ama an mu thei loi sik le an riet thei loi sikin. Aniatachu nangni ngeiin chu nin riet, nin kôm a om bang sik le nangnia aom bang ngâi sikin. ");
INSERT INTO sch_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Ke se khomin nin theivaiin nangni mâk no ninga; nin kôm juong kîr nôk ki tih. ");
INSERT INTO sch_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Chomolte suole chu rammuolin mi mu khâi no ni; hannirese nangnin chu mi mu nin ta, keima ki ring sikin nangni khom ring sa nin tih. ");
INSERT INTO sch_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ma nikhuo hah ahong tungin chu, nangni nin kôm ko om anghan keima ka Pa kôm ko oma, nangni ko kôm nin om tiin riet nin tih zoi. ");
INSERT INTO sch_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Tukhom ko chongpêkngei a poma jôm chu mi lungkham ani. Tukhom mi lungkham kai chu ka Pa khomin lungkham atih; kei khomin lungkham ngei ka ta, an kôm inlâr bang ngâi ki tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas (Judas Iscariot niloi) han a kôm, “Pumapa, kin kôm chu inlâr na ta, ithomo rammuol kôm chu nên lâr loi rang?” a tia. ");
INSERT INTO sch_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jisua'n a kôm, “Tukhom mi lungkham ngeiin chu ki minchuna jôm an tih. Ka Pa khomin lungkham ngei a ta, male ka Pa leh an kôm juong kin ta, an kôm om kin tih. ");
INSERT INTO sch_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Tukhom mi lungkham loi ngei chu ki minchuna khom jôm ngâi mak ngei. Male minchuna chong nin riet hi keima kata nimaka, Pa, mi tîrpu renga kêng ani.” ");
INSERT INTO sch_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nin kôm ka la om lâihin hi chong hih nangni ki tipe ani. ");
INSERT INTO sch_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Sanpu, Ratha Inthieng, Pa'n ki riminga a juongtîr rang han neinunngei murdi nangni minchu a ta, male nangni ki misîr pe sai ngei murdi hah riettit rangin nangni sin a tih.” ");
INSERT INTO sch_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Nangni ka mâkpe chu Rathânngamna hi ania; keima rathânngamna kêng nangni ke pêk ani. Rammuolin a pêk anghan chu nangni pêk mu-ung. Nin kângmindoi no ungla, male nin jâmminzal no roi; chi khom chi no roi. ");
INSERT INTO sch_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‘Nangni mâksan rang ki ni, ti nin rieta, aniatachu nin kôm juong kîr nôk ki tih,’ mi nin lungkhama anîn chu Pa kôm ke se hih nin râisân atih; ama chu keima nêkin a roiinpui uol sikin. ");
INSERT INTO sch_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Hi chong hih ahongtung mân nangni ke lei ril ani, ahongtung tika nin iem theina rangin. ");
INSERT INTO sch_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Zora sôt chu nangni chongpui thei khâi no ning, hi rammuola roijêkpu hih a hong zoi sikin. Ku chunga racham dôn maka, ");
INSERT INTO sch_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","hannirese Pa ku lungkham ti hih rammuolin a riet ngêt anâng ani; masikin ama chongpêkngei anghan neinuntin ki sin ngâi.” “Hong roi, hi mun renga hin jôk ta rei u.” ");
INSERT INTO sch_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Keima graprâng diktak ki ni, male ka Pa chu ruhuon donsûipu ani. ");
INSERT INTO sch_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Keima taka kop loi amachang ânra loi chu a khiekpaia, ânra kai chu a rithiel minsâi ngâi; masikin ânthienga amara atam uolna rangin. ");
INSERT INTO sch_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Minchuna chong nangni ke pêk saia hin nin inthiengvar zoi ani. ");
INSERT INTO sch_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ko kôm omtit ungla, male kei khom nin kôm omtit ki tih. Amachang hah graperânga akop tit nônchu athenin inra thei maka; graperânga akop tit vaiin kêng ânra thei ngâi. Ma anghan nangni khom ko kôm nin omtit nônchu nin thenin inra thei no tunui.” ");
INSERT INTO sch_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Keima graprâng ki nia, nangni ngei ha amachangngei nin ni. Tukhom keima taka aomtita, male kei khom ama taka ko omtitna chu tamtakin an inra ngâi; keima boiin ite nin sin thei loi sikin. ");
INSERT INTO sch_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Tukhom keima taka om loi chu amachang angin paiin aoma, male achâr ngâi; ma anga amachangngei hah chu an rokhôma meia an paia, akâng ngâi. ");
INSERT INTO sch_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ko kôm nin omtita, ko chong nin kôm aomtitin chu nin nunuom zong roi man bang nin tih. ");
INSERT INTO sch_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Tamtaka nin inra hin ka Pa roiinpuina inlangin aom ngâi ani; ma anghan ku ruoisingei nin hong ni ani. ");
INSERT INTO sch_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Pa'n mi lungkham anghan kei khom nangni ku lungkham ani; ku lungkhamna hin omtit roi. ");
INSERT INTO sch_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ko chongpêkngei nin jômin chu ku lungkhamna ombang nin tih, ka Pa chongpêkngei ko jôma a lungkhamnân ko ombang anghin. ");
INSERT INTO sch_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Ka râisâna nangnia han aom theina rang le nin râisâna akip theina rangin mahi nin kôm ki misîr ani. ");
INSERT INTO sch_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ko chongpêk chu mahi ani: inkhat le inkhat inlungkham inlôm roi, keiman nangni ku lungkham anghin. ");
INSERT INTO sch_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Miriemin a malngei ranga lungkhamna lientak a dôn thei chu an ta ranga a ringna pêk hi ani. ");
INSERT INTO sch_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Male ko chongpêk nin jômin chu ka malngei nin ni. ");
INSERT INTO sch_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Tîrlâmngei nangni ti khâi no ning, asikchu tîrlâmngei chu an pu sintho riet ngâi mak ngei ani. Manêkin chu malngei nangni ti ki tih, Pa renga ki riet ngei murdi nangni ki misîr pe zoi sikin. ");
INSERT INTO sch_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nangnin ni thang mak choia; keiman kêng nangni ka thang ania; sea mara tamtak va dôna, nin mara aom bang rangin nangni ku phun sa ani. Masikin ki riminga Pa kôm nin zong kai chu nangni a pêk theina rangin. ");
INSERT INTO sch_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Hanchu, mahi ko chongpêk chu ani: inkhat le inkhat inlungkham inlôm roi. ");
INSERT INTO sch_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Rammuolin nangni mumâkin chu, keima mi lei mumâk bak ani ti riettit roi. ");
INSERT INTO sch_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Rammuol ta ni ungla chu rammuolin ama ta angin nangni lungkham rang ani. Aniatachu rammuol renga nangni ka thangsuok ania, rammuol mi nin ni khâi loi sikin rammuolin nangni a mumâk ani. ");
INSERT INTO sch_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","‘Suokngei chu an pu nêkin lien uol mak ngei’ ti chong nangni ki ril hah riettit roi. Mingeiin keima an nuom minlôn chu nangni khom an nunuom nangni lô sa an tih; ki minchuna chong an donin chu nin minchuna chong khom don an tih. ");
INSERT INTO sch_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Hannirese hima ngei murdi hah kata nin ni sika kêng nin chunga an tho rang; tumo mi tîrpu hah an riet loi sikin. ");
INSERT INTO sch_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Keima juongin an kôm thurchi misîr no rong chu sietnân theiloi an chang loi rang piel ani; atûn chu an sietna muduolna rang dôn khâi mak ngei. ");
INSERT INTO sch_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Tukhom mi mumâkpu chu ka Pa khom a mumâk ani. ");
INSERT INTO sch_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mi dangin an la tho ngâiloi neinunngei hah an lâia tho no ronga chu sietna sikin theiloi an chang loi rang piel ania; atûn chu ki sintho ngei an mua, male keima le ka Pa kin ruonin min mumâk zoi ani. ");
INSERT INTO sch_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nikhomrese, mahi, an Balam lekhabua anni ngei han, ‘Ite abi boiin min mumâk,’ tia ânziek hah inzomin ahongtung adik theina ranga an tho ani. ");
INSERT INTO sch_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Sanpu hah juong a ta, Ratha diktak Pathien chungroia chongtak minlangpu hah Pa kôm renga juong atih. Pa kôm renga nin kôm juongtîr ka ta, male ama'n ku chungroi misîr atih. ");
INSERT INTO sch_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Male nangni, khomin ku chungroi misîr sâng nin tih, aphut renga keima leh nin om sikin. ");
INSERT INTO sch_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Nin taksônna nin mâk loina rangin mahi nangni ki misîr pe ani. ");
INSERT INTO sch_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Synagogngei renga nangni la khâipai an ta, nangni that ranga bôk ngei han Pathien sin an tho anga an inbe zora la tung atih. ");
INSERT INTO sch_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Mingeiin nin chunga hima anghan la thông an tih, Pa le keima min riet loi sikin. ");
INSERT INTO sch_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Hannirese mahi nin kôm ke lei misîr ani, masikin ma neinunngei tho ranga an zora ahong tung tikin, nangni ke lei misîr pe zoi ti nin riettit theina rangin. “Hi neinunngei hih aphut renga nangni ka la ril loi ani, nin kôma ka la om sikin. ");
INSERT INTO sch_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Aniatachu, atûn chu mi tîrpu kôm ke se rang kêng ani zoi, hannoma nin lâia tutên ke sena rang merkel mak chei. ");
INSERT INTO sch_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Male atûn nangni ki misîr pe lechu nin mulungngei dûkin asip zoi ani. ");
INSERT INTO sch_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Aniatachu chongdiktak nangni ki ril: ke se hah nangni rangin chu asa uol ani, ke se nônchu Sanpu hah nin kôm juong no nih. Hannirese ke sên chu ama hah nin kôm juongtîr ki tih. ");
INSERT INTO sch_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Male a juong tung tika chu sietna tieng mo, chong dika mo, Pathien roijêkna tieng mo theiloi an chang tie hah rammuol mingei kôm min mûng atih. ");
INSERT INTO sch_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Sietna tieng theiloi an chang ani, keima min iem loi sikin; ");
INSERT INTO sch_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","chong dika khom theiloi an chang ani, Pa kôm ke se rang sik le mi nin mu khâi loi rang sikin; ");
INSERT INTO sch_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","male roijêkna tieng khom adikloi an chang ani, hi rammuol roijêkpu khom jêkin aom zoi sikin. ");
INSERT INTO sch_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Nangni misîr pe rang tamtak ka la dôn, aniatachu atûna rangin chu ariet nangni lântak pe rai atih. ");
INSERT INTO sch_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nikhomrese, Ratha, Pathien chongtak minlang ngâipu hah a juong tika chu chongtak ngei murdia nangni ruoi min lût atih. Ama rachamin ite misîr no nia, a riet ha kêng a misîr rang male ahong tung rang neinunngei ha nangni ril atih. ");
INSERT INTO sch_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ama han roiinpuina mi pêk atih, ko chong ti ngei hah lâk a ta, nangni a ril rang sikin. ");
INSERT INTO sch_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ka Pa'n a dôn ngei murdi chu kata ani; masika han kêng Ratha han ke pêk hah lâk a ta male nangni ril atih, ki ti ani. ");
INSERT INTO sch_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Chomoltên chu mi mu khâi no tunuia, male chomolte suole chu mi mu nôk nin tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","A ruoisingei senkhatin anninanâkin annin rekela, “Ei kôma a thurchi misîr hi imo a tina? Chomolte chu mi mu no tunuia, chomolte suole chu mi mu nôk nin tih; a tia male, ‘Pa kôm ke se rang sikin’ khom a ti hi, an tia. ");
INSERT INTO sch_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","‘Chomolte’ a ti hih imo a tina? A misîr hih ei riet thei loi kêng!” an tia. ");
INSERT INTO sch_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jisua'n ama chong rekel rang an jôt ti a rieta, an kôm, “Chomolte chu mi mu no tunuia, chomolte suole chu mi mu nôk nin tih,” ki ti ha mo nangni nanâkin ni nin rekel inlôm? ");
INSERT INTO sch_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Chong diktak nangni ki ril: nangni chu chap le inrûmin om nin ta, hannirese, rammuol chu tâi atih; inngûiin om nin ta, aniatachu nin inngûina hah tâinân ânthûl rang ani. ");
INSERT INTO sch_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nupangin nâiha a tuong lâitak chu ân ngûikhak ngâi, a dûktongna zora ahong tung pe sikin; aniatachu nâi a nei suole chu a dûktong hah a mingil nôk ngâi, nâite rammuola juong suok hah a râisânpui sikin. ");
INSERT INTO sch_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nangni khom ma anghan nin ni: atûn chu inngûiin nin oma, aniatachu nangni mu nôk ki tih, nin mulungrîl râisânnân la sip atih. Ma râisânna ha chu tutên nangni sut thei khâi no ni ngei. ");
INSERT INTO sch_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Ma nikhuo hah ahong tungin chu ite mi rekel khâi no tunui. Chongdiktak nangni ki ril: ki riminga nin zong kai chu Pa'n nangni pêk atih. ");
INSERT INTO sch_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Atûn tena chu ite ki rimingin la zong mak choia; zong ungla man nin tih, nin râisânna akip theina rangin. ");
INSERT INTO sch_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ha neinunngei hah mintêknangei chongin nin kôm ki misîr ani. Aniatachu, mintêknangei chong mang loiin ânlangiemin Pa chungroi ha nin kôm ki misîr zora ala hong tung rang. ");
INSERT INTO sch_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ma nikhuo hah ahong tungin chu, ki rimingin Pa kôm zong nin ta; male keiman Pa kôm nin ruthûlin nangni zong pe ki tih ki tina nimaka, ");
INSERT INTO sch_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Pa lelê han nangni a lungkham ngâi. Keima mi nin lungkham sik le Pathien renga juong ki ni, ti mi nin iem sikin nangni a lungkham ngâi ani. ");
INSERT INTO sch_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Pa kôm renga ku juonga, male rammuola ku juong ani; male atûn chu rammuol mâkin Pa kôm ke se nôk rang ani zoi,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Hanchu a ruoisingei han a kôm, “Atûn chu ânlangiemin ni misîra, mintêknangei chong reng mang khâi mak chea. ");
INSERT INTO sch_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Atûn chu neinuntin ni riet let tiin kin riet zoi; tute kôm ite ne rekel ngei rang nâng mak che. Hima sika hin Pathien renga juong ni ni tiin kin iem zoi ani,” an tia. ");
INSERT INTO sch_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jisua'n an kôm, “Atûn chu nin iem mo zoi? ");
INSERT INTO sch_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Azora ahong tungtir zoi, anâikik zoi, matikin chu chekinchâi var nin ta, nin in, nin ina se nin ta, ke theivaiin mi mâkrak nin tih. Hannirese Pa hah ko kôm aom sikin ke theivaiin chu ni no ning. ");
INSERT INTO sch_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Masikin keima leh inpumkhata omin rathânngamna nin dôn theina rangin hi chong hih nangni ki misîr pe ani. Rammuolin intak nangni min tuong atih. Hannirese hâitakin om roi! Keiman rammuol ke mene zoi ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisua'n ma chong hih a ti suole chu invân tieng a tanga, “Pa, azora atung zoi. Na nâipasal kôm roiinpuina pêk ta roh. Nâipasal khomin roiinpuina nang a pêk theina rangin. ");
INSERT INTO sch_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Mingei murdi chunga rachamneina ama ne pêka, masikin ama khomin ne pêk ngei kôm kumtuong ringna a pêk ngei theina rangin. ");
INSERT INTO sch_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Male kumtuong ringna ti chu, nangma Pathien diktak vai nang riet, le ni tîrpu, Jisua Khrista riet hih ani. ");
INSERT INTO sch_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","No roiinpuina pilchunga ki minlanga; sintum mi ni pêk khom ki sin suozoi ani. ");
INSERT INTO sch_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Pa! atûn no kôm ngêt han roiinpuina ni pêk roh, rammuol insieng mâna no kôma roiinpuina ko dôn ngâi dên ha. ");
INSERT INTO sch_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Rammuol renga mi ni pêk ngei kôm ni riming ku phuong minzar zoi. Anni ngei hah nata an nia, male nangman kêng anni ngei ha mi ni pêka, no chong an don zoia, ");
INSERT INTO sch_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","male atûn chu neinun mi ni pêk ngei murdi hih nangma renga ani ti an riet zoi. ");
INSERT INTO sch_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nangman chong mi ni pêk ngei khom ke pêk ngeia an pom zoia; no kôm renga juong ki ni khom an riet minthâr zoi, male mi ni tîr ani ti khom an iem zoi ani. ");
INSERT INTO sch_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Anni rang piela chubaitho ki ni. Rammuol rangin chubaitho mu unga, nangma nata, keima mi ni pêk ngei ta ranga ani. ");
INSERT INTO sch_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ko dôn ngei murdi nata an nia; no dôn ngei murdi khom kata an nia, male ko roiinpuina khom anni renga ânlang ngâi ani. ");
INSERT INTO sch_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Atûn chu no kôm ko hong rang ani zoia; rammuola om khâi noning, aniatachu anni ngei chu rammuola la om an tih. Pa Inthieng! anni ngei hi ni riming sinthotheinân sanmojôk ngei roh, riming mi ni pêk lehan, masikin keima le nangma pumkhat eini anghan anni ngei khom pumkhat anni theina rangin. ");
INSERT INTO sch_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","An kôm ko om sûngin chu ni riming sinthotheinân ka sanmojôk ngei ngâi, riming mi ni pêk lehan. Ku rung ngeia, inkhat luo inmang mak ngei, ânmang rang piela ompu tiloiin chu Pathien lekhabua ânziek ahong tung adik theina rang sikin. ");
INSERT INTO sch_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Atûn chu no kôm ko hong rang ani zoia, male rammuola hi neinunngei hih ki misîr pe ngeia ka râisânna an mulung sûngngeia akipdira aom theina rangin. ");
INSERT INTO sch_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","No chongbê ke pêk ngeia, male rammuolin a mumâk ngei zoia, rammuol mi an ni khâiloi sikin, keima rammuol mi ki ni loi anghan. ");
INSERT INTO sch_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Rammuol renga lâk pai ngei rangin nang zong mu unga, Asaloi Inkhat renga sanmojôk ngei rangin nang ke ngên ani. ");
INSERT INTO sch_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Keima rammuol mi ki ni loi anghin anni khom rammuol mi nimak ngei. ");
INSERT INTO sch_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Anni ngei hih chongtakin minthâr ngei roh; no chong chu chongtak ani. ");
INSERT INTO sch_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Rammuola mi ni tîr anghan, kei khomin anni ngei hih rammuola ki tîr ngei ani. ");
INSERT INTO sch_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Anni sikin no kôm kên thâra, anni ngei khom no kôm, adiktaka an inthâr theina rangin. ");
INSERT INTO sch_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Hi ngei rang vaiin nang ngên mu unga, an thurchi misîr sika mi a iem ngei ta rang khomin nang ke ngên sa ani. ");
INSERT INTO sch_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","An rêngin pumkhat anni theina rangin nang ke ngên ani. Pa! Anni ngei hih ei kôm om rese ngei, nangma ko kôm no oma, keima khom no kôm ko om anghan. Pumkhatin om rese ngei, rammuolin mi ni tîr, ti an iem theina rangin. ");
INSERT INTO sch_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Roiinpuina mi ni pêk dên hah anni khom ke pêk ngei ani, nangma le keima pumkhat ei ni anghan pumkhat an ni theina rangin. ");
INSERT INTO sch_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Keima, an kôma, nangma ko kôma omin an nin pumkhat tatakna rangin, hanchu mi ni tîr ani ti hih rammuolin riet an ta, male mi ni lungkham anghan anni ngei khom nu lungkham ngei tiin riet an tih. ");
INSERT INTO sch_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Pa! anni ngei hih mi ni pêka, male ko omna an om sa theina rangin ku nuom ani, mi ni lungkham sika rammuol insieng mâna mi ni pêk roiinpuina hah an mu theina rangin. ");
INSERT INTO sch_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Pa Diktak! rammuolin nang riet maka, hannirese keiman chu nang ki riet, male hi ngei khomin mi ni tîr ani tiin an riet. ");
INSERT INTO sch_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","An kôm nang ki min riet ngeia, min riet ngei bang ki tih, mi ni lungkhamna hah an kôm aom theina rangin, male kei khom an kôm ko om sa theina rangin,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jisua'n hi chubaithona hih a ti suole chu, a ruoisingei le Kidron Tuitedung rakânin an sea. Ma muna han ruhuon aoma, male Jisua le a ruoisingei asûnga an lûta. ");
INSERT INTO sch_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","A minsûrpu Judas han hima mun hah a rieta, vêl tamtak Jisua le a ruoisingei, ha muna han an intûp ngâi sikin. ");
INSERT INTO sch_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Masikin Judas han Roman râlmingei pâl leh, male Ochaisingei le Phariseengeiin an tîr, Temple rungpungei senkhat tuongin ma ruhuona han râlrovongei, châtingei le meiserngei chôiin an sea. ");
INSERT INTO sch_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","A chunga ahong tung rang neinunngei murdi hah Jisua'n a lei riet sai piel ani sikin moton tieng a hong nâia, “Tumo nin rok?” tiin a rekel ngeia. ");
INSERT INTO sch_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","“Nazareth Jisua,” tiin an thuona. “Keima hih ki ni,” a tia. A minsûr rangpu Judas, khom an kôla ândinga. ");
INSERT INTO sch_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jisua'n, “Keima hih ki ni,” a ti lehan an nûk tieng an intôla, nuoia an inlet raka. ");
INSERT INTO sch_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Avêlin Jisua'n an kôm, “Tumo nin rôk?” tiin a rekel ngei nôka, “Nazareth Jisua” an tia. ");
INSERT INTO sch_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jisua'n an kôm, “Keima ki ni, nangni ki tipe zoi ngah. Ma anghan keima mi nin rok anîn chu adangngei chu se ta rese ngei,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Jisua'n hima anga a tina tak chu, “Pa, mi ni pêk ngei lâia inkhat luo minmang mu-ung, a lei ti hah ahong tung adikna ranga ani.”) ");
INSERT INTO sch_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Peter'n, a khandai pêl hah a kaidûka, Ochai Inlaltak suokpa kuor a changtienga a lengthâk pea. Ha suokpa riming hah Malchus ani. ");
INSERT INTO sch_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jisua'n Peter kôm, “Ne khandai hah akoka thun nôk ta roh! ka Pa'n tuongna kilât mi pêk hih ke nêk loi rangin ni mindon mo?” a tia. ");
INSERT INTO sch_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Hanchu Roman râlmingei pâla an ulien inchungtak leh Juda mi rungpungeiin Jisua an sûra, an khita, ");
INSERT INTO sch_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","male Annas kôm an tuong baka. Ama hah Caiaphas tarpu ania, Caiaphas hah ma kum han Ochai Inlaltak ani. ");
INSERT INTO sch_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Mi murdi ruthûlin mi inkhat thi hah asa uol, tia Juda rachamneipungei kôma rilpu hah Caiaphas hih ani. ");
INSERT INTO sch_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Peter le ruoisi dang han Jisua an jûia. Ha ruoisi dang hah Ochai Inlaltak mêlriet ani sikin Ochai Inlaltak khalâidung dênin Jisua a se puia. ");
INSERT INTO sch_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Peter chu mokot pêntieng a lei oma. Hanchu ruoisi dang han pêntieng a jôk nôka, mokota om dôngmate hah a chongpuia, male Peter sûng tieng a hong minlûta. ");
INSERT INTO sch_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mokota om dôngmate han, “Nangma khom hima miriempa ruoisingei lâia mi inkhat nimak che mo?” tiin a rekela. “Nimak, keima chu ni mu-ung,” tiin Peter'n a thuona. ");
INSERT INTO sch_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Adâi sikin tîrlâmngei le rungpungei han rohol leh mei an thoa, inding chungin an uota. Hanchu Peter khom a sea, an kôla vân dingin mei ava uota. ");
INSERT INTO sch_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ochai Inlaltak han Jisua kôm a ruoisingei thurchi le a minchu ngâi chungroi a rekela. ");
INSERT INTO sch_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jisua'n a thuona, “Zoratin mi murdi rietin thurchi ki misîr ngâia; Synagogngeia le Biekina, mipui intûpna ki minchu ngâia. Inrûkin ite reng misîr ngâi mu-ung. ");
INSERT INTO sch_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Masikin, ithomo keima mi ni rekela? Ku thurchi misîr a riet ngei rekel roh ba. Imo ki misîr pe ngei ngâi an riet ngah,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jisua'n hima anga a chong lâitakin ha taka om mi rungngâi inkhatin a bêna, a kôm, “Kho angngân mo Ochai Inlaltak hih hima anghan no chongpui ngama?” a tia. ");
INSERT INTO sch_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jisua'n a kôm, “Ki ti minchâina aom duoiin chu, maha imo ani hi muna mipuingei hih ril roh. Aniatachu ki ti mindikin chu, ithomo ni ni bêna?” tiin a thuon ngeia. ");
INSERT INTO sch_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Male Annas han khit pumin ama hah Ochai Inlaltak Caiaphas kôm a tîr zoia. ");
INSERT INTO sch_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Peter chu mei uotin a lân ding banga. Hanchu midangngeiin a kôm, “Nangma khom a ruoisingei lâia inkhatlam hah nimak che mo?” an tia. Hannirese, Peter'n a ipdela, “Kei chu ni mu-ung,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ochai Inlaltak suok Peter'n a kuor a lengthâk pe sûngsuokpa han Peter kôm, “Ruhuon sûnga han a kôm nang ku mu nimak mo?” tiin a rekela. ");
INSERT INTO sch_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Avêlin Peter'n, “Ni mu-ung” a ti nôka, male chu âr akhuong kelen zoi. ");
INSERT INTO sch_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jînga inmânin Jisua hah Caiaphas in renga Rom râiôt ina an tuonga. Juda rachamneipungei chu balam angin ânthiengin Kalkân kût ruolhoia sâk, sâk rang an nuom sikin râiôt ina lût mak ngei. ");
INSERT INTO sch_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Masikin Pilat tuol pêntieng ava jôka an kôm, “Hi mi hih imo nin nônna?” tiin a rekel ngeia. ");
INSERT INTO sch_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Annin an thuon chu, “Hi mi hin ite tho minchâina dôn no senla chu no kôm hong tuong no ni ung.” ");
INSERT INTO sch_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilat'n an kôm, “Nônchu nangnin tuong ungla nin balam angin a chungroi jêk roi,” a tipe ngeia. Anni ngei han, “Kin balamin tute that rangin mi phal mak,” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Jisua'n a thi rang thurchi a lei misîr hah ahong tung dikna rangin ha ngei hah ahong om ani.) ");
INSERT INTO sch_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilat hah a in sûnga a lût nôka male Jisua a koia, “Judangei rêngpa mo ni ni?” tiin a rekela. ");
INSERT INTO sch_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jisua'n, “Hi chong hih nangma nu mulung suoka mi ni rekel mo, mîn ku thurchi nang an misîr pe sika mo?” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilat'n a thuona, “Juda mi ani tiin mi ni mindon mo? Ni mingei nanâk le ochai inlal ngei kêng ku kut chunga nang hong pêk an ni, imo no tho pe ngei?” ");
INSERT INTO sch_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jisua'n a kôm, “Ke Rêngram chu hi rammuol hih nimaka; hi rammuol hih ke Rêngram nisenla chu, ku nûkjûingeiin doi an ta, Juda rachamneipungei kuta pêkin om no ning. Ke Rêngram chu mahin nimak!” a tia. ");
INSERT INTO sch_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Hanchu Pilat'n, “Rêngpa mo ni ni?” tiin a rekela, Jisua'n, “Nangman kêng rêngpa ni ni, ni na ti ngah. Kên zira male hi rammuola ku juongna abitak chu, chongtak misîr rang piel hih ani. Tukhom chongtaka om ngei kai chu ko chong an rangâi ngâi,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Male Pilat'n, “Chongtak hih imo?” tiin arkela. Hanchu Pilat han tuol pêntieng a jôk nôka, mingei kôm han, “Theiloi mintumna rangin ite abi man mu-ung. ");
INSERT INTO sch_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Hannirese nin balam anghan, Kalkân kût zorân mi ântâng inkhat nangni ko mojôk pe ngâia. Judangei rêngpa hih nangni mojôk pe ronga nin jôt mo?” a tia. ");
INSERT INTO sch_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Anni ngei han iniek pumin a kôm, “Nuom mak meh, ama chu ni no rese! Barabbas ke kin nuom!” tiin an thuona. (Barabbas chu inru, mi khuolse ngei chunga kut lek ngâi ani.) ");
INSERT INTO sch_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Hanchu Pilat'n Jisua a tuonga, a jêma. ");
INSERT INTO sch_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Râlmingeiin riling amachangngei hah lukhum an phana, male a lua an min khuma; hanchu kâncholiinchuol senduk an min haka, ");
INSERT INTO sch_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","male a kôm an honga, “Judangei Rêngpa ring sôt roh!” an tia, male an sea an bên zoi. ");
INSERT INTO sch_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilat han pêntieng vêlkhat ava jôk nôka, mipuingei kôm, “En ta u, theiloi mintumna rangin ite a sietna abi man mu-ung, ti nangni min riet rangin nin kôm ka la hong tuong rang ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Masikin riling lukhum inkhumin, kâncholiinchuol senduk hakin Jisua a hong jôka. Pilat'n an kôm, “En roi! Hi miriem hi!” a tia. ");
INSERT INTO sch_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ochaisingei le Biekin rungpungei an hong mu lehan an hêtsana, “Khrosa jêmdel roh, khrosa jêmdel roh,” an tia. Pilat'n an kôm, “Nônchu tuong ungla nangnin khrosa jêmdel roi. Theiloi mintumna rangin ite a sietna bi man mu-ung,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Mipuingei han, “Pathien Nâipasalin ânbê sikin a thi rang ani, ti balam kin dôn ani,” tiin an thuon nôka. ");
INSERT INTO sch_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ma chong hah Pilat'n a rietin chu a chi uol nôk zoia. ");
INSERT INTO sch_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","In sûnga a lût nôka, Jisua kôm, “Kho renga hong mo ni ni?” tiin a rekela. Aniatachu Jisua'n thuon maka. ");
INSERT INTO sch_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilat'n a kôm, “Ni na thuon loi rang mo? Nang mojôk theina le nang jêmdel theina rachamneina ko dôn ti hi riettit roh,” a tipea. ");
INSERT INTO sch_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jisua'n a kôm, “Pathien'n nang a pêk sika vaiin kêng ku chunga rachamneina no dôn ani. Masikin nu kuta mi hong bangpu chu a sietna arik uol ok ani,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilat'n ma chong hah a rietin chu Jisua a mojôk theina rang lam a mindonna. Aniatachu mipuingeiin an hêtsana, “No mojôkin chu Rêng mal nimak che! Tutu khom rênga ânbê kai chu Rêng doia ânhel an ni!” an tia. ");
INSERT INTO sch_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ma chongngei hah Pilat'n a rietin chu Jisua pêntieng a tuonga male roijêkpu sukmuna “Lungdâp” (Hebrew chongin “Gabbatha”) an tia han ânsunga. ");
INSERT INTO sch_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Hima nikhuo hah Kalkân kût ranga incherêlni ania, sûnchimrip dôr ani. Pilat'n mingei kôm han, “Mahin nin rêngpa aom!” a tia. ");
INSERT INTO sch_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","An hêtsan nôka, “That roh! That roh! khrosa jêmdel roh!” an tia. Pilat'n an kôm, “Nin rêngpa khrosa jêmdel rangin mi nin nuom mo?” tiin a rekel ngeia. Ochaisingei han, “Caesar vai kêng rêng kin dôn!” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Hanchu Pilat'n Jisua hah khrosa jêmdel rangin an kut chunga a bâng zoi ani. Masikin Jisua ha an tuong zoia. ");
INSERT INTO sch_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jisua a khros ruputin “Luru Mun” (Hebrew chongin “Golgotha”) an ti dênin a sea. ");
INSERT INTO sch_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ma mun han khrosa an jêmdela; male midang inik an jêmdel sa, voi le changa, alâitaka Jisua. ");
INSERT INTO sch_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilat'n minrietna a mizieka, “Nazareth Jisua, Judangei Rêngpa,” tiin khros lêra a târa. ");
INSERT INTO sch_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jisua an jêmdelna mun hah khopuilien renga ala loi sikin mi tamtakin an porea. Minrietna hah Hebrew chong, Latin chong le Greek chongin miziek ani. ");
INSERT INTO sch_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ochaisingei han Pilat kôm, “Judangei Rêngpa” tiin miziek no roh, ama'n kêng, “Judangei Rêngpa ki ni a ti,” an tipea. ");
INSERT INTO sch_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilat'n, “Ki miziek sai chu miziekin aom ani zoi.” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Râlmingei han Jisua an jêmdel suole chu a puonngei an lâka tum minlin an sema, an taka tum khat an changa. A kâncholiinchuol khom an lâka, maha sûiloi kâncholia không ani. ");
INSERT INTO sch_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Râlmingei han, “Khêr no u; tho, tumo a chang rang taruosân ei ti u.” inkhat le inkhat annin tia. Pathien lekhabua ânziek hah ahongtung adik theina rangin ha ngei hah ahong om ani: “Anni ngei han ku puon ki dier annin sema male ka kâncholiinchuol rangin taruo an sâna.” Male ma anghin râlmingei han an tho zoi ani. ");
INSERT INTO sch_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jisua khros kôla ânding ngei chu a nû, a nû zuorpuinu, Clopas lômnu Mary, le Mary Magdalene ngei an ni. ");
INSERT INTO sch_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jisua'n a nû le a lungkham ngâipu a ruoisi hah a kôla an inding a mua; masikin a nû kôm han, “Ama hih na nâipasal ani,” a tipea. ");
INSERT INTO sch_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Hanchu a ruoisi kôm han khom, “Amanu hih nu nû ani,” a tipea. Ma zora renga ha chu a ruoisi han hanu hah a ina om rangin a tuong zoi ani. ");
INSERT INTO sch_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jisua'n atûn chu neinunngei murdi ânzoi suo zoi ti a rieta; male Pathien lekhabua ânziek ahong tung adik theina rangin, “Ku tui ânrâl,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ma muna han uain thûra sip khuriâi inkhat aoma, sponge uaina an michie, hyssop khiengrol le an târra, a mûr an hong min tôna. ");
INSERT INTO sch_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jisua'n uain thûr ha a nêk suole chu, “Ahek zoi!” a tia. Hanchu a lu a juon kûna a rangachat zoi. ");
INSERT INTO sch_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Hanchu ma nikhuo hah Sûnrangngani ania, Juda rachamneipungeiin Sabbathnia khros lêra ruok aom tit rang hah an nuom loi sikin mi an jêmdel ngei kengei hah khiek rangin, le an ruokngei khrosngei renga musum rangin Pilat kôm phalna an ngêna, ahong tung rang Sabbathni ha aliekin ânthieng ani sikin. ");
INSERT INTO sch_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Masikin râlmingei hah an sea, Jisua leh munkhata an jêmdel tong masapu le midang inkhatpu kengei hah an khieka. ");
INSERT INTO sch_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Aniatachu Jisua kôla an hongin chu athi saiin an hong mua, masikin a kengei chu khiek mak ngei. ");
INSERT INTO sch_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Râlmi inkhatin Jisua kângrâm isei leh a hong sunna, harenghan thisen le tui a juong suok zoia. ");
INSERT INTO sch_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Masikin hi neinun a mupu hin nangni khom nin iemna rangin a misîr ani. A misîr hih adika, male chongtak ani ti khom a riet ani.) ");
INSERT INTO sch_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Pathien lekhabua, “A rungei inkhat luo khiek ni no nih.” tia ânziek hah ahong tung adik theina rangin hima hah ahong om ani. ");
INSERT INTO sch_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Pathien lekhabu mun danga, “Mingei han an sunna hah la en an tih,” a ti sa. ");
INSERT INTO sch_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Masuole chu, Arimathea khuoa mi Joseph han Pilat kôm Jisua ruok hah lâk rangin a ngêna. (Joseph hah Juda rachamneipungei chi sika inrûka Jisua nûkjûipu ani.) Pilat'n ruok hah chôi thei rangin a phal pea, masikin Joseph'n a chôia a se pui zoi ani. ");
INSERT INTO sch_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemus, motona jâna Jisua kôma lei hongpu han mirimhoi myrrh le aloe ânpol kilogram sômthum dôr chôiin Joseph a jûi sa. ");
INSERT INTO sch_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ha pasal inik ngei han Jisua ruok ha an chôia, Judangei inphûm ngâi balam angin mirimhoi le puoninnêm leh an tuoma. ");
INSERT INTO sch_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jisua an thatna muna han ruhuon inkhat aoma, ma ruhuon sûng han tute an lân phûmna ngâiloi thân thar inkhat aoma. ");
INSERT INTO sch_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Judangei Sabbathni rang motona sûn ani sika le thân ha anâi sikin, mahan Jisua ruok hah an phûm zoi ani. ");
INSERT INTO sch_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pathienni jînga, ala jîng mumuokin, Mary Magdalene thâna a sea, thân kotbâia lung hah muluoipai saiin ava mua. ");
INSERT INTO sch_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Simon Peter le ruoisi dang Jisua'n a lungkham ngâipu, kôm han a tâna, male an kôm, “Thân renga Pumapa hah an lâk paia, male an darna riet khâi mak me,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Hanchu Peter le ruoisi dang hah thâna an sea. ");
INSERT INTO sch_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Anruonin an tâna, aniatachu ruoisi dang hah Peter a khêl pita thâna a tung masa ani. ");
INSERT INTO sch_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ân kûna male puoninnêm zuot a mua, hannirese asûnga chu lût mak. ");
INSERT INTO sch_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Anûka Simon Peter a juonga male thân sûnga a lût pata. Puoninnêm zuot chu a mua ");
INSERT INTO sch_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","male Jisua lu tuomna puon ha chu puoninnêm zuot leh munkhatin om loiin atheia ânzuotin ava mua. ");
INSERT INTO sch_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Hanchu ruoisi dang, thâna tung masapu khom hah ava lûta; a mua male a iem zoi. ");
INSERT INTO sch_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Pathien lekhabu'n thina renga lân thoinôk atih, ti hah la riet thei uol mak ngei ani.) ");
INSERT INTO sch_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Hanchu ruoisingei hah an ina an kîr nôk zoi. ");
INSERT INTO sch_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mary chu chap pumin thân pêntieng ândinga, chap chungin ân kûna, thân sûng a vênga ");
INSERT INTO sch_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","male vântîrton inik angoia invôn Jisua ruok an min jâlna luthun tieng inkhat kethuon tieng inkhat an insung a mua. ");
INSERT INTO sch_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ha ngei han, “Nupangnu, ithomo na chapa?” tiin an rekela. Amanu han, “Ku Pumapa an lâk paia, khonmo an darna riet khâi mu-ung!” tiin a thuon ngeia. ");
INSERT INTO sch_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Hanchu amanu ha a hônheiin chu mahan Jisua ânding a mua; hannirese amanu ha Jisua ani tiin riet mak. ");
INSERT INTO sch_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jisua'n a kôm, “Nupangnu, ithomo na chapa? Tumo no rok?” tiin a rekela. Amanu han ruhuon donsûipu mini tiin a bôka, a kôm, “Pu, ama hah na lâkin chu khonmo na dar mi ril roh, sêng ka ta, ama ka va lâk theina rangin,” amanu han a tia. ");
INSERT INTO sch_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jisua'n amanu kôm han, “Mary!” a tia. Amanu han a tieng mâi a thaka, Hebrew chongin, “Rabboni!” amanu han a tia. (Maha “Minchupu” tina ani.) ");
INSERT INTO sch_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jisua'n amanu kôm han, “Mi mutu sôt no roh, asikchu ka Pa kôm la se nôk mu-ung. Hannirese ka lâibungngei kôm sênla, ka Pa an Pa, ka Pathien an Pathien kôm ki kîr nôk rang ani zoi tiin va ril ngei roh,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Masikin Mary Magdalene hah a sea, male Pumapa a mu tie le an inkaina a ril ngei hah ruoisingei ava misîr pe ngei zoi. ");
INSERT INTO sch_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ha Pathienni kholoia han, Juda rachamneipungei an chi sikin ruoisingei hah insûnga inkhâr kalin an intûpa. Hanchu Jisua a honga an lâia ândinga, “Nin lâia rathânngamna om rese!” a tia. ");
INSERT INTO sch_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Mahi a ti suole chu a kutngei le a kângrâm a min mu ngeia. Pumapa an mua, ruoisingei ha râisânnân an sip zoia. ");
INSERT INTO sch_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Avêlin Jisua'n an kôm, “Nin chunga rathânngamna om rese. Pa'n mi tîr anghan kei khomin nangni ki tîr ani,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Hanchu ratha a mûtkhum ngeia male an kôm, “Ratha Inthieng man roi. ");
INSERT INTO sch_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mingei sietnangei khom nin ngâidam kai chu ngâidamin om an ta; nin ngâidam loi kai chu ngâidamin om no ni ngei,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jisua a hong lâihan ruoisi sômleinik ngei lâia Thomas (Ânphîr an ti) ha chu an lâia omaka. ");
INSERT INTO sch_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Masikin ruoisi dangngei han, “Pumapa kin mu zoi!” an tipea. Thomas'n an kôm, “A kuta peret sâbenûkngei ku mu noa male a sâbenûkngei ha ku kutruol leh ki khîk noa, a kângrâma sâbenûkngei khom ko tôn nônchu iem no ning,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Hapta khat suole chu ruoisingei hah insûnga an intûp nôka, Thomas khom an kôm a om sa. Inkhârngei hah an kala, aniatachu Jisua a honga, an lâia ândinga, an kôm, “Nin chunga rathânngamna om rese,” a tia. ");
INSERT INTO sch_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Hanchu Thomas kôm, “Nu kutruol leh mahin khîk inla, male ku kutngei hi en roh; hanchu ka kângrâm khom nu kut sônin pûr inla tôn roh. Iemzoiloiin om khâi nônla, male iem ta roh!” a tipea. ");
INSERT INTO sch_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Thomas'n a kôm, “Ku Pumapa le ka Pathien ni ni!” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jisua'n a kôm, “Mi ni mu sika ni iem mini? Mi mu loia mi iem ngei chu satvur ani bak na!” a tipea. ");
INSERT INTO sch_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jisua'n a ruoisingei mitmu chunga sininkhêl dang tamtak ngei a thoa, mangei hah hi lekhabu sûng hin miziek nimak. ");
INSERT INTO sch_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Hannirese Jisua hih Messiah, Pathien Nâipasal ani ti nin iem theina rang le ama nin iemna sika ringna nin dôn theina ranga hingei hi chu miziek ani. ");
INSERT INTO sch_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Masuole chu, Tiberias dîla a ruoisingei kôm Jisua ânlâr nôka. Hi anghin neinun ahongtunga. ");
INSERT INTO sch_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Peter, Thomas (Ânphîr an ti) Nathanael (Galilee ram Cana mi), Zebedee nâipasalngei le Jisua ruoisi dang inik ngei anrêngin an intûpa. ");
INSERT INTO sch_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Peter'n adangngei kôm, “Nga sûr rangin se ki tih,” a tia. Anni han a kôm, “Keini khom juong sa kin tih,” an tipea. Masikin rukuonga an se zoia, aniatachu hani jâna han chu ite man mak ngei. ");
INSERT INTO sch_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nisa ahong suokin chu Jisua tuipanga ândinga, aniatachu ruoisingei han Jisua ani ti riet mak ngeia. ");
INSERT INTO sch_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Hanchu Jisua'n an kôm, “Ruothartengei, ite man mak chei mo?” tiin a rekel ngeia. “Ite man mak me” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ama'n an kôm, “Rukuong changtieng han nin lên ha vôr ungla male man nin tih,” a tipe ngeia. Masikin an lên hah an vôra nga an man tam rai sikin rukuong sûnga kai nôk thei khâi mak ngeia. ");
INSERT INTO sch_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jisua'n a lungkham ngâipu ruoisi han Peter kôm, “Pumapa kêng ani ngaso!” a tipea. Peter'n Pumapa ke ani ti a rietin chu a puon a bomduopa (korongin aom ani sikin) male tuia ânchôm zoia. ");
INSERT INTO sch_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ruoisi dangngei chu rukuong leh tuirakham tieng an honga, lêna nga sipmatin an kaisuoa, tâng renga hah la bâk maka meter razakhat dôr ani. ");
INSERT INTO sch_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tuirakham an hong suokin chu rohol leh mei tho, le achunga nga le vâipôl alekti aom an hong mua. ");
INSERT INTO sch_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Hanchu Jisua'n an kôm, “Atûn renga nin nga sûr senkhat hah hin hong chôi ta u,” a tipe ngeia. ");
INSERT INTO sch_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Peter'n rukuonga chuongin nga lienpapa lên sipmatin tânga a kaisuoa, anrêngin razakhat sômrangnga inthum ani; madôra nga tam khom nisenla lên chu chet mak. ");
INSERT INTO sch_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jisua'n an kôm, “Hong ungla, sâk roi” a tipe ngeia. Ruoisingei lâia tutên “Tumo ni ni?” ti luo rekel ngam mak ngei Pumapa ani tiin an riet minthâr sikin. ");
INSERT INTO sch_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Hanchu Jisua a sea, vaîpôl a lâka a sem pe ngeia, ma angdên han nga khom a sem pe ngei nôka. ");
INSERT INTO sch_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ma hah Jisua'n thina renga ânthoinôk suole a ruoisingei kôma ânlâr avoithumna ani. ");
INSERT INTO sch_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","An sâk suole chu Jisua'n Simon Peter kôm, “Simon John nâipasal, hi adangngei min lungkham nêkin mi ni lungkham uol mo?” a tia. Ama'n a kôm, “O, Pumapa, nang ku lungkham tiin ni riet,” tiin a thuona. Jisua'n a kôm, “Ke belringei donsûi roh,” a tipea. ");
INSERT INTO sch_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Avoiniknân Jisua'n a kôm, “Simon John nâipasal, mi ni lungkham mo?” a tia. “O, Pumapa, nang ku lungkham ti ni riet,” tiin a thuona. Jisua'n a kôm, “Ke belringei donsûi roh,” a tipea. ");
INSERT INTO sch_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Avoithumnân Jisua'n a kôm, “Simon John nâipasal, mi ni lungkham mo?” a tipea. Jisua'n vêlthum, “Mi ni lungkham mo?” tiin a rekel sikin Peter ahong innguikhak zoia, masikin, “Pumapa neinuntin ni riet leta; nang ku lungkham ti khom ni riet!” a tia. Jisua'n a kôm, “Ke belri donsûi roh. ");
INSERT INTO sch_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Chongdiktak nang ki ril: na nâipang lâihan chu nên thoka nu nuomna titieng ne se thei ngâia; aniatachu ulien ni ni tikin chu nu kutngei mazar na ta, tûn mini nang khit pe an ta nu nuom loina titieng nang tuong an tih,” a tipea. ");
INSERT INTO sch_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Hi chong hih Jisua'n a ti pena chu Pathien roiinpuina rangin Peter thi rang tie rietna ranga ani.) Hanchu Jisua'n a kôm, “Mi jûi roh!” a tipea. ");
INSERT INTO sch_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Peter a hônheiin chu ruoisi dang, Jisua'n a lungkham ngâipu, jânbu an nêk lâia Jisua tieng hôn ôna, “Pumapa, tumo nang a minsûr rang?” tia rekelpu hah a nûk a jûi a mua. ");
INSERT INTO sch_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Peter'n ama hah a mûn chu Jisua kôm, “Pumapa hipa hi rêkte imo a tho rang?” tiin a rekela. ");
INSERT INTO sch_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jisua'n a kôm, “Ku juong nôk mâka lei ring tit rangin nuom ngân inlang imo no lo rang? Mi jûi roh!” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Masikin ha ruoisi hah thi no nih tiin, Jisua nûkjûingei lâia ânthang zoi. Aniatachu Jisua'n thi no nih a tina nimaka; “Ku juong nôk mâka lei ring tit rangin nuom ngân inlang imo no lo rang?” kêng a ti ani. ");
INSERT INTO sch_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ama hih ruoisi, hi neinunngei a tipu le a miziekpu khom ania; male a ti ngei khom hih adik ani tiin ei riet. ");
INSERT INTO sch_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Atûn, Jisua sintho neinun dang tamtak aoma. Mangei murdi hah miziek var rang nisenla chu, mizieka om lekhabungei chu rammuol pumpui khom keng rangin minhoi mu-ung.");
INSERT INTO sch_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Moroitak, Theophilus: Ke lekhabu motontaka han, Jisua'n sintho aphut lâia a sintho le a minchuna chongngei hah ki mizieka ");
INSERT INTO sch_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","invân tienga tuongin aom ni tena rilnangei hah. Tuongin a om mân han, a tîrton ranga a thang miriemngei kôm han Ratha Inthieng ranakin chongpêk a pêk zoi. ");
INSERT INTO sch_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Athi suole a ring nôk ti an riet minthâr theina rangin sûn sômminli sûng hah chu vêl tamtak an kôm ânlâra, a chongpui ngeia, Pathien Rêngram thurchi a ril ngâia. ");
INSERT INTO sch_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Male munkhatin an intûp lehan, ma chongkhâm hih a pêk ngei ani: “Jerusalem mâk no roi, nangni ki misîr pe ngâi neinun manboipêk hah lei ngâk roi, ka Pa'n ânkhâm hah. ");
INSERT INTO sch_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","John han tuiin a Baptis ngâia, aniatachu sûn tômte suole nangni chu Ratha Inthiengin baptis chang nin tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Hanchu an intûpkhôm nôka, “Pumapa atûn hin mo Israelngei Rêngram ni minding nôk rang?” tiin tîrtonngeiin an rekela. ");
INSERT INTO sch_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Hanchu, Jisua'n an kôm, “Azorangei le anikhuo chu ka Pa'n ama rachama om ranga a dar ani, anni ngei hah nin lei riet rang nimak. ");
INSERT INTO sch_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Hannirese, Ratha Inthieng nin chunga ajuong tika chu sinthotheina la dôn nin tih, hanchu jerusalema, Judea le Samari ram pumpui ngeia, kôlkung dênin ko chong rietpuipungei nîng nin tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Hanchu ma chong hah a ril suole chu an mu chungchakin invân tieng tuongin a oma, an muphâk khâi loina sûmin a tuongpai zoia. ");
INSERT INTO sch_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ha anga invâna a se an thîr lâitakin mi inik puonchek insilin an kôm inningloiin an juon dinga. ");
INSERT INTO sch_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“Galilee mingei, ithomo invân tieng tanga nin inding chien? Hi Jisua nin kôm renga invâna tuonga ompu hih invâna ranga lâka aom nin mu angtakin la juong kîr nôk ngêt a tih,” an tia. ");
INSERT INTO sch_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Hanchu, tîrtonngei hah Olive Muol renga jerusalema an kîr nôk zoia, ma muol hah Jerusalem renga kilometer inkhat dôra ala ani. ");
INSERT INTO sch_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Hanchu Khopuilien hah an lûta an omna ngâi khâltan chunginta han an kala: anni ngei hah Peter, John, Jakob, Andrew, Philip, Thomas, Bartholomew, Matthew, Alfai nâipasal Jakob, Zelot Simon le Jakob nâipasal Judas an ni. ");
INSERT INTO sch_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Anrêngin nupangngei hah, Jisua nû Mary le Jisua urêngngei le mulung inruol takin chubaitho rangin an intûp bang ngâi ani. ");
INSERT INTO sch_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Sûn tômte suole chu iempungei an intûpkhôma razakhat sômnik an nia, ha ngei lâia han Peter chong rangin ândinga. ");
INSERT INTO sch_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Ka champuingei, Ratha Inthiengin Jisua sûrpu ranga aruoipu Judas roi David bâia alei ril chong hah atung rang piel ani. ");
INSERT INTO sch_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ama hah ei kôma kop ngâi mi ania, hi ei sinthona hin khom rangtum dôn ranga alei thang ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Ama han saloi thona sum a man lehan mun inkhat a rochôka, ha muna han a thia a von apuok khoia arîlngei aterhet ani. ");
INSERT INTO sch_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ha roi hah jerusalema om murdi'n an rieta, masikin ma mun hah an chongin, Akeldama an tia ma mun hah “Thisen mun,” tina ani.) ");
INSERT INTO sch_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Lapuibua hi anghin ânzieka, ‘A omna in lei ram senla; asûnga tute omno rese ngei’ ti le. ‘A sina mun midangin chang rese ngei.’ Ti hih miziekin alei om. ");
INSERT INTO sch_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Masikin, a ruthûl rang thang ngêt rang anânga, ei lâia tumakhat Pumapa Jisua sintho le sêna-hongna a rietpuipu ei lâia mi, John Baptis tholâi renga Jisua invâna a kal ni tena ama hah eini leh munkhata inthoinôkna rietpuipu ni rangin,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Masikin mi inik: Joseph, Barsabbas an ti (Justus khom an ti sa ngâi) le Matthias an zena. ");
INSERT INTO sch_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Masuole chu chubai an thoa, “Pumapa, nangman miriem mulungrîl murdi rietpu hi ngei inik hih tutak hi mo na thang mi min riet roh. ");
INSERT INTO sch_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Judas ama muna a se theina ranga hi tîrton sin a mâkrak mun thûl rangin,” an tia. ");
INSERT INTO sch_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Hanchu taruo an sâna, an taruosân hah Matthias chunga achula, ha anghan Matthias hah tîrton sômleikhat ngei lâia telsa ani zoi. ");
INSERT INTO sch_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecost ni ahong tungin chu iempungei hah anrêngin mun khata an intûpkhôma. ");
INSERT INTO sch_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Inningloi rengin invân renga phâivuopui angati rahang ajuong tung zuta, an insungna in hah ajuong sip zita. ");
INSERT INTO sch_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Melei anga om meidon insem inzarin an mua, an chunga achuong chita. ");
INSERT INTO sch_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Anrêngin Ratha Inthiengin an sip zita, Ratha'n a min chong ngei angtakin chong dangin an chong zoia. ");
INSERT INTO sch_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Hanchu muntin renga hong Juda sakhuo mingei jerusalema an châma. ");
INSERT INTO sch_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ma rahang hah an rietin chu, mi tamtak an hong intûpa, mitinin iempungei chong hah anni an chong chit angin an riet sikin an mulung sûnga an kamâma. ");
INSERT INTO sch_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","an mulung ajînga, kamâmruoi khom an ti oka, “En ta, hi a chongngei murdi hih Galilee rama mi nimak ngei mo! ");
INSERT INTO sch_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","I angin mo ei rêngin ei inzirpui chong ang chita ei riet thei hih? ");
INSERT INTO sch_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Senkhat Parthia mi, Media mi, Elam mingei ei nia, senkhat Mesopotamia rama om, Judea rama om, Cappadocia ram, Pontus le Asia rama om, ");
INSERT INTO sch_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Phrygia le Pamphylia ram, Egypt le Libya rama Cyrene khuo kôl revêla omngei ei nia, senkhat Rom khuo renga hong, ");
INSERT INTO sch_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Judangei le Jentail Juda lei minchang ngei ei nia, male senkhat Crete tuihuol mi le Arabia rama mi ei nia; Hankhoma, Pathien sintho roiinpui ngei an misîr, ei inzirpui chong ang chita ei riet hih!” an tia. ");
INSERT INTO sch_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Anrêngin a mindona chang riet loiin kamâm aruoi an tia, “Hi ngei hih inmo anni rang?” tiin anni le anni an inrekela. ");
INSERT INTO sch_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Hannirese senkhatin chu iempungei hah, innuinân an manga, “Hi mingei hih uain inrûi kêng an ni!” an tia. ");
INSERT INTO sch_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Hanchu sômleikhat ngei leh Peter hah an indinga, mipui lâia han inringtakin chongril aphuta, “Nangni Judea rama mingei le jerusalema ompu murdi ngei, ko chongril hih rangâi ungla male mahi imo aomzie nangni lei ril rong. ");
INSERT INTO sch_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Hi ngei hih nin iem lam angin inrûi mak ngei, atûn hin jîng dâr kuo vaikêng ala ni. ");
INSERT INTO sch_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Hi roi hih Dêipu Joel'n a lei ril hah ani. ");
INSERT INTO sch_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Pathien'n sûn nûka chu hi anghin la tho ki tih; mi murdi chunga ka Ratha la bun ka ta nin nâipasal le nin nâinupangngeiin ko chong la misîr an ta; nin ruotharte ngeiin inlârna mûng an ta, male nin tarngeiin ramangin phan an tih. ");
INSERT INTO sch_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ani, ma nikhuo ngeia hanchu ki tîrlâmngei nupangngei, pasalngei chunga ka Ratha bun ka ta ko chong la misîr an tih. ");
INSERT INTO sch_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Chungtieng invâna sininkhêlngei male nuoi tieng pilchunga kamâmruoingei min mu ngei ki tih. Mahan thisen, mei, meikhu bit ngei om a ta; ");
INSERT INTO sch_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Nisa jîng a ta male tha thisen anghan sen atih; Pumapa Nikhuo inlal le roiinpuitak hah ajuong tung mân. ");
INSERT INTO sch_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Hanchu, tukhomin Pumapa riming ralam murdi chu sanminringin om an tih.’ ");
INSERT INTO sch_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Nangni Israel mingei hi chongngei hih lei rangâi roi! Nangni rengin nin riet anghan, Nazereth Jisua hah Pathien'n nin lâia sininkhêl, kamâmruoi le sinthona ngei nangni a min riet ani. ");
INSERT INTO sch_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Jisua hah Pathien jêklam le mintuo lam angtakin an sûra, nangnin mi nunsie ngei kuta bângin khrosa jêmdelin nin thata. ");
INSERT INTO sch_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Aniatachu Pathien'n thina sinthotheina renga mojôkin, ama hah thinân asûr chien thei loi sikin a kaithoi zoi. ");
INSERT INTO sch_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","David reng khomin a chungroi hi anghin a rila, ‘Ka makunga Pumapa ku mu tit ngâia; kên nîk loina rangin ka changtieng aom tita. ");
INSERT INTO sch_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Masikin râisânnân ki sipa, ko chong khom râisâna asip. ka taksa khomin a sabei ngit ani, ka sabeina khom râisânnân asipa. ");
INSERT INTO sch_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Masikin ka ratha hi mithi khuoa mâksan no ti nia, Ni mi inthieng ruok mon rang phal no ti ni. ");
INSERT INTO sch_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nangman ringna lampuingei mi ni min mua; male mi ni ompui sikin râisânnân sip ki tih zoi.’ ");
INSERT INTO sch_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Ka champuingei, ei richibul Rêng David roi hah hâitakin nangni ki ril. Ama hah a thi zoia, male an phûma, a thân khom atûnten ei kôla ala om tit. ");
INSERT INTO sch_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ama hah Dêipu ania, a ruthûl rangin tumakhat Pathien'n David richisuonpârngei lâia rêngin la phun rangin ânkhâm ngit ti a rieta. ");
INSERT INTO sch_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Pathien'n sûnmotona sin a tho rang tie David'n a lei riet piel sikin Khrista inthoinôk rang chong misîrin, ‘Ama hah mithi khuoa mâkrakin om maka; a ruok khom thâna mon mak,’ ai ti ani. ");
INSERT INTO sch_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Hima Jisua hih Pathien'n thina renga a kaithoinôk zoi ti chong hih keini reng hi rietpuipungei kin ni. ");
INSERT INTO sch_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Pathien changtieng chôiminsâng ani zoia, a Pa kôm renga Ratha Inthieng leikhâm hah a changa, atûna nin mu le nin riet hi ei chunga ajuong vur ani hih. ");
INSERT INTO sch_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","David hah ama lelên invâna kal maka, ‘Pumapa han ku Pumapa kôm: ka changtieng insung tit roh. ");
INSERT INTO sch_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Keima'n na râlngei murdi ne kepha sirna nuoia ka dar mâka a ti, a tina kêng ani.’ ");
INSERT INTO sch_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Hanchu, Jisua nin jêmdelpu hah Pathien'n Pumapa le Khrista aminchang ngêt tih Israel mi murdi riet ngêt rese ngei a tia.” ");
INSERT INTO sch_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","An chong riet han an mulungrîl atôka, Peter le tîrton dangngei kôm han, “Lâibungngei, imo kin tho rang ani zoi?” an tia. ");
INSERT INTO sch_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peter'n an kôm, “Nin sietnangei ngâidam anina rangin insîr ungla, Jisua Khrista rimingin Baptis chang pak roi, hanchu, Pathien manboiapêk Ratha Inthieng hih chang nin tih. ");
INSERT INTO sch_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","A khâm hih nangni le nin nâingei le ram lataka mi murdi ngei rang le Pumapa Pathien'n a kôma a koi ngei nâm ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Peter'n Chong dang tamtakin a ril minthâra; male atûnlâi ruolthar saloi ngei renga hih jôk roi, tiin a ngêna. ");
INSERT INTO sch_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","A chong a pom ngei murdi baptis an changa, ma nikhuo han mi isâng thum an inbôk sa zoi. ");
INSERT INTO sch_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tîrtonngei kôm inchûn, inlopkhômna inchelin bu khalâi ot inlopkhômna inchelin le chubaitho ningsiet takin an oma. ");
INSERT INTO sch_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Tîrtonngei han sininkhêl kamâmruoi tamtak an tho sikin mitinin an rin ngei zoia. ");
INSERT INTO sch_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","A iempungei murdi chu inlopkhômin an neinunngei murdi an minchun zoi. ");
INSERT INTO sch_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","An rochonngei an neinunngei murdi juorin an nâng dungjûiin inmang inlômin an insem ngâia. ");
INSERT INTO sch_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Anîngtin mulung munkhatin Biekina an inkhôm ngâia an in tieng khom râisântak le mulungchuktakin bu khalâi an ot ngâi. ");
INSERT INTO sch_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Pathien an minpâka, mi murdi râisân lamin an oma. Hanchu, Pumapa minringa hong om tîr ngei chu anîngtin an lôm rangin a hong bôk pe bang ngâi ani. ");
INSERT INTO sch_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Sûnkhat chu Peter le John hah chonûk dâr thumin chubaitho rangin Biekina an sea. ");
INSERT INTO sch_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Pasal inkhat a suok renga kholra rojônin Biekina se ngei kôm kutdo rangin mokot, “Enhoi” an ti kôla han anîngtin an dar ngâia. ");
INSERT INTO sch_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ama han Peter le John Biekina an lût rang hah a mua, a kut a lei doa, ");
INSERT INTO sch_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Peter le John han an en ngita, Peter'n, “Keini mi hong en ta!” a tia. ");
INSERT INTO sch_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Masikin, ama han anni renga imakhat man rang sabeiin a en ngeia. ");
INSERT INTO sch_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Hannirese Peter'n, “Sum le rângkachak dôn mu ung, aniatachu ko dôn nang ke pêk thei chu Nazareth Jisua Khrista rimingin inthoi inla ne ke le lôn roh!” a tia. ");
INSERT INTO sch_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","A kut changtieng a sûra, a kaithoia, voikhat rengin a kengei le a ke ârtui rungei ahong rât kelena. ");
INSERT INTO sch_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ânchômma a ke leh ândinga a lôn phut zoia, Pathien manpâk pumin Biekina han an lût kelen zoia. ");
INSERT INTO sch_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Kea a lôn le Pathien a minpâk hah mingeiin an mua, ");
INSERT INTO sch_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Biekin mokot, “Mokot Enhoi” bula kutdoa lei insung ngâi hah ani ti an rieta, a chunga neinun tung hah kamâmruoi ok an tia, a mindonna chang riet mak ngei. ");
INSERT INTO sch_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","A dampu han Peter le John hah a la kol tita, hanchu mi murdi'n kamâmruoi tatakin an rieta, Solomon Bokrop an tia han mi tamtak an hong intûpkhôma. ");
INSERT INTO sch_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Mipui intûp ngei lâia han Peter'n, Nangni Israel mingei, ithomo hi hih kamâmruoi nin ti? Pathien kin iem mindik sika kin sinthotheinân hi mi hih kin minlôn anga ithomo ni nan en ngit? ");
INSERT INTO sch_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham, Isaac le Jakob Pathien, ei richibulngei Pathien han a Tîrlâm inthieng le roiinpuitak, Jisua hah rachamneipungei kuta nin banga, male nin min sûra, Pilat'n mojôk rang a masat suonûk khomin a makunga nin lei heng ani. ");
INSERT INTO sch_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mi inthiengtak le diktak hah nin henga, mi thatpa hah mojôk rangin Pilat kôm nin ngêna. ");
INSERT INTO sch_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ringna pêkpu hah nin thata, hannirese Pathien'n ama hah mithingei lâi renga a kaithoi zoia, keini hih a rietpuipungei kin ni. ");
INSERT INTO sch_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","A riming sinthotheina han hih kholrapa hih râtna a pêk ani. Nin mu le nin riet hih a riming taksônna sika sin ani; nin rêngin nin mu angin Jisua taksônna sika hong om hin amindamriem zoi ani. ");
INSERT INTO sch_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Male, “Atûn hin ka champuingei, nangni le nin ruoipungei khomin Jisua chunga nin sintho hah nin riet loi tatak ani ti ki riet zoi ani. ");
INSERT INTO sch_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pathien'n dêipungei murdi manga Khrista han a tuong rang ani tia a lei ril hah a juongtung ani zoi. ");
INSERT INTO sch_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Masikin nin sietnangei nangni ngâidam theina rangin insîr ungla, Pathien tieng hong kîrnôk ta roi, hanchu nin sietnangei ngâidamin om nin ta. ");
INSERT INTO sch_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Male Pumapa kôm renga rathatienga râtna zora juong tung a ta, nin ranga Messiah a lei thang Jisua hah, juongtîr a tih. ");
INSERT INTO sch_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pathien'n tienlâia a dêipu inthiengngei bâia a lei phuong sai anghan neinunngei murdi sin minthar zora atung mâka chu invâna la om rang ani. ");
INSERT INTO sch_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses khom han, ‘Pumapa nin Pathien'n keima ni tîr anga nin sûngsuokngei lâia mi dêipu inkhat nangni minding pe a ta; nin kôma a ril murdi chu nin jôm rang ani. ");
INSERT INTO sch_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tukhom ha dêipu chongjôm loi murdi chu, Pathien mingei renga sensâiin that minmang pai nîng a tih,’ a ti ani. ");
INSERT INTO sch_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Male Samuel le a nûka dêipungei murdi chu atûnlâi thurchi hih an lei misîr ngâi ani. ");
INSERT INTO sch_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Pathien'n a dêipungei manga chong a lei khâm hah nangni ngei rang ania, nin richibulngei kôma chongkhâm a lei pêk hah khom nin mansa zoia, Pathien'n Abraham kôm, ‘Ni richisuonpârngei sikin pilchunga mi murdi satvur ki tih, a lei ti anghan.’ ");
INSERT INTO sch_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Masikin Pathien'n a Tîrlâm hah a thanga, nin puoloina lampuingei nûksong zit rang le mi murdi sat nangni vur rangin nin kôm a juongtîr masa ani hi,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Hanchu Peter le John'n mipuingei kôm chong an ril lâihan ochaingei kôm, Biekin enkol ulienngei, Sadduceengei hah an kôm an juong tung zuta. ");
INSERT INTO sch_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Jisua thina renga ânthoinôk sikin miriemngei khom inthoinôk an tih, ti thurchi mingei an ril ngei sikin asân an taksia. ");
INSERT INTO sch_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Masikin, an sûr ngeia, kholoi ani sikin anangtûk tena rangin intâng ina an khum ngeia. ");
INSERT INTO sch_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Hannirese, an chongril rangâipungei lâia mi tamtakin an iem zoia, an tamlam chu pasal ulien korong khom isâng rangnga dôr an ni. ");
INSERT INTO sch_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Anangtûka chu Juda ruoipungei, Upangei, Balam minchupungei Jerusalema an intûp zoia. ");
INSERT INTO sch_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ochai Inlaltak Annas, Caiaphas, John, Alexander ngei le Ochai Inlaltak rûia mingei murdi lehan. ");
INSERT INTO sch_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Peter le John hah an makunga an minding ngeia, “I angin mo mahi nin tho? I ranakin mo, tu riming mo nin mang tiin an rekel ngeia?” ");
INSERT INTO sch_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Peter hah Ratha Inthiengin a sipa, an kôm, “Mipui Ruoipungei le Upangei: ");
INSERT INTO sch_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Avien hin kholrapa chunga sin sa roia le a hong damna roia, i anga mindam mo tiin mi nin rekela anînchu, ");
INSERT INTO sch_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Nin rêngin riet roi, Israelngei murdi khomin riet rese ngei, Nazareth Jisua Khrista khrosa nin jêmdela, Pathien'n thina renga a kaithoinôk rimingin hi kholrapa nin makunga dam vangin ânding ani hi. ");
INSERT INTO sch_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jisua hih ani, Pathien lekhabua ati, ‘Nangni in sinpungeiin nin hengpai lung hah, akila lung kâmnâng tak ahong chang zoi.’ ");
INSERT INTO sch_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Sanminringna hih Jisua kôm mangke aom, rammuol pumpuia tute kôm mi min ringtheina rang riming dang Pathien'n pêk mak,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Peter le John ngei an hâi tie an mua, lekha theiloi minmôl papai anni an rieta, asân kamâm aom an tia, Jisua kôm om ngâi an ni tiin an riet sikin. ");
INSERT INTO sch_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Hannirese, an mi mindam hah an kôm Peter le John inding an enin ite dem rang lâk om maka. ");
INSERT INTO sch_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Masikin roijêkna in renga an mojôk ngei zoia, an se nûkin chu an thenin anin kerenga. ");
INSERT INTO sch_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Hi mingei hih inmo ei tho rang ani zoi? an sininkhêl tho hih jerusalema om murdi khomin an riet zoia, eini khomin ite ei dem theiloi hih. ");
INSERT INTO sch_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Aniatachu mîn an riet minzar uol loina rangin tute kôm Jisua riminga chongril nôk khâiloi rangin lei misi ngei rei u,” an tia. ");
INSERT INTO sch_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Masikin, anni hah an koi ngei nôka Jisua rimingin chongril tet khâiloi rangin le minchu ngei khâiloi rangin chong an pêk ngeia. ");
INSERT INTO sch_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Hannirese, Peter le John'n an kôm, “Pathien mitmua, Pathien chongjôm nêkin nangni chong jôm mo adik uol mindon ta u. ");
INSERT INTO sch_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Keini chu kin mu le kin riet hi misîr loiin om thei no ni-ung” an tia. ");
INSERT INTO sch_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Hanchu roijêkpungei han an masî ngei nôk uola an mojôk ngei zoi, Peter le John sintho sika han mi murdi'n Pathien an minpâk sikin dûkmintong ngei thei khâimak ngei. ");
INSERT INTO sch_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Kamâmomtaka an mindampu hah kum sômminli nêka ulien ani. ");
INSERT INTO sch_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Peter le John hah an mojôk ngei suole han, an champuingei kôm an kîr nôka, ochai inlalngei le upangeiin an kôma an ti ngei hah an ril leta. ");
INSERT INTO sch_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Iempungei maha an riet lehan anrêngin Pathien kôm chubaithôn, “Pumapa Ânchungtak nangma, invân, pilchung, tuikhanglien le an sûnga neinun om murdi ngei Sinpu ni ni. ");
INSERT INTO sch_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Nangman Ratha inthiengin kin richibulngei ni tîrlâm David bâiin hi chong hi ni min rila, ‘Jentailngei ithomo an ning a thika; mipuingeiin ithomo neinun kâmnângloi an mintuo? ");
INSERT INTO sch_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Pilchung rêngngeiin an insiema, roijêkpungei khom an intûpkhôma Pumapa le a Messiah doi rangin tiin.’ ");
INSERT INTO sch_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ma ang han Herod le Pontius Pilat'n, hi khopuilien hin Jentailngei le Israelngei leh an intûpkhôma, Jisua ni Tîrlâm inthieng Messiah doi rangin. ");
INSERT INTO sch_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ni sinthotheina le nu lungdo mintung ranga ne jêk masat sai anghan neinuntin tho rangin an intûp zoi. ");
INSERT INTO sch_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Misinangei hih en ta ni tîrlâmngei hih hâina murdi leh nu thurchi misîr phalna pêk roh. ");
INSERT INTO sch_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Mingei mindamna rangin nu kut phar inla, male tîrlâm inthieng Jisua riming jârin kamâmruoingei le sininkhêlngei sin theina rangin ni pêk roh” an tia. ");
INSERT INTO sch_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Chubai an tho suole chu an om khômna mun hah ahong innîka, anrêngin Ratha Inthiengin an sipa, hâitakin Pathien chong an ril phut zoi. ");
INSERT INTO sch_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Iempungei pâl hah mulung munkhat le mulungbôk mulungrîl munkhat ruputin an oma, an lâia tukhomin an neinun dôn ngei hah keima kata kêng ti loiin, neinuntin insemin an inlopkhôm ngâi. ");
INSERT INTO sch_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Tîrtonngei han asân sinthona dônin Pumapa Jisua inthoinôkna, rietpuipu nina rangin chong an ril ngâia, male anrêngin Pathien satvurna lientak an chang pak zoi. ");
INSERT INTO sch_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","An pâla tute ânsam khom om mak ngei, loingei mini, inngei mini an juora, aman hah an hong chôia, ");
INSERT INTO sch_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","male tîrtonngei kuta an pêka; an nâng lam angtakin sum hah an sem ngâia. ");
INSERT INTO sch_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Masikin, Joseph, tîrtonngeiin Barnabas an ti (Aomtie chu “mohôk ngâipu” tina ani), Levi jâisuon Cyprus tuihuola mi ania, ");
INSERT INTO sch_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","loimun a dôn hah a juora, aman hah hong chôiin tîrtonngei kuta a hong pêk zoi. ");
INSERT INTO sch_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Hannisenla mi inkhat a riming Ananias a dôngma Sapphira leh an oma, an neinun senkhat a juora. ");
INSERT INTO sch_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Hannirese ma sum hah a dôngma inrietpuiin in-ang a thupa, adang aminieng kai hah tîrtonngei kuta an hong pêka. ");
INSERT INTO sch_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Hanchu Peter'n, “Ananias Ratha Inthieng huongin ram man in-angrip thup rangin ithomo Soitan'n nu mulungrîla racham ni min nei? ");
INSERT INTO sch_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Nu juor mâna han khom nata ania; nu juor suo nûkin khom aman chu nata ania, ithomo ma anga neinun tho rangin nu mulunga na masata? Miriemngei huong nimak chea, Pathien huong kêng ni ni,” a tipea. ");
INSERT INTO sch_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananias'n ma chong hah a riet lehan, ha renghan an leta a thi kelena; hanchu ha thurchi a riet murdi'n chu asân an chi zoia. ");
INSERT INTO sch_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ruothartengei an honga, a ruok hah an thoma, an rojôna, male an phûm zoi. ");
INSERT INTO sch_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Dâr inthum vêl suole a dôngma khom ite roi riet loiin a hong lûta. ");
INSERT INTO sch_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Peter'n amanu kôm, “Na pasal le neinun man nin man hah hi dôr veihi mo ani, ni ril roh?” tiin a rekela, “O, ma dôr vai hih ani,” tiin amanu han a thuona. ");
INSERT INTO sch_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Masikin Peter'n amanu kôm han, “Ithomo Pumapa Ratha minsinna rangin no lômpa le nin inruol? En ta atûn hin na lômpa phûm ngei khom mokota an hong tung nôk zoi so, male nangma khom nang rojôn nôk an tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Hanchu voikhat rengin Peter ke kunga han ân leta a thi kelena. Ruothartengei hah an hong lûta, amanu hah a thîn an hong mua, masikin an rojôn paia, a pasal kôla han an phûmsa zoi. ");
INSERT INTO sch_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Koiindang mi murdi ngei le midangngei ha roi a riet murdi'n chu asân an chi sabak zoi. ");
INSERT INTO sch_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Tîrtonngei chu mipui lâia kamâmruoingei le sininkhêl tamtak an tho tira. Iempungei anrêngin Solomon Bokropa an intûpkhôm ngâia. ");
INSERT INTO sch_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","An pâl pêntieng mingei hah tute an kôma kop ngam khâimak ngeia, nikhomsenla mingeiin anni ngei hah an minpâk ngâi. ");
INSERT INTO sch_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Hannirese Pumapa iempungei pasal le nupang tamtakin an pâla kopin an hong pung bang ani. ");
INSERT INTO sch_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tîrtonngei sintho sika han, damloingei khom khalâidung lamlienngeia an hong rojôna, jâlmunngeia, puonphângeia an min jâl ngeia, Peter hong inlôi zorân a rilîm tete luon mi minli thei duoi mo, an tia. ");
INSERT INTO sch_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jerusalem kôl revêla khopuingei renga mipuingei an honga, damloingei, ramkhori sûrngei an hong tuonga; anrêngin an dam let zoi. ");
INSERT INTO sch_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Hanchu ochai Inlaltak le a champui Sadduceengei murdi an honga, tîrtonngei hah an narsa ngei tataka, dûkmintong ngei rang an masata. ");
INSERT INTO sch_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Tîrtonngei hah an sûr ngeia intâng ina an khum ngei zoi. ");
INSERT INTO sch_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Hannirese, jâna Pumapa vântîrton inkhatin intâng in mokot hah ajuong mo-onga, pêntieng a tuong ngeia male an kôm, ");
INSERT INTO sch_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Se ungla Biekina vân ding ungla, male mipuingei kôm hi ringna thar roi hih varil roi,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ma chong hah an jôma, male an sea, khuovârchak dôrin Pathien Biekina an lûta, mi an minchu phut zoi. Hanchu Ochai Inlaltak le a champuingei hah an honga, Juda ulienngei murdi hah roijêkna lientak nei rangin an koi bûma; an makunga rangin tîrtonngei varuoi rangin intâng ina mi an tîra. ");
INSERT INTO sch_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Aniatachu, ulienngei hah an vatungin chu intâng ina han tîrtonngei hah tute va mu khâi mak ngeia, masikin an hong kîr nôka, ");
INSERT INTO sch_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Intâng in ha asadimin inkhârin a rungpungei mokotngeia indingin kin va mua; hannirese kin mo onga asûnga tute mu mak me,” tiin an hong rila. ");
INSERT INTO sch_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Biekina ochaisi le ruoipu ulien han ha chong hah an rietin chu, “Tîrtonngei chunga imo atung ani zoi hih,” tiin an kamâm sabak zoia. ");
INSERT INTO sch_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Hanchu mi inkhat a honga, an kôm, “Rangâita u! Intâng ina mi nin khum ngei han Biekina mi an minchu ngei bang so,” tiin a hong rila. ");
INSERT INTO sch_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Hanchu ruoipu ulien hah a champuingei le an honga tîrtonngei hah rangrât song loiin an hong ruoi ngeia, rangrât an songin chu mipuingeiin lungin me deng ni ngei ti an chi sikin. ");
INSERT INTO sch_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tîrtonngei asûnga an hong tuonga male roijêkna muna an inding ngeia, male Ochai Inlaltak han chong a rakel ngeia. ");
INSERT INTO sch_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Hi mi riminga hin minchu tet khâi loi rangin chong inngartak nangni kin pêka, aniatachu en ta u nin chongrilin Jerusalem nin min sipzit zoi hi! hi mi thina hih keini ngei mi minpêl rang nin bôk ani hih!” tiin a ti pe ngeia. ");
INSERT INTO sch_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Peter le tîrton dangngei han, “Miriemngei chong nêkin Pathien chong kin jôm ngêt rang ani. ");
INSERT INTO sch_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nangnin Khrosa peret leh nin jêmdela nin that Jisua hah ei richibulngei Pathien'n a kaithoi nôk zoi. ");
INSERT INTO sch_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Israelngei nunsie minsîr ngeia ngâidam an chang theina rangin Ama ngêt hah Pathien'n Ruoipu le Sanminringpu ni rangin a changtienga rangin a kaithoi zoia. ");
INSERT INTO sch_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Keini hih ha roi rietpuipungei kin nia, Keini le Ratha Inthieng, Pathien'n chong jôm ngei kai kôma a pêk ngâi hah kin ni sa,” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Hanchu roijêkpungei han ma chong ha an rietin chu asân an ning athika, tîrtonngei hah thatpai rang an bôka. ");
INSERT INTO sch_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Hannirese an lâia Pharisee inkhat a riming Gamaliel, Balam minchupu le mitinin mirit an tho ngâi hah Roijêkna han ândinga. Tîrtonngei hah pêntieng chomolte mojôk rangin chong a pêka, ");
INSERT INTO sch_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","hanchu roijêkpungei makunga han, “Ki Israel champuingei, hi mingei chunga tho ranga nin bôk chunga hin indîn roi. ");
INSERT INTO sch_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Moton han khom Theudas, ‘Milien ki ni’ tiin a hong oma, mi raza minli dôr an jûi ti nin la riet, nikhomrese ama hah thatin a oma, a nûk jûipungei khom anrêngin chekaninchâi zita ite ni khâimak ngei. ");
INSERT INTO sch_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ma suonûk khom han, intelna zora lâiin Galilee rama om Judas hah a hong om nôka; a tieng mi tamtak an kop nôka, aniatachu, ama khom thatin a om nôka a nûk jûipungei murdi khom chekaninchâi zit nôka. ");
INSERT INTO sch_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Masikin ma roia hin nangni ki ti, hi mingei hih tôn ngei no roi, omchien rese ngei! tho ranga an bôk le an sintho ngei hih miriem renga ânzir anînchu mong nôk kelen atih, ");
INSERT INTO sch_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","hannirese Pathien renga an tho anînchu mene no tunui, Pathien doi kêng nin hong changna rang!” a tia. Roijêkna han Gamaliel chong hah an poma. ");
INSERT INTO sch_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Tîrtonngei hah asûnga an koi ngeia, an vîk ngeia, Jisua rimingin thurchi misîr tet khâiloi rangin chong an pêk ngeia, male an mojôk ngei zoi. ");
INSERT INTO sch_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Hanchu, roijêkpungei lâi renga an jôka Jisua riming sika tuong thei rangin intelin an om sikin asân an râiasâna. ");
INSERT INTO sch_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Male anîngtin Biekin le insûng ngeia thurchisa misîrin, Jisua chu Messiah ani tiin an misîr bang ngâi. ");
INSERT INTO sch_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ma zora han, ruoisingei an hong pung bang lâia han, anîngtin an neinun sema han meithâingei rang lunghâng an tho ngâiloi sikin Greek chong mang Judangei hah, Juda Hebrew ngei chunga an chiera. ");
INSERT INTO sch_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Masikin, tîrton sômleinik ngei han iempungei murdi an koibum zita, “Pathien chongril mâksanin anîngtin sum puon jêk kin changin chu dik noni. ");
INSERT INTO sch_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Masikin, champuingei nin lâia mi Ratha Inthienga asip le vârna dôn pasal sari inthang ungla, an kôm hi sin hih minkol kin tih, ");
INSERT INTO sch_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Keini chu chubaitho le chongrilin om kin tih,” an tia. ");
INSERT INTO sch_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tîrtonngei chong han mipuingei murdi an râiasâna, masikin Stephan taksôn dettak le Ratha Inthienga sip le Philip, Prochoras, Nicanor, Timon, Parmenas le Nikolas Jentail Juda lei chang Antioch mi an thang suok ngeia. ");
INSERT INTO sch_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ma mi sari ngei hah tîrtonngei makunga an minding ngeia, tîrtonngei han an lu chunga kut min ngamin chubai an thoa. ");
INSERT INTO sch_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Masikin Pathien thurchi inzarin a oma, Jerusalema ruoisingei asân an hong punga, ochai lâia mi tamtak khomin taksônna hah an pomsa zoi. ");
INSERT INTO sch_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stephan chu Pathien satvurna tamtak changin le sinthotheinân a sipa, mipui lâia kamâmruoi le sininkhêl roiinpuitak a tho ngena. ");
INSERT INTO sch_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Hannirese Cyrene khuo le Alexandria khuo renga Juda senkhat (suok renga jôk) Synagog an tia kop sa ngâi ngei le Cilicia ram le Asia rama Judangei an honga, Stephan an hôn khalpuia. ");
INSERT INTO sch_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Aniatachu Ratha han ma anga vârna a pêka han a hong chongin chu makhal mindok thei ngâi mak ngei. ");
INSERT INTO sch_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Hanchu, “Moses le Pathien a rilminsiet kin riet,” min ti rangin mi senkhat sum le an methêmin an lei dara. ");
INSERT INTO sch_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ma anghan, mipuingei, Upangei le Balam minchupungei an misieta. Stephan hah an minsûra, Judangei roijêkna an tuonga. ");
INSERT INTO sch_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Mi senkhat a chungroia milak tho rangin an hong tuonga anni han, “Hi mi, hin kin Biekin Inthieng le Moses Balam a rilminsiet bang ngâi. ");
INSERT INTO sch_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nazereth Jisua'n, hi Biekin hih set a ta, Moses'n balam mi pêk ngei hah thûl atih, tiin a misîr kin riet!” an tia. ");
INSERT INTO sch_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Roijêkna muna om murdi'n Stephan hah an enruma, a mâi hah vântîrton mêl angin an mu zoi. ");
INSERT INTO sch_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ochai Inlaltak han Stephan kôm, “hi chong hi adik mo?” a tia. ");
INSERT INTO sch_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stephan'n, “Ka lâibungngei ka pangei rangâi roi, ei richibul Abraham hah Haran khuoa ava om mân, Mesopotamia rama aom lâihan, roiinpuina Pathien hah a kôm ânlâra. ");
INSERT INTO sch_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘Na ram le ni insûngmingei mâksan inla, ram nang ka la min mûna rang tieng se roh,’ a tipea. ");
INSERT INTO sch_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Masikin, a ram renga ânphêta, Harana om rangin a sea. Abraham a pa thi suole, ha mun renga atûna nin omna rama hin Pathien'n nangni a min thon ani. ");
INSERT INTO sch_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pathien'n ite mun luorang, a ke sirna rang dôr luo pêk maka, aniatachu ama le anûka a richisuonpârngei tena pêk rangin ânkhâm ani. Pathien'n ha chong ânkhâm lâihan Abraham chu nâi la dôn mak. ");
INSERT INTO sch_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Pathien'n hi anghin a tia, ‘Nin richisuonpârngei chu mi rama khuolmi la nîng an ta, kum raza minli mi suoka omin asân dûkmintong la nîng an tih. ");
INSERT INTO sch_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Hannirese suoka tuong rang mingei chu keiman jêk ka ta; masuole jôk an tih, hi muna hin ni la biek an tih,’ a tia. ");
INSERT INTO sch_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Pathien'n Abraham kôm chonginkhitin an sertan rangin chong a pêk zoi. Masikin Abraham han a nâipasal Isaac hah sûn sari suoleh a ser a tanpea; Isaac'n a nâi Jakob a tanpe nôka, Jakob'n a nâi sômleinik ei richibulngei inthang ngei a tanpe nôka. ");
INSERT INTO sch_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Jakob nâipasalngeiin an lâibungpa Joseph hah an narsa zoia, Egypt rama suok rangin an juora, hannirese, Pathien'n a ompuia. ");
INSERT INTO sch_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Intak a tuongna murdia a san minjôka, Egypt rama Rêng Pharoah mitmua mi vârtak le midit omtak a min nia; Pharaoh han Egypt ram le a ina mi murdi chunga râiôt ni rangin a min changa. ");
INSERT INTO sch_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Hanchu Egypt le Canaan ram pumpuia mâitâm achula, asân intak an tuonga, ei richibulngei han sâk le nêk rang reng man khâimak ngeia. ");
INSERT INTO sch_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jakob'n Egypt rama bu aom ti a rietin chu a nâingei a tîra, ma hah an se phutna tak alei ni. ");
INSERT INTO sch_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Avoinikna an se han Joseph han a lâibungngei le inrietna a lei thopui ngeia, Egypt Rêng han khom Joseph insungmingei a lei riet zoia. ");
INSERT INTO sch_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Hanchu, Joseph han a pa Jakob le a insûngmingei murdi Egypt rama om rangin a koia, an rêngin sômsari-leirangnga anni. ");
INSERT INTO sch_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Hanchu Jakob hah Egypt rama a va sea ha muna han ama le a nâipasalngei chu an thi zoia. ");
INSERT INTO sch_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","A ruok hah Shechem khuo an hong chôia, Hamor rûingei renga Abraham'n suma a rochôk thâna han an phûm zoi. ");
INSERT INTO sch_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Abraham kôma Pathien chongkhâm ahongtung rang zora ahong nâi tena ha mingei hah Egypt rama an hong pung zoia. ");
INSERT INTO sch_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Anûktaka Egypt rama han rêng dang Joseph riet loi ahong inlal zoia. ");
INSERT INTO sch_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ama han ei richibulngei hah a huong ngeia, dûk amintong ngeia, nâitesenngei ring loina rangin an suok suo pêntieng pai rangin rangrâtin chong a pêka. ");
INSERT INTO sch_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ma zora tak han Moses ajuon zira nâitesen mêl satak a nia. A pa ina thân thum an donsuia, ");
INSERT INTO sch_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","an in renga an pai suo nûkin, Pharaoh nâinupangin a lâka a nâipasal rangin a vâia. ");
INSERT INTO sch_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moses hah Egypt rama vârna murdi an minchua, hanchu chongril theitak le sinthothei tak a hongni zoi. ");
INSERT INTO sch_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Kum sômminli a hong nînchu, a mulung sûnga a sungsuok Israel champuingei kho angin mo an om mu rang nuomin ava pana. ");
INSERT INTO sch_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","A va sên chu mi inkhat Egypt min dûk amintong lâi ava mua, masikin a sanna, dûktongpu chunga han phûba a laka Egypt mipa hah a thata. ");
INSERT INTO sch_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","(Moses han, ama mangin Pathien'n a mingei mojôk atih ti a sungsuok ngeiin an riet mini tiin a bôka hannirese riet mak ngei.) ");
INSERT INTO sch_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Anangtûka chu Isreal mi inik insuol lâitak ava tonga ava sel ngeia, ‘Rangâita u sûngsuokngei,’ lâibungrêng kêng nin ni, ithomo hima anga nin insuola? tiin min sûk ngei rang a bôka. ");
INSERT INTO sch_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","A theiloi uolpu han Moses hah a nampaia, ‘Kin chunga ruoipu le roijêkpu rangin tumo nang phun?’ a tia. ");
INSERT INTO sch_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","‘Majâna Egypt mi na that angdên han ni that nôk rang no bôk mo?’ a tia. ");
INSERT INTO sch_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ma chong hah a riet lehan, Moses a rota, Midian rama ava oma, mahan nâipasal inik a neia. ");
INSERT INTO sch_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Kum sômminli avun suole chu, Sinai Muol ramchâr kôla chîmbuk akângna han vântîrton a kôm ânlâra. ");
INSERT INTO sch_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses'n a neinun mu hah a kamâm tataka, minthâr rang bôkin a va nâia, Pumapa rôl a rieta: ");
INSERT INTO sch_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Keima hih ni richibulngei Pathien, Abraham Pathien Isaac Pathien, Jakob Pathien hah ki ni,’ a lei tia, Moses hah ichîn ânnîka en ngam khâi maka. ");
INSERT INTO sch_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Pumapa'n, a kôm, ‘Ne kekokngei ha khek roh, nên dingna mun hah mun inthieng kêng. ");
INSERT INTO sch_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Egypt rama ki mi omngei dengthei tie ku mua, an inrûmnangei khom ki rieta anni ngei minjôk rangin ku juong ani. Hong ta; Egypt rama nang lei tîr rong,’ a tia. ");
INSERT INTO sch_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ha Moses kôma ruoipu le roijêkpu rangin tumo nang phun? tia an makhal hah chîmbuk kângna taka vântîrton a kôma inlâr han a sanna, Pathien'n ama lele hah ruoipu le sanminjôkpu ni rangin ai tîr ani. ");
INSERT INTO sch_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ama han anni hah a ruoisuoka Egypt rama, tuipui sena, ramchâra kum sômminli sûng han Kamânruoi le sininkhêl tamtak thôn a ruoi ngeia. ");
INSERT INTO sch_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moses hah Israel mingei kôm, ‘Pathien'n keima, mi tîr angin nin sûngsuokngei lâia om dêipu nangni la minchang pe atih,’ tipu hah ani. ");
INSERT INTO sch_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ama hah ani ramchâra Israel mi intûp ngei lâia oma; ei richibulngei kôma le Sinai muola a chongpuipu vântîrton kôma, eini mi pêk ranga Pathien chong ring lâkpu hah ani. ");
INSERT INTO sch_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Hannirese ei richibulngei han a chong jôm nuom mak ngeia; ama hah an nampaia male Egypt ram tieng kîr nôk an nuoma. ");
INSERT INTO sch_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Masikin Aaron kôm, ‘Kin moton ruoipu rangin pathienngei mi sin pe roh. Moses Egypt ram renga mi ruoipu laka a thurchi reng riet khâi mak meh,’ an tia. ");
INSERT INTO sch_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Masuole chu, ma ngei han serât chalte rimil an sina, a rimil hah sa thatin an bieka, male an kut suoka han mirit thonân ruolhoi an thoa an râi an minsâna. ");
INSERT INTO sch_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Hanchu, Pathien'n anni hah nûk a song ngeia, invâna ârsingei an biek theina rangin a rotsan ngeia, dêipu lekhabua: ‘Israel insung mingei! kum sômminli sûngin ramchâra han inbôlna sa thatin nin pêk ngâi hah keima ni mu ung. ");
INSERT INTO sch_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Molech pathien puon-in nin chôia nin pathien le Rephan nin ârsi pathien; rimilngei hah chubaimûk rangin nin sin ngei hah an ni. Masikin Babylon khêl tieng nangni min tâng ki tih, tia ânziek anghan.’ ");
INSERT INTO sch_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Ramchâra han ei richibulngeiin Pathien omna Puon-in an neia, ma in hah Pathien'n Moses kôm sin rangin a bea, a rimil a min mu lam taka sin ani. ");
INSERT INTO sch_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ha ngei hah ei richibulngei khomin an hong dôn banga, Pathien'n ei richibulngei motona ai not pai nâmngei rama an luo lâihan Joshua lût zorân an lûtpui ani. David a zora tena a oma. ");
INSERT INTO sch_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ha David hah Pathien mitmua miditin a hong oma, Jacob Pathien ta ranga omna rang sin pe rangin a zonga. ");
INSERT INTO sch_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Hannirese, in hah chu Solomon'n kêng a sin pe zoi. ");
INSERT INTO sch_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Nikhomrese, Ânchungtak Pathien chu kuta sin in ngeia om ngâi mak; Dêipu'n, ");
INSERT INTO sch_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Pumapa'n, invân ke Rêngsukmun ania pilchung ke ke sirna ani. I anga in mo mi ni sin pe rang? Khotieng mo kên ngamna rang mun khom aom? ");
INSERT INTO sch_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Hi neinun murdi hih keima ki sin nimak mo?’ ");
INSERT INTO sch_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Khodôra mulung ngar mo nin ni! Mulungrîl le kuor in-ongloi sertanloingei anga, nin richibulngei tho ngâi lam angin Ratha Inthieng nin dem tita! ");
INSERT INTO sch_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nin richibulngeiin, dêipungei lâia tumo dûkmintong loia an dar? midik tak juong rang lei juong ril Pathien tîrtonngei hah an thata, atûn nangni hih mi min sûrpu le a thatpu nin ni hi. ");
INSERT INTO sch_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Nangni hi Pathien balam, vântîrtonngeiin an juong thak muchaka jômloi ngei nin ni!” a tia. ");
INSERT INTO sch_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Roijêkpungei han Stephan chong hah an rietin chu an takasia, a chunga an rakam an tâta. ");
INSERT INTO sch_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Hannirese, Stephan hah Ratha Inthienga sip ania, invân tieng a en ngita, Pathien roiinpuina le a changtienga Jisua inding a mua. ");
INSERT INTO sch_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“En ta u! invân in-ong ku mua, Pathien changtienga Miriem Nâipasal inding ku mu!” a tia. ");
INSERT INTO sch_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Hanchu, roijêkpungei han inringtakin an inieka, an kutngei leh an kuorngei an hîpa. Hanchu ha renghan a tieng an tâna. ");
INSERT INTO sch_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Khopuilien sûng renga an mojôk paia, lungin an dênga rietpuipungei han ruotharte inkhat a riming Sual an tih kôm han an puon an mâka. ");
INSERT INTO sch_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Lungin an dêng lâiin Stephan'n Pumapa a koia, “Pumapa Jisua ka Ratha lâk ta roh,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Khûk ânbila, rôl inringtakin ânieka, “Pumapa! hi an sietna hih riet pe ngei khâi no roh!” a tia. Ha chongbâi hah a ti suole chu a thi zoi. ");
INSERT INTO sch_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Male Saul khomin Stephan thi hah apompui sa. Ma nikhuo renga han Jerusalema koiindangngei hah dûk an mintong ngei kelen zoia. Hanchu tîrtonngei telloi iempu adang nâm chu Judea le Samaria ram khuotina chek an inchâi zita. ");
INSERT INTO sch_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Pathien sabei senkhatin Stephan ruok hah an phûma, mulungna takin an châ zoi. ");
INSERT INTO sch_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sual chu koiindang minboipai rang bôkin in tina a lûta, iempungei nupang, pasal a kaisuo ngeia intâng ina a khum ngei zoi. ");
INSERT INTO sch_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Iempu khuotina chekinchâi ngei hah muntina an sea, thurchisa an ril tira. ");
INSERT INTO sch_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Philip chu Samari khopuilien a lûta, an kôm Khrista thurchi a rila. ");
INSERT INTO sch_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Mipuingeiin Philip chongril an rieta, sininkhêl a tho ngei an mûn chu a chongril ngei hah asân an rangâia. ");
INSERT INTO sch_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ramkhoringei hah inringtakin in-iekin mi tamtak sûng renga an hong jôka, phalkhatthi le kholra tamtak khom a mindam ngeia. ");
INSERT INTO sch_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ha khuo mingei hah an râisân tataka. ");
INSERT INTO sch_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ma khopui han mi inkhat a riming Simon, dôithei a oma, mi inlal takin an bea, Samari mingei han a dôi hah an kamâm tataka. ");
INSERT INTO sch_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Khopuilien sûnga mi murdi, achîn alienin a chong asân an rangâia, “Hi mi hih Pathien sinthotheina roiinpui an ti hah ani,” an tia. ");
INSERT INTO sch_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","A mitphildôi hah zora sôttak kamâm tataka an lei ti zoi sikin a chong kamâm omtak hah an rangâi ngâia. ");
INSERT INTO sch_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Aniatachu Pathien Rêngram thurchisa le Jisua Khrista riming Philip'n a ril hah an iem le chu nupang, pasalin baptisma an changa. ");
INSERT INTO sch_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon khomin a iema; baptisma a chang zoia, Philip kôm han aom bang ngâia, sininkhêl kamâmruoi a sinngei hah a mua kamâm aom sabak a tia. ");
INSERT INTO sch_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jerusalema tîrton omngei han Samari khuoa omngei chu Pathien chong an pom zoi tih an rieta Peter le John an kôm an tîra. ");
INSERT INTO sch_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Anni hah an tungin chu a iempu thar ngeiin Ratha Inthieng an chang theina rangin chubai an thope ngeia. ");
INSERT INTO sch_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","An lâia tute chunga khom Ratha Inthieng la chum mak; Pumapa Jisua riminga baptisma an chang vai kêng ala ni. ");
INSERT INTO sch_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Hanchu Peter le John'n an lu chunga kut an minngama, male Ratha Inthieng an chang zoi. ");
INSERT INTO sch_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Tîrtonngei han iempungei chunga kut an min ngamin Ratha Inthieng pêk an ni ti, Simon han amûn chu, Peter le John hah sum a pêk ngeia, ");
INSERT INTO sch_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Hi anga sinthotheina hi mi pêk roi, tu chunga khom ku kut ki minngamna chita Ratha Inthieng an chang theina rangin,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Hannisenla, Peter'n a kôm han, “Nangma le nu sum hih meidîla se rese, Pathien manboipêk suma rochôk rang no bôk sikin! ");
INSERT INTO sch_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Kin sinna hin kopna le rangtum dôn mak che, nu mulungrîl Pathien mitmûn adikloi sikin. ");
INSERT INTO sch_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Masikin, hih no bôkna saloi renga hi insîr inla Pumapa kôm invûi roh, ni mindon hih nang ala ngâidam theina rangin. ");
INSERT INTO sch_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Mulungrîl bôkna khâtak ne pêla, sietnân nang a khitrap iti nang ki riet,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon'n Peter le John kôm, “Nin ti ngei hi inkhat luo ku chunga atung loina rangin nangnin rangâihoitak Pumapa kôm chubai mi thope roi,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Peter le John'n an thurchi le Pumapa thurchi an misîr zoiin chu Jerusalema an kîr nôka, lampuia Samari rama khuo tamtaka Thurchi Sa an misîra. ");
INSERT INTO sch_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Pumapa tîr vântîrtonin Philip hah a chongpuia, “Inthok inla, Jerusalem renga Gaza panna lampuia saktieng ramchâr pielna han se roh,” a tia. (Atûn hin chu hi lampui hih mang nikhâi mak.) ");
INSERT INTO sch_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Masikin Philip ânthoka a sea. Ethopia rama mi inkhat an Rêngnu nuoia sinpêl milien inlaltak a sum murdi enkolpu, Jerusalema Pathien chubaimûk rangin a sea. A kîr nôk tieng chu tali chunga chuongin dêipu Isaiah lekhabu a porea. ");
INSERT INTO sch_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ratha'n Philip kôm, “Tali so va pan inla vanâi roh,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Hanchu Philip a tâna, dêipu Isaiah lekhabu a pore hah a rieta, no pore hah ni rietthei mo? tiin a rekela. ");
INSERT INTO sch_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","“Ama'n tutên mi rilminthâr pe loiin i angin mo ki riet thei ranga?” tiin a thuona. Hanchu Philip ha tali chunga a kala a kôla insungpui rangin a koia. ");
INSERT INTO sch_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Pathien lekhabu a pore hah ma hi ani: “Belri that rang angin belri angin ama hah an tuonga, Belrite a mul eplâitak khomin a dâirek angin, Chongbai khat luo ti maka. ");
INSERT INTO sch_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ântem lâiin a roijêkna hah lâkpe'n a oma. A richisuonpârngei thurchi tûn mo ril ta nih, Rammuol renga a ringna ahek zoi sikin,” ti hi. ");
INSERT INTO sch_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Milien han Philip kôm han, “Ni ril ta, dêipu hin tu thurchi mo a misîr? Ama thurchi mo, midang thurchi mo?” tiin a rekela. ");
INSERT INTO sch_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Hanchu Philip'n, hi Pathien lekhabua phutin Jisua Khrista Thurchi sa a rila. ");
INSERT INTO sch_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","An sea suk an chumin chu, tui omna an tunga, milien han “mahin tui aom, baptis ka chang loina rangin imo mikhap?” a tia. ");
INSERT INTO sch_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Philip'n a kôm, “Nu mulungrîl murdi'n ni iemin chu na chang thei,” a tia. Ama han, “Ki iem,” Jisua Khrista chu Pathien nâi ani ti ki iem, tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Hanchu, tali ha an min ngama, an chuma Philip le milien hah tuia an juong sea. Philip'n Ethopia milien hah baptis a min changa. ");
INSERT INTO sch_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Tui renga an hong jôka, Pumapa Ratha Inthiengin Philip hah a lâk min manga, ama hah mu khâi maka, hankhom râisântakin a in tieng a sea. ");
INSERT INTO sch_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Philip chu mingeiin Azotus khuoa an mu nôka, hanchu a sea, Caesarea khuo a tung mâka chu khopui murdia Thurchi Sa a misîr tira. ");
INSERT INTO sch_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saul han Pumapa jûipungei hah en nuom ngei maka, anrêngin that let rang aphuta. Hanchu Ochai Inlalngei kôm a sea. ");
INSERT INTO sch_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Damascusa Khuoa Synagog mingei kôma pêk rang lekha a min mizieka, ma khuo han a nuom lam takin sin a thothei tiin an lei rietna rang ani, tukhom Pumapa jûi mi amûn chu nupang mo, pasal mo, a sûra Jerusalema a hongtuong theina rangin. ");
INSERT INTO sch_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Hanchu, Saul hah Damascusa a tung rangtôn, inningloi rengin invân renga vârin ajuong êla. ");
INSERT INTO sch_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","pila ânlet paia, rôl miring a rieta, “Saul, Saul! ithomo ma angtaka dûk mini tho hih?” a tia. ");
INSERT INTO sch_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Hanchu, Saul han, “Pumapa tumo ni ni?” tiin a rekela. Hanchu, rôl miring han, “Keima Jisua, dûk ni mintong bângpu hah ki ni.” ");
INSERT INTO sch_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“Nikhomrese, inthoi inla khopuilien sûnga va senla, mahan ni sintho rang nang lei ril an tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saul leh munkhata se ngei chu, chong theiloi le a mindona chang riet loiin, an inding chiena, rôl miring hah chu an rieta, aniatachu tute mu mak ngeia. ");
INSERT INTO sch_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saul hah nuoi renga ânthoia male a mitngei ahong menga, hannirese, tute muthei khâi maka, a kuta an kaia Damascusa khuo tieng an sepuia. ");
INSERT INTO sch_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Sûnthum dôr chu khoite muthei loi le sâk nêk khom sâk thei loiin a oma. ");
INSERT INTO sch_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ma zora han Damascusa khuoa Khristien iempu mi inkhat a riming Ananias a oma. Inlârnân Pumapa a mua, “Ananias!” a tia, Ananias'n, “Pumapa hin ko om,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Pumapa han a kôm, “Ananias insiem inla, Lamlien Tûn son va sênla, Judas ina Tarsus mi a riming Sual an ti hah va rok roh, ama'n chubai a tho tit. ");
INSERT INTO sch_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Male inlârnân mi inkhat a riming Ananias a sea, a mitngei minvâr pe rangin a lu chunga a kutngei minngamin chubaitho pe rangin nang a lei mu zoi,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias'n, “Pumapa ma miriem han Jerusalema khuo mingei dûk amintong lam mi tamtak ngeiin min rila. ");
INSERT INTO sch_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Male atûnhin khom Damascusa khuoa nang jûipungei, sûrna rang phalna lekha ochaisingei kôm renga a dôn,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pumapa han, “va se roh, ama hah ki sinthopu rangin ka thang zoi, hi Jentailngei, Rêngngei le Israel mingei ki riming min riet ranga ki tîr rang ani. ");
INSERT INTO sch_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Keima sikin idôrmo dûk a la tong rang nang la ril ki tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Masikin Ananias hah a sea, Saul omna ina a lûta, male Saul chunga a kutngei a minngama “Sungsuok Saul ni mit vâr nôkna rang le Ratha Inthieng sipa no om theina rangin no hongna lampuia na kôma inlârpu Pumapa Jisua'n ni hongtîr ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Harenghan, a mitngei renga ngalip angati ajuong tâka, a mitngei ahong vârpe nôka. Hanchu ânthoia baptis a changa; ");
INSERT INTO sch_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Male bu, an, a nêka a hong har nôk zoi. Saulin sûn tomte Damascusa iempungei kôm oma. ");
INSERT INTO sch_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Synagog taka a lût pata Khrista thurchi a rila, Jisua chu Pathien nâipasal ani tiin a ril phut kelen zoia. ");
INSERT INTO sch_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","A chongril riet ngei murdi'n asân an kamâm tataka, “Hi mi hih Jerusalema Jisua riming ralam ngei dûk lei mintong ngâipu hah nimak mo? Ha mingei hah khita ochaisingei kôma tuong ranga mahin khom a hong nimak mo?” an tia. ");
INSERT INTO sch_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Hannirese Saul chongril hah ranak a dôn teteta, male Jisua chu Khrista ani tiin a ril minthâr han mi a mene thei oka, Damascus taka aom Judangei khomin makhal thei khâi mak ngei. ");
INSERT INTO sch_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Sûn tamtak suole chu Saul that rangin Judangei lungvâr an thoa, ");
INSERT INTO sch_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","hannirese ama'n an lungvâr tho hah a rieta, that rang bôkin rukul mokot tina sûn le jân an muruonga. ");
INSERT INTO sch_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Hannirese a nûkjûingeiin Saul an tuonga, jâna rukul kotvêng renga kok leh makhâiin an musum zoi. ");
INSERT INTO sch_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Hanchu Saul hah Jerusalema a sea, ruoisingei inloppui rang a bôka, hannirese anni han ruoisi ani sa ti iem mak ngeia, anrêngin achiin an chia. ");
INSERT INTO sch_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Hanchu Barnabas a tuonga tîrtonngei kôm a sepuia. Lampuia Pumapa a mu tie ngei, Pumapa'n a kôma a ti pe ngei, Damascusa taka Jisua riminga hâitaka chong a ril tie ngei an kôm a misîr pe ngeia. ");
INSERT INTO sch_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Male Saul hah an kôm a om zoia, Jerusalem pumpuia hâitakin Pumapa rimingin chong a rila. ");
INSERT INTO sch_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Greek chong mangin Judangei lâia chong a rila, a makhala, anni rêkin chu that rangin an pûta. ");
INSERT INTO sch_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ha chong hah koiindang mingeiin an rietin chu Saul hah Caesarea khuo an tuonga, Tarsus khuoa an tîr pat zoi. ");
INSERT INTO sch_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Male Judea ram, Galilee ram le Samari ram pumpuia koiindang hah dengtheina an jôk zoia. Pumapa mân thôn an oma, Ratha Inthieng ompuinân an rât uola, an mijôn ahong pung tetet zoia. ");
INSERT INTO sch_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Peter'n muntina a chaia, sûnkhat chu Ludda khuo Pathien mingei omna a juong sea. ");
INSERT INTO sch_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Mahan mi inkhat a riming Aeneas an ti kum riet phalkhatthi sika jâlmuna jâl a mua. ");
INSERT INTO sch_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Peter'n a kôm han, “Aeneas, Jisua Khrista'n nang a mindam zoi inthoi inla na jâlmun luok roh,” a tia, hanchu harenghan ânthoia. ");
INSERT INTO sch_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ludda le Sharona mi murdi'n ama an mua Pumapa tieng an hong inhei zoi. ");
INSERT INTO sch_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Joppa khuoa han Jisua lei iem nuvengte inkhat a riming Tabitha a oma. (Greek riming Dorcas, mahi, “sakhi,” tina ani.) Amanu han azora dôn murdi sin sa le inriengngei sannân a lei mang ngâi ani. ");
INSERT INTO sch_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ma zora han dam maka, a thi zoia, tui an min buola inchunginchuon khâltana an min jâla. ");
INSERT INTO sch_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ludda khuo hah Joppa khuo kôl ani sikin, iempungeiin Peter Ludda khuoa aom ti an rieta, “Rangâihoitakin inrangralin mi hong pe roh,” tia koi rangin mi inik an tîra. ");
INSERT INTO sch_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Masikin Peter inthoiin anni ngei lehan an sea. A tung leh an inchunginchuon khâltan sûnga an tuonga. Dorcas kôla indingin meithâingei tamtakin an chapa, an kôm aom lâia kâncholingei le puonngei hah a sûi ngei hah Peter an min mua. ");
INSERT INTO sch_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Peter'n anrêngin pêntieng a mojôk ngeia, male Khûkinbilin chubai a thoa, hanchu ruok tieng ânheia, “Tabitha inthoi roh,” a tia. Tabitha hah a hong menga Peter hah a mua, a hong insunga. ");
INSERT INTO sch_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Peter'n a kut a pêka a kaithoia, hanchu iempungei le meithâingei a koia, Tabitha hah aringin a pêk ngei zoi. ");
INSERT INTO sch_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ma roi hah Joppa khuoa ânthang zita, mi tamtakin Pumapa an hong iem zoi. ");
INSERT INTO sch_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Peter chu sûn tamtak Joppa khuo savun sinngâipu Simon ina ala châma. ");
INSERT INTO sch_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Caesarea khuo mi inkhat a riming Cornelius an ti, “Rom râlmi pâl raza-ruoipu a oma” maha Italy râlmi an ti ngâi. ");
INSERT INTO sch_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ama hah Pathien biek mi ania, ama leh a insûng mingei nâm anrêngin Pathien lei biek ngâi an ni. Judangei lâia inriengngei sanin asân ranak a song ngâia, Pathien kôma khom chubai a tho bang ngâia. ");
INSERT INTO sch_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Sûnkhat chu chonûk dâr thumin inlârna inthârlak a mua, Pathien vântîrton inkhat a kôm ahong lûta, “Cornelius!” a hong tia. ");
INSERT INTO sch_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cornelius'n ama hah a en ngita, a chia, “Pu mahi imo?” a tia. Vântîrtonin a thuona nu chubaithona le nu lungkhamna sinngei hah Pathien'n a râisânna nang a thuon rang ke ani zoi. ");
INSERT INTO sch_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Atûn Joppa khuoa mi tîr inla, mi inkhat a riming Simon Peter an ti hah hong min koi roh. ");
INSERT INTO sch_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Savun sin ngâipu Simon ina a tunga, a in chu tuikhanglien panga aom a tia. ");
INSERT INTO sch_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Hanchu vântîrton hah a rot suole, Cornelius'n a tîrlâmngei mi inik le râlmi inkhat, Pathien biek ngâi a tîrlâma a mang ngâi a koia. ");
INSERT INTO sch_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","A mu le a riet murdi a ril zoiin chu Joppa khuoa se rangin a tîra. ");
INSERT INTO sch_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Anangtûka an sea, Joppa khuo kôl an tungin chu, Peter hah chubaitho rangin sûna inchunga a kala. ");
INSERT INTO sch_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","A von a châm sabaka, bunêk rang a nuoma hannisenla nêk rang a mintuo lâitakin inlârna a mua. ");
INSERT INTO sch_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Invân in-ongin puon lienpa arikil minlia inthung invân renga nuoia juong chum a mua. ");
INSERT INTO sch_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ha sûng han sa ake minli jât tamtakngei le rama vângei an omna, a rôpa intolngâi ngei. ");
INSERT INTO sch_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","A kôm han rôlin, Peter, “Inthoi roh; that inla sâk roh!” a tia. ");
INSERT INTO sch_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Hannisenla Peter'n “Pumapa nimak! ânthiengloi le porinche ite sâk ngâi mu ung” a tia. ");
INSERT INTO sch_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Rôl han avêlin a kôma, “Pathien'n ânthieng zoi a ti hih nangman ite ânthiengloiin mindon no roh,” a ti nôka. ");
INSERT INTO sch_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ha anghan, voithum ajuong oma, masuole chu invân tieng lâk paiin a om nôk zoi. ");
INSERT INTO sch_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Hanchu, Peter'n inlârna a mu hah a mindonna chang riet loiin a om lâitak han, Cornelius mi tîr ngei hah Simon in rekelin mokot kôla an lên dinga. ");
INSERT INTO sch_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Mahin Simon Peter a tung mo? tiin an rekela. ");
INSERT INTO sch_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Peter'n inlârna ai mu hah a mindon lâitakin, Ratha'n a kôma, “Rangâi roh! Mi inthumin nang an rok. ");
INSERT INTO sch_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Masikin inthok inla chum roh, ite kamâm loiin jûi ngei roh, anni hah ko hongtîr ngei ke” a tia. ");
INSERT INTO sch_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Masikin Peter hah a chuma, an kôm han, nin rokpu hah “Keima ki ni, imo nin hongna abi?” a tia. ");
INSERT INTO sch_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Anni han, “Râlmi raza ruoipu Cornelius mi hongtîr ani. Ama hah mi sa Pathien biek ngâi mi le Juda mi murdi'n mirit an tho ngâi mi ania. Pathien vântîrtonin nangma hah a ina koi rangin a tipea, no chongril rangâi rangin” an tia. ");
INSERT INTO sch_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ha mingei hah a koi lût ngeia, a min riek ngeia. Anangtûka ânthoka anni ngei leh, Joppa khuo iempu senkhat ngei le munkhatin an sea. ");
INSERT INTO sch_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Anangtûk nôka chu Caesarea khuo an tung zoia, Cornelius han a sûngsuokngei le a ruolngei a koibûma, Peter ngei an lei ngâk chiena. ");
INSERT INTO sch_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Hanchu Peter ava lût rangtôn Cornelius'n a lei dônna, a ke bula khûkinbilin chubai a mûka. ");
INSERT INTO sch_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Aniatachu Peter'n ama hah a kaithoia, “Inding roh, kei khom miriem dên ke ki ni,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","A kôm chong pumin insûnga a lûta, mi tamtak intûp ngei hah ava mua. ");
INSERT INTO sch_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","An kôm han, “Juda mîn, Juda mi niloi pan rang le inloppui rangin Juda balamin phal mak ti nangni rengin nin riet. Hannirese, tute inthiengloi le annima ke be loina rangin Pathien'n mi min mu ani. ");
INSERT INTO sch_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Masika han mi nin hong min koia han, ite makhal viet loiin ko hong kelen ani. Masik han nangni ki rekel imo mi nin hong koina bi?” a tia. ");
INSERT INTO sch_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelius'n a kôma, “Atûn zora tena hin sûnthum ani zoi. Chonûk dâr thum vêlin ki ina chubai ko thoa; harenghan mi inkhat puon chêk invo ka makunga a juong indinga. ");
INSERT INTO sch_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‘Cornelius! Pathien'n nu chubaithona a riet zoi, nu lungkhamna sin ngei khom a riettit. ");
INSERT INTO sch_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Masikin Joppa khuoa mi tîr inla Simon Peter hong min koi roh, ama hah tuikhanglien panga savun sin ngâipu Simon ina a tung ani’ a tia. ");
INSERT INTO sch_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Male han no kôm mi ko hongtîr kelena; no hong hih râisân aom sabak. Pumapa'n chongril ranga nang a pêk riet rangin atûn hin Pathien mitmu'n kin rêngin kin om ani hi,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Peter a hong chonga hi anghin a tia: “Pathien'n jâttin le namtin in-angsara a en ti ki riet minthâr zoi. ");
INSERT INTO sch_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Namtin lâia tukhom ama iema sin asa thopu murdi chu ama khôk thei mi anni ngâi. ");
INSERT INTO sch_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ama'n, mi murdi Pumapa, Jisua Khrista han Israel mingei kôma rangin inchamna râisânna Thurchi Sa chu a juong mintunga. ");
INSERT INTO sch_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","John'n Baptis roi a ril suole Galilee ram renga a phuta, Judea ram pumpuia a roi a chongril hah nin lei rieta. ");
INSERT INTO sch_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nazareth Jisua chu Pathien'n Ratha Inthieng le sinthotheinân min silin, Pathien han a ompui tita, sin sa thoa muntina a chai lâihan Diabol dûkmintong murdi ngei a mindama. ");
INSERT INTO sch_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Judea ram le Jerusalema a sintho murdi rietpuipungei kin ni, ama hah Khrosa jêmdelin an that ani. ");
INSERT INTO sch_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Hanniresea, Pathien'n sûnthum suole a kaithoia mu theiin ânlâra, ");
INSERT INTO sch_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","mitin mitmua chu inlâr maka, Pathien'n a rietpuipu ranga a lei thang keini ngei vai hin kin mu, ânthoinôk suole han Ama lehan kin sâkin kin nêk suom ngâi ani. ");
INSERT INTO sch_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Male hah thurchisa ril rang le Ama hah mi ring le mithi chunga roijêkpu'n Pathien'n a phun ti mi murdi min riet rangin chong mi pêk ani. ");
INSERT INTO sch_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Dêipungei murdi khomin ama iem murdi'n a riming sikin an sietnangei ngâidam nîng an tih,” tiin an lei ril ngâi a tia. ");
INSERT INTO sch_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Peter chong a la ril bang lâiin, a chongril rangâi murdi chunga Ratha Inthieng ajuong chuma. ");
INSERT INTO sch_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Juda iempungei Joppa khuo renga Peter hong jûipungei han Ratha Inthieng neinun pêk Jentailngei chunga khom ivur ani ti an rieta an kamâm oka. ");
INSERT INTO sch_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Chong rietloia chongrilin le Pathien roiinpuina minpâkin an rieta, Peter'n a thuona, ");
INSERT INTO sch_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Hi mingei hi kin chang anga Ratha Inthieng an chang ania, tuia baptis chang rangin tumo khap thei ngei ranga?” a tia. ");
INSERT INTO sch_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Masikin Jisua Khrista riminga baptis chang rang chong a pêk ngeia. Hanchu anni kôm han sûn tômte la châm rangin an ngêna. ");
INSERT INTO sch_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Judea ram pumpuia tîrtonngei le iempungei hah Jentailngei khom Pathien chong an rieta an lei modôm zoi. ");
INSERT INTO sch_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Peter hah Jerusalema a sea, hanchu sertan ngei han ama an lei dema, a kôm, ");
INSERT INTO sch_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Sertanloi Jentailngei ina nu tunga an kôma sâk khom na sâk ngâi!” an tia. ");
INSERT INTO sch_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Masikin Peter'n abul renga anrêngin aroi omtie murdi a misîrpe ngâia. ");
INSERT INTO sch_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Joppa khopuiliena chubai ko tho lâiin, inlârna ku mua. Puon chêk lientak anghan arikil minlia inthung invân renga juong musum ko kôla juong om ku mua. ");
INSERT INTO sch_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mahan anâikikin ke enna insûng sa le ram sa, rôpa intol ngâi le vângei ku mua. ");
INSERT INTO sch_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Masuole chong mirîng ki rieta ko kôm, ‘Inthoi roh Peter; that inla sâk roh,’ a tia. ");
INSERT INTO sch_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Hannirese keiman ‘Nimak Pumapa! ânthieng loi le ânnim ite ka bâia lût ngâi mak’ ki tia. ");
INSERT INTO sch_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Invân renga rôl han avoiniknân, ‘Pathien'n ânthieng a ti sai hi nangman inthieng mak tino roh!’ a ti nôka. ");
INSERT INTO sch_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ma anghan voithum ajuong oma masuole azoinataka chu invân tieng lâk pâiin a oma. ");
INSERT INTO sch_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ma zora tak han Caesarea renga mi inthum hongtîra om ngei hah ko omna in an hong tunga. ");
INSERT INTO sch_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ratha'n mulung inlakloia anni ngei jûi ngei rangin mi rila. Hi iempu uruk Joppa renga Caesarea hong ngei khom min jûisa kin rêngin Cornelius ina kin lûta. ");
INSERT INTO sch_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ama han a ina vântîrton inding a mua, vântîrton han a kôma, Joppa khuoa mi tîr inla mi inkhat a riming Simon Peter an ti hah hong minkoi roh. ");
INSERT INTO sch_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ama han chong nang misîrpe a ta, ama chong han nangma le ni insûngmingei sânminjôkin om nin tih, tiin khom mi ril sa. ");
INSERT INTO sch_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Chongril ko hong phut lehan motona ei chunga ajuongtung anghan Ratha Inthieng an chunga ajuongtunga. ");
INSERT INTO sch_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Male Pumapa'n a ti ‘John'n tui le mi a baptis ania, nangni chu Ratha Inthiengin baptis la chang nin tih,’ a ti hah ki rietsuok nôka. ");
INSERT INTO sch_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Pumapa Jisua Khrista ei iema ama chongpêk nanâk hah Jentailngei khom a pêk ani ti ânthâr ani. Kei hih tumo ki ni, Pathien khap rang bôkpu hi!” a tia. ");
INSERT INTO sch_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ma chong hah an riet lechu dem khâi mak ngei, Pathien an minpâka, “Pathien'n Jentailngei khom insîra ring rangin zora inchum a pêk ani hi!” an tia. ");
INSERT INTO sch_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Hanchu Stephan an that zora dûkmintongna sika chekinchâi ngei hah Phoenicia Ram, Cyprus tuikul le Antioch khuo dênin an sea Judangei kôm vai thurchi an rila. ");
INSERT INTO sch_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Hannirese, iempu senkhat: Cyprus tuihuol le Cyrene a mingei hah Antioch'a an sea, Jentailngei kôm khom Thurchi Sa an misîra, Pumapa Jisua Thurchi Sa an rila. ");
INSERT INTO sch_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Pumapa ranakin a san ngeia, mi tamtakin an iema, Pumapa tieng an inhei zoia. ");
INSERT INTO sch_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ma thurchi hah Jerusalema koiindang ngeiin an lei rieta, masikin Barnabas hah Antioch taka an tîra. ");
INSERT INTO sch_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ama hah a tungin chu mataka mingei Pathien'n satavur tie hah a mûn chu a râisân tataka, an mulungngei murdia Pathien taksônna om mindet rangin anrêngin a mohôk ngeia. ");
INSERT INTO sch_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas hah mi satak, Ratha Inthieng le iemna sip ania, masikin mi tamtak Pumapa tieng a tuong zoia. ");
INSERT INTO sch_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Hanchu Barnabas hah Saul rokin Tarsus khuoa a sea. ");
INSERT INTO sch_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","A mu lehan Antioch tieng a hong tuonga, kum khat piel koiindangngei inkhômna an inchel ngâia, mi tamtak an minchu sa ngâi. Antioch'a han kêng iempungei hah Khristien an ti masatak. ");
INSERT INTO sch_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ma zora han Dêipu senkhat ngei Jerusalem renga Antioch an sea. ");
INSERT INTO sch_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","An lâia mi inkhat a riming Agabus ândinga rammuol pumpuia mâitâm natak chul atih, ti ratha min rietin a phuonga; ha mâitâm hah Claudius inlal lâiin atung zoi. ");
INSERT INTO sch_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ha anghan, ruoisingei han an thei lam chitin Judea rama iempungei kôm sanna muthuon rang an masata. ");
INSERT INTO sch_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ma hah an thoa masuole sum han koiindang upangei kôm pêk rangin Barnabas le Saul kuta an muthuon zoi. ");
INSERT INTO sch_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Hanchu, ma zora han, Rêng Herod'n koiindanga mi senkhat ngei a nunuom a lo zoia. ");
INSERT INTO sch_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Jacob, John nâipa hah khandaiin a tuk thata. ");
INSERT INTO sch_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ama han Judangei an râiasân ok ti a rietin chu Peter khom sûr rang a bôk tita. (Ma zora hah cholboivâipôl ruolhoi zora ani). ");
INSERT INTO sch_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Peter hah a sûr suole chu intâng ina a khuma, râlmi pâl minli minlin angâk an inthâklîpa. Kalkân kût ruolhoi chumin mipui makunga kai suoa jêk rangin a mintuo ani. ");
INSERT INTO sch_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Masikin Peter hah intâng ina a khum rapa, hannirese, ama ta rangin koiindangngeiin ningsiettakin Pathien kôm chubai an thope ngâi. ");
INSERT INTO sch_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herod'n a kai suoa, a jêk rang nijân tak han chu Peter hah rungpungei inik kâra rênrokol inik bunin a jâla, a ngâkngei khom mokot bula an oma, an ngâk chiena. ");
INSERT INTO sch_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Inningloiin vântîrton inkhat a kôla ajuong indinga intâng in sûnga han vâr ajuong inlanga. Vântîrton han Peter dâra anîk min hara, “Inrangin! inthoi roh!” a tia. Hanchu, voikhatrengin Peter kuta rênrokolngei hah a kutngei renga a tâkrila. ");
INSERT INTO sch_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Masuole Vântîrton han a kôm, “No kongkhit mindên inla, ne kekok bun roh,” a tia. Peter'n ha anghan a thoa, hanchu vântîrton han a kôm, “Na kâncholiinchuol inhak inla, mi jûi roh,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Peter intâng in renga a jôka, a jûi zoia; nikhomrese a tak ani ti riet mak, Vântîrton hah inlârna a mu mini kêng a bôka. ");
INSERT INTO sch_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","A rungngei inkhatna le inikna an khêlin chu khopuiliena lûtna thîr mokot an va tunga. Mokot hah athethenin alei in-onga, an jôka, lamlien inkhat an khêlin chu voikhatrengin vântîrton han Peter a mâk zoia. ");
INSERT INTO sch_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Hanchu Peter hah a harin chu, “Pumapa'n a vântîrton a juongtîra, Herod kut renga le Judangei sabeina murdi renga mi mojôk ti adiktakin ki riet zoi,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","A mulung a min chong zoiin chu John Mark nû Mary ina a sea, mahan mi tamtak lên bûmin an lei chubaia. ");
INSERT INTO sch_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Peter'n bokrop inkhâr a tôk lehan, tîrlâm inkhat Rhoda dôngmate han mo-ong rangin a sea. ");
INSERT INTO sch_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Peter rôl a riet lechu a râisân rai sikin inkhâr mo ong loiin a tân nôka, “Peter inkot bula son ânding,” tiin a va rila. ");
INSERT INTO sch_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Anni han a kôm, “Na châng ani zoi hi!” an tia. Ama'n chu adik tatak kêng? a ti tita. Anni han “a vântîrton nîng atih,” an tia. ");
INSERT INTO sch_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Nikhomrese Peter'n a tôk tita nûktaka chu an va mo onga, ama hah an mua kamâm aom an ti tataka. ");
INSERT INTO sch_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ama han an dâirekna rangin a kut a jâpa, Pumapa'n intâng in renga a kêlsuo tie hah a misîr zoia. Hanchu, “Hi chong hih Jacob le iempu dangngei va ril roi,” a tia. Masuole chu a jôka ram danga a se zoi. ");
INSERT INTO sch_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Hanchu, jîng ahongni lechu rungpungei hah, Peter imo a chang zoi? tiin asân an mulung ajîng zoia. ");
INSERT INTO sch_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herod han a rok rangin chong a pêk ngeia, hannirese mu mak ngeia a ngâkngei hah a rekela, that ngei rangin chong a pêk ngei zoi. Masuole chu, Herod judea khuo a mâka Caesarea khuoa môrkhat ava om zoi. ");
INSERT INTO sch_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Hanchu, Herod hah Tyre le Sidon khuo mingei chunga a taksi sabaka. Anni han inruolin ama kôm se rangin an honga, rêng milien Blastus hah an malin an sin baka. Masuole Herod kôm an sea, an ram hah rêngpa ram renga sâk, nêk an man ngâi ani sikin inngêi rangin an ngêna. ");
INSERT INTO sch_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","A nikhuo khâm nîn chu Herod hah puon inlal insilin rêngsukmuna ânsunga, mipuingei kôm chong a misîra. ");
INSERT INTO sch_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Mi murdi'n, “Miriem rôl nimak, Pathien rôl kêng,” an tia, an inieka. ");
INSERT INTO sch_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Voikhatrengin ama han Pathien kôm miritna a pêk loi sikin Pumapa vântîrtonin voikhatrengin Herod chunga a kut a musuma, rûlkûtin a sâka, athi zoi. ");
INSERT INTO sch_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ma lâia han Pathien chong ânzara an pung tir zoi. ");
INSERT INTO sch_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas le Saul'n an sintum an sin suole chu Jerusalem renga an kîr nôk zoia, John Mark hah an kôm an tuong sa. ");
INSERT INTO sch_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Hanchu, Antioch koiindangngei lâia Dêipungei le minchupungei an oma; Ma ngei hah Barnabas ngei, Simeon (miduk an ti) ngei, Cyrene khuoa Lucius ngei, Manaen (Râiôt Herod'n a vâi minlien) ngei le Saul ngei an ni. ");
INSERT INTO sch_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Pumapa sin an thoa, bu an ngêi lâiin Ratha Inthiengin an kôm, “Barnabas le Saul hih ko koina lama sintho rangin mi pêk roi,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Bungêiin chubai an tho zoiin chu an chunga kutngei an minngama, an tîr ngei zoi. ");
INSERT INTO sch_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ha anghan, Ratha Inthieng tîrin an sea, Seleucia khuo an tunga, ha mun renga Cyprus tuihuola rukuongin an se zoia. ");
INSERT INTO sch_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Hanchu, Salamis khuoa an tungin chu Judangei Synagog ngeia Pathien thurchi an misîra. John Mark hah an insanpui rangin an tuong sa. ");
INSERT INTO sch_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tuihuol hah Paphos dênin an chai suoa, dôithei, dêipu inti Juda inkhat a riming Bar-Jisua an tonga. ");
INSERT INTO sch_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ama hah tuihuol râiôt Sergius Paulus mi vâr tak khom a malpa ania. Ha râiôt han Pathien chong rangâi a nuom sikin Barnabas le Saul a koia. ");
INSERT INTO sch_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Hannirese, dôipu Elimus (Greek riming) han râiôt hah takminsôn loi rang pûtin anni hah a lei deia. ");
INSERT INTO sch_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Hanchu Saul, Paul an ti sa ngâi hah Ratha Inthiengin a sipa, dôipu hah a en ngita, a kôm, ");
INSERT INTO sch_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","male “Nangma khori nâipasal! satnangei nâm râlpa, milak ngei nâmin ni minsipa, zoratin Pathien chongtakngei hih chong milak min chang rang no bôk ngâi ani. ");
INSERT INTO sch_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Atûn Pumapa kut nu chunga achum rang ani, ni mit jîng a ta, sûn khovâr mu khâino tini,” a tia. Sûm le ijîngin ama hah abok kelen zoia, a kairuoi rang mi zongin ânvâk titira. ");
INSERT INTO sch_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Râiôt han ahong mu lehan khoimo atung hah, a iem zoia; Pumapa minchuna chungroi hah a kamâm oka. ");
INSERT INTO sch_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paul le a champuingei hah Paphos khopuilien renga rukuongin an sea, Pamphylia rama Perga an tunga, mahan John Mark'n anni hah a mâka, Jerusalema a kîr nôk zoia. ");
INSERT INTO sch_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Anni hah Perga renga an se tita, Pisidia rama Antioch an tunga, male Sabbathnin chu Synagog taka an lûta, an insunga. ");
INSERT INTO sch_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Moses balam le dêipungei lekhabungei an miziekngei hah an pore suole chu Synagog ulienngeiin an kôm mi an tîra: “Sûngsuokngei, mohôkna chong nin dôn aomin chu mipuingei kôm misîr rangin nangni kin nuom ani,” an tia. ");
INSERT INTO sch_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paul ândinga, a kutin a jâpa, thurchi misîr a phut zoia: “Ki Israel champuingei le Jentialngei murdi Pathien biek ngei, ko chong rangâi roi! ");
INSERT INTO sch_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israelngei Pathien mingei ei richibulngei a lei thanga, Egypt khuolmingei anghan an om lâiin nam lienpân a sina, a ranak lienin Egypt renga a kai suo ngeia, ");
INSERT INTO sch_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","male kum sômminli ramchâra an sinthongei hah a en chien theia. ");
INSERT INTO sch_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Canaan rama nam sari an inmanga, a mingei a ram puma a minchang zoi. ");
INSERT INTO sch_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ma ngei nâm hah Kum raza minli sômrangnga alût ani. “Masuole han roijêkpungei a pêk ngeia, dêipu Samuel dêna han. ");
INSERT INTO sch_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Male Rêng an ngêna, ma anghan Pathien'n Saul, Kish nâipasal, Benjamin rûia mi hah kum sômminli sûnga an rêng rangin a pêk ngeia. ");
INSERT INTO sch_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ama hah an hengpai suole chu Pathien'n David hah an rêng aminchanga, ma chungroi hah Pathien'n hi anghin a misîra; ‘David Jesse nâipasal, ku lungdo mi ka mân zoi, ama han sin ranga ku nuom murdi sin a tih,’ a tia. ");
INSERT INTO sch_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Mahi Jisua, David richisuonpârngei lâi renga han Israel mingei Sanminringpu'n ai sin ani, Pathien'n a lei khâm anghan. ");
INSERT INTO sch_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jisua'n a sin a phut mân han, Israel mingei an sietnangei renga an insîra baptisma an changna rangin John'n thurchi a misîr pe ngei ngâia. ");
INSERT INTO sch_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Male John'n a sintum a zoi rangto han mipuingei kôm, ‘Keima hih tumo ani mi nin ti? nin ngâkpu hah keima hih ni mu ung. Aniatachu, rangâi ta u! ku nûka juong a tih, kei chu a kekok khek rang luo inhoi mu ung,’ a tia. ");
INSERT INTO sch_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Abraham richisuonpârngei, ki richibulngei le Jentailngei murdi Pathien biek ngei, hi Sanminringna chong hih ei kôm a juongtîr ani. ");
INSERT INTO sch_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalema mi omngei le an ruoipungei han sanminringpu ani an riet loi sik le dêipungei chong Sabbathni tina an pore ngâi hah aomtie an rietloi sikin Jisua theiloi min changin dêipungei chong an mintung min dik zoi. ");
INSERT INTO sch_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Thina rang rak dôr a chunga ite abi an man no khomin that rangin Pilat kôm an ngêna. ");
INSERT INTO sch_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Male a chungroi Pathien lekhabu'n a miziek murdi atung suole chu Khros renga an musuma, thâna an min jâl zoia. ");
INSERT INTO sch_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Aniatachu, Pathien'n thina renga a kaithoi nôk zoi, ");
INSERT INTO sch_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Galilee ram renga Jerusalema ama leh munkhata lei se ngei kôm han sûn tamtak ânlâr ngâia; ha mingei hah atûna hin Israel mingei kôm ama rietpuipungei an ni. ");
INSERT INTO sch_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Ei richibulngei kôma Pathien'n chong a lei khâm hah, eini a richisuonpârngei ta rangin Pathien'n atûna hih Jisua kaithoiin atung ani ti Thurchi Sa nangni kin mintung pe. Lapui inikna taka aom anghan. ‘Ka Nâipasal ni ni; Avien hin na Pa ko hongni zoi.’ ");
INSERT INTO sch_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Monna mun thâna kîr nôk khâi loi rangin Pathien'n ama hah thina renga a kaithoi rang roi hi anghin a misîra; ‘Satvurna inthieng le adik David kôma kên khâm hah nang pêk ki tih,’ tiin. ");
INSERT INTO sch_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Masikin, minpâkna la dangin, ‘Ni mi inthieng chu thâna mon rangin phal no ti nih,’ ati sa. ");
INSERT INTO sch_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","David'n ama zora kai chu Pathien lungdo a sina, masuole chu a thia, a richibulngei leh an phûma, a takpum hah thâna amon zoi. ");
INSERT INTO sch_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pathien'n thina renga a kaithoipu ha chu mon mak. ");
INSERT INTO sch_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Ki Israel sûngsuokngei, mahih nin riet rangin kin nuom, Jisua sikin ani sietnangei ngâidamna chong nin kôma misîrin aom; male tukhom ama iem kai chu Moses balamin a mojôk theiloi sietnangei murdi renga an jôk zoia. ");
INSERT INTO sch_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Masikin, indîn roi, dêipungei lei ti hah nin chunga tung duoi nih. ");
INSERT INTO sch_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Mumâkpungei, en ta u! kamâm aom ti ungla, thi roi! asikchu aviena sin ko tho hih, Mîn nangni ril minthâr pe khom rese ngei iem no tunui!’ ” ti hah a tia. ");
INSERT INTO sch_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paul le Barnabas hah Synagog renga an jôkin chu sabbathni nôka ma chong hah hong misîr nôk rangin mipuingei han an siela. ");
INSERT INTO sch_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ânbûm ngei an chîn zoiin chu Judangei le an Juda rotholngei tamtakin Paul le Barnabas an jûia, Tîrtonngei han, Pathien moroina nuoi han om tit rangin an mohôka. ");
INSERT INTO sch_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sabbathni nôka chu a khopui pumpui ti dôrin Pathien chong rangâi rangin an hong intûpa. ");
INSERT INTO sch_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Judangei han mipuingei an mûn chu an narsa oka, Paul thurchi misîr hah an makhala, an misîr minpôta. ");
INSERT INTO sch_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Aniatachu Paul le Barnabas han hâi uolin an misîra, “Pathien chong hi nin kôma misîr masa rang piel ani; hannirese, nin henga, kumtuong ringna manpui rangin ahunin nin be loi sikin, nangni mâkin Jentailngei tieng pan kin tih. ");
INSERT INTO sch_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Mahi Pumapa chong mi pêk ani; ‘Jentailngei min vârpu'n nang ki minchang, masikin rammuol murdi an ring theina rangin ti hi,’ ” an tia. ");
INSERT INTO sch_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Jentailngei han ha chong hah an rietin chu an râiasâna, Pumapa chong an chôiminsânga; kumtuong ringna chang ranga thang ngei kai chu iempungei an hong chang zoi. ");
INSERT INTO sch_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Pumapa chong hah ramhuol muntina ânzar zoia. ");
INSERT INTO sch_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Hannirese Khopuiliena Juda ulienngei le Pathien biek mi Jentail nupang mirit omngei an misieta; Paul le Barnabas hah an nuom an min loa, an ramhuol renga an rujûlpai zoia. ");
INSERT INTO sch_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Tîrtonngei han anni ngei chunga an mulung hoiloi minlangnân an kepha taka pildi an không mathâka, Iconium an pan zoi. ");
INSERT INTO sch_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Antioch taka iempungei chu râisânna le Ratha Inthiengin an sip zoi. ");
INSERT INTO sch_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ma angdên han Iconiuma khom Judangei Synagog taka an lûta, thurchi an misîra, Juda le Jentail tamtakin an iem zoia. ");
INSERT INTO sch_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Hannirese a iem nuomloi Judangei han Jentailngei an misieta an min mumâk zoi. ");
INSERT INTO sch_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Tîrtonngei han hâitaka Pumapa thurchi misîrin ha khuoa han sôttak an oma; mahan a lungkhamna chongril tîrtonngeiin an misîr hah adik ti minlangnân an kuta sininkhêlngei le sin kamâmruoingei an sina. ");
INSERT INTO sch_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Khopuilien sûnga mipuingei pâl inikin an insen zoia. Senkhat Judangei tieng, senkhat tîrtonngei tieng. ");
INSERT INTO sch_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Hanchu Jentailngei le Judangei an ruoipungei le tîrtonngei hah lung leh dênga dûkmintong rang an bôka. ");
INSERT INTO sch_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Tîrtonngeiin ma chong hah an lei riet lechu Lycaonia rama Lystra le Derbe khopuilienngei le a kol revêla ram ngeia an rota. ");
INSERT INTO sch_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Mahan annîn Thurchi Sa an misîr tir zoi. ");
INSERT INTO sch_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lystra khuoa mi inkhat a suok renga kholra lôn theiloi a oma. ");
INSERT INTO sch_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Mahan ama ânsunga Paul thurchi misîr a rangâia. Damna ranga iemna a nei ti Paul'n a mûn chu ama hah Paul'n a en ngita, ");
INSERT INTO sch_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","male rôl inringtakin, “Ne ke le injîkzatin inding roh!” a tia. Ama hah ân chôma, a lôn titir kelen zoi. ");
INSERT INTO sch_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Mipuingeiin Paul sintho hah an mu lechu anni Lycaonia chongin an inieka, “Pathienngei miriem changin ei kôm an juong chum ani hih!” an tia. ");
INSERT INTO sch_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Barnabas riming hah Zeus an tia, male Paul hah thurchi misîr uol ngâi ani sikin Hermes an tia. ");
INSERT INTO sch_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Hanchu, Zeus pathien ochai, an biekin, khopui pêntienga om han serâtchalngei le pârthilrûingei mokota a hongchôia, mipuingei lehan tîrtonngei biekna ranga that rangin an mintuoa. ");
INSERT INTO sch_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ma anga tho ranga an mintuo hah Barnabas le Paul'n an riet lechu an puon an potkhêra, mipui lâi tieng tânin an inieka. ");
INSERT INTO sch_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Mahih irang mo nin tho? keini khom nangni anga miriem papai kêng kin ni. Mahin keini hih Thurchi Sa misîr ranga om ke kin ni, hi kâmnângloi neinunngei hih mâka Pathien aring, invân, pilchung, tuikhanglien le an sûnga om murdi Sinpu tienga nin hong kop theina rangin. ");
INSERT INTO sch_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Tiena han chu, Pathien'n mitin an lampui chit jûi rangin a phal ngâia. ");
INSERT INTO sch_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Hannirese ama aom ti rietnân neinun sa nangni thopên a minlang ngâi. Invân renga ruo le chimungei azora taka nangni a pêk ngâia, sâk rang le nin mulungrîla râisâna sip nangni a pêk ngâi” an tia. ");
INSERT INTO sch_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ha chonga han tîrtonngeiin mipuingei chu an kôm inbôlna pêk loi rangin an khap thei jâma. ");
INSERT INTO sch_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Pisidia rama Antioch le Iconium renga Juda senkhatngei an honga; mipuingei hah an tieng an methêm mene zoia; Paul hah lung leh an dênga, a thi zoi tiin an mindona khopui renga an kai suoa. ");
INSERT INTO sch_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Hannirese, iempungei hah a kôla an hong indingin chu ânthoia, khopuia han a lût nôk zoia. Anangtûkah chu Barnabas le Derbea an se zoi. ");
INSERT INTO sch_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paul le Barnabas'n Derbea han Thurchi Sa an misîra, ruoisi tamtak an man nûkin Lystra, Iconium le Pisidia rama Antioch ngeia an kîr nôka. ");
INSERT INTO sch_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","“Intakna tamtak tuong ngêtin Pathien Rêngrama ei lût rang ani,” tia minchûn iempungei hah an mindeta, taksôn dika omtit rangin an mohôka. ");
INSERT INTO sch_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Koiindang tina upangei an phun pe ngei tira, bungêiin an chubai suole an iemna Pumapa, an taksônpu kuta an bâng tir zoia. ");
INSERT INTO sch_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pisidia ram an sir zoiin chu Pamphylia ram an hong tunga. ");
INSERT INTO sch_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Perga taka thurchi an misîr zoiin chu Attalia an sea, ");
INSERT INTO sch_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ma renga hah chu rukuongin Antioch an se nôk zoia. Ha mun hah hi zora an chuonsin an zoi hih, an phut rang lâia Pathien moroina kuta bânga an omna mun hah ani. ");
INSERT INTO sch_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Antioch an tungin chu koiindangngei an koibûma, anni ngei manga Pathien'n sin a tho ngei murdi le Jentailngei ta ranga iemna lampui a mo-ong pe ngei tie hah an rila. ");
INSERT INTO sch_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Mahan iempungei leh zora sôtzan an oma. ");
INSERT INTO sch_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Mi senkhat Judea ram renga Antioch an juonga, “Moses Balam anghan sertan nin tho nônchu sanminring ni thei no tu nui,” tiin iempungei an minchua. ");
INSERT INTO sch_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paul le Barnabas han ma roia han anni ngei hah an inkhalpui ngei oka, masikin, Paul le Barnaba le an lâia mi senkhat le ha bâiinkhamna chungroia han Jerusalema tîrtonngei le upangei hong intongpui rangin an minsûk zoia. ");
INSERT INTO sch_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Koiindangin an hong mathâna, anni han Jentailngei Pathien tienga an inlet roi hah misîr tîrin Phoenicia ram le Samaria ram an sir suoa ha an misîr renga han iempungei murdi an râiasân oka. ");
INSERT INTO sch_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jerusalem an tungin chu koiindangin tîrtonngei le upangeiin an lei modôma ma ngei kôm han Pathien'n anni ngei ma anga sin a tho ngei murdi hah an rila. ");
INSERT INTO sch_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Hannirese Pharisee pâla mi iempungei senkhat an indinga, “Jentailngei sertan ngêta, Moses Balam an jôm rangin tipe ngei rang ani” an tia. ");
INSERT INTO sch_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Tîrtonngei le upangei, ha roi hah jêk rangin an intûpa. ");
INSERT INTO sch_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Asôt tak an inkhal suo nûkin Peter ândinga, “Sûngsuokngei, Jentailngei Pathien chong an rieta, an iem theina ranga Thurchi Sa misîr pe ngei ranga nin lâi renga tien renga Pathien'n mi zen ani ti hah nin riet. ");
INSERT INTO sch_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Mitin mindona rietpu Pathien'n ei kôm mi pêk anghan Jentailngei khom Ratha Inthieng pêk sân a khôk tiin ânlanga. ");
INSERT INTO sch_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Eini le anni sensâi loiin, an iem sikin an sietnangei a ngâidam zoia. ");
INSERT INTO sch_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Masikin, ei richibulngei le eini pêl zoi khâiloi puok hah atûna hin iempungei chunga mokhop pe rang bôkin irang mo Pathien nin minsin hi? ");
INSERT INTO sch_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ni mak! Anni ngei angdênin eini khom Pumapa Jisua iema moroina han Sanminring ei ni,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Barnabas le Paul'n anni ngei manga Pathien'n Jentailngei lâia sininkhêlngei le kamâmruoingei a sin roi an misîr kâr chu mipuingei nâm an dâireka. ");
INSERT INTO sch_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","An misîr suole chu Jacob khomin a misîr sa, “Sûngsuokngei, ko chong rangâi ta u! ");
INSERT INTO sch_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Pathien'n ama riming ruput ranga anni ngei lâia ni lâk suok rangin Jentailngei a juong pan phut roi Simon'n a misîr zoia. ");
INSERT INTO sch_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ha chong le dêipungei chong hi ântok thap ani. Pathien lekhabu'n, ");
INSERT INTO sch_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Masuole, Pumapa han kîr nôk ka ta David omna rêngram achim hah minding nôk ki tih. a sietnangei sin nôk ka ta male mindet nôk ki tih. ");
INSERT INTO sch_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Male mi murdi ngei le Jentailngei, Ki mi niranga ko koi ngei nâm Jentailngei ko kôm hong an ta. ");
INSERT INTO sch_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Rammuol insieng renga hi chong min riet ngâipu Pumapa han a ti,’ ati anghan. ");
INSERT INTO sch_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Masikin Jacob'n, mahi ki mindon chu ani. Jentailngei Pathien tienga hong inlet ngei chu minjêl no ila. ");
INSERT INTO sch_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Manêkin, lekha muthuonin mirmilngei biekna neinun inthiengloi sâk mo, hur le ngal mo, sâ lei thisai le thisen sâk mo, mong rangin tipe ngei ila ki ti ani. ");
INSERT INTO sch_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Moses Balam chu tienlâi renga sabbathni rachamin Synagog taka an pore ngâi zoia, a chongngei khom khopui tina an misîr ngâi zoi,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Hanchu, tîrtonngei, upangei le koiindang pumpuiin an lâia mi senkhat an thanga, Paul le Barnabas pâla Antiocha min se rangin an min chukka. An ulien uol inik iempungeiin an mirit, Judas, Barsabass an ti le Silas an thang ngeia. ");
INSERT INTO sch_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Hi anghin miziekin, an min chôi ngeia: “Keini, tîrtonngei le upangei nin sûngsuokngeiin kin iempu champui Jentail ânzir ngei Antioch, Syria le Cilicia rama omngei chibaingei nangni kin mûk. ");
INSERT INTO sch_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Kin pâla mi senkhatin thurchi juong misîrin nangni an minjêla, mulungjîng nangni an shak ti kin rieta; nikhomrese, anni ngei ha kin kôm renga ite rilnangei man mak ngei. ");
INSERT INTO sch_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Masikin kin intûpa, mulung inruol takin kin thanga nin kôm juongtîr rangin kin minsûk ani. Ei ruol moroitak ngei Barnaba le Paul ");
INSERT INTO sch_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Jisua Khrista sinthona an ringna phal ngei lehin juong rese ngei kin ti. ");
INSERT INTO sch_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ha anghan, Judas le Silas kin juongtîr ani, hi ngei hin kin miziek hih mêl inmun nangni misîr pe an tih. ");
INSERT INTO sch_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ratha Inthieng le inruolin hi balamngei sin om pêna hi chu puok rik dang sin loi rangin kin inruol; ");
INSERT INTO sch_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","mirmilngei biekna sâkruo sâk no roi, thisen sâk no roi, sâ sômthat sâk no roi, hur le ngal renga inkêm roi. Hi ngei hih tho tet loi rangin nin indîn theiin chu nin ta rangin sa ok atih, chibai” tiin. ");
INSERT INTO sch_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","An tîrlâmngei hah an sea, Antioch an tunga; mahan iempungei pâl murdi an koibûma, lekhamuthuon hah an pêk ngeia. ");
INSERT INTO sch_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","An pore suole chu ma mohôkna chong sika han râisânin an sip zoia. ");
INSERT INTO sch_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas le Silas chu dêipungei khom an ti sa, asôtzan an chongpui ngeia, an mohôk ngeia, an min rât oka. ");
INSERT INTO sch_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Sûn sôtzan an om suole chu a juongtîr ngei kôm kîr nôk rangin an se zoia, iempungeiin rathangamriemin an mathân ngeia. ");
INSERT INTO sch_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paul le Barnaba chu midang tamtak ngei le Pumapa chong minchu le misîrin Antioch'a han zora sôtzan an la oma. ");
INSERT INTO sch_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Zora sôtzan suole chu Paul'n Barnabas kôm, “Tho se nôk ei ta, khopui tina Pumapa chong ei misîrna murdia ei sûngsuokngei pan ei ta, i angin mo an om va en ngei rei,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas'n John Mark an kôm tuongsa rang a nuoma. ");
INSERT INTO sch_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Hannirese Paul'n chu nuom maka, abi chu Pamphylia ram tena a kîra, an sin a zoipui loi sikin ani. ");
INSERT INTO sch_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","An inkhal bita, an insen zoia, Barnabas John Mark a tuonga, rukuongin Cyprus tuihuol tieng an sea. ");
INSERT INTO sch_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paul'n chu Silas a thanga, iempungeiin Pumapa moroina kuta an bâng ngei suole chu a se zoi. ");
INSERT INTO sch_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Koiindangngei mindet tîrin Syria le Cilicia ram a sir zoi. ");
INSERT INTO sch_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paul'n Derbe le Lystra khom a sir sa, mahan Khristien inkhat a riming Timothy a oma. A nû khom Khristien dên Juda mi ania, a pa chu Greek ani. ");
INSERT INTO sch_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Lystra le Iconiuma iempungei murdi'n Timothy an minlut ok ngâia. ");
INSERT INTO sch_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paul'n ama hah tuong rang a nuoma, ma revêla Judangei han Timothy pa hah Greek ani ti an riet sikin Timothy khom a sertan pe ani. ");
INSERT INTO sch_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Khopuingei tin an sir malamin, Jerusalema tîrtonngei le upangei balamngei masat hah iempungei an pêk tira, jôm rang khomin he an be tira. ");
INSERT INTO sch_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Masikin, koiindangngei hah taksônnân an rât uola nîngtin an pung titira. ");
INSERT INTO sch_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ratha Inthiengin Asia rama thurchi misîr a khap sikin Phrygia le Galatia ram an sîra. ");
INSERT INTO sch_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Mysia ramri an tungin chu Bithynia rama se rang an bôka, hannirese, Jisua Ratha'n phal ngei maka. ");
INSERT INTO sch_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Masikin, Mysia ram khêlin Troasa an se zoia. ");
INSERT INTO sch_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Hanchu, mani jâna han Paul'n inlârnân Macedonia rama mi inkhatin “Macedonia rama hong kâi inla, mi hong san roh,” tia ngênin a mua, ");
INSERT INTO sch_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paul'n inlârna hi a mu suole chu Macedonia rama se rangin kin inthok kelen zoia, ha rama mingei kôma Thurchi Sa misîr rangin Pathien'n mi koi sikin. ");
INSERT INTO sch_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Troas renga rukuongin kin jôka, Samothrace kin thengpata, male anangtûka Neapolis kin sea. ");
INSERT INTO sch_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ha renga hah Philippia kin sea, ha khopuilien hah Macedonia; rama khuo inkhat ania, ma biela han chu khuo kâm omtak ani. Rom mingei bung ani. Ma khuoa han sûn tamtak kin châma. ");
INSERT INTO sch_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sabbathni khopui pêntienga tuidung panga Judangei chubaithona ngâi mun ni ranga kin iema han kin sea; mahan kin insunga nupang intûp ngei kôm thurchi kin misîra. ");
INSERT INTO sch_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ha ngei lâia mi a riming Lydia, Thyatira, khuo mi puon senduk juor ngâi, Pathiena inbei mi nupang inkhatin chong a rieta; male Paul thurchi misîr jôm rangin Pumapa'n a mulungrîl a minvâr pea. ");
INSERT INTO sch_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ama le a inmingeiin baptisma an chang zoiin chu, “Pumapa iem tatakin ni nan bêa anin chu ki ina hong tung roi tiin mi siel rîta,” ni sûr zoi. ");
INSERT INTO sch_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Sûnkhat chu chubaithona muna kin se lâiin suok dôngmate inkhat ramkhori sûra taruosân thei kin intongpuia, amanu han taruosân a theina sika han a pu ngei sum tamtak a lo pe ngâia. ");
INSERT INTO sch_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Hanu han Paul le Keini mi jûia, “Hi mi, Sanminringna lampui nangni ril ngei hih, Ânchungtak Pathien tîrlâmngei an ni hi,” tiin âniek ngâia. ");
INSERT INTO sch_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ma anghan, sûn tamtak a tho tenin chu Paul a mulung hoi khâi maka, a takasia. Ramkhori kôm han, “Jisua Khrista rimingin a sûng renga jôk rangin chong nang ke pêk,” a tia. Ha mitmisim kongkâr han a jôk pai kelen zoia. ");
INSERT INTO sch_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","A pumangei han an sum manna om khâi mak ti an riet lechu Paul le Silas hah an sûra, roijêkpungei kôm mipui intûpna muna an kai minlûta. ");
INSERT INTO sch_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Rom roijêkpungei kôm an min tungin chu, “Hi mingei hih Juda an nia, kin khopuilien sûnga bâiinkhamna an sin ngâi. ");
INSERT INTO sch_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Balam dang kin balam le ânkâl, keini Rom mingei kin pom rang le kin mang ranga ânthiengloi an misîr ngâi” an tia. ");
INSERT INTO sch_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Mipuingei hah Paul le Silas jêm rangin an inthoka. Masuole chu roijêkpungei han Paul le Silas puon an khêr pe ngeia, jêm rangin chong an pêka. ");
INSERT INTO sch_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","An jêm bit suole jêl ina an khuma, a ngâkpu kôm han asân khumrap rangin chong an pêka. ");
INSERT INTO sch_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ma anghan, intâng insûng ânlâina taka a khum ngei, an kea thing kekok riktak an min bun ngeia. ");
INSERT INTO sch_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Jân lâitaka chu Paul le Silas'n Pathien kôm chubai an thoa. Minpâkna lâ an thoa, intâng ina midangngeiin an rangâia. ");
INSERT INTO sch_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Inningloiin nîngnupui a honga; intâng in lungphûmngei tena khom ânphêt heta, voikhatrengin inkhârngei hah ân-ong leta, mitin rênrokolngei hah ânkhek rila. ");
INSERT INTO sch_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Hanchu, angâkpu a in hah a hong hara, inkhârngei in-ong letin a mua, intâng ina intângngei an rot suo zoi tiin a bôka, khandai a kaidûka, inthat rang a thoa. ");
INSERT INTO sch_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Hannirese Paul'n rôl inringtakin, “Ite inlo no roh, kin rêngin kin la om let” a tia. ");
INSERT INTO sch_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ama han meiser a roka, a tâna, chi le innîk pumin Paul le Silas ke bula ânbokraka. ");
INSERT INTO sch_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Hanchu anni han a ruoi suok ngeia, “Pungei, Sanminringa ko om theina rangin imo ko tho rang?” a tia. ");
INSERT INTO sch_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Anni han, “Pumapa Jisua iem inla, hanchu sanminringin om ni tih, nangma le ni inmingei leh,” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Masuole chu ama le a inmingei han Pumapa thurchi an misîra. ");
INSERT INTO sch_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Mani jâna han, ma zora lelea han an sâbengei hah a rusûk pe ngeia; hanchu ama le a inmingei baptisma an chang kelen zoi. ");
INSERT INTO sch_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Masuole Paul le Silas hah a ina a tuong ngeia, sâk rang a pêk ngeia Pathien an iem zoi sikin an insûng pumin an râiasân tatak zoi ani. ");
INSERT INTO sch_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Anangtûk jînga chu Rom roijêkpungei han, “Ha mingei hah mojôk ta roh,” ti chongpêk chôiin misûr ngâi ngei ulienngei an tîra. ");
INSERT INTO sch_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Masikin a ngâkpu han Paul kôm, “Roijêkpungeiin nangni mojôk rangin chong an hong muthuon. Hong jôk ungla, rathânngamtakin se ta roi,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Aniatachu, Paul'n misûr ngâi ulienngei kôm, “Rom miriem kêng kin ni, kin tho minchâina om le omloi luo en loiin loko makunga min jêma, intâng ina min khuma. Atûn inrûkin mi mojôk rang an ti na? Ni thei tet no nih! Anni ngêt hong rese ngei, mi hong mojôk rese ngei,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Misûr ngâi ulienngeiin ha chong hah roijêkpungei kôm an misîra; Rom miriem anni ti an rietin chu an chi zoia. ");
INSERT INTO sch_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Masikin an sea an vânvûia, male chu an mojôk ngeia khopuilien renga jôkpai rangin an ngêna. ");
INSERT INTO sch_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paul le Silas hah intâng in renga an jôka, Lydia ina an sea. Mahan iempungei hah an mua, mohôkna chong an pêk ngei suole chu an mâk ngei zoia. ");
INSERT INTO sch_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paul le Silas hah Amphipolis le Apollonia an khêla. Thessalonika an tunga. Mahan Judangei Synagog taka ava oma. ");
INSERT INTO sch_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paul'n a tho ngâi balam anghan an kôm a lûta, sabbathnia voithum Pathien lekhabu renga asân a sûtpuiin, ");
INSERT INTO sch_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Messiah chu dûktonga thina renga ânthoinôk rang piel ani ti a rilminthâra, a minlang ngâia, “Hi Jisua, nin lâia ku phuong hih Messiah ani,” a ti sa ngâi. ");
INSERT INTO sch_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","An lâia senkhat chu Paul thurchi misîr hah an iema, Paul le Silas hah an jôm zoia; nupang ruoipu tamtak le Pathiena inbei mi Greek mipuingei lehan. ");
INSERT INTO sch_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Hannirese Judangei han an narsa, lamliena thaboi pâlngei hah an tuonga, mipui an koibûma, khopuilien pumpui bâiinkham chara, Paul le Silas hah loko makunga tuong rang bôkin Jason in an hong lûtkhuma. ");
INSERT INTO sch_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Hannirese, an manloi lehan chu, Jason le iempu senkhatngei hah khopuilien ulienngei makunga an hong kainâl ngeia, an inieka. “Hi mingei hin muntina bâiinkhamna an sin ngâi! atûna hin ei khopuiliena an hong ani. ");
INSERT INTO sch_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jason hin a ina a lei mintung ngei ngâia. Hi ngei hin, a riming Jisua, Rêng dang aom tiin Caesar balam an siet ngâi,” an tia. ");
INSERT INTO sch_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ma chong hah an rietin chu mipui le khopuilien ulienngei hah bâiinkhamin an om zoia. ");
INSERT INTO sch_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Khopui ulienngeiin Jason le a champuingei hah sum anâng dôr an pêka, an mojôk ngei zoi ani. ");
INSERT INTO sch_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Hanchu, iempungeiin hani jân ahongni lechu Paul le Silas hah Berea khopuia an min se ngei kelena, an tungin chu Judangei Synagog an lûta. ");
INSERT INTO sch_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ma taka mingei kai chu Thessalonika mingei nêkin chu an mulungrîl ân ong uola. Thurchi hah atui takin an rangâia, Paul thurchi misîr hah adik le dikloi rietna rangin nîngtin Pathien lekhabu an inchu ngâia. ");
INSERT INTO sch_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ha ngei lâia mi tamtakin an iem zoia, Greek nupang mirit om tamtak le pasal tamtak khomin an iem zoi. ");
INSERT INTO sch_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Hannirese Thessalonika Judangei han, Paul'n Berea khopuia khom Pathien thurchi a misîr ti an riet lechu mahan khom an va sea, mipuingei an mohôka; bâi an inkhâm char zoi. ");
INSERT INTO sch_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Iempungeiin tuipui dênin se rangin Paul hah an tîra, Silas le Timothy chu an la oma. ");
INSERT INTO sch_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Paul juong thak ngei han Athens dênin an juong thaka; Silas le Timothy kôm han innota a kôma se ranga Paul chongbê chôiin an kîr nôk zoi. ");
INSERT INTO sch_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paul'n Athens taka anni hah a lei ngâk lâiin ha khopuilien hah mirmilngeia sip ani ti a mûn chu a mulung a minna oka. ");
INSERT INTO sch_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Masikin Synagog'a Judangei le Jentailngei, Pathien biek ngei hah a dem ngâia; mipui intûpna muna khom mataka omngei ngân chu nîngtin an injêk ngâi. ");
INSERT INTO sch_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Epicurean le Stoic minchupungei lâia khomin an inkhalpuia. Senkhat chu, “Hi mûr thiempa hin imo misîr rang a bôk hi?” an tia. Adangngeiin chu, “Ram dang pathienngei chong a misîr rang ani hi,” Paul, Jisua le inthoinôkna. misîr sika ani. ");
INSERT INTO sch_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Masikin Paul hah a koia, roijêkna Areopagus han an tuonga; a kôm “Hi minchuna thar ni misîr ngâi hi a riet kin nuom. ");
INSERT INTO sch_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ni misîr kin riet ngei hih la riet ngâi makme; itina mo ani a riet kin nuom,” an tia. ");
INSERT INTO sch_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Athens khopui mi murdi le ramdangmingei ajuong omngei khomin an zora dôn murdi neinun thar misîrna le rangâina mang an nuom sikin). ");
INSERT INTO sch_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paul hah roijêkna Areopagus moton taka ândinga, “Nangni Athens mingei, lamtina sakhuo mi tatak nin ni ti ki riet. ");
INSERT INTO sch_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Nin khopuilien sûnga ka chai malamin chubai nin mûk ngâi ngei ke ena; mâichâm inkhat, ‘Rietloi pathien ta rang,’ tia ânziek ku mua. Nin rietloi chubai nin mûk tit ngâi hah atûna nangni ki misîr pe hih ani. ");
INSERT INTO sch_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Pathien'n rammuol le asûnga neinunngei murdi sinpu chu pilchung le invân Pumapa ani sikin kuta sin in ngeia om ngâi mak. ");
INSERT INTO sch_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Miriem ei sem rang neinun ite khom insam mak. Ama ngêt han hah ngei nâm kôma ringna ngei, phûk ngei le mitin kôma neinunngei nâm a pêkpu ani uol. ");
INSERT INTO sch_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Rammuol pumpuia om rangin, mi inkhat renga jâttin a sina. An ta rang zorangei a khit pe ngeia, an omna rang rikung a khangpe ngeia. ");
INSERT INTO sch_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ma hih a thona abi chu ama an ena, an zonga an mu theina ranga ani. Adiktakin, Pathien chu tute renga la uol mak. ");
INSERT INTO sch_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Mi senkhatin an ti anghan, ‘Ama sikin ei ringa, singinsa'n, ei om ani,’ Nin lâ phuopungei khomin an ti sa anghan, ‘Eini khom a nâingei ei ni.’ ");
INSERT INTO sch_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Pathien nâingei ei nin chu, Pathien chu rângkachak mini, sumin mini, lungin mini, miriem kut thiem le mindonna mirimil an sin ngâi anga han om rang tetên ei bôk rang nimak. ");
INSERT INTO sch_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Pathien'n ama ei riet mâna ngei kai chu rietloi om a tho ngâia; aniatachu, atûn chu ramtina mi murdi sietna renga inhei rangin chong a pêk zoi. ");
INSERT INTO sch_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Nikhuo a khita, ha nia han a mi phunpu hah rammuola mi murdi ngei roi adiktakin jêk atih. Ma chong ha chu Pathien'n ama hah thina renga kaithoiin mi murdi kôm a min riet zoi,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Thina renga inthoinôk roi an riet lechu senkhatin an munuisana; senkhat nôkin chu, “Hi chong hi no kôm renga la rangâi nôk kin nuom,” an tia. ");
INSERT INTO sch_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Male Paul a mâk ngeia. ");
INSERT INTO sch_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Mi senkhat chu a tieng an kop tita male an iem zoia. Ha ngei lâia senkhat chu, Areopagus roijêkpu pâla mi Dionysius le nupang inkhat a riming Damaris le midang ngei an ni. ");
INSERT INTO sch_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Masuole han, Paul hah Athens renga Korinth a se zoia. ");
INSERT INTO sch_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Mahan Juda inkhat a riming Aquila a mua, ha mi hah Pontus rama suok ania, Claudius Juda murdi Rom renga jôkpai rangin chong a pêk sikin a lômnu Priscilla le Italy ram renga hong inthon bil an ni. Paul an kôm a sea. ");
INSERT INTO sch_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ha ngei khom hah Paul anga puon in sin ngâi anni sikin an kôm a oma, munkhatin sin an tho zoi. ");
INSERT INTO sch_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sabbathni racham Synagog taka chong a mintukpui ngâia. Judangei le Greekngei hah min riet minthâr rang a bôk ngâia. ");
INSERT INTO sch_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silas le Timothy Macedonia ram renga an juong tungin chu Paul hah thurchi misîr injîen a zora a mang zoia, Jisua chu Messiah ani tiin Judangei kôm a ril minthâr ngâia. ");
INSERT INTO sch_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Hannirese an doia an ril minsieta masuole, chu Paul'n a puona rababngei hah thikin chongnatakin a thuona, an kôm, “Nin thina chungroi chu nangnin pêl roi, keima chu ko jôk ani, atûn renga chu Jentailngei kôm se ki tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Masikin a jôka Jentail inkhat a riming Titius Justus ina a lûta, ha mi hah Pathien biek ngâi mi ania, a in khom Synagog le ântôn chak. ");
INSERT INTO sch_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Crispus Synagog ruoipu han a inmingei murdi le Pumapa an iema, Korinth khopuia mi tamtak khomin an rieta, an iema baptisma an chang zoi. ");
INSERT INTO sch_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Jân khat chu Paul'n inlârna a mua, mahan Pumapa'n a kôm, “Chi no roh, dâirek loiin thurchi misîr tit roh, ");
INSERT INTO sch_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","asikchu nang ko ompui tit nang minna rangin tutên nu chunga an kut musum noni ngei, hi khopuia hin mi tamtak ko dôn kêng,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Masik han, Paul hah ma khopuiliena han Pathien chong minchûn kum khat in-ang a oma. ");
INSERT INTO sch_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Gallio ha Achaia rama râiôt a chang lâiin Judangei an inruola, Paul an sûra, roijêknamuna an tuonga. ");
INSERT INTO sch_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“Hi mi hin balam niloia Pathien biek rangin mi methêm rang a bôk ngâi,” an tia. ");
INSERT INTO sch_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paul hong chong rang a ti lehan, Gallio han Judangei kôm, “Judangei, mahi neinun dikloi mini, aninônchu tho minchâina mini luo nirese chu, inkhêl loiin nangni mindon pe ki tih. ");
INSERT INTO sch_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Hannirese, chongngei, rimingngei le nin balam chungroia inkhalna papai kêng ania, nangnin jêk roi. Kei chu ha anga neinunngei kai chu jêk no ning,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Roijêkna mun renga a rujûlpai ngei zoia. ");
INSERT INTO sch_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Anrêngin an Synagog ruoipu Sosthenes an sûra, roijêknamun mâia an jêma. Aniatachu Gallio han ma anga an tho ha itên rangâi pe ngei tet mak. ");
INSERT INTO sch_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Masuole han Paul hah iempungei leh sûn tamtak a la oma, hanchu iempungei hah a mathân ngeia Syria ram tieng rukuongin a se zoia, a kôm Priscilla le Aquila khom an se sa. Paul'n chonginkhâm a lei dôn sikin Cenchreae a se mân a sam a ep baka. ");
INSERT INTO sch_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ephesus'a an tunga, mahan Priscilla le Aquila chu a mâka, ama chu Synagog taka a lûta Judangei hah chong a la mintukpui ngeia. ");
INSERT INTO sch_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Anni han asôtzan om rangin an ngêna, hannirese pom pe ngei maka. ");
INSERT INTO sch_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Manêkin, an kôm se khom inlang “Pathien lungdo anîn chu nin kôm la hong nôk ki tih,” tiin chong hoiin a mâk ngeia, Ephesus'a renga rukuongin a se zoia. ");
INSERT INTO sch_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Caesarea a tungin chu Jerusalema a sea, koiindang chibai a mûka, masuole chu Antioch taka a se zoia. ");
INSERT INTO sch_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Mahan sûn tamtak a om suo nûkin a se nôka, iempungei mindet tîrin Galatia ram le Phragia ram a sir suo zoi. ");
INSERT INTO sch_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ha lâia han Juda inkhat a riming Apollos, Alexandria taka suok Ephesus'a a juonga. Ama hah thurchi misîr theitak ania, Pathien Lekhabungei khom a riet oka. ");
INSERT INTO sch_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ama hah Pumapa lampui chong ânchu zoisai ania, mulungrîla satna tak inheiin Jisua thurchi a misîr ngâia, Nikhomrese, John baptisma vai kêng ala riet. ");
INSERT INTO sch_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Synagog taka hâitakin thurchi misîr a phuta, hanchu Priscilla le Aquila hah a thurchi misîr an rietin chu an ina an tuonga, a kôm, Pathien lampui roi adik uolin an rilminthâr pea. ");
INSERT INTO sch_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Hanchu ama hah Achaia rama se rang a bôk sikin Ephesus'a iempungeiin an mohôka ama an lei modômna rangin Achaia rama iempungei kôm lekha an miziek pea. A tungin chu Pathien moroina sika iempu hong chang ngei ta rangin a sanpu satak a changa. ");
INSERT INTO sch_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Loko rieta Judangei hah a makhal mindoka, Pathien lekhabu mangin Jisua chu Messiah ani ti a minlang ngâi. ");
INSERT INTO sch_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apollos hah Korinth taka a la om lâiin Paul'n sak tienga biel a hong sîra, Ephesus'a a tunga mahan ruoisingei senkhat a mua. ");
INSERT INTO sch_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ama han, “Iempu nin changa han Ratha Inthieng nin lei modôm ngâi mo?” tiin a rekel ngeia. “Ratha Inthieng aom ti luo riet mak me,” tiin an thuona. ");
INSERT INTO sch_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Asa! “Nônchu, khoi baptisma mo nin chang?” a tia. Anni han “John baptisma,” an tia. ");
INSERT INTO sch_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paul'n an kôm, “John'n mingei kôm, ku nûka juong rangpu Jisua nin la iem rang ani tiin Isrealngei an sietna renga inhei ngei hah a baptis ngâi ani ha,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Maha an rietin chu Pumapa Jisua rimingin baptisma an chang zoia. ");
INSERT INTO sch_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Paul'n an chunga a kut a minngama, Ratha Inthieng an chang kelen zoi, rietloi chong ngeiin an chonga, Pathien chong an misîr zoi. ");
INSERT INTO sch_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Anrêngin pasal sômleinik dôr an ni. ");
INSERT INTO sch_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paul'n Synagog lût bangin than thum chu Pathien Rêngram thurchi mintukpuiin methêm mene rang bôkin hâitakin thurchi a misîr tita. ");
INSERT INTO sch_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Aniatachu, senkhat chu an seletrûka, iem nuom mak ngeia, mipui makunga Pumapa lampui thurchi hah an ril minsieta, masikin Paul'n anni ngei hah mâkin iempungei hah a tuonga nîngtin Tyrannus inchuna ina han chong an mintukpui ngâia. ");
INSERT INTO sch_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ma anghan, kumnik a thoa, masikin Asia rama om murdi, Judangei le Greekngei khomin Pumapa chong an riet zoia. ");
INSERT INTO sch_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Pathien'n Paul kuta sininkhêl adangviek a min thoa. ");
INSERT INTO sch_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Paul'n a lei mang ngâi mâihuinangei le a rôpthupna puonngei hah damloingei kôm a min chôia, an natnangei an dam ngâia, an sûnga ratha saloi tena khom an jôk ngâi. ");
INSERT INTO sch_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Judangei senkhat ratha saloi rujûlpai rang a bôka, ânvâk ngâi ngei khomin Pumapa Jisua riming an manga. Ratha saloi kôm, “Paul'n a misîr ngâi Jisua rimingin a sûng renga jôk rangin chong nang ke pêk,” an tia. ");
INSERT INTO sch_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Juda Ochai Inlaltak, Sceva han nâipasal sari ha anga chong ngâi a dôna. ");
INSERT INTO sch_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Hannirese ratha saloi han an kôm, “Jisua ki riet, Paul khom ki riet nangni rêk hi chu tu ngei mo nin ni?” a tia. ");
INSERT INTO sch_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","A sûnga ratha saloi dôn han a hong invôra, amene ngei riei zoia, ha in renga hah popnekin le an puon chet chitin an tân riei zoi. ");
INSERT INTO sch_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ephesus'a taka om Judangei le Jentailngei murdi'n ma roi hah an rietin chu an chi sabak zoia, hanchu Pumapa Jisua riming ânthang uol zoi. ");
INSERT INTO sch_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Iempu tamtak an honga, loko rieta an chong minchâina an phuonga. ");
INSERT INTO sch_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Dôitheingei tamtak khomin an lekhabungei an hong bûma, mitin mitmua an hâla, male aman an minsâpa, sumdârngei isâng sômrangnga ani tiin an rieta. ");
INSERT INTO sch_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ma ang taka sintho theina lien han Pumapa thurchi ânzara, rât takin ânsôn tir zoi. ");
INSERT INTO sch_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Masuole chu Paul'n Macedonia ram le Achaia ram a sir suo baka, Jerusalema se rang a bôka “Ma han ke se suole chu Rom khom sir sa ngêt ki tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Masikin ânsanpui ngâi mi inik, Timothy le Erastus hah Mecedonia rama a lei tîr baka, ama chu Asia rama ala oma. ");
INSERT INTO sch_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ma zora lâihan Pumapa lampui thurchi sikin bâiinkhamna lientak Ephesus'a a oma. ");
INSERT INTO sch_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Mi inkhat a riming Demetrius, sumtuia Artemis pathiennu biekin rimil sin ngâi a oma, maha a sintho ngei kôm inlâpna lientak an pêk ngâia. ");
INSERT INTO sch_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Masikin ama han anni ngei hah a koibûma, an sintho anga tho ngei lehan chu, an kôm, “Miriempa, hi sin hih ei neina ani ti nin rieta. ");
INSERT INTO sch_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Atûn, hi Paul sintho hih nangni khomin nin mua, nin rieta Ephesus'a vaia khom niloiin Asia ram pumpuia ti rang dôrin hi mi hin, kuta sin pathienngei hih pathien ni tet mak tiin mi tamtak a huong mene suo zoia. ");
INSERT INTO sch_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Masikin ei sintho hih min en minnuoi an tih, ti vai niloiin, Asia rama mi murdi le rammuola mîn an biek ngâi pathiennu Artemis roiinpui khom boi atih, ti hih ichi aom ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ha chong hah mipuingeiin an riet lechu an taksi sabaka, “Ephesus'a Artemis hi a roiinpui tak,” tin an hêta. ");
INSERT INTO sch_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Hanchu, khopuilien pumpui bâi an inkhâm zoia, Gaius le Aristarchus, Mecedonia rama mi Paul nûkjûingei hah an sûra, a pâlin enhoi sinna ina an tânpuia. ");
INSERT INTO sch_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paul'n mipui makunga vânding rang a bôka, hannirese, iempungeiin phal mak ngeia. ");
INSERT INTO sch_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Asia rama ulien senkhat Paul malngei an oma, ha ngei khom han Paul hah enhoi sinna ina vânlang loi rangin chong an muthuona. ");
INSERT INTO sch_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","an thup ngeia, anrêngin bâi an inkhâm char zoia, mi tamtakin an intûpna bi khom riet mak ngei. Masikin, senkhat chong inkhat an hêtpuia senkhatin chong dang an hêtpuia. ");
INSERT INTO sch_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Mi senkhat chu Alexander sika nîng atih, an tia; ama hah Judangei moton tieng an nam minlût sikin. Alexander'n mipui ruhu dâina rangin a kut a jâpa, an theina thurchi misîr rang a bôka. ");
INSERT INTO sch_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Hannirese Juda ani ti an riet lechu darkâr nik inruolin, “Ephesus'a Artemus hih a roiinpui tak,” tiin an iniek tita. ");
INSERT INTO sch_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Amongnataka chu an khopuilien jêkpu'n mipuingei hah a ngo mindâia. A ngo mindâi suole chu an kôm, “Ephesus'a Artimus roiinpuitak biekin le invân renga lung inthieng achul hah Ephesus'a mingei hih a donsûipu nin ni ti mitinin an rieta. ");
INSERT INTO sch_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Hi chong hi tutên makhal thei noni ngei. Masikin nin ruhu mindâi ngêt rang ani, mindon bak loiin ite nin tho rang nimak. ");
INSERT INTO sch_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Hi mi, hi taka nin hong tuong ngei hih biekina inru khom nimak ngeia, ei pathiennu rilminsiet khom nimak ngei. ");
INSERT INTO sch_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Demetrius le a sinthongei khomin tu chunga khom roi intak an dônin chu roijêkpungei ei dôna, roijêkna in khom ân-ong tit, ma son vân ngo rese ngei. ");
INSERT INTO sch_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Aniatachu, roi intak piel nin la dônin chu jâttin roijêkna ina mindon nîng atih. ");
INSERT INTO sch_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Aviena inkhôm sika hin mîn bâiinkhamna musuo ngei tiin, mi tîng an tih, ti hih ichi om ani. Hi bâiinkhamna hi abi boi ani sikin tute lakin abi misîr thei noni ngeia,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ma chong hah a ti suole chu mipuingei intûp hah an chîn zoi. ");
INSERT INTO sch_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ruhu lumpa hah ahek suole Paul'n iempungei a koibûma, a mohôkna chongin a mâk ngeia. Hanchu a jôka Macedonia rama a se zoia. ");
INSERT INTO sch_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Mingei mohôkna chong tamtak misîrin ha ram hah a sir suoa, Achaia ram a tung zoia. ");
INSERT INTO sch_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Mahan than thum aom suole Syria ram tieng se rangin ânthoka; hannirese, Judangei an lei muruong chien ti a riet sikin Macedonia tieng kîr nôk rang a bôka. ");
INSERT INTO sch_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Pyrrhus nâipasal Sopater Beroea mingei, Aristarchus le Secundus, Thessalonika mingei, Gaius, Derbe, mingei, Timothy ngei, Tichicus le Trophimus Asia rama mingei an se sa. ");
INSERT INTO sch_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ha ngei hah moton aninsa. Troasa min lei ngâka. ");
INSERT INTO sch_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Keini chu cholboivâipôl ruolhoi chumin Philipi renga rukuongin kin jôka. Sûn rangnga suole Troasa an kôm kin tunga, mahan sûn sari kin châma. ");
INSERT INTO sch_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Sûnrukni kholoiin vâipôl khoi rangin kin intûpa, Paul'n anangtûka se rang a bôk sikin jânchim tena thurchi a misîr jêta. ");
INSERT INTO sch_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Kin intûpna khâltan chunginchuon han châti tamtak mochok ania. ");
INSERT INTO sch_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Hanchu ruotharte inkhat a riming Eutychus, kotvênga ân sunga inngûi a lênsua Paul thurchi misîr hah asôt rai sikin a lei inphara; in chunginchuon inthumna renga a juong tâka. An juong rût tena chu a lei thi zoi. ");
INSERT INTO sch_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Aniatachu Paul a chuma a juon kûna a poma, “Nin mulung minjîng no roi, a la ring ke,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Hanchu, Paul hah in chunginchuona a kal nôka, vâipôl a khoia, an sâk zoia. Asôtzan khuovâr rak dôr nisa asuok tena a chongpui ngei suole chu a se zoia. ");
INSERT INTO sch_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ruotharte hah damin a in tieng an tuonga an phûk adâiriem zoi. ");
INSERT INTO sch_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Keini chu rukuongin Assos khuo panin moton kin lênsa zoi, mahan Paul min chuong rang kin bôka, ama hah kea hong rang a bôk sikin hi anga rangin mi ril sai ani. ");
INSERT INTO sch_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Assosa mi hong huoma, kin min chuonga Mitylene kin tung zoi. ");
INSERT INTO sch_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ha mun renga hah rukuong nanâkin kin se nôka, anangtûka Chios kin tunga hatûk chu Samos kin tunga, anangtûk nôka Miletus kin tung zoia. ");
INSERT INTO sch_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paul'n Asia rama om sôt a nuom loi sikin Ephesus'a chu sûnapal rang a bôk piel ani. Ani thei paia anîn chu Jerusalema Pentecost ni mang rang a bôka, ânnot ani. ");
INSERT INTO sch_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Miletus renga Paul'n Ephesus'a mi a tîra, koiindang ulienngei ava min koi ngeia. ");
INSERT INTO sch_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","A kôm an tungin chu an kôm, “Asia ram ku lût masa ni renga nin kôma ko om kâra ko omlam hah nin rieta. ");
INSERT INTO sch_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Judangei min muruong sika mitrithi tâk pumin le zora intak ku chunga hong tung ngei tuongin intem takin Pumapa sin ko tho ngâi. ");
INSERT INTO sch_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Nin ta ranga inlâpna rang ite thup loiin loko lâia le insûngngeia nangni ki ril ngâia, nangni ki minchu ngâi duo. ");
INSERT INTO sch_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Judangei le Jentailngei khom Pathien tieng an sietnangei renga insîrin ei Pumapa Jisua Khrista an iem rang ani ti insiemna chong ke pêk ngeia. ");
INSERT INTO sch_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Male atûn Ratha Inthieng chong jômin Jerusalema ke se rang ani, mahan ku chunga imo atung rang riet mu ung. ");
INSERT INTO sch_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Khopuilien tina, intâng ina le bâiinkhamnân mi ngâk ti vai hi Ratha Inthiengin mi min rieta, ki riet ani. ");
INSERT INTO sch_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Pathien moroina Thurchi Sa misîr rang sintum Pumapa Jisua Khrista mi pêk zoina rangin chu ki ringna khom hi itên be mu-ung. ");
INSERT INTO sch_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Masikin riet roi, nin rêngin Pathien Rêngram thurchi misîra kên vâkna ngâi ngei hin atûn renga chu mi mu khâi no tu nui, ti ki riet. ");
INSERT INTO sch_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Mapêna an mang nin om duoi le khom kei chu ko jôk ani ti avien hin nangni ki min riet. ");
INSERT INTO sch_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Pathien neinun khîn murdi anrêngin nin lâia misîr inrîng mu ung. ");
INSERT INTO sch_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Masikin Pathien koiindang, a Nâipasal thina sika ama ta ranga a sin chunga belripungei chang ungla, nangni le belripâl Ratha Inthiengin nangni a min kolna ngei satna rang zong roi. ");
INSERT INTO sch_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ku nûk le chu melang ichi om ngei nin lâia hong lût an ta, belripâl hôih noni ngei ti ki riet. ");
INSERT INTO sch_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Nin pâla mi senkhat khomin iempungei an tieng an tuong theina rangin milak an ril zora la tung atih. ");
INSERT INTO sch_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Hanchu sûn, jân mitrithi tâkpumin kum thum piel mitin nangni ki minchu hah riettitin sing thei roi. ");
INSERT INTO sch_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Atûn hin Pathien donsûina le moroina chonga nangni ka bânga ama han nangni a sin minlien theia, Pathien'n a mingei ta ranga a khâm satvurna hah nangni a pêk thei. ");
INSERT INTO sch_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Tute sumdâr khom, rângkachak khom, sil le bom khom ôi ngâi mu-ung. ");
INSERT INTO sch_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ku kutngei lehin keima le ka champuingei anâng murdi asuo ngâi ti nangni rengin nin rieta. ");
INSERT INTO sch_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Lamtina sintho ranak songin le Pumapa Jisua'n, ‘Lâk nêkin pêk râisânna aom uol’ a ti hah riettitin râtloingei ei san rang ani ti nangni ki min mu ngâi,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paul'n ha chong hah a ti suole chu, khûkinbilin an rêngin chubai a thopui ngeia. ");
INSERT INTO sch_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","He hoiin an mathân zoia, anrêngin an chapa Paul hah an kuoa an tuma. ");
INSERT INTO sch_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","A mêl an mu nôk khâi loi rang chong Paul'n a misîr pe ngei hah an rangâi sietna bitak ani. Masuole chu rukuong dênin an juong thak zoi. ");
INSERT INTO sch_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Anni ngei le kin insen suole chu rukuong leh kin se pata Cos kin tunga anangtûka Rhodes kin tunga, tuihuol kin tung nôka ma renga hah Patara kin tung nôka. ");
INSERT INTO sch_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ma mun han rukuong inkhat Phonicia tienga se rang kin mua, mahan kin chuonga kin se nôk kelena. ");
INSERT INTO sch_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Cyprus tuihuol ânlangna mun ten kin va phâk lehan Cyprus hah voi tieng kin mâka Syria tieng kin sea Tyre chu neinun an musum sikin kin chuma. ");
INSERT INTO sch_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ma mun han iempungei senkhat kin va mua an kôm sûn sari nikhuo kin châma, anni ngei han Ratha Inthieng rilin Paul hah Jerusalema se loi rangin an khapa. ");
INSERT INTO sch_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Hannirese, sûn sari ahek suole chu ha renga hah kin jôka kin se nôka iempungeiin an lômnungei le an nâingei le tuikôl tena min juong thaka ma mun han khûkinbilin chubai kin thoa. ");
INSERT INTO sch_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Masuole chu chonghoiin inkhat le inkhat kin insena rukuonga kin chuonga anni ngei chu in tieng an kîr nôk zoi. ");
INSERT INTO sch_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Rukuong leh kin se pata Tyre renga Tolemais kin tunga iempungei chibai kin pêka mahan sûn khat an kôm kin châma. ");
INSERT INTO sch_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Anangtûka chu kin se nôka Caesarea kin tunga mahan Thurchi Sa misîrpu Philip ina kin tunga, Philip hah Jerusalema sanpu ânthang sari ngei lâia inkhat hah alei ni. ");
INSERT INTO sch_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ama han nâi dôngmate inneiloi minli a dôna anni ngei han Pathien thurchi an misîr ngâia. ");
INSERT INTO sch_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Mahan sûn tamtak nikhuo kin châma ha nikhuo kin châm sûng han Judea ram renga dêipu a riming Agabus a juonga. ");
INSERT INTO sch_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Kin kôm a honga Paul a kongkhitngei hah a lâka, a kengei a kutngei athenin a khita masuole chu kin kôm hi anghin a tia, “Jerusalema, Judangei hi anga kongkhit a dônpu tak hi, hi angtak hin khit an ta, Jentailngei kuta an pêk rang ti hi Ratha Inthiengin mi ril sai ke ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ha thurchi hah kin riet lechu keini le ma khuoa omngei han Paul hah Jerusalema se loi rang kin tipe tita. ");
INSERT INTO sch_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Hannirese Paul han kin kôm, “Khoimo nin tho, ma angdôr hih nin chap, ku mulung nin khoi hi? Pumapa Jisua sikin Jerusalema khit rang vai hi kên phal nimaka, thi rang ten khom kên phal ke,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Methêm theijât ani khâiloi sikin, “Pumapa ti lam tak nirese,” kin tia, kin mojôk zoi. ");
INSERT INTO sch_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Masuole chu, kin insiema Jerusalem tienga se rangin kin jôk zoi. ");
INSERT INTO sch_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Caeserea khuo renga ruoisi senkhat ngeiin min jûia, anni ngei lâia mi inkhat a riming Mnason, ruoisi masa ngei lâia mi Cyprus tuihuola om ngâi ama han kin tungna rang ina mi sepui zoi. ");
INSERT INTO sch_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Jerusalem kin tungin chu iempungeiin râisântakin min lei dona. ");
INSERT INTO sch_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Anangtûka chu Paul'n Jacob ina mi sepuia ma mun han koiindang upangei murdi khom an oma. ");
INSERT INTO sch_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Anni ngei hah Paul'n chibai a pêk suole chu Pathien'n a ranak a minsila Jentailngei lâia sin a tho lam ngei hah anrêngin a misîr pe ngeia. ");
INSERT INTO sch_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ha thurchi hah an rietin chu anrêngin Pathien an minpâka, Hanchu Paul kôm, “Sungsuokpa, Judangei lâia iempungei tamlam le Balama an inpêk lam ngei nu mua. ");
INSERT INTO sch_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Nangman Jentailngei rama Juda omngei murdi kôm, Moses balam nûksonga an nâingei sertan khâiloi rang le Juda balam jûi khâiloi rang ni minchu ngâi ti mîn an rila. ");
INSERT INTO sch_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","No hong tung ti laka hi an riet ngêt rang ania, kho angin mo ei tho rang? ");
INSERT INTO sch_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Masikin chong nang kin be lam angtakin tho roh, chonginkhâmna lei dôn sai mi pasal minli an oma. ");
INSERT INTO sch_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Anni ngei hah tuong inla, an kôm nang khom inthieng inla an sam epna man hah nangman pêk roh, male chu mingei murdi'n nu thurchi an lei misîr ha dik mak ti hong riet thei an tih, nangma ke Moses balam ajûi mindik ti hong riet kelen an tih. ");
INSERT INTO sch_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Jentailngei lâia iempungei rangin chu, mirmil biekna sâ inthiengloi ngei, sâ alei thi sai ngei, ha renga athi ngei sâkloi rang le, hur inditna ngei khoma inthieng rang ani tiin lekha'n ei roijêk ei min riet zoi,” an tia. ");
INSERT INTO sch_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Masikin Paul'n anangtûka chu pasal minli ngei hah a tuonga an kôm ama khom ânthienga Pathien Biekina an lûta, inthiengna nikhuo ahek suomân chu inbôlna rang sângei pêk thei ni noni tiin ochai'n a lei ril ira. ");
INSERT INTO sch_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Aniatachu sûn sari ahek suo vâng dôrin Asia rama Judangei Paul hah Biekina an mua lokongei an misieta Paul hah an sûra. ");
INSERT INTO sch_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","An hêtsana, “Israel mingei mi san roi, ma miriem hih ramtina mingei murdi kôm, Israel mingei Moses Balamngei ma Biekin ngei hi a rilminsiet bang ngâipu hah ani, atûn reng hin khom ma Biekina hin Jentailngei a hong tuonga ma Biekin hih a min nim,” an tia. ");
INSERT INTO sch_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Ma anga an tina chu moton han khopuilien sûnga Ephesus'a renga Trophimus hah Paul kôm an mua, Biekin sûnga a tuong nîng atih, tiin an iem sikin). ");
INSERT INTO sch_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","A khopuilien pumpui an injêl sabak zoia lokongei hah an tama, Paul ha an sûra Biekin renga an mojôk paia Biekin ngei an khâr kelen zoia. ");
INSERT INTO sch_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Paul hah that rang an ti lâitakin Jerusalema mingei murdi an injêl ti Rom râlmi ulientak kôm an hong rila. ");
INSERT INTO sch_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Masuole chu, râlmi pâl ulientakpu han râlmi ulienngei le râlmingei hah a tuonga lokongei tieng an tân kelena, lokongei han, râlmi ulientak le râlmingei ha an mu lechu Paul an lei jêm hah an inngama. ");
INSERT INTO sch_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Hanchu, râlmi ulientak han a kôm a hong nâia, Paul hah a sûra a kuta zingjirûi inik a minbun kelena, masuole chu lokongei kôm han tumo ani le imo a tho minchâi a rekela. ");
INSERT INTO sch_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Lokongei an chong inruol khâi maka, pâl dadangin an chong hah ahong om zoia, lokongei an hêtsan rei sikin khoite mindik thei maka Paul hah kulpuia minlût rangin chong a pêka. ");
INSERT INTO sch_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Paul hah kalbi a phâk vâng dôr an tuonga, lokongei an pût rei sikin râlmingei han a domin an dom paia. ");
INSERT INTO sch_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Lokongei han “That roi” tia hêtsan chungin an jûi ngei bang. ");
INSERT INTO sch_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Hanchu, Paul han kulpui an minlût rangto han, râlmi ulientak kôm han “No kôm chong imakhat ti thei ning mo?” a tia. Râlmi ulientak han, “Greek chong ni riet mo?” ");
INSERT INTO sch_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","“Tiena misaloi mi thata isâng minli ramchâr tienga tuong, Egypt mi hah nimak che mo?” a tia. ");
INSERT INTO sch_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paul'n “Juda, Cilicia rama Tarsus khopuiliena suok ki nia, khuo kâm omtak mi ki ni, rangâihoitakin lokongei makunga hin chong thei rangin ni phal roh,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Male chu râlmi ulientak han chong thei rangin phalna a pêka Paul hah indingna mun han a vândinga, lokongei hah dâirek rangin kut a jâpa lokongei rahang adâi lehan Hebrew chongin a chonga: ");
INSERT INTO sch_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Ka champui Isrealngei ki dikna thurchi nin kôm ki ril hih rangâi roi!” a tia. ");
INSERT INTO sch_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Hebrew chongin a chong ti an riet lechu an dâirek uol zoia Paul'n a ti banga. ");
INSERT INTO sch_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Hanchu Paul'n, “Juda ki ni, Cilicia rama Tarsus khuoa suok ki ni, hannirese Jerusalema Gamaliel minchuna hong seilien ki nia, ei richibulngei anga balam inngartaka lei inchu ki ni. Aviensûn hin nangni ngei angtaka Pathien tienga theidôra inpêk ke lei ni. ");
INSERT INTO sch_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Hi Lampui lei jûingei hih that rang dôra lei pûta ku nuom lei lo ngâi ki ni, pasal nupang ku sûra intâng ina lei khum ngâi ki ni. ");
INSERT INTO sch_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ochai Inlalngei le Roijêkpungei murdi'n ko chong hih adik ti nangni ril thei an tih, an kôm renga Damascus taka Juda champuingei sûrna rang lekha ka mana, masikin ma khuo mingei hah sûra dûkmintonga zingjirûi leh khita Jerusalema hong tuong ranga se ki nia. ");
INSERT INTO sch_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Hanchu ke sea, Damascus khuo kôl kin phâk le sûnchimripa inningloi rengin invân renga vârin mi juong êla. ");
INSERT INTO sch_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Hanchu nuoia kên leta, chong ki rieta, ‘Sual, Sual ithomo dûk mi ni mintonga?’ a tia. ");
INSERT INTO sch_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Keiman, ‘Pumapa Tumo ni ni?’ tiin ke rekela, ama han ko kôm, ‘Keima Nazareth Jisua, dûk ni mintong ngâipu hah ki ni,’ a tia. ");
INSERT INTO sch_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ko kôla miriemngei han vâr chu an mua, hannirese ko kôma chong juong tung hah chu riet mak ngei. ");
INSERT INTO sch_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Keiman ‘Pumapa imo ko tho rang?’ ki tia, Pumapa han ko kôm ‘Inthoi inla Damascus khuo lût roh, mahan Pathien'n no tho rang ngei murdi nang lei ril atih’ a tia. ");
INSERT INTO sch_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Avâr hah avâr rai sikin ki mitngei khom ajînga, masikin ka champuingei han ku kutin min keiruoia Damascus khuoa kin lût zoi. ");
INSERT INTO sch_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Ma khopuilien han mi inkhat a riming Ananias, Pathien biek mi le balam lei jûi ngâi a oma, mataka Juda omngei murdi'n an mirit sabaka. ");
INSERT INTO sch_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ama hah ko kôm a honga, ko kôla ândinga, Lâibung Saul hong mu thei ta roh, mi tia. Ma zora tak han ko hong muthei nôk zoia, ama hah ko hong ena. ");
INSERT INTO sch_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ama han, ei richibulngei Pathien lungdo ngei riet rang le mi diktak tîrlâm hah mua, a chongbâingei riet rangin nang a thang ani. ");
INSERT INTO sch_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Nu mu le ni riet ngei angtak han mi murdi chunga rietpuipu na la ni rang sikin. ");
INSERT INTO sch_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Atûn reng, hi hin khoi mo na la ôt bang? Inthoi inla, baptisma chang inla ni sietnangei rusûk minsâina rangin a kôm chubaitho ta roh, a tia. ");
INSERT INTO sch_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Jerusalem tieng ki kîr nôka, Biekina Pathien kôm chubai ko tho lâiin inlârnân, ");
INSERT INTO sch_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Mahan Pumapa ku mua, ko kôm, ‘Inrangin Jerusalem mâk roh, ku thurchi ni misîr rang, hi muna mingeiin an modôm loi rang sikin’ a tia. ");
INSERT INTO sch_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Hanchu keiman, ‘Pumapa, synagog murdi ngei lûta nang iempungei lei sûra lei jêm ngâipu hah ki ni tiin min riet let kêng alei ni. ");
INSERT INTO sch_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Male no chong rietpuipu Stephan an that zora han khom ko oma, an that rang hah asa lei ti puipu le ama that ngei an puonngei lei dar pepu hah ki ni,’ ki tia. ");
INSERT INTO sch_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Pumapa'n, ‘Se roh, alataka Jentailngei kôm nang tîr ki tih,’” a tia. ");
INSERT INTO sch_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Hanchu, ha thurchi ten hah an rangâia, masuole chu rôl inringtakin an inieka minboi pai roi! That roi! a ring rangin chuk mak an tia. ");
INSERT INTO sch_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Anrêngin an inieka an puonngei an vôka, pildi invân tieng an vôra. ");
INSERT INTO sch_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Hanchu Rom râlmi ulientakpu han Paul hah rukulpui sûng tieng ruoi rangin chong a pêka, a chunga ma angdôra an hêtsana abi riet theina rangin jêm pumin rekel tit rangin a ti pe ngeia. ");
INSERT INTO sch_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Hannirese jêm ranga an khit suole chu, Paul'n a kôma inding râlmi razakhat ruoipu kôm han, “Rom mi adik loina khoite boi hih jêm rangin balam ani mo?” a tipea. ");
INSERT INTO sch_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Râlmi razakhat ruoipu han ha chong hah a rietin chu, râlmi ulientak kôm a sea. “Khoimo tho rang nin ti hi? Ma miriem hih Rom mi ke ani” a tipea. ");
INSERT INTO sch_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Masuole chu, râlmi ulientakpu hah Paul kôm a sea, “Rom mi ni ni mo, mi ril roh!” tiin a rekela, Paul'n “Ki ni,” a tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Râlmi ulientakpu han “Kei chu Rom mi changna rang hin sum tamtak ka thâm ok,” a tia, Aniatachu Paul'n kei chu “Rom mi nisai piela juonzir ki ni,” tiin athuona. ");
INSERT INTO sch_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Voikhat rengin, Paul kôma chong rekel rang dônpu ngei murdi khom an rot let zoia. Râlmi ulientak ha khom Paul hah Rom mi ani ti a riet lechu asân a chi zoi, moton han Paul ha zingjirûi leh a lei thung zoi sikin. ");
INSERT INTO sch_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Hanchu, anangtûka chu râlmi ulien han, Judangei itho sikin mo Paul an nônna riet rang a nuom sikin, a zingjirûi khitna an sût pea, ochaisingei le roijêkpungei murdi lei intûp rangin chong a pêka, masuole chu Paul ha a tuonga an makunga a minding zoi. ");
INSERT INTO sch_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paul'n roijêkpungei hah a en ngita, “Ka champui Isrealngei aviensûn ten hin Pathien mâkunga sielesarietna diktak dônin ko tho rang ngei murdi ko hong tho ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ochai Inlaltak Ananias han, Paul kôma inding ngei kôm han Paul hah a bâikuo bên pe roi, a ti pe ngeia. ");
INSERT INTO sch_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Paul'n a kôm, “Nangma, bang rusûk minchekpu Pathien'n nang bên atih, a tia. Mahan nên sunga Balam anga roijêk rangin nên sunga balam khêlin mi min bên rang ni ti mo!” a tipea. ");
INSERT INTO sch_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Paul kôm inding ngei han, Paul kôm han “Pathien Ochai Inlaltak khom jâ loiin khoi ithomo no ngo,” an tia. ");
INSERT INTO sch_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paul'n “Ka champuingei Ochai Inlaltak ani ti ki riet loi sika kêng, Pathien lekhabu'n ‘Ni mi, roijêkpungei chunga chong saloi ni ti rang nimak ati,’” a tia. ");
INSERT INTO sch_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Paul'n Sadduceengei senkhat, Pharisee ngei senkhat le anni ti a riet lechu, roijêkpungei lâia han inringtakin “Ka champui Isrealngei keima Pharisee ki ni, Pharisee nâipasal ki ni, keiman mithi inthoinôkna aom ti sabeina ko dôn sikin ma angtaka intakna ko om ani,” a ti pe ngeia. ");
INSERT INTO sch_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Maha a ti suole chu, Pharisee ngei le Sadduceengei bâiinkhamin pâl inikin an insena. ");
INSERT INTO sch_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Sadduceengeiin chu mithi inthoinôkna reng om mak, vântîrtonngei, rathangei ommak, aniatachu Pharisee ngeiin chu anin thumin an iem sikin.) ");
INSERT INTO sch_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Hanchu an iniek hah ânring uola, Pharisee tienga Balam minchupungei senkhat an indinga asân an makhala, “Hi miriem hih a tho minchâina khoite mu mak me, vântîrton le ratha'n a chongpui tatak khom nisenla khoimo asiet?” an tia. ");
INSERT INTO sch_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Hanchu asân an inkhal sikin Paul hah khêr nôinek ni ngei tiin râlmi ulientak han a chia, râlmingei hah lokongei lâia han juong sea, Paul hah hong tuonga kulpui sûng tieng tuong pai rangin chong a pêka. ");
INSERT INTO sch_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Mani jân han Pumapa hah, Paul kôm a juon dinga, a kôm, “Chi no roh! Jerusalema ko chong ni min riet angdên han Rom khopuia khom ko chong la min riet nôk ni tih,” a tipea. ");
INSERT INTO sch_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Anangtûk jînga chu Juda senkhatngei an intûpkhôma, huongvâr an sina Paul an that mân chu ite sâkloi rang nêkloi rang tiin khomâk an insâma. ");
INSERT INTO sch_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ma anga tho ngei hi mi sômminli nêkin an tama. ");
INSERT INTO sch_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Hanchu anni ngei hah ochaisingei le upangei kôm an sea, “Paul kin that mân chu ite sâkloi rang nêkloi rangin khomâk kin insâm ke ani zoi. ");
INSERT INTO sch_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Masikin atûn hin, nangnin roijêkpungei le a roi asa uola jêk rang angin Paul hi nin kôm juong tuong rangin Rom râlmi ulientak kôm chong hong pêk roi, nin kôm a juong tung mân khom lei that rangin kin insiem suo ke ani zoi,” an tia. ");
INSERT INTO sch_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Hannirese ma thurchingei hah Paul a tupa'n a lei rieta, kulpui sûnga a va lûta, Paul a va rîla. ");
INSERT INTO sch_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Hanchu Paul han râlmi razakhat ruoipu inkhat a koia, “Hi ruotharte hi râlmi ulientak kôm tuong roh, râlmi ulientak kôma chong khat ril rang a dôn,” a tipea. ");
INSERT INTO sch_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Râlmi ulientakpu kôm a tuonga, “Intâng ina ompu Paul han mi koia hi ruotharte hi no kôm hong thak rangin mi tia, no kôm hin chong inkhat ril rang a dôn tiin chong mi be sa,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Râlmi ulientak han a kut a sûra, mun ânkilna uola a tuonga “Imo mi ril rang no dôn,” tiin a rekela. ");
INSERT INTO sch_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ama han, “Juda rachamneipungei Paul a roi hi adik uola jêk rang tiin nangtûka roijêkpungei kôma tuong rang minlêmin nang an hong zong rang ani. ");
INSERT INTO sch_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Hannirese an chong lei don no roh, an lâia mi sômminli nêka tam uolin Paul an that mân chu ite sâkloi rang nêkloi rang tiin chong an inkhâm, atûn hin that rangin an insiem chak kêng ani zoi no chong vai ke an ngâk,” a tipea. ");
INSERT INTO sch_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Râlmi ulientak han, “Hi thurchi hi ko kôma ni misîr pêna chu tute kôm misîr khâi no roh,” tiin chong a bea. Male ruotharte hah a min se zoi. ");
INSERT INTO sch_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Hanchu, “Râlmi razanik ruoipu inik a kôia, avien jân, dârkuo dôrin Caesarea se rangin râlmi razanik le, sakor chung chuong thei sômsari le isei a chôi râlmi razanik insiem roi, ");
INSERT INTO sch_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Mapêna han Felix kôm a tung ngêt theina rangin, Paul a chuongna rang sakorngei khom mintuo pe sa rangin chong a be sa zoi.” ");
INSERT INTO sch_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Male Râlmi ulienpu han, hi anghin lekhamuthuon a mizieka. ");
INSERT INTO sch_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Claudius Lysias Râiôt jâ omtak Felix: chibai a pêk. ");
INSERT INTO sch_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Hi miriem hih Judangei an sûra, that rang an ti lâitakin ka râlmingei juong kêlsuo rangin ke sea, Rom mi ani ti ki riet sikin ko hong sanminjôka. ");
INSERT INTO sch_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","An nônna bi riet rang ku nuom sikin, an roijêkpungei kôm khom ku tuonga. ");
INSERT INTO sch_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Anni an balama a lekti sikin an nôn pai ani ti ki rieta, hannirese thi rak rang dôr le intâng ina omna rang dôr ite minchâi mak. ");
INSERT INTO sch_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Male Judangei that rangin an pût tit ti min rîla, masikin no kôm ku juongtîr kelen ani. A nônpungei khom a thurchi misîr rang a nônpungei murdi chu no kôm hong misîr rangin chong ke pêk ngei,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Hanchu râlmingeiin a chongpêk angin Paul hah an tuonga mani jân han Antipatris khuo an tungpuia. ");
INSERT INTO sch_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Anangtûka chu râlmi kea se ngei hah chu rukulpui tieng an kîr nôka, sakor chunga chuong mingei vai hah Paul sepui tit rangin an oma. ");
INSERT INTO sch_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Hanchu Caesarea an tuonga, Râiôt kôm lekha hah an pêka, male Paul ha khom a kuta an bang kelena. ");
INSERT INTO sch_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Râiôt'n lekha hah a pore suole chu Paul omna ram a rekela, Cililia ram mi ani ti a riet lechu a kôm, ");
INSERT INTO sch_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","“Nang nônpungei an juong tung lehan no roi hih keiman rangâi ki tih,” a tipea. Hanchu Paul hah râiôt omna munpuia han dara vêng bang rangin chong a pêk ngeia. ");
INSERT INTO sch_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Sûn rangnga suole Ochai Inlaltak Ananias hah upangei senkhat le balamtheipu a riming Tertullas ngei le Ceasarea khuoa an sea. Felix makunga an vânlanga male Paul an nônna roi hah an va rila. ");
INSERT INTO sch_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Hanchu Paul hah an koi lûta, male Tertullus'n hi anghin an nônna roi a hong misîr phuta: “Nasa sabak na! No roijêk theina jârin inngêi takin zora sôtak kin om ngâi sik le kin ram sana rang sinsiem anângngei murdi khom nangman mi ni thop sikin. ");
INSERT INTO sch_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Kho zora khoma, kho muna khom râisântakin kin om ngâi. ");
INSERT INTO sch_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","No zora minchâi ok rang hi jôt mu ung han khom nu nunhoina sikin ko chong bongkik hi mi lei rangâi pe rangin nang ko hong ngên. ");
INSERT INTO sch_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ma miriem hin asân mi min jêla; muntina Judangei lâia injêlnangei a musuok phuta Nazareth pâla ruoipu inkhat ani ti kin riet. ");
INSERT INTO sch_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Pathien Biekin min nim rangin a tho ngâi sikin kin lei sûr ania, kin balam angin a roi hih jêk kin nuoma. ");
INSERT INTO sch_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Hannisenla, râlmi ulientak Lysias a honga, male rangrât rengin kin kôm renga a tuonga. ");
INSERT INTO sch_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ama nônpungei khom na makunga inlang rangin chong a pêk sa, nangma reng khomin rekel inla, kin nônna bi ngei hi ama renga khom hin riet thei ni tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Judangei khomin an nônna an lei thopa ma ngei murdi hah adik kêng an lei tia. ");
INSERT INTO sch_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Masuole chu râiôt'n Paul hah chong rangin kut jâpin a kôia, Paul'n, “Kum tamtak hi jât nget chunga roijêkpu ne lei ni ti ki riet sikin asân ka râiasâna, râisântakin na makunga hin ki dikna thurchi ki misîr rang ani, a tia. ");
INSERT INTO sch_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Jerusalema Pathien biek rangin ko hong se ni renga hi sûn sômleinik pên lani nonih ti nangma rengin riet thei ni tih. ");
INSERT INTO sch_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Pathien Biekina tute kên khal puina omak, Synagogngeia le khopuiliena, kho mun khoma, Mipuingei saloi tho ranga ki misietna Judangei mu mak ngei. ");
INSERT INTO sch_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Atûna no kôma min juong nônna hi khom inthâr takin misîr thei no ni ngei. ");
INSERT INTO sch_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Nikhomrese hi chong hih no kôm muphuong ki tih: Anni ngeiin minchuna dikloi an lei ti ngâi lam dang tieng ei richibulngei Pathien ke lei jûia, hannirese Moses Balama lênziek le dêipungei lekhabungei murdi chu ke lei iem ani. ");
INSERT INTO sch_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Keima khom anni ngei angin Pathiena sabeina ko dôn, mi murdi ngei, midik le dikloi, thina renga inthoinôkna ngeia. ");
INSERT INTO sch_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Masikin Pathien le miriem makunga hin sielesarietna diktak hih kho zora khom dôn tit rang hih ke lei nuom tak ani. ");
INSERT INTO sch_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Kum tamtak Jerusalem ka mâk suo nûkin, ka jât mingei rang sum le inbôlnangei pêk rangin ke sea. ");
INSERT INTO sch_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ma zora han inthiengna ko dôn suole Biekina min mua, ma zora han mipuingei khom ommak ngeia ite rahang a rât khom om mak. ");
INSERT INTO sch_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Hannirese, Asia rama Judangei senkhatngei mahan an oma; anni ngei han min nônna thurchi hin imo misîr rang an dônin chu, no kôm hin juong misîr rese ngei. ");
INSERT INTO sch_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Nônchu ma muna mingei hin roijêkpungei makunga kên ding zora han imo ki minchâina an man misîr rese ngei. ");
INSERT INTO sch_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Hi neinun inkhat an makunga kên ding lâia ki ti telloiin chu: ‘Mithi inthoinôkna aom tiin iemna ko dôn ti hi aviensûn ten hin hi angtaka dûktonga ko omna chu ani.’ ” a tia. ");
INSERT INTO sch_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Hanchu Felix hah, ma roi hah asadima lei min riet ani sikin, roijêkna hah a minngama, “Râlmi ulientak Lysias a juong tung tena nin roi hi la jêk rong,” a ti pe ngeia. ");
INSERT INTO sch_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Hanchu Paul a rungpu ulientak kôm han asadima enkôl rangin chong a pêka, aniatachu alekti mojôk rangin le a malngei anângngei pêk thei rangin phalna a pêka. ");
INSERT INTO sch_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Sûn idôr mini suole Felix le a lômnu Drusilla, Juda nupang leh an honga. Paul hah an kôia Jisua Khrista taksônna roia an chonga, a thurchi hah an rangâia. ");
INSERT INTO sch_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Paul'n dikna ngei, indînna, male roijêk nikhuo ahong tung rang ngei, a misîr pea anînchu Felix han asân a chia, “Atûn chu ne se thei zoi. Zora ka man tika nang koi nôk ki tih,” a tipea. ");
INSERT INTO sch_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ma zoratak han Paul'n sum mi pêk duoi mo ti sabeina a dôna; masika han a kôia a chongpui bang ngâi ani. ");
INSERT INTO sch_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Kum inik dôr a vunsuo lechu, Porcius Festus, Felix hah râiôt'n a thûl zoia. Felix han Judangei modômna man rang a nuom sikin Paul ha intâng ina a mâk chiena. ");
INSERT INTO sch_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Hanchu Festus'n ha ramhuol hah a tunga, sûnthum suole chu Caesarea renga Jerusalema a sea. ");
INSERT INTO sch_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Mahan ochaisingei le Juda ruoipungeiin Paul hah an hong tuonga an nônna Festus kôm han an ngêna ");
INSERT INTO sch_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","an nuomna thope ngeia Paul hah Jerusalema hong tuong rangin, asikchu lampuia lei that rang an bôk sikin. ");
INSERT INTO sch_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festus a thuona, “Paul hi Caesarea intâng ina lei dar ania male keima khom mason se nôk lei rang ki ni. ");
INSERT INTO sch_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Nin ruoipungei Caesarea tena mi jûi senla ngei ma miriem hah a tho lei minchâina aomin chu juong nôn rese ngei,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festus hah sûn riet mini, sûn sôm mini, anni ngei leh ala châma male Caesarea tieng a se zoi. Anangtûka chu roijêkna ânsunga Paul hah hong tuong rangin chong a pêka. ");
INSERT INTO sch_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Paul hah a hong tung lechu a kôm han Jerusalem renga juong Judangei hah a rihîla an indinga an nônna thurchi tamtak an misîra, minthârna man mak ngei. ");
INSERT INTO sch_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Aniatachu Paul han athenin ânrunga: “Judangei balam roia, Biekin roia nônchu Caesar chunga khom ite minchâiin doina lei tho mu-ung,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Hannirese Festus han Judangei modômna man rang a nuomna, masikin Paul kôm han a rekela, “Jerusalema sea, ka makunga nang an nônna ngei hih khi taka hôn jêk rang nu nuom mo?” a tia. ");
INSERT INTO sch_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paul'n, “Caesar roijêkna makunga ko roi an jêkna muna jêk pea om rang piela inding ki ni. Judangei chunga ite minchâina dôn mu ung ti nangma khom ni riet sai ania. ");
INSERT INTO sch_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Balam ki minchâia, thi rang dôrin minchâina ko dôn anîn chu, thi rang khomin kên phal. Hannirese min nônna ngei hi adikloi anin chu tutên an kôm mi pêk thei no ni ngei Caesar kôm tung ki tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Hanchu Festus roijêkpungei, a chongpui suole chu, “Caesar kôm tung rang nu nuom lam angtakin tung ni tih,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Sûn idôr mini avun suole chu Rêng Agrippa le Bernice Caesarea an hong tunga Festus mirit an pêka. ");
INSERT INTO sch_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Sûn tamtak an om nûkin, Festus'n Paul thurchi ngei hah Rêng kôm han a misîr pea Felix han mi inkhat intâng ina hin a mâka. ");
INSERT INTO sch_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Jerusalema ke sea han, Juda Ochaisingei le Juda ruoipungeiin asân an lei nônna dikloi minchang ngêt rangin ko kôm an ngêna. ");
INSERT INTO sch_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Aniatachu hi anghin ki tipe ngei, “An nônpu le a nônpungei mâi intongin, an nônpu han an nônna roia han a dikna thurchi misîr rang a riet khâi noa, dikloi ani ti ânlang mân chu mojôk rang hih Rom mingei balam nimak. ");
INSERT INTO sch_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Mahin an juong tung suo nûkin zora sôtloiin anangtûka roijêkna taka kên sunga, ama hah hong tuong rangin chong ke pêka. ");
INSERT INTO sch_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","A nônpungei hah an indinga, aniatachu Paul chunga han ma dôra dikloina khoite an misîr angin riet mu-ung. ");
INSERT INTO sch_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","An inkhalnangei senkhat ha chu sakhuo roia ania mi inkhat a riming Jisua an ti, ama hah a thia; aniatachu Paul'n ama hah aring nôk a tia. ");
INSERT INTO sch_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Keiman chu ma thurchi ngei ha chu a jêkna chang khom riet mu-ung, masikin keiman Paul ke rekela Jerusalema a sea mahan ajêk rangin nu nuom mo? tiin ke rekela. ");
INSERT INTO sch_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Aniatachu Paul han Caesar jêk pe rangin a ngên sikin, ki min se thei mân chu lei donsûi rangin chong ke pêk ngei ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agrippa han Festus kôm, “Kei khom ma miriem hah a chong rangâi rang ku nuom,” a tia. Festus'n “Nangtûka rangâi ni tih,” tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Anangtûka chu Agrippa le Bernice han inlal takin mipuingei intûpna an va lûta, râlmi ulienngei le khopuilien sûnga ulienngei khom an oma. Hanchu Festus chongpêkin Paul an hong tuonga. ");
INSERT INTO sch_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festus han, “Rêng Agrippa le kin kôma omngei murdi, hi mi hih nin mu ania, Judangei murdi'n hi taka omngei le Jerusalema omngei murdi'n ko kôm an juong nônna min ring khâiloi rangin an in-iek. ");
INSERT INTO sch_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Hannisenla thina rang dôr ite tho minchâina dôn mak ti ki rieta. Aniatachu ama'n Ceasar kôm tung rang a nuom sikin tîr rangin ki ti ani. ");
INSERT INTO sch_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Aniatachu, a thurchi hi Ceasar kôm ki miziek rang hi ânthârin riet mu-ung, masikin nin kôm ko hong tuong ani hi, Rêng Agrippa nangma kôm hin ani uol, a chungroi nin phuol suole, a miziek rang imakhat ko dôn thei rang. ");
INSERT INTO sch_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Asikchu mi intâng ina om, an nônna bi inthârlaka ril loia tîr rang chu keima rangin omzie boi aphuo rang,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agrippa'n Paul kôma, “Ni dikna thurchi misîr thei rangin phal ni nih,” a tipea. Paul'n a kut a phara a dikna thurchi, hi anghin a misîra: ");
INSERT INTO sch_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Rêng Agrippa! Judangei min nônna murdia ki dikna thurchi avien hin no kôm ki misîr rang sikin asân ka râlvân asa okin ki riet, ");
INSERT INTO sch_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","mahin, Judangei balam le ânjêlna omngei murdi ni riet minthâr sikin rangâihoitakin ko chong hi ni lei rangâi pe rangin nang ko hong ngên ani. ");
INSERT INTO sch_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Judangei murdi'n nâipang ka chang lâia ko omlam le ku nunchan, motona kin rama, masuole Jerusalema khom an rêngin an riet. ");
INSERT INTO sch_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","An misîr nuom ngânin chu, ku thurchi hi aphut renga an riet let, ei sakhuo tienga pâl inngartak Pharisee ngei lâia ke lei omngei hah. ");
INSERT INTO sch_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Male atûn ei richibulngei kôm Pathien chong a lei khâmsai hah sabeina sikin hima mun hin kên ding ani. ");
INSERT INTO sch_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ma chonginkhâm sika han ei jât sômleinik ngeiin sûn le jânin Pathien chubai an lei mûk ngâi ani, male ma sabeina sika han Pumapa, hima sikin kêng Judangei hin min nôn ani. ");
INSERT INTO sch_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Pathien'n mithi a kaithoi ngei thei ani, tiin hi taka omngei hin ithomo nin iem theiloi? ");
INSERT INTO sch_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Keima nanâk khom hih Nazareth Jisua riming doiin neinunngei murdi tho ngâi ke lei ni. ");
INSERT INTO sch_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Maha Jerusalema ke lei tho ngâi. Ochaisingei renga rachamneina ngei ka mana, male Pathien mingei tamtak intângna ina ke lei khum ngâi; male that rang an ti zora khomin, asa ke lei ti pui ngei ngâi. ");
INSERT INTO sch_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Synagogngeia khom voi tamtak dûk ke lei mintong ngei ngâi, an taksônna ngei min mâk rangin ke lei pût ngâia, ka takasi rei sikin ram dang khopuilienngei khom ku nunuom lo rangin ke se ngâi. ");
INSERT INTO sch_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Ma rang sik piel han ochaisingei renga rachamneina le phalna chôiin Damascus khuoa ke sea. ");
INSERT INTO sch_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Pu Mirit-omtak, lampuia ke se lâitak sûnchimripa, O Rêngpa, invân renga juong vâr, nisa nêka vâr uol hah, keima le ka champuingei revêla hin ajuong êl ku mua. ");
INSERT INTO sch_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Kin rêngin nuoia kin inleta, male Hebrew chongin ‘Saul, Saul! ithomo nangman nu nunuom mini loa? Nangmananâk kêng nang minna rang, serâtchalin a pumapa tôkmola doiin athâi anghan’ kêng ani rang. ");
INSERT INTO sch_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Keiman, ‘Puma tumo ni ni?’ tiin ke rekela, male Pumapa han, ‘Keima hih Jisua, dûk ni mintong bângpu hah ki ni, tiin a thuona. ");
INSERT INTO sch_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Aniatachu, inthoi inla ne ke leh inding roh, ki sinthopua nang phun rangin no kôm ku juong inlâr ani. Avien sûna keima renga nu mu ngei le sûnmoton tienga nang ki min mu rang ngei murdi hi midangngei khom ril roh. ");
INSERT INTO sch_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Israelngei le Jentailngei renga nang kêlsuo ki tih, nang ki tîrna rang ngei kôm renga. ");
INSERT INTO sch_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","An mitngei minvâr pe ngei na ta, hanchu ijîng renga avâr tieng hong inhei an ta, soitan kut renga Pathien tieng hong inhei an tih, masikin ku chunga taksônna an dôn sika an sietnangei ngâidam an changna rang le Pathien mi thang ngei lâia mun an manna rangin.’ a tia. ");
INSERT INTO sch_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Male, Rêng Agrippa, invân renga inlârna ku mu jômloiin tho mu-ung. ");
INSERT INTO sch_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Motontaka Damascus sûnga male Jerusalem sûnga male chu Judea ram murdi le Jentailngei lâia khom, an sietnangei renga insîrin, male Pathien tieng an nin hei zoi ti riet theina rangin thurchi ki misîr pe ngâi ani. ");
INSERT INTO sch_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Masik taka han hi Judangei Biekin sûnga ko om han min sûra, male ma that rang an pût ani. ");
INSERT INTO sch_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Aniatachu avien sûnten hin Pathien'n ni sana, male mi chîn le mi lien ngei kôm indingin rietpuipu nina hih nin rêngin nin kôm ka la misîr thei ani, ki ti ngâi ngei chu, Moses le dêipungeiin la juong tung atih, an ti bang ngâi hah ani: ");
INSERT INTO sch_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Messiah han dûktong ngêt a ta, male thina renga inthoinôk masatak nîng atih, Sanminringna vâr thurchi Judangei le Jentialngei kôm muphuong atih,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Ma anghan, Paul'n a dikna thurchi a misîr lâitakin, Festus hah a hong hêtsana, “Paul, na châng ke ani zoi! nên chu mintam rei sikin na châng zoi!” a tia. ");
INSERT INTO sch_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Paul'n, châng mu-ung, Festus mirit omtak hangvangin adiktak ki misîr ani. ");
INSERT INTO sch_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Rêng Agrippa! hâitakin no kôm ko chong thei, hi neinunngei chungroi hih ni riet sikin, hi thurchi hih inkila tho nimaka a kôm hin ite ip rang ommak ti ki riet mindik ani. ");
INSERT INTO sch_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","“Rêng Agrippa dêipungei ni iem mo? ni iem ti ki riet ani!” ");
INSERT INTO sch_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agrippa han Paul kôm, ma zora bongte sûng hin Khristien mi min chang rang no bôk mini? a tia. ");
INSERT INTO sch_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paul'n, “zora bongtên mo, aseiin mo, nangma vai nang ti mu unga, avien sûna ko chong rangâi ngei murdi hih keima anga om rangin Pathien kôm ke ngên bang ngâi hi zingjirûi hi chu bun uol loi rangin!” tiin athuona. ");
INSERT INTO sch_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Hanchu Rêng, le Râiôt, le Bernice, le adangngei murdi an inthoi leta, ");
INSERT INTO sch_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Male an mâk suole anni le anni a nin tia, “Hima miriem hin a thina rang dôra le intângna ina khum rang dôra minchâina dôn mak.” ");
INSERT INTO sch_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Male Agrippa han Festus kôm, “Hi miriem hin Caesar kôm tung rangin lei inzong no rese chu, ma reng hin mojôk thei rang piel ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Italy taka rukuonga se rangin kin masat lehan, Paul le intângna ina om senkhatngei hah “Rom râlmi pâl” ulien Julius kuta an bang ngeia. ");
INSERT INTO sch_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Adramyttium renga rukuonga kin sea Asia ramhuol sûnga rukuong inngamna mâk rangin ânthoka male Aristarkus Macedonia rama Thessalonika khuo mi kin kôm a oma. ");
INSERT INTO sch_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Anangtûka chu Sidon kin tunga. Julius han Paul hah lungkham a mua, male a malngei vântongpui rangin phalna a pêka a nângngei an lei pêk theina rangin. ");
INSERT INTO sch_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Ma renga han kin se nôka, male phâivuon anôk tieng mi hong sêm sikin Cyprus tuihuola kâirêng omna tieng kin se zoia. ");
INSERT INTO sch_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Cilicia rama tuikhanglien kin rakâna male Pamphylia le Lycia rama Myra kin hong zoi. ");
INSERT INTO sch_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Mahan râlmi ulien han rukuong inkhat Alexandria renga hong Italy rama se rang a mua, masikin mahan mi min chuong zoi. ");
INSERT INTO sch_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Nikhuo tamtak thâmin jâm jâmin kin sea male intak takin Cnidus khopuia kin tunga, phâivuo han ma tieng han mi min se thei maka, masikin kâirêng omna Crete tuihuol tieng asukin kin sea, Cape Salmone kin tung zoi. ");
INSERT INTO sch_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Tuipâng kin vanâia male intak takin Rukuong Inngamna Hoi, an ti hah kin hong tunga, Lasea khopui renga hah labâk mak. ");
INSERT INTO sch_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Mahan nikhuo tamtak kin min hek zoi sikin rukuong dêna se nôk rang hah chi a oma, Ratanna Nikhuo alei vun zoia, Masikin Paul'n hima rilna hih a pêk ngeia. ");
INSERT INTO sch_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Miriem ngei, atûn renga ei mântieng hi chu asân chi aom ti ku mua, sietna le inmangna lientak rukuong le a neinunngei chunga le ei ringna khom ânmang thei.” ");
INSERT INTO sch_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Aniatachu râlmi ulienpu han Paul chong jôm nêkin rukuonga ulienpu le rukuong pumangei chong a mindon ngei uola. ");
INSERT INTO sch_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Rukuong inngamna hah phalbia omna rangin asaloi sikin mi tam uolin an omna renga sea, Phoenix an tung theia anin chu la tunga ma muna han phalbi la min hek rangin a min sûka. Phoenix chu Cret tuihuola rukuong inngamna inkhat thang-mâr le sak-mâr maiinthak ani. ");
INSERT INTO sch_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Thang phâivuo jâmin ahong lechu an mintuo tak ha an tho thei rangin an bôka, thîrrûi ha a kaisuoa Crete tuipâng tienga han nâi theidôra nâiin an jâpa. ");
INSERT INTO sch_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Aniatachu chomolte ani lechu phâivuo râttak “Sak-sim” an ti ngâi hah tuihuol renga ajuong sêma. ");
INSERT INTO sch_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Rukuong hah ajuong tokthapa, phâivuo mâithakin kin se thei khâiloi tena chu pût khâi makme phâivuon rukuong ha asemna titieng mi chôia. ");
INSERT INTO sch_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Cauda tuihuol saktieng kin khêl lechu kâirêng chînte kin mana. Mahan, intak takin, rukuong sûnga rukuong chînte hah kin kêlsuo theia. ");
INSERT INTO sch_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","An kêlsuo nûkin insanna rûi lehan rukuong nuoitieng an thunga an khitbela. Libya tuipânga sietsâia mi nôngpai atih, ti an chi sikin puonjâr hah an min nuoia, male phâivuon ajôtna titieng amin sêma. ");
INSERT INTO sch_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Phâivuo hah ala rât tit sikin anangtûka chu neinun hah senkhat an vôr paia, ");
INSERT INTO sch_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","male hatûknôka chu rukuonga mangruo neinunngei ha an vôrpai nôka. ");
INSERT INTO sch_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Nikhuo tamtak nisa, ârsingei khom inlang khâiloiin phâivuopui râtin ahong sêm tit sikin amongnataka chu ring rang khomin in sabei khâi makmea. ");
INSERT INTO sch_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Masuole bunêk loia zora sôttak an om nûkin, Paul'n an motona ândinga male, “Miriemngei, ko chong hah nin rangâia Cret tuihuol renga ei juong khâiloi nirese chu hi sietna le inmangna hi tong loi rang ei nia. ");
INSERT INTO sch_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Aniatachu atûn hin nangni ke ngên ratha inngamtakin om roi! tute nin ringna machân uol no tunui, rukuong hi vai kêng machânin aom rang. ");
INSERT INTO sch_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ata ki nia, a sin ki sin bang ngâipu Pathien vântîrton inkhat jânin han ko kôm a juonga. ");
INSERT INTO sch_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‘Paul, chi no roh! Caesar makunga lânding ngêt ni tih. Male Pathien asatna sikin rukuonga na champuingei ringna khom hôi pe ngei atih.’ ");
INSERT INTO sch_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Masikin miriem ngei rathângamtakin om roi! Pathien ka sabei sikin mi juong ril angin nîng atih. ");
INSERT INTO sch_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Aniatachu kho tuihuol pânga makhata mi chôi atih.” ");
INSERT INTO sch_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Mediterranean tuipuia jân sômleiminli phâivuopuiin mi chôi suo nûkin, jânchimripa rukuongpungei hah tânga suok thei rangin an mindona. ");
INSERT INTO sch_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Masikin anni ngei han tui minkhina le an minkhia metres 40 ânthûka; chomolte suole chu ma angdên han an thoa metres 30 an man nôka. ");
INSERT INTO sch_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Kho lungkâra makhat mi juong nông nih ti an chi sikin rukuong remei tieng thîrrûi minli dôr an juong mathâka khuovâr rang ngâklalin chubai an tho. ");
INSERT INTO sch_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Hanchu rukuongpu ngei han, rukuong renga rotpai rang an pûta; rukuong chînte hah tuia an mathâka, rukuong moton tienga han thîrrûingei mathâk inlêmin an thoa. ");
INSERT INTO sch_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Aniatachu, Paul'n râlmi ulienpu kôm le râlmingei kôm, “Rukuongpungei hah rukuong chunga an om nônchu nin ring rangin sabeina om mak,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Masikin, râlmingei han rukuong chînte rûi hah an âtsata, an min se zoi. ");
INSERT INTO sch_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Khuo ahong vâr vângin, Paul'n, bunêk rangin a ngên ngeia: “Aviensûn ten hin sûn sômleiminli nin ngâkna ani zoia, male madôr zora sôt hi khoite sâkloi nêkloia nin om ani zoi. ");
INSERT INTO sch_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Bunêk rangin nangni ke ngên, nin ring theina rangin. Nin lua samsang inkhat luo inmang no nih” a tia. ");
INSERT INTO sch_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Mahi a ti suole, Paul'n vâipôl senkhat a lâka anrênga makunga han Pathien kôm râisânchong a rila, a khoia an sâk phut zoi. ");
INSERT INTO sch_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Anni ngei khom han an ratha ânngama an rêngin bu an nêk zoi. ");
INSERT INTO sch_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Rukuonga miriem hah kin rêngin 276 kin ni. ");
INSERT INTO sch_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Mitinin an khop dôr an nêk suole chu rukuong hah ajâng theina rangin bungei hah tuikhangliena an vôrpai zoi. ");
INSERT INTO sch_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Khuo ahong vârin chu, rukuongpungei han kho mun mini rietthei mak ngeia, aniatachu, tui inkilna mun inkhat sietsâibil an mua, anithei nisenla chu ma mun han rukuong hah tâng makhâi ngêt rang an pûta. ");
INSERT INTO sch_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Masika han thîrrûingei hah an âtsata, male tuikhangliena han an minngima, an jâpna thîrrûingei khom madên han an sûta, mântieng puon an mazara phâivuon ajôtna titieng atuong thei rang lam takin an min sânga sietsâibil an va muna tieng han an pan zoia. ");
INSERT INTO sch_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Aniatachu tuisou inik inchunna taka kin lûta rukuong lu han tâng ava sika rukuong lu hah singinsa thei khâiloiin ân-ôk tita, rukuong remei tieng hah tuidârinsokin ahong suka akoi zoi. ");
INSERT INTO sch_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Intângna ina intâng ngei hah tui inlieiin lei rot ni ngei ti sika han râlmingei han anrêngin that let rang an mintuoa. ");
INSERT INTO sch_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Aniatachu, râlmi ulienpu han Paul hah mojôk rang a nuoma masikin hima anga an tho hah a khap ngeia, manêkin tui inliei thei ngei kai chu tui inlieia tâng lei kâi rangin; ");
INSERT INTO sch_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","adangngei khom thingpêk chunga aninônchu rukuong hârngei lehan tâng lei kâi rangin chong a pêk ngeia. Ma anghan kin rêngin damtakin tâng kin kâi zoi ani. ");
INSERT INTO sch_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Damtakin tuipânga kin hong lehan, tuihuol hah Malta ani ti kin riet zoi. ");
INSERT INTO sch_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Ma rama mingei hah keini rangin mal satak an lei nia. Ruo ajuonga adâi sikin mei an thoa male kin rêngin uôt rangin min modôm ani. ");
INSERT INTO sch_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paul han thing pomkhat ava lâka meia a tuoa alum lehan murûl ahong jôka Paul kut hah a muchuka a kher tita. ");
INSERT INTO sch_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Ma rama mingei han Paul kuta murûl akâi hah an mua, inkhat le inkhatin, “Ma miriempa hi mi thatpu kêng ani ngêt rang, tuikhanglien renga damin a hong jôka, aniatachu adika roijêkpu han min ring no nih,” an tia. ");
INSERT INTO sch_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Hannirese, Paul han murûl hah mei lâia a hirthâk paia, khoite tiriêk mak. ");
INSERT INTO sch_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Anni ngei han chu inthing a ta, aninônchu harenghan inletin a thi rang, ha an ôta. Hannisenla zora sôtzan an ôt suole khoite ati an mu loi lechu, an mindona hah an thûla, “Paul hi pathien kêng ani duo!” an ti zoi. ");
INSERT INTO sch_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ma mun le inla bâkloi han ram alekti a oma a puma chu, tuihuola an ruoipu lien a riming Publius ani. Ama han mulunghoitakin mi lei modôma sûnthum tena khuolmi kin chang ani. ");
INSERT INTO sch_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Publius a pa hah jâlmun sûnga a oma, ritun le êksen damloi ani. Paul hah khâltana ava sea, chubai a thoa, a chunga a kutngei a minngama, a mindam zoi. ");
INSERT INTO sch_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Masuole chu, ma tuihuola om damloi dangngei murdi an honga an dam zoi. ");
INSERT INTO sch_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Neinun ngâihoipêk tamtak min pêka, male rukuonga kin se lehan, rukuonga kin om sûnga kin nâng rang ngei hah rukuonga an dar zoi. ");
INSERT INTO sch_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Thânthum suole chu Alexandria renga rukuong inkhat han kin sea, ariming “Pathien Inphîr,” maha phalbia ma tuihuola alei om sai ani. ");
INSERT INTO sch_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Syracuse khopuilien kin tunga male mahan sûnthum kin oma. ");
INSERT INTO sch_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Ma renga hah kin se nôka male Rhegium khopuilien kin tunga. Anangtûka chu sim phâivuo ahonga, sûnnik sûngin Puteoli khopui kin tung zoi. ");
INSERT INTO sch_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Mahan iempungei senkhat kin mua an kôm sûn sari nikhuo châm rangin min tia, masuole chu Rom kin hong zoi. ");
INSERT INTO sch_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Rom taka iempungei han kin thurchi an rieta male alazan ten Appius khopuingeia bazar lei Tung-in Inthum ten han keini ngei leh intong rangin an honga. Paul'n a mu ngei lechu, Pathien kôm râisânchong a rîla mohôkna lientak ngei a man ani. ");
INSERT INTO sch_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Rom kin tung lechu, Paul hah a rungpu râlmi inkhat leh atheivaia om rang an phal zoia. ");
INSERT INTO sch_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Sûnthum suole chu Paul'n khotuola Juda ruoipungei hah intong rangin a koitûpa. An intûp suole, ama'n an kôm, “Ka champui Isrealngei, ei mipuingei chunga nônchu ei jât balam ei richibulngei renga ei manna chunga ite minchâina dôn khom no ronga, Jerusalema intâng ina min khuma male Rom ngei kuta mi bânga. ");
INSERT INTO sch_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Chong min rekel suole, Rom ulienngeiin mi mojôk rang an nuoma, asikchu thi rang dôra ki minchâina ite an mu loi ani. ");
INSERT INTO sch_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Aniatachu maha Judangei an makhal lechu, ki mingei lelê doi ngei rang jôt khom no ronga, Caesar kôm jêk rangin namnôl ko tho zoi ani. ");
INSERT INTO sch_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Masikin kêng nangni inmupuia nangni chongpui rangin nangni ko koi ani. Maha atatak kêng, Ma sabeina hanchu Israelngei an sabeipu han zingjirûi leh thungin ma anghin ko om ani,” a tia. ");
INSERT INTO sch_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Anni ngeiin a kôm han, “Judea renga nu chungroia lekhamuthuon khom ite man makme, ei miriem so renga juong ngei khomin no roi ngei aninônchu nu chunga asie juong ti mak ngei. ");
INSERT INTO sch_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Aniatachu nu huongvârngei hih riet rang kin nuom ani, asikchu muntina mingeiin no omna pâl hah an misîr minsiet ngâi kin riet,” an tia. ");
INSERT INTO sch_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Masikin Paul le nikhuo an khita, ma nikhuo han chu mi tamtak Paul omna han an honga. Jîng renga jânjîng ten an kôm Pathien Rêngram thurchi a misîr minthâr pe ngeia, Moses Balam le dêipungei miziekngei hah mangin Jisua thurchi min iem ngei rang a pûta. ");
INSERT INTO sch_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Senkhatngeiin chu an iema, hannirese senkhatngeiin chu iem mak ngei. ");
INSERT INTO sch_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Masikin anni le anni khom inngêi khâi mak ngeia, Paul'n hi chong inkhat hih a ti pe ngei suole: “Ratha Inthieng han dêipu Isaiah renga nin richibulngei kôma a lei misîr ha idôra adik mini. ");
INSERT INTO sch_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Ama'n a kôm ‘Sênla ma mingei kôm han va ti roh: Rangâi rangâi nin ta, aniatachu rietthei no tunui; En en nin ta, aniatachu mu no tunui, ");
INSERT INTO sch_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","asikchu ma miriemngei an mindona hih ânmôl zoi, male an kuorngei hîprap an ta an mitngei sîng an tih. Aninônchu, an mitin a mu rang, an kuorin a riet rang, an mulungbôkngei han rietthei an ta, male ko kôm hong kîr an tih, Pathien'n a ti, male keiman lei mindam ngei duoi nîng,’ ” a tia. ");
INSERT INTO sch_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Male Paul'n: “Nangnin nin riet rang chu, Pathien'n sanminringna chong hah Jentailngei kôm min pêl ani zoia. Anni ngei ke a lei rangâi rang!” tiin a khâr zoi. ");
INSERT INTO sch_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Kum nik ten chu Paul hah athena rang in man oma han a oma, male mahan ama mu nuoma ahong ngei murdi chu a lei modôm ani. ");
INSERT INTO sch_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Pathien Rêngram thurchi a misîrpe ngeia male Pumapa Jisua Khrista thurchi a rila, tutên khap mak ngeia ngamtakin a misîr tit ani.");
INSERT INTO sch_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Paul renga, Jisua Khrista tîrlâm le tîrton ranga thang, Pathien'n a Thurchi Sa ngei misîr ranga koi. ");
INSERT INTO sch_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Ma Thurchi Sa hah tien renga Pathien'n a dêipungei mangin a lei khâma, Lekhabu Inthieng taka miziekin. ");
INSERT INTO sch_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Mahi a Nâipasal, ei Pumapa Jisua Khrista roi ani: Miriem nina tieng chu David richisuonpâra inzir ania; ");
INSERT INTO sch_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ânthiengna Ratha Inthieng chu, thina renga ânthoinôkna han Pathien Nâipasal ani tie sinthotheina roiinpuitak chu a minlang ani zoi. ");
INSERT INTO sch_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Ama sika han Pathien'n tîrton ni rangin Khrista jôtna sika sintum ni pêk ani, Ramtina mingei iema le jômna tienga ruoi ngei rangin mikhâm ani. ");
INSERT INTO sch_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Rom taka om ngei khom nangni huomsa ani, Jisua Khrista ata nirangin nangni a koi ani. ");
INSERT INTO sch_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Masikin Rom taka om Pathien lungkham ngei le ama mi ni ranga a koi ngei nâm ranga ki miziek ani: Pathien ei Pa le Pumapa Jisua Khrista'n, moroina le inngêina nangni pêk rese. ");
INSERT INTO sch_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Amotontaka, rammuol pumpuia nin taksônna thurchi ânthang sikin nin rênga rangin Jisua Khrista jâra ka Pathien kôm râisânna chong ki mintung bak ani. ");
INSERT INTO sch_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Chubai ko thona ngeia nangni ki riettit ngâi ti a Nâipasal Thurchi Sa misîra ku mulung murdia sin ko tho ngâi Pathien hah ni rietpuipu ani. ");
INSERT INTO sch_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","A lungdo anînchu atûn luo nangni ko hong sir phâk theina rangin Pathien kôm ke ngên tit ngâi ani. ");
INSERT INTO sch_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Nin dik nôk uolna rangin ratha satvurna ngei nangni min chang rangin mu rang nangni ku nuom tatak ani. ");
INSERT INTO sch_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Maha keima le nangni hih nin taksôn han inmohôk inlôm ku nuom ani, ei insan inlôm theina rangin. ");
INSERT INTO sch_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Ka lâibungngei le sarnungei, nangni hongpan rang ko bôk tit ngâia, hannirese insûkloina a om kelen ngâi ti nin riet ku nuom ani, Jentail dang ngei lâia taksôn thar ka man anghan nin lâia khom man rangin ka sabei. ");
INSERT INTO sch_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Mitin chunga lâkâi ke nei, Greek mingei le mi môlma ngei mivârngei le mi inmôl ngei kôma khom. ");
INSERT INTO sch_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Ma anghan nangni Rom khopuia omngei kôma khom Thurchi Sa misîr rangin inthok chakin ko om ani. ");
INSERT INTO sch_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Thurchisa hih inzakpui mu-ung, tukhom a iem murdi sanminringna ranga Pathien sinthotheina ania, aphuta Judangei ta rangin masuole Jentailngei ta rang khomin ahongni. ");
INSERT INTO sch_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Thurchisa hin taksôn sik vaia Pathien'n mi thei a minchang lam aphut renga amongna tena a juong minlang ani, Pathien lekhabu'n, “Taksôn sika thei intumpu chu ring a tih,” tia ânziek anghan. ");
INSERT INTO sch_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Invân renga Pathien taksina hah miriemngei Pathien lunghâng tholoina sietna le dikloina murdi chunga ajuong minlang ani, an sietna sikin chongtak hah an kal tita. ");
INSERT INTO sch_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Pathien'n intakna a mintuong ngeia, asikchu thurchi rietruongei chu an kôma ânlang tita Pathien'n ama rengin a min riet zoi sikin. ");
INSERT INTO sch_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Anina mita mutheiloi a kumtuong sinthotheina le a Pathien nina hah rammuol sinphut renga a neinun sin ngeia inthârin mutheiin ânlanga. Masikin anni ngei chu jôkna rang lampui ite dôn mak ngei. ");
INSERT INTO sch_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Pathien an riet chakin Pathien angin chôiminsâng mak ngeia ama kôm râisânchong khom ril mak ngeia; sin kâmboi mang an mindona an mulungrîl sêt tak hah ahong jîng zoia. ");
INSERT INTO sch_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Avâr okin an inbea hannirese an inmôl ani. ");
INSERT INTO sch_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Thitheiloi Pathien chubaimûk nêkin a thithei miriemngei le vângei sângei le iring rimilngei pathien an min chang zoia. ");
INSERT INTO sch_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Masikin, an mulungrîl nuomlam neinun porinchengei tho rangin Pathien'n nûk a song ngeia inzakpui omtakin an om zoi ani. ");
INSERT INTO sch_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Pathien chongtak nêkin milak an thang uola, asinpu biek nêkin a sin ngei biekna sin an thope uola, Asinpu chu kumtuongin minpâkin om rese! Amen. ");
INSERT INTO sch_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Masika han kêng Pathien'n inzak taka an hur ha phalin nûk a song ngeia. An nupangngei hah khom nunchan insiengpui angtakin om loiin an oma. ");
INSERT INTO sch_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","An pasalngei khom nupang mang ngâi lam mâksanin, hurin an in en inlôma, pasal le pasal dikloi takin an lênga. An taksa ngeia an sietna man an man ani. ");
INSERT INTO sch_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Pathien rietna diktak hah an mulungrîla an nei nuom loi sikin an mindonna siet tak anga om rangin Pathien'n nûk a song ngeia, an tho loi ruo khom an tho zoia. ");
INSERT INTO sch_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Dikloina murdi'n an sipa sietnangei, insâp râtnangei, puoloina ngei, narsana ngei, inthatna ngei, insuol inkhalna ngei, inhuongna ngei le inmumâkna ngeiin an sipa, ");
INSERT INTO sch_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","an inêroa, an indema, Pathien an henga, an indoia, an inpâka, an insonga, sietna dadang athar an min suoka, an nulepangei mirit mak ngeia. ");
INSERT INTO sch_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","A sielesarietna nei mak ngeia an inkhâmna mang mak ngeia, midang lungkhamna le inriengmuna reng dôn ngâi mak ngei. ");
INSERT INTO sch_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Ma anga tho ngei chu Pathien'n a khâm anga thiruo anni ti riet chakin, anni an tho vai niloiin midang a tho ngei khom an nuompui sa ngâi. ");
INSERT INTO sch_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","O miriem, mi jêkpu tukhom ni roh inlêmna rang reng dôn riek mak che, midang ne jêkna dêna han nangma theiloi na chang kêng, nangma a jêkpu reng khomin ma anga sin hah no tho ngâi sikin. ");
INSERT INTO sch_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Ha anga tho ngâi mingei hah Pathien'n theiloi a min changin a jêk mindik thap ani ti ei riet. ");
INSERT INTO sch_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Aniatachu, O miriem ma anga sin tho ngâi ngei jêkpu, nang khomin ha anga sin hah no thôn chu roijêkna piel thei rangin nên tung mo? ");
INSERT INTO sch_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Aninônchu nang mehei rang a nuom sikin Pathien'n a moroina lien, a tuong theina le a tuongdierna hi misit mo ni ni? ");
INSERT INTO sch_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Nangma tukdullien le mulungngar sikin Pathien taksina le roijêkna diktak juong inlang rang Nia rangin nu chunga dengtheina nu bûm ani. ");
INSERT INTO sch_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Pathien'n mitin an sintho lam angtakin râisânman a pêk rang sikin. ");
INSERT INTO sch_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Tuongdiertaka sin asa thoa roiinpuina le chôiminsângna le ringna thitheiloi zong ngei kôma han kumtuong ringna pêk atih. ");
INSERT INTO sch_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Hannirese, a rang mang zonga chongdik hengpaia dikloina an jûi theina rangin, an chunga Pathien taksina le ningthikna musum atih. ");
INSERT INTO sch_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Adikloi sin ngei murdi chunga dengtheina le jâmzalna ngei om atih, Judangei chunga om bak a ta, Jentailngei chunga om nôk atih. ");
INSERT INTO sch_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Hannirese, sin asa sin ngei murdi chunga chu roiinpuina, chôiinsângna le inngêina ngei Pathien'n pêk atih, Judangei pêk bak a ta masuole Jentailngei pêk a tih. ");
INSERT INTO sch_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Pathien'n zen uol a neiloi sikin. ");
INSERT INTO sch_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Jentailngei chu Moses Balam dôn mak ngeia, Balam dôn loia nunsie ngei chu balam boia inmang rang an nia, Judangei chu Balam an dôna, Balam an dônna nunsie ngei khom Balam taka an roi jêk rang ani. ");
INSERT INTO sch_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Asikchu, Pathien makunga midika a tel chu Balam ariet ngei nimaka, ajômpu ngei kêng thei intum rang an ni. ");
INSERT INTO sch_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Jentailngei Balam dôn no khom rese ngeia mulungrîla an insiengpuia balam sin ngei hah sinin, anni le anni Balam an changa. ");
INSERT INTO sch_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","An mulungrîla balam chongpêk inziek ani ti an nunchana an minlanga, an sielesarietna han khom ânlanga, an mindonna ngei ânjêlna, akâra thei a mintuma, akâra chu theiloi a mintum ngâi. ");
INSERT INTO sch_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Pathien'n mi murdi mindonna inthup Jisua Khrista manga a jêk Nikhuo tika chu Thurchi Sa ki misîr angtak hin jêk a tih. ");
INSERT INTO sch_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Hannisenla nangma Juda kini ni tia, Balam han nên beia Pathien no songa, ");
INSERT INTO sch_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","a lungdo khom ni rieta, Balam ni riet sikin sielesa khom ni riet. ");
INSERT INTO sch_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Nangma ngêt hah mitcho ngei ruoipu ajînga om ngei êlpu. ");
INSERT INTO sch_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Amo ngei minvâr theipu le nâipangngei minchupu ni uol takin nên bê ngâia, rietna le chongtak murdi chu Balama aom let ni riet sikin. ");
INSERT INTO sch_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Midangngei ki minchu ngâi ni tia, ithomo nethenin nên chu loi? inru loi rangin mi ni minchu ngâia, nangma'n nên ru ngâi na? ");
INSERT INTO sch_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Inrê no roh ni tia, ania nangma nên re ngâi mini? mirmilngei mumâkpu, nangman mirmil biekna ina neinunngei hah nu muruk ngâi mini? ");
INSERT INTO sch_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Pathien Balam hah insong puiin balam minchâiin Pathien thang ni minsiet ngâina? ");
INSERT INTO sch_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Pathien lekhabu'n, “Nangni sikin Pathien riming chu Jentailngei lâia rilminsiet ani,” ti ânziek anghan. ");
INSERT INTO sch_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Balam hih jômin la chu ne sertana khom asêna om ok atih, Balam no jôm nônchu sertanloi angtakin ni ni rang. ");
INSERT INTO sch_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Jentail mi hah sertanloi ania, Sertan loiin Balam chu a jôma, Pathien'n maha sertan anga a bê loi rang mini? ");
INSERT INTO sch_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Nangni'n sertana, Balam inziek nin neia, hannirese Balam chu nin minchâi nôka, Jentail taksa sertanloi ngeiin chu Balam chong chu an jôm ngit nôka, theiloi nangni an minchang rang ani. ");
INSERT INTO sch_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Apêntieng vaia Juda mi ki ni ti chu Juda mi taktak ni mak, taksa vaia sertan chu sertan taktak ni nôk sa mak. ");
INSERT INTO sch_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Manêkin, mulungrîla Juda mi ni chu Juda taktak chu ania, sertan taktak khom hah mulung tienga ania balam inziek vaia niloiin Ratha tieng ani uol. Ma anga mi ha chu miriemin minpâk no khomrese Pathien'n chu minpâk atih. ");
INSERT INTO sch_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Hanchu, Juda mi ni hah Jentail mingei nêkin imo chungtuorna aom uola? sertan khom imo asena aom? ");
INSERT INTO sch_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Lamtina asena aom ok! Amotontaka chu Pathien chongngei hi Judangei chunga juong mintung ani. ");
INSERT INTO sch_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","mi senkhatin taksônna dônloi ngei ha inmo an ni rang? an taksôn loina han Pathien taksôn omna hah an minboi thei rang mini? ");
INSERT INTO sch_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Nitet mak! mi murdi milak ni riei khomrese ngeia Pathien chu dik tit atih, Pathien lekhabu'n, “Nangma no chong zorân chu thei na chang ngêt rang anâng, roijêkpea no om tika no motor theina rangin,” tia ânziek anghan. ");
INSERT INTO sch_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Ei dikloina ngei hin Pathien dikna a min lang thei aninte i angin mo ei mindon? Pathien'n mi sepna a pêk inte a minchâi ei ti thei rang mini? (Miriem balama ki ril ani). ");
INSERT INTO sch_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Nitet mak! ha anghan nirese, Pathien'n i angin mo rammuol roi a jêk thei ranga? ");
INSERT INTO sch_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Aniatachu, adikloi ki nina hin a roiinpuina rang Pathien dik tie ânlang thei uolin te i rangin mo kei khom dikloia bên ka la om ranga? ");
INSERT INTO sch_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Mi senkhatin, “Asa ahong suok theina rangin asie lei tho rei u,” a ti, tia min rilsiet anga han ei tho rang mini? ha mingei ha chu theiloi intum ruopiel an ni. ");
INSERT INTO sch_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Hanchu, eini Judangei hih Jentailngei nêkin ei sa uol bak mini? nitet mak! Judangei le Jentialngei nunsie suoka om zit ei ni ti ki ril suozoi. ");
INSERT INTO sch_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Pathien lekhabu'n, “Tute midik reng ommak ngei, inkhat luo ommak ngei, ");
INSERT INTO sch_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Tute mivâr reng ommak ngei, tute Pathien a rok reng ommak ngei, ");
INSERT INTO sch_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Pathien renga an pêt suo zoia, dikloina tieng an se suozoi, inkhat luo asa sin reng om khâi mak ngei. ");
INSERT INTO sch_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","An rôl chu thân in-ong ania, an meleiin milak an rila, an bâi sûng renga murûl tûr asuoka, ");
INSERT INTO sch_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","an bâi hah khomâksâmna le chongkhân asipa, ");
INSERT INTO sch_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","an ke hah thisen min suok rangin kal achôi ânranga; ");
INSERT INTO sch_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","an lampui chu inmangna le jâmzalna asipa. ");
INSERT INTO sch_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Inngêina lampui reng riet mak ngei, ");
INSERT INTO sch_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","an mitmua Pathien china reng om riek mak,” tia inziek anghan. ");
INSERT INTO sch_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Balam chongngei chu Balam nuoia omngei chunga mang rang ani ti ei riet, tutên ite an ti theiloina rangin le rammuol pumpui hi Pathien roijêkna nuoia aom theina rangin. ");
INSERT INTO sch_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Masikin Balam jôm mindik sikin tute Pathien makunga dik intum theiruo nimak Balam chu miriem sietna inrietna mang kêng ani. ");
INSERT INTO sch_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Atûn chu Pathien'n miriemngei dik a mintum lam a juong minlang zoi. Balamin ite atho rang ommak, Moses Balam le Dêipungeiin rietpuipu lei ni senla ngei khoma. ");
INSERT INTO sch_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Jisua Khrista an taksônna sikin Pathien'n mi thei a min chang ani, tukhom a iem murdi chu inteina reng ommak. ");
INSERT INTO sch_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Mi murdi'n nunsie an tho zita, Pathien sanminjôkna hah an chang thei khâiloi ani. ");
INSERT INTO sch_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Nikhomsenla, Khrista Jisua râtanna jârin Pathien'n a moroina sik vaiin ke mi a manboiin thei a min chang zoi. ");
INSERT INTO sch_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","26","Pathien'n ama hah ngâihoiin a pêka, ma anghan a thisena ama an taksônna sika mi murdi nunsie ngâidam anni narangin, mîn dik an chang theina rangin Pathien'n a tho ani. Zora lei vunsai han chu tuongdierin miriemngei nunsienangei chu riet khâiloiin a min vun ani. Pathien'n ama lelê midik ani tie le Jisua iem ngei murdi dik an chang ti minthârna rangin atûn lâihin mi dik a minchang lam hah a juong minlang ani hi. ");
INSERT INTO sch_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Hanchu song rang mo ei dôn? dôn makme, itho sikin mo? balam jôm sika mini? nimak, iemna sika kêng ani. ");
INSERT INTO sch_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Masika han miriem hi Balam jôm sika Pathien kôm adik a chang niloiin, taksônna sikin kêng mîn dik an chang tiin kin min mong ani. ");
INSERT INTO sch_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Pathien chu Judangei ta rang uol mini? Jentailngei ta khom ani loi mini? O, ani sa. ");
INSERT INTO sch_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Pathien chu inkhat ania, Juda sertanngei chu an taksônna sikin thei min chang ngei a ta, sertanloi Jentailngei khom an taksônna sik nanâk han thei min chang ngei atih. ");
INSERT INTO sch_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Hanchu taksônna ei misîr uol sikin Balam hah mangmunboia ei dar rak rang tina mini? Ni uol mak, Balam hah ei mindet ani. ");
INSERT INTO sch_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Hanchu, taksa tieng ei richibul Abraham hah i angin mo ei misîr rang ani zoi? Inmo a sinthona a lei intem? ");
INSERT INTO sch_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Sintho sika thei intum nirese chu, Abraham'n song rang imini chu a dôn rang kêng, hannirese Pathien mitmua chu ni mak. ");
INSERT INTO sch_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Pathien lekhabu'n imo ati? “Abraham'n Pathien a iema, a taksônna sika han Pathien'n midikin a pom ani,” ati. ");
INSERT INTO sch_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Sinthopu rathaman chu lungkham pêk niloiin lâkâi anga be ani uol, an sinthona an man kêng ani. ");
INSERT INTO sch_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Aniatachu mingei hah an sintho han midika tel nimak ngeia nunsiengei ngâidampu Pathien taksônna sikin kêng ani. ");
INSERT INTO sch_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Mi Sintho sika niloia Pathien'n dikna a minchang ngei satvur anni tie, David khom hi anghin a ril: ");
INSERT INTO sch_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“An tho minchâinangei ngâidamin a oma, an sietnangei mukhua aom ngei chu, satvur an ni! ");
INSERT INTO sch_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Pumapa'n sietna dôn a be loi ngei chu satvur an ni!” ");
INSERT INTO sch_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Ha satvurna hah sertan ngei rang vai mo? Sertanloi ngei rang khom mo? Abraham'n taksônna sikin dikna achang ei tia. ");
INSERT INTO sch_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","A sertan mâna chong mo, a tan suole mo? nimak, sertan suole nimaka, sertan mân ani. ");
INSERT INTO sch_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","A sertan mâna a taksônna sika, Pathien'n thei a minchang minenna ranga sertan kêng ani. Hanchu sertan khom no rese iemna sika Pathien'n thei a minchang ngei ta rangin chu Abraham chu an rathatienga pa ani. ");
INSERT INTO sch_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Sertan ngei pa khom ani, sertan anni vai sika niloiin ei pa Abraham'n a sertan mâna an taksôn angdêna iemna an nei sika ani. ");
INSERT INTO sch_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Balam jôm sik niloiin, iemna sika thei minchang a lei ni, Pathien'n Abraham kôm, ama le a jâisuon ngeiin rammuol hih la luo an tih, ti a khâm ani. ");
INSERT INTO sch_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Balam jôm hih rochon luona anînchu, taksônna hih akorong nîng ata, chongkhâm khom hah kâmomloi ani, tina nîng a tih. ");
INSERT INTO sch_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Balam han Pathien taksina a minsuok ngâi balam boina hanchu minchâina khom om ngâi mak. ");
INSERT INTO sch_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Masikin, chongkhâm hah Abraham jâisuonngei murdi rangin balam a jôm ngei mang niloiin ama taksôn anga iempungei rang khomin Pathien manboipêk a nitie min langna rangin iemna sikin ani Abraham kôma chong a lei khâm hah, ama hah ratha tienga ei rênga ei pa ani. ");
INSERT INTO sch_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Pathien lekhabu'n, “Nam tamtak pa'n nang ki minchang zoi” a tia, inkhâmna hah Pathien tieng chu asa ani. Hi chongkhâm hih Abraham'n ai iem Pathien mithi ngei minringnôkpu le neinun a omloi ngei min ompu kôm renga ai mu ani. ");
INSERT INTO sch_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Abraham han sabei rang aboi tet nûk khomin ala sabei ngit sikin, “Nam tamtak ngei pa,” a hongchang zoi ani. Pathien chongin, “Na jâisuonngei ârsi dôr la nîng an tih,” ati anghan. ");
INSERT INTO sch_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Kum raza mi ani zoia a taksa mindon nân chu mithi angdôr ani zoia, Sarah khom aching ani ti a riet chien pum khomin a taksônna chu duoi uol mak. ");
INSERT INTO sch_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Taksônna insamin Pathien chongkhâm hah mindon kârminlak maka, a taksônna a rât uol uola Pathien a chôiminsânga. ");
INSERT INTO sch_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Pathien'n a chongkhâm tuonmintung thei ngêt a tih, ti a riet minthâr sikin. ");
INSERT INTO sch_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Masika han kêng, “A taksônna sika thei minchang ani,” ti ani. ");
INSERT INTO sch_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Hi chong, “midika pom ani,” ti hih ama chungroi misîrna rang manga miziek ni maka. ");
INSERT INTO sch_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Eini, ei Pumapa Jisua thina renga kaithoipu iemngei sika dikna intum sai ngei rang khomin miziek ani. ");
INSERT INTO sch_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Jisua hah ei sietnangei sikin thatin a oma Pathien makunga dikna intum theina rangin kaithoiin a om nôk ani. ");
INSERT INTO sch_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Hanchu taksônna sika dik intuma omin, ei Pumapa Jisua Khrista jârin Pathien leh inngêiin ei om zoi. ");
INSERT INTO sch_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Ama jârin hi ei omna moroina nuoia hin taksônna ei lut zoi Pathien inlalna sabeina sikin insongin, râisânin ei om ani. ");
INSERT INTO sch_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Mapêna ei intakna khom ei insong ani, intaknân tuongdierna asuoka, ");
INSERT INTO sch_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Tuongdierna'n Pathien pomna amusuoka, detna han sabeina asuok ti ei riet ani. ");
INSERT INTO sch_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Ha sabeina han ei bei mindong maka, asikchu Pathien'n Ratha Inthieng renga a lungkhamna hah ei mulung sûnga a juong vura, maha eini ranga Pathien manboipêk ani. ");
INSERT INTO sch_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Asan rang boi ei ni lâitak han, azora taka Khrista chu mi nunsie ngei rangin a juong thi zoia. ");
INSERT INTO sch_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","midik ranga thi chu a nuom om khet noni ngei, misa ta rangin chu tumakhat athi ngam khom an om duoi thei. ");
INSERT INTO sch_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Nikhomrese, Pathien'n mi lungkham tatak ti a minlang zoi, mi nunsie ei la ni lâitakin Khrista hah ei ta rangin a juong thi zoi. ");
INSERT INTO sch_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","A thisen sika han Pathien'n dik mi juong mintum zoia, a taksina renga khom ama jârin mi sanminjôk ngêt atih. ");
INSERT INTO sch_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Pathien leh râl ei lei nia, aniatachu a nâipasal thina sikin a malngeiin mi sin zoi. Atûn chu Pathien malngei ei ni zoia, Khrista ringna sikin vângchu idôra sanminring mo ei ni rang na! ");
INSERT INTO sch_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Ma mang hah nimaka, atûna inngêina mi pêkpu ei Pumapa Jisua Khrista jâra han Pathiena ei râiasân ani. ");
INSERT INTO sch_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Rammuola hin mi inkhat sikin nunsie ahong lûta, nunsie sika han thina ahong om zoia hanchu rammuola mi murdi'n nunsie an sin zoi sikin, thina han mi murdi ahuom zoi. ");
INSERT INTO sch_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Balam aom mân khomin rammuola nunsie aom zoia, hannirese balam aom loi sikin nunsie hah nunsiea be nimak. ");
INSERT INTO sch_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Hannirese, Adam zora renga Moses zora dênin mi murdi chunga Adamin Pathien chongpêk jômloia nunsie a tho sikin nunsie tho loi ngei chunga khom thina han racham aneia. Adam hah a la juong rangpu le mintêk ani. ");
INSERT INTO sch_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Hannirese, Pathien manboipêk hah chu Adam nunsie leh han in-ang tet mah, ha mi inkhat nunsie sika han mi tamtak an thia. Aniatachu, Pathien moroina chu alien oka male mi inkhat Jisua Khrista sika a manboipêk chu mi tamtakin an chang ani. ");
INSERT INTO sch_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Pathien manboipêk leh mi inkhat nunsie hah in-ang riek mak, mi inkhat nunsie sikin theiloi changna ahong oma, nikhomrese, mi tamtak nunsie sikin moroinân thei inchangna ahong om nôk zoi. ");
INSERT INTO sch_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Mi inkhat nunsiena sikin rammuola hin thina'n roi a jêka, hanchu, mi inkhat nanâk, Jisua Khrista sikin Pathien moroina lientak leh a manboipêka thei inchanga omngei han ringna changin inlaltakin roi la jêk ngêt an tih. ");
INSERT INTO sch_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Ma anghan, mi inkhat nunsie sikin mi murdi theiloi intum an nia, ma angdênin mi inkhat dikna sikin mi murdi dik intumin an ring thei zoi ani. ");
INSERT INTO sch_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Mi inkhat chong jômloina sikin mi tamtak nunsie an ni zoia, ha angdênin mi inkhat chong jôm sikin mi tamtak dik intum an tih. ");
INSERT INTO sch_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Hanchu, nunsie apung nôk uol theina rangin balam ajuong oma, hannirese, nunsie apung nôk uolin Pathien moroina apung nôk uol ani. ");
INSERT INTO sch_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Hanchu nunsie chu thina'n roi a jêka ei Pumapa Jisua Khrista jâra kumtuong ringna ei man theina rangin Pathien moroina han thei intumnân roi a jêk ani. ");
INSERT INTO sch_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Imo ei ti rang ani zoi? Pathien moroina apung uol theina rangin nunsie ei la tho tit rang mini? ");
INSERT INTO sch_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Nitet mak! Ei ni nunsiea thisai ngei hin i-angin mo nunsiea ei la om tit thei ranga? ");
INSERT INTO sch_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Khrista Jisua han baptis chang murdi ngei chu a thina han baptis in ei omsa ti nin riet loi mini? ");
INSERT INTO sch_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","A thina han baptis changin, ama leh phûmin ei omsa zoi, Pa'n roiinpuitakin thina renga Khrista a kaithoi anghan ei ni khom ringna thara ei lêng theina rangin. ");
INSERT INTO sch_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","A thi anghan ei ni khom ama leh inzomin ei thia ma anghan ama leh inzomin kaithoiin om sâng ei tih. ");
INSERT INTO sch_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Nunsie suoka ei om khâi loina rangin nunsie pêl taksa hih that rangin ei miriem muruo hah Khrista leh khros chunga jêmdelin aom zoi ti ei riet. ");
INSERT INTO sch_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Tukhom a thiin chu nunsie sinthotheina renga a jôk ani. ");
INSERT INTO sch_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Hanchu, Khrista kôma ei thisân chu a kôma ringsa nôk ei tih, ti ei iem ani. ");
INSERT INTO sch_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Khrista hah thina renga kaithoiin a oma, thi nôk tet khâi no nih ti ei riet, thina han a chunga racham nei khâi mak. ");
INSERT INTO sch_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Hanchu a thi sikin nunsie han a chunga racham nei khâi maka, male atûn chu a ringna ha Pathien leh inzomin aom zoi. ");
INSERT INTO sch_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Ha anghan, nangni khom nunsie tieng athi saiin inbe ungla, Khrista Jisua han Pathien tieng a ringin inbe roi. ");
INSERT INTO sch_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Masika han, nin taksa mulungbôk jôm rangin nin takpum athithei han nunsie hah minlal khâi no rese. ");
INSERT INTO sch_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Nin takpum abâkngei khom dikloina mangruo rangin nunsie thona rangin phal no roi. Manêkin thina renga a ring nôk anghan Pathien kôm inpêk ungla, nin takpum abâkngei hah dikna mangruo rangin Pathien kôm pêk rangin phal let roi. ");
INSERT INTO sch_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Nunsie han nin chunga racham nei khâi no nih, balam nuoia om loiin Pathien moroina nuoia nin om zoi sikin. ");
INSERT INTO sch_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Inmo a ni rang ani zoi? balam nuoia om loiin Pathien moroina nuoia ei om zoi sikin nunsie ei la tho tit rang mini? Nitet mak. ");
INSERT INTO sch_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Tu kôma khom nirese an chong jôm ranga an suoka nin inpêklûta thina rang raka nunsie suok mini, dikna ranga chong jômna suok mini khom nirese a chong nin jômpu suok chu nin ni ti nin riet minthâr ani, Pathien kôm dik intumna han a minlangsuok ani. ");
INSERT INTO sch_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Hannirese, Pathien chu minpâkin om rese, voikhat nunsie suok lei ni ta khom ungla, minchuna chongdik nin man, nin mulungrîl murdia nin jôm sikin. ");
INSERT INTO sch_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Hanchu, nunsie suok renga chu mojôkin nin oma, dikna suokngei nin hongni zoi. ");
INSERT INTO sch_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","(Nin riet theina rangin anîngtina chong ei mang ngâi lamin ki ril ani) nin takpum abâkngei hah inthiengloina le dikloina suoka siet rangin nin lei phal ngâi anga han, atûn chu dikna suoka inthienga ring rangin hong pêk phar roi. ");
INSERT INTO sch_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Nunsie suok nin ni lâihan chu dikna renga nin inkêm ani. ");
INSERT INTO sch_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Atûna nin inzakpui tak nin lei sin ngâi hah nin inlâp pui mo? ha ngei murdi mongna hah chu thina kêng ani. ");
INSERT INTO sch_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Atûn chu nunsie suok renga mojôka omin Pathien suokngei nin hong ni zoi. Hanchu a kôma ringna akipphar le ânthieng kumtuong ringna hah nin hong nei zoi. ");
INSERT INTO sch_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Asikchu nunsie sin mara chu thina ania, Pathien manboipêk rêk chu ei Pumapa Jisua Khrista leh inzomin kumtuonga ringna ani. ");
INSERT INTO sch_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Sûngsuokngei, balam nin riet let sikin ki misîr rang hih riet thei nin tih. Balam han mi an ringsûng kâr mang kêng an chunga roi a nei ngâi ani. ");
INSERT INTO sch_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Dôngma hah a lômpa ringsûng kâr chu a lômpa balam han a khita, hannirese a lômpa a thi inchu a lômpa renga balamin a khit hah sûtin aom ngâi. ");
INSERT INTO sch_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","A lômpa ringsûngin midang a nei inchu a inrê ania, a lômpa thi nûkin chu balamin a khit hah a jôk ania, midang nei khom senla inrê nikhâi mak. ");
INSERT INTO sch_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Ma angtak han ani, ku sûngsuokngei, Khrista takpum machangngei nin ni zoi sikin Balam tieng chu nin thi zoia, atûn chu thina renga kaithoia ompu ta nin ni zoi, Pathien chuonsina mangruo sa ei nina rangin. ");
INSERT INTO sch_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Ei miriem nina muruo nuna ei lêng lâihan chu ei ngâituina saloi Balamin ânchoka han ei takpuma sin a thoa, thina amintung ngâi. ");
INSERT INTO sch_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Atûn chu mikhit ngâipu hah ei thisan zoia, balam renga mojôkin ei om zoi, balam inziek muruo papai ang niloiin Ratha balam tharin sin ei tho ani zoi hi. ");
INSERT INTO sch_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Imo ei ti rang ni zoi, Balam ha nunsie mini? nitet mak! Aniatachu balam han mi min riet no rese chu nunsie hih riet no ning. Balam han “Mi ta ôi no roh” ti no rese chu, ôi hi ki riet loi rang ani. ");
INSERT INTO sch_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Hi chongpêk hih chuminrêna mangin sietna han ôina tamtak amin om ngâi, Balam om no rese chu nunsie hih neinun thi ani. ");
INSERT INTO sch_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Moton han chu balam boiin ke lêng ngâia, hannirese, chongpêk hah ahong oma, nunsie hah ahong hara, ");
INSERT INTO sch_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","kei chu ki thi zoia. Ringna ranga chongpêk hah kei rangin chu thina ahong ni zoi. ");
INSERT INTO sch_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Asikchu sietna han chongpêk hah chuminrêna mangin mi huonga mi that zoi ani. ");
INSERT INTO sch_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Balam chu ânthienga, chongpêk khom ânthienga, adika asa ani. ");
INSERT INTO sch_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Nônchu, neinun sa han kata rangin thina amintung mini? nitet mak! nunsie hin ani, nunsie ani ti minlangna rangin neinun sa mangin kata rangin thina amintunga, chongpêk sik han nunsie hah saloina inchung uolin aminlang ani. ");
INSERT INTO sch_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Balam chu rathatienga neinun ani ti ei riet, keima rêk chu athithei miriem papai nunsie suoka juor ki ni zoi. ");
INSERT INTO sch_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Ki sintho hi rietthei mu-ung ko jôtlam tho ngâi loia, manêkin ko jôt loilam sin ngâi ki ni. ");
INSERT INTO sch_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Ko tho nuom ngâiloi hah ko thôn chu, balam hah asa tia jôm nîng ki tih. ");
INSERT INTO sch_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Masikin, hi sinngei hih keima a thopu ni mu-unga, nunsie keima taka om han atho ngâi ani. ");
INSERT INTO sch_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Keima miriem nina hin neinun adik reng om mak ti ki riet adik tho nuomna nei ngâi khom inlang thothei ngâi mu-ung. ");
INSERT INTO sch_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Neinun asa ko tho nuom hah tho loiin, neinun saloi ko tho nuomloi hah ko tho ngâi. ");
INSERT INTO sch_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Ku nuom loi ko thôn chu a thopu hah keima ni khâi mu-unga, nunsie keima taka om han atho ngâi ani. ");
INSERT INTO sch_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Masikin, hi balam hih sin atho tit ti ki riet thei zoi, neinun asa tho ku nuom ngâi nâka, neinun saloi ko tho nôk kelen ngâi. ");
INSERT INTO sch_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Ki miriem sûngrîlin chu Pathien Balam hah a râiminsân ngâia. ");
INSERT INTO sch_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Nikhomsenla, ka takpuma hin balam dang sin atho tit aom ti ki riet, ama han ku mulung sung balam hah adoia, nunsiena balam ka takpuma sin atho tit ngâi suok mi min chang chien ngâi. ");
INSERT INTO sch_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","I anga mi Lungkham omtak mo ki nina! hi thina mi tuong rang takpum renga hih tûn mo mi sanminjôk rang ani zoi? ");
INSERT INTO sch_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Pathien vaiin kêng. Ei Pumapa Jisua Khrista jârin ei Pathien minpâkin om rese. Hanchu ku mulungrîl takin chu Pathien Balam sin ko tho ngâia, ki miriem nina rêkin chu sietna balam sin atho ngâi. ");
INSERT INTO sch_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Masika han atûn chu Khrista Jisua taka om ngei rangin chu theiloi intumna rang reng om khâi mak. ");
INSERT INTO sch_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Khrista Jisua a ringna Ratha balam han sietna le thina balam renga mi sanminjôk zoi sikin. ");
INSERT INTO sch_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Miriem nina rât loina sika balamin atho thei viet loi hah Pathien'n a juong thoa, miriem taksa nunsie nina pêlin a Nâipasal hah, nunsie inbôlnân Pathien'n a juongtîra, miriem nina nunsie aom hah theiloi a minchang zoia. ");
INSERT INTO sch_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Pathien'n mahih a tho ani, taksa balama om khâiloi Ratha Balama omsai ngei, einia hin balamin aphut hah thangsuoa aom theina rangin. ");
INSERT INTO sch_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Taksa nina balama om ngeiin chu taksa tienga neinunngei an nuoma, Ratha tienga om ngeiin chu Ratha tienga neinunngei an nuom ngâi. ");
INSERT INTO sch_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Taksa nina tienga neinun a nuom chu thina ania, Ratha tienga neinun a nuom chu ringna le inngêina ani. ");
INSERT INTO sch_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Taksa nina nuomlam han Pathien adoi ngâi, Pathien Balam ajôm loi sikin, jôm khom jôm thei ngâi mak. ");
INSERT INTO sch_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Masikin taksa nina nuomlam ajôm ngeiin chu Pathien râiminsân thei mak ngei. ");
INSERT INTO sch_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Hannirese, Pathien Ratha hah nin kôm aom tikin chu taksa nina mi nikhâi mak chôia, Ratha mi kêng nin ni zoi. Tukhom Khrista Ratha dôn loi chu ama mi nimak. ");
INSERT INTO sch_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Khrista hah nangnia aomin chu nin takpum hah nunsie sikin thi khomrese Pathien kôm dik inchang nin ni sikin nin Ratha chu a ring ani. ");
INSERT INTO sch_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Thina renga Jisua kaithoi nôkpu Ratha hah nangnia han aomin chu thina renga Khrista Jisua kaithoi nôkpu han nin takpum athi thei hah nangnia han ama Ratha omin min ring atih. ");
INSERT INTO sch_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Masikin, sûngsuokngei, lâkâi ei dôn, taksa nina balama omloi rangin, taksa tieng khom ni sa loiin. ");
INSERT INTO sch_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Taksa nina balamin nin omin chu nin thi ngêt rang ani, nikhomsenla nin taksa nunsie sintho ngei hah Ratha'n nin thatin chu ring nin ti. ");
INSERT INTO sch_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Pathien ratha iruoi ngei kaichu Pathien nâingei an ni. ");
INSERT INTO sch_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Nin Ratha chang hah ichia om nôk ranga suokngei nina Ratha nimaka, Pathien nâingei nina Ratha kêng nin chang, ha ratha sinthotheina jâra han “Abba! Pa!” tiin Pathien kôm ei koi ngâi ani. ");
INSERT INTO sch_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Ma Ratha nanâk han ei Ratha leh inzomin Pathien nâingei ei ni tiin amin rieta. ");
INSERT INTO sch_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Hanchu, a nâingei ei nînchu a rochon luopungei Pathien rochon luopu ngei Khrista luopu ngei ei ni, Khrista tuongna ei tuongpuiin chu a roiinpuina khom ei changsa ngêt rang ani. ");
INSERT INTO sch_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Atûn lâia tuongna ngei hih chunga roiinpuina inlanga la om rang lehan mintuk zatin be mu-ung. ");
INSERT INTO sch_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Neinun sin murdi ngeiin Pathien nâingei hong inlang rang zora an ngâklal tatak ani. ");
INSERT INTO sch_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Neinun sin murdi ngei hah an nuom sika niloiin Pathien nuom sikin mangmunboi ni rangin heng an ni zoi, nikhomsenla, sabei rang ala om. ");
INSERT INTO sch_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Neinun sin murdi ngei khom nikhuo khat chu sietna suok renga mojôkin la om an ta, Pathien nâingei zalenna roiinpui hah la koppui an tih, ti sabeina hah ani. ");
INSERT INTO sch_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Neinun sin murdi ngei hah atûn tena nâiha na inrûm anga inrûm ti ei riet. ");
INSERT INTO sch_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Maha vai niloiin ei ni Ratha mara chang masapu ngei khom hih a nâingei mi minchang rang zora ei takpum minjôk rang ngâklalin ei inrum ani. ");
INSERT INTO sch_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Ma sabeina han kêng min ringin ei oma, nikhomsenla, mu thei tit sabeina hih sabeina tatak nimak, ei mu thei tit hah i angin mo ei la sabei tit ranga? ");
INSERT INTO sch_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Ei muloi hah ei sabeiin chu tuongdiertakin ei ngâk zajâm ngâi ani. ");
INSERT INTO sch_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Ma angdênin, Ratha'n ei rât loina mi san ngâia, i anga chubaitho rang mo ei nâng khom riet mak meh, nikhomsenla, Ratha han inrûm misîr thei loiin chubai mi thope ngâi. ");
INSERT INTO sch_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Mi mulungrîl bôkna rietpu Pathien'n chu Ratha bôkna a rieta, asikchu Ratha'n chu Pathien a mingei ruthûlin ama nuomlam takin a ngên pe ngâi. ");
INSERT INTO sch_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Hanchu Pathien'n lungkham a mupu ngei chu, a mintuo anga a koi ngei rangin chu an satna rangin neinuntin a thope ngei ngâi ti ei riet. ");
INSERT INTO sch_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Pathien'n a lei thangsai ngei hah ama nâipasal angin om rangin a lei mintuma, masikin a nâipasal chu urêng tamtak kâra nâi lutîrtak ni theina rangin. ");
INSERT INTO sch_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Hanchu, Pathien'n a lei thangsai ngei hah a koia, a koi ngei chu dik a mintuma, dik intum ngei chu a roiinpuina a semsa ngei ngâi ani. ");
INSERT INTO sch_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Ma roia han imo ei ti rang ani zoi? Pathien eini tieng a kop inte tumo mi doi thei ranga? ");
INSERT INTO sch_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Nitet mak, Pathien'n a Nâipasal luo manar loia ei rênga ruthûla pêkpu han neinun dang murdi khom manboiin mi pêk sa noni mo? ");
INSERT INTO sch_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Pathien'n a thangsai mingei hah tûn mo a rilminsiet ngam ranga? adik mintumpu hah Pathien ani sikin. ");
INSERT INTO sch_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Tu ngânin mo theiloi a mintum ranga? a thi hah Jisua Khrista ania, a thina renga ânthoinôka Pathien changtieng omin mi chongpepu hah ama nanâk kêng ani. ");
INSERT INTO sch_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Khrista lungkhamna renga chu tûnmo mi sensâi thei ranga? Injêlna ngei mo? intakna mo, nuomlona mo, vonchâmnân mo, inriengnân mo, chi omna mo? nônchu thina'n mo, mi sensâi thei rang mini? ");
INSERT INTO sch_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Pathien lekhabu'n, “Nangma jârin zoratin thina rang chipumin kin oma, Belri that rang toto, anga bên kin om ani hih,” ati anghan. ");
INSERT INTO sch_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Nithei no nih, ha ngei murdi renga han lungkham mi mupu sikin roiinpui taka azoipu ngei ei ni. ");
INSERT INTO sch_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Thina khomin, ringna khomin, vântîrton khomin, invâna rachamneina khomin, neinun a omsai le ala hong om rang khomin, sinthotheina khomin, ");
INSERT INTO sch_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","insângna khomin inthûkna khomin, neinun sin dadang ngei khomin, ei Pumapa Khrista Jisua a om Pathien lungkhamna renga chu mi sensâi thei no nih, ti ki riet minthâr ani. ");
INSERT INTO sch_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Chong diktak ki ril ani; Khrista taka kini milak ril mu ung. Ki sielesarietna Ratha Inthieng ruoina han khom milak tho mu ung ti mi minthâr ani. ");
INSERT INTO sch_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Ku mulung dûktongna lientak le mulung nanah boi theiloi ko dôn tie ki ti zora hin, ");
INSERT INTO sch_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Ki mingei, taksa tienga ki richibulngei ruthûla hin Pathien khomâksâmin Khrista renga minsenin om inlang chu ku nuom ngâi. ");
INSERT INTO sch_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Pathien mingei an nia, aman a nâingeiin a sin ngeia, an kôm a roiinpuina ngei a minlanga; chonginkhitngei a sinpui ngeia male Balam ngei a pêk ngeia; Sava diktak an dônna; Pathien chonginkhâmngei an man ani; ");
INSERT INTO sch_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Richibulngei inthang tak Hebrew jâisuon an nia, taksa tieng roia chu Khrista reng khom hah an rûia mi ani. Jâttin chunga roijêkpu Pathien chu tuonsôtin! minpâkin om rese, Amen. ");
INSERT INTO sch_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Pathien chonginkhâm hah ite asena ommak ki tina ni riek mak. Israelngei nâm hah anrêngin Pathien mi ni zit mak ngei. ");
INSERT INTO sch_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Abraham richi murdi khom anrêngin Pathien nâingei ni let uol mak ngei, “Isaac hin nu rûi isûi nîng atih,” Pathien'n a ti pe ani. ");
INSERT INTO sch_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Ma hah taksa lama a nâingei hah Pathien nâingei nimak ngei, chonginkhâm nâingei hah kêng Abraham richi diktaka be an ni tina ani. ");
INSERT INTO sch_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Pathien chonginkhâm hah mahi ani “Azora taka juong nôk ka ta, Sarah'n nâipasal nei atih,” ti hi. ");
INSERT INTO sch_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Ma vai hah nimaka, Rebecca han ei richibul Isaac renga nâi inphîr a neia. ");
INSERT INTO sch_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","Nâite ngei an la suok mân, sielesa an tho thei mân Pathien'n a lungdo angin inkhat lam a thang ani ti ânlang. Sintho sik ni loiin a koipu lungdo sikin Rebecca kôm, “A ulienpu'n nâipangpu sin thông atih,” Pathien'n a ti hah. ");
INSERT INTO sch_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Pathien lekhabu'n, “Jacob ku lungkhama, aniatachu Esau chu ke heng,” ati anghan. ");
INSERT INTO sch_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Hanchu, imo ei ti rang ani zoi? Pathien han dik zoi loina aom mini? Nitet mak. ");
INSERT INTO sch_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Ama han Moses kôm han, “Ku nunuom moroi ka ta, ku nunuom chunga inriengmu ki tih a ti anghan.” ");
INSERT INTO sch_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Masikin, miriem nuom sika le sin tho sika niloiin Pathien inriengmuna sikin kêng ani. ");
INSERT INTO sch_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Pathien lekhabu'n Pharaoh kôm, “Ki sinthotheina ki minlang theina rang le rammuol pumpuia ki riming ânthang theina rang pielin rêngin nang ku phun ani,” a ti. ");
INSERT INTO sch_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Ma anghan Pathien'n a nuom kai inriengmuna a neia, a nuom kai a mulung a minngar ngâi ani. ");
INSERT INTO sch_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Ma anghan aninte, “Pathien'n irangin mo mi a lei dem tit rêka? A lungdo hah tumo a makhal theia?” mi nin ti thei. ");
INSERT INTO sch_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Hannirese, O miriem, Pathien makhalpu hah tumo ni ni? bêlpil han a sinpu rekel ngâi mak, “Irangin mo hi anghin mi ni sin?” ati rang mini? ");
INSERT INTO sch_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Bêlpil tangkhat renga bêl a lut uol, anem uola sin rangin bêl sinpu han bêlpil chunga racham a dôn nimak mo? ");
INSERT INTO sch_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Ma anghan Pathien'n a tho ngâi, a taksina le a sinthotheina minlang nuom khomrese, a taksina changpu bêl inmang kelen ruo ngei chu a tuong zajâma. ");
INSERT INTO sch_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Hanchu, a inriengmuna bêl a roiinpuina chang ranga a minsûk, eini ngei kôma hin a roiinpuina tamtak a juong vur ani. ");
INSERT INTO sch_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Ma anga bêlngei hah eini Judangei lâia vai niloiin Jentailngei lâi renga a koi ngei khom ei ni sa. ");
INSERT INTO sch_vpl VALUES ("RM9_25",