﻿USE sofia;
DROP TABLE IF EXISTS sofia.sce_vpl;
CREATE TABLE sce_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sce_vpl WRITE;
INSERT INTO sce_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Eneshi Ersa Mexihani xienrenlai niereni jilasan shu wo. Hheshi Iburaheimu, Dawudeni houdei wo. ");
INSERT INTO sce_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Iburaheimude Isagheini oluwo. Isagheide Yagebuni oluwo. Yagebude Yuda, gaijiulaini oluwo. ");
INSERT INTO sce_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","TamaYudade Falesi, Xiela ghualai oluwo. Faleside Xisilunni oluwo. Xisilunde Lanni oluwo. ");
INSERT INTO sce_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lande Yaminadani oluwo. Yaminadade Nashunni oluwo. Nashunde Samenni oluwo. ");
INSERT INTO sce_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","LaheSamende Boasini oluwo. LudeBoaside Ebeideni oluwo. Ebeidede Yexini oluwo. ");
INSERT INTO sce_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yexide Dawude honshanni oluwo. Uliyani bierei Dawudede Sulumaneni oluwo. ");
INSERT INTO sce_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sulumanede Loboanni oluwo. Loboande Yabiyani oluwo. Yabiyade Yasani oluwo. ");
INSERT INTO sce_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Yasade Yeshafani oluwo. Yeshafade Yelanni oluwo. Yelande Uxiyani oluwo. ");
INSERT INTO sce_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uxiyade Yetanni oluwo. Yetande Yahasini oluwo. Yahaside Xixijiani oluwo. ");
INSERT INTO sce_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Xixijiade Manaxini oluwo. Manaxide Yamenni oluwo. Yamende Yexiyani oluwo. ");
INSERT INTO sce_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Bexinlai Babilunde touzhi echikude Yexiyade Yegeniya, gaijiulani oluwo. ");
INSERT INTO sce_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Touzhi Babilunde echidene Yegeniyade Salaqieni oluwo. Salaqiede Solobaboni oluwo. ");
INSERT INTO sce_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Solobabode Yabiini oluwo. Yabiide Iliyajinni oluwo. Iliyajinde Yasoni oluwo. ");
INSERT INTO sce_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Yasode Saduni oluwo. Sadude Yajinni oluwo. Yajinde Ilini oluwo. ");
INSERT INTO sce_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ilide Iliyasani oluwo. Iliyasade Madanni oluwo. Madande Yagebuni oluwo. ");
INSERT INTO sce_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yagebude Yusufuni oluwo. Yusufushi Mereiyenni zhanguiji wo. Mereiyen Mexiha giesan Ersai oluwo. ");
INSERT INTO sce_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ingiese Iburaheimuse Dawudeshi 14 dai wo. Dawudese bexinlai touzhi Babilunde echikude 14 dai wo. Touzhi Babilunde echidene Mexihashi 14 dai wo. ");
INSERT INTO sce_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ersa Mexihai olusan shiqinshi imutui wo. Hhei anai Mereiyenni Yusufude boluzho. Dou ese agikude Mereiyen Shenlinghala kewosi laiwo. ");
INSERT INTO sce_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Hhei zhanguijini Yusufushi nie gou kun wo. Hhei minminji shizheghaku duran uwo. Qioqioji siraghane giezho. ");
INSERT INTO sce_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Hhe zhen ene shiqinni sumulakude Ezhanni qienxien zhoujindei xienjighazhi kieliewo, \"Dawudeni houdei Yusufu, chi bu ayidene Mereiyenni agizhi ire. Hhe Shenlinghala kewosi laiwo. ");
INSERT INTO sce_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Hhe nie kewon olune. Niereini Ersa giezhi ogi. Hhe bexinlane zui dundase jiuine.\" ");
INSERT INTO sce_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ene shiqinla man fashen giekushi Ezhan xienzhini tungo giezhi kieliesan kielien mutun gholughane giezho, ");
INSERT INTO sce_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","\"Nie ese dafalasan oqin kewon laizhi olune. Niereini Imaneili giene.\" Imaneilini isishi Huda matanre hhantu wo. ");
INSERT INTO sce_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yusufu xiereidene Ezhanni qienxien fenfulasan mutun biereii agizhi irewoma, ");
INSERT INTO sce_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","kewosi ese olutula ghuala hhantu ese kijiezho. Kewonni oludene hhende Ersa giezhi niere ogiwo. ");
INSERT INTO sce_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Hherode honshan danlakude Ersai Yudayani Bolihende oluwo. Dunbangiese aghelitu kunla Yelusalende ire asawo, ");
INSERT INTO sce_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","\"Olusan hhe nie Yutai kunni honshan khala wine? Bijien dunbangiese hodunyini chanladene hhei beiile irewo.\" ");
INSERT INTO sce_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Hherode honshan enei sonosudene zhughedeni nanran uwo. Nie Yelusalenni kunladeye nanran uwo. ");
INSERT INTO sce_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ingie honshan bexinlai fugie buwa, jinwun hanjialai man uruzhi hhantulagha asazho, \"Mexihani khala olune?\" ");
INSERT INTO sce_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Hhela kieliewo, \"Yudayani Bolihende olune. Xienzhini shu jiere huaizho, ");
INSERT INTO sce_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","'Yuda oronni Bolihenya, chi Yudani chenshi dundase zui gani pusho. Mii bexin Isilieyi uduruchen nie lindao chii hhense khizhene.'\" ");
INSERT INTO sce_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ingie Hherode aghelitu kunlai ghulazhi uru iredene hodun yan xienzide khizhesei xianxide asazho. ");
INSERT INTO sce_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ingiedene hhelai Bolihende peizhi echigha kieliewo, \"Ta echidene xianxide hhe kewonni daqinla. Ereizhi oludene made kieliele ire. Biye hhei beiile echine.\" ");
INSERT INTO sce_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Hhela honshanyi kielienyi chenliedene echiwo. Dunbangiese chanlasan hhe hodun hhelai melie yozho. Izhi hhe kewonyi qiorun qiende yozhi echi beiwo. ");
INSERT INTO sce_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Hhela hodunni chanladene hende bayasuzho. ");
INSERT INTO sce_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Giedoura orose kewonni, anaini Mereiyenyi chanlawo, papaladene hhe kewonni beiiwo. Boubei xiaxiane keighadene antan, xian, guizhuntu caoyeni mure ogiwo. ");
INSERT INTO sce_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Huda aghelitu kunlai zhoujinde Hherodei ochirale bu echi giezhi mejieghase psedu mose goya orondene echiwo. ");
INSERT INTO sce_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Hhela echidene Ezhanni qienxien Yusufui zhoujinde xienjizhi kieliewo, \"Chi bosizhedene kewon, anaini uduruzhi Aijide piile echi. Bi fenfulatula hhende sou. Ene kewonni Hherode ereizhi alane giezho!\" ");
INSERT INTO sce_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ingie Yusufu xienidei bosizhedene kewon, anaini uduruzhi Aijide echi ");
INSERT INTO sce_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Hherode fugutula hhende souwo. Ingiekushi Ezhan xienzhii tungo giezhi kieliesan kielien mutun gholughane giezho, \"Bi kewonne Aijise uruzhi khizhewo.\" ");
INSERT INTO sce_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Aghelitu kunla piendasei Hherode mejiedene hende hokuzho. Ingiedene aghelitu kunlase hodun kaishi giezhi khizhesan shijienni mejiedene kun peizhi Bolihen chenshi pse zhouwidedu ghuase meilani kewonlai man alawo. ");
INSERT INTO sce_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ingiese Ezhan Yelimi xienzhii tungo giezhi kieliesan kielien mutun gholuwo, ");
INSERT INTO sce_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","\"Ramade nango giezhi hende wilasan shenqini sonosuwo. Lajie kesiladene oluzhi wilazho. Kesilani man widase sidaghazhi kieliesei ese chenliewo.\" ");
INSERT INTO sce_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Hherode fugudene Ezhanyi qienxien Aijide Yusufuni zhoujinde xienjighazhi kieliewo, ");
INSERT INTO sce_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","\"Chi bosizhedene kewosi, anaini uduruzhi Isilie oronde echi. Kewonni alane giesan kunla ijin fuguwo.\" ");
INSERT INTO sce_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ingie Yusufu bosizhedene kewosi, anaini uduruzhi Isilie oronde khareizhi irewo. ");
INSERT INTO sce_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","YajilaoHherode adane oronde Yudayani honshan danlasei Yusufu sonosudene hhende echikuse ayizho. Ingie zhoujindeni Ezhan mejieghase Jialili oronde echidene ");
INSERT INTO sce_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nasale giesan chenshide souwo. Ingiekushi Ezhan xienzhilai tungo giezhi, \"Hhei Nasale kun giezhi urune.\" giezhi kieliesan kielien mutun gholughane giezho. ");
INSERT INTO sce_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Hhe xienzide xili gieghasan YaheiyaYudayani hontande khizhedene chonjizhi kieliewo, ");
INSERT INTO sce_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","\"Ta geizhen giendu, asiman gojia chadashiwo!\" ");
INSERT INTO sce_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Eneshi Isaiya xienzhi kieliesan hhe kun wo. \"Hontande nie kun waradazho. 'Ezhanni moni zhunbei gie! Hhei moni zhidagha!'\" ");
INSERT INTO sce_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yaheiya loto noghosunghala giesan jienyi musizhi arasunni pixie pixieliezho. Hhe ijiesanshi machazi, shimei wo. ");
INSERT INTO sce_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Yelusalen, Yudayani go oron, Yedanheni idou oronlade sousan kunla man Yaheiyai hhende echidene ");
INSERT INTO sce_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","zuine renjizhi Yedanhede Yaheiyase xili jienliezho. ");
INSERT INTO sce_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yaheiya olon Falisai kun, Sadugai kunla xili jienliele iresei chanladene kieliewo, \"Du mogheini zhunzhughala, kien tande jianlai ireku Hudai hokukuse anda shidane giezhi kieliewo? ");
INSERT INTO sce_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ta geizhen giesanne giekughala zhenmin gie. ");
INSERT INTO sce_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Iburaheimushi bijienyi xienren wo giezhi ta zhughedene bu sumula. Bi tande kielieye, Huda ene tashilani Iburaheimuni houdei gholugha shidane! ");
INSERT INTO sce_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ede sugiei mutun genzide teiwo. Gou alima ulie souku mutunlani man chizhidene khande teine. ");
INSERT INTO sce_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Bi tai geizhen gieghane giezhi usughala xili gieghazhoma, mase khuina iresan kun mase nenli fugie wo. Bi hhende maheini qilaseye pei dane. Hhe Shenlin, khanghala tai xili gieghane. ");
INSERT INTO sce_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Hhe khadene baqi bareizhi tughonni boudeii baqiliezhi agidene cankude zhonlone. Arasunlai ulie xinieku khande teine.\" ");
INSERT INTO sce_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Hhe shihoude ErsaJialilise Yedanhede irezhi Yaheiyase xili jienliene giezho. ");
INSERT INTO sce_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yaheiya hhei danlazhi kieliewo, \"Bi indan chase xilii jienliese oluzho. Chi matugie mase jienliele irewo?\" ");
INSERT INTO sce_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ersa kieliewo, \"Chi dain gie. Matan ingiezhi giedene gounilai man chenjighakui wo.\" Ingiese Yaheiya dain giewo. ");
INSERT INTO sce_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ersa xilii jienliedene dei ususe khizhekude asiman menzhali keizhi Hudai Ruhher ghoghochen mutun bouzhezhi goyai jiere luisei chanlawo. ");
INSERT INTO sce_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Pse asiman jierese shenqi irezhi kieliewo, \"Eneshi bi oresan kewon wo. Bi hhende xiqi wo.\" ");
INSERT INTO sce_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ingiedene Shenlin Ersai udurusenu hontande echise Ibilisi hhei shiizho. ");
INSERT INTO sce_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ersa 40 qiende xieni udu orozo bareidene oliesuzho. ");
INSERT INTO sce_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Shiichen iredene Ersade kieliewo, \"Chi Hudai kewon enbese enezighan tashii fenfulazhi ginan gholugha.\" ");
INSERT INTO sce_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ersa kieliewo, \"Jinwun jiere huaizho, 'Kun amitushi zinie ginande ulie kouine. Hudai amanse khizhesan soyuji kieliende kouine.'\" ");
INSERT INTO sce_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ingie Ibilisi Ersai uduruzhi zhiguitu chenshi Yelusalende echi mechii zui undu oronde beigha ");
INSERT INTO sce_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","kieliewo, \"Chi Hudai kewon enbese jiuli bou. Jinwun jiere, 'Hhe chade oluzhi qienxienladene fenfulazhi khaghalani chii feizhi konnichii tashi jiere ulie mughughane.' giezhi huaizho.\" ");
INSERT INTO sce_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ersa hhende kieliewo, \"'Ezhan Hudane bu shii.' giezhi jinwun jiereye huaizho.\" ");
INSERT INTO sce_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ibilisi pse hhei uduruzhi tebie undu ula jiere khireidene duyani soyuji gojia, pse gojialani henni man uzheghazhi ");
INSERT INTO sce_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","kieliewo, \"Chi papalazhi mii beiise enelai man chade ogiye.\" ");
INSERT INTO sce_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ersa hhende kieliewo, \"Ibilisi, chi yola! Jinwun jiere huaizho, 'Zinie Ezhan Hudane beiizhi hhei shunji.'\" ");
INSERT INTO sce_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ingie Ibilisi Ersase likai gie, qienxienla irezhi hhei ushilazho. ");
INSERT INTO sce_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ErsaYaheiyai barei echisei mejiedene Jialilide khareiwo. ");
INSERT INTO sce_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Khuinashi Jialilini Nasalese likai gie Jiabainunde echi souwo. Eneshi Xibulun, Nafutalidedu Jialilihaini kouisan oron wo. ");
INSERT INTO sce_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ingiekushi Ezhan Isaiya xienzhini tungo giezhi kieliesan kielien mutun gholughane giezho, ");
INSERT INTO sce_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","\"Xibulun, Nafutalidedu kunla, haibienzini mo jiere, Yedanheni hhemiende niman kunlai Jialilide sousan kunla, ");
INSERT INTO sce_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Hhe khara oronde sousan bexinla fugie gonni chanlawo. Fugusan oronde sousan kunlade gon zhouiwo.\" ");
INSERT INTO sce_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Hhe shihouse kaishi giezhi Ersa chonjizhi kieliewo, \"Ta geizhen giendu. Asiman gojia chadashiwo.\" ");
INSERT INTO sce_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ErsaJialilihai bienzide yokude Beduru giesan Ximun, jiuni Andelie ghuala haide on xiaisei chanlawo. Hhelashi zhaghasun bareisan kun wo. ");
INSERT INTO sce_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ersa hhelade kieliewo, \"Ta iredene mii dagha. Bi tai zhaghasun bareiku mutun kun bareichen gholughane.\" ");
INSERT INTO sce_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Hhela onni deigo jiedene hhei daghawo. ");
INSERT INTO sce_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ersa hhense melie yodene pse gaijiu ghualai chanlawo. Hhelashi Xibitaini kewon Yagebu, Yagebui jiuni Yaheiya wo. Hhela adarene hhantu chon jiere on huduzho. Ersa hhelai uruse ");
INSERT INTO sce_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","hhela deigo chon, adasene likai gie hhei daghawo. ");
INSERT INTO sce_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ErsaJialilini gochude man yozhi hhelai huitanlade sughazhi Hudai gojiai gouxioxini chonjizhi bexinlai yanyanji gien nouzhi giemeresanlai goudaghazho. ");
INSERT INTO sce_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ersai minshen Xiliyade man chonji kuruwo. Kunla yanyanji gientulai uduruzhi irese Ersa goudaghawo. Yanyanji giemerezhi tendun shouisan, sheitan heisan, yanjiofen nousan, tanhon giesanlai man ireghazho. ");
INSERT INTO sce_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tebieji olon kunla Jialili, Jijiapoli, Yelusalen, Yudaya, Yedanheni dunmiense hhei daghawo. ");
INSERT INTO sce_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ersa olon kunlai chujieghedene ulade khirei souwo. Tujilani melie irese ");
INSERT INTO sce_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","hhelade sughazhi kielie qiiwo. ");
INSERT INTO sce_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","\"Zhughede nanxin kunlade fuqi wine, asiman gojiashi hhelanughun wo. ");
INSERT INTO sce_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nango giechen kunlade fuqi wine, hhelai sidaghazhi kieliene. ");
INSERT INTO sce_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Goyane meilade uzhechen kunlade fuqi wine, hhela ghazhai jienliene. ");
INSERT INTO sce_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Gundanni giene giezhi oliesuzhi undasuchen kunlade fuqi wine, hhelade kurughane. ");
INSERT INTO sce_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ubali xiichen kunlade fuqi wine, hhelade ubali xiine. ");
INSERT INTO sce_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Zhughe ganjintu kunlade fuqi wine, hhela Hudai chujieghene. ");
INSERT INTO sce_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Heqishighachen kunlade fuqi wine, hhelai Hudai kewosi giezhi urune. ");
INSERT INTO sce_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Gundannide oluzhi heikui shouisan kunlade fuqi wine, asiman gojiashi hhelanughun wo.\" ");
INSERT INTO sce_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","\"Mii yenyinghala kunla tai shizheghazhi, heizhi, shiheni doghunnighala ghudan kieliezhi tai sugiese tande fuqi wine. ");
INSERT INTO sce_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ta hende bayasundu, asiman jiere tande ogiku jianli fugie wo. Tanse melieshiku xienzhilaiye ingiezhi biizhi daozho.\" ");
INSERT INTO sce_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","\"Tashi duyai dansun wo. Dansunde widao widase matugie koudaghane? Yamade inji dadene bendase kunla taine.\" ");
INSERT INTO sce_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","\"Tashi duyai gon wo. Ula jiere beighasan chenshini niuigha dane. ");
INSERT INTO sce_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kun zhulai jienjise ighaghala ulie komorone, zhula teiku teizi jiere jiene. Ingiese nie gie kunlade gieghan wo. ");
INSERT INTO sce_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ingiezhi ta gonne kunlai melie zhouidene kunla ta goude giesei chanlazhi asiman jieredu adadene kuaikui ogigha.\" ");
INSERT INTO sce_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","\"Bi irese guijin, xienzhilai shuni widaghane giekui ta bu sumula. Bi guijinni widaghale ese irezho, chengun olughale irezho. ");
INSERT INTO sce_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Bi tande shuhua kielieye, asiman zemin widatula guijin jieredu nie jienjien nie bihuada ulie widazhi man chengun olune. ");
INSERT INTO sce_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ingiese kienliuzhe enezighan minlin jieredu zui ganii ulie zunjizhi kunlade ulie zunjise olune giezhi sughase asiman gojiade zui gani giezhi urune. Kienliuzhe minlinyi zunjizhi kunlade sughase asiman gojiade fugieni giezhi urune. ");
INSERT INTO sce_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Bi tande kielieye, tai gouni jinwun hanjia, Falisai kunlase ulie daose jiedui asiman gojiade oro dane.\" ");
INSERT INTO sce_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","\"'Kun bu ala! Kun alase panjine.' giezhi eqighanku kunlade kieliesei ta chenliezhi daozhoma, ");
INSERT INTO sce_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","bi tande kielieye, gaijiudene hokuse panjine. Gaijiune, 'Guazi' giese zui fugie fayende lai echine. 'Yanhunzi' giezhi sugiese dozoheini khande orone. ");
INSERT INTO sce_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ingiese chi sidagha gieku teizi jiere mure ogikude gaijiuchii chade hokusei sumula irese ");
INSERT INTO sce_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","mureni sidagha gieku teizi konde jiesenu gaijiughalane xien goudadene mure ogile ire. ");
INSERT INTO sce_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Chi duitoughalane zhale echikude mo jiere ghujighan hheghala gouda. Pse duitou chii panjiku noyende jiuise panjiku noyen chii gunnande jiuizhi bafanzide khane. ");
INSERT INTO sce_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Bi tande shuhua kielieye, chi 1 fen baerniliuzhe honjizhi ulie qindaghase bafanzise khizhe dane.\" ");
INSERT INTO sce_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","\"'Piofen bu gie.' giesan kielienyi ta chenliezhi daozhoma, ");
INSERT INTO sce_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","bi tande kielieye, biereini uzhezhi hu sumulase ijin zhughedeni piofen giewo. ");
INSERT INTO sce_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Chii borun nudun chii zui fanjighase waidene benda. Chii beyese iyanzi widazhi beyechii man dozode orokuse gou wo! ");
INSERT INTO sce_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Chii borun kha chii zui fanjighase chizhidene benda. Chii beyese iyanzi widazhi beyechii man dozode orokuse gou wo!\" ");
INSERT INTO sce_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","\"Pse, 'Biereine ulie kerese hhende lihun qiuzi ogikuni wo.' giezhi kieliezhoma, ");
INSERT INTO sce_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","bi tande kielieye, biereini lon kijieku yenyinse chugo lihun giese biereini piofen gieghazho. Pse lihun giesan biereini agisan kunye piofen giezho.\" ");
INSERT INTO sce_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","\"Pse, 'Fayen giesanne bu fura. Ezhande fayen giesanne zunji.' giezhi eqighanku kunlade kieliesei ta chenliezhi daozhoma, ");
INSERT INTO sce_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","bi tande kielieye, yama fayen bu gie. Asimanyi zhiizhi fayen bu gie. Hheshi Hudai baozo wo. ");
INSERT INTO sce_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Zeminyi zhiizhi fayen bu gie. Hheshi Ezhan kon teiku bandou wo. Yelusalenyi zhiizhi fayen bu gie. Hheshi fugie honshanni chenshi wo. ");
INSERT INTO sce_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Qiorunne zhiizhi fayen bu gie. Chi qiorun jieredu nie ganzi usunne chighashigha dazhi kharalagha dane. ");
INSERT INTO sce_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Tai kielien enbeneshi enbene gie, pushoshi pusho gie. Enense olon kieliese Ibilisinughun wo.\" ");
INSERT INTO sce_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","\"'Nudunde nudun honji, shidunde shidun honji.' giesan kielienyi ta chenliezhi daozhoma, ");
INSERT INTO sce_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","bi tande kielieye, doghun kunlare zodui bu gie. Kunla borun khizhaichii eghise soghei khizhaneye eghigha. ");
INSERT INTO sce_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kunla chii zhazhi chii lizii jienni kerene giese mienzine jienniye ogi. ");
INSERT INTO sce_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kunla chii biizhi 1 li mo yoghase hhere hhantu 2 li mo yo. ");
INSERT INTO sce_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Chii xiahua giezhi kerese ogi. Chase dunxi ghuise uwo giezhi bu kielie.\" ");
INSERT INTO sce_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","\"'Ta giebeidene ore, duitoune henji.' giesan kielienyi chenliezhi daozhoma, ");
INSERT INTO sce_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","bi tande kielieye, duitoudene ore, tai heisanlade oluzhi onxian gie. ");
INSERT INTO sce_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ingiezhi giese ta asimanni Adadene kewosi danlane. Hhe naranne doghun kun, gou kunni jiere man zhouighazho. Ghurani gou kun, gou witu kunde man bouzheghazho. ");
INSERT INTO sce_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ta zinie tande oresan kunlade orese tande yan jianli ogine? Lien shui shanjisan kunlaye ingiezhi giene. ");
INSERT INTO sce_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ta zinie gaijiudene zhaohu daise kunlase giedun gou wo? Lien niman kunlaye ingiezhi giene. ");
INSERT INTO sce_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ingiese asiman jieredu Adatai onqien biku mutun taye onqienshi.\" ");
INSERT INTO sce_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","\"Ta gouni giekude xioxin giezhi kunlai melie uzheghane giezhi bu gie. Qingiezhi giese asiman jieredu tai Adase yama jianli jienlie dane. ");
INSERT INTO sce_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Chi nanxin kunlade ogikude jiazhon giesan kunla mutun bu gie. Hhela goyane kuaighane giezhi huitan, geidoude fugiede tunguliene. Bi tande shuhua kielieye, hhelade jianli ijin ogiwo. ");
INSERT INTO sce_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Chi nanxin kunlade ogikude borun kha giesei soghei khade bu mejiegha. ");
INSERT INTO sce_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Chi ogisanne kunlade bu mejiegha. Beichazide uzhesan Adachii tande jianli ogine.\" ");
INSERT INTO sce_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","\"Ta onxian giekude jiazhon giesan kunla mutun bu gie. Hhela kunlade uzheghane giezhi huitan, shizilukoude beidene onxian giekude xiqi wo. Bi tande shuhua kielieye, hhelade jianli ijin ogiwo. ");
INSERT INTO sce_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ta onxian giekude giedera orodene wijienyi khadene beichazide bisan Adasene onxian gie. Beichazide uzhesan Adachii jianli ogine. ");
INSERT INTO sce_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ta onxian giekude niman kunla mutun touchan erchanji yama isi witu kielienyi bu kielie. Hhela sumulase ologhan kieliese chenliemu giezho. ");
INSERT INTO sce_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ta hhela mutun bu gie. Ta xiahua gieku melie ta yan keresei Adatai mejiene.\" ");
INSERT INTO sce_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","\"Ingiese ta ingiezhi onxian gie, 'Asiman jieredu mai Ada, chi nierene zhiguishigha. ");
INSERT INTO sce_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Chii gojiai iregha. Chi isine asiman jiere mutun zemin jiere chenjigha. ");
INSERT INTO sce_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Niudunieku ijiuni enedu bijiende ogi. ");
INSERT INTO sce_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Bijiende codasan kunlai bijien rouliesan mutun bijien codasei roulie. ");
INSERT INTO sce_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Bijienyi shiikude bu echighazhi Ibilisii khase khizhegha. Gojia, qienli, famashi chanqi chinughun wo. Amine!' ");
INSERT INTO sce_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kunla codasei ta rouliese asiman jieredu Adataiye tai rouliene. ");
INSERT INTO sce_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kunla codasei ta ulie rouliese asiman jieredu Adataiye tai ulie rouliene.\" ");
INSERT INTO sce_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","\"Ta orozo bareikude jiazhon giesan kunla mutun uxinne bu bougha. Hhela orozo bareisei kunlade mejieghane giezhi guyide ghuniraku yanzi khizheghane. Bi tande shuhua kielieye, hhelade jianli ijin ogiwo. ");
INSERT INTO sce_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Chi orozo bareikude qiorunne sanlazhi nune waghadene ");
INSERT INTO sce_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","orozo bareisei kunlade bu chujiegheghazhi beichazide bisan Adadene uzhegha. Ingiese beichazide uzhesan Adachii chade jianli ogine.\" ");
INSERT INTO sce_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","\"Goyadene oluzhi boubeini zemin jiere bu sunji. Zemin jiere ghughei ghazhazhi xiuqirane. Ghughei nudurun waizhi ghulane. ");
INSERT INTO sce_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Boubeini asiman jiere sunji. Asiman jiere ghughei ghazha dane, ulie xiuqirane. Ghughei nudurun waizhi ghula dane. ");
INSERT INTO sce_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Chii boubei khalashi zhughechiiye khala wo.\" ");
INSERT INTO sce_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","\"Nudunchiishi beyeni zhula wo. Nudunchii goushi beyechii man gieghan wo. ");
INSERT INTO sce_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nudunchii gou wise beyechii man khara wo. Chii sudorodu gon kharashi hhe kharani zhengiejia fugie wo. ");
INSERT INTO sce_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Kienliuzhe ghua ezhanni shunji dane. Ene niede henjise hhe niede orene. Ene niede gundushi hhe niede gongien wo. Ta Huda baer ghualai hhantu shunji dane.\" ");
INSERT INTO sce_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","\"Ingiese bi tande kielieye, ta amindene oluzhi yan ijiene, ochine giezhi munan bu gie. Beyedene oluzhi yan musine giezhi munan bu gie. Amin ijiekuse zhunyo uwonu? Beye musikuse zhunyo uwonu? ");
INSERT INTO sce_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ta asiman jieredu bunzhulai nie sumula, hhela ulie tareine, ulie ghurane, cankude ulie sunjine, tai asiman jieredu ada hhelai qiezhene. Ta bunzhulase zhunyo uwonu? ");
INSERT INTO sce_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Tani dunda kien zhughe chilakughala aminne niecha fududagha shidane? ");
INSERT INTO sce_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Musikude yangiezhi munan giezho? Ta banche jieredu baihe chizhe matugie osisei nie sumula, hhela ulie khishilane, bosiye ulie giene. ");
INSERT INTO sce_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Bi tande kielieye, Sulumane honshan zui henni xienzide musisanla ene nie chizhede ulie kurune. ");
INSERT INTO sce_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ta goude xianxin ulie giechen kunla, banche jieredu osun enedu wine, maghashijie luzide teiliuzhe Huda dou ingiezhi dabalaghazho. Tai qingie ulie gienu? ");
INSERT INTO sce_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ingiese, 'Ta yan ijiene? Yan ochine? Yan musine?' giezhi zhughe bu chila. ");
INSERT INTO sce_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Enelashi man niman kunla xiahua giekuni wo. Asiman jieredu Adatai tande enezighan chaisanlai man mejiene. ");
INSERT INTO sce_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ta xien Hudai gojia, hhei gundanni xiahua gie, ingiese enelai man tande ogine. ");
INSERT INTO sce_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ingiese ta maghashijiekude munan bu gie. Maghashijiekude maghashijie munan giekui wine. Niuduku chijiani niudushi kuruzho.\" ");
INSERT INTO sce_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","\"Ta kunlai bu kielie, pse taiye kieliene. ");
INSERT INTO sce_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ta kunlai matui kieliese taiye qingiezhi kieliene. Ta yanghala nanjizhi ogise tandeye yanghala nanjizhi ogine. ");
INSERT INTO sce_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Chi yangiezhi gaijiune nudundedu osun zhazhai chanlane, goya nudundedu lianni chanla dane? ");
INSERT INTO sce_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Chii nudunde lian bidene matui gaijiudene, 'Bi chini nudundedu osun zhazhai agiye.' giezhi kieliene? ");
INSERT INTO sce_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Chi ene jiazhon giesan kun, xien goya nudundedu lianni agidene uzhezhi qinchu olusenu gaijiune nudundedu osun zhazhai agi.\" ");
INSERT INTO sce_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","\"Zhiguitu dunxini nogheide bu ogi. Ochira daozhese tai zhoune. Manouni khigheini melie bu tei. Khigheila manouni taine.\" ");
INSERT INTO sce_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","\"Ta xiahua gie, tande ogine. Erei, ereizhi olune. Wijienni eghi, tande niene. ");
INSERT INTO sce_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Xiahua giechen kunlade ogine. Ereichen kunla ereizhi olune. Wijienni eghichen kunlade niene. ");
INSERT INTO sce_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Tai dunda yan kunyi kewon ginan kerese tashi ogine? ");
INSERT INTO sce_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Zhaghasun kerese moghei ogine? ");
INSERT INTO sce_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ta gou wiliuzhe kesiladene gouni ogikuni mejiene, asiman jieredu Adatai xiahua giechen kunlade gou dunxini genjia ulie oginu? ");
INSERT INTO sce_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ingiese ta kunlai goyadene matugie gieghaku duranshi taye kunlade qingiezhi gie. Eneshi guijin, xienzhilai shu wo.\" ");
INSERT INTO sce_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","\"Ta witan wijiense oro. Fugughakude uduruku wijien fugie wo. Mo aghui wo. Orochen kun olon wo. ");
INSERT INTO sce_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Aminde uduruku wijien witan wo. Mo yozhi chijia wo. Ereizhi oluchen kun choghon wo.\" ");
INSERT INTO sce_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","\"Ta jia xienzhilai fangula. Hhela ghoni arasunyi zhozhi tai enende irene, sudoroni wizha zhanghei wo. ");
INSERT INTO sce_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Hhelai alimaghala hhelai tanine. Eghesun jierese putou zhei shidanu? Osun jierese uhuago zhei shidanu? ");
INSERT INTO sce_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Jien gou mutun jiere gou alima soune. Langan mutun jiere langan alima soune. ");
INSERT INTO sce_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Gou mutun jiere langan alima sou dane. Langan mutun jiere gou alima sou dane. ");
INSERT INTO sce_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Jien gou alima ulie souku mutunlai chizhidene khande teine. ");
INSERT INTO sce_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ingiese hhelai alimaghala hhelai tanine.\" ");
INSERT INTO sce_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","\"Mii, 'Ezhan, Ezhan!' giezhi waradachen kunla man asiman gojiade orokui pusho. Zinie asimandedu Adaimi kielien mutun giechen kunla orone. ");
INSERT INTO sce_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Hhe zuihouku udude olon kunla made kieliene, 'Ezhan, Ezhan, bijien chini niereghala chonjiwola? Chini niereghala sheitanlai touwola? Chini niereghala olon nenlitu shiqin giewola?' ");
INSERT INTO sce_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Hhe shihoude bi mindaminji hhelade kieliene, 'Bi tai tani dane. Ta enezighan uhun kunla, mase likai gie!'\" ");
INSERT INTO sce_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","\"Ingiese mii enezighan kielienyi chenliedene giesan kunshi jienzha kun wo. Hoxian gieni fugie tashi jiere giesanghala niekielien wo. ");
INSERT INTO sce_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ghura bou, fugie usu chunji, kei hende feiliezhi eghiliuzhe gieni ulie enbereine. Gieni jigunni fugie tashi jiere giezho. ");
INSERT INTO sce_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Mii enezighan kielienyi chenliedene ulie giesan kunshi men kun wo. Hoxian gieni shazi jiere giesanghala niekielien wo. ");
INSERT INTO sce_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ghura bou, fugie usu chunji, kei hende feiliezhi eghise gie enbereine. Da enbereisan fugie wo.\" ");
INSERT INTO sce_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ersa enezighan kielienyi jianji baraghase olon kunla hhe sughasande ghanirazho. ");
INSERT INTO sce_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ersa hhelade sughadan hhelai jinwun hanjialai buxian wo, nie qienlitu kunni xianli. ");
INSERT INTO sce_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ersa ula jierese bouzhi irese tebieji olon kunla hhei daghawo. ");
INSERT INTO sce_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ingiekude nie pifugientu Ersai melie ire papaladene kieliewo, \"Ezhan, chi duran bise mini ganjinragha shidane.\" ");
INSERT INTO sce_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ersa khane zhighazhi hhei maqizhi kieliewo, \"Bi duran wine. Chi ganjinra!\" Ingiese hhei pifugienni deigo ganjinrawo. ");
INSERT INTO sce_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ersa hhende kieliewo, \"Chi kiemade bu kieliedene echizhi beyene buwade uzhegha. Musai shu jiere fenfulasan mutun Hudade mure ogizhi kunlade ganzhen bei.\" ");
INSERT INTO sce_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ErsaJiabainunde orose nie baifuzhan melieni irezhi Ersai xiahua giezhi kieliewo, ");
INSERT INTO sce_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","\"Ezhan, hojimi tanhon giesenu giede kijiedene tendun shouizho.\" ");
INSERT INTO sce_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ersa hhende kieliewo, \"Bi hhei goudaghale yoye.\" ");
INSERT INTO sce_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Baifuzhan kieliewo, \"Ezhan, chi mii giede irese bi pei dane. Chii nie aman kielienshi hojimi goudane. ");
INSERT INTO sce_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Biye kunlai kha doura wo, buduila mii kha doura wo. Bi buduiladene, 'Echi!' giese echine, 'Ire!' giese irene, 'Enei gie!' giese hhe giene.\" ");
INSERT INTO sce_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ersa chenliedene ghanirazhi daghasan kunlade kieliewo, \"Bi tande shuhua kielieye, bi intu xianxin giekui Isiliede uzhezhi uye daozho. ");
INSERT INTO sce_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Bi tande kielieye, dunmien ximiense olon niman kunla irezhi asiman gojiade Iburaheimu, Isaghei, Yagebure hhantu xi soune. ");
INSERT INTO sce_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kharei Isilie kunlai tousenu ghadanedu kharanide echighase hhela hhende shidunne zhouzhi wilane.\" ");
INSERT INTO sce_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ingie Ersa baifuzhande kieliewo, \"Chi kharei. Chi xianxin giesan mutun gholu gie.\" Hhe shihoude hojini goudawo. ");
INSERT INTO sce_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ErsaBedurui giede echise Bedurui ghadunmekieni fashao giedene kijiesei chanlawo. ");
INSERT INTO sce_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ersa hhei khani nie maqise fashao giesan daodene hhe bosizhe Ersai ushilawo. ");
INSERT INTO sce_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Khara oluse kunla sheitan heisan olon kunlai Ersai shida uduru irewo. Ersa nie aman kielienghala sheitanlai tou khighawo. Pse gien wineku kunlai man goudaghawo. ");
INSERT INTO sce_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ingiekushi Ezhan Isaiya xienzhii tungo giezhi kieliesan kielien mutun gholughane giezho, \"Hhe matanyi bixinni deilawo. Matanyi gienlai danjiwo.\" ");
INSERT INTO sce_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ersa olon kunla hhei wiqisei chujieghedene, \"Hai duimiende daoye!\" giezhi fenfulawo. ");
INSERT INTO sce_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nie jinwun hanjia melie ire hhende kieliewo, \"Loushi, chi khala echise bi chii daghane.\" ");
INSERT INTO sce_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ersa kieliewo, \"Funieghede dun wine, asiman jieredu bunzhude ho wine, Kunnikewonde nie zhentou teiku oronda uwo.\" ");
INSERT INTO sce_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Pse nie tuji iredene Ersade kieliewo, \"Ezhan, bi xien adane bulale echiye.\" ");
INSERT INTO sce_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ersa hhende kieliewo, \"Fugusan kun fugusan kunlane bulale echi gie. Chi mii dagha.\" ");
INSERT INTO sce_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ersa chon jiere khireise tujilani hhei daghazho. ");
INSERT INTO sce_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Menzhali hai jiere fugie kei bosiwo. Lan chabudu chonni unaghane. Ersa da hhunturazho. ");
INSERT INTO sce_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tujilani echizhi Ersai uru xiereigha kieliewo, \"Ezhan, bijienyi jiui! Bijienyi amin widane giezho!\" ");
INSERT INTO sce_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ersa kieliewo, \"Ta ene Hudai gou xianxin ulie giechen kunla, yangiezhi ayizho?\" Ingie bosizhedene kei, haini nie sugiese nanranghane gholuwo. ");
INSERT INTO sce_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kunla ghaniradene kieliewo, \"Eneshi yan kun wo? Kei, haiye kielienyini chenliene.\" ");
INSERT INTO sce_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ersa hai duimiende daosenu Jiadala kunyi oronde irewo. Ghua sheitan heisan kun mezase khizhedene hhei shida texien wizhashi kiemada hhe mose yo dazho. ");
INSERT INTO sce_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Hhela deigo warada qiiwo, \"Hudai kewon, chi bijienyi jiohoro bu gie. Shihou da uye kuruzho, chi enende irezhi bijienyi zayalanu?\" ");
INSERT INTO sce_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Hhelase gouji gholode idaban khighei ijiezhi souzho. ");
INSERT INTO sce_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Sheitanla Ersai xiahua giezhi chi bijienyi tou khighane giese bijienyi khighei jiere echigha giewo. ");
INSERT INTO sce_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ingie Ersa echi giese sheitanla khizhedene khigheilai jiere khiwo. Menzhali khigheila egheide chunji bou, haide yenji alawo. ");
INSERT INTO sce_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Khighei adulasan kunla holudene chenshide echi sheitan heisan ene kunlai shiqinyi kunlade man kieliewo. ");
INSERT INTO sce_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ingiese nie chenshini kunla man Ersai ochirale khizhewo. Hhei uzhedene, \"Enense likai gie.\" giezhi xiahua giewo. ");
INSERT INTO sce_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ersa chon jiere khirei hai hhemiende daozhi goya chenshidene irewo. ");
INSERT INTO sce_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ingiekude kunla nie tanhon giesan gientui ruzide qienlie Ersai shida irewo. Ersa hhelai xianxin giekui uzhedene tanhon giesan gientude kieliewo, \"Gaijiu, zhughene tei, chii zuini mienliewo.\" ");
INSERT INTO sce_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ingiekude giedun jinwun hanjiala zhughedene kieliezho, \"Ene kun kufurei fanjizho!\" ");
INSERT INTO sce_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ersa hhela yan sumulasei mejiedene kieliewo, \"Ta zhughedene yale doghunni sumulane? ");
INSERT INTO sce_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","'Chii zuini mienliewo.' giese sunfan onu, 'Bosizhe yo.' giese sunfan wo? ");
INSERT INTO sce_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kunnikewon duyade zuini mienlieku qienli bikui tande mejieghane giezho.\" Ingiedene tanhon giesan gientude kieliewo, \"Bosidene ruzine agi, giedene echi!\" ");
INSERT INTO sce_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Hhe kun bosidene giedene echiwo. ");
INSERT INTO sce_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kunla chanladene man ayizho. Imutu fugie qienlini kunlade ogiwo giezhi Hudai kuaizho. ");
INSERT INTO sce_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ersa hhense melie yose Matai giesan nie kun shui shanjisan oronde sousei chanlawo. Hhende kieliewo, \"Chi mii dagha.\" Ingie hhe bosizhedene Ersai daghawo. ");
INSERT INTO sce_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ersa giedera ijiekude olon shui shanjisan kun, zuirenla Ersa, Ersai tujilare man hhantu soudene ijienduzho. ");
INSERT INTO sce_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Falisai kunla chanladene Ersai tujilade kieliezho, \"Tai loushi yale shui shanjisan kun, zuirenlare hhantu ijiene?\" ");
INSERT INTO sce_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ersa sonosudene kieliewo, \"Gien witu kunla deifu ulie kerene, gientula deifu kerene. ");
INSERT INTO sce_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ta echidene, 'Bi ubali xiikude xiqi wo, murede xiqi uwo.' giesan jinwun jieredu ene kielienyi isii suru. Bi gou kunlai ereile ese irezho. Zuirenlai ereile irezho.\" ");
INSERT INTO sce_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ingiekude Yaheiyani tujila Ersai ochirale ire kieliewo, \"Bijien, pse Falisai kunla chan orozo bareizho, chii tujila yale orozo ulie bareine?\" ");
INSERT INTO sce_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ersa hhelade kieliewo, \"Ghurunde iresan zhochenla shini khughon bikude matugie nango giene? Shini khughonni kunla lai echiku udu kuzhene. Hhe shihoude hhela orozo bareine. ");
INSERT INTO sce_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Shini popui khuichen jien jiere huduchen kun uwo. Qingiese hudusan oron jienni qida olughane, tanturasan pse fugiedane. ");
INSERT INTO sce_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Shini jiuni khuichen tulunde zhonlochen kun uwo. Qingie zhonlose tulun ghaluzhi jiu usuru khizhese tulunye qida olune. Shini jiuni shini tulunde zhonlose ghuala gou wo.\" ");
INSERT INTO sce_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ersa hhelade zhen ene kielienyi kieliekude nie huitan gonjisan kun ire papalazhi kieliewo, \"Mii oqin jian duya ijiewo. Chi yodene hhei jiere khane teizhi onxian giema, hhe aminne olune.\" ");
INSERT INTO sce_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ersa bosizhedene tujilarene hhantu hhei daghazhi echiwo. ");
INSERT INTO sce_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Zhen qingiekude nie chusun usuruzhi 12 nien olusan bierei Ersai khuina iredene jien ghizhaseni nie maqiwo. ");
INSERT INTO sce_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Hhe \"Ersai jienni nie maqise gienni goudane.\" giezhi zhughedene sumulazho. ");
INSERT INTO sce_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ersa ochira daozhe hhei uzhezhi kieliewo, \"Funi, zhughene tei! Chii xianxin gieku chii jiuiwo.\" Hhe shihoude bierei goudawo. ");
INSERT INTO sce_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ersa gonjisan kunni giede kuruse kunla fugusan kunde xiu feiliezhi lon chouisei chanlawo. ");
INSERT INTO sce_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ingie kieliewo, \"Daodu. Oqin ese duya ijiezho, hhunturazho.\" Ingiese hhela Ersai uzhezhi xiniezho. ");
INSERT INTO sce_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kunlai khighadene Ersa oro echi oqinni khase nie laise oqin bosizhewo. ");
INSERT INTO sce_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ene xioxi hhe oronde man chonji kuruwo. ");
INSERT INTO sce_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ersa hhense melie yose ghua sugho hhei daghadene waradazho, \"Dawudeni houdei, bijiende ubali nie xii!\" ");
INSERT INTO sce_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ersa giedera orose sughola hhei melie irewo. Ersa kieliewo, \"Bi ene shiqinyi gie shidakui ta xianxin gienu?\" Hhela kieliewo, \"Ezhan, bijien xianxin giene!\" ");
INSERT INTO sce_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ersa hhelai nudunyi moizhi kieliewo, \"Ta xianxin giesan mutun gholu gie.\" ");
INSERT INTO sce_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ingiese hhelai nudun goudawo. Ersa hhelade hende fenfulazhi, \"Ta ene shiqinyi kunlade bu mejiegha.\" giewo. ");
INSERT INTO sce_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ingieliuzhe hhela khizhi echidene Ersai xioxii hhe oronde man chonji kurughawo. ");
INSERT INTO sce_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Hhela khizhi echikude kunla nie sheitan heisan yabai Ersai shida uduru irewo. ");
INSERT INTO sce_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Sheitanni touzhi khighase yaba kielien kielie qiiwo. Kunla man ghanirazhi kieliewo, \"Isiliede intu shiqin uzhezhi ese daowo!\" ");
INSERT INTO sce_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Falisai kunla kieliezho, \"Hhe sheitanni touzii kouizhi sheitan touzho.\" ");
INSERT INTO sce_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ersa go chenshi, aghinlai yo baraghazhi hhelai huitanlade kunlade sughazhi asiman gojiani gouxioxini chonjizho. Yanyanji gien nouzhi giemeresanlai goudaghazho. ");
INSERT INTO sce_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Olon kunlai chanladene ubali xiizho. Hhela kunnan wo, banman giechen uwo. Ghonide asuchi uwokughala niekielien wo. ");
INSERT INTO sce_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ingie tujiladene kieliewo, \"Zhonjia olon wo, wiliechi choghon wo. ");
INSERT INTO sce_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ta zhonjiani ezhanyi xiahua giezhi wiliechilai peidene zhonjiane ghuragha gie.\" ");
INSERT INTO sce_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ersa 12 gie tujine uruzhi iresenu hhelade zannan ruhher touzhi yanyanji gien nouzhi giemeresanlai goudaghaku qienli ogiwo. ");
INSERT INTO sce_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","12 gie shituni tou 1 gieni niereshi, Beduru giezhi urusan Ximun, hhei jiu Andelie, Xibitaini kewon Yagebu, Yagebuni gaijiu Yaheiya, ");
INSERT INTO sce_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Feili, Badolomai, Doma, shui shanjisan Matai, Yalefeini kewon Yagebu, Datai, ");
INSERT INTO sce_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Rexinpaini Ximun, pse Ersai ghudandusan Jialie kun Yuda wo. ");
INSERT INTO sce_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ersa ene 12 gie kunni peizhi echighakude fenfulazhi kieliewo, \"Ta niman kunlai oronde bu echi. Samaliya kunlai chenshide bu oro. ");
INSERT INTO sce_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Zinie Isilie kunla dunda echi. Hhela miisan ghoni niekielien wo. ");
INSERT INTO sce_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Xien yo xien chonjizhi kielie, 'Asiman gojia chadashiwo!' ");
INSERT INTO sce_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Giemeresan kunlai goudaghazhi fugusan kunlai aminne olugha. Pifugientulai ganjinraghazhi sheitanlani tou khigha. Ta belien jienliewoma, belien ogi. ");
INSERT INTO sce_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kakadene antan, miengu, baer bu barei. ");
INSERT INTO sce_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mo yose kuabao, ghua jien, mahei, zhugun bu barei. Wilie giechen kunla ijiuni indan jienliekuni wo. ");
INSERT INTO sce_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ta alinie chenshi, aghinde echise gou kun khala bikui daqinladene likai gietula hhei giede sou. ");
INSERT INTO sce_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Hheni giede orokude salan gie. ");
INSERT INTO sce_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Hhe giei kunla tai pei shidase ta onxian giesan pinnan hhelai jiere wo. Pei dase ta onxian giesan pinnan yen tai jiere irene. ");
INSERT INTO sce_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kien tai ulie jienliezhi kielienyi ulie chenliese hhei gie, hhe chenshise likai giekude kon jieredu turane kui bougha. ");
INSERT INTO sce_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Bi tande shuhua kielieye, panjiku udude hhe chenshi shouiku zeinan Sodoma, Emola oronse da fugie wo!\" ");
INSERT INTO sce_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","\"Uzhe, bi tai peizhi echighase ghonilai zhanghei dunda echighasan niekielien wo. Ingiese ta moghei mutun jienzharazhi ghoghochen mutun ganjinra. ");
INSERT INTO sce_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ta kunlai xioxin gie. Kunla tai zui fugie fayende jiuine. Hhelai huitanlade mabienzighala eghine. ");
INSERT INTO sce_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mii yenyinghala tai shenzhan, honshanlai melie lai echine. Ta hhelai melie, niman kunlai melie made ganzhen beine. ");
INSERT INTO sce_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kunla tai jiuikude ta matui, yan kieliekui munan bu gie. Hhe shihoude yan kieliekui tande mejieghane. ");
INSERT INTO sce_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kieliesanshi ta pusho, Adaitai Ruhher tai sudoro kieliezho. ");
INSERT INTO sce_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Gaijiu gaijiune, ada kewosine ghudanduzhi fugughakude jiuine. Kesila ada, anane zodui giezhi fugughakude kune. ");
INSERT INTO sce_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mii yenyinghala soyuji kunla tai henjine. Ingieliuzhe rennai giezhi zuihou kusanlai jiuine. ");
INSERT INTO sce_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kunla tai ene chenshide heise da nie chenshide holu. Bi tande shuhua kielieye, Isilieni chenshilai ta yozhi baraghatula Kunnikewon irene.\" ");
INSERT INTO sce_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","\"Xieshen loushise fugie uwo, hoji ezhanse fugie uwo. ");
INSERT INTO sce_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Xieshen loushighala niekielien, hoji ezhanghala niekielien gholuse kuruwo. Kunla gieni zhanguijini, 'Sheitanni touzi.' giezhi sugiese gieni kunlai genjia ulie sugienu?\" ");
INSERT INTO sce_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","\"Ingiese ta hhelase bu ayi. Khaghasanlai ulie khizheghakui uwo. Niuighasanlai ulie mejieghakui uwo. ");
INSERT INTO sce_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Bi tande beichazide kieliesei ta mindamin kielie. Ta chighindene chenliesei gie jierese fugiede kielie. ");
INSERT INTO sce_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Beyeni alane, ruhherni ala dachen hhelase bu ayi. Zinie beye, ruhher ghualai widaghadene dozoheide echigha shidachen hhense ayi. ");
INSERT INTO sce_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ghua bunzhui 1 mao baer huinela? Ingieliuzhe asimanni adatai dain ulie giese nieda andazhi bouzhe dane. ");
INSERT INTO sce_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Tai kieliese tai qiorun jieredu usunniliuzhe toulazhi agizho. ");
INSERT INTO sce_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ingiese ta bu ayi, ta olon bunzhulase zhunyo wo.\" ");
INSERT INTO sce_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","\"Kien kunlai melie mini renjise biye asiman jieredu adane melie hhei renjine. ");
INSERT INTO sce_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kien kunlai melie mini ulie renjise biye asiman jieredu adane melie hhei ulie renjine.\" ");
INSERT INTO sce_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","\"Bi irekushi zemin jiere pinnan deilazhi iresei ta bu sumula. Bi irekushi pinnan deilazhi ese iredene khudogho deilazhi irezho. ");
INSERT INTO sce_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Bi irekushi, 'Kun adarene, oqin anarene, konbierei ghadunmekierene zodui gieghale irezho. ");
INSERT INTO sce_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Kunni duitoushi gieni kun wo.' ");
INSERT INTO sce_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ada anadene mase olon orese mii pei dane. Kesiladene mase olon orese mii pei dane. ");
INSERT INTO sce_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kien shizijiane beiliezhi mii ulie daghase mii pei dane. ");
INSERT INTO sce_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Aminne ulie widaghane giese aminne widaghane. Made oluzhi aminne widaghase aminne ulie widaghane.\" ");
INSERT INTO sce_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","\"Kun tai jienliese mii jienliezho. Mii jienliese mii peizhi ireghasan hhei jienliezho. ");
INSERT INTO sce_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kien xienzhini xienzhi danlaghazhi jienliese xienzhini jianlini linlane. Kien gou kunni gou kun danlaghazhi jienliese gou kunni jianlini linlane. ");
INSERT INTO sce_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Bi tande shuhua kielieye, kien mii tujila dundadu zui ganide mii tuji danlaghazhi nie beizi usu ogiliuzhe hhende jianli kenjin ogine.\" ");
INSERT INTO sce_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ersa 12 gie tujidene fenfulazhi baludene hhense likai gie hhelai go chenshilade echizhi kunlade sughazhi chonjizho. ");
INSERT INTO sce_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yaheiya bafanzise Mexiha giesan shiqinyi sonosudene tujilane peizhi echighawo. ");
INSERT INTO sce_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Hhela Ersade asawo, \"Hhe irene giesanshi chi onu, bijien pse niei saghei?\" ");
INSERT INTO sce_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ersa kieliewo, \"Ta echidene sonosusanyi, chanlasanyi Yaheiyade kielie. ");
INSERT INTO sce_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Sugho chanlasanyi, dogholon yosanyi, pifugientui goudaghasanyi, dulei sonosusanyi, fugusan kun aminne olusanyi, pse nanxin kunlade gouxioxi chonjikui kielie. ");
INSERT INTO sce_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mii inxin ulie giechen kunde fuqi wine.\" ");
INSERT INTO sce_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yaheiyai tujila yoladene Ersa kunlade Yaheiyai kieliezho, \"Ta hontande yan kunyi uzhele echiwo? Kei feiliezhi gojiolusan ghulusun mutun zholien kunyi uzhele echiwu? Pusho! ");
INSERT INTO sce_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ta yan kunyi uzhele echiwo? Seighan jien musisan kunyi uzhele echiwu? Seighan jien musisan kunla hongunde wo! ");
INSERT INTO sce_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ta jiujin yan kunyi uzhele echiwo? Xienzhii uzhele echiwu? Enbene! Bi tande kielieye, hheshi xienzhise da fugieni wo. ");
INSERT INTO sce_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jinwun jiere, 'Uzhe, bi qinsi kunne chii melie peizhi chii moni zhunbei gieghane.' giezhi huaisanshi ene kun wo. ");
INSERT INTO sce_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Bi tande shuhua kielieye, biereila olusan kun dunda xili gieghasan Yaheiyase fugieni nieda uwoma, asiman gojiade zui meila kun hhense fugie wo. ");
INSERT INTO sce_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yaheiyani hhe xienzise eli kutula asiman gojiani hende eghizho, lihaitu kun hhei qianlazho. ");
INSERT INTO sce_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Soyuji xienzhishu, guijinshu jiere melie kieliesanlashi man Yaheiyase jieshu oluwo. ");
INSERT INTO sce_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kieliesanlai ta xianxin giene giese Yaheiyashi irene giesan Iliya enbene. ");
INSERT INTO sce_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Chighin bitu kunla chenliendu!\" ");
INSERT INTO sce_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","\"Bi ene idai kunlai yanghala bilane? Hoxian geidoude souzhi nadusan kesilai xianli. Hhela nieniedene waradazhi kieliene, ");
INSERT INTO sce_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","'Bijien tande bierei agiku xiu feiliese ta ulie jiuline. Kun fuguwo giezhi wilase ta ulie wilane.' ");
INSERT INTO sce_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yaheiya iredene ulie ijiezhi ulie ochise kunla hhei jiere sheitan wine giezhi kieliene. ");
INSERT INTO sce_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kunnikewon iredene ijiezhi ochise kunla ene kun jin ijiezhi ochikure wo. Shui shanjisan kun, zuirenlani zhanlien wo giezhi kieliene. Ingieliuzhe aghelishi giekughala olusan bikuni zhenmin giene.\" ");
INSERT INTO sce_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Hhe xienzide Ersa nenlitu shiqin olon giese chenshii kunla geizhen ese giese hhelade jingao giezhi kieliewo, ");
INSERT INTO sce_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","\"Gelaxin, Bosaida, tande gou widawo! Tai dunda giesan nenlitu shiqinni Tuilo, Xidunde giewoshi hhela eqighanse madei zhodene jierene funiesun teizhi geizhen giewo. ");
INSERT INTO sce_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Bi tande kielieye, panjiku udude ta shouiku zeinan Tuilo, Xidunse da fugie wo! ");
INSERT INTO sce_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Jiabainun, chii undudaghazhi asiman jiere khireighanu? Chii dozoheide anda boughane. Chii hhende giesan nenlitu shiqinni Sodomade giezhoshi hhe chenshi eli kutula wine. ");
INSERT INTO sce_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Bi tande kielieye, panjiku udude ta shouiku zeinan Sodomase da fugie wo!\" ");
INSERT INTO sce_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Hhe xienzide Ersa kieliewo, \"Asiman zeminni Ezhan, Ada, chii mafan gieghawo. Chi ene shiqinlani agheli, erlintu kunlade niuighazhi ga kewosi mutun kunlade mejieghawo. ");
INSERT INTO sce_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ada, enbene, eneshi chi duranghalane giesanwo. ");
INSERT INTO sce_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yanniliuzhe Adami made ogiwo. Adase chugo kiema kewonni mejie dane. Kewon, pse kewon yenyi mejieghasan kunse chugo kiema Adai mejie dane. ");
INSERT INTO sce_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Jien khishulazhi gunduni beiliesan kunla man mii shida ire. Bi tai hhamuraghaye. ");
INSERT INTO sce_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ta mii jiabanyi jierene zhozhi mase suru. Mii zhughede renyi, meilade uzhekui wine. Tai zhughe hhamura shidane. ");
INSERT INTO sce_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mii jiaban sunfan wo. Mii danzi gongien wo.\" ");
INSERT INTO sce_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Hhe xienzide Ersa hhamuraku udude boudei ghazhaghun yozhi daozho. Tujilani oliesuse boudei qiorunni sidazhi ijiezho. ");
INSERT INTO sce_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Falisai kunla chanladene Ersade kieliewo, \"Uzhe, chii tujila hhamuraku udude ulie giekui giezho!\" ");
INSERT INTO sce_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ersa hhelade kieliewo, \"Dawude, hhantuku kunlarene oliesukude giesan shiqinyi ta onshizhi ese daowu? ");
INSERT INTO sce_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Hhe mechide orodene Hudade ogiku ginanyi ijiewo. Ene ginanyi hhe, pse hhantuku kunlai ijiezhi ulie olune. Zinie buwa ijiese olune. ");
INSERT INTO sce_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Pse buwala hhamuraku udude mechide hhamuraku udui guijinni fanjiliuzhe zui ulie sanakui ta guijinshu jiere onshizhi ese daowu? ");
INSERT INTO sce_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Bi tande kielieye, enende nie kun mechise da fugie wo. ");
INSERT INTO sce_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","'Bi ubali xiikude xiqi wo. Murede xiqi uwo.' giesan ene kielienyi isii ta mejiese zui witude zui ulie soughane. ");
INSERT INTO sce_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kunnikewonshi hhamuraku uduni Ezhan wo.\" ");
INSERT INTO sce_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ersa hhe oronse likai gie huitande orowo. ");
INSERT INTO sce_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Hhende nie khani ghosan kun wine. Kunla Ersai zhane giezhi, \"Hhamuraku udude goudaghase olunulie?\" giezhi asawo. ");
INSERT INTO sce_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ersa kieliewo, \"Tai dunda kien hhamuraku udude ghoni nokiende anda bouse laizhi ulie khizhenu? ");
INSERT INTO sce_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Kun ghonise giedughon zhigui wo. Ingiese hhamuraku udude gouni giese oluzho.\" ");
INSERT INTO sce_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ingie, \"Hhe kunde khane khizhegha.\" giezhi kieliewo. Hhe khane khizheghase khani goudazhi da nie khaghalai niekielien gholuwo. ");
INSERT INTO sce_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Falisai kunla khizhi echidene \"Ersai matugie widaghane?\" giezhi shanlian giewo. ");
INSERT INTO sce_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ersa mejiedene hhense likai giewo. Tebieji olon kunla hhei daghazho. Hhe gientulai man goudaghadene ");
INSERT INTO sce_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","hhelade, \"Hheshi kien bikui bu kielie!\" giezhi minlin xiaiwo. ");
INSERT INTO sce_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ingiekushi Ezhan Isaiya xienzhini tungo giezhi kieliesan kielien mutun gholughane giezho, ");
INSERT INTO sce_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","\"Uzhe, eneshi bi sunghusan mii hoji wo. Bi hhende orezhi xiqi hen wo. Bi ruhherne hhende ogine. Ingiedene hhe gundanni minzulade chonjine. ");
INSERT INTO sce_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Hhe ulie zhenjindune, ulie onghonone. Geidoude hhei shenqini kiema sonosu dane. ");
INSERT INTO sce_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ghurane giesan ghulusunyi hhe ulie ghuraghane. Xiniene giesan zhulai ulie xinieghane. Izhi gundanni injitula giene. ");
INSERT INTO sce_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Minzula hhei nierei xiwon giene.\" ");
INSERT INTO sce_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ingiekude kunla nie sheitan heisan sugho, yabai Ersai shida uduru irewo. Ersa hheni goudaghase hhe kielien kieliezhi chanlawo. ");
INSERT INTO sce_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kunla man ghanirazhi kieliewo, \"Eneshi Dawudeni houdei enbeneba?\" ");
INSERT INTO sce_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Falisai kunla chenliedene kieliewo, \"Ene kun sheitanni touzi Biexibui ulie kouise sheitan tou dane.\" ");
INSERT INTO sce_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ersa hhela yan sumulasei mejiedene kieliewo, \"Alinie gojia goyalane eghinduse hontan gholune. Alinie chenshiwonu, alinie giei kunla goyalane eghinduse bei dane. ");
INSERT INTO sce_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ibilisi Ibilisine touse goyalane eghinduzho, hhei gojia matugie beine? ");
INSERT INTO sce_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Bi Biexibuni kouizhi sheitan touse tai tujila kienyi kouizhi sheitan touzho? Ingiese tai tujila zhenmin giese tanughun codazho. ");
INSERT INTO sce_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Bi Hudai Ruhherghala sheitan touse Hudai gojia tande irezho. ");
INSERT INTO sce_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Pse kun liliantu kunyi giede orozhi dunxilai qianlane giese xien liliantu kunyi ulie banlase matugie man qianla echine? ");
INSERT INTO sce_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mii miende ulie beise mii duitou wo. Mare ulie hhantulachen kunshi sandachen kun wo. ");
INSERT INTO sce_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ingiese bi tande kielieye, yanyanji zui, hu kieliesanlai man roulienema, Shenlinni hu kieliese ulie rouliene. ");
INSERT INTO sce_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kunnikewonni fandui giezhi kieliese roulienema, Shenlinni fandui giezhi kieliese duyade ulie rouliene, houshideye ulie rouliene.\" ");
INSERT INTO sce_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","\"Mutun goushi alima gou wo. Mutun bixinshi alimaye bixin wo. Alimaghala mutunni mejiene. ");
INSERT INTO sce_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ta ene du mogheini zhunzhughala, ta doghunshi matugie gou kielien kieliezhi khizheghane? Zhughede durusei amande kielie khizheghane. ");
INSERT INTO sce_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Gou kunlai zhughede gounishi yen gouni khizheghane. Doghun kunlai zhughede doghunnishi yen doghunni khizheghane. ");
INSERT INTO sce_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Bi tande kielieye, xienhua kieliechen kunlai panjiku udude nie aman nie amanji renjighane. ");
INSERT INTO sce_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tai kielienghala tai gounii sanane. Tai kielienghala tai zuini jinjine.\" ");
INSERT INTO sce_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ingiekude giedun jinwun hanjia, Falisai kun Ersade kieliewo, \"Loushi, chi gieku ghudureqini bijien uzhene giezho.\" ");
INSERT INTO sce_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ersa hhelade kieliewo, \"Ene idaini kunla doghun nefuxin giezho, ta dou ghudureqi kerezhoma, xienzhi Yunusii ghudureqise chugo uzheghaku ghudureqi uwo. ");
INSERT INTO sce_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yunusi ghurudu ghuran xii fugie zhaghasunyi kielide wo. Kunnikewonye ghurudu ghuran xii zemin jizide beine. ");
INSERT INTO sce_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Panjiku udude Niniwi kunla bosizhezhi ene idai kunlai zuini jinjine. Ingiekushi Niniwi kunla Yunusi chonjisei chenliedene geizhen giewo. Uzhe, enende Yunusise pse fugieni wine! ");
INSERT INTO sce_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Panjiku udude nanfanni bierei honshan bosizhedene ene idai kunlai zuini jinjine. Ingiekushi hhe gholose Sulumaneni aghelini chenliele irewo. Uzhe, enende Sulumanese pse fugieni wine!\" ");
INSERT INTO sce_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","\"Nie zannan ruhher kunni jierese likai giedene usu witu oronde izhigie yozhi hhamuraku oron ereizho. Ereizhi olu dadene ");
INSERT INTO sce_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","kieliewo, 'Bi yen khizhesan hhe giedene echine.' Khareizhi echi nie uzhese kunkunji shuzhi goudagha jiezho. ");
INSERT INTO sce_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ingie khizhi echi goyasene dolon doghun ruhheryi uduruzhi ire souwo. Ingiese hhe kunni qinkon melieshidakude pse ese kuruwo. Ene idaini doghun kunlaye eneghala niekielien gholune.\" ");
INSERT INTO sce_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ersa kunlade kieliekude ana, gaijiulani iredene ghadane beizhi hhere kielien kieliene giezho. ");
INSERT INTO sce_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Nie kun hhende kieliewo, \"Uzhe, anachii, gaijiulachii ghadane sagheizhi chare kielien kieliene giezho.\" ");
INSERT INTO sce_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ersa khareizhi hhe kieliesan kunde kieliewo, \"Kienshi mii ana wo? Kienshi mii gaijiula wo?\" ");
INSERT INTO sce_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ingie tujilane zhiizhi kieliewo, \"Uzhe, mii ana, mii gaijiula wo. ");
INSERT INTO sce_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Asiman jieredu adaimi isii zunjizhi giesan kunlashi mii gaijiu, eghechijiu, ana wo.\" ");
INSERT INTO sce_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yen hhe udude Ersa giederase khizhedene haibienzide souwo. ");
INSERT INTO sce_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tebieji olon kunla hhei shida irezhi hhantulase hhe chon jiere khirei souwo. Kunla man haibienzide beizho. ");
INSERT INTO sce_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ersa kunlade bilazhi olon kieliewo, \"Nie kun shizhile echiwo. ");
INSERT INTO sce_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Shizhikudeni niezhanla mo jiere luise bunzhula ire ijie agiwo. ");
INSERT INTO sce_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Niezhanla tura olon witu tashitu oronde luise tura ninkienshi niazi faizhi ghujin woma, ");
INSERT INTO sce_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","genzi uwoshi naran khizhe nie xiese ghowo. ");
INSERT INTO sce_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Pse niezhanla eghesun dunda luise eghesun khizhezhi hhei jigheidawo. ");
INSERT INTO sce_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Da niezhanla gou ghazhade luise 100 pei, 60 pei, 30 pei zhonjia souwo. ");
INSERT INTO sce_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Chighin bitu kunla chenliendu!\" ");
INSERT INTO sce_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tujilani Ersai shida ire asawo, \"Kunlade yale bilazhi kieliene?\" ");
INSERT INTO sce_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ersa hhelade kieliewo, \"Hudai gojiai mimii zinie tande mejieghawoma, hhelade ese mejieghawo. ");
INSERT INTO sce_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Bichen kunde pse olon ogizhi feilieghane. Wichen kunse bisanlainiye agi echine. ");
INSERT INTO sce_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Bi hhelade bilazhi kieliekushi hhela uzhese qinchu olu dane, chenliese sonosu dazhi minbai olu dane. ");
INSERT INTO sce_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Isaiya melie kieliesan kielien mutun hhelai jiere shuhua gholuwo, 'Ta izhi chenliezhoma, dunjire dane. Ta izhi uzhezhoma, minbai olu dane. ");
INSERT INTO sce_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ene bexinlai zhughe khiduzhezhi chighin beidazhi nudunne hameizho. Pse nudunni chanlazhi chighinni sonosuzhi zhughedeni minbai oludene kharei daorese Bi hhelai goudaghakuse ayizho.' ");
INSERT INTO sce_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ingieliuzhe tande fuqi wine. Tai nudunde chanlazhi chighinde sonosuzho. ");
INSERT INTO sce_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Bi tande shuhua kielieye, olon xienzhi, gou kunla ta uzhesei uzhene giezhoma, uzhe dazho. Ta chenliesei chenliene giezhoma, chenlie dazho.\" ");
INSERT INTO sce_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","\"Ingiese ta ene fure shizhisan kunni bilasei chenlie. ");
INSERT INTO sce_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kienliuzhe asiman gojiani kielienyi chenliedene dunjire dase Ibilisi iredene zhughedeni shizhisei agi echine. Eneshi mo jiere luisan fure wo. ");
INSERT INTO sce_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Tashitu oronde luisanshi kielienyi chenliedene bayasuzhi deigo jienliewoma, ");
INSERT INTO sce_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","zhughedeni genzi wise niechaku wo. Kielienyi yenyinghala zeinan onu heiku kuzhese deigo furawo. ");
INSERT INTO sce_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Eghesun dunda luisanshi kielienyi chenliewoma, duyai munan gieku, baer miise kielienyi jigheidazhi yama sou dawo. ");
INSERT INTO sce_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Gou ghazhade luisanshi kielienyi chenliezhi dunjiresan kun wo. 100 pei, 60 pei, 30 pei zhonjia souwo.\" ");
INSERT INTO sce_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ersa hhelade pse bilazhi kieliewo, \"Asiman gojia hoxian kun ghazhadene boudei fure shizhisei xianli. ");
INSERT INTO sce_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ashighala hhunturakude duitouni iredene yemeini boudei dundani shizhi yolawo. ");
INSERT INTO sce_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Boudei osizhi qiorun khise yemeiye khizhewo. ");
INSERT INTO sce_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Hojilani iredene ezhandene kieliewo, 'Ezhan, chi boudei fureni ghazhade ese tareiwu? Khalase iresan yemei wo?' ");
INSERT INTO sce_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ezhan hhelade kieliewo, 'Eneshi duitou giesan wo.' Hojilani kieliewo, 'Bijien echidene xi agimu?' ");
INSERT INTO sce_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ezhanni kieliewo, 'Bu echi, yemeini xise boudeiniye xi khizhene. ");
INSERT INTO sce_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ghuala hhantu osi gie. Sagheizhi xiku shihoude bi ghurachen kunlade kielieye, \"Xien yemeii xisenu chouladene khan tei. Boudeini yanchidene cankude ghura.\" giezhi.'\" ");
INSERT INTO sce_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ersa hhelade pse bilazhi kieliewo, \"Asiman gojia nie caizi furei xianli. Kun agizhi echi ghazhadene tareiwo. ");
INSERT INTO sce_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Eneshi fure dundase zui gani woma, osizhi khizhese yan caiseliuzhe fugie wo. Mutun gholudene bunzhula chala jiereni holiene.\" ");
INSERT INTO sce_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Pse hhelade bilazhi kieliewo, \"Asiman gojia hoxian kuniegheni xianli. Nie bierei agizhi echidene nie deizi ghurunde teizhi man faighawo.\" ");
INSERT INTO sce_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Enelashi man Ersa olon kunlade bilazhi kieliesan wo. Bilazhi ulie kieliese hhelade ulie kieliene. ");
INSERT INTO sce_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ingiekushi Ezhan xienzhini tungo giezhi kieliesan kielien mutun gholughane giezho, \"Bi bilazhi kielieye. Duyai zhayaghasanse niuighasan shiqinlai kieliezhi khizheghaye.\" ");
INSERT INTO sce_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ingiedene Ersa kunlase likai gie giedera orowo. Tujila shidani ire kieliewo, \"Ghazha jieredu yemeini bilasei bijiende mejiegha.\" ");
INSERT INTO sce_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Hhe kieliewo, \"Boudei furei shizhisanshi Kunnikewon wo. ");
INSERT INTO sce_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ghazhashi duya wo. Boudei fureshi asiman gojiai kunla wo. Yemeishi hhe doghunnii kunla wo. ");
INSERT INTO sce_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Yemei shizhisan duitoushi Ibilisi wo. Ghuraku shihoushi duya baraku shihou wo. Ghurachenshi qienxienla wo. ");
INSERT INTO sce_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Yemeini xi agidene khande sideraghaku mutun duya barakudeye ingiene. ");
INSERT INTO sce_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Kunnikewon qienxienlane peizhi zui fanjighasanlai, uhunni giesanlai man asiman gojiasene zhiizhi khizhedene ");
INSERT INTO sce_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","fugie khantu nokiende benda oroghase hhende shidunne zhouzhi wilane. ");
INSERT INTO sce_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ingiekude gou kunla adane gojiade naran nudun mutun gieran faine. Chighin bitu kunla chenliendu!\" ");
INSERT INTO sce_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","\"Asiman gojia hoxian ghazhade niuighasan boubeini xianli. Nie kun hhei chanladene niuighawo. Bayasuzhi echidene goyane dunxilai man huisenu ene ghazhai agiwo.\" ");
INSERT INTO sce_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","\"Pse asiman gojia hoxian nie meimei kun zhiguitu manou ereisei xianli. ");
INSERT INTO sce_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nie fugie jiagetu manoui penjise echidene goya dunxilane man huisenu ene manoui agiwo.\" ");
INSERT INTO sce_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","\"Pse asiman gojia hoxian haide xiaisan onni xianli. Yanyanji zhaghasunlai bareizhi ");
INSERT INTO sce_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","on duruse usu bienzide laizhi khizhedene sousenu gounilai sunghuzhi tunzide teine. Bixinnilai bendane. ");
INSERT INTO sce_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Duya barakudeye ingiene. Qienxienla irese doghun kunni gou kun dundase sunghu khizhedene ");
INSERT INTO sce_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","fugie khantu nokiende bendase hhende shidunne zhouzhi wilane.\" ");
INSERT INTO sce_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ersa kieliewo, \"Enezighan kielienyi ta man dunjirewoye?\" Hhela huida giewo, \"Bijien dunjirewo.\" ");
INSERT INTO sce_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ersa kieliewo, \"Jien asiman gojiade tuji danlasan jinwun hanjiala hoxian gieni zhanguijii xianli. Hhe kufansene shini, khuichen dunxilai agi khizhene.\" ");
INSERT INTO sce_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ersa enezighan bilasei kielie baraghadene hhense likai giewo. ");
INSERT INTO sce_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ingiedene hhe goya orondene irezhi hhelai huitande kunlade sughase hhela man ghanirazhi kieliewo, \"Ene kunde imutu agheli, fugie shiqin khalase irezho? ");
INSERT INTO sce_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Eneshi mujianyi kewon pushonu? Hhei ananishi Mereiyen pushonu? Gaijiulanishi Yagebu, Yusufu, Ximun, Yuda pushonu? ");
INSERT INTO sce_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Hhei oqinjiulani mai enende uwonu? Ene kunde khalase iresan benshi wo?\" ");
INSERT INTO sce_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Hhela Ersade hokuzho. Ingiese Ersa hhelade kieliewo, \"Xienzhini goyai oron, goyai giese chugo khalaliuzhe zunjine.\" ");
INSERT INTO sce_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Hhela Ersai xianxin ese giese Ersa hhende famatu shiqin olon ese giezho. ");
INSERT INTO sce_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Hhe xienzide Hherode on Ersai shiqinyi sonosudene ");
INSERT INTO sce_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","kha dourashiku kunlade kieliewo, \"Eneshi xili gieghasan Yaheiya wo. Hhe fugudene aminne oluwo. Ingiese ene nenlitu shiqinla hhei jierese khizhezho.\" ");
INSERT INTO sce_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Eneshi Hherode jiu biereine Xilojini yenyinghala Yaheiyai bareidene banlasenu bafanzide khazho. Hherodei jiushi Feili wo. ");
INSERT INTO sce_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","YaheiyaHherodede, \"Chi hhei agise ese oluzho.\" giezhi kieliezho. ");
INSERT INTO sce_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ingiese HherodeYaheiyani alane giezhoma, bexinla hhei xienzhi wo giese hhelase ayizho. ");
INSERT INTO sce_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Hherodeni olusan udu kuzhese xi beilazhi Xilojini oqin kunlai melie wu jiulizho. Hherode hende bayasuzho, ");
INSERT INTO sce_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ingiese fayen giezhi oqinde yan kerese yan ogiye giezhi dain giewo. ");
INSERT INTO sce_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Anani oqinne, \"Xili gieghasan Yaheiyani qiorunyi hhamusade teidene made iregha.\" giezhi kielieghase oqin kieliewo. ");
INSERT INTO sce_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Hherode hende munan giezho. Ingieliuzhe olon kunlai melie fayen giese fenfulazhi hhende ogine giewo. ");
INSERT INTO sce_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ingie kun peidene bafanzide Yaheiyai qiorunyi chizhighawo. ");
INSERT INTO sce_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Qiorunyini hhamusade agi ire oqinde ogiwo. Oqin pse anadene ogiwo. ");
INSERT INTO sce_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yaheiyai tujila iredene beyeini linlasenu buladene Ersade echi kieliewo. ");
INSERT INTO sce_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ersa enei mejiedene chon souzhi hhense likai gie niezheghan hontande echiwo. Olon kunla Ersa yolasei mejiedene chenshilase yozhi hhei daghazho. ");
INSERT INTO sce_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ersa chon jierese bouzhese tebieji olon kunlai chanladene ubali xiiwo. Hhelai giemeresan kunlai goudaghawo. ");
INSERT INTO sce_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Khara olukude tujilani hhei shida ire kieliewo, \"Eneshi hontan wo. Shihou eqie widawo. Kunlai sandaghazhi hhela goyalane aghinlade agizhi ijiele echigieba.\" ");
INSERT INTO sce_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ersa kieliewo, \"Hhelai echighaku biyo uwo. Ta hhelade ogizhi ijiegha.\" ");
INSERT INTO sce_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tujilani kieliewo, \"Matai enende zi tawun ginanji ghua zhaghasun wo.\" ");
INSERT INTO sce_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ersa kieliewo, \"Mii enende agizhi iregha.\" ");
INSERT INTO sce_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ingie olon kunlai fenfulazhi osuntu oronde soughawo. Pse tawun ginan, ghua zhaghasunyi barei, asimanyi uzhe Hudade mafan kieliedene ghulusenu tujilade ogise tujila kunlade ogiwo. ");
INSERT INTO sce_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Dajiala man ijiedene chuduwo. Tujila feiliesan zhazhai hhantulaghase 12 gie lanzi zhonlowo. ");
INSERT INTO sce_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ijiesan kun dunda bierei kewosilai ulie sanase chabudu 5000 ere kun wo. ");
INSERT INTO sce_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ersa deigo tujilai biizhi chon jiere khighadene xien hai duimiende daogha goyane olon kunlai sandaghawo. ");
INSERT INTO sce_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kunlai sandaghadene ulade niezheghan onxian giele echiwo. Khara oluse hhende niezheghan wo. ");
INSERT INTO sce_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Qingiekude chon haibienzise gholo wo. Kei shun wise lan chonni eghizhi yuqighazho. ");
INSERT INTO sce_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Xieni 3 jiense 6 jienni shihoude Ersa tujilai hhende echine giezhi haini usu jiere yozho. ");
INSERT INTO sce_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tujila hai jiere hhe yosei chanladene jindazhi ayidene waradawo, \"Perei wo!\" ");
INSERT INTO sce_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ersa deigo hhelade kieliewo, \"Ta zhughelane tei. Bi wo. Bu ayi!\" ");
INSERT INTO sce_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Beduru kieliewo, \"Ezhan, chi enbese minlin xiaizhi mii hai jiereghun goyane hhende yozhi echigha.\" ");
INSERT INTO sce_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ersa, \"Chi ire.\" giezhi kieliese Beduru chon jierese boudene Ersai hhende echine giezhi hai jiereghun yo qiiwo. ");
INSERT INTO sce_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kei fugiede feiliesei chanla ayidene haide anda boune giese waradazhi kieliewo, \"Ezhan, mii jiui!\" ");
INSERT INTO sce_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ersa deigo khaghalane laidene kieliezho, \"Chi ene xianxin gieku zhughe gajitu kun. Yangiezhi inxin giezho?\" ");
INSERT INTO sce_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ErsaBedurughala chon jiere khise kei beiwo. ");
INSERT INTO sce_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Chon jieredu kunla Ersai beiizhi kieliewo, \"Chishi shuhua Hudai kewon enbene!\" ");
INSERT INTO sce_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Hhela haini daodene Genisale oronde irewo. ");
INSERT INTO sce_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Hhendedu kunla Ersai tanidene hhe iresan xioxini go oronlade chonjizhi giemeresan kunlai man udurudene Ersai hhende irewo. ");
INSERT INTO sce_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Hhela Ersai xiahua giezhi jien ghizhane nie maqigha giezho. Maqisan kunla man goudawo. ");
INSERT INTO sce_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ingiekude Falisai kun, jinwun hanjiala Yelusalense Ersai hhende ire asawo, ");
INSERT INTO sce_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","\"Chii tujila yangiezhi xienrenla sughasan xigonni ulie zunjine? Hhela ijiekude khane ulie wagha ijiezho.\" ");
INSERT INTO sce_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ersa hhelade kieliewo, \"Ta yangiezhi goya xigonghalane Hudai minlinni ulie zunjine? ");
INSERT INTO sce_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Huda, 'Ada anane zunji', 'Ada anane sugiesan kunni ala.' giezhi kieliezho. ");
INSERT INTO sce_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ingieliuzhe ta kieliene, 'Kien ada anadene bi tande ogi shidakui Hudade ogiwo.' giezhi kieliese ");
INSERT INTO sce_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","hhe kun adane ulie zunjise olune giezho. Ingiezhi ta goya xigonghalane Hudai kielienyi widaghazho. ");
INSERT INTO sce_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Jiazhon giesan kunlaya, Isaiya tai zhiizhi melieshida kieliesan ese codazho. Hhe kieliezho, ");
INSERT INTO sce_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","'Ene bexinla amanghalane mii zunjine. Zhugheni mase gholo wo. ");
INSERT INTO sce_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Hhela kunni guijinyi zhenzhenji daoli mutun kunlade sughazho. Ingiese mii beiise yama oronde uwo.'\" ");
INSERT INTO sce_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ersa kunlai uruzhi ire hhelade kieliewo, \"Ta chenliezhi minbai olu, ");
INSERT INTO sce_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","amanse orosan kunyi ulie zannanshighanema, amanse khizhesan kunyi zannanshighane.\" ");
INSERT INTO sce_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ingie tujila hhei melie ire kieliewo, \"Falisai kun ene kielienyi chenliese hokusanni chi mejielie?\" ");
INSERT INTO sce_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ersa kieliewo, \"Asiman jieredu adami zeilasan pushoshi man xi khizhene. ");
INSERT INTO sce_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Hhelai bu gonji. Hhelashi sughoi uduruchen sugho wo. Sugho sughone uduruse ghuala nokiende anda boune.\" ");
INSERT INTO sce_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","BeduruErsade kieliewo, \"Ene bilazhi kieliesei bijiende kieliezhi minbai olugha.\" ");
INSERT INTO sce_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ersa kieliewo, \"Ta dou minbai olu dawu? ");
INSERT INTO sce_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Amande orosan kielighun mekiende echisei ta ulie mejienu? ");
INSERT INTO sce_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Amanse khizhesanshi zhughese khizhesanwo. Ene caigie kunni zannanshighane. ");
INSERT INTO sce_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Zhughese khizhesanshi doghunde sumulaku, alaku, piofen gieku, lon kijieku, ghulaku, jia ganzhen beiku, sugieku wo. ");
INSERT INTO sce_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Enela man kunni zannanshighane. Khane ulie wagha ijiese kunni ulie zannanshighane.\" ");
INSERT INTO sce_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ersa hhense likai giedene Tuilo, Xidunni oronde echiwo. ");
INSERT INTO sce_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nie niman kunyi bierei hhe oronse khizhedene waradazhi kieliewo, \"Ezhan, Dawudeni houdei, made ubali nie xii! Mii oqinyi sheitan heisan hen wo.\" ");
INSERT INTO sce_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ingieliuzhe Ersa yama huida ese giezho. Tujilani melie ire xiahua giezhi kieliewo, \"Hhei khareighaba. Ene bierei mai khuinase waradazho.\" ");
INSERT INTO sce_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ersa kieliewo, \"Mii peizhi zinie Isilieni kunlai dundadu miisan ghonilade oluzhi ireghazho.\" ");
INSERT INTO sce_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Hhe bierei ire Ersai beiizhi kieliewo, \"Ezhan, made banman nie gie!\" ");
INSERT INTO sce_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ersa kieliewo, \"Kesilai ginanyi ga nogheide bendazhi ogise ese oluzho.\" ");
INSERT INTO sce_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Hhe bierei kieliewo, \"Ezhan, oluzhoma, nogheiye ezhanne shire doura bousan zhazhai ijiene.\" ");
INSERT INTO sce_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ingiese Ersa kieliewo, \"Funi, chii xianxin gieku fugie wo. Chi keresan mutun chade gholu gie.\" Hhe shihoude oqinni goudawo. ");
INSERT INTO sce_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ersa hhense likai giezhi Jialilihai bienzide iredene ulade khirei souwo. ");
INSERT INTO sce_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tebieji olon kunla hhei hhende iredene dogholon, sugho, sanfei, yaba, pse olon gientulai hhei konshida jiese hhe goudaghawo. ");
INSERT INTO sce_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Yaba kielien kielie, sanfei gouda, dogholon yo, sugho chanlasei olon kunla uzhedene ghanirazhi Isilieni Hudai kuaiwo. ");
INSERT INTO sce_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ersa tujilane uruzhi ire kieliewo, \"Ene kunla mare hhantu ghurudu oluzho, hhelade ijiekui widazho. Bi hhelade ubali xiizho. Bi hhelai oliesuzhi echighaku duran uwo. Mo jiere echise injirekuse ayizho.\" ");
INSERT INTO sce_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tujila hhende kieliewo, \"Ene hontande imeghei kunlade ijie chudughaku ginan bijiende khalase irene?\" ");
INSERT INTO sce_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ersa hhelade kieliewo, \"Tande ginan giedughon wo?\" Hhela kieliewo, \"Dolon wo, pse giedun ga zhaghasun wo.\" ");
INSERT INTO sce_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ersa olon kunlai fenfulazhi zemin jiere soughadene ");
INSERT INTO sce_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","dolon ginan, giedun zhaghasunyi barei mafan kieliedene ghulu tujilade ogise tujila olon kunlade ogiwo. ");
INSERT INTO sce_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Dajiala man ijiezhi chududene feiliesan zhazhai dolon lanzi zhonlowo. ");
INSERT INTO sce_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ijiesan kun dunda bierei kewosilai ulie sanase 4000 ere kun wo. ");
INSERT INTO sce_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ersa kunlai sandaghadene chon jiere khirei Majiadan oronde echiwo. ");
INSERT INTO sce_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Falisai kun, Sadugai kunla Ersai shida iredene hhei shiizhi asiman jierese iresan ghudureqi uzhegha giezhi yoqiu giezho. ");
INSERT INTO sce_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ersa hhelade kieliewo, \"Khara olukude olien shouizhi daose, 'Maghashijie arulune.' giezhi ta kieliene. ");
INSERT INTO sce_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Eqiemagha olien shouizhi dao dase, 'Enedu kei feiliezhi ghura boune.' giezhi kieliene. Ta asimanni qinkonyi fenjine, ene shidaini ghudureqini fenji dane. ");
INSERT INTO sce_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ene idaini kunla, doghun nefuxin giezho, ta dou ghudureqi kerezhoma, Yunusii ghudureqise chugo uzheghaku ghudureqi uwo.\" Ingiedene hhelase likai giewo. ");
INSERT INTO sce_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tujila hai duimiende daose ginan bareikui matazho. ");
INSERT INTO sce_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ersa hhelade kieliewo, \"Ta Falisai kun, Sadugai kunlai kuniegheni jinxin giezhi fangula.\" ");
INSERT INTO sce_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tujila nieniedene kielienduzho, \"Matan ginan ese bareise ingiezhi kieliezhoba.\" ");
INSERT INTO sce_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ersa mejiedene kieliewo, \"Ta ene xianxin gieku zhughe gajitu kunla, ta yangiezhi ginan wikui kielienduzho? ");
INSERT INTO sce_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ta dou minbai olu dazhou? Tawun ginanyi 5000 kunde ogizhi giedun lanzi zhonlosei jila danu? ");
INSERT INTO sce_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Pse dolon ginanyi 4000 kunde ogizhi giedun lanzi zhonlosei jila danu? ");
INSERT INTO sce_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Bi kieliesanshi ginanyi ese kieliesei ta matugie mejie dane? Ta jinxin giezhi Falisai kun, Sadugai kunlai kuniegheni fangula.\" ");
INSERT INTO sce_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ingiekude tujila Ersa ginan kuniegheni ese kieliezhi Falisai kun, Sadugai kunla surughasei fangula giesei mejiewo. ");
INSERT INTO sce_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ErsaKaisaliya-Feilibi oronde iredene tujiladene asazho, \"Kunla kieliese Kunnikewonshi kien wo giezho?\" ");
INSERT INTO sce_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Hhela kieliewo, \"Kunla kieliese xili gieghasan Yaheiya wo giezho. Niezhan kunla kieliese Iliya wo giezho. Pse niezhan kunla kieliese Yelimi onu, xienzhi dundadu nie wo giezho.\" ");
INSERT INTO sce_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ersa hhelade kieliewo, \"Ta kieliese bishi kien wo?\" ");
INSERT INTO sce_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ximun-Beduru kieliewo, \"Chishi Mexiha wo. Chanqiku Hudai kewon wo.\" ");
INSERT INTO sce_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ersa hhende kieliewo, \"Ximun-Bayena, chade fuqi wine! Enei chade mejieghasanshi kun pusho, asiman jieredu adami wo. ");
INSERT INTO sce_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Bi pse chade kielieye, chishi Beduru wo. Bi jiohuine ene tashi jiere giene. Dozoni lilian hhense inji dane. ");
INSERT INTO sce_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Bi asiman gojiani yeshii chade ogiye. Chi zemin jiere yan banlase asiman jiereye yan banlane. Chi zemin jiere yan andaghase asiman jiereye yan andaghane.\" ");
INSERT INTO sce_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ingiedene Ersa, \"Goyaneshi Mexiha bikui kiemade bu kielie!\" giezhi tujilade fenfulawo. ");
INSERT INTO sce_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Hhe shihouse Ersa matugieseda Yelusalende echidene zhanlao, fugie buwa, jinwun hanjialase hende shouku giezhi goyai aladene ghurudude aminne olukui tujiladene kielie qiiwo. ");
INSERT INTO sce_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","BeduruErsai laidene kheila qiiwo, \"Ezhan, ulie olune! Intui chii jiere ulie irene.\" ");
INSERT INTO sce_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ersa ochira daore Bedurude kieliewo, \"Ibilisi, mii khuina dao! Chi mii unaghane. Chi Hudai isii ulie sumulazhi kunni isii sumulane.\" ");
INSERT INTO sce_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ersa tujiladene kieliewo, \"Kien mii daghane giese goyane sheidene shizijiane beiliezhi mii daghakuni wo. ");
INSERT INTO sce_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kien aminne jiuine giese aminne widaghane. Made oluzhi aminne widaghase aminne ulie widaghane. ");
INSERT INTO sce_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kun duyani man zhenjidene goya aminne widaghase yande gou wo? Kun pse yanghala aminne arunzhane? ");
INSERT INTO sce_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kunnikewon qienxienlarene hhantu hhei adani fama dunda irene. Ingiekude zhao kunni giekughala jien kunde kharulune. ");
INSERT INTO sce_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Bi tande shuhua kielieye, enende beisan kun dunda niezhanla Kunnikewon qienline bareizhi irekui ulie chanlatula ulie fugune.\" ");
INSERT INTO sce_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Zhighudu daose ErsaBeduru, Yagebu, Yagebui jiuni Yaheiyai danxin uduru undu ulade khireidene ");
INSERT INTO sce_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","hhelai melie bienjiwo. Ungieni naran mutun gieghan wo, jienni chighande gon niekielien wo. ");
INSERT INTO sce_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Menzhali Musa, Iliyaghala Ersare kielien kieliesei hhela chujieghewo. ");
INSERT INTO sce_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","BeduruErsade kieliezho, \"Ezhan, matan enende gou wo. Chi duran bise bi enende ghuran zhanfan daiye. Niei chade, niei Musade, niei Iliyade.\" ");
INSERT INTO sce_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Beduru kieliekude menzhali niegieda gon faisan olien iredene hhelai khawo. Oliense shenqi irezhi kieliewo, \"Eneshi bi oresan mii kewon wo. Bi hhende xiqi wo. Ta hhei kielienyi chenlie!\" ");
INSERT INTO sce_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tujila sonosudene hende ayizhi zemin jiere papalawo. ");
INSERT INTO sce_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ersa melie iredene hhelai maqizhi kieliewo, \"Bosizhe, bu ayi.\" ");
INSERT INTO sce_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Hhela qiorunne qila uzhese Ersase chugo kiemai ese chanlawo. ");
INSERT INTO sce_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ulase boukude Ersa hhelade fenfulazhi kieliewo, \"Kunnikewon fugusan kun dundase aminne ulie olutula ta chanlasei kiemade bu kielie.\" ");
INSERT INTO sce_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tujila Ersade asawo, \"Qinse jinwun hanjiala yangiezhi Iliya ijinyo xien irene giezhi kieliezho?\" ");
INSERT INTO sce_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ersa kieliewo, \"Iliya irezhi man erchan gie goudaghanema, ");
INSERT INTO sce_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","bi tande kielieye, hhe ijin irezhoma, kunla hhei tani dazhi shimatu giezho. Kunnikewonniye niekielienji zayalane.\" ");
INSERT INTO sce_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ersa xili gieghasan Yaheiyai zhiizhi kieliesei tujila caigie minbai oluzho. ");
INSERT INTO sce_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ersa tujilarene iban kunlai shida irese nie kun Ersai melie ire xiutuliezhi kieliewo, ");
INSERT INTO sce_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","\"Ezhan, mii kewonde ubali nie xii! Hhende kharalaku gien kurudene tendun fugie wo. Haojihui khande usude anda bouzho. ");
INSERT INTO sce_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Bi udurudene tujila shidachii echise hhela goudagha dane.\" ");
INSERT INTO sce_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ersa kieliewo, \"Ai, ta ene xianxin gieku witu, xiemecha yochen kunla, bi tanse rennai giezhi giedoghoncha beine? Kewonni uduruzhi mii enende ire!\" ");
INSERT INTO sce_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ersa sheitanyi nie sugiese sheitan khizhewo. Hhe shihoude kewon goudawo. ");
INSERT INTO sce_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ingiekude tujila Ersai shida konkonji ire asawo, \"Bijien yangiezhi ene sheitanyi khigha dane?\" ");
INSERT INTO sce_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ersa kieliewo, \"Tai xianxin gieku texien gaji wo. Bi tande shuhua kielieye, tande caizi fure chigei xianxin gieku bise ta ene ulade enense noidene hhende dao giezhi kieliese daone, ingiese ta yama gie dakui uwo.\" ");
INSERT INTO sce_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Hhela Jialilide hhantulakude Ersa tujilade kieliewo, \"Kunnikewonni kunlai khade jiuidene ");
INSERT INTO sce_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","hhela alase ghurudude aminne olune.\" Ingiese tujila hende yuchou giezho. ");
INSERT INTO sce_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Hhela Jiabainunde irese mechide shui shanjisan kunla Bedurui melie ire kieliewo, \"Tai loushi shui ulie jiuinu?\" ");
INSERT INTO sce_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Beduru kieliewo, \"Jiuine.\" Beduru giedoura orose Ersa xien hhende asawo, \"Ximun, chii isi matugiezho? Duyani honshanla kiense shui, baer ghurazho? Goya kunlase onu, niman kunlase wo?\" ");
INSERT INTO sce_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Beduru kieliezho, \"Niman kunlase wo.\" Ersa kieliezho, \"Qingiese goya kunlanughunne mienlienema, ");
INSERT INTO sce_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","matan reikusene ayine, chi haibienzide echisenu zhaghasun barei. Touchan bareisan amanyini keighama, nie miengui chanlane. Chi agizhi echidene matan ghualanughunyi jiui.\" ");
INSERT INTO sce_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Hhe shihoude tujilani Ersai shida ire asawo, \"Asiman gojiade kien zui fugie wo?\" ");
INSERT INTO sce_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ersa nie kewosii uruzhi ire hhelai dunda beighadene kieliewo, ");
INSERT INTO sce_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","\"Bi tande shuhua kielieye, ta geizhen giezhi kewosi mutun ulie gholuse asiman gojiade oro dane. ");
INSERT INTO sce_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ingiese kien ene kewosi mutun goyane meilade uzhese asiman gojiade zui fugie wo. ");
INSERT INTO sce_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kien mii niereghala intu kewosii jienliese mii jienliezho.\" ");
INSERT INTO sce_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","\"Kien mii xianxin giesan enezighan ga kun dundadu niei zui fanjighase ghuzhundeni qiemanshai banladene haini gunde boughase da gou wo. ");
INSERT INTO sce_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Zui fanjiku yenyinghala ene duyade gou widawo. Zui fanjighaku shiqin chan winema, kunlai zui fanjighasan hhe kunde gou widawo! ");
INSERT INTO sce_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Chii nie kha onu nie kon chii zui fanjighase chizhidene benda! Ghua kha ghua kon bidene chanqiku khande bendatula nie kha onu nie kon feiliedene chanqi amitukude orose da gou wo. ");
INSERT INTO sce_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Chii nie nudun chii zui fanjighase waidene benda! Ghua nudun bidene dozoheini khande bendatula nie nudun feiliedene chanqi amitukude orose da gou wo.\" ");
INSERT INTO sce_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","\"Ta xioxin giezhi enezighan ga kun dundase nieiliuzhe meilade bu uzhe. Bi tande kielieye, hhelai qienxienla asiman jieredu adaimi shida chanqi wine. ");
INSERT INTO sce_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Nie kunde 100 gie ghoni wo. Nieni yo widase ta sumulase matugiene? 99 gieni ulade jiesenu widasan ghonii ereile ulie echinu? ");
INSERT INTO sce_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Bi tande shuhua kielieye, hhe ereizhi oluse uye widasan 99 giese da olon bayasune. ");
INSERT INTO sce_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Tai asiman jieredu adaye niekielien wo. Enezighan ga kun dundadu nieiliuzhe widaghaku duran uwo.\" ");
INSERT INTO sce_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","\"Gaijiuchii zui fanjise hhei hhende echizhi zinie ta ghuala bikude codaseini kielie. Hhe chii kielienyi chenliese chade nie gaijiu olodowo. ");
INSERT INTO sce_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Hhe ulie chenliese kun nie ghua urudene tanghala echi. Ingiese 'jien zhasan shiqinlai ghua, ghuran kunni ganzhenghala shidaghane.' ");
INSERT INTO sce_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Hhe pse ulie chenliese jiohuide kielie. Jiohuini kunlanughunyiye ulie chenliese niman kun, shui shanjisan kun mutun uzhe. ");
INSERT INTO sce_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Bi tande shuhua kielieye, ta zemin jiere yan banlase, asiman jiereye yan banlane. Ta zemin jiere yan andaghase asiman jiereye yan andaghane. ");
INSERT INTO sce_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Bi pse tande kielieye, tai dunda ghuala hhantulazhi nie zhugheghala zemin jiere onxian giesanlai asiman jiereshiku adami man chenjighane. ");
INSERT INTO sce_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ghua ghuran kun mii niereghala khala hhantulase bi hhelai dunda wine.\" ");
INSERT INTO sce_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ingiekude Beduru shidani ire kieliewo, \"Ezhan, jiumi made gieduifa zui fanjise bi gieduifa hhei rouliene? Doleifashi kurulie?\" ");
INSERT INTO sce_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ersa kieliewo, \"Bi chade kielieye, doleifa ulie kurune, 70 gie doleifa wo. ");
INSERT INTO sce_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ingiese asiman gojiashi hoxian honshan hojilarene zhan sanaku niekielien wo. ");
INSERT INTO sce_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Sanazhi qiikude 50 on antan chaisan kunyi uduruzhi irewo. ");
INSERT INTO sce_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Hhende yama honjikui uwo, ezhanni minlin xiaizhi hhei, biereiini, kesilaini, pse bisanlaini man huidene honji giezho. ");
INSERT INTO sce_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Hhe hoji papaladene, 'Made shijien pse gouji ogi, bi man honjine.' giezhi kieliezho. ");
INSERT INTO sce_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ezhanni hhende ubali xiidene andaghazhi chaisan baerni man rouliewo.\" ");
INSERT INTO sce_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","\"Ene hoji khizhedene hhende hharan miengu chaisan hhantuku kunyi penjidene bareizhi ghuzhunsei nieqidene, 'Chaisan baerni iregha.' giezho. ");
INSERT INTO sce_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Hhantuku kunni papaladene 'Shijien gouji ogima, bi honjiye.' giezhi xiahua giezho. ");
INSERT INTO sce_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Hhe kun ulie olune giedene chaisan baerni honjitula bafanzide khazho. ");
INSERT INTO sce_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Pseshiku hojila enei chanladene hende nango giedene echi ene shiqinyi man ezhandene huibao giewo. ");
INSERT INTO sce_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ingie ezhanni hhe kunyi uru iredene kieliewo, 'Chi ene doghun hoji! Chi mii xiahua giese bi chi chaisanlai man rouliewo. ");
INSERT INTO sce_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Bi chade ubali xiizho giezhi chi hhantuku kundene qingiezhi indan ubali xiise ulie olunu?' ");
INSERT INTO sce_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ezhanni hende hokudene chaisan baerni man honjitula bafanzi sagheisan kunlade jiuizhi eghighazho. ");
INSERT INTO sce_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ta gaijiune zhughesene ingiezhi ulie rouliese asiman jieredu adamiye tande ingiezhi giene.\" ");
INSERT INTO sce_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ersa ene kielienlai kielie baraghadene Jialilise likai giezhi Yedanhe duimienni Yudaya oronde irewo. ");
INSERT INTO sce_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tebieji olon kunla hhei daghazho, Ersa hhende kunlai goudaghawo. ");
INSERT INTO sce_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Falisai kunla ire Ersai shiizhi asazho, \"Kun yan yenyinghalaliuzhe biereine lihun gieghase olunulie?\" ");
INSERT INTO sce_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ersa kieliewo, \"Kunyi zhayaghasan Huda dei qiikude ere kun, eme kunyi zhayaghawo giezho. ");
INSERT INTO sce_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Pse, 'Ingiese kun ada anasene likai giedene biereighalane hhantulazhi ghuala nie beye gholune.' giezhi kieliesan jinwunni ta onshizhi ese daowu? ");
INSERT INTO sce_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Hhela ghua pusho, nie wo. Ingiese Huda hhantulaghasei kun fenkai gieghase ulie olune.\" ");
INSERT INTO sce_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Falisai kunla asawo, \"Qinse Musa yangiezhi lihun qiuzi ogidene lihun gie giezhi fenfulawo?\" ");
INSERT INTO sce_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ersa hhelade kieliewo, \"Tai zhughe khidunshi Musa ta biereine lihun gieghase olune giezhoma, dei qiikude ingie ese giezho. ");
INSERT INTO sce_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Bi tande kielieye, kien lon kijieku yenyinse chugo biereighalane lihun giedene pse agise piofen giezho.\" ");
INSERT INTO sce_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tujilani Ersade kieliewo, \"Ere kun bierei kunyi gonxi imutuishi jiehun ulie giese da gou wo.\" ");
INSERT INTO sce_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ersa kieliewo, \"Ene kielienyi kienliuzhe man jienlie shidaku pusho, kiende nengou ogise kien jienliene. ");
INSERT INTO sce_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Niezhan kunla olusanse jiehun gie dane. Niezhan kunlai kunla ataladene jiehun gie dane. Pse niezhan kunla asiman gojiade oluzhi goyane jiehun ulie giene. Ene kielienyi kien jienlie shidase jienliedu.\" ");
INSERT INTO sce_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ingiekude kunla kesilane uduruzhi Ersai melie ire hhelai jiere kha teizhi onxian gieghane giese tujila hhelai sugiezho. ");
INSERT INTO sce_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ingiese Ersa kieliezho, \"Kesilai bu dui, mii shida ire gie. Asiman gojiashi imutu kunlanughun wo.\" ");
INSERT INTO sce_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ersa hhelai jiere khane teidene hhense likai giewo. ");
INSERT INTO sce_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nie kun Ersai melie iredene kieliewo, \"Loushi, bi yan gouni giese chanqiku amin wine?\" ");
INSERT INTO sce_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ersa kieliewo, \"Chi made yangiezhi gouni asane? Zi niekozishi gouni wo. Chi chanqiku aminyi jienliene giese minlinni zunji.\" ");
INSERT INTO sce_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Hhe asawo, \"Yan minlin wo?\" Ersa kieliewo, \"Kun bu ala, piofen bu gie, bu ghula, jia ganzhen bu bei, ");
INSERT INTO sce_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ada anane zunji, goyadene mutun giebeidene ore.\" ");
INSERT INTO sce_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nasuchighan kun kieliewo, \"Enelai bi man zunjiwo, pse yan chaizho?\" ");
INSERT INTO sce_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ersa hhende kieliewo, \"Chi man qiendaghaku duran bise echidene bisanlane man huizhi nanxin kunlade ogi. Ingiese chii boubei asiman jiere wo. Ingiedene irezhi mii dagha.\" ");
INSERT INTO sce_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nasuchighan kunde caichan olonshi ene kielienyi chenliedene yuchourazhi yolawo. ");
INSERT INTO sce_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ersa tujiladene kieliewo, \"Bi tande shuhua kielieye, bayan kun asiman gojiade oroku chijia wo. ");
INSERT INTO sce_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Bi tande pse kielieye, loto zhun boghose daoku bayan kun Hudai gojiade orokuse da sunfan wo.\" ");
INSERT INTO sce_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tujila enei chenliedene ghanirazhi kieliewo, \"Ingiese kienyi jiui shidane?\" ");
INSERT INTO sce_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ersa hhelai uzhedene kieliewo, \"Kun enei gie danema, Huda yanniliuzhe giene.\" ");
INSERT INTO sce_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ingiekude Beduru kieliewo, \"Uzhe, bijien man bendadene chii daghazho. Jianlai bijiende yan wine?\" ");
INSERT INTO sce_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ersa kieliewo, \"Bi tande shuhua kielieye, shini duyade Kunnikewon goyane famatu baozo jiere soukude, ta enezighan mii daghasan kunlaye 12 gie baozo jiere souzhi Isilieni 12 gie paini gonjine. ");
INSERT INTO sce_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kien mii nierede oluzhi gie, gaijiu, eghechijiu, ada, ana, kesila, ghazhane bendase 100 pei ogine, da chanqiku aminni jienliene. ");
INSERT INTO sce_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ingiese olon melieshikula khuinashilane, khuinashikula melieshilane.\" ");
INSERT INTO sce_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","\"Asiman gojia hoxian nie gieni zhanguijii xianli. Eqiemagha eqie khizhi echizhi kun guidene putou yenzidene wilie gieghane giezho. ");
INSERT INTO sce_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Wiliechilaghala niudu nie miengu ogikui kielie goudaghadene hhelai putou yenzide echighawo. ");
INSERT INTO sce_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Eqiemagha 9 jien olukude zhanguiji khizhi echise jide xien beisan kunyi chanladene ");
INSERT INTO sce_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","hhelade kieliewo, 'Taye putou yenzide ire, tande heshide baer ogine.' ");
INSERT INTO sce_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ingie hhela echiwo. Xiawu 12 jien, pse 3 jien olukude zhanguiji khizhi echidene ye ingiezhi giewo. ");
INSERT INTO sce_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Hhe xiawu 5 jien olukude pse khizhi echise dou xien beisan kunni chanladene hhelade asawo, 'Ta niudu enende beizhi wilie giele yale ese echizho?' ");
INSERT INTO sce_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Hhela kieliewo, 'Bijienyi kieme ese guizho.' Hhe kieliewo, 'Taye putou yenzide ire.' ");
INSERT INTO sce_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Khara oluse putou yenzii zhanguiji duizhande kieliewo, 'Wilie giesan kunlai uruzhedene zui khuina iresanse baerlaini ogizhi zui melie kuru.' ");
INSERT INTO sce_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Xiawu 5 jien olukude iresan kunla nie kun nie miengu linlawo. ");
INSERT INTO sce_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Zui melie iresan kun iredene olon ogimu giezhoma, yen nie kun nie miengu linlawo. ");
INSERT INTO sce_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Hhela linladene zhanguijide boxin giezhi kieliezho, ");
INSERT INTO sce_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","'Bijien khara naran doura niudu khishilazho. Enezighan khuina iredene nie zhuntou wilie giesan kunlai bijienre niekielien uzhezho.' ");
INSERT INTO sce_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ingiese zhanguiji hhelai dundashiku nie kunde kieliewo, 'Zhanlien, bi chii ese kuighazho. Matan ghuala kieliesanshi nie miengu wola? ");
INSERT INTO sce_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Goyanughunne agidene echi. Zui khuina iresan hhe kunde chade ogisanghala niekielien ogise bi yenyi wo. ");
INSERT INTO sce_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Bi duranghalane baerne injise ulie olunu? Bi gou kun danlase chi dubilienu?' ");
INSERT INTO sce_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ingiese khuinashikula melieshilane, melieshikula khuinashilane.\" ");
INSERT INTO sce_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ErsaYelusalende khireikude mo jiere 12 gie tujine uruzhi ire hhelade kieliewo, ");
INSERT INTO sce_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","\"Uzhe, matan Yelusalende khireine. Kunnikewonyi fugie buwa, jinwun hanjialade jiuise hhela hhei sixin panjidene ");
INSERT INTO sce_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","niman kunlade jiuine. Hhela hhei xilun giene, mabienzighala eghine, shizijia jiere ghada alane. Ingie ghurudude aminne olune.\" ");
INSERT INTO sce_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ingiekude Xibitaini bierei ghua kewonne uduruzhi Ersai melie ire xiutuliezhi xiahua giezho. ");
INSERT INTO sce_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ersa kieliewo, \"Chi yan kerene?\" Hhe kieliewo, \"Mii onxianshi ghua kewonyimi chii gojiade niei chii borun miende niei soghei miende sougha.\" ");
INSERT INTO sce_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ersa kieliewo, \"Ta ghuala yan keresanne ulie mejiene. Bi shouiku kuni ta shoui shidanu?\" Hhela kieliewo, \"Shouine.\" ");
INSERT INTO sce_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ersa kieliewo, \"Bi shouiku kuni ta shouinema, mii lianmien kanzide soughakui bi ogiku pusho. Adami kiende zhunbei giezhoshi kiende ogine.\" ");
INSERT INTO sce_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Psedu hharan tujini sonosudene hhe gaijiughalade hokuzho. ");
INSERT INTO sce_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ersa hhelai uruzhi ire kieliewo, \"Niman kunlai dunda lindao, noyenla qienli bareizhi kunlai gonjisei ta mejiene. ");
INSERT INTO sce_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ta niekielien pusho, tai dunda kien fugieni danlane giese tande ushilachen kun danlakuni wo. ");
INSERT INTO sce_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Tai dunda kien laoda danlane giese tande hoji danlakuni wo. ");
INSERT INTO sce_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kunnikewon irekushi kunlai ushilaghale ese irezho. Kharei kunlai ushilazhi aminne sheidene olon kunlade shuiku Jiage danlale irezho.\" ");
INSERT INTO sce_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Hhela Yeligese likai giekude tebieji olon kunla Ersai daghazho. ");
INSERT INTO sce_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ghua sugho mo bienzide souzho. Ersa daosei sonosudene waradazho, \"Ezhan, Dawudeni houdei, bijiende ubali nie xii!\" ");
INSERT INTO sce_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kunla jiebalazhi shenqi bu khizhe giese hhela genjia fugiede waradazhi kieliezho, \"Ezhan, Dawudeni houdei, bijiende ubali nie xii!\" ");
INSERT INTO sce_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ersa beidene hhelai uruzhi ire kieliezho, \"Bi tande yan giene?\" ");
INSERT INTO sce_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Hhela kieliezho, \"Ezhan, bijienyi nudunyi goudagha!\" ");
INSERT INTO sce_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ersai zhugheni zholieredene hhelai nudunyi nie moise hhela deigo chanladene Ersai daghawo. ");
INSERT INTO sce_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Hhela Yelusalense chadashizhi Ganlanshanni Bofaqide irekude Ersa ghua tujine peizhi ");
INSERT INTO sce_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","hhelade kieliewo, \"Ta duimienni aghinde echi. Hhende nie huiyasan enzheghei deigo chanlane, shidai da nie unaghan wo. Ta andaghadene mii shida lai ire. ");
INSERT INTO sce_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kunla tande asase, 'Ezhan hhelai injine.' giezhi kieliema, hhe kun deigo laighane.\" ");
INSERT INTO sce_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ene shiqin fashen giekushi Ezhan xienzhini tungo giezhi kieliesan kielien mutun gholughane giezho, ");
INSERT INTO sce_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","\"Xiwunni kunlade kielie. Uzhe, tai honshan tai hhende irewo. Hhe goyane meilade uzhezhi enzheghe unuzho. Unusanshi ga enzheghe wo.\" ");
INSERT INTO sce_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Tujila echidene Ersa fenfulasan mutun giewo. ");
INSERT INTO sce_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Hhela enzheghe, ga enzheghei lai ire goya jienlane enzheghe jiere daidene Ersai unughawo. ");
INSERT INTO sce_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Olon kunla jienlane mo jiere peizho. Psedu kunla mutun chalai chizhidene mo jiere peizho. ");
INSERT INTO sce_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Melie khuinadu olon kunla waradazhi kieliezho, \"Hesanna! Dawudeni houdeii doulandu! Ezhanni niereghala iresan hhei doulandu! Zui undudedu Hudai doulandu!\" ");
INSERT INTO sce_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ErsaYelusalende orose kunla man hunnerei daghazhi eneshi kien wo giezho. ");
INSERT INTO sce_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Olon kunla kieliezho, \"Eneshi Jialiliyi Nasaleni xienzhi Ersa wo.\" ");
INSERT INTO sce_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ersa mechide orodene meimei giesan kunlai man tou khighawo. Baer arunzhasan kunlai shire, ghoghochen huisan kunlai bandoulai tungu unaghawo. ");
INSERT INTO sce_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Hhelade kieliewo, \"Mii giei onxian gieku gie giezhi urune giezhi jinwun jiere huaizho. Ta ghughei ho gholughazho!\" ");
INSERT INTO sce_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mechi sudoro sugho, dogholonla Ersai shida irese hhelai goudaghawo. ");
INSERT INTO sce_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Fugie buwa, jinwun hanjiala Ersa ghaniraku shiqin giesei chanladene pse kesila mechi doura Hesanna! Dawudeni houdeii doulandu giezhi onghonosei sonosudene hende hokuzhi ");
INSERT INTO sce_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ersade asawo, \"Enezighan kesila kieliesei chi sonosuwoye?\" Ersa kieliewo, \"Sonosuwo. Jinwun jiere chi yeliwa, ga kesilai amanghala goyane doulaghawo giesei ta onshizhi ese daowu?\" ");
INSERT INTO sce_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ingie hhelase likai giezhi chenshise khidene Bodanide echi nie xii souwo. ");
INSERT INTO sce_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ersa eqiemagha chenshide khareikude oliesuzho. ");
INSERT INTO sce_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Mo bienzide nie uhuago mutunyi chanlawo. Shidani echi nie uzhese mutun jiere lachen wine, alima uwo. Ersa mutunde, \"Enedu khuinase chii jiere ibeizi alima ulie soune.\" giezhi kieliese uhuago mutun deigo gho fuguwo. ");
INSERT INTO sce_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tujila uzhedene ghudurezhi, \"Uhuago mutun matugie deigo gho fuguwo.\" giezhi kieliezho. ");
INSERT INTO sce_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ersa kieliewo, \"Bi tande shuhua kielieye, tande xianxin gieku bizhi inxin ulie giese bi uhuago mutun jiere giesei taye gie shidane, da ene ulade oronsene noidene haide bou giezhi kieliese boune. ");
INSERT INTO sce_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ta xianxin giedene xiahua giezhi onxian giese man ogine.\" ");
INSERT INTO sce_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ersa mechide orodene kunlade sughakude fugie buwa, bexinlai zhanlaola hhei shida ire kieliezho, \"Chi yan qienlighala ene shiqinlai giezho? Kien chade ene qienlii ogizho?\" ");
INSERT INTO sce_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ersa hhelade kieliewo, \"Biye tande nie unqi asaye. Ta made kieliese biye yan qienlighala ene shiqinlai giesei tande kieliene. ");
INSERT INTO sce_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yaheiyai xili gieghaku qienli khalase irezho? Asimanse onu, kunlase wo?\" Hhela goyalane shanlian giezhi kieliewo, \"Matan asimanse wo giese, 'Ta yale hhei xianxin ulie giene.' giezhi hhe matande kieliene. ");
INSERT INTO sce_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kunlase wo giese matan bexinlase ayizho, hhela man Yaheiyashi xienzhi wo giezho.\" ");
INSERT INTO sce_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ingie Ersade kieliewo, \"Bijien ulie mejiene.\" Ersa hhelade kieliewo, \"Biye tande yan qienlighala ene shiqinlai giesei ulie kieliene.\" ");
INSERT INTO sce_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","\"Ta nie sumula bi ede bilaku matugiezho? Nie kunde ghua kewon wo. Hhe fugie kewondene kieliezho, 'Mii kewon, chi enedu putou yenzide wilie giele echi.' ");
INSERT INTO sce_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Kewonni kieliewo, 'Bi ulie echine.' Khuinashida houhui giedene echiwo. ");
INSERT INTO sce_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Adani echidene meila kewondene ye niekielienji kieliezho. Kewonni kieliewo, 'Ada, bi echiye.' Ingiedene ese echiwo. ");
INSERT INTO sce_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ta sumulase ene ghua kewonlani alinie adane kielienyi chenliezho?\" Hhela kieliewo, \"Fugie kewon wo.\" Ersa kieliewo, \"Bi tande shuhua kielieye, shui shanjisan kun, biozila tanse melie Hudai gojiade orone. ");
INSERT INTO sce_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yaheiya tai hhende irekude gou moni uzheghazho. Ta hhei xianxin ulie giene, shui shanjisan kun, biozila hhei xianxin giezho. Ta hhela xianxin giesei uzhedene dou geizhen ulie giezhi xianxin ulie giene.\" ");
INSERT INTO sce_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","\"Ta pse nie bilasei chenlie. Nie gieni zhanguiji nie yenzi putou zeiladene izhonyini qienjiwo. Sudoroni jiu daruku chizi waizhi yenzi uzheku teizi giedene kunlade bouizhi ogi, gholode echiwo. ");
INSERT INTO sce_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ghuraku shihou oluse hojilai peizhi bouisan kunlase nexianne ghuraghale echiwo. ");
INSERT INTO sce_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Bouisan kunla hojilaini bareidene nieini eghiwo, nieini alawo, nieini tashida alawo. ");
INSERT INTO sce_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Zhanguijii pse genjia olon hojilai peizhi echighase bouisan kunla yen qingiezhi duidai giewo. ");
INSERT INTO sce_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Zuihoude hhela kewonyimi zunjineba giezhi kewonne peizhi echighawo. ");
INSERT INTO sce_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Bouisan kunla kewonyini chanladene nieniedene kielienduzho, 'Eneshi jiachanni jienliechen wo. Matan enei aladene jiachanni zhanjiye!' ");
INSERT INTO sce_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ingie hhei bareidene putou yenzise tungu khigha alawo. ");
INSERT INTO sce_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ingiese putou yenzii zhanguiji irekude bouisan kunlai matugiene?\" ");
INSERT INTO sce_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Hhela kieliewo, \"Doghun kunlai ese rouliezhi aladene putou yenzini nanshi putou jiuichen kunlade bouizhi ogine.\" ");
INSERT INTO sce_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ersa hhelade kieliewo. \"Ta jinwun jiere onshizhi ese daowu? 'Gie giesan kunla bendasan tashi giei zhunyo tashi gholuwo. Eneshi Ezhan giesanwo. Matan uzhese xihan giezho.' ");
INSERT INTO sce_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ingiese bi tande kielieye, Hudai gojiai tanse agi echidene Hudai gojiade oluzhi jiego khizheghasan minzude ogine. ");
INSERT INTO sce_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kien ene tashi jiere anda bouse zhazhazi gholune. Ene tashi kienyi jiere anda bouse zai miendaghane.\" ");
INSERT INTO sce_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Fugie buwa, Falisai kunla Ersa bilasei chenliedene hhelai zhiizhi kieliesei mejie ");
INSERT INTO sce_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ersai bareine giese olon kunlase ayizho. Olon kunla Ersai xienzhi wo giezho. ");
INSERT INTO sce_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ersa hhelade pse bilazhi kieliewo, ");
INSERT INTO sce_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","\"Asiman gojia hoxian nie honshan kewondene bierei agizhi xi beilasei xianli. ");
INSERT INTO sce_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Hhe hojilane peizhi xinlasan kunlai ghurunde ire giezhi urughale echiwoma, hhela ulie irene. ");
INSERT INTO sce_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Honshan psedu hojilai peizhi kieliewo, 'Ta xinlasan kunlade kielie. Bi ijin xini beila goudaghawo. Fughe, taghun tughuchalai zharuzhi man zhunbei giewo. Ta ghurunde irendu.' ");
INSERT INTO sce_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Hhezighan kunla ese gonjidene yolawo. Nieni ghazha jierene echiwo, nieni meimei giele echiwo. ");
INSERT INTO sce_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Pseshikula honshanyi hojilai bareidene shizheghazhi alawo. ");
INSERT INTO sce_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Honshan hokudene buduilai peizhi hhezighan alasan kunlai aladene hhelai chenshini tulie widaghawo. ");
INSERT INTO sce_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ingie hojiladene kieliewo. 'Ghurunni zhunbei giezhi goudaghazhoma, xinlasan kunla pei dane. ");
INSERT INTO sce_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ta dalu kouzide echisenu chanlasan kunlai man ghurunde xinlazhi ire.' ");
INSERT INTO sce_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Hhezighan hojilani dalu jiere echidene gou kun, doghun kunni ese gonjidene man uruzhi ire ghurunde zhochen duruwo. ");
INSERT INTO sce_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Honshan orozhedene shire jieredu zhochenlai nie uzhese ghurunde musiku jien uye musisan nie kunni chanla, ");
INSERT INTO sce_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","hhende 'zhanlien, chi enende irese yangiezhi ghurunde musiku jien ese musizho?' giese hhe kunde yama shenqi uwo. ");
INSERT INTO sce_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ingie honshan ushilachen kunlade kieliewo, 'Kha konyini banladene ghadanedu kharanide benda, hhende shidunne zhouzhi wila gie.' ");
INSERT INTO sce_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Urusan kun olon wo, sunghusan kun choghon wo.\" ");
INSERT INTO sce_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Falisai kunla echidene shanlian giezhi Ersai kieliense matugie maobin ereizhi heine giezho. ");
INSERT INTO sce_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Hhela tujilane, Hherodepai kunni peizhi Ersai hhende echighase kieliewo, \"Loushi, chi shuhua kieliekui bijien mejiene. Chi yan kunyiliuzhe niekielien uzhezhi kunni mienzii ulie uzhene. Hudai daolini shixinde sughazho. ");
INSERT INTO sce_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Chii isi matugiezho? Bijiende nie kielie, matan Kaisa honshande shui jiuise oluzhou ese oluzho?\" ");
INSERT INTO sce_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ersa hhelai doghunni uzhe khizhedene kieliewo, \"Jiazhon giesan kunla, ta mii shiizhi yangiene? ");
INSERT INTO sce_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Shui jiuiku baerni made nie uzhegha.\" Hhela nie mienguni agizhese ");
INSERT INTO sce_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ersa kieliewo, \"Ene qiorun, haoshi kiennughun wo?\" ");
INSERT INTO sce_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Hhela kieliewo, \"Kaisanughun wo.\" Ersa kieliewo, \"Qinse Kaisanughunshi Kaisade ogi, Hudanughunshi Hudade ogi.\" ");
INSERT INTO sce_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Hhela chenliedene ghanirazhi Ersase likai gie yolawo. ");
INSERT INTO sce_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Fuho gieku shiqin uwo giesan Sadugai kunla yen hhe udude Ersai shida ire asawo, ");
INSERT INTO sce_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","\"Loushi, Musa guijin jiere kieliezho, nie kunde kewosi wi fuguse jiuni gaine biereii zhoui gaidene houdei liuikuni wo giezho. ");
INSERT INTO sce_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Bijienyi enende gaijiu dololie wo. Laodani bierei agidene kewosi wi fuguse jiuni zhouiwo. ");
INSERT INTO sce_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Laoer, laosan, dololie man ingiezho. ");
INSERT INTO sce_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Zuihoude biereiye fuguwo. ");
INSERT INTO sce_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ingiese fuho giekude hheshi dololie dundadu kienyi bierei wo? Hhela man hhei agiwo.\" ");
INSERT INTO sce_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ersa hhelade kieliewo, \"Tanughun codazho. Ta jinwunni mejie dazho, Hudai nenliniye mejie dazho. ");
INSERT INTO sce_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kun aminne olukude ulie agine, ulie dafalane, asiman jieredu qienxien niekielien wo. ");
INSERT INTO sce_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","Fugusan kun aminne olukui kieliese 'bishi Iburaheimuni Huda wo, Isagheini Huda wo, Yagebuni Huda wo' giezhi Huda tande kieliesei ta onshizhi ese daowu? Hudashi fugusan kunyi Huda pusho, amitu kunyi Huda wo.\" ");
INSERT INTO sce_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Olon kunla ene kielienyi chenliedene hhe sughasande hende ghanirazho. ");
INSERT INTO sce_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Falisai kunla Ersa Sadugai kunlai kielie beighasei mejiedene hhantulazho. ");
INSERT INTO sce_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Hhelai dundadu nie jinwun loushi Ersai shiizhi asawo, ");
INSERT INTO sce_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","\"Loushi, minlin dunda alinie zui fugie wo?\" ");
INSERT INTO sce_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ersa hhende kieliewo, \"Chi qienbuji zhughe, qienbuji jinshen, qienbuji sumulakughalane ezhan Hudadene ore. ");
INSERT INTO sce_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Eneshi zui fugie, ji 1 gie minlin wo. ");
INSERT INTO sce_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ji 2 gie hheghala niekielien wo. 'Goyadene mutun giebeidene ore.' ");
INSERT INTO sce_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ene ghua minlinshi soyuji guijinshu, xienzhishuni jichu wo.\" ");
INSERT INTO sce_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Falisai kunla hhantulakude Ersa hhelade asazho, ");
INSERT INTO sce_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","\"Mexihani kieliese ta matugie sumulazho? Hheshi kienyi houdei wo?\" Hhela kieliewo, \"Dawudeni houdei wo.\" ");
INSERT INTO sce_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ersa kieliewo, \"Qingiese Dawude Shenlinni tungo giezhi matugie Mexihani Ezhan giezhi uruzho? Dawude kieliezho, ");
INSERT INTO sce_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","'Ezhan mii Ezhande kieliewo, \"Bi duitoulaichii kon dourachii teitula chi mii borun miende sou.\"' ");
INSERT INTO sce_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Qingiese Dawude Mexihai Ezhan giezhi uruse Mexiha matugie Dawudeni houdei wo?\" ");
INSERT INTO sce_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kiemada hhende yama huida gie dawo. Hhe uduse khuinashi kiemada hhende yama asa dazho. ");
INSERT INTO sce_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ingiedene Ersa olon kunlade, tujiladene kieliewo, ");
INSERT INTO sce_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","\"Jinwun hanjia, Falisai kunla Musani guijinyi jieshi gieku qienli bareizho. ");
INSERT INTO sce_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ingiese hhela tande sughasei ta man zunjizhi giema, hhelai giekuni bu dagha. Hhela sughasanne ulie giene. ");
INSERT INTO sce_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Hhela banlasan gundu danzilani kunlai dalou jiere jiedene goyala nie kha ghurunneliuzhe ulie gojiolughane. ");
INSERT INTO sce_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Hhela giesan soyuji shiqinlane kunlade uzheghane giezhi giezho. Hhela zhoku jinwun xiaxiani giezhi fugiedaghazho. Jienni sasuiye giezhi fududaghazho. ");
INSERT INTO sce_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Hhela xini shanxide, huitanni undu wizide soukude xiqi wo. ");
INSERT INTO sce_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Giedoude kunla hhelade kielien asazhi loushi giezhi urukude xiqi wo. ");
INSERT INTO sce_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ta kunlai goyane loushi giezhi bu urugha, tande zi niekozi loushi wo, ta manshi gaijiu wo. ");
INSERT INTO sce_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Zemin jieredu kunni ada giezhi bu uru, tande zi niekozi ada wo, hheshi asiman jieredu ada wo. ");
INSERT INTO sce_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ta kunlai goyane shifu giezhi bu urugha. Tande zi niekozi shifu wo, hheshi Mexiha wo. ");
INSERT INTO sce_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Tai dunda zui fugienishi tande hoji danlakuni wo. ");
INSERT INTO sce_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kien goyane undudaghase boghonidaghane. Goyane boghonidaghase undudaghane.\" ");
INSERT INTO sce_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","\"Ta jiazhon giesan jinwun hanjia, Falisai kunlade gou widawo! Ta kunlade asiman gojiani wijienyi khazhi goyalane ese orozho, orone giechen kunlaiye ese oroghazho.\" ");
INSERT INTO sce_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","\"Ta jiazhon giesan jinwun hanjia, Falisai kunlade gou widawo! Ta nie kunyi jiopaidene oroghane giezhi zemin haini yo baraghane. Hhei jiopaidene oroghadene dozoheini kun gholughazhi tanse da olon doghunshighane.\" ");
INSERT INTO sce_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","\"Ta mo udurusan sugholade gou widawo! Ta kieliese mechii zhiizhi fayen giese yama ulie sananema, mechii antanni zhiizhi fayen giese kieliendene kuru giezho. ");
INSERT INTO sce_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Sughotu guazila, alinieshi zhunyoni wo? Antan onu? Antanni zhiguishighasan mechi wo? ");
INSERT INTO sce_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ta pse kieliese sidagha gieku teizini zhiizhi fayen giese yama ulie sananema, sidagha gieku teizi jieredu dunxilai zhiizhi fayen giese kieliendene kuru giezho. ");
INSERT INTO sce_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Sughola, daoji mure zhunyo onu mureni zhiguishighaku sidagha gieku teizi zhunyo wo? ");
INSERT INTO sce_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ingiese kien sidagha gieku teizini zhiizhi fayen giese sidagha gieku teizi, sidagha gieku teizi jiereshiku dunxilani man zhiizhi fayen giezho; ");
INSERT INTO sce_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kien mechii zhiizhi fayen giese mechi sudoro sousan Hudai zhiizhi fayen giezho. ");
INSERT INTO sce_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kien asimanyi zhiizhi fayen giese Hudai baozo, baozo jiere sousan Hudai zhiizhi fayen giezho.\" ");
INSERT INTO sce_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","\"Ta jiazhon giesan jinwun hanjia, Falisai kunlade gou widawo! Ta bohe, huajio, ziranlasene Hudade ushirei ogizhoma, guijin jieredu gundande gieku, ubali xiiku, kekaoni enezighan genjia zhunyoni ulie giene. Enelai ta indan giekui wo, psedulaiye ulie giekui pusho. ");
INSERT INTO sce_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ta mo udurusan sughola, ta meiyen ghugheini liizhi khizheghane, lotoni hulun yenjine.\" ");
INSERT INTO sce_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","\"Ta jiazhon giesan jinwun hanjia, Falisai kunlade gou widawo! Ta beizi, jiezilai mienzii wagha arughazhoma, sudoroni tanxin gieku, lon giekula duruzho. ");
INSERT INTO sce_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ta sughotu Falisai kunla, xien beizi sudorodui waghazhi arugha, mienziye arune.\" ");
INSERT INTO sce_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","\"Ta jiazhon giesan jinwun hanjia, Falisai kunlade gou widawo! Ta fenshua giesan mezai xianli, ghadanese uzhese gou wo, sudoro fugusan kunyi yasun, yanyanji zannanni duruzho. ");
INSERT INTO sce_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Taiye kunla mienzise uzhese gou wo, sudorotai jiazhon gieku, mouxienni duruzho.\" ");
INSERT INTO sce_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","\"Ta jiazhon giesan jinwun hanjia, Falisai kunlade gou widawo! Ta xienzhilai mezai giezho, gou kunni jilaku peizii giezhi mezai goudaghadene ");
INSERT INTO sce_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","'Xienrenlane hhe xienzide bijien bizhoshi xienzhii chusunyi xienrenlarene hhantu ulie usurughane.' giezhi kieliezho. ");
INSERT INTO sce_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ingiezhi ta xienzhilani alasan kunlai houdei bikui zhenmin giezho. ");
INSERT INTO sce_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ta xienrenlane zuini giezhi baraghale echi! ");
INSERT INTO sce_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ta enezighan moghei, du mogheini zhunzhugha. Ta matugie dozoheini faikuse andane? ");
INSERT INTO sce_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ingiese bi xienzhi, aghelitu, jinwun hanjialai tai enende peizhi ireghane. Ta niezhanlai alane, niezhanlai shizijia jiere ghadane, pse niezhanlai huitande mabienzighala eghine, ene chenshise touzhi hhe chenshide echighane. ");
INSERT INTO sce_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ingiese gou kun Hhabise qiizhi izhi dajienji sidagha gieku teizi dunda alasan Balajiani kewon Sajialiyai zuini guide kurutula soyuji gou kunla usurusan chusunni guini man tai jiere ireghane. ");
INSERT INTO sce_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Bi tande shuhua kielieye, ene guini man ene idai kunlai jiere ireghane.\" ");
INSERT INTO sce_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","\"Yelusalen, Yelusalen! Peizhi ireghasan xienzhilai tashidazhi alasan chenshiya, bi chii kesilani gieduifa muji tigha zhunzhughalane siban doura hhantulaghaku mutun hhantulaghane giese ta duran uwo. ");
INSERT INTO sce_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Uzhe, chii gie hontan gholuzhi chade zinie hontan feiliene. ");
INSERT INTO sce_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Bi chade kielieye, chi 'Ezhanni niereghala iresan kunni doulandu.' giezhi kielietula mii pse chanla dane.\" ");
INSERT INTO sce_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ersa mechise khizhedene yokude tujilani ire mechii loulani hhende zhiizhi uzheghawo. ");
INSERT INTO sce_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ersa tujiladene kieliewo, \"Ta enelai man chanlawu? Bi tande shuhua kielieye, jianlai man cheizhi tashi jiere tashi nieda ulie jiene.\" ");
INSERT INTO sce_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ErsaGanlanshande soukude tujila konkonji ire asazho, \"Yan xienzide ene shiqinla fashen giene? Chi irezhi duya barakude yan zunji bikui bijiende nie kielie.\" ");
INSERT INTO sce_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ersa hhelade kieliewo, \"Ta xioxin giezhi kunlai bu piendagha. ");
INSERT INTO sce_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Olon kunla mii niereghala iredene bishi Mexiha wo giezhi olon kunlai miine. ");
INSERT INTO sce_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ta eghindusan, eghindune giesan xioxini sonosune. Ingiese goujida bu jinda. Ene shiqin kenjin fashen gienema, duya baraku shihou dou ese kuzhezho. ");
INSERT INTO sce_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Minzu, minzula eghindune. Gojia, gojiala eghindune. Gochude oliesuzhi zemin gojiolune. ");
INSERT INTO sce_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Eneshi tendunni keitou wo.\" ");
INSERT INTO sce_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","\"Hhe shihoude kunla tai barei echidene heizhi alane. Mii yenyinghala go minzula tai henjine. ");
INSERT INTO sce_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Hhe shihoude olon kunla jiomunni bendane. Nieniene ghudanduzhi henjindune. ");
INSERT INTO sce_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Olon jia xienzhila khizhedene olon kunlai miine. ");
INSERT INTO sce_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mouxienni olodozhi kunlai oreku zhughe widane. ");
INSERT INTO sce_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ingieliuzhe rennai giezhi zuihou kusanlai jiuine. ");
INSERT INTO sce_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Asiman gojiani gouxioxini qienxiade chonji kurughazhi soyuji minzulade ganzhen beidene caigie duya baraku kuzhene.\" ");
INSERT INTO sce_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","\"Ingiese Danyili xienzhi kieliesan hhe pohai giezhi hanzhan gieghaku zhiguitu oronde beisei ta chanlane. (Onshichen kunla, ene kielienni isii dunjirekuni wo.) ");
INSERT INTO sce_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ingiekude Yudayade sousan kunla, ulade piile echi. ");
INSERT INTO sce_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Gie jieredula, giederase dunxi agile bu bouzhe. ");
INSERT INTO sce_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ghazha jieredula, khareizhi jienne agile bu echi. ");
INSERT INTO sce_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Hhe udude kewosi laisan, gogoghasanlade gou widawo. ");
INSERT INTO sce_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ta holukude uncha, hhamuraku udui bu kuzhegha giezhi onxian gie. ");
INSERT INTO sce_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ingiekushi hhezighan udude zeinan zui fugie wo. Duya kaishi giesanse eli kutula imutu zeinan uwo, khuinashiye uwo. ");
INSERT INTO sce_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Hhezighan zeinantu udui ese choghonshighazhoshi nieda jiui danema, sunghusan kunladene oluzhi choghonshighane. ");
INSERT INTO sce_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Hhe udude kunla tande uzhe, Mexiha enende wo, hhende wo giese ta xianxin bu gie. ");
INSERT INTO sce_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Jia Mexiha, jia xienzhila khizhezhi fugie ghudureqi, fugie shiqinlai giekushi sunghusanlaiye kenen miine. ");
INSERT INTO sce_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Uzhe, bi shiqinlai tande eqie kieliewo. ");
INSERT INTO sce_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ingiese kunla tande uzhe, 'Mexiha hontande wo.' giezhi kieliese ta khizhi bu echi. Pse, 'Uzhe, hhe giedera wo.' giezhi kieliese ta xianxin bu gie. ");
INSERT INTO sce_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Shanjien dunmiense khizhezhi ximiende zhouiku mutun Kunnikewon irekudeye ingiene. ");
INSERT INTO sce_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Fugusan dunxi khalashi inye khala wo.\" ");
INSERT INTO sce_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","\"Hhezighan zeinanni udu jian daose naran kharalane. Sara gon ulie faine. Hodunla asiman jierese anda bouzhene. Asimanyi lilianla gojiolune. ");
INSERT INTO sce_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ingiekude Kunnikewonyi zunji asiman jiere khizhene. Zemin jieredu minzula man wilane. Hhela Kunnikewon nenli, famanude olien jiere irekui chanlane. ");
INSERT INTO sce_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Laba fugiede tunguliese Kunnikewon qienxienlane peizhi asiman enemanse hhemande kutula sunghusan kunlane simiense uruzhi hhantulaghane.\" ");
INSERT INTO sce_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","\"Ta uhuago mutunyi bilasei suru. Mutun niazi faizhi lachen keise khaluncha orokui ta mejiene. ");
INSERT INTO sce_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Taye niekielien wo. Ta ene shiqinla fashen giesei man chanlase hhe shihou chadashizhi shida kuzhesei mejiene. ");
INSERT INTO sce_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Bi tande shuhua kielieye, ene idaini kunla fugutula ene shiqinla man gholune. ");
INSERT INTO sce_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Asiman, zemin widaliuzhe mii kielien kenjin ulie widane.\" ");
INSERT INTO sce_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","\"Hhe udu, hhe shihouni kiema ulie mejiene. Asiman jieredu qienxienlaye ulie mejiene. Kewonye ulie mejiene. Zinie Ada mejiene. ");
INSERT INTO sce_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nuhhani xienzide matugiezhoshi Kunnikewon irekudeye qingiene. ");
INSERT INTO sce_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Hunshuise melieshidaku hhe xienzide kunla ijiezho, ochizho, bierei agizho, dafalazhi izhi Nuhha chon sudoro oroku hhe udude kuruwo. ");
INSERT INTO sce_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Yamai mejie dakude hunshui iredene kunlai man tou yolawo. Kunnikewon irekudeye ingiene. ");
INSERT INTO sce_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Hhe shihoude ghua kun ghazha jiereshi niei uduru echine, niei jiene. ");
INSERT INTO sce_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ghua bierei qieman sidase niei uduru echine, niei jiene. ");
INSERT INTO sce_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ingiese ta jinxin gie. Tai Ezhan yan xienzide irekui ulie mejiene. ");
INSERT INTO sce_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ta enei mejie, giei ezhan ghughei yan xienzide irekui mejiese jinxin giezhi giedene ulie oroghane. ");
INSERT INTO sce_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ingiese ta goude zhunbei giendu, ta mejie dakude Kunnikewon irene.\" ");
INSERT INTO sce_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","\"Qinse kienshi kekaotu jienzha hoji wo? Zhanguijini hhende giededu hojilai, ijiekulani man gonjighasan pushonu? ");
INSERT INTO sce_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Zhanguiji irekude hoji ingiezhi giesei chanlase hhe hojide fuqi wine. ");
INSERT INTO sce_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Bi tande shuhua kielieye, zhanguiji hhende caichanlane man gonjighane. ");
INSERT INTO sce_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Hhe doghun hoji zhughedene sumulazhi mini zhanguiji deigo ulie irene gie, ");
INSERT INTO sce_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","psedu hojilai eghizhi sudosan kunlare ochizhi ijiese, ");
INSERT INTO sce_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","hhe sumula daku udu, mejie daku shihoude zhanguijini iredene ");
INSERT INTO sce_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","hhei sidasunyi qiuizhi jiazhon giesan kunlare hhantu faise hhende shidunne zhouzhi wilane.\" ");
INSERT INTO sce_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","\"Hhe shihoude asiman gojia hoxian hharan shini bierei zhula bareidene shini khughonyi jienliekui xianli. ");
INSERT INTO sce_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Hhelai dunda tawun benni, tawun jienzhani wo. ");
INSERT INTO sce_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Tawun bennila zhula bareidene tosun ese bareizho. ");
INSERT INTO sce_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Tawun jienzhanila zhula bareidene hulude tosun bareizho. ");
INSERT INTO sce_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Shini khughon udazhi da ese irese hhela man nokuzhi kijie hhunturawo. ");
INSERT INTO sce_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Banyedei kunla waradazho, 'Bosizhendu! Shini khughon irewo! Ghujighan jienliele khizhendu!' ");
INSERT INTO sce_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Shini biereila man bosizhedene zhulalane zhendunlawo. ");
INSERT INTO sce_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Bennila jienzhanilade kieliewo, 'Tosunsene gouji ogi, zhulabijienyi xiniene giezho.' ");
INSERT INTO sce_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Jienzhanila kieliewo, 'Ulie olune. Manlade injizhi ulie kurune. Ta huisan kunlase agile echi.' ");
INSERT INTO sce_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Hhela agile echikude shini khughon irewo. Zhunbei gie goudaghasanla shini khughonre hhantu ghurunde echise wijienyi khawo. ");
INSERT INTO sce_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Khuinashi psedu shini biereila iredene kieliewo, 'Ezhan, Ezhan, bijiende wijienyi nieya!' ");
INSERT INTO sce_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Shini khughon kieliewo, 'Bi tande shuhua kielieye, bi tai tani dane.' ");
INSERT INTO sce_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ingiese ta jinxin gie, hhe udu, hhe zhuntouni ta ulie mejiene.\" ");
INSERT INTO sce_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","\"Asiman gojia hoxian nie kun gholode echine giezhi hojilane uruzhi ire baerne hhelade jiuizhi gonjighakui xianli. ");
INSERT INTO sce_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Zhao hhelai benshizhe niede 500 antan, niede 200 antan, niede 100 antan ogidene gholode echiwo. ");
INSERT INTO sce_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","500 linlasan deigo echidene meimei giezhi 500 zhenjiwo. ");
INSERT INTO sce_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","200 linlasanye 200 zhenjiwo. ");
INSERT INTO sce_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","100 linlasan echidene zeminde oko wai ezhanne baerni niuighawo. ");
INSERT INTO sce_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Hende oloncha beidene ezhanni ire hhelase zhan sanazho. ");
INSERT INTO sce_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","500 linlasan ezhanne shida ire zhenjisan 500 ne bareizhi kieliewo, 'Ezhan, chi made 500 ogiwo. Uzhe, bi pse 500 zhenjiwo.' ");
INSERT INTO sce_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ezhanni kieliewo, 'Giesan gou wo. Chishi gou, kekaotu hoji wo. Ga shiqinde shixinji giezho, bi chii olon shiqinlai gonjighane. Ezhanghalane hhantu bayasu.' ");
INSERT INTO sce_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","200 linlasan ire kieliewo, 'Ezhan, chi made 200 ogiwo. Uzhe, bi pse 200 zhenjiwo.' ");
INSERT INTO sce_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ezhanni kieliewo, 'Giesan gou wo. Chishi gou, kekaotu hoji wo. Ga shiqinde shixinji giezho. Bi chii olon shiqinlai gonjighane. Ezhanghalane hhantu bayasu.' ");
INSERT INTO sce_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","100 linlasan ire kieliewo, 'Ezhan, chishi jiafatu kun bikui bi mejiene. Ese tareisan oronse ghurane, ese shizhisan oronse hhantulaghane. ");
INSERT INTO sce_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Bi ayizhi echidene chii 100 ni zeminde niuighawo. Uzhe, chii miengu enende wo.' ");
INSERT INTO sce_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ezhanni hhende kieliewo, 'Chi ene doghun, langantu hoji, bi ese tareisan oronse ghurane, ese shizhisan oronse hhantulaghakui chi mejiese ");
INSERT INTO sce_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","mii baerni inhande jiekuni wo, bi irekude benqien lixiji agi khizhene. ");
INSERT INTO sce_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ta hhei baerlani agi echidene hhe 1000 bisande ogi. ");
INSERT INTO sce_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Bichen kunlade pse olon ogizhi feilieghane, wichen kunlase bisanlainiye agi echine. ");
INSERT INTO sce_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ene yama zoin witu hojini ghadanedu kharanide benda. Hhende shidunne zhouzhi wila gie!'\" ");
INSERT INTO sce_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","\"Kunnikewon qienxienlare man hhantu goya fama dunda irekude hhe famatu baozo jierene soune. ");
INSERT INTO sce_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Duyani soyuji minzulai hhei melie hhantulaghazhi hhe hhelai fenji keighane. Hoxian ghoni adulachen ghoni, imanyi fenji keighakui xianli. ");
INSERT INTO sce_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ghonilai borun miendene teine, imanlai soghei miendene teine. ");
INSERT INTO sce_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ingie honshan borun mienne kunlade kieliene, 'Adami fuqi ogisan kunla, irendu. Duyai zhayaghazhi iresanse tande zhunbei giesan gojiani jienliendu. ");
INSERT INTO sce_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Bi oliesukude ta made ijieghazho, undasukudei made ochighazho. Bi chumen giekude ta mii soughazho. ");
INSERT INTO sce_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Bi hulan muchughun bikude ta made musighazho. Bi giemerekude ta mii ushilazho. Bi bafanzideshi ta mii uzhele irezho.' ");
INSERT INTO sce_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Gou kunla kieliene, 'Ezhan, bijien yan xienzide chi oliesusei chanladene chade ijieghazhi undasusei chanladene chade ochighawo? ");
INSERT INTO sce_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Yan xienzide chumen giesei chanladene chii soughazhi hulan muchughun bikude chade jien musighawo? ");
INSERT INTO sce_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Pse chi yan xienzide giemeresei chanladene ushilazhi bafanzideshi chii uzhele irewo?' ");
INSERT INTO sce_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Honshan kieliewo, 'Bi tande shuhua kielieye, ta enezighan mii gaijiu dunda zui ganide oluzhi giese made oluzhi giezho.'\" ");
INSERT INTO sce_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","\"Ingie honshan soghei mienne kunlade kieliene, 'Ta ene kharasan kunla, yola. Ibilisi, Ibilisii hojilade zhunbei giesan ulie xinieku khande oro! ");
INSERT INTO sce_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Bi oliesukude ta made ese ijieghazhi undasukude made ese ochighawo. ");
INSERT INTO sce_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Bi chumen giekude ta mii ese soughawo. Bi hulan muchughun bikude made ese musighawo. Bi giemerekude ta mii ese ushilazhi bafanzideshi ta mii uzhele ese irewo.' ");
INSERT INTO sce_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Hhelaye kieliene, 'Ezhan, bijien yan xienzide chi oliesusei, undasusei, chumen giesei, hulan muchughun bikui, giemeresei, bafanzide bikui chanlazhi ese banman giewo?' ");
INSERT INTO sce_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Honshan kieliene, 'Bi tande shuhua kielieye, ta enezighan kun dunda zui ganide ese oluzhi giese made oluzhi ese giezho.' ");
INSERT INTO sce_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Enezighan kunla chanqi faikude orone, gou kunla chanqi amitukude orone.\" ");
INSERT INTO sce_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ersa enezighan kielienlai man kielie baragha tujiladene kieliewo, ");
INSERT INTO sce_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","\"Pse ghuarudushi Jiulidaosan Jiei ta mejiene. Kunnikewonyi kunlade jiuidene shizijia jiere ghadazhi fugughane.\" ");
INSERT INTO sce_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Qingiekude fugie buwa, bexinlani zhanlaola Gaiyafa giezhi urusan zui fugie buwai ghoronde hhantulazho. ");
INSERT INTO sce_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Hhela piendaku banfaghala Ersai bareidene alane giezhi shanlian giezho, ");
INSERT INTO sce_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","\"Jieqii udude ulie olune, bexinla londane.\" ");
INSERT INTO sce_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ErsaBodanide pifugientu Ximunyi giede bikude ");
INSERT INTO sce_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","nie bierei ishighala giesan huapinde guizhuntu xianshuini hhei shida agizhi ire Ersa ijiezhi soukude qiorun jiereni kiewo. ");
INSERT INTO sce_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tujila chanladene hokuzhi kieliewo, \"Ingiezhi lanfei giezhi yangiene? ");
INSERT INTO sce_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ene xianshuini olon baer huidene nanxin kunlade ogikui wo.\" ");
INSERT INTO sce_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ersa hhelai isii mejiedene kieliewo, \"Ene biereide chijia teizhi yangiene? Hhe made nie gou shiqin giewo. ");
INSERT INTO sce_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nanxin kunla tanre chan hhantu woma, bi chan hhantu uwo. ");
INSERT INTO sce_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ene bierei xianshuini mii jiere kiekushi mii bulakude zhunbei giezho. ");
INSERT INTO sce_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Bi tande shuhua kielieye, ene gouxioxini chonjizhi qienxiade kutula ene bierei gieseiye kieliezhi jilane.\" ");
INSERT INTO sce_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ingiedene 12 gie tuji dundadu Jialie kun Yuda giesan tuji fugie buwalai hhende echi kieliewo, ");
INSERT INTO sce_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","\"Bi hhei tande bareighase ta made yan ogine?\" Hhela 30 gie miengu ogiwo. ");
INSERT INTO sce_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Hhe shihouse YudaErsai ghudanduku jihui ereizho. ");
INSERT INTO sce_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tanmien Jieni tou 1 qiende tujila Ersai shida ire asawo, \"Bijien Jiulidaosan Jieni xini chade khala zhunbei giene?\" ");
INSERT INTO sce_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Hhe kieliewo, \"Ta chenshini nie kunyi hhende echidene kielie, 'Loushi kieliezho, \"Mii shihou ghujinlazho. Bi tujilarene chii giede Jiulidaosan Jieni daoghane.\"'\" ");
INSERT INTO sce_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tujila Ersa kieliesan mutun echidene Jiulidaosan Jieni zhunbei giewo. ");
INSERT INTO sce_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Khara oluse Ersa 12 gie tujirene hhantu xi souzho. ");
INSERT INTO sce_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Hhela ijiekude Ersa kieliewo, \"Bi tande shuhua kielieye, tai dunda nie kun mii ghudandune.\" ");
INSERT INTO sce_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Hhela hende munan giedene Ezhan, bi pushoba giezhi nienieji asa qiiwo. ");
INSERT INTO sce_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ersa kieliewo, \"Mare hhantu jiezise zhanjizhi ijiesan kun mii ghudandune. ");
INSERT INTO sce_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Kunnikewon jinwun jiere huaisan mutun fugunema, hhei ghudandusan kunde gou widawo! Hhe kunyi ese oluzhoshida gou wo.\" ");
INSERT INTO sce_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ersai ghudandusan Yuda hhende asawo, \"Loushi, bi pushoba?\" Ersa kieliewo, \"Chi enbene, goyane kieliewo.\" ");
INSERT INTO sce_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Hhela ijiekude Ersa ginanyi barei onxian giedene ghulu, tujilade ogi kieliewo, \"Ta bareidene ijie. Eneshi mii beye wo.\" ");
INSERT INTO sce_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pse beizii barei mafan kieliedene hhelade ogi kieliewo, \"Ta man enei ochi. ");
INSERT INTO sce_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Eneshi olon kunlai zuini mienliene giezhi usurusan bi yenjisan chusun wo. ");
INSERT INTO sce_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Bi tande kielieye, bi pse ene putoujiuni ulie ochizhi adaimi gojiade tanre hhantu shinii ochiku hhe udu kune.\" ");
INSERT INTO sce_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Hhela douladene khizhe Ganlanshande echiwo. ");
INSERT INTO sce_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ingiedene Ersa tujiladene kieliewo, \"Ene xii ta man mii bendane. Jinwun jiere kieliezho, 'Bi yanbashii eghi unaghase ghonila sandane.' ");
INSERT INTO sce_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ingieliuzhe bi aminne oludene tanse melie Jialilide echine.\" ");
INSERT INTO sce_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ingiese Beduru kieliewo, \"Kunla man chii bendaliuzhe bi jiedui ulie bendane!\" ");
INSERT INTO sce_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ersa hhende kieliewo, \"Bi chade shuhua kielieye, ene xii tigha kheilatula chi mii 3 hui ulie renjine.\" ");
INSERT INTO sce_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Beduru kieliewo, \"Bi chare hhantu fuguliuzhe chii tani dane giezhi ulie kieliene!\" Tujilaye man qingiezhi kieliezho. ");
INSERT INTO sce_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ersa tujilare nie Keximani giesan oronde ire tujilade kieliewo, \"Ta enende sou, bi hhemiende onxian giele echine.\" ");
INSERT INTO sce_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ErsaBeduru, Xibitaini ghua kewonni uduruzhi echiwo. Ingie yuchou giezhi nango gie qii ");
INSERT INTO sce_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","hhelade kieliewo, \"Mii zhughede nango giezhi fugukui xianli. Ta enende sagheizhi mare hhantu jinxin gie.\" ");
INSERT INTO sce_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Hhe goujinie melie yodene zemin jiere papala onxian giezhi kieliewo, \"Mii ada, olu shidase ene shouku giekui made bu iregha! Ingieliuzhe mii duranghala bu gie, chii duranghala gie.\" ");
INSERT INTO sce_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ersa tujilai hhende irese hhela hhunturasei chanladene Bedurude kieliewo, \"Ta mare nie zhuntouye jinxin gie danu? ");
INSERT INTO sce_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Jinxin giezhi onxian gie, pse miine. Tai zhughede duran winema, beyetai zholien wo.\" ");
INSERT INTO sce_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ingie pse erchan likai giedene onxian giezhi kieliewo, \"Mii ada, ene kuni bi ulie shouizhi ulie oluse, chi duranghalane gie.\" ");
INSERT INTO sce_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pse irese hhela hhunturasei chanlawo. Hhela nokuzhi nudunne nie dazho. ");
INSERT INTO sce_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ersa pse hhelase likai gie ji 3 hui onxian giele echiwo. Kieliesan kielien melieshidakughala niekielien wo. ");
INSERT INTO sce_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ingie tujilai hhende ire hhelade kieliewo, \"Ta dou hhunturazhi hhamuranu? Uzhe, shihou kuzhewo. Kunnikewonyi zuirenlai khade ghudanduwo. ");
INSERT INTO sce_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Bosizhe, matan yoye. Uzhe, mii ghudandusan kun irewo.\" ");
INSERT INTO sce_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ersa zhen kieliekude 12 gie tuji dundadu Yuda fugie buwa, bexinlai zhanlaola peisan idaban banban, khudogho bareisan kunlare hhantu irewo. ");
INSERT INTO sce_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ersai ghudandusan kun hhelade nie jihao kieliezho, \"Bi kiende orese kien enbene. Ta hhei barei.\" ");
INSERT INTO sce_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yuda dei Ersai shida echi loushi, salan giedene orewo. ");
INSERT INTO sce_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ersa hhende kieliewo, \"Zhanlien, chi giele iresan shiqinne gie.\" Ingiese hhela melie ire Ersai bareiwo. ");
INSERT INTO sce_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ingiekude Ersare hhantuku nie kun khudoghoi lai khizhe zui fugie buwai hojii nie chighinyi chizhi agiwo. ");
INSERT INTO sce_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ersa hhende kieliewo, \"Khudoghone xiuzide orogha. Kien khudogho gojiolughase khudogho doura fugune. ");
INSERT INTO sce_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Bi Adane xiahua giese hhe made deigo 12 gie buduitonse da olon qienxienyi ireghakui chi mejie dazhou? ");
INSERT INTO sce_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Qingiese bixi fashen giene giezhi kieliesan jinwunlani matugie gholughane?\" ");
INSERT INTO sce_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Hhe shihoude Ersa kunlade kieliewo, \"Ta khudogho, banbanlai bareidene mii qiandao mutun bareile irewu? Niudunie bi mechide soudene sughase ulie bareine. ");
INSERT INTO sce_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Enela man fashen giekushi xienzhini shu jieredu kielienyi gholughane giezho.\" Ingiekude tujila man Ersase likai gie holu widawo. ");
INSERT INTO sce_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ersai bareisan kunla Ersai zui fugie buwa Gaiyafai hhende lai echiwo. Hhende jinwun hanjia, zhanlaola hhantulazho. ");
INSERT INTO sce_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Beduru gholose daghazhi zui fugie buwai ghoronde orodene wijien sagheisan kunlare hhantu souzhi ene shiqin matui gholukui uzhezho. ");
INSERT INTO sce_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Fugie buwa, zui fugie fayenni soyuji kunla man jia ganzhen ereizhi Ersai alane giezho. ");
INSERT INTO sce_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Olon kunla khizhezhi jia ganzhen beizhoma, zhenji erei dazho. Zuihoude ghua kun ire kieliewo, ");
INSERT INTO sce_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","\"Ene kun orun mechii cheidene ghurudude gie khigha shidane giezhi kieliezho.\" ");
INSERT INTO sce_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Zui fugie buwa bosizhedene Ersade kieliewo, \"Ene kunla ganzhen beizhi zhasande chi yama huida ulie gienu?\" ");
INSERT INTO sce_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ersa shenqi ese khizhezho. Zui fugie buwa kieliewo, \"Chanqiku Hudade bi chii fayen gieghaye. Chishi Mexiha, Hudai kewon enbese bijiende kielie.\" ");
INSERT INTO sce_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ersa hhende kieliezho, \"Chi goyane kieliezho. Ingiezhoma bi tande kielieye, Ta enedu khuinashi Kunnikewon Nenlitu Hudai borun miende sousei, pse asimanni olien jierese irekui chanlane.\" ");
INSERT INTO sce_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Zui fugie buwa jienne sida keigha kieliewo, \"Hhe kufurei fanjiwo! Matan pse yan ganzhen beiku kun kerene? Hhe kufurei fanjisei ta jian chenliewo. ");
INSERT INTO sce_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ta kieliese matugiene?\" Hhela kieliese sixin panjikuni wo giezho. ");
INSERT INTO sce_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Hhela ungie jiereni nunpuzhi chuidazho. Niezhanla hhaghadazhi kieliezho, ");
INSERT INTO sce_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","\"Mexiha, chii kien eghisei bijiende nie kielie.\" ");
INSERT INTO sce_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ingiekude Beduru ghadanedu ghoronde souzho. Nie hoji oqin hhei melie iredene kieliewo, \"Chiye Jialilini Ersare hhantuku wo.\" ");
INSERT INTO sce_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Beduru dajialai melie ese renjizhi kieliewo, \"Chi yan kieliesei bi ulie mejiene.\" ");
INSERT INTO sce_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Hhe wijien shida echise da nie hoji oqin chanladene hhendedu kunlade kieliewo, \"Ene kunshi Nasale kun Ersare hhantuku wo.\" ");
INSERT INTO sce_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Beduru pse ese renjidene fayen giezhi kieliewo, \"Bi hhe kunyi tani dane.\" ");
INSERT INTO sce_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Goujicha beidene shidani beisan kunla Bedurui melie ire kieliewo, \"Chi kenjinshi hhelare hhantuku kun wo. Chii kouin chii mejieghawo.\" ");
INSERT INTO sce_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Beduru fayen giezhi khara qiiwo, \"Hhe kunyi bi tani dane!\" Deigo tigha kheilawo. ");
INSERT INTO sce_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","BeduruErsa kieliesan tigha kheilatula chi mii 3 hui ulie renjine giesei sumula ire, khizhi echidene nango giezhi hende wilawo. ");
INSERT INTO sce_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Eqiemagha oluse fugie buwa, bexinlani zhanlaola man shanlian giezhi Ersai alane giezho. ");
INSERT INTO sce_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Hhela Ersai banladene laizhi Bilado shenzhande jiuiwo. ");
INSERT INTO sce_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ersani ghudandusan YudaErsade zui jinjisei chanladene houhui giezho. Hhe 30 gie mienguni fugie buwa, zhanlaolade khareizhi ogidene kieliewo, ");
INSERT INTO sce_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","\"Bi hanhanji kunyi ghudanduse made zui wo.\" Hhela kieliewo, \"Eneshi chii shiqin wo. Bijienre yan gonxi wo?\" ");
INSERT INTO sce_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yuda miengui mechide benda jiedene khizhi echi jiuzhilie fuguwo. ");
INSERT INTO sce_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Fugie buwala miengui qiangudene kieliezho, \"Eneshi chusun qien wo. Mechini kufande teizhi ulie olune.\" ");
INSERT INTO sce_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Hhela shanlian giedene hhe baerghala gan giesan kunyi ghazhai agizhi niman kunyi meza giewo. ");
INSERT INTO sce_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ingiese eli kutula hhe ghazhai chusun ghazha giezho. ");
INSERT INTO sce_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ingiese Ezhan Yelimi xienzhii tungo giezhi kieliesan kielien mutun gholuwo, \"Hhela Isilie kun hhei aminde jinjisan 30 gie miengughala ");
INSERT INTO sce_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","gan giesan kunyi ghazhai agiwo. Eneshi Huda made fenfulasan wo.\" ");
INSERT INTO sce_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ErsaBilado shenzhanni melie beizho. Shenzhan hhende asawo, \"Chishi Yutai kunni honshan onu?\" Ersa kieliewo, \"Chi kieliezho.\" ");
INSERT INTO sce_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Fugie buwa, zhanlaola hhei zhase hhe yama ulie kieliene. ");
INSERT INTO sce_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ingie Bilado asawo, \"Hhela chii imegheni zhase chi ese sonosuzhou?\" ");
INSERT INTO sce_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ersa nie amanda huida ese giese shenzhan hende ghanirazho. ");
INSERT INTO sce_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Niefanie ene jieqide shenzhan bexinla keresan mutun nie fanren andaghaku xigon wine. ");
INSERT INTO sce_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Hhe shihoude nie chumin giesan fanrenni Balaba giene. ");
INSERT INTO sce_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kunla hhantulakude Bilado hhelade kieliewo, \"Bi tande aliniei andagha? Balaba onu, Mexiha giesan Ersa wo?\" ");
INSERT INTO sce_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Hhela Ersai dubiliezhi hhende jiuizhi ogisei hhe mejiedene ingiezhi asazho. ");
INSERT INTO sce_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Hhe shenpantai jiere soukude biereini kun peizhi iregha kieliewo, \"Chi ene gou kunni shiqinyi goujida bu gonji. Ene xii mii zhoujinde hhei yenyin jiere bi hende munan giezho.\" ");
INSERT INTO sce_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Fugie buwa, zhanlaola bexinlai shanjizhi Balabai andagha, Ersai ala giezho. ");
INSERT INTO sce_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Shenzhan hhelade kieliewo, \"Bi ene ghualase tande aliniei andagha?\" Hhela kieliewo, \"Balaba wo!\" ");
INSERT INTO sce_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Bilado kieliewo, \"Qinse Mexiha wo giesan Ersai bi matugiene?\" Hhela man kieliewo, \"Hhei shizijia jiere ghada!\" ");
INSERT INTO sce_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Bilado kieliewo, \"Yangiezhi? Hhe yan doghun shiqin giewo?\" Hhela pse hende waradazhi kieliewo, \"Hhei shizijia jiere ghada!\" ");
INSERT INTO sce_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Bilado uzhese goya kieliesan yama oronde uwo, kharei londakui xianli. Ingie bexinlai melie usu agizhe, khane wagha kieliewo, \"Ene kunni chusun usurusan zui mii jiere uwo. Ta goyalane danji.\" ");
INSERT INTO sce_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Bexinla man hhantu kieliezho, \"Hhei chusun bijien, bijienyi houdeini jiere ire gie!\" ");
INSERT INTO sce_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ingiese BiladoBalabai andaghawo. Ersai mabienzighala eghidene kunlade jiuizhi shizijia jiere ghada giezho. ");
INSERT INTO sce_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Shenzhanni buduila Ersai laizhi shenzhan sousan oronde echi, nie tonni buduilai man hhei shida hhantulaghawo. ");
INSERT INTO sce_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Hhela Ersai jienyi teighadene dahun fudu jienyi musighawo. ");
INSERT INTO sce_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Eghesunyi honshan zhoku maghalai onjidene qiorun jierei zhoghasenu borun khadei ghulusunyi bareighadene meliei xiutuliezhi Yutai kunni honshan, onsui giezhi xilun giezho. ");
INSERT INTO sce_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Hhei jiere nunpuzhi qiorun jierei ghulusunghala eghizho. ");
INSERT INTO sce_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Xilun gie balu, fudu jienyi teigha, jienyini musighadene lai shizijia jiere ghadale echiwo. ");
INSERT INTO sce_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Hhela khikude Gulinaini nie Ximun giesan kunyi penjidene ninkounin Ersai shizijiai beilieghawo. ");
INSERT INTO sce_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Gegeta giesan nie oronde kuruwo. Gegetani isishi qiorun yasun oron wo. ");
INSERT INTO sce_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Buduila kudanni jiude huigha Ersade ochighase goujinie ochi ese ochiwo. ");
INSERT INTO sce_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Hhela Ersai shizijia jiere ghadadene fendan qianguzhi jienyini ghughasenu ");
INSERT INTO sce_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","hhende souzhi uzhezho. ");
INSERT INTO sce_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Peizi jiere eneshi Yutai kunni honshan Ersa wo giezhi zuinini huaidene qiorun qiendei guaiwo. ");
INSERT INTO sce_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ingiedene hhere hhantu ghua qiandaoi shizijia jiere niei borun miende niei soghei miende ghadawo. ");
INSERT INTO sce_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Hhense yozhi daosan kunla sugiezhi qiorunne shuiqizhi kieliezho, ");
INSERT INTO sce_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","\"Chi mechii cheise ghurudude gie khighane giesan, chi Hudai kewon enbese goyane jiuizhi shizijia jierese bouzhesha!\" ");
INSERT INTO sce_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Fugie buwa, jinwun hanjia, zhanlaolaye ingiezhi uzhezhi xiniezhi kielienduzho, ");
INSERT INTO sce_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","\"Hhe kunlai jiuiwo, goyane jiui dane. Hheshi Isilieni honshan wo. Ede shizijia jierese bouzhe giema, bijien xianxin gieye. ");
INSERT INTO sce_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Hhe Hudai kouizho, dou orunshi Hudai kewon wo giezho. Qinse Huda duran bise ede hhei jiui gie!\" ");
INSERT INTO sce_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Hhantu ghadasan qiandaolaye ingiezhi sugiezho. ");
INSERT INTO sce_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Zhunwuse xiawu 3 jien olutula zemin man kharalazho. ");
INSERT INTO sce_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Chabudu 3 jien oluse Ersa fugiede, \"Ili, Ili, lamasabagedani?\" giezhi waradazho. Isishi, \"Mii Huda, mii Huda, chi mii yangiezhi ulie gonjine?\" giezho. ");
INSERT INTO sce_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Hhende beisan niezhan kunla chenliedene kieliezho, \"Ene kun Iliyani waradazho.\" ");
INSERT INTO sce_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Hhelai dundadu nie kun deigo holu echi, haimiende cui zhanji ghulusun jiere banla hhende ughawo. ");
INSERT INTO sce_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Psedu kunla kieliezho, \"Gouji saghei, matan Iliya hhei jiuile irenu ulie irekui uzheye.\" ");
INSERT INTO sce_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ersa pse fugiede nie warada, ho sirawo. ");
INSERT INTO sce_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Zhen ingiekude dajienni sudorodu menlienzi jierese doura kei echidene ghua gholuwo. Zemin gojioluzhi tashila ghaluwo. ");
INSERT INTO sce_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mezala keizhi olon duya ijiesan shentulai beyela aminne oluwo. ");
INSERT INTO sce_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ersa aminne oludene hhela mezase khizhezhi zhiguitu chenshi Yelusalende oro, olon kunlade chujiegheghawo. ");
INSERT INTO sce_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Baifuzhan, pse hhere hhantu Ersai sagheisan kunla zemin gojiolusan, psedu shiqinlai chanladene hende ayizhi, \"Ene kunshi zhenzhenji Hudai Kewon enbene.\" giezhi kieliezho. ");
INSERT INTO sce_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Hhende Jialilise Ersai daghazhi ushilasan olon biereila gholose uzhezho. ");
INSERT INTO sce_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Hhelai dunda Modalani Mereiyen, YagebuYusufu ghualai anani Mereiyen, Xibitaini kewonlai anani wo. ");
INSERT INTO sce_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Khara oluse Yalimataini Yusufu giesan nie bayan kun irewo. Hheshiye Ersai tuji wo. ");
INSERT INTO sce_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ene kun Biladoi hhende echidene Ersai beyeni xiahua giezhi kerewo. Ingie Bilado ogi giezhi fenfulawo. ");
INSERT INTO sce_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusufu beyeni agi bouzhe, ganjin boside boui goudaghawo. ");
INSERT INTO sce_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Tashide waisan goya shini mezadene teiwo. Pse fugie tashii ghoghoreighazhi meza kouzii duighadene likai giewo. ");
INSERT INTO sce_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Hhende Modalani Mereiyen, da nie Mereiyenghala mezai duimiende souzho. ");
INSERT INTO sce_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Khuichudushi hhamuraku udu wo. Fugie buwa, Falisai kunla Biladoi hhende hhantuladene kieliewo, ");
INSERT INTO sce_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","\"Noyen, bijien jilase kunlai piendasan hhe kun ese fugukudei ghurudushi aminne olune giezhi kieliezho. ");
INSERT INTO sce_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Chi ghurudu olutula mezai uzhezhi goudagha giezhi fenfula. Pse tujilani ghula echizhi bexinlade, 'Hhe fugudene aminne oluwo.' giezhi kieliene. Ingiese kun piendaku melieshikuse pse hendane.\" ");
INSERT INTO sce_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Bilado kieliewo, \"Ta buduilai uduru echi. Jinlianji uzhezhi goudagha.\" ");
INSERT INTO sce_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Hhela echi meza kouzini tashii fenjidene buduilade goude uzheghawo. ");
INSERT INTO sce_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Hhamuraku udu daozhi xinqini ogheikude Modalani Mereiyen da nie Mereiyenghala mezai uzhele irewo. ");
INSERT INTO sce_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Menzhali zemin hende gojiolukushi Ezhanyi qienxien asiman jierese bouzhe tashii ghoghorei daogha jierei souzho. ");
INSERT INTO sce_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Hhei yanzini gieghande gon faisei xianli, jienni chighande zhansunyi xianli. ");
INSERT INTO sce_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Mezai sagheisan kunla ayizhi pugharadene fugusan kun mutun gholuwo. ");
INSERT INTO sce_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Qienxien biereilade kieliewo, \"Bu ayi! Ta shizijia jiere ghadasan Ersai ereisei bi mejiene. ");
INSERT INTO sce_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Hhe enende uwo. Hhe kieliesan mutun aminne oluwo. Hhe kijiesan oronni ta uzhele ire. ");
INSERT INTO sce_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ta ghujighan echidene tujiladeni hhe fugusan kun dundase aminne oluwo. Tanse melie Jialilide echine. Ta hhende hhei chanlane giezhi kielie. Uzhe, bi tande kieliesei jila.\" ");
INSERT INTO sce_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Biereila jindazhi mezase khizhe, hende bayasuzhi ayidene holuzhi tujiladeni kieliele echiwo. ");
INSERT INTO sce_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Menzhali Ersa hhelai penji, \"Ta gou onu?\" giezhi kieliezho. Hhela shidani echi konsei qioru hhei beiizho. ");
INSERT INTO sce_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ersa hhelade kieliezho, \"Bu ayi! Ta echidene mii gaijiulade Jialilide echi giezhi kielie. Hhela hhende mii ochirane.\" ");
INSERT INTO sce_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Biereila echikude giedun uzhesan buduila chenshide echi, fashen giesan shiqinlai fugie buwalade man kieliewo. ");
INSERT INTO sce_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Fugie buwa zhanlaola hhantulazhi shanlian giedene buduilade olon baer ogizhi kieliezho, ");
INSERT INTO sce_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","\"Ta 'Bijien xieni kijiekude tujilani ire hhei beyeni ghula echiwo.' giezhi kielie. ");
INSERT INTO sce_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ene kielien shenzhanyi chighinde echise bijien hhende kieliezhi tai yama bu gieghaye.\" ");
INSERT INTO sce_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Buduila baerni jienliedene hhela fenfulasan mutun giewo. Ene kielien Yutai kunyi dunda chonjizhi eli kuzho. ");
INSERT INTO sce_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","11 gie tujila Jialilide echizhi Ersa jinjisan ulade khireiwo. ");
INSERT INTO sce_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Hhela Ersai chujieghedene beiizho, niezhan kunla inxin giezho. ");
INSERT INTO sce_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ersa melie ire hhelade kieliewo, \"Asiman, zemin jieredu qienlilani man made ogiwo. ");
INSERT INTO sce_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ingiese ta echidene soyuji minzuni kunlai Ada, Kewon, Shenlinni niereghala xili gieghazhi tuji gholugha. ");
INSERT INTO sce_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Bi tande fenfulasan soyujilai hhelade sughazhi zunjigha. Uzhe, bi duya baratula tanre chanqi hhantu wo.\"");
INSERT INTO sce_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Hudai kewon Ersa Mexihani gouxioxi ingiezhi kaishi giezho. ");
INSERT INTO sce_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Isaiya xienzhini shu jiere huaizho, \"Uzhe, bi qinsi kunne chii melie peizhi chii moni zhunbei gieghane. ");
INSERT INTO sce_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Hontande nie kun waradazho, 'Ezhanni moni zhunbei gie! Hhei moni zhidagha!'\" ");
INSERT INTO sce_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Zhao ene kielien mutun xili gieghasan Yaheiya hontande irezhi kunlade xili gieghazhi, \"Ta geizhen giendu, Huda tai zuini rouliene.\" giezhi chonjizhi kieliezho. ");
INSERT INTO sce_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yudayani go orondedu kun, Yelusalenyi kunla man Yaheiyai hhende echidene zuine renjizhi Yedanhede Yaheiyase xili jienliezho. ");
INSERT INTO sce_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yaheiya loto noghosunghala giesan jienyi musizhi arasunni pixie pixieliezho. Machazi, shimei ijiezho. ");
INSERT INTO sce_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Hhe chonjizhi kieliewo, \"Mase khuina irechen kun mase nenli fugie wo. Bi ghodeizhi hhende mahei deizi andaghaseye pei dane. ");
INSERT INTO sce_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Bi usughala tai xili gieghazhoma, hhe Shenlinghala tai xili gieghane.\" ");
INSERT INTO sce_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Hhe shihoude ErsaJialilini Nasalese Yedanhede ire Yaheiyase xilii jienliewo. ");
INSERT INTO sce_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ersa dei ususe khizhese asiman keizhi Shenlin ghoghochen mutun goyai jiere bouzhesei chanlawo. ");
INSERT INTO sce_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ingiedene asiman jierese shenqi irezhi kieliewo, \"Chishi bi oresan kewon wo. Bi chade xiqi wo.\" ");
INSERT INTO sce_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Deigo Shenlin Ersai biizhi hontande echighawo. ");
INSERT INTO sce_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Hhe hontande souzhi Ibilisi 40 qien shiizho. Yewolase hhantu wo. Qienxienla ushilazho. ");
INSERT INTO sce_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yaheiyai barei echise ErsaJialilide ire, Hudai gouxioxini chonjizhi kieliewo, ");
INSERT INTO sce_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","\"Udu kuruwo. Hudai gojia chadashiwo. Ta geizhen giezhi gouxioxini xianxin gie.\" ");
INSERT INTO sce_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ErsaJialilihai bienzide yozhi daokude Ximun, Ximunni jiu Andelie haide on xiaisei chanlawo. Hhelashi zhaghasun bareisan kun wo. ");
INSERT INTO sce_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ersa hhelade kieliewo, \"Ta iredene mii dagha. Bi tai zhaghasun bareiku mutun kun bareichen gholughane.\" ");
INSERT INTO sce_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Hhela onni deigo jiedene hhei daghawo. ");
INSERT INTO sce_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ersa melie gouji yodene pse Xibitaini kewon Yagebu, Yagebui jiuni Yaheiyani chanlawo. Hhela chon jiere on huduzho. ");
INSERT INTO sce_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ersa deigo hhelai uruse hhela Xibitai adane, pse guisan kunlai chon jiere jiedene Ersani daghawo. ");
INSERT INTO sce_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Hhela Jiabainunde kudene Ersa hhamuraku udude deigo huitande orozhi kunlade sughazhi kieliezho. ");
INSERT INTO sce_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Chenliesan kunla hhe sughasande ghanirazho. Ersa hhelade sughadan jinwun hanjialai buxian wo, nie qienlitu kunni xianli. ");
INSERT INTO sce_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ingiekude hhelai huitande nie kunni zannan ruhher heizho. Waradazhi kieliewo, ");
INSERT INTO sce_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","\"Nasale kun Ersa, chi bijienyi jiohoro bu gie. Chi bijienyi widaghale irewu? Chishi kien bikui bi mejiene. Chishi Hudase iresan hhe zhiguitu wo!\" ");
INSERT INTO sce_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ersa hhei sugiezhi kieliewo, \"Amanne menji. Ene kunni jierese khizhe!\" ");
INSERT INTO sce_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Zannan ruhher hhe kunni nie tigharagha, fugiede waradadene hhe kunni jierese khizhewo. ");
INSERT INTO sce_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kunla man ghanirazhi nieniedene asazhi kieliezho, \"Eneshi yan shiqin wo? Eneshi nie nenlitu, shini daoli wo. Hhe zannan ruhherde minlin xiaise hhei kielienyi chenliene!\" ");
INSERT INTO sce_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ingie Ersai minshen Jialili oronde man chonji keiwo. ");
INSERT INTO sce_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Hhela huitanse dei khizhe Yagebu, Yaheiyare hhantu Ximun, Andelietai giede echiwo. ");
INSERT INTO sce_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ximunyi ghadunmekieni fashao gie kijiezho. Kunla deigo Ersade kieliewo. ");
INSERT INTO sce_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ersa hhei shida ire khasei feizhi bosighase fashao giesan daowo. Ingiedene ghadunmekieni hhelai ushilazho. ");
INSERT INTO sce_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Khara oluse kunla yanyanji giemeresan kun, sheitan heisan kunlai man Ersai shida uduru irewo. ");
INSERT INTO sce_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Chenshini kunla man wijien konde hhantulazho. ");
INSERT INTO sce_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ersa olon gientulai goudaghawo. Olon sheitanlai tou khighawo. Hhe sheitanlai kielien ese kielieghazho, sheitanla hhei tanine. ");
INSERT INTO sce_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Khuichuduni eqiemagha ese ogheikude Ersa bosizhedene hontande echi onxian giezho. ");
INSERT INTO sce_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ximun hhantuku kunlarene ereile echiwo. ");
INSERT INTO sce_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ereizhi oludene hhende kieliewo, \"Kunla man chii ereizho.\" ");
INSERT INTO sce_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ersa hhelade kieliewo, \"Matan psedulade yozhi shidadu aghinlade jiomun chonjiye. Bishi ene shiqinde iresan wo.\" ");
INSERT INTO sce_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ingie Jialilini gochude man yozhi hhelai huitanlade chonjizhi sheitan touzho. ");
INSERT INTO sce_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nie pifugientu Ersai melie ire xiutuliedene xiahua giezhi kieliewo, \"Chi duran bise mini ganjinragha shidane.\" ");
INSERT INTO sce_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ersai zhugheni zholierese khane zhighazhi hhei maqizhi kieliewo, \"Bi duran wine. Chi ganjinra!\" ");
INSERT INTO sce_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Pifugien deigo likai giese hhe ganjinrawo. ");
INSERT INTO sce_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ersa hhei echighakude hende fenfulazhi kieliewo, ");
INSERT INTO sce_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","\"Chi kiemade yama bu kieliedene echizhi beyene buwade uzhegha. Musai shu jiere fenfulasan mutun beyechii ganjinrasande oluzhi Hudade mure ogizhi kunlade ganzhen bei.\" ");
INSERT INTO sce_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Hhe kun khireidene olon kielien kieliezhi ene shiqinyi gochude kieliese Ersa khuinashi mindaminji chenshide echi dazhi zinie hontande wo. Go oronse kunla hhei ereizhi echizho. ");
INSERT INTO sce_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Giedudu daose Ersa pse Jiabainunde echiwo. Ersa giedoura bikui kunla sonosudene ");
INSERT INTO sce_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","olon kunla hhantulazhi wijien konde oron goujida uwo. Ersa hhelade Hudai kielienyi chonjizho. ");
INSERT INTO sce_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nie tanhon giesan gientui jieran kun qienliedene Ersai hhende irewo. ");
INSERT INTO sce_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kun olonshi Ersai shida qienliezhi echi dazho. Ingie hhe bisan oronni giei nouzii cheizhi chouraghadene ruzi lienqien boughawo. ");
INSERT INTO sce_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ersa hhelai xianxin giekui uzhedene tanhon giesan gientude kieliewo, \"Gaijiu, chii zuini mienliewo.\" ");
INSERT INTO sce_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Giedun jinwun hanjiala hhende sousenu zhughedene sumulazhi kieliezho, ");
INSERT INTO sce_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","\"Ene kun yangiezhi imutui kieliezho? Hhe kufurei fanjizho! Hudase chugo zuini kien mienliene?\" ");
INSERT INTO sce_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ersa hhelai zhughenughunyi mejiedene kieliewo, \"Ta yangiezhi zhughedene imutui sumulane? ");
INSERT INTO sce_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Tanhon giesan gientude chii zuini mienliewo giese sunfan onu, ruzine agisenu yo giese sunfan wo? ");
INSERT INTO sce_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kunnikewon duyade zuini mienlieku qienli bikui tande mejieghane giezho.\" Ingie tanhon giesan gientude kieliewo, ");
INSERT INTO sce_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","\"Bi chade kielieye, bosidene ruzine agisenu giedene echi!\" ");
INSERT INTO sce_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Hhe kun bosidene deigo ruzine agi kunlai melieghun khireiwo. Kunla man ghaniradene Hudai kuaizhi kieliezho, \"Bijien imutu shiqin uzhezhi ese daozho!\" ");
INSERT INTO sce_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ersa pse haibienzide echiwo. Kunla man hhei shida irese hhelade sughazho. ");
INSERT INTO sce_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ersa melie yose Yalefeini kewon Liwi shui shanjisan oronde sousei chanlawo. Hhende kieliewo, \"Chi mii dagha.\" Ingie hhe bosizhedene Ersai daghawo. ");
INSERT INTO sce_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ErsaLiwini giede ijiekude olon shui shanjisan kun, zuirenla Ersa, Ersai tujilare man hhantu soudene ijienduzho. Imutu kunla olon Ersai daghazho. ");
INSERT INTO sce_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Falisai kunni jinwun hanjiala Ersa shui shanjisan kun, zuirenlare hhantu ijiesei chanladene hhe yangiezhi shui shanjisan kun, zuirenlare hhantu ijiezho giezhi tujiladeni kieliezho. ");
INSERT INTO sce_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ersa sonosudene hhelade kieliezho, \"Gien witu kunla deifu ulie kerene. Gientula deifu kerene. Bi gou kunlai ereile ese irezho, zuirenlai ereile irezho.\" ");
INSERT INTO sce_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Hhe xienzide Yaheiyani tujila, Falisai kunla orozo bareizho. Kunla iredene Ersade kieliezho, \"Yaheiyani tujila, Falisai kunni tujila orozo bareizho. Chii tujila yale orozo ulie bareine?\" ");
INSERT INTO sce_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ersa hhelade kieliewo, \"Ghurunde iresan zhochenla shini khughon bikude matugie orozo bareine? Shini khughon hhelase hhantushi hhela orozo barei danema, ");
INSERT INTO sce_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","shini khughonni kunla lai echiku udu kuzhene. Hhe udude hhela orozo bareine.\" ");
INSERT INTO sce_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","\"Shini popui khuichen jien jiere huduchen kun uwo. Qingiese hudusan shini popu khuichen jienni tanturaghasan pse fugiedane. ");
INSERT INTO sce_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Shini jiuni khuichen tulunde zhonlochen kun uwo. Qingie zhonlose shini jiu tulunni ghalughazhi, jiu usuru khizhezhi tulunye qida olune. Shini jiuni shini tulunde zhonlone.\" ");
INSERT INTO sce_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nie hhamuraku udude Ersa boudei ghazhaghun yozhi daokude tujilani boudei qiorun sidazho. ");
INSERT INTO sce_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Falisai kunla Ersade kieliezho, \"Uzhe, hhela yangiezhi hhamuraku udude ulie giekui giezho?\" ");
INSERT INTO sce_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ersa hhelade kieliezho, \"Dawude, hhantuku kunlarene oliesukude giesan shiqinyi ta onshizhi ese daowu? ");
INSERT INTO sce_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Yabiyata zui fugie buwa danlakude hhe Hudai giede orodene Hudade ogiku ginanyi ijiewo. Pse hhantuku kunladene ogiwo. Ene ginanyi buwase andase kiema ijiezhi ulie olune.\" ");
INSERT INTO sce_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Pse hhelade kieliewo, \"Hhamuraku udushi kunde giesan wo. Kunshi hhamuraku udude giesan pusho. ");
INSERT INTO sce_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kunnikewonshi hhamuraku uduni Ezhan wo.\" ");
INSERT INTO sce_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ersa pse huitande orowo. Hhende nie khani ghosan kun wine. ");
INSERT INTO sce_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kunla Ersa hhamuraku udude goudaghase zhane giezhi xianxide uzhezho. ");
INSERT INTO sce_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ersa khani ghosan kunde kieliezho, \"Bosizhedene dunda bei.\" ");
INSERT INTO sce_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ersa kunlade kieliezho, \"Hhamuraku udude gouni giese gou onu, huaini giese gou wo? Aminni jiuinu, heine? Alinie oluzho?\" Hhela yama shenqi ese khizhewo. ");
INSERT INTO sce_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ersa hokuzhi zhouwine kunlai uzhezho. Hhelai zhughe khidunshi nango giezhi hhe kunde, \"Khane khizhegha.\" giezhi kieliese hhe khane khizheghase khani goudawo. ");
INSERT INTO sce_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Falisai kunla khizhi echidene deigo Hherodepai kunlare shanlian giezhi Ersai matui widaghane giezho. ");
INSERT INTO sce_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Ersa tujilarene likai gie haibienzide echise tebieji olon kunla hhei daghazho. Olon kunla hhe giesan shiqinni sonosudene Jialili, Yudaya, Yelusalen, Itumai, Yedanheni dunmien, Tuilo, Xidun zhouwini oronse man hhei shida irezho. ");
INSERT INTO sce_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kun olonshi jigheidane. Ersa tujiladene chon nie zhunbei gie giezhi kieliewo. ");
INSERT INTO sce_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ingiekushi Ersa olon kunyi goudaghawo. Gientula man jigheidazhi hhei maqine giezho. ");
INSERT INTO sce_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Zannan ruhherla hhei chanlase chishi Hudai Kewon wo giezhi niefanie papaladene waradazhi kieliene. ");
INSERT INTO sce_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ingiese Ersa hhelade hheshi kien bikui bu kielie giezhi hende minlin xiaizho. ");
INSERT INTO sce_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ersa ulade khirei, goya zhughe jieredu kunlane uruse hhela hhei shida irewo. ");
INSERT INTO sce_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Hhe 12 gie kun sunghudene shitu danlaghawo. Hhelai goyarene chan hhantu beighazhi peidene jiomun chonjighazhi ");
INSERT INTO sce_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","sheitan touku qienli ogine giezho. ");
INSERT INTO sce_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Hhe sunghusan 12 gie kunshi ErsaBeduru giezhi niere ogisan Ximun wo, ");
INSERT INTO sce_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Xibitaini kewon Yagebu, Yagebuni jiuni Yaheiya wo. Ene ghualade ErsaBanniqi giezhi niere ogiwo. Isishi xinbinni olien tungulieku niekielien wo. ");
INSERT INTO sce_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Pse Andelie, Feili, Badolomai, Matai, Doma, Yalefeini kewon Yagebu, Datai, Rexinpaini Ximun, ");
INSERT INTO sce_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","pse Ersai ghudandusan Jialie kun Yuda wo. ");
INSERT INTO sce_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ersa nie giedoura orowo. Kunla olon hhantulazho. Hhelade ijieku gunfuye uwo. ");
INSERT INTO sce_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ersai gieini kunla Ersa fenjiulizho giezhi kieliesei sonosudene khizhesenu hhei laizhi echine giezho. ");
INSERT INTO sce_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yelusalense bouzhesan jinwun hanjiala kieliezho, \"Hhei jiere Biexibu wine. Hhe sheitanni touzii kouizhi sheitan touzho.\" ");
INSERT INTO sce_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ersa hhelai uruzhi ire bilazhi kieliewo, \"Ibilisi matugie Ibilisini toune? ");
INSERT INTO sce_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nie gojia goyalane eghinduse hhe gojia bei dane. ");
INSERT INTO sce_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nie giede goyalane eghinduse hhe gie bei dane. ");
INSERT INTO sce_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ibilisi goyalane eghinduse hhela bei dazhi widane. ");
INSERT INTO sce_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kun liliantu kunyi giede orozhi dunxilai qianlane giese xien liliantu kunyi ulie banlase qianla dane. ");
INSERT INTO sce_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Bi tande shuhua kielieye, kunla fanjisan soyuji zui, hu kieliesanlai man roulienema, ");
INSERT INTO sce_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Shenlinni hu kieliese chanqi ulie rouliene. Zui chanqi wine.\" ");
INSERT INTO sce_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ene kielienyi kieliekushi hhela, \"Hhei jiere zannan ruhher wine.\" giezhi kieliezho. ");
INSERT INTO sce_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Hhe shihoude Ersai anani, gaijiulani iredene ghadane beizhi kunlai Ersai urughale echiwo. ");
INSERT INTO sce_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Olon kunla Ersai izhonde souzho. Ingie Ersade kieliewo, \"Uzhe, anachii, gaijiulachii, eghechijiulachii ghadane chii ereizho.\" ");
INSERT INTO sce_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ersa hhelade kieliewo, \"Kienshi mii ana wo? Kienshi mii gaijiula wo?\" ");
INSERT INTO sce_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Zhouwidene sousan kunlai uzhezhi kieliewo, \"Uzhe, mii ana, mii gaijiula wo! ");
INSERT INTO sce_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Hudai isii zunjizhi giesan kunlashi mii gaijiu, eghechijiu, ana wo.\" ");
INSERT INTO sce_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ersa pse haibienzide sughazhi qiiwo. Tebieji olon kunla hhei shida hhantulase hhe haini chon jiere khirei souwo. Kunla man haibienzide wo. ");
INSERT INTO sce_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ersa hhelade bilazhi olon sughazho. Sughakudeni hhelade kieliewo, ");
INSERT INTO sce_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","\"Ta chenliendu, nie kun shizhile echiwo. ");
INSERT INTO sce_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Shizhikudeni niezhanla mo jiere luise bunzhula ire ijie agiwo. ");
INSERT INTO sce_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Niezhanla tura olon witu tashitu oronde luise tura ninkienshi niazi faizhi ghujin woma, ");
INSERT INTO sce_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","genzi uwoshi naran khizhe nie xiese ghowo. ");
INSERT INTO sce_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Pse niezhanla eghesun dunda luise eghesun khizhezhi jigheidase bolu dawo. ");
INSERT INTO sce_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Da niezhanla gou ghazhade luise osizhi fugiedadene 30 pei, 60 pei, 100 pei zhonjia souwo.\" ");
INSERT INTO sce_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ersa pse kieliewo, \"Chighin bitu kunla chenliendu!\" ");
INSERT INTO sce_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ersa niezheghanne bikude daghasan kunla, 12 gie shitu bilasan isii asazho. ");
INSERT INTO sce_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ersa hhelade kieliewo, \"Hudai gojiai mimii tande mejieghawoma, ghadanedu kunlade bilazhi kieliekushi, ");
INSERT INTO sce_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","'Hhela uzhese minbai olu dane, chenliese dunjire dane. Pse kharei daorese Huda hhelai zuini mienliekuse ayizho.'\" ");
INSERT INTO sce_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Pse hhelade kieliewo, \"Ta ene bilasei mejie danu? Qinse ta soyuji bilasei matugie mejiene? ");
INSERT INTO sce_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Fure shizhisan kun shizhisanshi Hudai kielien wo. ");
INSERT INTO sce_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mo bienzide luisanshi kun Hudai kielienyi chenliedene Ibilisi deigo ire sudoro shizhisan kielienyi agi echiwo. ");
INSERT INTO sce_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tashitu oronde luisanshi kun kielienyi chenliedene bayasuzhi deigo jienliewoma, ");
INSERT INTO sce_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","zhughedeni genzi wise niechaku wo. Kielienyi yenyinghala zeinan onu heiku kuzhese deigo furawo. ");
INSERT INTO sce_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Eghesun dunda luisanshi kun kielienyi chenliewoma, ");
INSERT INTO sce_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","duyai munan gieku, baer miiku, pse duyai yanyanji onxian giekughala kielienyi jigheidazhi yama sou dawo. ");
INSERT INTO sce_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Gou ghazhade luisanshi kun kielienyi chenliezhi jienliedene 30 pei, 60 pei, 100 pei zhonjia souwo.\" ");
INSERT INTO sce_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ersa pse kieliewo, \"Kun zhulai agi irese ighaghala komoronu? Chonban doura jienu? Zhula teiku teizi jiere jiene. ");
INSERT INTO sce_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Niuighasanlai ulie khizheghakui uwo. Ghulazhi giesan shiqinlai ulie khizheghakui uwo. ");
INSERT INTO sce_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Chighin bitu kunla chenliendu!\" ");
INSERT INTO sce_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ersa pse kieliewo, \"Ta goude chenliendu, ta kunlade yanghala nanjizhi ogise tandeye yanghala nanjizhi ogine, da olon ogine. ");
INSERT INTO sce_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Bichen kunde pse olon ogine. Wichen kunse bisanlainiye agi echine.\" ");
INSERT INTO sce_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ersa pse kieliewo, \"Hudai gojia kun fureni ghazhade shizhisei xianli. ");
INSERT INTO sce_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Xieni kijiene, udu bosine, ene fure matui niazi faizhi osisei hhe kun ulie mejiene. ");
INSERT INTO sce_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ghazhase zhonjia goya osine. Xien niazi faine, khuinashi fugiedazhi qiorun khidene chuduzho. ");
INSERT INTO sce_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Zhonjia boluse liendaoghala ghadune. Ghuraku shihou oluwo.\" ");
INSERT INTO sce_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ersa pse kieliewo, \"Hudai gojia yanni xianli? Matan yanghala bilane? ");
INSERT INTO sce_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nie caizi furei xianli. Zemin jiere shizhisan furese zui gaji woma, ");
INSERT INTO sce_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","shizhidene khizhese yan caiseliuzhe fugie wo. Chalani fugiedazhi asiman jieredu bunzhula holiene.\" ");
INSERT INTO sce_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ersa zhao hhela dunjire shidaku mutun bilazhi olon kieliezho. ");
INSERT INTO sce_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Bilazhi ulie kieliese hhelade ulie kieliene. Kun widakude tujiladene isii kieliezhi man mejieghazho. ");
INSERT INTO sce_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Hhe xii Ersa tujiladene kieliewo, \"Matan hai duimiende daoye.\" ");
INSERT INTO sce_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tujilani olon kunlase likai gie Ersa sousan chon jiere khireidene hhantu echiwo. Psedu chonlaye hhantu yozho. ");
INSERT INTO sce_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Menzhali honfen kei bosidene lan chonni eghizhi chonde usu durune giezho. ");
INSERT INTO sce_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ersa chonni khuina zhentouni zhentoula kijie hhunturazho. Tujilani hhei xiereigha kieliewo, \"Loushi, bijienyi amin widane giezho! Chi ulie gonjinu?\" ");
INSERT INTO sce_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ersa xiereidene keini nie sugiezhi haide kieliewo, \"Bei! Nanranshi!\" Ingiese kei beiwo, fugiede nanranshiwo. ");
INSERT INTO sce_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ersa hhelade kieliewo, \"Ta yangiezhi ayizho? Tande xianxin giekui uwonu?\" ");
INSERT INTO sce_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Hhela fugiede ayizhi nieniedene kieliezho, \"Eneshi yan kun wo? Kei, haiye kielienyini chenliene.\" ");
INSERT INTO sce_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Hhela hai duimienni Gelasen kunyi oronde irewo. ");
INSERT INTO sce_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ersa chon jierese bouzhese nie zannan ruhher heisan kun mezase khizhe Ersai shida irewo. ");
INSERT INTO sce_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Hhe kun chan meza sudoro souzho. Hhei kunla banla dazhi qieshenghalaye han wo. ");
INSERT INTO sce_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kunla niefanie qieshen, jielioghala sozilase qieshenyi denji siraghazhi jielioni zhazhazi gholughane. Kiemada hhei hanshilie dane. ");
INSERT INTO sce_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Hhe xieni uduji meza konde, ulade onghonozhi da tashighala goyane zaizho. ");
INSERT INTO sce_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Hhe gholose Ersai chanladene holu ire hhei melie xiutuliedene ");
INSERT INTO sce_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","fugiede waradazhi kieliewo, \"Zui Undu Hudai kewon Ersa, chi mii jiohoro bu gie. Bi Hudai zhiizhi chii xiahua gieye, mii bu zayala!\" ");
INSERT INTO sce_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ingiekushi Ersa zannan ruhherde ene kunyi jierese khizhe giezhi fenfulazhi daozho. ");
INSERT INTO sce_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ersa hhende asawo, \"Chii nierei yan giene?\" Hhe kieliewo, \"Bijien olonshi Iban giezhi uruzho.\" ");
INSERT INTO sce_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Hhe Ersade oruntanyi hhe oronse bu yolagha giezhi hende xiahua giezho. ");
INSERT INTO sce_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Hhe popo jiere idaban khighei ijiezhi souzho. ");
INSERT INTO sce_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Zannan ruhher Ersade, \"Bijienyi khigheilai dunda echighazhi hhelai jiere khigha!\" giezhi xiahua giewo. ");
INSERT INTO sce_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ersa dain giese zannan ruhher khizhedene khigheilai jiere khiwo. Khigheila egheide chunji bou, haide yenji alawo. Khighei chabudu 2000 wo. ");
INSERT INTO sce_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Khighei adulasan kunla holu echidene chenshi, aghinlade kieliese kunla yan shiqin fashen giewo giezhi uzhele irewo. ");
INSERT INTO sce_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Hhela Ersai shida ire uzhese eqighandei \"Iban\" sheitan heisan hhe kun jien musizhi jinshen goudazhi souzho. Ingiese hhela ayizho. ");
INSERT INTO sce_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Sheitan heisan kunde fashen giesan shiqin, khigheini shiqinyi chanlasan kunla kunlade kieliezho. ");
INSERT INTO sce_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ingiese kunla Ersai, \"Enense likai gie!\" giezhi xiahua giezho. ");
INSERT INTO sce_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ersa chon jiere khireikude eqighandei sheitan heisan kun Ersai xiahua giezhi hhere hhantulane giese, ");
INSERT INTO sce_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ersa dain ese giezhi hhende kieliewo, \"Chi giedene echizhi jiawune kunlade Ezhan chade giesan fugie shiqin, pse matugiezhi ubali xiisei man kielie.\" ");
INSERT INTO sce_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Hhe kun echidene Jijiapolide Ersa hhende giesan fugie shiqinyi chonji qiise kunla man ghanirazho. ");
INSERT INTO sce_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ersa pse chon souzhi hai duimiende daose olon kunla hhei shida hhantulazho. Hhe zhen haibienzide wo. ");
INSERT INTO sce_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nie huitan gonjisan kunyi niereni Yalu giene. Ire Ersai chanladene kon kondei papala ");
INSERT INTO sce_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","hende xiahua giezhi kieliewo, \"Mii ga oqin ede duya ijiene giezho. Chi yodene hhei jiere khane teizhi onxian giese hhe goudazhi aminne olune.\" ");
INSERT INTO sce_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ingiese Ersa hhere hhantu echiwo. Tebieji olon kunla hhei daghazhi jigheidazho. ");
INSERT INTO sce_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nie biereii chusun usurusan gien 12 nien olune. ");
INSERT INTO sce_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Deifulai khade olon shouku giezhi bisan baerlane man huai widaghazho. Goujida ese goudadene kharei gundudazho. ");
INSERT INTO sce_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Hhe Ersai shiqinyi sonosudene kunlai dunda jiaidene Ersai khuinase jienni nie maqiwo. ");
INSERT INTO sce_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Hhe, \"Ersai jienni nie maqise gienni goudane.\" giezhi sumulazho. ");
INSERT INTO sce_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ingiese usurusan chusunni deigo beizhi goyane uzhese goudawo. ");
INSERT INTO sce_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ersa jieresene nenli khisei deigo mejiedene ochira daozhe kieliewo, \"Mii jienni kien maqiwo?\" ");
INSERT INTO sce_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tujilani Ersade kieliewo, \"Imegheni kun jigheidazho. Chi da, 'Kien maqiwo.' giezhi asane.\" ");
INSERT INTO sce_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ersa zhouwidene ene shiqinni giesan biereii uzhene giezho. ");
INSERT INTO sce_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ene bierei jiereni gholusan shiqinyi mejie, ayi pugharazhi Ersai melie ire papaladene shuhuane man kieliewo. ");
INSERT INTO sce_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ersa hhende kieliewo, \"Funi, chii xianxin gieku chii jiuiwo. Pinnande echi, chii gien goudawo.\" ");
INSERT INTO sce_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ersa zhen kieliekude huitan gonjisan kunni giese kunla kieliele irewo, \"Oqinchii duya ijiewo. Loushii pse mafan bu giegha.\" ");
INSERT INTO sce_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ersa hhela kieliesei ese gonjidene huitan gonjisan kunde kieliewo, \"Bu ayi, zi xianxin gie.\" ");
INSERT INTO sce_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ingie Ersa kunlai ese daghaghadene Beduru, Yagebu, Yagebui jiuni Yaheiya enela hhantu echiwo. ");
INSERT INTO sce_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Hhela huitan gonjisan kunyi giede irese kunla fugiede wilazhi onghonozhi lon chouisei Ersa chujieghewo. ");
INSERT INTO sce_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Sudoro orodene hhelade kieliewo, \"Ta yangiezhi lon chouizhi wilazho? Oqin ese duya ijiezho, hhunturazho.\" ");
INSERT INTO sce_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ingiese hhela Ersai uzhezhi xiniezho. Ersa hhelai man tou khighadene ada, anaini, daghasan kunlai uduru oqinyi giedera orowo. ");
INSERT INTO sce_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ingie oqinni khai bareidene kieliewo, \"Talita kumu!\" Isishi oqin, bosizhe giezho. ");
INSERT INTO sce_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Oqin deigo bosizhe yowo. Oqin 12 olune. Kunla hende ghanirazho. ");
INSERT INTO sce_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ersa ene shiqinyi kiemade bu mejiegha giezhi kunlade hende fenfuladene oqinde ijiuni ogi giezhi kieliewo. ");
INSERT INTO sce_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ersa hhense likai giedene goya orondene irewo. Tujilani hhei daghazho. ");
INSERT INTO sce_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Hhamuraku udude Ersa huitande kunlade sughase kunla chenliedene ghanirazhi kieliewo, \"Ene kunde khalase imutu benshi irezho? Hhende ogisanshi yan agheli wo? Hhe matugie imutu nenlitu shiqin giezho? ");
INSERT INTO sce_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Eneshi hhe mujian pushonu? Mereiyenni kewon pushonu? Gaijiulani Yagebu, Yusei, Yuda, Ximun, oqinjiulani mai enende uwonu?\" Hhela Ersade hokuzho. ");
INSERT INTO sce_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ersa hhelade kieliewo, \"Xienzhini goya oron, goya minzu, goya giese chugo khalaliuzhe zunjine.\" ");
INSERT INTO sce_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Hhela Ersai xianxin ese giese Ersa hhende nenlitu shiqinyi olon ese giewo. Zinie giedun gientulai jiere khane teizhi onxian giedene goudaghawo. ");
INSERT INTO sce_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Hhela xianxin ese giese Ersa ghanirawo. Ersa go aghinlai yo baraghazhi sughazho. ");
INSERT INTO sce_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ersa 12 gie tujini uru ire ghua ghuaji peizhi echighakude hhelade zannan ruhher touku qienli ogiwo. ");
INSERT INTO sce_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ersa hhelade fenfulawo, \"Mo yose zhugunse andase ijiuni, kuabao bu barei. Kakade maqie bu barei. ");
INSERT INTO sce_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Maheine musidene jien ghua bu barei.\" ");
INSERT INTO sce_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Pse hhelade kieliewo, \"Ta alinie giede orose hhe oronse likai gietula hhe giede sou. ");
INSERT INTO sce_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Alinie oronyi kunla tai ulie jienliezhi ulie chenliese hhense likai giekude kon jieredu turane kui boughazhi fandui giezhi zhenmin gie.\" ");
INSERT INTO sce_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Shitula khizhi echidene kunlade, \"Geizhen gie!\" giezhi chonjizho. ");
INSERT INTO sce_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Olon sheitanlai tou khighazhi olon gientulai jiere tosun fureizhi goudaghazho. ");
INSERT INTO sce_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ersai minshenyi chonji khireise Hherode honshan sonosuwo. Niezhan kunla kieliezho, \"Xili gieghasan Yaheiya fugudene aminne oluwo. Ingiese ene nenlitu shiqinla hhei jierese khizhezho.\" ");
INSERT INTO sce_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Psedu kunla kieliese hheshi Iliya wo giezho. Da kunla kieliese hheshi melieshiku nie xienzhi wo giezho. ");
INSERT INTO sce_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Hherode enei sonosudene kieliewo, \"Bi qiorunyini pienjisan Yaheiya aminne oluwo.\" ");
INSERT INTO sce_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Eqighandei ene Hherode honshan jiuni Feilini bierei Xilojini yenyinghala kun peizhi Yaheiyai bareidene banlasenu bafanzide khawo. Ingiekushi Hherode hhe biereii agizho. ");
INSERT INTO sce_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","YaheiyaHherodede, \"Chi jiune biereii agise ese oluzho.\" giezhi kieliezho. ");
INSERT INTO sce_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ingiese Xiloji hhei henjizhi alane giezhoma, ala dakushi ");
INSERT INTO sce_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","HherodeYaheiyase ayizho, hhei huizho. Ingiekushi Yaheiyashi nie gou kun, zhiguitu kun wo. Hherode hhei kielienyi chenliedene munan giezhoma kielienyini chenliekude xiqi wo. ");
INSERT INTO sce_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Niudude gou jihui irewo. Hherodeni olusan udu kuzhese xi beilazhi fugie noyen, buduini lindao, pse Jialilini lindaolai xinlazhi irewo. ");
INSERT INTO sce_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Xilojini oqin orozhedene wu jiuliwo. Hherode, xi sousan kunla man bayasuwo. Honshan oqinde kieliewo, \"Chi mase yan kerese yan ogiye.\" ");
INSERT INTO sce_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Pse fayen giezhi kieliewo, \"Chi mase yan kerezhi xiahua giese mii gojiani olieliuzhe ogine!\" ");
INSERT INTO sce_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Hhe khizhi echidene anadene asawo, \"Bi yan kerene?\" Anani kieliewo, \"Xili gieghasan Yaheiyani qiorunyi kere.\" ");
INSERT INTO sce_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Hhe jindazhi orodene honshande kieliewo. \"Bi xili gieghasan Yaheiyani qiorunyi kerene. Ede hhamusade donjidene made ogi.\" ");
INSERT INTO sce_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Honshan hhantu sousan kunlai melie fayen giese hende munan giezhi fura dazho. ");
INSERT INTO sce_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Honshan deigo nie binni peidene Yaheiyai qiorunyi agizhe giezho. Bin echidene bafanzide Yaheiyai qiorunyi chizhisenu ");
INSERT INTO sce_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","hhamusade donji ire oqinde ogise oqin anadene ogiwo. ");
INSERT INTO sce_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yaheiyai tujila enei sonosudene ire beyeini linlasenu mezade teiwo. ");
INSERT INTO sce_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Shitula Ersai shida iredene giesan shiqin, chonjisanlane man hhende kieliewo. ");
INSERT INTO sce_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Irewo echiwoji kun olonshi hhelade ijieku gunfuda uwo. Ingiese Ersa hhelade kieliewo, \"Ta ire, matan konkonji hontande yodene niecha hhamuraye.\" ");
INSERT INTO sce_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Hhela chonni soudene konkonji hontande echiwo. ");
INSERT INTO sce_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Olon kunla hhela yolasei chanladene hhelai tanidene go chenshise holuzhi hhelase melieshida kuruwo. ");
INSERT INTO sce_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ersa chon jierese bouzhese tebieji olon kunlai chanladene ubali xiiwo. Hhela adulachen witu ghonilai xianli. Ingie hhelade olon sughazhi qiiwo. ");
INSERT INTO sce_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Khara olune gie tujilani hhei shida ire kieliewo, \"Eneshi hontan wo. Shihou udazho. ");
INSERT INTO sce_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kunlai sandaghazhi hhela goyalane zhouwini go oron, aghinlade echidene agizhi ijiele echigieba.\" ");
INSERT INTO sce_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ersa kieliewo, \"Ta hhelade ogizhi ijiegha.\" Tujila kieliewo, \"Bijien 200 gie miengughala hhelade ginan agizhi ijieghanu?\" ");
INSERT INTO sce_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ersa kieliewo, \"Tande ginan giedughon wo? Nie uzhele echi.\" Hhela uzhedene kieliewo, \"Tawun ginanji ghua zhaghasun wo.\" ");
INSERT INTO sce_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ersa hhelade fenfulazhi kunlai iban ibanji osuntu oronde sougha giezho. ");
INSERT INTO sce_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kunla iban ibanji souzho. Ibande 100 gie, 50 gie souzho. ");
INSERT INTO sce_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ersa tawun ginan, ghua zhaghasunyi barei, asimanyi uzhe Hudade mafan kieliedene ginanyi ghulu keigha, tujiladene ogise tujila kunlai melie teiwo. Ghua zhaghasunyiye kunlade ghughazhi ogiwo. ");
INSERT INTO sce_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Dajiala man ijiedene chuduwo. ");
INSERT INTO sce_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Hhela feiliesan ginan, zhaghasun zhazhai hhantulaghase 12 gie lanzi zhonlowo. ");
INSERT INTO sce_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ginan ijiesan ere kun 5000 wo. ");
INSERT INTO sce_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ersa deigo tujilai biizhi chon jiere khighadene xien hai duimienni Bosaidade echigha goyane olon kunlai sandaghazho. ");
INSERT INTO sce_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Hhe hhelai khozhi yolaghadene goyane ula jiere khisenu onxian giele echiwo. ");
INSERT INTO sce_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Khara oluse chon hai dunda wo. Ersa niezheghanne zemin jiere wo. ");
INSERT INTO sce_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ersa tujilai uzhese kei shun uwoshi chonni huaizhi chijia no wo. Xieni 3 jiense 6 jienni shihoude hhe haini usu jiere yozhi hhelai hhense daone giezho. ");
INSERT INTO sce_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Tujila hai jiere hhe yosei chanladene perei wo gie waradazho. ");
INSERT INTO sce_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Hhela hhei chanladene ayizho. Ersa deigo hhelade kieliewo, \"Ta zhughelane tei. Bi wo. Bu ayi!\" ");
INSERT INTO sce_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ersa hhelare hhantu chon jiere khireise kei beiwo. Hhela hende ghanirazho. ");
INSERT INTO sce_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ingiekushi hhela ginan ijieghasan shiqinyi minbai olu dazho. Zhughelani khidun wo. ");
INSERT INTO sce_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Hhela haini daodene Genisaleni haibienzide chonni beighawo. ");
INSERT INTO sce_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Chon jierese bouzhese kunla deigo Ersai taniwo. ");
INSERT INTO sce_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ingie kunla hhe oronne holu onjighadene Ersa khala bikui mejiese gientulai ruzide qienlie hhei shida irewo. ");
INSERT INTO sce_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ersa ali aghin, chenshi, xiande echise kunla gientulai qienliedene geidoude jiene. Ersai xiahua giezhi lien jien ghizhane nie maqigha giezho. Maqisan kunla man goudawo. ");
INSERT INTO sce_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Falisai kun, giedun jinwun hanjiala Yelusalense ire Ersai hhende hhantulazho. ");
INSERT INTO sce_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ersai niezhan tujila khane ese wagha ijiesei hhela chanlawo. ");
INSERT INTO sce_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Falisai kun, soyuji Yutai kunla man xienrenla sughasan xigonyi zunjizho. Khane ulie waghatula ulie ijiene. ");
INSERT INTO sce_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Jise irese ulie waghatula ulie ijiene. Hhela da zunjisan xigon olon wo. Beizi, huhu, aduma enelai waghane. ");
INSERT INTO sce_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Falisai kun, jinwun hanjiala Ersade asawo, \"Chii tujila yangiezhi xienrenla sughasan xigonni ulie zunjidene khane ulie wagha ijiene?\" ");
INSERT INTO sce_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ingiese Ersa kieliewo, \"Isaiya ta jiazhon giesan kunlai zhiizhi melieshida kieliesan ese codazho. Jinwun jiere kieliezho, 'Ene bexinla amanghalane mii zunjine, zhugheni mase gholo wo. ");
INSERT INTO sce_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Hhela kunni guijinyi zhenzhenji daoli mutun kunlade sughazho, ingiese mii beiise yama oronde uwo.' ");
INSERT INTO sce_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ta Hudai minlinyi jiezhi kunni xigonyi zunjine.\" ");
INSERT INTO sce_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ersa pse kieliewo, \"Ta goya xigonne zunjine giezhi Hudai minlinyi gou banfaghala bendawo. ");
INSERT INTO sce_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Musa, 'Ada anane zunji, ada anane sugiesan kunni ala.' giezhi kieliezho. ");
INSERT INTO sce_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ingieliuzhe ta, 'Kun ada anadene bi tande ogi shidakui gurubani giewo.' giezhi kieliese ");
INSERT INTO sce_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","hhe kun ada anadene yama ulie giese olune giezho. (Gurubani isishi Hudade ogikui kieliezho.) ");
INSERT INTO sce_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ingiezhi ta goya xigonghalane Hudai kielienyi widaghazho. Ta dou intu shiqin olon giezho.\" ");
INSERT INTO sce_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ersa pse kunlai uruzhi ire hhelade kieliewo, \"Ta man mii kielienyi chenliezhi minbai olu, ");
INSERT INTO sce_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ghadanese orosan kunyi ulie zannanshighanema, sudorose khizhesan kunyi zannanshighane.\" ");
INSERT INTO sce_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ersa kunlase likai gie giedoura orose tujilani bilasan isini asazho. ");
INSERT INTO sce_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ersa hhelade kieliewo, \"Taye minbai olu danu? Ghadanese orosan kunyi ulie zannanshighakui ta ulie mejienu? ");
INSERT INTO sce_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ghadanese orosan kunyi zhughede oro dazhi kielighun mekiende echizho.\" Ingiezhi kieliezhi ijiekulashi man ganjinni wo giezho. ");
INSERT INTO sce_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ersa kieliewo, \"Kunyi sudorose khizhesan kunni zannanshighane. ");
INSERT INTO sce_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Doghunni sumulakulashi kunyi zhughese khizhezho. Lon kijieku, ghulaku, alaku, ");
INSERT INTO sce_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","piofen gieku, tanxin, doghunni, piendaku, hu gieku, dubilieku, sugieku, kondaku, benni wo. ");
INSERT INTO sce_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ene doghun shiqinlashi man kunyi sudorose khizhezhi kunni zannanshighane.\" ");
INSERT INTO sce_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ersa hhense likai giedene Tuilo oronde echi nie giede orowo. Kunlade mejieghaku duran uwoma, ingieliuzhe kunla mejiezho. ");
INSERT INTO sce_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nie biereini oqinyi zannan ruhher heizho. Ersai shiqinyi sonosudene ire Ersai kon melieni papalawo. ");
INSERT INTO sce_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ene biereishi niman kun wo. Xiliyani-Feiniji minzu wo. Hhe Ersai xiahua giezhi oqinyini jierese sheitanyi tou khigha giezho. ");
INSERT INTO sce_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ersa hhende kieliewo, \"Kesilade xien ijiezhi chudughakuni wo, kesilai ginanyi ga nogheide bendazhi ogise ese oluzho.\" ");
INSERT INTO sce_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Bierei kieliewo, \"Ezhan, kesila ijiezhi feiliesan zhazhai nogheiye shire doura ijiene.\" ");
INSERT INTO sce_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ersa hhende kieliewo, \"Ene nie aman kielienghala chi khareizhi echi. Sheitan chii oqinse likai giewo.\" ");
INSERT INTO sce_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Hhe khareizhi echi uzhese sheitan khizhi echizhi oqin chonban jiere kijiezho. ");
INSERT INTO sce_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ErsaTuilose likai gie Xidunse daozhi Jijiapoli orondedu Jialilihaide echiwo. ");
INSERT INTO sce_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Hhe oronyi kunla dulei yaba gholusan nie kunyi uduruzhi Ersai ochirale irewo. Ersai xiahua giezhi khane beye jiereni tei giezho. ");
INSERT INTO sce_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ersa hhei uduruzhi olon kunse likai giezhi nimande echiwo. Kha ghurunne ghua chighindei teiwo. Ingie nunpudene kielien jiereni moiwo. ");
INSERT INTO sce_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Asimanyi uzhezhi nie shanholo hhende kieliewo, \"Ifada!\" Isishi keii giezho. ");
INSERT INTO sce_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Hhei chighinni deigo keiwo. Kielienni goudazhi kielien kielieseye qinchu wo. ");
INSERT INTO sce_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ersa kunlade bu kielie giezhi hhelade fenfulazhoma, ye fenfulase ye chonji keighawo. ");
INSERT INTO sce_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Olon kun hende ghuduredene kieliezho, \"Hhe giesan shiqinla man gou wo. Duleii sonosughawo. Yabaiye kielien kielieghawo.\" ");
INSERT INTO sce_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Hhe shihoude pse olon kun hhantulase ijiekui uwo. Ersa tujilane uruzhi ire kieliewo, ");
INSERT INTO sce_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","\"Ene kunla mare hhantu ghurudu oluzho, hhelade ijiekui widazho. Bi hhelade ubali xiizho. ");
INSERT INTO sce_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Bi hhelai oliesuzhi giedei echighase hhela mo jiere injirene. Gholose iresanye wine.\" ");
INSERT INTO sce_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tujilani hhende kieliewo, \"Ene hontande imeghei kunlade matugie ginanyi ijiezhi chudughane?\" ");
INSERT INTO sce_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ersa hhelade asawo, \"Tande ginan giedughon wo?\" Hhela kieliewo, \"Dolon wo.\" ");
INSERT INTO sce_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ersa olon kunlai fenfulazhi zemin jiere soughadene dolon ginanyi barei mafan kieliedene ghulu tujilade ogise tujila olon kunlai melie beilawo. ");
INSERT INTO sce_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Pse hhelade giedun zhaghasun wo. Ersa mafan kieliedene fenfulazhi kunlai melie beilaghawo. ");
INSERT INTO sce_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Hhela ijiezhi chududene feiliesei dolon lanzi zhonlowo. ");
INSERT INTO sce_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Hhende chabudu 4000 kun wo. Ersa hhelani dafalazhi echighawo. ");
INSERT INTO sce_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Deigo tujilarene hhantu chon jiere khirei Damanuta oronde echiwo. ");
INSERT INTO sce_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Falisai kunla Ersai shida ire jianjindu qiiwo. Hhela Ersai shiizhi, \"Asiman jierese iresan ghudureqi xienjigha.\" giezhi xiahua giezho. ");
INSERT INTO sce_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ersa zhughedene hende nie shanholo kieliewo, \"Ene idai kunla yangiezhi ghudureqii kerene? Bi tande shuhua kielieye, ene idai kunlade xienjighaku ghudureqi uwo.\" ");
INSERT INTO sce_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ingiedene hhelase likai gie, chon jiere khirei hai duimiende daowo. ");
INSERT INTO sce_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tujila ginan bareikui matazho. Chon jiere khireise zinie ginan wo. Pse ijiuni uwo. ");
INSERT INTO sce_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ersa hhelade fenfulazhi kieliezho, \"Ta Falisai kunni kunieghe, Hherode kunni kunieghei jinxin giezhi fangula.\" ");
INSERT INTO sce_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tujila nieniedene kielienduzho, \"Matande ginan wise ingiezhi kieliezhoba.\" ");
INSERT INTO sce_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ersa mejiedene hhelade kieliewo, \"Ta yangiezhi ginan wikui kielienduzho? Ta dou mejie dazhi minbai olu danu? Ta dou intu men onu? ");
INSERT INTO sce_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Tande nudun wine, uzhe danu? Chighin wine, chenlie danu? Ta jila dazhou? ");
INSERT INTO sce_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tawun ginanyi ghuludene 5000 kunde ogikude zhazhai giedun lanzi zhonlowo?\" Hhela kieliewo, \"12 gie wo.\" ");
INSERT INTO sce_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","\"Pse dolon ginanyi ghuludene 4000 kunde ogikude zhazhai giedun lanzi zhonlowo?\" Hhela kieliewo, \"Dolon wo.\" ");
INSERT INTO sce_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ersa kieliewo, \"Ta dou minbai olu danu?\" ");
INSERT INTO sce_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Hhela Bosaidade irewo. Kunla nie sughoi uduruzhi ire Ersai xiahua giezhi hhei nie maqi giezho. ");
INSERT INTO sce_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ersa sughoi khase laidene aghin ghadane echiwo. Nudun jierei nunpudene ghua khane hhei jiere teizhi, \"Chi yan chanlawo.\" giezhi asazho. ");
INSERT INTO sce_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Hhe qiorunne qila nie uzhe kieliewo, \"Bi kunlai chanlawo. Hhela mutunyi xianli, da yozho.\" ");
INSERT INTO sce_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ersa pse khane nudun jierei teizho. Sugho xianxide uzhese goudadene yanyanjilai qinchude chanlawo. ");
INSERT INTO sce_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ersa hhei giedei echighakude, \"Aghinde bu echi.\" giezhi kieliewo. ");
INSERT INTO sce_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ersa tujilarene khidene Kaisaliya-Feilibini aghinlade echiwo. Mo jiere tujiladene asazho, \"Kunla kieliese bishi kien wo giezho?\" ");
INSERT INTO sce_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Hhela kieliewo, \"Kunla kieliese xili gieghasan Yaheiya wo giezho. Niezhan kunla kieliese Iliya wo giezho. Pse niezhan kunla kieliese xienzhi dundadu nie wo giezho.\" ");
INSERT INTO sce_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ersa hhelade asawo, \"Ta kieliese bishi kien wo?\" Beduru kieliewo, \"Chishi Mexiha wo.\" ");
INSERT INTO sce_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ersa orunyi kiemade bu kielie giezhi hhelade hende fenfulawo. ");
INSERT INTO sce_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ingiedene Ersa hhelade sughazhi qiiwo, \"Kunnikewon matugieseda hende shouku giezhi zhanlao, fugie buwa, jinwun hanjiala mii fandui giezhi alane. Ghurudu oludene aminne olune.\" ");
INSERT INTO sce_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ersa ene kielienyi mindamin kieliese Beduru hhei laidene kheila qiiwo. ");
INSERT INTO sce_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ersa ochira daore tujilai uzhedene Bedurui kheilazhi kieliewo, \"Ibilisi, mii khuina dao! Chi Hudai isii ulie sumulazhi kunni isii sumulane!\" ");
INSERT INTO sce_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ersa olon kun, tujilane uruzhi ire kieliewo, \"Kien mii daghane giese goyane sheidene shizijiane beiliezhi mii daghakuni wo. ");
INSERT INTO sce_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kien aminne jiuine giese aminne widaghane. Made, gouxioxide oluzhi aminne widaghase aminne jiuine. ");
INSERT INTO sce_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kun duyani man zhenjidene goya aminne widaghase yande gou wo? ");
INSERT INTO sce_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kun pse yanghala aminne arunzhane? ");
INSERT INTO sce_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kien ene piofen giezhi zui fanjisan duyade bi, kieliensemi jiuren giese Kunnikewon Adane fama dunda zhiguitu qienxienlare hhantu irekude hhenseye jiuren giene.\" ");
INSERT INTO sce_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ersa hhelade kieliewo, \"Bi tande shuhua kielieye, enende beisan kun dunda niezhanla Hudai gojia nenli dunda irekui ulie chanlatula ulie fugune.\" ");
INSERT INTO sce_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Zhighudu daose ErsaBeduru, Yagebu, Yaheiyai danxin uduru undu ulade khireidene hhelai melie bienjiwo. ");
INSERT INTO sce_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Jienni gon faidene chighande duya jiere popu waghachen kun dunda kiema qingiezhi waghazhi chighashigha dane. ");
INSERT INTO sce_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Iliya, MusaErsare kielien kieliesei hhela chujieghewo. ");
INSERT INTO sce_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","BeduruErsade kieliewo, \"Loushi, matan enende gou wo. Enende ghuran zhanfan daiye. Niei chade, niei Musade, niei Iliyade.\" ");
INSERT INTO sce_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ingiekushi hhela hende ayidene Beduru yan kieliekune ulie mejiene. ");
INSERT INTO sce_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Niegieda olien iredene hhelai khawo. Oliense shenqi irezhi kieliewo, \"Eneshi bi oresan mii kewon wo. Ta hhei kielienyi chenlie!\" ");
INSERT INTO sce_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Menzhali tujila zhouwidene nie uzhese kiemai ese chanlawo. Zi Ersa hhelare hhantuwo. ");
INSERT INTO sce_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ulase boukude Ersa, \"Kunnikewon fugusan kun dundase aminne ulie olutula chanlasei kiemade bu kielie!\" giezhi hhelade fenfulawo. ");
INSERT INTO sce_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tujila ene kielienyi zhughedene jilasenu, \"Fugusanse aminne olune giese yan isi wo.\" giezhi kielienduzho. ");
INSERT INTO sce_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Hhela Ersade asawo, \"Jinwun hanjiala yangiezhi Iliya ijinyo xien irene giezhi kieliezho?\" ");
INSERT INTO sce_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ersa kieliewo, \"Iliya xien iredene man erchan gie goudaghakuni woma, jinwun jiere yangiezhi, 'Kunnikewon olon shouku giezhi kunla hhei uzhe dane?' giezhi huaizho? ");
INSERT INTO sce_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Bi tande kielieye, Iliya shuhuajia irezhoma, jinwun jiere kieliesan mutun kunla hhei shimatu giezho.\" ");
INSERT INTO sce_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Hhela psedu tujilai hhende khareizhi irese olon kunla wiqizhi jinwun hanjiala tujilare jianjindusei chanlawo. ");
INSERT INTO sce_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kunla man Ersai chanladene ghudurezho. Ingie holu echi kielien asazho. ");
INSERT INTO sce_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ersa hhelade asawo, \"Ta hhelare yan jianjinduzho?\" ");
INSERT INTO sce_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Kunlai dundase nie kun kieliewo, \"Loushi, bi kewonne uduruzhi chii enende irewo. Hhei yaba sheitan heizho. ");
INSERT INTO sce_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Khalaliuzhe sheitan hhei barei agise hhei banjighazhi amansei momozi moine. Shidunne zhouzhi beyeni khiduzhezho. Bi chii tujilade kieliezhi sheitanyi tou khigha giese hhela han wo.\" ");
INSERT INTO sce_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ersa kieliewo, \"Ai, ta ene xianxin ulie giechen idaini kunla! Bi tanse rennai giezhi giedoghoncha beine? Kewonni uduruzhi mii enende ire!\" ");
INSERT INTO sce_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Hhela kewonni uduru irewo. Sheitan Ersai chanlasenu kewonni hende nie tigharaghawo. Kewon zemin jiere unadene ghoghoreizhi amansei momozi moizho. ");
INSERT INTO sce_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ersa adadei asawo, \"Hhe giemerezhi giedoghoncha oluzho?\" Adani kieliewo, \"Ga xienzise ingiezho. ");
INSERT INTO sce_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Sheitan hhei niefanie khande, usude bendazhi fugughane giezho. Chi gie shidase bijiende ubali xiizhi banman nie gie.\" ");
INSERT INTO sce_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ersa hhende kieliewo, \"Gie shidaseshi yan kielien wo? Xianxin giesan kunde yanniliuzhe giene.\" ");
INSERT INTO sce_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ingie adani deigo fugiede kieliewo, \"Bi xianxin giene, bi xianxin gie dasei chi made banman gie!\" ");
INSERT INTO sce_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ersa olon kunla holu iresei chanlasenu zannan ruhheryi sugiezhi kieliewo, \"Chi ene dulei yaba sheitan, bi minlin xiaiye, ene kunyi jierese khizhedene pse bu oro!\" ");
INSERT INTO sce_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Sheitan fugiede nie warada kewonni nie tigharaghadene khizhewo. Kewon fugusan niekielien wo. Olon kunla kieliese hhe fuguwo giezho. ");
INSERT INTO sce_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ersa hhei khase laidene feizhi bosighase hhe bosizhewo. ");
INSERT INTO sce_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ersa giedera orose tujilani konkonji asawo, \"Bijien yangiezhi ene sheitanyi khigha dane?\" ");
INSERT INTO sce_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ersa hhelade kieliewo, \"Onxian ulie giese ene izhun sheitanni khigha dane.\" ");
INSERT INTO sce_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Hhela hhe oronse likai giezhi Jialiliyi daowo. Ersa kunlade mejieghaku duran uwo. ");
INSERT INTO sce_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ingiekushi Kunnikewonyi kunlai khade jiuidene hhela alase ghurudude aminne olune giezhi Ersa tujiladene sughazho. ");
INSERT INTO sce_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tujila ene kielienyi dunjire dazho, ayizhi asaye dazho. ");
INSERT INTO sce_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Hhela Jiabainunde irese Ersa giedoura tujilade asawo, \"Ta mo jiere yan zhenjinduzho?\" ");
INSERT INTO sce_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Tujila shenqi ese khizhezho. Hhela mo jiere kien zui fugie wo giezhi zhenjinduzho. ");
INSERT INTO sce_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ersa sousenu 12 gie tujii uruzhi ire kieliewo, \"Kien laoda danlane giese kunlase gajishizhi ushilachen kun danlakuni wo.\" ");
INSERT INTO sce_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ingie Ersa nie kewosii uduru ire hhelai dunda beighadene qioru hhelade kieliewo, ");
INSERT INTO sce_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","\"Kien mii niereghala intu kewosii jienliese mii jienliezho. Kien mii jienliese mii ese jienliezho, mii peizhi ireghasan hhei jienliezho.\" ");
INSERT INTO sce_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","YaheiyaErsade kieliewo, \"Loushi, bijien nie kunyi uzhese chii niereghala sheitan touzho. Bijien danlazhi ese toughawo. Hhe matanyi ese daghazho.\" ");
INSERT INTO sce_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ingiese Ersa kieliewo, \"Bu danla. Mii niereghala fugie shiqin giedene deigo mii sugiechen kun uwo. ");
INSERT INTO sce_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Matanyi fandui ulie giese matande oluzhi giezho. ");
INSERT INTO sce_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Bi tande shuhua kielieye, kien tande tashi Mexihanughun wo giezhi nie beizi usu ogiliuzhe hhende jianli kenjin ogine.\" ");
INSERT INTO sce_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","\"Kien mii xianxin giesan enezighan ga kun dundadu niei zui fanjighase ghuzhundeni qiemanshai banladene haide bendase da gou wo. ");
INSERT INTO sce_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Chii nie kha chii zui fanjighase chizhidene agi! Beyechii canfei gholuzhi chanqi amitukude echiku ghua kha bidene dozode, ulie xinieku khande orokuse gou wo. ");
INSERT INTO sce_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Chii nie kon chii zui fanjighase chizhidene agi! Beyechii canfei gholuzhi chanqi amitukude echiku ghua kon bidene dozode bendakuse gou wo. ");
INSERT INTO sce_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Chii nie nudun chii zui fanjighase waidene agi! Chade nie nudun chaizhi Hudai gojiade oroku ghua nudun bidene dozode bendakuse gou wo. ");
INSERT INTO sce_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Hhende ghughei ulie fugune, khan ulie xiniene. ");
INSERT INTO sce_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Khan dansun wo giezhi jien kunyi yenliene. ");
INSERT INTO sce_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Dansunshi gouni wo. Widaoni widase matugie koudaghane? Tai dunda dansun bizhi nieniedene heqishi.\" ");
INSERT INTO sce_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ersa hhense likai giezhi Yudaya oronde, Yedanhe duimiende irewo. Kunla pse hhei hhende hhantulase Ersa chanqiku mutun kunlade sughazho. ");
INSERT INTO sce_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Falisai kunla ire Ersai shiizhi asazho, \"Ere kun biereine lihun gieghase olunulie?\" ");
INSERT INTO sce_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ersa hhelade kieliewo, \"Musa tande matugie fenfulazho?\" ");
INSERT INTO sce_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Hhela kieliewo, \"Musa kieliese lihun qiuzi huaidene lihun giese olune giezho.\" ");
INSERT INTO sce_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ersa hhelade kieliewo, \"Tai zhughe khidunshi Musa ene minlinyi huaizho. ");
INSERT INTO sce_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Duyai zhayaghakude Huda ere kun, eme kunyi zhayaghawo. ");
INSERT INTO sce_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ingiese kun ada anasene likai giedene biereighalane hhantulazhi ");
INSERT INTO sce_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ghuala nie beye gholune. Hhela ghua pusho, nie wo. ");
INSERT INTO sce_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ingiese Huda hhantulaghasei kun fenkai gieghase ulie olune.\" ");
INSERT INTO sce_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Giedoura orose tujila Ersade ene shiqinyi pse asazho. ");
INSERT INTO sce_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ersa hhelade kieliewo, \"Kien biereighalane lihun giedene pse agise piofen giezho. Biereine kuighazho. ");
INSERT INTO sce_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Bierei zhanguijighalane lihun giedene pse loujide khiseye piofen giezho.\" ");
INSERT INTO sce_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kunla kesilane uduruzhi Ersai melie ire maqighane giese tujila hhelai sugiezho. ");
INSERT INTO sce_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ersa chanladene hokuzhi tujilade kieliewo, \"Kesilai bu dui, mii shida ire gie. Hudai gojiashi imutu kunlanughun wo. ");
INSERT INTO sce_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Bi tande shuhua kielieye, kien kewosi mutun Hudai gojiai ulie jienliese hhende oro dane.\" ");
INSERT INTO sce_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ingie kesilai qiorudene hhelai jiere khane teizhi gouni kieliezho. ");
INSERT INTO sce_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ersa yozhi qiikude nie kun holuzhi iredene hhei melie xiutuliezhi asawo, \"Gou loushi, bi matui giese chanqiku aminni jienliene?\" ");
INSERT INTO sce_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ersa hhende kieliewo, \"Chi mii yangiezhi gou wo giezho? Hudase chugo gouni uwo. ");
INSERT INTO sce_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Minlinyi chi mejiene, kun bu ala, piofen bu gie, bu ghula, jia ganzhen bu bei, bu pienda, ada anane zunji giezho.\" ");
INSERT INTO sce_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Hhe kun kieliewo, \"Loushi, enelai bi ga xienzise man zunjizho.\" ");
INSERT INTO sce_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ersa hhei uzhedene orezhi kieliewo, \"Chade da nie chaizho. Echidene bisanlane man huizhi nanxin kunlade ogi. Ingiese chii boubei asiman jiere wo. Ingiedene irezhi mii dagha.\" ");
INSERT INTO sce_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Hhende caichan olonshi ene kielienyi chenliedene ungieni bouzhi yuchourazhi yolawo. ");
INSERT INTO sce_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ersa zhouwidene uzhe tujiladene kieliewo, \"Baertu kun Hudai gojiade oroku chijia no wo.\" ");
INSERT INTO sce_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Tujila ene kieliende ghudurezho. Ingiese Ersa hhelade kieliewo, \"Kesila, Hudai gojiade oroku chijia no wo. ");
INSERT INTO sce_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Loto zhun boghose daoku bayan kun Hudai gojiade orokuse da sunfan wo.\" ");
INSERT INTO sce_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tujila hende ghanirazhi nieniedene asazho, \"Ingiese kienyi jiui shidane?\" ");
INSERT INTO sce_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ersa hhelai uzhedene kieliewo, \"Kun gie danema, Huda buxian wo. Huda yanniliuzhe giene.\" ");
INSERT INTO sce_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","BeduruErsade kieliewo, \"Uzhe, bijien man bendadene chii daghazho!\" ");
INSERT INTO sce_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ersa kieliewo, \"Bi tande shuhua kielieye, kun made, gouxioxide oluzhi gie, gaijiu, eghechijiu, ada, ana, kesila, ghazhane bendase ");
INSERT INTO sce_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ene duyade gie, gaijiu, eghechijiu, ana, kesila, ghazha 100 pei ogine. Ogikude heikuiye hhantu ogine. Houshide chanqiku amin ogine. ");
INSERT INTO sce_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ingiese olon melieshikula khuinashilane, khuinashikula melieshilane.\" ");
INSERT INTO sce_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Hhela Yelusalende khireiku mo jiere Ersa melie yozho. Tujilani ghanirazho, daghasan kunla ayizho. Ersa pse 12 gie tujii uruzhi ire goyade kuzheku shiqinyi kielie qiiwo, ");
INSERT INTO sce_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","\"Uzhe, matan Yelusalende khireine. Kunnikewonyi fugie buwa, jinwun hanjialade jiuise hhela hhei sixin panjidene niman kunlade jiuine. ");
INSERT INTO sce_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Hhela hhei xilun giene, ungie jiere nunpune, mabienzighala eghine, da alane. Ingie ghurudu daose aminne olune.\" ");
INSERT INTO sce_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Xibitaini ghua kewon Yagebu, YaheiyaErsai melie ire kieliewo, \"Loushi, bijien yan xiahua giese chi bijiende yan ogiba.\" ");
INSERT INTO sce_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ersa kieliewo, \"Ta mii yan gieghane?\" ");
INSERT INTO sce_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Hhela kieliewo, \"Chi famatu baozo jiere soukude bijienyi niei borun miende niei soghei miende sougha.\" ");
INSERT INTO sce_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ersa kieliewo, \"Ta yan keresanne ulie mejiene. Bi shouiku kuni ta shoui shidanu? Bi jienlieku xilini ta jienlienu?\" ");
INSERT INTO sce_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Hhela kieliewo, \"Jienliene.\" Ersa kieliewo, \"Bi shouiku kuni ta shoui, bi jienlieku xilini ta jienlienema, ");
INSERT INTO sce_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","mii lianmien kanzide soughakui bi ogiku pusho. Kiende zhunbei giezhoshi kiende ogine.\" ");
INSERT INTO sce_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Psedu hharan tujini sonosudene Yagebu, Yaheiyaghalade hokuzho. ");
INSERT INTO sce_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ersa hhelai uruzhi ire kieliewo, \"Niman kunlai dunda lindao, noyen giezhi urusanla qienli bareizhi kunlai gonjisei ta mejiene. ");
INSERT INTO sce_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ta niekielien pusho, tai dunda kien fugieni danlane giese tande ushilachen kun danlakuni wo. ");
INSERT INTO sce_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Tai dunda kien laoda danlane giese dajialade hoji danlakuni wo. ");
INSERT INTO sce_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kunnikewon irekushi kunlai ushilaghale ese irezho. Kharei kunlai ushilazhi aminne sheidene olon kunlade shuiku Jiage danlale irezho.\" ");
INSERT INTO sce_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Hhela Yeligede irewo. Ersa tuji, tebieji olon kunlare Yeligese likai giekude nie ghuichen sugho Jimaini kewon Bajimai mo bienzide souzho. ");
INSERT INTO sce_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Hhe chenliese Nasaleni Ersa wo giese warada qiiwo, \"Dawudeni houdei Ersa, made ubali nie xii!\" ");
INSERT INTO sce_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Olon kunla hhei jiebalazhi shenqi bu khizhe giese hhe genjia fugiede waradazhi kieliezho, \"Dawudeni houdei, made ubali nie xii!\" ");
INSERT INTO sce_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ersa beidene kieliewo, \"Hhei uru daozhe.\" Hhela sughoi uruzhi kieliewo, \"Zhughene teidene bosizhe. Hhe chii uruzho.\" ");
INSERT INTO sce_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Sugho jienne jiezhi jiuli bosizhedene Ersai hhende yozhi irewo. ");
INSERT INTO sce_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ersa kieliewo, \"Bi chade yan giene?\" Sugho kieliewo, \"Loushi, bi chanlaku duran wo!\" ");
INSERT INTO sce_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ersa kieliewo, \"Chi echi. Chii xianxin gieku chii jiuiwo.\" Sugho deigo chanladene mo jiere Ersai daghawo. ");
INSERT INTO sce_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Hhela Yelusalense chadashizhi Ganlanshanni Bofaqi, Bodanide kuzhekude Ersa ghua tujine peizhi ");
INSERT INTO sce_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","hhelade kieliewo, \"Ta duimienni aghinde echi. Dei orose nie huiyasan ga enzheghei chanlane. Kieme unuzhi ese daozho. Ta andaghadene lai ire. ");
INSERT INTO sce_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kunla tande enei, 'Yangiezhi giezho?' giese ta 'Ezhan injine. Ingie deigo enende khugho ireghane.' giezhi kielie.\" ");
INSERT INTO sce_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Hhela echise nie ga enzheghei wijien konni mo jiere huiya jiesei chanlawo. Hhela hhei andaghase ");
INSERT INTO sce_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","hhende beisan giedun kunla asawo, \"Ta ga enzhegheni andaghazhi yan giene?\" ");
INSERT INTO sce_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tujila Ersa kieliesan mutun kieliese hhela laighawo. ");
INSERT INTO sce_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Hhela ga enzheghei lai Ersai shida ire goya jienlane enzheghe jiere daidene Ersai unughawo. ");
INSERT INTO sce_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Olon kunla jienlane mo jiere peizho. Psedu kunla ghazhase chizhisan mutun chalai mo jiere peizho. ");
INSERT INTO sce_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Melie khuinadu kunla waradazhi kieliezho, \"Hesanna! Ezhanyi niereghala iresan hhei doulandu! ");
INSERT INTO sce_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Mai xienren Dawudeni gojia iresande doulandu! Zui Undudedu Hudade doulandu! Hesanna!\" ");
INSERT INTO sce_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ErsaYelusalende kuru mechide orozhi zhouwini man nie uzhewo. Khara oluse Ersa 12 gie shiturene chenshise khirei Bodanide echiwo. ");
INSERT INTO sce_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Khuichudu hhela Bodanise khizhese Ersa oliesuzho. ");
INSERT INTO sce_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Gholose nie lachen winetu nie uhuago mutunyi chanlawo. Hhende echizhi mutun jierese alima ereizhi olune giezho. Hhe mutun doura echise yama uwo, zinie lachen bikushi alima souku shihou pusho. ");
INSERT INTO sce_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ersa mutunde kieliewo, \"Enedu khuinase chii jiere pse ibeizi alima ulie soune!\" Tujilani kielienyini sonosuzho. ");
INSERT INTO sce_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Hhela Yelusalende irewo. Ersa mechide orodene meimei giesan kunlai tou khighawo. Baer arunzhasan kunlai shire, ghoghochen huisan kunlai bandoulai tungu unaghawo. ");
INSERT INTO sce_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kunlai mechise dunxilai agizhi ese daoghazho. ");
INSERT INTO sce_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Hhelade sughazhi kieliezho, \"'Mii giei go minzula onxian gieku gie giezhi urune.' giezhi jinwun jiere ese huaizhou? Ta hhei ghughei ho gholughazho!\" ");
INSERT INTO sce_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Fugie buwa, jinwun hanjiala ene kielienyi chenliedene banfa xianjizhi Ersai widaghane giezho. Olon kunla man hhe sughasan tebie gou wo giese hhense ayizho. ");
INSERT INTO sce_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Khara olukude hhela chenshi ghadane khireizho. ");
INSERT INTO sce_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Eqiemagha hhela hhense yozhi daokude uhuago mutun lien genzi ghosei chanlawo. ");
INSERT INTO sce_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","BeduruErsai kielienyi sumula ire hhende kieliewo, \"Loushi, uzhe! Chi kharasan uhuago mutun ghozho.\" ");
INSERT INTO sce_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ersa kieliewo, \"Ta Hudai xianxin gie. ");
INSERT INTO sce_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Bi tande shuhua kielieye, kien zhughedene inxin ulie giezhi ene ulade oronsene noidene haide bou giese jiu qingiezhi gholune. ");
INSERT INTO sce_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ingiese bi tande kielieye, ta onxian giezhi xiahua giekude tande ogiwo giezhi xianxin giema, tande qingiezhi gholune. ");
INSERT INTO sce_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ta beidene onxian giekude kunla chii hokughasei sumula irese roulie. Asiman jieredu adataiye tai codasei rouliene.\" ");
INSERT INTO sce_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Hhela pse Yelusalende irewo. Ersa mechide yokude fugie buwa, jinwun hanjia, zhanlaola Ersai shida iredene ");
INSERT INTO sce_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","hhende kieliezho, \"Chi yan qienlighala ene shiqinlai giezho? Kien chade ene qienlii ogizhi ene shiqinyi gieghazho?\" ");
INSERT INTO sce_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ersa hhelade kieliewo, \"Biye tande nie unqi asaye. Ta made huida giese bi yan qienlighala ene shiqinlai giesei tande kieliene. ");
INSERT INTO sce_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yaheiyai xili gieghaku qienli asimanse onu, kunlase wo? Ta made huida gie.\" ");
INSERT INTO sce_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Hhela goyalane shanlian giezhi kieliewo, \"Matan asimanse wo giese ta yale hhei xianxin ulie giene giezhi hhe kieliene. ");
INSERT INTO sce_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kunlase wo giese?\" Jien kunla man Yaheiyashi zhenzhenji xienzhi wo giese hhela bexinlase ayizho. ");
INSERT INTO sce_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ingie Ersade kieliewo, \"Bijien ulie mejiene.\" Ersa hhelade kieliewo, \"Biye tande yan qienlighala ene shiqinlai giesei ulie kieliene.\" ");
INSERT INTO sce_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ersa hhelade bilazhi kielie qiiwo, \"Nie kun nie yenzi putou zeiladene izhonyini qienjiwo. Jiu daruku chizi waizhi yenzi uzheku teizi giedene kunlade bouizhi ogi, gholode echiwo. ");
INSERT INTO sce_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Shihou kuzhese nie hojine peizhi bouisan kunlase nexianne ghuraghale echiwo. ");
INSERT INTO sce_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Bouisan kunla hhei bareidene idun eghi khosun khareighawo. ");
INSERT INTO sce_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Pse nie hoji peizhi echighase hhela qiorunyini eghi ghalughazhi shizheghazho. ");
INSERT INTO sce_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Pse nie hoji peizhi echighase hhela hhei alawo. Khuinashida olon hojilai peizhi echighase niezhanlai eghizho, niezhanlai alazho. ");
INSERT INTO sce_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Yenzii ezhande oresan niekozi kewon wo. Zuihoude hhei peizhi echighazhi kieliezho, 'Hhela kewonyimi zunjineba.' ");
INSERT INTO sce_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ingie bouisan kunla nieniedene kieliewo, 'Eneshi jiachanni jienliechen wo. Matan enei alayema, jiachanni manughun gholune!' ");
INSERT INTO sce_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ingie hhei bareidene alazhi putou yenzise benda khighawo. ");
INSERT INTO sce_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ingiese putou yenzii ezhan matugiene? Hhe iredene bouisan kunlai alazhi putou yenzii psedu kunlade ogine. ");
INSERT INTO sce_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ta ene idon jinwunni onshizhi ese daowu? 'Gie giesan kunla bendasan tashi giei zhunyo tashi gholuwo. ");
INSERT INTO sce_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Eneshi Ezhan giesan wo. Matan uzhese xihan giezho.'\" ");
INSERT INTO sce_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ersa hhelai zhiizhi bilazhi kieliesei hhela uzhe khizhedene bareine giezhoma, olon kunlase ayidene Ersase likai gie yolawo. ");
INSERT INTO sce_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Hhela giedun Falisai kun, Hherodepai kunni peizhi Ersai hhende echighadene hhei kielienghala heine giezho. ");
INSERT INTO sce_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Hhela iredene hhende kieliewo, \"Loushi, chi shuhua kieliekui bijien mejiene. Chi yan kunyiliuzhe niekielien uzhezhi kunni mienzii ulie uzhene. Hudai daolini shixinde sughazho. Matan Kaisa Honshande shui jiuise oluzhou ese oluzho? ");
INSERT INTO sce_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Matan jiuiku onu, ulie jiuiku wo?\" Ersa hhelai jiazhon giesei mejiedene hhelade kieliewo, \"Ta mii shiizhi yan giene? Made miengui agizhedene nie uzhegha.\" ");
INSERT INTO sce_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Hhela agizhese Ersa kieliewo, \"Ene qiorun, haoshi kiennughun wo?\" Hhela kieliewo, \"Kaisanughun wo.\" ");
INSERT INTO sce_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ersa kieliewo, \"Kaisanughunshi Kaisade ogi, Hudanughunshi Hudade ogi.\" Ingiese hhela Ersade hende ghanirazho. ");
INSERT INTO sce_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Fuho gieku shiqin uwo giesan Sadugai kunla ire Ersade asazho, ");
INSERT INTO sce_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","\"Loushi, Musa guijin jiere huaizho, nie kun bierei agidene kewosi wi duya ijiese jiuni zhoui gaidene houdei liuikuni wo giezho. ");
INSERT INTO sce_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Gaijiu dololie, laoda bierei agidene kewosi wi duya ijiewo. ");
INSERT INTO sce_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Laoer hhei zhouidene kewosi wi duya ijiewo. Laosanye ingiezho. ");
INSERT INTO sce_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Hhe dololiede kewosi nieda uye feiliezho. Zuihou biereiye duya ijiewo. ");
INSERT INTO sce_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ingiese fuho giekude hheshi kienyi bierei wo? Gaijiu dololie man hhei agiwo.\" ");
INSERT INTO sce_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ersa hhelade kieliewo, \"Tanughun codazho. Ta jinwunni mejie dazho, Hudai nenliniye mejie dazho. Eneshi tai codasan yenyin wo. ");
INSERT INTO sce_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kun aminne olukude ulie agine, ulie dafalane, asiman jieredu qienxien niekielien wo. ");
INSERT INTO sce_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Duya ijiesan kun aminne olukui kieliese ta eghesun khan siderasan jinwunni Musai shu jiere onshizhi ese daowu? Huda Musade, 'Bishi Iburaheimuni Huda wo, Isagheini Huda wo, Yagebuni Huda wo.' giezhi kieliezho. ");
INSERT INTO sce_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Hudashi duya ijiesan kunyi Huda pusho, amitu kunyi Huda wo. Tanughun fugiede codazho.\" ");
INSERT INTO sce_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nie jinwun hanjia ire hhela jianjindusei sonosuwo. Ersa kieliesan gou bikui mejiedene Ersade asazho, \"Minlin dunda alinie zui zhunyo wo?\" ");
INSERT INTO sce_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ersa kieliewo, \"Ji 1 gieshi ene wo, Isilieya, chenliendu! Ezhan mai Hudashi zi niekozi wo. ");
INSERT INTO sce_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Chi qienbuji zhughe, qienbuji jinshen, qienbuji sumulaku, qienbuji lilianghalane Ezhan Hudadene ore giezho. ");
INSERT INTO sce_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Jie 2 gieshi ene wo, goyadene mutun giebeidene ore giezho. Ene ghua minlinse fugieni uwo.\" ");
INSERT INTO sce_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Jinwun hanjia Ersade kieliewo, \"Loushi, chi kieliesan oluzho. Hudashi nie wo. Hhense chugo pse Huda uwo. ");
INSERT INTO sce_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Qienbuji zhughe, qienbuji sumulaku, qienbuji lilianghalane Ezhan Hudadene oreku, pse goyadene mutun giebeidene oreku yanyanji sideraghaku sidagha, ogiku murelase zhunyo wo.\" ");
INSERT INTO sce_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ersa uzhese hhe huida giesande agheli wine. Ingie hhende kieliewo, \"Chi Hudai gojiase gholo uwo.\" Enense khuinashi kunla hhende yama asa dazho. ");
INSERT INTO sce_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ersa mechide sughakude kieliezho, \"Jinwun hanjiala matugie Mexihashi Dawudeni houdei wo giezhi kieliezho? ");
INSERT INTO sce_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dawude goya Shenlinni tungo giezhi kieliewo, 'Ezhan mii Ezhande kieliewo, \"Bi duitoulaichii kon dourachii teitula chi mini borun miende sou.\"' ");
INSERT INTO sce_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dawude goyane Mexihai Ezhan giezhi uruse Mexiha matugie Dawudeni houdei wo?\" Ingiese tebieji olon kunla hhenughunyi chenliekude xiqi wo. ");
INSERT INTO sce_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ersa kunlade sughakude kieliewo, \"Ta jinwun hanjialai fangula. Hhela fudu jien musidene geidoude toreizhi kunla hhelade kielien asakude xiqi wo. ");
INSERT INTO sce_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Huitanni undu wizi, xini shanxide soukude xiqi wo. ");
INSERT INTO sce_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Hhela guafui gieni chigheine. Jiazhon giezhi oloncha onxian giene. Enezighan kunlai pse gundude faine.\" ");
INSERT INTO sce_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ersa mechii baer teiku xianzii duimiende soudene kunla matui baer teisanyi uzhezho. Olon bayan kunla xianzide baer olon teizho. ");
INSERT INTO sce_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nie nanxin guafu iredene ghua fenfenzi baer teizho. ");
INSERT INTO sce_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ersa tujilane uruzhi ire kieliewo, \"Bi tande shuhua kielieye, ene nanxin guafu xianzide teisan soyuji kunlase olon wo. ");
INSERT INTO sce_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kunla olonsene teiwo, guafude yama uwoma, udu daoku baerlane man teiwo.\" ");
INSERT INTO sce_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ersa mechise khizhekude nie tujini hhende kieliewo, \"Loushi, uzhe! Ene tashi, loula matu fama wo!\" ");
INSERT INTO sce_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ersa hhende kieliewo, \"Chi ene fugie gielai chanlawu? Jianlai man cheizhi tashi jiere tashi nieda ulie jiene.\" ");
INSERT INTO sce_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ersa mechini duimienni Ganlanshande soukude Beduru, Yagebu, Yaheiya, Andelie konkonji ire asazho, ");
INSERT INTO sce_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","\"Yan xienzide ene shiqinla fashen giene? Enela man chenjikude yan zunji bikui bijiende nie kielie.\" ");
INSERT INTO sce_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ersa hhelade kielie qiiwo, \"Ta xioxin giezhi kunlai bu miigha. ");
INSERT INTO sce_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Olon kunla mii niereghala iredene bishi hhe enbene giezhi olon kunlai miine. ");
INSERT INTO sce_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ta eghindusan, eghindune giesan xioxini sonosuse bu jinda. Ene shiqin kenjin fashen gienema, duya baraku shihou dou ese kuzhezho. ");
INSERT INTO sce_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Minzu minzula eghindune, gojia gojiala eghindune. Gochude zemin gojioluzhi oliesune. Eneshi tendunni keitou wo.\" ");
INSERT INTO sce_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","\"Ingiese ta goyane xioxin gie. Kunla tai zui fugie fayende jiuine. Huitanlade eghine. Mii yenyinghala ta shenzhan, honshanlai melie beizhi ganzhen beine. ");
INSERT INTO sce_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Pse gouxioxini go minzulade matugieseda xien chonjizhi ogine. ");
INSERT INTO sce_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kunla tai bareizhi fayende jiuikude ta yan kieliekui melieshighan munan bu gie. Hhe shihoude tande yan kielieghase yan kielie. Kieliesanshi ta pusho, Shenlin wo. ");
INSERT INTO sce_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Gaijiu gaijiune, ada kewosine ghudanduzhi fugughakude kune. Kesila ada, anane zodui giezhi fugughakude jiuine. ");
INSERT INTO sce_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mii yenyinghala soyuji kunla man tai henjine. Ingieliuzhe rennai giezhi zuihou kusanlai jiuine.\" ");
INSERT INTO sce_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","\"Hhe pohai giezhi hanzhan gieghaku ulie beiku oronde beisei ta chanlane. (Onshichen kunla, ene kielienni isii dunjirekuni wo.) Ingiekude Yudayade sousan kunla, ulade piile echi. ");
INSERT INTO sce_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Gie jieredula, bu bouzhezhi giederase dunxi agile bu oro. ");
INSERT INTO sce_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ghazha jieredula, jienne agile khareizhi bu echi. ");
INSERT INTO sce_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Hhe udude kewosi laisan, gogoghasanlade gou widawo. ");
INSERT INTO sce_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Enei unchade bu kuzhegha giezhi onxian gie. ");
INSERT INTO sce_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ingiekushi hhezighan udude zeinan fugie wo. Huda duyai zhayaghazhi eli kutula imutu zeinan uwo, khuinashiye uwo. ");
INSERT INTO sce_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ezhan hhezighan zeinantu udui ese choghonshighazhoshi nieda jiui danema, hhe sunghusan kunladene oluzhi choghonshighawo. ");
INSERT INTO sce_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Hhe udude kunla tande uzhe, Mexiha enende wo, uzhe, hhende wo giese ta xianxin bu gie. ");
INSERT INTO sce_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Jia Mexiha, jia xienzhila khizhezhi ghudureqi, fugie shiqinlai giekushi sunghusanlaiye kenen miine. ");
INSERT INTO sce_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ta xioxin gie, bi shiqinlai tande man eqie kieliewo.\" ");
INSERT INTO sce_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","\"Hhezighan zeinanni udu daose naran kharalane, sara gon ulie faine. ");
INSERT INTO sce_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Hodunla asiman jierese anda bouzhene. Asiman jieredu lilianla gojiolune. ");
INSERT INTO sce_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ingiekude Kunnikewon fugie nenlighala famade olien jierese irekui kunla chanlane. ");
INSERT INTO sce_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Hhe qienxienlai peizhi zemin enemanse asiman hhemande kutula sunghusan kunlane simiense uruzhi hhantulaghane.\" ");
INSERT INTO sce_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","\"Ta uhuago mutunyi bilasei suru. Mutun niazi faizhi lachen keise khaluncha orokui ta mejiene. ");
INSERT INTO sce_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Taye niekielien wo. Ta ene shiqinla fashen giesei chanlase hhe shihou chadashizhi shida kuzhesei mejiene. ");
INSERT INTO sce_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Bi tande shuhua kielieye, ene idaini kunla fugutula ene shiqinla man gholune. ");
INSERT INTO sce_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Asiman zemin widaliuzhe mii kielien kenjin ulie widane.\" ");
INSERT INTO sce_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","\"Hhe udu hhe shihouni kiema ulie mejiene. Asiman jieredu qienxienlaye ulie mejiene. Kewonye ulie mejiene. Zinie Ada mejiene. ");
INSERT INTO sce_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ta xioxin giezhi jinxin gie, hhe shihouni ta ulie mejiene. ");
INSERT INTO sce_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Eneshi nie kun giesene likai giezhi gholode echikude hojiladene gonjighazhi wilielai nanpei gie, wijien sagheisande jinxin gie giezhi fenfulasei xianli. ");
INSERT INTO sce_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ingiese ta jinxin gie. Giei ezhan yan xienzide irekui ulie mejiene. Khara olukude onu, banyede onu, tigha kheilakude onu, eqiemagha irekui ulie mejiene. ");
INSERT INTO sce_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Hhe menzhali irese ta kijiesei chanlakuse ayizho. ");
INSERT INTO sce_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Bi tande kieliesan kielienshi soyuji kunlade kieliesan wo. Ta jinxin gie!\" ");
INSERT INTO sce_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ghuarudu daose Jiulidaosan Jie, jiushi Tanmien Jie wo. Fugie buwa, jinwun hanjiala Ersai piendazhi bareidene matui alane giezhi banfa xianjizhi kieliezho, ");
INSERT INTO sce_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","\"Jieqii udude ulie olune, bexinla londane.\" ");
INSERT INTO sce_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ErsaBodanide pifugientu Ximunyi giede ijiekude nie bierei ishighala giesan huapinde guizhuntu zhen nada xianshuini agizhedene eghi ghalugha Ersai qiorun jiere kiewo. ");
INSERT INTO sce_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Giedun kunlai zhughede hokuzhi kieliewo, \"Xianshuii ingiezhi lanfei giezhi yan giene? ");
INSERT INTO sce_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ene xianshuii 300 gie miengu huidene nanxin kunlade ogikui wo!\" Hhela hhe biereii kheilazho. ");
INSERT INTO sce_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ersa kieliewo, \"Bu danla. Hhende chijia teizhi yan giene? Hhe made nie gou shiqin giewo. ");
INSERT INTO sce_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nanxin kunla tanre chan hhantu wo. Ta hhelade banman giese yan xienzideliuzhe olune. Bi tanre chan hhantu uwo. ");
INSERT INTO sce_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Hhe gie shidakune jinlianji giezho. Xianshuini mii jiere kiezhi mii bulakude zhunbei giezho. ");
INSERT INTO sce_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Bi tande shuhua kielieye, gouxioxini chonjizhi qienxiade kutula ene bierei gieseiye kieliezhi jilane.\" ");
INSERT INTO sce_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","12 gie tuji dundadu Jialie kun YudaErsai ghudandune giezhi fugie buwalai hhende echiwo. ");
INSERT INTO sce_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Hhela chenliedene bayasuzhi hhende baer ogikui dain giewo. Ingiese YudaErsai ghudanduku jihui ereizho. ");
INSERT INTO sce_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Tanmien Jieni tou 1 qien, Jiulidaosan Jieni ghoni zharuku udude tujilani Ersade kieliewo, \"Bijien Jiulidaosan Jieni xini chade khala zhunbei giene?\" ");
INSERT INTO sce_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ersa ghua tujii peidene kieliewo, \"Ta chenshide echi. Nie tunzi usu qilasan kunyi penjine. Ta hhei daghazhi ");
INSERT INTO sce_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","hhe ali giede orose ta oro, hhe giei zhanguijide kielie, 'Loushi asazho, \"Bi tujilarene Jiulidaosan Jieni daoghaku gie khala wo?\"' ");
INSERT INTO sce_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Hhe tande lou jiere fugie gieni uzheghane. Man qiendaghazhi zhunbei gie goudaghazho. Ta hhende matande zhunbei gie.\" ");
INSERT INTO sce_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tujila khizhi echi chenshide echidene chanlasan Ersa kieliesanghala niekielien wo. Ingie hhela hhende Jiulidaosan Jieni zhunbei giewo. ");
INSERT INTO sce_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Khara oluse Ersa 12 gie tujirene irewo. ");
INSERT INTO sce_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Hhela xi souzhi ijiekude Ersa kieliewo, \"Bi tande shuhua kielieye, tai dunda mase hhantu ijiesan nie kun mii ghudandune.\" ");
INSERT INTO sce_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Hhela munan giedene bi pushoba giezhi nienieji asa qiiwo. ");
INSERT INTO sce_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ersa hhelade kieliewo, \"Tai 12 gie dundadu mare hhantu jiezise zhanjizhi ijiesan nie kun wo. ");
INSERT INTO sce_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kunnikewon jinwun jiere huaisan mutun fugunema, hhei ghudandusan kunde gou widawo! Hhe kunyi ese oluzhoshida gou wo.\" ");
INSERT INTO sce_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Hhela ijiekude Ersa ginanyi barei onxian giedene ghulu hhelade ogi kieliewo, \"Ta barei, eneshi mii beye wo.\" ");
INSERT INTO sce_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pse beizii barei mafan kieliedene hhelade ogise hhela man ochiwo. ");
INSERT INTO sce_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ersa kieliewo, \"Eneshi olon kunlade usurusan bi yenjisan chusun wo. ");
INSERT INTO sce_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Bi tande shuhua kielieye, bi pse putoujiuni ulie ochizhi Hudai gojiade shinii ochiku hhe udu kune.\" ");
INSERT INTO sce_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Hhela douladene khizhe Ganlanshande echiwo. ");
INSERT INTO sce_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ersa hhelade kieliewo, \"Ta man mii bendane. Jinwun jiere kieliezho, 'Bi yanbashii eghi unaghase ghonila sandane.' ");
INSERT INTO sce_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ingieliuzhe bi aminne oludene tanse melie Jialilide echine.\" ");
INSERT INTO sce_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Beduru kieliewo, \"Kunla man chii bendaliuzhe bi ulie bendane!\" ");
INSERT INTO sce_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ersa hhende kieliewo, \"Bi chade shuhua kielieye, ene xii tigha lianhui kheilatula chi mii 3 hui ulie renjine.\" ");
INSERT INTO sce_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Beduru khidunde kieliewo, \"Bi chare hhantu fuguliuzhe chii tani dane giezhi ulie kieliene!\" Tujilaye man qingiezhi kieliezho. ");
INSERT INTO sce_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Hhela nie Keximani giesan oronde irewo. Ersa tujiladene kieliewo, \"Ta enende sou, bi onxian giele echine.\" ");
INSERT INTO sce_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ingie Beduru, Yagebu, Yaheiya enelai uduru hhantu echiwo. Ersa hende jindazhi nango giedene ");
INSERT INTO sce_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","hhelade kieliewo, \"Mii zhughede nango giezhi fugukui xianli, ta enende sagheizhi jinxin gie.\" ");
INSERT INTO sce_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Hhe gouji melie yodene zemin jiere papala olu shidase hhe shihoui daogha giezhi onxian giezho. ");
INSERT INTO sce_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ersa kieliewo, \"Aba, Ada, chi yanniliuzhe giene. Ene shouku giekui made bu iregha! Ingieliuzhe mii duranghala bu gie, chii duranghala gie.\" ");
INSERT INTO sce_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ersa irese hhela hhunturasei chanladene Bedurude kieliewo, \"Ximun, chi hhunturazhou? Nie zhuntouye jinxin gie danu? ");
INSERT INTO sce_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Jinxin giezhi onxian gie, pse miine. Tai zhughede duran winema, beyetai zholien wo.\" ");
INSERT INTO sce_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ingie pse likai gie onxian giewo. Kieliesan melieshidakughala niekielien wo. ");
INSERT INTO sce_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pse irese hhela hhunturasei chanlawo. Hhela nokuzhi nudunne nie dazho. Ersade yan huida giekui ulie mejiene. ");
INSERT INTO sce_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","3 huide ire hhelade kieliewo, \"Ta dou hhunturazhi hhamuranu? Ede oluwo, shihou kuzhewo. Uzhe, Kunnikewonyi zuirenlai khade ghudanduwo. ");
INSERT INTO sce_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bosizhe, matan yoye. Uzhe, mii ghudandusan kun irewo.\" ");
INSERT INTO sce_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ersa zhen kieliekude 12 gie tuji dundadu Yuda fugie buwa, jinwun hanjia, zhanlaola peisan iban banban, khudogho bareisan kunlare hhantu irewo. ");
INSERT INTO sce_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ersai ghudandusan kun hhelade nie jihao kieliezhi bi kiende orese kien enbene. Ta hhei bareidene xioxin giezhi lai echi giezho. ");
INSERT INTO sce_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yuda iredene Ersai shida echi loushi giedene orewo. ");
INSERT INTO sce_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ingiese hhela Ersai bareiwo. ");
INSERT INTO sce_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kanzide beisan nie kun khudoghoi lai khizhe zui fugie buwai hojii nie chighinyi chizhi agiwo. ");
INSERT INTO sce_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ersa hhelade kieliewo, \"Ta khudogho, banbanlai bareidene mii qiandao mutun bareile irewu? ");
INSERT INTO sce_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Niudunie bi mechide sughakude tanre hhantu wo, ta ulie bareine. Eneshi jinwun jieredu kielienyi gholughane giezho.\" ");
INSERT INTO sce_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tujila man Ersase likai gie holu widawo. ");
INSERT INTO sce_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nie nasuchighan kun hulan muchughun jierene bosii nanbezhi Ersai daghazho. Kunla hhei bareine giese ");
INSERT INTO sce_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","hhe bosii benda jiedene hulan muchughun holu widawo. ");
INSERT INTO sce_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Hhela Ersai zui fugie buwai hhende lai echiwo. Hhende fugie buwa, zhanlao, jinwun hanjiala man hhantulazho. ");
INSERT INTO sce_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Beduru gholose Ersai daghazhi zui fugie buwai ghoronde orodene wijien sagheisan kunlare hhantu khan xiezho. ");
INSERT INTO sce_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Fugie buwa, zui fugie fayenni soyuji kunla man ganzhen ereizhi Ersai alane giezhoma, yama zhenji erei dazho. ");
INSERT INTO sce_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Olon kunla jia ganzhen beizhoma, kieliesanlani izhi uwo. ");
INSERT INTO sce_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Giedun kunla bosizhedene jia ganzhen beizhi kieliewo, ");
INSERT INTO sce_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","\"Bijien kielieseini chenliese bi kun giesan mechii cheidene ghurudude pse nie kun uye giesei gie khighane giezho.\" ");
INSERT INTO sce_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ingiezhi ganzhen beiliuzhe izhi uwo. ");
INSERT INTO sce_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Zui fugie buwa bosizhe dunda beidene Ersade asawo, \"Ene kunla ganzhen beizhi zhasande chi yama huida ulie gienu?\" ");
INSERT INTO sce_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ersa shenqi ese khizhezhi nie amanda huida ese giezho. Zui fugie buwa pse asazho, \"Chishi Mexiha, indan doulaku Hudai kewon enbenu?\" ");
INSERT INTO sce_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ersa kieliezho, \"Bi enbene. Ta Kunnikewon Nenlitu Hudai borun miende sousei, pse asimanni olien jierese irekui chanlane.\" ");
INSERT INTO sce_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Zui fugie buwa jienne sida keigha kieliewo, \"Matan pse yan ganzhen beiku kun kerene? ");
INSERT INTO sce_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Hhe kufurei fanjisei ta chenliewo! Ta kieliese matugiene?\" Hhela man fuguku zui jinjizho. ");
INSERT INTO sce_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Niezhanla ungie jiereni nunpuzho. Pse ungieini huighadene chuidazhi kieliezho, \"Chii kien eghisei kielie?\" Wijien sagheisan kunla laizhi daodene hhaghadazho. ");
INSERT INTO sce_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Beduru doura ghoronde bikude zui fugie buwai nie hoji oqin ire ");
INSERT INTO sce_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Beduru khan konde khan xiesei chanla, uzhedene kieliewo, \"Chiye Nasaleni Ersare hhantuku wo.\" ");
INSERT INTO sce_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Beduru ese renjizhi kieliewo, \"Chi yan kieliesei bi ulie mejiene, dunjireye dane.\" Ingie khizhedene melie yenzide echise tigha kheilawo. ");
INSERT INTO sce_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Hhe hoji oqin chanladene kanzii beisan kunlade kieliewo, \"Eneshi hhelare hhantuku kun wo.\" ");
INSERT INTO sce_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Beduru pse ese renjiwo. Goujicha beise kanzii kunla pse kieliewo, \"Chishi Jialili kun wo, kenjin hhelare hhantuku wo.\" ");
INSERT INTO sce_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Beduru fayen giezhi khara qiiwo, \"Ene kunyi bi tani dane!\" ");
INSERT INTO sce_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Deigo tigha lianhui kheilawo. BeduruErsa kieliesan tigha lianhui kheilatula chi mii 3 hui ulie renjine giesei sumula ire bazilie da wila qiiwo. ");
INSERT INTO sce_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Eqiemagha kuse deigo fugie buwa, zhanlao, jinwun hanjiala, zui fugie fayenni soyuji kunlare hhantu shanlian giezho. Hhela Ersai banladene laizhi Biladode jiuiwo. ");
INSERT INTO sce_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","BiladoErsade asawo, \"Chishi Yutai kunni honshan onu?\" Ersa kieliewo, \"Chi kieliezho.\" ");
INSERT INTO sce_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Fugie buwala hhei olon shiqinde zhase ");
INSERT INTO sce_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Bilado pse asazho, \"Chi uzhe, hhela chii imegheni zhase, chi yama ulie kielienu?\" ");
INSERT INTO sce_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ersa yama huida ese giese Bilado ghanirazho. ");
INSERT INTO sce_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Niefanie ene jieqide shenzhan bexinla keresan mutun nie fanren andaghane. ");
INSERT INTO sce_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nie kunyi nierei Balaba giene. Panlon giesan kunlare hhantu khazho. Hhela panlon giekude kun alazhi daozho. ");
INSERT INTO sce_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Olon kunla Biladoi melie echi, \"Melieshidaku mutun banji.\" giezhi xiahua gie qiiwo. ");
INSERT INTO sce_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Bilado kieliezho, \"Tande Yutai kunni honshanyi tei giezhou?\" ");
INSERT INTO sce_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Fugie buwala Ersai dubiliezhi hhende jiuizhi ogisei hhe mejiedene ingiezhi asazho. ");
INSERT INTO sce_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Fugie buwala bexinlai shanjizhi, \"Balabai andagha!\" giezhi xiahua gieghazho. ");
INSERT INTO sce_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Bilado pse kieliewo, \"Qinse ta Yutai kunni honshan wo giesan enei matugiene?\" ");
INSERT INTO sce_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ingiese hhela pse waradazho, \"Hhei shizijia jiere ghada!\" ");
INSERT INTO sce_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Bilado kieliezho, \"Yangiezhi? Hhe yan doghun shiqin giewo?\" Hhela pse hende waradazhi kieliezho, \"Hhei shizijia jiere ghada!\" ");
INSERT INTO sce_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ingiese Bilado bexinlai bayasughazhi Balabai andaghawo. Ersai mabienzighala eghidene kunlade jiuizhi shizijia jiere ghada giezho. ");
INSERT INTO sce_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Buduila Ersai laizhi shenzhan sousan oronyi ghoronde echi, nie tonni buduilai man uruzhi hhantulaghawo. ");
INSERT INTO sce_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Hhela Ersade zishei fudu jienyi musighazhi eghesunni maghala onjidene zhoghawo. ");
INSERT INTO sce_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ingiedene Yutai kunni honshan, onsui giezhi jinli giewo. ");
INSERT INTO sce_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ingie qiorun jierei ghulusunghala eghizhi jierei nunpuzho. Xietuliedene hhei beiizho. ");
INSERT INTO sce_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Xilun gie balu, zishei fudu jienyi teigha, jienyini musighadene lai khirei shizijia jiere ghadane giezho. ");
INSERT INTO sce_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nie xianse iresan Gulinai kun Ximun wo. Yalishanda, Lufuni ada wo. Hhense daokude buduila hhende ninkounin Ersai shizijiai beilieghawo. ");
INSERT INTO sce_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Hhela Ersani laizhi Gegeta giesan oronde kuruwo. Isishi qiorun yasun oron wo. ");
INSERT INTO sce_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Guizhuntu caoyeni jiude huigha Ersade ogise ese kerewo. ");
INSERT INTO sce_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ingie shizijia jiere ghadawo. Hhela fendan qianguzhi jienni kiende kune giezho. ");
INSERT INTO sce_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Eqiemagha 9 jiende hhela Ersai shizijia jiere ghadawo. ");
INSERT INTO sce_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Peizi jiere Yutai kunni honshan giezhi zuinini huaizho. ");
INSERT INTO sce_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Hhela hhere hhantu ghua qiandaoi shizijia jiere niei borun miende, niei soghei miende ghadazho. ");
INSERT INTO sce_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Hhense yozhi daosan kunla sugiezhi qiorunne shuiqizhi kieliezho, \"Ai! Chi mechii cheise ghurudude gie khighane giesan, ");
INSERT INTO sce_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","chi goyane jiuizhi shizijia jierese bouzhesha!\" ");
INSERT INTO sce_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Fugie buwa, jinwun hanjialaye ingiezhi uzhezhi xiniezhi nieniedene kielienduzho, \"Hhe kunlai jiuiwo, goyane jiui dane. ");
INSERT INTO sce_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Isilieni honshan Mexiha, ede shizijia jierese bouzhesha, bijien uzhedene xianxin gieye.\" Hhantu ghadasan kunlaye sugiezho. ");
INSERT INTO sce_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Zhunwuse xiawu 3 jien olutula zemin man kharalazho. ");
INSERT INTO sce_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","3 jien oluse Ersa fugiede, \"Ili, Ili, lamasabagedani?\" giezhi waradazho. Isishi, \"Mii Huda, mii Huda, chi mii yangiezhi ulie gonjine?\" giezho. ");
INSERT INTO sce_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kanzide beisan niezhan kunla chenliedene kieliezho, \"Uzhe, hhe Iliyani waradazho.\" ");
INSERT INTO sce_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nie kun holuzhi echi, haimiende cui zhanji, ghulusun jiere banla hhende ughadene kieliezho, \"Gouji saghei, matan Iliya hhei bouzheghale irenu ulie irekui uzheye.\" ");
INSERT INTO sce_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ersa fugiede nie warada, ho sirawo. ");
INSERT INTO sce_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ingiekude dajienni sudorodu menlienzi jierese doura kei echidene ghua gholuwo. ");
INSERT INTO sce_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Duimiende beisan baifuzhan Ersa ingiezhi ho sirasei chanladene kieliewo, \"Ene kunshi zhenzhenji Hudai kewon enbene!\" ");
INSERT INTO sce_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Pse giedun biereila gholose uzhezho. Hhelai dunda Modalani Mereiyen, ga Yagebu, Yusei ghualai anani Mereiyen, Salomi wo. ");
INSERT INTO sce_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ErsaJialilide bikude daghazhi ushilasan kunla wo. Pse Ersase hhantu Yelusalende iresan olon biereilaye uzhezho. ");
INSERT INTO sce_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Eneshi zhunbei gieku udu, Hhamuraku uduni melieshi niudu wo. ");
INSERT INTO sce_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Khara oluse Yalimataini Yusufu irewo. Hheshi fugie fayenni nie noyen wo, kunla man zunjine. Hheye Hudai gojiani sagheizho. Hhe danzine fugiedagha Biladoi ochirale oro Ersai beyei xiahua giezhi kerewo. ");
INSERT INTO sce_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","BiladoErsa ijin duya ijiewo giese ghaniradene baifuzhanyi uruzhi ire Ersa duya ijiezhi nietan oluwoye giezho. ");
INSERT INTO sce_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Bilado baifuzhanse qinkonyi mejiedene Ersai beyeni Yusufude ogiwo. ");
INSERT INTO sce_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yusufu bosii baerghala agi ire beyeni agi bouzhe boside boui goudagha tashide waisan mezade teiwo. Tashii ghoghoreighazhi meza kouzii duighawo. ");
INSERT INTO sce_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Modalani Mereiyen, Yuseini anani Mereiyen beyeni teisan oronyi uzhezho. ");
INSERT INTO sce_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Hhamuraku udu daose Modalani Mereiyen, Yagebui anani Mereiyen, Salomi enela Ersai beye jiere fureine giezhi xianlio agiwo. ");
INSERT INTO sce_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Xinqini ogheikude hhela mezade irewo. ");
INSERT INTO sce_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Matande tashii meza kouzise kien ghoghorei daoghane giezhi nieniedene kielienduzho. ");
INSERT INTO sce_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Hhela nie uzhese tashi ghoghorei daozho. Hhe tashi fugie no wo. ");
INSERT INTO sce_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Hhela mezade orodene uzhese nie nasuchighan kun borun miende souzho. Chighan fudu jien musizho. Hhela hende ayizho. ");
INSERT INTO sce_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nasuchighan kun kieliezho, \"Bu ayi! Ta shizijia jiere ghadasan Nasaleni Ersai ereizhou? Hhe aminne oluzho. Enende uwo. Hhei jiesan oronni ta uzhe. ");
INSERT INTO sce_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ta echidene tujiladeni Bedurude kielie, hhe tanse melie Jialilide echine. Tande melieshida kieliesan mutun ta hhende hhei chanlane gie.\" ");
INSERT INTO sce_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Hhela hende ayizhi pugharadene mezase khirei holuzho. Ayizhi kunlade yama ese kieliezho. (Ersa hhelade fenfulasanlai man Bedurutande jiendande kieliewo. Khuinashi Ersa tujilai tungo giezhi zhiguitu, ulie widaku, chanqi jiuiku daolini dunmiense ximiende kutula chonjiwo. Amine.) ( ");
INSERT INTO sce_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Xinqii eqiemagha Ersa aminne oludene xien Modalani Mereiyende chujiegheghazho. Ersa melieshida hhei jierese dolon sheitan tou khighazho. ");
INSERT INTO sce_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Hhe echidene nango giezhi wilazhi sousan tujilade kieliewo. ");
INSERT INTO sce_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Hhela Ersa aminne oluzhi Mereiyende chujiegheghawo giesei chenliedene xianxin ese giezho.) ( ");
INSERT INTO sce_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Enense khuinashi tuji dundadu ghuala xiande echine giezhi mo jiere yokude Ersa pse nie yanzighala chujiegheghawo. ");
INSERT INTO sce_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Hhela echidene psedu tujilade kieliese xianxin ese giezho.) ( ");
INSERT INTO sce_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Khuinashida 11 gie tujila ijiekude Ersa hhelade chujiegheghawo. Hhela Ersa aminne oludene chanlawo giesan kunlai xianxin ese giese Ersa hhelai zhughe khidun, xianxin ese giewo giezhi kheilazho. ");
INSERT INTO sce_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Pse hhelade kieliewo, \"Ta qienxiade man echizhi gouxioxii soyuji zhayaghasanlade chonji. ");
INSERT INTO sce_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Xianxin giezhi xilii jienliese jiuine, xianxin ulie giese zui jinjine. ");
INSERT INTO sce_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Xianxin giesan kunla enezighan ghudureqilai giene. Mii niereghala sheitan toune. Shini kielien kieliene. ");
INSERT INTO sce_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Khaghala moghei bareizhi yan du ochiliuzhe yama ulie giene. Khane gientulai jiere teise gien goudane.\") ( ");
INSERT INTO sce_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ezhan Ersa hhelade kielie baludene hhei asiman jiere jienlie khirei Hudai borun miende soughawo. ");
INSERT INTO sce_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tujila khizhi gochude gouxioxii chonjise Ezhan hhelare hhantu wilie giezho. Ghudureqila daghazhi Hudai kielienyi chonjisande ganzhen beizho. Amine.)");
INSERT INTO sce_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Qiafeilo noyen! Olon kun bijienni dunda fashen giesan shiqinyi huaizho. ");
INSERT INTO sce_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Huaisanlashi Hudai kieliende wilie giechen kunla zui melieshidase nudundene qinsi uzhedene bijiende chonjisan mutun wo. ");
INSERT INTO sce_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ene shiqinlani bi melieshida xianxide chaizhi daowo. Ingiese biye chade nienieji huaizhi ");
INSERT INTO sce_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","chi surusanlai man zhenni bikui mejieghane giezho. ");
INSERT INTO sce_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","HherodeYudayani honshan danlakude nie buwa wo, niereini Sajialiya giene. Yabiyani duide wo. Hheni biereishi Hharuneni houdei wo, niereini Ilishabai giene. ");
INSERT INTO sce_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Hhe ghualashi Hudai melie gou kun wo. Hudai minlin, guijinni zunjizhi man giezho, yama kieliekui uwo. ");
INSERT INTO sce_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Hhelade zinie kewosi uwo. Ilishabai kewosi olu dane, ede hhe ghuala oqioluwo. ");
INSERT INTO sce_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Niefade Sajialiyani nie duide buwani wilie gieku linjizhi kuzhese hhe Hudai melie wilie giekude ");
INSERT INTO sce_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","buwani xigonghala gangan chouidene Ezhanni giede oro xian jienjiwo. ");
INSERT INTO sce_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Xian jienjikude bexinla man ghadane onxian giezho. ");
INSERT INTO sce_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Menzhali Ezhanni qienxien xianlu shireni borun miende beizhi Sajialiyade chanlaghawo. ");
INSERT INTO sce_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sajialiya chanladene jinda hende ayizho. ");
INSERT INTO sce_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Qienxien hhende kieliewo, \"Sajialiya, bu ayi! Chini onxianni Huda chenliewo. Chini bierei Ilishabai chade nie kewon olune. Chi hhende Yaheiya giezhi niere ogi. ");
INSERT INTO sce_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Chi hende bayasune. Hhei oluse olon kunlaye bayasune. ");
INSERT INTO sce_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Hhe Ezhanni melie fugie kun gholune. Putoujiu, yama jiu ulie ochine, anane kielise Shenlinghala duruzho. ");
INSERT INTO sce_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Hhe olon Isilie kunlai Ezhan Hudai miende khareizhi ireghane. ");
INSERT INTO sce_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Hhe irese xienzhi Iliyani jinshen, nenli winezhi Ezhanni melie zhunbei giene. Adalai kesilarene goudaghane, kielien ulie chenliechen kunlai gouni sumulakude khareighane. Ingiezhi kunlai Ezhanni melie zhunbei gieghane.\" ");
INSERT INTO sce_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sajialiya qienxiende kieliewo, \"Bi pin yanzhe eneni mejiene? Bi oqioluwo, biereimiye oqioluwo.\" ");
INSERT INTO sce_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Qienxien kieliewo, \"Bishi Hudai melie beisan Zhebereiye wo. Mini peizhi chade ene gouxioxini kielieghale irewo. ");
INSERT INTO sce_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Uzhe, hhe shihou kuzhese mini kieliende kurunema, ene shiqin kuzhetula chi yaba gholune. Chi mini kielienni xianxin ese giewo.\" ");
INSERT INTO sce_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ingiekude Sajialiya Ezhanni giese dou ese khizhese sagheisan kunla ghudurezho. ");
INSERT INTO sce_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sajialiya khizhese hhelade kielien kielie dane, yaba gholudene khaghalane kieliese hhela hhe Ezhanni giede yama chanlawo giezho. ");
INSERT INTO sce_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Hhe wilie giezhi ududei kuruse giedene echiwo. ");
INSERT INTO sce_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Enense khuinashi hheni bierei Ilishabai kewosi laidene tawun sara kiemade ese chujiegheghazho. ");
INSERT INTO sce_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Hhe kieliewo, \"Ezhanni nenjien fugie no wo. Mini zhaogu giekude ingiezhi giedene kunlai dundase mini shizhekuni widaghawo.\" ");
INSERT INTO sce_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ilishabai zhighon sara laikude Huda Zhebereiye qienxienni peizhi Jialilini Nasale giesan chenshii nie oqinde echighawo. ");
INSERT INTO sce_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Hhe oqinni niereini Mereiyen giene, Dawude honshanni houdei Yusufude boluzho. ");
INSERT INTO sce_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Qienxien orodene hhende kieliewo, \"Chi gou onu? Hudai nenjien chade fugie no wo. Huda chighala hhantu wo.\" ");
INSERT INTO sce_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mereiyen chenliedene jindazhi eneshi yan isi wo giezhi sumulazho. ");
INSERT INTO sce_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Qienxien Mereiyende kieliewo, \"Bu ayi! Huda chade nenjien ogiwo. ");
INSERT INTO sce_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Uzhe, chi laizhi nie kewon olune. Hhende Ersa giezhi niere ogi. ");
INSERT INTO sce_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Hhe fugie kun gholuzhi kunla jianlai hhei Zui Undu Ezhanni Kewon giezhi urune. Ezhan Huda hhende xienren Dawudeni wizini ogine. ");
INSERT INTO sce_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Hhe Yagebuni giede chan honshan danlane. Hhe chanqi gonjizhi qienli ulie widane.\" ");
INSERT INTO sce_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mereiyen qienxiende kieliewo, \"Mii dou ese dafalazho. Matugie imutu shiqin wine?\" ");
INSERT INTO sce_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Qienxien kieliewo, \"Shenlin chini jiere irene. Zui Undu Hudai nenli chii jiere irezhi huine. Ingiese oluku zhiguitu kewonni Hudai Kewon giezhi urune. ");
INSERT INTO sce_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Uzhe, chii qingu Ilishabai oqioludene nie kewon laiwo. Kunla kieliese hheshi nie ulie oluchen kun wo giezho, ede laizhi zhighon sara oluwo. ");
INSERT INTO sce_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Hudade nengou wituni uwo.\" ");
INSERT INTO sce_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ingiese Mereiyen kieliewo, \"Bishi Ezhanni hoji wo. Chi kieliesan mutun made gholu gie.\" Ingiedene qienxien likai giewo. ");
INSERT INTO sce_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Oloncha ese oluse Mereiyen zhunbei gie jindazhi ulatu Yuda oronni chenshide echiwo. ");
INSERT INTO sce_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sajialiyani giede orodene Ilishabaide salan giewo. ");
INSERT INTO sce_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","IlishabaiMereiyenni salanni jienliekude kieliini kewosi jiulizho. Ingie Ilishabai Shenlinghala durudene ");
INSERT INTO sce_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","fugiede doulazhi kieliewo, \"Biereila dunda chade fuqi zui fugie wo. Chi oluku kewondeye fuqi fugie wo. ");
INSERT INTO sce_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Mii Ezhanni ana enende irese matui olune? ");
INSERT INTO sce_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Uzhe, chii shenqini chenliekude mii kielini kewosi bayasuzhi jiulizho. ");
INSERT INTO sce_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ezhan kieliesan shiqin chenjikui xianxin giesan chade fuqi wine.\" ");
INSERT INTO sce_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mereiyen kieliewo. \"Zhughemi Ezhan fugie wo giezho. ");
INSERT INTO sce_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ruhhermi mii jiuichen Hudade oluzhi bayasuzho. ");
INSERT INTO sce_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Hhe imutu meila hojii zhaogu giewo. Uzhe, enedu khuinase soyuji kunla made fuqi wine giezhi kieliene. ");
INSERT INTO sce_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Nenlitu Huda made fugie shiqin giewo, hhei niere zhigui wo. ");
INSERT INTO sce_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Hhei zunjisan kunlade zuzubeibeide ubali xiine. ");
INSERT INTO sce_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Hhe beghelieghalane lilianni uzheghawo. Sudorone hu sumulazhi goyane fugiede huichen kunlai sanda widaghawo. ");
INSERT INTO sce_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Qienli bitu kunlai boghonidaghawo. Qienli witu kunlai undudaghawo. ");
INSERT INTO sce_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Oliesuchen kunlade gouni ogizhi chudughawo. Bayan kunlai khosun kha echighawo. ");
INSERT INTO sce_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Hhe Isilie hojidene banman giewo. ");
INSERT INTO sce_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Yenjisan kielien mutun Iburaheimuji houdeiladeni chanqi ubali xiikui ese matazho.\" ");
INSERT INTO sce_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","MereiyenIlishabaighala hhantu chabudu ghuran sara soudene giedene echiwo. ");
INSERT INTO sce_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ilishabai oluku shihouni kurudene nie kewon oluwo. ");
INSERT INTO sce_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Giebeilane, jiawulani Ezhan Ilishabaide fugie nenjien ogisei mejiedene hhantu man bayasuzho. ");
INSERT INTO sce_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Neimudu kurudene kunla kewonni hetoune giele irewo. Adaini niere mutun hhende Sajialiya giezhi niere ogine giezho. ");
INSERT INTO sce_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ingiese anani kieliewo, \"Ulie olune, hhei niereni Yaheiya gie.\" ");
INSERT INTO sce_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kunla hhende kieliewo, \"Chii jiawude imutu niere uwo.\" ");
INSERT INTO sce_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ingie adadei khaghala uzheghazhi, \"Kewosii niereini yan giene?\" giezhi asawo. ");
INSERT INTO sce_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Adani nie banba keredene, \"Hhei nierei Yaheiya giene.\" giezhi huaiwo. Ingiese kunla man ghanirawo. ");
INSERT INTO sce_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Hhe xienzide Sajialiyani amanni keidene kielienni goudasenu Hudade doulazho. ");
INSERT INTO sce_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Zhouwide sousan kunla man ayizho. Ene shiqinni ulatu Yudaya oronde man chonji kurughawo. ");
INSERT INTO sce_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ene shiqinyi chenliesan kunla man zhughedene sumulazhi ene kewon jianlai matui gholuse giezho. Ingiekushi Ezhanni nenli hheghala hhantu wo. ");
INSERT INTO sce_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Hhei ada Sajialiyade Shenlin durudene Hudai kielienyi deilazhi kieliewo. ");
INSERT INTO sce_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","\"Ezhan Isilieni Hudade doulakuni wo. Hhe bexinlane zhaogu giezhi shuiwo. ");
INSERT INTO sce_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Matande oluzhi goya hoji Dawudeni houdeise fugie nenlitu jiuichen khizheghawo. ");
INSERT INTO sce_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Eneshi melieshida Huda zhiguitu xienzhilai tungo giezhi kieliesanghala niekielien wo, ");
INSERT INTO sce_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","'Huda bijienyi henjisan kunlai, duitoulani khase jiuiwo. ");
INSERT INTO sce_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Matanni xienrenlade ubali xiizhi yenjisan zhiguitu kielienne uye matazho. ");
INSERT INTO sce_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Eneshi hhe matanyi xienren Iburaheimude yenjisan wo. ");
INSERT INTO sce_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Mai duitoulai khase jiuisenu Hudai melie beighadene ulie ayizhi zhigui, gundande ibeizi shunjighane. ");
INSERT INTO sce_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Kewon, chii Zui Undu Hudai xienzhi giezhi urune. Chi Ezhanni melie yozhi moni zhunbei giene, ");
INSERT INTO sce_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ezhanni bexinlai zuini mienliezhi jiuiku nenjienni mejieghane. ");
INSERT INTO sce_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Matai Huda ubali xiizhi zhugheni zholien wo. Hhe eqiemaghaku naranyi asiman jierese matai jiere ireghazhi ");
INSERT INTO sce_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Khara oron, fuguku xiojiededu sousan kunlai giegheraghadene uduruzhi pinnan mode yoghane.'\" ");
INSERT INTO sce_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Hhe kewonyi beye fugiedazhi zhanjin wo. Isilieni kunlai melie khizhezhi wilie gietula hontande souzho. ");
INSERT INTO sce_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Hhe shihoude Kaisa Honshan Aogusidu minlin xiaizhi qienxiani kunlai man hukou banji giezho. ");
INSERT INTO sce_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Eneshi JiliniuXiliyani oronde shenzhan danlaku shihoude tou 1 hui hukou banjighasan wo. ");
INSERT INTO sce_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ingie kunla man goya loujiadene hukou banjile echiwo. ");
INSERT INTO sce_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yusufushi Dawude honshanni houdei wo, ingiese hheye Jialilini Nasale chenshise Bolihen giesan Yudaya orondedu Dawude Chenshide khizhi echiwo. ");
INSERT INTO sce_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Hhende bolusan Mereiyen ghuala hhantu hukou banjile echiwo. Hhe xienzide Mereiyen kewosi laizho. ");
INSERT INTO sce_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Hhela hhende bikude Mereiyen oluku shihou kuzhewo. ");
INSERT INTO sce_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Toushude nie kewon oluwo. Lishede oron widadene popude boui onghochode kijieghawo. ");
INSERT INTO sce_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Hhe oronde xieni ghoni adulasan kunla ghadane ghonilai sagheizho. ");
INSERT INTO sce_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ezhanyi qienxien hhelade xienjighazhi Ezhanni gon simiense zhouise ghoni adulachen kunla hende ayizho. ");
INSERT INTO sce_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Qienxien kieliewo, \"Bu ayi! Uzhe, bi soyuji kunlade olusan hende bayasuku gouxioxini tande boulaye. ");
INSERT INTO sce_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Enedu Dawude Chenshide tande nie Jiuichen oluwo, hheshi Ezhan Mexiha wo. ");
INSERT INTO sce_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ta nie yeliwai chanlane. Popude bouidene onghochode kijieghazho. Eneshi jihao wo.\" ");
INSERT INTO sce_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Menzhali asiman jieredu idaban budui hhe qienxienghala hhantu Hudade doulazho, ");
INSERT INTO sce_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","\"Asiman jiere Hudai kuai. Zemin jiere Huda xiqi bisan kunlade pinnan wo!\" ");
INSERT INTO sce_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ingie qienxienla likai giedene asiman jiere khireiwo. Ghoni adulachen kunla nieniedene \"matan Bolihende yoye. Huda matande kieliesan shiqin matui gholukuni nie uzheye\" giezho. ");
INSERT INTO sce_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Hhela jindazhi echidene Mereiyen, Yusufu, pse nie onghochode kijieghasan yeliwai chanlawo. ");
INSERT INTO sce_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Hhela uzhedene qienxien ene kewonde kieliesan shiqinni kunlade man kieliewo. ");
INSERT INTO sce_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ghoni adulachen kunla kieliesan shiqinyi kunla chenliedene ghudure wo giezhoma, ");
INSERT INTO sce_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mereiyen ene shiqinyi man zhughedene jilazhi izhi sumulazho. ");
INSERT INTO sce_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ghoni adulachen kunla khareizhi echikude Hudade kuaizhi doulazho. Hhela uzhesan, chenliesanla qienxien kieliesanghala niekielien wo. ");
INSERT INTO sce_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Neimudu kuru ga kewonni hetoune giedene niereini Ersa giewo. Eneshi kewosii laiku melie qienxien ogisan niere wo. ");
INSERT INTO sce_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Musani shu jiere kieliesan waghaku udu kurudene MereiyenYusufughala Yelusalen chenshide kewonne Hudade khughozhi echighawo. ");
INSERT INTO sce_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ezhanni guijinshu jiere huaizho, \"Laoda kewonlani man zhiguishighazhi Hudade ogi.\" ");
INSERT INTO sce_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Pse Ezhanni guijinshu jiere huaizhi ghua yegu onu, ghua ga ghoghochen ogi giezho. Hhela ingiezhi giewo. ");
INSERT INTO sce_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Yelusalende nie kunni niereini Ximien giene. Hheshi nie gou kun wo, jiomun jiereye chighara wo, chanqi Isilie kunni jiuise giezhi panjizho. Hhende Shenlin duruzho. ");
INSERT INTO sce_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Duya ijieku melieshida kenjin Ezhan kieliesan Mexihani uzhene giezhi Shenlin mejieghawo. ");
INSERT INTO sce_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Shenlin hhei uduruzhi mechide ireghawo. Ersai ana adani zhao guijinni yoqiu mutun shiqin banjile irekude ");
INSERT INTO sce_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ximien kewonni qiorudene Hudai nierei fugiedaghazhi doulawo, ");
INSERT INTO sce_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","\"Ezhan, chi yenjisan kielien mutun ede hojii duyase pinnan andaghazho. ");
INSERT INTO sce_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Chi jiuikuni bi qinsi uzhewo. ");
INSERT INTO sce_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Eneshi chi olon minzulade zhunbei giesan wo. ");
INSERT INTO sce_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Niman kunlade Hudai mejieghaku gon wo. Goya bexin Isilie kunni minshen wo.\" ");
INSERT INTO sce_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ada anani hhe kewonde kieliesei chenliedene ghanirawo. ");
INSERT INTO sce_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ximien hhelade oluzhi onxian giedene kewonni ana Mereiyende kieliewo, \"Isilie kunlai dunda ezighan kunla ene kewonni bayasuzhi jienliene, ezighan kunla fandui giene. Kunla hhei sugienduzhi duitou gholune. ");
INSERT INTO sce_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Kunla zhughedene yan sumulakuni hhe man mejieghane. Chii zhugheye khudoghoghala chujiku mutun gholune.\" ");
INSERT INTO sce_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Pse hhende nie bierei xienzhi wine. Niereini Yana giene, Yasheni jiawuni Faneilini oqin wo, hende oqioluwo. Dafalasenu 7 nien soudene ");
INSERT INTO sce_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","guafu feiliezhi 84 nien niezheghan souzho. Hhe mechise likai ulie giedene xieni udu orozo bareizhi onxian giedene Hudai shunjizho. ");
INSERT INTO sce_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Hhela jian kielien kielieku shihoude Yana hhelani yo penjidene Hudade mafan giezhi Yelusalenyi jiuise giezhi sagheichen kunlade Ersani shiqinyi kieliewo. ");
INSERT INTO sce_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","YusufuMereiyen ghuala zhao Hudai shu jiereshiku mutun shiqinni man banjizhi baraghadene khareizhi Jialilini Nasale chenshidene echiwo. ");
INSERT INTO sce_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ersani beye fugiedazhi hendazhi agheli olodozho. Hudai nenjien hhei jiere wo. ");
INSERT INTO sce_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Niehonnie Jiulidaosan Jie kuzhese ada anani Yelusalende khizhi echizho. ");
INSERT INTO sce_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ersa 12 olukude hhela zhao hhe xigonghala jieqi daoghale echiwo. ");
INSERT INTO sce_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Jieqi baludene giedene khareikude ErsaYelusalende feiliewo. Ana adani ulie mejiene. ");
INSERT INTO sce_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Hhela sumulase hhantu yozho. Niudu yodene widasei mejie, qingu zhelienladene asazhi ereizho. ");
INSERT INTO sce_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ereizhi olu dadene khareizhi Yelusalende ereile echiwo. ");
INSERT INTO sce_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ghurudude Ezhanni giese ereizhi oluwo. Ersa loushilai dunda souzhi niemiende chenliezho, niemiende asazho. ");
INSERT INTO sce_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Jien hhenughunyi chenliesanla man hhe cunmin wo, huida giesan gou wo giezhi ghanirazho. ");
INSERT INTO sce_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ada anani hhei chanladene uzhe beizho. Anani Ersade kieliewo, \"Mini kewon, chi ingiezhi bijienni ereighazhi yangiene? Uzhe, bi adachinighala izhigie zhughe chilazhi ereizho.\" ");
INSERT INTO sce_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ersa kieliewo, \"Mini ereizhi yangiene? Bi indan Adane giede bikuni ta mejie danu?\" ");
INSERT INTO sce_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Hhela kielienyini dunjire dazho. ");
INSERT INTO sce_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ingie Ersa hhantu Nasalede khareidene ada anane kielienyi chenliezhi giezho. Anani ene shiqinyi zhughedene goude jilazho. ");
INSERT INTO sce_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ersani beye yebeiseye fugiedazhi agheli olodozho. Huda kunla man Ersade bayasuzho. ");
INSERT INTO sce_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Qibiliu fugie honshan danlazhi 15 nien olukude Benjiu-BiladoYudayade shenzhan danlazho. HherodeJialilide on danlazho, jiuni FeiliItuliyaji Telakenide on danlazho, LisanieYabilinide on danlazho. ");
INSERT INTO sce_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Yanasi, Gaiyafaghala zui fugie buwa danlazho. Hhe shihoude Hudai kielien Sajialiyani kewon Yaheiyade bouzhewo. Yaheiya hontande souzho. ");
INSERT INTO sce_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Hhe Yedanheni hhemien enemiende yozhi kunlade xili gieghazhi, \"Ta geizhen giendu, Huda tai zuini rouliene.\" giezhi chonjizhi kieliezho. ");
INSERT INTO sce_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Isaiya xienzhini shu jiere huaizho, \"Hontande nie kun waradazho, 'Ezhanni moni zhunbei gie! Hhei moni zhidagha! ");
INSERT INTO sce_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ghonni man jienjizhi pindaghane. Fugie ula ga ulalani man pindaghane. Onjisan molani zhidaghazhi goudaghane. Oko danlanlani pienjizhi goudaghane. ");
INSERT INTO sce_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ingiese kunla man Hudai jiuikuni uzhene.'\" ");
INSERT INTO sce_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yaheiya xili jienliele iresan kunlade kieliewo, \"Du mogheini zhunzhughala, kien tande jianlai ireku Hudai hokukuse anda shidane giezhi kieliewo? ");
INSERT INTO sce_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ta geizhen giesanne giekughala zhenmin gie. Iburaheimushi bijienyi xienren wo giezhi ta zhughedene bu sumula. Bi tande kielieye, Huda ene tashilani Iburaheimuni houdei gholugha shidane. ");
INSERT INTO sce_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ede sugiei mutun genzide teiwo. Gou alima ulie souku mutunlani man chizhidene khande teine.\" ");
INSERT INTO sce_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kunla asawo, \"Qingiese bijien matugiene?\" ");
INSERT INTO sce_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yaheiya kieliewo, \"Ghua jien bisan kunla jien witu kunlade ogi. Ijiewuni bisan kunla ye qingiezhi gie.\" ");
INSERT INTO sce_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Shui shanjisan kunlaye xili giele iredene asawo, \"Loushi, bijien matugiese gouwo?\" ");
INSERT INTO sce_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yaheiya kieliewo, \"Zhao hhe shuzighala kere, hhense olon bu kere.\" ");
INSERT INTO sce_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Pse niezhan buduilaye asawo, \"Bijien matugiese gou wo?\" Yaheiya kieliewo, \"Kunlani ayighazhi baer bu kere. Kunlai hu bu zha. Tande ogisan gunzi kuzho gie.\" ");
INSERT INTO sce_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Hhe shihoude kunla man Mexihani panjizho. Ingiese kunla zhughedene sumulazhi Yaheiyashi Mexiha wo giezho. ");
INSERT INTO sce_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yaheiya hhelade kieliewo, \"Bi usughala tai xili gieghazhoma, mase khuina irechen kun mase nenli fugie wo. Bi hhende mahei deizi andaghaseye pei dane. Hhe Shenlin, khanghala tai xili gieghane. ");
INSERT INTO sce_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Hhe khadene baqi bareizhi tughonni boudeii baqiliezhi agidene cankude zhonlone. Arasunlai ulie xinieku khande teine.\" ");
INSERT INTO sce_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yaheiya pse olon kielienghala kunlade gouxioxini jianjizhi kieliewo. ");
INSERT INTO sce_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Melieshida Hherode on jiune bierei Xilojini agiwo. Hhe melieshidase huaishi olon giewo. Yaheiya hheni kheilasenu ");
INSERT INTO sce_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","pse nie huaishi giezhi Yaheiyani bafanzide khawo. ");
INSERT INTO sce_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Yaheiya kunlai xili gieghakude Ersaiye hhantu gieghawo. Ersa onxian giekude asiman keidene ");
INSERT INTO sce_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Shenlin hhei jiere bouzhewo. Yanzini ghoghochenyi xianli. Ingiedene asiman jierese shenqi irezhi kieliewo, \"Chishi bi oresan kewon wo. Bi chade xiqi wo.\" ");
INSERT INTO sce_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ersa chonji keise chabudu 30 olune. Kunla uzhese Ersashi Yusufuni kewon wo. Yusufushi Xilini kewon wo. ");
INSERT INTO sce_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Xilishi Matani kewon wo. Matashi Liwini kewon wo. Liwishi Maijini kewon wo. Maijishi Yanaini kewon wo. Yanaishi Yusufuni kewon wo. ");
INSERT INTO sce_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusufushi Mataqiyani kewon wo. Mataqiyashi Yamosini kewon wo. Yamosishi Nahunni kewon wo. Nahunshi Isilini kewon wo. Isilishi Nagaini kewon wo. ");
INSERT INTO sce_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaishi Mayani kewon wo. Mayashi Mataqiyani kewon wo. Mataqiyashi Ximeini kewon wo. Ximeishi Yesekeni kewon wo. Yesekeshi Yedani kewon wo. ");
INSERT INTO sce_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yedashi Yehananni kewon wo. Yehananshi Lisani kewon wo. Lisashi Solobaboni kewon wo. Solobaboshi Salaqieni kewon wo. Salaqieshi Nilini kewon wo. ");
INSERT INTO sce_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nilishi Maijini kewon wo. Maijishi Yajini kewon wo. Yajishi Gesanni kewon wo. Gesanshi Imodanni kewon wo. Imodanshi Erni kewon wo. ");
INSERT INTO sce_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ershi Yeshuyani kewon wo. Yeshuyashi Iliixieni kewon wo. Iliixieshi Yelinni kewon wo. Yelinshi Matani kewon wo. Matashi Liwini kewon wo. ");
INSERT INTO sce_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Liwishi Ximienni kewon wo. Ximienshi Yudani kewon wo. Yudashi Yusufuni kewon wo. Yusufushi Yenanni kewon wo. Yenanshi Iliyajinni kewon wo. ");
INSERT INTO sce_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Iliyajinshi Miliyani kewon wo. Miliyashi Mainanni kewon wo. Mainanshi Madatani kewon wo. Madatashi Nadanni kewon wo. Nadanshi Dawudeni kewon wo. ");
INSERT INTO sce_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawudeshi Yexini kewon wo. Yexishi Ebeideni kewon wo. Ebeideshi Boasini kewon wo. Boasishi Samenni kewon wo. Samenshi Nashunni kewon wo. ");
INSERT INTO sce_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashunshi Yaminadani kewon wo. Yaminadashi Yaminni kewon wo. Yaminshi Yanini kewon wo. Yanishi Xisilunni kewon wo. Xisilunshi Falesini kewon wo. Falesishi Yudani kewon wo. ");
INSERT INTO sce_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yudashi Yagebuni kewon wo. Yagebushi Isagheini kewon wo. Isagheishi Iburaheimuni kewon wo. Iburaheimushi Talani kewon wo. Talashi Naheni kewon wo. ");
INSERT INTO sce_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naheshi Xiluni kewon wo. Xilushi Lawuni kewon wo. Lawushi Faleni kewon wo. Faleshi Iboni kewon wo. Iboshi Shalani kewon wo. ");
INSERT INTO sce_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shalashi Gainanni kewon wo. Gainanshi Yafasani kewon wo. Yafasashi Shemuni kewon wo. Shemushi Nuhhani kewon wo. Nuhhashi Lamaini kewon wo. ");
INSERT INTO sce_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamaishi Matusalani kewon wo. Matusalashi Idileisini kewon wo. Idileisishi Yareni kewon wo. Yareshi Malelieni kewon wo. Malelieshi Gainanni kewon wo. ");
INSERT INTO sce_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Gainanshi Inoshini kewon wo. Inoshishi Saiteni kewon wo. Saiteshi Adanni kewon wo. Adanshi Hudai kewon wo. ");
INSERT INTO sce_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ersa Shenlinghala durudene Yedanhese irewo. Shenlin hhei uduruzhi hontande echidene ");
INSERT INTO sce_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ibilisi 40 qien shiizho. Hhe udulade Ersa yama ese ijiezhi udu kuruse oliesuzho. ");
INSERT INTO sce_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ibilisi kieliewo, \"Chi Hudai Kewon enbese ene tashii fenfulazhi ginan gholugha.\" ");
INSERT INTO sce_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ersa hhende kieliewo, \"Jinwun jiere huaizho, 'Kun amitushi zinie ginande ulie kouine.'\" ");
INSERT INTO sce_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ibilisi hhei uduruzhi khireidene nie shanjien giekude duyani soyuji gojialani man uzheghawo. ");
INSERT INTO sce_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Hhende kieliewo, \"Ene gojialani qienli, zui gounilai man chade ogiye. Eneshi minughun wo. Bi kiende ogiku duranshi kiende ogine. ");
INSERT INTO sce_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Chi mii beiise enela man chinughun gholune.\" ");
INSERT INTO sce_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ersa hhende kieliewo, \"Jinwun jiere huaizho, 'Zinie Ezhan Hudane beiizhi hhei shunji.'\" ");
INSERT INTO sce_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ingiedene Ibilisi Ersai uduruzhi Yelusalende echi mechii zui undu oronde beigha kieliewo, \"Chi Hudai kewon enbese enense jiuli bou. ");
INSERT INTO sce_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Jinwun jiere, 'Hhe chade oluzhi qienxienladene fenfulazhi chii baohu giene. ");
INSERT INTO sce_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Khaghalani chii feizhi konnichii tashi jiere ulie mughughane.' giezhi huaizho.\" ");
INSERT INTO sce_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ersa hhende kieliewo, \"Ezhan Hudane bu shii giezhi jinwun jiere kieliezho.\" ");
INSERT INTO sce_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ibilisi ingiezhi shiidene pse gou jihui iretula Ersase likai giewo. ");
INSERT INTO sce_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ingiedene Ersade Shenlinni nenli duruzhi Jialilide khareizhi irewo. Minshenyini kunla man zhouwide kieliezho. ");
INSERT INTO sce_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ersa hhelai huitanlade sughazhi qiise kunla hhe surughasan gou wo giezho. ");
INSERT INTO sce_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ersa goya fugiedasan Nasalede irewo. Hhamuraku udude chanqiku guijinghala huitande orowo. Jinwun onshine giezhi beise ");
INSERT INTO sce_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","kunla Isaiya xienzhini shuni hhende ogiwo. Hhe keighadene ereizhi idon onshiwo, ");
INSERT INTO sce_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","\"Ezhanni Ruhher mini jiere wine. Mii sunghuzhi jiahui kunlade gouxioxini chonjighawo. Hhe mini peizhi kunlade man kielieghawo. Bareisan kunlai andaghane. Nudun sugho olusan kunlai goudaghane. Qifulasan kunlai pse ulie qifulaghane. Huda jiuiku shihou kuzhewo.\" ");
INSERT INTO sce_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ersa jinwunni horo agi gonjisan kunde ogidene souwo. Huitanni kunla man hhei xianxide uzhezho. ");
INSERT INTO sce_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ersa hhelade kieliewo, \"Enedu ene jinwun tani dunda chenjiwo\". ");
INSERT INTO sce_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kunla man kieliezhi ene kun oluzho giezho. Jianjisan kielienyini chenliedene kunla man ghudurezhi eneshi Yusufuni kewon pushonu giezho. ");
INSERT INTO sce_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ersa hhelade kieliewo, \"Ta kenjin 'Daifu, chi goyane goudagha.' giesan kienni kielienghala made kieliezhi 'Bijien chenliese Jiabainunde chi giesan fugie shiqinyi goya aghindeneye gie.' giezhi kieliene.\" ");
INSERT INTO sce_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ersa pse kieliewo, \"Bi tande shuhua kielieye, xienzhini goya aghindene jienliechen kun uwo. ");
INSERT INTO sce_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Bi tande shuhua kielieye, Iliya xienzhini shihoude 3 nienban ghura ese bouzhi honnien gholukude Isiliede guafu olon woma, ");
INSERT INTO sce_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Iliyai khalama ese echighadene Xidun oronni Salefani guafude peizhi echighawo. ");
INSERT INTO sce_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Pse Ilisha xienzhini shihoude Isiliede pifugientu olon woma, zinie Xiliyani Naimanni goudaghawo.\" ");
INSERT INTO sce_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Huitanni kunla chenliedene hende hokuzho. ");
INSERT INTO sce_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ingie kunla man bosi iredene Ersani laizhi chenmen ghadane khireighawo. Hhe chenshi ula jiere wo. Hhela Ersani laizhi eghei ghizhade echidene tunguzhi boughane giese, ");
INSERT INTO sce_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ersa kharei hhelani dundaghun yo dao wo. ");
INSERT INTO sce_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ingiedene ErsaJialilini nie chenshi Jiabainunde bouzhi echiwo. Hhamuraku udude kunlade sughazhi kieliezho. ");
INSERT INTO sce_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Chenliesan kunla hhe sughasande ghanirazho, hhe kieliesande qienli wine. ");
INSERT INTO sce_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Hhe huitande nie kunni sheitan heizho. Fugiede waradazhi kieliewo, ");
INSERT INTO sce_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","\"Ei! Nasale kun Ersa, chi bijienyi jiohoro bu gie. Chi bijienyi widaghale irewu? Chishi kien bikui bi mejiene. Chishi Hudase iresan hhe zhiguitu wo.\" ");
INSERT INTO sce_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ersa hhei sugiezhi kieliewo, \"Amanne menji. Ene kunni jierese khizhe!\" Sheitan hhe kunni kunlai melie benda kijieghadene jieresei khizhewo. Hhe kunyi yama ese shanjiwo. ");
INSERT INTO sce_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kunla man ghanirazhi nieniedene kielienduzho, \"Ene daoli zhengiejia gou wo. Hhende qienli wine, nenliye wine. Hhe zannan ruhherde minlin xiaise khizhene.\" ");
INSERT INTO sce_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ingie Ersani xioxii hhe oronde man chonji kurughawo. ");
INSERT INTO sce_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ersa huitanse khizhedene Ximunni giede echise ghadunmekieni fashao giezhi jindaghazho. Kunla hheni goudagha giezhi Ersani xiahua giezho. ");
INSERT INTO sce_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ersa hheni shida beizhi gienyini sugiezhi nie kieliese fashao giesan daowo. Hhe deigo bosizhe hhelai ushila qiiwo. ");
INSERT INTO sce_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Naran pudakude kunla yanyanji giemeresan kunlai man Ersai shida uduru irewo. Ersa nienieji khaghalane maqise hhela man goudawo. ");
INSERT INTO sce_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Pse sheitanla olon kunlai jierese khizhedene fugiede waradazhi kieliewo, \"Chishi Hudai Kewon wo!\" Ersa hhelai sugiezhi kielien ese kielieghazho, sheitanla hheshi Mexiha bikui mejiene. ");
INSERT INTO sce_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ogheikude Ersa khizhedene hontande echiwo. Kunla Ersani izhi ereizho. Ereizhi oludene hhei ulie echighane giezho. ");
INSERT INTO sce_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ersa hhelade kieliewo, \"Bi psedu oronlade echizhi Hudai gojiani gouxioxini chonjine. Mii ene shiqinde peizhi ireghawo.\" ");
INSERT INTO sce_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ingiedene ErsaYudayani huitanlade echizhi daoli chonjizho. ");
INSERT INTO sce_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Niudude ErsaGenisaleni hu ghizhade beizho. Olon kun jigheidazhi Hudai kielienni chenliene giezho. ");
INSERT INTO sce_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ersa uzhese hu ghizhade ghua chon beizho. Zhaghasun bareisan kunla chon jiere uwo, on waghazhi souzho. ");
INSERT INTO sce_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ErsaXimunyi chon jiere khireidene Ximunde kieliewo, \"Chonne bienzise usu dunda daogha.\" Ingie chon jiere soudene olon kunlade sughawo. ");
INSERT INTO sce_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jianji baludene Ximunde kieliewo, \"Chi chonne keizhi usui gun oronde echi on xiaizhi zhaghasun barei.\" ");
INSERT INTO sce_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ximun kieliewo, \"Bijien nie xii bareise yama barei dawoma, chii kielien mutun bi onni xiaiye.\" ");
INSERT INTO sce_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ingie onni xiaidene zhaghasun texien olon bareizhi onni bii gha olughakui xianli. ");
INSERT INTO sce_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Hhela kha rouizhi psedu chon jieredu kunlai banman giele ire giezho. Hhela iredene ghua chon jiere zhaghasunyi durughase chon pudane giezho. ");
INSERT INTO sce_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ximun-Beduru ene shiqinni uzhedene Ersani melie papalazhi kieliewo, \"Ezhan, chi mase likai gie, bishi zuiren wo!\" ");
INSERT INTO sce_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ximun hhantuku kunla zhaghasun texien olon bareise uzhe beizho. ");
INSERT INTO sce_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Xibitaini kewon Yagebu, Yaheiyashi Ximunyi nokie wo. Hhelaye uzhe beizho. Ingie ErsaXimunde kieliewo, \"Bu ayi. Enedu khuinase chi kun louine.\" ");
INSERT INTO sce_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Hhela chonlai haibienzide khizhegha soyujilane man jiedene hhei daghawo. ");
INSERT INTO sce_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Niefade Ersa chenshide bikude hhende nie hunshendeni pifugientu kun wine. Hhe Ersai chanlasenu papaladene xiahua giewo, \"Ezhan, chi duran bise mini ganjinragha shidane.\" ");
INSERT INTO sce_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ersa khane zhighazhi hhei maqizhi kieliewo, \"Bi duran wine. Chi ganjinra.\" Ene kielienni dei kieliese pifugienni goudawo. ");
INSERT INTO sce_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ersa hhende fenfulazhi kieliewo, \"Chi kiemade bu kieliedene echizhi beyene buwade uzhegha. Musai shu jiere fenfulasan mutun beyechii ganjinrasande oluzhi Hudade mure ogizhi kunlade ganzhen bei.\" ");
INSERT INTO sce_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ingieliuzhe Ersani minshen yebeiseye fugiedazho. Olon kunla Ersani kielienni chenliezhi gienne goudaghale irezhoma, ");
INSERT INTO sce_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ersa tuidene hontande onxian giele echizho. ");
INSERT INTO sce_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Niudude Ersa kunlade surughakude Falisai kun, jinwun loushila kanzideni souzho. Enela Jialili, Yudayani go aghin, Yelusalense irezho. Hudai nenli Ersaghala hhantu bizhi kunlai gienni goudaghazho. ");
INSERT INTO sce_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kunla ruzide nie tanhon giesan gientui qienliezhi Ersai shida echine giese ");
INSERT INTO sce_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","kun olonshi echi dazho. Ingiesenu gie jiere khirei wani agidene ruzide bareizhi Ersai melie boughawo. ");
INSERT INTO sce_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ersa hhelai xianxin giekui uzhedene kieliewo, \"Zhanlien, chii zuini mienliewo.\" ");
INSERT INTO sce_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ingiese jinwun hanjia, Falisai kunla kieliendu qiiwo, \"Imutu kufurei fanjichen kunshi kien wine? Hudase chugo zuini kien mienliene?\" ");
INSERT INTO sce_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ersa hhela sumulasanni mejiedene kieliewo, \"Ta yangiezhi zhughedene imutui sumulane? ");
INSERT INTO sce_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Chii zuini mienliewo giese sunfan onu, bosizhe yo giese sunfan wo? ");
INSERT INTO sce_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ingieseye Kunnikewon duyade zuini mienlieku qienli bikui tande mejieghane giezho.\" Ingiedene tanhon giesan gientude kieliewo, \"Bi chade kielieye, bosizhedene ruzine agi giedene echi.\" ");
INSERT INTO sce_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Hhe kun kunlai melie deigo bosi ruzine agisenu Hudai kuaizhi giedene echiwo. ");
INSERT INTO sce_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kunla man ghanira beizho. Zhughesene ayizhi Hudai kuaizhi kieliezho, \"Enedu bijien nie fugie shiqin uzhewo!\" ");
INSERT INTO sce_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Enese khuinashi Ersa khireidene shui shanjisan Liwi giesan nie kun shui shanjisan oronde sousei chanlawo. Ersa hhende kieliewo, \"Chi mii dagha.\" ");
INSERT INTO sce_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ingie hhe man benda jie bosizhedene Ersai daghawo. ");
INSERT INTO sce_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","LiwiErsade oluzhi giedene fugiede xi beilawo. Shui shanjisan tebieji olon kunla psedu kunlare hhantu xi souzho. ");
INSERT INTO sce_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Falisai kun, hhelai jinwun hanjiala Ersani tujilani sugiezhi kieliezho, \"Ta yale shui shanjisan kun, zuirenlare hhantu ijiezhi ochine?\" ");
INSERT INTO sce_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ersa kieliewo, \"Gien witu kunla deifu ulie kerene. Gientula deifu kerene. ");
INSERT INTO sce_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Bi irese gou kunlai ereile ese irezho, zuirenlani geizhen gieghale irezho.\" ");
INSERT INTO sce_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Hhela kieliewo, \"Yaheiyani tujila chan orozo bareizhi onxian giezho. Falisai kunni tujilaye ingiezhi giezho. Zinie chii tujila jin ochizhi ijiezho.\" ");
INSERT INTO sce_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ersa hhelade kieliewo, \"Ghurunde iresan zhochenla shini khughon bikude matugie orozo bareine? ");
INSERT INTO sce_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Shini khughonni kunla lai echiku udu kuzhene. Hhe udude hhela orozo bareine.\" ");
INSERT INTO sce_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ersa pse bilazhi hhelade kieliewo, \"Shini jienne ghighazhi khuichen jien jiere huduchen kun uwo. Qingiese shini jien tanturawo. Pse ghigha bouzhesan hhe nie shidu khuichenni jiere ulie talane. ");
INSERT INTO sce_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Shini jiuni khuichen tulunde zhonlochen kun uwo. Qingie zhonlose shini jiu tulunni ghalughazhi jiu usuru khizhese tulunye qida olune. ");
INSERT INTO sce_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Shini jiuni shini tulunde zhonlone. ");
INSERT INTO sce_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kunla khuichen jiu ochidene shini jiu ochiku duran uwo. Hhela kieliese khuichenni gou wo giene.\" ");
INSERT INTO sce_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nie hhamuraku udude Ersa boudei ghazhaghun yozhi daokude tujilani boudei qiorunni sidadene huluzhi ijiezho. ");
INSERT INTO sce_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Niezhan Falisai kunla kieliewo, \"Ta yangiezhi hhamuraku udude ulie giekui giene?\" ");
INSERT INTO sce_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ersa hhelade kieliewo, \"Dawude hhantuku kunlarene oliesukude giesan shiqinyi ta onshizhi ese daowu? ");
INSERT INTO sce_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Hhe Hudai giede orodene Hudade ogiku ginanyi bareidene ijiewo. Pse hhantuku kunladene ogiwo. Ene ginanyi buwase andase kiema ijiezhi ulie olune.\" ");
INSERT INTO sce_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ersa pse hhelade kieliewo, \"Kunnikewonshi hhamuraku uduni Ezhan wo.\" ");
INSERT INTO sce_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pse nie hhamuraku udude Ersa huitande orodene kunlade sughazho. Hhende nie borun khani ghosan kun wine. ");
INSERT INTO sce_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Jinwun hanjia, Falisai kunla Ersa hhamuraku udude goudaghase zhaku zhenji ereine giezhi ghulazhi uzhezho. ");
INSERT INTO sce_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ersa hhela sumulasei mejiedene khani ghosan kunde kieliewo, \"Bosizhedene dunda bei.\" Ingie hhe kun bosizhedene beiwo. ");
INSERT INTO sce_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ersa hhelade kieliewo, \"Bi tande asaye, hhamuraku udude gouni giese gou onu huaini giese gou wo? Aminni jiuinu, heine? Alinie oluzho?\" ");
INSERT INTO sce_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ingie zhouwini kunlai uzhedene hhe kunde khane khizhegha giese khizheghase khani goudawo. ");
INSERT INTO sce_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ingiese hhela hende hokudene Ersai matugiene giezhi shanlian giezho. ");
INSERT INTO sce_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Hhe xienzide Ersa ulade khireidene nie xii Hudase onxian giewo. ");
INSERT INTO sce_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ogheikude tujilane uru iredene hhelai dundase 12 gie kun sunghudene shitu danlaghawo. ");
INSERT INTO sce_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Hhelai niereshi Ximun (ErsaXimunde niere ogise Beduru giene), hhei jiu Andelie, Yagebu,Yaheiya, Feili, Badolomai, ");
INSERT INTO sce_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matai, Doma, Yalefeini kewon Yagebu, Rexinpai giezhi urusan Ximun, ");
INSERT INTO sce_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yagebuni kewon Yuda, pse Ersai ghudandusan Jialie kun Yuda wo. ");
INSERT INTO sce_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ersa hhelare hhantu boudene pin oronde beiwo. Olon tujilaye hhantu wo. Pse tebieji olon bexinla Yudaya, Yelusalen, haibienzini Tuilo, Xidunse man irezho. ");
INSERT INTO sce_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Hhela Ersa jianjisan kielienni chenliezhi gientulai goudaghase giezho. Sudoro zannan ruhher orosan kunlai goudaghawo. ");
INSERT INTO sce_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kunla man Ersai maqine giezho. Hhei nenli khizhese gientulai man goudaghane. ");
INSERT INTO sce_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ersa qiorunne qila tujilane uzhedene kieliewo, \"Jiahui kunlade fuqi wine, Hudai gojiashi tanughun wo. ");
INSERT INTO sce_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ede oliesusan kunlade fuqi wine, ta chudune. Ede wilasan kunlade fuqi wine, ta bayasune. ");
INSERT INTO sce_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mii yenyinghala kunla tai henjizhi fandui giene, shizheghazhi doghun kun danlaghadene minshenyi bixindaghase tande fuqi wine. ");
INSERT INTO sce_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Hhe shihoude ta bayasuzhi jiulindu, asiman jiere tande ogiku jianli fugie wo. Tani xienrenlaye xienzhilani ingiezhi fandui giezho. ");
INSERT INTO sce_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ta bayan kunlade gou widawo, ta xianshou gie kuruwo. ");
INSERT INTO sce_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ede chudusan kunlade gou widawo, ihou ta oliesune. Ede bayasusan kunlade gou widawo, ihou ta houhui giezhi wilane. ");
INSERT INTO sce_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kunla man tai kuaiku shihoude tande gou widawo, hhelai xienrenlaye jia xienzhilai ingiezhi kuaizhi daozho.\" ");
INSERT INTO sce_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","\"Ingieliuzhe kielienyimi chenliesan kunlade bi kielieye. Duitoudene ore, tani henjisan kunlade goude gie. ");
INSERT INTO sce_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Tani sugiesan kunlade gouni kielie. Tai peichilasan kunlade oluzhi onxian gie. ");
INSERT INTO sce_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kunla niemien khizhaichii eghise pse niemienne eghigha. Kunla chii mienzii jienni agi echise lizii jienneye ogi. ");
INSERT INTO sce_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kunla xiahua giezhi kerese ogi. Tani dunxilani agi echise kerezhi bu ire. ");
INSERT INTO sce_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ta kunlai goyadene matugie gieghaku duranshi taye kunlade qingiezhi gie.\" ");
INSERT INTO sce_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","\"Ta zinie tande oresan kunlade orese yan gou wo? Zuirenlaye goya oresan kunladene orene. ");
INSERT INTO sce_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ta zinie tande goude giesan kunlade goude giese kunlase yan gou wo? Zuirenlaye ingiezhi giene. ");
INSERT INTO sce_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ta baer asughuzhi ogikude goyane ogine giesan hhe kunlade ogise kunlase yan gou wo? Zuirenlaye zuirenlade asughuzhi ogidene yen khareizhi kerene.\" ");
INSERT INTO sce_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","\"Ta duitoudene ore. Hhelade goude gie. Baer asughuzhi ogise khareizhi ogi dakuse bu ayi. Qingiezhi giese tande jianli olon wo, Zui Undu Hudai kewosi gholune. Huda nenjienni matasan kun, doghun kunlade man goude giene. ");
INSERT INTO sce_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Adatai ubali xiiku mutun taye qingiezhi ubali xii.\" ");
INSERT INTO sce_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","\"Kunlai bu kielie, taiye ulie kieliene. Kunlade zui bu jinji, tandeye zui ulie jinjine. Kunlani roulie, taiye rouliene. ");
INSERT INTO sce_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Kunlade ogi, ingiese tande khareizhi ogine. Tande ogise gashende sidaghazhi daruzhi moighazhi olon ogine. Ta kunlade yanghala nanjizhi ogise tandeye yanghala nanjizhi ogine.\" ");
INSERT INTO sce_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ersa pse hhelade bilazhi kieliewo, \"Sugho sughone uduru shidanu? Qingiese ghuala nokiende anda ulie bounu? ");
INSERT INTO sce_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Xieshen loushise fugie uwo. Xieshenla man suru baraghase loushighala jian pindane. ");
INSERT INTO sce_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Chi yangiezhi gaijiune nudundedu osun zhazhai chanlane, goya nudundedu lianni chanla dane? ");
INSERT INTO sce_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Chi goya nudundedu lianni chanla dadene matui 'Gaijiu, bi chini nudundedu osun zhazhai agiye.' giezhi kieliene? Chi ene jiazhon giesan kun, xien goya nudundedu lianni agidene uzhezhi qinchu olusenu gaijiune nudundedu osun zhazhai agi.\" ");
INSERT INTO sce_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","\"Gou mutun jiere langan alima ulie soune. Langan mutun jiere gou alima ulie soune. ");
INSERT INTO sce_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Alimani uzhese mutunni tanine. Eghesunse uhuago zhei dane, osunse putouiye zhei dane. ");
INSERT INTO sce_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Gou kunlai zhughede gounishi yen gouni khizheghane. Doghun kunlai zhughede doghunnishi yen doghunni khizheghane. Zhughede durusei amande kielie khizheghane.\" ");
INSERT INTO sce_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","\"Ta mini yangiezhi, 'Ezhan, Ezhan!' giezhi waradadene mii kielien mutun ulie giene? ");
INSERT INTO sce_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mini enende iredene mii kielienyi chenliedene giesan kun yanni xianli bikui bi tande kielieye. ");
INSERT INTO sce_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Hhe hoxian nie goude gie beighasan kunyi xianli. Zeminni waizhi gundaghadene jigunni fugie tashi jiere giezho. Fugie usu irezhi gieni chunjiliuzhe ulie gojiolune. ");
INSERT INTO sce_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mii kielienyi chenliedene ulie giesan kunshi hoxian jichu ulie waidene gie beighasan kunyi xianli. Usu nie chunjise gie tairewo, pse tairesan fugie wo.\" ");
INSERT INTO sce_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ersa ene kielienyi kieliedene Jiabainunde echiwo. ");
INSERT INTO sce_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Hhende nie baifuzhan zhunshi giesan hojini giemere fugune giezho. ");
INSERT INTO sce_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Baifuzhan Ersai shiqinyi sonosudene hojine goudaghane giezhi Yutai kunni zhanlaolai peizhi Ersai xinlaghale echiwo. ");
INSERT INTO sce_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Hhela Ersai shida echidene hende xiahua giezhi kieliezho, \"Ene kunde banman giekui enbene. ");
INSERT INTO sce_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Hhe mai kunlade orezho. Huitanye giezhi ogizho.\" ");
INSERT INTO sce_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ersa hhelare hhantu echiwo. Gie shidai kuzhese baifuzhan zhanlienlane peizhi Ersade kielieghale echiwo. \"Bijienyi ezhan kieliewo, 'Ezhan, Chi pofan bu gie. Chi mii giede irese bi pei dane. ");
INSERT INTO sce_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Bi chii jienlieseye pei dane. Chii nie aman kielienshi hojimi goudane. ");
INSERT INTO sce_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Biye kunlai kha doura wo, buduila mii kha doura wo. Bi buduidene echi giese echine, ire giese irene, enei gie giese hhe giene.'\" ");
INSERT INTO sce_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ersa enei chenliedene ghanirazhi ochira daghasan olon kunlade kieliewo, \"Bi intu xianxin giekui Isiliede uzhezhi uye daozho.\" ");
INSERT INTO sce_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Hhe peizhi ireghasan kun kharei echise hojini ijin goudawo. ");
INSERT INTO sce_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Oloncha ese oludene ErsaNain giezhi nie aghinde echiwo. Hhei tuji, tebieji olon kunla man hhantu echiwo. ");
INSERT INTO sce_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Aghin shida kuzhekude kunla nie fugusan kunni qienlie khizhewo. Guafude niekozi kewonshi fugu widawo. Chenshini tebieji olon kunlaye hhere hhantu wo. ");
INSERT INTO sce_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ezhan guafui uzhedene ubali xiizhi bu wila giewo. ");
INSERT INTO sce_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ingiedene melieshila danjiani nie maqise qienliesan kunla beiwo. Ersa kieliewo, \"Nasuchighan kun, bi kielieye, chi bosizhe!\" ");
INSERT INTO sce_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Fugusan kun bosizhe kielien kielie qiiwo. Ingie Ersa anadei jiuizhi ogiwo. ");
INSERT INTO sce_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kunla man ayizhi uzhe beidene Hudai kuaizhi kieliezho, \"Fugie xienzhi mai shida irewo!\" Pse kieliezho, \"Huda goya bexinladene banman giezho!\" ");
INSERT INTO sce_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ersai shiqinyi Yudaya, pse zhouwini go oronlade man kielie kurughawo. ");
INSERT INTO sce_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yaheiyani tujila ene shiqinni Yaheiyade kieliewo. Yaheiya ghua tujine urudene kieliewo, ");
INSERT INTO sce_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","\"Ta Ezhande echidei asa, 'Jianlai irene giesanshi chi onu, pse nie saghei?'\" ");
INSERT INTO sce_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ghua tujini Ersade ire asawo, \"Xili gieghasan Yaheiya bijienni asaghale irewo, 'Jianlai irene giesanshi chi onu, pse nie saghei?'\" ");
INSERT INTO sce_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Zhen ingiekude Ersa olon gientu, giemeresan kun, sheitan heisan kunlai goudaghawo, sugholaiye chanlaghawo. ");
INSERT INTO sce_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ersa kieliewo, \"Ta echidene chanlasanyi, sonosusanyi Yaheiyade kielie. Sugho chanlasanyi, dogholon yosanyi, pifugientui goudaghasanyi, dulei sonosusanyi, fugusan kun aminne olusanyi, pse nanxin kunlade gouxioxi chonjikui kielie.\" ");
INSERT INTO sce_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mii inxin ulie giechen kunde fuqi wine. ");
INSERT INTO sce_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yaheiya peizhi ireghasan kunla kharei echise Ersa kunlade Yaheiyai kieliezho, \"Ta hontande yan kunyi uzhele echiwo? Kei feiliese gojiolusan ghulusun mutun zholien kunyi uzhele echiwu? Pusho. ");
INSERT INTO sce_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ta yan kunyi uzhele echiwo? Seighan jien musisan kun uzhele echiwu? Uzhe, huahua, gouni musisan kunla hongunde wo. ");
INSERT INTO sce_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ta jiujin yan kunyi uzhele echiwo? Xienzhii uzhele echiwu? Enbene. Bi tande kielieye, hhe xienzhise da fugie wo. ");
INSERT INTO sce_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jinwun jiere, 'Uzhe, bi qinsi kunne chii melie peizhi chii moni zhunbei gieghane.' giezhi huaisanshi ene kun wo. ");
INSERT INTO sce_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Bi tande kielieye, biereila olusan kun dunda Yaheiyase fugieni nieda uwoma, Hudai gojiade zui meila kun hhense fugie wo.\" ");
INSERT INTO sce_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Bexinla, shui shanjisan kunla ene kielienyi chenliedene Hudai daoli oluzho giezho. Hhela ijin Yaheiyase xili jienliewo. ");
INSERT INTO sce_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ingiese Falisai kun, jinwun loushila Yaheiyase xili ese giezhi Huda hhelade ogisan jihuai ese jienliewo. ");
INSERT INTO sce_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","\"Bi ene idai kunlai yanghala bilane? Hhela yanni xianli? ");
INSERT INTO sce_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Hoxian geidoude souzhi nadusan kesilai xianli. Hhela nieniedene waradazhi kieliene, 'Bijien tande bierei agiku xiu feiliese ta ulie jiuline. Kun fuguwo giezhi wilase ta ulie wilane.' ");
INSERT INTO sce_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Xili gieghasan Yaheiya iredene ijiuni ulie ijiezhi, jiu ulie ochise ta hhei jiere sheitan wine giezhi kieliene. ");
INSERT INTO sce_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kunnikewon iredene ijiezhi ochise ene kun jin ijiezhi ochikure wo. Shui shanjisan kun, zuirenlani zhanlien wo giezhi ta kielienema, ");
INSERT INTO sce_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","agheli bisan kunla aghelishi gouni bikui mejiene.\" ");
INSERT INTO sce_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nie Falisai kun Ersani xinlazhi giedene budan ijieghane giezho. Ersa giedeni echidene shire konde souzho. ");
INSERT INTO sce_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Hhe chenshide nie biereishi zuiren wo. Ersa Falisai kunni giede ijiele echikui mejiedene ishighala giesan huapinde xianshuini agizhi irewo. ");
INSERT INTO sce_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ersai khuina iredene kon shidai beizhi wilazho. Nunpusun kon jiereni jienliezhi bouse usunghalane saizho. Kon jiereni izhigie orezhi xianshui fureizho. ");
INSERT INTO sce_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ersai xinlasan Falisai kun ene shiqinni chanladene zhughedene sumulawo, \"Ene kunshi xienzhi enbese eneni kien moisei mejiene, eneshi zuiren bikuiye mejiene.\" ");
INSERT INTO sce_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ingiese Ersa kieliewo, \"Ximun, bi chade kielieye.\" Ximun kieliewo, \"Loushi, chi kielie.\" ");
INSERT INTO sce_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","\"Nie kunde ghua kun baer chaine. Nie kun 500 gie miengu chaine. Dou nie kun 50 gie miengu chaine. ");
INSERT INTO sce_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Baer wizhi honji dazho. Ghualai baerni mienliewo. Ene ghualase alinie hhe kunde olon orene?\" ");
INSERT INTO sce_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ximun kieliewo, \"Bi sumulase baer olon chaisan hhe kun olon orene.\" Ersa kieliewo, \"Chi sumulasan oluzho.\" ");
INSERT INTO sce_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ingiedene bierei miende ochiradene Ximunde kieliewo, \"Chi ene nie biereii uzhe. Bi chii giede orozhese mini konni waghaku usu da ese ogiwo. Ene bierei nunpusunghalane waghazhi usunghalane saizho. ");
INSERT INTO sce_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Chi made orezhi salan ese giewo, ene bierei bi orozhesanse izhigie mii konde orezho. ");
INSERT INTO sce_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Chi mii qiorun jiere tosun ese fureizho, ene bierei mii kon jiere gou xianshui fureizho. ");
INSERT INTO sce_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Bi chade kielieye, hhei giedughon zuini mienliewo. Ene bierei made olon oresei uzhese hheni zuini olon mienliesei mejiene. Choghon mienliesan kun choghon orene.\" ");
INSERT INTO sce_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ingie biereide kieliewo, \"Chii zuini mienliewo.\" ");
INSERT INTO sce_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Hhantu sousan kunla zhughedene sumulazho, \"Eneshi yan kun wo? Kunlai zuini mienliene.\" ");
INSERT INTO sce_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ersa biereide kieliewo, \"Chii xianxin gieku chii jiuiwo. Pinnan giedene echi.\" ");
INSERT INTO sce_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Oloncha ese oludene Ersa zhouwini chenshi, aghinlade toreizhi Hudai gojiai gouxioxini chonjizho. 12 gie tujiniye hhantu wo. ");
INSERT INTO sce_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Giedun biereilaye hhantu wo. Enelashi melieshida sheitan heizhi giemeredene goudaghasan wo. Hhelai dunda Modalani Mereiyen wine. Hhei jierese dolon sheitan touzhi khizheghawo. ");
INSERT INTO sce_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Hherodeni gonjia Kusani bierei Yeyanaye wine. Susana, psedu biereilaye wine. Hhela goyane baerghala Ersatande banman giezho. ");
INSERT INTO sce_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Olon kunla go chenshise Ersai shida irekude Ersa hhelade bilazhi kieliewo, ");
INSERT INTO sce_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","\"Nie kun shizhile echiwo. Shizhikudeni niezhanla mo jiere luise kunla taizhi asiman jieredu bunzhula ijie agiwo. ");
INSERT INTO sce_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Niezhanla tashitu oronde luise osiwoma, usu uwoshi ghowo. ");
INSERT INTO sce_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Pse niezhanla eghesun dunda luise eghesunre hhantu osise hhei jigheidawo. ");
INSERT INTO sce_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Da niezhanla gou ghazhade luise osizhi 100 pei zhonjia souwo.\" Ersa enezighan kielienyi kieliedene fugiede kieliewo, \"Chighin bitu kunla chenliendu!\" ");
INSERT INTO sce_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ingiedene tujilani ene bilazhi kieliesanshi yan isi wo giezhi Ersade asazho. ");
INSERT INTO sce_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ersa kieliewo, \"Hudai gojiai mimii tande mejieghawoma, psedu kunlade bilazhi kieliekushi, 'Hhela uzhese minbai olu dane, chenliese dunjire dane.'\" ");
INSERT INTO sce_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","\"Eneshi bilasei isi wo. Fureshi Hudai kielien wo. ");
INSERT INTO sce_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mo jiereghunshi kun Hudai kielienyi chenliedene Ibilisi ire zhugheseni kielienyi agi echise xianxin gie dazhi jiui dawo. ");
INSERT INTO sce_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Tashi jiereghunshi kun kielienyi chenliedene bayasuzhi jienliewoma, zhughedeni genzi wise nietan xianxin giedene nie shiise tuiwo. ");
INSERT INTO sce_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Eghesun dunda luisanshi kun kielienyi chenliedene duyade munan gieku, bayazheku, xianfugiekughala jigheidazhi yama sou dazho. ");
INSERT INTO sce_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Gou ghazhaghunshi kun kielienyi chenliedene gou lianxintu zhughedene teizhi izhigie rennai giedene zhonjia souwo.\" ");
INSERT INTO sce_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","\"Zhulai jienjidene huapinghala khaghachen kun uwo, chonban douraye ulie teine. Zhula teiku teizi jiere jiene. Ingiese kunla orozhese chujieghene. ");
INSERT INTO sce_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Niuighasanlai ulie khizheghakui uwo. Ghulazhi giesan shiqinlai ulie khizheghazhi ulie mejieghakui uwo. ");
INSERT INTO sce_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ingiese ta xioxin giezhi goude chenliendu, bichen kunde pse olon ogine. Wichen kunse goyane wine giesanlainiye agi echine.\" ");
INSERT INTO sce_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ersai anani, gaijiulani uzhele irewo. Kun olonshi shidani echi dazho. ");
INSERT INTO sce_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kunla Ersade kieliewo, \"Anachii, gaijiulachii ghadane sagheizhi chii ochirane giezho.\" ");
INSERT INTO sce_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ersa hhelade kieliewo, \"Hudai kielienyi chenliedene giesan kunlashi mii ana, gaijiula wo.\" ");
INSERT INTO sce_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Niudude Ersa tujilarene hhantu chon jiere khireidene hhelade kieliewo, \"Matan hu duimiende daoye.\" Ingie hhela chonni kei yo qiiwo. ");
INSERT INTO sce_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Zhen yokude Ersa kijie hhunturazho. Hu jiere menzhali honfen kei bosiwo. Chonde usu oro wixiennudazho. ");
INSERT INTO sce_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tujilani echizhi Ersai uru xiereigha kieliewo, \"Ezhan, a Ezhan! Bijienyi amin widane giezho!\" Ersa xiereidene kei, fugie lanni nie sugiese deigo beiwo. Hu nanranghane gholuwo. ");
INSERT INTO sce_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ersa hhelade kieliewo, \"Tai xianxin gieku khala wine?\" Hhela ayi ghaniradene nieniedene kieliezho, \"Eneshi yan kun wo? Kei, usudeye minlin xiaise kielienyini chenliene.\" ");
INSERT INTO sce_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Hhela Jialili duimienni Gelasen kunyi oronde kuzhewo. ");
INSERT INTO sce_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Usu bienzide khireise nie chenshide sheitan heisan kun Ersai shida irewo. Ene kun oloncha jien ese musizhi giedene ese souzhi chan meza sudoro souzho. ");
INSERT INTO sce_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Hhe Ersai chanladene papalazhi fugiede kieliewo, \"Zui Undu Hudai kewon Ersa, chi mii jiohoro bu gie. Bi chii xiahua gieye, mii bu zayala!\" ");
INSERT INTO sce_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Melieshida Ersa minlin xiaizhi zannan ruhheryi hhe kunyi jierese khizhe giezho. Zannan ruhher hhei niefanie bareizho. Khakonyini qieshen jielioghala soziladene sagheiliuzhe sheitanyi lilianghala denji siraghasenu hontande holu echine. ");
INSERT INTO sce_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ingiese Ersa hhende asawo, \"Chii nierei yan giene?\" Hhe kieliewo, \"Olon giene.\" Sudoroi orosan sheitan olon wo. ");
INSERT INTO sce_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Sheitanla Ersade, \"Bijienyi ibeizi khizhe daku kenzide bu echigha!\" giezhi xiahua giezho. ");
INSERT INTO sce_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Hhe popo jiere idaban khighei ijiezhi souzho. Sheitanla Ersade, \"Bijienyi hhe khigheila jiere khigha!\" giezhi xiahua giezho. Ersa dain giese ");
INSERT INTO sce_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","sheitanla hhe kunyi jierese khizhedene khigheilai jiere khiwo. Khigheila egheide chunji bou, hude yenji alawo. ");
INSERT INTO sce_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Khighei adulasan kunla ene shiqin fashen giesei chujieghedene holuzhi chenshi, aghinlade kieliele echiwo. ");
INSERT INTO sce_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kunla yan shiqin wo giezhi uzhele irewo. Ersai shida ire uzhese sheitan likai giesan kun goudazhi jienne musizhi Ersai kon shida souzho. Ingiese hhela ayizho. ");
INSERT INTO sce_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Shiqinyi chanlasan kunla sheitan heisan kunni matui goudaghasei kunlade kieliezho. ");
INSERT INTO sce_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gelasen zhouwini kunla man hende ayidene Ersai xiahua giezhi chi bijiense likai gieba giezho. Ingiese Ersa chon jiere khireidene khareiwo. ");
INSERT INTO sce_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Sheitan heisan kun Ersai xiahua giezhi hhantulaye giese Ersa hhei khareighazhi ");
INSERT INTO sce_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","chi giedene echidene Huda chade giesan fugie shiqinni kunlade man kielie giewo. Hhe echidene chenshini kunlade Ersa giesan fugie shiqinyi chonjizho. ");
INSERT INTO sce_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ersa khareizhi irese hhei sagheichen kunla man hhei jienliezho. ");
INSERT INTO sce_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Zhen ingiekude Yalu giezhi nie kun irewo. Hheshi huitan gonjisan kun wo. Ersai kon konde papalazhi xiahua giezhi giedene uruzho. ");
INSERT INTO sce_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Hhe kunde 12 olusan zinie oqin wo, duya ijiene giezho. Ersa echikudeni olon kun jigheidazho. ");
INSERT INTO sce_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nie biereii chusun usurusan gien 12 nien oluzho. Deifulade uzheghazhi baerlane man huai widaghazhoma, gouda dazho. ");
INSERT INTO sce_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Hhe Ersai khuina iredene jien ghizhaseni nie maqise chusun usuruku deigo beiwo. ");
INSERT INTO sce_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ersa kieliewo, \"Mii kien maqiwo?\" Kunla man chenren ese giese Beduru kieliewo, \"Ezhan, kun olonshi chii jigheidazhi mughuwoba.\" ");
INSERT INTO sce_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ersa kieliewo, \"Kun mii maqiwo. Mii jierese nenli khisei bi mejiewo.\" ");
INSERT INTO sce_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ene bierei ulie mejieghaku banfa widawo. Ingie ayi pugharazhi Ersai melie ire papalawo. Hhe yangiezhi maqisei, matugie deigo goudasei kunlade kieliewo. ");
INSERT INTO sce_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ersa hhende kieliewo, \"Funi, chii xianxin gieku chii jiuiwo. Pinnande echi.\" ");
INSERT INTO sce_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ersa zhen kieliekude huitan gonjisan kunni giese nie kun kieliele irewo, \"Oqinchii duya ijiewo. Loushii mafan bu giegha.\" ");
INSERT INTO sce_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ersa chenliedene Yalude kieliewo, \"Bu ayi, zi xianxin giese oqinchii goudane.\" ");
INSERT INTO sce_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ersa hhe giede kurudene Beduru, Yaheiya, Yagebu, oqinni ada anaseni chugo gie doura kiemai ese oroghawo. ");
INSERT INTO sce_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Kunla man ene oqinde orezhi echanne chuidazhi wilazho. Ersa kieliewo, \"Bu wila, hhe ese duya ijiezho, hhunturazho.\" ");
INSERT INTO sce_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Hhela oqin fugusei mejiene. Ingiese Ersai uzhezhi xiniezho. ");
INSERT INTO sce_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ersa khaseni bareidene fugiede kieliewo, \"Oqin, bosizhe!\" ");
INSERT INTO sce_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Hhei ruhherni kharei iredene deigo bosi irewo. Ersa minlin xiaizhi oqinde ijiekuni ogi giezho. ");
INSERT INTO sce_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ada anani hende ghanirazho. Ersa fenfulazhi ene shiqinyi kiemade bu kielie giezho. ");
INSERT INTO sce_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ersa 12 gie tujini uruzhi hhantulaghadene hhelade soyuji sheitan hanshilieku, gien goudaghaku nenli, qienli ogiwo. ");
INSERT INTO sce_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Hhelai peizhi echighadene Hudai gojiai chonjizhi gientulai goudagha giezho. ");
INSERT INTO sce_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Hhelade kieliewo, \"Mo yose zhugun, kuabao, ijiuni, baerlai bu barei. Pse jien ghua bu barei. ");
INSERT INTO sce_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ta alinie giede orose hhe oronse likai gietula hhe giede sou. ");
INSERT INTO sce_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Alinie chenshide tai ulie jienliese hhense likai giekude kon jieredu turane kui boughazhi fandui giezhi zhenmin gie.\" ");
INSERT INTO sce_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ingie tujila go chenshi, aghinlade echizhi Hudai kielienyi chonjizhi gien goudaghazho. ");
INSERT INTO sce_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ingiekude Hherode honshan fashen giesan shiqinlai man sonosudene matui imutunyi shiqin wo giezho. Kunla kieliese fugusan Yaheiya aminne oluwo giezho. ");
INSERT INTO sce_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Niezhan kunla kieliese Iliya chuxien giewo giezho. Pseshiku kunla kieliese nie melieshiku xienzhi aminne oluwo giezho. ");
INSERT INTO sce_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hherode\"Yaheiyani qiorunyi bi pienjiwo. Bi sonosusan ene kun daojishi kien wine\" giezhi kieliewo. Ingie banfa xianjizhi nie uzhele echine giezho. ");
INSERT INTO sce_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Shitula kharei iredene giesan shiqinlai man Ersade kieliewo. Ersa hhelai konkonji uduru Bosaida chenshide echiwo. ");
INSERT INTO sce_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kunla mejiedene hhei daghazho. Ersa hhelai jienliedene Hudai gojiai jianjizhi gientulai goudaghazho. ");
INSERT INTO sce_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Naran pudakude 12 gie shitu Ersai melie ire kieliewo, \"Kunlai sandaghazhi hhela aghinlade ijiezhi kijieku oronne ereile echigieba, eneshi hontan wo.\" ");
INSERT INTO sce_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ersa kieliewo, \"Ta hhelade ogizhi ijiegha.\" Hhela kieliewo, \"Matande zinie tawun ginanji ghua zhaghasun wo. Imeghei kunlade pse agile echinu?\" ");
INSERT INTO sce_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Hhende chabudu 5000 ere kun wo. Ersa kieliewo, \"Ta hhelai chabudu 50 gie 50 gieji nie tozi nie tozi sougha.\" ");
INSERT INTO sce_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Tujila Ersa kieliesan mutun kunlai man soughawo. ");
INSERT INTO sce_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ersa tawun ginan, ghua zhaghasunyi barei asimanyi uzhe, Hudade mafan kieliedene ghulu keigha, tujilade ogise tujila kunlai melie teiwo. ");
INSERT INTO sce_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Dajiala man ijie chududene feiliesan zhazhai hhantulaghase 12 gie lanzi zhonlowo. ");
INSERT INTO sce_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Niudude Ersa niezheghanne onxian giekude tujilaniye hhantu wo. Ersa hhelade asawo, \"Kunla kieliese bishi kien wo giezho?\" ");
INSERT INTO sce_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Hhela kieliewo, \"Kunla kieliese xili gieghasan Yaheiya wo giezho. Niezhan kunla kieliese Iliya wo giezho. Pse niezhan kunla kieliese eqighanku nie xienzhi aminne oluwo giezho.\" ");
INSERT INTO sce_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ersa hhelade kieliewo, \"Ta kieliese bishi kien wo?\" Beduru kieliewo, \"Chishi Mexiha wo.\" ");
INSERT INTO sce_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ersa ene shiqinyi kiemade bu kielie giezhi hhelade hende fenfulawo, ");
INSERT INTO sce_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","\"Kunnikewon matugieseda hende shouku giezhi zhanlao, fugie buwa, jinwun hanjiala mii fandui giezhi alane. Ghurudude aminne olune.\" ");
INSERT INTO sce_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ersa kunlade kieliewo, \"Kien mii daghane giese goyane sheidene niudunie shizijiane beiliezhi mii daghakuni wo. ");
INSERT INTO sce_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kien aminne jiuine giese aminne widaghane. Made oluzhi aminne widaghase hhe kun aminne jiuine. ");
INSERT INTO sce_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kun duyani man zhenjidene goyane peizhi widaghase yande gou wo? ");
INSERT INTO sce_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kien mase pse kieliensemi jiuren giese Kunnikewon goyane famade, pse Ada, zhiguitu qienxienlai famade irekude hhenseye jiuren giene. ");
INSERT INTO sce_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Bi tande shuhua kielieye, enende beisan kun dunda niezhanla Hudai gojiani ulie chanlatula ulie fugune.\" ");
INSERT INTO sce_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ene kielienyi kieliezhi chabudu neimudu oludene ErsaBeduru, Yaheiya, Yagebui udurudene ulade onxian giele khireiwo. ");
INSERT INTO sce_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Onxian giekude ungieni bienjidene jiensei chighan gon faizho. ");
INSERT INTO sce_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Menzhali Musa, Iliya ghuala Ersare kielien kieliezho. ");
INSERT INTO sce_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Hhela fama dunda khizhedene ErsaYelusalende fuguzhi Hudai jihua chenjikui shanlian giezho. ");
INSERT INTO sce_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Beduru, Bedurui nokielani hende nokuru hhunturazho. Hhela xiereisenu Ersai gonqii chanlawo. Hherezhe ghua kun hhantu beizho. ");
INSERT INTO sce_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Hhela likai giekude BeduruErsade kieliewo, \"Ezhan, matan enende gou wo. Enende ghuran zhanfan daiye. Niei chade, niei Musade, niei Iliyade.\" Hhe yan kieliesanne ulie mejiene. ");
INSERT INTO sce_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Hhe kieliekude niegieda olien khase hhela ayizho. ");
INSERT INTO sce_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ingiekude olien dundase nie shenqi ire kieliewo, \"Eneshi bi sunghusan mii kewon wo. Ta hhei kielienyi chenlie!\" ");
INSERT INTO sce_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Shenqi daose Ersa niezheghan feiliezho. Hhe uduse khuinashi tujila chanlasan shiqinyi kiemade ese kieliewo. ");
INSERT INTO sce_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Khuichudu ulase bouzhekude olon kunla Ersai ochirale irewo. ");
INSERT INTO sce_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kunlai dundase nie kun waradazhi kieliewo, \"Loushi, chini nie xiahua gieye. Kewonyimi nie uzhezhi ogi. Made zi niekozi kewosi wo. ");
INSERT INTO sce_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Sheitan hhei barei agise menzhali onghonoghane. Nie tigharaghase amansei momozi khizhene. Shan dailaghazhi deigo likai ulie giene. ");
INSERT INTO sce_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Bi tujilaichii xiahua giezhi nie tou khigha giese hhela khigha dawo.\" ");
INSERT INTO sce_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ersa kieliewo, \"Ai, ta ene xianxin gieku witu, xiemecha yochen kunla. Bi tanse rennai giezhi giedoghoncha beine? Chi kewonne uduru enende ire.\" ");
INSERT INTO sce_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Hhe irekude sheitan qila benda hende tigharaghawo. Ersa zannan ruhheryi nie sugie kewonni goudagha adadei jiuizhi ogiwo. ");
INSERT INTO sce_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Hudai fugie nenlii uzhedene kunla man ghanira beizho. Ersa giesan shiqinyi kunla uzhedene ghanirakude Ersa tujiladene kieliewo, ");
INSERT INTO sce_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","\"Ta ene kielienyi goude chenliezhi jila, Kunnikewonyi kunlai khade jiuine.\" ");
INSERT INTO sce_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Hhela ene kielienyi dunjire dazho. Isiini hhelade niuighazhi ese mejieghazho. Hhela ayizhi asaye dazho. ");
INSERT INTO sce_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Hhelai dunda kien zui fugie wo giezhi nienieji zhenjindu qiiwo. ");
INSERT INTO sce_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ersa hhelai zhughede yan sumulasanyi mejiedene nie kewosii uduru ire kanzidene beigha ");
INSERT INTO sce_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","hhelade kieliewo, \"Kien mii niereghala ene kewosii jienliese mii jienliezho. Mii jienliese mii peisan Hudai jienliezho. Tai dunda kien zui meilashi hhe zui fugie wo.\" ");
INSERT INTO sce_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yaheiya kieliewo, \"Ezhan, bijien nie kunyi uzhese chii niereghala sheitan touzho. Bijien danlazhi ese toughawo. Hhe bijienre hhantu chii ese daghazho.\" ");
INSERT INTO sce_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ersa kieliewo, \"Bu danla. Tai fandui ulie giese tande oluzhi giezho.\" ");
INSERT INTO sce_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ersa asiman jiere khireiku ghujinlase jiejin giezhi Yelusalende ijinyo echine giezho. ");
INSERT INTO sce_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ingie giedun kunyi dafaladene Samaliya aghinde Ersa irekuni zhunbei gieghale echiwoma, ");
INSERT INTO sce_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Yelusalende echikui mejiedene hhela Ersai ese jienliewo. ");
INSERT INTO sce_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ersai tuji Yagebu, Yaheiya ene shiqinyi uzhedene kieliewo, \"Ezhan, chi bijienyi fenfulaghazhi asiman jierese khan bouzheghadene enelai sidera widaghase olunulie?\" ");
INSERT INTO sce_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ersa ochira hhelai sugiewo. ");
INSERT INTO sce_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ingiedene hhela pse nie aghinde echiwo. ");
INSERT INTO sce_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Hhela mo yokude nie kun Ersade kieliewo, \"Chi khala echise bi chii daghane.\" ");
INSERT INTO sce_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ersa kieliewo, \"Funieghede dun wine, asiman jieredu bunzhude ho wine, Kunnikewonde nie zhentou teiku oronda uwo.\" ");
INSERT INTO sce_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ersa pse nie kunde \"Chi mii dagha.\" giezhi kieliese hhe kun \"Ezhan, bi xien adane bulale echiye.\" giezhi kieliewo. ");
INSERT INTO sce_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ersa kieliewo, \"Fugusan kun fugusan kunlane bulale echi gie, chi Hudai gojiai chonjile echi.\" ");
INSERT INTO sce_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Da nie kun kieliewo, \"Ezhan, bi chini daghanema, xien echidene giededu kunladene nie kieliedei ireye.\" ");
INSERT INTO sce_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ersa kieliewo, \"Anzhasunyi bareidene khuinane uzhesan kun Hudai gojiai pei dane.\" ");
INSERT INTO sce_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ene shiqinse khuinashi Ezhan pse 72 gie kun sunghudene goyane echiku go chenshi go oronlade ghuaghuaji melie peizhi echighawo. ");
INSERT INTO sce_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Hhelade kieliewo, \"Zhonjia olon wo, wiliechi choghon wo. Ta zhonjiani ezhanyi xiahua giezhi wiliechilai peidene zhonjiane ghuragha gie. ");
INSERT INTO sce_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ta echindu. Bi tai peizhi echighase ghoni ghughanlai zhanghei dunda echighasan niekielien wo. ");
INSERT INTO sce_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Qienbao, kuabao, maheine bu barei. Mo jiere kunlai chujieghese kielien bu asa. ");
INSERT INTO sce_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Alinie giede orose ta man pinnan onu giezhi xien asa. ");
INSERT INTO sce_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kunla tai jienliese hhelade pinnan irene, ulie jienliese pinnan tai jiere irene. ");
INSERT INTO sce_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ta alinie giede souse izhigie nie giede sou. Kunla yan ochizhi ijiekuni ogise yan kere. Eneshi wilie giechen kunde ogikuni enbene. ");
INSERT INTO sce_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Alinie chenshide tai jienliezhi yan beilase yan ijie. ");
INSERT INTO sce_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Hhendedu gientulani goudaghazhi 'Hudai gojia chadashiwo.' giezhi kielie. ");
INSERT INTO sce_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Alinie chenshide tai ulie jienliese geidoude echidene kielie, ");
INSERT INTO sce_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","\"Tai aghinni turailiuzhe kon jieresene kui boughazhi fandui giene. Ingieliuzhe Hudai gojia chadashisei ta mejiendu.\" giezhi. ");
INSERT INTO sce_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Bi tande kielieye, panjiku udude hhe chenshi shouiku zeinan Sodomase da fugie wo. ");
INSERT INTO sce_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Gelaxin, Bosaida, tande gou widawo. Tai dunda giesan nenlitu shiqinni Tuilo, Xidunde giewoshi hhela eqighanse madei zhodene jierene funiesun teizhi zemin jiere soudene geizhen giewo. ");
INSERT INTO sce_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Panjiku shihoude ta shouiku zeinan Tuilo, Xidunse da fugie wo. ");
INSERT INTO sce_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Jiabainun, Chii undudaghazhi asiman jiere khireighanu? Chii dozoheide anda boughane!\" ");
INSERT INTO sce_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","\"Kun tai kielienyi chenliese mini kielienyi chenliezho. Tai kielienyi ulie chenliese mini kielienyi ese chenliezho. Mii ulie jienliese mii peisan Hudai ese jienliezho.\" ");
INSERT INTO sce_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Hhe 72 gie kun bayasuzhi kharei ire kieliewo, \"Ezhan! Chii niereghala giese sheitanlaye bijienyi feiwo.\" ");
INSERT INTO sce_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ersa hhelade kieliewo, \"Bi chujieghese Ibilisi asiman jierese shanjien mutun anda bou irewo. ");
INSERT INTO sce_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Bi tande moghei, xiezilai taizhi duitoulai soyuji lilianse injizhi daoku qienli ogiwo. Yanliuzhe tai hei dane. ");
INSERT INTO sce_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ingieliuzhe sheitanla tai feiwo giese bu bayasudene nierelaitai asiman jiere jilasande bayasundu.\" ");
INSERT INTO sce_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ene shihoude Ersade Shenlin durudene bayasuzhi kieliewo, \"Asiman zeminni Ezhan, Ada, chii mafan gieghawo. Chi ene shiqinlani agheli, erlintu kunlade niuighazhi ga kewosi mutun kunlade mejieghawo. Ada, enbene, eneshi chi duranghalane giesan wo. ");
INSERT INTO sce_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Soyujilashi man Adami made ogisanwo. Adase chugo kewonni kiema ulie mejiene. Kewon, pse kewon yenyi mejieghasan kunse chugo Adani kiema ulie mejiene.\" ");
INSERT INTO sce_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ersa kharei ochira tujiladene danlin kieliewo, \"Ta ede uzhesei uzhese tande fuqi wine. ");
INSERT INTO sce_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Bi tande kielieye, olon xienzhi, honshanla ta uzhesei uzhene giezhoma, uzhe dazho. Ta chenliesei chenliene giezhoma, chenlie dazho.\" ");
INSERT INTO sce_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nie jinwun loushi bosizhe Ersai shiizhi asazho, \"Loushi, bi matui giese chanqiku aminni jienliene?\" ");
INSERT INTO sce_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ersa kieliewo, \"Guijin jiere yan huaizho? Chi yan onshiwo?\" ");
INSERT INTO sce_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Hhe kieliewo, \"Chi qienbuji zhughe, qienbuji jinshen, qienbuji lilian, qienbuji sumulakughalane Ezhan Hudadene ore. Pse goyadene mutun giebeidene ore.\" ");
INSERT INTO sce_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ersa kieliewo, \"Chi kieliesan oluzho. Chi qingiezhi giese amiturane.\" ");
INSERT INTO sce_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Hhe kun goyane olusei mejieghane giezhi Ersade asawo, \"Kienshi mini giebei wo?\" ");
INSERT INTO sce_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ersa kieliewo, \"Nie kun Yelusalense Yeligede boukude qiandaolani khade orowo. Eghizhi fugughakude kudene jienlaini agi echi benda jiewo. ");
INSERT INTO sce_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ingie nie buwa hhe mose bou, hhei chujieghedene mo bienzighun yo daowo. ");
INSERT INTO sce_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Pse nie Liwi kun hhende ire chujieghedene ye mo bienzighun yo daowo. ");
INSERT INTO sce_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ingie nie Samaliya kun mo yokude hhende ire, ubali xiizhi ");
INSERT INTO sce_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","shidani echi shankouni tosun, jiughala waghazhi bouizhi goudaghadene enzheghe jiere achi lishede echi zhaogu giewo. ");
INSERT INTO sce_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Khuichudu ghua miengui lisheni ezhande ogizhi kieliewo, 'Chi enei uzhezhi zhaogu nie gie. Baer ulie kuruse bi pse irese ogiye.'\" ");
INSERT INTO sce_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ersa kieliewo, \"Chi sumula, ene ghurulie dundase alinieshi qiandaolai khade orosan kunni giebei wo?\" ");
INSERT INTO sce_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Jinwun loushi kieliewo, \"Hhe ubali xiisan kun wo.\" Ersa kieliewo, \"Chi ye echidene qingiezhi gie.\" ");
INSERT INTO sce_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ersa tujilaghalane Yelusalenni mo jiere echikude nie aghinde orowo. Hhende nie biereini niereni Mada giene. Ersai jienliezhi giedene echiwo. ");
INSERT INTO sce_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Giedeni nie oqinjiu wine. Niereini Mereiyen giene. Ersai kon shida souzhi goude kielienyini chenliezho. ");
INSERT INTO sce_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mada zhochen ushilazhi hende munan gie Ersade ire kieliewo, \"Ezhan, chi ene oqinjiuimi ulie gonjinu? Enende souzhi jin mini wilie gieghazho. Ede chi kieliezhi made banman giegha!\" ");
INSERT INTO sce_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ezhan kieliewo, \"Madaya, chi olon wilie giene giezhi munan giezhoma, ");
INSERT INTO sce_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","zhunyonishi nie wo. Mereiyen gounii sunghuwo, kiema agizhi echi dane.\" ");
INSERT INTO sce_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Niudude Ersa nie oronde onxian giezho. Onxian giezhi baludene nie tuji Ersade kieliewo, \"Ezhan, Yaheiya tujiladene sughasan mutun chiye bijiende onxian giekui surugha.\" ");
INSERT INTO sce_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ersa hhelade kieliewo, \"Ta onxian giekude ingiezhi kielie, 'Ada, chi nierene zhiguishigha. Chii gojiai iregha. ");
INSERT INTO sce_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Niudunieku ijiuni niudunie bijiende ogi. ");
INSERT INTO sce_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Bijienni zuini mienlie. Bijiende zui fanjisan kunlai bijienye mienliewo. Bijienyi shiikude bu echigha.'\" ");
INSERT INTO sce_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ersa hhelade kieliewo, \"Tai dunda kien nie kun banyedei zhanlienne giede echi zhanlien, made ginansene ghuran ghuizhi ogi. ");
INSERT INTO sce_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Bijienni giede nie zhochen irewoma, ijiuni widawo giese ");
INSERT INTO sce_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","hhe gie sudorose mii bu pofansagha. Wijienlani man khazhi kewosilare hhantu kijiezho. Bosizhi chade ogiku chijia wo giene. ");
INSERT INTO sce_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Bi tande kielieye, ene kun zhanlien wo giezhi ulie oginema, ninkounin keresei uzhese bosizhedene ogine.\" ");
INSERT INTO sce_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","\"Tande bi kielieye, ta xiahua gie, tande ogine. Erei, ereizhi olune. Wijienni eghi, tande niene. ");
INSERT INTO sce_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Xiahua giechen kunlade ogine. Ereichen kunla ereizhi olune. Wijienni eghichen kunlade niene. ");
INSERT INTO sce_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Tai dunda ada danlachen kien kewon zhaghasun kerese moghei ogine? ");
INSERT INTO sce_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Endeghei kerese xiezi ogichen kun uwola? ");
INSERT INTO sce_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ta gou wiliuzhe kesiladene gouni ogikuni mejiene, asiman jieredu Ada xiahua giechen kunlade Shenlinni genjia ulie oginu?\" ");
INSERT INTO sce_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ersa nie kunyi sudorose yaba sheitanni tou khighawo. Ingie hhe yaba kielien kielie qiise kunla man ghanirazho. ");
INSERT INTO sce_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ingie niezhan kunla kieliezhi hhe sheitanni touzi Biexibui kouizhi sheitan touzho giewo. ");
INSERT INTO sce_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Pse niezhan kunla hhei shiizhi asiman jierese iresan ghudureqi xienjigha giezho. ");
INSERT INTO sce_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ersa hhela yan sumulasei mejiedene kieliewo, \"Alinie gojia goyalane eghinduse hontan gholune. Alinie giei kunla goyalane eghinduse bixindane. ");
INSERT INTO sce_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ta kieliese bi Biexibui kouizhi sheitan touzho, Ibilisi goyalane eghinduse hhei gojia matugie beine? ");
INSERT INTO sce_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Bi Biexibui kouizhi sheitan touse tai tujila kienyi kouizhi sheitan touzho? Ingiese tai tujila zhenmin giese tanughun codazho. ");
INSERT INTO sce_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Bi Hudai nenlighala sheitan touse Hudai gojia tande irezho. ");
INSERT INTO sce_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Nie uqine qiendaghasan kun giene sagheise dunxila man pinnan wo. ");
INSERT INTO sce_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Hhense lilian pse fugietu kun ire, hhei eghizhi kouisan uqilaini agi echi, dunxilani man ghughawo. ");
INSERT INTO sce_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Mii miende ulie beise mii duitou wo. Mare ulie hhantulachen kunshi sandachen kun wo.\" ");
INSERT INTO sce_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","\"Nie zannan ruhher kunni jierese likai giedene usu witu oronde izhigie yozhi hhamuraku oron ereizho. Ereizhi olu dadene kieliewo, 'Bi yen khizhesan hhe giedene echine.' ");
INSERT INTO sce_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Khareizhi echi nie uzhese shuzhi goudagha jiezho. ");
INSERT INTO sce_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ingie khizhi echi dolon doghun ruhheryi uduruzhi ire souwo. Ingiese hhe kunni qinkon melieshidakude pse ese kuruwo.\" ");
INSERT INTO sce_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ersa zhen kieliekude kunlai dundase nie bierei fugiede waradazhi kieliewo, \"Chini laizhi gogoghazhi fugiedaghasan kunde fuqi wine!\" ");
INSERT INTO sce_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ersa kieliewo, \"Hudai kielienni zunjizhi giesan kunde zhenzhen fuqi wine.\" ");
INSERT INTO sce_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kun olodokude Ersa pse kieliewo, \"Ene idai kunla yale intu doghun wo. Ghudureqi kerezhoma, Yunusii ghudureqise chugo xienjighaku ghudureqi uwo. ");
INSERT INTO sce_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","YunusiNiniwi kunlade oluzhi ghudureqi gholusan mutun Kunnikewonye ene idaini kunlade ghudureqi gholune. ");
INSERT INTO sce_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Panjiku udude nanfanni bierei honshan bosizhedene ene idaini kunlade zui jinjine. Hhe gholose Sulumaneni aghelini chenliele irewo. Uzhe, enende Sulumanese pse fugieni wine. ");
INSERT INTO sce_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Panjiku udude Niniwi kunla bosizhezhi ene idai kunlai zuini jinjine. Niniwi kunla Yunusi chonjisei chenliedene geizhen giewo. Uzhe, Yunusise pse fugieni enende wo!\" ");
INSERT INTO sce_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","\"Zhulai jienjidene jiude niuighachen kun uwo. Ighaghala komorochen kunye uwo. Zhula teiku teizi jiere teise kunla orozhese chujieghene. ");
INSERT INTO sce_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nudunchiishi beyeni zhula wo. Nudunchii goushi beyechii man gieghan wo. Nudunchii gou wise beyechii man khara wo. ");
INSERT INTO sce_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Goyane xianxide uzhe, pse sudorodu gonchii kharalane. ");
INSERT INTO sce_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Chii jiere kharani goujighanida wi man gieghanshi zhula chini zhouisan mutun gieghan wo.\" ");
INSERT INTO sce_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ersa kielien kieliekude nie Falisai kun Ersai xinlawo. Ingie Ersa echidene xi jiere souwo. ");
INSERT INTO sce_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ersa khane ese wagha ijiese hhe Falisai kun ghudure wo giezho. ");
INSERT INTO sce_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ezhan hhende kieliewo, \"Ta Falisai kun beizi, jiezi mienzii wagha arughazhoma, tai sudoro jin qianlaku okhoni duruzho. ");
INSERT INTO sce_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ta yama mejie dachen kunla, tani ghadanedui zhayaghasan Huda tani sudorodui ese zhayaghawu? ");
INSERT INTO sce_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ta sudorodedu dunxilane jiahui kunlade ogi. Qingiese tande man ganjin wo.\" ");
INSERT INTO sce_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","\"Ingiezhoma, ta ene Falisai kunlade gou widawo! Ta bohe, huajio, yanyanji cailasene Hudade ushirei ogizhoma, gundande gieku, Hudade orekuni zhunshi ulie giene. Enelai ta indan giekui wo, psedulaiye ulie giekui pusho.\" ");
INSERT INTO sce_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","\"Ta ene Falisai kunlade gou widawo! Ta huitanni undu wizide soukude xiqi wo. Geidoude kunla tande kielien asakude xiqi wo. ");
INSERT INTO sce_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Tande gou widawo! Ta hao witu meza niekielien wo. Kunla mejie dazhi taine.\" ");
INSERT INTO sce_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nie jinwun loushi Ersade kieliewo, \"Loushi, chi ingiezhi kieliese bijienyiye jiuren gieghazho.\" ");
INSERT INTO sce_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ersa kieliewo, \"Ta jinwun loushiladeye gou widawo! Ta kunlai jiere bazilie daku qimutu gundu danzii beilieghadene goya kha ghurunghalane goujida banman ulie giene. ");
INSERT INTO sce_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Tande gou widawo! Tai xienrenla alasan xienzhilade ta meza giezho. ");
INSERT INTO sce_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ingiese hhela giesei ta ganzhen beizhi zanchen giezho. Hhela alawo, ta meza giezho. ");
INSERT INTO sce_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Hudade agheli olonshi ingiezhi kieliewo, 'Bi xienzhi, peisan kunlai hhelade echighane. Hhela niezhanlai heine, niezhanlai alane.'\" ");
INSERT INTO sce_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","\"Ingiese duyai zhayaghasanse alasan soyuji xienzhilai chusunni guini man ene idai kunlai jiere teine. ");
INSERT INTO sce_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Jiushi Hhabini alasanse qiizhi izhi sidagha gieku teiziji dajien dunda Sajialiyai alasan zuini guini man ene idai kunlai jiere teine. Enbene, bi tande kielieye, ene guini ene idai kunlai jiere teine. ");
INSERT INTO sce_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ta jinwun loushilade gou widawo! Ta Hudai taniku yeshii agizhi echidene goyalane ese orowo, orone giechen kunlaiye ese oroghawo.\" ");
INSERT INTO sce_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ersa enense ghadane khireise jinwun hanjia, Falisai kunla Ersai hende fandui giedene unqi olon asazhi ");
INSERT INTO sce_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","kieliensei babin ereine giezho. ");
INSERT INTO sce_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ingiekude jiqien jiwon kun hhantulazhi nieniene taikui xianli. Ersa xien tujiladene kieliewo, \"Ta Falisai kunni kunieghei xioxin gie. Hhelashi jiazhon giesan kun wo. ");
INSERT INTO sce_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Jizide giesan shiqinlai ulie khizheghakui uwo. Niuighasanlai ulie mejieghakui uwo. ");
INSERT INTO sce_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ta beichazide kieliesan kielienlai kunla ghadane mindamin chenliene. Ta giedera chighinde kieliesei kunla gie jiere fugiede kieliene.\" ");
INSERT INTO sce_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","\"Mini zhanlienla, bi tande kielieye, beyeni aladene pse yama gie dachen hhelase bu ayi. ");
INSERT INTO sce_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Bi tande kiense ayikui mejieghaye, beyeni aladene dozoheide echighaku qienli bichen hhense ayi.\" ");
INSERT INTO sce_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","\"Tawun bunzhui 2 mao baer huinela? Ingieliuzhe Huda hhelai nieda ulie matane. ");
INSERT INTO sce_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Tai qiorun jieredu usunniliuzhe toulazhi agizho. Ta bu ayi, ta olon bunzhulase zhunyo wo.\" ");
INSERT INTO sce_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","\"Bi pse tande kielieye, kien kunlai melie mini renjise Kunnikewonye Hudai qienxien melie hhei renjine. ");
INSERT INTO sce_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kien kunlai melie mini ulie renjise bi Hudai qienxien melie hhei ulie renjine. ");
INSERT INTO sce_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Kunnikewonni fandui giezhi kieliese roulienema, Shenlinni hu kieliese ulie rouliene. ");
INSERT INTO sce_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Kunla tai laizhi huitan, noyen, qienli bareichen kun shida echise ta matugie huida giekui, yan kieliekui munan bu gie. ");
INSERT INTO sce_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Hhe shihou kuse ta yan kieliekuni Shenlin mejieghane.\" ");
INSERT INTO sce_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ingiedene olon kunla dundase nie kun Ersade kieliewo, \"Loushi, chi gaidemi kieliezhi jiachanyi made ghughazhi ogi gie.\" ");
INSERT INTO sce_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ersa kieliewo, \"Chi ene kun, mini tande kien noyen danlaghazhi gieni ghughaghane?\" ");
INSERT INTO sce_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ingie pse kieliewo, \"Ta xioxin giezhi yanyanji tanxin giekulase gholodo. Kunni amin olon baerghala gonxi uwo.\" ");
INSERT INTO sce_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Pse bilazhi kieliewo, \"Nie bayan kunyi ghazhadeni osisan zhonjia gansan no wo. ");
INSERT INTO sce_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Hhe sumulawo, 'Bi ene zhonjiani khala teine? Teiku oron uwo.' ");
INSERT INTO sce_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Pse bi ene cankune cheidene pse fugiede nie gie, taran dunxilane teiye giezho. ");
INSERT INTO sce_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ingie goyadene made ijin sunjisan olon no wo. Jinien ijieliuzhe bara dane. Ede suibien ijiezhi ochizhi udu daose olune giezho. ");
INSERT INTO sce_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ingiese Huda hhende kieliewo, 'Chi ene ulie mejiechen kun! Ene xii chi fugu widase dunxilachii kiende feiliene?'\" ");
INSERT INTO sce_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ersa kieliewo. \"Jin goyadene boubeini sunjizhi Hudai miende bayan wichen kunshi man intui wo.\" ");
INSERT INTO sce_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ersa tujiladene kieliewo, \"Ingiese bi tande kielieye, ta amindene oluzhi yan ijiene, musine giezhi munan bu gie. ");
INSERT INTO sce_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Amin ijiekuse zhunyo wo, beye musikuse zhunyo wo. ");
INSERT INTO sce_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ta louwalani uzhe, hhela yama ese tareizho, ese ghurazho, ghuraku canku ye uwoma, Huda qiezhezho. Ta bunzhulase zhunyo uwonu? ");
INSERT INTO sce_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Tani dunda kien zhughe chilakughala aminne niecha fududagha shidane? ");
INSERT INTO sce_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ta intughani ga shiqinyi gie dane, pseshiku shiqinde munan giezhi yangiene? ");
INSERT INTO sce_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ta baihe chizhe matugie osisei nie uzhe, hhela ulie khishilane, bosiye ulie giene. Bi tande kielieye, Sulumane honshan zui henni xienzide musisanla ene nie chizhede ulie kurune. ");
INSERT INTO sce_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ta goude xianxin ulie giechen kunla, banche jieredu osun enedu wine, maghashijie luzide teiliuzhe Huda dou ingiezhi dabalaghazho. Tai qingie ulie gienu? ");
INSERT INTO sce_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ta ijiezhi ochikude xiahua bu giezhi munan bu gie, ");
INSERT INTO sce_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","enelashi man duyani kunla xiahua giekuni wo. Tande enezighan chaisanlai Adatai mejiene. ");
INSERT INTO sce_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ta Hudai gojiai xiahua gie, ingiese enelai man tande ogine.\" ");
INSERT INTO sce_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","\"Ta kun choghontu kunla, bu ayi. Tai Ada bayasuzhi asiman gojiani tande ogine. ");
INSERT INTO sce_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ta giededu dunxilane huizhi nanxin kunlade ghughazhi ogi. Goyadene oluzhi ulie qida oluku qienbaoni zhunbei giedene boubeini asiman jiere sunji. Hhende boubeila ulie widane, ghughei ghula dane, ghughei ijie dane. ");
INSERT INTO sce_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tai boubei khalashi zhughetaiye khala wo.\" ");
INSERT INTO sce_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","\"Ta pixiene pixiliezhi zhulane jienjidene goude zhunbei gie. ");
INSERT INTO sce_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Eneshi nie ezhan ghurunse irekuni sagheisan hojila niekielien wo. Ezhan iredene wijienyi eghikure hhantu niewo. ");
INSERT INTO sce_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ezhan irekude zeixin giesan hojilade fuqi wine. Bi tande shuhua kielieye, Ezhan goya wilie gieku jienne musidene hojilani shire jiere soughazhi ushilane. ");
INSERT INTO sce_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Hhe banyede iremu, giegherekude irekude hojila ingiezhi giesei uzhese hhe hojilade fuqi wine. ");
INSERT INTO sce_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ta enei mejie, giei ezhan ghughei yan xienzide irekui mejiese giedene ulie oroghane. ");
INSERT INTO sce_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Taye goude zhunbei giendu, ta mejie dakude Kunnikewon irene.\" ");
INSERT INTO sce_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Beduru kieliewo, \"Ezhan, ene bilasan kielienni bijiende kieliewu, dajialade kieliewo?\" ");
INSERT INTO sce_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ezhan kieliewo, \"Qinse kienshi kekaotu jienzha giechen gonjia wo? Zhanguijini hhende giededu hojilai, ijiekulani man gonjighasan pushonu? ");
INSERT INTO sce_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Zhanguiji irekude hoji ingiezhi giesei chanlase hhe hojide fuqi wine. ");
INSERT INTO sce_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Bi tande shuhua kielieye, zhanguiji hhende caichanlane man gonjighane. ");
INSERT INTO sce_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Hhe hoji zhughedene sumulazhi mini zhanguiji deigo ulie irene gie, kewon, oqin hojilai eghizhi ijiezhi jiu ochizhi sudose ");
INSERT INTO sce_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","hhe sumula daku udu, mejie daku shihoude zhanguijini iredene hhei sidasunyi qiuizhi kielien ese chenliesan kunlare hhantu faine. ");
INSERT INTO sce_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ene hoji ezhanni isini mejiewoma, zhunbei ese giewo. Zhanguijini kielien mutun ye ese giewo. Ingiese hheni gundude faikuni wo. ");
INSERT INTO sce_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Zinie zhanguijini isini mejie dazhi gou ese giesan kunlai gongiende faine. Olon ogisan kunlase olon kerene, choghon ogisan kunlase choghon kerene.\" ");
INSERT INTO sce_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","\"Bi zemin jiere khan teile irewo. Bi sumulase khan ghujighan sidera qiisejiu. ");
INSERT INTO sce_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Made da nie chijia xili giekuni wine. Hhei onchen gietula made yali fugie no wo. ");
INSERT INTO sce_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ta sumulase bi zemin jiere pinnan deilazhi irewo giezhou? Uye, bi tande kielieye, bi tani fandui gieghale irewo. ");
INSERT INTO sce_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Enedu khuinase nie giede tawun kun bise ghuran kun ghua kunghala fandui giene, ghua kun ghuran kunghala fandui giene. ");
INSERT INTO sce_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ada kewonghalane fandui giene, kewon adaghalane fandui giene, ana oqinghalane fandui giene, oqin anaghalane fandui giene, ghadunmekie konbiereighalane fandui giene, konbierei ghadunmekieghalane fandui giene.\" ");
INSERT INTO sce_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ersa pse olon kunlade kieliewo, \"Ta xibangiede olien nie chanlase 'Ghura boune.' giezhi kieliene. Kieliese boune. ");
INSERT INTO sce_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nanbangiese kei bosise, 'Khalundane.' giezhi kieliese khalundane. ");
INSERT INTO sce_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ta ene jiazhon giesan kun, ta qienqi bienjikuni mejiene, ene shihouni fenji dane?\" ");
INSERT INTO sce_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","\"Ta yale alinie olusei fenji dane? ");
INSERT INTO sce_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Chi noyenyi shida echikude mo jiere duitoughalane gouda. Pse hhe chii panjiku noyen shida lai echise panjiku noyen gunnande jiuise gunnan chii bafanzide khane. ");
INSERT INTO sce_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Bi chade kielieye, chi 1 fen baerniliuzhe honjizhi ulie qindaghase bafanzise khizhe dane.\" ");
INSERT INTO sce_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ene shihoude danchan kunla BiladoJialili kunlai alasan chusunni hhelai sidagha giesan dunxi dunda huighasan shiqinni Ersade kieliewo. ");
INSERT INTO sce_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ersa asawo, \"Ta sumulase ene Jialili kun psedu Jialili kunlase fanjisan zui fugieshi alawu? ");
INSERT INTO sce_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Uye. Bi tande kielieye, ta geizhen ulie giese hhela mutun fugune. ");
INSERT INTO sce_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Pse hhe Xiloya orondeni lou tairedene 18 gie kunyi daru alawo. Ta sumulase ene kunla Yelusalen kunlase fanjisan zui fugie onu? ");
INSERT INTO sce_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Uwo. Bi tande kielieye, ta geizhen ulie giese hhela mutun fugune.\" ");
INSERT INTO sce_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ingiedene Ersa pse bilazhi kieliewo, \"Nie kun putou yenzide nie uhuago mutun zeilawo. Hhe mutunsene alima ereile irese nieda ereizhi olu dawo. ");
INSERT INTO sce_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ezhanni yenzi sagheisan kunde kieliewo, 'Uzhe, bi ene 3 niende uhuago mutun jierese alima nieda chujieghe dawo. Eneni chizhi daogha, belien oron ezheliezho.' ");
INSERT INTO sce_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Yenzi sagheisan kun kieliewo, 'Ezhan, ene hon nie liui. Bi ene zhouwi turani waikude hhagha teiye. ");
INSERT INTO sce_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Khuinashi alima souse sougie, ulie souse chizhi widaghaye.'\" ");
INSERT INTO sce_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Hhamuraku udude Ersa huitande kunlade sughazho. ");
INSERT INTO sce_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Hhende sheitan heizhi 18 nien nurunne zhidagha dasan nie bierei wine. ");
INSERT INTO sce_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ersa chanla uruzhi ire kieliewo, \"Funi, ede chi giensene andawo.\" ");
INSERT INTO sce_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ingie hheni jiere ghua khane teise deigo goudazhi bierei Hudai kuaizho. ");
INSERT INTO sce_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Huitan gonjisan kun Ersa hhamuraku udude gien goudaghase hokuzhi kunlade kieliewo, \"Hhe tawun zhighudu winema, yangiezhi hhamuraku udude goudaghane?\" ");
INSERT INTO sce_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ezhan kieliewo, \"Ta ene jiazhon giesan kun, ta hhamuraku udude fughe, enzheghelane khudonse khizheghazhi ulie sulanu? ");
INSERT INTO sce_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ene biereishi Iburaheimuni houdei wo, hhei 18 nien Ibilisi heizhi giedalaghazho, hhamuraku udude andaghase ulie olunu?\" ");
INSERT INTO sce_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ingiesenu fandui giesan kunla nanchan duruzho. Ersa giesan famatu shiqinlai uzhedene kunla man bayasuzho. ");
INSERT INTO sce_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ersa pse kieliezho, \"Hudai gojia yanni xianli? Yanghala bilane? ");
INSERT INTO sce_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Hoxian nie caizi furei xianli. Kun agizhi echi yenzidene tareise fugiedazhi mutun gholuse chala jiere bunzhula holiene.\" ");
INSERT INTO sce_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ersa pse kieliewo, \"Hudai gojiai yanghala bilane? ");
INSERT INTO sce_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Hoxian kunieghei xianli. Nie bierei agizhi echidene nie deizi ghurunde teizhi man faighazho.\" ");
INSERT INTO sce_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ErsaYelusalenni mo jiere echikude kunlai chenshi aghinlade sughazho. ");
INSERT INTO sce_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nie kun asazho, \"Ezhan, jiuisan kun choghon woba?\" Ersa kunlade kieliewo, ");
INSERT INTO sce_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","\"Witan wijiense orokuni xiacha gie. Bi tande kielieye, orone giechen kun olon wo, oro dane. ");
INSERT INTO sce_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Giei ezhan wijienni khase ta ghadanese wijienni eghizhi 'Ezhan, bijiende wijienni nieya.' giese hhe 'Bi tai tani dane. Ta khalase iresei bi ulie mejiene.' giezhi kieliene. ");
INSERT INTO sce_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Hhe shihoude ta kieliene, 'Hhe xienzide matan hhantu ochizhi ijienduzho. Pse chi bijienyi geidoude sughazho.' ");
INSERT INTO sce_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ingiese hhe kieliene, 'Bi tande kielieye, ta khalase iresei bi ulie mejiene. Ta ene huaishi giesan kunla, mase likai gie.'\" ");
INSERT INTO sce_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","\"Ta Hudai gojiade Iburaheimu, Isaghei, Yagebu, pse hhe xienzhilani man chanlaku shihoude tani toudene ghadane khighase ta shidunne zhouzhi wilane. ");
INSERT INTO sce_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Dunnanxibeise kunla irezhi Hudai gojiade xi soune. ");
INSERT INTO sce_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Chenlie, khuinashikula melieshilane, melieshikula khuinashilane.\" ");
INSERT INTO sce_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Zhen ingiekude giedun Falisai kun ire Ersade kieliewo, \"Chi enense likai gie, Hherode chini alane giezho.\" ");
INSERT INTO sce_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","\"Ta echidene hhe funieghede kielie, 'Enedu maghashijie bi sheitanlani touzhi gien goudaghane, chinaer mini shiqin barawo.' ");
INSERT INTO sce_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Enedu, maghashi, chinaer bi bixi mone yone, Hudai xienzhini Yelusalense chugo ala dane. ");
INSERT INTO sce_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yelusalen, Yelusalen, peizhi ireghasan xienzhilai tashidazhi alasan chenshiya. Bi chii kesilani gieduifa muji tigha zhunzhughalane siban doura hhantulaghaku mutun hhantulaghane giese ta duran uwo. ");
INSERT INTO sce_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Uzhe, chii gie hontan gholuzhi chade feiliene. Bi chade kielieye, chi 'Ezhanni niereghala iresan kunni doulandu.' giezhi kielietula mii pse chanla dane.\" ");
INSERT INTO sce_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Hhamuraku udude Ersa nie Falisai kunni lindaoni giede ijiele echikude kunla ghulazhi uzhezho. ");
INSERT INTO sce_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Zhen hheni melie shighara beghelieni khaitusan kun wine. ");
INSERT INTO sce_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ersa jinwun loushi, Falisai kunlade asazho, \"Hhamuraku udude gien uzhese olunu ulie olune?\" ");
INSERT INTO sce_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Hhelade shenqi uwo. Ersa hhei jiere khane tei, uzhe goudaghadene echighawo. ");
INSERT INTO sce_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ingie hhelade kieliewo, \"Tai dunda hhamuraku udude enzheghe, fughe nokiende anda bouse laizhi ulie khizhenu?\" ");
INSERT INTO sce_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Hhela ene kieliende yama kielie dawo. ");
INSERT INTO sce_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Xinlazhi iresan zhochenla goyalane shanxide echi souwo. Ersa hhelai chanla bilazhi kieliewo, ");
INSERT INTO sce_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","\"Ta ghurunde echise shanxide bu sou, tanse fugie zhochen bise tani daoghane. ");
INSERT INTO sce_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Giei kun iredene kieliese chi ene oronyi zhochende nie ranji giese chi shizhezhi daone. ");
INSERT INTO sce_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Xinlazhi irekude ta zui bixinni oronde souse xinlasan kun chini uruzhi kieliene, 'Zhanlien, chi ene shanxide sou.' Ingiese kunla uzhese giedughon gou wo. ");
INSERT INTO sce_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kien goyane undudaghase boghonidaghane. Goyane boghonidaghase undudaghane.\" ");
INSERT INTO sce_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ersa xinlasan kunde kieliewo, \"Chi udukun, heifande zhanlienlane, gaijiulane, qingulane, giebei bayankunlai bu xinla, pse hhelaye chii xinlane. ");
INSERT INTO sce_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Chi ghurun ijiekude nanxin kunla, canfei, dogholon, sugho, enelani xinla, ingiese chade fuqi wine. ");
INSERT INTO sce_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Hhela chini khareizhi xinla danema, gou kunla fuho giekude Huda chade gouni ogine.\" ");
INSERT INTO sce_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Hhantu sousan kun dunda nie kun enei chenliedene Ersade kieliewo, \"Hudai gojiade xi ijiesan kunde fuqi wine.\" ");
INSERT INTO sce_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ersa hhende kieliewo, \"Nie kun fugiede xi beilazhi zhochen olon xinlawo. ");
INSERT INTO sce_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Xi souku shihoude hojine peizhi xinlasan kunlai urughale echiwo, 'Irendu, man zhunbei gie goudaghawo.' ");
INSERT INTO sce_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Kunla nienieji man tui qiiwo. Tou 1 gie kun kieliewo, 'Bi nie ghazha agizho. Uzhele echine. Ire dane. Bu hoku.' ");
INSERT INTO sce_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Da nie kun kieliewo, 'Bi 5 dui fughe agiwo. Shiile echine. Bu hoku.' ");
INSERT INTO sce_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Pse nie kun kieliewo, 'Bi bierei agiwo, ingiese echi dane.'\" ");
INSERT INTO sce_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","\"Hhe hoji kharei iredene ezhandene ene shiqinni man kieliewo. Ezhan hokuzhi hojidene kieliewo, 'Ghujighan echidene chenshini fugie geidou, ga geidoudedu nanxin kun, canfei, sugho, dogholonlai urude ire.' ");
INSERT INTO sce_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Hoji ezhandene kieliewo, 'Chi kieliesanlai man banji goudaghawo, da kun oron wine.' ");
INSERT INTO sce_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Hojidene kieliewo, 'Chi echidene dalu mo jieredu, ga mo jierededu kunlai ninkounin uruzhi iredene mini oronni souzhi durugha.' ");
INSERT INTO sce_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Bi tande kielieye. Touchan xinlasan dunda mini ghurunse ijiechen kun nieda uwo.\" ");
INSERT INTO sce_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tebieji olon kun Ersare hhantu yozho. Hhe ochiradene hhelade kieliewo, ");
INSERT INTO sce_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","\"Kun mini enende irese goyane ada, ana, bierei, kesila, eghechijiu, gaijiulasene, pse goya aminsene made olon ulie orese mini tuji danla dane. ");
INSERT INTO sce_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kien goya shizijiane beiliezhi mii ulie daghase mini tuji danla dane.\" ");
INSERT INTO sce_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","\"Ta kien lou giekude giezhi gholughanu gholugha dane giezhi baerni ulie sananu? ");
INSERT INTO sce_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kunpa ta jichune jiedene pse giedase kunla uzhezhi xiniene, ");
INSERT INTO sce_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","'Ene nie kun loune giedene giezhi khigha dawo.'\" ");
INSERT INTO sce_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","\"Pse nie honshan hhe nie gojiani honshanghala eghindune giese xien soudene kun giedughon bikuni ulie sananu? Bi 10000 kunghala kunlai 20000 kunni eghi shidanu? ");
INSERT INTO sce_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Eghi dase hhela gholo bikude kun nie peisenu matugiezhi heqishighakui shanlian giene. ");
INSERT INTO sce_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kienliuzhe shihenine ulie jiese mini tuji danla dane.\" ");
INSERT INTO sce_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","\"Dansunshi gouni wo. Widaoni widase pse matugie koudaghane? ");
INSERT INTO sce_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Widao widasan dansunni ghazha, hhaghade teise yama zoin uwo. Zinie ghadane bendane. Chighin bitu kunla chenliendu!\" ");
INSERT INTO sce_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Shui shanjisan kun, zuirenla Ersani shida echizhi jianjisanyi chenliene giezho. ");
INSERT INTO sce_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Falisai kun, jinwun hanjiala nieniedene Ersani sugienduzhi ene kun zuirenlare hhantu souzhi ijiezho giezho. ");
INSERT INTO sce_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ingiese Ersa hhelade bilazhi kieliewo. ");
INSERT INTO sce_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","\"Tai dunda kien 100 gie ghoni dunda nie ghoni yo widase 99 gie ghonine banchede jiedene widasan ghonii ereizhi ulie olunu? ");
INSERT INTO sce_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ereizhi oludene bayasuzhi dalou jierene danladene giedene echiwo. ");
INSERT INTO sce_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Zhanlien, giebeiladene widasan ghoni ereizhi oluwo. Matan hhantu hunnerei daghaye giezho. ");
INSERT INTO sce_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Bi tande kielieye, nie zuiren geizhen giese asiman jiereye hhende oluzhi bayasune. Hhe geizhen gieku biyo wichen 99 gie gou kunlase pse olon bayasune.\" ");
INSERT INTO sce_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","\"Pse nie bierei hharan miengusene nieni wida khighase zhulane jienjidene gieni xianxide shuzhi ereizhi ulie olunu? ");
INSERT INTO sce_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ereizhi oluse zhanlienlane giebeilane uruzhi matan hhantu nie hunnerei daghaye giene. ");
INSERT INTO sce_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Bi tande kielieye, nie zuiren geizhen giese Hudai qienxienla hhende oluzhi ingiezhi bayasune.\" ");
INSERT INTO sce_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ersa pse kieliewo, \"Nie kunde ghua kewon wo. ");
INSERT INTO sce_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ga kewonni adadene kieliewo, 'Ada, chi jiachanse made kuruku nexianni ghughazhi ogi.' Ingiese adani goya jiachanne ghualade ghugha ogiwo.\" ");
INSERT INTO sce_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","\"Giedudu beidene ga kewonni dunxilane agidene niman gojiade echiwo. Ingiedene dunxi baerlane man hu zharu widaghawo. ");
INSERT INTO sce_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Man huai widaghasenu hhe oronde honnien penjise nanxinshizhi oliesuzho. ");
INSERT INTO sce_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ingie hhe oronni nie kunde kouizhi ghazhade khighei qiezheghazho. ");
INSERT INTO sce_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Hende oliesuse khighei ijieku noshui ijiene gieliuzhe kiema ulie ogine.\" ");
INSERT INTO sce_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","\"Hhe minbairedene kieliewo, 'Adaimi kha doura qimegheni wiliechi wo. Hhelade ijieku taranye olon no wo. Bi enende oliesuzhi fugune. ");
INSERT INTO sce_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Bosidene adane hhende echine. Ingie \"Ada, bi Hudai melie, chii melie giesan ese oluzho. ");
INSERT INTO sce_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Enedu khuinase bi chade kewon danla dane. Mini nie wiliechi danlagha.\" giezhi kielieye.'\" ");
INSERT INTO sce_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","\"Ingiedene bosizhe adane hhende echiwo. Adani gholose chanladene zhugheni zholierese holu echi qioru agi orewo. ");
INSERT INTO sce_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kewonni adadene kieliewo, 'Ada, bi Hudai melie, chii melie giesan ese oluzho. Enedu khuinase bi chade kewon danla dane.'\" ");
INSERT INTO sce_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","\"Adani hojidene kieliewo, 'Ghujighan gou jienni agizhe musigha. Kha jiereni geizhi zhogha. Mahei musigha. ");
INSERT INTO sce_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Hhe taghun fughe tughuchai lai khizhe zharu. Matan ochizhi ijiezhi hunnerei daghaye. ");
INSERT INTO sce_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Mini fugusan kewon aminne oluwo, widasan kewon kharei irewo!' Ingiese hhela hunnerei daghazho.\" ");
INSERT INTO sce_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","\"Ingiekude fugie kewonni ghazha jierese gie shida irekude doulazhi jiulisan shenqilai sonosuwo. ");
INSERT INTO sce_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ingie nie hojii uru ire, 'Yan shiqin wo?' giezhi asawo. ");
INSERT INTO sce_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Hoji kieliewo, 'Jiuchii giede irewo. Hhe pinnan khareizhi irese adachii bayasuzhi taghun fughe tughuchai zharughawo.'\" ");
INSERT INTO sce_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","\"Fugie kewonni hokuzhi ese orose adani khizhe kewondene sughazhi kieliezho. ");
INSERT INTO sce_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Hhe adadene kieliezho, 'Bi hoji mutun chini imegheicha ushilazhi kielienyichii ese chenliezhi ese daowo. Chi made ga iman ese ogizhi zhanlienlare hunnerei ese daghaghawo. ");
INSERT INTO sce_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Chii ene kewon biozilare hhantu jiachanchii ijie widaghadene irese hhende taghun tughuchai zharune!'\" ");
INSERT INTO sce_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","\"Adani kieliewo, 'Kewon, chi mare hhantu chan souzho. Minughunshi man chinughun wo. ");
INSERT INTO sce_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Jiuchini fugudene aminne oluwo, widadene khareizhi irewo. Matan indan bayasuzhi hunnerei daghakuni wo.'\" ");
INSERT INTO sce_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ersa tujiladene kieliewo, \"Nie bayan kunni gonjiai kunla baerni hu huaizho giezhi zhazho. ");
INSERT INTO sce_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ezhanni hhei uruzhi iredene kieliewo, 'Mii chighinde iresanshi yan shiqin wo? Chi zhanlai made nie jiui. Chii gonjia pse ulie danlaghane.'\" ");
INSERT INTO sce_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","\"Hhe gonjia zhughedene kieliezho, 'Mii gonjia ulie danlaghase bi jianlai yan giene? Ghazha waise lilian uwo, ghuile echise shizhene. ");
INSERT INTO sce_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Bi matui giekui mejiewo. Ingiezhi giese bi gonjia danla dakude kunla mini jienliene.'\" ");
INSERT INTO sce_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","\"Ingiedene hhe ezhande baer chaisan kunlai nienieji uru irewo. Touchankude asawo, 'Chi ezhandemi giedughon chaine?' ");
INSERT INTO sce_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","'100 gie tunzi tosun chaine.' 'Chi zhanne agizhedene ghujighan souzhi 50 gie tunzi huai.' ");
INSERT INTO sce_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Da nie kunde asazho, 'Chi giedughon chaine?' '100 gie deizi boudei chaine.' 'Chi zhanne agizhedene 80 gie deizi huai.' ");
INSERT INTO sce_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ezhanni gou witu gonjiai jienzhaini kuaiwo. Ene duyani kunla goyadene shiqin banjise gonni kunlase jienzha wo.\" ");
INSERT INTO sce_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","\"Bi tande kielieye, duyai baerghala goyadene oluzhi zhanlien tani. Ingiese baer widakude qientande tai jienliene. ");
INSERT INTO sce_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ta ga shiqinde zhunshi ulie giese fugie shiqindeye zhunshi ulie giene. Ga shiqinde undan wise fugie shiqindeye undan uwo. ");
INSERT INTO sce_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ta duyani baerni zhunshi ulie giese tande kien asiman jieredu zhen baerni gonjighane? ");
INSERT INTO sce_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ta kunlai dunxilai zhunshi ulie giese tande kien dunxilane ogine?\" ");
INSERT INTO sce_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","\"Alinie hojiliuzhe ghua ezhanni shunji dane. Ene niede henjise hhe niede orene. Ene niede gundushi hhe niede gongien wo. Ta Huda baer ghualai hhantu shunji dane.\" ");
INSERT INTO sce_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Falisai kun jin baerrezhe, ene kielienyi sonosudene uzhezhi xiniezho. ");
INSERT INTO sce_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ersa hhelade kieliewo, \"Ta kunyi melie gou kun danlazho. Tai zhughede yan sumulasanyi Huda mejiene. Kunlai melie kuaisanshi Hudai melie henjikuni wo. ");
INSERT INTO sce_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Musani guijin, xienzhishu Yaheiyase jieshu oluwo. Enense khuinashi Hudai gojiai gouxioxii chonji keiwo, kunla man xiacha giezhi hhende orone giezho. ");
INSERT INTO sce_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ingieliuzhe asiman zemin widaliuzhe guijin jieredu nie jienjienda ulie widane. ");
INSERT INTO sce_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Kien biereighalane lihun giedene pse agise piofen giezho. Lihun giesan biereini agisan kunye piofen giezho.\" ");
INSERT INTO sce_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","\"Nie bayan kun zishei gou jien musizhi niudunie gofende xianfu giezho. ");
INSERT INTO sce_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nie Lasalu giesan ghuichenyi hunshende man yara wo. Chan bayan kunyi wijien konde soughazho. ");
INSERT INTO sce_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Sumulase bayan kunyi shire jierese ijiezhi feiliesan ginan zhazha anda bou irese ijiezhi chudune giezho. Lien noghei irezhi yaraini doluzho. ");
INSERT INTO sce_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Khuinashi ghuichen duya ijiewo. Qienxienla qienliedene Iburaheimui shida echighawo. Hhe bayan kun ye duya ijiedene bulawo.\" ");
INSERT INTO sce_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","\"Bayan kun dozoheide lolien giezho. Qiorunne qila gholose marazhi Iburaheimui chanlawo. Lasalu hhei shida wo. ");
INSERT INTO sce_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Waradazhi kieliewo, 'Iburaheimu mii xienren, made ubali nie xii! Lasalui dafalazhi kha ghurundene usu nie zhanjidene kielienyimi nie liandagha gie. Bi khan dunda siderazhi tendun shouizho!'\" ");
INSERT INTO sce_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","\"Iburaheimu kieliewo, 'Kewon, chi melieshida xianfu giesanne nie sumula. Lasalu lolien giezho. Ede Lasalude futanshiwo, chi lolien giene. ");
INSERT INTO sce_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Pse nieshi matanyi dunda ghon geizho. Bi chii hhende daorene giese daore dane. Chi mii enende daorene gieliuzheye daore dane.'\" ");
INSERT INTO sce_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","\"Bayan kun kieliewo, 'Mii xienren, qinse bi chii xiahua gieye. Lasalui mii giede peizhi echigha. ");
INSERT INTO sce_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Made tawun gaijiu wo. Hhe echidene nie jingao gie gie. Pse hhela ene oronde lolien giele irene.'\" ");
INSERT INTO sce_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","\"Iburaheimu kieliewo, 'Hhelade Musai shu, xienzhilai shu wine. Chenlie gie.' ");
INSERT INTO sce_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Hhe kieliewo, 'Ulie olune, mii xienren Iburaheimu, fugusan kun aminne oludene echise hhela geizhen giene.' ");
INSERT INTO sce_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Iburaheimu kieliewo, 'Musai shu, xienzhilai shui ulie chenliese fugusan kun aminne oluseye ulie chenliene.'\" ");
INSERT INTO sce_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ersa tujiladene kieliewo, \"Zui fanjiku shiqin chan winema, kunlai zui fanjighasan hhe kunde gou widawo! ");
INSERT INTO sce_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Enezighan ga kun dundadu niei zui fanjighase ghuzhundeni qiemanshai banladene haide boughase da gou wo. ");
INSERT INTO sce_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ta xioxin giendu, gaijiutai chii hokughase kheila. Hhe geizhen giese roulie. ");
INSERT INTO sce_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nie kun niudude doleifa zui fanjidene doleifa khareizhi 'Bi ese oluzho.' giezhi kieliese roulie.\" ");
INSERT INTO sce_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Shitula Ezhande kieliewo, \"Bijiende xianxin giekui olodogha.\" ");
INSERT INTO sce_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ezhan kieliewo, \"Tande caizi fure chigei xianxin gieku bise ta ene sunshu mutunde chi genzilada khizhe haide echi osi gieseye kielienyichii chenliene.\" ");
INSERT INTO sce_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","\"Tai dunda kienyi hoji ghazha qighalazhi irenu, ghoni adulazhi irese 'Chi ghujighan soudene ijie.' giezhi kielienu? ");
INSERT INTO sce_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kenjin ulie kieliene. Khareidene 'Chi made budan giezhi mii ushilazhi ijieghadene chi ochizhi ijie.' giezhi kieliene. ");
INSERT INTO sce_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Hoji ezhan kieliesan mutun giese ezhan mafan giezho giezhi kielienu? Ulie kieliene. ");
INSERT INTO sce_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Taye niekielien wo. Ta ezhan kieliesan mutun giezhi baraghadene ingiezhi kieliene, 'Bijienshi yama gie daku hoji wo. Eneshi bijien indan giekuni wo.'\" ");
INSERT INTO sce_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ErsaYelusalende echikude Samaliya, Jialilini dundadu oronde echizho. ");
INSERT INTO sce_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nie aghinde orone giese hharan pifugientu gholode ire beidene ");
INSERT INTO sce_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","fugiede waradazho, \"Ezhan Ersa bijiende ubali nie xii!\" ");
INSERT INTO sce_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ersa chanladene kieliewo, \"Ta buwalade goya beyene uzheghale echi.\" Hhela echikude ijin goudawo. ");
INSERT INTO sce_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Hhelai dundase nie kun goyane goudasanyi mejiedene kharei ire Hudai fugiede kuaizho. ");
INSERT INTO sce_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ersai kon konde xiutulie papaladene mafan kieliewo. Eneshi Samaliya kun wo. ");
INSERT INTO sce_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ersa kieliewo, \"Ta goudasanshi hharolie wola? Da yesun kun khala wo? ");
INSERT INTO sce_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ene niman kunse chugo pse nieda Hudai kuaile ese irewu?\" ");
INSERT INTO sce_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ingie hhe kunde kieliewo, \"Chi bosizhedene echi. Chii xianxin gieku chii jiuiwo.\" ");
INSERT INTO sce_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Niudude Falisai kunla Ersade asazho, \"Hudai gojia yan shihoude irene?\" Ersa kieliewo, \"Hudai gojia irese chanlakui pusho. ");
INSERT INTO sce_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kunla uzhe, Hudai gojia enende wo, hhende wo giezhi ulie kieliene. Hudai gojia tani dunda wo.\" ");
INSERT INTO sce_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Pse tujiladene kieliewo, \"Ta Kunnikewonni niudui uzhene gieku shihou kuzhenema, uzhe dane. ");
INSERT INTO sce_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Kunla 'Uzhe, kunnikewon enende wo.' 'Uzhe, hhende wo.' giezhi kieliese ta bu echi. Hhelai bu dagha. ");
INSERT INTO sce_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Shanjien asiman enemiense khizhezhi hhemiende zhouiku mutun Kunnikewonni ududeye ingiene. ");
INSERT INTO sce_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kunnikewon irese ijinyo xien shouku giezhi ene idai kunla hhei fandui giene.\" ");
INSERT INTO sce_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","\"Nuhhani xienzide matugiezhoshi Kunnikewonyi xienzideye qingiene. ");
INSERT INTO sce_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Hhe shihoudedu kunla ijiezho, ochizho, bierei agizho, dafalazhi izhi Nuhha chon sudoro oroku hhe udude hunshui iredene man yenji alawo.\" ");
INSERT INTO sce_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","\"Kunnikewonni udu Luteii hhe shihoudedu niekielien wo. Hhe kunla ijiezho, ochizho, agizho, huizho, ghazha tareizho, gie giezho. ");
INSERT INTO sce_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","LuteiSodomase yolaku hhe niudude khan funi asiman jierese bouredene man sidera widawo.\" ");
INSERT INTO sce_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","\"Kunnikewon xienjiku ududeye ingiene. ");
INSERT INTO sce_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Hhe udude gie jieredu kunla giederase dunxilai agile bu bouzhe. Ghazha jieredulaye giedene khareizhi bu echi. ");
INSERT INTO sce_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ta Luteii bierei matui gholusanni nie sumula. ");
INSERT INTO sce_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kien aminne baohu giene giese aminne widaghane. Aminne widaghase jiuine. ");
INSERT INTO sce_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Bi tande kielieye, hhe nie xii ghuala nie chon jiere kijiese niei uduru echine, niei jiene. ");
INSERT INTO sce_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ghua bierei qieman sidase niei uduru echine, niei jiene.\" ");
INSERT INTO sce_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Hhela asawo, \"Ezhan, imutu shiqin khala fashen giene?\" Ersa hhelade kieliewo, \"Fugusan dunxi khalashi inye khala wo.\" ");
INSERT INTO sce_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ersa tujiladene izhi ulie beidene onxian giezhi zhughe ulie widakui bilazhi kieliewo. ");
INSERT INTO sce_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","\"Nie chenshide nie noyen Hudase ulie ayine, kunlaiye ulie zunjine. ");
INSERT INTO sce_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Hhe chenshide nie guafu wo. Ibeizi noyenyi hhende echizhi kieliezho, 'Made nie duitou wo. Chi made gundande chuli gie.' ");
INSERT INTO sce_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ene noyen izhi ese gonjizho. Oloncha oludene sudorone sumulazho, 'Bi Hudase ulie ayine, bexinlaiye ulie zunjinema, ");
INSERT INTO sce_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ene bierei ibeizi mii souine. Enei bi goudaghaye pse mini jindaghazhi alane.'\" ");
INSERT INTO sce_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ezhan kieliewo, \"Ene gou witu noyen kieliesanyi ta chenlie. ");
INSERT INTO sce_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Huda sunghuzhi irezhi xieni udu hhei waradasan kunlade Huda gundanni ulie ogidene udazhi banman gienu? ");
INSERT INTO sce_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Bi tande kielieye, Huda hhelade ghujighan gundanni ogine. Ingieliuzhe Kunnikewon irekude duyade goude xianxin giechen kun giedun ereizhi olune?\" ");
INSERT INTO sce_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Goyaneshi gou kun wo giezhi kunlai meilade uzhesan kunlade Ersa bilazhi kieliewo. ");
INSERT INTO sce_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","\"Nie Falisai kun shui shanjisan kunghala huitande onxian giele echiwo. ");
INSERT INTO sce_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Falisai kun niezheghan beidene onxian giezho, 'Huda, bi chade mafan kielieye. Bi kunlai buxian wo. Ese qianlazho, gou wini ese giezho, piofen ese giezho. Ene shui shanjisan kunyiye genben buxian wo. ");
INSERT INTO sce_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Bi nie xinqide lianhui orozo bareizho. Shourusene 10 fenzhi 1 ni chade ogizho.' ");
INSERT INTO sce_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Shui shanjisan kun gholode beidene asimanyi ayizhi uzhe da echanne chuidazhi kieliezho, 'Huda, bishi zuiren wo. Made ubali nie xii!' ");
INSERT INTO sce_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Bi tande kielieye, giedene echikude Huda gounide sanasanshi hhe kun pusho, ene kun wo. Kien goyane undudaghase boghonidaghane. Goyane boghonidaghase undudaghane.\" ");
INSERT INTO sce_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kunla jiujiulane qioruzhi Ersai melie ire maqighane giezho. Tujila chanladene hhelai sugiezho. ");
INSERT INTO sce_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ersa hhelai uruzhi ire tujilade kieliewo, \"Kesilai bu dui, mii shida ire gie. Hudai gojiashi imutu kunlanughun wo. ");
INSERT INTO sce_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Bi tande shuhua kielieye, kien kewosi mutun Hudai gojiai ulie jienliese hhende oro dane.\" ");
INSERT INTO sce_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nie noyen Ersade asawo, \"Gou loushi, bi matui giese chanqiku aminni jienliene?\" ");
INSERT INTO sce_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ersa hhende kieliewo, \"Chi mii yangiezhi gou wo giezho? Hudase chugo gouni uwo. ");
INSERT INTO sce_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Minlinyi chi mejiene, Piofen bu gie, kun bu ala, bu ghula, jia ganzhen bu bei, ada anane zunji giezho.\" ");
INSERT INTO sce_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Hhe kieliewo, \"Enelai bi ga xienzise man zunjizho.\" ");
INSERT INTO sce_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ersa chenliedene kieliewo, \"Chade da nie chaizho. Chi bisanlane man huizhi nanxin kunlade ogi. Ingiese chii boubei asiman jiere wo. Ingiedene irezhi mii dagha.\" ");
INSERT INTO sce_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Hheshi nie fugie bayan kun wo. Ene kielienyi chenliedene hende yuchourazho. ");
INSERT INTO sce_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ersa hhei uzhedene kieliewo, \"Baertu kun Hudai gojiade oroku chijia no wo. ");
INSERT INTO sce_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Loto zhun boghose daoku bayan kun Hudai gojiade orokuse da sunfan wo.\" ");
INSERT INTO sce_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Chenliesan kunla kieliewo, \"Ingiese kienyi jiui shidane?\" ");
INSERT INTO sce_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ersa kieliewo, \"Kun gie dakui Huda giene.\" ");
INSERT INTO sce_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Beduru kieliewo, \"Uzhe, bijien goyanughunne bendadene chii daghazho.\" ");
INSERT INTO sce_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ersa kieliewo, \"Bi tande shuhua kielieye, kun Hudai gojiade oluzhi gie, bierei, gaijiu, ada, ana, kesilane bendase ");
INSERT INTO sce_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ene duyade pse olon ogine, houshide chanqiku amin ogine.\" ");
INSERT INTO sce_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ersa 12 gie tujii uruzhi ire hhelade kieliewo, \"Uzhe, matan Yelusalende khireine. Xienzhila Jinwun jiere huaisan mutun Kunnikewonyi shiqinyi man gholughane. ");
INSERT INTO sce_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Hhela hhei niman kunlade jiuise kunla xilun, shizheghane, ungie jiere nunpune. ");
INSERT INTO sce_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Mabienzighala eghine, da alane. Ingie ghurudude aminne olune.\" ");
INSERT INTO sce_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ene shiqinyi tujila dunjire dawo. Isii niuighazho, hhela hhe kieliesan isii mejie dawo. ");
INSERT INTO sce_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ErsaYeligede chadashikude nie sugho mo bienzide soudene ghuizho. ");
INSERT INTO sce_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Olon kun yozhi daokude sugho sonosudene, \"Yan shiqin wo?\" giezhi asazho. ");
INSERT INTO sce_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Hhela sughode kieliewo, \"Nasale kun Ersa yozhi daowo.\" ");
INSERT INTO sce_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Deigo waradawo, \"Dawudeni houdei Ersa, made ubali nie xii!\" ");
INSERT INTO sce_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Melie yosan kunla shenqi bu khizhe giezhi jiebalase hhe genjia fugiede waradazhi kieliezho, \"Dawudeni houdei, made ubali nie xii!\" ");
INSERT INTO sce_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ersa beidene hhei urudei ire giezhi kieliewo. Hhe dao irese hhende asawo, ");
INSERT INTO sce_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","\"Bi chade yan giene?\" Hhe kieliewo, \"Ezhan, bi chanlaku duran wo!\" ");
INSERT INTO sce_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ersa kieliewo, \"Chi chanla. Chii xianxin gieku chii jiuiwo.\" ");
INSERT INTO sce_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Sugho deigo chanladene Hudai kuaizhi Ersai daghawo. Kunla enei uzhedene Hudade doulazho. ");
INSERT INTO sce_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ErsaYeligede orodene yozhi daokude ");
INSERT INTO sce_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","nie kunyi niereini Sagai giene. Shui shanjisan kun dunda qienli fugie wo, bayan no wo. ");
INSERT INTO sce_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Hhe Ersashi matunie kun bikui uzhene giezhoma, kun olon, beyeni gajishi uzhe dazho. ");
INSERT INTO sce_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ingie holu melieshidadene nie mutun jiere khirei Ersai uzhene giezho. Ersa hhense yozhi daone. ");
INSERT INTO sce_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ersa mutun konde echidene qiorunne qila kieliewo, \"Sagai, ghujighan bouzhe. Enedu bi chii giede ijinyo soune.\" ");
INSERT INTO sce_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Hhe jindazhi bouzhedene hende bayasuzhi Ersai jienliewo. ");
INSERT INTO sce_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Uzhesan kunla ene matugie zuirenyi giede souwo giezhi nieniedene kieliezho. ");
INSERT INTO sce_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sagai beidene Ezhande kieliewo, \"Bi giei jiachansene olienyi nanxin kunlade ogiye. Pse bi kienyi piendazhoshi 1 peide 4 pei honjiye.\" ");
INSERT INTO sce_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ersa kieliewo, \"Enedu jiuiku nenjien ene nie giede kuzhewo. Ene kunshiye Iburaheimuni houdei wo. ");
INSERT INTO sce_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kunnikewon widasan kunlai ereizhi jiuile irewo.\" ");
INSERT INTO sce_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Kunla zhen chenliekude ErsaYelusalense chadashiwo. Kunla sumulazhi Hudai gojia ede kuzhewo giezho. Ingie Ersa nie bilazhi kieliewo. ");
INSERT INTO sce_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","\"Nie fugie noyen gholose nie gojiani honshan danlaku qienli keredene irene giezho. ");
INSERT INTO sce_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Echikude hharan hojii uru ire hhelade hharan antan ogidene kieliewo, 'Bi iretula ta meimei giendu.' ");
INSERT INTO sce_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Hhei gojiani kunla ene noyenyi henjizhi daibioni khuina dafalazhi echigha 'Ene kunyi matande honshan danlaghaku duran uwo.' giezhi kieliewo.\" ");
INSERT INTO sce_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","\"Hhe noyen qienli kerezhi iredene baer ogisan hojilai uruzhi ire baer giedughon zhenjisei mejiene giezho. ");
INSERT INTO sce_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ji 1 gie hojini kieliewo, 'Ezhan, bi nie antan jierese 10 pei zhenjiwo.' ");
INSERT INTO sce_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Noyen hhende kieliewo, 'Giesan gou wo. Chishi gou hoji wo. Chi ga shiqinde shixinji giezho, ingiese bi chade hharan chenshi gonjighaye.'\" ");
INSERT INTO sce_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","\"Da nie hojini kieliewo, 'Ezhan, bi nie antan jierese 5 pei zhenjiwo.' ");
INSERT INTO sce_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Noyen ene niedeye kieliewo, 'Bi chade tawun chenshi gonjighaye.'\" ");
INSERT INTO sce_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","\"Pse nie hojini kieliewo, 'Ezhan, uzhe. Bi chii ene nie antanyi shoujinde boui ghurazho. ");
INSERT INTO sce_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Chi lihaishi bi chase ayizho. Chi ese jiesan oronse agine, ese tareisan oronse ghurane.'\" ");
INSERT INTO sce_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","\"Noyen hhende kieliewo, 'Chi ene doghun hoji! Bi chii kielienghala chii kheilane. Bi ese jiesan oronse agizhi ese tareisan oronse ghurachen lihaitu kun bikui chi mejienu? ");
INSERT INTO sce_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Qinse mini baerni yale inhande ese teiwo? Bi irekude benqien lixiji agi khizhene.' ");
INSERT INTO sce_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ingie hhe shida beisan kunlade kieliewo, 'Ene kunse nie antanni agi echidene hharan antantu kunde ogi.'\" ");
INSERT INTO sce_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","\"Ingie kunla hhende kieliewo, 'Ezhan, hhende hharan antan wine.' ");
INSERT INTO sce_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Noyen kieliewo. 'Bi tande kielieye, bichen kunde pse olon ogine. Wichen kunse bisanlainiye agi echine. ");
INSERT INTO sce_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mini honshan ulie danlaghachen hhe duitoulai mini melie lai iredene ala.'\" ");
INSERT INTO sce_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ersa enei kielie baludene melie yozhi Yelusalende khireine giezho. ");
INSERT INTO sce_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ganlanshan giezhi urusan ula shida Bofaqi, Bodanide kuzhekude Ersa ghua tujine peizhi ");
INSERT INTO sce_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","kieliewo, \"Ta duimienni aghinde echi. Orose nie huiyasan ga enzheghei chanlane. Kieme unuzhi ese daozho. Ta andaghadene lai ire. ");
INSERT INTO sce_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kunla tande 'Yangiezhi andaghane?' giezhi asase 'Ezhan injine.' giezhi kielie.\" ");
INSERT INTO sce_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Peisan kunla echidene Ersa kieliesan mutun chanlawo. ");
INSERT INTO sce_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Hhela andaghakude ezhanni chanladene asazho, \"Ta ga enzheghei andaghazhi yangiene?\" ");
INSERT INTO sce_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Hhela \"Ezhan injine.\" giezhi kieliewo. ");
INSERT INTO sce_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Hhela Ersai shida lai ire goya jienlane ga enzheghe jiere daidene Ersai unughawo. ");
INSERT INTO sce_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ersa yokude kunla man jienlane mo jiere peiwo. ");
INSERT INTO sce_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Zhen Ganlanshanse boukude Ersa giesan fugie shiqinyi uzhesan kunla man bayasuzhi fugiede Hudade doulazho, ");
INSERT INTO sce_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","\"Ezhanyi niereghala iresan honshande doulandu! Asiman jiere pinnan wo, Zui Undudedu Hudai kuai!\" ");
INSERT INTO sce_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Giedun Falisai kunla Ersade kieliewo, \"Loushi, chi tujilane bu onghonogha.\" ");
INSERT INTO sce_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ersa kieliewo, \"Bi tande kielieye, enela amanne menjise tashila onghono qiine.\" ");
INSERT INTO sce_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ErsaYelusalende kuzhi echikude hhe chenshide oluzhi wilazhi kieliewo, ");
INSERT INTO sce_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","\"Bi sumulase enedu chi pinnan olukuni mejiese gou woma, ede chi mejie dane, mejiekui niuighazho. ");
INSERT INTO sce_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Shihou kuzhese chii duitoula danghaghala luizhi zhouwise wiqidene chii witanlaghane. ");
INSERT INTO sce_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Hhela irese chii, kesilachii man widaghane. Nie luisan tashiniliuzhe ulie jiene. Huda irezhi jiuiku shihouni ta uye renjiwo.\" ");
INSERT INTO sce_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ersa mechide orodene meimei giesan kunlai man tou khighadene kieliewo, ");
INSERT INTO sce_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","\"Mii gie onxian gieku gie gholune giezhi jinwun jiere huaizho. Ta ghughei ho gholughazho.\" ");
INSERT INTO sce_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ersa niudunie mechide kunlade sughazho. Fugie buwa, jinwun hanjia, bexinlai lindaola hhei alane giezhi banfa xianjizhoma, ");
INSERT INTO sce_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","bexinla man hhei kieliei goude chenliese hhela yama gie dazho. ");
INSERT INTO sce_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Niudude Ersa mechide kunlade sughazhi Hudai gouxioxini jianjikude fugie buwa, jinwun hanjiala zhanlaolare hhantu ire ");
INSERT INTO sce_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ersade kieliewo, \"Chi yan qienlighala ene shiqinlai giesei bijiende kielie. Chade ene qienlii ogisanshi kien wo?\" ");
INSERT INTO sce_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ersa kieliewo, \"Biye tande nie unqi asaye. Ta made kielie, ");
INSERT INTO sce_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yaheiyai xili gieghaku qienli asimanse onu, kunlase wo?\" ");
INSERT INTO sce_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Hhela goyalane shanlian giezhi kieliewo, \"Matan 'Asimanse wo.' giese 'Ta yale hhei xianxin ulie giene.' giezhi hhe kieliene. ");
INSERT INTO sce_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Kunlase wo giese bexinla man matai tashighala eghi alane, hhela Yaheiyashi xienzhi wo giezhi xianxin giezho.\" ");
INSERT INTO sce_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ingie khalase iresei ulie mejiene giezhi hhela kieliewo. ");
INSERT INTO sce_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ersa hhelade kieliewo, \"Biye tande yan qienlighala ene shiqinlai giesei ulie kieliene.\" ");
INSERT INTO sce_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ersa ene kielienyi bexinlade bilazhi kielie qiiwo. \"Nie kun nie yenzi putou zeiladene kunlade bouizhi ogi, gholode echi oloncha souwo. ");
INSERT INTO sce_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Shihou kuzhese nie hojine peizhi nexianne ghuraghale echiwo. Bouisan kunla hhei idun eghidene khosun khareighawo. ");
INSERT INTO sce_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Da nie hojine pse ghuraghale echiwo. Eghizhi shizheghadene khosun echighawo. ");
INSERT INTO sce_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Pse nie hojine echighawo. Eghizhi shan dailaghadene tungu khizheghawo. ");
INSERT INTO sce_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Putou yenzii ezhan kieliezho, 'Bi matugiene? Bi oresan kewonne echighayema, hhela zunjineba.' ");
INSERT INTO sce_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Bouisan kunla hhei chanladene nieniene shanlian giezhi kieliewo, 'Eneshi jiachanni jienliechen wo. Matan enei alayema, jiachanni manughun gholune!' ");
INSERT INTO sce_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ingie putou yenzise tungu khigha alawo. Ta sumulase putou yenzii ezhan ene kunlai matugiene? ");
INSERT INTO sce_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ezhan iredene bouisan kunlai man alazhi psedu kunlade bouizhi ogine.\" Chenliesan kunla kieliewo, \"Imutu shiqin jiedui uwo!\" ");
INSERT INTO sce_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ersa hhelai uzhedene kieliewo, \"Qingiese ene idon jinwunshi yan isi wo? 'Gie giesan kunla bendasan tashi giei zhunyo tashi gholuwo.' ");
INSERT INTO sce_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Jien hhe tashi jiere anda bousan kunla zhazhazi gholune. Ene tashi kienyi jiere anda bouse zai miendaghane.\" ");
INSERT INTO sce_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jinwun hanjia, fugie buwala Ersa hhelai bilazhi kieliesei uzhe khizhedene deigo bareine giezhoma, bexinlase ayizho. ");
INSERT INTO sce_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Hhela kunlai jizide jiazhon gieghazhi Ersani uzheghale echiwo. Hhe kielie codaghase shenzhande zhazhi bareighane giezho. ");
INSERT INTO sce_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jiazhon giesan kunla Ersade asazho, \"Loushi, chi kieliesan, jianjisan man oluzho. Enei bijien mejiezho. Chi kunni niekielien uzhezhi Hudai daolini shixinde sughazho. ");
INSERT INTO sce_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Matan Kaisa honshande shui jiuise oluzhou ese oluzho?\" ");
INSERT INTO sce_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ersa piendasanyini mejiedene hhelade kieliewo, ");
INSERT INTO sce_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","\"Made miengui nie uzhegha. Ene qiorun, haoshi kiennughun wo?\" Hhela kieliewo, \"Kaisanughun wo.\" ");
INSERT INTO sce_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","\"Qinse Kaisanughunshi Kaisade ogi, Hudanughunshi Hudade ogi.\" ");
INSERT INTO sce_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Hhela kunlai melie Ersa kieliesande yama codasei erei dazho. Ersa huida giesande ghaniradene amanlane menjiwo. ");
INSERT INTO sce_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Fuho gieku shiqin uwo giesan niezhan Sadugai kunla Ersai shida ire asawo, ");
INSERT INTO sce_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","\"Loushi, Musa guijin jiere huaizho, nie kun bierei agidene kewosi wi duya ijiese jiuni zhoui gaidene houdei liuikuni wo giezho. ");
INSERT INTO sce_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ingiese gaijiu dololie laoda bierei agidene kewosi wi duya ijiewo. ");
INSERT INTO sce_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Laoer, laosan man hhei zhouiwo. ");
INSERT INTO sce_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Dololie man zhouidene kewosi wi duya ijiewo. ");
INSERT INTO sce_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Zuihoude biereiye duya ijiewo. ");
INSERT INTO sce_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ingiese fuho giekude hheshi kienyi bierei wo? Gaijiu dololie man hhei agiwo.\" ");
INSERT INTO sce_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ersa hhelade kieliewo, \"Ene duyani kunla agizhi dafalane. ");
INSERT INTO sce_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Duya ijiesan kun dundase aminne oluzhi houshide zige bichen kunla ulie agizhi ulie dafalane. ");
INSERT INTO sce_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Hhela pse ulie duya ijiene, qienxien niekielien wo. Hhelashi fuho giechen wo, Hudai kesila wo. ");
INSERT INTO sce_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Duya ijiesan kun aminne olukui Musaye eghesun khan sideraku jinwun jiere zhenmin giezho. Musa Ezhanni urukude Iburaheimuni Huda, Isagheini Huda, Yagebuni Huda giezho. ");
INSERT INTO sce_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ingiese Hudashi duya ijiesan kunyi Huda pusho, amitu kunyi Huda wo. Huda uzhese kunla man amitu wo.\" ");
INSERT INTO sce_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Giedun jinwun hanjia kieliewo, \"Loushi, chi kieliesan oluzho.\" ");
INSERT INTO sce_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Hhela ayizhi pse hhende yama asa dazho. ");
INSERT INTO sce_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ersa hhelade kieliewo, \"Kunla matugie Mexihashi Dawudeni houdei wo giezho? ");
INSERT INTO sce_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Dawude goyane Zeburei jiere kieliezho, 'Ezhan mii Ezhande kieliewo, \"Bi duitoulaichii kon dourachii teitula chi mini borun miende sou.\"' ");
INSERT INTO sce_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Qingiese Dawude Mexihai Ezhan giezhi uruse Mexiha matugie Dawudeni houdei wo?\" ");
INSERT INTO sce_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Bexinla chenliekude Ersa tujiladene kieliewo, ");
INSERT INTO sce_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","\"Ta jinwun hanjialai fangula. Hhela fudu jienni musidene geidoude toreizhi kunla hhelade kielien asakude xiqi wo. Huitanni undu wizi, xini shanxide soukude xiqi wo. ");
INSERT INTO sce_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Hhela guafui gieni chigheine. Jiazhon giezhi oloncha onxian giene. Enezighan kunlai pse gundude faine.\" ");
INSERT INTO sce_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ersa qiorunne qila bayan kunla mechii baer teiku xianzide baer teikuni uzhezho. ");
INSERT INTO sce_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Pse nie nanxin guafu hhende ghua fenfenzi baer teisei uzhewo. ");
INSERT INTO sce_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ersa kieliewo, \"Bi tande shuhua kielieye, ene nanxin guafu soyuji kunlase olon teiwo. ");
INSERT INTO sce_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kunla olonsene teiwo. Guafude yama uwoma, udu daoku baerlane man teiwo.\" ");
INSERT INTO sce_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Niezhan kunla mechini seighan tashi, Hudade ogisan mureghala zhonhon giesei kielienduzho. Ingiese Ersa kieliewo. ");
INSERT INTO sce_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","\"Ta chanlasan enelai hhe shihou kuzhese cheizhi tashi jiere tashi nieda ulie jiene.\" ");
INSERT INTO sce_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Hhela Ersade asazho, \"Loushi, yan xienzide ene shiqinla fashen giene? Enela fashen giekude yan zunji wine?\" ");
INSERT INTO sce_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Hhe kieliezho, \"Ta xioxin giezhi kunlai bu piendagha. Olon kunla mii niereghala iredene bishi hhe enbene, ede shihou kuzhewo giese ta bu dagha. ");
INSERT INTO sce_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ta eghinduzhi londasan xioxini sonosuse bu ayi. Ene shiqin xien fashen gienema, duya baraku deigo ulie kuzhene.\" ");
INSERT INTO sce_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Pse hhelade kieliewo, \"Minzu minzula eghindune, gojia gojiala eghindune. ");
INSERT INTO sce_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Zemin fugiede gojiolune, gochude oliesuku inzhanku gien wine, asiman jierese fugie ghudureqi irezhi ayighane.\" ");
INSERT INTO sce_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","\"Ene shiqin iretula kunla tai heizhi bareidene huitan, bafanzide jiuine. Mii yenyinghala tai honshan, shenzhanlai melie lai echine. ");
INSERT INTO sce_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Hheshi made ganzhen beiku jihui wo. ");
INSERT INTO sce_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Panjichen kunde matugie huida giekui melieshi zhunbei bu gie. ");
INSERT INTO sce_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Bi tande duitoulatai tai kieliezhi dao daku kielien, agheli ogine. ");
INSERT INTO sce_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Lien ada, ana, gaijiu, qingu, zhanlienlaye tai ghudanduzhi niezhanlani alane. ");
INSERT INTO sce_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Mii yenyinghala kunla man tai henjine. ");
INSERT INTO sce_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ingieliuzhe tai niekozi usunye ulie widane. ");
INSERT INTO sce_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ta izhigie rennai giese goyane jiuine.\" ");
INSERT INTO sce_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","\"Budui iredene Yelusalenyi wiqikui ta chanlase hhe widaghaku udu ghujinlasei mejiene. ");
INSERT INTO sce_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ingiekude Yudayade sousan kunla, ulade piile echi. Chenshini kunla ghadane khirei. Xianni kunla chenshide bu oro. ");
INSERT INTO sce_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Enezighan udushi faiku udu wo. Jinwun jiere huaisan kielienyi gholughane. ");
INSERT INTO sce_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Hhe udude kewosi laisan, gogoghasanlade gou widawo! Zemin jiere zeinan wo, Hudai hokuku ene bexinlai jiere irezho. ");
INSERT INTO sce_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Hhela khudogho doura fugune, pse bareidene go gojiade lai echine. Niman kunni udu kurutula niman kun iredene Yelusalenni tai pindaghane.\" ");
INSERT INTO sce_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","\"Hhe shihou kuzhese naran, sara, hodunla bienjizhi zunji uzheghane. Haide lan jiulizhi onghonose zemin jieredu gojiala man jindazhi matugiekui mejie dazho. ");
INSERT INTO sce_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Asimanyi lilianla gojioluse duya matui gholune gie kunla ayidene injirene. ");
INSERT INTO sce_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ingiekude Kunnikewon nenli, famanude olien jierese irekui kunla chanlane. ");
INSERT INTO sce_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ene shiqin kaishi giese bosizhedene qiorunne qila. Tai shuiku udu chadashiwo.\" ");
INSERT INTO sce_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ersa hhelade bilazhi kieliewo, \"Ta uhuago mutun, psedu mutunlai uzhe. ");
INSERT INTO sce_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Mutun lachen keikui ta uzhese khaluncha orokui mejiene. ");
INSERT INTO sce_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Taye niekielien wo. Ta ene shiqinla fashen giesei chanlase Hudai gojia chadashisei mejiene. ");
INSERT INTO sce_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Bi tande shuhua kielieye, ene idaini kunla fugutula ene shiqinla man gholune. ");
INSERT INTO sce_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Asiman zemin widaliuzhe mii kielien kenjin ulie widane.\" ");
INSERT INTO sce_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","\"Ta jinxin giendu. Pse ta hunnerei daghazhi ochizhi ijiekude, duyani shiqinghala munan giezhi zhugheitai kunzhi giekude hhe udu irene. Hhe shihou irese onghala zhaghasun bareiku niekielien wo, mejie dakude irene. ");
INSERT INTO sce_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Hhe udu irekude zemin jiereshiku kunlade man irene. ");
INSERT INTO sce_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ta chan onxian giezhi jinxin giendu. Qingiese ene shiqin irekude holuzhi andadene Kunnikewonni melie bei shidane.\" ");
INSERT INTO sce_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ersa niudunie mechide kunlade surughazho. Niexiinie Ganlanshande echizhi souzho. ");
INSERT INTO sce_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bexinla man eqiemagha eqie mechide Ersa jianjisei chenliele irezho. ");
INSERT INTO sce_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Jiulidaosan Jie giezhi urusan Tanmien Jie kuzhewo. ");
INSERT INTO sce_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Fugie buwa, jinwun hanjiala bexinlase ayise yan banfaghala Ersai alase gou wo giezhi sumulazho. ");
INSERT INTO sce_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ingiekude Jialie kun Yudani sudoro Ibilisi orowo. Hheshi 12 gie tuji dundadu nie wo. ");
INSERT INTO sce_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yuda fugie buwa, mechi sagheisan kunlare Ersai matugie ghudandukui shanlian giele echiwo. ");
INSERT INTO sce_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Hhela bayasuzhi Yudade baer ogikui dain giewo. ");
INSERT INTO sce_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuda tunyi oludene bexinla wikude Ersai ghudanduku jihui ereizho. ");
INSERT INTO sce_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tanmien Jie kuzhezhi Jiulidaosan Jieni ghoni zharuku udude ");
INSERT INTO sce_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ErsaBeduruYaheiya ghualani peizhi kieliewo, \"Ta matande Jiulidaosan Jieni ijiuni zhunbei giele echi. Matan ijienduye.\" ");
INSERT INTO sce_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Hhela asawo, \"Bijien khala zhunbei giene?\" ");
INSERT INTO sce_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ersa kieliewo, \"Ta chenshide orokude nie tunzi usu qilasan kunyi penjine. Ta hhei daghazhi hhe orosan gie doura orodene ");
INSERT INTO sce_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","giei zhanguijide kielie, 'Loushi chade asazho, \"Bi tujilarene Jiulidaosan Jieni daoghaku gie khala wo?\"' ");
INSERT INTO sce_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Hhe tande lou jiere man qiendaghasan nie fugie gieni uzheghane. Ta hhende zhunbei gie.\" ");
INSERT INTO sce_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Hhela echidene chanlasan Ersa kieliesanghala niekielien wo. Ingie hhela hhende Jiulidaosan Jieni zhunbei giewo. ");
INSERT INTO sce_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Shihou kuzhese Ersa shitularene hhantu xi souwo. ");
INSERT INTO sce_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ersa hhelade kieliewo, \"Bi shouku gieku melie tanre hhantu Jiulidaosan Jieni ijieku hende duran wine. ");
INSERT INTO sce_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Bi tande kielieye. Jiulidaosan Jie Hudai gojiade chengun olutula bi pse hhei ulie ijiene.\" ");
INSERT INTO sce_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ersa beizii agi daore Hudade mafan kieliedene hhelade kieliewo, \"Ta enei man ghughazhi ochindu. ");
INSERT INTO sce_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Bi tande kielieye, enedu khuinase bi pse putoujiuni ulie ochizhi Hudai gojia ireku shihou kune.\" ");
INSERT INTO sce_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ingie ginanyi barei mafan kieliedene ghulu hhelade ogi kieliewo, \"Eneshi tande oluzhi ogisan mii beye wo. Ta mii jilazhi enei gie.\" ");
INSERT INTO sce_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ijie baludene qingiezhi beizii barei kieliewo, \"Ene beizishi mii chusunghala shini yenjisan kielien wo. Tande oluzhi usurusan wo. ");
INSERT INTO sce_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ingieliuzhe, uzhe, mini ghudandune giesan kun mii shida souzhi mare hhantu ijiezho. ");
INSERT INTO sce_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Huda jiejin giesan mutun Kunnikewon duya ijienema, hhei ghudandusan kunde gou widawo!\" ");
INSERT INTO sce_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Hhela nieniedene asazho, \"Imutu shiqini kien giene?\" ");
INSERT INTO sce_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Hhelai dunda kien zui fugie wo giezhiye nienieji zhenjinduzho. ");
INSERT INTO sce_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ersa hhelade kieliewo, \"Niman kunlai dunda honshan noyenla qienli bareizhi kunlai gonjiliuzhe hhelai gouni ogisan kun giezhi uruzho. ");
INSERT INTO sce_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ta niekielien pusho, tai dunda zui fugieni zui meilashi, lindao danlane giesan kun ushilachen kun mutun gie. ");
INSERT INTO sce_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kien fugie wo? Xi sousan kun fugie onu ushilachen kun fugie wo? Xi sousan kun fugie woba. Ingieliuzhe bishi tai dunda ushilachen kun wo. ");
INSERT INTO sce_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kunla mini fandui giezhi alane giese ta izhi mare hhantu wo. ");
INSERT INTO sce_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Huda made gonjiku qienlini ogiku mutun bi ye tande qienlini ogiye. ");
INSERT INTO sce_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ta marezhe hhantu mini gojiade ijiezhi ochine. Ta baozo jiere souzhi Isilieni 12 gie paini gonjine.\" ");
INSERT INTO sce_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","\"Ximun, Ximun! Ibilisi tai boudei shierlaku mutun shierlane giezhi Hudade xiahua giewo. ");
INSERT INTO sce_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ingiese bi chade oluzhi chii xianxin gieku bu fura giezhi onxian giewo. Chi geizhen giedene gaijiulane khiduzhegha.\" ");
INSERT INTO sce_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Beduru kieliewo, \"Ezhan, bi chimare hhantu bafanzide orozhi fuguseye zhunbei gie goudazho!\" ");
INSERT INTO sce_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ersa kieliewo, \"Beduru, bi chade kielieye, enedu tigha kheilatula chi mii 3 hui ulie renjine.\" ");
INSERT INTO sce_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ingie pse kieliewo, \"Bi tai echighakude baer, qibao, maheiye uwo. Tande yama chaizhoye?\" Hhela kieliewo, \"Uye.\" ");
INSERT INTO sce_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ersa kieliewo, \"Ede baer, qibao bichenla barei, khudogho wise jienne huizhi agi. ");
INSERT INTO sce_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Bi tande kielieye hhei zuirende sanawo giezhi jinwun jiere mii zhiizhi kieliesanla kenjin gholune. Enbene, mii zhiizhi kieliesan ene zhen gholuzho.\" ");
INSERT INTO sce_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Hhela kieliewo, \"Ezhan, enende ghua khudogho wo.\" Ersa kieliewo, \"Kuruwo.\" ");
INSERT INTO sce_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ersa eqighanku mutun Ganlanshande echise tujilaniye daghazho. ");
INSERT INTO sce_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Hhe oronde kurudene hhelade kieliewo, \"Ta onxian gie, pse miine.\" ");
INSERT INTO sce_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ingiedene nie tashi bendasan qimutu gholo echidene xiutuliezhi onxian giezho, ");
INSERT INTO sce_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","\"Ada, chi duran bise ene shouku giekui made bu iregha! Ingieliuzhe mii duranghala bu gie, chii duranghala gie.\" ");
INSERT INTO sce_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ingiekude nie qienxien asiman jierese iredene hhende nenli ogiwo. ");
INSERT INTO sce_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ersai zhughe otuzhi pse hende onxian giezho. Koniesun chusun mutun zemin jiere luizho. ");
INSERT INTO sce_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Onxian gie balu bosizhedene tujilai hhende echiwo. Hhela hende munan giedene hhunturazho. ");
INSERT INTO sce_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ersa hhelade kieliewo, \"Ta yangiezhi hhunturazho? Bosizhedene onxian gie, pse miine.\" ");
INSERT INTO sce_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Zhen kieliekude 12 gie tuji dundadu Yuda giesan nie kun iban kunni uduru irewo. Ersai shida irezhi orene giezho. ");
INSERT INTO sce_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ersa hhende kieliewo, \"Yuda, chi Kunnikewonni orekughala ghudandunu?\" ");
INSERT INTO sce_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Zhouwini tujila ene shiqinyi uzhedene kieliewo, \"Ezhan, bijien khudoghoghala chizhise olunulie?\" ");
INSERT INTO sce_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Hhelai dundase nie kun zui fugie buwai hojii borun chighinyi chizhi agiwo. ");
INSERT INTO sce_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ersa kieliewo, \"Bu eghi!\" Ingie hhe kunni chighinyi moi goudaghawo. ");
INSERT INTO sce_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ingie hhei bareile iresan fugie buwa, mechii sagheisan kun, zhanlaolade kieliewo, \"Ta khudogho, banbanlai bareidene mii qiandao mutun bareile irewu? ");
INSERT INTO sce_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Niudunie bi mechide tanre hhantu wo, ulie bareine. Ede tai shihou wo, kharani qienlii bareizho.\" ");
INSERT INTO sce_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Hhela Ersai bareidene zui fugie buwai giede lai echiwo. Beduru gholose daghazho. ");
INSERT INTO sce_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Kunla ghoronde khan teidene izhonde hhantu souse Beduruye hhantu wo. ");
INSERT INTO sce_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nie hoji oqin khanni gonse Beduruni xianxide uzhe tanidene kieliewo, \"Ene kunye Ersare hhantuku wo.\" ");
INSERT INTO sce_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Beduru ese renjizhi kieliewo, \"Funi, bi hheni tani dane.\" ");
INSERT INTO sce_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Goujicha beidene nie kun Bedurui chanla kieliewo, \"Chishiye hhelare hhantuku kun wo.\" Beduru kieliewo, \"Gujiu, bi pusho.\" ");
INSERT INTO sce_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Chabudu nie xioshi daodene pse nie kun kieliewo, \"Ene kenjinshi hhelare hhantuku kun enbene. Hhe yeshi Jialili kun wo.\" ");
INSERT INTO sce_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Beduru kieliewo, \"Gujiu, chi yan kieliekui bi ulie mejiene!\" Zhen kieliekude tigha kheilawo. ");
INSERT INTO sce_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ingie Ezhan ochira Beduruni uzhewo. Beduru Ezhan kieliesan enedu tigha kheilatula chi mii 3 hui ulie renjine giesei sumula ire ");
INSERT INTO sce_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","khizhi echidene nango giezhi hende wilawo. ");
INSERT INTO sce_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ersai uzhesan kunla xilun giezhi eghizho. ");
INSERT INTO sce_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nudunyini huighadene asazho, \"Chii kien eghisei kielie?\" ");
INSERT INTO sce_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Hhela pse olon zannan kielienghala hhei sugiezhi shizheghazho. ");
INSERT INTO sce_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ogheise bexinlani zhanlao, fugie buwa, jinwun hanjiala man hhantulazho. Hhela Ersai laidene zui fugie fayende echi ");
INSERT INTO sce_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","kieliewo, \"Chishi Mexiha enbese bijiende kielie.\" Ersa kieliewo, \"Bi tande kieliese taye xianxin ulie giene. ");
INSERT INTO sce_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Bi tande asase taye ulie kieliene. ");
INSERT INTO sce_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Enedu khuinashi Kunnikewon Nenlitu Hudai borun miende soune.\" ");
INSERT INTO sce_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ingiese hhela man kieliewo, \"Qinse chishi Hudai kewon enbenu?\" Ersa hhelade kieliewo, \"Bi enbene giezhi ta kieliezho.\" ");
INSERT INTO sce_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ingie hhela kieliewo, \"Pse yan ganzhen kerene? Hhe goyane kieliesei matan qinsi chenliewo!\" ");
INSERT INTO sce_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kunla man hhantu Ersai Biladoi melie echighawo. ");
INSERT INTO sce_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Hhela Ersai zhazhi qiiwo, \"Ene kun bexinlani shanjizhi Lomani honshan Kaisade shui bu jiui giezho. Pse goyane Mexihai wo, honshan wo giezho.\" ");
INSERT INTO sce_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","BiladoErsade asawo, \"Chishi Yutai kunni honshan onu?\" Ersa kieliewo, \"Chi kieliezho.\" ");
INSERT INTO sce_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Bilado fugie buwa, kunlade kieliewo, \"Bi ene kunse yama zui chaizhi khizhe dawo.\" ");
INSERT INTO sce_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ingieliuzhe hhela pse zhazhi hendawo, \"Ene kun bexinlade sughazhi shanjizhi Yudayani gochude echizho. Jialilise enende irewo.\" ");
INSERT INTO sce_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Bilado chenliedene asawo, \"Eneshi Jialili kun onu?\" ");
INSERT INTO sce_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Jialilini Hherode gonjisei Bilado mejiedene Ersai Hherodei hhende khughoghawo. Hhe shihoude Hherode zhen Yelusalende wo. ");
INSERT INTO sce_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","HherodeErsai chanladene hende bayasuzho. Hhe giesan shiqinni chighindei irese melieshise nie ochirane giezho. Ghudureqi xienjighase uzhene giezho. ");
INSERT INTO sce_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ingie HherodeErsade olon asawoma Ersa yama ese kieliewo. ");
INSERT INTO sce_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Fugie buwa, jinwun hanjiala beidene hende zhazho. ");
INSERT INTO sce_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hherode buduighalane Ersai uzhezhi xiniezhi xilun giedene seighan fudu jienyi musigha, Biladoi hhende echighawo. ");
INSERT INTO sce_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Melieshida HherodeBiladoghala duitou wo. Hhe niudude zhanlien gholuwo. ");
INSERT INTO sce_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Bilado fugie buwa, lindao, bexinlani uruzhi hhantulaghadene ");
INSERT INTO sce_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","hhelade kieliewo, \"Ta ene kunyi mii enende ireghase ene kun bexinlai shanjizho giezho. Uzhe, bi tai melie ene kunyi xianxide shenwun giewoma, ene kunde ta zhasan qimutu zui uwo. ");
INSERT INTO sce_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hherodeye yama zuini ereizhi olu dadene enende kharei ireghawo. Ene kunde fugughaku zui uwo. ");
INSERT INTO sce_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Enei ingieye, nie faidene andaghaye.\" ");
INSERT INTO sce_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kunla man waradazhi kieliewo, \"Ene kunni ala! Balabai andagha!\" ");
INSERT INTO sce_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balabashi hhe chenshide panlon giezhi kun aladene bafanzide khasan wo. ");
INSERT INTO sce_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","BiladoErsai andaghaku duran wine, hhelade qingiezhi kieliezho. ");
INSERT INTO sce_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ingiese kunla, \"Ersai shizijia jiere ghada! Shizijia jiere ghada!\" giezhi waradazhi ulie olune. ");
INSERT INTO sce_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Bilado 3 hui hhelade kieliewo, \"Yangiezhi? Ene kun yan doghun shiqin giezho? Bi ene kunde yama fuguku zui jinji dane. Nie faidene andaghaye.\" ");
INSERT INTO sce_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kunla fugiede waradazhi izhigie kieliezho, \"Shizijia jiere ghada!\" Hhelai shenqi injiwo. ");
INSERT INTO sce_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ingie Bilado hhela kieliesan mutun panjiwo. ");
INSERT INTO sce_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kunla keresan mutun panlon giezhi lon kun alasan hhe kunyi bafanzise khizheghawo. Ingiedene Ersai hhelai durande teiwo. ");
INSERT INTO sce_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ersai lai echikude nie xianse iresan Gulinai kun Ximun wo. Shizijiani hhende beilieghadene Ersai daghaghazho. ");
INSERT INTO sce_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Olon kun Ersai daghazho. Hhelai dunda niezhan biereila Ersade zhughe otuzhi wilazho. ");
INSERT INTO sce_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ersa ochiradene hhelade kieliewo, \"Yelusalenni funila, ta made oluzhi bu wila, goyadene, kesiladene oluzhi wila. ");
INSERT INTO sce_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Hhe shihou ijin irene, irese kunla kieliene, 'Kewosi uye olusan, uye laisan, uye gogoghasan biereilade fuqi wine!' ");
INSERT INTO sce_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Hhe shihoude kunla fugie ulade kieliezhi bijienni jiere una! Ga ulade kieliezhi bijienni kha giene. ");
INSERT INTO sce_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Hhela noghon mutunde ingiezhi giese ghosan mutunde matugie giene?\" ");
INSERT INTO sce_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Da ghua fanrenlai Ersare hhantu alane giezho. ");
INSERT INTO sce_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Hhela qiorun yasun oron giesan oronde kudene Ersai shizijia jiere ghadawo. Ghua fanrenniye Ersai lianmiende ghadawo. ");
INSERT INTO sce_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ersa kieliewo, \"Adaya, hhelai mienlie. Hhela yan giesanne ulie mejiene.\" Buduila fendan qianguzhi Ersai jienni ghughazho. ");
INSERT INTO sce_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bexinla beidene uzhezho. Noyenlaye uzhezhi xiniezhi kieliezho, \"Hhe kunlai jiuiwo, goyashi Huda sunghusan Hudai Mexiha enbese goyane jiui gie.\" ");
INSERT INTO sce_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Buduila Ersai shida khirei cu ogidene xilun giezhi ");
INSERT INTO sce_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","chi Yutai kunni honshan enbese goyane jiuisha giezho. ");
INSERT INTO sce_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ersai qiorun qinde nie peizii gie eneshi Yutai kunni honshan wo giezho. ");
INSERT INTO sce_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Hhantu ghadasan nie fanren Ersai sugiezhi kieliewo, \"Chishi Mexiha pushonu? Goyane jiuidene bijienyiye jiuisha!\" ");
INSERT INTO sce_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Da nie fanren hhei sugiezhi kieliewo, \"Chii xianxianji fugughaku zui panjidene Hudase da ulie ayinu? ");
INSERT INTO sce_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Matan giesan wilie mutunshi ghadase oluzho, ene kun nie huaishi ese giezho.\" ");
INSERT INTO sce_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ingie kieliewo, \"Ersa, chi goya gojiadene qienli bareikude mini jila.\" ");
INSERT INTO sce_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ersa kieliewo, \"Bi chade shuhua kielieye, enedu matan ghuala qientande hhantulane.\" ");
INSERT INTO sce_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Chabudu zhunwuse xiawu 3 jien olutula zemin man kharalazho. ");
INSERT INTO sce_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Naran nudun kharalawo. Dajienni sudorodu menlienzi dundase kei echidene ghua gholuwo. ");
INSERT INTO sce_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ersa fugiede waradazhi kieliewo, \"Ada, bi chade ruhherne jiuiye!\" Ene kielienyi kieliedene ho sirawo. ");
INSERT INTO sce_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Baifuzhan ene shiqinni chanladene Hudai kuaizhi kieliewo, \"Eneshi zhenzhen gou kun enbene!\" ");
INSERT INTO sce_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Fashen giesan shiqinni uzhesan kunla man echanne chuidazhi khareiwo. ");
INSERT INTO sce_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Niezhan Ersai tanisan kunla, Jialilise daghazhi iresan biereila gholode beidene uzhezho. ");
INSERT INTO sce_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Fugie fayenni nie noyenyi nierei Yusufu giene. Hheshi nie gou kun wo, gundan kun wo. ");
INSERT INTO sce_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Fayende kunla hui keizhi Ersai widaghane giese ene kun tunyi ese oluwo. Hheshi Yudayani Yalimatai chenshini kun wo, izhi Hudai gojia irekui sagheizho. ");
INSERT INTO sce_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Biladoi hhende echidene Ersai beyeni xiahua giezhi kerewo. ");
INSERT INTO sce_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Agi bouzhe boside boui tashide waisan fugie mezade teiwo. Hhe mezade kun nieda teizhi ese daozho. ");
INSERT INTO sce_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Enedushi zhunbei gieku udu wo. Hhamuraku udu ede kuzhene. ");
INSERT INTO sce_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Jialilise Ersai daghazhi iresan biereila khuina daghadene mezade Ersai beyeni matui teisei uzhewo. ");
INSERT INTO sce_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ingie hhela khareizhi echidene xianlio, xianshui zhunbei giezho. Hhamuraku udu oluwo. Hhela jiomunni minlinni zunjizhi hhe niudude hhamurawo. ");
INSERT INTO sce_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Xinqini ogheikude giedun biereila zhunbei giesan xianlioni bareidene mezade irewo. ");
INSERT INTO sce_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Hhela uzhese mezai duighasan tashi ghoghorei daozho. ");
INSERT INTO sce_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Oro echi uzhese Ezhan Ersai beye wida khizho. ");
INSERT INTO sce_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Hhela zhen jindakude menzhali ghua kun shidani beizho, jienseni gon faine. ");
INSERT INTO sce_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Niende ayidene melie papalazho. Hhe ghua kun biereilade kieliezho, \"Ta yangiezhi fugusan kun dundase amitu kun ereine? ");
INSERT INTO sce_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Hhe enende uwo, aminne oluwo. Hhe Jialilide kieliesan kielienyi ta jila danu? ");
INSERT INTO sce_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Hhe kieliezhi Kunnikewonyi matugieseda zuirende jiuizhi ogidene shizijia jiere ghadane. Ghurudu udude aminne olune giewo.\" ");
INSERT INTO sce_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Hhe biereila Ersa kieliesanyi sumula irewo. ");
INSERT INTO sce_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Hhela mezase khareizhi echidene ene shiqinlai 11 gie tujilade pseshiku kunlade man kieliezho. ");
INSERT INTO sce_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ene shiqinyi shitulade kieliesan biereilashi Modalani Mereiyen, Yeyana, Yagebuni anani Mereiyenji pse giedun biereila wo. ");
INSERT INTO sce_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Shitula ene kielienyi xianxin ese giezho. Hu kieliezho giezho. ");
INSERT INTO sce_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ingieliuzhe Beduru bosi ire mezade holuzhi echidene ghodei nie uzhese nie bosi wo, pse yama uwo. Khareikude matui imutui gholuwo giezhi sumulazho. ");
INSERT INTO sce_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Hhe niudude Ersai daghasan ghua tujilani Imawusi giesan aghinde echine giezho, Yelusalense 22 li mo wo. ");
INSERT INTO sce_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Hhela mo jiere yokude fashen giesan shiqinlai kielienduzho. ");
INSERT INTO sce_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Zhen kieliendukude Ersa qinsi shidani kuzhezhi hhelare hhantu yozhoma, ");
INSERT INTO sce_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","hhelai nudun madadene kien bikuni tani dazho. ");
INSERT INTO sce_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ersa hhelade asazho, \"Ta yon yon yan kielienduzhou?\" Hhela beidene nango giezhi uxinne boughazho. ");
INSERT INTO sce_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Nie kunni niereini Geliuba giene. Ersade kieliewo, \"Chi Yelusalende toreizhi ene giedudu fashen giesan shiqinlai chi niezheghanne ulie mejienu?\" ");
INSERT INTO sce_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ersa asawo, \"Yan shiqin wo?\" Hhela kieliewo, \"Nasaleni Ersai shiqin wo. Hheshi nie xienzhi wo. Hudai melie bexinlai melie kielien kieliekude, giekude nenli wine. ");
INSERT INTO sce_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Mai fugie buwa, noyenla hhei jiuidene fugughaku zui panjisenu shizijia jiere ghadawo. ");
INSERT INTO sce_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Bijien panjise hheshi Isilieni jiuile iresan enbene giezho. Ene shiqin fashen giezhi ghurudu oluwo. ");
INSERT INTO sce_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ingiedene bijienyi dundase giedun bierei bijienyi ghaniraghawo. Hhela eqiemagha eqie meza konde echise ");
INSERT INTO sce_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ersai beye wida khizho. Ingie kharei iredene bijiende kieliese qienxienlai chanlawo giezho. Qienxienla kieliese hhe aminne oluwo giene. ");
INSERT INTO sce_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ingie bijien giedun kun dagha mezadei uzhele echise biereila kieliesan mutun wo. Ersai chanla dawo.\" ");
INSERT INTO sce_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ersa hhelade kieliewo, \"Ta ene yama ulie mejiesan kunla, ta xienzhila kieliesan kielienyi gou xianxin ese giezho. ");
INSERT INTO sce_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Mexiha Hudaghala hhantu undu wizide soutula ingiezhi shouku giedene goyane famashighaku pushonu?\" ");
INSERT INTO sce_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ingiedene Musa, xienzhilani shu kaishi giezhi jinwun jiere goya fanmiende huaisan kielienni hhelade kieliezhi man minbai olughawo. ");
INSERT INTO sce_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Hhela echiku hhe aghinde kuzhese Ersa melie yosanyi xianli. ");
INSERT INTO sce_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Hhela ninkounin Ersai feilieghazhi kieliewo, \"Ede nanran pudawo, khara oluwo. Matan enende hhantu souye.\" Ingiese Ersa hhelare hhantu echi souwo. ");
INSERT INTO sce_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ijiekude Ersa ginanyi barei Hudade mafan kieliedene ghulu hhelade ogiwo. ");
INSERT INTO sce_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ingiekude hhelai nudun gieghere Ersai tanise Ersa menzhali hhelai meliese wida khiwo. ");
INSERT INTO sce_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Hhela kieliewo, \"Mo jiere hhe matande jinwun jianjikude matanyi zhughe khalundazhola?\" ");
INSERT INTO sce_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ingie deigo bosizhe Yelusalende echidene 11 gie tuji, psedu kunla hhantulakui chanlawo. ");
INSERT INTO sce_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Kunla kieliezho, \"Ezhan shuhuane aminne oludene Ximunde chujiegheghazho.\" ");
INSERT INTO sce_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Hhe ghuala mo jiere Ersai penjisan shiqinyi, pse ginan ghuluzhi ogikude matugie tanisanyi hhelade man kieliewo. ");
INSERT INTO sce_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Zhen ene kielienyi kieliekude Ersa qinsi hhelai dunda ire beizhi kieliewo, \"Ta pinnan onu?\" ");
INSERT INTO sce_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Hhela hende ayizhi sumulase ruhher chanlawo giezho. ");
INSERT INTO sce_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ersa hhelade kieliewo, \"Ta yale ingiezhi jindazhi xianxin ulie giene? ");
INSERT INTO sce_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ta kon khaimini nie moizhi uzhema, bi enbekui mejiene. Ruhherde yasun migha uwo. Ta uzhe, made wine.\" ");
INSERT INTO sce_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ene kielienyi kieliedene kha, konne hhelade uzheghawo. ");
INSERT INTO sce_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Hhela bayasuzhoma, xianxin gie dazhi ghudurezho. Ersa kieliewo, \"Tai enende yama ijiekui winu uwo?\" ");
INSERT INTO sce_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ingie hhela shirasan zhaghasunse gouji ogiwo. ");
INSERT INTO sce_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Hhe jienliedei hhelai melie ijie agiwo. ");
INSERT INTO sce_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ersa hhelade kieliewo, \"Eneshi bi melieshida tanre hhantu bikude kieliesan wo. Musani guijinshu, xienzhishu, zeburei jiere mii zhiizhi huaisanlai man ijinyo gholughakuni wo.\" ");
INSERT INTO sce_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ingiedene Ersa hhelai sumuladanyi minbai olughazhi jinwunni dunjireghadene ");
INSERT INTO sce_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","hhelade kieliewo, \"Jinwun jiere ingiezhi huaizho, Mexiha irese ijinyo shouku giezhi duya ijiedene ghurudushi aminne olune. ");
INSERT INTO sce_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Pse hhei niereghala geizhen giese roulieku gouxioxini Yelusalense soyuji minzulade chonji keine. ");
INSERT INTO sce_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ta ene shiqinde ganzhen bei. ");
INSERT INTO sce_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Adami dain giesan hhei bi tai jiere peizhi ireghane. Asiman jierese Hudai nenli tande olon iretula ta ene chenshide saghei.\" ");
INSERT INTO sce_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ersa hhelai uduruzhi Bodanide echidene khane zhadeighazhi hhelade oluzhi onxian giewo. ");
INSERT INTO sce_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Zhen onxian giekude hhelase likai gie asiman jiere khireiwo. ");
INSERT INTO sce_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Hhela Ersai beiidene hende bayasuzhi Yelusalende khareiwo. ");
INSERT INTO sce_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Hhela Hudade doulazhi chan mechide wo.");
INSERT INTO sce_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Zui melieshida Kielien wine. Ene Kielien Hudaghala hhantu wo. Ene Kielienshi Huda wo. ");
INSERT INTO sce_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Hhe zui melieshida Hudaghala hhantu wo. ");
INSERT INTO sce_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Duya jiereshikulai man hhe zhayaghawo. Hhe uye zhayaghasei nieda uwo. ");
INSERT INTO sce_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Hhei sudoro amin wine. Ene aminshi kunlai gon wo. ");
INSERT INTO sce_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Gon kharanide zhouise kharani gonni gieru dane. ");
INSERT INTO sce_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Yaheiya giezhi nie kunyi Hudai hhense peizhi ireghawo. ");
INSERT INTO sce_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Hhei peizhi ireghase hhe gonde ganzhen beizhi kunlai man xianxin gieghane giezho. ");
INSERT INTO sce_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ene kunshi gon pusho, gonde ganzhen beile irezho. ");
INSERT INTO sce_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Kunlai giegheraghaku zhenzhenji hhe gon duyade irezho. ");
INSERT INTO sce_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Hhe duyade wo, hhei tungo giezhi duyai zhayaghawoma, duya hhei tani dane. ");
INSERT INTO sce_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Hhe goya orondene irese goyai kunla hhei ese jienliewoma, ");
INSERT INTO sce_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","jien hhei jienliezhi niereini xianxin giesan kunlade Hudai kewosi danlaku qienli ogiwo. ");
INSERT INTO sce_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ene kesilashi kun jierese iresan pusho. Kunni duranghala jihua giedene olusanye pusho, Hudase iresan wo. ");
INSERT INTO sce_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ene Kielien kun gholudene mai dunda souzho. Matan hhei famani uzhese zhen Adani niekozi Kewonni famani wo. Hhei sudoro nenjien, zhendao olon wo. ");
INSERT INTO sce_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yaheiya hhende ganzhen beizhi fugiede kieliewo, \"Eneshi hhe mase khuina irenema, mase hen wo. Hhe zui melieshidasejiu wine giezhi bi kieliezhi daosan hhe wo.\" ");
INSERT INTO sce_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Matan man hhei fugie nenjien jierese nenjien olon jienliezho. ");
INSERT INTO sce_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Guijinshi Musase irezho. Nenjien, zhennishi Ersa Mexihase irezho. ");
INSERT INTO sce_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kiemada Hudai chujieghezhi ese daozhoma, Hudai zhughe jieredu niekozi kewon Hudai mejieghawo. Hhe benshenshi Huda wo. ");
INSERT INTO sce_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yelusalense Yutai kunla buwa, Liwi kunlai peizhi Yaheiyashi kien bikuni asaghale echise Yaheiya ingiezhi ganzhen beizho. ");
INSERT INTO sce_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Hhe ghudan ese kieliezhi zhijie kieliewo, \"Bishi Mexiha pusho.\" ");
INSERT INTO sce_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Hhela pse asawo, \"Qinse chishi kien wo? Iliya onu?\" \"Pusho.\" \"Qinse chishi hhe nie xienzhi onu?\" \"Pusho.\" ");
INSERT INTO sce_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ingiese hhela kieliewo, \"Chi daojishi kien wo? Bijien khareizhi echise peizhi ireghasan kunlade jiodai giene. Chi goyane nie kielie. Chishi kien wo?\" ");
INSERT INTO sce_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Hhe kieliewo, \"Bishi Isaiya xienzhi kieliesan mutun Ezhanni moni zhidagha giezhi hontande waradasan hhe shenqi wo.\" ");
INSERT INTO sce_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Hhelashi Falisai kun peizhi ireghasan wo. ");
INSERT INTO sce_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ingiese asazho, \"Chi Mexiha pusho, Iliya pusho, hhe nie xienzhiye pusho. Chi yangiezhi kunlade xili gieghazho?\" ");
INSERT INTO sce_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yaheiya kieliewo, \"Bi usughala xili gieghazhoma, ta tani dasan daniezhan tai dunda beizho. ");
INSERT INTO sce_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Hhe mase khuina irenema, bi hhende mahei deizi andaghaseye pei dane.\" ");
INSERT INTO sce_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ene shiqinlashi Yedanheni hhemandedu Bodanide fashen giesan wo, zhen Yaheiya xili gieghasan oron wo. ");
INSERT INTO sce_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Khuichuduni Ersa hhelai hhende iresei Yaheiya chanladene kieliewo, \"Uzhe, duyai kunlai zuini widaghaku Hudai ghoni ghughan wo! ");
INSERT INTO sce_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Eneshi hhe mase khuina irenema, mase hen wo. Hhe zui melieshidasejiu wine giezhi bi kieliezhi daosan hhe wo. ");
INSERT INTO sce_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Bi melieshidase hheni tani dane. Bi ede usughala xili gieghase hhei Isilie kunlade mejieghane giezho.\" ");
INSERT INTO sce_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yaheiya pse ganzhen beizhi kieliewo, \"Bi melieshi chanlase Shenlin ghoghochen mutun asiman jierese bouzhezhi hhei jiere luiwo. ");
INSERT INTO sce_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Bi melieshise hhei tani dane. Mii peizhi usughala xili gieghasan Huda made kieliewo, 'Shenlin kienyi jiere bouzhesei chi chanlase hhe Shenlinghala xili gieghane.' ");
INSERT INTO sce_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Enei bi chanlawo. Eneshi Hudai kewon enbene giezhi bi ganzhen beine.\" ");
INSERT INTO sce_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Khuichuduni Yaheiya ghua tujilaghalane hhantu hhende beizho. ");
INSERT INTO sce_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","YaheiyaErsai yosei chanladene kieliewo, \"Uzhe, Hudai ghoni ghughan wo.\" ");
INSERT INTO sce_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ghua tujilani ene kielienyi sonosudene Ersai daghawo. ");
INSERT INTO sce_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ersa ochirasenu hhela daghasei chanladene asawo, \"Ta yan kerene?\" Hhela kieliewo, \"Labi, chi khala souzho?\" Labishi loushii isi wo. ");
INSERT INTO sce_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ersa kieliewo, \"Ta uzhele irendu.\" Hhela daghazhi echidene sousan oronyini uzhewo. Hhe xienzide chabudu xiawu 4 jien oluzho. Hhe udu hhela Ersare hhantu souwo. ");
INSERT INTO sce_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yaheiyai kielienyi chenliedene Ersai daghasan ghua kun dundadu nieshi Ximun-Bedurui jiuni Andelie wo. ");
INSERT INTO sce_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Hhe xien Ximun gaine ereizhi oludene kieliewo, \"Bijien Mexihai penjiwo!\" Mexihai fanyi giese Jidu wo. ");
INSERT INTO sce_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ingiedene hhe Ximunni uduruzhi Ersai shida echiwo. Ersa hhei uzhedene kieliewo, \"Chishi Yaheiyai kewon Ximun wo. Ede chii Jifa giezhi urune.\" Jifai fanyi giese Beduru wo. ");
INSERT INTO sce_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Khuichuduni Ersa jiejin giezhi Jialilide echine giezho. Ingiekude Feilii penjidene hhende kieliewo, \"Chi mii dagha.\" ");
INSERT INTO sce_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Feilishi Bosaida kun wo. Andelie, Beduru enelashi nie oronnughun wo. ");
INSERT INTO sce_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","FeiliNadanyei ereizhi oludene kieliewo, \"Musai guijin jiere huaisan, xienzhila jilasan hhe kunyi bijien chanlawo. Hheshi Nasale kun, Yusufui kewon Ersa wo.\" ");
INSERT INTO sce_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ingie Nadanye kieliewo, \"Nasalese pse yama khizheneba.\" Feili kieliewo, \"Chi iredene uzhe.\" ");
INSERT INTO sce_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ErsaNadanye shidani iresei chanladene kieliewo, \"Uzhe, eneshi nie zhenzhenji Isilie kun wo. Hhei zhughede yama huaini uwo.\" ");
INSERT INTO sce_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nadanye asawo, \"Chi mii matugie taniwo?\" Ersa kieliewo, \"Feili chii da ese urukude chi uhuago mutun doura bikui bi chanlawo.\" ");
INSERT INTO sce_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nadanye kieliewo, \"Loushi, chishi Hudai Kewon, Isilie kunni honshan wo.\" ");
INSERT INTO sce_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ersa kieliewo, \"Bi chii uhuago mutun doura bikui chanlawo giezhi kieliese chi mii xianxin giewu? Chi enense da fugie shiqin uzhene.\" ");
INSERT INTO sce_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Pse hhelade kieliewo, \"Bi shuhuajia tande kielieye, asiman keizhi Hudai qienxienla Kunnikewonyi jiere bouzhi khikui ta chanlane.\" ");
INSERT INTO sce_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ghurudude Jialilini Jianade kunla ghurun ijiezho. Ersai anani ye hhende wo. ");
INSERT INTO sce_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ersa, tujilaini man hhantu xinlazhi echizho. ");
INSERT INTO sce_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Jiuni ochizhi baraghawo. Ersai anani Ersade kieliewo, \"Hhelade jiu widazho.\" ");
INSERT INTO sce_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ersa kieliewo, \"Ana, hhe made yan xiangan wo? Mii shihou da ese kuruzho.\" ");
INSERT INTO sce_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Hhei anani hojilade kieliewo, \"Hhe tai yan gieghase ta yan giendu.\" ");
INSERT INTO sce_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Hhende usu zhonloku zhighon gan wine. Nie gande ghua ghuran tunzi usu zhonlone. Zhonmun libai giekude injiku usui hhende teizho. ");
INSERT INTO sce_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ersa hojilade kieliewo, \"Gande usui durugha.\" Ingiese hojila usui zhonlozhi gan kouzide khizheghawo. ");
INSERT INTO sce_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ersa pse hojilade kieliewo, \"Ede yuzhi xi gonjisan kunde khughozhi echigha.\" Ingiese hhela echighawo. ");
INSERT INTO sce_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Xi gonjisan kun usu jiu bienjisei nie ochise ene jiu khalase iresei ulie mejiene. Zi usu yusan hojila mejiene. Xi gonjisan kun shini khughonyi uru ire kieliewo, ");
INSERT INTO sce_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","\"Kunla gou jiuni melieshi ireghane. Zhochenla ochizhi sudosenu bixin jiuni ireghane. Chi matui gou jiuni feilieghazhi eli kuzho.\" ");
INSERT INTO sce_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Eneshi Ersa xienjighasan tou 1 gie ghudureqi wo. Jialilini Jianade xienjighawo. Ene ghudureqighala kunlade famane mejieghawo. Ingiese tujilani hhei xianxin giewo. ");
INSERT INTO sce_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Enense khuinashi Ersa, anani, jiulani, tujila man Jiabainunde bouzhi echidene giedudu souwo. ");
INSERT INTO sce_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yutai kunni Jiulidaosan Jie ghujinlase ErsaYelusalende echiwo. ");
INSERT INTO sce_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Echise kunla mechide orodene meimei giesei chujieghewo. Kunla fughe, ghoni, ghoghochen huizho. Dazeghan kunla souzhi baer arunzhazho. ");
INSERT INTO sce_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ingiese Ersa jiesunyi mushigheidene fughe ghonilai mechise tou khighawo. Baer arunzhasan kunlai baerlani kie khizhegha, shirelani tungu unaghawo. ");
INSERT INTO sce_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Pse ghoghochen huisan kunlade kieliewo, \"Dunxilane man banji khirei! Adaimi giei meimei gieku oron bu gholugha!\" ");
INSERT INTO sce_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ingiekude tujilani jinwun jiere huaisan kielienyi sumula irewo, \"Bi Adane giede oluzhi zhughedemi khan siderazho.\" ");
INSERT INTO sce_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ingiese Yutai kunla Ersade kieliewo, \"Chade ingiezhi gieku qienli winu? Chi bijiende yan ghudureqi xienjighane?\" ");
INSERT INTO sce_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ersa kieliewo, \"Ta ene mechini chei. Bi ghurudude gie khizheghane.\" ");
INSERT INTO sce_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Hhela kieliewo, \"Ene mechishi 46 niende giezhi khireighasan wo. Chi ghurudude giezhi khizheghanu?\" ");
INSERT INTO sce_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ersa kieliesan mechishi goya beyene kieliezho. ");
INSERT INTO sce_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ersa aminne oludene tujilani Ersai ene nie aman kielienyi sumula irewo. Ingiese hhela jinwunyi xianxin giewo. Ersa kieliesan kielienlai ye xianxin giewo. ");
INSERT INTO sce_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ErsaYelusalende Jiulidaosan Jie daoghakude ghudureqi xienjighase olon kunla uzhedene Ersai xianxin giewo. ");
INSERT INTO sce_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ingieliuzhe Ersa hhelai xianxin ese giezho. Ersa kunlai man mejiene. ");
INSERT INTO sce_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Hhe kunni zhughede yan bikuni mejiene. Ingiese hhende kunshi matunie bikui kielieku biyo uwo. ");
INSERT INTO sce_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Falisaini nie kunyi niereni Nigedemu giene. Yutai kunlani nie lindao wo. ");
INSERT INTO sce_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ene kun xienidei Ersai ochirale ire hhende kieliewo, \"Labi, chi Hudai hhense iresan loushi bikui bijien mejiene. Huda chighala hhantu wise chi giesan ghudureqini kiemada gie dane.\" ");
INSERT INTO sce_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ersa hhende kieliewo, \"Bi chade shuhuajia kielieye, kunyi erchan ulie oluse Hudai gojiai chanla dane.\" ");
INSERT INTO sce_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nigedemu kieliewo, \"Kun fugiedadene pse matugie olune? Anane kielide orosenu pse olunu?\" ");
INSERT INTO sce_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ersa kieliewo, \"Bi chade shuhuajia kielieye, kunyi usu, Shenlinse ulie oluse Hudai gojiade oro dane. ");
INSERT INTO sce_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Beyese olusanshi beye wo, ruhherse olusanshi ruhher wo. ");
INSERT INTO sce_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Bi kieliese ta erchan olukuni wo giese ta bu ghudure. ");
INSERT INTO sce_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kei suibien feiliekui ta sonosu shidanema, khalase iresanyi, khala echikui ulie mejiene. Ruhherse olusan kun keighala niekielien wo.\" ");
INSERT INTO sce_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nigedemu asazho. \"Matugie imutu shiqin wine?\" ");
INSERT INTO sce_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ersa kieliewo, \"Chishi Isilieni fugie loushi wo. Ene shiqinyi ulie mejienu? ");
INSERT INTO sce_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Bi shuhuajia kielieye, bijien mejiesanne tande kieliezho, chujieghesanne ganzhen beizhoma, ta bijienyi kielienyi xianxin ulie giene. ");
INSERT INTO sce_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Bi zemin jieredu shiqinyi kieliese ta xianxin ulie giene, asiman jieredu shiqinyi kieliese matugie xianxin giene? ");
INSERT INTO sce_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Asiman jierese bouzhesan Kunnikewonse chugo kiemada asiman jiere khizhi ese daozho. ");
INSERT INTO sce_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Musa hontande mogheini qila qiighaku mutun Kunnikewonniye qingiezhi qila qiighane. ");
INSERT INTO sce_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ingiese jien hhei xianxin giesan kunlade chanqiku amin ogine giezho. ");
INSERT INTO sce_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Huda duyani kunlade olon orezhi lien niekozi kewonneliuzhe ogiwo. Ingiese jien hhei xianxin giesan kunlai ulie widaghazhi chanqiku amin ogine giezho. ");
INSERT INTO sce_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Hhe kewonne peizhi duyade ireghase zui jinjile ese irezho, kunlai jiuighale irezho. ");
INSERT INTO sce_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Hhei xianxin giesan kunlade zui ulie jinjine. Xianxin ulie giesan kunlade zui ijin jinjiwo. Hhela Hudai niekozi kewonni xianxin ese giezho. ");
INSERT INTO sce_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Hhela giesan doghunnishi gon duyade irese gonde xiqi uwo, kharanide xiqi wo. Hhelai zuini jiu ingiezhi soughawo. ");
INSERT INTO sce_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Doghunni giesanla gonni henjine, gon shida ulie irene. Giesanlaini khizheghakuse ayizho. ");
INSERT INTO sce_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Zhendaode giesan kunla gon shida irene. Hudai isighala giesan shiqinlai man mejieghane giezho.\" ");
INSERT INTO sce_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Enense khuinashi Ersa tujilarene Yudayani oronde echidene nietan souzhi kunlai xili gieghazho. ");
INSERT INTO sce_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Salenni kouisan Ainende usu olonshi Yaheiyaye hhende xili gieghazho. Kunla hhende xili gieghakui jienliele irezho. ");
INSERT INTO sce_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Hhe shihoude Yaheiyani da bafanzide bareizhi ese echizho. ");
INSERT INTO sce_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yaheiyai tujila nie Yutai kunghala waghaku banfa jiere jianjindu qiiwo. ");
INSERT INTO sce_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Hhela Yaheiya shida iredene kieliewo, \"Loushi, melieshida Yedanhe hhemiende chighala hhantulasan hhe kun ede kunlade xili gieghazho. Chi hhende ganzhen beizho. Kunla man hhei shida echizho.\" ");
INSERT INTO sce_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yaheiya kieliewo, \"Huda ulie ogise kun yama jienlie dane. ");
INSERT INTO sce_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Bishi Mexiha pusho. Mii hhense melie peizhi ireghawo giezhi bi kieliezhi daosei ta mejiene. ");
INSERT INTO sce_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Shini bierei agikushi shini khughon wo. Peikieni hhei kanzide beizhi shenqiini nie sonosuse hende bayasune. Biye qingiezhi hende bayasuzho. ");
INSERT INTO sce_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Hhe hendakuni wo, bi bixindakuni wo.\" ");
INSERT INTO sce_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","\"Jierese iresan hhe yanseliuzhe fugie wo. Zemin jierese iresanshi zemin jieredu wo. Kieliesan kielienla yeshi zemin jieredu wo. Asiman jierese iresan hheshi yanseliuzhe fugie wo. ");
INSERT INTO sce_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Hhe chujieghesanne, chenliesanne ganzhen beizhoma, hhei ganzhenyi kiema ulie jienliene. ");
INSERT INTO sce_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Hhei ganzhenyi xianxin giesan kunla Hudashi zhenni enbene giezho. ");
INSERT INTO sce_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Huda peizhi ireghasan hhe Hudai kielienyi kieliene. Huda hhende Shenlinni shuzi witui ogizho. ");
INSERT INTO sce_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Adani kewondene orezhi man hhei khade jiuiwo. ");
INSERT INTO sce_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kewonyini xianxin giesan kunde chanqiku amin wine. Hhei ulie shunjichen kunde amin uwo. Hudai hokuku chan hhei jiere wo.\" ");
INSERT INTO sce_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Falisai kun chenliese ErsaYaheiyase tuji olon ghurazhi xili gieghazho. Shiji jiere Ersa goyane xili ese gieghazho, tujilani gieghazho. Ersa ene shiqinlai mejiedene Yudayase likai gie Jialilide khareine giezho. ");
INSERT INTO sce_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Echikudeni Samaliya moni daone. ");
INSERT INTO sce_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Samaliyai nie chenshide kuruwo. Niereini Xijia giene. Ene chenshishi YagebuYusufu kewondene ogisan oron konde wo. ");
INSERT INTO sce_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yagebuni jin hhende wo. Ersa yozhi hhechese jin konde souwo. Chabudu zhunwu xienzi wo. ");
INSERT INTO sce_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Samaliyai nie bierei usu daile irese Ersa hhende kieliewo, \"Made ususene gouji ogi.\" ");
INSERT INTO sce_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ene shihoude tujilani chenshise ijiuni agile echizho. ");
INSERT INTO sce_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Samaliyai bierei kieliewo, \"Chishi Yutai kun wo. Matugie Samaliyai nie biereise usu kerene?\" Yenlai Yutai kun Samaliya kunghala laiwon ese giezho. ");
INSERT INTO sce_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ersa kieliewo, \"Chi Hudai nenjienni mejiese, pse chase usu keresanshi kien bikui mejiese chi hhei xiahua giene, hhe amitu usui chade ogine.\" ");
INSERT INTO sce_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Bierei kieliewo, \"Gujiu, chade usu daiku tunzida uwo. Jin imutu gun wo. Chi khalase amitu usu daine? ");
INSERT INTO sce_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Bijienyi xienren Yagebu ene jinni bijiende jiewo. Hhe goyane, kesilani, asunla man enense ijiezho. Chi hhense da fugie onu?\" ");
INSERT INTO sce_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ersa kieliewo, \"Ene usui usan kunla pse undasune. ");
INSERT INTO sce_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Bi ogisan usui use chanqi ulie undasune. Bi ogisan usu hhei sudoro bula gholuzhi izhi usuruzhi khizhezhi hhende chanqiku amin ogine.\" ");
INSERT INTO sce_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Bierei kieliewo, \"Gujiu, made ene usui nie ogi. Ingiese bi ulie undasune. Bi pse enense usu daile ulie irene.\" ");
INSERT INTO sce_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ersa kieliewo, \"Chi echidene zhanguijine uruzhi ire.\" ");
INSERT INTO sce_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Bierei kieliewo, \"Made zhanguiji uwo.\" Ersa kieliewo, \"Chade zhanguiji uwo giezhi kieliesan oluzho. ");
INSERT INTO sce_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Melieshida chade tawun zhanguiji wine. Edekushi chii zhanguiji pusho. Chi kieliesan oluzho.\" ");
INSERT INTO sce_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Bierei kieliewo, \"Gujiu, bi uzhese chishi nie xienzhi wo. ");
INSERT INTO sce_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Bijien Samaliya kunyi xienrenla ene ulade beii giezhoma, ta Yutai kunla kieliese Yelusalenshi beiiku oron wo giezho.\" ");
INSERT INTO sce_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ersa kieliewo, \"Funi, mii xianxin gie. Shihou kuzhese Adai beiiku ene ulade uwo, Yelusalende ye uwo. ");
INSERT INTO sce_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ta Samaliya kun kienyi beiisanne ulie mejiene. Bijien Yutai kun kienyi beiisanne mejiene. Jiuikushi Yutai kunni tungo giezhi irene. ");
INSERT INTO sce_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Shihou kuzhese Adai shixinji beiisan kun zhughesene shixinji beiine. Shihou ede enbene. Ada ingiezhi goude beiisan kunyi ereine. ");
INSERT INTO sce_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Hudashi ruhher wo. Hhei beiisan kun indan zhughesene shixinji beiikuni wo.\" ");
INSERT INTO sce_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Bierei kieliewo, \"Hhe Jidu giezhi urusan Mexihai irekui bi mejiene. Hhe irese bijiende man mejieghane.\" ");
INSERT INTO sce_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ersa kieliewo, \"Chimare kielien kieliesanshi enbene.\" ");
INSERT INTO sce_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ingiekude tujilani kharei ire Ersa nie biereire kielien kieliesei uzhedene ghanirazho. Chi yan kerene? Chi yangiezhi biereighala kielien kieliezho giezhi kiema asa dawo. ");
INSERT INTO sce_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Hhe bierei usu tunzine jie, chenshide echisenu olon kunlade kieliewo, ");
INSERT INTO sce_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","\"Ta uzhele irendu, nie kun bi giesan shiqinlai man kielie khizheghawo! Ene kunshi Mexiha enbeneba?\" ");
INSERT INTO sce_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ingiese kunla aghinse khizhe Ersai hhende echiwo. ");
INSERT INTO sce_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ingiekude tujilani kieliewo, \"Loushi, ijie.\" ");
INSERT INTO sce_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ersa kieliewo, \"Made ta mejie daku ijiuni wine.\" ");
INSERT INTO sce_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ingiese tujilani nieniedene asazho, \"Kunla ogizhi ijieghazhoba?\" ");
INSERT INTO sce_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ersa kieliewo, \"Mii ijiunishi mii peizhi ireghasan hhei isini gieku wo. Hhei wilielai chengun olughane. ");
INSERT INTO sce_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ta kieliese pse jieran sarashi boudei ghuraku shihou olune giezho. Bi tande kielieye, ta qiorunne qila hhe ghazhade nie uzhe, ede ghuraku oluwo. ");
INSERT INTO sce_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ghurasan kun gunzi bareizhi chanqiku aminde ugu cunjizho. Ingiese tareisan kun ghurasan kunghala hhantu bayasune. ");
INSERT INTO sce_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kienni kieliedanma, 'Nie kun tareine, da nie kun ghurane.' Ene kielien oluzho. ");
INSERT INTO sce_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Bi tai peizhi ghuraghale echise ta ese khishulasan ghazhade echighawo. Ta kunla khishulasei xianshou giezho.\" ");
INSERT INTO sce_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Hhe bierei ganzhen beizhi, \"Bi giesan shiqinlai hhe kun man kielie khizheghawo!\" giezhi kieliese hhe chenshidedu olon Samaliya kunla Ersai xianxin giewo. ");
INSERT INTO sce_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Samaliya kunla Ersai ochirale irewo. Hhei xiahua giezhi hhelai hhende sou giese, Ersa ghuarudu souwo. ");
INSERT INTO sce_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ersai kielienyi chenliedene xianxin giesan kun pse olodowo. ");
INSERT INTO sce_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Hhela biereide kieliewo, \"Bijien ede xianxin giese chi kieliesan pusho. Bijien goyane hhei kielienyini chenliedene hheshi zhenzhenji duyani jiuichen enbekui mejiewo.\" ");
INSERT INTO sce_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ghuarudu daosenu Ersa hhe oronse likai gie Jialilide echiwo. ");
INSERT INTO sce_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ersa goyane kieliezhi daozho, \"Xienzhini goya aghindene ulie zunjine.\" ");
INSERT INTO sce_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ErsaJialilide kuse hhe oronyi kunla jienliezho. Hhela Yelusalende jieqi daoghale echisande Ersa giesan shiqinlai man uzhewo. ");
INSERT INTO sce_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ersa pse Jialilini Jianade khareizhi irewo. Yen melieshida usui jiu gholughasan hhe oronde wo. Hhende nie fugie noyen wine, kewonni Jiabainunde giemerezho. ");
INSERT INTO sce_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ErsaYudayase Jialilide iresanyi hhe sonosudene ochirale ire, \"Mii kewon duya ijiene giezho. Goudaghale yo!\" giezhi xiahua giewo. ");
INSERT INTO sce_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ersa kieliewo, \"Ta ghudureqi, fugie shiqinlai ulie chanlatula xianxin ulie giene.\" ");
INSERT INTO sce_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Noyen kieliewo, \"Gujiu, kewonmi ese duya ijietula nie bouzhi yo.\" ");
INSERT INTO sce_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ersa kieliewo, \"Chi kharei, kewonchii goudawo.\" Hhe kun Ersai kielienyi xianxin giedene khareiwo. ");
INSERT INTO sce_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Giedene boukudeni mo jiere hojilani hhei jienliele ire, \"Kewonchii goudawo.\" giezhi kieliewo. ");
INSERT INTO sce_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ingiese hhe asawo, \"Kewon yan shihoude goudawo?\" Hojila kieliewo, \"Uchughudu xiawu 1 jiende tuishao giezhi qiiwo.\" ");
INSERT INTO sce_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ingiese adani Ersa kewonchii goudawo giesan hhe shihoui mejiewo. Ingiese hhe nie giechilie man Ersai xianxin giewo. ");
INSERT INTO sce_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Eneshi ErsaYudayase Jialilide khareidene giesan ji 2 gie ghudureqi wo. ");
INSERT INTO sce_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Enense khuinashi Yutai kunyi nie jieqi kuzhewo. ErsaYelusalende khizhi echiwo. ");
INSERT INTO sce_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yelusalenyi Ghoni wijien shida nie bula wine. Xibolai kielienghala kieliese Bishida giene. Bula zhouwide tawun zoulan wine. ");
INSERT INTO sce_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Zoulande giemeresan kun olon kijiezho. Sugho, dogholon, beye fugusan kun olon wo. ");
INSERT INTO sce_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Hhende nie kun giemerezhi 38 nien olune. ");
INSERT INTO sce_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ersa hhe kijiesei chujieghewo. Oloncha giemeresei mejiesenu asawo, \"Chi gienne goudaghaku duran winu?\" ");
INSERT INTO sce_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Giemeresan kun kieliewo, \"Gujiu, usu gojiolukudei mii usude boughachen kun uwo. Bi goya boukudei kunla mase melieshida qianla boune.\" ");
INSERT INTO sce_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ingiese Ersa kieliewo, \"Bosizhedene ruzine agidei echi.\" ");
INSERT INTO sce_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Hhe kun deigo gouda ruzine agisenu yozhi echiwo. Hhe nie udushi hhamuraku udu wo. ");
INSERT INTO sce_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ingiese Yutai kunla hhe goudasan kunde kieliewo, \"Enedushi hhamuraku udu wo. Chi ruzii bareizhi yose ese oluzho.\" ");
INSERT INTO sce_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Hhe kun kieliewo, \"Mii goudaghasan kun ruzine bareizhi yo giezhi made kieliewo.\" ");
INSERT INTO sce_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Hhela asazho, \"Chade ruzine agidene yo giesanshi kien wine?\" ");
INSERT INTO sce_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Goudasan kun kien hhei goudaghasei ulie mejiene. Hhende kun olonshi Ersa niui widazho. ");
INSERT INTO sce_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Khuinashi Ersa mechide hhe kunyi chujieghedene kieliewo, \"Chi ede goudawoma, pse zui bu fanji. Pse enense yenzhunshine.\" ");
INSERT INTO sce_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Hhe kun echidene Yutai kunlade kieliewo, \"Mii goudaghasanshi Ersa wo.\" ");
INSERT INTO sce_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ingiese Yutai kunla Ersa chan hhamuraku udude enezighan shiqinlai giese hhei heizhi qiiwo. ");
INSERT INTO sce_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ersa hhelade kieliewo, \"Adami izhi eli kutula wilie giezho, biye giezho.\" ");
INSERT INTO sce_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ingiese Yutai kunla hhei alane giezhi hendawo. Hhe hhamuraku udui guijinyi ese zunjizho, da Hudashi goyai Ada wo giezho. Pse goyane Hudaghala pin wo giezho. ");
INSERT INTO sce_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ersa hhelade kieliewo, \"Bi tande shuhuajia kielieye. Kewon goyane kouizhi yama gie dane. Zinie Ada giesanyi uzhedene giezho. Ada giesan wilielai Kewon ye giene. ");
INSERT INTO sce_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ada Kewondene orezhi goya giesanlane hhende man uzheghazho. Da enense fugie shiqinlai hhende uzheghane. Ingiese tai ghaniraghane. ");
INSERT INTO sce_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ada fugusan kunlai bosi ireghazhi amin ogiku mutun Kewonniye goya duranghalane kunlade amin ogine. ");
INSERT INTO sce_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ada yan kunyiliuzhe ulie panjinema, panjiku qienlini Kewondene jiuizhi ogiwo. ");
INSERT INTO sce_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ingiese kunla Adai zunjiku mutun Kewonne zunjighane giezho. Kewonni ulie zunjise hhei peizhi ireghasan Adainiye uye zunjizho. ");
INSERT INTO sce_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Bi tande shuhuajia kielieye, kien mii kielienyi chenliezhi mii peizhi ireghasan hhei xianxin giese chanqiku amin wine. Zui ulie soughane, fugukuse amitude ijin ireghawo.\" ");
INSERT INTO sce_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","\"Bi tande shuhuajia kielieye, shihou kuzhese fugusan kunla Kunnikewonni shenqii sonosune. Sonosusan kunla aminne olune. Ede hhe shihou enbene. ");
INSERT INTO sce_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ada benshenshi aminni genzi wo. Kewonneye aminni genzi gholughawo. ");
INSERT INTO sce_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Hheshi Kunnikewon wo. Ingiese Ada hhende kunlai panjiku qienlii ogiwo. ");
INSERT INTO sce_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ta ene shiqinde bu ghanira, shihou kuzhese mezai kunla man Kewonni shenqii sonosuse, ");
INSERT INTO sce_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","fuho giedene khizhene. Gouni giesanla chanqi amiturane, huaishi giesanlade zui jinjine.\" ");
INSERT INTO sce_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","\"Bi goyane kouizhi yama gie dane. Bi matui sonosuse matui panjine. Bi panjisanshi gundanni wo. Bi panjise goya isighalane ese giezho. Mii peizhi ireghasan hhei isighala giezho.\" ");
INSERT INTO sce_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","\"Bi goyadene ganzhen beise zoin ulie qiine. ");
INSERT INTO sce_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Da niekozi made ganzhen beizho. Hhe beisanshi zhenni bikui bi mejiene. ");
INSERT INTO sce_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ta melieshidase Yaheiyai hhende kun peizhi echighase Yaheiya zhendaode ganzhen beizho. ");
INSERT INTO sce_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Bi kunse ganzhen ulie kerenema, bi ene kielienyi kieliekushi tai jiuine giezho. ");
INSERT INTO sce_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yaheiyashi siderazhi gon faisan zhula niekielien wo. Ta zhanshi jiere hhei gonde xiqi woma, ");
INSERT INTO sce_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","made Yaheiyase da fugie ganzhen wine. Hheshi Adami mii onchengie giesan wilie wo. Ede bi giesan wilie enbene. Ene wiliela Adami mii peizhi ireghasande ganzhen beizho. ");
INSERT INTO sce_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Pse mii peizhi ireghasan Adami made ganzhen beizho. Ta hhei shenqiini chenliezhi uye daozho. Yanziini ye uzhezhi uye daozho. ");
INSERT INTO sce_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ada peizhi ireghasei ta xianxin ese giezho, ingiese hhei kielienyi ta zhughedene ese teizho.\" ");
INSERT INTO sce_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","\"Ta sumulase jinwunyi uzhezhi suruse hhe jierese chanqiku aminyi ereine giezhoma, jinwun zhen made ganzhen beizho. ");
INSERT INTO sce_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ingieliuzhe ta aminni mii enense ereile ulie irene.\" ");
INSERT INTO sce_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","\"Kun mii kuaikui bi ulie jienliene. ");
INSERT INTO sce_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Bi tai mejiene. Tande Hudade oreku zhughe uwo. ");
INSERT INTO sce_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Bi Adane niereghala irese ta ulie jienliene. Kunla goya niereghalane irese ta jienliene. ");
INSERT INTO sce_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ta nieniene kuaikui jienlienduzhoma, niekozi Hudase iresan kuaikui ulie ereine. Ingiese ta mii matui xianxin giene? ");
INSERT INTO sce_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Bi Adai melie tai zhane giezhi bu sumula. Tai zhakui da nie wine. Ta kouizhi xianxin giesan Musa tai zhane. ");
INSERT INTO sce_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ta Musai xianxin giese miiye xianxin giekui wo. Hhe huaisanshi mii zhiizhi kieliezho. ");
INSERT INTO sce_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Hhe huaisanyi ta xianxin ulie giese mii kielienyi matugie xianxin giene?\" ");
INSERT INTO sce_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Enense khuinashi ErsaJialilihaini daowo. Hhei Qibiliyahai giezhi ye uruzho. ");
INSERT INTO sce_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Tebieji olon kunla hhe gientulai goudaghasan ghudureqii uzhedene hhei daghazho. ");
INSERT INTO sce_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ersa ulade khirei tujilarene hhantu souwo. ");
INSERT INTO sce_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Hhe shihoude Yutai kunni Jiulidaosan Jie chadashizho. ");
INSERT INTO sce_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ersa qiorunne qila uzhese tebieji olon kunla hhei melie iresei chanladene Feilide kieliewo, \"Matan khalase imegheni ginan agizhi irezhi ene kunlade ijieghane?\" ");
INSERT INTO sce_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Hhe ingiezhi kieliese Feilii shiizho. Goyane matui giekui eqie mejiene. ");
INSERT INTO sce_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Feili kieliewo, \"200 gie miengughala ginan agise nie kunde goujinie ijiezhiye ulie kurune.\" ");
INSERT INTO sce_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Nie tujishi Ximun-Bedurui jiuni Andelie wo. Ersade kieliewo, ");
INSERT INTO sce_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","\"Enende nie ga kewon dunmaighala giesan tawun ginanji ghua zhaghasun bareizho. Imegheni kunlade yan gholune?\" ");
INSERT INTO sce_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ersa \"Dajialai sougha.\" giezhi kieliewo. Hhe oronde osun henshi kunla souwo. Gon ere kun sanase chabudu 5000 wine. ");
INSERT INTO sce_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ersa ginanyi barei Hudade mafan kieliedene sousan kunlade ghughazhi ogiwo. Zhaghasunyiye ingiezhi giedene kunlade ogiwo. Dajiala giedughonni ijiese giedughonni ogiwo. ");
INSERT INTO sce_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Hhela ijie chuduse Ersa tujiladene kieliewo, \"Feiliesei zaota bu giedene man shidolozhi agi.\" ");
INSERT INTO sce_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ingiese kunla ijiedene feiliesan tawun ginanni zhazhai shidolose 12 gie lanzi zhonlowo. ");
INSERT INTO sce_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ersa giesan ghudureqini uzhedene kunla kieliezho, \"Eneshi zhen duyade ireku hhe nie xienzhi enbene.\" ");
INSERT INTO sce_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Kunla iredene Ersai bareizhi biizhi honshan danlaghakui mejiedene Ersa niezheghanne pse ulade khireiwo. ");
INSERT INTO sce_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Khara oluse tujilani haibienzide bouwo. ");
INSERT INTO sce_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Chon jiere khireidene hai hhemienni Jiabainunde yozhi qiiwo. Khara oluzhoma, Ersa hhelai hhende dou ese irezho. ");
INSERT INTO sce_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Nie fugie kei feiliese hai jiere lan yebeiseye fugiedawo. ");
INSERT INTO sce_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tujila chonni huaizhi 10 jili yozho. Ingiekude hhela Ersa hai jiere yozhi chon shida iresei chujieghedene ayizho. ");
INSERT INTO sce_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ingiese Ersa kieliewo, \"Bi wo, bu ayi.\" ");
INSERT INTO sce_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ingiese hhela hende bayasudene Ersai jienliezhi chon jiere khise echiku orondene deigo kuruwo. ");
INSERT INTO sce_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Khuichudu hai duimiende beisan kunla hhende zi niekozi chon bikui mejiene, pse chon uwo. Ersa tujilarene chon jiere hhantu uye khiseiye mejiene. Tujilani goyane echizho. ");
INSERT INTO sce_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Pse giedun chon Qibiliyase Ezhan mafan kieliedene kunlade ginan ijieghasan hhe oron shida irewo. ");
INSERT INTO sce_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Kunla Ersa, tujilai chanla dase chon souzhi Jiabainunde Ersai ereile echiwo. ");
INSERT INTO sce_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Hhela hai duimiense Ersai ereizhi oludene kieliewo, \"Loushi, chi yan xienzide enende irewo?\" ");
INSERT INTO sce_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ersa kieliewo, \"Bi tande shuhuajia kielieye, ta mii ereile irese bi xienjighasan ghudureqide ese oluzho, ginanni ijiezhi chudusande oluzho. ");
INSERT INTO sce_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ta widaku ijiunide oluzhi wilie bu gie. Chanqiku amin wineku ijiunide oluzhi gie. Enei Kunnikewon tande ogine. Kunnikewonshi Huda Ada renjisan wo.\" ");
INSERT INTO sce_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ingiese hhela asawo, \"Bijien yan wilie giese Hudai wilie sanane?\" ");
INSERT INTO sce_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ersa kieliewo, \"Huda peizhi ireghasan hhei xianxin giese, hheshi Hudai wilie wo.\" ");
INSERT INTO sce_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Hhela pse kieliewo, \"Chi yan ghudureqi xienjighazhi bijienyi xianxin gieghane? Chi yan giene? ");
INSERT INTO sce_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Jinwun jiere, 'Asiman jierese hhe hhelade ginanyi ogizho.' giezhi huaisan mutun mai xienrenla hontande mana ijiewoma.\" ");
INSERT INTO sce_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ingiese Ersa kieliewo, \"Bi tande shuhuajia kielieye, asiman jierese tande ginanyi ogisanshi Musa pusho. Asiman jierese tande zhenzhenji ginan ogisanshi Adami wo. ");
INSERT INTO sce_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Hudai ginanshi asiman jierese bouzhesan hhe nie wo. Hhe duyani kunlade amin ogine.\" ");
INSERT INTO sce_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ingiese hhela kieliewo, \"Gujiu, chi imutu ginanyi bijiende chanqi ogi.\" ");
INSERT INTO sce_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ersa kieliewo, \"Bishi aminni ginan enbene. Mii enende iresan kunla ulie oliesune. Mii xianxin giese ibeizi ulie undasune. ");
INSERT INTO sce_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ingieliuzhe, bi kieliezhi daozhoma, ta mii chujiegheseye, xianxin ulie giene. ");
INSERT INTO sce_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Adami made ogisan kunla mii enende irene. Mii enende iresanlai bi jiedui ulie danlane. ");
INSERT INTO sce_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Bi asiman jierese bouzhese goya isighalane ulie giene. Mii peizhi ireghasan hhei isighala giene. ");
INSERT INTO sce_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Mii peizhi ireghasan hhei isishi made ogisan kunlai bi nieda ulie widaghazhi duya barakudeni aminne olughane giezho. ");
INSERT INTO sce_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Adaimi isishi Kewonyini uzhedene xianxin giesan kunlade man chanqiku aminyi ogine. Duya barakudeni bi hhelai aminne olughane.\" ");
INSERT INTO sce_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yutai kunla Ersa orunshi asiman jierese bouzhesan ginan wo giese hhei kieliendu qiiwo. ");
INSERT INTO sce_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Hhela kieliewo, \"Eneshi Yusufui kewon Ersa pushonu? Ana adaini matan tanine. Hhe matugie imutui kielien kieliene? Orunshi asiman jierese bouzhesan wo giezho?\" ");
INSERT INTO sce_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ersa kieliewo, \"Ta qingiezhi bu kieliendu. ");
INSERT INTO sce_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mii peizhi ireghasan Adami ulie ireghase mii enende kiemada ire dane. Mii enende iresanlai duya barakudeni bi hhei aminne olughane. ");
INSERT INTO sce_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Xienzhii shu jiere, 'Hhela man Hudase suruzho.' giezhi huaizho. Adase chenliezhi surusan kunla man mii enende irene. ");
INSERT INTO sce_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ene kielienshi kiema Adai chanlazhi daosan hhe isi pusho. Hudai hhense iresan hhense chugo kiemada Adai uzhezhi ese daozho. ");
INSERT INTO sce_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Bi shuhuajia kielieye, xianxin giesan kunde chanqiku amin wine. ");
INSERT INTO sce_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Bishi aminni ginan wo. ");
INSERT INTO sce_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tai xienren hontande manai ijieliuzhe fuguwo. ");
INSERT INTO sce_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Eneshi asiman jierese bouzhesan ginan wo. Kun ijiese ulie fugune. ");
INSERT INTO sce_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Bishi asiman jierese bouzhesan amin ogiku ginan wo. Kun ijiese chanqi amitu wo. Ene ginanshi mii migha wo, duyai kunlai aminde oluzhi ogizho.\" ");
INSERT INTO sce_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yutai kunla nieniedene jianjinduzho, \"Ene kun matugie mighane ogizhi ijieghane?\" ");
INSERT INTO sce_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ersa kieliewo, \"Bi shuhuajia kielieye, ta Kunnikewonyi mighai ulie ijiezhi chusunyi ulie ochise tai sudoro amin uwo. ");
INSERT INTO sce_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mii mighai ijiezhi chusunyi ochisan kunde chanqiku amin wine. Duya barakudeni bi hhei aminne olughane. ");
INSERT INTO sce_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Mighamishi zhenzhenji ijiuni wo, chusunmishi zhenzhenji ochikui wo. ");
INSERT INTO sce_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mighaimi ijiezhi chusunyimi ochisan kun mii sudoro beizho. Biye hhei sudoro beizho. ");
INSERT INTO sce_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mii peizhi ireghasan ulie fuguku Adai kouizhi bi amituku mutun mighaimi ijiesan kunla mii kouizhi amiturane. ");
INSERT INTO sce_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Eneshi asiman jierese bouzhesan ginan wo. Enei ijiesan kun chanqi amitu wo. Tai xienrenghala buxian wo, manai ijieliuzhe fuguwo.\" ");
INSERT INTO sce_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Enezighan kielienshi ErsaJiabainunni huitande kunlade sughazhi kieliesan wo. ");
INSERT INTO sce_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Tujilani hhei kielienyi sonosudene kieliewo, \"Ene kielien chijia wo. Kien dunjirene?\" ");
INSERT INTO sce_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ersa tujilani kieliendusei mejiedene hhelade kieliewo, \"Ene kielien tai zhughei gojiolughawu? ");
INSERT INTO sce_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Qingiese Kunnikewon yenlaiku orondene khikui chanlase ta matugie sumulane? ");
INSERT INTO sce_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Kunde amin ogikushi Shenlin wo, beye yama oronde uwo. Bi tande kieliesan kielienshi ruhher wo, aminye enbene. ");
INSERT INTO sce_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ingieseye tai dunda mii xianxin ese giesan kun wine.\" Ersa kaishi giekude kien hhei ghudandukuni mejiene. ");
INSERT INTO sce_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ersa pse kieliewo, \"Ene yenyin jiere bi tande kieliezhi daozho. Ada ulie ireghase kiemada mii enende ire dane.\" ");
INSERT INTO sce_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Enense khuinashi Ersai daghasan olon kunla yolazhi pse hhei ese daghawo. ");
INSERT INTO sce_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ingiese Ersa 12 gie tujidene kieliewo, \"Taye yolanu?\" ");
INSERT INTO sce_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ximun-Beduru kieliewo, \"Ezhan, chade chanqiku amin ogiku kielien wine. Bijien pse kienyi daghane? ");
INSERT INTO sce_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Bijien chishi Hudase iresan hhe zhiguitu bikui xianxin giezhi mejiezho.\" ");
INSERT INTO sce_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ersa kieliewo, \"Bi tai 12 giei sunghuwola? Tai dunda niekozishi Ibilisi wo.\" ");
INSERT INTO sce_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ersai ene kielienshi Jialie kun Ximunyi kewon Yudai kieliezho. Hheshi 12 gie tuji dundadu nie wo, khuinashi Ersai ghudandune. ");
INSERT INTO sce_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Enense khuinashi ErsaJialilide toreizho. Hhe Yudayade echiku duran uwo. Yutai kunla hhei alane giezho. ");
INSERT INTO sce_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Hhe shihoude Yutai kunlani Zhanfan Jie kuzhele qiiwo. ");
INSERT INTO sce_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ersai gaijiula hhende kieliewo, \"Chi enense likai giezhi Yudayade echi. Chi giesan wilielane tujiladene uzhegha. ");
INSERT INTO sce_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kun minshende khiku duran bise niuise ulie olune. Chi ene shiqinlai giene giese duyai kunlade man uzhegha.\" ");
INSERT INTO sce_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Yenlai gaijiulaniye hhei xianxin ese giezho. ");
INSERT INTO sce_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ingiese Ersa kieliewo, \"Ta giezhe echiliuzhe olune, mini shihou da uye kuzhezho. ");
INSERT INTO sce_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Duyani kunla tai ulie henjine, mii henjine. Duyai kunla giesanlashi doghun wo giezhi bi kieliese mii henjine. ");
INSERT INTO sce_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ta jieqi daoghale echi. Bi ede da ulie echine. Mini shihou da uye kuzhezho.\" ");
INSERT INTO sce_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ersa ene kielienyi kieliesenu Jialilide souzho. ");
INSERT INTO sce_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Hhei gaijiulani jieqi daoghale echikude Ersaye echiwo. Minminji ese echizho, ghulazhi echizho. ");
INSERT INTO sce_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Zhen jieqi daoghakudeni Yutai kunla Ersai ereizhi asazho, \"Hhe khala wine?\" ");
INSERT INTO sce_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Hhe xienzide kunla man Ersai kielienduzho. Ezighan kunla kieliese hheshi nie gou kun wo pse ezighan kunla kieliese hheshi nie pienzi wo giezho. ");
INSERT INTO sce_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ingieliuzhe Yutai kunse ayizhi Ersai minminji kiema kielie dane. ");
INSERT INTO sce_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Jieqi daoghazhi zhen dundani echikude Ersa mechide khizhi echidene kunlade sughazhi qiiwo. ");
INSERT INTO sce_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yutai kunla chenliesenu ghanirazhi kieliewo, \"Ene kun olon uye onshizho, matui imeghei mejiene?\" ");
INSERT INTO sce_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ingiese Ersa kieliewo. \"Bi sughasanshi minughun pusho. Mii peizhi ireghasan hhenughun wo. ");
INSERT INTO sce_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Hudai isii zunjizhi giesan kunshi bi sughasanshi Hudanughun onu minughun bikuni mejiene. ");
INSERT INTO sce_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Goya sumulasanne kieliechen kunshi goyane kuaichen kun wo. Peizhi ireghasan hheni kuaichen kunshi olusan kun wo, sudoroni yama gou wini uwo. ");
INSERT INTO sce_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Musa tande guijinni ogiwola? Kiema uye zunjizho. Ta yangiezhi mii alane giezho?\" ");
INSERT INTO sce_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Kunla kieliewo. \"Chii jiere sheitan wine. Chii kien alane giezho?\" ");
INSERT INTO sce_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ersa kieliewo, \"Bi niekozi wilie giese ta man ghanirazho. ");
INSERT INTO sce_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa chonjisan hetoune gieku guijinni ta hhamuraku udude ye giezho. Shijishan eneshi Musase kaishi giesan pusho, mai famatu xienrenlase kaishi giesan wo. ");
INSERT INTO sce_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ta Musai guijinyi ulie fanjine giezhi hhamuraku udude hetoune giene. Bi hhamuraku udude nie kunyi hunshenyi man goudaghase ta yangiezhi made hokune? ");
INSERT INTO sce_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ta kunni kieliese mienzini bu uzhe, gundande gie.\" ");
INSERT INTO sce_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yelusalenyi niezhan kunla kieliewo, \"Eneshi hhela alane giesan kun pushonu? ");
INSERT INTO sce_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Chi uzhe, hhe mindaminji jianjizho, hhela hhei yama ulie kieliene. Noyenla hheshi Mexiha bikui mejienu? ");
INSERT INTO sce_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ene kun khalase iresei matan mejiene. Mexiha irekude hhe khalase irekui kiema ulie mejiene.\" ");
INSERT INTO sce_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ingiekude Ersa mechide kunlade sughazhi fugiede kieliewo, \"Ta mii tanine. Bi khalase ireseiye mejiene. Shijishan bi goyane ese irezho. Mii peizhi ireghasanshi zhoni wo, ta hhei tani dane. ");
INSERT INTO sce_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Bi hhei tanine. Bishi hhense iresan wo. Hhe mii peizhi ireghazho.\" ");
INSERT INTO sce_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ingiese hhela Ersai bareine giezho. Shihouni ese kuse kiema kha tei dazho. ");
INSERT INTO sce_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Olon kunla hhei xianxin giedene kieliewo, \"Mexiha irese ene kunse ghudureqi olon xienjigha shidanu?\" ");
INSERT INTO sce_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Falisai kunla chenliese kunla Ersai kielienduzho. Ingiese fugie buwa, Falisai kunla mechini sagheisan kunlai peizhi Ersai bareighale echiwo. ");
INSERT INTO sce_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ingiese Ersa kieliewo, \"Bi tanrezhe hhantuku udu choghonshiwo. Bi ede mii peizhi ireghasan hhende echine. ");
INSERT INTO sce_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ta mii ereise ereizhi olu dane. Bi biku oronde ta ire dane.\" ");
INSERT INTO sce_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yutai kunla nieniedene asazhi kieliewo, \"Ene kun khala echinu? Matan ereizhi olu dane giene? Hhe niman gojiade sousan maikun dunda echinu, pse Xila kunlade surughale echinu? ");
INSERT INTO sce_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ta mii ereise ereizhi olu dane. Bi biku oronde ta ire dane giesan ene kielienshi yan isi wo?\" ");
INSERT INTO sce_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Jieqini zuihouku udu, zui zhunyoni udude Ersa beidene fugiede kieliewo, \"Kun undasuse mii enende ule ire. ");
INSERT INTO sce_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mii xianxin giesan kunde jinwun jiere kieliesan mutun 'Sudoroseni amitu usu moron mutun holune.'\" ");
INSERT INTO sce_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ersai ene kielienshi hhei xianxin giesan kunlade Shenlin ireghakui kieliezho. Hhe xienzide Ersade kuaikui ese ogizho. Ingiese kunlade Shenlin da ese irezho. ");
INSERT INTO sce_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ene kielienyi chenliedene niezhan kunla kieliewo, \"Eneshi zhen hhe xienzhi wo.\" ");
INSERT INTO sce_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Pse niezhan kunla kieliewo, \"Ene kunshi Mexiha wo.\" Pseshiku kunla kieliewo, \"Mexiha matugie Jialilise khizhene? ");
INSERT INTO sce_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Mexihashi Dawudei houdeise hhei aghin Bolihense khizhene giezhi jinwun jiere ese kieliewu?\" ");
INSERT INTO sce_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ingiese kunla Ersai ene shiqinde ghugha keiwo. ");
INSERT INTO sce_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Hhelai dundadu kunla Ersai bareine giezhoma, kiema kha tei dazho. ");
INSERT INTO sce_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Mechini sagheisan kunla khareizhi fugie buwa, Falisai kun shida irewo. Fugie buwa, Falisai kunla hhelade asawo, \"Ta yale hhei bareizhi ese irewo?\" ");
INSERT INTO sce_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Mechini sagheisan kunla kieliewo, \"Hhe kun mutun kielien kieliesan kun uwo!\" ");
INSERT INTO sce_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Falisai kunla kieliewo, \"Taye dan jiere khireiwu? ");
INSERT INTO sce_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Noyen, Falisai kun dunda hhei xianxin giesan kun nieda uwola? ");
INSERT INTO sce_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Enezighan Musai guijinni yama dunjire dasan kunlade gou widawo.\" ");
INSERT INTO sce_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Hhela dundadu nie kunshi Nigedemu wo. Melieshidase Ersai ochirale echizho. Hhelade kieliewo, ");
INSERT INTO sce_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","\"Xien hhe goyane kieliesan kielienyi ulie chenliezhi hhe giesanlai chaizhi qinchu ulie olutula mai guijinghala matugie hhende zui jinjine?\" ");
INSERT INTO sce_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Hhela kieliewo, \"Chiye Jialili kun onu? Chi echidene nie chaima, Jialilise xienzhi khizhenu ulie khizhene.\" ");
INSERT INTO sce_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ingiedene kunla man gieladene khareiwo. ");
INSERT INTO sce_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ErsaGanlanshande echiwo. ");
INSERT INTO sce_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Eqiemagha eqie mechide irewo. Olon kunla hhei shida irese hhe soudene sughazho. ");
INSERT INTO sce_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Jinwun hanjia, Falisai kunla nie bierei zhen kunlare kijiekude barei ire kunlai dunda beigha ");
INSERT INTO sce_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ersade kieliewo, \"Loushi, ene bierei zhen kunlare kijiekude barei irewo. ");
INSERT INTO sce_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Musani guijin jiere imutu biereii tashighala eghi ala giezhi fenfulazho. Chi kieliese matugiene?\" ");
INSERT INTO sce_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Hhela ene kielienyi kieliese Ersai shiizho. Ersade nie zui jinjidene zhane giezho. Ersa ghodeidene kha ghurunghalane zemin jiere urou huaizho. ");
INSERT INTO sce_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Hhela ulie beidene izhi asazho. Ersa bosizhedene kieliewo, \"Tai dunda kiende zui uwoshi xien tashii bareidene eghi.\" ");
INSERT INTO sce_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ingie pse ghodeidene zemin jiere urou huaizho. ");
INSERT INTO sce_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Hhela ene kielienyi chenliedene xien nasun fugienise nienieji yolawo. Zuihoude Ersa hhe biereighala feiliewo. ");
INSERT INTO sce_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ersa bosizhedene biereide kieliewo, \"Funi, hhela khala echiwo? Chade kiema zui ese jinjiwu?\" ");
INSERT INTO sce_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Bierei kieliewo, \"Gujiu, uye.\" Ersa kieliewo, \"Biye chade zui ulie jinjine. Chi echidene pse zui bu fanji.\" ");
INSERT INTO sce_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ersa pse kunlade kieliewo, \"Bishi duyani gon wo. Mii daghasan kunlade aminni gon wine, kharanide ulie yone.\" ");
INSERT INTO sce_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Falisai kunla kieliewo, \"Chi goyadene ganzhen beizho, chii ganzhen yama oronde uwo.\" ");
INSERT INTO sce_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ersa kieliewo, \"Bi goyane ganzhen beiliuzhe mii ganzhen oronde wine. Bi goyane khalase iresanne mejiene, khala echikuneye mejiene. Bi khalase iresanyi ta ulie mejiene, khala echikuiye ulie mejiene. ");
INSERT INTO sce_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ta kunni uzhedanghala panjinema, bi kiemai ulie panjine. ");
INSERT INTO sce_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Bi kunyi panjiliuzhe mii panjiku oronde wine. Bi niezheghanne pusho. Mii peizhi ireghasan Adaghalane hhantu wo. ");
INSERT INTO sce_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Tai guijin jiere, 'Ghua kun ganzhen beise zhenni wo.' giezhi huaizho. ");
INSERT INTO sce_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Bi goyadene ganzhen beizho, pse mii peizhi ireghasan adamiye made ganzhen beizho.\" ");
INSERT INTO sce_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ingiese hhela asazho, \"Adachii khala wo?\" Ersa kieliewo, \"Ta mii tani dane, adaimiye tani dane. Mii tanise adaimiye tanine.\" ");
INSERT INTO sce_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ene kielienshi Ersa mechini baer teiku kufan konde kunlade sughazhi kieliesan woma, hhei shihouni uye kuzhese kiemada hhei uye bareizho. ");
INSERT INTO sce_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ersa hhelade kieliewo, \"Bi echine. Ta mii ereinema, ta zui dunda fugune. Bi echiku oronde ta echi dane.\" ");
INSERT INTO sce_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ingiese Yutai kunla kieliewo, \"Hhe kieliese hhe echiku oronde matan echi dane giene. Hhe goyane fugune giezhou?\" ");
INSERT INTO sce_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ersa hhelade pse kieliewo, \"Tashi zemin jierese iresan wo, bishi asiman jierese iresan wo. Tashi duyadedu wo, bishi duyadedu pusho. ");
INSERT INTO sce_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ingiese ta zui dundane fugune giezhi bi kieliewo. Ta bishi hhe enbekui xianxin ulie giese zui dundane fugune.\" ");
INSERT INTO sce_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ingiese hhela asazho, \"Chishi kien wo?\" Ersa kieliewo, \"Bishi dei irekude tande kieliesan hhe nie wo. ");
INSERT INTO sce_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Bi tande kieliekui olon wo, zui jinjikuiye olon wo. Ingieliuzhe mii peizhi ireghasanshi zhenni wo, ingiese bi hhense chenliesanlai duyai kunlade kieliene.\" ");
INSERT INTO sce_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ersa Adane zhiizhi kieliesei hhela mejie dazho. ");
INSERT INTO sce_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ingiese Ersa kieliewo, \"Ta Kunnikewonyi qila qiighakude bishi hhe enbekui mejiene. Bi goya isighalane uye giezho, Adami sughasan mutun kieliesei ta mejiene. ");
INSERT INTO sce_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Mii peizhi ireghasan hhe mare hhantu wo. Hhe mii niezheghan ese jiezho. Bi chan hhei bayasughakui giezho.\" ");
INSERT INTO sce_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ersa ene kielienyi kieliedene olon kunla hhei xianxin giewo. ");
INSERT INTO sce_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ingiese Ersa hhei xianxin giesan Yutai kunlade kieliewo, \"Ta mii kielienyi chan zunjizhi giese mii zhenzhenji tuji wo. ");
INSERT INTO sce_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ta zhendaoni mejiene, zhendao tai ziyushighane.\" ");
INSERT INTO sce_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Hhela kieliewo, \"Bijienshi Iburaheimui houdei wo. Bijien kiemade hoji danlazhi ese daozho. Chi matui 'Bijienyi ziyushighane.' giezhi kieliene?\" ");
INSERT INTO sce_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ersa hhelade kieliewo, \"Bi shuhuajia kielieye, zui fanjisan kunshi zuini hoji wo. ");
INSERT INTO sce_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Hoji chanqi giede sou dane, kewon chanqi giede soune. ");
INSERT INTO sce_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ingiese Kewon tai ziyushighase ta zhenzhenji ziyushine. ");
INSERT INTO sce_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Tashi Iburaheimui houdei bikui bi mejiene. Mii kielien tai zhughede oro dase ta mii alane giezho. ");
INSERT INTO sce_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Bi Adane hhense chujieghesei kieliezho. Ta adane hhense chenliesei giezho.\" ");
INSERT INTO sce_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Hhela kieliewo, \"Bijienyi adashi Iburaheimu wo.\" Ersa kieliewo, \"Pusho, ta Iburaheimui houdeishi taye Iburaheimu giesan wilie mutun giene. ");
INSERT INTO sce_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Bi Hudai hhense chenliesan zhendaoi tande kieliese, ta mii alane giezho. Eneshi Iburaheimu gieku wilie pusho. ");
INSERT INTO sce_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ta giesan wilieshi zhen adatai giesan wilie wo.\" Ingiese hhela Ersade kieliewo, \"Bijienshi zagieda pusho. Bijiende niekozi ada wo, hheshi Huda wo.\" ");
INSERT INTO sce_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ersa kieliewo, \"Huda tai ada enbese ta made orene. Bishi Hudase tai enende iresan wo. Bi goyane iresan pusho, hhe mii peizhi ireghazho. ");
INSERT INTO sce_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Bi kieliesanlai ta yangiezhi minbai olu dane? Bi sughakui ta jieshou ulie giene. ");
INSERT INTO sce_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Tashi tai ada Ibilisise iresan wo. Adatai yan duralase ta yan giene. Hheshi dei qiisanse kun alachen wo. Ibeizi zhennide ulie beine. Zhughedeni zhenni uwo. Hheshi ghudanchi wo, ghudanchini touzi wo. Ingiese hhe ghudan kieliese hhei xinbin wo. ");
INSERT INTO sce_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ingiese bi zhendaoni kieliese ta mii xianxin ulie giene. ");
INSERT INTO sce_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Tai dunda kien made zui jinjine? Bi tande zhendaoni kieliese, ta yale mii xianxin ulie giene? ");
INSERT INTO sce_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Hudase khizhesan kunla Hudai kielienyi chenliene. Ta ulie chenliese Hudase khizhesei pusho.\" ");
INSERT INTO sce_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yutai kunla kieliewo, \"Bijien kieliese chishi Samaliya kun wo, chii jiere sheitan wo giesan ene kielien ese oluzhou?\" ");
INSERT INTO sce_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ersa kieliewo, \"Mii jiere sheitan uwo. Bi adane zunzhun giezho, ta mii zunzhun uye giezho. ");
INSERT INTO sce_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Bi goyane kuaikui ulie sumulanema, da niezhan mii kuaine. Hheshijiu panjichen wo. ");
INSERT INTO sce_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Bi shuhuajia kielieye, kien mii kielienyi chenliese hhe chanqi ulie fugune.\" ");
INSERT INTO sce_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ingiese Yutai kunla kieliewo, \"Ede bijien zhenzhen mejiewo! Chii jiere sheitan wine. Iburaheimu duya ijiewo, xienzhilaye duya ijiewo. Chi kieliese chii kielienyi chenliese chanqi ulie fugune giezho. ");
INSERT INTO sce_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Qinse chi bijienyi xienren Iburaheimuse pse fugie onu? Hhe duya ijiewo, xienzhilaye duya ijiewo. Chi goyane yan kun wo giezho?\" ");
INSERT INTO sce_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ersa kieliewo, \"Bi goyane kuaise hhe yama zoin uwo. Mii kuaisanshi Adami wo. Hheshijiu ta kieliesan mai huda wo giesan hhe wo. ");
INSERT INTO sce_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ta hhei tani dane, bi hhei tanine. Bi hhei tani dane giezhi kieliese ta mutun ghudanchi gholune. Ingiese bi hhei tanine, kielienyini ye chenliene. ");
INSERT INTO sce_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tai xienren Iburaheimu mii udui uzhene giezhi bayasuzhi sagheizho. Udui chanladene hende bayasuzho.\" ");
INSERT INTO sce_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yutai kunla kieliewo, \"Chii nasun 50 da ulie olune, matugie Iburaheimui uzhezhi daowo giezhi kieliene?\" ");
INSERT INTO sce_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ersa kieliewo, \"Bi tande shuhuajia kielieye, Iburaheimui ese olukudeni bi wine.\" ");
INSERT INTO sce_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ingiese hhela tashii bareisenu Ersai eghine giezho. Ersa piidene mechise khizhi echiwo. ");
INSERT INTO sce_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ersa mo yozhi daokudeni olusanse nie sughoi chanlawo. ");
INSERT INTO sce_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Tujilani Ersade asazho, \"Loushi, ene kun goya zui fanjizhi sugho gholuwu, ada anani zui fanjizhi sugho gholuwo?\" ");
INSERT INTO sce_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ersa kieliewo, \"Hhe zui fanjizhi gholusan pusho, ada anani zui fanjizhi gholusanye pusho. Eneshi hhei jierese Huda nenline kunlade mejieghane giezho. ");
INSERT INTO sce_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Udu bikude matan mii peizhi ireghasan hhei wiliei giekuni wo. Khara oluse kiemada wilie gie dane. ");
INSERT INTO sce_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Bi duyade bikude bishi duyani gon wo.\" ");
INSERT INTO sce_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ersa ene kielienyi kieliesenu zemin jiere nunpuwo. Nunpusunghala shuwa zhuwadene sughoni nudun jiere moiwo. ");
INSERT INTO sce_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ingie hhende kieliewo, \"Chi Xiloya loubade echidene nie wagha.\" Xiloyani isishi peizhi ireghasan wo. Hhe echi nie wagha kharei irese chujieghewo. ");
INSERT INTO sce_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Hhei giebeilane, hhe ghuisei chujieghesan kunla kieliewo, \"Eneshi melieshida soudene ghuisan hhe kun pushonu?\" ");
INSERT INTO sce_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ezighan kunla hhe enbene giezho. Psezighan kunla pusho, hhei xianli giezho. Hhe goyane bi enbene giezho. ");
INSERT INTO sce_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Hhela asazho, \"Chii nudun matui goudawo?\" ");
INSERT INTO sce_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Hhe kieliewo, \"Ersa giechen nie kun shuwa giedene mii nudun jiere moi made kieliewo, 'Chi Xiloya loubade echi nie wagha.' Bi echi nie waghase chujieghewo.\" ");
INSERT INTO sce_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Hhela asawo, \"Hhe kun khala wine?\" Hhe kieliewo, \"Bi ulie mejiene.\" ");
INSERT INTO sce_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Kunla melieshidaku sughoni udurusenu Falisai kunlai hhende echiwo. ");
INSERT INTO sce_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ersa shuwa zhuwazhi nudunyi goudaghasan hhe niudushi hhamuraku udu wo. ");
INSERT INTO sce_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ingiese Falisai kunla hhe kunde asazho, \"Chii nudun matui goudawo?\" Hhe kieliewo, \"Hhe shuwani mii nudun jiere moiwo. Bi nie waghase chujieghewo.\" ");
INSERT INTO sce_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Falisai kun dunda niezhan kunla kieliewo, \"Hheshi Hudase iresan kun pusho. Hhe hhamuraku uduiye uye zunjizho.\" Da niezhan kunla kieliewo, \"Nie zui winetu kun imutu ghudureqi gie shidanu?\" Ingie kunla ghugha keiwo. ");
INSERT INTO sce_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ingiese hhela pse sughode kieliewo, \"Hhe chii nudunyi goudaghazho. Chi nie kielie, hheshi nie matunie kun wo?\" Hhe kieliewo, \"Hheshi nie xienzhi wo.\" ");
INSERT INTO sce_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ingiese Yutai kunla hheshi melieshida sugho wo, ede goudasei xianxin ese giedene nudun goudasan kunyi ada anaini uruzhi ire asazho, ");
INSERT INTO sce_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","\"Eneshi olusanse sugho wo giesan tai kewon enbenu pusho? Ede matui chujieghewo?\" ");
INSERT INTO sce_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ada anani kieliewo, \"Eneshi bijienyi kewon enbene. Hhe olusanse sugho bikui bijien mejiene. ");
INSERT INTO sce_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ede matui chujieghewoshi bijien ulie mejiene. Nudunyini kien goudaghawoshi bijienye ulie mejiene. Ta hhende asa, hhe ede fugiedazho. Goyane kielie shidane.\" ");
INSERT INTO sce_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ada anani ingiezhi kieliekushi Yutai kunlase ayizho. Yutai kunla jiejin giezhi kien Ersashi Mexiha wo giezhi renjise huitanse tou khighane giezho. ");
INSERT INTO sce_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ingiese ada anani ta hhende asa, \"Hhe ede fugiedazho.\" giezhi kieliewo. ");
INSERT INTO sce_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ingiese hhela hhe sughoi erchan uruzhi iredene asazho, \"Chi indan Hudai kuaikui wo. Ene kunshi zuiren bikui bijien mejiene.\" ");
INSERT INTO sce_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ingiese hhe kun kieliewo, \"Hhende zui winu uwokui bi ulie mejienema, melieshi bi sugho wo, ede chujieghekune mejiene.\" ");
INSERT INTO sce_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ingiese hhela asazho, \"Hhe chade yan giewo? Hhe chii nudunyi matugie goudaghawo?\" ");
INSERT INTO sce_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Hhe kieliewo, \"Bi munigie tande kieliewo, ta ulie chenliene. Ta yangiezhi pse chenliene giezho? Taye hhei tuji danlane giezhou?\" ");
INSERT INTO sce_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Hhela sugiezhi kieliewo, \"Chishi hhei tuji wo, bijienshi Musai tuji wo. ");
INSERT INTO sce_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Huda Musade kieliesanyi bijien mejiene. Hhe kun khalase iresanyi bijien ulie mejiene.\" ");
INSERT INTO sce_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Hhe kun kieliewo, \"Hhe mii nudunyi goudaghawo. Hhe khalase iresanyi ta ulie mejienu? Ta zhenzhen hunnerei wo. ");
INSERT INTO sce_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Huda zuirenni kielienyi ulie chenliene. Zinie hhei zunjizhi kielienyini chenliesan kunnughunyi chenliene. Enei matan man mejiene. ");
INSERT INTO sce_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Duyai zhayaghasanse sughoi nudunyi goudaghasei chenliezhi uye daozho. ");
INSERT INTO sce_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Hhe kun Hudai hhense uye irezhoshi imutu wilie gie dane.\" ");
INSERT INTO sce_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Hhela kieliewo, \"Chii olusanse qienbu zui dunda wo, chi da bijiende sughanu!\" Ingiedene hhei tou khighawo. ");
INSERT INTO sce_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ersa hhe kunyi tou khighasanyi chenliedene hhei ereizhi oluwo. Ersa hhende kieliewo, \"Chi Kunnikewonni xianxin giezhou?\" ");
INSERT INTO sce_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Hhe kun kieliewo, \"Gujiu, hheshi kien wine? Bi xianxin gieye.\" ");
INSERT INTO sce_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ersa kieliewo, \"Chi hhei chujieghezho. Chare kielien kieliesanshi enbene.\" ");
INSERT INTO sce_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Hhe kieliewo, \"Gujiu, bi xianxin giene!\" Ingiesenu Ersade xiutuliewo. ");
INSERT INTO sce_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ersa kieliewo, \"Bi duyade panjile irewo. Chujieghe dachen kunlai chujiegheghane, chujieghechen kunlai sugho gholughane.\" ");
INSERT INTO sce_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Hhei shida ene kielienyi chenliesan ezighan Falisai kunla kieliewo, \"Qinse bijienye sugho onu?\" ");
INSERT INTO sce_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ersa hhelade kieliewo, \"Tashi sughoshi tande zui uwo. Ta, 'Chujieghe shidane.' giezhi kieliese tande zui wine.\" ");
INSERT INTO sce_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","\"Bi tande shuhuajia kielieye, kien ghoni khudonde orokude wijiense ulie orozhi pse khalamase orose hheshi ghughei, qiandao wo. ");
INSERT INTO sce_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Wijiense orosan kunshi zhen ghoni adulachen kun wo. ");
INSERT INTO sce_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ghoni adulachen kun irese wijienyi sagheisan kun wijienyi niene, ghonilaye hhei shenqii tanine. Hhe ghonine nierese uruzhi khizheghane. ");
INSERT INTO sce_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Man uruzhi khizhesenu goyane melie yone. Ghonila hhei shenqii tanise hhei daghane. ");
INSERT INTO sce_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ghonila tani daku kunyi ulie daghane. Hhei shenqii ulie mejiese holu widane.\" ");
INSERT INTO sce_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ersa enezighan kielienyi hhelade bilazhi kieliezho. Hhela yan isi bikui dunjire dane. ");
INSERT INTO sce_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ingiese Ersa hhelade pse kieliewo, \"Bi tande shuhuajia kielieye, bishi ghoni yoku wijien enbene. ");
INSERT INTO sce_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Mase melie iresanshi man ghughei, qiandao wo. Ghonila hhelai ese chenliewo. ");
INSERT INTO sce_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Bishi wijien wo. Mase tungo giezhi orosanlai jiui shidane, orozhi ire khizhi echise osun ijie shidane. ");
INSERT INTO sce_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ghughei irese ghulane, alane, qida olughane. Bi irese ghonilade amin ogine, da fugiede ogine. ");
INSERT INTO sce_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Bishi nie gou ghoni adulachen kun wo. Gou ghoni adulachen kun ghonide oluzhi aminne sheine. ");
INSERT INTO sce_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Guisan kunshi zhenzhenji ghoni adulachen pusho. Ghonishi hhenughun pusho. Zhanghei irekui chanlase ghonilai benda jie holu widane. Zhanghei ghonise nie bareise ghonila man sanda widane. ");
INSERT INTO sce_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Guisan kun ghonilade zhughe ulie chilane. Ingiese holu widane. ");
INSERT INTO sce_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Bishi gou ghoni adulachen wo. Bi ghonine tanine, mii ghonilaye mii tanine. ");
INSERT INTO sce_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Eneshi Adami mini taniku, bi Adane tanikughala niekielien wo. Bi ghonidene oluzhi aminne sheine. ");
INSERT INTO sce_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Made ene khudonde wiku ghoni da wine. Hhelaiye bi uduruzhi irene. Hhela mii shenqii sonosudene man hhantulazhi nie adulachen kun gonjine.\" ");
INSERT INTO sce_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","\"Bi aminne widaghadene pse agizhi irene. Ingiese Adami made orezho. ");
INSERT INTO sce_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mii aminyi kiema agizhi echi dane. Bi goyane ogisan wo. Bi aminne bendaku qienli wine. Pse agizhi ireku qienliye wine. Eneshi Adami made ogisan minlin wo.\" ");
INSERT INTO sce_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yutai kunla ene kieliende pse ghugha keiwo. ");
INSERT INTO sce_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Olon kunla kieliezho, \"Hhei jiere sheitan khizho, hhe fenjiulizho. Ta dou kielienyini chenliezhou?\" ");
INSERT INTO sce_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pse iban kunla kieliewo, \"Hhei jiere sheitan khise imutu kielien kielie dane. Sheitan sughoi goudagha shidanu?\" ");
INSERT INTO sce_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yelusalende mechii giesan jieqi kuzhewo. Eneshi unchade wo. ");
INSERT INTO sce_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ersa mechini Sulumane doudoughun yozho. ");
INSERT INTO sce_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yutai kunla hhei wiqidene kieliewo, \"Chi bijienyi giedoghoncha inxin gieghane? Chi Mexiha enbese mindamin kielie.\" ");
INSERT INTO sce_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ersa kieliewo, \"Bi tande ijin kieliewoma, ta mii xianxin ulie giene. Bi adane niereghala giesan shiqinla made ganzhen beine. ");
INSERT INTO sce_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ta mii ghoni pusho, ingiese mii xianxin ulie giene. ");
INSERT INTO sce_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mii ghoni mii shenqii chenliene, bi hhelai tanine, hhela mii daghane. ");
INSERT INTO sce_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Bi hhelade chanqiku amin ogine. Hhela ibeizi ulie widane, kiemada mii khase agizhi echi dane. ");
INSERT INTO sce_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Hhelai made ogisan Adami yanseliuzhe fugie wo. Adaimi khase hhelai kiemada qianlazhi echi dane. ");
INSERT INTO sce_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Bi Adaghalaneshi nie wo.\" ");
INSERT INTO sce_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yutai kunla pse tashii bareidene Ersai eghine giezho. ");
INSERT INTO sce_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ersa hhelade kieliewo, \"Bi Adane hhendedu gou wiliei giezhi tande uzheghazho. Ta alinie shiqinde mii eghine giezho?\" ");
INSERT INTO sce_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yutai kunla kieliewo, \"Gouni giewo giezhi eghine giesan pusho. Chi kufurei fanjizho. Chishi nie kun wo, goyane Huda giezhi kieliene.\" ");
INSERT INTO sce_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ersa kieliewo, \"Tai guijinshu jiere tashi huda wo giezhi bi kieliewo giezhi ese huaizhou? ");
INSERT INTO sce_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Jinwun jieredu kielien nieda ulie widane. Hudai kielienyi jienliesan kunlade huda giezhi kieliewoma, ");
INSERT INTO sce_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Adami mii zhiguishighadene duyade peizhi ireghase bi kieliezhi 'Bishi Hudai Kewon wo.' giese ta mii kufurei fanjiwo giezhi kielienu? ");
INSERT INTO sce_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Bi Adane wiliei ulie giese ta mii xianxin bu gie. ");
INSERT INTO sce_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Bi giese ta mii xianxin ulie gieliuzhe bi giesan shiqinlai xianxin gie. Ingiese Adami mii sudoro wo, bi Adane sudoro bikui ta qinchude mejiene.\" ");
INSERT INTO sce_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ingiese hhela Ersai pse bareine giese Ersa hhelai khase anda yolasenu ");
INSERT INTO sce_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yedanheni pse daozhi Yaheiya melieshida kunlade xili gieghasan hhe oronde echizhi souwo. ");
INSERT INTO sce_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Olon kunla hhei shida iredene kieliewo, \"Yaheiya yama ghudureqi uye giezhoma, hhe ene kunyi zhiizhi kieliesanshi man zhenni wo.\" ");
INSERT INTO sce_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ingiedene hhende olon kunla Ersai xianxin giewo. ");
INSERT INTO sce_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Nie giemeresan kunyi nierei Lasalu giene. Mereiyen, Mada ghua eghechijiularene Bodani aghinde souzho. ");
INSERT INTO sce_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ene Mereiyenshi Ezhanni jiere xianshui kiedene usunghalane konyini saisan hhe wo. Giemeresan Lasalushi hhei jiu wo. ");
INSERT INTO sce_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ghua eghechijiuni kun peizhi Ersade kielieghale echiwo, \"Ezhan, chi oresan kun giemerezho.\" ");
INSERT INTO sce_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ersa chenliedene kieliewo, \"Eneshi fuguku gien pusho. Hudai kuaiku shiqin wo. Ingiedene eneghala Hudai Kewonni kuaine.\" ");
INSERT INTO sce_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ingiese ErsaMada, hhei eghechijiu, pse Lasalude orezhoma, ");
INSERT INTO sce_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lasalu giemeresanyi sonosudene sousan orondene pse ghuarudu souwo. ");
INSERT INTO sce_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ingie tujiladene kieliewo, \"Matan pse Yudayade khareiye.\" ");
INSERT INTO sce_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Tujilani kieliewo, \"Loushi, ene ghuarudu Yutai kunla chii tashighala eghine giezho. Chi da hhende echinu?\" ");
INSERT INTO sce_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ersa kieliewo, \"Udu 12 gie xioshi pushonu? Kun ene duyani gonni chanlase udu mo yose ulie banjine. ");
INSERT INTO sce_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Xieni yose hhe kunde gon uwoshi banjine.\" ");
INSERT INTO sce_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ersa ene kielienyi kieliedene pse kieliewo, \"Mai zhanlien Lasalu hhunturazho. Bi echidene uruzhi xiereighane.\" ");
INSERT INTO sce_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ingiese tujilani kieliewo, \"Ezhan, hhe hhunturazhoshi goudane.\" ");
INSERT INTO sce_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ersai ene kielienshi hhe fugusei kieliezho. Hhela sumulase Ersai ene kielienshi hhe kijie hhunturazho giezho. ");
INSERT INTO sce_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ersa hhelade minminji kieliewo, \"Lasalu duya ijiezho. ");
INSERT INTO sce_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Bi hhende wise bi tande oluzhi bayasuzho. Ene jihui jiere ta mini xianxin giene. Ede matan hhende yoye.\" ");
INSERT INTO sce_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Shongo giezhi urusan Doma psedu tujilade kieliewo, \"Matanye yo, Ersare hhantu duya ijieye.\" ");
INSERT INTO sce_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ersa kuzhedene Lasalui mezade teizhi ijin jierudu olusanyi mejiewo. ");
INSERT INTO sce_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","BodaniYelusalense gholo uwo, chabudu 6 li mo wo. ");
INSERT INTO sce_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Olon Yutai kunla Mada, Mereiyenyi uzhele irewo. Jiunini shiqinde sidaghazhi kieliele irewo. ");
INSERT INTO sce_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","MadaErsa iresei mejiedene jienliele echiwo. Mereiyen yen giedene souzho. ");
INSERT INTO sce_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","MadaErsade kieliewo, \"Ezhan, chi enende wineshi jiumi ulie duya ijienema, ");
INSERT INTO sce_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","edeliuzhe chi Hudase yan kerese Huda chade ogikui bi mejiene.\" ");
INSERT INTO sce_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ersa kieliewo, \"Jiuchii aminne olune.\" ");
INSERT INTO sce_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mada kieliewo, \"Duya barazhi kunla fuho giekude hheye aminne olukui bi mejiene.\" ");
INSERT INTO sce_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ersa kieliewo, \"Bishi fuho wo, amin wo. Mini xianxin giesan kun fuguliuzhe aminne olune. ");
INSERT INTO sce_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Kun amitu bikude mii xianxin giese chanqi ulie fugune. Chi eneni xianxin gienu?\" ");
INSERT INTO sce_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mada kieliewo, \"Ezhan, oluzho. Chishi Mexiha wo, duyade irene giesan Hudai Kewon enbekui bi xianxin giene.\" ");
INSERT INTO sce_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mada ene kielienyi kieliedene khareizhi echi eghechijiu Mereiyende konkonji kieliewo, \"Loushi irewo. Chii uruzho.\" ");
INSERT INTO sce_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mereiyen chenliedene jindazhi bosizhe Ersai hhende echiwo. ");
INSERT INTO sce_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ersa aghinde orozhi ese echidene Mada hhei jienliesan hhe oronde wo. ");
INSERT INTO sce_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Hhezighan Mereiyenyi giede sidaghazhi kieliesan Yutai kunla Mereiyen bosizhedene jindazhi ghadane echisei chanlasenu daghazhi echiwo. Hhela sumulase Mereiyen mezade wilale echine giezho. ");
INSERT INTO sce_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","MereiyenErsai hhende kuzhi ire hhei chanladene kon shidai papala kieliewo, \"Ezhan, chi enende wineshi jiumi ulie duya ijiene.\" ");
INSERT INTO sce_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ersa hhe wilasei, pse hhei daghazhi iresan Yutai kunla wilasei chanladene zhughedene zhoqi giezhi nango giezho. ");
INSERT INTO sce_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Hhe asawo, \"Ta hhei khala teiwo?\" Hhela kieliewo, \"Ezhan, uzhele ire.\" ");
INSERT INTO sce_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ersa wilawo. ");
INSERT INTO sce_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ingiese Yutai kunla kieliewo, \"Ta uzhe, ene kun Lasalude matugiezhi orezho.\" ");
INSERT INTO sce_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Niezhan kunla kieliewo, \"Hhe sughoni nudunyi goudaghawoma, ene kunyi matugie ese goudaghazhi fugughawo?\" ");
INSERT INTO sce_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ersa pse sudorone zhoqi giezhi meza konde irewo. Hhe mezashi nie alima wo. Niekozi tashighala kouzii duighazho. ");
INSERT INTO sce_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ersa kieliewo, \"Tashii daogha.\" Ingiese duya ijiesan kunyi ajieni Mada hhende kieliewo, \"Ezhan, hhe duya ijiezhi jierudu olune. Ede fumugheishizho.\" ");
INSERT INTO sce_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ersa kieliewo, \"Chi xianxin giese Hudai famai chanlakuni bi chade kieliezhi ese daowu?\" ");
INSERT INTO sce_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ingiese hhela tashii daoghawo. Ersa qiorunne qila asimanni uzhedene kieliewo, \"Ada, chii mafan gieghawo. Chi minughunyi chenliewo. ");
INSERT INTO sce_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Chi chan minughunyi chenliekui bi mejiene. Bi ene kielienyi kieliese zhouwini beisan kunlade oluzho. Chi mii peizhi ireghasanyi hhelade xianxin gieghane giezho.\" ");
INSERT INTO sce_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ene kielienyi kieliedene fugiede waradawo, \"Lasalu, khizhe!\" ");
INSERT INTO sce_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ingiese fugusan kun khizhewo. Khakonyini bosighala horozho, ungienyini ye shoujinghala bouizho. Ersa hhelade kieliewo, \"Hhei andaghadene yogha.\" ");
INSERT INTO sce_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ingiese Mereiyenyi hhende iresan olon Yutai kunla Ersa giesan shiqinyi uzhedene hhei xianxin giewoma, ");
INSERT INTO sce_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","hhelai dunda niezhan kunla Falisai kunyi shida echidene Ersa giesan shiqinyi kieliewo. ");
INSERT INTO sce_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Fugie buwa, Falisai kunla goyane zui fugie fayenni kunlai hhantulagha kieliewo, \"Ene kun ghudureqi olon xienjighazho. Matan matugiene? ");
INSERT INTO sce_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Enei izhi ingiezhi gieghase kunla man hhei xianxin giene. Pse Loma kunla irese mai mechii, mai minzui widaghane.\" ");
INSERT INTO sce_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Hhelai dunda nie kunyi nierei Gaiyafa giene. Hhe niehonde zui fugie buwa danlazho. Hhelade kieliewo, \"Ta yama ulie mejiene! ");
INSERT INTO sce_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Hhe niezheghanne bexinlade oluzhi fuguse nie gojia man widakuse gou wo. Ene tande haochu bikui ta ulie mejienu?\" ");
INSERT INTO sce_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ene kielienshi goyane kieliesan pusho. Ene honku zui fugie buwa danlase ErsaYutai kunlade oluzhi fugukuni melie kieliezho. ");
INSERT INTO sce_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Zinie Yutai kunlade pusho, gochude sousan Hudai kesilai hhantulaghazhi nie gholughane giezhi fugukui kieliezho. ");
INSERT INTO sce_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Hhe uduse hhela shanlian giezhi Ersai alane giezho. ");
INSERT INTO sce_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ingiese Ersa pse Yutai kun dunda mindaminji uye ochirazho. Hhense likai giedene hontan shida Ifalien giezhi nie oronde echisenu tujighalane hhantu souwo. ");
INSERT INTO sce_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Yutai kunni Jiulidaosan Jie kuzhene giezho. Olon kunla xianlase Yelusalende eqie khizhi iresenu goyalane waghane giezho. ");
INSERT INTO sce_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Hhela Ersai ereizhi mechide beisenu nieniedene kieliewo, \"Ta uzhese matugiezho? Hhe jieqi daoghale ulie ireneba.\" ");
INSERT INTO sce_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Hhe shihoude fugie buwa, Falisai kunla eqie fenfula goudaghazho. \"Kien Ersa khala bikui mejiese mejiegha. Hhei bareine.\" ");
INSERT INTO sce_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Jiulidaosan Jieni melieshi zhighudude ErsaBodanide kuzhi irewo. Hheshi ErsaLasalui aminne olughasan oron wo. ");
INSERT INTO sce_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Kunla Ersade oluzhi heifan zhunbei giezho. Mada ushilazho. LasaluErsaghala kunlare hhantu souzho. ");
INSERT INTO sce_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mereiyen 1 jin zhen nadaghala giesan guizhuntu xianshuini agizhedene Ersai kon jiere kiesenu usunghalane saiwo. Giedera xianshui widao penjizho. ");
INSERT INTO sce_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ersai ghudandune giesan tuji Jialie kun Yuda kieliewo, ");
INSERT INTO sce_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","\"Ene xianshuini 300 gie miengu huidene nanxin kunlade oginema!\" ");
INSERT INTO sce_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Hhe ene kielienyi kieliekushi nanxin kunlade sumulasan pusho. Goyaneshi nie ghughei wo. Baer qibaoni hhe bareizho. Hhense baerni chan agizho. ");
INSERT INTO sce_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ingiese Ersa kieliewo, \"Bu danla, hhe ene xianshuii mii bulaku udude zhunbei giezho. ");
INSERT INTO sce_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Nanxin kunla tanre chan hhantu woma, bi tanre chan hhantu uwo.\" ");
INSERT INTO sce_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Olon Yutai kunla Ersa hhende bikui mejiedene uzhele irewo. Zinie Ersai uzhekui pusho. Fuguzhi aminne olusan Lasaluiye uzhene giezho. ");
INSERT INTO sce_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ingiese fugie buwala Lasaluiye alane giezhi shanlian giezho. ");
INSERT INTO sce_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ingiekushi Lasalui ene shiqin jiere olon Yutai kunla hhelai bendadene Ersai xianxin giezho. ");
INSERT INTO sce_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Khuichudu olon kunla jieqi daoghale iredene ErsaYelusalende irekui mejiewo. ");
INSERT INTO sce_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ingie zunshu mutun chalalai bareidene hhei jienliele echi fugiede waradazhi kieliewo, \"Hesanna! Ezhanni niereghala iresan Isilieni honshande doulandu!\" ");
INSERT INTO sce_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ersa nie ga enzheghei ereizhi olu unuwo. Jinwun jiere jilasan mutun, ");
INSERT INTO sce_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","\"Xiwunni kunla bu ayi. Uzhe, tai honshan ga enzheghe unuzhi irewo.\" ");
INSERT INTO sce_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Hhe xienzide tujilani ene shiqinyi minbai olu dazho. Ersa kuaikui jienliedene hhela ene kielienshi Ersai zhiizhi kieliesei, pse kunla hhende qingiezhi giesei sumula irewo. ");
INSERT INTO sce_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ErsaLasalui mezase waradazhi khizhedene aminne olughakude shidani beisan kunla hhe giesan shiqinyi kunlade izhi kieliezho. ");
INSERT INTO sce_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ingiese olon kunla Ersa xienjighasan ghudureqii mejiedene hhei jienliele echiwo. ");
INSERT INTO sce_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ingiese Falisai kunla nieniedene kieliewo, \"Matande yama banfa widawo. Duyai kunla man hhei dagha echiwo.\" ");
INSERT INTO sce_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Jieqide libai giele iresan kun dunda giedun Xila kun wo. ");
INSERT INTO sce_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Hhela Jialilini Bosaida kunni Feilini ochiradene xiahua giezhi kieliewo, \"Gujiu, bijien Ersai ochirale irewo.\" ");
INSERT INTO sce_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Feili echidene Andeliede kieliewo. AndelieFeili ghuala hhantu Ersade echi kieliewo. ");
INSERT INTO sce_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ingie Ersa kieliewo, \"Kunnikewonni kuaiku shihou kuzhewo. ");
INSERT INTO sce_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Bi tande shuhuajia kielieye, niekozi boudei fure ghazha jiere luidene ulie fuguse dou niekozi fure wo. Fuguse olon boudei osizhi khizhene. ");
INSERT INTO sce_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Goya amindene oresan kun aminne widaghane. Ene duyade aminne henjisan kun aminne chanqi bouine. ");
INSERT INTO sce_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mii ushilasan kun indan mii daghakuni wo. Bi khalashi mii ushilasan kun ye khala wo. Mii ushilasan kunyi Adami danren giene. ");
INSERT INTO sce_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ede mii zhughede nango giezho. Bi yan kieliese gou wo? 'Ada, mii ene shiqinse daogha.' giezhi kielienu? Ulie, bi zhen ene shiqinde irezho. ");
INSERT INTO sce_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ada, chi nierene famashigha!\" Hhe xienzide asiman jierese shenqi irezhi kieliewo, \"Bi ijin nierene famashighawo, pse famashighane.\" ");
INSERT INTO sce_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Shida beisan kunla sonosusenu kieliewo, \"Olien tunguliezho.\" Psedu kunla kieliewo, \"Qienxien hhende kielien kieliezho.\" ");
INSERT INTO sce_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ersa kieliewo, \"Ene shenqishi made oluzhi iresan pusho. Tande oluzhi iresan wo. ");
INSERT INTO sce_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ede duyani panjiku shihou kuzhewo. Ene duyani touzii tou khighane, jiushi Ibilisi wo. ");
INSERT INTO sce_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Mii zemin jierese qila qiighakude bi kunlai man xiidene shidane irene.\" ");
INSERT INTO sce_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ersai ene kielienshi goyane matugie fugukui zhiizhi kieliezho. ");
INSERT INTO sce_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ingiese kunla kieliewo, \"Bijien chenliese jinwunde kieliesanshi Mexiha ibeizi amitu wo giezho. Chi matugie 'Kunnikewonni qila qiighane.' giezhi kieliene? Chi kieliesan Kunnikewonshi kien wo?\" ");
INSERT INTO sce_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ersa kieliewo, \"Gon tai dunda oloncha widazho. Gon bikude ta gon dunda yodu. Pse kharani kuzhese tai khane. Kharanide yochen kun khala echikune ulie mejiene. ");
INSERT INTO sce_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Gon bikude ta gonni xianxin giezhi gonni kewosi danla.\" Ersa ene kielienyi kielie baragha likai giedene hhelase pii widawo. ");
INSERT INTO sce_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Hhelai melie Ersa ghudureqi olon xienjighazhoma, hhela hhei xianxin ulie giene. ");
INSERT INTO sce_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ingiese Isaiya xienzhi kieliesan kielien mutun gholuwo, \"Ezhan, bijienyi chonjisanyi kien xianxin giewo? Chii nenlii kiende xienjighane?\" ");
INSERT INTO sce_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Hhela xianxin ulie giekushi Isaiya pse kieliezho, ");
INSERT INTO sce_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","\"Ezhan hhelai nudunyini sugho gholughazhi zhugheini khiduzheghakushi Hhela nudundene chanlazhi zhughedene minbai olusenu kharei daorese Bi hhelai goudaghakuse ayizho.\" ");
INSERT INTO sce_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","IsaiyaErsai famani chanladene hhei zhiizhi ene kielienyi kieliesan wo. ");
INSERT INTO sce_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ingieliuzhe Yutai kunni noyen dundaye hhei xianxin giesan kun olon wo, Falisai kunla huitanse tou khighakuse ayizhi chenren gie dazho. ");
INSERT INTO sce_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Hhela kunni kuaikui Hudai kuaikuse xiqi wo. ");
INSERT INTO sce_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ersa fugiede kieliewo, \"Kunla mii xianxin giese zinie mii xianxin giesan pusho, mii peizhi ireghasan hhei xianxin giezho. ");
INSERT INTO sce_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Kunla mii chujieghese mii peizhi ireghasanyi chujieghezho. ");
INSERT INTO sce_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Bi duyade irese duyani gon wo. Mii xianxin giesan kunlai bi kharanide ulie soughane. ");
INSERT INTO sce_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Mii kielienyi sonosudene ulie giechen kunyi bi ulie panjine. Bi duyade irese duyai panjile ese irezho, jiuile irezho. ");
INSERT INTO sce_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mii ulie kerechen, kielienyimi ulie jienliechen kunni panjiku wine. Bi kieliesan kielien duya barakude hhei panjine. ");
INSERT INTO sce_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Bi kieliesanshi goyane sumulazhi kieliesan pusho. Mii peizhi ireghasan Adami made minlin ogizhi mii yan kielieghase bi yan kieliezho. ");
INSERT INTO sce_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Adaimi minlinshi chanqiku amin bikui bi mejiene. Ingiese bi zinie Adami made kielieghakuni kieliene.\" ");
INSERT INTO sce_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Jiulidaosan Jieni melieshida Ersa duyase likai giezhi Adane hhende echiku shihou kurukui mejiewo. Hhe ene duyani goya kunladene orezhi zuihou kurutula izhi orezho. ");
INSERT INTO sce_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Heifan ijiekude Ibilisi Jialie kun Ximunyi kewon Yudai zhughede Ersai ghudandukui melieshise gie goudaghazho. ");
INSERT INTO sce_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ersa Adani duyani qienlii hhei khade jiuisanyi, goyaneshi Hudai hhense iresanyi, pse Hudai hhende echikui mejiene. ");
INSERT INTO sce_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ingie Ersa shire konse bosi ire jienne tei, kanzidene nie shoujinyi banla, ");
INSERT INTO sce_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","nie nienpen usui kiezhi ire, tujilane konyi waghasenu kanzidene banlasan shoujinghala caizhi ghoghawo. ");
INSERT INTO sce_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Waghazhi Ximun-Bedurude kuzhese BeduruErsade kieliewo, \"Ezhan, chi mini konni waghanu?\" ");
INSERT INTO sce_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ersa kieliewo, \"Bi giesanyi ede chi ulie mejienema, khuinashi mejiene.\" ");
INSERT INTO sce_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Beduru kieliewo, \"Chi mini konni jiedui waghazhi ulie olune.\" Ersa kieliewo, \"Bi chii ulie waghase bi jienliesan guzide chi bei dane.\" ");
INSERT INTO sce_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ximun-Beduru kieliewo, \"Ezhan, qinse gon konyimi bu wagha. Kha, qiorunyimi man wagha.\" ");
INSERT INTO sce_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ersa kieliewo, \"Xizao giezhi daosan kun zinie konne waghase hunshenni man ganjin wo. Tashi ganjinni woma, manshi ganjinni pusho.\" ");
INSERT INTO sce_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ersa kien hhei ghudandukui melieshise mejiene. Ingiese \"Tashi man ganjinni pusho.\" giezhi kieliewo. ");
INSERT INTO sce_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ersa hhelai konni waghazhi balu, jienne musidene pse souwo. Ingie hhelade kieliewo, \"Bi tande giesanyi ta dunjirewoye? ");
INSERT INTO sce_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ta mini loushi, ezhan giezhi uruzho. Ta urusan oluzho. Bi enbene. ");
INSERT INTO sce_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Bishi tai ezhan, loushi woma, tai konni waghawo. Taye nieniene konyi wagha. ");
INSERT INTO sce_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Bi tande nie yanzi uzheghawo. Ta ye zhao bi tande giesan mutun giendu. ");
INSERT INTO sce_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Bi tande shuhuajia kielieye, hoji ezhanse fugie uwo. Peizhi ireghasan kun peisan kunse fugie uwo. ");
INSERT INTO sce_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Enei ta mejienema, ta ingiezhi giese tande fuqi wine. ");
INSERT INTO sce_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Mini ene kielienshi ta manlai zhiizhi kieliesan pusho. Bi goyane kienyi sunghusei mejiene. Ingieliuzhe jinwun jieredu kielien bixi gholune, 'Mare hhantu ginan ijiesan kun konghalane mii qiuine.' ");
INSERT INTO sce_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ede shiqin da uye chenjikude bi tande xien kieliekushi shihou kuruse bishi hhe enbekui tai xianxin gieghane giezho. ");
INSERT INTO sce_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Bi tande shuhuajia kielieye, kun bi peisan kunlai jienliese mii jienliezho. Mii jienliese mii peizhi ireghasan hhei jienliezho.\" ");
INSERT INTO sce_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ersa ene kielienyi kieliesenu zhughedene nango giezhi minminji kieliewo, \"Bi tande shuhuajia kielieye, tai dunda nie kun mii ghudandune.\" ");
INSERT INTO sce_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tujilani nieniene uzhezhi hhe kienyi kieliesei mejie dazho. ");
INSERT INTO sce_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tujilani dunda niekozishi Ersa oresan wo. Hhe Ersai kanzide souzho. ");
INSERT INTO sce_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ximun-Beduru hhe nie tujide qiorun jienjizhi, \"Ezhan kienyi kieliezho?\" giezhi asaghawo. ");
INSERT INTO sce_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Hhe nie tuji Ersai kanzii shighadene asazho, \"Ezhan, kien wine?\" ");
INSERT INTO sce_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ersa kieliewo, \"Bi goujinie ginanyi zhanjizhi kiende ogise hhe enbene.\" Ingiedene Ersa goujinie ginanyi zhanjisenu Jialie kun Ximunni kewon Yudade ogiwo. ");
INSERT INTO sce_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Hhe jienliese Ibilisi hhei sudoro orowo. Ingiese Ersa hhende kieliewo, \"Chi giekune ghujighan gie.\" ");
INSERT INTO sce_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Shire konde hhantu sousan kunla hhende kieliesan ene kielienyi kiemada dunjire dawo. ");
INSERT INTO sce_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kunla sumulase Yuda baerni bareizho, Ersa hhende kieliesanshi hhe matande jieqi daoghaku dunxi agile echi giezho. Pse jiahui kunlade yama khugho giezho. ");
INSERT INTO sce_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yuda hhe ginanyi jienliedene deigo ghadane khizhi echiwo. Hhe xienzishi xieni wo. ");
INSERT INTO sce_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yuda khizhi echisenu Ersa kieliewo, \"Ede Kunnikewonni kuaiku kuzhewo. Kunnikewonni tungo giezhi Hudaiye kuaiwo. ");
INSERT INTO sce_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Huda Kunnikewonni tungo giezhi goyane kuaikui jienliese hheye goyai tungo giezhi Kunnikewonni kuaine. Ede kuaiku ghujinlazho. ");
INSERT INTO sce_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Kesila, bi tanre hhantu biku shihou oloncha widazho. Khuinashi ta mii ereinema, bi echiku oronde ta echi dane. Ene kielienyi bi melieshi Yutai kunlade kieliezhi daozho. Ede tandeye ingiezhi kielieye. ");
INSERT INTO sce_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Bi tande nie shini minlin ogiye, ta nieniedene orendu. Bi tande oresan mutun taye qingiezhi nieniedene orendu. ");
INSERT INTO sce_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ta nieniedene orese tashi mini tuji bikui kunla mejiene.\" ");
INSERT INTO sce_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ximun-BeduruErsade asawo, \"Ezhan, chi khala echine?\" Ersa kieliewo, \"Bi echiku oronde chi ede echi dane. Khuinashi chi mii daghazhi echine.\" ");
INSERT INTO sce_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Beduru kieliewo, \"Ezhan, bi ede yale echizhi ulie olune? Bi chade aminne sheine.\" ");
INSERT INTO sce_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ersa kieliewo, \"Chi made aminne sheinu? Bi chade shuhuajia kielieye, tigha kheilatula chi mii 3 hui ulie renjine.\" ");
INSERT INTO sce_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","\"Ta zhughedene nango bu gie. Ta Hudai xianxin gie, miiye xianxin gie. ");
INSERT INTO sce_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Adaimi giede souku oron olon wo. Uwoshi bi tande eqie kieliene. Bi echise tande oron zhunbei giele echine. ");
INSERT INTO sce_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Bi echi tande oron zhunbei giedene pse ire tai hhende jienlie echine. Ingiese bi khalashi taye khala wo. ");
INSERT INTO sce_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Bi echiku hhe moni ta mejiene.\" ");
INSERT INTO sce_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","DomaErsade kieliewo, \"Ezhan, chi khala echikui bijien ulie mejiene. Hhe moni bijien matui mejiene?\" ");
INSERT INTO sce_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ersa kieliewo, \"Bishijiu mo wo, zhendao wo, amin wo. Mase tungo ulie giese kiemada Adai hhende echi dane. ");
INSERT INTO sce_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ta mii tanise Adaimiye taniwo. Enedu khuinashi ta hhei taniwo, ye chujieghewo.\" ");
INSERT INTO sce_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","FeiliErsade kieliewo, \"Ezhan, bijiende Adai nie uzheghama, bijiende kuruwo.\" ");
INSERT INTO sce_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ersa kieliewo, \"Feili, bi tanre hhantu imeghenicha oluzho. Chi da mii tani dazhou? Kun mii chujieghese Adaimi chujieghezho. Chi matugie 'Adai bijiende uzhegha.' giezhi kieliene? ");
INSERT INTO sce_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Bi Adai sudoro wo, Ada mii sudoro bikui chi xianxin ulie gienu? Bi tande kieliesan kielienshi bi goyane kieliesan pusho. Mii sudoro sousan Adami goya wiliene giezho. ");
INSERT INTO sce_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Bi Adai sudoro wo, Ada mini sudoro wo giesan ene kielienyi ta xianxin gie. Xianxin gie dase bi giesan wilielani uzhedene xianxin gie. ");
INSERT INTO sce_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Bi tande shuhuajia kielieye, ede bi Adai hhende echine. Ingiese mii xianxin giesan kunla bi giesan wilielaiye gie shidane. Da enense fugie wiliei giene. ");
INSERT INTO sce_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ta mini niereghala yan xiahua giese bi tande yan gholughane. Ingiese Ada Kewonne jierese kuaikui jienliene. ");
INSERT INTO sce_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ta mini niereghala mase yan xiahua giese bi yan gholughane.\" ");
INSERT INTO sce_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","\"Ta made orese mini minlinni zunji. ");
INSERT INTO sce_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Bi Adasene xiahua giezhi tande da nie banjichen ireghaye. Hhe tanre chan hhantula gie. ");
INSERT INTO sce_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Eneshi zhendaoni ruhher wo. Duyani kunla hhei chujieghe dane, taniye dane. Ingiese hhei jienlie dane. Ta hhei tani shidane. Hhe tanre hhantu souzho, tai sudoro wine. ");
INSERT INTO sce_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Bi tai oliechen mutun bendazhi ulie jiene. Bi da tai shida irene. ");
INSERT INTO sce_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Pse goujicha beise duyani kunla mini chujieghe danema, ta mini chujieghene. Bi amitu wo, taye amitu wo. ");
INSERT INTO sce_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Hhe niudu kuse bi Adai sudoro wo, ta mii sudoro wo, biye tai sudoro bikui ta mejiene. ");
INSERT INTO sce_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Kien mini minlinyi jienliezhi zunjise made orezho. Made orese Adamiye hhende orene. Biye hhende orezhi goyane xienjighane.\" ");
INSERT INTO sce_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","YudaErsade asazho (Ene Yudashi Jialie kun Yuda pusho), \"Ezhan, chi bijiende xienjighane, duyani kunlade yale ulie xienjighane?\" ");
INSERT INTO sce_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ersa kieliewo, \"Kun made orese mini kielienyi zunjine. Adamiye hhende orene. Bi Adaghalane hhei hhende echidene hhantu soune. ");
INSERT INTO sce_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Made ulie orechen kun mini kielienyi ulie zunjine. Ta sonosusan kielienshi minughun pusho, mini peizhi ireghasan Adaimi kielien wo.\" ");
INSERT INTO sce_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","\"Ene kielienlai bi tanre hhantu bikude tande kieliewo. ");
INSERT INTO sce_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Banjichen giezhi urusan Shenlin irese shiqinlai man tande surughane, bi tande kieliesan kielienlai man sumula ireghane. Hheshi Ada mini niereghala peizhi ireghasan wo. ");
INSERT INTO sce_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Bi tande pinnan ogiye. Goya pinnanne tande ogiye. Bi ogisan pinnanshi duyani kunla ogisan pinnanyi buxian wo. Ta zhughedene munan bu gie, ye bu ayi. ");
INSERT INTO sce_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Bi yolane, pse tai enende irene giesan ene kielienyi ta chenliezhi daozho. Ta made orese bi Adai hhende echise ta bayasune. Ada mase fugie wo. ");
INSERT INTO sce_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ede shiqinla da uye gholukude bi xien tande kieliewo. Ingiezhi giese shiqin gholukudeni tai xianxin gieghane giezho.\" ");
INSERT INTO sce_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","\"Ene duyani touzi ede irewo. Ingiese bi tanre kielien kielieku shihou oloncha widazho. Hhe mini yama gie danema, ");
INSERT INTO sce_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ingieliuzhe bi Adadene oresei, pse Adami made matugiezhi fenfulase bi qingiezhi giesei duyani kunlade mejieghane. Bosizhe! Matan yoye.\" ");
INSERT INTO sce_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","\"Bishi zhen putou mutun wo. Adamishi zeilasan kun wo. ");
INSERT INTO sce_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Hhe mii jiere alima ulie sousan chalai man ghigha widaghane. Alima souku chalai ulou giezhi goudaghase hhei jiere alima pse olon soughane. ");
INSERT INTO sce_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ta bi jianjisan kielienghala ijin ganjinshiwo. ");
INSERT INTO sce_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ta mii sudoro bei. Biye tai sudoro beine. Chala mutun jiere uwoshi goyane alima sou dane. Ta mii sudoro ulie beiseye niekielien wo. ");
INSERT INTO sce_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Bishi putou mutun wo. Tashi chala wo. Kien mii sudoro beizhi bi hhei sudoro beise hhe alima olon soune. Mase likai giese ta yama gie dane. ");
INSERT INTO sce_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kun mini sudoro ulie beise bendadene ghosan chala niekielien wo. Kunla hhei qianguzhi echise khande tulie widaghane. ");
INSERT INTO sce_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ta mini sudoro beizhi mini kielien tai sudoro beise ta yan xiahua giezhi kerese tande man gholughane. ");
INSERT INTO sce_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ta alima olon souzhi mini tuji gholuse Adademi kuaiku irene. ");
INSERT INTO sce_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Adami made oreku mutun biye tande orezho. Ta mini oreku sudoro bei. ");
INSERT INTO sce_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ta mii minlinyi zunjise mii oreku sudoro beizho. Eneshi bi Adane minlinyi zunjizhi hhei oreku sudoro beikughala niekielien wo.\" ");
INSERT INTO sce_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","\"Bi enezighan kielienyi tande kieliese mii bayasukughala tai bayasughane. Tai fugiede bayasughane. ");
INSERT INTO sce_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Bi tande oreku mutun ta nieniedene orendu. Eneshi mini minlin wo. ");
INSERT INTO sce_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kun zhanliendene aminne sheise, ene orekuse fugieni uwo. ");
INSERT INTO sce_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Bi fenfulasan minlinyi ta zunjise tashi mini zhanlien wo. ");
INSERT INTO sce_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Bi tai pse hoji giezhi ulie urune. Ezhanyi wiliei hojila ulie mejiene. Bi tai zhanlien danlaghazho. Bi Adane hhense chenliezhi iresanlai tande man mejieghawo. ");
INSERT INTO sce_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ta mini sunghusan pusho, bi tai sunghusan wo. Bi tai peizhi chanqiku alimai soughale echiwo. Ingiese ta mini niereghala yan xiahua giese Adami tande ogine. ");
INSERT INTO sce_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ta nieniedene orendu. Eneshi mini minlin wo.\" ");
INSERT INTO sce_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","\"Duyai kunla tai henjise ta mejiendu. Mii tanse melieshi henjizho. ");
INSERT INTO sce_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ta duyaghunshi duyani kunla tande orenema, ta duyaghun pusho. Bi tai duyase sunghuwo. Ingiese duya tai henjine. ");
INSERT INTO sce_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Hoji ezhanse fugie uwo giezhi bi tande kieliesan ene kielienyi jila. Hhela mini heise taiye heine. Hhela mii kielienyi zunjizhi giese tai kielienyiye zunjizhi giene. ");
INSERT INTO sce_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Hhela mini yenyinghala tande ingiezhi giezho. Hhela mini peizhi ireghasan Hhei tani dazho. ");
INSERT INTO sce_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Bi irezhi hhelade uye kieliezhoshi hhelade zui uwo. Ede hhelade zui uwo giezhi kielie dane. ");
INSERT INTO sce_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Mini henjise Adaimiye henjizho. ");
INSERT INTO sce_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Bi hhelai dunda kiema gie dasei ese giezhoshi hhelade zui uwoma, ede hhela bi adamighalai chanladene henjizho. ");
INSERT INTO sce_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ene hhelai jinwun jiere huaisan kielien mutun gholuwo, 'Hhela mii uyenwuguji henjizho.'\" ");
INSERT INTO sce_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","\"Bi Adane hhense banjichenyi peizhi ireghane. Hheshi Adai hhense iresan zhendaoni ruhher wo. Hhe irese made ganzhen beine. ");
INSERT INTO sce_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Taye made ganzhen beine. Ta kaishi giesanse izhi bighala hhantu wo.\" ");
INSERT INTO sce_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","\"Bi tande enezighan shiqinyi kieliese tai zhughei ulie gojiolughane giezho. ");
INSERT INTO sce_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Kunla tai huitanse tou khighane. Shihou kuzhese tai alachen kunla ingiezhi giese Hudai shunjizho giezhi sumulane. ");
INSERT INTO sce_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Hhela ingiezhi giekushi Adai tani dane, miiye tani dane. ");
INSERT INTO sce_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Bi enezighan shiqinyi tande kieliekushi shihou kuzhese bi tande kieliezhi daosanyi sumulazhi ireghane giezho. Melieshi bi tanre hhantushi ene shiqinyi tande ese kieliezho.\" ");
INSERT INTO sce_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","\"Ede bi mini peizhi ireghasan Adai hhende echinema, tai dunda chi khala echine giezhi made asachen kun nieda uwo. ");
INSERT INTO sce_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kharei bi enezighan shiqinyi tande kieliese ta zhughedene hende nango giezho. ");
INSERT INTO sce_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Bi tande shuhua kielieye, bi echise tande kharei gou wo. Bi ulie echise banjichen tai enende ulie irene. Bi echise hhei tande peizhi ireghane. ");
INSERT INTO sce_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Hhe irese zui fanmiende, gundanni fanmiende, panjiku fanmiende duyani codasei kheilane. ");
INSERT INTO sce_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Zuini fanmiende kieliekushi hhela mini xianxin ese giewo. ");
INSERT INTO sce_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Gundanni fanmiende kieliekushi bi Adai hhende echise ta mini chanla dane. ");
INSERT INTO sce_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Panjikuni fanmiende kieliekushi ene duyani touzini ijin panjiwo.\" ");
INSERT INTO sce_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","\"Bi tande kielieku shiqin da olon woma, ta ede jienlie dane. ");
INSERT INTO sce_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Zhendaoni ruhher irese tai uduruzhi soyuji zhendaode echighane. Hhe kieliesanshi goyane sumulasan pusho. Hhe chenliesanlane tande kieliene. Khuinashiku shiqinlaiye tande mejieghane. ");
INSERT INTO sce_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Hhe mase chenliesanlane man tande kieliezhi ogine. Ingiese made kuaiku irene. ");
INSERT INTO sce_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Adaghunshi man minughun wo. Ingiese hhe mase chenliesanlane man tande kieliezhi ogine giezhi bi kieliewo.\" ");
INSERT INTO sce_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","\"Goujicha beise ta mini chujieghe dane. Pse goujicha beise ta mini chujieghene.\" ");
INSERT INTO sce_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ingiese giedun tujila nieniedene kieliezho, \"Hhe matande yan kieliezho? 'Goujicha beise matan hhei chujieghe dane. Pse goujicha beise matan hhei chujieghene.' Da bi Adai hhende echine giesan eneshi yan isi wo?\" ");
INSERT INTO sce_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Pse kieliezho, \"Hhe kieliesan goujichashi yan isi wo? Matan hhe kieliesan kielienyi dunjire dawo.\" ");
INSERT INTO sce_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ersa hhela asane giesei mejiedene kieliewo, \"Bi kieliesan goujicha beise ta mini pse chujieghe dane, pse goujicha beise ta mini chujieghene giesan ene kielienghala ta nieniedene asaduzhou? ");
INSERT INTO sce_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Bi tande shuhuajia kielieye, ta nango giezhi hende wilane, duyani kunla bayasune. Ta nango gienema, tai nango bayasukui gholune. ");
INSERT INTO sce_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Biereila oluku shihou kuzhese munan giene. Hhe kewosini oluse otusanlai mata widaghane. Hhe duyade nie kewosi oluse hende bayasune. ");
INSERT INTO sce_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ta ede munan giezhoma, bi tai pse chujieghene. Qingiese ta bayasune. Ene bayasukui kiemada agizhi echi dane. ");
INSERT INTO sce_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Hhe niudu kuse ta made yama ulie asane. Bi tande shuhuajia kielieye, ta mini niereghala yan xiahua giese Adami tande ogine. ");
INSERT INTO sce_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Eli kutula ta mini niereghala yama xiahua uye giewo. Ta xiahua gie, tande ogine. Ta hende bayasune.\" ");
INSERT INTO sce_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","\"Ene kielienlai bi tande bilazhi kieliewo. Shihou kuzhese bi pse tande bilazhi ulie kieliene. Adai shiqinyi tande mindaminji kieliezhi ogine. ");
INSERT INTO sce_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Hhe niudude ta mini niereghala xiahua giene. Eneshi bi tande oluzhi Adade xiahua gieku isi pusho. ");
INSERT INTO sce_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ta made orezho, pse bishi Adai hhense ireseiye xianxin giezho. Ingiese Ada goyane tande orezho. ");
INSERT INTO sce_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Bi Adai hhense khizhezhi duyade irewo. Pse duyase likai giezhi Adai hhende echine.\" ");
INSERT INTO sce_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tujila kieliewo, \"Ede chi mindaminji kieliezho, bilazhi uye kieliezho. ");
INSERT INTO sce_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Chi yanniliuzhe mejiekui bijien ede mejiene. Kunla chade asaku biyoye uwo. Eneghala bijien chishi Hudai hhense iresei xianxin giezho.\" ");
INSERT INTO sce_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ersa kieliewo, \"Ta ede xianxin giezhou? ");
INSERT INTO sce_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Uzhe, ta sandazhi goya oronladene echiku shihou kuzhene, shijishan ede kuzhewo. Ta mini niezheghan benda jiene. Bi niezheghanne pusho, Adaghalane hhantu wo. ");
INSERT INTO sce_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Bi ene kielienyi kieliekushi ta mii tungo giezhi pinnanyi jienlieghane giezho. Ta duyade shouku gienema, zhughene khidunde gie! Bi duyani injiwo!\" ");
INSERT INTO sce_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ersa ene kielienyi kieliedene qiorunne qila asiman jiere uzhe kieliewo, \"Ada, shihou kuruwo. Chi Kewone kuai, ingiese Kewonye chii kuaine. ");
INSERT INTO sce_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Chi Kewondene ogisan kunlade chanqiku aminni ogine giezhi soyuji kunlai man gonjiku qienlii hhende ogizho. ");
INSERT INTO sce_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Niekozi zhen Hudai tanizhi hhe peizhi ireghasan Ersa Mexihani tanise chanqiku amin enbene. ");
INSERT INTO sce_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Chi made fenfulasan wiliei bi onchen giezhi ene zemin jierese chade kuaikui ireghawo. ");
INSERT INTO sce_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ada, ede chii melie made famani ogi. Duyase melie matan hhantu xianshou giesan famani made ogi.\" ");
INSERT INTO sce_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","\"Chi duya jierese made ogisan kunlade bi chii nierei mejieghawo. Hhela benshenshi chinughun wo. Chi hhelai made ogiwo. Hhelaye chini kielienyi zunjiwo. ");
INSERT INTO sce_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ede hhela chi made ogisanshi man chii hhense iresanyi mejiewo. ");
INSERT INTO sce_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Chi made ogisan kielienyi bi hhelade ogise hhela jienliewo. Hhela bishi chii hhense iresanyi mejiewo. Chi mini peizhi ireghasanyiye xianxin giewo.\" ");
INSERT INTO sce_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","\"Bi hhelade oluzhi onxian giezho. Duyani kunlade oluzhi onxian ese giezho. Hhelashi chinughun wo. Ingiese chi made ogisan kunlade bi onxian giezho. ");
INSERT INTO sce_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Minughunshi man chinughun wo. Chinughunshi minughun wo. Hhelai jierese made kuaikui irezho. ");
INSERT INTO sce_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Enense khuinashi bi duyade uwo. Hhela duyade wine. Bi chii hhende echine. Zhiguitu Ada, chi made ogisan niereghalane hhelai baohu giezhi matan mutun hhelai niekozi gholugha. ");
INSERT INTO sce_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Bi hhelare hhantu bikude chi made ogisan niereghalane bi hhelai baohu giezhi ezheliezho. Chugo hhe widaku kunse andase pse nieda ulie widane. Ene jinwun jieredu kielien mutun gholuwo.\" ");
INSERT INTO sce_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","\"Ede bi chii hhende echine. Bi duyade bikudeni mii bayasukughala hhelai bayasughane giezhi enezighan kielienlai kieliewo. ");
INSERT INTO sce_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Bi chii kielienyi hhelade ogidene duya hhelai henjiwo. Ene yenyinshi bi duyanughun pusho mutun hhelashiye duyanughun pusho. ");
INSERT INTO sce_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Hhelai, 'Duyase khizhegha!' giezhi bi chii xiahua ulie giene, 'Hhe doghunnise baohu!' gie giezhi xiahua giene. ");
INSERT INTO sce_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Bi duyanughun pusho mutun hhelaye duyanughun pusho. ");
INSERT INTO sce_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Zhendaoghala zuise hhelai zhiguishigha. Chii kielienshijiu zhendao wo. ");
INSERT INTO sce_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Chi mii duyade peizhi ireghasan mutun bi hhelaiye qingiezhi duyade peizhi echighane. ");
INSERT INTO sce_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Bi hhelade oluzhi goyane zhiguishighawo. Ingiese hhelaiye zhendaoi tungo giezhi zhiguishighane.\" ");
INSERT INTO sce_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","\"Bi zinie enelade oluzhi onxian gieku pusho. Hhelai kielienyi chenliedene mii xianxin giesan kunladeye onxian giezho. ");
INSERT INTO sce_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Bi onxian giese Ada mii sudoro wo, bi chii sudoro biku mutun, hhelaye matanyi sudoro nie gholu gie. Ingiese duyai kunlai chi mii peizhi ireghasanyi xianxin giegha.\" ");
INSERT INTO sce_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","\"Chi made ogisan famani bi hhelade ogiwo. Ingiese hhelai matan mutun nie gholughane. ");
INSERT INTO sce_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Bi hhelai sudoro wo, Chi mii sudoro wo, hhelai man nie gholughane. Ingiese duyai kunlai chi mii peizhi ireghasanyi, pse chi made oresan mutun hhelade oresanyi mejieghane. ");
INSERT INTO sce_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ada, chi made ogisan hhela bi khalashi khala bizhi mii famani hhelade uzhegha. Ene mienzishi duyai zhayaghaku melie chi made orezhi ogisan wo.\" ");
INSERT INTO sce_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","\"Gundantu Ada, duyai kunla chii tani dane. Bi chii tanine. Enezighan tujila chi mii peizhi ireghasanyi mejiene. ");
INSERT INTO sce_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Bi hhelade chii mejieghawo, izhi mejieghane. Ingiese chi made oresan hhelai sudoro wo, biye hhelai sudoro wo.\" ");
INSERT INTO sce_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ersa enezighan kielienyi kieliedene tujilarene hhantu khizhi echiwo. Hhela Jilun ghonni daodene nie yenzide orowo. ");
INSERT INTO sce_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ersa tujilarene chan hhe nie oronde hhantulazho. Ersai ghudandusan Yudaye hhe oronyi mejiene. ");
INSERT INTO sce_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yuda idaban Loma buduilai uduruzhi hhende irewo. Fugie buwa, Falisai kunla peisan mechini sagheisan kunlaye hhantu irezho. Hhela denlun, hoba, uqilai bareizho. ");
INSERT INTO sce_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ersa goyadene yan wilie kuzhekui man mejiene. Ingie khizhedene hhelade kieliewo, \"Ta kienyi ereizho?\" ");
INSERT INTO sce_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Hhela kieliewo, \"Nasale kun Ersai ereizho.\" Ersa kieliewo, \"Bi enbene.\" Ersai ghudandusan Yudaye hhelare hhantu beizho. ");
INSERT INTO sce_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ersa \"Bi enbene.\" giezhi kieliekude hhela khuina tuidene zemin jiere unawo. ");
INSERT INTO sce_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ersa pse hhelade asawo, \"Ta kienyi ereizho?\" Hhela kieliewo, \"Nasale kun Ersai ereizho.\" ");
INSERT INTO sce_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ersa kieliewo, \"Bi enbene giezhi tande kieliewo. Ta mini ereizhoshi enelai yolagha.\" ");
INSERT INTO sce_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Eneshi chi made ogisan kunlai bi nieda ese widaghawo giesan Ersa melieshi kieliesan kielien mutun gholuwo. ");
INSERT INTO sce_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ingiekude Ximun-Beduru nie khudogho bareizho. Lai khizhe zui fugie buwai hojii borun chighinyi chizhi agiwo. Hhe hojini nierei Malegu giene. ");
INSERT INTO sce_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ErsaBedurude kieliewo, \"Khudoghone xiuzide orogha. Adami made ogisan ene kuni bi ulie shouise olunu?\" ");
INSERT INTO sce_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ingiese budui, qienfuzhan, Yutai kunni mechini sagheisan kunla Ersai barei banladene ");
INSERT INTO sce_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Yanasii melie xien lai echighawo. Yanasishi hhe niehonyi zui fugie buwa danlasan Gaiyafani ghadun wo. ");
INSERT INTO sce_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ene Gaiyafashi melieshi Yutai kunlade ijien qilazhi \"Nie kun bexinlade oluzhi fuguse haochu wine.\" giezhi kieliesan hhe kun wo. ");
INSERT INTO sce_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ximun-Beduru da nie tujighala Ersai daghazho. Hhe tuji zui fugie buwai tanine. Ingiese daghazhi zui fugie buwai ghoronde orowo. ");
INSERT INTO sce_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Beduru damen ghadane beizho. Zui fugie buwai taniku hhe tuji khizhe damen sagheisan oqinde nie kieliese Bedurui oroghawo. ");
INSERT INTO sce_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Wijien sagheisan hoji oqin Bedurude kieliewo, \"Chiye hhei tuji pushonu?\" Beduru kieliewo, \"Pusho.\" ");
INSERT INTO sce_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Hhe xienzide qienqi kuiqienshi hoji, mechini sagheisan kunla hhantu khan teidene beizhi kouizho. Beduruye hhelare hhantu beidene kouizho. ");
INSERT INTO sce_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ingiese zui fugie buwa Ersade tujilaini, sughasanlaini shenwun giezho. ");
INSERT INTO sce_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ersa kieliewo, \"Bi kunlade mindaminji kieliezho. Bi chan huitande, mechide kunlade surughazho. Bi ghulazhi yama ese kieliezho. ");
INSERT INTO sce_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Chi made yangiezhi asane? Asase chenliesan kunlade asale echi. Bi yan kieliesanyi hhela man mejiene.\" ");
INSERT INTO sce_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ersa ene kielienyi kieliese shidani beisan nie mechini sagheisan kun khaghalane Ersai eghizhi kieliewo, \"Chi zui fugie buwade imutu kielien kielienu?\" ");
INSERT INTO sce_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ersa kieliewo, \"Bi kieliesan ese oluse chi kieliezhi mejiegha. Bi kieliesan oluzhoshi chi mini yangiezhi eghizho?\" ");
INSERT INTO sce_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ingiese YanasiErsai banlaghadene zui fugie buwa Gaiyafai hhende echighawo. ");
INSERT INTO sce_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ximun-Beduru zhen beizhi khan xiekude nie kun hhende kieliewo, \"Chiye hhei tuji pushonu?\" Beduru bi pusho giezhi ese renjiwo. ");
INSERT INTO sce_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Da nie zui fugie buwai hojishi Beduru chighinyini chizhi bouzheghasan hhei qingu wo. Hhe kieliewo, \"Bi chii Ersare hhantu yenzide bisei ese chanlawu?\" ");
INSERT INTO sce_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Beduru pse ese renjiwo. Deigo tigha kheilawo. ");
INSERT INTO sce_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Eqiemagha eqie Ersai Gaiyafai hhense Loma kunyi shenzhanfude echighawo. Hhela goyane shenzhanfude ese orowo. Orose zannantukuse ayizho. Jiulidaosan Jieni xini ijie dane. ");
INSERT INTO sce_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Bilado khizhedene hhelade kieliewo, \"Ta ene kunyi yan shiqinde zhazho?\" ");
INSERT INTO sce_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Hhela kieliewo, \"Ene kun zui ulie fanjise bijien chade ulie ireghane.\" ");
INSERT INTO sce_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Bilado kieliewo, \"Ta hhei uduru echi. Zhao goyane guijinghala panji.\" Yutai kunla kieliewo, \"Bijiende kun alaku qienli uwo.\" ");
INSERT INTO sce_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Eneshi Ersa melieshida goyane matui fugukune kieliesan kielien mutun gholuwo. ");
INSERT INTO sce_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Bilado pse shenzhanfude orodene Ersai uru ire hhende asawo, \"Chishi Yutai kunni honshan onu?\" ");
INSERT INTO sce_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ersa kieliewo, \"Ene kielienshi chi goyane kieliesan onu, kunla mii kieliesan wo?\" ");
INSERT INTO sce_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Bilado kieliewo, \"Chi sumulase bishi Yutai kun wo giezhou? Tai gojiai kunla, fugie buwala chii made jiuizhi ogizho. Chi yan giewo?\" ");
INSERT INTO sce_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ersa kieliewo, \"Mini gojiashi ene duyaghun pusho. Mini gojia ene duyaghunshi mini hojila made oluzhi zhan eghizhi mii Yutai kunlade jiuizhi ulie ogine. Mini gojiashi ene duyaghun pusho.\" ");
INSERT INTO sce_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Bilado hhende kieliewo, \"Ingiese chishi honshan onu?\" Ersa kieliewo, \"Bishi honshan wo giezhi chi kieliezho. Mii oluzhi duyade iresanshi zhendaode ganzhen beine giezho. Zhendaode beisan kunla mini kielienyi chenliene.\" ");
INSERT INTO sce_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Bilado kieliewo, \"Zhendaoshi yan wo?\" Ene kielienyi kieliedene pse khizhesenu Yutai kunlai hhende echi kieliewo, \"Bi hhei zuini chaizhi khizhe dawo. ");
INSERT INTO sce_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Tai nie xigonshi Jiulidaosan Jiede bi nie kun andaghane. Tande Yutai kunni honshanyi tei giezhou?\" ");
INSERT INTO sce_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ingiese hhela pse waradazhi kieliewo, \"Bijien ene kunyi ulie kerene! Balabai kerene!\" Balabashi nie panlon giesan kun wo. ");
INSERT INTO sce_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ingiedene Bilado mabienzighala Ersai eghighawo. ");
INSERT INTO sce_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Buduila eghesunyi maghala onjidene qiorun jierei zhoghazhi zishei fudu jienyi musighawo. ");
INSERT INTO sce_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ingie shidani echi kieliewo, \"Yutai kunni honshan, onsui!\" Ingiedene khaghalane eghizho. ");
INSERT INTO sce_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Bilado pse khizhedene bexinlade kieliewo, \"Uzhe, bi hhei uduruzhi tai melie khizheghaye. Bi hhense yama zui chaizhi khizhe dasei ta mejiendu.\" ");
INSERT INTO sce_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ingiese Ersa khizhewo. Eghesun maghala zhozho. Zishei fudu jien musizho. Bilado hhelade kieliewo, \"Uzhe, ene kun wo.\" ");
INSERT INTO sce_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Fugie buwa, mechini sagheisan kunla hhei chanlasenu waradazhi kieliewo, \"Hhei shizijia jiere ghada! Shizijia jiere ghada!\" Ingiese Bilado kieliewo, \"Ta goyalane hhei shizijia jiere ghadale echi. Bi hhei zuiini chaizhi khizhe dawo.\" ");
INSERT INTO sce_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ingiese Yutai kunla kieliewo, \"Bijiende guijin wine. Zhao guijin mutunshi hhe fugukuni wo. Hhe goyane Hudai kewon wo giezho.\" ");
INSERT INTO sce_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Bilado ene kielienyi sonosudene genjia ayizho. ");
INSERT INTO sce_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ingie shenzhanfude orosenu Ersade asawo, \"Chishi khalase iresan wo?\" Ersa yama huida ese giewo. ");
INSERT INTO sce_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Bilado kieliewo, \"Chi made kielien ulie kielienu? Made chii andaghaku, shizijia jiere ghadaku qienli bikui chi ulie mejienu?\" ");
INSERT INTO sce_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ersa kieliewo, \"Asiman jierese chade qienli ese ogizhoshi chi mii yama gie dane. Ingiese mii chade jiuisan hhe kunde zui pse gundu wo.\" ");
INSERT INTO sce_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Enense khuinashi BiladoErsai andaghane giezho. Yutai kunla waradazhi kieliewo, \"Chi ene kunyi andaghase Kaisa honshanni goude ese zunjizho. Kien goyane honshan giezhi kieliese Kaisa honshanyi ghudanduwo giezho.\" ");
INSERT INTO sce_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Bilado ene kielienyi sonosudene Ersai laizhi khizhesenu shenpantai jiere souwo. Sousan hhe oronyi Puisan Tashi giene. Xibolai kielienghala Jiabada giene. ");
INSERT INTO sce_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Hhe niudushi Jiulidaosan Jieni zhunbei giesan uduni udukun xienzi wo. BiladoYutai kunlade kieliewo. \"Uzhe, eneshi tai honshan wo.\" ");
INSERT INTO sce_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Hhela waradazhi kieliewo, \"Hhei widagha! Hhei widagha! Shizijia jiere ghada!\" Bilado kieliewo, \"Bi tai honshanyi shizijia jiere ghadase olunu?\" Fugie buwala kieliewo, \"Kaisa honshanse andase bijiende honshan uwo.\" ");
INSERT INTO sce_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ingiese BiladoErsai hhelade jiuizhi shizijia jiere ghada giewo. Hhela Ersai laidene echiwo. ");
INSERT INTO sce_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ersa goyane shizijiai beiliezhi khizhedene qiorun yasun oron giezhi urusan nie oronde echiwo. Xibolai kielienghala kieliese Gegeta giene. ");
INSERT INTO sce_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Hhende Ersai shizijia jiere ghadawo. Da ghua kunyi niemiendei nie ghadawo. Ersa dunda wo. ");
INSERT INTO sce_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Bilado nie peizi huaidene shizijia jiere guaighawo. Huaisanshi Nasale kun ErsaYutai kunni honshan giezho. ");
INSERT INTO sce_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ersai ghadasan oron chenshise gholo uwo. Peizi jiere huaisanshi Xibolai, Loma, Xilani uroughala huaizho. Ingiese olon Yutai kunla peizi jiere huaisei onshizho. ");
INSERT INTO sce_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Yutai kunni fugie buwala Biladode kieliewo, \"'Yutai kunni honshan' giezhi bu huai. Huaise, 'Ene kun goya bishi Yutai kunni honshan wo giezho.' giezhi huai.\" ");
INSERT INTO sce_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ingiese Bilado kieliewo, \"Bi huaikune huai baraghawo.\" ");
INSERT INTO sce_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Buduila Ersai shizijia jiere ghadasenu jienyini agi bouzhe jieran gholughadene nie kunde nie ghughawo. Pse sudorodu jienyini agise hhe jiendeni hudusan oron uwo. Jiere dourashi hulun giesan wo. ");
INSERT INTO sce_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Hhela nieniedene kieliewo, \"Matan sidazhi bu keighaye. Kiende irekui matan fendan qianguye.\" Ingiedene jinwun jieredu kielien mutun gholuwo, \"Hhela mini jienni ghughane. Mii sudorodu jienni fendan qiangune.\" Buduila zhenzhenji ingiezhi giewo. ");
INSERT INTO sce_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ersai shizijia shida beisan kun dunda Ersai anani, inianni, Gelobani bierei Mereiyen, Modalani Mereiyen wine. ");
INSERT INTO sce_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ersa anani, oresan tujini kanzide beisanyi chanladene anadene kieliewo, \"Ana, eneshi chii kewon wo.\" ");
INSERT INTO sce_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Pse hhe tujidene kieliewo, \"Uzhe, eneshi chii ana wo!\" Enense khuinashi hhe tuji anaini jienliezhi giedene echiwo. ");
INSERT INTO sce_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Enense khuinashi Ersa shiqinlane gie baraghasanyi mejiedene jinwun jieredu kielienyi gholughane giezhi kieliewo, \"Bi undasuzho.\" ");
INSERT INTO sce_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Cui zhonlozhi durughasan tantanyi hhende jiezho. Hhela haimienni cude zhanjidene osun gangan jiere banla, amandeni echighawo. ");
INSERT INTO sce_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ingiese Ersa cui ochidene kieliewo, \"Chenjiwo!\" Ingiedene qiorunne ghodeise ho sirawo. ");
INSERT INTO sce_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ene udushi Yutai kunla hhamuraku udude zhunbei gieku udu wo. Pse ene faku hhamuraku udushi nie fugie udu wo. Ingiese Yutai kunla Biladoi xiahua giezhi hhelai shigharai eghizhi ghuraghadene agi widagha giezho. Hhamuraku udude fugusan kunyi shizijia jiere jiese gou uwo giezho. ");
INSERT INTO sce_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ingiese buduila iredene Ersare hhantu ghadasan hhe ghua kunyi shigharai eghizhi ghuraghawo. ");
INSERT INTO sce_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ingie Ersai shida ire nie uzhese hhe duya ijiezho. Hhei shigharaini eghizhi uye ghuraghawo. ");
INSERT INTO sce_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ingiese niekozi budui zhidaghala leibadeni nie chujise chusun, usu usuru khizhewo. ");
INSERT INTO sce_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ene shiqinyi qinsi uzhesan kun ganzhen beizhi tai xianxin gieghane giezho. Hhe beisan ganzhenshi zhenni wo. Goyane kieliesanshi zhenni bikui mejiene. ");
INSERT INTO sce_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ene shiqinla fashen giekushi jinwun jieredu kielienyi gholughane giezho, \"Hhei yasun nieda ulie ghurane.\" ");
INSERT INTO sce_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Dou nie jinwun jiere kieliezho, \"Hhela goya chujisan kunne uzhene.\" ");
INSERT INTO sce_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Enense khuinashi Ersani nie tuji Yalimatai kun Yusufu giene. Hhe Yutai kunlase ayise ghulazhi tuji danlazho. Hhe Biladoi xiahua giezhi Ersai beyei kerezho. Bilado tunyi oluse Ersai beyeni agi echiwo. ");
INSERT INTO sce_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Melieshi xienidei Ersai ochirale iresan Nigedemuye huighasan guizhuntu caoye, luhuini 65 jin bareizhi irewo. ");
INSERT INTO sce_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Hhela zhao Yutai kunni bulaku xigonghala Ersai beyeni bosi xianshuighala boui goudaghawo. ");
INSERT INTO sce_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ersai shizijia jiere ghadasan oronde nie yenzi wine. Yenzide nie shini alimatu meza wine. Kun teizhi uye daozho. ");
INSERT INTO sce_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Hhe niudushi Yutai kunlai zhunbei gieku udu wo. Pse hhe meza chadashi hhela Ersai hhende bulawo. ");
INSERT INTO sce_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Xinqini eqiemagha udu da khara bikude Modalani Mereiyen mezade irewo. Nie uzhese tashi meza kouzise noi daozho. ");
INSERT INTO sce_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ingie holuzhi echidene Ximun-Beduru, Ersa oresan tujide kieliewo, \"Kunla mezase Ezhanni agi echizho. Khala jiesanyi ulie mejiene.\" ");
INSERT INTO sce_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ingiese Beduru hhe tujighala khizhe mezai hhende echiwo. ");
INSERT INTO sce_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Hhe ghuala hhantu holuzho. Hhe tuji Beduruse holuzhi ghujinshi xien mezade kuruwo. ");
INSERT INTO sce_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ghodeidene sudoro nie uzhese bosii hhende jiesanyi chanlawoma, orozhi ese echiwo. ");
INSERT INTO sce_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ingie Ximun-Beduru khuinasei kuzhi ire mezade orowo. Bosini hhende jiesanyi chanlawo. ");
INSERT INTO sce_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Pse Ersai qiorunni huisan toujin bosighala hhantu ese jiezhi niemiende horo jiesei chanlawo. ");
INSERT INTO sce_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ingiedene melieshi kuzhi iresan hhe tujiye mezade orozhi echi uzhedene xianxin giewo. ");
INSERT INTO sce_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Hhela Ersa fugusan kun dundase aminne olune giesan jinwun jieredu ene kielienyini dunjire dazho. ");
INSERT INTO sce_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ingiedene ghua tujila sousan orondene echiwo. ");
INSERT INTO sce_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mereiyen meza ghadane beizhi wilazho. Wilakudeni ghodei mezade nie uzhese ");
INSERT INTO sce_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ghua chighan jien musisan qienxienyi chanlawo. Ersai teisan oronde souzho. Nie qiorun konde wo, nie kon konde wo. ");
INSERT INTO sce_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Hhela Mereiyende asawo, \"Funi, chi yangiezhi wilazho?\" Hhe kieliewo, \"Kunla mii Ezhanyi agi echizho, khala jiesei ulie mejiene.\" ");
INSERT INTO sce_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ene kielienyi kieliesenu ochira daozhese Ersa hhende beisei chanlawoma, Ersa bikui ulie mejiene. ");
INSERT INTO sce_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ersa hhende kieliewo, \"Funi, chi yangiezhi wilazho? Kienyi ereizho?\" MereiyenErsai yenzi sagheisan kun wo giezhi asawo, \"Gujiu, chi hhei noighazhi khala jiezhoshi made kielie. Bi agile echiye.\" ");
INSERT INTO sce_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ersa kieliewo, \"Mereiyen!\" Mereiyen ochiradene Xibolai kielienghala hhende kieliewo, \"Laboni!\" Labonii isishi 'loushi' wo. ");
INSERT INTO sce_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ersa kieliewo, \"Chi mii bu barei. Bi da adane hhende ese khireizho. Chi echidene mii gaijiulade bi adane hhende khireine giezhi kielie. Hheshi tai adaye enbene, mii Huda wo, tai Hudaye enbene.\" ");
INSERT INTO sce_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Modalani Mereiyen echidene tujilade kieliewo, \"Bi Ezhanyi chujieghewo!\" Pse Ezhan hhende kieliesan kielienlai hhelade kieliewo. ");
INSERT INTO sce_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Xinqini yen hhe uduni xienidei tujila hhantulasan oronde Yutai kunlase ayise wijienlane khazho. Ersa hhelai dunda ire beizhi kieliewo, \"Ta pinnan onu?\" ");
INSERT INTO sce_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ene kielienyi kieliesenu hhelade kha, leibane uzheghawo. Tujila Ezhanyi chanladene bayasuzho. ");
INSERT INTO sce_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ingie Ersa pse hhelade kieliewo, \"Ta pinnan onu? Adami mii peisan mutun biye tai peine.\" ");
INSERT INTO sce_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ene kielienyi kieliedene hhelade nie feiliesenu kieliewo, \"Ta Shenlinyi jienliendu. ");
INSERT INTO sce_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ta kienyi zuini mienliese kienyi zui widane, kienyi zuini ulie mienliese kienyi zui ulie widane.\" ");
INSERT INTO sce_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","12 gie tuji dundadu Shongo giezhi urusan DomaErsa irekudeni hhelare hhantu uwo. ");
INSERT INTO sce_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Psedu tujila hhende kieliewo, \"Bijien Ezhanyi chujieghewo!\" Doma kieliewo, \"Bi hhei kha jieredu ghadasan oronyini, leibade chujisan oronyini ulie uzhetula xianxin ulie giene.\" ");
INSERT INTO sce_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Neimudu daodene hhei tujilani pse giedera hhantulazho. Domaye hhelare hhantu wo. Wijienlai man khazhoma, Ersa iredene hhelai dunda beizhi kieliewo, \"Ta pinnan onu?\" ");
INSERT INTO sce_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ingie Domade kieliewo, \"Khaghurunne enende teizhi mii khai uzhe. Khane khizheghazhi mii leibai moizhi uzhe. Inxin bu gie, xianxin gie.\" ");
INSERT INTO sce_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Doma kieliewo, \"Mii Ezhan, mii Huda!\" ");
INSERT INTO sce_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ersa kieliewo, \"Chi mii uzhedene xianxin gienu? Ese uzhedene xianxin giesan kunlade fuqi wine.\" ");
INSERT INTO sce_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ersa tujilai melie ene shu jiere uye jilasan ghudureqi da olon xienjighawoma, ");
INSERT INTO sce_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","enende jilasanlashi Ersashi Hudai Kewon Mexiha bikui tai xianxin gieghane giezhi pse xianxin giedene hhei niereghala tande amin ireghane giezhi huaizho. ");
INSERT INTO sce_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ene shiqinse khuinashi ErsaQibiliyahai bienzide tujiladene pse chujiegheghawo. Hhe matugie chujiegheghasei doura huaizho. ");
INSERT INTO sce_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ximun-Beduru, Shongo giezhi urusan Doma, Jialilini Jiana kun Nadanye, Xibitaini kewonla, pse ghua tuji enela man hhantu wo. ");
INSERT INTO sce_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ximun-Beduru hhelade kieliewo, \"Bi zhaghasun bareile echine.\" Hhela kieliewo. \"Bijienye chare hhantu yoye.\" Hhela khizhi echisenu chon jiere khiwo. Hhe xii hhela yama barei dazho. ");
INSERT INTO sce_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ogheine giekude Ersa haibienzide beizho. Tujila hheshi Ersa bikui ulie mejiene. ");
INSERT INTO sce_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ersa hhelade kieliewo, \"Zhanlienla, ta zhaghasun bareiwoye?\" Hhela kieliewo, \"Uye.\" ");
INSERT INTO sce_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ersa kieliewo, \"Ta onni chonni borun miende teima, zhaghasun barei shidane.\" Ingiese hhela onni chonyi borun miende teiwo. Zhaghasun texien olon, laizhi khizhe dazho. ");
INSERT INTO sce_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ersa oresan hhe nie tuji Bedurude kieliewo, \"Hheshi Ezhan wo!\" Hhe shihoude Beduru jien ese musizho. Ezhan wo giezhi nie sonosuse jienne pixilie hude jiuli bouwo. ");
INSERT INTO sce_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Psedu tujila haibienzise gholo uwo, chabudu 100 mi wine. Chon jiere soudene nie on zhaghasunyi laizhi daozhewo. ");
INSERT INTO sce_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Hhela bienzide khisenu nie duizi mutan khan chujieghewo. Khan jiere zhaghasun teizho, ginanye wine. ");
INSERT INTO sce_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ersa hhelade kieliewo, \"Ta jian bareisan zhaghasunsene giedun agi daozhe.\" ");
INSERT INTO sce_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ximun-Beduru chon shida echidene onni laizhi bienzide khizheghawo. Onde fugie zhaghasun duruzho, 153 gie wine. Ingieliuzhe on ese tanturazho. ");
INSERT INTO sce_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ersa kieliewo, \"Ta yushe ijiele irendu.\" Tujila hheshi Ezhan bikui mejiedene chishi kien wo giezhi kiema asa dazho. ");
INSERT INTO sce_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ersa ginanyi bareizhi hhelade ogiwo. Zhaghasunyiye ingiezhi hhelade ogiwo. ");
INSERT INTO sce_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Eneshi Ersa fugusan kun dundase aminne olusenu tujiladene 3 hui chujiegheghasan wo. ");
INSERT INTO sce_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Hhela yushe ijiedene ErsaXimun-Bedurude asawo, \"Yaheiyani kewon Ximun, chi made oresan enelase hen onu?\" Beduru kieliewo, \"Ezhan, bi chade oresei chi mejiene.\" Ersa kieliewo, \"Chi mii ga ghonilai chezhe.\" ");
INSERT INTO sce_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ersa 2 hui hhende asawo, \"Yaheiyani kewon Ximun, chi made orezhoye?\" Beduru kieliewo, \"Ezhan, bi chade oresei chi mejiene.\" Ersa kieliewo, \"Chi mii ghonilai adula.\" ");
INSERT INTO sce_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ersa hhende 3 hui asawo, \"Yaheiyani kewon Ximun, chi made orezhoye?\" ErsaBedurude 3 hui orezhoye giezhi asase Beduru nango giezhi Ersade kieliewo, \"Ezhan, chi yanniliuzhe mejiene. Bi chade oresei chi mejiene.\" Ersa kieliewo, \"Chi mii ghonilai chezhe. ");
INSERT INTO sce_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Bi chade shuhuajia kielieye, chi nasuchighan bikude yodaine banlazhi khalabi khala echinema, oqioluse kunla chii khai banlazhi chi duran wiku oronde deila echine.\" ");
INSERT INTO sce_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ersa ene kielienyi kieliekushi Beduru matugie fuguzhi Hudai kuaikui kieliezho. Ene kielienyi kieliesenu hhende kieliewo, \"Chi mii dagha.\" ");
INSERT INTO sce_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Beduru ochira daozhese Ersa oresan hhe tuji daghasei chujieghewo. Ene tujishi heifan ijiekude Ersai kanzii shighazhi, \"Ezhan, chii ghudandukushi kien wo?\" giezhi asasan hhe wo. ");
INSERT INTO sce_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Beduru hhei chujieghedene Ersade asawo, \"Ezhan, ene kun jianlai matui gholune?\" ");
INSERT INTO sce_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ersa hhende kieliewo, \"Bi hhei ulie fugughazhi bi pse ireku shihou oluliuzhe chare yan xiangan wo? Chi mini dagha.\" ");
INSERT INTO sce_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ene kielien gaijiulai chighinde echizhi \"Hhe tuji ulie fugune.\" giezhi kieliezho. Shijishan Ersa \"Hhe ulie fugune.\" giezhi ese kieliezho. \"Bi hhei ulie fugughazhi bi pse ireku shihou oluliuzhe chare yan xiangan wo.\" giezhi kieliezho. ");
INSERT INTO sce_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ene kunshi ene shiqinlade ganzhen beizhi jilasan hhe tuji wo. Hhe beisan ganzhenshi zhenni bikui bijien mejiene. ");
INSERT INTO sce_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ersa giesan shiqinla da olon hen wo. Bi sumulase nienieji jilane giese huaisan shu olonde, duyadeliuzhe teizhi pudagha dane.");
INSERT INTO sce_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Qiafeilo noyen, bi melieshiku shu jiere Ersa wilie giezhi qiisanse sunghusan shitulade Shenlinghala fenfulasenu asiman jiere khireiku hhe udu kurutula hhe giesan, surughasanlai man huaiwo. ");
INSERT INTO sce_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ersa ku shouidene olon zhenjighala goya aminne oluwo giezhi shitulade uzheghawo. 40 qien dunda shitulade xienjighazhi Hudai gojiai shiqinyi jianjizho. ");
INSERT INTO sce_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ersa hhelare hhantulakude fenfulazhi kieliewo, \"Ta Yelusalense likai bu giezhi bi tande kieliesan mutun Ada dain giesei saghei. ");
INSERT INTO sce_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yaheiya usughala xili gieghawoma, giedudu ulie beizhi tai Shenlinghala xili gieghane.\" ");
INSERT INTO sce_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Hhela man hhantu bikude Ersade asawo, \"Ezhan, chi ene shihoude Isilie gojiani yen goudaghanu?\" ");
INSERT INTO sce_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ersa hhelade kieliewo, \"Ada qienlighalane jinjisan shihou, uduni ta mejiekuni pushoma, ");
INSERT INTO sce_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Shenlin tai jiere bouzhese tande nenli irezhi ta Yelusalen, Yudaya, Samaliya, pse duyai uzhude kutula made ganzhen beine.\" ");
INSERT INTO sce_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ene kielienyi kielie baraghadene hhela uzheku shihoude asiman jiere khireiwo. Niegieda olien hhei jienlie echise chanla dawo. ");
INSERT INTO sce_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Hhe khireikude hhela asiman jiere xianxide uzhese menzhali ghua chighan jien musisan kun hhelai kanzide beizhi kieliewo, ");
INSERT INTO sce_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","\"Jialili kunla, ta yale beizhi asimanyi uzhene? Tanse likai giezhi asiman jiere khireisan Ersa, ta matugie uzhezhi khireighazhoshi yen qingiezhi irene.\" ");
INSERT INTO sce_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ingiedene hhela Ganlanshanse Yelusalende khareiwo. GanlanshanYelusalense chada wo, hhamuraku udude yose olune. ");
INSERT INTO sce_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Hhela chenshide orodene sousan lou jierene khireiwo. Hhende Beduru, Yaheiya, Yagebu, Andelie, Feili, Doma, Badolomai, Matai, Yalefeini kewon Yagebu, Rexinpaini Ximun, Yagebuni kewon Yuda enela wine. ");
INSERT INTO sce_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Enezighan kunla, giedun bierei, Ersani anani Mereiyen, gaijiulareni hhantu hende onxian giezho. ");
INSERT INTO sce_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Hhe oloncha chabudu 120 gie gaijiula hhantulakude Beduru bosizhedene kieliewo, ");
INSERT INTO sce_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","\"Gaijiula, jinwun jiere Shenlin Dawudei amanghala melieshi kieliesan mutun Yuda kunlai uduruzhi Ersai bareiku shiqin zhao hhe mutun gholuse indanji wo. ");
INSERT INTO sce_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Hhe yenlaishi matanyi dundashiku nie wo. Shitula gieku wiliese ibufen zhanjizho. ");
INSERT INTO sce_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ene nie kun gou wiku baerghala nie ghazha agiwo. Ingie ghazhadene fura bou, kielini gha oluzhi khizhesunlani usuru khizhezho. ");
INSERT INTO sce_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Yelusalende sousan kunla ene shiqinni man mejiewo. Ingie goyalane kielienghala ghazhaini Yagedama giewo. Isishi chusun ghazha wo. ");
INSERT INTO sce_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Enei Zeburei jiere ingiezhi kieliezho, 'Hhei sousan oronni honji gholuzhi kiemai ulie soughasejiu.' Pse kieliezho, 'Danie kunyi hhei oronde jinjighasejiu.' ");
INSERT INTO sce_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Ingiese Ezhan Ersa matanyi dunda giekude Yaheiya xili gieghasanse Ezhan matanse likai giezhi asiman jiere khitula matanre chan hhantu bisan kun dundase nie sunghuzhi Ersa fuho giesande ganzhen beighakui wo.\" ");
INSERT INTO sce_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ingiedene hhela sunghune giezhi ghua kunyi khizheghawo. Nieshi Yusufu wo. Hhei Basabaye giene, Yushidu giezhiye uruzho. Da nieshi Maqiya wo. ");
INSERT INTO sce_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Hhela onxian giezhi kieliewo, \"Ezhan, chi kunlai zhughei man mejiene. Chi ene ghua kunse kienyi sunghuzhi ene shituni wiliei giekui bijiende mejiegha. Yuda ene wiliei bendadene goya orondene echiwo.\" ");
INSERT INTO sce_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ingie hhela fendan qiangudene Maqiyani choui khizhewo. Hhei 11 gie shitulare hhantulaghawo. ");
INSERT INTO sce_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","50 qienni jieqi kuzhese hhela man nie oronde hhantulazho. ");
INSERT INTO sce_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Menzhali asiman jierese fugie kei feiliesan mutun nie xianshen bouzhezhi hhela sousan giedera duruwo. ");
INSERT INTO sce_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Pse khanni hoyen mutun khizhedene jien kunyi jiere luiwo. ");
INSERT INTO sce_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ingie hhelai jiere Shenlin durudene Shenlin ogisan nenlighala psedu kielienghala kielie qiiwo. ");
INSERT INTO sce_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Hhe xienzide xienliantu Yutai kunla shijieni go gojiase irezhi Yelusalende souzho. ");
INSERT INTO sce_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ene shenqi khizhese olon kunla man hhantuladene goya oronyi kielienyi sonosuse ghudure wo giezho. ");
INSERT INTO sce_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Hhela hende ghanirazhi kieliewo, \"Uzhe, ene kielien kieliesanlashi Jialili kun pushonu? ");
INSERT INTO sce_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Matan chenliese hhela matugie mai olusan oronyi kielienghala kieliezho? ");
INSERT INTO sce_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Mai dunda Paqiya, Madai, Ilan kun wine. Pse Meisobudamiya, Yudaya, Jiapadojia, Bendu, Yaxiya, ");
INSERT INTO sce_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Fulijia, Panfeiliya, Aijidedu kun, Gulinaini kouisan Libiyai idou oronni kunlaye wine. Da Lomase irezhi toreisan kun dunda ");
INSERT INTO sce_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Yutai kun, Yutaijioni suisan kun wine. Pse Kelite, Alabo kunye wine. Matan sonosuse hhela mai kielienghala Hudai fugie shiqinyi kieliezho.\" ");
INSERT INTO sce_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Kunla man ghanirazhi mejie dazhi nieniedene, \"Eneshi yan isi wo?\" giezhi asazho. ");
INSERT INTO sce_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Niezhan kunla hhelai xiniezhi hhela jiu ochi sudowo giezho. ");
INSERT INTO sce_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Beduru 11 gie shitulare bosi ire kunlade fugiede kieliewo, \"Yutai kun, Yelusalende sousan kunla, bi kieliesei goude chenliezhi mejiendu. ");
INSERT INTO sce_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ta sumulase enezighan kunla sudowo giezhou? Uye sudozho, eneshi eqiemaghaku 9 jien wo. ");
INSERT INTO sce_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Eneshi zhen xienzhi Yeer kieliezhi daosan wo, ");
INSERT INTO sce_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","'Huda kieliewo, Duya baraku xienzide bi Shenlinne jien kunlai jiere kiene. Tai kewon, oqinla mini kielienyi kieliene. Tai nasuchighan kunla zhoujin mutun chanlane. Tai oqio kunla zhoujin zhoujiliene. ");
INSERT INTO sce_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Hhe xienzi kuzhese bi Shenlinne ere kun, bierei hojilane jiere kiese hhela mini kielienyi kunlade kieliene. ");
INSERT INTO sce_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Asiman jiere bi fugie shiqin xienjighane. Zemin jiere chusun, khan, funighala ghudureqi xienjighane. ");
INSERT INTO sce_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ezhanni fugie famatu udu kuzhetula naran kharalane, sara chusun mutun hularane. ");
INSERT INTO sce_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ingiese Ezhanyi xiahua giesan kunlai man jiuine.'\" ");
INSERT INTO sce_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","\"Isilie kunla, ene kielienyi chenliendu. Huda Nasale kun Ersai tungo giezhi tai dunda nenlitu shiqin, fugie shiqin, ghudureqi xienjighadene Ersade ganzhen beizho. Enei ta goyalane mejiene. ");
INSERT INTO sce_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Huda zhao goyane isighala melieshi jihua giesan mutun Ersai jiuizhi ogiwo. Ta niman doghun kunlai tungo giezhi hhei shizijia jiere ghada alawo. ");
INSERT INTO sce_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ingieliuzhe Huda hhei fuguku nangoni widaghazhi aminne olughawo. Fuguku hhei hanshilie dazho. ");
INSERT INTO sce_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dawude hhei zhiizhi kieliewo, 'Bi chanlase Ezhan chan mii shida wo. Hhe mii borun miende beise bi ulie gojiolune. ");
INSERT INTO sce_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ingiese zhughedemi bayasuzhi amandemi doulakui wine. Made xiwon wine, bi hhamura shidane. ");
INSERT INTO sce_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Chi mii ruhherni dozode ulie bendane. Zhiguitu kunne ulie fughane. ");
INSERT INTO sce_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Chi aminni moni made uzheghawo. Chighala hhantushi bi hende bayasuzho.'\" ");
INSERT INTO sce_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","\"Gaijiula, famatu xienren Dawudeni shiqinyi bi tande minminji kielieye. Hhe duya ijiezhi bulawo. Hhei meza edeliuzhe mai enende wine. ");
INSERT INTO sce_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Hheshi nie xienzhi wo. Huda hhende dadu giezhi hhei houdeise nie kun sunghudene hhei baozo jiere soughane giezhi kieliesei mejiewo. ");
INSERT INTO sce_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Hhe melieshidase ene shiqinyi mejiezhi Mexiha fuho giekui kieliewo, 'Hhei dozode ese bendawo, beyeini ese fughawo.' ");
INSERT INTO sce_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ene nie Ersai Huda aminne olughawo. Bijien man ene shiqinde ganzhen beine. ");
INSERT INTO sce_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Huda hhei undudaghazhi borun miendene soughawo. Ada dain giesan Shenlinni hhe jienliedene kie bouzheghawo. Eneshi ta chujieghezhi sonosusan wo. ");
INSERT INTO sce_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Dawude asiman jiere ese khireiwoma, goyane kieliezho, 'Ezhan mii Ezhande kieliewo, \"Bi duitoulaichii kon dourachii teitula chi mini borun miende sou.\"' ");
INSERT INTO sce_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ingiese Isilie kunla, man mejiendu. Ta shizijia jiere ghadasan ene Ersani Huda Ezhan, yeshijiu Mexiha gholughawo.\" ");
INSERT INTO sce_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Kunla ene kielienyi chenliedene zhughedeni hende jindazhi Bedurude, psedu shitulade asazho, \"Gaijiula, bijien matugiene?\" ");
INSERT INTO sce_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Beduru kieliewo, \"Ta man geizhen giendu. Ersa Mexihai niereghala xilii jienliedene tai zuini mienlie gie. Ingiese Huda ogine giesan Shenlinni ta jienliene. ");
INSERT INTO sce_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ene dainshi tande, tai kesilade, pse Ezhan mai Huda gholodose uruzhi iresan kunlade man olusan wo.\" ");
INSERT INTO sce_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Beduru pse olon kielienghala, \"Ta ene idai doghun kunlai dundase goyalane jiuizhi khizhe!\" giezhi ganzhen beizhi hhelade hende surughazhi kieliewo. ");
INSERT INTO sce_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Hhei kielienyi xianxin giesan kunla xili jienliewo. Hhe niudude xianxin giesan kun chabudu 3000 olodowo. ");
INSERT INTO sce_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Hhela zhomen shitula sughasanyi chenliezhi laiwon giezhi ginan ghuluzhi onxian gienduzho. ");
INSERT INTO sce_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Shitula olon fugie shiqin, ghudureqi xienjighase kunla man ayizho. ");
INSERT INTO sce_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Xianxin giesan kunla hhantulazhi yan dunxiiliuzhe hhantu injizho. ");
INSERT INTO sce_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Hhela giene dunxi, jiachanlane huidene baer injine giesan kunlade ghughazhi ogizho. ");
INSERT INTO sce_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Niudunie mechide hhantulazho. Pse gieladene ginan ghuluzhi bayasuzhi heqide ijienduzho. ");
INSERT INTO sce_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Hudade doulazho. Olon kunla hhelai kuaizho. Ezhan yebeiseye kun olon jiuizho. ");
INSERT INTO sce_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Niudude xiawu 3 jienni onxian gieku shihoude BeduruYaheiyaghala mechide echiwo. ");
INSERT INTO sce_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Niekozi kun olusanse dogholon wo. Niudunie kunla qienliezhi mechii wijien konde teizhi wijiense orochen kunlase xiahua giezhi baer ghuizho. Hhe wijienyi nierei Seighan wijien giene. ");
INSERT INTO sce_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Hhe kun Beduru, Yaheiyaghala orokui chanladene xiahua giezhi baer kerezho. ");
INSERT INTO sce_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Beduru, Yaheiyaghala hhei xianxide uzhedene Beduru kieliewo, \"Chi bijienyi uzhe.\" ");
INSERT INTO sce_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Hhe kun hhelai xianxide uzhezhi sumulase yama kerene giezho. ");
INSERT INTO sce_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Beduru kieliewo, \"Made antan, miengu uwoma, bikune chade ogiye. Bi Nasale kun Ersa Mexihai niereghala kielieye, 'Chi bosidene yo!'\" ");
INSERT INTO sce_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ingiedene hhei borun khase feizhi bosizheghawo. Hhei gugieni, konni deigo goudazhi lilian orowo. ");
INSERT INTO sce_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Jiuli bosi ire, beidene yo qiiwo. Hhelare hhantu mechide orokude yozho, jiulizho, Hudade doulazho. ");
INSERT INTO sce_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Kunla hhe yozhi Hudade doulasanyi chanlawo. ");
INSERT INTO sce_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Hheshi mechini Seighan wijien konde sousan ghuichen bikuni mejiedene hhe goudasan shiqinde ghaniradei uzhe beizho. ");
INSERT INTO sce_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Hhe kun Beduru, Yaheiyaghalai barei beikude olon kunla holuzhi hhende ire ghanirawo. Hheshi zhen Sulumaneni zoulan doura wo. ");
INSERT INTO sce_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Beduru chanladene bexinlade kieliewo, \"Isilie kunla, ta yale ene shiqinde ghanirazho? Ta bijienyi yangiezhi uzhezho? Ta sumulase bijien goya nenli, xienliantu zhugheghalane ene kunyi yoghawo giezhou? ");
INSERT INTO sce_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Iburaheimu, Isaghei, Yagebui Huda, mai xienrenlai Huda goya hoji Ersai kuaizho. Ene Ersashi ta Biladode jiuizhi ogidene Bilado jiejin giezhi hhei andaghane giese ta fandui giesan hhe wo. ");
INSERT INTO sce_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ta zhiguitu, gou kunyi ulie keredene kun alasan kunyi andagha giezhi xiahua giewo. ");
INSERT INTO sce_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ta alasanshi aminni Ezhan wo. Huda hhei fugusan kun dundase aminne olughawo. Bijien ene shiqinde ganzhen beine. ");
INSERT INTO sce_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ta tanizhi chanlasan ene kunde Ersai niere lilian oroghawo. Ersai xianxin gieku xinyanghala ene kunyi tai melie qienbu goudaghawo. ");
INSERT INTO sce_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Gaijiula, ta noyenlane mutun mejie dazhi qingiezhi giesei bi mejiene. ");
INSERT INTO sce_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Huda eqighanse jien xienzhilani tungo giezhi Mexiha shouku giekui kieliewo. Ede qimutui gholuwo. ");
INSERT INTO sce_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ingiese ta geizhen giezhi Hudai miende khareizhi irendu. Tai zuini widaghane. ");
INSERT INTO sce_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ingiese futanni shihou Ezhanyi hhense irene. Huda eqighanse jinjisan Mexihai tande oluzhi ireghane. Hheshijiu Ersa wo. ");
INSERT INTO sce_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Zhen Huda eqighandei zhiguitu xienzhilane tungo giezhi kieliesan mutun duyani cunxin goudaghaku shihou olutula Ersa Mexiha bixi asiman jiere feiliene. ");
INSERT INTO sce_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Musa kieliezhi Ezhan Huda tai dundase bi mutun nie xienzhi khizheghane. Hhe yan kieliese ta man chenliendu. ");
INSERT INTO sce_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kien ene xienzhii kielienyi ulie chenliese Huda bexinlane dundase widaghane giezho. ");
INSERT INTO sce_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Samuerse kaishi giezhi hhei khuinadedu alinie xienzhiliuzhe ene udulani shiqinyi kieliezhi daowo. ");
INSERT INTO sce_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Tashi hhe xienzhilai houdei wo. Huda tai xienrenlade yenjisan kielienni taye jienliewo. Huda Iburaheimude ingie kielie goudaghazho, 'Zemin jieredu soyuji minzulade chii houdeini yenyinzhe fuqi irene.' ");
INSERT INTO sce_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Huda hojine bosizheghadene peizhi xien tande iregha, tai alinie kunniliuzhe doghunnilase likai gieghazhi tande fuqi ogiwo.\" ");
INSERT INTO sce_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","BeduruYaheiyaghala kunlade kielien kieliekude buwala, mechii sagheisan duizhan, Sadugai kunla iredene ");
INSERT INTO sce_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","hhela bexinlade Ersai tungo giezhi fugusan kun fuho giesei surughazhi chonjise hende hokuzho. ");
INSERT INTO sce_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ingie hhelai barei agi, khara oluse khadene khuichudu kuwo. ");
INSERT INTO sce_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ingieliuzhe hhela jianjisan kielienni chenliedene xianxin giesan kun olon wo. Xianxin giesan ere kun 5000 gholuwo. ");
INSERT INTO sce_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Khuichudu Yutai kunni noyen, zhanlao, jinwun hanjiala man Yelusalende hhantulawo. ");
INSERT INTO sce_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Zui fugie buwa Yanasi, Gaiyafa, Yaheiya, Yalishanda, pse zui fugie buwani jiawuni kunla man hhende wine. ");
INSERT INTO sce_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Hhela Beduru, Yaheiyaghalai dunda beighadene asawo, \"Ta kienyi nenli, niereghala ene shiqinyi giezho?\" ");
INSERT INTO sce_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Qingiekude Bedurude Shenlin duruzhi hhelade kieliewo, \"Bexinlai noyen, zhanlaolaya, ");
INSERT INTO sce_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ta enedu ene dogholonyi jiere bijien giesan gou shiqin, pse hhe matugie goudasei bijiende asazhoshi ");
INSERT INTO sce_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ta ashighala, Isilieni bexinla man mejiendu. Tai melie beizhi goudasan ene kunshi ta shizijia jiere ghadadene Huda fugusan kun dundase aminne olughasan Nasale kun Ersa Mexihani niereghala goudaghasan wo. ");
INSERT INTO sce_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ene Ersashi jinwunde ingiezhi kieliesan hhe wo, 'Ta jianrenla bendasan tashi ede giei zhunyo tashi gholuwo.' ");
INSERT INTO sce_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ersase chugo pse jiuichen uwo. Qienxiade matanyi jiuiku psedu nierei ese ogizho.\" ");
INSERT INTO sce_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Hhela Beduru, Yaheiya ghuala fugie danzighala kieliesei uzhewo. Hhelade yama unhua wikui mejiedene ghanirawo. Pse ene ghua kunshi Ersare hhantuku wo giezho. ");
INSERT INTO sce_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Hhe goudasan kun hhelare hhantu beisanyi chanladene hhelade yama kielieku kielien widawo. ");
INSERT INTO sce_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ingie BeduruYaheiyai zui fugie fayense khireigha giezhi fenfuladene goyalane shanlian giezhi kieliewo. ");
INSERT INTO sce_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","\"Matan ene ghua kunyi matugiene? Hhela nie ghudureqi xienjighawo, jien Yelusalende sousan kunla man mejiene. Matan uwo giezhi kielie danema, ");
INSERT INTO sce_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ene shiqin bexinlai dunda fugiedakuse ayizhi matan hhelai nie ayighaye. Ene kunyi niereghala pse bu chonji gie.\" ");
INSERT INTO sce_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ingie hhe ghualai uruzhi ire, Ersani niereghala kunlade pse bu jianji, ye bu surugha giewo. ");
INSERT INTO sce_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","BeduruYaheiyaghala kieliewo, \"Tai kieliei chenlie, Hudai kieliei ulie chenliese, Hudai melie heshi winu uwo? Ta goyalane sumula. ");
INSERT INTO sce_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Bijien chujieghezhi sonosusanne ulie kieliezhi ulie olune.\" ");
INSERT INTO sce_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Noyenla hhelade yama faikui jiekou ereizhi khizhe dawo. Pse bexinla ene fashen giesan shiqin jiere Hudai kuaise hhe ghualai hende nie ayigha andaghawo. ");
INSERT INTO sce_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Yenlai ene ghudureqighala goudaghasan kun 40 ji olune. ");
INSERT INTO sce_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","BeduruYaheiyaghalai andaghadene hhela goya kunlane hhende echiwo. Fugie buwa, zhanlaolai kieliesan kielienyi goya kunladene kieliewo. ");
INSERT INTO sce_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Hhela chenliedene Hudade nie zhugheghala fugiede kieliewo, \"Asiman, zemin, hai, pse hhei sudorodu shihenilai man zhayaghazhi gonjisan Ezhan, ");
INSERT INTO sce_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","chi Shenlinyi tungo giezhi goya hojine, bijienyi xienren Dawudeni amanghala ingiezhi kieliewo, 'Go gojiala yale nouine? Go minzula yale oronde wikui jihua giene? ");
INSERT INTO sce_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Duyai honshanla bosizhewo. Noyenla hhantulazho. Ezhanse, Ezhanni Mexihase fandui giene giezho.' ");
INSERT INTO sce_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Hherode, Benjiu-Bilado ghuala ene chenshide niman kun, Isilie kunlare hhantuladene chi sunghu goudaghasan zhiguitu hoji Ersai qingiezhi fandui giezho. ");
INSERT INTO sce_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Hhela giesanlashi man chii nenli, isighala eqighan jiejin giesan shiqin wo. ");
INSERT INTO sce_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ezhan, hhela ede bijienyi ayighasei chi nie uzhe. Hojiladene fugie danzi ogizhi chii kielienni kieliegha. ");
INSERT INTO sce_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Chi nenline xienjighazhi gienlai goudagha. Chii zhiguitu hoji Ersai niereghala ghudureqi, fugie shiqin xienjigha.\" ");
INSERT INTO sce_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Hhela onxian gie baluse hhantulasan oron gojiolu qii, hhelade man Shenlin duruzhi danzine fugiedagha, Hudai kielienni kielie qiiwo. ");
INSERT INTO sce_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Xianxin giesan kunla zhughede, sumulasanla man nie wo. Kienliuzhe eneshi goyanughun wo ulie giene, man hhantu injizho. ");
INSERT INTO sce_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Shitula fugie nenlighala Ezhan Ersa fuho giesande ganzhen beizho. Ingiese kunlade Hudai fugie nenjien irewo. ");
INSERT INTO sce_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Hhelai dunda kiemade yama ese chaizho. Hhela ghazha, gielane huisan baerni agizhi iredene ");
INSERT INTO sce_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","shitulani melie jiese shitula zhao kunla injiku mutun ghughazhi ogiwo. ");
INSERT INTO sce_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Nie Liwi kunyi nierei Yusufu giene. Saipuluside oluzho. Shitula hhei Banaba giezhi uruzho, isishi kunlade goude sughazhi kieliechen wo. ");
INSERT INTO sce_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Hhe ghazhalane huidene baerni agizhi ire shitulai melie jiewo. ");
INSERT INTO sce_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Da nie kunyi nierei Yananiya giene. Biereiini Safeila giene. Ghuala ghazhane huidene ");
INSERT INTO sce_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","baerse ghulazhi goyadene gouji feiliegha, psedulai shitulai melie jiewo. Enei biereiniye mejiene. ");
INSERT INTO sce_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Beduru kieliewo, \"Yananiya, yale chii zhughede Ibilisi duruzhi Shenlinyi piendane? Ghazhane huisan baerni yale goujinie feilieghawo? ");
INSERT INTO sce_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ghazhane uye huikude ghazhashi chinughun pushonu? Ede huise baerne chi zozhu giezhola? Chi yale intui giezho? Chi kunni ese piendazho. Hudai piendazho.\" ");
INSERT INTO sce_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Yananiya ene kielienyi chenliedene fura bou, ho sirawo. Chenliesan kunla man hende ayizho. ");
INSERT INTO sce_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Giedun nasuchighan kunla bosi ire, hhei boui goudaghadene qienlie khirei bulawo. ");
INSERT INTO sce_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ghuran zhuntou daose biereini irewo. Ene shiqinni dou ulie mejiene. ");
INSERT INTO sce_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Beduru hhende asawo, \"Chi made kielie, ta ghazha huisan baershi enezighan onu?\" \"Jiu enezighan wo.\" ");
INSERT INTO sce_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Beduru kieliewo, \"Ta ghuala yale hhantulazhi Ezhanni ruhherni shiine? Zhanguijii chii bulasan kunla ede wijien konde irewo, chiiye qienlie khighane.\" ");
INSERT INTO sce_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ingie hhe bierei deigo Bedurui kon konde fura bou, ho sirawo. Hhe nasuchighan kunla oro ire fuguseini chanladene, qienlie echi zhanguijiini kanzide bulawo. ");
INSERT INTO sce_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Jien jiohuini kunla, pse ene shiqinyi chenliesan kunla man hende ayizho. ");
INSERT INTO sce_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ezhan shitulai tungo giezhi bexinlai dunda ghudureqi, fugie shiqin olon giewo. Xianxin giesan kunla Sulumane zoulande heqide man hhantulazho. ");
INSERT INTO sce_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Bexinla man hhelai zanchen giezhoma, kunlase ayizhi hhelare hhantula dazho. ");
INSERT INTO sce_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ezhanyi xianxin giesan ere kun, biereila yebeiseye olodozho. ");
INSERT INTO sce_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Niezhan kunla da gientulai qienliezhi geidoude khirei chon, ruzi jiere jiezho. Sumulase Beduru yozhi daokude xiujieniliuzhe hhelai jiere kuse giezho. ");
INSERT INTO sce_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Pse Yelusalen zhouwini xianlase olon kunla gientu, zannan ruhher heisanlai uduru ire man goudaghawo. ");
INSERT INTO sce_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Zui fugie buwa, hhei lienshoulani Sadugai kunla hende dubiliedene ");
INSERT INTO sce_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","shitulai barei agi bafanzide khawo. ");
INSERT INTO sce_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Xienidei Ezhanyi qienxien bafanzi wijienyi niezhi hhelai uduru khizhegha kieliewo, ");
INSERT INTO sce_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","\"Ta mechide echidene ene amin ogiku daolii bexinlade man kielie.\" ");
INSERT INTO sce_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ingiese shitula ene kielienyi chenliedene ogheikude mechide echizhi kunlade sughazho. Zui fugie buwa, lienshoularene kuzhedene zui fugie fayenni kun, Isilieni zhanlaolai uruzhi irewo. Kun peizhi bafanzise shitulai lai iregha giezho. ");
INSERT INTO sce_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Mechini sagheisan kunla bafanzide echise kun nieda uwo. Ingie khareizhi ire kieliewo, ");
INSERT INTO sce_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","\"Bijien echise bafanzi wijien yama ese giezho. Sagheisan kun wijien ghadane wo. Wijienyi niese sudoro kun nieda uwo.\" ");
INSERT INTO sce_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Mechini sagheisan duizhan, fugie buwa ene kielienyi chenliedene ghanirazhi matugie imutui gholuwo giezho. ");
INSERT INTO sce_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nie kun iredene kieliewo, \"Ta bafanzide bareisan kunla ede mechide beidene bexinlade sughazho.\" ");
INSERT INTO sce_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ingie duizhan mechini sagheisan kunlai uduruzhi shitulai barei irewo. Bexinla hhelai tashighala eghikuse ayizhi khidunde ese giezho. ");
INSERT INTO sce_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Hhela shitulai barei ire zui fugie fayen sudoro beigha zui fugie buwa hhelade asazho, ");
INSERT INTO sce_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","\"Bijien tande hende jingao giezhi ene kunyi niereghala kunlai bu surugha giezhi kieliewo. Ta daoline nie Yelusalende kielie kurughadene dou alasan ene kunni chusunni zhanni bijienyi jiere beilieghane.\" ");
INSERT INTO sce_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Beduru, pse shitula kieliewo, \"Hudai shunjizhi kunyi ulie shunjise indanji wo. ");
INSERT INTO sce_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mai xienrenni Huda ta mutun jiere guaidene alasan Ersai aminne olughawo. ");
INSERT INTO sce_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Huda hhei undudaghazhi borun miendene khighawo. Hhei honshan, jiuichen danlaghazhi Isilie kunni geizhen gieghazhi zuini mienliene giezho. ");
INSERT INTO sce_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Bijien ene shiqinlade ganzhen beine. Hudai shunjisan kunlade ogisan Shenlinye ganzhen beine.\" ");
INSERT INTO sce_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Zui fugie fayenni kunla enei chenliedene hende hokuzhi hhelai alane giezho. ");
INSERT INTO sce_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Nie Falisai kunyi niereini Jiamalie giene. Hheshi nie jinwun loushi wo, kunla man hhei zunjine. Zui fugie fayende bosi ire kunlade fenfulazhi shitulai ghadane niecha khireigha giewo. ");
INSERT INTO sce_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ingie kunlade kieliewo, \"Isilie kunla, ta ene kunlai xioxin giezhi chuli gie. ");
INSERT INTO sce_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Eqighandei Duda bosi ire goyane fugie wo giezho. Hhei daghasan kun 400 wine. Hhei alasenu daghasan kunlai man sanda widazhi yama widawo. ");
INSERT INTO sce_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Hhense khuinashi hukou denji giekude Jialilini Yuda bexinlai yela giezhi goyane daghaghawoma, hhe fuguse daghasan kunla man sanda widawo. ");
INSERT INTO sce_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ede bi tande kielieye, ta ene kunlase gholodo. Hhelai bu gonji. Hhelai jihua, giesanlashi kunse irese widane. ");
INSERT INTO sce_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Hudase iresan enbese ta hhelai widagha dane. Ta kenen Hudare duitou gholune.\" Zui fugie fayenni kunla hhei kieliei shunjidene ");
INSERT INTO sce_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","shitulai uru ire idun eghidene Ersai niereghala bu kielie gie andaghawo. ");
INSERT INTO sce_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Shitula Ersai nierede oluzhi jiuren giese pei shidane giezhi hende bayasudene zui fugie fayense likai giewo. ");
INSERT INTO sce_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Hhela niudunie mechide, go gielade ese beidene Ersashi Mexiha wo giezhi kunlade sughazhi gouxioxini chonjizho. ");
INSERT INTO sce_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Hhe oloncha tuji niudunie olodozho. Niudunieku shenhofei ogiku shiqin jiere Xila kielien kieliechen Yutaii guafulai jiezho. Ingiese hhela Xibolai kielien kieliechen Yutai kunlade boxin kieliezho. ");
INSERT INTO sce_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ingie 12 gie shitu olon tujilai uru ire kieliewo, \"Matan Hudai kielienyi chonjikui bendazhi jiedene ijiekui gonjise heshi uwo. ");
INSERT INTO sce_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Gaijiula, tai dundase gou minshentu, Shenlin duruzhi agheli olontu dolon ere kunyi sunghuzhi ene shiqinlai gonjighaye. ");
INSERT INTO sce_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ingiese matan zhomen onxian giezhi pse Hudai kieliende giene.\" ");
INSERT INTO sce_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Kunla man ene kielienyi zanchen giedene Siqifan, Feili, Bologelo, Nijiano, Qimun, Bamina, pse Yutaijiode suisan Anqiya kun Nigelai sunghuwo. Siqifan xianxin giesan gou wo, Shenlinye duruzho. ");
INSERT INTO sce_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Enelai shitulai melie beighase shitula onxian giezhi hhelai jiere khane teiwo. ");
INSERT INTO sce_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Hudai kielien ondazhi Yelusalende tujila zhenzhen olodozho. Tebie olon buwalaye ene xinyanni shunjizho. ");
INSERT INTO sce_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Siqifande Hudai nenjien, nenli olonshi kunlai dunda fugie shiqin, ghudureqi giezho. ");
INSERT INTO sce_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ingiese Ziyutu kunla giezhi urusan huitanni giedun kun bosi ire Siqifanghala jianjinduwo. Enelashi Gulinai, Yalishanda, Jilijia, Yaxiya gochuse irezho. ");
INSERT INTO sce_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Siqifan agheli, Shenlinyi kouizhi kielien kieliese hhela dui dane. ");
INSERT INTO sce_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ingie kunlai baerghala agidene kielieghawo, \"Bijien chenliese SiqifanMusa, Hudaghalai sugiezho.\" ");
INSERT INTO sce_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Hhela bexin, zhanlao, jinwun hanjialai shanjizhi Siqifanyi hhende echighase barei zui fugie fayende irewo. ");
INSERT INTO sce_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Hhela pse jia ganzhen beisan kunlai uru ire kielieghawo, \"Ene kun zhiguitu oronji Musani guijinni sugiezhi ese beizho. ");
INSERT INTO sce_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Bijien chenliese hhe kieliezhi Nasale kun Ersa mechii furaghane, pse Musa matande ogisan guijinni geighane giezho.\" ");
INSERT INTO sce_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Zui fugie fayende sousan kunla man Siqifanni xianxide uzhese ungieni qienxienni ungiei xianli. ");
INSERT INTO sce_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Zui fugie buwa Siqifande asawo, \"Intu shiqin winu?\" ");
INSERT INTO sce_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Siqifan kieliewo, \"Oqio kun, gaijiula, ta chenliendu. Matai xienren IburaheimuHalande soutula Meisobudamiyade bikude famatu Huda hhende xienjighadene kieliewo, ");
INSERT INTO sce_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","'Chi goya oron, jiawusene likai giezhi bi chade uzheghaku oronde echi.'\" ");
INSERT INTO sce_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","\"Ingie hhe Jialeji kunlai oronse likai giedene Halande souwo. Hhei adani fugudene Huda hhei banjighazhi ta ede sousan ene oronde ireghawo. ");
INSERT INTO sce_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ene oronde Huda hhende yama jiachan, lien beiku oronye uye ogiwoma, Huda kielien yenjizhi ene oronyi hhende, hhei houdeide ogizhi caichan gie giewo. Hhe shihoude hhende kewosi uwo. ");
INSERT INTO sce_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ingiese Huda kieliewo, 'Houdeichii kunlai oronde souzhi hoji danlazhi 400 nien zayalane.' ");
INSERT INTO sce_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pse kieliewo, 'Hhelai hoji danlaghasan gojiani bi panjine. Khuinashi hhela khizhedene ene oronde mii shunjine.' ");
INSERT INTO sce_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ingiedene Huda Iburaheimude hetoune giekughala kielien yenjiwo. Iburaheimude Isagheini oluzhi neimudude hetoune giewo. Isagheide Yagebuni oluwo, Yagebude mai 12 gie famatu xienrenlai oluwo.\" ");
INSERT INTO sce_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","\"Ene famatu xienrenla Yusufu jiuni dubiliedene Aijide huiwo. Ingieliuzhe Huda hheghala hhantushi ");
INSERT INTO sce_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","hhei yan kunnanseliuzhe khizheghawo. Huda hhende nenjien, agheli ogise Aijini Falao honshan hhei uzhedan gou wo. Falao hhei Aijide zui fugie noyen danlaghazhi giene man gonjighawo.\" ");
INSERT INTO sce_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","\"Ingiedene Aiji, Jianande honnien kuzhezhi zeinan irewo. Mai xienrenlade taran sirawo. ");
INSERT INTO sce_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yagebu sonosuse Aijide taran wine. Ingie mai xienrenlani peizhi tou 1 hui hhende echighawo. ");
INSERT INTO sce_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","2 huide echise Yusufu gaijiuladene tanighawo. Ingiese Falao hhei gieni qinkonyi mejiewo. ");
INSERT INTO sce_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yusufu kun peizhi adane nie gie kunyi jienlieghale echiwo. Man 75 gie kun wo. ");
INSERT INTO sce_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ingie YagebuAijide bouzhewo. Khuinashi Yagebu, mai xienrenla man hhende duya ijiewo. ");
INSERT INTO sce_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Hhelai laizhi Shijiende echi IburaheimuHamoni houdeilase miengughala agisan mezade bulawo.\" ");
INSERT INTO sce_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","\"Huda Iburaheimude yenjisan kielien kuzhekude Aijide Isilie kunla hende olodowo. ");
INSERT INTO sce_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Khuinashi Yusufui tani dachen nie shini honshan khizhezhi Aijini gonjizho. ");
INSERT INTO sce_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Hhe mai kunlai heizhi xienrenlai mai zayalazho. Hhelai biizhi yeliwalai bendaghazhi aminne ese olughazho.\" ");
INSERT INTO sce_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","\"Hhe shihoude Musani oluwo. Hudai melie hhe uzhezhi seighan wo. Hhei adaini giede ghuran sara qiezhedene ");
INSERT INTO sce_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","bendase Falaoi oqin kewonni giedene qiezhe fugiedaghawo. ");
INSERT INTO sce_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","MusaAiji kunlai unhuani man suruwo. Kielien kielie, shiqin giese nenli wine.\" ");
INSERT INTO sce_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","\"Musa 40 olukude goya Isilie kunlane uzhele echine giezhi jiejin giewo. ");
INSERT INTO sce_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Niefade hhe echikude nie Aiji kun nie Isilie kunyi qifulasanyi chanlasenu hhe Aiji kunyi alazhi hhe kunde bouchou giewo. ");
INSERT INTO sce_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Hhe sumulase Huda hhei tungo giezhi goya kunlai jiuikui mejiemu giezhoma, hhela mejie dazho. ");
INSERT INTO sce_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Khuichudu Musa chanlase Isilie kunla eghinduzho. Hhelai sidaghazhi kieliewo, 'Gujiu, tashi gaijiula wo, yale nieniene qifulane?'\" ");
INSERT INTO sce_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","\"Giebeine qifulasan kun Musai tungu daogha kieliewo, 'Kien chii bijiende lindao, panjichen kun danlaghawo? ");
INSERT INTO sce_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Chi uchughudu hhe Aiji kunyi alaku mutun mii alanu?' ");
INSERT INTO sce_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musa ene kielienyi chenliedene Aijise ghula holu Mijiende toreisan mutun souwo. Hhe oronde hhende ghua kewon oluwo.\" ");
INSERT INTO sce_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","\"40 nien daose Xinaishan hontande nie qienxien siderasan eghesun dunda Musade chanlaghawo. ");
INSERT INTO sce_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musa zhoujin mutunyi chanladene ghanirazhi melie daozhi uzhene giekude Ezhanyi shenqii sonosuwo, ");
INSERT INTO sce_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","'Bishi chii xienrenlai Huda wo. Iburaheimu, Isaghei, Yagebuni Huda wo.' Musa chenliesenu pugharadene ayizhi uzhe dazho. ");
INSERT INTO sce_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ezhan hhende kieliewo, 'Chi kon jieredu maheine tei. Chi beisan oronshi zhiguitu oron wo. ");
INSERT INTO sce_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mii bexinlai Aijide zayalasanyi bi qinchude chanlawo. Hhela shonholosan shenqiiye sonosuwo. Bi hhelai jiuile bouzhewo. Ede ire, bi chii peizhi Aijide echighane.'\" ");
INSERT INTO sce_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","\"Eneshi bexinla kien chii bijiende lindao, panjichen kun danlaghawo giezhi fandui giesan Musa wo. Ingieliuzhe Huda siderasan eghesun dunda qienxienyi tungo giezhi hhei peidene bexinlade noyen, jiuichen danlaghawo. ");
INSERT INTO sce_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","MusaAiji, Hunhai, hontande 40 nien olon fugie shiqin, ghudureqi giezhi bexinlai Aijise uduru khizhewo.\" ");
INSERT INTO sce_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","\"Eneshijiu Isilie kunlade 'Huda tai dundase bi mutun nie xienzhi khizheghane.' giezhi kieliesan hhe Musa wo. ");
INSERT INTO sce_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ene Musa hontandedu Isilie kunlare hhantu wo. Mai xienrenghala hhantu Xinaishan jiere hhende kielien kieliesan qienxienyi tungo giezhi amin ogiku kielienyi jienliedene matande chonjizhi ogiwo.\" ");
INSERT INTO sce_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","\"Mai xienrenla hhei kielienyi ese chenliedene hhei tungu daoghazhi Aijide khareiku duralazho. ");
INSERT INTO sce_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Hhela Hharunede kieliewo, 'Bijiende mo uduruku nigiedalani gie. Bijienyi Aijise uduru khizhesan Musa yan shiqin penji woshi bijien ulie mejiene.' ");
INSERT INTO sce_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ingie hhe shihoude hhela nie fughe giedene hhe nigiedade mure khughozhi goya khaghalane giesanlade beiizhi bayasunduzho. ");
INSERT INTO sce_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ingiese Huda hhelase likai giedene hhela asiman jieredu naran, sara, hodunlai beiise uye gonjizho. Zhen xienzhii shu jiere huaisan mutun, 'Isilie kunla, ta hontande 40 nien dunda zharusan ghoni fugheji pse ogisan mureshi made giesan pusho. ");
INSERT INTO sce_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ta qienliesanshi Molo nigiedani zhanfan wo, Lifan nigiedani hodun wo. Enelashi ta goyala beiine giezhi giesan nigiedala wo. Ingiese bi tai touzhi Babilun ghadane khighane.'\" ");
INSERT INTO sce_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","\"Mai xienrenla hontande bikude ganzhen beiku zhanfan wine. Hheshi Huda Musade fenfuladene uzheghasan yanzi mutun gieghasan wo. ");
INSERT INTO sce_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Mai xienrenla ene zhanfanyi jienliewo. Huda hhelai melie niman kunlai tou khighasan oronde hhela Yeshuyare hhantu zhanfanyi agi echizhi Dawude honshanni shihou kuruwo. ");
INSERT INTO sce_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Huda Dawudede orezho. Ingiese hhe Hudai xiahua giezhi Yagebui houdeilade Huda souku oron zhunbei giene giezhoma, ");
INSERT INTO sce_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Hudade giei beighasanshi Sulumane wo.\" ");
INSERT INTO sce_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","\"Ingiezhoma, Zui Unduni Huda kun khaghalane giesan giede ulie soune. Xienzhi kieliesan kielien mutun wo, ");
INSERT INTO sce_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ezhan kieliewo, 'Asimanshi mii zowi wo. Zeminshi mii bandou wo. Ta made matui gie giene? Khalashi bi hhamuraku oron wo? ");
INSERT INTO sce_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Enelashi man bi khaghalane giesan pushonu?'\" ");
INSERT INTO sce_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","\"Ta ene jianbanjin kunla, zhughe, chighindene hetoune ese giesan kunla. Ta xienrenlane mutun ibeizi Shenlinni fandui giezho. ");
INSERT INTO sce_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Alinie xienzhilai tai xienrenla ese heiwo? Hhela nie gou kun irene giezhi melie kieliesan xienzhilai alawo. Ede ta hhe gou kunni ghudanduzhi alawo. ");
INSERT INTO sce_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ta qienxienla chonjizhi ogisan guijinni jienliedene ese zunjiwo.\" ");
INSERT INTO sce_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Hhela ene kielienyi chenliedene Siqifande hende hokuzhi shidunne zhouzho. ");
INSERT INTO sce_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Siqifande Shenlin duruzhi asimanyi xianxide uzhezhi Hudai fama, pse Ersa Hudai borun miende beisei chanladene kieliewo, ");
INSERT INTO sce_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","\"Asiman keizhi Kunnikewon Hudai borun miende beisei bi chanlawo.\" ");
INSERT INTO sce_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ingiese kunla chighinne duigha fugiede onghonozhi hhei melie chunji echidene ");
INSERT INTO sce_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","hhei chenshi ghadane tungu khigha tashighala eghi qiiwo. Ganzhen beisan kunla jienne teidene nie Saolo giezhi urusan nasuchighan kunyi kon konde jiewo. ");
INSERT INTO sce_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Hhela tashighala eghikude Siqifan onxian giezhi kieliewo, \"Ezhan Ersa, mii ruhherni jienlie!\" ");
INSERT INTO sce_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Pse xiutuliezhi fugiede kieliewo, \"Ezhan, ene zuini hhelade bu sougha!\" Ene kielienyi kieliedene fuguwo. ");
INSERT INTO sce_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Siqifanyi alasande Saolo tunyi giewo. Ene uduse Yelusalenni jiohuii hende heizho. Shitulase chugo psedu tujila sandazhi Yudaya, Samaliyani go oronde echiwo. ");
INSERT INTO sce_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Niezhan xienliantu kunla Siqifanyi buladene hhende oluzhi fugiede wilazho. ");
INSERT INTO sce_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saolo jiohuini heizhi jien kunlai giede orodene ere kun, biereilai bafanzide lai echi khawo. ");
INSERT INTO sce_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Hhe sandasan kunla gochude echizhi Hudai kielienyi chonjizho. ");
INSERT INTO sce_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","FeiliSamaliyai chenshide echizhi kunlade Mexihai chonjizho. ");
INSERT INTO sce_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Olon kunla Feili kieliesan kielienyi chenliezhi giesan ghudureqii uzhedene man hhei kielienyi goude chenliezho. ");
INSERT INTO sce_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Olon kunlai jierese zannan ruhherla fugiede nie onghonodene likai giewo. Pse olon tanhon giesan, dogholonlai goudaghawo. ");
INSERT INTO sce_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ingiese hhe chenshii kunla hende bayasuzho. ");
INSERT INTO sce_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Hhe chenshide nie kunyi nierei Ximun giene. Eqighanse baxi shuaizhi bi hen wo giezho. Samaliyai bexinlai ghaniraghazho. ");
INSERT INTO sce_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Bugon fugiei ganii man hhei daghazhi ene kunshi fugie nenlitu giezhi urusan Hudai nenli wo giezho. ");
INSERT INTO sce_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Hhela hhei chenliekushi hhe oloncha baxi shuaizhi hhelai ghaniraghazho. ");
INSERT INTO sce_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ingiekude Feili hhelade Hudai gojiai gouxioxi, Ersa Mexihai nierei chonjise hhela xianxin giezhi ere kun, biereila xili jienliewo. ");
INSERT INTO sce_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Lien Ximunye xianxin giedene xili jienliewo. Hhe Feilighala chan hhantulazhi Feili giesan ghudureqi, fugie nenlitu shiqinlai uzhedene ghanirazho. ");
INSERT INTO sce_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Shitula Yelusalende bikude chenliese Samaliya kunla Hudai kielienyi jienliewo giese BeduruYaheiyaghalai hhelai hhende echighawo. ");
INSERT INTO sce_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Hheghala boudene hhelade Shenlinyi jienlieghane giezhi onxian giezho. ");
INSERT INTO sce_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Shenlin kiemai jiere ese bouzhezho. Hhela zinie Ezhan Ersai niereghala xili jienliezho. ");
INSERT INTO sce_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","BeduruYaheiyaghala hhelai jiere khane teise hhela Shenlinyi jienliewo. ");
INSERT INTO sce_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Shitula khane teise Shenlin bouzhesei Ximun chanladene baerne hhelade ogizhi ");
INSERT INTO sce_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","kieliewo, \"Ene nenlii madeye ogi. Bi kienyi jiere khane teizhi onxian giese kienye Shenlinyi jienliene.\" ");
INSERT INTO sce_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ingiese Beduru kieliewo, \"Chi baerghalane hhantu fugule echi. Chi sumulase Huda ogiku nenjienni baerghala aginu? ");
INSERT INTO sce_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ene wiliede chade guzi uwo. Hudai melie chii zhughe donzhen uwo. ");
INSERT INTO sce_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Chi ene doghunnii geizhi Ezhanni xiahua gie. Kenen chi zhughedene sumulasei mienliene. ");
INSERT INTO sce_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Bi uzhese chii zhughede dubilieku olon wo, gou wini chii banlazho.\" ");
INSERT INTO sce_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ingiese Ximun kieliewo, \"Ta made oluzhi Ezhanni xiahua gie. Ingiese ta kieliesanla mii jiere nieda ulie irene.\" ");
INSERT INTO sce_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","BeduruYaheiyaghala Ezhanyi kielienni kieliezhi ganzhen beidene Yelusalende khareiwo. Idou mo jiere Samaliyani go aghinlade gouxioxii chonjizho. ");
INSERT INTO sce_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ingiekude Ezhanni qienxien Feilide kieliewo, \"Chi bosidene nanbangiede yo. Yelusalense Jiasade bouku mo jiere echi.\" Hhe mo hontande wo. ");
INSERT INTO sce_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Feili bosizhedene echise mo jiere nie Aisaiebiya kunyi chanlawo. Ene kunshi Aisaiebiya bierei honshan Gandajini kha douradu taijien wo. Hheshi bierei honshanni baerlai man gonjisan fugie noyen wo. Yelusalende libai giezhi irezho. ");
INSERT INTO sce_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Khareiku mo jiere mache souzhi xienzhi Isaiyai shuni onshizho. ");
INSERT INTO sce_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Shenlin Feilide kieliewo, \"Chi gierudene chezii shigha.\" ");
INSERT INTO sce_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Feili holuzhi echise xienzhi Isaiyai shuni onshisei sonosuwo. Ingie hhende asawo, \"Chi onshisanne dunjirenu?\" ");
INSERT INTO sce_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Hhe kieliewo, \"Mii kiema ese uduruzho, bi matugie dunjirene?\" Ingie Feilii chezi jierene uru khirei hhantu souwo. ");
INSERT INTO sce_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Hhe onshisan jinwun jiere kieliezho, \"Hhei ghoni zharuchen kun shida echiku ghoni mutun lai echiwo. Usun ghighachen kunni kha douradu qioqioji ghoni mutun hhe amanne ese angheiwo. ");
INSERT INTO sce_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Kunla hhei uru giezho, gundande ese panjiwo. Hhei aminni duyase agi echiwo. Kunlade kielieku houdeiye uwo.\" ");
INSERT INTO sce_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Taijien Feilide kieliewo, \"Bi nie asaye, xienzhi kieliesan ene kielienshi kienyi kieliezho? Goyane kieliezhou? Pse nie kunyi kieliezho?\" ");
INSERT INTO sce_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Feili ene jinwunse kaishi giezhi hhende Ersai gouxioxii jianji qiiwo. ");
INSERT INTO sce_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Hhela mo jiere yokude usu winetu oronde kuruwo. Taijien kieliewo, \"Uzhe, enende usu wine. Bi enende xili jienliese ulie olunu?\" ");
INSERT INTO sce_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ingie fenfulazhi chezii beighadene Feili taijienghala usude bouzhi Feili hhende xili gieghawo. ");
INSERT INTO sce_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ususe khizhese Ezhanyi Shenlin Feilii uduru yolawo. Taijien hhei chanla dawo. Ingiedene bayasuzhi mone yowo. ");
INSERT INTO sce_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ingie Feilii Yasodude chanlawo. Hhe yozhi go chenshilade gouxioxii chonjizhi izhi Kaisaliyade kuruwo. ");
INSERT INTO sce_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saolo izhigie Ezhanyi tujilai alane giezhi ayighazho. Ingie zui fugie buwai hhende echidene ");
INSERT INTO sce_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Damashigeni go huitande echiku xinni kerewo. Ene daolini daghasan kunyi faxien giese bugon bierei ere kun barei Yelusalende lai echine giezho. ");
INSERT INTO sce_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Saolo mo jiere yozhi Damashigede kurukude menzhali asiman jierese gonqi faizhi hhei simiende zhouizho. ");
INSERT INTO sce_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ingie hhe zemin jiere fura bouwo. Sonususe nie shenqi hhende kieliewo, \"Saolo! Saolo! Chi mii yale heine?\" ");
INSERT INTO sce_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Hhe kieliewo, \"Ezhan, chishi kien wo?\" \"Bishi chi heisan Ersa wo. ");
INSERT INTO sce_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Chi bosizhedene chenshide echi. Hhende matui giekui chade kieliene.\" ");
INSERT INTO sce_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Hhantu yosan kunla shenqii sonosuzhoma kunni chanla dase beidene kielien kielie dazho. ");
INSERT INTO sce_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saolo zemin jierese bosise nudunne niewoma, yama chanla dane. Kunla hhei khase lai Damashigede echiwo. ");
INSERT INTO sce_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ghurudu chanla dadene yama ese ijiezhi ese ochiwo. ");
INSERT INTO sce_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damashigede nie tuji wine. Niereini Yananiya giene. Ezhan zhoujin mutun xienjighazhi hhende kieliewo, \"Yananiya.\" Hhe kieliewo, \"Ezhan, matugiewo?\" ");
INSERT INTO sce_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ezhan hhende kieliewo, \"Chi bosizhedene Dondonji giezhi urusan geidoude echizhi Yudai giede nie Dashu kunyi erei. Niereini Saolo giene. Hhe zhen onxian giezho. ");
INSERT INTO sce_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Hhe zhoujin mutun chanlase Yananiya giesan nie kun oro iredene hhei jiere khane teise goudawo.\" ");
INSERT INTO sce_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ingiese Yananiya kieliewo, \"Ezhan, bi sonosuse ene kun Yelusalende chii shentulade olon doghun shiqin giezho giezhi olon kunla kieliezho. ");
INSERT INTO sce_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Hhe pse fugie buwalase chii beiisan jien kunlai bareiku qienlii kere enende irezho.\" ");
INSERT INTO sce_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ingiese Ezhan hhende kieliewo, \"Chi echi. Hheshi niman kun, honshan, Isilie kunlade bi nierene chonjighane giezhi sunghusan rencai wo. ");
INSERT INTO sce_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Hhe mii nierede bixi olon ku shoukui bi hhende mejieghane.\" ");
INSERT INTO sce_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ingiese Yananiya echidene hhei giede orowo. Khane Saoloi jiere teizhi kieliewo, \"Saolo gaijiu, chi ireku mo jiere chade chujiegheghasan Ezhan Ersa mii ireghakushi chii pse chanlaghazhi chade Shenlin durughane giezho.\" ");
INSERT INTO sce_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ingiese Saoloi nudun jierese deigo zhaghasun arasun mutun nie dunxi bou irese hhe chanlawo. Ingiedene bosi ire xili jienliewo. ");
INSERT INTO sce_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ijiewuni ijiedene lilian orowo. SaoloDamashigeni tujilare hhantu giedudu souzhi ");
INSERT INTO sce_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","deigo Ersashi Hudai kewon wo giezhi go huitanlade chonjizho. ");
INSERT INTO sce_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Jien ene kielienyi chenliesan kunla man ghaniradene kieliewo, \"Ene kunshi Yelusalende Ersai beiisan kunlai heisan hhe kun pushonu? Hhe enende irezhi hhelai bareidene fugie buwalade ogine ese giezhou?\" ");
INSERT INTO sce_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saolode yebeiseye nenli olodozhi Ersashi Mexiha bikui zhenmin giese Damashigeni Yutai kunlai kielie beighawo. ");
INSERT INTO sce_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ezighancha daose Yutai kunla Saoloi alane giezhi shanlian giezho. ");
INSERT INTO sce_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Hhela alane gieku jihuai kunla Saolode mejieghawo. Hhela xieni udu chenshi wijiende sagheizhi hhei alane giezho. ");
INSERT INTO sce_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Nie xiidei hhei tujila nie lanlande hhei orogha chenqian jierese jiuzhilie bouzheghawo. ");
INSERT INTO sce_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","SaoloYelusalende kuzhedene psedu tujilare hhantulane giezhoma, hhe tuji gholusei xianxin gie dase hhela man ayizho. ");
INSERT INTO sce_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ingiese Banaba hhei jienliedene uduruzhi shitulai shida echiwo. Hhe mo jiere matugiezhi Ezhanyi chanlasei, Ezhan hhende kielien kieliesei, hhe Damashigede danzine fugiedaghazhi Ersai niereghala jianjisei man kieliewo. ");
INSERT INTO sce_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ingiedene SaoloYelusalende tujilare hhantulazhi ziyude yozho. Ezhanyi niereghala danzine fugiedagha kieliezho. ");
INSERT INTO sce_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Hhe pse Xila kielien kieliechen Yutai kunlare kieliezhi jianjinduzho. Ingiese hhela Saoloi alane giezho. ");
INSERT INTO sce_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Gaijiula enei mejiedene hhei Kaisaliyade khughozhi boughadene Dashude echighawo. ");
INSERT INTO sce_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ingiekude Yudaya, Jialili, Samaliyai gochudedu jiohui man pinnanshizhi hendawo. Hhela Ezhanyi zunjizhi giezho. Shenlin hhelai bayasughazho. Ingiese xianxin giesan kunla yebeiseye olodozho. ");
INSERT INTO sce_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Beduru gochude yokude Lida oronde sousan shentulai hhende echiwo. ");
INSERT INTO sce_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Hhende Iniya giesan nie kunni chanlawo. Tanhon giezhi ruzi jiere 8 nien kijiezho. ");
INSERT INTO sce_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Beduru hhende kieliewo, \"Iniya, Ersa Mexiha chii goudaghawo. Bosizhedene ruzine shidolo agi!\" Ingiese hhe deigo bosi irewo. ");
INSERT INTO sce_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Jien Lida, Shalunde sousan kunla hhei chanladene man Ezhanyi shunjiwo. ");
INSERT INTO sce_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Yepade nie oqitu tuji wo. Niereini Dabida giene, Xila kielienghala kieliese Dojia giene, isishi lugo wo. Hhe chanqi gounii giezhi nanxin kunlade banman giezho. ");
INSERT INTO sce_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Hhe shihoude hhe giemere fuguse kunla beyeini waghadene lou jiere teiwo. ");
INSERT INTO sce_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","LidaYepaghala chada wo. BeduruLidade bikui tujila sonosusenu ghua kunyi peizhi echighadene xiahua giezhi danwu bu giezhi bijienyi hhende ghujighan yo giezho. ");
INSERT INTO sce_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Beduru qiizhi hhelare hhantu kuruse kunla uduru lou jiere khireiwo. Olon guafu biereila Bedurui kanzide beidene wilazhi Dojia hhelare hhantu bikude giesan lizii jien, mienzii jienlai uzheghawo. ");
INSERT INTO sce_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Beduru kunlai man kieliezhi ghadane khighadene xiutuliezhi onxian giewo. Ingie fugusan kunyi miende ochiradene kieliewo, \"Dabida, bosizhe!\" Ingiese hhe nudunne nie Bedurui chanla bosi ire souwo. ");
INSERT INTO sce_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Beduru khaghalane hhei fui bosighawo. Ingie shentulai, guafulai uru orozhe, Dojiai amitu hhelade jiuizhi ogiwo. ");
INSERT INTO sce_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ene shiqin Yepade man chonji kurudene olon kunla Ezhanyi xianxin giewo. ");
INSERT INTO sce_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Khuinashi BeduruYepani nie arasun giesan Ximunyi giede ezighancha souwo. ");
INSERT INTO sce_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kaisaliyade nie kunyi niereini Geniliu giene. Hheshi Idali buduitonni baifuzhan wo. ");
INSERT INTO sce_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Hheshi nie xienliantu kun wo. Nie gie kunlai man Hudai zunjizho. Da nanxin kunlade olon banman giezhi Hudase chan onxian giezho. ");
INSERT INTO sce_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Niudude xiawu 3 jien olukude hhe zhoujin mutun qinchude chanlase Hudai nie qienxien oro ire Geniliu giezhi uruwo. ");
INSERT INTO sce_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Geniliu xianxide nie uzhe ayizhi kieliewo, \"Ezhan, yan shiqin wo?\" Qienxien kieliewo, \"Chi onxian giesan, nanxin kunlade banman giesanla Hudai melie echizhi jilawo. ");
INSERT INTO sce_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ede chi kun peizhi Yepase Beduru giesan Ximunni xinlazhi ire. ");
INSERT INTO sce_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Hhe nie arasun jiagun giesan Ximunyi giede souzho. Gieni haibienzide wo.\" ");
INSERT INTO sce_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Hhende kielien kieliesan qienxien yoladene Geniliu giene ghua hojini, pse hhei chan ushilasan nie xienliantu buduini uru ire ");
INSERT INTO sce_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ene shiqinyi man kieliezhi ogidene peizhi Yepade echighawo. ");
INSERT INTO sce_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Khuichudu hhela yozhi hhe chenshide kurukude Beduru zhunwude gie jiere onxian giele khireiwo. ");
INSERT INTO sce_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Hhe oliesuzhi ijiene giezho. Kunla ijiuni zhunbei giekude Beduru zhoujin mutun nie ghudureqi chanlase ");
INSERT INTO sce_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","asiman keizhi hoxian nie fugie popu mutun dunxi bouzhewo. Jieran gozii banladene zemin jiere bou irewo. ");
INSERT INTO sce_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Hhe sudoro zemin jieredu yanyanji jieran zhuazhuatu chushen, ghughei, pse asiman jiere musisanla wine. ");
INSERT INTO sce_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Nie shenyin irezhi hhende kieliewo, \"Beduru, bosizhedene ala ijie.\" ");
INSERT INTO sce_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ingiese Beduru kieliewo, \"Ezhan, ulie olune. Ganjin wini, zannannilai bi ijiezhi ese daozho.\" ");
INSERT INTO sce_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","2 hui shenyin pse hhende kieliewo, \"Huda ganjin wo giesanni chi ganjin uwo giezhi bu kielie.\" ");
INSERT INTO sce_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ingiezhi ghureifashi hhe dunxilai deigo asiman jiere agi khireiwo. ");
INSERT INTO sce_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Beduru zhoujin mutun chanlasanshi yan isi wo giezhi zhughedene zhen sumulakude Geniliu peisan kunla asazhi Ximunyi gieni wijien konde beizho. ");
INSERT INTO sce_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Hhela waradazhi, \"Beduru giesan Ximun enende souzhoye?\" giezhi asazho. ");
INSERT INTO sce_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Beduru dou zhoujin mutun chanlasei sumulakude Shenlin hhende kieliewo, \"Ghuran kun chii ereizho. ");
INSERT INTO sce_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Bosi, boudene yama bu sumulazhi hhelare hhantu echi. Hhelashi bi ireghasan wo.\" ");
INSERT INTO sce_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ingiese Beduru boudene hhelade kieliewo, \"Bishi ta ereisan kun wo. Ta yangiezhi irezho?\" ");
INSERT INTO sce_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Hhela kieliewo, \"Baifuzhan Geniliushi Hudai zunjisan nie gou kun wo. Yutai kunla man hhei zunzhun giene. Nie zhiguitu qienxien hhende kieliezhi chii xinlazhi giedene iredene chi jianjisei chenlie giezho.\" ");
INSERT INTO sce_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Beduru hhelai uruzhi oro nie xii soughawo. Khuichudu zhunbei gie hhelare hhantu echiwo. Yepani giedun gaijiulaye hhantu echiwo. ");
INSERT INTO sce_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Pse niudude hhela Kaisaliyade kuruwo. Geniliu qingu, gou zhanlienlane uruzhi ire hhelai sagheizho. ");
INSERT INTO sce_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Beduru orone giekude Geniliu hhei jienliedene kon kondeni papalazhi beiiwo. ");
INSERT INTO sce_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Beduru hhei fei bosigha kieliewo, \"Bosizhe. Bishiye nie kun wo.\" ");
INSERT INTO sce_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Beduru hheghala kielienduzhi orose olon kunla hhantulasei chanlawo. ");
INSERT INTO sce_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ingie hhelade kieliewo, \"Bijien Yutai kun niman kunghala laiwon giezhi hhantulase ese olusei ta goyane mejienema, yan kunyiliuzhe ganjin uwo, zannan wo giezhi kieliese ese olusei Huda made uzheghawo. ");
INSERT INTO sce_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ingiese ta mii xinlakude bi tuichi ese giezhi irewo. Ede bi tande asaye, ta mii yan shiqinde xinlazho?\" ");
INSERT INTO sce_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Geniliu kieliewo, \"Jierudu melie ene shihoude bi giedene onxian giezho. Xiawu 3 jiende wo. Menzhali nie rouiku jien musisan kun mii melie beidene ");
INSERT INTO sce_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","kieliezho, 'Geniliu, chi onxian giesan, nanxin kunlade banman giesanlai Huda chenliezhi jilawo. ");
INSERT INTO sce_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ingiese chi kun peizhi Yepase Beduru giesan Ximunyi xinlazhi ire. Hhe haibienzini nie arasun jiagun giesan Ximunyi giede souzho.' ");
INSERT INTO sce_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ingiese bi deigo kun peizhi chii xinlaghale echiwo. Chi irese gou wo. Ede bijien Ezhan chade fenfulasan kielienlai man chenliene giezhi Hudai melie hhantulazho.\" ");
INSERT INTO sce_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ingiese Beduru kielie qiiwo, \"Huda kunlade pienxin ulie giekui bi shuhua mejiewo. ");
INSERT INTO sce_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Alinie gojiai kunlaliuzhe Hudai zunjizhi olusei giese Huda jienliene. ");
INSERT INTO sce_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Taye mejieku mutun Huda yanyanjini Ezhan Ersa Mexihani tungo giezhi pinnantu gouxioxi daolini Isilie kunlade chonjizhi ogiwo. ");
INSERT INTO sce_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Yaheiya xili giekui jianjizhi daodene ene daolii Jialilise kaishi giezhi Yudaya go oronlade chonji kuruwo. ");
INSERT INTO sce_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nasale kun Ersade Huda Shenlin, nenlini olon ogiwo. Huda hheghala hhantushi hhe gochude yozhi gouni giezho. Ibilisi heisanlai man uzhezhi goudaghawo. ");
INSERT INTO sce_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Bijien hhe kun Yutai kunni oronde, Yelusalende giesan shiqinlade ganzhen beine. Kunla hhei mutun jiere guaidene alawo. ");
INSERT INTO sce_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ghurudude Huda hhei aminne olughazhi kunlade chanlaghawo. ");
INSERT INTO sce_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Soyuji kunlade ese chanlaghazhi zinie Huda sunghuzhi hhende ganzhen beighane giesan bijiende chanlaghawo. Bijienshi hhe fugusan kun dundase aminne oludene hhere hhantu ijiezhi ochisan kun wo. ");
INSERT INTO sce_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Hhe bijiende fenfulazhi kunlade ene daolii chonji giewo. \"Hheshijiu Huda sunghuzhi amitu kun, fugusan kunyi panjichen wo.\" giezhi ganzhen bei giezho. ");
INSERT INTO sce_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Xienzhila man hhende ganzhen beizhi kieliewo, 'Hhei xianxin giesan kunla hhei niereghala zuini mienliene.'\" ");
INSERT INTO sce_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Beduru kielien kieliekude daoli chenliesan jien kunlai jiere Shenlin bouzhewo. ");
INSERT INTO sce_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Bedurughala hhantu iresan Yutaini Mexihai xianxin giesan kunla Shenlinni nenjien niman kunlai jiere kie bouzhese ghanirakushi ");
INSERT INTO sce_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","hhela pseshiku kielienyi kieliezhi Hudashi fugie wo giezhi doulasei sonosuzho. Ingiese Beduru kieliewo, ");
INSERT INTO sce_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","\"Enezighan kunla bijien mutun Shenlinyi jienliewo. Ede usughala hhelade xili gieghase kien danla shidane?\" ");
INSERT INTO sce_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ingie fenfulazhi Ersa Mexihai niereghala hhelade xili gieghawo. Hhela pse Bedurui danlazhi giedudu soughawo. ");
INSERT INTO sce_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Niman kunla Hudai kielienyi jienliesei shitula, Yudayani gaijiula sonosuwo. ");
INSERT INTO sce_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","BeduruYelusalende echise Yutaini Mexihai xianxin giesan kunla hhei sugiezhi kieliewo, ");
INSERT INTO sce_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","\"Chi hetoune ese giesan kunlai giede echizhi dou hhelare hhantu ijiene?\" ");
INSERT INTO sce_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ingiese Beduru ene shiqinni hhelade qiqiji kieliewo, ");
INSERT INTO sce_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","\"Bi Yepa chenshide onxian giekude zhoujin mutun nie ghudureqi chanlase hoxian nie fugie popu mutun dunxi bouzhezhi jieran gozii banlazho. Asiman jierese bouzhe mii melie irewo. ");
INSERT INTO sce_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Bi xianxide uzhese sudoro zemin jieredu jieran zhuazhuatu chushen, yewo, ghughei, pse asiman jiere musisanla wine. ");
INSERT INTO sce_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Bi sonosuse nie shenyin made kieliewo, 'Beduru, bosizhedene ala ijie.' ");
INSERT INTO sce_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ingie bi kieliewo, 'Ezhan, ulie olune. Ganjin wini, zannannila mii amande orozhi ese daozho.' ");
INSERT INTO sce_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","2 hui shenyin asiman jierese kieliewo, 'Huda ganjin wo giesanni chi ganjin uwo giezhi bu kielie.' ");
INSERT INTO sce_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ingiezhi ghureifashi man asiman jiere agi khireiwo. ");
INSERT INTO sce_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Zhen qingiekude Kaisaliyase mii xinlaghale iresan ghuran kun bijien sousan gie konde beizho. ");
INSERT INTO sce_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Shenlin made fenfulazhi yama bu sumuladene hhelare hhantu echi giewo. Ingiese ene zhighon gaijiu mare hhantu echizhi bijien Geniliui giede orowo. Hhe bijiende kieliewo. ");
INSERT INTO sce_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Geniliu matugiezhi nie qienxienyi chanladene hhei giede beizhi chi kun peizhi Yepase Beduru giesan Ximunyi xinlazhi ire. ");
INSERT INTO sce_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Hhe chii nie gie kunlai jiuiku daolii chade kieliene giesan kielienyi bijiende kieliewo. ");
INSERT INTO sce_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Bi dei jianji qiise Shenlin hhelai jiere bouzhewo. Eqighandei matanyi jiere bouzhesan niekielien wo. ");
INSERT INTO sce_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ingiese Yaheiya usughala xili gieghawoma, tai Shenlinghala xili gieghane giesan Ezhanyi kielienyi bi sumula irewo. ");
INSERT INTO sce_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Huda hhelade ogisan nenjien matan Ezhan Ersa Mexihai xianxin giekude matande ogisan nenjienghala niekielien wo. Bishi kien wo? Hudai duii shidanu?\" ");
INSERT INTO sce_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Hhela ene kielienyi chenliedene yama ese kieliezhi qinse Huda niman kunladeye geizhen giezhi amin ireku jihui ogiwo giezhi Hudai kuaizho. ");
INSERT INTO sce_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ene shihoude Siqifanni shiqin jiere biisan kunla sandazhi Feiniji, Saipulusi, Anqiyade echidene zinie Yutai kunlade Hudai kielienyi jianjizhoma, ");
INSERT INTO sce_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Saipulusi, Gulinaise iresan niezhan kunla Anqiyade kurudene Xila kunladeye Ezhan Ersai gouxioxii jianjizho. ");
INSERT INTO sce_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ezhanni nenli hhelare hhantushi Ezhanyi xianxin giezhi shunjisan kun olonnudazho. ");
INSERT INTO sce_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ene xioxi Yelusalenni jiohuii kunlai chighinde echiwo. Ingie hhela Banabai peizhi Anqiyade echighawo. ");
INSERT INTO sce_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Hhe kurudene Hudai nenjienyi chanla bayasuzhi kunlade khidunde beidene izhi Ezhanni koui giezhi sughazhi kieliezho. ");
INSERT INTO sce_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabashi nie gou kun wo. Hhende Shenlin duruzhi Hudade kouiku xianxin gieku fugie wo. Ingiese olon kunla Ezhande shunjiwo. ");
INSERT INTO sce_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Hhe Dashuse Saoloi ereile echi, ");
INSERT INTO sce_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ereizhi oludene uduru Anqiyade echiwo. Hhe ghuala duduji niehon hhe oronni jiohuini kunlaghala hhantulazhi olon kunlade surughazho. Tujilai Anqiyase tou 1 hui Mexihani tuji giezhi uruzhi qiizho. ");
INSERT INTO sce_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Hhe xienzide giedun xienzhila Yelusalense Anqiyade bouzhi irewo. ");
INSERT INTO sce_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Hhelai dundadu nie kunyi niereini Yajiabu giene. Bosi iredene duya jiere honnien kuzhene giezhi Shenlinyi tungo giezhi melie kieliewo. Ene shiqin Kelaoji gonjiku shihoude fashen giewo. ");
INSERT INTO sce_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ingiese tujila zhao goyane nenlighala Yudayade sousan gaijiulade baer khughozhi echighane giezhi jiejin giewo. ");
INSERT INTO sce_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Hhela baerni ghuradene BanabaSaolo ghualai peizhi zhanlaolai hhende khughozhi echighawo. ");
INSERT INTO sce_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Hhe shihoude Hherode honshan jiohuini niezhan kunlai heiwo. ");
INSERT INTO sce_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Khudoghoghala Yaheiyani gaii Yagebui alawo. ");
INSERT INTO sce_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Hhe uzhese Yutai kunla ene shiqinde xiqishi Beduruiye bareighale echiwo. Hheshi zhen Tanmien Jieni udu wo. ");
INSERT INTO sce_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Bedurui barei agi bafanzide khadene jieran duini buduilade uzheghazho. Nie duide jieran kun wo. Jiulidaosan Jie daose bexinlai melie hhei panjine giezho. ");
INSERT INTO sce_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Bedurui bafanzide khase jiohuini kunla hhende oluzhi Hudase hende onxian giezho. ");
INSERT INTO sce_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","HherodeBedurui panjiku meliedu xii, Bedurui ghua qieshenghala sozilazhi ghua buduini dunda kijieghazho. Sagheisan kunla bafanzi wijien ghadane sagheizho. ");
INSERT INTO sce_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Menzhali Ezhanyi qienxien xienjighazhi bafanzi sudoro gon zhouizho. Qienxien Bedurui lebadei peizhi xiereigha kieliewo, \"Ghujighan bosizhe.\" Ingie qieshen hhei kha jierese anda bouwo. ");
INSERT INTO sce_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Yodaine banlazhi maheine musi giezhi qienxien hhende kieliese hhe qingiezhi giewo. Qienxien pse kieliewo, \"Jienne musidene mii dagha.\" ");
INSERT INTO sce_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Beduru khizhedene hhei daghawo. Qienxien giesanshi zhenni bikui mejie dazho, zhoujin wo giezho. ");
INSERT INTO sce_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Bafanzii ji 1 gon ji 2 gonyi daodene chenshide khireiku qieman shida irese hhe wijien goyane niewo. Hhela khizhedene nie moni yozhi daose qienxien deigo hhense likai giewo. ");
INSERT INTO sce_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Beduru minbairedene kieliewo, \"Ede bi zhenzhenji mejiewo. Ezhan qienxienne peizhi mii Hherodei khase, Yutai kunlai xiwon giesanse jiuizhi khizhewo.\" ");
INSERT INTO sce_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Beduru nie sumuladene Mereiyeni giede echiwo. Hheshi Make giesan Yaheiyai anani wo. Hhende olon kunla hhantulazhi onxian giezho. ");
INSERT INTO sce_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Beduru wijienyi nie eghise Loda giesan nie hoji oqin wijien niele irewo. ");
INSERT INTO sce_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Hhe Bedurui shenqii mejiedene bayasuzhi wijienyi ese nie, holuzhi echi kunlade kieliewo, \"Beduru wijien ghadane beizho!\" ");
INSERT INTO sce_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Hhela kieliewo, \"Chi fenjiulizho!\" Hoji oqin izhigie kieliezho, \"Hhe enbene!\" Hhela kieliezho, \"Hheshi Bedurui qienxien wo.\" ");
INSERT INTO sce_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Beduru ese beidene wijienyi eghizho. Hhela wijienyi niedene chanlase ghanirazho. ");
INSERT INTO sce_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Beduru khane zhadeighazhi hhelai shenqi bu khizhe giezho. Ingie hhelade Ezhan matugiezhi hhei bafanzise uduruzhi khizheghasei kieliewo. Pse ene shiqinni Yagebu psedu gaijiulade kielie giedene khizhe, psedu oronde echiwo. ");
INSERT INTO sce_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ogheidene buduila londundunde Beduru khala echisei mejie dazho. ");
INSERT INTO sce_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Hherode hhei ereizhi olu dase sagheisan kunlade asadene hhelai ala giezhi fenfulawo. Khuinashi HherodeYudayase likai gie Kaisaliyade bouzhi hhende souwo. ");
INSERT INTO sce_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Hherode honshan Tuilo kun, Xidun kunlade hokuzho. Ene ghua oronni kunla honshanni oronse taran ijiezho. Ingie honshanni giei gonjisan Bolasidui kielie shundaghadene hhantu Hherodei ochirale echi goudane giezhi xiahua giezho. ");
INSERT INTO sce_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Jinjisan udude Hherode honshan jienne musi wizi jierene souzhi kunlade jianjizho. ");
INSERT INTO sce_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ingiese bexinla waradazhi kieliezho, \"Eneshi kunni shenqi pusho, hudai shenqi wo!\" ");
INSERT INTO sce_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Hherode kunla kuaikui Hudade ese ogise Ezhanyi qienxien deigo faizhi ghugheighala zhou alaghawo. ");
INSERT INTO sce_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Hudai kielien yebeiseye ondazhi xianxin giesan kunla olodozho. ");
INSERT INTO sce_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","BanabaSaologhala renwune onchen giedene Make giesan Yaheiyai uduru Yelusalende khareiwo. ");
INSERT INTO sce_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Anqiyani jiohuide giedun xienzhi, loushi wine. Banaba, heiren giesan Ximien, Gulinai kun Luqiu, Hherode onghala hhantu fugiedasan Manien, pse Saolo wo. ");
INSERT INTO sce_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Hhela Ezhanyi beiizhi orozo bareikude Shenlin kieliewo, \"Ta BanabaSaoloi sunghudene made jie. Bi hhelai uruzhi wiliene gieghane.\" ");
INSERT INTO sce_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ingie hhela orozo bareizhi onxian giedene hhelai jiere khane teizhi peizhi echighawo. ");
INSERT INTO sce_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Hhelai Shenlin peizhi Xiliujide boughadene hhense chon souzhi Saipulusi daode kuruwo. ");
INSERT INTO sce_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Hhende Salami geidoude echi Yutai kunlai huitanlade Hudai kielienyi jianjizho. Yaheiya hhelade banman giezho. ");
INSERT INTO sce_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Hhela Saipulusi nie daoni yozhi zuihoude Pafude irewo. Hhende nie fashu shuaisan kunyi penjiwo. Hheshi nie xienzhii maochun giesan Yutai kun wo. Niereini Bayesu giene. ");
INSERT INTO sce_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Hhe kun Shiqiu-Baolo giesan zunlighala jiodao daizho. Shiqiu-Baoloshi nie aghelitu kun wo, hhe BanabaSaologhalai xinlazhi ire Hudai kielienyi chenliene giezho. ");
INSERT INTO sce_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","IlimaBanabaSaologhalai jiohorozhi zunlii ene xinyanni ulie xianxin gieghane giezho. Ilimai isishi fashu shuaisan kun wo. ");
INSERT INTO sce_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Baolo giesan Saolode Shenlin durudene hhei aralazhi kieliewo, ");
INSERT INTO sce_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","\"Chishi Ibilisini kewon wo. Chi yanyanji gounii fandui giezho. Chade yanyanji piendakui doghunni duruzho. Chi Ezhanni zhendaoni wirulaghakui da ulie beinu? ");
INSERT INTO sce_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ede Ezhan chii faise chi sugho gholuzhi zhanshi jiere naranyi chanla dane!\" Ingiese nudunni deigo borolozhi kharaladene simiendene moqioluzhi mo uduruku kun ereizho. ");
INSERT INTO sce_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Zunli ene fashen giesan shiqinyi chanladene Ezhanyi daoli ghudure wo giezhi xianxin giewo. ");
INSERT INTO sce_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Baolotan Pafuse chon souzhi Panfeiliyani Biejiade irewo. Yaheiya hhelase likai gie Yelusalende echiwo. ");
INSERT INTO sce_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Baolotan Biejiase likai giedene yozhi Bixijini Anqiyade irewo. Hhamuraku udude huitande orozhi souwo. ");
INSERT INTO sce_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Guijinshu, xienzhishui onshi baraghadene huitan gonjisan kunla kun peizhi hhelade kielieghawo, \"Gaijiula, kunlade yan surughaku kielien bise kielie.\" ");
INSERT INTO sce_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ingie Baolo bosizhe khane nie zhadeigha kieliewo, \"Isilie kunla, pse Hudai zunjisan niman kunla, chenliendu! ");
INSERT INTO sce_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ene Isilieni Huda mai xienrenlai sunghuzho. Hhela Aijide soukude Huda hhelai hendaghazhi fugie nenlighalane Aijise uduruzhi khizhewo. ");
INSERT INTO sce_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Hontande hhelai 40 nien rennai giezho. ");
INSERT INTO sce_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Jianan oronni dolon minzui widaghazhi hhe oronyi hhelade ogiwo. ");
INSERT INTO sce_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Enezighan shiqinla chabudu 450 nien olune. Khuinashi Huda hhelade panjiku noyen ogizhi izhi Samuer xienzhii shihou kuruwo. ");
INSERT INTO sce_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ene shihoude hhela Hudase nie honshan kerewo. Ingie Huda Bienyamin pai dundadedu Jishini kewon Saoloi hhelade 40 nien honshan danlaghawo. ");
INSERT INTO sce_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ingie Saoloi widaghadene Dawudeni hhelade honshan danlagha, hhende oluzhi kieliewo, 'Bi ereisan Yexini kewon Dawude made talazho. Hhe mii jihuai chengun olughane.'\" ");
INSERT INTO sce_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","\"Huda dain giesan mutun Dawudeni houdeise Isilie kunlade nie jiuichen Ersai khizheghawo. ");
INSERT INTO sce_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Hhe iretula Yaheiya jien Isilie kunlade, \"Geizhen giedene xilini jienlie.\" giezhi chonjizho. ");
INSERT INTO sce_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yaheiya renwune onchen giekude kieliewo, 'Ta sumulase bishi kien wo? Bishi hhe pusho. Hhe mii khuinase irene. Bi hhende mahei deizi andaghaseye pei dane.'\" ");
INSERT INTO sce_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","\"Gaijiula, Iburaheimuni houdeila, pse Hudai zunjisan niman kunla, ene jiuiku daolishijiu matande ogisanwo. ");
INSERT INTO sce_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Yelusalende sousan kun, hhelai lindaola Ersai tani dazho. Hhela niefanie hhamuraku udude onshisan xienzhii kielienyi dunjire dazhi Ersade zui jinjise xienzhila kieliesan mutun gholuwo. ");
INSERT INTO sce_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Hhende yama fuguku zui ereizhi oludawoma, hhela Biladoi xiahua giezhi hhei ala giewo. ");
INSERT INTO sce_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ingiezhi jinwun jiere hhei zhiizhi kieliesanla man gholuwo. Ingiedene hhei mutun jierese agi bouzhe mezade teiwo. ");
INSERT INTO sce_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ingieliuzhe Huda hhei fugusan kun dundase aminne olughawo. ");
INSERT INTO sce_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ersaghala hhantu Jialilise Yelusalende khisan kunlade Ersa ezighancha xienjighawo. Hhela ede bexinlai dunda Ersade ganzhen beizho. ");
INSERT INTO sce_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Bijienye ene gouxioxini tande chonjizhi ogine. Eneshi Huda matanyi xienrenlade dain giesanwo. ");
INSERT INTO sce_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ersai aminne olughazhi matan houdei danlasan kunde chenjighawo. Zeburei ji 2 piende jilasan mutun, 'Chishi mii kewon wo. Enedu bi chade ada danlawo.' ");
INSERT INTO sce_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Pse fugusan kun dundase Ersai aminne olughazhi ulie fughaku shiqinde Huda ingiezhi kieliezhi daowo, 'Bi Dawudede ogisan zhigui, kekaotu nenjienni tande ogiye.' ");
INSERT INTO sce_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Da nie Zeburei jiereye kieliewo, 'Chi zhiguitu kunne ulie fughane.'\" ");
INSERT INTO sce_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","\"Dawude duyade bikude Hudai isii zunjizhoma, duya ijiedene xienrenlareni hhantu bulase fuwo. ");
INSERT INTO sce_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Zinie Huda aminne olughasan hhe ese fuwo.\" ");
INSERT INTO sce_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","\"Ingiese gaijiula, ta mejiendu. Ene kunyi tungo giezhi zuini mienlieku daolii tande chonjizhi ogiwo. ");
INSERT INTO sce_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Musai guijinghala giese gounide sana danema, Ersai xianxin giesan kunlai man yanseliuzhe gounide sanane. ");
INSERT INTO sce_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ingiese ta xioxin gie, pse xienzhila kieliesan tai jiere gholune. ");
INSERT INTO sce_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","'Uzhe, ta uzhezhi xiniesan kunla, jindazhi fugune. Bi tai xienzide kunla tande kielieliuzhe ta xianxin gie daku fugie shiqin giene. Ingiese ta ayidene fugune.'\" ");
INSERT INTO sce_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","BaoloBanabaghala huitanse khizhekude kunla hhelai xinlazhi pse nie hhamuraku udude enezighan kielienyi hhelade pse jianji giezho. ");
INSERT INTO sce_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Sanhui giedene olon Yutai kun, Yutaijioni suisan niman kunla Baolo, Banabaghalai daghazho. Hheghala hhelade Hudai nenjiende chan kouizhi gie giezhi jianjizhi goude kieliewo. ");
INSERT INTO sce_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Pse nie hhamuraku udude nie chenshini kunla man hhantulazhi ire Ezhanyi kielienyi chenliene giezho. ");
INSERT INTO sce_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Yutai kunla imeghei kun iresei chanladene dubiliezhi Baolo kieliesan kielienyi fandui giezhi sugiezho. ");
INSERT INTO sce_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ingiese BaoloBanabaghala danzine fugiedaghazhi kieliewo, \"Hudai kielienyi xien tande kieliese indanji woma, ta ene daolii ulie jienliene. Ta goyane ene chanqiku aminni pei dane giezhi jiejin giezho. Ingiese bijien niman kunlai hhende echine. ");
INSERT INTO sce_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ezhan bijiende ingiezhi fenfulawo, 'Bi chii niman kunlade gon gholughadene jiuiku nenjienni deilazhi duyani uzhude echigha giezhi jinjiwo.'\" ");
INSERT INTO sce_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Niman kunla ene kielienyi chenliesenu bayasuzhi Ezhanyi kielien gou wo giezho. Chanqiku aminni ogine giezhi jinjisan kunla man xianxin giewo. ");
INSERT INTO sce_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ingiese Hudai kielienyi hhe oronde chonji kurughawo. ");
INSERT INTO sce_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Yutai kunla Hudai beiisan minshentu biereilai, pse hhe chenshii zhanlaolai shanjizhi Baolo, Banabaghalai heizhi oronsene tou khighawo. ");
INSERT INTO sce_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Hheghala kunlai fandui giezhi kon jieredu turane kui boughadene Igeniende echiwo. ");
INSERT INTO sce_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Tujilade bayasuku, Shenlin duruzho. ");
INSERT INTO sce_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Xianxianji shiqin Igeniendeye gholuwo. BaoloBanabaghala Yutai kunlai huitande orozhi daolii goude jianjise olon Yutai kun, Xila kunla xianxin giewo. ");
INSERT INTO sce_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ulie shunjisan Yutai kunla niman kunlai shanjizhi gaijiulade doghunni sumulaghazho. ");
INSERT INTO sce_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ingiese hheghala hhende oloncha souzhi Ezhande oluzhi danzine fugiedagha giezhi kieliezho. Ezhan hhelade nenli ogizhi ghudureqi, fugie shiqin giedene hhela jianjisan Hudai nenjientu daolide ganzhen beizho. ");
INSERT INTO sce_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ingiese chenshini kunla lianbanzi gholudene ibanlie Yutai kunyi daghazho, pse ibanlie shitulai daghazho. ");
INSERT INTO sce_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Niezhan niman kunla, Yutai kunla, noyenlarene hhantuladene ghua shitulai zayalazhi tashighala eghine giezhi jiejin giewo. ");
INSERT INTO sce_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Shitula ene shiqinni mejiedene holuzhi Ligaonini Luside, Tebi ghua chenshide, pse zhouwini oronlade echiwo. ");
INSERT INTO sce_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Hhela hhe oronlade gouxioxini chonjizho. ");
INSERT INTO sce_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lusidede ghua konde lilian witu nie canfei souzho. Zhayaghasanse mo yozhi ese daozho. ");
INSERT INTO sce_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Baolo jianjisanyi hhe kun chenliezho. Baolo hhei goude uzhese hhende goudaku xianxin gieku zhughe wine. ");
INSERT INTO sce_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ingie fugiede kieliewo, \"Chi ghua konne zhidaghazhi bosizhe!\" Ingiese hhe kun jiuli bosi ire yo qiiwo. ");
INSERT INTO sce_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Olon kunla Baolo giesan shiqinyi chanladene Ligaonii kielienghala fugiede kieliewo, \"Nigiedala kun gholudene mai dunda irewo!\" ");
INSERT INTO sce_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ingie Banabai Zhousi giezhi uruzho. Baolo zhomen jianjise Xiermi giezhi uruzho. ");
INSERT INTO sce_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Chenshi ghadaneshiku Zhousi mioni buwa giedun fughe laizhi chizhe bareidene chenshi wijien melie irewo. Olon kunlare hhantu shitulade khughozhi beiine giezho. ");
INSERT INTO sce_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","BanabaBaologhala sonosudene jienne sidakeigha, olon kunlai dunda holu oro fugiede kieliewo, ");
INSERT INTO sce_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","\"Dajiala, ta yale intu shiqin giene? Bijienshiye kun wo, tanre niekielien wo. Bijien enende irezhi gouxioxii chonjikushi tai gou witu dunxilase likai gieghazhi asiman, zemin, hai, pse hhei sudorodu shihenilai man zhayaghasan zhenzhenji chanqiku Hudade shunjighane giezho. ");
INSERT INTO sce_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Eqighanku gonyinde Huda go minzulani durare teizhi yan giese gie giezho. ");
INSERT INTO sce_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ingieliuzhe Huda gou shiqin giezhi goyane chan zhenmin giezho. Asiman jierese ghura bouzheghazhi, nanshihoude yanyanji osighazhi, tai chudughadene zhughede bayasughazho.\" ");
INSERT INTO sce_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Shitula ene kielienyi kieliedene olon kunlai danlazhi beigha dazhi ingiezhi goyane seigie ese beiighawo. ");
INSERT INTO sce_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Niezhan Yutai kunla Anqiyase Igeniense ire olon kunlai kielie shundagha Baoloi tashighala eghi, hhe fuguwo giedene chenshi ghadane lai khighawo. ");
INSERT INTO sce_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Tujila Baoloi kanzide wiqi beise hhe bosi ire chenshide orowo. Khuichudu hhe Banabaghala hhantu Tebide echiwo. ");
INSERT INTO sce_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Hhela Tebide gouxioxii chonjidene olon kunlai tuji gholughawo. Ingiedene hhela Luside, Igenienni jingo giezhi Anqiyade khareiwo. ");
INSERT INTO sce_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Hhela tujilai zhugheini khiduzheghazhi izhi xianxin gie giezhi sughazhi kieliezho. \"Matan Hudai gojiade orone giese bixi olon ku shouine.\" ");
INSERT INTO sce_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Hhela go jiohuide zhanlaolai sunghudene ese ijiezhi onxian gie, hhelai xianxin giesan Ezhandei jiuizhi ogiwo. ");
INSERT INTO sce_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ingie ghuala Bixijini jingo giezhi Panfeiliyade echiwo. ");
INSERT INTO sce_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pse Biejiade Hudai kielienyi jianjidene Yadalide bouwo. ");
INSERT INTO sce_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Hhense chon souzhi Anqiyade khareiwo. Anqiyashi chonjiku wiliede oluzhi ghua shitulai Hudai nenjiende jiuizhi ogisan oron wo. Ede onchen giedene khareizhi irewo. ");
INSERT INTO sce_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Anqiyade kurudene jiohuini kunlai man uru ire Huda hhelai tungo giezhi matugie giesan shiqinlai, pse Huda niman kunlai xianxin gie qiighasei kieliezho. ");
INSERT INTO sce_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Hhela hhende tujilare hhantu oloncha souwo. ");
INSERT INTO sce_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Yudayase bouzhesan giedun kunla gaijiulade Musani guijinghala hetoune ulie giese jiui dane giezhi sughazho. ");
INSERT INTO sce_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","BaoloBanabaghala hhelare hende jianjiduzhi zhenjinduse jiohuini kunla Baolo, Banaba, pse giedun kunlai ene shiqinde Yelusalenni shitu, zhanlaolade asaghale echine giezhi jiejin giewo. ");
INSERT INTO sce_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ingiese jiohuini kunla hhelai khughowo. Hhela Feiniji, Samaliyani daokude niman kunla Ersai xianxin giesei kieliese hhendedu gaijiula man hende bayasuzho. ");
INSERT INTO sce_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Yelusalende kuruse shitu, zhanlao, jiohuini kunla hhelai jienliewo. Huda hhelare hhantu giesan shiqinlai man jiohuini kunlade kieliewo. ");
INSERT INTO sce_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Giedun Falisai paini Ersai xianxin giesan kunla bosizhedene kieliewo, \"Niman kunlai bixi hetoune gieghadene fenfulazhi Musani guijinni zunjighakuni wo.\" ");
INSERT INTO sce_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Shitu, zhanlaola hhantulazhi ene shiqinni shanlian giewo. ");
INSERT INTO sce_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Dajiala ene shiqinni oloncha jianjidudene Beduru bosizhe kieliewo, \"Gaijiula, Huda melieshida tani dundase mii sunghuzhi niman kunla mase gouxioxini chenliedene xianxin giesei ta mejiene. ");
INSERT INTO sce_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Kunyi zhugheni mejiechen Huda matande ogisan mutun niman kunladeye Shenlinni ogizhi hhelai jienliewo. ");
INSERT INTO sce_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Dou xianxin giekughala hhelani zhughei ganjinraghawo. Hhelai uzheku matanre niekielien wo. ");
INSERT INTO sce_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ede ta yale Hudai shiizhi matan, matanyi xienrenla lai daku jiabanni tujilai ghuzhun jiere zhoghane? ");
INSERT INTO sce_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ulie olune, matanyi jiuikushi Ezhan Ersai nenjienghala wo. Hhelaye niekielien wo. Bijien ingiezhi xianxin giezho.\" ");
INSERT INTO sce_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Olon kunla man yama shenqi uye khizhezhi Huda BanabaBaologhalai tungo giezhi niman kunlai dunda giesan ghudureqi, fugie shiqinlai chenliezho. ");
INSERT INTO sce_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Hhela kielie baludene Yagebu kieliewo, \"Gaijiula, mii kielienyi chenliendu. ");
INSERT INTO sce_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Huda matugiezhi niman kunlai zhaogu giezhi tou 1 hui hhelani dundase bexinlai sunghudene goyanughun gholughasei Ximien kieliewo. ");
INSERT INTO sce_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Eneshi xienzhila kieliesan kielienghala niekielien wo. Jinwun jiere huaizho, ");
INSERT INTO sce_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","'Enense khuinashi bi khareizhi iredene Dawudeni furasan gieni erchan bosizheghane. Tairesanni gie goudaghazhi erchan bosizheghane. ");
INSERT INTO sce_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ingiese feiliesan kunlai man Ezhanyi ereighane. Bi sunghuzhi goyanughun gholughasan niman kunlai man Ezhanyi ereighane. ");
INSERT INTO sce_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Eneshi dei qiikude ene shiqinlai mejieghasan Ezhan kieliesan wo.' ");
INSERT INTO sce_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ingiese bi uzhese Hudade shunjisan niman kunlade chijia bu teidene ");
INSERT INTO sce_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","hhelade xin huaizhi nigiedade ogidene zannanshisan, lon kijieku, lei alasan, chusun, enelase gholodo giezhi fenfulase oluzho. ");
INSERT INTO sce_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ingiekushi eqighanse izhi go chenshide Musani guijinni jianjichen kun wine. Niefanie hhamuraku udude huitande onshizho.\" ");
INSERT INTO sce_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ingiedene shitu, zhanlao, jiohuini kunla hhelai dundase kun sunghuzhi Baolo, Banabare hhantu Anqiyade echighane giezhi jiejin giewo. Sunghusan kunshi Basaba giesan Yuda, pse Seila wo. Ene ghualashi jiohuini zhanlao wo. ");
INSERT INTO sce_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ingie hhelade bareighasan xin jiere kieliezho, \"Ersai sudoro gaijiu danlasan shitu, zhanlaola Anqiya, Xiliya, Jilijiadedu xianxin giesan niman gaijiulade kielien asazho.\" ");
INSERT INTO sce_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","\"Bijien sonosuse bijienni enense giedun kun khizhi echi kielienghala tai jiohoro giezhi tande nanran ese ogizho. Shijishan bijien hhelade yama ese fenfulazho. ");
INSERT INTO sce_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ingie dajiala tunyigie giedun kun sunghu peizhi bijien oresan Banaba, Baolore hhantu tai hhende echighawo. ");
INSERT INTO sce_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ene ghualashi mai Ezhan Ersa Mexihade oluzhi aminne ulie kerechen kun wo. ");
INSERT INTO sce_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ingiese bijien Yuda, Seilaghalai peizhi tande qinsi ene shiqinlai kielieghane. ");
INSERT INTO sce_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Shenlin bijienre hhantu tunyi giezhi ene giedun zhunyoni shiqinse chugo psedu achanni tai jiere ulie teise gou wo giezho. ");
INSERT INTO sce_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ta nigiedade teisan, chusun, lei alasan, lon kijieku enelase gholoduse jiu oluwo. Tande salan gieye.\" ");
INSERT INTO sce_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Hhelani peizhi Anqiyade bou, xianxin giesan kunlai uruzhi hhantulagha xinni jiuizhi ogiwo. ");
INSERT INTO sce_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Xinni onshidene zhichi giesan goushi hhela bayasuzho. ");
INSERT INTO sce_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuda, Seilaghalashiye xienzhi wo. Olon kielienghala gaijiulade surughazhi hhelai xianxin giekuni khiduzheghawo. ");
INSERT INTO sce_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Hhela hhende nietan soudene gaijiula hhelai dafalazhi hhelai peizhi ireghasan Yelusalenni jiohuide pinnande echighawo. ");
INSERT INTO sce_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Baolo, Banabaghala Anqiyade zhanshi souzhi olon kunlare hhantu kunlade sughazhi Ezhanyi kielienyi chonjizho. ");
INSERT INTO sce_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Giedudu daodene BaoloBanabade kieliewo, \"Matan khareizhi eqighandei Ezhanni kielienyi chonjisan go chenshide gaijiulani qinkonyi uzhele yoye.\" ");
INSERT INTO sce_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","BanabaMake giesan Yaheiyani uduruzhi echine giese ");
INSERT INTO sce_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Make eqighandei Panfeiliyase likai giezhi hhelare hhantu wilie ese giewo giezhi Baolo hhei jiedui ulie udurune giezho. ");
INSERT INTO sce_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ingie ghuala hende jianjindu ghaghachawo. BanabaMakei uduru chon soudene Saipuluside echiwo. ");
INSERT INTO sce_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","BaoloSeilai sunghusenu gaijiula hhelai Ezhanni nenjiende jiuizhi ogise yo qiiwo. ");
INSERT INTO sce_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","BaoloXiliyani, Jilijiani yozhi go jiohuilani khiduzheghawo. ");
INSERT INTO sce_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","BaoloTebide echi, pse Lusidede kuruse hhende nie tuji wine. Niereini Qimotai giene. Ananishi Yutai kun wo, Ezhanyi xianxin giezho. Adanishi Xila kun wo. ");
INSERT INTO sce_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Luside, Igenienni gaijiula man Qimotaini kuaizho. ");
INSERT INTO sce_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Baolo hhei uduruzhi echine giezho. Hhe oronni Yutai kunla adanishi Xila kun bikui man mejiene. Ingie hhende hetoune giewo. ");
INSERT INTO sce_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Hhela go chenshilai yozhi daokude Yelusalenni shitu, zhanlaola jinjisan guijinni xianxin giesan kunlade ogizhi zunjighazho. ");
INSERT INTO sce_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ingiese jiohuilani kunlai xianxin gieku khiduzhezhi kun niudunie olodowo. ");
INSERT INTO sce_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Shenlin hhelai danlazhi Yaxiyade Hudai kielienyi ese jianjighase hhela Fulijia, Jialatai oronlade echiwo. ");
INSERT INTO sce_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Meixiyani bienzide kurudene Bituinide echine giese Ersai ruhher ese echighawo. ");
INSERT INTO sce_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ingiese hhela Meixiyani jingo giezhi Teloyade bouwo. ");
INSERT INTO sce_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Xienidei Baolo zhoujin mutun chanlawo. Niekozi Maqidun kun beidene hhei xiahua giezhi kieliewo, \"Maqidunde daozhedene bijiende banman gie.\" ");
INSERT INTO sce_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Baolo zhoujin mutun chanlase bijien deigo Maqidunde echine giezho. Bijien jiejin giese Huda bijienyi uruzhi hhe oronni kunlade gouxioxini chonjighane giezho. ");
INSERT INTO sce_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ingiese bijien Teloyase chon souzhi zhijie Samotelade echidene khuichudu Niyapolide kuruwo. ");
INSERT INTO sce_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Hhense Feilibide kuruwo. Feilibishi Maqidun orondedu nie zhunyo chenshi wo, Loma gonjizho. Bijien ene chenshide giedudu souwo. ");
INSERT INTO sce_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Hhamuraku udude bijien chenshini wijiense khirei nie moron bienzide echiwo. Sumulase hhende nie onxian gieku oron wine giezho. Bijien soudene hhantulasan biereilade daoli jianjiwo. ");
INSERT INTO sce_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Chenliesan kun dunda Tuiyatuila chenshini nie zihun bosi huisan bierei wo. Niereini Lijiya giene. Hhe Hudai beiizho. Baolo jianjikude Ezhan hheni zhugheni keighase hhe goude chenliezho. ");
INSERT INTO sce_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Hhe bierei, pse nie gie kunladeni man xili gieghawo. Ingie bijienyi xiahua giezhi kieliewo, \"Ta bishi Ezhanni zhenzhenji xianxin giesan wo giese mii giede yodene sou.\" Ingie bijienyi ninguru danlawo. ");
INSERT INTO sce_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Niefade bijien onxian gieku oronde echikude nie sheitan heisan hoji oqin irewo. Hhe fashu shuaizhi loubanladene baer olon ireghazho. ");
INSERT INTO sce_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ene oqin Baolo, pse bijienyi daghadene onghonozhi kieliewo, \"Enezighan kunlashi Zui Undu Hudai hojila wo. Hhela tande jiuiku daolini chonjine!\" ");
INSERT INTO sce_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Hhe ingiezhi ezighancha onghonose Baolo pofensadene ochira daozhe sheitande kieliewo, \"Bi Ersa Mexihani niereghala chii fenfulaye, hhei jierese khizhe!\" Hhe sheitan danshi khizhewo. ");
INSERT INTO sce_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Hoji oqinni loubanla uzhese baer ireku xiwon widase BaoloSeilaghalai bareidene geidoude khirei noyenyi shida lai echighawo. ");
INSERT INTO sce_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Hhelai laidene noyenlai shida ire kieliewo, \"Enezighan kunlashi Yutai kun wo, mai chenshini daolon giezho. ");
INSERT INTO sce_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Hhela matan Loma kunla jienlie dazhi gie daku jiomun chonjizho.\" ");
INSERT INTO sce_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Olon kunlaye hhantuladene hhelai fandui giezho. Panjiku noyenla fenfulazhi hhelai jienni teighadene banbanghala eghi giezho. ");
INSERT INTO sce_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Hhelai hende eghidene bafanzide khawo. Sagheisan kunde goude uzhe giezhi fenfulawo. ");
INSERT INTO sce_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Sagheisan kun ene minlinni jienliedene hhelani zui jizii bafanzide khazhi ghua kon jierei jieliu zhoghawo. ");
INSERT INTO sce_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Banye olukudeni BaoloSeilaghala onxian giezhi Hudade doulazho. Fanrenlaye chenliezho. ");
INSERT INTO sce_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Menzhali zemin hende gojiolu bafanzi jiziye gojioluwo. Ingie bafanzi wijienla man kei echi soyuji fanrenlani jieliu man andawo. ");
INSERT INTO sce_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Sagheisan kun xiereise bafanzi wijienla man keise fanrenla man holuwo giedene khudoghone choui khizhe goyane fugune giezho. ");
INSERT INTO sce_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ingiekude Baolo fugiede waradazhi kieliewo, \"Goyane bu shanji! Bijien man enende wo!\" ");
INSERT INTO sce_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Sagheisan kun zhulai kerezhi ire, jiuli bou, pugharazhi BaoloSeilani melie papalawo. ");
INSERT INTO sce_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ingie hhelani uduru khizhe kieliewo, \"Gujiula, bi matugiese jiuine?\" ");
INSERT INTO sce_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Hhela kieliewo, \"Ezhan Ersani xianxin gie. Ingiese chi, chii nie giechiliei man jiuine.\" ");
INSERT INTO sce_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ingie Ezhanni kielienyi hhei nie giechiliede jianjizhi chenlieghawo. ");
INSERT INTO sce_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Yen hhe xii hhe shihoude sagheisan kun hhelani uduruzhi echi shankoulaini waghazhi ogiwo. Ingiedene hhe nie giechiliede man xili gieghawo. ");
INSERT INTO sce_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ingie sagheisan kun hhelai uduruzhi giedene echi budan ijieghawo. Hhe nie giechilie Hudai xianxin giese hende bayasuzho. ");
INSERT INTO sce_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Khuichudu ogheise noyenla gunnanjilai peizhi iregha \"Hhe ghua kunyi andagha.\" giezhi kieliewo. ");
INSERT INTO sce_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ingiese sagheisan kun Baolode kieliewo, \"Panjiku noyenla tai andagha giezhi minlin xiaiwo. Ede ta khidene pinnande echi.\" ");
INSERT INTO sce_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Baolo kieliewo, \"Bijienshi Loma kun wo. Bijiende zui ese jinjidene olon kunlai melie bijienni eghizhi dou bafanzide khawo. Ede bijienni zhonmenji andaghanu? Ene ulie olune. Hhela goyalane irezhi bijienni uduzhi khireigha gie.\" ");
INSERT INTO sce_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Gunnanjila ene kielienyi noyenlade kieliese noyenla hhelashi Loma kun wo giese ayizho. ");
INSERT INTO sce_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ingiedene ire hhelai sidaghazhi kielie, uduruzhi khizhedene, \"Hhe chenshise likai gie!\" giezhi xiahua giewo. ");
INSERT INTO sce_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ghuala bafanzise khizhedene Lijiyani giede echi gaijiulai ochira, zhichi giedene yolawo. ");
INSERT INTO sce_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","BaoloSeilaghala Anfeipoli, Yaboloniyani daodene Qiesalonijiade irewo. Hhende Yutai kunni nie huitan wine. ");
INSERT INTO sce_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Baolo suchanku xigonghala hhende orozhi lienji ghuran hhamuraku udude kunlare jinwun kielienduzho. ");
INSERT INTO sce_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Mexiha bixi shouku giedene fugusan kun dundase aminne olukui hhelade jianjizhi zhenmin giezho. Pse kieliewo, \"Bi tande chonjizhi ogisan ene Ersashijiu Mexiha wo.\" ");
INSERT INTO sce_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Hhelai dunda ezighan kunlai kielie shundaghase BaoloSeilai daghazho. Pse Hudai beiisan olon Xila kun, minshentu biereilaye olon daghazho. ");
INSERT INTO sce_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Xianxin ulie giechen Yutai kunla dubiliezhi geidouse ezighan liumanlai uruzhi hhantulagha nie chenshii kunlai shanjidene Yasoni giede chunji oro, BaoloSeila ghualai ereizhi bexinlade jiuine giezho. ");
INSERT INTO sce_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ereizhi olu dadene Yaso, giedun gaijiulai laisenu hhe oronni noyenyi shida echi waradazhi kieliewo, \"Qienxiani daolon giesan ene iban kunla enende irezho. ");
INSERT INTO sce_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yaso giedene hhelai jienliewo. Enezighan kunla man Ersa giechen da nie honshan wine giezhi Kaisai minlinyi fanjizho.\" ");
INSERT INTO sce_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Olon kunla hhe oronni noyenla ene kielienyi chenliedene jindazho. ");
INSERT INTO sce_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ingiedene Yaso, psedu kunlai baer faidene andaghawo. ");
INSERT INTO sce_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Xienidei gaijiula BaoloSeilaghalai deigo Biliyade echighawo. Ghuala kudene Yutai kunlai huitande echiwo. ");
INSERT INTO sce_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Biliyani kunla Qiesalonijia kunlase sixian keifan giezho. Daolini rexinde jienliezhi niudunie xianxide jinwunni chaizhi ene daoli oluzhou ese oluzho giezho. ");
INSERT INTO sce_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ingie hhelai dunda olon kun xianxin giewo. Xilani minshentu bierei, ere kunlaye choghon uwo. ");
INSERT INTO sce_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Qiesalonijiani Yutai kunla BaoloBiliyade Hudai kielienyi chonjisei mejiedene hhende echizhi kunlai shanjizhi londaghazho. ");
INSERT INTO sce_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ingiese gaijiula deigo Baoloi haibienzide echighawo. SeilaQimotaighala yen Biliyade feiliewo. ");
INSERT INTO sce_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Baoloi khughosan kunla hhei khughozhi Yajiende echighawo. Hhela khareikude SeilaQimotaighala ghujighande mii enende ire giezhi Baolo fenfulasei deila echiwo. ");
INSERT INTO sce_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","BaoloYajiende hhelai sagheikude nie chenshide man nigiedashi hende nango giezho. ");
INSERT INTO sce_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Hhe huitan sudoro Yutai kun, Hudai beiisan niman kunlare jianjinduzho. Pse niudunie geidoude penjisan kunlare jianjiduzho. ");
INSERT INTO sce_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Da niezhan Ibijiulu, Sidoya ghua paini loushilaye Baolore jianjinduzhi kieliezho, \"Ene hulihuduji yan kieliezho?\" Pse niezhanla kieliezho, \"Hhe hoxianshi niman kunlai nigiedani chonjizho.\" Ingiezhi kieliekushi Baolo hhelade Ersa fuho giesan daolii jianjizho. ");
INSERT INTO sce_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ingiese hhela Baoloi uduru Yaliebagu fayende echidene kieliewo, \"Chi jianjisan ene nie shini daolini bijiende mejieghase olulie? ");
INSERT INTO sce_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Chi kieliesan niezhan shiqinlai bijien chenliese ghudure no wo. Eneshi yan isi bikui bijien mejieku duran wine.\" ");
INSERT INTO sce_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Yajien kun, hhende zhanshi jiere sousan waiji kunla man yama ulie gonjidene zui shini shiqinyi chenliezhi kieliekude xiqi wo. ");
INSERT INTO sce_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","BaoloYaliebagu fayende beidene kieliewo, \"Yajien kunla, bi uzhese ta yan gieliuzhe zunjio xinyan jiere chighara wo. ");
INSERT INTO sce_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Bi gochude yokude ta beiisanlai xianxide uzhese nie sidagha gieku teizi jiere, 'Tani Daku Hudade' giezhi huaizho. Ingiese ta tani dazhi beiisei bi kielieye.\" ");
INSERT INTO sce_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","\"Hheshi duya, duya jieredu yanyanjilai man zhayaghasan Huda wo. Asiman zeminni Ezhan wo. Kun giesan huitande ulie soune. ");
INSERT INTO sce_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Hhende chaiku mutun kunni khaghala ushilaku biyo uwo. Huda kunlade amin, ho, yanyanjilai man ogizho. ");
INSERT INTO sce_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Niekozi kunse jien minzulani zhayaghadene zeminyi gochude soughawo. Hhelade nienjien, souku oronni jinjizhi ogiwo. ");
INSERT INTO sce_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ingiezhi giekushi Huda goyane kunlai ereighane giezho. Kenen moqioluzhi hhei ereizhi olune. Shijishan Huda matan alinie kunseliuzhe gholo uwo. ");
INSERT INTO sce_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","'Matan amituraku, gojioluku, bikushi man hhei kouizho.' Tai dunda shu huaisan kunla kieliesan mutun, 'Matanshi Hudase iresan wo.'\" ");
INSERT INTO sce_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","\"Matan Hudase iresanshi Hudai antan, miengu, tashighala, kunni jishu, sumulakughala giesan yanzi mutun uzhese ulie olune. ");
INSERT INTO sce_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Melieshida kunla mejie dazhi giesei ese gonjiwoma, ede Huda gochui kunlade fenfulazhi geizhen gie giezho. ");
INSERT INTO sce_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Huda sunghusan hhe kunghalane duyai gundande panjiku udui ijin jinji goudaghawo. Hhe kunyi fugusan kun dundase aminne olughazhi soyuji kunlade xianxin gieku zhenmin ogiwo.\" ");
INSERT INTO sce_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Fugusanse fuho giesan ene kielienyi chenliedene niezhanla hhei uzhezhi xiniezho, niezhanla \"Bijien pse chenlieku duran wine.\" giezhi kieliezho. ");
INSERT INTO sce_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ingie Baolo hhelai dundase khizhi echiwo. ");
INSERT INTO sce_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Niezhan kunla Baolore hhantulazhi Ezhanni xianxin giewo. Hhelai dunda Yaliebagu fayendedu nie kun Jiunixiu, Damali giesan nie bierei, da ezighan kunye wine. ");
INSERT INTO sce_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ene shiqinse khuinashi BaoloYajiense likai giedene Gelindode echiwo. ");
INSERT INTO sce_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Hhende Bendude olusan nie Yutai kunyi penjiwo. Niereini Yajila giene. Kelaoji honshan Yutai kunlade Loma gojiase likai gie giezhi minlin xiaise Baijila giesan biereighalane ene oloncha Lomani Idalise irewo. Baolo hhelai ochirale echiwo. ");
INSERT INTO sce_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Hhelaye Baolo mutun zhanfan giezhi udu daoghazho. Ingiese Baolo hhelare hhantu souzhi wilie giezho. ");
INSERT INTO sce_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Niefanie hhamuraku udude Baolo huitande kunlare jianjinduzhi Yutai kun, Xila kunlai kielie shundaghane giezho. ");
INSERT INTO sce_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Seila, Qimotaighala Maqidunse iredene Baolo zhomen Hudai kielienyi chonjizhi Yutai kunlade, \"Ersashi Mexiha wo.\" giezhi ganzhen beizho. ");
INSERT INTO sce_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Hhela fandui giezhi zannan kielienghala hhei sugiese Baolo jien jieredu turane kuizhi kieliewo, \"Ta goya zuine goya danji! Made yama ghadaghan uwo. Enedu khuinashi bi niman kunlai hhende echine.\" ");
INSERT INTO sce_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ingiedene huitanse likai giezhi Qido-Yushidu giesan nie kunyi giede echiwo. Ene kun Hudai beiizho. Hhei gieni huitan konde wo. ");
INSERT INTO sce_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Huitan gonjisan Jilisibu nie giechiliene Ezhanyi xianxin giewo. Pse olon Gelindo kunlaye chenliedene xianxin giezhi xili jienliewo. ");
INSERT INTO sce_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Xienidei Ezhan zhoujin mutun Baolode kieliewo, \"Bu ayi, amanne bu menjidene kielie. ");
INSERT INTO sce_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Bi chighala hhantu wo. Kieme chii hei dane. Ene chenshide mii bexin olon wo.\" ");
INSERT INTO sce_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Baolo hhende nienban souzhi Hudai kielienyi hhelade sughazho. ");
INSERT INTO sce_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","JialiuYagaiyade zunli danlakude Yutai kunla hhantuladene Baoloi fandui giezhi lai shenpantai melie echi kieliewo, ");
INSERT INTO sce_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","\"Ene kun guijinni ulie zunjidene Hudai beiise olune giezhi kunlai kielie shundaghazho.\" ");
INSERT INTO sce_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Baolo jian kieliene giese JialiuYutai kunlade kieliewo, \"Yutai kunla, fanfa giezhi yenzhunde zui fanjisan shiqinde zhazhoshi bi tanughunyi chenliese oluzhoma, ");
INSERT INTO sce_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ta jianjindusanshi kielien, niere, tai guijinni shiqinshi ta goyalane banjile echi. Ene shiqinlani bi panjiku duran uwo.\" ");
INSERT INTO sce_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ingiedene hhelai fayense tou khighawo. ");
INSERT INTO sce_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ingiese kunla man huitan gonjisan Soqinii barei agidene shenpantai melie idun eghiwo. Ingieliuzhe Jialiu ese gonjizho. ");
INSERT INTO sce_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","BaoloGelindode pse ezighancha soudene gaijiulase ghaghachadene chon souzhi Xiliyade echiwo. Baijila, Yajila hhere hhantu echiwo. Hhe Jiengelide usunne ghigha widaghawo. Enei hhe eqighanse fayen giezhi daozho. ");
INSERT INTO sce_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ifusode kurudene Baolo hhelai hhende feiliegha goyane huitande orozhi Yutai kunlare daoli jianjinduzho. ");
INSERT INTO sce_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Kunla hhei pse giedudu sou giese hhe dain ese giedene ");
INSERT INTO sce_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","hhelase likai giekude kieliewo, \"Huda duran bise bi pse tai enede irene.\" Ingie chon souzhi Ifusose likai giewo. ");
INSERT INTO sce_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Kaisaliyade chon jierese bouzhe, Yelusalende khireidene jiohuini kunlai nie asa, Anqiyade bouwo. ");
INSERT INTO sce_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Giedudu soudene pse likai gie, Jialatai, Fulijia oronlai yozhi olon tujilai khiduzheghawo. ");
INSERT INTO sce_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Yabolo giesan nie Yutai kun Ifusode irewo. Hhei Yalishandade oluzho. Koucai wine, jinwunde hen wo. ");
INSERT INTO sce_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ene kun Ezhanni daolini olon suruzho. Zhughe chilazhi Ersai shiqinni kunlade xianxide sughazhoma, zinie Yaheiyani xilini mejiene. ");
INSERT INTO sce_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Hhe huitande danzine fugiedaghazhi jianjizho. Baijila, Yajilaghala jianjiseini chenliedene hhei danlin uruzhi Hudai daolini hhende pse xianxide jianjizhi mejieghawo. ");
INSERT INTO sce_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","YaboloYagaiyade echine giese Ifusoni gaijiula hhende zhichi giedene Yagaiyani tujila Yaboloi goude jienlie giezhi xin huaizho. Hhe hhende kuruse Ezhanni nenjienghala xianxin giesan kunlade banman fugie wo. ");
INSERT INTO sce_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Hhe olon kunlai melie jinwunghala Ersashi Mexiha wo giezhi hende zhenmin giese Yutai kunlai kielie beighawo. ");
INSERT INTO sce_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","YaboloGelindode bikude Baolo beimienghun yozhi Ifusode echiwo. Hhende giedun tujilai penjidene asawo, ");
INSERT INTO sce_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","\"Ta xianxin giekude Shenlinyi jienliewoye?\" Hhela kieliewo, \"Uye, lien Shenlin winekuida chenliezhi ese daowo.\" ");
INSERT INTO sce_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ingiese Baolo kieliewo, \"Qinse ta yan xilini jienliewo?\" Hhela kieliewo, \"Yaheiya gieghasan xilini jienliewo.\" ");
INSERT INTO sce_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Baolo kieliewo, \"Yaheiya gieghasanshi geizhen gieku xili wo. Hhe bexinlade kieliezhi mii khuinase ireku hhei xianxin gie giezho. Hheshijiu Ersa wo.\" ");
INSERT INTO sce_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Hhela ene kielienyi chenliedene Ezhan Ersai niereghala xili jienliewo. ");
INSERT INTO sce_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Baolo hhelai jiere khane teise Shenlin hhelai jiere bouzhewo. Ingiese hhela shiheni kielienghala kieliezhi Hudai kielienyi kielie qiiwo. ");
INSERT INTO sce_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Hhende chabudu 12 gie kun wo. ");
INSERT INTO sce_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Baolo huitande orozhi danzine fugiedagha ghuran sara kunlare Hudai gojiai shiqinni jianjinduzhi kielie shundaghawo. ");
INSERT INTO sce_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ingieliuzhe niezhan kunla zhughene khiduzheghazhi ulie shunjidene olon kunlai melie ene daolini sugiene. Ingiese Baolo tujilarene hhantu hhelase likai giedene Tuilanuni suruku oronde niudunie jianjizhi kielienduzho. ");
INSERT INTO sce_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ingiezhi ghua honshi Yaxiyade sousan Yutai kun, Xila kunla man Ezhanni kielienyi chenliewo. ");
INSERT INTO sce_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Huda Baoloi tungo giezhi tebieji nenlitu shiqinlai gieghazho. ");
INSERT INTO sce_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Niezhan kunla da hhe injizhi daosan shoujin, wiqinyini agi ire gientulai jiere teise gienla goudazhi sheitanla khizhi echiwo. ");
INSERT INTO sce_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Gochude toreizhi sheitan tousan giedun Yutai kunla Ezhan Ersai niereghala sheitanyi tou khighane giezhi sheitan heisan kunlade bi Baolo chonjisan Ersai niereghala tande minlin xiaiye giezhi shiizho. ");
INSERT INTO sce_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Shijiwa giesan nie Yutai kunni fugie buwai dolon kewonla ene shiqinyi giezho. ");
INSERT INTO sce_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ingiese sheitan hhelade kieliewo, \"Ersai bi mejiene. Baoloiye tanine. Tashi kien wo?\" ");
INSERT INTO sce_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ingiedene sheitan heisan hhe kun hhelai jiere jiuli khirei, eghizhi hanshiliese hhela shan deilazhi hulan muchughun hhe giederase holu khireiwo. ");
INSERT INTO sce_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ifusode sousan Yutai kun, Xila kunla man ene shiqinyi mejiedene ayizho. Ingiese Ezhan Ersai minshen fugiedawo. ");
INSERT INTO sce_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Pse olon xianxin giesan kunla iredene goya giesanlane man chenren giezhi kielie khizheghawo. ");
INSERT INTO sce_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Olon fashu shuaisan kunla shulai agizhi ire dajialai melie sideraghawo. Shuni jiageni sanase 50000 miengu wine. ");
INSERT INTO sce_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ingiezhi Ezhanyi kielien yebeiseye ondazhi gochude echizho. ");
INSERT INTO sce_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ene shiqin daodene BaoloMaqidun, Yagaiya oronse daozhi Yelusalende echine giezhi zhughedene jiejin gie kieliewo, \"Bi hhende kuruse bixi Lomade nie uzhele echine.\" ");
INSERT INTO sce_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ingie hhende banman giesan kun dundase Qimotai, Iladughalai Maqidunde echighawo. Goyane zhanshi jiere Yaxiyade feiliewo. ");
INSERT INTO sce_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Hhe shihoude ene daolini yenyin jiere Ifusode hende londawo. ");
INSERT INTO sce_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Nie miengu jianrenyi niereiini Jimijiu giene. Miengughala Yajimini yanzii giezhi jishugunlade baer olon zhenjighazho. ");
INSERT INTO sce_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Hhe jishugun, hanjialane uruzhi hhantulaghadene kieliewo, \"Dajiala, matan ene meimeighala facai giesei ta mejiene. ");
INSERT INTO sce_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ene Baolo zinie Ifusode pusho, Yaxiya go oronlade olon kunlai miizhi kun khaghala giesanlashi Huda pusho giesei ta chujieghezhi sonosuwo. ");
INSERT INTO sce_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ingiese zinie matanyi ene meimeini minshen bixindaku pusho. Yajimi famatu bierei nigiedani mioniye kunla meilade uzhene. Yaxiya kun, qienxiani kunla beiisan Yajimini wifen widane.\" ");
INSERT INTO sce_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Kunla chenliedene hende hokuzhi Ifuso kunlai Yajimi hen wo giezhi onghonozho. ");
INSERT INTO sce_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Nie chenshi man londa qiiwo. Kunla Baolore hhantu yosan Maqidunni Gaiyu, Yalidagui laidene xi yenjisan chanchande hhantu chunji orowo. ");
INSERT INTO sce_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Baoloye bexinlai dunda orone giese tujila ese oroghawo. ");
INSERT INTO sce_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Yaxiyani giedun noyenlashi Baoloi zhanlien wo. Kun peizhi iregha Baoloi wixiennide bu echi giezhi danlawo. ");
INSERT INTO sce_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Hhantulasan kunla londundunji wo. Ingiezhi onghonone, qingiezhi onghonone. Fugie olie kunla yangiezhi hhantulasanne ulie mejiene. ");
INSERT INTO sce_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Yutai kunla Yalishandai tungu melie khighase niezhan kunla hhende matugie giekui kieliezho. Yalishanda nie kha zhadeigha bexinlade jieshi giene giese ");
INSERT INTO sce_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","kunla hheshi Yutai kun bikui mejiedene man hhantu Ifuso kunlai Yajimi hen wo giezhi ghua zhuntou onghonozho. ");
INSERT INTO sce_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ingie hhe chenshini noyen ire olon kunla onghonosei beigha kieliewo, \"Ifuso kunlaya, Ifusoshi hen Yajimi mioi sagheisan, pse asiman jierese bouzhesan tashii sagheisan chenshi bikui kien ulie mejiene? ");
INSERT INTO sce_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ene shiqinde yama kieliekui uwoshi ta qioqioji lon bu ire. ");
INSERT INTO sce_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ta laizhi iresan enezighan kunla mioni dunxilai ese ghulazho. Pse mai bierei nigiedaniye ese sugiezho. ");
INSERT INTO sce_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ingiese Jimijiu, hhantuku jishugunlarene yan zhakui bise fayende nieniene zhale echi gie. Ede fayenni niezho, zunlilaye wine. ");
INSERT INTO sce_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Tande psedu shiqin wineshi zhao guijinghala hui keizhi chuli gie. ");
INSERT INTO sce_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Eneduku londasan shiqinde matanyi zhaku wixien wine. Ene saorao giesande matande jieshi gieku kielien uwo.\" ");
INSERT INTO sce_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ene kielienyi kieliedene qinzhunlai sandaghawo. ");
INSERT INTO sce_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ene londasan shiqin bouzhi echisenu Baolo tujilai uruzhi ire, hhelade sughazhi kielie, pse chujiegheye giedene Maqidunde echiwo. ");
INSERT INTO sce_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Baolo hhe oronlai jingo giekude olon kielienghala tujilade sughazhi kieliedene Xilade echiwo. ");
INSERT INTO sce_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Hhende ghuran sara soudene chon souzhi Xiliyade zhen echine giekude Yutai kunla jihua giezhi hhei heine giekui mejie, Maqidunghun echine giezhi jiejin giewo. ");
INSERT INTO sce_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Hhere hhantu Yaxiyade echisanshi Biliya kun Bilosini kewon Sobate wo, Qiesalonijia kun Yalidagu, Xigundu ghuala wo, Qimotai pse Tebi kun Gaiyu ghuala wo, da Yaxiya kun Tuijigu, Telofeimo ghuala wo. ");
INSERT INTO sce_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Enezighan kunla xien Teloyade echi bijienyi sagheizho. ");
INSERT INTO sce_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Bijien Tanmien Jie daodene Feilibise chon souzhi tawudushi Teloya hhelai hhende kuru, doludu souwo. ");
INSERT INTO sce_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Xinqide bijien hhantuladene ginan ghuluzhi ijiekude Baolo khuichudu yolane giese hhelade banye olutula jianjiwo. ");
INSERT INTO sce_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Bijien hhantulasan hhe lou jiere zhula olon wo. ");
INSERT INTO sce_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Baolo jianjikude Yutuigu giesan nie nasuchighan kun chongun jiere souzho. Oloncha jianjise hhe kun funtura fugudene 3 lou jierese anda bouwo. Kunla fei bosizheghase fuguzho. ");
INSERT INTO sce_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Baolo bou echi ghodeidene hhei qioru agi kieliewo, \"Ta bu jinda, hhe dou amitu wo\". ");
INSERT INTO sce_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Baolo pse khizhi echi ginan ghuluzhi ijie, oloncha jianjizhi ogheidene yolawo. ");
INSERT INTO sce_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Kunla nasuchighan kunyi amitu khugho echighase man hende bayasuzho. ");
INSERT INTO sce_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Bijien xien chon souzhi Yashode echi hhende Baoloi jienliene giezho. Hhe goyane yozhi echine giezho. Eneshi hhe nanpei giesan wo. ");
INSERT INTO sce_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","BaoloYashode bijienre hhantulase bijien hhei chon jiere jienlie khirei Mituilinide irewo. ");
INSERT INTO sce_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Hhense chon souzhi khuichudu Jiyani duimiende kurudene da niudude Samode daowo. Ingie pse niudude Milidude irewo. ");
INSERT INTO sce_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","BaoloYaxiyade danwu giekuse ayizhi Ifusoni onji daone giezhi eqighanse jiejin giewo. Hhe ghujighan yozhi jinlianji 50 qienni jieqi melie Yelusalende kune giezho. ");
INSERT INTO sce_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","BaoloMiliduse kun peizhi Ifuso jiohuini zhanlaolai xinlaghale echiwo. ");
INSERT INTO sce_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Hhela irese Baolo hhelade kieliewo, \"Bi Yaxiyase iresan hhe niuduse izhi tai dunda matugiezhi giesei ta mejiene. ");
INSERT INTO sce_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Yutai kunla mii heizhi shouku gieghakude bi rennai giezhi goyane meilade uzhezhi nughusunghalane Ezhanyi zunjizhi giezho. ");
INSERT INTO sce_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Tande oluzhi gounii bi nieda ese jiezhi olon kunlai melie pse kienyi giedeliuzhe tande sughazhi jianjiwo. ");
INSERT INTO sce_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Pse Yutai kun, Xila kunlade ganzhen beizhi Hudai melie geizhen giedene mai Ezhan Ersai xianxin gie giewo.\" ");
INSERT INTO sce_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","\"Ede Shenlin mii biizhi bi Yelusalende echine. Hhende yan shiqin penjikui ulie mejienema, ");
INSERT INTO sce_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","bi mejiekushi Shenlin go chenshide made ganzhen beizhi bareiku pse kunnan kuzhene giezho. ");
INSERT INTO sce_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ingieliuzhe bi Hudai nenjienni kielieku gouxioxide ganzhen beine giezhi Ezhan Ersase jienliesan renwune onchen ulie gietula aminne ulie kerene.\" ");
INSERT INTO sce_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","\"Bi tai dunda irezhi Hudai gojiai daolii chonjizhoma, ihou ta mii pse chanla dakui ede bi mejiene. ");
INSERT INTO sce_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ingiese bi enedu tande ganzhen beiye. Tai dunda kien dozode echise made zui uwo. ");
INSERT INTO sce_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Hudai isii bi goujida uye feilieghazhi man tande chonjizhi ogiwo. ");
INSERT INTO sce_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ta goyalane xioxin giezhi zhaogu gie pse Hudai bexinlani xioxin giezhi zhaogu gie. Ta ghoni adulachen kun mutun hhelai zhaogu gie. Shenlin tai hhelade lindao danlaghazho. Hhelashi Huda Kewonne chusunghala agizhi iresan Hudani jiohui wo. ");
INSERT INTO sce_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Bi yolase mouxien zhanghei tai dunda orezhezhi ghonilai shanjikui bi mejiene. ");
INSERT INTO sce_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Tai dundaseye niezhan kunla khizhedene zhendaoni wirulaghazhi tujilai miidene goyalane daghaghane. ");
INSERT INTO sce_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ingiese xioxin giendu. Bi ene 3 niende xieni uduiji nughusun usuruzhi soyuji kunlade sughazhi kieliesei ta jila. ");
INSERT INTO sce_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Ede bi tai Hudade, hhei nenjientu daolide jiuizhi ogiye. Ene daoli tai hendagha shidane, pse taiji soyuji zhiguishisan kunlare hhantu Hudai jiachanni jienliegha shidane. ");
INSERT INTO sce_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Bi kiemai antan, miengu, jienni nienhei giezhi ese daozho. ");
INSERT INTO sce_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Bi ghua khaghalane goyadene hhantuku kunladene injiku dunxi gunjisei ta goyalane mejiene. ");
INSERT INTO sce_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Bi yandeliuzhe yanzi uzheghazhi khishulazhi wilie giedene zholien kunlade banman giezho. Pse ogiku jienliekuse fuqi fugiewo giesan Ezhan Ersai kielienyi jila giezho.\" ");
INSERT INTO sce_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Baolo ene kielienyi kielie baraghadene xiutulie dajialare hhantu onxian giewo. ");
INSERT INTO sce_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Kunla man fugiede wilazhi Baoloi qiorudene orezho. ");
INSERT INTO sce_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ihou ta mii pse chanla dane giesan Baoloi ene kielien hhelai zhughei hende otughazho. Ingie hhela Baoloi chon jiere khugho echighawo. ");
INSERT INTO sce_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Bijien hhelase likai giedene chon souzhi zhijie Geshide kuruwo. Khuichudu Lojide kurudene hhense Padalade echiwo. ");
INSERT INTO sce_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Hhende nie Feiniji echiku chonyi penjidene chon jiere khirei yozhi qiiwo. ");
INSERT INTO sce_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ingie Saipulusiyi chanla soghei miende jiedene Xiliya fanxiande yozhi Tuilode kuruwo. Chon hhende ho xiine giezho. ");
INSERT INTO sce_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Bijien hhende ezighan tujilai ereizhi oludene doludu souwo. Hhela Shenlinyi kouizhi Baolode Yelusalende bu khirei giezhi kieliewo. ");
INSERT INTO sce_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Doludu daodene bijien yozhi qiiwo. Hhela bierei, kesilarene man bijienyi khughozhi chenshi ghadane ireghawo. Bijien haibienzide xiutulie onxian giedene ");
INSERT INTO sce_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","nieniedene feixin kieliewo. Bijien chon jiere khireise hhela gieladene khareiwo. ");
INSERT INTO sce_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Bijien izhi chon souzhi Tuilose Dolimaide kuruwo. Hhendedu gaijiulade kielien asazhi hhelare niudu souwo. ");
INSERT INTO sce_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Khuichudu bijien hhense likai gie Kaisaliyade iredene gouxioxi chonjisan Feilii giede oro hhere hhantu souwo. Hheshi dolon kun dundadu nie wo. ");
INSERT INTO sce_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Hhende uye dafalasan jieran oqin wine. Hhelade Hudai kielien kielieku nenli wine. ");
INSERT INTO sce_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Bijien hhende ezighancha souse Yudayase nie xienzhi bouzhewo. Niereini Yajiabu giene. ");
INSERT INTO sce_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Bijienyi enende iredene Baoloi pixiei bareizhi goya kha, konne banladene kieliewo, \"Shenlin ingiezhi kieliezho, 'Yutai kunla Yelusalende ene pixieni ezhanyi ingiezhi banladene niman kunlade jiuizhi ogine.'\" ");
INSERT INTO sce_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Bijien ene kielienyi chenliedene hhe oronyi kunlare Baoloi Yelusalende bu khirei giezhi hende danlazho. ");
INSERT INTO sce_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ingie Baolo kieliewo, \"Ta yale ingiezhi wilazhi mii zhughei ghalughane? Bi Ezhan Ersade oluzhi kunla mii banlazhi pse Yelusalende fugughaliuzhe bi zhunbei gie goudazho.\" ");
INSERT INTO sce_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Bijien Baoloi kieliezhi dao dase yama ese giedene zinie \"Ezhanyi isi mutun gholu gie.\" giezhi kieliewo. ");
INSERT INTO sce_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Giedudu daodene bijien zhunbei gie Yelusalende khireiwo. ");
INSERT INTO sce_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Kaisaliyani giedun tujilaye bijienre hhantu echiwo. Hhela bijienyi uduruzhi Nasun giesan nie Saipulusi kunyi giede echiwo. Hhe tuji danlazhi oloncha olune. ");
INSERT INTO sce_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Yelusalende kuruse gaijiula bijienyi bayasuzhi jienliewo. ");
INSERT INTO sce_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Khuichudu Baolo bijienre hhantu Yagebui uzhele echiwo. Zhanlaolaye man hhende wine. ");
INSERT INTO sce_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Baolo hhelade kielien asadene Huda hhei niman kunlai dunda gieghasan wilielai nienieji kieliezhi ogiwo. ");
INSERT INTO sce_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Hhela chenliedene Hudai kuaizhi Baolode kieliewo, \"Gaijiu, chi mejiene. Ezhanyi xianxin giesan Yutai kun hao jiwon wine. Hhela Musani guijinde chighara no wo. ");
INSERT INTO sce_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Hhela chenliese chi sughazhi niman kunlai dundadedu soyuji Yutai kunlai Musai guijinni bu zunjizhi ga kewosilade hetoune bu giegha giezho. Pse hhelai xigonni bu dagha giezho. ");
INSERT INTO sce_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ede matugiene? Kunla chi enende iresei mejiene. ");
INSERT INTO sce_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Chi zhao bijienyi kielien mutun giele echi. Bijienyi enende jieran kunla kielien yenji jiezho. ");
INSERT INTO sce_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Chi hhelare hhantu echizhi waghaku xigonghala hhantu wagha. Hhelai qiorun duliku baerni chi ogi. Ingiese hhela chenliesanshi zhenni pusho bikui, pse chi Musai guijinni zunjisei dajiala mejiene. ");
INSERT INTO sce_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Bijien Ezhanni xianxin giesan niman kunlade nigiedade teisan, chusun, lei alasan, lon kijieku enelase gholodo giezhi jiejin giedene xin huaiwo.\" ");
INSERT INTO sce_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ingiese Baolo hhe jieran kunyi uduruzhi khuichudu waghaku xigonghala hhelare hhantu waghawo. Ingie mechide orodene hhela waghazhi baluku udui, pse jien kun Hudade mure ogiku uduni tunzhi giewo. ");
INSERT INTO sce_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Hhe doludu barane giekude Yaxiyase iresan Yutai kunla Baolo mechide bikui chanladene olon kunlai man shanjizhi Baoloi barei agiwo. ");
INSERT INTO sce_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ingie waradazhi kieliewo, \"Isilie kunla, bijiende ishula! Ene kun gochude toreizhi jien kunlade mai kun, guijin, mechii fandui giezhi sughazho. Hhe da niman kunlai uduruzhi mechide oro ene zhiguitu oronyi zannanshighawo.\" ");
INSERT INTO sce_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Hhela ingiezhi kieliekushi Ifuso kun, TelofeimoBaologhala chenshide bisei chanlasenu Baolo hhei mechide uduru orowo giezho. ");
INSERT INTO sce_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Nie chenshi man londazhi bexinla holu ire, Baoloi barei agidene mechise lai khireighawo. Ingie mechini wijienyi deigo kha jiewo. ");
INSERT INTO sce_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Kunla zhen Baoloi alane giekude buduilani qienfuzhande Yelusalen nie chenshi man londawo giezhi huibao giewo. ");
INSERT INTO sce_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ingie qienfuzhan deigo budui, giedun baifuzhanlai uduru holuzhi hhelai hhende bouwo. Hhela qienfuzhan, buduilai chanladene Baoloi eghiku beiwo. ");
INSERT INTO sce_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ingie qienfuzhan melie echi Baoloi barei agidene fenfulazhi ghua qieshenghala sozila giezho. Ingiedene, \"Hheshi kien wine, yan shiqin giezho?\" giezhi asazho. ");
INSERT INTO sce_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Niezhan kunla ingiezhi onghonone, niezhan kunla qingiezhi onghonone. Ingiezhi noise qienfuzhan yan shiqin bikui mejie da, Baoloi laidene buduila sousan loude echi giezhi fenfulawo. ");
INSERT INTO sce_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Louqi konde irese olon kunla hende jigheidazhi eghine giese buduila zinie Baoloi qienlie daowo. ");
INSERT INTO sce_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Kunla khuina daghazhi, \"Hhei ala!\" giezhi waradazho. ");
INSERT INTO sce_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Baoloi buduila sousan lou sudoro lai orone giekude Baolo qienfuzhande asawo, \"Bi chade nie aman kielien kieliese olunulie?\" Hhe kieliewo, \"Chi Xila kielien kielie mejienu? ");
INSERT INTO sce_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Chishi hhe oloncha daolon giedene 4000 shashoui uduruzhi hontande echisan hhe Aiji kun pushoba?\" ");
INSERT INTO sce_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Baolo kieliewo, \"Bishi Yutai kun wo. Jilijiani nie minshentu chenshi Dashuni hukouni bareizho. Bi chii xiahua gieye, mii bexinlade nie kielien kieliegha.\" ");
INSERT INTO sce_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Qienfuzhan tunyi oluse Baolo louqi jiere beidene bexinlade nie kha zhadeighase shenqi widawo. Ingiese BaoloXibolai kielienghala kieliewo. ");
INSERT INTO sce_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","\"Oqio kunla, gaijiula, bi goyane huizhi kieliesan kielienyi ta chenliendu.\" ");
INSERT INTO sce_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","BaoloXibolai kielienghala kieliese hhela chenliedene genjia nanranshiwo. Ingie Baolo kieliewo, ");
INSERT INTO sce_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","\"Bishi Yutai kun wo. Jilijiani Dashude oludene ene Yelusalen chenshide fugiedazhi Jiamalieni kha doura suruzho. Matanyi xienrenlani guijinyi chigharade suruzhi Hudade rexin wo. Edeku tanre niekielien wo. ");
INSERT INTO sce_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Bi eqighanse ene daolini daghasan kunlai heizhi fugughakude kuruwo. Ere kun, biereilai banlazhi bafanzide khawo. ");
INSERT INTO sce_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ene shiqinde hhe nie zui fugie buwa, soyuji zui fugie fayenni zhanlaola man ganzhen bei shidane. Bi hhelai hhense xinni keredene Damashigeni gaijiulai hhende echi, hhendedu xianxin giesan kunlai barei Yelusalende lai echi faine giezho.\" ");
INSERT INTO sce_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","\"Bi Damashigede yozhi kurukude zhen zhunwu shihou wo. Menzhali asiman jierese fugie gonqi faizhi mii simiende zhouizho. ");
INSERT INTO sce_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Bi zemin jiere fura bouse nie shenqi made kieliewo, 'Saolo! Saolo! Chi mii yangiezhi heine?' ");
INSERT INTO sce_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Bi asawo, 'Ezhan, chishi kien wo?' Hhe kieliewo, 'Bishi chi heisan Nasale kun Ersa wo.' ");
INSERT INTO sce_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Mare hhantu yosan kunla hhe gonqii chanlawoma, made kieliesan shenqini sonosu dazho. ");
INSERT INTO sce_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Bi kieliewo, 'Ezhan, bi matugiene?' Ezhan kieliewo, 'Bosidene Damashigede echi. Hhende nie kun chi yan gieku shiqinni man kieliene.' ");
INSERT INTO sce_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Hhe gonqini gieghanghala bi sugho gholuwo. Hhantu yosan kunla mii khase laizhi Damashigede orowo.\" ");
INSERT INTO sce_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","\"Hhende nie kunyi niereiini Yananiya giene. Hheshi nie xienliantu kun wo, guijin jiere chighara wo. Hhende sousan Yutai kunla man hhei zunzhun giezho. ");
INSERT INTO sce_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Hhe mii uzhele ire kanzidemi beidene Saolo gaijiu, chi chanla giezhi made kieliewo. Ingiekude bi nie uzhese hhei chanlawo.\" ");
INSERT INTO sce_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","\"Ingie hhe kun kieliewo, 'Mai xienrenni Huda chii sunghudene goyane isii mejieghazhi hhe gou kunni chanlaghazhi shenqiini chenlieghawo. ");
INSERT INTO sce_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Chi chanlasan, chenliesanne soyuji kunlai melie hhe kunde ganzhen beine. ");
INSERT INTO sce_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Chi ede yan sagheizho? Bosidene Ezhanyi xiahua giezhi xilii jienliedene goya zuine waghazhi widagha.'\" ");
INSERT INTO sce_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","\"Khuinashi bi Yelusalende khareidene mechide zhen onxian giekude zhoujin mutun nie ghudureqi chanlase ");
INSERT INTO sce_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ezhan made kieliewo, 'Chi ghujighan Yelusalense likai gie. Chi made beisan ganzhenni hhela ulie jienliene.' ");
INSERT INTO sce_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ingie bi kieliewo, 'Ezhan, eqighandei bi chii xianxin giesan kunlai bafanzide khazhi pse go huitanlade hhelai eghisei hhela goyane mejiene. ");
INSERT INTO sce_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Pse chade ganzhen beisan Siqifanyi heizhi chusun usurukude biye kanzide beizhi tunyi giezhi hhei alasan kunlade oluzhi jienlaini uzhezhi ogizho.'\" ");
INSERT INTO sce_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","\"Ingieliuzhe Ezhan made kieliewo, 'Chi echi, bi chii peizhi gholododu niman kunlai hhende echighane.'\" ");
INSERT INTO sce_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Bexinla ene nie aman kielienyi chenliedene fugiede kieliewo, \"Intu kunyi duya jierese widagha! Hheshi fugukuni wo!\" ");
INSERT INTO sce_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Hhela izhi onghonozhi jienlane bendazhi turai asiman jiere khisigheise ");
INSERT INTO sce_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","qienfuzhan fenfulazhi Baoloi buduila sousan lou sudoro orogha, mabienzighala eghizhi kunla yangiezhi onghonosei asa giezho. ");
INSERT INTO sce_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Eghine giezhi banlakude Baolo kanzide beisan baifuzhande kieliewo, \"Bishi Loma kun wo. Zui ese jinjidene eghise falighala kieliese tande oluzhoye?\" ");
INSERT INTO sce_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ene kielienni chenliedene baifuzhan qienfuzhande echidene kieliewo, \"Ene kunshi Loma kun wo. Chi matugiene giezho?\" ");
INSERT INTO sce_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Qienfuzhan ire Baolode asawo, \"Chi made kielie, chishi Loma kun onu?\" Baolo kieliewo, \"Enbene.\" ");
INSERT INTO sce_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Qienfuzhan kieliewo, \"Bi olon baer huaizhi Loma gojiani hukoude orowo.\" Baolo kieliewo, \"Bi olusanse enbene.\" ");
INSERT INTO sce_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ingiese Baoloi eghizhi asane giesan kunla hhense deigo likai giewo. Qienfuzhan banlasan Baoloshi Loma kun bikui mejiedene ayizho. ");
INSERT INTO sce_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Khuichudu qienfuzhan Yutai kun Baoloi zhasan shiqinni mejiene giezhi hhei andaghadene fenfulazhi fugie buwa, zui fugie fayenni kunlai man hhantulaghasenu Baoloi uduru ire hhelai melie beighawo. ");
INSERT INTO sce_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Baolo zui fugie fayenni kunlai nudunne ese agi uzhezhi kieliewo, \"Gaijiula, bi Hudai melie giekude lianxin ese ghudanduzhi izhi eli kuruwo.\" ");
INSERT INTO sce_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ingie zui fugie buwa YananiyaBaoloi kanzide beisan kunlade hhei aman jiere eghi giezhi fenfulawo. ");
INSERT INTO sce_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ingiese Baolo hhende kieliewo, \"Chi ene mienzide khireisan kun, ghadane seighan wo, sudoro zannan wo. Huda chii eghine! Chi hhende souzhi guijinghala mii panjine giedene da guijinni fanjizhi mii eghi giezhi fenfulanu?\" ");
INSERT INTO sce_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Kanzide beisan kunla kieliewo, \"Chi lien Hudai zui fugie buwai sugienu?\" ");
INSERT INTO sce_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ingie Baolo kieliewo, \"Gaijiula, hheshi zui fugie buwa bikui bi mejie dawo. Bexinni gonjisan noyenne bu sugie giezhi jinwun jiere kieliezho.\" ");
INSERT INTO sce_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Baolo hhelai dundadu olieshi Sadugai kun, olieshi Falisai kun bikui uzhe khizhedene zui fugie fayenni kunlade fugiede kieliewo, \"Gaijiula, bishi Falisai kun wo, Falisai kunni houdei wo. Bi fugusan kun fuho giekui xianxin giese made shenwun giezho.\" ");
INSERT INTO sce_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ene kielienyi kieliese Falisai kun, Sadugai kunghala jianjidu qii kunla ghugha keiwo. ");
INSERT INTO sce_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Yenlai Sadugai kunla kieliese qienxien, ruhher uwo, fuho gieku shiqinye uwo giezho. Falisai kun kieliese enela man wine giezho. ");
INSERT INTO sce_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Kunla fugiede onghono qiiwo. Giedun Falisai paini jinwun hanjiala bosi ire hende jianjiduzho, \"Ene kun yan codasei bijien ereizhi khizhe dawo. Kenen ruhher, qienxienla hhende kielien kieliezhoba.\" ");
INSERT INTO sce_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ingie jianjiduzhi hendawo. Qienfuzhan Baoloi sida zhazhazi gholughakuse ayizhi buduilai fenfula boughadene hhei qianla khizhe buduila sousan loude echigha giewo. ");
INSERT INTO sce_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Hhe xii Ezhan Baoloi kanzide beizhi kieliewo, \"Chi danzine fugiedagha. Chi Yelusalende matugie made ganzhen beizhoshi Lomadeye qingiezhi ganzhen beikuni wo.\" ");
INSERT INTO sce_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ogheidene Yutai kunla qioqioji shanlian giedene fayen giezhi kieliewo, \"Baoloi ulie alatula matan ulie ijiene, ulie ochine.\" ");
INSERT INTO sce_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ingiezhi hhantu fayen giesan kun 40 gie daozho. ");
INSERT INTO sce_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Hhela fugie buwa, zhanlaolai shida echidene kieliewo, \"Bijien Baoloi ulie alatula yama ulie ijiene giezhi fayen gie goudaghazho. ");
INSERT INTO sce_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Ta ede zui fugie fayenni kunlare hhantu qienfuzhande kieliezhi Baoloi tai enende uduru iregha. Jiazhon giezhi pse xianxide hhei shiqinni asane giezhi kielie. Bijien zhunbei gie goudazho. Hhe kuzhetula ala widaghane.\" ");
INSERT INTO sce_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ingie Baoloi wishen hhela ghulazhi giesan jihuai sonosudene buduila sousan loude echi Baolode kieliewo. ");
INSERT INTO sce_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ingie Baolo nie baifuzhanyi uruzhi ire kieliewo, \"Chi ene nasuchighan kunyi udurudene qienfuzhanyi shida echi. Hhe hhende nie shiqin huibao giene.\" ");
INSERT INTO sce_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ingiese baifuzhan hhei uduruzhi qienfuzhanyi shida echi \"Bareisan Baolo mii uruzhi echi xiahua giezhi ene nie nasuchighan kunyi udurudene chade nie shiqin kielieghane.\" giezhi kieliese ");
INSERT INTO sce_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Qienfuzhan hhei khase laizhi niemiende echi asawo, \"Chi made yan shiqin kieliene?\" ");
INSERT INTO sce_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Hhe kieliewo, \"Yutai kunla Baoloi shiqinde xianxide asane giezhi jiazhon giedene maghashijie hhei zui fugie fayende uduru iregha giezhi chii xiahua giekui shanlian gie goudawo. ");
INSERT INTO sce_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ingiese chi hhelanughunyi bu chenlie. Baoloi ulie alatula ulie ijiezhi ulie ochine giezhi fayen giesan 40 dogie kunla ede alane giezhi niuizho. Ede zhunbei gie goudazhi chii dain giekui sagheizho.\" ");
INSERT INTO sce_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ingiese qienfuzhan nasuchighan kunde ene shiqinyi chi made kieliewo giezhi kiemade bu kielie giezhi fenfuladene hhei echighawo. ");
INSERT INTO sce_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Qienfuzhan ghua baifuzhanyi uru ire kieliewo, \"200 gie yosan budui, 70 gie morei unusan budui, 200 gie zhida bareisan buduilai zhunbei gie. Ene xii 9 jiende Kaisaliyade echine. ");
INSERT INTO sce_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Pse morei zhunbei giezhi Baoloi unughadene baohu giezhi Feilisi shenzhanni hhende khughozhi echigha.\" ");
INSERT INTO sce_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Hhe xin huaizhi kieliewo, ");
INSERT INTO sce_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","\"Kelaoji-LixiyaFeilisi shenzhande kielien asazho. ");
INSERT INTO sce_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ene kunyi Yutai kunla bareizhi alane giekude hheshi Loma kun bikui bi mejiedene buduilai uduru echi hhei jiui khizhewo. ");
INSERT INTO sce_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Hhela hhei yangiezhi zhasan shiqinyi bi mejiene giezhi hhei uduru hhelai zui fugie fayende echiwo. ");
INSERT INTO sce_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Hhei zhasanshi zi hhelai jiomunni guijin jieredu shiqin bikui bi mejiewo. Yama fugughaku, banlaku zui uwo. ");
INSERT INTO sce_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Khuinashi Yutai kunla hhei alane giesan jihuai nie kun made kieliese bi hhei deigo chii hhende ireghawo. Pse minlin xiaizhi hhei zhasan kun chii melie iredene zha giewo.\" ");
INSERT INTO sce_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Ingiese buduila zhao fenfulasan mutun xienidei Baoloi uduru Anqipajide echighadene ");
INSERT INTO sce_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","khuichudu morei unusan buduila Baoloni khughozhi echigha, yosan buduila sousan loudene khareiwo. ");
INSERT INTO sce_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Morei unusan buduila Kaisaliyade ire xinni shenzhande ogisenu Baoloni hhende jiuizhi ogiwo.'' ");
INSERT INTO sce_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Shenzhan xinni uzhe, \"Baoloshi alinie shenni kun wo?\" giezhi asadene Jilijiani kun bikui mejie kieliewo, ");
INSERT INTO sce_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","\"Chii zhasan kunla irese panjiye.\" Ingie kunlade fenfulazhi Baoloi Hherode hongunde khawo. ");
INSERT INTO sce_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Tawudu daodene zui fugie buwa Yananiya giedun zhanlao, pse nie Qietulo giezhi lishire hhantu iredene shenzhande Baoloi zhazho. ");
INSERT INTO sce_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Baoloi uduru irese Qietulo hhei zhazhi kieliewo, \"Feilisi fugie noyen, bijien chii yenyinghala chanqi nanrande udu daozhi chini melie uzheku aghelighala ene gojia fazhan giezhi goudazho. ");
INSERT INTO sce_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Bijien suishisui chade hende mafan kieliezho. ");
INSERT INTO sce_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Bijien chii olon mafan ulie gieghane. Chii xiahua gieye, zhughene aghuidaghazhi bijienyi giedun aman kielienyi nie chenlie. ");
INSERT INTO sce_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Bijien ene kunyi uzhese inzhaku gien niekielien wo. Qienxiani Yutai kunlai shanjizhi londaghazho. Hheshi Nasale jiomunni nie touzi wo. ");
INSERT INTO sce_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Mechini zannanshighane giese bijien hhei bareiwo. ");
INSERT INTO sce_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Chi goyane ene kunyi shenwun giese bijien hhei zhasan shiqinlai man mejiene.\" ");
INSERT INTO sce_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Yutai kunla daghadene shiqin intui enbene giezhi hhei zhazhi kieliewo. ");
INSERT INTO sce_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Shenzhan qiorun jienjizhi Baoloi kielie giese Baolo kieliewo, \"Chi ene gojiade fayenni yenzhan haojinien danlasei bi mejiene. Ingiese bi bayasuzhi goyane huizho. ");
INSERT INTO sce_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Bi libai giele Yelusalende khizhezhi 12 qienda ese olusei chi nie chaima mejiene. ");
INSERT INTO sce_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Bi mechide kunlare jianjindusei, huitande, chenshini go oronlade kunlai shanjisei hhela chanlazhi ese daozho. ");
INSERT INTO sce_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Hhela ede mii zhasan shiqinde chade yama zhenji ogi dane. ");
INSERT INTO sce_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ingiese bi chade nie shiqinni chenren gieye. Hhela xiejio wo giesan ene daolini bi daghazhi bijienyi xienrenyi Hudai beiizho. Guijinshu, xienzhini shu jiere jilasanyi man xianxin giezho. ");
INSERT INTO sce_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Pse ene kunla xianxin giesan mutun gou kun, gou witu kunla man fuho giekui bi Hudase panjizho. ");
INSERT INTO sce_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ingiese bi Hudai melie, kunlai melie chan lianxin ulie ghudandune giezhi xiacha giezho. ");
INSERT INTO sce_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Jinien daodene bi goya minzune nanxin kunlade baer khughozhi Hudade mure ogine giezhi Yelusalende irewo. ");
INSERT INTO sce_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Bi mechide ogine giezhi waghazhi ganjinrasei hhela chujieghewoma, olon kunlare hhantu uwo, daolonye ese giezho. ");
INSERT INTO sce_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Zinie Yaxiyase iresan giedun Yutai kunla hhende wo. Hhelade mii zhaku shiqin bise chii shida irezhi zhane. ");
INSERT INTO sce_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Pse enezighan kunla bi zui fugie fayen melie bidene mii yan codasei mejiewoshi goyalane nie kielie gie. ");
INSERT INTO sce_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Bi zinie hhelai dunda beizhi ene nie aman kielienyi fugiede kieliewo, 'Enedu tai melie made shenwun giekushi fugusan kun fuho giesan shiqin wo.'\" ");
INSERT INTO sce_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feilisi ene daolini xiandan qinchu wo. Ingie shenpanhuini danlazhi beighadene kieliewo, \"Lixiya qienfuzhan bouzhese bi tai shiqinni panjiye.\" ");
INSERT INTO sce_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ingiese baifuzhande fenfulazhi Baolode ezighan ziyu ogizhi hhei uzhe giewo. Pse zhanlienlani hhende injiku dunxi ogise bu danla giezho. ");
INSERT INTO sce_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Giedudu daodene Feilisi biereighalane Baoloi ochirale irewo. Hhei biereishi Yutai kun wo. Niereini Tuxila giene. Baoloi uruzhi iresenu Ersa Mexihani xianxin gieku daolii kielieghazhi chenliene giezho. ");
INSERT INTO sce_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Baolo gundande gieku, goyane kunzhi gieku, jianlai ireku shenpanni kieliese Feilisi hende ayidene kieliewo, \"Chi xian echi, made fanbien winekude chii uruzhi ireye.\" ");
INSERT INTO sce_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","FeilisiBaolo hhende baer ogimu giezhi onxian giezhi hhei olonfa uruzhi ire kielien kielienduzho. ");
INSERT INTO sce_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ghua hon gierudene Boqiu-FeisiduFeilisini oronde noyen danlawo. FeilisiYutai kunlai bayasughane giezhi Baoloi bafanzide kha jiezho. ");
INSERT INTO sce_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","FeisiduKaisaliyade noyen danlazhi ghurudu oludene Yelusalende khireiwo. ");
INSERT INTO sce_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Hhende fugie buwa, Yutai kunni noyenla Feisidude Baoloi zhazho. ");
INSERT INTO sce_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Feisidui xiahua giezhi banman kerezhi Baoloi Yelusalende iregha giezho. Hhela mo jiere Baoloi alane giezhi jihua giezho. ");
INSERT INTO sce_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Feisidu kieliewo, \"Baoloi ede Kaisaliyade khazho. Bi deigo hhende echine giezho. ");
INSERT INTO sce_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Tai dunda qienlitu kun mare hhantu bousenu hhe kunde yan zui wineshi hhei zha.\" ");
INSERT INTO sce_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Feisidu hhelai hhende neimudu, hharudu soudene Kaisaliyade bouwo. Khuichudu hui keine giezhi shenpantai jiere soudene fenfulazhi Baoloi uduru ire giewo. ");
INSERT INTO sce_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Baolo irese hhezighan Yelusalense bouzhesan Yutai kunla zhouwideni beizhi olon, gundu zuighala hhei zhazhoma, yama zhenji ogi dazho. ");
INSERT INTO sce_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Baolo goyane huizhi kieliewo, \"Bugon Yutai kunyi guijin, mechi, pse Kaisa honshande bi zui fanjizhi ese daozho.\" ");
INSERT INTO sce_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","FeisiduYutai kunlai bayasughane gie Baolode asawo, \"Chi Yelusalende khireidene bi ene shiqinyi shenwun giese duran winu uwo?\" ");
INSERT INTO sce_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Ingiese Baolo kieliewo, \"Bi ede Kaisa honshanni shenpantai melie beizho. Enende made shenwun giese indanji wo. Bi Yutai kunlade yama codasan shiqin giezhi ese daosei chiye qinchu wo. ");
INSERT INTO sce_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Bi codasan shiqin giezhi fuguku zui wineshi fuguliuzhe made yama kieliekui uwo. Hhela mii zhasan shiqinshi zhenni pushoshi kiemada mii hhelade jiuizhi ogi dane. Bi Kaisa honshande zhane.\" ");
INSERT INTO sce_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Feisidu goya kunlarene shanlian giedene kieliewo, \"Chi Kaisa honshande zhase Kaisa honshanyi hhende echikuni wo.\" ");
INSERT INTO sce_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Giedudu daodene Yajipa honshan Beinisighala Kaisaliyade irezhi Feisidude kielien asawo. ");
INSERT INTO sce_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Hhende ezighancha soukude FeisiduBaoloni shiqinyi Yajipa honshande kieliewo, \"Enende nie fanren wine. Feilisi feilieghasan wo. ");
INSERT INTO sce_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Bi Yelusalende bikude Yutai kunni fugie buwa, zhanlaola hhei shiqinyi made zhazhi, \"Hhende zui jinji!\" giezhi xiahua giewo. ");
INSERT INTO sce_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Bi hhelade Loma kunni falishi zhasan kun duifanghala ulie hhantulazhi duifande goyane huiku jihui ulie ogidene zui jinjise ulie olune giezhi kieliewo. ");
INSERT INTO sce_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Ingiese hhela enende irese bi danwu ese giezhi khuichudu shenpantai jiere soudene fenfulazhi hhe kunyi uduru ire giewo. ");
INSERT INTO sce_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Zhasan kunla beidene hhei zhase bi sumulasan qintu doghun shiqin pusho. ");
INSERT INTO sce_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Hhela zinie goyai jiomunni shiqin jiere, pse fugusan Ersa giesan nie kunyi shiqin jiere jianjinduzho. Baolo kieliese hhe kun amitu wo giezho. ");
INSERT INTO sce_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Bi enei matugie chaikui mejie da, \"Baolode ene shiqinyi Yelusalende khireidene shenwun giese duran winuwo?\" giezhi asawo. ");
INSERT INTO sce_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ingiese Baolo mii xiahua giezhi goyane feilieghadene Kaisa honshan jiejin gie giezho. Ingie bi hhei Kaisa honshanyi hhende khughozhi echighatula feiliegha giezhi fenfulawo.\" ");
INSERT INTO sce_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","YajipaFeisidude kieliewo, \"Bi goyane ene kun kieliekui chenlieku duran wine.\" Feisidu kieliewo, \"Maghashijie chi chenlie.\" ");
INSERT INTO sce_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Khuichudu YajipaBeinisighala yoqi yoqi daqinde irewo. Qienfuzhan, hhe chenshini minshen fugietu kunlaiye deilazhi orowo. Feisidu nie fenfulase Baoloi uduru irewo. ");
INSERT INTO sce_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Feisidu kieliewo, \"Yajipa honshan, pse enende bisan dajiala, ta uzhesan ene kunshijiu Yelusalenni, pse enendedu Yutai kunla man made fugiede waradazhi yoqiu giezhi hhei amitu feilieghase ulie olune giesan hhe kun wo. ");
INSERT INTO sce_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Bi chaise hhende yama fuguku zui uwo. Pse hhe goyane Kaisa honshande zhane giese bi hhei khughozhi hhende echighane giezhi jiejin giewoma, ");
INSERT INTO sce_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","ene kunyi xianxi shiqinyi Kaisa honshande huaikui uwo. Ingie yama huaiku dunxi enende chaizhi olu shidanu gie, tai melie, yuqishi chi Yajipa honshanyi melie hhei uduru irewo. ");
INSERT INTO sce_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Bi sumulase zhaku shiqinyi kieliezhi qinchu ulie olughadene fanrenni khughokude heshi uwo giezho.\" ");
INSERT INTO sce_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","YajipaBaolode kieliewo, \"Chi goyadene oluzhi kielie.\" Ingiese Baolo khane zhadeigha goyane huizhi kieliewo, ");
INSERT INTO sce_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","\"Yajipa honshan, Yutai kunla mii zhasan shiqinde enedu chii melie bi goyane huise mii inqi gou wo. ");
INSERT INTO sce_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Tebieshi chi Yutai kunlai xigon, jianjindukulai man shuxi wo. Ingiese bi chii xiahua gieye, chi rennai giezhi bi kieliesanyi chenlie.\" ");
INSERT INTO sce_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","\"Bi meila shihouse izhi goya kun dundane Yelusalende matugie giesei Yutai kunla man mejiene. ");
INSERT INTO sce_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Bishi mai jiomun dundadu zui chigharadu Falisai paini nie goude giesan kun bikui hhela eqighanse mejiene. Enei hhela duran bise ganzhen bei shidane. ");
INSERT INTO sce_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ede mii enende beigha shenwun giekushi Huda mai xienrenlade dain giesei bi panjiwo giezho. ");
INSERT INTO sce_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ene panjikushi mai 12 gie paini kunla xieni udu Hudai goude beiizhi ene dain giesei gholuse giesan hhe wo. Honshanya, ene nie panjiku yenyin jiere Yutai kunla mii zhazho. ");
INSERT INTO sce_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ta yale Huda fugusan kunlai aminne olughase xianxin giekui pusho giezho?\" ");
INSERT INTO sce_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","\"Shijishan bi goyane Nasale kun Ersai jinlianji fandui giese indanji wo giezhi sumuladene ");
INSERT INTO sce_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Yelusalende ingiezhi giewo. Fugie buwalase qienli keredene shentulai bafanzide khazhi, da hhelai sixin panjikude beizhi bi tunyi oluwo. ");
INSERT INTO sce_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Bi pse go huitanlade olonfa hhelai faizhi biidene Ersani sugieghazho. Bi hhelade hende hokuzhi da niman kunlai chenshilade echizhi heizho.\" ");
INSERT INTO sce_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","\"Ene mujighala bi fugie buwalase qienli, minlinni bareidene Damashigede echine giezho. ");
INSERT INTO sce_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Honshanya, zhunwude bi mo jiere yokude chanlase asimanse gon faizhi naranse da gieghan wo. Simiende bi, bighala hhantu yosan kunlai zhouizho. ");
INSERT INTO sce_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Bijien man zemin jiere fura bouse nie shenqi Xibolai kielienghala made kieliewo, 'Saolo! Saolo! Yale mii heine? Chi fugherei mutun ezhanni eghesuntu teiyai qiuise goyane shanjine.'\" ");
INSERT INTO sce_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","\"Ingiese bi kieliewo, 'Ezhan, chishi kien wo?' Ezhan kieliewo, 'Bishi chi heisan Ersa wo. ");
INSERT INTO sce_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Chi bosizhedene bei. Bi goyane chade xienjighakushi chii goyadene hoji danlaghazhi chi mii chanlasan shiqinde, pse bi chade jianlai xienjighaku shiqinde ganzhen beighane giezho. ");
INSERT INTO sce_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Bi chii Yutai kunlai, niman kunlai dundase jiuizhi khizhene. Bi chii peizhi hhelai hhende echighadene ");
INSERT INTO sce_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","nudunlaini keighazhi kharanise gon dunda ireghane. Ibilisii nenlise likai gieghazhi Hudade shunjighane. Ingiese mii xianxin giezhi zuini mienliedene zhiguitu gholusan kunlare hhantu guzide beighane.'\" ");
INSERT INTO sce_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","\"Yajipa honshanya, bi asimanse iresan zhoujin mutunyi shunjizhi ");
INSERT INTO sce_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","xien Damashigede, pse Yelusalende, Yudayani go oronlade, niman kunlade chonjizhi geizhen giedene Hudade shunjizhi geizhen giesan shiqinne giezhi uzhegha giewo. ");
INSERT INTO sce_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ene yenyin jiere Yutai kunla mechide mii barei agidene alane giezho. ");
INSERT INTO sce_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ingieliuzhe enedu kurutula Huda made banman giese bi enende beizhi undu kun boghoni kunliuzhe hhelade man ganzhen beizho. Xienzhila, Musa kieliezhi jianlai fashen giene giesan shiqinse chugo bi yama ese kieliezho. ");
INSERT INTO sce_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Hheshijiu Mexiha bixi shouku giedene fugusan kun dundase xien aminne oludene Yutai kun, niman kunlade gonni mejieghane giesan wo.\" ");
INSERT INTO sce_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Baolo ingiezhi huise Feisidu fugiede kieliewo, \"Baolo, chi fenjiulizho. Chii unhua texien undudase chii fenjiulighazho!\" ");
INSERT INTO sce_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Baolo kieliewo, \"Feisidu fugie noyen, bi uye fenjiulizho. Bi qinchude sumulasan daolini kieliezho. ");
INSERT INTO sce_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Honshanye ene shiqinlai mejiene. Ingiese bi uye ayizhi hhende kieliezho. Ene shiqinni beimiende ese giezho, ingiese enelai noyende nieda mii dakui bi mejiene. ");
INSERT INTO sce_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Yajipa honshanya, chi xienzhini xianxin gienu? Chi xianxin giekui bi mejiene.\" ");
INSERT INTO sce_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Ingiese YajipaBaolode kieliewo, \"Chi intughanighala mii kieliezhi Mexihani tuji gholughanu?\" ");
INSERT INTO sce_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Baolo kieliewo, \"Intughaniye olune, olonye olune. Chi, pse enedu enende chenliesan kunla man bi mutun gholuse giezhi bi Hudase onxian giezho, zinie bi mutun jieliu bu zho giezho.\" ");
INSERT INTO sce_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Ingiese honshan, shenzhan, Beinisi, pse sousan kunlare bosizhedene ");
INSERT INTO sce_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","khuina dao echi nieniedene kieliezho, \"Ene kun fuguku, khaku zui ese fanjizho.\" ");
INSERT INTO sce_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ingiedene YajipaFeisidude kieliewo, \"Ene kun Kaisa honshande ese zhazhoshi eqighan andaghawo.\" ");
INSERT INTO sce_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Bijienni chon soughazhi Idalide echighane giezhi jiejin giese hhela Baolo, psedu fanrenlai hongun buduilani nie baifuzhande jiuizhi ogiwo. Niereini Yuliu giene. ");
INSERT INTO sce_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Niekozi Yadamiqiense iresan chon Yaxiya oronni haibienzighun yone giezho. Bijien hhe chon jiere khirei yowo. Bijienre hhantu yosanshi Maqidunni Qiesalonijia kun Yalidagu wo. ");
INSERT INTO sce_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Khuichudu Xidunde kuruwo. YuliuBaoloi danren giezhi zhanlienlaini uzheghale echise zhanlienlani Baoloi zhaogu giezho. ");
INSERT INTO sce_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Hhense chonni keizhi qiise kei shun uwoshi bijien keini piizhi Saipulusiyi beimienghun yozho. ");
INSERT INTO sce_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Bijien Jilijia, Panfeiliyani meliedu haini daodene Lijiani Meilade kuzhewo. ");
INSERT INTO sce_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Hhende niekozi Idalide echine giesan Yalishandani chonni penjise baifuzhan bijienyi hhe chon jiere khireighawo. ");
INSERT INTO sce_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Lienjizhi giedudu chon yozhi tanshi kuzhe dazhi ingiezhi cai Genitu bienzide kuzhewo. Kei bijienyi jiohoro giese Samonini bienzise keini piizhi Kelitedao douraghun yozho. ");
INSERT INTO sce_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Bijien bienzighun yose chon yozhi chijia no wo. Ingie cai Laxiya chenshini kouisan Seighan Haibienzi giezhi nie oronde irewo. ");
INSERT INTO sce_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Oloncha shijien danwu giezhi orozo bareiku shihou ijin daose pse chon keizhi wixiennudawo. Ingie Baolo kunlade sughazhi kieliewo, ");
INSERT INTO sce_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","\"Dajiala, bi uzhese enefa chon keizhi wixien no wo. Zinie ho, chonni qida olughaku pusho, matan aminne da gui dane.\" ");
INSERT INTO sce_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Baifuzhan Baoloi kielienni ese chenliezhi chon keisan kun, chonni ezhanyi kielienyi chenliezho. ");
INSERT INTO sce_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ene haibienzide uncha daoghaku chijia wo. Ingiese dabufen kunla hhense likai giezhi Feinikede echidene uncha daoghaye giezhi jiejin giewo. Feinikeshi Kelitedaoni nie haibienzi wo. Niemienni xinan miende wo, niemienni xibei miende wo. ");
INSERT INTO sce_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Ene shihoude nanbangiese ga kei bosiwo. Hhela sumulase zhao jihuaghala yose olune giezhi chon beighaku gougoui khizheghadene Kelitedaoi kouizhi yozho. ");
INSERT INTO sce_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Oloncha ese beidene nie honfenkei Kelitedao bienzise feilie irewo. Hhe honfenkeini nierei Dunbeifen giene. ");
INSERT INTO sce_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Chonni kei wiqi agise pse melie yo da, keini dagha yozho. ");
INSERT INTO sce_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Nie ga daoni nierei Gaoda giene. Bijien ene daoni kanzighun keini piizhi yozho. Khuina laisan ga chonni beigha dazhi ingiezhi beighawo. ");
INSERT INTO sce_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ga chonni laizhi khizhedene zhashighala fugie chonni zhouwini banla goudaghawo. Saierjini usu douradu shazide guai feilieghakuse ayizhi chon jieredu fugie popui bouzhegha chonni durare yoghawo. ");
INSERT INTO sce_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Bijienyi kei, lan izhi biidene jindaghase khuichudu hhela holai haide bendawo. ");
INSERT INTO sce_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Pse niudu daosenu hhela chonde injisan dunxilai qinsi bendawo. ");
INSERT INTO sce_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Hao giedudu naran, hodunyi chanla dawo. Honfenkei bijienyi biise bijienyi jiuiku xiwon widawo. ");
INSERT INTO sce_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Kunla giedudu yama ese ijiezho. Baolo hhelai dunda beidene kieliewo, \"Dajiala, ta mini kielienyi indan chenliekui wo. Kelitedaose likai ese giewoshi imeghei sunshiji qida olukui uwo. ");
INSERT INTO sce_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ede bi tande kielieye, ta zhughene tei. Tai kiemai amin nieda ulie widane, zinie chon widane. ");
INSERT INTO sce_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Mii gonjisan, bi beiisan Hudai qienxien uzhughu xii mii kanzide beizhi kieliewo, ");
INSERT INTO sce_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","'Baolo, bu ayi. Chi kenjin Kaisa honshanyi melie beine. Huda chighala hhantu chon sousan kunlade pinnan ogine.' ");
INSERT INTO sce_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ingiese dajiala, zhughene tei. Huda made matugiezhi kieliese qintui gholukui bi xianxin giene. ");
INSERT INTO sce_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Matanyi nie haini dao jiere guai feilieghane.\" ");
INSERT INTO sce_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","14 qien kurudene xienidei chon Yadeliyahai jiere hheliezhi eneman hheman giezho. Chabudu banyedei chon jieredu wiliechila zemin jiere chadashiwo gie, ");
INSERT INTO sce_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","jiochighala nie nanjise gunde 12 zhan wo. Melie gouji yodene pse nie nanjise 9 zhan wo. ");
INSERT INTO sce_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Hhela chon tashi jiere mughukuse ayizhi chon boghose jieran chon beighaku gougoui boughadene ogheikui panjizho. ");
INSERT INTO sce_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Wiliechila chon beighaku gougoui chon qiorunse boughazho giezhi yanzi gie, ga chonni usude bougha, holuku muji daizho. ");
INSERT INTO sce_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Baolo baifuzhan, buduilade kieliewo, \"Enezighan kunla chon jiere ulie feiliese ta aminne gui dane.\" ");
INSERT INTO sce_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Ingiese buduila ga chonni zhashii chizhi siragha anda boughawo. ");
INSERT INTO sce_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Ogheikude Baolo ashighalade ijiuni ijie giezhi sughazhi kieliezho, \"Ta izhi yama ese ijiezhi enedushi 14 qien oluwo. ");
INSERT INTO sce_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Ingiese bi tande sughazhi kielieye, ta gouji ijie. Ene tai aminni jiuine. Tai kiemadai nieganzi usunye ulie widane.\" ");
INSERT INTO sce_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Ingie Baolo ene kielienyi kieliedene ginanyi barei ashighalai melie Hudade mafan kieliedene ghulu ijiewo. ");
INSERT INTO sce_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ingie hhela man zhughene teizhi ijiewo. ");
INSERT INTO sce_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Bijien chon jiere 276 gie kun wo. ");
INSERT INTO sce_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Hhela ijie chududene chonni gongiereghane giezhi boudeilai haide bendawo. ");
INSERT INTO sce_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Ogheisenu hhela hhe oronyi tani dawoma, nie haibienzii chanlawo. Ingie chonni jinlianji bienzide echighane giezho. ");
INSERT INTO sce_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ingie jiesunyi chizhi siragha chon beighaku gougoui haide boughawo. Fanxian kunzhi gieku doni sularaghazhi popui lai khireighase zhao keizhe bienzide echiwo. ");
INSERT INTO sce_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Lianmienni usu hhantulasan shazitu oronde chonni qiorunyi jiai beighawo. Lan chon boghoi eghi qida olughawo. ");
INSERT INTO sce_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Ingiekude fanrenla unba holu widakuse ayizhi buduila hhelai alane giezho. ");
INSERT INTO sce_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Baifuzhan Baoloi jiuine giezhi hhelai ingiezhi ese gieghawo. Ingie fenfulazhi unba mejiechen kunla usude jioli bou, xien bienzide khirei giewo. ");
INSERT INTO sce_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Psedu kunla banba, chon jieredu dunxighala bienzide khirei gie wo. Ingiezhi dajialai jiuizhi usu bienzide khireiwo. ");
INSERT INTO sce_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Bijien pinnande bienzi jiere khirei, ene daoni Maerta giekui mejiewo. ");
INSERT INTO sce_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Hhe oronyi kunla bijiende gou no wo. Hhende ghura bouzhi qienqi kuiqienshi khan sideraghazhi bijienyi zhaogu giewo. ");
INSERT INTO sce_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Baolo ezighan muzhai qiangu ire khande teise nie mogheii tulie bazilie da, holu khizhe Baoloi khaini jinji beizho. ");
INSERT INTO sce_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Hhe oronyi kunla moghei hhei kha jiere horo beisanyi chanladene nieniedene kieliezho, \"Ene kunshi kenjin nie sharenfan wo. Haise jiui khizhewoma, asiman hhei aminne ulie olughane.\" ");
INSERT INTO sce_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Baolo mogheini khande benda oroghawoma, shan ese deilazho. ");
INSERT INTO sce_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Hhela sumulase hhe khaitumu, pse zemin jiere fura boudene fugumu giezho. Oloncha sagheise yama uye giesei chanladene kharei hheshi nie huda wo giezho. ");
INSERT INTO sce_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Hhe shida nie ghazha wine, dao jieredu zui fugie noyen Bubailiunughun wo. Hhe bijienyi jienliezhi shixinji ghurudu zhaodai giewo. ");
INSERT INTO sce_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Ingiekude Bubailiuni adani fashao giezhi xieli kudene kijiezho. Baolo orozhi echi onxian giezhi hhei jiere khane teiwo. ");
INSERT INTO sce_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Ingiese dao jieredu gientulaye irezhi man goudaghawo. ");
INSERT INTO sce_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Hhela bijienyi hende danren giezhi bijien yokude mo jiere injiku dunxilai chon jiere khughozhi ogiwo. ");
INSERT INTO sce_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Dao jiere ghuran sara beidene bijien nie Yalishandase iresan chon jiere khirei yo qiiwo. Ene chonshi haini dao jiere uncha daoghasan wo, qiorun jiereni Shongo giesan hao teizho. ");
INSERT INTO sce_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Bijien Xilagude kurudene ghurudu beiwo. ");
INSERT INTO sce_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Pse hhense raoizhi Lijiwunde echiwo. Niudu daose nanbangieni kei bosise khuichudu Bujiulide kuruwo. ");
INSERT INTO sce_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Hhende ezighan gaijiulai ochiradene bijienyi xinlazhi echi hhelare hhantu doludu souwo. Bijien ingiezhi Lomade kuzhewo. ");
INSERT INTO sce_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Hhendedu gaijiula bijienyi xioxini sonosudene Lomase Yabiwu geidoude, pse Ghuran Lishe giesan ime gholo oronde bijienyi jienliele irewo. Baolo hhelai chanladene Hudade mafan kieliezhi danzi fugiedawo. ");
INSERT INTO sce_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Bijien Lomade kuruse Baoloi uzhesan nie buduighala danxin soukui tunyi oluwo. ");
INSERT INTO sce_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Ghurudu daodene BaoloYutai kunni lindaolai uruzhi irewo. Hhela irese Baolo kieliewo, \"Gaijiula, bi goya kunlane, xienrenlai guijinni fandui gieku shiqin uye giezhoma, mii Yelusalende bareizhi Loma kunde jiuizhi ogiwo. ");
INSERT INTO sce_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Hhela mii shenwun giezhi yama fuguku zui ereizhi olu dadene mii andaghane giese ");
INSERT INTO sce_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Yutai kunla fandui giezhi made banfa widadene Kaisa honshande zhawo. Bi goya kunlane zhane ese giezho. ");
INSERT INTO sce_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ingiese bi tai xinlazhi ire danmien kielieye giezho. Bi Isilie kunla panjisan hhe kunyi yenyin jiere ene qieshenyi zhozho.\" ");
INSERT INTO sce_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ingiese hhela kieliewo, \"Bijien Yudayase chii kieliesan xinni jienliezhi ese daozho. Gaijiula dundaye kiema chii zhazhi yama huaini kieliezhi ese daozho. ");
INSERT INTO sce_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ingieliuzhe bijien chii ijien matugiezho giezhi chenlieku duran wine. Ene jiomunni kunla gochude fandui giekui bijien mejiene.\" ");
INSERT INTO sce_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ingiese hhela udu jinjidene olon kunla Baolo sousan oronde irewo. Baolo eqiemaghase khara olutula hhelade Hudai gojiai daolii jianjizhi ganzhen beizho. Musani shu, xienzhilai shughala Ersani shiqinyi kieliezhi shundaghawo. ");
INSERT INTO sce_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Baolo kieliesan kielienyi chenliedene niezhanla xianxin giewo, niezhanla xianxin ese giewo. ");
INSERT INTO sce_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Hhelai ijien kiemai ijien buxianshi sandane giekude Baolo nie aman kielien kieliewo, \"Shenlin Isaiya xienzhii tungo giezhi tai xienrenlade kieliesan kielien ese codazho, ");
INSERT INTO sce_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","'Chi echidene ene bexinlade kielie, 'Ta izhi chenliezhoma, dunjire dane. Ta izhi uzhezhoma, minbai olu dane. ");
INSERT INTO sce_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ene bexinlai zhughe khiduzhezhi chighin beidazhi nudunne hameizho. Pse nudunni chanlazhi chighinni sonosuzhi zhughedeni minbai oludene kharei daorese Bi hhelai goudaghakuse ayizho. ");
INSERT INTO sce_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Ingiese ta mejiendu. Huda ene jiuiku daolini niman kunlade chonjizhi ogiwo. Hhelaye chenliene.\" ");
INSERT INTO sce_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Baolo goya bouisan giedene ghua hon souzhi hhei ochirale iresan kunlai man jienliewo. ");
INSERT INTO sce_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Hhe zui fugie danzighala Hudai gojiai daolii jianjizhi Ezhan Ersa Mexihani shiqinyi kunlade sughase danlachen kun uwo.");
INSERT INTO sce_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Bishi Ersa Mexihani hoji Baolo wo. Hudai gouxioxini zhomen chonjighane giezhi mii uruzhi iredene shitu danlaghawo. ");
INSERT INTO sce_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Ene gouxioxishi eqighanse Huda xienzhilai tungo giezhi zhiguitu jinwun jiere dain giesan wo. ");
INSERT INTO sce_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","4","Gouxioxishi Hudai kewon, mai Ezhan Ersa Mexihai kieliezho. Hhei kunni fanmiende kieliese Dawudeni houdei wo. Zhiguitu ruhherni fanmiende kieliese fugie nenlighala fugusan kun dundase aminne oluzhi Hudai kewon bikui mejieghawo. ");
INSERT INTO sce_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Huda Mexihai tungo giezhi bijiende shitu danlaku nenjien ogidene soyuji minzulade hhei nierei xianxin gieghazhi shunjighazho. ");
INSERT INTO sce_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ene dunda taye wine. Huda tai uruzhi iredene Ersa Mexihanughun danlaghawo. ");
INSERT INTO sce_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Huda orezhi uruzhi iredene shentu danlaghasan Loma kunlade bi xin huaizho. Mai ada Huda, Ezhan Ersa Mexiha tande nenjien, pinnan ogi gie! ");
INSERT INTO sce_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Bi xien ta dajialade oluzhi Ersa Mexihai tungo giezhi bi zunjisan Hudade mafan kieliekushi ta xianxin giesei qienxiani kunla man mejiezho. ");
INSERT INTO sce_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Bi onxian giekude ese beidene tai jilazho. Bi hhei kewonni gouxioxi jiere zhughesene shunjisan Huda enende ganzhen beine. ");
INSERT INTO sce_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Bi chan xiahua giese Hudai isi enbese bi zuihoude tai hhende echine. ");
INSERT INTO sce_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Bi tai hende chujiegheku duranshi Hudai nenjienni tande deilazhi tai khiduzheghane giezho. ");
INSERT INTO sce_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Isishi matan nieniene xianxin giekughala nieniedene zhichi gieye giezho. ");
INSERT INTO sce_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Gaijiula, psedu minzula dundashiku mutun tai dundase jiego khizheghane giezhi bi tai hhende haojihui echine giesan jihuai tande mejieghaku duran wine. Daliuzhe jiohoro giezhi echi dazho. ");
INSERT INTO sce_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Bugon Xila kun, wigokun, unhuatu kun, unhua witu kunlade bi yama chaisan mutun giezho. ");
INSERT INTO sce_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Ingiese bi ta Lomade sousanladeye gouxioxini chonjine giezhi hende duralazho. ");
INSERT INTO sce_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Bi gouxioxise ulie shizhene. Gouxioxishi soyuji xianxin giesan kunlai jiuiku Hudai nenli wo, xien Yutai kun, pse Xila kun. ");
INSERT INTO sce_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Gouxioxi jiere Hudai gundanni khizhezho. Ene gundanni kaishi giezhi baratula xianxin giekughala giene. Jinwun jiere kieliesan mutun, \"Gou kun xianxin giekughala amiturane.\" ");
INSERT INTO sce_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Hudai hokuku doghunnighala zhendaoi duisan kunlai soyuji xienlian witu, gou wituni kunlai jiere asiman jierese bouzhezho. ");
INSERT INTO sce_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Ingiekushi kunla Hudai shiqinni mejiekui man mejiene. Hhelade Huda qinchude uzheghawo. ");
INSERT INTO sce_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Duyai zhayaghasanse Hudai tejien, hhei chanqiku nenlini chanla danema, zhayaghasanlai uzhezhi qinchude mejiene. Ingiese kunlade yama kieliekui uwo. ");
INSERT INTO sce_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Hhela Hudai mejienema, Huda wo giezhi ulie kuaizhi mafan ulie kieliene. Hhelai sumulaku yama oronde wiku gholuwo, zhugheni benni gholuzhi kharanide wo. ");
INSERT INTO sce_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Hhela goyane jienzha wo giezhoma, ben wo. ");
INSERT INTO sce_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Hhela chanqiku Hudai famani fuguku kun, bunzhu, yewo, ghugheilai yanzi gholughawo. ");
INSERT INTO sce_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Ingiese Huda hhelai ese gonjidene hhela nefuxinne daghazhi zannannide echizhi nieniene beyede shizhekuni giezho. ");
INSERT INTO sce_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Hhela Hudai zhendaoi jianighala daiqi giedene zhayaghachenni ese beiidene zhayaghasanlai shunjizhi beiine. Hudashi indan chanqi kuaikuni wo. Amine. ");
INSERT INTO sce_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Ingiese Huda hhelai ese gonjidene hhela shizheku nefuxin giezho. Hhelai biereila zhenchande giekui ulie giedene zhenchan wini giene. ");
INSERT INTO sce_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Ere kunlaye biereighalane zhenchande giekuni ulie giedene nienieni nefuxin bazilie dase ere kun ere kunghala shizhekuni giene. Ingiezhi hhelai codasande indan chenfa giekui goya jierene ireghazho. ");
INSERT INTO sce_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Hhela Hudai tanise guazi wo giese Huda hhelai ese gonjidene guazitu sumuladande fanqi giewo. Ingiese hhela ulie giekuni giezho. ");
INSERT INTO sce_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Hhelade yanyanji gou wini, doghunni, tanxin, mouxienni duruzho. Dubilieku, alaku, eghinduku, piendaku, tuguni duruzho. Xienhua kieliene, ");
INSERT INTO sce_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","beihoude kunni sugiene, Hudai henjine, kunni yamacha ulie teine, goyane fugiede uzhezhi kuaine, doghun shiqinyi khizheghane, ada anadene ulie shunjine. ");
INSERT INTO sce_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Yama ulie mejiene, kieliendene ulie kurune, oreku, ubali xiiku zhughe uwo. ");
INSERT INTO sce_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Hudai guijin mutunshi jien ene shiqinni giesan kun indan fugukuni hhela mejiene. Ingieliuzhe goyalane giene, da kunla giese gou wo giezho. ");
INSERT INTO sce_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Ingiese chi ene kunlai kieliechen kun, chi kienliuzhe yama jiekou erei dane. Chi kunlai kieliekude goyaneye niekielienji giese goyadene zui jinjizho. ");
INSERT INTO sce_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Huda intui giechen kunlai gundande panjikui matan mejiene. ");
INSERT INTO sce_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Chi ene kunlai kieliedene niekielienji giesan kun, chi sumulase Hudai panjikuse andane giezhou? ");
INSERT INTO sce_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Huda tebieji goude giezhi, ranjizhi, rennai giese chi meilade uzhenu? Huda chade goude giekushi chii geizhen gieghane giekuni ulie mejienu? ");
INSERT INTO sce_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Chii zhughe khidunde geizhen ulie giedene Huda gundande panjiku hhe udu kuzhetula goyadene Hudai hokukui izhi olodoghazho. ");
INSERT INTO sce_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Huda kunla giekughala kunlade kharulune. ");
INSERT INTO sce_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Gou wilieni izhi giezhi kuaiku, gou minshen, chanqi ulie qida olukuni giesan kunlade Huda chanqiku aminni ogine. ");
INSERT INTO sce_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Zi goyane guizhi zhendaoni ulie shunjidene gou winii shunjichen kunlade hokuku, faikughala kharulune. ");
INSERT INTO sce_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Jien doghunnii giesan kunlade zeinan, tunkuni ogine. Xien Yutai kun, pse Xila kun. ");
INSERT INTO sce_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Jien gounii giesan kunlade kuaiku, gou minshen, pinnanni ogine. Xien Yutai kun, pse Xila kun. ");
INSERT INTO sce_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Huda kunlai pienxin ulie giene. ");
INSERT INTO sce_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Jien guijinni chenliezhi uye daodene zui fanjisan kunla guijinghala gonxi widene widane. Jien guijinni chenliedene zui fanjisan kunlai guijinghala panjine. ");
INSERT INTO sce_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Guijinni chenliese Hudai melie gounide ulie sanane, guijinni zunjise gounide sanane. ");
INSERT INTO sce_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Guijin ese ogisan niman kunla olusanse goyane guijin mutun giese, hhelade guijin uwoma, ene hhelai guijin gholuwo. ");
INSERT INTO sce_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Giesanlaini uzhese guijinni yoqiu hhelai zhughede teisei mejiene. Lianxinniye enende ganzhen beine. Hhelai zhughede maodun giezhi goyane kheilane, baohu giene. ");
INSERT INTO sce_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Eneshi, bi chonjisan gouxioxi mutun, Huda Mexiha Ersai tungo giezhi kunla niuighasan shiqin man panjiku hhe udude fashen giene. ");
INSERT INTO sce_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Chi ene goyane Yutai kun wo giesan, guijinni kouizhi Hudai mejiene giezhi goyane kuaizho. ");
INSERT INTO sce_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Chi Hudai isii mejiene, guijinse suruzhi gounii fenji shidane, ");
INSERT INTO sce_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","goyane sughoni udurusan wo, kharani dundadu gon wo giezho. ");
INSERT INTO sce_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Chi guijinghala erlin, zhendaoi zhanwo giezhi ben kun, kesilade sughachen loushi danlane giezhi goyane xianxin giezho. ");
INSERT INTO sce_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Qinse chi kunlade sughase goyadene yan giezhi ese sughazho? Kunlade bu ghula giezhi sughadene goyane ghulanu? ");
INSERT INTO sce_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Chi kunlade piofen bu gie giezhi kieliedene goyane piofen gienu? Chi nigiedalai uzhe dadene, goyane mioni dunxii ghulanu? ");
INSERT INTO sce_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Chi guijinni kuaidene guijinni fanjizhi Hudai shizheghanu? ");
INSERT INTO sce_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Jinwun jiere kieliesan mutun, \"Tai yenyinghala niman kunlai dunda Hudai nierei sugiezho.\" ");
INSERT INTO sce_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Chi guijinni zunjise giesan hetoune haochu wine. Hetoune giedene guijinni fanjise hetoune ese giesanghala niekielien wo. ");
INSERT INTO sce_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ingiese hetoune ese giesanla guijinni zunjise hetoune ese giezhoma hetoude ulie sananu? ");
INSERT INTO sce_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Hetoune ese giedene guijinni zunjisan kunla hetoune giezhi huaisan guijinni bidene guijinni fanjisan kunni zui jinjine. ");
INSERT INTO sce_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Biomien jiere Yutai kunshi Yutai kun pusho. Beye, mienzide giesan hetouneshi zhen hetoune pusho. ");
INSERT INTO sce_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Zinie sudoro Yutai kun danlasan kunshi Yutai kun wo. Zhen hetouneshi zhughenughun wo. Huaisande ulie kouine. Shenlinde kouine. Ene kunyi kuaikushi kunse iresan pusho, Hudase wo. ");
INSERT INTO sce_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Ingiese Yutai kun danlase yan haochu wo? Hetoune giese yande gou wo? ");
INSERT INTO sce_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Go fanmiende wine. Xien Hudai kielienyi hhelade ogiwo. ");
INSERT INTO sce_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Niezhanla xianxin ulie giese matugiene? Hhela kekao wise Hudaye kekao uwonu? ");
INSERT INTO sce_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Kenjin pusho! Kunla man ghudan kieliese Huda ghudan ulie kieliene. Jinwun jiere jilasan mutun, \"Chi kielien kieliekude gundan wo giene. Shenwun giekude chi injine.\" ");
INSERT INTO sce_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Matanyi gou wiku Hudai gounii khizheghase matan matui kieliene? Huda matanyi faise gundan uwonu? Bi kunni jiodughala kieliezho. ");
INSERT INTO sce_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Kenjin pusho! Qinse Huda matugie duyani panjine? ");
INSERT INTO sce_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Bi ghudan kieliedene Hudai zhennii qinchushighazhi hhei kuaise mii yangiezhi zuiren mutun panjine? ");
INSERT INTO sce_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Qinse matan huaini gieyema, gouni irene giezhi yale ulie kieliene? Niezhanla bijien ingiezhi kieliezho giezhi zhazho. Ene kunlai indan panjikuni wo. ");
INSERT INTO sce_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Ingiese bijien Yutai kun niman kunlase hen onu? Kenjin pusho! Kunla man zui dunda wo, Yutai kun niman kun man niekielien wo giezhi bijien kieliezhi daozho. ");
INSERT INTO sce_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Jinwun jiere jilasan mutun, \"Gou kun uwo, nieliuzhe uwo. ");
INSERT INTO sce_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Minbai oluchen kun uwo, Hudai ereichen kun uwo. ");
INSERT INTO sce_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Kunla man xiemachalazhi yama oronde uwo. Gounii giechen kun uwo, nieliuzhe uwo.\" ");
INSERT INTO sce_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","\"Hhelai gholei keisan meza niekielien wo. Hhelai kielienshi kun piendakui wo.\" \"Hhelai aman furedeni mogheii du wine.\" ");
INSERT INTO sce_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","\"Hhelai amande okho sugiekui duruzho.\" ");
INSERT INTO sce_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","\"Kun alane giese ghujin no wo. ");
INSERT INTO sce_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Kurusan orondeni pohai nangoi jiezho. ");
INSERT INTO sce_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Pinnanni moni ulie mejiene.\" ");
INSERT INTO sce_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","\"Hudase goujida ulie ayine.\" ");
INSERT INTO sce_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Guijinshi guijintu kunlade kieliesei matan mejiene. Ingiedene soyuji kunlai amanni menjighazhi qienxiani kunlai man Hudai panjikude ireghane. ");
INSERT INTO sce_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Guijinni zunjizhi giedene Hudai melie gounide sanasan kun nieda uwo. Guijinni tungo giezhi zuini mejiene. ");
INSERT INTO sce_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Ede guijinse chugo Hudai gundanni khizhezho. Enende guijinshu, xienzhishu jiere ganzhen beizho. ");
INSERT INTO sce_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Hheshijiu Ersa Mexihai xianxin giesan jien kunlade olusan Hudai gundanni wo. Yan kunliuzhe niekielien wo. ");
INSERT INTO sce_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Jien kunla zui fanjidene Hudai famade dai dazhoma, ");
INSERT INTO sce_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Ersa Mexihai shuikui tungo giezhi Hudai nenjienghala belien gouni wo giezho. ");
INSERT INTO sce_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Huda Ersai kunni oronde fugughazhi shuiku gholughawo. Hhei xianxin giesan kunlai zuini mienliene. Ingiezhi Huda gundanne uzheghawo. Eqighandei Huda kunla fanjisan zuini rennai giezhi ese gonjizho. ");
INSERT INTO sce_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Edeku shihoude ingiezhi Huda goyaneshi gundan bikui, pse Ersai xianxin giesan kunlai gounii uzheghazho. ");
INSERT INTO sce_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Ingiese matan yanni kuaine? Yama kuaikui uwo. Yan banfaghala wo? Gieku banfaghala onu? Pusho! Xianxin gieku banfaghala wo. ");
INSERT INTO sce_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Bijien uzhese kunni gounide sanakushi guijinni zunjizhi giekughala pusho, xianxin giekughala wo. ");
INSERT INTO sce_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Hudashi zinie Yutai kunlai Huda onu? Niman kunlai Huda pushonu? Enbene, hheshi niman kunlai Hudaye enbene. ");
INSERT INTO sce_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Hudashi nie wo. Hetoune giesanlai xianxin giekughala gounide sanane, hetoune uye giesanlaiye xianxin giekughala gounide sanane. ");
INSERT INTO sce_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Ingiese matan xianxin giekughala guijinni bendazhou? Kenjin uye! Khareidene guijinni khiduzheghazho. ");
INSERT INTO sce_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Ingiese bijienyi minzui xienren Iburaheimui matui kieliene? Hhe yan mejiewo? ");
INSERT INTO sce_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Iburaheimu giekughala gounide sanazhoshi kuai shidanema, Hudai melie kuaikui uwo. ");
INSERT INTO sce_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Jinwun jiere matui kieliezho? Iburaheimu Hudai xianxin giedene Huda hhei gounide sanazho giezho. ");
INSERT INTO sce_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Wilie giezhi gunzi bareise indanji wo, nenjiende ulie sanane. ");
INSERT INTO sce_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Kun yama wilie ulie giedene xienlian witu kunlai gouni wo giesan Hudai xianxin giese hhei xianxin giekuni gounide sanane. ");
INSERT INTO sce_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Wilie giekughala gonxi wi Huda gounide sanasan kunlade fuqi winekui Dawudeye kieliezho, ");
INSERT INTO sce_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","\"Codasanyi rouliezhi zuini khasan kunlade fuqi wine. ");
INSERT INTO sce_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Huda zui uwo giesan kunlade fuqi wine.\" ");
INSERT INTO sce_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Ingiese ene fuqii zinie hetoune giesan kunlade ogizhou? Hetoune ese giesan kunlade uye ogizhou? Iburaheimu xianxin giekughala gounide sanasanyi matan kieliezho. ");
INSERT INTO sce_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Hhei yan xienzide gounide sanazho? Hetoune gietula onu, hetoune giedene wo? Hetoune giedene pusho, gietula wo. ");
INSERT INTO sce_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Hhe giesan hetouneshi hetoune ese giekude xianxin giekughala gouni wo giesande zhanzi taisan hao wo. Ingiedene hhezighan hetoune ese gie xianxin giekughala gounide sanasan kunlade xienren danlawo. ");
INSERT INTO sce_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Iburaheimushi hetoune giesan kunlai xienrenye enbene. Zinie hetoune gieku pusho. Mai xienren Iburaheimu hetoune ese giekude xianxin giesan yanziini daghasan kunlai xienren wo. ");
INSERT INTO sce_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Huda Iburaheimuji houdeiladeni duyani ogine giezhi dain giesanshi guijinghala pusho, xianxin giedene iresan gounighala wo. ");
INSERT INTO sce_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Zinie guijintu kunlade ogizhoshi xianxin giesan yama oronde uwo, dain giesanyiye ulie sanane. ");
INSERT INTO sce_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Guijin Hudai hokukuni ireghazho. Guijin wise guijinyi fanjiku shiqinye uwo. ");
INSERT INTO sce_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Ingiese dain giesanshi xianxin giekughala ogizho. Hheshi Iburaheimuni houdeilade belien ogisan nenjien wo. Zinie guijintu kunlade ogisan pusho, Iburaheimu mutun xianxin giesan kunladeye bouisan wo. Hudai melie Iburaheimushi matan dajialai xienren wo. ");
INSERT INTO sce_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Jinwun jiere jilasan mutun, \"Bi chii olon minzulai xienren gholughane.\" Fugusan kunni aminne olughachen, uwokuse wineku gholughachen Hudai Iburaheimu xianxin giewo. ");
INSERT INTO sce_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Hhe xiwon wikude xiwon giezhi olon minzulai xienren danlakui xianxin giewo. Huda hhende kieliesan mutun, \"Chii houdeila ingiezhi olodone.\" ");
INSERT INTO sce_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Hhe 100 oluzhi beyeni fuguku mutun, biereini olu dakui mejieliuzhe xianxin giekuni ese zholierezho. ");
INSERT INTO sce_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Huda dain giesanyi xianxin giezhi uye inxin giedene kharei xianxin giekuni khiduzhezhi Hudai kuaizho. ");
INSERT INTO sce_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Huda dain giesei chenjighakui hhe hende xianxin giezho. ");
INSERT INTO sce_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Ingiese hhei gounide sanazho. ");
INSERT INTO sce_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Gounide sanazho giesan ene kielienyi zinie hhende ese huaizho, ");
INSERT INTO sce_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","matandeye huaizho. Mai Ezhan Ersai fugusan kun dundase aminne olughasan Hudai xianxin giesan maiye gounide sanane. ");
INSERT INTO sce_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Ersai kunlade jiuizhi mai zuide oluzhi duya ijiewo, matanyi gounide sanane giezhi aminne oluwo. ");
INSERT INTO sce_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Ingiese matan xianxin giekughala gounide sanase matan mai Ezhan Ersa Mexihai tungo giezhi Hudare goudazho. ");
INSERT INTO sce_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Matan Ersai tungo giezhi xianxin giekughala ede xianshou giesan nenjiende irezho. Da bayasuzhi Hudai famani panjizho. ");
INSERT INTO sce_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Zinie ene pusho. Chijia dundaye bayasune. Chijiase rennai surune, ");
INSERT INTO sce_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","rennaise undan surune, undanse xiwon surukuni matan mejiene. ");
INSERT INTO sce_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Xiwon matai ulie kushidaghakushi Huda matande ogisan Shenlinni tungo giezhi orekune matai zhughede kie durughawo. ");
INSERT INTO sce_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Matande banfa widakude shihou kuruse Mexiha matan xienlian witu kunlade oluzhi duya ijiewo. ");
INSERT INTO sce_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Gundan kunde oluzhi fuguchen kun choghon wo, gou kunde oluzhi fuguchen kun kenen winema, ");
INSERT INTO sce_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","matan dou zuiren bikude Mexiha matande oluzhi fugudene Huda matande oresanne qinchude uzheghazho. ");
INSERT INTO sce_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Ede Mexihai chusunyi tungo giezhi matai gounide sanawo, hhe Hudai hokusanse matai genjia jiuine. ");
INSERT INTO sce_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Matan Hudai duitou bikude hhe kewonne fugughazhi matanre goudazho, Mexihai aminghala matai genjia jiuine. ");
INSERT INTO sce_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Zinie ene pusho. Matan Ezhan Ersa Mexihai tungo giezhi Hudare goudadene Hudai yenyin jiere bayasuzho. ");
INSERT INTO sce_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Ingiese zui nie kunse duyade irezhi fuguku zuise iresan mutun kunla man zui fanjidene fuguku kunlai jiere irezho. ");
INSERT INTO sce_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Guijin witula zui duyade winema, guijin uwoshi zuide ulie sanane. ");
INSERT INTO sce_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Ingieliuzhe Adanse Musade kurutula fuguku qienli bareizho. Lien Adan fanjisan zuini ese fanjisan kunlaye man fuguzho. Adanshi khuina ireku hhe kunyi yanzi wo. ");
INSERT INTO sce_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Ingiese nenjien zuighala buxian wo. Nie kun zui fanjise olon kunla fuguzhoma, Hudai nenjien, Ersa Mexiha niezheghanyi nenjienghala belien ogisan mure olon kunlade genjia olon ogizho. ");
INSERT INTO sce_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Huda ogisan mure nie kun fanjisan zuighala buxian wo. Panjikushi nie kun zui fanjisande zui jinjizho, nenjienshi olon kunla zui fanjisande gounide sanasan wo giezho. ");
INSERT INTO sce_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Nie kun zui fanjise fuguku nie kunni tungo giezhi qienli bareizho, nenjien olon jienliezhi belien gouni wo giesan hhezighan kunla Ersa Mexiha niezheghanyi tungo giezhi amin dunda qienli genjia bareine. ");
INSERT INTO sce_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Ingiese nie zui fanjidene soyuji kunlade zui jinjiku mutun, nie gounii giedene soyuji kunlai gounide sanazhi amin ogiwo. ");
INSERT INTO sce_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Nie kun ulie shunjidene olon kunlai zuiren gholughaku mutun, nie kun shunjidene olon kunlai gounide sananne. ");
INSERT INTO sce_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Guijin iredene zui olodozhoma, zui olodosan oronde nenjien genjia fugiedazho. ");
INSERT INTO sce_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Ingiedene zui qienli bareizhi fugukui ogisan mutun, nenjien qienli bareizhi kunlai gounide sanadene mai Ezhan Ersa Mexihani tungo giezhi chanqiku amin ogizho. ");
INSERT INTO sce_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Ingiese matan matui kieliene? Matan nenjienni olodoghane giezhi zui dunda izhi beinu? ");
INSERT INTO sce_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Kenjin ulie olune! Matan zui miende fugudene matugie zui dunda udu daone? ");
INSERT INTO sce_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Matan xilii jienliezhi Mexiha Ersare hhantulasan kun hhere hhantu fugusei ta ulie mejienu? ");
INSERT INTO sce_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Matan xilii tungo giezhi hhere hhantu fuguzhi hhantu bulawo. Ingiekushi Adai famaghala Mexihai fugusan kun dundase aminne olughasan mutun mataiye shini amin dunda udu daoghane giezho. ");
INSERT INTO sce_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Matan hhe fugukude hhere hhantulase hhe aminne olukudeye hhere hhantulane. ");
INSERT INTO sce_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Matan khuichen kunne hhere hhantu shizijia jiere ghadazhi zuitu beyene widaghasei mejiene. Ingiese matan pse zuide hoji ulie danlane. ");
INSERT INTO sce_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Fugusan kun zuise andazho. ");
INSERT INTO sce_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Matan Mexihare hhantu fuguse hhereye hhantu amiturakui xianxin giene. ");
INSERT INTO sce_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Mexiha fugusan kun dundase aminne oluzhi pse ulie fugune. Fuguku hhei kunzhi gie dakui matan mejiene. ");
INSERT INTO sce_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Hhe fuguse zui miende 1 huide fuguwo. Amiturase Hudai miende amiturazho. ");
INSERT INTO sce_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Taye zui miende goyane fugusan sanazhi Mexiha Ersai tungo giezhi Hudai miende amitu sana. ");
INSERT INTO sce_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Ingiese zuini tai fuguku beye jiere qienli bu bareighazhi zui gieku nefuxinyi bu dagha. ");
INSERT INTO sce_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Ta beye jieredu yama iyanzii zuide ogizhi gou winide jiaji bu danlagha. Khareidene fugusan kun dundase aminne olusan kun wo giezhi goyane Hudade ogi. Beye jieredulane man Hudade ogizhi gou jiaji danlagha. ");
INSERT INTO sce_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Zui tai gonji dakushi ta guijin doura uwo, nenjien doura wo. ");
INSERT INTO sce_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Qinse matugiene? Matan guijin doura uwo, nenjien dourashi zui fanjise olunu? Kenjin ulie olune! ");
INSERT INTO sce_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Ta goyane kiende ogizhi kienyi shunjise kiende hoji danlakui ta ulie mejienu? Zuini hoji danlase fugune, Hudai shunjichen hoji danlase gouni gholune. ");
INSERT INTO sce_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Hudade mafan kielieye, ta melieshida zuini hoji woma, ede tande chonjisan daolini ta zhughesene shunjiwo. ");
INSERT INTO sce_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Ingiedene zuise tai andaghazhi gounide hoji danlawo. ");
INSERT INTO sce_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Ta dunjire dakuse ayizhi bi ibanji kielienghala kielieye. Ta melieshida beyene ganjin winide, uhunnide ogizhi hoji danladene uhunni gholughasan mutun ede ta beyene gounide ogizhi hoji danladene zhiguitu gholugha. ");
INSERT INTO sce_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Ta zuide hoji danlakude gouni gieku biyo uwo. ");
INSERT INTO sce_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Ingiese ta ede sumulase shizheku shiqinyi hhe xienzide giedene tande yan haochu wo? Hhei jiegoshi fuguku wo. ");
INSERT INTO sce_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Ede tai zuise andaghazhi Hudai hoji danlaghawo. Tai haochushi zhigui wo. Jiegoshi chanqiku amin wo. ");
INSERT INTO sce_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Zuini daijiashi fugukuni wo. Hudai nenjienshi mai Ezhan Mexiha Ersai sudoro bisan chanqiku amin wo. ");
INSERT INTO sce_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Gaijiula, ta guijinni mejiechen kunlade bi kielieye. Guijinshi kun zinie amitu bikude oronde bisei ta ulie mejienu? ");
INSERT INTO sce_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Biereide zhanguiji bizhi amitushi guijinni yenyinghala zhanguijisene likai gie dane. Zhanguijini fuguse zhanguijine guijinse andawo. ");
INSERT INTO sce_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Ingiese zhanguijini bidene pse nie kunde khise biozi giezhi urune. Zhanguijini fuguse hhe guijinse andawo. Pse nie kunde khise biozi pusho. ");
INSERT INTO sce_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Mii gaijiula, taye niekielien wo. Ta Mexihani beyei tungo giezhi guijinse fuguwo. Ingiedene pse nienughun gholuzhi matan Hudade gou jiego ireghane. Hheshi fugusan kun dundase aminne olusan Mexiha wo. ");
INSERT INTO sce_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Matan beyenughun bikude zui gieku nefuxin guijinni tungo giezhi mai jiere wilie giedene fugukui ireghawo. ");
INSERT INTO sce_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Ede matanyi banlasan guijinse matan fuguzhi andawo. Ingiese matan Ezhanni shunjise uroughala giesan guijinni khuichen banfaghala ulie giene, Shenlinni shini banfaghala giene. ");
INSERT INTO sce_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Ingiese matan matui kieliene? Guijinshi zui onu? Kenjin pusho! Guijin uwoshi bi yanshi zui bikui ulie mejiene. Guijin jiere tanxin bu gie giezhi ese kieliezhoshi bi tanxinshi yan bikui ulie mejiene. ");
INSERT INTO sce_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Zui minlinghala jihui ereizhi mii zhughede yanyanji tanxin giekui khizheghazho. Guijin uwoshi zuishi fugusei wo. ");
INSERT INTO sce_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Eqighan guijin uwokude bi amitu wo. Minlin irese zui aminne oluwo, bi fuguwo. ");
INSERT INTO sce_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Hhe yenlai amin ireghaku minlin mii fugukui gholughawo. ");
INSERT INTO sce_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Zui minlinni jihuighala mii piendadene hhei tungo giezhi mii fugughawo. ");
INSERT INTO sce_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Ingiese guijinshi zhiguitu wo. Minlinshiye zhiguitu, gundan, gouni wo. ");
INSERT INTO sce_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Qinse gouni khareidene mii fugughanu? Kenjin pusho! Mii fugughasanshi zui wo. Zuishi zui bikui mejieghane giezhi gounii tungo giezhi mii fugughawo. Minlinyi tungo giezhi zui zhenzhen doghunne khizheghazho. ");
INSERT INTO sce_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Guijinshi ruhhernughun bikui matan mejienema, bishi beyenughun wo. Mii zuide huizhi hoji danlaghawo. ");
INSERT INTO sce_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Bi giene giekune ulie giene, henjisanne kharei giene. Bi yan giesanne ulie mejiene. ");
INSERT INTO sce_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Bi henjisanne giese guijinshi gouni bikui bi chenren giezho. ");
INSERT INTO sce_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Ingiese giesanshi bi pusho, mii sudoro sousan zui giezho. ");
INSERT INTO sce_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Mii sudoro, mii beye jiere gouni uwokui bi mejiene. Bi gounii gieku duran winema, gie dane. ");
INSERT INTO sce_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Bi gounii gieku duran winema, ulie giene. Doghunnii gieku duran uwoma, khareidene giene. ");
INSERT INTO sce_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Bi duran wikune giese giesanshi bi pusho. Mii sudoro sousan zui giezho. ");
INSERT INTO sce_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Bi nie guijin mejiewo. Bi gounii giene giekude doghunniye hhantu wo. ");
INSERT INTO sce_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Bi sudorone kun Hudai guijinde xiqi woma, ");
INSERT INTO sce_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","beye jieremi pse nie guijin mii zhugheni guijinghala maodun giezhi mii bareidene beye jiere bisan zuini guijinde hoji danlaghasei bi chanlazho. ");
INSERT INTO sce_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Mii amin muchughun wo, kien mii ene fuguku beyese jiuizhi khizheghane? ");
INSERT INTO sce_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Mai Ezhan Ersa Mexihai tungo giezhi Hudade mafan kielieye! Ingiese mii sumulaku Hudai guijinni shunjizho, mii beye zuini guijinni shunjizho. ");
INSERT INTO sce_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Ingiese ede Mexiha Ersai miendedu kunlade zui jiedui ulie jinjine. ");
INSERT INTO sce_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Amin ogiku Shenlinni guijin Mexiha Ersai tungo giezhi zuiji fuguku guijinse chii andaghawo. ");
INSERT INTO sce_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Kunde lilian wiku yenyinghala guijin gie dakui Huda giewo. Huda zuini widaghane giezhi Kewonne zuitu beyeni yanzighala peizhi ireghadene zuini kunlai ese gonjighawo. ");
INSERT INTO sce_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Ingiedene beyeni ulie daghazhi Shenlinni daghasan mai jiere guijinyi yoqiui gholughawo. ");
INSERT INTO sce_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Beyeni daghasan kunla beyeni shiqinyi gonxin giene. Shenlinni daghasan kunla Shenlinni shiqinyi gonxin giene. ");
INSERT INTO sce_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Beyeni shiqinyi gonxin giese fugune. Shenlinni shiqinyi gonxin giese amin, pinnan irene. ");
INSERT INTO sce_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Kun beyeni shiqinyi gonxin giese Hudaghala duitou gholune. Hudai guijinni ulie shunjine, shunjiye dane. ");
INSERT INTO sce_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Beyenughunla Hudai bayasugha dane. ");
INSERT INTO sce_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Hudai Ruhher tai sudoro souse tashi beyenughun pusho, Shenlinnughun wo. Kunde Mexihani ruhher uwoshi Mexihanughun pusho. ");
INSERT INTO sce_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Mexiha tai sudoro bise beye zuini yenyinghala fuguzhoma, ruhher gounii yenyinghala amiturazho. ");
INSERT INTO sce_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Ersai fugusan kun dundase aminne olughasan Hudai Ruhher tai sudoro souse Mexihai fugusan kun dundase aminne olughasan Huda tai sudoro sousan Shenlinne tungo giezhi tai fuguku beyeni aminne olughane. ");
INSERT INTO sce_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Gaijiula, ingiese matan beyede zhan chaisan mutun hhei daghazhi gieku biyo uwo. ");
INSERT INTO sce_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Ta beyeni daghazhi giese fugune. Shenlinde kouizhi beyeni doghun wiliei fugughase amiturane. ");
INSERT INTO sce_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Jien Hudai Ruhher udurusanlashi Hudai kewosi wo. ");
INSERT INTO sce_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Ta jienliesanshi hojini ruhher pusho. Pse ulie ayighane. Jienliesanshi kewosi danlaku ruhher wo. Ingiese matan Aba, ada giezhi urune. ");
INSERT INTO sce_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Shenlin qinsi matanyi ruhherre hhantu matanshi Hudai kewosi wo giezhi ganzhen beizho. ");
INSERT INTO sce_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Kewosi enbese jiachanyi jienliechen enbene. Matanshi Mexihare hhantu jiachanyi jienliechen Hudai kewosi wo. Matan hhere shouku giekude hhantulase famadeye hhantulane. ");
INSERT INTO sce_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Bi uzhese edeku shouku gieku jianlai matande ireku famaghala bilazhi ulie olune. ");
INSERT INTO sce_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Zhayaghasanla jirezhi Hudai kesila xienjizhi khizhekuni panjizho. ");
INSERT INTO sce_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Zhayaghasanla yama oronde widawo. Hhela imutui gholukushi goya duranghalane pusho, Huda ingiezhi gieghawo. ");
INSERT INTO sce_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Hhela qida olusande hoji danlakuse andadene Hudai kesilani famatu ziyuni jienliekui panjizho. ");
INSERT INTO sce_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Zhayaghasanla man hhantu shonholozhi tendun shouizhi eli kusanyi matan mejiene. ");
INSERT INTO sce_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Zinie zhayaghasanla pusho, Shenlinshi toushu alima wo giezhi jienliesan matanye zhughedene shonholozhi Hudai kewosi danlaku, pse mai beyei jiuizhi shuikui panjizho. ");
INSERT INTO sce_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Onxianghala matanyi jiuiwo. Chujieghekui onxian giese onxian pusho. Chujieghekui kien onxian giene? ");
INSERT INTO sce_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Matan chujieghe dakune onxian giese rennai giezhi panjikuni wo. ");
INSERT INTO sce_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Niekielien wo, Shenlinye matan zholierekude banman giene. Matan indan matugie onxian giekui ulie mejienema, Shenlin hende nango giezhi qinsi matande xiahua giene. ");
INSERT INTO sce_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Kunni zhughei uzhechen Huda Shenlinyi sumulakui mejiene. Shenlin zhao Hudai isighala shentulade oluzhi xiahua giezho. ");
INSERT INTO sce_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Hudade oresan kun, jiushi Huda jihuaghalane uruzhi iresan kunlade shiqinla man hhantulazhi gouni gholukui matan mejiene. ");
INSERT INTO sce_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Huda eqie mejiesan kunlai kewonne yanzi mutun gholughane giezhi pse eqie jinjiwo. Ingiezhi kewonne olon gaijiu dunda fugie kewon danlaghane giezho. ");
INSERT INTO sce_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Hhe eqighan jinjisan kunlai pse uruzhi irewo. Uruzhi iresan kunlai pse gounide sanawo. Gounide sanasan kunlai famani gholughawo. ");
INSERT INTO sce_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Ingiese matan enezighan shiqinde yan kieliene? Huda matande banman giese kien fandui giene? ");
INSERT INTO sce_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Huda Kewonne sheizhi matande ogiwoma, hhere hhantu pseshikulai man matande ulie oginu? ");
INSERT INTO sce_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Kien Huda sunghusan kunlai zha shidane? Hhelai gounide sanasanshi Huda wo. ");
INSERT INTO sce_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Kien hhelade zui jinjine? Mexiha Ersa duya ijiezhi aminne oludene ede Hudai borun miende bizhi matande oluzhi xiahua giezho. ");
INSERT INTO sce_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Kien Mexiha matande orekui siraghane? Kunnan onu? Khishun onu? Heiku onu? Oliesuku onu? Nanxin onu? Wixien onu? Khudogho onu? ");
INSERT INTO sce_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Jinwun jiere jilasan mutun, \"Chii yenyinghala bijienyi chanqi alazho. Kunla bijienyi alaku ghoni mutun uzhezho.\" ");
INSERT INTO sce_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Ingieliuzhe matande oresan Ezhanni tungo giezhi ene soyuji shiqin jiere suibiende injine. ");
INSERT INTO sce_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Bi hende xianxin giese bugon fuguku, amituku, qienxien, qienli bareichen, edeku shiqin, jianlaiku shiqin, lilian, ");
INSERT INTO sce_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","unduni, gunni, psedu zhayaghasanla man Huda mai ezhan Ersa Mexihai tungo giezhi matande orekui siragha dane. ");
INSERT INTO sce_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Bi Mexihani miende shuhuai kieliene, ghudan ulie kieliene. Mii lianxin Shenlinyi tungo giezhi made ganzhen beizho. ");
INSERT INTO sce_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Bi hende munan giezhi zhughedemi izhi otuzho. ");
INSERT INTO sce_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Bi gaijiuladene oluzhi mii kharazhi Mexihare danlinraghaseye duran wine. Hhelashi mare nie minzu wo, ");
INSERT INTO sce_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","yeshi Isilie kun wo. Kewonni nexian, fama, yenjisan kielien, guijin, libai gieku banfa, dain giesei man hhelade ogizho. ");
INSERT INTO sce_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Hhe famatu xienrenlashi hhelanughun wo. Mexihaye kunni fanmiende kieliese hhelase khizhezho. Mexihashi manlai gonjisan Huda wo, chanqi doulakui wo. Amine! ");
INSERT INTO sce_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Ingieseye bi Hudai kielienshi belienni wo giezhi ese kieliezho. Isiliese olusanlashi man Isilie kun pusho. ");
INSERT INTO sce_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Iburaheimuni houdeilashi man hhei kewosi pusho. Zinie Isagheise olusei chii houdei giezhi urune giezho. ");
INSERT INTO sce_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Isishi beyese olusan kesilashi man Hudai kewosi pusho. Zinie dain giesan mutun olusan kesilai houdeide sanane. ");
INSERT INTO sce_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Eneshi Huda dain giesan kielien wo, \"Gonien eli kuse bi irene. Sare nie kewon olune.\" ");
INSERT INTO sce_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Zinie ene pusho. Mai xienren Isagheise Libaijia shongo laikudeye qingiezho. ");
INSERT INTO sce_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","Shongoni ese oluzhi gounii, doghunnii ese khizhekude Huda Libaijiade, \"Jianlai fugieni ganinughunyi chenliene.\" giezhi kieliewo. Ingiezhi Huda kunni sunghuse goya mujighalane giezho. Kun giekughala ese giezho, kunni uruzhi iresan Huda jiejin giezho. ");
INSERT INTO sce_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Jinwun jiere Huda kieliesan mutun, \"Yagebude bi orezho, Isaode ese orezho.\" ");
INSERT INTO sce_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Ingiese matan matui kieliene? Huda gundan uwonu? Kenjin pusho. ");
INSERT INTO sce_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Huda Musade kieliewo, \"Bi kiende ubali xiise kiende ubali xiine. Kiende nenjien ogise kiende nenjien ogine.\" ");
INSERT INTO sce_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Ingie uzhese eneshi kunni duran, xiacha giekui kouisan pusho. Ubali xiisan Hudade kouizho. ");
INSERT INTO sce_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Jinwun jiere Huda Falaode kieliezho, \"Bi chii tungo giezhi nenline xienjighazhi qienxiade nierene chonji kurughane giezhi chii undudaghawo.\" ");
INSERT INTO sce_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Ingie uzhese Huda kiende ubali xiise kiende ubali xiine. Kienyi khiduzheghase kienyi khiduzheghane. ");
INSERT INTO sce_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Ingiese chi made kieliene, \"Qinse Huda kunlade yangiezhi gui teine? Kien hhei isii fandui giene?\" ");
INSERT INTO sce_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Chishi kien wo? Zinie kun wo. Hudaghala jianjindunu? Gholusan dunxi matugie hhei gholughasande, \"Chi mii yangiezhi intui giewo?\" giezhi kieliene? ");
INSERT INTO sce_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Ighachi shuwa dundase niegieda shuwai agidene niei guizhuntu, niei bixintu ighai gieku qienli uwonu? ");
INSERT INTO sce_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Hudaye niekielien wo. Hhe hokukune, nenline mejieghaku duran woma, hokuzhi widaghane giesan kunlade hende rennai giewo. ");
INSERT INTO sce_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Ingiedene Huda ubali xiisan kunlade hhei fama olon bikui mejieghazho. Enelashi famai ogine giezhi melie zhunbei giesan kunla wo, ");
INSERT INTO sce_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","yeshijiu Huda uruzhi iresan matan wo. Gon Yutai kun pusho, niman kunlaye enbene. ");
INSERT INTO sce_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Zhen Huda Hexiyani Shu jiere kieliesan mutun, \"Mii bexin pushotu kunlai bi mii bexin giezhi urune. Uye oresanlade bi oresan giezhi urune.\" ");
INSERT INTO sce_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Pse kieliezho, \"Ta mii bexin pusho giesan yen hhe oronde hhelai chanqiku Hudai kesila giezhi urune.\" ");
INSERT INTO sce_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Isilie kunlai kieliese Isaiya fugiede kieliezho, \"Isilie kunla olonde haibienni shazi niekielien woma, zinie feiliesanlai jiuine. ");
INSERT INTO sce_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Ezhan zemin jiere panjikune ghujighande man gie baraghane.\" ");
INSERT INTO sce_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Isaiya melieshi kieliezhi daosan mutun, \"Qienwon buduini Ezhan matande houdei ese feilieghazhoshi matan zaojiu Sodoma, Emola gholuwo.\" ");
INSERT INTO sce_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Ingiese matan matui kieliene? Hudare goudakui onxian ese giesan niman kunla xianxin giekughala Hudare goudawo. ");
INSERT INTO sce_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Guijinghala Hudare goudane giesan Isilie kunla khareidene guijinni mujide dai dazho. ");
INSERT INTO sce_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Eneshi yan yenyin wo? Eneshi hhela giekudene kouizho, xianxin giekude ese kouizho. Hhela banjighaku tashi jiere banjiwo. ");
INSERT INTO sce_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Jinwun jiere jilasan mutun, \"Bi Xiwunde nie banjighaku tashi teiwo. Kunni banjighaku tashi wo. Hhei xianxin giesan kunla jiuren ulie giene.\" ");
INSERT INTO sce_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Gaijiula, bi zhughedene panjizhi Hudase onxian giesanshi Isilie kunlai jiuise giezho. ");
INSERT INTO sce_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Hhela Hudade rexin bikui bi ganzhen beizhoma, zhao unhuaghala ese giezho. ");
INSERT INTO sce_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Hudai gundanni ulie mejiene. Goya gundanine gholughane giezhi Hudai gundanni ulie shunjine. ");
INSERT INTO sce_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Mexihashi guijinni uzhu wo. Jien xianxin giesan kunlai gounide sanane. ");
INSERT INTO sce_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Guijinghala gounide sanakui ene shiqinyi giesan kunla amiturane giezhi Musa huaizhoma, ");
INSERT INTO sce_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","xianxin giekughala gounide sanaku daolii ingiezhi kieliezho, \"Kien asiman jiere khireine giezhi chi zhughedene bu kielie.\" (Jiushi Mexihani jierese lai bouzheghane giezho.) ");
INSERT INTO sce_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Pse \"Kien dozoheide boune giezhi chi zhughedene bu kielie.\" (Jiushi Mexihani fugusan kun dundase lai khizheghane giezho.) ");
INSERT INTO sce_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Hhe kieliesanshi ene wo, \"Hudai kielien chase gholo uwo. Chii amande, zhughede wo.\" Jiushi bijien chonjisan xianxin gieku daoli wo. ");
INSERT INTO sce_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Chi amandene Ersashi Ezhan wo giezhi chenren giezhi zhughedene Huda hhei fugusan kun dundase aminne olughasei xianxin giese jiuine. ");
INSERT INTO sce_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Kun zhughedene xianxin giese gounide sanane, amandene chenren giese jiuine. ");
INSERT INTO sce_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Jinwun jiere kieliezho, \"Jien hhei xianxin giesan kunla jiuren ulie giene.\" ");
INSERT INTO sce_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Yutai kun, Xila kun yama chabie uwo. Soyuji kunlade niekozi Ezhan wo, hhei xiahua giesan soyuji kunlade dafande ogine. ");
INSERT INTO sce_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","\"Jien Ezhanni nierei xiahua giesan kunlai jiuine.\" ");
INSERT INTO sce_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Qinse kun hhei xianxin ulie giese matugie xiahua giene? Hhei chenliezhi ese daodene matugie xianxin giene? Kieme ulie chonjise matugie chenliene? ");
INSERT INTO sce_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Kiemei ese peise matugie chonjine? Jinwun jiere jilasan mutun, \"Gouxioxii chonjisan kunlai koronlon zhengiejia seighan wo!\" ");
INSERT INTO sce_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Ingieliuzhe kunla man gouxioxini shunjisan pusho. Isaiya kieliezho, \"Ezhan, bijien chonjisanyi kien xianxin giewo?\" ");
INSERT INTO sce_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Ingiese xianxin giekushi chenliesanse irezho. Chenliesanshi Mexihani kieliense irezho. ");
INSERT INTO sce_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Bi nie asaye. Kunla ese chenliewu? Kenjin chenliezho. \"Hhelai shenqi qienxiade kuruwo. Hhelai kielien duyani uzhude kuruwo.\" ");
INSERT INTO sce_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Bi pse asaye. Isilie kun yama ulie mejienu? Mejiene! Xien Musa Hudai kielienyi ingiezhi kieliezho, \"Bi minzude ulie sanaku minzuni tungo giezhi tai dubilieghane. Bi yama ulie mejiechen minzui tungo giezhi tai hokughane.\" ");
INSERT INTO sce_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Pse Isaiya danzine fugiedaghazhi Hudai kielienyi ingiezhi kieliezho, \"Mii ese ereisan kunlade bi chujiegheghane. Mii xiahua ese giesan kunlade bi xienjighane.\" ");
INSERT INTO sce_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Isilie kunlade hhe kharei ingiezhi kieliezho, \"Bi niudunie kielien ulie chenliezhi jianjinduku bexinlai jienliene giezhi khane rouizho.\" ");
INSERT INTO sce_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Ingiese bi asaye, Huda goya bexinne bendawu? Kenjin uye! Bishiye Isilie kun, Iburaheimuni houdei, Bienyamin jiawuse khizhesan wo. ");
INSERT INTO sce_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Huda melie mejiesan bexinlane ese bendazho. Jinwun jiere Iliyai matugie kieliesei ta ulie mejienu? Hhe Hudade Isilie kunlai zhazhi kieliezho, ");
INSERT INTO sce_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","\"Ezhan, hhela chii xienzhilai alazhi sidagha gieku chii teizii cheiwo. Jianie bi feiliezhi hhela dou mii aminyi kerene.\" ");
INSERT INTO sce_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Ingiese Huda matugie huida giewo? Bi goyadene oluzhi Balii ese beiisan 7000 kun feilieghawo giezho. ");
INSERT INTO sce_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Edeku shihouye niekielien wo. Feiliesan kun wine. Hhelai nenjienghala sunghuzho. ");
INSERT INTO sce_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Nenjienghala giese giekughala ese giezho. Qingiese nenjienshi nenjien pusho. ");
INSERT INTO sce_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Ingiese matugie gholuwo? Isilie kunla goya ereisanne ereizhi olu dawo. Zinie Huda sunghusan kunla ereizhi oluwo. Psedu kunlai zhughe khiduzhewo. ");
INSERT INTO sce_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Jinwun jiere jilasan mutun, \"Huda hhelade sudoku zhughe ogizho nudunlani chanla dane, chighinlaiye sonosu dazhi eli kuwo.\" ");
INSERT INTO sce_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Pse Dawude kieliewo, \"Hhelai ijieku xini sa, on, banjighaku, bouin gieku gholusejiu. ");
INSERT INTO sce_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Hhelai nudun borolozhi chujieghe dasejiu. Hhelai nurun ibeizi ghodeisejiu.\" ");
INSERT INTO sce_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Ingiese bi asaye, hhela banjise bosizhe danu? Kenjin pusho! Hhela codadene jiuiku niman kunlade echise Isilie kunlai dubilieghazho. ");
INSERT INTO sce_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Isilie kunlai codasan duyai kunlade haochu ireghazho, hhelai ese olusan niman kunlade gounii ireghazho. Qinse Isilie kunlai man jiuiku dunda oroghase ireku gounii genjia fugie uwonu? ");
INSERT INTO sce_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Bi ta niman kunlade kielieye. Bishi niman kunlade peisan shitu wo. Ene wiliei bi fugiede uzhekushi ");
INSERT INTO sce_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","goya minzune dubilieghazhi ezighan jiuine giezho. ");
INSERT INTO sce_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Huda hhelai bendadene duyai kunlare goudazho, hhelai jienliese zhengiejia gou uwonu? Fugusanse aminne olusan niekielien wo. ");
INSERT INTO sce_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Hudade ogiku ghurun ganjinshi nieduizi ghurun man ganjin wo. Mutun genzi ganjinshi chalaye ganjin wo. ");
INSERT INTO sce_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Bilase nie ganlan mutunyi giedun chalani ghigha bouzhedene yeganlan chalai chaiwo. Chishijiu chaisan chala wo. Chaisan chala mutun genzise gounii hhantu xiikude ");
INSERT INTO sce_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","ghighasan chalade kuai dane. Kuaine giese chi jila. Chi genzii ese qiezhezho, genzi chii qiezhezho. ");
INSERT INTO sce_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Ingiese chi kieliene, 'Hhezighan chalai ghigha bouzhekushi mii chaine giezho.' ");
INSERT INTO sce_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Oluzho! Hhela xianxin ulie giese ghigha bouzhezho, chi xianxin giese beizho. Ingiese ayizhi goyane undude bu uzhe. ");
INSERT INTO sce_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Huda yenlaiku chalai sheise chiiye sheine. ");
INSERT INTO sce_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Ingie uzhese Huda renyi, yenge wo. Hhezighan xinyan jiere banjisan kunlade yenge wo, tande renyi wo. Chi renyideni chanqi kouise beizhoma, pse chiiye ghigha widaghane. ");
INSERT INTO sce_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Isilie kunla ulie guidene xianxin giese yen chaine. Hudade erchan chaiku nenli wine. ");
INSERT INTO sce_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Chishi goya osisan ganlan mutun jierese ghighazhi bouzhedene zeilasan ganlan mutun jiere zhenchan wide chaisan wo. Qinse yenlaiku chalai yenlaiku mutun jiere chaise genjia zhenchan uwonu? ");
INSERT INTO sce_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Gaijiula, bi ene mimii tande mejieghaku duran wo. Pse ta goyalane jienzha wo giene. Ene mimishi niman kunlai jiuiku shuzi kurutula niezhan Isilie kunlai zhughei khiduzheghazho. ");
INSERT INTO sce_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Ingiedene Isilie kunlai man jiuine. Jinwun jiere jilasan mutun, \"Xiwunse jiuichen khizhezhi Yagebuse xienlian wituni widaghane. ");
INSERT INTO sce_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Hhe shihoude bi hhelai zuini widaghane. Eneshijiu bi hhelare yenjisan kielien wo.\" ");
INSERT INTO sce_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Gouxioxighala kieliese Isilie kunla Hudare duitou gholudene tande haochu ireghawo. Hhelai xienrenni sunghusei uzhese hhelashi Huda oresan wo. ");
INSERT INTO sce_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Hudai nenjien, uruku ulie bienjine. ");
INSERT INTO sce_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Ta eqighandei Hudai ulie shunjiku mutun ede hhelai ulie shunjiku yenyinghala tande kharei ubali xiizho. ");
INSERT INTO sce_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Niekielien wo. Hhela ede uye shunjizhoma, tande ubali xiisan yenyinghala ede hheladeye ubali xiine. ");
INSERT INTO sce_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Huda soyuji kunlai ulie shunjiku dunda oroghazhi khakushi soyuji kunlade ubali xiine giezho. ");
INSERT INTO sce_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Hudai bayan, agheli, erlin matui fugie wo! Hhe panjikui kiema mejie dane! Hhe giekui kiema dunjire dane! ");
INSERT INTO sce_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","\"Kien Ezhanyi zhughei mejiene? Kien hhende sughachen danlane?\" ");
INSERT INTO sce_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","\"Kien Hudade xien ogidene khareizhi goyadene honjighane?\" ");
INSERT INTO sce_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Soyujila man hhense khizhezhi hhende kouizhi hhende oluzho. Kuaikui chanqi hhende ogi! Amine! ");
INSERT INTO sce_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Ingiese gaijiula, bi Hudai ubali xiikughala tai goude fenfulaye. Ta beyene amitu mure danlaghazhi Hudade ogi. Intu mureshi Huda xiqi biku wo, zhiguitu wo. Eneshijiu zhenzhenji beiiku wo. ");
INSERT INTO sce_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Ene duyani bu dagha. Sumulakune arunzhazhi shinishighadene Hudai gou, bayasuku, onqien isii shiizhi mejie. ");
INSERT INTO sce_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Bi made ogisan nenjienghala ta jien kunlade kielieye, goyane texien undude bu uzhe. Goude sumulazhi Huda tande ghughazhi ogisan xianxin gieku fenlianghala goyane heshide uzhe. ");
INSERT INTO sce_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Matanyi nie beye jiere iyanzi olon biliuzhe zoin buxian mutun ");
INSERT INTO sce_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","matanye olon woma, Mexihai miende nie beye wo. Nienieji beyede lienjizhi buxiantu iyanzi gholuwo. ");
INSERT INTO sce_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Huda nenjienghalane matande buxiantu nenli ogizho. Hudai kielienyi kieliekushi xianxin gieku kamaghala kielie. ");
INSERT INTO sce_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Ushilakushi ushila, surughakushi surugha. ");
INSERT INTO sce_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Zhichi giezhi kieliechenla zhichi gie. Ogichenla dafande ogi. Gonjichenla xiacha giezhi gonji. Ubali xiichenla bayasuzhi gie. ");
INSERT INTO sce_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Orekude jianii bu deila. Doghunnii henji, gounii barei. ");
INSERT INTO sce_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Zhenzhenji orekughala nieniedene ore. Ranjizhi nieniene zunji. ");
INSERT INTO sce_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Langan bu giedene zhughesene rexinde Ezhanni shunji. ");
INSERT INTO sce_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Panjizhi bayasu, kunnan dunda rennai gie, izhi onxian gie. ");
INSERT INTO sce_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Nanxintu shentulade ogi. Bayasuzhi kunlai jienlie. ");
INSERT INTO sce_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Tai heisanlade oluzhi gouni kielie, bu kharadene gouni kielie. ");
INSERT INTO sce_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Bayasuchen kunlare hhantu bayasu, wilachen kunlare hhantu wila. ");
INSERT INTO sce_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Nieniedene heqitughan, goyane undude bu uzhezhi bixin kunlare laiwon gie. Goyane jienzha wo bu gie. ");
INSERT INTO sce_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Kiemade doghunnide doghunnii bouchou bu gie, dajiala gou wo giesan shiqinni jinlianji gie. ");
INSERT INTO sce_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Tande nengou bise jinlianji jien kunlare heqitu. ");
INSERT INTO sce_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Mii orentula, goyane bouchou bu giedene Ezhan hhelai faikui saghei. Jinwun jiere jilasan mutun, \"Ezhan kieliezho, 'Bouchoushi bi giekui wo, bi kharulune.'\" ");
INSERT INTO sce_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Khareidene chii duitou oliesuse ijiegha. Undasuse ochigha. Chi ingiezhi giese shitan khanni hhei qiorun jiere teizho. ");
INSERT INTO sce_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Goyasene doghunnii bu injigha, gounighala doghunnise inji. ");
INSERT INTO sce_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Jien kunla qienli bareisan noyenlai shunji. Qienlishi man Hudase irezho. Soyuji qienli bareichenlashi Huda jinjisan wo. ");
INSERT INTO sce_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Ingiese qienli bareichenlai fandui giese Huda jinjisanyi fandui giezho. Fandui giesanla goyadene faikui ereizho. ");
INSERT INTO sce_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Noyenlashi gouni giesanlai ayighachen pusho, doghunni giesanlai ayighachen wo. Chi qienli bareichenlase ulie ayine giezhou? Gouni giema, hhela chii kuaine. ");
INSERT INTO sce_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Hhelashi tai haochude olusan Hudai hoji wo. Chi doghunni giese indan ayikui wo. Hhela khudoghoi belien bareisan pusho. Hhelashi doghunni giesan kunlai faichen Hudai hoji wo. ");
INSERT INTO sce_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Ingiese ta bixi shunji, zinie Hudai hokuruku yenyinghala pusho, lianxinni yenyinghala wo. ");
INSERT INTO sce_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Ta shui ogikuyeshi ene yenyin wo. Hhelashi zhomen ene shiqinyi gonjisan Hudai hoji wo. ");
INSERT INTO sce_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Jien kunlade indan ogikui ogi. Shui ghurasande shui ogi, baer ghurasande baer ogi. Indan zunjichenlai zunji, danren giekulai danren gie. ");
INSERT INTO sce_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Nieniedene orekuse chugo kiemade zhan bu chai. Kunlade orechenla guijinni chenjighawo. ");
INSERT INTO sce_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Piofen bu gie, kun bu ala, bu ghula, tanxin bu gie giesan minlin, psedu guijinla man goyadene mutun giebeidene ore giesan ene minlinde bouizho. ");
INSERT INTO sce_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Orechen kun giebeidene doghunni ulie giene. Ingiese oreku guijinni chenjighawo. ");
INSERT INTO sce_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Ingiekushi edeshi yan shihou bikui ta mejiene. Ta hhunturazhi xiereiku shihou wo. Matanyi jiuiku matan dei xianxin gieku shihouse ede chadashizho. ");
INSERT INTO sce_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Xieni daozhi ogheine giezho. Ingiese matan kharanide giesan shiqinlai jiedene gieghantu baohu gieku majiani musiye. ");
INSERT INTO sce_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Matan udude gieku mutun yan gieliuzhe donzhende gieye. Lon naduzhi sudoku, lon kijiezhi hu gieku, jianjinduzhi dubilieku enelai bu gieye. ");
INSERT INTO sce_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Khareidene Ezhan Ersa Mexihai musi. Zui gieku durande jihui bu ogizhi nefuxinni bu dagha. ");
INSERT INTO sce_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Xianxin gieku zholientu kunlai ta jienlie. Ijien buxianshi bu jianjindu. ");
INSERT INTO sce_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Niezhan kunla yanniliuzhe ijiese olune giezhi xianxin giezho. Xianxin gieku zholientu kunla zinie cai ijiene. ");
INSERT INTO sce_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Migha ijiesan kunla migha ese ijiesan kunlai meilade bu uzhe, migha ese ijiesan kunla migha ijiesan kunlai bu kielie. Huda hhelai jienliewo. ");
INSERT INTO sce_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Kunlai hojii kieliezhi chishi kien wo? Hhela olu, ulie olu ezhanyini shiqin wo. Ezhande olughaku nengou wine. Ingiese hhe olu shidane. ");
INSERT INTO sce_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Niezhan kunla enenie udui psedu udulase zhunyo wo giezho. Niezhan kunla niuduniei uzhedan niekielien wo giezho. Alinie kunliuzhe zhughedene oluzhou ese olusei jiejin gie gie. ");
INSERT INTO sce_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Udu jilasan kunla Ezhande oluzhi udu jilazho. Ijiesan kunla Hudade mafan giedene Ezhande oluzhi ijiezho. Ese ijiesan kunlaye Hudade mafan kieliedene Ezhande oluzhi ese ijiezho. ");
INSERT INTO sce_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Matan alinie kunliuzhe goyadene oluzhi ese amiturazho. Goyadene oluzhiye ulie fugune. ");
INSERT INTO sce_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Matan amitushi Ezhande oluzhi amiturazho. Fuguseye Ezhande oluzhi fugune. Ingiese matan amitura, fuguliuzhe Ezhannughun wo. ");
INSERT INTO sce_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Mexiha fugusan kun, amitu kunde Ezhan danlane giezhi duya ijiedene aminne oluwo. ");
INSERT INTO sce_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Matan man Hudai shenpantai melie beine. Chi yale gaijiune kieliene? Chi yale gaijiune meilade uzhene? ");
INSERT INTO sce_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Jinwun jiere jilasan mutun, \"Ezhan kieliewo, 'Bi goyane aminghala fayen gieye. Soyuji odoula made xiutuliene. Soyuji amanla bishi Huda wo giezhi chenren giene.'\" ");
INSERT INTO sce_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Ingiese matan alinie kunliuzhe Hudai melie goyane shiqinyi jiodai giene. ");
INSERT INTO sce_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Ingiese matan nieniene bu kielieye. Jiexin xiaizhi gaijiulai melie boujia, banjighaku dunxii bu tei. ");
INSERT INTO sce_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Bi Ezhan Ersai xianxin giezhi kenjin mejiene. Yandeliuzhe benshen ganjin wituni uwo. Zinie kun ganjin uwo giese hhende ganjin uwo. ");
INSERT INTO sce_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Chi ijiunighala gaijiulane munan gieghase oreku daolighala ese giezho. Mexiha hhende oluzhi duya ijiewo, chi goyane ijiunighala hhei baxi bu olugha. ");
INSERT INTO sce_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Ingiese ta goya gounine kunlai bu sugiegha. ");
INSERT INTO sce_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Hudai gojiashi ijieku, ochiku pusho, Shenlin ogisan gundan, heqi, bayasuku wo. ");
INSERT INTO sce_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Mexihani ingiezhi shunjisan kunde Huda bayasune, kunlaye kuaine. ");
INSERT INTO sce_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Ingiese matan heqituzhi nieniene hendaghakui xiacha gieye. ");
INSERT INTO sce_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Ijiunighala Hudai wiliei bu qida olugha. Manshi ganjinni woma, chi ijiedene kunlai zui fanjighase ese oluzho. ");
INSERT INTO sce_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Migha ijie, jiu ochi, pse yan shiqindeliuzhe gaijiulani zui fanjighakui ulie giese gou wo. ");
INSERT INTO sce_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Chi xianxin giesanne Hudai melie goude barei. Kun goyane gou wo giesan shiqinyi giedene gui ulie teise fuqi wine. ");
INSERT INTO sce_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Inxin giezhi ijiese zui jinjine. Xianxin giekughala ese ijiezho. Xianxin giekughala giesanni pushoshi man zui wo. ");
INSERT INTO sce_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Matan khidun kunla indan goyane bu bayasughazhi khidun witu kunlai zholiennii danjikuni wo. ");
INSERT INTO sce_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Matan alinie kunliuzhe kunlai haochude oluzhi bayasughazhi hhelai hendaghakuni wo. ");
INSERT INTO sce_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Mexihaye goyane ese bayasughazho. Jinwun jiere jilasan mutun, \"Chii sugiesan kunlai sugieku man mii jiere irewo.\" ");
INSERT INTO sce_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Eqighandei huaisan jinwunshi man matande oluzhi sughazhi huaisan wo. Hhe matai rennai gieghazhi sughazhi kieliedene matande xiwon ogizho. ");
INSERT INTO sce_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Bi onxian giese rennai gieghazhi sughazhi kieliesan Huda tai sumuladanyi Mexiha Ersai daghazhi nie gholughadene ");
INSERT INTO sce_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","dajiala man hhantu mai Ezhan Ersa Mexihani Ada Hudai kuai! ");
INSERT INTO sce_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Ingiese Mexiha tai jienlieku mutun taye nieniene jienliezhi Hudai kuai. ");
INSERT INTO sce_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Bi kieliese Mexiha Hudai zhendaode oluzhi Yutai kunlade hoji danlazhi xienrenlade dain giesei chenjighawo, ");
INSERT INTO sce_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","pse niman kunlai Huda hhelade ubali xiisande kuaighazho. Jinwun jiere jilasan mutun, \"Ingiese bi niman kunlai dunda chii chenren giene. Bi donghala chii nierei doulane.\" ");
INSERT INTO sce_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Pse kieliezho, \"Niman kunla, ta Ezhanyi bexinlare hhantu bayasundu.\" ");
INSERT INTO sce_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Pse, \"Soyuji niman kunla, ta Ezhande doulandu. Soyuji minzula, hhende doulandu!\" ");
INSERT INTO sce_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Pse Isaiya kieliezho, \"Jianlai Yexini houdei irene. Hhe khizhedene niman kunlai gonjine. Niman kunla hhei xiwon giene.\" ");
INSERT INTO sce_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Xiwon ogisan Huda ta xianxin giekude yanyanji bayasukui, pinnanni tai zhughede durughazhi Shenlinni nenlighala xiwon olon ogi gie! ");
INSERT INTO sce_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Mii gaijiula, tande gouni, yanyanji agheli duruzhi ta nieniedene surugha shidakui bi kenjin mejiene. ");
INSERT INTO sce_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Ingieliuzhe bi niezhan shiqin jiere tai sumula ireghane giezhi danzine fugiedaghazhi tande xin huaikushi Huda made ogisan nenjienghala ");
INSERT INTO sce_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","bi niman kunlade oluzhi Mexiha Ersade wiliechi danlazho. Bi hhelade Hudai gouxioxii chonjise buwa niekielien wo. Shenlinyi tungo giezhi hhelai zhiguishighadene jienlieku mure mutun Hudade ogizho. ");
INSERT INTO sce_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Ingiese Mexiha Ersai miende bi Hudade oluzhi giesan shiqinde kuaikui wine. ");
INSERT INTO sce_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Niman kunlai shunjighane giezhi Mexiha mii tungo giezhi giesan wiliese chugo bi psedulai yama ulie kieliene. Hheshi kielienji, giekughala giesan wo. ");
INSERT INTO sce_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","Ghudureqi, fugie shiqinyi nenlighala, pse Hudai Ruhheryi nenlighala giesan wo. Bi Mexihai gouxioxii Yelusalense izhi Ililigude man chonji kurughawo. ");
INSERT INTO sce_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Ingiezhi bi Mexihani nierei chenliezhi ese daosan oronlade chonjine giezhi hende duralakushi kunlai jigun jiere gie ulie beighane giezho. ");
INSERT INTO sce_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Jinwun jiere jilasan mutun, \"Hhei xioxii mejie dasanla chanlane. Chenliezhi ese daosanla dunjirene.\" ");
INSERT INTO sce_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Ene yenyin jiere bi tai hhende haojihui echine giezhoma, echi dazho. ");
INSERT INTO sce_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Ede ene oronlade chonjiku oron widazho, pse haojinien bi tai hhende echiku duralazho. ");
INSERT INTO sce_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Ingiese bi Xibenyade echikude tai ochira, xien nietan laiwon giezhi xianshou giedene ta mii khughose giezhi xiwon giezho. ");
INSERT INTO sce_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Ingiezhoma, ede bi Yelusalende echizhi shentulade banman giene giezho. ");
INSERT INTO sce_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Maqidun, Yagaiyani kunla Yelusalenni nanxintu shentulade banman giene giezhi bayasuzhi baer khireighawo. ");
INSERT INTO sce_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Hhela enei bayasuzhi giekushi shuhuajia shentulade chaizho. Niman kunla hhelase ruhher jieredu haochui ghughazhi echise hhela injikude banman giese indanji wo. ");
INSERT INTO sce_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Ingiese bi kunla khireighasanni goude jiuizhi ogi ene shiqinyi onchen giedene tai hhense jingo giezhi Xibenyade echine. ");
INSERT INTO sce_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Bi tai hhende irekude Mexihani olon nenjienni deilazhi irekui bi mejiene. ");
INSERT INTO sce_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Gaijiula, bi matanyi Ezhan Ersa Mexiha, Shenlinni orekughala tande goude fenfulaye. Ta mare hhantu xiacha giezhi made oluzhi Hudase ingiezhi onxian gie, ");
INSERT INTO sce_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","\"Mii Yudaya oronni xianxin ulie giechen kunlai khade bu oroghazhi bi Yelusalende banman giesan shiqinde shentulai bayasuzhi jienliegha gie. ");
INSERT INTO sce_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Pse mii Hudai isighala tai hhende bayasuzhi iregha tanre hhantu hhamuragha gie.\" ");
INSERT INTO sce_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Pinnan ogisan Huda ta dajialare hhantu bi gie. Amine! ");
INSERT INTO sce_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Bi Jiengelini jiohuide gonjia danlasan mai eghechijiu Feibini tande jieshao gieye. ");
INSERT INTO sce_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Ta Ezhanni miende hhei shentula indan gieku mutun heshide jienlie. Hhe yan shiqinde banman kerese banman gie. Hhe olon kunlade banman giezho, madeye banman giezho. ");
INSERT INTO sce_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Baijila, Yajilade kielien asa. Hhela Mexiha Ersai miende mare hhantu wilie giezho. ");
INSERT INTO sce_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Mii aminde oluzhi goya aminne ese kerewo. Zinie bi hhelade mafan kielieku pusho, niman kunlai jiohuila man hhelade mafan kieliezho. ");
INSERT INTO sce_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Pse hhelai gieni jiohuii kunlade kielien asa. Bi oresan Ibainitude kielien asa. Hheshi Yaxiya oronyi ji 1 gie Mexihai xianxin giesan kun wo. ");
INSERT INTO sce_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Mereiyende kielien asa. Hhe tande oluzhi hende khishulazho. ");
INSERT INTO sce_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Mare hhantu bafanzi sousan mii qingu Andonigu, Yuniyade kielien asa. Hhela shitulai dunda minshen fugie wo, mase melie Mexihai xianxin giezho. ");
INSERT INTO sce_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Ezhanyi miende bi oresan Anbolide kielien asa. ");
INSERT INTO sce_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Mexihai miende matanre hhantu wilie giesan Erbanu, pse bi oresan Shidagude kielien asa. ");
INSERT INTO sce_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Mexihai miende olune giesan Yabilide kielien asa. Yalidobui giei kunlade kielien asa. ");
INSERT INTO sce_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Mii qingu Xiloqiende kielien asa. Naqishu giei Ezhanyi miendedu kunlade kielien asa. ");
INSERT INTO sce_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Ezhanyi miende khishulasan TufeinaTufusa ghualade kielien asa. Ezhanyi miende hende khishulasan oresan Bixide kielien asa. ");
INSERT INTO sce_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Ezhanyi miende sunghusan Lufu, hhei anadeni kielien asa. Hhei ana made ana danlazho. ");
INSERT INTO sce_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Yaxinqitu, Fulegan, Xiermi, Baloba, Heima, pse hhelare hhantuku gaijiulade kielien asa. ");
INSERT INTO sce_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Feilologu, Yuliyaghala, Niliya, hhei eghechijiughala, Alinba, pse hhelare hhantuku shentulade man kielien asa. ");
INSERT INTO sce_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Ta zhughesene nieniedene kielien asa. Mexihani jiohuila man tande kielien asazho. ");
INSERT INTO sce_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Gaijiula, bi tai xiahua gieye, ta surusan daolini fandui giezhi tai khudoghozhi banjighachen hhezighan kunlase gholodo. ");
INSERT INTO sce_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Imutu kunla mai Ezhan Mexihai ulie shunjizhi zinie goya shiqinne guizhi kuaiku seighan kielienghala loushi kunlai miine. ");
INSERT INTO sce_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Tai shunjisan shiqinla gochude chonji kuruzho. Ingiese bi tande oluzhi bayasuzho. Mii duranshi ta gou shiqin jiere jienzhaghan, doghun shiqin jiere menghan. ");
INSERT INTO sce_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Pinnan ogisan Huda Ibilisii kon douratai taizhi ireghaku ghujinlazho. Matanyi Ezhan Ersa Mexihani nenjien tanre hhantu bi gie! ");
INSERT INTO sce_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Mare hhantu wilie giesan Qimotai, mii qingu Luqiu, Yaso, Soxibade enela tande kielien asazho. ");
INSERT INTO sce_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Made xin deilazhi huaisan Deqi Ezhanyi miende tande kielien asazho. ");
INSERT INTO sce_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Mii jienliezhi jiohuini kunlai man jienliesan Gaiyu tande kielien asazho. Chenshii baer gonjisan Iladu, mai gaijiu Kotughala tande kielien asazho. ");
INSERT INTO sce_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Hudade kuaikui ogi. Bi chonjisan Ersa Mexihai gouxioxighala, eqighanku gonyinni niuighasan mimii mejieghakughala Huda tai khiduzhegha shidane. ");
INSERT INTO sce_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","Ene mimi ede xienjizhi khizhezho. Chanqiku Hudai minlin mutun xienzhilai shuni tungo giezhi soyuji minzulade mejieghadene hhelai xianxin gieghazhi shunjighawo. ");
INSERT INTO sce_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Ersa Mexihai tungo giezhi zi niekozi aghelitu Hudade chanqi kuaikui ogi. Amine!");
INSERT INTO sce_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Hudai isighala urudene Ersa Mexihade shitu danlasan BaoloSoqini gaijiughala ");
INSERT INTO sce_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Gelindoni Hudai jiohuide xin huaizho. Tai Mexiha Ersai miende zhiguishighazho, gochude mai Ezhan Ersa Mexihai nierei xiahua giesan kunlare hhantu man shentu giezhi uruzho. Mexihashi hhelai Ezhan wo, mai Ezhanye enbene. ");
INSERT INTO sce_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Mai Ada Huda, Ezhan Ersa Mexiha tande nenjien, pinnan ogi gie! ");
INSERT INTO sce_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Huda Mexiha Ersai miende tande nenjien ogise bi tande oluzhi bi zunjisan Hudade chan mafan kieliezho. ");
INSERT INTO sce_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Ta hhei sudoro kielien kielieku, erlin, yanyanjilai jiere man hendazho. ");
INSERT INTO sce_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Ingiezhi Mexihade beisan ganzhen tai dunda khiduzhezho. ");
INSERT INTO sce_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Ta nenjien jiere yama ese chaizhi mai Ezhan Ersa Mexiha xienjikui sagheizho. ");
INSERT INTO sce_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Huda tai zuihou kutula khiduzheghazhi mai Ezhan Ersa Mexihani udude ulie kheilaghane. ");
INSERT INTO sce_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Hudashi kekaoni wo, hhe tai uruzhi goya kewonre, yeshijiu mai Ezhan Ersa Mexihare laiwon gieghazho. ");
INSERT INTO sce_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Gaijiula, mai Ezhan Ersa Mexihani niereghala bi tai goude fenfulaye, ta man xianlitu kielien kielie. Tai dunda maodun bu khizhezhi nie zhughe nie sumuladanghala goude heqishi. ");
INSERT INTO sce_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Mii gaijiula, tai dunda maodun wine giezhi Gelaini giededu kunla made kieliezho. ");
INSERT INTO sce_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Mii isishi ta jien kunla, \"Bishi Baolonughun wo,\" \"Bishi Yabolonughun wo,\" \"Bishi Jifanughun wo,\" \"Bishi Mexihanughun wo.\" giezhi kieliezho. ");
INSERT INTO sce_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Mexihashi fenkai giesanni onu? Baolo tande oluzhi shizijia jiere fuguwu? Ta Baoloni niereghala xili jienliewu? ");
INSERT INTO sce_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Bi Jilisibu, Gaiyughalase chugo pse tai dunda kiemade xili ese gieghasande Hudade mafan kieliezho. ");
INSERT INTO sce_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Pse ta mii niereghala xili jienliewo giezhi kunla kieliene. ");
INSERT INTO sce_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Bi Siqifanai gieni kunladeye xili gieghazhi daozho, psedu kunlade xili gieghazhi daozhoyeshi bi matazho. ");
INSERT INTO sce_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Mexiha mii peikushi xili gieghaku pusho, gouxioxii chonjighaku wo. Bi aghelitu kielienghala ese chonjizho, pse Mexihani shizijiai zoin widane. ");
INSERT INTO sce_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Shizijiani daoli hhezighan widachen kunladeshi ben wo, matan enezighan ji0 uisan kunladeshi Hudai nenli wo. ");
INSERT INTO sce_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Jinwun jiere jilasan mutun, \"Bi aghelitu kunlai aghelini widaghane, jienzhatu kunlai jienzhani bendane.\" ");
INSERT INTO sce_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Aghelitu kun khala wo? Hanjia khala wo? Ene duyani erlintu kun khala wo? Huda ene duyai aghelini benni ese gholughazhou? ");
INSERT INTO sce_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Duya goya aghelighalane Hudai ese taniwo. Ingiese Huda kunla benni wo giesan bijien chonjisan daolighala xianxin giesan kunlai jiuine giezhi jiejin giewo. Eneshi Hudai agheli wo. ");
INSERT INTO sce_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Yutai kun ghudureqi kerezho, Xila kun agheli ereizhoma, ");
INSERT INTO sce_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","bijien chonjisanshi shizijia jiere ghadasan Mexiha wo. Eneshi Yutai kunde banjiku tashi wo, niman kunde benni woma, ");
INSERT INTO sce_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","bugon Yutai kun niman kun, Huda urusan kunde Mexihashi Hudai nenli, Hudai agheli wo. ");
INSERT INTO sce_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Hudai benni kunni aghelise fama wo. Hudai zholienni kunni khidunnise khidun wo. ");
INSERT INTO sce_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Gaijiula, tai urusanni nie sumula. Kunni isighala kieliese tai dunda aghelitu, nenlitu, zhiguitu kun choghon wo. ");
INSERT INTO sce_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Huda duya jieredu bennilai sunghuzhi aghelitulai shizheghazho. Huda duya jieredu zholiennilai sunghuzhi khidunnilai shizheghazho. ");
INSERT INTO sce_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Huda duya jieredu kunla uzhezhi xiniesan, henjisan, yama witu kunlai sunghuzhi winetulai widaghazho. ");
INSERT INTO sce_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Ingiese kun kiemada Hudai melie goyane kuai dane. ");
INSERT INTO sce_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Ingiezhoma, Huda tai Mexiha Ersare hhantulaghazho. Hhe Hudase irezhi mai agheli, gundan, zhigui, shuiku gholuwo. ");
INSERT INTO sce_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Jinwun jiere jilasan mutun, \"Kien kuaise Ezhanyi kuai.\" ");
INSERT INTO sce_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Gaijiula, eqighandei bi tai hhende echizhi Hudai mimii chonjikude seighan kielien, aghelighala ese giezho. ");
INSERT INTO sce_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Bi tai dunda bikude zinie Ersa Mexiha, pse hhei shizijia jiere ghadasanse chugo psedulai ulie mejiene giezhi jiejin giewo. ");
INSERT INTO sce_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Bi tai hhendeshi zholien, ayi, hende pugharazho. ");
INSERT INTO sce_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Bi kieliezhi chonjikude seighan, aghelitu kielienghala ese giezhi Shenlinni nenlighala zhenmin giezho. ");
INSERT INTO sce_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","Ingiese tai xianxin gieku kunni aghelide ese kouizho, Hudai nenlide kouizho. ");
INSERT INTO sce_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Ingiezhoma, xinyan jiere qiendasan kunlade bijien aghelini jianjizho. Eneshi duyai agheli pusho, duyai qienlini bareizhi widachen kunlai agheliye pusho. ");
INSERT INTO sce_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Bijien jianjisanshi eqighandei niuighasan Hudai mimitu agheli wo. Eneshi Huda duyai zhayaghaku melie matande famai ogine giezhi jinjisan wo. ");
INSERT INTO sce_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Ene aghelini duyani qienli bareichen kunla dunda mejiechen nieda uwo. Hhela mejiezhoshi famatu Ezhanyi shizijia jiere ulie ghadane. ");
INSERT INTO sce_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Jinwun jiere jilasan mutun, \"Hudade oresan kunlade Huda zhunbei giesanshi nudunghala uzhezhi ese daosan wo, chighinghala chenliezhi ese daosan wo, kunni zhugheye sumulazhi ese daosan wo.\" ");
INSERT INTO sce_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Ingiezhoma, matande Huda Shenlinni tungo giezhi mejieghawo. Shenlin yanniliuzhe mejiene, lien Hudai chijia isiniye mejiene. ");
INSERT INTO sce_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Kunni sudorodu ruhherse chugo kunni shiqinni kien mejiene? Niekielien wo, Hudai Ruhherse chugo Hudai shiqinni kiema mejie dane. ");
INSERT INTO sce_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Matan jienliesanshi duya jieredu ruhher pusho, Hudase iresan ruhher wo, ingiese Huda matande ogisan nenjienlai matan mejiene. ");
INSERT INTO sce_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Bijienye enelai jianjikude kunni agheli sughasan kielienghala ese giezho, Shenlin sughasanghala giezho. Ruhhertu shiqinlai ruhhertu kielienghala mejieghane. ");
INSERT INTO sce_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Hudai Ruhher uwotu kunla Hudai ruhher ogisanlai jienlie dane. Hhela enei ben wo giezho, ye dunjire dane. Ene shiqinlai zinie ruhherghala uzhe khizhene. ");
INSERT INTO sce_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Ruhhertu kunla yan shiqinniliuzhe uzhe khizhenema, kiema hhelai uzhezhi khizhe dane. ");
INSERT INTO sce_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","\"Kien Ezhanyi zhughei mejiene? Kien hhende surughane?\" Mai kieliese matande Mexihani zhughe wine. ");
INSERT INTO sce_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Gaijiula, bi eqighandei tande kielien kieliekude tai ruhhernughun danlagha dazhi beyenughun danlaghazho. Mexihai miende tai yeliwa mutun uzhezho. ");
INSERT INTO sce_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Bi tande budan ese qiezhezhi neizi qiezhekushi ta budanyi ijie dane, edeliuzhe ijie dane. ");
INSERT INTO sce_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Tashi beyenughun wo. Tai sudoro dubilieku, jianjinduku wine. Eneshi beyenughun pushonu? Zhao duyani kunla giesan mutun ese giezhou? ");
INSERT INTO sce_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Niezhan kunla kieliese bi Baoloni daghazho. Niezhan kunla kieliese bi Yaboloi daghazho giezho. Ingiezhi ta duyai kunlare niekielien pushonu? ");
INSERT INTO sce_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Yaboloshi kien wo? Baoloshi kien wo? Manshi wiliechi wo, zhao Ezhan nieniede ogisan renwughala tai xianxin gieghasan wo. ");
INSERT INTO sce_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Bi tareiwo, Yabolo usu teiwo, osighasanshi Huda wo. ");
INSERT INTO sce_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Ingiese tareisan, usu kiesan yama pusho, zinie osighasan Huda hen wo. ");
INSERT INTO sce_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Tareisan, usu kiesanghala niekielien wo, zhao nieniede wilie giesan mutun gunzi ogine. ");
INSERT INTO sce_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Bijienshi hhantu wilie giesan Hudai wiliechi wo. Tashi Hudai ghazha, mechi wo. ");
INSERT INTO sce_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Zhao Huda made ogisan nenjienghala bi nie hen guntou mutun jichui daizho, psedu kun jiereni gie giezhoma, jien kun matugie giekui xioxin gie. ");
INSERT INTO sce_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Ene dai goudaghasan jichushi Ersa Mexiha wo, psedu jichui kiemada dai dane. ");
INSERT INTO sce_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Ene jichu jiere kienliuzhe antan, miengu, boushi, mutun, osun, ghuyughala gie giese ");
INSERT INTO sce_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","panjiku udude jien kunla giesei xienjizhi khizheghane, khanghala khizheghane. Goya giesanla matugiezho giezhi ene khan shiine. ");
INSERT INTO sce_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Gie giesan kun hhe jichu jiere giesan bei shidase hhende jianli ogine. ");
INSERT INTO sce_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Giesanni sidera widase hhe kuiine. Hhei jiuinema, jiuiku hoxian khan dundase holu khizheku niekielien wo. ");
INSERT INTO sce_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Tashi Hudai dajien bikui, pse Hudai ruhher tai sudoro sousanyi ta ulie mejienu? ");
INSERT INTO sce_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Kien Hudai dajienyi qida olughase Huda hhe kunyi qida olughane. Hudai dajienshi zhiguitu wo, tashi ene dajien wo. ");
INSERT INTO sce_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Kienliuzhe goyane bu pienda. Tai dunda kun goyane ene duyade agheli wine giezhi sumulase benni gholu. Ingiese aghelitu gholune. ");
INSERT INTO sce_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Ene duyani aghelii Huda uzhese benni wo. Jinwun jiere jilasan mutun, \"Ezhan aghelitu kunlai jienzhanii hhelai bareiku on gholughawo.\" ");
INSERT INTO sce_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Pse huaizho, \"Aghelitu kunlai sumulaku yama isi witui Ezhan mejiene.\" ");
INSERT INTO sce_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Ingiese kienliuzhe kunni bu kuai, yanliuzhe manshi tanughun wo. ");
INSERT INTO sce_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Baolo, Yabolo, Jifa, duya, amituku, fuguku, edeku shiqin, jianlaiku shiqin manshi tanughun wo. ");
INSERT INTO sce_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","Tashi Mexihanughun wo, Mexihashi Hudanughun wo. ");
INSERT INTO sce_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Ingiese ta bijienyi Mexihani wiliechi, pse Hudai chijia daolini gonjia danlaghakui wo. ");
INSERT INTO sce_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Gonjiade yoqiu giekushi shixinji giekui wo. ");
INSERT INTO sce_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Ta mii kielie yehao kunla kielie yehao bi yamacha ulie teine. Bi goyane goya ulie kieliene. ");
INSERT INTO sce_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Bi sumulase mii lianxinde yama ese chaizhoma, ingieliuzhe minughun man oluzho giezhi kielie dane. Mii kieliekushi Ezhan wo. ");
INSERT INTO sce_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Ingiese shihou ese kuzhezhi Ezhan ese iretula ta kienyiliuzhe bu kielie. Hhe irese kharade niuighasanlai zhouizhi khizheghane, kunyi zhughei mujilai khizheghane. Hhe shihoude Huda jien kunlai kuaine. ");
INSERT INTO sce_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Gaijiula, bi tande oluzhi ene shiqin jiere Yaboloji goyane bilazhi yanzi uzheghazho. Ingiekushi jinwun jiere jilasanse bu daogha giesan isii ta bijiense suru giezho, pse tai dunda kienliuzhe goyane bu kondazhi ene niei fugiede uzhe, hhe niei meilade uzhe bu gie giezho. ");
INSERT INTO sce_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Kien chii kunlare niekielien pusho giezho? Chii alinieshi chade ogisan pusho? Ogisan enbese ogisan pusho giezhi yale goyane kuaine? ");
INSERT INTO sce_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Ta ijin chuduzho, ijin bayazhewo. Bijiense chugo ta honshan danlawo. Mii xiwonshi ta zhenzhenji honshan danlama, bijienye tanre hhantu danlaye! ");
INSERT INTO sce_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Bi sumulase Huda bijien shitu danlasanlai zhan eghisanse barei ire sixin panjisan kun mutun zui khuina teizhi kunlade uzheghasanyi xianli. Bijienyi xi mutun duyani kunlade, qienxienlade uzheghazho. ");
INSERT INTO sce_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Bijien Mexihani yenyinghala benni gholuzho, ta Mexihai miende jienzhani gholuzho. Bijien zholien wo, ta khidun wo, kunla tai kuaizho, bijienyi meilade uzhezho. ");
INSERT INTO sce_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Eli kuliuzhe bijien oliesuzhi undasuzho, hulan muchughun wo, kunlase neizhi souku oron uwo. ");
INSERT INTO sce_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","Khishulazhi goyane khaghala wilie giezho. Kunla kharase bijien gounii kieliezho, kunla heise rennai giezho. ");
INSERT INTO sce_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","Kunla bijienyi sugiese bijien gou kielienghala khareizhi kieliezho. Edeliuzhe bijien duya jieredu zannanni, yanyanjilai dundadu laji gholuzho. ");
INSERT INTO sce_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Bi enei huaise tai shizheghane ese giezho, goya oresan kesilane mutun tande jingao giezho. ");
INSERT INTO sce_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Mexihai miende tande loushi olon no woma, ada olon uwo. Bi gouxioxii chonjizhi Mexiha Ersai miende tande ada danlazho. ");
INSERT INTO sce_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Ingiese bi tai goude fenfulaye, ta mii yanzii suru. ");
INSERT INTO sce_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Ene yenyin jiere bi Qimotaini peizhi tai hhende echighawo. Hheshi Ezhanyi miende bi oresan shixinji kewon wo. Hhe tai qixin giezhi bi Mexiha Ersai sudoro matugie giesei, pse go oron, go jiohuilade matugie sughasei jilaghane. ");
INSERT INTO sce_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Tai dunda niezhan kunla sumulase bi tai hhende ulie irene giezhi goyalane fugiede uzhezho. ");
INSERT INTO sce_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Ingieliuzhe Ezhan duran bise bi tai hhende ghujighan echidene goyane fugiede uzhesanlai kielienni ulie uzhene, nenlii uzhene. ");
INSERT INTO sce_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Hudai gojiashi kieliende uwo, nenlide wo. ");
INSERT INTO sce_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Ta yan kerene? Bi banban bareizhi tai faile iremu, oreku, renyitu zhugheghala ire? ");
INSERT INTO sce_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Bi chenliese shuhuajia tai dunda lon kijieku shiqin wine. Intu shiqin niman kunlai dundaliuzhe uwo. Nie kun goya khuitu anarene kijiezho. ");
INSERT INTO sce_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","Ta dou goyalane fugiede uzhene. Ta indan hende nango giekui wo. Ene shiqinni giesan kunni tai dundase tou khighakui wo! ");
INSERT INTO sce_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Mii kun tanre hhantu uwoma, zhughemi tanre hhantu wo. Bi tai hhende bisan mutun intu shiqinyi giesan kunyi Ezhan Ersai niereghala ijin zui jinjiwo. ");
INSERT INTO sce_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","Ta hhantulazhi mii zhughe tanre hhantu bikude mai Ezhan Ersani qienlighala ");
INSERT INTO sce_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","intu kunni Ibiliside jiuizhi beyeni huailugha gie, ingiese ruhheryini Ezhanni udude jiuine. ");
INSERT INTO sce_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Ta goyalane kuaise ese oluzho. Goujinie kunieghe nie duizi ghurunni man faighakui ta ulie mejienu? ");
INSERT INTO sce_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Tashi tanmien woshi khuichen kunieghei widaghadene shini ghurun gholu. Matanyi Jiulidaosan Jieni ghoni ghughan yeshijiu Mexihai ijin zharuzhi sidagha giewo. ");
INSERT INTO sce_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Ingiese matan jieqi daoghase doghun, mouxientu khuichen kuniegheghala bu daoghadene ganjin, shixintu tanmienghala daoghaye. ");
INSERT INTO sce_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","Bi eqighandei tande xin huaizhi ta lon kijiechen kunlare laiwon bu gie giezhi kieliewo. ");
INSERT INTO sce_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","Mii isishi ene duyadedu lon kijiechen, tanxin giechen, piendachen, nigiedai beiichen kunlare jiedui laiwon bu gie giekui pusho. Qingiese ta ene duyase likai giese da gou wo. ");
INSERT INTO sce_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Ede bi ene xinni tande huaikushi goyaneshi xianxin giesan gaijiu wo giedene lon kijiesan, tanxin giesan, nigiedai beiisan, kun sugiesan, jiu ochisan, piendasan intui giesan kunlare ta laiwon bu giezhi budanye hhantu bu ijie giezho. ");
INSERT INTO sce_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","Ghadanedu kunyi bi kheilaku pushoma, sudorodu kunyi ta kheilaku pushonu? ");
INSERT INTO sce_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","Ghadanedu kunyi Huda panjine. \"Ta dundasene mouxien kunlai tou khigha.\" ");
INSERT INTO sce_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Tai dunda jianjinduku shiqin bidene matugie shentulade ese zhazhi gou witu kunlade zhale echizho? ");
INSERT INTO sce_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Shentula duyai panjikui ta ulie mejienu? Ta duyai panjise ene ga shiqinlai panji danu? ");
INSERT INTO sce_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Matan qienxienlai panjikui ta ulie mejienu? Ingiese duyai shiqinni yan sanane? ");
INSERT INTO sce_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Ingiese jiohuide intu shiqin bise matugie jiohui zunzhun ese giesan kunlai panjighane? ");
INSERT INTO sce_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","Bi ingiezhi kieliekushi tai shizheghane giezho. Tai dunda gaijiulai shiqinyi chuli gieku aghelitu kun nieda uwonu? ");
INSERT INTO sce_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Tai dunda gaijiula gaijiulai zhazhi dou xianxin ulie giechen kunlai melie zhale echiwo. ");
INSERT INTO sce_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Ta nieniene zhase tanughun fugiede codazho. Ta yale bixinde ulie beizhi kui ulie ijiene? ");
INSERT INTO sce_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Ta khareidene kunlai bixindaghazhi kuighazho, hhelashi goyai gaijiu wo. ");
INSERT INTO sce_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","Gou witu kunla Hudai gojiai jienlie dakui ta ulie mejienu? Goyane bu pienda, lon kijiechen, nigiedai beiichen, piofen giechen, ere kun biozi danlachen, tunxinlien giechen, ");
INSERT INTO sce_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","ghulachen, tanxin giechen, sudochen, kunni sugiechen, piendachen enela Hudai gojiani jienlie dane. ");
INSERT INTO sce_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","Tai dunda niezhan kunla eqighandei intui giezhi daozhoma, ede Ezhan Ersa Mexihani niere, pse mai Hudai ruhherni tungo giezhi tai ijin waghazho, zhiguishighazho, gounide sanazho. ");
INSERT INTO sce_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","Goyane yan shiqin gieliuzhe olune giezhi kunla kieliezhoma, man haochu bikui pusho. Bi yan shiqin gieliuzhe oluzhoma, alinie shiqinniliuzhe bi goyane kunzhi ulie gieghane. ");
INSERT INTO sce_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","Ijiuni kielide oluzho, kieli ijiunide oluzho giezhoma, Huda ene ghualai widaghane. Beyeshi lon kijiekude giesan pusho, Ezhande oluzhi giesan wo, Ezhan kunni beyede oluzho. ");
INSERT INTO sce_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","Huda Ezhanyi aminne olughazhi maiye goya nenlighalane aminne olughane. ");
INSERT INTO sce_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","Tai beyeshi Mexihani iyanzi bikui ta ulie mejienu? Bi Mexihani iyanzii biozini iyanzi gholughazhi olunu? Kenjin ulie olune! ");
INSERT INTO sce_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Biozighala hhantulase hheghala nie beye gholukui ta ulie mejienu? Jinwun jiere kieliezho, \"Ghuala nie beye gholune.\" ");
INSERT INTO sce_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Ezhanghala hhantulasan kun Ezhanghala nie ruhher gholune. ");
INSERT INTO sce_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Ta lon kijieku shiqinse pii. Kun yan zui fanjiliuzhe beye ghadane giezho, zinie lon kijiekushi goyai beye jiere giezho. ");
INSERT INTO sce_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Tai beyeshi Huda tande ogisan Shenlin tai sudoro souku dajien bikui ta ulie mejienu? Tashi goyanughun pusho, ");
INSERT INTO sce_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","fugie jiageghala agizhi iresan wo. Ingiese ta beyeghalane Hudai kuai. ");
INSERT INTO sce_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Xin jiere ta qiisan shiqinni kielieye. Ere kun eme kunni ulie shighase gou wo giezhoma, ");
INSERT INTO sce_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","lon kijieku shiqinlase ayizhi ere kunde bierei bise gou wo, eme kunde zhanguiji bise gou wo. ");
INSERT INTO sce_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Zhanguiji biereidene zhanguiji danlaku zherenyi feii, biereiye zhanguijidene ingiezhi gie. ");
INSERT INTO sce_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","Bierei goya beyene gonjiku qienli uwo, qienli zhanguijide wo. Zhanguijiye goya beyene gonjiku qienli uwo, qienli biereide wo. ");
INSERT INTO sce_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Ghuala nieniene bu kuigha. Zinie zhomen onxian giene giese ghuala tunyi bise zhanshi jiere danlin kijiese olune. Khuinashi ghuala hhantula, pse ta goyane kunzhi gie dakude Ibilisi miine. ");
INSERT INTO sce_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","Bi ingiezhi kieliese tande minlin ese xiaizho, ijien qilazho. ");
INSERT INTO sce_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Mii xiwonshi kunla man bi mutun woshi giezhoma, jien kun Hudase jienliesan nenjien buxian wo. Niezhanla ingiezho, niezhanla qingiezho. ");
INSERT INTO sce_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Jiehun ese giesan, pse guafulai kieliese hhela bi mutun jiehun ulie giese gou woma, ");
INSERT INTO sce_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","goyane kunzhi gie dase jiehun giekui wo. Zhughe tuliezhi bazilie datula jiehun giese gou wo. ");
INSERT INTO sce_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Jiehun giesanlade bi fenfulaye. Eneshi bi fenfulasan pusho, Ezhan fenfulasan wo. Bierei zhanguijisene bu danxinra. ");
INSERT INTO sce_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","Danxinrase pse jiehun bu gie, yen zhanguijighalane gouda. Ere kunye biereine bu benda. ");
INSERT INTO sce_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","Psedu kunlade bi kielieye. Eneshi Ezhan kieliesan pusho, bi kieliesan wo. Xianxin giesan gaijiude xianxin ese giesan bierei bizhi hhe bierei hhere hhantu udu daoku duran bise hhei bu benda. ");
INSERT INTO sce_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","Biereide xianxin ese giesan zhanguiji bizhi hhe zhanguiji hhere hhantu udu daoku duran bise hhei bu benda. ");
INSERT INTO sce_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","Ese xianxin giesan zhanguiji biereini yenyinghala zhiguitu gholune. Ese xianxin giesan bierei zhanguijini yenyinghala zhiguitu gholune. Pse tai kesila ganjin uwoma, ede hhela zhiguitu wo. ");
INSERT INTO sce_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Xianxin ese giesan kun danxinrane giese hhei danxinragha. Intu shiqinde xianxin giesan gaijiu eghechijiulade ziyu wine. Huda tai urukushi tai heqishighane giezho. ");
INSERT INTO sce_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","Bierei danlachen, chii tungo giezhi zhanguijiichii kenen jiui shidane. Zhanguiji danlachen, chii tungo giezhi biereinichii kenen jiui shidane. ");
INSERT INTO sce_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Alinie kunliuzhe Ezhan nanpeilasan mutun, pse Huda hhei urusan mutun udu dao. Eneshi bi go jiohuilade jinjisan wo. ");
INSERT INTO sce_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Niezhan kunlai hetoune giedene uruzhoshi jihaoni widaghaku biyo uwo. Niezhan kunlai hetoune ese giedene uruzhoshi hetoune gieku biyo uwo. ");
INSERT INTO sce_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Hetoune gie, ulie gie zhunyo uwo. Zui zhunyonishi Hudai minlinyi goude zunji. ");
INSERT INTO sce_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Jien kunyi urukude matui woshi qingiezhi bei. ");
INSERT INTO sce_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Chii urukude chi hoji danlazhoshi munan bu gie. Ziyushiku jihui bise goude barei. ");
INSERT INTO sce_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","Hoji danlasei Ezhan uruse hheshi Ezhanni ziyutu kun wo. Ziyutu kunyi uruse hheshi Mexihani hoji wo. ");
INSERT INTO sce_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","Tashi fugie jiageghala agizhi iresan wo, kunde hoji bu danla. ");
INSERT INTO sce_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Gaijiula, jien kunyi urukude matui woshi Hudai melie qingiezhi bei. ");
INSERT INTO sce_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","Jiehun ese giesan kunni kieliese made Ezhanni yama minlin uwoma, Ezhan made ubali xiizhi mii nie kekaotu kun gholughase bi ijienne kielieye. ");
INSERT INTO sce_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","Edeku kunnan mutunshi bi uzhese ta qinkonne ulie bienjighase gou wo. ");
INSERT INTO sce_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","Chade bierei bise hhense danxinrane bu gie. Chade bierei wise bierei agine bu gie. ");
INSERT INTO sce_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","Bierei agise zui ese fanjizho, oqin jiehun gieseye zui ese fanjizhoma, jiehun giesan kunla udu daokude ku shouine, bi tai intu ku shouighaku duran uwo. ");
INSERT INTO sce_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","Gaijiula, bi tande kielieye, shihou oloncha widawo. Enedu khuinashi bierei bichenla bierei wichen mutun giekui wo. ");
INSERT INTO sce_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","Wilachenla ese wilachen mutun gie. Bayasuchenla ese bayasuchen mutun gie. Dunxi agichenla yama uwoku mutun gie. ");
INSERT INTO sce_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","Duya jieredulai xianshou giesanla xianshou ese giesan mutun gie. Edeku duyai yanzi widane. ");
INSERT INTO sce_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","Mii duranshi ta yamade munan ulie giesejiu. Bierei ese agisanla Ezhanni shiqinde munan giezhi matugie Ezhanni bayasughakui sumulazho. ");
INSERT INTO sce_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","Bierei agisanla duya jieredu shiqinde munan giezhi matugie biereine bayasughakui sumulazhi ");
INSERT INTO sce_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","zhugheni nie jiere uwo. Guafu, oqinla Hudai shiqinde munan giezhi beye, ruhherlani man zhiguishighane giezho. Biereila duyani shiqinde munan giezhi zhanguijine matugie bayasughakui sumulazho. ");
INSERT INTO sce_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","Bi ene kielienyi kieliekushi tai gonjine ese giezho, tai gounide oluzho. Tai olusan shiqin gieghazhi psedu shiqinde zhughe bu chilazhi zhomen Ezhanni shunji giezho. ");
INSERT INTO sce_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","Nie kun goyade bolusan oqinyi kuighawo giese pse hhe oqinye jiehun gieku nasunse daose hhe kun sumulase indan jiehun giene giese zhao goyane isighala gie, eneshi zui pusho. Hhelai jiehun giegha. ");
INSERT INTO sce_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","Jiaru hhe kun zhughedene jiexin xiaizhi kunzhi gie shidazhi yama biiku shiqin uwoshi ulie jiehun gieseye gou wo. ");
INSERT INTO sce_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","Ingiese jiehun gieseye gou woma, ulie jiehun giese genjia gou wo. ");
INSERT INTO sce_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Zhanguiji bikude biereini gonjizho, zhanguiji fuguse bierei ziyude kiende khiku duranshi khireima, Ezhanyi xianxin giesan kunde khikui wo. ");
INSERT INTO sce_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","Hhe bierei loujide ulie khise genjia gou wine. Eneshi mii ijien woma, bi sumulase Hudai Ruhher mii jiereye wine. ");
INSERT INTO sce_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","Nigiedade ogisan ijiunii kieliese matande man ene fanmienni erlin bikui matan mejienema, erlin kunni fugiede uzheghane, oreku kunni hendaghane. ");
INSERT INTO sce_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","Goyane mejiene giesan kun indan mejiekune dou ulie mejienema, ");
INSERT INTO sce_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","Hudade oresan kunni Huda tanine. ");
INSERT INTO sce_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","Nigiedade ogisan ijiuni ijiekui kieliese nigieda duyade yama pusho bikui matan mejiene. Huda niekozi wo, pse Huda wikui matan mejiene. ");
INSERT INTO sce_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","Asiman, zemin jiere Huda, Ezhan giezhi urusan olon woma, ");
INSERT INTO sce_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","matande niekozi Huda Ada wo. Yanyanjila man hhense irezho, matanshiye hhenughun wo. Pse matande niekozi Ezhan wo, hheshi Ersa Mexiha wo. Yanyanjila hhei tungo giezhi wine, matanye hhei tungo giezhi wine. ");
INSERT INTO sce_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","Ingieliuzhe intu erlinni jien kunde ese ogizho. Niezhan kunla edeliuzhe nigiedai beiizhi gon oluzho. Ingiese hhela ijiekude nigiedade ogizhi daosan wo giezho. Hhelai lianxin zholienshi zannanshiwo. ");
INSERT INTO sce_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","Shijishan ijieku matan Hudaghalai chadashigha dane. Ulie ijiese yama sunshi uwo, ijieseye yama haochu uwo. ");
INSERT INTO sce_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","Ingiese ta xioxin gie, pse tai ziyu xianxin gieku zholientu kunlai zui fanjighane. ");
INSERT INTO sce_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","Chi intu erlintu kun nigiedai miode ijiesei lianxin zholientu kunla chanlase hhe danzine fugiedaghazhi nigiedade ogisan ijiuni ulie ijienu? ");
INSERT INTO sce_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","Zholientu kun chii erlinni yenyinghala widane. Hheshi Mexiha hhende oluzhi duya ijiesan gaijiu wo. ");
INSERT INTO sce_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","Ta ingiezhi gaijiulai reizhi hhelai zholientu lianxinyi shanjise Mexihani reiwo. ");
INSERT INTO sce_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","Ingiese ijieku gaijiulai zui fanjighase bi chanqi migha ulie ijiene, pse bi gaijiulane zui fanjighane. ");
INSERT INTO sce_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","Bishi ziyutu kun pushonu? Shitu pushonu? Bi mai Ezhan Ersai chanlazhi ese daowu? Tashi bi Ezhanyi miende giesan wiliei jiego pushonu? ");
INSERT INTO sce_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","Bi kunlai shitu pusholiuzhe tai shitu enbene. Tashi bi Ezhanyi miende shitu danlasan zhenji wo. ");
INSERT INTO sce_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","Mii kieliesan kunlade bi goyane ingiezhi huine. ");
INSERT INTO sce_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","Bijiende ijiezhi ochiku qienli uwonu? ");
INSERT INTO sce_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","Bijiende psedu shitu, Ezhanni gaijiula, pse Jifa mutun xianxin giesan biereine uduruku qienli uwonu? ");
INSERT INTO sce_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","Zinie bi Banabaghalade wilie ulie gieku qienli uwonu? ");
INSERT INTO sce_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","Budui danlachen kun kien ijiunine bareizho? Kien putou tareidene yenzini putoui ulie ijiene? Kien iman chezhedene neizii ulie ochine? ");
INSERT INTO sce_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","Bi ingiezhi kieliekushi kunni kieliedanghala kieliezhou? Guijin jiereye ingiezhi ese kieliezhou? ");
INSERT INTO sce_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","Musani guijin jiere, 'Fughe tughon yanchikude zuilun bu zhogha.' giezhi huaizho. Huda fughereide zhughe chilazhou? ");
INSERT INTO sce_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","Enei man matande kieliesan pushonu? Kenjinshi matande oluzhi huaizho. Tareichen kun ghurane giezhi panjizhi tareizho, yanchichen kun ghughane giezhi panjizhi yanchizho. ");
INSERT INTO sce_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","Bijien tai dunda ruhher fanmienni fureni tareidene tanse beye fanmienni injikui ghurase gofen onu? ");
INSERT INTO sce_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","Psedu kunlade tai jierese intu xianshou gieku qienli bise bijiende genjia uwonu? Ingieliuzhe bijien ene qienlini ese injiwo. Khareidene Mexihani gouxioxii duikuse ayizhi soyujilai rennai giewo. ");
INSERT INTO sce_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","Mechide wilie giesan kun mechii dunxii ijiesei, pse sidagha gieku teizi konde ushilasan kun sidagha gieku teizi jieredu dunxii ghughasei ta ulie mejienu? ");
INSERT INTO sce_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","Qingiezhi Ezhanye fenfulazho. Gouxioxini chonjisan kunla gouxioxide kouizhi udu dao giezho. ");
INSERT INTO sce_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","Ingieliuzhe intu qienlini bi goujida injizhi ese daozho. Bi ede xin huaikushi made ingiezhi gie ese giezho. Bi fuguliuzhe bi kuaikune kunlade qianlazhi ulie echighane. ");
INSERT INTO sce_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","Bi gouxioxii chonjise yama kuaikui uwo. Bi ulie chonjise banfa uwo. Ulie chonjise made gou widawo! ");
INSERT INTO sce_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","Bi duralazhi enei giese made gunzi wine. Duran wiliuzhe ene zherenni made ogizho. ");
INSERT INTO sce_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","Ingiese mii gunzishi yan wo? Jiushi gouxioxii kunlade belien chonjizhi indan kereku baerni ese kerekui wo. ");
INSERT INTO sce_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","Made ziyu wine, kiema mii gonji danema, bi soyuji kunlade yenyizhe hoji danlakushi jinlianji olon kunyi jiuighane giezho. ");
INSERT INTO sce_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","Bi Yutai kunlade Yutai kun danlakushi Yutai kunlai jiuighane giezho. Bi guijin doura uwoliuzhe guijin douradu kunlade guijin douradu kun danlakushi guijin douradu kunlai jiuighane giezho. ");
INSERT INTO sce_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","Bi guijin witu kunlade guijin witu kun danlakushi guijin witu kunlai jiuighane giezho. Shijishan made Hudai guijin uwoku pusho, bi Mexihani guijin doura wo. ");
INSERT INTO sce_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","Bi zholien kunlade zholien kun danlakushi zholien kunlai jiuighane giezho. Bi yan kunde yan kun danlakushi matugieliuzhe ezighan kunyi jiuighane. ");
INSERT INTO sce_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","Bi gouxioxini yenyinghala man giekushi kunlare hhantu gouxioxii haochui xianshou giene giezho. ");
INSERT INTO sce_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","Bisai giekude kunla man holuliuzhe zi niekozi kun jianli linlakui ta ulie mejienu? Taye ingiezhi holuma, jianli linlane. ");
INSERT INTO sce_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","Bisai giechen kunla go fanmiende goyane gonjizho. Ingiezhi hhela widaku jianlini linlane giezhoma, matan ulie widaku jianlini linlane giezho. ");
INSERT INTO sce_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","Ingiese bi muji wizhi ese holuzho, chuidase ulie noughachen kun ulie gholune. ");
INSERT INTO sce_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","Bi beyene hende gonjizhi kunzhi giene, pse bi kunlade gouxioxii chonjizhi ogidene goyane baxi olune. ");
INSERT INTO sce_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Gaijiula, matanyi xienrenla eqighandei olien dourase haise daosan ene shiqinyi bi tai goude jilaghane giezho. ");
INSERT INTO sce_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","Manla olien dourase haise xili jienliezhi Musai daghawo. ");
INSERT INTO sce_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","Manla niekielienji ruhhertu ijiunii ijiewo. ");
INSERT INTO sce_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","Manla niekielienji ruhhertu usui ochiwo. Ochisanshi hhelare yosan ruhhertu tashise khizhesan wo. Ene tashishi Mexiha wo. ");
INSERT INTO sce_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","Ingieliuzhe hhelai dundadu fugie olie kunlade Huda xiqi wise hhelai hontande alawo. ");
INSERT INTO sce_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","Fashen giesan ene shiqinla matande jingao giezhi hhela mutun doghun shiqinni bu neii giezho. ");
INSERT INTO sce_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","Ye hhelai dundadu kunla mutun nigiedalai bu beii giezho. Jinwun jiere jilasan mutun, \"Bexinla sousenu ochizhi ijiene, bosizhese nadune.\" ");
INSERT INTO sce_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","Hhela kunlare lon kijiezhi niudude 23000 kun fuguwo. Matan hhela mutun bu gieye. ");
INSERT INTO sce_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","Hhelai dundadu kunla Ezhanni shiidene moghei zhou alawo. Matan hhela mutun Ezhanni bu shiiye. ");
INSERT INTO sce_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","Hhela boxin kieliedene azaraili qienxien hhelai aminni agiwo. Ta hhela mutun boxin bu kielie. ");
INSERT INTO sce_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","Enezighan shiqinla hhelai jiere fashen giezhi kunlade jingao giezho. Matan enezighan duya baraku kunlade surughane giezhi huaizho. ");
INSERT INTO sce_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","Ingiese goyane beizhi undanlawo giesanla indan xioxin gie, pse banjine. ");
INSERT INTO sce_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","Tande iresan shiiku kunlade man wine. Hudashi kekaoni wo, Hhe tande danji daku shiikui ulie ireghane. Shiikude tande nie piiku mo keighazhi tai danji shidaghane. ");
INSERT INTO sce_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","Ingiese mii orentula, ta nigiedalai beiikuse gholodo. ");
INSERT INTO sce_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","Bi minbaitu kunlade kieliezho, bi kieliesanlai ta goyalane uzhezhi gie. ");
INSERT INTO sce_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","Matan onxian giedene ochisan fuqitu beizishi Mexihani chusunde hhantulasan pushonu? Matan ginan ghuluzhi ijiekude Mexihani beyede hhantulasan pushonu? ");
INSERT INTO sce_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","Ginan niekozi wo, matan kun olon woma, nie beye wo. Matan man nie ginande hhantulazho. ");
INSERT INTO sce_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","Ta Isilie bexinlai sumula, sidagha gieku teizi jieredu dunxii ijiesanlashi sidagha gieku teizide hhantulasan pushonu? ");
INSERT INTO sce_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","Bi kieliesanshi yan isi wo? Nigieda, pse nigiedade ogisan ijiunishi yan wo? Yamada pusho! ");
INSERT INTO sce_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","Bi kieliesanshi niman kunla ogise Hudade ese ogizho, sheitande ogizho. Bi tai sheitanre hhantulaghaku duran uwo. ");
INSERT INTO sce_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","Ta Ezhanni beizii ochidene sheitanni beizii ochise jiedui ulie olune. Ezhanni xii soudene sheitanni xii souse jiedui ulie olune. ");
INSERT INTO sce_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","Matan Ezhanni reizhi hokughanu? Matan hhense fama onu? ");
INSERT INTO sce_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","Yanniliuzhe giese olune giezhi kunla kieliezhoma, man haochu wineku pusho. Yanniliuzhe giese olune giezhoma, man kunlai hendaghakui pusho. ");
INSERT INTO sce_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","Kienliuzhe goyane haochude bu olu, kunlai haochude olu. ");
INSERT INTO sce_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","Shichande huisan mighalai ta man ijie, lianxinni yenyinghala yama bu asadene ijie. ");
INSERT INTO sce_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","Zemin, zemin jiere durusanlashi man Ezhannughun wo. ");
INSERT INTO sce_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","Niezhan xianxin ulie giesan kunla tai xinlazhi ijieghase ta duran bizhi echise tai melie beilasanlai ijie, lianxinni yenyinghala yama bu asa. ");
INSERT INTO sce_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","Bifan \"eneshi nigiedade xienji giesan ijiuni wo\" giezhi kunla tande kieliese, hhe kunde oluzhi, lianxinni yenyinghala bu ijie. ");
INSERT INTO sce_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","Bi kieliesanshi tai lianxin pusho, hhe kunyi lianxin wo. Mii ziyuni yangiezhi kunlai lianxinghala kieliene? ");
INSERT INTO sce_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","Bi mafan kieliedene ijiese yangiezhi bi mafan kieliesan ijiunii yenyinghala mii sugiene? ");
INSERT INTO sce_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","Ingiese ta ijie, ochi yan gieliuzhe Hudai kuaine giezhi gie. ");
INSERT INTO sce_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","Bugon Yutai kun, Xila kun, Hudai jiohuiliuzhe ta hhelai bu banjigha. ");
INSERT INTO sce_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","Bi giesan mutun yan shiqindeliuzhe kunlai bayasugha. Goyane haochude bu oludene kunlai haochude oluzhi hhelai jiuigha. ");
INSERT INTO sce_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","Bi Mexihase surusan mutun ta mase suru. ");
INSERT INTO sce_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","Ta yandeliuzhe mii jilazhi da bi tande chonjizhi ogisei goude bareizho, ingiese bi tai kuaizho. ");
INSERT INTO sce_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","Jien ere kunlai qiorunshi Mexiha wo, biereilai qiorunshi ere kun wo, Mexihai qiorunshi Huda bikui bi tande mejieghaku duran wine. ");
INSERT INTO sce_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","Ere kun onxian giekude, Hudai kielienyi kieliekude qiorunne huighase qiorunne shizheghazho. ");
INSERT INTO sce_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","Biereila onxian giekude Hudai kielienyi kieliekude qiorunne ulie huighase qiorunne shizheghazho. Qingiese qiorunne dulisan niekielien wo. ");
INSERT INTO sce_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","Biereila qiorunne ulie huighase usunne ghigha. Usunne ghigha, dulidene shizhese qiorunne huigha. ");
INSERT INTO sce_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","Ere kun indan qiorunne ulie huighakuni wo, hheshi Hudai yanzi, kuaikui wo. Biereishi ere kunyi kuaiku wo. ");
INSERT INTO sce_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","Ere kunshi biereise khizhesan pusho, biereishi ere kunse khizhesan wo. ");
INSERT INTO sce_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","Da ere kunshi biereide oluzhi zhayaghasan pusho, biereishi ere kunde oluzhi zhayaghasan wo. ");
INSERT INTO sce_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","Ingiese biereila qienxienni yenyinghala qiorun jierene indan jihao giekuni wo. Ene jihaoshi qienli dourashiku isi wo. ");
INSERT INTO sce_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","Ingieliuzhe Ezhanni miende ere kun uwoshi ulie olune, bierei kun uwoshiye ulie olune. ");
INSERT INTO sce_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","Bierei ere kunse khizhesan mutun ere kunye biereii tungo giezhi khizhezho. Soyujila man Hudase khizhezho. ");
INSERT INTO sce_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","Ta goyalane sumula, biereila Hudase onxian giekude qiorunne ulie huighase heshi winu? ");
INSERT INTO sce_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","Ere kunla fudu usun liuise shizhekui ta yenlai ulie mejienu? ");
INSERT INTO sce_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","Biereila fudu usun liuise kuaine. Usunshi biereii qiorunni huighakude ogizho. ");
INSERT INTO sce_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","Niezhan kunla jianjindune giese bijiende intu xigon uwo, Hudai jiohuiladeye intu xigon uwo. ");
INSERT INTO sce_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","Ede bi tai fenfulane giesande tai ulie kuaine. Ta hhantulase haochu uwo, zinie huaichu wo. ");
INSERT INTO sce_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","Ji 1 gieshi bi chenliese ta nie jiohuinughunla libai giene giezhi hhantulakude tai dunda danlinraku shiqin wine. Ene kielienyi bi gouji xianxin giezho. ");
INSERT INTO sce_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","Tai dunda danlinraku shiqin kenjin khizhene, ingiekude caigie hhezighan shixinji giesan kunlai uzhezhi khizhene. ");
INSERT INTO sce_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","Ta hhantulakude ijiesanni Ezhanni heifande ulie sanane. ");
INSERT INTO sce_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","Ta ijiekude man qianlazhi xien ijiezho. Niezhan kunla ijiezhi chudu dazho, niezhan kunla ochi sudozho. ");
INSERT INTO sce_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","Tande ijiezhi ochiku gie uwonu? Pse ta Hudai jiohuii meilade uzhezhi yama witu kunlai shizheghanu? Bi tai matugie kieliene? Tai kuaimu? Intu shiqin jiere bi tai ulie kuaine! ");
INSERT INTO sce_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","Bi Ezhanse jienliesanni tande chonjizhi ogiwo. Ezhan Ersani ghudandusan hhe xii ginanni barei ");
INSERT INTO sce_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","mafan kieliedene ghulu kieliewo, \"Eneshi tande oluzhi ogisan mii beye wo. Ta mii jilazhi enei gie.\" ");
INSERT INTO sce_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","Ijie baludene qingiezhi beizii barei kieliewo, \"Ene beizishi mii chusunghala shini yenjisan kielien wo. Ta niefanie ochikude mii jilazhi enei gie.\" ");
INSERT INTO sce_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","Ta niefanie ene ginanyi ijiezhi ene beizii ochikude Ezhan iretula Ezhan duya ijiesan shiqinni kunlade man mejieghazho. ");
INSERT INTO sce_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","Ingiese yan kunliuzhe Ezhanni ginan, beizii lon ijiezhi ochise Ezhanni beye, chusunyi kuighazho. ");
INSERT INTO sce_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","Kun indan goyade zui winu uwo giezhi goyane goude sumuladene ene ginanyi ijie, ene beizii ochikuni wo. ");
INSERT INTO sce_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","Kun Ezhani beyeshi yan isi bikui ulie mejiedene ijiezhi ochise goyadene zui jinjizho. ");
INSERT INTO sce_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","Ene yenyin jiere tai dunda olon kunla zholierezhi gien kuwo, da fugusanye olon wo. ");
INSERT INTO sce_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","Matan goyalane goude jiencha giese ulie panjine. ");
INSERT INTO sce_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","Matanni panjikude Ezhan matanyi gonjizho, pse matanyi duyai kunlare hhantu zui jinjine. ");
INSERT INTO sce_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","Ingiese mii gaijiula, ta hhantulazhi ijiekude nieniene saghei. ");
INSERT INTO sce_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","Kien oliesuse xien giedene ijie, pse hhantulasanni man panjine. Psedu shiqinlani bi iredene nanpei gieye. ");
INSERT INTO sce_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","Gaijiula, Shenlin fanmienni shiqinni kieliese bi tande ulie mejieghaku duran uwo. ");
INSERT INTO sce_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","Taye mejiene, ta niman kun bikude tai miizhi kielien kielie daku nigiedalai hhende uduruzho. ");
INSERT INTO sce_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","Ingiese bi tande mejieghaye. Hudai Ruhher udurusan kunla Ersani kharakuni wo giezhi kiema ulie kieliene. Shenlin ulie uduruse Ersashi Ezhan wo giezhi kiema kielie dane. ");
INSERT INTO sce_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","Ogisan nenlila buxian woma, manshi nie Shenlin ogisan wo. ");
INSERT INTO sce_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","Ushilaku wiliela buxian woma, manshi nie Ezhande oluzhi giezho. ");
INSERT INTO sce_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","Zoinye buxian woma, manshi nie Huda soyuji kunlai tungo giezhi khizheghasan wo. ");
INSERT INTO sce_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","Shenlin jien kunlai jiere xienjighakushi dajialade haochu ireghane giezho. ");
INSERT INTO sce_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","Niezhan kunlade Shenlinyi tungo giezhi tebieji aghelitu kielienyi ogizho. Niezhan kunlade nie Shenlinyi tungo giezhi tebieji erlin kielieku nenli ogizho. ");
INSERT INTO sce_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","Niezhan kunlade nie Shenlinyi tungo giezhi xianxin gieku ogizho. Niezhan kunlade niekozi Shenlinyi tungo giezhi gien goudaghaku nenli ogizho. ");
INSERT INTO sce_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","Niezhan kunlade nenlitu shiqin gieku, niezhan kunlade Hudai kielienyi kielieku, niezhan kunlade ruhherlani fenjiku, niezhan kunlade psedu kielien kielieku, niezhan kunlade psedu kielienyi fanyi gieku nenli ogizho. ");
INSERT INTO sce_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","Enelashi man hhe niekozi Shenlin giesan wo, hhe goya isighalane buxiantu nenlini jien kunlade fenjizhi ogizho. ");
INSERT INTO sce_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","Niekozi beye jiere iyanzi olon wine, beyede iyanzi olonliuzhe beyeshi nie wo. Mexihaye niekielien wo. ");
INSERT INTO sce_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","Matan bugon Yutai kun, Xila kun, hoji danlasan, ziyutu kunliuzhe hhe niekozi Shenlinse xili jienliezhi nie beye gholudene niekozi Shenlinni xianshou giezho. ");
INSERT INTO sce_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","Beyeshi niekozi iyanzi pusho, olon iyanzi wo. ");
INSERT INTO sce_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","Kon kieliezhi bishi kha pusho, ingiese bi beyenughun pusho gieliuzhe beyenughun pusho bikui pusho. ");
INSERT INTO sce_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","Chighin kieliezhi bishi nudun pusho, ingiese bi beyenughun pusho gieliuzhe beyenughun pusho bikui pusho. ");
INSERT INTO sce_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","Beyede gon nudunshi matugie chenliene? Beyede gon chighinshi matugie funqiene? ");
INSERT INTO sce_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","Huda goya isighalane buxiantu iyanzii nienieji beye jiere teiwo. ");
INSERT INTO sce_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","Soyujila man niekozi iyanzishi matugie beye sanane? ");
INSERT INTO sce_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","Iyanzi olon woma, beye niekozi wo. ");
INSERT INTO sce_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","Nudun khade \"Bi chii ulie kerene.\" giezhi kielie dane. Qiorunye konde \"Bi chii ulie kerene.\" giezhi kielie dane. ");
INSERT INTO sce_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","Khareidene beye jieredu uzhese zholien wo giesan iyanzila chaizhi genjia ulie olune. ");
INSERT INTO sce_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","Matan sumulase beye jieredu zhunyo uwo giesan iyanzilai genjia zhunyoni gholughazhi uzhezhi bixinnilai genjia goude dabalaghazhoma, ");
INSERT INTO sce_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","hennilai qingiezhi gieku biyo uwo. Huda genjia fugie mienzii hhezighan bixin iyanzilade ogizhi beyeni nanpei giekushi ");
INSERT INTO sce_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","beyei iyanzilai ulie danlinraghazhi nieniei zhaogu gieghane giezho. ");
INSERT INTO sce_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","Nie iyanzi ku shouise man hhantu ku shouine. Nie iyanzide famani irese man hhantu bayasune. ");
INSERT INTO sce_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","Tashi Mexihani beye wo, jien kunshi beyeni iyanzi wo. ");
INSERT INTO sce_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","Huda jiohuide nanpei giesan ji 1 gieshi shitu, ji 2 gieshi xienzhi, ji 3 gieshi loushi wo, pse nenlitu shiqin gieku, gien goudaghaku nenli, banman gieku, gonjiku, yanyanji psedu kielien kielieku wo. ");
INSERT INTO sce_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","Manshi shitu onu? Manshi xienzhi onu? Manshi loushi onu? Man nenlitu shiqin gienu? ");
INSERT INTO sce_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","Jien kunlade gien goudaghaku nenli winu? Man psedu kielien kielie shidanu? Man psedu kielienyi fanyi gie shidanu? ");
INSERT INTO sce_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","Ta genjia fugie nenlii hende onxian gie. Bi zui gou moi tande uzheghaye. ");
INSERT INTO sce_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","Bi kunni buxiantu kielienyi kieliezhi qienxienyi kielienyi kielieliuzhe oreku wise tunguliesan laba, gu niekielien wo. ");
INSERT INTO sce_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","Made Hudai kielienyi kielieku nenli bizhi yanyanji chijia daoliji erlinni mejiezhi ulai noighaku fugie xianxin gieku biliuzhe oreku wise bi yama pusho. ");
INSERT INTO sce_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","Bi baerlane man nanxin kunde ogizhi beyene kunlade oluzhi tulieghaliuzhe oreku wise made yama haochu uwo. ");
INSERT INTO sce_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","Oreku izhi rennai giene, renyi wo, ulie dubiliene, goyane ulie kuaizhi zishi ulie shuaine, ");
INSERT INTO sce_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","limao witui ulie giene. Zi goyadene oluzhi ulie giene, suibiende ho ulie kuruzhi kunlai chouni ulie bareine. ");
INSERT INTO sce_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","Gou winide xiqi uwo, zhendaode xiqi wo. ");
INSERT INTO sce_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","Yandeliuzhe aghuide sumulane, soyujilai man xianxin giene, soyujilai man xiwon giene, soyujilai man rennai giene. ");
INSERT INTO sce_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","Hudai kielienyi kielieku, psedu kielienyi kielieku, erlin enela jianlai man baranema, oreku chanqi ulie barane. ");
INSERT INTO sce_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","Matan mejiesanshi ezighan wo, Hudai kielien kieliesanshi ezighan woma, ");
INSERT INTO sce_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","hulunni irese ezighanla man widane. ");
INSERT INTO sce_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","Bi ga shihoude kielieku, sumulaku, jiejin giekula man ga kunyi xianli, fugiedase ga kunnughunyi man widaghawo. ");
INSERT INTO sce_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","Matan ede belijide uzhesan mutun qinchude ese uzhezhoma, hhe xienzi kuse mienduimien uzhene. Bi ede mejiesanshi ezighan woma, hhe xienzi kuse Ezhan mii man mejiesan mutun bi man mejiene. ");
INSERT INTO sce_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","Xianxin gieku, xiwon gieku, oreku chan wine. Ene ghuron dundase orekushi zui fugieni wo. ");
INSERT INTO sce_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","Ta orekui dagha. Pse Shenlin ogisan nenli, tebieshi Hudai kielienyi kielieku nenlini hende onxian gie. ");
INSERT INTO sce_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","Psedu kielienyi kieliesanshi kunlade ese kieliezho, Hudade kieliezho. Kunla dunjire dane, hhe ruhherghalane yanyanji mimii kieliezho. ");
INSERT INTO sce_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","Hudai kielienyi kieliesanshi kunlade kieliezho. Kunlai hendaghazhi surughazhi sidaghazhi kieliezho. ");
INSERT INTO sce_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","Psedu kielienyi kieliesanshi goyane hendaghazho. Hudai kielienyi kieliesanshi jiohuini hendaghazho. ");
INSERT INTO sce_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","Ta man psedu kielienyi kieliekui bi xiwon giezhoma, Hudai kielienyi kieliekui genjia xiwon giezho. Psedu kielienyi kieliedene fanyi ulie giezhi jiohuini ese hendaghazhoshi Hudai kielienyi kieliesan kun hhense hen wo. ");
INSERT INTO sce_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","Gaijiula, bi tai hhende echidene zinie psedu kielienyi kieliezhi Huda mejieghasan, erlin, Hudai kielienyi kielieku, surughasanlai ulie injise tande yan haochu wo? ");
INSERT INTO sce_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","Shenqi khizhesan xiu, qin xianlitu dunxiliuzhe zhao hashuzhe ulie yose yan feiliezhi yan tanjisei kien mejiene? ");
INSERT INTO sce_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","Labai feilie londaghase kien eghindune giezhi zhunbei giene? ");
INSERT INTO sce_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","Taye niekielien wo. Amanghala dunjire daku kielienyi kieliese kieliesei kien mejiene? Enei goyadene kieliezho. ");
INSERT INTO sce_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","Duyade kielien kenjin olon woma, isi witui nieda uwo. ");
INSERT INTO sce_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","Kieliesan kielienyi isini bi dunjire dase hhe kieliechen kun uzhese bishi wigokun wo, bi uzhese hheshi wigokun wo. ");
INSERT INTO sce_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","Taye niekielien wo. Ta Shenlinni nenlii neiizhoma, jiohuini hendaghaku mutun jinlianji olon gie. ");
INSERT INTO sce_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","Ingiese psedu kielienyi kieliesanla indan fanyi gieku nenlini onxian gie. ");
INSERT INTO sce_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","Bi psedu kielienghala onxian giese mii ruhher onxian giezho, mii sumulaku yama zoin uwo. ");
INSERT INTO sce_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","Qingiese matugiene? Bi ruhherghala onxian giene, sumulakughalaye onxian giene. Bi ruhherghala doulane, sumulakughalaye doulane. ");
INSERT INTO sce_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","Ingiezhi ulie giese chi ruhherghala Hudade mafan kieliekude hhantulasan dunda mejie dasan kun chii kielienyi dunjire dase matugie amine giene? ");
INSERT INTO sce_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","Chi Hudade mafan kieliesan gou woma, kunlai hendagha dane. ");
INSERT INTO sce_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","Bi psedu kielienyi ta manlase olon kieliezho. Ingiese Hudade mafan kieliene. ");
INSERT INTO sce_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","Ingiezhoma, bi jiohuide psedu kielienyi 10000 aman kielietula tawun aman sumulakughala kunlade sughazhi kielieku duran wo. ");
INSERT INTO sce_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","Gaijiula, sumulaku jiere ga kun bu gholu. Doghun shiqin jiere yeliwa gholuzhi sumulaku jiere fugie kun gholu. ");
INSERT INTO sce_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","Jinwun jiere huaizho, Bi psedu kielienghala, niman kunlai amanghala ene bexinde kieliene, Ingieliuzhe hhela minughunyi ulie chenliene. Eneshi Ezhan kieliesan wo giezho. ");
INSERT INTO sce_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","Ingiese psedu kielienyi kieliese xianxin giesan kunlade hao ese giezho, xianxin ese giesan kunlade hao giezho. Hudai kielienyi kieliese xianxin giesan kunlade hao giezho, xianxin ese giesan kunlade hao ese giezho. ");
INSERT INTO sce_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","Ingiese jiohuide man hhantulakude dajiala man psedu kielienyi kieliese mejie dasan ibanji kun, xianxin ese giesan kunla iredene ta fenjiulizho giezhi ulie kielienu? ");
INSERT INTO sce_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","Dajiala Hudai kielienyi kieliese xianxin ese giesan kun, ibanji kunla orezhedene ene kielienghala goya zuine mejiezhi goyane kheilazhi ");
INSERT INTO sce_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","zhughedene niuighasanlai khizheghane. Ingie papala Hudai beiizhi Huda shuhuajia tai dunda wo giezhi chenren giene. ");
INSERT INTO sce_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","Gaijiula, qingiese matugiene? Ta hhantulakude jien kunde zeburei onshiku, surughaku, Huda uzheghasan, psedu kielien, fanyi gieku winema, enelai man kunlai hendaghaku mutun gie. ");
INSERT INTO sce_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","Psedu kielienghala kieliekude ghua kun, zui olon ghuran kun lunjizhi kielie. Niekozi kun fanyi gie. ");
INSERT INTO sce_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","Fanyi giechen kun uwoshi hhela jiohuide bu kielie. Goyadeneji Hudade kielie. ");
INSERT INTO sce_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","Hudai kielienyi deilazhi kieliekude ghua ghuran kun kielie. Psedu kunla chenliedene pandon gie. ");
INSERT INTO sce_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","Sousan kun dunda nie kunde Huda mejieghase Hudai kielienyi kieliesan kun xien bu kielie. ");
INSERT INTO sce_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","Ta man ingiezhi nienieji Hudai kielienyi kieliezhi dajialai surughazhi sidaghane. ");
INSERT INTO sce_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","Hudai kielienyi kieliechen kun goyane kunzhi giene. ");
INSERT INTO sce_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","Hudashi londaghachen pusho, heqishighachen wo. Shentulani jiohuilade man ingiezho. ");
INSERT INTO sce_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","Biereila jiohuide kielien bu kielie. Guijin jiere kieliesan mutun hhelai kielien ulie kielieghane, indan shunjikui wo. ");
INSERT INTO sce_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","Hhela yan surune giese giedene zhanguijidene asa, biereila jiohuide kielien kieliese shizheku shiqin wo. ");
INSERT INTO sce_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","Hudai kielien zinie tanse khizhesan onu? Jianie tande ogizhou? ");
INSERT INTO sce_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","Kien goyane xienzhi wo, Shenlinghala hhantu wo giese bi huaisanlashi Ezhanni minlin bikui mejiene. ");
INSERT INTO sce_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","Kien enei chenren ulie giese ta hhei chenren bu gie. ");
INSERT INTO sce_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","Ingiese mii gaijiula, ta Hudai kielienyi kieliekui neii. Psedu kielienyi kieliese bu danla. ");
INSERT INTO sce_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","Ta yan giese nanpeilasan mutun heshide gie. ");
INSERT INTO sce_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","Gaijiula, bi eqighandei tande chonjisan gouxioxii jila ireghaye. Enei ta jienliedene beizhi undanlazho. ");
INSERT INTO sce_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","Bi tande chonjisanni ta belien xianxin ese giedene goude bareizhoshi enei tungo giezhi tai jiuine. ");
INSERT INTO sce_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","Bi eqighandei jienliesan zui zhunyo daolini tande chonjizhi ogiwo. Jiushi jinwun jiere kieliesan mutun Mexiha mai zuide oluzhi duya ijiewo, ");
INSERT INTO sce_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","bulawo, pse jinwun jiere kieliesan mutun ghurudude aminne oluwo, ");
INSERT INTO sce_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","ingie Jifade, pse 12 gie shitulade chujiegheghawo. ");
INSERT INTO sce_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","Khuinashi 500 gie gaijiulade hhantu chujiegheghawo. Hhela dunda niezhanla fuguzho, dabufen ede wine. ");
INSERT INTO sce_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","Khuinashi Yagebude, pse soyuji shitulade chujiegheghawo. ");
INSERT INTO sce_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","Zuihou, shihoude ese olusan mutun zui bixintu madeye chujiegheghawo. ");
INSERT INTO sce_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","Bi shitu dundase zui gani wo. Eqighandei Hudai jiohuii heizho, mii shitu giezhi uruse pei dane. ");
INSERT INTO sce_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","Ingieliuzhe ede bi imutui gholuse Hudai nenjien wo. Hhe made ogisan nenjien zoin witui pusho, bi psedu shitulase olon xiacha giezhi wilie giezho. Eneshi bi pusho, Hudai nenjien bighala hhantu wo. ");
INSERT INTO sce_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","Ingiese biye hao, psedu shitulaye hao, bijien man ingiezhi chonjizho. Taye ingiezhi xianxin giezho. ");
INSERT INTO sce_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","\"Mexiha fugusan kun dundase aminne oluwo.\" giezhi chonjizhoma, tai dunda matugie, \"Intu shiqin uwo.\" giezho? ");
INSERT INTO sce_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","Fugusan kun aminne oluku shiqin uwoshi Mexihaye aminne ese oluzho. ");
INSERT INTO sce_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","Mexiha aminne ese oluzhoshi bijien chonjisan yama oronde uwo, ta xianxin giesanye yama oronde uwo. ");
INSERT INTO sce_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","Zinie ene pusho, bijien lien Hudade oluzhi jia ganzhen beichen danlazho. Ingiekushi bijien ganzhen beizhi Huda Mexihai aminne olughawo giezho. Fugusan kun aminne oluku shiqin uwoshi Hudaye Mexihai aminne ese olughazho. ");
INSERT INTO sce_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","Fugusan kun aminne ulie oluse Mexihaye aminne ese oluzho. ");
INSERT INTO sce_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","Mexiha aminne ese oluzhoshi ta xianxin giesan yama oronde uwo, dou zui dunda wo, ");
INSERT INTO sce_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","Mexihani xianxin giedene duya ijiesanlaye widawo. ");
INSERT INTO sce_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","Matan Mexihai miende jianie duyade xiwon giezhoshi soyuji kun dunda zui ubali wo. ");
INSERT INTO sce_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","Ingiezhoma, Mexiha zhenzhenji fugusan kun dundase aminne oluzhi fugusan kun dundadu toushu gholuwo. ");
INSERT INTO sce_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","Fuguku nie kunse irezho, fugusan kun aminne olukuye da nie kunse irezho. ");
INSERT INTO sce_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","Adanyi miende man fugusan mutun Mexihai miende man aminne olune. ");
INSERT INTO sce_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","Jien kun aminne olukui nanpeilasan mutun giene. Xien toushu Mexiha wo, pse hhe irekude hhenughunla wo. ");
INSERT INTO sce_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","Ingiedene duya barane. Hhe shihoude Mexiha duyade gonjisan, qienli bareisan, nenli bitulai man widaghasenu qienlini Adadene jiuine. ");
INSERT INTO sce_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","Huda Mexihare duitou danlasanlai man hhei kon doura teitula hhe bixi honshan danlane. ");
INSERT INTO sce_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","Zuihou widaghaku duitoushi fuguku wo. ");
INSERT INTO sce_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","Huda soyujilai hhei kon doura shunjighawo giezhi jinwun jiere kieliezhoma, man hhei shunjighazho giese manlai shunjighasan kenjin hhezighanlai sudoro uwo. ");
INSERT INTO sce_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","Man hhei shunjikude kewon goyaneye manlai shunjighasan hhende shunjine, ingiedene Huda manlai gonjizhi manlai jiere wo. ");
INSERT INTO sce_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","Aminne oluku shiqin uwoshi hhezighan kunla fugusan kunde oluzhi xili jienliezhi yan giezho? Fugusan kun zhenzhenji aminne ulie oluse kunla yangiezhi hhelade oluzhi xili jienliezho? ");
INSERT INTO sce_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","Pse yangiezhi bijien niechanie wixiennide echine? ");
INSERT INTO sce_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","Gaijiula, made niudunie fugukui penjizho. Eneshi shuhua wo, bi mai Ezhan Mexiha Ersai miende tai kuaiku mutun zhenni wo. ");
INSERT INTO sce_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","Bi kunni isighala yewore eghinduku mutun Ifuso kunlare eghinduse made yan zoin wo? Fugusan kun aminne ulie oluse, kunla kieliesan mutun \"Matan ijie ochiye, maghashijie fugune.\" giene. ");
INSERT INTO sce_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","Ta shandan bu gie, \"Doghun zhanlien gou kunni qida olughane.\" ");
INSERT INTO sce_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","Ta xiereizhi goude sumula, zui pse bu gie. Niezhan kunla Hudai tani dase bi tai shizheghane giezhi ingiezhi kieliewo. ");
INSERT INTO sce_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","Kunla, \"Fugusan kun matugie aminne olune? Yan beyeghala irene.\" giezhi asane. ");
INSERT INTO sce_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","Yama ulie mejiechen kunlaya, tareisan ulie fuguse osizhi ulie khizhene. ");
INSERT INTO sce_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","Tareisanshi jianlaiku beye pusho, zinie boudei onu, pseshiku fure wo. ");
INSERT INTO sce_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","Huda goya isighalane furede beye ogine, buxiantu furede buxiantu beye ogine. ");
INSERT INTO sce_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","Beyelashi man buxiantu beye wo. Kunde 1 zhun beye wo, yewode 1 zhun beye wo, bunzhude 1 zhun beye wo, zhaghasunde 1 izhun beye wo. ");
INSERT INTO sce_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","Asiman jieredulade 1 zhun beye wo, zemin jieredulade 1 zhun beye wo. Asimanni beyeshi 1 zhun fama wo, zeminni beyeshi 1 zhun fama wo. ");
INSERT INTO sce_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","Naran narande 1 zhun fama wo, sara sarade 1 zhun fama wo, hodun hodunde 1 zhun fama wo, ene hodun hhe hodunghalai famai buxian wo. ");
INSERT INTO sce_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","Fugusan kun aminne oluseye ingiezho. Tareisanshi qida olukuni wo, aminne olusanshi ulie qida olukuni wo. ");
INSERT INTO sce_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","Tareisanshi bixinni wo, aminne olusanshi famani wo. Tareisanshi zholienni wo, aminne olusanshi liliantui wo. ");
INSERT INTO sce_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","Tareisanshi duyani beye wo, aminne olusanshi ruhhertu beye wo. Duyani beye bise ruhhertu beyeye wine. ");
INSERT INTO sce_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","Ji 1 gie kun Adan amitui gholuwo giezhi jinwun jiere huaizhoma, zuihouku Adan amin ogiku ruhher gholuwo. ");
INSERT INTO sce_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","Ingiezhoma, ruhhernughun melie uwo, duyanughun melie wo, khuinashi ruhhernughun wo. ");
INSERT INTO sce_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","Ji 1 gie kun zeminse irezho, turanughun wo, ji 2 gie kun asimanse irezho. ");
INSERT INTO sce_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","Turanughunlashi turase iresan hhei xianli. Asimanughunlashi asimanse iresan hhei xianli. ");
INSERT INTO sce_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","Matande turanughunyi yanzi wineku mutun jianlai asimannughunyi yanzi wine. ");
INSERT INTO sce_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","Gaijiula, bi tande kieliekushi beye Hudai gojiai jienlie dane. Qida oluku ulie qida olukui jienlie dane. ");
INSERT INTO sce_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","Chenliendu, bi tande nie chijia shiqin kielieye. Matan man fugukui pusho, man bienjine. ");
INSERT INTO sce_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","Menzhali nie nudun hameikude zuihouku laba tunguliese fugusan kunla aminne oluzhi ulie qida olune, matanye bienjine. ");
INSERT INTO sce_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","Ene qida oluku beye bixi ulie qida olukui gholune, fuguku beye bixi ulie fugukui gholune. ");
INSERT INTO sce_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","Ene qida oluku ulie qida olukui gholuzhi fuguku ulie fugukui gholukude fugukui injiku yenji boughawo giezhi jinwun jiere jilasan kielien mutun gholune. ");
INSERT INTO sce_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","\"Fugukuya, chii injiku khala wo? Fugukuya, chii soyen khala wo?\" ");
INSERT INTO sce_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","Fugukui soyenshi zui wo, zuini lilianshi guijin wo. ");
INSERT INTO sce_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","Hudade mafan kielieye, hhe mai ezhan Ersa Mexihai tungo giezhi matanyi injighazho. ");
INSERT INTO sce_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","Ingiese mii gaijiula, ta khiduzhezhi bu gojiolu, chan xiacha giezhi Ezhanni wiliei olon gie. Ta khishulasanla Ezhanyi miende oronde wiku pusho bikui ta mejiene. ");
INSERT INTO sce_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","Shentulade baer khighakui kieliese bi Jialataini jiohuilade fenfulasan mutun taye qingiezhi gie. ");
INSERT INTO sce_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","Niefanie xinqide jien kunla goya hashughalane agizhi khizhedene ghura, pse bi irekude ta cai khireighane. ");
INSERT INTO sce_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","Bi irekudeni ta chenren giesan kunlade xinni deilazhi hhelai tai murei ughuzhi Yelusalende khughozhi echighaye. ");
INSERT INTO sce_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","Bi echise heshi bise hhela mare hhantu echise olune. ");
INSERT INTO sce_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","Bi Maqidunse daone giezho, daokudeni tai uzhele ireye. ");
INSERT INTO sce_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","Kenen bi tanre nietan soune, kenen unchai daoghane. Ingiedene bi khala echise ta mii khughose olune. ");
INSERT INTO sce_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7"