﻿USE sofia;
DROP TABLE IF EXISTS sofia.sby_vpl;
CREATE TABLE sby_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sby_vpl WRITE;
INSERT INTO sby_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Uwu e mulongo wa bamashali bakulukulu ba Yesu, mushukulu wa Dafeti, uyo walikuba mushukulu wa Abulahamu. ");
INSERT INTO sby_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abulahamu walasema Isake, nendi Isake walasema Yakobo, Nendi Yakobo walasema Yuda ne bakwabo, ");
INSERT INTO sby_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda walasema Pelesi ne Sela muli Tamala, Pelesi walasema Hesiloni, Nendi Hesiloni walasema Lamu, ");
INSERT INTO sby_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lamu walasema Aminadabu, nendi Aminadabu walasema Nasoni, nendi Nasoni walasema Salumoni, ");
INSERT INTO sby_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salumoni walasema Bowasi muli Lahabi, nendi Bowasi walasema Obedi muli Lute, nendi Obedi walasema Jesi, ");
INSERT INTO sby_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi walasema Mwami Dafeti, nendi Dafeti walasema Solomoni mu mukashi walikuba wa Uliya. ");
INSERT INTO sby_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomoni walasema Lehabyamu, nendi Lehabyamu walasema Abiya, nendi Abiya walasema Asa, ");
INSERT INTO sby_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","nendi Asa walasema Yehosafati, nendi Yehosafati walasema Yolamu, nendi Yolamu walasema Usiya, ");
INSERT INTO sby_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiya walasema Yotamu, Nendi Yotamu walasema Ahazi, Nendi Ahazi walasema Hezekiya, ");
INSERT INTO sby_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","nendi Hezekiya walasema Manase, nendi Manase walasema Amoni, nendi Amoni walasema Yosiya, ");
INSERT INTO sby_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiya walasema Yekoniya ne bakwabo pacindi bana Baisilayeli mpobalikumantwa busha ku Babulo. ");
INSERT INTO sby_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Baisilayeli mpobalamantwa busha ku Babulo, Yekoniya walasema Salatiyele nendi Salatiyele walasema Zelubabele, ");
INSERT INTO sby_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","nendi Zelubabele walasema Abiyudi, Abiyudi walasema Eliyakimu nendi Eliyakimu walasema Asolo, ");
INSERT INTO sby_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asolo walasema Sadoki, nendi Sadoki walasema Akimu, nendi Akimu walasema Eliyudi, ");
INSERT INTO sby_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Nendi Eliyudi walasema Eliyasala, nendi Eliyasala walasema Matani, Matani walasema Yakobo, ");
INSERT INTO sby_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Nendi Yakobo walasema Yosefe ibendi Maliya, uyu Maliya e walasema Yesu lakwiwangeti Klistu Mupulushi Walaiwa usa. ");
INSERT INTO sby_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Neco, kufuma pali Abulahamu kushika pali Mwami Dafeti, palikuba misemano likumi ne ina, kayi kufuma pali Mwami Dafeti kushika pacindi bana ba Isilayeli mpobalamantwa busha kuya ku Babulo, napo palikuba misemano likumi ne ina, kayi kufuma pacindi ca kumantwa busha ku Babulo kushika pacindi ca Klistu, napo palikuba misemano likumi ne ina. ");
INSERT INTO sby_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Lino kusemwa kwa Yesu Klistu kwalenshika munshila iyi. Pacindi Maliya banyina Yesu mpobalikuba bamamikilwa kuli Yosefe. Nomba kabatana baya kumalili, Maliya walacanika ne libunda kupitila mu ngofu ya Mushimu Uswepa. ");
INSERT INTO sby_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yosefe walikuba muntu walulama, nkalayanda kumusebanya pantangalala, walayeya kupwisha bubambo bwa cikwati kwakubula kwishiba bantu. ");
INSERT INTO sby_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kaciyeya cakwinsa mungelo wa Mwami Lesa walamubonekela muciloto ne kumwambileti, “Yosefe mwanendi Dafeti kotatina kumumanta Maliya kuba mukashobe, ili libunda ndyakute ni ngofu ya Mushimu Uswepa. ");
INSERT INTO sby_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nakatumbuke mwana mutuloba uyo ngoshi mukatumbe lina eti Yesu, pakwinga nakapulushe bantu bakendi ku bwipishi bwabo.” ");
INSERT INTO sby_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ibi byalenshika kwalikuba kukwanilisha ncalamba Mwami kumushinshimi kwambeti ");
INSERT INTO sby_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mulindu nakabe ne libunda ne kutumbuka mwana mutuloba uyo eti akakwiweti Emanuele, uku ekwambeti ‘Lesa uli nenjafwe’ ” ");
INSERT INTO sby_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yosefe mpwalapunduka walensa ncalamwambila mungelo wa Mwami Lesa, walamumanta Maliya kuba mukashendi. ");
INSERT INTO sby_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nomba nikukabeco uliya kuya nendi kumalili sobwe mpaka panyuma pakutumbuka mwana mutuloba. Yosefe walamupa Lina eti Yesu. ");
INSERT INTO sby_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu walasemenwa mu munshi wa Betelehemu mucimpansha ca Yudeya pacindi Helode mpwalikuba mwami mu cishico. Ku Yelusalemu kwalesa bantu baiya shakwenda kwa nyenyenshi balafumina kucishi ca kucwe. ");
INSERT INTO sby_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Mpobalashika ku Yelusalemu balikabepusheti “Inga mwana ngotwanyumfweti eshakabe Mwami wa Bayuda wasemenwa kupeyo? Afwe twalubona lunyenyenshi lwatuleshanga nkwabele kalupula kucwe, neco tulesa kumukambilila.” ");
INSERT INTO sby_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mwami Helode ne bantu bangi balikwikala mu Yelusalemu mpobalanyufweco, balapenga mumyoyo. ");
INSERT INTO sby_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Neco, Helode walabunganya mwabwangu bwangu, beshimilumbo bamakulene ne beshikwiyisha Milawo ya Mose ne kubepusheti, “Anu Mupulushi Walaiwa ne Lesa nakasemenwe kupeyo ayi?” ");
INSERT INTO sby_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Balo balambeti, “Nakasemenwe mumunshi wa Betelehemu wa kucishi ca Yudeya, pakwinga tucinsheti Mabala a Lesa alambangeti,” ");
INSERT INTO sby_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Obe Betelehemu wa mucishi ca Yudeya, ntobe munshi ung'ana sobwe pakati pa minshi naimbi ya Bayuda. Pakwinga mutangunishi eshakembele Baisilayeli bantu ba Lesa nakakafumine kuli njobe.” ");
INSERT INTO sby_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Mpwalanyumfweco Helode, walabakwila pambali bantu abo kwakubula bantu nabambi kwinshiba, ne kubepushisha cindi ncobalabona lunyenyenshi ulo. ");
INSERT INTO sby_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Neco Helode walabambileti, “Kamuyani ku Betelehemu mwenga mu mulangaule cenacena mwana uyo, mwakamucana, mukese kuno mukanjishibishe kumusena nkwabele, kwambeti nenjame nkenga kumukambilila.” ");
INSERT INTO sby_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Panyuma pakwambilwa maswi alico ne mwami, balanyamuka. Lunyenyenshi lusa ndobalabona kucwe, lwalabatangunina ne kuya kwimana mwilu pamusena palikuba mwanoyo. ");
INSERT INTO sby_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Mpobalabona lunyenyenshi lusa balakondwa kwine. ");
INSERT INTO sby_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Popelapo balengila mu ng'anda, balabona mwanoyo kali ne Maliya banyina, balasuntama ne kumukambilila. Balasungulula bifunta ne kupulisha bipo bya golide, lubani ne mafuta anunkila a mule ne kupa mwana. ");
INSERT INTO sby_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nomba Lesa walabacenjesha aba bantu bayiya kwenda kwa nyenyenshi muciloto kwambeti kabatabwelela kuli Helode. Neco mpobali kubwelela ku cishi cabo, balapitila nshila imbi. ");
INSERT INTO sby_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Mpobalafumako, mungelo wa Mwami walabonekela kuli Yosefe muciloto, ne kumwambileti, “Nyamuka, manta mwana ne banyina, ufwambile ku Injipto, uye wikale kopeloko mpaka cindi ncoti nkakwambile, pakwinga Helode nalangaulenga mwana uyu kwambeti amushine.” ");
INSERT INTO sby_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Popelapo Yosefe walanyamuka mashiku ne kumanta mwana ne banyina kuya ku Injipto. ");
INSERT INTO sby_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Walakekalako mpaka mpwalafwa Helode. Ici calenshika kwambeti ncalamba Mwami kupitila mumushinshimi cikwanilishiwe cakwambeti, “Ninkakuwe mwaname kufuma mu Injipto.” ");
INSERT INTO sby_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Helode mpwaleshibeti, basa bantu baiya kwenda kwa nyenyenshi bamubona buluya walakalala, walatuma bantu ku Betelehemu, ne kuminshi yonse ya bambana, kwambeti benga bashine bana batuloba bonse kutatikila pali bakute byaka bibili kwisa panshi. Byaka ibi, balabelengela kufuma pacindi ncalanyumfwa kuli bantu basa baiya kwenda kwa nyenyenshi. ");
INSERT INTO sby_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Mbyalamba mushinshimi Yelemiya byalakwanilishiwa bya kwambeti, ");
INSERT INTO sby_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Mibila ilanyumfwikinga mu Lama, yakulila ne kompolola, Lakelo, lalilinga banabendi, lakananga kumumwenesha pacebo ca banabendi balafu.” ");
INSERT INTO sby_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pacindi Helode usa mpwalafwa, mungelo wa Mwami walamubonekela Yosefe muciloto kali ku Injipto. ");
INSERT INTO sby_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Walamwambileti, “Nyamuka, manta mwana ne banyina, ubwelele ku Islayeli, pakwinga bonse balikuyanda kushina mwana bafwa.” ");
INSERT INTO sby_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yosefe walapunduka ne kumanta mwana ne banyina ne kubwelela ku Islayeli. ");
INSERT INTO sby_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nomba mpwalanyumfwa kwambeti, Alikelawo, mwanendi Helode, ewapyana baishi kuba mwami waku Yudeya, walatina kuyako. Neco kayi Lesa walamucenjesha Yosefe muciloto, walaya mucimpansha ca Galileya. ");
INSERT INTO sby_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Balakekala mu munshi wa Nasaleti, kwambeti ncalamba mushinshimi cikwanilishiwe, cakwambeti, “Nakakwiweti, Munasaleti.” ");
INSERT INTO sby_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mu masubayo walesa Yohane Mubatishi kakambauka mu cinyika caku Yudeya, ");
INSERT INTO sby_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","kambeti, “Shiyani bwipishi pakwinga Lesa ulipepi kwikalika Bwami bwakendi.” ");
INSERT INTO sby_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Uyu engwalikwamba Mushinshimi Yesaya mpwalambeti, “Liswi lya muntu labilikishinga mucinyika kambeti, ‘Bambani mukwakwa wa kupitamo Mwami,’ ‘Lulamikani nshila njoti akapitemo.’” ");
INSERT INTO sby_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohane walikufwala mwinjila wabweya bwa Ngamila, ne mukopo wacipaya mubukome. Cakulya cakendi calikuba bikobo ne bwiki bwamucisuwa. ");
INSERT INTO sby_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Bantu balafumina mu Yelusalemu ne mu Yudeya kayi ne mubibela byonse bilipepi ne mulonga wa Yolodani, balikwisa kuli Yohane. ");
INSERT INTO sby_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Abo balikulyambilila bwipishi bwabo, balabatishiwa mu mulonga wa Yolodani. ");
INSERT INTO sby_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yohane mpwalabona Bayuda bangi bamulikoto lya Bafalisi, ne Basaduki kabayanda kubatishiwa, nendi Yohane walabambileti, “Bana banjoka amwe, niyani sena walamucenjesheti mufwambe kutina bukalu bwa Lesa bulesanga? ");
INSERT INTO sby_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Neco kamwinsani bintu bilaleshengeti mwashiya bwipishi bwenu. ");
INSERT INTO sby_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kamutalibepanga mu myoyo yenu kwambeti, ngamucifwamba cisubulo ca Lesa pakwambeti mushali wetu ni Abulahamu. Cakubinga ndamwambilishingeti Lesa ingawasandula awa mabwe kuba banabendi Abulahamu. ");
INSERT INTO sby_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Pacino cindi kembe kalibambila kutimbula citondo pamiyanda, neco citondo ciliconse cilabulunga kusema bisepo byaina, nibakacitimbule ne kuciwala mumulilo.” ");
INSERT INTO sby_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ame ndamubatishinga ne menshi kuba cilesho ca kushiya bwipishi bwenu, nomba panyuma pakame palesanga uyo eshakamubatishenga ne Mushimu Uswepa ne mulilo. Nendi wampita ngofu, cakwinseti nkandelela ne kunyamuna nkwabilo shakendi sobwe. ");
INSERT INTO sby_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Cakupupulushila cilikendi mu makasa akendi, kwambeti atatike kupupulusha. Nakabike maila apupulushiwa cena mu lyanga, nomba bungu nakabutente pamulilo utapu.” ");
INSERT INTO sby_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Pacindico, Yesu walesa kuli Yohane ku mulonga wa Yolodani, kufuma ku Galileya kwambeti Yohane enga mubatishe. ");
INSERT INTO sby_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yohane pakwelekesha kukana walambeti, “Nte njame ndelela kubatishiwa nenjamwe, nomba amwe kayi mulesanga kuli njame?” ");
INSERT INTO sby_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nomba Yesu walamukumbuleti, “Obe kosuminowa, pakwinga emotwelela kwinshila bintu byonse byabululami mbyalayandanga Lesa.” Neco Yohane walasumina. ");
INSERT INTO sby_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesu mpwalabatishiwa, walasabuka mu menshi. Popelapo kwilu kwalacaluka, walabona Mushimu wa Lesa kauseluka mbuli nkulimba nekwisa kwikala palyendiye, ");
INSERT INTO sby_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","kwilu kwalanyumfwika Liswi lyakwambeti, “Uyu e Mwaname ngondayandishisha, ndakondwa nendi.” ");
INSERT INTO sby_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Calakonkapo, Mushimu Uswepa walamutwala Yesu ku cinyika kuya kwelekeshewa ne Muyungaushi. ");
INSERT INTO sby_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kwa masuba makumi ana, munshi ne mashiku,Yesu walikulikanisha kulya, neco walanyumfwa nsala. ");
INSERT INTO sby_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Muyungaushi walesa kulyendiye walambeti, “Na njamwe Mwanendi Lesa, ambilani mabwe awa asanduke abe shinkwa.” ");
INSERT INTO sby_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nomba Yesu walambeti, “Kwalembweti muntu nkelela kuba ne buyumi ne shinkwa enka sobwe, nsombi ne Maswi onse ngalambanga Lesa.” ");
INSERT INTO sby_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Panyuma pakendi, Muyungaushi walamutwala Yesu ku Yelusalemu, mushi waswepa, ne kumutantika pelu pa Ng'anda ya Lesa, ");
INSERT INTO sby_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ne kumwambileti, “Na cakubinga njobe Mwanendi Lesa, kolilasha panshi, pakwinga kwalembweti, “Lesa nambile bangelo bese bakubake kwambeti, myendo yakobe kaitapunta pamabwe.” ");
INSERT INTO sby_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Nendi Yesu walambeti, “Kwalembweti, ‘Kotamwelekeshanga Nkambo Lesa wakobe.’ ” ");
INSERT INTO sby_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pakupwililisha, Muyungaushi walamumanta Yesu ne kuya kumutantika pa mulundu utali, ne kumulesha bwendeleshi bonse bwa pacishi capanshi ne bulemu bwabo. ");
INSERT INTO sby_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Satana walambeti, “Byonse ibi nindikupe na usuntaminekowa, ne kunkambilila.” ");
INSERT INTO sby_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Apa lino Yesu walambeti, “Fumapa, Satana! Mabala alambangeti, ‘Welela kukambilila Nkambo Lesa wakobe, ne kumusebensela enka.’” ");
INSERT INTO sby_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Popelapo Muyungaushi walamushiya Yesu. Neco bangelo balesa kumunyamfwilisha Yesu. ");
INSERT INTO sby_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Lino Yesu mpwalanyumfweti, Yohane lasungwa mu jele, walaya ku Galileya, ");
INSERT INTO sby_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","walaleka kwikala ku Nasaleti, walaya kwikala ku Kapelenawo, munshi walikuba mumbali mwa lwenje lwa Galileya, mucibela ca Sebuloni ne Nafitali. ");
INSERT INTO sby_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ici calenshika, kukwanilisha calambwa kupitila mushinshimi Yesaya, uyo walambeti, ");
INSERT INTO sby_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Obe cimpansha ca Sebuloni, nenjobe cishi ca Nafitali, kunshila yaku lwenje, patala pa Yolodani, obe Galileya, cimpansha ca bantu babula kuba Bayuda! ");
INSERT INTO sby_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bantu bekala mu mushinshe ni bakabone mumuni unene. Bantu bekala mucishi ca mufunsha wa lufu, mumuni ulababonekele.” ");
INSERT INTO sby_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kufuma cindi copeleco, Yesu walatatika kukambauka kambeti, “Shiyani bwipishi bwenu, pakwinga Lesa ulipepi kwikalika Bwami bwakendi.” ");
INSERT INTO sby_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu mpwalikwenda mu mbali mwa lwenje lwa Galileya, walabona bantu babili pabukwabo, Shimoni walikukwiweti Petulo, ne Ndileya mukwabo, kabekata inswi mulwenje ne tombe twabo, pakwinga balikuba basulishi banswi. ");
INSERT INTO sby_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu walabambileti, “Nkonkeleni, ndimwiyishe kuba basulishi ba bantu.” ");
INSERT INTO sby_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Popelapo balashiya tombe twabo ne kuya nendi. ");
INSERT INTO sby_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Mpwalendako pang'ana walabona nabambi babili pabukwabo Jemusi ne Yohane, banabendi Sebedayo balikuba mu bwato pamo ne mushali wabo kababamba tombe twabo. Yesu walabakuwa. ");
INSERT INTO sby_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Popelapo balashiya bwato ne baishi nekuya neYesu. ");
INSERT INTO sby_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu walendana mucimpansha conse ca Galileya, kaya kwiyisha mu manda akupaililamo ne kukambauka Mulumbe Waina ulambanga sha Bwami, nekusengula bantu balikukute malwashi apusana pusana ne bulema bwapusanapusana. ");
INSERT INTO sby_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Mpuwo yakendi yalamwaikila mucishi conse ca Siliya, cakwinseti bantu balikabaleta balwashi bonse balikupenga ne malwashi ne bishikubaba byapusana pusana, ne bekatwa ne mishimu yaipa ne balwashi atushita kayi ne balema. bonse walikubasengula. ");
INSERT INTO sby_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Bantu bangi balikumukonkela kufuma ku Galileya, kucibela calikukwiweti Minshi Likumi, ne kuYelusalemu, neku Yudeya, kayi ne mucibela cakutala kwa mulonga wa Yolodani. ");
INSERT INTO sby_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu mpwalabona likoto linene lya bantu balikumukonkela, walatanta pa mulundu ne kwikala panshi pamo ne beshikwiya bakendi, ");
INSERT INTO sby_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","walatatika kubeyisha kambeti, ");
INSERT INTO sby_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Bakute colwe abo bacinka manungo pali Lesa, pakwinga Bwami bwa kwilu ni bwabo. ");
INSERT INTO sby_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","bakute colwe, bantu balalilinga, pakwinga Lesa nakabaumbulushe. ");
INSERT INTO sby_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","bakute colwe, bantu balicepesha, pakwinga nibakatambule ico Lesa ncalabalaya. ");
INSERT INTO sby_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","bakute colwe, bantu balanyumfunga nsala ne nyotwa ya kwinsa cilayandanga Lesa, pakwinga nibakekutishiwe. ");
INSERT INTO sby_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","bakute colwe bantu bakute nkumbo kubanabo, pakwinga Lesa nakabanyumfwile nkumbo. ");
INSERT INTO sby_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","bakute colwe, bantu baswepa myoyo, pakwinga nibakabone Lesa. ");
INSERT INTO sby_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","bakute colwe bantu balaletenga lumuno, pakwinga nibakakwiweti bana ba Lesa. ");
INSERT INTO sby_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Bakute colwe bantu balapenshewanga, pacebo cakwinsa calulama, pakwinga Bwami bwa kwilu nibwabo. ");
INSERT INTO sby_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Mwalelekwa, omulatukanwanga, kupenshewa, ne kumubepesha bintu bingi bbyaipa pacebo cakwambeti munkonkelenga. ");
INSERT INTO sby_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kamusamwani, kayi kamukondwani, pakwinga cilambo cenu kwilu nicinene. Naboyo bashinshimi, amwe kamutana musemwa, balabapenshewa munshila yopeleyo.” ");
INSERT INTO sby_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Amwe mulyeti mucele wa bantu bonse pacishi capanshi, nomba na mucele usambuluka, nicani celela kubweshulula mbuli ncowanga? Ulabulu ncito, nikutayowa pansa kaulyataulwa ne bantu. ");
INSERT INTO sby_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Amwe mulyeti mumuni wishikumunikila bantu bonse mucishi. Munshi webakwa pa mulundu nkawelela kubula kubonekela. ");
INSERT INTO sby_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Paliya muntu ukute kubangilisha lampi nekwifwekelela munongo, nsombi bakute kubika pacakubikapo lampi, kwambeti umunikile bantu bonse bali mung'andomo, ");
INSERT INTO sby_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Cimo cimo nenjamwe munikani pamenso abantu, kwambeti babona ncito shenu shaina, bakatembaule Bameshenu ba kwilu. ");
INSERT INTO sby_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Kamutayeyeti ndesakupwisha Milawo ya Mose, ne biyisho bya bashinshimi. Ame ndiyakwisa kwipwisha sobwe, nsombi kwisa kwikwanilisha. ");
INSERT INTO sby_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Cakubinga ndamwambilishingeti kwilu necishi capanshi kabitanabipwa, paliya libala nilikaba ling'aneconi lya Mulawo lyeshi likafumemo, mpaka byonse bikakwanilishiwe. ");
INSERT INTO sby_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Neco muntu labulunga kukonka mulawo umo uli mumilawo iyi, nambi kauli ung'aneconi, ne kwiyishako nabambi kwambeti naboyo babule kukonka, nakabe mung'ana mu Bwami bwa kwilu. Nomba muntu uliyense lakonkonga Milawo, ne kwiyishako nabambi kwambeti naboyo baikonke, nakabe mukulene mu Bwami bwa kwilu. ");
INSERT INTO sby_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Encondamwambililingeti, na bululami bwenu nkabwapita bululami bwa beshikwiyisha milawo ya Mose ne Bafalisi, nteti mukengilemo mu Bwami bwa kwilu pimbi. ");
INSERT INTO sby_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mwalanyumfwa kwambeti, kaindi bantu balambilweti ‘Kotashina, uliyense lashini munendi welela komboloshewa ku nkuta.’ ");
INSERT INTO sby_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nsombi lino ame ndamwambilingeti, muntu uliyense lakalalilinga mukwabo welela kupewa mulandu ku nkuta, Uliyense lambilinga munendi eti, ‘Omuluya’ Welela komboloshewa ku Nkuta. Nomba uliyense lambilinga munendi eti, ‘Cishilu’ Nendi welela kuyamu mulilo wa Gehena. ");
INSERT INTO sby_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Neco na ulesa necipo cakobe cakubenga kuli Lesa pa nteme, kayi wanuka kwambeti, munobe ukute mulandu nenjobe, ");
INSERT INTO sby_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","koshiya cipo cakobeco pambali pa nteme, koya unyumfwane mulumuno ne munobe, wenseco bwela ubenge cipo cakobe kuli Lesa panteme. ");
INSERT INTO sby_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Kamufwambananga kunyumfwana ne muntu ngolepishili kamutana mushika ku nkuta. Kutineti ingaukutwala ku momboloshi, nendi momboloshi, ingaukubika mu makasa a mushilikali uyo welela kukuwala mu jele. ");
INSERT INTO sby_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Cakubinga ndakwambilishinga, nukekale mujele mpaka ukapwishe kulipila mwelo wamali a mulandu.” ");
INSERT INTO sby_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mwalanyumfwa kwambeti kaindi bantu balambilweti, ‘Kotapombola.’ ");
INSERT INTO sby_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nomba lino ame ndamwambilingeti muntu uliyense lamulangishishinga mutukashi cakumukumbwa, lamupombolo kendi mumoyo wakendi. ");
INSERT INTO sby_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Na linso lyakobe lilakwipishinga, ulikolobolemo ulitaye. Caina kutayako lubasu lumo lwa mubili wakobe, kupita kuba ne mubili wakwana ne kuwalwa mu Gehena. ");
INSERT INTO sby_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kayi na cikasa cakobe cakululyo cilakwipishinga, ucitimbule ucitaye. Caina kutayako lubasu lumo lwamubili wakobe, kupita kuba ne mubili wakwana ne kuwalwa mu Gehena. ");
INSERT INTO sby_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Kayi kaindi balambilweti, ‘Na muntu uleka mukashendi, amulembele ne kumupa cipepala cabushike.’ ");
INSERT INTO sby_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nomba ame lino ndamwambilingeti, uliyense lalekenga mukashendi pacebo cimbi cabula kuba cabupombo, uyo mukashi ebwa kumutuloba naumbi lenshi bupombo, nendi mutuloba uyo lamwebe ukute mulandu wabupombo. ");
INSERT INTO sby_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kayi mwalamfweti, kaindi bantu balambilweti, ‘Kotaumbila cabwepeshi, nsombi cinse ncowalalumbila kuli Lesa.’ ");
INSERT INTO sby_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nomba ame ndamwambilingeti, lekani kulumbila sobwe. Kamutalumbilangeti, kwilu kwine nditu! pakwinga kwilu ekuli cipuna ca Mwami Lesa, ");
INSERT INTO sby_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kamutalumbilangeti, pacishi capanshi nditu! pakwinga pacishi capanshi epakulyata myendo yakendi Lesa. kayi kamutalumbilangeti ‘Pali Yelusalemu nditu!’ Pakwinga Yelusalemu ni munshi wa Mwami mukulene. ");
INSERT INTO sby_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kamutalumbilangeti, ‘Mutwi wakame nditu,’ Pakwinga nkamwelela kusandula mishishi kuba ituba nambi ishipa. ");
INSERT INTO sby_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kamwambangoweti, ‘Ee’ Nambi ‘ne.’ Cakusankanyapo pali ibi cilafumunga kuli Waipa usa.” ");
INSERT INTO sby_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Mwalanyumfweti kaindi bantu balambilweti, Linso kubenga linso, lino kubenga lino. ");
INSERT INTO sby_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nomba ame lino ndamwambilingeti “Kamutabweshelanga caipa kumuntu lamwipishili sobwe. Na muntu ukuma kulicili lya kululyo, akume kayi kulicili lya kucipiko. ");
INSERT INTO sby_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Na muntu ukupa mulandu, ne kukukakatisheti umupe mwinjila wakobe, muleke amantile kumo ne munganjo. ");
INSERT INTO sby_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Muntu uliyense amukakatisha kwenda nendi mushinso wakilomita imo, wende nendi mushinso wamakilomita abili. ");
INSERT INTO sby_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Muntu amusenga cintu mupeni. Kayi muntu ayandanga kubweleka cintu kulinjobe kotamukanina.” ");
INSERT INTO sby_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Mwalanyumfweti kaindi bantu balambilweti, Kosuna munobe, mupele mulwani wakobe. ");
INSERT INTO sby_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nomba ame lino ndamwambilingeti, basuneni balwani benu ne kubapaililako kuli Lesa abo balamupenshenga. ");
INSERT INTO sby_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mwenseco, emposhimubele limo bana ba Bameshenu balikwilu, bakute kuleta lumwi pa bantu baipa ne baina. Kayi bakute kulokela mfula pa bantu baina ne baipa. ");
INSERT INTO sby_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Na kamusunakowa bantu bamusuni, ngamutambulapo cilambo cini kuli Lesa? Beshimisonko nabo nte ncobakute kwinsa copeleco? ");
INSERT INTO sby_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kayi nakamupa mitende banse benu bonka, mulenshipo cani capita nabambi? Sena bantu batamwinshi Lesa nkabakute kwinsa copeleco? ");
INSERT INTO sby_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kamubani babula kampenda, mbuli Bameshenu bakwilu ncobabula kampenda. ");
INSERT INTO sby_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Kamutaliboneshanga kwinsa ncito shaina pamenso abantu kwambeti bamubone, mwenseco, nteti mukatambulepo cilambo kuli Bameshenu balikwilu. ");
INSERT INTO sby_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Neco mwapanga cintu ciliconse kumuntu laciyandanga, kamutaliboneshanga mbuli mobakute kwinshila bantu bandemishibili basa mumanda akupaililamo, ne munshila sha muminshi, balo bakute kwinseco kwambeti bantu bababone ne kubalumbaisha. Nditu ndamwambilishingeti abo balatambulililimo cilambo cabo. ");
INSERT INTO sby_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nomba obe wanyamfwanga bapenshi, munobe ngoli nendi pepi kabatenshiba sobwe. ");
INSERT INTO sby_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Wenseco, bipo byankumbo byakobe nukabinshibe wenka. Lino Baiso bakute kubona byasolekwa nibakakupe cilambo.” ");
INSERT INTO sby_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Mwapailanga kamutensanga mbuli bandemi shibili basa ncobakute kwinsa, balo bakute kuyanda kupaila kabali bemana mumanda akupaililamo, ne pamampambano anshila kwambeti bantu bababone. Cakubinga balo balatambulili limo cilambo ");
INSERT INTO sby_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nomba obe wayandanga kupaila, ingila mucimpetela, cala cisasa, upaile kuli Baiso bataboneke, Baiso bakute kubona byasolekwa nibakakupe cilambo. ");
INSERT INTO sby_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Pacindi ncomulapailinga, kamutambanga maswi amo amo, mbuli ncobakute kwinsa bantu batamwinshi Lesa. Balo bakute kuyeyeti bafulishanga byakwamba empwelela kubanyumfwa Lesa. ");
INSERT INTO sby_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nomba amwe kamutabangeti endibo, pakwinga Bameshenu babinshi mbyomwabula, kamutana mubasenga. ");
INSERT INTO sby_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ecebo cakendi amwe pakupaila kamwambangeti, Bameshetu omuli kwilu, lina lyenu lilemekwe, ");
INSERT INTO sby_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Bwami bwenu bwise, Kuyanda kwenu kwinshike. Panshi pano mbuli ncekubele kwilu, ");
INSERT INTO sby_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Mutupe lelo cakulya cetu ca masuba onse. ");
INSERT INTO sby_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Mutulekeleleko bwipishi bwetu, mbuli nenjafwe ncotukute kubalekelelako bakute kutwipishila, ");
INSERT INTO sby_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kamutasuminisha kwambeti tuwile mukweleshewa, Nsombi tukwabilileni kuli Waipa usa. “Pakwinga Bwami ne ngofu kayi ne bulemeneno ni bwenu kwamuyayaya. Ameni ");
INSERT INTO sby_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Cakubinga na mulekelela bantu bwipishi bwabo, Bameshenu ba kwilu nabo nibakamulekelele. ");
INSERT INTO sby_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nomba na nkamulekelele bantu bwipishi bwabo, nabo Bameshenu nteti bakamulekelele bwipishi bwenu sobwe.” ");
INSERT INTO sby_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Mwalikanishanga kulya, kamutabonekanga kungumana pamenso. mbuli ncobakute kwinsa bandemi shibili basa, balo bakute kwipisha pamenso kwambeti bantu bababoneti balikanishinga kulya. Cakubinga, balatambulililimo cilambo cabo. ");
INSERT INTO sby_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nomba obe walikanishanga kulya, samba kumenso, ne kusakula cena mishishi ku mutwi, ");
INSERT INTO sby_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","kwambeti bantu kabatenshibeti ulalikanishinga kulya, nsombi Baiso bataboneke ebelela kwinshiba bonka. Abo Baiso bakute kubona byasolekwa mbyolenshi nibakakupe cilambo.” ");
INSERT INTO sby_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Kamutalibunjikila buboni pacishi capanshi pano, apo mpobukute kubumbwa muswa, nambi kuba ne ndala, kayi nabo bakabwalala, mpobakute kwingila ne kwiba. ");
INSERT INTO sby_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Neco kamubunganyani buboni bwenu kwilu, uko kwabula muswa nambi ndala, uko kabwalala nkwela kwalilwa kwingila ne kuyakwiba. ");
INSERT INTO sby_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Pakwinga kowabika buboni bwakobe, moyo wakobe ukute kauli kopeloko.” ");
INSERT INTO sby_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Menso elampi ya mubili na menso kalicena, mubili wakobe wonse ukute kauli wakwana kumunikilwa. ");
INSERT INTO sby_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nomba na menso akobe nkalipo cena, na mumuni mulinjobe usanduka kuba mushinshe. Lino akute aba citatiko ca mushinshe washipa mbii!” ");
INSERT INTO sby_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Muntu nkela kusebensela bantu babili pacindi cimo, pakwinga ngaupelapo umo, ne kusunako naumbi, nakashomeke kuli umo, ne kusampula naumbi. Nkamwelela kusebensela Lesa, ne buboni pacindi cimo.” ");
INSERT INTO sby_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ecebo cakendi ndamwambilingeti kamutayakamwanga ne buyumi bwenu, kwambeti nitukalye cani, nambi nitukanwe cani? Nambi nitukafwale cani, sena buyumi bwenu nkabwapita cakulya? Nambi mubili nkawapita byakufwala? ");
INSERT INTO sby_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kamubonani bikeni, nkabikute kubyala mbuto, nambi kutebula ne kubika mulyanga sobwe, nomba Bameshenu bakwilu bakute kubilyesha. Sena amwe nkamwayandika kupita bikeni? ");
INSERT INTO sby_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Niyani mulinjamwe wayakamwa ne buyumi, wela kucikonsha kunungako busuba bumowa ku buyumi bwakendi?” ");
INSERT INTO sby_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Inga mukute kushilacani mano ku byakufwala? Bonani maluba amucisuwa mwakute kukulila, nkakute kusebensa, nambi kulyanina bikwisa sobwe. ");
INSERT INTO sby_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nomba ndamwambilinga mwami Solomoni, nambi walikuba mubile, uliyawa kufwalapo byakufwala byabekema mbuli maluba. ");
INSERT INTO sby_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Lino na Lesa kacikonsha kufwalika mila yamucisuwa, iyo ikute kubakowa lelo, lilo nikwitenta mulilo, Lesa ngaubula kumufwalika sena akaka! Mobalushomo lung'anamwe!” ");
INSERT INTO sby_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Ecebo cakendi kamutayakamwanga ne kwambeti, ‘Inga lelo nindicicane kupeyo cakulya’ Nambi ‘cakunwa’ Nambi ‘cakufwala? ");
INSERT INTO sby_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ibi nibintu mbyobakute kuyakamwa bantu batamwinshi Lesa. Amwe Bameshenu ba kwilu bacinshi kwambeti nenjamwe mulabiyandanga bintu ibi. ");
INSERT INTO sby_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nomba amwe nanshi mulangaule Bwami bwa Lesa, ne bululami bwakendi, nabimbi ibi Lesa nakamubikilepo. ");
INSERT INTO sby_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Neco nkabayakamwa ne byalilo, byalilo nibyalilo. Busuba bulibonse bukute makatasho abo.” ");
INSERT INTO sby_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Kamutomboloshanga banenu, kwambeti nenjamwe Lesa akabule kumombolosha. ");
INSERT INTO sby_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Momukute komboloshela banenu, mopelomo nenjamwe Lesa mweti akamomboloshele. Kayi mwelo ngomukute kusebenshesha pakombolosha, mwelo wopelowo nukasebensheshewe pali njamwe. ");
INSERT INTO sby_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mukute kuboneconi kantu kang'ana kali mulinso mwamunobe, kotayeye omwine cishiki cili mulinso lyakobe? ");
INSERT INTO sby_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ngaumwambileconi munobeti, ‘Tubone ndikufunye kantu mulinso,’ Kakuli obe mulinso mwakobe muli cishiki? ");
INSERT INTO sby_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Obe wandemi shibili! nanshi tatika kufunya cishiki ico cili mu linso lyakobe, empowelela kubona cena ne kukafunyamo kantu kali mulinso lyamunobe. ");
INSERT INTO sby_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Kamutapa bakabwa bintu bya Lesa, pakwinga ingabamubwelela ne kwisa kumuluma. Nambi kuwalila nkumba mikanda yamalungu, pakwinga nishikalwataulowa.” ");
INSERT INTO sby_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Senga nakamupe, langaula nimukacane, kukonkosha nibakamucalwile cisasa. ");
INSERT INTO sby_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ee, muntu lasengenga winga kupewa, muntu lalangaulunga winga kucicana, kayi muntu lakonkoshonga bakute kumucalwila cisasa. ");
INSERT INTO sby_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Niyani pakati penu amwe bamashali welela kupa libwe mwanendi lasenge shinkwa? ");
INSERT INTO sby_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nambi usenga lunswi, ngamumupa njoka sena? ");
INSERT INTO sby_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Lino amwe ne kwipa kwenuku, mucinshi kupa banabenu bintu byaina, kulyeconi kuli Bameshenu bakwilu, sena ngabalilwa kupa bintu byaina kuli balamusengenga? ");
INSERT INTO sby_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Neco, mubintu bili byonse mbyomulayandangeti bantu bamwinshile, mwelela nanshi amwe kubenshila byopelebyo. Pakwinga uku ekukwanilisha milawo ya Mose, ne biyisho bya bashinshimi. ");
INSERT INTO sby_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Kamwingililani mwakulipakatisha pacishinga cing'ana. Pakwinga cishinga cilatwalanga ku lufu ni cinene, ne nshila yatandabala ne bantu balapitingamonga nibagi. ");
INSERT INTO sby_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nomba cishinga cakuya kwingila kubuyumi nica kulipakatisha, ne nshila yakendi yayuma kwendamo, nabo balendengamonga nibang'ana. ");
INSERT INTO sby_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Kamucenjelani ne bashinshimi bandemi shibili. Bakute besanga kulinjamwe kababoneka babomba myoyo eti mbelele. Nomba mukati balyeti baumpe bansala. ");
INSERT INTO sby_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nimukabeshibile ku bisepo byabo. Sena bitondo bya myunga ngabisema minyansa? Sena ingamucana nkuyu ku kankolong'onso? ");
INSERT INTO sby_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Citondo caina cikute kusema bisepo byaina, nomba citondo caipa cikute kusema bisepo byaipa. ");
INSERT INTO sby_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Citondo caina nkacelela kusema bisepo byaipa sobwe, nambi citondo caipa kusema bisepo byaina nkacinshiki pimbi. ");
INSERT INTO sby_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Citondo ciliconse citaseme bisepo byaina bakute kucitimbula ne kuciwala pa mulilo. ");
INSERT INTO sby_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Neco, bantu nimukabeshibile kuncito shabo. ");
INSERT INTO sby_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Nteye muntu lambangoweti, ‘Nkambo, Nkambo,’ Eti akengile mu Bwami bwa kwilu sobwe, nsombi uyo lenshinga ncobalayandanga Bata ba kwilu. ");
INSERT INTO sby_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Pabusuba bwakomboloshewa bantu bangi nibakambengeti, ‘Nkambo, Nkambo!’ Sena afwe ntetwali kukambauka mu lina lyenu? Twalikucikonsha kupulisha mishimu yaipa pakusebenshesha lina lyenu, mu lina lyenu kayi twalikwinsa bishikukankamanisha. ");
INSERT INTO sby_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nomba ame ninkabambile pamensotuba kwambeti, ‘nkandimwishipo sobwe, fumani apa!’ Mobeshi kwinsa byaipa.” ");
INSERT INTO sby_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Uliyense lanyumfunga ne kwakonkela maswi akame, welana ndendende ne muntu wamano uyo walebaka ng'anda yakendi palibwe lyacandanshi. ");
INSERT INTO sby_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kwalaloka mfula, milonga yalesula, lukupwe lwangofu lwalauma kung'anda, nomba ng'anda iliya kuwa sobwe, pakwinga walaibaka palibwe lyacandanshi.” ");
INSERT INTO sby_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Nomba uliyense lanyumfunga maswi akame, nsombi kabula kwakonkela, welana ndendende, ne muntu wapunama uyo walebaka ng'anda yakendi pa museya. ");
INSERT INTO sby_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kwalaloka mfula, milonga yalesula, lukupwe lwangofu lwalauma kung'anda, ng'anda yalawa, nomba kuwa kwa ng'andeyo kwalikuba kunene kuyosha.” ");
INSERT INTO sby_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu mpwalapwisha kwamba makani awa, bantu bangi balakankamana ne njiyishilo yakendi. ");
INSERT INTO sby_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Pakwinga nkalikubeti beshikwiyisha milawo ya Mose, nsombi nendi walikwiyisha ne ngofu. ");
INSERT INTO sby_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu mpwalaseluka pa mulundu pasa, bantu bangi balamukonkela. ");
INSERT INTO sby_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Lino muntu walikukute bulwashi bwa mankuntu, walesakusuntama ne kwambeti, “Nkambo, nakamuyanda ngamunswepesha” ");
INSERT INTO sby_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu walatandabula cikasa cakendi ne kumukumya, ne kwambeti, “Ee, ndayandanga, ‘Swepa!’ Popelapo walabacena.” ");
INSERT INTO sby_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kufumapo Yesu walamwambileti, “Nyumfwa, kotambilako nabambi sobwe, obe koya uliboneshe kuli shimilumbo, utwale mulumbo usa ngwalamba Mose, kwambeti bantu baboneti ulaba cena.” ");
INSERT INTO sby_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Mpwalashika Yesu mu munshi wa Kapelenawo, mushilikali mukulene wabashilikali mwanda, walesa kusenga lunyamfwo. ");
INSERT INTO sby_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Walasengeti, “Nkambo, musebenshi wakame wona kung'anda nimulwashi, nkelela kucikonsha kwenda, lakolwanga.” ");
INSERT INTO sby_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu walamwambileti, “Ndesanga kumusengula.” ");
INSERT INTO sby_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nomba mushilikali usa walambeti, “Sobwe Nkambo, ame nkandelela kwambeti amwe mwenga kuyakwingila mung'anda yakame, kamwambani maswi onka, musebenshi wakame nabe cena. ");
INSERT INTO sby_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","“Pali bamakulene mbonkute kunyumfwila, nomba nenjame nkute bashilikali bakute kunyumfwila. Na ndambili mushilikali, ‘Koya’ Cakubinga ukute kuya. Na ndambili naumbi eti ‘Kwesa kuno’ Cakubinga ukute kwisa, na ndambili musha wakameti, ‘kwensa ici cakubinga ukute kucinsa.’ ” ");
INSERT INTO sby_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Lino Yesu mpwalanyumfweco walakankamana, walambila bantu basa balikumukonkeleti, “Kwamba cakubinga, nambi pakati pa Baislayeli paliya kucanikapo lushomo lulicisa. ");
INSERT INTO sby_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Cakubinga ndamwambilishingeti bantu bangi nibakafumine kucwe, ne kumbonshi, kwisakwikala pamo ne Abulahamu ne Isake kayi ne Yakobo pa malyalya amu Bwami bwakwilu. ");
INSERT INTO sby_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nomba abo banga belela kuba mu Bwami ubo, nibakataiwe kunsa mumushinshe. Kopeloko nibakalile ne kukokota meno abo, cebo cakubabwa.” ");
INSERT INTO sby_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Popelapo Yesu walambila mukulene wabashilikali, “Kamuyani kung'anda, cinshike kwelana ne lushomo ndokute.” Pacindi copeleco musebenshi wakendi walaba cena. ");
INSERT INTO sby_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu mpwalengila mu ng'anda ya Petulo, walabona kumakwendi batukashi kabali bona, kabakolwa cimpwita. ");
INSERT INTO sby_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Walabekata kucikasa popelapo cimpwita calapwa. Kumakwendi Petulo balapunduka, ne kutatika kubambila Yesu cakulya. ");
INSERT INTO sby_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mansailo, pabusuba bopelobo, bantu balaleta balwashi bangi bekatwa ne mishimu yaipa, Yesu walikupulisha mishimu ne maswi onka, kayi balwashi bonse walikubasengula. ");
INSERT INTO sby_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Byonsebi walabinsa kwambeti, mbyalamba mushinshimi Yesaya bikwanilishiwe, byakwambeti, “Nendi walamanta bishikubaba ne malwashi etu.” ");
INSERT INTO sby_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu mpwalabona likoto lyabantu balikuba bamushinguluka, walambila beshikwiya bakendi, “Katutampukilani kutala kwa lwenje kusa.” ");
INSERT INTO sby_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nomba pacindi copeleco palashika umo wabeshikwiyisha milawo ya Mose walambila Yesu eti, “Bashikwiyisha, ame ndayandanga kuba shikwiya wenu kayi nindimukonkelenga kulikonse nkomulenga.” ");
INSERT INTO sby_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu walamukumbuleti, “Bamwaba bakute bilingo, nabyo bikeni bikute bisangala byakwikalamo. Nomba ame nde Mwana Muntu ndiya musena wakona nepumwininapo.” ");
INSERT INTO sby_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nomba shikwiya naumbi walambila Yesu, eti, “Nkambo, nsuminisheni mbwelele nanshi embike bata.” ");
INSERT INTO sby_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Neye Yesu walamwambileti, “Obe nkonkele. Kobaleka bafwa babikenga bantu babo bafwa.” ");
INSERT INTO sby_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu pamo ne beshikwiya bakendi balatanta bwato nekuya. ");
INSERT INTO sby_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mwacimfundumukila kwalesa lukupwe luyosha pa lwenje, mankape alatatika kwingila mu bwatomo, nomba Yesu walikali wonatulo. ");
INSERT INTO sby_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kacili wona, beshikwiya balayakumunyukumuna ne kwambeti, “Nkambo, tupulusheni, tulipepi kufwa!” ");
INSERT INTO sby_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu walabakumbuleti, “Mulatininga cani amwe mobantu mukute lushomo lung'ana?” Mpwalambeco walemana ne kulucancilila lukupwe ne mankape, popelapo pa lwenje palamwena tonto. ");
INSERT INTO sby_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Beshikwiya basa balakankamana ne kwambeti, “Inga uyu ni muntu ulyeconi cakwinseti lukupwe ne mankape byonse bilamunyumfwilinga?” ");
INSERT INTO sby_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu mpwalashika kutala kwa lwenje, mu cibela ca Gadala, walakumanya bantu babili bekatwa ne mishimu yaipa kabafuma kunamaumbwe. Balikuba bakalu, cakwinseti paliya muntu naba umo walikupita nshila iyo. ");
INSERT INTO sby_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Pacindi copeleco balatatika kolobesheti, “Mulayandanga cani amwe Mwanendi Lesa? Sena mulesa kuno kwisa kutupensha cindi kacitanacishika?” ");
INSERT INTO sby_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nomba palikuba litanga linene lya nkumba shalikulya pepi napo mpobalikuba. ");
INSERT INTO sby_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Mishimu yaipa yalamupapatila Yesu, ne kwambeti, “Mwatupulisha, mutusuminishe twenga kwingila mulitanga lya nkumba shisa shilipasa.” ");
INSERT INTO sby_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu walayambileti, “Ee, kamuyani,” Nayo yalapula ne kuya kwingila munkumba shisa. Popelapo likoto lya nkumba lyalafwambalubilo kuselemukila kumukolo kwa mulundu ne kuyakuwila mulwenje, moshalakafwila shonse. ");
INSERT INTO sby_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Abo balikwembela nkumba balafwamba, balashika kumunshi, nekwambila bantu bintu byonse byalenshika kubantu basa babili balikuba bekatwa ne mishimu yaipa. ");
INSERT INTO sby_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Popelapo bantu bonse mumunshi balapula kuya kukumana ne Yesu. mpobalamucana balamusenga kwambeti afume mucibela ico. ");
INSERT INTO sby_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu walatanta mu bwato ne kutampuka lwenje, kuya kumunshi nkwalikwikala. ");
INSERT INTO sby_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kopeloko bantu nabambi balamuletela mulema watontola myendo kabali bamoneka pampasa. pakubona lushomo lwabo, Yesu walambila mulema uyo “Yumisha moyo omwanobe! bwipishi bwakobe bulalekelelwa.” ");
INSERT INTO sby_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Mpwalenseco beshikwiyisha milawo ya Mose nabambi, balatatika kumufwiya mumyoyo yabo ne kwambeti, “Uyu muntu lanyanshanga Lesa!” ");
INSERT INTO sby_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nomba Yesu pakwishiba miyeyo yabo walambeti, “Mukute kuyeyela cani bintu byaipa mumyoyo yenu? ");
INSERT INTO sby_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Capubako nicipeyo kwambeti, ‘Bwipishi bwakobe bulalekelelwa’ Nambi kwambeti, ‘nyamuka wende.’ ");
INSERT INTO sby_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nomba ndayandanga kwambeti mwinshibeti, Mwana Muntu ukute ngofu shakulekelela bwipishi pacishi capanshi pano.” Neco walambila mulema watontola myenda uyu, “Nyamuka manta mpasa yakobe, koya kwenu.” ");
INSERT INTO sby_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Popelapo muntu usa walanyamuka ne kuya kumunshi kwabo. ");
INSERT INTO sby_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Bantu basa mpobalaboneco, balekatwa buyowa, ne kulumbanya Lesa walapa bantu ngofu shabwendeleshi shilicisa. ");
INSERT INTO sby_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu mpwalikufumako walabona muntu walikukwiweti, Mateyo kaliwekala mukanda ka misonko, walamwambileti, “Nenjobe, nkonke.” Pacindi copeleco Mateyo walanyamuka ne kumukonkela. ");
INSERT INTO sby_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesu mpwalikulya mu ng'anda ya Mateyo. Kwalesa beshimisonko bangi, ne beshi kwinsa byaipa, balesa kulya nendi pamo ne beshikwiya bakendi. ");
INSERT INTO sby_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mpobalaboneco Bafalisi, balatatika kubepusha beshikwiya bakendi Yesu eti, “Inga bashikwiyisha benu balalingeconi pamo ne beshimisonko, ne beshi kwinsa byaipa?” ");
INSERT INTO sby_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nendi Yesu pakunyumfweco, walabakumbuleti, “Bantu balabulunga kukolwa nkabakute kuyanda mu ng'anga sobwe, nsombi balwashi ebakute kuyanda mung'anda.” ");
INSERT INTO sby_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","“Nomba kamwiyani cilambanga maswi awa, alambangeti, ‘Nkandayandangeti bantu bampe milumbo sobwe, nsombi ndayandangeti bantu beenshilenga nkumbo kubanabo.’ Pakwinga nkandaleshila kukuwa bantu balulama sobwe, nsombi beshikwinsa byaipa.” ");
INSERT INTO sby_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Panyuma pakendi beshikwiya ba Yohane mubatishi, balesa kuli Yesu ne kumwipusheti, “Afwe, ne Bafalisi tukute kulikanisha kulya tunkanda twingi, nomba nicani beshikwiya benu nkabakute kulikanishapo?” ");
INSERT INTO sby_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nendi Yesu walambeti, “Sena banendi shibwinga ngabalyetesha bacibanga pamo ne shibwinga? Ico nkacinshiki sobwe! Nomba nicikashike cindi ncotibakamufulepo shibwinga usa, popelapo nibakatatike kulikanisha kulya. ");
INSERT INTO sby_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Muntu nkakute kumamika cikamba ca cikwisa ca lino lino ne kucitungila pa mwinjila ukulukulu, pakwinga cikamba ca cikwisa ca lino lino ngacikokonyana nekumatula uwo mwinjila ukulukulu, ne kumatuka kulico kukute kushiya cibwanko. ");
INSERT INTO sby_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kayi paliya muntu ukute kubika waini mucifwafumwa cacipaya cakaindi sobwe, pakwinga nawinseco, cifwafumwa cacipaya ngacipasuka, waini ngautaika, nasho nkomwa ngashibula ncito. Waini walino lino bakute kubika munkomwa sha lino lino. Neco byonse bibili bikute kubambwa cena.” ");
INSERT INTO sby_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu kacamba, kwalesa mukulene wa Bayuda walesa kumusuntamina ne kwambeti, “Mwaname mutukashi ulipepi kufwa, ndapapata kamwisani mubike makasa enu palyendiye, kwambeti abe muyumi.” ");
INSERT INTO sby_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Popelapo Yesu ne beshikwiya bakendi balanyamuka ne kuya nendi. ");
INSERT INTO sby_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Lino palikuba mutukashi walikukolwa bulwashi bwa mukunko kwa byaka likumi ne bibili, walesa cakunyuma kwa Yesu, ne kwisa kwikata kucelele kwa munganjo wa Yesu, ");
INSERT INTO sby_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","mumoyo mwakendi walikayeyeti, “Na njikatekowa munganjo wakendi ni nsengulwe.” ");
INSERT INTO sby_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu popelapo walacebuka ne kumubona mutukashi uyo, Yesu walambeti, “Yumisha moyo mwaname, lushomo lwakobe lulakupulushu.” Pacindi copeleco mutukashi usa walasengulwa. ");
INSERT INTO sby_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu mpwalashika ku ng'anda kwa mukulene wa Bayuda usa, walacana bantu kabalilisha mikonkobesho nebisekele, nabambi kabalyuma pacali kulila mibila. ");
INSERT INTO sby_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Lino nendi Yesu walabambileti, “Kamupulani mwense, kashimbi uyu uliya kufwa sobwe, nsombi wonowatulo.” Popelapo bangi balatatika kumuseka. ");
INSERT INTO sby_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nomba bonse mpobalapulamo mu ng'anda,Yesu walaya kucimpetela nkwalikuba ne kuyakwikata kashimbi uyu pacikasa, popelapo walapunduka. ");
INSERT INTO sby_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Impuwo iyi yalanyumfwika mucibela ca cishico. ");
INSERT INTO sby_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Mpwalikufumako, bantu bashipilwa babili balamukonkela nekutatika kubilikisheti, “Amwe Yesu mwanendi Dafeti, tunyumfwilekoni nkumbo!” ");
INSERT INTO sby_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu mpwalengila mung'anda bashipilwa babili basa balesa kulyendiye. nendi walabepusheti, “Sena mwashometi ngandimusengula?” Naboyo balakumbuleti, “Ee twashoma Nkambo.” ");
INSERT INTO sby_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yesu walabekata mumenso, ne kwambeti, “Cinshike kwelana ne lushomo lwenu.” ");
INSERT INTO sby_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Popelapo menso abo alacaluka, balacikonsha kubona. Nomba Yesu walabambilisheti kabataya bambileko muntu naba umo sobwe. ");
INSERT INTO sby_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nomba kufumapo balo balatatika kumwaya mpuwo kumuntu uliyense mucibela ico. ");
INSERT INTO sby_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mpobalapula mung'anda nekutatika kuya, bantu nabambi balaleta muntu walikuba cibulu, cebo cakwikatwa ne mushimu waipa. ");
INSERT INTO sby_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesu mpwalaufunya mushimu waipa usa, muntusa walacikonsha kwamba. Nomba bantu balakankamana cakwinseti balatatika kwambeti, “Nkatuna tucibonapo cintu camushoboyu mu Islayeli!” ");
INSERT INTO sby_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nomba nabo Bafalisi balambeti, “Lamupanga ngofu shakufunya mishimu yaipa ni mukulene wa mishimu yaipa.” ");
INSERT INTO sby_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu walendana mu minshi inene, ne ing'ana ing'ana, walikwiyisha mu misena yabo yakupaililamo, ne kukambauka Mulumbe Waina wa Bwami bwa Lesa, Kayi walasengula bulema bwapusanapusana ne malwashi apusana pusana. ");
INSERT INTO sby_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesu mpwalabona makoto a bantu, walanyumfwa luse, pakwinga balikuba bantu balemenwa kayi batyompwa kubeti mbelele shabula mwembeshi. ");
INSERT INTO sby_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yesu walambila beshikwiya bakendi eti, “Butebushi bulafulu, nomba basebenshi balacepe. ");
INSERT INTO sby_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Neco, kamusengani Lesa mwine butebushi kwambeti atume basebenshi bangi kuya kutebula.” ");
INSERT INTO sby_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu walakuwa beshikwiya bakendi likumi ne babili, walabapa ngofu sha kupulisha mishimu yaipa, kayi ne ngofu shakusengula bulema apusanapusana ne malwashi apusanapusana. ");
INSERT INTO sby_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Maina abatumwa basa likumi ne babili, ni Shimoni, walikukwiweti, Petulo ne Ndileya mukwabo, ne Jemusi mwanendi Sebedayo, ne Yohane mukwabo, ");
INSERT INTO sby_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ne Filipo, ne Batolomeyo, ne Tomasi ne Mateyo, walikusonkesha misonko, ne Jemusi mwanendi Alufeyo, ne Tadeyo, ");
INSERT INTO sby_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ne Shimoni wa mucipani ca bantu balikulwanina lwanguluko mu cishi ca Islayeli, kayi ne Yuda Sikalyote, uyo walamulisha Yesu kubalwani. ");
INSERT INTO sby_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Aba bantu bali likumi ne babili, Yesu walabatuma ne kubapa malailile akwambeti, “Kamutaya kubantu babula kuba Bayuda sobwe, nambi kuya kwingila mu munshi uliwonse wa bene Samaliya sobwe. ");
INSERT INTO sby_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nomba amwe kamuyani kuli Baislayeli abo balyeti mbelele shataika. ");
INSERT INTO sby_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kamuyani, mukambaukengeti, Lesa ulipepi kwikalika bwami bwakendi. ");
INSERT INTO sby_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Sengulani balwashi, kupundusha bafwa, kusengula mankuntu, ne kupulisha mishimu yaipa. Mulatambulu kwabulyo, ne njamwe kamupani kwabulyo. ");
INSERT INTO sby_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kamutamanta mali mumpotomona shenu, golide nambi silifa, nambi mali amukuba. ");
INSERT INTO sby_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kamutamanta cipokolo ca pabulwendo, nambi kumanta minjila ibili, nambi nkwabilo, nambi nkoli. Basebenshi bela kutambula bintu mbyobabula. ");
INSERT INTO sby_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Mwengila mu munshi uliwonse, mulangaule muntu layandishishinga kumutambula, amutambula ikalani ku ng'anda kopeloko mpaka cishika cindi cakufumamo. ");
INSERT INTO sby_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pakwingila mu ng'anda mwambengeti, ‘lumuno lube ne njamwe.’ ");
INSERT INTO sby_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Lino bamutambula calushinisho bene ng'anda, lumuno lwenu lube nabo nditu, nomba na bene ng'anda balakana kumutambula, lumuno lwenu lubwelele kulinjamwe. ");
INSERT INTO sby_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Muntu uliyense akana kumutambula, nambi kunyumfwa maswi ngomukute, pampamunani lusuko lwakumyendo kwenu mwafumanga mung'andomo nambi mumunshi umo. ");
INSERT INTO sby_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Cakubinga ndamwambilishingeti, pabusuba bwalombolosho, nicikabeko capuba kubantu baku Sodomu, ne Gomola, kupita bantu ba mumunshi uwo. ");
INSERT INTO sby_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Kamunyumfwani! Ndamutumunga mbuli mbelele pakati pa baumpe, neco kamubani bacenjela mbuli njoka, nomba kayi babomba myoyo mbuli nkulimba. ");
INSERT INTO sby_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mucenjele nabo bantu, pakwinga nibakamwikate ne bakamutwale kunkuta, ne kumukwapula bikoti mu manda abo akupaililamo. ");
INSERT INTO sby_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nibakamutwale ku bamanduna, ne kubami, pacebo canjame, cakwinseti ni mukambeleko bakamboni pamenso pabo, ne pamenso abantu bamishobo naimbi. ");
INSERT INTO sby_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Bakamutwalanga ku nkuta, kamutaka yakamwanga kwambeti, ‘Inga ne twambeconi’ Nambi nitwambe cani. Pacindi copeleco ni mukapewe maswi akwamba. ");
INSERT INTO sby_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Pakwinga ntamwe mweshi mukambenga sobwe, nsombi shikwamba ni Mushimu Uswepa wa Lesa Bameshenu, eti ukambenga kupitila muli njamwe. ");
INSERT INTO sby_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Mukwabo nakabukile mukwabo nekumushinisha, baishi nibakabukile mwana nekumushinisha, nabo bana nibakabukile bamashali babo, ne kubashinisha. ");
INSERT INTO sby_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Bantu bonse ni bakapelane ne njamwe pacebo cakame. Nomba uyo eshakemanowa ncili mukunshoma mpaka kumapwililisho, endiyeti akapuluke. ");
INSERT INTO sby_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Lino bakatatika kumupensha mu munshi uwu ne uwo, mukafwambile ku minshi naimbi. Cakubinga ndamwambilishingeti, kamutana mupwisha kwendela minshi yonse ya Baislayeli, Mwana Muntu nakabenga kaliwesa kendi. ");
INSERT INTO sby_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Shikwiya nkapita lamwiyishinga sobwe, kayi musebenshi nkapita muntu walamwingisha ncito sobwe. ");
INSERT INTO sby_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ee, ngacibeco kwambeti, shikwiya ngawelana ne lamwiyishinga, kayi musebenshi ngawelana ne walamwingisha ncito. Nomba lino na mwine mukowa, bantu balamupa lina eti, Belesebulu, Inga bantu bamukowa wakendi sena nkabelela kubapa maina aipa apitapo?” ");
INSERT INTO sby_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Neco, kamutatinanga bantu, kantu kalikonse kafwekelelwa nikakafwekulwe, kayi kalikonse kasolekwa nikakeshibikwe. ");
INSERT INTO sby_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mbyondamwambilinga mu mushinshe, amwe mukabyambilenga patuba, ibyo mbyomulanyumfwili kumukushi, amwe mukabyambilenga pelu paciluli. ");
INSERT INTO sby_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kamutatinanga abo bakute kushina mubili, pakwinga nkabela kushina mushimu. Nsombi amwe kamutinani uyo wela kononga byonse bibili, mubili ne mushimu pamo, mu Gehena. ");
INSERT INTO sby_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Sena tutite tubili nkatukute kulwa ne kalyali kamo? Nsombi paliya nakakaba kamo kakute kulaka panshi kwakubula Bameshenu kwinshiba. ");
INSERT INTO sby_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nomba kulinjamwe, ne mishishi ya mu mutwi yonse yabelengewa ne Lesa. ");
INSERT INTO sby_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Neco kamutatina, amwe mwapita mwelo wa tutite twingi! ");
INSERT INTO sby_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Abo bakute kunsumina pamenso abantu kwambeti nibakame, nenjame ninkabasumine pamenso a Bata balikwilu. ");
INSERT INTO sby_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nomba lankananga pamenso abantu, nenjame ninkamukane pamenso a Bata bakwilu kwambeti nkandimwishipo sobwe.” ");
INSERT INTO sby_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Sena mulayeyengeti ndaleshila lumuno pacishi capanshi? Ame ndiya kwishila lumuno sobwe, nsombi censho ca nkondo. ");
INSERT INTO sby_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ndalesa kupansanya mwana mutuloba ne baishi, mwana mutukashi ne banyina, mulekashi ne banyina shala, ");
INSERT INTO sby_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","balwani ba muntu nibakabe bansebendi. ");
INSERT INTO sby_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Muntu wasunisha baishi ne banyina kupita ame, nkelela kuba shikwiya wakame sobwe. Kayi uyo wasunisha mwana mutuloba nambi mwana mutukashi kupita ame neye nkelela kuba shikwiya wakame. ");
INSERT INTO sby_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Alikane mwine, kayi alibambile kupeshewa, ne kufwa cebo ca kunkonkela. ");
INSERT INTO sby_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Uliyense layandanga kupulusha buyumi bwakendi, nakabutaye, nsombi uyo latayanga buyumi bwakendi pacebo cakame, nakabucane nditu! ");
INSERT INTO sby_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Muntu lamutambulunga, latambulungame, nendi lantambulunga, latambulunga uyo walantuma. ");
INSERT INTO sby_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Muntu latambulunga mushinshimi, pacebo cakwambeti ni mushinshimi, nakatambule cilambo ca mushinshimi. Latambulunga muntu walulama, pacebo cakwambeti walulama, nakatambule cilambo ca muntu walulama. ");
INSERT INTO sby_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Uliyense lapanga menshi atontola mu nkomeshi, kuli umo wa beshikwiya bakame, pacebo cakwambeti ni shikwiya wakame, cakubinga ndamwambilingeti, nendi nteti akalilwe kutambula cilambo camwelela.” ");
INSERT INTO sby_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu mpwalapwisha kubapa busele beshikwiya bakendi likumi ne babili, walafumako nekuya kwiyisha, ne kukambauka mu minshi. ");
INSERT INTO sby_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Mbyalikwinsa Klistu, byalanyumfwika kuli Yohane mubatishi kali mujele, neco walatuma beshikwiya bakendi kulyendiye. ");
INSERT INTO sby_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Kuya kumwipusheti, “Sena njamwe ngobalikwambeti lakesanga, mpani tupembele naumbi?” ");
INSERT INTO sby_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu walakumbuleti, “Kamuyani mumwambile Yohane, bintu mbyomulanyumfunga, ne kubibona. ");
INSERT INTO sby_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Bashipilwa balabononga, nabo balema miyendo balendenga, bashimankuntu balasengulwanga, bashinka matwi balatatiki kunyumfwa, bafwa balapundukunga, nawo Mulumbe Waina ulakambaukwanga kubapenshi. ");
INSERT INTO sby_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Walelekwa muntu labulunga kutonshanya shanjame.” ");
INSERT INTO sby_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Pacindi beshikwiya ba Yohane basa mpobalafumako, Yesu walatatika kwamba sha Yohane, ne kwipusha makoto abantu eti, “Mpomwalikuya kucinyika, mwalayakubona cani? Sena lyalikuba litete lyalikutenkana ne lukupwe? ");
INSERT INTO sby_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mwalayakubona cani? Sena ni muntu wafwala byakufwala bya mulo wadula? Bantu bakute kufwala byakufwala bya mulo wadula bakute kwikala mu manda a bami! ");
INSERT INTO sby_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kamung'ambilani, mwalayakubona cani? Sena walikuba mushinshimi? Ee, nicakubinga, nomba ndamwambilishingeti, mwalabona wapita mushinshimi. ");
INSERT INTO sby_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Uyu endiye usa Mabala a Lesa ngalikwambeti, “Mutumwa wakame uyu, ndamutumunga pantangu pakobe, kwambeti abambile limo nshila njoti ukeshilemo.” ");
INSERT INTO sby_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Cakubinga ndamwambilingeti, mubantu bonse balasemwa kubatukashi, paliya naba umo munene wapita Yohane Mubatishi, nomba nendi uyo mung'ana mu Bwami bwakwilu wamupita Yohane. ");
INSERT INTO sby_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kufuma pacindi ca Yohane mubatishi mpaka lelo, Bwami bakwilu bwakwabililwa mwangofu ne bantu balayandangowa kubulumina banabo. ");
INSERT INTO sby_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mu milawo ya Mose, ne bashinshimi balikabamba sha Bwami bopelobu, mpaka kushika kucindi ca Yohane mubatishi. ");
INSERT INTO sby_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Na mulayandanga kushoma, ishibani kwambeti, Yohane endiye Eliya walikwambweti lakesanga, ");
INSERT INTO sby_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Uyo ukute matwi, kanyumfwani! ");
INSERT INTO sby_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Anu bantu bamusemanowu ngandibelenkanya necani? Balyeti batwanike balatotekeshananga pamusena wa makwebo, bambi kabepusha banabo eti, ");
INSERT INTO sby_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Twalamombela ngoma, nomba mwalabulila cani kushana? Twalembila nyimbo sha malila, nomba nicani amwe muliya kulilako sobwe?” ");
INSERT INTO sby_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Yohane mubatishi mpwalesa, kalikanisha byakulya, ne byakunwa, mwali kamwambeti, wekatwa ne mushimu waipa!” ");
INSERT INTO sby_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mwana Muntu nendi walikulya nekunwa, uliyense walatatika kwambeti, “Kamubonani muntuyu nicakolwa, kayi nimukuma, wasunana ne beshimisonko ne bantu babwipishi, nomba Mano akendi alabonekenga mubyakwinsa byakendi.” ");
INSERT INTO sby_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Panyuma pakendi Yesu walatatika kushingana minshi njalenshilamo bintu bingi byangofu, pakwinga bantu mu minshiyo baliya kushinta myoyo yabo sobwe. ");
INSERT INTO sby_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Walambeti, “Malele obe Kolasini! Malele obe Betisaida! Pakwinga bintu byangofu byalenshika kulinjamwe, anu nibyalenshikila ku Tulo ne Sidoni, nshinga bantu bakendi ne balafwala masankunya, ne kulitila milota, kubonesha kushinta myoyo kwabo, ");
INSERT INTO sby_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nomba ndamwambilingeti, pabusuba bwa lombolosho, nicikabeko capuba kunyumfwilako luse Tulo ne Sidoni, kupita amwe. ");
INSERT INTO sby_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nenjobe Kapelenawo, sena ulayeyengeti nakakutantike kwilu? Wangwela! Nakakulashe panshi mpaka ku musena wa bantu bafwa, pakwinga bintu bya ngofu byalenshika kulinjobe, ne byalenshikila mu Sodomu, nshinga Sodomu nacilipo nelelo. ");
INSERT INTO sby_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nomba ndamwambilingeti, pabusuba bwalombolosho nicikabe capubako kunyumfwilako luse bene Sodomu kupita amwe!” ");
INSERT INTO sby_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Pacindi copeleco Yesu walambeti, “Amwe Ta, mobene kwilu ne cishi capanshi, ndamulumbu pakuyubulula bintu ibi kubatwanike, ne kubisoleka kubantu bamano akucishi, ");
INSERT INTO sby_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ee, Ta, kwinamoyo kwenu mwalayanda kwinseco. ");
INSERT INTO sby_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Ta mwalampa bintu byose mumakasa akame, paliya nabaumo wela kumwinshiba cena Mwana, nsombi Baishi bonka ebala kumwinshiba cena, kayi paliya nabaumo wela kwinshiba cena babula kuba Baishi, nsombi Mwana ewinshi cena Baishi, neye ukute kuyubulwila abo mbwalayandanga. ");
INSERT INTO sby_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Kamwisani kulinjame amwe omwalema cebo ca kunyamuna mitolo, kwambeti mucane kupumwina. ");
INSERT INTO sby_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kamumantani lijoko lyakame, kayi mwiye kulinjame.Pakwinga ndabomba moyo kayi ndalicepesha, kayi nimwise mucane kupumwina. ");
INSERT INTO sby_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Lijoko lyakame lyapuba, ne mutolo wakame wapuba.” ");
INSERT INTO sby_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Pabusuba bwa Sabata, bwakupumwina kwa Bayuda, Yesu walikapita mu libala lya maila pamo ne beshikwiya, beshikwiya bakendi balanyumfwa nsala, neco balatatika kuningula ngala sha maila ne kushilya. ");
INSERT INTO sby_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mpobalaboneco Bafalisi, Yesu balamwambileti, “Kamubonani ncobalenshinga beshikwiya benu pabusuba bwa Sabata cabula kusuminishiwa ne Mulawo” ");
INSERT INTO sby_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Nendi walabambileti, “Sena muliya kubelengapo ncalensa Dafeti, mpwalanyumfwa nsala pamo ne banendi mbwalikuba nabo? ");
INSERT INTO sby_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ntepasa walakengila mu Ng'anda ya Lesa, kuya kulya shinkwa wishikubengwa kuli Lesa ico calikuba catonda, nkabalikuba basuminishiwa ne mulawo kulya shinkwa uyo sobwe, nsombi beshimilumbo. ");
INSERT INTO sby_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mpani muliya kubelengapo mu Milawo kwambeti, beshimilumbo nabo balikupwaya mulawo pabusuba bwa Sabata ne kuboneketi baliya mulandu. ");
INSERT INTO sby_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Cakubinga ndamwambilishingeti, mpwali pano wapita Ng'anda ya Lesa. ");
INSERT INTO sby_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nshinga nemucishi bupandulushi bwa Maswi a Lesa alambangeti, ‘Nkandayandangeti bantu bampe milumbo sobwe, nsombi ndayandangeti bantu benshilenga nkumbo kubanabo. nsuni nkumbo, kupita milumbo, anu ne mutambili bantu babula bwipishi eti bakute bwipishi,’ ");
INSERT INTO sby_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Pakwinga Mwana Muntu emwine busuba bwa Sabata.” ");
INSERT INTO sby_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Mpwalafumapo Yesu walakengila mu ng'anda yakupaililamo, ");
INSERT INTO sby_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Umo mwalikuba muntu watontola cikasa, bantu nabambi balikuyanda pakumucaninapo mulandu wakumubepeshela Yesu, balamwipusheti, “Sena Milawo yasuminisha kusengula muntu pabusuba bwa Sabata?” ");
INSERT INTO sby_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nendi Yesu walabakumbuleti, “Niyani palinjamwe ukute kambelele kamowa, welela kubula kukatampula kawila mucisengu pa busuba bwa Sabata? ");
INSERT INTO sby_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nomba muntu ntewapita mbelele! Na nico ekwambeti Milawo yasuminisha kwinsa byaina pabusuba bwa Sabata.” ");
INSERT INTO sby_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Neco walamwambila usa muntu, “Tandabula cikasa cakobe!” Nendi walatandabula, popelapo cikasa cakendi calaba cena mbuli cinendi. ");
INSERT INTO sby_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Popelapo basa Bafalisi balapula kuya kupangana mobelela kumushinina Yesu. ");
INSERT INTO sby_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu mpwalanyumfweti balapangananga, walafumamo. Abo bantu bonse balikumukonkela walikubasengula malwashi onse. ");
INSERT INTO sby_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Nomba nendi walabakonkomesha kwambeti, kabatamuyubululanga, ");
INSERT INTO sby_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","walenseco kwambeti ncalamba Lesa kumushinshimi wakendi Yesaya cikwanilishiwe cakwambeti, ");
INSERT INTO sby_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“kamubonani, musebenshi wakame uyu ngondalasala, Ndimusuni, moyo wakame wakondwa nendi, Ninkabike Mushimu mulyendiye. Nendi nakakambaukenga shalombolosho kubantu ba mishobo naimbi, ");
INSERT INTO sby_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nteti akatotekepo, nambi kompolola sobwe, Paliya muntu eti akanyumfwepo liswi akendi munshila sha muminshi, ");
INSERT INTO sby_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nendi nteti akatyokole litete lyomfwama, nambi kushima muniko ulayandanga kushimika, mpaka cancinencine cikakwane, ");
INSERT INTO sby_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kupembelela kwa bantu bonse nikukabikwe mu lina lyakendi.” ");
INSERT INTO sby_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Panyuma pakendi bantu balaleta muntu washipilwa, kayi utacikonsho kwamba wekatwa ne mishimu yaipa, Yesu walamusengula, walatatika kwamba ne kubona cena. ");
INSERT INTO sby_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Bantu bangi balakankamana kabambeti, “Sena uyu nte mwanendi Dafeti?” ");
INSERT INTO sby_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nomba Bafalisi mpobalanyumfweco balambeti, “Sobwe, ngofu shakupulisha mishimu yaipa lashifulunga kuli belezebulu mukulene wa mishimu yaipa.” ");
INSERT INTO sby_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu mpwaleshiba ncebalikuyeya walabambileti, “Cishi ciliconse capansana mu makoto makoto ne kutatika kulwana, nkacela kwikalisha nsombi ngaconongeka. Nambi bantu mu munshi, ne mumikowa batatika kubukilana ne kulwana, uwo munshi nambi mukowa nkapelela kuba kunyumfwana sobwe. ");
INSERT INTO sby_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Na bali mubwami bwa Satana kabapulishana palwabo bene, ekwambeti bapansana, inga bwami bwakendi Satana ngabuyumeconi? ");
INSERT INTO sby_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Na ame kamung'ambeti ndapulishinga mishimu yaipa ne ngofu sha belezebulu, inga beshikwiya benu balo balapulishinga mishimu yaipa ne ngofu shabani? Ecebo cakendi beshikwiya benu ebabanga bakamboni pacilubo cenu. ");
INSERT INTO sby_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Na ame ndapulishinga mishimu yaipa ne ngofu ya Mushimu wa Lesa, anu ekwambeti Lesa latatiki kubika Bwami bwakendi pakati penu.” ");
INSERT INTO sby_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Paliya muntu welela kwingila mu ng'anda ya muntu wangofu kuya kumantamo buboni bwakendi, katanamusunga muntu wangofuyo. Enseco welela kuya kumantamo bintu mung'andomo. ");
INSERT INTO sby_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Uyo labulunga kubela kulubasu lwakame latotekeshananga nenjame, uyo labulunga kunyamfwako kubunganya, nendi ni shikumwaya. ");
INSERT INTO sby_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ecebo cakendi ndamwambilishingeti, Lesa nakalekelele bwipishi bonse, ne maswi aipa. Nomba ku muntu lanyanshanga Mushimu Uswepa, Lesa nteti akamulekelelepo. ");
INSERT INTO sby_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ni cimo cimo uliyense lambilinga Mwana Muntu maswi aipa, Lesa nakamulekeleleko, nomba uliyense lanyanshanga Mushimu Uswepa, Lesa nteti akamulekelelepo sobwe pacino cindi, nambi mucindi cakuntangu.” ");
INSERT INTO sby_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Na mwambeti citondo ici caina, ekwambeti ne bisepo byakendi byaina, kayi mwambeti, citondo ici caipa, ekwambeti ne bisepo byakendi byaipa, citondo cikute kwishibikwa kubisepo byakendi. ");
INSERT INTO sby_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Bana banjoka amwe! Ngamucikonsheconi kwamba byaina pakwinga mwaipa? Pakwinga mulomo ukute kwamba byesula mumoyo. ");
INSERT INTO sby_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Muntu waina ukute kupulisha byaina kufuma pamulunda wa buboni bwakendi bwaina. Nendi muntu waipa ukute kupulisha byaipa kufuma pamulunda wa buboni bwakendi bwaipa. ");
INSERT INTO sby_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ndamwambilishingeti pa busuba bwalombolosho, bantu ni bakacanike ne mulandu pa maswi abula kwelela ngobalikwamba, ");
INSERT INTO sby_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","pakwinga nemaswi akobe nukacaniketi uliya mulandu, kayi maswi akobe nakakupeshe mulandu. ");
INSERT INTO sby_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Beshikwiyisha milawo ya Mose ne Bafalisi balamwambila Yesu eti, “Bashikwiyisha, tulayandanga mutulesheko cingashilo cishikukankamanisha.” ");
INSERT INTO sby_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nomba nendi Yesu walambeti, Ha! Kwipa musemano uwu wabantu babula lushomo balayandanga kubona cingashilo cishikukankamanisha, Nomba nteti bakacibonepo sobwe cingashilo kupatulakowa cisa ca mushinshimi Yona. ");
INSERT INTO sby_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Mbuli Yona usa ncalikuba mulibunda lya luswi lunene lusa masuba atatu, munshi ne mashiku, nendi Mwana Muntu na kabikwe panshi mubulongo masuba atatu, munshi ne mashiku. ");
INSERT INTO sby_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Bantu baku Ninive, nibakapundukile pamo ne bantu ba musemanowu pa busuba bwa lombolosho, kwambeti bantu ba ku ninive bakabatotekeko, nte pasa balo balalapa mpobalanyumfwa kukambauka kwa Yona. Nsombi pano mpwali wapita Yona. ");
INSERT INTO sby_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Pa busuba bwalombolosho, mwami mutukashi waku Sheba nakapunduke pamo ne bantu bamusemanuwu, nakese akabatoteke. Pakwinga nendi walenda musuma, kwisa kunyumfwa kwamba kwa mano a mwami Solomoni, nomba pano pali wapita Solomoni. ");
INSERT INTO sby_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Na mushimu waipa ulapulu mu muntu, ukute kuya kwendenda mucishi cabula menshi, kulangaula musena wakupumwininako, nomba nkaukute kucanika. ");
INSERT INTO sby_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Neco ukute kwambeti, ndabwelenga kung'anda kwakame kusa nkondalapula, lino washika ukute ucana mung'anda musa muli tonto, mwapyangwa ne kubambwa cena. ");
INSERT INTO sby_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ukute kuya kumanta mishimu inendi isanu ne ibili yaipa kupita walo, panyuma pakendi yonse ikute kuya kwingila ne kwikalilila mopelomo. Neco bwikalo bwa muntu uyo bukute kwipa kupita ncalikuba pakutanguna, nicikabeco kumusemanuwu waipa.” ");
INSERT INTO sby_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu kacamba ne bantu bangi basa, bakwabo ne banyina balashika, balemana pansa, balikuyanda kwambako nendi. ");
INSERT INTO sby_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Lino muntu naumbi walakamwambila Yesu kwambeti, “Banyoko ne bakwenu bali apa pansa balayandanga kwambako ne njobe.” ");
INSERT INTO sby_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu walamukumbuleti, “Anu bama ni bani? Ne bakwetu nibani?” ");
INSERT INTO sby_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Mpwalambeco walatondeka kwalikuba beshikwiya bakendi ne kwambeti, Ame aba e Bama ne bakwetu, ");
INSERT INTO sby_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Pakwinga uliyense lenshinga kuyanda kwa Bata ba kwilu, uyo emukwetu mutuloba, enkashi yakame, kayi e Bama. ");
INSERT INTO sby_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yesu pa busuba bopelobo walapula mung'anda, ne kuya kwikala panshi mu mbali mwa lwenje. ");
INSERT INTO sby_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kopeleko kwalabungana bantu bangi, Yesu walengila ne kuya kwikala mubwato, bantu bonse balemana kumutunta. ");
INSERT INTO sby_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yesu walamba ne bantu aba bintu bingi mumikoshano, walambeti, “Muntu naumbi walaya kumwaya mbuto. ");
INSERT INTO sby_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mpwalikumwaya mbuto, nashimbi mbuto shalawila munshila, shalalyewa ne bikeni. ");
INSERT INTO sby_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Imbuto nashimbi shalawila pabulongo bwa mabwe, apo palikubula bulongo bwingi, shalamena bwangu pakwinga bulongo nkabwalikuba bwingi. ");
INSERT INTO sby_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nomba lisuba mpolyalatako, shalapya ne lumwi, neco shalanyana, pakwinga miyanda nkayalikuba yayapanshi sobwe. ");
INSERT INTO sby_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Imbuto nashimbi shalawila pa myunga. Pakukula matewu, myunga yalashinkilila kukula kwa mbuto shisa. ");
INSERT INTO sby_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Nomba mbuto nashimbi shalawila pa bulongo bwabolela cena, shalasema mifuko ingi namumbi mwalikuba nseke mwanda, namumbi nseke makumi asanu ne limo, namumbi nseke makumi atatu, kupita shalabyalwa” ");
INSERT INTO sby_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yesu walambeti, “Uyo ukute matwi, anyumfwe!” ");
INSERT INTO sby_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Panyuma pakendi beshikwiya ba Yesu balamwipusheti, “Inga nipacebo cini bantu aba ncomulambanga nabo mumikoshanyo?” ");
INSERT INTO sby_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nendi walambeti, “Amwe Lesa walamuyubulwila byasolekwa bya Bwami bwa kwilu, nsombi kuli nabambi uliya kubayubulwilapo sobwe. ");
INSERT INTO sby_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ukuteko kantu nibakamupeko nabimbi, nakabe ne bintu bingi. Nomba uyo wabula kantu kalikonse, ne kang'anako nkakute nibaka mulamune. ");
INSERT INTO sby_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ncondambilinga mumikoshanyo ne bantu aba nicebo cakwambeti, nambi balalanganga, nkabalabononga sobwe, nambi balanyumfunga, nkabalanyufunga nambi kunyumfwishisha sobwe. ");
INSERT INTO sby_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ebantu aba balakwanilisha ncalikwamba mushinshimi Yesaya,” “Kunyumfwa nimukanyumfwenga, nsombi nteti mukanyumfwishishenga kubona nimukabonenga, nsombi nteti mukabonesheshenga sobwe. ");
INSERT INTO sby_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Cakubinga myoyo yabantu yafumpa, bashinka bishili mumatwi mwabo, bacala menso abo. Ne calabula kubeco, ngababona ne menso abo. ngabanyumfwa ne matwi abo, mano abo ngaishiba ne kushinta myoyo, kwambeti ame ndibasengule.” ");
INSERT INTO sby_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Nombamwe menso enu alelekwa pakwinga alabononga, nawo matwi enu alanyumfunga. ");
INSERT INTO sby_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kwamba cakubinga, bashinshimi ne bantu bangi balulama balikuyandishisha kubona bintu ibi mbyomulabononga, nsombi balo baliya kubibonapo sobwe, balikuyandishisha kunyumfwa mbyomulanyumfunga, nsombi baliya kubinyumfwapo sobwe.” ");
INSERT INTO sby_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Amwe lino munyumfwishishe bupandulushi bwa mukoshanyo wa muntu usa walikumwaya mbuto. ");
INSERT INTO sby_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Muntu uliyense anyumfwa Maswi, kwakubula kwanyumfwishisha, Waipa ukute kwisakufunyamo Maswi abyalwa mumoyo, Ishi embuto shisa shalabyalwa munshila. ");
INSERT INTO sby_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Imbuto shalabyalwa pabulongo bwa mabwe shilapandululunga muntu ukute kunyumfwa Maswi ne kwatambula mwabwangu bwangu mwakukondwa. ");
INSERT INTO sby_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Lino pacebo cakubula miyanda yashimpa cena, ukute kulikakatishako kwakacindi kang'anowa, cakwinseti aba mumapensho ne kunyumfwa bishikubaba pacebo ca Maswi asa, muntuyo ukute kubwelela panyuma pacindi copeleco. ");
INSERT INTO sby_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Imbuto shisa shalabyalwa pa myunga shilapandululunga muntu ukute kunyumfwa Maswi a Lesa, nomba cebo cakutatilwa ne bintu byapacishi ne kuyandishisha mali, kukute kutyompwesha kukula kwa Maswi asa, neco nkakute kusemapo bisepo sobwe. ");
INSERT INTO sby_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nomba mbuto shisa shalabyalwa pabulongo bwabolela shilapandululunga muntu uyo ukute kwatambula Maswi a Lesa ne kwanyumfwishisha, Muntuyu ukute kusema bisepo, mwanda, nacimbi cindi makumi asanu ne limo, nambi makumi atatu a bishango byalabyalwa.” ");
INSERT INTO sby_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu walabambila kayi mukoshanyo naumbi, walambeti, “Bwami bwakwilu bwakoshana ne muntu walabyala mbuto shaina mulibala lyakendi. ");
INSERT INTO sby_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nomba cindi ncobalikuba bonatulo bantu bonse, mulwani wakendi walesa kubyalamo musonde pakati pa maila, ne kufumapo. ");
INSERT INTO sby_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Lino mumena wa maila mpowalikukula nekuba ne mapumpu, nawo musonde walatatika kuboneka.” ");
INSERT INTO sby_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Basebenshi bakendi mwine libala usa, balamwipusheti, “Nkambo, sena nte mwalabyalamo'wa mbuto shaina mulibala lyenu? Inga nawo musonde ulabonekenga mongeconi?” ");
INSERT INTO sby_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nendi walabakumbuleti, “Nimulwani wakame wenseco,” Nabo basebenshi balamwipusha kayi, “Sena twenga tutumunemo?” ");
INSERT INTO sby_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Walambeti, “Sobwe! Mwenseco ngamutumwina kumo ne maila mwatumunanga musonde uwo. ");
INSERT INTO sby_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kamubilekani bikulile pamo mpaka cindi cakucesa. Pacindico ninkambile beshikucesa Kamucesani nanshi musonde, musunge mitolo mitolo, muutente. Panyuma pakendi mubunganye maila ne kuya kwabika mu lyanga lyakame.” ");
INSERT INTO sby_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Kayi Yesu walabapa mukoshanyo naumbi walambeti, “Bwami bwakwilu bulyeti nseke shakatondo ka masitadi ako muntu nkalakabyala mulibala lyakendi. ");
INSERT INTO sby_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nseke shakatondo aka ni shing'anashing'ana mwelanisha ne nseke nashimbi. Nomba mbuto yakendi yakula, ikute kupita bifukusa nabimbi, ikute kuba citondo cinene, umo bikeni bikute kwisa kwibakamo bisangala mu misampi yakendi.” ");
INSERT INTO sby_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu walabapa mukoshanyo naumbi kayi, walambeti, “Bwami bwakwilu bulyeti cishikufufumisha shinkwa, ico mutukashi naumbi ncalasankanya pamo ne bunga bwakwana bikopo bibili, mpaka bunga bonse bwalafufumuka.” ");
INSERT INTO sby_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu byonsebi walikubambila bantu mumikoshanyo, pacindici uliya kwambapo nabo cintu ciliconse kwabula mukoshanyo. ");
INSERT INTO sby_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Uko kwalikuba kukwanilisha calambwa ne mushinshimi, kwambeti, “Ninkambenga nabo mumikoshanyo, Ninkayubulule byalikuba byasolekwa kufuma pakulengwa kwacishi capanshi.” ");
INSERT INTO sby_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu walashiya makoto abantu basa, ne kuya kwingila mung'anda, beshikwiya bakendi balamusengeti, “Kamutupandulwilako mukoshanyo wa musonde wa mulibala usa.” ");
INSERT INTO sby_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","“Yesu nendi walambeti, Usa shikumwaya mbuto shaina endiye Mwana Muntu. ");
INSERT INTO sby_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Libala lisa ecishi cino capanshi. Shisa mbuto shaina ebantu bene Bwami bwa Lesa. Musonde ni bantu baipa bakendi Waipa usa. ");
INSERT INTO sby_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mulwani usa walabyala musonde ni Muyungaushi. Kucesa maila kusa ekupwa kwacishi capanshi, ne beshikucesa ni bangelo. ");
INSERT INTO sby_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Mbuli ncobalabunganya musonde ne kutenta pamulilo, nicikabeco pakupwa kwa cishicapanshi ");
INSERT INTO sby_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwana Muntu nakatume bangelo bakendi, kwisa kufunyamo mu Bwami bwakendi bantu bonse bakute kwipisha banabo, pamo ne bonse bamicito yaipa. ");
INSERT INTO sby_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Nibakabawale mubufuni bwa mulilo, kopeloko nibakalilenga ne kukokota meno. ");
INSERT INTO sby_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nomba bantu balulama nibakabaleti lisuba mu Bwami bwa Bameshabo, Uyo ukute matwi, anyumfwe! ");
INSERT INTO sby_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Bwami bwakwilu ngatubwelanika cisa; Muntu naumbi walafumbula mali asolekwa mulibala. neye kayi walafumbika pambi, panyuma pakendi mwakukondwa, walakaulisha bintu byonse mbyalikukute ne kuya kula libala lisa. ");
INSERT INTO sby_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Kayi Bwami bwakwilu ngatubwelanika cisa; Muntu naumbi shimakwebo, walayakulangaula malungu a mulo wadula. ");
INSERT INTO sby_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Mpwalacana libwe limo lya mulo wadula, walaya kuyakulisha bintu byonse mbyalikukute ne kuyakula libwe lyamulo wadula lisa ndyalikuyandishisha. ");
INSERT INTO sby_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Bwami bwakwilu ngatubwelanika cisa; Basulishi balawala kombe mulwenje nekubungulula nswi sha mishobo yonse, ");
INSERT INTO sby_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","kesula bakute kukakwelela kumutunta, bakute kwikala panshi nekutatika kusalapo nswi shaina kababika mu mitanga, shaipa nikushitaya. ");
INSERT INTO sby_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nicikenshikeco pakupwa kwacishici, bangelo nibakafunyepo bantu baipa pakati pa bantu balulama, ");
INSERT INTO sby_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ne kubawala mubufuni bwamulilo, kopeloko nibakalilenga ne kukokota meno.” ");
INSERT INTO sby_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu walabepusha beshikwiya bakendi, “Sena mulanyumfwishishi cena bintu ibi byonse?” Balo balambeti, “Ee” ");
INSERT INTO sby_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kayi walabambileti, “Ecebo cakendi shikwiyisha uliyense wa milawo laba shikwiya wa Bwami bwakwilu, ulyeti mwine ng'anda uyo ukute kupulisha bintu bya linolino ne byakaindi kufuma mulyanga lya buboni bwakendi.” ");
INSERT INTO sby_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu mpwalapwisha kwamba mikoshanyo walafumako. ");
INSERT INTO sby_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Mpwalashika mucibela cakucomwabo, walatatika kwiyisha bantu mu ng'anda yakupaililamo. Abo balikumunyumfwa balikunkamana ne kwipusheti, “Mano, ne ngofu shakankamanisha shilicisa muntuyu walashifunya kupeyo? ");
INSERT INTO sby_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Sena uyu nte mwana wa shikupala mapulanga usa? Sena nte mwanendi Maliya? Sena bamakwabo nte Jemusi ne Yosefe ne Shimoni ne Yuda? ");
INSERT INTO sby_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Sena nkashi shakendi shonse ntetulinasho pamo pano? Inga bintu ibi walabicana kupeyo?” ");
INSERT INTO sby_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Neco balamusula, nomba nendi Yesu walabambileti, Mushinshimi nkakute kupewa bulemu ne banse bendi mbaikala nabo mumunshi, nsombi bantu bakumbi. ");
INSERT INTO sby_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Neco, Yesu uliya kwinsako bintu bingi byangofu, pacebo cakubula lushomo kwabo. ");
INSERT INTO sby_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Pacindi copeleco, mwami Helode waku Galileya walanyumfwa bintu byalikwamba bantu mbyalikwinsa Yesu. ");
INSERT INTO sby_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Walambila bantu bakendi bamakulene, “Uyu ingakali Yohane Mubatishi usa elapunduku kubafu! Ecebo cakendi ncalenshilinga bishikunkamanisha bilicisa.” ");
INSERT INTO sby_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Pakwinga Helode ewalatuma bashilikali kuyakwikata Yohane, ne kumubika mujele. Walenseco pacebo ca Helodiya, walikuba mukashi wa Filipo, mukwabo Helode. ");
INSERT INTO sby_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Pakwinga Yohane walamwambila Helode kwambeti, “Mulawo nkawasuminisha amwe kumweba uyu mutukashi,” ");
INSERT INTO sby_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ncalikuyanda Helode nikushina Yohane, nsombi walikutina bantu, pakwinga bantu balikwambeti Yohane nimushinshimi. ");
INSERT INTO sby_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mpobwalashika busuba bwa kwanuka kusemwa kwa Helode, mwana mutukashi wa Helodiya walashana pamenso pa bantu bonse balakwiwa ku malyalya awo, Helode walakondwa, ");
INSERT INTO sby_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","cakwinseti walensa kulumbileti, “Cakubinga nditu ninkupe ciliconse ncoti usenge.” ");
INSERT INTO sby_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Lino banyina balamwambila cintu ncoti engakusenga. Mwana mutukashi usa walambeti, “Kamumpani mumbale popelepano mutwi wa Yohane mubatishi.” ");
INSERT INTO sby_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mwami Helode walanyumfwa nsoni, nomba pacebo ca kulumbila kusa, kayi ne bantu basa mbwalakuwa kumalyalya asa, walambeti, “Mwana mutukashuyu apewe mutwi ngwalasenge.” ");
INSERT INTO sby_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Popelapo walatuma muntu kuya kumutimbula mutwi Yohane mujele. ");
INSERT INTO sby_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Walaumantila mumbale mutwi ne kutwala kumwana mutukashi, nendi walautwala ku banyina. ");
INSERT INTO sby_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Panyuma pakendi beshikwiya bakendi Yohane balesa kumanta citumbi ne kuyakubika mumanda, kufumapo balayakumwambila Yesu. ");
INSERT INTO sby_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu mpwalanyumfweco walatanta bwato ne kufumako, ne kuya kumusena kwabula bantu. Nomba bantu mpobalanyumfweti Yesu lafumuko balamukonkela ne myendo kufuma muminshi yabo. ");
INSERT INTO sby_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu mpwalabona likoto lyabantu, walaseluka mubwato, walabanyumfwila nkumbo, kayi walatatika kusengula balwashi. ");
INSERT INTO sby_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Beshikwiya bakendi pacindi camansailo, Yesu balamwambileti, “Kuno nikucisuwa, ano nimansailo kamubambilani bantu aba benga kuminshi bengakula byakulya.” ");
INSERT INTO sby_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nomba nendi Yesu walabambileti, “Nkabelela kuya kumbi, amwe nimubape cakulya.” ");
INSERT INTO sby_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Balo balambeti, “Tukutekowa shinkwa usanu, ne nswi shibili.” ");
INSERT INTO sby_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu walambeti, “kamuletani kuno.” ");
INSERT INTO sby_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mpobalamutwalila, Yesu walambila bantu baseti bekale panshi pa mila, Yesu walamanta shinkwa usanu ne nswi shibili, walalungumana kulanga kwilu, ne kulumba Lesa, panyuma pakendi walakomona komona shinkwa usa ne kupa beshikwiya bakendi, nabo balayabila bantu bonse. ");
INSERT INTO sby_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bantu bonse balalya ne kwikuta. Panyuma pakendi beshikwiya balayowela byalashala ne kwisusha mitanga likumi ne ibili. ");
INSERT INTO sby_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Bantu bonse balikubapo balalya, balikuba batuloba myanda makumi asanu kutabelengela kumo batukashi ne bana. ");
INSERT INTO sby_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pacindi copeleco, Yesu walambila beshikwiya bakendi kwambeti batante bwato batangune kuya kutala, nendi walashalila kunyuma kacambila bantu eti benga kwabo. ");
INSERT INTO sby_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Mpwalalayana ne bantu basa, Yesu walatanta mumulundu kuyakupaila enka, palatatika kushipuluka kacili kopeloko enka. ");
INSERT INTO sby_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Pacindici bwato busa bwalikuba pakati pa lwenje, patali ne kumutunta, kabapenga kukwasula cebo camankape, pakwinga balikabalwana ne lukupwe lunene. ");
INSERT INTO sby_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Cindi cakumaca kakutubuluka Yesu walesa nkobalikuba kesakwenda pa menshi. ");
INSERT INTO sby_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Beshikwiya bakendi mpobalamubona kenda pamenshi, balatina, balambeti, “Nicipuku!” Balatatika kutamauka cebo ca buyowa. ");
INSERT INTO sby_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yesu pacindi copeleco walabambileti, “Kamwikalikani cali! Njame, kamutatina sobwe!” ");
INSERT INTO sby_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nendi Petulo walambeti, “Nkambo, na njamwe kamunsuminisha ne njame njise uko pamenshi,” ");
INSERT INTO sby_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Nendi Yesu walambeti, “Kwesa!” Petulo nendi walafuma mubwato, ne kutatika kwenda pamenshi kuya kuli Yesu. ");
INSERT INTO sby_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Mpwalabona kukonempa kwalukupwe walaba ne buyowa, walatatika kwibila, walatatika kubilikisheti, “Nkambo, kamumpulushako!” ");
INSERT INTO sby_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesu popelapo walatandabula cikasa ne kumwikata, ne kwambeti, “Obe okute lushomo lung'ana ulatonshanini cani?” ");
INSERT INTO sby_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Panyuma pakendi bonse babili balaya kwingila mubwato busa ne lukupwe lwalacileka. ");
INSERT INTO sby_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Beshikwiya basa balikuba mu bwato balamukambilila Yesu ne kwambeti, “Cakubinga njamwe Mwanendi Lesa.” ");
INSERT INTO sby_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Lino bonse balatampuka lwenje ne kushika ku Genesaleti. ");
INSERT INTO sby_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Bantu bakucishico balamwishiba Yesu, balaya kwishibisha banabo mucibela conse, neco balaleta balwashi bonse kuli Yesu. ");
INSERT INTO sby_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Balamusengeti abasuminishe balwashi bekatekowa mwinjila wakendi, cakubinga bonse balekatako balikusengulwa. ");
INSERT INTO sby_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Busuba nabumbi Bafalisi ne beshikwiyisha Milawo ya Mose nabambi balesa kuli Yesu kufumina ku Yelusalemu, balamwipusheti, ");
INSERT INTO sby_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Nipacebo cini beshikwiya benu nkabalasungunga mwambo wa bakulukulu? Nkabalasambanga kumakasa balyanga cakulya. ");
INSERT INTO sby_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nendi Yesu walabakumbuleti, “Inga ne njamwe mukute kusulila cani Milawo ya Lesa, ne kuyuminina nta ku mwambo wamashali benu bakulukulu?” ");
INSERT INTO sby_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Lesa walambeti, “Kopa bulemu baiso ne banyoko kayi kwambeti, uyo lanyanshanga baishi ne banyina welela kushinwa nditu. ");
INSERT INTO sby_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nsombi amwe mukute kwambeti, ‘Muntu ambila baishi, nambi banyina, eti, mbyondayandanga kumunyamfwani, ndabibenge kuli Lesa, ");
INSERT INTO sby_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","nteko kwambeti uyo uliya kupa bulemu baishi,’ Cebo ca mwambo wenuwo Maswi a Lesa akute kuba abulyo.” ");
INSERT INTO sby_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Amwe bantu bandemi shibili, mushinshimi Yesaya walamba cakubinga mpwalambeti, ");
INSERT INTO sby_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Bantu aba bakute kumpa bulemu bwa pamulomo nsombi moyo wabo ulikutali ne njame. ");
INSERT INTO sby_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ee, bakute kunkambilila, nsombi kunkambilila kulico ni kwabulyo, pakwinga mbyobakute kwiyisha, nteyo milawo yakame, nsombi niya bantu.” ");
INSERT INTO sby_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Panyuma pakendi Yesu walabakuwa bantu basa, kwambeti bese pepi ne kubambileti, “Kamunyumfwani, kayi munyumfwishishe cena, ");
INSERT INTO sby_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","cintu cikute kwingila mu mulomo, nteco cikute kwipisha muntu sobwe, nsombi cisa cikute kupula pamulomo pakendi endico cikute kwipisha muntu.” ");
INSERT INTO sby_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Popelapo beshikwiya bakendi nabo balamwipusheti, “Sena mucinshi kwambeti mubalabanyufwishi nsoni Bafalisi ne ncomulamba?” ");
INSERT INTO sby_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu walambeti, “Imbuto iliyonse yabula kubyalwa ne Bata bakwilu, ni katumunwe. ");
INSERT INTO sby_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Balekeni, aba nibatangunishi bashipilwa babantu bashipilwa, Lino na washipilwa utangunina washipilwa munendi, babili bonse ni bakawile mucisengu.” ");
INSERT INTO sby_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pacindici nendi Petulo walamwipusha Yesu kwambeti, “Tupandululwileni mukoshanyowu.” ");
INSERT INTO sby_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu walambeti, “Anu ne njamwe kayi nkamulanyumfwishishinga? ");
INSERT INTO sby_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Sena kamucinshi kwambeti, ciliconse cilengilinga mumulomo cikute kwingila mulibunda mwakendi, ne kuya kucitaila kucisuwa? ");
INSERT INTO sby_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nomba bilapulunga mu mulomo wa muntu bikute kufuma mumoyo, neco, ibi ebikute kumwipisha. ");
INSERT INTO sby_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Pakwinga mu myoyo ya bantu emukute kufuma manjeyaulwa aipa, nambi akushina nambi abupombo nambi abufule nambi akwiba nambi abukamboni bwabwepeshi, kayi ne abufwiyishi. ");
INSERT INTO sby_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ibi ebikute kwipisha muntu. Nteko kulya cakulya kwakubula kusamba kumakasa sobwe.” ");
INSERT INTO sby_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu walafumako, ne kuya kubibela bya Tulo ne Sidoni. ");
INSERT INTO sby_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mutukashi naumbi mu Kenani wamucibela ca kopeloko, walesa kuli Yesu, kabilikisheti, “Kamunyumfwilako nkumbo, Nkambo, Mobana bendi Dafeti. Mwaname mutukashi lapenge kwine pakwinga wekatwa ne mushimu waipa.” ");
INSERT INTO sby_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nomba Yesu uliya kumukumbulapo. Beshikwiya bakendi Yesu balesa kumusengeti, “Anu kamumwambilani enga, bonani latuyobekelenga.” ");
INSERT INTO sby_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nendi Yesu walambeti, “Ame ndalatumwa ku mbelele shataika sha Baislayeli.” ");
INSERT INTO sby_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mutukashi usa walasuntama, ne kwambeti, “Kamunyamfwilishako Nkambo.” ");
INSERT INTO sby_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu walamwambileti, “Nkacaina kupa bakabwa cakulya cabana.” ");
INSERT INTO sby_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mutukashi usa walambeti, “Ee, nicakubinga Nkambo, nomba ntepasa bakabwa bakute nabo kubweselela bilalakanga panshi alyanga mwine ng'anda.” ");
INSERT INTO sby_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nendi Yesu walambeti, “Obe mutukashi lushomo lwakobe ni lunene, cinshike nditu ncolayandanga.” Popelapo mwanendi mutukashi usa walabacena. ");
INSERT INTO sby_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Kufumapo, Yesu walaya kwendana mu mbali mwa lwenje lwa Galileya, kayi walatanta mulundu ne kwikala panshi kopeloko. ");
INSERT INTO sby_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nomba bantu bangi balesa kuli Yesu, balamuletela balwashi, balema myendo ne bashipilwa ne balemana ne bacibulu ne nabambi. mpobalikubaleta pantangu pakendi, walikabasengula bonse. ");
INSERT INTO sby_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Lino bantu bangi balakankamana, pakubona bacibulu kabamba, balemana kabasengulwa, balema myendo basa kabenda, kayi bashipilwa kabacikonsha kubona, neco balamutembaula Lesa wa Baislayeli. ");
INSERT INTO sby_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu walakuwa beshikwiya bakendi nekubambileti, “Ame ndabanyumfwilinga luse bantu aba, pakwinga balekala ne njame kwa masuba atatu, kayi kwakubula cakulya. Nkansuni kubambileti, benga kwabo ne nsala kabatana balyapo, pakwinga ngabawisuka bayanga munshila.” ");
INSERT INTO sby_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Beshikwiya bakendi balamwipusheti, “Inga kucisuwa kuno ngatucicana kupeyo cakulya celela kukwana bantu bangi cisa?” ");
INSERT INTO sby_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Nendi Yesu walabepusheti, “Inga mukuteko shinkwa ungaye?” Balo balamukumbuleti, “Usanu ne ubili, kayi ne tunswi twakubelengowa.” ");
INSERT INTO sby_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesu walabambila bantu basa kwambeti bekale panshi. ");
INSERT INTO sby_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Panyuma pakendi walamanta shinkwa usanu ne ubili usa ne nswi, walalumba Lesa, ne kukomona komona shinkwa, walapa beshikwiya bakendi, nabo balayabila bantu. ");
INSERT INTO sby_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Bantu bonse balalya, balekuta. Balayowela byalashalapo ne kwisusha mitanga isanu ne ibili. ");
INSERT INTO sby_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Lino bantu bonse pamo balalya balikuba batuloba myanda makumi ana, kutabelengela kumo batukashi ne batwanike. ");
INSERT INTO sby_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Panyuma pakulayana ne bantu basa, Yesu walatanta bwato walaya kucibela ca Magadani. ");
INSERT INTO sby_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Kayi Bafalisi ne Basaduki nabambi balesa kuli Yesu kwisa kumwelekesha pakumwipusheti, abaleshe cishibisho ceshikufuma kwilu. ");
INSERT INTO sby_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nomba nendi Yesu walabambileti, “Mansailo mwaboneti kwilu kwafubela pyuu, mukute kwambeti lilo nibukace cena, ");
INSERT INTO sby_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","kayi bwaca mukute mwambeti, ‘Lelo niloke mfula yamabwe, pakwinga kwilu kwafubela ciyosha, kayi kuli makumbi ashipa mbii.’ Mukute kucikonsha kupandulula mbuli ncokulabonekenga kwilu ku makumbi, nomba cilalanga kupandulula bishibisho byapacindi cino. ");
INSERT INTO sby_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Musemano wa bantu baipa, kayi babula lushomo, balayandanga cishibisho cishikukankamanisha? Paliyawa cishibisho ncoti bakapewe capita cisa ca Yona.” Yesu mpwalambeco walafumapo nekuya kumbi. ");
INSERT INTO sby_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mpobalikutampuka kuya kutala kwa lwenje, beshikwiya balalubako kumanta shinkwa. ");
INSERT INTO sby_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu walabambileti, “Mucenjele ne cishikufufumusha ca Bafalisi neca Basaduki.” ");
INSERT INTO sby_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Beshikwiya bakendi balatatika kwamba pa lwabo beneti, lambangeco pakwinga tuliya kumanta shinkwa. ");
INSERT INTO sby_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu walenshiba ncobalikwamba, neco walabepusheti, “Inga nipacebo cini ncomulambilingeti muliya shinkwa? Kucepa lushomo ndomukute mobantu amwe. ");
INSERT INTO sby_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mpaka pacino cindi mobantu amwe mucili mungubi? Sena nkamulanukunga kwambeti, ne shinkwa usanu, ndalalyesha bantu myanda makumi asanu? Inga mwalesusha mitanga ingaye ya byashalapo? ");
INSERT INTO sby_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Pacindi nacimo cisa ne shinkwa usanu ne ubili ndalalyesha bantu myanda makumi ana, inga mwalesusha mitanga ingaye ya byashalapo? ");
INSERT INTO sby_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Cilamwalilingeconi kwinshibeti, nkandambanga sha shinkwa? Kamucenjelani ne cishikufufumusha ca Bafalisi ne Basaduki.” ");
INSERT INTO sby_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Apa lino empobaleshibeti, Yesu nkalikwambeti bacenjele ne cishikufufumusha shinkwa, nsombi kwambeti bacenjele ne biyisho bya Bafalisi ne Ba saduki. ");
INSERT INTO sby_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu mpwalashika ku bibela bya Kaisaleya waku Filipi, walabepusha beshikwiya bakendi, “Inga bantu balambangeti Mwana Muntu niyani?” ");
INSERT INTO sby_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Balo balambeti, “Nabambi balambangeti Mwana Muntu ni Yohane mubatishi, nabambi eti Mwana Muntu ni Eliya nabambi, eti Mwana Muntu ni Yelemiya, nambi umo wa bashinshimi.” ");
INSERT INTO sby_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesu walabepusha beshikwiya bakendi, “Inga amwe, mukute kwambeti ame njame bani?” ");
INSERT INTO sby_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nendi Shimoni Petulo walakumbuleti, “Amwe njamwe Klistu, Mwanendi Lesa muyumi” ");
INSERT INTO sby_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Nendi Yesu walamwambileti, “Walelekwa njobe, Shimoni mwanendi Yona, pakwinga lakuyubulwili ici nte muntu sobwe, nsombi ni Bata balikwilu. ");
INSERT INTO sby_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ame ndambangeti, lino obe njobe Petulo, nomba palibwe lyacandanshi ili ninkebakepo mubungano. Kayi lufu nteti lukakomepo mubungano. ");
INSERT INTO sby_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ninkakupe makiyi akucalwisha Bwami bwakwilu, neco ncoti mukasungenga panshi pano, nicikasungwenga ne kwilu, kayi ibyo mbyoti mukasungululenga panshi pano, nibikasungululwenga ne kwilu.” ");
INSERT INTO sby_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yesu mpwalambeco walabambila beshikwiya eti, kabatambilanga bantu kwambeti endiye Klistu. ");
INSERT INTO sby_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kufuma cindico, Yesu walatatika kubeshibishila limo beshikwiya bakendi kwambeti, “Ndelela kuya ku Yelusalemu, uko bamakulene Baciyuda, ne bamakulene ba beshimilumbo, ne beshikwiyisha milawo ya Mose, nkoti bakampenshe cikamba. Nibakanshine, nsombi pabusuba bwa butatu kayi ninkapundushiwe kubuyumi.” ");
INSERT INTO sby_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petulo mpwalanyumfweco, walamumanta Yesu pambali ne kumukansa, walambeti, “Sobwe Nkambo, ici kacitenshika, Lesa katacisuminisha kwambeti cinshike,” ");
INSERT INTO sby_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nendi Yesu walacebuka ne kumukalalila Petulo mwangofu, walambeti, “Fumapa, Satana obe! Ulayandanga kuncimwisha! Kuyeya kwakobe nteko kwa Lesa sobwe, nsombi ni kwabuntu.” ");
INSERT INTO sby_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yesu mpwalambeco, beshikwiya bakendi walabambileti, “Muntu layandanga kukonka ame, alikane mwine, kayi alimantile mwine lusanda ankonke. ");
INSERT INTO sby_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Pakwinga layandanga kupulusha buyumi bwakendi nakabutaye. Nomba uyo latayanga buyumi bwakendi pacebo cakame, nakabucane. ");
INSERT INTO sby_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Inga nicani ncenga ucanapo, na muntu uba ne bintu byonse byapano pacishi, nomba nendi usomekapo kabeshi ne kutaya buyumi bwakendi? Anu muntu ngaubenga cani kwambeti alubule buyumi bwakendi?” ");
INSERT INTO sby_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Neco nditu Mwana Muntu lakesanga pamo ne bangelo bakendi mubulemu bwa Baishi. Popelapo nakabweshele muntu uliyense kwelana ne ncito shakendi. ");
INSERT INTO sby_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Cakubinga ndamwambilishingeti, popele pano mpobali nabambi beti bakabule kufwa, kabatana bamubona Mwana Muntu kesa mubulemu bwa Bwami. ");
INSERT INTO sby_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mpopalapita masuba asanu ne limo, Yesu walamantapo Petulo, Jemusi ne Yohane mukwabo, walatanta nabo pamulundu utali kwabonka. ");
INSERT INTO sby_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Lino cinso ca Yesu calasanduka kababona, cinso cakendi calabala tuu mbuli lisuba, ne byakufwala byakendi byalabeka mbee. ");
INSERT INTO sby_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Popelapo Mose ne Eliya balabonekela kulyendibo kababandika ne Yesu. ");
INSERT INTO sby_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Mpwalaboneco, Petulo walambila Yesu, kwambeti, “Nkambo, cilabacena kwambeti, mpotuli pano, anu na kamusuni, nitwibake mishasha itatu, umo wenu, naumbi wa Mose, naumbi ube wa Eliya.” ");
INSERT INTO sby_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Kacambeco likumbi lituba lyalesa kubafwekelela, umo mulikumbi mwalanyumfwika Liswi lyakwambeti, “Uyu e Mwaname ngonsuni, mulyendiye ndakondwa, Kamumunyumfwilani.” ");
INSERT INTO sby_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Mpobalanyumfweco, beshikwiya basa balatina kwine, balawa panshi cakufulumana. ");
INSERT INTO sby_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Nomba Yesu walesa kubekata, ne kwambeti, “Pundukani kamutaba ne buyowa.” ");
INSERT INTO sby_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nomba mpobalenamuka, paliya muntu ngobalabonapo sobwe, nsombi Yesu enka. ");
INSERT INTO sby_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mpobalikuseluka pa mulundu usa Yesu walabambileti, “Mbyomulabono mucimbonimboni, kamutaya mwambileko uliyense, mpaka Mwana Muntu akapundushiwe kubafu.” ");
INSERT INTO sby_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Beshikwiya basa balamwipusheti, “Inga nipacebo cini beshikwiyisha milawo ya Mose ncobakute kwambileti, Eliya ewelela kutanguna kwisa?” ");
INSERT INTO sby_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu walambeti, “Nicakubinga Eliya ewelela kutanguna kwisa kubamba bintu byonse. ");
INSERT INTO sby_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nomba ndamwambilishingeti, Eliya walesa kendi, bantu ebabula kumwingashila, nsombi balamwinshila bintu byonse mbyobalikuyanda kulyendiye. Nicimo cimo Mwana Muntu nendi nibakamupenshe.” ");
INSERT INTO sby_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Popelapo beshikwiya balenshibeti wambanga sha Yohane mubatishi. ");
INSERT INTO sby_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mpobalabwelela kusa kwalikuba likoto lyabantu, naumbi muntu walesa kusuntama kuli Yesu, ");
INSERT INTO sby_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","walambeti, “Nkambo kamumunyumfwilako nkumbo, mwaname ukute bulwashi bwa kashita, lapenge, cindi conse ukute kuwila pamulilo, ne pamenshi. ");
INSERT INTO sby_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ndanga ndesa nendi kuli beshikwiya benu aba, nomba balalilwa kumusengula.” ");
INSERT INTO sby_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu walambeti, “Ha! Amwe musemano wa bantu babula lushomo, bamiyeyo yalunkanwa, ninjikale nenu kushika cindi cini sena? Ndelela kulishishibisha kushika cindi citali cilyeconi sena? Kamumuletani kuno uyo mwana.” ");
INSERT INTO sby_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu walaukalalila mushimu waipa, popelapo walafuma mu mwana. Pacindi copeleco walaba cena. ");
INSERT INTO sby_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Panyuma pakendi beshikwiya balesa kuli Yesu pambali ne kumwipusheti, “Inga twalilwaconi afwe kupulisha mushimu waipa usa?” ");
INSERT INTO sby_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu walabakumbuleti, “Cebo cakendi ni cakwambeti lushomo lwenu nilung'ana, cakubinga ndamwambilishingeti, nambi lushomo lwenu kaluli nilung'ana mbuli kambuto ka katondo ka masitadi, nimukambile mulundu uwu eti, ‘Fumapa, koya uko,’ Mulunduwo nukafumepo, paliya cintu ceshi cikamwalilenga pimbi.” ");
INSERT INTO sby_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","“Kwambeti mupulishe mushimu wa mushobowu, mwelela nanshi kupaila ne kulikanisha kulya.” ");
INSERT INTO sby_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Mpobalabungana beshikwiya bonse ku Galileya, Yesu walabambileti, “Mwana Muntu lenga mu makasa abantu, ");
INSERT INTO sby_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","betibakamushine Nsombi pabusuba wabutatu nakapundushiwe.” Beshikwiya mpobalanyumfweco, balongumana. ");
INSERT INTO sby_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu ne beshikwiya bakendi mpobalashika ku Kapelenawo, beshikusonkesha musonko wa Ng'anda ya Lesa, balamwipusha Petulo, “Sena Shikwiyisha wenu Yesu, nkakute kusonkako musonko waku Ng'anda ya Lesa?” ");
INSERT INTO sby_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Nendi Petulo walambeti, “Ee, ukute kusonka.” Lino Petulo mpwalengila mung'anda katanamba ciliconse. Yesu walamwipusheti, “Obe Shimoni ulayeyenga cani? Inga bami bapano pacishi bakute kutambula misonko kufuma kuli bani,” Kubantu bamushobo wabo, nambi bensu? ");
INSERT INTO sby_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petulo walambeti, “Kubensu,” Nendi Yesu walamwambileti, “Anu nanico bantu bamushobo wabo nkabelela kusonkako sobwe. ");
INSERT INTO sby_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nomba kwambeti, katutabapesha nsoni baku Ng'anda ya Lesa, koya kulwenje kuya kulobola. Luswi ndoti utangune kulobola ulucenamune mulomo, nucanemo lyali, Ulimante uye usonke, kayi ne njame uye unsonkeleko.” ");
INSERT INTO sby_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Pacindi copeleco beshikwiya ba Yesu balesa kulyendiye nekumwipusheti, “Inga niyani eshakabe mukulene wapita bonse mu Bwami bwa kwilu?” ");
INSERT INTO sby_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu walakuwa mwana ne kumwimanika pakati pabo, ");
INSERT INTO sby_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ne kwambeti, “Cakubinga ndamwambilishingeti, mwabula kusanduka, ne kubeti mwana uyu, nteti mukengile mu Bwami bwa kwilu pimbi. ");
INSERT INTO sby_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ecebo cakendi muntu uliyense lalicepeshenga mbuli mwana uyu, epeloyo emukulene wapita, mu Bwami bwa kwilu. ");
INSERT INTO sby_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kayi uliyense latambulunga mwana ulyeti uyu pacebo cakame, endiye kayi lantambulunga.” ");
INSERT INTO sby_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Uliyense lapeshengeti umo wabana bakute lushomo muli njame kwambeti bapuntwe, celela kuba cena kumusungilila cilibwe camwampelo munshingo ne kumuwala mulwenje. ");
INSERT INTO sby_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Malele kubantu bapacishi capanshi pano, cebo cakufula kwabwipishi, Naboyo bwipishi nkabwelela kubula kuboneka, nomba malele kumuntu uyo lapeshengeti banendi bapuntwe. ");
INSERT INTO sby_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Lino na cikasa cakobe, nambi mwendo wakobe, ukute kukwipisha, kotimbula utaye, caina kuya kwingila ku buyumi koli watimbuka cikasa, nambi mwendo, kupita kuwalwa kumulilo utapu kokute makasa onse, nambi myendo yonse ibili. ");
INSERT INTO sby_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kayi na linso lyakobe lilakwipishinga, likolobolemo ulitaye, caina kuya kwingila ku buyumi kokute linso limo'wa, kupita kuwalwa mu Gehena kokute menso abili.” ");
INSERT INTO sby_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Cenjelani, kamutanyansha umo wa bana batwanike aba, cakubinga ndamwambilishingeti, bangelo bakwilu nkobali cindi conse pamenso a Bata bakwilu.” ");
INSERT INTO sby_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Mwana Muntu walesa kupulusha bantu bataika. ");
INSERT INTO sby_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Inga mwinseconi, na muntu kakute mbelele mwanda umo, imo itaika, sena nkelela kushiya mbelele shisa makumi asanu, ne ana, ne na shimbi shisanu ne shina mumilundu, ne kuya kulangaula imo isa ilataiki? ");
INSERT INTO sby_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ndamwambilinga cakubinga kwambeti, aicana ukute kusekelela kupita kusekelela ne shisa shilabulu kutaika. ");
INSERT INTO sby_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nicimo cimo Ba meshenu bakwilu nkabasuni kwambeti umo wabana batwanike aba ataike?” ");
INSERT INTO sby_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Na mwanse wakobe lakwipishili koya kulyendiye, wenga umuleshe cilubo cakendi, mubandike pambali mobabili, na mulanyumfwana ekwambeti ulamubweshe munshila, ");
INSERT INTO sby_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nomba na ubula kukunyumfwila, umantepo umo nambi babili, nambi batatu. kwambeti makani nakashininkishiwe ne bukamboni bwa bantu babili nambi batatu. ");
INSERT INTO sby_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Na naboyo ubula kubanyumfwila,wambileko bamubungano. Kayi na ubula kunyumfwila bamubungano, komubonangeti muntu wamishobo naimbi, nambi shimisonko.” ");
INSERT INTO sby_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Cakubinga ndamwambilishingeti, ciliconse ncoti mukasunge panshi pano, nicikasungwe kwilu, kayi ciliconse nceti mukasungulule panshi pano, nicikasungululwe kwilu. ");
INSERT INTO sby_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kayi cakubinga ndamwambilishingeti, mwanyumfwana mobabili pacishi capanshi, pakusenga cintu ciliconse, Bata bakwilu nibakamwinshile. ");
INSERT INTO sby_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Pali babili, nambi batatu balabungana mu Lina lyakame, ame mpondi pakati pabo.” ");
INSERT INTO sby_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Popelapo Petulo walesa kuli Yesu, ne kumwipusheti, “Nkambo, na mukwetu kapitilishowa kunjipishila, ngandimulekelela tunkanda tungaye? Sena nganshikisha tunkanda tusanu ne tubili?” ");
INSERT INTO sby_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu walamukumbuleti, “Sena ndambangowa tunkanda tusanu ne tubili, sobwe, nsombi tunkanda makumi asanu ne abili kufulisha tunkanda tusanu ne tubili.” ");
INSERT INTO sby_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Lino Bwami bwa kwilu tubwelanishe cisa. Palikuba mwami uyo walakuwa basebenshi bakendi kwambeti, abone cena nkongole nshobalikukute. ");
INSERT INTO sby_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mpwalatatika kubasesa, kwalacanika musebenshi naumbi walikukute nkongole ya mali angi akwana bina myanda myanda. ");
INSERT INTO sby_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mpwalalilwa kubwesha nkongole, Mwami walambeti, musebenshi usa aulishiwe ne mukashendi ne banabendi, ne bintu byonse mbyalikukute, kwambeti nkongole isa ipwe. ");
INSERT INTO sby_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Musebenshi usa walasuntama nekufulungana panshi pamenso pa mwami ne kukombeleleti, “Kamupembelelako pang'ana ninkabweshe nkongole yonse.” ");
INSERT INTO sby_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mwami usa walanyumfwila luse, ne kumulekelela nkongole yonse, ne kumusuminisheti, ayenga. ");
INSERT INTO sby_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Nomba uyu musebenshi mpwalapula, walakumanya musebenshi munendi walikumukutile nkongole ya mali akwana mwanda umo. Walamwikata mwabukalu ne kumutinga panshingo, ne kumwambileti, “Bwesha nkongole isa!” ");
INSERT INTO sby_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Musebenshi munendi usa walaliwisha panshi kumyendo yakendi ne kumukombeleleti, Kamupembelelako pang'ana, ninkabweshe nkongole njonkute kuli njamwe. ");
INSERT INTO sby_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nendi walakana kumulekelela, walamusungisha mujele, kushikila akabweshe nkongole. ");
INSERT INTO sby_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Basebenshi nabambi mpobalabona calenshika, balepilwa kwine. Neco balaya kumwambila mwami bintu byonse. ");
INSERT INTO sby_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mwami usa walamukuwa, ne kumwambileti, “Musebenshi waipa obe! Ame ndalakulekelela nkongole yonse mpowalankombelela. ");
INSERT INTO sby_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Sena nkowanga welela kumwinshila nkumbo ne kumulekelela munobe mbuli ame ncondakwinshila nkumbo ne kukulekelela?” ");
INSERT INTO sby_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Mwami usa walakalala, neco walamuwala mujele kwambeti bakamupenshe, kushikla akabweshe nkongole isa, ");
INSERT INTO sby_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesu walapwisha kwamba pakwambeti “Ici encoti bakense Bata bakwilu kuli umo ne umo, uyo utalekelele munendi ne moyo wonse.” ");
INSERT INTO sby_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu mpwalapwisha kwamba, walafumako ku Galileya, walaya mucibela ca Yudeya kutala kwa mulonga wa Yolodani. ");
INSERT INTO sby_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nomba likoto lya bantu lyalamukonkela, kopeloko walasengula balwashi bangi. ");
INSERT INTO sby_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Bafalisi nabambi balesa kuli Yesu pakuyanda kumutapa mukanwa pakumwipusheti, “Sena casuminishiwa mu Mulawo, muntu kuleka mukashendi pa cebo ciliconse?” ");
INSERT INTO sby_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nendi Yesu walabakumbuleti, “Sena nkamuna mubelengapo kwambeti kumatatikilo, Mulengi walabalenga mutuloba ne mutukashi?” ");
INSERT INTO sby_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Neco walambeti, “Ecebo cakendi mutuloba nakashiye baishi ne banyina, ne kuya kupamankana ne mukashendi, neco bantu babili aba nibakabeti mubili umo?” ");
INSERT INTO sby_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Neco nkabacilipo babili sobwe, nsombi mubili umo, palico Lesa ncalapamankanya pamo kapataba muntu shikupansanya. ");
INSERT INTO sby_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Basa Bafalisi balamwipusheti, “Inga Mose walambila cani kwambeti mutuloba welela kupa mukashendi cipepala cakumuleka?” ");
INSERT INTO sby_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu walabakumbuleti, “Mose walamusuminisha kuleka ba makashenu, pakwinga kumwiyisha amwe cayuma, nsombi kumatatikilo a cindi, nkacali kubeco sobwe” ");
INSERT INTO sby_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Lino ndamwambilishingeti, “Uliyense lalekenga mukashendi pacebo ciliconse, cabula kuba mulandu wabupombo, ne kuya kweba naumbi, ukute mulandu wabupombo.” ");
INSERT INTO sby_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Beshikwiya bakendi balamwambileti, “Anu nacilico pakati pa mulume ne mukashendi, cilicena kwikala bunkonta.” ");
INSERT INTO sby_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Nendi Yesu walabambileti, “Ciyisho ici nkacelela kutambulwa cena ne bantu bonse sobwe, nsombi abo bonka balapewa. ");
INSERT INTO sby_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Pali bintu bingi bikute kupa bantu kuteba batukashi, nabambi encobalasemwa, nabambi nicebo cakulakilwa kakowa pamukombo, pali nabambi balasala bene bonka kuteba kwambeti basebensele cena Lesa. Uyo welela kucikonsha kukonkela ciyisho ici, akonkele.” ");
INSERT INTO sby_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nabambi bantu balaleta bana babo kuli Yesu kwambeti abike makasa akendi palyendibo, ne kubapailila, nomba beshikwiya bakendi balabakalalila. ");
INSERT INTO sby_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Nomba Yesu walambeti, “Balekeni bana bese kuli njame, kamutabakanishanga sobwe, pakwinga Bwami bwakwilu ni bwa bantu bali mbuli aba.” ");
INSERT INTO sby_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Popelapo walabika makasa palyendibo, panyuma pakendi walafumapo. ");
INSERT INTO sby_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mutuloba naumbi walesa kuli Yesu ne kumwipusheti, “Bashikwiyisha, ni cipeyo cintu caina ncondelela kwinsa kwambeti nkacane buyumi butapu?” ");
INSERT INTO sby_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Nendi Yesu walamukumbuleti, “Inga ulanjipushilinga cani sha cintu caina pakwinga pali umowa Waina? Na usuni kucana buyumi butapu, konkela Milawo.” ");
INSERT INTO sby_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nendi walepusheti, “Milawo cini?” Yesu walakumbuleti, “Kotashina, kotapombola, kotaiba, kotapa bukamboni bwabwepeshi, ");
INSERT INTO sby_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","lemekesha baiso ne banyoko, kayi suna munobe mbuli ncolisuni omwine.” ");
INSERT INTO sby_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Usa muntu walambeti, “Milawo yonseyi ndalatatika kwikonkela kufuma kaindi, inga ncondicili ndabulilwa nicani kayi?” ");
INSERT INTO sby_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu walamwambileti, “Na ulayandanga kuba muntu walulama, koya ulishe bintu byonse mbyokute. Mali ngoshucanemo uyabile bapenshi, buboni bwakobe nukabucane kwilu, wapwisha kwinseco, wise unkonke.” ");
INSERT INTO sby_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Usa muntu mpwalanyumfwa maswi awo walafumapo kali wongumana mumoyo, pakwinga walikuba mubile cikamba. ");
INSERT INTO sby_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesu walambila beshikwiya bakendi, “Cakubinga ndamwambilishingeti, nicapatali ku muntu mubile kwingila mu Bwami bwakwilu.” ");
INSERT INTO sby_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kayi ndambangeti, “Nicapafupi munyama munene ukute kukwiweti ngamila kupita mukamulyango ka nyeleti, kupita muntu mubile kwingila mu Bwami bwa Lesa.” ");
INSERT INTO sby_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Beshikwiya mpobalanyumfweco, balakankamana ne kwambeti, “Anu na cilico, nomba niyani wela kupuluka?” ");
INSERT INTO sby_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu walabalangishisha walambeti, “Ibi nkabikonsheke ne bantu sobwe, nsombi bintu byonse bikute kukonsheka ne Lesa.” ");
INSERT INTO sby_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Popelapo Petulo walakumbulapo, “Afwe twalashiya bintu byonse ne kumukonkela, nomba afwe lino ni tukatambulepo cani?” ");
INSERT INTO sby_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Nendi Yesu walabakumbuleti, “Cakubinga ndamwambilishingeti, Lesa akabibambulula cena bintu byonse, Mwana Muntu nakekale pa Cipuna cakendi ca Bulemeneno ca Bwami, ne njamwe omulankonkelenga ni mukekale pa bipuna likumi ne bibili bya Bwami, kamombolosha mikowa likumi ne ibili ya Baislayeli. ");
INSERT INTO sby_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Neco uliyense walashiya ng'anda, bakwabo batuloba, nambi nkashi, nambi baishi, nambi banyina, nambi banabendi, nambi mabala pacebo cakame, uyo nendi nakatambule bingi byapita tunkanda mwanda, panyuma pakendi kayi nakapewe buyumi butapu. ");
INSERT INTO sby_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nomba abo pa cino cindi bali kuntangu nibakabe kunyuma, kayi abo bali kunyuma pacino cindi, nibakabe kuntangu.” ");
INSERT INTO sby_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Bwami bwa kwilu ngatubukoshanisha cisa. Muntu walanyamuka mumene mene kuya kulemba beshikusebensa mulibala lyakendi. ");
INSERT INTO sby_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Balasuminishana kubafolesha lyali limo lya silifa lyelela kufoleshewa pa busuba, nekubatuma kulibala lyakendi. ");
INSERT INTO sby_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Cindi ca muma 9 koloko walacana nabambi kabali bekala pamusena wa makwebo babula ncito. ");
INSERT INTO sby_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Naboyo walabambileti, “Ne njamwe kamuyani kulibala lyakame lya maila, nindimufoleshe mwakwelana.” ");
INSERT INTO sby_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Naboyo balaya. Cindi ca munshi, kayi ne cindi camuma 3 koloko mansailo. Muntu usa walalemba basebenshi nabambi ne kubatuma kulibala lyakendi lya maila. ");
INSERT INTO sby_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kayi camuma 5 koloko mansailo, walacana bantu nabambi kabali bekala. Walabepusheti, “Mwekalilacani lisuba lyonse kwakubula ncito?” ");
INSERT INTO sby_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Balo balamukumbuleti, “Paliya muntu latwingishiko ncito sobwe.” Naboyo walabambileti, “Ne njamwe kamuyani ku libala lyakame.” ");
INSERT INTO sby_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Mansailo lisuba kaliya kwibila, mwine libala walambila Kapitawo wakendi, “Bakuwe basebenshi bonse, ubafoleshe. Utatikile abo balengili ncito mu ma 5 koloko, basa batanguna kwingila ncito beti bashalilile.” ");
INSERT INTO sby_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Mpobalesa basa balengila ncito cindi ca 5 koloko mansailo uliyense walafola lyali limo lya silifa, lyelela kufeleshewa pa ncito ya busuba bumo. ");
INSERT INTO sby_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Lino mpobalesa basa balatanguna, balo balayeyeti nibafole mali angi, nomba uliyense walafola lyali limo lyelela kufoleshewa pa ncito ya busuba bumo. ");
INSERT INTO sby_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nomba nabo pakufola balatatika kutongaukila mwine libala, ");
INSERT INTO sby_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","balambeti, “Ha! Banetu balengili ncito lino lino, balasebensowa kwa ola limo, cilyeconi mulabafoleshe kwelana ne njafwe, kakuli afwe tulafu misana ne ncito, lumwi lulatupwili pamubili!” ");
INSERT INTO sby_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Nomba nendi mwine libala walamukumbuleti, “Obe ndo, ndiya kukwibilapo sobwe, sena ntetwalasuminishana lyali limo lya silifa pa busuba? ");
INSERT INTO sby_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Manta lyali lyakobe, koya. Njame ndemwine ndayeye kwambeti mfoleshe beshikushalila mwakwelanika nenjobe. ");
INSERT INTO sby_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Sena nkandasunguluka mwangofu pabintu byakame kwinsa mbuli mondayandilinga? Sena ulepilwa pakwinga ndaina moyo pakutasalulula pakufolesha?” ");
INSERT INTO sby_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Neco Yesu pakupwililisha walambeti, “Bakunyuma nibakabe kuntangu, kayi bakuntangu nibakabe kunyuma.” ");
INSERT INTO sby_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Pacindi Yesu mpwalikuya ku Yelusalemu, walabatwala palubasu beshikwiya bakendi likumi ne babili, ne kubambileti, ");
INSERT INTO sby_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ee, tuli pabulwendo bwakuya ku Yelusalemu, nomba kopeloko Mwa Muntu nakatwalwe kuba makulene beshimilumbo, ne beshikwiyisha milawo ya Mose. Nibakamomboloshe ne kusuminishaneti afwe, ");
INSERT INTO sby_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","kayi nibakamutwale kubantu bamishobo naimbi, beti bakamunyanshe, ne kumukwapula, ne kumupopa palusanda. Nomba pabusuba bwatutatu nendi nakapundushiwe kubafu.” ");
INSERT INTO sby_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Muka Sebedayo ne bana bendi babili balesa kuli Yesu, walasuntama ne kumusengeti abenshileko kantu kalikonse nketi basenge. ");
INSERT INTO sby_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu walamwipusheti, “Mulayandanga cani mama?” Uyu mutukashi walambeti, “Kamunshomeshesha kwambeti, banabame aba, umo akekale kucikasa cenu cakululyo, naumbi kucikasa cakucipiko mu Bwami bwenu.” ");
INSERT INTO sby_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Nomba nendi Yesu walakumbuleti, “Nkamucinshi ncomulasengenga, Sena ngamucikonsha kunwina pamo mu nkomeshi yamapensho njoti nwinemo?” Bonse balambeti, “Ee, ngatucikonsha.” ");
INSERT INTO sby_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu walambeti, “Ee, nimukanwe munkomeshiyo, nomba ame ndiya ngofu shakusala uyo eti akekale kucikasa cakame cakululyo, nambi kucikasa cakucipiko, Bata endibo beti bakape misena ilico kubantu abo mbobabambila.” ");
INSERT INTO sby_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Mpobalanyumfwako bali likumi basa, balakalalila basa babili pabukwabo. ");
INSERT INTO sby_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yesu walabakuwa beshikwiya bakendi bonse ne kubambileti, “Mucinsheti bendeleshi ba bantu ba mishobo naimbi bakute kulyela masuku pamitwi ya bantu babo, ne kubonesha ngofu shabo pabantu. ");
INSERT INTO sby_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nomba nkacelela kubeco pakati penu sobwe, pali njamwe uliyense layandanga kuba mukulene, abe musebenshi wenu.” ");
INSERT INTO sby_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","“Kayi uliyense layandanga kuba mutangunishi pakati penu, abe musha wenu. ");
INSERT INTO sby_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kamubani mbuli Mwana Muntu utasuni kusebenselwa, nsombi kusebensela bantu, ne kubenga buyumi bwakendi kulubula bantu bangi.” ");
INSERT INTO sby_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu ne beshikwiya bakendi mpobalikufuma mu munshi wa Yeliko, bantu bangi balikumukonkela. ");
INSERT INTO sby_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Bantu babili bashipilwa balikuba bekala mumbali mwa nshila balanyumfweti Yesu lapitinga munshila, balatatika kubilikisha, “Nkambo omwanendi Dafeti, kamutunyumfwilako nkumbo.” ");
INSERT INTO sby_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Basa bantu balayanda kubamweneka mwakubacancilila, nsombi balo empobalapitilisha kolobesha, “Nkambo omwanendi Dafeti, kamutunyumfwilako nkumbo.” ");
INSERT INTO sby_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu walemana, walabakuwa, ne kubepusheti, “Inga mulayandanga ndimwinshile cani?” ");
INSERT INTO sby_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Balo balakumbuleti, “Nkambo tulayandanga tutatike kubona.” ");
INSERT INTO sby_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu walabanyumfwila luse, walabekata pamenso, popelapo balatatika kubona, naboyo balamukonkela. ");
INSERT INTO sby_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Mpobalashika pepi ku Yelusalemu, balashika nanshi ku Betifage ku mulundu wa maolifi, Yesu walatuma beshikwiya bakendi babili, ");
INSERT INTO sby_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ne kubambileti, “Kamuyani mu munshi uwu ngomulabononga pantangu apa, mwaya mwengila, nimucane mbongolo wasungililwa pamo ne mwanendi, mu basungulule mubalete kuno.” ");
INSERT INTO sby_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Na muntu amwipushe, mumwambileti, “Mwami labayandanga, apwisha kubasebensesha nabalete.” ");
INSERT INTO sby_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","“Ici calenshika kwambeti maswi alamba mushinshimi akwanilishiwe, akwambeti, ");
INSERT INTO sby_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Kamwambilani munshi wa Siyoni kwambeti Kobona Mwami wakobe lesanga kulinjobe, Walicepesha, kayi watanta pa mbongolo. Watanta pa mwana mbongolo, nyama ishikumanta mitolo.” ");
INSERT INTO sby_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Popelapo beshikwiya balensa mbuli Yesu ncalabambila. ");
INSERT INTO sby_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Balaleta mbongolo pamo ne mwanendi, balayansa bikwisa pamusana pa mwanambongolo, uyo ngwalatantapo Yesu. ");
INSERT INTO sby_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bantu bangi balayansa bikwisa munshila, nabambi balakwakula misampi yabitondo ne kwiyansa munshila. ");
INSERT INTO sby_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Bantu bangi balikuba pantangu ne balikuba panyuma, balatatika kubilikisheti, “Hosana kuli Mwanendi Dafeti. Walelekwa uyo lesanga mu Lina lya Lesa, Hosana kuli Lesa wakwilu ku Mayoba.” ");
INSERT INTO sby_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu mpwalengila mu Yelusalemu, bantu bonse balakankamana, nabambi balikabepusheti, “Anu uyu niyani?” ");
INSERT INTO sby_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Bantu bangi balakumbuleti, “Uyu emushinshimi, Yesu waku Nasaleti, mucishi ca Galileya.” ");
INSERT INTO sby_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu walengila mu Ng'anda ya Lesa,ne kutandanyamo bantu bonse balikulisha ne kula. Walawishila panshi matebulu ngobalikulishilapo beshikushintanisha mali, ne bipuna bya beshikulisha nkulimba, ");
INSERT INTO sby_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Walabambileti, “Mabala alambangeti, ‘Ng'anda yakame nikabe yakupaililamo,’ Nomba amwe mulaisandulu kuba mwakuyubila bakabwalala.” ");
INSERT INTO sby_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Popelapo balema ne bashipilwa balesa kuli Yesu mu Ng'anda ya Lesa mopelemo, nendi walabasengula. ");
INSERT INTO sby_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Bamakulene beshimilumbo ne beshikwiyisha milawo ya Mose, mpobalabona byeshikukondwelesha mbyalensa kayi ne kunyumfwa batwanike mu ng'anda ya Lesa kababilikisheti, “Hosana kuli Mwanendi Dafeti,” Calabepila mu moyo. ");
INSERT INTO sby_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Neco, Yesu balamwipusheti, “Sena mulanyumfunga mbyobalambanga batwanike aba?” Nendi Yesu walabakumbuleti, “Ee, kanshi nkamuna mubelengapo Maswi alambangeti Lesa walabambilalimo batwanike ne bakateta kwambeti nibakamutembaule kwakupwililila?” ");
INSERT INTO sby_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Popelapo Yesu walabashiya, ne kuya ku Betani nkwalakona. ");
INSERT INTO sby_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mpobwalaca mumene mene, Yesu mpwalikubwelela ku Yelusalemu walanyumfwa nsala. ");
INSERT INTO sby_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Mpwalabona citondo ca mukuyu pepi ne nshila, walayapo, nomba walacana kacikutowa matewu. Popelapo walacambila citondo camukuyu, “citondobe, kufuma lelo nteti ukasemepo bisepo sobwe.” Cindi copeleco citondo camukuyu cisa calayuma nta. ");
INSERT INTO sby_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Beshikwiya mpobalaboneco balakankamana balamwipusha Yesu, “Inga citondo ca mukuyu ici cilafwambaneconi kuyuma?” ");
INSERT INTO sby_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu walakumbuleti, “Cakubinga ndamwambilishingeti na lushomo lwenu ntelo lwakutonshanya nimukacikonshenga kwinsa mbuli ncondenshili citondo ca mukuyu ici. Nteconkeco sobwe, nsombi na muwambila mulundu uwu, kwambeti, ‘Fuma apa, koya uliwale mu lwenje, mpaka nicikenshike.’ ");
INSERT INTO sby_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Na mupaila ne lushomo ciliconse nceti mukasenge nimukapewe.” ");
INSERT INTO sby_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Cindi Yesu ncalengila mu Ng'anda ya Lesa, ne kutatika kwiyisha, bamakulene beshimilumbo, ne bamakulene Baciyuda, balesa kumwipusheti, “Mwalashifunya kupeyo ngofu shakwinsa cisa? Niyani walamupa ngofu ishi?” ");
INSERT INTO sby_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Nendi Yesu walabakumbuleti, “ne njame nindimwipushe mwipusho umo, mwankumbula, bacu, nindimwambile nkondalafunya ngofu shakwinsa cisa. ");
INSERT INTO sby_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kwambeti Yohane abatishenga, ngofu walashifunya kupeyo, kuli Lesa nambi kubantu?” Balo balatatika kutotekeshana pa lwabo bene, “Natukumbuleti walashifunya kuli Lesa, nendi nambeti, inga mwalabulila cani kumushoma? ");
INSERT INTO sby_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nomba kayi natukumbuleti walashifunya kubantu, bantu nteti batulekepo sobwe, pakwinga balambangeti, Yohane nimushinshimi.” ");
INSERT INTO sby_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Neco balamukumbuleti, “Afwe nkatucishipo sobwe.” Nendi walambeti, “Anu ne njame nteti ndimwambilepo sobwe nkondalashicana ngofu shakwinsa cisa.” ");
INSERT INTO sby_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Amwe ngamuyeyapo aconi? Muntu naumbi walikukute bana batuloba babili. Walaya kumwanendi mukulene ne kumwambileti, ‘Mwaname, koya lelo usebense kumabala.’ ");
INSERT INTO sby_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Walakumbuleti ‘Sobwe nkasuni,’ Nsombi panyuma pakendi walalitibuka, walaya ku mabala kuya kusebensa. ");
INSERT INTO sby_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Baishi balaya kumwanabo kanike ne kumwambila maswi amo amo ngobalambila mwanabo mukulene. Nendi walambeti, ‘Ndanyumfu ta, ndenga kusebensa.’ Nsombi uliya kuyako. ");
INSERT INTO sby_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Pa bana babili aba walensa ncobalikuyanda baishi nupeyo?” Balo balambeti, “wakutanguna usa.” Yesu walabambileti, “Cakubinga ndamwambilishingeti, beshikusonkesha misonko ne batukashi bapombo balengilinga mu Bwami bwa Lesa, amwe kamutana. ");
INSERT INTO sby_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yohane Mubatishi walesa kumulesha nshila yabululami, amwe muliya kushoma sobwe, kakuli beshikusonkesha misonko, ne batukashi bapombo balo balamushoma, Amwe nambi mwalabibona, muliya kulitibuka kwambeti mumushome.” ");
INSERT INTO sby_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu walambeti, “Kamunyumfwani mukoshanyo naumbi, Muntu naumbi walikukute libala. Mulibalo'mo walabyalamo minyansa, walebaka luba kushinguluka libala lyonse, walaimba cisengu mwakutyanina minyansa, walaibaka lupingwe lwa kupembelelapo libala. Panyuma pakendi walalibwelekesha libala lisa ku balimi, nendi walaya bulwendo kucishi cimbi. ");
INSERT INTO sby_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Cindi cakutebula mpocalashika, muntu usa walatuma basebenshi bakendi ku balimi basa, kwambeti bamupeko bisepo bya mulibala lisa. ");
INSERT INTO sby_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Nomba balimi basa balabekata basebenshi basa, umo balamuma, naumbi balamushina, naumbi balamupwaya mabwe. ");
INSERT INTO sby_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Muntu usa walatumako basebenshi nabambi bangi kupita basa bakutanguna. Kayi balimi basa balabensa cimo cimo. ");
INSERT INTO sby_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kumapwililisho balimi basa walabatumina Mwanendi, ne kwambeti, ‘Mwaname uyu enka nibenga bamupe bulemu.’ ");
INSERT INTO sby_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nomba balimi basa mpobalamubona Mwanendi usa, balatatika kumufwiya, kabambeti, ‘uyu eshakapyane buboni bonse. Tiyeni tumushine kwambeti buboni ubu bukabe bwetu.’ ");
INSERT INTO sby_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Neco balamwikata, nekumuwala kunsa kwa libala ne kumushina.” ");
INSERT INTO sby_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Inga mwine libala lisa lya minyansa akesa nakabenseconi balimi basa?” ");
INSERT INTO sby_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Balo balakumbuleti, “Nakabashine balimi baipa basa, ne kulibwelekesha libala lisa kubalimi nabambi belela kumupako bisepo pacindi cakendi celela.” ");
INSERT INTO sby_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu walabepusheti, “Sena muliya kubelengapo Mabala alambangeti, ‘Libwe lyacandanshi ndyobalakana beshikwibaka,’ Elilaba libwe lya nkokola ya ng'anda lilayandikinga? Lesa mwine ewalacinseci, kayi cilatukankamanishi kucibona.” ");
INSERT INTO sby_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Encondamwambililingeti, “Bwami bwa Lesa, nibukalamunwe kulinjamwe ne kubupa bantu bambi abo belela kusema bisepo.” ");
INSERT INTO sby_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Uliyense eshakawile palibwe ili, nakapasauke pasauke. Uyo ngoshi likamuwile, nendi nakashanyaukilelimo. ");
INSERT INTO sby_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Bamakulene beshimilumbo, ne Bafalisi mpobalanyumfwa mikoshanyo njalikwamba Yesu, balenshibeti wambangendibo. ");
INSERT INTO sby_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Neco balayanda kumwikata nsombi balatina bantu, pakwinga bantu bangi balikuba bashometi, Yesu nimushinshimi. ");
INSERT INTO sby_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu walamba kayi mumikoshanyo ingi. Walambeti, ");
INSERT INTO sby_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Bwami bwakwilu bwakoshaneti, Mwami walabambila mwanendi malyalya a bwinga.” ");
INSERT INTO sby_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Walatuma basebenshi bakendi kuya kutamba bantu ku malyalya abwinga kwambeti bese, nsombi nabo balakana. ");
INSERT INTO sby_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Walatuma kayi nabambi, ne kubambileti, “Yani mwambile bonse basa balatambwa, kwambeti cakulya cilabambwa, ndashini ng'ombe, ne bombe bansuka, byonse bilabambwa, kamwisani ku malyalya abwinga.” ");
INSERT INTO sby_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nomba abo balatambwa baliya kuyako sobwe, bonse balaya kuncito shabo. Naumbi walaya kumabala kwakendi, naumbi walaya kumakwebo akendi. ");
INSERT INTO sby_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Nabambi balekata basebenshi basa, balabapensha ne kubashina. ");
INSERT INTO sby_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mwami walakalala kwine, walatuma bashilikali bakendi kuya kubashina basa bantu balikushina banabo, ne kubatentela munshi wabo. ");
INSERT INTO sby_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Panyuma pakendi walakuwa basebenshi bakendi ne kubambileti, malyalya abwinga alabambwa, nomba balatambwa basa nkabanga belela. ");
INSERT INTO sby_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","“Anu lino kamuyani mu mampambanya a nshila, mwenga mutambe balibonse mbweshi mucane, bese kumalyalya abwinga kuno.” ");
INSERT INTO sby_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Cakubinga basebenshi basa balaya munshila kuya kutamba balibonse mbobalikucana, baipa ne baina, ng'anda yalesula ne bantu. ");
INSERT INTO sby_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Mwami mpwalengila mung'andomo kuya kubona bantu balatambwa, walabonamo muntu naumbi wabula kufwala cakufwala capabwinga. ");
INSERT INTO sby_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Walamwipusheti, “Obe ndo, ulengili aconi muno wabula cakufwala capabwinga?” Nendi walabula cakukumbula. ");
INSERT INTO sby_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Mwami walambila basebenshi bakendi, “Musungeni kumyendo ne kumakasa, mu muwale kunsa mu mushinshe. Kopeloko nkweshi akalilenga ne kukokota meno.” ");
INSERT INTO sby_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Pakupwililisha Yesu walambeti, “Ee, batambwa nibangi, nsombi, balasalwa nibang'ana.” ");
INSERT INTO sby_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pacindi nacimbi, Bafalisi balapangana sha kumutapa mukanwa Yesu pakumwipusha mipusho. ");
INSERT INTO sby_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Balatuma beshikwiya babo nabambi, ne bamucipani candale ca Helode kuya kuli Yesu, balambeti, “Bashikwiyisha, tucishi kwambeti mukute kwamba cakubinga, mukute kwiyisha nshila ya Lesa mwakubinga, kayi nkamukute kutinapo muntu sobwe, nkamukute kuboneti uyu niyani.” ");
INSERT INTO sby_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Neco tulesa kwambeti mutwambileko ncomulayeyenga. “Sena Milawo ya Lesa yasuminisha kusonka musonko kuli Mwami waku Loma, nambi sobwe?” ");
INSERT INTO sby_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nomba Yesu pakwishiba miyeyo yabo yaipa, nendi walabepusheti, “Inga mulanjelekeshelenga cani, amwe bantu bandemi shibili? ");
INSERT INTO sby_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kamumboneshako lyali lyamusonko, nabo balamutambika lyali.” ");
INSERT INTO sby_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Popelapo walabepusheti, “Inga cinso ne lina ili lyalembwapa nilyabani?” ");
INSERT INTO sby_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Balo balamukumbuleti, “byonse bilipo nibya Mwami waku Loma.” Neco nendi Yesu walabambileti, “Anu mupeni Mwami waku Loma bintu byakendi, Mupeni Lesa bintu byakendi.” ");
INSERT INTO sby_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Bantu abo mpolabanyumfweco balapwilwa mano, balafumapo ne kumushiya. ");
INSERT INTO sby_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Pa busuba bopelobo nabambi Basaduki abo bakute kushometi bafwa nteti bakapunduke, balesa kuli Yesu, ne kumwipusheti, ");
INSERT INTO sby_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Bashikwiyisha, Mose walambeti, ‘Na mutuloba ufwa kwakubula kusemapo bana, mukwabo welela kumupyana mukalubingi ne kusemenamo bana beti bakabengeti banabendi usa mukwabo walafwa.’ ");
INSERT INTO sby_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Lino kucomwetu kwalikuba bantu basanu ne babili pabukwabo. Wakutanguna waleba mukashi, walafwa wabulapo mwana, mukashi usa walapyanwa ne mukwabo. ");
INSERT INTO sby_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Calenshika cimo cimo kuli wacibili walamupyana, kayi wacitatu walamupyana, mpaka kuli wacisanu ne cibili. ");
INSERT INTO sby_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pamapwililisho pakendi nendi mutukashi usa walafwa. ");
INSERT INTO sby_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Neco twambile inga lino pabusuba bwakupunduka bantu kubafu, mutukashi uyu, nakabe mukashi wabani, kakuli batuloba bonse basanu ne babili pabukwabo balamwebapo?” ");
INSERT INTO sby_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu walabakumbuleti, “Mwalubila, pakwinga nkamwayishi Mabala nambi ngofu sha Lesa. ");
INSERT INTO sby_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Pakwinga bantu beti bakapunduke kubafu, nteti bakebenga nambi kwebwa sobwe, bonse nibakabengeti bangelo bakwilu. ");
INSERT INTO sby_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nomba cakwambeti bantu nibakapunduke kubafu, sena muliya kubelengapo Lesa ncalamwambila amwe, mpwalambeti, ");
INSERT INTO sby_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ame njame Lesa wa Abulahamu, Lesa wa Isake, Lesa wa Yakobo.’ Anu uko ekwambeti, ni Lesa wa bantu bayumi, nteshi wa bantu bafwa sobwe.” ");
INSERT INTO sby_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Bantu bangi balikubapo mpobalanyumfweco balakankamana ne kwiyisha kwakendi. ");
INSERT INTO sby_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Bafalisi,mpobalanyumfweti Yesu, labatoteke Basaduki, balabungana pamo. ");
INSERT INTO sby_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Umo nkalakata shikwiyisha milawo ya Mose, walelekesha kayi kumutapa Yesu mukanwa pakumwipusheti, ");
INSERT INTO sby_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Bashikwiyisha, pa Milawo yonse ya Lesa, unenepo nupeyo?” ");
INSERT INTO sby_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Nendi Yesu walamukumbuleti, “Suna Mwami Lesa wakobe ne moyo wakobe wonse, ne buyumi bwakobe bonse, ne mano akobe onse.” ");
INSERT INTO sby_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Uwu emulawo unene kayi emulawo wakutanguna. ");
INSERT INTO sby_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Mulawo watubili niwa kwambeti, “Kosuna munobe mbuli ncolisuni omwine. ");
INSERT INTO sby_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Milawo yonse ya Mose, ne biyisho byonse mbyobalikwiyisha bashinshimi byona pa Milawo ibili iyi.” ");
INSERT INTO sby_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mpobalabungana pamo Bafalisi, Yesu walabepusha mwipusho. ");
INSERT INTO sby_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Walambeti, “mulayeyenga cani sha Mupulushi Walaiwa? Mulayeyengeti ni Mwana wabani?” Balo balambeti, “Ni mwanendi Dafeti,” ");
INSERT INTO sby_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu walabepusheti, “Inga ni pacebo cini Dafeti mwine pakutanguninwa ne Mushimu Uswepa, walamukuwa Mupulushi Walaiwa useti, Mwami wakendi? Walambeti, ");
INSERT INTO sby_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Mwami Lesa, walambila Mwami wakameti, Ikala kucikasa cakame cakululyo, mpaka nkabike balwani bakobe, kuba cakulyatapo myendo yakobe. ");
INSERT INTO sby_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Na Dafeti mwine walamukuwa Mupulushi Walaiwa eti, ‘Lesa wakame,’ Inga ngobeconi mwanendi?” ");
INSERT INTO sby_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Paliya nabaumo walelekesha kukumbulapo maswi. Kufuma busuba ubo, paliya muntu walaliyuminishako moyo kwambeti, amwipusheko naba mwipusho umo. ");
INSERT INTO sby_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Panyuma pakendi, Yesu walamba ku likoto lyabantu bangi, kayi ne kuli beshikwiya bakendi. ");
INSERT INTO sby_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Walabambileti, “Beshikwiyisha Milawo ya Mose ne Bafalisi bakute ncito ya kusansulula Milawo ya Mose.” ");
INSERT INTO sby_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ecebo cakendi mwelela kukonka byonse mbyobala mwiyishinga. kamutensanga mbyobalenshinga, pakwinga nkabakute kwinsa mbyobakute kwiyisha sobwe. ");
INSERT INTO sby_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Balo bakute kunyamwisha bantu mitolo yalema, njobatakumyuko ne kambombo kabo kunyamfwilisha kumanta mitolo. ");
INSERT INTO sby_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Bakute kwinsa bintu byonse kwambeti bantu bababone. Bakute kusungilila tukwisa tunene pankumo ne pamakasa twalembwapo maswi a Lesa! Bonani kutalimpisha mayombo kuminganjo yabo! ");
INSERT INTO sby_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kayi bakute kuyanda kwikala pa bipuna byabulemu pa misena yalemekeshewa ya malyalya, ne mu manda akupaililamo. ");
INSERT INTO sby_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Bakute kuyandeti bantu babapenga mitende yabulemu mu misena ya makwebo, ne kubakuweti, bashikwiyisha. ");
INSERT INTO sby_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nomba amwe bantu kabata mukuwangeti, bashikwiyisha sobwe, pakwinga mukute shikwiyisha umowa, mwense ni pabukwenu. ");
INSERT INTO sby_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kamutakuwanga muntu naba umo panshi pano eti, Ta, pakwinga amwe mukute ba Meshenu bamowa, Ba meshenu bakwilu. ");
INSERT INTO sby_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nabo bantu kabata mukuwangeti, batangunishi sobwe, pakwinga mutangunishi wenu ni Klistu umowa. ");
INSERT INTO sby_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Pakati penu mukulene abe musebenshi wenu. ");
INSERT INTO sby_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ee, uyo lalisumpulunga mwine, nakacepeshewe, uyo lalicepeshenga nakasumpulwe. ");
INSERT INTO sby_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Malele kulinjamwe beshikwiyisha Milawo ya Mose, ne njamwe Bafalisi, bantu bandemi shibili! Mulacalanga cishinga pa menso abantu caku Bwami bwakwilu.Pakwinga mucinsheti nteti mukenglemo, neco mulashinkilishinga bantu balayandanga kwingilamo.” ");
INSERT INTO sby_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Malele kulinjamwe beshikwiyisha Milawo ya Mose, ne njamwe Bafalisi, bantu bandemishibili! Mukute kubebila bamukalubingi, kubalyela buboni bwabo, pakubanyengelela ne mipailo yenu itali itali. Pacebo ico Lesa nakamomboloshe mwangofu.” ");
INSERT INTO sby_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Malele kulinjamwe beshikwiyisha Milawo ya Mose, ne njamwe Bafalisi, bantu bandemishibili! Mukute kwenda nyendo shingi pa lwenje ne pamutunta, kulangaula muntu umo kwambeti mu musandule abe shikwiya wenu. Nomba kayi mwa mucana, mukute kumusandula tunkanda tubili kuba welela Gehena, kupita amwe mobene.” ");
INSERT INTO sby_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Malele kulinjamwe, batangunishi bashipilwa! Amwe mukute kwiyisheti, muntu alumbileti, pa Ng'anda ya Lesa, ciliya mulandu, nsombi na ulumbileti, pamali ali mu ng'anda ya Lesa, uyo welela kusunga kulumbila kwakendi. ");
INSERT INTO sby_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Amwe bantu bapusa, kayi bashipilwa! Cinene nicipeyo, mali nambi Ng'anda ya Lesa iyo ikute kusandula mali kuba aswepa? ");
INSERT INTO sby_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kayi mukute kwambeti, Muntu alumbileti, panteme ya milumbo, ciliya mulandu, Nsombi na ulumbileti, pa cishikubengwa panteme, uyo welela kusunga kulumbila kwakendi. ");
INSERT INTO sby_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Amwe bantu bashipilwa! Cinene nicipeyo, cisa cishikubengwa nambi nteme ya milumbo iyo ikute kusandula cishikubengwa kuba caswepa? ");
INSERT INTO sby_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Neco, muntu alumbileti, panteme ya milumbo, ekwambeti lalumbilili kumo ne byonse bili panteme. ");
INSERT INTO sby_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Alumbileti, pa Ng'anda ya Lesa, ekwambeti lalumbilili kumo ne Ng'andeyo pamo ne Lesa ukute kwikalamo. ");
INSERT INTO sby_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kayi Alumbileti, mbuli kwilu, lalumbili pa Cipuna ca Bwami bwa Lesa, kubikapo ne uyo wekala pa Cipuna. ");
INSERT INTO sby_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Malele kulinjamwe beshikwiyisha Milawo ya Mose, ne njamwe Bafalisi, bantu bandemi shibili! Mukute kubenga ca likumi ca tumbuto twanunkila, twakubika mucakulya, nsombi mukute kusula Milawo ya Lesa yancine ncine, mbuli kombolosha kwalulama ne nkumbo kayi ne kushomeka. Mwanga mwelela kwinseco, kutashiyapo nabimbi sobwe. ");
INSERT INTO sby_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Amwe batangunishi bashipilwa, mukute kufunya shikanshi lawili momulanunga, nsombi mukute kumina munyama munene ukute kukwiweti ngamila.” ");
INSERT INTO sby_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Malele amwe beshikwiyisha Milawo ya Mose, ne njamwe Bafalisi, bantu bandemi shibili! Mukute kusuka kunsa kwa nkomeshi ne mbale, kakuli mukati mwesula bukuma ne kuliyanda. ");
INSERT INTO sby_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Amwe Ba falisi bashipilwa, tangunani nanshi kusuka mukati munkomeshi ne mbale, mpweshi musuke kunsa.” ");
INSERT INTO sby_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Malele kulinjamwe beshikwiyisha Milawo ya Mose, ne njamwe Bafalisi, bantu bandemi shibili! Mulyeti manda ashibululwa ne laimu akute kuboneka cena kunsa, kakuli mukati mwesula mafupa abantu bafwa ne bintu bingi byabola. ");
INSERT INTO sby_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ne njamwe ncomubele pamenso abantu mukute kuboneketi mwalulama, kakuli mukati mwenu mwesula bundenga mano ne bintu byaipa.” ");
INSERT INTO sby_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Malele kuli njamwe beshikwiyisha Milawo ya Mose, ne njamwe Bafalisi, bantu bandemi shibili! Mukute kubamba cena manda abashinshimi bakulu kulu, ne kushibulula bibumbwanya bya bantu balulama. ");
INSERT INTO sby_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mukute kwambeti, ne twalikubako pacindi ncobalikubako bamashali betu bakulu kulu, nshinga ne twalabula kumantako lubasu pakushina basa bashinshimi. ");
INSERT INTO sby_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nomba mulalisungunga mobene, pakwinga mulasuminingeti, mobashikulu ba bantu abo balashina bashinshimi. ");
INSERT INTO sby_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ee, lino kamupwishani ncito njobalatatika bamashali benu bakulukulu.” ");
INSERT INTO sby_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Mwenjoka amwe, bana bampili, ni mukayubeconi lombolosho lwa Gehena? ");
INSERT INTO sby_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Lino kamunyumfwani! Ni nkamutumine bashinshimi, ne bantu bamano, ne beshikwiyisha. Nabambi ni mukabashine ne kubapopa pa nsanda, nabambi ni mukabakwapule bikoti mu manda enu akupaililamo, kayi ni mukabapenshe ne kubatandanya kufuma pamunshi umo ne umo. ");
INSERT INTO sby_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Neco nimukacanike ne mulandu wabantu bonse balulama balashinwa pacishi capanshi, kufumina pakushinwa kwa Abele, muntu walulama, mpaka pa kushinwa kwa Sakaliya mwanendi Balakiya, uyo ngomwalashinina mu Ng'anda ya Lesa pakati pa nteme ya milumbo, ne Musena wa Swepeshesha. ");
INSERT INTO sby_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Cakubinga ndamwambilingeti, lombolosho lulico nebintu byonse nibikenshike mu musemano uwu.” ");
INSERT INTO sby_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ha! Obe Yelusalemu, Yelusalemu! Weshikushina bashinshimi, ne kupwaya mabwe bantu Lesa mbwalakutumininga. Ndayandanga kufukatila pamo banabobe tunkanda tungaye, mbuli nkuku ncekute kufukatila twana twayo mu mapepe akendi, nsombi obe ulakana! ");
INSERT INTO sby_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Cakubinga kamubonani nomba, ng'anda yenu ineneyi nibe matongo. ");
INSERT INTO sby_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kayi ndamwambilishingeti,kufuma cindi cino nteti mukambonepo sobwe, mpaka cindi ncoti mukambeti, “Walelekwa uyo lesanga mu Lina lya enka bulyo walibela.” ");
INSERT INTO sby_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu walapula mu Ng'anda ya Lesa,lino mpwalikuya beshikwiya bakendi balamulesha ncoyalebakwa mwabuya Ng'anda iyo. ");
INSERT INTO sby_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Nomba Yesu walabambileti, “Ee mulabono ibi byonse, nomba cakubinga ndamwambilingeti, paliya libwe lyeti likashale palibwe linendi,lyeti likabule kupwayaulwa.” ");
INSERT INTO sby_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Lino Yesu mpwalekala panshi pa mulundu wa maolifi, beshikwiya bakendi balesa kulyendiye palubasu bonka ne kumwipusheti, “Kamutwambilako, inga ibi nibikenshike lilyoni? Kayi nicani ceshi cikenshikenga nceti tukaboneneko kwisa kwenu, kayi ne cakupwa kwacindici?” ");
INSERT INTO sby_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu walabakumbuleti, “Cenjelani, kamutakabepwa ne muntu uliyense sobwe. ");
INSERT INTO sby_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bantu bangi nibakese mulina lyakame! Kabambeti, ‘Klistu usa njame,’ Nibakabepe bantu bangi. ");
INSERT INTO sby_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nimukanyumfwe nkondo, kayi ne mbili shiyosha nkondo. Nomba amwe kamutaka yakamwa, Ee, ibi byela kwinshika, nsombi uku nteko kwambeti mapwililisho nawo alashiki kendi sobwe.” ");
INSERT INTO sby_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","“Pakwinga mishobo ya bantu nikabukilane, nabo bwami nibikalwanenga ne bwami. Nikukabe nsala, ne bikunkumo bishikutenkanya inshi mu misena ingi, ");
INSERT INTO sby_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nomba ibi byonse nicitatikowa ca mapensho.” ");
INSERT INTO sby_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Bantu nibakamusunge ne kumupensha kayi ne kumushina. Bantu bamishobo yonse nibakamupele pacebo ca Lina lyakame. ");
INSERT INTO sby_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Bantu bangi pacindico nibakaleke kushoma, nibakatatike kupelana ne kulishana pamukowa wabo bene. ");
INSERT INTO sby_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nikukaboneke bashinshimi bandemishibili beti bakabepe bantu bangi. ");
INSERT INTO sby_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Pacebo cakufula kwabintu byaipa, lusuno lwabantu bangi nilukacepe. ");
INSERT INTO sby_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nsombi uyo eshakalimbikile mpaka kumapwililisho, endiyeti akapuluke. ");
INSERT INTO sby_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nomba Mulumbe Waina uwu wa Bwami bwa Lesa nukakambaukwe pacishi capanshi conse, kwambeti, ube bukamboni kubantu ba mishobo yonse, popelapo mapwililisho nakashike.” ");
INSERT INTO sby_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Mwakabona cintu cishikusesemya cishikononga, calambwa ne Danyele mushinshimi, balacimaniki pa musena waswepa.” Obe ulabelengenga unyumfwishishe cena. ");
INSERT INTO sby_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Abo bali mu Yudeya bela kufwambila kumilundu. ");
INSERT INTO sby_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Uyo uli pelu pa ng'anda yakendi kataseluka kuya kwingila mu ng'anda eti amantemo bibya byakendi. ");
INSERT INTO sby_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Uyo uli kumabala, kataya kumunshi kuya kumanta cakufwala cakunsa. ");
INSERT INTO sby_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","“Malele ku batukashi beti bakabenga ne mabunda, kayi ne batukashi beti bakayamwishenga bana mumasubayo. ");
INSERT INTO sby_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Pailani kwambeti cindi cakufwamba kacitakaba cindi camupewo, nambi pa busuba bwa Sabata sobwe. ");
INSERT INTO sby_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Pakwinga mapensho ayosha eti akaboneke mu masubayo, nkanabonekapo kufuma mpocalalengelwa cishi capanshi mpaka lelo, kayi nteti akabonekepo sobwe. ");
INSERT INTO sby_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nomba masubayo nalabula kufumfwipishiwa, nshinga ne palakabulu muntu nabaumo shikupuluka. Nsombi Lesa nakafumfwipishiwe masubayo pacebo cabantu mbwalasala.” ");
INSERT INTO sby_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Cindico na muntu akamwambileti, ‘Klistu ulikuno!’ Nambi ‘uli uko!’ Kamutakamushoma sobwe. ");
INSERT INTO sby_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Pakwinga nikukaboneke baklistu ne bashinshimi bangi bandemishibili, beti bakambengeti, Kamubonani ‘Njame Klistu,’ Nambi kwambeti ‘njame mushinshimi,’ Abo bantu nibakensenga bintu byangofu, bishikukankamanisha, kwambeti babepe uliyense na kacikonsheka nambi basalwa ba Lesa.” ");
INSERT INTO sby_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kamunyumfwani, ame ndamwambilili limo. ");
INSERT INTO sby_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ecebo cakendi, bantu bakamwambilangeti, ‘Kamubonani Klistu ulikucinyika,’ Kamutakayako sobwe, nambi bakambeti, ‘uli mu ng'anda,’ Kamutakashoma sobwe. ");
INSERT INTO sby_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kwisa kwa Mwana Muntu nikukabeti kubyasha kwa lulabo ulo lukute kubyasha kufuma kucwe mpaka ku mbonshi.” ");
INSERT INTO sby_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Walambeti, “kulikonse kuli mutunta wanyama yafwa, makubi nkwakute kubungana.” ");
INSERT INTO sby_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Panyuma pakendi mapensho akapwa mu masubayo, lisuba nilikashipe mbi, nawo mwenshi nukacileke kubala, nyenyenshi nishikalake kufuma ku makumbi, kayi ngofu sha mu mulengalenga nishikatenkane. ");
INSERT INTO sby_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Popelapo citondesho cakwisa kwa Mwana Muntu, nicikaboneke kwilu. Bantu bapacishi capanshi pano, ni bakatatike kulila, nibakabone Mwana Muntu kesa mu makumbi akwilu ne ngofu ne bulemeneno buyosha. ");
INSERT INTO sby_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tolompita yangofu nikalile, popelapo nendi nakatume bangelo bakendi ku mbasu shonse shapacishi capanshi, kuya kubunganya basalwa bakendi. Kufuma kumapwililisho acishi, kushika kumapwililisho acishi.” ");
INSERT INTO sby_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Kamulangani kucitondo ca mukuyu kwambeti mwiyeko ciyo. Mwabona misampi yakendi ne matewu atatika kusonsa, mukute kwinshibeti, mainsa alipepi. ");
INSERT INTO sby_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ne njamwe mwakatatika kubona bintu ibi mbyondambanga, mukenshibeti Mwana Muntu ulipepi, cakubinga uli pa cishinga. ");
INSERT INTO sby_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Kamwinshibani kwambeti bintu ibi nibikenshike bantu bamusemano uno kabata bapwa bonse. ");
INSERT INTO sby_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kwilu ne cishi capanshi nibikapwe, nomba maswi akame nteti akapwe.” ");
INSERT INTO sby_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Nambi kubeconi, paliya ubwishi busuba ne cindi, nambi bangelo bakwilu nkabacishipo, ne njame Ndemwana nkandicishipo sowe, nsombi Bata bonka ebaci shi. ");
INSERT INTO sby_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kwisa kwa Mwana Muntu nikukabeti ncokwalikuba mucindi ca Nowa. ");
INSERT INTO sby_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Mu masubayo, muyoba wa mfula ya cilobe kautana ushika, bantu balikulya ne kunwa, bali kweba ne kwebwa, mpaka busuba mbwalengila Nowa mubwato. ");
INSERT INTO sby_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Paliya ncobalikwinshiba sobwe, mpaka muyoba wamfula yacilobe yalesa kubashina bonse. Encoti cikabe pakwisa kwa Mwana Muntu. ");
INSERT INTO sby_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Pacindi copeleco bantu babili nibakacanike mulibala, umo nakamantwe, naumbi nakashale. ");
INSERT INTO sby_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Batukashi babili nibakacanike kabapela bunga ne mwampelo, umo nakamantwe, naumbi nakashale.” ");
INSERT INTO sby_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Ne njamwe kamubani mwalibambila cindi conse, pakwinga nkamubwinshipo busuba mboti akese Mwami wenu. ");
INSERT INTO sby_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nomba kamwishibaneti, mwine ng'anda nakute kwinshiba kwambeti nicindi cini camashiku ncalesanga kabwalala, nshinga nakute kalebe, kwambeti kabwalala katesa aibe mung'anda. ");
INSERT INTO sby_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Neco, kamubani balibambila, pakwinga Mwana Muntu nakese pacindi ncomwabula kwingashila.” ");
INSERT INTO sby_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Inga niyani, musebenshi washomwa, kayi ukute mano? Uyo ngwalapa ncito Mwami wakendi yakwendelesha cena, ne kubapa cakulya basebenshi banendi pacindi celela? ");
INSERT INTO sby_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Walelekwa musebeshuyo, na kamucane Mwami wakendi kasebensa cena. ");
INSERT INTO sby_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Cakubinga ndamwambilishingeti, Mwami wakendi nakamupe ncito yakwendelesha byonse bintu mbyakute.” ");
INSERT INTO sby_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Nsombi na ni musebenshi waipa, nendi nakayeyeti, ‘Mwami wakame lacelwa cindi citali’ ");
INSERT INTO sby_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Neco nakatatike kubauma basebenshi banendi, kulya ne kunwa pamo ne bacakolwa. ");
INSERT INTO sby_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Pabusuba ne cindi ncabula kwingashila, Mwami wakendi nakashike sokoloku! ");
INSERT INTO sby_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Neco Mwami wakendi na kamutimbaule, ne kumuwala uko kuli bantu bandemi shibili. Kopeloko eti kubenga kulila ne kukokota meno.” ");
INSERT INTO sby_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Pacindico Bwami bwakwilu nibukabeti calenshika ku balindu likumi, balamanta malampi abo ne kumucinsha shibwinga. ");
INSERT INTO sby_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Basanu balikuba bapusa kayi nabambi basanu balikuba bacenjela. ");
INSERT INTO sby_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Basa basanu bapusa, balamanta malampi abo kwakubula kumantako mafuta apalubasu. ");
INSERT INTO sby_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Basa bacenjela basanu, balo balamantilila mafuta apalubasu munsupa shabo akuya kwisusha malampi. ");
INSERT INTO sby_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nomba shibwinga usa walacelwa, neco bonse balatatika kushinshila, balona tulo.” ");
INSERT INTO sby_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Pakati pamashiku, kwalanyumfwika maswi abantu balikubilikisheti, ‘Shibwinga uyo lesanga! Pulani mwenga mumutambule!’ ");
INSERT INTO sby_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Lino balindu basa likumi balapunduka, ne kutatika kubamba cena malampi abo. ");
INSERT INTO sby_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Basa basanu bapusa, balatatika kusenga mafuta ku banabo bacenjela, ‘Kamutupako mafuta, malampi etu alashimikinga.’ ");
INSERT INTO sby_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Lino basa bacenjela balakumbuleti, ‘Bacu! Mulayandanga ne njafwe mafuta atupwile twamuyabilako, amwe kamuyani mule mafuta kuli beshikulisha.’ ");
INSERT INTO sby_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Pacindi cindi ncobalafumapo kuya kula mafuta, nendi shibwinga walashika. Basa balindu basanu balikuba balibambila, balengila pamo mu ng'anda ya malyalya abwinga, ne cisasa calacalwa. ");
INSERT INTO sby_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Panyuma pakendi balindu basanu bapusa basa balesa, balambeti, ‘Nkambo! Nkambo! kamutucalwilako.’ ");
INSERT INTO sby_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Nomba shibwinga walakumbuleti, ‘Kumwambila cakubinga, nkandimwishipo sobwe.’ ” ");
INSERT INTO sby_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesu pakupwililisha walambeti, “Amwe kamubani balibambila, pakwinga nkamubwishi busuba, nambi ola lyakwisa kwakendi.” ");
INSERT INTO sby_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Bwami bwakwilu tubwelanike cisa, muntu naumbi walaya pabulwendo. Katananyamuka walakuwa basebenshi bakendi, ne kubashiyila ngofu shakwendelesha buboni bwakendi. ");
INSERT INTO sby_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Walapa uliyense mbuli ncelela kukonsha, naumbi walamupa mali amukuba myanda makumi asanu, naumbi myanda makumi abili kayi naumbi myanda likumi. Nendi walafumapo. ");
INSERT INTO sby_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Musebenshi usa walapewa mali myanda makumi asanu, walacaninapo kayi mali apelu akwana myanda makumi asanu. ");
INSERT INTO sby_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nendi usa walapewa mali myanda makumi abili, walacaninapo kayi mali apelu akwana myanda makumi abili. ");
INSERT INTO sby_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nomba usa walapewa mali myanda likumi, walemba cisengu ne kwafumbika mali asa ngalapewa ne mwami wakendi.” ");
INSERT INTO sby_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Mpopalapita cindi citali, mwami usa walabwela, walabakuwa basebenshi bakendi bonse, kwambeti bamwambile mobalasebenseshela mali asa. ");
INSERT INTO sby_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Usa musebenshi walapewa mali myanda makumi asanu, walaletelapo kayi mali ali myanda makumi asanu, ne kwambeti “Mwami ‘pamali asa ngomwalampa ndacaninapo kayi mali akwana myanda makumi asanu.’ ");
INSERT INTO sby_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Mwami wakendi walamwambileti, wensa cena, njobe musebenshi waina washomeka, lino pacebo cakuba washomeka pabintu bing'ana, nindikupe lino ncito yakwendelesha bintu bingi. Kwesa usamwe pamo nenjame ndemwami wakobe. ");
INSERT INTO sby_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Nendi musebenshi usa walapewa mali akwana myanda makumi abili, walaletelapo mali ali myanda makumi abili ne kwambeti, mwami pamali asa ngomwalampa ndacaninapo kayi mali akwana myanda makumi abili. ");
INSERT INTO sby_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Mwami wakendi walamwambileti, ‘Wensa cena, njobe musebenshi waina washomeka, lino pacebo cakuba washomeka pabintu bing'ana, nindikupe ncito yakwendelesha bintu bingi. Kwesa usamwe pamo nenjame ndemwami wakobe.’ ");
INSERT INTO sby_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Nendi musebebenshi walapewa mali myanda likumi, walambeti, ‘Nkambo ndacishibangeti mwaipa moyo, mukute kutebula nkomwabula kubyala, ne kuyobolola nkomwabula kumwaya mbuto. ");
INSERT INTO sby_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Neco ndatinanga, encondalafumbikila mucisengu mali enu, nomba ntawa mali enu.’ ");
INSERT INTO sby_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Mwami wakendi usa walamwambileti, njobe musebenshi waipa, kayi mutolo. Anu wacishibangeti, nkute kutebula nkondalabula kubyala ne kuyobolola nkondalabula kumwaya mbuto. ");
INSERT INTO sby_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Neco wanga welela kuya kwibikisha ku banki kwambeti mpondesa ne ndatambulu mali ne bwili. ");
INSERT INTO sby_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Lino mulamuneni awo mali, mupe uyo ukute mali myanda makumi mwanda. ");
INSERT INTO sby_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ecebo cakendi uliyense ukuteko cintu, nibaka mubikilepo nabimbi, neco nakabe ne bintu bingi. Nomba uyo wabulapo cintu, nibaka mulamune nakaba kantu nkakute. ");
INSERT INTO sby_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Musebenshi uyu waipa wabula ncito, muwaleni kunsa mu mushinshe, uko eti kukabenga kulila ne kukokota meno.” ");
INSERT INTO sby_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Cindi Mwana Muntu akesanga kali Mwami, pamo ne bangelo bonse, nakekale pa cipuna cabwami cakendi ca Bulemeneno. ");
INSERT INTO sby_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nakabunganye bantu bamishobo yonse pantangu pakendi. Nakapansanyenga bantu mbuli mwembeshi ncakute kupansanya mbelele ne mpongo. ");
INSERT INTO sby_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mbelele nakashibikenga kucikasa cakendi ca kululyo, mpongo kucikasa cakendi ca kucipiko. ");
INSERT INTO sby_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Neco, Mwami nakambile abo bali kucikasa cakululyo, ‘Kamwisani kuno amwe mwalelekwa ne Bata! Kamwingilani mu Bwami mbwalamubambila kufuma pakulengwa kwacishi capanshi.’ ");
INSERT INTO sby_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Pakwinga ndalanyumfwa nsala mwalampa cakulya. Ndalanyumfwa nyotwa, mwalampa menshi akunwa. Ndalikuba mwensu, mwalantambula kung'anda kwenu. ");
INSERT INTO sby_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ndalikuba matakosha, mwalamfwalika. ndalakolwa mwalanyamfwilisha. Ndalikuba mujele, mwalesa kumbona.” ");
INSERT INTO sby_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Popelapo balulama nibakepusheti, ‘Nkambo twalamubona kupeyo kamunyumfwa nsala, afwe ne kumupa cakulya nambi kamunyumfwa nyotwa, afwe ne kumupa menshi akunwa. ");
INSERT INTO sby_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Twalamubona lilyoni kamuli bensu, afwe ne kumutambula kumanda etu, nambi kamuli matakosha, afwe ne kumufwalika? ");
INSERT INTO sby_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ni lilyoni mpotwalanyumfwapo eti mulakolwanga, nambi eti muli mujele, afwe ne kwisa kumubona? ");
INSERT INTO sby_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mwami na kabakumbuleti “Cakubinga ndamwambilishingeti, mpomwalikwinshila ibi kubanse bakame babula ncobabelepo, mwalikwinshila ame ndepele.” ");
INSERT INTO sby_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Panyuma pakendi Mwami nakambile bali kucikasa cakucipiko, “Kamufumapa, amwe bashinganwa! Kamuyani kumulilo utapu uyo Lesa ngwabambila Muyungaushi ne bangelo bakendi baipa abo balapandukila Lesa! ");
INSERT INTO sby_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ndalikunyumfwa nsala, muliya kumpa cakulya. Ndalikunyumfwa nyotwa, muliya kumpa menshi akunwa. ");
INSERT INTO sby_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ndalikuba mwensu muliya kuntambula kumanda enu, ndalikuba matakosha, muliya kumfwalika. Ndalikukolwa, kayi ndalikuba mujele, muliya kwisa kunyamfwilisha.” ");
INSERT INTO sby_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Balo ni bakambeti, “Nkambo, Inga nililyoni mpotwalamubona kamumfwa nsala, nambi kamunyumfwa nyotwa, nambi kamuli matakosha. Twalanyumfwapo lilyoni eti mulakolwanga, nambi eti muli mujele afwe twalakana kumunyamfwilisha? ");
INSERT INTO sby_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Nendi Mwami nakabakumbuleti, ‘Cakubinga ndamwambilishingeti, pacindi ncomwalikukana kunyamfwa banse bame babula ncobabelepo, mwalikukana kunyamfwa ame.’ ");
INSERT INTO sby_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Popelapo nibakenga cisubula citapu, balo balulama kabaya kubuyumi bwamuyayaya.” ");
INSERT INTO sby_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu mpwalapwisha kubeyisha makani awa, walabambila beshikwiya bakendi eti, ");
INSERT INTO sby_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mucinshi cena kwambeti papita masuba abili, kusekelela kwa Pasika nikutatike, neco Mwana Muntu nakatwalwe kuya kupopwa.” ");
INSERT INTO sby_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Pacindi copeleco, bamakulene beshimilumbo, ne bamakulene Baciyuda, balabungana mu ng'anda ya Mukulene wa Beshimilumbo bonse, lina lyakendi Kayafa. ");
INSERT INTO sby_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Balikupangana mobelela kumwikatila Yesu kwakubula nabambi kwinshiba ne kumushina. ");
INSERT INTO sby_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nsombi balikwambeti, “Nkatwelela kumwikata mumasuba akusekelela Pasika sobwe, pakwinga ngapaba minyungwe pakati pabantu.” ");
INSERT INTO sby_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu mpwalikuba ku Betaniya, mu ng'anda ya Shimoni shimankuntu. ");
INSERT INTO sby_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Nomba mpobalikulya patebulu, palashika mutukashi walikuba wamanta nsupa mwalikuba mafuta anunkila amulo wadula, walatatika kwitila mafutawo pamutwi wa Yesu. ");
INSERT INTO sby_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nomba beshikwiya bakendi mpobalaboneco, balepilwa kwine, ne kwambeti, “Inga nikwataila cani cisa mafuta pabulyo.” ");
INSERT INTO sby_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“Mafutawa ayandikanga kwaulisha mali angi, ne kunyamfwalishako bantu bapenshi.” ");
INSERT INTO sby_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu pakwinshiba byonse mbyobalikwamba, walabepusheti, “Mulamupenshelenga cani mutukashi uyu? Ici ncalenshili ame caina.” ");
INSERT INTO sby_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","“Nimukutenga bantu bapenshi cindi conse, nsombi nteti munkutenga cindi conse sobwe, ");
INSERT INTO sby_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","nendi letili mafutawa pamubili pakame, ‘lananikili limo kantana mbikwa mu manda.’ ");
INSERT INTO sby_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Cakubinga ndamwambilishingeti, kulikonse uko bantu nkweshi bakakambaukenga Mulumbe uwu Waina pacishi conse, naco ici ncalenshi ni bakacambenga, kwambeti bantu bakanukilenga ponga.” ");
INSERT INTO sby_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Panyuma pakendi umo wabeshikwiya likumi ne babili, Yuda Sikalyote walaya kuli ba makulene beshimilumbo. ");
INSERT INTO sby_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ne kuya kubepusheti, “Inga nimumpe cani ndamulisha Yesu kuli njamwe?” Naboyo popelapo balabelenga mali a silifa makumi atatu ne kumupa. ");
INSERT INTO sby_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kufuma cindico, Yuda Sikalyote, walatatika kulangaula cindi celela ca kumwikatilapo Yesu. ");
INSERT INTO sby_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pabusuba bwakutanguna bwakusekelela masuba ashinkwa wabula cishifufumusha, beshikwiya bakendi balesa kuli Yesu ne kumwipusheti, “Twenga kupeyo kuya kumubambila musena wa kulyelako Pasika?” ");
INSERT INTO sby_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesu walabambileti, “Kamuyani mu munshi uwu kumuntu wakuti wakuti, muye mwambeti, cindi cabo Bashikwiyisha cilipepi, balayandanga kwisa kulyela Pasika pamo ne beshikwiya babo kwenu.” ");
INSERT INTO sby_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Basa beshikwiya balensa mbuli Yesu ncalabambila, balabamba Pasika. ");
INSERT INTO sby_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Mansailo mpokwalashipuluka, Yesu ne beshikwiya bakendi likumi ne babili balekala patebulu ne kutatika kulya. ");
INSERT INTO sby_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kabacilya, Yesu walabambileti, “Cakubinga ndamwambilishingeti, umo pali njamwe langulishinga kubalwani bakame.” ");
INSERT INTO sby_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Beshikwiya balanyumfwa nsoni, neco, balatatika kumwipusha Yesu, umo ne umo Nkambo, sena njame? ");
INSERT INTO sby_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu walabakumbuleti, “Umo pali njamwe, uyo walyanga pamo nenjame mumbale iyi, epeloyo elangulishinga. ");
INSERT INTO sby_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","‘Mwana Muntu nafwe nditu, mbuli Mabala ncalambanga,’ Nomba ukute malele muntu laulishinga Mwana Muntu, ne calabako cena nalabula kusemwapo muntuyo.” ");
INSERT INTO sby_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yuda Sikalyote, usa walamulisha, walepusheti, “Bashikwiyisha, cakubinga nkandela kuba ame ngomulambanga ayi?” Yesu walamukumbuleti, “Ulamba omwine.” ");
INSERT INTO sby_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Cindi ncobalikulya, Yesu walamanta shinkwa walapaila ne kulumba Lesa, walakomona komona, walayabila beshikwiya, ne kwambeti, “Mantani, kamulyani, uwu emubili wakame.” ");
INSERT INTO sby_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kayi walamanta nkomeshi yesula waini, walalumba Lesa, ne kubapa beshikwiya basa, nekubambileti, “Kamunwa mwense. ");
INSERT INTO sby_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Iyi emilopa yakame yacipangano iletikilinga bantu bangi kwambeti, balekelelwe bwipishi bwabo. ");
INSERT INTO sby_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Cakubinga, nteti nkanwepo waini umbi, mpaka busuba mbweshi nkanwe waini walinolino pamo ne njamwe mu Bwami bwa Bata.” ");
INSERT INTO sby_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Panyuma pakwimbila lwimbo lwakutembaula Lesa, bonse balapula, balaya ku mulundu wa maolifi. ");
INSERT INTO sby_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yesu walabambila beshikwiya bakendi kwambeti, “Lelo mashiku mwense nimunkane ne kunshiya ndenka, pakwinga kwalembweti, ‘Ninkashine mwembeshi, kayi litanga lya mbelele nilikapalangane,’ ");
INSERT INTO sby_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nomba ndakapundushiwa kubafu, njameti nkatangune kuya ku Galileya.” ");
INSERT INTO sby_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Nomba Petulo walambeti, “Nambi bonse bamukane ne kumushiya, ame ndenka nteti ndimukanepo pimbi.” ");
INSERT INTO sby_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Apo Yesu walamwambila Petulo, “Cakubinga ndakwambilishingeti, lyopele lelo mashiku, kombwe katanalila, obe nunkane tunkanda tutatu, kwambeti nkonjishipo sobwe.” ");
INSERT INTO sby_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nomba Petulo walambeti, “Nambi cambweti mfwe pamo nenjamwe nteti nkamukanepo sobwe.” Nabo beshikwiya bonse balamba cimo cimo. ");
INSERT INTO sby_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesu ne beshikwiya bakendi balaya kumusena walikukwiweti, Getisemani, uko nkwalakabambileti, “Kamwikalani pano, ame ndenga uko kuya kupaila.” ");
INSERT INTO sby_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Walamantako Petulo, ne banabendi Sebedayo babili, Yesu walongumana, ne kupenga mumoyo. ");
INSERT INTO sby_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Walabambileti, “Mumoyo wakame muli bulanda bunene bwakufwa nabo. Kwamwikalani pano, nomba kamucetukani.” ");
INSERT INTO sby_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yesu walaya pantangu ntamwa pang'ana, walawa kali wakotamika cinso cakendi panshi ne kutatika kupaila,walambeti, “Ta, na kacikonsheka, mufunye nkomeshi yamapensho iyi. Nsombi kakutaba kuyanda kwakame sobwe, nsombi kube kuyanda kwenu.” ");
INSERT INTO sby_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Mpwalambeco, Yesu walabwelela kwalikuba beshikwiya basa, walabacana kabali bona tulo, neco walamwipusha Petulo, “Inga mulalilwaconi kupembelela pamo ne njame kwa kacindi kang'anowa. ");
INSERT INTO sby_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kumucetukani kayi kamupailani kwambeti kamutawila mu masunko. Walo moyo ulayandishishinga, nsombi mubili ulalefuku.” ");
INSERT INTO sby_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kayi Yesu walabashiya nekuya kankanda katubili kuya kupaila kambeti, “Ta, na nkomeshi ya mapensho iyi, nkayelela kumpitilila mpaka nwamo, naco caina, kuyanda kwinshike.” ");
INSERT INTO sby_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Mpwalabwelako kayi walabacana kabali bona tulo, pakwinga bikope byabo byalalema ne tulo. ");
INSERT INTO sby_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kayi Yesu walabashiya walaya kupaila katunkanda tutatu, kamba maswi amo amo. ");
INSERT INTO sby_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Panyuma pakendi, walesa kuli beshikwiya bakendi basa ne kwambeti, “Ne lino mucili monatulo, ne kupumwina ‘Cindi cilashiki,’ Mwana Muntu nabikwe mu makasa abantu baipa.” ");
INSERT INTO sby_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","“Pundukani! Tiyeni! Nte uyu shikungulisha lashiki!” ");
INSERT INTO sby_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu kacamba, Yuda Sikalyote, umo wa beshikwiya likumi ne babili walashika ne likoto lyabantu kabali bamanta bibeshi ne mingwala. Bamakulene beshimilumbo, ne bamakulene ba Bayuda ebalabatuma aba bantu. ");
INSERT INTO sby_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Shikumulisha wali kalilabambili kendi cishibisho, kwambeti, “Uyo ngweshi nshonshonte, endiye ngomulayandanga, mumwikate!” ");
INSERT INTO sby_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yuda Sikalyote walalulama palikuba Yesu ne kwambeti, Mitende Bashikwiyisha! Mpwalambeco walamushonshonta. ");
INSERT INTO sby_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu walamwambileti, “Obe ndo fwambana kwinsa ncoleshili.” Popelapo basa bantu Yesu balamutanya ne kumusunga. ");
INSERT INTO sby_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nomba kamubonani! umo walikuba pamo ne Yesu walapulisha cibeshi, ne kumutimbula litwi musebenshi wa Shimilumbo mukulene. ");
INSERT INTO sby_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nomba Yesu walamwambileti, “Bwesha cibeshico mucikwama, pakwinga bonse balasebenseshenga bibeshi, nibakafwe ku bibeshi,” ");
INSERT INTO sby_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Sena ulayeyengeti nkandelela kukuwa ne kusenga Bata, balo pacindi copele cino ngabantumina bangelo bankondo bapita makoto likumi ne abili. ");
INSERT INTO sby_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Na ame nyinseco, ngabinshikeconi byalambwa mu Mabala kwambeti byelela kwinshika. ");
INSERT INTO sby_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Popelapo, bantu basa Yesu walabepusheti, “Nipacebo cini mulaletelele bibeshi ne mingwala, pakunjikata eti njame kapondo? Masuba onse ndekalanga nenu mu Ng'anda ya Lesa kanjiyisha.” ");
INSERT INTO sby_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","“Nomba ibi byonse bilenshiki kwambeti mbyobalalemba bashinshimi mu Mabala bikwanilishiwe.” Popelapo beshikwiya bakendi bonse balafwamba, ne kumushiya Yesu enka. ");
INSERT INTO sby_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bantu basa mpobalamwikata Yesu, balamutwala ku ng'anda ya Kayafa Mukulene wa beshimilumbo bonse, uko nkobalabungana beshikwiyisha Milawo ya Mose, ne bamakulene ba Bayuda. ");
INSERT INTO sby_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petulo, walikakonka panyuma capataliko, mpaka walakengila mukati mulubuwa lwa ng'anda ya Mukulene wa beshimilumbo usa. Walengila mukati ne kuya kwikala pamo ne bamalonda baku Ng'anda ya Lesa, kwambeti abone ceti cinshike. ");
INSERT INTO sby_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Beshimilumbo bamakulene, ne bonse bamu Nkuta inene ya Bayuda, bali kulangaula bakamboni bela kumubepeshela Yesu kwambeti bamushine. ");
INSERT INTO sby_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nikukabeti palesa bakamboni bangi bela kumubepeshela, nsombi baliya kucanapo bukamboni bwancinencine mbobalikulangaula. Kumapwililisho kwalesa bantu babili, ");
INSERT INTO sby_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","balambeti, “Muntuyu walikwambeti, ame ndelela kumwaya Ng'anda ya Lesa, ne kuyibaka kayi mu masuba atatu owa.” ");
INSERT INTO sby_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Lino Mukulene wa beshimilumbo bonse walemana ne kumwipusha Yesu. “Sena uliya cakukumbulapo pa bintu ibi mbyobalakubepeshenga aba bantu?” ");
INSERT INTO sby_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nomba Yesu nendi walamwenowa tonto. Kayi Mukulene wa beshimilumbo bonse usa walambila Yesu, “Ndakwambilinga mu Lina lya Lesa muyumi, kwambeti winse kulumbila pakwamba na njobe Klistu, Mwanendi Lesa.” ");
INSERT INTO sby_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu walamukumbuleti, “Mulamba mobene, nsombi ndamwambilishingeti, ‘kufuma cino cindi nimukabone Mwana Muntu kaliwekala kucikasa calulyo ca Lesa wangofu shonse,’ Nimukamubone kesa mwilu mumakumbi.” ");
INSERT INTO sby_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mukulene wa beshimilumbobonse walatwamuna munganjo wakendi kulesha bukalu ne kwambeti, “Uku ni kumunyansha Lesa ‘Sena paciyandika bakamboni nabambi’ Mulalinyumfwili mobene ncalamunyansha Lesa.” ");
INSERT INTO sby_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","“Neco mulayeyengapongeconi?” Balo balakumbuleti, “Lacaniki ne mulandu, welela kushinwa!” ");
INSERT INTO sby_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Popelapo balatatika kumusankila mata kumenso ne kumuma mpaka, nabambi balatatika kumuma makofi, ");
INSERT INTO sby_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","kabambeti, “Obe Klistu, Kolotela, inga lakumu niyani?” ");
INSERT INTO sby_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petulo walakekala mulubuwa kunsa kwa ng'anda. Mutukashi musebenshi wa Mukulene wa beshimilumbo walesa kulyendiye ne kwambeti, “Ne njamwe mwalikwenda pamo ne Yesuyu waku Galileya.” ");
INSERT INTO sby_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nsombi nendi walakana pamenso abantu bonse, walambeti, “Ncolambanga ame nkandicishipo sobwe!” ");
INSERT INTO sby_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Petulo mpwalikupula kaya pacishinga, kayi mutukashi naumbi musebenshi walamubona, walatatika kwambila nabambi balikubapo. “Uyu muntu walikuba pamo ne Yesu waku Nasaleti.” ");
INSERT INTO sby_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petulo walakana, cakwinsa kulumbileti, “Cakubinga ame nkandimwishipo muntuyo.” ");
INSERT INTO sby_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mpopalapitako kacindi kang'ana, bantu balikubapo balamwambila Petulo, “Kwelana ne ntaka ya ng'ambilo yakobe tuleshibinga kwambeti ne njobe owa mulikoto ili.” ");
INSERT INTO sby_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Apo Petulo walensa kulumbileti, “Lesa anshingane ne kumpa cisubulo, na ndambanga bwepeshi, ame muntuyu nkandimwishipo sobwe.” Cindi copeleco kombwe walalila. ");
INSERT INTO sby_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Petulo walanuka maswi ngalamwambila Yesu akwambeti, “Kombwe katanalila nukankane tunkanda tutatu kwambeti nkonjishipo sobwe.” Popelapo Petulo walapula kayakulila ne kushinshimuka. ");
INSERT INTO sby_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mpobwalaca mumene, beshimilumbo bonse, ne bamakulene Baciyuda balapangana kayi sha kumushina Yesu. ");
INSERT INTO sby_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Balamusunga ne kumutwala kuli Pilato Mwendeleshi wa Ciloma. ");
INSERT INTO sby_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yuda, usa walaulisha Yesu mpwalaboneti mulandu ulaba wakumushina Yesu, walalisenda mwine, neco walababweshela bamakulene beshimilumbo, ne bamakulene Baciyuda, mali asa akwana makumi atatu a silifa. ");
INSERT INTO sby_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Walambeti, “Ndepisha kulisha muntu wabula mulandu kwambeti ayafwe.” Nomba balo balambeti, “Ulayandanga twinseconi? Awo nimakani akobe omwine.” ");
INSERT INTO sby_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yuda walamanta mali ne kuya kwawala mu Ng'anda ya Lesa, kufumapo wakalisungilila. ");
INSERT INTO sby_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Basa bamakulene beshimilumbo balabwesa mali, ne kwambeti, “Milawo yetu nkayasuminisha kwabika mali awa mu kabokoshi nkotukute kubikamo mali muno mu Ng'anda ya Lesa, pakwinga ni mali amilopa.” ");
INSERT INTO sby_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Neco balapanganeti mali awa baule libala lya mubumbi wanongo, kwambeti kube kunamaumbwe abensu. ");
INSERT INTO sby_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ecebo cakendi libala ilyo mpaka lelo likute kukwiweti libala lya milopa. ");
INSERT INTO sby_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Neco, kwalikuba kukwanilisha calamba mushinshimi Yelemiya uyo walambeti, “balamanta asa mali makumi atatu amukuba, mulo bana Baislayeli ngobalapangana palyendiye ");
INSERT INTO sby_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","balaula libala lya mubumbi wanongo, mbuli Lesa ncalang'ambila.” ");
INSERT INTO sby_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Lino Yesu walemana pamenso pa Pilato Mwendeleshi, uyo walamwipusheti, “Sena njobe Mwami wa Bayuda?” Yesu walakumbuleti, “Mulamba mobene.” ");
INSERT INTO sby_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nomba mpobali kumubepesha bamakulene beshimilumbo, ne bamakulene Baciyuda, Yesu nkali kubakumbulapo sobwe. ");
INSERT INTO sby_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilato mpwalaboneco, walamwipusha Yesu, “Sena nkolabinyumfunga mbyobala kubepeshenga?” ");
INSERT INTO sby_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yesu uliya kumukumbula. Neco Pilato walakankamana kwine. ");
INSERT INTO sby_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pacindi cakusekelela Pasika, Mwendeleshi Pilato, walikukute cinga cakusungulula kaili umo, uyo bantu ngobalayandanga. ");
INSERT INTO sby_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kwalikuba kaili umo pacindico wayampuyo, walikuwiweti Balaba. ");
INSERT INTO sby_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Mpobalabungana, Pilato walabepusheti, “Inga mulayandanga upeyo ngoti nsungulule, ‘Balaba,’ Nambi Yesu, lakwiwangeti Klistu?” ");
INSERT INTO sby_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Walambeco pakwinga walikwinshiba kwambeti, bantu balamuleta Yesu kulyendiye cebo ca minyono yabo. ");
INSERT INTO sby_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato kacili wekala pa cipuna cakomboloshela milandu, mukashendi walamutumina maswi, walambeti, “Kamutengililapo pankani ya muntuyo walulama, ame lelo mashiku ndapenge ne maloto pacebo ca muntuyo.” ");
INSERT INTO sby_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Bamakulene beshimilumbo, ne bamakulene Baciyuda, balatatika kuyungaula bantu kwambeti, basenge Pilato asungulule Balaba, ne kwambeti Yesu afwe. ");
INSERT INTO sby_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Lino Pilato walabepusheti, “Pa bantu babili aba mulayandanga ndimusungulwilepo upeyo?” Balo balambeti, “Balaba!” ");
INSERT INTO sby_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Kayi Pilato walabepusheti, “Inga lino uyu Yesu, lakwiwangeti, Klistu ndimwinseconi?” Bantu bonse balambeti, “Mupopeni!” ");
INSERT INTO sby_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kayi Pilato, walabepusheti, “Inga ukute mulandu cini?” Bantu basa balapitilisha kubilikisheti, “Mupopeni!” ");
INSERT INTO sby_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Lino Pilato mpwalaboneti bantu ngabatatika mipyopyongano, na upitilisha kwambapo, walamanta menshi, walasamba kumakasa pamenso pabantu bonse. Walambeti, “Ame ndiya mulandu wa lufu lwa muntuyu. Mulandu niwenu mobene.” ");
INSERT INTO sby_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Basa bantu bonse pamo balambeti, “Mulandu walufulo ube pamitwi yetu ne ya bana betu.” ");
INSERT INTO sby_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Popelapo Pilato walabasungulwila Balaba, ne kumukwapula Yesu, panyuma pakendi balamutwala kuya kumupopa palusanda. ");
INSERT INTO sby_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Popelapo bashilikali ba Mwendeleshi Pilato, balamumanta Yesu, nekuya nendi mulubuwa lwang'anda ya Pilato. Umo mobalabunganya bashilikali banabo ne kumushunguluka Yesu. ");
INSERT INTO sby_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Balamufulula byakufwala byakendi, ne kumufwalika mwinjila ufubeluka. ");
INSERT INTO sby_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Balapomba munshini wamyunga ne kumufwalika kumutwi, kayi balamwikatisha nkoli ya litete kucikasa cakululyo, balatatika kumusuntamina kwakumuwela, ne kumufukanya mwalisongwe, kabambeti, “Mitende Mwami wa Bayuda.” ");
INSERT INTO sby_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Balamusankila mata, balamanta nkoli yalitete ne kumuma nayo mu mutwi. ");
INSERT INTO sby_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mpobalacileka kumufukanya mwalisongwe, balamufulula mwinjila ufubeluka usa, ne kumufwalika mwinjila wakendi. Panyuma pakendi balamumanta kuya kumupopa. ");
INSERT INTO sby_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Cindi ncobalikufuma mu munshi umo, balakumanya muntu, lina lyakendi, Shimoni waku Kulene. Bashilikali balamukakatisha kunyamuna lusanda lwa Yesu. ");
INSERT INTO sby_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Balashika pamusena walikukwiweti, Gologota, ekwambeti musena wacifupa camutwi. ");
INSERT INTO sby_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Uko nkobalamupa Yesu, waini wasankanishiwako ne ntulukishi, kwambeti anwe. Nomba mpwalasupitamo, walakana kunwa. ");
INSERT INTO sby_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Yesu mpobalamupopa pa lusanda, balauma nsolo kwambeti baboneti nibani beti bayabane byakufwala byakendi, ");
INSERT INTO sby_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Panyuma pakendi balekala panshi kabamupembelela. ");
INSERT INTO sby_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Pelu pamutwi wakendi Yesu, balalembapo mulandu ngobalamushinina, balalembeti, “Uyu e Yesu Mwami wa Bayuda.” ");
INSERT INTO sby_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Kayi kopeloko kwalikuba kwapopwa kapondo babili, umo kucikasa ca kululyo, naumbi kucikasa ca kucipiko. ");
INSERT INTO sby_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nomba bantu balikupita pepi bali kumutukana, kabapukumuna mitwi yabo, ");
INSERT INTO sby_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","kabambeti, “Sena obe ntobe walikwambeti, ‘Ni nkamwaye Ng'anda ya Lesa, ne kuyibaka pamasuba atatu’ Na cakubinga njobe Mwanendi Lesa, kolipulusha ufumepo pa lusandapo.” ");
INSERT INTO sby_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nabo bamakulene beshimilumbo pamo ne beshikwiyisha milawo ya Mose, ne bamakulene Baciyuda, balikumuseka kabambeti, ");
INSERT INTO sby_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Walikupulusha bantu bambi, nsombi lalilwanga kulipulusha mwine, sena nte Mwami wa Baislayeli? Kaselukapo pa lusandapo kwambeti afwe tumushome. ");
INSERT INTO sby_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Walikuba wacinka manungo muli Lesa, kamupulushani Lesa uyo na umusuni nte walikambeti, “Njame Mwanendi Lesa!” ");
INSERT INTO sby_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nabo kapondo babili basa balikuba bapopwa pamo ne Yesu balikumutukana. ");
INSERT INTO sby_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kufuma cindi ca muma 12 koloko mpaka 3 koloko munshi palaba mushinshe pacishi conse. ");
INSERT INTO sby_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Cindi camuma 3 koloko munshi, Yesu walabilikisheti, “Eloi, Eloi, Lama sabakatani?” Uku ekwambeti, “Lesa wakame, Lesa wakame, mulanshili cani ndenka!” ");
INSERT INTO sby_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nabambi balikuba bemana pepi mpobalanyumfwa maswi awo balambeti, “Muntuyu lakunga Eliya.” ");
INSERT INTO sby_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Popelapo naumbi walafwamba kuya kumanta cisambo, walacisabika mu waini wasasa, ne kucibika ku kalutele ne kumupa kwambeti anwe. ");
INSERT INTO sby_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nsombi nabambi balambeti, “Koleka nanshi, tubone na Eliya nese amupulushe!” ");
INSERT INTO sby_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu walakuluma cangofu, popelapo walataya moyo. ");
INSERT INTO sby_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Lino kamubonani, cisa cikwisa calikuba mu Ng'anda ya Lesa, calatwamuka pakati kufumina pelu mpaka panshi. Kwalaba mukunkumo, ne mabwe alapasauka. ");
INSERT INTO sby_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Manda alacaluka ne mibili yabantu ba Lesa bangi bona mu manda balapundushiwa. ");
INSERT INTO sby_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Mpolabapula mu manda, Panyuma pa kupunduka kwa Yesu, balaya kwingila mu Yelusalemu Mushi Waswepa. Ne kuboneka ku bantu bangi. ");
INSERT INTO sby_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Abo balikuba ne mushilikali mukulene kabapembelela Yesu, mpobalabona mukunkumo ne bintu nabimbi byalenshika, balaba ne buyowa bunene, balambeti, “Cakubinga muntuyu wanga Mwanendi Lesa.” ");
INSERT INTO sby_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Palikuba batukashi bangi balikuba bemana capataliko balikwebelela. Aba ebalamukonkela Yesu kufuma ku Galileya, kabamunyamfwilisha. ");
INSERT INTO sby_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Pakati pabatukashi aba palikuba Maliya waku Magadala, Maliya banyina Jemusi ne Yosefe, ne mukashendi Sebedayo. ");
INSERT INTO sby_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Cindi camansailo pamuntu ngulya, kwalashika Yosefe waku Alimateya, walikuba mubile, neye walikuba shikwiya wa Yesu. ");
INSERT INTO sby_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Walaya kusenga mubili wa Yesu kuli Pilato, nendi Pilato walasuminisheti, Yosefe apewe uwo mubili. ");
INSERT INTO sby_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Neco Yosefe walamanta mubili ne kufungaila mucikwisa caswepa calinolino cituba, ");
INSERT INTO sby_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ne kuya kubika mu manda ngwalalibesela calinolino mulibwe ne kunkulushilapo cilibwe pacishinga camanda ne kufumako. ");
INSERT INTO sby_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maliya waku Magadala, ne Maliya naumbi usa balikuba bekala panshi kabali balangila kumanda. ");
INSERT INTO sby_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mpobwalaca mumene pa Sabata, bamakulene beshimilumbo, pamo ne Bafalisi balakabungana kuli Pilato ");
INSERT INTO sby_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ne kumwambileti, “Nkambo, twanuka kwambeti kacili muyumi muntu mubepeshi usa, walikwambeti, ‘Pakapita masuba atatu ninkapundushiwe.’ ");
INSERT INTO sby_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Neco, kamubambilani bamalonda benga bapembelele pamanda kwa masuba atatu, kutineti kabatesa bamwibe beshikwiya bakendi, ne kutatika kwambila bantu, eti lapundushiwa kubafu. Pakwinga kubepa uku ngakukonempa kupita kubepa kusa kwakutanguna.” ");
INSERT INTO sby_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Nendi Pilato walabambileti, “Nenjamwe mukute bamalonda, mucinshi ncomwelela kwinsa, kamuyani mupembelele pamandapo.” ");
INSERT INTO sby_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Balaya, balashinkashinka pamanda ne kushapo cishibisho pacilibweco. Ne kushiyapo bamalonda babo. ");
INSERT INTO sby_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Busuba bwa Sabata ya Bayuda mpobwalapita, Maliya waku Magadala ne Maliya naumbi, mumenemene kapacili pashipuluka pasondo, balaya kusula kumanda. ");
INSERT INTO sby_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kabatana bashikako kwalenshika mukunkumo unene, pakwinga mungelo wa Lesa walafuma kwilu walakunkulushila pambali cilibwe cisa ne kwikalapo. ");
INSERT INTO sby_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Walikuboneketi lulabo kayi byakufwala byakendi byalikuba byatuba tuu! ");
INSERT INTO sby_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Bamalonda basa balatina, kayi balatatika kututuma, balayuminina ntaa! eti bantu bafwa. ");
INSERT INTO sby_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nomba mungeloyo walabambila batukashi baseti, “Kamutatina sobwe! Ndicinshi mulalangaulunga Yesu usa ngobanga bapopa palusanda, ");
INSERT INTO sby_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","muliya muno sobwe lapundushiwa mbuli ncalikwamba. ‘Kamwisani mubone mpwanga wona.’ ");
INSERT INTO sby_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kamuyani bwangu mwenga mwambile beshikwiya bakendi kwambeti, ‘lapundushiwa kubafu,’ Kayi latangunu kendi kuya ku Galileya kopeloko nimwenga mubonane nendi, mwanukenga ibi mbyondamwambili.” ");
INSERT INTO sby_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Batukashi basa balafumako bwangu kumanda, kabali ne buyowa, nomba kayi kabali bakondwa cikamba, balafwamba kuya kwambila beshikwiya bakendi. ");
INSERT INTO sby_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mwakutengashila Yesu walakumana nabo ne kubambileti, “Mitende batukashi amwe!” Nabo balesa pepi,balasuntama ne kumwikata kumyendo yakendi ne kumukambilila. ");
INSERT INTO sby_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesu walabambileti, “Kamutatina, kamuyani mwambile banse bame benga ku Galileya. Nitubonane kopeloko.” ");
INSERT INTO sby_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Cindi ncobalikuya batukashi basa, bamalonda nabambi balashika ku Yelusalemu kuya kwambila beshimilumbo bamakulene bintu byonse byalenshika. ");
INSERT INTO sby_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Lino beshimilumbo bamakulene basa, ne bamakulene Baciyuda, balabungana pamo kupana mano. Bamalonda basa balabapa mali angi, ");
INSERT INTO sby_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ne kubambileti, “Mwambengeti, beshikwiya bakendi besakwiba citumbi mashiku, afwe katuli tona tulo.” ");
INSERT INTO sby_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Na Mwendeleshi wamfulumende anyumfwe ibi, afwe nitumwikalike cali, paliya mulandu ngoshimupewe sobwe. ");
INSERT INTO sby_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","balatambula mali bamalonda basa, kayi balensa mbuli ncobalabambila. Awa makani alayampuwo pakati pa Bayuda mpaka lelo. ");
INSERT INTO sby_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Beshikwiya likumi ne umo balaya ku Galileya, kumulundu uko Yesu nkwalabambileti benga bakakumane nendi. ");
INSERT INTO sby_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Mpobalamubona, balamukambilila, nsombi nabambi balikutonshanya. ");
INSERT INTO sby_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu walesa pepi ne kubambileti, “Ngofu shonse shabwendeleshi kwilu ne pacishi capanshi shilapewa kulinjame. ");
INSERT INTO sby_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Anu lino kamuyani kubantu bamishobo yonse, mwenga mubeyishe babe beshikwiya bakame. Mukababatishenga mu lina lya Bata ne mu lina lya Mwana, kayi ne lya Mushimu Uswepa. ");
INSERT INTO sby_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mukabeyishenga kukonkela bintu byonse mbyondamwambili, kayi nimbenga ne njamwe masuba onse, mpaka mapwililisho acishi.”");
INSERT INTO sby_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ici ecitatiko ca Mulumbe Waina ulambanga sha Yesu Klistu, Mwanendi Lesa. ");
INSERT INTO sby_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Walatatika mbuli ncewalalembwa mulibuku lya Yesaya mushinshimi, Lesa walambeti, “Ninkatume mutumwa wakame pantangu pakobe, uyo eti akabambe nshila yakobe, ");
INSERT INTO sby_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Pali liswi lya muntu labilikishinga mu cinyika limbangeti, Bambani mukwakwa mwakupita Mwami, Lulamikani nshila njoti akapitemo.” ");
INSERT INTO sby_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Neco, Yohane walashika mucinyika kakambauka nekubatisha bantu. Walambila bantu eti, “Shiyani bwipishi mubatishiwe, kayi Lesa namulekelele bwipishi bwenu.” ");
INSERT INTO sby_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Neco, bantu bangi bekala mu cimpansha ca Yudeya ne mu Yelusalemu balaya kuli Yohane akunyumfwa. Abo balikulyambilila bwipishi bwabo walababatisha mu mulonga wa Yolodano. ");
INSERT INTO sby_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohane walikufwala mwinjila wa bweya bwa ngamila, kayi ne lamba wa cipaya mubukome. Byakulya byakendi byalikuba bikobo ne bwiki bwamucisuwa. ");
INSERT INTO sby_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Walikukambauketi, “Panyuma pakame, palesanga ukute ngofu kupita shakame. Ame nkandelela kukotameti nsungulule ntambo sha nkwabilo shakendi. ");
INSERT INTO sby_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ame ndamubatishanga ne menshi, nsombi nendi nakamubatishenga ne Mushimu Uswepa.” ");
INSERT INTO sby_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Paliya kupita masuba angi, Yesu walafuma ku Nasaleti mucimpansha ca Galileya. Walabatishiwa ne Yohane mu mulonga wa Yolodano. ");
INSERT INTO sby_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Mpwalikufuma mu menshi, walabona kwilu kwalacaluka, kayi Mushimu Uswepa waleseti nkulimba nekwikala palyendiye. ");
INSERT INTO sby_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Popelapo palanyumfwika liswi kwilu lyakwambeti, “Obe njobe Mwaname ngondayandishisha, ndakondwa muli njobe.” ");
INSERT INTO sby_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Popelapo Mushimu Uswepa walapesheti enga mucinyika. ");
INSERT INTO sby_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Walekalako masuba makumi ana, kasunkwa ne Satana. Walikuba pakati pa banyama, nsombi bangelo balikumunyamfwilisha. ");
INSERT INTO sby_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Pacindi Yohane mpwalabikwa mujele, panyuma pakendi Yesu walaya ku Galileya kuya kukambauka Mulumbe Waina wa Lesa. ");
INSERT INTO sby_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Walikwambeti, “Cindi cilashiki, Bwami bwa Lesa bulaseng'ene pepi! Kamulapani, kayi kamushomani Mulumbe Waina.” ");
INSERT INTO sby_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nomba pacindi ncalikwenda mu mbali mwa lwenje lwa Galileya, walabona Shimoni ne Ndileya pabukwabo, kabawala tombe mulwenje, pakwinga balikuba basulishi banswi. ");
INSERT INTO sby_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Neco Yesu walabambileti, “Kamunkonkani, ninkamwiyishe kuba basulishi ba bantu.” ");
INSERT INTO sby_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Popelapo balashiya tombe twabo ne kumukonkela. ");
INSERT INTO sby_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kayi mpwalendako pang'ana, walabona Jemusi ne Yohane banabendi Sebedayo, mu bwato kababamba tombe twabo. ");
INSERT INTO sby_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Naboyo pacindi copeleco Yesu walabakuwa. Balashiya mushali wabo Sebedayo mubwato pamo ne basebenshi, balo balaya pamo ne Yesu. ");
INSERT INTO sby_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu pamo ne beshikwiya bakendi balaya ku Kapelenao, mpobwalashika busuba bwa Sabata bwakupumwina, Yesu walengila mung'anda yakupaililamo ne kutatika kwiyisha. ");
INSERT INTO sby_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nomba bantu balamunyumfwa ncalikwiyisha balakankamana, pakwinga nkalikwiyisheti beshikwiyisha ba milawo ya Mose, nsombi nendi walikwiyisha ne ngofu sha bwendeleshi. ");
INSERT INTO sby_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Pacindi copeleco muntu wekatwa ne mushimu waipa, neye walesa mu ng'anda yakupaililamo, muntuyo walabilikisheti, ");
INSERT INTO sby_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Tukute mulandu cini kuli njamwe Yesu wa ku Nasaleti? Sena waleshila kutushina? Ame ndimwinshi, njamwe Waswepa wa Lesa.” ");
INSERT INTO sby_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Nomba Yesu walaucancilila mushimu waipa ne kuwambileti “Komwena, pula mu muntuyu.” ");
INSERT INTO sby_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Panyuma pa kumuwishila panshi kanyukuma, mushimu waipa walabilikisha cangofu, ne kufumamo popelapo. ");
INSERT INTO sby_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Bantu bonse balakankamana ne kutatika kwipushana pa lwabo bene, “Inga ici nicani? Cakubinga ni ciyisho censu cangofu! Ha, lacancililinga ne mishimu yaipa yonse mwangofu, nayo ilamunyumfwilinga!” ");
INSERT INTO sby_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Neco, impuwo yakendi lwalamwaikila bwangu mu misena yonse ya mu cimpansha ca Galileya. ");
INSERT INTO sby_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu pamo ne beshikwiya bakendi pamo ne Jemusi ne Yohane, mpobalapula mung'anda yakupaililamo, balaya kung'anda ya Shimoni ne Ndileya. ");
INSERT INTO sby_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Kumakwendi Shimoni batukashi balikuba bona kabanyumfwa mubili kulungula,Yesu mpwalashika mwakufwambana balamwinshibisha. ");
INSERT INTO sby_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu walaya mpobalikuba bona walabekata kucikasa ne kubapundusha. Popelapo bulwashi bwalapwa, balatatika kubabambila cakulya. ");
INSERT INTO sby_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mansailo, lisuba mpolyalebila, bantu balatatika kumuletela Yesu balwashi bonse, ne abo bekatwa ne mishimu yaipa. ");
INSERT INTO sby_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Bantu bonse bamu munshi balabungana pa lubansa. ");
INSERT INTO sby_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu walabasengula balikukolwa malwashi apusana pusana, walapulisha mishimu yaipa, kayi nkali kwisuminisha kwambapo, pakwinga yaliku mwinshiba. ");
INSERT INTO sby_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kumaca kapacili pashipuluka, Yesu walapunduka mung'anda ne kuya kumusena kwabula bantu nkwalaya kupaila. ");
INSERT INTO sby_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Nomba Shimoni ne banendi balatatika kumulangaula. ");
INSERT INTO sby_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Mpobalamucana balambeti “Bantu bonse balamulangaulunga.” ");
INSERT INTO sby_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nomba Yesu walabakumbuleti, “Katuyani kumbi ku minshi ili pepi, kwambeti enkambaukeko, pakwinga encondaleshila.” ");
INSERT INTO sby_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kayi walaya mu manda abo akupaililamo mu Galileya monse, kaya kukambauka ne kupulisha mishimu yaipa. ");
INSERT INTO sby_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Shimankuntu walesa kuli Yesu ne kumusuntamina ne kumusengeti, “Nakamuyanda, inga munswepesha.” ");
INSERT INTO sby_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu walepilwa moyo neco, walatandabula cikasa cakendi ne kumwikata ne kumwambileti, “Ee ndayandishishinga, swepesha.” ");
INSERT INTO sby_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Pacindi copeleco, mankuntu alashimangana, walaswepa. ");
INSERT INTO sby_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Nomba Yesu walamwambileti enga kwabo, ne kumucenjesheti, ");
INSERT INTO sby_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Konyumfwa, kotaya wambile muntu naba umo sobwe, nsombi uye uliboneshe kuli Shimilumbo, ne kubenga milumbo ilayandikinga mu milawo ya Mose pacebo ca kuswepeshewa kwakobe kwambeti kube bukamboni kubantu.” ");
INSERT INTO sby_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nomba mpwalafumapo, nendi walatatika kwambila uliyense ne kumwaya makani mumisena ingi, neco Yesu calamwalila kwingila mu minshi mwakubonekela. Nsombi walapitilisha kwikala enka ku musena kwabula bantu. Nikukabeco bantu balikabesa nkwalikuba kufuma mu mbasu shapusana pusana. ");
INSERT INTO sby_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mpopalapitako masuba, Yesu walabwela ku Kapelenawo, bantu balanyumfweti uli pang'anda mpwalikwikala. ");
INSERT INTO sby_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Neco bantu bangi balabungana pang'anda cakwinseti mwalalabula musena mung'anda nambi palubansa, pakwinga bantu balafulisha mpaka pacishinga. nsombi nendi walatatika kukambauka sha maswi a Lesa. ");
INSERT INTO sby_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Kwalashika bantu bana balikuba batatula muntu mulema ne kumuleta kuli Yesu. ");
INSERT INTO sby_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nomba baliya kushika nendi pepi ne Yesu, pakwinga kwalikuba bantu bangi. Neco balashimbulula pelu paciluli kwelana ne mpalikuba Yesu. mpobalashimbulula balamwingisha mulwashi usa kali wona pa mpasa. ");
INSERT INTO sby_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nomba Yesu mpwalabona lushomo lwabo walambila muntu mulema usa eti, “O mwaname, bwipishi bwakobe bulalekelelwa.” ");
INSERT INTO sby_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Lino beshikwiyisha milawo nabambi balikubapo balatatika kuyeyaula mu myoyo yabo eti, ");
INSERT INTO sby_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nicani cilamwambinshinga cisa muntuyu? Lanyanshanga Lesa! Niyani welela kulekelela bwipishi? Sena nte Lesa enka?” ");
INSERT INTO sby_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pacindi copeleco Yesu walenshiba mu moyo mwakendi kwambeti encobalayeyenga, neco walabepusheti, “Inga mulayeyelenga cani bintu ibi mu myoyo yenu? ");
INSERT INTO sby_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Sena capubako cipeyo, kwambila muntu mulema eti, ‘Bwipishi bwakobe bulalekelelwa’ Nambi kwambeti, ‘Nyamuka manta mpasa yakobe wende.’ ");
INSERT INTO sby_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Neco, nindimuleshe kwambeti, Mwana Muntu nkute ngofu shakulekelela bwipishi pacishi capanshi.” Neco walambila muntu mulema usa, ");
INSERT INTO sby_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ndakwambalinga, nyamuka! Manta, mpasa yakobe koya kwenu!” ");
INSERT INTO sby_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Popelapo walapunduka ne kumanta mpasa yakendi, ne kutatika kulyendela enka pa menso pa cinyabwingi. Ici calankakamanisha bonse, neco, balamushikaisha Lesa ne kwambeti, “Bilicisa nkatunatubibonapo sobwe!” ");
INSERT INTO sby_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Kayi Yesu walendana mumbali mwa lwenje, bantu bangi balesa kulyendiye. nendi walatatika kubeyisha. ");
INSERT INTO sby_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Mpwalendanako walabona Levi mwanendi Alufeyo, kali wekala mu kanda kakusonkelamo musonko. Yesu walamwambileti, “Nkonkele.” Popelapo walanyamuka ne kumukonkela. ");
INSERT INTO sby_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pacindi nacimbi Yesu mpwalikulya mung'anda ya Levi pamo ne beshikwiya bakendi, beshimisonko ne beshimicito yaipa balikulya pamo, pakwinga bantu bangi balikumukonkela. ");
INSERT INTO sby_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Beshikwiyisha bamilawo ya Mose nabambi bamulikoto lyaba Falisi mpobalaboneti lalinga pamo ne bantu ba micito yaipa ne beshimisonko Balepusha beshikwiya ba Yesu eti, “Lalingeconi pamo ne beshimisonko ne beshimicito yaipa?” ");
INSERT INTO sby_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu mpwalanyumfwa, walabakumbuleti, “Bantu balabulunga kukolwa nkabakute kuyanda mung'anga sobwe, nsombi nibalwashi. Ndiya kwisakukuwa balulama sobwe, nsombi bamicito yaipa.” ");
INSERT INTO sby_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Beshikwiya ba Yohane Mubatishi kayi ne beshikwiya ba Bafalisi balo bakute kulikanisha kulya. Popelapo bantu nabambi balamwipusha Yesu, “Inga nipacebo cini beshikwiya ba Yohane kayi ne beshikwiya ba Bafalisi ncebakute kulikanisha kulya nomba benu nkabakute kulikanisha?” ");
INSERT INTO sby_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu walabakumbuleti, “Sena shibwinga acibanga pamo ne mbwalatamba kubwinga ngabalikanisha kulya? Nkabela kulikanisha kulya sobwe. ");
INSERT INTO sby_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nomba nicikashike cindi ncotibakamufulepo shibwinga, pacindico nibakatatike kulikanisha kulya.” ");
INSERT INTO sby_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Paliya muntu ukute kutunga cimami ca linolino pa mwinjila wakaindi, pakwinga ayinseco cimami ico inga cikokonyana nekumatula mwinjila wakaindi, ne kushiya cibwanko cinene pa mwinjila wakaindi usa. ");
INSERT INTO sby_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Paliya ukute kubika waini wamutumba mu cifwafumwa cacipaya cakaindi, pakwinga ayinseco, waini uwo ngaupasula cifwafumwa, kayi waini ne cifwafumwa byonse ngabitaika. Caina nikubika waini wamutumba mu cifwafumwa ca cipaya calinolino. ");
INSERT INTO sby_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Pa Sabata busuba bwakupumwina bwa Bayuda, Yesu pamo ne beshikwiya bakendi balikupita pakati pa mabala a mayila, kabaya kuningula ngala shamaila. ");
INSERT INTO sby_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Bafalisi balamwipusha Yesu, “Inga, nicani beshikwiya bakobe n-cobalenshilinga bintu byabula kusumishiwa kwinsa pa busuba bwa kupumwina?” ");
INSERT INTO sby_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Nendi Yesu walabakumbuleti, “Sena muliya kubelengapo ncalensa Defeti pamo ne batuloba mbwalikuba nabo mpwobalanyumfwa nsala, nomba kabali babula cakulya ");
INSERT INTO sby_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nte usa walengila mu Ng'anda ya Lesa, pacindi Abiyatala mpwalikuba Mukulene wa Beshimilumbo, walalya shinkwa watondwa walikubengwa kuli Lesa. Balikuba basuminishiwa kulya ni beshimilumbowa bonka, nomba Dafeti walalya nekupako batuloba mbwalikuba nabo?” ");
INSERT INTO sby_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu walabambileti, “Sabata yalabikwapo pacebo ca muntu, muntu uliyakubikwako pacebo ca Sabata sobwe ");
INSERT INTO sby_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ekwambeti Mwana Muntu ni Mwami wa bintu byonse, kayi wabusuba bwa Sabata.” ");
INSERT INTO sby_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Pacindi nacimbi Yesu walengila mung'anda yakupaililamo, mopelomo mwalikuba muntu wakokonyana cikasa. ");
INSERT INTO sby_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bantu bambi balikubamo balasha menso pali Yesu kwambeti babone mpani ingaumusengula usa muntu pa busuba bwa Sabata, kwambeti bamucaninepo mulandu wa kumubepeshela. ");
INSERT INTO sby_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nomba Yesu walamwambila muntu wakokonyana cikasa eti, “Nyamuka, kwesa wimanine pantangu.” ");
INSERT INTO sby_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Lino Yesu walabepusheti, “Inga nicipeyo casuminishiwa ne mulawo kwinsa pabusuba bwa Sabata? Kwinsa caina nambi caipa? Kupulusha buyumi bwa muntu nambi kononga?” Nomba nabo balamwena tonto. ");
INSERT INTO sby_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nomba Yesu walalanga uku ne uku mwabukalu, ne kwetelwa mumoyo pa cebo cakuyuma myoyo kwabo. Neco walamwambila muntuyo eti, “Tandabula cikasa cakobe.” Nendi walatandabula cikasa, neco calaba cena. ");
INSERT INTO sby_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Popelapo Bafalisi balapula mung'anda yakupaililamo balaya kukumana ne bantu ba mulikoto lya Helode, kwambeti bacane nshila yakushininamo Yesu. ");
INSERT INTO sby_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu ne beshikwiya bakendi balafumako ne kuya ku lwenje lwa Galileya, nomba likoto lya bantu lyalamukonka, beshikufuma ku Galileya ne ku Yudeya, ");
INSERT INTO sby_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ne ku Yelusalemu ne ku Idumeya kayi ne kutala kwa Yolodani ne mu bibela bya Tulo ne Sidoni. Bonse balanyumfwa mbyalikwinsa balabungana nkwalikuba. ");
INSERT INTO sby_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Bantu balikuba bangi kwine, neco Yesu walambila beshikwiya bakendi kwambeti bamuleteleko bwato atantemo, kukineti bantu kabatamushankanya. ");
INSERT INTO sby_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Pakwinga walikali lasengulupo bantu bangi, bonse balikuba bekatwa ne mishimu yaipa, kayi ne malwashi apensha balikabanyakana kwambeti bamukumyeko. ");
INSERT INTO sby_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","cindi conse mishimu yaipa, yamubona Yesu yalikupesheti bantu bekatwa mishimu iyo bawe panshi pamyendo yakendi. Mishimu yaipa yalikubilikisheti, “Amwe njamwe Mwanendi Lesa!” ");
INSERT INTO sby_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nomba Yesu walikuyambilishisha mishimu isa kwambeti kaitamuyubululanga. ");
INSERT INTO sby_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu walatanta pa mulundu ne kukuwako bonka balikuyandika, naboyo balaya nkwalikuba. ");
INSERT INTO sby_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Walasalapo bantu likumi ne babili mbwalakuweti, “batumwa” Ne kubambileti “Ndamusala kwambeti mwikalenga ne njame, ndimutumenga kuya kukambauka. ");
INSERT INTO sby_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Kayi ndamupanga ngofu shakupulisha mishimu yaipa.” ");
INSERT INTO sby_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Batumwa likumi ne babili mbwalasala balikuba aba Shimoni ngwalatumbiketi Petulo, ");
INSERT INTO sby_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ne Jemusi ne Yohane banabendi Sebedayo, Aba babili Yesu walabapa lina lya Bowanege, lilapandululungeti Bana ba kukunkuma, ");
INSERT INTO sby_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ne Ndileya ne Filipo ne Batolomeya ne Mateyo ne Tomasi ne Jemusi mwanendi Alufeyo ne Tadeyo ne Shimoni wa mucipani ca bantu balikulwanina lwanguluko mu cishi ca Islayeli, ");
INSERT INTO sby_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","kayi ne Yuda Isikalyoti uyo walayaba Yesu kubalwani. ");
INSERT INTO sby_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu walabwela kung'anda nkwalikushikila, likoto lya bantu lyalabungana kayi kopeloko, cakwambeti Yesu ne beshikwiya balabula ne cindi cakulya. ");
INSERT INTO sby_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nomba bakwabo mpobalanyumfweco, balikuyanda kuya kumufunyako, pakwinga bantu balikwambeti, “Yesu lakonyo!” ");
INSERT INTO sby_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nomba beshikwiyisha milawo ya Mose balafumina ku Yelusalemu balikwambeti, “Wekatwa ne Belesebulu, mwami wamishimu yaipa, endiye lamupanga ngofu sha kupulisha mishimu yaipa.” ");
INSERT INTO sby_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kayi Yesu walabakuwa, ne kutatika kubapa mikoshanyo ne kwambeti, “Inga Satana ngaucikonsheconi kupulisha Satana? ");
INSERT INTO sby_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Na bwami bupansana bwine, bwami ubo nkabwela kwikalisha sobwe, ");
INSERT INTO sby_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Na bantu ba mukowa umo batatika kubukilana palwabo, mukowa uyo nkawelela kwikalisha sobwe. ");
INSERT INTO sby_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ni cimo cimo, na bwendeleshi bwa Satana bulibukila bwine ne kupansana, bwendeleshi ubo nkabwela kwikalisha sobwe, nsombi bulenga kumapwililisho.” ");
INSERT INTO sby_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Paliya muntu welela kwingila mung'anda ya muntu wangofu ne kumantamo bibya byakendi, kwakubula nanshi kumusunga muntu wangofu. Ayinseco mpwelela kumantamo bibya mung'anda. ");
INSERT INTO sby_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Cakubinga ndamwambilinga, bantu nibakalekelelwe bwipishi ne byonse byaipa mbyebalambanga. ");
INSERT INTO sby_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","nomba uliyense lanyanshanga Mushimu Uswepa nteti akalekelelwe sobwe. Nendi nakabe ne mulandu wa bwipishi butapu.” ");
INSERT INTO sby_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(Yesu walambeco pakwinga bantu bambi balikumwambeti, ukute mushimu waipa.) ");
INSERT INTO sby_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Lino banyina ne bamakwabo Yesu balashika, ne kwimana pansa ne kumutumina muntu kuya kumukuwa. ");
INSERT INTO sby_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Bantu bangi balikuba bamushinguluka Yesu, balamwambileti, “Banyoko ne ba kwenu bali pansa balakuyandanga.” ");
INSERT INTO sby_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu pakubakumbula walambeti, “Bama ne bamakwetu nibani?” ");
INSERT INTO sby_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Yesu pakubalangishisha pabantu balikuba bekala panshi kabali bamushinguluka, walambeti, “Bonani, aba ebama kayi ebamakwetu.” ");
INSERT INTO sby_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","“Uliyense lenshinga kuyanda kwa Lesa, uyo emukwetu mutuloba nambi mutukashi kayi ebama.” ");
INSERT INTO sby_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Kayi Yesu walatatika kwiyisha mumbali mwa lwenje. Likoto linene lya bantu lyalabungana nkwalikuba, cakwinseti walatanta mubwato mwalakekala capataliko, nalyo likoto lya bantu lyalekala kumunta mumbali mwa lwenje. ");
INSERT INTO sby_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Walatatika kubeyisha bintu bingi mumikonshanyo. Walambeti, ");
INSERT INTO sby_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Kamunyumfwani! Muntu naumbi walaya kumwaya mbuto mulibala. ");
INSERT INTO sby_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Mpwalikumwaya mbuto, nashimbi shalawila mumbali mwanshila, neco kwalesa bikeni byalashilya. ");
INSERT INTO sby_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mbuto nashimbi shalawila pa mabwe pabula bulongo bwingi. Shalamena bwangu, pakwinga nkapalikuba bulongo bwingi. ");
INSERT INTO sby_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nomba lisuba mpolyatantako, mumena walanyana ne lumwi pakwinga nkashalikuba ne myanda yashimpa. ");
INSERT INTO sby_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mbuto nashimbi shalawila pa myunga, nomba myunga yalakula ne kufwekelela mumena, neco uliya kusema bisepo. ");
INSERT INTO sby_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nomba nashimbi shalawila pabulongo bwabolela, shalamena ne kukula cena, shalatatika kusema bisepo, nashimbi makumi atatu, nashimbi makumi asanu ne limo, nashimbi shalasema mwanda umo kupita mbuto shalamwaiwa.” ");
INSERT INTO sby_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Pakupwililisha, Yesu walambeti, “Uyo ukute matwi anyumfwe!” ");
INSERT INTO sby_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesu mpwalekala enka, nabambi balikuba bekala pepi nendi pamo ne basa likumi ne babili balesa kumwipusha sha mikoshanyo isa. ");
INSERT INTO sby_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nendi walabakumbuleti, “Amwe mulapewa casolekwa ca Bwami bwa Lesa, nomba kuli balikunsa byonse bilenshikinga mu mikoshanyo ");
INSERT INTO sby_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kwambeti, “kulanga kabalanga, nsombi kabatalangishishi, kunyumfwa kabayumfwa, nomba kabatanyumfwishishi, pakwinga na bensoco, ngabasanduka, Nendi Lesa ngaubalekelela.” ");
INSERT INTO sby_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesu walabepusheti, “Sena nkamuna munyumfwishisha mukoshanyo uwu? Inga lino nimukanyumfwishisheconi mikoshanyo naimbi? ");
INSERT INTO sby_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Shikumwaya mbuto ulyeti shikukambauka maswi a Lesa. ");
INSERT INTO sby_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mbuto shalakawila mumbali munshila, shilemanininga bantu bakute kunyumfwa maswi a Lesa, nomba banyumfwa, cabwangubwangu Satana ukute kwisa kwafunyamo maswi amwaiwa mukati mwabo. ");
INSERT INTO sby_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kayi mbuto shisa shalakawila pa mabwe, shilemanininga bantu bakute kunyumfwa maswi a Lesa ne kwatambula pa cindi copeleco mwakukondwa. ");
INSERT INTO sby_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nomba pakwinga maswi awo aliyawa miyanda, bakute kulikakatishako kacindi kafupi. Bacana mapesho ne bishikubaba pacebo ca maswi a Lesa, bakute kutyompwa bwangu. ");
INSERT INTO sby_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nomba mbuto nashimbi shalakawila pa myunga, shilemanininga bantu bakute kunyumfwa maswi a Lesa, ");
INSERT INTO sby_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","nomba cebo cakufula kwa bishikutatisha pa buyumi bwabo pacindi cino, ne bwikalo bwalunkumbwa lwabuboni, ne bintu nabimbi, bikute kwingila ne kufwekelela maswi awa, neco nkakute kusema bisepo. ");
INSERT INTO sby_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Imbuto isho shalakawila pa bulongo bwabolela, shilemanininga bantu bakute kunyumfwa maswi a Lesa ne kwatambula cena, ne kusema bisepo makumi atatu, nashimbi makumi asanu ne limo, nashimbi mwanda umo kupita isho shalabyalwa.” ");
INSERT INTO sby_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Pacindi copeleco walabepusheti, “Nkabakute kufwekelela lampi mu mutanga, nambi kubika panshi pabulili, sena ncobakute kwinsa? Sena nkabakute kubika lampi pantangalala? ");
INSERT INTO sby_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Paliya bintu byasolekwa, byeti bikabule kuyubululwa. Kayi paliya bintu byafwekwa byeti bikabule kufwekulwa. ");
INSERT INTO sby_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Uyo ukute matwi anyumfwe!” ");
INSERT INTO sby_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yesu walambeti, “Shakoni mano kuli mbyomulanyumfunga. Mupimo ngomulapimininga banenu, munshila imo imo ne njamwe nibakamupimineko, cakubinga nibaka musankanishilepo. ");
INSERT INTO sby_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Pakwinga uyo ukute bingi nakapewe bingi, nomba uyo ukuteko kang'ana, nambi kopelako nkalayeyengeti ukakute nibakamulamune.” ");
INSERT INTO sby_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu walambeti, “Bwami bwa Lesa buli mbuli muntu ukute kumwaila mbuto pa bulongo, ");
INSERT INTO sby_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ukute kuya kona mashiku ne kupunduka bwaca, nasho mbuto shisa shamwaiwa shikute kumena ne kukula. Nomba moshikute kukulila, nkakute kwinshibapo sobwe. ");
INSERT INTO sby_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Bulongo pacabo bwine bukute kumenesha, mukuya kwa cindi ngala shikute kuboneka, kayi mukuya kwa cindi kukute kupula tubeshi, kumapwililisho kwakendi, inseke shakoma shikute kubamo. ");
INSERT INTO sby_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","bisepo byakoma ukute kubiyangula ne Jekesi, pakwinga cindi ca kutebula cilakwana.” ");
INSERT INTO sby_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu walabepusheti, “Inga Bwami bwa Lesa tubwelanishe necani? Nambi tubwambe mumukoshanyo ulyeconi? ");
INSERT INTO sby_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Bulyeti kambuto ka masitadi, ako pa cindi ca kukabyala kakute kakali kang'ana pa mbuto shonse shakubyala sha pacishi ca panshi. ");
INSERT INTO sby_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nomba kabyalwa kakute kumena ne kukula kupita mbuto shonse sha matewu shili mulibala, kakute kuba ne misampi inene, cakwinseti bikeni bikute kupangilamo bisangala mulumfwile.” ");
INSERT INTO sby_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu walikukambaukila bantu mulumbe mumikoshanyo ingi yamushobowu, mbuli mobelela kukonsha kunyumfwila. ");
INSERT INTO sby_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Cakubinga uliya kwambapo nabo ciliconse kwakubula mukoshanyo, nsombi beshikwiya bakendi bonka embwali kubapandulwila byonse babanga pa lubasu bonka. ");
INSERT INTO sby_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Pa busuba bopelobo mansailo, Yesu walambila beshikwiya bakendi eti, “Katutampukilako kutala kwa lwenje.” ");
INSERT INTO sby_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Neco balashiya likoto lya bantu, ne kutanta nendi mubwato mbwalikubamo, kayi palikuba mato ambi. ");
INSERT INTO sby_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Pacindici kwalesa lukumpwe lunene lwa ngofu, neco mankape alatatika kuma ku bwato, palashala pang'ana kwambeti bwato bwibile. ");
INSERT INTO sby_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Nsombi Yesu walikuba mu bwato kunyuma, kaliwona tulo kali watamina pa mutamino. Beshikwiya bakendi balamunyukumuna ne kumwambileti, “Bashikwiyisha, nkamulashingonga mano, kwambeti tulipepi kufwa?” ");
INSERT INTO sby_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Walapashamuka ne kulucancilila lukupwe ne kulwambileti “Leka!” Kayi ne kwambila mankape, “Tontola!” Popelapo lukupwe lwalacileka, nawo mankape pa lwenje alamwena tonto. ");
INSERT INTO sby_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Neco Yesu walabepusheti, “nicani ncemwabela ne buyowa bwa swaswalo? Sena mucili babula lushomo?” ");
INSERT INTO sby_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nsombi nabo balanyumfwa buyowa ne kutatika kwamba kuli umo ne munendi eti, Inga uyu “Niyani cakwinseti lukupwe ne mankape pa lwenje byonse bilamunyumfwilanga!” ");
INSERT INTO sby_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu ne beshikwiya bakendi balatampukila kutala kwa lwenje lwa Galileya mu cishi ca Gelasa. ");
INSERT INTO sby_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Mpwalaseluka mubwato, walakumanya muntu wekatwa ne mishimu yaipa kafumina ku namaumbwe. ");
INSERT INTO sby_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Walikwikala ku namaumbwe, paliya muntu naba umo walakonsha kumusunga ncetani. ");
INSERT INTO sby_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Pakwinga walasungwapo ncetani kumakasa ne nshimbi kumyendo mankanda mangi, nsombi nendi walikusutaula ne kutyokola nshimbi. Paliya walikucikonsha kumukoma. ");
INSERT INTO sby_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Cindi conse munshi ne mashiku, walikolobesha munamaumbwe ne mumalundu kaliyasaula ne mabwe. ");
INSERT INTO sby_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nomba mpwalamubona Yesu capataliko, walamufwambila ne kumusuntamina, ");
INSERT INTO sby_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Neco walolobesha ne kwamba maswi eshikunyumfwika capatali walambeti, “Nkute nenu cani Yesu Mwana Lesa wa Kwilu ku mayoba? Ndamusengenga mulina lya Lesa kwambeti kamutampesha.” ");
INSERT INTO sby_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Walambeco pakwinga Yesu walawambila mushimuwo kwambeti, “Pula mu muntuyu mushimu waipa obe.” ");
INSERT INTO sby_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nomba Yesu walamwipusha muntuyu kwambeti, “Njobe bani lina?” Nendi walakumbuleti, “Lina lyakame njame likoto, pakwinga tulimo bangi.” ");
INSERT INTO sby_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Mishimu yaipa, yalapapata mankanda mangi kwambeti nkataituma kutali ne cibela ico. ");
INSERT INTO sby_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Lino mungusa wa nkumba walikaulya pamulundu. ");
INSERT INTO sby_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Neco, mishimu iyo yalamupapatileti, “kamututumani ku nkumba shisa, tuye twingilemo.” ");
INSERT INTO sby_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu walesuminisha. Popelapo mishimu yaipa yalapulamo nekuya kwingila mu nkumba. Mungusa wonse walamfwambila cakumukolo lubilo ne kuya kuliwala mulwenje, ne kufwilamo shonse, pamo myanda makumi abili. ");
INSERT INTO sby_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Balikushembela balafwambila ku minshi ne ku mabala, kabaya kwamba, neco bantu bangi balesa kubona bintu byalenshika. ");
INSERT INTO sby_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mpobalashika kuli Yesu, balabona muntu walikuba wekatwa ne mishimu yaipa kaliwekala, kaliwafwala, kaliwekalikana nkombe, ee muntu walikukute likoto lya mishimu yaipa, neco balaba ne buyowa. ");
INSERT INTO sby_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bantu abo balabonako ibyo byalenshika balabambila mocalabela ku muntu usa walikuba wekatwa mishimu yaipa, ne byalenshika ku nkumba. ");
INSERT INTO sby_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Neco bantu abo balatatika kumusenga Yesu kwambeti afume mucishi cabo. ");
INSERT INTO sby_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Lino mpwali kutanta mubwato, muntu usa walikuba wekatwa mishimu yaipa walatatika kupapatila kwambeti benga pamo. ");
INSERT INTO sby_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nsombi nkalamusuminisha sobwe, walamwambileti, “Koya ku munshi kubanse bobe wenga ubambile byonse Lesa mbyalakwinshili ne nkumbo nshalakuleshe.” ");
INSERT INTO sby_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Neco walanyamuka ne kuya ku Minshi likumi kuya kwambila bantu bintu byonse mbyalamwinshila Yesu, bantu bonse balakankamana. ");
INSERT INTO sby_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Pacindi Yesu mpwalatampukila kutala nakumbi mu bwato, likoto lya bantu bangi lyalabungana nkwalikuba, nsombi nendi walikuba mumbali mwa lwenje. ");
INSERT INTO sby_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Popelapo umo wabatangunishi ba ng'anda ya kupaililamo lina lyakendi Yailo, walashika, mpwalamubona walamusuntamina, ");
INSERT INTO sby_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ne kumupapatila mankanda angi, kwambeti, “Mwaname mutukashi lakolwa camakasa abili ndapapata katuyani mwenga mubike makasa enu palyendiye kwambeti bulwashi bumumbuluke abe cena.” ");
INSERT INTO sby_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Neco balanyamuka ne kuya pamo. Nomba likoto lya bantu lyalikumukonkela ne kumushankanya. ");
INSERT INTO sby_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Lino palikuba mutukashi walikukolwa bulwashi bwa mukunko kwa byaka likumi ne bibili. ");
INSERT INTO sby_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Walapenga kwine, nikukabeti walaya ku bang'anga bangi. ne kononga mali akendi onse nsombi bulwashi bwa mukunko empo bwalikuya pantangu. ");
INSERT INTO sby_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Mutukashi uyu mpwalanyumfwa bintu bingi mbyalikwinsa Yesu. Walakengila mulikoto lya bantu ne kwisa kwikata mwinjila wakunsa, cakunyuma kwa Yesu. ");
INSERT INTO sby_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Pakwinga munkombe mwakendi wali kuyeyeti, “ndekatako mwinjila wakendi wakunsa ninsengulwe.” ");
INSERT INTO sby_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Pa cindi copeleco, bulwashi bwa mukunko bwalapwa, walanyumfwa mubili wakendi kwambeti lashilikwa kubulwashi bwamupenshanga. ");
INSERT INTO sby_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesu neye pacindi copeleco, walanyumfwa kwambeti ngofu nashimbi shakusengula shilapulumo, walacebuka mu likoto lya bantu ne kwipusheti, “Inga niyani lekatako ku mwinjila wakame?” ");
INSERT INTO sby_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nomba beshikwiya bakendi balakumbuleti, “Bona bantu balakushankanyanga nibangi, nomba ulepushilingacani eti lakwikata niyani?” ");
INSERT INTO sby_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nomba Yesu walikacebauka uku ne uku kwambeti abone lenshico. ");
INSERT INTO sby_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nomba mutukashi uyo walaba ne buyowa ne kutatika kututuma pa kwinshiba ncilamwinshinkili. Neco walesa pepi ne kusuntama pamenso pakendi ne kumwambila cancine ncine. ");
INSERT INTO sby_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu walamwambila mutukashi uyo, “Omwana mutukashi obe lushomo lwakobe lulapesheti ube cena, Koya mu lumuno. Bulwashi bwakobe bwakumpenshanga bulapwilili.” ");
INSERT INTO sby_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kacamba palashika batuloba balafumina kuli Yailo mutangunishi wa ng'anda ya kupaililamo ne kumwambileti, “Mwanenu mutukashi usa lafu! Inga mucimumpenshela cani Shikwiyisha?” ");
INSERT INTO sby_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nomba Yesu mpwalanyumfwa ibyo byalikwambwa, walamwambila Yailo kwambeti, “Kotatina, kobowa lushomo.” ");
INSERT INTO sby_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesu nkalasuminisha kuya ne muntu uliyense kupatulakowa Petulo ne Jemusi ne Yohane mukwabo. ");
INSERT INTO sby_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Neco balakashika ku ng'anda ya mutangunishi wa ng'anda yakupaililamo, walabona kupilingana kwa bantu balikulila ne kulyuma pa nkombe. ");
INSERT INTO sby_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nomba mpwalengila mukati walambeti, “Inga mulalilingeconi cisa? Mwana uyu uliya kufwa sobwe, nsombi wonatulo.” ");
INSERT INTO sby_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mpwalamba maswi awa, balatatika kumuseka. Nomba mpwalabapulishamo bonse, walamanta baishi ne banyina bamwana pamo ne beshikwiya batatu mbwalikuba nabo, ne kwingila uko kwalikuba mwana uyo. ");
INSERT INTO sby_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Neco walekata cikasa ca mwana mutukashi uyo ne kwambeti, “Talita koumi!” Maswi aya alapandululungeti, “Omulindu obe, ndambanga ne njobe punduka!” ");
INSERT INTO sby_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Pa cindi copeleco mwana uyu walapunduka ne kutatika kwenda, walikuba wa byaka likumi ne bibili. Nomba bantu balakankamana kwine. ");
INSERT INTO sby_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nomba Yesu walabakonkomesha makanda angi kwambeti kabatambilako uliyense sha bintu ibi, walabambileti “mupeni cakulya.” ");
INSERT INTO sby_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu walafumako ne kushika mu cibela ca ku comwabo, neco beshikwiya bakendi balamukonka. ");
INSERT INTO sby_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Mpobwalashika busuba bwa sabata, nendi walatatika kwiyisha mung'anda yakupaililamo, nomba bantu bangi balamunyumfwa, balakankamana ne kwambeti, “Inga bintu ibi walabicana kupeyo muntuyu? Nipacebo cini mano alicisa alapewa ku muntuyu? Kwambeti bintu bya ngofu shilicisa nendi abinsenga? ");
INSERT INTO sby_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Sena nte shikupala mapulanga uyu, mwanendi Maliya, mukwabo Yakobo ne Yose ne Yuda ne Shimoni? Kayi ne bakwabo batukashi ntetuli nabo pano?” Neco balamusula. ");
INSERT INTO sby_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Nomba Yesu walapitilisha kubambileti, “Mushishimi nkatute kupewa bulemu kucomwabo nambi ne banse bendi nambi ne bamung'anda mucomwabo. Nsombi kumbi.” ");
INSERT INTO sby_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Neco calamwemba kwinsako bintu byeshikukankaminisha, nsombi walabika makasa pa balwashi bang'ana ne kubasengula. ");
INSERT INTO sby_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Cakubinga, walakankamana pakubula lushomo kwabo. Neco walendana muminshi yapepi kushingulukamo kaya kwiyisha. ");
INSERT INTO sby_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesu walakuwa likumi ne babili ne kubatuma babili babili, ne kubapa ngofu shakupulisha mishimu yaipa. ");
INSERT INTO sby_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nomba walabakonkomesheti, “Kamutamanta kantu kalikonse pabulwendo, nsombi nkoli yonka. Kamutamanta shinkwa, nambi mukopa wapabulwendo, nambi mali mubikwama byenu. ");
INSERT INTO sby_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ee, mufwale nkwabilo, kamutapamankanya minjila ibili.” ");
INSERT INTO sby_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kayi walabambileti, “Bamutambula mung'anda iliyonse, ikalani mung'andomo mpaka cindi cakufumamo. ");
INSERT INTO sby_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kulikonse nkobalabulu kumutambula, nambi kumunyumfwila, pakufumako mupampamune lusuko lwa ku myendo kwenu kwambeti lube cishibisho cakubacenjesha.” ");
INSERT INTO sby_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Neco balanyamuka kuya kukambauka kwambeti bantu bashiye bwipishi bwabo. ");
INSERT INTO sby_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Neco balapulisha mishimu yaipa ingi, ne kunanika mafuta balwashi bangi ne kubasengula. ");
INSERT INTO sby_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Lino ibi byalanyumfwika ku Mwami Helode pakwinga lina lya Yesu lyanyumfwika paliponse, neco bantu balikwambeti, “Yohane Mubatishi lapundushiwa kubafu, ecebo cakendi lenshinga bishikukankaminisha bilicisa.” ");
INSERT INTO sby_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nomba nabambi balikwambeti, “Ni Mushinshimi Eliya” Nsombi nabambi balikwambeti, “Ni mushinshimi mbuli ncobalikuba bashinshimi nabambi bakulukulu” ");
INSERT INTO sby_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Helode mpwalanyumfwa walambeti, “Cakubinga uyu ni Yohane Mubatishi usa ngondatimbula mutwi elapundushiwa.” ");
INSERT INTO sby_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Pakwinga Helodi mwine ewalatuma bantu kuya kumwikata Yohane, kumusunga ne kumubika mujele. Helode walenseco, pakwinga waleba Helodiya mukashi wa Filipo mukwabo. ");
INSERT INTO sby_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Calabeco pakwinga Yohane walikumwambila mankanda angi kwambeti, “Catonda kweba mukashi wa mukwenu” ");
INSERT INTO sby_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Neco Helodiya calamunyona kumoyo, walikalangaula mwa kushinina Yohane, nsombi Helodiya calikumwemba. ");
INSERT INTO sby_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Helode walikumutina Yohane, pakwinga walikumwinshibeti ni muntu walulama kayi waswepa, neco walikumusunga cena. Nomba mpwalanyumfwa ncalikwamba Yohane walapwilwa mano, Nambi walikuyanda kumunyumfwila mwa kukondwa. ");
INSERT INTO sby_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nomba Helodiya walacaninapo colwe mpobwalashika busuba bwakusekelela kusemwa kwa Helode. Walabambila cakulya camansailo bamanduna bakendi, bashilikali bamakulene, ne batangunishi bayampuwo mu Galileya. ");
INSERT INTO sby_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nomba mwana mutukashi wa Helodiya mpwalengilamo ne kubashanina ca sunsa bukome, walamukondwelesha Helode pamo ne mbwalikulya nabo. Pano Mwami walambila mwana mutukashi eti, “Kosenga ciliconse ncolandanga kuli njame, nindikupe.” ");
INSERT INTO sby_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ea, walensa kulumbileti, “Cakubinga ciliconse ncowelela kusenga kulinjame nindikupe, nambi cimpansha ca bwami bwakame.” ");
INSERT INTO sby_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Popelapo walapula ne kuya kwambila banyina kwambeti, “Inga ensenge cani?” Banyina balambeti, “Mutwi wa Yohane Mubatishi.” ");
INSERT INTO sby_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Pa cindi copeleco mutukashi uyu walengila mwabwangu bwangu ne kuya kwalikuba mwami, nekumusenga, “Ndayandanga mumpe mumbale popele pano mutwi wa Yohane.” ");
INSERT INTO sby_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Popelapo Mwami Herode calamwikala kumoyo, nomba pakuyeya ncalalumbila, kayi nabo mbwalakuwa kumalyalya asa uliya kuyanda kupwaya maswi ngalambila mutukashi usa. ");
INSERT INTO sby_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Pacindi copeleco mwami walatuma mushilikani ne kumukonkomesheti, alete mutwi wa Yohane. Neye walaya kumutimbula mutwi mu Jele, ");
INSERT INTO sby_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ne kuleta mumbale, ne kutwala ku mwana mutukashi usa, neye mutukashi uyo walautwala ku banyina. ");
INSERT INTO sby_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Beshikwiya bakendi Yohane mpobalanyumfwa balesakumanta citumbi ne kuya kubika mu manda. ");
INSERT INTO sby_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Lino beshikwiya balabwelela kuli Yesu ne kumwambila byonse mbyebalensa ne kwiyisha. ");
INSERT INTO sby_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kwalikuba bantu bangi balikwisa ne kuya, cakwinseti Yesu ne beshikwiya bakendi balabula cindi cakupumwina, nambi cakwambeti balye cakulya. Neco,walabambileti, “Katuyani kumusena kwabula bantu twenga tupumwineko.” ");
INSERT INTO sby_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Neco balatanta bwato, ne kuya kumusena kwabula bantu. ");
INSERT INTO sby_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nomba bantu balababona kabanyamuka, balenshiba nkobalikuya. Neco bantu balasokoloka kufuma muminshi ne kufwamba lubilo kuya kopeloko ne kushika bwangu Yesu ne beshikwiya bakendi kabatana bashika. ");
INSERT INTO sby_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Lino Yesu mpwalaseluka mu bwato, walabona likoto linene lyabantu, neco walabanyumfwila luse, pakwinga balikubeti mbelele shabula mwembeshi. Walatatika kubeyisha bintu bingi. ");
INSERT INTO sby_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Lino mpokwalatatika kushipuluka, beshikwiya bakendi balesa kumwambileti, “Kuno nikucisuwa, kayi naco cindi cilapu. ");
INSERT INTO sby_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kamubambilani bantu benga mu minshi ilipepi kwambeti benga balyulile byakulya.” ");
INSERT INTO sby_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Neye Yesu walabambileti, “Amwe njamweti mubape cakulya.” Palico, balo balambeti, “Sena twenga kuyakula shinkwa wa mali ngelakufola muntu pa myenshi isanu ne itatu ne kutwala kubantu aba kwambeti balye?” ");
INSERT INTO sby_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nendi Yesu walabepusheti, “Inga mukuteko shinkwa ungaye? Kamuya mubone!” Mpobalaubona balamwambileti, “Muli shinkwa usanu, kayi ne nswi shibili.” ");
INSERT INTO sby_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Palico, Yesu walambila beshikwiya bakendi kwambeti, bekalike panshi bantu mu makoto-makoto pamila yamwemfu. ");
INSERT INTO sby_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Neco balekala mumakoto milongo mwanda umo, ukute bantu makumi asanu pa mulongo. ");
INSERT INTO sby_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesu walamanta shinkwa usanu ne nswi shibili ne kulanga kwilu ne kusenga Lesa, ne kukatika komona shinkwa ne inswi shibili nekupa beshikwiya bakendi, kwambeti nabo bayabile bantu. ");
INSERT INTO sby_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Neco bonse balalya ne kwikuta, ");
INSERT INTO sby_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Panyuma pakendi beshikwiya basa balayowela byalashalapo bya shinkwa ne nswi, balesusha mitanga likumi ne ibili, ");
INSERT INTO sby_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nomba, bonse abo balalya shinkwa uyo balikuba batuloba bali myanda makumi asanu. ");
INSERT INTO sby_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pacindi copeleco, Yesu walambila beshikwiya bakendi eti batante mu bwato batangune kuya kutala ku Betisaida, nsombi nendi walashalila kacambila bantu kwambeti benga kwabo. ");
INSERT INTO sby_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Mpwalalayana nabo bantu, walaya pa mulundu kuya kupaila. ");
INSERT INTO sby_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Mansailo mpokwalashipuluka, bwato bwali kabucili pakati pa lwenje, kakuli nendi walikuba enka kumutunta. ");
INSERT INTO sby_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nomba Yesu mpwalababona kabakwasula bwato mwakupenga pakwinga balikulwana ne lukupwe lwa ngofu, camuma 3 koloko kumaca walabakonkela, kaya kwenda palwenje, nomba walayanda nsulo kubapitilila. ");
INSERT INTO sby_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nomba beshikwiya mpobalamubona kenda pa lwenje balayeyeti, “Ni cipuku ici nditu!” Neco kwalaba kubilikisha kwabuyowa. ");
INSERT INTO sby_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Pakwinga bonse balamubona neco balatina kwine. Nomba pa cindi copeleco, walabambileti, “Yumishani moyo, njame. Kamutatina!” ");
INSERT INTO sby_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Popelapo walatanta nabo mubwato ne lukupwe lwalacileka. Neco balakankamana mu myoyo yabo. ");
INSERT INTO sby_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Pakwinga baliya kunyumfwishisha shinkwa usa ne swi, ncalikupandulula, cebo cakwambeti myoyo yabo yalikuba yayuma. ");
INSERT INTO sby_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nomba lino mpobalatampukila kumutunta, balashika mu Genesalete ne kubwimanika bwato capepi. ");
INSERT INTO sby_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nomba mpwalaseluka mu bwato bantu balashikila kumwinshiba Yesu. ");
INSERT INTO sby_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Neco bantu bamu misena yonse balafwamba uku ne uku ne kunyamuna balwashi pa mampasa, kuya nabo uko nkobalanyumfeti nkwabele. ");
INSERT INTO sby_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Calaba cakwinseti mumunshi mwalengili, nambi mu minshi inene inene, nambi mumisena yashinguluka iliyonse, bantu balikwikalika balwashi mumisena ya makwebo. Balikumusengeti bakumyeko kucelele kwamwinjila wakendi wakunsa. Neco bangi balakumya ne kusenguka. ");
INSERT INTO sby_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Bafalisi ne beshikwiyisha milawo nabambi balafumina ku Yelusalemu, balamubunganina Yesu. ");
INSERT INTO sby_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Lino balaboneti beshikwiya nabambi balalinga shinkwa kwakubula kusamba kumakasa mbuli mulawo wa Bafalisi nceulambanga. ");
INSERT INTO sby_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Pakwinga Bafalisi ne Bayuda bonse nkabakute kulya kwakubula kusamba kumakasa mbuli mwambo wabakulukulu nceulambanga. ");
INSERT INTO sby_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Weco bafuma kumakwebo, nkabali kubilya kabatana babiswepesha nanshi. Kayi pali miyambo ingi njobalatambula ne kwisunga, mbuli kusuka mipika nkomeshi ne mbale kayi ne malili. ");
INSERT INTO sby_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Neco aba Bafalisi ne beshikwiyisha milawo balamwipusheti, “Inga nipacebo cini beshikwiya bakobe ncobabulilinga kukonka mwambo wa bakulukulu. Balo balalinga cakulya ne makasa ashilila?” ");
INSERT INTO sby_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu walabakumbuleti, “Yesaya walamba cakubinga pakwamba sha bandemi shibili amwe, mbuli Mabala ncakute kwambeti,” Bantu aba bakute kumpa bulemu ne milomo yabo, nsombi myoyo yabo ili kutali nenjame. ");
INSERT INTO sby_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","“Bakute kunkambilila pabulyo, pakwinga bakute kwiyisha milawo yabantu kubeti biyisho bya Lesa! ");
INSERT INTO sby_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Mukute kubika palubasu milawo ya Lesa, ne kuyuminina nta ku mwambo wa bantu.” ");
INSERT INTO sby_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kayi walabambileti, “Mubucenjeshi bwenu mukute kunyakila palubasu milawo ya Lesa kwambeti musunge mwambo wenu. ");
INSERT INTO sby_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Pakwinga Mose walambeti, ‘Kopa bulemu baiso ne banyoko,’ Kayi walambeti, ‘Uliyense lanyanshanga baishi ne banyina ashinwe.’ ");
INSERT INTO sby_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nomba amwe mukute kwambeti muntu ambila baishi nambi banyina, nconkute, ncomwayandangeti ndimunyamfweko, ni kwambeti, ‘ni Kobani (uku ekwambeti cintu ico cilabengwa kuli Lesa). ");
INSERT INTO sby_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nkamukute kumusuminisheti asebensele baishi nambi banyina munshila iliyonse, ");
INSERT INTO sby_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","pakwinseco maswi a Lesa akute kuba abulyo pacebo ca mwambo wenu ngomwalatwalila bantu. Kayi mukute kwinsa bintu bingi byakoshana nebi.” ");
INSERT INTO sby_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Neco Yesu walakuwa likoto lisa lya bantu, ne kutatika kwamba nalyo, “Kamunyumfwani kuno mwense, munyumfwishishe bupandulushi bwakendi. ");
INSERT INTO sby_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Paliya ciliconse cishikufuma kunsa kwa muntu cikute kwingila mumubili mwakendi celela kusafwanya muntu, nsombi bintu bikute kupula mu muntu ebikute kusafwanya muntu.” ");
INSERT INTO sby_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","“Ukute matwi Anyumfwe.” ");
INSERT INTO sby_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesu mpwalafuma palikoto lya bantu walakengila mung'anda, beshikwiya bakendi balatatika kumwipusha sha mukoshano usa. ");
INSERT INTO sby_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu walabambileti, “Sena nenjamwe nkamuncishi kwambeti paliya cishikufuma kunsa ne kwingila mu mubili wa muntu celela kumusafwanya, ");
INSERT INTO sby_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","pakwinga nkacikute kwingila mumoyo, nsombi mumila yakendi. Neco cikute kupula nekuya kucitaila kucisuwa” Palico byakulya byonse byaswepa. ");
INSERT INTO sby_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kayi walambeti, “cishikufuma mu muntu ecikute kusafwanya muntu, ");
INSERT INTO sby_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","pakwinga mukati mu moyo wa muntu, mukute kupula miyeyo yaipa yakwinsa bufule, ya bwibi, yabukapondo, ");
INSERT INTO sby_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","yabupombo, yakukumbwa kwa munyono, kwinsa byaipa, bwepeshi, bwikalo bwacendende, liso lyalunkumbwa, lunkanwa, kulibonabuntu, kwinsa bintu kwa buluya. ");
INSERT INTO sby_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Byonsebi byaipa ebikute kupula mukati ne kusafwanya muntu.” ");
INSERT INTO sby_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu mpwalafumako walengila mubibela bya Tulo ne Sidoni. Walaya kwingila mung'anda, neco nkalikuyandeti muntu uliyense enshibe. Nikukabeco bantu balenshiba. ");
INSERT INTO sby_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Neco pacindi copeleco mutukashi walikukute mwana mutukashi wekatwa ne mushimu waipa, walanyumfwa sha Yesu, walesa kusuntama pa myendo yakendi. ");
INSERT INTO sby_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mutukashi uyu walikuba mu Giliki walasemenwa mu cibela ca Siliya calikukwiweti Foinike. Neco walamusenga Yesu tunkanda twingi kwambeti apulishe mushimu mu mwanendi mutukashi. ");
INSERT INTO sby_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nomba nendi walatatika kwambeti, “Cakutanguna bana ebelela nanshi kwikuta, pakwinga nkacaina kumanta cakulya ca bana ne kupa bakabwa.” ");
INSERT INTO sby_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nomba pakukumbula nendi mutukashi walambeti, “Nicakubinga Nkambo, nomba nabo bakabwa bona mwinshi mutebulu bakute kupembelela kulya bilalashanga bana panshi.” Mpwalanyumfwa maswi alico walamwambila mutukashi, ");
INSERT INTO sby_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","“Pakwinga ulambeco, koya, mushimu waipa ulapulumo mu mwanobe.” ");
INSERT INTO sby_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Neco walaya kung'anda kwakendi nekucana mwanendi kali walambalala pabulili mushimu kauli ulapulumo kendi. ");
INSERT INTO sby_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Lino mpwalikubwela kufuma mubibela bya Tulo, walapita pakati pa Sidoni ne kushika kulwenje lwa Galileya ne kupita mu Cimpansha caminshi likumi. ");
INSERT INTO sby_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Kopeloko bantu balamuletela muntu washinka matwi, kayi wakamama, balamusengeti abike cikasa cakendi palyendiye. ");
INSERT INTO sby_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nomba Yesu walamanta muntuyo pakati pa likoto lya bantu nekuya nendi palubasu. Kopeloko walengisha minwe yakendi mu matwi a muntuyo kayi walasanka mata ne kwikata lulemi lwakendi. ");
INSERT INTO sby_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Popelapo walalanga kwilu walashinshimuka ne kwambeti, “Ephphata,” Uku ekwambeti, “Caluka.” ");
INSERT INTO sby_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Popelako matwi akendi alacaluka, lulemi lwakendi lwalikuba lwasungika lwalasunguluka, walatatika kwamba cena cena. ");
INSERT INTO sby_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu walabakonkomesheti, “Kamutambilako uliyense,” Nomba balo empobalikuya kwamba kulikonse. ");
INSERT INTO sby_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Cakubinga balikukankamana ne kwambeti, “Bintu byonse labinshi cena nditu, bashinka matwi balanyumfunga, ne bacibulu balambanga.” ");
INSERT INTO sby_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Paliyawa kupita cindi citali sobwe, kayi bantu bangi balabungana kuli Yesu, nomba nkabalikukute cakulya,Yesu walakuwa beshikwiya bakendi ne kubambileti, ");
INSERT INTO sby_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ndanyumfwilinga luse bantu aba, pakwinga balekala ne njame kwa masuba atatu, kwabula cakulya. ");
INSERT INTO sby_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Na ndibambileti benga kwabo kabali ne nsala, nibawisukenga mu nshila, pakwinga nabambi bafuma kutali.” ");
INSERT INTO sby_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Beshikwiya bakendi balamwipusheti, “Nikupeyo muntu nkwelela kucana shinkwa wingi wakulyesha aba bantu bonse mucisuwa muno?” ");
INSERT INTO sby_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nendi Yesu walabepusheti, “Inga mukuteko shinkwa ungaye?” Nabo balakumbuleti, “Usanu ne ubili.” ");
INSERT INTO sby_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Lino walabambila bantu kwambeti bekale panshi. Neco walamanta shinkwa usanu ne ubili, walalumbaisha Lesa, walakomauna, nekupa beshikwiya bakendi kwambeti bayabile likoto lya bantu. Naboyo balensa copeleco. ");
INSERT INTO sby_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kayi balikukute tunswi twakubelengowa, walalumbaisha Lesa ne kubambileti nato batuyabe. ");
INSERT INTO sby_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Neco bonse balalya ne kwikuta, cakwinseti balayowela bishikulaka panshi ne kwisusha mitanga inene inene isanu ne ibili. ");
INSERT INTO sby_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Palikuba bantu bashika pepi myanda makumi ana, Yesu balabambileti benga kwabo. ");
INSERT INTO sby_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Popelapo Yesu, walatanta mubwato pamo ne beshikwiya bakendi ne kuya ku cibela ca Dalamanuta. ");
INSERT INTO sby_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Kopeloko kwalashika Bafalisi balatatika kutotekeshana ne Yesu. Balikuyandeti ababoneshe chinshibisho chishikufumina kwilu pakuyanda kumwelekesha. ");
INSERT INTO sby_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu walashinshimuka mumoyo wakendi, walambeti, “Sena niciyani musemanowu colayandilinga kubona cinshibisho? Cakubinga ndambangeti, musemanowu nteti ukapewepo chinshibisho ciliconse sobwe.” ");
INSERT INTO sby_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Mpwalambeco walabashiya ne kutanta bwato kuya kutala kwa lwenje. ");
INSERT INTO sby_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nomba, balalubako kumanta shinkwa wingi, neco nkabalikukute ciliconse mubwatomo, nsombi shinkwa umowa. ");
INSERT INTO sby_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","walabacenjesheti, “Calukani menso! Cetukani ne cishikufufumusha ca Bafalisi ne ca Helode.” ");
INSERT INTO sby_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Neco balatatika kukangana umo ne munendi pa nkani yakubula shinkwa. ");
INSERT INTO sby_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu pakwinshibeco, walabambileti, “Inga mulakanganangeconi pa nkani yakubula shinkwa. Sena mpaka pacindi cino nkamuna munyumfwishisha ne kwinshiba bupandulushi bwakendi? Sena myoyo yenu icili mungubi? ");
INSERT INTO sby_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nambi menso mulinawo sena nkamulabonesheshenga? Matwi mulinao sena nkamulanyumfwishishinga? Sena nkamulanukunga? ");
INSERT INTO sby_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Pasa mpondala komauna shinkwa usanu kwambeti ndyeshe batuloba myanda makumi asanu, sena mwalesusha mitanga ingaye ya byashalapo?” Beshikwiya bakumbuleti, “Likumi ne ibili.” ");
INSERT INTO sby_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesu walabepusheti “Mpondalakomauna shinkwa usanu ne ubili ne kulyesha batuloba myanda makumi ana, mwalesusha mitanga ingaye?” Balakumbuleti “Isanu ne ibili” ");
INSERT INTO sby_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Popelapo walambeti, “Sena nkamuna mwinshiba ncocilapandululunga?” ");
INSERT INTO sby_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu ne beshikwiya bakendi balashika ku Betisaida, uku bantu balamuletela muntu washipilwa, balamupapatila kwambeti amwikatekowa muntuyo. ");
INSERT INTO sby_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Popelapo Yesu walamwikata muntu washipilwa pacikasa nekuya nendi kunsa kwa munshi walamusankila mata mumenso ne kubika makasa palyendiye, ne kumwipusheti “Sena pali ncolabonongaponga?” ");
INSERT INTO sby_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Muntu washipilwa usa walakapula ne kukumbuleti, “Ee ndabononga bantu balendendenga.” Nomba balabonekengeti, “bitondo.” ");
INSERT INTO sby_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Kayi Yesu walabika makasa pamenso a muntu usa, neco walakapula nekutatika kubona. Walaba cena ne kuboneshesha cena bintu byonse. ");
INSERT INTO sby_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu walamwambileti koya kucomwenu, ne kumwambilisheti, “Kotabwela mumunshiwu.” ");
INSERT INTO sby_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu ne beshikwiya bakendi pacindici balaya ku minshi yaku Kaisaleya waku Filipi. Mpobalikuya munshila, Yesu walabepusheti, “Inga bantu balambangeti njame bani?” ");
INSERT INTO sby_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Balo beshikwiya bakendi balamukumbuleti, “Bambi balambangeti njamwe Yohane Mubatishi, nabambi balambangeti njamwe Eliya. Nsombi nabambi balambangeti, njamwe umo wabashinshimi bakulukulu.” ");
INSERT INTO sby_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yesu walabepusheti, “Inga amwe mulambangeti njame bani?” Petulo walakumbuleti, “Amwe Njamwe Klistu Mupulushi Wasalalwa ne Lesa.” ");
INSERT INTO sby_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Neco Yesu walabambileti, “Kamutambilapo muntu uliyense shanjame.” ");
INSERT INTO sby_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesu popelapo walatatika kubeyisha beshikwiya bakendi kwambeti, “Mwana Muntu welela kunyumfwa bishikubaba, kupenshewa ne kukanwa ne beshimilumbo milumbo, ne bashikwiyisha milawo ne kumushina. Nsombi pabusuba bwatutatu, nakapundushiwe kubafu.” ");
INSERT INTO sby_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu walabambila makani awa pantangalala. Nomba nendi Petulo walamutwala Yesu pa lubasu ne kumukansa. ");
INSERT INTO sby_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nendi Yesu walacebuka ne kulangila kwalikuba beshikwiya bakendi nabambi, ne kumucancalila Petulo mwabukalu eti. “Koyoko Satana obe, pakwinga miyeyo yakobe niya buntu, nteyo miyeyo ya Lesa sobwe!.” ");
INSERT INTO sby_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Panyuma pakendi, Yesu walakuwa likoto lya bantu pamo ne beshikwiya bakendi, nekubambileti, “Muntu layandanga kunkonka ame alikane mwine, kayi alibambile kupeshewa, ne kufwa cebo ca kunkonkela. ");
INSERT INTO sby_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Pakwinga uliyense layandanga kupulusha buyumi bwakendi mwine, nakabutaye. Nomba uyo latayanga buyumi bwakendi pa cebo cakame, ne pacebo ca makani awa ayina, cakubinga nendi nakabupulushe. ");
INSERT INTO sby_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Inga caina cilipo nicipeyo na muntu uba ne bintu byonse bili pacishi capanshi, nomba ubutaya buyumi bwakendi butapu? ");
INSERT INTO sby_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Inga nicani ico muntu ncelela kutika kwambeti buyumi bwancinencine butapu? ");
INSERT INTO sby_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Abo balanyumfwilinga insoni ne maswi akame pamenso abantu babula lushomo,kayi babwipishi, bopelabo Mwana Muntu nakabanyumfwile insoni akesanga pamo ne bangelo mu Mulemu bwa Baishi.” ");
INSERT INTO sby_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu walapitilisha kubambileti, “Cakubinga ndamwambilishingeti, popele pano, mpobali nabambi beti bakabule kufwa kabatana babubona Bwami bwa Lesa kabwisa ne ngofu.” ");
INSERT INTO sby_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Mpopalapita masuba asanu ne bumo, Yesu walamanta Petulo ne Jemusi ne Yohane ne kuya nabo pa mulundu utali pabonka, kopeloko ciwa ca Yesu walasanduka kabalangilisha ne menso abo. ");
INSERT INTO sby_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Balabona mwinjila wakendi ncowalatatika kubemba, walabemba kupita byakufwala bilibyonse ibyo muntu mbyelela kucapa pano pacishi capanshi ne kubitubisha. ");
INSERT INTO sby_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Yesu walaboneka kuli beshikwiya kabandika ne Mose ne Eliya. ");
INSERT INTO sby_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petulo mpwalaboneco walamba kuli Yesu eti, “Bashikwiyisha, caina kwambeti mpotuli pano, neco twibake mishasha itatu, umo ube wenu, naumbi ube wa Mose, kayi naumbi ube wa Eliya.” ");
INSERT INTO sby_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nsombi Petulo walabula cakwamba pakwinga bonse balaba ne buyowa bunene. ");
INSERT INTO sby_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Likumbi lyalesa kubafwekelela popelapo, ne liswi lyalanyumfwika mulikumbi akwambeti, “Uyu e Mwaname ngonsuni. Kamumunyumfwilani!” ");
INSERT INTO sby_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mpobalacebukila uku ne uku beshikwiya aba balabonowa Yesu kaliyenka, nabambi mbwambanga nabo kucana paliya. ");
INSERT INTO sby_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mpobalikuselela kufuma pa mulundu, Yesu walabambilisheti, “Ncomulabono kamutaya mwambileko muntu uliyense, mpaka panyuma pa kupunduka kubafu kwa Mwana Muntu.” ");
INSERT INTO sby_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Maswi awa balasunga mucali mwabo, nomba balikabepushana palwabo eti, “Sena kupunduka kubafu nkwalambanga Yesu uku kulapandululunga cani?” ");
INSERT INTO sby_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Neco beshikwiya balamwipusha Yesu eti, “Nipacebo cini beshikwiyisha Milawo ncobakute kwambileti welela kwisa cakutanguna ni Eliya?” ");
INSERT INTO sby_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nendi Yesu walabakumbuleti, “Nicakubinga Eliya welela kwisa cakutanguna, ne kubamba bintu byonse, nsombi kwalembweconi sha Mwana Muntu kwambeti welela kucana mapensho mangi ne kumukana? ");
INSERT INTO sby_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ame ndamwambilingeti Eliya wesakendi, ne bantu bensa kendi ciliconse ncobayandanga kwinsa, mbuli nceca lembwa mu Mabala.” ");
INSERT INTO sby_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mpobalabwelela kwalashala beshikwiya nabambi, balabona likoto lya bantu bangi kabali babashinguluka kabatotekeshanya ne beshikwiyisha Milawo. ");
INSERT INTO sby_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Bantu bonse balakankamana mpobalamubona Yesu, balamufwambila kuya kumushisha. ");
INSERT INTO sby_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nendi Yesu walabepusha beshikwiya, “Inga nipacebo cini mpomulatotekeshanyanga ne bantu aba?” ");
INSERT INTO sby_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Muntu umo walikuba mulikoto lyabantu walakumbuleti, “Bashikwiyisha, ndalete kulinjamwe mwaname mutuloba ukute mushimu wabucibulu. ");
INSERT INTO sby_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ukute kumwuwishila panshi, ne kupula mapofu kumulomo, ne kutatika kukokota meno, kulikonse nkolamwikatili, ukute ubula ne ngofu. Neco ndanga ndambili beshikwiya benu kwambeti baupulishemo, nomba cilabalili.” ");
INSERT INTO sby_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nendi Yesu walabambileti, “Mawe! Ninjikale nenu kwa masuba angaye amwe musemano wabula lushomo ndimulekeleleni cindi citali aconi? Kamumuletani kuli njame”. ");
INSERT INTO sby_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Naboyo balamutwala kuli Yesu. Nomba mushimu waipa mpowalamubona Yesu, mwana mutuloba usa walamuwisha panshi ne kufulumuka fulumuka uku kapula lipofu ku mulomo. ");
INSERT INTO sby_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu walepusha baishi kwambeti, “Inga cilamanta cindi citali cilyeconi mwana kalicisa?” Baishi balambeti, “Kufuma kubutwanike, ");
INSERT INTO sby_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Pakwinga tunkanda twingi mushimuwu ukute kuyanda kumushina, pakumuwala pa mulilo. Kayi ne mu menshi. Na ngamwinsapo ciliconse! Kamutunyumfwilako luse mutunyamfweko.” ");
INSERT INTO sby_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu walambeti, “Inga mulambilinga cani eti na ngamwinsapo ciliconse? Cintu ciliconse cinga kukonsheka kuli uyo ukute lushomo.” ");
INSERT INTO sby_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nabo baishi popelapo balolobesha ne kwambeti, “Ndashoma, nomba kamunyamfwani pakubula lushomo kwakame!” ");
INSERT INTO sby_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu pakubona likoto lya bantu lyalikwisa lubilo apo mpobalikuba, walawambila mwabukalu mushimuwo walikumwalisha kunyumfwa ne kwamba walambeti, “Obe mushimu wabucibulu fuma mu muntu uyu kotakabwelamo kayi!” ");
INSERT INTO sby_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Neco mushimuwo walolobesha ne kumunyukumuna cangofu mwanoyo, ne kupulamo, nomba walaboneketi citumbi, cakuwinseti bantu balikubapo balambeti, “Lafu!” ");
INSERT INTO sby_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nomba Yesu walamwikata kucikasa kumunyamfwilisha kupunduka neco walapunduka. ");
INSERT INTO sby_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Lino Yesu mpwalengila mung'anda, beshikwiya bakendi balatatika kumwipusha kumbali, “Inga afwe catwalilangeconi kupulisha mushimu usa?” ");
INSERT INTO sby_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu walakumbuleti, “Paliya cintu nacimbi celela kukonsha kupulisha mushimu wa mushobowu, nsombi mupailo.” ");
INSERT INTO sby_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu ne beshikwiya bakendi mpobalafumako balapitilila mu cibela ca Galileya, pakwinga nkabalikuyandeti bantu benshibeti lapitinga. ");
INSERT INTO sby_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Pakwinga walikwiyisha beshikwiya bakendi eti, “Mwana Muntu nakatwalwe mu makasa abantu, beti bakamushine, nomba nakapunduke pa busuba bwa butatu.” ");
INSERT INTO sby_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Beshikwiya baliya kunyumfwishisha ncali kwamba maswi awa, kayi balikutina kumwipusha. ");
INSERT INTO sby_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yesu pamo ne beshikwiya bakendi mpobalashika ku Kapelenawo, balengila mung'anda, walabepusheti, “Inga mwatotekeshanyanga cani pomwesanga munshila?” ");
INSERT INTO sby_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Balo balamwena tonto, pakwinga mpobesanga munshila batotekeshanyanga kuyanda kwinshiba mukulene pakati pabo niyani. ");
INSERT INTO sby_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Neco Yesu walekala panshi nekubakuwa bonse beshikwiya likumi ne babili, ne kubambileti “Namuntu layandanga kuba mutanshi abe wakupwililisha pali bonse, kayi abe musha wa bonse.” ");
INSERT INTO sby_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yesu walamanta mwana ne kumwimanika pakati pabo ne kumufukata ne kubambileti, ");
INSERT INTO sby_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Uliyense latambulunga mwana ulyeti uyu pacebo canjame, ekwambeti latambulu ame. Kayi uyo latambulunga ame, latambulunga Bata abo balantuma ame.” ");
INSERT INTO sby_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohane walambeti, “Bashikwiyisha twabona muntu kapulisha mushimu waipa kasebensesha lina lyenu, nomba afwe twamukanisha kwambeti nkelela kwinseco pakwinga nte umo wa njafwe sobwe.” ");
INSERT INTO sby_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Nendi Yesu walambeti, “Kamutamukanisha sobwe, pakwinga paliya welela kwinsa bintu bya ngofu mbulibyo kusebensesha lina lyakame welela kayi kungalukila cabwangu bwangu. ");
INSERT INTO sby_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Pakwinga uyo labulunga kutoteka afwe uli kulubasu lwetu. ");
INSERT INTO sby_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nicakubinga pakwinga uyo lamupanga nkomeshi ya menshi akunwa, pacebo cakwambeti mobakame, cakubinga nteti akabule kupewa cilambo celela.” ");
INSERT INTO sby_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Nsombi uliyense lapambulunga bana bashoma aba pa nshila yalulama, ingaciba cena kumusungilila cilibwe cinene munshingo ne kumuwala mu lwenje. ");
INSERT INTO sby_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Neco na cikasa cakobe cilakwipishinga ucitimbule, cilicena kuya kucana buyumi kokute cikasa cimo kupita kuwalwa mu gehena mu mulilo utashimiki kokute makasa onse abili. ");
INSERT INTO sby_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Kopeloko mapila eshi kubapensha nkafu, kayi nawo mulilo weshukabatentenga nteti ukashimikenga sobwe. ");
INSERT INTO sby_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kayi na mwendo wakobe ula kwipishinga pa utimbule, pakwinga cilicena kuya kucana buyumi kokute mwendo umo kupita kuba ne myendo ibili ne kuwalwa mu gehena. ");
INSERT INTO sby_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Kopeloko mapila eshikubapensha nkafu, kayi nawo mulilo weshukabatentenga nteti ukashimikenga sobwe. ");
INSERT INTO sby_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kayi na linso lyakobe lilakwipishinga, koli kolobolamo ne kulitaya, pakwinga cili cena kuya kwingila mu Bwami bwa Lesa ne liso limo, kupita kuwalwa mu Gehena kokute menso onse abili. ");
INSERT INTO sby_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kopeloko mapila eshi kubapensha nkafu, kayi nawo mulilo weshukabatentenga nteti ukashimikenga sobwe ");
INSERT INTO sby_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Pakwinga uliyense nakaswepeshewe ne mulilo mbuli mulumbo ncokute kuswepeshewa ne mucele. ");
INSERT INTO sby_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Mucele waina, nomba na mucele usambuluka niyani kayi welela kubwesheti unyumfwike mbuli ncowabanga pakutanguna? Kamubani ne cintu cishikumuswepeshewa mubuymi mbuli mucele. Kamwikalani mu lumuno pakati penu.” ");
INSERT INTO sby_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Kayi Yesu pakufuma ku Kapelenawo, walapita mu cimpansha ca Yudeya kutala kwa mulonga wa Yolodano. Bantu bangi balamubunganina, neye walatatika kubeyisha pakwinga ecalikuba cinga cakendi. ");
INSERT INTO sby_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Lino kwalashika Bafalisi nabambi balesa kumutapa mukanwa pakumwipusheti, “Sena mulawo wasuminisha mutuloba kuleka mukashendi?” ");
INSERT INTO sby_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Neye walabepusheti, “Inga Mose walamupa mulawo ulyeconi?” ");
INSERT INTO sby_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nabo balamukumbuleti, “Mose walasuminisha mutuloba kumuleka mukashendi ne kumulembela cipepala cabushike ne kumutwala kucomwabo.” ");
INSERT INTO sby_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu walambeti, “Mose walamulembela mulawo uwu pacebo ca kuyuma mitwi kwenu. ");
INSERT INTO sby_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nsombi pacitatiko Lesa mpwalalenga bintu byonse, mbuli mabala ncalambanga, Lesa ‘walababumba mutuloba ne mutukashi.’ ");
INSERT INTO sby_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Pacebo ici, mutuloba nakashiye baishi ne banyina ne kuya kupamankana pamo ne mukashendi. ");
INSERT INTO sby_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","weco aba bantu babili nibakabe umo. Neco nkabacilipo babili sobwe, nsombi umo. ");
INSERT INTO sby_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Neco aba babili Lesa mbwalapamankanya pamo, kapataba muntu shikubapansanya.” ");
INSERT INTO sby_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Mpobalabwela mu ng'anda, beshikwiya balatatika kayi kumwipusha sha makani ngwambanga. ");
INSERT INTO sby_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nsombi nendi Yesu walabambileti, “Na mutuloba uleka mukashi ne kweba mutukashi naumbi, ukute mulandu wa bupombo pakwinga lepishili mukashendi. ");
INSERT INTO sby_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Neye mukashi aleka mulume wakendi ne kuya kwebwa kumutuloba naumbi, neye ukute mulandu wabupombo.” ");
INSERT INTO sby_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Popelapo bantu nabambi balaleta bana babo kuli Yesu kwambeti abekate makasa ne kubapa colwe, nsombi beshikwiya balakalalila bantu abo balaleta bana kwambeti abape colwe. ");
INSERT INTO sby_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu mpwalaboneco, walabakalilila beshikwiya bakendi ne kubambileti, “Balekeni bana bese kuno kuli njame. Kamutabakanishanga sobwe. Pakwinga bantu balyeti bana aba, Bwami bwa Lesa nibwabo. ");
INSERT INTO sby_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ndamwambilishinga cakubinga kwambeti uyo eti abule kutambula Bwami bwa Lesa eti mwana, nteti akaingilemo.” ");
INSERT INTO sby_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Popelapo Yesu walabafukata bana ne kubika makasa akendi palyendibo kwambeti abape colwe. ");
INSERT INTO sby_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu mpwalatatika bulwendo, muntu naumbi walamufwambila. Walashika ne kwisa kusuntama pantangu ne kumwipusheti, “Amwe bashikwiyisha baina, inga ni cani ncondelela kwinsa kwambeti nkatambule buyumi bwa cindi conse?” ");
INSERT INTO sby_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Popelapo nendi Yesu walamukumbuleti, “Inga ni pacebo cini mpolang'ambanga ame kuba waina? Paliya muntu waina nsombi Lesa enka. ");
INSERT INTO sby_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Winshi milawo; Kotashina, kotapombola, kotaiba, kotamba bukamboni bwabwepeshi, kotapamba camunobe, kopa bulemu baiso ne banyoko.” ");
INSERT INTO sby_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nendi walambeti, “Bashikwiyisha ibi ndalatatika kubikonka kufumina kubutwanike bwakame.” ");
INSERT INTO sby_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu walamulangishisha ne lusuno, ne kumwambileti, “Ucili wapelebelako cintu cimo. Koya ulishe bintu byonse mbyokute. Mali ngoshucanemo upe bantu bapenshi, wenseco,buboni bwakobe nukabucane kwilu. Panyuma pakendi wise ukonke.” ");
INSERT INTO sby_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mpwalanyumfwa maswi awo, walawisha cinso walafumapo kaliwongumana, pakwinga walikuba mubile. ");
INSERT INTO sby_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu walacebukila beshikwiya bakendi ne kubambileti, “Nicapatali kubantu bakute buboni kwambeti bakengile mu Bwami bwa Lesa.” ");
INSERT INTO sby_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Maswi awa alabakankamanisha beshikwiya. Kayi Yesu walabweshapo kwambeti, “Cakubinga, amwe bana bame, nicapatali kuya kwingila mu Bwami bwa Lesa, ");
INSERT INTO sby_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","cakonsheka munyama ukute kukwiweti ngamila kwambeti apite mukamulyango ka nyeleti, kupita kwambeti muntu ukute buboni akengile mu Bwami bwa Lesa?” ");
INSERT INTO sby_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Popelapo beshikwiya balaba ne buyowa ne kutatika kwipushaneti, “Nomba na ncocibeleco niyani welela kupuluka?” ");
INSERT INTO sby_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu walabalangishisha, ne kubambileti, “Nkacikonsheke kwelana ne kuyeya kwa bantu, nomba kuli Lesa nendi paliya camukoma. Pakwinga kuli Lesa byonse bikute kukonsheka.” ");
INSERT INTO sby_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Popelapo Petulo walatatika kwamba ne Yesu, “Kamubonani afwe twalashiya byonse kwambeti twendenga nenu.” ");
INSERT INTO sby_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu walambeti, “Cakubinga ndamwambilishinga uyo walashiya ng'anda, nambi bakwabo batuloba nebatukashi, nambi baishi, nambi banabendi, nambi mabala pacebo cakame, ne Mulumbe Waina, ");
INSERT INTO sby_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nakatambule mwanda wabintu byapita mbyalikuba nabyo pacindi cino, mbuli ng'anda ne bakwabo batuloba ne batukashi, banyina ne bana ne mabala, kubikapo ne mapensho. Uyu pacindi ca pantangu nakatambule buyumi butapu. ");
INSERT INTO sby_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nomba bantu bangi bali kuntangu nibakabe kunyuma, abo bali kunyuma nibakabe kuntangu.” ");
INSERT INTO sby_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Mpobalikuba pabulwendo bwakuya ku Yelusalemu, Yesu walikwendela capantangu pa beshikwiya, nabo beshikwiya balikuba bayakamwa, nabo bantu balikubakonkela balikukute buyowa. Yesu walabakuwa palubasu beshikwiya likumi ne babili, ne kutatika kubambila bintu byeshi binshike. ");
INSERT INTO sby_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Walambeti, “Kamubonani tuli pa bulwendo bwakuya ku Yelusalemu. Twakashika Mwana Muntu nakekatwe ne kutwalwa kuli beshimilumbo bamakulene ne ku beshikwiyisha milawo. Beti bakamomboloshe ne kusuminishana sha kumushina. Kayi ni bakamutwale kubantu bamishobo naimbi. ");
INSERT INTO sby_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Beti bakamunyanshe ne kumusankila mata, ne kumukwapula kayi ne kumushina. Nomba pakapita masuba atatu nendi nakamupundushiwe kubafu.” ");
INSERT INTO sby_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jemusi ne Yohane, banabendi Sebedayo balamwipusha Yesu kwambeti, “Bashikwiyisha, tusuni kwambeti mutwinshile cili conse nceti tusenge.” ");
INSERT INTO sby_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu walabepusheti, “Inga mulayandanga ndimwinshileni cani?” ");
INSERT INTO sby_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nabo balakumbuleti, “tulayandangeti mutusuminisheti umo palinjafwe tobabili akekale ku cikasa cakululyo naumbi kucikasa cakucipiko, mwakekala mu bulemeneno bwa Bwami.” ");
INSERT INTO sby_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Nomba Yesu walabambileti, “Nkamucinshi ncomulasengenga. Sena ngamucikonsha kunwa munkomeshi ya mapensho njoti nkanwemo? Nambi kubatishiwa mulubatisho ndoti mbatishiwe?” ");
INSERT INTO sby_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nabo balamukumbuleti, “Cakubinga, ingatucikonsha.” Palico Yesu walabambileti, “Ingacibeco, nkomeshi njoti nkanwemo, nenjamwe ningamunwamo, ne lubatisho ndoti nkatambule nenjamwe nimukalutambule. ");
INSERT INTO sby_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nomba ame ntameti nkasale muntu shikwikala kucikasa ca kululyo nambi ku cikasa cakucipiko. Lesa mwine eti akape kwa kwikala abo babambilwa misena.” ");
INSERT INTO sby_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Mpobalanyumfwako banabo bali likumi balakalalila Jemusi ne Yohane. ");
INSERT INTO sby_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu walakuwa beshikwiya bakendi, ne kubambileti, “Mucinshi cena kwambeti pakati pa bantu bakunsa, bantu bakute kutangunina bakute kulyela bantu babo masuku pamutwi. Bamakulene babo bakute kubonesha ngofu shabo pa bantu babo. ");
INSERT INTO sby_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nomba nkacelela kubeco pakati palinjamwe sobwe. Uliyense layandanga kuba mukulene pakati palinjamwe, abe musebenshi wenu. ");
INSERT INTO sby_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Uliyense layandanga kuba mutangunishi wapita bonse pakati penu abe musha wa bonse. ");
INSERT INTO sby_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Pakwinga nambi Mwana Muntu uliya kwisa kusebenselwa, nsombi kulipa mwine kuba musebenshi, ne kubenga buyumi bwakendi kwambeti alubule bantu bangi.” ");
INSERT INTO sby_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesu ne beshikwiya bakendi balashika ku Yeliko. Nomba Yesu ne beshikwiya ne likoto linene mpobalikupula mu Yeliko, balacana muntu washipilwa walikukute cinga cakusengasenga kali wekala mumbali mwanshila, muntuyu walikuba Batimeyo mwanendi Timeyo. ");
INSERT INTO sby_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mpwalanyumfwa kwambeti Yesu wa ku Nasaleti elapitinga, walatatika kubilikisha, “Yesu mwanendi Dafeti! Kamunyumfwilako nkumbo!” ");
INSERT INTO sby_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nabambi bantu balamucanchilila kwambeti amwene, nomba nendi empwalapitilisha kubilikisha, “Mwanendi Dafeti kamunyumfwilako nkumbo.” ");
INSERT INTO sby_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu walemana ne kwambila beshikwiya bakendi eti, “Mukuweni ese kuno.” Neco balamukuwa ne kumwambileti, “Yumisha moyo! Nyamuka! Yesu lakukunga.” ");
INSERT INTO sby_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Neco muntu washipilwa uyu walafulula mwinjila ne kuwala panshi nekulukila mwilu ne kwisa kuli Yesu. ");
INSERT INTO sby_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu walamwipusheti, “Ulayandanga ndikwinshile cani?” Washipilwa uyo wakumbuleti, “Bashikwiyisha ndayandangeti ntatike kubona.” ");
INSERT INTO sby_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","“Koya lushomo lwakobe lulapeshepeti ube cena,” Popelapo walatatika kubona cena, ne kukonkela Yesu pabulwendo. ");
INSERT INTO sby_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Mpobalashika ku Yelusalemu pepi ne minshi ya Betifagi ne Betani mumbali mwa mulundu wa Maolifi, Yesu walatuma beshikwiya babili. ");
INSERT INTO sby_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ne kubambileti, “Kamuyani mu mushi ngomulabononga usa, mwengila nimucane mwanambongolo wasungwa, utana utantwapo ne muntu, mumusungulule mumulete kuno. ");
INSERT INTO sby_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Na muntu naumbi amwipusheti ingamula mutwalanga kupeyo, mumwambileti Mwami layandanga kumusebensesha, apwisha na mulete kayi.” ");
INSERT INTO sby_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Neco mpobalaya balacana mwanambongolo, kaliwasungililwa pa cishinga pepi ne nshila, nabo balamusungulula. ");
INSERT INTO sby_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Bantu balikuba pepi balepusheti, “Inga mulamusungululwinga cani?” ");
INSERT INTO sby_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nabo balakumbula mbuli Yesu ncalabambila. Neco balabasuminisha beshikwiya. ");
INSERT INTO sby_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nabo balamuleta mwanambongolo kuli Yesu, ne kubika cikwisa pa musana pa mwanambongolo kwambeti aikalepo Yesu. ");
INSERT INTO sby_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bantu bangi balayansa bikwisa byabo panshila, nabambi balatimbula misampi yatutondo twamulibala. ");
INSERT INTO sby_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bantu bonse balikuba pantangu ne abo balikuba kunyuma balatatika kubilikisheti, “Lesa alumbaishiwe! Lesa ape colwe uyo lesanga mulina lya Mwami. ");
INSERT INTO sby_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Lesa ape colwe Bwami bulesanga bwa Dafeti mushali wetu. Lesa wa Kwilu kumayoba alumbaishiwe!” ");
INSERT INTO sby_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu mpwalashika mu Yelusalemu, walengila mu Ng'anda ya Lesa, ne kulanga langa byonse. Pakwinga calikuba kendi cindi ca mansailo, walapula ne kuya ku Betani pamo ne beshikwiya likumi ne babili. ");
INSERT INTO sby_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mpobwalaca mumene Yesu walanyumfwa nsala pakufuma ku Betani. ");
INSERT INTO sby_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kaciliko patali walabona citondo ca mukuyu cikute matewu, walaya pepi kwambeti abone mpani inga kacikute nkuyu, nsombi mpwalashika mwinshi walacaneti cikute matewu onka, pakwinga nkacalikuba cindi cakuba ne nkuyu. ");
INSERT INTO sby_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Neco, Yesu walacambileti, “Paliya muntu eshakalyeko nkuyu ku citondo ici!” Beshikwiya bakendi balamunyumfwa kambeco. ");
INSERT INTO sby_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Lino Yesu mpwalashika ku Yelusalemu walengila mu Ng'anda ya Lesa, ne kubatandanyamo bonse balikulishilamo makwebo. Walawisha matebulu ngobalikulishapo, ne bipuna mbyobalikuba bekalapo pakulisha nkulimba shabo. ");
INSERT INTO sby_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Uliyawa kusuminisha uliyense kupitila mu lubuwa lwa Ng'anda ya Lesa kaliwamanta kantu. ");
INSERT INTO sby_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Yesu waleyisha bantu ne kubambileti, “Sena nkacalembwa, ‘ng'anda ya kame nikakwiweti ng'anda yakupaililamo ya bantu bamishobo yonse.’ Nomba amwe mulaisandulu kuba mwakwikala bantu beshikulamuna banabo.” ");
INSERT INTO sby_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Beshimilumbo bamakulene ne beshikwiyisha milawo ya Mose mpobalanyumfwa, balatatika kulangaula nshila ya kumushininamo Yesu, nomba balikumutina pacebo ca bantu abo balikukankamana ne njiyishilo yakendi. ");
INSERT INTO sby_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Mpokwalashipuluka pa muntu ngulya, Yesu ne beshikwiya bakendi balafuma mu Yelusalemu. ");
INSERT INTO sby_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Cindi ncobalikwenda mushila mpobwalaca mumenemene, balabona citondo ca mukuyu cisa calanshinganwa ne Yesu kacili cayuma conse mpaka kumiyanda. ");
INSERT INTO sby_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petulo walanuka calenshika, ne kumwambila Yesu, “Bashikwiyisha kamubonani citondo ca mukuyu ncomwashingana cilayumu”. ");
INSERT INTO sby_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Nendi Yesu walabakumbuleti, “Kamushomani muli Lesa. ");
INSERT INTO sby_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Cakubinga ndamwambilinga na muntu uwambila mulundu eti fuma apo mpobele, koya uliwale mu lwenje, kwamba kwakubula kutonshanya, nomba kali washometi ncalambanga ni cikenshike nditu nikenshike. ");
INSERT INTO sby_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Pacebo ici, ndambilishingeti, mwapailinga ne kusenga cintu, shomani kubeti mulacitambula kendi, cili conse ncomulasengenga nimukapewe.” ");
INSERT INTO sby_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“Mwatatikanga kupaila, lekelelani bonse bamwipishila kwambeti Lesa wakwilu nendi amulekeleleni bwipishi bonse.” ");
INSERT INTO sby_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Na mubula kulekelela banenu, naboyo Bameshenu bakwilu nkabela kumulekelela bwipisho bwenu. ");
INSERT INTO sby_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Kayi Yesu mpwalaya ku Yelusalemu walengila mu Ng'anda ya Lesa ne kwendana mu lubuwa, beshimilumbo bamakulene, ne beshikwiyisha milawo ya Mose, ne bamakulene nabambi balesa kuli Yesu. ");
INSERT INTO sby_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Balamwipusheti, “Mukute ngofu shilye coni shakwinsa cisa kwakubula kusuminishiwa? Niyani wakupa ngofu shakwinsa cisa?” ");
INSERT INTO sby_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu walabakumbuleti, “Ndamwipushunga mwipusho umo, na mukumbule, nenjame nindi mwambile ngondashifunya ngofu shakwinsa bintu ibi. ");
INSERT INTO sby_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Inga Yohane walashifunya kupeyo ngofu shakubatisha? Kuli Lesa nambi kubantu? Kamunkumbulani.” ");
INSERT INTO sby_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Balakangana pa lwambo bene ne kwambeti na tukumbuleti lwalafumina kwilu ku mayoba, nendi natwipusheti, “Inga mwalabulila cani kushoma ncalikwamba?” ");
INSERT INTO sby_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Nomba nkatwela kwambeti,lwafumina kubantu. Pakwinga balikutina bantu, bonse balikuba bashoma kwambeti Yohane walikuba mushinshimi. ");
INSERT INTO sby_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Neco mukumbulo wabo kuli Yesu walikuba wakwambeti, “Nkatucishi?” Neco Yesu walabakumbuleti, “Nenjame nteti ndimwambile nkondalashifunya ngofu shakwinsa cisa.” ");
INSERT INTO sby_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Kayi Yesu walatatika kwamba kulyendibo mu mikoshanyo, walambeti, “Palikuba muntu naumbi walalima libala lya minyansa. walebaka luba kushunguluka libala, walemba cisengu cakutyaninamo minyansa ne kwibaka lupingwe. Libala ili walalibwelekesha ku balimi, nendi walaya kucishi cimbi. ");
INSERT INTO sby_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mpocalashika cindi ca kutebula, mwine libala walatuma musebenshi wakendi ku balimi mbwalabwelekesha, kwambeti bamupeko bisepo bya mulibala lisa. ");
INSERT INTO sby_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nomba nabo balamwikata, ne kumuma ne kumutandanya, walabwelelako wabula ciliconse mu makasa. ");
INSERT INTO sby_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mwine libala walatumako kayi musebenshi wakendi naumbi. Nomba uyu balamutoba luma mu mutwi ne kumucobola cipesha nsoni. ");
INSERT INTO sby_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kayi mwine libala walatumako naumbi, uyu balamushina. Kayi walatumako nabambi nabo balabauma, kayi nabambi balashina. ");
INSERT INTO sby_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kwalashala muntu umo, mwanendi ngwalikusuna cikamba. Pakupwililisha mwine libala usa walatumako mwanendi,” Ne kwambeti, “Mwaname nibenga bamupe bulemu.” ");
INSERT INTO sby_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nomba nabo balimi balatatika kumufwiya ne kwambeti, “Uyu endiye eshakapyane buboni bwa baishi, neco katumushinani kwambeti bukabe bwetu, ");
INSERT INTO sby_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Balamutanya, ne kumushina, ne kumuwala kunsa kwa luba lwa libala.” ");
INSERT INTO sby_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Inga mwine libala nakenseconi? Lakenga kubashina balimi bonse ne kubwelekesha libala lyakendi kubalimi nabambi.” ");
INSERT INTO sby_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Sena nkamuna mubelengapo Mabala alambangeti, “Libwe lya candanshi ndyebalakana Beshikwibaka, Lyalaba libwe lyayandika Kupita onse. ");
INSERT INTO sby_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mwami mwine elacinshi, Kayi cakondelesha pakucibona?” ");
INSERT INTO sby_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Balelekesha kucana nshila ya kumwikatilamo, nomba balatina kufula kwa bantu, pakwinga balenshibeti wambangendibo mumukoshanyo, nomba balamushiya Yesu ne kuya. ");
INSERT INTO sby_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Bafalisi nabambi ne ba mucipani ca Helodi balatumwa kuli Yesu kwambeti bamutape mukwamba kwakendi. ");
INSERT INTO sby_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Mpobalashika kuli Yesu balambeti, “Bashikwiyisha tucinshi, kwambeti mukute kwamba cakubinga, kayi nkamukute kubona cilikunsa kwa muntu, nkamukute kusakamaneti uyu niyani, nsombi mukute kwiyisha nshila ya Lesa mwancine ncine, Sena kusonka musonko ku mwami wa ku Loma casuminishiwa nambi sobwe?” ");
INSERT INTO sby_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","“Tusonkenga misonko nambi sobwe?” Yesu pakubenshiba bundenga mano bwabo, walabambileti, “Ingamulanjelekeshelenga cani? Kamundetelani lyali ndilibone.” ");
INSERT INTO sby_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Balamutambika lyali, Yesu walabepusheti, “Inga cintimbwi cilipa lyali, ne walembapo niyani?” Balamukumbuleti “Ni ca Mwami waku Loma.” ");
INSERT INTO sby_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Neco Yesu walabambileti, “Mupeni Mwami waku Loma bintu byakendi, nendi Lesa mupeni bintu byakendi.” Nomba balakankamana ne kwamba kulico. ");
INSERT INTO sby_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Basaduki nabambi batashomo sha kupunduka kubafu balesa kuli Yesu ne kwambeti, ");
INSERT INTO sby_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Bashikwiyisha, Mose walatulembela afwe kwambeti na muntu ufwa ushiya mukashi enka wabula mwana, kanike wakendi shikufwa amwebe mukalubingi ne kusemenamo bana mu mulamu wakendi mucimo ca mukwabo ");
INSERT INTO sby_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Lino palikuba batuloba basanu ne babili pabukwabo. Mukulene bantu waleba mukashi, nsombi walafwa kwa kubula kushiyapo bana, ");
INSERT INTO sby_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","mukwabo wamukonkapo walamweba mukalubingi, neye walafwa katana asemenamo mwana. Calenshika copeleco ku mukwabo wa butatu. ");
INSERT INTO sby_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Walebwa kuli umo ne umo wa bonse basanu ne babili, nsombi bonse balafwa kwakubula kusemenamo bana, panyuma pakendi neye mukashi uyu walafwa. ");
INSERT INTO sby_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Lino bantu bakapundukanga kubafu nakabe mukashi wa bani? Pakwinga bonse basanu ne babili balamwebapo?” ");
INSERT INTO sby_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu walabakumbuleti, Sena ici nteco cilapeshengeti mulubile cakwinseti mubule kwinshiba Mabala ne ngofu sha Lesa? ");
INSERT INTO sby_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Pakwinga bantu beti bakapunduke kubafu nteti bakebenga nambi kwebwa, pakwinga nibakabengeti bangelo ba kwilu. ");
INSERT INTO sby_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na nimakani akwambeti sena bafwa nibakapunduke, sena muliya kubelengapo muli buku lya Mose mpalikwamba sha cifukusa calikubangila mulilo? Lesa mpwalambila Mose eti, “Ame njame Lesa wa Abulahamu, Lesa wa Isake, kayi Lesa wa Yakobo. ");
INSERT INTO sby_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nte Lesa wa bantu bafwa, nsombi wa bayumi, mwalubila kwine!” ");
INSERT INTO sby_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Umo wa beshikwiyisha milawo ya Mose walabanyumfwa kabakangana umo ne munendi. Kayi pakuboneti Yesu labakumbulu cakubinga ba Saduki, walamwipusha Yesu eti, “Inga nimulawo upeyo utanshi kupita yonse?” ");
INSERT INTO sby_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu walamukumbuleti, Mulawo utanshi ni wakwambeti, “Kamunyumfwani amwe Baislayeli, Mwami Lesa wetu, eMwami umo enka bulyo walibela. ");
INSERT INTO sby_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Neco suna Mwami Lesa wakobe ne moyo wakobe wonse, ne mushimu wakobe onse, ne manjeyaulwa akobe onse, kayi ne ngofu shakobe shonse.” ");
INSERT INTO sby_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mulawo watubili ni wakwambeti, “Suna munobe mbuli ncolisuni omwine, Paliya mulawo wapita pa milawo ibili iyi sobwe.” ");
INSERT INTO sby_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Shikwiyisha Milawo ya Mose walamwambila Yesu,eti “Ncomulamba Bashikwiyisha nicakubinga, Ee pali Lesa umo enka, paliya naumbi sobwe nsombi enka bulyo. ");
INSERT INTO sby_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nomba kusuna Lesa ne moyo wakobe wonse ne buyumi bwakobe bonse ne manjeyaulwa akobe onse, kayi ne ngofu shakobe shonse, ne kusuna bantu banobe mbuli ncolisuni, kulayandikinga kupita kutwala milumbo ya banyama ne milumbo naimbi kuli Lesa.” ");
INSERT INTO sby_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu pakwinshibeti lakumbulu camano, walamwambileti, “Obe nkolipo kutali ne Bwami bwa Lesa sobwe.” Neco bonse balaba ne buyowa, neco bonse balatina bamwipusha Yesu mwipusho naumbi. ");
INSERT INTO sby_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu mpwalikwiyisha Mung'anda ya Lesa, walepusheti, Inga beshikwiyisha milawo ya Mose ngabambeconi eti Klistu nimwanendi Dafeti? ");
INSERT INTO sby_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kakuli Dafeti mwine pakutanguninwa ne Mushimu Uswepa, walambeti, Mwami Lesa walamba kuli mwami wakame, eti kwesa wikale ku cikasa calulyo cabulemu, mpaka nkababike balwani bakobe panshi pa myendo yakobe. ");
INSERT INTO sby_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dafeti mwine walamwambeti, “Mwami” Ngobaconi mwanendi Dafeti? Likoto lyabantu balikumunyumfwa Yesu mwakukondwa. ");
INSERT INTO sby_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu mpwalikwiyisha, walambeti, “Cetukani ne beshikwiyisha milawo ya Mose, basuna kwendana kabali muminganjo yalelemba nekuyanda kupewa mitende yabulemu mu misena ya makwebo, ");
INSERT INTO sby_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","bakute kuyanda kwikala pa bipuna byakuntangu mung'anda ya kupaililamo, ne mumisena ya bulemu musena yamalyalya. ");
INSERT INTO sby_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Aba bantu ebakute kupwisha buboni bwa bamukalubingi, nekulibonesheti bantu balulama mumipailo yabo itali itali, aba bantu nibakatambule lombolosho lunene!” ");
INSERT INTO sby_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kayi Yesu mpwalekala pepi ne kabokoshi bantu nkobalikubikamo mali mung'anda kupaililamo, walikalangishisha bantu ncobalikubikamo mali. Abo balikuba ne buboni balikubikamo mali angi, ");
INSERT INTO sby_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Palashika mukalubingi mupenshi, nendi walabikamo tumali tubili twa mukuba. ");
INSERT INTO sby_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Neco walakuwa beshikwiya bakendi nekubambileti, cakubinga ndamwambilinga, mukalubingi mupenshi uyu labikimo mali angi kupita ngobalabikimo bonse. ");
INSERT INTO sby_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Pakwinga bonse batapulanga pa mali apitilila pa mali ngobakute kusebensesha, nsombi nendi mubupenshi bwakendi labikimo mali ngwakutenga onka mung'anda, ebwanga buyumi bwakendi. ");
INSERT INTO sby_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu mpwalafuma mu Ng'anda ya Lesa, umo wabeshikwiya bakendi walambeti, “Bashikwiyisha kamubonani kukonempa ne kubekema kwa mabwe ne manda awa?” ");
INSERT INTO sby_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Nomba nendi Yesu walamukumbuleti, “Nte ulabono manda anene anene awa onse? Paliya libwe nambi limo lyeti likashale pelu pa libwe linendi, lyeti likabule kumwaiwa.” ");
INSERT INTO sby_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu mpwalekala panshi pamulundu wamaolifi, nkabali balangana ne Ng'anda ya Lesa, Petulo ne Jemusi, ne Yohane kayi ne Ndileya balamwipusha mpobalikuba bonka nendiye kwambeti ");
INSERT INTO sby_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Kamutwambilani, inga bintu ibi nibikenshikelilyoni? Inga nicishibisho cini nceti tukaboneneko kwambeti byonsebi bilipepi kukwanilishiwa?” ");
INSERT INTO sby_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu walabambileti “Cetukani, muntu uliyense katakamubepa. ");
INSERT INTO sby_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Pakwinga bantu bangi nibakese lina lyakame, ne kwambeti ‘njame Klistu!’ Bantu bangi nibakabepwe. ");
INSERT INTO sby_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mwakatatika kunyumfwa sha nkondo ne mbili shankondo kamutakayakamwa sobwe. ibi byelela kwinshika, nomba ntewo mapwililisho sobwe. ");
INSERT INTO sby_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mishobo ya bantu nikabukilane, bishi nibikabukilane, Nikukabe mikunkumo mumibibela byapusana pusana, kayi nikukabe nsala. Lino byonse ibi ekutatika kwa mapensho.” ");
INSERT INTO sby_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Nomba amwe cetukani, pakwinga bantu nibakamutwale kunkuta ne kumukwapula mumanda akupaililamo.Nimukamane pamenso pa bendeleshi ba mfulumende ne bami, pacebo ca njame, kwambeti mukabe bakamboni bakame. ");
INSERT INTO sby_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nomba kulayandikinga nanshi kwambeti Mulumbe Waina ukambaukwe kubantu ba mishobo yonse. ");
INSERT INTO sby_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nomba bakamwikata ne kumutawala kuya komboloshewa, kamutakalibilika nekwambeti, netwambe cani, Lesa nakamupe cakwamba pacindi copeleco pakwinga shikwamba ntamwe sobwe, nsombi ni Mushimu Uswepa. ");
INSERT INTO sby_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mukwabo nakashinishe mukwabo, bamashali nibakashinishe bana babo. Nabo bana nibakabukile bamashali babo ne kubashinisha ");
INSERT INTO sby_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kayi muntu uliyense nakamupele, pacebo ca Lina lyakame, nomba uyo eti akalishishibishe mpaka kumapwililisho endiye esha akapuluke.” ");
INSERT INTO sby_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Mwakabona cintu cishikusesemya kayi cishikononga, balacimaniki pamusena ngocabula kwelela, uyo labelengenga enshibe, abo bali mu Yudeya bafwambile ku milundu. ");
INSERT INTO sby_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Uyo uli pelu pa ciluli kataseluka nekuya kwingila mung'anda yakendi kwambeti amantemo ciliconse. ");
INSERT INTO sby_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Uyo muntu uli mulibala katabwelela ku munshi kuya kumanta byakufwala mbyalashiyi ");
INSERT INTO sby_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ha! Akonempa mapensho kubatukashi bakute mabunda, ne beti bakayamwishenga bana mu masubayo! ");
INSERT INTO sby_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kamupailani kwambeti kacitakaba mucindi camupewo. ");
INSERT INTO sby_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Pakwinga mumasubayo bantu nibakapenge ncebatana bapengapo kufuma kucindi Lesa ncalalenga cishi mpaka kushika cindi cino, kayi nteti bakapengepo cilico sobwe. ");
INSERT INTO sby_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Lesa nalabula kwafumfwipishilalimo masubayo, nshinga ne palakabulu muntu naba umo shikupuluka, nomba pacebo ca bantu basalwa bakendi, masubayo walafumfwipishilalimo. ");
INSERT INTO sby_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Nomba pacindi copeleco, na muntu akamwambileti, “Kamubonani Klistu ulikuno, Nambi wambeti, ‘Klistu uli uko!’ Kamutakashoma. ");
INSERT INTO sby_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Pakwinga nikukaboneke ba klistu bangi bandemi shibili ne bashinshimi bandemi shibili. Nibakensenga bingashilo ne bintu bishikukankamanisha, ne kubepa uliyense kayi na kacikonsheka, nabo basalwa, bashome bwepeshi. ");
INSERT INTO sby_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Neco amwe cetukani! Ndamwambilili limo bintu byeti bikenshike.” ");
INSERT INTO sby_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Mumasubayo, cindi camapensho cakapita lisuba nilikasanduke mushinshe ne mwenshi nukaleke kubala. ");
INSERT INTO sby_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Nyenyenshi nishikatatike kulaka kufuma kwilu, ne ngofu sha bwendeleshi bwa mwilu nibukatenkane ");
INSERT INTO sby_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Lino, bantu nibakamubone Mwana Muntu kesa mumakumbi ne ngofu shinene ne bulemeneno. ");
INSERT INTO sby_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Pacindico Yesu nakatume bangelo bakendi kuya kubunganya bantu basalwa mumbasu shonse, kufumina kwakuma cinshi ne kuya kwakuma cishi. ");
INSERT INTO sby_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Kamwiyakoni mukoshanyo kucitondo camukuyu. Misampi yatatika kusonsa matewu mukute kwinshibeti mainsa alipepi. ");
INSERT INTO sby_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nenjamwe mwakabona bintu ibi kabinshika nimukenshibeti Mwana Muntu ulipepi, uli pacishinga. ");
INSERT INTO sby_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Cakubinga ndamwambilishingeti uwu musemano nteti ukapite sobwe mpaka ibi bintu bikenshike. ");
INSERT INTO sby_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kwilu ne cishi capanshi nibikapite, nsombi ciyisho cakame nteti cikapite sobwe. ");
INSERT INTO sby_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Nomba kwamba sha cindi nambi busuba, paliya naba umo ubwinshi, nambi bangelo ba kwilu nkabacinshi, nambi mwana nkabwinshi nsombi Bata bonka.” ");
INSERT INTO sby_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Cetukani, pembelelani, pakwinga nkamucishi na nililyoni cindi ncoti cikashike. ");
INSERT INTO sby_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ici cili mbuli cikutekwinshika muntu aya pabulwendo, ukute ushiya mukowa nekupa ngofu basebenseshi bakendi, uliyense incito yakendi. Ne kumukonkomesha mulonda kwambeti katashinshilanga. ");
INSERT INTO sby_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nenjamwe cetukani, pakwinga nkamucishi cindi ncoti akese mwine ng'anda, mpani ni mansailo, mpani ni paka pa mashiku, mpani pacindi ca malililo abakombwe mpani nimumenemene, ");
INSERT INTO sby_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","kwambeti mwine ng'anda esa mwakutengashila, katesamucane kamuli monatulo. ");
INSERT INTO sby_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Neco ncondamwambilinga amwe ndambilinga bonse. Weco cetukani. ");
INSERT INTO sby_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Mpokwalashala masuba abili kwambeti kube Pasika, ne kusekelela kwa shinkwa wabula chishikufufumusha. Beshimilumbo bamakulene ne beshikwiyisha Milawo ya Mose, bali kulangaula mwakumwikatila Yesu kwakubula kwinshiba bantu kwambeti bamushine. ");
INSERT INTO sby_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nomba balikwambeti “Nkatwelela kumwikata pa cindi cakusekelela sobwe, pakwinga ngapaba mipyopyongano.” ");
INSERT INTO sby_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu mpwalikuba mung'anda ya shimoni, shimankuntu ku Betani, pacindi ncebalikulya kwalashika mutukashi walikuba wamata nsupa yalibwe lya alabasita mwalikuba wabika mafuta anunkila amulo wadula, amushobo wa nadi. Walapwaya nsupa ya libwe ne kutatika kwitila mafuta pa mutwi wa Yesu. ");
INSERT INTO sby_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nomba nabambi calabepila, balambeti “Nipacebo cini ncalatayilinga awa mafuta anunkila cisa?” ");
INSERT INTO sby_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","“Canga celela kwaulisha mafutawa ne kucanamo mali angi ngelakufola muntu pa caka, akunyamfwilisha bakandu.” Neco balamukalalila mutukashi usa. ");
INSERT INTO sby_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nomba Yesu walambeti, “Mulekeni, mulamupenshelenga cani uyu mutukashi? Ici ncalenshili ame caina. ");
INSERT INTO sby_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Pakwinga bakandu mulinabo cindi conse, cakwinseti mwayandanga kubenshila byaina, inga mubenshila, nomba amwe nteti mubenga nenjame cindi conse sobwe. ");
INSERT INTO sby_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Uyu mutukashi lenshi ncelela kwinsa, pakwinga lananikili limo mafuta pamubili wakame kantanambikwa mu manda. ");
INSERT INTO sby_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Cakubinga ndambangeti kulikonse uko Mulumbe Waina nkoti ukakambaukwe pa cishi conse. Ici ncalenshi mutukashi uyu naco nibakacambenga kubantu kwambeti bakamwanukilengaponga.” ");
INSERT INTO sby_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nomba Yuda Sikalyote umo wa beshikwiya likumi ne babili, walaya kuli beshimilumbo bamakulene kuya kumulisha kulyendibo. ");
INSERT INTO sby_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Balakondwa mpobalanyumfwa ncalabambila ne kumushomesha kwambeti nibakamupe mali ngobalapangana. Nendi walatatika kulangaula cindi celela ca kumulisha. ");
INSERT INTO sby_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pabusuba bwakutanguna bwa kusekelela kwa shinkwa wabula cishikufufumusha, pacindi ncobali kubenga milumbo ya nyama, beshikwiya bakendi Yesu balamwipusheti, “Inga mulayandanga twengakupeyo kuya kumubambila musena wakulyelako Pasika.?” ");
INSERT INTO sby_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Popelapo Yesu walatuma beshikwiya babili kuya kulangaula musena, ne kubambileti, “Kamuyani mu munshi uwu. Nimukumane ne mutuloba wamanta mungomo wa menshi mumukonkele. ");
INSERT INTO sby_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Engila mung'anda mumwambile mwine, eti ‘Bashikwiyisha balepushungeti, cilikupeyo cipinda cabensu umo mweti njise ndyele Pasika pamo ne beshikwiya bakame? ");
INSERT INTO sby_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nomba amulesha ng'anda yapelu mwabambwa cena, mopelomo mweshimubambile Pasika.” ");
INSERT INTO sby_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Neco beshikwiya basa balaya mumunshi, kayi byalenshika ndendende mbuli mwalabambilila, Pasika balamubambila kopeloko. ");
INSERT INTO sby_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Cakumansailo Yesu pamo ne beshikwiya likumi ne babili balashika. ");
INSERT INTO sby_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Pacindi ncobalekala panshi kabalya Yesu walabambileti, “Cakubinga ndamwambilinga umo pali njamwe uyo lalinga pamo nenjame nangulishe.” ");
INSERT INTO sby_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Bonse balanyumfwa nsoni ne kutatika ku mwipusha Yesu umo ne umo kabambeti, “Ndashometi ntame ngomulambanga ayi?” ");
INSERT INTO sby_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nendi Yesu walambeti, “Umo pali amwe likumi ne babili, ‘Umo pali njamwe, uyo walyanga pamo nenjame mumbale iyi, epeloyo elangulishinga.’ ");
INSERT INTO sby_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ni cakubinga Mwana Muntu lenga akufwa, mbuli Mabala ncalambanga sha endiye, nomba malele ku muntu lamulishinga Mwana wa Muntu! Ne calaba cena muntuyo nalabula kusemwa.” ");
INSERT INTO sby_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mpobalikulya Yesu walamanta shinkwa ne kulumba Lesa, ne kukomauna shinkwa ne kubapa, ne kwambeti, “Kamumanta shinkwa uwu, emubili wakame.” ");
INSERT INTO sby_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kayi walamanta nkomenshi mwalikuba waini walalumba Lesa, panyuma pakendi walabatambika nkomeshi mpaka bonse balanwamo. ");
INSERT INTO sby_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Panyuma pakendi walabambileti, “Waini uwu emilopa yakame ya Cipangano iletikilinga bantu bangi. ");
INSERT INTO sby_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Cakubinga ndamwambilingeti, nteti nkanwepo waini mpaka pa busuba ubo mbweshi nkanwe waini naumbi mu Bwami bwa Lesa.” ");
INSERT INTO sby_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Mpobalapwisha kwimbila nyimbo shakushikaisha Lesa balapula ne kuya ku mulundu maolifi. ");
INSERT INTO sby_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu walabambileti, “Mwense nimunkane mbuli Mabala alambangeti, ‘Ninkashine mwembeshi, ne mbelele ni shikamwaike.’ ");
INSERT INTO sby_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ndakapundushiwa kufuma kubafu, ninkamutangunine kuya ku Galileya.” ");
INSERT INTO sby_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petulo nendi walambeti kuli Yesu, “Nambi bonse bamukane ame nkandelela.” ");
INSERT INTO sby_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu popelapo walamwambileti, “Cakubinga ndakwambilinga obe Petulo Kombwe katanalila tunkanda tubili lelo mashiku, obe nunkane tunkanda tutatu.” ");
INSERT INTO sby_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nsombi nendi Petulo walakumbula cangofu, “Nkandelela kwambeco, nambi eti mfwa pamo nenjamwe!” Beshikwiya nabambi bonse balamba cimocimo. ");
INSERT INTO sby_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Mpolabashika pa musena walikukwiweti Getsemane Yesu walabambila beshikwiya bakendi, “Kamwikalako panshi pamo ndenga kuya kupaila kuli Lesa.” ");
INSERT INTO sby_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pakuya uko walamanta Petulo ne Jemusi kayi ne Yohane, nsombi walapenga ne kuyakamwa mumoyo. ");
INSERT INTO sby_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Neco walabambileti, “Ame ndetelwa mumoyo cakwinsa kufwa, kamwikalani pano, kamutashinshila.” ");
INSERT INTO sby_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Mpwalendako ntamwa shingana Yesu walaliwisha panshi nekutatika kupaileti, nakacikonsheka cintu cilayandanga kwinshika pacindi ici, cibule kwishinka. ");
INSERT INTO sby_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kayi walambeti, “Abba, Ta, Amwe ngamwinsa bintu bili byonse, kamufunyani nkomeshi mapensho ilayandanga kwisa pali njame, nsombi kakutaba kuyanda kwakame, sobwe nsombi kube kuyanda kwenu.” ");
INSERT INTO sby_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Mpwalabwela pamusena mpwalabashiya walacana kabali bonatulo, neco walepusha Petulo, “Shimoni sena ucili wonatulo, ‘nkowelela kuliyumishako kwakacindi kang'anowa?” ");
INSERT INTO sby_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kayi walabambileti, “Mobantu amwe pundukani, mupaile kwambeti kamutengila mumapensho, cakubinga, moyo ulandishishinga, nomba mubili walefuka.” ");
INSERT INTO sby_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yesu walabashiya kayi beshikwiya batatu basa, walaya akupaila kayi kamba cimo cimo. ");
INSERT INTO sby_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Mpwalabwela walacana nkabali bonatulo pakwinga bikope byabo byalikuba byalema, neco balabula cakwamba kulyendiye. ");
INSERT INTO sby_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Walabwela kacitatu ne kubepusheti “Mucili monatulo ne kupumwina? Mwaliba! Cindi cilakwana kamubonani Mwana Muntu ulipepi kutwalwa mu makasa abantu baipa. ");
INSERT INTO sby_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nyamukani, tiyeni. Kamubonani shikungulisha nte uyu lashiki.” ");
INSERT INTO sby_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu kacamba maswi awa Yuda Isikalyoti umo wabeshikwiya likumi ne babili walashika pamo ne likoto lyabantu abo balatumwa ne beshimilumbo bamakulene, ne beshikwiyisha milawo ya Mose ne bamakulene, kabalibamanta byensho, ne mingwala. ");
INSERT INTO sby_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Apa shikumulisha Yesu wali kalilabapakendi cishibisho ncobalayumfwana pamo cakwambeti, “Uyo ngotinshonshote pakumupa mitende, endiye Yesu mumwikatishe, mwenganendi, kamutamulekapo.” ");
INSERT INTO sby_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yuda walaya pali kuba Yesu mwakufwambana ne kwambeti, “Mitende Bashikwiyisha,” Ne kumunshonshonta. ");
INSERT INTO sby_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Neco balamutanya Yesu ne kumusunga. ");
INSERT INTO sby_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nomba naumo walikuba wemana pepi walasolola cibeshi cakendi ne kukwempula naco litwi lya musebenshi wa Shimilumbo Mukulene. ");
INSERT INTO sby_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nendi Yesu walabepusheti, “Inga mulamantili cani bibeshi, ne mingwala pakwisa kunjikata eti mulesanga kulwana ne kapondo? ");
INSERT INTO sby_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Masuba onse ndalikuba nenu mpondali kwiyisha mu Ng'anda ya Lesa, muliyawa kuyeya shakunjikata. Nomba ibi bilenshikinga kwambeti Mabala akwanilishiwe.” ");
INSERT INTO sby_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Beshikwiya bonse balafwamba ne kumushiya enka. ");
INSERT INTO sby_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nomba mutuloba naumo walikuba walifweka mwingila walikakonkela Yesu. Neye balayanda kumwikata, ");
INSERT INTO sby_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Walashiya cakufwala cakendi mumakasa abo ne kufwamba matakosha. ");
INSERT INTO sby_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Balamutwala Yesu kuli Shimilumbo mukulene uko nkobalabungana beshimilumbo bonse, ne beshikwiyisha ya milawo ne bamakulene bonse. ");
INSERT INTO sby_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Nomba Petulo walikuba pamo ne bantu bangi abo balikukonkela panyuma, mpaka walakengila mukati mwalubuwa lwa ng'anda ya Shimilumbo Mukulene, walakekala panshi pamo ne bamalonda kayota mulilo. ");
INSERT INTO sby_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pacindici beshimilumbo bamakulene, pamo ne Nkuta inene ya Bayuda, bali kulangaula bukamboni bwakwambeti Yesu acanike ne mulandu wakumushina, nomba calala kubacana. ");
INSERT INTO sby_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Pakwinga bangi balamba bukamboni bwapusanapusana pakuyanda kumucaninapo mulandu Yesu. ");
INSERT INTO sby_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nikukabeco nabambi bali kwimana ne kwamba bukamboni bwabwepeshi, ");
INSERT INTO sby_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","ne kwambeti, “Afwe twalamunyumfwa kambeti, ‘Ame ninkaiwishe Ng'anda ya Lesa iyi yalebakwa ne makasa,’ Nomba mu masuba atatu ame ninkebake imbi itebakwa ne makasa.” ");
INSERT INTO sby_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nikukabeco byonse mbyobalikwamba nkabyalikuba byekatana. ");
INSERT INTO sby_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Shimilumbo mukulene walemana ne kumwipusha Yesu, “Sena uliyawa cakwambapo? Sena nibyakubinga ibi mbyobala kwambanga?” ");
INSERT INTO sby_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nomba nendi walamwena tonto, uliya kwambapo ciliconse. Apa kayi Shimilumbo Mukulene walamwipusha Yesu, “Sena njobe Klistu, Mwanendi Lesa Walelekwa?” ");
INSERT INTO sby_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu walakumbuleti, “Cakubinga ame njame. Mobantu amwe nimukabone Mwana Muntu kaliwekala kucikasa ca lulyo ca ngofu, nimukamubone kesa mumakumbi akwilu.” ");
INSERT INTO sby_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Shimilumbo mukulene mpwalanyumfwa maswi awa walatwamuna mwinjila wakendi nekwambeti, “Sena muciyanda kayi bakamboni nabambi? ");
INSERT INTO sby_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mulalinyumfwili mobene ncalamunyansa Lesa. Mulayeyengapongeconi?” Bonse balambeti lacaniki ne mulandu, welela kufwa. ");
INSERT INTO sby_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Popelapo nabambi balatatika kumusankila mata, kumufweka pamenso, ne kumuma makofi, ne kwambeti, “Lotela!” Inga niyani lakumu? Panyuma pakendi, bamalonda balamumanta kabaya kumuma. ");
INSERT INTO sby_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petulo kacili mu lubuwa lwamukati, umo musebenshi mutukashi wa Shimilumbo Mukulene walesa. ");
INSERT INTO sby_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Mpwalamubona Petulo kayota mulilo walamulangishisha nekwambeti, “Nenjamwe mwalikuba ne Yesu waku Nasaleti.” ");
INSERT INTO sby_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nsombi nendi walamukana nekwambeti, “Nambi kumwinshiba, nkandi mwinshipo, kayi nkandanyumfwishishinga na ulambanga cani.” Mpwalambeco walapula kaya pacishinga. ");
INSERT INTO sby_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kayi musebenshi mutukashi usa mpwalamubona kayi, walatatika kubambila abo mbwalikuba nabo pepi kwambeti, “Muntuyu walikwenda ne Yesu.” ");
INSERT INTO sby_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kayi apa walamukana. Mpopalapita kacindi pang'ana abo balikuba bemana pepi nendi Petulo balatatika kumwipusha eti, “Cakubinga obe njobe umo wa endibo nenjobe omu Galileya.” ");
INSERT INTO sby_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nsombi nendi walatatika kulishinganya, ne kulumbileti, “Ame nkandimwishi muntuyu ngomulambanga sobwe.” Ne Kombwe walalila. ");
INSERT INTO sby_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Popelapo kayi Kombwe walalila katubili, Petulo walanuka ncalamwambila Yesu “Cakubinga ndakwabilinga Petulo obe, kombwe katanalila tunkanda tubili mashiku alelo obe nunkane tunkanda tutatu.” Neco,walatatika kulila cakutamwena. ");
INSERT INTO sby_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mpobwalaca mumene beshimilumbo bamakulene, ne bamakulene ne beshikwiyisha milawo ya Mose ne Nkuta inene yaba Yuda bonse balabungana mwabwangu bwangu, balamusunga Yesu ne kuya nendi kuli Pilato. ");
INSERT INTO sby_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato walepusha “Sena njobe Mwami waba Bayuda?” Yesu walakumbuleti, “Ee, encomulamba” ");
INSERT INTO sby_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Nomba beshimilumbo bamakulene balamubepesha bintu bingi. ");
INSERT INTO sby_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kayi Pilato walepusha Yesu, “Sena paliya ncowela kukumbulapo? Bona kufula milandu njobalakubeshenga” ");
INSERT INTO sby_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nomba Yesu uliya kumukumbulapo, neco Pilato walakankamana. ");
INSERT INTO sby_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Cindi conse pa kusekelela Pasika, Pilato walikukute cinga ca kupulisha mujele kaili umo uyo bantu ngobalamusenge. ");
INSERT INTO sby_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Pacindici kwalikuba muntu walikukwiweti Balaba walasungwa mujele pamo ne nabambi balashina muntu pakulwanisha mfulumende. ");
INSERT INTO sby_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Neco likoto lya bantu lyalesa kuli Pilato ne kumusenga kwambeti ainsepo cimo kwelana ne cinga ncakute kwinsa. ");
INSERT INTO sby_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato walabakumbuleti, “Mulayandanga ndimusungulwile Mwami wa Bayuda?” ");
INSERT INTO sby_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pakwinga Pilato walaboneshesha kwambeti nipacebo caminyono yabo ecalapesheti beshimilumbo bamakulene bamulete Yesu kulyendiye. ");
INSERT INTO sby_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Nomba beshimilumbo bamakulene balayungaula bantu kwambeti basenge Pilato abasungulwile Balaba. ");
INSERT INTO sby_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nendi Pilato kayi walabepusheti, “Inga ndimwinseconi uyu ngomulambangeti eMwami wa Bayuda?” ");
INSERT INTO sby_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Balo balabilikisheti “Apopwe!” ");
INSERT INTO sby_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Nomba kayi Pilato walapitilisha kubepusheti, “Inga nipacebo cini? Inga lenshi mulandu cini,” Nomba nabo empobalolobesheti, “Apopwe?” ");
INSERT INTO sby_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato pakuyanda kubakondwelesha, walabasungulwila Balaba, ne kwambeti Yesu bamukwapule, kayi bamutwale kuya kumupopa. ");
INSERT INTO sby_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Bashilikali balamumanta Yesu kuya nendi mukati mulubuwa lwa ng'anda ya mwendeleshi, ne kubunganya bashilikali bonse. ");
INSERT INTO sby_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Balamufwalika Yesu mwinjila ufubeluka, balapomba cishoti cabwami ca myunga ne kumufwalika. ");
INSERT INTO sby_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Balatatika kumupa mitende mwalisongwe kabambeti, “Mwikale ne buyumi butali amwe Mwami wa Bayuda!” ");
INSERT INTO sby_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kayi balabamuma pamutwi neluntele nekumusankila mata ne kumusuntamina kabamukambilila. ");
INSERT INTO sby_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mpobalapwisha kumutakausha, balamufulula mwinjila ufubeluka ne kumufwalika mwinjila wakendi, balamutangunya kuya kumupopa. ");
INSERT INTO sby_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kayi mpobalikuya balakumanya Shimoni, waku Kulene walikupita kafuma kumunshi, baishi Alekisandulo ne Lufu, balamukakatisha kwambeti amante lusanda lwa Yesu. ");
INSERT INTO sby_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Balashika nendi pa musena walikukwiweti, Gologota, ekwambeti musena wacifupa ca mutwi. ");
INSERT INTO sby_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Balamupa waini wasankanishiwa ne mule, nomba nendi Yesu walakana kunwa. ");
INSERT INTO sby_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Panyuma pakumupopa, balauma nsolo kwambeti babone umo ne umo ngaumantapo cani pa byakufwala byakendi. ");
INSERT INTO sby_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yesu balamupopa pa lusanda ne cindi ca 9 koloko mumenemene. ");
INSERT INTO sby_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Malembo alambanga sha mulandu ngobalamupa alikubelengweti, “Mwami wa Bayuda.” ");
INSERT INTO sby_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Kayi kopeloko kwalikuba kwapopwa kapondo babili umo kucikasa cakululyo ca Yesu, naumbi kucikasa ca kucipiko ca Yesu. ");
INSERT INTO sby_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Mabala alakwanilishiwa akwambeti,walabelengelwa pamo ne bamilandu. ");
INSERT INTO sby_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bantu balikupita pepi balikwamba maswi akumutukana Yesu kabapukumuna mitwi yabo kabambeti, “Ba! Obe shikuwisha Ng'anda ya Lesa, kayi ne kuyibaka mumasuba atatu, ");
INSERT INTO sby_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","kolipulusha wenka, selukapo palusandapo!” ");
INSERT INTO sby_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nabo beshimilumbo ba makulene, pamo ne beshikwiyisha milawo ya Mose balikumuwela Yesu, nekwamba palwabo beneti, “Walikupulusha bantu bambi,nkela kulipulusha mwine. ");
INSERT INTO sby_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Klistu Mwami wa Baislayeli lino koselukapo pa lusanda, kwambeti afwe tubone kayi tushome” Nabo balikuba bapopwa pamo ne Yesu balikumutukana. ");
INSERT INTO sby_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Cindi mpocalashika muma 12 koloko munshi, mucishico mwalaba mushinshe mpaka cindi ca 3 koloko mansailo. ");
INSERT INTO sby_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Pacindi ca muma 3 koloko Yesu walabilikisha ne liswi lyangofu “Eloi Eloi Lama sabakatani!” Uku ekwambeti, “Lesa wakame, Lesa wakame, mulanshiyi aconi ndenka!” ");
INSERT INTO sby_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Abo balikubapo mpobalanyumfwa ncalikwamba balambeti “Kamubonani! Lakunga Eliya.” ");
INSERT INTO sby_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Popelapo naumbi walamanta cisambo nekufwamba kuya kucisabika mu waini wasasa, ne kucisungilila ku lutele nekumupa kwambeti anwe, kambeti, “Katupembelelani, tubone na Eliya nese amuselushe palusanda.” ");
INSERT INTO sby_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Pacindici Yesu walakuluma cangofu ne kutaya moyo. ");
INSERT INTO sby_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Naco cikwisa ca mu Ng'anda ya Lesa, calikucala pakati pa cipinda Caswepa ne cipinda Caswepeshesha calatwamuka pakati kutatikila pelu mpaka panshi. ");
INSERT INTO sby_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Lino mushilikali mukulene walikuba wemane pepi kali walangana ne Yesu, mpwalabona kwambeti Yesu lataya moyo, walambeti, “Cakubinga muntuyu wanga mwanendi Lesa!” ");
INSERT INTO sby_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Palikuba kayi batukashi balikuba bemana capataliko kabebelela, pakati pabo palikuba Maliya waku magadala ne Maliya banyina Jemusi kanike wakonka Yose, kayi ne Salome, ");
INSERT INTO sby_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","abo ebalikwenda pamo nendiye nekumusebensela cindi ncalikuba ku Galileya.Palikuba kayi batukashi bangi balesa pamo nendiye ku Yelusalemu. ");
INSERT INTO sby_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Cindi camansailo pabusuba bwakulibambila kwambeti lilo bwakaca nibusuba bwa Sabata, ");
INSERT INTO sby_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yosefe waku Alimateya umo wa mu Nkuta inene ya Bayuda weshibikwa ne bonse, uyo neye walikupembelela Bwami bwa Lesa, walayumisha moyo nekuya kusenga mubili wa Yesu kuli Pilato. ");
INSERT INTO sby_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nomba Pilato walakankamana kunyumfweti Yesu lafu kendi.Walakuwa mushilikali mukulene, nekumwipusha kwambeti ashininkishe na nicakubinga Yesu lafu kendi ");
INSERT INTO sby_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mpwalamwambila Pilato kwambeti nicakubinga Yesu lafu kendi, walamusuminisha Yosefe kumanta mubili wa Yesu. ");
INSERT INTO sby_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yosefe walaula cikwisa, mpwalaselusha mubili panshi, walaufungaila mu cikwisa, walamanta mubili nekuya kubika mumanda abeswa mulibwe, ne kukunkulushilapo cilibwe pa cishinga ca manda. ");
INSERT INTO sby_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maliya Magadala, ne Maliya banyina Yose, balikabebelela ne kubonapo mpwalabikwa. ");
INSERT INTO sby_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Mpobwalapita busuba bwa Sabata, Maliya waku Magadala ne Salome ne Maliya banyina Jemusi, balaula mafuta anunkila kwambeti benga bamunanike. ");
INSERT INTO sby_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Mpobwalaca mumenemene pasondo balaya kumanda lisuba kalili lilapulu. ");
INSERT INTO sby_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","pakuya balikwipushaneti, “Inga niyani eshi engatukunkulushileko cilibwe cisa kucifunya pa cishinga ca manda?” ");
INSERT INTO sby_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nomba mpobalalangishisha cena, balabona cilibwe cisa kacili cakunkulushiwa pambali, calikuba cilibwe cinene. ");
INSERT INTO sby_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nomba mpobalengila mumanda, balabona mutuloba kali wekala panshi kucikasa cakululyo, kaliwa wafwala mwinjila utuba, neco balakankamana. ");
INSERT INTO sby_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nomba nendi walabambileti, “Kamutakankamana, ndicinsheti mulalangaulunga Yesu waku Nasaleti usa wanga wapopwa palusanda, Lapunduku kubafu, nkalimo sobwe, kamwisani mulibonene mobene mukati muno mobanga bamubika. ");
INSERT INTO sby_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Lino kamuyani mwambile beshikwiya bakendi ne Petulo kwambeti, nendi latangunu kendi kuya ku Galileya nkweshi mwenga mumubone mbuli ncalamwambila.” ");
INSERT INTO sby_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Balapula mumanda ne kufwamba kufumako ku manda kabatutuma,ne kukankamana, neco paliya muntu ngobalambilako, pakwinga balekatwa ne buyowa. ");
INSERT INTO sby_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Lino Yesu mpwalapunduka pasondo mumenemene, walabonekela nanshi kuli Maliya Magadala usa ngwalapulishamo mishimu yaipa isanu ne ibili. ");
INSERT INTO sby_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mutukashuyu walaya kwambila abo mbwali kuba nabo Yesu, pakwinga balikuba baungumana kabalila. ");
INSERT INTO sby_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nomba mpobalanyumfweti nimuyumi, kayi labonekele kulyendiye, balakana kushoma sobwe. ");
INSERT INTO sby_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Panyuma pakendi walabonekela kubantu babili mucinso cimbi, mpobalikwenda kabaya kumunshi. ");
INSERT INTO sby_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Aba bantu balabwelela kuya kwambila beshikwiya, nomba naboyo baliya kubashoma sobwe. ");
INSERT INTO sby_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Panyuma pakendi kayi walabonekela kuli beshikwiya likumi ne umo pacindi ncobalikulya cakulya patebulu, nomba walabakalalila pacebo ca kubula lushomo, pakwinga myoyo yabo yalikuba yayuma, baliya kushoma mpobalambilwa ne bantu balamubona mpwalapundushiwa kubafu. ");
INSERT INTO sby_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nomba nendi walabambileti, “Kamuyani mukambauke Mulumbe Waina mu cishi conse, ku mishobo yonse ya bantu. ");
INSERT INTO sby_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Abo betibashomenga ne kubatishiwa beti bakapuluke, nomba beti bakabule kushoma beti bakacanike ne mulandu. ");
INSERT INTO sby_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Abo bashoma nibakaleshenga bingashilo ibi, mulina lyakame nibakapulishenga mishimu yaipa, nibakambenga mumilaka yensu. ");
INSERT INTO sby_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Nibakamantenga njoka mumakasa, nambi banwa cintu ciliconse cikute mutondo nteti bakakolewe sobwe, nibakabikenga makasa pa balwashi, nabo nibakabe cena.” ");
INSERT INTO sby_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","(Neco Mwami Yesu mpwalapwisha kwamba nabo, walamantwa kuya kwilu, ne kuya kwikala kucikasa cakululyo ca Lesa. ");
INSERT INTO sby_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Lino balaya kukambauka kulikonse, Mwami walikusebensa nabo, kushininkisheti kukambauka kwabo kwalikuba kwa ncinencine kupitila mu bingashilo byalikwinshika.)");
INSERT INTO sby_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Teofilo Walemekwa, bantu bangi balelekesha kwambeti balembe sha makani abintu ibyo byalenshika pakati petu, ");
INSERT INTO sby_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","balalemba mbuli ncobalambilwa kuli bakamboni balabona bintu ibyo mpobyalatatikila kwinshika. abo ebalikukambauka Mulumbe uwo. ");
INSERT INTO sby_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Pabintu byonse ibi ndalepushisha mwabuya, kufuma pacindi ncobyalatatika kwinshika, neco ndayeye kwambeti ndimulembele mbuli mobyakonkanilana. ");
INSERT INTO sby_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ndenshici kwambeti mwinshibe cakubinga pali byonse mbyobalamwambila. ");
INSERT INTO sby_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Pacindi mwami Helode mpwalikuba muleli wacishi ca Yudeya kwalikuba shimilumbo walikukwiweti Sakaliya, wamukalikoto ka beshimilumbo ka Abija. Mukashendi Sakaliya walikuba Lisabeti wa mumukowa wa Aloni. ");
INSERT INTO sby_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bonse babili balikuba bantu beshikunyumfwila Lesa, kayi bali kukonkela Milawo ne byonse Lesa mbyalikuyandeti babinse. ");
INSERT INTO sby_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nomba nkabalikukutepo mwana, pakwinga Lisabeti walikuba cumba kayi balikuba balacekulu. ");
INSERT INTO sby_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Busuba nabumbi, Sakaliya walikusebensa ncito yakendi yabushimilumbo mu Ng'anda ya Lesa. Pakwinga bwalikuba busuba bwalikoto lyakendi. ");
INSERT INTO sby_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Lino kwelana ne cinga ca beshimilumbo, balasala Sakaliya kwambeti ayenga mu Ng'anda ya Lesa kuya kutenta lubani. ");
INSERT INTO sby_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Pacindi Sakaliya mpwalikutenta lubani, likoto lya bantu balikuba pansa kabapaila. ");
INSERT INTO sby_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Lino mwakutayeyela Sakaliya walabona mungelo wa Mwami, kali wemana kulubasu lwalulyo lwanteme pali kutentelwa lubani. ");
INSERT INTO sby_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakaliya walakankamana nekutina. ");
INSERT INTO sby_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nsombi mungelo uyo walamwambileti, “Kotatina Sakaliya, Lesa lanyumfu kupaila kwakobe, neco mukashobe lisabeti nakakusemene mwana mutuloba ukamutumbe lineti Yohane. ");
INSERT INTO sby_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nakakukondweleshe ne kukusangalasha cikamba, kayi bantu bangi naboyo nibakakondwe pacebo cakusemwa kwakendi. ");
INSERT INTO sby_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Pakwinga mwana uyo nakabe mukulene pamenso a Lesa, kayi nteshi akanwenga waini nambi byeshikukola. Nakakutenga ngofu sha Mushimu Uswepa nkacili mulibunda. ");
INSERT INTO sby_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Uyu muntu nakenshisheti ba Isilayeli bangi bakabwele kuli Mwami Lesa wabo. ");
INSERT INTO sby_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Yohane nakabe kuntangu kwa Mwami, kayi nakabe ne Mushimu nengofu mbuli shali kuba ne mushinshimi Eliya. Nakalete lunyufwano pakati pabana neba meshabo.” “Nakasandule bantu batanyumfwili Lesa kwambeti bakabe ne miyeyo ya bantu balulama. Nakabambe bantu ba Mwami kwambeti babenga balibambila.” ");
INSERT INTO sby_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakaliya walepusha mungelo uyo, “Nomba nganjishibaconi kwambeti ncolambanga nicikenshike? Pakwinga ame ndacekulu neye mukashame lacekulu.” ");
INSERT INTO sby_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mungelo usa walakumbuleti, ame njame Gabiliyeli. Nkute kwimana pamenso a Lesa cindi conse. Nendi elantumu kwambeti nkwambile bintu ibi. ");
INSERT INTO sby_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nomba pakwinga uliya kushoma mulumbe uyu ngondamba weti ukenshike pacindi celela, nube cibulu nteti ucikonshenga kwamba, mpaka ibi bintu bikenshike. ");
INSERT INTO sby_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Pacindi ico bantu balikupembelela Sakaliya balakankamana nkabepushanyeti nicani lamanta cindi citali mu Ng'anda ya Lesa? ");
INSERT INTO sby_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Lino mpwalapula pansa nkalikucikonsha kwamba nabo. Nomba nabo balenshiba kwambeti labono cimboni mboni, popelapo walatatika kwamba ne makasa mbuli cibulu, neco walapitilisha kuba cibulu. ");
INSERT INTO sby_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Mpwalapwa masuba akusebensa mu Ng'anda ya Lesa, Sakaliya walaya kucomwabo. ");
INSERT INTO sby_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Panyuma pakendi Lisabeti walemita, lino nkalikupulapula mu ng'anda kwamyenshi isanu nkambeti, ");
INSERT INTO sby_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Lesa lino lanyumfwili inkumbo pakunyinshileci lafunyu insoni shakame pamenso abantu.” ");
INSERT INTO sby_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mumwenshi wacisanu ne umo kufuma mpwalemita Lisabeti, Lesa walatuma mungelo Gabiliyeli ku munshi naumbi waku Galileya, walikukwiweti Nasaleti. ");
INSERT INTO sby_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Walaya ku mulindu walikukwiweti Maliya. Maliya walikuba wamamikilwa kumutuloba lina lyakendi ni Yosefe wa mumukowa wa Dafeti. ");
INSERT INTO sby_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mungelo mpwalashika kuli Maliya walambeti, mitende obe walelekwa ne Lesa. Lesa uli ne njobe. ");
INSERT INTO sby_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maliya mpwalanyumfwa maswi a mungelo walatilimuka walipusha mumoyo wakendi eti, “Nikupa mitende kwamushobo cini uku?” ");
INSERT INTO sby_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Popelapo mungelo walamwambileti, “Kotatina, Maliya; Pakwinga Lesa lakunyumfwili inkumbo. ");
INSERT INTO sby_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Bona nukemite ne kusema mwana mutuloba ukamutumbeti Yesu. ");
INSERT INTO sby_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","“Nakabe mukulene kayi nakakwiweti mwanendi Lesa wakwilu wapitapo. Mwami Lesa nakamupe cipuna ca bwami ca Dafeti. ");
INSERT INTO sby_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nakabe Mwami wa ba Islaeli kucindi conse ne bwendeleshi bwakendi nteshi bukapwepo!” ");
INSERT INTO sby_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Lino, Maliya walamwipusha Mungelo eti, “Nomba ici ngacinshika econi ame nkana nkumanapo ne mutuloba?” ");
INSERT INTO sby_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mungelo walakumbuleti, Mushimu Uswepa nukese palinjobe nengofu sha Lesa wapita byonse nishikakufwekelele. Neco mwana eshi akasemwe nakakwiweti waswepa, Mwanendi Lesa. ");
INSERT INTO sby_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","“Bona mukwenu Lisabeti usa walikwambweti nkaseme, lino lapembelenga kuya kuba ne mwana mutuloba mubucembele bwakendi. Pakwinga ukute myenshi isanu ne umo kakute libunda. ");
INSERT INTO sby_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Pakwinga paliya ceshi cikamwalile Lesa.” ");
INSERT INTO sby_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maliya walakumbuleti, “Kacinshika mbuli momulambili, pakwinga ame ndemusha wa Mwami.” Lino mungelo usa walamushiya. ");
INSERT INTO sby_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mpopalapita masuba ang'ana, Maliya walanyamuka bulwendo bwakufwambana kuya kumusena wa milundu, kumunshi wa Yudeya. ");
INSERT INTO sby_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Walengila mung'anda ya Sakaliya nekumupa mutende Lisabeti. ");
INSERT INTO sby_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Pacindi Lisabeti mpwalanyumfwa mutende wa Maliya, mwana walatatika kunyanyala mwakukondwa mulibunda mwakendi. Lisabeti walesushiwa ne ngofu sha Mushimu Uswepa, ");
INSERT INTO sby_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","kayi walolobesha ne kwambeti, “Ukute colwe pakati pa batukashi bonse, kayi mwanobe weshi akasemwe walelekwa. ");
INSERT INTO sby_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Anu njame bani kwambeti mfwakashilwe ne banyina Mwami wakame? ");
INSERT INTO sby_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Pakwinga mpondalanyumfowa mutende wenu, mwana walatatika kunyanyala mwakukondwa mulibunda mwakame. ");
INSERT INTO sby_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ukute colwe pakwinga walashoma kwambeti makani Lesa ayo ngowalambilwa nakubinga nakenshike.” ");
INSERT INTO sby_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Popelapo Maliya walalumbaisha nekwambeti, “Ndalumbu Mwami mumoyo mwakame, ");
INSERT INTO sby_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Kayi mushimu wakame wakondwa muli Lesa Mupulushi wakame. ");
INSERT INTO sby_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Pakwinga labono kulicepesha kwakame ndemusha wakendi kufuma lelo, bantu bonse pacishi ca panshi nibakankuweti walelekwa. ");
INSERT INTO sby_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Pakwinga nendi Lesa wangofu shonse lanjinshili bintu binene, lina lyakendi lyaswepa. ");
INSERT INTO sby_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kayi inkumbo shakendi shili pali bonse bantu abo bakute kumulemeka kufuma kumusemano kushika kumusemano naumbi. ");
INSERT INTO sby_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Likasa lyakendi lilenshi bintu binene byangofu byeshi kukankamanisha, lamwaya bantu bakute miyeyo ya kulisumpula. ");
INSERT INTO sby_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Lafunyu Bami bangofu shinene pabipuna byabo, nekusumpula abo beshi kulicepesha. ");
INSERT INTO sby_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Lapa bantu bakute nsala bintu bingi kwambeti bekute, Lababweshe babile kwakubula kubapapo kantu kalikonse. ");
INSERT INTO sby_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Lanyamfwa Islaeli musebenshi wakendi kayi uliya kuluba kumwinshila inkumbo ");
INSERT INTO sby_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","mbuli ncalalaya bamashali betu bakulukulu, Abulahamu ne bashikulu bakendi mpaka muyayaya.” ");
INSERT INTO sby_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maliya walekala ne Lisabeti myenshi yanda kukwana itatu, panyuma pakendi walabwelela kucomwabo. ");
INSERT INTO sby_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Lino cindi cakwambeti Lisabeti atumbuke calakwana, walasema mwana mutuloba. ");
INSERT INTO sby_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Beshikamukowa ne banendi mpobalanyufwa mbuli Mwami ncalamubela inkumbo Lisabeti balakondwa pamo bonse ne ndiye. ");
INSERT INTO sby_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mwana usa mpwalakwanisha nsondo ne busuba bumo balesa kwambeti bamwelule, kayi bamutumbe lina lyabaishi ba Sakaliya, ");
INSERT INTO sby_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","nsombi banyina balakana kwambeti, “Welela kukwiweti Yohane.” ");
INSERT INTO sby_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Balo bantu balamukumbuleti, “Nomba kuliyawa ukute lina lyamushoboyo kubeshi kamukowa.” ");
INSERT INTO sby_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Lino balambila baishi ne makasa, ne kubepusheti, “Mulandanga tumutumbe lina cini?” ");
INSERT INTO sby_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Popelapo Sakaliya walasebensesha makasa pakusenga cakulembelapo, ne kulembeti, “Lina lyakendi ni Yohane.” Bantu bonse balakankamana. ");
INSERT INTO sby_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Mpwalapwishowa kulemba Sakaliya walatatika kwamba, nekutatika kulumbaisha Lesa. ");
INSERT INTO sby_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Bantu bonse balatina abo balikuba bekala pepi nendiye. Neco lulumbi ulo lwalamwaika mucishi conse ca tulundu twa mu Yudeya. ");
INSERT INTO sby_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Bonse abo balanyufwa mulumbe uyo bali kabayeya mumyoyo yabo kayi ne kulipusheti, “Uyu mwana nakabe wamushobo cini?” Pakwinga cilabonekelenga limo kwambeti ngofu sha Lesa shili pali endiye. ");
INSERT INTO sby_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Lino Sakaliya baishi Yohane, walesushiwa ne ngofu sha Mushimu Uswepa nekutatika kwambeti, ");
INSERT INTO sby_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Alumbaishiwe Mwami Lesa wa ba Islaeli, Pakwinga Lesa lanyamfwa bantu bakendi ne kubapulusha. ");
INSERT INTO sby_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Latupa mupulushi ukute ngofu, walafuma mulibunda lya Dafeti musebenshi wa Lesa. ");
INSERT INTO sby_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ibi walabyambila limo kupitila mubashinshimi bakendi baswepa bakeendi, ");
INSERT INTO sby_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Kwambeti nakatupulushe kufuma mumakasa abalwani betu, ne kuli abo bonse batupata. ");
INSERT INTO sby_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Walambeti, nakanyumfwile inkumbo bamashali betu bakeendi, kayi nteshi akalubeko cipangano cakendi caswepa. ");
INSERT INTO sby_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ncalalumbila kumushali wetu Abulahamu ne kumushomesheti, ");
INSERT INTO sby_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","nakatupulushe mumakasa abalwani betu, kwambeti tukamusebensele mwakubula buyowa, ");
INSERT INTO sby_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Kayi tube baswepa nekuba balulama pamenso akendi, masuba onse abuyumi bwetu. ");
INSERT INTO sby_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Lino mwana obe, nukakwiweti mushinshimi wa Lesa wa wangofu shonse, Pakwinga obe nukabe pantangu pa Mwami, akumubambila nshila. ");
INSERT INTO sby_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nukenshibishe bantu bakendi kwambeti, nibakapulushiwe kayi nekulekelelwa bwipishi bwabo. ");
INSERT INTO sby_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Mwami Lesa wetu ukute nkumbo nakatupe mumuni wa kwilu ulyeti kutubuluka kwa kumaca. ");
INSERT INTO sby_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","nukabe mumuni weti ukamunikile bantu bonse bekala mu mushinshe wa lufu, nekututangunina mulumuno.” ");
INSERT INTO sby_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Usa mwana Yohani walakula nekushimpa mumushimu. Walekala mucinyika kushikila busuba mpwalabonekela patuba kubantu mu Isilaeli. ");
INSERT INTO sby_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Masuba ayo Agasita, mwami waku Loma walabika mulawo wakwambeti bantu bonse bali mubulelo bwa Loma balembwe. ");
INSERT INTO sby_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Uku kwalikuba kulembesha kwakuyamba kwalenshika cindi Kwilinyasi mpwalikuba mwendeleshi wa cishi ca Siliya. ");
INSERT INTO sby_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Lino bonse bantu balaya akulembesha umo ne umo kumunshi kucomwabo. ");
INSERT INTO sby_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yosefe neye walanyamuka kufuma ku Nasaleti munshi walikuba mucimpansha ca Galileya kuya kumunshi wa Dafeti, uko kwali kukwiweti Betelehemu, mucishi ca Yudeya, pakwinga walikuba wamulibunda lya Dafeti. ");
INSERT INTO sby_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Walaya pamo ne Maliya uyo ngwalikuba wamamikila, kwambeti naboyo baye balembwe. Cindi ico Maliya walikuba wemita. ");
INSERT INTO sby_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kabacili kopeloko masuba akwambeti Maliya apulukemo alakwana, ");
INSERT INTO sby_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","walasema mwana wakwiya mutuloba. Walamupetelesha mubikwisa ne kumoneka mucibaya mwali kulyela ng'ombe, pakwinga nkakwalikuba musena mu ng'anda ya bensu. ");
INSERT INTO sby_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kucishi kopeloko kwalikuba bembeshi balikwembela mbelele shabo mashiku. ");
INSERT INTO sby_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mwakutayeyela, mungelo wa Mwami walabonekela kuli endibo. Kubala kwa bulemeneno bwa Mwami kwalabamunikila tuu! Lino balatina. ");
INSERT INTO sby_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nomba mungelo walabambileti, “Kamutatina pakwinga ndalete Mulumbe Waina weti ukondweleshe bantu bonse. ");
INSERT INTO sby_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mashiku alelo mumunshi wa mwami Dafeti mulasemwe Mupulushi wenu wananikwa uyo walaiwa, Klistu endiye Mwami. ");
INSERT INTO sby_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Lino cishibisho cakendi nici; Nimuye mucane mwana kateta wafungailwa mubikwisa kaliwona mucibaya mwakulyela ng'ombe.” ");
INSERT INTO sby_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Mwakutayeyela kwalabonekela likoto lya bangelo bangi ba kwilu pamo ne mungelo usa bali kulumbaisha Lesa kabambeti, ");
INSERT INTO sby_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Alumbwe Lesa wa kwilu wapitapo kayi panshi pabe lumuno pakati pa bantu Lesa mbakondwa nabo.” ");
INSERT INTO sby_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Bangelo balabwelela kwilu, lino bembeshi balatatika kwambilaneti, “Katuyani tushikeko ku Betelehemu tuye tubone cilenshiki ico ncalatwambili Mwami.” ");
INSERT INTO sby_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Lino balaya mwakufwambana, nekucana Maliya ne Yosefu boneka mwana mucibaya mwalikulyela ng'ombe. ");
INSERT INTO sby_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mpobalamubona, bembeshi basa balabamba byonse mbyalabambila mungelo usa pamwana walasemwa. ");
INSERT INTO sby_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bonse balanyumfwa makani ayo alambwa ne bembeshi balakankamana. ");
INSERT INTO sby_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maliya walapitilisha kubyanuka bintu byonse ibi kayi walinkabiyeyapo mumoyo wakendi cindi conse. ");
INSERT INTO sby_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bembeshi basa balabwelela, nkabalemeka nekulumbaisha Lesa pabyonse mbyobalanyufwa nekubona. Calenshika ndendende mbuli mwalabambilila Mungelo. ");
INSERT INTO sby_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mwana usa mpwalakwanisha masuba asanu ne atatu balamwelula nekumutumba lineti Yesu. Lina ndyalamba mungelo, Yesu nkatana aba mulibunda lyabanyina. ");
INSERT INTO sby_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mpocalashika cindi cakwambeti, Yosefe ne maliya bense mwambo wakuswepesha pakukonka Milawo Lesa njalapa Mose, mwanoyo balaya nendi ku Yelusalemu kwambeti bamubenge kuli Mwami. ");
INSERT INTO sby_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Pakwinga calembwa mu Milawo Lesa njalapa Mose kwambeti, “Mwana uliyense mutuloba, wakwiya welela kubengwa kuli Lesa.” ");
INSERT INTO sby_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Balaya akubenga mulumbo wa nkulimba shibili nambi bana ba baciba babili kwelana mbuli calembwa mu Milawo ya Lesa njalapa Mose. ");
INSERT INTO sby_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Lino mu Yelusalemu mwalikuba muntu walikukwiweti Simyoni, walikuba muntu walikutina Lesa. kayi Mushimu Uswepa walikuba pali endiye. Walikupembelela cindi cakwambeti Lesa akapulushe Baislaeli. ");
INSERT INTO sby_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Mushimu Uswepa walamuyubulwila kwambeti nteshi akafwe nkatanabona Klistu mupulushi walaiwa ne Lesa. ");
INSERT INTO sby_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Busuba bumbi Mushimu Uswepa walamwambila simyoni kwambeti ayenga kung'anda ya Lesa. Bamashali ba Yesu balengila mu Ng'anda ya Lesa ne mwana kwambeti bamwinshile mwambo wa Milawo ya Lesa njalapa Mose. ");
INSERT INTO sby_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Popelapo Simyoni walatambula mwana nekumufukatila mumakasa mwakendi ne kulumbaisha Lesa ne maswi akwambeti, ");
INSERT INTO sby_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Mwami, lino ndekeni ame musebenshi wenu, njenga mulumuno, pakwinga mulenshi ncomwalanshomesha. ");
INSERT INTO sby_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Pakwinga menso akame alabono lupulusho lwenu, ");
INSERT INTO sby_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","lupulusho ulo ndomwalabamba, pamenso abantu bonse. ");
INSERT INTO sby_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Uyu ni mumuni walambweti nukamunikile bantu ba mishobo naimbi, nekwambeti pakabe bulemeneno pa bantu benu Ba isilayeli.” ");
INSERT INTO sby_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Baishi ne banyina balakankamana mpobalanyumfwa maswi ngalamba Simyoni pa mwana uyu. ");
INSERT INTO sby_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Lino Simyoni walabaleleka nekwambila Maliya banyina mwana eti, uyu mwana walasalwa ne Lesa, “Kwambeti awishe ne kupundusha bangi pakati pa bantu ba mu Islayeli. Nakabe cishibisho catumwa ne Lesa, ico bantu bangi ncoti bakakane. ");
INSERT INTO sby_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Neco miyeyo ili mumyoyo yabantu bangi, nikabonekele patuba. Nenjobe Maliya mapensho nakakwikate ne kuyasa kumuyo eti cibeshi.” ");
INSERT INTO sby_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kayi kwalikuba mushinshimi mutukashi mukalibingi lina lyakendi ni Ana. Walikuba mwanendi Faniwelo wa mulibunda lya Asha uyo walekala ne baibendi byaka bisanu ne bibili, Lino neye walikuba mucembele. ");
INSERT INTO sby_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Pacindi co walikuba ne byaka makumi asanu ne atatu kayi ne byaka bina. Cindi conse walikwikala mu Ng'anda ya Lesa. Walikapaila kuli Lesa mashiku ne munshi kayi ni muntu walikulikanisha kulya. ");
INSERT INTO sby_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nendi mpwalashikako copeleco cindi, walatatika kulumbaisha Lesa, kambila bantu bonse sha mwana uyo ngobalikupembelela cindi Lesa mposhi akapulushe Yelusalemu. ");
INSERT INTO sby_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yosefe ne Maliya mpobalapwisha kwinsa byonse kwelana ne Milawo Lesa njalapa Mose, balabwelela kucomwabo ku Nasaleti mucishi ca Galileya. ");
INSERT INTO sby_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mwana usa walakula nekuba ne ngofu kayi walaba ne mano. Neco Lesa walamuleleka. ");
INSERT INTO sby_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Bashali ba Yesu balikuya lyonse ku Yelusalemu mwaka ne mwaka akusekelela Pasika. ");
INSERT INTO sby_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu mpwalaba ne myaka likumi ne ibili, balaya kopeloko mbuli cinga cabo. ");
INSERT INTO sby_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Mpobalapwisha kusekelela bala bwelela kucomwabo, Yesu walashala ku Yelusalemu, bashali bakendi nkabalenshiba. ");
INSERT INTO sby_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Balo bashali bakendi bali kabayeyeti uli mulikoto lya bantu mbobali kuyanabo munshila, balenda musuma wa busuba bumo. Lino balatatika kumuyandaula kubamakwabo ne kubanabo. ");
INSERT INTO sby_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mpobalacaneti kuliyawa, balabwelela ku Yelusalemu kabaya akumulangola. ");
INSERT INTO sby_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Balamucana mpopalapita masuba atatu mu Ng'anda ya Lesa, nkali ekala pakati pa beshikwiyisha, nkanyumfwila maswi abo kayi nkabepusha mipusho. ");
INSERT INTO sby_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bantu bonse balakankamana mpobalanyufwa mbuli mwalikubakumbulila ne mano. ");
INSERT INTO sby_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Bashali bakendi mpobalamubona balakankamana. Lino banyina balamwipusheti, “Mwana obe, ulatwinshili cani cisa? Bona ame ne baiso tulashupiki kukuyandola.” ");
INSERT INTO sby_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesu walakumbuleti, “Nomba nkamundangwela cani, sena nkamucishi kwambeti ndelela kuba mung'anda ya Bata?” ");
INSERT INTO sby_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Balo baliya kunyufwishisha ncalabakumbula. ");
INSERT INTO sby_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Lino Yesu walanyamuka nekuya nabo kucomwabo ku Nasaleti pakwinga walikunyumfwila banyina. Maliya walasunga bintu ibi byonse mumoyo wakendi. ");
INSERT INTO sby_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu walakula necimo ca mano kayi walaba mwana weshi kukondwelesha Lesa nebantu bonse. ");
INSERT INTO sby_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mu mwaka walikumi ne cisanu Tibelyo, mwami wa ku Loma. Pontiyasi Pilato pacindi ico walikuba emuleli wacishi ca Yudeya. Helodi neye walikuba muleli wa cishi ca Galileya. Filipo mukwabo Helodi, walikendelesha cishi ca Ituliya ne Tilakoniti. Lisaniya walikuba emuleli wa cishi ca Abilini. ");
INSERT INTO sby_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Pa cindico Anasi ne Kayafa balikuba beshimilumbo bamakulene. Pacindi copeleci Lesa walamupa mulumbe Yohane mwanendi Sakaliya mucinyika. ");
INSERT INTO sby_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Popelapo Yohane walaya akukambauka muminshi yonse yalikuba yashunguluka mulonga wa Yolodani, kabambileti, “Sandukani mu myoyo yenu, mubatishiwe, kwambeti Lesa amulekelele bwipishi bwenu.” ");
INSERT INTO sby_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ibi embyalamba mushinshimi Yesaya eti, “Muntu labilikishinga mucinyika lambangeti, ‘Kamubamba nshila ya mwami. Kamululamika nshila yakendi. ");
INSERT INTO sby_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Misena yonse yakunama nikafukilwe, milundu ne bina byonse nibikacepeshewe. Nshila shapetuka petuka nishikalulamikwe. Sha byeshikupuntula nishikaswepe. ");
INSERT INTO sby_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Lino mishobo yonse ya bantu nikabone lupulusho lwa Lesa!’ ” ");
INSERT INTO sby_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Bantu bangi balaya nkwalikuba Yohane kwambeti enga ababatishe. Nomba nendi walabambileti, “Amwe omulyeti njoka, niyani lamucenjeshe kufwamba bukalu bwa Lesa bulesanga? ");
INSERT INTO sby_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kamwinsani milimo yaina yeshikulesha kwambeti mulasanduku myoyo yenu. Kamutambangeti, mwalulama pakwinga Abulahamu. ebameshenu. Ndamwambilinga Lesa ngausandula mabwe aya kuba banabendi Abulahamu. ");
INSERT INTO sby_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nomba lino kembe kakankwa kendi pamiyanda ya bitondo. Neco citondo cili conse citaseme bisepo byaina, nicikatemwe nekuciwala pamulilo.” ");
INSERT INTO sby_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nomba bantu balamwipusha Yohane eti, “Nomba lino twinse aconi?” ");
INSERT INTO sby_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nendi Yohane walambeti, “Uyo ukute byakulya apeko munendi wabula. Neye ukute byakufwala ense copeleco.” ");
INSERT INTO sby_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Naboyo beshimisonko balikuyanda kubatishiwa, balamwipusha Yohane eti, “Shikwiyisha, nomba twinsenga cani?” ");
INSERT INTO sby_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nendi Yohane walabambileti, “Mutasonkeshanga mwelo wapitilila.” ");
INSERT INTO sby_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Naboyo bashilikali balamwipusheti, “Nomba twinsenga cani?” Nendi Yohane walabambileti, “Mutalamunanga muntu cintu cakendi pakumuyosha nambi kumunanika mulandu. Amwe mali ngomulafolonga amukwanine.” ");
INSERT INTO sby_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Pakwinga pacindici bantu bangi balikupembelela kwisa kwa Mupulushi Walaiwa ne Lesa, bantu balatatika kuyeyeti mpani Yohane eMupulushi usa Walaiwa ne Lesa. ");
INSERT INTO sby_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Lino Yohane walabambila bonseti, “Ame ndamubatishinga ne menshi, nsombi lesanga wampita kayi nkandela kucikonsha kuba musha wakendi uyo wela kusungulula ntambo sha nkwabilo shakendi. Uyo nendi naka mubatishenga ne Mushimu Uswepa ne mulilo. ");
INSERT INTO sby_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nendi ukute cakupupulushilako maila mumakasa akendi kwambeti apupulushe nekwalongela mulyanga, Lino nakatente bungu bonse mumulilo utashimiki.” ");
INSERT INTO sby_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yohane walikukambauka Mulumbe Waina nekubacenjesha munshila shapusa pusana. ");
INSERT INTO sby_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nomba Yohane walakalalila mwami Helodi pacebo cakweba Helodyasi, muka mukwabo, ne pacebo ca bintu byaipa nabimbi mbyalikwinsa. ");
INSERT INTO sby_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kusankanya pabwipishi ubu, Helode walamusunga Yohane mujele. ");
INSERT INTO sby_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Busuba nabumbi bantu bonse mpobalabatishiwa, neye Yesu walabatishiwa. Lino pacindi mpwali kupaila kwilu kwalacaluka, ");
INSERT INTO sby_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Kai ne Mushimu Uswepa walikuboneketi nkulimba walaseluka nekwisa kwikala pali endiye. Ne liswi lyalanyumfwika kwilu eti, “Njobe mwaname ngonsuni mumoyo mwakame, pali njobe ndakondwa.” ");
INSERT INTO sby_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu walatatika incito yakendi yakwiyisha nkali ne myaka makumi atatu. Bantu balikumwambeti nimwana wa Yosefe, uyo walikuba mwana wa Eli, ");
INSERT INTO sby_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli mwanendi Matati, Matati mwanendi Levi, Levi mwanendi Meliki, Meliki mwanendi janai, Janai mwanendi Yosefe, ");
INSERT INTO sby_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosefe mwanendi Matayasi, Matayasi mwanendi Amosi, Amosi mwanendi Nahumu, Nahumu mwanendi Esili, Esili mwanendi Nagai, ");
INSERT INTO sby_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai mwanendi Mahati, Mahati mwanendi Matatiyasi, Matatiyasi mwanendi Semeine, Semeine mwanendi Yoseki, Yoseki mwanendi Yoda, ");
INSERT INTO sby_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda Mwanendi Yowanani, Yowanani mwanendi Lesa, Lesa mwanendi Zelubabelo, Zelubabelo mwanendi Seyalatyelo, Seyalatyelo mwanendi Neli, ");
INSERT INTO sby_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neli mwanendi Meluki, Meluki mwanendi Adi, Adi mwanendi Kosamu, Kosamu mwanendi Elimadamu, Elimadamu mwanendi Ele, ");
INSERT INTO sby_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ele mwanendi Yoshiwa, Yoshiwa mwanendi Eliyaza, Eliyaza mwanendi Yolimu, Yolimu mwanendi Matati, Matati mwanendi Levi, ");
INSERT INTO sby_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi mwanendi Simyoni, Simyoni mwanendi Yudasi, Yudasi mwanendi Yosefe, Yosefe, mwanendi Yonamu, Yonamu mwanendi Eliyakimu, ");
INSERT INTO sby_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakimu mwanendi Meliya, Meliya mwanendi Mena, Mena mwanendi Matata, Matata mwanendi Natamu, Natamu mwanendi Dafeti, ");
INSERT INTO sby_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dafeti mwanendi Yese, Yese mwanendi Obedi, Obedi mwanendi Bowasi, Bowasi mwanendi Sala, Sala mwanendi Nasoni, ");
INSERT INTO sby_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasoni mwanendi Aminadabu, Aminadabu mwanendi Adimini, Adimini mwanendi Ani, Ani mwanendi Hesiloni, Hesiloni mwanendi Pelesi, Pelesi mwanendi Yuda, ");
INSERT INTO sby_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda mwanendi Yakobo, Yakobo mwanendi Isaki, Isaki mwanendi Abulahamu, Abulahamu mwanendi Tela, Tela mwanendi Naholi, ");
INSERT INTO sby_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naholi mwanendi Selaki, Selaki mwanendi Leu, Leu mwanendi Pelegi, Pelegi mwanendi Eba, Eba mwanendi Sela, ");
INSERT INTO sby_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela mwanendi Kainani, Kainani mwanendi Alifakisadi, Alifakisadi mwanendi Semu, Semu mwanendi Nowa, Nowa mwanendi Lameki, ");
INSERT INTO sby_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameki mwanendi Metusela, Metusela mwanendi Enoki, Enoki mwanendi Yaledi, Yaledi mwanendi Mahalale, Mahalale mwanendi Kenani, ");
INSERT INTO sby_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenani mwanendi Enosi, Enosi mwanendi Seti, Seti mwanendi Adamu, Adamu mwanendi Lesa. ");
INSERT INTO sby_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu walafumako kumulonga wa Yolodani kaliwesula ne Mushimu Uswepa. Kayi Mushimu Uswepa walamutangunina kuya mucinyika, ");
INSERT INTO sby_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","umo mucinyika walekalamo masuba makumi ana kasunkwa ne Satana, kayi nkalalyapo kantu kalikonse. Lino masubayo mpwalapwa Yesu walanyumfwa nsala. ");
INSERT INTO sby_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Lino Satana walamwambileti, “Na njobe mwanendi Lesa, ambila libwe ili lisanduke shinkwa.” ");
INSERT INTO sby_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu walakumbuleti, “Calembwa mu Maswi a Lesa eti, muntu nkela kuba ne buyumi mubyakulya byonka.” ");
INSERT INTO sby_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kufumapo Satana walamumanta Yesu nekumutwala pa mulundu nekumulesha bwami bonse bwa mu cishi ca panshi mucindi cing'ana. ");
INSERT INTO sby_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Lino Satana walambila Yesu eti, “Ubu bonse bwami ne bulemu bwakendi ngankupa, pakwinga bonse bwalapewa kuli njame. Nkute ngofu shakupa muntu ngonsuni. ");
INSERT INTO sby_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Lino ndakwambilinga na umfukamine ekwambeti, bonse bulelo ubu nibube bwakobe.” ");
INSERT INTO sby_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu walamukumbuleti, “Calembwa mu Maswi a Lesa eti, fukamina Mwami Lesa wakobe enka nekumusebensela!” ");
INSERT INTO sby_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kumapwilisho Satana walamutwala Yesu ku Yelusalemu nekumubika pa Ng'anda ya Lesa. Nekumwambileti, “Na omwanendi Lesa liwale panshi, ");
INSERT INTO sby_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","pakwinga calembwa mu Maswi a Lesa eti, ‘Lesa nakatume bangelo bakendi kwambeti bakutabe,’ ");
INSERT INTO sby_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Nibakakubake mumakasa “Kwambeti utalilinga kucimpanta cakobe pamabwe.” ");
INSERT INTO sby_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nomba Yesu walambeti, “Calembwa mu Maswi a Lesa eti, ‘Utasunka Mwami, Lesa wakobe.’ ” ");
INSERT INTO sby_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nomba Satana mpwalapwisha kumusunka Yesu munshila iliyonse, walamushiya kwambeti akamukonke cindi nacimbi. ");
INSERT INTO sby_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu walabwelela ku Galileya kakute ngofu sha Mushimu Uswepa. Lulumbi lwakendi lwalaya mucishi conseco. ");
INSERT INTO sby_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Walikeyisha mumanda akupaililamo aba Yuda, kayi bantu bonse balamulemeka. ");
INSERT INTO sby_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu walaya ku Nasaleti uko nkwalakulila. Kayi pabusuba bwa Sabata walengila mung'anda yakupaililamo, pakwinga ecalikuba cinga cakendi, walemana kwambeti abelenge Maswi, ");
INSERT INTO sby_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","balamupa libuku lya mushinshimi Yesaya. Lino neye walacalula libuku ilyo nekucana palembweti, ");
INSERT INTO sby_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Mushimu wa Mwami Lesa uli pali njame. Pakwinga lansala kwambeti ndibambile mulumbe waina bapenshi. Lantumu kwambeti ndibambile basungwa eti basungululwe, bampofu babone, bantu bashantililwa balubulwe. ");
INSERT INTO sby_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Kayi lantumu kuya kubambileti, cindi cilashiki ncoti Lesa akapulushe bantu bakendi.” ");
INSERT INTO sby_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu mpwalapwisha walifweka libuku nekupa shimilumbo wa mung'anda yakupaililamo yaba Yuda, nekwikala panshi. Bantu bonse balikuba mung'anda balamulangilisha. ");
INSERT INTO sby_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Lino Yesu walabambileti, “Lelo maswi awa ngomulanyumfu alakwanilishiwa” ");
INSERT INTO sby_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bantu bonse balamulumbaisha kayi balakankamana ne maswi ngalikwamba mwamano, neco bantu balambeti “Sena uyu nte mwanendi Yosefe?” ");
INSERT INTO sby_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Lino Yesu walabambileti, “Cancinencine nimukambengeti, ‘mung'anga, lipulushe wenka.’ Kayi nimukambengeti, ‘Twalanyumfwa ncowalensa ku Kapelenawo,nako kuno lino linshile omwine.’ ");
INSERT INTO sby_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ndamwambilinga cakubinga, mushinshimi nkakute kutambulwa cena ne bantu bakumunshi kucomwabo. ");
INSERT INTO sby_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Lino kamunyufwani, mumasuba a Eliya kwalikuba ba mukalubingi bangi balikuyanda lunyamfwo mu Isilaeli, mpokwalaba cilala kwa myaka itatu ne myenshi isanu ne umo mpokwalaba nsala mucishi conse. ");
INSERT INTO sby_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Eliya uliya kutumwapo kumuntu uliyense palibasa bonse mu Islayeli, nsombi walatumwa ku mukalubingi mutukashi wakumunshi wa Zalefati, mucishi ca Sidoni. ");
INSERT INTO sby_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Palikuba bantu bangi balikukolwa bulwashi bwamankuntu mu Isilaeli mumasuba amushinshimi Elisha. Nsombi Namani enka wa ku Siliya ewalasengulwa.” ");
INSERT INTO sby_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Mpobalanyumfweco, bantu bonse balikuba mung'anda yakupaililamo balakalala. ");
INSERT INTO sby_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Popelapo balanyamuka nekumukwekwanya kumufunya mumushi usa, nekumutwala pa mulundu mpobalikuba bebaka munshi wabo kwambeti bamuwale panshi. ");
INSERT INTO sby_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nomba nendi walapita pakati pa bantu nekuya. ");
INSERT INTO sby_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesu walaya ku Kapelenawo, mumunshi wa mucishi ca Galileya walikayisha bantu pabusuba bwa Sabata. ");
INSERT INTO sby_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Kwiyisha kwakendi, kwalekata myoyo yabantu pakwinga maswi akendi alalesha kwambeti akute ngofu sha bwendeleshi. ");
INSERT INTO sby_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mung'anda yakupailila mwalikuba muntu walikuba wekatwa ne mushimu waipa walolobesha ne liswi lyapelu eti, ");
INSERT INTO sby_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Anu tulamwinshi cani amwe Yesu wa ku Nasaleti? Sena mulesa kutononga? Ndamwinshibi njamwe Waswepa mutumwa wa Lesa!” ");
INSERT INTO sby_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Lino Yesu walakalalila mushimu waipa eti, “Mwena, fuma mu muntuyu!” Neco mushimu waipa walamuwisha panshi pakati pa bantu nekufuma muli endiye cakubula kumulingapo. ");
INSERT INTO sby_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bantu bonse balakankamana nekwipushanyeti, “Anu ni maswi cini aya cakubinga nendi lambilinga mishimu yaipa cangofu nayoyo ilamunyumfwilinga nekufumamo.” ");
INSERT INTO sby_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Neco lulumbi lwakendi lwalanyumfwika mumisena yonse yashunguluka cishi. ");
INSERT INTO sby_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Lino Yesu walafumako ku ng'anda yakupaililamo nekuya ku ng'anda ya Shimoni. Kumakwendi Shimoni batukashi balikuba balwashi cimpwita. Lino bantu balasenga Yesu eti abashilike. ");
INSERT INTO sby_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Neco Yesu walaya kwimana pepi nendiye walakalalila cimpwita, kofuma, cindi copeleco cimpwita calapwa. Kumakwendi abo balapunduka nekutatika kubabambila byakulya. ");
INSERT INTO sby_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Lisuba mpolyalebila abo balikukute banabo balikuba ne malwashi apusana pusana, balabaleta kwalikuba Yesu. Walabekata ne makasa bonse balwashi, popelapo balaba cena. ");
INSERT INTO sby_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nayo mishimu yaipa yalikufuma mubantu bangi kayolobesheti, “Njobe mwanendi Lesa!” Nsombi nendi walaikalalila ne kwikanisha kwamba pakwinga yalikumwishibeti ni wasalwa wa Lesa. ");
INSERT INTO sby_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mpobwalaca Yesu walafuma ku Kapelenawo nekuya kubusena kwalikubula kwikala bantu. Bantu balatatika kumuyandaula, mpobalamucana balelesha kumusenga camakasa abili kwambeti ataya kumbi. ");
INSERT INTO sby_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nsombi nendi walabakumbuleti, “Ndelela kukambauka Mulumbe Waina wa Bwami bwa Lesa kuminshi imbi pakwinga encito njalantuma Lesa.” ");
INSERT INTO sby_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Neco walikukambauka mumanda akupaililamo aku Yudeya onse. ");
INSERT INTO sby_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Busuba nabumbi Yesu walikuba wemana mumbali mwa lwenje lwa Genesaleti. Bantu bangi bali kabanyakana kwambeti banyumfwe Maswi a Lesa. ");
INSERT INTO sby_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Lino Yesu walabona mato abili asungwa mumbali, beshikushina inswi balikuba balafumumo kabasuka tombe twabo. ");
INSERT INTO sby_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu walengila mubwato bumo ubo bwalikuba bwa Shimoni, neye walasengeti abunyakileko pa lwenje. Walekala mubwato nekutatika kwiyisha bantu. ");
INSERT INTO sby_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Mpwalapwisha kwiyisha, walambila Shimoni eti, “Bunyakileni bwato pakati, kwambeti muwale tombe twenu mumenshi mwikate inswi.” ");
INSERT INTO sby_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Shimoni walakumbuleti, “Shikwiyisha, kufuma mashiku bulatucele tuliya kwikatapo inswi, pakwinga mulamba njamwe ningwale tombe.” ");
INSERT INTO sby_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Lino balawala tombe twabo, nekwikata inswi shingi, tombe twabo twalatatika kupasuka. ");
INSERT INTO sby_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Lino balakuwa banabo balikuba mubwato bumbi kwambeti bese babanyafweko kusabula, naboyo balesa, nomba balesusha mato abili nkayanda kwibila. ");
INSERT INTO sby_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Shimoni Petulo mpwalaboneco walasuntama pantangu pa Yesu nekwambeti, “Kamundekelela Mwami Pakwinga ndeshikwinsa byaipa.” ");
INSERT INTO sby_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Shimoni ne banendi balenseco pakwinga balakankamana pa kufula kwa inswi isho nshobalekata. ");
INSERT INTO sby_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Neco Jemusi ne Yohane bana bendi Zebediya kayi nebanendi Shimoni, naboyo balakankamana. Lino Yesu walambila Shimoni eti, “Kotatina pakwinga kufuma lelo nube weshikwikata bantu.” ");
INSERT INTO sby_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Popelapo balatanta mato ayo kuya kutala kwa mulonga, balashiya byonse nekunkokela Yesu. ");
INSERT INTO sby_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu mpwalikuba mumunshi naumbi walakumana ne muntu wali kukolwa bulwashi bwa mankuntu mubili wonse. Mpwalabona Yesu mulwashi uyu walasuntama kuntangu nekumusengeti, “Mwami ndicishi kwambeti mukute ngofu shakusengula nsenguleni.” ");
INSERT INTO sby_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu walatandabula likasa lyakendi, walamwikata ne kwambeti, “Ee ndayandanga, koba cena!” Popelapo mankuntu alapwa. ");
INSERT INTO sby_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kufumapo Yesu walamwambileti, “Konyumfwa, kotambila muntu nambi umo makani awa. Nomba obe ululame wenga kuli beshikwiyisha, uyenga ulileshe kuli beshimilumbo kwambeti ulaba cena. Uye ubenge bupe kwelana ne ncalamba Mose kwambeti bantu bashometi ulaba cena.” ");
INSERT INTO sby_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Necikabeco impuwo ya Yesu yalanyumfwika kubantu bangi. Neco bantu balikwisa kuli endiye kwambeti banyumfwe Maswi akendi kayi nekubasengula malwashi abo. ");
INSERT INTO sby_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Lino nendi Yesu walaya kwa enka akupaila. ");
INSERT INTO sby_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nabumbi busuba Yesu walikeyisha, popelapo palikuba Bafalisi ne beshikwiyisha milawo nabambi. Bantu aba balafuma muminshi yonse ya ku Galileya, ku Yudeya kayi neku Yelusalemu. Ngofu sha Lesa shalikuba muli Yesu kwambeti abasengule. ");
INSERT INTO sby_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kufumapo bantu nabambi balaleta mutuloba walikuba watontola mubili nkabali bamunyamuna pa mpasa. Balelesha kwambeti bamwingishe mu ng'andeti bamoneke pantangu pa Yesu. ");
INSERT INTO sby_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Naboyo balikuyanda kumwingishila pacishinga, lino pakwinga bantu balafula balalilwa kwambeti bamutwale mukati. Neco balatanta nendi pa ciluli ca ng'anda ne kupasula mulyango, balamwingisha ne kumulelesha pampasa yakendi pakati pabantu ne kumushikisha pantangu pa Yesu. ");
INSERT INTO sby_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu mpwalabona kushoma kwakendi, “Walambeti, bwipishi bwakobe bulalekelelwa.” ");
INSERT INTO sby_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Lino beshikwiyisha Milawo kayi ne Bafalisi balatatika kwipushaneti, “Nomba uyu niyani lanyashanga Lesa? Niyani welela kulekelela bwipishi sena nte Lesa enka?” ");
INSERT INTO sby_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Lino Yesu walenshiba ncobalikuyeya mumyoyo yabo neku bepusheti, “Nomba mulayeyelenga cani bintu bya mushoboyo mu myoyo yenu? ");
INSERT INTO sby_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nicipeyo capuba kwambila muntu eti, ‘Bwipishi bwakobe bulalekelelwa,’ Nambi kwambeti, ‘Nyamuka, wende’ ");
INSERT INTO sby_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Lino ndayandanga kumwambileti mwinshibe kwambeti mwana muntu ukute ngofu shakulekelela bwipishi pacishi ca panshi.” Kufumapo walambila usa watontola mubileti, “Ndakwambilinga, nyamuka, manta mpasa yakobe wenga kucomwenu.” ");
INSERT INTO sby_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Popelapo walapunduka bonse kabalanga nemenso abo, walamanta mpasa mpwalikuba wona nekutatika kuya nkalumbaisha Lesa. ");
INSERT INTO sby_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Bantu bonse balakankamana kayi balatina. Lino balatatika kulumbaisha Lesa ne kwambeti, “Ici ncotulabono lelo, nkatutana tucibonapo sobwe.” ");
INSERT INTO sby_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Popelapo Yesu walafuma pansa nekubona weshikusonkesha musonko walikukwiweti Levi, nkali ekala mu ng'anda yamusonko.Yesu walamwambileti, “Nkonkele.” ");
INSERT INTO sby_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Popelapo neye walanyamuka, nekushiya byonse nekumukonkela. ");
INSERT INTO sby_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lino Levi walabamba byakulya bingi kwambeti basekelele ne Yesu mu ng'anda yakendi. Kwalikuba beshikusonkesha misonko bangi ne bantu nabambi kabalya pamo. ");
INSERT INTO sby_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Bafalisi nabambi ne beshikwiyisha milawo balatatika kudandaulila beshikwiya ba Yesu eti, “Nomba nicani mulalyelenga nekunwa pamo ne beshikusonkesha kayi ne bantu babwipishi?” ");
INSERT INTO sby_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Lino Yesu walabakumbuleti, “Bayumi nkabakute kulangaula mu ng'anga sobwe, nsombi balwashi. ");
INSERT INTO sby_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ndiya kwishila balulama nsombi babwipishi kwambeti basanduke mu myoyo yabo.” ");
INSERT INTO sby_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bantu nabambi balepusha Yesu eti, “Beshikwiya ba Yohane mubatishi bali kuba necindi cakulikanisha kulya nekupaila, naboyo beshikwiya ba Bafalisi bangi balikwinsa copeleco, bakobe baliya cindi camushoboyo, balo bakute kulya ne kunwowa.” ");
INSERT INTO sby_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Lino Yesu walabakumuleti, “Sena balikubwinga ingamubakakatisha kutalya nebanabo, shibwinga kacilipo? Sobwe! ");
INSERT INTO sby_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nsombi cindi nicikashike shibwinga mpoti bakamufunyepo pali endibo, Lino ico cindi nibakalikanishe kulya.” ");
INSERT INTO sby_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kufumapo Yesu walabambila cikoshanisho eti, “Kuliya muntu welela kukwamuna cimami cacikwisa caina nekutunga pa cakufwala cakeendi. Nkela kwinseco pakwinga naco ngacononga cikwisa kayi cimami nkacela kwendelana pacakufwala ico sobwe. ");
INSERT INTO sby_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kuliya muntu welela kubika waini walino lino munkomwa yacipaya cakendi. Nalabikimo waini walino lino ukute kupasula nkomwa. Waini wonse ngawitika ne konongeka. ");
INSERT INTO sby_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nomba waini walino lino welela kubikiwa mucinkuli calino lino. ");
INSERT INTO sby_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kuliya muntu welela kuyanda kunwa waini walino lino na lanu waini wakaindi pakwinga mukute kwambeti, ‘Usa wakaindi ewaina.’” ");
INSERT INTO sby_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Busuba nabumbi pa Sabata Yesu ne beshikwiya bakendi balikwenda kabapita mumabala a Maila. Beshikwiya bakendi balatatika kuyapa ngala sha Maila ne kushipikisa mumakasa nkabalya. ");
INSERT INTO sby_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Kufumapo Bafalisi nabambi balepusheti, “Nomba mulenshilinga cani bintu byabula kusuminishiwa pabusuba bwa Sabata?” ");
INSERT INTO sby_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu walakumbuleti, “Sena muliya kubelengapo calensa Dafeti pacindi mpwalanyumfwa nsala ne banendi? ");
INSERT INTO sby_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Walengila mu Ng'anda ya Lesa nekumanta shinkwa waswepa. Walalya nebanendi shinkwa uyo weshikulyewowa ne beshimilumbo bonka kwelana ne milawo yabo.” ");
INSERT INTO sby_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Lino Yesu walabambileti, “Ame nde Mwana Muntu njame ndemwine busuba bwa Sabata.” ");
INSERT INTO sby_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nabumbi busuba pa Sabata, Yesu walengila mung'anda yakupaililamo kuya kwiyisha. Mung'anda umo mwalikuba mutuloba watontola likasa lyalulyo. ");
INSERT INTO sby_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Beshikwiyisha bamilawo ne Bafalisi bali kabalangishisha eti babone, na Yesu ngaumusengula mutuloba usa pabusuba bwa Sabata kwambeti bamucaninepo mulandu. ");
INSERT INTO sby_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nendi walenshiba ncobalikuyeya. Lino walambila mutuloba usa walikuba watontola likaseti, “kwesa kuno wimane kuntangu.” Neye walanyamuka nekuya kwimana kuntangu. ");
INSERT INTO sby_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Lino “Ndamwipushunga, nomba milawo ikute kutusuminisha kwinsa cani pabusuba bwa Sabata? Kwinsa caina ku muntu nambi kumwinshila caipa? Kupulusha buyumi bwa muntu nambi kubononga?” ");
INSERT INTO sby_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Apwishe kwambeco walalangishisha bantu bonse balikuba mu Ng'anda yakupaililamo, nendi walambila mutuloba useti, “Tandabula likasa lyakobe.” Neye walatandabula, lino lyalaba cena. ");
INSERT INTO sby_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nsombi nabo balakalala nekutatika kulifuyafuya cakumwinsa Yesu. ");
INSERT INTO sby_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pacindico Yesu walaya kumulundu kuya kupaila lino bwalaca kapaila. ");
INSERT INTO sby_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Mpobwalaca walakuwa beshikwiya bakendi. Pakati pabo walasala bali kumi nebabili abo mbalakuweti batumwa. ");
INSERT INTO sby_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Maina abo naya; Shimoni uyo ngwalapa lina lya Petulo, ne Ndileya mukwabo, Jemusi ne Yohane, Filipo ne Batolomeyo, ");
INSERT INTO sby_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateyo, Tomasi, ne Jemusi mwanendi Alufeyo Kai ne Shimoni wa mucipani ca bantu balikulwanina lwanguluko mu cishi ca Islayeli, ");
INSERT INTO sby_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ne Yudasi mwanendi Jemusi kayi ne Yuda isikalyoti walesa akumuyaba Yesu kubalwani. ");
INSERT INTO sby_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu mpwalikuselela pamulundu pamo ne beshikwiya, walemana pololoka. Palikuba likoto linene lya beshikwiya bakendi kayi ne likoto linene lya bantu lyalafuma kulubasu lwa ku Yudeya neku Yelusalemu. Bambi balafuma muminshi ya Tulo ne Sidoni, ne mumbali mwa Mulonga. ");
INSERT INTO sby_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Naboyo balesa akukutika Yesu kayi kwambeti abasenguleko malwashi. Lino bonse balikupenshewa ne mishimu yaipa balacanikako kwambeti abasengule. ");
INSERT INTO sby_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Bantu bonse balikabayanda kumukumya, pakwinga ngofu shalikufuma muli endiye, shalikubasengula bonse. ");
INSERT INTO sby_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu walalanga beshikwiya bakendi nekubambileti, “Mwalelekwa amwe mwapenga Pakwinga Bwami bwa Lesa nibwenu! ");
INSERT INTO sby_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mwalelekewa amwe mulanyumfunga nsala cino cindi, pakwinga nimukekute! Mwalelekwa amwe omulalilinga pakwinga nimukakondwe! ");
INSERT INTO sby_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Mwalelekwa omwapatwa ne bantu, kusulwa ne kutukanwa kayi nekumwambeti mwaipa pacebo ca kukonkela ame nde Mwana Muntu! ");
INSERT INTO sby_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Kamukondwani cangofu nekushana kayi ne nekusamwa pakwinga cilambo cenu nicinene kwilu. Pakwinga naboyo bashali babo encobalenshila bashinshimi bakulukulu. ");
INSERT INTO sby_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Nsombi mapensho nakabe pali njamwe mobabile “pakwinga amwe mwatambula kendi bubile bwenu! ");
INSERT INTO sby_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Mapensho nakabe pali njamwe omwekuta cino cindi, “Pakwinga nimukafwe nsala! Mapensho nakabe pali njamwe omwakondwanga cindi cino, pakwinga nimukongumane kayi nimukalile! ");
INSERT INTO sby_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Mapensho nakabe pali njamwe mwense omukute kwambwa kuba baina kubantu bonse pakwinga nebamashali babo encobali kubenshila copeleco bashinshimi bandemi shibili. ");
INSERT INTO sby_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Lino mwense omulakutikinga maswi akame ndamwambilingeti, kamusuna balwani benu kayi nekwinshila byaina abo bamupata. ");
INSERT INTO sby_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mubasengelenga kwambeti Lesa abaleleke abo beshikumushinganya kayi nabo beshi kumupensha kayi mubapaililenga. ");
INSERT INTO sby_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Na muntu lakumu kulicili, Pilibuka akume nekumbi nakoyo. Na muntu lakulamunu cakufwala cakobe capelu umuleke amante ne camukati. ");
INSERT INTO sby_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Na muntu lakusenge cintu umupe. Kai na muntu lamanta cintu cakobe utamwambileti acibweshe. ");
INSERT INTO sby_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ncomulandanga kwambeti bantu bamwinshile, ne njamwe benshileni copeleco. ");
INSERT INTO sby_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nomba na musuni bantu bonka abo bamusuni, lino ngamulumbwecon? Pakwinga naboyo babwipishi basuni abo babasuni. ");
INSERT INTO sby_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Na mulenshinga byaina kulyabo beshi kumwinshila byaina, nomba ngamulumbweconi? Pakwinga naboyo babwipishi encobakute kwinsa. ");
INSERT INTO sby_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Na mukute kukongolesha abo bonka mbomwashometi nibakamubweshele, nomba ngamulumbaishiweconi? Kai naboyo babwipishi bakute kukongoleshana nemwelo wopelowo! ");
INSERT INTO sby_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Amwe mutenseco, kamusunani balwani benu kayi mubenshilenga byaina. Kamutakweletesha kwambeti bakamubweshele. Nimukatambule cipo cenu kwilu. Nimukabe bana ba Lesa wapitapo. Pakwinga neye ukute kwinshila byaina bantu batalumbu ne baipa. ");
INSERT INTO sby_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mbuli bameshenu bakwilu ncobakute inkumbo, nenjamwe mube nenkumbo mbuli bameshenu ba kwilu. ");
INSERT INTO sby_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Mutabetekanga bantu kwambeti nenjamwe Lesa katakamubeteka. Mutapa muntu mulandu kwambeti mutakapewa mulandu ne njamwe, nsombi kamulekelelani, Lesa neye nakamulekelele. ");
INSERT INTO sby_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pani banenu pakolola makasa enu, neye Lesa nakamwinshile copeleco, nakamupeni cipimo caina, cashindailwa kayi kacisempukila panshi. Cipimo ncomukute kupiminako banenu neye Lesa nceti akamupimineko.” ");
INSERT INTO sby_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Lino Yesu walabambila cikoshanyo eti, “Sena muntu mpofu ngautangunina mpofu munendi? Sena bonse babili nkabela kuwila mucisengu?” ");
INSERT INTO sby_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kuliya weshikwiya welela kupita shikwiyisha wakendi, nomba muntu uliyense ukute kubeti shikwiyisha wakendi nalapwishi kwiya. ");
INSERT INTO sby_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Nomba ngobona aconi kapampansha kali mulinso lya munobe nekushiya citondo cili mulinso mwakobe? ");
INSERT INTO sby_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nomba ngawambileconi mukwenu eti, mukwabo, tubone nkufunye kapampansha kali mulinso, na obe mulinso mwakobe omwine kamuli citondo ncolabulunga kubona? Obe mubepeshi tanguna ufunye citondo cili mulinso lya kobe, emposhi ubone cena nekufunya kapampasha kali mulinso lya mukwenu. ");
INSERT INTO sby_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Kuliyawa citondo caina celela kwikata bisepo byaipa, nambi citondo caipa kwikata bisepo byaina. ");
INSERT INTO sby_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Anu ekwambeti citondo cili conse cikute kwinshibika nebisepo byakendi. Kuliyawa muntu ukute kuyapa nkuyu kucitondo ca myunga nambi ku binkupu byabitondo. ");
INSERT INTO sby_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Muntu uli cena ukute kupulisha byaina bili mumoyo mwakendi, neye muntu waipa ukute kupulisha byaipa bili mumoyo mwakendi pakwinga mulomo ukute kwamba byesula mumoyo.” ");
INSERT INTO sby_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Nipacebo cini mukute kwambeti, ‘Mwami, Mwami,’ Kakuli nkamukute kwinsa ibyo mbyonkute kwamba? ");
INSERT INTO sby_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Muntu uliyense lesanga kulinjame nekunyumfwa maswi akame nekwainsa, nindi muleshe ncabele. ");
INSERT INTO sby_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ulyeti muntu walebaka ng'anda, uyo walemba kuya panshi akushika palibwe linene, ne kwibaka ng'anda. Mulonga mpowalesula, meshi alatatika kuma kung'anda iyo. Nomba iliyawa kuwa pakwinga walebaka cena. ");
INSERT INTO sby_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nsombi uyo ukute kunyumfwa maswi akame nekutainsa, ulyeti muntu walebaka ng'anda cakubula kwimba panshi. Menshi mpwalesula, alatatika kuma kung'anda. Lino ng'anda yalawa eti nyang'a nyang'a nekonongeka.” ");
INSERT INTO sby_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu mpwalapwisha kwambila bantu maswi awa, walaya ku Kapelenawo. ");
INSERT INTO sby_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kwalikuba mutangunishi naumbi walikuba mukulene wa bashilikali bakwana mwanda walikuba ne musha ngwali kusuna. Musha uyo wali kakolwa cakwambeti walikuba pepi ne kufwa ");
INSERT INTO sby_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Lino mpwalanyufwa lulumbi lwa Yesu, walatuma bamakulene nabambi ba Bayuda kuya akumusengeti amushilike musebenshi wa mukulene wa bashilikali. ");
INSERT INTO sby_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Abo balatumwa balashika kuli Yesu, balamusenga camakasa abili kwambeti, “Kamubonani uyu muntu mwelela kumunyafwa, ");
INSERT INTO sby_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","pakwinga usuni mushobo wetu kayi walatwibakila ng'anda yakupaililamo.” ");
INSERT INTO sby_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Lino Yesu walaya nabo. Mpwalashika pepi ne ng'anda, mukulene wa bashilikali walatuma banendi kuli Yesu kuya kumwambileti, “Mwami, mutalishupa, pakwinga ame nkandelela kwambeti amwe mwingile mung'anda yakame. ");
INSERT INTO sby_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Weco ndiya kulibikapo kuba walulama kwisa kuli njamwe. Nomba mwambowa maswi musha wakame nabe cena. ");
INSERT INTO sby_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Pakwinga nenjame nkute kukonkela milawo yabamakulene pancinto kayi nkute bashilikali mbonkute kutangunina. Na ndamwambili mushilikali eti, koya, neye ukute kuya. Na ndamwambili mushilikali eti, Kwesa, neye ukute kwisa, Na ndamwambili musha wakame eti, insa ici, neye ukute kwinsa.” ");
INSERT INTO sby_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu mpwalanyumfweco, walakankamana. Lino walalanga kubantu bangi abo balikumukonkela ne kwambeti, “Cakubinga ndiya kubonapo lushomo lwamushoboyu pakati paba Isilaeli sobwe!” ");
INSERT INTO sby_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Balatumwa basa balabwelela kung'anda, nekuya akucana musha uyo laba cena. ");
INSERT INTO sby_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kufumapo Yesu walaya mumunshi umbi ukute kukwiweti Naini. Beshikwiya bakendi nelikoto lya bantu balaya nendi. ");
INSERT INTO sby_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yesu mpwalashika pepi ne munshi, walakumanya bantu kabali banyamuna citumbi, ca mutuloba wafwa walikuba emwana enka kuli banyina bamuka lubingi. Bantu bangi ba mumunshi balikuba pamo ne mukalubingi. ");
INSERT INTO sby_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Yesu mpwalabona mukalubingi uyo walamunyumfwila inkumbo ne kumwambileti, “Kocileka kulila.” ");
INSERT INTO sby_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yesu walashika kuntangu ne kwikata citumbi ico, Lino balikuba bamanta citumbi ico balemana. Kayi kufumapo walambeti, “Obe mwana mutuloba ndakwambilingeti, punduka!” ");
INSERT INTO sby_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mwana mutuloboyo walikuba wafwa walapunduka nekwikala, walatatika kwamba. Lino Yesu walamubwesha kuli banyina. ");
INSERT INTO sby_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nomba bantu bonse balatina, popelapo balalumbaisha Lesa kabambeti, “Mushinshimi mukulene labonekele pakati petu, kayi Lesa wesa akupulusha bantu bakendi.” ");
INSERT INTO sby_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kufumapo lulumbi lwa Yesu yalamwaika mucishi conse ca Yudeya kayi ne bishi byonse byalikuba byashunguluka. ");
INSERT INTO sby_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Beshikwiya ba Yohane balamwambila byonse. Lino Yohane walakuwa babili pa beshikwiya bakendi, ");
INSERT INTO sby_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ne kubatuma kuli Mwami Yesu kuya kwipusheti, “Sena njamwe ngwalamba Yohane eti lesanga nambi tulangilile naumbi?” ");
INSERT INTO sby_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Balatumwa abo mpobalashika kuli Yesu, balamwambileti, “Yohane mubatishi latutumu kwambeti twipushe na njamwe uyo lesanga nambi tulangililenga naumbi?” ");
INSERT INTO sby_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Pacindico Yesu walikashilika malwashi abantu bangi apusana pusana, bamapensho ne kufunya mishimu yaipa kayi walasengula bampofu bangi. ");
INSERT INTO sby_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Lino Yesu walakumbula beshikwiya ba Yohane eti, “Kamuyani mumwambile Yohane byonse mbyomulabono ne kunyufwa, bampofu balabononga, balema myendo balendenga, beshimankuntu balabanga cena, bashinka matwi balanyufunga, bafu balapundukunga kayi bapenga balanyumfunga Mulumbe Waina. ");
INSERT INTO sby_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Walelekwa muntu uyo labulunga kutonshanya pali njame.” ");
INSERT INTO sby_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Lino beshikwiya bakendi Yohane mpobalaya, Yesu walatatika kwambila bantu bangi balikubapo sha makani a Yohane mubatishi eti, “Mpomwalaya akubona Yohane mucinyika mwalikuyeyeti ulyeti cani? Sena mwalikuyeyeti Yohane uliya ngofu eti litete likute kutenkanowa ne mpepo? ");
INSERT INTO sby_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nomba mwalikuyeyeti Yohane ulyeti cani? Sena nimuntu walikuba wafwala byakufwala byaina? Sobwe bantu beshi kufwala byaina, bakute kusuna malyalya nekwikala mumanda abami. ");
INSERT INTO sby_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kamung'ambila, nicani ncomwalaya akubona? Sena mwalikuyeyeti Yohane nimushinshimi? Ee, ndamwambilinga cakubinga kwambeti mwalabona wapita mushinshimi. ");
INSERT INTO sby_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Pakwinga Yohane ewuyo walambwa mumabala a Lesa, Lesa walambeti, “Ninkatume mutumwa wakame kuntangu kwakobe kwambeti akakubambile nshila.” ");
INSERT INTO sby_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Ndamwambilinga kufuma keendi kuliyawa kubapo muntu wapita Yohane, nsombi usa mung'ana mu Bwami bwa Lesa emukulene kupita endiye.” ");
INSERT INTO sby_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Bantu bonse ne beshikusonkesha misonko balanyumfwa kukambauka kwa Yohane, mpobalabatishiwa balasumina kwambeti Lesa walulama. ");
INSERT INTO sby_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nsombi Bafalisi ne beshikwiyisha Milawo pakukana kubatishiwa ne Yohane, balakana ncalikuyanda kubenshila Lesa. ");
INSERT INTO sby_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu walapitilisha kwambeti, “Anu bantu ba cino cindi ngandi bakoshanisha ne cani? Anu balyeti cani?” ");
INSERT INTO sby_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Balyeti batwanike bekala pabusena bwakulishilapo kabolobeshanyeti, “Twalamulilishila ngoma, amwe muliya kushana! ‘Twalamwimbila inyimbo sha malila amwe muliya kulila!’ ");
INSERT INTO sby_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Pakwinga Yohane mubatishi walesa nkalikanisha kulya kayi nkali kunwapo waini, nomba amwe mwalambeti, ‘Ukute mushimu waipa.’ ");
INSERT INTO sby_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Lino Mwana Muntu mpwalesa walatatika kulya ne kunwa, amwe mwalambeti, kamubonani ni weshikulyowa nekukolwa, kayi banendi ni beshimisonko kayi ne babwipishi. ");
INSERT INTO sby_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nsombi mano a Lesa akute kubonekela kuba ancine ncine kuli bonse bakute kwatambula.” ");
INSERT INTO sby_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mufalisi naumbi walakuwa Yesu eti ayenga akulya nendiye. Lino Yesu walaya akwingila mung'anda nekwikala pakulyela. ");
INSERT INTO sby_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mu munshi uwu mwalikuba mutukashi wabwikalo bwaipa. Mpwalanyumfweti Yesu lalinga mung'anda ya Mufalisi uyo, walamanta kankuli kesula mafuta anunkila cena. ");
INSERT INTO sby_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Walashika nekusuntama kunyuma kwa Yesu, pepi ne myendo kalila. Walatontosha myendo bya Yesu ne misoshi yakendi ne kutatika kwipukuta ne mishishi yakendi, nekumyanguta bimpanta bya Yessu ne kutatika kumunanika mafuta ayo. ");
INSERT INTO sby_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Lino Mufalisi usa walakuwa Yesu mpwalaboneco, walatatika kuyeyeti, “Muntu uyu nabanga mushinshimi wancincine nalenshibi mbuli ncabele mutukashi uyu lamwikatanga pakwinga nkamwisheti nimwipishi.” ");
INSERT INTO sby_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Lino Yesu walamwambileti, “Shimoni nkute byakukwambila.” Shimoni walakumbuleti, “Beshikwiyisha kamwambani” ");
INSERT INTO sby_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu walambeti, “Palikuba bantu babili balabweleka mali ku muntu. Umo walabweleka myanda isanu ya mali, naumbi mali makumi asanu. ");
INSERT INTO sby_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Mpocalashika cindi ca kubwesha, bonse babili balalilwa kubwesha nkongole, lino walabalekelela. Nomba pabantu babili basa, nupeyo shikubwelekesha mali ngweshakasune cikamba?” ");
INSERT INTO sby_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Shimoni walakumbuleti, “Ame ndayeyengeti uyo walabweleka mali angi,” Yesu walamwambileti, “Ulakumbulu cena.” ");
INSERT INTO sby_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Lino walalanga kumuntukashi usa ne kumwambila Shimoni eti, “Sena ulabono mutukashi uyu? Mpondashiki mung'anda yakobe uliyawa kumpapo menshi akusamba kumyendo. Nsombi nendi lasambishi myendo yakame nemishoshi yakendi nekwipukuta ne mishishi yakendi. ");
INSERT INTO sby_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Obe uliyawa kumyanguta pakumpa mutende, nsombi nendi kufuma mpondeshili mung'anda liya kucilekapo kumyanguta myendo yakame. ");
INSERT INTO sby_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Bona mondeshili uliyawa kunanikapo mafuta mumutwi, nsombi uyu lananiki mafuta anunkila cena kubimpanta. ");
INSERT INTO sby_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ndakwambilinga cancine ncine, kuyandishisha kunene nkwalandeshe, cilaleshengeti bwipishi bwakendi bwingi bulalekelelwa. Nomba muntu lalekelelwa bwipishi bung'ana ukute kusuna pang'ana.” ");
INSERT INTO sby_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kufumapo Yesu walamwambila mutukashi uyo eti, “Bwipishi bwakobe bulalekelelwa.” ");
INSERT INTO sby_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Lino abo bali kabalya pamo ne Yesu balatatika kwipushanyeti, “Anu niyani muntu uyu weshi kulekelela ne bwipishi?” ");
INSERT INTO sby_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Lino Yesu walambila mutukashi uyo eti, “Lushomo lwakobe lulakupulushu, koya mulumuno.” ");
INSERT INTO sby_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kufumapo Yesu walendana muminshi, kaya kukambauka Mulumbe Waina wa Bwami bwa Lesa, walikuba ne beshikwiya bali likumi ne babili. ");
INSERT INTO sby_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ne batukashi nabamb balafunyiwa mishimu yaipa ne malwashi, Maliya waku Magadala uyo walikukute mishimu yaipa isanu ne ibili ");
INSERT INTO sby_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yowana mukashi wa Kuza uyo walikuba kapitawo wa Helode, Susana, kayi ne nabambi bangi balikunyamfwilisha Yesu ne beshikwiya bakendi kusebensesha mali abo. ");
INSERT INTO sby_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Bantu bangi balabungana kwalikuba Yesu kufuma muminshi. Lino nendi walabapa mukoshanyo eti, ");
INSERT INTO sby_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Kwalikuba muntu umbi walaya akumwaya imbuto. Lino mpwalikumwaya, shimbi imbuto shalalakila munshila shalalyataulwa, bikeni byalashilya. ");
INSERT INTO sby_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Shimbi mbuto shalalakila pabulongo bwamabwe. Mposhalamena, misonga yalatatika kuyuma pakwinga kwalabula katonto mubulongo, ");
INSERT INTO sby_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Shimbi imbuto shalalakila patufukusa twa myunga, lino tufukusa pakukula twalatatika kushantilila. ");
INSERT INTO sby_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Nomba shimbi imbuto shalalakila pabulongo bwaina. Shalakula ne kwikata myanda myanda.” Lino Yesu walamba ne liswi lyapelu kwambeti, “uyo ukute matwi, anyumfwe!” ");
INSERT INTO sby_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Beshikwiya bakendi balamwipusha pabupandulwishi bwa mukoshanyo uwu. ");
INSERT INTO sby_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yesu walakumbuleti, “Amwe mwalapewa kwinshiba bintu byasolama bya Bwami bwa Lesa. Nsombi bambi bakute kunyumfwa bambilwa mumikoshanyo ekwambeti, ‘balangishishe, nomba babule kubona’ Kayi ‘Bakutike, nsombi batanyumfwishisha.’” ");
INSERT INTO sby_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Kupandulula kwa mukoshanyo wa mbuto ni uku, imbuto ni Maswi a Lesa. ");
INSERT INTO sby_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Isho imbuto shalalakila munshila shakoshana ne bantu beshi kunyumfwa Maswi a Lesa, nomba pacindi cing'ana, Satana ukute kwafunya mumyoyo yabo kwambeti babule kushoma ne kupuluka. ");
INSERT INTO sby_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Isho imbuto shalalakila pabulongo bwa mabwe shakoshana ne bantu abo balanyumfunga Maswi a Lesa ne kwatambula cakusangalala sombi pakwinga baliya miyanda yashimpa bakute kushoma kwa kacindi kang'ana neco na balasunkwa bakute kuwa. ");
INSERT INTO sby_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Isho imbuto shalalakila pamyunga shakoshana ne bantu beshi kunyumfwa Maswi a Lesa, nomba miyeyo yakuyanda bubile ne byeshikukondwelesha bikute kubakoma, neco nkabekata bisepo byakoma, ");
INSERT INTO sby_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nsombi isho shalalakila mubulongo bwaina, shakosna ne bantu beshi kunyumfwa Maswi a Lesa, ne kwaikata ne kushoma mumyoyo yabo yaina, neco bakute kulimbikila mpaka kwikata bisepo. ");
INSERT INTO sby_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Kuliya muntu welela kumunika lampi ne kulifwekelela ne nongo nambi kubika mwinshi lyatebulu. Nsombi ukute ubika pelu kwambeti limunikile abo beti bengile mung'anda.” ");
INSERT INTO sby_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Pakwinga kuliya cintu casolama ceti cikabule kuyubulululwa patuba, kayi cintu ciliconse casolekwa ni cikabonekele patuba. ");
INSERT INTO sby_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Neco kamucenjelani mbuli ncomukute kunyufwa Maswi a Lesa. Pakwinga uyo ukute kendi nakabikilwepo, nsombi uyo wabula kantu nibakamulamune konse nkakute.” ");
INSERT INTO sby_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Lino banyina Yesu ne bamakwabo balashika nkwalikuba, lino baliya kucikonsha kushika pepi nendiye pacebo cakwambeti bantu balikuba bangi. ");
INSERT INTO sby_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Lino muntu naumbi walambila Yesu eti, “Bamanyenu ne bakwenu bemana pansa, balandanga kumubona.” ");
INSERT INTO sby_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Nendi Yesu walabambileti, “Bama ne bakwetu niyabo beshi kunyumfwa Maswi a Lesa nekwinsa ncalambanga.” ");
INSERT INTO sby_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Busuba nabumbi Yesu ne beshikwiya bakendi balengila mubwato, Yesu walambeti, “Katutampukilani kutala kwa lwenje kusa.” Popelapo balanyamuka. ");
INSERT INTO sby_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Lino bwato mpobwalikuya, Yesu walona. Kwalesa cilukupwe cinene pamenshi. Bwato bwalatatika kwisula ne menshi kabuyanda pepi nekwibila. ");
INSERT INTO sby_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kufumapo beshikwiya balaya kuli Yesu ne kumwambileti, “Mwami, Mwami, kamupundukani tulafu!” Lino Yesu walapunduka walakalalila lukupwe ne mankape alamwena tonto ");
INSERT INTO sby_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Lino Yesu walambila beshikwiya bakendi eti, “Nomba lushomo lwenu lulikupeyo?” Nabo balatina nekupwilwa mano nkabepushanyeti, “Nomba uyu nimuntu uli econi lambilinga lukupwe nalo lulamunyumfwilinga?” ");
INSERT INTO sby_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Balo balashika kucishi ca Gelasa calangana ne cishi ca Galileya. ");
INSERT INTO sby_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu mpwalafuma mubwato walakumanya, mutuloba naumbi walafuma mumunshi. Mutuloba usa walikukute mishimu yaipa. Lingi walikwenda matakosha, nkalikwikala pa ng'anda nsombi mumaceni akumanda. ");
INSERT INTO sby_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Mpwalamubona Yesu, walolobesha ne kufukama kuntangu ne kwamba ne liswi lya pelu eti, “Nomba ndamwinshi cani amwe Yesu mwanendi Lesa wakwilu wapitapo? Ndamusengenga mutampesha.” ");
INSERT INTO sby_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Walambeco pakwinga Yesu walambila mushimu waipa eti ufumemo muli endiye. Mankanda angi mushimu wamwikata, nambi bantu bamusunga makasa ne ncetani kayi ne nshimbi kumyendo eti bamululamike, wali kasutula. Lino mishimu yaipa yalikumutwala ku cisuwa. ");
INSERT INTO sby_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Lino Yesu wamwipusheti, “Njobe bani?” Neye walakumbuleti, “Njame likoto” Walambeco pakwinga walikukute mishimu yaipa ingi. ");
INSERT INTO sby_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Lino popelapo mishimu yaipa iyo yalamupapata Yesu eti ataitandanyina kucisengu citali. ");
INSERT INTO sby_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Lino mwinshi mwa mulundu mwalikuba litanga linene lya nkumba lyali kalilya. lino mishimu yaipa isa yalasenga Yesu eti yenga ingile munkumba isho, neye walaisuminisha. ");
INSERT INTO sby_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Lino yalafumamo mumutuloba usa ne kwingila munkumba, Lino litanga lyonse lyalaselemukila kumukolo lubilo kuya kulwenje nekuya kuliwalamo nekufwilamo. ");
INSERT INTO sby_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Beshikwembela nkumba mpobalaboneco, balaya akwambila bantu balikwikala mumusena kayi ne muminshi calenshika. ");
INSERT INTO sby_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Neco bantu balesa akubona calenshika. Mpobalashika kwalikuba Yesu, balacana muntu walafunyiwa mishimu yaipa wekala pepi ne Yesu kaliwafwala, mano kali akwana cena. Lino bantu balatina. ");
INSERT INTO sby_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bantu balabona byalenshika balambila bantu mbuli ncalaba cena muntu uyo walikuba ne mishimu yaipa. ");
INSERT INTO sby_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Lino bantu bonse balikwikala mucishi ca Gelasa balapapatila Yesu eti afumemo mucishi cabo pacebo cakwambeti balatina. Kufumapo walengila mubwato kwambeti abwelele ");
INSERT INTO sby_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Lino mutuloba uyo walafunyiwa mishimu yaipa walasenga Yesu eti benga bonse, linoYesu walamukanisha ne kumwambileti, ");
INSERT INTO sby_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Bwelela kucomwenu uye wambe bintu byonse Lesa mbyalakwinshili. Popelapo muntu usa walaya mumunshi wonse kaya kwamba sha bintu Yesu mbyalamwinshila.” ");
INSERT INTO sby_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Lino Yesu mpwalabwelela kulubasu lumbi lwa lwenje bantu bangi balamutambula, balikuba bakondwa pakwinga bonse bali kaba mupembelela. ");
INSERT INTO sby_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Lino kwalesa muntu wali kukwiweti Yailo uyo wali kutangunina ng'anda yakupaililamo walesa kusuntama kuntangu kwa Yesu ne kumusengeti ayenga kung'anda yakendi. ");
INSERT INTO sby_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","pakwinga mwanendi mutukashi wa myaka likumi ne ibili mwana umowa, ngwalikukute wali kakolwa cakwambeti ngofwa. Yesu mpwalikuya, bantu bangi balamushankanya. ");
INSERT INTO sby_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Palikuba mutukashi naumbi walikukolwa bulwashi bwa mukunko kwa byaka likumi ne bibili. Walapwisha buboni bwakendi bonse mubang'anga, nsombi kuliya muntu nambi umo walakonsha kumusengula. ");
INSERT INTO sby_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mutukashi uyo walesa kunyuma kwa Yesu pabantu bangi balikuba bamushinguluka nekwikata kucelele kwamunganjo wakendi, popelapo bulwashi bwamukunko bwalapwa. ");
INSERT INTO sby_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Neco Yesu walepusheti, “Niyani lanjikata ku munganjo?” Bonse bantu balakana eti paliyawa. Petulo walambeti, “Kufula bantu balamukumyunga kayi bantu balamushankanyanga.” ");
INSERT INTO sby_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Lino Yesu walambeti, “Nkwali muntu naumbi lanjikata kumunganjo, pakwinga ndanyumfu ngofu shimbi shilafumumo mulinjame.” ");
INSERT INTO sby_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Lino mutukashi usa mpwalaboneti nkela kusolamapo walalitwala kuli Yesu nkatutuma walawa kuntangu kwakendi Yesu. Ne kwamba byonse pamenso a bantu kabanyumfwa mbuli ncalamwikata kumunganjo ne kuba cena pacindi copeleco. ");
INSERT INTO sby_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu walamwambileti, “Mwaname, pakwinga washoma njame, koya mulumuno.” ");
INSERT INTO sby_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu kacamba kwalesa muntu kufuma ku ng'anda ya mukulene wa ng'anda yakupaililamo ne kumwambila Yailo eti, “Mwanenu lafu kendi, mutapensha beshikwiyisha.” ");
INSERT INTO sby_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu mpwalanyumfwa makani ayo walambila Yailo eti, “Utatina, koshoma, mwanobe nabe cena.” ");
INSERT INTO sby_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesu mpwalashika kung'anda ya Yailo liya kusuminisha muntu nambi umo eti engilemo, nsombi Petulo, Yohane, ne Jemusi kayi ne baishi nebanyina ba mwana. ");
INSERT INTO sby_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Bantu bonse mung'anda bali kabalila mwana mutukashi walikuba wafwa. Necikabeco Yesu walabambileti, “Kamucilekani kulila pakwinga uyu mwana nkafwapo, wonowa tulo.” ");
INSERT INTO sby_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Popelapo bonse balamuwela, pakwinga bonse balikwi shibeti lafu kendi. ");
INSERT INTO sby_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Lino Yesu walekata mwana uyo pacikasa nekwambeti, “Mwana obe punduka!” ");
INSERT INTO sby_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Popelapo walaba muyumi, walanyamuka. Lino Yesu walabambileti bamupe cakulya mwana alye. ");
INSERT INTO sby_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Baishi ne banyina ba mwana uyo balakankamana. Lino Yesu walabambileti kamutaya kwambila muntu uliyense pamakani aya alenshiki. ");
INSERT INTO sby_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu walabunganya beshikwiya bakendi ne kubapa ngofu shakufunya mishimu yaipa ne kushilika malwashi. ");
INSERT INTO sby_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Lino Yesu walabatuma kuya kukambauka sha Bwami bwakendi Lesa ne kushilika malwashi. ");
INSERT INTO sby_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Walabambileti, “Mutanyamunapo cintu nambi cimo mubulwendo bwenu, mutamanta inkoli, mukopa, cakulya, mali nambi byakufwala bibili. ");
INSERT INTO sby_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Mwakashika mung'anda moshi bakamutambule cena, mukekale mwepelomo kushikikila busuba mboti mukafume mumushi umo. ");
INSERT INTO sby_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Uko nkweshi bakabule kumutambula, pakufuma mumushi umo, mukalipampe lusuko kumyendo. Ici nicikabe cishibisho kuli endibo.” ");
INSERT INTO sby_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Beshikwiya balenda muminshi yonse, kabaya akukambauka Mulumbe Waina ne kushilika malwashi kuli konse. ");
INSERT INTO sby_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Lino mwami Helode, mpwalanyumfwa byonse byalenshika, walapenga mumoyo pakwinga bantu bambi bali kabambeti, “Uyu ni Yohane lapunduku kufuma kubafu.” ");
INSERT INTO sby_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bambi bali kabambeti, “Ni Eliya laboneke kayi, nabambi eti, ni umo wa bashinshimi bakulukulu lapunduku kubafu.” ");
INSERT INTO sby_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Helode walambeti, “Yohane ni usa ngondatimbula mutwi, nomba niyani uyu lenshinga bintu ibi mbyondanyumfunga?” Neco wali kayanda kubona Yesu uyo. ");
INSERT INTO sby_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Lino mpobabwelela batumwa balamwambila Yesu byonse mbyobalensa. Kufumapo Yesu walaya ne beshikwiya bakendi kuminshi yaku Betisaida. ");
INSERT INTO sby_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Bantu bangi mpobalanyumfwa balamukonkela uko nkwalaya. Yesu walabatambula, neku bambila sha Bwami bwakendi Lesa, ne kushilika abo bali kabasuni kwambeti babe cena. ");
INSERT INTO sby_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Lisuba mpolyalikuba pepi kwibila, beshikwiya bakendi bali likumi ne babili balaya kuli Yesu ne kumwambileti, “Kamubambilani bantu benga muminshi ne misena ili pepi balangole byakulya ne kwakona pakwinga kuno nikucisuwa.” ");
INSERT INTO sby_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nsombi Yesu walabambileti, “Amwe mubape byakulya.” Beshikwiya bakumbuleti, “Tukute owa shinkwa usanu ne inswi shibili. Lino sena musuni kwambeti tuye tule byakulya byakwana bantu aba?” ");
INSERT INTO sby_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Palikuba batuloba bonka bakwana 5,000. Lino Yesu walabambila beshikwiya bakendi eti, “Kamwambilani bantu bekale mumakoto, likoto lya makumi ali asanu.” ");
INSERT INTO sby_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Beshikwiya balensa mbuli ncobalambilwa. ");
INSERT INTO sby_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu walanyamuna shinkwa usanu ne Iswi shibili uto, walalanga kwilu ne kulumba Lesa, walakomona nekupa beshikwiya eti bayabile bantu. ");
INSERT INTO sby_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bantu bonse balalya nekwikuta. Nomba beshikwiya balabwesa byonse byalashalako ku bantu nekwisusha bitundu likumi ne bibili. ");
INSERT INTO sby_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nabumbi busuba Yesu wali kapaila enka, beshikwiya bakendi naboyo balikuba pepi. Lino walabepusheti, “Sena bantu bangi balambangeti ame njame bani?” ");
INSERT INTO sby_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Balo balakumbuleti, “Bambi balambangeti njamwe Yohane mubatishi. Kayi nabambi balambangeti njamwe Eliya. Kayi nabambi eti njamwe umo wabanshinshimi bakulukulu walapunduka kubafu.” ");
INSERT INTO sby_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Lino Yesu walabepusheti, “Nomba amwe mukute kwambeti ame njame bani?” Petulo walakumbuleti, “Njamwe Wananikwa wa Lesa.” ");
INSERT INTO sby_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Nomba Yesu walakonkomesha beshikwiya kwambeti kabatambila muntu nambi umo makani aya. ");
INSERT INTO sby_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kayi walambeti, “Mwana Muntu welela kupenshewa ne kukanwa ne bamakulene beshimilumbo ne bamakulene baba Yuda ne beshikwiyisha ba Milawo nibakamukane. Nendi naka shinwe, nsombi busuba bwabutatu nakapunduke kubafu.” ");
INSERT INTO sby_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kufumapo walambila bonseti, “Namuntu layandanga kunkonkela ame, welela kushiya nekusula bintu byonse busuba ne busuba kunyamuna lusanda lwakendi nekunkonkela. ");
INSERT INTO sby_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Pakwinga layandanga kupulusha buyumi bwakendi nakabutaye. Nomba uyo latayanga buyumi bwakendi pacebo ca njame, cakubinga nakabucane. ");
INSERT INTO sby_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nomba cainapo ni cani na muntu laba ne bintu byonse bili mucishi capanshi cino, nendi ubutaya buyumi bwakendi bwancinencine nambi kubononga? ");
INSERT INTO sby_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Palico na muntu unyumfwa insoni pacebo ca maswi akame, neye Mwana Muntu nakamunyufwile insoni pakwisa mubulemu bwakendi ne mubulemu bwa Baishi nebwa bangelo bwaswepa. ");
INSERT INTO sby_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Cakubinga ndamwambilingeti mpobali bambi pano beshi bakabule kufwa kabatana babona Bwami bwa Lesa.” ");
INSERT INTO sby_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mpopalapita masuba asanu ne atatu Yesu mpwalamba makani aya, walamanta Petulo ne Yohane ne Jemusi walaya pa mulundu kuya kupaila. ");
INSERT INTO sby_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Lino mpwalikupaila, ciwa cakendi Yesu calasanduka ne byakufwala byakendi byalabemba tuu. ");
INSERT INTO sby_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Popelapo kwalaboneka batuloba babili Mose ne Eliya kabamba ne Yesu. ");
INSERT INTO sby_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Balaboneka mubulemu bwa kwilu kayi kabambilana sha palufu lwa Yesu lwakuya kufwila ku Yelusalemu. ");
INSERT INTO sby_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Lino Petulo ne abo mbwalikuba nabo balikuba mutulo. Nomba mpobalapunduka balabona bulemu bwa Yesu ne bantu babili bemana pepi nendiye. ");
INSERT INTO sby_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Pacindi mpwalikupansana nabo, Petulo walambila Yesu eti, “Bashikwiyisha, cileni kwambeti tuli pano katwibaka mishasha itatu, umbi wenu, umbi wa Mose, umbi wa Eliya.” Petulo nkalikwishiba ncali kwamba. ");
INSERT INTO sby_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kacamba, kwalesa likumbi lyabafwekelela. Lino beshikwiya balatina. ");
INSERT INTO sby_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Lino mulikumbi umo mwalanyumfwika liswi lya kwambeti, “Uyu emwaname ndalamusala neco mumunyumfwile!” ");
INSERT INTO sby_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Lino maswi mpwalacileka kunyufwika, beshikwiya balabona Yesu lashala enka. Neco balamwena tonto, kufuma apo baliya kwambilapo muntu nambi umo mbuli ncobalabona. ");
INSERT INTO sby_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mumene mene Yesu ne beshikwiya bakendi batatu balaseluka pa mulundu, nalyo likoto linene lyabantu lyalakumanina ne Yesu. ");
INSERT INTO sby_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Popelapo, muntu umbi wamulikoto ilyo walolobesheti, “Bashikwiyisha, ndamusengengeti munyumfwileko inkumbo uyu emwaname enka ngonkute. ");
INSERT INTO sby_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ukute mushimu waipa na ulamwikata ukute kakuwa, kayi ne kunyukuma mpaka ufuma lipofu kumulomo. Kayi nkaukute kumulekapo mpaka umulingapo. ");
INSERT INTO sby_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Lino ndanga ndasenge beshikwiya benu eti baufunye, nomba balalilwa.” ");
INSERT INTO sby_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu walakumbuleti, “Ha! Bantu babula lushomo, mweshikupindimuna miyeyeyo, nomba ninjikale nenu cindi citali econi? Kamumuletani kuno mwana.” ");
INSERT INTO sby_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mwana uyo mpwalikuya kuli Yesu, mushimu waipa walamuwala panshi ne kumunyukumuna. Nendi Yesu walakalalila mushimu waipa ne kushilika mwana usa. Lino walamubwesha kuli baishi. ");
INSERT INTO sby_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bantu bonse balakankamana mpobalabona ngofu shinene sha Lesa. Bantu kabacikankamana pa bintu ibyo mbyalensa, Yesu wabambila beshikwiya bakendi eti, ");
INSERT INTO sby_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Kamunyumfwishisha makani aya ngoti ndimwambile! ame Mwana Muntu ninkayabwe mumakasa abantu.” ");
INSERT INTO sby_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Nsombi balo baliya kwinshiba ncalikwamba pakwinga calikuba casolama nomba baliyawa kwanyumfwishisha. Kayi balatina kumwipusha. ");
INSERT INTO sby_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Beshikwiya balatatika kupikishana kwambeti benshibe nomba mukulene niyani pakati pabo. ");
INSERT INTO sby_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Lino Yesu walenshiba ncobali kabayeya mumyoyo, walamanta mwana nekumwikalika kulubasu lwakendi. ");
INSERT INTO sby_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Lino walabambileti, “Muntu uliyense welela kutambula mwana mbuli uyu mulina lyakame, latambulu ame. Muntu uliyense ukute kutambula ame latambulunga uyo walantuma, pakwinga uyo ngomwasula pakati penu emukulene.” ");
INSERT INTO sby_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Lino Yohane walambeti, “Amwe beshikwiyisha, twabona muntu umbi nkafunya mishimu yaipa mulina lyenu, nomba twamukanisha pakwinga nte wa mulikoto lyetu.” ");
INSERT INTO sby_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesu walamwambileti, “Mutamukanisha, pakwinga uyo labulunga kutotekeshana nenjamwe uli kulubasu lwenu.” ");
INSERT INTO sby_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Lino mpocalashika cindi cakwambeti Yesu enga kwilu, walayeya kuya ku Yelesalemu. ");
INSERT INTO sby_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Walatuma batumwa kuntangu kwakendi abo balaya kuya kwingila mumunshi wa Samaliya kwambeti bamubambile busena. ");
INSERT INTO sby_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bantu ba mumunshi uyo baliyawa kumutambula pakwinga walikaya ku Yelusalemu. ");
INSERT INTO sby_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Lino beshikwiya ba Yesu, Jemusi ne Yohane, mpobalabona balambeti, “Mwami, sena nkatwela kwambeti tukuwe mulilo ufume kwilu wise wononge bantu aba?” ");
INSERT INTO sby_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesu walacebuka ne kubakalalila beshikwiya. ");
INSERT INTO sby_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Popelapo bonse balanyamuka balaya kumunshi umbi. ");
INSERT INTO sby_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Mpobalikuya munshila, muntu umbi walambila Yesu eti, “Nindimukonkelenga kuli konse nkweshi mwenganga.” ");
INSERT INTO sby_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu walamukumbuleti, “Bamwaba bakute mishima, kayi ne bikeni bikute bisangala, lino Mwana Muntu liyawa pakona.” ");
INSERT INTO sby_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Panyuma pakendi Yesu walambila naumbi eti, “Unkokele.” Nsombi nendi muntu uyo walambeti, “Mwami tanshika munsuminishe njenga mbike bata.” ");
INSERT INTO sby_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu walakumbuleti, “Leka bafwa babike bafu banabo, nsombi obe koya ukambauke sha Bwami bwa Lesa.” ");
INSERT INTO sby_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Naumbi muntu walambeti, “Nindimukonkele Mwami, lino tanguna nje ndaye kung'anda yakame.” ");
INSERT INTO sby_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu walakumbuleti, “Muntu atatika kulima ne ngombe, kayi nkacebuku kunyuma, Lesa liya nendi incito mu Bwami bwakendi.” ");
INSERT INTO sby_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Panyuma pakendi Mwami Yesu walasala bambi batuloba makumi asanu ne abili ne bantu babili ne kubatuma nanshi kuntangu kuya muminshi ne misena yonse nkwalikuyanda kuyako. ");
INSERT INTO sby_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kufumapo walabambileti, “Kutebula kulafulu, lino beshikutebula balacepe. Lino sengani kuli mwine libala kwambeti atume bambi basebenshi beshikutebula.” ");
INSERT INTO sby_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kamuyani, nomba ndamutumunga mbuli bana bambelele pakati pabaumpe. ");
INSERT INTO sby_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mutamanta mpotomona ya mali, cola nambi nkwabilo. Mutataya cindi ca kupana mutende ne bantu munshila. ");
INSERT INTO sby_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Mung'anda muli monse momulengili mutangune kwambeti, Mube lumuno mung'anda muno. ");
INSERT INTO sby_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Na mung'anda umo muli muntu layandanga lumuno, lumuno ulo nilukabe kuli endiye. Nsombi na muliya muntu wa mushoboyo, ekwambeti lumuno nilukabwelele kuli njamwe. ");
INSERT INTO sby_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mwakekala mung'anda yopeleyo kayi mukalye ne kunwa byonse byoti bakamupe pakwinga musebenshi uliwonse ukute kutambula malipilo akendi. Mutafumanga nkomulashikili nekuya kumanda ambi. ");
INSERT INTO sby_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Mwashika mumushi mweshi bakamutambule mukalye byonse mbyeti bakamupe. ");
INSERT INTO sby_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mukasengule bantu balwashi mumunshi umo kayi nekubambila bantu eti, Bwami bwa Lesa bulesa pepi nenjamwe. ");
INSERT INTO sby_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mwakashika mumunshi umbi bantu bakabule kumutambula, kamuyani munshila sha mumunshi uyo nekwambeti, ");
INSERT INTO sby_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","nambi lusuko lwamuminshi iyi lulamatila kumyendo yetu nikulupampa nekwambeti lube kamboni. Lino inshibani kwambeti Bwami bwalesa Lesa buli pepi! ");
INSERT INTO sby_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ndamwambilinga cakubingeti pabusuba bwakubeteka, minshi iyo nikabe ne mulandu kupita munshi wa Sodomu! ");
INSERT INTO sby_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Ukute malele, obe Kolasini ne Betisaida! Pakwinga kuli incito yangofu yalenshika muli amwe, ne yalenshika kuminshi ya Tulo ne Sidoni, bantu bakusa, ne balasanduka kendi kuleka bwipishi nekufwala masaka kayi nekulinanika milota, kubonesheti balatembenuku kuleka bwipishi. ");
INSERT INTO sby_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ndamwambilinga cakubingeti pabusuba bwakubeteka Lesa nakamupeni mulandu unene kupita baku Tulo ne Sidoni. ");
INSERT INTO sby_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nenjobe Kapelenawo, sena ulayeyengeti nibakakunyamune mpaka kwilu? Sobwe, nibakakuwale panshi pabusena bwa bafu!” ");
INSERT INTO sby_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu walambila beshikwiya bakendi eti. “Uyo lanyumfwili amwe ekwambeti lanyumfwili ame, uyo weshi kukana ame lakana ne Bata balantuma.” ");
INSERT INTO sby_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Bantu bali makumi asanu ne abili ne bantu babili balabwelako kabalibakondwa balambeti, “Mwami, Lino ne mishimu yaipa ilatunyumfwilinga twayambila mulina lyenu.” ");
INSERT INTO sby_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu walabakumbuleti, “Ndamubona Satana nkalaka kwilu eti kubyasha kwamfula. ");
INSERT INTO sby_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Lino kamunyufwani! Ndamupanga ngofu shakulyata injoka ne tupilili kayi ne kukoma ngofu shonse sha mulwani. Kuliya ceti cikamulinge. ");
INSERT INTO sby_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nsombi mutakondwa kwambeti mishimu yaipa yamunyumfwilanga, nomba kondwani pakwinga mena enu alembwa kwilu.” ");
INSERT INTO sby_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Pacindico Yesu walakondwa mu Mushimu Uswepa. Lino walambeti, “Ndalumbu Ta, amwe mwine kwilu ne cishi ca panshi pakwinga mulayubululu kubantu babula kwiya bintu mbyomwalasoleka kubantu ba mano ne baiya. Cakubinga Ta, mwalayanda kwinsa kwelana nekuyanda kwenu. ");
INSERT INTO sby_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Ba Ta balabika bintu byonse mumakasa akame. Kuliya muntu winshi mwana, nsombi ba Ta bonka. Kayi kuliya muntu winshi ba Ta, nsombi Mwana enka kayi ne abo Mwana mbwalasaleti abayubulwile.” ");
INSERT INTO sby_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Popelapo walalanga kuli beshikwiya bakendi nekubambila kulubasu eti, “Bakute colwe abo balabononga bintu ibi mbyomulabononga. ");
INSERT INTO sby_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ndamwambilingeti banshinshimi ne bami bangi bali kuyandishisha kubona mbyomulabononga, nomba baliya kubibonapo. Ni cakubinga bali kuyandishisha kunyumfwa bintu mbyomulayumfunga, nomba baliya kubinyumfwa.” ");
INSERT INTO sby_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Popelapo kwalesa shikwiyisha Milawo kwambeti asunkwe Yesu ne kumwipusheti, “Amwe beshikwiyisha, nicani ncendela kwinsa kwambeti nkatambule buyumi butapu?” ");
INSERT INTO sby_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu walamwipusheti, “Nomba mu Milawo mwalembwa cani? nomba mukute kubelengamo cani?” ");
INSERT INTO sby_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Shikwiyisha Milawo walakumbuleti, “Suna Mwami Lesa wakobe ne moyo wakobe wonse, ne buyumi bwakobe bonse, nengofu shakobe shonse kayi ne miyeyo yakobe yonse, ‘Kayi kosuna munobe mbuli ncolisuni omwine.’ ” ");
INSERT INTO sby_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu wamwambileti, “Ulakumbulu cena, uye winseco, nukabe ne buyumi butapu.” ");
INSERT INTO sby_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Lino shikwiyisha pakuyanda kulibonesheti walulama, walepusha Yesu eti, “Nomba muname niyani?” ");
INSERT INTO sby_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu walakumbuleti, “Kwalikuba muntu ku Yelusalemu walikuya ku Yeliko. Mpwalikuya munshila, walakumanya kapondo balamwikata, balamufulula ne kumuma, nekumushiya nkali wawisuka. ");
INSERT INTO sby_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Lino shimilumbo walikapita munshila yopeleyo, mpwalabona muntu uyo walomwa, walapitila kumbali. ");
INSERT INTO sby_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Neye Mulevi walikapita munshila yopeleyo, mpwalashika palikuba muntu walomwa walamubona nomba neye walapitila kumbali. ");
INSERT INTO sby_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nsombi Musamaliya walikuba pabulwendo munshila yopeleyo mpwalamubona muntuyo walanyumfwa inkumbo. ");
INSERT INTO sby_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Walaya mpwalikuba wona waletila mafuta ne waini pabilonda byakendi nekusungapo bikwisa. Mpwalapwisha kwinseco walamumanta pambongolo yakendi ne kumutwala kung'anda ya bensu uko nkwalamubamba cena. ");
INSERT INTO sby_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Bushiku bwalakonkapo mu Samaliya uyo walapa mali mwine ng'anda ya bensu nekumwambileti, ‘Mumusunge cena, na mukasebensenshe mali naambi ninkese nkalipile ndakabwelanga.’” ");
INSERT INTO sby_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Lino Yesu pakupwisha walepusha shikwiyisha milawo eti, “Lino mumuyeyo wakobe, niyani pabantu batatu aba welela kuba munendi wamuntu walomwa ne kapondo?” ");
INSERT INTO sby_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Shikwiyisha milawo walakumbuleti, “Uyo walamunyumfwila inkumbo.” Lino Yesu walamwambileti, “koya lino winse mbuli copeleco.” ");
INSERT INTO sby_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Lino Yesu nebeshikwiya bakendi mpobalikuba mulwendo lwabo, balashika mumunshi mwali kwikala Malita. Mutukashi uyo walabatambula ne makasa abili mung'anda yakendi. ");
INSERT INTO sby_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Malita walikuba ne mukwabo Maliya uyo walikuba wekala panshi pepi ne Yesu kakutika kwiyisha kwakendi. ");
INSERT INTO sby_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Lino pacindico Malita incito yalamufulila walaya kuli Yesu nekwambeti, “Mwami sena nkamubweni kwambeti kanike wakame landekelenga incito yonse? Kamumwambilani ese anyafwe.” ");
INSERT INTO sby_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mwami Yesu walamukumbuleti, “Malita obe! wasukamanga nekupeshewa pa bintu bingi, ");
INSERT INTO sby_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","nsombi kuli cintu cimo cisuniki, Maliya lasala cintu caina kayi kuliyeti akamulamunepo.” ");
INSERT INTO sby_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nabumbi busuba Yesu walikapaila kumusena umo. Mpwalapwisha, umo weshikwiya wakendi wamwambileti, “Mwami, kamutwiyishani kupaila mbuli Yohane ncalaisha beshikwiya bakendi.” ");
INSERT INTO sby_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu walabambileti, “Pakupaila kamwambangeti, “Ta, lilemekwe lina lyenu lyaswepa, Bwami bwenu bwise. ");
INSERT INTO sby_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mutupenga byakulya bilayandikinga lelo, kayi ne masuba onse. ");
INSERT INTO sby_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mutulekelele bwipishi bwetu mbuli ncotukute kulekelela bantu beshikutwipishila, Kamutatutwala mumasunko.” ");
INSERT INTO sby_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Lino walabambileti, Nomba na umbi popele pano uya kung'anda yamunendi pakati pamashiku nekwambeti, Mwana, kombwelekako shinkwa utatu, ");
INSERT INTO sby_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","pakwinga ndapolelwa mwensu uli pabulwendo. Lino ndiya cakumupa kwambeti alye! ");
INSERT INTO sby_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Lino munobe akumbwila mukati eti, utanshupa! Kucishinga tulacalako kendi kayi ame nebana bakame tulono kendi. Nkandelela kupunduka kwambeti nkupe shinkwa. ");
INSERT INTO sby_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ndamwambilingeti, nakapunduke nekumupa, kwakubula kwambeti nimunendi nsombi pakwinga lakakatili kumusenga. Nakamupe byonse mbyabula. ");
INSERT INTO sby_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Weco ndamwambilinga, kamusengani nimukapewe, kamulangolani nimukacane kayi kamukonkoshani nibakamucalilwe. ");
INSERT INTO sby_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","“Pakwinga uyo weshi kusenga ukute kupewa, ne uyo weshi kulangola ukute kucana neye weshi kukonkosha nibakamucalwile. ");
INSERT INTO sby_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","lino niyani mushali pakati penu, na mwanendi umusenga inswi, sena ngomupa injoka? ");
INSERT INTO sby_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Nambi amusenga liyi, sena ngomupa kapilili? ");
INSERT INTO sby_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nomba amwe, mobantu baipa, mukute kupa bana benu byaina, nomba bata ba kwilu ngabalilweconi kupa Mushimu Uswepa kuli abo balamusengenga?” ");
INSERT INTO sby_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesu walikafunya mushimu waipa walikukanisha muntuyo kwamba. Mushimu uyo mpowalafumamo, muntuyo walatatika kwamba. Neco bantu bonse balikubapo balakankamana. ");
INSERT INTO sby_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nsombi bambi balambeti, “Ukute kufunya mishimu yaipa pakwinga Belezebulu emwami wa mishimu yaipa, eukute kumupa ngofu.” ");
INSERT INTO sby_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Cindi copeleco bambi balelesha kusunka Yesu eti ababoneshe cikankamanisho ceshi cifuma kwilu. ");
INSERT INTO sby_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nsombi Yesu walenshiba miyeyo yabo, Lino walabambileti, “Bulelo bonse bwabukilana ne kutatika kulwana, bulelo ubo bukute kumwaika. Na bantu ba mukowa umo babukilana, mukowa uwo ngomwaika. ");
INSERT INTO sby_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nomba na bwami bwa Satana bubukilana, nomba bwami ubo ngabuyuma econi? Amwe mulambangeti, nkute kupulisha mishimu yaipa ne ngofu sha Belezebulu. ");
INSERT INTO sby_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Lino na ame ndapulishinga mishimu yaipa mbuli ncobalenshinga beshikwiya benu, nomba ame ngamung'ambeconi eti ndapulishinga mishimu yaipa ne ngofu sha Belezebulu, nomba beshikwiya benu balapulishinga mishimu yaipa nengofu shabani? Palico beshikwiya benu nibakamulesheti mwalubila. ");
INSERT INTO sby_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nsombi na ame nkute kupulisha mishimu yaipa mungofu sha Lesa, ekwambeti Bwami bwa Lesa buli pakati penu.” ");
INSERT INTO sby_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Na muntu wangofu kalangilila ng'anda yakendi ne byensho, buboni bwakendi nkabwela kwibwapo. ");
INSERT INTO sby_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nsombi umbi wapitapo ngofu na lesa, nekumukoma, ukute kumanta bibya byakendi byonse mbyacinkilamo ne kuyabanya buboni mbwalebila bantu. ");
INSERT INTO sby_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Muntu uliyense labulunga kwikatishana nenjame nimulwani wakame, uyo labulunga kunyamfwa kubunganisha mbelele, nendi niweshi kupalanganya.” ");
INSERT INTO sby_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Na mushimu waipa ulafumu mumuntu, ukute kuya mumalundu a kuyandaula kwakupumwinina. Nakulabulu kucanika, ukute kwambeti, nimbwelele mung'anda yakame mondalafuma. ");
INSERT INTO sby_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Lino na ulabwelele ukute kucana ng'anda iyo yaswepa cena. ");
INSERT INTO sby_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Lino ukute kuletelapo imbi isanu ne ibili yapitapo pali nayo, kwambeti bengile nekwikala mumuntu uyo. Neco bwikalo bwamuntu uyo bukute kwipa kupita bwakutanguna.” ");
INSERT INTO sby_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu mpwalapwisha kwambeco mutukashi umbi mulikoto walolobesheti, walelekwa mutukashi walakusema nekukuyamwisha. ");
INSERT INTO sby_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Lino Yesu walakumbuleti, “bakute colwe abo balanyumfunga Maswi a Lesa ne kwinsa ncalambanga!” ");
INSERT INTO sby_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Bantu mpobalikuya kufula, Yesu walatatika kwambeti, “Bantu bacino cindi baipa, bakute kuyanda kubona cingashilo cishikufuma kwilu, lino nteshibakacibonepo cingashilo ico, nsombi ca mushinshimi Yona. ");
INSERT INTO sby_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Mbuli Yona ncalikuba cingashilo ku Ninive, neye Mwana Muntu nakabe cingashilo capewa kubantu ba cino cindi. ");
INSERT INTO sby_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Pabusuba bwakubeteka mwami mutukashi wa kumbonshi kwa cishi ca Sheba nakamutoteke pakwinga walafuma kwakuma cishi kwisa akunyumfwa mano a Solomoni. Kamubonani pano mpwali wapita Solomoni ");
INSERT INTO sby_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Pabusuba bwakubetekwa, bantu baku Ninive nibakapunduke pamo ne bantu bamusemano uwu, nibakabatoteke. Pakwinga balo balasanduka kufuma kubwipishi, mpwalabakambaukila Yona. Lino mpwali pano wapita Yona.” ");
INSERT INTO sby_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Kuliya muntu wela kumunika lampi ne kwisoleka nambi kwifwekelela ne nongo, nsombi ukute kwibika pelu kwambeti imunikile bonse balengilinga mung'anda. ");
INSERT INTO sby_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Menso enu emumuni wa mubili wenu. Na menso enu ali cena. Ne mubili wonse ukute kuba mu mumuni. Nsombi na menso enu abula kuba cena, mubili wonse ukute kuba mumunshinshe. ");
INSERT INTO sby_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Lino kamucenjelani kwambeti mumuni uli muli njamwe utaba mushinshe. ");
INSERT INTO sby_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Neco na mubili wonse kauli mumuni kwakubula mushinshe, mubili wonse ukutekuba mumuni mbuli lampi lilakumunikilinga.” ");
INSERT INTO sby_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu mpwalapwisha kwamba, Mufalisi walamukuwa eti alye nendiye. Neco Yesu walaya mung'anda nekwikala kwambeti kulya. ");
INSERT INTO sby_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mufalisi uyo walakankamana mpwalaboneti Yesu latatiki kulya katana asamba kumakasa kwelena ne myambo yabo. ");
INSERT INTO sby_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Popelapo Mwami Yesu walamwambileti, “Lino amwe Bafalisi mukute kusuka kunsa kwambale nenkomeshi, nsombi mumyoyo yenu mwesula kulisuna ne nebukapondo. ");
INSERT INTO sby_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Amwe mobantu baluya! Sena Lesa walalenga byakunsa ntendiye walalenga ne byamukati? ");
INSERT INTO sby_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pakupa bapenga, mubapenga bintu ibyo bili mukati munkomeshi ne mumbale, Lino byonse bintu byenu nibikabe byaswepa.” ");
INSERT INTO sby_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Mapensho, kuli amwe Bafalisi! Pakwinga mulabikilinga mano kwambeti mupe Lesa ca likumi pa tuntu tungana tungangana tweshikulengesha kwambeti buchisa bununkile cena. Nsombi nkamukute kwinshila bantu bintu byalulama nambi kusuna Lesa. Pakwinga bintu ibi mwelela kubinsa, kwakubula kusula nabimbi ibyo.” ");
INSERT INTO sby_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Mapensho nakabe pali njamwe Bafalisi! Pakwinga mukute kusala bipuna byabulemu mumanda akupaililamo, ne kusuna kupewa mitende yabulemu mumisena yakulishilamo.” ");
INSERT INTO sby_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Mapensho nakabe pali njamwe bafalisi, pakwinga mulyeti manda ataboneke ngobakute kulyatapo cakubula kwinshiba.” ");
INSERT INTO sby_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Lino shikwiyisha Milawo umbi walakumbuleti, “Amwe mobeshikwiyisha pakwambeco nenjafwe mulatusampulunga.” ");
INSERT INTO sby_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu walambeti mapensho kuli abo beshikwiyisha Milawo pakwinga mukute kupa bantu mikuli yalema, nsombi amwe mobene nkamukumyuko nambi pang'ana. ");
INSERT INTO sby_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mapensho nakbe pali njamwe, pakwinga mukute kwibaka byumbwe byaina byabashinshimi, kakuli bamashali benu ebalashina bashinshimi. ");
INSERT INTO sby_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Lino ekwambeti ico calensa bamashali benu cilaleshengeti mukute kucisuminisha kwambeti balo balashina bashinshimi amwe mwalebaka byumbwe. ");
INSERT INTO sby_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Weco Lesa mu mano akendi walambeti, ninkabatume bashinshimi ne batumwa, Lino nabambi pakati pabo nibakabashine kayi nabambi nibakabapenshewe. ");
INSERT INTO sby_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Nomba bantu bacino cindi nibakapewe mulandu wa bashinshimi bonse balashinwa kufuma kumatatikilo a cishi capanshi, ");
INSERT INTO sby_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kutatikila kukushinwa kwa Abelo kushikila kukushinwa kwa Sakaliya, uyo walashinwa pakati pa cipaililo kayi ne Musena Uswepa wa Ng'anda yakendi Lesa. Ndamwambilingeti bantu ba musemano uwu nibakapewe mulandu palibi byonse. ");
INSERT INTO sby_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Malele kuli abo beshikwiyisha milawo! Mwalamanta maki akucalwila bantu bamano. Amwe mobene muliya kwingila, mwalakanisha abo balikuyanda kwingila.” ");
INSERT INTO sby_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu mpwalafuma mung'anda umo, beshikwiyisha Milawo kayi ne Bafalisi balatatika kumutongokila ne kumwipusha mipusho ingi yapusana pusana. ");
INSERT INTO sby_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Balikuyanda kumucaninapo mulandu mumyambo yakendi. ");
INSERT INTO sby_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Pacindico bantu mpobalabungana kwalikuba Yesu, bantu balatatika kulyatana cebo cakufula, Yesu walatanguna kwambila beshikwiya bakendi eti, “Kamucenjelani kamutabeti cishikufufumisha shinkwa ca Bafalisi, pakwinga nkabenshi ncobakute kwamba. ");
INSERT INTO sby_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kantu kalikonse kafwekewa nikakafwekulwe nambi kasolama nikakenshibikwe. ");
INSERT INTO sby_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Neco bilibyonse mbyomulamba mumushinshe nibikanyufwike patuba pa bonse, mbyomulabelebeshana ne muntu mucipinda nibikambwe pamenso a bantu.” ");
INSERT INTO sby_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ndamwambilinga mobanse mutatina abo beshikushina mubili, nomba kuliya nacimbi ncobela kwinsapo. ");
INSERT INTO sby_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Lino ndamwambilingeti ngomwelela kutina ni Lesa uyo ukute kushina buyumi bwa muntu, kayi ukute ngofu shakumuwalani mumulilo utapu, mumutinenga Lesa.” ");
INSERT INTO sby_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Sena Tutite tusanu ntebakute kulishiwa ne tumali tung'ana twa mangwe? Lino kuliya nambi umo Lesa ngwakute kulubapo. ");
INSERT INTO sby_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nomba mishishi yenu ili mumutwi mwenu yonse waibelenga. Neco mutatinanga pakwinga amwe mwadula kupita baciba bangi. ");
INSERT INTO sby_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ndamwambilinga cakubinga, muntu uliyense lansumininga pamenso abantu, nenjame nde Mwana Muntu ninkamusumine pamenso a bangelo ba Lesa. ");
INSERT INTO sby_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nsombi Muntu uliyense lankananga pamenso a bantu, nenjame nde Mwana Muntu ninkamukane pamenso a bangelo ba Lesa.” ");
INSERT INTO sby_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Muntu uliyense weshi kwamba maswi aipa pa Mwana Muntu inga ulekelelwa, nsombi muntu uliyense weshikusampula Mushimu Uswepa, nteshi akalekelelwepo.” ");
INSERT INTO sby_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Bakamwikata kwambeti bakamubeteke mung'anda yakupaililamo, kuli beshikwendelesha nambi kubaleli, mutakasukameti, nimukumbuleconi, nekukaba kuyeyeti nomba nituye twambe cani? ");
INSERT INTO sby_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Pakwinga Mushimu Uswepa nakamwishibishe ncomwelela kwamba pacindico.” ");
INSERT INTO sby_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Umbi muntu walikuba mulikoto walambila Yesu eti, “Beshikwiyisha, kamumwambila mukwetu ampeko buboni bwalashiya bata balobe.” ");
INSERT INTO sby_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Nsombi Yesu wamukumbuleti, “Obe nomba niyani walampa incito yakumubeteka amwe nambi kuyabanya bintu byalamushila bameshenu balobe?” ");
INSERT INTO sby_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Lino Yesu walapitilisha kubambila bantu, “Kamucenjelani kayi mutaba bantu basunishi buboni. Pakwinga buyumi bwa muntu nkabwela kupimwa ne buboni mbwakute.” ");
INSERT INTO sby_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kayi Yesu walabambila mukoshanyo eti, “Umbi muntu mubile walikukute libala umo mwalekata byakulya bingi. ");
INSERT INTO sby_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Mpwalaboneco walatatika kuyeya mumoyo eti, ‘Ndiya butala bunene mwakubika byakulya byakame byonse ibi ninjinseconi’ ");
INSERT INTO sby_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Lino walambeti, ‘Nimwaye matala akame nekwibaka ambi anene kwambeti mbikemo byakulya ne buboni bwakame bumbi bonse. ");
INSERT INTO sby_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Lino ninkambile moyo wakameti, ukute buboni bwingi bwakwana byaka bingi. Neco pumwina, kolya ne kunwa nekukondwa.’ ");
INSERT INTO sby_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Nsombi Lesa walamwambileti, ‘Omuluya! Lelo lyopele mashiku nufwe. Nomba bintu byonse ibi mbyowalabamba kushikila cino cindi nibibe byabani?” ");
INSERT INTO sby_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Lino Yesu pakupwisha walambeti, “Encoti cikabe kuli abo beshikulibunjikila buboni, kakuli pamenso a Lesa baliyapo buboni.” ");
INSERT INTO sby_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesu walambila beshikwiya bakendi eti, “Pacebo ici ndamwambilingeti mutalisukama pa buyumi bwenu eti nitulye cani nambi nitufwale cani. ");
INSERT INTO sby_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Pakwinga buyumi bwapita byakulya, ne mubili wapita byakufwala. ");
INSERT INTO sby_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kamubonani bikwangala, nkabishanga, nkabitebulu biliya ng'anda yakusungilamo bintu nambi manga. Nsombi Lesa ukute kubisanina. Sena nkamwinshi kwambeti Lesa umusuni kupita bikeni? ");
INSERT INTO sby_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Niyani palyamwe welakunungilako busuba bumo kubuyumi bwakendi? ");
INSERT INTO sby_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nomba na nkamwela kucikonsha kwinsa kantu kang'ana eti ako, nipacebo cini mulasukamanga pa bintu bimbi ibyo? ");
INSERT INTO sby_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Kamubonani maluba ncakute kukula. Nkakute kusebensa nambi kutunga byakufwala, nsombi ndamwambilingeti nambi Mwami Solomoni mububile bwakendi bonse, liya kubapo ne byakufwala byaina byalaboneka eti limo pa malubayo. ");
INSERT INTO sby_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Lino na ni Lesa ukute kufwalika mwila uyo ukute kwinsa lelo mpouli, lilo bauwala pa mulilo, nomba amwe, nkela kumufwalika? Amwe bantu balushomo lung'ana!” ");
INSERT INTO sby_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Weco mutasukamanga nambi kuyeyeti nimulye cani nambi kunwa. ");
INSERT INTO sby_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ibi bintu, bantu bakunsa bakute kubiyandaula, nsombi Bameshenu bacinshi kwambeti byonse mubisuni. ");
INSERT INTO sby_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Neco kamuyandaulani Bwami bwa Lesa, nakamupeni bintu byonse ibyo.” ");
INSERT INTO sby_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Amwe kalikoto kang'ana kambelele shakame, mutatina pakwinga Bameshenu balayanda kumupa Bwami. ");
INSERT INTO sby_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kamulishani buboni mbomukute, mali mupe bapenga. Kamulilangwela mpotomona shitabolo kayi mubike buboni bwenu kwilu nkweti bukabule kubola, pakwinga kuliya kabwalala wela kushikako, ne muswa nkawela kubononga. ");
INSERT INTO sby_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Pakwinga myoyo yenu ikutekuba kuli bubile bwenu.” ");
INSERT INTO sby_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Kamubani balibambila cindi conse kayi malampi enu abenga abangila lyonse. ");
INSERT INTO sby_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Kamubani eti basebenshi balapembelenga mwami wabo lafumunga kubwinga kwambeti mpoti ashikile ne kukonkosha, nabo bamucalwile bwangu. ");
INSERT INTO sby_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bakute colwe basebenshi beshi bakacanike kabalanga ne menso mwami wabo akabwela. Ndamwambilinga cakubingeti mwami wabo nakafwale byakufwala bya ncito nekubekalika nekubapa byakulya. ");
INSERT INTO sby_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Bakute colwe basebenshi mwami mboti akacane balibambila, nambi akese pakati pamashiku nambi kumaca. ");
INSERT INTO sby_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nsombi kamwanukangeti, mwine ng'anda abangawenshiba cindi kabwalala ncalesanga, inga nkela kuleka kabwalala kwingila mung'anda yakendi. ");
INSERT INTO sby_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nenjamwe copeleco, kamubani mwalibambila kumutambula Mwana Muntu pakwinga lakesanga pacindi ncomwabula kwingashila.” ");
INSERT INTO sby_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Neye Petulo walepusheti, “Mwami, sena mukoshanyo uyu mulambilinga afwe twenka nambi bantu bonse?” ");
INSERT INTO sby_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mwami Yesu walakumbuleti, nomba niyani musebenshi ukute lushomo kayi ne mano? Uyo mwami ngoshi akape incito yakulangilila bonse ba mu ng'anda yakendi nekupa banendi byakulya pacindi celela? ");
INSERT INTO sby_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nakatambule cilambo musebenshi uyo mwami wakendi pakubwelela ngweti akacane nkensa ico. ");
INSERT INTO sby_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ndamwambilinga cakubingeti mwami wakendi nakamupe incito yakubona bintu byonse mbyakute. ");
INSERT INTO sby_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Lino na musebeshi uyo lamba mumoyo wakendi eti, mwami wakame lacelwa kwisa, lino utatika kuma basebenshi banendi batuloba ne batukashi kayi ne kutatika kulya, kunwa ne kukolwa. ");
INSERT INTO sby_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Mwami wa musebeshi uyo lakesanga pabusuba mbwateshi kayi nepa cindi ncabula kwingashila. Nakamupe cisubulo ciyosha ne kumuwala uko nkoti kukabenga bantu babula lushomo. ");
INSERT INTO sby_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Musebenshi uyo wishi mwami wakendi ncasuni, nomba liya kulibambila nambi kwinsa ncasuni mwami wakendi nakamukwipe cangofu. ");
INSERT INTO sby_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nomba musebenshi utacinshi ncasuni mwami wakendi, na lepishi mwakubula kwinshiba nakomwe pang'ana. Muntu uliyense walapewa bingi welela kubwesha bingi. Muntu walapewa bingi kwambeti asunge, nakambilwe kubwesha bingi pelu pa ibyo mbyalapewa. ");
INSERT INTO sby_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ndalesa kuwala mulilo mucishi capanshi, nendakondwa kwambeti mulilo newabangila kendi! ");
INSERT INTO sby_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nomba ndelela kwingila mulubatisho lwamapensho anene, neco moyo wakame nkawekalikana kushikila mapensho ayo akenshike. ");
INSERT INTO sby_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Sena mulayeyengeti ndalaleta lumuno mucishi ca panshi? Cakubinga ndiyawa, nsombi ndalaleta kupansana. ");
INSERT INTO sby_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kufuma lelo mumukowa umo nimukabe bantu basanu bapatana, batatu nibakapatane nebabili. Naboyo babili nibakabukilane ne batatu ");
INSERT INTO sby_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Baishi nibakabukile mwana mutuloba, neye mwana mutuloba nakabukile baishi, banyina nibakabukile mwana mutukashi, neye mwana mutukashi nakabukile banyina. Kumakwendi batukashi nibakabukile mulekashi, neye mulekashi nakabukile kumakwendi batukashi.” ");
INSERT INTO sby_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu walambila bantu bonseti, “Na mulabono likumbi kalifumina kumboshi, mukute kwambeti, imfula niloke lelo, nicakubinga ikute kuloka. ");
INSERT INTO sby_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Na impepo itatika kupupula kufumina kumusansa mukute kwambeti lelo nikupye cepa, kayi kukute kuba copeleco. ");
INSERT INTO sby_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Amwe bantu batenshi mbyomulambanga, mukute kwinshiba kuboneka kwa cishi capanshi ne kwilu, nomba nicani nkamukute kwinshiba bupandulushi bwa bintu bilenshikinga masuba ano?” ");
INSERT INTO sby_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Nomba nipacebo cini nkamukute kwinsa byalulama mobene? ");
INSERT INTO sby_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Na mulenga kunkuta ne munobe wa mulandu,wela kufwambana kunyumfwana nendi kamucili panshila, kwambeti katakutwala kuli weshi kubeteka. Pakwinga neye weshikubeteka inga ukutwala kumushilikali, neye mushilikali inga ukusunga mujele. ");
INSERT INTO sby_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ndakwambilinga cakubingeti nteshi ukafumemo kushikila ukalipile byonse bilayandikinga.” ");
INSERT INTO sby_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Pacindico bantu bambi balikubapo balamwambila Yesu makani a bantu baku Galileya abo Pilato mbwalashina mung'anda ya Lesa nekusankanya milopa yabo pamilumbo njobalikubenga kuli Lesa. ");
INSERT INTO sby_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Lino Yesu walabakumbuleti, “Sena mulayeyengeti abo ba Galileya balashininwa balikuba baipa kupita ba Galileya bambi bonse? ");
INSERT INTO sby_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Sobwe! Lino ndamwambilingeti na mubule kusanduka kubwipishi bwenu nenjamwe nimukafweti basa. ");
INSERT INTO sby_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nomba abo bantu likumi nebasanu ne batatu lwalabawila lubumbu lutali lwa ku Siloamu, mulayeyengeti balikuba baipa kupita bantu bonse balikwikala mu Yelusalemu? ");
INSERT INTO sby_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Sobwe! Nsombi namubule kusanduka kubwipishi bwenu nenjamwe nimukafwe eti basa.” ");
INSERT INTO sby_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kayi Yesu walabambila mukoshanyo uwu, “Kwalikuba muntu naumbi walikukute citondo ca mukuyu calikuba mulibala lya minyansa. Bumbi busuba walaya kucitondo kuya kubonako nkuyu, nsombi liya kushicanako. ");
INSERT INTO sby_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Lino walambila musebenshi eti, ‘Bona nibyaka bitatu nkanjisa kuno kuyanda nkuyu kumukuyu uyu, nsombi nkankute kucanapo. Lino citeme cilonongelenga cani bulongo’ ");
INSERT INTO sby_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nomba nendi walakumbuleti, ‘Mwami ulekeni kwacaka cino conka. Nindubambilile cena nekubika mboleshi. ");
INSERT INTO sby_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mpani nicikekate bisepo mwakali. Nsombi na cikabule kwikata mukaciteme.’” ");
INSERT INTO sby_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Lino pabusuba bumbi bwa Sabata, Yesu walikwiyisha mung'anda yakupaililamo. ");
INSERT INTO sby_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mung'anda umo mwalikuba mutukashi walikuba ne mishimu yaipa walapenga kwa byaka likumi ne bisanu ne bitatu. Walikwenda kali wakotama, nkalikucikosha kololoka nambi pang'ana. ");
INSERT INTO sby_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Lino Yesu mpwalabona mutukashi uyo walamwambileti, “Mutukashi, ulasungululwa kubulwashi bwakobe.” ");
INSERT INTO sby_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Lino Yesu walabika makasa akendi pali endiye, popelapo walololoka nekutatika kulumbaisha Lesa. ");
INSERT INTO sby_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Lino mukulene wa ng'anda ya kupaililamo walakalala cepa mpwalaboneti Yesu lashiliki muntu pa busuba bwa Sabata. Lino walambila bantu eti, “Kuli masuba asanu ne bumo ngotwelela kusebensa mbuli ncocalembwa mumilawo. Neco mwisenga kushilikwa mumasubayo, kufunyakowa pa busuba bwa Sabata Sobwe.” ");
INSERT INTO sby_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Lino Mwami Yesu walamukumbuleti, “Amwe mobantu omukute kwamba mbyomutenshi, niyani mulikoto wela kubula kucalwila musune nambi mbongolo yakendi ne kuya kwinwisha menshi pa busuba bwa Sabata? ");
INSERT INTO sby_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nomba uyo mutukashi mwana wa mumukowa wa Abulahamu uyo Satana ngwalasunga kwa byaka likumi ne bisanu ne bitatu, sena nkelela kusungululwa pa busuba bwa Sabata?” ");
INSERT INTO sby_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesu mpwalambeco balwani bakendi balanyumfwa nsoni, nsombi bantu bonse balasangalala pabintu byonse byaina bikankamanisha mbyalensa. ");
INSERT INTO sby_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu walepusheti, “Anu bwami bwa Lesa bulyeti cani? Nomba ngandibukoshanisha necani? ");
INSERT INTO sby_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Bwakoshana ne luseke lwa mastadi ulo muntu ndwalabyala mulibala mwakendi. Mpolwalamena nekukula, calaba citondo cinene kayi ne bikeni byalabambilamo bisangala mumisampi yaco.” ");
INSERT INTO sby_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kayi Yesu walepusheti, “Anu Bwami bwa Lesa ngandibukoshanisha necani? ");
INSERT INTO sby_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Bulyeti cikufufumusha shinkwa, ico mutukashi ncalasankanya ne bunga wakwana bikopo bitatu, kushikila byonse byalafutumuka.” ");
INSERT INTO sby_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu mpalikuba pabulwendo bwakuya ku Yelusalemu, walenda muminshi kaya kwiyisha. ");
INSERT INTO sby_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Lino umbi muntu walepusha Yesu eti, “Mwami, sena ni bang'ana beti bakapuluke?” Yesu walakumbuleti, ");
INSERT INTO sby_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Kamweleshani cangofu kwingila pacishinga cing'ana pakwinga ndamwambilingeti bantu bangi nibakeleshe kwingila, nsombi nteshi bakacikoshe. ");
INSERT INTO sby_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Lino mwine ng'anda nakanyamuke nekucala kucishinga. Lino amwe mwemana pansa nimukatatike kukonkosha ne kwambeti, ‘Kamutucalwilako.’ Nsombi nendi nakamukumbuleti, ‘Kandimwinshi nkomulafumini.’ ");
INSERT INTO sby_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Lino nimukatatike kwambeti, ‘Pasa twalikulya ne kunwa pamo nenjamwe kayi mwalikwiyisha muminshi yetu.’ ");
INSERT INTO sby_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nsombi nakamwambileti kandimwinshi nkomulafumininga, fumani apa mwense babwipishi. ");
INSERT INTO sby_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Lino nimukalile nekukokota meno, nimukabone Abulahamu ne Isaki ne Yakobo kayi ne bashinshimi bonse kabali mu Bwami bwa Lesa, nsombi amwe kamuli pansa. ");
INSERT INTO sby_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bantu nibakafume kucwe ne kumboshi ne kumusansa ne kunyika, kwisa kwikala nekulya mu Bwami bwa Lesa. ");
INSERT INTO sby_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Lino abo balikunyuma nibakabe kuntangu naboyo balikuntangu nibakabe kunyuma.” ");
INSERT INTO sby_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Pacindi ico Bafalisi bambi balesa kuli Yesu nekumwambileti, “Kamufumani kuno, mwenga kumusena umbi pakwinga Helode layandanga kumushina.” ");
INSERT INTO sby_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Nsombi Yesu walakumbuleti, “Kamuyani mumwambile uyo mwaba eti, ‘Ndafunyunga mishimu yaipa ne kushilika bantu lelo ne lilo. Lino pabusuba bwa butatu ninkapwishe incito yakame.’ ");
INSERT INTO sby_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Necikabeco ndelela kuba pa bulwendo lelo, ne lilo kayi ne busuba bwakonkapo, pakwinga nkacainapo mushinshimi kushinwa kumbi, nsombi ku Yelusalemu.” ");
INSERT INTO sby_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Obe Yelusalemu, Yelusalemu, weshikushina bashinshimi nekupwaya mabwe bantu abo Lesa mbwalatuma kuli njobe. Lingi ndalikuyanda kubunganya bantu mbuli ncoikute kwinsa inkuku pakufukatila twana twayo mumapapamino, nsombi obe walakana.” ");
INSERT INTO sby_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Neco ng'anda ya Lesa inene iyi nikabe matongo. Ndamwambilingeti nteshi mukambonepo kayi kushikila mukambeti, “Walelekwa uyo lesanga mulina lya Mwami Lesa.” ");
INSERT INTO sby_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nabumbi busuba bwa Sabata Yesu walakwiwa kuya kulya kung'anda ya mukulene wa Bafalisi. Popelapo Bafalisi bali kabamulangishisha. ");
INSERT INTO sby_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Lino pantangu pakendi Yesu palikuba muntu walikuba washimba mubili. ");
INSERT INTO sby_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Lino Yesu walepusha Bafalisi ne beshikwiyisha Milawo eti, “Sena Milawo ikute kusuminisha kushilika muntu pa busuba bwa Sabata nambi ne?” ");
INSERT INTO sby_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nsombi balo balamwenowa. Lino Yesu walamanta muntu uyo, wamushilika nekumwambileti koya. ");
INSERT INTO sby_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Popelapo Yesu walabepusheti, “Nomba nibani pakati penu. Na ng'ombe iwila mumukalo pa busuba bwa Sabata, sena nkela kwisabula pa cindico?” ");
INSERT INTO sby_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Lino balalilwa kumukumbula. ");
INSERT INTO sby_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu mpwalabona bantu balakwiwa kulya nendi balatatika kulisalila bipuna byabulemu, walabambila mukoshanisho eti, ");
INSERT INTO sby_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Na muntu umukuwa kubwinga, mutekalanga pacipuna ca bulemu, pakwinga uyo muntu lamukuwu inga kakute bambi bapita amwe ba bulemu. ");
INSERT INTO sby_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Neco uyo walamukuwa mwense mobabili nakese akamwambileti, kamufumani apa, pani cipuna ici kumuntu uyu, Lino nimukanyumfwe insoni mwakanyamuka kuya kwikala pa cipuma cabula bulemu. ");
INSERT INTO sby_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nomba na bamukuwa, kamuyani mwikale pabusena bwabula kuba bwabulemu kwambeti uyo mwine lamukuwu akamwambileti, ‘Kamwisani mwikalile pano, pa cipuna ca bulemu.’ Ici nicikakupe bulemu pamenso abantu bonse mbowalakwiwa nabo. ");
INSERT INTO sby_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Pakwinga muntu uliyense weshikulisumpula nakacepeshewe nsombi muntu weshikulicepesha nakasumpulwe.” ");
INSERT INTO sby_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Lino Yesu walambila Mufalisi walabakuweti, “Na mulakuwu bantu kwisakulya nabo cakulya ca munshi nambi ca mansailo, mutakuwa banenu, bakamukowa, ne bamakwenu nambi banobe babile, pakwinga naboyo nga bamukuwani, neco ngamutambulila limo cipo cenu. ");
INSERT INTO sby_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nsombi na ulabamba byakulya byakusekelela, kuwa bakandu ne balema kayi ne bampofu. ");
INSERT INTO sby_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Lino nukapewe colwe, pakwinga balo nkabela kucikonsha kumubweshela. Lesa nakamubweshele pabusuba ubo baswepa bakapunduka kubafu.” ");
INSERT INTO sby_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Muntu umbi palyabo Yesu mbwalikulyanabo, mpwalanyumfwa makani aya, walambila Yesu eti, “Walelekwa uyo eti akalye nabo pakusekelela mu Bwami bwa Lesa.” ");
INSERT INTO sby_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nendi Yesu walakumbuleti, “Kwalikuba muntu umbi walabamba malyalya kwambeti basekelele, ne kukuwa bantu bangi. ");
INSERT INTO sby_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Cindi camalyalya mpocalashika walatuma musebenshi wakendi kuya kubakuwa nekubambileti, kamwisani bintu byonse bilabambiwa. ");
INSERT INTO sby_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nsombi bonse balakwiwa balatalika kwamba bintu byalabatatisha. Mutanshi walambeti, ndaulu libala neco ndelela kuya kulibona. Bandekeleleko nteti njise.” ");
INSERT INTO sby_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Umbi walambeti, Ndaulu ng'ombe shakwana bipani bisanu, ndenga akushelesha, mundekeleleko nteti njise. ");
INSERT INTO sby_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Naumbi walambeti, Ame ndeba mutukashi lino lino neco nteshi njise. ");
INSERT INTO sby_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Lino musebenshi walabwelela ne kumwambila mwami wakendi byonse ibyo. Mwine ng'anda walakalala, lino walamwambila musebesheti, endesha, koya munshila shinene ne shing'ana sha mumushi ukuwe bakandu ne balema kayi ne bampofu wise nabo kuno. ");
INSERT INTO sby_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mpwalabwela musebenshi walambeti, mwami, ndenshi kwelena nencomulang'ambili, kayi busena mobucili. ");
INSERT INTO sby_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Lino mwami wakendi walakumbuleti, koya munshila ne mumikondo ya muminshi ubambile bantu cangofu eti bese kwambeti ng'anda yakame isule. ");
INSERT INTO sby_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ndamwambilingeti paliya nambi umo palyabo mbondalakuwa weshi alyeko malyalya akusekelela kwakame!” ");
INSERT INTO sby_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Likoto linene lya bantu lyalakonkela Yesu, lino walapindamuka ne kubambileti, ");
INSERT INTO sby_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Muntu uliyense layandanga kuba weshikwiya wakame welela kusuna ame kupita baishi ne banyina, nambi bakashendi ne bana, banse batukashi ne batuloba, kupita buyumi bwakendi. ");
INSERT INTO sby_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Muntu uliyense labulunga kulikana mwine ne kuba walimbambila kupenshewa, nkela kuba shikwiya wakame. ");
INSERT INTO sby_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Nomba niyani umo pali amwe ayandanga kwibaka ng'anda itali, sena nkakute kwikala panshi nekubona na ukute mali akwana bintu bikute kuyandika kwambeti apwishe ng'anda iyo? ");
INSERT INTO sby_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Pakwinga nalabulu kwinseco, ngacikonshyowa kubamba panshi, nekwalilwa kupwisha. Nomba bantu beshikubona ibi inga bamuseka. ");
INSERT INTO sby_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Nibakambeti, uyu muntu walatatika kwibaka ng'anda, nomba lalilwa kupwisha.” ");
INSERT INTO sby_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Nomba nimwami cini, wela pakuya kulwana ne mwami umbi, nkakute kwikala panshi nekuyeya cena? Ukute kuyeya kwambeti nibashilikali byulu makumi abili bela kulwana ne mwami usa umbi, uyo lesanga bela kucikonshya ni bashilikali byulu likumi limo. ");
INSERT INTO sby_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Neco na labono kwambeti nkela kucikonshya, ukute kutuma beshikumwimanina kwambeti be ngabasenge lumuno, mwami usa kacili kutali. ");
INSERT INTO sby_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Weco muntu uliyense labulunga kushiya bintu byonse mbyakute, nkela kuba weshikwiya wakame.” ");
INSERT INTO sby_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Mucele waina nomba na ulasambuluku ngamwinseconi kwambeti ube cena kayi? ");
INSERT INTO sby_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Uliyawa incito kubulongo nambi pa bufumba bwakubika mulibala bakute kutayowa. muntu ukute matwi anyumfwe!” ");
INSERT INTO sby_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Lino beshikusonkesha musonko ne bantu nabambi balikubula kukonka Milawo, balesa kwambeti banyumfwe mulumbe wa Yesu. ");
INSERT INTO sby_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Lino Bafalisi ne beshikwiyisha ba Milawo balatatika kudandaula ne kwambeti, “Uyu muntu latambulungeconi bantu babwipishi, nekulya nabo.” ");
INSERT INTO sby_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Lino Yesu walabambila mukoshanyo eti, ");
INSERT INTO sby_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Na umbi pali amwe kakute mbelele shili mwanda, lino imo itaika sena nkela kushiya mbelele shili makumi asanu ne ana ne shisanu ne shina ne kuya kulangaula kushikila wicana? ");
INSERT INTO sby_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Lino na layicana ukute kukondwa ne kwinyamuna pamafushi ");
INSERT INTO sby_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","nekwitwala kung'anda. Lino ukute kukuwa banendi ne beshikamukowa nekubambileti, katukondwani pamo pakwinga mbelele yakame yanga yataika ndaicana, ");
INSERT INTO sby_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ndamwambilingeti, nakoyo kwilu nikukabe kukondwa pamuntu umo wabwipishi lasanduku kubwipishi, kupita bantu bali makumi asanu ne ana ne basanu ne bana balulama batasuni kusanduka.” ");
INSERT INTO sby_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Na mutukashi umbi nkakute mali amasilifa likumi, na imo itaika ngawinseconi? Sena nte ukute kumunika lampi nekupyanga mung'anda yakendi nekulangaula cena monse kushikila wicana? ");
INSERT INTO sby_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Alicana ukute kukuwa banendi ne beshikamukowa nekubambileti, ‘Katukondwani pamo pakwinga lyali lyakame lyanga lyataika ndalicana.’” ");
INSERT INTO sby_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yesu walabambileti, “Ndamwambilinga ne kwilu encobakute kwinsa bangelo ba Lesa bakute kukondwa na muntu umo weshi kwinsa bwipishi lasanduku mubyaipa.” ");
INSERT INTO sby_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu kayi walabambileti, “Kwalikuba mutuloba naumbi walikukute bana batuloba babili. ");
INSERT INTO sby_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Lino kanike bantu walabambila baisheti, ‘Ta, kamumpani buboni mbomwela kunjabilako ame mumpele limo.’ Nabo bameshabo balabayabanya buboni bwabo. ");
INSERT INTO sby_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kapatana papita masuba angi, kanike bantu uyo walolisha buboni bwakendi nekumanta mali kuya pabulwendo kucishi ca kutali uko nkwalaya akononga mali akendi onse mubwikalo bwaipa. ");
INSERT INTO sby_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Mpwalapwisha mali akendi onse, mucishi umo mwalaba nsala inene, lino walatatika kupenga. ");
INSERT INTO sby_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Lino walaya kumuntu naumbi wa mucishi umo. Lino muntu uyo walamupa incito yakwembela ne kusanina nkumba. ");
INSERT INTO sby_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mutuloba uyo walatatika kukumbwa bufufu bwamusekese mboshali kulya nkumba. Nomba kuliya nambi muntu umo walikumupa byakulya.” ");
INSERT INTO sby_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Lino mpwalekalikana mano mumoyo wakendi walambeti, basebenshi bonse ba bata bakute byakulya bingi balekutunga, lino ame kuno ndayandanga kufwa kunsala. ");
INSERT INTO sby_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ndanyamukunga njenga kuli bata njengambeti, Ta, ndalepisha kuli Lesa ne kuli njamwe. ");
INSERT INTO sby_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nkandelela kukwiweti mwanenu, nsombi munsuminishe nsanduke musebenshi wenu.” ");
INSERT INTO sby_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Lino walanyamuka nekubwelela kuli baishi. “Nkacili patali baishi balamubona, lino bamunyumfwila inkumbo, ne kumukonka akumukumbata ne kumumyanguta mwakukondwa. ");
INSERT INTO sby_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mwana uyo walabambila baisheti, ta, ndalepisha kuli Lesa ne kuli amwe. Nkandelelela kukwiweti mwanenu. ");
INSERT INTO sby_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Nomba baishi balambila basebenshi babo eti, ‘Kamufwambanani mulete byakufwala byaina afwale. Mumufwalike likosa kumunwe ne nkwabilo kumyendo. ");
INSERT INTO sby_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Salaniponi ng'ombe yansuka inene mushine kwambeti tulye tukondwe. ");
INSERT INTO sby_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Pakwinga uyu mwaname wanga wafwa, lino laba muyumi kayi wanga wataika lino lacaniki.’ Pacindici balatatika kusekelela.” ");
INSERT INTO sby_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Pacindico mukulene bantu walikuba kulibala. Lino mpwalashika pepi ne ng'anda, walanyumfwa bantu bali kabembila ne kushana ne kulubisha. ");
INSERT INTO sby_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Walakuwa musebenshi umo nekumwipusheti, “cilenshikinga kuno nicani?” ");
INSERT INTO sby_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Musebenshi walakumbuleti, “Mukwenu lesa neco baiso bamushinini ng'ombe yansuka inene pakwinga lesa nkali muyumi.” ");
INSERT INTO sby_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mpwalanyumfweco popelapo walakalala kayi walakana nekwingila mung'anda. Nomba baishi balapula pansa kuya kumukombeleleti engile mung'anda. ");
INSERT INTO sby_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nendi walakumbula baishi eti, kamubonani! byaka kufula mbyondamusebensele eti ndemusha kayi ndiyawa kumwipishilapo nambi pang'ana nomba muliya kumpapo nambi kapongo konka kwambeti kondwepo nebaname. ");
INSERT INTO sby_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nsombi mwanenu uyu walononga buboni bwenu mubatukashi bapombo, mpwalesa kung'anda, mulamushinini ng'ombe yansuka! ");
INSERT INTO sby_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Baishi balamwambileti, “Omwaname, obe uli nenjame cindi conse kayi bintu byonse mbyonkute nibyakobe. ");
INSERT INTO sby_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nsombi lino katukondwa nekusekelela pakwinga kanike wakobe walikuba wafwa, lino nimuyumi, walikuba wataika, lino lacaniki.” ");
INSERT INTO sby_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu walabambila beshikwiya bakendi eti, Kwalikuba muntu mubile walikukute kapitawo weshi kubona buboni. Bantu balamwamba muntu uyo eti lonongonga buboni bwa mwami wakendi. ");
INSERT INTO sby_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Lino walakuwa kapitawo wabuboni nekumwipusheti, “Nomba nicani ncondanyufunga pali njobe? Mpandulwile sha bukapitawo bwakobe pakwinga nkowelela kuba kapitawo sobwe.” ");
INSERT INTO sby_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Lino kapitawo walatatika kuyeya mumoyo mwakendi eti, “Ninjiseconi mwami wakame layandanga kumfunya incito? Ndiya ngofu shakulima kayi kusenga kukutekumpa insoni. ");
INSERT INTO sby_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Lino nceti njinse nici, kwambeti bantu bakantambule mumandabo, ndakafuma incito.” ");
INSERT INTO sby_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Lino walatika kukuwa bonse balikukute nkongole ku mwami wakendi umo ne umo nekwipusha mutanshi eti, “Walakweleta shingaye kumwami wakame?” ");
INSERT INTO sby_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Neye walakumbuleti, “Ndalakweleta mingomo mwanda ya mafuta”. Neco kapitawo uyo walamwambileti, “Manta lipepa apo palembwa nkongole yakobe, ufwambane wikale panshi ulembepo eti, mingomo yakwana makumi asanu.” ");
INSERT INTO sby_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Lino walepusha umbi eti, “Nomba obe walakweleta shingaye?” Walakumbuleti, “Ndalakweleta masaka ali mwanda a maila.” Lino neye walamwambileti, “Manta Lipepa palembwa nkongole yakobe, Ulembepo masaka makumi asanu ne atatu.” ");
INSERT INTO sby_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Mwami wakendi uyo walalumbaisha kapitawo wa buboni wabula kushomeka pakucenjela kwakendi. Pakwinga bantu ba mucishi ca panshi pano nibasongo pa kubamba makani abo kupita bantu bali mu mumuni wa Lesa. ");
INSERT INTO sby_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesu walapitilisha kubambileti, “Ndamwambilinga kamulicanina banenu babuboni bwa mucishi cino kwambeti, buboni bwakapwa nibakamutambule mumanda amuyayaya. ");
INSERT INTO sby_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Muntu uliyense washomeka pabintu bing'ana, nakashomeke pa bintu bingi. Uyo wabula kushomeka pabintu bing'ana, nteshi akashomeke pabintu bingi. ");
INSERT INTO sby_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Lino na nkamwashomeka pabuboni bwa pacishi cino, nomba niyani eti akamushome nekumupani buboni bwancincine? ");
INSERT INTO sby_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na kamulimwabula kushomeka pabuboni bwa bantu bambi, nomba niyani eti akamupeni buboni bwelela kuba bwenu?” ");
INSERT INTO sby_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Kuliya musebenshi wela kusebensela bami babili, pakwinga ukute kupatapo umbi nekusuna umbi, nambi kunyumfwila umbi nekusula umbi. Anu ekwambeti nkamwela kusebensela Lesa ne buboni.” ");
INSERT INTO sby_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Bafalisi mpolabanyumfwa makani aya balatatika kushibuluka Yesu pakwinga balo balikusunisha mali. ");
INSERT INTO sby_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Nsombi Yesu walabambileti, “Amwe mukute kulibonesha kubantu eti mwalulama, necikabeco Lesa winshi myoyo yenu. Pakwinga bintu byonse bantu mbyobakute kwambeti byaina, nsombi kuli Lesa kuliya mobibelele.” ");
INSERT INTO sby_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Milawo Lesa njalapa Mose ne Maswi alalemba bashinshimi byali kusebensa cindi ca Yohane mubatishi. Kufuma pacindico Mulumbe Waina wa Bwami bwa Lesa ukute kukambaukwa, kayi ne bantu bangi baleleshenga ne ngofu kwambeti bengile mu Bwami ubu. ");
INSERT INTO sby_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nsombi capuba kwambeti kwilu necishi kupwa, kupita liswi limo lya Milawo kupwa ngofu. ");
INSERT INTO sby_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Muntu uliyense laleke mukashendi nekweba mukashi naumbi, lenshi bupombo. Neye uyo lebe mutukashi ngwalaleka munendi lenshinga bupombo”. ");
INSERT INTO sby_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Kwalikuba muntu mubile walikufwala byadula uyo walikulya cena lyonse. ");
INSERT INTO sby_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Lino kwalikuba muntu wapenga lina lyakendi walikuba Lazalo. Walikukute bilonda mubili wonse, walikusuna kona pa cishinga ca ng'anda ya muntu mubile uyo. ");
INSERT INTO sby_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lazalo walikaminina mate uto twakulya twalikulaka panshi pa tebulu ya muntu mubile uyo, naboyo bakabwa bali kabesa akumyanguta pabilonda byakendi. ");
INSERT INTO sby_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Muntu wapenga uyo walafwa, bangelo balamutwala kwilu mumakasa a Abulahamu. Muntu mubile uyo neye walafwa nekumufukila mumanda. ");
INSERT INTO sby_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Lino mubile uyo mpwalikupenga mumusena wa bafu, walalanga kwilu nekubona Lazalo kulubasu lwa Abulahamu nkali patali. ");
INSERT INTO sby_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Lino walolobesha eti, “Ta Abulahamu kamunyumfwilako inkumbo. Kamutumani Lazalo kwambeti abike cikumo cakendi mumenshi kwambeti atontoshe lulemi lwakame pakwinga ndashupiki mumulilo muno.” ");
INSERT INTO sby_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Lino Abulahamu walambeti, “Mwaname kwanuka mpowalikuba muyumi walatambula bintu byonse byaina, neye Lazalo walatambula bintu byeshikubaba. Lino neye kuno wakondwa, obe uli mumapensho anene. ");
INSERT INTO sby_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Kayi pakati petu nenjobe pali cisengu, cakwambeti kuliya muntu ulikuno wela kucikonsha kusabuka kwisa uko, nambi uli uko kwisa kuno.” ");
INSERT INTO sby_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Kufumapo mubile uyo walambeti, “Anu ndasengenga Ta, mutume Lazalo kung'anda ya bata. ");
INSERT INTO sby_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Pakwinga nkute bakwetu basanu. Enga abacenjeshe kwambeti naboyo batakesa kumusena wa mapensho kuno.” ");
INSERT INTO sby_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Nsombi Abulahamu walambeti, “abo bakute mabuku alalembwa ne Mose ne bashinshimi, kabanyumfwani byalembwamo.” ");
INSERT INTO sby_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Nendi walakumbuleti, sobwe ta Abulahamu, na umbi ufuma kubafu nekuyako, mpobela kusanduka kubwipishi bwabo. ");
INSERT INTO sby_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abulahamu walamwambileti, “na nkabanyumfwilinga Mabala alalembwa ne Mose ne bashinshimi nteshi bakanyumfwepo nambi umbi akapunduke kubafu.” ");
INSERT INTO sby_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu walambila beshikwiya bakendi eti, “Bintu bikute kulengesha muntu kwambeti aipishe nibikaboneke, nsombi mapensho nakabe pali bantu beshikubileta. ");
INSERT INTO sby_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nomba caina kwambeti muntu uyo asungwe ne libwe linene lya mwampelo munshingo ne kumuwala mu lwenje, kupita kulengesha umo wa bana bang'ana aba kwipisha.” ");
INSERT INTO sby_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Neco kamucenjelani! Na mukwenu lakwipishili, umukalalile, na lasenge kulekelelwa umulekelele. ");
INSERT INTO sby_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Na lakwipishili mankanda asanu ne abili pabusuba bumo, kayi mankanda onse ayo kesa kuli njobe nekwambeti, “Ndepishi,” Welela kumulekelela. ");
INSERT INTO sby_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Lino batumwa balambila Mwami eti, “Kamukonempesha lushomo lwetu.” ");
INSERT INTO sby_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Mwami Yesu walabakumbuleti, “Nemwabanga ne lushomo lulyeti luseke lwa masitadi, ngamucikonsha kwambila citondo eti, ‘Shukuka apo ulishimpike mumulonga, nacoyo ngacimunyumfwila.’ ” ");
INSERT INTO sby_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Nomba naumbi pakati penu kakute musebenshi shikulima mulibala nambi kwembela mbelele. Nomba sena akomboka ngomwambila eti, ‘Fwambana kwesa ulye cakulya’ ");
INSERT INTO sby_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Sobwe nkela kwinseco! Nsombi ngomwambileti, ‘Kontelekela cakulya, na upwishe ufwale cena nekundetela byakulya, lino ndapwisha nenjobe mpoti ulye ne kunwa.’ ");
INSERT INTO sby_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Lino sena ngomulumba musebenshi pakwinga lenshi ncowamwambila? ");
INSERT INTO sby_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Copeleco nenjamwe, na mulenshi ncomwalambilwa mwelela kwambeti, ‘To basebenshi babula kwelela kutambula kantu. Pakwinga tulenshi mulimo wetu!’ ” ");
INSERT INTO sby_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu mpwalikuya ku Yelusalemu, walapita panyinsa ya Samaliya ne Galileya. ");
INSERT INTO sby_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Mpwalashika mumunshi naumbi, beshimankuntu bali likumi balamukumanya ne kwimana pataliko. ");
INSERT INTO sby_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Lino balobelesheti, “Amwe Yesu, Nkambo kamutunyumfwilako nkumbo!” ");
INSERT INTO sby_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu mpwalababona walabambileti, “Kamuyani ku beshimilumbo baye bamuboneti mulaba cena.” Lino mpobalikuya kwenda munshila, balaba cena. ");
INSERT INTO sby_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Lino umo pakati pabo mpwalaboneti laba cena, walabwelela kuli Yesu nkaya akulumbaisha Lesa ne liswi lyapelu. ");
INSERT INTO sby_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Lino mpwalashika kuli Yesu walafukama kuntangu kwakendi ne kumulumba. Shimankuntu uyu walikuba mu Samaliya. ");
INSERT INTO sby_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Lino Yesu walambeti, “Sena bashilikwa nkabanga likumi? Nomba bambi basanu ne bana balikupe? ");
INSERT INTO sby_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nomba nicani kulesowa muswamashi enka kwisa kulumbaisha Lesa? ");
INSERT INTO sby_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kufumapo, Yesu walambila shimankuntu uyo, pakwinga wanshoma nyamuka koya, Lushomo lwakobe lulakushiliki.” ");
INSERT INTO sby_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Bafalisi bambi balepusha Yesu eti, “Bwami bwa Lesa nibukese lilyoni?” Yesu walabakumbuleti, “Bwami bwa Lesa, nteshi bukese mwakubonekela ne menso sobwe. ");
INSERT INTO sby_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kuliya weshi akambeti, ‘Nibuno bulikuno!’ Nambi eti, ‘Nibusa kusa!’ Pakwinga Bwami bwa Lesa buli pakati penu.” ");
INSERT INTO sby_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Lino walakumbula beshikwiya bakendi eti, “Nicikashike cindi mpoti mukayande kubona Mwana Muntu mubusuba bumo, nomba nteshi mukabubonepo sobwe. ");
INSERT INTO sby_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nikukabe bantu beshi bakamwambileti, ‘Kamubona nte busa bulikusa, nambi eti, ubu bulipano, mutakayako nambi kubakonkela sobwe.’ ");
INSERT INTO sby_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Pakwinga mbuli kubyasha ncokukute kucilingana mwilu nekubonekela kumbasu shonse, enceti kukabe pabusuba bwakwisa Mwana Muntu. ");
INSERT INTO sby_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nsombi welela kutanguna kupenshewa, nekukanwa ne bantu ba cino cindi. ");
INSERT INTO sby_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Mbuli ncocalikuba mumasuba a Nowa encoti cikabe mumasuba a Mwana Muntu. ");
INSERT INTO sby_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mucindico bantu bali kabalya, ne kunwa, kweba kayi ne kwebwa kushikila busuba Nowa mbwalengila mubwato. Lino muyoba unene walesa nekubononga bonse. ");
INSERT INTO sby_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Nicikabeti ncocalikuba mucindi ca Loti, bantu bali kabalya ne kunwa, kula ne kulisha, kubyala ne kwibaka manda. ");
INSERT INTO sby_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nsombi busuba Loti mpwalafuma mu Sodomu, Lesa walalasha mulilo wa salufa walalaka kwilu nekubononga bonse. ");
INSERT INTO sby_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nicikabe copeleco pabusuba Mwana Muntu mpoti akese. ");
INSERT INTO sby_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Busuba ubo, uyo eti akabenga paciluli ca ng'anda atakaseluketi amante bintu byakendi mung'anda, neye uyo eti akabenga mulibala atakabwelela kung'anda. ");
INSERT INTO sby_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kamwanukani muka Loti! ");
INSERT INTO sby_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Uyo layandanga kupulusha buyumi bwakendi, nakabutaye. Nsombi uyo latayanga buyumi bwakendi pacebo cakame, nakabupulushe. ");
INSERT INTO sby_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ndamwambilinga pabusuba ubo mashiku, bantu babili nibakabenga bona pabulili bumo, umo nakamantwe, umbi nakashale. ");
INSERT INTO sby_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Batukashi babili nibakapelenga pantu pamo umo nakamantwe, umbi nakashale. ");
INSERT INTO sby_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Bantu babili nibakabenga mulibala, nsombi umo nakamantwe, umbi nakashale.” ");
INSERT INTO sby_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Beshikwiya balamwipusheti, “Mwami, nikupeyo nkoti bikenshikile ibi?” Yesu walakumbuleti, “Uko kulafwili cintu nawoyo makubi akute kubungana kopeloko.” ");
INSERT INTO sby_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Lino Yesu walabambila beshikwiya bakendi mukoshano, pakuyanda kubeyisha kwambeti bapailenga lyonse kwakubula kubwelela kunyuma. ");
INSERT INTO sby_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Walambeti, “Kwalikuba mubeteshi mumunshi umbi walikubula kutina Lesa nambi kulemeka muntu. ");
INSERT INTO sby_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kwalikuba mukalubingi mutukashi mumunshi wopeloyo walikaya kuli shikubeteka ne kumusengeti, ‘Munyamfweko pa mulandu ngonkute ku mulwani wakame.’ ");
INSERT INTO sby_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Masuba alafula mubeteshi kakanowa, nsombi panyuma pakendi walayeya mwineti, necikaba kwambeti nkantini Lesa nambi kulemeka muntu, ");
INSERT INTO sby_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pakwinga mukalubingi uyu landemeshe kunjobekela, nindimubetekele mulandu wakendi, kwambeti ngaundemesha kwisa kuno!” ");
INSERT INTO sby_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Lino Mwami walambeti, “Nte mulanyumfu maswi amubeteshi wabula kululama usa. ");
INSERT INTO sby_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Sena Lesa nteshi akabetekeshe mulandu wa balulama bakendi abo balamusengenga munshi ne mashiku? Sena nakalilwe kubanyamfwa? ");
INSERT INTO sby_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ndamwambilingeti nakafwambane kubabetekela mulandu wabo. Sena pakwisa Mwana Muntu nakacane bantu bakute lushomo panshi pano?” ");
INSERT INTO sby_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Lino Yesu walamba mukoshano umbi kulyabo bali kabayeyeti balulama kupita bonse nekunyansha banabo. ");
INSERT INTO sby_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Walambeti, “Kwalikuba bantu babili balaya akupaila ku Ng'anda ya Lesa. Umbi walikuba Mufalisi naumbi walikuba weshimisonko. ");
INSERT INTO sby_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Lino Mufalisi walanyamuka nekupaileti, ndamulumbunga obe Lesa, pakwinga ame nkandipo eti bantu nabambi bonse. Nabo nibantu babula kululama kayi ni bapombo. Kayi ndalumbu pakwinga kandipo eti uyu weshi kusonkesha musonko uyu. ");
INSERT INTO sby_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ndalikanishinga kulya mankanda abili munsondo, kayi nkute kubenga calikumi pabintu byonse mbyonkute kucana. ");
INSERT INTO sby_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Nsombi weshikusonkesha musonko usa walemana patali, liya kulangapo kwilu. Nsombi walikalyuma pantiti nekwambeti, Lesa, kamunyumfwilako inkumbo ame ndemwipishi.” ");
INSERT INTO sby_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesu walabambileti, “Cancine ncine, weshimusonko walabwelela kucomwabo kali walulama pamenso a Lesa, mu Falisi neye liya. Pakwinga muntu uliyense weshi kulisumpula nakacepeshewe, nomba muntu weshi kulicepesha nakasumpulwe.” ");
INSERT INTO sby_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bantu nabambi balaleta bana bang'ana kuli Yesu kwambeti abike makasa akendi pabana nekubaleleka. Beshikwiya bakendi mpobalaboneco balabakalalila bantu abo balaleta bana. ");
INSERT INTO sby_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nsombi Yesu walakuwa bana nekwambeti. “Kamulekani bana bang'ana bese kuli njame, mutabakanishanga, pakwinga Bwami bwa Lesa ni bwa bantu balyeti bana aba. ");
INSERT INTO sby_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ndamwambilinga cakubingeti uyo labulunga kutambula Bwami Bwa Lesa eti mwana, cakubinga nteshi akengilemo.” ");
INSERT INTO sby_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mukulene wa Bayuda naumbi walepusha Yesu eti. “Bashikwiyisha baina, nomba ndelelela kwinseconi kwambeti nkatambule buyumi butapu?” ");
INSERT INTO sby_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu walepusheti, “Nomba nicani ncolambilico kwambeti ndaina? Kuliya muntu waina, nsombi Lesa enka. ");
INSERT INTO sby_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Milawo uyinshi yeshi kwambeti, ‘Utensa bulale, utashina, kotaiba, utapa bukamboni bwabwepeshi, lemeka baiso ne banyoko.’” ");
INSERT INTO sby_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Muntu uyo walakumbuleti, “Iyi Milawo yonse nkute kwikonka kufuma kubutwanike bwakame.” ");
INSERT INTO sby_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu mpwalanyumfweco, walamwambileti, “Kulashalowa cintu cimo ncowelela kwinsa. Koya ulishe byonse mbyokute, mali upe bapenga, lino nukabe nebuboni kwilu. Wenseco, wise unkonkele.” ");
INSERT INTO sby_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nsombi muntu usa mpwalanyumfweco, walongumana pakwinga walikuba ne mubile bwingi. ");
INSERT INTO sby_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu mpwalabona, kungumana kwa muntu usa walambeti, “Cayuma kwambeti bantu babile bakengile mu Bwami bwa Lesa. ");
INSERT INTO sby_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Capuba kwambeti ngamila ingile mukamulyango ka nyeleti kupita muntu mubile kwingila mu Bwami bwa Lesa.” ");
INSERT INTO sby_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bantu balanyumfwa makani aya balepusheti, “Nomba niyani eti akapuluke?” ");
INSERT INTO sby_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu walakumbuleti, “Ibi bintu bitakonsheke nebantu, bikute kukonsheka ne Lesa.” ");
INSERT INTO sby_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Lino Petulo walambeti, “Kamubona! Afwe twalashiya manda etu nekukonkela njamwe.” ");
INSERT INTO sby_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu walakumbuleti, “Ndamwambilinga cakubinga paliya muntu walashiya ng'anda, nambi mukashendi nambi bamakwabo nambi bashali bakendi nambi bana bakendi pacebo ca Bwami bwa Lesa, ");
INSERT INTO sby_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","eti akabule kutambula bintu bingi pacino cindi, kayi mucindi cilesanga nakatambule buyumi butapu.” ");
INSERT INTO sby_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu walamanta beshikwiya bakendi bali likumi ne babili kuya palubasu nekubambileti, “Tulenga ku Yelusalemu uko byonse byalalemba bashinshimi pa Mwana Muntu nkoti bikenshikile. ");
INSERT INTO sby_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Pakwinga Mwana Muntu nakatwalwe mumakasa abantu bakunsa abo beshi bakamuwele, kumutukana, nekumusankila mata. ");
INSERT INTO sby_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Nibakamukwipe nekumushina, nsombi pabusuba bwabutatu nakapundushiwe kubafu.” ");
INSERT INTO sby_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Beshikwiya bakendi baliya kunyumfwishisha pamakani ayo. Maswi aya baliya kwanyumfwishisha pakwinga alikuba asolama kuli endibo, neco baliya kwinshiba ncali kwamba. ");
INSERT INTO sby_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu mpwalashika pepi ne Yeliko walacana mpofu kali wekala mumbali mwa nshila, kasengelela. ");
INSERT INTO sby_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Lino mpofu uyo mpwalanyumfwa bantu bangi kabapita munshileyo, walepusheti, “Nicani cilenshikinga?” ");
INSERT INTO sby_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bantu balamwambileti, “Ni Yesu wa ku Nasaleti lapitinga.” ");
INSERT INTO sby_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Lino walolobesheti, “Yesu mwana wa Dafeti konyumfwilako inkumbo!” ");
INSERT INTO sby_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Lino bantu balikuba kutangu balamukalilila nekumwambileti mwena. Nsombi nendi walapitilisha kolobesheti, “Mwanendi Dafeti, konyumfwilako inkumbo!” ");
INSERT INTO sby_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Neye Yesu walemana ne kwambila bantu eti bamulete kuli endiye. Mpwalashika pepi Yesu walamwipusheti, ");
INSERT INTO sby_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","nicani ncolandangeti nkwinshile? Neye walamukumbuleti, “Mwami, ndayandanga kwambeti ntatike kubona kayi.” ");
INSERT INTO sby_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Lino Yesu walamwambileti, “Tatika kubona, pakwinga ulanshomo, lushomo lwakobe lulakushiliki.” ");
INSERT INTO sby_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Pacindi copeleco walatatika kubona. Lino walakonkela Yesu nkaya kulumbaisha Lesa. Bantu bonse mpobalabona calenshika naboyo balalalumbaisha Lesa. ");
INSERT INTO sby_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu walengila mu Yeliko, nekupitilila. ");
INSERT INTO sby_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mu Yeliko mopelomo mwalikuba muntu wali kukwiweti Zakeyo. Walikuba shikusonkesha misonko mukulene, kayi walikuba mubile. ");
INSERT INTO sby_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Walikuyandishisha kubona Yesu ncabele nomba walikuba mufupi, walalilwa kumubona pakwinga bantu balafulisha. ");
INSERT INTO sby_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Neco walafwambila kuntangu ne kutanta mu citondo ca mukuyu kwambeti amubone, pakwinga Yesu empalikupitila popelapo. ");
INSERT INTO sby_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu mpwalashika pamusenapo walalanga kwilu nekumwambileti, “Zakeyo, fwambana seluka pakwinga ndelela kuya kwikala kung'anda yakobe lelo.” ");
INSERT INTO sby_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Lino Zakeyo walaseluka cakufwambana nekutambula Yesu mwakukondwa. ");
INSERT INTO sby_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Lino bantu bonse balabonako, balatatika kudandaula ne kwambeti, “Kamubonani muntu uyu lenga kwikala kung'anda ya muntu mwipishi.” ");
INSERT INTO sby_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nomba Zakeyo walanyamuka nekwambila Mwami eti, “Mwami,kamubonani, ninkape buboni bwakame kupa bapenshi. Na ndalamanta kantu kumuntu munshila yabula kwelela, ndimubweshele mankanda ana.” ");
INSERT INTO sby_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu walamwambileti, “Lelo kupuluka kulesa mung'anda ino, pakwinga muntu uyu neye nimwanendi Abulahamu. ");
INSERT INTO sby_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Neco Mwana Muntu walesa kuyandaula nekupulusha bataika.” ");
INSERT INTO sby_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Bantu kabacinyumfwa mbyalikwamba Yesu,walapitilisha kayi kubambila mukoshano pakwinga balashika pepi ku Yelusalemu. Nomba bantu bali kabayeyeti Bwami bwa Lesa buli pepi kwisa. ");
INSERT INTO sby_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Lino walambeti, “Kwalikuba muntu, walikuba walemekwa uyo walaya kucishi ca kutali kuya kupewa bwami nekubwelela kayi. ");
INSERT INTO sby_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Katanaya walakuwa basebenshi bakendi nekupa mali a golide likumi ku musebenshi umo ne umo” Nekubambileti, “kamwinsanga makwebo mpaka nkabwele.” ");
INSERT INTO sby_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Lino bantu mbwalikwikala nabo mucishi umo nkabali kumuyanda, neco balatuma ntumwi kuya kucishico akwambeti, “Afwe nkatulayandanga muntu uyo kuba mwami wetu.” ");
INSERT INTO sby_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Necikabeco muntu uyo walaya kupewa bwami busa, lino mpwalabwela kwabo, walakuwa basebenshi bakendi abo mbwalapa mali kwambeti,bamwambile bwili mbwacanapo umo ne umo.” ");
INSERT INTO sby_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Lino musebenshi mutanshi walesa walambeti, “Nkambo pamali ngomwalampa ndacaninipo bwili bwa mali ali likumi.” ");
INSERT INTO sby_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Lino mwami wakendi walamwambileti, “Ulenshi cena, Omusebenshi waina! Pakwinga walashomeka mubintu bing'ana nube weshikwendelesha minshi ili likumi.” ");
INSERT INTO sby_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Neye musebenshi wabubili walesa walambeti, “Mwami pamali asanu ngomwalampa ndacaninipo bwili bwa mali ali asanu.” ");
INSERT INTO sby_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Mwami walamwambileti, “Obe nube weshikwendelesha minshi isanu.” ");
INSERT INTO sby_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Lino musebenshi naumbi walesa walambeti, “Mwami, mali enu ndalasunga pakakwisa. ");
INSERT INTO sby_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ndalatina pakwinga mobakalu, mukute kutambula byabula byenu nekutebula mbyomwabula kubyala.” ");
INSERT INTO sby_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Mwami wakendi walakumbuleti, “Obe musebenshi waipa! Lino ninkutoteke kwelana ne maswi ngolamba. Ucishi kwambeti ndemukalu, nkute kumanta byabula byakame nekutebula mpondabula kubyala. ");
INSERT INTO sby_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Nomba uliya kubikila cani ku banki mali akame, kwambeti pakubwelela ncane bwili?” ");
INSERT INTO sby_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Lino walambila balikubapo eti, ‘Mulamuneni mali ayo mupe ukute mali likumi.’ ");
INSERT INTO sby_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Balo balambeti, ‘Mwami, uyo ukute kendi mali ali likumi.’ ");
INSERT INTO sby_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nsombi mwami walakumbuleti, ndamwambilinga ukute kantu nakabikilwepo nabimbi, nsombi uyo ukute kang'ana nibakamunyongomone nako konse kankute. ");
INSERT INTO sby_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Lino balwani bakame abo bali kuyandeti ame ntaba mwami wabo, kamubaleta kuno mubashine kambonako!” ");
INSERT INTO sby_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu mpwalapwisha kwambeco, walabatangunina kuya ku Yelusalemu. ");
INSERT INTO sby_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Mpwalashika pepi ne minshi ya Betifagi ne Betaniya pepi ne mulundu wa maolifi walatuma beshikwiya bakendi babili, ");
INSERT INTO sby_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Nekubambileti, “Kamuyani mumunshi usa ngomulabononga. Mwashika, nimucane mwana wambongolo kali wasungwa uyo utana utantwapo kendi ne bantu, muye mumusungulule, mumulete kuno. ");
INSERT INTO sby_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Na umbi muntu amwipusheti, ‘Mulamusungulilinga cani’ Mumwambileti, ‘Mwami ukute nendi incito.’” ");
INSERT INTO sby_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nicakubinga beshikwiya babili basa balaya kucana mbuli ncalabamba Yesu. ");
INSERT INTO sby_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Mpobali kusungulula mbongolo, bene balepusheti, “Nomba mulamusungulwilinga cani?” ");
INSERT INTO sby_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nabo balakumbuleti, “Mwami ukute nendi incito.” ");
INSERT INTO sby_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Lino balatwala mbongolo kuli Yesu, nekutatika kuyansa byakufwala byabo pelu nekumutantikapo Yesu. ");
INSERT INTO sby_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Lino Yesu mpwalikuya kali watanta mbongolo, bantu balayansa byakufwala byabo munshila kulesha bulemu kulyendiye. ");
INSERT INTO sby_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Mpwalashika pepi neku Yelusalemu mwinshi mwa mulundu wa maolifi, likoto linene lya beshikwiya bali kabamukonkela balatatika kukondwa. Kayi balumbaisha Lesa ne maswi a pelu pacebo ca incito ya ngofu njobalabona. ");
INSERT INTO sby_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Balambeti, “Walelekwa Mwami uyo lesanga mulina lya Lesa. Lumuno kwilu ne bulemu bube kuli Lesa.” ");
INSERT INTO sby_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Lino Bafalisi nabambi balikuba mulikoto balambila Yesu eti, “Bashikwiyisha, kamwambilani beshikwiya benu bamwene.” ");
INSERT INTO sby_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu walakumbuleti, “Ndamwambilinga na aba bamwene, mabwe nawo nawolobeshe.” ");
INSERT INTO sby_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Lino Yesu mpwalashika pepi nekubona Yelusalemu, walalila. ");
INSERT INTO sby_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Walambeti, “Na obe newalenshiba lelo, bintu byeshikuleta lumuno! Nsombi nkobishi pakwinga menso akobe nkela kubibona. ");
INSERT INTO sby_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Necikabeco nicikashike cindi balwani bakobe mpoti bakakushinguluke nekukushinkila konse konse. ");
INSERT INTO sby_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nibakakumwayaule nekushina bantu bakobe bonse. Nteshi bakashiye libwe pelu palinendi, pakwinga uliyawa kwishiba cindi Lesa ncalesa akukupulusha.” ");
INSERT INTO sby_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu walengila mu Ng'anda ya Lesa nekutatika kutandanyamo abo bali kabolisha mukati mulubuwa lwa Ng'anda ya Lesa, ");
INSERT INTO sby_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","walabambileti, “Calembwa Mumabala a Lesa kwambeti, ‘Ng'anda yakame nikakwiweti Ng'anda yakupaililamo.’ Nsombi amwe mulaisandulu kuba ng'anda mwakuyubila bakapondo!” ");
INSERT INTO sby_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Lino Yesu walikeyisha lyonse mu Ng'anda ya Lesa. Nomba bamakulene beshimilumbo, beshikwiyisha Milawo ne batangunishi ba Bayuda balikuyanda kumushina, ");
INSERT INTO sby_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Lino balabula cakwinsa pakwinga bantu bonse balikuba nendi cindi conse kwambeti banyumfwe maswi akendi. ");
INSERT INTO sby_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nabumbi busuba Yesu mpwalikwiyisha nekukambauka Mulumbe Waina mu Ng'anda ya Lesa, bamakulene beshimilumbo, beshikwiyisha Milawo kayi ne bamakulene ba Bayuda balesa. ");
INSERT INTO sby_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Balepusheti, “Kotwambila, nomba ningofucini nshokute pakwinsa bintu ibi? Wakupa ngofu shakwinsa ibi bintu niyani?” ");
INSERT INTO sby_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu walabakumbuleti, “Nenjame ndamwipushunga mwipusho umo. Kamungambilani, ");
INSERT INTO sby_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Nomba niyani walapa Yohane ngofu shakubatisha? Sena ni Lesa nambi nibantu?” ");
INSERT INTO sby_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nabo balatatika kwipushana bonka eti, “Na twambeti, ni Lesa, nendi natwipusheti, ‘Nomba nicani muliya kumushoma? ");
INSERT INTO sby_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Lino na twambeti, nibantu, bantu bonse nibatuwale mabwe pakwinga bacinsheti Yohane walikuba mushinshimi.” ");
INSERT INTO sby_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Neco balakumbuleti, “Nkatucinshi na walashifunya kupeyo.” ");
INSERT INTO sby_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Lino Yesu walabakumbuleti, “Nenjame anu nteshi ndimwambile uyo walampa ngofu shakwinsa bintu ibi.” ");
INSERT INTO sby_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Lino Yesu walapitilisha kubambila bantu mukoshanyo eti, Kwalikuba muntu walalima libala lyaminyansa ne kulibwelekesha balimi, lino walaya pabulwendo bwa kucishi nacimbi, uko nkwalekala cindi citali. ");
INSERT INTO sby_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Mpocalashika cindi cakutebula bisepo, muntu uyo, walatuma musebenshi wakendi kubalimi abo kwambeti bamupeko bisepo byamulibala lyakendi. Nsombi balimi abo balekata musebenshi uyo nekumuma nekumutandanya kwabula kumupapo kantu. ");
INSERT INTO sby_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mwine libala walatumako naumbi musebenshi. Neye balamuma, ne kumusebanya, kayi nekumutandanya kwakubula kantu mumakasa. ");
INSERT INTO sby_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Lino walatumako naumbi wabutatu, nsombi neye balamupwayaula nekumutaila kunsa. ");
INSERT INTO sby_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Lino mwine libala uyo walambeti, “Ninjiseconi lino? Anu nintumeko mwaname ngonsunishi mpani nendi nibenga bamupe bulemu.” ");
INSERT INTO sby_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Nsombi balimi abo mpobalamubona, balatatika kwambilaneti, “Uyu endiye weshi akapyane buboni bonse, katumushina kwambeti buboni bonse bukabe bwetu.” ");
INSERT INTO sby_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Neco balamukwelela pansa pa libala nekumushina. Lino Yesu walabepusheti, “Nomba nicani nceshi akense mwine libala kubalimi abo? ");
INSERT INTO sby_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nakese akubashina balimi abo nekupa bambi libala ilyo.” Bantu basa mpobalanyumfweco balambeti, “Citakenshika.” ");
INSERT INTO sby_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesu walabalangishisha nekubepusheti, lino malembo ayo akute kwamba cani? “Libwe ilyo ndyobalakana beshikwibaka, lyalaba elibwe lya pakona pa ng'anda lyayandika. ");
INSERT INTO sby_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Muntu uliyense weshi akawile pa libwe ili nakatyokauke. Nsombi uyo weshi likamulakile, nakasansauke.” ");
INSERT INTO sby_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Beshikwiyisha Milawo ne bamakulene beshimilumbo bali kuyanda kwikata Yesu pacindi copeleco pakwinga balenshibeti Yesu walikwamba endibo mumukoshanyo uyo. Nsombi balatina bantu balikubapo. ");
INSERT INTO sby_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Neco nabo balikabalangaula cindi caina, balatuma bantu kwambeti bamweleshe, palikulibonesheti balulama mung'ambilo yabo kwambeti bamuteye kose mukwamba, kwambeti benga bamubepeshele kuli bendeleshi, pakwinga neye walikukute ngofu ne bwendeleshi bonse. ");
INSERT INTO sby_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Bantu abo balepusha Yesu eti, “Bashikwiyisha, tucinshi kwambeti mukute kwamba ne kwiyisha byalulama. Nkamukute kulanga eti uyu niyani. Nsombi mukute kwiyisha Milawo ya Lesa cancine ncine. ");
INSERT INTO sby_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kamutwambila, sena Milawo ya Lesa yasuminisha kubenga musonko ku mwami waku Loma, nambi nkayasuminisha?” ");
INSERT INTO sby_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Nomba Yesu walenshiba miyeyo yabo yaipa walabambileti, ");
INSERT INTO sby_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Kamundesha mali, nomba cinso ne lina lilipo nilyabani?” Balakumbuleti, “Byonse nibya mwami waku Loma.” ");
INSERT INTO sby_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Lino neye walakumbuleti, “Kamubengani ku mwami waku Loma bintu byakendi, Neco neye Lesa mupeni bintu byakendi.” ");
INSERT INTO sby_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Neco balalilwa kucana mulandu mulibyo mbyalamba pamenso abantu. Lino balapwilwa mano pakukumbula kwa Yesu, balamwenowa tonto. ");
INSERT INTO sby_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Basaduki nabambi balesa kuli Yesu. Bantu aba bali kwambeti bantu bafwa nteshi bakapundukepo. Balamwipusha Yesu eti, ");
INSERT INTO sby_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Bashikwiyisha, Mose watulembela Milawo yakwambeti, Na muntu lafu, nekushiya mukashendi, kwakubula mwana, mukwabo welela kumweba mukalubingi kwambeti asemenemo bana bamukwabo uyo walafwa.” ");
INSERT INTO sby_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Lino kwalikuba batuloba basanu ne babili pamukowa, mukulene bantu waleba mukashi, nsombi walafwa katana asemenamo mwana. ");
INSERT INTO sby_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Neye wabubili walamupyana mukashi nomba neye walafwa katana asemenamo mwana, ");
INSERT INTO sby_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Wabutatu walamupyana neye walafwa katana asemenamo mwana. Lino bonse basa basanu ne babili balapwa kufwa kwakubula kusemenamo bana mumutukashi uyo. ");
INSERT INTO sby_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kumapwilisho, mukashi uyo walafwa neye. ");
INSERT INTO sby_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","“Lino pabusuba bwakupunduka kubafu, mukashi uyo nakabe muka bani? Pakwinga bonse bamukowa basanu ne babili balikuba balamwebepo.” ");
INSERT INTO sby_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu walakumbuleti, “Bantu bacino cindi bakute kweba nekwebwa. ");
INSERT INTO sby_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Nsombi abo beti bakapundushiwe kubafu nekwikala mubuyumi bulesanga, nteshi bakebanenga. ");
INSERT INTO sby_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Nabo nibakekalengeti bangelo, kayi nteshi bakafwepo. Balo nibakabe bana ba Lesa pakwinga balapunduku kubafu. ");
INSERT INTO sby_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nomba pamakani akupunduka kubafu, neye Mose walambapo, pamakani a cifukusa cisa calikubangila mulilo, pakwinga Mwami walambeti, ‘Ni Lesa wa Abulahamu ni Lesa wa Isaki kayi ni Lesa wa Yakobo.’ ");
INSERT INTO sby_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Anu ekwambeti nte Lesa wa bantu bafwa, nsombi Lesa ni Lesa wabantu bayumi, pakwinga pamenso akendi bantu bonse nibayumi.” ");
INSERT INTO sby_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Beshikwiyisha Milawo nabambi balakumbuleti, “Bashikwiyisha mulamba cena” ");
INSERT INTO sby_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Neco baliya kuyanda kumwipushapo Yesu mipusho naimbi. ");
INSERT INTO sby_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu walabepusheti, “nipacebo cini bantu bakute kwambeti Mupulushi Walaiwa nimwanendi Dafeti?” ");
INSERT INTO sby_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Pakwinga Dafeti mwine mulibuku lya kutembaula walambeti, “Mwami walambila Mwami wakame eti, Ikala kulikasa lyakame lyakululyo ");
INSERT INTO sby_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kushikila nkasandule balwani bakobe, bakabe pakulyata myendo yakobe.” ");
INSERT INTO sby_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Na Dafeti mwine walamukuweti, Mwami, nomba ngobeconi mwanendi?” ");
INSERT INTO sby_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Bantu bonse mpobalikunyumfwa mbyalikwamba Yesu, nendi walabambila beshikwiya bakendi eti, ");
INSERT INTO sby_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Kamucenjelani ne beshikwiyisha Milawo. Nabo basuni kwendana kabalibafwala minganjo itali, kwambeti bantu babapenga mitende yabulemu mumisena yamakwebo. Basuni kwikala pabipuna byabulemu mung'anda yakupaililamo ne mumisena yamalyalya. ");
INSERT INTO sby_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nomba ebakute kulamuna manda bamukalubingi, ne kupaila mipailo itali itali kwambeti bantu bababone. Cakubinga Lesa nakabape mulandu kupita bantu nabambi balabulunga kwinseco.” ");
INSERT INTO sby_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu walalangishisha, walabona bantu babile kababika bipo byabo mucakubikamo bipo byamali mu Ng'anda ya Lesa. ");
INSERT INTO sby_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Walabona mutukashi mukalubingi kabikamo tumali tubili. ");
INSERT INTO sby_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Lino Yesu walambeti, “Ndamwambilinga cakubinga uyu mukalubingi wapenga labikimo bupe bwapitapo bambi bonse. ");
INSERT INTO sby_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Pakwinga bonse aba, balafunyu pa mali angi ngobakute, nsombi neye mubupenshi bwakendi labikimo mali onse ngakutenga mung'anda yakendi.” ");
INSERT INTO sby_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Beshikwiya nabambi bali kabamba pamakani a Ng'anda ya Lesa eti balaibaka ne mabwe eshikuboneka cena, kayi nebipo byakutwala kuli Lesa. Lino Yesu walambeti, ");
INSERT INTO sby_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ibi byonse mbyomulabononga, nicikashike cindi mpoti kukabule libwe nambi limo lyeti likashale palibwe linendi, mabwe onse nakamwayaulwe.” ");
INSERT INTO sby_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Lino beshikwiya balepusha Yesu eti, “Bashikwiyisha, nomba ibi nibikenshike lilyoni? Kayi nitukenshibile kucani eti bintu byonse ibi bili pepi kwinshika?” ");
INSERT INTO sby_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu walambeti, “Kamucenjelani kwambeti kutakaba muntu naba umo eti akamubepe. Pakwinga bantu bangi balakesanga mulina lyakame kabambeti, ‘Njame Mupulushi usa Walaiwa.’ Kayi eti, ‘cindi cilashiki.’ Mutakabakonkela. ");
INSERT INTO sby_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mwakanyumfwa makani a nkondo kayi nebimfulunganya mubishi, mutakatina. Ibi bintu byelela kutanguna kwinshika, nomba nteko kwambeti mapwililisho a cishi alashiki.” ");
INSERT INTO sby_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Lino Yesu walapitilisha kubambileti, “Bishi nibikalwane ne bishi nabimbi, nayoyo mishobo nikabukilane ne mishobo inabo. ");
INSERT INTO sby_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nikukabe mikukumo iyosha. Nikukabe nsala, malwashi ne lulanga mumisena yapusana pusana. Nikukenshike bintu byeshikuyosha nebingashilo byeshikukankamanisha kwilu. ");
INSERT INTO sby_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Nsombi byonse ibi kabitana binshika, nimukasungwe nekupenshewa. Nimukatwalwe mumanda akupaililamo, nimukabetekwe nekubikwa mujele. Nimukatwalwe ku bami ne baleli pacebo ca njame. ");
INSERT INTO sby_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ici nicikabe cindi caina ca kukambauka Mulumbe Waina. ");
INSERT INTO sby_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Lino mutakasukama mumyoyo kuyeyeti nitwambe cani pamulanduyu. ");
INSERT INTO sby_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Pakwinga ninkamupe maswi a mano cakwambeti kuliya mulwani wenu eti akacikonshe kukana nambi kutoteka. ");
INSERT INTO sby_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ne bamashali benu bonse, bamakwenu, beshikamukowa, nebanenu, nibakamutwale kubalwani benu, bambi pakati penu nibakamushine. ");
INSERT INTO sby_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Bantu bonse nibakamupate pacebo ca njame. ");
INSERT INTO sby_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Necikabeco kuliya mushishi nambi umo wenu weshi ukataike. ");
INSERT INTO sby_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mukalimbikile cakubula kubwelela munyuma nimukatambule buyumi bwenu.” ");
INSERT INTO sby_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Mwakaboneti munshi wa Yelusalemu ulashingulukwa ne beshi nkondo, mukenshibeti konongeka kwawo kulashiki. ");
INSERT INTO sby_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Lino abo bali mu Yudeya bakafwambile kumilundu, abo beshi bakabenga mukati mu Yelusalemu bakapulemo, balikumabala kabatakengila mu Yelusalemu. ");
INSERT INTO sby_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Pakwinga ici nicikabe cindi cacisubulo, kwambeti byonse bisa byalalembwa mumabala bikenshike. ");
INSERT INTO sby_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Batukashi beti bakabenga ne mabunda nibakabe mumapensho, nabo beshi bakabenga ne bana balayamwanga mumasubayo. Pakwinga nikukabe mapensho anene mucishici, kayi ne bukalu bwa Lesa nibukabe pabantu bamu Isilaeli. ");
INSERT INTO sby_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nabambi nibakayaswe bibeshi kayi nibakamantwe busha kubantu bamishobo imbi. Lino Yelusalemu nikalyataulwe ne baswamashi kushikila cindi cabo cikapwe. ");
INSERT INTO sby_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Kulakabanga bingashilo kulisuba ne kumwenshi ne kunyenyenshi. Pacishi pano, bantu nibakalisukame nekutina pakunyumfwa kuwota kwa lwenje ne mankape. ");
INSERT INTO sby_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Bantu nibakawisuke ne buyowa pakulangilila bilandanga kwinshika mucishi ca panshi conse, pakwinga ngofu sha kwilu nishikatenkanishiwe. ");
INSERT INTO sby_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Lino nibakabone ame nde Mwana Muntu kanjisa mumakumbi nengofu kayi nebulemu bunene. ");
INSERT INTO sby_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Lino bintu ibi byakatatika kwinshika, mukanyamuke nekwinuna mitwi yenu, pakwinga kulubulwa kwenu kulasenene pepi.” ");
INSERT INTO sby_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Lino Yesu walabambila mukoshano eti, “Kamulangani mukuyu nebitondo bimbi byonse. ");
INSERT INTO sby_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Na mulabono matewu atatiki kusonsa mukute kwishibeti cilimo cili pepi. ");
INSERT INTO sby_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Copeleco nenjamwe mwakabona bintu ibi kabinshika mukenshibe kwambeti Bwami bwa Lesa buli pepi. ");
INSERT INTO sby_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Ndamwambilinga cakubingeti musemano uwu nteti ukapwe kufwa bintu ibi kabitana binshika. ");
INSERT INTO sby_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kwilu ne cishi ca panshi nibikapite, nsombi maswi akame nteshi akapwepo ngofu sobwe.” ");
INSERT INTO sby_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Kamucenjelani kwambeti mutaba bantu basuni kulya ne kusekelela malyalya, nekukolwa kayi nekusukama pa bintu bya buyumi buno, pakwinga busuba ubo ngabwisa mwakutenshiba eti kose. ");
INSERT INTO sby_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Nibukese bushikubo pabantu bonse bekala pa cishi capanshi ");
INSERT INTO sby_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ikalani mwalibambila lyonse, nekupaila cindi conse, kwambeti mube nengofu shakupuluka kubintu ibi byeshibikeshike, kwambeti mukemane pamenso pa Mwana Muntu.” ");
INSERT INTO sby_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Masuba ayo, Yesu walikeyisha mu Ng'anda ya Lesa, nsombi mashiku lyonse walikuya ku mulundu wa maolifi akwikala. ");
INSERT INTO sby_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Lino mumenemene bantu bangi bali kabaya ku Ng'anda ya Lesa kuya kukutika kwiyisha kwakendi. ");
INSERT INTO sby_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Bushiku bwakukondwa bwa kulya shinkwa wabula cishikufufumusha, ubo bwalikukwiweti Pasika mpobwalashika pepi. ");
INSERT INTO sby_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Bamakulene beshimilumbo, ne beshikwiyisha Milawo balikabayandaula nshila yakushininamo Yesu. Nomba bali kutina bantu. ");
INSERT INTO sby_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Lino Satana walengila muli Yudasi, walikukwiweti Isikalyoti, uyo walikuba umo wa beshikwiya bali likumi ne babili ba Yesu. ");
INSERT INTO sby_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Neco Yudasi walaya kupangana ne bamakulene beshimilumbo ne beshikwendelesha Ng'anda ya Lesa ncobela kwinsa kwambeti amuyabe Yesu kulyendibo. ");
INSERT INTO sby_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Lino balakondwa, kayi balasuminishana kumulipila mali. ");
INSERT INTO sby_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yudasi walasumina ne kutatika kuyandaula cindi caina cakumuyabilapo, bantu bonse kabatacinshi. ");
INSERT INTO sby_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Bwalashika busuba bwakukondwa bwakulya shinkwa wakutafufumusha, busuba bwakushina twana twambelele twakulya pabusuba bwa Pasika. ");
INSERT INTO sby_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Lino Yesu walatuma Petulo ne Yohane ne kubambileti, “Kamuyani mutubambile byakulya bya pabusuba bwa Pasika kwambeti tulye.” ");
INSERT INTO sby_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Balo balamwipusheti, “Nikupeyo nkomulayandanga kwambeti twenga tubambile?” ");
INSERT INTO sby_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesu walabambileti, “Kamunyumfwani! mwengila mu Yelusalemu nimucane mutuloba wanyamuna nongo ya menshi, mu mukonkele mpaka mung'anda moshi engile. ");
INSERT INTO sby_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Lino mu mwambile mwine ng'andeti, Bashikwiyisha balepushungeti, ‘Nomba cili kupeyo cipinda moshi balyele byakulya bya Pasika ne beshikwiya babo’ ");
INSERT INTO sby_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Lino na amuboneshe cipinda cinene ca pelu cabambiwa cena, mopelomo emoti mutubambile byakulya.” ");
INSERT INTO sby_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Lino balaya kucana bintu byonse mbuli mwalabambilila Yesu. Lino balatatika kubamba byakulya bya Pasika. ");
INSERT INTO sby_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Lino mpocalashika cindi cakulya Yesu walekala pa tebulu pamo ne batumwa bakendi kwambeti balye. ");
INSERT INTO sby_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Lino Yesu walabambileti, “Ndayandishishanga kulya Pasika pamo nenjamwe nkantana kutatika kupenshewa. ");
INSERT INTO sby_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ndamwambilinga cakubinga nteshi nkalyepo Pasika, kushikila cikakwanilishiwe mu Bwami bwa Lesa.” ");
INSERT INTO sby_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Lino Yesu mpwalamanta nkomeshi nekulumba Lesa, walabambileti, “Kamutambulani munwe mwense. ");
INSERT INTO sby_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Lino ndamwambilinga kufuma lelo nteshi nkanwepo waini, kushikila Bwami bwa Lesa bukese.” ");
INSERT INTO sby_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kufumapo Yesu walamanta shinkwa, walalumba Lesa, nekukomona nekupa beshikwiya bakendi nekwambeti, “Uyu emubili wakame ulayabwa cebo canjamwe. Kamwinsanga ici lyonse pakunganukila.” ");
INSERT INTO sby_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Copeleco mpobalapwisha kulya mulalilo, Yesu walapa beshikwiya bakendi nkomeshi nekubambileti, “Nkomeshi iyi nicipangano calino lino ca Lesa, nemilopa yakame yeshi iketike pacebo cenu. ");
INSERT INTO sby_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Nsombi kamubona! Uyo lanjabanga kubalwani lalinga pamo nenjame patebulu pano. ");
INSERT INTO sby_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Pakwinga Mwana Muntu nakafwe kwelana ne kuyanda kwa Lesa. Nsombi muntu lamuyabanga Mwana Muntu nakapenge. Caina muntuyo nalabula kusemwa.” ");
INSERT INTO sby_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Lino beshikwiya balatatika kulipusheti, nomba welakwinseco niyani pakati petu. ");
INSERT INTO sby_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Lino beshikwiya balatatika kupikishaneti, “Inga niyani mukulene pakati petu?” ");
INSERT INTO sby_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Lino Yesu walabambileti, “Bami ba bantu bakunsa bakute ngofu pabantu babo kayi bakute kulyela masuku pamutwi bantu, bakute kukwiweti, ‘Beshikwinsa byaina kubantu.’ ");
INSERT INTO sby_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nsombi pakati penu citabanga mushoboyu. Cakubinga mukulene pali amwe abe weshikulicepesha kupita bonse, neye weshi kwendelesha abe musha wenu. ");
INSERT INTO sby_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nomba mukulene niyani? Sena ni usa lalinga pa tebulu na ni musha? Sena nte usa lalyelenga pa tebulu? Nomba ame ndilyeti musha pakati penu. ");
INSERT INTO sby_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Amwe mulekala nenjame mumasunko akame onse. ");
INSERT INTO sby_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Lino copeleco, mbuli ba Ta ncobalampa ngofu shakwendelesha, nenjame nindimupeni ngofu. ");
INSERT INTO sby_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nimukalye ne kunwa pamo nenjame, kayi nimukekale pabipuna bya Bwami ne kubeteka mishobo likumi ne ibili ya ba Isilaeli.” ");
INSERT INTO sby_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Shimoni, Shimoni, nyumfwa! Satana layandanga kumupupulusha mumasunko mbuli mulimi ncakute kupupulusha maila. ");
INSERT INTO sby_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nsombi ndakupailili kwambeti lushomo lwakobe lutapwa. Lino obe wakatembenuka mumuyo ukayuminishe banobe.” ");
INSERT INTO sby_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nsombi Petulo walakumbuleti, “Mwami, ame ndalibambila kuya nenjamwe mujele nambi kufwa.” ");
INSERT INTO sby_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu walakumbuleti, “Ndakwambilinga Petulo, lelo kombwe nkatana alila, nunkane mankanda atatu eti nkonjinshipo.” ");
INSERT INTO sby_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesu walepusha beshikwiya bakendi eti, “Pasa mpondalamutuma nkamubulile mpotomona, cola nambi nkwabilo nomba nicani ncomwapengapo?” Balo balakumbuleti, “Kuliyawa.” ");
INSERT INTO sby_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Lino walabambileti, “Muntu uliyense ukute mpotomona nambi cola, anyamune. Neye uyo wabula mupeni, aulishe byakufwala byakendi kwambeti aule mupeni. ");
INSERT INTO sby_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Cakubinga celela kwinshika calalembwa Mumabala eti, ‘Neye balamubelengela pamo ne babwipishi.’ Ndamwambilingeti Mabala aya alenshikinga cancinencine.” ");
INSERT INTO sby_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Beshikwiya balambeti, “Kamubona Mwami tukute bibeshi bibili,” Yesu walabakumbuleti, “Ni ningi byopelebyo.” ");
INSERT INTO sby_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu walafumamo mu Yelusalemu nekuya ku mulundu wa maolifi mbuli ncalikwinsa lyonse. Naboyo beshikwiya bakendi balamukonkela. ");
INSERT INTO sby_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Mpwalashika pamusena uyo Yesu walabambileti, “Kamupailani kwambeti mutengila mumasunko.” ");
INSERT INTO sby_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Lino Yesu walabashiya, walendako pang'ana walafukama nekupaila. ");
INSERT INTO sby_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Walambeti, “Bata, na musuni kamufunyani nkomeshi ya mapensho iyi. Necikabeco mutensa kuyanda kwakame, nsombi mwinse kuyanda kwenu.” ");
INSERT INTO sby_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Lino mungelo wakwilu walesa kumuyuminisha. ");
INSERT INTO sby_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Pacebo cakupenshewa mumoyo, walapaila cangofu kupita pakutanguna. Lino inkasalo yakendi yalikubeti mandondo a milopa alakanga panshi. ");
INSERT INTO sby_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Mpwalafuma akupaila walabwelela kuli beshikwiya bakendi. Walacana nkabalibona pacebo ca miyeyo, ");
INSERT INTO sby_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Yesu walabepusheti, “Nipacebo cini mona tulo? Kamupundukani mupaile kwambeti mutengila mumasunko.” ");
INSERT INTO sby_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu nkacamba, likoto lya bantu, lyalesa kalili lyatanguninwa ne Yudasi, umo wabeshikwiya likumi nebabili. Walesa pepi walamupa mutende ne kumushonshota. ");
INSERT INTO sby_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nsombi Yesu walamwambileti, “Yudasi, sena ulayabanga Mwana Muntu kupitila mukumushonshota?” ");
INSERT INTO sby_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Lino beshikwiya balikuba ne Yesu mpobalabona calikwinshika balepusha Yesu eti, “Mwami, Se tubayase ne bibeshi?” ");
INSERT INTO sby_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Lino umo wa beshikwiya walatimbula litwi lya kululyo lya musebenshi wa mukulene wa beshimilumbo bonse. ");
INSERT INTO sby_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Nsombi Yesu walambeti, “Cilekeni kwinseco.” Popelapo Yesu walekata litwi lya muntu uyo nekumushilika. ");
INSERT INTO sby_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yesu walambila bonse abo balesa kumwikata, bamakulene ba beshimilumbo nebamukulene baba kamulonda ba Ng'anda ya Lesa, kayi nebamakulene ba Bayuda. Walabepusheti, “Sena mulenshi kwisa ne mipeni nemingwala eti nde kapondo? ");
INSERT INTO sby_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ndalikuba nenjamwe mu Ng'anda ya Lesa lyonse, nomba muliya kunjikatapo. Lino cino cindi nicenu ca ngofu sha mwami wa mushinshe.” ");
INSERT INTO sby_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Lino balekata Yesu nekumutwala kung'anda ya mukulene wa beshimilumbo bonse. Neye Petulo walikakonkela Yesu capatali. ");
INSERT INTO sby_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Lino balakunka mulilo pakati palubansa lwang'anda, bonse balekala panshi pamo. Neye Petulo walekala pakati pabo. ");
INSERT INTO sby_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Lino mutukashi umo wa basebenshi mpwalabona Petulo kayota mulilo wamulangishisha, ne kwambeti, “Uyu neye walikuba ne Yesu.” ");
INSERT INTO sby_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nsombi Petulo nendi walakana nekwambeti, “Sobwe obe mutukashi nkandimwinshipo uyu ame.” ");
INSERT INTO sby_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mpopalapita kacindi kang'ana mutuloba naumbi neye walamubona Petulo nekumwambileti, “Obe njobe umo wabasa.” Nomba Petulo walakumbuleti, “Ntamepo sobwe.” ");
INSERT INTO sby_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Mpopalapita kacindi kanda kukwana ola umo naumbi muntu walamba cangofu eti, “Nicakubinga muntu uyu walikuba ne Yesu pakwinga nimwine Galileya.” ");
INSERT INTO sby_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Petulo walakumbuleti, “Ayo makani ngolambanga nkandainshi ame nambi pang'ana.” Lino petulo kacamba, kombwe walalila. ");
INSERT INTO sby_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Mwami Yesu walafutatuka nekulangilisha Petulo. Lino nendi Petulo walanuka maswi a Mwami Yesu ngalamwambileti, “Kombwe nkatana alila lelo, obe Petulo nunkane mankanda atatu.” ");
INSERT INTO sby_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Lino Petulo walafuma pansa, walalila cebo ca cikonko ncali kukute mumoyo. ");
INSERT INTO sby_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Lino bantu balikulonda Yesu, balatatika kumuseka nekumuma. ");
INSERT INTO sby_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Balamufweka pamenso, balamuma nekumwipusheti, “Lotela, nomba niyani lakumu?” ");
INSERT INTO sby_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Kayi balamba maswi angi akumucobola. ");
INSERT INTO sby_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Mpobwalaca bamakulene ba Bayuda, ne beshimilumbo, kayi ne beshikwiyisha Milawo balabungana. Balamumanta Yesu nekuya nendi kunkuta yabo. ");
INSERT INTO sby_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Balamwipusheti, “Twambile na njobe Mupulushi Walaiwa usa.” Nsombi nendi walabakumbuleti, “Nambi ndimwambile, nteshi mushome sobwe, ");
INSERT INTO sby_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","na ndimwipushe mwipusho, nteshi munkumbulepo. ");
INSERT INTO sby_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kufuma lelo ame nde Mwana Muntu nimbenga ndekala kulikasa lyakululyo kwa Lesa wangofu shonse.” ");
INSERT INTO sby_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Lino bonse balepusheti, “Sena ulambangeti njobe Mwanendi Lesa?” Neye walakumbuleti, “Ee njame mbuli ncomulamba mobene.” ");
INSERT INTO sby_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Balo balambeti, “Sena lino inga katuciyandola nabambi bakamboni? Tulalinyufwili kendi ncalamba mwine.” ");
INSERT INTO sby_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Bantu bangi balanyamuka, nekutwala Yesu kuli Pilato. ");
INSERT INTO sby_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Lino balatatika kumubepeshela Yesu eti, “Twalamucana muntu uyu kayungaula bantu ba mushobo wetu. Walikwambila bantu eti tucileke kusonka musonko kuli mwami wa ku Loma. Kayi ukute kwambeti ni Mupulushi Walaiwa kayi eti emwami.” ");
INSERT INTO sby_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Lino Pilato walamwipusha Yesu eti, “Sena njobe, Mwami wa ba Yuda?” Yesu walakumbuleti, “Mulamba mobene.” ");
INSERT INTO sby_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato walambila bamakulene beshimilumbo nebantu bonse basa eti, “Ame kuliya mulandu ngondacana pa muntu uyu.” ");
INSERT INTO sby_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nsombi balo balayuminina kumubepeshela kabambeti, “Layungaulunga ne kufulunganya bantu pakwiyisha kwakendi mucishi conse ca Yudeya. Walatatikila ku Galileya lino mpaka lashiki ne kuno.” ");
INSERT INTO sby_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato mpwalanyumfweco walepusheti, “Sena uyu muntu nimwine Galileya?” ");
INSERT INTO sby_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Lino mpwalanyumfwa kwambeti Yesu ukute kufuma mucishi ncalikwendelesha Helode, walamutuma kuli Helode uyo walikuba mu Yelesalemu pa cindico. ");
INSERT INTO sby_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Helode mpwalabona Yesu walakondwa, pakwinga lyonse walikunyumfwa mbili yakendi. Neco walikuyanda kumubona. Walikuyandishisha kwambeti akamubonepo kensa cikankamanisho. ");
INSERT INTO sby_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Neco Helode walamwipusha mipusho ingi, nsombi Yesu nendi liya kumukumbulapo ciliconse. ");
INSERT INTO sby_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Bamakulene beshimilumbo ne beshikwiyisha ba Milawo balesa pepi nekutatika kumubepesha cangofu. ");
INSERT INTO sby_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Helode nebashilikali bakendi balamuseka Yesu ne kumunyansha. Lino balamufwalika cakufwala cabwami, nekumubwesha kuli Pilato. ");
INSERT INTO sby_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kufuma busuba ubo Helode ne Pilato balatatika kunyumfwana pakwinga balikuba bapatana. ");
INSERT INTO sby_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Lino Pilato walabunganya bamakulene beshimilumbo ne beshikwendelesha kayi ne bantu bonse. ");
INSERT INTO sby_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Lino walabambileti, “Uyu muntu mulamulete kuli njameti nkayungaula bantu, lino ame ndamwipushu mwense kamulipo, ndacana kwambeti liya mulandu pamakani onse ngomwa mwambanga. ");
INSERT INTO sby_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Helode neye liya kucanapo mulandu pali uyu muntu, weco neye lamubweshe kuli afwe. Kamubona uyu muntu liya kwinsapo mulandu wakufwilapo. ");
INSERT INTO sby_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Neco ndimukwipowa ne kumusungulula.” ");
INSERT INTO sby_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Nomba Pilato lyonse walikubasungululila kayili umo pabusuba bwa Pasika. ");
INSERT INTO sby_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nsombi bonse bantu balolobesha pamo eti, “Ashinwe muntu uyu, mutusungwilile Balabasi.” ");
INSERT INTO sby_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balabasi uyu walasungwa pakwinga walapanga cimfulunganya mucishi ne kushina bantu. ");
INSERT INTO sby_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Nsombi Pilato walikuyanda kumusungulula Yesu, neco walamba nabo bantu basa kayi. ");
INSERT INTO sby_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Nomba nabo balolobesheti, “Mupopeni palusanda! Mupopeni!” ");
INSERT INTO sby_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilato walabambila bantu kabutatu eti, nomba lenshi cani caipa uyu? Ame ndacana kwambeti liya mulandu ngwelakufwilapo. Neco ndimukwipowa nekumusungulula. ");
INSERT INTO sby_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Nsombi bonse bayuminina kolobesheti, “Welela kupopwa palusanda.” Lino Pilato walakomwa kumaswi ayo. ");
INSERT INTO sby_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Neco Pilato walapingula kwelana ne ncobalikusenga bantu baseti cinshike. ");
INSERT INTO sby_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pilato walasungulula Balabasi uyo walaleta cimfulunganya nekushina bantu ngobalasenga. Yesu bamwinse kwelana mbuli kuyanda kwabo. ");
INSERT INTO sby_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Bashilikali balamumanta Yesu kwambeti benga bamupope. Balakumana ne Shimoni waku Kulene, nkafuma muminshi. Balamwikata nekumunyamwisha lusanda kwambeti akonkenga panyuma pa Yesu. ");
INSERT INTO sby_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Bantu bangi balikumukonkela. Pakati pabo palikuba batukashi bali kabalila nekunyumfwa kwipilwa pacebo ca Yesu. ");
INSERT INTO sby_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Lino Yesu walapilibuka ne kubambileti, “Amwe mobatukashi ba ku Yelusalemu mutalilila ame sobwe, nsombi mulilile mobene kayi ne bana benu. ");
INSERT INTO sby_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Pakwinga masuba nakashike bantu mpoti bakambengeti, ‘Bakute colwe batukashi balabula kusemapo nekuyamwishapo!’ ");
INSERT INTO sby_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Pacindico nibakasenge malundu eti, ‘Kamutuwila’ Kayi netucina eti, ‘Tufwekeleleni.’ ");
INSERT INTO sby_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nomba lino na kulico kulinjame ndecitondo catontola, nomba nikukabeconi kuli njamwe mobitondo byayuma?” ");
INSERT INTO sby_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Balamanta ba kapondo babili kwambeti benga bapopwe pamo ne Yesu. ");
INSERT INTO sby_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Mpobalashika kumusena walikukwiweti cifupa ca mutwi, balapopa Yesu palusanda. Kopeloko balapopako bakapondo basa palusanda, umbi kululyo naumbi kucipiko. ");
INSERT INTO sby_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu walambeti, “Ta, kamubalekelela pakwinga nkabacinshi ncobalenshinga.” Lino balensa nsolo nekuyabana byakufwala byakendi. ");
INSERT INTO sby_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bantu balikuba bemana popelapo kabebela. Nomba bamakulene ba Bayuda abo kabaweluluka Yesu nekwambeti, “Walapulusha bambi, lino neye alipulushe mwine, na ni Mupulushi uyo Walaiwa ne Lesa.” ");
INSERT INTO sby_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Bashilikali naboyo balamuseka, balesa pepi nekumupa waini wasasa eti anwe. ");
INSERT INTO sby_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Nekumwambileti, “Na njobe Mwami wa Bayuda, lipulushe omwine.” ");
INSERT INTO sby_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Pelu palusanda palikuba palembweti, “Uyu emwami wa ba Yuda.” ");
INSERT INTO sby_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kapondo umo walikuba wapopwa pamo ne Yesu, walamucobola Yesu eti, “Sena ntobe mupulushi washomeshewa? Lipulushe nenjafwe utupulushe.” ");
INSERT INTO sby_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nsombi umbi walakalilila munendi nekumwambileti, “Sena obe nkotini Lesa? Tulapopwa pamo twense mu mapensho. ");
INSERT INTO sby_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nsombi afwe tobabili twelela kupopwa pakwinga tulatambulunga cilambo celela pa bintu mbyotwalikwinsa. Lino uyu neye kuliya caipa ncalensapo.” ");
INSERT INTO sby_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Lino walambila Yesu eti “Mukanganuke mwakesa mu Bwami bwenu.” ");
INSERT INTO sby_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Lino Yesu walamwambileti, “Cakubinga ndakwambilinga lelo, nukekale nenjame mu Paladaiso.” ");
INSERT INTO sby_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Lino cindi mpocalashika pa 12 koloko, kwalaba mushinshe pacishi conse kushikila 3 koloko, ");
INSERT INTO sby_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","lino cikwisa calikucala mu Ng'anda ya Lesa calatwamuka pakati. ");
INSERT INTO sby_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Lino Yesu walolobesha ne liswi lya pelu eti, “Ta mushimu wakame ndaubiki mumakasa enu.” Mpwalapwisha kwambeco, walafwa. ");
INSERT INTO sby_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Mukulene wa bashilikali mpwalaboneco, walalumbaisha Lesa, ne kwambeti, “Nicakubinga uyu muntu walikuba walulama.” ");
INSERT INTO sby_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Naboyo bantu bangi balikuba babungana kabebela, mpobalabona calenshika balabwelela kumanda kwabo nkabayakulyuma pantiti ne kungumana. ");
INSERT INTO sby_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Bantu bonse balikumwinshiba Yesu, ne batukashi basa balamukonkela baku Galileya, balemana patali kababona byonse byalenshika. ");
INSERT INTO sby_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kwalikuba muntu walikukwiweti Yosefe walikwikala mumushi wa Alimateya mucishi ca Yudeya. Walikuba umo wamulibunga lya Nkuta inene ya Bayuda, walikuba muntu uli cena walemekwa ");
INSERT INTO sby_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","nendi wali kupembelela kwisa kwa Bwami bwa Lesa. ");
INSERT INTO sby_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Uyu muntu walaya ku musenga Pilato citumbi ca Yesu. ");
INSERT INTO sby_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Lino walaselusha citumbi palusanda ne kupombela mucikwisa caina, walamubika mu cumbwe ca mulibwe umo mwalikuba mutana mubikwapo muntu uliyense. ");
INSERT INTO sby_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Bwalikuba busuba bwakulibambila pakwinga busuba bwa Sabata bwalikuba pepi kutatika. ");
INSERT INTO sby_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Batukashi baku Galileya basa balikukonkela Yesu balaya ne Yosefe akubona cumbwe mwalabika citumbi ca Yesu. ");
INSERT INTO sby_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Balabwelela ku ng'anda a kubamba mafuta anunkila cena. Lino pabusuba bwa Sabata, balapumwina kwelana ne Milawo Lesa njalapa Mose. ");
INSERT INTO sby_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Lino mumenemene pa busuba bwa pa Sondo, batukashi abo balanyamuna mafuta ne byanunkila mbyobalabamba kuya kucumbwe. ");
INSERT INTO sby_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Balacana libwe lyakunkulushiwapo pacishinga ca cumbwe. ");
INSERT INTO sby_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nomba mpobalengila mucumbwe baliya kucanamo citumbi ca Mwami Yesu. ");
INSERT INTO sby_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kabacikankamana, balabonowa bantu babili balikuba bafwala byakufwala byabekema kabali bemana pepi nabo. ");
INSERT INTO sby_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Batukashi abo balatina nekukotama panshi. Lino bantu abo balabepusheti, “Mulamulangwelinga cani muntu muyumi pakati pa bafu? ");
INSERT INTO sby_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nkalimo muno, lapunduku. Kamwanuka maswi ngalamwambila mpwalikuba ku Galileya. ");
INSERT INTO sby_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Eti Mwana Muntu welela kuyabwa mumakasa a bantu baipa, nekupopwa palusanda, nekupunduka kubafu pakapita masuba atatu.” ");
INSERT INTO sby_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Popelapo batukashi basa balanuka maswi aya. ");
INSERT INTO sby_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Mpobalafuma kucumbwe kusa, balambila beshikwiya likumi ne umo kayi ne bantu bambi bonse. ");
INSERT INTO sby_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Abo batukashi balikuba Maliya wa ku Magadala, ne Yohana ne Maliya banyina Jemusi. Balo ne batukashi bambi balikubapo balambila batumwa makani aya. ");
INSERT INTO sby_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nsombi maswi ayo kubeshikwiya alaboneka eti nikutamokowa, neco baliya kubashoma batukashi abo. ");
INSERT INTO sby_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Nsombi nendi Petulo walanyamuka nekufwambilako kucumbwe. Mpwalashika walabonowa muli bikwisa byonka, walabwelela kung'anda kali wakankamana pabintu byalenshika. ");
INSERT INTO sby_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Pabusuba ubo beshikwiya babili balikuya kumunshi walikukwiweti Emausi. Mushinso wa kufuma ku Emausi kushika ku Yelusalemu walikuba wa makilomita akwana likumi ne limo. ");
INSERT INTO sby_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Mpobalikuya munshila bali kababandika pa bintu ibyo byonse byalenshika. ");
INSERT INTO sby_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kabacibandika nekwipushanya, Yesu mwine walesa pepi ne kwendela pamo nabo. ");
INSERT INTO sby_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Balamubona nomba baliya kumwinshiba. ");
INSERT INTO sby_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu walabepusheti, “Nimakani cini ngomulenga nkamubandikilana?” Lino nabo balemana kayi cinso cabo nkacili calaka nemapensho, ");
INSERT INTO sby_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","lino umbi walikukwiweti kileopasi walamwipusheti, “Sena njobe mwensu wenka mu Yelusalemu utenshi byalenshika masuba apita kunyuma?” ");
INSERT INTO sby_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesu walepusheti, “Byamushobocini?” Lino balakumbuleti. Sha Yesu wa ku Nasaleti. Uyo muntu walikuba munshinshimi wali kwinsa bintu byangofu pamenso a Lesa ne bantu bonse. ");
INSERT INTO sby_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nsombi bamakulene beshimilumbo ne bakulene betu bambi balamutwala kwambeti apewe mulandu wakushinwa, kufumapo balamupopa palusanda. ");
INSERT INTO sby_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nsombi afwe twalikuba twengashila kwambeti nakalubule ba Isilaeli. Lino palapiti masuba atatu kufuma mpobyenshika byonse ibi. ");
INSERT INTO sby_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Lino kayi batukashi nabambi pakati petu balatukankamanisha. Nabo balaya kucumbwe mumene mene, ");
INSERT INTO sby_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","lino mubili wakendi baliya kucanamo. Mpobalabwela balambeti balabono bangelo abo balabambileti Yesu nimuyumi. ");
INSERT INTO sby_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bambi mulikoto lyetu balaya kucumbwe ne kucana mbuli ncobalamba batukashi basa, nabo baliya kumubona Yesu. ");
INSERT INTO sby_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Lino Yesu walabambileti, “Amwe mobantu baluya, bakute kubula kuyanda kushoma bwangu bintu byonse byalamba bashinshimi. ");
INSERT INTO sby_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Sena nkamucinshi kwambeti mupulushi walaiwa usa walikwelela kunyumfwa byeshikubaba byonse ibi kwambeti engile mubulemu bwakendi?” ");
INSERT INTO sby_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Lino walabasansulwila byonse byalembwa mumalembo onse, kutatikila mumabuku a Mose mpaka ku bashinshimi bonse bilambanga palyendiye. ");
INSERT INTO sby_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Mpobalashika pepi ne Yelusalemu, Yesu walenseti lapitililinga. ");
INSERT INTO sby_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nsombi beshikwiya abo balamukakatisha ne kwambeti, “Kamwikalani nenjafwe pakwinga kulashipi, bonani lisuba lilenga akwibila.” Neco walengila mung'anda ne kwikala nabo. ");
INSERT INTO sby_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Mpwalekala nabo pakulyela, Yesu walamanta shinkwa, walalumba Lesa, Kayi walakomona nekubayabila. ");
INSERT INTO sby_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Popelapo menso abo alacaluka. Lino balamwinshiba popelapo walashimanganowa. ");
INSERT INTO sby_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Lino balatatika kwambilaneti, “Cancine ncine maswi akendi ayasanga mumoyo mpwatwambilanga munshila pasa, nekupandulula mabala.” ");
INSERT INTO sby_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kufumapo balanyamuka nekubwelela ku Yelusalemu, uko nkobalacana beshikwiya likumi ne umo kabali babungana pamo nebanabo, ");
INSERT INTO sby_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","kabambeti, “Nicakubinga Mwami lapunduku kubafu, labonekele kuli Shimoni.” ");
INSERT INTO sby_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Lino naboyo babili basa, balasansulula calenshika munshila mpobalamwinshiba Mwami mpwalabakomwena shinkwa. ");
INSERT INTO sby_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kabacamba babili abo, Yesu mwine walashika nekwimana pakati pabo bonse ne kwambeti, “lumuno lube nenjamwe.” ");
INSERT INTO sby_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Balo balatilimuka nekutina pakwinga balayeyeti balabononga cipuku. ");
INSERT INTO sby_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nendi walabambileti, “Nomba mulapengelenga cani ne kutoshana mumyoyo mwenu? ");
INSERT INTO sby_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kamubona makasa nebimpanta byakame, kwambeti njame. Kamunjikata munyumfwe pakwinga cipuku ciliya musuni nebifupa mbuli mbyomulabonongeti ndibikute ame.” ");
INSERT INTO sby_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Lino mpwalambeco walababonesha makasa nebimpanta byakendi. ");
INSERT INTO sby_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nabo baliya kushoma pakwinga balikuba bakondwa, kayi ne kukankamana. Lino walabepusheti, “Sena mukutepo byakulya pano?” ");
INSERT INTO sby_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Balamupa cipansha ca nswi yakuyoka. ");
INSERT INTO sby_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Walacitambula ne kulya bonse nkababonako. ");
INSERT INTO sby_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Lino walabambileti, “Ibi ebintu byondamwambila mpondalikuba nenjamwe. Pasa ndalikwambeti byonse byalembwa pali njame mu Milawo Lesa njalapa Mose, ne mumabuku abashinshimi, ne mulibuku lya kutembaula.” ");
INSERT INTO sby_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Lino walabanyafwa kwambeti banyufwishishe Mabala. ");
INSERT INTO sby_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Walabambileti, “Byalalembwa nibi; Mupulushi welela kupenshewa ne kupunduka kubafu pabusuba bwabutatu. ");
INSERT INTO sby_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kwambeti mulina lyakendi Mulumbe Waina ukakambaukwe kubantu ba mishobo yonse, kutatikila ku Yelusalemu. Kwambeti basanduke mumoyo benseco neye Lesa empwela kubalekelela bwipishi bwabo. ");
INSERT INTO sby_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Amwe mobakamboni pabintu ibi. ");
INSERT INTO sby_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ninkamutumine cipo ico Bata ncobalashomesha, nsombi mwelela kwikala mumunshi muno kushikila mukatambule ngofu sheti shikafume kwilu.” ");
INSERT INTO sby_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Lino Yesu walabatangunina kufuma mumunshi umo kuya kushika ku Betaniya. Kopeloko walatambika makasa akendi nekubaleleka. ");
INSERT INTO sby_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Lino kacibaleleka walapansana nabo, nekumantwa kuya kwilu. ");
INSERT INTO sby_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Lino balamukambilila, panyuma pakendi balabwelela ku Yelusalemu kabali bakondwa maningi. ");
INSERT INTO sby_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Cindi conse balikucanika mu Ng'anda ya Lesa kabalumbaisha Lesa.");
INSERT INTO sby_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Pakutatika, kakuli kwabula bintu byonse kwalikuba Liswi, Liswi ili lyalikuba kuli Lesa. Kayi Liswi ili lyalikuba Lesa. ");
INSERT INTO sby_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Liswi ili lyalikuba ne Lesa cindi conse. ");
INSERT INTO sby_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Byonse byalabako kupitila mulyendiye, kayi kuliyawa cintu calabako kwabula endiye. ");
INSERT INTO sby_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mulyendiye mwalikuba buyumi, kayi buyumi ubo ebwalikuba cinyina ca mumuni kubantu. ");
INSERT INTO sby_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Mumuni uwu ulamunikinga mumushinshe, kayi mushinshe nkawalacikonsha kushima mumuni. ");
INSERT INTO sby_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Neco Lesa walatuma muntu naumbi, lina lyakendi walikuba Yohane. ");
INSERT INTO sby_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Nendi uyu walesa kwinshila bukamboni, nekwambila bantu sha mumuni usa, kwambeti bantu bonse banyumfwe nekushoma. ");
INSERT INTO sby_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Nteko kwambeti nendi walikuba mumuni, nsombi walesa kuba kamboni wa mumuni. ");
INSERT INTO sby_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mumuni wancine ncine, weshi kumunikila bantu bonse, walesa pacishi capanshi. ");
INSERT INTO sby_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Yesu walikuba pacishi capanshi, nomba bantu bapacishi capanshi baliya kumwinshiba, nambi Lesa walalenga bintu byonse kupitila mulyendiye. ");
INSERT INTO sby_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Walesa kubantu bamushobo wakendi, nomba bantu bakendi baliya kumutambula. ");
INSERT INTO sby_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Necikabeco nabambi balamutambula nekushoma lina lyakendi, kayi bopelaba walabapa ngofu shakuba bana ba Lesa ");
INSERT INTO sby_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Neco Kuba bana ba Lesa kuliya kufuma mukusemwa kwabo, nambi mu kuyanda kwa mubili, nambi kwanda kwa muntu sobwe, sombi kwalafuma kuli Lesa. ");
INSERT INTO sby_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Lino Liswi lyalasanduka muntu, nekwisa kwikala pamo nenjafwe. Walikuba ne nkumbo kayi ne cancine ncine. Kayi twalabona bulemu bwakendi, bulemu mbwalatambula kuBaishi. ");
INSERT INTO sby_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohane walamubela bukamboni. Walikwambila bantu mwangofu kwambeti, “Uyu engondalikwambeti, kuli lesanga panyuma pakame wampita, pakwinga nkantana nsemwa, nendi walikubapo.” ");
INSERT INTO sby_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Weco kupitila munkumbo shakendi shesula twense twalalelekwa mwakupwililila, kulelekwa kwakonkana konkana. ");
INSERT INTO sby_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Lesa walatupa Milawo kupitila muli Mose, nomba inkumbo nekushomeka kwalesa kupitila muli Yesu. ");
INSERT INTO sby_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","kuliya muntu walamubonapo Lesa. Nsombi umo enka Lesa usa, wekala pamo neBaishi, ewalamuyubulula. ");
INSERT INTO sby_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Lino ubu ebukamboni mbwalapa Yohane kubamakulene baBayuda baku Yelusalemu balatuma beshimilumbo neba Levi nabambi kuyakwipusha Yohane, balamwipusheti “Njobe bani?” ");
INSERT INTO sby_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nendi walasumina cancine ncine nekubakumbula mwakubula kusoleka, “Ame ntame Mupulushi Walaiwa usa sobwe.” ");
INSERT INTO sby_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Balamwipusha kayi, “Nomba njobe Eliya?” Neye walambeti, “Sobwe, ntame Eliya.” Nabo balambeti, “Njobe Mushinshimi ngotulapembelelenga usa?” Neye Yohane walakumbuleti, “Sobwe ntame.” ");
INSERT INTO sby_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Lino twambile cancine ncine, kwambeti twenga tubapandulwile cena balatutumu. Omwine ukute kwambeti njobe bani? ");
INSERT INTO sby_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohane walabakumbuleti, mbuli mwalambila mushinshimi Yesaya, “Ame njame liswi lya muntu lolobeshenga mucinyika; Lambangeti, lulamikani nshila mwakupita Mwami.” ");
INSERT INTO sby_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Lino basa bantu balatumwa ne Bafalisi, ");
INSERT INTO sby_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","balamwipusha Yohane, “Na ntobe Mupulushi Walaiwa usa, nambi Eliya, nambi Mushinshimi ngotulapembelelenga usa, nomba nicani ulabatishinga bantu?” ");
INSERT INTO sby_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohane walabakumbuleti, “Ame ndababatishinga ne menshi nsombi pakati penu apa pali umbi ngomutenshi. ");
INSERT INTO sby_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nendi uyu lesanga panyuma pakame, nkandelela nekuba musha wakendi wela kusungulula ntambo sha nkwabilo shakendi.” ");
INSERT INTO sby_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Bintu ibi byalenshikila ku Betaniya, kutala lwa kucwe kwa mulonga waYolodani, uko Yohane nkwali kubatisha. ");
INSERT INTO sby_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mumene mene Yohane walabona Yesu kesa kulyendiye, lino walambeti, “Kamubonani Mwana Mbelele wa Lesa, weshikufunya bwipishi bwapacishi capanshi! ");
INSERT INTO sby_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Uyu endiye usa ngondalikwambeti, ‘Panyuma pakame palesanga muntu wampita, pakwinga ame nkantanansemwa nendi walikubako.’ ");
INSERT INTO sby_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nenjame nkandimwinshi, nomba ndalesa akubatisha ne menshi kwambeti Baislaeli bamwishibe.” ");
INSERT INTO sby_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Kayi Yohane walamwinshila bukamboni, pakwambeti, “Ndalabona Mushimu Uswepa kauseluka kwilu walikuboneketi nkulimba, walesa kwikala pali endiye. ");
INSERT INTO sby_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ame nkandali kumwinshiba, nsombi Lesa walantuma kwisa akubatisha ne menshi ewanjishibisha kwambeti, ‘Nubone Mushimu Uswepa wesanga kwikala palyendiye, epeloyo eshi kubatisha ne Mushimu Uswepa.’ ” ");
INSERT INTO sby_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ame ndalabibona, kayi ndamwambilingeti, “Epele uyu Emwana waLesa.” ");
INSERT INTO sby_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mumene mene busuba bwalakonkapo Yohane walikuba pamusena popelapo pamo ne beshikwiya bambi babili. ");
INSERT INTO sby_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Mpwalabona Yesu kapita, walambeti, “Kamubonani Mwana mbelele wa Lesa!” ");
INSERT INTO sby_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Beshikwiya babili basa mpobalanyumfwa maswi alico, balamukonka Yesu. ");
INSERT INTO sby_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu mpwalacebuka ne kuboneti balamukonkelenga, walabepusheti, “Nomba mulayandanga cani?” Nabo balambeti, “Tulayandanga kwinshiba mukute kwikala kupeyo, Labi? Bupandulushi bwa Labi nikwambeti, shikwiyisha.” ");
INSERT INTO sby_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesu walakumbuleti “Tiyeni mwenga mukubone.” Nabo balaya nendi. Nomba cindi calikuba mu ma 4 koloko mansailo mpobalayakubona nkwalikwikala, balekala kopeloko ubo busuba. ");
INSERT INTO sby_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Umo pali basa babili walanyumfwa maswi a Yohane ne kumukonka Yesu, walikuba Ndileya mukwabo Shimoni Petulo. ");
INSERT INTO sby_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Mpwalamucana shimoni mukwabo, walamwambileti, “Tulamucana Klistu, Mupulushi Walaiwa.” ");
INSERT INTO sby_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Neco walamumanta ne kuya nendi kuli Yesu. Yesu mpwalamulangishisha walambeti, “Njobe Shimoni, mwanendi Yohane, nomba lino Lina lyakobe nube Kefa.” Bupandulushi bwa maina Kefa ne Petulo, alambangeti libwe. ");
INSERT INTO sby_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Mpobwalaca Yesu walayeya shakuya ku Galileya. Walacana Filipo, ne kumwambileti, “Unkonke.” ");
INSERT INTO sby_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipo walikuba waku munshi wa Betsaida, kucomwabo Ndileya ne Petulo. ");
INSERT INTO sby_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipo walacana Nataniyele ne kumwambileti, “Tulamucana usa Mose ngwalalemba sha endiye mulibuku lya Milawo, usa bashinshimi ngobalalemba sha endiye. Yesu Mwana waYosefe, waku Nasaleti.” ");
INSERT INTO sby_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nomba Nataniyele walamwipusheti, “Sena kuNasaleti ngakufuma kantu kayina?” Filipo walakumbuleti, “Tiye ulibonene wenka.” ");
INSERT INTO sby_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu mpwalamubona Nataniyele nkesa, walambeti, “Cakubinga uyu emwana mwine mwine waku Islayele wabula bundengamano.” ");
INSERT INTO sby_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniyele walamwipusheti, “Mulanjishibi aconi?” Yesu walakumbuleti, “Pasa mpowanga wekala mwinshi mwacitondo camukuyu, Filipo katana akukuwa, ame ndalakubona.” ");
INSERT INTO sby_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniyele walambeti, “Bashikwiyisha, cakubinga njamwe Mwana Lesa, njamwe Mwami wa Islayele.” ");
INSERT INTO sby_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu walamukumbuleti, “Sena ulashomo pakwinga ndakwambilyeti ndalakubona mwinshi mwa citondo camukuyu. Nomba nubone byapita apa.” ");
INSERT INTO sby_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Kayi walambeti, “Lino cancine ncine ndakwambilingeti nukabone kwilu kwacaluka, nukabone bangelo ba Lesa nkabatanta kayi kabaseluka kwisa kuli Mwana Muntu.” ");
INSERT INTO sby_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Mpopalapita masuba abili, kwalaba bwinga ku Kana munshi walikuba mucimpansha ca Galileya. Nabo banyina Yesu balayako. ");
INSERT INTO sby_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu neye pamo ne beshikwiya bakendi balakwiwako kubwinga ubu. ");
INSERT INTO sby_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mpowalapwa waini ngobalikunwa bantu, banyina Yesu balamwambileti, “Ulabapwili waini.” ");
INSERT INTO sby_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu walakumbuleti, “Ma kamutang'ambila ncendela kwinsa, Cindi cakame nkacitana cishika.” ");
INSERT INTO sby_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Necikabeco banyina balambila basebenshi bapabwingeti, “Mwinse ciliconse nceti amwambile.” ");
INSERT INTO sby_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Lino popelapo palikuba nongo sha mabwe shisanu ne imo, balashibikapo pacebo ca mwambo wa Bayuda wakuliswepesha. Munongo iliyonse mwalikwingila menshi akwana mingomo isanu nambi kupitililapo. ");
INSERT INTO sby_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Lino Yesu walambila basa basebenshi, “Kamushani menshi munongo shonse shisule.” Naboyo balesusha mpaka pamilomo. ");
INSERT INTO sby_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Panyuma pakendi walabambileti, “Lino tekulani, mutwalile mukulene lendeleshenga bwinga.” Naboyo balamutwalila. ");
INSERT INTO sby_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mukulene wa bwinga mpwalatelela menshi asa Yesu ngalasandula kuba waini, liya kwinshiba kwalafuma waini uyo. Nomba basebenshi basa balateka menshi balikwinshiba. Lino mukulene walikwendelesha bwinga walakuwa shibwinga, ");
INSERT INTO sby_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ne kumwambileti, “Bantu bakute kutanguna kuyaba waini waina, nomba bantu bekuta, ukute kubapa waini waina pang'ana. Nomba amwe mwanga mwabika waina kushika cino cindi!” ");
INSERT INTO sby_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ici calikuba cishikunkamanisha cakutanguna Yesu ncalensa mumunshi wa Kana mucimpansha ca Galileya nkwalalesha bulemu bwakendi, neco beshikwiya bakendi balamushoma. ");
INSERT INTO sby_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Panyuma pakendi Yesu walaya ku Kapenao, pamo ne banyina ne bakwabo ne beshikwiya bakendi, nkobalakekala kwamasuba ang'ana. ");
INSERT INTO sby_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Cindi ca kusekelela Pasika wa Bayuda calaba pepi, Yesu walanyamuka kuya kuYelusalemu. ");
INSERT INTO sby_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Kopeloko walengila mulubuwa lwa Ng'anda ya Lesa walakacana bantu balolishinga ng'ombe, mbelele ne nkulimba. Kayi nabambi kabali bekala pa bipuna kabashintana mali. ");
INSERT INTO sby_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Popelapo walapanga ciswepu ca loshi ne kutatika kubatandanyina pansa bonse, pamo ne ngombe, ne mbelele shabo shonse. walawisha matebulu a bantu balikushintana mali ne mali alamwaikila panshi mbwee. ");
INSERT INTO sby_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Kayi walambila balikulisha nkulimba eti, “Bipulisheni pansa, mutaisandula Ng'anda ya Bata kuba ya kwinshilamo makwebo.” ");
INSERT INTO sby_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Beshikwiya balanuka Mabala alambangeti, “Kulibenga kwakame mung'anda yenu kulyeti mulilo ulabangilinga mukati mwakame.” ");
INSERT INTO sby_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Popelapo bamakulene ba Bayuda balamwipusheti, “Nicikankamiko cini ncoshi winse kwambeti utuleshe naukute ngofu shakwinsa bintu ibi?” ");
INSERT INTO sby_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu walabakumbuleti, “Na mwipwaye Nga'nda ya Lesa ino, nenjame nindiyibake mumasuba atatu.” ");
INSERT INTO sby_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Lino nabo balambeti, “Nga'nda ya Lesa iyi yalamanta byaka makumi ana ne byaka bisanu ne cimo pakuibaka, lino amwe ngamuibaka mumasubowa atatu?” ");
INSERT INTO sby_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nomba Ng'anda ya Lesa njalikwamba Yesu walikuba mubili wakendi. ");
INSERT INTO sby_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Mpwalapunduka kubafu, beshikwiya bakendi balanuka kwambeti walabambilapo makani awa, neco balashoma Mabala ne maswi ngalamba. ");
INSERT INTO sby_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu mpwalikuba mu Yelusalemu pakusekelela kwa Pasika, bantu bangi balamushoma pakubona bikankamisho mbyalensa. ");
INSERT INTO sby_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Nomba Yesu liya kubashoma, pakwinga walikubenshiba ncebabele bonse. ");
INSERT INTO sby_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nkalapembela kwambeti muntu umbi amwambile ncebabele bantu, pakwinga mwine walikwinshiba bili mumyoyo ya bantu. ");
INSERT INTO sby_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Muntu wamulikoto lya Bafalisi, lina lyakendi Nikodemo, mutangunishi wa Bayuda, ");
INSERT INTO sby_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","walesa kuli Yesu mashiku ne kwambeti, “Bashikwiyisha, tucinsheti njamwe shikwiyisha ngwalatutumina Lesa, pakwinga kuliya muntu wela kwinsa bingashilo byeshikukankamanisha mbyomulenshinga, na Lesa nkalipo nendi.” ");
INSERT INTO sby_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu walambeti, “Cancine ndakwambilinga kuliya muntu wela kwingila mubwami bwa Lesa na liya kusemwa cipya.” ");
INSERT INTO sby_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemo walepusheti, “Sena muntu ngosemwa kayi cipya lakulu kendi? Sena ngawingila mulibunda mubanyina ne kusemwa cipya?” ");
INSERT INTO sby_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu walamukumbuleti, “Ndakwambilinga cancine ncine kwambeti kotana wingila mu Bwami bwa Lesa citanshi kusemwa ne menshi ne Mushimu Uswepa. ");
INSERT INTO sby_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Muntu ukute kusemwa kumubili, nsombi kumushimu ukute kusemwa ne Mushimu Uswepa. ");
INSERT INTO sby_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kotakankamana pakwinga ndakwambilyeti wela kusemwa katubili. ");
INSERT INTO sby_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Lukupwe lukute kupupula kulubasu kulikonse, kayi mukute kunyumfweti lulapupulunga, nsombi nkokute kwinshiba nkolulafumunga nambi nkolulenga. Nicimo cimo ne muntu uliyense lasemwa ne Mushimu Uswepa.” ");
INSERT INTO sby_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemo walepusheti, “Ibi ngabinshika aconi?” ");
INSERT INTO sby_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu walambeti, “Sena obe ntobe shikwiyisha wenshibikwa mu islayeli, nomba nkobinshi aconi bintu ibi?” ");
INSERT INTO sby_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ndakwambilinga cancine ncine tukute kwamba mbyotwinshi, kayi tukute kupa bukamboni mbyotwalabona, nomba amwe nkamulashomonga maswi etu. ");
INSERT INTO sby_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Na nkamulashomonga mpondamwambilinga byapanshi pano, nomba ngamushoma aconi ndamwambila bintu byakwilu? ");
INSERT INTO sby_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Kuliya muntu walayako kwilu, nsombi Mwana Muntu ewalesa kufuma kwilu. ");
INSERT INTO sby_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nomba kayi mbuli Mose mucinyika musa walapacika njoka ya mukuba pelu pacitondo, copeleco neye Mwana Muntu nakanyamunwe pelu mushobomo. ");
INSERT INTO sby_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Kwambeti uliyense wamushoma akabe ne buyumi butapu. ");
INSERT INTO sby_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kayi Lesa walabasunisha bantu pacishi capanshi, ecebo cakendi walayaba Mwanendi umo enka, kwambeti uliyense eti akamushome akacane buyumi butapu. ");
INSERT INTO sby_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Lesa nkalatuma Mwanendi panshi pano, kwambeti omboloshe milandu ya bantu, nsombi kwambeti abapulushe. ");
INSERT INTO sby_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Namuntu washoma muli Yesu, Lesa nteshi akamomboloshe, nsombi abo balabulunga kushoma balomboloshewanga kendi, pakwinga nkabalashomonga Mwana wa Lesa enka. ");
INSERT INTO sby_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Lombolosho nulu lwakwambeti nekukabeti mumuni walesa pacishi capanshi bantu balasuna mushinshe, kupita mumuni pakwinga incito shabo shaipa. ");
INSERT INTO sby_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Uliyense lenshinga byaipa, wapatana ne mumuni. Kayi nkakute kwisa patuba, kutina incito shakendi shaipa kwambeti ngashibonekela. ");
INSERT INTO sby_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nsombi balenshinga byancine ncine bakute kwisa patuba, kayi bya kwinsa byabo bikute kwinshibiketi labinshi mwakunyumfwila Lesa.” ");
INSERT INTO sby_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Panyuma pakendi, Yesu ne beshikwiya bakendi balaya ku cimpansha caYudeya. Walekala nabo kwacindi citali kopeloko kabatisha bantu. ");
INSERT INTO sby_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Neye Yohane walikubatisha ku Ainoni pepi ne Salimu, pakwinga ekwalikuba menshi angi. Bantu balikushika kulyendiye, walikubabatisha. ");
INSERT INTO sby_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Pacindici Yohane walikatana uwalwa mujele. ");
INSERT INTO sby_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Beshikwiya bambi baYohane balatatika kutototekeshana ne Muyuda naumbi shamwambo wakuliswepesha. ");
INSERT INTO sby_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Neco beshikwiya basa balesa kuli Yohane ne kumwambileti, “Mwiyi bonani, muntu usa ngomwalikwamba nendi kutala kwa mulonga wa Yolodani, usa ngomwalenshila bukamboni neye labatishinga, kayi bantu bonse balafwambilinga kulyendiye.” ");
INSERT INTO sby_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohane walakumbuleti, “Muntu nkela kutambula kantu kalikonse na Lesa liya kumupa. ");
INSERT INTO sby_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Amwe ngamumbela bukamboni pakwinga mwalanyumfwa ndalambeti, Ntame Mupulushi Walaiwa, nsombi njame walatumwa pantangu pakendi. ");
INSERT INTO sby_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nyabwinga nimuka shibwinga. Nomba munendi nyabwinga emanapepi kanyumfwako ukute kukondwa anyumfwa maswi ashibwinga. Nicimo cimo nenjame kukondwa kwakame kulakwana. ");
INSERT INTO sby_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Usa welela kuba ne bulemu bunene bwapita bwakame.” ");
INSERT INTO sby_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Weshikufuma kwilu wapita bonse. Weshikufuma panshi pano niwapanshi pano, kayi ukute kwamba bya panshi pano. Weshikufuma kwilu wapita bonse. ");
INSERT INTO sby_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nendi uyu lenshinga bukamboni pa bintu mbyalabona ne kunyumfwa, nsombi paliya ukute kushoma maswi akendi. ");
INSERT INTO sby_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nsombi muntu ashoma maswi akendi, ukute kulesheti Lesa ukute kukwanilisha malayano akendi. ");
INSERT INTO sby_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Uyo Lesa ngwalatuma, ukute kwamba maswi a Lesa, pakwinga Lesa ukute kumupa Mushimu Uswepa wabula cipimo. ");
INSERT INTO sby_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Bata bamusuni mwanabo, kayi babika bintu byonse mumakasa akendi. ");
INSERT INTO sby_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Muntu lashomonga mwanoyo, ukute buyumi butapu. Nsombi lakananga kushoma mwanoyo, nteshi akabe nebuyumi, neco bukalu bwa Lesa buli palyendiye cindi conse.” ");
INSERT INTO sby_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Bafalisi balanyumfweti Yesu lasandulunga bantu bangi kuba beshikwiya ne kubabatisha kupita Yohane, ");
INSERT INTO sby_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Yesu uliya kubatishapo muntu naba umo, nsombi beshikwiya bakendi ebalikubatisha. ");
INSERT INTO sby_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesu mpwalenshiba ncebalikwamba, walafumako kuYudeya ne kubwelela ku Galileya. ");
INSERT INTO sby_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Pabulwendo bwakendi walaciboneti welela kupitila mucishi ca Samaliya. ");
INSERT INTO sby_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Lino walashika ku munshi waku Samaliya, walikukwiweti Sika, pepi ne kamusena ako Yakobo nkalapa Yosefe mwanendi. ");
INSERT INTO sby_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Kopeloko kwalikuba mukalo walikuba waYakobo. Yesu walekala panshi pambali pamukalo uyo, pakwinga walikuba laleme nemusuma. Cindi calikuba muma 12 koloko munshi. ");
INSERT INTO sby_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Mutukashi wa kuSamaliya walesakuteka menshi. Yesu walamusengeti, “kamumpako menshi akunwa.” ");
INSERT INTO sby_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Pacindi ico beshikwiya bakendi balikuba balayi akula cakulya mumunshi. ");
INSERT INTO sby_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mutukashi usa walakumbuleti, “Amwe Bayuda, nicani mulasengenga menshi kuli nde Musamaliya?” Pakwinga Bayuda nkabendelana ne Basamaliya. ");
INSERT INTO sby_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu walambeti, “Nkocishi cipo Lesa ncalayandanga kukupa, kayi nkomwinshi lakusengenga menshi akunwa, numwinshi nshinga nulamusenge menshi eshikupa buyumi.” ");
INSERT INTO sby_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mutukashi uyo walambeti, “Nkambo, muliyawa cakutekesha, kayi mukalo uyu nutali, nomba menshi eshikupa buyumi ayo nimwafunye kupeyo? ");
INSERT INTO sby_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Sena amwe mwapita bata bakulukulu balikubako ba Yakobo? uyo walashiya mukalo uyu ngalikunwamo mwine ne bana bendi kayi ne biswika byakendi.” ");
INSERT INTO sby_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu walakumbuleti, “Muntu uliyense lanunga menshi aya nakanyumfwe inyotwa kayi. ");
INSERT INTO sby_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nsombi uliyense uyo lanunga menshi ngondamupa nteshi akanyumfwepo inyotwa kayi. Pakwinga menshi ayo ngoshi nkamupe nakabeti kamulonga kansansa menshi eshikupa buyumi butapu.” ");
INSERT INTO sby_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mutukashi uyo walambeti, “Nkambo, kamumpako ayo menshi kwambeti ntakanyumfwapo nyotwa nambi ntakesa kayi kuno akuteka menshi.” ");
INSERT INTO sby_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu walambeti, “Koya ukuwe baibobe mwise,” ");
INSERT INTO sby_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mutukashi uyo walambeti, “Ndiyawa mulume.” Yesu walakumbuleti, “Ulambanga cakubinga uliyawa mulume. ");
INSERT INTO sby_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Obe walebwapo kendi kubatuloba basanu, kayi mutuloba ngoli nendi lino nte ibobe, mutukashi walambeti, mulamba cakubinga.” ");
INSERT INTO sby_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mutukashi walambeti, “Nkambo, ndacinshibi kwambeti njamwe Mushinshimi. ");
INSERT INTO sby_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Bamashali betu bakulukulu balikupaila Lesa pa mulundu uyu, nsombi amwe Bayuda mukute kwambeti kuYelusalemu ekwelela kupailila.” ");
INSERT INTO sby_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu walamwambileti, “Koshoma ncendambanga.” Cindi nicikashike nceshi mukabule kupailila Bata pa mulundu pano, nambi kuYelusalemu. ");
INSERT INTO sby_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Basamaliya mukute kupaila ngo mutenshi, afwe Bayuda tukute kupaila ngotwinshi, pakwinga lupulusho nilukacanike kupitila mu Bayuda. ");
INSERT INTO sby_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","“Nomba cindi nicikashike, kayi cilashiki kendi, bantu beshikupaila Cancine ncine mpoti bakapaile Bata mu Mushimu nemu cancine ncine. Bata bakute kuyanda bantu beshikumupaila mumushoboyo. ");
INSERT INTO sby_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Lesa ni Mushimu, neco beshikumupaila bela kumupaila mu Mushimu ne mu Cancine ncine.” ");
INSERT INTO sby_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mutukashi usa walambeti, “Ndicinsheti Klistu Mupulushi Walaiwa lakesanga, akashika, nakatwambile byonse.” ");
INSERT INTO sby_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu walamwambileti, “Ame ngolambanga nendi njame wopeloyo.” ");
INSERT INTO sby_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Pacindi copeleco beshikwiya ba Yesu balashika, nomba balakankamana mpobalacana kabandika ne mutukashi. Paliya walamwipusheti, “Ulayandanga cani” Nambi, “Nicani mulabandikinga nendi?” ");
INSERT INTO sby_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Mutukashi usa walashiya mungomo wakendi ne kuya mu munshi akwambila bantu, ");
INSERT INTO sby_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Katuyani mubone muntu lang'ambili byonse mbyondalensa. Sena ngakali usa Mupulushi Walaiwa? ");
INSERT INTO sby_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Lino bantu balayoboloka kufuma mumunshi kwisa kuli Yesu.” ");
INSERT INTO sby_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Pacindi copeleco beshikwiya ba Yesu balamusengeti, “Mwiyi, kamulyani.” ");
INSERT INTO sby_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nendi walakumbuleti, “Ame nkute cakulya amwe ncomutenshi.” ");
INSERT INTO sby_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Popelapo beshikwiya balatatika kwipushana, “Sena kuli naumbi lamuletele cakulya?” ");
INSERT INTO sby_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Nomba Yesu walambeti, “Cakulya cakame nikwinsa ibyo mbyasuni Lesa walantuma ne kupwisha mulimo wakendi.” ");
INSERT INTO sby_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mukute kwambeti, pakati pakushanga ne kutebula pali myenshi ina nambi ingi, nsombi kamulangishisha bishango bilapi kendi, bilapembelengowa kutebula. ");
INSERT INTO sby_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Musebenshi shikutebula latatiki kendi kufola, kayi labunganyanga bisepo kubuymi butapu. Neco shikushanga ne shikutebula nibakakondwe pamo. ");
INSERT INTO sby_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Neco mwambo wakwambeti, “Nabambi bakute kushanga, kayi nabambi bakute kwisa kutebula niwakubinga.” ");
INSERT INTO sby_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ndamutumunga kuya kutebula bishango mumabala alalimwa kendi ne bantu bambi. Amwe mulacaninipo pindu pa ncito yabo. ");
INSERT INTO sby_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Basamaliya bangi ba mumunshi musa balamushoma Yesu pacebo cabukamboni bwa mutukashi usa, bwakwambeti, “nendi langambili byonse mbyondalensa.” ");
INSERT INTO sby_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Lino Basamaliya mpobalashika kuli Yesu, balamusengeti ekale nabo. Neco walekala kopeloko masuba abili. ");
INSERT INTO sby_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Popelapo bantu bangi balashoma pacebo ca maswi ngobalanyumfwa kuli Yesu. ");
INSERT INTO sby_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Usa mutukashu balamwambileti, “Tulashomo lino, tuliya kushoma pacebo ca maswi akobe, nsombi pacebo cakwambeti tulalinyumfwili tobene. Tulenshibi cakubinga kwambeti uyu eMupulushi wa bantu ba pacishi capanshi conse.” ");
INSERT INTO sby_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nomba mpopalapita masuba abili, Yesu walafumako nekuya ku Galileya. ");
INSERT INTO sby_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Nomba Yesu mwine walambeti, “mushinshimi, nkakute kupewa bulemu kucomwabo.” ");
INSERT INTO sby_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Mpwalashika kuGalileya, bantu balamutambula, pakwinga balabonapo kendi byonse mbyalensa pakusekelela Pasika ku Yelusalemu pakwinga naboyo balikubako. ");
INSERT INTO sby_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kufumapo Yesu walaya kumunshi wa kana ku Galileya, kusa nkwalasandula menshi kuba waini. Kopeloko kwalikuba mukulene wamfulumende ku Kapelenaumu walikukute mwana mulwashi. ");
INSERT INTO sby_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Mpalanyumfweti Yesu lashiki kuGalileya kufuma kuYudeya, walesa kulyendiye nekumusengeti enga nendi ku Kapelenaumu, kwambeti enga ashilike mwanendi walikuba pepi kufwa. ");
INSERT INTO sby_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu walamwambileti, “wabula kubona bingashilo ne bikankamanisho, nkamushomo sobwe.” ");
INSERT INTO sby_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mukulene wa mfulumende walambeti, “Nkambo, katuyani pamo mwaname nkatanafwa.” ");
INSERT INTO sby_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu walamwambileti, “Koya mwanobe lasenguku kendi.” Muntuyo walashoma maswi a Yesu nekuya kucomwabo. ");
INSERT INTO sby_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Mpwalikuya walakumana ne basebenshi bakendi, nabo balamwambileti, “Mwanenu laba cena.” ");
INSERT INTO sby_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Walabepusha cindi ncalaba cena mwanoyo, nabo balambeti, “Watatika kunyumfwa cena lilo munshi muma 1 koloko.” ");
INSERT INTO sby_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Lino baishi mwana balanuketi ecindi Yesu mpwalabambileti, “Mwanobe lasenguku.” Neco bonse bamung'anda yakendi balamushoma. ");
INSERT INTO sby_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ici calikuba cingashilo cacibili ncalensa ku Kana, wa kuGalileya mpwalafuma ku Yudeya. ");
INSERT INTO sby_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Panyuma pakendi kwalikuba kusekelela kwa Bayuda, ku Yelusalemu neye Yesu walayako ");
INSERT INTO sby_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Lino kopeloko pepi necishinga cambelele, kwalikuba kalishiba ka menshi kalikukwiweti Betsaida mumbali mwalishiba ili mwalikuba mwebakwa tumanda tubili. ");
INSERT INTO sby_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mu tumandomo mwalikona bantu bangi balwashi, balema ne bashipilwa kayi ne bakokonyana mibili ");
INSERT INTO sby_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","(Pakwinga mungelo walikufandaula menshi, neco mulwashi walikwingila bwangu mumenshi walikushilikwa.) ");
INSERT INTO sby_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nomba pa bantu balwashi abo palikuba umbi walakolwa kwa byaka 38. ");
INSERT INTO sby_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu mpwalamubona nkali wona, waleshiba kwambeti walakolwa kwa cindi citali. Lino walamwipusheti, “Sena ulayandanga kushilikwa?” ");
INSERT INTO sby_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mulwashi uyo walambeti, “Nkambo ndiyawa muntu welakuntwala mumenshi na alafundaulwa, ndambeti njingile nkutekucana naumbi lampitili kendi.” ");
INSERT INTO sby_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu walamwambileti, “Punduka, manta mpasa yakobe, yamba kwenda.” ");
INSERT INTO sby_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Popelapo muntu uyo walashilikwa, walamanta mpasa yakendi nekuyamba kwenda. Busuba ubo bwalikuba bwa Sabata. ");
INSERT INTO sby_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Lino Bayuda balambila uyu walashilikwa, “Lelo nipa Sabata, milawo yetu nkayasuminisha kunyamuna mpasa yakobe.” ");
INSERT INTO sby_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nomba neye walambeti, “Lanshiliki elangambilyeti, ‘Nyamuna mpasa yakobe nekwenda.’” ");
INSERT INTO sby_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nabo balamwipusheti, “Niyani uyo lakwambily eti nyamuna mpasa yakobe wende?” ");
INSERT INTO sby_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nomba uyu muntu walashilikwa nkalamwinshiba walamushilikwa, pakwinga Yesu walikuba lengili mukati mwa bantu bangi abo balikuba popelapo. ");
INSERT INTO sby_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Panyuma pakendi Yesu walamucana mu Nga'nda ya Lesa, usa ngwalashilika, walamwambileti, “Bona, lino ulashilikwa, kotakensa kayi byaipa, kwambeti nkotakakolwa kayi bulwashi nabumbi bwaipa.” ");
INSERT INTO sby_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Muntu usa walaya kwambila Bayuda kwambeti Yesu elamushiliki. ");
INSERT INTO sby_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Lino batangunishi ba Bayuda balatatika kumushupa Yesu pacebo cakushilika muntu pa Sabata. ");
INSERT INTO sby_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Nsombi Yesu walabambileti, “Bata balasebensenga cindi conse mpaka lelo lino, nenjame ndelela kusebensa.” ");
INSERT INTO sby_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Makani aya alapesheti bayuda bapitilishe kupingila kushina Yesu. Balikwambeti Yesu lapwayanga mulawo wa Sabata, kayi pakwambeti ni mwana wa Lesa, walyelanishinga ne Lesa. ");
INSERT INTO sby_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Lino Yesu walambeti, “Ndamwambilinga cancine ncine kwambeti paliya ncela kwinsa Mwana palwakendi mwine. Nsombi ukute kwinsa ncalabononga baishi nkabensa. Bilenshinga baishi neye Mwana mbyakute kwinsa. ");
INSERT INTO sby_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Pakwinga baishi basuni Mwana, neco bakute kumulesha byonse nabo mbyobalenshinga. Baishi nibamuleshe mulimo wapita ibi kwambeti mubinshibe. ");
INSERT INTO sby_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mbuli Bata ncobakute kupundusha bafwa, nekubapa buyumi, copeleco Mwana lapanga buyumi kuli abo mbasuni. ");
INSERT INTO sby_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Baishi nkabakute kombolosha muntu sobwe. Nsombi balapa ngofu Mwana kwambeti abe weshikombolosha byonse. ");
INSERT INTO sby_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Bata bakute kuyandeti bantu bonse balemekenga Mwana, mbuli ncobakute kulemeka Baishi. Muntu labulunga kulemeka Mwana, nkakute kulemeka Baishi balamutuma. ");
INSERT INTO sby_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ndamwambilishingeti muntu uliyense lanyumfu maswi akame nekushoma walantuma, nakabe ne buyumi butapu. Uyo nendi nteshi akomboloshewe, nsombi lapulu kendi mu lufu, nekuya mubuyumi butapu. ");
INSERT INTO sby_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Kayi ndamwambilingeti cindi nicikashike, kayi cilashiki kendi, apo bantu bafwa mposhi bakanyumfwe maswi a Mwana wa Lesa, kayi abo beshibakanyumfwe ne bakashome nibakabe ne buyumi. ");
INSERT INTO sby_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mbuli baishi ncebalicitente ca buyumi nendi Mwana walaba citente cabuyumi. ");
INSERT INTO sby_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Neco walamupa mwana ngofu shakombolosha bantu, pakwinga ni Mwana Muntu. ");
INSERT INTO sby_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mutakankamana, pakwinga cindi nicikashike bantu bonse bali mumanda nibakanyumfwe maswi akendi nekupunduka. ");
INSERT INTO sby_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Bantu balensa byaina nibakapunduke kwambeti babe ne buyumi, nsombi balensa byaipa, nibakapunduke kwambeti bomboloshewe.” ");
INSERT INTO sby_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Ame nkandela kwinsa kantu pandenka. Nkute kombolosha mbuli ncobakute kung'ambila Bata. Kayi nkute kombolosha mubululami, pakwinga nkankute kwinsa mbyonsuni, nsombi mbyobasuni Bata balantuma. ");
INSERT INTO sby_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Na ndalinshili bukamboni, bukamboni bwakame nkabwakwana. ");
INSERT INTO sby_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nsombi kuli naumbi ukute kunjinshila bukamboni, kayi bukamboni mbwakute kunjinshila nibwancine ncine. ");
INSERT INTO sby_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Amwe mwalatuma ntumi kuli Yohane mubatishi, nendi walensa bukamboni bwakubinga. ");
INSERT INTO sby_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nteko kwambeti ame nsuni bukamboni bwa muntu, nsombi ndambanga ibi kwambeti amwe mupuluke. ");
INSERT INTO sby_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohane mubatishi walikubeti lampi yalikumunika, amwe mwalakondwa ne mumuni kwakacindi kang'ana. ");
INSERT INTO sby_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nsombi ame nkute bukamboni bwapita bwa Yohane. Bata balampa incito njondelela kwinsa, kayi incito njondenshinga iyi ilaleshengeti Bata ebalantuma. ");
INSERT INTO sby_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Kayi Bata abo balantuma, balanjinshila bukamboni. Nomba amwe muliya kunyumfwa maswi abo, nambi kubona cinso cabo. ");
INSERT INTO sby_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Maswi abo nkakute kwikala muli njamwe, pakwinga nkamukute kumushoma Bata ngobalatuma. ");
INSERT INTO sby_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mukute kubelenga Mabala a Lesa, pakwinga mukute kuyeyeti nimucanemo buyumi butapu. Nomba kayi Mabala opelayo akute kunjinshila bukamboni. ");
INSERT INTO sby_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Nomba amwe mulakananga kwisa kuli njame kwambeti mube ne buyumi. ");
INSERT INTO sby_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Nkandalangaulunga kupewa bulemu kubantu sobwe. ");
INSERT INTO sby_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nsombi ndimwinshi kwambeti amwe nkamusuni Lesa mumyoyo yenu. ");
INSERT INTO sby_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ame ndalesa mulina lya Bata, nomba amwe muliya kuntambula. Nsombi umbi esa mulina lyakendi ne kulyamba mwine uyo engomukute kutambula. ");
INSERT INTO sby_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Lino nomba nga mushomaconi na musuni owa kulumbaishiwa ne banenu, Nsombi nkamusuni kutambula bulemu mbwela kumupa Lesa? ");
INSERT INTO sby_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nomba mutayeyeti njame ndeshi nkamwambilenga byaipa kuli Bata. Weshi akamwambilenga nkwali, Mose ngomwalikuba mwashoma. ");
INSERT INTO sby_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ne mwalashoma Mose cancine ncine ne mwalanshoma ne njame, pakwinga neye walalemba makani alikwamba njame. ");
INSERT INTO sby_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nomba na nkamulashomonga mbyalalemba, nomba ngamushoma aconi maswi akame?” ");
INSERT INTO sby_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Panyuma pakendi Yesu walatampuka lwenje lwa Galileya ulo kayi lwalikukwiweti lwenje lwa Tibeliyo ");
INSERT INTO sby_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Likoto linene lyalamukonkela, pacebo cakwambeti lyalabona bingashilo byeshi kukankamanisha mbyalensa pakushilika balwashi. ");
INSERT INTO sby_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu walatanta mulundu ne kwikala panshi ne beshikwiya bakendi. ");
INSERT INTO sby_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Lino kusekelela kwa Pasika kwalaseng'ena pepi. ");
INSERT INTO sby_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Lino Yesu mpwalalangishisha, walabona likoto lyabantu linene lisa nkalisa kulyendiye. Lino nendi walepusha Filipo, “Sena ngatuya tula kupeyo cakulya cakulyesha bantu bonse aba?” ");
INSERT INTO sby_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Walepushila nsulo kwambeti amweleshe Filipo, nsombi mwine walikwinshiba cakwinsa. ");
INSERT INTO sby_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipo walakumbuleti, “Nambi mali akwana masauzande ali 200 nkelakukwana kula cakulya cakwambeti uliyense alyeko nambi pang'ana.” ");
INSERT INTO sby_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Weshikwiya wakendi umbi, lina lyakendi Ndileya, mukwabo Shimoni Petulo, walambila Yesu eti, ");
INSERT INTO sby_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Pali mutuloba pano, ukute shinkwa usanu ne tunswi tubili. Nomba sena ngatukwana bantu bonse aba?” ");
INSERT INTO sby_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu walambeti, “Bambileni bantu bekale panshi.” Popelapo palikuba mila yamwemfu ingi, nabo bantu abo balekala panshi. Batuloba bonka balikubapo balikuba bakwana 5,000. ");
INSERT INTO sby_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Lino walamanta shinkwa usa, mpwalalumba Lesa, walabayabila bantu abo balikuba bekala panshi. Walensa copeleco ne tunswi tusa, nekubayabila bantu abo mobalikuyandila. ");
INSERT INTO sby_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Bantu bonse abo mpobalekuta, Yesu walambila Beshikwiya bakendi, “Yowelani byashalanga panshi kwambeti kabitatayanikowa.” ");
INSERT INTO sby_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nomba balayowela byonse bya shinkwa usanu usa, ne kwisusha mitanga likumi ne ibili. ");
INSERT INTO sby_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Bantu basa mpobalabona ceshikukankamanisha ncalensa Yesu, balambeti, “Cancine ncine uyu nimushinshimi usa ngobalikwambeti nakese panshi pano.” ");
INSERT INTO sby_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu walenshiba kwambeti bantu abo balikuyandeti bamwikate ne kumubika pabwami cakumukakatisha. Neco walaya kayi kumulundu kwayenka. ");
INSERT INTO sby_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Mansailo, beshikwiya ba Yesu balaya ku Lwenje. ");
INSERT INTO sby_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Kopeloko balengila mubwato kwambeti batampuke lwenje kuya ku Kapelenaumu. Kwalashipa Yesu nkatana uya kulyendibo. ");
INSERT INTO sby_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Pacindici kwalikuba cipuupu cinene, neco palaba mankape pa menshi. ");
INSERT INTO sby_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Beshikwiya mpobalendako makilomita akwana atatu nambi ana, balabona Yesu nkenda pa menshi nkesa pepi kubwato bwabo, neco nabo balatina. ");
INSERT INTO sby_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Nsombi Yesu walambeti, “Njame, mutatina.” ");
INSERT INTO sby_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Lino balikuyandeti engile mubwato nomba pacindi copeleco bwato bwalashika kutala kwa Lwenje nkobalikuya. ");
INSERT INTO sby_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Lino mumene mene likoto lya bantu lyalashalila kutala kwa lwenje, lyalenshiba kwambeti panga bwato bumo. Kayi bantu balenshiba kwambeti Yesu liya kwingilamo mubwato ubo beshikwiya bakendi balaya bonka. ");
INSERT INTO sby_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Lino mato nambi alafumina ku Tibeliyasi alashika pepi ne busena bantu basa mpobalyela cakulya Mwami mpalalumba Lesa. ");
INSERT INTO sby_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Likoto lisa lyalaboneti Yesu kuliya, nabo beshikwiya bakendi kuliya, bantu bonse basa balengila mubwato busa, nekuya ku kapelenaumu akuyandaula Yesu. ");
INSERT INTO sby_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Mpobalamucana Yesu kutala kwa lwenje, balamwipusheti, “Bashikwiyisha, mwalashika lilyoni kuno?” ");
INSERT INTO sby_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu walambeti, “Kwamba cakubinga, amwe mwanangaulanga pacebo cakwambeti mwalalya cakulya nekwikuta, nteko kwambeti mwalanyumfwishisha bikankamanisho bisa ncebyalikwamba sobwe. ");
INSERT INTO sby_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kamutasebensanga kwambeti mucane cakulya cikute konongeka, nsombi musebensenga kwambeti mucane cakulya ceshikwikalilila, buyumi butapu. Mwana Muntu endiye wela kumupa cakulya copeleci, pakwinga Lesa Bata mpobalabika cinshibilo ca kusuminisha kwabo.” ");
INSERT INTO sby_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nabo balamwipusheti, “Twinse aconi kwambeti tukonke mbyalayandanga Lesa?” ");
INSERT INTO sby_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu walabakumbuleti, “Lesa ncalayandanga kwambeti mwinse nikushoma ame ndalatumwa ne Lesa.” ");
INSERT INTO sby_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Kayi balamwipusheti, “Ningamutubonesha cingashilo camushobo cini kwambeti twacibona tumushome? Nimwinsepo cani? ");
INSERT INTO sby_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Bashali betu bali kulya mana mucinyika musa, mbuli Mabala a Lesa ncalambangeti, ‘walikubapa cakulya ceshi kufuma kwilu kwambeti balye.’” ");
INSERT INTO sby_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu walambeti, “Ndamwambilinga cakubinga kwambeti nte Mose walikubapa cakulya calikufuma kwilu sobwe, nsombi ni Bata. Mbuli Bata ncabalamupanga cakulya cancine ncine pacino cindi cilafumunga kwilu. ");
INSERT INTO sby_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Pakwinga cakulya Lesa ncakute kupa, endico ceshikufuma kwilu, ceshikupa buyumi kubantu bonse ba mucishi capanshi.” ");
INSERT INTO sby_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Popelapo balambeti, “Mwami, kamutupanga cakulya ici masuba onse.” ");
INSERT INTO sby_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu walabambileti, “Njame shinkwa ceshikupa buyumi. Uliyense lesanga kuli njame nekunshoma nteshi akanyumfwe nsala. Kayi uliyense lashomonga njame, nteshi akanyumfwe nyotwa. ");
INSERT INTO sby_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mbuli ncondalamwambileti kumbona mulambononga, nsombi nkamulashomonga. ");
INSERT INTO sby_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Abo bonse mbobampa bata, nibakese kuli njame, nomba muntu uliyense lesanga kuli njame, nteshi nkamukane. ");
INSERT INTO sby_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Pakwinga ndalafuma kwilu kwisakwinsa kuyanda kwa uyo walantuma, kutambeti njinse kuyanda kwakame sobwe. ");
INSERT INTO sby_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Kuyanda kwa uyo walantuma nikwambeti mbule kutaya nambi umo pali abo mbalampa, nsombi kwambeti nkabapundushe kubafu pabusuba bwakupwililisha. ");
INSERT INTO sby_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Pakwinga Bata ncobalayandanga nikwambeti muntu uliyense lamubono Mwanoyo nekumushoma, akabe ne buyumi butapu. Kai ame ninkamupundushe kufuma kubafu pabusuba bwa kupwililisha.” ");
INSERT INTO sby_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Popelapo Bayuda nabambi balatatika kung'unung'usha cebo cakwambeti Yesu walambeti, “Ame njame shinkwa walafuma kwilu.” ");
INSERT INTO sby_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Pacebo ici balambeti, “Se uyu nte Yesu mwanendi Yosefe usa? Baishi ne banyina tubenshi. Nomba nicani lambangeti, Ndalafuma kwilu?” ");
INSERT INTO sby_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu walabakumbuleti, “Mutang'unung'ushanga pakati penu. ");
INSERT INTO sby_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Paliya wela kwisa kuli njame, nsombi Bata balantuma ebelakumuleta kuli njame. Nomba na ucikonsha kwisa kulinjame ninkamupundushe kubafu pabusuba bwa kupwililisha. ");
INSERT INTO sby_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Bashinshimi balalembeti, ‘Lesa nakamwiyishe muntu uliyense.’ Pakwinga muntu uliyense lanyumfwilinga Bata, nekwiya kulyendibo, ukute kwisa kuli njame. ");
INSERT INTO sby_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ici nkacilapandululungeti pali muntu walababonapo Bata sobwe, nsombi uyo enka walafuma kuli Lesa ewalababona. ");
INSERT INTO sby_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ndamwambilinga cakubingeti uyo lanshomonga ukute buyumi butapu. ");
INSERT INTO sby_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ame njame shinkwa ceshikupa buyumi. ");
INSERT INTO sby_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Bashali benu balikulya mana mucinyika musa, nikukabeco balafwa. ");
INSERT INTO sby_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nomba shinkwa uwu walafuma kwilu, muntu aulya nteshi akafwe. ");
INSERT INTO sby_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ame ndeshinkwa weshikupa buyumi walafuma kwilu. Na muntu uliyense ulya shinkwa uwu, nakabe nebuyumi butapu. Shinkwa weshinkamupe nimubili wakame, ngoshi nkape kwambeti bantu bonse bapacishi capanshi babe nebuyumi.” ");
INSERT INTO sby_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Popelapo Bayuda basa balatatika kutotekeshana bonka, kabambeti, “Ngatulya aconi mubili wakendi?” ");
INSERT INTO sby_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu walambeti, “Ndamwambilinga cakubinga, Na mubula kulya mubili wa Mwana Muntu nekunwa milopa yakendi, nkamwela kuba nebuyumi muli njamwe. ");
INSERT INTO sby_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Uliyense lalinga mubili wakame nekunwa milopa yakame, ukute buyumi butapu, ame ninkamupundushe kubafu pa busuba bwa kupwililisha. ");
INSERT INTO sby_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Pakwinga mubili wakame shinkwa wacancine ncine, kayi milopa yakame ecakunwa cancine ncine. ");
INSERT INTO sby_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Uliyense lalinga mubili wakame nekunwa milopa yakame ukute kwikala mulinjame, nenjame nkute kwikala mulyendiye. ");
INSERT INTO sby_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mbuli Bata bayumi balantuma, kayi nenjame ndemuyumi pakuba mulyendibo, copeleco uliyense lalinga mubili wakame, nakabe nebuyumi pakuba mulinjame. ");
INSERT INTO sby_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Shinkwa walafuma kwilu ni wopelowu. Wapusana ne mana asa bashali benu ngobalikulya, nsombi panyuma pakendi balikabafwa. Nomba lalinga shinkwa wopelowu, nakabe nebuyumi butapu.” ");
INSERT INTO sby_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu walamba ibi mpwalikwiyisha munga'nda yakupaililamo ku kapelenaumu. ");
INSERT INTO sby_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Beshikwiya bangi mpobalamunyumfwa kambeco balambeti, “Ciyo ici cayuma, niyani wela kucinyumfwishisha?” ");
INSERT INTO sby_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu walenshiba mumoyo mwakendi kwambeti beshikwiya bakendi balatongaukunga. Neco walabepusheti, “Sena mulepilwa? ");
INSERT INTO sby_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Nomba nimukense aconi mwakabona Mwana Muntu kaya kwilu nkwalikuba? ");
INSERT INTO sby_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Mushimu wa Lesa eukute kupa buyumi, mubili paliya ncokute. Maswi ngondamwambili akute kuleta mushimu wa Lesa ukute kupa buyumi. ");
INSERT INTO sby_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nomba pali nabambi pali amwe balabulunga kushoma.” Pakwinga Yesu walenshiba kendi eshakabule kumushoma, walamwinshibila limo weshakamuyabe kubalwani bakendi. ");
INSERT INTO sby_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Lino walambeti, “Weco ndamwambilingeti paliya muntu wela kwisa kuli njame na Bata baliya kumupa ngofu sha kwisa kuli njame.” ");
INSERT INTO sby_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kufumapo beshikwiya bangi ba Yesu balamushiya ne kucileka kwenda nendi. ");
INSERT INTO sby_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Lino Yesu walepusha beshikwiya likumi ne babili basa, “Nomba amwe nkamulandanga kuya?” ");
INSERT INTO sby_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Shimoni Petulo walambeti, “Mwami, nomba ngatuya kuli bani? Njamwe mukute maswi eshikupa buyumi butapu. ");
INSERT INTO sby_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Afwe twashoma kayi tucinshi kwambeti njamwe Waswepa walafuma kuli Lesa.” ");
INSERT INTO sby_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Lino Yesu walambeti, “Sena ntame ndalamusala amwe omuli likumi ne babili? Nsombi umo pali amwe ni Satana” ");
INSERT INTO sby_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Walikwamba Yuda, mwanendi Shimoni Isikalyoti. Nambi walikuba umo pali basa beshikwiya likumi ne babili, ewalamuyaba kubalwani bakendi. ");
INSERT INTO sby_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Panyuma pakendi Yesu walikwendana mucishi ca Galileya, nkalikuyanda kuya Yudeya. Pakwinga bamakulene Babayuda balikuyanda kumushina. ");
INSERT INTO sby_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Cindi cakusekelela mishasha calikuba pepi, ");
INSERT INTO sby_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","lino bakwabo Yesu balamwambileti, “Inga nicani kutaya kuYudeya kwambeti beshikwiya bakobe bakabone bikankamanisho mbyolenshinga. ");
INSERT INTO sby_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kuliya muntu ukute kusoleka mbyalenshinga na kayanda kwinshibikwa. Kwelana ne mbyolenshinga leka bantu bonse bakwinshibe.” ");
INSERT INTO sby_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nambi bamakwabo balambeco nkabali kumushoma. ");
INSERT INTO sby_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu walabambileti, “Cindi cakame nkacitana cishika, nsombi amwe mukute cindi cakuya kulikonse nkomulayandanga. ");
INSERT INTO sby_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Bantu basuni byapanshi pano nkabela kumupata, nsombi bakute kupata njame, pakwinga nkute kubalesha ncito shabo shaipa. ");
INSERT INTO sby_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Amwe kamuyani akusekelela uko. Ame nkandengonga pakwinga cindi cakame nkacina cishika.” ");
INSERT INTO sby_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yesu mpwalambeco, walashalila mu Galileya. ");
INSERT INTO sby_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nomba bamakwabo mpobalaya akusekelela mishasha isa, Yesu neye walabakonkela. Nomba liya kuyanda kubonekela kubantu. ");
INSERT INTO sby_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Bamakulene ba Bayuda balikumuyandaula uko nkobalikusekelela, nkabepushaneti, “Nomba usa muntu ulikupeyo?” ");
INSERT INTO sby_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Popelapo palikuba kunung'unusha palyendiye. Bambi balikwambeti, “Usa muntu waina”Nsombi bambi balikwambeti, “Sobwe, usa layungaulunga bantu.” ");
INSERT INTO sby_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nomba nkapalikuba muntu weshikwamba patuba sha Yesu, pakwinga balikutina Bayuda. ");
INSERT INTO sby_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Lino kusekelela mpokwalashika pakati, Yesu walaya ku Nga'nda ya Lesa nekutatika kwiyisha. ");
INSERT INTO sby_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Bamakulene ba Bayuda balakankamana nekwambeti, “Nomba muntu uyu ubinshi aconi bintu ibi pabula balamwiyishapo!” ");
INSERT INTO sby_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Nomba Yesu walambeti, “Mbyonkute kwiyisha nte byakame sobwe, nsombi bikute kufuma kuli Bata abo balantuma. ");
INSERT INTO sby_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Uliyense layandanga kwinsa kuyanda kwa Lesa, nakenshibeti kwiyisha kwakame kulafumunga kuli Lesa nteko kuli ndemwine ");
INSERT INTO sby_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Pakwinga muntu lambangowa byakendi ukute kuliyandawila bulemu. Nsombi nendi ukute bulemu bwa uyo walamutuma, wopeloyo ewancine ncine, kayi mumoyo mwakendi muliya bwipishi. ");
INSERT INTO sby_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Lino sena Mose liya kumupa Milawo ya Lesa? Nsombi paliya naba umo mulinjamwe ukute kwikonkela. Nomba nicani mulayandanga kunshina?” ");
INSERT INTO sby_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nsombi likoto lya bantu lyalamukumbuleti, “Sena ulakonyo. Layandanga kukushina niyani?” ");
INSERT INTO sby_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Nendi Yesu walabakumbuleti, “Ndalensowa ceshikukankamanisha cimo, mwense mwalakankamana.” ");
INSERT INTO sby_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","“Nte pasa Mose walamupa mulawo wa kupalula bana benu batuloba (mulawo uyo uliya kufuma kuli Mose nsombi walafuma kubamashali benu bakulukulu.) Neco mukute kupalula mwana mutuloba nambi nipa busuba bwa Sabata.” ");
INSERT INTO sby_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","“Na mwanoyo mukute kumupalula pa Sabata, nicani nkamukute kutina kupwaya mulawo wa Mose? Nomba nicani mulankalalilinga pacebo cakwambeti ndashilika muntu pabusuba bwa Sabata? ");
INSERT INTO sby_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kamucileka kombolosha kwakulanga pamenso, lino tatikani kombolosha mubululami.” ");
INSERT INTO sby_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Popelapo bantu nabambi baku Yelusalemu balambeti, “Sena muntu usa ngobalayandanga kushina, nte wopele uyu? ");
INSERT INTO sby_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nte uyu lambanga patuba, kwakubula weshikwambapo kantu kalikonse! Ekwambeti aba bantu bacinsheti eMupulushi Walaiwa? ");
INSERT INTO sby_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Mupulushi Walaiwa akesa, paliya weshakenshibe nkoshakafume. Nomba uyu tukwinshi twense nkwalafumunga.” ");
INSERT INTO sby_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Popelapo Yesu kaciyisha mu Nga'nda ya Lesa walolobesha, “Mukwinshi nkondalafuma. Nsombi ndiya kwisa palwakame sobwe. Uyo walantuma washomeka, nomba amwe nkamumwinshi. ");
INSERT INTO sby_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nsombi ame ndikwinshi, pakwinga njame ndalafuma kulyendiye, kayi endiye walantuma.” ");
INSERT INTO sby_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Popelapo bantu balayanda kumwikata Yesu, nsombi paliya nambi umo walamwikatamo, pakwinga cindi cakendi calikacitana cishika. ");
INSERT INTO sby_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Bantu bangi mulikoto ilyo balamushoma, kayi balikwambeti, “Mupulushi Walaiwa akesa, nakensepo bingashilo byapita ibi muntuyu mbyalenshi?” ");
INSERT INTO sby_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Neco Bafalisi balanyumfwa kunung'unusha kwa bantu balikwamba sha Yesu. Nomba bamakulene beshimilumbo balatuma bamalonda bamu Nga'nda ya Lesa kwambeti bamwikate. ");
INSERT INTO sby_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Lino Yesu walabambileti, “Ndi nenu kwa kacindi kang'ana kantananja kuli walantuma. ");
INSERT INTO sby_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Cakubinga nimukanyandaule, nsombi nteshi mukancane. Kayi uko nkondenga amwe nkamwela kushikako.” ");
INSERT INTO sby_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Popelapo bamakulene ba Bayuda balatatika kwipushaneti, “Uyu layandanga kuya kupeyo uko afwe nkotwela kubula kumucana? Sena layandanga kuya kuminshi ya ba Giliki kwekala bantu betu nekuya kubeyisha? ");
INSERT INTO sby_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Lambangeti, nimukanangaule nsombi nteshi mukancane, kayi eti, uko nkwalenga, amwe nkamwela kushikako. Anu maswi awa alapandululunga cani?” ");
INSERT INTO sby_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Pa busuba bunene bwakupwisha kusekelela. Yesu walemana nekwamba mwakolobesha, “Napali muntu ukute inyotwa, kesani kulinjame kwisakunwa. ");
INSERT INTO sby_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Muntu wanshoma, moyo wakendi nukabeti tumilonga twa menshi eshikupa buyumi.Mbuli Mabala a Lesa ncalambangeti, nakabeti tumilonga twa menshi” ");
INSERT INTO sby_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu walamba sha Mushimu Uswepa uyo bantu bamushoma ngoshi bakatambule. Pacindico Mushimu Uswepa walinkautana upewa kubantu, pakwinga Yesu walinkatana utambula bulemu bwakendi. ");
INSERT INTO sby_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Popelapo likoto lya bantu mpolyalanyumfwa maswi awa, nabambi balatatika kwambeti, “Cancine muntu uyu niMushinshimi.” ");
INSERT INTO sby_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Nabambi balikwambeti, “uyu eMupulushi Walaiwa usa.” Nsombi nabambi balikwambeti, “Sena Mupulushi Walaiwa ngaufuma ku Galileya sobwe! ");
INSERT INTO sby_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Mabala a Lesa alambangeti Mupulushi Walaiwa wela kufumina mu cikombo ca Mwami Dafeti, kayi wela kusemenwa mumunshi wa Betelehemu uko nkwalikwikala Dafeti” ");
INSERT INTO sby_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Lino bantu balatatika kupansana pacebo ca Yesu. ");
INSERT INTO sby_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nabambi balikuyanda kumwikata, nsombi paliya walamwikata. ");
INSERT INTO sby_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Bamalonda ba Nga'nda ya Lesa basa balabwelela kuli bamakulene beshimilumbo neBafalilsi. Nabo balepusha bamalonda basa, “nicani muliya kwisa nendi?” ");
INSERT INTO sby_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Bamalonda balakumbuleti, “Bintu uyu muntu mbyalamba paliya muntu naumbi walabyambapo sobwe.” ");
INSERT INTO sby_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Lino Bafalisi balambeti, “Sena nenjamwe lamubepe kendi? ");
INSERT INTO sby_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Sena mwalanyumfwapo kwambeti umo wabamakulene nambi Bafalisi pali wamushoma? ");
INSERT INTO sby_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nomba bantu aba baluya batainshi Milawo Lesa njalapa Mose, ecebo cakendi bashinganwa.” ");
INSERT INTO sby_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Lino Nikodemo, umo waBafalisi, usa walaya kuli Yesu kumasuba akunyuma, walabepusha banendi, ");
INSERT INTO sby_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Sena milawo yetu yasuminisha kombolosha muntu ngotutana tunyumfwapo maswi akendi kwambeti twinshibe mbyalenshi?” ");
INSERT INTO sby_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nabo balambeti, “Sena nenjobe owakuGalileya? Koya ubelenge Mabala niwinshibeti kuliya mushinshimi wela kufuma kuGalileya.” ");
INSERT INTO sby_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Popelapo bantu bonse balabwelela kucomwabo. ");
INSERT INTO sby_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Lino Yesu walaya ku mulundu wa ma olifi. ");
INSERT INTO sby_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Mumene mene walaya ku Nga'nda yaLesa. Bantu bonse balesa kulyendiye, walekala panshi nekutatika kubeyisha. ");
INSERT INTO sby_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Bafalisi neBeshiwiyisha Milawo balaleta mutukashi ngobalekata bupombo, nekumwimanika pakati pabo. ");
INSERT INTO sby_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Lino balambila Yesu, “Bashikwiyisha, mutukashuyu wacanika kapombolwa. ");
INSERT INTO sby_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Lino kwelana ne Milawo Lesa njalapa Mose mutukashi uyu wela kupwaiwa mabwe. Nomba amwe mulambangapongaconi?” ");
INSERT INTO sby_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Balamwipusha mwipusho uyu pakumwelesha kwambeti bamucaninepo mulandu. Nomba Yesu pacindi copeleco walakotama, nekutatika kulemba panshi ne munwe wakendi. ");
INSERT INTO sby_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pakupitilisha kumwipusha, Yesu walakotamuka nekubambileti, “pakati penu uyo utana kucimwapo, ayambilile kumanta libwe amupwaye mutukashi uyu.” ");
INSERT INTO sby_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Mpwalambeco, kayi walakotama nekupitilisha kulemba panshi. ");
INSERT INTO sby_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Mpobalanyumfweco bantu balatatika kufumapo umo neumo,bamakulene ebalatatikila kupalangana. Lino palashalowa mutukashi usa kaliwemana pantangu pa Yesu. ");
INSERT INTO sby_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu walakotamuka nekumwipusha, “Mutukashi obe balayikupeyo bakupanga mulandu? Sena paliya nambi umo lashalapo kukupa mulandu?” ");
INSERT INTO sby_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mutukashi walambeti, “Mwami, paliya.” Neye Yesu walamwambileti, “Nenjame nkandakupanga mulandu sobwe. Koya nsombi kuyambila lelo kotakabweshapo kwipisha.” ");
INSERT INTO sby_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Kayi Yesu walambila bantu bonse, “Ame njame mumuni ulamunikilinga bantu bonse. Muntu lankonkonga, nteshi akende mumushinshe, nsombi nakekale mu mumuni weshikupa buyumi.” ");
INSERT INTO sby_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Nabo Bafalisi balamwambileti, “Ulalinshilinga bukamboni omwine. Bukamboni ubo ntebo bwakubinga.” ");
INSERT INTO sby_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu walabakumbuleti, “Nambi ndalinshilinga bukamboni, bukamboni bwakame nibwakubinga, pakwinga ndikwinshi nkondalafuma nenkondenga. Nsombi amwe nkamukwinshi nkondalafuma, nambi nenkondenga. ");
INSERT INTO sby_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Amwe mukute kombolosha pakukonka miyeyo ya bantu. Ame nkankute kombolosha muntu uliyense. ");
INSERT INTO sby_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nsombi ndambeti ng'omboloshe, kombolosha kwakame ngakuba kwancine ncine, pakwinga nkandipo ndenka sobwe, pakwinga Bata balantuma balinenjame. ");
INSERT INTO sby_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kayi mumilawo yenu mwalembweti bukamboni bwa bantu babili nibwakubinga ");
INSERT INTO sby_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ame nkute kulinshila bukamboni, nabo Bata balantuma bakute kunjinshila bukamboni.” ");
INSERT INTO sby_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Lino nabo balamwipusheti, “Baiso abo balikupeyo?” Yesu walambeti, “Nkamunjishi, kayi ne Bata nkamubenshi. Nimunjinshi nimubenshi Bata.” ");
INSERT INTO sby_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu walamba maswi awa mpwalikwiyisha mu Nga'nda ya Lesa, mucipinda cakutambulilamo bupe bwa bantu. Paliya walamwikata, pakwinga cindi cakendi calinkacitana cishika. ");
INSERT INTO sby_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Panyuma pakendi Yesu kayi walabambileti, “Ame ndenga, nimukanangaule, nomba nkondenga amwe nkamwela kushikako nimukafwilowa mubwipishi.” ");
INSERT INTO sby_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Lino Bayuda balambeti, “Sena layandanga kulishina, pakwambeti, ‘nkondenga, nkamwela kushikako?” ");
INSERT INTO sby_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu walabambileti, “Amwe njamwe ba pacishi capanshi pano, ame ndalafuma kwilu. Amwe mobapanshi pano, nsombi ame ntame wapacishi capanshi sobwe. ");
INSERT INTO sby_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Weco ndalamwambilingeti. nimukafwile mubwipishi bwenu. Pakwinga na nkamulashomonga kwambeti njame wopeloyo lalyambanga, nimukafwile mubwipishi bwenu.” ");
INSERT INTO sby_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Lino nabo balamwipusheti, “Obe njobe bani?” Yesu walambeti, “Mbuli ncondamwambilanga pakuyamba. ");
INSERT INTO sby_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nkute bingi byakwamba nebyakumomboloshelapo. Walantuma niwancine ncine, kayi nkute kwambila bantu bapanshi pano bintu mbyendalanyumfwa kulyendiye.” ");
INSERT INTO sby_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Bantu basa baliya kwinshibeti Yesu walikwamba sha Baishi. ");
INSERT INTO sby_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Lino Yesu walabambileti, “Mwakantantika Mwana Muntu, popelapo nimukenshibeti njame wopeloyo lalyambanga. Nimukenshibe kwambeti nkankute kwinsa bintu pandenka, nkute kwamba ibyo Bata mbyobalanjiyisha. ");
INSERT INTO sby_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nsombi uyo walantuma, uli pamo nenjame. Nendi nkakute kunshiya ndenka, pakwinga cindi conse nkute kwinsa byeshi kumukondwelesha.” ");
INSERT INTO sby_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Mpobalanyumfwa Yesu nkamba makani awa, bantu bangi balamushoma. ");
INSERT INTO sby_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu walambila bantu abo balamushoma, “Na mulakonkelenga kwiyisha kwakame cindi conse, cakubinga nimube beshikwiya bakame. ");
INSERT INTO sby_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nimwinshibe cakubinga, kayi naco cakubinga nicikamusungululeni.” ");
INSERT INTO sby_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nabo balambeti, “Afwe njafwe bana ba Abulahamu, kayi nkatuna tubapo basha ba muntu uliyense. Nomba aconi ulambangeti, ‘nimukasungululwe?” ");
INSERT INTO sby_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu walabakumbuleti, “Ndamwambilinga cakubinga kwambeti muntu uliyense lenshinga bwipishi nimusha kubwipishi. ");
INSERT INTO sby_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Musha nkakute kwikalisha panga'nda ya mwami wakendi cindi conse, nsombi mwinepabo. ");
INSERT INTO sby_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Lino namwana lamusungululu, okwambeti mulasungululwa cancine ncine. ");
INSERT INTO sby_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ndicinshi kwambeti njamwe bana ba Abulahamu, nsombi mulayandanga kunshina, pakwinga nkamulasumininga maswi akame mumyoyo mwenu. ");
INSERT INTO sby_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ame nkute kwamba ibyo mbyondalabona kuli Bata, nsombi amwe mulenshinga mbyomwalanyumfwa kuli bameshenu.” ");
INSERT INTO sby_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Nabo balambeti, “Bameshetu ni Abulahamu.” Neye Yesu walabambileti, “nemuli bana ba Abulahamu, ne mulenshinga bintu mbyalikwinsa. ");
INSERT INTO sby_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nomba lino mulayandanga kunshina, ame ndamwambilinga makani akubinga ngondalanyumfwa kuli Lesa. Abulahamu liya kwinsapo bintu byamushobo uyu sobwe. ");
INSERT INTO sby_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Amwe mulenshinga ibyo bameshenu mbyobakute kwinsa.” Nabo balamwambileti, “ntafwe bana bamu bupombo sobwe, tukutowa mushali wetu umo, Lesa.” ");
INSERT INTO sby_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu walambeti, “Lesa nabanga mushali wenu, ne mwalansuna, pakwinga ndalafuma kuli Lesa, nomba lino ndikuno. Ndiya kwisa mungofu shakame, nsombi sha uyo walantuma. ");
INSERT INTO sby_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nomba nicani nkamulanyumfunga mbyondambanga? Pakwinga nkamwela kukonsha nekunyumfwa maswi akame. ");
INSERT INTO sby_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Amwe mwalafuma kuli mushali wenu Satana. Pakwinga emubepeshi kayi shikushina kufuminowa cindi cakunyuma kayi, mulyendiye muliya cancine ncine sobwe.Ambanga ukute kwambowa bya mumutwi wakendi ");
INSERT INTO sby_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nsombi ame nkute kwamba cakubinga, weco nkamulanshomonga. ");
INSERT INTO sby_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nibani pakati penu welakumpa mulandu wabwipishi? Nipacebo cini ndamwambilanga cakubinga, nkamulashomonga? ");
INSERT INTO sby_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Muntu waLesa ukute kukutika maswi a Lesa, nomba amwe mulakananga kunyumfwa, pakwinga ntamwe bantu baLesa.” ");
INSERT INTO sby_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Popelapo ba Yuda balamwipusheti, “Sena afwe nkatulambanga cakubingeti njobe wakuSamaliya, kayi wekatwa ne mushimu waipa?” ");
INSERT INTO sby_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu walambeti, “Ndiyawa mushimu waipa. Nkute kulemeka Bata, nsombi amwe nkamukute kumpa bulemu. ");
INSERT INTO sby_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nsombi nkandayandanga kulemekwa, nsombi nkwali layandangeti mpewe bulemu, kayi eukute kombolosha mubululami. ");
INSERT INTO sby_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Cakubinga ndamwambilinga muntu anyumfwa maswi akame, nteshi akafwe sobwe.” ");
INSERT INTO sby_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Lino bantu balamwambileti, “Lino tulenshibi kwambeti ukute mushimu waipa. Abulahamu nebashinshimi bonse balafwa! Nomba obe ulambangeti muntu anyumfwa makani akobe nteshi akafwe sobwe. ");
INSERT INTO sby_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Sena obe wapita Abulahamu mushali wetu mukulukulu nebashinshimi bonse balafwa? Nomba ulayeyengeti njobe bani?” ");
INSERT INTO sby_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu walambeti, “Na kandilipa bulemu, bulemubo nibwabulyo. Nomba Bata,bakute kumpa bulemu,abo nenjamwe mbomulambangeti eLesa wenu. ");
INSERT INTO sby_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Amwe muliya kumwinshiba, nsombi ame ndimwinshi, nendalambeti nkandimwinshi nendalaba mubepeshi mbuli ncemubele. Nomba ame ndimwinshi weco nkute kunyumfwa maswi akendi. ");
INSERT INTO sby_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mushali wenu mukulukulu Abulahamu walikuba walasekelela kubona kwisa kwakame. Kayi walakondwa.” ");
INSERT INTO sby_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Lino ba Yuda balamwipusheti, “Byaka byakobe nkabina bikwana nambi makumi asanu, ngowambaconi eti walamubona Abulahamu?” ");
INSERT INTO sby_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu walambeti, “Ndamwambilinga cakubinga, Abulahamu nkatanasemwa, ndalikubapo.” ");
INSERT INTO sby_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Lino mpobalanyumfweco balabwesa mabwe kwambeti bamupwaye. Nsombi Yesu walasolama ne kupita mubantu nekufuma mu Nga'nda ya Lesa. ");
INSERT INTO sby_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Lino Yesu mpwalikwenda walabona muntu walasemwa kaliwashipilwa. ");
INSERT INTO sby_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Beshikwiya bakendi balamwipusheti, “mwiyi, niyani walalubisha kwambeti muntuyu asemwe kaliwashipilwa? Sena nimwine nambi, nibashali bakendi?” ");
INSERT INTO sby_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu walambeti, “Nteko kwambeti walasemwa kaliwashipilwa cebo ca bwipishi bwakendi, nambi bwipishi bwabashali bakendi sobwe.Nsombi kwambeti Lesa apewe bulemu kupitila mumuntuyu ");
INSERT INTO sby_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nkakucili munshi twela kusebensa ncito njebalantumina Bata. Mashiku alesanga muntu wela kusebensa ");
INSERT INTO sby_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kandicili panshi pano, njame ndapanga mumuni bantu bonse.” ");
INSERT INTO sby_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Mpwalambeco, Yesu walasankila mata panshi, walakandila tumankatya nekumunanika mumenso muntu washipilwa ");
INSERT INTO sby_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Lino walamwambileti, “Koya usambe pakalishiba kaSiloyamu. Lina lyakwambeti Siloyamu lilapandululungeti mutumwa. Neco muntuyo walaya akusamba, walatatika kulanga mpwalikubwelela.” ");
INSERT INTO sby_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Popelapo baneshi nnebantu balikumubona nkasenga senga balambeti, “Sena uyu nte usa walikukute cinga cakusenga senga kaliwekala panshi?” ");
INSERT INTO sby_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bambi balambeti, “Ee endiye.” Nabambi balikwambeti, “Nteye, wakoshanakowa nendi.” Nsombi mwine walambeti, “Njame.” ");
INSERT INTO sby_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Lino bantu basa balamwipusheti, “Nomba nicani capesheti utatike kubona?” ");
INSERT INTO sby_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nendi walambeti, “Muntu usa ngobakute kukuweti Yesu, walakandila bulongo nekunanika mumenso mwakame nekung'ambileti, ‘Koya, usambe mukalishiba kaSiloamu. Mpondalasamba ndalatatika kubona.’” ");
INSERT INTO sby_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Neco basa bantu balamwipusheti, “Ingalino ulikupeyo?” Muntu usa walambeti, “Nkandikwishi nkwabele.” ");
INSERT INTO sby_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Neco balamumanta usa muntu walikuba washipilwa nekuya nendi kuli bamakulene baBafalisi, ");
INSERT INTO sby_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","pakwinga busuba mbwalakandila bulongo mbwalashilikisha muntu washipilwa bwalikuba bwaSabata ");
INSERT INTO sby_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Neco bamakulene ba Bafalisi balamwipusheti, “Obe watatika coni kubona?” Nendi walabambileti, “walananika bulongo mumenso, ndalaya akusamba, weco lino ndabononga.” ");
INSERT INTO sby_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ba falisi nabambi balambeti, “Muntuyu nkalatumwa neLesa, pakwinga nkalakonkelenga mulawo wa Sabata.” Nsombi nabambi balambeti, “Muntu shikwinsa byaipa ngawinsa byeshikukankamanisha byamushobo uyu?” Neco palaba kupansana umo ne munendi. ");
INSERT INTO sby_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kayi muntusa walikuba washipilwa Bafalisi balamwipusheti, “Nomba obe ulambangaponga aconi pali uyo lakushiliki?” Neye walambeti, “Ni Mushinshimi.” ");
INSERT INTO sby_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nomba bamakulene ba Bayuda nkabalashometi muntuyo nkalikubona nomba lino labononga, mpaka balakuwa bamashali bakendi. ");
INSERT INTO sby_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Mpobalesa balabepusheti, “Amwe uyu nimwanenu? sena nicakubinga walasemwa nkatalanga? Nomba kulabeconi kwambeti lino lakonshonga kubona?” ");
INSERT INTO sby_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Bamashali bakendi balambeti, “Ncotwinshi afwe nikwambeti uyu nimwanetu, kayi walasemwa nkatalanga. ");
INSERT INTO sby_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Lino nkatucinshi cilenshiki kwambeti atatike kubona, kayi nkatucinshi mobilenshikili. Kayi nkatumwinshi naniyani lamushiliki. Kamumwipusha mwine nimukulene.” ");
INSERT INTO sby_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Bashali balambeco cebo cakutina bamakulene baBayuda, abo balapangana kwambeti, muntu uliyense eshyakambeti Yesu eMupulushi Walaiwa, nibakamutandanye munga'nda yakupaililamo. ");
INSERT INTO sby_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Weco bashali bakendi balambeti, “nimukulene, kamumwipushani.” ");
INSERT INTO sby_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Popelapo bamakulene baBayuda balamukuwa katubilli usa muntu walikuba washipilwa, nekumwambileti, “Lumbila kuli Lesa, kayi wambe cakubinga. Afwe tucinshi kwambeti muntu usa nishikwinsa byaipa.” ");
INSERT INTO sby_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nendi walambeti, “nkandicinshi nanishikwinsa byaipa, ncenjinshi, nikwambeti nkandalikubona, nsombi lino ndabononga.” ");
INSERT INTO sby_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nabo balamwipusheti, “nomba walakwinsaconi pakukushilika?” ");
INSERT INTO sby_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nendi walabakumbuleti, “Ndamwambilikendi, nomba muliya kunyumfwa. Nomba nicani mulayandanga kubinyumfwa kayi? Mpani nenjamwe mulayandanga kuba beshikwiya bakendi?” ");
INSERT INTO sby_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Popelapo balatatika kumushingana, nekumwambileti, “Njobe shikwiya wakendi. Afwe njafwe beshikwiya baMose. ");
INSERT INTO sby_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Twashometi Lesa walambila Mose, nomba uyu nkatukwinshi nkwalafuma.” ");
INSERT INTO sby_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Muntuyo walakumbuleti, “Ndakankamananga kunyumfweti nkamukwinshi nkwalafuma, nsombi elamboneshe. ");
INSERT INTO sby_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tucinshi kwambeti Lesa nkakute kunyumfwila bantu beshikwinsa byaipa. Lesa, ukute kunyumfwila bantu bakute kumunyumfwila nekwinsa mbyalayandanga. ");
INSERT INTO sby_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kufuma kumatatikilo acishi kuliyawa muntu walanyumfwapo kwambeti muntu lashiliki muntu walasemwa kaliwashipilwa. ");
INSERT INTO sby_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Muntuyu nalabula kufuma kuli Lesa, naliyawa kucikonshya kwinsa ici cintu.” ");
INSERT INTO sby_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Lino nabo balambeti, “Obe walasemwa mubwipishi. Ulayandanga kutwiyisha?” Mpobalambeco balamutandanya mung'anda yakupaililamo. ");
INSERT INTO sby_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu mpwalanyumfweti bamakulene baBayuda balamutandanya munga'nda yakupaililamo usa walikuba washipilwa mpwalamucana walamwipusheti, “Wamushoma Mwana Muntu?” ");
INSERT INTO sby_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nendi walambeti, “Mwami, ng'ambileni niyani kwambeti ndimushome!” ");
INSERT INTO sby_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu walamwambileti, “Ulamubono kendi, endiye lambanga nenjobe.” ");
INSERT INTO sby_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Neye walamusuntamina nekwambeti, “Mwami, ndashomo.” ");
INSERT INTO sby_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Lino Yesu walambeti, “Lombolosho ndondaleshila nikwambeti batabono babone, balabononga bashipilwe.” ");
INSERT INTO sby_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Bafalisi nabambi balikuba pepi, mpobalanyumfweco balamwipusheti, “Sena nenjafwe twashipilwa?” ");
INSERT INTO sby_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu walambeti, “Nemwanga mwashipilwa, nemuliya mulandu. Nsombi pakwinga mulalyambangeti, mulabononga, ekwambeti mucikute mulandu.” ");
INSERT INTO sby_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Panyuma pakendi Yesu walambeti, “Ndamwambilinga cakubinga, muntu labulunga kwingilila pacishinga cambelele nikabwalala kayi nikapondo. ");
INSERT INTO sby_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nsombi muntu lengililinga pacishinga endiye mwembeshi wa mbelele. ");
INSERT INTO sby_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mulonda ukute kumucalwila. Mbelele shikute kunyumfwa maswi akendi, kayi ukute kushikuwa maina mbelele shakendi, nekushipulisha. ");
INSERT INTO sby_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ashipulisha ukute kushitangunina, nashoyo shikute kumukonkela, pakwinga shikute kwinshiba maswi akendi. ");
INSERT INTO sby_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mwensu nkashela kumukonkela sobwe, pakwinga nkashainshi maswi a mwensu. Neco shikute kumufwamba.” ");
INSERT INTO sby_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu walabambila mukoshano uyu, nsombi nabo baliyakunyumfwishisha ncalikubambila. ");
INSERT INTO sby_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ecebo cakendi kayi Yesu ncalabambilileti, “Ndamwambilinga cakubinga, ame njame cishinga cambelele. ");
INSERT INTO sby_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bonse balesa kantanjisa nibakabwalala kayi nibakapondo, neco mbelele shiliya kubanyumfwila. ");
INSERT INTO sby_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Njame cishinga, bonse balengilinga kupitila mulinjame nibakapuluke. Kupitila mulinjame nibakengilenga ne kupula nekucana cakulya. ");
INSERT INTO sby_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Nsombi nendi kabwalala ukute kwishila kwiba, kushina ne kononga. Nomba ame nkandipo ico, ndalesa kupa bantu buyumi, kayi bwakwaninina.” ");
INSERT INTO sby_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ame njame mwembeshi waina. Mwembeshi waina ukute kutaya buyumi bwakendi pacebo cambelele shakendi. ");
INSERT INTO sby_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nomba mwembeshi wakwingisha ncito yakwembela mbelele nte mwembeshi waina pakwinga nte mwine neco abona kaumpe ukute kushishiya nekufwamba, nomba nako kaumpe kakute kwikatapo nashimbi kayi shilashala shikute kupalangana. ");
INSERT INTO sby_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Usa shikulembwa incito ukute kufwamba, pakwinga ntemwinesho, neco nkakute kusukama. ");
INSERT INTO sby_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ame njame mwembeshi waina. Mbelele shakame ndishinshi, kayi nashoyo shinjishi. ");
INSERT INTO sby_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","mbuli bata ncobanjishi, nenjame ndibenshi, ndalibambila kutaya buyumi bwakame pacebo cambelele shakame. ");
INSERT INTO sby_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Kayi nkute nashimbi mbelele shabula kuba shamucata ici. Nashoyo nishikanyumfwe maswi akame, ninkashilete pamo,nishikabe mulitanga limo kayi ne mwembeshi umo. ");
INSERT INTO sby_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Bata bansuni, pakwinga ndalibambila kuyaba buyumi bwakame kwambeti nkabe nabo kayi. ");
INSERT INTO sby_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kuliya muntu wela kundamuna buyumi bwakame, ndabuyabanga mukuyanda kwakame. Nkute ngofu shakutaya buyumi bwakame, kayi ne ngofu shakubumanta. uwu emulawo ngobalampa Bata.” ");
INSERT INTO sby_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Bantu balatatika kupansana pacebo ca maswi awa. ");
INSERT INTO sby_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bangi pakati pabo balikwambeti, “Ukute mushimu waipa, kayi wakonya. Nicani mulamunyumfwilinga?” ");
INSERT INTO sby_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Nomba bambi balikwambeti, “Maswi awa ntewo amuntu wekatwa ne mushimu waipa. Sena mushimu waipa ngaumubonesha washipilwa kwambeti abone?” ");
INSERT INTO sby_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Lino calikuba cindi camupewo pakusekekelela kupwa kwa kwibaka Ng'anda ya Lesa ku Yelusalemu. ");
INSERT INTO sby_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Lino Yesu walinkenda mumukushi wa Nga'nda ya Lesa, walikukwiweti mukushi waSolomoni. ");
INSERT INTO sby_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Lino bamakulene baYuda balamubunganina nekumwipusheti, “Nomba nukatuyubwilile lilyoni nanjobe Mupulushi Walaiwa? Twambile.” ");
INSERT INTO sby_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu walambeti, “Ndalamwambila kendi, nsombi nkamulashomonga. Mulimo ngonkute kwinsa mulina lya Bata, eukute kunjishila bukamboni. ");
INSERT INTO sby_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nomba amwe nkamulashomonga, pakwinga nkamulipo mulikoto lyambelele shakame. ");
INSERT INTO sby_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mbelele shakame shikute kunyumfwa maswi akame. Ame ndishinshi, kayi shikute kunkonkela. ");
INSERT INTO sby_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nkute kushipa buyumi butapu, kayi nteshi shikataike. Paliya muntu wela kundamuna. ");
INSERT INTO sby_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Bata balampa mbelele isho banene kupita bonse, neco paliya muntu wela kubalamuna mumakasa abo. ");
INSERT INTO sby_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ame neBata tobamo muntu umowa.” ");
INSERT INTO sby_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Lino bamakulene baBayuda balabwesa mabwe kwambeti bamupwaye. ");
INSERT INTO sby_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu walabambileti, “Ndamuboneshe mulimo waina walafumina kuli Bata. Nomba nipa ncito shipeyo nshomulayandanga kumpwaila mabwe?” ");
INSERT INTO sby_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Bamakulene ba Baciyuda balamukumbuleti, “Nkatulayandanga kukupwaya mabwe pacebo ca mulimo waina sobwe, nsombi pacebo cakwambeti ulanyanshanga Lesa. Obe omuntu, ulalyelanikinga neLesa.” ");
INSERT INTO sby_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu walabakumbuleti, “Sena mu Milawo yenu nkamwalembweti, ‘Ame ndambeti mobalesa? ");
INSERT INTO sby_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Tucinsheti Mabala a Lesa nkela kupwaiwa. Kayi nakubinga, naLesa walikubakuwa, balapewa maswi wakendi eti balesa.” ");
INSERT INTO sby_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","“Ngamwabaconi uyo Lesa ngwalaswepesha nekumutuma pacishi capanshi, amwe mulamwambilingeti lanyanshanga Lesa, sena nipacebo cakwambeti njame Mwana wa Lesa? ");
INSERT INTO sby_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nomba na nkandenshinga mulimo ngobalampa Bata, kamutanshoma. ");
INSERT INTO sby_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nsombi na emulimo ngondenshinga, kamushomani mulimo nambi nkamulanshomonga kwambeti mukonshe kwinshiba nekunyumfwishisha kwambeti ame nkute kwikala muli Bata, nabo Bata bakute kwikala muli njame.” ");
INSERT INTO sby_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Popelapo bantu basa balayanda kayi kumwikata, nsombi neye walapushumuka. ");
INSERT INTO sby_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu walabwelela kayi kutala kwa mulonga wa Yolodani uko Yohane nkwalikubatishila bantu pakuyamba, lino walekala kopeloko. ");
INSERT INTO sby_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bantu bangi balesa kulyendiye, nkabambeti, “Yohane liya kwinsapo byeshikukankamanisha sobwe, nsombi byonse mbyalikwamba pamuntu uyu byalikuba byakubinga.” ");
INSERT INTO sby_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Kopeloko bantu bangi balashoma Yesu. ");
INSERT INTO sby_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","muntu walikukwiweti Lazaro, walakolwa, walikwikala mumunshi waBetaniya, kucomwabo Maliya ne Malita. ");
INSERT INTO sby_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Uyu Maliya endiye usa walananika mafuta anunkila kumyendo yaMwami nekumupukutisha mishishi yakendi. Lazaro walikuba mukwabo Maliya Lazalo ewalikukolwa. ");
INSERT INTO sby_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lino bamakwabo batukashi balatuma mulumbe kuli Yesu kumwambileti, “Mwami, munenu ngomusuni nimulwashi.” ");
INSERT INTO sby_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu mpalanyumfwa walambeti, “Kukolwa uko nteshi kumushine Lazalo sobwe, nsombi cilenshiki kwambeti Lesa alemekwe, kayi kwambeti Mwanendi Lesa apewe bulemu.” ");
INSERT INTO sby_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu walikusuna Malita nekanike wakendi, kayi neLazalo. ");
INSERT INTO sby_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Nomba mpalanyumfwa shamalwashi, Yesu walekala masuba abili pamusena popelapo mpwalikuba. ");
INSERT INTO sby_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Panyuma pakendi walambila beshikwiya bakendi, “katuyani kuYudeya.” ");
INSERT INTO sby_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Beshikwiya bakendi balambeti, “Mwiyi, lino apa bamakulene baBayuda nkabayanda kumupwaya mabwe, Inga nicani mulayandanga kubwelelako?” ");
INSERT INTO sby_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu walambeti, “Sena busuba ntebukute mifunshya yacindi likumi ne ibili? Muntu nalendenga mu mumuni nkela kulisuntula pakwinga ukute kubona mumuni wacishici. ");
INSERT INTO sby_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nsombi nalendenga mashiku empwela kulisuntula, pakwinga nkalendenga mu mumuni.” ");
INSERT INTO sby_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Mpwalambeco walabambileti, “Lazalo, munetu lono tulo, nsombi ndenga akumupundusha kutulo.” ");
INSERT INTO sby_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Beshikwiya bakendi balambeti, “Mwami, nawona tulo, nabe cena.” ");
INSERT INTO sby_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Balo balikuyeyeti walikwamba shatulowa, nsombi Yesu walikwambeti Lazalo wafwa. ");
INSERT INTO sby_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Lino Yesu walabambila mwakutasoleketi, “Lazalo lafu, ");
INSERT INTO sby_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nkandabangonga, nsombi ndakondwa cebo canjamwe kwambeti mushome. Katuyani.” ");
INSERT INTO sby_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Popelapo Tomasi, walikukwiweti mpundu, walambila beshikwiya banendi, “Katuyani nendi tuyetufwile pamo.” ");
INSERT INTO sby_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu mpwalashika kuBetaniya walacaneti Lazalo wabikwa kendi mumanda masuba ana alapiti. ");
INSERT INTO sby_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Munshi waBetaniya walikuba pepi neku Yelusalemu, musuma wakwanowa makilomita atatu. ");
INSERT INTO sby_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ecebo cakendi kwalikuba bantu bangi balesa kuli Malita ne Maliya kwisakubatontosha pacebo ca lufu lwa Lazalo mukwabo. ");
INSERT INTO sby_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Malita mpwalanyumfeti Yesu lesanga, walayakumucinsha. Nomba Maliya walashala munga'nda. ");
INSERT INTO sby_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Lino Malita walambila Yesu, “Mwami, nemwanga kuno mukwetu Lazalo naliya kufwa. ");
INSERT INTO sby_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nsombi nambi lino ndicinsheti Lesa namupeni ciliconse ncomwela kumumusenga.” ");
INSERT INTO sby_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu walamwambileti, “Mukwenu napunduke.” ");
INSERT INTO sby_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Malita walambeti, “Ndicinsheti nakapunduke pa busuba bwakupwililisha bantu bonse bakapundukanga.” ");
INSERT INTO sby_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu walamwambileti, “weshikupundusha bantu kubafu nekupa buyumi njame. Muntu washoma ame, nambi ufwa nakabe ne buyumi. ");
INSERT INTO sby_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Kayi abo bayumi banshoma nteshi bakafwe sobwe. Sena ulashomonga?” ");
INSERT INTO sby_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Nendi walambeti, “Cakubinga Mwami, ndashomeshesha njamwe Mupulushi Walaiwa, Mwana wa Lesa, walikuyandika kwisa pacishi capanshi.” ");
INSERT INTO sby_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Malita mpwalambeco, walamukuwa Maliya kanike wakendi kumbali nekumwambileti, “Lashiki Shikwiyisha, lakukunga.” ");
INSERT INTO sby_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maliya mpwalanyumfwa bwite, walanyamuka bwangu bwangu, nekwisa kuli Yesu. ");
INSERT INTO sby_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Pacindici Yesu walinkatana ashika mumunshi, nsombi walikacili pamusena mpobalakumana ne Malita. ");
INSERT INTO sby_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Nomba bantu balikuba munga'nda kabatontosha Maliya, mpobalaboneti lanyamuku bwangu bwangu kufuma mung'anda, balamukonka. Balikuyeyeti lenga akulilila kumanda. ");
INSERT INTO sby_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maliya mpwalashika palikuba Yesu, nekumubona, walaliwisha panshi kumyendo kwakendi nekwambeti, “Mwami, nemwanga kuno, mukwetu naliya kufwa.” ");
INSERT INTO sby_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu mpwalabona Maliya kalila kayi nebantu balikubapo nkabalila, walekatwa kumoyo kayi calamubaba. ");
INSERT INTO sby_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Lino walabepusheti, “Mwalamubika kupeyo?” Balambeti, “Mwami, katuyani mukubone.” ");
INSERT INTO sby_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu walalila. ");
INSERT INTO sby_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Popelapo bantu basa balambeti, “bonani, ncanga wamusuna.” ");
INSERT INTO sby_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nomba nabambi pakati pabo balambeti, “Muntuyu walashilika muntu washipilwa usa, Inga walalilwaconi kushinkilila Lazalo kwambeti nkatafwa?” ");
INSERT INTO sby_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu walikacililila mucali, mpwalikuya kumanda. Lino manda alikuba amuliceni, pacishinga pa manda palikuba cilibwe. ");
INSERT INTO sby_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Lino walambeti, “Cifunyeni cilibweco.” Malita, mukwabo Lazalo walafwa, walamwambileti, “Mwami latatiki kendi kununka, pakwinga palapiti masuba ana.” ");
INSERT INTO sby_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu walamwipusheti, “Sena ndiya kukwambileti washoma nubone bulemu bwaLesa?” ");
INSERT INTO sby_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Lino bantu mpobalafunya cilibwe cisa. Yesu walalanga kwilu nekwambeti, “Ta, ndamulumbunga kwambeti mukute kunkumbula ndasenganga. ");
INSERT INTO sby_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ndicinshi kwambeti mukute kunyumfwa cindi conse. Lino ndambangeci pacebo calikoto lyabantu balipano kwambeti, bashometi njamwe mwalantuma.” ");
INSERT INTO sby_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Mpwalambeco walakuwa mwakolobesheti, “Lazaro, pula!” ");
INSERT INTO sby_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Popelapo muntu usa walikuba wafwa walapula kenda kaliwapombailwa bikwisa byamalila kumakasa mpaka kumyendo,cikwisa cimbi calikuba cafwekelela kumenso. Yesu walabambileti, “Mupombololeni, kayi mumuleke ende.” ");
INSERT INTO sby_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Bangi bantu balamushindikila Maliya, balabona bintu mbyalensa Yesu balamushoma. ");
INSERT INTO sby_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nsombi Bayuda nabambi balaya kuli bamakulene baBafalisi, kuyakubambila byonse Yesu mbyalensa. ");
INSERT INTO sby_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Lino bamakulene beshimilumbo neBaFalisi balakuwa nkuta inene ya Bayuda, nekwipushaneti, “Nitwinseconi lino, pakwinga muntuyu lenshinga byeshikukankamanisha bingi? ");
INSERT INTO sby_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Twamulekelela bantu bonse nibamushome, nomba Baloma nibakese bakatonongele Ng'anda ya Lesa, kayi ne mushobo wetu.” ");
INSERT INTO sby_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nsombi umo pakati pabo, lina lyakendi Kayafa, mukulene wa beshimilumbo bonse mucaka ico, walabambileti, “Mwatabila aconi amwe! ");
INSERT INTO sby_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Sena amwe nkamulabonongeti caina kwambeti muntu umo afwile bantu bonse, kupita kwambeti mushobo wonse wonongeke?” ");
INSERT INTO sby_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Cakubinga kwamba kulico nkakwalikuba kwamumano akendi sobwe. Pakwinga walikuba Shimilumbo Mukulene, walikushinshima kwambeti Yesu nakafwile mushobo wa bantu. ");
INSERT INTO sby_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Cakubinga nteko kwambeti kubafwila bonkowa nsombi, kubunganya pamo bana baLesa balamwaika. ");
INSERT INTO sby_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kufumina busa busuba bamakulene ba Bayuda balatatika kupangana sha kushina Yesu. ");
INSERT INTO sby_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Weco Yesu nkalikwenda pantangalala pakati pabantu. Nomba walafumako nekuya kucishi calikuba pepi necinyika, kumunshi walikukwiweti Efulemu, nkwalekala kopeloko pamo nebeshikwiya bakendi. ");
INSERT INTO sby_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Kusekelela kwa Pasika kwalaseng'ena pepi. Neco bantu bangi beshikufuma kuminshi balaya ku Yelusalemu kucika cakuliswepesha, Pasika nkayitana iyamba. ");
INSERT INTO sby_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Balikumulangaula Yesu, lino mpobalabungana mu Nga'nda ya Lesa balepushaneti “Sena amwe mulayeyengaconi? Sena lesanga ku Pasika kuno?” ");
INSERT INTO sby_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nomba bamakulene beshimilumbo neBafalisi balambeti uliyense lenshibi kuli Yesu, atwinshibishe kwambeti bamwikate. ");
INSERT INTO sby_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Mpokwalashala masuba asanu nebumo kwambeti Pasika ishike, Yesu walaya ku Betaniya, uko kwalikuba Lazalo usa ngwalapundusha kubafu. ");
INSERT INTO sby_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Balamubambila cakulya cakulemeka Yesu, ico Malita ncalabanyamfwilisha kutebeta. Lazalo walikubapo mpobalikulya pamo ne Yesu. ");
INSERT INTO sby_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Lino Maliya walamanta libotolo lyamafuta anunkila nado, adula cikamba nekutatika kunanika myendo ya Yesu, kapukutisha nemishishi yakendi. Lino bantu balikuba mung'anda balanyumfwa bwema bwamafutayo. ");
INSERT INTO sby_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nomba Yuda Isikalioti, umo wa beshikwiya baYesu, uyo panyuma pakendi walamuyaba kubalwani bakendi, walambeti, ");
INSERT INTO sby_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Nomba nicani mafuta awa uliya kwaulisha mali a muwayawaya akwana 300 kwambeti apewe kubantu bapenga?” ");
INSERT INTO sby_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Uku nkakwalikuba kwambeti usuni bapenga sobwe, nsombi pacebo cakwambeti walikuba kabwalala. Nendi ewalikusunga mali nekwibamo. ");
INSERT INTO sby_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesu walambeti, “mulekeni abike mafuta awa kushikila busuba bwa kubikwa mumanda kwakame. ");
INSERT INTO sby_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Pakwinga bantu bapenga nimubenga nabo cindi conse, nomba ame nteshi mubenganga pamo nenjame cindi conse.” ");
INSERT INTO sby_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Bantu bangi mpobalanyumfweti Yesu uli kuBetaniya, nabo balayako. Baliya kuya pacebo caYesu enka sobwe, nsombi balayakubona Lazaro ngwalapundusha kubafu. ");
INSERT INTO sby_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Weco bamakulene beshimilumbo balapangana shakwambeti Lazaro neye bamushine, ");
INSERT INTO sby_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Pakwinga pacebo ca Lazaro bantu bangi bali kubashiya nekushoma Yesu. ");
INSERT INTO sby_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Busuba bwalakonkapo bantu bangi balesa akusekelela Pasika, balanyumfweti Yesu lesanga kuYelusalemu. ");
INSERT INTO sby_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Neco balamanta misampi yamalala nekuya akukumana nendi. Kabolobesheti, “Bulemu kuli Lesa! Walelekwa uyo lesanga mulina lya Mwami! Alelekwe Mwami wa Islaeli!” ");
INSERT INTO sby_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu walatanta mwana wa mbongolo ngobalamuletela, mbuli Mabala ncalambangeti, ");
INSERT INTO sby_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Kotatina, obe munshi wa Siyoni. “Bona, Mwami wakobe lesanga, watanta mwana wa mbongolo.” ");
INSERT INTO sby_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Pacindico beshikwiya bakendi baliya kunyumfwishisha. Nsombi Yesu mpwalapunduka nebulemu, empobalanuka kwambeti ibi byalembwa muMabala byalikwamba endiye, nekwambeti balamwinshila bintu ibi. ");
INSERT INTO sby_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Bantu balikuba neYesu mpwalakuwa Lazaro mumanda nekumupundusha kubafu nabo balapitilisha kwamba pabintu mbyobalabona. ");
INSERT INTO sby_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ecebo cakendi bantu ncebalayilakukumana nendi, pakwinga balanyumfwa ceshikukankamanisha ncalensa. ");
INSERT INTO sby_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Popelapo Bafalisi balatatika kwambilaneti, “Bonani afwe paliya ncetulenshinga, pakwinga bantu bonse balafwambilinga kulyendiye.” ");
INSERT INTO sby_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nomba kwalikuba Bagiliki nabambi pakati pabantu balaya kuYelusalemu akupaila pacindi cakusekelela. ");
INSERT INTO sby_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ba Giliki balayakubona Filipo, waku Betisaida muGalileya. Balamusengeti, “nkambo tulayandanga kubona Yesu.” ");
INSERT INTO sby_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipo walambila Ndileya, bonse babili balaya akwambila Yesu. ");
INSERT INTO sby_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu walambeti, “Cilashiki cindi cakwambeti Mwana Muntu atambule bulemu bwakendi. ");
INSERT INTO sby_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kwamba cakubinga, imbuto ya witi yabula kubyalwa mubulongo nekufwa ikute kaili imo imo. Nomba yafukilwa, ikute kukula nekusema bisepo bingi. ");
INSERT INTO sby_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Muntu usuni buyumi bwakendi, nakabutaye, nsombi uyo utabusuni buyumi bwakendi mucishi cino nakapewe buyumi butapu. ");
INSERT INTO sby_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Muntu layandanga kunsebensela, ankonkele, kwambeti musebenshi wakame akabe nenjame kulikonse nkotinkabenga. Muntu asebensela ame, Bata nibakamupe bulemu.” ");
INSERT INTO sby_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Lino ndapengenga mumoyo. Nomba ng'ambe cani? Sena ng'ambeti, ‘Bata kamumpulusha pacindici ku mapensho alesanga pantangu? Nomba sobwe, pakwinga encondaleshila. ");
INSERT INTO sby_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Bata kamulemekani Lina lyenu.” Popelapo kwalanyumfwika Maswi kwilu akwambeti, “ndalilemeke, kayi nimpitilishe kulilemeka.” ");
INSERT INTO sby_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Lino likoto linene lyabantu mpolyalanyumfwa maswi awo, balambeti, “Nimukunkumo wa mfula.” Nomba nabambi balambeti, “Nimungelo wambanga nendi.” ");
INSERT INTO sby_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesu walabambileti, “Maswi aliyakunyumfwika pacebo ca Njame sobwe, nsombi nakumunyamfwa. ");
INSERT INTO sby_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Lino ecindi cakwambeti cishi capanshi comboloshewe. Lino Satana, mwami wa cishi capanshi, Lesa namuwale kunsa. ");
INSERT INTO sby_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nomba ndakanyamunwa pelu, ninkabunganye bantu bonse kuli njame.” ");
INSERT INTO sby_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu walamba maswi awa kwambeti abaleshe mushobo walufu ndoshi akafwe nalo. ");
INSERT INTO sby_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Bantu basa balamwambileti, “Milawo yetu ikute kwambeti Mupulushi Walaiwa nakabengapongowa. Nomba amwe mulambilingeti Mwana Muntu welela kunyamunwa pelu Mwana Muntu wopeloyo niyani?” ");
INSERT INTO sby_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Lino Yesu walambeti, “Mumuni ucili pakati penu kwacindi cing'ana. Kamwendani, mu mumuni nkauciliko, mushinshe nkautamukoma. Pakwinga uliyense lendenga mumushinshe nkakute kwinshiba nkwalenga. ");
INSERT INTO sby_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kamushomani mumuni kaucili nenjamwe kwambeti mube bantu bamunikilwa.” Yesu mpwalapwisha kwamba makani awa walafumapo nekuya kumusena nkobatenshi. ");
INSERT INTO sby_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nambi Yesu walensa byeshikukankamanisha bingi, nsombi nabo baliya kumushoma. ");
INSERT INTO sby_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ici calenshika mbuli ncalamba mushinshimi Yesaya, “Mwami, niyani lashomo kukambauka kwetu? Niyani labono ngofu sha Mwami?” ");
INSERT INTO sby_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Neco nkamwalashoma pakwinga mbuli Yesaya kayi walambeti, ");
INSERT INTO sby_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Lesa walabapofola menso, nekuyumisha mitwi yabo, cakwambeti menso abo nkacikonsho kubona, nambi kwishiba nemyoyo yabo. Nambi kusandukila kuli njame kwambeti ndibasengule.” ");
INSERT INTO sby_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yesaya mpwalikwamba maswi awa, walikwamba sha Yesu, pacebo cakwambeti walabona bulemu bwakendi. ");
INSERT INTO sby_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nomba nikukabeco batangunishi babo bangi balashoma Yesu. Nsombi pacebo ca kutina Bafalisi kwambeti ngababatandanya mu libungano, nkabalikwambila bantu patuba. ");
INSERT INTO sby_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Balikusuna kulumbwa kubantu kupita kulumbwa ne Lesa. ");
INSERT INTO sby_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Neco Yesu walamba mwakolobesheti, “Muntu lanshomonga, nkalashomonga ame ndenka sobwe, nsombi lashomonga uyo walantuma. ");
INSERT INTO sby_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Kayi muntu labononga ame, labononga uyo walantuma. ");
INSERT INTO sby_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ame njame mumuni, kayi ndalesa panshi pano, kwambeti uliyense lanshomo akabule kwikala mumushinshe. ");
INSERT INTO sby_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Muntu anyumfwa maswi akame nomba ubula kwanyumfwa, nteshinkamomboloshe pakwinga ndiya kwisa kombolosha cishi, nsombi kwisa kupulusha. ");
INSERT INTO sby_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Muntu lankananga, kayi labulunga kutambula maswi akame, mpwali weshakamomboloshe. Maswi ngondamba eshakamupeshe mulandu pa busuba bwakupwililisha! ");
INSERT INTO sby_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ici nicakubinga pakwinga nkankute kwambowa bintu mukuyeya kwakame, nsombi Bata balantuma ebalang'ambila byakwamba, ne mwakwambila. ");
INSERT INTO sby_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Kayi ndicinsheti milawo njalampa ikute kupa buyumi butapu. Weco mbyonkute kwamba, nkute kwamba Bata ncobalang'ambila.” ");
INSERT INTO sby_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Kusekelela kwa Pasika mpokwalikuba pepi, Yesu walenshibeti cindi cakwambeti afume pacishi capanshi kuya kuBaishi cilashiki. Nendi walikubasuna bantu bakendi pacishi capanshi, walabasunishisha cakupwililila. ");
INSERT INTO sby_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Pacindi Yesu ne beshikwiya bakendi mpobalikulya cakulya camansailo, Satana walikuba labiki kendi mumoyo wa Yudasi, mwana wa Simoni Isikariote, miyeyo yakwambeti amuyabe Yesu kubalwani bakendi. ");
INSERT INTO sby_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu walikwinshiba kwambeti Baishi balamupa ngofu pabintu byonse. Kayi kwambeti walafumina kuli Lesa, kayi lakenga kuBaishi. ");
INSERT INTO sby_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Neco pacindi ncobalikulya walemana nekufulula mwinjila wakendi wakunsa nekumanta cikwisa cakupukutisha nekucisunga mubukome. ");
INSERT INTO sby_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Mpwalenseco waletila menshi mumbale, nekutatika kusambisha myendo yabeshikwiya bakendi, nkabapukuta necikwisa cisa ncalasunga mubukome. ");
INSERT INTO sby_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Mpwalashika pali Simoni Petulo, nendi walambeti, “Mwami, sena ngamunsambisha kumyendo?” ");
INSERT INTO sby_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu walamukumbuleti, “Ncondenshinga nkocinshi, nsombi nukenshibe kuntangu.” ");
INSERT INTO sby_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petulo walambeti, “Nteshi munsambishe kumyendo sobwe.” Yesu walamukumbuleti, “Na mbule kukusambisha, ekwambeti ntobe weshikwiya wakame.” ");
INSERT INTO sby_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoni Petulo walambeti, “Mwami, nanico kamutasambishowa myendo nsombi kumakasa kayi nekumutwi.” ");
INSERT INTO sby_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu walamwambileti, “Muntu lasamba mubili wonse ukute kuswepa cilayandikinga nikusambowa kumyendo konka. Mwense mulaswepe kufunyakowa umo.” ");
INSERT INTO sby_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu walambeco pakwinga walikwinshiba kendi uyo weshakamuyabe, encalambileti, “Mwense mulaswepe kufunyakowa umo.” ");
INSERT INTO sby_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesu mpwalapwisha kubasambisha kumyendo, walafwala cakufwala cakendi capelu nekubwelela mpwalikuba ekala. Lino walabepusheti, “Sena muleshibi ncondenshili cisa? ");
INSERT INTO sby_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Amwe mukute kunkuweti, ‘Mwiyi’ Nambi ‘Mwami.’ Ee mwela kwambeco, pakwinga njame. ");
INSERT INTO sby_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nomba ame ndeMwami kayi Shikwiyisha wenu, ndamusambishi kumyendo yenu, ekwambeti nenjamwe mwelela kusambishana kumyendo. ");
INSERT INTO sby_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Lino ndamupa cilesho, kwambeti nenjamwe mwelela kwinshila nabambi mbuli ncondamwinshili. ");
INSERT INTO sby_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ndamwambilinga cakubingeti, kuliya musebenshi wapita mwami wakendi, kayi kuliya mutumwa wapita walamutuma. ");
INSERT INTO sby_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Lino mpomulenshibi bintu ibi, Lesa nakamuleleke na mukacinsenga. ");
INSERT INTO sby_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Maswi awa nkandambilinga mwense sobwe, pakwinga ndibenshi abo mbondalasala. Ibi bilenshiki mbuli Mabala a Lesa ncalambangeti, ‘Uyo walikulyela mumbale yakame walambukila.’ ");
INSERT INTO sby_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ndamwambililinga limo ibi nkabitana binshika, kwambeti mukashometi, cakubinga njame. ");
INSERT INTO sby_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nomba ndambilishingeti uliyense latambulunga mbondatumunga, latambulunga njame. Kayi lantambulunga, latambulumga walantuma.” ");
INSERT INTO sby_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu mpwalambeco, walatatika kupenshewa mumoyo nekubambileti, “Ndamwambilinga cakubinga umo pakati penu nanjabe kubalwani bakame.” ");
INSERT INTO sby_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Beshikwiya bakendi balatatika kulangana, kutenshibeti lambanga bani. ");
INSERT INTO sby_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yesu walikuba wekala pepi shikwiya ngwalikusuna. ");
INSERT INTO sby_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Lino Simoni Petulo walamukuwa nemakasa shikwiya uyo nekumwambileti, “Bepushe nomba balambanga ani?” ");
INSERT INTO sby_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Popelapo shikwiya walikuba pepi walamuyamina Yesu, nekumwipusheti, “Mwami, nomba mulambanga ani?” ");
INSERT INTO sby_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu walakumbuleti, “Uyo ngoshimpe shinkwa ngweshinsunse mumbale.” Lino mpwalapwa kusunsa walapa Yuda Isikaliote mwanendi Simoni Isikaliote. ");
INSERT INTO sby_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yuda mpwalatambulowa shinkwa Satana walamwingila, popelapo Yesu walamwambileti, “Koya winse bintu mbyolayandanga kwinsa mwakufwambana.” ");
INSERT INTO sby_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Necikabeco, paliya naba umo pakati abo mbwalikulya nabo walenshiba ncalamwambilila mushoboyo. ");
INSERT INTO sby_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Nomba pacebo cakwambeti Yuda ewalikusunga mali, beshikwiya balayeyeti lamutumunga kuya kula byakulya byalikuyandika pabusuba bwa Pasika, nambi byakupa bantu bapenga. ");
INSERT INTO sby_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yudasi mpwalatambula shinkwa usa,walapula pansa, kayi kwalikuba kulashipi kendi. ");
INSERT INTO sby_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudasi mpwalapula, Yesu walambeti, “Lino Mwana Muntu napewe bulemu, Kayi mulyendiye Lesa nalemekeshewe. ");
INSERT INTO sby_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Lino na Lesa lalemekwa kupitila muMwanendi, ekwambeti, nendi Lesa nakamulemeke Mwanendi, kayi ecilenshikinga pacino cindi. ");
INSERT INTO sby_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Mobana bame, ndinenu kwakacindi kang'ana, nimukanangaule, nsombi ndamwambilinga ncondalambila bamakulene ba Bayuda, ‘Nkondenga ame, amwe nkamwela kushikako.’ ");
INSERT INTO sby_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Lino ndamupanga mulawo walino lino, wakwambeti musunanenga, mbuli mondamusunina, nenjamwe kamusunananga. ");
INSERT INTO sby_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Pakwinga namusunanenga, bantu bonse nibakenshibeti njamwe beshikwiya bakame.” ");
INSERT INTO sby_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoni Petulo walamwipusha Yesu, “Mwami, mulenga kupeyo?” Yesu walambeti, “Nkandela kuya pamo nenjobe sobwe, nsombi nukankonkele mumasuba akuntangu.” ");
INSERT INTO sby_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petulo walamwipusheti, “Mwami, ingacelakunkanisha kumukonka lino nicani? Ame ndalibambila kuyaba buyumi bwakame pacebo cenu.” ");
INSERT INTO sby_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Lino Yesu walambeti, “Sena walibambila kuyaba buyumi bwakobe pacebo cakame! Cakubinga ndakwambilinga kombwe nkatana alila nunkaneti nkonjishi mankanda atatu.” ");
INSERT INTO sby_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu walambila beshikwiya bakendi, “Myoyo yenu kaitashupika. Kamushomani Lesa, kayi mushome nenjame. ");
INSERT INTO sby_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","munga'nda muli Bata muli bipinda bingi yakwikalamo necabula kubeco, nendalamwambila. Ndenga akumubambila misena. ");
INSERT INTO sby_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Lino ndakapwisha kumubambila misena, ninkabwele kwisakumumanta, kwambeti mukabenga nkweshinkabenga. ");
INSERT INTO sby_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Cakubinga nkondenga mukwinshi, nenshila muyinshi.” ");
INSERT INTO sby_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasi walambeti, “Mwami, nkatukwinshi nkomulenga, nomba nshila yakwilako ngatuyinshibaconi?” ");
INSERT INTO sby_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu walamukumbuleti, “ame njame nshila, kayi njame cancine ncine nebuyumi. Paliya muntu welakuya kuli Bata, kwakubula kupitila muli njame. ");
INSERT INTO sby_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Pakwinga nemunjishi, nemwabeshiba Bata. Kufumina lelo mulabenshibi kayi mulababono.” ");
INSERT INTO sby_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipo walambeti, “Mwami tulesheni Bata kwambeti tushome.” ");
INSERT INTO sby_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu walamukumbuleti, “Filipo, ndekala nenu cindi citali, nomba nkotana unjinshiba? Labono ame elababono Bata. Nomba nicani ulambangeti, ‘Kotulesha Baiso? ");
INSERT INTO sby_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Sena nkaulashomonga kwambeti ame nkute kwikala muli Bata, kayi Bata bakute kwikala muli njame? Maswi ngonkute kumwambila nkakute kufuma kuli njame ndenka sobwe, nsombi Bata abakute kwikala muli njame, endibo bakute kwinsa bintu byonsebi. ");
INSERT INTO sby_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kamunshomani kwambeti ame nkute kwikala muli Bata kayi Bata bakute kwikala muli njame. Nanteco, shomani ncito shakame. ");
INSERT INTO sby_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Cakubinga ndambilishingeti uyo lanshomonga mulimo ngondenshinga nendi nakawinse, pakwinga ndenga kuli Bata neco nendi nakense byapita pali ibi. ");
INSERT INTO sby_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Neco ciliconse ncoshimukasenge muLina lyakame, ninkacinse kwambeti Bata bakapewe bulemu kupitila mu Mwanabo. ");
INSERT INTO sby_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ninkense ciliconse ncoshi mukasenge muLina lyakame.” ");
INSERT INTO sby_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Na munsuni, konkelani milawo yakame. ");
INSERT INTO sby_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Lino ninkasenge Bata kwambeti, bakamupe weshikumunyamfwilisha naumbi uyo eshakekale nenu masuba onse. ");
INSERT INTO sby_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Mushimu Uswepa nukamuleshe cancine ncine. Cishi nkacela kumutambula sobwe, pakwinga nkacimubono kayi nkacimwinshi. Nsombi amwe mumwinshi, pakwinga ukute kwikala muli njamwe, kayi nakekale muli njamwe kwacindi conse. ");
INSERT INTO sby_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Nteshi ndimushiyeti bana banshiwa. Ninkese kayi kuli njamwe. ");
INSERT INTO sby_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kulashalowa kacindi kang'ana, cishi capanshi nteshi cikambonepo nsombi amwe nimukambone. Pakwinga ndemuyumi, nenjamwe nimukabe bayumi. ");
INSERT INTO sby_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Pabusuba ubo nimukenshibeti Bata, nenjame tuli muntu umo, kayi amwe nenjame tuli muntu umo. ");
INSERT INTO sby_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Muntu latambulunga milawo yakame nekwikonka, endiye unsuni. Kayi uyo unsuni ame, Bata nibakamusune. Nenjame ninkamusune, kayi nakenshibe ncombele.” ");
INSERT INTO sby_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuda naumbi, kutamba usa Yuda Iskaliote sobwe, walamwipusheti, “Mwami nomba ngamuliyubululaconi kuli njafwe kwakubula kuliyubulula ku cishi capanshi?” ");
INSERT INTO sby_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu walambeti, uyo unsuni, nakakonke ciyisho cakame. Nabo Bata nibakamusune, ame ne Bata nitukekale mulyendiye. ");
INSERT INTO sby_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Muntu utansuni, nteshakakonkele ciyisho cakame. Maswi awa ngomulanyumfunga nteyo akame sobwe, nsombi na Bata balantuma. ");
INSERT INTO sby_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ndamwambilililimo nkandicili nenjamwe. ");
INSERT INTO sby_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nsombi usa weshikunyamfwilisha, Mushimu Uswepa uyo Bata ngoshibakatume mulina lyakame, endiye weshakamwiyishe byonse, kayi nakamwanusheni byonse ibyo mbyondalamwambila kandicili nenjamwe. ");
INSERT INTO sby_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ndamupanga lumuno. Lumuno ndondelela kumupa. Ndamupanga lumuno lwapusana nelumuno ndocela kupa cishi capanshi. Neco myoyo yenu itashupika nambi kutina. ");
INSERT INTO sby_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mulanyumfu mpondamwambilangeti, ndenga, nsombi ndakesanga kayi kuli njamwe. Nemunsuni, nemulakondwa kwambeti ndenga kuli Bata, pakwinga Bata bampita. ");
INSERT INTO sby_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ndamwambilililimo bintu ibi nkabitana binshika, kwambeti byakenshika, mukashome. ");
INSERT INTO sby_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nteshi mpitilishe kwamba nenjamwe pakwinga Satana mwami wa cishi capanshi, lesanga. Nomba uliya ngofu palinjame, ");
INSERT INTO sby_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Nomba bantu bonse bela kwinshiba kwambeti ame nsuni Bata, weco ndenshinga ncobalang'ambila. “Lino kamunyamuka twenga.” ");
INSERT INTO sby_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ame njame citondo ca vaini, nomba Bata ebalimi. ");
INSERT INTO sby_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nabo bakute kutimbula misampi iliyonse mulinjame itaseme bisepo. Nomba misampi ikutekusema bisepo Bata bakute kwibambilila cena kwambeti ikate bisepo bingi. ");
INSERT INTO sby_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Amwe mulapenselwa kayi mulaswepe kendi pacebo ca maswi ngondalamwambila. ");
INSERT INTO sby_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kamwikalililani mulinjame kayi nenjame ninkekalilile muli njamwe. Kuliyawa musampi wabulakwikata kucinyina welakwikata bisepo. Copeleco nenjamwe nkamwela kwikata bisepo nankamulekalilinga muli njame. ");
INSERT INTO sby_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ame njame citondo cancine ncine ca vaini nomba amwe njamwe misampi. Muntu uliyense eshakekalilile mulinjame, nenjame mulyendiye nakekate bisepo bingi. Weco kwakubula njame kuliyawa ncomwela kwinsa. ");
INSERT INTO sby_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Namuntu nkalekalanga mulinjame, nakawalwe kunseti misampi yatemwa, ikute kuyuma. Misampi yamushoboyo ikute kubunganishiwa nekuwalwa mumulilo nekutentwa. ");
INSERT INTO sby_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Namulekala mulinjame, kayi maswi akame ekala mulinjamwe, ngamunsenga ciliconse ncomwela kuyanda, nimukapewe. ");
INSERT INTO sby_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Bata bakute kulemekeshewa namulekata bisepo bingi, kayi cikute kulesheti njamwe beshikwiya bakame bancine ncine. ");
INSERT INTO sby_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mbuli Bata ncobansuni, nenjame ndimusuni amwe. Mwikalenga mu lusuno lwakame. ");
INSERT INTO sby_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Namukonkelenga milawo yakame, nimwikalenga mulusuno lwakame, mbuli ame nconkute kukonkela milawo ya Bata nekwikalilila mulusuno lwabo. ");
INSERT INTO sby_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Ndamwambili ibi kwambeti kukondwa kwakame kube muli njamwe kayi kwambeti kukondwa kwenu kube kwakwana. ");
INSERT INTO sby_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Mulawo wakame niwakwambeti musunanenga mbuli ncondimusuni. ");
INSERT INTO sby_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kuliya muntu ukute lusuno lwapita ulu lwakutaya buyumi bwakendi pacebo cabanendi. ");
INSERT INTO sby_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Namulakonkelenga kwiyisha kwakame ekwambeti njamwe mobaname. ");
INSERT INTO sby_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nteshi ndimukuwengeti basebenshi sobwe pakwinga musebenshi nkakute kwinshiba bilenshinga mwami wakendi. Nsombi ndamukungeti baname, pacebo cakwambeti byonse mbyondalanyumfwa kuli Bata ndalamwambila. ");
INSERT INTO sby_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ntamwe mwalansala sobwe, nsombi njame ndalamusala. Kayi ndalamupatula kwambeti mukekate bisepo bitalobo. Neco ciliconse ncoshimukasenge kuli Bata mulina lyakame nibakamupe. ");
INSERT INTO sby_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Neco mulawo wakame niwakwambeti musunanenga. ");
INSERT INTO sby_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Na cishi capanshi cikamupate, mukanuke kwambeti calatatikila kupata njame. ");
INSERT INTO sby_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nemwekalangeti bantu bamucishi nebalamusuna, nomba pacebo cakwambeti ntamwe bamucishi capanshi sobwe. Nomba bamupela pakwinga ame ndalamusala pakati pabo, weco ntamwe banabo sobwe. ");
INSERT INTO sby_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kamwanukanga maswi asa ngondalamwambileti, ‘Musebenshi nkapiti mwami wakendi.’ Na balampensha, nenjamwe nibakamupenshe. Na balanyumfwa maswi akame, nibakanyumfwe maswi enu. ");
INSERT INTO sby_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nsombi nibakamwinshile bintu mbyobalenshila kulinjame, pakwinga nkabamwinshi walantuma. ");
INSERT INTO sby_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nendalabula kwisa kubeyisha, nebalabula kuba nemulandu. Nomba lino paliyawa mpobela kukanina mulandu wabo. ");
INSERT INTO sby_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Muntu lapatananga nenjame, lapatananga neBata. ");
INSERT INTO sby_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nendalabula kwinsa bintu pakati pabo bitana binshiwapo nemuntu uliyense, cakubinga nebalakabulu kuba nemulandu. Nomba pakwinga balabibona, nsombi bapata ame neBata. ");
INSERT INTO sby_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nomba byalenshika mushoboyo mbuli ncecalembwa mulibuku lyabo lya milawo kwambeti, ‘Balapatana nenjame kwakubula mulandu.’ ");
INSERT INTO sby_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Shikumunyamfwa lakesanga, uyo ni Mushimu weshukayubulule cancine ncine cilambanga shaBata, Ninkamutumine, nendi uyo akesa nakambele bukamboni. ");
INSERT INTO sby_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nenjamwe nimukambele bukamboni, pakwinga mulekala nenjame kufuma kumatatikilo.” ");
INSERT INTO sby_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ndamwambili makani awa kwambeti mutakatyompwa. ");
INSERT INTO sby_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Lino nibakamutandanye mu mandakupaililamo.Kayi cindi nicikashike cakwambeti bantu beshibakamushinenga nibakayeyengeti balasebenselenga Lesa. ");
INSERT INTO sby_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nibakense bintu bilico pacebo cakwambeti nkababenshi Bata kayi nenjame nkabanjinshi. ");
INSERT INTO sby_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nsombi ndamwambililinga limo bintu ibi kwambeti cindi cakashika mukanuketi ndalamwambilapo kendi. Ndiya kumwambila bintu ibi pakuyamba pakwinga ndalikuba nenu.” ");
INSERT INTO sby_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nomba lino ndenga kuli Bata balantuma, nsombi paliya nambi umo lanjipushunga kwambeti, “Ulenga kupeyo.” ");
INSERT INTO sby_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","“Nomba mumyoyo yenu mulesulu miyeyo yakungumana pacebo ca bintu mbyondamwambili. ");
INSERT INTO sby_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nsombi ndamwambilinga cakubinga, caina kuli njamwe kwambeti ame njenga. Pakwinga nankandenga, munyamfwilishi usa nteshi akese kuli njamwe. Nsombi ndaya ninkamutume kulinjamwe. ");
INSERT INTO sby_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Lino akesa shikumunyamfwa nakababoneshe bantu ba panshi pano pabwipishi bwabo nepabululami, kayi nekombolosha kwa Mwami Lesa. ");
INSERT INTO sby_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Bacimwa pacebo cakwipa kwabo pakwinga nkabashomo mulinjame. ");
INSERT INTO sby_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Bacimwa pamakani abululami pakwinga ndenga kuli Bata kayi nteshi mukambonepo sobwe. ");
INSERT INTO sby_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Bacimwa pashakombolosha, pakwinga Lesa lamombolosho kendi mwami lendeleshenga cishi cino. ");
INSERT INTO sby_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Nkute Maswi angi akumwambila nsombi nkamwela kwanyumfwishisha sobwe. ");
INSERT INTO sby_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nsombi wakashika Mushimu nukamwiyishe byancine ncine. Pakwinga Nteshi ukambenga bintu byakuliyandila sobwe, nsombi bintu ibyo Bata mbyoshibakamwambilenga, endibyo mbyoshi ukambenga. Kayi nukamwiyishe bintu byakuntangu. ");
INSERT INTO sby_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nukampe bulemu pakwinga nukamante bintu kufuma kulinjame nekwisa kumwambila. ");
INSERT INTO sby_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Bintu byonse byaBata nibyakame. Weco ndamwambilingeti nukamante bilafumunga kuli njame nekwisa kumwambila. ");
INSERT INTO sby_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Kwacindi cing'ana nteshi mukambone, nsombi pakapita kacindi cing'anowa nimukambone.” ");
INSERT INTO sby_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Beshikwiya bakendi nabambi balatatika kwipushaneti, “Nomba nicani ncalatwambilinga? Lambangeti, ‘Kwacindi cing'anowa nteshi mukambone.’ Kayi lambangeti, ‘pakwinga ndenga kuli Bata.’ ");
INSERT INTO sby_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Nomba inga cilapandululunga cani, ‘Kwacindi cing'ana’ Nkatulanyumfwishishinga mbyalayandanga kutwambila.” ");
INSERT INTO sby_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu walenshibeti balayandanga kumwipusha, neco walabambileti, sena mulepushanyanga pamakani ngondamwambileti, kwakacindi kang'ana nteshi mukambonepo, nsombi pakapita kacindi kang'ana kayi nimukambone? ");
INSERT INTO sby_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ndamwambilinga cakubinga kwambeti nimukalile kayi nimukongumane, nsombi cishi nicikasekelele. Amwe nimukongumane, nsombi kungumana kwenu panyuma pakendi nikukabe kusekelela. ");
INSERT INTO sby_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Lino pacindi cakupulukamo mutukashi ukute kushupika pacebo cakwambeti cindi cilashiki. Nomba mwana asemwa nkakute nekuyeyako shakushupika, pakwinga kukute kuba kusekelela kwambeti mwana lasemwa. ");
INSERT INTO sby_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nenjamwe mulashupikinga lino, nsombi ninkamubone kayi. Popelapo myoyo yenu nikasekelele, kayi paliya muntu weshakamulamune kukondwa kwenu. ");
INSERT INTO sby_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Pabusuba ubo nteti mukayande kunjipusha.necikabeco ndamwambilinga cakubinga kwambeti Bata nibakamupe ciliconse nceshi mukasenge mulina lyakame. ");
INSERT INTO sby_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kushikila lelo nkamuna musengapo cintu mulina lyakame. Nomba lino mwela kusenga mulina lyakame, neco, nimukapewe, kwambeti kukondwa kwenu kube kwakwana.” ");
INSERT INTO sby_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ndamwambili bintu ibi mumapinda. Cindi nicikashike mposhinkambe pantangalala shaBata, ntetinkambepo mumapinda sobwe. ");
INSERT INTO sby_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Busuba ubo nimukasenge kupitila mulina lyakame, ntetikukayandiketi ndimusengele kuli Bata sobwe. ");
INSERT INTO sby_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Bata bamusuni pakwinga munsuni, kayi mwanshometi ndalafuma kuliBata. ");
INSERT INTO sby_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ndalafuma kuli Bata kwisa panshi pano. Lino kayi ndafumunga panshi pano kuya kuliBata. ");
INSERT INTO sby_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Beshikwiya bakendi balambeti, “Lino mulambanga mwakunyumfwika, kutamba mumapinda sobwe. ");
INSERT INTO sby_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Lino tulenshibi kwambeti mubinshi byonse, neco nkatwela kumwipusha. Weco lino tulashomo kwambeti mwalafuma kuli Lesa.” ");
INSERT INTO sby_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu walabakumbuleti, “Sena lino empomulashomo? ");
INSERT INTO sby_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Cindi nicishike, kayi cilashiki kendi, nceshimumwaike uliyense kuya kwabo, nimunshiye ndenka. Nsombi nkandipo ndenka sobwe pakwinga Bata bali nenjame. ");
INSERT INTO sby_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ndamwambili bintu ibi kwambeti mube neLumuno pakushoma njame. Cishi nicikamupenshe nsombi kamuyumani pakwinga ame ndacikomo cishi capanshi.” ");
INSERT INTO sby_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu mpwalamba bintu ibi, walalanga kwilu nekwambeti, “Cindi cilashiki Ta. Kamumupani bulemu mwanenu, kwambeti nendi Mwanenu amupe bulemu. ");
INSERT INTO sby_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Pakwinga mwalamupa ngofu shakwendelesha bantu bonse kwambeti ape buyumi butapu kuli bonse mbomwalamupa. ");
INSERT INTO sby_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Buyumi butapu nikwinshiba njamwe kayi neYesu Klistu ngomwalatuma. ");
INSERT INTO sby_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ndamuletele bulemu pacishi capanshi pakupwisha mulimo ngomwalantuma. ");
INSERT INTO sby_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Neco Ta kamumpani bulemu pacino cindi ncendesanga kulinjamwe. Bulemu busa mbondalikukute kacitana cilengwa cishi.” ");
INSERT INTO sby_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Balamwishibi cena abo mbomwalampa pano pacishicapanshi, balikuba benu, nsombi mwalampa. Kayi balakonka maswi enu. ");
INSERT INTO sby_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Lino bacinshi kwambeti byonse mbyomwalampa byalafuma kulinjamwe. ");
INSERT INTO sby_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Pakwinga ndalabeisha maswi ngomwalangambila kayi balatambula. Neco bacinshi kwambeti ndalafuma kuli njamwe, kayi bashoma kwambeti njamwe mwalantuma. ");
INSERT INTO sby_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ndabapaililinga. Nkandapaililinga cishi capanshi sobwe, nsombi ndapaililinga abo mbomwalampa pakwinga nibenu. ");
INSERT INTO sby_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Byonse mbyonkute nibyenu, kayi byenu byonse nibyakame, neco nkute kupewa bulemu mulyendibo. ");
INSERT INTO sby_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Lino ndesanga kulinjamwe. Nteshi mbenganga mucishi capanshi sobwe, ndesanga kulinjamwe, nsombi nabo mobacili. Ta omwaswepa kamubasunga mulina lyenu ndyomwalampa, kwambeti babeti umo mbuli njafwe ncetuli umo ");
INSERT INTO sby_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Mpondalikuba nabo, ndalikubasunga nengofu nshomwalampa. Ndalabacingilila cena kayi kuliya nambi umo walataika, kufunyakowa usa walikuba welela kutaika, kwambeti byonse byalalembwa binshike. ");
INSERT INTO sby_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Lino ndesanga kuli njamwe. Ndambanga bintu ibi nkandicili panshi pano kwambeti, kukondwa kwakame kwisule mumyoyo yabo. ");
INSERT INTO sby_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ndabeyishi maswi enu. nsombi cishi cilabapata, pakwinga nabo baliya cibusa necishi capanshi, mbuli ame ncondababula cibusa ne cishi capanshi. ");
INSERT INTO sby_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nkandasengenga kwambeti mubafunye mucishi capanshi sobwe, nsombi kwambeti mubacingilile kumulwani. ");
INSERT INTO sby_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nabo ntebo bapacishi capanshi, mbuli ame ncendabula kuba wapa cishi capanshi. ");
INSERT INTO sby_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mubaswepeshe necancine ncine kwambeti babe benu. Maswi enu ecanci ncine. ");
INSERT INTO sby_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mbuli ncemwalantuma ame pacishi capanshi pano, nenjame ndabatumu pacishi capanshi pano. ");
INSERT INTO sby_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Pacebo cabo ndalibenge kuli njamwe, kwambeti nabo balibenge kuli njamwe mucancine ncine.” ");
INSERT INTO sby_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Nkandapaililinga aba bonka sobwe, nsombi bonse beshibakanshome pacebo ca mulumbe wabo. ");
INSERT INTO sby_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ndabapaililinga kwambeti bonse bakabebamo. Mbuli amwe Ta ncomuli mulinjame, kayi nenjame ndimulinjamwe nabo bekale muli njafwe. Neco bantu bonse bakashome kwambeti mwalantuma. ");
INSERT INTO sby_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ndabapa bulemu mbomwalampa, kwambeti babe bamo, babe mbuli afwe ncetuli bamo. ");
INSERT INTO sby_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ame njikale mulyendibo, nenjamwe muli njame kwambeti babe bamo cancine ncine. Neco bantu bonse nibakenshibe kwambeti njamwe mwalantuma, kayi mubasuni mbuli ncomunsuni. ");
INSERT INTO sby_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ndandangeti, abo mbomwalampa babe pamo nenjame uko nkoshi nkabe. Ndandangeti babone bulemu bwakame mbomwalampa, pakwinga mwalansuna kendi nkacitana cilengwa cishi capanshi. ");
INSERT INTO sby_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Omwalulama Ta, cishi capanshi ciliya kumwinshiba sobwe, nsombi ame ndimwinshi, kayi aba bacinsheti njamwe mwalantuma. ");
INSERT INTO sby_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ndalabenshibisha Lina lyenu, kayi ninkapitilishe kubeyisha kwambeti lusuno ndomukute palinjame lube mulyendibo, kwambeti nenjame mbe mulyendibo. ");
INSERT INTO sby_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu mpwalapwisha kwamba walaya pamo nebeshikwiya bakendi kutala kwa cisapa ca Kedroni, nkobalakengila mulibala lya bitondo bya maolifi, ");
INSERT INTO sby_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Uko Yesu nebeshikwiya bakendi nkobalikukumanina cindi conse. Neco Yuda walamuyaba walikwishiba musena wopelowo. ");
INSERT INTO sby_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yuda walanyamuka pamo nebashilikali baku Loma nebamalonda baku Nga'nda ya Lesa abo balatumwa nebamakulene beshimilumbo neBafalisi. Nabo balaya kulibala uko kabalibamanta malampi ne nsakamwenge kayi ne byensho byankondo. ");
INSERT INTO sby_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Nomba Yesu walikwinshiba byeshibimwinshikile. Weco nendi walemana patuba, nekubepusheti, “Nomba mulayandanga bani?” ");
INSERT INTO sby_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Balamukumbuleti, “tulayandanga Yesu waku Nasaleti.” Yesu walambeti, “Njame.” Yuda walamuyaba kubalwani bakendi, neye walikubapo. ");
INSERT INTO sby_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesu mpwalabakumbuleti, “Njame,” Balabwelela kunyuma nekuwa panshi. ");
INSERT INTO sby_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Kayi Yesu walabepusha, “Nomba mulayandanga bani?” Nabo balambeti, “tulandanga Yesu wa ku nazaleti.” ");
INSERT INTO sby_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu walambeti, “Ndamwambili eti njame, nomba na mulayandanga njame, aba balekeni bayenga.” ");
INSERT INTO sby_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Walambeco kwambeti bikwanilishiwe mbyalambeti, “Ndiya kutayapo naba umo pali abo mbomwalampa.” ");
INSERT INTO sby_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Shimoni Petulo walikukute cingwebe. Walasokolola nekukwempula litwi lyakululyo lya Makasi musebenshi wa shimilumbo mukulene. ");
INSERT INTO sby_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Lino Yesu walambila Petulo, “Bwesha cingwebe cakobe mumukopa. Sena ulayeyengeti mbule kunwa nkomeshi ya mapensho njobalampa Bata?” ");
INSERT INTO sby_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Mushilikali mukulene nebashilikali bakendi, kayi nebamalondabamuNg'anda ya Lesa, balamwikata Yesu nekumusunga. ");
INSERT INTO sby_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Pakutanguna balaya nendi kuli Anasi, mupongoshi wa Kayafa, walikuba mukulene wa beshimilumbo bonse mucaka copeleco. ");
INSERT INTO sby_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafa eusa walambila bamakulene baBayuda kumasuba akunyuma kwambeti caina namuntu umo ufwa kupita kwambeti bantu bonse bafwe. ");
INSERT INTO sby_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Shimoni Petulo neshikwiya naumbi balamukonkela Yesu. Shikwiya naumbi uyo walikuba wenshibana neshimilumbo mukulene. Lino walengila pamo ne Yesu munga'nda ya shimilumbo mukulene. ");
INSERT INTO sby_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Nsombi Petulo walemana kunsa pepi necishinga, usa shikwiya walikuba wenshibikwa walapula nekuya kwamba nemutukashi pacishinga kwambeti ambile Petulo engile, ");
INSERT INTO sby_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nomba mutukashi musebenshi walepusha Petulo, “Sena obe ntobe umo wa beshikwiya bamuntuyu?” Petulo walambeti, “Ame? Sobwe.” ");
INSERT INTO sby_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kwalikuba kwatontola, neco basebenshi ne bamalonda balakunka mulilo ngobalikuyota bwimene,neye Petulo walayakwimanapo kayota mulilo. ");
INSERT INTO sby_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Pacindi copeleco shimilumbo mukulene walepusha Yesu sha beshikwiya bakendi, kayi nebintu mbyalikwiyisha. ");
INSERT INTO sby_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu walambeti, “Ame ndalikwamba mwakutasoleka ku muntu uliyense. Ndalikwiyisha mumanda akupaililamo kayi ne mu Nga'nda ya Lesa, bantu bonse mobakute kubungana. Ndiya kwambapo bintu mwakusoleka sobwe. ");
INSERT INTO sby_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nomba lino mulanjipushilinga cani? Kamwipushani abo balanyumfwa bintu mbyondalikwamba bacishi ncendalikwiyisha.” ");
INSERT INTO sby_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Mpwalambeco, umo wa bamalonda walikuba wemana popelapo walamuma Yesu nekwambeti, “Ngokumbula aconi mushoboyo shimilumbo mukulene?” ");
INSERT INTO sby_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu walamukumbuleti, “na ndamba bintu byaipa kobishumbula. Nsombi na ndamba byakubinga nomba ulangumininga cani?” ");
INSERT INTO sby_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Lino Anasi walamutuma Yesu kaliwasungwa kuli Kayafa shimilumbo mukulene. ");
INSERT INTO sby_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simoni Petulo mpwalikuba wemana nkaciyota mulilo, nabambi balamwipusheti, “Sena obe ntobe umo wabeshikwiya ba muntusa?” Petulo walakaneti, “Sobwe ntame.” ");
INSERT INTO sby_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Musebenshi naumbi wa mukulene wabeshimilumbo bonse, mwanse muntusa Petulo ngwalakwempula litwi, walamwipusheti, “Sena ndiya kukubonapo mulibala musa nkoli nendi?” ");
INSERT INTO sby_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petulo walakana kayi, pacindi copeleco kombwe walalila. ");
INSERT INTO sby_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Mumene mene bamakulene baBayuda balamumanta Yesu kufuma kuli Kayafa nekuya nendi kunga'nda ya mwendeleshi wa Loma. Bantu bangi balashala pansa, kutina kwambeti ningababa babulakuswepa, kayi nkabela kusuminishiwa kulyako Pasika. ");
INSERT INTO sby_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Neco Pilato walapulapansa nekubepusheti, “Mulamucana nemulandu cini muntuyu?” ");
INSERT INTO sby_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Nabo balambeti, “Nalabula kwinsa byaipa muntuyo netuliya kumuleta kuli njamwe sobwe.” ");
INSERT INTO sby_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Neco Pilato walabambileti, “Mumanteni mwenga mumomboloshe kwelana ne milawo yenu.” Nsombi Bayuda basa balambeti, “Afwe nkatwasuminishiwa kushina muntu sobwe.” ");
INSERT INTO sby_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ibi byalenshika kwambeti maswi Yesu ngalamba sha lufu lwakendi akwanilishiwe. ");
INSERT INTO sby_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato walengila munga'nda yakendi kayi, nekukuwa Yesu. Walamwipusheti, “Sena obe, njobe Mwami wa Bayuda?” ");
INSERT INTO sby_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu walambeti, “Sena kwamba kulico nikwenu mobene, nambi pali bantu balamwambilapo sha njame?” ");
INSERT INTO sby_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato walambeti, “Sena ulayeyengeti njame Muyuda? Nibantu bakobe kayi ne beshimilumbo bamakulene endibo balakulete kulinjame, nomba walensa cani?” ");
INSERT INTO sby_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu walakumbuleti, “Bwami bwakame ntebo bwapacishi capanshi sobwe. Bwami bwakame nebwanga bwapacishi capanshi pano batuloba bakame nebalandwaninini nkondo kwambeti babule kuntwala kuli bamakulene baBayuda. Nsombi bwami bwakame ntebo bwa pacishi capanshi sobwe.” ");
INSERT INTO sby_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato walambeti, “Lino ekwambeti njobe Mwami ntendimo?” Yesu walambeti, “Mulalyambili mobene kwambeti njame Mwami. Ame ndalesa pacishi capanshi pano kayi ndalasemwa nekwisa mucishi kusakwamba cancine ncine. Uliyense usuni cancine ncine ukute kunyumfwa maswi akame.” ");
INSERT INTO sby_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato walamwipusha Yesu, “Anu cancine ncine nicani?” Pilato mpwalamba maswi awa, walapula kunsa kwalikuba Bayuda, nekubambileti, “Ame ndiya kumucanapo ne mulandu uli wonse muntuyu. ");
INSERT INTO sby_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nsombi kukonka cinga cenu, pacindi ca kusekelela Pasika nkute kumusungulwila muntu umo. Sena mulayandanga kwambeti ndimusungwilile Mwami waBayuda uyu?” ");
INSERT INTO sby_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Popelapo nabo balolobesha nekwambeti, “Uyo sobwe nsombi Balaba.” Balaba walikuba cigabenga. ");
INSERT INTO sby_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Popelapo Pilato walamumanta Yesu ne kumukwipisha. ");
INSERT INTO sby_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Lino bashilikali balabamba mushini wa myunga nekumufwalika kumutwi. Kayi balamufwalika mwinjila wamushobo wabulemu ufubeluka, ");
INSERT INTO sby_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","balikabesa kulyendiye nkabambeti, “Mitende, mobami ba Bayuda!” Pacindici balatatika kumuma. ");
INSERT INTO sby_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato walapula pansa kayi nekubambila Bayuda, “Kamubonani ndamulete kuli njamwe, neco mwinshibe kwambeti ndiya kumucanapo ne mulandu uli wonse.” ");
INSERT INTO sby_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Popelapo Yesu walapula nkali afwala mushini wa myunga kumutwi ne cakufwala cifubeluka cisa, Pilato walambeti, “Uyu muntusa.” ");
INSERT INTO sby_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Bamakulene beshimilumbo nebamalonda ba mu Nga'nda ya Lesa basa mpobalabona Yesu, balolobesheti, “Mupopeni! Mupopeni!” Pilato walambeti, “Mumanteni mwenka mwenga mumupope pakwinga ame ndiya kumucanapo nemulandu.” ");
INSERT INTO sby_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Bantu balambeti, “Afwe tukute mulawo, nomba twakonka mulawo wetu uyu welela kufwa, pakwinga walikwambeti, ‘Njame Mwana wa Lesa.’ ” ");
INSERT INTO sby_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Lino Pilato mpalanyumfwa maswi awa, walanyumfwa buyowa kwine. ");
INSERT INTO sby_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Nomba walengila kayi munga'nda nekwipusha Yesu, “Nomba obe kwenu nikupeyo?” Nsombi Yesu nkalakumbula sobwe. ");
INSERT INTO sby_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Kayi Pilato walamwipusheti, “Nicani nkolankumbulunga? Sena nkocinsheti nkute ngofu sha kukusungulula nekukupopa?” ");
INSERT INTO sby_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu walambeti, “Lesa, abula kumupa ngofu nemuliya kwinsapo ciliconse palinjame. Weco uyo wanjaba kuli njamwe ukute bwipishi bunene.” ");
INSERT INTO sby_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Mpwalanyumfwa maswi awa, Pilato walayandishisha kwambeti amusungulule Yesu. Nsombi Bayuda balolobesha, mwamusungulula muntuyu ekwambeti nkamwekatana ne mwami wa kuLoma. Uliyense lalyambanga kuba mwami, ekwambeti nimulwani wamwami wa ku Loma. ");
INSERT INTO sby_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato mpwalanyumfweco, walamupulisha Yesu, nekwikala pacipuna cakomboloshelapo milandu, pabusena bwalikukwiweti, “Lubansa lwa mabwe.” Mu cihebeli ukute kukwiweti, Gabata. ");
INSERT INTO sby_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Nomba bwalikuba busuba bwakulibambila sha Pasika, kayi cindi calikuba muma 12 koloko munshi. Pilato walambila Bayuda, “Uyu Mwami wenu.” ");
INSERT INTO sby_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Nomba nabo balolobesha nekwambeti, “Mushineni! Mushineni! Kapopwani!” Pilato walabepusheti, “Sena mpope Mwami wenu?” Bamakulene beshimilumbo balakumbuleti, “Tuliyawa Mwami naumbi sobwe, nsombi Mwami wa ku Loma enka.” ");
INSERT INTO sby_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Popelapo Pilato walamutwala Yesu kulyendibo kwambeti bamupope.kufumapo Yesu walaba mumakasa abo. ");
INSERT INTO sby_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Bashilikali balamumantisha Yesu lusanda lwakendi, balapula nendi mulubansa nekuya kumusena walikukwiweti. “Cifupa ca mutwi” Mu Cihebeli bakute kwambeti “Gologota.” ");
INSERT INTO sby_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Kopeloko balamupopa palusanda. Kayi balapopa bantu bambi babili, umbi kulikasa lyalulyo naumbi kulikasa lya kucipiko, Yesu nendi walikuba pakati. ");
INSERT INTO sby_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato walalemba cishibisho pelu palusanda. Walalembeti, “Yesu wa kuNasaleti, Mwami wa Bayuda.” ");
INSERT INTO sby_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Mpwalapopela Yesu palikuba pepi neku Yelusalemu. Neco Bayuda bangi balikababelengapo. Cishibisho ici calikuba calembwa mumishobo itatu, Cihebeli ne Cilatini kayi ne Cigiliki. ");
INSERT INTO sby_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Bamakulene ba beshimilumbo ba Bayuda balambila Pilato, “Kamutalembeti, Mwami wa Bayuda sobwe. Nsombi mwine ewalikulyambeti eMwami wa Bayuda.” ");
INSERT INTO sby_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Nomba Pilato walambeti, “Mbyondalembe, nibibe copeleco mbuli ncondalembe.” ");
INSERT INTO sby_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Bashilikali basa mpwobalapopa Yesu, balamanta bayakufwala byakendi nekutwamunamo tumpansha tuna, mushilikali uliyense walamanta kampansha kakendi. Balamanta kayi nemwinjila wakendi uyo walikuba watungwa necikwisa cimo kayi nkawalikuba ne lupeto. ");
INSERT INTO sby_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Lino bashilikali abo balambilaneti, “Katutautwamuna sobwe, nsombi twinse nsolo kwambeti twinshibe na nibani eshi aumante.” Byalenshika mushoboyo kwambeti bikwanishiwe balambwa mumabala, “Balayabana byakufwala byakame, kayi mwinjila wakame balawinshila nsolo.” Weco ncobalensa bashilikali basa. ");
INSERT INTO sby_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Nomba pepi ne lusanda palemana banyina, ne mukwabo banyina, kayi palikuba Maliya mukashendi klopa ne Mariya wa ku magadalena. ");
INSERT INTO sby_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Lino Yesu mpalabona banyina ne shikwiya usa ngwalikusuna nkabalibemana pepi, walambila banyina eti, “Ma mwanenu uno.” ");
INSERT INTO sby_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Walambila kayi shikwiya usa eti, “Banyoko aba.” Lino kufumina popelapo shikwiya usa walabamanta batukashi abo ne kutatika kubasunga cena kwakendi. ");
INSERT INTO sby_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu walenshiba kwambeti lino byonse bilakwanilishiwa. Lino kwambeti bikwanilishiwe byonse byalambwa mumabala, nendi walambeti “Nkute inyotwa.” ");
INSERT INTO sby_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Popelapo palikuba nsupa yesula waini wasasa. Bashilikali basa balasabika cisambo mu waini wasasa usa, nekucisomeka kukatondo ka hisopi nekukashikisha pamulomo pakendi. ");
INSERT INTO sby_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu mpalasupita waini wasasa walambeti, “Byonse bilakwanilishiwa.” Lino walakotama mutwi nekufwa. ");
INSERT INTO sby_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Bwalikuba busuba bwakulibambila sha Pasika. Bamakulene ba Bayuda nkabali kwandeti bitumbi ibyo bibe pa lusanda pa busuba bwa Sabata, pakwinga busuba bwa Sabata ubo bwalikuba bunene. Weco balamusenga Pilato kwambeti batyokole myendo ya bantu basa balikuba bapopwa nekubafunya. ");
INSERT INTO sby_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Lino bashilikali balesa, nekutyokola umo pa babili basa balapopwa pamo ne Yesu. Balensa copeleco ne kumunendi usa. ");
INSERT INTO sby_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nsombi mpobalashika pali Yesu, pakubona kwambeti lafu kendi, neco baliya kutyokola myendo yakendi. ");
INSERT INTO sby_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Nsombi umo wa bashilikali basa walamuyasa mumbafu ne lifumo, nomba mwalafuma milopa ne menshi. ");
INSERT INTO sby_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Uyo walabona bintu ibi endiye labinshilinga bukamboni, kwambeti ne njamwe mushome. Bukamboni bwakendi nibwancine ncine, kayi mwine ucinshi kwambeti mbyalambanga nibyakubinga. ");
INSERT INTO sby_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ibi byalenshika kwambeti byalambwa mumabala bikwanilishiwe, mabala akwambeti, “Nteshi bakatyokole lifupa lyakendi nambi limo.” ");
INSERT INTO sby_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kayi kuli mabala nambi alambangeti, “Bantu nibakamwebele uyo ngobalayasa.” ");
INSERT INTO sby_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Panyuma pakendi Yosefe wa ku Arimatea walasenga Pilato kwambeti amusuminishe kufunya citumbi ca Yesu. Yosefe walikuba weshikwiya wa Yesu, nsombi mwakusolama, pakwinga balikutina bamakulene ba Bayuda. Lino Pilato walamusuminisha, nendi walafunya citumbi ico. ");
INSERT INTO sby_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Kwalesa kayi nikodemasi, usa walaya kuli Yesu mashiku pakutatika pasa. Nendi walaleta mafuta anunkila a mule asankanishiwa ne aloe, alikuba alema makilogilamu akwana 32. ");
INSERT INTO sby_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Bantu babili aba balamanta mubili wa Yesu nekupomba mucikwisa caswepa ne mafuta anunkila cena, balakonka mwambo wa Bayuda. ");
INSERT INTO sby_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Uko Yesu nkwalapopwa kwalikuba libala. Nomba mulibala umo mwalikuba cumbwe calino lino, citana cibikwamo muntu. ");
INSERT INTO sby_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Lino bwalikuba busuba bwa kulibambila kwa Bayuda kusekelela Pasika, Nomba manda ayo alikuba pepi, balabika Yesu mopelomo. ");
INSERT INTO sby_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pabusuba bwa Sondo mumene mene nkapacili pashipa shipa, Mariya wa ku Magadalene walaya ku manda a Yesu. Mpwalashika walabona kwambeti cilibwe cisa cafunywapo kendi pacishinga ca manda. ");
INSERT INTO sby_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Neco walafwamba kuya akushika kuli Simoni Petulo ne shikwiya umo usa ngwalikusuna Yesu maningi. Walabambila kwambeti, “Balamufunyumo Mwami mumanda kayi nkatucinshi nkobalamubiki.” ");
INSERT INTO sby_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Popelapo Petulo ne shikwiya naumbi balapula nekuya ku manda. ");
INSERT INTO sby_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bonse babili balafwamba, nomba usa shikwiya naumbi walafwamba kupita Petulo, neco ewalatanguna kushika kumanda. ");
INSERT INTO sby_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Walakotama nekubonowa bikwisa nkabili byafungana, nomba nendi liyawa kwingilamo. ");
INSERT INTO sby_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Shimoni Petulo mpwalashika walayakwingila mumanda. Nomba walabonowa bikwisa byabungana nkabili popelapo, ");
INSERT INTO sby_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Kayi kakwisa kasa kalikuba kumutwi kwakendi. Kakwisa aka nkakalikuba pamo ne bikwisa nabimbi bisa, nsombi kalikuba pakonka nkakali kapombwa. ");
INSERT INTO sby_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Popelapo shikwiya naumbi usa walatatikila kushika ku manda, nendi walengilamo. Nomba mpwalabona bintu ibi, walashoma. ");
INSERT INTO sby_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Kushikila cindi copeleco nabo basa balinkabatana banyumfwishisha maswi akwambeti Yesu welela kupunduka kubafu. ");
INSERT INTO sby_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Panyuma pakendi beshikwiya basa balabwela kucomwabo. ");
INSERT INTO sby_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Nomba Maliya walemana pansa pamanda nkalila, nkacilila mushoboyo, walakotama nekusumbila mumanda, ");
INSERT INTO sby_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","walabona bangelo babili nkabali bafwala mingila ituba. Bangelo abo balikuba bekala panshi,palikuba pona citumbi ca Yesu pasa. ");
INSERT INTO sby_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nabo balamwipusheti, “Obe mutukashi, ulalilinga cani?” Nendi walakumbuleti, “Pacebo cakwambeti balamufunyumo Mwami wakame kayi nkandicinshi nkobalamubiki.” ");
INSERT INTO sby_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Mpwalamba bintu ibi walacebuka nekubona muntu nkali wemana popelapo, nsombi liyawa kumwinshiba kwambeti ni Yesu. ");
INSERT INTO sby_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Lino Yesu walamwipusheti, “Mutukashi obe ulalilinga cani?” Mariya nendi walikuyeya kwambeti nimusebenshi wamulibala, neco walamwambila kwambeti, “Nkambo, na njamwe mulamufunyumo, kamungambilani nkomulamubiki kwambeti njenga akumumanta.” ");
INSERT INTO sby_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu walambeti, “Maliya!” Nendi walacebuka nekwambeti, “Laboni!” Uku ekwambeti, “Bashikwiyisha.” ");
INSERT INTO sby_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu walamwambileti, “Kotanjikata pakwinga nkanta nja kuli Bata. Nsombi koya wambile bakwetu, ubambileti, ndenga kuli Bata, kayi Ebameshenu, kuli Lesa wakame kayi endiye Lesa wenu.” ");
INSERT INTO sby_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maliya waku Magadalene walaya akwambila beshikwiya bakendi eti, “Ndamubono Mwami,” Neco walabambila byonse mbyalamwambila Mwami. ");
INSERT INTO sby_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Mansailo mpokwalashipa pabusuba bwa Sondo, Beshikwiya basa balikuba pamo. Bishinga byalikuba byacalwa, pakwinga balikutina bamakulene ba Bayuda. Lino Yesu walesa akwimana pakati pabo nekwambeti “Lumuno lube nenjamwe!” ");
INSERT INTO sby_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Mpwalambeco walababonesha makasa akendi ne kumbafu nkwalayaswa, neco beshikwiya basa balakondwa mpobalabona Mwami. ");
INSERT INTO sby_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Kayi Yesu walambeti, “Lumuno lube nenu.” Mbuli Bata balantuma, nenjame ndamutumunga. ");
INSERT INTO sby_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Panyuma pakendi walabambila kayi walayoyela, “kamutambulani Mushimu Uswepa. ");
INSERT INTO sby_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Bantu abo mboshi mukalekelele bwipishi bwabo nibakalekelelwe cakubinga, nomba abo mboshi mukabule kulekelela nteshi bakalekelelwe sobwe.” ");
INSERT INTO sby_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Umo wa basa beshikwiya balilikumi ne babili, Tomasi walikukwiweti mpundu, nkalikuba pamo ne beshikwiya banendi pacindi Yesu mpwalesa. ");
INSERT INTO sby_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Lino beshikwiya banendi basa balamwambila eti, “Afwe tulamubono Mwami.” Nsombi Tomasi walambeti, “Ndabula kubona bilonda bya misupikili, nambi kutyonka cimbombo cakame kumbafu nkwalayaswa nkandela kushoma sobwe.” ");
INSERT INTO sby_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Mpopalapita masuba asanu ne atatu, beshikwiya basa balikuba munga'nda mopelomo ne Tomasi walikuba nabo. Bishinga byalikuba byacalwa, nsombi Yesu walesa, walemana pakati pabo nekwambeti, “Lumuno lube nenu!” ");
INSERT INTO sby_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Mpwalambeco, walambila Tomasi eti, “Tyonka cimbombo cakobe mumbafu mwakame, kayi bona makasa akame. Kobika cimbombo cakobe apa. Cileke kutonshanya kayi ushome.” ");
INSERT INTO sby_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasi walambeti, “Mwami wakame! Lesa wakame!” ");
INSERT INTO sby_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu walambeti, “Sena ulashomo pacebo cakwambeti ulambono? bakute colwe balashomonga ncebatana babona.” ");
INSERT INTO sby_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu walensa bingashilo nabimbi bingi byeshikukankamanisha pamenso abeshikwiya bakendi, ibyo byabula kulembwa mulibuku ili. ");
INSERT INTO sby_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nsombi ibi bilalembwe kwambeti mushometi Yesu eMupulushi Walaiwa usa, Mwanendi Lesa, kwambeti mwashoma mube ne buyumi butapu mulina lyakendi. ");
INSERT INTO sby_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Panyuma pakendi Yesu walalilesha kayi kuli beshikwiya bakendi kumulonga wa Tibeliyo. ");
INSERT INTO sby_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Shimoni Petro, Tomasi ne Nataniele wa kumunshi waku Kana mucishi ca Galileya, bana basa ba Sebediya, kayi ne beshikwiya nabambi babili, balikuba pamo. ");
INSERT INTO sby_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Shimoni Petulo walabambileti, “Ame ndenga akwikata inswi.” Nabo balambeti, “Nenjafwe tulenga nenjobe.” Balanyamuka nekuya akwingila mubwato. Nomba mashiku baliya kwikatapo inswi. ");
INSERT INTO sby_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Mpobwalaca Yesu walemana pa mutunta. Nsombi beshikwiya basa nkabalenshibeti ni Yesu. ");
INSERT INTO sby_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Lino nendi walabepusha eti, “Sena muliya kwikatapo inswi?” Nabo balambeti, “Sobwe, tulabwelekowa.” ");
INSERT INTO sby_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yesu walabambileti, “Walani kombe kulubasu lwakululyo kwa bwato, nimwikate.” Naboyo balawala kombe, nomba balalilwa kukwela kombe pakwinga kalekata inswi shingi. ");
INSERT INTO sby_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Popelapo shikwiya usa Yesu ngwalikusuna maningi walambila Petulo eti, “Ni Mwami!” Shimoni Petulo mpwalanyumfwa kwambeti ni mwami, walafwala mwinjila wakendi (pakwinga walikuba laufululu mwinjila) Nomba walaliwala mu lwenje. ");
INSERT INTO sby_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Lino beshikwiya nabambi basa balesa ne bwato kumutunta, nkabadonsa kombe kesula ne nswi shingi. Nkalikuba kutali ne mutunta, nsombi walikuba pepi ne ntamwa shakwana makumi asanu ne ana. ");
INSERT INTO sby_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Mpobalashika kumutunta balabona mulilo wa malasha kapali inswi ne shinkwa. ");
INSERT INTO sby_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu walabambileti, “kamuletani inswi shing'ana pali isho nshomulekata.” ");
INSERT INTO sby_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Lino Shimoni Petulo walengila mubwato musa nekukwelela kombe kumutunta, kalikuba kekata inswi shakwana mwanda ne makumi asanu ne shitatu. Nambi inswi shalafula mushobo uyu, kombe nkakalatwamuka sobwe. ");
INSERT INTO sby_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu walabambileti, “Kamwisani mulye.” Nomba pa beshikwiya basa nkapalikuba nambi umo walaliyuminisha kumwipusheti, “Njobe bani?” Pakwinga balenshibeti ni Mwami. ");
INSERT INTO sby_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu walaya akumanta buledi ne kubapa. Walensa copeleco ne nswi shisa. ");
INSERT INTO sby_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Pacindi ici alakwana mankanda atatu akubonekela kuli beshikwiya bakendi kufuma mpalapunduka kubafu. ");
INSERT INTO sby_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Mpobalapwisha kulya, Yesu walepusha Simoni Petulo eti, “Obe Shimoni mwanendi Yohane, sena unsuni kupita bonse aba?” Nendi walambeti, “Cakubinga Mwami, mucinshi kwambeti ndimusuni.” Yesu walamwambileti, “Sunga mbelele shakame.” ");
INSERT INTO sby_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesu walamwipusha kayi katubili eti, “Obe Shimoni mwanendi Yohane, sena unsuni?” Nendi walambeti, “Cakubinga Mwami mucinsheti ndimusuni.” Yesu walamwambileti, “Sunga mbelele shakame.” ");
INSERT INTO sby_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesu walamwipusha kayi kabutatu eti, “Obe Simoni mwanendi Yohane, sena unsuni?” Nendi walambeti, “Cakubinga Mwami mucinsheti ndimusuni.” Yesu walamwambileti, “Sunga mbelele shakame.” ");
INSERT INTO sby_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“Ndakwambilinga cakubinga, pacindi mpowalikuba mutuloba, walikulisunga wenka beloti nekuya kulikonse nkowalikwanda. Nomba wakacembela, nukatandabule makasa akobe kwambeti umbi akusunge beloti nekuya nenjobe nkotasuni.” ");
INSERT INTO sby_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Yesu walamba bintu ibi kwambeti abenshibishe moshi akafwile Petulo kwambeti Lesa akalemekwe. Mpalambeco, walambila Petulo eti, “Nkonke.”) ");
INSERT INTO sby_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petulo walacebuka nekubonowa shikwiya usa Yesu ngwalikwanda maningi nkamukonkela munyuma. Endiye shikwiya usa walikuba watamina pantiti pa Yesu Pacindi cakusekelela pasa nekumwipusheti, “Mwami weshi akamuyabe kubalwani benu nibani?” ");
INSERT INTO sby_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Popelapo Petulo walamubona nekumwipusheti, “Mwami, nomba uyu cilyeconi?” ");
INSERT INTO sby_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu walamwambileti, “Na ndandanga kwambeti nendi abe ne buyumi kushikila mpaka nkabwele, sena kuli obe ngaciba cani? Obe nkonke.” ");
INSERT INTO sby_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Lino lulumbi lwalanyumfwika pakati pa beshikwiya bonse kwambeti usa munabo nteshi akafwe sobwe, nsombi walambeti, “Na ndandanga kwambeti nendi akabe ne buyumi mpaka nkabwele, sena kuli obe ngaciba cani?” ");
INSERT INTO sby_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Uyu eweshikwiya usa walensa bukamboni bwa bintu byalenshika ibyo, kayi endiye walabilemba. Tucinshi kwambeti bukamboni bwakendi nibwakubinga. ");
INSERT INTO sby_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Nomba kuli bintu nabimbi bingi Yesu mbyalensa. Nebyalalembwa byonse ibyo ndashoma kwambeti pacishi conse capanshi nepalakabulu mabuku akulembamo byonse ibyo.");
INSERT INTO sby_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kuli wasunika Teofilo; Mulibuku lya kutanguna ndalalembamo bintu byonse Yesu mbyalikwinsa ne kwiyisha ");
INSERT INTO sby_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","kushikila pabusuba mbwalamantwa kuya kwilu. Katana amantwa kwilu, kupitila mu ngofu sha Mushimu Uswepa, walabambila batumwa mbwalasala ncobela kwinsa. ");
INSERT INTO sby_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Panyuma pa kufwa ne kupunduka kubafu, Yesu walabonekela ku batumwa bakendi tunkanda twingi, munshila shingi shapusana pusana kushomesha kwambeti nimuyumi, walabonekela kulyendibo kwa masuba makumi ana. kayi walabambila sha Bwami bwa Lesa. ");
INSERT INTO sby_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Kacilinabo, Yesu walabambileti, “Kamutafuma mu Yelusalemu nanshi, mupembelele Mushimu Uswepa ngobalalaya Bata, mbuli ncondalamwambila. ");
INSERT INTO sby_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohane walikubatisha ne menshi, nomba papita masuba ang'anowa, nimubatishiwe ne Mushimu Uswepa.” ");
INSERT INTO sby_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Batumwa mpobalabungana pamo ne Yesu, balamwipusheti, “Nkambo, sena ecino cindi nceti mubweshele Bwami ku Baislayeli?” ");
INSERT INTO sby_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesu walabakumbuleti, “Nkacayandiketi amwe mwinshibe cindi nceti bikenshikenga bintu bili mungofu sha Bata. ");
INSERT INTO sby_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Nomba Mushimu Uswepa wakesa pali njamwe nimukatambule ngofu. Kayi nimukabe bakamboni bakame ku Yelusalemu ne ku Yudeya konse kayi ne ku Samaliya, mpaka kushika kwakuma cishi capanshi.” ");
INSERT INTO sby_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yesu mpwalapwisha kwambeco walamantwa kwilu batumwa kabebelela, kushikila likumbi mpolyabashinkilila, balacileka kumubona. ");
INSERT INTO sby_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Batumwa basa kabacili balangishisha kwilu, mwakutengashila, batuloba babili bafwala byakufwala bituba, balemana pambali pabo, ");
INSERT INTO sby_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ne kubepusheti, “Amwe batuloba ba ku Galileya mwemanina cani pano kamuli mwalangishishowa mwilu? Yesu opele uyu lamantwa kufuma pakati penu kuya kwilu, nakese kayi ndendende mbuli momula mubonene kaya Kwilu.” ");
INSERT INTO sby_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Lino basa batumwa balabwelela ku Yelusalemu kufuma ku mulundu wa ma Olifi. Palikubowa mushinso ufupi wabula kukwana ntamwa myanda likumi, kufuma ku Yelusalemu. ");
INSERT INTO sby_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Mpobalengila mu Yelusalemu, balatanta mucipinda capelu mung'anda mobali kukumana. Abo balayako balikuba; Petulo ne Yohane ne Jemusi ne Ndileya ne Filipo ne Tomasi ne Batolomeyo ne Mateyo ne Jemusi Mwanendi Alufeyo ne Shimoni wa mucipani ca bantu balikulwanina lwanguluko mu cishi ca Islayeli, kayi ne Yudasi mwanendi Jemusi. ");
INSERT INTO sby_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bonse balikuba balimbikila kupaila ne moyo umo, kayi palikuba Maliya banyina Yesu ne bakwabo Yesu, pamo ne batukashi nabambi. ");
INSERT INTO sby_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mpopalapita masuba ang'ana, bashoma muli Yesu bali mwanda umo ne makumi abili, balabungana pamo, Petulo walemana pakati pabo ne kwambeti, ");
INSERT INTO sby_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Mobanse bame, calikuba celela kukwanilishiwa calalembwa mu Mabala a Lesa sha Yudasi. Mushimu Uswepa kupitila muli Dafeti, walamba sha endiye uyo walatangunina bantu kuya kwikata Yesu. ");
INSERT INTO sby_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yudasi wanga wamulikoto lyetu, wakutenga ncito njasebensanga pamo ne njafwe.” ");
INSERT INTO sby_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Mali asa ngalacana pakwinsa bwipishi bulico walaula libala, mulibala umo emwalalisungilila. Walalaka panshi cakushapo libunda, walapasuka libunda ne mila yakendi yalapula panshi mbwee. ");
INSERT INTO sby_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Bonse bantu balikwikala mu Yelusalemu balanyumfwa. Kwelana ne mulaka wabo, libala ilyo balalikuweti, “Akeledama.” Akeledama ekwambeti, “Libala lya milopa.” ");
INSERT INTO sby_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Petulo walapitilisha kwambeti, “Pakwinga mulibuku lya Kutembaula muli maswi alambangeti, “Ng'anda yakendi isanduke matongo, Kapataba muntu shikwikalamo!” Muli kayi maswi alambangeti, “Naumbi amante musena wancito yakendi! ");
INSERT INTO sby_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Pacebo ico, twelela kusalapo umo pa bantu abo mbotwalikuba nabo, pacindi Mwami Yesu mpwalikuba pakati petu ");
INSERT INTO sby_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","kufumina pacindi Yohane mpwalikubatisha bantu, mpaka busuba Yesu mbwalamantwa kufuma pakati petu ne kuya kwilu. Umo wa bantu aba abe kamboni pamo ne njafwe, pa shakupunduka kubafu kwa Yesu.” ");
INSERT INTO sby_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Neco balasalapo batuloba babili Yosefe Balasaba, lina lyakendi nalimbi ni Yusito, kayi ne Matiya. ");
INSERT INTO sby_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Neco,balapaileti, “Nkambo Lesa, njamwe mwishi myoyo ya bantu bonse, kamutuleshani uyo ngomulasalapo pa batuloba babili aba, ");
INSERT INTO sby_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","kwambeti amante ncito iyi ya butumwa, njalashiya Yudasi, uyo walafwa ne kuya kumusena wamwelela.” ");
INSERT INTO sby_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Panyuma pakendi balabauma nsolo pa batuloba babili aba. Nsolo yalawila Matiya, neco walaba palikoto lya batumwa likumi ne umo. ");
INSERT INTO sby_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Lino mpobwalashika busuba bwa Pentekosite, beshikwiya bonse balabungana pamo mung'anda. ");
INSERT INTO sby_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Popelapo kwilu kwalanyufwika mukokomo ulyeti walukupwe lwangofu ne kwisa kwisula mung'anda njobalikubamo. ");
INSERT INTO sby_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Balabona nsakamwenge shamulilo, shalikuboneketi ndemi kashipansana ne kwisa kwikala pali umo ne umo. ");
INSERT INTO sby_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Bonse balesulilwa ne Mushimu Uswepa ne kutatika kwamba mumilaka yapusana pusana, Mushimu ewalikubambisheco. ");
INSERT INTO sby_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Lino mu Yelusalemu mwalikuba Bayuda nabambi balikusuna Lesa, balafumina mubishi byonse bya pacishi capanshi. ");
INSERT INTO sby_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Mpobalanyumfwa usa mukokomo, bantu bangi balabungana pamo. Bonse balapwilwa mano pakwinga umo ne umo walabanyumfwa bashoma basa kabamba mumulaka wakendi mwine. ");
INSERT INTO sby_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Balakankamana kwine ne kwambeti, “Sena aba bonse balambanga ntebo ba ku Galileya? ");
INSERT INTO sby_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Inga cilabeconi kwambeti uliyense pakati petu lanyumfunga kabamba mulaka wakendi mwine? ");
INSERT INTO sby_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Tobambi twafuma ku Apati ne ku Midiya ne ku Elamu ne ku Mesopotamiya ne ku Yudeya ne ku Kapadokiya ne ku Ponto ne ku Asiya, ");
INSERT INTO sby_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ne ku Filigiya ne ku Pamfiliya ne ku Injipito ne kubimpansha bya Libya pepi ne ku Kulene. Tobambi tobensu tulafumini ku Loma. ");
INSERT INTO sby_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Nabambi ni Bayuda ne bantu nabambi basumina ciyisho ca Ciyuda. Tobambi toba ku Kelete ne baku Alabu. Nomba twense tulabanyumfunga kabamba mumilaka yetu ncito sha ngofu sha Lesa!” ");
INSERT INTO sby_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Bonse balakankamana ne kupwilwa mano, balatatika kwipushana umo ne munendi, “Inga nicani ici?” ");
INSERT INTO sby_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Nomba nabambi balatatikowa kuseka ne kwambeti, “Balakolewa waini.” ");
INSERT INTO sby_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Petulo walemana pamo ne batumwa banendi likumi ne umo, ne kwamba maswi akubilikisha, “Amwe Bayuda, pamo ne njamwe mwekala mu Yelusalemu muno, kamukutikani kayi munyumfwishishe maswi akame. ");
INSERT INTO sby_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Aba bantu nkabakolewa waini mbuli ncomulabayeyelenga, cino cindi cicili muma 9 koloko mumenemene. ");
INSERT INTO sby_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ici encalamba mushinshimi Yoweli, kwambeti, ");
INSERT INTO sby_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Lesa lambangeti, Mu masuba akupwililisha ninketile Mushimu wakame mubantu bonse, bana benu batuloba ne batukashi, Nibakakambaukenga shanjame. Misepela nibakabonenga bintu byakame mucimbonimboni, Bamacekulu nibakalotenga maloto. ");
INSERT INTO sby_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Cakubinga mumasuba opelawo ninketile Mushimu wakame mubasha bakame batuloba ne batukashi, Nibakakambaukenga shanjame. ");
INSERT INTO sby_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ninkense bikankamanisha mwilu, pano pacishi capanshi nipakabe bingashilo ibi, milopa, mulilo ne bwishi bwatikama. ");
INSERT INTO sby_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Lisuba nilikashipe mbii mbuli mushinshe ne mwenshi nukafubele pyuu, mbuli milopa, kabutana bushika busuba bunene buyosha bwakame Ndekali Mwami. ");
INSERT INTO sby_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Popelapo uliyenseti akakuwe Mwami kwambeti amunyamfwe nakapuluke.” ");
INSERT INTO sby_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Petulo walapitilisha kwambeti, “Amwe Baislayeli, kamunyumfwani maswi awa, alambanga sha Yesu waku Nazaleti. Lesa walashomesha kwambeti walamutuma kuli njamwe pakwinsa bishomesho byangofu ne bishikukankamanisha, kayi ne bingashilo. Mucinshico, pakwinga byalenshika pakati penu. ");
INSERT INTO sby_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Lesa walikuba wabibambilalimo kwambeti, Yesu nakayabwe kuli njamwe ne kumushina pakumutwala mumakasa abantu baipa abo balamupopa palusanda. ");
INSERT INTO sby_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nomba Lesa walamusungulula kubishikubaba bya lufu ne kumupundusha kubafu, pakwinga calikuba capatali kwambeti lufu lumukome.” ");
INSERT INTO sby_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dafeti pakwamba sha endiye walambeti, “Ndalikubona Mwami Lesa pamenso pakame cindi conse, Pakwinga uli kucikasa cakame calulyo kwambeti kantatenkana. ");
INSERT INTO sby_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ecebo cakendi moyo wakame walakondwa, kayi ndalikwamba mwakusangalala. Cakubinga nawo mubili wakame nukapumwine mukupembelela, ");
INSERT INTO sby_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Pakwinga nteti mukanshiye mumanda, nambi kulekelesha musebenshi wenu washomeka kubola, ");
INSERT INTO sby_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Mulandeshe nshila sha kubuyumi, kayi kuba ne njamwe nikukankondweleshe kwine.” ");
INSERT INTO sby_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Kayi Petulo walapitilisha kwamba, “Mobanse bame ndamwambilishingeti, ‘cikokwe wetu Dafeti walafwa, ne manda ngwalabikwamo mpwacili pano nelelo.’ ");
INSERT INTO sby_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Kacili muyumi, walikuba mushinshimi, kayi walikwinshiba Lesa ncalamulaya pakulumbileti, umo wabashikululwa bakendi nakabe Mwami mbuli Dafeti.” ");
INSERT INTO sby_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Anu Dafeti walabonenalimo sha kupunduka kubafu kwa Klistu kwambeti “Nteti nkamushiye mu manda, kayi ne mubili wakendi uliya kubolapo sobwe!” ");
INSERT INTO sby_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Twense pano tobakamboni bamakani awa, akwambeti Lesa walapundusha Yesuyu kubafu. ");
INSERT INTO sby_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Walasumpulwa ne kuya kwikala kucikasa ca kululyo ca Lesa ne kutambula Mushimu Uswepa, uwo Lesa Baishi ngobalamulaya. Ibi mbyomulabononga ne kunyumfwa ecipo ncalatutumini. ");
INSERT INTO sby_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dafeti uliya kuya kwilu sobwe, nsombi nendi ewalambeti, “Mwami Lesa, walambila Mwami wakame kwambeti, Ikala kucikasa cakame cakululyo, ");
INSERT INTO sby_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","mpaka nkasandule balwani bakobe bakabe cakulyatapo myendo yakobe.” ");
INSERT INTO sby_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Kayi Petulo walapitilisha kwambeti, “Bonse Baislayeli mwinshibe lino kwambeti, Yesu usa ngomwalapopa palusanda, Lesa walamusala kuba Mwami ne Klistu.” ");
INSERT INTO sby_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Lino basa bantu mpobalanyumfweco, balayaswa kumoyo. Balamwipusha Petulo ne batumwa banendi, “Mobanse bame nicani ncotitwinse afwe?” ");
INSERT INTO sby_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petulo walabambileti, “Shiyani bwipishi, umo ne umo abatishiwe mu Lina lya Yesu Klistu. Mwenseco bwipishi bwenu nibulekelelwe, kayi nimutambule Mushimu Uswepa, cipo ca Lesa. ");
INSERT INTO sby_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Lesa walalailisha amwe, bana benu ne bantu bonse bekala kutali, abo Mwami Lesa wetu mbweshakakuwe.” ");
INSERT INTO sby_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petulo walamba maswi angi, ne kubacenjesheti, “Lipulusheni mobene ku cisubulo ceti cise pa bantu baipa aba.” ");
INSERT INTO sby_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Popelapo bantu balatambula maswi akendi balabatishiwa. Pabusuba bopelobo bantu myanda makumi atatu balaba kulubasu lwa beshikwiya. ");
INSERT INTO sby_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bantu abo balikuyandishisha kwiya ku batumwa. Balikubangana pamo lyonse kayi balikulyela pamo shinkwa kayi ne kupaila pamo. ");
INSERT INTO sby_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Bantu balaba ne buyowa pakubona bishikunkamanisha ne bingashilo bingi Lesa mbyalikwinsa kupitila batumwa. ");
INSERT INTO sby_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Abo bonse balikuba bashoma muli Yesu balikuba bekatana pamo ne kuyabana bintu byabo. ");
INSERT INTO sby_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Balikulisha mabala abo ne bintu byabo, kayi ne kuyabanya kuli umo ne umo kwelana ne kubulilwa kwakendi. ");
INSERT INTO sby_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Busuba ne busuba balikubungana pamo mulubuwa lwa Ng'anda ya Lesa ne moyo umo, kayi balikukuwa banabo kumanda kwabo kuya kulyela pamo. Balikulya cakulya mwakukondwa, ne myoyo yasunguluka, ");
INSERT INTO sby_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","kabatembaula Lesa, kayi bantu bonse balikulesha kwina moyo kulyendibo. Busuba ne busuba, Lesa walikuyungisha cibelengelo ca bantu balikutambula lupulusho. ");
INSERT INTO sby_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Lino busuba nabumbi Petulo ne Yohane balikuya ku Ng'anda ya Lesa cindi ca 3 koloko mansailo, kuya kupaila. ");
INSERT INTO sby_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Bantu nabambi balaleta muntu walasemwa kali mulema myendo. Masuba onse balikumubika pa cishinga ca Ng'anda ya Lesa, calikukwiweti “Cishinga Capa,” Kwambeti asengenga bantu balengilinga mu lubuwa lwa Ng'anda ya Lesa. ");
INSERT INTO sby_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Uyu muntu mpwalabona Petulo ne Yohane kabengila mu lubuwa lwa Ng'anda ya Lesa, walabasengeti, “Kamumpako kantu.” ");
INSERT INTO sby_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Balo balamulangishisha, popelapo Petulo walamwambileti, “Kotulangishisha!” ");
INSERT INTO sby_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nendi walabangishisha kayeyeti natambuleko kantu. ");
INSERT INTO sby_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nomba Petulo walamwambileti, “Mali ndiyawa, nsombi nindikupe cintu nconkute. Mu Lina lya Yesu Klistu waku Nasaleti, Imana wende!” ");
INSERT INTO sby_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Walamwikata kucikasa cakululyo, ne kumunyamfwilisha kwimana. Popelapo bimpanta ne tupondopashi twakendi twalayuma yuma. ");
INSERT INTO sby_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Walaulukila mwilu, walemana nji! ne kutatika kwenda kaculauka culauka, walengila mu lubuwa lwa Ng'anda ya Lesa pamo nendibo kalyendela mwine, katembaula Lesa. ");
INSERT INTO sby_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bantu bonse balamubona kenda ne kutembaula Lesa. ");
INSERT INTO sby_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Balamwinshibeti endiye walikwikala pa Cishinga Capa ca Ng'anda ya Lesa. Ici calenshika ku muntuyu calabakankamanisha ne kubapwisha mano. ");
INSERT INTO sby_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Bantu bonse, balakankamana kwine, balafwambila kumukushi walikukwiweti, “Mukushi wa Solomoni.” Uko kwalikuba Petulo ne Yohane, balacana usa muntu kali wabekatilila. ");
INSERT INTO sby_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petulo mpwalaboneco walamba nabo bantu abo, walambeti, “Amwe Baislayeli mulakankamanangeconi? Mulatulangangeconi cisa eti muntuyu tulamwendeshe ne ngofu shetu tobene? Sena mulayeyengeti afwe njafwe tukute kupaila Lesa kupita amwe? ");
INSERT INTO sby_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nteco ico sobwe, Lesa wa Abulahamu, Lesa wa Isake, Lesa Yakobo, kayi Lesa wa bamashali betu, elapa bulemeneno Yesu musebenshi wakendi. Amwe ngomwalatwala mu makasa a bendeleshi ne kumukana pamenso pa Pilato, nendi kayanda kumusungulula. ");
INSERT INTO sby_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Nsombi mwalakana musebenshi washomeka kayi walulama, mwalasenga Pilato kwambeti, amusungulwile kapondo usa. ");
INSERT INTO sby_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mwalashina citente ca buyumi, nsombi Lesa walamupundusha kubafu, kayi afwe tobakamboni pa makani awa. ");
INSERT INTO sby_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Muntuyu ngomulabononga kayi ngomwinshi, lashomo lina lya Yesu. Lushomo ndwakute muli Yesu, elulayumishi myendo yakendi, kwambeti abe cena, mbuli ncomulamubononga mwense.” ");
INSERT INTO sby_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Kayi ndicinshi mobanse bame kwambeti, amwe ne batangunishi benu mwalensa ibi mwakubula kwinshiba. ");
INSERT INTO sby_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nomba Lesa walambilalimo kubashinshimi bonse kwambeti, Klistu nakapenshewe, neco walacikwanilisha ndendende. ");
INSERT INTO sby_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Neco shiyani bwipishi, bwelelani kuli Lesa kwambeti afunye bwipishi bwenu, ");
INSERT INTO sby_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","na mwinseco, cindi cakatontoshi keshikufuma pamenso pa Mwami Lesa nikakamushikile, kayi nakamutumine Klistu Yesu uyo Lesa ngwalasalilalimo cebo ca njamwe. ");
INSERT INTO sby_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Uyo nendi walatambulwa Kwilu mpaka kushika cindi cakubambulula bintu, mbuli Lesa ncalamba kupitila mubashinshimi bakendi bakulukulu bashomeka. ");
INSERT INTO sby_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mose walambeti, Lesa Mwami wenu nakapundushepo umo pakati pabanse benu uyo eshakabe mushinshimi ulyeti ame. Mukamunyumfwilenga mbyeti akamwambilenga byonse. ");
INSERT INTO sby_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Uliyense eshakabule kunyumfwila mushinshimi uyo nibakamufunye pa bantu ba Lesa ne kumononga. ");
INSERT INTO sby_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Bashinshimi bonse balikwambapo, kutatikila Samiyele, mpaka bashinshimi bonse balabako panyuma pakendi, balikukambauka sha masuba ano. ");
INSERT INTO sby_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kushomesha kwa Lesa kupitila mubashinshimi bakendi nikwenu, kayi mukutemo lubasu mu cipangano ncalabamba Lesa ne bamashali benu bakulukulu. Mbuli ncalambila Abulahamu kwambeti, Kupitila mubashukulu bakobe, ninkape colwe mishobo yonse ya pacishi capanshi. ");
INSERT INTO sby_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Neco Lesa walasala musebenshi wakendi, cakutanguna walamutuma kuli njamwe, kwambeti amupe colwe pakunyamfwilisha uliyense kushiya nshila shakendi shaipa. ");
INSERT INTO sby_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petulo kacamba ne basa bantu, kali pamo ne Yohane, kwalesa beshimilumbo nabambi, pamo ne mukulene wa bamalonda baku Ng'anda ya Lesa, ne Basaduki nabambi. ");
INSERT INTO sby_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Balikuba bakalala pacebo cakwambeti, batumwa babili basa balikwiyisha bantu ne kukambauka sha kupunduka kwa Yesu. ");
INSERT INTO sby_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Neco balabekata ne kubabika mujele cindi ca mansailo kakuli kulashipuluku, kwambeti bekalemo mpaka lilo mumene. ");
INSERT INTO sby_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Nikukabeco, bantu bangi balanyumfwa maswi abatumwa basa balashoma. Cibelengelo cabashoma calakwana myanda makumi asanu. ");
INSERT INTO sby_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Mpobwalaca mumene, batangunishi ba Bayuda ne bamakulene babo ne beshikwiyisha Milawo ya Mose, balabungana mu Yelusalemu. ");
INSERT INTO sby_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Popelapo palikuba Mukulene wa Beshimilumbo bonse Anasi ne Kayafa ne Yohane ne Alesandulo ne nabambi bamumukowa wa Shimilumbo Mukulene. ");
INSERT INTO sby_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Balemanika Petulo ne Yohane pakati ne kubepusheti, “Mwacikonshaconi kwinsa cisa, nambi mwensa cisa mungofu shabani?” ");
INSERT INTO sby_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Petulo, pakwisulilwa ne Mushimu Uswepa, walabakumbuleti, “Amwe batangunishi ba bantu, ne njamwe bamakulene muli pano. ");
INSERT INTO sby_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Pakwinga mulatwipushunga lelo pa ncito yaina yalenshika pa muntu mulema usa ne kusengulwa kwakendi, ");
INSERT INTO sby_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","lino mwinshibe mwense, ne Baislayeli nabambi, uyu muntu wemana pamenso penu wapola cakupwililila, pacebo cangofu sha lina lya Yesu Klistu waku Nasaleti, usa ngomwalapopa palusanda, Lesa ngwalapundusha kubafu.” ");
INSERT INTO sby_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Kwamba sha Yesu, Mabala Lesa alambangeti, “Libwe ndyomwalakana mobeshikwibaka ng'anda Lyopelyo lyalaba libwe Lyayandika kupita onse.” ");
INSERT INTO sby_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Paliya muntu nakaba umo, welela kupulusha bantu, nsombi Yesu enkowa, pakwinga paliya lina nalimbi pacishi capanshi, Lesa ndyalapa muntu naumbi, lyelela kutupulusha. ");
INSERT INTO sby_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ba munkuta mpobalabona kubula buyowa kwa Petulo ne Yohane, balakankamana, pakwinga balikuba bantu bulyo, babula lwiyo. Popelapo balenshibeti, balikwenda pamo ne Yesu. ");
INSERT INTO sby_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Mpobalabona usa muntu walasengulwa kaliwemana pepi ne Petulo ne Yohane, balabula pa kubatotekela. ");
INSERT INTO sby_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Balabambileti, bapule munkuta. Balo bashala kabalifwiya. ");
INSERT INTO sby_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Balambeti, “Inga tubensaconi bantu aba? Bantu bonse bekala mu Yelusalemu bacinshi ncobensa bantu aba cikankamanisha ncotwelela kubula kucikana sobwe. ");
INSERT INTO sby_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Nomba pakutina kwambeti awa makani katayampuwo, katubatinishani kwambeti, kabatambanga sha Yesu babandikanga ne muntu uliyense.” ");
INSERT INTO sby_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Mpobalalifwiyeco, balabakuwa ne kubambilisheti, kabatashumbulanga, nambi kwiyisha sha Yesu. ");
INSERT INTO sby_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nomba Petulo ne Yohane balabakumbuleti, “Kamulyomboloshani mobene, nicipeyo calulama pamenso a Lesa, kunyumfwila amwe? Nambi kunyumfwila Lesa? ");
INSERT INTO sby_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Mwandi afwe, nkatwelela kucileka kwambapo pabintu mbyotwalabona ne kubinyumfwa.” ");
INSERT INTO sby_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Nomba bankuta balabatinisha mwangofu, ne kubasungulula. Balacana kwambeti nkabelela kubapa cisubulo, pakwinga bantu bonse balikabatembaula Lesa palico calenshika. ");
INSERT INTO sby_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Usa muntu walasengulwa munshila yakankamanisha walikuba ne byaka byapita makumi ana. ");
INSERT INTO sby_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Petulo ne Yohane mpobalasungululwa, balaya kwambila banabo mbyobalambilwa ne beshimilumbo bamakulene ne bamakulene Baciyuda. ");
INSERT INTO sby_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Bashoma mpobalanyumfweco, balapaila pamo ne moyo umo. Balambeti, “Mwami Lesa, njamwe mwalalenga kwilu, ne cishi capanshi ne lwenje, kayi ne byonse bilimo.” ");
INSERT INTO sby_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Kupitila mu Mushimu Uswepa mwalamba ku mushali wetu mukulukulu Dafeti, musebenshi wenu uyo walambeti, Niciyani calakalalisha bantu batamwishi Lesa, inga bantu balapanganina cani bintu byabulyo? ");
INSERT INTO sby_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Bami bapacishi capanshi balalibambila, nabo bendeleshi balabungana pamo kulwana ne Lesa, kayi ne Wasalwa wakendi. ");
INSERT INTO sby_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Nicakubinga, Helode ne Ponsho Pilato, balabungana mu munshi muno, pamo ne bantu batamwinshi Lesa, kayi ne Baislayeli, kwambeti balwane ne Yesu musebenshi wenu Washomeka uyo ngomwalasala kuba Mesiya. ");
INSERT INTO sby_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","“Neco, balenseco, amwe ncomwalabamba kendi mungofu shenu, kwelana ne kuyanda kwenu kwambeti celela kwinshika. ");
INSERT INTO sby_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Neco Mwami, kamubonani ncebalatutinishinga, kamutunyamfwilishako tobasebenshi benu, kwambeti twambenga maswi enu kwakubula buyowa. ");
INSERT INTO sby_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Tandabulani cikasa cenu kwambeti bantu basengulwe, bingashilo ne bishikukankamanisha, binshike mu lina lya Yesu musebenshi wenu washomeka.” ");
INSERT INTO sby_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Mpobalapwisha kupaila, ng'anda njobalikuba babunganamo yalatatika kutenkana. Bonse balesulilwa ne Mushimu Uswepa, balatatika kwamba maswi a Lesa kwakubula buyowa. ");
INSERT INTO sby_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Likoto lya bashoma Lesa balikuba ne moyo umo ne miyeyo imo. Paliya muntu walikuba ne muyeyo wakwambeti, “Ibi mbyonkute nibyakame ndenka.” Bonse balikuyabana bintu mbyobalikukute. ");
INSERT INTO sby_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Batumwa balikukute bukamboni bwangofu bwa kwambeti Yesu cakubinga walapunduka kubafu. Bonse Lesa walikubaleleka kwine. ");
INSERT INTO sby_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nkapalikuba wabulilwa pakati pabo, pakwinga abo balikukute mabala, nambi manda, balikulishapo ne kuleta mali kuli batumwa. ");
INSERT INTO sby_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Nabo batumwa balikuyaba mali ku muntu uliyense kwelana ne kubulilwa kwakendi. ");
INSERT INTO sby_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Palikuba muntu walikukwiweti Yosefe, wamucikombo ca Levi, walasemenwa ku Saipulasi, uyo batumwa ngobalatumbika lina eti Banabasi, uku ekwambeti, “Shikuyuminisha.” ");
INSERT INTO sby_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nendi walaulisha libala lyakendi, ne kuleta mali kuli batumwa. ");
INSERT INTO sby_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Lino palikuba muntu naumbi lina lyakendi Hananiya ne Safila mukashendi, nabo balaulisha libala lyabo. ");
INSERT INTO sby_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Walanyumfwana ne mukashendi, ne kufunyapo mali ngobalaulisha libala, ambi walatwala kuli batumwa. ");
INSERT INTO sby_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Petulo walamwipusheti, “Hananiya obe, nipacebo cini ulamusuminishi Satana kwingila mumoyo wakobe cakwinseti ulatatiki kubepa Mushimu Uswepa, ne kufunyapo mali ngolaulishi libala lyakobe? ");
INSERT INTO sby_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Sena libala nkalyanga lyakobe kotana ulyulisha? kayi mpowaulisha libala, sena nkowakutenga mali mumakasa akobe? Nkowayandikanga kwisa cisa? Apa uliya kubepa muntu sobwe, nsombi ulabepe Lesa.” ");
INSERT INTO sby_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Hananiya mpwalanyumfwa maswi awa, walawa panshi ne kufwa popelapo. Ici calabayosha kwine bantu bonse balanyumfwako calenshika. ");
INSERT INTO sby_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Batuloba misepela balesa kufungaila citumbico mucikwisa, balacinyamuna ne kuya kubika mu manda. ");
INSERT INTO sby_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Mpopalapita maola atatu, nendi mukashendi walengila mung'anda katacinshi cilenshiki. ");
INSERT INTO sby_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petulo walamwipusheti, “Kong'ambila cena, sena awa emali onka ngomwaulisha libala lyenu? Mutukashuyo walakumbuleti, ‘Ee, wopelowo emulo wakendi.’ ");
INSERT INTO sby_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kayi Petulo walamwipusheti, ‘Inga wasuminina cani kwambeti mwelekeshe Mushimu wa Mwami? Bantu bangakubika baibenu balipansa pa cishinga apa, nenjobe nibakumante.” ");
INSERT INTO sby_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Nendi popelapo walawa panshi pamyendo ya Petulo, ne kufwa. Mpobalengila batuloba misepela basa, balacana kali wafwa kendi. Balanyamuna citumbi ne kuya kubika mu manda pepi ne mpobabika baibendi. ");
INSERT INTO sby_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Mubungano wonse ne bantu bonse nabambi, balanyumfwako balaba ne buyowa. ");
INSERT INTO sby_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Batumwa balensa bingashilo ne bishikukankamanisha bingi pakati pa bantu. Bonse bashoma Klistu balikubungana pamo mu Mukushi wa Solomoni. ");
INSERT INTO sby_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Paliya naba umo walikuba kunsa kwalikoto walalibanda kwambeti abunganenga nabo, nsombi ne kukabeco bantu balikubalumbaisha. ");
INSERT INTO sby_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Bantu bashoma muli Lesa balatatika kufulilako, cakwinseti lyalaba likoto linene lya batuloba ne batukashi. ");
INSERT INTO sby_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Pacebo ca bintu byalikwinsa batumwa, bantu bangi balatatika kuleta nekoneka balwashi babo pa malili ne pa mpasa munshila, kwambeti Petulo apitanga, mpani cifunsha cakendi ngacibakumyako balwashi. ");
INSERT INTO sby_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Makoto abantu alesa kufuma muminshi yashinguluka Yelusalemu balikwisa kabali banyamuna balwashi ne bekatwa ne mishimu yaipa, kayi bonse balikusengulwa. ");
INSERT INTO sby_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Popelapo Mukulene wa Beshimilumbo, ne banendi ba mucipani ca Basaduki mulanyumfwa munyono. Neco balayeya kwinsapo kantu. ");
INSERT INTO sby_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Balabekata batumwa basa ne kubacalila mujele. ");
INSERT INTO sby_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nomba cindi camashiku, mungelo wa Mwami walabicalula bisasa bya jele ne kubapulishamo ne kubambileti, ");
INSERT INTO sby_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Kamuyani mwambile bantu bonse mu Ng'anda ya Lesa maswi abuyumi ubu bwalinolino.” ");
INSERT INTO sby_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Basa batumwa balanyumfwa, balengila mu lubuwa wa Ng'anda ya Lesa mumenemene ne kutatika kwiyisha. Mukulene wa Beshimilumbo mpwalashika ne banendi, walakuwa libungano lya bamakulene Baciyuda. Walatuma bamalonda baku Ng'anda ya Lesa kwambeti benga babamante batumwa basa ku Jele. ");
INSERT INTO sby_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nomba mpobalashika kujele, baliya kubacanamo sobwe. Mpobalabwelako balabambileti, ");
INSERT INTO sby_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Tulacana bishinga byakujele kabili byacalwa ne kupinkwa cena cena, kayi ne bamalonda kabali bemana ncili pacishinga. Nomba mpotulacalulu bisasa, tuliya kucanamo muntu naba umo sobwe.” ");
INSERT INTO sby_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Mukulene wa bamalonda baku Ng'anda ya Lesa ne beshimilumbo bamakulene mpobalanyumfwa awa maswi, balapwilwa mano ne kuyeyeti nicani ceticinshike. ");
INSERT INTO sby_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Muntu naumbi walesa kubambileti, “Kamunyumfwani! Basa bantu mbomwacalila mujele, bali mu Ng'anda ya Lesa baleyishinga bantu.” ");
INSERT INTO sby_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Popelapo mukulene wa bamalonda, pamo ne bashilikali nabambi, balaya kubamanta batumwa. Nsombi baliya kubakakatisha batumwa, pakwinga balikutina bantu kwambeti ngababapwaya mabwe. ");
INSERT INTO sby_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Mpobalaleta batumwa basa, balabemanika pamenso pa nkuta inene ya Bayuda, apo Mukulene wa Beshimilumbo mpwalatatika kubepusha. ");
INSERT INTO sby_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Walambeti, “Mucinshi cena kwambeti, twalamukanisha mwangofu kwambeti, kamutayishanga mulina lya Yesu, nsombi amwe mulamwaya biyisho byenu mu Yelusalemu monse, kayi mulayandanga kutusambila lufu lwa muntuyu?” ");
INSERT INTO sby_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Nomba Petulo ne batumwa banendi balakumbuleti, “Twelela kunyumfwila Lesa, kupita kunyumfwila bantu. ");
INSERT INTO sby_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Amwe mwalashina Yesu pakumupopa pa lusanda. Nomba Lesa wa bamashali betu bakulukulu walamupundusha kubafu. ");
INSERT INTO sby_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","walamusumpula epeloyo ne kumubika kucikasa cakendi cakululyo kuba mutangunishi ne Mupulushi. Walenseco kwambeti ape cindi Baislayeli cakusanduka kufuma ku bwipishi bwabo, kwambeti Lesa abalekelele. ");
INSERT INTO sby_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Njafwe bakamboni ba bintu ibi, ne Mushimu Uswepa uyo Lesa ngwakute kupeti cipo kubantu bakute kumunyumfwila.” ");
INSERT INTO sby_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Bomboloshi bankuta inene mpobalanyumfweco, balakalala kabayanda kubashina. ");
INSERT INTO sby_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Nomba Mufalisi naumbi pakati pabo, lina lyakendi, Gamaliyele, shikwiyisha milawo, uyo bantu ngobalikupa bulemu, walemana. Walambeti, “Batumwa bapuleko pansa nanshi.” ");
INSERT INTO sby_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Apo lino walabambila bomboloshi Bankuta inene kwambeti, “Amwe Baislayeli, cenjelani ne ncomulayandanga kwinshila bantu aba. ");
INSERT INTO sby_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Na mulanukunga ca linolinowa, kwalikuba muntu naumbi lina lyakendi Teuda walikulisumpula ne kulibandeti ni muntu walemekwa, bantu bali myanda ina balamukonkela, nsombi balamushina, bantu bonse balikumukonkela balamwaika ne kupwilalimo. ");
INSERT INTO sby_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Kayi pacindi ncobalikubelenga bantu, palesa naumbi lina lyakendi Yudasi waku Galileya, nendi walayungaula bantu, bangi balamukonkela. Neye balamushina, bantu bonse balikumukonkela balamwaika. ");
INSERT INTO sby_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Neco pankaniyi, ndamwambilishingeti, balekeni bantu aba, balekeni benga. Na ncobalayeyenga ne ncobalenshinga, bilafumunga kubantu nicikamwaike. ");
INSERT INTO sby_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nomba na bilafumunga kuli Lesa, nteti mucikonshe kubakoma sobwe. Ngamucaniketi mulalwanangowa ne Lesa.” Bonse balakonkela maswi ngalamba Gamaliyele. ");
INSERT INTO sby_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Balabakuwa batumwa ne kubengisha mukati, ne kwambeti babakwapule bikoti, ne kubambileti, “Kamutakabweshapo kwambila bantu mu lina lya Yesu.” Popelapo balabaleka. ");
INSERT INTO sby_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Batumwa mpobalapula pansa, balikuba bakondwa kwambeti Lesa lababoneti belela kupenshewa cipansoni pacebo ca Yesu. ");
INSERT INTO sby_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Busuba ne busuba batumwa balapitilisha kwiyisha ne kukambauka Mulumbe Waina mulubuwa lwa Ng'anda ya Lesa, kayi ne mu manda abantu kwambeti Yesu e Wasalwa wa Lesa. ");
INSERT INTO sby_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mu masubawo, beshikwiya balikabaya kufulilako. Bayuda balikwamba Cigiliki balikutongokela Bayuda banabo balikwamba Cihebeli, busuba ne busuba nkabalikuyaba cena mali, ne bipo nabimbi kubamukalubingi babo. ");
INSERT INTO sby_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Batumwa likumi ne babili, balabunganya beshikwiya bonse pamo, ne kubambileti, “Nkacaina kwambeti afwe tushiyenga kukambauka maswi a Lesa, tutatike kusamalila bamukalubingi. ");
INSERT INTO sby_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Mobanse, musalepo pakati penu, batuloba basanu ne babili, babwikalo bwaina, besulilwa ne Mushimu Uswepa, bakute mano, mbotitupe incito iyi. ");
INSERT INTO sby_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Afwe nitulibenge kukupaila, ne kukambauka maswi a Lesa.” ");
INSERT INTO sby_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Bonse balakondwa kunyumfwa maswi alico. Neco balasala; Stefano, muntu wa lushomo, wesulilwa ne Mushimu Uswepa. Filipo ne Pulokolasi ne Nikana ne Timoni. Pamenasi ne Nikolasi waku Antiyokeya, uyo kendi walikukonka kwiyisha kwa Ciyuda. ");
INSERT INTO sby_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Kufumapo balabemanika pamenso pabatumwa, nabo batumwa balapaila ne kubika makasa pa batuloba basa. ");
INSERT INTO sby_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Maswi a Lesa alamwaikila kulikonse, nabo beshikwiya balatatika kufulilako mu Yelusalemu. Beshimilumbo bangi nabo balashoma. ");
INSERT INTO sby_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stefano walikuba muntuyo Lesa ngwalapa colwe ne ngofu shingi, cakwinseti walikwinsa bishikukankamanisha ne bingashilo byangofu pakati pa bantu. ");
INSERT INTO sby_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Kwalesa bantu nabambi balafuma ku Kulene ne ku Alekisandiliya, bakung'anda yakupaililamo yalikukwiweti, Ng'anda ya Mipailo ya bantu Basunguluka. Aba bantu pamo ne bantu baku Kilikiya, neku Asiya, balatatika kutotekeshana ne Stefano. ");
INSERT INTO sby_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Nsombi balalilwa kumushinina, pakwinga Mushimu Uswepa ewalikumupa mano akwamba. ");
INSERT INTO sby_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Lino balayungaula bantu nabambi kwambeti, bambengeti, “Twalamunyumfwa kacobola Mose ne Lesa.” ");
INSERT INTO sby_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Neco, balakalalisha bantu, bamakulene Baciyuda, ne beshikwiyisha milawo ya Mose. Bonse pamo balamubukila Stefano, balamwikata ne kuya nendi ku nkuta inene ya Bayuda. ");
INSERT INTO sby_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Balaleta bakamboni babwepeshi abo balambeti, “Ee muntuyu nishikwambowa maswi akunyansha Ng'anda ya Lesa, kayi ne milawo ya Mose. ");
INSERT INTO sby_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Twalamunyumfwa kambeti, Yesu waku Nasaleti nakapwaye Ng'anda ya Lesa ne kushinta miyambo njalatupa Mose.” ");
INSERT INTO sby_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Bomboloshi bonse balikuba mu nkuta balaswamuna menso abo pali Stefano, pakwinga cinso cakendi calaboneketi ca mungelo. ");
INSERT INTO sby_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Lino, Mukulene wa Beshimilumbo walamwipusha Stefano, “Sena bintu ibi ni byakubinga?” ");
INSERT INTO sby_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Nendi walakumbuleti, “Kamunyumfwani bamatata ne mobanse bame! Lesa wabulemu walabonekela kuli mushali wetu mukulukulu Abulahamu mpwalikwikala ku Mesopotamiya, katanalongela ku Halani. ");
INSERT INTO sby_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Walamwambileti, ‘Fuma mucishi cakobe, ushiye banse bobe, wenga kucishi nceti ndikuleshe.’ ");
INSERT INTO sby_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Walafuma mucishi ca Akaladayo nekuya kwikala ku Halani. Baishi mpobalafwa, Lesa walamufunyako ne kumuleta mucishi cino ncomwekalamo lelo. ");
INSERT INTO sby_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Lesa uliya kumupako nakaba kabela kang'ana kacishici kuba kakendi mwine. Nsombi walamulayeti, cishi conseci nicikabe cakendi ne bashikulu bendi, nikukabeti nkalikukute mwana pacindico. ");
INSERT INTO sby_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Lesa walamwambileti, ‘Bashikulu bobe nibakabe basha mucishi cabwensu moti bakapenshewe kwa byaka myanda ina.’ ");
INSERT INTO sby_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Kayi Lesa walambeti, ‘Ame ninkape mulandu mushobo uyo weti ukabasunge busha. Balo nibakapule mucishico ne kwisa kunkambilila pamusena uno.’ ");
INSERT INTO sby_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Lesa walapangana ne Abulahamu, ne kumupa cingashilo ico ecando cakupalulwa. Neco Abulahamu walamupalula Isake mwanendi, kakute masuba asanu ne atatu akusemwa. Neye Isake walapalula Yakobo mwanendi, neye Yakobo walapalula banabendi bali likumi ne babili, abo ebamashali betu bakulukulu. ");
INSERT INTO sby_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Abo bamashali betu balamunyonokela Yosefe mukwabo, balamulisha busha ku Injipito. Nsombi Lesa walikuba nendi, ");
INSERT INTO sby_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","cakwinseti, walamupulusha mu mapensho akendi onse. Walamupa mano alenshisha kwambeti, Mwami Falawo waku Injipito amuyande, kayi walamubika Yosefe kuba muntu shikwendelesha cishi ca Injipito, kayi mukulene shikulangilila pamukowa wakendi Falawo wonse. ");
INSERT INTO sby_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Nomba mwalaba nsala mucishi conse ca Injipito ne Kenani, bantu balapenga, ne bamashali betu kumo balabula cakulya. ");
INSERT INTO sby_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yakobo mpwalanyumfweti ku Injipito kuli cakulya, walatumako banabendi bamashali betu. Ubu bwalikuba bulwendo bwabo bwakutanguna. ");
INSERT INTO sby_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Pabulwendo bwabo bwacibili, Yosefe walaliyubulula kubakwabo, kayi walamwinshibisha Mwami Falawo shabanse bendi bonse. ");
INSERT INTO sby_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yosefe walabakuwa baishi ba Yakobo, pamo ne banse bendi. Bonse pamo balikuba bantu makumi asanu ne abili ne basanu. ");
INSERT INTO sby_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakobo walaya kwikala ku Injipito pamo ne bamashali betu basa. Bonse balafwila kopeloko. ");
INSERT INTO sby_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Bitumbi byabo byalakabikwa ku Sekemu, kunamaumbwe awo Abulahamu ngwalaula ne mali kubana bendi Hamoli ku Sekemu. ");
INSERT INTO sby_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Cindi mpocalashika pepi kwambeti Lesa akwanilishe cipangano ncalambila Abulahamu, mushobo wetu wali kauli ulafulu mu Injipito. ");
INSERT INTO sby_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Panyuma pakendi kwalapyana Mwami naumbi mu Injipito walikubula kumwinshiba Yosefe. ");
INSERT INTO sby_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mwami uyo walaupita panshi mushobo wetu, walatatika kupensha bamashali betu, pakubakakatisheti bashiyenga bana babo pansa kwambeti bafwe. ");
INSERT INTO sby_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Pacindico Mose walasemwa, walikuba mwana wapa. Walalelwa ne kwa myenshi itatu mung'anda ya baishi. ");
INSERT INTO sby_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Mpobalamushiya pansa mwanendi Falawo mutukashi walamumanta, walikumuleleti mwanendi. ");
INSERT INTO sby_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Neco Mose walaiya mano a bantu bonse baku Injipito, mano ne ncito shakendi shalikuba shangofu.” ");
INSERT INTO sby_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Mose mpwalaba ne byaka makumi ana, walayeya kuya kufwakashila banse bendi bene Islayeli.” ");
INSERT INTO sby_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Lino mpwalabona mwine Injipito kapensha umo wabanse bendi, Mose walamufuna mwine Islayeli ne kumushina mwine Injipito. ");
INSERT INTO sby_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Walikuyeyeti banse bendi bene Islayeli nibenshibe kwambeti Lesa, kufumina muli Mose nakabapulushe, nsombi balo baliya kwingashileco. ");
INSERT INTO sby_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Mpobwalaca mumene walacana bene Islayeli babili kabalwana. Walelekesha kubafuna. Walabambileti, “Amwe batuloba, moba mukowa umo, inga mulalwanininga cani?” ");
INSERT INTO sby_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Nomba uyo walasoka munendi, walanyakila Mose pambali ne kwambeti, “Niyani walakubiketi ube mutangunishi shikutombolosha? ");
INSERT INTO sby_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Sena ulayandanga kunshina mbuli ncowashina mwine Injipito usa lilo?” ");
INSERT INTO sby_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mpwalanyumfweco, Mose walafwambila kucishi censu ca Midyani. Kopeloko nkwalasemena bana batuloba babili. ");
INSERT INTO sby_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Lino mpokwalapita byaka makumi ana, mungelo walabonekela kuli Mose mucinyika pepi ne mulundu wa Sinai, pacinkupu cisa calikubangila mulilo mucinyika. ");
INSERT INTO sby_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mose mpwalaboneci walakankamana, walaseng'ena pepi kwambeti abonesheshe.” Popelapo walanyumfwa liswi lya Lesa lyakwambeti, ");
INSERT INTO sby_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Ame njame Lesa wabamashali bakobe, Lesa wa Abulahamu ne Isake ne Yakobo.” Popelapo Mose walatatika kututuma ne kutina cakwinseti calala kulangako. ");
INSERT INTO sby_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Popelapo Lesa walamwambileti, “Kofulula nkwabilo shakobe, pakwinga pamusena apo mpowalyata Paswepa. ");
INSERT INTO sby_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ndabono kupenshewa kwabantu bakame mu Injipito. Ndanyumfu kulilishanya kwabo, lino ndesa kubapulusha, lino kwesa ndikutume ku Injipito.” ");
INSERT INTO sby_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Uyo Mose engobalakana Baislayeli pakumwipusheti, “Niyani walakubiketi ube mukulene kayi momboloshi wetu?” Epeloyo engwalatuma Lesa kwambeti abe mukulene kayi mupulushi, kufumina mumungelo usa walamubonekela pacinkupu cisa calikubilima mulilo. ");
INSERT INTO sby_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mose ewalabatangunina bantu ne kubapulisha mucishi ca Injipito, walikwinsa bishikukankamanisha, ne bingashilo ku Injipito, palwenje lufubela ne mucinyika, kwabyaka makumi ana. ");
INSERT INTO sby_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mose uyo ewalabambila Baislayeli kwambeti, “Lesa nakatume naumbi kufumina mubanse benu eshakabe mushinshimi eti njame.” ");
INSERT INTO sby_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mose ewalikuba nabo pamubungano wa Baislayeli mucinyika. Nendi ewalemana pamo ne mungelo walikwamba pakati pa bamashali betu bakulukulu pamulundu wa Sinai. Ewalatambula maswi abuyumi akutwambila. ");
INSERT INTO sby_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Bamashali betu bakulukulu balakana kumunyumfwila, pakwinga myoyo yabo yalikuyeya ku Injipito. ");
INSERT INTO sby_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Neco, Aloni balamwambileti, ‘Kotupangila Lesa eshatutanguninenga, pakwinga nkatucishi cilenshiki kuli Mose, walatufunya ku Injipito.’ ");
INSERT INTO sby_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Mumasuba opelawo balabumba cimbwanga ca mwanawang'ombe. Balatwala milumbo kucimbwanga ne kukondwa ne ncito yalabamba makasa abo.” ");
INSERT INTO sby_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Neco Lesa walabafutatila, ne kubaleketi bakambililenga nyenyenshi shakwilu, mbuli ncocalembwa mu mabuku abashinshimi bakulukulu akwambeti, “Amwe Baislayeli, kamutayeyangeti Mwalikubengela ame nyama nshomwali kushina ne kutwala milumbo, kwabyaka makumi ana musa mucinyika. ");
INSERT INTO sby_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mwalikunyamuna lesa wenu Moleki mutente, Ne nyenyenshi ya lesa wenu Lefani, bimbwanga mbyomwalabumba Kwambeti mubikambililenga. Pacebo ico ninkamutandanyine kutali, kupitilila cishi ca Babulo.” ");
INSERT INTO sby_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Bamashali betu bakulukulu balikukute tente wa cipangano walikulesheti Lesa mpwali pakati pabo musa mucinyika. Walapangwa mbuli Lesa ncalamwambila Mose mucikoshanyo ncalabona. ");
INSERT INTO sby_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Uyo tente walapewa ku bamashali betu kufuma ku ba mashali babo, tente iyo yalikuba ya cishiya matongo. Yalikubapo cindi Yoswa mpwalikubatangunina, pakulamuna cishi mishobo njalatandanya Lesa. Tente iyo yalekala mpaka mucindi ca Dafeti. ");
INSERT INTO sby_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Lesa walikumusuna Dafeti, nendi Dafeti walasenga kwambeti amwibakile ng'anda, Lesa wa Yakobo. ");
INSERT INTO sby_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Nomba Solomoni ewalebaka ng'andeyo. ");
INSERT INTO sby_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Nikukabeco Lesa wapita byonse, nkakute kwikala mung'anda yebakwa ne makasa, mbuli ncalamba mushinshimi mukulukulu.” Kwambeti, ");
INSERT INTO sby_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Lesa lambangeti, Kwilu ecipuna cakame ca Bwami, cishi capanshi epakulyata myendo yakame. Ngamunjibakila ng'anda ilyeconi? Nambi nimusena ulyeconi ngondelela kupumwininamo? ");
INSERT INTO sby_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Sena ntame ndalapanga bintu byonsebi?” ");
INSERT INTO sby_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stefano walapitilisha kwambeti, “Ha! Amwe bantu balunkanwa, myoyo yenu ilyeti bantu batashomo Lesa, kayi matwi enu ashinka. Mwakoshanowa ne bamashali benu bakulukulu, pakwinga nenjamwe mulakananga kunyumfwila Mushimu Uswepa.” ");
INSERT INTO sby_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","“Sena pali mushinshimi ngobalabula kupensha bamashali benu bakulukulu? Paliyawa, balo balikushina bantu balikwamba shakwisa kwa Musebenshi Waswepa usa. Nsombi amwe mwalamulisha kubalwani bakendi ne kumushina. ");
INSERT INTO sby_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Amwe omwalatambula Milawo ya Lesa njobalikuleta bangelo pacishi capanshi, nsombi amwe muliya kwikonkela sobwe.” ");
INSERT INTO sby_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Neco Bomboloshi bankuta inene mpobalanyumfwa maswi onse ngalamba Stefano, balatatika kubimba myoyo cebo cabukalu. ");
INSERT INTO sby_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Stefano walesulilwa ne Mushimu Uswepa, walalanga kwilu, walabona bulemeneno bwakendi Lesa, kayi walabona Yesu kali wemana kucikasa cakululyo ca Lesa. ");
INSERT INTO sby_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Popelapo walambeti, “kamubonani! Ndabono kwilu kulacaluku, kayi ndabononga Mwana Muntu wemana kucikasa cakululyo ca Lesa.” ");
INSERT INTO sby_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Popelapo bendeleshi bankuta inene balashinka mumatwi ne kolobesha! Pacindico bonse balafwambila akumutanya Stefano. ");
INSERT INTO sby_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Balamukwekweshela kunsa kwamunshi, nkobalakamupwaya mabwe. Bakamboni balafulula minjila yabo yakunsa ne kwibungika pa myendo ya mutuloba musepela, lina lyakendi Saulo. ");
INSERT INTO sby_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Mpobalikumupwaya mabwe, Stefano walatatika kupaileti, “Yesu Mwami wakame, tambulani mushimu wakame.” ");
INSERT INTO sby_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Walasuntama panshi ne kubilikisheti, “Nkambo kamubalekelelako bwipishi ubu mbobalenshinga.” Mpwalapwisha kwamba awa maswi walataya moyo. ");
INSERT INTO sby_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Nendi Saulo walasuminisheti balenshi cena kumushina. Kufuma busuba bopelobo mapensho mu mubungano waku Yelusalemu alatatika. Bashoma bonse, kufunyakowa batumwa, balamwaikila mubimpansha byonse bya Yudeya ne Samaliya. ");
INSERT INTO sby_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Batuloba nabambi balibenga kuli Lesa ebalamubika Stefano mumanda ne kumulila mwakwetelwa. ");
INSERT INTO sby_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulo walatatika kononga mubungano. Walikwingila mu ng'anda ne ng'anda, kekata batuloba ne batukashi bonse pamo ne kubawala mujele. ");
INSERT INTO sby_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Bashoma basa balamwaika, balaya kukambauka Mulumbe Waina konse nkobalikuya. ");
INSERT INTO sby_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Nendi Filipo walakashika ku Samaliya, kaya kubakambaukila bantu bakopeloko makani a Klistu Mupulushi Walaiwa. ");
INSERT INTO sby_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Makoto abantu mpobalanyumfwa maswi ngalikwamba Filipo, ne kubona bishikukankamanisha mbyalikwinsa, balakutikisheti banyumfwishishe cena. ");
INSERT INTO sby_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Pakwinga ne mishimu yaipa yalikupula mubantu bangi kaibilikisha. Batontola biso ne balema myendo balikusengulwa. ");
INSERT INTO sby_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Neco bantu balikuba mu munshi usa balakondwa. ");
INSERT INTO sby_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Mu munshi wa Samaliya, mwalikuba muntu naumbi, lina lyakendi Shimoni, walikuba mung'anga walikukondwelesha bene Samaliya bonse, muntu walikulibanda mwineti walemekwa. ");
INSERT INTO sby_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Bantu bayampuwo ne bantu bulyo bonse, balikumunyumfwila kabaya kwambeti, “Shimoni uyu ningofu sha Lesa nshobakute kwambeti ngofu shinene.” ");
INSERT INTO sby_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Balikumukonkela konkela, pakwinga kwacindi citali walikubakondwelesha ne bung'anga bwakendi. ");
INSERT INTO sby_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Nomba pacindi Filipo mpwalikukambauka Mulumbe Waina wa Bwami bwa Lesa, kayi ne lina lya Yesu Klistu, bantu balashoma ne kubatishiwa, batuloba ne batukashi. ");
INSERT INTO sby_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Nendi Shimoni mung'anga usa walashoma, ne kubatishiwa. Popelapo walatatika kwenda pamo ne Filipo, pakwinga walakankamana pakubona bishikukamanisha ne bingashilo byangofu mbyalikwinsa Filipo. ");
INSERT INTO sby_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Batumwa basa balashala mu Yelusalemu, mpobalanyumfweti bene Samaliya balatambulu maswi a Lesa, balatumako Petulo ne Yohane. ");
INSERT INTO sby_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Mpobalashika, balatatika kupailila basa bashoma kwambeti batambule Mushimu Uswepa. ");
INSERT INTO sby_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Pacindico paliya muntu naba umo walikuba latambulupo Mushimu Uswepa pakati pabo nekukabeti balikuba babatishiwa mulina lya Mwami Yesu. ");
INSERT INTO sby_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Lino Petulo ne Yohane mpobalabika makasa palyendibo, balatambula Mushimu Uswepa. ");
INSERT INTO sby_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Shimoni usa mpwalaboneti Mushimu Uswepa ulatambulwa, mpobalabikwa makasa ne batumwa basa, walapulisha mali kwambeti abape. ");
INSERT INTO sby_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Walambeti, “Kamumpako ngofu ishi, kwambeti nenjame ngondabiki makasa palyendiye, utambula Mushimu Uswepa.” ");
INSERT INTO sby_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Petulo walamukumbuleti, “Koya ulobe pamo ne mali akobe. Sena ulayeyengeti ngofu sha Lesa nishakula ne mali? ");
INSERT INTO sby_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Muncito iyi, obe uliyamo lubasu sobwe, pakwinga moyo wakobe nkawalulama pamenso a Lesa. ");
INSERT INTO sby_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ecebo cakendi sanduka, leka caipa ncolayeyenga. Senga Mwami Lesa kwambeti akulekeleleko manjeyaulwa aipa ali mumoyo wakobe. ");
INSERT INTO sby_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Pakwinga ndakubono kwambeti ukute munyono waipa, wasungililwa ku bwipishi.” ");
INSERT INTO sby_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Apo Shimoni usa walambeti, “Kamumpaililako kuli Mwami Lesa kwambeti kacitenshika kuli njame ncomulamba.” ");
INSERT INTO sby_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Mpobalapwisha kupa bukamboni ne kukambauka maswi a Lesa, Petulo ne Yohane balabwelela ku Yelusalemu. Balikabaya kukambauka Mulumbe Waina muminshi ingi ya bene Samaliya. ");
INSERT INTO sby_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Mungelo wa Lesa walamwambila Filipo, “Nyamuka, koya kucibela cakumusansa, ukonke nshila ilafumunga ku Yelusalemu kuya ku Gaza nshila isa yapita mucinyika.” ");
INSERT INTO sby_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Cakubinga Filipo walanyamuka, walaya. Walakumanya mwendeleshi wa ku Itopiya muntu walikupewa bulemu, walikusunga nkomwa ya mali a mfulumende ya mwami mutukashi Kandasi wa ku Itopiya. Walikufumina ku Yelusalemu nkwalaya kukambilila Lesa. ");
INSERT INTO sby_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Pacindici walikubwelela kucomwabo kali wekala mung'ola, kabelenga libuku lya mushinshimi Yesaya. ");
INSERT INTO sby_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Mushimu Uswepa walamwambila Filipo, “Koya ku ng'ola isa, wendenga pepi nayo.” ");
INSERT INTO sby_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipo walafwambila kung'ola isa, walanyumfwa mwendeleshi usa kabelenga libuku lya mushinshimi Yesaya. Filipo walamwipusheti, “Nkambo, Sena mulanyumfwishishinga mabala ngomulabelengenga?” ");
INSERT INTO sby_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mwendeleshi usa walakumbuleti, “Ha! Nganyumfwisheconi kwabula muntu naumbi lapandululunga?” Mpwalapwa kwambeco walamusengeti, “Kotanta mung'ola twendele pamo.” ");
INSERT INTO sby_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Awa e Maswi a mu Mabala a Lesa ngalikayakubelenga, “Walikubeti mbelele ilatanguninwanga kuya kushiniwa, eti mwana mbelele wamwena tonto pa kumucesa bweya. Uliya kwambapo nambi liswi limo. ");
INSERT INTO sby_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Balamunyansha, kayi baliya kumombolosha mubululami. Paliya muntu eshakambe shamukowa wakendi, pakwinga buyumi bwakendi bulatimbulwa pacishi capanshi kwakubula kushiyapo mwana.” ");
INSERT INTO sby_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Popelapo Mwendeleshi usa walepusha Filipo, “Kamung'ambilako, inga mushinshimi lambanga bani? Sena lalyambanga mwine, nambi lambanga shamuntu naumbi?” ");
INSERT INTO sby_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Popelapo Filipo walatatika kumukambaukila Mulumbe Waina wa Yesu kutakila pa Mabala a Lesa ngalikubelengapo. ");
INSERT INTO sby_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Kabacenda pamo munshila, balashika pamusena naumbi mpobalacana menshi. Mwendeleshi usa walambeti, “Ntawa menshi apa. Sena pacili nacimbi celela kunkanisha kubatishiwa?” ");
INSERT INTO sby_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipo walakumbuleti, “Ngamubatishiwa na mulashomo ne moyo wenu wonse.” Usa mwendeleshi walambeti, “Ndashoma kwambeti Yesu Klistu ni Mwanendi Lesa.” ");
INSERT INTO sby_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Popelapo mwendeleshi walemanika ng'ola. Bonse babili, Filipo ne mwendeleshi usa, balaya mumenshi, neco Filipo walamubatisha. ");
INSERT INTO sby_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Mpobalikufuma mumenshi, Mushimu wa Lesa walamunyamunapo Filipo. Mwendeleshi usa uliya kumubonapo Filipo kayi, nomba Mwendeleshi usa walapitilisha bulwendo bwakendi kaliwakondwa. ");
INSERT INTO sby_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipo walacaniketi uli ku Azoto. Walapitana mucishi conse kakambauka Mulumbe Waina muminshi yonse mpaka walashika ku Kaisaleya. ");
INSERT INTO sby_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo usa walapitilisha kuyosha sha kushina bantu balikukonkela kwiyisha kwa Yesu. Walaya kuli Mukulene wa Beshimilumbo, ");
INSERT INTO sby_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","kuya kusenga makalata akumusuminisha kuyanawo ku manda akupaililamo ku Damasiko, kwambeti acanako nabambi bantu bacikonkela kwiyisha kwa Yesu, babe batuloba, nambi batukashi abasunge ne kubaleta ku Yelusalemu. ");
INSERT INTO sby_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Mpobalashika pepi ne ku Damasiko mu bulwendo bwakendi, mwakutengashila mumuni watuba tuu walafuma kwilu ne ku mushinguluka. ");
INSERT INTO sby_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Walawa panshi ne ku nyumfwa liswi lya kwambeti, “Saulo, Saulo, ulampenshelenga cani?” ");
INSERT INTO sby_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saulo walepusheti, “Inga njamwe bani Mwami?” Liswi lyalamukumbuleti, “Njame Yesu ngolapenshenga. ");
INSERT INTO sby_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Nyamuka, koya wingile mu munshi uwu, ni bakwambile ca kwinsa.” ");
INSERT INTO sby_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Bantu mbwalikuba nabo balemana, babula ca kwambapo, maswi awo bali kwanyumfwa, nsombi nkabalikumubona muntu walikwamba. ");
INSERT INTO sby_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulo walanyamuka, nsombi mpwalakapula menso, calala kubona cili conse. Neco banendi mbwalikuba nabo balengila nendi mu munshi wa Damasiko kabali bamwikatilila ku cikasa. ");
INSERT INTO sby_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Walekala masuba atatu katabono, katali cakulya, nambi kunwa cili conse. ");
INSERT INTO sby_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Lino mu Damasiko mwalikuba shikwiya naumbi lina lyakendi Hananiya. Uyo walabona mucimbonimboni Mwami kamukuweti, “Hananiya!” Nendi walakumbuleti, “Mwami!” ");
INSERT INTO sby_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Lino Mwami wala mwambileti, “Nyamuka, wenga kunshila njobakute kukuweti, ‘Nshila ya Tandabala.’ Washika ku ng'anda ya Yuda, wenga wipusheko muntu wa ku Taliso, lina lyakendi ni Saulo. Lapailinga pacino cindi. ");
INSERT INTO sby_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Mucimbonimboni walabona muntu lina lyakendi ni Hananiya walesa ku bika makasa akendi palyendiye kwambeti akonshe kubona kayi.” ");
INSERT INTO sby_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Mpwalanyumfweco Hananiya walambeti, “Mwami, bantu bangi balang'ambili sha muntuyu, walabenshila bintu byaipa bantu benu ku Yelusalemu. ");
INSERT INTO sby_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Lino kayi uli kuno pakusuminishiwa ne beshimilumbo bamakulene kwambeti ese abasunge abo bonse bakute kukambilila amwe.” ");
INSERT INTO sby_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nsombi nendi Mwami Yesu walamwambileti, “Koya, pakwinga muntuyu ndamusala, ni musebenshi wakame eshakakambaukile mishobo imbi sha Lina lyakame, bami ne bene Islayeli. ");
INSERT INTO sby_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ame nindimuboneshe bishikubaba bingi mbyeshi akanyumfwe pacebo ca lina lyakame.” ");
INSERT INTO sby_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Popelapo Hananiya walanyamuka ne kuya kwingila mu ng'anda umo mwalikuba Saulo. Walabika makasa pali Saulo ne kwambeti, “Mwanse wame Saulo, Mwami Yesu uyo wakubonekela pa nshila mpo wesanga kuno, lantumu. Layandangeti utatike kubona, kayi eti wisulilwe ne Mushimu Uswepa.” ");
INSERT INTO sby_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Popelapo mu menso mwa Saulo mwalafuma bintu bilyeti mamba answi. Walatatika kubona kayi, walanyamuka ne kubatishiwa. ");
INSERT INTO sby_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Panyuma pakulya cakulya, walaba ne ngofu. Saulo walekala ne beshikwiya baku Damasiko kwa masuba ang'ana. ");
INSERT INTO sby_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Mwakutataya cindi, Saulo walatatika kukambauka mu manda akupaililamo a Bayuda, kwambeti Yesu ni Mwanendi Lesa. ");
INSERT INTO sby_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Bantu bonse balikumunyumfwa balakankamana ne kwipushana bene, “Sena uyu nteyo usa walikushina bantu bashoma Yesu ku Yelusalemu? Sena kuno nte leshili kwisa kusunga bantu bamushobo uwu bonse ne kubatwala kuli beshimilumbo bamakulene?” ");
INSERT INTO sby_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ngofu sha Saulo sha kukambauka shali kuya kukonempa, walapwisha mano Bayuda balikwikala mu Damasiko, ne kubashinineti Yesu endiye Mupulushi Walaiwa. ");
INSERT INTO sby_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Mpopalapita cindi citali, Bayuda balapanganeti bamushine Saulo. ");
INSERT INTO sby_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Bantu balikuyanda kumushina bali kumupembelela munshi ne mashiku pacishinga ca mushi kwambeti bamushine. Nomba nabambi bantu balaya kumwambila nshebalapangana. ");
INSERT INTO sby_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Neco pacindi ca mashiku beshikwiya bakendi balamubika mu mutanga ne kumupulishila pa cibwanko ca lubumbu lwa lilinga. ");
INSERT INTO sby_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Mpwalashika ku Yelusalemu, Saulo walelekesha kusankana pamo ne beshikwiya. Nomba bonse balikuba ne buyowa, balikutonshanya kwambeti neye ni shikwiya. ");
INSERT INTO sby_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Popelapo Banabasi, walamumanta Saulo ne kumutwala kuli batumwa. Banabasi walabambila batumwa mbuli Saulo mwalabonena Mwami Yesu pa nshila ya ku Damasiko, ne Mwami ncalamwambila, kayi walabambila ncali kukambauka Saulo mulina lya Yesu mwakubula buyowa ku Damasiko. ");
INSERT INTO sby_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Neco Saulo walekala nabo, walendana mu Yelusalemu monse kaya ku kambauka mulina lya Mwami Yesu mwakubula buyowa. ");
INSERT INTO sby_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Saulo walikwamba ne kutotekeshana nabo Bayuda bali kwamba Cigiliki. Pacebo ico, naboyo balelekesha kumushina. ");
INSERT INTO sby_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Beshikwiya mpobala nyumfweco, balaya pamo nendi ku Kaisaleya, ne kumutuma ku Taliso. ");
INSERT INTO sby_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Mibungano yonse yaku Yudeya, ne ku Galileya, kayi ne ku Samaliya yalekala mubote. Kayi yalayumayuma, bantu balafula, pakwinga bantu cindi conse balikupa bulemu Mwami. Kayi Mushimu Uswepa walikubayuminisha. ");
INSERT INTO sby_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petulo mpwali kwendana uku ne uku, walakekala pamo ne bantu ba Lesa baku Lida. ");
INSERT INTO sby_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Uko nkwalacana mutuloba naumbi lina lyakendi Eneya, walikuba watontola biso bya mubili, walikonowa pampasa kwa byaka bisanu ne bitatu, kwakubula kupunduka. ");
INSERT INTO sby_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petulo walamwambileti, “Eneya, Yesu Klistu lakusengulunga. Punduka, yansula mpasa yakobe.” Popelapo walapunduka. ");
INSERT INTO sby_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Mpobalamubona bantu bonse bekala mu Lida, ne mu Saloni, balashoma Mwami. ");
INSERT INTO sby_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ku Yopa kwalikuba shikwiya naumbi mutukashi, lina lya kendi Tabita mu Cigiliki ni Dolika. Wali kwinsa ncito shingi shaina, wali kunyamfwa bapenshi. ");
INSERT INTO sby_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Pacindico Dolika walakolwa ne kufwa. Bantu balasambisha citumbi, ne kuconeka mu cipinda capelu mu ng'anda. ");
INSERT INTO sby_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ku Yopa kwalikuba pepi ne ku Lida, neco beshikwiya mpobalanyumfweti Petulo uli ku Lida, balatuma bantu babili kuya kumwambileti, “Tulapapata, kamwisani kuno lino lino.” ");
INSERT INTO sby_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Petulo walanyamuka ne kuya nabo. Mpwalashika, balamushindikila mu cipinda ca pelu cisa. Walacanamo batukashi bangi bamukalubingi kabalila, balamushinguluka Petulo ne kumulesha minjila ne byakufwala nabimbi mbyali kutunga Dolika, cindi ncalikuba muyumi. ");
INSERT INTO sby_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petulo walasenga bonse mwa bulemu kwambeti benga pansa. Walasuntama panshi ne kupaila. Walacebukila kwalikuba citumbi cisa ne kwambeti, “Tabita, punduka!” Tabita walakapula, mpwalabona Petulo, walekala ne kwikala. ");
INSERT INTO sby_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petulo walamwikata kucikasa ne kumunyamfwilisha kwimana. Petulo walakuwa bantu bonse, bashoma Lesa, ne basa batukashi bamukalubingi, ne kumutwala Tabita kulyendibo kali muyumi ntaa! ");
INSERT INTO sby_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Makani awa mpwalanyumfwika ku Yopa, bantu bangi balashoma Mwami Lesa. ");
INSERT INTO sby_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petulo walekala masuba angi ku Yopa ku ng'anda ya muntu naumbi lina lyakendi Shimoni, kanyuka mpaya. ");
INSERT INTO sby_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ku Kaisaleya kwalikuba muntu naumbi lina lyendi Kolonelyo. Muntuyu walikuba mukulene wabashilikali Baciloma, bamulikoto lyalikukwiweti “Likoto lyaku Italiya.” ");
INSERT INTO sby_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Walikuba muntu walibenga, shikutina Lesa, pamo ne bantu bonse bamung'anda yakendi.Walikunyamfwilisha Bayuda bapenga kayi nekupaila Lesa cindi conse. ");
INSERT INTO sby_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Busuba nabumbi cindi camuma 3 koloko mansailo, walabona bintu mucimbonimboni. Walabona mungelo wa Lesa kesa kulyendiye ne kwambeti, “Koloneliyo!” ");
INSERT INTO sby_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Nendi Koloneliyo walamulangishisha mungeloyo, cabuyowa, ne kumwipusheti, “Nicani Nkambo?” Mungeloyo walambeti, “Lesa lakondwa ne mipailo yakobe, kayi lanuku ncito shakobe shankumbo. ");
INSERT INTO sby_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Pacino cindi kotuma bantu ku Yopa, benga bakuwe muntu lina lyakendi Shimoni, ukute kukwiweti Petulo. ");
INSERT INTO sby_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Lekalanga kuli Shimoni naumbi, kanyuka mpaya, ng'anda yakendi ili mumbali mwa lwenje.” ");
INSERT INTO sby_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Mpwalafumapo mungelo usa ngwalikubandika nendi, Koloneliyo walakuwa basebenshi bakendi babili ne mushilikali. Uyo mushilkali walikuba umo wa abo balikumusebensela, neye walikuba muntu usuni kupaila Lesa. ");
INSERT INTO sby_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Koloneliyo mpwalapwisha kubambila byonse, walabatuma ku Yopa kwalikuba Petulo. ");
INSERT INTO sby_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Mpobwalaca, basa bantu balatumwa kabacili munshila pepi ne munshi, Petulo walatanta pelu paciluli cabwantalala kuya kupaila, lisuba kalili pamutwi. ");
INSERT INTO sby_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Petulo kacili pacilulico, walanyumfwa nsala, walikuyanda kulyapo kantu. Kabacibamba cakulya, kwalesa cimbonimboni kulyendiye. ");
INSERT INTO sby_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Walabona Kwilu kwalacaluka, ne cintu calikwisa panshi calikuboneketi cikwisa cinene casungwa nkokola pelu shina. ");
INSERT INTO sby_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mopelomo mwalikuba banyama bamishobo ya shiyanashiyana, beshikukalaba, ne bikeni bishikuluka mwilu. ");
INSERT INTO sby_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Petulo walanyumfwa liswi lyakwambeti, “Petulo, Punduka, koshina ulye.” ");
INSERT INTO sby_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Petulo walambeti, “Sobwe, Nkambo, ame nkanandyapo cintu cabula kuswepa, nambi cishikusesemya.” ");
INSERT INTO sby_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Kayi Petulo walanyumfwa liswi lya kwambeti, “Bintu mbyalaswepeshe Lesa, obe kotambeti nkabyaswepa sobwe.” ");
INSERT INTO sby_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ici calenshika tunkanda tutatu, panyuma pakendi cikwisa cisa calabwelela kwilu. ");
INSERT INTO sby_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Cindi Petulo mpwalikuyeya bupandulushi bwacintu cisa ncalabona mu cimbonimboni, basa bantu batatu balatumwa ne Kolonelyo, balecana ng'anda ya Shimoni, ne kwimana pacishinga. ");
INSERT INTO sby_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Balakuwa ne kwipusheti, “Sena paliko mwensu pano lina lyakendi Shimoni, ukute kukwiweti Petulo?” ");
INSERT INTO sby_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petulo kaciyeya sha bintu bisa mbyalabona mucimbonimboni, Mushimu Uswepa walamwambileti, “Kobona bantu batatu balakuyandaulunga. ");
INSERT INTO sby_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Nyamuka, seluka, wenga nabo kotatonshanya sobwe, pakwinga njame ndabatumu.” ");
INSERT INTO sby_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Petulo walaseluka ne kubambila bantu basa, “Muntu ngomulalangaulunga njame. Muleshili cani?” ");
INSERT INTO sby_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Balo balambeti, “Kolonelyo, mukulene wabashilikali latutumu kulinjamwe. Nimuntu walulama, kayi ukute kutina Lesa, Bayuda bonse bakute kumulumba. Mungelo wa Lesa ewamwambileti amukuwe kung'anda kwakendi kwambeti enganyumfwishishe cena maswi ngomukute.” ");
INSERT INTO sby_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Popelapo Petulo walabengisha mung'anda, ne kubasengeti bone. Mpobwalaca mumenemene walanyamuka ne kuya nabo. Beshikwiya nabambi baku Yopa balamushindikila. ");
INSERT INTO sby_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Busuba bwakonkapo, balakashika ku Kaisaleya. Kolonelyo walikabapembelela, pamo ne bakwabo ne banendi mbwalakuwa. ");
INSERT INTO sby_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petulo mpwalashika pepi kwambeti engile mung'anda, Kolonelyo walamutambula ne kuliwisha pamyendo ya Petulo, kwambeti amukambilile. ");
INSERT INTO sby_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Nomba Petulo walamunyamfwilisha kwimana, walambeti, “Aa! Imana, nenjame ndemuntu mbuli njobe!” ");
INSERT INTO sby_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Petulo walikaya kwamba ne Kolonelyo mpobalikwingila mung'anda, umo mwalacana bantu bangi babungana. ");
INSERT INTO sby_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Petulo walabambileti, “Amwe mucinshi cena kwambeti, Muyuda nkasuminishiwa ne mulawo, kusankana ne muntu wamushobo umbi, nambi kwingila mung'anda yakendi sobwe. Nsombi Lesa lanjinshibishi kwambeti, kantambila muntu uliyenseti nkaswepa, nambi eti wasesemya sobwe. ");
INSERT INTO sby_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ecebo cakendi ndesa kuno ndiya kukana mpomulankuwu. Lino ndayandanga kwinshiba ncemulankuwili kuno.” ");
INSERT INTO sby_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kolonelyo walambeti, “Masuba atatu alapitipo, cindi copele cino camuma 3 koloko mansailo ndalikampaila mung'anda yakame. Ndalabonowa muntu wafwala byakufwala byabekema kaliwemana pantangu pakame.” ");
INSERT INTO sby_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Walang'ambileti, “Kolonelyo! Lesa lanyumfu mupailo wakobe, lanuku ncito shakobe shankumbo. ");
INSERT INTO sby_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Lino kotuma bantu ku Yopa benga bakuwe Shimoni, ukute kukwiweti Petulo. Uyu muntu lekalanga kuli Shimoni kanyuka mpaya, ng'anda yakendi ili mumbali mwa lwenje ");
INSERT INTO sby_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ecebo cakendi ndamutumina bantu mwabwangu bwangu, mulenshi cena kwisa. Tuli pano twense pamenso a Lesa kwambeti tunyumfwe bintu byonse Lesa mbyalamwambili kwambeti mutwambile.” ");
INSERT INTO sby_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pakutatikowa kwamba, Petulo walambeti, “Cakubinga lelo ndenshibi kwambeti, Lesa uliya lusalululo. ");
INSERT INTO sby_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Nendi ukute kutambula muntu wamushobo uliwonse uyo lamutininga, kayi lenshinga byalulama. ");
INSERT INTO sby_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Mucinshi kwambeti bene Islayeli walabatumina maswi, ne kubambila Mulumbe Waina wa lumuno kupitila muli Yesu Klistu, Mwami wa bantu bonse. ");
INSERT INTO sby_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mubinshi cena byalenshika mucishi conse ca Islayeli, kutatikila ku Galileya, kufuma pacindi Yohane mpwalikukambauka sha lubatisho. ");
INSERT INTO sby_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Mwainshi makani a Yesu waku Nasaleti, kwambeti Lesa walamunanika Mushimu Uswepa ne kumupa ngofu. Walendana paliponse, kaya kwinsa ncito shaina, kusengula bonse abo balikupenshewa ne Muyungaushi, pakwinga Lesa walikuba nendiye. ");
INSERT INTO sby_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Afwe njafwe bakamboni wabintu byonse byalenshika mu Yelusalemu, ne mucishi conse ca Islayeli. Balo balamushina nekumupopa pa lusanda. ");
INSERT INTO sby_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Nsombi pa busuba bwabutatu Lesa walamupundusha kubafu, ne kumusuminisha kwambeti abonekele. ");
INSERT INTO sby_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Uliya kubonekela kubantu bonse sobwe, nsombi kuli bakamboni abo Lesa mbwalasalilalimo. Uku ekwambeti walabonekela kulinjafwe, afwe otwalikulya nekunwa nendi pamo panyuma pakupunduka kubafu. ");
INSERT INTO sby_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Kayi walatulailila kwambeti twelela kuya kukambaukila bantu bonse, ne kumubela bukamboni kwambeti endiye ngwalasala Lesa kuba momboloshi wabantu bayumi ne bafwa. ");
INSERT INTO sby_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Bashinshimi bonse balamwinshila bukamboni, ne kwambeti pacebo ca lina lyakendi, Lesa nakalekelele bwipishi bwa muntu uliyense wamushoma.” ");
INSERT INTO sby_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petulo kacamba, Mushimu Uswepa waletikila pa bantu bonse balikunyumfwa maswi awo. ");
INSERT INTO sby_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Bayuda bashoma Mwami Yesu abo balamushindikila Petulo, balakankamana mpobalabona kwambeti Lesa labapa bantu bakunsa cipo ca Mushimu Uswepa. ");
INSERT INTO sby_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Pakwinga balabanyumfwa kabamba milaka yensu, kabatembaula bukulene bwa Lesa. Lino Petulo walambeti, ");
INSERT INTO sby_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Aba bantu balatambulu Mushimu Uswepa mbuli ncotwalatambula afwe, sena pali muntu naumbi welela kubakanisha kubatishiwa mumenshi?” ");
INSERT INTO sby_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Lino walabambileti, belela kubatishiwa mu Lina lya Yesu Klistu. Abo bantu balamusengeti ekale nabo kwa masuba ang'ana. ");
INSERT INTO sby_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Batumwa, ne bonse bashoma Yesu, balikuba mu Yudeya, balanyumfweti naboyo bantu ba mishobo naimbi balatambula maswi a Lesa. ");
INSERT INTO sby_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Petulo mpwalabwelela ku Yelusalemu, bantu balikuba bayuminina nta kuciyisho ca kupalula, balatotekeshana nendi. ");
INSERT INTO sby_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Balo balambeti, “Obe walaya kwingila mu ng'anda ya muntu wabula kupalulwa, ne kulya nendi pamo.” ");
INSERT INTO sby_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Petulo walatatika kubambila cena bintu byalenshika. Walambeti, ");
INSERT INTO sby_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ame ndalikupaila mu munshi wa Yopa. Popelapo mucimbonimboni ndalabona cintu calikwisa panshi kufuma kwilu. Calikuboneketi cikwisa cinene casungwa nkokola shina, calesa mpondalikuba. ");
INSERT INTO sby_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mpondalalangishisha, ndalabonamo banyama bamucisuwa ne beshikukalaba kayi ne bikeni bishikuluka. ");
INSERT INTO sby_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ndalanyumfwa maswi akung'ambileti, ‘Petulo, punduka, koshina, ulye.’ ");
INSERT INTO sby_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nomba ndalambeti, ‘Sobwe, Nkambo! Ame nkanandyapo cintu cabula kuswepa, cishikusesemya kufumina na nililyoni.’ ");
INSERT INTO sby_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Nomba liswi lyalafuma kwilu lyalamba kayi eti, ‘Bintu mbyalaswepeshe Lesa, obe kotambeti byashilila.’ ");
INSERT INTO sby_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ici calenshika tunkanda tutatu, panyuma pakendi byonse byalamantwa kayi kuya kwilu. ");
INSERT INTO sby_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Pacindi copeleco, kung'anda nkondali kwikala, kwalashika bantu batatu, balatumwa kulinjame kufuma ku Kaisaleya. ");
INSERT INTO sby_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Mushimu Uswepa walang'ambileti, kantakana kuya nabo sobwe. Aba banse basanu ne umo nabo balanshindikila, mpaka twalengila mu ng'anda ya Kolonelyo. ");
INSERT INTO sby_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Neye walatwambila mbuli ncalabona mungelo kaliwemana mu ng'anda yakendi, ne kumwambileti, ‘Kotuma bantu ku Yopa benga bakuwe Shimoni, ukute kukwiweti Petulo. ");
INSERT INTO sby_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Nendi nakwambile maswi alupulusho lwakobe, ne bamung'nda yakobe bonse.’ ");
INSERT INTO sby_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Lino mpondalatatika kwamba, Mushimu Uswepa walesa palyendibo, mbuli ncewalesa pali njafwe pasa pakutatika. ");
INSERT INTO sby_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Popelapo ndalanuka maswi asa ngalamba Mwami Yesu akwambeti, ‘Yohane walikubatisha ne menshi, nomba amwe nimukabatishiwe ne Mushimu Uswepa.’ ");
INSERT INTO sby_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Neco na Lesa walabapa cipo cimocimo mbuli ncalatupa afwe mpotwalashoma Mwami Yesu Klistu, ame njame bani kwambeti ndimukanishe Lesa?” ");
INSERT INTO sby_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Mpobalanyumfweco basa balikutotekeshana ne Petulo, balacileka kumutoteka. Balatembaula Lesa ne kwambeti, “Anu ekwambeti Lesa labapa naboyo bantu batamwinshi, colwe cakwambeti bashiye micito yabo yaipa ne kutambula buyumi.” ");
INSERT INTO sby_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Basa bashoma Klistu, balapalangana cebo camapensho alabuka palufu lwa Stefano. Balakashika ku Fenishiya, ku Saipulasi ne ku Antiyokeya. Aba bantu nkabali kukambaukila muntu uliyense sobwe, nsombi Bayuda bonka. ");
INSERT INTO sby_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Palikuba bantu nabambi balafumina ku Saipulasi, neku Kulene. Aba balashika ku Antiyokeya, kabaya kukambauka ku Bagiliki naboyo, Mulumbe Waina ulambanga sha Mwami Yesu. ");
INSERT INTO sby_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ngofu sha Mwami Lesa shalikubanyamfwilisha, cakwinseti bantu bangi balashoma ne kusandukila kuli Mwami Yesu. ");
INSERT INTO sby_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Makani awa mpwalanyumfwika ku mubungano waku Yelusalemu, balatumako Banabasi ku Antiyokeya. ");
INSERT INTO sby_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Mpwalashika ne kubona Lesa ncalapa colwe abo bantu, walakondwa ne kubayuminisheti batwalilile kushoma Mwami Yesu ne myoyo yabo yonse. ");
INSERT INTO sby_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabasi walikuba muntu walulama, walikutanguninwa ne Mushimu Uswepa ne lushomo lunene, neco bantu bangi balaletwa kuli Mwami Yesu. ");
INSERT INTO sby_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kufumapo Banabasi walaya ku Taliso, kuya kulangaula Saulo. ");
INSERT INTO sby_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Mpwalamucana Saulo, walesa nendi pamo ku Antiyokeya. Bonse pamo balekala mu mubungano waku Antiyokeya, ne kwiyisha bantu bangi kwacaka cimo. Uku ku Antiyokeya, enkobatatikila beshikwiya kukwiweti baklistu. ");
INSERT INTO sby_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Mu masubayo kwalashika bashinshimi ba Lesa nabambi ku Antiyokeya balafumina ku Yelusalemu. ");
INSERT INTO sby_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Naumbi mushishimi lina lyakendi Agabu, walemana ne kushinshima kupitila mu mushimu wa Lesa, kwambeti mucishi conse mulakabanga nsala inene. Nsala iyi yalabako pacindi Kulodiyasi mpwalikuba mwami mukulene waku Loma. ");
INSERT INTO sby_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Cindici baklistu balayeyeti uliyense atumeko lunyamfwo kubanse balikwikala mu Yudeya, uliyense atume kwelana mbuli ncabele pang'anda, ico ncelela kukonsha. ");
INSERT INTO sby_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Mpobalapwa kubunganya bipo, balapa Banabasi ne Saulo kwambeti batwale ku bamakulene ba mubungano waku Yelusalemu. ");
INSERT INTO sby_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Palikuba pacindi copeleco Mwami Helode mpwalekata nabambi bamu mubungano wa bashoma, kwambeti abapenshe. ");
INSERT INTO sby_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Walambila mushilikali kwambeti ashine Jemusi, mukwabo Yohane, ne cibeshi. Nendi walamushina. ");
INSERT INTO sby_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Mpwalaboneti ici cilakondweleshe Bayuda, walatuma bashilikali kuya kwikata Petulo. Ici calenshika pacindi ca Pasika, kusekelela kwa shinkwa wabula cishikufufumusha. ");
INSERT INTO sby_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Mpobalamwikata, balamuwala mujele, umo mwalikupembelelwa ne makoto ana abashilikali. Kalikoto kamo kalikuba ne bashilikali bana. Helode walikuyanda kumombolosha Petulo pamenso abantu bangi, panyuma pakusekelela Pasika. ");
INSERT INTO sby_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Neco Petulo walikuba wasungwa mujele. Nomba bantu mu mubungano balikupaila cangofu kuli Lesa. ");
INSERT INTO sby_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Mashiku, kwambeti lilo bwakaca Helode akamomboloshe, Petulo walikuba wona pakati pa bashilikali babili. Walikuba wasungwa ncetani shibili, napo pacishinga palikuba bamalonda nabambi. ");
INSERT INTO sby_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Kwakubula kwingashila mungelo wa Lesa walashika, mucipinda mobalikuba mwalatuba tuu. Mungeloyo walamunyukumuna mumbafu Petulo, ne kumwambileti, “Fwambana, kupunduka!” Pacindi copeleco ncetani shalalaka kumakasa mbwee panshi. ");
INSERT INTO sby_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Kayi mungelo usa walamwambileti, “Fwala mukopo ne nkwabilo shakobe.” Petulo mpwalenseco, mungelo usa kayi walambeti, “Fwala mwinjila wakobe wapelu, unkonkele.” ");
INSERT INTO sby_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petulo walapula kaya kumukonkela, nomba nkalikwinshibeti cilenshinga mungelo nicakubinga. Nendi walikuyeyeti nicimbonimboni. ");
INSERT INTO sby_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Mungelo usa pamo ne Petulo, balapitilila kalikoto kabashilikali kakutanguna, kayi pakalikoto kacibili, mpaka balakashika pacisasa ca nshimbi cakwingilila mu munshi. Cisasa calacaluka conka, balo balapula kabaya kwenda munshila ya mu munshi, mungelo usa walashimangana. ");
INSERT INTO sby_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Petulo mpwalashinshimuka walambeti, “Cakubinga lino ndenshibeti Mwami Lesa langa latumu mungelo wakendi kwisa kumpulusha kuli Helode, ne Bayuda abo bapembelelanga kwambeti babone ceticinshike kulinjame.” ");
INSERT INTO sby_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Mpwalenshibeco, walaya kung'anda ya Maliya banyina Yohane Maliko, uko bantu bangi nkobalikuba babungana kabapaila. ");
INSERT INTO sby_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petulo mpwalakonkosha pa cisasa cakunsa, mutukashi musebenshi, lina lyakendi Loda, walesa kwambeti acalule. ");
INSERT INTO sby_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nomba mpwalenshiba liswi kwambeti nilya Petulo, walakondwa cakwinseti uliya kucalula cisasa, walafwambila mukati nekuya kubambileti, “Petulo wemana pacishinga pansapa!” ");
INSERT INTO sby_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Balo balambeti, “Obe ulakonyo!” Nsombi nendi walapitilisha kwambeti nicakubinga. Neco balo balambeti, “Mpani ulanyumfu liswi lya mungelo wakendi.” ");
INSERT INTO sby_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Petulo walapitilisha kukonkoshowa pacisasa. Mpobalacalula cisasa ne kumuboneti cakubinga endiye Petulo, balekatowa pamulomo. ");
INSERT INTO sby_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petulo walabamweneka ne cikasa cakendi, kwambeti abambile mbuli Lesa ncalamupulishi mujele. Walambeti, “Mwenga mumwambile Jemusi, ne banse nabambi makani awa.” Popelapo Petulo walapula nekuya kumbi. ");
INSERT INTO sby_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Mpobwalaca mumene, bashilikali balanyongana mu mitwi ne kutina kwambeti, inga nicani cilenshiki kuli Petulo ? ");
INSERT INTO sby_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Helode walambila bashilikali kwambeti bamulangaule, mpobalalilwa kumucana, walabepushisha cena bamalonda basa, nomba walabapa mulandu wakwambeti bashiniwe. Panyuma pakendi Helode walafumako ku Yudeya, nekuya kwikala ku Kaisaleya. ");
INSERT INTO sby_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Helode walepilwa nabo bantu baku Tulo ne Sidoni. Neco bantu ba mumisena iyi balatuma kalikoto kabantu kwambeti benga banyumfwane nendi. Cakutanguna balaya kuli Blasito, mukulene waku ng'anda ya mwami Helode kwambeti abanyamfwilishe. Kufumapo balaya kuli Helode kuya kumusengeti pabe lumuno, pakwinga cakulya ncebalikukute mucishi cabo, calikufumina mucishi ca mwami Helode. ");
INSERT INTO sby_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Pabusuba mbobalapangana, Helode walafwala byakufwala byacami, walekala pacipuna cabwami, ne kutatika kubambila bantu basa. ");
INSERT INTO sby_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Bantu balabilikisheti, “Nteyo muntu lambanga sobwe! Nsombi ni Lesa!” ");
INSERT INTO sby_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Popelapo mungelo wa Lesa, walalengesheti Helode akolwe bulwashi, pakwinga uliya kulemeka Lesa. Myambo yamulibunda eyalamulya nekumushina. ");
INSERT INTO sby_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Lino maswi a Lesa alamwaikila kulikonse bantu bangi balashoma. ");
INSERT INTO sby_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabasi ne Saulo mpobalakwanilisha ncebalabatumina ku Yelusalemu, balabwelako. Balamantako Yohane Maliko. ");
INSERT INTO sby_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Mu mubungano waku Antiyokeya mwalikuba bashinshimi ne beshikwiyisha aba; Banabasi ne Shimoni walikukwiweti muntu mushipa, ne Lusiya waku Kulene, ne Manaeni uyo walalelwa pamo ne Mwami Helode, kayi ne Saulo. ");
INSERT INTO sby_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Busuba nabumbi mpobalabungana kwambeti bamutembaule Lesa, ne kwambeti balikanishe kulya cakulya, Mushimu Uswepa walabambileti, “Kamumbikilani palubasu Banabasi ne Saulo, kwambeti benga basebense ncito njendalabakuwila.” ");
INSERT INTO sby_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Lino panyuma pakulikanisha kulya ne kupaila ne kubika makasa palyendibo, balabatuma. ");
INSERT INTO sby_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Banabasi ne Saulo, balatumwa ne Mushimu Uswepa, balaya ku Selukeya. Kufuma uko balatanta bwato ne kuya kushika pansumbu ya Saipulasi. ");
INSERT INTO sby_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Mpobalashika mu munshi wa Salamu, balakambauka maswi a Lesa mu manda akupaililamo a Bayuda. Balikuba ne Yohane uyo walikubanyamfwilisha. ");
INSERT INTO sby_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Balendana pansumbu ponse, mpaka balashika ku munshi wa Pafosi. Uko nkobalacana mung'anga, lina lyakendi, Bala-yesu Muyuda, mushinshimi mubepeshi. ");
INSERT INTO sby_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Uyu muntu walikuba munendi Mwendeleshi Selegiyo Paulo, muntu wacenjela. Uyu Selegiyo Paulo, walakuwa Banabasi ne Saulo, pakwinga walikuyandishisha kunyumfwa maswi a Lesa. ");
INSERT INTO sby_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Elimasi mung'anga usa, Elimasi nilina nalimbi lya Bala-Yesu mu Cigiliki. Walatotekana nabo, kwelekesha kushinkilisha mwendeleshi kwambeti katashoma muli Yesu. ");
INSERT INTO sby_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Nomba Saulo, uyo walikukwiweti Paulo, walesulilwa ne Mushimu Uswepa, walamulangishisha ");
INSERT INTO sby_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","walamwambileti, “Obe mwanendi Muyungaushi, mulwani wabululami, obe weshikulicenjelesha ne bwipishi, nukaleke lilyoni kufulunganya makani akubinga a Mwami Lesa? ");
INSERT INTO sby_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Pacindi copele cino Mwami Lesa nakomboloshe ne kukupa mulandu, nushipilwe nteti ulibonepo lisuba kwakacindi kang'ana.” Popelapo mushinshe wa shikunku walamufweka mumenso. Elimasi walashipilwa walatatika kulipuntapunta, kulangaula muntu welela kumutanguninako kaliwamwikata kucikasa. ");
INSERT INTO sby_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Mwendeleshi usa mpwalabona calenshika, walashoma. Walakankamana pakunyumfwa mbyobalikwiyisha bya Mwami Yesu. ");
INSERT INTO sby_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulo ne banendi balatanta bwato ku Pafosi kuya ku Pega, mucibela ca Pamfiliya. Nomba Yohane walabashiya walabwela combenyuma ku Yelusalemu. ");
INSERT INTO sby_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Mpobalafuma ku Pega, balapitilila mpaka balashika ku Antiyokeya mucibela ca Pisidiya. Pa busuba bwa Sabata balengila mu ng'anda mobalikupailila Bayuda, balekala panshi. ");
INSERT INTO sby_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Bamakulene bang'anda yakupaililamo mpobalabelenga maswi mulibuku lya Milawo ya Mose, ne mulibuku lyabashinshimi bakulukulu, balabatumina maswi akwambeti, “Mobanse, na mukutepo maswi akuyuminishako bantu balikuno, tulamusengenga ngamwambapo.” ");
INSERT INTO sby_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Popelapo Paulo walanyamuka ne kubamweneka bantu ne makasa ne kwambeti. “Amwe Baislayeli baname, ne njamwe mwense mukute kutembaula Lesa, kamunyumfwani! ");
INSERT INTO sby_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Lesa wamushobo wetu afwe Baislayeli, walasala bamashali betu bakulukulu, walabafulisha kabacili bensu mucishi ca Injipito. Walabapulisha mucishico ne cikasa cakendi cangofu. ");
INSERT INTO sby_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Walabalama cena byaka makumi ana mucinyika, nikukabeti balikwalilwa kumunyumfwila. ");
INSERT INTO sby_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Lesa walashina mishobo isanu ne ibili ya bantu balikwikala mucishi ca Kenani, walabalamuna cishico ne kupa Baislayeli kuba cishi cabo.” ");
INSERT INTO sby_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","“Ibi byonse byalamanta byaka pepi myanda ina ne makumi asanu. Kufumapo walabapa bomboloshi kushika kucindi ca Samiyele. ");
INSERT INTO sby_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Bantu balasenga kwambeti Lesa abape Mwami, neco Lesa walabapa Saulo, mwanendi Kisi, wamucikombo ca Benjameni, uyo walabendelesha byaka makumi ana. ");
INSERT INTO sby_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kufumapo Lesa walamufulapo Saulo, ne kubikapo Dafeti kuba Mwami wabo. Pali Dafeti Lesa walambeti, ‘Ndacana Dafeti, mwanendi Jese, emuntu ngonsuni, kayi nakense bintu byonse mbyondayandanga.’ ");
INSERT INTO sby_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kufuma mubashikululwa bamucikombo ca Dafeti, Lesa walasalamo Yesu kuba Mupulushi wa Baislayeli, mbuli ncalalaya. ");
INSERT INTO sby_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesu katanatatika ncito, Yohane walikukambaukila Baislayeli bonse, kwambeti basanduke kushiya bwipishi bwabo ne kubatishiwa. ");
INSERT INTO sby_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Cindi Yohane ncalikuba pepi kupwisha ncito yakendi, walabepusha bantu, ‘Inga amwe mulayeyengeti ame njame bani? Ame ntame uyo ngomulapembelelenga sobwe. Nsombi palesanga naumbi panyuma pakame, ngondelela kubula kufulula nkwabilo shakendi.” ");
INSERT INTO sby_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Mobanse, mobashikululwa ba Abulahamu, ne njamwe mwense mukute kukambilila Lesa, ni kuli njafwe Lesa nkwalatumini mulumbe uwu walupulusho. ");
INSERT INTO sby_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Bantu bekala mu Yelusalemu ne batangunishi baliya kumwinshiba Yesu, kayi baliya kwanyumfwishisha maswi abashinshimi bakulukulu awo ngobalikubelenga pabusuba bwa Sabata bulibonse. kakuli balakwanilisha calambwa ne bashinshimi bakulukulu, pakumombolosha Yesu kwambeti ashiniwe.” ");
INSERT INTO sby_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Nikukabeti baliya kucana mulandu welela lufu, balamusenga Pilato kwambeti Yesuyo ashiniwe. ");
INSERT INTO sby_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Mpobalapwisha kwinsa byonse, mbuli ncebyalembwa mu Mabala a Lesa bilambanga sha Yesu, abo balikukonkela kwiyisha kwakendi, balamuselushapo palusanda, ne kuya kumubika mumanda. ");
INSERT INTO sby_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Nomba Lesa walamupundusha kubafu, ");
INSERT INTO sby_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","walabonekela kwa masuba angi ku bantu basa balikumushindikila kufuma ku Galileya kuya ku Yelusalemu katanafwa. Bantu aba ebakamboni bakendi kubantu bamu Islayeli. ");
INSERT INTO sby_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Neco afwe tulesa kukambauka Mulumbe Waina wa bishomesho Lesa mbyalalaya bamashali betu bakulukulu. ");
INSERT INTO sby_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ibyo mbyalalaya latwinshili afwe, tobashukululwa babo, pakumupundusha Yesu kubafu. Mbuli ncecalembwa Mukutembaula kwacibili kwambeti, Obe omwaname, lelo ndaba baiso. ");
INSERT INTO sby_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Lesa walamupundusha Yesu kubafu kwambeti katabola sobwe. Calenshika mbuli ncalambeti, Ninkakupe colwe caswepa, kayi cancinencine, ico ncendalamulaya Dafeti. ");
INSERT INTO sby_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ecebo cakendi Mukutembaula nakumbi kayi walambeti, Nteti mukalekelele Musebenshi wenu Washomeka kwambeti akabole. ");
INSERT INTO sby_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Awa maswi nkalambanga sha Dafeti, pakwinga Dafeti mubuyumi bwakendi mpwalakwanilisha kusebensa ncito njalamubambila Lesa, walafwa ne kubikwa mu manda uko nkobalabikwa bamashali bakulukulu, mubili wakendi walabola. ");
INSERT INTO sby_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Nomba usa ngwalapundusha Lesa kubafu, mubili wakendi uliya kubolapo sobwe. ");
INSERT INTO sby_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Neco mobanse bame, kamwinshibani kwambeti, kupitila muli Yesu, Lesa lamulekelelenga bwipishi bwenu, ici encotulakambaukunga kulinjamwe. ");
INSERT INTO sby_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Uliyense washoma Yesu walulamikwa pamenso a Lesa, uko nkomwelela kubula kukucana pakukonka Milawo ya Mose. ");
INSERT INTO sby_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Amwe cenjelani, kwambeti byalambwa ne bashinshimi bakulukulu bikabule kwinshika kuli njamwe, Ibyo mbyebalambeti, ");
INSERT INTO sby_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“Kamunyumfwani amwe beshikucobola! Mukankamane ne kufwililila! Pakwinga mucindi cabuyumi bwenu ame ninkensepo cintu nceti mukabule kushoma sobwe, nambi muntu naumbi umusansulwila.” ");
INSERT INTO sby_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paulo ne Banabasi mpobalikupula mung'anda yakupaililamo Bayuda, basa bantu balabasenga kwambeti bakese kayi pa Sabata, kwisa kupitilisha kukambauka pabintu ibi. ");
INSERT INTO sby_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Nomba bantu mpobalamwaika, Bayuda bangi pamo ne bantu nabambi balikukambilila Lesa balikukonkela ciyisho ca Bayuda, balakonkela Paulo ne Banabasi. Bantu aba babili balambila likoto lya bantu, ne kubayuminisha kwambeti bapitilishe kushoma munkumbo sha Lesa. ");
INSERT INTO sby_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Mpobwalashika busuba bwa Sabata, bantu bonse ba mumunshi uwo balabungana kwambeti banyumfwe maswi a Mwami. ");
INSERT INTO sby_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nomba Bayuda basa mpobalabona likoto lyabantu, balanyumfwa munyono. Balatatika kumutoteka Paulo mbyalikwamba, kayi balamucobola. ");
INSERT INTO sby_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Paulo ne Banabasi balamba kwakubula buyowa, balambeti, “Cakubinga calikuba celela kwambeti tukambauke maswi a Lesa kulinjamwe nanshi. Nomba bonani mulakana mobene, mulalileshe mobene kwambeti nkamwelela kutambula buyumi butapu, nitumushiye, nitwenga kubantu bakunsa.” ");
INSERT INTO sby_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Pakwinga Mwami walatwambileti, Ndakubiki kwambeti umunikile bantu bakunsa, Kwambeti bantu balimucishi conse bakapuluke pacebo cakobe. ");
INSERT INTO sby_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Mpobalanyumfweco bantu bakunsa, balakondwa ne kulumba maswi a Mwami. Abo Lesa mbwalasala kwambeti bakatambule buyumi butapu, balashoma. ");
INSERT INTO sby_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Maswi a Mwami alamwaikila kuli konse mucimpansha ici. ");
INSERT INTO sby_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Nomba Bayuda basa balayungaula batukashi bayampuwo abo balikukambilila Lesa ne batangunishi ba mumunshi. Balatatika kupensha Paulo ne Banabasi ne kubatandanya kufuma mucimpansha cabo. ");
INSERT INTO sby_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Paulo ne Banabasi balapampamuna lusuko kumyendo kwabo, kwambeti lube bukamboni bwa kukana kwabo, kufumapo balaya ku Ikoniya. ");
INSERT INTO sby_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Beshikwiya baku Antiyokeya balakondwa kayi balesulilwa ne Mushimu Uswepa. ");
INSERT INTO sby_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Byalenshika ku Antiyokeya, byalenshika kayi ne ku Ikoniya. Paulo ne Banabasi balengila mung'anda yakupaililamo ya Bayuda, umo mobaleyisha cakwinseti bantu bangi, Bayuda ne Bagiliki, balashoma Mwami Yesu. ");
INSERT INTO sby_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Nikukabeco, Bayuda balabula kushoma balayungaula bantu bamishobo naimbi kwambeti babukile abo balashoma. ");
INSERT INTO sby_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Nomba Paulo ne Banabasi balekalako cindi citaliko, kabakambauka maswi kwakubula buyowa, kabali bashintilila muli Mwami, uyo walalesha kwambeti makani ngobali kukambauka alambanga sha nkumbo shakendi nancinencine, mubingashilo ne bishikukankamanisha mbyobalikwinsa. ");
INSERT INTO sby_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Nomba bantu ba mumunshi balapansana, bambi balaba kulubasu lwa Bayuda, nabambi kulubasu lwa batumwa. ");
INSERT INTO sby_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Popelapo bantu bamishobo naimbi ne Bayuda pamo ne batangunishi babo balapangana shakubapensha ne kubapwaya mabwe batumwa. ");
INSERT INTO sby_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Batumwa mpobalanyumfweco, balafwambila ku Lusitala ne ku Debe, mucishi ca Lukoniya ne mumisena ya shinguluka. ");
INSERT INTO sby_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Balakambauka Mulumbe Waina kopeloko. ");
INSERT INTO sby_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ku Lusitala kwalikuba muntu naumbi mulema myendo walikubula kwenda mwalasemenwa. ");
INSERT INTO sby_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Muntuyo walikanyumfwa Paulo mpwalikwamba. Paulo walamulangishisha, mpwalabona lushomo ndwalikukute muntuyu lwakwambeti ngausengulwa, ");
INSERT INTO sby_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","walamba mwakubilikisha maswi, “Olola myendo yakobe, imana.” Popelapo muntuyo walaculukila mwilu ne kutatika kwendenda. ");
INSERT INTO sby_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Makoto abantu mpobalabona calensa Paulo, balabilikisha mu mulaka wabo wa Cilukoniya, “Balesa balafumu kwilu balesa kulinjafwe mucimo cabantu.” ");
INSERT INTO sby_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Neco Banabasi balamupa lina lya lesa wabo Zeu, nendi Paulo balamupa lina lya lesa wabo Hemesi, pakwinga ewalikutanguna kwamba. ");
INSERT INTO sby_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ng'anda njobalikupaililamo Zeu, yalikuba kunsa pepi ne munshi. Shimilumbo wakendi walesa pacishinga, walaleta ng'ombe ne maluba. Muntuyu pamo ne likoto lyabantu balikuyanda kubenga mulumbo kubatumwa. ");
INSERT INTO sby_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Nomba Paulo ne Banabasi, mpobalanyumfweco, balatwamuna byakufwala byabo, ne kufwambila pakati palikoto. Walabilikisha ne kwambeti, ");
INSERT INTO sby_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Amwe mobantu mulayandanga kwinsa cani pano? Njafwe bantu eti ncomubele! Tulamukambaukilinga Mulumbe Waina, kwambeti mushiye bintu mbuli ibi byabula ncito, konkelani Lesa muyumi walalenga kwilu, cishi capanshi, lwenje ne byonse bilimo. ");
INSERT INTO sby_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Mucindi cakunyuma, Lesa walasuminisha bantu bamishobo yonse kwinsa ciliconse mbuli ncobalayandanga. ");
INSERT INTO sby_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Nsombi uliya kuleka kulinshila bukamboni mubintu byaina mbyalikwinsa. Ukute kumupa mfula kufuma kwilu, necindi cakwambeti mbuto shiseme bisepo. Lesa ukute kayi kumupa byakulya bingi byamishobo mishobo ibyo bikute kukondwelesha myoyo yenu.” ");
INSERT INTO sby_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Nambi Paulo walamba maswi awa, calamuyumina kwambeti abakanishe kubenga mulumbo wakubalemeka. ");
INSERT INTO sby_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Kwalesa Bayuda nabambi balafumina ku Antiyokeya mucishi ca Pisidiya ne baku Ikoniya. Balanyengelela likoto lya bantu basa kwambeti babukile Paulo, balamupwaya mabwe ne kumukwekweshela kunsa kwa munshi, pakwinga balayeyeti lafu. ");
INSERT INTO sby_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Nomba beshikwiya balesa ne kumushinguluka, walapunduka ne kubwelela kayi mumunshi umo. Mpobwalaca Paulo ne Banabasi balaya ku Debe. ");
INSERT INTO sby_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paulo ne Banabasi mpobalapwisha kukambauka Mulumbe Waina ku Debe kusa, ne kusandulako bantu kwambeti bashome muli Yesu, balabwelela ku Lusitala, ne ku Ikoniya, ne ku Antiyokeya mucibela ca Pisidiya. ");
INSERT INTO sby_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Balabayuminisha beshikwiya kwambeti, batwalilile kushoma mwangofu kabatataya lushomo lwabo. Balabambileti, “Kwambeti tukengile mu Bwami bwa Lesa, twelela kupita mumapensho angi.” ");
INSERT INTO sby_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pa mubungano uliwonse balabikapo bamakulene. Mpobalapwisha kupaila ne kulikanisha kulya cakulya, balababika mumakasa a Mwami uyo bonse ngobalashoma. ");
INSERT INTO sby_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Balapitilila mucishi ca Pisidiya ne kushika ku Pamfuliya. ");
INSERT INTO sby_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Balakambauka maswi a Lesa ku Pega, panyuma pakendi balaya ku Ataliya. ");
INSERT INTO sby_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Kufuma uko balatanta bwato kuya ku Antiyokeya. Uku enkobalabikwa mumakasa a Lesa pakutatika ncito iyi njobalapwishi. ");
INSERT INTO sby_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Mpobalashika ku Antiyokeya, balakuwa mubungano wonse pamo, ne kubambila byonse Lesa mbyalensa kupitila mulyendibo, kayi ne Lesa mwalacalwila nshila kubantu bamishobo naimbi kwambeti naboyo bamushome. ");
INSERT INTO sby_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Paulo ne Banabasi balekala kopeloko cindi citali pamo ne beshikwiya. ");
INSERT INTO sby_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Bantu nabambi balafuma ku Yudeya, balesa ku Antiyokeya, kabayisha bashoma banabo kwambeti, “Na mubula kupalulwa kwelana ne ncelambanga milawo ya Mose, nkamwelela kupuluka sobwe.” ");
INSERT INTO sby_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Nomba Paulo ne Banabasi baliya kusuminishana ne ciyisho cilico sobwe, neco balatotekeshana nabo cangofu. Lino banse balapangana kwambeti Paulo ne Banabasi ne banse nabambi baku Antiyokeya, bakenga ku Yelusalemu kuya kubandika makani awa pamo ne batumwa ne bamakulene bamubungano waku Yelusalemu. ");
INSERT INTO sby_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Mubungano mpowalabatuma, balapitila ku Foinike ne ku Samaliya, kabaya kwamba mbuli bantu bakunsa mobalikusandukila kuli Lesa. Maswi awa alabakondwelesha beshikwiya bonse. ");
INSERT INTO sby_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Mpobalashika ku Yelusalemu, balatambulwa cena ne mubungano ne batumwa kayi ne bamakulene. Paulo ne Banabasi, balamba ncito shonse Lesa nshalensa kupitila mulyendibo. ");
INSERT INTO sby_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Nomba bashoma nabambi bali kabacili mu kalikoto ka Bafalisi, balanyamuka ne kwambeti, “Bantu balafumunga mumishobo naimbi kuba beshikwiya ba Yesu belela kupalulwa, kayi twelela kubambileti bakonke Milawo ya Mose.” ");
INSERT INTO sby_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Lino batumwa ne bamakulene bamubungano, balabungana pamo kwambeti babonepo cena pa nkaniyi. ");
INSERT INTO sby_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Mpobalambishana pankaniyi kwacindi citali, Petulo walemana ne kutatika kwambeti, “Mucinshi cena mobanse bame kwambeti, Lesa walansala kaindi pakati penu kwambeti njenga kuya kukambauka Mulumbe Waina, kubantu bamishobo naimbi kwambeti banyumfwe ne kushoma. ");
INSERT INTO sby_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Lesa uyo ukute kwinshiba cena myoyo ya bantu, walalesha kwambeti bantu ba mishobo naimbi labatambulu pakubapa Mushimu Uswepa, mbuli ncalatupa afwe. ");
INSERT INTO sby_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Lesa uliya kupusanyapo pakati pabo ne njafwe, pakwinga lushomo lwalaswepesha myoyo yabo. ");
INSERT INTO sby_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Nipacebo cini ncemulamwelekeshelenga Lesa, pakubabika lijoko panshingo beshikwiya, ilyo bamashali betu bakulukulu, nambi afwe tobene ndyetwalalilwa kulimanta? ");
INSERT INTO sby_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Nkacelela kubeco sobwe, twashoma kwambeti cilatupulushunga twense pamo ne ndibo ni Luse lwa Mwami Yesu.” ");
INSERT INTO sby_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Bonse mu mubunganowo balamwena tonto, kabanyumfwa Banabasi ne Paulo ncebalikwamba pabingashilo ne bishikukankamanisha mbyalikwinsa Lesa pakati pabantu bakunsa, kupitila mulyendibo. ");
INSERT INTO sby_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Mpobalapwisha kwamba, Jemusi walambeti, “Mobanse bame, kamunyumfwani. ");
INSERT INTO sby_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Shimoni latwambili cena mbuli Lesa pakutatika, ncalanuka bantu bamishobo naimbi, kupatulapo nabambi kuba bantu bakendi mwine. ");
INSERT INTO sby_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Awa maswi alasuminishananga ne maswi abashinshimi bakulukulu, mbuli ncalembwa mu Mabala a Lesa kwambeti, ");
INSERT INTO sby_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“Ibi byakapwa ninkabwele, kayi ninkebake ng'anda yalawa ya Dafeti. Byapwaika ninkabibake ne kubibambulula cena. ");
INSERT INTO sby_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","‘Ninkenseco kwambeti bantu nabambi bapacishi capanshi naboyo balangaule Mwami Lesa, uku ekwambeti bantu bamishobo yonse mbondalasala kwambeti babe bakame. ");
INSERT INTO sby_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ici encalambanga Mwami Lesa uyo walayubulula ibi kufuma kumasuba akunyuma.” ");
INSERT INTO sby_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jemusi walapitilisha kwambeti, “Kwelana ne kuyeya kwakame, afwe katutabatwika mitolo bantu bakunsa balasandukilinga kuli Lesa. ");
INSERT INTO sby_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Caina tubalembele kalata kwambeti kabatalyanga bintu byasafwana, byabengwa milumbo ku tulesa twakubumba. Balo kabatensanga bufule, kabatalyanga nyama yalifwila, kayi kabatalyanga milopa. ");
INSERT INTO sby_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Pakwinga Milawo ya Mose, yalatatika kubelengwa ne beshikwiyisha mu manda akupaililamo a Bayuda mu munshi uliwonse, pa busuba buli bonse bwa Sabata kufumina kubyaka byakunyuma.” ");
INSERT INTO sby_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Popelapo batumwa ne bamakulene, pamo ne mubungano wonse, balasuminishana kwambeti basalepo bantu beti batumwe pamo ne Paulo ne Banabasi kuya ku Antiyokeya. Balasalapo Yudasi, walikukwiweti Basabasi, ne Sailasi, batuloba babili aba balikukute bulemu pakati pabashoma. ");
INSERT INTO sby_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Kalata njebalabapa yalikwambeti. “Mobanse, afwe batumwa pamo ne bamakulene bamubungano, tulamupanga mitende amwe mobanse baku Antiyokeya, baku Siliya, ne njamwe baku Kilikiya omwashoma muli Mwami Yesu, amwe bantu bakunsa. ");
INSERT INTO sby_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tulanyumfu kwambeti bantu nabambi bamulikoto lyetu bafumina kuno, besa uko kwisa kumupensha ne kumufulunganya bongo ne ciyisho cabo. Abo ntafwe twabatuma sobwe. ");
INSERT INTO sby_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Lino mpotwabungana twense, twasuminishana kusalapo bantu ne kubatuma uko kuli njamwe. Nibakese pamo ne Paulo ne Banabasi bantu mbotusuni. ");
INSERT INTO sby_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Abo balabenga buyumi bwabo kusebensela Mwami Yesu Klistu. ");
INSERT INTO sby_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ecebo cakendi tulatumu Yudasi ne Sailasi, kwambeti bese bamwambile ne mulomo mbyotulalembe mukalata. ");
INSERT INTO sby_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Kuyeya kwetu kulelana ndendende ne Mushimu Uswepa, kwambeti katutamutwika mitolo naimbi yalema sobwe, nsombi milawo ilayandikinga iyi; ");
INSERT INTO sby_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Kamutalyanga nyama njebalatwalilinga milumbo tulesa twakubumba, kamutalyanga milopa, nambi nyama yalifwila, kayi kamutensanga bufule. Na muyamuke ku bintu ibi nimwinse cena. Kamushalani cena.” ");
INSERT INTO sby_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Basa mbobalatuma balaya ku Antiyokeya uko nkobalabunganya mubungano wonse ne kubapa kalata isa. ");
INSERT INTO sby_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Mpobalaibelenga kalata isa balakondwa, pakwinga mwalikuba maswi alabayuminisha. ");
INSERT INTO sby_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yudasi ne Sailasi balikuba bashinshimi, balabayuminisha banse, balamba nabo kwacindi citali ne kubekalika myoyo panshi. ");
INSERT INTO sby_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Mpobalekalako nsondo shing'ana, beshikwiya baku Antiyokeya balalayana ne kwambeti, bende mulumuno pa kubwelela kuli balabatuma. ");
INSERT INTO sby_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Nomba nendi Sailasi walashalila. ");
INSERT INTO sby_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulo ne Banabasi balekala ku Antiyokeya, kabeyisha ne kukambauka maswi a Mwami ne banabo bangi. ");
INSERT INTO sby_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Mpopalapita cindi, Paulo walambila Banabasi kwambeti, “Katubwelela twenga tubone bantu mbotwakambukila maswi a mwami Yesu mu minshi yonse na balekalangeconi.” ");
INSERT INTO sby_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabasi walikuyandeti bamantilile pamo Yohane Maliko. ");
INSERT INTO sby_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Nomba Paulo nkalikuyandeti benga pamo ne Yohane, pakwinga mpobalikuba ku Pamfuliya walabwela combenyuma, ne kubashiya ncito kaitana ipwa. ");
INSERT INTO sby_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Popelapo balatotekeshana caipa cakwinseti balapansana. Banabasi ne Maliko balatanta bwato ne kuya ku Saipulasi. ");
INSERT INTO sby_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Nendi Paulo walasala Sailasi ne kuya pamo, banse mpobalabapailila kwambeti Lesa abape colwe, balanyamuka. ");
INSERT INTO sby_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Naboyo balapitila ku Siliya neku Kilikiya kabaya kuyuminisha bantu mu mibungano. ");
INSERT INTO sby_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulo mpwalashika ku Debe, walaya ne ku Lusitala, uko kwalikuba shikwiya naumbi, lina lyakendi Timoti. Banyina balikuba Bayuda bashoma Lesa, baishi balikuba bagiliki. ");
INSERT INTO sby_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Banse baku Lusitala ne baku Ikoniya balikumulumba Timoti. ");
INSERT INTO sby_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Neco Paulo walikuyanda kumumanta kwambeti bendenga pamo. Nomba Bayuda bonse balikwikala uko balikwinshibeti baishi Timoti ni Bagiliki, Paulo walamupalula Timoti. ");
INSERT INTO sby_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Mpobalikuya kupita mu minshi balikuya kubenshibisha bashoma kwambeti, bakonkele milawo yalabikwa ne batumwa, pamo ne bamakulene ba mubungano wa mu Yelusalemu. ");
INSERT INTO sby_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Neco mibungano ya bashoma yalaba ne lushomo lwayuma, busuba ne busuba bantu balatatika kufulilako. ");
INSERT INTO sby_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paulo ne banendi balapitilila cimpansha ca Fuligiya ne Galatiya, pakwinga Mushimu Uswepa walabakanisha kukambauka maswi a Lesa mucimpansha ca Asiya. ");
INSERT INTO sby_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Mpobalashika kunyinsa yacishi ca Misiya, balayanda kwingila mucimpansha ca Bituniya, nsombi Mushimu wa Yesu walabakanisha. ");
INSERT INTO sby_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Neco balapitilila Misiya ne kuya kushika ku Tulowa. ");
INSERT INTO sby_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Cindi ca mashiku Paulo walabona cimbonimboni camuntu waku Makedoniya, kali wemana ne kusengeti, “Kamutampukilani ku Makedoniya kuno, mwise mutunyamfwe.” ");
INSERT INTO sby_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pacindi copeleco Paulo mpwalabona muntu mucimbonimboni, twalalibambila bulwendo bwakuya ku Makedoniya, pakwinga twalenshibeti Lesa layandeti twenga akukambauka Mulumbe Waina ku bantu baku Makedoniya. ");
INSERT INTO sby_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Kufuma ku Tulowa twalenda mubwato kululama ku nsumbu ya Samotilase, mpobwalaca mumene twalapitilila mpaka twalashika ku Niyapoli. ");
INSERT INTO sby_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kufuma ku Niyapoli, twalaya ku Filipi, munshi unene wa mucibela ca Makedoniya, walikwendeleshewa ne mfulumende ya Ciloma. Twalekala masuba angi mu munshi uwu. ");
INSERT INTO sby_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Pabusuba bwa Sabata twalapulilako kunsa kwamunshi ne kuya ku mulonga uko nkotwali kuyeyeti kuli musena mpobakute kupailila Bayuda. Twalekala panshi katubandika ne batukashi balikuba babungana kopeloko. ");
INSERT INTO sby_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Pakati pabo palikuba mutukashi naumbi, lina lyakendi Lidiya. Kucomwabo niku Tiyatila, ncito yakendi yalikuba yakulisha bikwisa byafubeluka. Walikuba mutukashi wali kupaila Lesa, neco Lesa walamucalula moyo wakendi kwambeti anyumfwishishe ne kushoma ncalikwamba Paulo. ");
INSERT INTO sby_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Lidiya ne bamung'anda yakendi mpobalabatishiwa, walatusengeti, “Mbuli ncemulabono kwambeti nkute lushomo muli Lesa, katuyani kung'anda kwakame muye mwikale nenjame,” Walatukakatisha neco twalaya. ");
INSERT INTO sby_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Cindi nacimbi mpotwalaya kumusena nkobalikupailila, twalakumanyako mutukashi musebenshi walikuba wekatwa ne mushimu waipa wakulaluka. Kufumina muncito yakendi ya kulaluka, baleli bakendi balikucanamo mali angi. ");
INSERT INTO sby_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Uyu mutukashi walikukonkela Paulo pamo ne njafwe, kabilikisheti, “Bantu aba ni basebenshi ba Lesa Mukulene Wapita Byonse! Balamukambaukilinga nshila yalupulusho.” ");
INSERT INTO sby_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Uyu mutukashi walikwinseco kwa masuba angi. Neco Paulo calamucima, walacebuka ne kuwambila mushimu waipa, “Mulina lya Yesu Klistu, ndakwambilinga omushimu waipa, fuma mu muntuyu.” Pacindi copeleco mushimu waipa walapulamo. ");
INSERT INTO sby_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Baleli bamutukashuyu, mpobalabona kwambeti nteti abacaninenga mali, balekata Paulo ne Sailasi, ne kubakwekweshela kumusena wa makwebo, kubomboloshi. ");
INSERT INTO sby_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Mpobalashika nabo kubeshi kombolosha, balambeti, “Aba bantu ni Bayuda, balapenshe bantu mu munshi mwetu muno. ");
INSERT INTO sby_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Baleyishinga miyambo byabula kusuminishiwa, kayi nkatwelela kwitambula nambi kwikonkela afwe Baloma.” ");
INSERT INTO sby_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Likoto lyalikubapo lyalatatika kuma Paulo ne Sailasi, beshikombolosha milandu nabo ebalapesheti bantu batwamune byakufwala bya Paulo ne Sailasi ne kubambileti, babakwapule bikoti. ");
INSERT INTO sby_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Mpobalabakwapula bikoti tunkanda twingi, balabawala mujele ne kwambila mulonda wajele kwambeti abalame cena. ");
INSERT INTO sby_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Neco pacebo camaswi awa, mulonda wajele walabacalila mucipinda camukati mujele, ne kubapinka myendo yabo pakati pa minkulu ibili. ");
INSERT INTO sby_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pakati pa mashiku Paulo ne Sailasi balikupaila, ne kwimbila nyimbo shakutembaula Lesa, bakaili banabo balikunyumfwako. ");
INSERT INTO sby_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Mwakutengashila kwalaba mukunkumo wangofu, cakwinseti lulindi lwa ng'anda ya jele yonse lwalatenkana, bisasa byonse byalashonkauka, ncetani nshebalikuba basunga kaili uliyense shalalaka panshi mbwee. ");
INSERT INTO sby_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mulonda wajele usa mpwalapashamuka, ne kubona bisasa bya jele byonse byashonkauka, walayeyeti bakaili bonse balafwambamo. Walapulisha cibeshi kwambeti alishine. ");
INSERT INTO sby_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Paulo walabilikisheti, “Kotalishina! Twense motuli muno!” ");
INSERT INTO sby_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Mulonda usa walambila naumbi kwambeti alete lampi, walafwambila mukati katutuma njenjenje, ne kuya kuliwala pamyendo ya Paulo ne Sailasi. ");
INSERT INTO sby_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Walabapulisha kunsa ne kubepusheti, “Nkambo! Nicani ncetinyinse kwambeti mpuluke?” ");
INSERT INTO sby_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Balo balamukumbuleti, “Koshoma muli Mwami Yesu, obe ne ba mung'anda yakobe nimukapuluke.” ");
INSERT INTO sby_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Balamukambaukila maswi a Mwami, pamo ne ba mung'anda yakendi. ");
INSERT INTO sby_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Nekukabeti calikuba cindi camashiku, walabamanta ne kuya kubasuka bilonda. Popelapo mulonda usa ne ba mung'anda yakendi balabatishiwa. ");
INSERT INTO sby_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Panyuma pakendi, walaya nabo kung'anda yakendi, kuya kubapa cakulya. Mulonda uyu ne bonse ba mung'anda yakendi balakondwa cebo ca kushoma Lesa. ");
INSERT INTO sby_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Mpobwalaca, beshikombolosha balatuma bashilikali kuya kumwambila usa mulonda wajele kwambeti, “Basungulule abo bantu benga.” ");
INSERT INTO sby_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Usa mulonda wajele walamwambila Paulo kwambeti, “Beshikombolosha balatumu maswi akwambeti tumusungulule. Neco, kamupulani, kamuyani mulumuno.” ");
INSERT INTO sby_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Paulo walabambila bashilikali abo, kwambeti “Batukwapula bikoti bantu bangi kabebelela, kwakubula kutombolosha nanshi, kakuli afwe tobene Loma, kayi batuwala mujele. Inga lino balayandanga kutupulisheconi kampunampuna, nkacelela kubeco sobwe! Kamuyani mubambile balamutumu bese batupulishe bene.” ");
INSERT INTO sby_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Basa bashilikali balaya kubambila beshikombolosha maswi awa. Mpobalanyumfweti Paulo ne Sailasi ni bene Loma, balatina. ");
INSERT INTO sby_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Neco beshikombolosha balesa kulilekelela kuli Paulo ne Sailasi. Panyuma pakendi balabapulisha mujele, ne kubasengeti bafumemo mu munshi uwo. ");
INSERT INTO sby_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paulo ne Sailasi mpobalapula mujele, balabwelela ku ng'anda kwa Lidiya, nkobalakabonana ne banabo. Panyuma pakubayuminisha, balafuma mu mushi. ");
INSERT INTO sby_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paulo ne Sailasi pakuya balapitila mu minshi ya Amfipoli ne Apoloniya, balashika ku Tesalonika uko kwalikuba ng'anda yakupaililamo ya Bayuda. ");
INSERT INTO sby_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Kwelana ne cinga ncalikukute Paulo, walengila mung'anda yakupaililamo ne kubandika nabo makani amu Mabala a Lesa kwa nsondo shitatu. ");
INSERT INTO sby_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Walabasansulwila cena makani amu Mabala a Lesa, ne kubalesheti Mupulushi Walaiwa usa welela kupenga ne kupundushiwa kubafu. Paulo walambeti, “Yesuyu ngondamukambaukilinga e Mupulushi Wasalwa ne Lesa.” ");
INSERT INTO sby_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Nabambi balashoma ne kukonkela Paulo ne Sailasi. Naboyo Bagiliki bangi balikukambilila Lesa, pamo ne batukashi bangi bayampuwo naboyo balashoma. ");
INSERT INTO sby_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Nomba Bayuda nabambi balanyumfwa minyono, neco balayungaula bantu bamalofwa balikwendanowa munshila, bantu abo pamo ne Bayuda ebalatatika mipyopyongano mu munshi umo. Balabundumukila ne kuya kutoba ng'anda ya Yasoni, kuya kulangaula Paulo ne Sailasi, kwambeti babapulishe mung'andomo ne kubaleta ku bantu. ");
INSERT INTO sby_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Mpobalanyala pakubula kucanako Paulo ne Sailasi, balekata Yasoni pamo ne bashoma nabambi ne ku bakwelanya kubatwala kubendeleshi bamu munshi, uko nkobalabilikisheti, “Basa bantu baletenga mipyopyongano kulikonse, lelo balesa kumunshi kwetu, ");
INSERT INTO sby_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yasoni labatambulu. Mbyobalenshinga bonse nkabyekatana ne milawo ya mwami waku Loma sobwe, balambangeti kuli Mwami naumbi lina lyakendi Yesu.” ");
INSERT INTO sby_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Maswi awa alakalalisha likoto lya bantu pamo ne bendeleshi bamu munshi. ");
INSERT INTO sby_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Nomba Yasoni ne banendi basa mpobalalipila mali angi a mulanduwo, bendeleshi ba munshi balabasungulula. ");
INSERT INTO sby_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Mpokwalashipuluka mansailo, banse balatuma Paulo ne Sailasi ku Beleya. Mpobalashikowa balengila mu ng'anda yakupaililamo ya Bayuda. ");
INSERT INTO sby_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Bayuda balikuba ku Beleya balikukute myoyo ishikuyanda kunyumfwishisha, kupita bantu baku Tesalonika. Pakwinga balo balatambula maswi a Lesa ne moyo umo, kayi busuba ne busuba balikubwelulukamo mu Mabala a Lesa kwambeti babone na nicakubinga ncambanga Paulo ne Sailasi. ");
INSERT INTO sby_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Neco Bayuda bangi balashoma. Kayi ne batukashi ba Cigiliki ne batuloba bangi bayampuwo nabo balashoma. ");
INSERT INTO sby_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Nomba mpobalanyumfwa Bayuda baku Tesalonika basa, kwambeti Paulo lakambaukunga maswi a Lesa ku Beleya, nakoyo balayako ne kutatika kuyungaula bantu kwambeti batatike mipyopyongano. ");
INSERT INTO sby_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Pacindi copeleco banse balatuma bantu nabambi kwambeti bashindikile Paulo ku lwenje. Nomba Sailasi ne Timoti balashalila ku Beleya. ");
INSERT INTO sby_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Bantu basa balamushindikila Paulo balashika nendi ku Atene. Panyuma pakendi balabwelela ku Beleya, ne kuya kwambila Sailasi ne Timoti kwambeti Paulo layandangeti bamukonke bwangu bwangu. ");
INSERT INTO sby_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Cindi Paulo ncalikupembelela Sailasi ne Timoti ku Atene, walapenga mumoyo pakuboneti munshi wonse walikuba wesula ne tumbwanga ntobali kukambilila. ");
INSERT INTO sby_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Lino Paulo walabandika ne Bayuda mung'anda ya kupaililamo pamo ne bantu bamishobo naimbi balikukambilila Lesa. Kayi walabandika ne bantu mbwalikukumanya pamusena wa makwebo busuba ne busuba. ");
INSERT INTO sby_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Bantu ba mano nabambi bamulikoto lyalikukwiweti Epikuleya, neba Sitoyiki, balatotekeshana ne Paulo, nabambi balikwambeti, “Inga mbutuma iyi yapamulomo cisa ilelekeshenga kwamba cani?” Nabambi kayi balikwambeti, “Uyu lanyumfwikingeti lakambaukunga sha balesa bensu mbotuteshi kuno.” Balikwambeco pakwinga Paulo, walikukambauka Mulumbe Waina ulambanga sha Yesu ne shakupunduka kubafu. ");
INSERT INTO sby_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Neco balamutwala Paulo ku nkuta yalikukwiweti Aleopagi ne kumwambileti, “Mutusansulwile afwe cishikunyumfwika sha ciyisho calinolino ici ncomuleyishinga. ");
INSERT INTO sby_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Pakwinga bintu nabimbi mbyomulatwiyishinga, nkatuna tubinyumfwapo, neco tulayandanga kubinshiba cena.” ");
INSERT INTO sby_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Bantu bonse balikwikala mu Atene, pamo ne bensu, balikukute cinga cakutaya cindi cabo, ne kuyandowa kutonda tonda ne kunyumfwa bintu byalinolino. ");
INSERT INTO sby_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paulo walemana pakati pa nkuta ya Aleopagi ne kwambeti, “Amwe bantu bene Atene, ndabononga kwambeti mwashimpa cena mu kukambilila kwenu. ");
INSERT INTO sby_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Pakwinga pacindi ncondendananga mu munshi wenu uwu, ndabona misena ingi njomukute kupaililamo, pa nteme napambi mpomukute kupaililapo palembwa cisa, ‘Kuli Lesa wabula kwinshibikwa. Epeloyo ngomukute kukambilila kamutamwinshi, endiye ngondamwambilinga pacino cindi. ");
INSERT INTO sby_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Uyo endiye Lesa walalenga cishi ne bintu byonse bilimo, e Mwami lendeleshenga kwilu ne cishi capanshi. Neco nkakute kwikala mu manda ebakwa ne bantu sobwe. ");
INSERT INTO sby_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Cakubinga paliya bantu ncobelela kumusebensela ne makasa abo, pakwinga paliya ncabulilwa. Endiye Lesa ukute kutupa buyumi ne muya ngotukute kuyoya, pamo ne bintu byonse. ");
INSERT INTO sby_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","cakutanguna Lesa walalenga muntu umo, kufuma mu muntu umo ngwalalenga, emwalafuma mishobo yonse ya bantu, kwambeti bekalenga kulikonse pacishi capacishi. Walababambilalimo cindi ca buyumu bwabo kayi ne nyinsa ya misena yabo. ");
INSERT INTO sby_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Walenseco kwambeti bantu bakamulangaule, mpani ngabamwinshiba mukumulangaula. Nsombi Lesa nkalipo kutali ne njafwe twense sobwe.” ");
INSERT INTO sby_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Mbuli muntu naumbi ncalambeti, endiye ukute kutupa ngofu sha kuba ne buyumi, shakwenda kayi kuba mbuli ncetubele. Mbuli bakalaka maimbo benu ncobalalembeti, ne njafwe tobana bendi. ");
INSERT INTO sby_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Pakwinga tobana bendi Lesa, nkatwelela kuyeyeti bulesa bwakendi bwakoshana ne kambwanga kagolide nambi ka silifa nambi ka libwe lyapangwa cena ne mano a muntu. ");
INSERT INTO sby_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Kaindi Lesa walikubalekelela bantu bintu byaipa mbyobalikwinsa, pakwinga nkabalikumwinshiba, nsombi lino labambilinga bantu kulikonse kwambeti basanduke. ");
INSERT INTO sby_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Lesa wasalapo busuba bumo, bwa kwisakombolosha bantu pacishi capanshi mubululami, kupitila mu muntu uyo ngwalasala. Ici walacibonesha ku bantu bonse, pakumupundusha kubafu muntuyo. ");
INSERT INTO sby_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Nabambi bantu mpobalanyumfwa makani akupunduka kubafu ngalikwamba Paulo, balamuseka. Nsombi nabambi balambeti, tulayandanga kwambeti ukese busuba nabumbi kwisa kutwambila makani awa. ");
INSERT INTO sby_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Popelapo Paulo walafumako ku nkuta. ");
INSERT INTO sby_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nabambi bantu balakonkela Paulo balashoma. Pakati pa bantu abo palikuba Diyonisiya, wa mulikoto lyankuta ya Aleopagi, pamo ne mutukashi lina lyakendi Damalisi, ne nabambi. ");
INSERT INTO sby_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Panyuma pa bintu ibi, Paulo walafuma ku Atene nekuya ku Kolinto. ");
INSERT INTO sby_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Uko nkwalacana Muyuda naumbi, lina lyakendi Akula, uyo walasemenwa ku Pontasi. Walikuba mwensu walafumina ku Italiya, walesa pamo ne Pulisila mukashendi, cebo ca mwami waku Loma Kilaudiyo, uyo walabika mulawo wakwambeti Bayuda bonse bafume ku Loma. Lino Paulo walaya kubabona. ");
INSERT INTO sby_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pakubona kwambeti aba bantu balikukute incito mbuli njalikukute Paulo, yakutunga matente, walekala ne kusebensela nabo pamo. ");
INSERT INTO sby_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Paulo walikwamba ne bantu ku ng'anda yakupaililamo ya Bayuda, pa busuba bwa Sabata bulibonse, kelekesha kusandula Bayuda ne Bagiliki kwambeti bashome Mulumbe Waina. ");
INSERT INTO sby_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sailasi ne Timoti mpobalashika kufuma ku Makedoniya, Paulo walalibengowa kuncito ya kukambauka, ne kwinshila bukamboni ku Bayuda kwambeti Yesu e Mupulushi Walaiwa usa. ");
INSERT INTO sby_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Nomba pacebo cakwambeti balamutoteka, ne kumusampula, Paulo walapansana nabo ne kupampamuna lusuko ku byakufwala byakendi, ne kubambileti, “Mulalishinishi mobene! Ame ndemuyawu. Kufuma lelo ndenga kukambaukila bantu bamishobo naimbi.” ");
INSERT INTO sby_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Popelapo walabashiya ne kuya ku ng'anda ya muntu naumbi, lina lyakendi, Tito Yusito, uyu muntu wali kuyandishisha kukambilila Lesa, ng'anda yakendi yalikuba yabambana ne ng'anda ya kupaililamo. ");
INSERT INTO sby_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Mutangunishi wa ng'anda ya kupaililamo, Klisipo pamo ne ba mung'anda yakendi balashoma muli Mwami Yesu. Bantu bangi baku Kolinto balanyumfwa makani alikwamba Paulo, balashoma ne kubatishiwa. ");
INSERT INTO sby_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Mwami Yesu walabonekela kuli Paulo mucimbonimboni busuba nabumbi cindi ca mashiku, ne kumwambileti, “Kotatina, pitilisha kukambauka, kayi kotacileka, ");
INSERT INTO sby_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","pakwinga ame ndi pamo ne njobe. Paliya muntu eti akulwane ne kukulinga, pakwinga muno mu munshi muli bantu bakame bangi.” ");
INSERT INTO sby_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Paulo walekala kopeloko kabeyisha bantu maswi a Lesa kwacaka cimo ne myenshi isanu ne umo. ");
INSERT INTO sby_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Pacindi Galiyo ncalikuba Mwendeleshi wa cimpansha ca Akaya, Bayuda balamwikata Paulo, ne kumutwala ku nkuta. ");
INSERT INTO sby_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Balambeti, “Muntuyu layungaulunga bantu kwambeti bakambililenga Lesa mu nshila yapusana ne Milawo yetu.” ");
INSERT INTO sby_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Nomba Paulo katanambapo ciliconse, Galiyo walabambila Bayuda eti, “Ne mulambeti muntuyu lataluku mulawo, nambi kwambeti lepishili munendi, nshinga ne ndawombolosho mulandu wenu amwe Bayuda. ");
INSERT INTO sby_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Nomba ndacaneti ninkani ilambangowa shamaswi ne maina, kayi ne milawo yenu, mwelela kulibonena mobene. Ame ndamukanini pimbi!” ");
INSERT INTO sby_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Mpwalamba maswi awa, walabatandanyapo pa nkuta. ");
INSERT INTO sby_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Kufumapo, bantu bonse balekata Sositene, mutangunishi wa ng'anda yakupaililamo ya Bayuda, ne kumumina pantangu pa bomboloshi. Galiyo kabonako, nsombi paliya ncalensapo. ");
INSERT INTO sby_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo walalayana ne banse ba ku Kolinto, panyuma pa kwikalako masuba angi. Walatanta bwato pamo ne Akula ne Pulisila mukashendi, ne kuya ku Siliya. Paulo kacili ku Kenkeleya katanatanta bwato, walacesa mishishi kubonesheti lakwanilishi lumbilo lwakendi ndwalensa kuli Lesa. ");
INSERT INTO sby_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Mpobalashika ku Efenso, Akula ne Pulisila mukashendi balashala. Paulo kacili kopeloko walengila mu ng'anda yakupaililamo ya Bayuda ne kubandika nabo. ");
INSERT INTO sby_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Balamusenga kwambeti ekaleko nabo kwa masuba angiko, nsombi nendi walakana. ");
INSERT INTO sby_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Walabalaya ne kubambileti, “Lesa akampa cindi ninkese.” Mpwalambeco walatanta bwato ne kufumako ku Efenso. ");
INSERT INTO sby_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Paulo mpwalashika ku Kaisaleya, walaya kayi neku Yelusalemu kuya kupa mitende mubungano. Kufuma uko walaya ku Antiyokeya. ");
INSERT INTO sby_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Panyuma pakwikalako kacindi, walaya kupitana mubibela bingi bya bimpansha bya Galatiya ne Fuligiya, kaya kuyuminisha beshikwiya bonse. ");
INSERT INTO sby_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ku Efenso kwalesa Muyuda walasemenwa ku Alekisandiliya, lina lyakendi, Apolo. Walikuba muntu muya mukutonda, kayi walikwainshiba cena Mabala a Lesa. ");
INSERT INTO sby_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Uyu muntu waleyishiwa nshila ya Mwami, kayi walikuba muntu wakangwabu, walikwamba ne kwiyisha mwabuya makani a Mwami Yesu. Nsombi walikwishibowa sha lubatisho lwa Yohane. ");
INSERT INTO sby_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Walikwamba kwakubula buyowa mu ng'anda yakupaililamo ya Bayuda. Pulisila ne Akula mpobalamunyumfwa balamumanta ne kuya kumusansulwila cena mwabuya nshila ya Lesa. ");
INSERT INTO sby_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolo mpwalikuyanda kuya ku Akaya, banse balamuyuminisha ne kulembela kalata ku banse ba ku Akaya kwambeti bamutambule cena. Mpwalashika walabanyamfwilisha bonse balikuba bashoma kupitila mu luse lwa Lesa. ");
INSERT INTO sby_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Pakwinga Apolo walikubatoteka mwangofu ne kubakoma Bayuda pamenso abantu, kubashinina kupitila mu Mabala a Lesa, kwambeti Yesu endiye Mupulushi Walaiwa usa. ");
INSERT INTO sby_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolo mpwalikuba ku Kolinto, ecindi nendi Paulo mpwali kapita mu bimpansha bingi byacishi, mpaka walakashika ku Efenso, nkwalacana beshikwiya nabambi. ");
INSERT INTO sby_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Walabepusheti, “Mpomwalashoma muli Mwami Yesu, sena mwalatambula Mushimu Uswepa?” Balo balakumbuleti, “Afwe nkatuna tunyumfwapo eti kuli Mushimu Uswepa sobwe.” ");
INSERT INTO sby_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Kayi Paulo walabepusheti, “Inga nilubatisho lwamushobo cini ndomwalatambula?” Balo balakumbuleti, “Lubatisho lwa Yohane.” ");
INSERT INTO sby_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paulo walambeti, “Yohane walikubatisha bantu balikushiya bwipishi bwabo, kayi walikubambila bantu kwambeti bashome uyo walikwisa panyuma pakendi, uyo e Yesu.” ");
INSERT INTO sby_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Beshikwiya basa mpobalanyumfweco, balabatishiwa mulina lya Mwami Yesu. ");
INSERT INTO sby_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Paulo mpwalabika makasa palyendibo, Mushimu Uswepa walesa, balatatika kwamba milaka yabula kwishibikwa uko, balatatika kushinshima. ");
INSERT INTO sby_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Bantu abo balikuba likumi ne babili. ");
INSERT INTO sby_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Kwa myenshi itatu, Paulo walikaya kung'anda yakupailiamo ya Bayuda. Walikubandika ne bantu sha makani a Bwami bwa Lesa, kwakubula buyowa kwambeti bashome. ");
INSERT INTO sby_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Nomba nabambi balayumisha myoyo yabo gwa! Nkabalayanda kushoma mbyalikubambila sobwe, balatatika kucobola nshila ya Mwami Yesu pamenso abantu bangi. Neco Paulo walabashiya ne kumantapo abo bashoma. Busuba ne busuba Paulo walikubandika ne bantu mung'anda yakwiyishilamo ya Tilano. ");
INSERT INTO sby_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Kubandika ne bantu kulico kwalamumantila byaka bibili, cakwinseti bantu bonse bekala mu Asiya, Bayuda ne Bagiliki balanyumfwa maswi a Mwami Yesu. ");
INSERT INTO sby_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Lesa walikwinsa bishikukankamanisha binene kupitila muli Paulo. ");
INSERT INTO sby_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Bitambala ne bikwisa mbyalikusebensesha Paulo, bantu babitwala ku balwashi babo, balwashi balikusengulwa kayi ne mishimu yaipa yalikupula mu bantu. ");
INSERT INTO sby_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Nabambi Bayuda balikwendenda kabaya kupulisha mishimu yaipa, balelekesha kusebensesha lina lya Mwami Yesu bapulishanga mishimu yaipa. Balikwambeti, “Mulina lya Yesu ngwalakambaukunga Paulo, ndamwambilishinga pulani!” ");
INSERT INTO sby_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Abo balikwinseco ni bana basanu ne babili, ba Sikeva, Mukulene wa Beshimilumbo Baciyuda. ");
INSERT INTO sby_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Nomba mushimu waipa walakumbuleti, “Yesu ndimwinshi, nendi Paulo ndimwishi, inga amwe njamwe bani?” ");
INSERT INTO sby_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Popelapo muntu usa walikukute mishimu yaipa, walabaulukila ne kubafwankanya bonse. Walabakoma ne kubakwamauna byakufwala byabo, cakwinseti balafwambamo mung'andomo matakosha kabali balingwa. ");
INSERT INTO sby_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ici calanyumfwika kubantu bonse, Bayuda ne Bagiliki balikwikala ku Efeso, bonse balesulilwa nebuyowa. Neco lina ya Yesu lyalalumbaishiwa. ");
INSERT INTO sby_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Bantu bangi balikushoma muli Yesu, balikwisa kulyambilila bene pamenso abantu bwipishi mbobalikwinsa. ");
INSERT INTO sby_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Nabo bantu bangi balikwinsa sha bung'anga, balabunganya mabuku abo, ne kwatenta bantu bangi kabebelela. Mpobalasankanya mulo wa mabuku alatentwa, balacaneti ni makumi asanu a bina bya mali amuwayawaya asilifa. ");
INSERT INTO sby_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Cebo ca ibi bintu byangofu byalikwinshika, bantu bangi balanyumfwa maswi a Mwami Yesu kayi alamwaikila ne kukula. ");
INSERT INTO sby_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Mpobyalenshika bintu ibi, Paulo walayeya kuya ku Yelusalemu, kupitila ku Makedoniya ne ku Akaya. Walambeti, “Ndakafuma ku Yelusalemu, ndelela kuya ku Loma.” ");
INSERT INTO sby_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Neco walatuma Timoti ne Elasito ku Makedoniya, batuloba babili balikumunyamfwilisha. Nendi Paulo walashalila kwa kacindi kang'ana mu cimpansha ca Asiya. ");
INSERT INTO sby_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Epacindici mpokwalatatika kuba minyungwe inene ku Efenso, cebo ca Nshila ya Mwami Yesu. ");
INSERT INTO sby_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Kwalikuba muntu naumbi walikukute ncito yakupanga tuntu twa silifa lina lyakendi Demetiliyo. Walikupanga tukoshano twasilifa twa ng'anda yakupaililamo Atemi lesa wabo mutukashi, kayi basebenshi bakendi balikucanamo mali angi muncito iyi. ");
INSERT INTO sby_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Uyu Demetiliyo walabunganya basebenshi bakendi, ne bantu nabambi balikukute ncito mbuli ya kendi, ne kubambileti, “Mobaname, mucinshi cena kwambeti, bubile bwetu bulafumunga muncito iyi. ");
INSERT INTO sby_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Mulabononga ne kulinyumfwila mobene bintu mbyalenshinga Paulo uyu. Lambangeti balesa bakubumba ntebo balesa sobwe. Neco, bantu bangi balashomo mbyalanyengelelenga bantu muno mu Efeso, ne mucimpansha conse ca Asiya. ");
INSERT INTO sby_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ndayakamwa pakwinga bantu nibatatike kwamba byaipa pancito yetu iyi. Nteti bambengowa pancito yetu yonka sobwe, nsombi ng'anda ya lesa wetu Atemi nayo nibayisule bantu. Neco bulemu bwakendi lesa uyu nibupwe, lesa uyu ngobakute kukambilila bantu mucimpansha Asiya ne cishi conse!” ");
INSERT INTO sby_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Bantu balakalala mpobalanyumfwa awo maswi, ne kutatika kubilikisheti, “Mukulene ni Atemi waku Efenso!” ");
INSERT INTO sby_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Popelapo mu munshi monse mwalaba mipyopyongano. Balekata Gayo ne Alisitako, bantu baku Makedoniya balikwenda ne Paulo. Balabakwekweshela ku lubansa lwamafuka nkobali kusuna kubungana bantu. ");
INSERT INTO sby_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulo mpwalayanda kuya mulikoto lya bantu, beshikwiya balamukanisha. ");
INSERT INTO sby_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Nabo bendeleshi nabambi baku Asiya, balikuba banendi Paulo, balatuma maswi akumusenga kwambeti katayako ku lubansa lwa mafuka kwalikuba kwabungana bantu. ");
INSERT INTO sby_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Balatatika kwambowa cambe ambe, pakwinga balikuba banyongana kayi bangi nkabalikwinshiba ncebalabunganina sobwe. ");
INSERT INTO sby_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Bayuda nabambi balikuba mulikoto balanyakila Alekisanda pantangu ne kwambeti ewelela kusansulula cena makani, neco Alekisanda walabamweneka bantu ne cikasa, neye walambeti, “Ntebo bayuda balepesheti kube mipyopyongano.” ");
INSERT INTO sby_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Lino bantu mpobalenshibeti ni Muyuda, balabilikisha kabamba maswi amo amo kwa maola abili, kabambeti, “Mukulene ni lesa Atemi waku Efenso!” ");
INSERT INTO sby_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Pamapwililisho pakendi, mulembi wa mu munshi walabamwenesha bantu ne kubambileti, “Amwe mobene Efenso baname, nibani batacinshi kwambeti munshi uwu wa Efeso ewasunga ng'anda yakendi lesa Atemi mukulene, ne libwe lyatondwa lyalalaka kufuma kwilu? ");
INSERT INTO sby_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Paliya muntu welela kukana makani awa, neco kamumwenako, kamutengana kwinsa cintu sobwe. ");
INSERT INTO sby_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Mulalete Gayo ne Alisitako kuno, kakuli paliya cintu ncebalebi mung'anda ya lesa wetu, nambi kumucobola. ");
INSERT INTO sby_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Neco, na Demetiliyo pamo ne bantu mbwakute kusebensa nabo, balayandanga kupa mulandu muntu naumbi, bomboloshi ba nkuta nkobali, ingabatwalana kuya kwambila makani awa uko pa masuba ngobakute kombolosha. ");
INSERT INTO sby_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Na pali nacimbi ncemulayandanga, mubungano wa mumunshi wasuminishiwa ne milawo, kubonapo pankani iyo. ");
INSERT INTO sby_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Palibi bilenshiki lelo, bendeleshi baku Loma, babinyumfwa ngabatupa mulandu wakuleta mipyopyongano. Paliya mpotwelela kuyubila mulandu sobwe. Kayi paliya muntu welela kusansulula cena cilalete mipyopyongano iyi.” ");
INSERT INTO sby_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Mpwalapwisha kwambeco, bonse walabambileti bamwaike. ");
INSERT INTO sby_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Mipyopyongano mpoyalapwa, Paulo walabunganya beshikwiya. Mpwalamba maswi akubayuminisha, walabalaya walaya ku Makedoniya. ");
INSERT INTO sby_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Walapitana mubimpansha byonse kaya kuyuminisha beshikwiya, kupitila mukukambauka maswi a Lesa, mpaka walashika ku Gilisi. ");
INSERT INTO sby_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Uko walekalako myenshi itatu. Mpwalikulibambila bulwendo bwa kuya ku Siliya mubwato, walanyumfwa kwambeti, Bayuda balapangananga sha kumushina. Pacebo ico, walayeyeti enga akupitila ku Makedoniya. ");
INSERT INTO sby_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Paulo walaya pamo ne bantu aba; Sopatulo mwanendi Pailasi waku Beleya ne Alisitako ne Sekunda, ba ku Tesalonika ne Gayo waku Debe ne Timoti ne Tukiko kayi ne Tulofimo ba micimpansha ca Asiya. ");
INSERT INTO sby_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Aba balatanguna kushika ku Tulowa, nkobali kutupembelela. ");
INSERT INTO sby_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Mpobwalapita busuba bwakusekelela shinkwa wabula cishikufufumusha, ne njafwe twalanyamuka ne bwato kufuma ku Filipi. Panyuma pa kwenda bulwendo bwa masuba asanu twalashika ku Tulowa, uko nkotwalabacana. Twalekalako masuba asanu ne abili. ");
INSERT INTO sby_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Lino pa busuba butanshi bwa nsondo, mpotwalabungana pamo kulya mulalilo wakwanukilapo Mwami Yesu, Paulo walatatika kwambila bantu mpaka pakati pa mashiku, pakwinga walikuyanda kufumako mumene mene. ");
INSERT INTO sby_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Mwalikuba mimuni ingi mucipinda capelu ca ng'anda njetwalikuba twabunganamo. ");
INSERT INTO sby_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mutuloba naumbi musepela lina lyakendi Yutika, walikuba wekalila pa cipense, walatatika kushinshila. Pakwinga Paulo walapitilisha kwamba cindi citali, muntuyu walona tulo, walawa panshi kufuma pelu palupingwe lwabutatu, balacana wafwa. ");
INSERT INTO sby_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Popelapo Paulo walaseluka panshi, ne kulambalala pamubili wa mutuloba uyu, ne kumufukata. Paulo walabambila bantu balikubapo, “Kamutapenga sobwe, ni muyumi.” ");
INSERT INTO sby_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Kufumapo Paulo walabwelela mucipinda capelu mung'anda. Walalya mulalilo wakwanukilapo Mwami Yesu pamo ne beshikwiya bonse balikubapo. Walabandika nabo cindi citali. Walafumako kumaca lisuba kalili pepi kupula. ");
INSERT INTO sby_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Usa mutuloba balamutwala kung'anda kucomwabo kali muyumi ntaa! Neco bonse balekalika myoyo. ");
INSERT INTO sby_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Popelapo twalatanguna kuya ku Asosi mu bwato. Pakwinga walatwambileti tukakumanine ku Asosi kwambeti nkoti akatantile mu bwato motwalikuba, pakwinga nendi walenda lwa musansa kuya ku Asosi. ");
INSERT INTO sby_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Mpwalatucana ku Asosi, walatanta mu bwato motwalikuba ne kuya pamo ku Mitileni. ");
INSERT INTO sby_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Busuba bwakonkapo twalashika pepi ne Kiyosi. Twalenda mpaka twalashika ku Samo. Busuba bwalakonkapo twalashika ku Mileto. ");
INSERT INTO sby_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pakwinga Paulo walayeya kupita kumbali kwa munshi wa Efenso, kwambeti katataya cindi citali mu cimpansha ca Asiya. Walikuba wengana pakwinga walikuyandeti na kacikonsheka, akabenga mu Yelusalemu kabutana bushika busuba bwa Pentekosite. ");
INSERT INTO sby_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Mpwalikuba pa Mileto, Paulo walatuma muntu ku Efenso kuya kubakuwa bamakulene ba mubungano. ");
INSERT INTO sby_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Mpobalashika walabambileti, “Amwe mucinshi cena ncendalikwikala ne kusebensa pacindi ncendalikuba pamo ne njamwe, kufuma pa busuba mbondalashika mu cimpansha ca Asiya. ");
INSERT INTO sby_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ndalasebensela Mwami Yesu mwakulicepesha, nacimbi cindi ndalikulila misoshi cebo ca masunko ngobalikundetela Bayuda mpobalikupangana sha kushina. ");
INSERT INTO sby_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mucinshi kwambeti paliya cintu nacikaba cimo, calikuyandika kumunyamfwa ncondalamusoleka, nsombi ndalakambauka ne kumwiyisha makani alambanga sha Yesu, pabantu bangi kayi ne kung'anda ne ng'anda.” ");
INSERT INTO sby_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ndalikubacenjesha Bayuda ne bantu bamishobo naimbi, kwambeti belela kusandukila kuli Lesa, ne kushoma Mwami wetu Yesu. ");
INSERT INTO sby_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Cebo cakunyumfwila Mushimu Uswepa, pacino cindi ndenga ku Yelusalemu, nomba nkandicinshi ceti cikenshike kuli njame. ");
INSERT INTO sby_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ncenjinshowa ni cakwambeti, mu minshi yonse Mushimu Uswepa ulancenjeshengeti, mapensho ne kusungwa mujele kulampembelenga. ");
INSERT INTO sby_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Nkandasakamananga sha buyumi bwakame sobwe, ncendayandishishinga ni kupwisha ncito njalampa Mwami Yesu, kukambauka Mulumbe Waina ulambanga sha luse ulo luli cipo ca Lesa. ");
INSERT INTO sby_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Ndalapitana muli njamwe mwense, kanja kukambauka makani a Bwami bwa Lesa, nomba lino ndicinshi kwambeti nteti mukambonepo sobwe. ");
INSERT INTO sby_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Neco ndamwambilishinga busuba bwalelo, kwambeti na nabambi mulikoto lyenu ili bakonongeke ntewo mulandu wakame sobwe. ");
INSERT INTO sby_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Pakwinga paliya cintu naba cimo ncendalamusoleka sobwe. Ndalamwambila byonse mbyalayandanga Lesa. ");
INSERT INTO sby_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Mwelela kulilama cena mobene, ne kulama cena likoto lya bantu abo Mushimu Uswepa ngowalamupeti mubembelenga. Kamwembelanga cena bantu mu mubungano wa Lesa, abo mbwalapulusheti babe bakendi kupitila mu lufu lwa Mwanendi. ");
INSERT INTO sby_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ndicinshi kwambeti ame ndakafumapo pa likoto lyenu, baumpe bakalu nibakese pakati penu, beti bakabule nkumbo ne likoto lya bantu bali mu mubungano. ");
INSERT INTO sby_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Kayi mu likoto lyenu mobene, nimukapunduke bantu beshikwiyisha bya bwepeshi ne kukwelela bangi kulubasu kwabo, kwambeti babakonkele. ");
INSERT INTO sby_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Neco, cetukani! Kamwingashilangeti kwa byaka bitatu ndalikumwiyisha mwense munshi ne mashiku, kandila misoshi. ");
INSERT INTO sby_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Cakupwililisha, ndamubikinga mu makasa a Lesa, ne mu makani alambanga sha luse lwakendi, elela kumwibaka ne kumupa colwe ico Lesa ncabikila bantu bakendi bonse. ");
INSERT INTO sby_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ndiya ku kumbwapo mali, nambi cakufwala camuntu uliyense sobwe. ");
INSERT INTO sby_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mobene mucinshi cena kwambeti ndalikusebensa ne makasa akame, kucana byonse byali kuyandika pabuyumi bwakame ne kunyamfwilishako baname mbondalikuba nabo. ");
INSERT INTO sby_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mubintu byonsebi ndalamubonesha kwambeti, kusebensa ne ngofu mbuli ncendalikusebensa, inga tunyamfwako abo balefuka. Cindi conse kamwanukanga maswi ngalamba Mwami Yesu, akwambeti, “Kupa kukute kuleta colwe, kupita kutambula.” ");
INSERT INTO sby_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Mpwalapwisha kwamba, bantu bonse balikuba pamo ne Paulo, balasuntama ne kupaila kuli Lesa. ");
INSERT INTO sby_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Bonse bali kabalila mwakompolola mpobalamukumbatila Paulo, ne kumushonshonta pakulayana. ");
INSERT INTO sby_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Calabapa kungumana ni maswi ngalambeti nteti bakamubonepo kayi. Kufumapo balamushindikila kwalikuba bwato. ");
INSERT INTO sby_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Mpotwalapwisha kulayana, twalafumako twalenda mu bwato ne kululama ku Kosi. Busuba bwakonkapo twalashika ku Lodi, kufuma uko twalaya ku Patala. ");
INSERT INTO sby_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Mpotwalashika, twalacana bwato bwali kuya ku Foinike, twalatanta ne kuya. ");
INSERT INTO sby_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Lino mpotwalashika pamusena mpotwalikukonsha kubona nsumbu ya Saipulasi, twalabembuluka cakucipiko, mpaka twalashika ku Siliya kucito ca Tulo nkobalalongololamo bintu byalikuba mu bwatomo. ");
INSERT INTO sby_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Kopeloko twalacanako beshikwiya nabambi mbotwalekala nabo masuba asanu ne abili. Abo balamwambila Paulo, kupitila mu Mushimu Uswepa kwambeti kataya ku Yelusalemu. ");
INSERT INTO sby_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Mpwalapwa masuba akwikala nabo, twalafumako ne kupitilisha bulwendo bwetu, beshikwiya bonse pamo ne bamakashabo ne bana babo balatushindikila mpaka kunsa kwa munshi. Twalasuntama ne kupaila pa museya mulombe pepi ne lwenje. ");
INSERT INTO sby_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Mpotwalalayana balo balabwelela kumanda kwabo, afwe twalengila mu bwato. ");
INSERT INTO sby_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Twalapitilisha bulwendo bwetu mu bwato kufuma ku Tulo, ne kushika ku Pitolemasi uko nkotwalapa mitende banse ne kwikalako busuba bumo. ");
INSERT INTO sby_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Busuba bwakonkapo twalanyamuka ne kuya kushika ku Kaisaleya. Twalekala kung'anda ya Filipo mukambaushi wa Mulumbe Waina, umo wa batuloba basanu ne babili basa balasalwa kunyamfwilisha mu Yelusalemu. ");
INSERT INTO sby_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Filipo walikukute bana batukashi bashike bana, balikuba bashinshimi. ");
INSERT INTO sby_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Mpokwalapita masuba angi, kwalesa mushinshimi walafumina ku Yudeya walikukwiweti Agaba. ");
INSERT INTO sby_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Walesa kuli njafwe ne kumanta mukopo wa Paulo, ne kulisunga mwine ku makasa ne ku myendo, ne kwambeti, “Mushimu Uswepa, ulambangeti, mwine mukopo uwu, Bayuda bamu Yelusalemu ni bakamusunge mbuli ncendalisungu, ni bakamutwale mu makasa abantu bakunsa.” ");
INSERT INTO sby_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Mpotwalanyumfwa maswi alico, afwe pamo ne bantu balikuba uko, twalamusenga Paulo kwambeti katayako ku Yelusalemu. ");
INSERT INTO sby_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Nsombi nendi Paulo walakumbuleti, “Mulalilishanyanga aconi ne kumpa buyowa? Ndalibambila, nteko kuya kusungwa konka sobwe, nsombi kuya kufwila kopeloko mu Yelusalemu pacebo ca lina lya Mwami Yesu.” ");
INSERT INTO sby_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Mpotwalaboneti tulalilwa kumukanisha, twalamuleka, twalambeti, “Kuyanda kwa Mwami kwinshike.” ");
INSERT INTO sby_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Panyuma pa kwikalako masuba ang'ana, twalalongela bintu byetu ne kuya ku Yelusalemu. ");
INSERT INTO sby_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Twalaya pamo ne beshikwiya nabambi baku Kaisaleya. Balatushikisha kung'anda ya muntu walikukwiweti Munasoni waku Saipulasi, nkotwalikuba twelela kwikala. Walikuba shikwiya kwa byaka bingi. ");
INSERT INTO sby_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Mpotwalashika mu Yelusalemu, banse balatutambula cena. ");
INSERT INTO sby_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Busuba bwakonkapo, Paulo ne njafwe twense pamo twalaya kubona Jemusi. Twalacanako bamakulene bamubungano kabali babungana. ");
INSERT INTO sby_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Popelapo, Paulo walabapa mitende ne kubambila cena bintu byonse Lesa mbyalensa ku bantu bakunsa, kupitila mu ncito yakendi. ");
INSERT INTO sby_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Mpobalanyumfwa makani awa balamutembaula Lesa, ne kumwambila Paulo, eti, “Obe mwanse wetu, Paulo, kobona kufula kwa bina ne bina bya Bayuda bashoma muli Mwami, bonse bacinka manungo mu Milawo ya Mose.” ");
INSERT INTO sby_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","“Bonse aba balambilweti obe uleyishinga Bayuda bonse bekala mubishi nabimbi kwambeti baleke kukonkela Milawo ya Mose. Kayi bambilweti kabata palulanga bana babo, nambi kukonkela miyambo ya bakulukulu. ");
INSERT INTO sby_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Aba bantu ni banyumfweti ulesa. ");
INSERT INTO sby_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Neco, leka tukwambile nceti winse. Kuno kuli batuloba bana abo balalumbila kuli Lesa. ");
INSERT INTO sby_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Koya nabo batuloba aba ku Nganda ya Lesa, wenga uliswepeshe pamo nendibo kwelana ne mwambo. Kufumapo ubalipilile kwambeti baceswe mishishi. Wenseco, bantu bonse nibakenshibeti byonse mbyebambanga pa linjobe ni byakubepa, anu ne njobe ukute kukonkela Milawo ya Mose. ");
INSERT INTO sby_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ku bantu ba mishobo naimbi abo balashoma Mwami Yesu, twalabalembela kalata ya kubenshibisha ncetwalasuminishana. Twalasuminishaneti, nkabelela kulya byakulya bikute kupewa milumbo kutumbwanga, nambi kulya milopa, nambi kulya nyama yalifwila ne kutensa bufule.” ");
INSERT INTO sby_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Neco busuba bwakonkapo, Paulo walaya ne batuloba bana ne kuliswepesha pamo nabo. Kufumapo walaya mu Ng'anda ya Lesa kuya kubenshibisha bantu sha bushiku mbweshi bakapwishe kuliswepesha kwabo mpweti akababengele milumbo kuli Lesa batuloba basa umo ne umo. ");
INSERT INTO sby_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Mpwalikuba pepi kupwa masuba asanu ne abili akuliswepesha, Bayuda nabambi ba kucishi ca Asiya pakumubona Paulo mu Ng'anda ya Lesa, balayungaula likoto lya bantu ne kumwikata Paulo. ");
INSERT INTO sby_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Balabilikisheti, “Batuloba amwe Baislayeli, kamwisani mutunyamfwe! Uyu emuntu usa wayanga kwiyisha bantu kuli konse, sha kwipisha bene Islayeli, ne Milawo ya Mose, kayi ne Ng'anda ya Lesa ino. Lalete bantu bakunsa mu Ng'anda ya Lesa, lasafwanya musena waswepa uno.” ");
INSERT INTO sby_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Balambeco pakwinga balabona mutuloba walikukwiweti Tulofimo waku Efenso, kali pamo ne Paulo mu munshi, neco balayeyeti Paulo la mumanta kuya nendi mu Ng'anda ya Lesa. ");
INSERT INTO sby_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Neco mushi wonse walesula ne mipyopyongano. Bantu bonse balabundumukila kuya kwikata Paulo, ne kumupulisha pansa pa Ng'anda ya Lesa. Pacindico balacala bisasa bya ku Ng'anda ya Lesa. ");
INSERT INTO sby_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Cindi ncebali kuyanda kumushina Paulo,makani awa alanyufwika ku mukulene wa bashilikali bonse Baciloma eti mu munshi wonse wa Yelusalemu mulesulu mipyopyongano. ");
INSERT INTO sby_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Mwa bwangu bwangu mukulene wa bashilikali bonse, walamanta bamakulene ba bashilikali, pamo ne bashilikali nabambi ne kubundumukila ku bantu abo balikwinsa mipyopyongano. Mpobalamubona kesa pamo ne bashilikali, balacileka kumuma Paulo. ");
INSERT INTO sby_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Mukulene wa bashilikali bonse walaya kuli Paulo kuya kumwikata. Walambila bashilikali nabambi kwambeti bamusunge ncetani shibili, lino walepusheti, “Inga muntuyu niyani, kayi nicani ncalenshi?” ");
INSERT INTO sby_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Bantu balatatika kubilikisha kabamba cambe ambe, umo wambeci, naumbi wambeco. Kwalabowa kuyobeka cakwinseti mukulene wa bashilikali bonse walalilwa kucana cine cine calaletelesha mipyopyongano. Neco walambila bashilikali eti bamutwale Paulo kunkambe ya bashilikali. ");
INSERT INTO sby_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Paulo mpobalamushikisha pa kutantila kuya munkambe yabo, bashilikali balamunyamuna pakwinga bantu balikuyanda kumulya bubesu. ");
INSERT INTO sby_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Bonse bantu balikumukonkela balikubilikisheti, “Mushineni!” ");
INSERT INTO sby_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Lino bashilikali kabali pepi kumwingisha Paulo munkambe, walambila mukulene wa bashilikali, eti, “Ndasengengeti ndimwambileko cintu nacimbi.” Mukulene wa bashilikali bonse walambeti, “Sena ucinshi kwamba Cigiliki? ");
INSERT INTO sby_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Anu sena ntobe mwine Injipito usa walaleta mipyopyongano ya kubukila bwendeleshi cisa cindi, ne kutangunina bakapondo myanda makumi ana, kuya nabo mucinyika?” ");
INSERT INTO sby_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulo walakumbuleti, “Ame nde Muyuda, ndalasemenwa mu munshi wa Taliso, munshi wayampuwo mucishi conse ca Kilikiya. Ndasengenga kwambeti ng'ambeko ne bantu aba.” ");
INSERT INTO sby_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Mukulene wa bashilikali bonse usa walamusuminisha. Lino Paulo walemana pa kutantila ne kutandabula cikasa kubamwenesha bantu. Mpobalamwena bonse tonto Paulo walamba mu mulaka wa Cihebeli, walambeti, ");
INSERT INTO sby_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Mobantu mwense, banse, ne bamatata, kamunyumfwani kukana mulandu kwakame.” ");
INSERT INTO sby_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Pakunyumfwa kwambeti Paulo, lambanga mu mulaka wabo, balamwena tonto kwambeti banyumfwishishe cena. Paulo walapitilisha kubambileti, ");
INSERT INTO sby_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ame nde Muyuda, ndalasemenwa mu munshi wa Taliso, mucishi ca Kilikiya, nsombi ndalakulila muno mu munshi wa Yelusalemu. Ndalikuba shikwiya wa Gamaliyeli, uyo walanjiyisha mwakukonkela Milawo yalapewa ku bamashali betu bakulukulu. Kayi ndalikuba walibenga kusebensela Lesa, mbuli ncemubele mwense omuli pano. ");
INSERT INTO sby_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ndalikupensha bantu balikukonkela nshila ya Mwami Yesu, nabambi ndalikubashinisha. Ndalikwikata batuloba ne batukashi ne kubatwala mujele. ");
INSERT INTO sby_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Mukulene wa Beshimilumbo, ne bomboloshi ba nkuta ngabasumineti ndambanga cakubinga. Pakwinga balo ebalampa makalata, akunsuminisha kutwala ku Bayuda balikwikala mu munshi wa Damasiko. Neco ndalaya akubekata bantu bashoma Yesu ne kubaleta ku Yelusalemu, kabali basungwa ncetani kwambeti bese bapewe cisubulo. ");
INSERT INTO sby_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Mpondalashika pepi ne munshi wa Damasiko, cindi ca 12 koloko munshi, mumuni unene walafuma kwilu walamunikila mpondalikuba. ");
INSERT INTO sby_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ndalawa panshi, popelapo ndalanyumfwa liswi lya kwambeti, ‘Saulo! Saulo! Inga ulampenshelenga cani cisa’ ");
INSERT INTO sby_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ndalepusheti, ‘Inga njamwe bani Nkambo,’ Walikwamba walankumbuleti, ‘Njame Yesu waku Nasaleti ngolapenshenga.” ");
INSERT INTO sby_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Bantu mbondalikuba nabo baliya kunyumfwa liswi lya muntu walikwamba nenjame sobwe, nsombi mumuni balaubona. ");
INSERT INTO sby_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Popelapo ndalepusheti, “Inga nicani ncendelela kwinsa Nkambo? Apo Mwami walambeti, ‘Nyamuka, wenga mu Damasiko, nibenga bakwambile byonse Lesa mbyalayandangeti winse.’ ");
INSERT INTO sby_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ndalashipilwa cebo ca mumuni unene walamunikila cakwinseti balanjikatilila kucikasa bantu mbondalikuba nabo pa kuntwala mu Damasiko.” ");
INSERT INTO sby_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Mu munshi uwu mwalikuba muntu walikukwiweti Hananiya, muntu wali kukonkela Milawo, ne kukambilila Lesa ne moyo wakendi wonse. Bayuda bonse baku Damasiko balikumupa bulemu. ");
INSERT INTO sby_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Walemana pepi ne njame ne kwambeti, “Saulo mukwabo, kocaluka menso utatike kubona kayi!” Pacindi copeleco ndalacikonsha kulanga ne kumubona Hananiya. ");
INSERT INTO sby_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Popelapo walambeti, “Lesa ngobali kukambilila bamashali betu bakulukulu, lakusala kwambeti winshibe kuyanda kwakendi ne kubona Walulama ne kunyumfwa liswi lyakendi. ");
INSERT INTO sby_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Pakwinga nukamubele kamboni pakubambila bantu bintu mbyowalabona, ne kunyumfwa. ");
INSERT INTO sby_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Inga lino ucipembelela cani? Nyamuka, ubatishiwe kwambeti Lesa akuswepeshe bwipishi bwakobe mpolapailinga Lesa. ");
INSERT INTO sby_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Mpondalabwelela ku Yelusalemu, cindi ncondalikupaila mu Ng'anda ya Lesa ndalabona cimbonimboni. ");
INSERT INTO sby_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ndalabona Mwami kang'ambileti, ‘Fwambana, fuma mu Yelusalemu muno, pakwinga bantu nteti bakunyumfwile bukamboni mbweti wambenga bulambanga sha njame.’ ");
INSERT INTO sby_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ame ndalambeti, ‘Nkambo, bonse bacinshi kwambeti ndalikuya mu mibungano ya Bayuda, kusunga ne kubauma abo bashoma muli njamwe. ");
INSERT INTO sby_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Kayi mpobalikumushina Stefano uyo walikwambila bantu makani ali pali njamwe, ame ndalikubapo. Ndalasuminishako kwambeti bamushine, kayi njame ndalikuba ndekata mu makasa byakufwala bya kunsa bya bantu abo balikumushina.’ ");
INSERT INTO sby_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Lino Mwami walang'ambileti, ‘Koya, pakwinga ni nkakutume kutali ku bantu bakunsa.’” ");
INSERT INTO sby_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Bantu bali kabakutika mpaka pacindi ncalamba maswi akuya kubantu bakunsa.Neco balatatika kubilikisheti, “Katumushinani! Nkelela kubapo pacishi capanshi muntuyu sobwe!” ");
INSERT INTO sby_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Balabilikisha ne kuwala byakufwala byabo bya kunsa mwilu, ne kutukula lusuko. ");
INSERT INTO sby_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Popelapo mukulene wa bashilikali bonse walabambileti bamutwale Paulo, munkambe ya bashilikali kuya kumukwapula, kwambeti ayubulule ncobayobekelanga bantu bonse. ");
INSERT INTO sby_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Lino mpobalamusunga kwambeti batatike kumukwipa, Paulo walepusha mushilikali walikwendelesha bashilikali mwanda, walikuba wemana pepi, “Sena mulawo wasuminisha kukwipa bikoti muntu Muloma, kamutana mu mombolosheti mucane mulandu?” ");
INSERT INTO sby_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Uyu mukulene wabashilikali mpwalanyumfweco, walaya kwambila mukulene wa bashilikali bonse, ne kumwipusheti, “Inga mulayandanga kwinsa cani? Muntuyu ni Muloma!” ");
INSERT INTO sby_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Popelapo mukulene wa bashilikali bonse walaya kuli Paulo, kuya kumwipusheti, “Kong'ambila cena, sena omu Loma?” Paulo walakumbuleti, “Ee.” ");
INSERT INTO sby_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Mukulene wa bashilikali bonse walambeti, “Ame ndalensa kula ne mali angi, kwambeti mbe Mu loma.” Paulo walakumbuleti, “Ame nde mu Loma mukusemwa.” ");
INSERT INTO sby_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Cindico bashilikali basa balikuyanda kumwipusha balasonoka. Nendi mukulene wa bashilikali bonse walatina mpwaleshibeti Paulo ni Muloma, kayi bamusunga ncetani. ");
INSERT INTO sby_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Neco pabusuba bwalakonkapo, mukulene wa bashilikali bonse walikuyanda kwinshiba cena mulandu ngobali kuyanda kumupa Paulo Bayuda, walambila bashilikali kwambeti bamusungulule Paulo, kufumapo walambila beshimilumbo bamakulene ne bendeleshi ba nkuta bonse kwambeti babungane. Neco balamwimanika Paulo pantangu pabo. ");
INSERT INTO sby_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulo walabalangishisha bendeleshi ba nkuta, walambeti, “Batuloba mwense, banse bame. Ame ndekala ne buyumi bwalulama ne miyeyo yaloma pamenso a Lesa ne kukwanilisha incito shakame nshendelela kwinsa kushikila lelo pano.” ");
INSERT INTO sby_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Hananiya, Mukulene wa Beshimilumbo mpwalanyumfweco, walambila balikuba bemana pepi ne Paulo kwambeti bamume lupaka pa mulomo. ");
INSERT INTO sby_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Paulo walamwambila Hananiya, “Lesa lakakumunga obe olubumbu lwashibululwa bulongo utuba! Obe ncowekaliloko ni kwambeti ung'omboloshe kwelana ne Milawo, kayi njobe ulatalukunga Milawo pa kwambila bantu eti bangume!” ");
INSERT INTO sby_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Nomba bantu balikuba pepi ne Paulo balamwambileti, “Ha! Ulatukananga Mukulene wa Beshimilumbo wa Lesa!” ");
INSERT INTO sby_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paulo walakumbuleti, “Mobanse bame, nkandacishibangeti ni Mukulene wa Beshimilumbo. Pakwinga Mabala a Lesa alambangeti, ‘Kotamba maswi ayipa pa mwendeleshi wa bantu bakobe sobwe.’ ” ");
INSERT INTO sby_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Paulo mpwalaboneti nabambi balikuba Basaduki, nabambi balikuba Bafalisi, walabilikisheti, “Mobanse bame, ame nde Mufalisi, mwana wa Bafalisi! Ndomboloshewanga cebo ca kupembelela nkonkute kwa kwambeti bafwa ni bakapunduke.” ");
INSERT INTO sby_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Mpwalambeco, palaba kutanyumfwana pakati pa Bafalisi ne Basaduki. Popelapo balapansana. ");
INSERT INTO sby_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Pakwinga Basaduki bakute kwambeti kuliya kupunduka, kuliya mungelo, nambi mushimu. Balo Bafalisi bashoma byonse bitatu. ");
INSERT INTO sby_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Neco kutanyumfwana kwalakonempa, pakwinga beshikwiyisha Milawo ya Mose balikuba kulubasu lwa Bafalisi balemana ne kutotekeshana cangofu, ne kwambeti, “Afwe paliya ncetulacana caipa mu muntuyu! Mpani mushimu, nambi mungelo walamba nendi.” ");
INSERT INTO sby_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Makoto abantu abili alatotekeshana cangofu, cakwinseti mukulene wa bashilikali bonse walatineti mpani ni bamushine Paulo. Neco walambila bashilikali bakendi kuya kumufunyapo Paulo pa bantu, ne kumutwala mu nkambe ya bashilikali. ");
INSERT INTO sby_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Pabusuba bopelobo cindi ca mashiku, Mwami Yesu walemana pepi ne Paulo ne kumwambileti, “Yumisha moyo! Mbuli ncolambeleko kamboni muno mu Yelusalemu, anu neku Loma welela kumbeleko kamboni.” ");
INSERT INTO sby_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Mpobwalaca, Bayuda nabambi balabungana pamo, kupangana cakumwinshila Paulo. Balalumbila pamenso a Lesa kwambeti nteti balyepo cakulya, nambi kunwapo ciliconse mpaka bamushine Paulo. ");
INSERT INTO sby_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Bantu abo balapangana sha kumushina Paulo balikuba bapitilila makumi ana. ");
INSERT INTO sby_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Mwa bwangu bwangu balaya kuli beshimilumbo bamakulene, ne bamakulene Baciyuda, ne kubambileti, “Tulalumbili tobene kwambeti, nteti tulyepo cintu ciliconse mpaka tukamushine Paulo. ");
INSERT INTO sby_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Neco amwe, pamo ne bendeleshi ba nkuta bonse, muye mumusenge mukulene wa bashilikali bonse kwambeti amulete kuno Paulo. Mu mubepeti mulayandanga kunyumfwishisha cena ncalensa. Kabatana bashika nendi kuno, afwe tulalibambili ku mushina.” ");
INSERT INTO sby_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Nomba muntuwendi Paulo mutuloba, walanyumfwa nshebali kupangana. Mwa bwangu bwangu walaya munkambe ya bashilikali kuya kumwambila Paulo. ");
INSERT INTO sby_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Popelapo Paulo walakuwa mukulene wa bashilikali mwanda, ne kumwambileti, “Koya nendi mutuloba musepela uyu kuli mukulene wa bashilikali bonse, ukute maswi akumwambila.” ");
INSERT INTO sby_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Mukulene wa bashilikali mwanda, walamutwala mutuloba musepela kuli mukulene wa bashilikali bonse, ne kumwambileti, “Paulo usa ngotwasunga langa lankuwu ne kunsengeti ndete mutuloba uyu kuli njamwe, ukute maswi akumwambila.” ");
INSERT INTO sby_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Mukulene wa bashilikali bonse usa walamwikata kucikasa ne kuya nendi pa lubasu, ne kumwipusheti, “Nimakani cini ngolayandanga kung'ambila?” ");
INSERT INTO sby_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Nendi mutuloba usa walambeti, “Bayuda nabambi balapanganeti bakese kulinjamwe lilo, kwisa kumusengeti mukamusungulule Paulo kuli bendeleshi ba nkuta, nibakabepeti balayandanga kunyumfwishisha ncobele mulandu wakendi. ");
INSERT INTO sby_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Kamutaka banyumfwila sobwe, pakwinga kuli batuloba bapitilila makumi ana, beti bakabenga bamubelamina Paulo panshila. Balumbila pamenso a Lesa kwambeti, ‘nteti balye cakulya, nambi kunwa kabatana bamushina Paulo.’ Pacino cindi balibambila kumushina, balapembelelengowa ncotimukumbule.” ");
INSERT INTO sby_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Mukulene wa bashilikali bonse walambeti, “Kotambilako muntu naba umo makani awa ngolang'ambiliko.” Popelapo mutuloba usa walapulamo, walaya kwabo. ");
INSERT INTO sby_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Mukulene wa bashilikali walakuwa bashilikali babili bamakulene, ne kubambileti, “Mantani bashilikali myanda ibili ne bashilikali makumi asanu ne abili beshikutanta pama haki, kayi ne bashilikali myanda ibili bamafumo beti benga ku Kaisaleya, banyamuke cindi ca 9 koloko mashiku. ");
INSERT INTO sby_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Nendi Paulo mu mutantike pa lihaki, mwenga mu mushikishe cena kuli Mwendeleshi Felekisi.” ");
INSERT INTO sby_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Usa mukulene wa bashilikali bonse walalemba nkalata njalalembamo maswi awa. ");
INSERT INTO sby_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Njame Kulodiyasi Lisiyasi, ndalembelenga amwe mwalemekwa ba Felekisi, ndeti mitende. ");
INSERT INTO sby_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Bayuda balamwikata muntuyu, balikuyanda kumushina. Lino mpondalenshibeti ni mwine Loma, ndalaya ne bashilikali kuya kumufuna. ");
INSERT INTO sby_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ndalikuyanda kwinshiba mulandu ngobalamupa, neco ndalamutwala ku nkuta ya Bayuda. ");
INSERT INTO sby_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ndalacaneti paliya caipa ncalensa ncelela kufwilapo, nambi kusungwa sobwe, pakwinga balikumupa mulandu pa makani a Milawo yabo bene. ");
INSERT INTO sby_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Mpondalambilweti Bayuda nabambi bapangananga sha kumushina, pacindi copeleco ndalayeya kwambeti ndimutume kuli njamwe. Ndabambila bonse balikumupa mulandu kwambeti, bakese bakambe kuli njamwe mulandu ngobalamupanga.” ");
INSERT INTO sby_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Basa bashilikali balensa ncobalambilwa. Balamanta Paulo busuba bopelobo mashiku, ne kuya kumushikisha kumunshi wa Antipatili. ");
INSERT INTO sby_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Mpobwalaca bashilikali beshikutanta pa mahaki balapitilisha kumushindikila Paulo, bashilikali nabambi balabwelela ku nkambe yabo. ");
INSERT INTO sby_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Bashilikali beshikutanta pa mahaki mpobalashika nendi ku Kaisaleya, balamupa nkalata Mwendeleshi Felekisi ne kushiya Paulo mu makasa akendi. ");
INSERT INTO sby_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Mwendeleshi Felekisi mpwalapwa kubelenga nkalata, walepusha Paulo lubasu lwacishi ndwakute kufumina. Mpwalanyumfweti ukute kufuma ku Kilikiya, ");
INSERT INTO sby_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","walambeti, “Ni nkanyumfwe mulandu wakobe, bakesa balakubepeshenga.” Bashilikali walabambileti bamulonde cena mu manda akomboloshela milandu ngalebaka Helode. ");
INSERT INTO sby_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Mpopalapita masuba asanu, mukulene wa beshimilumbo Hananiya, pamo ne bamakulene Baciyuda, ne nkalakata ya milawo walikukwiweti Tetalasi, balaya ku Kaisaleya. Mpobalashika kuli Mwendeleshi Felekisi, balamubepesha Paulo. ");
INSERT INTO sby_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Mpobalamukuwa Paulo, Tetalasi walatatika kumubepesheti, “Omwalemekwa! Butangunishi bwenu bwa mano ebulalete lumuno kwacindi citali mubwikalo bwetu, kayi ni bintu bingi bilenshikinga kusumpula cishi cetu. ");
INSERT INTO sby_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ibi bintu tulabitambulunga ne makasa abili kuli konse pacindi conse, neco tulamulumbunga. ");
INSERT INTO sby_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Nsombi nkansuni kumutaila cindi sobwe, ndamusengengeti mubombe moyo, kayi munkututikishe pa makani ang'ana awa ngotulambanga. ");
INSERT INTO sby_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Twacaneti muntuyu wapensha. Ni shikuleta mipyopyongano pakati pa Bayuda ne mucishi conse capanshi. Kayi ni mutangunishi wa likoto likute kukwiweti, ‘Banasaleti.’ ");
INSERT INTO sby_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Kayi wayandanga kusafwanya Ng'anda ya Lesa, neco twalamwikata. Twali kuyanda kumombolosha kwelana ne Milawo yetu. ");
INSERT INTO sby_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Nomba mukulene wa bashilikali bonse Lisiyasi, walesa ne kwisa kumufunya mwangofu mu makasa etu. ");
INSERT INTO sby_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Kufumapo, Lisiyasi, walambeti beshikumupa milandu bonse, belela kwisa kuli njamwe. Na mu mwipushe muntuyu ngamulinyumfwila mobeneti milandu yonse njotulambanga ni mucaneti ni yakubinga.” ");
INSERT INTO sby_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Nabo Bayuda balasuminisheti mbyalambanga ni bya kubinga. ");
INSERT INTO sby_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Mwendeleshi Felekisi, walamucebula Paulo ne cikasa kwambeti ambepo, Paulo walambeti, “Ndicinsheti mwalatatika kaindi kombolosha bantu bamucishici, neco ndakondwa kulifuna pamenso penu. ");
INSERT INTO sby_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Inga mulicanina mobene kwambeti palapiti masubowa likumi ne abili, mpondalaya ku Yelusalemu kuya kukambilila Lesa. ");
INSERT INTO sby_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Bayuda aba baliya kuncana mu Ng'anda ya Lesa kantotekeshana ne bantu. Ndiyawa kuletapo mipyopyongano mu manda abo akupaililamo, nambi mu munshi wa Yelusalemu. ");
INSERT INTO sby_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Nkabelela kucikonsha kumulesheti byonse mbyobalambepeshenga ni bya kubinga sobwe.” ");
INSERT INTO sby_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","“Nsombi ncondasumininga ni kwambeti, ame nkute kukambilila Lesa uyo ngobali kukambilila bamashali betu bakulukulu, kwelana ne ‘Nshila iyo njobalambangeti niya bwepeshi.’ Ndashoma byonse byalembwa mu Milawo ya Mose, kayi ne byalembwa mu mabuku abashinshimi bakulukulu. ");
INSERT INTO sby_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ndapembelelenga muli Lesa, mbuli aba naboyo ncobalapembelelenga, kwambeti bantu bonse balenshinga byaina, ne balenshinga byaipa ni bakapunduke kubafu. ");
INSERT INTO sby_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ecebo cakendi ndelekeshenga ne ngofu kwikala buyumi bwaina pamenso a Lesa ne bantu.” ");
INSERT INTO sby_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Palapiti myaka ingi mpondalafuma mu Yelusalemu, ndabwelelowa linolino kuleta bipo bya mali kuli Bayuda baname bakandu, kayi ndaleta milumbo naimbi ya kubenga kuli Lesa. ");
INSERT INTO sby_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Mpondalikwinseco, empobalancana mu Ng'anda ya Lesa kandi ndapwishi kuliswepesha kwelana ne Milawo ya Mose. Nkandalikubapo ne likoto lya bantu kayi nkapalikubapo mipyopyongano sobwe. ");
INSERT INTO sby_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Nsombi palikuba Bayuda nabambi baku Asiya, abo banga belela kubapo pano pamenso penu kwambeti bampe mulandu. ");
INSERT INTO sby_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Mpani nabo aba balipo ngabamwambila na pali mulandu ngobalancana nawo beshinkuta babo mpobalang'ombolosha. ");
INSERT INTO sby_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Nsombi, pali cintu cimo ncondalamba mpondalemana pantangu pabo, ndalambeti, ndomboloshewanga ne njamwe lelo cebo cakushometi bafwa ni bakapundushiwe.” ");
INSERT INTO sby_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Popelapo Mwendeleshi Felekisi, walatuntulusha busuba bwakombolosha mulandu wabo, pakwinga walikwinshiba cena makani a Nshila ya Mwami Yesu. Walabambileti, “Ninkapingule mulandu wenu akesa Lisiyasi mukulene wa bashilikali bonse.” ");
INSERT INTO sby_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Walambila mukulene wa bashilikali mwanda, kwambeti amulonde Paulo, kayi amupengonga cindi ca kulikalila mwine, ne kusuminisha banendi kumuletelako bintu bilayandikinga pali endiye. ");
INSERT INTO sby_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Mpopalapitako masuba ang'ana, Felekisi ne Dulusila mukashendi Muyuda, walesa. Walatuma muntu kuya kumukuwa Paulo, balanyumfwishisha ncalikwamba Paulo sha lushomo muli Klistu Yesu. ");
INSERT INTO sby_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Lino cindi Paulo ncalikwamba sha bululami, ne sha kulilama kayi ne sha busuba Lesa mbweshakomboloshe bantu, Felekisi walatina. Popelapo walamwambila Paulo, “Pacino cindi koya, ndabona cindi ni nkukuwe kayi.” ");
INSERT INTO sby_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Felekisi walikuyanda kupewako mali acishinkamulomo kufuma kuli Paulo. Ecebo cakendi wali kumukuwakuwa. ");
INSERT INTO sby_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Lino mpopalapita byaka bibili, Polokiyo Fesito, walapyana Felekisi pacipuna ca bwendeleshi. Pakuyanda kubakondwelesha Bayuda, Felekisi walamushiya Paulo mujele. ");
INSERT INTO sby_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Mpopalapita masuba atatu kufumina pa busuba mbwalashika mu cimpansha caYudeya, Fesito walafuma ku Kaisaleya walaya ku Yelusalemu ");
INSERT INTO sby_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Beshimilumbo bamakulene, pamo ne batangunishi Baciyuda, balamwambila Fesito milandu yonse njebalamubepesha Paulo. Balamukombelela Fesito, ");
INSERT INTO sby_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","kwambeti amubweshe Paulo ku Yelusalemu. Balambeco pakwinga balikuyandeti bamushine pakwisa mu nshila. ");
INSERT INTO sby_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Nomba Fesito walabakumbuleti, “Paulo wasungilwa ku Kaisaleya uko nkondenga linolino apa. ");
INSERT INTO sby_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Neco, batangunishi benu twenga pamo ne njame ku Kaisaleya kwambeti benga bakamupe mulandu kopeloko na pali ncalensa caipa.” ");
INSERT INTO sby_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fesito mpwalekalako masuba asanu ne atatu mpani masuba likumi ku Yelusalemu, walaya ku Kaisaleya. Pabusuba bwakonkapo, walengila mu nkuta ne kwikala pa cipuna calombolosho ne kutuma bantu kuya kuleta Paulo. ");
INSERT INTO sby_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Lino Paulo mpwalashika, Bayuda balafumina ku Yelusalemu balamushinguluka ne kwamba makani angi eshikutinisha, nomba baliyawa kucikonsha kupa bukamboni bwesulila. ");
INSERT INTO sby_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Nomba Paulo pakulifuna walambeti, “Paliya cintu ncondalensa cabula kusuminishiwa mu Milawo ya Bayuda, ndiyawa kwipishapo Ng'anda ya Lesa, nambi kwamba caipa ku Mwami waku Loma.” ");
INSERT INTO sby_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Nomba pakuyandeti Bayuda bamusune, Fesito walepusha Paulo, “Sena ngoyanda kuya ku Yelusalemu kwambeti nkoti nkakomboloshele?” ");
INSERT INTO sby_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paulo walakumbuleti, “Ame ndemana kendi pano pa cipuna ca lombolosho lwa Mwami waku Loma, pano empondelela komboloshewa. Paliya ncendalepishila Bayuda, mbuli ncomwinshi mobene. ");
INSERT INTO sby_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Lino na pali cintu ncondalensa cabula kusuminishiwa ne Milawo, ico celela kunshinisha ame, nkandakananga kunshinwa sobwe. Nsombi ibi mbyobalambanga na ni bya bwepeshi, paliya muntu welela kuntwala mu makasa abo. Neco ndasengengeti, Mwami waku Loma akawomboloshe mulandu wakame.” ");
INSERT INTO sby_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Fesito mpwalapwisha kufwiyafwiya pamo ne bamaloba bamano, walamwambileti, “Pakwinga omwine ulasengeti Mwami waku Loma eshakomboloshe mulandu wakobe, anu nukenga ku Mwami waku Loma.” ");
INSERT INTO sby_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Mpopalapita masuba ang'ana, Mwami Agilipa pamo ne Benisi nkash yakendi, balaya ku Kaisaleya, kuya kumufwakashila Fesito. ");
INSERT INTO sby_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Mpobalekalako masuba angi, Fesito walamwambila Mwami Agilipa ncewalikuba mulandu wa Paulo. Walambeti, “Kuli muntu kuno ngwalashiya Felekisi mujele. ");
INSERT INTO sby_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Mpondalaya ku Yelusalemu, beshimilumbo bamakulene, ne bamakulene Baciyuda, balang'ambila makani a muntuyu ne kunsengeti ndimupe mulandu. ");
INSERT INTO sby_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Nomba ndalabambileti catondwa kuli njafwe Baloma. Pakwinga nkatukute kupa mulandu muntu uliyense kwakubula kumupa cindi cakulifuna pamenso pa abo balamupanga mulandu. ");
INSERT INTO sby_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Mpobalesa kuno pamo ne njame, ndiyawa kutaya cindi sobwe, busuba bwalakonkapo, ndalengila mu nkuta ne kwikala pa cipuna ca lombolosho, ne kutuma bantu kuya kumuleta Paulo. ");
INSERT INTO sby_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Beshikumupa mulandu mpobalanyamuka kutatika kwamba, baliya kwamba milandu yaipa ame njendalikuyeyeti njebalamuletele. ");
INSERT INTO sby_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Anu alikuba makani ngobali kutotekeshana bene, mbuli mobelela kukambilila Lesa, kayi ne makani a muntu naumbi walafwa walikukwiweti Yesu, uyo Paulo ngwalikwambeti ni muyumi. ");
INSERT INTO sby_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ndalabula mwakucanina makani akubinga pa mulandu uwu, neco ndalepusha Paulo na ngoyanda kuya komboloshewa ku Yelusalemu. ");
INSERT INTO sby_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Paulo walasenga mwine kuya komboloshewa ne Mwami waku Loma, ne kwambeti bashilikali bamulondenga mujele katanaya ku Loma. Neco ndalambila bashilikali kwambeti bamulondenga mpaka busuba bwa kumutuma kuli Mwami mukulene.” ");
INSERT INTO sby_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agilipa walambila Fesito, “Ne njame ndayandangeti nkalinyumfwile ndemwine kumuntuyu.” Fesito walakumbuleti, “Nimukalinyumfwile mobene lilo.” ");
INSERT INTO sby_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Busuba bwalakonkapo, Agilipa ne Benisi balatambulwa cabulemu ne bantu mpobalikuya kwingila mu nkuta, pamo ne bashilikali bamakulene, ne bantu bayampuwo mu munshi. Popelapo Fesito walatuma bashilikali kuya kumuleta Paulo. ");
INSERT INTO sby_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Mpwalesa Paulo, Fesito walambeti, “Mwalemekwa Mwami Agilipa, ne njamwe muli pamo ne njafwe muno. Uyu muntu ngomulabononga, engobalatongokunga Bayuda bonse bekala kuno, ne ku Yelusalemu, ne kubilikisheti welela kufwa. ");
INSERT INTO sby_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Nsombi ame pacakame, paliya caipa ncondalacana celela kumuletela lufu. Lino pakwinga walasengeti omboloshewe ne Mwami waku Loma, ndalayeyeti bakamutwale ku Loma. ");
INSERT INTO sby_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Cakubinga, pano ame ndiyawa cancinencine ncondelela kulembela Mwami, cilambanga sha mulandu wakendi muntuyu. Ecebo cakendi ndamulete muntuyu kuli njamwe, makamaka kuli njamwe Mwami Agilipa, kwambeti mpani ngancana makani akulemba twamwipusha ipushako. ");
INSERT INTO sby_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Pakwinga ndalacaneti nkacinyamfwa kutuma kaili, kwakubula kusansulula cena mulandu ngwakute.” ");
INSERT INTO sby_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Neco Agilipa walambeti kuli Paulo, “Ulasuminishiwa kulifuna omwine.” Paulo walatandabula cikasa cakendi ne kutatika kwambeti, ");
INSERT INTO sby_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Mobami ba Agilipa, Lelo ndaba ne colwe cakwambeti ndilifune ndemwine pamenso penu pa bintu byonse mbyobalambepeshenga Bayuda. ");
INSERT INTO sby_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Amwe muyinshi cena miyambo yonse ya Bayuda, ne kutanyumfwana konse. Neco ndamusengengeti munyumfwishishe mwakwikalika moyo ncondambanga. ");
INSERT INTO sby_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Bayuda bonse babwinshi cena buyumi bwakame kufumina kubutwanike bwakame. Bacinshi ncondalikwikala kumasuba akunyuma mucishi ca comwetu, kayi ne mu Yelusalemu. ");
INSERT INTO sby_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Na balayandanga kwamba pamenso penu, ngabasumineti ame kumasuba akunyuma ndalikuba mu likoto lya Bafalisi, bantu bakute kulama cena milawo ya mpaililo yetu, kupita bantu bonse. ");
INSERT INTO sby_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ndemana pano lelo komboloshewa, cebo cakupembelela cintu ncalashomesha Lesa kuli bamashali betu bakulukulu. ");
INSERT INTO sby_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Mikowa yetu yonse ili likumi ne ibili ilapembelelenga kutambula copeleco Lesa ncalashomesha, kupita mukukambilila munshi ne mashiku. Neco Mobami Mwalemekwa, cebo cakupembelela uku Bayuda balambepeshenga! ");
INSERT INTO sby_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ni pacebo cini amwe Bayuda omuli pano, mukute kuyeyeti nkacikonsheke kushometi Lesa ukute kupundusha bafwa? ");
INSERT INTO sby_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Pacakame ndenka, ndalikuyeya kucana cakwinsa ciliconse, ncendelela kulwanisha kwambeti makani alambanga sha Yesu waku Nasaleti amwene. ");
INSERT INTO sby_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ico encendalensa mu Yelusalemu. Ndalapewa ngofu shakwinseco kufuma kuli beshimilumbo bamakulene, ndalasungisha bantu ba Lesa bangi mujele. Mpobali kombolosheweti bashinwe ndalikubapo kayi ndalasuminishako. ");
INSERT INTO sby_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Tunkanda twingi ndalapesheti bantu aba bacane cisubulo mu mibungano ya Bayuda, ndalelekesha cangofu kwambeti bacileke kushoma muli Yesu. Ndalikuba mukalu cakwinseti ndalikuya kayi ne mu minshi ya mubishi nabimbi kuya kubapensha.” ");
INSERT INTO sby_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Neco, cebo ca makani awa, ndalaya ku Damasiko kankute makalata alampa ngofu alalemba beshimilumbo bamakulene. ");
INSERT INTO sby_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Omwalemekwa Mwami, mpotwalikwenda mu nshila cindi ca 12 koloko, ndalabona mumuni kufuma kwilu. Mumuni uwu walikuba wapita kumunika kwalisuba, mpondalikuba ame, pamo ne baname, palamweka mwee! ");
INSERT INTO sby_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Twense twalawa panshi. Calakonkapo ndalanyumfwa liswi mu mulaka wa Cihebeli lyakwambeti, ‘Saulo! Saulo! Ulampenshelenga cani? Nulilinge omwine pakukakatila kulwana ne njame, ulyeti musune lawalanga bibambala bilashikilinga mukatondo nkateya mwineyo.’ ");
INSERT INTO sby_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Lino ndalepusheti, ‘Inga njamwe bani Nkambo’ Mwami walankumbuleti, ‘Njame Yesu ngolapenshenga. ");
INSERT INTO sby_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Konyamuka! Ndabonekele kuli njobe kwambeti ndikusale, ube musebenshi wakame. Ulayandikinga kuba kamboni wa bintu ibi mbyolabono lelo, kayi ne byo mbyoti nkakuboneshenga kumasuba akuntangu. ");
INSERT INTO sby_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ni nkakufunenga ku Baislayeli ne kubantu bamishobo naimbi nkoti nkakutumenga. ");
INSERT INTO sby_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Ukabacalulenga menso kwambeti bakafume mushinshe ne kwingila mu mumuni, kayi bakafumenga mungofu ya Satana kwambeti bese kuli Lesa. Kupitila mu lushomo lwabo muli njame, Lesa nakabalekelele bwipishi bwabo kwambeti bakabeko ne musena pakati pa bantu basalwa bakendi Lesa.’ ");
INSERT INTO sby_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Neco, Omwalemekwa Mwami Agilipa, ndiya kukana kunyumfwila ncondalabona mu cimbonimboni calafuma kwilu. ");
INSERT INTO sby_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ndalatanguna kukambauka mu Damasiko, ne mu Yelusalemu ne mu cishi conse ca Yudeya, kayi ne kubantu bamishobo naimbi. Ndalabakambaukila kwambeti basanduke kushiya bwipishi bwabo, basandukile kuli Lesa ne kwinsa bintu bilaleshengeti basanduka cancinencine. ");
INSERT INTO sby_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Cebo cakukambauka uku, mpobalancana Bayuda mu Ng'anda ya Lesa, balanjikata kabayanda kunshina. ");
INSERT INTO sby_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Mpaka lelo pano Lesa elanyamfwanga, neco ndemana pano kupa bukamboni ku bantu bonse, balemekwa ne bantususu. Ndambanga bintu byalamba bashinshimi bakulukulu ne Mose, abo balambeti, ");
INSERT INTO sby_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Wasalwa wakendi Lesa nakapenshewe ne kumushina, nsombi nakabe mutanshi kupunduka ku bafu kwambeti, akakambaukile Bayuda ne bantu bamishobo naimbi mu muni walupulusho.” ");
INSERT INTO sby_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Paulo kacamba makani awa akulifuna, Fesito walambila Paulo maswi akucelemuka, “Paulo ulakonyo! Kwiya bintu bingi kula kukonyeshe!” ");
INSERT INTO sby_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Paulo walakumbuleti, “Ndiya kukonya, Mwalemekwa, Fesito! Makani ngondambanga nakubinga, kayi a mano. ");
INSERT INTO sby_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Mwami Agilipa, bacinshi ncondambanga, ecebo cakendi ndambanga mwakusunguluka. Ndashoma kwambeti paliya cintu nacikaba cimo ca bintu ibi mbyobalabula kunyumfwa, pakwinga makani awa aliya kwinshikila mu musena wasolama.” ");
INSERT INTO sby_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Amwe Bami ba Agilipa, “Sena mwashoma maswi abashinshimi bakulukulu? Ndicinsheti mwashoma.” ");
INSERT INTO sby_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Popelapo Mwami Agilipa walepusha Paulo, “Sena mukacindi kang'anowaka obe ulayeyengeti ngaunsandula kuba muklistu ayi?” ");
INSERT INTO sby_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paulo walakumbuleti, “Mukacindi kang'anowa nambi cindi citali, ame ndapailinga kuli Lesa kwambeti amwe, pamo ne bonse balanyumfunga maswi awa lelo, ngababeti ncombele, uku nteko kwambeti ne njamwe musungwe ncetani ishi sobwe!” ");
INSERT INTO sby_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Popelapo, Mwami Agilipa ne Mwendeleshi ne Benisi, kayi ne bantu bonse balanyamuka. ");
INSERT INTO sby_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Mpobalikufumapo bali kabambeti, “Paliya cintu caipa ncalensa muntuyu ncelela kufwilapo, nambi kusungwa mujele sobwe.” ");
INSERT INTO sby_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agilipa walambila Fesito, “Muntuyu nalabula kusengeti Mwami waku Loma akawomboloshe mulandu wakendi, nshinga nolamusungululu kopele kuno.” ");
INSERT INTO sby_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Mpokwalasuminishiweti twenga ku Italiya mubwato, Paulo pamo ne bakaili nabambi balabikwa mumakasa amukulene wa bashilikali mwanda lina lyakendi Juliyasi, wamulikoto lyalikukwiweti, “Bashilikali ba Mwami waku Loma.” ");
INSERT INTO sby_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Twalatanta bwato bwalafumina ku Adilamitayo bwalikuya ku bito bya mucishi ca Asiya. Twalikuba pamo ne Alisitako walafuma ku Tesalonika mu cimpansha ca Makedoniya. ");
INSERT INTO sby_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Busuba bwalakonkapo, twalashika ku Sidoni. Juliyasi walamunyumfwila nkumbo Paulo, walamusuminisha kuya kubona banendi kwambeti, bamupengonga bintu bilayandikinga palyendiye. ");
INSERT INTO sby_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Mpotwalafuma uko, kayi pacebo cacipupu calikubako, twalapitila kwalikubula cipupu kunsa kwansumbu ya Saipulasi. ");
INSERT INTO sby_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Lino panyuma pa kwenda mumbali mulwenje pepi ne cishi ca Kilikiya ne Pamfuliya, twalashika ku munshi wa Mula mucishi ca Lukiya. ");
INSERT INTO sby_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Uko mukulene wa bashilikali mwanda, nkwalacana bwato bunene bwalikufuma ku Alekisandiliya bwalikuya ku Italiya, emwalatutantika. ");
INSERT INTO sby_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Twalikwenda pang'anapang'ana kwa masuba angi mwakupenga penga kwambeti tushike pepi ne munshi wa Sinido. Lino mpotwalaboneti lukupwe lunene lulafumunga nkotwalikuya, twalalilwa kwenda. Twalapita kulubasu nkotwalashinkililwako ne nsumbu ya Kelete, yalangana ne Salimoni. ");
INSERT INTO sby_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Twalenda mwa kupengapenga mu mbali mwa nsumbu, mpaka twalashika pamusena walikukwiweti “Bito Byaina,” Pepi ne munshi wa Laseya. ");
INSERT INTO sby_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Twalataya cindi citali mu bulwendo, cakwinseti busuba bwa kulikanisha kulya bwalikuba bulapiti kendi. Cindico calaboneketi nitukumane ne bintu biyosha mu bulwendo bwetu. Neco Paulo walabacenjesheti, ");
INSERT INTO sby_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Mobaname, ame ndabonongeti kufuma pano bulwendo bwetu bwakuya kuntangu nitukumane ne bintu biyosha. Bintu bingi nibyonongeke ne kutaika, ntebyo bintu byonka ne bwato sobwe, nsombi ne buyumi bwetu.” ");
INSERT INTO sby_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Nomba nendi mukulene wa bashilikali mwanda, walanyumfwila mukulene wa basebenshi ba bwato ne mwine bwato, kupita maswi ngalamba Paulo. ");
INSERT INTO sby_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Cito ico nkacalikuba caina kwikalapo cindi ca mupewo. Neco bantu bangi balayeya kufumapo pacito ico, ne kuya pantanguko kwambeti mpani ngabashika kucito ca Foinike, ne kwikalako pa cindico. Cito ici ciliku Kelete, calangila kumusansa cakumbonshi kayi ne kunyika cakumbonshi. ");
INSERT INTO sby_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Popelapo cipupu cabomba calafumina kumusansa, calatatika kupupula, neco bantu balayeyeti bapitilishe bulwendo bwabo mpaka kuya kushika ku Foinike. Balacikwela cinshimbi cinene cishikwimanika bwato, ne kutatika kwendela mu mbali mwakuma nsumbu ya Kelete. ");
INSERT INTO sby_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Nsombi paliya kupita cindi citali sobwe, lukupwe lwalikukwiweti, “Lukupwe lwa kunyika ca kucwe” Lwalikufumina pansumbu lwalakonempa cangofu. ");
INSERT INTO sby_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ulu lukupwe lwalesa kuma ku bwato cakwinseti calala kuya kwalikufumina lukupwe. Neco twalabuleka kabuya kunyakwa ne lukupwe. ");
INSERT INTO sby_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Twaleshikilwako ne nsumbu ing'ana ya Kauda, mpotwalenda ku lubasu lwa kumusansa. Kopeloko mukupenga penga, twalacikonsha kukwabilila kabwato kang'ana kali kukwelwa ne bwato bunene. ");
INSERT INTO sby_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Kabwato kang'ana balakakwelela mubwato bunene. Balasunga ntambo bwato bunene kwambeti kabuta pausuka. Balikutineti mpani ngabuya buma pa museya waku Siriti mu mbali mwacishi ca Libya. Neco balalasha byombesho bya mu bwato ne kubuleka kabuya kuselaukowa ne lukupwe. ");
INSERT INTO sby_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Twalasunkanwa ne lukupwe lwangofu lwalapitilisha kupupula. Mpobwalaca, balatatika kufunya bintu mbyebalikuba bamanta ne kubiwala mulwenje. ");
INSERT INTO sby_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Pabusuba bwatutatu, balawala mu menshi nabimbi byombesho bya mu bwato. ");
INSERT INTO sby_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Kwa masuba angi nkatwalikulibona lisuba nambi nyenyenshi. Lukupwe lwalapitilisha kupupula cangofu, cakwinseti kupembelela sha kupuluka nkotwalikukute kwalapwa. ");
INSERT INTO sby_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Bantu mpobalekala masuba angi kwakubula kulya cakulya, Paulo walemana pakati pabo ne kwambeti, “Mobanse bame, nshinga ne mwalanyumfwa maswi ngondalambeti katutafuma pa Kelete, ne tulabulu kutaikilwa bintu bingi cisa. ");
INSERT INTO sby_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Nikukabeco ndamusengengeti muyumishe myoyo, paliya muntu naba umo eshafwe, bwato bonka bweti bonongeke. ");
INSERT INTO sby_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ndicinshici, pakwinga lelo mashiku, mungelo wa Lesa uyo kayi e Mwami wakame ngonkute kukambilila langa lesa kuli njame, ");
INSERT INTO sby_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","lambeti, ‘Kotatina Paulo! Ulenga kwimana pamenso pa Mwami waku Loma. Lesa munkumbo shakendi elashomesheti nupuluke, pamo ne bantu bonse mbolinabo mu bulwendobu.’ ");
INSERT INTO sby_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Neco mobanse bame, yumishani myoyo pakwinga ndashometi byonse nibinshike mbuli ncalamba mungelo wa Lesa. ");
INSERT INTO sby_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Nikukabeco nituye tucinke pansumbu njotuteshi.” ");
INSERT INTO sby_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Mashiku abusuba mbotwalakwanisha nsondo shibili kufumina mpolwalatatika lukupwe lwacipupu, twalikatuya kwempauka ne lukupwe palwenje lwa Medeteleniya. Pakati pa mashiku basebenshi ba mu bwato bunene balikuyeyeti tuli pepi ne kumutunta. ");
INSERT INTO sby_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Popelapo balalasha lutambo mu menshi lwalikuba lwasungwako cinshimbi kwakumako, kwambeti babone na nipatali aconi kuya panshi mu menshi apo mpobalikuba. Balacaneti palikuba ntamwa makumi ana kuya panshi. Mpobalendako pang'ana kayi balapima, balacaneti pali ntamwa makumi atatu. ");
INSERT INTO sby_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Apa balatineti bwato bunene ngabuya buma pamabwe. Neco balalasha binshimbi byalema bishikwimanika bwato bina byalikuba byasungwa kunyuma kwa bwato, balatatika kupaileti kabuca bwangu. ");
INSERT INTO sby_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Basebenshi ba mu bwato balikuyanda kuloboka. Neco balaselusha kabwato kang'ana mu menshi, kababoneketi balabikinga binshimbi bishikwimanika bwato bunene, byalikuba byasungwa kuntangu kwa bwato. ");
INSERT INTO sby_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Mwabwangu bwangu, Paulo walambila mukulene wabashilikali mwanda, ne bashilikali nabambi mbobalikuba nabo pamo kwambeti, “Na basebenshi ba mu bwato muno bafumemo, nteti mupulukepo sobwe.” ");
INSERT INTO sby_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Popelapo bashilikali balatimbula ntambo shalikuba shasungwako kabwato ako ne kukaleka kakaya kusela pamenshi. ");
INSERT INTO sby_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Kabutana buca, Paulo walabasenga bonse kwambeti balye cakulya. Walabambileti, “Alakwana masuba likumi ne ana, mwapembelelangowa kwakubula kulya kantu kalikonse. ");
INSERT INTO sby_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Lino ndamusengengeti kamulyani cakulya kwambeti mube ne ngofu sha kupuluka, nteti mulilingepo sobwe.” ");
INSERT INTO sby_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Mpwalapwisha kwamba Paulo walamanta shinkwa walatembaula Lesa pamenso abantu, walakomonako walalya. ");
INSERT INTO sby_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Popelapo bonse balaliyuminisha myoyo balatatika kulya. ");
INSERT INTO sby_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Twense twalikuba mu bwatomo twalikuba myanda ibili, ne makumi asanu ne abili, ne bantu basanu ne umo. ");
INSERT INTO sby_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Bonse mpobalekuta, balawala bifunta bya museke mu menshi byalikuba bilashala mu bwato kwambeti bupubeko. ");
INSERT INTO sby_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Mumene mpobwalaca, basebenshi bamubwato bunene balabona mutunta nomba baliya kuwinshiba. Mpobalabona cisapa camuseya balayeyeti benga bemanike bwato popelapo na kacikonsheka. ");
INSERT INTO sby_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Balatimbula ntambo shekata bishimbi byalema bishikwimanika bwato, ne kubilekela mu menshi, kayi balasungulula ntambo kwalikuba kwasungililwa bitondo byakunyonena bwato. Balakweleka cikwisa cishi kwikata lukupwe calikuba kuntangu kwa bwato kwambeti lukupwe lubatwalanyenga kuntangu. Neco twalabukuba ne kuya ku cisapa. ");
INSERT INTO sby_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Nomba bwato bwalakacinka pa museya walikuba mu menshi, popelapo bwalemana. Cimpansha cakuntangu calakapatila mu museya calala kucendesha. Calo cimpansha cakunyuma calapasauka ne mankape alikwisa cangofu. ");
INSERT INTO sby_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Pacindici bashilikali balapanganeti bashine bakaili bonse, kwambeti kapataba naba umo eshasambe nyambwe kutampukila kutala ne kuloboka. ");
INSERT INTO sby_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Mukulene wabashilikali mwanda walikuyanda kupulushako Paulo. Pacebo ico walabakanisha ncebalikuyanda kwinsa. Lino walambila bakaili bonse bacinshi kusamba nyambwe kwambeti batangune kuliwala pamenshi benga kutala. ");
INSERT INTO sby_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Panyuma pakendi walambila nabambi bonseti baliwale pamenshi, kabali bekatilila ku mapulanga ne bintu nabimbi byalapasauka ku bwato. Umu emotwalatampukila ku mutunta ne kupuluka kwakubula kulilinga. ");
INSERT INTO sby_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Mpotwalapuluka ne kushika cena ku mutunta, bantu bakusa balatwambileti, kuno ku mutunta nkomubele nipa nsumbu ikute kukwiweti Melita. ");
INSERT INTO sby_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Bantu aba balikuba baina myoyo. Balatutambula cena, balatukunkila mulilo pakwinga kwalikuba mpepo cebo ca mfula yali kuloka. ");
INSERT INTO sby_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paulo walaya kutema muleye wankuni. Lino cindi ncalabika muleye wa nkuni uwo pamulilo, njoka yabululu yalikubamo mpoyalanyumfwa kulungula, yalasolomokamo ne kumuluma Paulo kucikasa. ");
INSERT INTO sby_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Bantu ba uko mpobalabona njoka kaili yalelela ku cikasa ca Paulo, balambeti, “Cakubinga muntuyu ni kapondo, nambi wapuluka palwenje, lesa wetu wabululami nkasuni kwambeti uyu muntu ekale ne buyumi.” ");
INSERT INTO sby_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Paulo waisansamwina pamulilo, uliya kulingwapo sobwe. ");
INSERT INTO sby_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Bantu balikuyeyeti nashimbe, nambi kufwa kwakwinsa kwalamuka. Nomba mpobalalangila kwacindi citali, ne kuboneti paliya cilenshiki pali Paulo, balambeti, “Ni lesa!” ");
INSERT INTO sby_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Capepi napo mpotwalikuba, palikuba mabala amutangunishi wapa nsumbu ya Melita walikukwiweti Pabulosi. Walatutambula ca makasa abili, twalekala nendi masuba atatu. ");
INSERT INTO sby_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Baishi Pabulosi balikuba bona kabakolwa bulwashi bwa kulungula mubili, kayi ne cinkumbe. Paulo walaya mu ng'anda mobalikuba, walapaila nekubika makasa akendi palyendibo, popelapo balasengulwa. ");
INSERT INTO sby_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Panyuma mpocalenshika ici bantu bonse balikukolwa malwashi pansumbu apa, balatatika kwisa kuli Paulo, kayi balasengulwa. ");
INSERT INTO sby_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Balatulemekesha munshila shingi. Mpotwalengila mu bwato bunene kwambeti twenga, balatubikilamo bintu nabimbi byalikuyandika pa bulwendo bwetu. ");
INSERT INTO sby_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Panyuma pakwikalako myenshi itatu, twalatanta bwato bunene bwalikufuma ku Alekisandiliya, kuntangu kwa bwato ubu kwalikuba cikoshano ya “Balesa Bampundu.” Ubu bwato bunene bwalikuba apa pa nsumbu cindi conse ca mupewo. ");
INSERT INTO sby_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Mpotwalashika ku munshi wa Sulakusa, twalekalako masuba atatu. ");
INSERT INTO sby_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Kufuma uko, twalenda ne kuya kushika ku munshi wa Legiyamu. Busuba bwalakonkapo, lukupwe lwalatatika kupupula kufumina ku musansa. Pabusuba bwatubili twalashika pa cito ca Potiyolo. ");
INSERT INTO sby_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Uko twalacanako banse abo balatusengeti, twikale nabo kwa nsondo imo. Twalatatika bulwendo bwetu bwa mapwililisho pakuya kushika ku Loma. ");
INSERT INTO sby_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Banse baku Loma mpobalanyumfweti tuli munshila, balatucinsha mpaka kushika ku musena walikukwiweti, “Cibansa camakwebo ca Apiya,” Kayi ne kumusena kwalikukwiweti, “Manda Atatu Abensu.” Paulo mpwalababona, walalumba Lesa kayi walayuminishiwa. ");
INSERT INTO sby_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Mpotwalashika ku Loma, Paulo balamusuminisha kwikala enka kalondwa ne mushilikali. ");
INSERT INTO sby_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Mpopalapita masuba atatu, Paulo walakuwa batangunishi ba Ciyuda kwambeti abandike nabo. Mpobalabungana pamo, Paulo walabambileti, “Baislayeli baname, nikukabeti paliya caipa ncondalensa kuli banse betu, nambi kutoteka miyambo ya bamashali betu bakulu kulu, Bayuda balansungisha mu Yelusalemu, ne kuntwala mu makasa aba Loma. ");
INSERT INTO sby_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Baloma mpobalanjipusha mipusho kwambeti benshibe makani ncabele, balayanda kunsungulula pakwinga baliya kucana mulandu ngondelela kufwilapo. ");
INSERT INTO sby_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Nsombi Bayuda nkabalikuyandeti ame nsungululwe sobwe, ecebo cakendi ndalasengeti Mwami Mukulene wa ku Loma kuno awomboloshe mulandu wakame. Nikukabeco ame ndiya mfundilishi ne bantu bamushobo wakame sobwe. ");
INSERT INTO sby_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ecebo cakendi ncondamukuwili kwambeti ng'ambe ne njamwe. Ame ndasungwa ncetani cebo ca muntuyo ngobalapembelelenga Baislayeli bonse.” ");
INSERT INTO sby_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Balo balakumbuleti, “Tuliya kutambulapo makalata kufuma ku Yudeya alambanga makani akobe. Kayi paliya banse betu bafuma uko kwisa kutwambila makani aipa pali njobe sobwe. ");
INSERT INTO sby_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Nomba tulayandanga kulinyumfwila tobene miyeyo yakobe, pakwinga tucinshi kwambeti kulikonse bantu balambangeti mu likoto mobele nkalilipo cena sobwe.” ");
INSERT INTO sby_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Neco balabamba busuba bumbi bwa kwisa kubandika ne Paulo, Bangi bali kwisa kung'anda nkwali kwikala. Kufuma mumene mene mpaka mansailo, Paulo wali kubasansululwila ne kubakambaukila makani a Bwami bwa Lesa. Walelekesha kubambila makani alambanga pali Yesu kwambeti bashome, pa kubambila byalembwa mu Milawo ya Mose ne mu mabuku alalembwa ne bashinshimi bakulukulu. ");
INSERT INTO sby_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Nabambi batangunishi balashoma makani ngalikwamba Paulo, nsombi nabambi baliya kwashoma sobwe. ");
INSERT INTO sby_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Lino nkapalikuba kunyumfwana cena pakati pabo, neco bapalangana Paulo mpwalamba maswi akupwililisheti, “Cakubinga Mushimu Uswepa walamba cena kupitila muli mushinshimi Yesaya, pa kwambila bamashali betu bakulukulu eti, ");
INSERT INTO sby_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","“Koya ku bantu aba ubambileti, kunyumfwa nimukanyumfwenga, nsombi nteti mukanyumfwishishenga sobwe. Kubona nimukabonenga, nsombi nteti mukabonesheshenga sobwe. ");
INSERT INTO sby_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Pakwinga bantu aba bayuma myoyo, kayi matwi ashinka, ne menso abo acalika. Necabuleco, ne balalangishisha cena, ne kunyumfwishisha cena, ne kuba ne myoyo ilayandishishinga kwinshiba kwambeti bashiye bwipishi bwabo, kwambeti Ame ndibasengule.” ");
INSERT INTO sby_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Paulo walapitilisha kubambileti, “Mwelela kwinshibeti beshikukambauka makani a lupulusho lwa Lesa, batumwa ku bantu bamishobo naimbi, pakwinga balo nibakanyumfwe!” ");
INSERT INTO sby_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Paulo mpwalapwisha kwambeco Bayuda balafumapo kabaya kutotekeshana cangofu bene bonka. ");
INSERT INTO sby_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Paulo walekala kwa byaka bibili mu ng'anda njali kusonkela, bonse bantu balikwisa kumubona wali kubatambula cena. ");
INSERT INTO sby_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Walikukambauka sha Bwami bwa Lesa, ne kubeyisha sha Mwami Yesu Klistu kwakubula buyowa, kayi paliya muntu walelekesha ku mukanisha sobwe.");
INSERT INTO sby_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Njame Paulo musebenshi wa Yesu Klistu. Lesa walankuweti mbe mutumwa, kayi ne kunsaleti nkakambauke Mulumbe wakendi Waina. ");
INSERT INTO sby_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Lesa walashomesha kupa uwu Mulumbwe Waina kupitila mu bashinshimi bakendi, kayi walalembwa mu Mabala Aswepa. ");
INSERT INTO sby_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Ukute kwamba sha Yesu Klistu Mwanendi, Mwami wetu. Na tulalanga pa buntu bwakendi, walasemenwa mu mukowa wa Dafeti. ");
INSERT INTO sby_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Nomba twalanga pa kuswepa kwakendi kwabu Lesa, kupunduka kubafu kwakendi kulaleshenga mwangofu kwambeti ni Mwanendi Lesa. ");
INSERT INTO sby_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Muli Klistu, kayi pacebo ca lina lyakendi,ame ndalatambula colwe cakuba mutumwa, kwambeti nyamfwe bantu ba mishobo yonse kumushoma ne kumunyumfwila Yesu. ");
INSERT INTO sby_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Nabambi pakati pa abo bantu, njamwe muli ku Loma, omwalakwiweti mube bakendi Yesu Klistu. ");
INSERT INTO sby_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Neco kayi ndamulembele mwense ba ku Loma, abo Lesa mbwasuni kayi ne kubakuweti babe bantu bakendi. Lesa Bata ne Mwami Yesu Klistu balamuleshe kwina moyo ne kumupa lumuno. ");
INSERT INTO sby_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Cakutanguna ndalumbunga Lesa wakame kupitila muli Yesu Klistu pacebo ca njamwe mwense, pakwinga pa cishi conse capanshi bantu balambanga sha lushomo lwenu. ");
INSERT INTO sby_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Lesa nikamboni wakame, ucinsheti ndambanga cancinencine. Nkute kumusebensela ne moyo wakame wonse, pakukambauka Mulumbe Waina ulambanga sha Mwanendi. Neco Lesa ucinsheti nkute kumuyeya cindi conse mumipailo yakame, ");
INSERT INTO sby_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","nkute kumusenga Lesa kwambeti na kayanda, ncane cindi cakwambeti njise ndimufwakashile. ");
INSERT INTO sby_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Pakwinga ndayandishishinga kwisa kumubona, kwambeti ndimuyabileko cipo ca Mushimu Uswepa, kayi ne kumuyuminisha. ");
INSERT INTO sby_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Ncendambanga nikwambeti, lushomo lwakame lukamuyuminishe ndakesa kuli njamwe, kayi ne njamwe lushomo lwenu lukanjuminishe. ");
INSERT INTO sby_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Lino mobase bame, ndamwinshibishinga kwambeti nkanjeya sha kwisa kwenu, nsombi kushikila lelo kuli bintu bikute kungalisha kwambeti njise kwenu. Ndayandangeti nkese nkapesheti bantu bangi pali njamwe, bakasandukile kuli Klistu mbuli ncendalensa ku bantu ba mishobo naimbi. ");
INSERT INTO sby_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Pakwinga nkute cikweleti cakukambaukila bantu baiya ne babula kwiya, kayi kuli bakute mano ne mbutuma. ");
INSERT INTO sby_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Weco cilankakatishinga kwisa akukambauka Mulumbe Waina kuli amwe ba ku Loma. ");
INSERT INTO sby_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Ame ndashomeshesha Mulumbe Waina, pakwinga engofu sha Lesa shikute kupulusha muntu uliyense washoma, kutatikila ne Bayuda kushikila ku bantu bamishobo naimbi. ");
INSERT INTO sby_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Uwu Mulumbe ukute kutuyubulwila bantu mobela kubela balulama pamenso a Lesa. Kufuma kumatatikilo kushikila kumapwililisho cilayandikinga nikwambeti bantu bashome. Mbuli Mabala ncalambangeti, “Muntu walulama kuli Lesa kupitila mulushomo nakabe ne buyumi.” ");
INSERT INTO sby_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Lesa layubululunga bukalu bwakendi kufuma kwilu kwisa pa bantu baipa kayi babula kululama, kwipa kwabo ekukute kubalisha kwinshiba cancine ncine ca Lesa. ");
INSERT INTO sby_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Lesa ukute kubapa cisubulo pakwinga bintu byela kwinshibikwa pali Lesa, nabo babinshi, kayi Lesa ewalabayubwilila ibi bintu. ");
INSERT INTO sby_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Pakwinga kufuma pacindi Lesa mpwalalenga cishi capanshi ne lelo pano, bantu bakute kubona bwikalo bwa Lesa butaboneke, kayi ne ngofu shakendi shitapu ne bu Lesa bwakendi. Bantu bakute kubinshiba pakubona bintu Lesa mbyalalenga, neco bantu paliyawa mpobela kuleyela. ");
INSERT INTO sby_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Lesa bamwinshi, nsombi nkabakute kumupa bulemu bwamwelela nambi kumulumba, neco miyeyo yabo yalasanduka kuba yabula ncito, Kayi mumyoyo yabo mwesulowa mushinshe. ");
INSERT INTO sby_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Nabo bakute kulibona kuba bamano, kakuli bapusa. ");
INSERT INTO sby_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Mu musena wa kukambilila Lesa wa cindi conse, balatatika kukambilila tumbwanga tukute kuboneketi muntu ukute kufwa, nambi bikeni nambi banyama, nambi tulyeti bintu bikute kukalaba. ");
INSERT INTO sby_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Weco Lesa walabaleka kwambeti bapitilishe kwinsa byaipa, ibyo myoyo yabo mbyoilandanga kushikila pakusafwanya mibili yabo. ");
INSERT INTO sby_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Balashiya cancine ncine ca Lesa ne kutatika kushoma bwepeshi. Balatatika kukambilila ne kusebensela bilengwa mucindi ca kusebensela Mulengi, kayi welela kulemekwa kushikila muyayaya. Amen. ");
INSERT INTO sby_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Pacebo ca bintu ibi Lesa walabaleka kwambeti bensenga bintu byeshikupa nsoni, bilayandanga lunkumbwa lwa mibili yabo. Nambi batukashi balalula bwikalo bwa kona ne batuloba ne kutatika konana bonkabonka. ");
INSERT INTO sby_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Kayi nabo batuloba balalula bwikalo bwa kona ne batukashi ne kutatika kuba ne lunkumbwa lwa konana ne batuloba banabo. Balensa bintu byeshikupa nsoni. Pacebo ici balalitelenga bene cisubulo celela micito yabo yaipa. ");
INSERT INTO sby_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Pakwinga balaciboneti nkacelela kuba ne lwinshibo lwesulila lwa ncinencine lwa Lesa, weco nendi Lesa walabaleka ne miyeyo yabo yaipa, yakwinsa bintu byeshikupa nsoni. ");
INSERT INTO sby_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Myoyo yabo yalesula ne kutalulama kwapusana pusana, mbuli kwipa ne bukuma ne bukapondo ne lukanda. Kayi myoyo yabo yesula ne kubepana ne minyono ne kwinshila banabo byaipa. Kayi ne kunung'unusha, ne bufwishi, ");
INSERT INTO sby_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","kayi ne kwambana kwipa umo ne munendi, neco bakute kupatana ne Lesa, bamatuka beshikutwanga ne kulibonesha.Kayi bakute kuyeya nshila sha kwinsa byaipa, baliya bulemu ku bamashali babo. ");
INSERT INTO sby_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Nibantu batalisende, babula kushomeka baipa myoyo kayi babula nkumbo. ");
INSERT INTO sby_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Bawinshi mulawo wa Lesa wakwambeti bantu beshikwinsa bintu byamushoboyo belela kufwa. Necikabeco nabo ebakute kubinsa, kayi ebakute ne kulumbaisha abo balabinshinga. ");
INSERT INTO sby_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Lino obe weshikombolosha banobe, na njobe bani, uliya pakuleyela sobwe. Pakwinga pacindi mpolomboloshonga munobe ukute kulitoteka wenka, pakwinga nenjobe weshikombolosha ukute kubinsa bintu ibyo. ");
INSERT INTO sby_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Tucinsheti Lesa walulama pakombolosha bantu beshikwinsa bintu byamushoboyo. ");
INSERT INTO sby_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Nomba obe muntususu, okute kombolosha bantu bambi beshikwinsa bintu ibi, pakwinsa bintu ibi, sena ukute kuyeyeti nukakuleye kombolosha kwa Lesa? ");
INSERT INTO sby_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Sena ulapubishinga kwina moyo kunene kwa Lesa ne kutakalala bwangu ne moyonteka wakendi? Sena nkocinsheti Lesa lakwinshilinga nkumbo kwambeti usanduke kufuma kubwipishi bwakobe? ");
INSERT INTO sby_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Pakwinga moyo wakobe wayuma kayi nkausanduku, nukatambule cisubulo ca Lesa. Cisubulo ico nicikakuwile pabusuba mboshakaleshe bukalu bwakendi ne kombolosha kwakendi kwalulama. ");
INSERT INTO sby_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Lesa nakabweshele uliyense kwelana ne incito shakendi. ");
INSERT INTO sby_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Bantu balapitilishinga kwinsa byaina ne balalangaulunga bulemu ne bulemeneno bwa Lesa ne buyumi butapu, balenshingeco, neye Lesa nakabape buyumi butapu. ");
INSERT INTO sby_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Nomba bantu bakute kwinsa bintu mbyobasuni ne kukana kwinsa byalulama ne kukonkela byaipa, Lesa nakabape cisubulo mubukalu bwakendi. ");
INSERT INTO sby_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Mapensho ne makatasho nakabawile beshikwinsa byaipa, kutatikila Bayuda kushikila ne kubantu ba mishobo naimbi. ");
INSERT INTO sby_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Nsombi Lesa nakabape bulemu ne bulemeneno ne lumuno bonse beshikwinsa byaina, kutatikila Bayuda kushikila ku bantu bamishobo naimbi. ");
INSERT INTO sby_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Pakwinga Lesa nkakute kusalaula. ");
INSERT INTO sby_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Bantu ba mishobo naimbi balabula kwinshiba Milawo ya Mose, ne kwinsa bwipishi, naboyo nibakonongeketi bantu babula kwinshiba Mulawo. Nomba abo Bayuda balepisha kabalibenshiba Milawo ya Mose nibakomboloshewe kwelana ne Mulawo, ");
INSERT INTO sby_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Pakwinga bantu balulama pamenso a Lesa ntebo bakute kunyumfwowa Milawo sobwe. Nsombi bakute kwinsa mbuli Mulawo nceulambanga. ");
INSERT INTO sby_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Naboyo bantu babula kuba Bayuda babula Mulawo, nsombi na balenshi mbuli Milawo ncoikute kwamba palwabo bene, bakute kulesheti bakute Milawo mumyoyo yabo, nambi baliya Milawo ya Mose. ");
INSERT INTO sby_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Bwikalo bwabo bukute kulesheti Milawo yalembwa mumyoyo yabo. Kayi myoyo yabo ikute kulesheti nicakubinga, pakwinga mengashilo abo nacimbi cindi akute kubatoteka kayi ne kubasuminisha. ");
INSERT INTO sby_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Mbuli Mulumbe Waina ngonkute kukambauka nicikabe mushoboyo pabusuba Lesa mposhakomboloshe bantu kupitila muli Yesu Klistu pali ibyo byasolekwa mbyobakute kuyeya bene. ");
INSERT INTO sby_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Nomba lino obe ukute kulyambeti o Muyuda wacinkila manungo mu Milawo, kayi ukute kulisumpula muli Lesa wakobe. ");
INSERT INTO sby_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Ucinshi ncalayandanga Lesa kwambeti winse, kayi waleishiwa mu Milawo, kusala byaina nambi byaipa. ");
INSERT INTO sby_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Washometi njobe mutangunishi wa bantu bashipilwa, mumuni weshikumunikila bantu bali mumushinshe, ");
INSERT INTO sby_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","kayi njobe shikwiyisha baluya ne bantu batacinshi. Washometi mu Milawo muli lwinshibo lwa bintu byancine ncine byonse. ");
INSERT INTO sby_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Nomba obe shikwiyisha banobe, nicani nkokute kuliyisha omwine? Obe shikukambauketi, “Kwiba sobwe.” Nicani obe ukute kwiba? ");
INSERT INTO sby_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Nomba uleishingeti, “Nkamwelela kwinsa bupombo.” Nicani obe ulenshinga bupombo? Wapela kukambilila tumbwanga, nomba kayi nicani ukute kuya mu ng'anda kuya kwibamo tumbwanga? ");
INSERT INTO sby_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ukute kulisumpuleti nkute Milawo ya Lesa, nomba nicani ulapanga nsoni Lesa pakupwaya Milawo? ");
INSERT INTO sby_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Mbuli Mabala ncakute kwambeti, “Bantu bamishoboyo naimbi bakute kunyansha Lesa pacebo ca njamwe Bayuda.” ");
INSERT INTO sby_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Na ukute kukonka Milawo ya Mose kupalulwa kwakobe kulicena. Nomba na nkokute kukonka Milawo caina kwambeti wikale kwakubula kupalulwa. ");
INSERT INTO sby_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Nomba na muntu wabula kupalulwa lakonkonga Milawo ya Mose, sena muntuyu pamenso a Lesa nteshakabeti muntu wapalulwa, necikabeti nkapalulwa? ");
INSERT INTO sby_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Weco muntu wabula kupalulwa ukute kukonka Milawo endiye weshi akamutoteke amwe Bayuda mwapalulwa kayi mukute Milawo yalembwa, nsombi mukute kwipwaya. ");
INSERT INTO sby_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Bintu ibi bilaleshengeti Muyuda mwine nteyo lalileshenga kubantu eti ni Muyuda sobwe. Kayi kupalulwa kwancine ncine nteko nkobakute kwinsa kumubili sobwe. ");
INSERT INTO sby_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Neco, Muyuda mwine ni uyo Muyuda mumoyo, kayi kupalulwa kwakendi nikwamumoyo kweshikwinshika ne Mushimu Uswepa, kwakubula Milawo sobwe. Weshikulumba muntu wa mushoboyo nte muntu sobwe nsombi ni Lesa. ");
INSERT INTO sby_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Sena mulayeyengeti Bayuda bapita bantu ba mishobo naimbi? Ninga kupalulwa kukute pindu cini? ");
INSERT INTO sby_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Pali bwinishi bunene pakuba Muyuda, pakwinga pakutanguna Lesa walapa Bayuda maswi akendi kwambeti basungenga. ");
INSERT INTO sby_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Nomba nabambi pakati pabo nkabalashomeka, sena kubula lushomo kwabo ngakupesheti Lesa abule kushomeka? ");
INSERT INTO sby_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Sobwe, ico nkacela kwinshika! Lesa abe wakubinga, necikabeti bantu bonse nibandemishibili. Mbuli Mabala ncakute kwambeti, “Amwe Lesa, lekani bantu bonse benshibeti mukute kwamba cakubinga, Kayi cindi conse mukute kucaniketi muliya kampenda pakukombolosha.” ");
INSERT INTO sby_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Lino na kwipa kwetu kulaleshengeti Lesa walulama, ngatwambeconi? Sena ngatwambeti Lesa nkalulama pakutupa cisubulo? Ndambanga mbuli bantu nabambi ncobakute kwamba. ");
INSERT INTO sby_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Sobwe, Lesa nalabula kuba walulama, sena nalakombolosheconi bantu bonse bapacishi capanshi? ");
INSERT INTO sby_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Nabambi ngabambeti, “Nakubepa kwakame kulaleshenga patuba kushomeka kwa Lesa ne kukonempesha bulemeneno bwakendi, nomba ngaung'ombolosheconi eti nkute bwipishi?” ");
INSERT INTO sby_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Lino nicani ncotwelela kwambileti “katwinsani byaipa kwambeti byaina biboneke?” Cakubinga bantu nabambi balatutukananga pakwambeti, tulamba makani awa. Bantu aba Lesa nakabape cisubulo celela. ");
INSERT INTO sby_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Nomba lino sena afwe Bayuda twapita bantu ba mishobo naimbi? Sobwe! Tulapandululu kendi kwambeti bonse balepisha, Bayuda pamo ne bantu ba mishobo naimbi. ");
INSERT INTO sby_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Pakwinga Mabala akute kwambeti, “Paliya muntu walulama, sobwe naba umo kuliya. ");
INSERT INTO sby_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Kuliya muntu ukute kunyumfwishisha, kuliyawa muntu lalangaulunga Lesa. ");
INSERT INTO sby_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Bantu bonse basula Lesa, kayi bonse basendama, paliya shikwinsa byaina, sobwe kuliya naba umo. ");
INSERT INTO sby_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Kwamba kwabo nikwakubepa, kayi kukute kushinisha. Milaka yabo ikute kwamba byakubepa kayi mumilomo yabo mukute kufuma maswi aipa aipa eti mata anjoka. ");
INSERT INTO sby_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Mumilomo mwabo mwesula mashingo, mukute kufuma maswi aipa. ");
INSERT INTO sby_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Nibantu bakute kufwambana kulinga ne kushina banabo. ");
INSERT INTO sby_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Bakute kononga ne kupensha bantu kulikonse nkobalayi, ");
INSERT INTO sby_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","kayi nkabacinshi kwikala mulumuno. ");
INSERT INTO sby_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Nkabakute kutina Lesa nambi pang'ana sobwe.” ");
INSERT INTO sby_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","“Lino tucinshi kwambeti byonse byambwa mu Milawo ya Lesa, bikute kwamba pali abo balakonkelenga Milawo kwambeti bantu bonse pa cishi capanshi bakabule pakuyubila milandu Lesa njeshakabape. ");
INSERT INTO sby_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Pakwinga kuliyawa muntu Lesa ngwakute kubona walulama pacebo ca kukonkela Milawo. Mulawo ukute kutulesheti bantu bonse balepisha.” ");
INSERT INTO sby_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Nomba lino nshila ilaboneke yakucaninamo bululami pamenso a Lesa, nteyo yakukonkela Milawo sobwe. Milawo iyo niya Mose ne bashinshimi bakute kuyinshila bukamboni. ");
INSERT INTO sby_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Nshila bantu njobakute kucaninamo bululami pamenso a Lesa nikushoma Yesu Klistu. Lesa eukute kululamika bantu bashoma Yesu Klistu, pakwinga kuliya bupusano pakati pa bantu bonse. ");
INSERT INTO sby_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Bantu bonse balepisha, kayi balalilwa kushika ku bulemeneno bwa Lesa. ");
INSERT INTO sby_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Nsombi kwinamoyo kwakendi Lesa kwabulyo, bantu balulamikwa kupitila muli Klistu Yesu uyo walabalubula. ");
INSERT INTO sby_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Lesa walamubengeti abe mulumbo kwambeti lufu lwakendi, lulesheti Lesa walulama uliyawa kubapa cisubulo abo balepisha mucindi cakunyuma ");
INSERT INTO sby_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","pacebo cakuba ne moyonteka. Nomba pacindi cino Lesa walabenga Yesu kwambeti aboneshe kululama kwakendi, ne kwambeti benshibeti nendi walulama, kayi uliyense washoma Yesu ukute kuba walulama pamenso a Lesa. ");
INSERT INTO sby_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Nomba sena lino muntu ngolitukumuna? Sobwe, nkela kulitukumuna. Pacebo cini? Sena nipakukonkela Milawo? Sobwe, nsombi kushoma. ");
INSERT INTO sby_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Neco lino tulabono kwambeti muntu ukute kuba walulama pamenso a Lesa na lashomo, nteko kukonkela Milawo sobwe. ");
INSERT INTO sby_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Sena Lesa ni Lesa wa Bayuda bonka? Sena ntendiye kayi Lesa wa bantu ba mishobo naimbi? Cakubinga endiye Lesa wa bantu ba mishobo naimbi. ");
INSERT INTO sby_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Lesa ni umo, neco endiye ukute kululamika Bayuda kupitila mulushomo kayi nabo bantu bakunsa bakute kuba balulama kupitila mulushomo. ");
INSERT INTO sby_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Sena ici cilambangeti Milawo iliyawa ncito pakwambeti nikupitila mulushomo? Sobwe! Empotulaiyumishinga Milawo. ");
INSERT INTO sby_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Nomba twambe cani afwe Bayuda pamushali wetu Abulahamu? Nibyani mbyalacana mubuyumi bwakendi? ");
INSERT INTO sby_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Na walalulamikwa ne Lesa kupitila mubintu mbyalensa, nshinga nalacana pakulitukumunina. Nomba liya kulitukumuna pamenso a Lesa sobwe. ");
INSERT INTO sby_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Nomba Mabala alambangaconi? Akute kwambeti “Abulahamu walashoma Lesa, kayi mpwalashoma, Lesa walamubona kwambeti walulama.” ");
INSERT INTO sby_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Muntu asebensa ncito, ukute kutambula malipilo. Nomba nteko kwambeti ni cipo sobwe, nsombi tukute kwambeti embyelela kutambula pacebo ca ncito yakendi. ");
INSERT INTO sby_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Muntu lashomo kwakubula kushimpila mu ncito shakendi ne kushoma muli Lesa, Lesa eukute kumuboneti nimuyawu, ulu elushomo Lesa ndwakute kulangaula kwambeti abe walulama pamenso akendi. ");
INSERT INTO sby_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Nendi Dafeti walamba copeleco pacindi mpwalambeti ukute colwe uyo Lesa ngwalasuminisheti walulama kwakubula pacebo cabintu mbyalenshi.Walambeti, ");
INSERT INTO sby_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Bakute colwe bantu Lesa bwalalekelela bwipishi bwabo, Abo mbwalashimanganya bwipishi bwabo, ");
INSERT INTO sby_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Ukute colwe muntuyo Mwami ngweshakabule kubelengela bwipishi bwakendi.” ");
INSERT INTO sby_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Sena colwe ici nica bantu bapalulwa bonka nambi ne babula kupalulwa? Sobwe naboyo babula kupalulwa nikwabo. Pakwinga Mabala ngotulambapo alambangeti, “Abulahamu walashoma Lesa, lino mpwalashoma walacanika kwambeti walulama pamenso a Lesa.” ");
INSERT INTO sby_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Nomba ibi byalenshika lilyoni? Sena nipacindi mpwalapalulwa nambi katana? Nkabyalenshika mpwalapalulwa sobwe nsombi nkatana apalulwa. ");
INSERT INTO sby_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Kupalulwa kwalenshika panyuma pakendi, kwambeti cikabe cishibisho cebo calushomo lwakendi nambi nkalikuba wapalulwa, nsombi walacanika kwambeti walulama pamenso a Lesa mpwalashoma. Neco Abulahamu nimushali wabo bonse bashoma Lesa, kayi Lesa ukute kumubona kuba muntu walulama nambi nkapalulwa. ");
INSERT INTO sby_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Kayi ni mushali wa bonse bapalulwa, kutamba bonka bapalulwa mumubili monka, nsombi uyo ukute kukonka citondesho ca lushomo lwa mushali wetu Abulahamu nkatana apalulwa. ");
INSERT INTO sby_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Abulahamu ne bashikulu bakendi balatambula cishomesho cakwambeti cishi capanshi nicikabe cabo. Balatambula cishomesho ici, nteko kupitila mukukonkela Milawo sobwe, nsombi pacebo ca kululama kulafumunga mulushomo. ");
INSERT INTO sby_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Neco na cishomesho ca Lesa nicikapewe kuli balakonkelenga Milawo, ekwambeti lushomo luliyawa ncito kayi ne cishomesho ca Lesa nicabulyo. ");
INSERT INTO sby_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Milawo ikute kuleta bukalu bwa Lesa, nsombi kwabula Milawo kuliyawa kayi ne kwipwaya. ");
INSERT INTO sby_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Neco cishomesho calapewa kupitila mulushomo, kwambeti cibe cipo ca Lesa ncalalaya kuli bonse bashikulu ba Abulahamu ntebo bonka balakonkelenga Milawo, nsombi ne kuli bashoma mbuli Abulahamu ncalensa, pakwinga Abulahamu ni mushali wetu twense. ");
INSERT INTO sby_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Pakwinga Mabala alambangeti, “Ndakubiki kwambeti ube mushali wa mishobo ingi ya bantu.” Cishomesho ici Abulahamu walacitambula kuli Lesa ngwalikuba washoma. Endiye Lesa ukute kubweshela buyumi kubantu bafwa, kayi kupitila mu maswi akendi ukute kupesheti bintu byabulapo bibepo. ");
INSERT INTO sby_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Lesa walambeti, “bashukulu bakobe nibakafule.” Neco nendi walapitilisha kushoma ne kukabeti nkabyalikuba bintu byeshibikwa, weco nendi walaba mushali wa mishobo ingi ya bantu. ");
INSERT INTO sby_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Byaka byakendi byalikuba byakwana pepi mwanda. Nomba lushomo lwakendi luliya kulefuka nambi mubili wakendi walabeti wafwa cebo cakucekula. Neye Sala walikuba wayuma palibunda. ");
INSERT INTO sby_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Nendi uliya kutaya lushomo kayi nkalacitonshanya cishomesho ca Lesa sobwe, nsombi walapitilisha kushoma ne kulumbaisha Lesa. ");
INSERT INTO sby_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Walashomeshesha kwambeti Lesa nakacikonshe kwinsa bintu mbyalamushomesha. ");
INSERT INTO sby_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Weco, mbuli maswi a Lesa ncalambilingeti, “Lesa walamubona kuba walulama.” ");
INSERT INTO sby_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Mabala alambangeti, “Lesa walamubona kwambeti walulama,” Nkalambanga shakendi enka sobwe. ");
INSERT INTO sby_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Nsombi alambanga kayi pali njafwe tweshi tukacaniketi twalulama pakushoma Lesa, uyo walapundusha Yesu Mwami wetu kubafu. ");
INSERT INTO sby_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Yesu walabengwa kwambeti afwe pacebo ca bwipishi bwetu, kayi walapunduka kubafu kwambeti tube balulama pamenso a Lesa. ");
INSERT INTO sby_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Nomba lino pacebo ca kushoma tulaba balulama pamenso a Lesa, ekwambeti twekala mu lumuno ne Lesa kupitila muli Mwami wetu Yesu Klistu. ");
INSERT INTO sby_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Uyo nendi endiye walatucalwila nshila, kwambeti na tulashomo tukenshibe kwina moyo kwa Lesa, umo emotwekalikana lino. Neco twakondwa pakupembelela kwetu kwambeti tukatambule bulemeneno bwa Lesa. ");
INSERT INTO sby_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Nteco conka ici sobwe, tukute kukondwa mumapensho etu. Pakwinga tucinsheti mapensho akute kwiyisha kutatyompwa, ");
INSERT INTO sby_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","kutatyompwa kukute kuleta bwikalo bwasuminishiwa ne Lesa, kayi bwikalobo bwasuminishiwa bukute kuleta kupembelela. ");
INSERT INTO sby_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Kupembelela uku nkakukute kutunyumfwisha nsoni sobwe, pakwinga Lesa walatupa Mushimu Uswepa ukute kwisusha myoyo yetu ne lusuno lwakendi. ");
INSERT INTO sby_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Pacindi mpotwalikuba mubwipishi kayi katuli twabula ciliconse, pacindi Lesa ncalabambilalimo Klistu walafwila. ");
INSERT INTO sby_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Nicapatali muntu kufwila muntu walulama. Nambi kwambeti muntu uyumisha moyo mpaka kufwila muntu waina. ");
INSERT INTO sby_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Nsombi nendi Lesa watulesheti utusuni, pakwinga pacindi mpotwalikuba mubwipishi Klistu walatufwila. ");
INSERT INTO sby_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Weco, pakucanika kwambeti njafwe balulama pamenso a Lesa, cebo ca milopa yakendi Yesu Klistu, nendi nakatupulushe ku bukalu bwa Lesa. ");
INSERT INTO sby_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Afwe twalikuba balwani ba Lesa, nsombi lufu lwa Mwanendi elwalatubwesha mubwanse nendiye. Neco mpotuli banendi Lesa twashoma kwambeti nakatupulushe kupitila mubuyumi bwa Klistu. ");
INSERT INTO sby_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Nsombi nteco ici conka sobwe, tukute kukondwa pacebo ncalensa Lesa kupitila mu Mwami wetu Yesu Klistu uyo walapesheti tubweshane m