﻿USE sofia;
DROP TABLE IF EXISTS sofia.sbs_vpl;
CREATE TABLE sbs_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES sbs_vpl WRITE;
INSERT INTO sbs_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Imbuka ya luzuvo lwa Jesu Kereste mwana wa Daafita mwana wa Abrahama. ");
INSERT INTO sbs_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahama a vali nji si wa Isaka, ni Isaka isi wa Jakobo, ni Jakobo isi wa Juda ni vance. ");
INSERT INTO sbs_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda a vali njisi wa Perezi ni Zera cha Tama, Perezi isi wa Hezironi, ni Hezironi isi wa Ramu. ");
INSERT INTO sbs_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ramu a vali njisi wa Amminadab, Amminadab isi wa Nahshoni, ni Nahshoni isi wa Salumoni. ");
INSERT INTO sbs_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salumoni ivali nji si wa Boazi cha Rahaba, Boazi isi wa Obedi cha Ruti, Obedi isi wa Jesse, ");
INSERT INTO sbs_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesse a vali nji si wa Daafita simwine. Daafita a vali njisi Solomoni cha mwihyavwe wa Uriya. ");
INSERT INTO sbs_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomoni a vali nji si wa Rehoboamu, Rehoboamu isi wa Abijah, Abijah isi wa Asa. ");
INSERT INTO sbs_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa a vali njisi wa Josafati, Josafati isi wa Joramu, ni Joramu isi wa Uzziah. ");
INSERT INTO sbs_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzziya avali njisi wa Jotamu, Jotamu isi wa Ahazi, Ahazi isi wa Hezekiya. ");
INSERT INTO sbs_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiya a vali njisi wa Manasseh, Mannasseh isi wa Amoni, ni Amoni isi wa Josiyah. ");
INSERT INTO sbs_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiya avali njisi wa Jekoniya ni vanche he nako i vavaka luwitwe kwa Bavilona. ");
INSERT INTO sbs_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Mi kuzwa ha kuka luwiwa kwa Babilona, Jekoniya a vali njisi wa Salatiele, Salatiele a vali muzimu wa Zerubabele. ");
INSERT INTO sbs_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabele a vali njisi wa Abiudi, Abiudi isi wa Eliyakimu, ni Eliyakimu isi wa Azoro. ");
INSERT INTO sbs_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azoro a vali njisi wa Zadoki, Zadoki isi wa Akimu, ni Akimu isi wa Eliudu. ");
INSERT INTO sbs_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudi avali nji si wa Eliyazere, Eliyazere isi wa Matani, ni Matani isi wa Jakobo. ");
INSERT INTO sbs_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jokobo avali nji si wa Josefa mwihyabwe wa Maria, kakwe Jesu na zalwa, yo sumpwa Keresite. ");
INSERT INTO sbs_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Mahasi onse ku zwa kwa Abrahama ku ya kwa Daafita a vali mahasi ena ikumi lyonke ni one, kuzwa kwa Daafita kuya ha vaka luwiwa kwa Babilona ku leta kwa Keresite avali masika ena ikumi lyonke ni one. ");
INSERT INTO sbs_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ku zalwa kwa Jesu Keresite kuva chitahali mu nzila i chilila. Inyina, Maria, ava veelezwe kuti a seswe kwa Josefa, kono pili ni vaseni kwiza hamwina, ava waniki ha menzi mahya cha Luhuho lu Jolola. ");
INSERT INTO sbs_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Mwihyavwe, Josefa, avali mukwane yo shiyeme, kono kana a vali kusaka ku shuvulisa mwihyabve iñandaleza. Cwale cha nahana ku manisa che nkunutu ku li veereza kwaakwe naye. ");
INSERT INTO sbs_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Havali kusi nahana cezi zintu, Iñeloi lya Ireza ni lya livonisa kwali mu chiloto, liti, “Josefa, mwana wa Daafita, kanji u tiyi to hinda Maria kuva muhwenu, kakuli yo lihinditwe kwali avali ku lihindwa cha Luhuho lu Jolola. ");
INSERT INTO sbs_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mwa zale mwana' mushisu, mi momu ulike izina lya Jesu, mukuti ka puluse vantu vakwe ku zivi zavo.” ");
INSERT INTO sbs_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Izo zonse zi va pangahali kwi zuziliza chiva wambiwa kwa Simwine cha muporofita, nati, ");
INSERT INTO sbs_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“ Mu vone, mwalyango mwave ha menzi mahya, mi mwa zale mwana' shwisu, mi mu va mu sumpe izina lyakwe Imanuere”- i talusa, “Ireza wina neswe.” ");
INSERT INTO sbs_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josefa ha vuka ku ñonzi zakwe ni ku chita ka kuya ke Iñeloi lya Simwine muli va mu laeli mi ca mu hinda kuva mwihyavwe. ");
INSERT INTO sbs_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kono kana aba lali naye konji ha zala mwana' mushisu. Mi ava mu sumpisi izina lya Jesu. ");
INSERT INTO sbs_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesu hamana kuzalwa mwa Betelehema ya Judea mwi nako za simwine Heroda, vakwame valitutite vazwa kuvuzwe zuba civeza mwa Jerusalema, ");
INSERT INTO sbs_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Wina kuhi yava zalwa simwine wa Majuda? kakuti twavona inkani yakwe kuvuzwe bwe zuva, twakeza kukumu fukamina”. ");
INSERT INTO sbs_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Simwine Heroda hazuwa catiya ahulu mane nivantu vamwa Jerusalema vonse. ");
INSERT INTO sbs_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Heroda ca supa ma Purisita vonse ni vañoli va mulao mi cava vuza nati, “Kriste uswanela kuzalilwa kuhi”? ");
INSERT INTO sbs_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Civamuco kuti Mwa Bethelehema wa Judea, kakuti muvava ñoleli va porofita, ");
INSERT INTO sbs_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Iwe, Bethelehema, mwinkanda ya Juda, kana umunini kuvayendisi va Juda, mukuzwe muyendisi yete a alise cisi ca Isilaele”. ");
INSERT INTO sbs_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Cwale Heroda ca sumpila va litutite kumbali nikuva vuza kuti inkani yavoneka inakonzi luli. ");
INSERT INTO sbs_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Cavatuma kwa Bethelehema nikuvata kuti “muyende mukasakisise ce ntokomero muhwile, cimwaka muwana, zemuniizibise name zeniyende nikamu fukamine.” ");
INSERT INTO sbs_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Havamana kuzuwa kwa simwine, civaliyendeza mi inkani ivava voni kuvuzwezuva ciyava yenda kuvusu nikuka zimaninina hewulu lye civaka mwa vali kwikere mucice. ");
INSERT INTO sbs_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Hava vona inkani civa sanga ahulu cokuhitiriza. ");
INSERT INTO sbs_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Habenjila mwinzuvo civa vona mucice nena ni Maria nyina. Civa fukama nikumu lapera. Civavungununa cifumu cavo nikumuha impo ze gauda, ni insense, ni mira. ");
INSERT INTO sbs_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ireza cava kalimera muciloto kuti sanzi vaboli kwa Heroda, mi civavola kwi nkanda yavo cenzila ingi. ");
INSERT INTO sbs_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Hava yenda, iñiroi lye Ireza cilye zira Josefa kwi ñonzi mi cilyati, “vuke uhinde mucice niva nyina, mutirire kwa Egepita, muke kale kwateni kusikira hete nini kuwambile, kakuti Heroda mwasake mucice kuti a mwi haye.” ");
INSERT INTO sbs_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","A o masiku Josefa cavuka nikuhinda muhwire niva nyina niku tilira kwa Egepita. ");
INSERT INTO sbs_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ava kekali kwa Egepita kusikira he fu lya Heroda. Ici ci be zuzilizi civa wambwa nji Ireza camu porofita, “kuzwa mwa Egepita niva sumpi mwangu wo muswisu.” ");
INSERT INTO sbs_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Cwale Heroda havona kuti vakwame va litutite vavamucengi, cavenga ahulu. avatumini vantu kuti vake haye vahwile vonse veciswisu mwa Bethelehema, mane nimucilalo conse civehaya vahwile ve zilimo zo vere kuzwa hakuzalwa kuvoza hansi, cokuya ce inako yava lakalezi kuzwa havava mu wambilili va kwame va litutite. ");
INSERT INTO sbs_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Mi cikwalizuziliza civa wambiwa ca muporofita Jeremia, ");
INSERT INTO sbs_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Linzwi li vazuweki mwa Rammah, cililo ni kuvokolola kukando, Rahele ulilira vana vakwe ukana mane nikutontozwa kakuti kavasikwina.” ");
INSERT INTO sbs_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Hafwa Heroda, Ingiloi lya Ireza cilyeza kuvoneka kwa Josefa muciloto mwa Egepita ni kumuta, ");
INSERT INTO sbs_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Vuke hinde mwana niva nyina mi uyende kwi nkanda ya Isilaele, kakuti vavali kusaka kwi haya mucice ci vavafwi.” ");
INSERT INTO sbs_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Josefa ca vuka ni kuhinda muhwire niva nyina civeza mwinkanda ya Isilaere. ");
INSERT INTO sbs_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","kono hazuwa kuti Arkelausi avali ku vusa mwa Judea ha cipula cesi Heroda, ava tiyi kuya kwateni. mi Ireza camukalimera muciloto, cayenda kwi nkanda ya Galileya ");
INSERT INTO sbs_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","mi cayenda mi cakekala mucivaka cisupwa Nazareta. I ci cibezuzilizi civawambiwa cava Porofita, kuti mwa supwe mu Nazareta. ");
INSERT INTO sbs_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ku mazuba ao Joani mukolobezi chakeza na kutaza mwi halaupa ya Judea nata kuti, ");
INSERT INTO sbs_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Mubake ka kuli mubuso we renza wina ha fuhi.” ");
INSERT INTO sbs_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ka kuli linzwi ni lya wambwa ngi mupolofita Isaya, halili, “Linzwi yo zumwi li huweleza mwi halaupa, 'mulukise enzila ye renza, mupange enzila zi wotolokete.'” ");
INSERT INTO sbs_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yahanu Joani u zabala cizabalo zo boza bwe ka mele ni lutunga lwe ndalo mwi muunda. Zilyo za kwe baili epasu ni buchi bo mwi munkanda. ");
INSERT INTO sbs_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Cwale Jelusalema, Judeya yose ni nkanda yose bo mumukulela wa lwizwi lwa Joludani ci bayenda kwali ");
INSERT INTO sbs_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Cibeza ku kolobezwa kwali mu lwizwi lwa Jolundani, a bo ni baliwaba zibi za boo. ");
INSERT INTO sbs_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kono ha bona bungi bwa bafalisi ni masaduki ba keza kwali kwi i nkolobezo, ca ba wambila, “Enwe bana be nzoka zina cifanu, aba mulwili kutiya bukali bwe renza bu keza njeni? ");
INSERT INTO sbs_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Cwale mubike zihantu zi bonisa kubaka. ");
INSERT INTO sbs_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Cwale musiye kuzeza kuli wanbila mukati kenu,'Twina Abulahama ishetu.' Cwale ni milwila kuti irenza uo wola kukatwila Abrahama bahwile ha aa mabwe. ");
INSERT INTO sbs_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Hanu imbezo izimene ku mihisi ya masamu. Cikuni conse ci sabiki zihantu zilotu mu citemwene hansi ni ku sohelwa mu mulilo. ");
INSERT INTO sbs_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ni mi mikolobeza ni mezi kubonisa kubaka. Kono iye u kezite mu masule angu mukando kwa ngu, ka ni swaneli nanga ku nyemuna insangu zakwe. Mwa mi kolozebe ni luhuho lu jolola ni mulilo. ");
INSERT INTO sbs_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Itundu lyakwe lina mwi yanza lya kwe; mwa fiyele cihoto cakwe, a ku kunganye mahila akwe mu cishete cakwe. Luungu ulo, a luhise mu mulilo u sa zimi. ");
INSERT INTO sbs_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Cwale Jesu ha zwa mwa Galilela ku ya ku lwizi mwa joludani ku ku kolobezwa kwa Joani. ");
INSERT INTO sbs_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kono Joani ca tundamena kumu kanina, nati, “Njeme ni swanela ku kolobezwa kwa ko, ukeza kwa ngu?” ");
INSERT INTO sbs_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesu ca mwi taba, “Uni zuminine hanu ci lukite kwetu kwizuziliza ku luka konse.” Cwale Joani ca mizuminina. ");
INSERT INTO sbs_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ha mana ku kolobezwa, Jesu ca zwa haho mumenzi, haho i wulu cilye yalukila ha kwe. Ca bona luhuho lwe renza lu keza hansi luswana sina inkwilimba ni kwi za ku munikila hewulu lwakwe. ");
INSERT INTO sbs_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Haho, liinzwi cilya zwa muwulu li ta kuti, “Uzo nji Mwanangu yo sakiwa, u ni katwa.” ");
INSERT INTO sbs_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Lyahanu Jesu ca kashiwa ku luhuho lu jolola kuya mwi halaupa ku ku likiwa kwa Jabulusi. ");
INSERT INTO sbs_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Halinyima zilyo mazuva ena makumi one ni masiku ena makumi one, ca fwa inzala. ");
INSERT INTO sbs_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Muliki neza kuwamba kwali, “Haiva u mwana we Ireza, u laele aa mabwe a sanduke zilyo” ");
INSERT INTO sbs_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mi Jesu ne tava cati kwali, “ku ñoletwe, 'Muntu kete na hale ca zilyo vulyo, kono ni ca liinzwi li zwa mukaholo ka Ireza'” ");
INSERT INTO sbs_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Linu Javulisi ca mu hinda kumu twala he wulu lwa muzako ujolola uva ketiwa we nkereke mulelele, ");
INSERT INTO sbs_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ni ku mu wamvila kuti, “Haiva njewe u mwana wa Ireza, uwile hansi kakuli ku ñoletwe, ka laele mañeloi akwe mu aku vavalele, mu aku nyamune mu mayanza nji kuti itende lyako kanji li gunkiwa ibwe ");
INSERT INTO sbs_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesu nati kwali, “Hape u ñoletwe, Kanji u liki infumwako Ireza. ");
INSERT INTO sbs_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","“Hape Javulusi na mu hinda kumu twala he lundu lilumbite, ni kumu tondeza mileneñi ina munkanda yonse ni nkanya yayo. ");
INSERT INTO sbs_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nati kwali, “Zonse izi zintu kani zikuhe, ci wa wila hansi ca mazwi. uni fukamine uni lapele” ");
INSERT INTO sbs_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Linu Jesu ca muta, “U zwe aha Javulusi! kakuli ku ñoletwe, “U fukamine Ireza i nfumwako, imi u seveleze iye yeke” ");
INSERT INTO sbs_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Javulusi ca musiya; mi mañeloi ci eza kwa Jesu, ci a mu seveleza. ");
INSERT INTO sbs_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Haho linu Jesu ca zuwa kuti Joani avva suminwa, na vola kwa Galilea; ");
INSERT INTO sbs_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ca kuula kwa Nazareta ku ka zaka kwa Kapenauma, i wanika kumbali ni wate lya Galilea, mu cilalo ca Zevuloni ni Nafitali. ");
INSERT INTO sbs_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Izi ziva pangahali kwi zuziliza ci polofita ca Isaya ha vati, ");
INSERT INTO sbs_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Inkanda ya Zavuloni ni nkanda ya Nafitali i vambene ni wate, mwi shilwa lwa Jodani, Galilea ya vantu vasena vavezi Ireza; ");
INSERT INTO sbs_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Vantu va vena mwififi, va va voni iseli ikando; linu va vena munkanda yefu ni mumu nzunde walyo, vava ñaatwilwa iseli” ");
INSERT INTO sbs_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kuzwa iyo nako Jesu na tanga ku kutaza nati, “Mu vake, mukuti mubuso wa kwiwulu ci wina hafuhi” ");
INSERT INTO sbs_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Havali kwa vwenda ku mbali ye wate lwa Galilea, ca vona vakwame vovele vana va muntu yenke, Simone yo sumpwa Pitolosi, ni Andriyasi mwancakwe, ci va sohela tunyandi twavo mwi wate, kakuli vavali vandui. ");
INSERT INTO sbs_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesu cati ku vali, “mwize, municilile, imi muni mi pange vayamvi va vantu” ");
INSERT INTO sbs_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Haho niva siya tunyandi twavo, kumwi cilila. ");
INSERT INTO sbs_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jesu hvvali kwa vu yenda vulyo ca vona vovele vamwi, Jakovo mwana wa Zebediya, ni Joani mwancakwe, va vena mu cisepe ni Zevediya ishavo, ni va onga tunyandi twavo. ca va sumpa; ");
INSERT INTO sbs_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Haho civa siya cisepe ni shavo, kumwi cilila. ");
INSERT INTO sbs_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesu na yenda mwa Galilea yonse, na ka ruta vantu mumasinagoge avo, nava wambila ivangeli ya muvuso, na hoza matuku onse ni vuhole vonse vuvena ku vantu. ");
INSERT INTO sbs_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Intava zakwe ci za ka zuweka kwa Siriya yonse; ni kwa letwa kwali valwala vonse malwalo a cincana cincana, ni va katazehete, ni va vena inhuho imbi, ni vava li ku liwa kuzuminina, ni vava li ku zuminina luñañali; Jesu ca va hoza. ");
INSERT INTO sbs_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Vungi vwavo vu a kuzwa kwa Galilea, ni kwa Dekapolisi, ni kwa Jelusalema, ni kwa Judeya, ni mwishilwa lya Joludani, ci vwa mwi cilila. ");
INSERT INTO sbs_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Cwale Jesu ha vona bantu, ca kambama he lundu. cwale he kala hansi, Valutiwa bakwe cibeza kwali. ");
INSERT INTO sbs_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ca zasumuka ni kubaluta. Ca wamba kuti, ");
INSERT INTO sbs_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“ Imbuyoti ya vana va vontana mu luhuho, kakuti cavo mubuso we Wulu. ");
INSERT INTO sbs_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Imbuyoti ya bana ba Lila, kakuti muva ntontozwe. ");
INSERT INTO sbs_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Va fuyaulitwe bali Tobohete, kakuti mu ba yole inkanda. ");
INSERT INTO sbs_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Va fuyauletwe abo ba fwa inzala yo ku shiyama ni nyota yo Kushiyama, kakuli mu be kute. ");
INSERT INTO sbs_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Imbuyoti ya vaana ve Cishemo, kakuti kava tambule cishemo. ");
INSERT INTO sbs_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Va fuyauletwe vena Inkulo zi jolola, ka va vone Ireza. ");
INSERT INTO sbs_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Va fuyaulitwe va leta Inkozo, kaba supwe vana ve Ireza, ");
INSERT INTO sbs_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Va fuyaulitwe va nyandisiwa ce baka lyo kuluka', kakuti cavo mubuso we Wulu. ");
INSERT INTO sbs_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Imbuyoti zenu vantu ciba mi tukola ni kuminyandisa, kapa kuwamba zibilala zonse ca mapa cevaka lyangu. ");
INSERT INTO sbs_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","mutabe mi musange, kakuti itifo yenu inkando kwi Wulu. Kakuti vantu mubaba nyandisezi maporofita vavali kwina kwa teni ni museni ku zalwa. ");
INSERT INTO sbs_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Inwe mwi Sautu lye kanda, kono i Sautu hali sampuka, muli lungiswe cinzi? kalisina buzole, konji kusohera fera hanze ni kulyatolwa ca matende. ");
INSERT INTO sbs_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","inwe mwi seli lye kanda. munzi uzakitwe he lundu ka u oli ku wungulwa. ");
INSERT INTO sbs_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ka kwina vantu va munika ilambi ni kuli bwika mwi nguvo, kono ulivika ha voneka, mi a tondeze vena mwi nzuvo vonse iseli. ");
INSERT INTO sbs_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Iseli lyenu livenye havusu bwa vantu vonse kuti va vone mitendo yenu yi shiyeme mi muva tembe ishenu wina kwi wulu. ");
INSERT INTO sbs_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","musiye kuhupula kuti ni va kezi kumanisa mulao kapa vaporofita. Kena ni va kezi kuku zimanisa, kono ku i zuziriza. ");
INSERT INTO sbs_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","kakuti ni mi wambira buniti kwanda Iwulu ni nkanda cinza mana, ka kwina yonke i taku yo Mulao, yetene ni imane mbwita zintu zonse hete ni zi mane. ");
INSERT INTO sbs_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Cwale yense yo cola mulao kuti kawina butokwa ni kuluta vamwi vo vulyo milao ka supiwe kuti munini mu mubuso wo kwi Wulu. Kono yo imamera ni kuiruta ka supiwe kuti mukando mumu buso wo kwi Wulu. ");
INSERT INTO sbs_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ceniti ni mi wambira nita kuti ku luka kwenu haiba ka ku hitirili kuluka kwa bañoli ni kwa bafalisi, ka sane ni mwi njire mubuso we Wula. ");
INSERT INTO sbs_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","muba zuwi kuba wambwa kuba ikale kuti, usiye kwi haya, mi we haya u swaneri ku hewa mulandu, ");
INSERT INTO sbs_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","kono ni miwambira mutu zuhi kamba zuhi yo bengera mu kwakwe, mwa swanere ku atuliwa. Mi hape yo wambira mu kwakwe kuti “u ci hole” u swanela ku atuliwa mwi khuta, mi yo mu wamba kuti, I we yasanambene, u mwabe mubu kabo bo muliro we here. ");
INSERT INTO sbs_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Cwale he co neula i mpo zako he aletare, ho sika hateni wiza kuhupula kuti wina mulandu ni mukwako, ");
INSERT INTO sbs_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","siye i mpo za ko habusu bwa katala, u yende muka ambo lisane ni ku zumizana ni mukwako, njo so keze ku tambika i mpo yako cwale. ");
INSERT INTO sbs_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","U litahanere ku zumi zana naye yo kuzekisa ni musina mwi nzira, mwendi yo zo, yo kuzekisa mpohona ca ka ku twale ku muatuli mi muatuli mwa ka kutambike mu manza o mu hikana yasa ka ku atule, ya sa ku sohere mwi intorongo, ");
INSERT INTO sbs_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ka maniti ni mi wambira, kosono zwe mwa teni kwanda hete no mane kuliha mulando ca mali onse o kwete. ");
INSERT INTO sbs_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Muba zuwi kuti kuba tewa kuti, usiye ku panga buhule. ");
INSERT INTO sbs_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","kono i me ni mi wambira kuti, yense yo lola mwanakazi cwo ku mu lakamina, ca mulala mwi nkulo ya kwe. ");
INSERT INTO sbs_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","linso lyako lye cilyo haiba li ku sitatalisa, u li nyukule mo, mi u linzindire kule nawe, ka kuti ci lotu kwa ko, zi lama ca ko conke ha cifwa cocona, mi mubiri wa ko onse kanji u zindirwa mumulilo we Here. ");
INSERT INTO sbs_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","I yanza lyako lye chilyo haiba ni liku sitatalisa, u likosole kwa teni, mi u lisohere kule nawe, kakuli ci lotu kwa ko cilama conke ha ci fwa co nke isiñi mubiri onse ha u nzindirwa mumuliro we Here. ");
INSERT INTO sbs_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ku ba wambiwa hape kuti, muntu ha tanda mwi hyabwe, a mu tambike i mpampili lye kauhano. ");
INSERT INTO sbs_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","kono i me ni mi wambira kuti muntu zuhi kamba zuhi yo hindika mwi hyabwe, kwanda o mulandu wo bushahi, u mupanga bushahi. Mi yense yasana musese kuzwa ha kukanwa kaibe i hule naye. ");
INSERT INTO sbs_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Hape, muba zuwi mu wambiro ku batu ba kwa ikale kuti, 'kanji u nkonkii ca vulisumino bwa mapa kwa Simwine, kono wi zuzirise vulisumino kwe Ireza ko bali sumini cabo. ");
INSERT INTO sbs_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kono ni mi wambira kuti kanji muku nkonka, kamba niheba ce Wulu, ka kuli ji kwina cipula he kere Ireza, ");
INSERT INTO sbs_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","kamba ce nkanda, kakuli nji malyatiro a matende a kwe; kamba ca Jerusalema kakuli muleneñi wa Simwine. ");
INSERT INTO sbs_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Hape musiye ku nkonka ce mitwi yenu, sina ha musa woli ku sandula lusuki lonke kusiha kapa kutuba, ");
INSERT INTO sbs_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ci muswanera kuwamba co bufuhi kuta kuti eni eni kapa Ne ne, cihi ne chihi ci hitilira izi cicizwa kumutu mu bilala. ");
INSERT INTO sbs_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Mubazuwi kuti kuba wambiwa kuti, 'Linso ce Linso, mi lino ce Lino, ");
INSERT INTO sbs_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kono ni mi wambira kuti, kanji mu kanini mutu mubilala. Haiba, yense u ku bakula kwi tama lyo bulyo, muntezekere ni kuyimwi mbali nayo a bakule koo. ");
INSERT INTO sbs_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mi haiba zumwi u saka kumi suminisa ni kuhinda ci zwato canko, muherere ni ngubo yanko, ");
INSERT INTO sbs_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ha iba muntu u kuhambiriza kumu sindikiza cibima conke, u musindikize zibima zo bere. ");
INSERT INTO sbs_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","U he ku muntu yense yo kukumbira, mi kanji u ka nini muntu yo saka ku kalima kwako. ");
INSERT INTO sbs_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Mubazuwi kuti kuba wambitwe kuti, u sake yo wikala naye he mbali mi u toye cila ca nko. ");
INSERT INTO sbs_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","'Kono ni mi wambira kuti, musake zila zenu mi mulaperele bana ba mi nyandisa, ");
INSERT INTO sbs_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Jokuta kuti mube baana be shenu wina kwi Wulu, yo ñatulisa i zuba lyakwe ku bantu va vii mane bulyo ni ba Lukite, mi u tumina i bula ha ba shiyeme ni ba fosahere. ");
INSERT INTO sbs_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Haiba kuti musaka bulyo ba misaka, mupuzo inzi wete ni muka tambule?, esi ni batelisi bo mutero bapanga bulyo? ");
INSERT INTO sbs_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mi haiba kuti mu lumerisa bulyo ba kwenu, zintu nzi zi mupanga zi hitilira zi bamwi? esi ni basezi Ireza nabo bapanga bulyo? ");
INSERT INTO sbs_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mu be hande he, sina ishenu wina kwi Wulu ha shiyeme. ");
INSERT INTO sbs_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Mu mamele kuti kanji mu citi inkezo zo vulotu vwenu havusu vwa vantu kuti mu voniwe ku vali, heva njovulyo kete mu wane mupuzo kwe shenu wina kwi wulu. ");
INSERT INTO sbs_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Cwale ha muha intuso, kanji mu lizi mpeta ha vusu vwenu mu va citila ba lihele muma sinagoge ni makululu, kuti va lumbiwe ku vantu. Ca buniti ni mi wambila, ci vava tambuli mupuzo wavo. ");
INSERT INTO sbs_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kono ho ha intuso, kanji u zuminini iyanza lwako lya cimonso kwi ziva cili panga iyanza lyako lya cilyo, ");
INSERT INTO sbs_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","njikuti i intuso yako yoha i hewe vulipatite. Cwale Iso yo vona zi patitwe mwa ku vozekeze. ");
INSERT INTO sbs_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Mi hamu lapera, kanji mu swani uvu va lihele, va saka kuzimana ni ku lapera mu masinagoge ni mu ma cailo a migwagwa, kuti va voniwe vantu. Luli ni mi wambila niti; ci va va tambili mipuzo yabo. ");
INSERT INTO sbs_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kono iwe, co lapera, wi njile mu malivela, imi ci we yala ciyazo, u lapere kweso wina ku mbali; imi Iso yo vona ku mbali, mwa ku vozekeze. ");
INSERT INTO sbs_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ci mu lapera, kanji mu boleli boleli zi sena intuso uvu mu ba citila va sa zumini; va nahana kuti va wola ku zuwiwa caku wamba wamba ahulu kwabo. ");
INSERT INTO sbs_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Hakuva vulyo, kanji mu swani na vo; kakuli Ishenu wizi zi mu vulite, ni mu seni ku mu kumbila. ");
INSERT INTO sbs_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ci kwina vulyo mu lapele vuti, 'Ishetu wina mwi wulu' ku lumbiwe izina lyako. vu simwine vwako vwize. ");
INSERT INTO sbs_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ci sakiwa kwako ci tendahale hansi mu ci nani mwi wulu. ");
INSERT INTO sbs_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tuhe sunu zilyo ze zuva ni zuva. ");
INSERT INTO sbs_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","U kwatile milandu yetu, uvu naswe mu tu ba kwatili va vatu fosezi. ");
INSERT INTO sbs_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Hape kanji utu twali mu muliko, kono utu lukulule ku muntu muvi. ");
INSERT INTO sbs_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Mi ho kwatila vantu zi va ku fosekeza, ni Iso mwi wulu naye mwaku kwatile. ");
INSERT INTO sbs_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kono ho sa kwatili vamwi zi vaku fosekeza, niheli Iso kete na kukwatile zo mu fosekeza. ");
INSERT INTO sbs_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Imi, hape ho li nyima zilyo, kanji u linyanisi cifateho cako, ubu mu vacitila va lihele, va linyanisa zifateho njikuti va voneke ku vantu kuti vena ha ku linyima zilyo. Faa ni ku rwira, ci va va tambuli mipuzo yavo. ");
INSERT INTO sbs_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kono iwe ho lilinyima zilyo, uli singe mafuta ku mutwi ni ku samba ku cifateho caku. ");
INSERT INTO sbs_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Nji kuti kanji u vonahali ku vantu kuti wina ha kuli nyima zilyo, kono konji kweso wina kumbali. Mi iso yo vona kumbali, mwaku vozekeze. ");
INSERT INTO sbs_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Kanji uli kunganyizi cifumu ca hansi, hena mafele ni mafumi a wola kuci lya, ni hena vasa va wola kutulula mwateni ni ku iva. ");
INSERT INTO sbs_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kono, u likunganyize cifumu umwine kwi wulu ku sena mafele ni mafumi alya hateni, hasena ni vasa va wola ku tulula ni ku iva. ");
INSERT INTO sbs_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kakuli hena cifumu cako nji hena inkulo yako. ");
INSERT INTO sbs_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Linso nji lambi lya muvili. Cikwina vulyo, heva linso lyako li vona hande, muvili wako onse mu uve mwiseli. ");
INSERT INTO sbs_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Heva linso lyako li towele, ni muvili wako wonse wina mucinzime. Cikwina vulyo, heva iseli lina kwako lina luli mucinzime, cikando vule ico cinzime! ");
INSERT INTO sbs_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Kakwina muntu yete na tendele vasimwine vovele, hesi ka toye yenke ni ku saka zumwi, kamba mwa kuteke yenke ni ku shwaula zumwi. Koti co wola ku tendela Ireza ni cifumu. ");
INSERT INTO sbs_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ci kwina vulyo ni ku wambila, kanji u vilaeli ni za vuhalo vwako, cete ulye ni cete uñwe, kambe kaza mubili wako, cete u zwate. njikuti vuhalo kavu hiti zilyo, ni muvili kuhita zizwato? ");
INSERT INTO sbs_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mu lole zizuni za mwibyumbyulu. Kazi vyali kazi sinzi kamba ku vika zi kutulwa mu ciduli; kono Ishenu wina kwi wulu uzi lela. Aho inwe kana muva tokwa ahulu ku zi zamba? ");
INSERT INTO sbs_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Njeni kwenu yo wola ku vulaela ku ekeza ku vuhalo vwakwe? Cwale cinzi hamu vilela ni za kuzwata? ");
INSERT INTO sbs_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Mu hupule nanga ziyangayanga za mu mawa, mu zi menena. Kazi tendi, kazi hosi vwanda. ");
INSERT INTO sbs_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kono ni mi wambila niti, nanga Salumoni munkanya yakwe kana ava zwati niheva ku likana ni lyoke lyao. ");
INSERT INTO sbs_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Heva Ireza u zwatika lyani lya mumawa, lihala sunu ni zona lici li sohelwa mwi ziko, ku woleka vule ku zwatika inwe, inwe muve ntumelo inini? ");
INSERT INTO sbs_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ni ha kwina vulyo kanji mu vileli ni muti, 'Mu tulye nzi?' kamba 'Mutu ñywe nzi?' kamba 'Mutu zwate zizwato nzi?' ");
INSERT INTO sbs_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Vantu vasa zimini nji va saka izi zintu, imi ishenu wa kwiwulu wizi kale zimu saka. ");
INSERT INTO sbs_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kono pili musake vusimwine ni ku shiyama kwabo imi zintu zonse ka muzihewe. ");
INSERT INTO sbs_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Cikwina bulyo, kanji mu vileli ni ze zona, mukuti izona li vilela ni zalyo. Izuva limwi ni limwi lilikenwe vuvi vwalyo. ");
INSERT INTO sbs_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Sanzi uatuli, ni we kete u atulwe. ");
INSERT INTO sbs_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mo atwira nawe mwete utwirwe, Mi mulikaniso wo likanisa, ni wee mukulikaniswe. ");
INSERT INTO sbs_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Chinzi holola chitoweze muliso lyo mukwenu, kono ko lemuhi chikutoweze muliso ya ko? ");
INSERT INTO sbs_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","U wola bule kuwamba kumukwenu, kuti nisaka kuku zwisa chimutoweze muliso, kono mu liso lya ko kwina chikutowenze na wee? ");
INSERT INTO sbs_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Iwe ulihele! tange u zwise chikutoweze muliso lyako, linu mobone site ni ku wola kuzwisa chitoweze mukwako muliso. ");
INSERT INTO sbs_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Musiye kuha zilyo zi njolola ku ba mbwa, mu siye ku sohela mabwe abutokwa habusu bwe zingulube. Ha kuba bulyo zi wola ku a lyatola cha matende, mi ni kubola kwiza ku kuñatola hakati. ");
INSERT INTO sbs_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Kubile, ko hewe. Sake, mo wane. Ngongote, mo wi lyalulwe ");
INSERT INTO sbs_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mi yese ukubila u hewa, mi yese usaka, uwana. Mi mutu u ngongota, we wulilwa. ");
INSERT INTO sbs_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kapa kwina mutu mukati kenu, kuti mwana nkwe ha mukubila inkoko, linu umu ha ibwe? ");
INSERT INTO sbs_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","kapa ha kubila inswi, amu muhe inzoka? ");
INSERT INTO sbs_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","chikwina bulyo, haiba iwe u muvi winzi kuha i mpo kubana bako, ku wo leka bule kwe ishenu wina kwiwulu kumuha zitu zilotu ku ba mukubila? ");
INSERT INTO sbs_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Linu, zitu zose zosaka kuti vatu vaku chitire, ni we u swanela kuba kuva chitira zonse, ici nji mulawo ni ma polofita. ");
INSERT INTO sbs_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Njile mwi nzila i ñuñu. Mulyango u zaseme ahulu ni kwiyaluka ahulu ulolete ku kufwa, Mi batu ba bangi ba yenda mwayo. ");
INSERT INTO sbs_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Mulyango muñuñu ni nzila iñuñu zitwala kubu halo, mi bache baiwana. ");
INSERT INTO sbs_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Mutiye maporofita ba mapa, ba keza kwenu ni chizwato chengu kono buniti ba tuhu bafile zala. ");
INSERT INTO sbs_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kezihatu zabo mobezibe. Kana batu ba kunganya zichelatu ze waine ku chisamu cha miya kapa i efenga kuzwa kwi inkoma? ");
INSERT INTO sbs_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Mwi nzila iswana, cose ci samu cilotu ciha zi chelatu zilotu, kono cisamu cibi ciha zichelatu zivi. ");
INSERT INTO sbs_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Chisamu chilotu kachi woli kuha zihatu zivi, ni chisamu chivi kachiwoli kuha zihatu zilotu. ");
INSERT INTO sbs_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Chose chisamu chisa biki zihatu zilotu chikankwa ni kusohelwa mulilo. ");
INSERT INTO sbs_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ha kuva bulyo, mu mu bezibe cha zihatu zabo. ");
INSERT INTO sbs_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Kana vantu vonse va sumpa kwa ngu kuti,” simwine, simwine,” va sejile mu chisi chewulu, kono konji yense utenda chiva saka va ndanda vena kwi wulu. ");
INSERT INTO sbs_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Vungi bwa vantu kava cho kwangu ilyo izuba, “simwine, simwine, kana tuva polofiti mwizina yako, mwizina tuva hidiki madimona, hape mwinzina lyako tubapangi imakazo zikando? ");
INSERT INTO sbs_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Linu kani va lwire halukanda, “kena niva mizi! muzwe kwangu, inwe vantu vavi!” ");
INSERT INTO sbs_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","linu, yese uzuwa mazwi angu ni ku e chilila u swana sina muntu yozaka inzumbo yakwe he bwe. ");
INSERT INTO sbs_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Invula haisoka, muunda ukeza, ni huho likeza ziza kundama he nzubo, kono kaiwiri hasi, kakuti ibazakwa he bwe. ");
INSERT INTO sbs_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Chi kwina bulyo yese uzuwa mazwi angu kono ka e chilili u swana sina mutu we chihole uzaka izubo yakwe he seke seke. ");
INSERT INTO sbs_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Invula ikeza hansi, muunda ukeza, ni luhuwo luhunga ni kundama izumbo, cwale iwa, ni kushinyeha tota.” ");
INSERT INTO sbs_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ha kuvakuti Jesu chamana kuwamba mazwi aa, vungi bwa vantu chiva komoka ituto ya kwe, ");
INSERT INTO sbs_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","cwale chaba luta sina wina mata, isinyi sina vanoli ba mulawo. ");
INSERT INTO sbs_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Cwale Jesu hasuka helundu, vantu vangi civamwi cilila. ");
INSERT INTO sbs_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Micwale we imbingwa ca keza kwali, cheza kumufukamina, niku wamba, “Simwine, haiva usaka, uwola kuni cenisa.” ");
INSERT INTO sbs_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesu chaotolola iyanza ni kumukwata, nikuwamba, “Ni saka. Ucene.” Hahofera ca cenisiwa kwi imbwingwa yakwe. ");
INSERT INTO sbs_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesu camuwambila, “Uvone kuti kowambi cimwi u zumwi muntu. Yende mwi nzila yako, mi ukalivonahaze ku mupurisita ni kukaha impo ina Mushe yavalaeli, kuti ikabe vupaki kuvali.” ");
INSERT INTO sbs_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesu hace njile mwa kapenaumu, mulauli avakezi kwali ni kumuvuza, ");
INSERT INTO sbs_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","cawamba, “Simwine, muhikana wangu ulele mwinzuvo uzuminine luñañali mi usasa mwinwe lilu.” ");
INSERT INTO sbs_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesu chawamba kwali, “Munize ni muhoze.” ");
INSERT INTO sbs_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Mulauli chetava ni kuwamba, “Simwine, kaniswaneli kuti winjile mwi nzuvo yangu, uwambe vulyo inzi, mi muhikana wangu kahole. ");
INSERT INTO sbs_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kakuti ime ni muntu ubikitwe mwikonde lya muvuso, mi nina masole vena mwikonde lyangu. Niwambila uzu, 'Yende,' mi uyenda, ni kuzumwi, 'Wize' mi ukeza, ni kumuhikana wangu, 'Pange ici,' mi ucipanga.” ");
INSERT INTO sbs_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Cwale Jesu hazuwa izi, avakomokwa mi avawambili avovava kumwichilile, “Ceniti nimiwambila, kanini kuwana kale we ina intumelo mwa Isilaele. ");
INSERT INTO sbs_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nimi wambila, vungi kavazwile kwa upa ni kwa wiko, mi muvekale he tanfule ni Abrahama, ni Isaka, ni Jacobo, mumuvuso wa kwiulu. ");
INSERT INTO sbs_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kono vana vamu muvuso kava sohelwe kwi fifi lyahanze, kwina kulila ni kukwecameno.” ");
INSERT INTO sbs_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jesu cawambila mulauli we nkondo, “Yende! vulyo moco vazumininni, ili kuti kucitahale vulyo kwako.” Mi muhikana cahola yeyo inako. ");
INSERT INTO sbs_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesu habakwina mwi nzuvo ya Petorosi, cavona mukwenyani wa Petorosi nalele a valwalite ifiva. ");
INSERT INTO sbs_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesu a vamukwati he yanza, mi ifiva ci lyamusiya. cavuka ni kutanga kumuseveleza. ");
INSERT INTO sbs_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Cwale hakuva Citengu, vantu civaletela Jesu vantu vangi vavakuyendiswa madimona. Avahindiki inhuho ce inzwi nikuhoza vavakulwala vonse vava kulwala. ");
INSERT INTO sbs_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Mwei inzila kuvezuzilizwa civawambwa ku mupolofita Isaya, nawamba, “iye mwine Avalihindili matuku etu ni mifokolo yetu. ");
INSERT INTO sbs_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesu havona inyangela ci imuzumbulukite, caha itaelo kuti vayende kuimwi imbali ye wate lya Galileya. ");
INSERT INTO sbs_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Cwale Muñoli ca keza kwali ni wamba, “Muluti, munikwi cilile konse kwete uyende.” ");
INSERT INTO sbs_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesu cawamba kwali, “Valuwawa vena malindi, ni zizuni zamwi ulu zina zizumbo, kono Mwana Muntu kena hete a shamike mutwi wakwe.” ");
INSERT INTO sbs_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Zumwi kuvalutiwa vakwe cawamba kwali, “Ireeza, ni zuminine pili nikaunge vandanda.” ");
INSERT INTO sbs_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Kono Jesu ca muwambila, “Niicilele, mi usiye vafwile vaunge vafwile kuninavo.” ");
INSERT INTO sbs_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesu hecila mucisepe, valutiwa vakwe ci va mwicilila mucili. ");
INSERT INTO sbs_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Micwale, cikweza inwungwa ikando mwiwate, micisepe ciceza kuumbwa mandinda. Kono Jesu abalele. ");
INSERT INTO sbs_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Valutiwa bakwe civeza kumuvusa, ni vawamba, “Tutuse, Simwine, citwina hafuhi ni kufwa!” ");
INSERT INTO sbs_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesu cawamba kubali, “Cinzi hamutiyite, inwe be intumelo inini?” Cazima ni kukalimela luhuho ni liwate. Haho cikwa tontola ahulu. ");
INSERT INTO sbs_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Vantu civakomokwa ni kuwamba, “Muntu wina bule uzu, yo kutekiwa niheva luhuho ni wate?” ");
INSERT INTO sbs_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesu hakeza kwimbali imwi ni kwi nkanda ya Magadarena, bakwame VoVele vava kuyendiswa madimona civamukatana. Vavakuzwa mumavita mi vavali kutiza hahulu, mi mane kakwina muyenzi yava kuwola kukosaza ce inzila iyo. ");
INSERT INTO sbs_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Micwale, civalila ca kuwongoza ni vawamba, “Cinzi citulukela kupanga nawe, Mwana Ireeza? Weza kunu kwiza kutu kataza inako niseni kusika?” ");
INSERT INTO sbs_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Mukunyi wa ziguluve zingi uva kwete kufulila kule kanini navo. ");
INSERT INTO sbs_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Madimona azwili havusu ni kukatazaJesu ni awamba, “Haiba motuhindike, tutumine kuna kawuna mukunyi waziguluve.” ");
INSERT INTO sbs_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesu cawamba kubali, “Muyende!” Madimona ciazwa ni kuyenda muzigulube. Micwale, mukunyi wonse chiwa tilila hekomwe nikuli wisikiza mwiwate micizafwila mumenzi. ");
INSERT INTO sbs_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Vakwame vavaku lisa zigulube civatiya. Mi ha vayenda mwitolopo civakaviha zintu zonse, sihulu civapangahali kuva kwame vava kuyendiswa madimona. ");
INSERT INTO sbs_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Micwale, itolopo yonse civazwa kukakatana ni Jesu. Ha vamuvona, civamukumbila kuti azwe mwinkanda yavo. ");
INSERT INTO sbs_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesu e njila mu chisepe, cha luuta, kwiza muitolopo yakwe. ");
INSERT INTO sbs_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Micwale, va valeti muntu yo zuminine luñañali na lele ha vulo. Cha vona intumelo ya bo, Jesu chawambila ya va kuzuminine luñañali. “Mwanangu u be u muntu yotavite. Zivi zako zi va wondelwa.” ");
INSERT INTO sbs_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Micwale, vamwi ku bañoli chi baliwambila a bo bene, “Uzu muntu u nyefula.” ");
INSERT INTO sbs_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesu abezi mihupulo yabo mi ni chati, “Chinzi hamuzeza bubi mwimunkulo zenu? ");
INSERT INTO sbs_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","chihuva nje chihi kuku chiwamba, 'Zíbi zako za wondelwa,' kapa kuwamba. 'Zimane mi u yende'? ");
INSERT INTO sbs_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kono wizive kuti Mwana Muntu wina maata hanu hansi akuswalela zibi,” Chawamba kuyo zuminine luñañali, “Vuke, zalule vulo bwako mi uyende kwinzuvo yako.” ");
INSERT INTO sbs_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Haho muntu cha katuka ni kuyenda kunzubo yakwe. ");
INSERT INTO sbs_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Cwale vungi bwavantu ha babona izo, chiba komokwa mi chiva vavaza Ireeza, ya vahi maata ena vulyo ku bantu. ");
INSERT INTO sbs_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesu haka kosola kuzwa uko, cha vona muntu we zina lya Mateu, ya va kuikele ha chivaka chi lihisezwa mutelo. Ni cha muwambila. “Ni ichilile.” Cha zimana ni kumuichilila. ");
INSERT INTO sbs_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jesu heza kwikala kuti alye mwinzubo, micwale, vuñata bwa vatelisi ni vantu vavaezalibi chiveza kulya ni Jesu ni valutiwa vakwe. ");
INSERT INTO sbs_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Cwale bafalisi ha va vona vulyo, chi vawamba kuvalutiwa vakwe, “Chinzi muluti wenu halya ni batelisi ni vantu va vaezalivi?” ");
INSERT INTO sbs_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesu hazuwa izi, cha wamba, “Vantu vakolete mumuvili kavalili iñanga, haisi vana valwala. ");
INSERT INTO sbs_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Muswanela kuyende mukalitute ziitalusa, 'Nitavela chishemo insinyi chitavelo.' Njaho hanikeza, insinyi kusumpa valukite kukulinyansa, kono vaezalibi.” ");
INSERT INTO sbs_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Haho valutiwa va Joani chi veeza kwali chivawamba, “Chinzi iswe ni bafalisi hañata hatulinyima zilyo, kono balutiwa bako kavalinyimi zilyo?” ");
INSERT INTO sbs_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesu chawamba kuvali, “Kana valikani vayoseswa vawola kulizuwa kusatava haiva munyaliwa nachina navo? Kono mazuva mueze munyaliwa hese nakahindwe kuvali, mi cwale kavalinyime zilyo. ");
INSERT INTO sbs_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ka kwina muntu ya vika chikamba chiha ha chizwato chakale, kokuti chikamba echo mo chi ñatuke ku chizwato, mi hafwile mohañatuke ahulu. ");
INSERT INTO sbs_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nanga vantu kete vavike iwaine ihya mwi dalo lye waine lya kale. Ha va chita vulyo, idalo kaliñatuke, mi iwaine moitike mi na lyo idalo lye iwaine kalisinyehe. Kaho muvavike iwaine ihya mu madalo mahya e waine, mi zonse kazivikwe nenza.” ");
INSERT INTO sbs_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesu na kwete kuwamba izo zintu kuvali, micwale muvusisi cha keza ni kwiza kufukama kwali. Chawamba, “Mwanangu wa mukazana hahanu cwa fwa, kono wize, zo u bike iyanza lya ko hali, mi kahale.” ");
INSERT INTO sbs_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Haho Jesu chazima kumwichilila, ni valutiwa vakwe. ");
INSERT INTO sbs_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Micwale, mwanakazi ya va kukatazwa vutuku bwa malaha ka zilimo zina ikumi ka zovele, chakeza kwisule lya Jesu, ni ku kwata ku mamaninizo echizavalo chaakwe. ");
INSERT INTO sbs_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ni chaliwambila i ye mwine, “Ha chinakwata vulyo kuchizavalo chakwe, monibe hande.” ");
INSERT INTO sbs_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Kono Jesu a muchevuka chamuvona, ni cha wamba, “Mwanagu wa mukazana, koze inkulo. Intumelo ya ko chi ya kuhoza.” Mi mwanakazi cha hola pohonaho. ");
INSERT INTO sbs_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jesu he njila munzubo yo muvusisi, cha bona balizi be mpeta ni vantu bangi va panga hahulu ilata. ");
INSERT INTO sbs_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Chawamba, “Muzwee, kakuti mukazana kafwile, kono u lele.” Kono va museka ni kumusheununa. ");
INSERT INTO sbs_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Cwale vantu vangi ha vahindikilwa hanze, che njila mwinzuvo ni kumukwata kuiyanza, mi mukazana cha vuuka. ");
INSERT INTO sbs_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Makande chiahasana chikiliti yonse. ");
INSERT INTO sbs_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesu ha kosoza ku zwauko, zibofu zovele za muichilila. Ne zi kwete kumuhuwa ni ziwamba, “Tuzuwele vutuku, Mwana a Daafita” ");
INSERT INTO sbs_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesu ha keza mwinzubo, zivofu zo vele chizakeza kwali. Jesu cwamba kuvali, “Muzumina kuti ni wola kumihoza?” chibawamba kwali, “Eeni Simwine.” ");
INSERT INTO sbs_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Mi Jesu cha vaonda ha menso, mi chati, “Musiye kupangahale bulyo kuya che intumelo yenu.” ");
INSERT INTO sbs_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mi menso a bo chi eyaluka. Mi Jusu cha abakalimela ahulu nikuwamba, “Muvone kuti ka kwina muntu u swanela kuiziba kuamana nezi.” ");
INSERT INTO sbs_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kono vakwame vo vele vayenda ni kukahasanya indava iyo muchikiliti chonse. ");
INSERT INTO sbs_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","A vo vakwame vo vele ha chivakaya, micwale mukwame wa chimumu wina madimona avaletwa kwa jesu. ");
INSERT INTO sbs_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Cwale madimona ha hindikiwa, muntu wa chimumu chawamba. Inyangela chi ya komokwa mi chi ya ti, “Izi kazini kuvonwa kale mwa Isilaele. ");
INSERT INTO sbs_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kono Bafalisi va va kuwamba, “Cha mulao wa madimona, u tanda madimona.” ");
INSERT INTO sbs_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesu ava yendi konse mumileneñi ni muminzi. A ba zwilile havusu ni kuluta mu masinagoge a vo, kukutaza inzwi lya mubuso, Ni kuholiza onse malwalila ni matuku onse a shutana. ");
INSERT INTO sbs_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ha vona inyangela, cha ba fwila makeke, kakuli va va kukatazehete ni kuzwafa. Va va kuswana sina ingu zi sena mulisana. ");
INSERT INTO sbs_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Chawamba ku valutiwa bakwe, “Inkutulo yi ngi, kono vaveleki vache. ");
INSERT INTO sbs_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kacwalo mulapele cheputako kwa Simwiine we inkutulo, ilikuti a tumine vabeleki mu inkutulo ya kwe.” ");
INSERT INTO sbs_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesu hasupa balutwana vakwe bonse vena ikumi ni vovele, mi cha vaha ziho za ku kalimela ihuho imbi, ni kuzi laela kuzwa, ni ku hoza matuku, ni mi fokolo yose. ");
INSERT INTO sbs_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Lyahanu mazina a valutwana vena ikumi ni vovele nji: We ntanzi, Sayimoni yo sumpwa Pitorosi, ni mwachakwe Andreyasi; Jakovo mwan'a Zevediya, ni mwachakwe Joani; ");
INSERT INTO sbs_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipi, ni Vartolome; Tomasi, ni Mateu mulihisi wa mitelo; Jakovo mwan'a Alufeya, ni Tadeya; ");
INSERT INTO sbs_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Sayimoni yo kanana, ni Judasi Isikariyote, muwuzi wa Jesu. ");
INSERT INTO sbs_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Aava vena ikumi ni vo vele Jesu cha va tuma. Cha va layela kuti, “Sanzi va yendi kuzivaka za Machava, mi sanzi mwi njili mwi Tolopo ihi ya Masamariya; ");
INSERT INTO sbs_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kono muyende kwi Ngu zi zovete ze zunvo ya Isilaele. ");
INSERT INTO sbs_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mi chi muyenda, mukutaze ni muuti, “Mubuso wa kwiwulu chiwina hafuhi.” ");
INSERT INTO sbs_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mu hoze valwele, mu vuuse vafwile, mu hooze imbingwa, mu hindike madimona. Mu vahewa bulyo, muhe vulyo. ");
INSERT INTO sbs_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Sanzi mu hindi gauda, ni silivera, kapa mashelenyi mu mikotana yenu; ");
INSERT INTO sbs_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Sanzi muhindi mikotana ya zizwato mu misipil yenu, kapa zimwi zizwato, kapa isangu, kapa inkoli, kakuti muveleki u swanelwa zilyo zakwe. ");
INSERT INTO sbs_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Muleneñi uhi no uhi kapa munzi u mwi njila mwateni, mu buuze yo swanela mwikale mwateni; mwi kale mwateni konji chi mwa funduka. ");
INSERT INTO sbs_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Chi mwi njila muzuvo, mu ilumelise. ");
INSERT INTO sbs_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Heva inzuvo iiswanela, musiye inkozo yenu ishale mwateni; kono heva kayi swaneli, musiye inkozo yenu i voole kwenu. ");
INSERT INTO sbs_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kwabo vasena vava mitambuli kapa kutekeleza liinzwi lyenu, ha mu nyamuka kuzwa muzuvo ya vo kapa mu Muleneñi, mu kunkumune imbundu ya ku matende yenu. ");
INSERT INTO sbs_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Che niti ni ta kwenu: Mu ve ni chisemo chihitilize mwi Nkanda ya Sodoma ni Gomora mwi zuva lye nkatulo kuhita lyowo muleneñi. ");
INSERT INTO sbs_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Mu vone, ni mi tuma sina Ngu zina mukati ka Valuwawa, muve vena maano sina nzoka mi mu ve sina va sena maano sina Nkwilimba. ");
INSERT INTO sbs_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mu tokomele Vantu! Mu va mitwale havusu bwa va zekisi, mi ka va mishupe mu zivaka za malapelelo avo. ");
INSERT INTO sbs_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mi ka muletwe ha vuusu bwa Mangambela ni va Simwine vakeni changu, kuti mu ve ni vupaki kuvali ni ku Machava. ");
INSERT INTO sbs_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Chini vati chiva mi kwatisa, sanzi ni mu katazehi kuti ka mu wambe inzi, kakuti cheti ni mu wambe ka mu chihewa mwe yeyeyo inako. ");
INSERT INTO sbs_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ka kuti keti niyi kuvele unwe mu wamba mi kayi kuvele Luhuho lwe Shenu lweti ni lu ku waamba mweenu. ");
INSERT INTO sbs_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Muntu mwa kwatise mukwakwe kwifu, mi muzazi a kwatise mwan'a kwe. Vaana mubalwise vazazi va vo, mi va va letele kufwa. ");
INSERT INTO sbs_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mu va mitoye vakeñi che zina lyangu. Mi yata sike ku ma manimani, uzo muuntu mwa puluswe. ");
INSERT INTO sbs_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Chi va minyandise bulyo mu Muleneñi, muyende ku mwi ku Muleneñi, Initi ni wamba kuti, ke se mu mane Mileneñi yoose ye Isilaele pili Mwana Muntu na seni kusika. ");
INSERT INTO sbs_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Mulutwana kahiti Muluti wa kwe, kapa mutanga kuhita Nfumwe. ");
INSERT INTO sbs_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ku swanela kuti mulutwana a swane ni muluti wa kwe, ni mutanga ni Nfumwe. Heba vasumpa mukulwana we nzuvo Beelzebule, ka kuve vule venzuvo ya kwe chi va nyasilizwa! ");
INSERT INTO sbs_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Linu sanzi mu va tiyi; kakuti kakwina chifupikitwe chi se chi shale ni chi fupikitwe mi ka kwina chipatitwe chi se chipale kwi zibwa. ");
INSERT INTO sbs_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Chi ni mi wambila mwififi, mu chi wambe mwiseli; mi chi muzuwa mu matwi yenu, mu chi wambe mpatalaza ku Vantu. ");
INSERT INTO sbs_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Sanzi mu tiyi Vantu ve haya muvili; kono ka va woli kwi haya luhuho. Insini, mu tiye ve haya zoose luhuho ni muvili mwi hele. ");
INSERT INTO sbs_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Heva, tutiti to vele twina heteko ye peene yoke? Kanti ka kwina katiti, niheva konke, ka wila hansi Ireeza wenu na se zivi. ");
INSERT INTO sbs_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ni heva nsuki za ku mitwi yenu zibalitwe zoose. ");
INSERT INTO sbs_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Sanzi mutiyi. Mu va vu tokwa kuhita tutiti tungi. ");
INSERT INTO sbs_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Muntu ye se yo wamba nzina lyangu ku Vantu, name kani muwambi kwa Tayo wina kwiwulu. ");
INSERT INTO sbs_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kono yo ni sampula ku vantu, name, kani mu sampule kwa Tayo wina kwiwulu. ");
INSERT INTO sbs_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Sanzi muhupuli kuti ni valete inkozo mwi kaanda. Kena ni va leti inkozo, kono mulinga. ");
INSERT INTO sbs_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Cwale ni va kezi kwiza kufapanya muntu ni veesi, mi mwnakana ni nyiina, mi mukwenyani wa mwana kazana ni nyinazaala. ");
INSERT INTO sbs_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Muntu zilazakwe, mu va ve, venzubo yakwe. ");
INSERT INTO sbs_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","I ye yo saka Sii kapa Nyina kuhitiliza mwani sakila, ka ni swaneli. Mi yo saka mwan'akwame kapa mwan'akazana kuhitiliza kani swaneli. ");
INSERT INTO sbs_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","I ye ya sa hindi chifapano cha kwe ni ku ni chilila ka ni swaneli. Yo tokomela vuhalo bwa kwe mwa vu sinyehelwe. ");
INSERT INTO sbs_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kono yo sinyehelwa vuhalo vwa kwe vakeñi cangu, mwa vuwane. ");
INSERT INTO sbs_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Yo mi tambula, u tambula ime, mi yoni tambula ime u tambula yoni tumite. ");
INSERT INTO sbs_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","I ye yo tambula mupolofita kakuti mupolofita ka wane mpo ya vupolofita. Mi yo tambula muntu yo shiyeme vakeñi cha kuta kuti muntu yo shiyeme ka wane mpo ya kushiyama. ");
INSERT INTO sbs_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ye nse yoha ku muntu munini menzi a kuñwa a tontola, chevaka lya kuwamba kuti mulutwana, ni mi wambila kuti, ka kwina mwi se na kangilwe ku wana mpo ya kwe.” ");
INSERT INTO sbs_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","I, nako hayisika mu kumana Jesu a va layi Valutwana vakwe vene nkumi ni vovele, cha yenda kuzwaho ni kutanga kuluta ni ku kutaza mu mileneñi yabo. ");
INSERT INTO sbs_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Linu Joani na nga zuwa mwi ntolongo inkenzo za Kereste, cha tumina iñusa ni valutwana vakwe ");
INSERT INTO sbs_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","mi chi va wamba kwali, “Kana njiwe yo Keza, kapa kwina zumwi muntu utu swanela kulola?” ");
INSERT INTO sbs_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesu ave tabi mi cha wamba kuvali, “Mu yende mi mukavihe kwa Joani zi mwa vona ni kuzuwa. ");
INSERT INTO sbs_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Zivofu va tambula kuvona, zihole zi yenda, ve mbingwa ba jolola, va sa zuwi va zuwe, va fwile va vukile vuhalo, mi vantu va saka ku zuwa linzwi va kutazwe. ");
INSERT INTO sbs_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Imbuyoti yi ve kwa vo, vasa nya nsilizi linzwi.” ");
INSERT INTO sbs_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","A va vakwame ha va yenda nzila yabo, Kereste cha tanga ku wambila chi chaba ka za Joani, “Zile muyendele nzi mwi Halaupa ku kalwela mpe zi hungiswa luhuho? ");
INSERT INTO sbs_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Linu zile muyendelezi ku kavona - muntu yo zavele zizwato zi huva? Initi, avo vazwata zizwato zi huvilila vahale muzubo ya simwine. ");
INSERT INTO sbs_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Chi nzi chi muyendela kuka bona, mupolofita? Ee, ni wamba kwenu, mi hahulu kuhita mupolofita. ");
INSERT INTO sbs_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Nji yena za kwe, zi ñoleletwe, 'Mu vone, ni tumina muhikana wangu havusu vwenu, ye se a lukise inzila yenu, havusu bwenu.' ");
INSERT INTO sbs_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ni wamba kwenu, che niti, kwa vo, vava pepwa ku vanakazi, kakwina mukando kwa Joani Mukolobezi. Linu munini mu mubuso we Reeza, kwiwulu njo mukando. ");
INSERT INTO sbs_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ku zwa muma zuva a Joani Mukolobezi ku sika sunu, mubuso we Reeza uhindwa chamata mi vakwame vakali va u hinda cha kunyanga. ");
INSERT INTO sbs_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Vapolofita vonse ni mulao, vava polofiti konji kusika kwa Joani Mukolobazi. ");
INSERT INTO sbs_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Heba no tavela kutambula, uzu Elia, iye yo swanela kukeza. ");
INSERT INTO sbs_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Uzo, wina matwi akuzuwa, mu musiye atekeleze. ");
INSERT INTO sbs_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Kani, vamba nye, ni chinzi kolu lusika? Kuswana sina vahwile, va kwete kuzanina ama wuzikizo a musika, vekele ni vali sumpa, ");
INSERT INTO sbs_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ni bati, 'twa miliizikize mpeeta kono kana mwa zana. Twa silisa, kono kana mwa donsa zinsozi.' ");
INSERT INTO sbs_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kana Joani kana vezi kuku lya chinkwa, kapa kuñywa i waine, mi ni vata kuti wina, 'Madimona.' ");
INSERT INTO sbs_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mwana'Muntu, abezi ku lya, ni kuñywa, ni vata kuti, 'Mu vwene, mukwame mulyabi, ni vudakwa, mulikana va telisi va mutelo, ni batenda zibi!' Kono vutali vu vwene kete chi vu tendwa.” ");
INSERT INTO sbs_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kuzwa aho, Jesu cha tanga ku kalimela minzi yonse ya vatendi I makazo mwa teni, kakuti kena vava vaki, ");
INSERT INTO sbs_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Wina bumayi iwe Koranizini! Wina bumayi iwe Betsaida! Heva zikando ziva tendwa mu minzi ya Tire ni Sidoni ziba tendwa inwe ni ziva voleli kale za kuzwata masaka ni kulivumbeka mufuse. ");
INSERT INTO sbs_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kono kakuve kuhuva kwi koto ye katulo ya Tire ni Sidoni kuhita yenu. ");
INSERT INTO sbs_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","I we, Kapenauma, uzeza kuti mo yende kwiwulu? Nanta, mo bozwe mwi Hele. Sina mwa Sodoma muva tendelwe zikando ni kwenu, ni ziba shali bulyo kusikila lya sunu. ");
INSERT INTO sbs_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kono, niti kwenu, ka ku huvahale munkanda ya Sodoma che nako ye nkatulo, kuhita kwenu.” ");
INSERT INTO sbs_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Che nako iyo Jesu avati, “Ni lumbeka Tayo Ireeza, Simwine wewulu ne nkanda, kakuti aba humbili vatali, ku zuwisisa ni kwi zivahaza kwavo, va sali tutite, sina vahwile, ");
INSERT INTO sbs_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ee, che niti, Tayo, kutendwe intanto yako. ");
INSERT INTO sbs_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Zintu zonse zi va tendwa cha Ngu kuzwila kwa Tayo, Mi kakwina nanga umwina wizi mwana konji Tayo, mi kakwina umwina wizi Tayo konji Mwana, mi kuzumwi sina Mwana' yo lakeze kulitondeza kwali. ");
INSERT INTO sbs_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mwize kwa ngu, mwense mu lemenwe ni ku suntika, mi kani mihe mpumulo. ");
INSERT INTO sbs_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Muhinde i jokwe lya ngu mulikulike mi mulitute kwangu, kakuti nina chisemo ni nkulo indotu, mi ka muwanine inhuho zenu impumulo. ");
INSERT INTO sbs_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kakuti i jokwe lyangu ihuva mi muziyo wangu muhuva.” ");
INSERT INTO sbs_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mu mazuva awo Kereste ava kuhita mu mawa mwi zuva lye Pumulo. Balutwana bakwe vava fwile izaala mi chi vatanga ku totola zikunku, ni kulya. ");
INSERT INTO sbs_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kono linu Vafalisi hava vona kuti; Chi va cho kuti kwa Kereste, “Voone, valutwana va ko kwete kuchola mulawo mwi zuva lye Pumulo.” ");
INSERT INTO sbs_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Kono Kereste cha wamba ku vali, “Kana ka mwini kuvala za vapangi Daafita, ha vali kufwile inzala, mi vakwame va vali kwina naye? ");
INSERT INTO sbs_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Mwa vayendeli mwi zuuvo ye Reeza mi chalya chinkwa chivena kwateni, kena avali cha mulawo kuti alye, hape kena chivali cha mulawo kwavo va vena naye, mi ku vali mulawo ku vali valuti? ");
INSERT INTO sbs_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kana kena mu va vali mu mulawo, kuti mwi zuva lye Pumulo valuti mwi tempele va cholanga mulawo we Pumulo mi ka vena mulandu? ");
INSERT INTO sbs_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kono ni cho kwenu kuti mu kulwana yo hita kereke zonse kwena. ");
INSERT INTO sbs_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kambe chi muvali kwizi, 'Ni lakaza chisemo mi isinyi chitavelo,' ni musena mu va nyansi va sa foseze. ");
INSERT INTO sbs_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Chokuti Mwan'a Muntu nji Kereste we Pumulo.” ");
INSERT INTO sbs_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Linu Kereste cha funduka ku yenda mi cha yenda mu zivaka zavo za malapelelo. Mu lindile, kuvena mukwame ya va zuminine yiyanza. ");
INSERT INTO sbs_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Vafalisi chi va vuuza Jesu, chi vati, “Kana ku swanela kuhoza lye Pumulo?” kuti va wanine ha teni inzila yi cho kuti wa tenda chivi. ");
INSERT INTO sbs_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesu na cho ku vali, “Muntu mwi ve njeni kwenu kuti ave ni ngu yi mwina, mi heva kuti iyi ngu iwila mwilindi mwi zuva lye Pumulo, ke se wi tuse ni kwi zwiisa? ");
INSERT INTO sbs_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mu ku ve vule ni vutokwa kuti muntu ahite ngu! Ni hakuvavulyo kulukela ku va mulawo wa kutenda vulotu mwi zuva lye Pumulo.” ");
INSERT INTO sbs_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Linu Jesu cha ti ku mukwamwe, “Wolole yanza lyanko.” Cha li wolola, mi cha vo zekezwa makete, sina nji limwi yi yanza. ");
INSERT INTO sbs_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kono va Falisi chi vazwa hanze mi chi va ka muveteka. Va vali ku ka vulola nzila mwe se va mwi hayile. ");
INSERT INTO sbs_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Kono Jesu heziva, cho volela mu masule. Vungi bwe nyangela vu va mwi chilile, mi cha va honza bonse. ");
INSERT INTO sbs_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Cho va layela kuti sanzi va mwi zi vahazi ku va mwi, ");
INSERT INTO sbs_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","iyo iwoleka ku va niti, ku wamana ni chi va wambwa kwa Isaya wa mupolofita, ku cho, ");
INSERT INTO sbs_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“ Vone, Iwe mutang'a ngu uni va keti; yini suuni, yiye kwali luhuho lwangu lu va mushukelyi. Ka ni vike kwali Luhuho lwangu, mi ka huweleze inkatulo ku Machava. ");
INSERT INTO sbs_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Keti na hondane kamba ku huweleza hahulu; mane nangati zumwi vulyo kuti azuwe linzwi lyakwe mu makululu. ");
INSERT INTO sbs_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ke se na chole impee yitengeme; ke se na zimise mu muni usa zwisi vuusi, konji pili cha tumina inkatulo kuti nje yikome. ");
INSERT INTO sbs_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mi va Machava konji chi va kolwisisa mwi ziina lyakwe.” ");
INSERT INTO sbs_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Linu zumwi yo fwile menso ni chimumu, wi nji hilwe madimona, ava letwa kwa Kereste. Cha mu haza, che kalavo yi cho kuti chimumu chiwambe ni ku vonna. ");
INSERT INTO sbs_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Inyangela yonse chi ya komokwa mi chi ya ti, “Kana kuti uzu muntu mwan'a Daafita?” ");
INSERT INTO sbs_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kono linu va Falisi ha va zuwa imakazo, chi vati, “Uzu muntu ka hindiki madimona konji cha Veelzebub, mu kulwana wa madimona” ");
INSERT INTO sbs_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Kono Jesu ave zivi milelo yavo mi cha ti ku vaali, “Umwi ni umwi muvuso ukawuhene hakati uwo wi ne ka wu wanike kuti u shinyiwa, mi muleneñi ni muleneñi kapa izuuvo yi ka wuhene hakati yiyo yine ke se ni zimane hamwina. ");
INSERT INTO sbs_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Heva Javulusi na hindika Javulusi, U li ka wuhenye hakati eye mwine. Kana uwo muuso ka wu kuzimane vule? ");
INSERT INTO sbs_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mi heva ni hindika madimona cha Veelzevule, cwale nji mwi zina lyani valutwana mu va hindikila? Vakeñi che zi, ka va ve vaatuli venu. ");
INSERT INTO sbs_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kono heva Ni tanda madimona cha Luhuho lwa Simwine Reeza, linu muvuso we Reeza wize hewulu lyenu. ");
INSERT INTO sbs_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Mi kwiza vule kuti zumwi wi njila muzuvo ya muntu wina ziiho mi wiiva zibya za mwi zuuvo na sa sumini mukwame yo kolete lye tanzi? Linu cwale mweve zibya za kwe mwi zuuvo. ");
INSERT INTO sbs_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Yiye ya sa zimene name uni toyete, mi yiye ya sa likopanyi name u hasana. ");
INSERT INTO sbs_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kuzwaho Ni cho kwenu niti, chivi chonse ni ku nyasilizwa ka zi swalelwe bantu, kono nyefulo zonse ku wamana ni Luhuho ke se ni kuve ni swalelo. ");
INSERT INTO sbs_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mi vonse va wamba linzwi lifusahele ku Mwan'a Muntu, ka va swalelwe kwali. Kono vonse va wamba kunyasiliza Luhuho lu Njolola, ke se ni va swalelwe, ni heva munu mwifasi, ni heva mwifasi likeza. ");
INSERT INTO sbs_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","U wola kutenda isamu vulotu ni zichelantu za teni kapa isamu kufwa ni zichelantu za teni kufwa, kakuti isamu lizivahala cha zi chelantu za teni. ");
INSERT INTO sbs_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yinwe vaana va zihili, kuzwaho mwina vuuvi, mu woola vule ku wamba zilotu? Kakuti ku zwililila kunkulo kaholo kawamba. ");
INSERT INTO sbs_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Muntu yo shiyeme u zwisa chimbule chilotu kuzwililila kunkulo, mi muntu u fosahele u zwiisa chimbule chi fosahele ku zwililila kwikulo yakwe. ");
INSERT INTO sbs_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mi ni milwilite kuti mwi zuva lwe katulo bantu ka va ve ni bwikalavelo ku linzwi ni linzwi li va va wamba. ");
INSERT INTO sbs_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Cho kuti cha maanzwi yenu ka mu wane ku shemuviwa, mi cha manzwi yenu ka mu hewe mulandu.” ");
INSERT INTO sbs_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Linu va mwi vañoli ni va Falisi chi vetava Jesu mi chi vaati, “Muluti, tu likumbuta ku vona chisupo chi zwa kwako. ");
INSERT INTO sbs_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Kono Jesu che tava naati kuvali, “Mu vilala ni lusika lusangu lu lola vulyo chisupo. Kono ka kwina chisupo chense chi vonwe konji chisupo cha Joona wa mupolofita. ");
INSERT INTO sbs_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Chokuti Joona ave kali mazuva otatwe ni masiku otatwe mwi vuumo lye inswi yikulite, mi na ye Mwan'a Muntu mwe kale mazuva otatwe ni masiku otatwe mwi kulo ye faasi. ");
INSERT INTO sbs_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Vaanakwame va munzi wa Nenive ka va zimane kwi katulo ni lusika lunu lwa suunu mi ka lunyanswe. Chokuti mu va sikuluhi chekutazo ya Joona, mi voone, zumwi mukulana kwa Joona kwena hanu. ");
INSERT INTO sbs_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Simwine wa mukulwakazi yo zwa kwa Mbowela ka zimane ni lusika lunu lwa suunu ni ku watulwa. U kazwila ku ma mani mani ye kanda ku keza kwi za kuzuwa za vutali bya Solomoni, mi voone, zumwi mukulwana kwa Solomoni kwena hanu. ");
INSERT INTO sbs_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Linu cwale luhuho luvilala haluzwa ku muntu ku yenda, lu yenda muzivaka zi sena menzi mi lu lola chi vaka cha ku pumula kono ka chi waniki. ");
INSERT INTO sbs_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Linu lu wamba kuti, 'Mu ni vole kuzuvo yangu ku ni vali kuhala.' Ha lu voola, lu ka wana kuti inzuvo yikulitwe hande mi ni ku vikwa hande. ");
INSERT INTO sbs_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Linu luyenda ni ku ka hinda zimwi yihuho zi kwanisa yiyaza ni tovele ku hita lyetanzi, mi yonse ni yenza kuhala mwateni. Linu mayemo a muntu ava mavilala kuhita lye tanzi. Mu ku ve vulyo vu vilala ni ku lusika lunu lwa sunu.” ");
INSERT INTO sbs_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Haho Jesu na si kwete ku wamba ku chilundwamanje, muvone, vanyina ni vanche va va zimene hanze ni va saka ku wamba kwali. ");
INSERT INTO sbs_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Zuumwi chati kwali, “Voone, va nyoko ni va chanko va zimene hanze, va sa ka ku wamba kwako.” ");
INSERT INTO sbs_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Linu Jesu che tava mi naati kwali ya va mu wambili, “Njeni Mayo? Mi nji vaani va chevangu?” ");
INSERT INTO sbs_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Linu cha wolola yi yanza lya kwe ku va lutwana mi cha ti, “Voone, ava nji va mayo ni va chevangu! ");
INSERT INTO sbs_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Chokuti yense wi chilila intato ya Taayo wina kwiwulu, uzo muntu mwa changu, mi nji nchizyangu mi nji maayo.” ");
INSERT INTO sbs_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Helyo izuva Jesu avayendi hanze yenzuoo ni kukala kwimbali ye wate. ");
INSERT INTO sbs_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Inyangela inkando iva kopene kumuzimbuluka, chechila mu chisepe ni kwikala mwateni. Inyangela yonse iva zimene helizo. ");
INSERT INTO sbs_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Linu Jesu chawamba zintu zingi kuvali mwi nguli. Chati, “Muvone, mubyali avayendi kukubyila. ");
INSERT INTO sbs_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Haba kukavubyala vulyo, imwi umbuto chiyawila kwimbali yenzila, mi zizuni chizakeza chizeza kuilya. ");
INSERT INTO sbs_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Imwi imbuto iba wili mwivu lya mabwe, uko kuisena iva wani ivu ilingi. Haho fele chiya mena, kakuti ivu kena livatungite. ");
INSERT INTO sbs_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kono izuva hali tanta, zivamenete chiza letuka kakuli kena zivena mihisi, mi chizazuma. ");
INSERT INTO sbs_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Imwi imbuko iva wili mu kati kezi samu. Masamu amwiya chia kula ni kuzi puputiza, ");
INSERT INTO sbs_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Imwi imbuto iba wili mwivu lina hande mi ziva biki vuheke, amwi makumi e kumi nikuhitilila, amwi makumi amana iyanza ni limwina, amwi makumi otatwe. ");
INSERT INTO sbs_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Eye yo zuwa, mumusiye atekeleze. ");
INSERT INTO sbs_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Valutwana chivakeza ni chivati kwa Jesu, “Chinzi howamba kwi nyangela mwinguli?” ");
INSERT INTO sbs_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesu chetava ni chati kuvali, “Muvahewa inswenelo yaku zuwisisa inkunutu zamuvuso wa kwiulu, kono kuvali kena kevava hewa. ");
INSERT INTO sbs_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kakuti yense yo wina, kwali kahewe zingi, mi kakwi zule kwali. Kono yense ya sena, kwali kanyangwe ni chakwete. ");
INSERT INTO sbs_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Cwale niwamba kubali che nguli, kakuti ni haike vavona, kava vonisisi. Mi nihava zuwa vulyo, kavazuwi, mikava zuwisisi. ");
INSERT INTO sbs_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kuvali chipolofita cha Isaya chivezuzilizwa, chita kuti, 'Chotekeleze uzuwa kono kete uzuwisise, chololete uvona, kono kete uvonisise. ");
INSERT INTO sbs_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","kakuti vantu inkulo zavo chiza nuna, mi vakukutu kuzuwa, mi vave yali menso avo, ili kiti senzi vavoni ni menso avo, kapa kuzuwa chamatwi avo, kapa kuzuwisisa che nkulo zavo, ili kuti vasandumuke hape, mi nini vavahozi.' ");
INSERT INTO sbs_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Kono chi tonofezwe menso enu, kuti avone; ni matwi enu, kuti azuwe. ");
INSERT INTO sbs_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Cheniti ni miwambila kuti vungu bwa vapolofita ni vantu valukite vatavela kuvona zintu zimuvona, mi kana vavaziboni. Vatabela kuzuwa zintu zimuzuwa, mi kana vavazizuwi. ");
INSERT INTO sbs_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Muteke kwi nguli ya mubyali. ");
INSERT INTO sbs_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Linu yense muntu hazuwa linzwi lya muvuso kono kali zuwisisi, haho vantu vavi vakeza kwiza kuhinda cha byalite mwi nkulo yakwe. Iyi nji mbuto iva byaliwe kwimbali ye nzila. ");
INSERT INTO sbs_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Iye yava byalwa hevu lya mabwe njo zuwa linzwi ni kulitambula cho kusanga haho. ");
INSERT INTO sbs_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Mi kena mihisi iye mwine kono ukwata vulyo inako zana. Linu manyando kapa kwihaiwa chikwava kwateni chevaka lye nzi, ka sitatale njiho haho. ");
INSERT INTO sbs_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Yavabyila mukati ke zisamu zamiya, uzu njiyena yozuwa linzi, kono kuvilelela ifasi nikusaka ahulu chifuma zi sina linzwi ni kusaha miselo. ");
INSERT INTO sbs_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Yavabyilwa he ivu ilotu, uzu njo zuwa linzwi nikuli zuwisisa. Uzu njo vikava miselo, ni yoilima; imwi makumi a kumi nikuhitilila, imwi mashumi akwanisa iyanza ni lyonke, imwi makumi otatwe. ");
INSERT INTO sbs_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesu chavaha imwi inguli. Chati. “Muso wa kwiwuulu ukola sina ili muntu yabyali intanga zilotu mwiwa lyakwe. ");
INSERT INTO sbs_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kono vantu nivalele, zila zakwe nazo chizakeza kubya mumukula mukati ka vuloto ni kuyenda. ");
INSERT INTO sbs_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Linu vuloto havukula mena ni kuvika miselo mukula nawo chiwavoneka. ");
INSERT INTO sbs_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Valeki vamwine waluwa chivakeza chivati kwali, 'Unkoshangu, kena uvabyali intanga zina hande muluwa lwako? Chinzi hachikuwanika mukula?' ");
INSERT INTO sbs_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Chati kuvali, 'Yonitoyete nja vapangi vulyo,' Vatanga vakwe chivati kwali, 'Cwale usaka kuti tuka zinyukule mwateni?' ");
INSERT INTO sbs_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mwina luwa chati, 'Nee, kakuti chi mwakanyukula mwateni mukula, pona chimuka nyukulilila ni vuloto. ");
INSERT INTO sbs_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Muzisiye zikulille hamwina kulindila inkutulo. He nako ye nkutulo kaniwambe kuva kutuli, “Chentanzi munyukolo mukula ni kuisumina mañata kuti uhisiwe, kono mukunganye vuloto muzishete zangu.'”” ");
INSERT INTO sbs_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesu chawamba imwi inguli kuvali, chati, “Muvuso wa kwiul ukola sina intanga ya masitete iyo muntu yavahindi ni kubyala muluwa lwakwe. ");
INSERT INTO sbs_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Iyi imbuto inini kwimbuto zonse. Kono haiva ya byalwa hande, inkando kuzi chalano za muluwa. Ikula iva isamu, mi zizuni ze wulu zikeza kuzaka zizumbo kumitayi yalyo. ");
INSERT INTO sbs_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesu linu chavawambila imwi inguli. “Muvuso wakwiulu ukola ili chivilisa icho mwanakazi avahindi ni kukopanya ni ntikanyo zo tatwe za busu konji hakufunduluka.” ");
INSERT INTO sbs_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Zonse inzi zintu Jesu avaziwambi kwinyangela mwinguli. Mi kwanda yenguli kakwina chavawambi kuvali. ");
INSERT INTO sbs_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Iyi ivavi intaelo kuti chonse chiva vawambwa chamupolofita chiwola kuba init. Haho chati, “kaniyalule kaholo kangu mwinguli. Kani wambe zintu zibapatitwe kuzwa kumatangizo inkanda. ");
INSERT INTO sbs_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Linu Jesu chasiya chichava nikuya mwinzuvo. Valutwana bakwe chivakeza kwali mi chivati, “Tutolokele inguli ya mufuka mwiwa.” ");
INSERT INTO sbs_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesu chetaba chati, “Yababyali intanga zina hande Mwana wa Mulimu. ");
INSERT INTO sbs_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Luwa inkanda; Mi intanga zina hande, izi vana va mubuso, mufuka vana va satani. ");
INSERT INTO sbs_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mi chila chivazibyali nji diavulusi. Inkutulo njimamanimani e nkanda, bakutuli mañiloyi. ");
INSERT INTO sbs_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Hakuva vulyo, mukula kaukunganye nikuhiswa chamulilo, njete kuve njimamanimani e nkanda. ");
INSERT INTO sbs_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwana muntu ka tumine mañiloi akwe, mikava kunganyeze hanze ya muvuso zintu zonse zileta chivi, niva vapanga vulilala. ");
INSERT INTO sbs_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Kavava sohele mwilyanga lilo, uko kavakalile nikukwecha meeno. ");
INSERT INTO sbs_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Linu bantu balukite kavavenye sina izuva mumubuso weshevo. Iye yowina matwi, musiye atekeleze. ");
INSERT INTO sbs_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Muvuso wa kwiulu ukola ili ibwe lya butokwa lipatitwe muluwa. Muntu abaliwan mi chalipata. Mwintavo ya kwe chayenda, ku uza zintu zonse zavakwete, nikuula ulo luwa. ");
INSERT INTO sbs_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Hape muvuso wa Mulimu ukola ili muntu yo patehete kukavulola mabwe abutokwa. ");
INSERT INTO sbs_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Hawana ibwe lina maemo ena hande, avayendi nikukauza zintu zakwe zonse zava kwete nikuliula. ");
INSERT INTO sbs_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Hape, muvuso wa kwiulu ukola ili kanyandi kavasohelwa mwi wate, kavachesi mufutafuta ye zintu. ");
INSERT INTO sbs_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Linu hakezula, muyambi chaka kwitila hamutunda. Linu chivekala hansi ni ku kunganya zintu zilotu muchiseye, mi zintu zivi zivasohelwa kwimbali. ");
INSERT INTO sbs_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Mukuve mweyi inzila kumamanimani inkanda. Mañiloi muakeze kukauhanya vavi mukati ka vantu valukite. ");
INSERT INTO sbs_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Kavava sohele mwi bimbililo lya mulilo, kwete vakahye niku kwecha meeno. ");
INSERT INTO sbs_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Mwazizuwisisa nzose izi zintu?” Valutwana chivati kwali, “Eni, “ ");
INSERT INTO sbs_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Linu Jesu chati kuvali, “Hakuva vulyo vañoli vonse vavavi valutwana ku muvuso weulu vaswa ili nji muntu yeli mwine we nzuvo. Yozwisa zakale ni zintu zihya muchifumu chakwe.” ");
INSERT INTO sbs_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Linu nichiya keza kuva vulyo Jesu hamana izi inguli, cha katuka kuzwa mwe chochivaka. ");
INSERT INTO sbs_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Linu Jesu che njila muchi kiliti chakwe ni kuluta vantu mumasinagoge avo. Inkalavo ivali kukomokwa ni kuti, “Kanti uzu mutu uwana kuhi vutali ne zi imakazo kuhi? ");
INSERT INTO sbs_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Uzu muntu kena mwana wa muvezi? Kena vanyina nji Maria? Ni vanche kena nji Jamusi, Josefa, Simone ni Judasi? ");
INSERT INTO sbs_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ni vanchizya kwe kavakwina mukati ketu? Cwale uzu muntu uwana kuhi zonse izi zintu?” ");
INSERT INTO sbs_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Vava vengwiswa kwali. Kono Jesu chati kuvali, “Mupolofita uswanela kukutekiwa kuunde mwinkanda yakwe ni kuvaluhasi lwakwe. ");
INSERT INTO sbs_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Mi kena ava pangi imakazo zingi kwateni chevaka lyakuvula intumelo. ");
INSERT INTO sbs_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Che yo inako, Heroda munyandisi a zuwa za kavuvo ka Jesu. ");
INSERT INTO sbs_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ni chawamba ku vahikana vakwe, cha ti, “U zu nji Joani Mukolovezi, a vakavuki kuvafwile. Ni hakuva vulyo aa maata a chikwete kuseveza kwali.” ");
INSERT INTO sbs_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Chokuti Heroda a vakwete Joani, ni ku musumina, ni kumuvika muitolongo chevaka lya Herodiasi, muihabwe wa Filipi mwanche wakwe. ");
INSERT INTO sbs_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Chokuti Joani a vati kwali, “Kahena mulao kuti u ve naye nali mwihenu.” ");
INSERT INTO sbs_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Heroda ava kuswanela kumwihaya, kono a vatiyi vantu, chokuti va va kumuhinda kuti mupolofita. ");
INSERT INTO sbs_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Kono izuva lya kupepwa kwa Heroda halisika, mwana wa Hedodiasi wa mukazana ava zani mukati mi chatavisa Heroda. ");
INSERT INTO sbs_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Chakutava, cha sepisa cha kukonka kumuha chonse chete akumbile. ");
INSERT INTO sbs_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Hamana kuhewa mulao kuvanyina, chati, “U nihe hahanu, mukasuva, mutwi wa Joani Mukolovezi.”. ");
INSERT INTO sbs_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Simwine ni cha filikanywa hahulu chekupo yakwe, kono che vaka lya kukonka, ni chalivaka lya vo vavakulya naye, ni cha laula kuti kutendahale vulyo. ");
INSERT INTO sbs_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","A ba tumini ni ku kakosala Joani mwintolongo. ");
INSERT INTO sbs_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mi mutwi wakwe wa letwa mukasuva ni kuhewa ku mukazana mi cha utwalila va nyina. ");
INSERT INTO sbs_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Valutwana va kwe ni chivakeza, ni kuhinda chitupu, ni ku chizika. Ha vamana kuchita ezo, chi va yenda ku ka wambila Jesu. ");
INSERT INTO sbs_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Hohwaho Jesu ha zuwa izo, a zwa muchivake echo ni chisepe ku ya kuchivaka chilikawile. Inyangela ha i zizuwa, chiya mwichilila chamatende kuzwa mwitolopo. ");
INSERT INTO sbs_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Linu Jesu chakeza kubusu bwabo mi ni chabona inyangela. Cha vafwila mañeke ni ku hoza vakuli va vo. ");
INSERT INTO sbs_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Chiminemine chezuba ha chisika, valutiwa vakwe chi bekeza kwali chibati, “Chinu chibaka kachina vantu, mi izuva chilyemina. Hasanye inyangela, ilikuti bayende muminzi ni kukaliwulila zilyo.” ");
INSERT INTO sbs_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Kono Jesu chawamba kuvali, “Kavena intuso ya kuya kule. Inwe muvahe chimwi chakulya.” ");
INSERT INTO sbs_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Chivati, “Twina hanu zinkwa bulyo zi kwanisa iyanza ni nswi zovele.” ");
INSERT INTO sbs_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesu chati, “Muzilete kwangu.” ");
INSERT INTO sbs_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Cwale Jesu a laula inyangela kuikala halyani. Chahinda zinkwa zi kwanisa iyanza ni nswi zovele. Na lolete kwiulu, chatoholofaza ni kucholola zinkwa ni kuziha valutwana. Valutwana chi vaziha inyangela. ");
INSERT INTO sbs_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Vavali ni kuikuta. Linu chibahinda vungululwa -vuvezuli zitanda zi na ikumi ni zobele. ");
INSERT INTO sbs_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Vonse va valyi, va va kusaka kusika kuvakwame va zikiti zi zikwanisa iiyanza, kuzwisa vanakazi ni vahwile. ");
INSERT INTO sbs_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Hohwaho vulyo chawambila valutwana vakwe kukwela muchisepe balitangize kwali kwimwi mbali, mikuti iye mwine ha situmina inyangela kule. ");
INSERT INTO sbs_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ha mana kuboza bungi bwabantu, chayenda heulu lyelundu yenke kukalapela. Linu chitengu ha chikolela a bena uko yenke. ");
INSERT INTO sbs_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kono chisepe icho chi chivena hakati kewate, chi chivakupala kuyendiswa chevaka la mandinda, chokuti luhuho lu va kuchikanisa. ");
INSERT INTO sbs_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mwinako ya bune ya masiku Jesu cha chuutila kubali, na yenda hewate. ");
INSERT INTO sbs_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Valutwana ha va muvona na yenda hewate, va vatiyi hahulu, ni chi bati, “Isaku,” mi chi vahuwa hahulu chakutiya. ");
INSERT INTO sbs_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kono Jesu cha wamba kuvali haho ni chati, “Mukole! Njeme! Kanji mutiyi.” ");
INSERT INTO sbs_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pitorosi cha mwitava chati, “Simwine, haiva nje we, ni laele ni niize kwako hamenzi. ");
INSERT INTO sbs_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesu chati, “Wize.” Cwale Pitorosi cha suka muchisepe ni kuyenda ha menzi kuya kwa Jesu. ");
INSERT INTO sbs_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kono Pitorosi ha vona luhuho, chatiya. Hakalisa bulyo kumina, cha huwa ahulu chati, “Simwine, nihaze!” ");
INSERT INTO sbs_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jesu haho vulyo cha otolola iyanza lyakwe, cha kwata Pitorosi, mi ni chamulwila kuti, “Iwe we ntumelo inini, chinzi hohonona?” ");
INSERT INTO sbs_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Linu cwale Jesu ni Pitorosi chiba yenda muchisepe, luhuho chilwa siya kuhunga. ");
INSERT INTO sbs_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Cwale valutwana muchisepe chiva lapela Jesu chibati, “Cheniti u Mwana Mulimu.” ");
INSERT INTO sbs_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ha chiva lutite, chi venjila munkanda ya Genezareta. ");
INSERT INTO sbs_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Linu vantu mwechina chibaka chivalemuha Jesu, chivatumina mañusa monse muzivaka zimbulukite chilalanda, mi chivamuletela vonse vavakulwala. ");
INSERT INTO sbs_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Chibamukumbila kuti vakwate vulyo kumungundo we chizwato chakwe, mi vungi vu vakwati kwateni chibwahola. ");
INSERT INTO sbs_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Linu Vafalisi ni bañoli bamwi babezi kwa Jesu kuzwa Jerusalema. Nivati, ");
INSERT INTO sbs_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Chinzi varutwana bako havaluta chisiyakulu chabatanzi? Mukuti kabashanji mayanza avo habalya.” ");
INSERT INTO sbs_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesu abetavi mi navawambila kuti, linu inwe - hamurwisa idaezo ze Reeza ivaka lyachisiyakulu chenu chinzi? ");
INSERT INTO sbs_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Mukuti Ireeza avati, 'Uhe ikute kweso ni nyoko,' mi 'Iye yowamba bubilala kwesi ni nyina, ikumbya kafwe.' ");
INSERT INTO sbs_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kono mute kuti, 'Yense yeti nati kubesi ni banyina, “Ituso yonse yimubali kuyelele kuwana kwangu linu chili impo iya kweReeza,” ");
INSERT INTO sbs_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","uzo muntu kayelele kukuteka besi. Chenzila yina bulyo wazimbuluka inzwi lye Reeza chevaka lachisayakulu chenu. ");
INSERT INTO sbs_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Inwe balihele, Isaya avapolofiti chakusima kazenu havati, ");
INSERT INTO sbs_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Aba bantu banikuteka chatuholo twavo, kono inkulo zabo zina kule name. ");
INSERT INTO sbs_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Banilapela ni basawani chimwi, kakuli itumelo ivaruta izimene hetaelo zamuntu.” ");
INSERT INTO sbs_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Linu chalisupila ikunga ni kuliwambila kuti, “Mutekeleze ni kuzuwisisa - ");
INSERT INTO sbs_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kakwina chinjila mukaholo chiizuza muntu ikwe. Muchibaka chobulyo, chizwa mukaholo, njecho chiizuza muntu ikwe.” ");
INSERT INTO sbs_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Linu barutwana babezi ni kuwambila Jesu, “Kana wizi kuti bafalisi babanyelwa habazuwa ichi chiwambo?” ");
INSERT INTO sbs_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesu avetavi mi nati, “Chimenantu chonse chasanaavabyali Tayo wakwiwulu kachinyukulwe ni kusohelwa kunze. Mubasiye bobona, bahitili bazihofu. ");
INSERT INTO sbs_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mi heva muhofu nahitila muhofu kunine, vonse kabawile mwilindi.” ");
INSERT INTO sbs_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pitorosi avetabi mi nati kwa Jesu, “Tutolokele iyi nguli.” ");
INSERT INTO sbs_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesu nati, “nanwe muchiikele nimusena inkutwisiso? ");
INSERT INTO sbs_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Inwe kamuboni kuti chonse chiinjila mukaholo chihita kuya mwibumu mi linu chikazwa kuya muchimbuzi?” ");
INSERT INTO sbs_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kono zintu zizwa mukaholo zizwa kunkulo. Nji zintu ziizuza muntu ikwe. ");
INSERT INTO sbs_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kakuli munkulo kuzwa mihupulo mibilala, vwihai, bubuki, zakusomana, busa, kupaka zamapa, ni kutukana. ");
INSERT INTO sbs_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ezi nji zintu ziizuza muntu ikwe. Kono kulya ni mayanza asasambite kakwiizuzi muntu ikwe.” ");
INSERT INTO sbs_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Linu Jesu chayenda kuzwa mwecho chibaka kulikungula ni kuya muzikiliti zamileñi iba Tire ni Sidoni. ");
INSERT INTO sbs_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mi hamulole, mwanakazi wa Mukanana abezi kuzwa mwechina chikiliti. Mi chahuweleza mi nichati, “Nifwile inse, Simwine, mwana a Daafita, mwanangu wamukazana ukatezwe madimona.” ");
INSERT INTO sbs_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kono Jesu kana abamwitabi nanga inzwi. Barutwana bakwe babezi ni kumukumbila, ni bati, “Muhindikile kuna, kakuli utuchitala ilata.” ");
INSERT INTO sbs_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Kono Jesu abetabi mi nati, “Kana nibatumwa kozuhi nozuhi kunze yembelele izobete munzuvo ya Isilaele.” ");
INSERT INTO sbs_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kono iye neza nikwiza kufukama habusu bwakwe, nati, “Simwine, unituse.” ");
INSERT INTO sbs_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Netaba nati, “Kakuyelele kuhinda chinkwa chabahwile ni kuchiha tumbwazana.” ");
INSERT INTO sbs_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mwanakazi nati, “Eni Simwine, kono nanga tumbwazana tulyanga ziwanga kumilomo hetafule ibafumwa to.” ");
INSERT INTO sbs_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Linu Jesu abetavi mi abati kwali, “Mwanakazi, itumelo yako inkando. Usiye kutendahale kwako sina mosakila.” Mi mwanakwe abaholi chehola iswana. ");
INSERT INTO sbs_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesu abasiyi icho chibaka mi nayenda kumbali ni Iwate la Galileya. Kuzwaho abatanti kuya helunduzana ni kukekala hateni. ");
INSERT INTO sbs_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ikunga ikando nilyeza kwali. Nibaleta bachukuta, bahofu, basatambi, ni basayendi, ni bamwi babali kulwala. Ni babaleta hamatende a Jesu, mi nabahoza bonse. ");
INSERT INTO sbs_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Chobulyo ikunga nilyamakala chabukando hababona basatambi kuti chibawamba, bachukuta chibaba nenza, basayendi chibayenda, ni bahofu chibabona. Niba lumba Ereeza wa Isilaele. ");
INSERT INTO sbs_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesu abasupi barutwana bakwe mi nati, “Nifwila ikunga inse, mukuti chibabekali name mazuba otatwe mi kakwina chibabali. Kanisuni kubalukulula ni basalile, kokuma sanzi bazuminini munzila.” ");
INSERT INTO sbs_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Barutwana nibawamba kwali ni bati, “Katuwane kuhi mañende azinkwa mwihalaupa likena buti kuti tufepe ikunga ikando buti?” ");
INSERT INTO sbs_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesu nabawambila kuti, “Mwina mañende ongahi?” Babetabi kuti, “Amana iyanza ni obele, ni tunswi tulikene.” ");
INSERT INTO sbs_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Linu Jesu nalaela ikunga kwikala hansi. ");
INSERT INTO sbs_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nichahinda mañende amana iyanza ni obele ni nswi, mi hamana kulitumela, ni changamona mañende ni kwaha kubarutwana bakwe. Barutwana nibaha mañende kwikunga. ");
INSERT INTO sbs_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Bantu bonse nibalya ni kuikuta. Mi nibakunganya zilyo zibashali zibangamoki tukoto, zitanda zimana iyanza ni zobele ni zezula. ");
INSERT INTO sbs_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Babali ibali balule bone, kuzwisa kwateñi banakazi ni bahwile. ");
INSERT INTO sbs_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Linu Jesu chalukulula ikunga mi nenjila muchikepe ni kuya muchikiliti cha Magadani. ");
INSERT INTO sbs_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mafalisi ni Masadduki chibeza ni kulika Jesu ka kumubuza kuti aba tondeze chisupo chizwa kwiwuli. ");
INSERT INTO sbs_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Mi na betaba kuti “chiminemine chezuba ha chisika mu wamba kuti bwikalo bwe wulu mubube hande, kakuti iwulu chili subilile. ");
INSERT INTO sbs_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Imi chimeneko mu wamba kuti, “Mazimo ewulu mwabe mabi kakuti kwiwulu busubile.” Mwizi kutoloka zintu zitondezwa mwiwulu, kono ka mwizi kutalusa zitondeza inako. ");
INSERT INTO sbs_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mulahi wa chive ni busangu u saka chitondeza, mi kakwina chitondeza konji Joani.” Linu Jesu cha katuka ku yenda ni kuba siya. ");
INSERT INTO sbs_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Balutwana chibakeza kwi ishilya limwi, kono chibazibala kuhinda zinkwe. ");
INSERT INTO sbs_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesu cha wamba kuti, “mu mamele mulungo wa Mafalisi ni Masadduki”. ");
INSERT INTO sbs_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Balutwana chiba kopanya mihupulo ni ku wamba kuti, “kakuti kena tweza ni zinkwa”. ");
INSERT INTO sbs_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesu chaba lemuhite zoose mi chawamba kuti “Inwe be ntumelo inini, cinzi hazeza bulyo mukati kanu ni kutakuti kakuti kena mwahinda zinkwa? ");
INSERT INTO sbs_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kana muzeza za zinkwa zibali kupanga iyanza, zibakwani bantu bena 5.000, mi zitanda zongayi zi mube zuzi? ");
INSERT INTO sbs_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Kapa zinkwa zibena iyanza ni zobele ku bantu ba bena 4.000, mi zongayi zitanda zi mu bahindi? ");
INSERT INTO sbs_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ha mu sazuwisisi chinzi kuti kani wamba nanwe za zinkwa? Mukole ni ku mamela za mulungo wa Mafalisi ni Masadduki.” ");
INSERT INTO sbs_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Linu chiba muzuwisisa kuti kena a talusa za mulungo, kono kumamela intuto ya Mafasi ni Masadduki. ");
INSERT INTO sbs_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Haho Jesu cha keza ku munzi umwi wa Chaesarea Filipi, chabuza balutwana bakwe, kuti, “Njozuhi bantu u bata kuti nji Mwan'a Muntu?” ");
INSERT INTO sbs_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Chibe taba kuti, “bamwi ba wamba kuti njeye Joani yokolobeza, bamwi nji Elija, mi bamwi bati nji Jeremia, kapa zumwi wa bapolofita.” ");
INSERT INTO sbs_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Chati ku bali, “Chwale inwe muti Njemeni?” ");
INSERT INTO sbs_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Chikwe taba Simone Pitrosi cati, “Njewe Keresite, mwan' a we Reza yohala.” ");
INSERT INTO sbs_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesu chetaba ni ku muta kuti, “Intohonolo nji yako Simone mwan' a a Joana, kakuti kena inyama kapa malaha, za ku cheniseza, kono nji Tayo wa kwiwulu. ");
INSERT INTO sbs_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Imi name niti njewe Pitorosi, ibwe hente nizake inkeleke yangu. Milyango ya bafwile kente ni iizunde. ");
INSERT INTO sbs_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ka ni kuhe inkiyi za mubuso wa kwiwulu. Chonse cho sumina hansi ni kwiwulu kaci suminwe, hape chonse cho sumununa hansi ni kwiwulu muchi sumununwe.” ");
INSERT INTO sbs_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Linu Jesu chalaela balutwana bakwe kuti kana bawambili ni haike muntu umwina kuti njeye Keresite. ");
INSERT INTO sbs_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kuzwa heyo inako Jesu, chatanga ku wambila balutwana bakwe kuti cho kutameha kuyenda kwa Jerusalema, mi kusukuluka kakube kungi mu manza a bentanzi, bañoli, ni bakulwana ba mapulisita, kwi haiwe, ni kubuswa kubola ku kuhala mwizuba lya butatu. ");
INSERT INTO sbs_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Linu Pitorosi na mukungwila kwimbali na munyasa nati, “Ichi chintu chibe kule nawe, Simwine, sanzi chitendahali kwako”. ");
INSERT INTO sbs_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Kono Jesu cha chebuka ni kuta Pitorosi, kuti “zwe kwangu, Satani! U chi sitataliso kwangu. Iwe kobilaela ni zintu ze Reeza, kono zintu za buntu.” ");
INSERT INTO sbs_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Linu Jesu cha wamba ku balutwana bakwe, “Heba kwina usaka kuni chilila, uswanela ku lisungula, a hinde chifapano chakwe, ni kuni chilila. ");
INSERT INTO sbs_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Muntu yense usaka buhalo bwakwe mwa bu mayiba, kono yo sinyehelwa buhalo bwakwe ke baka lyangu mwa buwane. ");
INSERT INTO sbs_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ka chi muhenzi muntu kuti a mune inkanda yonse kono umaninwa buhalo bwakwe? Chinzi muntu cawola kuha kuti a wane buhalo bwa kwe? ");
INSERT INTO sbs_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mwan' a Muntu mwe ze mwinkanya Yesi ni mañiloyi a kwe. Linu njente ahe muntu ni muntu impo kakuya ka zintu za batendi. ");
INSERT INTO sbs_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ikumbya ni mi wambile buniti, kwina bamwi bazimene hanu, kense ni ba bone bakane lufu konji chi ba bona Mwan'a Muntu neza mu mubuso wakwe. ");
INSERT INTO sbs_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mazuba a mana iyanza ni limwina chinga amana Jesu chahinda Pitorosi ni Jakobo, ni Joani mwa chakwe, mi caba ntwala he lundu li nyemukite abo bene. ");
INSERT INTO sbs_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ca sanduka ha hasu bwabo. Vuluvi bwakwe cibwa sanduka ku benya sina izuba, zizwato zakwe cizasanduka sina iboni. ");
INSERT INTO sbs_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mubone cikwa boneka Mushe ni Eliia niba wambola naye. ");
INSERT INTO sbs_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pitorosi ce taba, kwa Jesu. “Simwine, kambe kuwolekaa. Nitwe kala ha hanu halotu kuhitiliza. Haiba usaka, linu ime nina zaka zitomba zo tatwe chimwi cibe cako, chimwi ca Mushe, ni chimwi ca Eliia.” ");
INSERT INTO sbs_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ha ba kwete kusi wamba, hamulole, muzunde we kope licena ciweza kuba wumba cikwa zwa izwi libali kuzwila mwikope ci, lyati. “Uzu nji Mwanangu inisuni kuhitiliza, ini kantwa, Mu muzuwe.” ");
INSERT INTO sbs_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Balutwana bazuwa, ciba suha nikuwa ca bulubi. ");
INSERT INTO sbs_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Linu Jesu ceza ni kuba kwata cati, “Mubuke musiye kutiya.” ");
INSERT INTO sbs_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Linu ci ba buka kono kena baba boni mutu konji Jesu yeke. ");
INSERT INTO sbs_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Haba suka hasi kuzwa he lundu, Jesu caba laya “kuti kanji ba wambili mutu mane nanga yeke ziba bona konji Mwana Muntu caka buka kuva fwile.” ");
INSERT INTO sbs_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Balutwana ciba buza “cizi bañoli havati kuti Eliia eze lwe tazi?” ");
INSERT INTO sbs_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesu cetava niku wamba kuti, kuwamba vuniti, “Elia mweze za boze zintu muzi be kalile. ");
INSERT INTO sbs_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kono nimi ta kuti, Elia ca vezite kale, kono kana vava mwizivi civa panga zose zivava kusaka. Mwi zila iswana, Mwana Muntu mwa nyandiswe mu mayaza avo”. ");
INSERT INTO sbs_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Valutwana vakwe civa lemuha kuti uwamba Joani yo koloveza. ");
INSERT INTO sbs_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Cinga vasika hakunganine batu, muntu ceza kwali, ca fukama havusu vwakwe, naco kuti, ");
INSERT INTO sbs_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Simwine, fwile mwanangu inse, ulwala vutuku vwa kuzuminina unyanda maswe. Hamwi uwilinga mu mulilo kapa mu mezi. ");
INSERT INTO sbs_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Niva muletete kuva lutwana vako, niva kangwa ku muhoza.” ");
INSERT INTO sbs_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesu cetava cati, “Murahi usa zumini utenda zi fosahele, Kani kale nanwe inako ikumahi? Mulete kunu kwangu.” ");
INSERT INTO sbs_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesu cakalimela luhuho lubilala. Muhwile cahola mwi nako yeyo. ");
INSERT INTO sbs_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Balutwana ba Jesu chiveza kaku liwungula ku vamwi niku vuza, “cizi hatwa kangwa ku zwisa luhuho luvilala?” ");
INSERT INTO sbs_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesu ca wamba kuvali, “kakuli mwina itumelo inini. Ni mi wambila vuniti vwizwile, hamuva nitumelo sina itanga yamasitete, muwola kuwambila ilundu, “zwaho uyende kuna,” muliyende ka kwina cense cili kanise. ");
INSERT INTO sbs_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kono ulu luhuho lubilala kalu zwi feela haisi ca kulapela wa kuli nyima zilyo.” ");
INSERT INTO sbs_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Niva sina mwa Galilea, Jesu ca wambila va lutwana vakwe, “Mwana muntu mwa tambikwe muma yaza abatu. ");
INSERT INTO sbs_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Mi muva mwi haye, mi mwi zuba lyabutatu mwa vuswe kuba fwile.” Mi ikulo zaba lutwana vakwe ciza coka luli. ");
INSERT INTO sbs_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Chinga vasikna mwa Kapenauma, mukwame yo bona zamutelo nicha buza Pitorosi mane muruti wenu mane ulihanga mutelo? ");
INSERT INTO sbs_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Chati, “Eni” ulihanga. Kono Pitorosi cha yenda muzubo, Jesu cha wamba lwetanzi, “iwe uhupula vule Simoni? Masimwine be kanda va tambula mitelo izwa kubani? Kubazwa kule kamba kubatu bave kala navo?” ");
INSERT INTO sbs_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pitorosi chinge taba kuti, kubatu “bazwakule,” Jesu cha mucho kuti “batu be chinsi kaba zumininwe kuliha mutelo. ");
INSERT INTO sbs_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kanji tuleteli yo lola zamitelo chivi, Yende kwi wate, kasohele kashuto kako mu mezi, Hinde iswi ye tazi wi yalule mulomo wayo mowane isheleni, uka itambike yobona zamitelo muchisa changu ni chako.” ");
INSERT INTO sbs_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mwinako iswana. Jesu “abawambi kubaluti bakwe njeni mukando mwiulu.” ");
INSERT INTO sbs_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesu casumpa muhwire nikumubika mukati kabo, ");
INSERT INTO sbs_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“ikumbya ni wamba kwenu Konji hosanduka niku swana sina bahwile banini, kakwina mowolela kwi njirira mumubuso wa kwi ulu. ");
INSERT INTO sbs_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Cwale muntu uliboza mwi konde Sina Muhwile Munini, muntu yoswana nji mukando mumubuso wa kwiulu. ");
INSERT INTO sbs_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Yense yotambula muhwire munini mwi zina lyangu watambula ime. ");
INSERT INTO sbs_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yense yoletisa kuti aba bahwire bachite bubi, kwina butuka kuti asuminwe ibwe ikando mwinsingo, nikumusohela mubuliba bwe wate. ");
INSERT INTO sbs_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Bumai kwinkanda kakuli inako celi za kucuncula! Ka kuli kwina butokwa kuti izo inako zikeza! Kono bumai kacozo muntu izi inako kazize cakwe! ");
INSERT INTO sbs_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Haiba iiyanza lyako kapa itende lyako likuletela kuwa, likosole kwateni ni kulisohela kule nawe. Kwina butuka kwako kwi njila mubuso wakwilu ni uli cihole kwanda kuuti usohelwe mumulilo usazimi ni wina onse mayanza ni matende. ");
INSERT INTO sbs_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Haiba linso lyako likuleteza kufosai, lizwise mo ulisohele kule nawe. Kushiyeme kwako kwi njila mubuso wakwilu nilinso lyonke kuzamba kusohelwa mulyangalilo niwina menso obele. ");
INSERT INTO sbs_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ubone kuti kanzi unyansilizi zumwi waba bahwile. Nimiwambila kuti mwiwulu mangeloi abo inako yonse a lolete habusu bubaTayo bena kwiwulu. ");
INSERT INTO sbs_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kakuti mwana muntu a vakezi kukuhaza cizovete. ");
INSERT INTO sbs_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Muhupula nzi? Muntu wina imbelele zicita mwanda, cikwazoba hateni yonke, ketico siya zimwi zicita makumi acita iyanza ni zone zibaka zama luundu ni kukagana imwiina yazoba? ");
INSERT INTO sbs_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","mi haiwana, ikumbya ni miwambila, kasangalala cayo kuhita izo zina makumi a cita iyanza ni toone ni yanza ni toone zisana za zooba. ");
INSERT INTO sbs_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mwinzila iswana kahena kusuna kwe Tayo wina kwiwulu kuti imwina kazenini i zenengehe. ");
INSERT INTO sbs_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Haiba mukwako wakufosekeza, yende, mu tondeze mulandu wakwe mukati kaako naye. Haiba naa kutekeleza ciwa muwola mwaako. ");
INSERT INTO sbs_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kono haiba nasateeki kwako, uhinde ipaki imwina kapa zobele zimwi, njo kuti tuholo twabantu bobeele nandi botaatwe kuba ipaki lenzwi ni inzwi. ");
INSERT INTO sbs_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Linu haiba na kaana kutekeleza kubali, wambe i ndaba Kwi nkeleke. Haiba naakana kuzuwa kwi nkeleke, muhinde sina mulicaba ni mutelisi. ");
INSERT INTO sbs_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Chabusakusima ni kuwambila, chonse chintu chisuminwe hansi ni kwiwulu chisuminwe. Chonse chisumuninwe hansi ni kwiwulu kachisumununwe. ");
INSERT INTO sbs_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kwekeza henzo nimiwambila kuti, haiba mububeli bwenu muzuminzene hansi kuamana ni chimwi ni chimwi chonse chimukumbila, chintu ni chintu chibakumbila, kabachitendelwe ne Tayo wina kwiwulu. ");
INSERT INTO sbs_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mukuti konse kwina bobele kapa botatwe bakopene hamwina mwizina lyangu, ime kanibe mukati kabo.” ");
INSERT INTO sbs_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Linu Pitorosi chabuza Jesu, “Simwine, tongai mwaangu twa wola kuni fosekeza mu kuti nimu swalele? Kwanda twina iyanza nito beele?” ");
INSERT INTO sbs_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesu na muti, “kaniku wambili twe iyanza ni to beele, kono makumi eyanza ni obeele makumi. hape. ");
INSERT INTO sbs_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Cheyo inzila ipuso yekwiwulu ibambanywa ni simwine zumwi yaba sake namanise chikoloti ni muhikana kwe. ");
INSERT INTO sbs_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Habati batangise za kushiamisa, muhikana umwina abaletwa kwali yabali kumukolota italenta zichita zikiti zina ikumi. ");
INSERT INTO sbs_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kono ibaka lakuti kanabena mwawola kuitabila, mfumwakwe chalaela kuti awuzwe, hamwina ni mwihyabwe ni bahwile ni zonse zabena naze, ibaka le ntifo i tendwe. ");
INSERT INTO sbs_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Linu muhikana chawila hansi, ni kukubama habusu bwakwe, mi nati, 'Mfumwangu, munifwile inse, mi kanikulihe zonse.' ");
INSERT INTO sbs_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Chobulyo mfumu wamuhikana, kakuli ababi ni nse, abamulukululi nikuswalela chikoloti chakwe. ");
INSERT INTO sbs_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Muhikana uzo na yenda kunze mi naka wana ba mwaakwe, ya bali kumu kolota ikumi lwa mali na mu fwañata. Ni kumu kwatila mumumino, mi nati, 'ni life co kolota.' ");
INSERT INTO sbs_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Kono mwaakwe wo mutanga na wila hansi ni kumu kumbila, nati, 'U ni kwatile, mi munikulihe.' ");
INSERT INTO sbs_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Linu muhikana wa matangizo nakana. Kwanda bulyo, nayenda ni kumusohela mwi ntolongo, kusikila hete namulihe zonse zo kolota. ");
INSERT INTO sbs_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Linu ba mwi batanga haba boona cibatendahali, baba bengi maswe. Nikwiza kuwambila mfumwe ziba chitahali. ");
INSERT INTO sbs_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Linu ifumwe wamuhikana na musumpa, namuti, 'iwe mutanga yo fosaheele, ni baku wondeli mulandu wako kakuli ubani kumbili. ");
INSERT INTO sbs_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kete no babi ni nse nawe kwa mwaako, ubu muni ba ku kwatili nawe?' ");
INSERT INTO sbs_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Simwine wakwe nabenga mi namuha mu mayanza aba nyandisi kusikila hete namane kuliha zonse za mukolwete. ");
INSERT INTO sbs_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Njekuti Tayo wakuwulu naye mwa tende mu kuswana, haiba zumwi ni zumwi wenu kate awasalele mwaakwe mwi nkulo.” ");
INSERT INTO sbs_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Linu chikwa sika inako Jesu ha mana awo mazwi, ni cha zwa mwa Galilea, linu choya ku museto wa Judea uvena mwi shila lya lwizi lwa Jorodani. ");
INSERT INTO sbs_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ikunga lya batu bangi niba mwichilile, linu chaka va hozeza kwateni. ");
INSERT INTO sbs_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mafalisi ni chibeza kwali, kwiza kumulika, “kana ku woleka kuti mukwame akauhane ni mwihyabwe kabu kavo bonse?” ");
INSERT INTO sbs_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesu nabe tava kuti, “kana mubavali iye mwine yaba vapangi kuzwa ku matangilo aba vapangi mukwame ni mwakazi? ");
INSERT INTO sbs_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Mukuti iye yaba vapangi avati kuti, 'chebaka mukwame mwa siye chivaka chibesi ni ba nyina aka kopane ni mwihyavwe?' ");
INSERT INTO sbs_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Linu boveree muvabe muntu umwina mwi nyama. Linu chava kopanyi Ireeza hamwina, kanji nikuvi niyete nachi kauhanye.” ");
INSERT INTO sbs_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Chiva wamba kwali, “chizi Mushe hava tulayi kuti uswanela ku hewa iñolo lye kauhano niku muhindika?” ");
INSERT INTO sbs_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Nicha betava kuti, “bakenyi chaku kukutuhala kwe kulo zenu Mushe aba mizuminini ku kawuhana ni bamwi hyenwanwe kono kuzwa kumatangilo keena ivali nji zila iyo. ");
INSERT INTO sbs_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ikumbya nimi wambila buniti, yense yo kana mwihyavwe isi ka mulandu wabu sangu, nikusesa wungi mwakazi upanga bushahi. Hape mukwame yosensa mwanakazi yava kanwa upanga bushahi.” ");
INSERT INTO sbs_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Balutwana chiva ti kwa Jesu, “Haiva mukwi kalille mona bulyo bulotu bakwame ni banakazi kanji basesi ni kuseswa.” ");
INSERT INTO sbs_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesu nicha wamba kuvali nati, kahena muntu yese yo wola kuzumina zinu zikwetwe kurutwa, kono haisi avo va zumina kutambula icho. ");
INSERT INTO sbs_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kakuti kwina ba shalondo bava zalwa bovulyo kuzwa mu mavumu ava nyinavo. Imi vamwi ba shalondo bava pangwa ni vantu vamwi. Imi vamwi chevaka lyamusevezi wa muvuso we wulu. Iye yoo wola kutambula ituto atambule” ");
INSERT INTO sbs_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Linu vahwile zana nichi va letwa kwali ili kuti avike mayaza akwe hewulu lyavo niku valapelela. Kono balutwana vakwe nichi babakalimela. ");
INSERT INTO sbs_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kono Jesu nati kuti, “kanji muva kanisa kwiza kwangu, kakuti muuso we wulu wa vantu va swana navo.” ");
INSERT INTO sbs_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kuzwaho ni chava vika maza, ni chazwa havali. ");
INSERT INTO sbs_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mubone, mukwame wumwi cheza kwa Jesu ni chata kuti, “Muruti, chizi chilotu chini lukela ku tenda ili kuti niwane buhalo busamani?” ");
INSERT INTO sbs_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesu chata kwali, “chizi hotenda kuti uni buza zintu zilukite? Yeke muntu njolukite, kono haiva usaka kwinjila mukati ka vuhalo, zwile habusu kubika itayelo.” ");
INSERT INTO sbs_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mukwame chamu vuza ni chati, “Njezihi itaelo?” Jesu ni chati, “Kanji wi hayii, kanji uvukii, kanji wivii, kanji upaki indaba za mapa, ");
INSERT INTO sbs_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","uhe ikute venso niva nyoko, usake yo vambene naye sina moli molisakila.” ");
INSERT INTO sbs_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mutangana nata kwali, “Zose izo zintu niba zikuteki. Hape muni sakezi?” ");
INSERT INTO sbs_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesu ni chati, “haiva usaka kuva yo maninize, yende, kauze zose zo kwete, uka zihe ba sukulukite, mi iwe move ni chifumu kwi wulu, kuzwaho zoni chilile,” ");
INSERT INTO sbs_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Mutngana chinga zuwa bulyo kwa Jesu, nayenda na swavite ahulu, kakuti abali nji zumwi ba vena mazimo achifumu. ");
INSERT INTO sbs_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jesu ni chata kuva Lutwana vakwe, “ikumbya nimi wambila, ku kukutu ahulu ku muntu yo fumite kwi njila mu mubuso we wulu. ");
INSERT INTO sbs_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Hape nimi wambila bu sakusima kuti, kuhuva Inkamele kwi njila che linso lye naliti kuhita mufumi kuti enjile mu mubuso we Ireeza.” ");
INSERT INTO sbs_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Linu valutwana ha zuwa bulyo, Linu chiva makala tota hava zuwa bulyo niku ta kuti, “Nji vani bente niva hazwe?” ");
INSERT INTO sbs_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesu nicha ba lola niku ta kuti, “ku vantu kazi woleki, kwe Reeza zintu zonse ziwoleka.” ");
INSERT INTO sbs_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Linu Pitorosi niche tava nati, “mubone, tuva siyi zintu zose nitwa kwichilila. Linu kuzwaho mutu wane chituzi?” ");
INSERT INTO sbs_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesu nawamba ku vali nati, “Ikumbya nimi wambila, inwe muva chilili ime, muku zalwa chiha mwana mutu chake kala ha chihuna che kanya yakwe, nanwe bulyo mumu kekale hazi huna zina ikumi nizo vele, mukava vaatuli baka atula mishovo ina ikumi ni yovere ba mushobo wama Isilaele. ");
INSERT INTO sbs_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Wumwi ni wumwi yava siyi mazuvo, mizwale, bachizye, vesi, banyina, bana vakwe, mane ni mawa ke vaka lyangu, ka tambule zilukela kuva mwanda wi zwile niku wola buhalo busa mani. ");
INSERT INTO sbs_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kono bangi bena kumatangilo muvave kuma maninizo, hape bangi vena kuma maninizo muvave ku matangilo. ");
INSERT INTO sbs_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Kakuti muuso wa kuwulu uswana sina mwine webu yaba zwiili kuhanze kamapakela kukahira ba beleki ba muluwa lwakwe lwa muwomba. ");
INSERT INTO sbs_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kuzaho cha zuminzana ni ba beleki kaku sebeleza i sheleni lyonke mwi zuba, chaba tumina mwiwa lyakwe lya muwomba. ");
INSERT INTO sbs_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Cho yenda hanze hape munako ilikana ihola zotatwe mi cha bona bamwi ba beleki bauzimene ni kusena ziba bali kutende mu chibaka cha musika. ");
INSERT INTO sbs_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kubali na bacho, 'Inwe nanwe mu yende mwiwa lya muwomba, kanimihe chi lukite'. Haho chi ba yenda kuku vereka. ");
INSERT INTO sbs_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Hape cho yende kuhanze mwi ihola zibali kukwana iyanza lyonke ni iimwina, mi hape zimwi zibali kupanga iyanza ni zone ni kupanga kakuswana. ");
INSERT INTO sbs_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Hape ni hape mwihola yekumi ni yonke cha yenda hanze cha kawana bamwi niba zimene ni basena zi ba bali kutende. Cho ba wambila kuti, 'Chinzi hamu zimena bolyo hanu ni kusena zimutende mane izuba lyonse?' ");
INSERT INTO sbs_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Chi ba mwitaba kuti, 'kakuti ka kwina wa tuhira.' 'Linu cho wamba kubali nati, 'Nanwe muyende mwiwalya muwomba'. ");
INSERT INTO sbs_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Linu chitengwena, nfumwe wewa lya mawomba cho supa muhikana wakwe. 'Sumpe ba beleki njo ba luwera, ukalele kuwa manimani kukasika ku wentanzi.' ");
INSERT INTO sbs_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Linu ba beleki ba bahirwa ke nako yehola ichita ikumi ni yonke ha chiba sika, umwi ni wumwi na hora isheleni limwina. ");
INSERT INTO sbs_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Linu ba beleki babezi intanzi nabo chiba keza, ba bali kuzeza kuti muba lihiwe mangi, kono nabo chaba wana isheleni limwina. ");
INSERT INTO sbs_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ha chiba tambula ituwelo zabo, niba bilela kaza nfumwe webu. ");
INSERT INTO sbs_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Chiba wamba kuti, 'bana babeleki bama manimani ba babeleka bulyo ihola imwina, kono wabaliha iswana niyetu, iswe twa beleka ni kulemenwa izuba lyonse kamwi ni kahisite.' ");
INSERT INTO sbs_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Kono nfumwe wewa cho wamba kuzumwi wabo bantu chati, 'Mulikani kakwina buvi buna ku chita. Kena kuti wa zuminzana name ka kuku liha isheleni liimwina? ");
INSERT INTO sbs_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kohinde bulyo chako zwehateni uli yendeze mwinzila yako. Na lika kuliha ba beleki ba hirwa manainizo sina bulyo mukwi kalile kwako. ");
INSERT INTO sbs_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kana kakuni yelele kuti ni tende muni sakila ku chita ni ziluwantu zangu? Kapa liinso lyako linifwila muuna kakuli ni lukisa zangu?' ");
INSERT INTO sbs_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Cho bulyo bama manimani kababe be ntanzi mi bentanzi kababe bama manimani.” ");
INSERT INTO sbs_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Aho Jesu ha bali kukaya kwa Jerusalema, cho hinda ba bena ikumi ni bobele kwimbali, imi munzila cho wamba kubali nati, ");
INSERT INTO sbs_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Mu bwene, tukaya kwa Jerusalema, imi Mwan'a Muntu mwa hewe mumanza aba kulwana ba mapulisita ni ba ñoli. Ka ba muatwile ifu ");
INSERT INTO sbs_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","imi ka hewe kubantu feela kuti ba mushubule, ba mushupe, ni ku mukokotela. Kono mwi zuba lya butatu mwa buswe. ");
INSERT INTO sbs_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Linu inyina wa bana ba mitangana ba Zebediya chowiza nabo kwa Jesu. Cho fukama habusu bwakwe ni ku mukumbila chimwi chintu. ");
INSERT INTO sbs_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesu choti kwali, “Chinzi cho suni?” Chato kwali, “Layele kuti aba bana bangu bobele ba bamitangana bekale, umwina abe kwi yanza lyako lye chilyo imi zumwi kwiyanza lyako lye chi nzohoto mu muuso wako.” ");
INSERT INTO sbs_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Kono Jesu cho mwitaba ni kuwamba kuti, “Kawizi cho kwete ku kumbila. Kana u yelela kunywina muchi nywinso chente ni nywine hahanu?” Chi ba mwitaba kuti, “tuwola.” Cho wamba kuti, “Ikumbya inkomoki yangu mu munywine mo. ");
INSERT INTO sbs_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Kono za kwikala kwiyanza lyangu lya chilyo ni yanza lyangu lye chinzohoto kahena njeme yo yelela ku kuziha, kono ka zibe njiza bana balukisezwe kuba Tayo.” ");
INSERT INTO sbs_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Linu bamwi balutwana ba bena ikumi habazuwa bulyo, chiba nyelelwa muntu ni mwanche. ");
INSERT INTO sbs_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kono Jesu choba sumpila kumbali yakwe, ni kuba wambila kuti, “Mwizi kuti bayendisi be chichaba ba sebelisa ku lyatilila bamwi imi mane bantu bamazimo ba lyatilila tota. ");
INSERT INTO sbs_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kono sanzi kubi mweyo inzila mukati kanu. Ni ha mubonabulyo, yense yo lakaza kuba mukando mukati kanu abe muhikana wenu. ");
INSERT INTO sbs_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Hape yense yo lakaza kuba wentanzi abe muhikana wenu, ");
INSERT INTO sbs_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Sina hakwina kuti Mwan a Muntu kena abezili ku sebelezwa, kono kusebeleza, kono nikuha buhalo bwakwe chitabelo ku bantu bonse.” ");
INSERT INTO sbs_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Habali kuzwa kwa Jerico, ikunga ikando ni chi lyamwi chilila. ");
INSERT INTO sbs_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Imi kubena bakwame bobele babali ku fwile meenso ba bekele kwi mbali yamukwakwa. Linu haba zuwa kuti Jesu abali kuhita, chi batabeleza kaku huweleza, “Simwine, Mwan'a Daafita, utufwile inse.” ");
INSERT INTO sbs_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ikunga chilyaba nyaza ni ku bawambila kuti batontole, kono abo nji balila cha kuhuweleza kuti “Simwine, Mwan'a Daafita, utufwile inse.” ");
INSERT INTO sbs_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Linu Jesu, cho zimana nasa nyanganyi ni ku basumpa ni kuta kuti, “Chinzi chi mulakaza kuti ni mitendele?” ");
INSERT INTO sbs_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Chi ba wamba kuti, “Simwine, kuti meenso eetu eyaluke.” ");
INSERT INTO sbs_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Linu Jesu, cho bafwila inse, cho bawonda ha meenso abo. Pona haho chiba bone ni ku mwichilila. ");
INSERT INTO sbs_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Sina Jesu ni barutwana bakwe ha ba chunina Jelusalema ni kwiza kwa Patepaje, he Lundu la Olive, linu Jesu a ba tumini barutwana ba kwe bobele, ");
INSERT INTO sbs_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","na ba cho, “Muyende mu munzi wi chilila, mi ka pili ka mu kawane i ndonki i suminwe mwateni, ni kaana kayo. Mu zi sumunune mi mu zi lete kwa ngu. ");
INSERT INTO sbs_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Haiba muntu zumwi u wamba chi mwi ka zateni, mute kuti, “Simwine uzi saka; mi zuna mutu ka zitumine nanwe.” ");
INSERT INTO sbs_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Linu i chi chi ba chiteki kuti icho chi ba wambwa mupolofita chi zuzilizwe. ");
INSERT INTO sbs_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Nati, “wambile mwana wa mukazana wa zione, 'Bone, simwine wako ukezite kwako, Cha kuli booza hansi na tantite he donki, Ni ha kana kayo, ka na mani ke donki.” ");
INSERT INTO sbs_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Linu barutwana ba ba yendi ni ku ka tenda bo bulyo mwa ba ba laeleli Jesu. ");
INSERT INTO sbs_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ba ba kaleti i donki ni mwana ni ku bika zizabalo za bo ha zili, mi Jesu a be kali ha zizwato. ");
INSERT INTO sbs_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bungi bwa bantu ba bazali zizabalo za bo mu i nzila, ba mwi ba batemi mi tayi ya zisamu ni ku i zala mu inzila. ");
INSERT INTO sbs_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Linu ikunga ibayendi Jesu naseni kuyenda ne ikunga ibechilili, na huweleza nati, “Hosana kumwana Daafita! Utonolofezwe ukeza mwinzina lya simwine! Hosana kuwina mwiwulu!” ");
INSERT INTO sbs_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Linu Jesu heti chasika mwa Jelusalema, muleneñi wonse uba nyungani nibati, “Nyeni uzo?” ");
INSERT INTO sbs_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ibetabi, chiyati, “uzu nji Jesu uzwa mwa Nazaleta ina mwa Galileya.” ");
INSERT INTO sbs_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Linu Jesu chenjila mwi tempele. Abahindiki babali kuwuzikiza mwi tempele, ni kuzulika intafule zamasheleñi ni zipula zonse zibabauzi hamwina. ");
INSERT INTO sbs_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Abawambi kubali, “kuñoletwe kuti, 'Inzubo yangu kaisupwe kuti inzubo yetapelo,' kono inwe chimwaisandula chikunganino chabasa.” ");
INSERT INTO sbs_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Linu zihofu ni zihole zibakezi kwali mwi tempele, mi nabahoza. ");
INSERT INTO sbs_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Mukulwana wamapulisita ni bañoli bababoni zintu zikomokisa zabantendi, mi singa bazuwa bahwile bahuweleza mwitempele ni bati, “Hosana kumwana a Daafita,” babanjilwa bukali. ");
INSERT INTO sbs_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Babati kwali, “Mane uzuwile zibakwete kuwamba aba bantu?” Jesu chati kubali, “Eni! Kono mane chimubabalite, 'Mutuholo twabachiche ni bapamba kuzwa milumbeko ihitiliza kukuluka'?” ");
INSERT INTO sbs_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Linu Jesu na basiya ni kuya kumuleneñi wa Bethani mi abakalali kwateni. ");
INSERT INTO sbs_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Linu kakusasa chabola kumuleneni, aba fwile inzala. ");
INSERT INTO sbs_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kakubona chisamu chamuchaba kumbali ni nzila, abayendi kuchili mi abawani kuti kakwina chibikitwe kwateñi kunze yamakoba. Abawambi kuchili, “Kuzwa sunu kanzi nikube ni chichalantu kwako hape.” Imi kapilipili chisamu chamuchaba nichazuma. ");
INSERT INTO sbs_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Linu balutwana haba boni bulyo ni ba komokwa ni bati, “ku iza bule kuti i samu lwa muchaba hohwaho lizume?” ");
INSERT INTO sbs_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesu ne taaba na ba cho, “cho kusa kusima ni kucho, haiba ni mwina i ntumelo mi ka mubi ni mi hupulo yobele, kete mutende fela chiba tendwa kweli isamu lya muchaba. 'Kono ka muole kuwamba kwe chi chi wuulu,' u katulwe mui uulu mi u sohelwe mu iwate,' ");
INSERT INTO sbs_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mi mu ku chitahale. Chonse chi u kumbila che ntapelo, cha ku zumina, mo u tambule.” ");
INSERT INTO sbs_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Linu Jesu heza mwiitempele, muprisita mukulwana ni bakulwana babantu ni beeza kwali ha bali kuruta mi nacho, “chamaata ani ochita izi zintu? Mi wa akuha a amaata njeni?” ");
INSERT INTO sbs_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesu chobetaaba mi nabacho, “Ime name munimibuze impuzo imwina. Haiba nimuniwambila, name munimiwambile kuti chamaata nzi anichitisa izi zintu. ");
INSERT INTO sbs_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Inkolobezo ya Joani- ibazwi kuhi? Kuzwiila kwiwulu kamba kubantu?” Babali kuwambola mukati kaabo, ni bati, “Haiba nituti, 'Kuzwa kwiwulu,' mwati kwetu, 'Chizi linu hamusana mubamuzumini?' ");
INSERT INTO sbs_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kono haiba nituti, 'Kuzwa kubantu,' tutiya ikunga, kakuli bonse babona Joani kuba mupolofita.” ");
INSERT INTO sbs_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Linu babetabi Jesu nibati, “Katwiizi,” Imi naye nabetaba nati, “Nanga ime keti chinimiwambila kuti nji ani maata anichita chawo izi zintu. ");
INSERT INTO sbs_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kono iwe uzeza buti? Mukwame abena banaswisu bobele. Abayendi kuwetanzi mi nati, 'Mwanangu, kwiya ukasebeze muluwa lwe veine sunu.' ");
INSERT INTO sbs_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Mwana abetabi nati, 'kani woli,' kono mumasulezana nachincha muhupulo wakwe mi nayenda. ");
INSERT INTO sbs_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Imi mukwame nayenda kumwanaa kwe wabubeli mi nawamba chintu chiswana. Mwanaa kwe netaba nati, 'Kaniyende, sha,' kono kanabayendi. ");
INSERT INTO sbs_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kubana bobele yabachiti intato yeshabo?” Babati, “Wetanzi” Jesu nabacho, “Chabusakusima ni micho, bateliisi bamali ni mahuule mubakenjile mumubuso we Ireeza inwe nimuseni. ");
INSERT INTO sbs_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Mukuti Joani abezi kwenu chenzila ilukite, kono kanamubamuzumini, kono bateliisi bamali ni mahuule babamuzumini. Imi inwe, hamubona izo nizitendahala, kana mubabakeli zibe zenu kumamanimani kuti mumuzumine. ");
INSERT INTO sbs_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Mutekeleze kwinguli imwi. Kubena mukwame, yabali sichibaka, Ababyalite iwa lyamuwoomba, nikubika lukwakwa kuzimbulusa, abashi chilubilo mwateni, abazaki ni ngalani yakubonena kulee, imi abaikalimi kubalimi bakalimite. Linu abayendi kuimwi inkanda. ");
INSERT INTO sbs_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Imi inako yenkutulo yazichelantu haichunina, abatumi bahikana balikene kubabyali bamuwoomba kukahinda zichelantu zakwe. ");
INSERT INTO sbs_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kono bakalimite mawa babahindi bahikana bakwe, kudama umwina, kwihaya zumwi, ni kugoboola zumwi ni mabwe. ");
INSERT INTO sbs_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Imi hape, siluwa abatumi bamwi bahikana, kuhita bamatangilo, kono babyali bamawa bababachiti chenzila iswana. ");
INSERT INTO sbs_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kuzwaho, mwine siluwa abatumini mwanaa kwe kubali, nikucho, 'Kabakakuteke mwanangu.' ");
INSERT INTO sbs_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kono balimi bamuwoomba hababona mwana, chibaliwambila kuti, uzu nji swana. 'Mwize, tumwihaye tuyole chifumu.' ");
INSERT INTO sbs_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Linu chibamuhinda, chibamusohela hanze yaluwa lwamuwoomba, mi chiva mwihaya. ");
INSERT INTO sbs_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Linu siluiwa heti nasike, kachite inzi kubalimi bewa lyamuwoomba?” ");
INSERT INTO sbs_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Babawambi kwali nibacho, “Kasinyasinye abo bakwame bafosahele chenzila yachituhu chikando, mi kuzwaho mwakalime mawa amuwoomba kubamwi balimi bamuwoomba, bakwame bawola kuliha mowoomba haubuzwa.” ");
INSERT INTO sbs_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesu nabati, “Kana mubeni kubala mumañolo, 'Musumo Ubabakani bazaki Ubatendwa Musumo wamwikona. Ichi chibali kuzwila kwa Simwine, mi chitabisa mumenso etu'? ");
INSERT INTO sbs_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Chobulyo nimicho, mubuso we Ireeza kauzwiswe kwenu mi kauhewe kuchisi chilichitila zichelatu icho chine. ");
INSERT INTO sbs_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Yense yeti nawile heli ibwe mwachokoke bwemba. Kono iyemwine heti niliwile, kagazubuke.” ");
INSERT INTO sbs_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Bakulwana bavapurista ni vafarisi habazuwa iyi inguli, babalemuhi kuti uwamba abo. ");
INSERT INTO sbs_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Chakusaka kumusumina, babalikutiya ikunga, mukuti bantu babali kumuhinda kuti mupolofita. ");
INSERT INTO sbs_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jeeso cheza kuwamba nabo hape che nguli, chati', ");
INSERT INTO sbs_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Muvuso we wulu uswana uvu zumwi simwine ya va lukisi mukiti we seso lya mwanakwe wa mwanaswisu, ");
INSERT INTO sbs_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Chatuma va hikana vakwe ku ka sumpa avo va valayezwe, kono kena vaveza. ");
INSERT INTO sbs_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Hape simwine neza ku tuma vamwi vahikana, nati, 'Mukava wambile valayezwa, “Vone, china lukisa mulalilo wangu. Mapulu ne tunamani twangu tununine chi ze haiwa, mi zintu zonse zi shiyeme. Muize ku mukiti we seso.” ");
INSERT INTO sbs_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kono avo kena va vatekerezi cho ku tokomera nanga kanini chivaliyendeza kwabo, zumwi kwiwa lyakwe, naye zumwi ku zimpangaliko zakwe. ");
INSERT INTO sbs_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Vungi bwavo chiva hindeka vahikana va simwine nikuva fwisa insoni, mi ni kuvehaya. ");
INSERT INTO sbs_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mi simwine na venga. Choku tumina chisole chakwe, ku ihaya vehayi mi choku ka sumika munzi mukando wavo. ");
INSERT INTO sbs_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Mi na wamba ku vahikana vakwe ku tewa, 'mukiti we iseso u lukite, kono va valalezwa kena va vaku swanere. ");
INSERT INTO sbs_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Mi paho, muyende munzira ziwukite mwishira mi muka meme vantu cho vungi ku mukiti we iseso mumu wolyera.' ");
INSERT INTO sbs_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Mi vahikana niva yenda kuya vu kunganyana vantu vava vaka wani, vonse va sa shiyeme ni va shiyeme. Lyinu chivaka cho mukiti ni che zuzwa ne vayezi. ");
INSERT INTO sbs_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Kono simwine inge za kulola vaenzi, chavona mukwame yasena avazwete zi zwato za mukiti, ");
INSERT INTO sbs_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Simwine chati kwali, 'Mulikani, hape wenjira vule munu nosa zwete zizwato za mukiti we seso?' Mukwame chavula chiambo. ");
INSERT INTO sbs_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Lyinu simwine nawambira vahikana, 'Mu hambe uzu mukwame ku manza ni matende, mu musohele mukelima, uko kwina ku vokolola ne kulila inkunkuma.' ");
INSERT INTO sbs_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kakuli vangi va sumpitwe kono va che va salyitwa.” ");
INSERT INTO sbs_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Lyinu va farasai chiveza kuzeza ni ku zuminzana muvawolela kumu teyera Jeeso kaswa mu ziambo zakwe. ");
INSERT INTO sbs_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ni chi va mutuminiza valutwana vavo, ku kopanya vulyo ne maheroda. Choku wamba ne Jesu, “Muruti twizi kuti wina initi, mi uluta inzira ye Ireeza cho vusakusima. Ko tekerezi ku minahano yo muntu, mane kotondezi isobozi mukati ka vantu. ");
INSERT INTO sbs_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Lyinu tulwile, u zeza vulye? Cho mulao ku woleka ku liha mutelo kwa Kaishara kamba vule?” ");
INSERT INTO sbs_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kono Jeeso na lemuha ku fosahala kwavo mi choku wamba kuti, “Chinzi ha mu nilika unwe, unwe va itimukanyi? ");
INSERT INTO sbs_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mu ni tondeze vuwayawaya vo mutelo.” Mi avo choku leta vuwayawaya kwali. ");
INSERT INTO sbs_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jeeso na wamba kubalyi kuti, “Chiswaniso ne izina lyani izi?” ");
INSERT INTO sbs_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","chi vati njiza Kaishara. “Jeeso cho ku wamba kuti, muhe Kaishara zintu za Kaishara, ne Ireeza zintu ze Ireeza. ");
INSERT INTO sbs_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Chinga va zuwa mu wambilo wakwe choku komokwa. Mi choku mu siya ni vakaya. ");
INSERT INTO sbs_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Cholo lu zuva vamwi va Vasadukayi, va valyi kucho kuti ka kwiina ku vuuka kwa vafu ni beza kwali. ");
INSERT INTO sbs_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Choku mu vuza kuti, “Muruti, Mushe ava wambi, 'Haiva mukwame wa fwa na sena vaana, mwanchakwe u lukele ku sesa mwi hyabwe choku zalila mukulwakwe vahwile. ");
INSERT INTO sbs_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kuvena vanaswisu va va kumana iyanza ni tovele. We ntazi a va sesi cho ku fwa, Cho ku siya muihabwe ku mwanche. ");
INSERT INTO sbs_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Mi mwanche yo mu ichilila cho ku panga chintu chi swana, ne wo vutatu mane ne ku twala ku woku mana iyanza ne tovele. ");
INSERT INTO sbs_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Chinga va mana ku fwa bonse, mukulwakazi naye choku fwaa. ");
INSERT INTO sbs_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Lyinu ku inako yo ku vuka, kaave mukulwakazi wani kwava va vaanaswisu va mana iyanza ni tovele? Ka kuti vonse va va musesi?” ");
INSERT INTO sbs_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Mi Jeeso na ve taba nati, “Chingi mufosa, ka kuti ka mwizi mañolo kamba maata e Ireeza. ");
INSERT INTO sbs_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ka kuti ku ku vuuka ka kwina ku sesa, kamba ku seswa. Mi vulyo ka va ku kola ili mañiloi miulu. ");
INSERT INTO sbs_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kono kuya choku vuuka kwa vafwire, ka hena mu va vali ziva wambitwe kwenu ne Ireeza kuti ");
INSERT INTO sbs_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","'Njeme Ireeza wa Abrahama, Ireeza wa Isaka, Ireeza wa Jakobo?' Ireeza ka hena wa vafwire kono ngua va hala.” ");
INSERT INTO sbs_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mi vantu vangi chinga va zuwa izo, choku komokwerwa ituto yakwe. ");
INSERT INTO sbs_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mi Vafarasayi chinga va zuwa kuti Jeeso cha tontoza Vasadukayi, cho kuli kopanya vonse. ");
INSERT INTO sbs_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Zumwi wabo, muruti wo mulao, cho ku vuza ipuzo ku mulika- ");
INSERT INTO sbs_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Muluti, lyaho itaero inkando mu mulao nje ihi?” ");
INSERT INTO sbs_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jeeso cho ku mu sandula ku tewa, “Sune Ireeza wako che inkulo yako yonse, ne luhuho lwako lonse, ne muhupulo wako wonse.” ");
INSERT INTO sbs_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Iyi nje itaelo inkando mu mulao. ");
INSERT INTO sbs_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Mi yo vuveli itaelo yi swana-'U sune muzakinsani mo lisunine.' ");
INSERT INTO sbs_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","He zi itaelo zovele mpaha kolele mulao ne vapolofita.” ");
INSERT INTO sbs_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Choku hwela Vafarasayi ne vasi kungene, Jeeso choku va vuza ipuzo. ");
INSERT INTO sbs_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Nati munahana ku tinzi cha Kirisiti? Mwanaswisu wani?” Avo chokumu cho kuti, “Mwanaswisu wa Daafita.” ");
INSERT INTO sbs_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jeeso choku va cho kuti, “Kwiza vule kuti Daafita chowina Muluhuho amusumpe Simwine, nati kuti. ");
INSERT INTO sbs_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Simwene na wamba kwa Simwine wangu, “Wi kalile kwiyanza lyangu lya malyo, mbwita china chita zira zako kapula ka matende ako?” ");
INSERT INTO sbs_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Lyinu haiva Daafita u musumpa Kirisiti 'Simwine', ku zwaho u va vule mwanaswisu wa Daafita?” ");
INSERT INTO sbs_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mi ni kwa vuleka mane nangati u mwina ya va muitavi che linzwi, ku zwaho mane ni kwa vuleka muntu nangati umwina ku muvuza ipuzo ku zwa mwelyo izuva. ");
INSERT INTO sbs_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Lyinu Jeeso na wamba ku bungi-bungi bwa bantu ne ku varutwana vakwe ");
INSERT INTO sbs_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","kuti, “Vañoli ne Vafarasayi ve kala mu chimpura cha Mushe.” ");
INSERT INTO sbs_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","lyinu mupange zonse ziva mu lawiila, mu chite ne ku panga zonse inzi zintu, mi bulyo mu siye kuva ziya ziba panga. kakuti vawamba zitu choku sa zi pangahaza. ");
INSERT INTO sbs_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Eyee, va hinda choku puteereera choku sumina miputo mikando yi lyema choku vika ha maheta a vantu. Avo mane nanga chaka nwe kamwina kava liki kunyemuna. ");
INSERT INTO sbs_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Misevezi yaavo yiva woola ku panga vai pangira vulyo muma tembwa kuti va vonwe ku vantu. Vakandusa ahulu ziviko zaavo zo mulao mane choku kuza ahulu hape majira e zizwato zaavo. ");
INSERT INTO sbs_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Vasuni ahulu mekalo a vantu va kutekeha mu mikiti, ne zipula zi kalwa vantu va kutekeha mu Ikereke, ");
INSERT INTO sbs_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ne ku rumereswa ahulu ku vantu mu mazira, neku supwa muruti. ");
INSERT INTO sbs_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Sanzi mu sumpwa kuti 'Muruti', kakuti mwina muruti u mwina bulyo, unwe mu bonse mu balikani. ");
INSERT INTO sbs_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mi mane sanzi mu sumpi mutu kuti nje isheenu hansi hanu ka kuti isheenu wu mwina bulyo yo wina ku iwulu. ");
INSERT INTO sbs_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Hape sanzi u zuminini muntu kuti a ku sumpe kuti muruti, ka kuti mwina bulyo muruti u mwina iye kirisiti. ");
INSERT INTO sbs_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mi iye mukando ahulu mukati kenu njo lukele kuba muhikana wenu. ");
INSERT INTO sbs_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mi iyee yolyi nyemuna ka vikwa hasi, ku zwaho iye yeti naalyi vike hasi ka nyemunwa. ");
INSERT INTO sbs_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Mi ku maibite unwe mu Vañoli ne Vafarasayi, muva itimukanyi ka kuti mu iyalyira muvuso wo ku iwulu vantu, hape ku kwinjira ka mwinjiri mwa teni, va saka kwinjira navo hape muva kanisa. ");
INSERT INTO sbs_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Mu maibite unwe mu Vañoli neba Farasayi Va itimukanyi, mubwabwanga mazubo aba fwirwa ");
INSERT INTO sbs_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Mu maibite unwe mu Vañoli, Farasayi niba itimukanyi. Kakuti muyenda mu mawate ne inkanda kuti mu wole ku sandula muntu nangati wu mwina bulyo mi hakuti chimwa mu sandula, mumu chita kuti ave mwana wa satani kobele. ");
INSERT INTO sbs_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ku maivite unwe, va hitizi vasa voni, unwe mucho kuti, 'Zumwi ne zumwi muntu yo li kana che tempere ka hena chimwe. Mi lyinu zumwe ne zumwe muntu yo lyikana che ighawuda u suminwa ne kuli kana kwakwe.' ");
INSERT INTO sbs_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Unwe mu mahaafu a saa voni! Nje chihi chikando ku zaamba, ighawuda kamba itempere iiyo yi jololyekeza Ireeza ighawuda? ");
INSERT INTO sbs_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kono, 'zumwi ne zumwi yo lyi konka che iziko lye chitavero, ka hena chimwi bulyo hateni. Mi lyinu zumwi ni zumwi mutu yo likonka nce neo ina hateni, u suminwa ne kuli konka kwakwe.' ");
INSERT INTO sbs_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Va hofu njoonwe! Nche chihi chikando a hulu, ineo kamba chitavero chi jololyekeza Ireeza ineo? ");
INSERT INTO sbs_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Mpaho lyinu, iye yo lyi koonka che chitavero cha teni mane ne chimwe ni chimwe china ha teni. ");
INSERT INTO sbs_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Mane naaye yo lyi koonka che itempere u lyi koonka chaayo ne chakwe yoo hala mwa teni. ");
INSERT INTO sbs_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Naye vulyo yo lyi koonka che iwulu u lyi koonka che chipura che Ireeza mane naaye yo wii keere ha chilyi. ");
INSERT INTO sbs_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ku maivite unwe, mu Vañoli, ne Vafarasayi vaitimukanyi! Mu voza cho vuikumi cho minte, dilo ne kamine, Chovulyo, muka siite zintu zikando zo mulao ni musa pangaheza ku woloka ne chishemo ne tumelo. Mi izi nzi muva lukele kupangahaza chokusa litokolomosa zimwi. ");
INSERT INTO sbs_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Unwe muva hitizi vava hofu, mu mbatula ka gini, mi choku mina ikaamera! ");
INSERT INTO sbs_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Mu maibite unwe Vañoli ne Vafarasayi muva intimukanyi! Muhinda chipeto choku shanza inkomoki hanze mane ne impuleti, mi mukati kazo ni mwina ikwe lyisa wolyeki. ");
INSERT INTO sbs_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Unwe mu Vafarasayi vasa voni, mu shanze pili mukati ke inkomoki ne impulyeti ku chitila kuti ne hanze ku wole ku jolola. ");
INSERT INTO sbs_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ku maibite, inwe mu Vañoli ne Vafarisayi vaitimukanyi! Ka kuti mu kola mane iri makumbu a tuva twaa, a voneka vulotu hanze tota, mi mukati ka teni ni ena zifuha za vantu va fwire mane ne imbolyeza ne chimwe ne chimwe chi saa jololyi. ");
INSERT INTO sbs_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Voovo vuti nanwe mumu loleka hanze lyenu ku vantu choku jolola mi mukati kenu mu izwile vuitumukanyi neku sa shiyama. ");
INSERT INTO sbs_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ku maivite unwe, Vañoli ne Vafarasayi, vaitumukanyi! Kakuti muzaka makumbu ava polofita mane choku lotuhaza makumbu ava jolola. ");
INSERT INTO sbs_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mu cho kuti,' kali nitu vali kuhala mu inako zi ve ishetu nitu sana tuva bi ne chiyave muku itira malaha a Vapolofita'. ");
INSERT INTO sbs_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Chingi mu vone mane kete muha vupaki kuti mu vaana vaavo vave ihai va polofita. ");
INSERT INTO sbs_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Unwe nanwe mu izuziliize bulyo zintu zibe ishenu. ");
INSERT INTO sbs_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Unwe mu zonka, bana be zihiri, kamu wole ku loboka vule i katulo ye here? ");
INSERT INTO sbs_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Chingi mpaho, mubone, nimu tumiza va polofita, neva kwame va talifite, ne Vañoli. Mi mane vamwi vavo kamuve haye niku va vambula. Ku zwaaho mane vamwi vavo ka muve kuva shimeha neku va kava muma zubo enu e tuto, ne ku kaya mu vuva nyandisa, mu munzi mukando ne mukando. ");
INSERT INTO sbs_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ku chitila kuti mu wilwa mulandu wo kwi tila malaha a jolola ave tilwa mu inkaanda, ku tanga cha malaha a Avere kuya kwa a Zekaraya mwana wa Barakiya, u muve hairi hakati ke tempere ne iziko lye zitavero. ");
INSERT INTO sbs_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Choku izula ni mulwirite, zonse izi zintu ka ziize zimu pangahalile ulu luzuvo. ");
INSERT INTO sbs_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerusalema, Jerusalema, uwe yo wi haya va polofita mane neku govola cha mabwe vonse vaka tumitwa kwako! Mi ni saka vule kwi kala nini kuvukerereza vaana vako, mane iri inkunku kutu kukwana twayo chiyi tu bika mu mavava, mi ku zwaaho kamu suni! ");
INSERT INTO sbs_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Mubone, inzubo yenu muyi mu shalile cha matongo bulyo. ");
INSERT INTO sbs_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Aho ni mulwirite keti ni mu bolye muni bone hape, mbwita chini mwancho kuti, 'kwina mikonde kwali iye yo keza mu izina lye Ireeza.' ");
INSERT INTO sbs_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jeeso chaa vaalyi kuzwa mu itempere nna lyi yendeere. Varutwana vaakwe cho kuiiza kwaalyi choku taanga nni va mucho kuti mane u vweene muzaako we iiyi itempere. ");
INSERT INTO sbs_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Mmi iiye nnaa ve itava nnaati, “mu weene zoonse iisi zintu? Aaho nni mulwiirite, ka kwiina ivwe lyeeti nnilyi waanike nni lyiina he iwulu lye lyimwe muku rutunuka.” ");
INSERT INTO sbs_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Mmi cho usii keere he iruundu lye ziteente, varutwana vaakwe choku iiza kwaalyi voonse cho kulyi kuungula nniva mu vuuza kuti, “Tu lwiire kuti zoonse iizi zintu kazi pangahalye vulye? Chishupo cho kuiiza kwaako ka yive iinzi mane nne mamanimani e inkaanda?” ");
INSERT INTO sbs_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jeeso nna vee tava nnaati, “Mu tokomere kuti saanzi nni kuvi nne yeeti nna mu cheengerere. Ka kuti vaangi ka veeze mu izina lyaangu. ");
INSERT INTO sbs_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Mane kava kucho kuti, 'Njeeme Kirisiti,' mmi kava ziyeza- chengerere vantu vaangi choku va soha. ");
INSERT INTO sbs_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mmi kamu zuwe inkoondo nne mahulyuhulyu aayo ku zwaaho mu vone kuti saanzi nni mukatezehi, ka kuti iizi zintu zoonse zi lukeere ku pangahala; mmi mamanimani keeti nni a ku sikite. ");
INSERT INTO sbs_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mane inkaanda ka zilyi lwiisa nne mivuso ka yilyi saamdukire. Mmi ka kuve inzala nne ku nyanganya kwe inkaanda mu zivaka zi saa swani. ");
INSERT INTO sbs_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Mmi iizi zintu zoonse kazi ku veere mataangiro o ku sasama koku hwizumuka. ");
INSERT INTO sbs_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Lyiinu njeeti nni va mu swiisikize kuku katazwa nne ku ihayiiwa. Kamu toyeewa nne inkaanda zoonse che ivaka lye izina lyaangu. ");
INSERT INTO sbs_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ku zwaaho vaangi kava chuunchune choku taanga nni valyi wuza nne kulyi toya. ");
INSERT INTO sbs_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Vaporofita vaangi va mapa ka vave kwa teni mmi choku soha vantu vaangi. ");
INSERT INTO sbs_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ka kuti vuvilaala kavu ku injihite chisemo cha vantu vaangi ka chitoontolye. ");
INSERT INTO sbs_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Mmi iiye yeeti nnalyi koza mbwiita ku mamanimani njeeti nna hazwa. ");
INSERT INTO sbs_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Uuwu mulayeza wo muvuso woku iwulu kawu kutazwa mu inkaanda yoonse kuva vupaki mu inkaanda yoonse, ku zwaaho mamanimani njeeti nni eeze. ");
INSERT INTO sbs_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Chiingi lyiinu, chini mwaa vona chiina ikwe chi zakununa, chaa waamba chaacho muporofita Danyeere, nni chi zimeene ha jolola (a yoo vala a lyemuhe), ");
INSERT INTO sbs_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","A yo wiina mwa Judiya a ngombweere ku maruundu, ");
INSERT INTO sbs_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","yo wiina he iwulu lye inzuvo saanzi a suuki he iwulu lyaayo kuti a ka hiinde chimwe mukati ka teni, ");
INSERT INTO sbs_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","mane nnaaye yo wiina mu inkaanda saanzi a voolyi a ka hiindi chizwaato. ");
INSERT INTO sbs_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mmi ku mayivite aavo ve mmiinsi nne vanyoonsa inkeke mwaawo mazuva! ");
INSERT INTO sbs_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mu rapere kuti ku ngombola kweenu saanzi nni kuvi ha malyiha kamba lwe Nsavata. ");
INSERT INTO sbs_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ka kuti ka ku kwiina manyaando makaando mwaawo mazuva a chita kuti inkaanda chiinga yi vaati yi kuva ka eeni kuva ha teni mane nne kuti keeti nni a voolye nni ave kwa teni hape. ");
INSERT INTO sbs_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kwaanda kuti aawo mazuva a hunguzwa, nni ku sana ku vaavi muntu yeeti nna va hazwa. Mmi kuya cha va salyitwa a a mazuva ka a fwiiswa. ");
INSERT INTO sbs_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Mmi lyiinu haiva zumwe vulyo ka a kucho kuti Kirisiti zunuu hanu kamba zuna kuna, saanzi nno zumini. ");
INSERT INTO sbs_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ka kuti va Kirisiti nne vaporofita va mapa ka veeze nni va panga imboniso inkaando mane nne zi komosa ziingi a hulu, kuti va woolye ku ziyeza, chiku woolyeka mane nne va salyitwa. ");
INSERT INTO sbs_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mu vone nna mulwiira inako nni yi seeni ku sika. ");
INSERT INTO sbs_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Chiingi lyiinu, nnaangati kava mucho kuti, mu lolye u waanika ku chikwa, mane saanzi nni muyi kwa teni, Kamba mu vone wiina mu inzuvo, yo mukati, saanzi nni mu zumini. ");
INSERT INTO sbs_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Mmi siina mumini muwu minika ku vuzwa vwee zuva, mane choku ka voneka nne ku vuimino, nne ku iiza ko mwaana wo muntu naako mweeti nni kuve. ");
INSERT INTO sbs_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ka kuti koonse ku waanika chituunta ko kooko makuuvi nku a kunganera. ");
INSERT INTO sbs_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Mmi vulyo hoo hwaaho ku mamanimani a masukuluka eeyo inako izuva keeti nni lyi kusii zwiisa iseri, nne mweezi nnaawo, inkaani nnaazo ka ziwe ku iwulu, mane nne ziho ze iwulu nnaazo ka zinyungooswa. ");
INSERT INTO sbs_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Lyiinu chishupo cho mwaana wo muntu njeeti nni chi voneke mu iwulu, ku zwaaho mishovo yoonse ya vantu ve inkaanda njeeti nni va lyire. Ka va vone mwaana wo muntu nna keeza mu makope e iwulu nne che ziho nne ku vereenga ku kaando. ");
INSERT INTO sbs_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mmi kaa tume mangiloyi aakwe cho mulyumo mukaando we intorombita, mmi kava kunganya aavo va salyitwa mu zivaka zoone zo luhuho ku mamanimani e iwulu kuya ku amwi. ");
INSERT INTO sbs_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Mulyi tute ituto ku ibola, ho hwaaho vulyo ibola chilyi taanga ku zwiisa tutavi nne makova mahiya, chipeto chi mwee ziva kuti imbumbi chi yiina ha fwihi. ");
INSERT INTO sbs_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Lyiinu he iwulu lyaaho chini mwaa vona iizi zintu zoonse, nni mu izive kuti cho wiina ha fwihi, heene vulyo ha mulyaango. ");
INSERT INTO sbs_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Aaho nni mulwiirite, iichi chivaka keeti nni chi hite mbwiita iizi zintu zoonse zi pangahalye. ");
INSERT INTO sbs_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Iwulu nne inkaanda kazi mane mmi manzwi aangu aawo keeti nni a mane. ");
INSERT INTO sbs_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Mmi kuya che iilyo izuva nne inako ka kwiina yo wiizi, mane nnaangati mangiloyi e iwulu, kamba mwaana, mbwiita Taayo vulyo. ");
INSERT INTO sbs_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Siina mu inako za Noah muku veena nne zo kuiiza ko mwaana wo muntu mweeti nni kuve. ");
INSERT INTO sbs_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Mmi siina mwaawo mazuva muunda chiwu seeni kuva ha teni va vaalyi kulyia nni va nywa, kusesa nne ku sesesa mbwiita Noah chiinga e nijra mu iyareka, ");
INSERT INTO sbs_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","nni va vula kuiiziva chimwe vulyo mbwiita muunda chiinga weeza kuva hiinda voonse vulyo—mane nne kuiiza ko mwaana wo muntu mweeti nni kuve. ");
INSERT INTO sbs_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Lyiinu vakwaame voovere ka va kwiina mu luwa—wu mwiina kaa hiindwa wu mwiina choku shaala. ");
INSERT INTO sbs_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Vakulwaakazi voovere kava ku twa—wu mwiina kaa hiindwa wu mwiina kaa shaalye. ");
INSERT INTO sbs_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Chiingi lyiinu mu ikalye nni mu lyiisiiza ka kuti ka mwiizi kuti Simwiine weenu u keeza lyiiri. ");
INSERT INTO sbs_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mmi mu izive iichi, kuti kalyi si inzuvo u woola ku iziva kuti musa mweeze ku yiva inako iinzi ya masiku, keeti choo siyirira musa kuti zaa yive mu inzuvo yaakwe nna sa yi lyiisi. ");
INSERT INTO sbs_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Chiingi nnaanwe mu lukeere ku ikala nni mu lyivereere, ka kuti ka mwiizi inako yo mwaana wo muntu yaa keeza chaayo. ");
INSERT INTO sbs_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Chiingi lyiinu njeeye iini iiye muhikaana yoo sepahala nne yoo kwanine yeeti nnaati simwiine waakwe haa mu siya he inzuvo yaakwe kaa he vahikaana vamwe zilyio che inako yi swaneezi? ");
INSERT INTO sbs_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mmi kwiina mikoonde kwaalyi iiye muhikaana yeeti nna waanike nna kweete ku panga voovo vulyo. ");
INSERT INTO sbs_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Aaho nni mulwiirite uuzo simwiine kaa mu hiinde choku mu viika mu maziimo o ku vavalyera inzuvo yoonse vulyo. ");
INSERT INTO sbs_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mmi lyiinu muhikaana yoo fosaheere kaa lyi lwiire mu inkulo yaakwe, 'simwiine waangu u ka lyiehete,' ");
INSERT INTO sbs_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","mane choku taanga nna kava vamwe vahikaanakunine, cho kulyia nne kunywa nne vachaakolwa. ");
INSERT INTO sbs_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Mmi simwiine woozo muhikaana keeze che izuva nne inako yaa sa lyivereere. ");
INSERT INTO sbs_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Lyiinu simwiine waakwe njeeti nna mu kosolye ha kati, choku mu panga siina muva ihayirwa vaitimukanyi, kweeti nni ku kwiina ku boonda nne ku lyira inkuunkuma. ");
INSERT INTO sbs_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Mubuso wo kwiwulu kawu swane ni ba kamwale basika hekumi ba hindite malambi abo cho ku yenda kuka tambula musesi. ");
INSERT INTO sbs_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ba kamwale bakwanisa iyanza ba bali baholo mi bamwi bakwanisa iyanza ba bena ingana. ");
INSERT INTO sbs_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Mi ba kamwale baholo chinga bahinda kampalamba abo, cho kubula kulihindila mafuta amwi nabo. ");
INSERT INTO sbs_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Kono ba kamwale ba bena inga abo ba bahindite mafuta amwi mu zibiko ne malambi abo. ");
INSERT INTO sbs_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Mi linu musesi ha ba si lyehete, bonse co kutanga kusukula ne kulala. ");
INSERT INTO sbs_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Kono hakati ka masiku ni kwaba ni kusumpwilila, “Mu bone musesi! Mwende hanze mu ka mutambule.” ");
INSERT INTO sbs_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Mi linu ba kamwale bose mpu babukile cho ku munika tumpalamba twaabo. ");
INSERT INTO sbs_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Baholo ni ba cho bena inga kuti, “Mutuhuko ku mafuta kakuti malambi eetu chia zima.” ");
INSERT INTO sbs_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Mi bena inga ni be taba ni baati, “Ka kuti mafuta a likene bulyo uswe, lyaho unwe muyende ku musika muka liwulile kwateni mubene.” ");
INSERT INTO sbs_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mi chi ba siyendete ku ku kawula, musesi chokusika, mi abo ba ba mulindile cho kwi njila naye mu mukiti we iseso, kuzwaho mulyango cho kwi yalwa. ");
INSERT INTO sbs_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kumasule aho mpu ba kezilile ba na bamwi ba kamwale nibati kuti, “Simwine, simwine twiwulile.” ");
INSERT INTO sbs_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kono iye na be taba nati, “Cho busa kusima ni mu lwilite, kani mwizi.” ");
INSERT INTO sbs_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Linu mpaho mwikale ni mulisize, kakuti ka mwizi izuba mane nangati inako. ");
INSERT INTO sbs_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ka kuti kuswana mane ili muntu ya bali kusaka kuyenda ku kanda imwi. Yaa bati na sumpa bahikana bakwe cho kubaha buhumi bwakwe. ");
INSERT INTO sbs_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Zumwi cho kumuha italenta zimana iyanza, zumwi iye cho ku muha zobele, mi zumwi cho ku muha yi mwina italenta. Mi zumwi ni zumwi wabo na tambula kuya mwa bali ku wolela, kuzwaho uzo muntu cho kuli yendele mu lwendo lwaka. ");
INSERT INTO sbs_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Hohwaho bulyo zuna ya ba tambuli ineo zina ku mana iyanza cho ku zwa cho kuka zinjisa chezimwi hape zina ku mane iyanza. ");
INSERT INTO sbs_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mu kuswana hape u zu ya ba tambuli zobele, cho kuka zizaza ce zimwi zoobele. ");
INSERT INTO sbs_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kono muhikana ya ba tambwile imwina ineo na yenda, cho ku kaisila ilindi, cho kuwungula mwateni mali a simwine wakwe. ");
INSERT INTO sbs_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Cinga kwa hita inako inde, simwine wabo bahikana na ba sumpa kwiza ku lekula za ba basili. ");
INSERT INTO sbs_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Muhikana ya ba helwa ineo zina ku mane iyanza ne za ne zimwi hape zina kumane iyanza. Mi nati kuti, “Simwine u ba nihi ineo zina ku mana iyanza mi bone ni bakapangi zimwi hape zina ku mana iyanza.” ");
INSERT INTO sbs_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Simwine wakwe na muco kuti, “U bapangi nenza muhikana mulotu ni yo sepahala! U ba sepahali kuzintu zinini. mi linu hanu muni kubike mu kulolelela zintu zingi. linu paho wi njile mukusanga kwa simwine wako.” ");
INSERT INTO sbs_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Muhikana ya ba tambwile italenta zobele cha keza ni kuwamba, “Simwine u ba ni hele italenta zobele. Bone, ni bapangi zimwi zobele hape.” ");
INSERT INTO sbs_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Simwine wakwe cha wamba kwali, “U bapangi nenza, muhikana mulatu ni yo sepahala! U ba sepahali hewulu lya zintu ziche ka ni kubike kuyendisa zintu zingi. Njile mukusanga kwa simwine wako.” ");
INSERT INTO sbs_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Mi linu, muhikana ya bahewa ineo yi mwina ne za nacho, “Simwine, nizi kuti u muntu u mukukutu. U sinza hosana u balimite, mane uhuhula hosana u bahasi. ");
INSERT INTO sbs_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mi cinga natiya puni yendele cho kuka yi zika mwi bu. Bone, nji chako icho cho banihele.” ");
INSERT INTO sbs_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Mi simwine wakwe na mwitaba na mucho kuti, “U we muhikana yo fosehele ne bukata, wizi bule kuti ni muntu yo sinza hasana a balimi kamba yo huhula hasana a balimi. ");
INSERT INTO sbs_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Mi bone kali mali angu no baahi ba zaza mali, hanu ni ni bezi kuwana chimwi zana. ");
INSERT INTO sbs_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Linu mu munyange iyo ineo yi mwina cho ku yiha muhikana yo kwete zina ikumi. ");
INSERT INTO sbs_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kakuti ku zumwe no zumwe yo kwete ka hewa zingi, mane ne ku zambiliza. Mi ku zumwe ni zumwe ye kusena chena nacho, mane nechina chichita kuti wina nacho ka chi nyangwa. ");
INSERT INTO sbs_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Muhinde musohele muhikana uzu ya sena mutendo, mu musohele hanze ku kelima uko kwina kuwunzula ni kulila inkunkuma.” ");
INSERT INTO sbs_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Mi Mwana wo Muntu chi neza mu ku belenga kwa kwe ni mangiloi onse naye, linu njete ne kale ha chipula chakwe cibelenga. ");
INSERT INTO sbs_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Mi habusu bwakwe, ka kunganyeza mishobo yonse, mi njete na taule bantu mukati kabo, sina mulisini mwa tawila imbelele mu impene. ");
INSERT INTO sbs_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Kaabike imbelele kwi yanza lya kwe lya malyo, kono impene izo cho kuzibika ku lya mamonso. ");
INSERT INTO sbs_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Mi linu Simwine njeti na wambe nabo bena kwi yanza lya kwe lya malyo, “Mwize, unwe mu helwa mikonde kwa Tayo, muswane mubuso u mu bikilwa kuzwa ku nkanda ni yi pangwa. ");
INSERT INTO sbs_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kakuti ni ba fwile inzala mi mwaniha zo kulya, ne nyotwa iba nikwete mi nimwani nywisika, mane ne buyenzi ne bali ni muyenzi mi ni mwani tambula. ");
INSERT INTO sbs_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Hape ni ba kosokelwa mi ni mwani zwatika, kuzwaho hape chini lwala mubani tokomeli, ne mu intolongo mubeza kwangu.” ");
INSERT INTO sbs_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Linu bajolola njeti ni be tabe ni bati, “Simwine, njilili ha tuba ku boni no fwile inzala ni twa kulisika? Kamba no fwile inyotwa mi ni twa kuha menzi? ");
INSERT INTO sbs_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Hape njilili ni twa ku bona noli umwene mu ni twa kwinjilika mu mazubo etu? Kamba no wina mapunu ni twa ku zwatika? ");
INSERT INTO sbs_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Hape mane njilili ni twa kubona no lwala kamba no wina mu intolongo ni twa ku potela? ");
INSERT INTO sbs_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mi Simwine njete na betabe cho kuti, cho busakusima ni milwila kuti chi mubachitile bobwabo ba nyanseha ba ba kwangu mu ba chini chiti.” ");
INSERT INTO sbs_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Linu njete na cho kwabo bena kwi yanza lyakwe lya ma monso muzwe kwangu, “Muzwe hangu unwe mukutitwa, muye ku mulilo u chitilwa jabulusi ne mangiloi akwe, ");
INSERT INTO sbs_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","kakuti ni ba fwile nzala, kono kena mubanihi cho kulya, ni ba fwile inyotwa, kono kena mubanihi menzi. ");
INSERT INTO sbs_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ni bali ni muyenzi, kono kana mubani tambuli, ni ba kusokelwe, kono kena mu bani zwatiki, nibali kulwala ni kuba muntolongo, kono kahena mubani potela.” ");
INSERT INTO sbs_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Mi nabo njete ba mwi tabe cho ku mucho kuti, “Simwine, njilili ni twa kubona no fwile nzala, kamba nofwile inyotwa, kamba noli u muyenzi, kamba no kusokelwa, kamba no wina mu intolongo mi kahena tuba ku tendeli cimwi? ");
INSERT INTO sbs_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Kuzwaho njete na be tabe cho kuti, “Cho busakusima ni mulwila, chimusana mu ba pangili a bo bantu ba nyanseha bo bwabo kena mu ba chini chitili. ");
INSERT INTO sbs_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Mi aba ka bayende mu ikatulo yi sa mani, mi ba jolola abo ka bayende mu buhalo bu sa mani.” ");
INSERT INTO sbs_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Kweza ku pangahala kuti Jesu ha mana a a manzwi onse, na wamba ne balutwana bakwe, ");
INSERT INTO sbs_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mwizi kuti mumazuba obele ku keeza ku zambuluka, mi mwana muntu iye ukeza ku zwisikizwa ku bambulwa.” ");
INSERT INTO sbs_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ku zwaaho bapulisita ba kulwana ni ba kulwana ba ba bantu ni ba kunganela boonse mwi nzubo ya mupulisita mukulwana we zina lya Kayafasi. ");
INSERT INTO sbs_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Mi niba nahaninsana muba wola ku wonda Jesu mu chipili cho ku mu ihaya. ");
INSERT INTO sbs_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ka kuti ba bali kucho kuti, “Isiñi mu inako yo mukiti, ku chitila kuti kanzi kubi ne munyunga mukati ka bantu.” ");
INSERT INTO sbs_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Mi linu Jesu co sina mwa Betani mwi nzubo ya Simoni we ci senda, ");
INSERT INTO sbs_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ca bali kwi kala he tafule, mukulwakaazi neza kwali nakahindite i nkooma ye zinunkisa bulootu zi dula, mi nazimwitila mu mutwi. ");
INSERT INTO sbs_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kono balutawana bakwe cinga ba bona bulyo, ni beza kwaali co kunyelwa ni bati, “Ii baka nzi lileta ku zenenga ku ka sika aha? ");
INSERT INTO sbs_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","A a mafuta niauziwa camali mangi cokuha ba humanehi.” ");
INSERT INTO sbs_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Kono Jesu, cho kwiziba ici, nabaco kuti, “Mu katalekeza inzi uuzu mukulwaakazi? Kakuli ime cani npangila buloti. ");
INSERT INTO sbs_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mwina neba humanehi inako yoonse, kono kete mube name inako yonse. ");
INSERT INTO sbs_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ka kuti ha nitila a a mafuta hamubili wangu, u ni bakanyeza ku ungwa kwangu. ");
INSERT INTO sbs_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Cho kwizula ni mu wambila kuti, “konso kwete mulaezo ni u kutazwe mu inkanda yonse, uzu mukulwaakazi chacha panga kachi wambwe choku mu kumbulukwa.” ");
INSERT INTO sbs_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kuzwa aho zumwi wabe ikumi ne bobele, yabali kusumpwa Judasi Isikaliota, nayenda kuba prisita bakulwana cho ku ");
INSERT INTO sbs_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","kacho kuti, “cimuwola kuniha chinzi kuti nimumihe?” Mi ni bamubalila i silivela ya buwayaya wa mali bulikana makumi otatwe cho ku a muha. ");
INSERT INTO sbs_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kuzwa cheyeyo inako nekala nasaka kuwana chibaka cho kumubaha. ");
INSERT INTO sbs_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Linu mu izuba lye ntanzi lye chinkwe chi sa bili balutwana cho kuiiza kwa Jesu cho kucho kuti, “Njo kuhi kosaka kuti tuka ku bakanyeza zilyo zoku zambulukwa? ");
INSERT INTO sbs_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","“I ye cho ku bacho kuti muyende mumuzi mo mu kawane mukwame kuzwa ho muka mucho kuti, “muluti uti, “Inako yangu chiyasika. muni kekaliile ku zambulukwa mu nzubo yako ime ne balutwana bangu. ");
INSERT INTO sbs_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","“Mi Balutwana ni ba chita ka kuya cha Jesu mwa ba balati, mi niba ka bakanya zilyo zo ku zambulukwa. ");
INSERT INTO sbs_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Chitengwana chinga cha sika, ne kala hansi cho ku tanga kulya ne balutwana bakwe bena ikumi ne bobeele. ");
INSERT INTO sbs_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Chi ba kwete kulya eye cho ku cho kuti, “Cho busakusima ni mu lwilite u mwina mukati kenu mwani wuze. ");
INSERT INTO sbs_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Choku shala chiba zuwa butuku, mi zumwi ni zumwi wabo choku tanga ni ba mubuza ni bati, “Aa kahena ime mwendi simwine?” ");
INSERT INTO sbs_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Mi ne taba, “Iye mwine yete asunse name mukasuba njeye yeti ani wuze. ");
INSERT INTO sbs_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwana wo muntu mwa yende, sina mukuñoletwa cha kwe. kono kumaibite uzo muntu iye yete na uuze mwana muntu! ni kubabi neenza kati uzo muntu nasana a bazalwa.” ");
INSERT INTO sbs_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judasi, ya ba kukeza ku ku mu wuza nacho kuti,” A njeme, muluti?” Iye cho ku mwitaba nati. “Chi wa wamba uwo umwine.” ");
INSERT INTO sbs_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Chi basi kwete kulya, Jesu choku hinda chinkwe, nachiha mikonde, cho kuchi gamuna. Nachiha balutwana cho kucho kuti, “Muhinde, mulye. nje nyama yangu iiyi.” ");
INSERT INTO sbs_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nahinda i nkomoki cho kuli tumela, cho ku ibaha choku wamba kuti, “Mu iñwe, mubonse. ka kuti. ");
INSERT INTO sbs_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","A a malaha angu o ku zuminzana ku hiya etililwa bungi bungi bwa bantu kuti ba wole ku wondelwa zibi zabo. ");
INSERT INTO sbs_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kono ni mu cho kuti, keete nini boole hape ni nywe menzi e chihantu cho mu woomba, mbwita mwe lina izuba chi nina u nywa bu hiya na nwe mumu buso wa taayo.” ");
INSERT INTO sbs_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Mi chinga ba maana ku zimba luzimbo, niba tantukira he iwulu lye ruundu lye zitente. ");
INSERT INTO sbs_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Linu Jesu choku bacho kuti, “Mu boonse mu munitiyile masiku anu suunu che ibaka lyangu, ka kuti kuñoletwa, 'Kani dame mulisani mi imbelele zo mulaka izo cho ku gaanuka.' ");
INSERT INTO sbs_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Mi chi nina buswa, kani yende habusu bwenu kuya kwa Galilea.” ");
INSERT INTO sbs_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Kono Pitolosi na wamba naye, “Mane ngati bonse kaba ku tiile, Ime keeti chini ku tiila.” ");
INSERT INTO sbs_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesu na mucho kuti, “Chobusakusima ni kulwilite, mwaanu masiku muukombwe ni useni kulila mo ukuli sampwile ko tatwe.” ");
INSERT INTO sbs_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pitolosi na mucho kuti, “Mi ime ni wola ku fwa nawe, keti chini ku li sampula.” Mi balutwana bonse nabo cho ku wamba indaba iswana. ");
INSERT INTO sbs_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ku uzwaho Jesu nayenda nabo ku chibaka chi sumpwa Getesimane cho kucho balutwana bakwe,” Mu ikale aha chi nisi kaya haana kuku lapela.” ");
INSERT INTO sbs_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Mi na hinda Pitolosi ni baanaswisu bobele ba Zebedia mi na tanga ku wiilwa ne ku katazeha. ");
INSERT INTO sbs_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ku zwaaho choku bacho kuti,” Luhuho lwangu chi lwa sasaminwa, muniwola kufwa. Linu mu ikale hohwaha mu liise name.” ");
INSERT INTO sbs_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Mi na yenda ha busuzana bulyo, cho kuwa cho busu bwake, choku lapela. Naati, “Tayo, haiba ku wooleka, iyi inkomoki ini zambuluke. Mi, ni hakuba bulyo, sanzi ku pangahali kusuna kwangu, mi bulyo ku pangahale kwako.” ");
INSERT INTO sbs_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Mi neeza ku balutwana bakwe cho kuiiza kuba wana ba sukwiile, mi nacho Pitolosi,” Au mukangwa ku iiza name nangati inako imwina bulyo? ");
INSERT INTO sbs_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mu liise choku lapela kuti sanzi mu injili mu muliko. Luhuho lu suni, mi bulyo inyama iyo i kangwa.” ");
INSERT INTO sbs_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Mi na zwa cho kwenda hape lo bubeli cho kuka lapela, nati, “Ita, haiba i chi keti chichi hita mbwita ni chinwe, ku suna kwako ibe uko ku pangahala.” ");
INSERT INTO sbs_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Mi neeza hape cho kuiiza ku bawana ba sukwile ka kuti menso abo a bali ku lema ne ku lema. ");
INSERT INTO sbs_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ku zwaaho hape cho kuba siya cho kuli yendela. Mi na lapela lo butatu hape na wamba manzwi a swana bulyo. ");
INSERT INTO sbs_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ku zwaaho Jesu ne za ku balutwana cho ku bacho kuti, “Mu si lele ne kuli teeka? Mu bone, inako chiya sika, mi mwana Muntu chohewa mu ma yanza a ba fosahele. ");
INSERT INTO sbs_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mu buuke, tuyende. Mu bone, iye yoni wuza cho wina hafuhi.” ");
INSERT INTO sbs_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Mi haba si kwete ku wamba, Judasi, zumwi wa be ikumi ne bobele, neeza. Bungi-bungi bwa bantu cho kuiiza naye kuzwa ku mu prisita mukulwana ni ba kulwana ba bantu. Mi ne beza ne mafulo ne inkoli. ");
INSERT INTO sbs_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Linu muntu ya bali kuya ku ku wuza Jeeso naa baha chikuka, nati, “zumwe ne zumwe bulyo yete nikoote, njeye uzo. Mumu wonde.” ");
INSERT INTO sbs_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Hohwaho bulyo neeza kwa Jesu cho kucho kuti, “Lumele, Muluti!” Mane choku mu koota. ");
INSERT INTO sbs_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesu choku mucho kuti, “Mwangu, chite bulyo cho ke zilile ku panga.” Mi linu mpu bezilile mane cho ku wonda Jeeso chamayanza abo, cho kumusumina. ");
INSERT INTO sbs_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mu bone, zumwi waba beena ne Jesu na zwisa iyanza, cho ku kwita kafulo, mi naa kanka muhikana wo muprisita mukulwana ahulu, cho ku kosola kutwi kwakwe. ");
INSERT INTO sbs_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ku zwaaho Jesu namu cho kuti, “Booze kafulo kako muci biko cateni, kakuti abo bete ni ba kwi kala ni ba zwisa kafulo ka bafwe cha kafulo. ");
INSERT INTO sbs_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","A mi muzeza kuti ni kangwa ku wamba ni Tayo, ku zwaaho iye cho kuni tuminiza ma ñgiloi a zamba mianda mianda ina ikumi ni yo beele? ");
INSERT INTO sbs_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Linu mbobule mañolo mu a wola ku izuzilizwa, haiba i chi ni chi sa pangahali?” ");
INSERT INTO sbs_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Cheyo inako Jesu na wamba ne bungi-bungi bwa bantu, “Mu ka ni ziilile ni mafulo ni inkoli kwiza kuni wonda mane sina ni musaa? Ni bali kui kala i zuba ni zuba mu itempele ni ni luta, mi ka hena mu bani wondi. ");
INSERT INTO sbs_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mi zo nse izi chi za pangahali kuti zi ñoletwa ne bapolofita zi wo le kwi zuzilizwa.” ku zwaaho balutwana bonse ni ba musiya ni ku muñombwela. ");
INSERT INTO sbs_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mi linu a bo ba ba wondi Jesu ni ba mutwala kwa Kayafasi muprisita mukulwana, uko bañoli ni ba kulwana ku ba ba kunganine. ");
INSERT INTO sbs_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Kono Pitolosi na be chilila mu isule ku ya kwi laapa lyo mupurisita mukulwana ahulu. Ne njila mukati cho ku ke kaala niba shangabila kuti a bone ma mani mani. ");
INSERT INTO sbs_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Mi linu maprisita ba kulwana ni ba yeelezi bonse ba li ku gana bupaki bwa mapaa bwa ku hambiliza Jesu, kuti ba mwi haila hateni. ");
INSERT INTO sbs_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Mi ni ba bula na ngati ci nini mu zonse zi ntu zi ba ba mu hambiliza, nangati ku beezi ha busu bapaki bangi ba mapa. Kono ku ma mani mani ni kweza bo bele ha busu ");
INSERT INTO sbs_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","mi na cho, “U zu unkosi a ba cho kuti,' Ni woola ku za ku nuna itempele ye Ireeza mane cho ku i zaaka mu ma zuba otatwe.” ");
INSERT INTO sbs_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Muprisita mukulwana ahulu mi na ziima choku mucho,” Ko wina cho wi taba hateni? Chinzi chi ba paka ku a mana nawe? ");
INSERT INTO sbs_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kono Jesu a ba tontwele. Muluti mukulwana ahulu na muco kuti,” Ni ku laula ce Ireeza yo u hala, tu lwile haiba njowe Kirisite mwaana we Ireeza.” ");
INSERT INTO sbs_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesu cho kumwi taaba,” Chi wa wamba iwe u mwine. Kono niku luiirite, ku zwa hanu ko bone mwana mu kwame neekele ku iyanza lya malyo lye ziho, na keeza mu makope e iwulu.” ");
INSERT INTO sbs_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ku zwaho mupulisita mukulwana ahulu na halola zi zabalo zakwe cho kuti, “Cha waamba ku tukana! Tu sakila nzi ba paki! mu bone, linu hanu mwa li zuwila ma tuka. ");
INSERT INTO sbs_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mu yi bona bule?” Abo nibe taaba ni bati, “U swanela ifu,” ");
INSERT INTO sbs_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kuzwaho cho ku mu swila mate mu busu bwa kwe cho kumu kaba, cho ku i kala ni bamu woo pola che mpama ");
INSERT INTO sbs_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ni bati, “Tu polofitele, i we Kiresite. Njeni iye waku kaba?” ");
INSERT INTO sbs_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Hohwaho Pitolosi cho si keele hanze lye ilaapa, mi mu hikana wo mwana kazana cho kuiza kwali na mucho kuti, “Na we sa ka wina ni Jesu wa Galalea. ");
INSERT INTO sbs_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","“Kono iye na kanana ha busu bwa bo bonse, nati, “Kanizi kuti u kwete u wamba kaha cinzi.” ");
INSERT INTO sbs_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ha yenda hanze ku me njililo a mulyango, zumwi mukazanana wo muhikana na lwila a bo ba be na ha teni, “Uzu unkosi na ye wina ni Jesu wa Nazareta.” ");
INSERT INTO sbs_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Mi iye na kaanana cho kukonka nati, “uzo unkosi ka ni mwizi.” ");
INSERT INTO sbs_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ka ba kazana bulyo kwa bo ba ba li zimanine ne be za kwa Pitolosi cho ku mucho kuti,” cho busakusima na we u umwi wa a bo, ka kuti ne lulimi lwako lu ku paka.” ");
INSERT INTO sbs_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Na tanga ku kuuta ni ku koonka. “Ka nizi uzo unkosi,” cho bufwihizana hohwaho mukombwe cho kulila. ");
INSERT INTO sbs_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pitolosi na ku mbulukwa ma anzwi a ba wambi Jesu, “Pili mukombwe ni u seni ku lila mo kunili sampwile ko tatwe. “Ku zwaho mpwa zwilile hanze cho ku ka lila na boonda. ");
INSERT INTO sbs_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ka kusasani ha ku sika, bonse ba kulwana ba mapurisita ni ba kulwana ba bantu ba ba li kufumba muba wola kwi hayila Jesu. ");
INSERT INTO sbs_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ni ba musumina, ni kumu zwisa hateni, ni ku mu twala kwa Pilato mubusi. ");
INSERT INTO sbs_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Linu ku zwaaho Judasi, ya ba muuzi, na bona Jesu cho nyanswa, mi na baka ni ku booza mali e ikumi ni to tatwe ku maprisita ba kulwana ni ba kulwana, ");
INSERT INTO sbs_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","mi nati, “Ni ba pangi chibi ku uza malaha a sena mulandu. “Mi ni ba cho, “Chinzi icho kwetu? U bone kwa teni umwine.” ");
INSERT INTO sbs_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ku zwaho na sohela hansi bu wayawaya bwa mali mu itempele, cho ku katuka, mi na yenda kunze cho ku kali sungilila. ");
INSERT INTO sbs_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ba kulwana ba maprisita ne ba hinda buwayawaya vwa mali mi ni ba mucho, “Ka ku lukeli ku bika a a mali mu chibikilo ka kuti mali a malaha.” ");
INSERT INTO sbs_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ni ba wambola che yo indaba ha mwina mi chawo mali ni ba wuula iwaa lyo ku bumbila tu hambwe mwete ba ku zikwa ma buu kwenda. ");
INSERT INTO sbs_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Cheli ibaka lina iwa lisi sumpwa, “Iwaa lya malaha” ne linu izuba buti. ");
INSERT INTO sbs_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nji kuti chiba wambiwa ni mupolofita Jelemaya chi izuzilizwa, cho kuti, “Ba ba hindi makumi otatwe o buwayawaya, mu wulo u ba tomwa haakwe ni bantu ba Isilaele, ");
INSERT INTO sbs_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Mi ni baiha ku mwiine we iwa lyo ku bumbila tu hambwe, sina Ireeza mwa bani heli chikuka.” ");
INSERT INTO sbs_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Linu Jesu na zima ha busu bo muyendisi, mi muyendisi na mu buza, “Kana njowe simwine wa ma Juda?” Jesu cho mwi taaba, “Mu wa cho.” ");
INSERT INTO sbs_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kono ha baali kunyanswa ni ba kulwana ba mapurisita ni ba mwi ba kulwana, na bula kwi taaba chimwi. ");
INSERT INTO sbs_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ku zwaaho Pilato na mucho, “Ko zuwile yonse iyi milandu yo kwete u bikwa?” ");
INSERT INTO sbs_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kono na bula kwi taaba ne haiba li mwina inzwi, ku chita kuti mubusi na shala u komoketwa ahulu. ");
INSERT INTO sbs_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Linu ha mukiti chi bali chizo cho mubusi ku zwisa chifosi chi mwina cha salwa ne bantu bangi bangi. ");
INSERT INTO sbs_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Cheyo inako yi swana ku bena ibantiti li ba fosahele ahulu, lyi bali ku sumpwa Barabasi. ");
INSERT INTO sbs_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Mi ha baba ku kuunganele ha mwina, Pilato na ba cho, “Njeni wumu saka kuti ni mumu lukulwile? Barabasi, nandi Jesu yo sumpwa Kiristi?” ");
INSERT INTO sbs_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kakuti a ba kuiizi kuti ba ba mu woondi bulyo cho muna. ");
INSERT INTO sbs_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Cho usii keere ha chipura choku watula, mu kaakwe na tumina linzwi kwaalyi nati, “Sanzi u pangi chimwi koozo muntu ya sena mulandu. Kakuti na nyanda ahulu maswe suunu mu chilooto che ibaka lyakwe.” ");
INSERT INTO sbs_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ku zwaaho mapurisita bakulwana ne ba kulwana ni ba shongelekeza bungi bungi bwa bantu kuti ba kumbile Barabasi, ne kuti Jesu iye e ihayiwe. ");
INSERT INTO sbs_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Mubusi na ba buuza, “Njeni ku boobele wumu saka kuti nni mumu lukulwile?” Ne ba cho, “Barabasi.” ");
INSERT INTO sbs_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato na ba cho, “Linu ni pange inzi cha Jeeso yoo sumpwa Kilisiti?” Bonse ni be taba, “A bambulwe.” ");
INSERT INTO sbs_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Mi na cho, “Ibaka, mulandu nzi waa ba pangi?” Mi a bo ni ba huwa ahulu hulu, “Mu mu bambule.” ");
INSERT INTO sbs_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Mi linu Pilato chinga bona kuti ka kwina cha wola ku panga, mane ni kuti chi kuba tangite mu nyunga, na hinda menzi, cho ku samba ku maanza ha busu bwa bantu bangi, cho kucho kuti, “Ka nina mu laandu cha malaha o zu muntu ya sena mulandu. Mu kuzwe kwenu kuti mu chita bule.” ");
INSERT INTO sbs_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Bantu bonse ni bati, “A malaha a kwe a be kweetu ne ku baana betu.” ");
INSERT INTO sbs_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ku zwaaho na ba sumunwina Barabasi, kono na shimeha Jesu ni ku mu baha kuti a bambulwe. ");
INSERT INTO sbs_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ku zwaaho masole bo mubusi neba leta Jesu ku chikota china mu meekalo a mubusi ni ku kunganya masole mangi. ");
INSERT INTO sbs_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ni ba mu zabula cho ku mu bwika chizabalo chi subila. ");
INSERT INTO sbs_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ku zwaaho ni ba panga i hwiisi yo miiya ne kuyi mu bika ha mutwi, choku mu bika inkoli mu iyanza lyakwe lya malyo. Ni ba fukama ha busu bwakwe neku musheunwina, niba cho, “Lumele, Simwine wa Majuda!” ");
INSERT INTO sbs_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Mi neba muswila, mi niba hinda inkoli cho kuyi mu kabisa mu mutwi. ");
INSERT INTO sbs_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Haba mana ku musheunwina, cho kumu zabula chizwato ku zwaaho cho kumu zabika zizabalo zaakwe, ne ku mu twala kuku bambulwa. ");
INSERT INTO sbs_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Haba bati chiba zwila hanze, ni ba waana unkosi yo zwila kwa Sayirine yo sumpwa Sayimoni, u baba hambiliza kuti a yende naabo ne kuti a mu kulikile chifapano. ");
INSERT INTO sbs_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ni beeza ku chibaka chi sumpwa Gologota, chi landununa kuti “Chibaka cha Kagoboli.” ");
INSERT INTO sbs_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ni ba muha iwaine yiina shantukwe kuti a nywe. Mi chinga a yi soola, choku sayi nywa. ");
INSERT INTO sbs_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Haba mana kumu bambula, cho kuli kauhanyekeza zizabalo zakwe choku kaba indaula. ");
INSERT INTO sbs_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ni be kala choku muliisa. ");
INSERT INTO sbs_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","He iwulu lyo mutwi waakwe niba bika iñolo lyo mulandu, li baali ku balika kuti “Uzu nje Jesu, simwine wa Majuda.” ");
INSERT INTO sbs_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Basaa bobeele ni ba kokotelwa naye, zumwi ku malyo a kwe mi zumwi ku ma moonso. ");
INSERT INTO sbs_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ba baali ku hita ni ba mu tukoola, ni ba nyunga mitwi yabo ");
INSERT INTO sbs_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ni bati, “Uwe yo bali kuti moo rutunune itempele choku izaka mu ma zuba o tatwe, lihaze umwine! Haiba u Mwana we Ireeza, suke ha chifapaano!” ");
INSERT INTO sbs_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Che nzila i swana bapurisita ba kulwana ba baali ku musheunwina, ha mwina ni ba ñoli ni ba kulwana, ni bati, ");
INSERT INTO sbs_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“A ba ku haza bamwi, kono ka woli ku li haza mwiine. Njeye Simwine wa Isilaele. A suuke ha chifapano, mi ku zwaaho linu njete tu zumine mwaali. ");
INSERT INTO sbs_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","U sepa mwe Ireeza, A Ireeza a mulamulele hahanu buti haiba u saka, ka kuti a baco kuti, 'Njeme mwanaswisu we Ireeza.'” ");
INSERT INTO sbs_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Mi basaa ba bati ni ba bambwilwe na ye naabo niba wamba matuka kwali. ");
INSERT INTO sbs_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Linu ku zwaaho che inako yoku mana iyanza ne ka mwina kerima nika wumba inkanda yonse mbwita kuka sika ku inako yoku mana iyanza ne toone. ");
INSERT INTO sbs_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Che nako yoku mana iyanza ne toone Jesu na huwa che liinzwi ikando na cho, “Eli, Eli, La ma sabakatani?” yi landununwa kuti, “Ireeza wangu, Ireeza wangu, chinzi ho ni sohelele?” ");
INSERT INTO sbs_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Linu ba mwi ba ba zi meene ukochinga ba zuwa bulyo, ni bati, “U kwete ku sumpa Elija.” ");
INSERT INTO sbs_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Hohwaho bulyo zumwi waabo na tiya choku ka leta chi pongi, cho ku chi niika mwa shantukwe, ni ku chi bika ha luuhe, ni ku muha kuti a nywe. ");
INSERT INTO sbs_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bungi bwabo ni bacho, “Mu mu siye yeyena. Tu bone kuti nandi Elija mweze a mu haaza.” ");
INSERT INTO sbs_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ku zwaaho Jesu hape na huwa che linzwi ikando cho kumana luuho. ");
INSERT INTO sbs_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Boone, i jira lyo mu itempele ni lya haluka ko beele ku zwila kwi uulu ku leta hansi. Mi inkanda ni ya nyanganya, ku zwaaho mabwe choku pwachuka hakati. ");
INSERT INTO sbs_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ma kuumbu ni e wuka, mi mi bili ya bantu ba shiyeme ba ba lele ni ba buuka. ");
INSERT INTO sbs_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ni baazwa mu makuumbu chinga a buuka ku bafu, nibe njila mu muzi mukando u jolola, mane niba boneka ku bantu bangi. ");
INSERT INTO sbs_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mi musenchoriona na bo baba lolelele Jeeso ni ba boona kunyanganya kwe inkanda ni zintu zi bati niza pangahala, cho kuli kalililwa ahulu maswe ni bati, “Cho busakusima uzu ibali mwana we Ireeza.” ");
INSERT INTO sbs_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Bakulwakazi bangi baba ke ichilile Jeeso ku kazwa kwa Galalia cho kumu babalela ba ba zimene butabule ni ba lolelele. ");
INSERT INTO sbs_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mukati kaabo ku bena Maria Magadalena, Maria nyina wa Jakobo ni Josefa, ni nyina wa baanaswisu ba Zebedea. ");
INSERT INTO sbs_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Chinga yaba chitengwana, ni kweza unkosi wo muhumi yo zwa kwa Arimatea, we izina lya Josefa, iye naye ya bali mulutwana wa Jesu. ");
INSERT INTO sbs_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Na ya kwa Pilato mi na ka kumbila mubili wa Jesu. Pilato na laela kuti a wu hewe. ");
INSERT INTO sbs_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josefa na hinda mubili, na wu bungila mu ijila li jolola, ");
INSERT INTO sbs_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","mi choku kawu bika mu ikuumbu lyaakwe ihiyai lya ba hindi cho kuli beeza mu ibwe. Ku zwaaho na pindumwina ibwe ikando ha mulyango we ikuumbu mi nali yendela. ");
INSERT INTO sbs_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Magadalena ni zumwi Maria ku ba bena, ni be keele he shilya lye kuumbu. ");
INSERT INTO sbs_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Izuba li chilila, i bali izuba lya lo mugivero, Ma purisita ba kulwana ni Bafarisai neba kunganela ha mwiina kwa Pilato. ");
INSERT INTO sbs_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Cho kuti, “Unkosi, tu kumbulukwa kuti zuna shaamapa cho usii hala, a bati nati, 'Kani buuke mazuba otatwe haa hita.' ");
INSERT INTO sbs_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Chingi linu u lukele ku laula kuti ikumbu lika liiswa ahulu maswe mbwita luzuba lo butatu. Ni kusabi bulyo balutwana bakwe mu beeze ba muyibe ku zwaaho cho kucho bantu, 'Cha ba buuki kubafu.' Ka kuti ku chenga kwa mamani mani mu ku zambe kwe ntanzi.” ");
INSERT INTO sbs_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato na bacho kuti, “Mu hinde shangabila. Muyende muka liliise hakando mu mu wolela monse.” ");
INSERT INTO sbs_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Mi niba yenda cho kuka siinka che ibwe, choku viika shangavira. ");
INSERT INTO sbs_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Hwaho chitengwana cha lwe Sabata, ha chi libali ku ñatula kuti ibe luzuba lwe tanzi lwe Nsunda, Maria Magadelena ni Maria zumwi, ni beza ku kubona ikumbu. ");
INSERT INTO sbs_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Mubone, ni chii kweza ku nyanganya ku kulu, kakuti lingiloi lya Simwine li bazwile ku iwulu, kwiza ku pindumuna ibwe, kuzwaho ni kwi kala hateni. ");
INSERT INTO sbs_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ciswano calyo libali kuswana ni mumuni we nvula, mi zizwato zalyo zibali kutuba sina kapuku. ");
INSERT INTO sbs_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ba shangabila ni ba nyungeha ka kutiya mi ni ba ba sina bantu ba fwile. ");
INSERT INTO sbs_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ingiloi chi lya wamba ku banakazi ni lya cho kubali, “Kanji mutiyi, kakuti nizi kuti musaka Jesu, ya ba kokotelwa. ");
INSERT INTO sbs_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ka mwiina munu, kono ca buka sina mwa ba wambilile. Mwize za mubone za mwalele Simwine. ");
INSERT INTO sbs_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Muyende hahanu muka balwile balutwani bakwe, 'Wa buka ku bafwile. Mubwene, mwa litangize habusu bwenu ku kuya kwa Galillea. Wuko ka muka mubone.' Mubone, na mi wambila.” ");
INSERT INTO sbs_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Banakazi hwaho ni bazwa he ikumbu ni batite ni kusanga ahulu, mi chi batilila ku ku kalwila balutwani bakwe. ");
INSERT INTO sbs_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mubone, Jesu cha bawana na cho, “Mulumele mubonse.” Banakazi ni beza, ne ku mukwata ku matende mi ne ba mufukamina. ");
INSERT INTO sbs_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Mi Jesu na cho kubali kuti, “Kanji mutiyi. Muyende mu kalwile bance bangu kuti ba zwe bayende kwa Galilea. Kwateni ime mu bakani bone.” ");
INSERT INTO sbs_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mi hwaho banakazi ha baba kukaya, mubone, bamwi ba shangabila chi ba yenda mu munzi mukando ni ba wambila bapuritsa bakulwana zintu zonse za tendahala. ");
INSERT INTO sbs_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Mi bapuritsa ha kopana ni bakulwana ku wambola indaba na bo, ni baha mali mangi ku masole ");
INSERT INTO sbs_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ne ku balwila, “Muwambe ku bamwi kuti, balutwani bakwe Jesu bakeza masiku beza kwiba mubili wakwe chitu silele. ");
INSERT INTO sbs_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Haiba inu ndaba ni isika ku muyendesi, katu mu suunde neku zwisa intongosi kwenu.” ");
INSERT INTO sbs_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Mi masole ne ba hinda mali niku tenda mu baba wambililwa. Iyi indaba i ba hasani ahulu mukati ka Majuda mi mane ne suunu yisi zwilila habusu. ");
INSERT INTO sbs_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kono balutwani bene ikumi ni wu mwina ni baaya kwa Galilea, ku iluundu ilyo Jesu lya baba wambile. ");
INSERT INTO sbs_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Mi haba mubona, chi ba mu kubamela, kono bamwi ni ba kangwa ku zumini. ");
INSERT INTO sbs_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesu neza kwabo ne ku wamba kubali ni kucho, “Mataa onse abahewa kwangu, a kwi ulu ni aa hansi. ");
INSERT INTO sbs_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Linu muyende, muka pange balutwani ba machaba onse. Mu ba kolobeze mwi ziina lya Tayo, lya Mwana mane ni lya Luhuho lu Jolola. ");
INSERT INTO sbs_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mu balute ku mamela zintu zonse zi ni ba mi laele. Mi mubwene, ka ni kale nanwe inako yonse, mane ku twala ku ma mani ni nizo e nkanda.” ");
INSERT INTO sbs_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Aa nji matangilo e Ivangeli ya Jesu Kresite, mwana wa Ireeza, ");
INSERT INTO sbs_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ubu muiñolelwe mwa Isaya muporofita, “mubone, nitumine mutumiwa wangu habusu vwenu, iye yeti navakanye inzila yenu. ");
INSERT INTO sbs_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Inzwi lya umwina litabeleza mwihalaupa, 'Mubakanye inzila ya Simwine; mutende mwahita kuoloke.”' ");
INSERT INTO sbs_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Johani abakezi, nakolobeza mwihalaupa ni kukutaza inkolobezo yo kubaka kuti zive ziwondelwe. ");
INSERT INTO sbs_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Inkanda yonse ya Judeya ni bantu bonse ba mwa Jerusalema babayendi kwali. Babakakolobezwa kwali mulwizi lwa Jorudani, ni baliwamba zive zabo. ");
INSERT INTO sbs_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Johani a balikuzwete ijansi lyabooza bwe Kamele ni lutunga lwedalo mumunda yakwe, mi abali kulyanga impaanse ni buchi bwamumuzuka. ");
INSERT INTO sbs_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Abaaruti, “Zumwi ukezite mumasule angu yokolete kunizamba, imi kaniyelele nanga kukotama kusumununa tukwele twensangu zakwe. ");
INSERT INTO sbs_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nibamikolobezi chamenzi, kono iye kamikolobeze cha Luhuho lujolola.” ");
INSERT INTO sbs_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Chibatendahali mwao mazuva kuti Jesu abakezi kuzwa Nazareta mwaGalileya, imi abakolobezwa kwa Johani mulwizi lwa Jorodani. ");
INSERT INTO sbs_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesu hazubuka bulyo mumenzi, a baboni iwulu niliyaluka ni Luhuho nilusuukila hali ubu inkuba. ");
INSERT INTO sbs_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Imi liinzwi nilyazwa kwiwulu, “Umwanangu, inisaka kuhitiliza, nikondetwe chako.” ");
INSERT INTO sbs_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Linu luhuho chilumutumina kuyenda mwihalaupa. ");
INSERT INTO sbs_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Abena mwihalaupa mazuva ena makumi one, nakwete kulikwa kwaSatani. Abena ni zinyolozi zamunkanda, imi mangiloi abamuhazi. ");
INSERT INTO sbs_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Linu kuzwa hakusuminwa kwa Johani, Jesu nakeza mwaGalileya kukabuwamba Evangeli ya Ireeza, ");
INSERT INTO sbs_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","nati, “Inako chiyelizuzilikizwa, imi mubuso wa Ireeza chiwina hafuhi. mubake ni kuzumina mwi Evangeli.” ");
INSERT INTO sbs_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Mukukabuyenda kumbali ye Wate lya Galileya, nabona Simoni ni Andulu mukulwe wa Simoni nibalaleka tunyandi twabo mwiwate, mukuti babali bayambi. ");
INSERT INTO sbs_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesu nawamba kubali, “Mwize, munichilile, mi kanimitende bayambi babantu.” ");
INSERT INTO sbs_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Mi haho bulyo nibasiya tunyandi ni kumwichilila. ");
INSERT INTO sbs_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jesu habali kwabuyenda habusuzana, nabona Jakobo mwana Zebediya ni Johani mwanche; babena mubwato ni bawonga tunyandi twabo. ");
INSERT INTO sbs_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Naba sumpa mi babasiyi ishabo Zebediya mubwato ni bahikana babahilitwe, mi babamwichilili. ");
INSERT INTO sbs_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Mi habeza mwaKapenauma, mi Lensabata, Jesu nenjila mwi Sinangonge ni kuruta, ");
INSERT INTO sbs_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Babakomokiswa chamurutilo wakwe, mukuti abali kubaruta ubu njizumwi wina maata isiñi mubekalile bañoli. ");
INSERT INTO sbs_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Hohwaho mukwame yabena luhuho lusanjololi abahuwelezi, ");
INSERT INTO sbs_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","naati, “Chinzi chituswanela kuchita nawe, Jesu wa Nazareta? Kana ubezi kukutusinya? Nizi kuti nguweni. “Nguwe yochena wa Ireeza!” ");
INSERT INTO sbs_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesu nakalimela idimona nati, “Tontole ni kuzwa mwali!” ");
INSERT INTO sbs_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Mi luhuho lusajololi nilwamu sohela hansi ni lwazwa kwali ni lwabubokolola chaliinzwi ikando. ");
INSERT INTO sbs_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Mi bantu bonse babakomoketwe, ni kulibuza abobeene, “Chintunzi ichi? Murutilo munhya wina maata? U wola nanga kulayela luhuho lusajololi mi lumuzuwa!” ");
INSERT INTO sbs_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Mi indaba kuamana naye haho nizayenda konsekonse muchilalo cha Galileya. ");
INSERT INTO sbs_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Mi mukuzwa mwisinagoge, nibeza munzubo ya Simoni ni Andulu, ni Jakobo ni Johani. ");
INSERT INTO sbs_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Lyahanu mukwenyani wa Simoni wo mwanakazi abalele u lwalite ifibele, mi niba wambila Jesu chakwe. ");
INSERT INTO sbs_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Linu nakeza, kumuhinda cheyanza, ni kumuzimika mwiwulu; Ifivere niyamusiya, mi chatanga kubasebeleza. ");
INSERT INTO sbs_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Icho chitengu, izuba halimana kwiimina, chibamuletela bonse babalikulwala kapa bena madimona. ");
INSERT INTO sbs_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Muleneñi wonse chiwakopenela hamulyango. ");
INSERT INTO sbs_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Abahozi bangi babena malwalila asiyenesiyene ni kuhindika madimona mangi, kono kanabazuminini madimona kuwamba mukuti abamwizi. ");
INSERT INTO sbs_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Abalitahaneli kubuka kakasasani, ni kusisiha; abanyamuki ni kuyenda kuchibaka chitontwele mi uko abakalapeli. ");
INSERT INTO sbs_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoni ni babena nabo babali kumusakasaka. ");
INSERT INTO sbs_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Babamuwani ni kumuwambila, “Zumwi ni zumwi bakwete kukulolalola.” ");
INSERT INTO sbs_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nati, “Tuyende kumwi ni kumwi, kuzwa mumatoropo azimbulukite, kokuma nikakutaze ko naako. Chobulyo nakeza kunu.” ");
INSERT INTO sbs_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nayenda konsekonse mwaGalileya, nakabukutaza mumaSinangonge abo ni kuya buhindika madimona. ");
INSERT INTO sbs_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Sichisenda abakezi kwali. Abali kumukumbila; nakubama hansi imi namucho, “Chikuti usuni, uwola kunijoloza.” ");
INSERT INTO sbs_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Chokuba ni inse, Jesu chawolola iyanza lyakwe ni kumukwata, kumuwambila, “Ni suni, Jolole.” ");
INSERT INTO sbs_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Hohwaho chisenda nichamusiya, mi natendwa yojolola. ");
INSERT INTO sbs_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesu namukalimela chobukando mi namutumina kuti ayende. ");
INSERT INTO sbs_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Chati kwali, “utokomele kanji uwambi chimwi kumuntu, kono ukwiya, ukalitondeze kumuprisita, mi ukaneule chokujolozwa chabalayeli Mushe, bube bupaki kubali.” ");
INSERT INTO sbs_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kono nayenda ni kukatanga kulwila zumwi ni zumwi ni kuhasanya liinzwi chabukando kuti Jesu kena abali kusiwola kuyenda nasumunikite mwitoropo. Linu nekala muchibaka chintontwele mi bantu babezi kwali kuzwila muzibaka zisiyenesiyene. ");
INSERT INTO sbs_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Hakaboola kwaKapernauma kuzwa hamazubazana, kubazuweekete kuti abena kumunzi. ");
INSERT INTO sbs_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Chobulyo buungi bubakungene kwateni kuti mane kanakubasina ni chibaka, mane nanga hamulyango, mi Jesu nawamba liinzwi kubali. ");
INSERT INTO sbs_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","3 Linu bakwame babezi kwali babaletete mukwame yabazuminine luñañali; bantu boone babamuyengete. ");
INSERT INTO sbs_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Habakangwa kusika hafuhi naye chebaka lyachisi, chibazwisa chituwa hewulu lyamwabalikwina. Chinga basha ilindi mwateni, ni bashulumuna bulo habalele yozuminine luñañali. ");
INSERT INTO sbs_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Chakubona intumelo yabo, Jesu chati kumuntu yozuminine luñañali, “Mwanangu, zive zako zawondelwa.” ");
INSERT INTO sbs_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Linu bamwi bañoli babekele mo, chibalichiula munkulo zabo, ");
INSERT INTO sbs_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Kwizabule kuti uzu muntu awambe cheyi nzila? Unyefula! Yowola kuswalela zive mbwiteri Ireeza yeyena?” ");
INSERT INTO sbs_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mi Jesu hahobulyo neziba muluhuho lwakwe zibabali kuzeza munkulo zabo. Nichati kubali, “Chinzi hamukwete kuzeza bulyo munkulo zenu? ");
INSERT INTO sbs_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Njechihi chihuba kuwamba kuyozuminine luñañali, 'Zive zako zawondelwa' kamba kuwamba kuti, 'Zime, hinde bulo bwako, mi uyende'? ");
INSERT INTO sbs_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Imi kuti mwizibe kuti Mwana Muntu wina maata hansi okuwondela zive,” nawambila yozuminine luñañali, ");
INSERT INTO sbs_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Niwamba kwako, zime, hinde bulo bwako, mi uyende kunzubo yako.” ");
INSERT INTO sbs_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Chazima mi hahobulyo nahinda bulo, ni kuzwa munzubo habusu bwazumwi ni zumwi, kokuti bonse babamakali mi nibaha intumbo kwa Ireeza, mi nibati, “Kana tubeeni kubona chintu chiswana nechi.” ");
INSERT INTO sbs_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Nayenda hape kumbali yewate, mi chisi chonse nicheza kwali, mi na baruta. ");
INSERT INTO sbs_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Mukuhita kumbali, nabona Levi mwana wa Alufeya nekele hetente lya mutelisi, mi nati kwali, “Nichilile.” chazima ni kumwichilila. ");
INSERT INTO sbs_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mi Jesu habali kulya zilyo munzuvo ya Levi, Batelisi baangi ni bantu bezwile zive babali kulya ni Jesu ni barutwana bakwe, mukuti babali baangi mi nibamwichilila. ");
INSERT INTO sbs_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Linu bañoli bamulao, babali baFalisi, hababona kuti Jesu ukwete kulya ni batendi bazive ni batelisi, nibawamba kubarutwana bakwe, “Chinzi halya ni batelisi ni bantu bezwile zive?” ");
INSERT INTO sbs_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Linu Jesu hazuwa bulyo nacho kubali, “Bantu bakolete mumubili kabasuni iñanga; mbwiteli balwala njibaisaka. Kananibakezi kukusumpa bantu bashiyeme, kono kubantu bezwile zive.” ");
INSERT INTO sbs_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Barutwana ba Johani ni baFalisi babali kulinyima zilyo. Imi bantu bamwi babezi kwali ni kumuti, “Chinzi barutwana ba Johani ni barutwana babaFalisi habalinyima zilyo, mi bako barutwana kabalinyimi zilyo?” ");
INSERT INTO sbs_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesu chacho kubali, “Kana kuwoleka kuti bantu bena hamukiti wamaseso balinyime zilyo musesi nasina nabo? Kubona bulyo musesi uchina nabo, kabawoli kulinyima zilyo. ");
INSERT INTO sbs_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kono mazuba akezite akuti musesi nazwiswe kubali, mi mwao mazuva, kabalinyime zilyo. ");
INSERT INTO sbs_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Kakwina muntu yolukila kabbali kakajira kanhya hejira ikulukulu, kundeyobulyo chikamba chinhya muchihaluke ko, chinhya kuchikulukulu. Mi kakube muhalukilo mubilala. ");
INSERT INTO sbs_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kakwina muntu yobika iwaine inhya muchibikilo chewaine chikulkulu chamadalo, kundeyobulyo iwaine muiñatule madalo, mi bubeli bwewaine ni madalo ewaine kazisinyehe. Chovulyo, mubike iwaine inhya mwidalo inhya lyewaine.” ");
INSERT INTO sbs_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Lensabata Jesu nichahita muluwa lwabuheke, mi barutwana bakwe nibatanga kutola mitwi yabuheke. ");
INSERT INTO sbs_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mi bafalisi nibamucho, “Lole, chinzi habachita chintu chisali chamulao mwizuba Lensabata?” ");
INSERT INTO sbs_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Nacho kubali, “Kana chimubabalite chabachiti Dafita hababulite ni kufwa inzala—iye ni bakwame baabena nabo— ");
INSERT INTO sbs_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Mwabenjilili munzubo ya Ireeza Abbiyatare habali mupurisita yohanzi, mi abaali chinkwa chakubako, ili chisali chamulao kuti zuhi no zuhi alye kunde yamapurisita, mi mane naha kwateni amwi kwabana babena naye?” ");
INSERT INTO sbs_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesu nati, “Insabata ibalundilwa bantu, isinyi bantu kulundilwa Insabata. ");
INSERT INTO sbs_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Chobulyo, Mwana muntu Simwine, nanga weNsabata.” ");
INSERT INTO sbs_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Imi hape chenjila mwisinagoge mi kubena mukwame weyanza lizuminine. ");
INSERT INTO sbs_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bamwi bantu babamuteyete hafuhi kubona kamba mwamuhoze Lensabata kokuti bamunyansikize ho. ");
INSERT INTO sbs_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesu chati kumukwame weyanza lizuminine, “Katuke mi uzime aha mukati kabantu.” ");
INSERT INTO sbs_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Linu chati kubantu, “Kana kushiyeme kuchita bulotu mwizuba lya Lensabata, kamba kuholofaza; kupulusa buhalo, kamba kwihaya?” Kono babatontwele. ");
INSERT INTO sbs_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ababaloli kubazimbuluka bonse chabukali, mi abaswabiswa bukukutu bwenkulo zabo, imi chati kumukwame, “Wolole iyanza lyako.” Chaliwolola, imi iyanza lyakwe chilya shiyamiswa. ");
INSERT INTO sbs_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Bafalisi habazwa hanze imi haho bulyo nibatanga kulelinsana ni maHeroda kamubati chiba mwihaila. ");
INSERT INTO sbs_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Linu Jesu, ni barutwana bakwe, babayendi kwiwate, imi chisi chikando chabantu niche chilila kuzwa Galileya ni kuzwa Judeya ");
INSERT INTO sbs_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ni kuzwa Jerusalema ni kuzwa Idumeya ni mwishilya lya Joludani ni kuzimbuluka Tire ni Sidoni. Habazuwa chazintu zabali kuchita, chisi chikando chibezi kwali. ");
INSERT INTO sbs_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Imi abakumbili barutwana bakwe kumubakanyiza chisepezana chebaka lyachisi, kokuti kanji bamuliimbi. ");
INSERT INTO sbs_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Mukuti abahozi baangi, kokuti zumwi ni zumwi yabena malwalila alikoze kwiza kwali kuti amukwate. ");
INSERT INTO sbs_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Munako yonse muzibali kumubonena inhuho zisajolwele, zibali kuwila hansi habusu bwakwe ni kulililila, ni ziti, “Umwana wa Ireeza.” ");
INSERT INTO sbs_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","“Chabusakusima nazikalimela kuti kanji zimwizibahazi. ");
INSERT INTO sbs_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Abayendi kwilundu, imi abasupi bana baabalikusuna, imi nibeza kwali. ");
INSERT INTO sbs_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Abaketi bena ikumi ni bobele, (baabasumpi barutwana), njokuti babenaye ni kuti pona chobatuma kutwala iñuwa yeñusa, ");
INSERT INTO sbs_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ni kuba ni maata akuhindika madimona. ");
INSERT INTO sbs_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Imi abaketi bena ikumi ni bobele: Simone, yabahi izina Pitorosi; ");
INSERT INTO sbs_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jakobo mwana wa Zebediya, ni Johani mwance wa Jakobo, yabahi izina Boanergese, liti, bana bakupalakata, ");
INSERT INTO sbs_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ni Anduru, Filipi, Batolomiyu, Mateu, Tomasi, Jakobo mwana wa Alfeya, Tediyusi, Simone Mukakani, ");
INSERT INTO sbs_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ni Judasi Isikaliyote, yetena mubeteke. ");
INSERT INTO sbs_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Linu nayenda kumunzi, imi chisi chibaboleli kwiza hamwina, kokuti kanji bawoli nanga kulya chinkwa. ");
INSERT INTO sbs_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Luhasi lwakwe haluzuwa zateni, babayendi ni kukamuhitiza, mukuti nibati, “Uzwile mumaano akwe” ");
INSERT INTO sbs_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","“Bañoli bamulao babakazwi kwa Jerusalema nibati, “Ukwetwe kwa Beluzebule,” imi, cha buyendisi bwa madimona u hindika madimona.” ");
INSERT INTO sbs_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesu ababasumpili kwali ni kucho kubali munguli, “Satani uwola bule kuhindika Satani? ");
INSERT INTO sbs_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Heba mubuso uli koswele kulisandukila iwowine, uwo mubuso kawuwoli kuzimana. ");
INSERT INTO sbs_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Heba inzuvo ili koswele kulisandukila iyoine, iyo inzubo kete niiwole kuzima. ");
INSERT INTO sbs_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Heba Satani uzimana ni kulisandukila iye mwine ni kuliyaba, kawoli kuzimana, kono wizite kumamaninizo. ");
INSERT INTO sbs_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kono kakwina yowola kwinjila munzubo ya mukwame yokolete ni kwiba zibya zakwe nasahambite mukwame yokolete tanzi, mi mwawole kututulula inzubo yakwe. ");
INSERT INTO sbs_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Chabusakusima nicho kwenu, zive zonse zabaana babantu kazikwatilwe, nanga zonse inyefulo zibawaamba, ");
INSERT INTO sbs_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","kono yense yonyefula Luhuho lu Jolola kete nawane kukwatilwa, kono wina mulandu wachive chakuyakuile.” ");
INSERT INTO sbs_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“Jesu abawambi chimukuti babali kucho, “Wina luhuho lusa Jolwele.” ");
INSERT INTO sbs_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Linu banyina ni banche nibeza kuzimana hanze. Chibamutumina, kumusupa. ");
INSERT INTO sbs_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Mi buungi bubekele bumuzimbulukite, niba cho kwali, “Banyoko ni banche bako bena hanze, mi bakabukulola.” ");
INSERT INTO sbs_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nabetaba, “Njibani bamayo ni bache bangu?” ");
INSERT INTO sbs_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nalola mu mamabbali kubabekele nibena muchikwenda nibamu zimbulukite ni kucho, “Mulole, aba nji bamayo ni banche bangu! ");
INSERT INTO sbs_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mukuti yense yochita chisakiwa kwa Ireeza, uzo muntu nji mwanchangu, ni nchizyangu, ni bamayo.” ");
INSERT INTO sbs_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Hape natanga kuruta kumbali yewate. Mi buungi bwachisi nibwakungana kumuzibuluka, linu nechila chikepe mwiwate, ni kwikala hansi. Chisi chonse chibena kumbali yewate hamutunda. ");
INSERT INTO sbs_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Mi chabaruta zintu zingi muunguli, mi nati kubali muntuto yakwe, ");
INSERT INTO sbs_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mutekeleze, mulimi abayendi kukubyala imbuto yakwe. ");
INSERT INTO sbs_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Choya bubyala, imwi imbuto niyawila munzila, imi zizuni nizeza kuitotola. ");
INSERT INTO sbs_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Imwi imbuto niyawila mwibu lyamabwe, muisena ibabi ni ibu lingi. Hohwaho bulyo chiya mena, mukuti kena ibena ibu liya hansi. ");
INSERT INTO sbs_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kono izuba haliñatula, chizahiswa, mi chebaka lyakuti kanazibena muhisi, ziba zumi. ");
INSERT INTO sbs_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Imwi imbuto niyawila muzisamu zamiiya. Zisamu zamiiya nizakula ni kuzipuputiza, mi kana zibabiki nanga buheke. ");
INSERT INTO sbs_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Imwi imbuto niyawila mwibu ilotu ni kubika buheke muzaabukula ni zabuekeza, mi zimwi nizaleta chakuminihanya makumi otatwe kubungi, imi zimwi makumi amana iyanza ni kumi, mi zimwi mwanda.” ");
INSERT INTO sbs_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Mi chati, “Yese wina matwi akuzuwa, mumusiye azuwe!” ");
INSERT INTO sbs_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jesus habena yeyena, babena hafuhi naye ni bena ikumi ni bobele babamubuzi kuamana ni nguli. ");
INSERT INTO sbs_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Chati kubali, “Kwenu kuhelwe ikunutu yomubuso wa Ireeza. Kono kubeena hanze zonse zina munguli, ");
INSERT INTO sbs_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kokuti habalola, ee balola, kono kababoni, ni kuti habazuwa, ee bazuwa, kono kabazuwisisi, kamba hamwi pona chibasanduka mi Ireeza pona chobakwatila.” ");
INSERT INTO sbs_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Mi chati kubali, “Kamuzuwisisi iyi inguli? Mumuzuwisise bule inguli zonse zimwi? ");
INSERT INTO sbs_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mulimi yobyala imbuto njeye yobyala iinzwi. ");
INSERT INTO sbs_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Bamwi njezina ziwila kumbali yamugwagwa, mulibabyalwa liinzwi. Mi habalizuwa, hahobulyo Satani ulizwisa mi uhinda liinzwi liba byalwa mubali. ");
INSERT INTO sbs_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Mi bamwi njabo babyalwa hebu lyamabwe, ili abo, habazuwa liinzwi, hahobulyo balitambula chakusaanga. ");
INSERT INTO sbs_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mi kabena muhisi mubali beene, kono balikozakoza chenakozana. Linu bukabo ni kunyandiswa kwiza chebaka lyaliizwi, hahobulyo bachunchula. ");
INSERT INTO sbs_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mi bamwi njabo babyalwa mukati kamiiya. Bazuwa liinzwi, ");
INSERT INTO sbs_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kono babilela ni zenkanda, kuchengwa chifumu, ni ntakazo zazintu zimwi zinjila mo ni kwihaya liinzwi, mi liba lisabiiki zibikantu. ");
INSERT INTO sbs_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Linu kwina abo bababyalwa mwibu ilotu. Bazuwa liinzwi ni kulitambula ni kubika zihantu: zimwi makumi otatwe, mi zimwi makumi amana iyanza ni kumi, mi zimwi mwanda”. ");
INSERT INTO sbs_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesu nati kubali, “Muleta ilambi munzubo ni kulibika mwikonde yechitanda, kamba mwikonde lyabulo? Mulileta mukati ni kulitula hachitulilo chelambi. ");
INSERT INTO sbs_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mukuti kakwina chiuungilwa chiseti ni chizibahazwe, mi kakwina inkunutu yiseti niibe henkanza. ");
INSERT INTO sbs_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Heba zumwi wina matwi akuzuwa, mumusiye azuwe!” ");
INSERT INTO sbs_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nati kubali, “Mutwalize kuchi muzuwa, intikanyezo imulikanisa, yete nimulikanyezwe chayo, mi muiwelwe kwenu. ");
INSERT INTO sbs_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mukuti yense wina, kwali kakuwelwa ni kuhita, mi yense yasena, kwali mukuhindililwe ni zakwete.” ");
INSERT INTO sbs_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","27","Mi nichati, “Mubuso wa Ireeza uswana sina muntu yobyala imbuto hansi. Ulala masiku ni kubuka musihali, mi imbuto imena ni kukula, nanga kezibite kuti mbobule. ");
INSERT INTO sbs_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ibu libika buheke ilyo liine: intanzi ituunga, linu chikunku, linu kwiza buheke bubuzwile kuchikunku. ");
INSERT INTO sbs_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mi buheke habubuzwa hahobulyo utumina ijekisi hanze, mukuti inkutulo chiyasika”. ");
INSERT INTO sbs_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Mi nati, “Mubuso wa Ireeza tuwola kuubambanya ni chi, kamba inguli inzi ituwola tendisa kukuutoloka? ");
INSERT INTO sbs_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ukola sina imbuto yamasitate iti, chiibyalitwe, nji iha nikuhita imbuto yahebu. ");
INSERT INTO sbs_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mihe, chiibyalitwe, ikula ni kuba bukando kuzamba zonse zimenantu zoluwa, mi itenda mitavi mikando, kokuti zizuni zewulu ziwola kuchita zizumbo mumuzunde wayo.” ");
INSERT INTO sbs_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Chenguli zingi ziswana nezi nawamba liinzwi kubali, chabuungi kakuya kamubawolela kuzuwisisa, ");
INSERT INTO sbs_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","imi kanaabawambi kubali nikusena inguli. Kono habali yeyena, abatoloki zintu zonse kubarutwana bakwe. ");
INSERT INTO sbs_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mwelyo izuba, hakuba chitengu, nati kubali, “Tulutile mulimwi ishilya.” ");
INSERT INTO sbs_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Linu nibasiya chisi, kuhinda ni Jesu, kakuti chabena kale muchikepe. Zimwi zikepe nazo zibena naye. ");
INSERT INTO sbs_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mi ihuho likalihite ikando chilyabuka mi masuunda abali kwi njila muchikepe mukuti chikepe chichibezwile. ");
INSERT INTO sbs_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Kono Jesu iyemwine abeena muluheho lwachikepe, nalele hamushamo. Chibamubusa, nibacho, “Muruti, kobileli nihatusaka kufwa?” ");
INSERT INTO sbs_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Mi, haabuuswa, na kalimela luhuho ni kucho kwiwate, “Inkozo, tukumane.” Mi ihuho nilya zimana, mi kubena kutontola kukando. ");
INSERT INTO sbs_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Mi nati kubali, “Chinzi hamutiite? Kamwini kuba ni intumelo?” ");
INSERT INTO sbs_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Babezuli kutiya kukando mi ni bawamba zumwi ku zumwi, “Linu njeni uzu, mukuti nanga ihuho ni wate zimuzuwa?” ");
INSERT INTO sbs_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Babezi kwishilya limwi lyewate, kuchilalo cha Gerasenese. ");
INSERT INTO sbs_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Mi hahobulyo Jesu hazuka muchikepe, mukwame wina luhuho lusajololi abezi kwali kukazwa kumakumbu. ");
INSERT INTO sbs_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mukwame abali kuhala mumakumbu. Kakwina ni uumwina yabakuti chowola kumukanisa, mane nangati ni ncheini. ");
INSERT INTO sbs_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Chaba suminwe inako ingi ingi ni nkwele ni ncheini. Abali kupusoola hakati incheini ni nkwele zakwe zibapusoolwa. Kakwina ni umwina yabena ziho zokumu zuunda. ");
INSERT INTO sbs_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Masiku ni masiku ni musihali mumakumbu ni mumalundu, abali kubokolola ni kulifundola chamabwe makali. ");
INSERT INTO sbs_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Habona Jesu kulezana, natilila kwali ni kukafukama habusu bwakwe. ");
INSERT INTO sbs_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Chabokolola chamuhuwo mukando, “Chinzi chiniswanela kuchita nawe, Jesu, Mwana wa Ireeza waKwiwulu? Nikukumbila cha Ireeza iye mwine, kanji unisukululi.” ");
INSERT INTO sbs_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Mukuti abali kuwamba kwali, “Zwe mumukwame, iwe luhuho lusajololi.” ");
INSERT INTO sbs_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Mi namubuza, “Nguweni izina lyako?” Mi namwitaba, “Izina lyangu nji Mpi, mukuti tubangi.” ");
INSERT INTO sbs_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Namukumbila chakubolelabolela kusaatumina kunze ye chilalo. ");
INSERT INTO sbs_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Haho mulaka mukando wezigulube ubena ho ni ufula hachiwulu, ");
INSERT INTO sbs_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","mi niyamukumbila, niiti, “Tutumine muzingulube; twinjile muzili.” ");
INSERT INTO sbs_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Chobulyo chazizuminina; inhuho zisajolwele nizazwa ni kwinjila muzingulube, ni zashetumuka chakuhwelela hansi yachiwulu mwiwate, mi zibali kusaka kulikana impalo ya zikiti zobele ziguluve zibamini mwiwate. ");
INSERT INTO sbs_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Mi abo babali kulisika zingulube nibatiya ni kukabiha chibatendahali mumuleneñi ni kumbali yenkanda. Imi bantu bangi nibayenda hanze kukabona zibachitahali. ");
INSERT INTO sbs_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Linu nibeza kwa Jesu mi nibaabona mukwame yowina madimona—yabena iMpi—nekele hansi, nazwete, imi mumaano sakata akwe, mi babalikalilwe. ");
INSERT INTO sbs_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bana bababoni chibachitahali kumukwame yokwetwe madimona nibaba wambila chiba chitahali kwali mane ni kuamana ni zingulube. ");
INSERT INTO sbs_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Mi chibatanga kumukumbila kusiya chilalo chabo. ");
INSERT INTO sbs_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mi habali kwinjila mukepe, mukwame wamadimona na mukumbila kuti ayende naye. ");
INSERT INTO sbs_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kono kana aba muzuminini, kono nacho kwali, “Yende kunzubo yanko ni kubantu bako, nikukaba wambila Ireeza chaba kupangili, ni chisemonzi chaba kuhi.” ");
INSERT INTO sbs_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Linu nayenda ni kukatanga kwi zibahaza zintu zikando Jesu zabamuchitili mwa Dekapolisi, mi bonse baba makali. ");
INSERT INTO sbs_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Mi Jesu hachalutila mwishilwa hape kuimwimbali yewate, muchisepe, chisi chikando nichakungana kumuzimbuluka, mukuti abena kumbali lyewate. ");
INSERT INTO sbs_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mi zumwi kubayendisi besinangonge, wezina lya Jailusi, nakeza, mi hamubona, nawila hamantende akwe. ");
INSERT INTO sbs_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Namukumbila chakubolela bolela, nati, “Mwanangu munini wamukazana chiwina hafuhi ni lufu. Nikukumbila, wize ubike mayanza ako hali kuti apangwe siinte ni kuhala.” ");
INSERT INTO sbs_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Linu nayenda naye, ni chisi chikando nichamwichilila ni kumukakatiize kumuzimbuluka. ");
INSERT INTO sbs_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Lyahanu kubena mwanakazi wamalaha abazwizi zilimo zina ikumi ni zobele. ");
INSERT INTO sbs_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Abasukuluki chabukando mumpabalelo yeñanga zingi mi abalitusisi zonse zabakwete, kono kunde yakuba butuka naya kunsi. ");
INSERT INTO sbs_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Chabazuwile indaba kuamana ni Jesu. Linu nakeza mumasule akwe habali kwabuyenda muchisi, ni chakwata chizabalo chakwe. ");
INSERT INTO sbs_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Chobulyo nati, “Heba ninikwata bulyo zizwato zakwe, munihozwe.” ");
INSERT INTO sbs_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Hachamuwonda, kuzwiza ni kwazimana, mi nalizuwa mumubili wakwe kuti chahozwa kumalwalila akwe. ");
INSERT INTO sbs_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Mi hahobulyo Jesu nalemuha mwalimwine kuti ziho chizazwa kwali. Mi nasandukila mubuungi bwa chisi ni kubuza, “Njeni wawonda zizwato zangu?” ");
INSERT INTO sbs_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Barutwana bakwe chibacho kwali, “Ubwene ichi chisi chikukakatize kukuzimbuluka, mi uwamba, “Njeni waniwonda?” ");
INSERT INTO sbs_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kono Jesu nalolalola kubona yabapangi bulyo. ");
INSERT INTO sbs_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mwanakazi, chokwiziba chiba pangahali kwali, nalikalilwa niku chachalika. Abakezi ni kuwila habusu bwakwe ni kumuwambila buhote bonse. ");
INSERT INTO sbs_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nawamba kwali, “Mwanangu wechikazana, intumelo yako yakushiyamisa, Yende chenkozo mi uholele kuchilwalo chako.” ");
INSERT INTO sbs_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Habali kusiwamba, bamwi bantu nibeza kuzwa kumuyendisi we sinangonge, nibacho, “Mwanako wechikazana chafwa. Chinzi kuzwila habusu kukataza muruti?” ");
INSERT INTO sbs_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mi linu Jesu chakuzuwa zibaba wambi, nati kumuyendisi we sinagoge, “Kanji utiyi. Zumine bulyo.” ");
INSERT INTO sbs_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kana abazuminini nanga zuhi kumusindikiza, kunde aPitorosi, Jakobo, ni Johani, mwanche wa Jakobo. ");
INSERT INTO sbs_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Babakezi kunzuvo yomuyendisi we sinagoge mi nabona ko bantuvangi nibachita ilata lingi lingi; babali kusilisa ni kubokolola chakutumusa. ");
INSERT INTO sbs_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Henjila munzubo, nati kubali, “Chinzi hamunyeletwe imi chinzi hamusilisa? Muhwile kafwile kono ulele,” ");
INSERT INTO sbs_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nibamuseka. Kono nabazwisikiza hanze bonse niku hinda besi wamuhwile ni banyina ni babena naye, mi nenjila mwabena muhwile. ");
INSERT INTO sbs_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nichahinda iyanza lyamuhwile ni kuti kwali, “Talita koum,” ili ita kuti, “Muhwile wamukazana, niti kwako, zime.” ");
INSERT INTO sbs_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Hahobulyo muhwile chazima ni kuyenda (kakuti abena zilimo zina ikumi ni zobele kuchipepo). Mibabamakali ni kuhita. ");
INSERT INTO sbs_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Chenkalimelo nabalaela kuti kakwina nanga umwina yoswanela kwiziba kuamana ni chatendahala. Mi naba wambila kumuha chakulya. ");
INSERT INTO sbs_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Imi nayenda kuzwa mwateni ni kwiza mwitoropo mumuzi wakwe, ni varutwana vakwe vavamwichilili. ");
INSERT INTO sbs_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Imi Mukivero hausika, avaruti mu maSinagoge. Vuungi vwa vaantu vuva muzuwi nivaziyeleha. Nivati, “Aba wani kuhi izi intuto?” “Maanonzi aa avahewa kwali?” “Imakazonzi izi zatenda chamayanza akwe”? ");
INSERT INTO sbs_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","“ Kanji muvezi, mwana Maria ni mukulwe wa Jakovo ni Jose ni Juda ni Simoni? Vanchizye kavahena hanu naswe”? Mi vavaziyezwe chaJesu. ");
INSERT INTO sbs_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Mi Jesu chati kuvali, “Muporofita kayelele kuvuzwa ikute, mbwiteli mwitoropo mwazwa ni muvakwakwe, ni vamunzubo yakwe.” ");
INSERT INTO sbs_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ava kangwa kutenda mutendo ikolete, mbwiteli kuvika mayanza akwe havantu vache valwele ni kuvahoza. ");
INSERT INTO sbs_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kusazumina kwavo kuva mukomokisi. Nicha yenda vuzimbuluka muminzi nakavuruta. ");
INSERT INTO sbs_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ni chasumpa vena ikumi limwiina nivovere ni kutanga kuvatuma kunze, vovere cha vovere, nikuvaha ziho he inhuho zisaJololi, ");
INSERT INTO sbs_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ni kuba laera kuti kakwina chiva hinda mulwendo lwavo, mbwiteri inkoli vulyo: kakwina inkoko, kakwina mukotana, imi kakwina mali mulutunga lwavo, ");
INSERT INTO sbs_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","kono kuzwata insangu, nikusa livwika inguvo zovere. ");
INSERT INTO sbs_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ni chati kuvali, “Monse mumwinjirira mwinzuvo, mwikale mo mbwita hete nimusiire icho chivaka. ");
INSERT INTO sbs_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Imi itoropo isete imitambule kamba kusamiteeka, hamusiya icho chivaka, muzukutule isuko kumatende enu ivevupaki kuvali.” ");
INSERT INTO sbs_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Vavayendi ni vaya vuruta kuti vaantu vafutatile zivi zavo. ");
INSERT INTO sbs_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Niva zwisa madimona maangi, ni kusinga vantu vangi valwala ioli ni kuvahoza. ");
INSERT INTO sbs_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Heroda hazuwa izi, kakuti izina lya Jesu livavuvaani. Vamwi vavali kucho, “Johani Mukolovezi ava kavuswa kuvafwile imi chovuti, izi ziho zina imakazo zitendete mwali.” ");
INSERT INTO sbs_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Vamwi ni vaati, “Nji Eliya”. Kono vamwi nivati, “Muporofita, uvu nji vumwi wavaporofita vamwi nako zentanzi.” ");
INSERT INTO sbs_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kono linu Heroda hazuwa ichi nacho, “Johani, uni vakosoli mutwi avavuuswa.” ");
INSERT INTO sbs_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Mukuti Heroda avatumini kusuminwa kwa Johani niku muhakila muntolongo kaha mulandu wa Herodiasi (mwi hyabwe wa mwanchakwe Filipi), kakuti chava musesete. ");
INSERT INTO sbs_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Mukuti Johani avawambiri Heroda, “Kakuyelele kwako kuva ni mwihyabwe wa mwancako.” ");
INSERT INTO sbs_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","“Kono Herodiyasi nakwatilila havuvengi kumulwisanisa, ni kusaka kumwihaya, kono kana avawoli, ");
INSERT INTO sbs_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Mukuti Heroda avatite Johani; avezi kuti ushiyeme imi mukwame yojolola, na muvika neenza. Muku tekeleza kwali nikwamuha kunyelwa kukando, imi namuzuwisisa chakusanga. ");
INSERT INTO sbs_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Linu nikwasika mukwa Heroda hava ni luzuva lwakuzalwa kakwe ni chatenda mulalilo ni manduna vakwe, ni vayendisi venkondo, nivakulwana vamwa Galileya. ");
INSERT INTO sbs_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mwana a Herodiasi wa mukazana iyemwine neza ni kuvazanina, nicha sangisa Heroda niva vayenzi vakwe vavasumpwa. Simwine naati kumukazana, “Nikumbiire chimwi nichimwi chosaka imi municikuhe.” ");
INSERT INTO sbs_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Chakoonka kwali naati, “Chonse chete ukumbire kwangu, munichi kuhe, ku sika hakati kepuso yangu.” ");
INSERT INTO sbs_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Naya hanze nichakati kuvanyina, “Chinzi chete nimukumbiire?” Nacho, “Mutwi wa Johani Mukolovezi,” ");
INSERT INTO sbs_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Hohwaho nenjila chokuhwela kwa simwine ni kukumbiira, naati, “Nisaka kuti unihe hahanu, hakagwetere, mutwi wa Johani Mukolovezi”. ");
INSERT INTO sbs_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nihakuva kuti ichi chiva sasamisi simwine, kana avali kuwola kumukanina chava kumbiiri kevaka lya kulikonka kwava tendi nicha veene vakwe. ");
INSERT INTO sbs_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Imi simwine cha tuma isole yozwa kuvaganteri ni kumulaera kumuletela mutwi wa Johani. Muganteri nayenda kuka mu kosola mutwi muntolongo. ");
INSERT INTO sbs_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Naaleta mutwi wakwe hakagwetere niku uha mukazana, mi mukazana chauha vanyina. ");
INSERT INTO sbs_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mi varutwana vakwe, chokuzuwa ichi, chivakeza nikuhinda muviri ni kuka u uunga mwikuumbu. ");
INSERT INTO sbs_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mi vapositola, chivakungana kuzimbuluka Jesu, ku muwambira zonse zivava kapangi ni kuruta. ");
INSERT INTO sbs_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ni chata kuvali, “Mwize muzwe muvene muye muchivaka chisena vaantu ni kukapumula inakozana.” Mukuti vuungi vuvakwiza ni kuyenda, imi kena vavawani nanga inako yokulya. ");
INSERT INTO sbs_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Imi nivayenda muchikepe muchivaka chisena vaantu avoveene. ");
INSERT INTO sbs_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kono vava vavoni havakatuka mi vuungi ni bwaveziva, nivatilila kwateni hamwiina chamatende kuzwa mwitoropo yonse, ni kukasika lwentanzi kwavo. ");
INSERT INTO sbs_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Havasika herizo, chavona chinavuungi imi chava niinse havali kakuti vavali kukola sina imberere zisena mulisi. Nichatanga kuvaruta zintu zingi. ");
INSERT INTO sbs_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Chitengwaana, varutwana vakwe niveza kwali nikucho, “Ichi chivaka kachina vaantu nikuti cheli chitengu. ");
INSERT INTO sbs_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Uvatumine valiyendeze munkanda zina havubbali ni muminzi kuka liulila zakulya avoveene.” ");
INSERT INTO sbs_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kono netava ni kucho kuvali, “Inwe muvahe zakulya.” Chiva cho kwali, “Tuwola kukawula inkoko ya mali a mianda yovere nikwiza kuvaha valye?” ");
INSERT INTO sbs_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nacho kuvali, “Zongai ziinkwa zimukwete? Muyende mukavone.” Hava sakisisa, nivaati, “Ziinkwa zimana iyanza ninswi zovere.” ");
INSERT INTO sbs_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Chalaera vaantu vonse kwikala hansi halyani iteke. ");
INSERT INTO sbs_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Niveekala muzikwata; zikwata za myandanda ni makumi ahinda iyanza. ");
INSERT INTO sbs_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Chahinda ziikwa zimana iyanza ni nswi zovere, nalolele kwiwulu nafuyola niku gamoona ziinkwa nikuziha ku varutwana kuka zininzika havusu vwavaantu. Nicha yavelela inswi zovere mukati kavo voonse. ");
INSERT INTO sbs_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Voonse vavaali mbwita havekuta. ");
INSERT INTO sbs_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Chivahinda vufwafwaali bwa ziinkwa, nikwizuza ziseye zikwana ikumi nizovere, ni vufwafwali bwenswi. ");
INSERT INTO sbs_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mi vavali vaantu vatenda lule luhinde yanza vavaali ziinkwa. ");
INSERT INTO sbs_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Hohwaho nachita kuti varutwana vakwe vechile muchikepe vahitile havusu vwake kuya kuimwi imbali, kwa Bethesaida, naatumina chinavuungi kuyenda. ");
INSERT INTO sbs_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Chinga vayenda, nayenda herundu kuku lapera. ");
INSERT INTO sbs_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Masiku nieza, imi chikepe chichivena hakati kewate, imi aveena yenke hamutunda. ");
INSERT INTO sbs_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Imi navona kuti vavakwina muvukukutu vukando havati chivaka zuhila kwina luhuho luva kuvalwisa. Munako ya vuune yakuiza neza kuvali, nakavuyenda hewate, imi asake nava hite silubbali. ");
INSERT INTO sbs_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kono haba muvona ukavuyenda hewulu lyewate, niva zeza kuti isaku niva huwa, mane chiva tanga ku huwa, ");
INSERT INTO sbs_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","kakuti vavamuboni mi vavasuhite. Imi hohyaho chawamba kuvali nikuvata kuti, “Mulikoze! Jeme! Kanji mutiyi!” ");
INSERT INTO sbs_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nenjila muchikepe navo, imi luhuho chilwa siya kuhunga. Imi nivakomokwa. ");
INSERT INTO sbs_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Mukuti kena vavazuwisisi kuti chiinkwa chitalusa nzi. Imi, inkulo zavo nizakukutuhazwa. ");
INSERT INTO sbs_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Hachiva luutila mwishilya, chiva sika muchivaka Genesereti ni vasiika chikepe. ");
INSERT INTO sbs_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Hava zuvuka muchikepe, hahobulyo niva mulemuha. ");
INSERT INTO sbs_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Nichiva tirira muchikiliti chonse nikutanga kukaleta valwele kwali hamasasa, konse kuvava kuzuwa kuti kwakezite. ");
INSERT INTO sbs_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Konse mwavali kwinjira muminzi, kamba mileneñi, kamba munkanda, vava kuvikanga valwele muzibaka zamauzikizo, imi vavali kumu kumbira kuti avazuminine nanga kuwonda kumpera yachizwato chakwe. Imi vuungi vwavo vava kumu kwata vavahozwa. ");
INSERT INTO sbs_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Vafalisi ni vamwi vavañoli vavali kukazwila kwa Jerusalema nivakuungana kumuzimbuluka. ");
INSERT INTO sbs_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Mi vavavoni kuti vamwi vavarutiwa vavali zilyo ni mayanza enekwe, awo, asasambite. ");
INSERT INTO sbs_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Mukuti vafalisi ni vonse maJuda kavali mbwita havasamba kumayanza avo; mukuti vechilile chizo chavakulwana. ");
INSERT INTO sbs_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Cwale vafalisi havakazwa kuchivaka chamusika, kavali mbwita havasamba. Imi kwina milao mingi ivechilila chentokomelo, kukopanya ni kusambisa inkomoki, impoto, ni kahambwe ke nsipi i venya, mi mane nanga ni zikalo zivaliila.) ");
INSERT INTO sbs_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Mafalisi ni vañoli ni vavuuza Jesu, “Chinzi varutiwa vako havasayi ka chizo cha Vakulwana, mukuti vavaali zilyo ni mayanza asasambite?” ");
INSERT INTO sbs_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Kono nati kuvali, “Isaya avaporofiti neenza kuamana nanwe valihele, ava ñoli, 'Ava vantu bani kuteka chamiromo yavo, kono inkulo zavo zinakule naame. ");
INSERT INTO sbs_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kuteemba kusena intuso kuvaniha, kuruta milao yavantu kuva intuto yavo.' ");
INSERT INTO sbs_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Musiya intaero zaIreeza muya chamikwa ya chizo chavantu.” ");
INSERT INTO sbs_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Mi a va co kuvali, “Mwizi neenza kukana intaero yaIreza kuti mukuteke chizo chenu! ");
INSERT INTO sbs_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mi Mushe nati, 'Ukuteke iso ni nyoko', ni, 'Iye yowamba vuvi kuvesi kamba vanyina luli kafwe.' ");
INSERT INTO sbs_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kono inwe muti, 'Heba muntu uwambila vesi ni vanyina, “Cinzi ni chinzi intuso zimuvavatambuli kwangu Inkoombani,” (nji kuta kuti, 'Kuva hewa Ireeza')- ");
INSERT INTO sbs_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","linu kosiwoli kumuzuminina kutenda chimwi kuvesi ni vanyina. ");
INSERT INTO sbs_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mu kwete ku panga mulao wa Ireeza kuvula intuso chachizo chenu chimu vatambiki hansi. Ni zingi zintu ziswana zimucita.” ");
INSERT INTO sbs_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Cha sumpa chinavuungi hape ni kuwamba kuvali, “Muteke kwangu, muvonse, ni kuzuwisisa. ");
INSERT INTO sbs_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kakwina chizwa hanze yomuntu icho cimusihisa hachinjila mwali. Nji chizwa hanze yomuntu icho chimusihisa.” ");
INSERT INTO sbs_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(Wina matwi aku zuwa a zuwe). ");
INSERT INTO sbs_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Haho Jesu hasiya chinavuungi ni kwinjila munzubo, varutwana vakwe chivamuvuza kuamana ninguli. ");
INSERT INTO sbs_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesu nati, “Nenwe lyaho kamuzuwisisi? Kamuvoni kuti chonse chinjila kumuntu kuzwa hanze kachiwoli kumusihisa, ");
INSERT INTO sbs_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","kakuti kachiwoli kwinjila munkulo, kono chiya mwivumo ni kukachizwisikiza mukalimba-limba?” Chowu muwambiro Jesu avapangi zilyo zonse chokujolola. ");
INSERT INTO sbs_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Chati, “Nji chizwa hanse yomuntu njichimusilafaza. Kakuli chizwa kumuntu, ");
INSERT INTO sbs_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","kuzwa mu nkulo, kuzwa mumihupulo mivi, vusaangu, vusa, kwihaya, ");
INSERT INTO sbs_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","vushyahi, kunuungwa, lunya, muna, mapa, kuchengelela, vuikuhumuso, vuholo, ");
INSERT INTO sbs_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","zonse izi zivilala zizwilila mukati, mi nji zisihisa muuntu.” ");
INSERT INTO sbs_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Chavuuka kuzwa aho ni kuyenda ku chikiliti chaTire ni Sidoni. Cheza munzubo mi kanavali kusaka kuti muntu zumwi ezive kuti kwa veena, kono kana avali kuwoleka ku patwa. ");
INSERT INTO sbs_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kono hohwaho mukulwakazi, inyina wa mwana kazana yavena luhuho lusajololi, chazuwa kuamana naye, cheza, ni kuwila hansi hamatende akwe. ");
INSERT INTO sbs_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Cwale mwanakazi avali Mugerike, waluzuvo lwa Zirofenia. Namukumbila kuhindika idimona ku mwana'kwe wa mukazana. ");
INSERT INTO sbs_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nati kwali, “Musiye bahwile pili baleliwe. Sina hakusashiyeme kuhinda zilyo zabahwile nikuzi sohela vambwa.” ");
INSERT INTO sbs_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Kono cha mwitava nikuta kwali, “Eee, Simwine, nanga vambwa mwi konde lye ntafule valya tufwafwali twavahwile.” ");
INSERT INTO sbs_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nati kwali, “Kakuli wawamba buti, ulukuluhite kuyenda. Idimona chilyaazwa kumwanako”. ");
INSERT INTO sbs_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Chabola ku nzubo yakwe ni kukawana muhwile ulele hamumbeta, mi idimona livayendi. ");
INSERT INTO sbs_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Cwale chayenda hape kuzwa muchikiliti chaTire, nikuyenda cha Sidoni kuya kwiwate lyaGalileya konji kuchililiti cha Dekapolisi. ");
INSERT INTO sbs_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ni chivaleta kwali zumwi yavafwile matwi ni bukavo kukuwamba, ni va mukumbila kubika iyanzahali. ");
INSERT INTO sbs_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Chamuhindila kumbali kuzwa munavuungi cha kuliuungula, mi chavika minwe yakwe mumatwi akwe, mi hamana kuswa, nakwata lulimi lwakwe. ");
INSERT INTO sbs_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Avaloli kwiwulu, hatuliza muhuza nikucho kwali, “Efafata” njikuti, “Yaluke!” ");
INSERT INTO sbs_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mi haho kuzuwa kwakwe chikwe yaluka, mi chiva kwete lulimi lwakwe chiva shiywa mi chava kuwamba sinte. ");
INSERT INTO sbs_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Mi avava laeli kuti kanji vawambili muntu. Kono mwavali kuva laelelela, muvavali kuliwambila mane ni kuhita. ");
INSERT INTO sbs_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Vava komokiswa ahulu, ni vati, “Ava pangi zintu zonse siinte. Uwola nanga vasinkite matwi kuti vazuwe ni zimumu ku wamba.” ");
INSERT INTO sbs_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mwaana mazuva, kuvali kwina hape chinavuungi chikando, mi kena vavena chimwi chokulya. Jesu cha sumpa varutwana vakwe ni kucho kuvali, ");
INSERT INTO sbs_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nina inse ku cinavuungi, kakuli vazwilile havusu kuva name cha mazuva o tatwe mi nivasena chivalya. ");
INSERT INTO sbs_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Heva ni nivatumina kuya kumunzi wavo nivasalile vawola kuzuminina munzira. Imi vamwi kuvali vakazwa mulyendo lule.” ");
INSERT INTO sbs_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Varutwana vakwe chiva mwitava, “Chokuhi kwete tuwane ziinkwa zilikeene mwechi chivaka chisena vaantu kutiveekute?” ");
INSERT INTO sbs_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Cha vavuza, “Zongayi ziinkwa zimukwete?” Nichivati, “Iyanza ni tovere.” ");
INSERT INTO sbs_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Cha layera chinavuungi kwi kala hansi. Cha hinda zinkwa zimana iyanza nizovere, chali tumera, ni kuzi gamoona. Naziha kuvarutwana vakwe kuvika havusu bwavo, mi chivazikaa havusu vwa chinavuungi. ");
INSERT INTO sbs_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mukuti navo vaavena inswi zilikene, imi hamana kuha buitumelo chavo, na laela varutwana kuziyava nazo. ");
INSERT INTO sbs_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nivalya nikwikuta. Imi nivatotola vufwafwali vuvashele, ziseye zikando zimana iyaza nizo vere. ");
INSERT INTO sbs_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Vantu vavakusaka kulikana lule lone. Ni chava tumina kuyenda. ");
INSERT INTO sbs_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Hohwaho chechila muchikepe ni varutwana vakwe, niva yenda muchikiliti cha Dalumanuta. ");
INSERT INTO sbs_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","varisi niveza kuzwa nikutanga kukanana naye. Niva muvuza chisupo chizwila kwiwulu kumulika. ");
INSERT INTO sbs_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Natuliza muhuza muluhuho nikucho, “Chizi ulu lusika lwahanu halukumbila chisupo? Chabu niti kwenu, kakwina chisupo chete nichihewe kolu lusika.” ");
INSERT INTO sbs_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Linu chava siya, nechila muchikepe niku yenda kuyimwi imbali. ");
INSERT INTO sbs_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Lyahanu varutwana nivazivala kulihindila zilyo. Kena vavena nanga chikwa chihitilila chimwina muchikepe. ");
INSERT INTO sbs_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Navakalimela nati, mulole imi mugantele, “mulungo wa Mafarisi ni mulungo wa Heroda.” ");
INSERT INTO sbs_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Varutwana nichi vavuzana, “Kakuti katwina Chiinkwa.” ");
INSERT INTO sbs_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesu avakwizi zechi, ni chacho kuvali, “Chinzi hamuvuzana kazakusava ni chiinkwa? Kana nahanu kamu zuwi? Kamu zuwisisa? Inkulo zenu za sanduka kusa tekeleza? ");
INSERT INTO sbs_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mwina menso, kamuvoni? Mwina matwi, kamuzuwi? Kamuzezi? ");
INSERT INTO sbs_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Hani gamoona ziinkwa zimana iyanza mukati kavaantu vena lule vuhinda iyanza, zi seye zongayi zivezuli vufwalifwali vwa Chiikwa zimu vahindi?” Chivati kwali, “Ikumi lyonke nizovere.” ");
INSERT INTO sbs_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Imi hani gamoona ziinkwa zi hinda iyanza nizovere, mukati kavaantu vena lule luhinda minwe yoone, zitanda zongayi zivezuli zimuva hindi?” Chivacho kwali, “Zihinda iyanza nizovere.” ");
INSERT INTO sbs_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Chati, “Nahanu kamu zuwisisi?” ");
INSERT INTO sbs_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Niveza kwa Betisaida. Vaantu uko chiva leta kwali mukwame yasavoni ni kukumbira Jesu kuti a muwoonde. ");
INSERT INTO sbs_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesu chawoonda mukwame yasavoni kwi yanza, ni kumutwala kunze yo munzi. Hachaswira ha menso akwe ni kuvika mayanza akwe hali, Chamu vuza, “Kwina cho vona?” ");
INSERT INTO sbs_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nichalola mwiwulu, ni kucho, “Ni vweene vantu vayenda ili zisamu.” ");
INSERT INTO sbs_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Linu cha muvika hape mayanza akwe hamenso akwe, imi mukwame che yalula menso akwe, chavozekezwa kuvona kwakwe, ni chavona zintu zonse neenza. ");
INSERT INTO sbs_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesu cha mutumina kunzuvo yakwe ni kucho, “Kanji winjili mwitoropo.” ");
INSERT INTO sbs_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesu a vayendi ni varutwana vakwe muminzi ya Sizaria Filipi. Munzira cha vuza varutwana vakwe, “Vaantu vata kunti njeme ni?” ");
INSERT INTO sbs_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Chiva mwitava ni kucho, “Johani Mukolovezi. Vamwi vacho, 'Eliya' imi vamwi, 'Zumwi wa kuvaporofita.'” ");
INSERT INTO sbs_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Chava vuza, “Inwe mucho kuti njeme ni?” Pitorosi chati kwali, “Njewe Keresite.” ");
INSERT INTO sbs_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesu chavakalimera kusa wambila nanga umwiina kakwe. ");
INSERT INTO sbs_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Imi chatanga kuvaruta kuti Mwana wa Muntu uyelele kusukuluka zintu zingi, imi mwa kanwa kuvakulwana ni vapurisita vakulwana ni vañoli, imi kehayiwe, imi hakumana mazuva otatwe kavuuke. ");
INSERT INTO sbs_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nawamba ichi chokujoloza. Linu Pitolosi na muhindira ku bali ni kukatanga kumukalimera. ");
INSERT INTO sbs_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kono Jesu nachevuka ni kulolelela kuvarutwana vakwe ni ku kalimera Pitorosi ni kucho, “Voole mwisule lyangu, Satani! Kovileli ni zintu za Ireeza, kono chanzintu zavaantu.” ");
INSERT INTO sbs_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Linu cha sumpa chinavuuungi ni varutwana vakwe hamwina, ni kucho kuvali, “heva zumwi usaka kunichilira, u swanera kulikana iye mwine, anyemune chifapano chakwe, ni kunichilira. ");
INSERT INTO sbs_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kakuti yense yosaka kuhaza vuhalo vwakwe ka vusinyeherwe, imi yense yo sinyeherwa vuhalo vwakwe chevaka lyangu ni lya Ivangeli, mwa vuhaze. ");
INSERT INTO sbs_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Chinzi chawana muntu, ku waana inkanda yonse, ni kusinyeherwa vuhalo bwakwe? ");
INSERT INTO sbs_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Chinzi muntu chawola kuha mu kuchinchana ni vuhalo vwakwe? ");
INSERT INTO sbs_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yense yoni swavera ni maanzwi angu munu muchivi cha lusika, Mwaana o Muntu ka muswavere hakeza munkaanya Ivesi hamwina ni mailoi a jolola.” ");
INSERT INTO sbs_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Imi nacho kuvali; “chavusakusima ni milwirite, kwina vamwi kwenu inwe zimene hanu va sete nivasoole lufu ni vaseni kuvona muvuso wa Ireeza ciukeza ni ziho.” ");
INSERT INTO sbs_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Imi mazuva ahinde iyaza nikamwiina hahita, Jesu nahinda Pitolosi, ni Jakobo ni Johani nakaya nabo hewulu lye ruundu, bonke bo bulyo. Linu cha chincha mazimo havusu bwabo. ");
INSERT INTO sbs_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Zizwato zakwe chiza taanga ku venya, kutuva kuhitiliza, kutuva kuhita zituviso zonze hansi muzi wola kutuvila. ");
INSERT INTO sbs_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Linu Eliya ni Mushe chiveza kuboneka kuvali, imi vava kuwamba ni Jesu. ");
INSERT INTO sbs_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pitorosi chetava nikucho kwa Jesu, “Muruti, kwina neenza hatwina hanu, cwale niha kwina bulyo tuzaake zitoomba zotatwe, chimwiina chako, chimwiina cha Mushe ni chimwiina cha Eliya.” ");
INSERT INTO sbs_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Mukuti kena avezi choku wamba, mi chivavatiite.) ");
INSERT INTO sbs_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ikope nilyeza ni kuva wumba. Linu liinzwi chilya zwa mwi kope, “Unzu mwanangu wa Muswisu uni suni, muteeke kwaali. ");
INSERT INTO sbs_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Haho bulyo, havazoolola, kena vavakusi bwene zumwi yavena navo kwanda Jesu. ");
INSERT INTO sbs_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mukuka vusuuka iruundu, nichava laela kusa wambila muntu kazi vavona, hesi Mwana Muntu cha vuswa kuvafu. ");
INSERT INTO sbs_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Chiva ili bikira indaba mukati kavo, imi nivawambolisana mukati kavo cha “Ku vuuka kuvavuwile” chi iwola kutoloka. ");
INSERT INTO sbs_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Chiva muvuuza “Chizi vañoli hava chokuti Eliya uswanela kwiza lwentanzi?” ");
INSERT INTO sbs_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Chacho kuvali, Eliya initi ukeza lwentaanzi kukuvoza zintu sonnse neenza. “Linu chinzi haku ñoletwe kuti Mwana Muuntu mwa sukuluke muzintu zingi nikuhindwa uvu kena chimwi? ");
INSERT INTO sbs_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kono nimilwira kuti Eliya chavakezi, mi vavapangi zonse zivava kusaka kwali, sina mañoli mu awamila ku amana naye.” ");
INSERT INTO sbs_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Imi havakabola kuvarutwana, ni vona chinavuungi chiva zimbulukitwe ni vañoli vava ku kunana navo. ");
INSERT INTO sbs_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Imi hava muvona, chinavuungi chiva komokwa niku tilila kwali ku mulumelisa. ");
INSERT INTO sbs_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Navuuza varutwana, “Chinzi chi mukwete ku kanana navo. ");
INSERT INTO sbs_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Zumwi mu chinavuungi namu mwitava. “Muruti, naleta mwanangu waswinsu kwako. Wina luhuho lumukanisa kuwamba, ");
INSERT INTO sbs_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","lumu hindeka, niku mudanseeka hansi nikuzwisa ifulo kumulomo, ni kusuma meeno akwe niku zuminina mubili. Na kumbira varutwai vako kulu zwisa kono vakangwa.” ");
INSERT INTO sbs_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Navetava, “masika asa zumini, muku hinde inako ikuma kuhi ninikele nawe? Kanive nanwe inako ikumahi? Mumu lete kwangu.” ");
INSERT INTO sbs_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ni valeta muswisu kwali. imi luhuho haluvona Jesu, hohwaho chilwa kumu nyunga ni kumuwisa hansi. Muswisu nawila hansi niku zwa ifulo kumulomo. ");
INSERT INTO sbs_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesu cha vuza vesi wa muswisu, “Kuzwa lili nena vuti?” Vesi chivati, “kuzwa vunini bwake. ");
INSERT INTO sbs_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Lumu wisikizanga hamulilo kamba mu menzi ni kusaka kumusinya. Heva uwola kuchita cimwi, tufwire nse nikutu tusa.” ");
INSERT INTO sbs_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesu chati kwali, “'Heva uwola'? Zose zintu ziwoleka kozuna yo zumina.'” ");
INSERT INTO sbs_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","“Hohwaho insi wa muhwile chahuwa nikucho kuti, “Ni zumina! Tuse kusa zumina kwangu!” ");
INSERT INTO sbs_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesu havona cinavuungi nichi tilile kuvali, cha kalimela luhuho zisa jololi nati: “Iwe luhuho lokusa wamba nikusazuwa, niku laela, uzwe kwali, kanji novoleli kumwinjila.” ");
INSERT INTO sbs_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Chilwa lila ahulu nikunyunga muswisu ni kukumusiya. Muswisu navonahala ubu sakayofwiile, nji kuti vuungi nivwati “U fwiile.” ");
INSERT INTO sbs_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kono Jesu chamuwonda kwiyaza niku muzimanika mwiwulu, imi muswisu chazimana mwiwulu. ");
INSERT INTO sbs_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Hacheza kwinjira muzuvo, varutwana vakwe ni vamuvuza kumbali, “Chinzi iswe hatusana twawola kuzizwisa?” ");
INSERT INTO sbs_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nacho kuvali, “Zina vuti kaziwoli kuzwiswa mbwita chentapelo.” ");
INSERT INTO sbs_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Chiva kazwako ni kuhita cha Galileya. Kana avakusaka niumwina kwiziva kubena, ");
INSERT INTO sbs_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kakuti avakuruta varutwana vakwe: Nacho kuvali, “Mwana Muntu mwahewe mumanza avaantu, imi muvamwihaye. Imi chinivamwihaya, chikwahita mazuva wo tatwe ka vuuke.” ");
INSERT INTO sbs_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kono kana vavazuwisisi iyi indava, imi vavatite kumuvuuza. ");
INSERT INTO sbs_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ni chibeza kwa Kapanauma. imi havena munzuvo chava vuza, “Saka muka wambolanzi mu nzila?” ");
INSERT INTO sbs_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kono vava totwere. Mukuti vava kukavulikananisa munzila za kucho njeni mukulwana. ");
INSERT INTO sbs_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nekala hansi nikusupa venekumi ni vovere hawiina, ni kucho kuvali, “Yosaka kuva wentanzi, ave wamamanimani kuvonse ni kuva muhikaana wavonse. ");
INSERT INTO sbs_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Chahinda muhwirezana ni ku muvika mukati kavo. namubika hamavoko akwe nikucho kuvali, ");
INSERT INTO sbs_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Yese yo tambula muhwire winavuti mwizina lyangu, name uni tambula, imi heva umwi unitambula, katambuli ime memeena, kono ni yavanitumi.” ");
INSERT INTO sbs_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Johani nati kwali, “Muruti, tuva voni umwi yo zwisa madimona mwizina lyako nitwa muziimika, mukuti katwi chilili.” ");
INSERT INTO sbs_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Imi Jesu chati, “Kanji mumu ziimiki, kakuti kakwina yete natende mutendo mukando mwizina lyangu ni kuzwahateni kusanduka kuwamba chintu chivilala changu. ");
INSERT INTO sbs_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Yense yasa tulwisi nji wetu. ");
INSERT INTO sbs_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yese yo kuha inkomoki ya mezi akunywa kakuti uwila kwa Keresite, chovusakusima niti kwenu, kete naluze mupuzo wakwe. ");
INSERT INTO sbs_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yense yetena letele umwi wava vahwilezana vazumina kwangu kuti awe, uyelele kusungwa ivwe ikando ni kusohelwa mwiwate. ");
INSERT INTO sbs_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Chi kuti iyaza lyako likuretera kuwa, linokole kwateni. Kulotu kwako kuwana vuhalo vusamaani, kuhita kuba ni mayaza ovele ni kuke njila mulihele, mumulilo usa zimiswa. ");
INSERT INTO sbs_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Musafwi isene ni mulilo usazimiswa. ");
INSERT INTO sbs_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Heva itende lyako likuletiseza kuwa, linokole kwateni. Kukuyelele kwinjila mubuhalo nochunkuta, kuhita kuva ni matende ovele ni kuka sohelwa mulihele. ");
INSERT INTO sbs_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Mu safwii isene mi nimulilo usa zimiswa. ");
INSERT INTO sbs_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Heva liinso lyako li kuletela kuti uwe, li nongomone mwateni. Kuku yelele kwinjira mwipuso ya Ireeza ni liso limwiina, kuhita kuke njira mulihere ni meeso overe. ");
INSERT INTO sbs_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Uko masene avo kaafwi, ni mulilo usa zimiswa. ");
INSERT INTO sbs_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Mukuti umwi no umwi mwa luungwe sautu ni mulilo. ");
INSERT INTO sbs_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Isautu ilotu, kono heva isautu chilwa sampuka, uwoola vule kuli tenda isautu hape? Muve mwisautu mukati kenu, imi muve ni nkoozo niva mwenu. ");
INSERT INTO sbs_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesu na asiya china chivaka ni kuyenda ku chikiriti cha Judeya niku chivaka mwishilya lyalwizi lwaJorodani, imi chinavuungi ni cheza kwaali hape. Ava kuvaluta hape, uvu hauvali mukwa wake. ");
INSERT INTO sbs_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Imi vafarisi chiveeza kwali kukumulika ni kuvuuza, Kuyelele ku mukwame ku kaana mwihyavwe?” ");
INSERT INTO sbs_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Netava, “Chinzi chava milaeli Mushe?” ");
INSERT INTO sbs_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","“Chivati, “Mushe ava zuminini mukwame kuñola iñolo lye nkauhano nikumutanda.” ");
INSERT INTO sbs_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","“Ivaali kukukutuhala kwe nkulo zenu chingi avamiñoleli uwu mulao,” Jesu naati kuvali. ");
INSERT INTO sbs_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kono kumatangilo empupo, 'Ireeza avavapangi mukwame ni mwanakazi.' ");
INSERT INTO sbs_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Cheli ivaka mukwame kasiye vesi ni vanyina ni ku ñambatila kwa mwihyabwe, ");
INSERT INTO sbs_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","mi vovele kavave inyama imwiina. 'mukuti kavasili vovele, kono inyama imwiina. ");
INSERT INTO sbs_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kuzwaho Ireeza chavakopanyi hamwiina, ka kwina muntu yochihita hakati.” ");
INSERT INTO sbs_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Havaveena munzuvo, valutwana chiva muvuza hape ku amana nezi. ");
INSERT INTO sbs_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Naati kuvali, “Yense yokana mwihyabwe niku sesa ungi mwanakazi uchita vusangu kwali. ");
INSERT INTO sbs_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","hakana mwihyabwe niku seswa kuungi mukwame, uchita vusangu.” ");
INSERT INTO sbs_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Chivaleeta vahwilezana vavo kwali kuti pona chova woondava, imi valutwana chivava kalimela. ");
INSERT INTO sbs_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kono Jesu hachailemuha, kenaava taveli ni kucho kuvali, “Muzuminine vahwilezana kwiza kwangu, kanji mu vakanini, mukuti muvuso wa Ireeza waavo vaswana naavo. ");
INSERT INTO sbs_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Chovusakusima niti kwenu, yense yasa satambuli muvuso wa Ireeza uvu muhwilezana cheniti kete naaka winjile.” ");
INSERT INTO sbs_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Linu chahinda vahwilezana ni ku va kumbata mu mavoko akwe niku vafuyola chaku vika mayanza akwe havali. ");
INSERT INTO sbs_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Imi hatanga lweendo lwakwe, mukwame chatilila kwali ni kukamufukama havusu bwakwe, ni kuvuza, “Muluti wina nenza, chinzi chinitamehete ku chita kuti niyole vuhalo vusamani?” ");
INSERT INTO sbs_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","“Imi Jesu nati, “chinzi honisumpa wina nenza? Kakwina wina nenza, mbwita Ireeza yeyena. ");
INSERT INTO sbs_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mwizi intaelo: kanji wihayi, kanji utendi vusangu, kanji wivi, kanji upaki mapa, kanji uchengeleli, kuteke isoo ni nyoko.” ");
INSERT INTO sbs_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mukwame nati, “Muluti, zonse izi zintu nibazikuteki kuzwa kubuhya bwangu.” ");
INSERT INTO sbs_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesu chikumulola ni kumusuna. Chati kwali, “Chintu chimwina chobulite. Utamehete kuwuza zonse zokwete ni kuziha kubahumanehi, imi kove ni chifumu chakwiwulu. Linu wize, nichilile.” ");
INSERT INTO sbs_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kono chevaka lyechi chiwambo, naboneka kuwilwa hahulu chazwaho ni kuyenda imi nayenda naswabite, mukuti abena chifumu chingi. ");
INSERT INTO sbs_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesu nalolalola nikucho varutwana vakwe, “Kukutu vuti ku vahumine kwinjila muvuso wa Ireeza!” ");
INSERT INTO sbs_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Varutwana niva komokiswa kuziwambo zakwe. Imi Jesu navolela kucho kuvali, “Vahwile, ku ka vo vule kwi njile mu muvuso we Ireeza! ");
INSERT INTO sbs_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ku huva kuti i kamere injile muliso lye ndonga, ku hita muntu wo muhumi kwi njila mu muvuso we Ireeza.” ");
INSERT INTO sbs_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Vava komokwa vukando ni kuwambisana, “Linu njeni yowola kuhazwa?” ");
INSERT INTO sbs_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesu chavalola ni kucho, “Nivantu kakuwoleki, kono isiñi niIreeza. Mukuti zonse zintu ziwoleka chaIreeza.” ");
INSERT INTO sbs_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pitolosi natanga kuwamba kwali, “Lole, tuvaka siyi zintu zonse ni kukwichilila.” ");
INSERT INTO sbs_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesu nati, “Chavusakusima nicho kwenu, kakwina waka siya inzubo, kamba vanaswisu, kamba vanakazana, kamba vanyina, kamba vesi, kamba vahwile, kamba inkanda, kachangu, nicheIvangeli, ");
INSERT INTO sbs_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Yaseti natambule chamwandaa kuvuungi hahanu mweinu inkanda: mazuvo, ni vanaswisu, ni vanakazana, ni vanyina, ni vahwile, ni zivaka, chamasukuluka, ni munkanda ikeza, vuhalo vusamani. ");
INSERT INTO sbs_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kono vangi vahitile kavave va mamani-mani, ni vamamani-mani kuva matangilo.” ");
INSERT INTO sbs_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Vavena mumugwagwa, kuya kwa Jerusalema, imi Jesu avena havunsu vwavo. Varutwana vava komoketwe, ni vavamwichilile vavatite. Linu Jesu nahinda vamana mayanza ovele nivovele kumbali hape nikutanga kuva wambila zete chiziwola kutendahala haho kwali. ");
INSERT INTO sbs_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Muvone, tukaya hesi kwa Jerusalema, imi Mwana Muntu kakahewe kuvapurisita vakulwana ni Vañoli. ");
INSERT INTO sbs_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kava munyanse hesi kulufu nikumuha kuVamachava. Kavamukuve, kumuswila, kumushupa, ni kumwihaya. Kono chikwahita mazuva otatwe kavuke.” ");
INSERT INTO sbs_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jakobo ni Johani, vaana swisu va Zevedia, chiveza kwali ni kumuti, “Muluti, tusaka kuti iwe ututendele zonse zitu kukumbila.” ");
INSERT INTO sbs_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Chati kuvali, “Chinzi chimusaka kuti nimi tendele?” ");
INSERT INTO sbs_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Chivati, “Tu zuminine kwikala nawe mwi kanya yako, umwi kuvulyo vwako ni umwi ku vunzohoto vwako.” ");
INSERT INTO sbs_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kono Jesu chavetava, “Ka mwizi chimukwete kukumbila. Muwola kunywa munkomoki yete ni nywe kamba kuva munkolovezo yete ni kolovezwe chayo?” ");
INSERT INTO sbs_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Chivacho kwali, “Tuwola” Jesu nati kuvali, “Inkomoki yete ninywe, mumuinywe. imi ninkolovezo ini kolovezwe chayo, nanwe kamu ikolovezwe. ");
INSERT INTO sbs_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Imi njeni yete chiwikala kuvulyo vweyanza lyangu kamba ku vunzohoto vweyanza lyangu kahena njikwangu kuha, kono njikwavo avo vava ivikiilwe.” ");
INSERT INTO sbs_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Vamwi varutwana vena ikumi havazuwa ichi, chivataanga ku nyerererwa Jakovo ni Johani. ");
INSERT INTO sbs_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesu chava sumpila kwali nikucho, “Mwizi avo vezibahele kuva vayendisi va Machava vava lyatilila, ni vantu va sepahala vavelekisa mulao mukando hewulu lyavo. ");
INSERT INTO sbs_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kono ketenikuve bulyo mukati kenu. Yense yosaka kuva mukando mukati kenu uyelela kuva muhikana wenu, ");
INSERT INTO sbs_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ni yense yosaka kuva kuvusu mukati kenu uyelela kuva chikombwa chavonse. ");
INSERT INTO sbs_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mukuti Mwana Muntu kena avakezi ku kutendelwa, kono kukutenda, ni kwiza kuha vuhalo bwakwe kulukulula vaangi.” ");
INSERT INTO sbs_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Chiveza kwa Jeriko. Havali kuzwa mwa Jeriko ni varutwana vakwe ni chinavuungi, mwana wa Timea, Vatimeya, mukumbiiri wachivofu, Avekele kumbali ninzila. ");
INSERT INTO sbs_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Hazuwa kuti nji Jesu wa Nazareni, chatanga kuhuwa ni kuwamba, “Jesu, Mwana wa Dafita, nifwile inse!” ");
INSERT INTO sbs_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Vaangi chiva kalimela chivofu chamumbila kuti atontole. Kono chahuwa kuekeza, “Mwana Dafita, ni fwile inse!” ");
INSERT INTO sbs_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesu chazimana ni kulaela kuti asumpwe. Chiva sumpa chivofu chamukwame, nivati “U kole, “Ziimane! U ku sumpa.” ");
INSERT INTO sbs_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Cha sohela kuna inguvo yakwe, kulotoka, nikwiza kwa Jesu. ");
INSERT INTO sbs_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Imi Jesu chamwitava nacho, “Chinzi chosaka kuti nikuchitile?” Chivofu cha mukwame chichati, “Muluti wangu, nisaka kuvolelwa kuvona kwangu.” ");
INSERT INTO sbs_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Imi Jesu nacho kwaali, “Kwiya. Itumero yako chiyakuhaza. “Hohyaho chawola kuvoona hape, nikumwichilila munzila. ");
INSERT INTO sbs_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Linu hachi va keza mwa Jerusalama, va vena hafuhi ni Betefage ni Betenia, he rundu lya Olive, mi Jesu cha tuma vovere va varutwani vakwe, ");
INSERT INTO sbs_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","mi cha va wambila, “Muyende ha munzi wutuli lolele nawo. Haho kuti chimwa wi njila, ka muwane imberesa iseni kumbereswa. Mu isumunune mi mu ka ini letere. ");
INSERT INTO sbs_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mi haiva zumwi mwa wambe kwenu, 'Chinzi ha mupanga ichi?' mu swanera kuwamba, 'Simwine u isaka mi haho vulyo mutuka itumine kunu.'” ");
INSERT INTO sbs_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Vava yendi mi chivaka wana imbongolo isuminwe ha mulyango hanze he nzila iyalukite, mi chi ba isumununa. ");
INSERT INTO sbs_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Vamwi vantu vavali ku zimene hateni ni chiva wamba kubali, “Mutenda nzi, ha mu sumununa imbongolo iyo?” ");
INSERT INTO sbs_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Vava wambi kuvali mwavava teli Jesu, mi vantu chi vava siya kuti ba yende. ");
INSERT INTO sbs_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Valutwani vovele chi ba ileta imbongolo kwa Jesu mi chi va zindwelela inguvo zavo kuti Jesu a tante hateni. ");
INSERT INTO sbs_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Vungi vwa vantu ni va zala zizwato zavo munzila, mi vamwi ni va zala mitavi yi va va ku tema mu mawa. ");
INSERT INTO sbs_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Avo vavena ha busu bwakwe navo vavali kumwi chilire chiva huwa, “Hosana! Imbuyoti njozo wiza mwi zina lya Simwine. ");
INSERT INTO sbs_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Imbuyoti yo muvuso ukezite weshetu Davida. Hosana mwi wulu!” ");
INSERT INTO sbs_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Mi Jesu che njila mwa Jerusalema ni kuya mwi tempele ni kuka lola hazintu zonse. Linu, inako kakuti chi yi ba manite, cha ya kwa Betenia ni vena ikumi ka vovele. ");
INSERT INTO sbs_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Izuva lichilira, hava ka vola kwa Betenia, ava fwile nzala. ");
INSERT INTO sbs_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ha vona isamu lye ifenga livena makova kuule zana, cha yenda kuti mwendi ka wane kwateni muselo. Mi hakeza kwateni kakwina chava wani konzi makoba, kakuti kana ibali inako ye misero ye feiga. ");
INSERT INTO sbs_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Cha wambila kulili, “Kakwina yete na lye muselo kwako hape.” Mi balutwani bakwe vava zuwi. ");
INSERT INTO sbs_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ni beza kwa Jerusalama, mi che njila mwi tempele ni ku kalisa kuzwisa bawulisi hanze ni ba ba kuwula mwi tempele. Cha pindumuna mataafule a ba tambuzana mali ni zipula zabo ba ba ku wuza inkwilimba. ");
INSERT INTO sbs_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kena a ba ku zuminina muntu yo hindite choku wuza kuhita mukati ke itempele. ");
INSERT INTO sbs_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Na valuta nati, “Ku ñoletwa, “I nzubo yangu mu yi sumpwa inzubo ye tapelo ya mishobo yonse'? Kono inwe chi mwa yi panga maipato a vasa. ");
INSERT INTO sbs_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Vapuritsita bakulwana ni bañoli ni ba zuwa za waamba, mi ni vaa saka inzila iba wola ku mwihaya. Mi vava tiite kakuti vungi vwa vantu vava komokiswe mwa va ku lutila. ");
INSERT INTO sbs_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Mi chitengu muchivali kwizilanga, vavali kusiyanga muleneñi. ");
INSERT INTO sbs_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Havavali kukavu yenda kakusasani, chi ba bona i samu lye ifeiga lizumite kutwala ku mihisi yalyo. ");
INSERT INTO sbs_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pitorosi cha kumbulukwa mi cha wamba, “Rabbi, bone! I samu lye ifeiga lyo va kuuti li zumite.” ");
INSERT INTO sbs_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesu cha ve tava, “Mu ve ni ntumelo kwe Ireeza. ");
INSERT INTO sbs_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Cha vuniti ni mi wambile ye nse yete a wambe kweli iluundu, 'Nyamuke mi u lizindile umwine mwiwate,' mi heva ka hakanyehi munkulo yakwe kono na zumina kuti mwa wambila ka ku tendahale, icho Ireza chete na pange. ");
INSERT INTO sbs_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Lyahanu ni wamba kwenu: Chonse chete mulapele ni ku chi kumbila, muzumine kuti chimwa chitambula, mi ka chive nji chenu. ");
INSERT INTO sbs_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Heva no zima ni ku lapela, u lukela kuwondela chonse ca ku fosekeze zumwi, ili kuti Ishenu wina kwiwulu naye ami wondele milandu yanu.” ");
INSERT INTO sbs_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kono haiva nosa wondeli, nanga Iso wina kiwulu kete aku wondela zivi zako. ");
INSERT INTO sbs_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Chi veza kwa Jerusalema hape. Jesu hava kuka vuyenda mwi tempele, mupurisita mukulwana, vañoli, ni vakulwana chi veza kwali. ");
INSERT INTO sbs_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Chiva wamba kwali, “chowuhi mulao wo panga izi zintu? imi njeni ya va kuhi mataa a ku zi panga?” ");
INSERT INTO sbs_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesu chawamba, “Ka ni mivuze i mpuzo yonke. Muni wambile mi name ka ni mi wambile kuti chaahi maata anipanga izi zintu. ");
INSERT INTO sbs_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","I nkolobezo ya Joani, i ba kuzwa kwi wulu kamba ku vaantu? Mu ni tabe.” ");
INSERT INTO sbs_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Chi va wambola mukati kavo mi chi kanana mi chi ku wamba, “Heva tuwamba, 'kuzwa kwiwulu,' ka wambe, 'chinzi hamusena muva muzumini?' ");
INSERT INTO sbs_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kono heba nituwamba', Kuzwa kuvaantu...” Vava tiite vaantu, kakuli zumwi ni zumwi ava zumine kuti Joani ivali mupolofita. ");
INSERT INTO sbs_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Linu chive tava Jesu ni vati, “Ka twizi.” Linu Jesu na va cho, “Name kani mi wambili chaahi maata ani panga zinu zintu.” ");
INSERT INTO sbs_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Lyinu Jesu na tanga kuva ruta che inguli. Nati, “Mukwaame a va vyalite iwa lye feiga, cholu zakiriza, mi chasa ne chikomba choku kamwina iveine. Ava zaki itawala mi chatambika iwa kuva vyala iveine. Lyahanu iye chayenda mumusipili. ");
INSERT INTO sbs_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","He nako iswanera, chaka tumina muhikana kuva vyali ve veine kwiza kuhinda kuvali zimwi zihantu zo mwiwa lye veine. ");
INSERT INTO sbs_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","vava muhindi, kumundama, ni kumuvonza nikusena chimwi cha hindite. ");
INSERT INTO sbs_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Hape chavatumina zumwi muhikana, mi chiva muhorofaza mumutwi ni kumu nyandisa ahulu. ");
INSERT INTO sbs_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Chatumina hape zumwi, mi uzu vavamwi hayi. Vava pangi vangi vamwi mwinzira iswana, kundama vamwi nikwi haya vamwi. ");
INSERT INTO sbs_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Avali kusina yenke zumwi mutu wo kutumina, mwana yo sakiwa. Avali njiwa mamani-mani wava tumini kuvali. Mi nati, “Muvaka kuteke mwanangu.” ");
INSERT INTO sbs_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kono vavyali vewa chivali wambira zumwi ku zumwi, “Uzu njeye swana, Mwize, tumwi haye, mi chifumu muchive chetu.” ");
INSERT INTO sbs_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Vava muwondi, kumwihaya niku mu zindira hanze lyewa lyeveine. ");
INSERT INTO sbs_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Linu, chizi chete apange mwine wewa lye veine? Mwakeze nikwiza kushinya babyali veveine ni kwiza kuha iwa lyeveine kuvamwi. ");
INSERT INTO sbs_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kamwini kuvala ili iñolo? 'Ivwe ilyo vazaki livava kani, livapangwa musumo. ");
INSERT INTO sbs_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ichi chivali kuzwa kwa Simwiine, mi chilotu mumenso entu.”' ");
INSERT INTO sbs_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Niva zeza kusumina Jesu, mi vavatiyite chinzi, ka kuti vavezi kuti ava wambi iyi nguli kutondeka avo. Chiva musiya ni kuliyendeza. ");
INSERT INTO sbs_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Linu chivatumika vamwi vama Farisi niva Heroda kwali kuka mu cheesa cha manzwi. ");
INSERT INTO sbs_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Mi havakeza, chiva wamba kwali, “Muruti, twizi kuti ko wina indava ne kuti muntu zumwe u tiinzi, mane hape u hinda vantu choku lyikana. U ruta cho vuniti inzira ye Ireeza. Kana mulao kuliha mutero kwa Sisare kamba vule? Tulihe kamba sanzi tulihi?” ");
INSERT INTO sbs_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kono Jesu avali kwizi mwipo wavo ni kuwamba kuvali. “Chizi hamuni lika? Munitambike i koviri iri kuti ni lole haili.” ");
INSERT INTO sbs_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Chiva leta yonke kwa Jesu. Cha wamba kuvali, “Chiswaniso chani ichi ni ziñoletwe?” Chivati, Sisare.” ");
INSERT INTO sbs_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesu chati, “Muhe kwa Sisare zintu zili za Sisare, ni kwe Ireeza zintu zili ze Ireeza.” Chava komokisa. ");
INSERT INTO sbs_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Linu va Saduki, vata kuti kakwina kuvuka kuvafwire, chiveza kwali. Chiva muvuza, nivati, ");
INSERT INTO sbs_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Muruti, Mushe ava tuñoleri, 'Haiva mukulwomuntu wa fwa ni kusiya muihyabwe, niku sena mwana, mwanche uswanera kuti a sese muka mukulwe, ne kumu zaalira vana.' ");
INSERT INTO sbs_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ku vena vakwame vakwana iyanza nivovere; we intanzi cha hinda mukulwakazi kusesa mi nikufwa, kusiya kakwina mwana. ");
INSERT INTO sbs_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Linu wovuveri cha hinda uzo mukulwakazi ni kufwa, kusiya kakwina mwana. Niwo vutatu naye ni kuswana. ");
INSERT INTO sbs_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mane ne woku mana iyaanza ne toovere na vula ku siya vaana. Ku mamanimani a teni mukulwaakazi naye choku fwa. ");
INSERT INTO sbs_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Muku vuka kwa vafu, chiva vuka, ka yive mukani? Ka kuti vonse va mana iyaanza ne toovere vava musesi.” ");
INSERT INTO sbs_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesu chawamba, Ili kajilyona ivaka hamupanga mafosisa, ka kuti ka mwizi mañolo kamba ziho ze Ireeza? ");
INSERT INTO sbs_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kakuti hateniva vuke kuvafwiire, kate niva sese kamba kusesiwa, kono kavaswane uvu mañiroyi mwi wulu. ");
INSERT INTO sbs_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kono kuyamana nivafwire avo vete niva vunswe, kena muvavali mwimbuka ya Mushe, mwi ndava iyama chihumbu, vule Ireeza mwava wambiri kwali ni kuti, 'Jeme Ireeza wa Amburahama ni Ireeza wa Isaka ni Ireeza wa Jakovo? ");
INSERT INTO sbs_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kena ji Ireeza wava fwire, kono wavahala. Mwina muma fosisa.” ");
INSERT INTO sbs_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Zumwi wava ñoli cheza nikwiza kuzuwa ingambolo yavo; ava voni kuti Jesu avave tavi hande. Chamuvuza, “Jouhi mulao wina vutokwa hayonse?” ");
INSERT INTO sbs_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesu chetava, “Ovu tokwa kuhitiliza jowu, 'Zuwe, Isiraele, Simwine Ireeza wetu, Simwine yenke. ");
INSERT INTO sbs_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","U swanera kusaka Simwine Ireeza wako che nkulo yako yonse, chemunahano wako onse, che mizezo yako yonse ni cheziho zako zonse.' ");
INSERT INTO sbs_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ovuvere mulao jowu, 'Uswanera kusaka yo wikala hembali nawe uvu molisakira umwine'. Kakwina imwi milao mikando kuhita iyi.” ");
INSERT INTO sbs_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mu ñoli chati, 'Yowina hande, Muruti! Wawamba vuniti kuti Ireeza yenke, ni kuti kakwina zumwi kwanda yakwe. ");
INSERT INTO sbs_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ku musaka ni nkulo yako yonse ni kutwisiso yako yonse ni cheziho zako zonse, ni kusaka yowikala hembali nawe sina molisakira iwe umwine, mane ihita nagati ineo zokusumika ni zitavero.” ");
INSERT INTO sbs_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Linu Jesu havona kuti waha ikalavo yo vutali, chati kwali, “Kowina kule ni muvuso we Ireeza.”Hakumana zina, kakwina zumwi yava zezi kuvuza Jesu ipuzo hape. ");
INSERT INTO sbs_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Mi Jesu chetava, yaho nakwete kuruta mwi tempere; chati, “Kwina vule kuti vañoli vawambe Keresite mwana wa Davinda? ");
INSERT INTO sbs_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Davinda iye mwine, mu Luhuho lu Njolola, avacho, wikale kwi nyanza lyangu lyechiliso, kusikira hate nini pangire vakulwisa maltatiro a matende a ko.' ");
INSERT INTO sbs_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davinda iyemwine umu supa kuti 'Simwine; cwale kuwoleka vule kuti Keresite ave mwana wa Davida?” Chisi chikando chivali kusangitwe ahulu kutekereza kwali. ");
INSERT INTO sbs_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mututo zakwe Jesu ava wambi, “Mutokomere vañoli, vasaka ahulu kuyenda muzizwato zilele mi vasaka itumeriso ziva wana muzivaka zomusika ");
INSERT INTO sbs_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","mi vasaka kuwana zipura zovulena muma sinangonge ni zivaka za malena ha mikiti. ");
INSERT INTO sbs_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Miva vasinya mazuvo e mberwa, mi valapera itapero inde luli iri kuti vantu vavone. Ava vakwame kavatambule ikatulo ikando luli.” ");
INSERT INTO sbs_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Linu Jesu chekala hansi kumbali ni ka tanda ke neo muchivaka che tempere; avali kukwete kulwera vantu chiva vika mashereñi avo muchitanda. Vungi vwava fumite vavali kuvika mashereñi mangi. ");
INSERT INTO sbs_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Chikwakeza mukulwakazi avali kufwirirwe we mberwa nikwiza kuvika makoviri overe, alikana i shiriñi. ");
INSERT INTO sbs_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Mi chasupa varutwana vakwe ni kuva wambira, “Chovuniti ni miwambira, uzu mukulwakazi yasali wanini wa vikamo kuhita vonse vavika muchitanda che neo. ");
INSERT INTO sbs_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kakuti vonse vaha kuzwisa hachifumu chavo, kono kuzwa havunjebwe bwakwe, wavikamo onse mashereñi aswanera kuli hazikiza ho.” ");
INSERT INTO sbs_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Sina Jesu havali kuyenda kuzwa mwi tempere, zumwi kuva rutwana vakwe cha wamba kwali. “Muruti, lole ha mavwe akokiswa ni muyaho ukomokisa!” ");
INSERT INTO sbs_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Cha mu wambila, “Ubwene iyi mizako mikando?” Kakwina nangati ivwe lyonke lyete nili shale ni lilimbite limwi lyete nili kangwe kuwiswa hansi.” ");
INSERT INTO sbs_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Sina havali kwikere he Rundu lya Olive kulilolera ni tempere, Pitorosi, Jakovo, Johani ni Anderiasi chivamuvuza kwimbali, ");
INSERT INTO sbs_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tu wambile, izi zintu kazi pangahale lili? Zi supo nzi zitu lukere kuvona heva izi chi zina hafwihi niku pangahala?” ");
INSERT INTO sbs_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesu chatanga kuwamba kuvali, “Mutokomere kuti kakwina zumwiyante ami yembulule. ");
INSERT INTO sbs_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Vangi kavakeze mwizina lyangu ni kuti, 'Jime iye; mi kava yembulule vaangi. ");
INSERT INTO sbs_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ha mu zuwa ze kondo, ni ma hulyuhulyu e kondo sanzi mu vileli; inzo zintu zi lukere kupangahala, kono mamanimani kaeni kusika. ");
INSERT INTO sbs_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Cho kuti i kanda kai lwise i kanda, muvuso ka u lwise mu vuso. Ka kuve ni zikinyeho mu zi vaka zimwi ni nanga. Aa njima ma tangilo a ku sasama kwaku huzumuka (kusumunuka). ");
INSERT INTO sbs_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Muve muva mameli venu mu vene. Mu vaka mi twale kuva si tutengo, mi kamu ka kavolwe mwi muma sinangonge. Kamu zimane ha vusi bwa vavusisi ni malena ke vaka lyangu, Sina vupaki kuvali. ");
INSERT INTO sbs_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kono pili ivangeli lyi lukere ku ku taziwa mwi kanda zose. ");
INSERT INTO sbs_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ha va mi sumina niku mi twala, sezi mu vilelezwa zete muwambe. Ka kuti mweyo ihola zeti muwambe kamu zi hewe; Kese i ve njenwe mu wamba, kono Luhuho lu Njolola. ");
INSERT INTO sbs_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mukwakwe mutu ka veteke mukwake kwifuu, mi vesi mwana wa vo. Vaana kava zimane ni kulwisa bashemi va vo, nikuva letera kuvikiwa kwi ifu. ");
INSERT INTO sbs_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mu mu toiwe kubatu vonse ivaka lye zina lyangu. Kono yense yate a wonderele hesi kuma mani mani, unzo muntu ka hazwe. ");
INSERT INTO sbs_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Chimwa vona vuvi vu dadola kuti bwina havusa swaneli( yo vala a zuwi sise), mu siye avo vena mwa Judea va tilile ku ma ruundu. ");
INSERT INTO sbs_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","mi wina hakatungandu kezuvo sanzi a voli mwi zuvo kapa kuhinda cimwi mwa teni, ");
INSERT INTO sbs_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","mi mu siye wina mwi waa, sanzi abolyi kuka hinda inguvo. ");
INSERT INTO sbs_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kono bumai kwavo be minsi mwe yo i nako kapa vanyosa mweyo inako! ");
INSERT INTO sbs_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mulapele kuti kanji nzi pangahali ha maliha. ");
INSERT INTO sbs_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kakuti ka kuve ni manyando makando, aseni kuvonwa kutanga ku matangilo, aho Ireeza ha bumba i kanda, konji hanu, nanta, hape kese ni ku ve vulyo. ");
INSERT INTO sbs_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Hesi Simwine cha fwihaza mazuva, kakwina inyama yese ni hazwe, Kono kevaka lyi va ketetwe, avo vava keti ava fwihazi i palo ya mazuva. ");
INSERT INTO sbs_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Lyahanu heva zumwi chacho kuti, 'Vone, zunu kiresite!' kapa 'Vone, zuna hana!' sanzi mu zumini. ");
INSERT INTO sbs_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kakuti va kiresite va mapa ni vapolofita va mapa muva voneke mi kavahe zisupo ni makazo, kuku yembulula, nanga niva ketetwe. ");
INSERT INTO sbs_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mu tokomele! China mi wambila izi zintu niku sina i nako. ");
INSERT INTO sbs_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Kono chi amana manyando ayo mazuva, izuva kalisihiswe, mwezi kese uhe i seli lya teni, ");
INSERT INTO sbs_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","i kaani kaziwe kwi wulu, mi ziho zina kwi ulu kazi nyanganiswe. ");
INSERT INTO sbs_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Lyaho kava vone Mwana Muntu na keza muma kope ni ziho zikando ne kanya. ");
INSERT INTO sbs_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Mi ka tume mañeloyi akwee mi ka kopanye hamwina ba ketetwe, kuzwa muma ihuho zo nee, kuzwa ma mani mani e kanda kuya kumamanizo e wulu. ");
INSERT INTO sbs_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Muli tute ituto kwi samu lye Fenga, Haho mutavi hau zuma ni kuwisa makova alyo, mwi ziva kuti imbumbi chiyina hafuhi. ");
INSERT INTO sbs_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mi hape, hamu vona i zi zintu nizi pangahala mwi zive kuti cho wina hafwihi, ha fuhi ne mulyango. ");
INSERT INTO sbs_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ka busakusima nimi wambila ulu lu zuvo kese lu fwee inzi zitu nizi seni kupangala. ");
INSERT INTO sbs_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","I wulu ni kanda kazi mane, kono mazwi angu kese ni a mane. ");
INSERT INTO sbs_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Kono ku amana nelyo izuva kamba iyo inako, kakwina yo yizi, nangati mañiloyi, kamba Mwana, kono tayo. ");
INSERT INTO sbs_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mu tokomere! Mulole, kakuti ka mwizi kuti inako nzi. ");
INSERT INTO sbs_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ku swana iri mukwame yo yenda mumu musipili, u siya i zuvo yakwe niku vika bahikana vakwe kuku mamele i zuvo, zumwi ne zumwi ne musevezi wakwe, ni ku laela mungateli kuti a tonde. ");
INSERT INTO sbs_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Lyahanu mwikale ni mutonda, kakuti kamwizi aho simwine we zuvo yasaka vole kumuzi; i wola kuva muchitengu, ha kati ka masiku, mukombwe ciwa lila, kapa kakusasani. ");
INSERT INTO sbs_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Heva nakeza chokuhyera, kanji mumuzuminini kumi wana mulere. ");
INSERT INTO sbs_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Izo zini wamba kwenu ni ziwambira vonse: Mutonde!” ");
INSERT INTO sbs_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Chiyi vali hanu mazuva overe niwuseni kusika mukiti we Paseka ni Mukiti we nkonko isena Mulungo. Mukulwana wavaPurisita ni vañoli vavali kunganisisa mwete vawolere kuwonda Jesu ni kumwihaya. ");
INSERT INTO sbs_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ka kuti vavali kuwamba. “Isiñi hamukiti, iri kuti kanji kuvuki inyakanyaka mukati kavantu.” ");
INSERT INTO sbs_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Lyahanu Jesu avena mwa Betani mwizuvo ya Simoni we mbingwa, sina havali kwikere he tafule, mukulwakazi chakeza kwali ni votera lya alabasitera lyomunikiso undula ahulu, uvali wa menzi a nandi. Cha pwachula ivotera ni kuitira hamutwi wakwe. ");
INSERT INTO sbs_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mi kuvena vamwi vavali kuvengete. Chiva wamba kukati kavo nivati, “Ivakanzi lye shinyehero iyi? ");
INSERT INTO sbs_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Iwu munukiso uvali kuswanera kuwuziwa kumashereñi a hitilira miyanda yotatwe ye dinarii, ni kuha kuva shevete. Imi vavali kumu kalimera. ");
INSERT INTO sbs_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kono Jesu chawamba, “Mu musiye yenke, mu mu kataleza nzi? Wapanga chitu chilotu kwangu. ");
INSERT INTO sbs_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mwina inako yonse vashevete nanwe, mi inakao yonse imwa saka muwola kupanga zilotu kuvali, kono kete muve name inako yonse. ");
INSERT INTO sbs_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Wapanga icho cha wola: wa singa muvili wangu haku zikwa. ");
INSERT INTO sbs_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","“Chovu niti ni wamba kwenu, konse uko ivangeli kwete ikakutaziwe mwi kanda yonse, icho chapanga uzu mukulwakazi kachika wambiwe, mwikupuzo yakwe.” ");
INSERT INTO sbs_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Lyinu Judasi Isikariyota, zumwe wava vena ikumi ne tovere, a va yendi ku vapurisita vakulwana kuti a wolye kumuva wuzukiza choku muva tambika. ");
INSERT INTO sbs_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Lyahanu mukulwana wa mapurisita hazizuwa, vavali kutavite ni kumu sepisa kumuha mashereñi. Chatanga kulola inzira yate awane chivaka cho kumutambika kuvali. ");
INSERT INTO sbs_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mu izuva lye ntazi lye chinkwe chisena mumera, chinga va panga chitavero che imberere ye paseka, varutwana vakwe choku mucho kuti, “U saka kuti tuye kuhi kutu wola kuka ku vakanyeza zilyio ze paseka, iri kuti ukalye zilyo ze paseka? ");
INSERT INTO sbs_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Choku tuma vovere va varutwana vakwe choku vacho kuti, “Mu kwiya mu muleneñi, ku zwaho mumu wane mukwame yo hindite kahambwe kamenzi mwami katane. Mu muichirire. ");
INSERT INTO sbs_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Mu inzuvo yeeti a ke injire, mu muichirire mo mi muka cho kusi inzuvo kuti, 'Muruti ucho kuti, inzuvo yangu yeti ni lyire ipaseka ne varutwana vangu yina kuhi?'” ");
INSERT INTO sbs_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Mwa a ka mutondeza inzuvo inkando yi vakanyizwe yahe wulu, muka tuvakanyeze mwateni.” ");
INSERT INTO sbs_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Varutwana ni va zwa ni kuyenda mumuleneñi. Mi ni va ka wani chimwe ne chimwe china sina mwa a vawambiri kuvali, mi. ");
INSERT INTO sbs_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ha chivali chitengu, chakeza ni vekumi nivovere. ");
INSERT INTO sbs_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Sina havavali kwi kere he tafule ni kulya, Jesu chati, “Chovuniti ni wamba kwenu, wumwina kwenu yo lya name.” ");
INSERT INTO sbs_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Vonse vavali lizuwi inkumbu, mi zumwi ni zumwi chiva wamba kwali, “Luli isiñi me?” ");
INSERT INTO sbs_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesu che tava ni kuvawamba kuvali, “nje zumwi wa vena ikumi ne vovere, yozo yo sunsa name inkonko mu kasuva. ");
INSERT INTO sbs_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kakuti Mwana wo Muntu mwayende mwinzira iyo mañolo awamba kuyamana naye. Mi ku mayivite kozuo mukwame yo veteka Mwana o Muntu! Ku vaa shiyeme kuti kalyi uzu muntu na sana a va zalwa.” ");
INSERT INTO sbs_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Chi va si kwete kulyia, Jesu cha hinda chinkwe, ni kuchi fuyola, ni kuchi jamona. Ava chivahi ni kuwamba, “Muhinde ichi. Uwu chimuviri wangu.” ");
INSERT INTO sbs_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Chahinda i komoki, nikulitumera, ni kuitambika kuvali, mi vonse chiva nya kuili. ");
INSERT INTO sbs_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Chawamba kuvali, “Aya jamalaha angu echilikani, malaha awo etilirwe vangi. ");
INSERT INTO sbs_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Chovu niti niwamba kwenu, Kasane kani nywe hape kwezi zihikantu hape ze veine kusikira kusikira lina izuva hate kani inwe mumuvuso we Ireeza.” ");
INSERT INTO sbs_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Hachiva manite kuzimba luzimbo, chiva yenda hanze kwi Lundu lya Olive. ");
INSERT INTO sbs_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesu chata kuvali, “Muvonse mumunitiyire, kakuti kuñoletwe, 'Muni kave mulisani mi imberere kazi hasane.' ");
INSERT INTO sbs_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kono china mana kuvuswa hape, Kanili tangize kwenu kuya kwa Galileya.” ");
INSERT INTO sbs_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pitorosi choku mucho kuti, “Nangati vonse kava ku tiyire ime keti ni ni ku tiyiire.” ");
INSERT INTO sbs_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesu chamu wambira kuti, “Cho vuniti nikuwambira, masiku a sunu, mukombwe ni useni kulira kovere, moni sapule kotwatwe.” ");
INSERT INTO sbs_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Kono Pitorosi chati, “Haiva nini wola kufwa nawe, kete nikusampule.” Vonse vava chiva panga i sepiso i swana. ");
INSERT INTO sbs_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Va veza ku chivaka chi sumpwa Getesimani, Jesu cho kucho varutwana vakwe, “Mu ikale a ha chini rapera.” ");
INSERT INTO sbs_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Cha hinda Pitorosi, Jakovo ni Johani choku zwa navo, choku tanga ku wirirwa ne ku katazeha a hulu. ");
INSERT INTO sbs_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Cha wamba kuvali, “Luhuho lwangu lu zuwire ku chisa a hulu, nanga kwi nako yefu. Mu shale hanu ni kutonda.” ");
INSERT INTO sbs_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jesu na ya ha vusuzana, choku wa hansi, choku rapera kuti kambe ni ku wolyeka, iyi inako imu hitirire kwali. ");
INSERT INTO sbs_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nati, “Abba, Tayo, zintu zonse zi wolyeka nawe. Zwisa iyi inkomoki kwangu. Kono isiñi chini saka, Kono yako.” ");
INSERT INTO sbs_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Chaka vola ni kwiza kuvawana valere, mi chawamba kwa Pitorosi, “Simoni, ulere? Wakangwa kutonda nagati i hola yonke? ");
INSERT INTO sbs_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mutonde ni kulapera iri kuti kanji mwinjiri mumuliko. Luhuho che niti lusaka, kono inyama i kangitwe.” ");
INSERT INTO sbs_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Hape chayenda kule ni kukalapera, mi ava severisi manzwi a swana. ");
INSERT INTO sbs_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Hape cha vola ni kukavawana valere, kakuti menso avo avali kulema mi kena vavali kwizi cho kuwamba kwali. ");
INSERT INTO sbs_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Cho kuiza lo vutatu na vacho kuti, “Mu si lere ne ku pumula? Muvuke! inako chi ya sika. Muvone! Mwana o Muntu cha vekwa mumanza ava ezalivi. ");
INSERT INTO sbs_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mu vuke; tuyende. Muvone, uzo yo ni veteka wina hafuhi.” ");
INSERT INTO sbs_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Cho usi kwete ku wamba, Judasi, zumwe wa vena ikumi ne tovere, choku sika, nena ni vantu vangi ni va ka kwete mikwale ni masavule, kukazwa ku vapurisita vakulwana, n vañoli, ni vakulwana. ");
INSERT INTO sbs_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Lyahanu yo muveteka avava here chisupo, kuti, “Uzo yete ni chunchune nji yena.” ");
INSERT INTO sbs_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judasi hasika, pona aho cheza kwa Jesu nikuwamba, “'Rabbi! mi chamu chunchuna. ");
INSERT INTO sbs_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Linu chivavika maanza hali ni kumu sumina. ");
INSERT INTO sbs_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kono zumwi yava zimene hembali chazwisa mukwale niku kosola kutwi kwa muhikana wo mupurisita mukulwana. ");
INSERT INTO sbs_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesu chawamba kuvali, “mu ka ni izilile mane ili musa, cha mikwale ni che inkolyi kwiza kuni wonda? ");
INSERT INTO sbs_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nivena nenwe izuva nezuva hini vaku siina nnaanwe izu nva niva kuluta mwi tempele, kena muva nisumini. Kono ichi chiva pangahali kuti intimana zi zuzilizwe.” ");
INSERT INTO sbs_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Mi vavena ni Jesu vava musiyi niku valeha. ");
INSERT INTO sbs_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mu lombwaana, ya va zwete vulyo inguvo ivali kumuzingerete, avali kwi chilire Jesu. Aho vakwame hava mukwata, ");
INSERT INTO sbs_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","chasiya inguvo ye line ni kutiya mapunu. ");
INSERT INTO sbs_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Vavatwali Jesu kumupurisita mukulwana. Uko vavali kungene naye vonse malena vamapurisita, vakulwana, niva ñoli. ");
INSERT INTO sbs_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Lyahanu Pitorosi avali kumwi chilire chaka vakazana, mane mbwita kukasika he rapa lya mupurisita mukulwana. Avake kali mukati kava ngateri, vavali kwina hembali ni muliro kuli tukusa. ");
INSERT INTO sbs_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Linu mukulwana wava purisita ni nkuta ya Majuda vonse vavali kungana vupaki vuhambiriza Jesu iri kuli vamwi haye. Kono kakwina vuvava wani. ");
INSERT INTO sbs_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kakuti vangi vavaleti vupaki bwa mapa kumulwisa, kono mane vupaki bwavo kena vuva zumizani. ");
INSERT INTO sbs_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Vamwe ni va zimana avo choku mu hambiriza, ni vaati, ");
INSERT INTO sbs_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Tu vamu zuwi nati, 'Ka ni rutunune iyi itempere yi va pangwa cha manza, mi ku zwaho njeti nini pange yimwe yi sana yiva pangwa cha manza.'” ");
INSERT INTO sbs_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mane nangati aho hape vupaki vwavo ni vwa vula ku zuminzana. ");
INSERT INTO sbs_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mu purisita mukulwana ava zimani mukati kavo ni kuvuza Jesu, “Kowina iwe ikalavo? Chintu nzi ava vakwame zivapaka kuamana nawe? ");
INSERT INTO sbs_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kono avali kuntontwere ni kusetava chimwi. Hape mupurisita mukulwana chamuvuza ni kuti, “Jewe Keresite, mwana wozo yo fuyaulitwe?” ");
INSERT INTO sbs_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesu chati, “Jeme. Mi kovone Mwana o Muntu hasana kekale he yanza lyokulisa lya ziho ni kukeza ni makope e wulu.” ");
INSERT INTO sbs_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mu purisita mukulwaana cha halula mukanjo wakwe ni kucho, “Tusi saka vumwi vupaki? ");
INSERT INTO sbs_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mwazuwa vunyefuli. Ikatulo yenu jeyihi?” Mi vonse chiva yatula uvu zumwi yoswanera ifu. ");
INSERT INTO sbs_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Vamwi chivatanga kumu swira mate ni kuwumba impata yakwe ni kumu vakula ni kucho kwali, “Porofite!” Mapokola chiva muhinda ni kuka mundama. ");
INSERT INTO sbs_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Linu Pitorosi havali kwina hanze ye rapa, omwina muhikana wo mukazana wo mupurisita mukulwana cheza kwali. ");
INSERT INTO sbs_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Avavoni Pitorosi sina havali kuzimene ha muliro kuli tukusa, mi chalola hande kwali. Mi cha wamba, “I we nawe uvali kwina nimu Nazareta, Jesu.” ");
INSERT INTO sbs_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kono ava sampuli, nati, “Kanimwizi kamba kuzuwisisa chizi chowamba nacho.”Lyaho che jira mwirapa. ");
INSERT INTO sbs_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kono muhikana wo mukazana umo chamuvona nikutanga kuwamba hape kwavo vavali kuzimene, “Uzu mukwame ji zumwi wavo!” ");
INSERT INTO sbs_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kono cha kanana hape. Hakuhita inako zana vulyo avo vavali kuzimene ho vavali kuwamba kwa Pitorosi, “Kamaniti uzumwi wavo, kakuli nawe umu Galileya.” ");
INSERT INTO sbs_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Kono chatanga kulivika muchikuto ni kulinkonka, “Kanizi uzu mukwame umukwete kuwamba zakwe.” ");
INSERT INTO sbs_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Mukombwe yahaho chiwa lira lyo vuveri. Mi Pitorosi cha hupula manzwi awo Jesu ava muwambiri: “Pilio mukombwe niuseni kulira tovere, moni sampule to tatwe.” Imi cha virera ni kulira. ");
INSERT INTO sbs_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kakusasani luli, bapurisita bakulwana choku kopana hamwiina ni bakulwana ni bañoli mi ni khuta yonse ya Majuda. Linu chi basumina Jesu ni ku mutwala. Chi ba mu tambika kwa Pilato. ");
INSERT INTO sbs_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato na mu buza, “Njiwe u Simwine wa Majuda?” Cha mwitaba, “Uwe njo wamba bulyo.” ");
INSERT INTO sbs_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Bapurisita bakulwana ba bali ku hambiza Jesu milandu mingi. ");
INSERT INTO sbs_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Hape Pilato cha mubuza, “Ko ni tabi? Bone milandu ku bungi yi ba leta ni ku ku hambiliza!” ");
INSERT INTO sbs_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kono Jesu kana abali ku chi mwi taba Pilato, mi iyo ndaba ni ya mukomokisa. ");
INSERT INTO sbs_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Linu mu inako ya mukiti, Pilato a vali ku lukululanga kuvantu chifosi cho nke, chifosi chi vavali ku li kumbililanga. ");
INSERT INTO sbs_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mwateni ni vasandukile muntolongo, mukati ka vehayi va vakwatilwe ka kuva ni chiyemba mu kusandukila, kuvena mukwame ya vali ku sumpwa Banabasi. ");
INSERT INTO sbs_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Vungi vwa vantu chi vweza kwa Pilato mi chi va tangisa ku mu kumbila ku va pangila sina mwa va pangililanga inako yonse. ");
INSERT INTO sbs_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Cha ve tava Pilato mi nati kuti, “Musaka kuti ime ni mi lukululele Simwine wa Majuda?” ");
INSERT INTO sbs_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kakuti a vezi kuti i vali che vaka lya muna vapurista vakulwana ha va va hi Jesu kwali. ");
INSERT INTO sbs_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kono vapurista vakulwana chi va shongeleketa vungi vwa vantu kuhuwa ahulu kuti Vanavasi a lukululwe. ");
INSERT INTO sbs_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato chave tava hape ni niku wamba, Chinzi cwale chini swanera kupanga ni Mulena wa Majuda” ");
INSERT INTO sbs_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Chiva huwereza hape, “Mu kokotele!” ");
INSERT INTO sbs_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato cha wamba kuvali, “Mulandu nzi wa tenda?” Kono chi ba huwa ahula ni ahulu, “Mu mu kokotele.” ");
INSERT INTO sbs_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ka kuti Pilato abali ku saka ku zuwisa hande vantu, mi cho ku lukulula Banabasi. Cha shupa Jesu mi ni ku mubaha kuti ba mu kokotele. ");
INSERT INTO sbs_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Masole chi ba mutwala mukati ke ilapa (iri muleneñi wo muvuso), mi chi ba sumpila masole bonse hamwina. ");
INSERT INTO sbs_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Chi ba zwatika Jesu chizwato chisubile mi chi ba zingela ihusi ya miya mi chi bai mu zwatika ku mutwi. ");
INSERT INTO sbs_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Linu chi ba tangisa ku mu lumelisa ni bati, “Osho, Simwine wa Majuda!” ");
INSERT INTO sbs_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Chi ba mukaba ha mutwi ka luhe ni ku muswila. Ba ba kuchola mazwi abo habusu bwa kwe ku mukuteka. ");
INSERT INTO sbs_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mi linu ha chi ba mana ku mushubula, chi ba mu chupula chi zwato chi subila ni ku mu zwatika za kwe zi zwato, mi linu chi ba mu zwisa ku mutwala ku ka mu kokotela. ");
INSERT INTO sbs_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Chi ba bika ya bali kulihila fela mu musebezi, ya bali ku ka zwa mu nkanda, mukwame ya bali ku sumpwa Simoni wa Sirene (isi wa Alexander ni Rufusi); chi ba mu hambiliza ku kulika cifapano cha Jesu. ");
INSERT INTO sbs_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Masole chi ba twala Jesu ha cibaka chi sumpwa Gologota (i talusa kuti Cibaka cha katendere). ");
INSERT INTO sbs_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ni ba mu newira iwaine ikopenywe ni shantukwe, kono ka hena a ba inywi. ");
INSERT INTO sbs_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ni ba mu kokotela mi ci bali kauhanyeza zi zwato za kwe ka ku sumikiza kwi ziba kuti uzu lisole ni lisole ka hinde nzi. ");
INSERT INTO sbs_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","I bali ke nako ya butatu ha ba mu kokotela. ");
INSERT INTO sbs_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ha chishupo ku ba ñoletwa indaba za ku mu lwisa, “Simwine wa Majuda.” ");
INSERT INTO sbs_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ku ba kokotelwe naye basa bobele, umwina ku malyo mi zumwi ku ma monso akwe. ");
INSERT INTO sbs_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Mi inolo ni le zuzilizwa lita kuti a be haiwa ni zifosi. ");
INSERT INTO sbs_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Avo vava kuhita vavali ku mutuka, ni va nyunga mwi twi yavo mi ni vati, “Ehe! U vali kuti no va lutununi itempele ni kui zaka hape mu ma zuva o tatwe, ");
INSERT INTO sbs_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","U lihaze u mwine mi uzwe u suke ha chifapano!” ");
INSERT INTO sbs_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mu nzila iswana vapurisita vakulwana va vali ku mushuvula mukaati kavo navo, hamwina ni vañoli ni va cho, “A vali kuhaza vamwi, kono iye ka lihazi mwine. ");
INSERT INTO sbs_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Musiye Kilesite, Simwine wa Isilaele a zwe a suke ha chifapano hwa hanu, kuti tu mu vone mi tu zumine.” Mi va va kokotelwe naye na vo va vali ku mu sheununa. ");
INSERT INTO sbs_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mi nako imane iyanza ha ikwana, keerima ni ka wumba inkaanda yonse mbwiita che inako yoku mana iyanza ni tone. ");
INSERT INTO sbs_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Mi inako ya kumana iyanza ni tone, Jesu cha huwa ka linzwi li zuweka ahulu “Eloi, Eloi, la masabakatani?” I talusa kuti, Ireeza Wangu, Ireeza wangu, Wani siila nzi?” ");
INSERT INTO sbs_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Vamwi kwa va vo va va ku zimena he mbali, chi va zuwa mi ni vati, “Muvwene, cha sumpa Elia.” ");
INSERT INTO sbs_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Zumwi cha tiya, ku kahinda chiponchi ku chitila i waine i chanchumuka, cha chi bika ku mpela ya luhe, mi chi ku muha kuti a nywe. Uzo muntu cha wamba kuti, “Musiye! tubone kamba Elia ukezite kwiza ku mu hangula.” ");
INSERT INTO sbs_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Mi Jesu cha huwa ka linzwi li zuweka ahulu mi cho kufwa. ");
INSERT INTO sbs_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Isira lya mu itempele chi lya haluka tobele kutangiseza ku iwulu kutwala hansi. ");
INSERT INTO sbs_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mi muyendisi we chisole ya ba zimine na lolete Jesu, ha vona kuti wa fwa mweyi nzila, cha wamba, “Cha Vuniti uzu mukwame ivali mwana we Ireeza.” ");
INSERT INTO sbs_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ku vena vamwi vanakazi va va bwenene kule. Mukati kabo ku vena Maria Magadalena, Maria (inyina wa Jakobo munini ni Josesi) ni Salome. ");
INSERT INTO sbs_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Mi havena mwa Galileya va va mwi chilile ni ku mu tendela. Vamwi va vanakazi bangi na vo va va kezite naye kwa Jerusalema. ");
INSERT INTO sbs_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Mi nako ya chitengu ha yi sika, ka kuti li bali izuba lyo mughivero nji kuti, izuba lwe Sabata, ni li seni ku sika. ");
INSERT INTO sbs_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Josefa ya va kuzwa kwa Arimatea ca keza mwa teni. A vali i membala ya vali ku kutekewa we chikwta cha Majuda, ya vali ku lindile mubuso wa Ireeza. Na kenjila kwa Pilato kakusa tiya ni ku ka kumbila mubili wa Jesu. ");
INSERT INTO sbs_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Mi Pilato cha komokwa ahulu hazuwa kuti Jesu wa fwa kale; ava sumpi mukulwana wa masole ni ku mubuza heba Jesu cha va ku fwile. ");
INSERT INTO sbs_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pilato ha zuwa kumuyendisi wa masole kuti Jesu chavali kufwire, cha lukulwila chitunta chakwe kwa Josefa. ");
INSERT INTO sbs_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josefa a va li ku wulite masira e lineni. Cha muzwisa ha chifapano, ni ku mu bungila mumasira e lineni, mi chi ku mulalika mu ikumbu lya ba chakuile mu mavwe. Linu cha pindumwina ibwe mu mulyango we ikumbu. ");
INSERT INTO sbs_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Magadalena ni Maria inyina wa Josesi va va voni chivaka i cho Jesu mwa va zikwa. ");
INSERT INTO sbs_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Izuba lye Sabata ha limana, Maria Magadalena ni Maria inyina wa Jakobo ni Salome, ni va wula mi nunkiso, kuti va yende va ka singe mubili wa Jesu. ");
INSERT INTO sbs_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Cho kufuma ahulu kakusasani ku sili kulunza izuva lye ntanzi lye Nsunda, chi ba yenda ku ikumbu izuva ni liseni kuñatula. ");
INSERT INTO sbs_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Va vali kuya vu wambola, “Njeni yeti a katu pindumwiine ibwe kuzwa ha menjililo e ikumbu?” ");
INSERT INTO sbs_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mi hava nyamuna menso, chi va vona kuti ibwe liva pindumunwa, ka kuti livali ikando ahulu. ");
INSERT INTO sbs_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ni benjila mu ikumbu mi chi va vona muswisu ya va zwete chizwato chi tuva, ne keele ku imbali ya malyo, mi va va komoketwe. ");
INSERT INTO sbs_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Chava wambila, kanji mutiyi. Mu saka Jesu, mu Nazareta, ya va kokoterwa. Waa vuka! Ka kwina hanu. Mu vone mu chivaka umo mu vava mulalikite. ");
INSERT INTO sbs_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kono muyende, mu ka wambile valutwani ni Pitorosi kuti mwa yende havusu bwenu cha ya kwa Galileya. Kwateni kwete mu ka muvonene sina ha va milwili. ");
INSERT INTO sbs_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ni va zwila hanze ni kutiya mu ikumbu, va vaIi ku chachalika ni ku komokwa. Ka kwina chi va va wambili zumwi kakuti va vali kutite ahulu. ");
INSERT INTO sbs_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kakusasana luli mu izuva lye ntanzi lye Nsunda, kuzwa ha kuvuka, a va voneki lwe ntanzi kwa Maria Magadalena, iye ya va zwisize vadimona vena kumana iyanza ni vovele kwali. ");
INSERT INTO sbs_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Cha yenda ni ku ka wambila a vo va veena navo, ha va sina mukufwilwa ni ku lila. ");
INSERT INTO sbs_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Chi va zuwa kuti u hala mi a va li vonahazi kwali, kono kahena va va zumini. ");
INSERT INTO sbs_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mi izi zintu hazi mana ca vonahala mu mu ikalilo umwi ku vovele va vo, ha va vali ku zwa hanze ye nkanda. ");
INSERT INTO sbs_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Chi va yenda mi chi va ka wambila valutwani vakwe vonse, kono ka hena vava va zumini. ");
INSERT INTO sbs_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ku zwaho Jesu cha voneka ku vene kumi ni umwina, ha vava ku ikela ni va zimbulukite itaafule. Cha va nyansa choku saa zumina kwaabo ni ku zuminina kwe inkulo. Ka kuti ka hena vava zumini avo va va muvoni ha vuuka ku vafu. ");
INSERT INTO sbs_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Cha va wambila, “Muyende munkanda mukutaze linzwi, mu inkanda yonse. ");
INSERT INTO sbs_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Iye yo zumina mi choku kolobezwa, kahazwa, mi uzo yasazumini kahewa mulandu. ");
INSERT INTO sbs_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Izi nje zishupo zete zi yende navo va zumina: mu izina lyangu ka va zwise vadimona. Ka va wambe mu mishobo mihya. ");
INSERT INTO sbs_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Muva toole inzoka cha mayanza abo, mi ni heti ni va nywe chonse chihaya kete ni chi ve ihaye, Ka va vike mayanza he iwulu lya valwele, mi ka va hole.” ");
INSERT INTO sbs_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Simwine chinga mana ku wamba ku vali, choku hindilwa ku iwulu mi choku ke ikala ku iyanza lya malyo lye Ireeza. ");
INSERT INTO sbs_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Valutwani chi va yenda ni ku ka kutaza konse konse, mi Simwine cha tenda navo, mi ne cha kooza linzwi che imakazo zi vali kuyenda navo. ");
INSERT INTO sbs_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Vangi vachi vava liki ku vika i nswanelo lye kande lyezo indava zichi zive zuzilizwa mukati ketu, ");
INSERT INTO sbs_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","uvu vo vulyo mu vava zituheli mi avo kuzwila ku matangizo ivali impanki ni vahikana ve ñusa. ");
INSERT INTO sbs_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Cwale kwangu name ivali kuvoneka kuva hande - kuganisisa hande inzila ye indava yezo zintu kuzwila kuma tangizo - kuñola indava ye nswanelo yako iwe, Theophilus yo sepahala. ");
INSERT INTO sbs_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ili ku pangila kuti mwi zive vuniti vwezo zintu zimu va lutwa. ");
INSERT INTO sbs_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Muma zuva a Heroda, simwine wa Judeya ku vali kwina mu purisita we zina lya Zakariya, ya vali kuzwa kwi inkauhanyo ya Abija. Mwi hyavwe avali kuzwa kuvana vechi kazana va Arunì, Izina lyakwe ivali nji Elizabeta. ");
INSERT INTO sbs_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Vonse vo vele vava shieme ha vusu vwa Ireza, ku kuteka zonse intaezo za Simwine. ");
INSERT INTO sbs_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kono kana vavena mwana kakuli Elizabeta kana vena luzalo, mi hape vonse chi vava supele ahulu he iyi inako. ");
INSERT INTO sbs_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Mi kuvezi kuchita kuti Zakaria avena mukwina kwa Ireza, kwi chilila ni kupanga iyo mintendo yovu purisita yava hewa mwi nswanelo ye inkauhanyo ya kwe. ");
INSERT INTO sbs_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kuya ke chizo choku keta kuti njo zuhi mu purisita yese a tende, ava ketwa kwa loto kuti e njile mwi tempele ya Simwine kuti a hise minunkiso. ");
INSERT INTO sbs_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Chonse chichava cha vantu chiva kwete ku lapela hanze heyo inako minunkiso iva hiswa. ");
INSERT INTO sbs_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mi iñiloi lya Simwine livezi kuvoneka ha vusu vwake ni ku zimana ku vulyo vwe alutare ye minunkiso. ");
INSERT INTO sbs_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakaria ha muvona, ava tilimuki mi lyowa livezi hali. ");
INSERT INTO sbs_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kono i ñiloi chi lya ti kwali, “sanzi uvi ni lyowa, Zakaria, kakuti intapelo yako iva tekwa. Mwi hyenu Elizabeta mwa pepe mwana o mwisisu. Kamu sumpe izina lyakwe Johani. ");
INSERT INTO sbs_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ka muve ni ntabo ni kusanga, mi vangi vese va sangilile he mpepo yakwe. ");
INSERT INTO sbs_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kakuli mwave muntu mukando mu menso a Simwine. Sanzi na nywi i waine kapa zinywiwa zi kolete, mi mwe zule ni Luhuho lu Jolola ku zwilila mwi vumo li ba nyina. ");
INSERT INTO sbs_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mi vantu vangi va Isiraele kava sandulwe kwali Simwine wavo Ireza. ");
INSERT INTO sbs_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Mwa yende havusu bwe chifateho cha Simwine muluhuho ni ziho za Eliya. Mwa pange vovuti kupangila kuti a sandule inkulo za bashemi ve chikwame ku vana, ku pangila kuti vasa kuteki kava yende mu vutali vwa vantu va lukite - ku litukiseza kwa Simwine vantu valukisezwe iye. ");
INSERT INTO sbs_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakariya cha wamba kwi ñiloi, “Ni wola kuzi ziva vule izi? kakuli chili ni Mukwame yo supele mi ni mwihyetu naye cho supele ahulu. ");
INSERT INTO sbs_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mi iñiloi chila mwi taba ni ku wamba kwali, “njime Gaburiyele yo zimene mwikwina Ireza.”Nivaka tumwa ku kwiza kuwamba nawe, kukuletela aa makande ma lotu. ");
INSERT INTO sbs_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","“Cwale uvone, mo tontole, kese uwole kuwamba heisi izuva izi zintu hese nizi pangahale. Ichi nji kuti kana uva zumini manzwi angu, ese e zuzilizwe he nako i swanezi. ");
INSERT INTO sbs_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Cwale vantu vava lindile Zakariya. Vava komeketwe kakuli avali kwi kele inako ingi mwi tempele. ");
INSERT INTO sbs_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kono haka zwa mo, kana vali ku wola ku wamba navo. Chiva bonisisa kuti ava voni i pono havali kwina mwi tempele. Ava zwili ku panga zi supo kuvali na shele u tontwele. ");
INSERT INTO sbs_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ku vezi kuva kuti mazuva akwe oku tenda ha amana, cha yenda kwi nzuvo yakwe. ");
INSERT INTO sbs_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kuzwa aa mazuva, mwi hyavwe Elizabeta ava hi menzi ma hya. Avali zwisi ku vantu ka mwezi i hinda iyanza. Cha wamba, ");
INSERT INTO sbs_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Izi za vani pangili Simwine ha vani loli ni chishemo ku pangila kuti a zwise maswavisisa angu ha vusu bwa bantu.” ");
INSERT INTO sbs_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mu Mwezi we yanza ni kamwina, I ñiloi Gaburiyele liba tumwa ku zwa kwa Ireza kwi tolopo mwa Galileya i sumpwa Nazareta, ");
INSERT INTO sbs_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kwa kamwale yaba vikilizwe ku mukwame we zina lya Josefa. A vali ku wila ku luzuvo lwa Davida, kamwale izina lyakwe i vali nji Maria. ");
INSERT INTO sbs_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Cheza kwali ni kuwamba, “Lumele, iwe yo shemuvitwe ahulu, Simwine wina nawe.” ");
INSERT INTO sbs_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Kono ava lyangene ahulu cha manzwi akwe, ava hupuli kuti iwola kuva mulumelisezo nzi uwu. ");
INSERT INTO sbs_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Iñiloi chila wamba kwali, “Sanzi utiyi, Maria kakuli cho va wani chishemo ni Ireza.” ");
INSERT INTO sbs_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mi u vwene, mo pange mwana mwi vumo mi mo pepe muswisu. Mo sumpe izina lyakwe “Jesu.” ");
INSERT INTO sbs_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mwa ve mukando mi mwa sumpwe kuti Mwana wa Sikwiwulu. Simwine Ireza mwa muhe chipula chavu simwine chika zwilila ku vasikulwe vave sikulwe Davida. ");
INSERT INTO sbs_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Mwa vuse inzubo ya Jakovo kuya kwile, mi kese kuve nima mani ku muvuso wakwe. ");
INSERT INTO sbs_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria cha wamba kwi ñiloi, “Kai pangahale vule, kuvona kanini ku kopana ni mukwame?”, ");
INSERT INTO sbs_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Iñiloi chilye tava niku wamba kwali, Luhuho Lujolola ka lwize hako, miziho za Sikwiwulu ka zize hako. Cwale iye uzo yo jolola yenke yese apepwe mwa sumpwe Mwana wa Ireza. ");
INSERT INTO sbs_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mi ubwene, mukwako Elizabeta naye aba pepi mwana o muswisu mu busupali. Uwu mwezi we yanza ni konke wali, uzo yabali kusumpwa kusa pepa. ");
INSERT INTO sbs_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kakuli kakwina chese nichi sa woleki ni Ireza. ");
INSERT INTO sbs_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria chati “ubwene, ni muhikana wo mwanakazana wa Simwine.” Kuve vulyo kwangu kakuya che ñusa lyako. Mi iñiloi chilya musiya. ");
INSERT INTO sbs_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Linu Maria ava vuki mwa awo mazuba, mi cha hwelela kuya kwi nkanda ye ziwulu, kwi tolopo mwa Judeya. ");
INSERT INTO sbs_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ava yendi mwi nzuvo ya Zakariya mi chaka lumelisa Elizabeta. ");
INSERT INTO sbs_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Cwale kuva pangahali kuti Elizabeta ha zuwa mulumelisezo wa Maria, mbumbu mwi vumo lyakwe ava shili, mi Elizabeta ave zulwa Luhuho lu Jolola. ");
INSERT INTO sbs_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Cha koza inzwi lyakwe ni kuwamba kaku huwa “Iwe njo fwiyoletwe mukati kavanakazi, mi ni muselo we vumo lyako ufuyoletwe.” ");
INSERT INTO sbs_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Mi chinzi hayi va pangahali kwangu kuti vanyina va Simwine wangu va swanela kwiza kwangu? ");
INSERT INTO sbs_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mu vwene, mulumo we ntumeliso zako ha ziza ku matwi angu, mbumbu yo wina mwi vumo lyangu ava shili nche intabo. ");
INSERT INTO sbs_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mi uzo u fwiyoletwe yaba zumini kuti ka kuve ni kwizuzilizwa kwezo zintu ziva wambwa kwali ku zwilila kwa Simwine. ");
INSERT INTO sbs_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria cha wamba, “Luhuho lwangu lu temba Simwine”, ");
INSERT INTO sbs_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","mi luhuho lwangu lusanga mwe Ireza mutusi wangu. ");
INSERT INTO sbs_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Chaba loli ha mazimo avolele hansi a muhikana wakwe wo mwanakazana. Cwale mu vone, ku zwila hahanu onse masika ka a nisumpe kuti ni fwiyoletwe. ");
INSERT INTO sbs_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kakuli iye yo wina ziho chavani pangili zintu zikando mi izina lyakwe li jolola. ");
INSERT INTO sbs_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Chishemo chakwe chikalilile ku mahasi ni mahasi kwabo vamu tiya. ");
INSERT INTO sbs_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Chava tondezi ziho zakwe kache yanza: chaba hasani avo vavali kulikumuseza mihupulo ye nkulo zavo. ");
INSERT INTO sbs_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Chava soheli hansi vaana vavene simwine vechi kwame ha vuyendisi vwavo. mi chava nyamuni avo ba mazimo mavi. ");
INSERT INTO sbs_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Chave zuzi avo va fwile inzala ni zintu zilotu, kono va humite avava tumini kule niva sena chintu. ");
INSERT INTO sbs_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Chava hi intuso kwa Isiraele muhikana wakwe, kupangila ku hupula ku tondeza chishemo ");
INSERT INTO sbs_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","(mwava teli ku veshetu) kwa Aburahama niba mwi chilila kuya uko kusena mamanimani. ");
INSERT INTO sbs_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria ave kali ni Elizabeta ka miezi yo tatwe mi cha volela kwi nzuvo yakwe. ");
INSERT INTO sbs_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Hanu inako chi iva sikite ya Elizabeta kuti ahwizumuke muchiche mi ava pepi mwanaswisu. ");
INSERT INTO sbs_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Va vambene naye niva kwakwe vava zuwi kuti Simwine ava mutondenzi chishemo chakwe chikando kwali mi vava sangi naye. ");
INSERT INTO sbs_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Hanu kuvezi kupangahala he zuva li hinda iyanza ni to tatwe vava kezi njeva muchite mupato muchiche. Ni vava musumpi “Zakariya,” ku zwila izina li vesi. ");
INSERT INTO sbs_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kono va nyina chive tava ni kuwamba “Ne, mwa sumpwe Johani.” ");
INSERT INTO sbs_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Chiva wamba kwali, “kakwina yenke mukati kava mwenu yo sumpwa keli zina.” ");
INSERT INTO sbs_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Vava pangi zi supo kuvesi kupangila kuti vesi ve zive muvavali kusakila kuti a hewe izina. ");
INSERT INTO sbs_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Vesi chiba kumbila chiñolelo mi chiva ñola, “izina lyakwe nji Johani”. Vonse vava komokwa. ");
INSERT INTO sbs_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Haho vulyo kaholo kakwe kave yalulwa mi lulimi lwake luva lukululwa. Ava wambi niku lumba Ireza. ");
INSERT INTO sbs_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Lyowa livezi havo vavali kwi kala muma bali avo. Zonse izi zintu ziva twala monse mwi inkanda za ziwulu za Judeya. ");
INSERT INTO sbs_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Mi vonse vava vazuwi vava ziviki mwi nkulo zavo, kuwamba, “cwale uzu muhwile mwave chi?” Kakuli iyanza lya Simwine livena naye. ");
INSERT INTO sbs_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Vesi Zakariya ave zwile ni Luhuho lu Jolola mi cha polofita, kuwamba, ");
INSERT INTO sbs_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Simwine a lumbwe, Ireza wa Isiraele, kakuli avezi kwiza ku tusa mi ava kwanisi kuvozekezwa kwa bantu bakwe” ");
INSERT INTO sbs_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Chava tuzimikili luziya lwo kuhaza mwi nzuvo yo muhikana wakwe Davida, ");
INSERT INTO sbs_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","hava wambi cha kaholo zama polofita va jolola bakwe va vena mwi nako ya kale kale. ");
INSERT INTO sbs_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Mwa lete vu hazo vuzwilila ku zila zetu mi ni ku mayanza avo batu toyete. ");
INSERT INTO sbs_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Mwa pange vovuti ku totendeza chishemo chakwe ku veshetu mi ni ku hupula ku jolola kwe ntumelelano yakwe, ");
INSERT INTO sbs_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ku lisumina kwava wambi kwa Aburahama ishe etu. ");
INSERT INTO sbs_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ava sepisi kutuha kakuli tuba zwiswa muma yanza e zila zetu, katu mutendele niku sena lyowa, ");
INSERT INTO sbs_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","muku jolola ni muku shiama ha vusu bwake onse mazuva etu. ");
INSERT INTO sbs_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Eni, nawe, mwana, mo sumpwe mupolofita wa Isiwulu, kakuti moye ha vusu bwe chifateho cha Simwine kuli tukisa inzila zakwe, ku lukisa bantu cha kukeza kwakwe, ");
INSERT INTO sbs_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","kwiza kuha inzivo yo kuhazwa ku vantu vakwe kaku swalelwa kwa zivi zavo. ");
INSERT INTO sbs_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ichi kachi pangahale bakeñisa chishemo cha Ireza wetu, bakeñisa ke zuva lizwa kule lyese lize kuku tutusa. ");
INSERT INTO sbs_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ku venya havo ve kele mwi fifi navo vena mu munzunde we fu. Mwa pange vovuti kutondeza matende etu mwi nzila ye nkozo. ");
INSERT INTO sbs_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Hanu mwana ava kuli niku kola mu luhuho, mi avena mumu zuka heisi izuva hali vonekisa kwa Isiraele. ");
INSERT INTO sbs_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Lyahanu mwa ana mazuva, ni kweza za Ceaser Augusto na tuma sikwata ku laera kuti kuve ni cipalo ca ku vala vantu vonse mwi nkanda. ");
INSERT INTO sbs_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ichi chivali chipalo cha hentanzi chiva pangahali kwa Quirinius havali muyendisi we nkanda ya Siriya. ");
INSERT INTO sbs_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Lyahanu zimwi ni zumwi naya ku toropo yakwe ku ku ka ñolisa ku chipalo. ");
INSERT INTO sbs_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josefa naye na yenda kuzwa kwa Galileya, kuzwa ku toropo ya Nazareta. kuya kwa Judeya, kwi totopo ya Davita i va ku sumpwa Betelehema, mukunti avali ku zwilila ku luzuvo lwa Davita. ");
INSERT INTO sbs_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Na enda ko kuka liñolisa hamwina ni Mariya iye yaava veeleze avali hindite. ");
INSERT INTO sbs_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Linu ni yeza inako, havava ku sina koko, niya ba inako ya yakwe ya kuletwa kwa mucice. ");
INSERT INTO sbs_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Na leta mwana shwisu, we ntazi, cha mu vungila mu majira male, linu na mulazika muchililo che ñombe, mukuti kahena ku vena chivaka cha masikilo. ");
INSERT INTO sbs_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kuvena valisi vamitapi vavena mweco chilalo mu mumawa, vava ku lalila mitapi yavo masiku. ");
INSERT INTO sbs_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Iñeloi lya Simwine ni lyalivonahaza ku vali, ni kwava ni nkanya ya Simwine iva niya pazima kuva zimbuluka, imi vava tite tota. ");
INSERT INTO sbs_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Linu iñeloi nilya va cho kuti, musiye ku tiya, mukuti twa mi letela liinzwi i ilotu, lyete lilete ku sanga ku kando ku vantu vonse. ");
INSERT INTO sbs_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Sunu muhazi ava letwa kwenu mwi toropo ya Davida! Nji Keresite Simwine. ");
INSERT INTO sbs_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ichi nji chisupo chete nichi hewe kwenu, mu mu wane muchiche yo zingeletwe muma jira u lazikite muchililo ce ñombe. ");
INSERT INTO sbs_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Hahaho ni iñeloi ni lina ko kuvena vuungi bwe mpi izwa kwiwulu ivali ku lumbeka Ireza, ni icho, ");
INSERT INTO sbs_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Inkanya kwa Ireza mulena wa mawulu, mi kuve ni nkozo hansi mukati ka vantu va tavela.” ");
INSERT INTO sbs_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nikweza hakuti mañeloi ha a yenda kuzwa ku vali kuya kwi wulu, valisi ni vali ambila, tu yende kwa Betelehema, kuka vona ichi chintu chiva chitahali, icho chava twi zivisi Simwine. ");
INSERT INTO sbs_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Niva hwelela kwateni ni vaka wana Mariya ni Josefa, ni ku vona lukeke lu lele muchililo. ");
INSERT INTO sbs_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Haba mana kumu vona, ni ve zibahaza chi vava wambilwe ku likana nozu muhwile. ");
INSERT INTO sbs_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Vonse vava izuwi ni ba makala ku chiva wambitwe kuzwa ku balisi. ");
INSERT INTO sbs_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Kono Maliya na zwila havusu ku zeza zintu zonse za va zuwi, ku zi vika mu nkulo yakwe. ");
INSERT INTO sbs_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Balisi niva vola, ni va chenchelela ni ku lumba Ireza cha zintu zonse zi vava zuwi ni ku vona, uvu mu ku va wambilwa ku vali. ");
INSERT INTO sbs_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Hakuva kuma mani-mani e zuva li hinda iyanza ni otatwe, ha citwa mupato, na vikwa izina lwa Jesu, izina lyava hewa ku mañeloi naseni ku vumbwa mwi vumo. ");
INSERT INTO sbs_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Impalo ya mazuva ava sakahere ku kulijoloza kwavo ha i hita, kakuya cha mulao wa Mushe, Josefa ni Maliya ni va muleta kwi tempere mwa Jerusalema ku muleta havusu vwakwe kwa Simwine. ");
INSERT INTO sbs_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Muku ñolelwe mu mulawo wa Simwine, “umwi ne umwi mwana shisu wi yalula lupepo mwa vikwe kumbali kwa Simwine”. ");
INSERT INTO sbs_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Linu chivaha chitavelo chavo kakuya mukuva telwa mu mulao wa Simwine, “inkuva zovele kamba imkwilimba inini zo vele” ");
INSERT INTO sbs_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Muvone, kuvena mukwame mwa Jerusalema izina lakwe avali nji Simioni imi uzu mukwame ava shiyeme ni ku li neela. Ava lolelele muhazi wa Isiraere, imi luhuho lu jolola luvena hali. ");
INSERT INTO sbs_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Iva ungulwilwe kwali cha luhuho lujolola kuti kete na vone lufu naseni ku vona Keresite wa Simwine. ");
INSERT INTO sbs_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Che nkelelo ya luhuho, Simiyoni neza mwi tempele. Bazazi hava leta lukeke Jesu, ku mu chita cha kuya ka sico cha mulao, ");
INSERT INTO sbs_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","na mu hinda mu mavoko akwe ni ku lumbeka Ireza mi na cho, ");
INSERT INTO sbs_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Hanu u siye muhikana ko a yende mu nkozo, Simwine, chakuya cha liinzwi lyako. ");
INSERT INTO sbs_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Mukuti menso angu ava voni impuluso yako, ");
INSERT INTO sbs_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","yo va bakanyi mwi muvusu vwa vantu vonse: ");
INSERT INTO sbs_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mumuni we nsinulo kuva sa zumini ni nkanya ku vantu vako Isiraere.” ");
INSERT INTO sbs_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Vesi wa muhwile ni vanyina vava makele ka zintu ziva li ku wambiwa ku amana naye. ");
INSERT INTO sbs_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simiyoni cha va fuyola na cho kwa Mariya inyina wakwe, “Vone, uzu muhwile ketelwe kuwa ni ku vuka kwa vantu vangi mwa Isiraere imi cha chisupo chi kanitwe- ");
INSERT INTO sbs_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","mi ilumo mu li hweze mu luhuho lwako-mukuti muzezelo we nkulo zingi ku letwe he nkanza. ");
INSERT INTO sbs_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Muporofita wa mwanakazi ava ku sumpwa Anna kwavena. Avali mwana wa Fanuwelu yozwa ku mushovo wa Asha. Ava supele luli. ");
INSERT INTO sbs_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ava hali ni mwihyabwe ka zilimo zi hinda iyanza ni zovele. imi avali mufwilwa cha zilimo zina makumi a hinda iyaza ni makumi o tatwe ni zone. Kana ava ku siya itempere kono avali ku tendela cha kulinyima zilyo ni ntapelo, masiku ni kamwi. ");
INSERT INTO sbs_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Cho wo muzuzu, cheza kuvali ni kutanga kuha vuitumero kwa Ireza mi na wamba ka za muhwile ku zumwi ni zumwi yava lindile ku hazwa kwa Jerusalema. ");
INSERT INTO sbs_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Linu hava mana zonse zivavali lukela ku chita ka kuya ka mulao wa Simwine, niva vola kwa Galileya, kwi toropo yavo ya Nazareta. ");
INSERT INTO sbs_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Muhwile na kula ni kuva yo kolete, na ekeza ku vutali, ni chishemo cha Ireza chivena hakwe. ");
INSERT INTO sbs_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Vazazi vakwe vava kuyendanga chilimo ni chilimo kwa Jerusalema ku mukiti we mpaseka. ");
INSERT INTO sbs_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ha va ni zilimo zine ikumi ni zovele, hape niva yenda kuya ke nako ya chizo ku mukiti. ");
INSERT INTO sbs_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Have kala mazuva avalwa ezwile a mukiti, niva tanga ku voola ku muzi. Imi mushisu nashala mumasule mwa Jerusalema mi vazazi vakwe kena vave zivi. ");
INSERT INTO sbs_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Chiva zeza kuti wina mukati ka chikwata ca vamwi vava vali kuyenda navo, imi niva yenda lwendo lwe zuva lyonke. Linu ni va tanga ku mu lola mukati ka vakwavo ni bamwakwe. ");
INSERT INTO sbs_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Hava mu vula, niva vola kwa Jerusalema ni ku tanga kumu lola kwateni. ");
INSERT INTO sbs_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nikwahi ta mazuva otatwe, chi va muwana mwi tempere, ne kele mukati ka muruti, nava tekete ni kuva vuza impuzo. ");
INSERT INTO sbs_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Vonse vava zuwi ku amana naye ni va makala ha ku zuwisisa kwakwe ni nkalabo za kwe. ");
INSERT INTO sbs_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Havu muvona, ni va makala. Vanyina ni vawamba kwali, “Mwanangu, cinzi hawatu cita vuti? Teke, veso neme tuva ku ku saka saka.” ");
INSERT INTO sbs_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nati kuvali, “Cinzi hamu kwete kuni saka? kana muvezivi kuti ni lukela kuva munzuvo ivandanda?” ");
INSERT INTO sbs_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kono kena vava zuwisisi cha va talusi chawo manzwi. ");
INSERT INTO sbs_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Imi chayenda kuvola kumunzi navo kwa Nazareta ni kuli voza hansi ku vali. Banyina ni va ungula izi zintu zonse munkulo yavo. ");
INSERT INTO sbs_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Linu Jesu na zwila havusu ku kula cha vutali ni ku wera ku chiyemo, ni wera ku chishemo ni Ireza ni vantu. ");
INSERT INTO sbs_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Muchilimo che ikumi ni iyanza cho mubuso wa Tiberiasi Sisare- chikwina bulyo Pontiusi Pilato abali mubusi wa Judeya, Heroda ibali muyendisi wa Galileya, mwanchakwe Filipe abali kuyendisa chikiliti cha Ituria ni Trakoniyisi, mi Lisaniasi abali kuyendisa chikiliti cha Abilene, ");
INSERT INTO sbs_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","mwi nako ya vuvusi vwa muprisita mukulwana yo hanzi Ananiasi ni Kaishala-inzwi lye Ireeza ni lyeza kwa Johani mwana Zakaria, mwi ikanda. ");
INSERT INTO sbs_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Aba yendi mu zikiliti zonse zi zimbulukite Jorodani, ku kutaza i nkolobezo ya ku baka ya kuwondela zibi. ");
INSERT INTO sbs_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Sina mukuñolelwe mwi mvuka ya manzwi a Isaya mupolofita, “Inzwi lya yenke lisumpa mwi ikaanda, 'Mu vakanye i nzila ya Simwine, mu wolole inzila zakwe. ");
INSERT INTO sbs_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Mikokolombwa yonse mu izuzwe, mi ilundu ni chi ulu mu zi bozekezwe hansi, ni inzila zi nyonokete muzi wololwe, ni zi baka zisa shiyeme muzi zakwe mu migwagwa, ");
INSERT INTO sbs_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","mi inyama zonse muzi bone kuhaza kwe Ireeza.” ");
INSERT INTO sbs_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Linu Johani na wamba ku vantu vangi vavali kwiza kuku kolobezwa kwali, “Inwe muvaana va zihili! Njeni yava mi mamelisi kutiya ku vukali vukezite? ");
INSERT INTO sbs_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Linu he, muvike zilyantu ziswanele ku vaaka, mi kanji muti mukati kenu, 'Twina Abrahama che sheetu,' ni miwambile kuti Ireeza uwola ku busa baana ba Abrahama mwa a mavwe. ");
INSERT INTO sbs_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nanga hanu ibbeule li bakanyezwe muhiisi wa masamu. Mu kuti i samu lyonse lisahi zilyantu zi lotu mulitemenwe hansi ni ku sohelwa mu mulilo.” ");
INSERT INTO sbs_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","vungi vungi vwa vantu ni va tanga kumubuza, ni vacho, “Linu aha tuchita vule?” ");
INSERT INTO sbs_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Chetaava nikuti kuvali, “Chikuti muntu wina zizwato zo beele, ali kauhanyeze ni ya sena, nozuna wina zilyo naye achite cho kuswana.” ");
INSERT INTO sbs_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Va kunganyi ba mali naabo niveza kuku kolobezwa, mi ni kucho kwali, “Muruti, chinzi chitu lukela kuchita?” ");
INSERT INTO sbs_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Na wamba kwavo, “kanji mukunganyi mali mangii kuhitiliza amwa laelwa ku kunganya.” ");
INSERT INTO sbs_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Vamwi masole navo chiva muvuza, ni va cho, “Mi linu iswe vule? Tu swanela ku chita nzi?” Na wamba kubali, “kanji muhindi mali kuyense muntu cha kuhambiliza, imi kanji munyansi muntu cha mafosisa. mulikolwisise kache ntuwelo zenu.” ");
INSERT INTO sbs_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Linu vantu hanu hachivava lindile che ntakazo kwiza kwa Kiriste, zumwi no zumwi avali komokelwe mwi nkulo zavo ku amana ni Johani mukuti pona chova njeye Kireste. ");
INSERT INTO sbs_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Johani ne taava cha kuwamba kuvali vonse, “Ka changu, Ni mikolobeza ni menzi, kono zumwi ukezite yokolete tota hita Ime, mi Ime kani swaneli ni ku sumununa mihala ye nsangu zakwe. Mwa mi kolobeze cha Luhuho lu Jolola ni cha mulilo. ");
INSERT INTO sbs_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Chi damiso cha kwe cha haluvuwa cina mwi yanza lyakwe ku joloza luli lu vuwa lwa kwe ni ku kunganya mahila mu chishete cha kwe. Kono mwa hise buhundu ni mulilo usa zimwa.” ");
INSERT INTO sbs_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ni manzwi mangi a mwi e nsusuwezo hape, Johani na kutaza ivañeli indotu kuvantu. ");
INSERT INTO sbs_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Mi Heroda mubusi ha nyanswa cha kusesa mwihyavwe wa mwa nce, Herodiasi, mi ni cha zonse zivi zintu Heroda za vapangi, ");
INSERT INTO sbs_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ava weli izi kumi landu yakwe: ne yalila Johani mwi ntolongo. ");
INSERT INTO sbs_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Linu nikwa va kuti, vantu vonse chivavali kukolovezwe, Jesu naye ava kolovezwe. mi haho havali ku lapela, mawulu niye yaluka, ");
INSERT INTO sbs_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Mi Luhuho Lujolola mu chi vumbantu cha vuntu ni lweza cha ku shulumuka hali ubu inkuva, mi inzwi nilya zwa mwi ulu, “U mwanangu wa muswisu, uni saka, Ni kondetwa ka chako.” ");
INSERT INTO sbs_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesu hatanga ni luko lyakwe, avali kulichunza ku zi limo za makumi otatwe. Ivali mwana (sina muinuhelelwe) wa Josefa, mwana wa Heli, ");
INSERT INTO sbs_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","mwana wa Matihati, mwana wa Levi, mwana wa Meluchi, mwana wa Janai, mwana wa Josefa. ");
INSERT INTO sbs_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josefa ivali mwana wa Matatiasi, mwana wa Amosi, mwana wa Nahum, mwana wa Esili, mwana wa Nagayi, ");
INSERT INTO sbs_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","mwana wa Mati, mwana wa Matatiasi, mwana wa Seimini, mwana wa Josechi, mwana wa Joda. ");
INSERT INTO sbs_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda ivali mwana wa Joanani, mwana wa Rhesa, mwana wa Zerubabeli, mwana wa Salietele, mwana wa Neri, ");
INSERT INTO sbs_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","mwana wa Meluchi, mwana wa Adi, mwana wa Kosamu, mwana wa Elumadamu, mwana wa Eri, ");
INSERT INTO sbs_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","mwana wa Joshuwa, mwana wa Elieze, mwana wa Jorimu, mwana wa Matihati, mwana wa Levi. ");
INSERT INTO sbs_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi ivali mwana wa Simioni, mwana wa Juda, mwana wa Josefa, mwana wa Jonamu, mwana wa Eliakimu, ");
INSERT INTO sbs_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","mwana wa Melea, mwana wa Mena, mwana wa Mattata, mwana wa Natani, mwana wa Dafita, ");
INSERT INTO sbs_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","mwana wa Jese, mwana wa Obedi, mwana wa Bowazi, mwana wa Salumoni, mwana wa Nahashoni. ");
INSERT INTO sbs_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahashoni ivali mwana wa Aminadabu, mwana wa Adimini, mwana wa Arini, mwana wa Hezironi, mwana wa Perezi, mwana wa Juda, ");
INSERT INTO sbs_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","mwana wa Jakobo, mwana wa Isaka, mwana wa Aburahama, mwana wa Tera, mwana wa Nahori, ");
INSERT INTO sbs_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","mwana wa Serugi, mwana wa Rewu, mwana wa Pelegi, mwana wa Eberi, mwana wa Shelahi. ");
INSERT INTO sbs_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shelahi ivali mwana wa Kainani, mwana wa afakisadi, mwana wa shemu, mwana wa Nowa, mwana wa Lameki, ");
INSERT INTO sbs_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","mwana wa Metusela, mwana wa Enoki, mwana wa Jaredi, mwana wa Mahalalelu, mwana wa Kainani, ");
INSERT INTO sbs_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","mwana wa Enosi, mwana wa Sethi, mwana wa Adama, mwana we Ireeza. ");
INSERT INTO sbs_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Linu Jesu, chokwi zula Luhuho Lujolola, hakazwa kulwizi lwa Jodani, mi ava yendiswe Luhuho mwi halaupa. ");
INSERT INTO sbs_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","havena mazuva ena makumi one nalikiwa kwa javulusi. Kakwina cha va lile mwao mazuva, mi kuma manisilizo eyo inako chava fwile inzala. ");
INSERT INTO sbs_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Javulusi cha wamba kwali, “Haiva u Mwana we Ireza, ulaele ilibwe ive chinkwa.” ");
INSERT INTO sbs_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesu cha mwitava, “Kuñoletwe, Muntu kahali vulyo ha chinkwa.” ");
INSERT INTO sbs_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Linu javulusi cha mutwala ha chivaka chile, ni ku mutondeza mivuso yonse ye inkanda hohwaho vulyo. ");
INSERT INTO sbs_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Javulusi cha wamba kwali, “Ka ni kuhe vuyendisi bwe inkanda ni vulotu vonse, kakuti zivahewa kwangu, mi ni wola kuziha yense unisaka. ");
INSERT INTO sbs_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","haiva chiwani kuvamela ni kuni kunkwila muive yako.” ");
INSERT INTO sbs_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesu che tava cha muti, Kuñoletwe, mo kunkwile Simwine Ireza, mi hape mo mutendele yenke.” ");
INSERT INTO sbs_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Linu javulusi cheza kutwala Jesu mwa Jerusalema niku muvika ha chivaka chichilelele cha muzako we tempele, mi chati kwali, “Heiva u Mwana we Ireza, lisohele hansi kuzwa hanu. ");
INSERT INTO sbs_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","“Kakuti ku ñoletwe, mwa laele ma ñiloi akwe, a amana niwe, aku vukeleze, ");
INSERT INTO sbs_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","mi hape, 'Ka akunyemune muma yanza ao, kuti kenzu u chunchuli itende lyako hebwe.”' ");
INSERT INTO sbs_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Kuku mwitava, Jesu chati, “Ku wambitwe, 'Kenzu viki Simwine Ireza wako hakulikwa.”' ");
INSERT INTO sbs_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Cwale javulusi ha mana kulika Jesu, cheza ku musiya ni kuyenda haisi imwi inako. ");
INSERT INTO sbs_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Linu Jesu havola mwa Galilea muziho zo Luhuho, indava zi amana naye chize zulankana ku zimbuluka chikiliti chonse. ");
INSERT INTO sbs_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Mi chatanga ku luta mu ma sinagoge avo mi vonse chi va mutemba. ");
INSERT INTO sbs_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Cha keza mwa Nazareta, mwi tolopo mwa va kulili, mi sina ha i vali chizo chakwe, cheza mu ma sinagoge i va li zuva lya la Mugivelo, sina ha i vali chizo, cha zima ni ku vala cha ku huweleza. ");
INSERT INTO sbs_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Imbuka ya mupolofita Isaya iva hewa kwali, che yalula imbuka ni kuwana chi vaka hai va ñoletwe, ");
INSERT INTO sbs_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Luhuho lwa Simwene lwina hangu, kakuti a vani singi ku wamba makande malotu ku va shevete. A va ni tumi ku nkonkelza intukuluho ku va suminwe, ku lukulula va lyatililwe, mi ni ku vo zekeza ku vona ku va sa voni, ");
INSERT INTO sbs_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ni ku konkeleza chi limo cha Simwine che nshemuvo.” ");
INSERT INTO sbs_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Che yala imbuka, ni ku i voza ku ya vali muvavaleli ne kala hansi. Menso a vonse va vena mu ma sinagoge a va lolete vulyo hali. ");
INSERT INTO sbs_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Chatanga ku wamba ku vali, “Sunu i intimana chi ye zuzilikizwa ni mu zuwile.” ");
INSERT INTO sbs_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Vonse mwateni chi va va paka ku zavali ku wamba mi chiva komokiswa cha manzwi e zwile chishemo avali ku zwa mukaholo kakwe. Va vali ku wamba, “Uzu mwana Josefa wa muswisu, nandi kanjeye?” ");
INSERT INTO sbs_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Cha wamba ku vali, “Cheniti ka muwambe iyi inguli kwangu, 'Iñanga, lihoze u mwine. Zonse zitu va zuwi zo va pangi mwa Kapenaumi, pange zi swana ni mu munzi we tolopo yako.”' ");
INSERT INTO sbs_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Kono cha wamba, “Ni mi wa mbila vu niti kakwina mupolofita yo tambulwa mwi tolopo munzi we tolopo yakwe. ");
INSERT INTO sbs_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kono mu vuniti ni mi wambila ku vena vafwililwe vangi mwa Isilaele mwinako ya Eliya, i wulu hali ve yalite zilimo zotatwe ni myezi i ma na iyanza ni chonke, chi kweza inanga ikando mu chi vaka chonse. ");
INSERT INTO sbs_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","kono Eliya kena ava tumwa nanga ku umwina wavo, konji kwa Zarefasi mwa Sidoni, ku yo fwililwe ya vali kwi kala mwateni. ");
INSERT INTO sbs_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kuvali kwina ve mbingwa vangi mwa Isilaele mwi nako ya Elisha mupolofita, kono ka kwina kuvali ya va hozwa kwande ya Namani mwina Siriya.” ");
INSERT INTO sbs_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Vonse vantu va vena mu ma sinagoge chi ve zula kuvenga hava zuwa izi zintu. ");
INSERT INTO sbs_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Chiva zimana, ni ku mu hambiliza kuzwa mwi tolopo. Chiva muhitisa ku mu vika ku impela ya chiwulu hava za kitwe itolopo yavo, kuti va musohele he impela ya chiwulu. ");
INSERT INTO sbs_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kono cha va hita hakati kavo mi chaya ku chimwi chi vaka. ");
INSERT INTO sbs_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Linu cha na sezumukela mwa Kapenaumi, mwi tolopo ya Galileya, mi ava tangi kuva luta ivali la Mugivelo. ");
INSERT INTO sbs_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Va va komokiswa mulutilo wakwe, kakuti ava wambi ni vuyendisi. ");
INSERT INTO sbs_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Hanu mu masinagoge ku vena mukwame ya vena i dimona-luhuho lusajololi, mi chahuweleza ahulu cha linzwi. ");
INSERT INTO sbs_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Mawe! tuswanela kupanganzi nawe, Jesu wa Nazareta? Wakeza ku ku tusinyasinya? Ni kwizi kuti njiweni- Yenke yo Jolola wa Ireza.” ");
INSERT INTO sbs_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesu cha kalimela i dimona, chikuti, “Kenzu wambi zwe mukati kakwe!” Cwale aho i dimona li va soheli mukwame hansi mukati kavo, chilyazwa mukati kakwe, mi kena liva muholofazi ni hakuva vulyo. ");
INSERT INTO sbs_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Vantu vonse va va komokwa ahulu, chi va zwila havusu ku wamba zateni zumwi ku zumwi. Chivati, “Kanti manzwi amushovo nzi aa? U laela luhuho lusajololi che nkamaiso ni ziho mi zi zwa.” ");
INSERT INTO sbs_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Linu makande aa amana naye chi atanga kwi zivankana zivaka ku zimbuluka chikiliti. ");
INSERT INTO sbs_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Linu Jesu chazwa mu ma sinagoge ni kwinjila munzuvo ya Simoni. Hanu makwenyani va Simoni va chanakazi va vakatezwe vutuku bwa kuhisa muvili (isinza), mi chiva mu kumbila cha kuli kombeleza kachakwe. ");
INSERT INTO sbs_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Linu chazima hali ni ku kalimela isinza, mi nilya musiya. Haho vulyo cha zimana ni kutanga ku vatendela. ");
INSERT INTO sbs_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Izuva ha limina, vantu chivaleta vonse va vali kulwala matuku avali ku chinchana chinchana kwa Jesu. Chavika mayanza akwe havali vonse ni kuva hoza. ");
INSERT INTO sbs_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Madimona nao chiazwa muvantu vangi, ni a lila kuhuwa mi nati, “Njewe Mwana we Ireza!” Jesu cha kalimela madimona, mi kena ava azuminini ku wamba, kakuti a vezi kuti ivali nji Kirisite. ");
INSERT INTO sbs_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Izuva haliza ku zwa, chazwa ni kuya ku chivaka chili patite. Chisi cha vantu chi vali kumu lola chi cheza ku chi vaka kwavena. Chi va lika ku mukanisa kuti kanzi azwi havali. ");
INSERT INTO sbs_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kono chati kuvali, ni swanela ku wamba makande malotu omu muvuso we Ireza ku matolopo mangi, kakuti njivaka hani ni vaka tumwa kunu. ");
INSERT INTO sbs_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Linu cha zwila havusu ku kutaza mu ma sinagoge mane konse kwa Judeya. ");
INSERT INTO sbs_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Linu chikwa chitahala, Mukuti vantu vava kungeene kuzimbuluka Jesu ni kutekeleza linzwi lye Ireza, mi avali kuzimene he iyambezi lya Geneserate. ");
INSERT INTO sbs_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Chavona mato ovele ni avakwitilwe he rizo lye iyambezi. bayambi civava kuzwile mwa teni mi vava kwete kushanza tunyandi twavo. ");
INSERT INTO sbs_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesu chechira muvumwi bwato, vuvali bwa Simone, chamucho kuti avusikule chivakazana kuzwa ha hamutunda. Chekala hansi ni ku luta vantu nena mubwato. ");
INSERT INTO sbs_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Hamana kuwamba, cha wamba kwa Simone, “Twale bwato mumenzi male mi musohele tunyandi muchese.” ");
INSERT INTO sbs_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simone chetaba ni kucho “Simwine twatenda masiku onse, kakwina chitwa chesa, kono cha linzwi lyako, munisohele tunyandi.” ");
INSERT INTO sbs_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Hava chita bulyo, chiva kunganya impalo ingi ye nswi, mane tunyandi twavo tuva kuhaloka. ");
INSERT INTO sbs_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","chibawambila ba mwavo mubwato bumwi kuti beze zeba vava tuse. Chiveza ni kwizuza mato onse ovele, linu niva tanga kumina. ");
INSERT INTO sbs_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kono Simone Pitorosi, havona vulyo, cha wa cha mazwi a Jesu chati, “Zwe kwangu kakuti ni muntu ni muvi, Simwine.” ");
INSERT INTO sbs_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kakuti avakomoketwe, mane nivonse vavali kwina naye, haku cheswa kwe nswi zivava hindi. ");
INSERT INTO sbs_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Aha kuva kwina Jakovo ni Johani, vavali vaanaswisu va Zevedia vavali kusevelisana ni Simone. Mi Jesu chati kwa Simone “Kanji utiyi, kakuti kuzwa hanu mo mochese vantu.” ");
INSERT INTO sbs_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Haba leta mato avo hansi, civa siya zintu zonse niku mwi chilila. ");
INSERT INTO sbs_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Hakuva kuti avali kwina imwi toropo, mukwame yabezwile vutuku bwe mbingwa mwavena. Havona Jesu, cha wa cha chifateho ni ku mukumbila, nacho, “Simwine, haiva usaka uwola kuni joloza.” ");
INSERT INTO sbs_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","mi Jesu cha wolola iyanza lyakwe nikumu kwata, nawamba, “Nisaka jolole.” mi haho bulyo imbingwa yakwe chiya zwa kwali. ");
INSERT INTO sbs_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Cha mulaela kuti sanzi awambili muntu, kono cha mucho kuti, “Liyendeze, mi ukalivonahaze kuba purisita mi ukatambike chitabelo cha ku jolozwa kwako, kuya ke taelo ya Mushe, ive vushupi kubali.” ");
INSERT INTO sbs_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Kono ikande liamana naye chi lya yenda iñuwa, mi vungi bwa vantu chiva keza hamwina kwiza kumuzuwa na luta, mane nikuhozwa matuku abo. ");
INSERT INTO sbs_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kono inako ni inako cha zwa nikuya muzivaka zili mumatongo nikuka lapela. ");
INSERT INTO sbs_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Chikwa sika limwi zuva mwawo mazuva lyava kwete kuluta, mi kuvali kwina Mafarisi ni valuti va mulao vavali kwi kele mwateni kuzwila muminzi mingi ichinchana muzikiliti za Galileya ni Judeya, mane ni mwi tolopo ya Jerusalema. Ziho za Simwine zivali kwina naye za kuhoza. ");
INSERT INTO sbs_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Lyahanu vamwi vakwame chivakeza, vavali kuhindite muntu yo lwala vutuku bwaku zuminina ha vulo, vavali kusaka mahitilo a kumwinjilika mukati ni kuka mulalika havusu bwa Jesu. ");
INSERT INTO sbs_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kana vavali kuwola kuwana mahitilo o kumwinjilika mukati chevaka lya vantu vangi, linu chiva ya hewulu lya chituwa ni ku sezumwina mukwame hateni, havulo bwakwe, mukati ka vantu, hene havusu bwa Jesu. ");
INSERT INTO sbs_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Chakuvona kuzumina kwavo, Jesu chati, “mukwame, zivi zako chiza swalelwa we.” ");
INSERT INTO sbs_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Va ñoli ni ma Farisi chivatanga kuli vuza ichi, nivati, “Njeni uzu yo wamba cha kunyansiliza? Njeni yowola kuswalela vuvi konji Ireza yeyena?” ");
INSERT INTO sbs_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kono Jesu, chalemuha zivavali kuhupula, chetava nikuwamba kuvali, “Chinzi hamukwete kuli vuza vulyo mwinkulo zenu, ");
INSERT INTO sbs_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Njechihi chihuva kukuwamba, 'Zibi zako chiza swalelwa,' nikuta kuti 'zimane uyende?' ");
INSERT INTO sbs_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kono kuti mwizive kuti Mwana Muntu wina inkamaiso zakuswalela zivi hansi, Ni wamba kwako, zimane, 'Hinde vulo bwako mi uyende kwinzuvo yako.'” ");
INSERT INTO sbs_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Haho vulyo cha zimana havusu bwavo ni kunyemuna vulo hava lele. Chavola kwinzuvo yakwe, nakavu kuchenchelela Ireza. ");
INSERT INTO sbs_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Vonse vavakomoketwe niku chenchelela Ireza. Vave zwile kutiya, ni vati “Twavona zintu zihitilize sunu.” ");
INSERT INTO sbs_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Hakumana kupangahala izi zintu, Jesu cha zwa mwateni umo mi avavoni Mutelisi we zina lya Levi nekele mwi tente lya kutambwila mitelo. Chamuta kuti, “Ni chilile.” ");
INSERT INTO sbs_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Linu Levi cha zimana ni kumwi chilila, kusiya zintu zonse kuma sule. ");
INSERT INTO sbs_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Linu Levi cha ha Jesu zilyo zingi munzuvo yakwe. Muvali kwina vatelisi vangi mwateni ni vantu vamwi vavali shamine he ntafule mi niva kwete kulya navo. ");
INSERT INTO sbs_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kono Vafarisi ni va ñoli vavo vavakwete kuvilela kuvalutwana vakwe, “chivati, Chinzi hamulya ni kunywa niva telisi niva vantu vachita vuvi?” ");
INSERT INTO sbs_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesu cha vetava, “Vantu vasa lwali kavasaki musiliki, konji balwala nji musaka. ");
INSERT INTO sbs_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kena nivakezili kusumpa vantu vashiyeme kuku vaka, kono kusumpa vachita zivi ku ku vaka. ");
INSERT INTO sbs_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Chivawamba kwali, “inako ni nako, valutwana va Johani valinyimanga zilyo niku lapela, ni ba lutwana vava Falisi vachita vulyo navo, kono va lutwana vako valya niku nywa.” ");
INSERT INTO sbs_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesu chawamba kuvali, “Kana kwina yo wola kuwambila vena hamukiti wa musesi kuti vali nyime zilyo musesi nasina navo?” ");
INSERT INTO sbs_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kono mazuva akeza hete nazwiswe kuvali musesi, mi aho kavali nyime zilyo.” ");
INSERT INTO sbs_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Linu Jesu cha wamba che huko kuvali. “Kakwina muntu yohalula isila hachizwato chihya niku lukila hesila ikulukulu. Mi hachita vulyo, mwahalule chizwato chihya, mi kasila kazwa ha chizwato chihya kete kaswanele ha chizwato chikulukulu. ");
INSERT INTO sbs_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kakwina yo vika i waine ihya muzivikiro ze waine ze dalo chikulukulu. Mi hachita vulyo i wine ihya muiñatule madalo, Mi iwaine muitike. Mi zivikilo ze wine ze dalo muziñatuke. ");
INSERT INTO sbs_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kono i waine ihya iswanela kubikwa muzibikilo zedalo ziteketeke. ");
INSERT INTO sbs_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Mi kakwina yo chita kuti hamana kunywa iwaine yakale yosaka ihya, kakuti ucho kuti, “Yakale ina butuka.” ");
INSERT INTO sbs_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","chikwachitahala kuti ivali lwe Nsabata, mi Jesu avali kuhita muluwa lwa buheke, mi balutiwa vakwe vavali kwa vutola mitwi ya vuheke ni kulya vuheke. ");
INSERT INTO sbs_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mi vamwi vava Falisi chivawamba kuti. “Chinzi ho chita chisa swaneli kuchitwa luzuva lwe nsavata?” ");
INSERT INTO sbs_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Cha kumwitava, Jesu chetava kuti, “kena muvavali chava chiti Davida ha va fwile inzala, iye ni vakwame vavena navo? ");
INSERT INTO sbs_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","avayendi mwi nzuvo ye Ireza, avahindi inkonko ivavikitwe muchivaka che Ireza, ni kulya imwi mwateni, nikuhinda imwi chikuha kwateni mane nivavali kwina naye kuti valye kwateni, nihakuva vulyo zivali kuswanelwa kuliwa va Purisita ka mulao”, ");
INSERT INTO sbs_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Chata kuti mwana muntu simwine mane ni wale Nsavata. ");
INSERT INTO sbs_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","chikwa chitahala kuti lwensavata lumwi cheza mu ma Sinagoge nikuka luta vantu mwateni, Mukwame mwavali kwina mwateni yavali kwina iyanza lyakwe lyachilyo livanyonyovete. ");
INSERT INTO sbs_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Va ñoli niva Falisi vavali kumulolete chentokomelo kuvona kapa mwahoze muntu lwensavata, kuchitila kuti vawane vushupi bwakumu sumina indava. ");
INSERT INTO sbs_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Avezivi zivavali kuhupula, mi chata mukwame yavena iyanza linyonyovele, “Zimane wize aha vakuvone vantu vonse,” Mi mukwame cha zimana haho. ");
INSERT INTO sbs_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesu cha wamba, “nimivuza, kana kuzumininwe kuchita vulotu kapa siya zintu lwe Nsavata? Ku chita vuhalo kapa kuvusiya. ");
INSERT INTO sbs_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Linu chava lola vonse niku wamba kuyo lwala, “Wolole iyanza lyako” chachita vulyo mi iyanza lyakwe chilya va hande. ");
INSERT INTO sbs_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kono vavezwile kuvenge mane chivatanga kuli wambila mwete vachitile kaha Jesu. ");
INSERT INTO sbs_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Chikwachitahala kuti mwao mazuva cha yenda kuma lundu nikuka lapela. cha zwila havusu niku lapepa masiku onse kwe Ireza. Haiva ");
INSERT INTO sbs_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","musihali, cha sumpa valutiwa vakwe, nikuketa vena makumi nivi vele, vava sumpi va Apostola. ");
INSERT INTO sbs_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Mazina ava Apositola ivali nji Simon (wava sumpi Pitorosi), ni mwance, Andulu, Jakovo ni Johani, Filipi, Bartholome, ");
INSERT INTO sbs_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateu, Tomasi, Jakovo mwana wa Alufeya, Simone yavali kusupwa Zealote, ");
INSERT INTO sbs_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas mwana Jacobo, Ni Judasi Isikariyote, yava vi muveteki. ");
INSERT INTO sbs_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Linu Jesu chakav0la navo kuzwa he lundu navo, cheza kuzimana ha pateme ni chikwata cha valuti vakwe ni vantu vangi vavali kuzwila kwa Judeya, ni Jerusalema ni Tire ni Sidoni. ");
INSERT INTO sbs_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Vavakezi kwiza kuteka kwali ni kwiza kuhozwa matuku avo onse. Vantu vavali kukatazwa luhuho luvi vava hozwa navo. ");
INSERT INTO sbs_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Vantu vonse vavena muchisi vava kulika kumu kwata kakuti ziho zakuhoza zivali kuzwa kwali, mi avava hozi vonse. ");
INSERT INTO sbs_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Chalola kuva lutiwa vakwe, nikuti, mwina imbuyoti inwe musena chenu, kakuti chenu muvuso wa kwi wilu we Ireza. ");
INSERT INTO sbs_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Imbuyoti njiyenu mufwa inzala hanu, kakuti kamwi kutiswe. mufuyaulitwe inwe mulila hanu kakuti kamu seke. ");
INSERT INTO sbs_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","mwina imbuyoti vantu hava mi toya, havasamivali ni kumi tukola, chevaka lya mwana a muntu. ");
INSERT INTO sbs_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mutabe mwelina izuva mi mulotoke che ntavo. Kakuti kamuve ni mupuzo mukando mwi wulu. Kakuti vakukwavo muvava chitili va Polofita vamwi mwinzila iswana. ");
INSERT INTO sbs_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kono woo kwenu mufumite, kakuti chiva tambuli inkavelo yenu. ");
INSERT INTO sbs_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Woo kwenu mwi kusi hanu kakuti kamu fwenzala mazuva akeza. Woo kwenu museka hanu, kakuti kamulile ni kuswava kuvusu. ");
INSERT INTO sbs_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","woo kwenu vantu hava mitemba, kakuti muvava chitili kuva Polofita va mapa. ");
INSERT INTO sbs_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Kono niwamba kwenu mutekeleze, musake zila zenu mane muchite hande vami toyete. ");
INSERT INTO sbs_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","mufuyole vami kuta mi mufuyole vaminyandisa. ");
INSERT INTO sbs_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Yokuwopa kulimi tama, mumu he ni limwi a wope kwateni. Haiva zumwi nahinda chi Jansi chako, muhe ni vulukwe. ");
INSERT INTO sbs_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","He kuvonse vakumbila. haiva zumwi nahinda chintu kwako, Zanzi umuwambili kuti achivize. ");
INSERT INTO sbs_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mosakila kuti vantu vaku chitile, upange vulyo kuvantu. ");
INSERT INTO sbs_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Haiva usaka vulyo vakusaka, cho wana mwateni iwe chinzi. Ni vaezalivi vasaka vava ");
INSERT INTO sbs_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","saka. Haiva uchita vulotu kuvaku chita hande, cho volelwa chi? esi ni va ezalivi vachita ziswana, ");
INSERT INTO sbs_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","linu ho kalima vulyo vana vowizi kuti vawola kuku vozekeza, chovolelwa chi, niva eza livi vakolotisa va eza livi kuti vavolelwe zi swana. ");
INSERT INTO sbs_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kono usake zila zako mi uvachite hande. Kolotise nosalindili kutambula chimwi mi mupuzo wako kauve mi kamuve mu vaana va Simwine mukandomukando kakuti iye ushiyeme kuvali tumuli niku vantu vavi. ");
INSERT INTO sbs_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Muve ni chisemo kakuti ishenu wina chisemo. ");
INSERT INTO sbs_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Sanzi u atuli, mi nawe kete u atulwe. Sanzi unyazi mi nawe kete unyaswe. Swalele, mi nawe ko swalelwe. ");
INSERT INTO sbs_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Uhe nawe ko hewe. cha vungi luti, vukakatele, zinyungitwe hamwina, niku hasanywa, kasi tikile muchivikilo chako. kakuti vulemi votendesa, muvuseveliswe kwako. ");
INSERT INTO sbs_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","linu chaba wambila linu ihuko. “kana muntu yasa voni uwola ku etelela zumwi yasa voni? Haiva nachita vulyo, vuvele bwavo muva wile mwi lindi. kapa kaku oleki? ");
INSERT INTO sbs_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mulutiwa kena muku lwana ku muluti wakwe, kono zumwi ni zumwi hamana ku lutiwa chakwizula, uswana ni muluti wakwe. ");
INSERT INTO sbs_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Chinzi holola haka chiti kanini kena mulinso lya mwako, Mi kolemuhi chikando chikutoweze. ");
INSERT INTO sbs_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","U wola kw u wamba vule kwa mwako, mwangu nikuzwise chikutoweze, mi nikwina kuti iwe umwine kovonwe chikutoweze mulinso lyako. Inwe mulihele, Tange pili uzwise chikutoweze mulinso lyako, mi mo wole kuvona hande, linu njete uwole kuzwisa china mulinso lya mwako. ");
INSERT INTO sbs_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","kakuti kakwina isamu ilotu livika zihantu zi volete, nandi isamu livolete kaliwoli kuvika zihantu zi lotu. ");
INSERT INTO sbs_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Isamu ni isamu lizivahala cha zihanto lyalyo lili vika. Vantu kavawoli kukunganya ma Feiga kwi samu lya miya, kapa manjembere kuzi chachani. ");
INSERT INTO sbs_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Muntu mulotu kuzwilila kuvulotu bwa vuhumi bwina mwinkulo yakwe, uzwisa vulotu, ni muntu muvi ku zwilila ku vuhumi bwa vuvi bwina mwinkulo yakwe, uswisa sivi, kuzwilila ku vuhumi bwina mwinkulo yakwe muntu, uzwisa mwinkulo yakwe cha kaholo. ");
INSERT INTO sbs_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Chinzi hamuni sumpa kuti simwine simwinwe, kono kamu mameli zini mi wambila. ");
INSERT INTO sbs_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Muntu ni muntu wiza kwangu ni ku zuwa manzi angu ni kua mamela. Muni mi wambile mwe kalile. ");
INSERT INTO sbs_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ukola sina muntu yo zaka inzuvo, ya va shii chaku tunga mwivu, ni kuzaka musumo we nzuvo hebwe likolete. Mi muunda haukeza, ni menzi mangi kuvuvila he mota lyenzuvo, Kono kana abai nyanganisi, kakuti iva zakwa hande. ");
INSERT INTO sbs_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kono muntu yo zuwa manzi angu kono ka amameli, ukola sina muntu yo zaka inzuvo yakwe he wulu lyevu kusena musumo. Mi menzi ha vuvila he nzuvo, chiya wa kapilpili, Mi kusinyeha kwe nzuvo kuva mani. ");
INSERT INTO sbs_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Kuzwa Jesu hamana zonse zabali kuwamba bantu nibazuwile, nakenjila mwaKapenauma. ");
INSERT INTO sbs_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Linu muyenzi wachisole abena muhikana yabali kusunwa hahulu kwali, mi abali kulwala ni kusaka kufwa. ");
INSERT INTO sbs_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Muyenzi wachisole nanga zuwa za Jesu, natumina kwali bakulwana ba Majuda, kumukumbila kuti eze njamuhozeze muhikana wakwe. ");
INSERT INTO sbs_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Habati chibasika kwa Jesu, ni bamukumbila chakukakanina, ni bati, “Uyelele kuti umutendele bulyo, ");
INSERT INTO sbs_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","mukuti usaka chisi chetu, imi njabatuzakili masinagoge etu.” ");
INSERT INTO sbs_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Chobulyo Jesu nazwila habusu munzila yakwe nabo. Hati chotumbatumba henzuvo, muyezi wachisole abatumini balikani bakwe kukamuwambila kuti, Simwine, usiye ulikatazi, kakuli kaniyelele kuti iwe winjile munzuvo yangu. ");
INSERT INTO sbs_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Chelyo ibaka kanilihindi kuti niyelele kwiza kwako, kono uwambe bulyo inzwi mi muhikanangu kahole. ");
INSERT INTO sbs_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mukuti ime name ni muntu wina mwikonde lamulao, ni masole ni bena mwikonde lyangu. Niwambila umwina, 'Yende', mi uyenda, imi kuumwi, 'Wiize', mi wiiza, imi kumuhikanangu, 'Tende ichi', mi uchitenda.” ");
INSERT INTO sbs_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Imi Jesu hazuwa bulyo, namukomukwa, mi nasandukila kuchisi chibamuichilile nati, “Nimicho kuti, mane nangati mwaIsilaele kananibeni kuwanika itumelo ina bulyo.” ");
INSERT INTO sbs_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Imi linu bana babatumitwe habakabola kunzuvo, nibeza kuwana kuti muhikana chaba nenza. ");
INSERT INTO sbs_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Izo hazimana kutendahala, Jesu abayendi kwitolopo isupwa Naine, mi barutwana bakwe ni chisi ni bayenda naye. ");
INSERT INTO sbs_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Habali kutumbatumba hamenjililo etolopo, mi hamulole, muntu yofwile abahinditwe, mwana wamuswisu umwina bulyo wanyina (yabafwamini), mi chisi chingi chizwa mwitolopo chibena naye. ");
INSERT INTO sbs_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Imi Simwine hamubona, abamufwili maswe inse, imi abawambi kwali nati, “Sanzi ulili.” ");
INSERT INTO sbs_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kuzwaho nichaya kwateni ni kukakwata kuzisamu hababahindile chitumbi, imi babachihindite nibazimana. Nichati, “Murombwana, nikucho kuti, buke.” ");
INSERT INTO sbs_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Yofwile nekala ni kutanga kuwamba, mi Jesu namutambika kubanyina. ");
INSERT INTO sbs_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","16 Linu insabo ni chiyabawila bonse, imi chibazwira habusu kubabaza Ireeza, nibati, “Mupolofita yomaniniza ababuswa mukati ketu,” mi “Ireeza abaloli hewulu labantu bakwe.” ");
INSERT INTO sbs_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Iyi indaba ya Jesu ibahasani mwaJudea yonse ni zikiliti zonse zibambene nanyo. ");
INSERT INTO sbs_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Barutwana ba Johani babamuwambili izi zintu zonse. ");
INSERT INTO sbs_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Kuzwaho Johani nasupa bobele babarutwna bakwe ni kubatumina kwaSimwine nibakati, “Kana nguwe yoswanela kwiza, nandi tuswanela kulola zumwi?” ");
INSERT INTO sbs_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Heti chibasika hafwihi ni Jesu, bakwame nibati, “Johani Mukolobezi wakatutuma kwako zetu kuti, 'kana nguwe yokezite, nandi tuswanela kulola zumwi?”' ");
INSERT INTO sbs_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mweyo inako Jesu abahozi bantu bangi mumalwalila abo ni mumasukuluko abo ni mwihuho imbilala, imi ni kubahofu bangi ababahi kubona. ");
INSERT INTO sbs_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jesu nabetaba nabacho, “Heti chimwamana kuyenda musipili wenu, mukabihe kwa Johani chimubaboni ni kuzuwa. Bantu babahofu babahewa kubona, ziyanga zibatangi kuyenda, bachisenda babanjolozwa, basusu chibasuwa, bantu bafwile bababuswa ni kuhala, mi bahumanehi bawambilwa indava indotu. ");
INSERT INTO sbs_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Muntu yasasiyi kuzumina kwangu chebaka lazitendantu zangu utohonolofezwe.” ");
INSERT INTO sbs_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kumasule abatumwa ba Johani heti chibayenda, Jesu natanga kuwambila zisi kaza Johani. “Chinzi chobayendi kukabona mwihalaupa? Luhe lunyanganyiswa luhuho. ");
INSERT INTO sbs_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Linu chinzi chobayendi kukabona? Mukwame yozabele zizabalo zinolonolo? Lole, bazabala zizabalo zimaniniza ni bahala mumbombolelwa bena muzibaka zibasimwine. ");
INSERT INTO sbs_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Linu chinzi chobayendi kukabona? Mupolofita na? Eee, niwamba kwenu, ni kuhitilila mupolofita. ");
INSERT INTO sbs_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Uzu njiyena uzo zakwe ziñoletwe, 'Hamulole, nitumina mutuminwa wangu mubusu bwako, Yeti nalukise inzila yako noseni kusika.' ");
INSERT INTO sbs_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Niwamba kwenu, mukati kababahwizumukwa kumwanakazi kakwina mukando kuhita Johani. Nihakubabulyo umwina yomaniniza kubunini mupuso ya Ireeza mukando kumuhita.” ");
INSERT INTO sbs_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Bantu bonse habazuwa ichi, kuhindilila batelisa, bababonisi kushiyama kwa Ireeza, chakukolobezwa chekolobezo ya Johani. ");
INSERT INTO sbs_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Linu Bafalisi ni baluti babamaninizi bamulao wa chiJuda babakani zamulero weze Ireeza kuamana navo, mukuti kana babakolobezwa kwa Johani. ");
INSERT INTO sbs_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Kuchinzi, linu, kuniwola kubambanya bantu bounu murahi? Bakola sina chizi? ");
INSERT INTO sbs_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bakola sina bahwile bakwete bazanina henkanza, bekala ni kulinsupa ni bati, “Tubamilizizi impeta, kono kanamubazani. Tubamizimbili izimbo zenjinjo, mi kana mubasilisi.' ");
INSERT INTO sbs_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Mukuti Johani Mukolobezi abezi nasaali inkonko ni kusanywa iwaine, muwamba kuti, 'Wina idimona.' ");
INSERT INTO sbs_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mwana Muntu abezi nalya ni kunywa, imi muti, “Mulole, nji shazilyo ni chidakwa, mulikani wabatelisa ni batendi bazive!' ");
INSERT INTO sbs_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kono butali buzumininwe ni bana bakwe bonse.” ");
INSERT INTO sbs_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Lyahanu umwina wa Bafalisi na mema Jesu kukalya naye. Linu Jesu hamana kwinjila munzuvo ya Mufalisi, nekala hetafule kulya. ");
INSERT INTO sbs_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mi hamulole, kubena mwanakazi mumuleneñi, yabali mutendi wachive. Hazuwa kuti Jesu wina munzuvo ya Mufalisi hetafule, abaleti ijaki ye alabbasitera mwina ioili inunka nenza. ");
INSERT INTO sbs_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nazimene kumasule akwe hembali ni matende akwe, nalila, natanga kubombisa matende akwe ni zisonzi zakwe, imi nazisinda ni insuki zamutwi wakwe mi nachuchuna matende akwe ni kwasinga ni oili inuka nenza. ");
INSERT INTO sbs_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mufalisi yabamemete Jesu habona bulyo, nahupula munkulo yakwe, nati, kambe uzu mukwame mupolofita, hanu neziba kuti njeni ni kuti mwanakazi wamufuta nzi yomukwete, mukuti mutendi wachive.” ");
INSERT INTO sbs_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesu namwitaba nati, “Simoni, nina chinisaka kuwamba kwako.” Nati, “Chiwambe, Muruti!” ");
INSERT INTO sbs_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesu nati, “Mukolotisi zumwi wamasheleñi abena bakoloti bobele. Umwina nakolota ipondo zichita myanda imana iyanza, imi zumwi niyaba makumi amana iyanza. ");
INSERT INTO sbs_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Imi habakangwa kumuliha, nabaswalela bonse. Cheyo inzila, njeni kubali yeti amusake chakumaniniza?” ");
INSERT INTO sbs_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni abamwitabi nati, “Nihupula kuti njozuna yabaswalelwa kukando.” Jesu namuti, “Waatula nenza.” ");
INSERT INTO sbs_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jesu abasandukili kumwanakazi ni kuwambila Simoni, “Ubwene uzu mwanakazi. Nibenjili munzuvo yako. Kana ubanihi menzi amatende angu, kono iye wabombisa matende angu ni zinsonzi zakwe ni kuzisinda ni insuki zakwe. ");
INSERT INTO sbs_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Iwe kana ubanichuchuni, kono iye kuzwa henako yinitanga kwiiza kasiite kuchuchuna matende angu. ");
INSERT INTO sbs_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kana ubetili ioili hamutwi wangu, kono iye abetili matende angu ni ioili inunka bulotu. ");
INSERT INTO sbs_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Chobulyo niti kwako, zive zakwe, zibali zingi, chizaswalelwa ¬ mukuti watondeza kusuna kukando. Kono iye yoswalelwa halikene, usuna halikene. ");
INSERT INTO sbs_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Linu abati kwali, “Zive zako zaswalelwa.” ");
INSERT INTO sbs_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Babekele hamwina nibatanga kuambola mukati kabo, “Njeni uzu yoti uwola nanga kuswalela zive?” ");
INSERT INTO sbs_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kuzwaho Jesu nichati kumwanakazi. “Itumelo yako yakuhaza. Yende chekozo.” ");
INSERT INTO sbs_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Iva pangahali kavaka zana Jesu hatanga kuyenda mumileneni ni mizi, kukutaza ni kuwamba makande malotu kuamana ni mubuso wa Ireza. Ba cita ikumi nibobele babakwina naye, ");
INSERT INTO sbs_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","hamwina ni banakazi vava honzi kwi huho imbilala ni matuku; Mariya yava kusumpwa Magadalena, kozo madimona akwana iyanza nitobele abazwiswa; ");
INSERT INTO sbs_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Johana, mwihyabwe wa Chuza, Muyendisi wa Heroda; Susana, ni bamwi vangi vulyo, camazimo, kuya chezo zivavali kusaka. ");
INSERT INTO sbs_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Yaho chizi chikando chiva kwete kukopana hamwina, mi vantu vavali kukeza kwali kuzwa mwitoropo ni toropo, ca wamba inguli: ");
INSERT INTO sbs_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Mulimi abayendi hanze kukavyala imbuto. Haba kubyala, zimwi ziba wili mumungwangwa mi ziba lyatwa hansi, ni zizuni ze wulu ziba mani kuzilya. ");
INSERT INTO sbs_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Zimwi ziba wili mumabwe, linu haci zikula, ciza nyana, kakuti sekazina mezi. ");
INSERT INTO sbs_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mi zimwi ziva wili mukati ke miya, mi ciza kulilila hamwina ni ntanga ciza nyana ni kuzihwezola. ");
INSERT INTO sbs_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kono zimwi ziba wili mwibu lyindotu miciyaleta imbuto amana ikumi mane chovungi. “Jesu hachamana kuwamba izi zintu, chasumpa, “Yense wina matwi azuwa, mumusiye azuwe.” ");
INSERT INTO sbs_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Varutwana bakwe ciba mubuza intaluso ye nguli. ");
INSERT INTO sbs_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Cawamba, “Inzivo ye nkunutu za mubuso wa Ireza zibahewa kwenu, kono kubamwi ni wamba ce nguli, njokuta kuti kubona kanzi baboni, niku zuwa kanzi ba zuwisisi. ");
INSERT INTO sbs_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Cwale iyi ngi ntaluso ye nguli: Imbuto linzwi lye Ireza. ");
INSERT INTO sbs_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ina iba wili mwinzila njabana babazuwi, kono dyabulusi wiza kuhinda linzwi mwinkulo zabo, njokuta kuti kanzi bazumini ni ku hazwa. ");
INSERT INTO sbs_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mi yo mumabwe njabana, bazuwa linzwi nikuli amuhela che ntabo. Kono kabena mihisi; bazumina kenako zana, mi mwi nako yokulikiwa bawa kuwililila. ");
INSERT INTO sbs_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Imbuto ina iva wili mumiya bantu bazuwa linzwi, kono chi bayenda mwinzila zabo, banyanyiswa ke mpilayelo ni chifumi ni minyaka yo buhalo, mihe zihantu zavo kazi buzwi. ");
INSERT INTO sbs_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kono imbuto ibawili mwibu i lotu, abo njabo, bazuwa kenkulo indotu, balikwata chokuli sileleza mi vavika zicherentu kenkulo inde niku kwatilira. ");
INSERT INTO sbs_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Linu, kakwina zumwi, yomunika ivoni, ni ku bwika hateni itungu kamba kui vika munsi yo bulalo. kono wibika ha mekalo evoni, ilikuti yense winjila abone seli, ");
INSERT INTO sbs_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ka kakwina chiliwungwile cete nici kangwe kwizibeka, mi kakwina chiliwungwile chete ci kane kwizibahala nikwiza mwi seli. ");
INSERT INTO sbs_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Cwale mutekeleze hande, kozo yo wina, zingi kazihewe kwali, kono ya sena, nanga ca hupula kuba nacho kachihindwe kwali. ");
INSERT INTO sbs_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Cwale banyina ni bance ve chikwame chiva keza kwali, kono kena babezi havumbali bwakwe kebaka lye chizi. ");
INSERT INTO sbs_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Avawambilwa, 'Vanyoko ni bance bako vechi kwame vazimene hanze, balindire kukubona,' ");
INSERT INTO sbs_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kono Jesu chavetava ni kuva cho, 'Bamama ni bance bangu vechikwame njabana bazuwa linzwi lya Ireza nikuli panga.” ");
INSERT INTO sbs_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Linu izuba limwi abenjili muchisepe niba rutwana bakwe, mi chaco kubali, “tulutire kweyina imwi imbali yo lwinzi.” Chiva tanga kuzuha, ");
INSERT INTO sbs_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kono havava kuzuha chaya mwiñonzi. I huho ikando litiza libezi halwizi, mi chisepe chabo ciba kwingila menzi, mi vavena mu vukavu. ");
INSERT INTO sbs_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Cwale barutwana ba Jesu' chiveza kwali kwiza kumubusa, ni vacho, Simwine! Simwine! chitufwa!” Chabuka niku kalimela luhuho nikubenga kwa menzi mi chikwamana, mi njikwiza ku ntontola. ");
INSERT INTO sbs_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Cwale chawamba kubali, “Intumelo yenu inahi?” Mi vavali kutite, mwinako se ibatite baba kukomoketwe hape, hape chivatanga kuli buza, “zu cwale njeni, yoha intayelo ku menzi ni ku luhuho, imi zichilila?” ");
INSERT INTO sbs_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Chiba zuhila kuchi kiliti ca Gerasene, ina mwi shirwa lyo lwizi lwa Galileya, ");
INSERT INTO sbs_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesu hakalyata herizo, a vakatanwa mukwame zumwi yaba kwina madimona. Ke nako inde kena aba kuzwete zizavalo, mi kena abakwikala mwizubo abakwikala kuma kumbu. ");
INSERT INTO sbs_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Havona Jesu, chatanga kulila niku wa hansi mi chawamba mumulumo mukando, “usaka kupanganzi name, Jesu, mwana Ireza wina kwiwulu? nikukumbira, kanji uninyandisi.” ");
INSERT INTO sbs_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Kaho Jesu ava layili luho lubilala kuzwa mwali. Kaho luba munyandisi kenako inde, nanga aba kusuminwa mahaka ni mihala nikuba mwintokomelo, ava kukosola mahaka niku yendiswa madimona mwinkanda. ");
INSERT INTO sbs_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Cwale Jesu ca mubuza, “Jeweni inzinza lyako? “chawamba, njime Legiyoni,” kakuti madimona mangi ave njili mwali, ");
INSERT INTO sbs_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Chiya wondelela kumukumbila kuti kanji aya tumini mwintolongo. ");
INSERT INTO sbs_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Hanu mulaka mukanda we zugulube zibakwete kulya ku mbali ni chiwulu. Madimona chiya mukumbila kuti aye muzili, cha a zuminina. ");
INSERT INTO sbs_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Cwale madimona chi a zwa ku mukwame nikwi ngila muzigulube, mi mulaka chiwa shetumuka kuyenda mulwizi ni kuka mina. ");
INSERT INTO sbs_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Avo vavakuyendisa zigulube habavona chapangahala, chivatiya ni kukawamba mwintolopo chapangahala ni mukanda. ");
INSERT INTO sbs_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Cwale bantu chiba yenda kukabona chapangahala, Mi hachi veza kwa Jesu ni kwiza kuwana mukwame uzo kuvazwi madimona, wikele kumatende a Jesu, uzwete nikuba mwingana yakwe, mi vava tiyi ");
INSERT INTO sbs_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Cwale vana vavavoni chiva wambila vantu mukwame yava kunyandiswa madimona mwava hozwa. ");
INSERT INTO sbs_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Cwale vantu vonse ve ntolopo ya Gerasene chiva kumbila Jesu kuti azwe kubali, kakuti vava tiyite a hulu. Cwale chenjila mu chisepe nikubola. ");
INSERT INTO sbs_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mukwame uzo madimona avazwi kwali chakumbila Jesu kuti ayende naye, kono Jesu chamukanina, cacho kwali, ");
INSERT INTO sbs_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Vole kwinzuvo yako ukawambe kecho Ireza wakupangila. Mukwame chayenda munzila yakwe nakaya buwamba chamupangila Jesu. ");
INSERT INTO sbs_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Hanu Jesu ha kavola, chichava chicha muamuhela, kakuli vonse vavakumulindire. ");
INSERT INTO sbs_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mulole, mukwame yo supwa Jairasi, yabali zumwi wava yendisi wesinagoge, avakezi ni kwiza kuwila kumatende, a Jesu' ni ku mukumbila kuti ayende kwinzubo yakwe ");
INSERT INTO sbs_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kakuli mwanakwe womukazana yenke, wezilimo zekumi nizo bele, chava kufwa. Sina Jesu hava kwina mwinzila, chisi chicha kungana kumuzimbuka. ");
INSERT INTO sbs_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Linu mukulwakazi kwavali kwina yava kulwala vutuku bwa malaha kezilimo zekumi, miava sinyehelwi masheleñi akwe kuvasiliki, kono kenavaholi kuvali. ");
INSERT INTO sbs_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Chakeza kumasule a Jesu nikukwata kumangundero e zi zwato zakwe, yahaho kuzwiza kwakwe chikwa mana. ");
INSERT INTO sbs_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesu chawamba, “njeni zuna wani kwata?” Vonse haba sampula, Pitolosi chawamba, “Simwine, chisi ca vantu chikuzimbulukite, ");
INSERT INTO sbs_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","kono Jesu chawamba, “zumwi wani kwata, kakuti nizi kuti ziho zazwa kwangu. ");
INSERT INTO sbs_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mukulwakazi habona kuti kasiwoli kuli wungula, cheza nakwete kuchachalika ni kuwila habusu bwakwe. cheza kuliwamba mukati kabantu chinzi cha mukwatira, ni mwavaholeri yahaho. ");
INSERT INTO sbs_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","cho kwali mwanangu we chikazana, intumelo yako yakuhoza, Yende ce nkozo.” ");
INSERT INTO sbs_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nasi kwete kuwamba, zumwi yava kukazwa kwinzuha yo muyendisi ya sinagoge, chawamba, “Mwanako we chikazana chafwa. Kanji ukatazi muruti ahulu.” ");
INSERT INTO sbs_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Kono Jesu hazuwa izo, chetava Jairasi, “kanji utiyi; uzumine fela, mi kahole.” ");
INSERT INTO sbs_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Hava kezi kwinzuvo, ka kwina yava zumini kwi njila mukati naye, haisi Pitolosi ni Johani ni Jakovo, ni banyina ni vesi bo muhwile. ");
INSERT INTO sbs_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Linu vonse vavali kulila niku vokolola, kono chawamba, “kanji mulili; kafwile kono ulele fela.” ");
INSERT INTO sbs_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kono chiba museka, chokwiziba kuti ufwile. ");
INSERT INTO sbs_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kono cha muhinda kwiyanza ni kusupa, kuwamba, muhwire vuke!” ");
INSERT INTO sbs_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Luhuho lwakwe chilwa vola, mi chavuka yahaho. Chava laya kuti bamuhe chimwi chokulya. ");
INSERT INTO sbs_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Bashemi bakwe vava komokwa, kono chava laya kuti kanji bawambili muntu chapangahala. ");
INSERT INTO sbs_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Abasumpi bena ikumi ni bobele bonse mi nicabaha maata ni buyendisi heulu la madimona onse ni kuhoza matuku. ");
INSERT INTO sbs_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nabatuma kukawamba inzwi ni kukahoza balwela. ");
INSERT INTO sbs_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ni chabawambila nati, “Kanji muhindi chimwi ni chimwi mulwendo lwenu- nanga inkoli, nanga chinkwama, nanga chinkwa, nanga masheleni nanga ingubo zimwi. ");
INSERT INTO sbs_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Inzubo yonse yete mwinjile, mwikale mwateni kuhitila hete nemuyendele. ");
INSERT INTO sbs_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Konse kwete nimuye kobasamutambuli, hamuzwa mweyo intolopo muzukutule isukuko kumatende enu ive vupaki kwinekulyabo.” ");
INSERT INTO sbs_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kuzwaho ni chibanyamuka ni kuyenda muminzi, kuwamba inzwi ni kuhoza konse ko bakaya. ");
INSERT INTO sbs_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Linu Simwine Heroda ha zuwa zonse zi batendahali, na komokwa, mukuti bamwi bati Johani Mukolobezi ababuki kubafwile, ");
INSERT INTO sbs_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","kumwi bati Elija chababoneki, kono bamwi bati zumwi wa bapolofita bentanzi abavuki. ");
INSERT INTO sbs_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Heroda ni cha wamba, “Johani ye ni banokoli mutwi hape uzo njeni ye ni zuwile zakwe?” Mi ni chalika kubona. ");
INSERT INTO sbs_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Mi balutwana ha va voola, va wambili Jesu zonse zintu ze va vatendi. Mi ni chavahinda ni kuyenda kungi kuchivaka chilezana kuitolopo isumpwa Betisaida. ");
INSERT INTO sbs_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kono chisi ha chizuwa bulyo, nichi chamuichilila. A b batambuli ni kuwamba kuvali ka zamuvuso we Reeza, ni kuhoza ba bakusaka kuhozwa. ");
INSERT INTO sbs_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Linu izuba chiliba kuya kuku imina, mi bekumi ni bobele ni chibeza kwali ni chivawamba kuti, “Tumine chisi chiyende kuminzi ituzimbukite ni zivaka zi likungwile ku kaliwanina malalo ni zilyo, kakuti iswe kunu twina muchivaka chi liungwile.” ");
INSERT INTO sbs_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kono ni chawamba kuvali ni cha ti. “Inwe muvahe chimwi chakulya.” Ni chi vati, “Katwina nzinkwa zihitilila zimana iyanza ni nswi zobele - haisi iswe ha tuyenda ku ka ulila bantu bonse aba zilyo.” ");
INSERT INTO sbs_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Kuola ku va ni vakwame va bena zikiti zikwanisa iyanza.) I ca co ku Balutwani vakwe, “Muvavike bekale muzikwata ziwoola kusika mumakumi a kwanisa iyanza chikwata ni chikwata.” ");
INSERT INTO sbs_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ni chi vachita bulyo, mi ni chi vavika vantu kuikala hansi. ");
INSERT INTO sbs_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ni chahinda zinkwa zikwanisa iyanza ni nswi zobele, ni chalola kwiulu, ni ku zitohonolofaza ni kuzi gamona kuzichita tubbali bbali, ni chaha balutwani vakwe kukaha chisi. ");
INSERT INTO sbs_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bonse ni chibalya ni kuikuta, mi zivashali ni chizatolwa - ni chikwezula zitanda zivena ikumi ni zobele zatubbali bbali. ");
INSERT INTO sbs_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kuvezi vuti Jesu ha va kulapela na li yenke, balutwani vakwe va vena naye. A vavuza, ni cha ti, “Chisi chiti njime eni?” ");
INSERT INTO sbs_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ni chi vetaba, “Johani Mukolobezi. Kono bamwi bati nji Eliya, mi bamwi bati nji zumwi wa bapolofita va kale a vavuki. ");
INSERT INTO sbs_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ni cha wamba kuvali, “Kono inwe muti nji me ni?” Pitrosi ni chetava ni chati, “Njiwe Keresite we Ireeza.” ");
INSERT INTO sbs_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kono avakalimela chenguzu ku sawambila muntu zumwi, ");
INSERT INTO sbs_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","kuwamba kuti, “Mwana Muntu u swanera kunyandila zintu zingi ni kukanwa kwa vakulwana va chisi ni basimwine ba maprisita ni bañoli, mi kehaiwe kono mwizuba lya butatu ka vuke.” ");
INSERT INTO sbs_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ni cha wamba kuvali vonse, “Haiva kwina u saka ku ni ichilila, u swanela kulikana i ye mwine ni kuhinda chifapano chakwe mwizuva ni zuva ni ku ni ichilila. ");
INSERT INTO sbs_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","I ye mwine cha vavalela vuhalo bwakwe mwa vusinyehelwe, kono yo sinyehelwa vuhalo bwakwe chevaka lyangu ka vuhaze. ");
INSERT INTO sbs_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Bulutu njo vuhi kuti muntu aluwe inkanda yonse kono iye na sinyehelwa kapa na lihaya? ");
INSERT INTO sbs_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","I ye mwine yo ni swavela ni manzwi angu, na ye mwana Ereeza kamuswabile hachakeza mwikanya yakwe, ni mwikanya ye Reeza ni ya mangeloyi achenete, ");
INSERT INTO sbs_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kono ni miwambila cheniti, kwina vamwi vazimene hanu ve te ne vakane kubona ifu pili ne vaseni kubona mubuso we Reeza.” ");
INSERT INTO sbs_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Haho kwisule amazuva akwanisa iyanza ni wotatwe kuzwa ha vawambili Jesu ao manzwi, ni chahinda Pitolosi ni Johani ni Jakobo ni chivaya kwilundu ku kalapela, ");
INSERT INTO sbs_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Havakwete kulapela, mazimo achifateho chakwe ni cha chincha, mi zizwato zakwe zi vasanduki kutuba. ");
INSERT INTO sbs_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Mi mulole, bakwame vo vere va va kuwamba na ye, Mushe ni Eliya, ");
INSERT INTO sbs_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","va vavoneki mwinkanya ibenya. Ba vakuwamba za kuyenda kwake, ku vakusaka kuleta ma maninizo mwa Jerusalema, ");
INSERT INTO sbs_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Linu Pitrosi ni vavekele naye vava kulele ñozi inkando, kono havavuka ni chi va vona ikanya yakwe ni vakwame vovele va vazimene naye. ");
INSERT INTO sbs_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mi havayenda kusiya Jesu, Pitrosi ni chati kwali, “Simwine kuluto kuti tuvekunu. Tu zake zitomba zotatwe, chimwi chichako, chimwi nji cha Mushe mi chimwi chi be cha Eliya” (Kana a vezi cha va kuwamba), ");
INSERT INTO sbs_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ha va kuwamba vulyo, ikope chilyeza ku kubaungula kuvali, mi va batiite ha ve za kuinjila mwikope. ");
INSERT INTO sbs_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Inzwi li va lizwi mwikope, liti. “U zu nji mwanangu wa mwana-kwame, iye ya vaketwa, muteeke kwali. ");
INSERT INTO sbs_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Inzwi halimana kuwamba, Jesu ava wana yenke. Ba ba tontoli mi kakwina muntu ye ba bawambili mu mazuva ao chebababoni. ");
INSERT INTO sbs_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Linu mwizuba li ichilila, ha ba ba kusuka kuzwa helundu, chisi chingi cha musanganya. ");
INSERT INTO sbs_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mi hamulole mukwame u zwa muchisi ni cha huweleza, ni chati, ");
INSERT INTO sbs_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","“Muluti, ni kukumbila kulola ku mwanangu wa muswisu, nji mwanangu yenke. ubwene, luhuho luvi lumuyendisa mi haho uhuwa, ni kumumbindanisa ni kumuletela ifulo kumulomo. Umusiya cha bukukutu ni kukukatala. ");
INSERT INTO sbs_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ni bakumbili balutwani vako kuti va luzwise kono ba ba kangwi. ");
INSERT INTO sbs_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesu a ba vetabi mi abawambi, “Inwe mubetumelo inini baluzubo lu sazumini, mo ni hinde inako ikuma kuhi na nwe ne ni likwete kwenu? Lete mwanako kunu, ");
INSERT INTO sbs_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","“Mwana havakwiza luhuho lubi lwamuwisikeza hansi mi lwa mumbindanisa. Kono Jesu akalimela luhuho lubi ni kuholisa mwana, ni ku mubozekeza kubesi. ");
INSERT INTO sbs_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bonse ba komokwa kwa maata e Ireeza. Ne va komoketwe ku zintu zonse za va chiti, na vcha wamba kwa balutwani vakwe.” ");
INSERT INTO sbs_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“ Musiye ao manzwi e chile mumatwi enu: Chokuti Mwana e Ireeza ka vetekwe ni kuhewa mumayanza a vantu.” ");
INSERT INTO sbs_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","kono kana va va zuwisizi chiwambo echo. zi va kupatelwa a bo, kuti kanji ve zivi intaluso. Mi hape chi va va kutiya kuvuza intaluso ya chiwambo echo. ");
INSERT INTO sbs_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Linu inkani chi zatanga mukati kavo zakuti njeni mukulwana mukati kabo. ");
INSERT INTO sbs_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Kono Jesu, alemuha mihupulo yina mwinkulo zabo, ni cha hinda muhwile munini ni kumubika hafuhi naye, ");
INSERT INTO sbs_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ni chati kuvali, “Muntu yense yotambula muhwile chezina lyangu, njime yo tambula; mi u tambula ni ya va ni tumi. I ye yense u boneka bunini mukati kenu mwense nji mukando kwenu.” ");
INSERT INTO sbs_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Johani chetava, “Simwine tu baboni muntu yo kwete kutanda badimona chezina lyako ni twa mukanisa, chokuti ka yendeleli naswe.” ");
INSERT INTO sbs_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","“Kanji mumukanisi,” Jesu awamba, “chokuti muntu yense ya samilwisi wina kwenu.” ");
INSERT INTO sbs_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Haho mazuva hanze achuta a kutwi atwalwe kwiulu, ni chahupula kulolelela kwa Jerusalema. ");
INSERT INTO sbs_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ni chatumina ñusa kubusu bwakwe, mi chivayenda kumunzi wa Masamaria kukalukisa zintu zonse. ");
INSERT INTO sbs_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kono vantu kana ba bamutambuli, kakuli a ba lolete kuya kwa Jerusalema. ");
INSERT INTO sbs_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Cwale Balutwani bakwe ba Jokobo ni Jahani ha ba bona bulyo, ni chivawamba kuti, “Simwine, kana u saka kuti tulaele mulilo kuzwa kwiulu ni kubasinya bonse? ");
INSERT INTO sbs_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kono a ba chevuka ni kubanyansa ");
INSERT INTO sbs_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","mi ni chibayenda kumunzi u mwi. ");
INSERT INTO sbs_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ha ba vakuyenda mwinzila, zumwi ni chati kwali, “Ka ni kuicilile konse kwete u ye.” ");
INSERT INTO sbs_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesu ni chamuitaba. “Basimbwe be na malindi, ni zizuni za kwiulu zina zizumbu, kono Mwana Muntu kena nanga halalika mutwi wakwe.” ");
INSERT INTO sbs_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ni cha wambila muntu zumwi. “Ni icilile,” Kono zo ni chati, “Simwine, pili ni lindile ni ka zike bandanda.” ");
INSERT INTO sbs_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Kono ni chawamb kwali, “siye bafwile bazike bafu babo, kono haili iwe, uyende ukawambe inzwi mubule ni bukando ze Impuso ye Ireeza.” ");
INSERT INTO sbs_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Zumwi hape ni chati, “Ka ni kuicilile, Simwine, kono pili ni kalaeze ve na munzubo yangu.” ");
INSERT INTO sbs_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesu ni cha mwitava ni chati, “Ka kwina ubika iyanza lyakwe kumpilo ni kuchevuka kwisule u swanela Mumpuso ye Ireeza,” ");
INSERT INTO sbs_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Linu chinga kwamana izo zintu, Simwine nichaketa bantu bakwana makumi amana iyaza limwina ni overe Linu nichabatuma bovere bovere, habusu bwakwe mwitolopo ni tolopo mwava kuswanela kuyenda. ");
INSERT INTO sbs_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nichawamba kuvali, ikukutulo yingi, linu basinza bache. Nihakubabulyo muvuze Simwine wekutulo atumine bamwi vasinzi mwikutulo yakwe. ");
INSERT INTO sbs_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Muyende mwizila yenu. Mubone, nimitumina hanze sina imbelele zina mukati ka batuhu. ");
INSERT INTO sbs_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kanjimuhindi chikwama chamashereñi kanjimuhindi mukotana wazizwato kamba isangu. Mi nsezi mulumelisi zumwi ni zumwi yesemusangane munzila. ");
INSERT INTO sbs_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Izubo ihi neihi yetimwinjile, Chama tangilo muwambe, 'Inkozo ive mweyinu izubo!, ");
INSERT INTO sbs_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Haiva mutu wekozo mwena mukati, Inkozo muiikale hakwe, kono haiva kanji mona, mwivole kwenu. ");
INSERT INTO sbs_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mwikale mwizubo iswana, mulye ni kunywa zonse zivamiha, muvereki uyelere kuhewa impeyi yakwe. Kanji mukayendi mwinzuvo ni nzuvo. ");
INSERT INTO sbs_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Yonse itolopo yente nimwinjire, mi vamitambula, mulye zosezivamiha, ");
INSERT INTO sbs_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","mi muhoze vose valwala venakwateni, Muwambe kuvali, 'mutekuti impuso ye Reeza chiyeza hafwihi nanwe.' ");
INSERT INTO sbs_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Inakoyonse hamwinjila mwitolopo mi kava mitambuli, muyende haze lyamingwangwa mi mukatekuti, ");
INSERT INTO sbs_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","'Nanga isuko lizwa mwitolopo yavo likakatile kuma ntende enu muliva limi lwisa muliva nkunkumwine! Linu mwi zive izi: Impuso ye Reeza chiyeza hafuhi', ");
INSERT INTO sbs_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ikumbya nimiwambila nitii mwelina izuba lyekatulo Sodoma kapangiwe sinte kuhita yina itolopo. ");
INSERT INTO sbs_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Wina bumai iwe, korazini! Wina bumai iwe Betsaida! Mukuti kakuli zivapangiwa nanwe kambe zivapangiwa ni Tire ni Sidoni, niva vaki kale, kwikala niva zwete masaka niku lisinga itwe, ");
INSERT INTO sbs_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nihakuba bulyo Tire ni sidoni kazipangiwe sinte kuhita inwe mwinako yekatulo kuhita inwe. ");
INSERT INTO sbs_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Iwe, kapenawuma, uhupula konyemunwe kwiwulu? Nanta, movozwe hansi mwihele. ");
INSERT INTO sbs_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Iye mwine yoteka kwenu uteka kwangu, linu yomikana ukana name, mukuti yonikana ukana niyabanitumi.” ");
INSERT INTO sbs_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ba makumi akwana iyaza limwina nimakumi overe nichibakavola nibasangite, nivatakuti,'”Simwine, mane ni madimona atuzuwa mwizina lyako.” ");
INSERT INTO sbs_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesu nichata kuvali, “niva boni satani chowa kwiwulu sina invula ivesa. ");
INSERT INTO sbs_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mubone, nivamihi innguzu zakulyata izoka nitu vumwe, nihewulu lyenguzu zachila, mi kakwina mukwa umwi wete nichi miholofazo kawo. ");
INSERT INTO sbs_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nihakuva bulyo kanji musangi kezo bulyo, kuti ihuho zami zuwa, linu musange mukuti mazina enu añoletwe mwi mbuka yakwi wulu”. ");
INSERT INTO sbs_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mweyo inako iswana nicha taba ahulu Muluhuho Lunjolola, nichatakuti, “ni kulumbeka, Tayo, Simwine wewulu ni ikanda, mukuti izizintu ubaziwungwili vena mano nivazuwisisa, ni kuziwumbwila vana basana vavarutwa, sina vahwilezana, Eni, Ita, Mukuti chivali kusangisa kumbaliyenu.” ");
INSERT INTO sbs_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Zintu zose nivazihewa kwatayo, mukuti kakwina wizi kuti Mwana njozuhi mbwiteli Itayo, imi kakwina yowizi Tayo mbwiteli mwanakwe hape yense yonsalwa kumwanakwe kumuzivahaza kwali.” ");
INSERT INTO sbs_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Linu nicha sandukira kuvarutwana vakwe ni kuva wambira kwimbali, “Bafuyoletwe avo vantu vavona zintu zimuvwene. ");
INSERT INTO sbs_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nimilwira, mapolofita vangi ni vasimwine vava sakite kuvona zintu zimuvwene, linu kana vavazivoni, mane nikuzuwa zintu zimuzuwile, imi kana vavazizuwi.” ");
INSERT INTO sbs_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mulole, umwi muruti wamulao wa Majuda nicha zimana kusaka kumulika, nichati, “Muruti, munipange vuti kuti niwole kuyola vuhalo vusamani?” ");
INSERT INTO sbs_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesu chata kwali, “Chizi chiñoletwe mwimbuka yamulao? Kati wuvala vule?” ");
INSERT INTO sbs_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Linu chinge tava chatakuti, “Mosake simwine Ireeza nikulo yako yose ni mozo wakowose, ni nguzu zakozose, ni mizezo yakoyose, ni yovambee naye sina njewe.” ");
INSERT INTO sbs_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesu nata kwali, “Wetava sinte. Wupange, vovu lyo imi mohale.” ");
INSERT INTO sbs_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","linu muruti, kulakanamina kuli nyemuna iyemwine, nichata kwa Jesu, “linu univambene naye njeni?” ");
INSERT INTO sbs_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Imi hetava ikalavo Jesu nata kuti, “Mukwame zumwi avakuzwa kwa Jerusalema kuya kwa Jerico. Nicha wila mumayaza avansa, ni chi vamuchupulisa ni kumunyanga zintu zakwe, nichi vamundamona nikumusiya uzuminine. ");
INSERT INTO sbs_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Chetohonolo muprista avakuhita mweyo inzila, chinga muvona, nicha muzimbuluka. ");
INSERT INTO sbs_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Chokuswana mulevi naye, chingasika hachivaka chiswana ni kumubona, nichazimbulukila kumbali. ");
INSERT INTO sbs_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Linu mukwame Wamusamaria, hava kuyenda mweyo inzila, Chinga muvona, chamu nfwila inse. ");
INSERT INTO sbs_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Chamu chunina nikusumina zilavi zakwe, niku chuka ioyili ni veine hateni. Ni kumutatika hembelesa yakwe, nicha muleta mwi hotela, kwiza kumulwalikila mwateni. ");
INSERT INTO sbs_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Imi izuva lichilila chahinda impondo zovere. imi nichaziha mwine we hotela, “imi nichamuwambila kuti, zintu zonse zete notendise, china kabola, munize nikuluwere. ");
INSERT INTO sbs_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Imi njeni kwava votatwe, yo hupula, kuti yava vambene naye hawila muyaza abansa? ");
INSERT INTO sbs_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","'Imi muruti nichatii, “Yava mufwili inse,” Jesu nichata kwali, “Yende ukapange ziswana.” ");
INSERT INTO sbs_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Linu havava kwavuyenda, niche njila mu munzi wumwi, mwanakazi zumwi yava kusupwa Mareta nicha mutambula mwizuvo yakwe. ");
INSERT INTO sbs_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Avena mwache wamwanakazana yavakusupwa Maria, yave kele havunsu vwamatende a Simwine niku zuwa mazwi akwe. ");
INSERT INTO sbs_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kono Mareta avapatehete nimitendo mingi yakwihika kuti avayumbule. Nicha yende kwa Jesu, Nikuka cho, “Simwine, kovilaeli kuti mwachangu wanisiya nini seveza neke? linu umuwambile zanituse,” ");
INSERT INTO sbs_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","imi Simwine nicha mwitava nati, Mareta, Mareta, uvilaezwa nizintu zingi, ");
INSERT INTO sbs_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","imi chitu choke chisakahala, linu Maria waketa chintu chilukite, chisa woli kuhindiwa kwali. ");
INSERT INTO sbs_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kubatendahali imwi inako Jesu haba kulapela muchibaka chimwi, mulutwana yenke chawamba kwali, “Simwine, tulute kulapela sina Johani mwaba lutili balutwani bakwe kulapela.” ");
INSERT INTO sbs_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesu chati kubali, “Hamulapela muwambe, 'Tayo, izina lyako lijolozwe. Mubuso wako ukeze. ");
INSERT INTO sbs_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Utuhe chinkwa chetu mwi izuba ne zuba. ");
INSERT INTO sbs_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Utu ondere zibi zetu, sina mutu ondera muntu ni muntu yowina mulandu kwetu. Sanzi ututwali mumuliko.” ");
INSERT INTO sbs_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesu chawamba kubali, “Njeni kwenu yowina mulikani, mi uyenda kwali hakati kamasiku, nokumuwambila, 'Mulikani, nikolotise zinkwa zotatwe',6 ");
INSERT INTO sbs_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","chinga sikira mulikanangu kukazwa munzira, mi kanina chimwi cho kumuyumbula, ");
INSERT INTO sbs_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Yavena mukanti chamucho kuti, 'kanji uni katazi. Mulyango we yaliwa kale, mi bana bangu, bena neme, bena habulalo. Kani oli kubuka ni kukuha nchinkwa.' ");
INSERT INTO sbs_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nikuwambila, nihasabuki kuti akuhe nchinkwa, kakuli umulikani wakwe. Ibaka lyako lyo kundundamena kwako nosa swabi, mwabuke no kukuha zikwa zingi zosaka. ");
INSERT INTO sbs_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ime name nikuwambila, kumbile, mi mowane; ngane, mi mowane; ngongote, mi mowi yalwilwe. ");
INSERT INTO sbs_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Muntu yense yokumbila uhewa; mi muntu yongana uwana; mi kumuntu yo ngongota, mweyalwilwe. ");
INSERT INTO sbs_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Mushemi inzi wechi kwame hakati kenu, haiba mwanakwe wechi swesu hamu kumbila inswi, momuhe izoka kapa inswi? ");
INSERT INTO sbs_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kapa hakumbila iye, kana momuhe kabumwe? ");
INSERT INTO sbs_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nihakubabulyo, haiba inwe mwina buvi mwizi kuha impo zilotu kubana benu, linu Ishenu yowina kwiulu, kahe zikuma kuhi ku bamukumbila luhuho lujolola?” ");
INSERT INTO sbs_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Imwi inako, Jesu aba kuhindikira hanze indimona, mi ibali satambi. Chikupangahala kuti indimona halizwa, mukwame abali satambi chatanga kuwamba. Chisi chicha komokwa! ");
INSERT INTO sbs_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Linu bamwi bantu chibawamba, Cheziho za Beelzebule, simwine wa madimona, uzwesa madimona. ");
INSERT INTO sbs_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bamwi chibamulika kuti aba tondeze chisupo chizwa kwiulu. ");
INSERT INTO sbs_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Linu Jesu kokwiziba mihupulo yabo, chabawambila kuti, “Mubuso ni mubuso ose olikauhanya ushala niu kauhene, Mi inzubo ili kauhanya iyo ine kaiwe. ");
INSERT INTO sbs_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Haiba Satani uli kauhanya iye mwine, mubuso wakwe uzimana bule? Inwe muwamba kuti ime ni zwisa ihuho ca Beelzebule. ");
INSERT INTO sbs_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Haiba nini zwisa mandimona ca Beelzebule, chwale balutwani benu ba zwisa chani hanze? Bakeñi chezi, mubabe baatuli benu. ");
INSERT INTO sbs_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Kono haiba nizwesa mandimona chomunwe we Ireza, linu muvuso we Ireza chiweza kwenu. ");
INSERT INTO sbs_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Linu mukwame yokolete yokwete zilwiso namamela izubo yakwe, zibya zakwe zina mwipabalelo ina hande, ");
INSERT INTO sbs_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Linu mukwame yokolete hamukoma, mukwame yokolete uhinda zilwaniso zakwe, mi uzenenga chifumu chakwe. ");
INSERT INTO sbs_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Yase yasena name unisandukile, yasakunganyi name uhasanya. ");
INSERT INTO sbs_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Luhuho lubi haluzwa kumutu, lu yenda muchibaka chisena menzi ni kungana chibaka cho kupumwira. Halubula, luli wambila, 'Munibole kwizubo kunakazwa.' ");
INSERT INTO sbs_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Halubola, lukawana kuti izubo ifiyelwe ni kubikwa hande. ");
INSERT INTO sbs_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Mi lubola ni kukahinda amwi madimona akwana iyaza nio bele alihita kulunya mi onse enjila nikuhala mwateni. Linu bwikalo bwama manimani bozo muntu mubube bubilala nikuhita bwe ntanzi.” ");
INSERT INTO sbs_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kubapangahali vuti, habakuwamba inzi zintu, mwanakazi zumwi aba huwelezi kuhita mazwe a chisi, ni kuwamba kwali, “Lina itohonolo ibumo liba ku hwizumuki ni beere libakunyonsi.” ");
INSERT INTO sbs_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Linu iye chati, “Chobulyo, bena itohonolo njabana bazuwa linzwi lya Ireza nikulili vikira.” ");
INSERT INTO sbs_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Linu chisi hachibali kukopana nanga bantu bangi, chotanga kuwamba, “Uwu murahi - murahi mubilala. Usaka chisupo, kono kakwina chisupo chite chihewe kuwuli konji chisupo cha Jonasi. ");
INSERT INTO sbs_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Sina mwababiri Jonasi chisupo kuvene Nenive, Linu ku Mwana wa Muntu mwabe chisupo kounu murahi. ");
INSERT INTO sbs_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Simwine wa mwanakazi welu hati lwa chilyo mwazimane hekatulo ni mukwame wowuni murahi niku banyansa, linu aba kazwi kuma mani - mani a nkanda kwiza kuzuwa maano a Solomoni, mi mubone zumwi kuhita Solomoni kwena hanu. ");
INSERT INTO sbs_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mukwame wa Nenibe kazimane he nkatulo nowu murahi wa batu ni kuunyaza, Linu baba baki henkutazo ya Jonasi, mi mubone, zumwi mukando kwa Jonasi zunu hanu. ");
INSERT INTO sbs_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Kakwina zumwi, hamana kumunik i lambi, nokulibika mukerima, kamba mwikonde lye chitanda, kono hama biko a lambi iri kuti benjila bawane iseri. ");
INSERT INTO sbs_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Menso ako nji lambi yomubili. Haiba menso ako ena hande, mubili ose wizwire iseli. Kono haiba linso lyako ivi, mubili wako wiizwere kerima. ");
INSERT INTO sbs_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nihakwinabulyo, mutokomere kuti iseli lina kwenu kena kerima. ");
INSERT INTO sbs_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nihakwinabulyo, mubili wako ose wina iseli, nikusena i mbali yomubili wako mu kerima, Linu mubili wako onse muuswane ubu i lambi haibenya choku njoloza kwako.” ");
INSERT INTO sbs_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Hamana kuwamba, Mufalisi chomukumbira kuti bakalye naye kwizubo yakwe, mi Jesu choyenda chokekala ha zilyo. ");
INSERT INTO sbs_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mufarisi chokomokwa kuti kena aba tangi kusambi naseni kulalila. ");
INSERT INTO sbs_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kono Simwine chali kwali, “hanu chwale, inwe Mafarisi muchenise inkomoki ni tusuba hanze, kono mukati kenu mwina feela belyavi, nibubilala. ");
INSERT INTO sbs_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Inwe bantu musena ingana! Kena kuti yaba pangi hanze njiyena hape yopanga mukati? ");
INSERT INTO sbs_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Muhe ku babotana zina mukati, mi zintu zonse njisezi chene kwenu. ");
INSERT INTO sbs_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Kono bumayi kwenu inwe Mafarisi, kakuli muzwisa chintu chonke kuze kumi, minta ni kumini mwiwa lyezi byalantu, kono kamu bileli niswanero ni lato lya Ireza. Kwina hande kupanga nceswanero ni kusaka Ireza, nikusa kangwa kupanga zimwi zintu nazo. ");
INSERT INTO sbs_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Bumaiye kwenu inwe mafarisi, kakuli musaka zipula zokubusu mu masinagoge ni kulu meriswa chekute kuzibaka zemusika. ");
INSERT INTO sbs_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Bumaye kwenu, kakuli muswana sina makumbu asena maswayo, bantu baalyata niba sezi.” ");
INSERT INTO sbs_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mi muruti zumwi omu lao wama juda chamwitaba nokuwamba kuti, “Muruti, zowamba zitu tuka neswe.” ");
INSERT INTO sbs_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesu chawamba, “Bumaye kwenu, baruti bomulao! Linu mulemeza batu ni miziyo ibasa oli kuhinda, kono inwe mani kamukwati iyo miziyo ni kanwe kenu konke. ");
INSERT INTO sbs_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Bumaye kwenu, kakuli muzakila ba polofita' makumbu, akubazezela ho, mi bazimu benu ba babehayi. ");
INSERT INTO sbs_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Mi mwipaki hape niku zumina misebizi yaba ziimu benu, kakuli cheniti luli babe hayi Baporofita, avo makumbu abo akuba zezela ho. ");
INSERT INTO sbs_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Cheri ibaka nalyo, butali bwe Ireza vuva cho, 'Muni tumine kubali bapolofita ni ba apositola, mi mubaba nyandise ni kwihaya bamwi. ");
INSERT INTO sbs_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Uwu murazi, chwale, kababe nikulitabilira, kuamana ni malaha aba polofita avava tiri chinga libatangi ifasi. ");
INSERT INTO sbs_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","kuzwa kumalaha a Abele kuya kumalaha a Zakaria, yabe hailwa hakati ka katala ni chihalaleho. Eni, niwamba kwenu, Owu murahi kaulitabilile. ");
INSERT INTO sbs_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Bumayi kwenu maruti bo mulao wa Majuda, kakuti chimubahindi inkii yenzibo; inwe mubene kamwinjili mwateni, mi mukanisa abo basaka kwinjila. ");
INSERT INTO sbs_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesu hachazwele kwateni, bañoli ni Mafarisi chiba mukananisa ni kumu lwanisa kuamana zintu zingi, ");
INSERT INTO sbs_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Kulika kumuchesa mumanzwi akwe. ");
INSERT INTO sbs_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Munako zana, chikiti chavantu chibena hamwina, mbwita nibalilyata jo bungi, chatanga kuwamba kuva rutwana bakwe, Mutokomere mulungo wava Farisi, iri kuliha ");
INSERT INTO sbs_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kono kakwina chinchinte, chete nichi kanwe kwi zibahazwa, ");
INSERT INTO sbs_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Cwale chose cimu va wambi mwififi kachi zibahazwe mwiseli, mi chimubali kushovota muma ntwi kachi huwerezwe hakantungandi ke zuvo. ");
INSERT INTO sbs_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ni wamba kwenu balikani, kanji muntiyi behaya mubili, kuzwa ho kavena chimwi chiva ola kupanga, ");
INSERT INTO sbs_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kono me ni mikalimera kuamana neni umowola kutiya. Mutiye yenke uzo Hamana kwi haya, wina ziho zo kutumina mwi here, Eye, Ni miwambira, mumutiye. ");
INSERT INTO sbs_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Kena kuti tuzuni tukuma he yanza limwina tu uziwa hetenko i likana tukoviri to Vere? Kono nanganti konke kutuli kase hupulwa kweIreza. ");
INSERT INTO sbs_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kono nangati i mpalo ye nsunki nzenu ivalitwe, Kanji mutiyi. Mwina butokwa kuhita tuzuni tungi. ");
INSERT INTO sbs_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ni wamba kwenu, yense yo niwamba havusu bwa bantu, Mwana u muntu kaka muwambe naye habusu bwa mañiloyi e Ireza. ");
INSERT INTO sbs_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","kono nyense yo nisampula havusu bwa Vvantu kaka sampulwe havunsu bwa mañiloyi e Reza. ");
INSERT INTO sbs_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Yense yo wamba linzwi ivilala kuamana ni mwana wo Muntu, ka wonderwe awo mazwi, kono kozo yo wamba vuvilala kuamana ni Luhuho lu Njolola, kasana a wonderwe. ");
INSERT INTO sbs_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Hasana kava mi lete havusu bwa masinangonge, va yendisi, ni vena ha muvuso, kanji ni muvireri kuamana nimwete ni mwi tavire ku amana ni kulizimanina, kamba chete ni muwambe, ");
INSERT INTO sbs_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","kakuli Luhuho lu Njolola kalumi ka lumi lute mweyo nako chizi chi muswanera kuwamba. ");
INSERT INTO sbs_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Linu zumwi mukati kechisi cha cho kwali, “Muruti, wambire mukulwangu kuti a liyavire chifumu chavayoli name.” ");
INSERT INTO sbs_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesu cha kwa li, “Mukwame, Jeni wani vika mu atuli kamba muzimanini hakati kenu?” ");
INSERT INTO sbs_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Mi chati kuvali muli tokomere kobona kuti mulizwisa ku takazo yonse yomuuna, kakuti vuhalpo vo muntu kabwina vulyo hachi fumu chali kunganize muntu.” ");
INSERT INTO sbs_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Linu Jesu chava wambira i nguli, ni kucho Iuwa lo mukwame yavali kufumite, luvali kuvikite ahulu, ");
INSERT INTO sbs_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","mi chali wambira ni kucho, chizi chete ni pange kakuli kanina chiviko cho kuvika zilyo zina lima? ");
INSERT INTO sbs_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Cha wamba, í chi jichona chete ni pange. Mu ni wise hansi zishente zangu ni kuzaka zikando ahulku, umo mwete ni vinke vuhenke bwangu vonse ni zimwi zimera zete ni sinze. ");
INSERT INTO sbs_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Muni wambe ku luhuho lwangu, “luhuho, wina zilyo zingi zisizitwe zonso seberise zirimo zingi. Pumule hande, lye, nwe, unsese.” ");
INSERT INTO sbs_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kono Ireza cha cho kwali, 'Chihole cho mukwame, masiku a nsunu luhuho lwako luhindiwa kwanko, mi nzintu ziwa lukisa, muzive zani?' ");
INSERT INTO sbs_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","China mwe kalire muntu yoli kunganyiza chifumu kwali mi kafumite havusu bwe Ireza.” ");
INSERT INTO sbs_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jesu cha wamba kuva lutwana bakwe, “Cwale he nicho kwenu, kanji muivireri kuamana ni vuhalo bwenu - chizi chese mulye, kamba kuyana nizo mubiri wenu - chinzi chete muzwate. ");
INSERT INTO sbs_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kakuti vuhalo bwina butokwa kuhita zilyo, mi muviri wina butokwa kuhita zizwato. ");
INSERT INTO sbs_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mulemuhe ma ñwarara, kuti kava byali kamba kusiza. Kazina zivinko kamba zishete, kono Ireza uzilelra. Muvo vutokwa vule kuhita zizuni! ");
INSERT INTO sbs_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mi jeni kwenu choku virera u wola kuyekeza i zuva kuvuhalo bwakwe? ");
INSERT INTO sbs_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Cwale haiva kamu oli kupanga nanga nti chitu chinini, chinzi hamu virera kuamana ni nzonse? ");
INSERT INTO sbs_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mulemuhe tuyanga yanga mutumenena - zikula vule. Kazi sevezi, kamba kuhosa. Kono ni cho kwenu, nanga Salumoni mwi kanya yakwe kenba aba zwatikiwa uvu ji limwi. ");
INSERT INTO sbs_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Haiva Iraza uzwatika lyani lyomukanda, lina kwateni nsunu, mi inzona lizindirwa muhisa, inwe cwale mwa mizwatike vule, mawe inwe ve tumero inini! ");
INSERT INTO sbs_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kanji mungani zete mulye kamba zete munwe kanji mu vireri. ");
INSERT INTO sbs_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kakuli inkanda zonse ze fasi bangana inzi nzintu, mi Ishenu wizi kuti musaka inzi zintu. ");
INSERT INTO sbs_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kono musake mubuso wakwe, mi inzi zintu ka muziyekerezwe. ");
INSERT INTO sbs_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Kanji mutiyi, tumberere tunini, kakuli i shenu i sangitwe kumiha Muvuso. ");
INSERT INTO sbs_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mu uze maluwo enu mi muhe kuva shevete. Muli pangire ziviko zisa woli kusupala - Vufumu mwi wulu muzisa mani, uko kusengiri vasa mi Ifulapepe kuzisa shinyi. ");
INSERT INTO sbs_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kakuti kwina chifumu chenu, uko ni inkulo yenu kwete ive nayo. ");
INSERT INTO sbs_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Imunda zenu zisuminwe muma tunga mi malambi enu a zwirenhavusu ni kumbukuka, ");
INSERT INTO sbs_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","mi muswane uvu vantu bakwete kulola muyendisi wavo chakavola kumukiti we senso, iri kuti cha keza ni kwiza kungongo ta, yahaho bamwi yalwira mulyango. ");
INSERT INTO sbs_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Imbuyoti yaba bahikana, vesana keza wanikize niva lindire chakeza. Chama niti ni miwambire kuti keza nsumine ziwato zakwe zile mumunda che tunga, ni kuve kalika hasi kuzilyo, mi mwakeze nikwiza kuva haza. ");
INSERT INTO sbs_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Haiva muyendisi ukeza malunga siku, kamba kalya butatu bwe nako, ni kwiza kuva wana vali tukise, Imbuyoti zavo vahikana. ");
INSERT INTO sbs_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Konohape mwizive inchi, kuti haiva muyendisi we nzuvo ave zivite inako iyo musa avali kukeza, nasana a va siyiriri inzuvo yakwe ni iñatulwa. ");
INSERT INTO sbs_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mulitukiseze nanwe vulyo, kakuti kamwizi inako iyo mwana o Muntu sana keze.” ");
INSERT INTO sbs_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pitorosi chati, “Simwine, uwambira iyi nguli kwetu fera, kamba niku vantu vonse?” ");
INSERT INTO sbs_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mi Simwine chati, “Njeni he you sepahala ni kutalifa muyendisi simwine yata vike vuyendisi he wulu lya va hikana kuti a kuva hanga zilyo che nako iswanera? ");
INSERT INTO sbs_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ufuyaulitwe uzo muhikana, uzo muyendisi wakwe keza wane napanga izo hakeza. ");
INSERT INTO sbs_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Cheniti niwamba kwenu kamuvike vuyendisi bwe luwo lyakwe. ");
INSERT INTO sbs_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kono haiva uzo muhikana nali wambnira mwinkulo ya kwe, 'Simwine wangu unlyeha kuku vola; mi utanga ku mbupola bahikana vava kwame ni ve chanakazi Vahikana, ni kulya ni nwa, ni kukolwa, ");
INSERT INTO sbs_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","simwine wozuna mu hikana kakeze mwizuba lyasa mulindire, ni mwi nako yasenzi mi kamu konsole mutu vindivindi nikumu tumina kuchi vaka chimwi navana vasasepahali. ");
INSERT INTO sbs_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Zuna muhikana, hace zivite mihupulo ya simwine wakwe, mi kena ava lukise kamba kuyendereza mwa sakira, kakaviwe cha mafaindi mangi. ");
INSERT INTO sbs_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kono uzo yasana a bezivite, kakaviwe chama faindi mache. Zumwi ni zumwi kwali kuherwe a hulu, zingi kazi sakahane kwali, mi kwali vava sepahali ahulu, kava vuze zingi ahulu kwali. ");
INSERT INTO sbs_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ni vakezi kuzindira muliro mwi kanda, mi muni sangirwa kuti kamba ciwuva mbukulwa kale. ");
INSERT INTO sbs_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Kono nina i nkolovezo ini swanera kukolovezwa chayo, mi kaini kalikite hande konji chiya lizuziriza! ");
INSERT INTO sbs_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Muhupula kuti ni va kezi kuleta inkozo mwi ikanda? Ne, Ni ki wambira, kono niva leti ikauhano. ");
INSERT INTO sbs_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Cwale kuzwa hanu kuya kuvusu, mukube mwizuvo nyonke inkauhano zeyanza lyonke - vantu vo tatwe kulyisa vovere, vantu vo vere kulwisa vantu vo tatwe. ");
INSERT INTO sbs_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Kava kauhane mushemi we chikwame kulwisa mwana kwe we chiswisu, ni mwana we chiswisu kulwisa isi; mushemi we chanakazi kulwisa mwanakwe we chikazana, ni mwana kazana kulwisa nyina; mukwenyani we chanakazi kulwisa mukwenyana kwe we chikazana, ni mukwenyani we chikazana kulwisa mukwenyanakwe we chanakazi.” ");
INSERT INTO sbs_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesu avali kuwamba ni kuchisi bulyo,”Hamubona i kope lizimana kubwimino, yahaho mu wamba, 'I vula ikezite; mi iza kuva bulyo. ");
INSERT INTO sbs_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Mi haiva luhuho lo kwiyaza lye chimonso ni hunga, mu wamba, 'Mukuhise a hulu nsunu; mi kwiza kuva vulyo. ");
INSERT INTO sbs_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Balihere, mwinzi kutoloka mayemo e kanda ni e wulu, linu vule hape hamusezi muku tolokerwa i nako ya hanu? ");
INSERT INTO sbs_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Chinzi hamusa atuli zina hande kwenu? ");
INSERT INTO sbs_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kakuli haiva no yenda niyo ku zekisa kumu atuli, mu zira ulike ahulu kuti mumane indava naye, iri kuli kanji naka kutambinki kumu atuli, mi kuti muatuli kanji a kaku tambiki kumu yendisi, mi munyendisi kanji a kakusoheri mwi ntorongo. ");
INSERT INTO sbs_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ni wamba kwenu, kasana ko zwe mwateni konji hete no lihire ishereñi yama manimani yo kwete.” ");
INSERT INTO sbs_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Cheyo nako vantu vamwi vava mu wambili cha Magalileya avo, malaha, avo, a va kopanyi Pilato ni zitabelo zavo. ");
INSERT INTO sbs_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesu ave tabi nati ku vali, Linu muhupula kuti avo Magalileya vena zivi zingi kuhita Magalileya vonse vava nyandiswa che nzila iyi? ");
INSERT INTO sbs_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nanta, ni mi wambila. Niti, heva ni mu sa lisa lichuli zivi zenu muvonse mo mufwe munzila iswana. ");
INSERT INTO sbs_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ni heva vantu vene kumi ni valikana iyanza ni vo tatwe, va zwa mwa Siloe avo itawala iva wili ni ku ve haya, muhupula kuti va vena zivi kuhitiliza vamwi vakwame mwa Jerusalema? ");
INSERT INTO sbs_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nanta, niti kwenu, heva ni musa lichuli zivi zenu mu vonse momu fwe. ");
INSERT INTO sbs_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesu ava wambi inguli iyi, muntu zumwi ava vyali isamu lye feiga mwi wa lyakwe lye veine, linu neza kulola kwateni zi hantu ze veine cheza kuvula na nga konke. ");
INSERT INTO sbs_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Mukwame, nati ku mulimi, lole, cheli zilimo zo tatwe nini za kulola zi hantu kweli samu kono kani wani nanga konke. Liteme, liwe bulyo. Chinzi holi silile ni lishinye vuu?' ");
INSERT INTO sbs_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mulimi, ne tava nati, 'Mu siye vulo, chinu chilimo, nili, limine ni ku livika mununo. ");
INSERT INTO sbs_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Heva mu livike, zi, hantu, chilimo chi keza, ku lotu, linu, heva ka liviki, mu liteme liwe.'” ");
INSERT INTO sbs_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Linu, Jesu avali ku ruta mwi Sinagoge, le nsavata. ");
INSERT INTO sbs_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Muvone, mwanakazi a vena mwa teni ke zi limo zine kumi ni zi likana iyanza, ni zo tatwe, nena luhuho lubi lwa kufokola, linu, chava koteme musana kana vali ku wola kuzima. ");
INSERT INTO sbs_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Linu, Jesu nga amu vona, ava sumpi kwali nati, “Mwanakazi, niti, chi wa sumununwa ku manyando ako. ");
INSERT INTO sbs_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Cha vika manza heulu lya kwe, mi chenako yonke, cha oloka mi chatemba Ireeza. ");
INSERT INTO sbs_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Linu Mukulwana we Sinagoge cha venga ahulu che vaka lyo kuti Jesu ava hozi mwanakazi mwi zuva lye nsavata. Linu muyendisi we Sinagoge ne tava ku chicava nati, kwina mazuva alikane yanza ni zuva limwina, mazuva etu swanela ku seveza. mwize muhozwe, nanta lye nsavata. ");
INSERT INTO sbs_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ireeza na mwi tava nati, Inwe mulihele kana kete musumunune imbongolo kapa Iñombe kuitwala ku kunywa menzi le nsavata? ");
INSERT INTO sbs_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Linu kozu mwana Abrahama yava suminwe kwa Satani zi limo cha zi limo zine kumi ni zilimo zilikane ya nza ni zilimo zo tatwe, linu kene nswanelo yakwe kuti a sumununwe mwi zuva lye nsavata? ");
INSERT INTO sbs_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Sina hava wambi izi zintu, vonse va vali kumu sheununa, vava swabi ahulu. Linu, chonse chi chava chiva sangi ahulu ni kumu temba cha zintu za vatendi. ");
INSERT INTO sbs_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Linu, Jesu chati, muvuso we Reeza wina vule? Imi ka ni u vambaye ni chi? ");
INSERT INTO sbs_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kukola uvu lutanga lwe samu luva sohelwa mwiwaa, ni ku kula kuva isamu ikando, mi zizuni zewulu chiza zaka zizumbo kumitavi.” ");
INSERT INTO sbs_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Hape chati, “Kani uvambanye nichi muvuso we Reeza? ");
INSERT INTO sbs_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ku swana sina mulungo wava kopanyi mwanakazi muvusu vwavu roto kuti vu funduluke chi vukopene neza ni vusu vwa vuroto. ");
INSERT INTO sbs_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesu ava poteli mileni ni minzi havena munzila kuya kwa jerusalema niku va ruta. ");
INSERT INTO sbs_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Zumwi chati kwali, “Simwine, na vache feela vantu vete vapuluswe?” Cwale cha wamba kuvali, ");
INSERT INTO sbs_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Mu lwile kwinjila mu mulyango u kumbene, kakuti, niti kwenu, bungi mu vatavele kwi njila, kono kete va wole kwi njila. ");
INSERT INTO sbs_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Linu mwine we nzuvo havuka, mi cheyela mulyango, linu kamu zimane hanze ni mungongota, ni muti, Simwine, Simwine tusiye twinjile,' Mi ketave ni kucho kwenu, kani mizi inwe kapa muka zwila kuhi.' ");
INSERT INTO sbs_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Linu ka mu wambe, 'Tuvali ni ku nywa havusu bwako mi uva ruti mu makululu etu, ");
INSERT INTO sbs_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","linu ketave nati, niti kwenu, kani mizi ku mu kazwila. Muzwe kwa ngu, Inwe mutenda zivi. ");
INSERT INTO sbs_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ka valile ni ku kwenga meeno, chi va vona Abrahama, Isaaka, ni, Jakobo ni vonse va polofita mu muvuso we Reeza, ");
INSERT INTO sbs_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Linu inwe - inwe ka mu zindilwe hanze. Ka vasike kuzwililila ku vuzwe, ku vwimino, upa ni mbowela, ni kwi kala he ntafule mu vuso we Reeeza. ");
INSERT INTO sbs_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Mwizive izi, va ma manikizo kava ve ventanzi, ventanzi kavave va ma manikizo. ");
INSERT INTO sbs_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Che nakozana Vafarisi chiveza mi chivati kwali, “Yende mi wikale kunu kakuti Heroda usaka ku kwi haya. ");
INSERT INTO sbs_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesu chati, Muyende mi mu ka wambile zuna Luwawa, “vone, ni zwisa madimona, ni kuhoza va lwala sunu, ni zona ni lya vutatu ni sika ku mamani a musevezi wangu.' ");
INSERT INTO sbs_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Linu ni hakuva vulyo, kuni swanela ku zwila havusu lya sunu, sina haku sa zumi ninwe kwi haya mupolofita kule ni Jerusalema. ");
INSERT INTO sbs_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalema, Jerusalema, wi haya va polofita ni kuva zinda mavwe avo vava tuminwa kwenu. Chini lakaza ku kunganya vaana venu sina uvu inkuku ikunganya vaana vayo mu mavando, kono ka mu lakazi vulyo. ");
INSERT INTO sbs_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Voone, inzuvo yako ikendetwe. Ni wamba kwako, kete uni vone konji chi wati,' Imbuyoti nji yozo yo keza mwi zina lya Simwine Reeza.” ");
INSERT INTO sbs_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Izuba limwi le Savata Jesu a vayendi muzuvo ya mukulwana wavafalisi kukalya inkonko, miva vaku mulolete. ");
INSERT INTO sbs_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mubone, habusu vwa kwe kuvena mukwame yava kulwala butuku bwa chirunta. ");
INSERT INTO sbs_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesu ava kumbili vene inzivo ya mulao ni vafalisi chati: Kana iswanelo kuti muntu yo lwala a olwe ku hozwa le Savata kapa ka ku oleki? ");
INSERT INTO sbs_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Imi vava tuntwele. Jesu ava muondi, ava muhozi, ni ku mulwila kuti ayende. ");
INSERT INTO sbs_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Cha wamba kuvali, njeni kwenu wina manaswisu kapa ipulu iwilile muchisima le Savata ya sati amu zwise muchisima? ");
INSERT INTO sbs_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kana vava oli kuha inkalabo kwezi zintu zonse. ");
INSERT INTO sbs_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Linu Jesu cha lemuha kuti ku vava memetwe vava liketeli kwi kala ku zipula zi sepahala, cha wamba che nguli, ku wamba nati kubali, ");
INSERT INTO sbs_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ha mu memwa ku mukiti weseso, kanzi mwi kali ku zipula zi sepahala, kuola kuva ni muntu yo memetwe wina mazimo ahita enu. ");
INSERT INTO sbs_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Linu zuna muntu yava mi memi mu vonse ha sika, uwola ku milwila kuti muhe uzu mwi chi baka chenu; Linu che nsoni ka muhinde chipula cha hansi. ");
INSERT INTO sbs_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Linu ha mu memwa muyende ukekale ha chabaka cha hansi nji kuti zuna wa mi mema ha sika mwati kwenu mukwangu, zimane uzwe mu chaba cha hansi uke kale mu chabaka heulu.' ");
INSERT INTO sbs_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Linu kamu kutekehe ha vusu vwa vantu vonse vekele hentafule nanwe. Yense muntu uli nuneka kabozwe mwi sule.” ");
INSERT INTO sbs_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesu chata ku mukweme ya va mumemi kuzilyo za musihali kapa za chitengu, sanzi mu memi va likani niva kwenu, kapa muntu muhumanehi imu vambene naye chinanga amimeme naye, cho kuti kamulihiwe. ");
INSERT INTO sbs_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kono hova ni zilyo zi chitengu umeme vashebete, zihole, vasayendi ni vasaboni, ");
INSERT INTO sbs_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Imi mo fuyolwe, kakuti kavaoli kuku vozekeza chimwi kapa kukuliha. Mukuti, molihiwe kenako yoku vaka kuva shiyeme.” ");
INSERT INTO sbs_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Imi zumwi yabekele ni Jesu hentafule hazuwa zonse izi zintu abati kuti ufuyolwete yete nalya inkoko mu mubuso we Reeza!” ");
INSERT INTO sbs_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Imi Jesu chata kuti zinwi mukwame, “Ava lukisi zilyo ze chitengu ni kumema bantu bangi. ");
INSERT INTO sbs_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Imi zilyo hazi lukiswa, avatumi zumwi kuvahikana vakwe kukasumpa bonse vamemetwe, 'Mwize, kakuli zonse zintu chiza shiama. ");
INSERT INTO sbs_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Bonse chi vatanga kuha mavaka. Wentazi avati kwali, niva uli iwa, nisaka kuyenda nika libona, ni ondele. ");
INSERT INTO sbs_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Linu zumwi naye chata kuti niva uli mapulu atenda ikumi ni saka ku ka atapisa, ni ondele. ");
INSERT INTO sbs_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Linu zumwi naye chata kuti, 'nji ni sesa hanu, kani oli kusiya va mwihetu, ni ondele kani oli kwiza.' ");
INSERT INTO sbs_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Muhikana ava ka voli kwa nfumwe kwiza kumu wambila zintu zonse. Linu nfumwakwe cha venga ni ku wamba kuti azwe ayende mu ma kululu onse e tolopo ni kuka leta va shebete, zihole, va sayendi mane navana va saboni, ");
INSERT INTO sbs_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Muhikana chati, nfumwangu, zova ni tumi zi petehele linu kusina chivaka cingi.' ");
INSERT INTO sbs_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nfumwakwe chati ku muhikana wakwe, 'Yende mu makulu makando onse uka sumpe vonse cho kuti inzuvo yangu izule. ");
INSERT INTO sbs_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Linu niti kwako, kakwina kwavo vakwame vava memetwe yete na sole zilyo zangu zi chitengu.'” ");
INSERT INTO sbs_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Linu chisi chi va ku yenda naye, cha chevuka, chati ku vali, ");
INSERT INTO sbs_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Yense wiza kwangu yasa toyete vesi, vanyina, vamihyabwe, vana, vamukulwe ni va nchizye - initi, ni vu halo vwakwe, ka woli ku va mulutwana wangu. ");
INSERT INTO sbs_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yense ya sa woli ku kulilka muziyo wakwe ni kwiza kwa ngu ka woli ku vuba mulutwana wangu. ");
INSERT INTO sbs_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Njeni kwenu, yo lakaza ku zaka itawala, ya sa oli kwikala hansi ni ku hupula kapa, wina zi swanela ku mana ku mana muzako wa kwe. ");
INSERT INTO sbs_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Hamwi, chatanga kete a wole ku mana, vonse vete ni vavone kava tange kumu somoza, ni vati, ");
INSERT INTO sbs_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","'Uzu mukwame ava tangite ku zaka linu kana ava woli ku mani.' ");
INSERT INTO sbs_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Simwine nzi, yoya ku kulwa ni simwine zu mwi, ya sati ne kale hansi kapa ku kumbila intuso ku vamwi, ku vona kapa u wola kuya ku nkondo ni va kwame va likana zikiti zina ikumi, ni zumwi simwene yo keza ni mpi ina zikiti zina makumi ovele? ");
INSERT INTO sbs_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Linu heva ka njo vulyo, linu impi imwi ni sina kule, ka tumine muzimani zumwi ku ka ziminzana zikozo. ");
INSERT INTO sbs_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Cho kuti, linu, yense kwenu ya siyi zonse za kwate kete na wole kuva mulutwana ngu. ");
INSERT INTO sbs_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Mwinyo mu lotu, linu heva mwinyo ha u sampuka, ka u lungwe vule? ");
INSERT INTO sbs_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Linu ka kwina intuso kwi yevu nanga mu sutelo u lindikitwe. Ka u soiwa vulyo. Yense wina matwi aku zuwa, azuwe.” ");
INSERT INTO sbs_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Linu vatelisi vonse ni vamwi vaezalivi vavakezite kwa Jesu kukuteka kwali. ");
INSERT INTO sbs_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","vonse vafalisi ni vañoli vava kuñuñu, nivati, “Uzu mukwame u tambula vaezalivi, mi mane ulya navo.” ");
INSERT INTO sbs_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jesus avawambi iyi inguli kuvali, nati, ");
INSERT INTO sbs_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Njeni kwenu, haiva wina imberere zina makumi ekumi imi yonke izova, kete usiye imberere zina makumi akwana iyanza ni makumi one kuvika zikwana iyanza ni zone mwinkanda, nikwichilila ya zova haisi hokayiwana? ");
INSERT INTO sbs_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Linu cwale hayiwana, u yi kulika hamaheta ni kusanga. ");
INSERT INTO sbs_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Hakeza kwi nzuvo, usumpa valikani ni niva vambane nivo, nati kuvali, musange nime, nakawana imberere se izovete.' ");
INSERT INTO sbs_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Niwamba kwenu nihakuva vulyo, mukuve nikusanga mwi ulu nihaiva muezalivi yenke halitekula, kuhita vantu vena makumi akwana iyanza ni one kuvika vakwana iyanza ni vone vasiyeme vasa lili kulitekula. ");
INSERT INTO sbs_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Kapa zuna mwanakazi yavena muwayawaya we silivela i kwana ikumi, kuti azovelwe hateni yonke, kete a munike i lambi, kufiyela inzuvo, kungana kavutali kutwala chawana muwayawaya. ");
INSERT INTO sbs_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Mi linu hauwana, u sumpa balikani ni vekala he mbali yakwe, nati, musange name, nawana muwayawaya wangu se uzovete. ");
INSERT INTO sbs_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","nihakuba vulyo, niwamba kwenu, kwina kusanga mukuva kwa mangeloi e Reeza muezalivi yenke ha litekula. ");
INSERT INTO sbs_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Linu Jesu chati, mukwame zumwi avena vanaswisu vovele, ");
INSERT INTO sbs_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","mi wachinini cha wambila isi, 'Ita, munihe chanda cha chifumu chiwila kwangu,' chava kauhanyeza zibya zakwe. ");
INSERT INTO sbs_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kena kuvahiti mazuba mangi, wachinini cha kunganya zibya zakwe zonse hamwina zavayoli ni kuya kwinkanda imwi kule, mi uko avaka sinyi mashelinyi akwe, cha kaula zintu zisena itunso, avashinyi mashelenyi akwe muzintu zenkanda. ");
INSERT INTO sbs_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Linu hanu hashinya zintu zonse, inzala ikando ibatasezi inkanda yonse, mi chava ni ntakazo. ");
INSERT INTO sbs_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Cha yenda ni ku kaseveza ku zumwi yava kuhala mweyo inkanda, yava mutumi kuluwa ku kaha ziguluve zilyo. ");
INSERT INTO sbs_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mi navatavi kukalya zilyo ziva kuliwa ziguluve kakuti kakwina yava kumuha zilyo. ");
INSERT INTO sbs_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kono mwan'a swisu wa munini ha ka volelwa ingana, cha wamba, vongayi kuvahikana vaseveza kuva ndanda vena zilyo zingi luli, mi nina kunu, nini fwa inzala! ");
INSERT INTO sbs_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Munizwe kunu mi ni yende kuva ndanda, mi mu ni kawambe kuvali, “Ita, ni bafosekezi iwulu, ni mu menso enu. ");
INSERT INTO sbs_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Kaniswaneli kusumpwa kuti ni mwanenu, mu ni pange feela nibe ni muhikana wenu. ");
INSERT INTO sbs_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Cwale mwan'a swisu wamu nini cha katuka, ni kukeza mubusu bwe isi, ha ba kusina kule, isi cha mu vona, mi chali zuwa masisi, mi cha mutilila ni ku mutula manza ni ku muchunchuna. ");
INSERT INTO sbs_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","mwan'a swisu chati kwali, Ita, ni vafosekezi muvuso weulu ni ha menso enu. Ka ni swaneli kuti ni sumpwe kuti ni mwana nenu. ");
INSERT INTO sbs_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Isi chati kuva hikana vakwe, 'Mulete kapilipili inguvo indende indotu, mu mu zwatike, mi mu mu zwatike iseka kumunwe, mu mu zwatike ni nsangu kuma tende. ");
INSERT INTO sbs_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Linu mulete inamani inunite twi ihaye. Tu lye mukiti! ");
INSERT INTO sbs_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kakuti mwanangu wa mususwi ava fwile. mi hanu u hala, ava zovete, hanu cha wanika. mi chi va sangwa. ");
INSERT INTO sbs_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Linu mwana swisu wa mu kulwana avena kuluwa, ha sika hafuhi ni munzi, ava zuwi inzimbo nikuzana, ");
INSERT INTO sbs_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Cha sumpa zumwi wa va hikana ni ku muvuza kuti izi zintu zi wola kuva chinzi. ");
INSERT INTO sbs_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Muhikana cha mu wambila, mwancako weza mi veso vamwi haila inkomwana inunite, kakuti wa kavola na liketete. ");
INSERT INTO sbs_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mwan'a swisu wa mukulwana ava vengi, mi kana avayendi mukati, mi vesi va vakezi hanze, ni kwiza ku ku mu kombelela, ");
INSERT INTO sbs_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kona che tava isi chati, vone, zonse izi zilimo zi ni va kusevelezi, mi kena ni vacholi mulao wako, mi nahanu kowini ku niha ni haiva kampene kanini kuti nilitavise ni valikani vangu. ");
INSERT INTO sbs_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kono mwanako heza, ya vaali chifumu ni vanakazi va mahule, u va mwi hayili inkomwana inunite. ");
INSERT INTO sbs_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Vesi chiva wamba kwali, 'Mwanangu, wina name inako yonse, mi chonse cheli changu nji chako, ");
INSERT INTO sbs_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kono ni kwava hande kuti tusange ni kutava, kakuti mwancako ava fwile mi hanu chahala; ava zovete, mi hanu cha wanika. ");
INSERT INTO sbs_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesu naye cha wamba valutwana vakwe, “Kuvena mukwame wa muhumi avena muyendisi wa misevezi yakwe, mi kuva vihiwa kuti muyendisi wa misevezi ya kwe u kwete ku mu sinyeza iluwo lya kwe. ");
INSERT INTO sbs_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Cwale muhumi cha musupa mi chati kwali, 'Zintu nzi zi nizule kuamana niwe? U nihe chakwizula za musevezi wako, ili kuti kese uzwile havusu ni vuyendisi.' ");
INSERT INTO sbs_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Muyendisi cha liwambila, 'chiniswanela kupanga chinzi, hakuva mukulwana choni zwisa musevezi? Ka nina ziho za kusha, mi niswava ku mukumbila. ");
INSERT INTO sbs_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nizi chini swanela ku tenda, ili kuti china zwiswa ha musevezi wangu wa vu yendisi, bantu va ni tambule mu mazuvo avo. ");
INSERT INTO sbs_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Cwale muyendisi chasupa zumwi ni zumwi ya vaali kukolota si mwin'a kwe, mi cha vuza we ntazi, 'U kolota vukayi simwin'a ngu? 6. ");
INSERT INTO sbs_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Cha wamba, 'Ni kolota makumi ekumi ya byima bya mafuta e oli.' Mi chati kwali, muhinde zikoloti zenu, mwikale kapili, mi muñole makumi akwana yanza.' ");
INSERT INTO sbs_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Cwale muyendisi cha wamba ku zumwi, 'mi vukayi yo kolota?' Chati, 'makumi ekumi a vuyima bwa vuroto.' Chati kwali, 'hinde chikoloti mi u ñole makumi akwana yenza ni to tatwe. ");
INSERT INTO sbs_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Simwin'a kwe cha lumba chikombwa chi sa sepahali kakuti ava sevezi mu kusasepahala. Vaana ve fasi ilyi vena ahulu mukusa sepahala chiva kwete kuseveza ni vantu vavo hita vaana vena mu liseli. ");
INSERT INTO sbs_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ni wamba kwenu, mutende valikani che nzila za mashenyi a sa sepahali, kutendela kuti chi bwamana, va woole ku mitambula mu mazuvo asamani. ");
INSERT INTO sbs_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Iye yo sepahala ku zinini mwa sepahale ni ku zikando, mi niya sasepahali mu zinini kasepahali mu zikando. ");
INSERT INTO sbs_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Haiva kena u va sepahali ku ku sevelisa mashelenyi a fosahele, nje ni yeta kusepe mu chifumu che niti? ");
INSERT INTO sbs_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mi haiva kawini ku sepahala mu kusevelisa mashelinyi a vamwi, njeni ya sa kuhe mashelenyi ako u mwine? ");
INSERT INTO sbs_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ka kwina muhikana yo wola ku seveleza malena vo vele, kusicwalo mwa toye umwi ni kusaka zumwi, mwa kumalele umwi kapa kunyefula zumwi. Ko woli kuseveleza Ereeza ni chifumu. ");
INSERT INTO sbs_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Hanu Vafalisi, va vali kusaka hahulu mashelenyi, va va zuwi zoose inzi, mi chi va museka. ");
INSERT INTO sbs_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Mi chati kuvali, “Mu li shiyamisa mu menso a vantu, kono Ireeza wizi ikulo zenu. Zina zivoneka vulotu mumeeso a vantu kwe Reeza zi fosahele. ");
INSERT INTO sbs_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mulao ni vupolofita ziva kuseveza kuleta Johani hasika. Ku zwa iyo nako, inzwii lya muvuso we Reeza li va kutazwa, mi zumwi ni zumwi ava sa kuhambiliza inzila za vo mwateni. ");
INSERT INTO sbs_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kono kuhuva kwiwulu ni hansi zi mane isi kuti intaku imwi ya mulao sanzi ivi ni mutendo. ");
INSERT INTO sbs_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Yense yo kauhana ni mwanakazi wakwe ni kusesa zumwi u chita vushahi, mi yo sesa mwanakazi ya va kanwa kwa mwihyabwe naye utenda vushahi. ");
INSERT INTO sbs_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Linu ku vena mukwame ya va humite, ya va kuzwete zi zwato ze pulipera ni line mi mazuva onse ava kulikola chifumu cha kwe. ");
INSERT INTO sbs_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Mukumbizi ava kusumpwa Lazaro ava lele hamulyango, avali kwizwile zilavi muvili wonse. ");
INSERT INTO sbs_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Mi avali kuhala kulya vungululwa vu vali kuwa hentafule ya muhumi, mi kuzwaho, vambwa va vali kukomba zilavi zakwe. ");
INSERT INTO sbs_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ku vezi kuva kuti mukumbizi chafwa, mi avezi ku hindwa mangeloi ku mutwala kwimbali ya Abrahama. Muhumi naye chafwa mi cha zikwa, ");
INSERT INTO sbs_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","mi mu lyangalilo, na sukulukite, cha kotola menso mi cha vona Abrahama nena vutavule ni Lazaro nena ha chizuva chakwe. ");
INSERT INTO sbs_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Cha lila mi chati, Tayo Abrahama, uni zuwile kusasama, mi tumine Lazaro, kuti a tompe munwe wakwe mu menzi mi nja tontoze lulimi lwangu, kakuti ni hile maswe mowu mulilo. ");
INSERT INTO sbs_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Kono Abrahama chati, 'mwan'a ngu, u hupule kuti muvuhalo bwako uva tambuli zako zilotu, mi Lazaro mwinzila iswana ava ku tavela zintu zivilala, kono hanu cho kwete kusengwa sengwa kunu, mi iwe wina mumanyando. ");
INSERT INTO sbs_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Mi kuzwaho zintu zoose, chigodi chikando chivavi mukati, ili kuti avo vasaka kuluta kuzwa kunu kwiza kwako kese vawole, mi kakwina yese awole kuzwa uko kwiza kwetu.' ");
INSERT INTO sbs_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Muhumi chati, ni ku kumbila, Tayo Abrahama, kuti umuni tumine kuzuvo ya tayo ");
INSERT INTO sbs_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kakuti nina vanche vava swisu va tenda yanza - kutendela kuti akava kalimele, kutiya kuti navo chiveza mwe chi chivaka cha masukuluka.' ");
INSERT INTO sbs_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Kono Abrahama chati, veena Mushe ni vapolofita; mu vasiye va tekeleze ku vali.' ");
INSERT INTO sbs_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Muhumi che tava chati, 'Nanta, Tayo Abrahama, kono haiva zumwi na yenda kuvali kuvafwile, mu va lichiule.' ");
INSERT INTO sbs_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Kono Abrahama chati kwali, 'Haiba ni vasa tekelezi kwa Mushe ni vapolofita, kese vaole kuzumina ni haiva vafwile kuti va vuke.'” ");
INSERT INTO sbs_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesu chati kuva lutwana bakwe, “kwina kusakusimwa mukuve ni zintu zete ziwole ku tuletala ku tenda chivi, kono kwina vumai koozo muntu kwete ni zize! ");
INSERT INTO sbs_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ni kuvavi ni vutuka kwali haiva ivwe ikando nili vikwa kuzimbuluka insingo yakwe mi na va sohelwa mwi wate, kuhita kuti a letele zumwi kwava va nini kuti sanzi a sihwa inkulo. ");
INSERT INTO sbs_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mulitokomele muvene. haiva mukwako va chita chivi, mu kalimere, mi cha linyansa, mu wondere. ");
INSERT INTO sbs_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Hachita chivi kwako kusikahe yanza ni tovele mwizuva, ni yanza ni tovele na vola kwako, nati, 'na linyansa,' u swanela ku mu kumu wondera!” ");
INSERT INTO sbs_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Vaapositola va vati kwa Simwine, yekeze intumelo yetu. ");
INSERT INTO sbs_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Simwine chati, kamba muvena intumelo uvu lutanga lwa masitete, ni mu vawambi izi kwi samu lye feiga, U nyukuke, mi ukavwalwe mwi wate,' mi nili vami kukuteki. ");
INSERT INTO sbs_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Kono njeni kwenu, yo wina muhikana yolima kapa kilisa i mberere, yeta wambe kwali haka vola kuzwa kuluwa, 'wize kavu hweluhwelu mi zo wikale tulye'? ");
INSERT INTO sbs_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Keta wambe kwali, ni vakanyeze zakulya, mi mu sumine mambanti mi munihe kutwala china mana kulya nikunwa. linu kuzwa aho njete mulye ni kunwa'? ");
INSERT INTO sbs_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kalitumeli ku muhikana mukuti watenda ziva laitwe, utenda? ");
INSERT INTO sbs_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ni hakuva vulyo iwe, hete chiwa wamana zonse zova laitwe, mu wamba, tu vahikana va sena intuso. Twa tenda vulyo ze zi tu telwe kuti tu tende. ");
INSERT INTO sbs_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","kuva kezi kuva kuti ha ya kwa Jerusalema, ava hiti vulyo mwi nyinza ya Somaria ni Galilea. ");
INSERT INTO sbs_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ha va ke njila mu kamwi kanzi, ava katanwa vakwe vena ikumi va lwala imbingwa, va va zimene vatavule naye ");
INSERT INTO sbs_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","chi va katula manzwii avo, nibati, “Jesu, Nfumwetu, tufwile insoni. ");
INSERT INTO sbs_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ha va vona, chati ku vali, “Mu kali vona haze ku Muprista.” kuvezi kuva kuti hava yenda, chi va jolozwa. ");
INSERT INTO sbs_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","zumi kuvali havona kuti cha hozwa, cha vola li nzwi linyemukite na temba Ireeza. ");
INSERT INTO sbs_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Cha kuvama hamatende a Jesu, nali tumela kwali, avali Musamaria. ");
INSERT INTO sbs_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Mi che tava, Jesu chati, “Kana vena ikumi va va jolozwa? Vena Iyanza ni vone vena kuhi? ");
INSERT INTO sbs_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ka kwina vamwi va vola kwiza kutemba Ireeza. Kunde yo zu muzwakule?” ");
INSERT INTO sbs_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Cha wamba kwali, zime, mi uyende. Intumelo yako ya kuhoza. ");
INSERT INTO sbs_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Cha vuzwa Vafalisi muvuso wa Ireeza ukeza lili, Jesu cha veta mi chati, “Muvuso wa Ireeza kaukezi ni mu uli tekele. ");
INSERT INTO sbs_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kau woli kuwambiwa kuti, 'Lole kunu!' kapa, 'Lole kuna!', Muvone, Muvuso wa Ireeza wina mwenu.” ");
INSERT INTO sbs_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Cha wamba ku valutwana, Mazuva a keza heti ni mutavele kuvona izuva lyonke ku mazuva a Mwana mutu, kono kete mu avone. ");
INSERT INTO sbs_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Linu kava wambe kwenu, 'Muvone, kuna! Muvone, kunu!' Kono sanzi muyi hanze kapa kuve chilila, ");
INSERT INTO sbs_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","imi mumuni kauvenya kwimwi imbali ye wulu ku twala ku yimwi imbali ye wulu, mukuve bulyo ni ku Mwana Muntu mwi zuva lyakwe. ");
INSERT INTO sbs_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kono che ntazi uswanela ku sukuluka mu zintu zingi ni ku kanwa kolu lusika. ");
INSERT INTO sbs_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Sina mu ku vatenda halili ku ma zuva a Nuwe, mwete ni ku tendahalele mu mazuva a Mwana muntu. ");
INSERT INTO sbs_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Va valyi, va vanwi, va vasesi, ni kusesisa, kutwala Nuwe he njila mwa Areka - mi chikweza munda mukando ni kwiza kuveha vonse. ");
INSERT INTO sbs_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Sina vulyo mukuvapanga halili ku mazuva a lota, va valyi, kunwa, ku ula, ku wuza, ku vwala, ni ku zaka. ");
INSERT INTO sbs_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kono izuva lya zwa lota mwa Sodoma, mulilo uva soki ni silufula kwi wulu mi va ve haiwa vonse. ");
INSERT INTO sbs_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","kuzwa ku mukwa uswana kuve vulyo ni mwi zuva lyete a voneke Mwana muntu. ");
INSERT INTO sbs_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Mwe lyo izuva, wina he wulu lye nzovo sanzi ashetumukeli mwate ku kahinda chifumu chakwe. Mi yo wina muluwa sanzi avoli. ");
INSERT INTO sbs_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Muhupule mwihavwe wa lota. ");
INSERT INTO sbs_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Yense yo saka kuwana buhalo vwakwe mwa vu sinyehelwe. Kono yonse yo sinyehelwa vuhalo vwakwe ka vu vusilele. ");
INSERT INTO sbs_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nimi wambila, mwawo masiku, mukuve ni bantu vovele hamumbeta wu mwina. Umwina ka hindwe, mi umwina ka shale. ");
INSERT INTO sbs_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ka kuve ni vakulwakazi vo vele vete va kutwa hamwina. Umwina mwa hindwe, mi umwina mwa shale.” ");
INSERT INTO sbs_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Vo vele muluwa, umwina mwa hindwe, mi umwina mwa shale. ");
INSERT INTO sbs_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Chiva muvuza, “Kuhi, Simwine? Mi chati kuvali, “Kwina muvili, njoko makuvi nao kwete aka kunganele. ");
INSERT INTO sbs_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Linu cha wambe nguli kuvali muva swanelela ku lapelela mi kanzi va zwafi ku wamba vulyo, ");
INSERT INTO sbs_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","kuvena muleneñi u mwi mukuvena, Mwatuli ya sana vali kutiye Ireeza ni kusa kuteka vantu. ");
INSERT INTO sbs_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Linu ku vene Imbelwa mu muleneñi mi i vali kwizanga, nati, unituse ni wane ku atulelwa kozo ini zeka naye.' ");
INSERT INTO sbs_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Chenako nde kana va tavele ku mutusa, linu chenako zana chati, kwali iye mwine, nga kuti kani tiiyi Ireeza nanga ku kuteka vantu. ");
INSERT INTO sbs_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Linu uzu mukulwakazi we Mbelwa yoni kateze. Linu, kani mutuse ku nkatulo, ili kuti kanzi ani katazi kwi zanga kwa ngu.”' ");
INSERT INTO sbs_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Linu Ireeza chati, Muzuwe, mutekeleze ku mu atuli za wamba. ");
INSERT INTO sbs_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Linu Ireeza kete ashemuve va ketetwe, avo va lilila kwali masiku ni musihali? Na, kana mwa liyehe ku vali? ");
INSERT INTO sbs_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ni mi lwilite kuti ka shemuve vonse cha kuli tahanela Ni hakuva vulyo Mwana a Mukwame cheza, Chavu saku sima, keze a wane ntumelo mu nkanda?” ");
INSERT INTO sbs_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Linu haho cha wambe, nguli ku vamwi avo vava shushwezwa avo vene kuva va shiyeme imi vavali ku sheununa vamwi vantu, ");
INSERT INTO sbs_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Va kwame vo vele, vava yendi mwi Tempele kuku lapela zu mwi avali Mufalisi zu mwi avali Mutelisi. ");
INSERT INTO sbs_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mufalisi cha zima ni ku lapela manzwi aa kwali iye mwine, Ireeza, ni litumela kwako, ka kuti kani swani sina vantu vamwi vasa, va sa jolwele, mahule, kapa uzu Mutelisi. ");
INSERT INTO sbs_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nili nyimanga zilyo tovele mwi nsunda, ni zwisanga vulishumi ku zonse zini wana.' ");
INSERT INTO sbs_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Kono Mutelisi, Na zimene vuta vule, na sa oli nanga ku nyamuna Menso akwe kwi ulu, na kwete kuli kava- kava achizuva, nati Ireeza, uni zuwile nkulo vutuku, ni tenda zivi.' ");
INSERT INTO sbs_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Niti kwako, uzu Mukwame ava voli kunzuvo yakwe na jolwezwe Kuhita mwakwe, cho kuti muntu yense yo likatula iye mwine ka vozwe haansi mi yo likokoveza iye mwine ka kakatulwe.” ");
INSERT INTO sbs_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Vantu vava kuleta kwali ni va hwile vavo, ili kuti ava wonde, kono linu va rutwana nga vavona vulyo vava va kalimeli. ");
INSERT INTO sbs_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Lino Jesu chava sumpila kwali, naati, “Muzuminine va hwile kukeza kwa ngu, mi kanzi mu vakanisi kwiza kwa ngu. Imi Muvuso wa Mulimu nji wavo vaswana navo. ");
INSERT INTO sbs_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Chavu sakusima, niti kwenu, yense ya sate a amuhele muvuso we Ireeza sina munini, kete, enjile mumu vuso we Ireeza.” ");
INSERT INTO sbs_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Muvusi zumwi cha mu vuza, nati, Muruti mulotu, moni tende vule kuti ni luwe muvuso we Ireeza?” ");
INSERT INTO sbs_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesu chati kwali, uni sumpilazi Mulotu? kakwina muntu mulotu, kwande Ireeza yeke. ");
INSERT INTO sbs_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Wizi milao ine kumi, kanzi uvuki, kanzi wihai, kanzi wi vii, kanzi uhi vupaki vwa mapa, ukuteke veso ni va nyoko.” ");
INSERT INTO sbs_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Muvusi chati, zonse zo chini va, zikuteki kuzwilila ku vu lombwana bwangu.” ");
INSERT INTO sbs_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Linu Jesu nga zuwa bulyo, cha muwambila nati kwina chonke chosena uswanela ku uza zako zonse zokwete ni ku yavelela va votana, mi ko wane chifuma cha kwi ulu, linu wize uni chilile.” ");
INSERT INTO sbs_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Linu Muhumanehi nga zuwa izi zintu. Chava yo swavite ahulu. Sina avali Muhumanehi ahulu. ");
INSERT INTO sbs_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Linu, Jesu cha muvona kuti uswavite ahulu mi chati, ku kukutu vule kwavo, va humanehi kukwinjila mumu vuso we Ireeza! ");
INSERT INTO sbs_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Imi ku huva ku nkamele kuku njila mulinso lye ndonga, ku hita mu Humanehi kwinjila mumu vuso we Ireeza.' ");
INSERT INTO sbs_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Avo vava tekeleze chivati, linu nji vani vete va puluswe? ");
INSERT INTO sbs_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","“Jesu chee tava, nati zintu zisa woliki ku vantu zi woleka kwe Ireeza.” ");
INSERT INTO sbs_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pitrosi chati, “linu, tuvasiyi zintu zonse zivali zetu ni kukwichilila.” ");
INSERT INTO sbs_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesu cha wamba kuvali, Chavu sakusima, ni wamba kwenu niti kakwina kwenu umwina ya vasiyi inzuvo yakwe kapa Mwihyavwe, kapa vana vakwe, nchizyakwe, kapa vashemi vakwe, vakeni cha muvuso we Ireeza. ");
INSERT INTO sbs_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Yasate atambule kuhitiliza muno'munkanda ni munkanda ikeza, muvuhalo vusa mani.” ");
INSERT INTO sbs_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Nga a kunganya va rutwana vakwe vene kumi, ni vovele, chava wambila nati, “muvone, chitukaya kwa Jerusalema mi ni zintu zonse ziñoletwe ku vapolofita cha Mwana Mukwame kazi zuzilikizwe. ");
INSERT INTO sbs_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kakuti kahewe mu manza avo vasezi Ireeze. mi, kava musomoze ni ku musheununa kumunyandisa ni kumu swila mate. ");
INSERT INTO sbs_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Chiva mushimeha ni kumwi haya mi mwi zuva lyavu tatu ka vuke hape.” ");
INSERT INTO sbs_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kena vava zuwisisi chimwi kwezi zintu mi aya manzwi ava humbitwe kuvali, mi kana vava zuwi mwi zintu zava wambi. ");
INSERT INTO sbs_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ku vezi vulyo sina Jesu chava atumele munzi wa Jeriko, mukwame wa chivofu ave kele hembali ne kululu na vu kumbila kuvantu, ");
INSERT INTO sbs_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","cha zuwa inyangela ni hitite, cha vuza ziva ku tendahala, ");
INSERT INTO sbs_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","chiva muwambila kuti nji Jesu wa Nazareta yo hitite he mbali. ");
INSERT INTO sbs_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Linu, Mukwame wa chivofu cha, huweleza, nati, “Jésu Mwana Davida, uni fwile nkumbu.” ");
INSERT INTO sbs_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","vamwi vavali kwenda avusu, chi va mu kalimela Mukwame wa chivofu, ku muwambila kuti atontole. Kono nja huweleza kuhitiliza, Mwana Davida, uni fwile nkumbu.” ");
INSERT INTO sbs_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesu cha zimana ni kulaela vakwame kuti vamu lete kwali. Linu mukwame wa chivofu avena hafwi, Jesu cha muvuza, ");
INSERT INTO sbs_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Usaka kuti ni kutendele nzi?” chati, “Simwine nisaka ku hewa ku vona.” ");
INSERT INTO sbs_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesu chati kwali, Linu tambule ku vona. Intumelo yako chi ya kuhoza.” ");
INSERT INTO sbs_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Chenako imwina chata mbula ku vona mi cha mwi chilila, nakavu lumbeke Ireeza. Ha kuvonwe zi, Vantu vonse chiva tanga kulumbeka Ireeza. ");
INSERT INTO sbs_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesu abe njili ni ku hita mukati ka Jeriko. ");
INSERT INTO sbs_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Imi, kubena mukwame aba ku sumpwa Zakia. A bali mukulwana ku balihisi mi a baku fumite. ");
INSERT INTO sbs_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","A ba kulika ku bona kuti kanti Jesu njeni, kono kana aba kuwola kubona kwi shila lye chikwata, bakeñi cha kuti abali mufwihi. ");
INSERT INTO sbs_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Mi cha tilila ku busu bwa bantu ni kukantanta kwi isamu lya sikomore kuti amubone, kakuti Jesu kwa bakuhitila. ");
INSERT INTO sbs_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Mi Jesu ha sika hecho chibaka, cha lola kwiwulu mi cha muwambila kuti, “Zakia, suke hansi kakuhwela, mukuti sunu ni kekala kwi nzubo ya ko.” ");
INSERT INTO sbs_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Cha suka kapili, kwi za hansi mi chamutambula na tabite. ");
INSERT INTO sbs_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mi bantu haba bona vulyo, chi ba bilela, chiba wamba, “Cha yenda kukupotela mukwame wina chibi.” ");
INSERT INTO sbs_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakia cha zimana mi cha wamba kwe Ireeza kuti, “Bone, Ireeza, ni bahi imbali yimwi ye ntuntu yangu kubanjebwe, mi heba kwina yenke uni bachengeleli ni chimwi, ka nimu bozekeze zone.” ");
INSERT INTO sbs_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesu cha wamba kwali, “Sunu i puluso yeza mwi nzubo yako, kakuti nawe u mwana wa Abrahama. ");
INSERT INTO sbs_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mukuti Mwana a Muntu a ba kezi ku gana ni ku haza bantu ba zobete.” ");
INSERT INTO sbs_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mi haba zuwa izo zintu, cha zwila habusu ku wamba mi na wamba che nguli, kakuti cha bena hafwihi ni Jerusalema, mi baba kuhupula kuti mubuso we Ireeza chiu bena hafwihi ni kwiza. ");
INSERT INTO sbs_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Cha wamba, “Zumwi kuluzubo lwa busimwine cha yenda kule mwi nkanda kukali wanina mubuso ni ku kabola.” ");
INSERT INTO sbs_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Cha sumpa i kumi lya bahikana ba kwe, cha baha ikumi lye pondo lya masheleni, mi cha wamba ku bali kuti, “Mu pange mu ku wuza ku lindila chi naka bola. ");
INSERT INTO sbs_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Kono ba mushobo wakwe chi ba mutoya mi chi ba tumina chikwata chabazimanini mwisule lyakwe, mi ni ba wamba kuti, “Kese tu siye uzu muntu kuti atu yendise.” ");
INSERT INTO sbs_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Chi zapangahala haka bola hape, ha mana kuka wana mubuso, cha laela bahikana abo baba hewa masheleni kuti basumpwe kwali, kuti eze ezibe kuti kanti nji bukai ibaba wani yahewulu ha baba ku wuza. ");
INSERT INTO sbs_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","We ntanzi cheza kwali, na wamba kuti, “Ireeza, ha masheleni ako ni ba pangi ikumwi lya masheleni hewulu, ");
INSERT INTO sbs_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Yo zwa kuluzubo lwa busimwine cha wamba kwali kuti, “Wa tenda hande, u mu hikana yo shiyeme. Mukuti uba sepahali kuzintu zi nini, ko be imu yendisi hewulu lyekumi lya mileneni.” ");
INSERT INTO sbs_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Mi wa bubeli cheza, na wamba kuti, Ma masheleni ako, Ireeza, aa panga i yanza lya masheleni hewulu. ");
INSERT INTO sbs_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Yo zwa haluzubo lwa busimwine cha wamba kwali kuti, ko yendise i yanza lye mileneñi.” ");
INSERT INTO sbs_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Hape zumwi cheza, na wamba kuti, “Ireeza, masheleni ako aa, ni baabikite mwi njiila, ");
INSERT INTO sbs_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","kakuti ni ba ku tiite, mukuti u muntu yo bambamite. U hinda mosana uba biki, mi u sinza mosana u ba byali.” ");
INSERT INTO sbs_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Wa luzubo lya busimwine cha wamba kwali kuti, “kachi wambo chako ka ni ku atule, iwe muhikana mubi. U bezi kuti ime ni muntu yo bambamite, ni hinda ha ni sana ni ba biki, mi ni sinza mu ni sana ni babyali. ");
INSERT INTO sbs_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Mi chinzi ho sana u ba biki masheleni angu mwi banka, kuti ime chi na kabola, nize ni ahinde ni chimwi hewulu?” ");
INSERT INTO sbs_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Wa luzubo lwa busimwine cha wamba ku bose baba zimene, “Mu hinde masheleni ena kwali, mi mumu he ikumi lya masheleni,” ");
INSERT INTO sbs_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Chi ba wamba kwali kuti, Ireeza, wina kale i kumi lya masheleni. ");
INSERT INTO sbs_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ni wamba kwenu, muntu yese wina u swanezi kuhewa zingi, kono kwa kwe ya seena, niheba chi na cha kwete ka chi hindwe kwali. ");
INSERT INTO sbs_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kono zila zangu, abo ba sa ni suni kuti ni ni bayendise, mu ba lete kunu mi mwize mubehaye habusu bwangu.” ");
INSERT INTO sbs_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ha wamba izo zintu, cha zwila habusu, ku yenda kwa Jerusalema. ");
INSERT INTO sbs_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Hati cho chunine ha fwihi ni Bertifage ni Betania, helundu li sumpwa Oliveta, cha tuma balutwana bobele, ");
INSERT INTO sbs_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","na wamba kuti, “Mu yende ha munzi uwo wi chilila, mi chi mwe njila bulyo, ka muwane i mbongolo i seni kwi chilwa. Mu yisumunune mi muyi lete kunu kwangu. ");
INSERT INTO sbs_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Heba kwina yete ami buze, “Chinzi ha mu i sumununa? mu wambe kuti, Ireeza njo i suna.” ");
INSERT INTO sbs_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","A bo baba tumwitwe baba yendi ni kuka wana i mbongolo bo bulyo mwa ba wambili Jesu. ");
INSERT INTO sbs_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ha baba ku kwete ku sumununa i mbongolo, bene bayo chiba wamba ku bali kuti, “Chinzi ha mu sumununa i mbongolo?” ");
INSERT INTO sbs_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Chi ba wamba kuti, “Ireeza njo i suni.” ");
INSERT INTO sbs_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Chi ba kayi leta kwa Jesu, mi chi ba zala zizwato he mbongolo mi chi be tantika ho Jesu. ");
INSERT INTO sbs_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ha ba ba ku yenda, chi ba zala chizwato za bo mu nzila. ");
INSERT INTO sbs_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ha chunina ha chibaka cina zi samu ze olive, bungi bwa balutwana ci ba tanga ku luluweza ni ku temba Ireeza ka muhuwo mukando ka mitendo mi lontu yi baba boni, ");
INSERT INTO sbs_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ni ba wamba kuti, “Kutompwe simwine yo kezite mwi zina lye Ireeza! Kusanga ku be kwi wulu mi ikanya i be hewulu!” ");
INSERT INTO sbs_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Bamwi ku Bafalisi ba bena mu chikwata, chi ba wamba kwali kuti, “Muluti, kalimele balutwana bako.” ");
INSERT INTO sbs_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesu che taba cha wamba kuti, Ni mi wambila, heba aba ni ba ntontola, ma ñomwe ka a huwe.” ");
INSERT INTO sbs_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Cwale Jesu ha chunina ku muleneni, ca lila, ");
INSERT INTO sbs_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","na wamba kuti, Kambe u be zibite ze linu i zuba lya ko li ka kuletele ikozo, kono hanu zi patitwe ha menso ako. ");
INSERT INTO sbs_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mi mazuba ka akeze hewulu lyako, mi zila zako ka zi ku zimbuluse ni lukwakwa, mi zikuzimbuluke, ni kuku kakatiza imbali zose. ");
INSERT INTO sbs_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ka ba ku wisikize hasi iwe ni bana bako. Keteni ba siye ibwe hewulu lya limwi, mukuti kena u be zibi Ireeza ha ba kusuni ku kutusa. ");
INSERT INTO sbs_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesu che njila mwi keleke ni ku tandila hanze bonse baba ku wuza, ");
INSERT INTO sbs_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","na wamba ku bali kuti, “Ku ba ñoletwe, “I nzubo yangu ye ntapelo, kono inwe chi mwa yi tenda inzubo ya basa.” ");
INSERT INTO sbs_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Mi Jesu aba ku kutaza izuba ni zuba mwi keleke, ba kulwana ba Mapurisita, ni bañola mane ni bakulwana be cisi, ba ba ku saka ku mwi haya. ");
INSERT INTO sbs_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Kono kana ba ba wani inzila ya ku tenda bulyo, mukuti chisi chonse ci bakumalele ku muzuwa. ");
INSERT INTO sbs_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","kubezi zuba lyonke, linu Jesu abali kuluta ni kuwamba ku bantu mwi ntepele naluta Izwi, mukulwana wa mapulisita ni bamwi ba kulwana baba kezi kwali nibamwi ");
INSERT INTO sbs_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Baba wambi, chibati kwali, “utu wa mbile ma tanzi au kwete ku chita ezi zintu? Njeni uzo aba kuhi mata?” ");
INSERT INTO sbs_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Che taba nati kubali, “Name muni mibuze ipuzo. Muni wa mbile ");
INSERT INTO sbs_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","che nkolobezo ya Joani. Iba kuzwa kwiulu kapa ku muntu?” ");
INSERT INTO sbs_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Baba lielezi abobene, chibacho, “Chi twati, 'Izwa kwi ulu,' mwa wambe, 'chinzi ha musa zumini kwali?' ");
INSERT INTO sbs_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Linu chi twati, 'izwa ku muntu,' bonse bantu kaba tuñate, abo baba susu wezwa kuti Joani abali mupolofita,” ");
INSERT INTO sbs_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Linu chi betaba kuti kabezi kuzi ka zwa. ");
INSERT INTO sbs_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesu chati ku bali, “kese nimi wa mbile Inguzu zini chita izi zintu.” ");
INSERT INTO sbs_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Cha wambila bantu Inguli, “Muntu cha biala nzi chelantu zakwe muluwa, muntu aba kalimise luwa kuba viali bo muomba, ni kuya kwi nkanda Inako Inde. ");
INSERT INTO sbs_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Chi yasike nako chi kutuma bahikana kubabiali ba muwomba, muhe nzimwi nzi chelantu zizwa muluwa lo muwomba. Baba kutokomela luwa lo muomba baba mukabi, niku musiya mayanza-yanza. ");
INSERT INTO sbs_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Hape cha tuma zumwi muhikana naye baba mukabi, ni kumu nyandisa cha chituhu, niku mutumina naye mayanza-yanza. ");
INSERT INTO sbs_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Chiba tuma zumwi wa butatu naye baba mukavi kumu nongola nzilabi kwali, niku musohela hanze. ");
INSERT INTO sbs_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Linu Simwine wa luwa lomuomba chati, 'Muni chite bule?' Muni tume mwa nangu unisuna. Mwe ndi mubamuhe Ikute.' ");
INSERT INTO sbs_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kono ba byali ba muomba chiba mubona, chiba wamba mukati kabo, chi ba cho, Uzu nji yena swana. Tumwi haye, tuhinde chi fumu chibe chetu.' ");
INSERT INTO sbs_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Chi ba musohela kunze wo luwa lomuomba, ni kumwi haya. Mihe simwine wa luwa lomuomba mwati nzi kubali? ");
INSERT INTO sbs_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Kakeze ni kwiza kushinya ba byali boluwa lya muwomba, mwahe luwa lomu womba ku bamwi.” Mi ha ba zuwa, chiba cho, “Ireeza ukanisa!” ");
INSERT INTO sbs_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesu cha lola kubali, nacho, “Iñolo litalusa nzi? 'Ivwe liba sohiwa bazaki, liba bikwa musumo wo mwinkona'? ");
INSERT INTO sbs_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nzonse zibawi kweline vwe nziba kosoki hakati. Yense ase awile vwe, muli sinyehe.” ");
INSERT INTO sbs_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Bañoli niba kulwana bama pulisita baba kusuna kubika mayaza abo cheyo nako, babe zibite kuti inguli ya wamba i baku keza kubali. Linu baba ku tiya chi kwata cha bantu. ");
INSERT INTO sbs_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Baba ku mulolete che ntokomelo, baba tumini bantu ba matwela baba lihele kuti abo ba lukite, kuti baka wane muladu mu nzi wambo zakwe, bamu twale kwa bana ba yendisi ni kuba kulwana be chisi. ");
INSERT INTO sbs_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Chi bamu buza, nacho, “Muluti, twizi kuti uba wambi ni kuluta nzilukite, mikana Insusuwezo ye chitulo cha zumwi, kono ubakuluta buniti bwe nzila ye Ireeza. ");
INSERT INTO sbs_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kana Iswanelo kwetu kuliha mutelo kwa Sesare, kapa bule?” ");
INSERT INTO sbs_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kono Jesu cha zuwi sisa mizezo yabo, chati kubali, ");
INSERT INTO sbs_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Muni tondeze ma sheleñi. Chi fateho chani chi na hateni?” Chi bacho, 'Sesare.” ");
INSERT INTO sbs_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Chati kubali, “Muhe Sasere zintu za Sasere, ni kwe Ireeza, zintu zakwe Reeza.” ");
INSERT INTO sbs_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kana baba kwizi za kumu kananisa ha ba ku kwete ku wamba hakati habusu bwa bantu. Baba zimene niba ñuñuna kana baba kwina cho kwi taba. ");
INSERT INTO sbs_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Bu ngi bwa Masadduse chi ba keza kwali, yeke ya ba ku wamba kuti ka kwina kubuka kubafu, ");
INSERT INTO sbs_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","chi ba mu buza, chi bati, “Muluti, Mushe aba tuñoleli kuti haiba mukulwe wa mukwame nafwa, nena mwanakazi, mi nasa kwete bana, mukwame uwola kuhinda mwanakazi wamukulwa kwe, niku wanina mukulwe bana. ");
INSERT INTO sbs_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kuba kwina bana ba bakwame ba tenda iyanza ni bobele, wetanzi aba hindi mwanakazi, aba fwi na sena mwana, ");
INSERT INTO sbs_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","niwa bubeli naye. ");
INSERT INTO sbs_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Wa butatu cha muhinda, ubu nja bana be yaza ni bobeli ba bafwi, ka bena bana. ");
INSERT INTO sbs_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ha ku hinta inako mwanakazi naye chafwa. ");
INSERT INTO sbs_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Mwinako yokubuswa, mwabe mwanakazi wani? Kakuti iyaza nibo bele bakwete iye kuti nji mwanakazi wabo.” ");
INSERT INTO sbs_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesu cha cho kubali, “Bana be nkanda ba sesa, bahewa maseso. ");
INSERT INTO sbs_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Cwale aho njeni njete ahewe chifumu. abo bahindwa ku baba kutekwa mwinako yoku amuhelwa kuba ntu bafwile kuzwa kubafu. ");
INSERT INTO sbs_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Mikese ba olele kuzwilila kufwa. mukuti ba likanelele ni mangeloi ni bana ba Ireeza, bababi bana ba ba buswa. ");
INSERT INTO sbs_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kuti babafwi baba buswa, naye Mushe aba ntondezwa, kuamana ni chi humbu, kwa ba kusumpa Simwine Ireeza wa Abrahama ni Ireeza wa Isaka ni Ireeza wa Jakobo. ");
INSERT INTO sbs_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Hanu kanji Ireeza wa bafu, kono Ireeza yohala, Linu bonse bahalila kwali.” ");
INSERT INTO sbs_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Bamwi ba masika babe tabi, “Muluti, wetaba nenza, ");
INSERT INTO sbs_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","“Kana baba bozekezi kubuza nzimwi mpuzo. ");
INSERT INTO sbs_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesu chati kubali, “Chizi ha ba wamba kuti Jesu mwana wa Davida? ");
INSERT INTO sbs_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Mukuti Davida iye mwine aba wambi mwi mbuka ya Lisamu, Simwine aba wambi kwa Simwine wa ngu, 'Wikale kubulyo bwe yanza lyangu, ");
INSERT INTO sbs_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","konji chi napanga zila zako kuba mayendelo ako.' ");
INSERT INTO sbs_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Davida cha sumpa Jesu, simwine,' linu aho njeni mwana Davida?' ");
INSERT INTO sbs_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Mu kuhoza bantu bonse cha wamba kuba lutwana bakwe,” ");
INSERT INTO sbs_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Muzwe kubantu, bena mizezo yoku yenda munzila isalukite, abo basaka ahulu intumeliso zamanzimo muchibaka cha maunzikizo, mi simwine wikala muma sinangonge, zibaka zasimwine zemikiti. ");
INSERT INTO sbs_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bamana mazubo abanakazi ba fwililwe, nibaba lapelela intapelo inde. Abo kabahewe chikuto chikando. ");
INSERT INTO sbs_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesu ha lola aba boni bafumi niba bika impo zabo mwi citanda. ");
INSERT INTO sbs_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","A ba boni mwanakazi yo fwililwe yo nyandite habika tuhafu twe pene. ");
INSERT INTO sbs_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Chawamba, Zeniti nami bona, Uzu mwanakazi yo fwililwe wa zwisa kumihita. ");
INSERT INTO sbs_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Mubonse mwa zwisa impo zenu, Kono uzu mwanakazi ya sena chakwe wa mihita ka kuli waleta zonse zakakwete mubu njebwe bwakwe. ");
INSERT INTO sbs_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Bamwi ba bali ku wamba Inkeleke mwiba kabisezwe ka bukwala ni mavwe ni mpo, cawamba. ");
INSERT INTO sbs_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Kwezo zintu zimubwene, inako mwikeze kakwina ivwe lyete nilishale kulimwi nilisawi”. ");
INSERT INTO sbs_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Chiba mubuza kuti muluti, Izo kazi tendahale lili? Hape chisupo chete chitondeze kuti kazi tendahale? ");
INSERT INTO sbs_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ce taba; mumamele, kanzi muchengwa. Bangi kabeze che zina lyangu, Nokucho kuti; Njime kreste, inako chiya chuta, kono kanji mubechilili. ");
INSERT INTO sbs_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ha muzuwa inkondo ni kuli sandukila, Kanji mutiyi, Izo zintu kazi pangahali pili, kono kanji ma mani mani. ");
INSERT INTO sbs_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Chawamba kubali; Masika kalwise masika amwi; Mushobo ni mushobo kabalwe. ");
INSERT INTO sbs_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Izikinyebo ikando mwi kanda iboneke, Nilufu lungi muzibaka zingi, Ni zala, Nizitiza, Ni zikomosa zikando zizwa kwe lreeza kwi wulu. ");
INSERT INTO sbs_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Izi, ni ziseni kwiza, Bantu kaba milwise kamayaza, Bami sukulule niku mikwitila mu masinagoge, ni mwi tolongo, bami twale kuba simwine, niku ba atuli bezintu kebaka lyezina lyangu. ");
INSERT INTO sbs_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Izo kazi mizile kuti muwambe buniti. ");
INSERT INTO sbs_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Aho muli lemuhele mwi inkulo zenu, kuti kanji mulitukisezi pili zete muli tabilile kazo. ");
INSERT INTO sbs_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Mukuti ime kanimihe mamzwi ni butali, kuti bami lwisa bakangwe kumi taba ni kumi kananisa. ");
INSERT INTO sbs_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kamu betekwa niku bazazi benu, niba kwaluzubo benu, niba likani benu, kabe haye bamwi kwenu. ");
INSERT INTO sbs_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Imi kamu toiwe bantu bonse ibaka lyezina lyangu. ");
INSERT INTO sbs_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Imi ka kwina nanta lusuki lu mwina lwete nilu shale kumitwi yenu. ");
INSERT INTO sbs_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kamu haze ihuho zenu kaku kola kwenu. ");
INSERT INTO sbs_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Chimwa bona Jerusalema izimbukitwe masole mwizibe kuti kuza kunuka kwayo chiku chunine. ");
INSERT INTO sbs_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","linu, bena kwa Judea batilile ku malundu; Bena mu munzi bazwe mo'imi bena mwi kanda kanji bazwimo, ku bolela ku munzi. ");
INSERT INTO sbs_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Mukuti inako yaku bozekeza bantu bubi bwabo, kuti ziñoletwe zi boneke zose. ");
INSERT INTO sbs_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Bukabo kabwizile banakazi ba lihindite niba nyosa mwao mazuba; ka kuti bukabo bukando ka bube kwa nteni mwi kanda; imi bukali kabu sukile abo bantu. ");
INSERT INTO sbs_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mubawe kabu kali bwe sumo, kaba hapwe batwalwe kubantu bonse, imi jelusalema ka lyatolwe kube kanda mane ba maninine. ");
INSERT INTO sbs_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Zisupo kazi boneke hezuba ni mwezi ni nkani; imi mwi kanda mahasi kahwilwe niku njanja kebaka lya mawate ni masunda. ");
INSERT INTO sbs_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Bantu kaba zumininine kebaka lyo kutiya niku lindila zete zize mwi kanda; ka kuti zina ziho zo kwi wulu muzi nyanganye. ");
INSERT INTO sbs_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Imi kaba bone Mwana wo Muntu heti chokeza mu makope ke ziho ni kanya ikando. ");
INSERT INTO sbs_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Izo chizatanga kwiza; mu loleze menso kwi wulu, Imi muinuke; ka kuli kulukululwa kwenu chi kwina hafwihi. ");
INSERT INTO sbs_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Cha ba wambila inguli, Chati' mubone i samu lye feiga ni zisamu zimwi. ");
INSERT INTO sbs_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Hali tumpa makoba, Imi mwi ziba ni kulemuha kuti imbumbi chiina hafuhi. ");
INSERT INTO sbs_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ka mukwa wina bulyo, ne nwe, hamu bona izo chizi keza, mwina no kwi ziba kuti mubuso we Ireeza chi wina hafuhi. ");
INSERT INTO sbs_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Kabuniti ni wamba kwenu, ulu luzubo kete lumane, zonse zi seni ku tendahala. ");
INSERT INTO sbs_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Iwulu kali mane ni kanda bulyo; mi manzwi angu kete ni a mane. ");
INSERT INTO sbs_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Imi mu mamele inkulo zenu kanji zi lyanganiswa kulya kwenu, niku kolwa mutoho, niku bilela zo buhalo. ");
INSERT INTO sbs_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","mane ilyo izuba kali miwane kamu litukise; MU kuti kachiwile bonse bazakite mwi kanda yonse. ");
INSERT INTO sbs_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mi he, mutonde mulapele inako yonse, ili kuti mukole ni kubanduka kwezo zonse zete nizi boneke, ni kwa kwe habusu bwa Mwana Muntu. ");
INSERT INTO sbs_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesu abali kulutanga musihali mwi nkeleke imi masiku aba kuzwanga niku ka lindila hachi wulu chisumpwa ze samu lya olive. ");
INSERT INTO sbs_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Imi chichaba chonse chibali kwiza kakusasani mwi nkeleke kuku mutekeleza. ");
INSERT INTO sbs_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Mukiti we inkoko isena mulungo chiuba kwina ha fwihi, uba ku sumpwa Impaseka. ");
INSERT INTO sbs_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Baprista ni Bañoli baba bi ni mulelo wa kwi haya Jesu, kono baba tiyi chichaba. ");
INSERT INTO sbs_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Satani abe njili kwa Judas Isikaliote yabli zumwi wa balutiwa bena ikumi ni bo bele. ");
INSERT INTO sbs_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judas aba yendi ku Baprista ni Baeteleli ku wambola mwete ba mu betekele ku bali. ");
INSERT INTO sbs_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Baba tabite, ni ku zuminzana ku muha mali. ");
INSERT INTO sbs_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Aba zuminzani, ni ku lola inzila yo kumu lukulwila ku chichaba. ");
INSERT INTO sbs_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Izuba lya mukiti u sena mulungo chi lya sika, li baba ku swanela kuti ingu ye Paseka i haiwe. ");
INSERT INTO sbs_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesu aba tumi Peter ni Joani kuti baka lukise i paseka kuti balye, ");
INSERT INTO sbs_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Chiba mubuza kuti, Ko saka kuti tuka lukise njo kuhi? ");
INSERT INTO sbs_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Aba be tabi, “Mu ni teke, Chi mwa ke njila mu munzi mumu shangane Mukwame yo hindite kahambwe ka menzi. Mumwi chilile mwi nzubo yete ake njile. ");
INSERT INTO sbs_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Imi mu mu wambile si nzubo kuti, Muluti u wamba kwenu, Inzubo mwete a lile i paseka ni ba Lutwana bakwe inahi?” ");
INSERT INTO sbs_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Mwa mi tondeze inzubo ina kwi wulu inkando i lukiswe. Mulukise mwa teni. ");
INSERT INTO sbs_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Mi chi ba yenda, ni ku wana mwa ba ba teli, imi chiba lukisa ipaseka. ");
INSERT INTO sbs_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Inako ha i sika, che kala he ntafule ni ba lutwana. ");
INSERT INTO sbs_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Imi cha ba cho kuti, ni lakaza hahulu ku lya i paseka nenwe hani seni ku zuwiswa kuchisa. ");
INSERT INTO sbs_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Linu ni wamba kwenu, kuti kani li i paseka hesi chiye zibiswa mu mubuso wa Mulimu. ");
INSERT INTO sbs_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jesu cha hinda i nkomoki, ha manaku litumela, ni ku cho kuti muhinde ichi muli abele. ");
INSERT INTO sbs_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","linu chati ku bali, kete ni nwe i waine hape hesi mubuso wa Ireeza chi weza. ");
INSERT INTO sbs_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Cwale cha hinda chinkwa, ha mana ku litumela, cha chi komauna, ni ku baha ni ku cho kuti,” uwu nji mubili wangu mu lye nje nkupuzo yangu.” ");
INSERT INTO sbs_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Cha hinda i nkomoki che nzila i swana haba mana kulalila, chati, iyi inkomoki chilikani chetu ka malaha, angu ete e tikilwe nwe. ");
INSERT INTO sbs_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kono mu teke. Yoni beteka wina neme he ntafule. ");
INSERT INTO sbs_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mukuti Mwana we Ireeza che ziba kuti mukwi kalile, cwale kwina bumai kuya ba bi ni mulelo wo wa ku beteka. ");
INSERT INTO sbs_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Imi chiba tanga ku libuza mukati kabo, kuti njeni wina muhupulo uwo. ");
INSERT INTO sbs_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Imi chi kwa buka i nkani mukati kabo kuti yo hupulelwa kuba mukando njeni, ");
INSERT INTO sbs_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Chacho ku bali, Ba simwine bena bubusi hewulu lyabo, mi nji bena ziho hewulu lyabo ba sumpwa kuti bayendisi. ");
INSERT INTO sbs_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","kanji ku bi bulyo nenwe. Kono, mu leke yo li hinda bukando mukati kenu abe munini, mi mu leke yo lihinda ku sepahala abe bulyo; ");
INSERT INTO sbs_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Imi mukando, ibe iye wi kala he ntafule, kapa yo ha? Kanji wi kele he ntafule? Mukuti ime ni na mukati kenu ni ha. ");
INSERT INTO sbs_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kono njenwe mu be ntanzi mu miliko yangu. ");
INSERT INTO sbs_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Imi muni mihe Mubuso, sina mwa ba ni heli Tayo mubuso, kuti mulye ni ku nwa he ntafule yangu mu Mubuso wangu. ");
INSERT INTO sbs_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Imi ka mwi kale ha chipula cha bu simwine ni ku atula luzubo lwa Isilaele. ");
INSERT INTO sbs_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simon, Simon, bone, Satani uni kumbila kuti ami helule sina lungu lwa mauza. ");
INSERT INTO sbs_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kono chi na mi lapelela kuti itumelo yenu kanji i boleli hansi. Hachi mwa bola mukole ni mwachako. ");
INSERT INTO sbs_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pitrosi cha wamba kwali, “Simwine, ni li bakenye ku yenda newe mwi ntolongo kapa ku fwa.” ");
INSERT INTO sbs_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesu che taba kuti, Pitrosi koni sampule ko tatwe pili mukombwe ni useni ku lila.” ");
INSERT INTO sbs_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesu aba wambi ku bali, “Hani mi tuma ni mu sena chipaupau, ni mukotana usena zilyo, ni sangu, mu ba buli nzi?” Chi be taba, “Kakwina.” ");
INSERT INTO sbs_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Cwale cha wamba kubali kuti, Kono hanu, wina chipaupau ni mukotana we zilyo a zi hinde. Umwi ya sena mukwale, a uze ingubo yakwe a wule mukwale. ");
INSERT INTO sbs_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Chini wamba kwenu niti, chi ñoletwe ku amana neme kachi zuzilizwe, Mi a balelwe kuba sinyi! Mukuti zakwe chi za tendahala. ");
INSERT INTO sbs_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Chiba wamba, “Simwine, lole, milinga yobele” Imi che taba, “Ku shiyeme.” ");
INSERT INTO sbs_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Hamana mulalilo, Jesu cha yenda, mwa yendelanga, kwi lundu lya zi samu za Olive, mi balutwana bakwe chiba mwi chilila. ");
INSERT INTO sbs_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Haba ka sika, chati ku bali, “mu lapele mukuti kanji mwi njili mu miliko.” ");
INSERT INTO sbs_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Cha chunduluka ku bali chibaka chi likana ni ku zindwa kwe ibwe cha kubama ni ku lapela, ");
INSERT INTO sbs_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Nati, “Tayo, haiba mo sakile u zwise i nkomoki kwangu. Kanji uchiti muni sakila, ku chitwe mo sakila. ");
INSERT INTO sbs_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Imi ingeloi lizwa kwi wulu chilye za kwali, ku mu koza, ");
INSERT INTO sbs_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Cwale ha ba bile mubukabo cha lapela ahulu, mane chitukutuku chi a donka ubu malaha a wila hansi. ");
INSERT INTO sbs_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","46","Ha mana ku lapela cheza ku Balutwana bakwe cha ba wana kuti balele cha maswabi abo, cha ba buza kuti, “Chinzi ha mu lele? Mu buke mu lapele, kuti kanji mubi mu mu liko.” ");
INSERT INTO sbs_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Haba ku si wamba, chi kweza chikwata, ni Judas, umwi wa balutwana yo ba hitile, cheza hafwihi ni Jesu cha mu chuchuna, ");
INSERT INTO sbs_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","imi Jesu cha wamba kwali, “Judas, chiwa beteka mwana'muntu cha kumu chuchuna.” ");
INSERT INTO sbs_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Abo ba ba zimbukite Jesu haba bona zi ba ku pangahala, chi bati, “Simwine, tulwe ka mukwale?” ");
INSERT INTO sbs_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Cwale zumwi ca hinda mukwale ni ku konokola muhikana wo Muprisita mukulwana, ku mu konokola kutwi kwe chilyo. ");
INSERT INTO sbs_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesu chati, “ku shiyeme.” Cha wonda kutwi, ni ku mu hoza. ");
INSERT INTO sbs_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesu cha wambila baprisita ba kulwana, ni manduna ni balibeleli be nkeleke, ni bakulwana be chisi ba ba kezi kwa kwe, mwiza kwangu che mikwale ne nkoli ubu mu bwima musa? ");
INSERT INTO sbs_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Hani bena nenwe mazuba wonse mwi nkeleke, kana muba biki iyanza lyenu hangu. Kono nje nako inu yenu ni ziho ze chinzime. ");
INSERT INTO sbs_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Imi chi ba muwonda, kumu twala ku nzubo yo Muprisita mukulwana. Linu Pitrosi aba mwi chilile kule zana. ");
INSERT INTO sbs_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Haba mana ku tumbuza mulilo ha kati ke lapa chi be kala hamwina, ni Pitrosi che kala nabo. ");
INSERT INTO sbs_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Muhikana zumwi wa ba kazana cha mu bona ha mulilo, niku mu lolisa chati, “Naye uzu imwakwe wa Jesu.” ");
INSERT INTO sbs_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Linu Pitrosi cha kanana, chati, “Mukazana, Kani mwizi uzo.” ");
INSERT INTO sbs_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ha ku hita kaba kazana zumwi cha mubona, chati, “Uzumwi wa bo.” Imi Pitrosi chati, “Mukwame, ka njime.” ");
INSERT INTO sbs_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ha ku hita i hola zumwi Mukwame cha pihelela kuti,” Initi uzu mukwame a bena naye wuzu, Mugalileya,” ");
INSERT INTO sbs_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Imi Pitrosi chati, “Mukwame, kani zi izo zo wamba.” Na chi wamba, Mukombwe chiwa lila. ");
INSERT INTO sbs_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jesu cha chebuka niku lola Pitrosi. Imi Pitrosi cha hupula manzwi a Simwine, ha wamba kwali kuti, Pili mukombwe nu seni ku lila totatwe ko be choni sampwile.” ");
INSERT INTO sbs_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pitrosi cha zwila hanze, ku ka lila. ");
INSERT INTO sbs_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Bakwame baba ku gantela Jesu baba kumu shenda ni kumu kaba. ");
INSERT INTO sbs_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Haba mana ku mu sumina isila ku menso, chiba mu buza, kuti,” U nuhe wa ku kaba kuti njeni?” ");
INSERT INTO sbs_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Chi bawamba ziwambo zingi kwa Jesu. ");
INSERT INTO sbs_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Hali zwa izuba, bakulwana, ni ba kulwana ba Prisita ni bañoli chi ba kopana hamwina ku mu twala kwi nkuta, ");
INSERT INTO sbs_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Chibati, 'haiba njewe Kelesite, “tu wambile, “Kono cha ba wambila kuti, “chi na mi wambila, kete muni zumine.” ");
INSERT INTO sbs_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Mi niha ni mi buza, kete muni tabe. ");
INSERT INTO sbs_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kuzwa sunu, Mwana wa Muntu mwe kale kwi yanza lya bulyo ka ziho ze Ireeeza.” ");
INSERT INTO sbs_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Bonse Chibati, “Linu u Mwana we Ireeeza?” Imi Jesu cha cho kuti, “Mwa wamba njeme” ");
INSERT INTO sbs_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Chi bati “Chinzi hatu saka buniti? Mu kuti twa zuwa buniti buzwa mu kaholo kakwe.” ");
INSERT INTO sbs_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Inkopano yonse chiya zimana mwi wulu, ni kuleta Jesu kwa Pilato. ");
INSERT INTO sbs_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Chiba muhambiliza indaba, kuti; “twa wana uzu muntu na hambusa mahasi etu; u kanisa bantu ku zwisikiza Sesara mutelo, mi ulisumpa kuti njeye krisite, Ireeza”. ");
INSERT INTO sbs_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato cha mubuza, “kuti kana nji we Ireeza wa majuda?” Chetaba kuti, “wa wamba”. ");
INSERT INTO sbs_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato cha wambila Maprisita bakulwna ni nyangela, kani wani mulandu kozu muntu. ");
INSERT INTO sbs_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Chiba koza kuti “U lyanganisa chisi, Na kwete kuluta bantu mwa Judea yonse, a sali kutanga kwa Galilea, nikwiza kusika kunu”. ");
INSERT INTO sbs_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato hazuwa zo, cha buza kuti kanti Jesu Mugalilea. ");
INSERT INTO sbs_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Mi halemuha kuti ukazwa mwi puso ya Heroda, cha tumina Jesu kwa Heroda, uzo ya bali kwi kala naye mwa Jelusalema awo mazuba. ");
INSERT INTO sbs_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Heroda ha bona Jesu, aba tabi maswe, ka kuli aba hindi inako na saka kumu bona, kazitu zingi za kwe za bazuwi, mi aba sepete kuti kamu bone na tenda imakazo. ");
INSERT INTO sbs_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Heroda aba buzi Jesu cha manzwi mangi, kono Jesu kena betabi chimwi. ");
INSERT INTO sbs_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Baprisita ba kulwana ni bañoli chiba zimana, chiba muzinga indaba ko kukoza. ");
INSERT INTO sbs_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Heroda niba libeleli bakwe chiba mutuka, kumu shewununa, niku muzwatika zi zwato zilotu, niku muboza Jesu kwa Pilato hape. ");
INSERT INTO sbs_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Pilato ni Heroda chibaba muntu ni mulikani lolo luzuba, kono ibali muntu ni chila chakwe. ");
INSERT INTO sbs_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Imi pilato cha kunganya ba prisita niba yendisi babo mane ni chisi. ");
INSERT INTO sbs_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Chose cha wamba ku bali, “mwani letela uzu muntu, ni mucho kuti uzo yo hambusa chisi, ime namu buza habusu bwenu, kono kena na wana bubi bwakwe uzu mukwame ku amana nizi mu kwete kumu hambiliza. ");
INSERT INTO sbs_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Imi naye Hereda wa bona bulyo, cingi wa muboza kwetu, Ka mulole, Uzu muntu ka kwina cha foseze chi wola kumu cwala ku kwi haiwa. ");
INSERT INTO sbs_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Imi he kani mushupe niku mulukulula”. ");
INSERT INTO sbs_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Imi machaba onse aba huwelezi, ni kuti “ehawe uzo mi ulukulule Barabasi!” ");
INSERT INTO sbs_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","I ye Barabasi aba bikwa mwi tolongo ibaka lyo kuleta mulandu mu munzi ni kwi haya. ");
INSERT INTO sbs_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato cho kutabela kulukulula Jesu cha wamba nabo hape. ");
INSERT INTO sbs_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Chiba huweleza kuti aye ha chi fapano, “mi akokotelwe”. Chawamba nabo hape totatwe ");
INSERT INTO sbs_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","“kuti kanti chibi cha foseze uzu mukwame njezihi? Chi swanela ifu lya kwe, ka kwina chafoseze, kani mushupe niku mulukulula”. ");
INSERT INTO sbs_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kono ba bapiheleli ka manzwi ahanzi, chiba laela kuti a kokotelwe, manzwi abo chi akoma Pilato. ");
INSERT INTO sbs_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Mi Pilato cha kosola indaba, chati ku tendiwe muba sakila. ");
INSERT INTO sbs_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Imi cha lukulula ya bali kusuminwe mwi tolongo kama fosisa akwe, nika kwi haya, uzo iba kumbila Imi chabaha Jesu kuti ba ntende muba sakila. ");
INSERT INTO sbs_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Haba mutwala ku kwi haiwa, chiba kwata mukwame we zina lya Simoni wa kwa Sireni, ya bali kuzwa ku mawa, niku mutwikisa chifapano, no kwi cilila Jesu, ");
INSERT INTO sbs_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","vungi bwa chi chava va va mwi chilili, ni vanakazi va vali kulila, chevaka lyakwe. ");
INSERT INTO sbs_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesu cha sanduka, niku wamba kuti vanakazi va Jerusalema, kanzi mulili ivaka lyangu kono mulile lwenu nilwa vana venu. ");
INSERT INTO sbs_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ka kuti mukwize mazuva ete niva wambe kuti, vena imvuyoti vanakazi vasa zali, niva mavumo aseni ku zala, niva mavele aseni kunyosa. ");
INSERT INTO sbs_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","vantu njete niva tange ku wambila ziwulu, vati 'mutuwile hewulu', ni ku tuwulu kavati muntu 'vwike'. ");
INSERT INTO sbs_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kakuti hava tenda izo kuchi kuni chivombete, kakuve vule kuchizumite?” ");
INSERT INTO sbs_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Bamwi bakwame, ni zisinyi zobele, baba hitizwe naye kukwi haiwa. ");
INSERT INTO sbs_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Hava sika haka wulu kasumpwa “Gologota”, chiva mukokotela ha chifapano ha mwina nizi sinyi, chimwi kuvulyo, chimwi kuvuzohoto. ");
INSERT INTO sbs_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesu chacho, “Tayo Uva kwatile, ka kuti kabezi ziva tenda”. Chiva li aluhanyeza zi zwata za kwe cho ku laula. ");
INSERT INTO sbs_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Chisi chiva zimene, niku lolela kuba ye ndisi hava vali kumu sheunwina, chivati “Avali kutusa vantu, mu muleke ali tuse mwine, heva njeye krisite wa Ireeza, yava ketwa”. ");
INSERT INTO sbs_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Masole va vakumu nyefula niku chunina niva muchuka vinega, ");
INSERT INTO sbs_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Chivati,” haiva U mulena wa majuda uli tuse U mwine.” ");
INSERT INTO sbs_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kuvena chisupo kwali, “Nji Simwine wa Majuda” ");
INSERT INTO sbs_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Zumwi wa vasa yava hanzi naye chamu tuka kuti, “kanjewe Kresite? Lituse umwine niku tu tusa, ");
INSERT INTO sbs_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","vamwi chiva munyansa?” Kana kotiyi Ireeza, sina hawina muchi kuka chi swana? ");
INSERT INTO sbs_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Iswe itukelo yetu kuva hanu ka kuti tu fosete, tuli tumelela ma fosisa etu, kono uzu mukwame kena mafosisa. ");
INSERT INTO sbs_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Chazwila ha vusu “Jesu noni hupule mu muvuso wako.” ");
INSERT INTO sbs_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesu ava wambi kwali, “niku wambila ka vuniti, Sunu mobe name mwi paradaisi”. ");
INSERT INTO sbs_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Chivali ku patalala kwe zuva ka sikisi, mi kasinkwe cikeza kuwumba inkanda yonse kutwala ka naini, ");
INSERT INTO sbs_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","mi chikwava ni kusiha, isila lya mwi kereke chilya ñatuka hakati. ");
INSERT INTO sbs_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Chalila chezwi lihanzi, Jesu chati, “Tayo, ni vika luhuho lwangu mu mayaza ako.” ");
INSERT INTO sbs_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ha mana ku wamba bulyo nicha maniñwa luhuho, iñanga wempi za vakanteli ha vona ziva tendahali, chalumba Ireeza, “ni kuti niti, uzu muntu ava shiyeme”. ");
INSERT INTO sbs_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Imi vungi bwa vantu va vezi kulwela, zi vali ku tenda hala, nichi va vola niva li kava hazi zuva. ");
INSERT INTO sbs_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Imi vavezi Jesu, ni vanakazi va vali ku mwi chilile hakazwa kwa Galilea, va vazimene kule, niva lolete. ");
INSERT INTO sbs_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Mukwatise, ku vena mukwame ya vali kusumpwa Josefa we nkhuta Yecisi, mukwame mulotu yo lukite. ");
INSERT INTO sbs_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","I ye kena bazumini milao yabo ni kelezo. Avali kuzwa kwa judea ya kwa Arimathea ava kulindile muvuso we Ireeza. ");
INSERT INTO sbs_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Uzu mukwame cha yenda kwa Pilato niku ka kumbila chitunta cha Jesu. Chiba muhangula ha chifapano. ");
INSERT INTO sbs_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Chiva muvwika isila, imi chiva mupata mwikumbu liñatwilwe ni vwe, museni kubikwa muntu. ");
INSERT INTO sbs_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Imi ilyo izuva ivali lya vuitukiso, lya mukivelo chili vali kutanga. ");
INSERT INTO sbs_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Vanakazi, va vezite naye ku kazwa kwa Galilea, nive chilile Jesu, Niva lolete chitunta muchivikilwa mwa teni, ");
INSERT INTO sbs_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","chiva vola niku kalitukisa, imi la mukivelo nichi vapumula sina muku layelwe. ");
INSERT INTO sbs_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Haba fuma ku makalo e nviki, ci baya kwi bita ku leta mafuta a nunka a baba lukisi. ");
INSERT INTO sbs_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Baba wani ivwe ci lya pindumunwa kwi bita. ");
INSERT INTO sbs_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Cibe njila mukati, mi kana baba wani citunta ca Jesu. ");
INSERT INTO sbs_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ci kwa tendahala bulyo, haba ba kusi lyangene nezo, kapilipili bakwame bobele ciba zimana ha mbali nebo muzizabalo zi benya. ");
INSERT INTO sbs_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Banakazi babe zwile ku tiya ciba kubama hansi cha zi fateho zabo, ci ba wamba ku Banakazi “chinzi hamu saka bahala ku ba fwile? ");
INSERT INTO sbs_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ka kwina munu, Mi ca buswa, muhupule mwa ba wambili na sina mwa Galilea, ");
INSERT INTO sbs_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Chati mwana we Ireeza ka hewe mu mayanza aba tenda zibi ni ku mu kokotela, Imi ke zuba lya butatu ka buke.” ");
INSERT INTO sbs_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Banakazi ciba hupula manzwi akwe, ");
INSERT INTO sbs_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ciba zwa kwi bita ni kuka wamba zintu zonse ku balutwana ni bantu bonse. ");
INSERT INTO sbs_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Linu, Maria Madgalena, Joana, ni Mary nyina wa James ni bamwi Banakazi ciba biha zintu zonse ku ba Apositola. ");
INSERT INTO sbs_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Imi i impiho ciya bonala kusa zuweka hande kuba Apositola, imi kana bab zumini zi baba wambi Banakazi. ");
INSERT INTO sbs_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pitrosi cha zima niku tilila kwi bita, cha zima niku lola mukati, aba boni fela majila fela. Pitrosi aba boli ku Munzi na komoketwe chiba tendahali. ");
INSERT INTO sbs_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Celyo izuba balutwana bobele baba kuya ku munzi uba ku sumpwa Emmaus, ubena makumi ena i yanza ni kumi lyonke lye stadia kwa Jerusalema. ");
INSERT INTO sbs_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ciba ambola ni bamwi cezo zi ba tendahali. ");
INSERT INTO sbs_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kuba tendahali kuti haba ba ku wamba ni kuli buza Jesu cha li bonahaza ku bali. ");
INSERT INTO sbs_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Imi menso abo aba ku kangwa ku mwi ziba. ");
INSERT INTO sbs_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesu aba wambi ku bali, “chinzi inwe mu wamba mu bobele cimu ya buyenda?” Chiba zima ni ku lola ni ba swabite, ");
INSERT INTO sbs_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Zumwi kubali we zina lya Cleopas ca mwi taba, “Kana njewe u muntu wenke mwa Jerusalema ya sezi zintu zi ba tendahali mwa anu mazuba?” ");
INSERT INTO sbs_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesu ca wamba ku bali, “zintu zihi”? Ciba mwi taba, Zintu zi amana ni Jesu wa Nazareta, yabali Mupolofita, we misebezi mu manzwi, habusu bwa mulimu ne chisi. ");
INSERT INTO sbs_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Lyahanu ba Prisita ba kulwana ni Bayendisi, mumu baba mubetekeli ni ku mu nyansa kuti a kokotelwe ni kwi haiwa. ");
INSERT INTO sbs_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Imi tuba hupwile kuti njete na lukulule Israele. yee, nihakuba bulyo izi celi izuba lyo butatu kuzwa zonse zintu ha zi tendahala. ");
INSERT INTO sbs_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kono banakazi bamwi be nkopano baba tukomokisi, kaku pakelela kwi bita, ");
INSERT INTO sbs_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Imi kana baba ka mu wani chitunta, baba boli chi bakati nabo ba ba boni impono ya Mangeloi baba wambi kuti u hala. ");
INSERT INTO sbs_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bamwi ba Kwame mukati ketu baba yendi kwi bita, ciba kawana muba ba teli Banakazi, kono kana baba ka mu wani.” ");
INSERT INTO sbs_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jesu aba wambi kubali kuti, Mawe inwe bantu musa zuwisisi bene inkulo zi lyeha ku lemuha ziwambo za ba wambi mupolofita. ");
INSERT INTO sbs_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kana kena kubali kwa butokwa kuti Jesu a nyandiswe ni kwi njila mwi kanya, ");
INSERT INTO sbs_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kwi ntazi ku zwa kwa Mushe ku ya ku baprofita bonse, Jesu caba tolokela zintu ku amana naye mu mañolo. ");
INSERT INTO sbs_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Hachi ba ba sutelele ku munzi ku baba kuya, Jesu aba tendi ubu aba kusi zwila habusu, ");
INSERT INTO sbs_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","kono chiba mu cho kuti, “wi kale neswe, imi celi chitengu ni zuba chiliya kuku mina” linu Jesu cha bola mukati kwi kala nabo. ");
INSERT INTO sbs_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ku ba tendahali kuti haba kala naye ku lya, cha hinda chinkwa ku chi fuyola ni ku chi komauna cha baha, ");
INSERT INTO sbs_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Linu menso abo aba tondi ni chi ba mwi ziba, Imi cha zwa mu menso abo, ");
INSERT INTO sbs_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Chiba wamba kuzumwi ni zumwi, “kana inkulo kazi bili mukati ketu? Ha wamba kwetu munzila, ha tu wumbwila mañolo.” ");
INSERT INTO sbs_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Chiba zima che nako iyo ni ku yenda kwa Jerusalema, chi ba wana Balutwana bena ikumi ni yenke ni bamwi ba bena nabo, ");
INSERT INTO sbs_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","chi bati initi Jesu aba buki ni ku libonekisa kwa Simoni, ");
INSERT INTO sbs_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","chi ba wamba zintu zonse ziba tendahali mwi nzila, ni Jesu mwa ba tondelezwa ni kamo Jesu haba ku komauna chinkwa. ");
INSERT INTO sbs_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Haba ba ku wamba bulyo, Jesu cha zima mukati kabo, cha wamba ku bali chati “Ku sanga kube ne nwe”. ");
INSERT INTO sbs_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Kono baba bi ni sabo niku tiya ahulu, ni ku bonala kuti ba bona luhuho lu jolola. ");
INSERT INTO sbs_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jesu aba wambi ku bali, “Chinzi hamu bilela, ni kuba ni puzo mwi nkulo zenu? ");
INSERT INTO sbs_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Mu bone mu mayanza angu ni matende kuti njeme. Muni wonde niku ni lola, sina luhuho lu jolola halu sena inyama ne zi fuha sina muni kalile me”. ");
INSERT INTO sbs_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ha wamba bulyo aba ba tondezi mayanza ni matende a kwe. ");
INSERT INTO sbs_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Haba ba kwina mu ku sa zumina bakeñisa cha ku sanga bulyo niku komokwa Jesu cha wamba ku bali mwina chimwi chete mulye? ");
INSERT INTO sbs_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Chiba muha chiyemba che nswi zi jichitwe, ");
INSERT INTO sbs_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jesu cha hinda ni kulya mubusu bwa bo. ");
INSERT INTO sbs_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Aba wambi ku bali, “kuti hani bena nenwe, ni ba mi wambile kuti zonse ziba ñolwa ka mulawo wa Mushe ni we chiprofita ni manolo a Lisamu e zuzilizwe”. ");
INSERT INTO sbs_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Cwale che yalula ingana zabo, kuti ba zuwisise mañolo. ");
INSERT INTO sbs_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Aba wambi kubali kuti, “chiba ñoletwe kuti Jesu u swanela ku nyandiswa ni ku buka ku ba fwile che zuba lyo butatu. ");
INSERT INTO sbs_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Niku bakila zibi zetu kuti tu swalele, zi swanela kukutazwa mwi zina lyakwe ku zisi zonse, ku matango a Jerusalema. ");
INSERT INTO sbs_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mumpaki wezi zintu. ");
INSERT INTO sbs_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mubone, nimi tumina zaba sepisi Tayo. Kono mu shale mu Muleneñi konji chi mwa bwikwa ni inguzu zi zwa kwi wulu.” ");
INSERT INTO sbs_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Cwale Jesu cha ba hitila mane kuka sika ha fwihi ni Bethani. Mi cha zimika mayanza no ku ba fuyaula. ");
INSERT INTO sbs_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ku ba tendahali kuti haba kuba fuyola aba siyi ni ku hindwa kwi wulu. ");
INSERT INTO sbs_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Linu chiba mu lapelela kaku sanga ni ku bola kwa Jerusalema ke cha ku sanga. ");
INSERT INTO sbs_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Chiba zwila ha busu mwi inkeleke ku temba Ireeza. ");
INSERT INTO sbs_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kumatangilo kuvali kwina linzwi, mi linzwi lyivena kwa Ireeza, mi linzwi ivali Ireeza. ");
INSERT INTO sbs_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ichi chiva kwina ku matangilo ni Ireeza. ");
INSERT INTO sbs_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Zintu zonse ziva pangwa kwali, mi nikusena iye kakwina nanga chintu chonke chisena chapangwa chiva pangwa ");
INSERT INTO sbs_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mwali kuva kwina vuhalo, mi vuhalo vu vwina mwiseli lya vantu vonse. ");
INSERT INTO sbs_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Iseli lyi munika mukwelima, mi mukwelima kena uvakomi iseli. ");
INSERT INTO sbs_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Kuva kwina mukwame yava ku tumitwe kwa Ireeza, uzo izina lyakwe ivali Johani. ");
INSERT INTO sbs_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Avakezi cho kuva Impaki kwiza ku paka ze seli, njokuti vonse njete va zumine kakwe. ");
INSERT INTO sbs_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Johani kena vali iseli, kono avakezi kuti za pake ze seli. ");
INSERT INTO sbs_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ivali iseli lyeniti, lyiha iseli ku vantu vonse, lyikeza mwi fasi. ");
INSERT INTO sbs_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Avena mwi fasi, mi fasi lyiva pangwa kwali, mi fasi kena lyiva kumwizi. ");
INSERT INTO sbs_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Avakezi kuzakwe, mi zakwe kena ziva mutambuli. ");
INSERT INTO sbs_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kono kwavo vangi vava mutambuli, vava zumini mwi zina lyakwe, Avahi inswanelo yo kuva vana ve Ireeza. ");
INSERT INTO sbs_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ava kena vava zalwa cha malaha, kapa kentato ye nyama, kapa ke ntato yo muntu, kono ye Ireeza. ");
INSERT INTO sbs_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Mi linzwi chilyeza kuva inyama niku hala mukati ketu. Tuva voni inkanya yakwe, inkanya sina yozo mi iye vulyo yava kuka zwilila kwe Shetu, ye zwile chisemo ni niti. ");
INSERT INTO sbs_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jahani avapaki kuamana iye niku lilila kwakwe, na wamba, uzu njiyena wa kwavo vani va wambi, 'uzo yo keza mumasule angu u i hitilila, kakuli kwavali kwina ni niseni kuva kwateni ime.'” ");
INSERT INTO sbs_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kuzwa ku kwizula kwakwe tuva tambili chisemo kuzwa chisemo. ");
INSERT INTO sbs_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kaho mulao uvahewa kwa Mushe. Chisemo ne niti ziva kezi ka Jesu Kreste. ");
INSERT INTO sbs_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kakwina yava voni Ireeza ke nako ni nako. Ireeza yenkefela, yena hembali ni chizuva che Shetu, ava mwizivahazi. ");
INSERT INTO sbs_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Mi uvu nji vupaki bwa Johani aho majuda hava tumina ma Prisita ni naLivite kwali kuzwa kwa Jerusalema kuka muvuza, “njewe ni?” ");
INSERT INTO sbs_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Chentukuluho chawamba, mi kena va sampuli, kono che tava, “kena njime Kreste.” ");
INSERT INTO sbs_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Cwale chiva muvuza, “Uchinzi cwale? Njewe Eliya?” Cha cho, “kena ime,” Chiva cho, “Umuporofita?” Chetava,” Ne.” ");
INSERT INTO sbs_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Cwale chiva wamba kwakwe, “njewe ni, njokuti tuwole kukaha inkalavo kwavo vakatutuma? Uwambanzi kuama iwe umwine?” ");
INSERT INTO sbs_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Chacho, “ni mulumo, ulila mwihalaupa: 'Mupange inzila ya Simwine iwoloke; sina muporofita Isaya mwava teli.” ");
INSERT INTO sbs_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Mi avo vavatumwa vavali ma Pharisi. ");
INSERT INTO sbs_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Chiva, muvuza niku muwambila, “Chinzi hokoloveza cwale heva kena njewe Kreste kapa Eliya kapa muporofita?” ");
INSERT INTO sbs_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Mi Johani cha vetava, kuwamba, “nikoloveza cha menzi. Kono mukati kenu kuzimene muntu imusezi; ");
INSERT INTO sbs_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","iye yani chilila, uzo tukwele twe nsangu kani swaneli kusumununa.” ");
INSERT INTO sbs_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Izi zintu ziva pangwini Bethani kwi neku lyimwi lya Jordani, uko Johani kwava ka kolovelezwa. ");
INSERT INTO sbs_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Izuva lyi chilila Johani cha vona Jesu na keza kwali, “Lole, kwina imbelele ya Ireeza izwisa zivi mwi fasi! ");
INSERT INTO sbs_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Uzu njiyena kuni va wambi, 'iye yokeza ku masule angu uni hitilila, kakuli kwavali kwina nini seni kuva kwateni.' ");
INSERT INTO sbs_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Kena niva kumwizi, kono ivapangali kuti e zivahazwe ku isilaele kuti niva ku koloveza ni menzi.” ");
INSERT INTO sbs_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Johani avapaki, kuwamba, “na vona Luho nilushetumuka sina inkuva kwi wulu, mi lyeza kwi kala hewulu lyakwe. ");
INSERT INTO sbs_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","kena niva mwi zivi, kono iye yava ni tumi kwiza kukoloveza ni menzi wawamba kwangu, 'Kozo yete uvone Luhuho ni lushemukela hali ni kwikala hali, njeye yo koloveza mu Luhuho lu Jolola.' ");
INSERT INTO sbs_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Niva voni vonse niku paka kuti uzu nji mwana wa Ireeza.” ");
INSERT INTO sbs_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Hape, izuva lyi chilila, sina Johani hava kuzimene ni Varutwana vo vele, ");
INSERT INTO sbs_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","vava voni Jesu na yenda hembali, mi Johani chawamba, “Lole, Imbela ye Ireeza!” ");
INSERT INTO sbs_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Mi varutwana vakwe vava muzuwi na wamba izi, mi chive chilila Jesu. ");
INSERT INTO sbs_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Cwale Jesu chava vona niva mwichilile mi chava wambila, “Musakanzi?” Chivetava, “Rabbi (Itoloka muruti), Wikala kwi?” ");
INSERT INTO sbs_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Cha wamba kuvali, “mwize ze muvone.” Cwale chiva keza kwiza kuvona kwekala; vave kali naye ilyo izuva, hakuli chivali inako ikwana ikumu. ");
INSERT INTO sbs_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Zumwi kuvali ava zuwi Johani na wamba mi nikwi chilila Jesu ivali nji Andrew, mukulwa Simone Pitolosi. ");
INSERT INTO sbs_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Avatangi kuwana mukulwe Simone mi chawamba kwali, “Twawana Messiah” (italusa Kreste). ");
INSERT INTO sbs_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ava muleti kwa Jesu. Mi Jesu cha mulola niku wamba, “Njewe Simoni mwana Johani, Kosupwe Cephas” (itoloka Pitolosi). ");
INSERT INTO sbs_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Izuva lyi chilila, Jesu hava kusaka kuyenda kwa Galilee, cha wana Filipi niku muwambila, “Nichilile.” ");
INSERT INTO sbs_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Hanu Filipi ava kukazwililekwa Bethsaida, intoropo ya Andrew ni Pitolosi. ");
INSERT INTO sbs_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipi chawana Natheniel niku wamba kwali, “Iye uzo Mushe ava ñoli mumulao, ni maporofita, chitwa muwana: Jesu mwana a Josefa, kwa Nazereta.” ");
INSERT INTO sbs_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nathaniel chamu wambila, “kwina chintu chilotu chiwola kuzwa kwa Narazeta?” Fiipi chamu wambila, “wize zo vone.” ");
INSERT INTO sbs_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesu chavona Natheniel nakeza kwali niku wamba zali, “vone, mu isilaele we niti, yasena kuchenga!” ");
INSERT INTO sbs_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathaniel cha mu wambila, “unizini vule?” Jesu chetava niku mu wambila, “Filipi naseni kukusumpa, ni wina munsi ye chikuni cha feige, niva kuvoni.” ");
INSERT INTO sbs_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathaniel che tava, “Rabbi, umwana we Ireeza! umurena wa Isilaele!” ");
INSERT INTO sbs_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesu che tava niku mu wambila, “kakuli na wamba kwako, 'naku vona munsi ye chikuni cha feige; uzumina? Movone zintu zikando kuhita izi.” ");
INSERT INTO sbs_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","mi chawamba, “Zeniti, zeniti, ni wamba kwako, Kovone ma wulu ne yalukite, ni ma ñiloyi e Ireeza azwa hansi nikuya kwi wulu hewulu lya Mwana a Muntu.” ");
INSERT INTO sbs_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Hakuhita mazuva otatwe, kuvena mukiti we seso mwa Cana ya Galileya, niva nyina Jesu kuvavena. ");
INSERT INTO sbs_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesu niva rutwana vakwe vava memetwe kwiseso. ");
INSERT INTO sbs_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Iwaine haimana, vanyina chiva wamba kwali, “kavasina iwaine.” ");
INSERT INTO sbs_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesu cha wamba kwali, “Mwanakazi, chinzi hokeza kwangu? Inako yangu kaini kusika.” ");
INSERT INTO sbs_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Banyina chiva wambila ba hikana, “chonse chamiwambila muchipange.” ");
INSERT INTO sbs_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Linu kuvena impoto za mavwe amenzi zimane yanza ni konke kuseveliswa kusambila maJuda havava mukiti, impoto ni mpoto iva kuli yovule vulikana he ñokolwa zobele kapa zotatwe. ");
INSERT INTO sbs_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesu cha wamba kuvali, “mwizuze impoto za menzi ni menzi.” linu chiva zizuza ili kumilomo. ");
INSERT INTO sbs_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Linu chawambila vahikana, “Munembule amwi mwateni hanu ni kutwalile mukulwana yoha zilyo.” Linu chiba tenda bulyo. ");
INSERT INTO sbs_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mwihiki mukulwana chasola mumenzi ava sanduki iwaine, kono kena avazi kuizwa (kono vahikana vava teki awo menzi vavezi). Linu chasumpa musesi ni museswa ");
INSERT INTO sbs_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","nikucho kuti, mukwame ni mukwame avike iwaine indotu chantazi nikuha isaduri chivakorwa. Kono mwavika iwaine indotu kwiza kusika hanu. ");
INSERT INTO sbs_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ichi je Chisupo che ntanzi chava tendi Jesu mwa Cana ya Galilea, niku tondeza ikanya yakwe, imi varutwana vakwe chiva zumina kwali. ");
INSERT INTO sbs_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Izi hazimana Jesu, va nyina, vanche bakwe, niva rutwana vakwe vava yendi kwa Capenamu niku kekala mazuva alikene. ");
INSERT INTO sbs_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Linu impaseka yama Juda chi yivena hafuhi, imi Jesu chaya kwa Jerusalema. ");
INSERT INTO sbs_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Chawana vava kuwuza mapulu ni mbelele ni nkwilimba, niva chincha masheleni vava kwikele ho. ");
INSERT INTO sbs_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Linu chapanga imbazi yemihala hanze ye tempele, kuhindilila ni mbelele nima mapulu. Cha dadola makovili avantu va nchincha masheleni nikusoha Itafule. ");
INSERT INTO sbs_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Kuvava kuuza inkwilimba avati, “muzwise izi zintu munu. Muleke tenda inzuvo ivandanda musika.” ");
INSERT INTO sbs_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Varutwana vakwe chiva hupula kuti kuvañoletwe, “Nihaiwa kutokomela inzuvo yako. ");
INSERT INTO sbs_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Cha mulawo wa Majuda chive tava nikumuta kuti, “Chisupo nzi chete utu tondeze, hamukwete kupanga izi zintu?” ");
INSERT INTO sbs_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesu chetava, “Musinye iyi itempele, imi mumazuva otatwe munivuse.” ");
INSERT INTO sbs_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Lunu muvuso wa Majuda chiwati, Iyi itempele ivazakwa muzilimo zina makumi otatwe ni akwana iyanza ni chonke, imi ko ivuse mumazuva otatwe?” ");
INSERT INTO sbs_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nihakuva vulyo, ava kuwamba kuamana ni tempele ya muvili wakwe. ");
INSERT INTO sbs_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Cwale linu haka vuswa kuvafwile, varutwana vakwe chiva kumbulukwa kuti ava wambi izi, imi vava zumini iñolo ni chiwabo chava wambi Jesu. ");
INSERT INTO sbs_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Linu havena mwa Jerusalema kwi Mpaseka, mwinako ya mukiti, vangi vava zumini mwizina lyakwe havavona impono zava kupanga. ");
INSERT INTO sbs_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Kono Jesu kena vavasepi kakuli ava vezi vonse, ");
INSERT INTO sbs_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","kakuli kena kusaka muntu kumupaka kuamana ni muntu, kakuli avezi zivena mukati kakwe. ");
INSERT INTO sbs_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kuvena mufalisi wezina lya Nicodema, muyendisi wa Majuda. ");
INSERT INTO sbs_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Uzu mukwame chakeza kwa Jesu mi chati, “Rabbi, twizi kuti umuruti yo zwa kwa Ireeza mukuti kakwina muntu yo wola kupanga zisupo zowola kupanga haisi haiva Ireeza wina naye. ");
INSERT INTO sbs_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesu cha mwitava, “Niti, niti, haisi zumwi chapepwa hape, ka woli kuvona muvuso wa Ireeza.” ");
INSERT INTO sbs_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodema chati kwali, “Muntu wola vule kupepwa hape yacho supule? kawoli kwi njila lyo vuveli mwi vumo livanyina ni kupepwa, uwola?” ");
INSERT INTO sbs_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesu che tava, “Nini, niti, haisi zumwi cha pepwa ka mezi ni ka Luhohu, kawoli kwi njila mumuvuso wa Ireeza. ");
INSERT INTO sbs_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Chivapepwa che nyama che nyama, imi chivapepwa cha Luhuho cha Luhuho. ");
INSERT INTO sbs_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Sanzi mukomokwa kuti nawamba izi kwenu,' Muswanela kupepwa sinca,' ");
INSERT INTO sbs_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Luhuho luhunga konse kulusaka; mu zuwa mulumu walo, kono kamwizi luzwa kapa kuluya. Cwale nji zumwi ni zumwi ya vapepwa cha Luhuho.” ");
INSERT INTO sbs_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodema chetava chati kwali, Izi zintu ziwola kuva vule? ");
INSERT INTO sbs_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesu chetava chati, “U muruti wa Isilayele, imi nahanu kozuwisisi izi zintu? ");
INSERT INTO sbs_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Niti, niti, niwamba kwenu, tuwamba zitwizi, imi tupaka zituva voni. Kono kamutambuli vupaki vwetu. ");
INSERT INTO sbs_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ha ni miwambila kuamana ni zintu ze inkanda mi kamuzumini, muwola vule kuzumina hanimi wambila zintu ze wulu. ");
INSERT INTO sbs_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kakwina yava kambami kwi wulu konji yavasuki kwihulu: Mwana wa Muntu. ");
INSERT INTO sbs_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ili Mushe mwava nyamwini inzoka mwi halaupa, ");
INSERT INTO sbs_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","cwale Mwana Muntu uswanela ku nyamuna mwihulu, ili kuti vonse va zumina kwakwe vave ni vuhalo vusa mani. ");
INSERT INTO sbs_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kakuli Ireeza ava saki ahulu inkanda, mane avahi Mwanakwe yenke, ili kuti yense yo zumina kwakwe kate afwe kono kave nivuhalo vusamani. ");
INSERT INTO sbs_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ireeza kana ava tumiki Mwanakwe kwiza kuwatula inkanda, kono kwiza kuhaza inkanda kakwe. ");
INSERT INTO sbs_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Iye yozumina kwakwe kete ka watulwa, kono yasa zumini u watulwe kale kakuli kana avazumini mwi zina lya yenke vulyo Mwana wa Ireeza. ");
INSERT INTO sbs_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ili nji vaka lye nkatulo: iseli livakezi mwinkanda, imi vaantu vava kusaka ififi kuhita iseli kakuti mitendo yavo iva silafele. ");
INSERT INTO sbs_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Cwale yense yo tenda vuvi u toyete iseli imi kakezi kwi seli ili kuti mitendo yakwe sainzi izivahali. ");
INSERT INTO sbs_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nivakuva vulyo, iye yotenda initi wiza kwi seli ili kuti ni mitendo, yapanga u yipanga cha Ireeza, ka ivoneke. ");
INSERT INTO sbs_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Hakumana izi Jesu ni varutwana vakwe chivaya mwinkanda ya Judeya. Uko avakekali inako navo ni kukoloveza. ");
INSERT INTO sbs_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Linu Johani naye chaka kakoloveza mwa Enoni kwi mbali ya Salimu kakuli kuvena menzi mangi. Vaantu vavali kwiza kwali imi vava kukolovezwe, ");
INSERT INTO sbs_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","aho Johani kena aveni kusohelwa mwi ntolongo. ");
INSERT INTO sbs_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Cwale chikweza inkani mukati ka varutiwa va Johani ni Mujuda kuamana ni kulijoloza. ");
INSERT INTO sbs_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Vava yendi kwa Johani nikuti kwali, “Rabbi, uzu yavena nawe kwi mbali imwi ya lwizi lwa Jodani, iye yova paki, lole, ukwete ukoloveza, mi vonse vakwete kuya kwakwe,” ");
INSERT INTO sbs_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Johani chetava, “Muntu kawoli kutambula zonse haisi haiva chivahewa kwakwe kuzwa kwiwulu. ");
INSERT INTO sbs_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Iwe umwine uwolakupaka kuti nivawambi, 'Kanjime Keresite kono nihakuva vulyo, niva tumwa havusu vwakwe.' ");
INSERT INTO sbs_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","30","Musesiwa uwila kumusesi. Linu valikani va musesi, vazimana ni kumuzuwa, kusanga luli kakuli wazuwa inzwi lya musesi. Izi, linu, nji kusanga kwangu mi chikwatendahala. Uswanela kuwela, kono ni swanela fukuza. ");
INSERT INTO sbs_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","33","Iye yozwa kwihulu wina he wulu lya vonse. Iye yozwa mwinkanda uzwa mwinknda imi uwamba kuamana ni nkanda. Iye yozwa kwi wulu wina hewulu lya vonse. U paka kuamana kaza vavoni niza vazuwi, kono kakwina yo tambula vupaki vwakwe. Iye yotambula vupaki vwakwe initifaza kuti Ireeza we niti. ");
INSERT INTO sbs_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","36","Kakuli yavatumiwa Ireeza uwamba linzwii lya Ireeza. Kakuli kahi Luhuho cha kupima. Muzazi wa chikwame usaka Mwana imi avahi zintu zonse mu manza akwe. Iye yo zumina ku Mwana wina vuhalo vusa mani, kono yasa zumini ku Mwana kete avone vuhalo, kono vukali vwa Ireeza vwina hakwe.” ");
INSERT INTO sbs_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Linu aho Jesu heziva kuti Mafarisi vava zuwi kuti avali kupanga ni kukoloveza valutiwa vangi kuhita Johani ");
INSERT INTO sbs_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(nangati kuti Jesu iye mwine kena avali kukoloveza, kono ivali valutiwa vakwate), ");
INSERT INTO sbs_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","chazwa mwa Judeya ni kuvola hape kwa Galileya. ");
INSERT INTO sbs_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Kono ivali iswanero kwali ku hita mwa Samariya. ");
INSERT INTO sbs_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Cwale cha keza mwi toropo ya Samariya, i sumpwa Sychari, hembali ni chivaka chevu icho Jakovo ava here kumwane Josefa. ");
INSERT INTO sbs_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Chisima cha Jakovo puchivena aho. Jesu avali kukatere kuzwa ku musipiri wakwe ni kwiza ha chisima. Chi ivali kuchutire kwinako ye chitengu zana. ");
INSERT INTO sbs_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Mukulwakazi wa Musamariya ava kezi kuku teka menzi, mi Jesu cha wamba kwali, “Nihe ku menzi ni nywe.” ");
INSERT INTO sbs_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Kakuti valutwana vakwe vavali kuyendente mukati ke toropo kuku wula zilyo. ");
INSERT INTO sbs_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Yaho mukulwakazi wa Musamariya chata kwali, “Kuwoleka vule kuti iwe, kuva Mujunda, ukumbira ime, kuva mukulwakazi wa Musamariya, kuchimwi cho kunywa?” Kakuli Majunda kavana cho kupanga ni Masamariya. ");
INSERT INTO sbs_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesu che tava ni kumuta, “Kambe we ziva impo ya Ireeza, mi jeni uzu yo wamba kwako, 'Unihe cho kunwa; ni wa wola kumu kumbira, mi na wola kukuha, menzi a hala.” ");
INSERT INTO sbs_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mukulwakazi chata kwali, “Mukwame, kawina chitekiso imi isima litungite. Ena kuhi cwale kowina menzi a hala? ");
INSERT INTO sbs_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Kena umu kando, iwe, kuhita ishetu Jakovo, uzo ava tuhi chisima ni kunya mwateni iye mwine, nivane vulyo ni ñombe zavo? ");
INSERT INTO sbs_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesu che tava ni kumu ta, “Yense yo nwa kwaya menzi mwa fwe inyota hape, ");
INSERT INTO sbs_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","kono yense yo nwa kumenzi awo ite ni muhe kate na fwe inyota hape. Nihakuli, menzi ete ni muhe muave chisima chamezi mwali, kuvuvira ku vuhalo vusa mani.” ");
INSERT INTO sbs_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mukulwakazi chati kwali, “Mukwame, unihe aya menzi iri kuli nisiye ni kufwanga inyonta mi nisiye niku kezanga kunu kuku teka menzi.” ");
INSERT INTO sbs_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesu chata kwali, “Yende, kasupe mwihyenu, mi ukavole kunu.” ");
INSERT INTO sbs_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mukulwakazi chetava ni kumuti, “Kanina mukwame.”Jesu chetava, “Wina hande mukuwamba,”Kanina mwihyetu; ");
INSERT INTO sbs_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","kakuti uva vire ni vakwame vakuma ha minwe ye yanza, mi nozu yo wina naye hanu kanji mwihyenu. Chiwa wamba che niti.” ");
INSERT INTO sbs_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mukulwakazi cha wamba kwali, “Mukwame, Ni vona kuti umu porofita. ");
INSERT INTO sbs_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Veshetu vavali kulaperera heli irundu, kono inwe muwamba kuti Jerusalema je chivaka uko vantu vaswanera ku laperela.” ");
INSERT INTO sbs_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesu chata kwali, “Uni zumine, mwanakazi, kuti i hola i kezite aho kamulapere Tayo kamba heli rundu kamba mwa Jerusalema. ");
INSERT INTO sbs_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Inwe mulapera icho chimusezi. I swe tulapera chi twizi, kakuti ipuluso i zwirira kuMajuda. ");
INSERT INTO sbs_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Niha kuva vulyo, I hola ikezite, imi ina hanu, aho valaperi ve niti kava lapere Tayo muluhuho ni mwi niti, kakuli Tayo u kwete kulola vantu vaswana vulyo kuva valaperi vakwe. ");
INSERT INTO sbs_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ireeza luhuho, mi vantu vamulapera vaswanera kumu lapera muluhuho ni mwi niti.” ");
INSERT INTO sbs_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mukulwakazi chati kwali, “Ni izi kuti Mesiya ukezite (uzo usupiwa Keresite). A ho hasana kakeze, keze a tutoloke zintu zonse kwetu.” ");
INSERT INTO sbs_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesu chamuta, “Jeme uzu, yo kwete kuwamba kwako.” ");
INSERT INTO sbs_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Heyo inako valutwana vakwe chivaka vola. Hanu vavali ku komoketwe chinzi havali kuwamba ni mwanakazi, kono kakwina ava wambi, “Usaka nzi?”kamba “Chinzi hau wamba naye?” ");
INSERT INTO sbs_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Cwale mukulwakazi chasiya i hemere lyakwe, ni kuvola mwi toropo, ni kuwamba kuvantu, ");
INSERT INTO sbs_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Mwize, muvone mukwame wani wambira zintu zonse ziniva pangi. Uzu uswanera kuva iye Keresite, iwola kuva?” ");
INSERT INTO sbs_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Chiva siya itoporopo ni kukeza kwali. ");
INSERT INTO sbs_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mwinako zana, varutwana vavali kumukumbira, nivati, “Rabbi, Lye.” ");
INSERT INTO sbs_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Kono cha wamba kuvali, “Nina zilyo zo kulya inzo zimusezi chazo.” ");
INSERT INTO sbs_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Cwale varutwana chiva wambolisana kuvali vene, “Kakwina zumwi wa muletera zokulya, vamu letera?” ");
INSERT INTO sbs_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesu cha wamba kuvali, “Zilyo zangu ku panga itato yakwe uzo yava kani tumi ni kumana musevezi wa kwe. ");
INSERT INTO sbs_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Kamu wambi kuti, 'Kwina myezi imwi yone mi ikutulo jese ikeze'? Ni wamba kwenu, mulole kwi wulu ni kuvone mawa, kakuli chi alitukiseze kusizwa! ");
INSERT INTO sbs_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Uzo yo kwete kusiza u tambula i tuwero ni kukunganya misero yo vuhalo vusa mani, iri kuti uzo yo vyala nozo yo sinza va sangwe hamwina. ");
INSERT INTO sbs_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Mowu muwambiro, 'Yenke ubyala, mi zumwi usinza; vuniti. ");
INSERT INTO sbs_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ni va mitumi kuku sinza inzo zisina muva severezi. Vamwi vava sevezi, mi muvengiri mumi sevezi yavo.” ");
INSERT INTO sbs_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Vungi bwa Masamariya mowuna muleneñi chiva zumina kwali vakeñi che vaka lyue ñusa lyo mukulwakazi lya paka, “Wani wambira zintu zonse izo zini vapangi.” ");
INSERT INTO sbs_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Cwale Masamariya hava keza kwali, chiva muvuza kwikala navo, mi ave kali kwateni mazuva overe. ");
INSERT INTO sbs_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Mi vungi vomwi vuva zumini chevaka lya manzwi akwe. ");
INSERT INTO sbs_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Chiva wamba ku mwanakazi, “Katusizumini chevaka lyezo ziwawamba, kakuti iswe tuvene chitwa muzuwa, mi twizi kuti uzu luli chovuniti jo muhazi we kanda.” ");
INSERT INTO sbs_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Hakumana awo mazuva o vere, Chazwa kwatenio ni kuya kwa Ngalileya. ");
INSERT INTO sbs_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kakuli Jesu iye mwina ava wambi kuti muporofita mwi kanda yakwe kakutekiwa. ");
INSERT INTO sbs_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Hacha keza mwa Galileya, Mangalileya chi vamu tambula. Vava voni zintu zonse zava pangi mwa Jerusalema ha mukiti, kakuti navo vavali kuyendete kwateni. ");
INSERT INTO sbs_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Hanu chakeza hape mwa Kana mwa Ngalileya, umo mwava sanduli menzi i waine. Kuvena zumwi induna ili uzo mwane we chiswisu mwa Capenaume yavali kulwala. ");
INSERT INTO sbs_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Aho heza kuzuwa kuti Jesu ava kezi kukazwa kwa Judeya kwiza kwa Galileya, Cha yenda kwa Jesu ni kuka mukumbira kuti akeze ni kuhoza mwane we chiswisu, ya chavali kwina hafuhi ni kutokwala. ");
INSERT INTO sbs_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesu cwale cha wamba kwali, “Mbwita chi mwavona isupo ni makazo, kate muzumine.” ");
INSERT INTO sbs_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Induna chati kwali, “Mukwame, wize kunu mwanangu naseni kufwa.” ");
INSERT INTO sbs_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesu chawamba kwali, “Yende. Mwanako we chiswisu uhala.”Mukwame ava zumini manzwi awo Jesu ava wambi kwali, mi chayenda kuzwa hateni. ");
INSERT INTO sbs_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Havali kushetumuka, muhikana wakwe chamu katana, nawamba kuti mwanakwe we chiswisu avali kuhala. ");
INSERT INTO sbs_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Cwale chava vunza inako hatangira kuli zuwa hande. Chiva mwitava, Inzona mwinako ya musihali i fivere chiya musiya.” ");
INSERT INTO sbs_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Cwale vensi chiva lemuha kuti ivali jiyona inako ina Jesu yava wambi kwali, “Mwanako we chiswisu uhala.”Cwale iye mwine niver zuvo yakwe yonse chiva zumina. ");
INSERT INTO sbs_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Iyi ivali ivali je makazo yo vuveri yava pangi Jesu hakazwa kwa Judeya kuya kwa Ngalileya. ");
INSERT INTO sbs_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Hakumana izi kuvena mukiti wa Majuda, imi Jesu chayenda kwa Jerusalema. ");
INSERT INTO sbs_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Linu mwa Jerusalema hamulyango wa mulaka we mbelele, kwina kaziva, ako muchi Heveru ka sumpa Betesida, kavakwina kazuvo kena milyango i kwana iyanza. ");
INSERT INTO sbs_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ipalo ikatukite ya vaantu vava kulwala, vasavoni, vachunkuta, vazuminine luñañali vava lele mo. kulindila mezi avuva.” ");
INSERT INTO sbs_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Iñeloi lya simwine livashetuki ni kwiza kukundunga mezi imi vonse vava lyati mu mezi niakwete kukundungwa vava kuhola kumatuku onse avali kuva kataza. ");
INSERT INTO sbs_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","zumwi mukwame avena ko ya valyali zilimo zina Makumi otatwe ni akwana iyanza ni zo tatwe. ");
INSERT INTO sbs_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Juse hamuvona nalele, imi cha lemuha kuti chavekele hateni inako inde, chawamba kwali, usaka kuva ni makete?” ");
INSERT INTO sbs_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mukwame yava kulwala chetava, “Nfumwangu, kanina yowola kuni vika mukaziva ka mezi ha kasikwete kusimbulika. ha nikeza, zumwi wiza kuni hitilila.' ");
INSERT INTO sbs_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesu chati kwali, “Zimame, zalule vulo vwako, imi uyende.” ");
INSERT INTO sbs_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Haho vulyo mukwame chahola, imi chazalula vulo vwakwe, ni kuyenda. Linu iyo izuva ivali le Nsavata. ");
INSERT INTO sbs_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Cwale Majuda chivati kwali yava hozwa, “le Nsavata mikozumininwe kuhinda vulo vwako.” ");
INSERT INTO sbs_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Chetava, “Iye wanihoza wati kwangu, 'Tole vulo vwako uyende.'” ");
INSERT INTO sbs_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Chiva muvuza, “Njeni yozo muntu wa kuwambila, 'Vutole uyende'?” ");
INSERT INTO sbs_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nihakuva vulyo, uzu yava hozwa kena avezi kuti ivali njeni kakuli Jesu ava lovoki, kakuli kuvena vantu vangi hechi chivaka. ");
INSERT INTO sbs_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kuzwa aho, Jesu chamuwana mwi tepmele imi chati kwali, “vone, chiwava ni makete! Sanzi upangi chivi hape, ili kuti chimwi chiivilala sanzi chi pangahali kwako.” ");
INSERT INTO sbs_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mukwame cha yenda imi cha viha ku Majuda kuti ivali nji Jesu ya va muhozi. ");
INSERT INTO sbs_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Linu ivaka lyezi zintu Majuda chiva nyandisa Jesu, kakuli ava pangi izi zintu le Nsavata. ");
INSERT INTO sbs_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesu chavetava, Vandanda vakwetwe kutenda nangati hahanu, imi name, nikwete kutenda.” ");
INSERT INTO sbs_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Chevaka lyezi, Majuda chiva hupula kumwihaya nikuhitiliza kakuli kana vacholi feela i Nsavata, kono hapa ava sumpi Ireeza kuti njivesi, ava lilikanyezi ni mulimu. ");
INSERT INTO sbs_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Juse chavetava, “Niti niti, Mwana kakwina chawola kupanga mwine, kunde vulyo ya zavona Isi zapanga, chonse chapanga Isi, Mwana uzipanga naye. Kakuli ");
INSERT INTO sbs_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Musheni usaka Mwana umutondeza zinti zonse zapanga iye mwine, imi mwa mutondeze zintu zikando zihita izi ili kuti nawe mukomokwe. ");
INSERT INTO sbs_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kakuti Tayo ava vusi vafwile imi ava vahi vuhalo, ni Mwana nae uha vuhalo kumuntu yense ya saka. ");
INSERT INTO sbs_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","kakuli Tayo ka watuli muntu, kono kahe vuwatuli vonse ku Mwana ");
INSERT INTO sbs_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ili kuti vonse vakuteke Mwana muvakutekela Isi. Iye yasa kuteki Mwana kakuteki Isi yava mutumi. ");
INSERT INTO sbs_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Niti, niti, iye yo zuwa linzwi lyangu imi yo zumina yava nitumi wina vuhalo vusamani imi kete anyazahale, kono washila ifu kuya kuvuhalo. ");
INSERT INTO sbs_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Niti, niti, nimi wambila inako ikezite, imi njahanu, vafwile hete niva zuwe inzwii lya Mwana wa Ireeza, imi avo vete vazuwe muva hale. ");
INSERT INTO sbs_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Sina Tayo hena vuhalo mwali iye mwine, chovulyo avahi ku Mwanakwe ili kuti naye ave nivuhalo mwakwe mwine, ");
INSERT INTO sbs_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","imi Isi avahi Mwana mata kuzwila havusu ni nkatulo kakuli Mwana wa Muntu. ");
INSERT INTO sbs_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Sanzi mukomokiswa izi, kakuli kwina inako ikeza iyo vonse vena mumavita kava zuwe ilinzwi ");
INSERT INTO sbs_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","imi kaveze hanze: avo vavapangi vulotu kukuvuka kwa vuhalo, imi avo vava pangi vuvi kukuvuka kwe nkatulo. ");
INSERT INTO sbs_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Kakwina chini wola kulipangila nimwine. hani zuwa, ni watula, imi kuwatula kulukite kakuli kani kavulola kusaka kwangu kono cha kusaka kwa yava nitumi. ");
INSERT INTO sbs_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","haiva niswanela kupaka kuamana name, ");
INSERT INTO sbs_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","vupaki vwangu kete vuve vwe niti, kwina yo swanela paka kuamana name, mi nizi kuti vupakwi vaha kuamana name initi. ");
INSERT INTO sbs_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Uva tumini kwa Johani, imi avapaki vuniti. ");
INSERT INTO sbs_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kono vupaki vuni vatambuli kavuzwi kumuntu. Niwamba izi zintu kuti muwanela ku hazwe. ");
INSERT INTO sbs_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Johani ivali ilambi liva kunika niku venya, imi muvakuwola kutavela kusanga mwiseli lyakwe chenako zana. ");
INSERT INTO sbs_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Kono vupaki vunikwete vukando kovuna vwa Johani, ka musevezi wavanihi uwo wavani Tayo uva nihi kuumana, yonse misevezi ini panga, unipaka kuti Tayo ava nitumi. ");
INSERT INTO sbs_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tayo yava nitumi iye ava paki kuama name. yaseni kuzuwa inzwi lyakwe, kapa kuvona Chivupeho chakwe che nako. ");
INSERT INTO sbs_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","kamwina inzwi lyakwe lishele mwenu, kamuzumini muya vamitumi. ");
INSERT INTO sbs_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Musaka mañolo kakuli mu hupula kuti muali kamuve ni vuhalo vusa mani, Imi mañolo aswana apaka kuamana name, ");
INSERT INTO sbs_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","imi kamusaki kwiza kwangu ili kuti muve ni vuhalo. ");
INSERT INTO sbs_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Kaniwani kulumbekwa kuvaantu, ");
INSERT INTO sbs_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","kono nizi kuti kamwina ilato lya Ireeza mwenu. ");
INSERT INTO sbs_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nivakezi mwizina liva Tayo, imi kana muvani tambuli. Haiva zumwi nakeza mwizina lyakwe, kamumu tambule. ");
INSERT INTO sbs_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Muwola kuzuminz vule, inwe mutambula kulumbekwa kuvaantu kono kamu gani kulumbekwa kuzwakwa Ireeza? ");
INSERT INTO sbs_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Sanzi muhupuli kuti niwola kumihambiliza havusu vwa Tavo. yava mihambilizi nji Mushe, mwali mumu vavikite insepo yenu. ");
INSERT INTO sbs_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Haiva muva zumini Mushe, ni muva nizumini kakuli ava ñoli kuamana name. ");
INSERT INTO sbs_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","haiva kamuzumini zava ñoli, kamuzumine vule manzwii angu?” ");
INSERT INTO sbs_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Hazimana inzi zintu, Jesu chayenda kuyimwi imbali ye wate lya Galileya, hape livali kusupiwa I wate lya Tiberiya. ");
INSERT INTO sbs_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Vungi vwe chichava chivali kumwi chilire kakuli vava voni imakazo zavali kupanga kwavo vavali kulwala. ");
INSERT INTO sbs_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesu cha yenda kwirundu mi uko abake kali hasi ni varutwana vakwe. ");
INSERT INTO sbs_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","(Hanu mukiti we Paseka, Mukiti wa Majunda, uvali kwina hafuhi.) ");
INSERT INTO sbs_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Linu Jesu halola mwi wulu ni kuvona vantu vangi niva keza kwakwe, cha wambira Filipi, “Tuwola kuwula kuhi vuronto ili kuli ava vantu va wole kulya?” ");
INSERT INTO sbs_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Kono Jesu a vawambi ichi kulika Filipi, kakuli iye mwine ivali kwizi icho chavali kuswanera kupanga.) ");
INSERT INTO sbs_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipi cha mwi tava, “Miyanda yovere yamashereñi ovuroto kasa a wole kuwulira zumwi ni zumwi wavo nangati kakwa kanini.” ");
INSERT INTO sbs_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Zumwi wa valutwana vakwe, Adiriyasi, mukulwe wa Simoni Pita, chata kwa Jesu, ");
INSERT INTO sbs_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kwina muhwire wo muswisu hanu wina zikwa zeminwe ye yanza zo Vuroto ni nswi zo vere, kono chinzi ichi mukati ketu?” ");
INSERT INTO sbs_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesu chati, “Mwikalike vantu hansi.”( Hanu kuvena lyani liñgi mwe china chivaka,) Cwale vakwame chive kala hansi, valikana lule na lule lwe minwe yeyanza ku mpalo. ");
INSERT INTO sbs_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Linu Jesu chahinda vuloto mi hamana kuha vuitumero, cha tambika kwavo vavali kwi kere, mi kuswana nikwi inswi, chovungi sina muvavali kusakira. ");
INSERT INTO sbs_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Linu vantu havave kuti, cha wamba kuva lutwana vakwe, “Mukunganye vu fwafwali ni twa ngamoka twa shala, iri kuli kanji kuwaniki chi zova.” ");
INSERT INTO sbs_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Chale chiva tu kunganya ni kwizuza zitanda ze kumi ni tovere tufwafwali tuva zwi ha vuronto bwina palo ye minwe ye yanza ye; tu fwafwali tuva shali kwavo vavali. ");
INSERT INTO sbs_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Linu, vantu hava vona ichi chisupo chava pangi, chiva wamba, “Uzu chovu niti muporofita yo swanera kukeza mwi nkanda.” ");
INSERT INTO sbs_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Chale Jesu ha lemuha kuti chivavali kusaka kukeza ni kumukwata che nkani kuti vamupange mulena, cha zwengera yenke kuma Lundu. ");
INSERT INTO sbs_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Hachiyiza kuva chitengu, va lutwana vakwe chiva shetumukera kwi wate. ");
INSERT INTO sbs_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Chive chira muchikepe, mi vavali kuluta i wate kuya kwa Capenaume. Chikuvali kusiha cheyi nako, mi Jesu kena aveni kuka vola kale kuvali. ");
INSERT INTO sbs_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Imi i huho likolete livali kuhunga, mi iwate chili vali kutangite kulwa. ");
INSERT INTO sbs_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Hachi va zuhite chiuvaka chilikana makumi overe ni minwe ye yaza lyoke kamba makumi o tatwe muvule, chiva vona Jesu nakaya vuyenda he wulu lya wate ni kezite kumbali ni chikepe, mi vavali kutiyite. ");
INSERT INTO sbs_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Kono chati kuvali, “Njeme! Kanji mutiyi.” ");
INSERT INTO sbs_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Linu vavali kukusaka kumu longa muchi sepe, mi yahaho chisepe chicha kasika he rizo havavali kukaya. ");
INSERT INTO sbs_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Izuva lichilira, chinavungi chivali kuzimene kwishirya lye wate chiva vona kuti kena kuvena chimwi chikepe mbwita fera china choke, ni kuti Jesu kena ave chili mwateni ni varutwana vakwe kono kuti varutwana vakwe chivavali kuyendete vovona. ");
INSERT INTO sbs_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Niha kuva vulyo, kuvena amwi mato avali kukazwa kwa Tiberiasi hafuhi ni chivaka aho hava liri vuroto uvo Simwine hava litumeri. ");
INSERT INTO sbs_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Linu china vungi hachi lemuha kuti nangati Jesu kamba varutwana vakwe kena vavali kusikwina, cwale avo vene chiva chira mumato ni kuyenda kwa Capenaume kuka ngana Jesu. ");
INSERT INTO sbs_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Hachiva manite kumuwana kweyina imwi imbali ye wate, chiva cho kwali, “Rabbi, wakeza liri kunu?” ");
INSERT INTO sbs_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesu chave tava, ni kucho, “cho vuniti, niti, muni ngana, isiñi kuti muvavoni imakazo, kono ivaka lyokuti muvali vuroto vumwi bwe nkonko mi muve kuti. ");
INSERT INTO sbs_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kanji muverekeri zilyo inzo zisinyeha, kono muverekere zilyo zikala inako kutwala kuvahalo vusa mani uvo Mwana o Muntu bwasa mihe, kwe Ireeza Isi ava viki iswayo hali.” ");
INSERT INTO sbs_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Cwale chivati kwali, “Chizi chi tuswanera ku panga, iri kuli tuwole kupanga misevezi ye Ireeza?” ");
INSERT INTO sbs_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesu che tava ni kuta kuvali, “Uwu njo musevezi we Ireeza: kuti mu zumine ku yenke unzo yavaka tumi.” ");
INSERT INTO sbs_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Chwale chiva ta kwali, “Chechihi chisupo cwale choso pange, iri kuli tuvone ni kuku zumina? Chinzi choto pange? ");
INSERT INTO sbs_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Veshetu vavali maana mwi halaupa, sina hakuñoletwe,'Avavahi inkonko izwa kwi wuulu kulya.” ");
INSERT INTO sbs_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Linu Jesu chave tava, “Chovu niti, niti, kena ivali Mushe yava mihi inkonko kuzwa mwi wuulu, kono ivali Tayo yo miha inkonko ye niti izwa kwi wulu. ");
INSERT INTO sbs_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kakuti inkonko ye Ireeza je china chi zwa kwiwulu ni kukeza hansi ni kwiza kuha vuhalo kwi nkanda.” ");
INSERT INTO sbs_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Cwale chiva wamba kwali, “Nfumwetu, utuhe iyi inkonko inako yonse.” ");
INSERT INTO sbs_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesu cha wamba kuvali, “Jeme ni nkonko yo vuhalo; uzo yo keza kwangu kasane ka fwe inzala, mi uzo yo zumina mwangu kesane kafwe inyota. ");
INSERT INTO sbs_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kono ni vami wambiri chovu niti muvani voni, mi kamu zumini. ");
INSERT INTO sbs_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Yense uzo Tayo waniha mwa keze kwangu, mi yense yo keza kwangu chovuniti kaseni muzindire hanze. ");
INSERT INTO sbs_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kakuti niva kezi hansi kukazwa kwi wulu, isiñi kwiza kupanga itato yangu, kono chasaka iye uzo yavaka ni tumi. ");
INSERT INTO sbs_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Imi iyi nji tanto yakwe uzo yava kanitumi, kuti kanji ni zoverwa nangati yenke kwavo vonse vavanihi, kono kaniva vunse mwizuva lyama mani mani. ");
INSERT INTO sbs_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kakuli iyi nje tanto ya Tayo, kuti yense yo vona Mwana ni kuzumina mwali mwave ni vuhalo vusa mani mi kanimu vunse mwi zuva lya ma mani-mani. ");
INSERT INTO sbs_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Cwale majunda chivatanga kukumbola kuamana naye kakuti avati, “Njeme ni nkonko iyo yaka zwa kwi wulu.” ");
INSERT INTO sbs_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Chiva wamba, “Uzu kanjiyena Jesu mwana wa Josefa, uzo insi ni nyina tuve zi? Kwiza vule hape hanu kuti awambe, 'Nakazwa kwi wulu '?” ");
INSERT INTO sbs_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesu che tava ni kuvata, “Musiye kukumbola mukati kenu. ");
INSERT INTO sbs_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kakwina zumwi yo wola kukeza kwangu mbwita Tayo yava kanitumi hamu chuza, mi kani muvunse mwi zuva lyama mani-mani. ");
INSERT INTO sbs_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ku ñoletwe muma porofita, 'Yense karutiwe nji Ireeza. 'Yense yava zuwi ni kulituta kwa Tayo ukeza kwangu. ");
INSERT INTO sbs_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kena kuti vonse vava voni Tayo, mbwita fera iye yokazwa kwe Ireeza- ava voni Tayo. ");
INSERT INTO sbs_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Chovu niti, niti, iye yo zumina wina vahalo vusa mani. ");
INSERT INTO sbs_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Jeme ni nkonko yo vuhalo. ");
INSERT INTO sbs_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Veshenu vavali maana mwi halaupa, mi vava mani kufwa. ");
INSERT INTO sbs_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Iyi nje nkonko ikeza hansi kukazwa kwi wulu, iri kuli muntu awole kulya yimwi kuili ni kusa fwa. ");
INSERT INTO sbs_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Jeme ni nkonko i hala iyo ikazwa kwi wulu. Haiva zumwi ulya kuili iyi nkonko, mwa hale kuya kuire. Inkonko iyo yete nihe inyama wangu kuvu halo vwe kanda.” ");
INSERT INTO sbs_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Majunda chiva venga mukati kavo vene niku tanga kukanana, nivati, Kuwoleka vule kuti uzu mukwame atuhe inyama wakwe kuti tulye?' ");
INSERT INTO sbs_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Cwale Jesu cha wamba kuvali, “Chovu niti, niti, kwanda yo kuti mulye inyama o Mwana o Muntu ni kunwa malaha akwe, kete muve ni vuhalo mwenu. ");
INSERT INTO sbs_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Yense yolya inyama wangu ni kunwa malaha angu wina vuhalo vusa mani, mi kani muvuse mwizuvalya mamanikizo. ");
INSERT INTO sbs_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kakuti inyama yangu chilyo che niti, mi malaha angu chinwiwa che niti. ");
INSERT INTO sbs_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Iye yo lya inyama wangu ni kunwa malaha angu ushala mwangu, ni me mwali. ");
INSERT INTO sbs_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Sina Tayo yo hala havaka ni tumi, mi sina hani hala ivaka lya Tayo, cwale iye yonilya, mwahale naye ivaka lyangu. ");
INSERT INTO sbs_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Iyi nje nkonko ina yakeza hansi kukazwa kwi wulu, isiñi uvu veshenu vavali ni kufwa. Iye yo lya iyi nkonko mwahale kuya kuire.” ");
INSERT INTO sbs_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Kono Jesu avali kuwamba inzi zintu mwi sinangonge na kwete kuruta mwa Capenaume. ");
INSERT INTO sbs_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Cwale vungi vwava rutwana vakwe vava zuwi izi chiva ti, “Iyi ituto ikavo ahulu; jeni yo wola kuitambula?” ");
INSERT INTO sbs_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesu, kakuli avali kwizi mwali kuti varutwana vakwe vavali kukumbola heyi dava, chati kuvali, “Kana ichi chimi nyeza? ");
INSERT INTO sbs_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Cwale mukuve vule aho hasane kamuvone Mwana o Mutu nakambama kuta uko kwavali kwina sapilio? ");
INSERT INTO sbs_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Luhuho luha vuhalo; inyama kakwina chi ivozekeza. Mazwi awo ani vawambi kwenu nga luhuho, mi go vuhalo. ");
INSERT INTO sbs_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Imi kwina vamwi kwenu avo vasa zumini.”Kakuti Jesu avali kwinzi kuzwa kuma tangiro kuti mbani avo vate ni vakangwe kuzumina mi njeni uzo yate na muveteke. ");
INSERT INTO sbs_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Cha wamba, “I vaka lyezi kuti na miwamba kwenu kuti kakwina zumwi yo wola kukeza kwangu mbwita haiva wa zumininwa kwa Tayo.” ");
INSERT INTO sbs_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kevaka lyezi, vungi bwa varutwana chiva vola kumusiya mi kena vavazwiri havusu ni kumwi chilira. ");
INSERT INTO sbs_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Linu Jesu cha wamba kuvana ikumi ni tovere, “Inwe nanwe kamusaki kuyenda nanwe, musaka?” ");
INSERT INTO sbs_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoni Pitorosi chamwi tava, “Simwine, njikwani kwete tuyende? Wina manzwi ovuhalo vusa mani, ");
INSERT INTO sbs_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","mi tuva zumini ni kwiza kwiziva kuti jewe yo Chena yenke we Ireeza.” ");
INSERT INTO sbs_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesu cha wamba kuvali, “Kena kuti ni vamiketi, vena ikumi ni minwe yovere, imi zumwi kwenu ji diavulusi?” ");
INSERT INTO sbs_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Hanu avali kuwamba kuama ni Judasi mwana wa Simoni Isikariyoti, kakuti ivali iye, omumwina kuvena ikumi ni tovere, kakuti ivali njiyena, uzo yatane veteke Jesu. ");
INSERT INTO sbs_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Mi hakuzwa izi zintu Jesu avayendauli mwa Galilee, kaho kena va kusaka kuyenda kwa Judea chevaka lyokuti majuda vava kumusaka kuti va mwihaye. ");
INSERT INTO sbs_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Hanu mukuti wa majuda wa munzunde uva kwina hafuhi. ");
INSERT INTO sbs_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Va mukulwe cwale chiva muwambila, “siye chivaka ichi uyende kwa Judea, njokuti va rutwana vako va vone mitendo yo panga. ");
INSERT INTO sbs_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kakwina ya panga chintu ku mukunda iye mwine na saka kuti chivoneke. Haiva upanga izi zintu, livonahaze kwinkanda.” ");
INSERT INTO sbs_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kaho nanga va mukulwe kena vava zumini kwali. ");
INSERT INTO sbs_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesu cwale cha wamba kuvali, “inako yangu kena ya sika kale, kono inako yenu ilyitukise kale. ");
INSERT INTO sbs_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Inkanda kalyi woli kumi toya, kono lyi toya ime kevaka lyokuti ni paka za mitendo yalyo mivi. ");
INSERT INTO sbs_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Muyenda haisi ku mukiti; kani yendi kowu mukiti kakuti inako yangu kaini ku talelezwa.” ");
INSERT INTO sbs_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Hachamana ku wamba izi zintu kuvali, che kala mwa Galileya. ");
INSERT INTO sbs_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kono va mukulwe hati chivayenda ku mukiti, naye chayenda, isiñi na voneka kono cho kulipata. ");
INSERT INTO sbs_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Majuda vava kumusaka ku mukiti niku wamba, “wina hi?” ");
INSERT INTO sbs_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kuva kwina ku wambolisana mukati ke chisi kuamana naye. Vamwi vava wambi, “Mukwame ushiyeme.” Vamwi vava wambi, “Ne, Uyendisa vantu munzila isali njeyo.” ");
INSERT INTO sbs_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Naho ka kwina yava wambi cha kuzuweka kuamana naye cho kutiya ma Juda. ");
INSERT INTO sbs_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Mukiti hachi uva kwina hakati kokumana, Jesu chayenda mwi ntempele nikukatanga kuka ruta. ");
INSERT INTO sbs_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Cwale ma Juda chiva komoka, niva wamba, “Uzu mukwame wizi vule zingi? kena va lituti.” ");
INSERT INTO sbs_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesu cha vetava niku wamba, “intuto zangu kena nji zangu, kono njiyakwe wani tuma. ");
INSERT INTO sbs_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Haiva kwina yo saka ku panga intato yakwe, kezive kuamana nezi intuto, kapa zizwa kwe Ireeza, kapa ni wamba ka lwangu. ");
INSERT INTO sbs_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Yense yo wamba ka lwakwe ungana inkaya yakwe iye mwine, kono iye ya ngana inkanya yozo wa tuma uzo muntu we niti, mi kakwina kusa njolola kwali. ");
INSERT INTO sbs_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Kena kuti Mushe ava mihi mulao? Kono kakwina kwenu ye chilila mulao. Chinzi hamu saka kunihaya?” ");
INSERT INTO sbs_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","chisi cha vantu chichetava, “wina i dimona. Njeni yo saka kukwihaya?” ");
INSERT INTO sbs_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesu chetava niku va wambila, “na panga mutendo wonke, mi muvonse mukomoswa ke vaka lyecho. ");
INSERT INTO sbs_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mushe ava mihi mupato (isike kuti izwa kwa Mushe, kono kuve sukulwetu), mi he nsavata mu panga muntu mupato. ");
INSERT INTO sbs_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Haiva mukwame upangwa mupato he nsavata njokuti mulao wa Mushe kanzi ucholwa, chinzi hamuni vengele kakuli na panga mukwame kunjolola he nsavata? ");
INSERT INTO sbs_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kanji muatuli cha mayemo amuntu mwa vonekela, kono mu watule cho kunjolola.” ");
INSERT INTO sbs_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Vamwi kuvali vakwa Jerusalema vava wambi, “kena njiyena uzu ivakwete kungana kuti va mwihaye? ");
INSERT INTO sbs_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mi muvone, uwamba na lukuluhite, mi kakwina chiva wamba kwali. kena kuti initi va yendisi vezi luli kuti uzu njiyena Kreste, iwola kuva? ");
INSERT INTO sbs_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kono nitwizi kuti uzu uzwahi. Kono Kreste ha cheza, kakwina yete izive kuti ukazwila hi.” ");
INSERT INTO sbs_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Cwale Jesu cha lila mwi ntempele, kuruta niku wamba, “muvonse munizi mi mwizi kuni kazwilila. Kena na keza ka lwangu, kono iye wani tuma we niti, mi ka mumwizi. ");
INSERT INTO sbs_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ni mwizi kevaka lyo kuti nikazwa kwakwe mi wa kanituma.” ");
INSERT INTO sbs_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Vava kulikite ku musumina, kono kakwina yava muviki iyanza chevaka lyokuta kuti inako yakwe kena ivali kusikite. ");
INSERT INTO sbs_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Kono vungi bwa vantu vava zumini kwali, mi chiva wamba, “Kreste hacheza, ka pange zisupo kuhita izi za panga uzu?” ");
INSERT INTO sbs_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ma Farisi vava zuwi vantu niva shovota izi zintu kuamana ni Jesu, ni mu prisita mukulwana nima Farisi chiva tumina ma pokola kuka musumina. ");
INSERT INTO sbs_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesu cwale cha wamba, “ni sina nanwe che nako inini fela, mi cwale niyenda kwali wani tuma. ");
INSERT INTO sbs_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kamuni ngane kono kete muni wane; kwete niyende, kete muwole kwiza.” ");
INSERT INTO sbs_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ma Juda cwale chiva liwambila mukati kavo, “kayende kuhi uzu mukwame kwete tuwole kusa muwana? ka yende kuma Greek va hasene nikuka ruta ma Greek? ");
INSERT INTO sbs_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","linzwi inzi ilyi lya wamba, 'koni ngane kono kete uni wane; kwete ni yende, kete mu wole kwiza'?” ");
INSERT INTO sbs_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Linu cha mamani, izuva lyi kando lyo mukiti, Jesu cha zimana niku lila, kuwamba, “haiva kwina yo fwile inyotwa, mumusiye eze za nwe kwangu. ");
INSERT INTO sbs_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Iye ya zumina kwangu, sina mulyitela iñolo, lwizi lwa menzi ahala ka luvuve mwi vumo lyakwe.” ");
INSERT INTO sbs_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Kono ava wambi izi kuamana ni Luhuho, kwavo va zumina kwali muva tambule; Luhuho kena lyiveni kuhewa kevaka lyo kuta kuti Jessu kena va sini ku nyamwinwe. ");
INSERT INTO sbs_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Vamwi vantu muchisi, hava zuwa manzwi aya, chiva wamba, “Uzu muporofita luli.” ");
INSERT INTO sbs_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","vamwi vava wambi, “Uzu njiyena Kreste.” kono vamwi vava wambi, “Kreste uzu uzwa kwa Galileya? ");
INSERT INTO sbs_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kena kuti ma ñolo ava wambi kuti Kreste mwa kazwile kwi shika lya Davida mikwa Bethelehema, muzi uko Davida avakwina?” ");
INSERT INTO sbs_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Cwale chikwava niku liyava mu chisi che vaka lyakwe. ");
INSERT INTO sbs_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Vamwi vava kusaka kumusumina, kono kakwina yava viki iyanza hali. ");
INSERT INTO sbs_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Cwale ma pokola vava kavoli nima Prisita vakuluna ni ma Falisi, vava wambi kwali, “chinzi hasena mwa muleta?” ");
INSERT INTO sbs_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Mapokola chivetava, “Kakwina yava wambi vuti.” ");
INSERT INTO sbs_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Cwale ma farisi chiva mwitava, “Chova kuchengetwe nawe? ");
INSERT INTO sbs_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","kana kwina va yendisi vava zumini kwali, kapa kuma Falisi? ");
INSERT INTO sbs_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kono ichi chisi chisezi mulao, va kutitwe.” ");
INSERT INTO sbs_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemus (zumwi wa ma Falisi, vava kezi kwali kumatingilo), cha wamba kuvali, ");
INSERT INTO sbs_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Mulawo wetu u atula muntu ni useni kuzuwa kwali nicho cha panga?” ");
INSERT INTO sbs_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","chivetava niku wamba kwakwe, “nawe uzwa kwa Galileya? sakisise uvone kuti kakwina muporofita yozwa kwa Galileya.” ");
INSERT INTO sbs_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Cwale zumwi ni zumwi cha yenda kwi nzuvo yakwe. ");
INSERT INTO sbs_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesu avayendi kwi Lundu lya Olive. ");
INSERT INTO sbs_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kuseni-seni avakezi kwi tempele hape, linu vantu vangi vava kezi; chi kala hansi nikuva luta. ");
INSERT INTO sbs_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Vañoli ni ma Falisi nivaleta mwanakazi yava swalehi. Chiva muvika hakati. ");
INSERT INTO sbs_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Linu chiva mucho, “Muluti, uzu mwanakazi wa swaleha. ");
INSERT INTO sbs_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Lyahanu mumulawo wetu, Mushe avatulaeli kuti vantu vena vuti vaswanela kupwacholwa ni mañomwe; uwamba nzi kuamana naye?” ");
INSERT INTO sbs_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Vavawambi vulyo chokuti vawane inzila yo kumu hambiliza, kono Jesu ava sungami nikuñola hansi ni munwe wakwe. ");
INSERT INTO sbs_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Hava zwila havusu kumuvuza, avazimi nikuwamba kuvali, “Iye yasena chivi kwenu, ave wentanzi kumuzinda iñomwe.” ");
INSERT INTO sbs_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Hape chakotamina hansi, niku ñola hansi ni munwe wakwe. ");
INSERT INTO sbs_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Hava zuwa bulyo, chivayenda umwina ka umwina, kutangila kumu kulwana. Kuma mani mani Jesu ava shali yenke, ni mwanakazi yavena hakati. ");
INSERT INTO sbs_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesu chazimana nikumuvuza, “Mwanakazi va hambilizi vako vena kuhi? Kakwina wakunyaza?” ");
INSERT INTO sbs_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Cha wamba, “Kakwina Simwine.” Jesu chati, “Name kani kunyazi. Yende ukasiye kupanga chivi hape.” ");
INSERT INTO sbs_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Hape Jesu avawambi kuvali kuta kuti, “Njeme niseli lwe nkanda; iye yoni chilila kete ayende mukansikwe kono mwave niseli lyo vuhalo.” ");
INSERT INTO sbs_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ma Falisi chiva muwambila, “Uhindite vupaki hako; vupaki vwako kena vwe niti.” ");
INSERT INTO sbs_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesu chavetava nikuvata kuti, nanga hanilihindila vupaki vwangu, vupaki vwangu vwe niti. Nizi kunizwa ni kuni kaya, kono inwe kamwizi kunikazwa kapa kunikaya. ");
INSERT INTO sbs_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Muatula ke nyama; kono kakwina ini atula. ");
INSERT INTO sbs_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nanga anitula, inkatulo yangu yeniti kakuli kanikele nenke, kono nina ni Tayo yo nitumite. ");
INSERT INTO sbs_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Eeye, nanga mumulao wenu kuñoletwe kuti vupaki vwa vantu vovele vwe niti. ");
INSERT INTO sbs_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Njeme nili hindila vupaki vwangu, hape Tayo yo nitumite wina vupaki vwangu.” ");
INSERT INTO sbs_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Vavawambi kwali, “Iso wina kuhi?” Jesu chetava, “Kakwina imwizi ime kapa Tayo; kambe munizi, ni mweziva ni Tayo naye.” ");
INSERT INTO sbs_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","avawambi aa manzwi muchivulukelo na kwete kuruta mwi tempele, mi kakwina yava musumini kakuti inako yakwe kena iveni kusika. ");
INSERT INTO sbs_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Cwale hape ava wambi kuvali, “niya kungi; kamuni ngane mi kamufwile mu chivi chenu. Kuniya, kamuwoli kwiza koo.” ");
INSERT INTO sbs_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ma Juda chiva wamba, “kalihaye iye mwine? chingi uwamba; Kuniya kamuwoli kuya kwateni'?” ");
INSERT INTO sbs_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesu cha wamba kuvali, “uzwa ku nsi; nizwa kwi wulu. Uwe nkanda iyi; ime kena niwe nkanda iyi. ");
INSERT INTO sbs_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Cwale he, na miwambila kuti kamufwile mu zivi zenu. Haisi hachi mwa zumina kuti Ime Njime, ka mufwe muzivi zenu.” ");
INSERT INTO sbs_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Chiva wamba cwale he kwako, “Njewe ni?” Jesu cha wamba kwavo, “China wamba kwenu kuma tangilo. ");
INSERT INTO sbs_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nina zintu zingi zo kuwamba ni kuwatula kwenu. Nihakuva bulyo, iye wani tuma we niti; mi zintu zina zuwa kwali, izi zintu ni wamba kwi nkanda.” ");
INSERT INTO sbs_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Kena vava zuwisisi kuti ava kuwamba kuvali ze Shetu. ");
INSERT INTO sbs_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jesu cha wamba, “Hamumana kunyamuna mwana Muntu, cwale mumwizive kuti Njeme, mi kakwina zangu zini lipangila. Sina ishangu mwava ni rutili, ni wamba izi zintu. ");
INSERT INTO sbs_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Iye wani tuma wina name, mi kena ni siya nenke, kakuti ni panganga chimu tavisa.” ");
INSERT INTO sbs_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Sina Jesu hava kuwamba izi zintu, vangi vava zumini kwali. ");
INSERT INTO sbs_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesu cha wamba kuvo ma Juda vava zumini kwali, “Haiva mushala mu linzwi lyangu, cwale muva rutwana vangu ve niti, ");
INSERT INTO sbs_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","mi kamwizive initi, mi initi kai milukulule.” ");
INSERT INTO sbs_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","chiva mwitava mwitavi, “Tuvana va Abrahama mi kena tuvavi va hikana va muntu; uwola kuwamba vule, 'ka mulukuluhe'?” ");
INSERT INTO sbs_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesu cha vetava, “Niti, niti, nimi wambila, yense yo tenda chivi muhikana we chivi. ");
INSERT INTO sbs_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Muhikana ke kalilili mwizuvo kuya kwile; mwana wi kalilila. ");
INSERT INTO sbs_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Cwale he, haiva mwana umilukulula, ke niti ka mulukuluhe. ");
INSERT INTO sbs_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nizi kuti muvana va Abrahama; mukwete kungana kunihaya kakuti linzwi kalyina chivaka mwenu. ");
INSERT INTO sbs_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ni wamba chini va voni ni Ishangu, mi mupanga chimu vazuwi kwe shenu.” ");
INSERT INTO sbs_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Chiva mwitava niku wamba, “Ishetu nji Abrahama.” Jesu cha wamba kuvali, “kape sekeli muvana va Abrahama, nimwa panga mitendo ya Abrahama. ");
INSERT INTO sbs_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kono, hanu musaka kuni haya, mukwame yava miwambili initi ini vaka zuwi kwe Ireeza. Abrahama kena va pangi izi. ");
INSERT INTO sbs_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mupanga mitendo ye Shenu,” chiva mu wambila, “Kena tuva zalwa muvuliyendezi; twina Shetu yenke: Ireeza.” ");
INSERT INTO sbs_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesu cha wamba kuvali, “Haiva kape Ireeza nji Ishenu, nimwani saka, kaho nikazwa kwe Ireeza mi imozu; kaho kena niva kezi ka lwangu, kono ava ni tumi. ");
INSERT INTO sbs_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Chinzi hamu sa zuwisisi manzwi angu? Ivaka lyo kuti kamuwoli kuzuwa manzwi angu. ");
INSERT INTO sbs_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Muve shenu, iye dyavulusi, mi musaka ku panga intato ze shenu. Ivali chihayi kuma tangilo mi kazimani he niti kakuti kakwina vuniti mwali. Hawamba vupono, uwamba cho mukwa wakwe ni isi wai zwile mapa. ");
INSERT INTO sbs_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kono, kakuti ni wamba vuniti, kamu zumini. ");
INSERT INTO sbs_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Njeni kwenu yoni hambika chivi? haiva ni wamba vuniti, chizi hamu sa zumini? ");
INSERT INTO sbs_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Iye yazwa kwe Ireeza uzuwa manzwi ee Ireeza; kamu ya zuwi kakuti ka muzwi kwali.” ");
INSERT INTO sbs_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ma Juda chivetava niku mu wambila, “Kena kuti tuwamba kuti umu Samariya mi wina i dimona?” ");
INSERT INTO sbs_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesu che tava, “kanina i dimona, kono ni kuteka Shangu, mi kamuni kuteki. ");
INSERT INTO sbs_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kani ngani inkaya yangu; kwina yo ngana niku watula. ");
INSERT INTO sbs_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Niti, niti, nimi wambila, haiva kwina yata vike linzwi lyangu, keta vone ifu.” ");
INSERT INTO sbs_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ma Juda vava wambi kwakwe, “Hanu twizi kuti wina i dimona. Abrahama nima porofita vavafwi; kono iwe uwamba, 'haiva kwina yata vike linzwi lyangu, keta zuwe ifu.' ");
INSERT INTO sbs_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Kena umukando kuhata ishetu Abrahama yava fwii, vule? Ma porofita navo vavafwi. Uhupula kuti njewe ni?” ");
INSERT INTO sbs_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesu che tava, “haiva nili nyamuna ime ni mwine, inkanya yangu kahena; nji Isi wangu yoni nyamuna-koo imuwamba kuti nji Ireeza wenu. ");
INSERT INTO sbs_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ihati mwa mwiziva, kono ni mwizi. Haiva ni wola kuwamba, 'kani mwizi; kani swane sina njenwe, ihata. Nihakuva bulyo, ni mwizi nikuvika linzwi lyakwe. ");
INSERT INTO sbs_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ishenu Abrahama ava sangi chokuvona izuva lyangu; ava lyivoni niku nyakalala.” ");
INSERT INTO sbs_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ma Juda vava wambi kwali, “kawini kukwanisa makumi akwana iyanza ezilimo, mi muva voni Abrahama?” ");
INSERT INTO sbs_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesu chava wambila, “Niti, niti, nimi wambila, Abrahama naseni, Njeme.” ");
INSERT INTO sbs_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Cwale chiva tola mabwe niku musoholera kono Jesu cha lipata nikuzwa mwi tempele. ");
INSERT INTO sbs_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Linu Jesu habahitite, nabona mukwame yabazalwa nalimuhofu. ");
INSERT INTO sbs_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Barutwana bakwe chibamubuza, “Muruti, babatendi chive njibani, uzu mukwame kapa bazazi bakwe, habazalwa nalimuhofu?” ");
INSERT INTO sbs_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesus abetabi, “Kenakuti uzu mukwame aba tendi chive nandi bazazi bakwe “kono kuti mitendo ya Ireeza ibungutulwe chali. ");
INSERT INTO sbs_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tutameha kutenda mitendo yozo yabanitumi nichili musihali. Masiku akezite mweyonako kakwina yeti nawole kusebeza. ");
INSERT INTO sbs_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Hanichina muchisi, njime nisele lyechinu chisi. ");
INSERT INTO sbs_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jesu hamana kuwamba izi zintu, naswila hansi, kutenda itope chamate, imi nasinga itope hamenso akwe. ");
INSERT INTO sbs_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Nichati kwali, “Yenda, kasambe muchihumbi cha Siloe (Itoloka kuti: kutumwa.” Hakwinabulyo mukwame naliyendela, nakasamba, imi nakabola chobona. ");
INSERT INTO sbs_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Hahabulyo bababambene nozo mukwame nabana babamuboni nali mukumbili babali kuwamba kuti, “Uzu kanjiyena yaba kuikalanga na kumbila?” ");
INSERT INTO sbs_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Balikene nibati, “Nji yena” Bamwi nibati, “Nanta, kono uboneka ubu njeye.” imi iye chati, “Njime.” ");
INSERT INTO sbs_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nibati kwali, “Linuhe menso ako ayeluki bule?” ");
INSERT INTO sbs_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Netaba, mukwame yo sumpwa Jesu watenda itope ni kunisunga amenso angu imi nati kwangu, 'Yende kwa Siloe mi uka sambe,' Chobulyo chinayenda imi ninakasamba imi ninatanga kubona.” ");
INSERT INTO sbs_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nibati kwali, “Winahi iye?” Netaba nati, “kanizi.” ");
INSERT INTO sbs_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Nibaleta mukwame yaba kubanga chihofu ku Mafalisi. ");
INSERT INTO sbs_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Linu ibali izuba lye nsabata ilyo Jesu aba tendi itope heyalula menso akwe. ");
INSERT INTO sbs_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Linu hape Mafalisi chiba mubuza mwaba bonene. Nati kubali, “Wabika itope hamenso angu, naka samba imi hanu chini bona.” ");
INSERT INTO sbs_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Balikene ku Bafilisi nibati, “Uzu mukwame kazwi kwa Ireeza mukuti kechilili Insabata.” Bamwi nibati, “Kwiza buti kuti mukwame wina chive atende imakazo zisika aha?” Chobulyo ni kwaba ni kuliyaba mukati kabo. ");
INSERT INTO sbs_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Chobulyo nibabuza mukwame wechihofu hape, “Utinzi kuamana naye mukuti njobeyalulwa menso kwali?” Mukwame wechihofu nati, “mutanikizi.” ");
INSERT INTO sbs_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nangaho Majuda kanababazumini kuti ibali chihofu yabeyalulwa menso ulukusikila habasumpa bazazi bakwe yasanaabali kubona. ");
INSERT INTO sbs_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Nibabuza bazazi bakwe, “Uzu nji mwanenu wamuswisu imutakuti abazalwa nali chihofu? Kwiza buti kuti linu abone?” ");
INSERT INTO sbs_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Chobulyo bazazi bakwe babetabi, “Twizi kuti uzu nji mwanetu wamuswisu nikuti aba zalwa neli chihofu. ");
INSERT INTO sbs_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Mukubezili kuti abone hanu katwizi, ni yabeyaluli menso akwe katwizi. Mumubuze, mukulwana. Uwola kuliwambilila iye mwine.” ");
INSERT INTO sbs_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Bazazi bakwe babawambi izi zintu, mukuti babakutite Majuda. Mukuti Majuda chiba babazuminzene kale kuti iye yete alizumine kuti nji Kreste mubamuhindikile kunze yamasinagoge. ");
INSERT INTO sbs_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Chebaka lyezi, bazazi bakwe nibati, “Mukulwana, mumubuze.” ");
INSERT INTO sbs_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Mukuti chibabahitite tobole nibasumpa mukwame yabakubanga chihofu ni chibati kwali, “Uhe ikanya kwa Ireeza. Twizi kuti uzu mukwame mutendi wazive.” ");
INSERT INTO sbs_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Linu uzo mukwame netaba, “Kanizi nandi mutendi wazive. Chimwi chinizi: Nibali nimuhofu, imi hanu chinibona.” ");
INSERT INTO sbs_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Kuzwaho nibamuti, “Chinzi chabatendi kwako? Abeyalula buti menso ako?” ");
INSERT INTO sbs_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Abetabi, namiwambila kale, imi kamutekelezi! Chinzi hamusaka kuzuwa chimwi hape? Kamusaki kuba barutwana bakwe nanwe, nandi musaka? ");
INSERT INTO sbs_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Nichibamutuka imi nibati, “Umurutwana wakwe, imi iswe tubarutwana ba Mushe. ");
INSERT INTO sbs_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Twizi kuti Ireeza abawambi kwa Mushe, imi katwizi kuti uzu uzwa kuhi.” ");
INSERT INTO sbs_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mukwame netaba nabacho, Ichi chikomosa, kuti kamwizi kwazwa, kono abeyaluli menso angu. ");
INSERT INTO sbs_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Twizi kuti Ireeza katekelezi batendi bazive, kono haiba muntu ulibekite kwa Ireeza ni kutenda intato yakwe, umutekeleza. ");
INSERT INTO sbs_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kutanga kumatangilo achisi kana kubeni kuzuweka kuti kwina ichabeyaluli menso amukwame yabazalwa neli muhofu. ");
INSERT INTO sbs_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Haiba uzu mukwame kazwi kwa Ireeza, kakwina chiti nabatendi.” ");
INSERT INTO sbs_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nibamwitaba nibati, “Iwe ubazalilwa muzive kumaniniza, imi utuluta?” Hahobulyo nibamusohela kunze.” ");
INSERT INTO sbs_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesu abazuwi kuti babamuhindikili hanze yesinagoge. Hamusangana nati, “Uzumina ku Mwana Muntu na?” ");
INSERT INTO sbs_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Netaba nati, “Njeni uzo, Simwine, kokuti nizumine kwali?” ");
INSERT INTO sbs_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesu nati kwali, “Ubamuboni, imi njeyena yowamba nawe.” ");
INSERT INTO sbs_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Mukwame nati, “Simwine, nizumina” imi namulapela. ");
INSERT INTO sbs_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesu nati, “Kuatulwa chinibezili mwechinu chisi kokuti basaboni babone imi kokuti bana babona basanduke zihofu.” ");
INSERT INTO sbs_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Balikene ku Bafalisi babena naye babazuwi izi zintu imi nibamubuza, “Kana naswe bulyo tubahofu?” ");
INSERT INTO sbs_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesu nabati, “Haiba mubali muzihofu, nimusena mubabi ni zive, kono hanu muti, 'Tubona,' chobulyo chive chako muzishale bobulyo. ");
INSERT INTO sbs_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ikumbya line, nimiwambila, iye mwine yaseti enjile chamulyango wamulaka wembelele, kono utata kwiwulu chenzila imwi, unzo muntu musa mi wiba. ");
INSERT INTO sbs_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Iye winjilila kumulyango nji mulisana wembelele. ");
INSERT INTO sbs_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mubabaleli wamulyango mwamwiyalwile. Imbelele zizuwa inzwi lyakwe, mi usupa imbelele zakwe chamazina ni kuzietelela hazizwa. ");
INSERT INTO sbs_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Linu heti chazizwisa nzose zakwe, uziyenda kubusu, mi imbelele zimwichilila, mukuti zinzi inzwi lyakwe. ");
INSERT INTO sbs_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Linu keti nizichilile muyenzi, kono kazimukekuluhe, mokuti kanzinzi inzwi lyamuyenzi.” ");
INSERT INTO sbs_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesu abawambi iyi nguli kubali, kono abo kanababazuwisisi kuti izi zintu ibali nji zona zabali kuwamba kubali. ");
INSERT INTO sbs_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Linu Jesu chawamba kubali hape, Ikumbya line, Nimi wambila, Njime nimulyango wembelele. ");
INSERT INTO sbs_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Yese yabezi kumasule angu musa mi wiba, kono imbelele kena zibamuteki. ");
INSERT INTO sbs_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Njime nimulyango. Yese winjila changu, kapuluswe; kenjile mukati ni hanze mi kawane malisikizo. ");
INSERT INTO sbs_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Musa kawoli kwiza heba kezi kwiba kapa kwihaya ni kushinya. Nibakezi kuti benze bawane buhalo mi babu wane cha bungi. ");
INSERT INTO sbs_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Njime nimulisana weniti. Mulisana weniti uha buhalo bwakwe muchibaka chembelele. ");
INSERT INTO sbs_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mubeleki wakuhila kahena mulisana wembelele imi kamunite imbelele. Habona untuhu nakezite usiya imbelele ni kubaleha. Utuhu uwonda imbelele ni kuzihasanya. ");
INSERT INTO sbs_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Utiya mukuti mubeleki wakuhila kabileli ni mbelele. ");
INSERT INTO sbs_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Njime ni mulisani weniti, imi nizi zangu, mi zangu zinizi. ");
INSERT INTO sbs_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Tayo unizi, imi name nizi Tayo, imi nibahi buhalo bwangu muchibaka che mbelele. ");
INSERT INTO sbs_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nina imbelele zimwi zisali nzowo mulaka wembelele. Niyelele kuzileta nazo, imi kazizuwe inzwi lyangu kokuti ibe mutapi wonke ni mulisana yenke. ");
INSERT INTO sbs_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Njikeli ibaka Tayo hanisaka: Nisinyehelwa buhalo bwangu kokuti ninibuhinde hape. ");
INSERT INTO sbs_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kakwina yowola kubuninyanga, kono nibusinyehelwa changu nimwine. Nina maata akuzwisa, imi nina maata akuhinda hape. Nibawani iyo itaelo kuba Tayo. ");
INSERT INTO sbs_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kuliyabahakati chikwa tendahala mukati kaMajuda bakeñisa chayo manzwi. ");
INSERT INTO sbs_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bungi bwabo chiba wamba, “Wina i dimona mi umbulumuka. Chinzi hamutekeleza kwali? ");
INSERT INTO sbs_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Bamwi chibati, “Aa kahena manzwi amuntu yoyendiswa idimona. Kana idimona liwola kwiyalula menso amuntu yasaboni?” ");
INSERT INTO sbs_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Linu chibali inako ya Mukiti wa Kunjoloza mwa Jerusalema. ");
INSERT INTO sbs_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ibali maliha, mi Jesu abu kuyenda mwi keleke mumalibela a Solomoni. ");
INSERT INTO sbs_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Linu Majuda chiba muzimbuluka mi chiba wamba kwali, katuhinde inako ikumahi nitu sezibi? Heba njiwe Kirisite, tuwambile he ñandaleza.” ");
INSERT INTO sbs_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesu ababetabi kuti, “Nibamiwambili, kono kamuzumini. Mitendo initenda mwizina lya Tayo, yeyo njiipaka ziniama. ");
INSERT INTO sbs_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nikwinabulyo inwe ka muzumini mukuti kahena mwimbelele zangu. ");
INSERT INTO sbs_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Imbelele zangu zizuwa inzwi lyangu; nizizi, imi zinichilila. ");
INSERT INTO sbs_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Niziha buhalo busamani; kesinizifwe, imi kakwina niumwina yetinazi nzwabule mumayaza angu. ");
INSERT INTO sbs_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tayo, yabazinihi, mukando kuzamba bonse, mi kakwina yowola kubazwabula mumayaza a Tayo. ");
INSERT INTO sbs_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ime ni Tayo tuchintu chonke.” ");
INSERT INTO sbs_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Linu Majuda chi bahinda mavwe nibamu ñabola. ");
INSERT INTO sbs_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesu ababetabi, “Nibamitondezi mitendo mingi milotu izwa kwa Tayo. Linu njo uhi kweyo mitendo umuniñabolela cha mabwe?” ");
INSERT INTO sbs_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Majuda babamwitabi, “Katuku ñaboleli mutendo mulotu, kono kushwaula, mukuti iwe, umuntu, uli tenda kuti njowe Ireeza.” ");
INSERT INTO sbs_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesu ababetabi, “Kanakuti kuñoletwe mumilao, Ni wamba, “mumizimu”? ");
INSERT INTO sbs_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Heba ababa supi kuti bazimu, nji kwani kulibazwi izina lya Ireeza (mi mañolo ka awoli ku lutwa), ");
INSERT INTO sbs_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","muwamba konzo yaba bikiwakumbali nji Tayo ni kutumiwa muchisi, 'ushwaula; mukuti na wamba, 'Ni mwana we Ireeza.' ");
INSERT INTO sbs_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Heba kanitendi mitendo ya Tayo, kanzi muni zumini. ");
INSERT INTO sbs_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kono heba niitenda, nangakuti kazumini, muzumine mitendo linukuti mwizimbe ni kuzuwisisa ziba Tayo benamwangu imi name ninamuba Tayo.” ");
INSERT INTO sbs_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Babaliki kumuwonda hape, kono abayindi kungi kuzwa mumayanza abo. ");
INSERT INTO sbs_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Chayenda hape mwishila lya Jorodani kuchibaka unko Joani abali kukolobeza, niku kekala kwateni. ");
INSERT INTO sbs_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bungi bwabantu chibeza kwali nikuchokuti, “Cheniti Joani kana abatendi imakazo, kono zintu zonse zaba wambi Joani chozu mukwame ibali zeniti.” ");
INSERT INTO sbs_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Bantu bangi kwateni ni chibazumina kwali. ");
INSERT INTO sbs_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Linu mukwame zumwi yabali kusumpwa chezina lya Lazaro yabali kulwala. yaba kuzwa mwa Betenia, mumunzi mwabali kwikala Maria ni mukulwe Mareta. ");
INSERT INTO sbs_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","nji Maria yaba singi Simwine mafuta esende ni kumupemula kumatende ninsuki zakwe, imi Lazaro yabali kulwala ibala nchizyakwe. ");
INSERT INTO sbs_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Linu banchizyakwe nichibatumina iñusa kwa Jesu, nibacho, “Simwine, bone, iye yosaka ahulu ulwala.” ");
INSERT INTO sbs_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Linu Jesu hazuwa bulyo, nati, Uku kulwala kahena kufwa, kono bwakubonisa maata a Simwine chobulyo nimwana wa Ireeza uswanela kulumbekwa kachibatendahali.” ");
INSERT INTO sbs_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Linu Jesu abali kusaka ahulu Mareta ni mwanchakwe ni Lazaro bulyo. ");
INSERT INTO sbs_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Chobulyo hazuwa kulwala kwa Lazaro, Jesu abekali mazuba amwi obele muchibaka mwabekele. ");
INSERT INTO sbs_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Linu hakumana bulyo, Chowamba kuba rutwana bakwe, “Twende tuye kwa Judea hape.” ");
INSERT INTO sbs_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Barutwana chibawamba kwali, “Muruti, munako inu Majuda basaka kukugobola nimabwe, linu iwe usaka kubola kwateni hape?” ");
INSERT INTO sbs_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesu nichati, kahena kuti inhola zitenda ikumi ni obele eseli mwizuba? Linu zumwi muntu hayenda musihali, keti aholofale kapa kusitatala kakuti ubwene mwahitite cha liseli lyefasi. ");
INSERT INTO sbs_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nihakuba bulyo, hayenda masiku, mwasitatale kakuli iseli kalina mwali.” ");
INSERT INTO sbs_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nichawamba izi zintu, linu hamana izo zintu, nichabawambila, “Mulikanetu Lazaro chalala, kono nikaya ili kuti nikamubuse.” ");
INSERT INTO sbs_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Barutwana linu chibawamba kwali, “Simwine, haiba ulele, mwabe nenza.” ");
INSERT INTO sbs_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Linu Jesu chabataluseza kuamana niifu, Chobulyo abo babali kuhupula kuti uwamba iñonzi zakulikatulusa. ");
INSERT INTO sbs_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Linu Jesu nichabataluseza, “Lazaru ufwile. ");
INSERT INTO sbs_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nisangite, kebaka lyenu, kuti kana nibena kwateni kokuti nimubazumini. Twende kwali.” ");
INSERT INTO sbs_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomasi yaba kunsumpwa Didima, chawamba ku Barutwana, “Tuyende naswe tukafwe ni Jesu.” ");
INSERT INTO sbs_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Linu Jesu hakeza, neza kuwana kuti Lazaro chowina kale mwikumbu chamazuba onee. ");
INSERT INTO sbs_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Linu Betania ibena hembali ni Jerusalema, kazibima zotatwe. ");
INSERT INTO sbs_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Bungi bwa Majuda babali kwiza kwa Mareta ni Maria, kubaombaomba kuamana ni nchinzabo. ");
INSERT INTO sbs_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Linu Mareta, hazuwa kuti Jesu ukezite, nichibaka mukatanyeza, cobulyo Maria abekele munzubo. ");
INSERT INTO sbs_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mareta linu chawambila Jesu, “Nfumwangu, kapa kobena kunu, nchizyangu nasena bafwi. ");
INSERT INTO sbs_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nangati hanu, nizi kuti chimwi nichimwi chokumbila kwa Ireeza, mwakuhe.” ");
INSERT INTO sbs_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesu chawamba kwali, “Nchizyako mwabuke hape.” ");
INSERT INTO sbs_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mareta chawamba kwali, “Nizi kuti mwabuke hape he henzuho luzuba lwamamani mani.” ");
INSERT INTO sbs_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesu chawamba kwali, “Njeme ni nzuho ni buhalo; yense yozumina kwangu, niha fwa, mwa hale; ");
INSERT INTO sbs_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","chobulyo yense yohala ni kuzumina kwangu keti nafwe. Na muzumina iyi ndaba?” ");
INSERT INTO sbs_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Nichawamba kwali, “Ee, Nfumwangu, nizumina kuti njewe Kreste, mwana we Ireeza, yokezite mwi nkanda.” ");
INSERT INTO sbs_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Hamana kuwamba izi, chozwa mwateni nikusumpa mwanchakwe Maria kakuli ungula. chamuwambila, “Muruti chasika mi ukusumpa.” ");
INSERT INTO sbs_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Linu hazuwa bulyo, chonyamuka kapili nikuya kwali. ");
INSERT INTO sbs_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Linu Jesu kanabeni kusika mumunzi abali kusina kuchibaka kwaba kamukatanyezi Mareta. ");
INSERT INTO sbs_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Imi Majuda, babena naye mwinzubo babali kumuomba omba nibabona Maria hanyamuka kapili pili kuzwila hanze, chiba mwichilila, kuhupula kuti chokaya kwikumbu aka siliseze kwateni. ");
INSERT INTO sbs_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Linu Maria, hakeza kwabekele Jesu imi namubona, chowila hamatende akwe ni kumuwambila, “Simwine, kapa kobena kunu, nchinzyangu nasena abafwi,” ");
INSERT INTO sbs_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Linu Jesu chamubona nasilisa, imi ni Mujuda wakeza naye chokwete usilisa, ");
INSERT INTO sbs_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","chabahinditwe muluhuho lwakwe mi abali kubilela; chawamba, “Mubamulaziki kuhi?” Niba mwitaba, “Nfumwangu, wize zo bone.” ");
INSERT INTO sbs_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesu nasilisa. ");
INSERT INTO sbs_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Linu Majuda cibawamba, Mubone mwaba kusakila Lazaru!” ");
INSERT INTO sbs_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Imi bamwi chibawamba, “Kanjiyena uzu mukwame, yabeyaluli menso amukwame wamuhofu, hape ibaleti kuti uzu mukwame kuti afwe?” ");
INSERT INTO sbs_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Linu Jesu hape, nalizuwa kutomoha inkulo hape, nayenda kwikumbu. linu chibali ilindi, imi ibwe libatulitwe hateni. ");
INSERT INTO sbs_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesu nati, “Muzwise hateni ibwe.” Mareta, nchinzye wa Lazaro, iye yofwile, nawambila Jesu, “Nfumwangu, cheinu inako chitupu chichinunka, kakuti chikwahinda mazuba onee kuzwa habafwili.” ");
INSERT INTO sbs_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Linu Jesu nati kwali, Naa kana nibakuwambili kuti, heba uzumina, mokabone mubuso wa Ireeza?” ");
INSERT INTO sbs_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Linu chibazwisa ibwe hekumbu. Jesu nakatula menso akwe kulola kwiulu imi nati, “Tate, Nilitumela kakuti wateka kwangu. ");
INSERT INTO sbs_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nizi kuti utekanga kwangu inako yonse, kono niwamba bulyo kebaka lyekunga linizimbulukite kunibika mukati, ili kuti bazumine kuti ubanitumi.” ");
INSERT INTO sbs_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Chobulyo nawamba buti, nahuweleza chalizwi lizuweka ahulu, “Lazaro, wize hanze!” ");
INSERT INTO sbs_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mukwame yabafwile nazwa mwikumbu; matende akwe nimayanza abali kuzingeletwe masila. Jesu nawamba kubali, “Mumusumunune imi mumusiye ayende.” ");
INSERT INTO sbs_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Linu bungi bwa Majuda babakezi kwa Maria imi nibabona zabatendi Jesu, niba zumina kwali, ");
INSERT INTO sbs_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","kono bamwi mukati kabo chibayenda ku Bafalisi imi chibakawamba zabatendi Jesu. ");
INSERT INTO sbs_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Cwale mapurita bakulwana ni Bafalisi chibakopanya inkuta hamwina imi nibawamba, “Mutupange chihi? Uzu mukwame upanga imakazo zingi. ");
INSERT INTO sbs_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","heba mutumusiye yenke sina buti, bonse mubazumine kwali; Maroma mubatunyange minzi yetu yonse ni nkanda yetu.” ");
INSERT INTO sbs_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nihakuba bulyo, zumwi mukwame mukati kabo, Kayafa, yabali muprisita mukulwana mwecho chilimo, nati kubali, “Kakwina chimwizi. ");
INSERT INTO sbs_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Kamubwene kuti kulotu nibutuka kuti mukwame yenke afwile chichaba kundeye kuti inkanda yonse imaniswe.” ");
INSERT INTO sbs_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Lyahanu izi zawamba kazizwi kwali mwine. kono, kakuti abali muprisita mukulwana icho chilimo, aba polofiti kuti Jesu mwafwile inkanda; ");
INSERT INTO sbs_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","kono isini inkanda bulyo imi kono kuti bana ba Ireeza bahasene bekale hamwina kalusika lonke. ");
INSERT INTO sbs_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Linu kuzwa ulo luzuba niba zuminzana mwete behaile Jesu. ");
INSERT INTO sbs_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kelyo ibaka Jesu nasiya kuyenda mukati ka Majuda nibamubwene, imi chozwa mweyo inkanda nikuya mwihalaupa mumuleneñi wa Efraimi. Uko abakekali ni barutwana. ");
INSERT INTO sbs_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Lyahanu i Paseka ya Majuda chibena hafuhi, imi bungi bwabo nibaya mwa Jerusalema kuzwa mwinkanda i Paseka niseni kusika kuti bakalijoloze abo bene. ");
INSERT INTO sbs_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Babali kukabulola Jesu, imi nibena mwi Tempele nibakwete balibuza buza, “Muhupula bule? Na sanzi akezi kumukiti?” ");
INSERT INTO sbs_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Linu muprisita mukulwana ni Bafalisi niba hewa mulao kuti haiba kwina yowizi kwena Jesu, uswanela kuwamba ili kuti bamukwate. ");
INSERT INTO sbs_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Mazuba amana iyanza ni limwina habusu bwa Mukiti we Paseka, Jesu abezi kwa Betania, kwabali kuhala Lazaro, yababuswa kwali kubafwile. ");
INSERT INTO sbs_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Chobulyo nibamutendela mulalilo kwateni, mi Mareta njabali kuha zilyo, kono Lazaro ibali njizumwi yabena nabana babena ni Jesu hetafula. ");
INSERT INTO sbs_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Linu Maria nichahinda ilita yebotela yamafuta adula anuka nenza, ni kuetila hamatende a Jesu, ni kuasinda ni suki zakwe. Inzubo niyezula mununko mulotulotu wamafuta anunka nenza. ");
INSERT INTO sbs_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Judasi Isikariota, zumwi wabarutwana bakwe, yeti namubeteke, nati, ");
INSERT INTO sbs_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Chinzi aa mafuta hasana abawuzwa madola achita myanda yotatwe ni kuha kubahumanehi? ");
INSERT INTO sbs_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Abali kuwamba bulyo, isiñi kuti abali kufwila bahumanehi inse, nata, kono ibaka lakuti ibali musa: njabakweta chikwama chamasheleñi mi abalikwiba chibabikwa mwateni. ");
INSERT INTO sbs_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesu abati, “Mumuzuminine kuti abikile chakwete izuba lyangu lyekepelo. ");
INSERT INTO sbs_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Kamubakubile ni bahumanehi inako yonse, kono ime keti nimubekubile name inako yonse”. ");
INSERT INTO sbs_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Mweyonako ikunga ikando la Majuda nilyeziba kuti Jesu kwabena, mi babezi, isiñi kukezila Jesu bulyo, kono ni kwiza kubona Lazaro bulyo, ili yababusi Jesu kubafwile. ");
INSERT INTO sbs_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Baprisita bakulwana ni chibazumizana hamwina chamulelo wakwihaya Lazaro naye; ");
INSERT INTO sbs_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","mukuti ibali chebaka lyakwe Majuda hababazwi chabungi ni kukazumina kwa Jesu. ");
INSERT INTO sbs_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Halizwa ikunga ikando nilyakeza ku Mukiti we Paseka. Linu habazuwa kuti Jesu ukezite kwa Jerusalema, ");
INSERT INTO sbs_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","nibahinda mitavi yenzalu ni kuyenda kukamukatanyeza, ni kuhuweleza, “Hosanna! Yotohonolofezwe kwa Ireeza njozuna yokeza mwizina la Simwine, Simwine Mukulwana wa Isilaele.” ");
INSERT INTO sbs_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesu abawani mwana wedonki mi natanta haili; sina mukubañolezwi, ");
INSERT INTO sbs_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Musiyemutiyi, inwe mubantu ba Zion, Simwine wenu Mukulwana ukezite, natantite hamwana wedonki.” ");
INSERT INTO sbs_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Barutwana bakwe kanababazuwisi izi zintu kumatangilo; kono inako yahewa mata akubuka kubafu, nibahupula kuti izi zintu zibañoleltwe chebaka lyakwe ni kuti babatendi izi zintu kwali. ");
INSERT INTO sbs_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lyahanu ikunga libena naye inako yasupa Lazaro kuzwa mwikumbu imi abamubusi kuzwa kubafwile, ibabi bupaki. ");
INSERT INTO sbs_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ibali chelyo ibaka ikunga liba zwili kwateni kukamukatanyeza mukuti babazuwi kuti njiye yabatendi iyi makazo. ");
INSERT INTO sbs_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Chobulyo Bafalisi ni chibawambinsena mukati kabo, “Hamubone, kakwina chimuwola kutenda, mubwene, chisi chose chimwichilile.” ");
INSERT INTO sbs_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Magerike bamwi mweyonako babena mukati kwabana babali kuya kukulapela munako yamukiti. ");
INSERT INTO sbs_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Aba bantu babayi kwa Filipi, yabali kuzwa kwa Betsaida mwa Galilea, babamubuzi, nibati, “Fumwetu, tusaka kubona Jesu.” ");
INSERT INTO sbs_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipi abayendi kukawambila Andreasi; Andreasi abayendi ni Filipi, mi nibakawambila Jesu. ");
INSERT INTO sbs_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesu nabetaba nati, “Ihola chiyasika yakuti Mwana Muntu abe hamazimo makando akububekwa. ");
INSERT INTO sbs_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ikumbya lineline, nimiwambila, uluhaiba luheke lwamundale ni luwila mwibu ni kufwa, kalushale lolona mbona bobulyo; kono haiba nilufwa, kalubike zichelantu zingi. ");
INSERT INTO sbs_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Iye mwine yosuni buhalo bwakwe mwabuluze; kono iye mwine yohinda buhalo bwabamwi batu kuti bwabutokwa kuhita buhalo bwakwe iye mwine kahale ni Ireeza kuyakuile. ");
INSERT INTO sbs_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Haiba muntu unisebeleza, mumusiye anichilile; henikele kwiwulu, ni muhikana wangu kabe kwateni naye. Haiba muntu unisebeleza, Tayo mwamuhe itompo. ");
INSERT INTO sbs_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Lyahanu luhuho lwangu lukatazehete: Ketinilapele? 'Tayo, unihune mweyinu ihola'? “Kono njilona ibaka ili, hanibezi kuti zenitakisiwe. ");
INSERT INTO sbs_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tayo, utumise kububana kwako.” Linu linzwi ni lyazwa kwiwulu mi nilyati, “Nibalitumisi kale, mi kanilitumise hape.” ");
INSERT INTO sbs_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Linu ikunga libazimene habumbali ni kulizuwa ni lyati kuti invula yapalakata. Bamwi nibati, “Ingeloi libali kuwambi kwali.” ");
INSERT INTO sbs_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesu abetabi nati, “Ili linzwi kanalibezi kwangu, kono kwenu. ");
INSERT INTO sbs_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Hanu chilinako yakuti chinu chisi chiatulwe: Hanu chili inako yakuti ninisinyesinye mata a Satani yobusa chihanu chinsi. ");
INSERT INTO sbs_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Imi Ime, heti bantu kabaninyamwine mwiwulu hachifapano, kanikwitile zumwi ni zumwi kwangu.” ");
INSERT INTO sbs_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Abawambi bulyo kutondeza kuti mufutazi wefu lyeti nafwe. ");
INSERT INTO sbs_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ikunga libamwitabi, “Tubazuwi kuzwa kumulao kuti Jesu kekalile kuyakwile. Kwiza buti kuti uwambe, 'Mwana Muntu utameha kuhazikwa hachifapano'? Njeni uzu Mwana Muntu yowamba zakwe?” ");
INSERT INTO sbs_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesu linu chati kubali, “Iseli kalibe kubile nanwe chenakozana ifwihi. Muyende hamuchina iseli, kokuti ififi sanzilimihitilili. Iye yoyenda mulififi kaboni kwakaya. ");
INSERT INTO sbs_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Inako yimwina name, muzumine kumanzwi angu initi ya Ireeza kayibe nanwe.” Jesu abawambi izi zintu mi kuzwahateni naliyendela ni kukaliwungula kuzwa kubali. ");
INSERT INTO sbs_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nihakuba kuti Jesu abatendi imakazo zingizingi habusu bwabo, nihakubabulyo kanababazumini kwali. ");
INSERT INTO sbs_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Kokuti inzwi lamutanikizi Isaya lizuzilizwe, ili umo abati: “Simwine, njeni yabazumini kwiñusa lyetu? Mi iyanza lya Simwine libeziwahaza kwani? ");
INSERT INTO sbs_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Cheli ibaka kanababali kuwola kuzumina, mukuti Isaya naye abati, ");
INSERT INTO sbs_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Abatendi menso abo kuba buhofu, ni kuzumiza inkulo zabo; chenzila yimwi nibabawoli kubona ni menso abo ni kuzuwisisa ni nkulo zabo, ni kusanduka, imi ninibabahozi” ");
INSERT INTO sbs_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya abawambi izi zintu mukuti ababoni ikanya ya Jesu imi abawambi kazakwe. ");
INSERT INTO sbs_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kono nihakwinabulyo, bungi bwababusi babazumini kwa Jesu; kono chebabakala Bafalisi, kanababali kuzumina kweyo indaba kokuti sanzibakanisi kunjila mwisinagoge. ");
INSERT INTO sbs_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Babalikusaka kutembwa kubantu kuhita kutembwa kuzwa kwa Ireeza. ");
INSERT INTO sbs_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesu nahuweleza nati: “Yozumina kwangu, kazumini bulyo kwangu kono uzumina bulyo ni kwali zonitumite, ");
INSERT INTO sbs_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","imi uzoyonibwene ubwene bulyo ni yonitumite. ");
INSERT INTO sbs_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nibezi kuchisi ninili niseli kukuti yense yozumina kwangu sanzi nashali mulififi. ");
INSERT INTO sbs_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Haiba muntu zuhi no zuhi uzuwa manzwi angu kono kaabiki, kanimuatuli; mukuti kananibezili kuatula chisi, kono kwiza kuhaza chisi. ");
INSERT INTO sbs_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Iye yonikana ni yasazumini manzwi angu wina yomuatula: kaibe nji inzwi linibawambi letinilimuatule izuba lamamanimani. ");
INSERT INTO sbs_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mukuti kananibawambi kazangu, kono njiza Tayo yabanitumi, yabanihi itaelo kuamana ni chiniswanela kuwamba ni chiniswanela kuluta. ");
INSERT INTO sbs_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nizi kuti itaelo yakwe ileta buhalo busena mamaninizo, chobulyo checho chiniwamba - bobulyo fela sina Tayo mwabawambili kwangu, bobulyo name muniwambila.” ");
INSERT INTO sbs_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Lyahanu pili Mukiti we Paseka niuseni kuliwa Jesu chabezi kuti inakoyakwe chiyasika yakuzwa hanuhansi ni kuya kwa Tayo - sina habakusuni bakwe bamuchisi - ababasaki kutwala kumamanisinzo. ");
INSERT INTO sbs_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Lyahanu satani chababiketi kale mwinkulo ya Judasi Iskariota mwana a Simon, kuti abeteke Jesu. ");
INSERT INTO sbs_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Chabakwi kuti Tayo chabahele kale zintu zonso mumayanza akwe imi chabakazwile kwe Ireeza ni chabakubola kwe Ireeza. ");
INSERT INTO sbs_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Abazimani hamulalilo ni kuzwisa chizwanto chakwe chahewulu. Linu chahinda kataulo ni kukalisumina iye mwine. ");
INSERT INTO sbs_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Linu chachunka mezi mukasuba ni kutanga kusaza matenda abarutwana bakwe ni kubapemula ni taulo yabalizingelete. ");
INSERT INTO sbs_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Chakeza kwa Simoni Pitirosi, imi Pitorosi chawamba kwali, “Simwine, mosaze matende angu na?” ");
INSERT INTO sbs_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesu chetaba ni chati kwali, “Chinitenda kwanko kese uchizuwisise hanu, kono kokachizuwisise mwinako inza.” ");
INSERT INTO sbs_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pitorosi chawamba kwali, “Kense usanze matende angu.” Jesu chamwitaba, “Heba kanikusazi, kawina chemba kwangu.” ");
INSERT INTO sbs_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoni Pitirosi chawamba kwali, “Simwine, kanzi unisazi bulyo kumatende, kono nikumayanza angu ni mutwi wangu.” ");
INSERT INTO sbs_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesu chawamba kwali, “Uzo yosazwa kena chasaka, hensi kusazwa kumatende, kono ujolwele neza; ujololwe, kono isini umwi ni umwi.” ");
INSERT INTO sbs_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Mukuti Jesu abezi yese namubeteke; chinji abawambi, “Kahena kutimubonse mujolola.)” ");
INSERT INTO sbs_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Linu Jesu hamana kubasaza matende abo ni kuhinda zizwato zakwe ni kwikala hansi hape, chawamba kubali, “Kana mwizi chinatenda kwenu? ");
INSERT INTO sbs_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Munisupa 'Muluti' ni 'Simwine,' imi uwamba chishiyeme, kakuti linu njime. ");
INSERT INTO sbs_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Heba njime linu, Simwine ni Muluti, nashanza matende enu, nemwe mulishanze matende enu zumwi ni zumwi. ");
INSERT INTO sbs_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mukuti chinamiha mutala kokuti nenwe mutende bobulyo munamitendela. ");
INSERT INTO sbs_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ikumbya line, niwamba kwenu, mubeleki kena mukando kwafumwe; kapa mutumiwa kubamukando kuwamutuma. ");
INSERT INTO sbs_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Heba nimwiziba izizintu, mufuyoletwe heba nimuzitenda. ");
INSERT INTO sbs_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Kaniwambi mubonse; niziabo banibaketi — kono iñolo linani kwizuzilizwa; 'Iye ulya chikwa changu unilaha mulezele.' ");
INSERT INTO sbs_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nimiwambila inzohahanu pili niziseni kutendahala, linukuti hazitendahala, nimuzumine kuti Njime. ");
INSERT INTO sbs_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ikumbya line, nimiwambila, yotambula yese unatuma, watambulame, imi yotambula ime, utambula iye yabanitumi.” ");
INSERT INTO sbs_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Linu Jesu hawamba inzo, chabakatazehete muluhuho, chaha bupaki mi chati, “Ikumbya line, niwamba kwenu kuti zumwi kwenu kanibeteke.” ");
INSERT INTO sbs_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Barutwana chibalilola, nibabilelete kuti uwambani. ");
INSERT INTO sbs_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Zumwi wabarutwana, wabakusaka hahulu Jesu, abakushendeme hetafule nazendamine hachizuba cha Jesu. ");
INSERT INTO sbs_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simoni Pitorosi chalolela konzo murutwana ni kuwamba, “Tuwambile njeni unzo yowamba zakwe.” ");
INSERT INTO sbs_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Linu chazendamina hachizuba cha Jesu ni kuwamba kwali, “Simwine, njeni unzo?” ");
INSERT INTO sbs_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Linu Jesu chamwitaba, “Njiyena yesenihe chikwa chinansunsa.” Chobulyo hamana kunsunsa chikwa, chachiha Judasi mwana Simon Iskariota. ");
INSERT INTO sbs_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Imi linu, hakumana chikwa, Satani chamwinjila, linu Jesu chawamba kwali, “Chosakaku tenda, uchitende kakuhwela.” ");
INSERT INTO sbs_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Kakwina nanga umwina kubabalikwikele naye hetafule yabezi kuti chizi hawamba inzo kwali. ");
INSERT INTO sbs_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Bamwi chiba hupula kuti, mukuti Judasi ibali iye yabakubika masheleni, chingi Jesu abawambi kwali, “Ukawule zisakahala kuti tube nanzo hamukiti,” kapa uwola kukaha zimwi kubanjebwe. ");
INSERT INTO sbs_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judasi hamana kutambula chikwa, chazwila hanze hahobulyo. Chi ibali masiku. ");
INSERT INTO sbs_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Inako Judasi hayenda hanze, Jesu chati, “Hanu Mwana wa Muntu cholumbekwa, imi Ireeza kalumbekwe chebakalyakwe. ");
INSERT INTO sbs_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ireeza kamulumbeke iye kalwake mwine, imi kamulumbeke hahanubulyo. ");
INSERT INTO sbs_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Bahwile banini, nichina nanwe mukuti kuchina kanakozana bulyo. Kamuningane, imi sinamuni bawambili majuda, 'Kuniya kamuwoli kwizako.' Nahanu nichi wamba inzi kwenu hape. ");
INSERT INTO sbs_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nimiha mulao muhya, kuti musake umwi ni umwi; sina munibakumisakila, linu musake umwi ni umwi hape. ");
INSERT INTO sbs_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Chenzi umwi ni umwi kezibe kuti mubarutwana bangu, heba ni mulisuni zumwi ku zumwi. ");
INSERT INTO sbs_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoni Pitorosi chawamba kwali, “Simwine, ukaya kuhi?” Jesu abamwitaba, “Kuniya, kowoli kunichilila hanu, kono konichilele inako yiza.” ");
INSERT INTO sbs_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pitorosi chati kwali, “Simwine, chinzi hanisawoli kukwichilila? Kanilifungule buhalo bwangu bakeñi chanko.” ");
INSERT INTO sbs_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesu chetaba, “Uwola kulifungula buhalo bwanko ibaka lyangu? Ikumbya line, Nikuwambila, munkombwe niuseni kulila kobe chonisampwile totatwe.” ");
INSERT INTO sbs_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Sanzi musilili inkulo zenu kuti zisitatale. kono muzumine kwe Ireeza, ");
INSERT INTO sbs_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","muzumine hape ni kwangu. Munzubo iba Tayo mwina misiyo mingi. kamba kanjobulyo, ninisena namiwambila iyo indaba, chobulyo nikaya nikamilukiseze chibaka. ");
INSERT INTO sbs_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","imi haniyenda kukumilukiseza chibaka, munikabole hape imi zanimihinde chobulyo kunikena nanwe mukabe kwateni. ");
INSERT INTO sbs_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Wizi inzila yoko kunikaya.” ");
INSERT INTO sbs_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasi chati kwa Jesu, “Simwine, katwizi kokaya, mutwizibe bule inzila?” ");
INSERT INTO sbs_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesu namuwambila, “Njeme ni nzila, initi ni buhalo; kakwina yowiza kwaTayo konji kangu. ");
INSERT INTO sbs_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kapa munizi, nimwizi ni Tayo naye. kuzwa hanu chimwa mwiziba imi chimwa mubona ");
INSERT INTO sbs_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipi chati kwa Jesu, “Simwine, tutondeze Tayo, imi mukushiyame kwetu.” ");
INSERT INTO sbs_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesu nichawamba kwali, “Nibabi nanwe inako inde imi kanti nawe konizi, Filipi? Yense wabona ime wabona Tayo. Chinzi howamba, Kuti ni kutondeze Tayo'? ");
INSERT INTO sbs_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Na kamuzumini kuti ime nikele kwa Tayo imi Tayo wina kwangu? Manzwi animiwambila kanzwi kwangu kono a zwila kwa Tayo yohala kwangu yopanga musebezi wakwe. ");
INSERT INTO sbs_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Munizumine kuti njeme Tayo, imi Tayo wina kwangu, kakuba bulyo muzumine kebaka lya misebezi ine. ");
INSERT INTO sbs_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Inkyumba line, nimiwambila, yense yozumina kwangu mwapange misebezi ini panga, imi mwapange misebezi mikando ihita iyi kakuti ime nikaya kwa Tayo. ");
INSERT INTO sbs_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","chonse cheti mukumbile mwizina lyangu, kanichipange ili kuti tayo alumbekwe cha Mwana wa muntu. ");
INSERT INTO sbs_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Haiba munikumbila chimwi ni chimwi mwizina lyangu, Munichipange. ");
INSERT INTO sbs_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Haiba munisaka, mumu mamele milao yangu. ");
INSERT INTO sbs_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Imi kani lapele kwa Tayo, imi mwamihe zumwi Mutusi ili kuti zabe nanwe inako zonse: ");
INSERT INTO sbs_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Luhuho lweniti. Ulo lusawoli kutambulwa inkanda yonse kakuti kalumuboni kapa kumwiziba. Kono inwe mumwizi, imi wikele nanwe imi mwabe nanwe. ");
INSERT INTO sbs_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Keti nimisiye mwenge; munikabole kwenu. ");
INSERT INTO sbs_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kusishalile inako zana imi inkanda keti munibone hape, kono kamunibone. kakuti nihala, nanwe kamuhale. ");
INSERT INTO sbs_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Cholo luzuba kamwizibe kuti nina kwa Tayo, imi nanwe mwina kwangu, imi name nina kwenu. ");
INSERT INTO sbs_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Umwi ni umwi yokwete milao yangu nikuimamela njiyena yonisaka, imi iye yonisaka mwasakiwe nikwa Tayo, imi name kanimusake imi kanilitondeze kwali.” ");
INSERT INTO sbs_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judasi (insini Isikariota) chawambila Jesu, “Simwine, chinzi hosaka kulibonahaza kwetu isini kwi nkanda?” ");
INSERT INTO sbs_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesu chetaba nikumuwambila, heba kwina yonisaka, mwechilile linzwi lyangu. Imi Tayo kamusake, imi katwize kwali imi katuzake munzi wetu naye. ");
INSERT INTO sbs_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Iye yasanisaki keti echilile manzwi angu. Inyo linzwi limuzuwa kahena kuti lizwila kwangu kono lizwila kwa Tayo yonitumite. ");
INSERT INTO sbs_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nibamiwambili kuti, hanu hanisikele nanwe. ");
INSERT INTO sbs_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nihakuba bulyo, Muombaombi- Luhuho Lujolola yesa katume Tayo mwizina lyangu- iye mwamilute zintu zonse imi mwamihupulise nizonse zini bamiwambili. ");
INSERT INTO sbs_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nimisiya che nkozo; Nimiha inkozo yangu. Kanimihi sina mubaihela bena munkanda. Sanzi musilili inkulo zenu kuti zisitatale, hape sanzi mutiyi. ");
INSERT INTO sbs_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mwanizuwa kuti hanawamba kwenu, 'Chinikaya imi munikabole kwenu.' haiba munisaka, ni mwasanga kuzuwa kuti nikaya kwa Tayo, mukuti Tayo mukando kunihita. ");
INSERT INTO sbs_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Linu nimiwambila nichiseni kupangahala ili kuti, hete nichipangahale kamuzumine. ");
INSERT INTO sbs_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","keti niniwambe ahulu nanwe, mukuti mutendisi wenkanda ukezite. Iye kena maata heulu lyangu, ");
INSERT INTO sbs_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","chobulyo benkanda baswanela kwiziba kuti ime nisaka Tayo, Imi nipanga sina nji Tayo mwa ni balaelezi. Tuzimane tusiye ichi chibaka.” ");
INSERT INTO sbs_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Njeme ni isamu lye niti lye veine, mi Itayo nji mu va valeli. ");
INSERT INTO sbs_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","U zwisa mutavi onse mwangu usahi chihantu, mi u kosola mutavi onse usahi chihantu kuti uhe chihantu cho vungi. ");
INSERT INTO sbs_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mujolola ivaka lya iñusa li ni va wambi kwenu. ");
INSERT INTO sbs_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mushale mwangu, mi Name mwenu. Sina mutavi ha wusawoli kuha chihantu cha wo wine konji chi ha wushala mwisamu lye veine, mane nanga inwe, kwanda kuti mushale mwangu. ");
INSERT INTO sbs_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Njime ni samu lye veine, inwe mu mitavi. Iye yo shala mwangu mi Name mwali, uha chihantu chingi, kakuti mukuti kusena Ime ka kwina chi muwola kutenda. ");
INSERT INTO sbs_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Haiva zumwi kashali mwangu usohelwa kuna ni kuzuma, mi va kunganya mitavi ni ku isohela mu mulilo, ni ku hiswa. ");
INSERT INTO sbs_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Haiva mushala mwangu, mi haiva ni manzwi angu a shala mwenu, mu kumbile zonse zi mu litakaleza, mi ka muzi tendelwe. ");
INSERT INTO sbs_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mi Itayo ka tembwe mwezi: kuti muhe chihantu chingi mu valutwani vangu. ");
INSERT INTO sbs_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mi sina Itayo ha vani suni, Name mu ni va misuni, mushale mwi ilato lyangu. ");
INSERT INTO sbs_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Haiva mu vika intaelo zangu, ka mushale mwi ilato lyangu mi sina ha ni va viki intaelo za Itayo mi ni kushala mwi ilato lyakwe. ");
INSERT INTO sbs_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Na wamba izi zintu kwenu kuti ku sanga kwangu ku ve nanwe, ili kuti ku sangu kwenu kwi zu zilizwa. ");
INSERT INTO sbs_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Iyi nji intaelo yangu, mu lisune sina ha ni va mi suni. ");
INSERT INTO sbs_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ka kwina wina ilato ikando li likana neli, kuti uha vuhalo bwa kwe ku valikani vakwe. ");
INSERT INTO sbs_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Mu valikani vangu haiva muvika zintu zi ni va milaeli. ");
INSERT INTO sbs_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ka ni si misumpi vahikana, mukuti vahikana kavezi izo simwine wavo za tenda. Na misupi valikani, mi zonse zi ni vazuwi kwa Itayo, ni va zi zivahazi kwenu. ");
INSERT INTO sbs_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kana mu va ni keti, kono ni va miketi mi ni ku mita kuti mukahe chihantu, ili kuti chihantu chikale. Mu kuve vulyo kuti chonse chi mukumbila cha Itayo mwi zina lyangu, mwa chi mihe. ");
INSERT INTO sbs_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Izi zintu ni milaela: mu mulisune mu vonse. ");
INSERT INTO sbs_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Haiva inkanda imi toya, mwizive kuti ivani toyete ni iseni ku mitoya. ");
INSERT INTO sbs_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kamba mu ve inkanda, mi inkanda ni va misuni sina muvayo. Kono cho kuti ka hena mu ve inkanda mi chelyo ivaka ni va miketi kuzwa mwi inkanda, mi he inkanda i mi toyete ");
INSERT INTO sbs_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Muzeze linzwi li ni va mi wambi kwenu,' Muhikana ka hena mukando kwa simwine wake'. Haiva va va nyandisi ime, nanwe ka va mi nyandise; haiva va viki linzwi lyangu, navo vulyo ka vike lyenu. ");
INSERT INTO sbs_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ka va tende izi kwenu che ivaka lye zina lyangu kakuti ka vezi ya va ni tumi. ");
INSERT INTO sbs_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kamba ka na ni vezi ku wamba ku vali, ni vasana va va pangi chivi, kono hanu ka vena ivaka lya chivi chavo. ");
INSERT INTO sbs_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Iye yo ni toya uto yete vulyo ni Itayo. ");
INSERT INTO sbs_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kamba kana ni vapangi mitendo ni ku sena zumwi ya va itendi mukati kavo, ni vasena chivi, kono hanu va va voni ni ku nitoya tuvose Ime ni Itayo. ");
INSERT INTO sbs_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Kono ichi nji kwi zu zilikiza linzwi liñoletwe mu mulao, 'Va vani toyi ni ku sena chimwi.' ");
INSERT INTO sbs_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Linu Musengisengi- iye yese Ni tumine ku zwa kwa Itayo, iye njiye, Luhuho Lujolola lwa initi, lu zwilila kwa Itayo-kwiza, ka pake changu. ");
INSERT INTO sbs_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nanwe vulyo mupaka cha kuti muvena name ku zwa ku matangilo. ");
INSERT INTO sbs_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ni ba wambi izi zintu kwenu chokuti kanji muzwi kwangu. ");
INSERT INTO sbs_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ka ba mi sohe mu ma sinagoge. kono inako i kezite i yo zumwi ni zumwi yo mi haya kahupule kuti u ha mutendo wa chitabelo kwe Ireeza. ");
INSERT INTO sbs_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ka ba chite izo zintu chokuti kana ba bezibi Itayo kapa I me. ");
INSERT INTO sbs_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ni ba wambi izo zintu kwenu chokuti i nako ya bo ha i sika, ka muzeze kuti ni ba miwambili kuamana na bo. Kana ni ba miwambili kuamana nizo zintu kumatangilo chokuti ni bena nanwe. ");
INSERT INTO sbs_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Kono lyahanu ni kaya kwali ya ba ni tumi, nihaike kakwina kwenu ya ba ni buzi, “U kaya kuhi?' ");
INSERT INTO sbs_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kono chokuti ni bawambi izi zintu kwenu, kuswaba ku be zuli mwinkulo zenu. ");
INSERT INTO sbs_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kono ni miwambila buniti: mo kube hande kwenu ha ni ya kungi. Mukuti heba ne ni sa yendi kungi, Muombaombi kete ne ze kwenu, kono ha ni yenda, Ka ni mutumine kwenu. ");
INSERT INTO sbs_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ha te neeze, Muombaombi ka tondeze inkanda ku ba ni mafosisa kuamana ni chibi, kuamana ni kuluka, ni kuamana ni nkatulo- ");
INSERT INTO sbs_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","kuamana ni chibi, Chokuti ka ba zumini kwangu; ");
INSERT INTO sbs_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","kuamana ni kuluka chokuti ni ka ya kwe Itayo, mi inwe ke te ne muzwile habusu ku ni bona; ");
INSERT INTO sbs_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","mi kuamana ni nkatulo, chakuti mubusi we yunu inkanda cha ba atulwa kale. ");
INSERT INTO sbs_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ni na zintu zingi za kuwamba kwenwu, kono kete mu zi zuwisize hanu. ");
INSERT INTO sbs_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Kono cwale iye, Luhuho lwe Niti, ha lwiza, ka lu mi etelele mu buniti bonse, chokuti kete ne lu liwambile kuzwililia kwali mwine. Kono kawambe chonse chete na zuwe, mi ka wambe kwenu chete ne chize. ");
INSERT INTO sbs_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ka ni tembe, kakuli ka hinde ku zwilila ku zangu mi ka zi wambe kwenu. ");
INSERT INTO sbs_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Chimwi ni chimwi chena na cho Tayo nji changu. Ni hakwina bulyo, Ni bawambi kuti Luhuho ka luhinde ku zwilila ku che chili changu mi ka mi wambile. ");
INSERT INTO sbs_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Chakuya che nako i nfuhi kete ne mu ni bone, mi kwisule che nako i mwi i nfuhi ka mu ni bone.” ");
INSERT INTO sbs_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Kuzwaho bamwi ba balutwani ba kwe ni chi bati zumwi ku zumwi, “Chintunzi chi cha wamba kwetu, 'Che nako infuhi kete ne mu ni bone mi kwisule lye nako i mwi infuhi ka mu ni bone,' mi, 'Chokuti ni yenda kwe Itayo'?” ");
INSERT INTO sbs_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Nihakwina bulyo ni chi bati, “Kanti chintunzi chi chawamba, 'I nako zana i nfuhi'? Katwizi cha kwete kuamana ni cha wamba.” ");
INSERT INTO sbs_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesu ni cha bona kuti basaka ku mubuza, ni cha ti kubali, “I chi che mukwete kulibuza mukati kenu kuamana ni cha na wamba, 'I nako zana infuhi kete ne mu ni bone mi kwisule lye nako zana i mwi infuhi ka mu ni bone'? ");
INSERT INTO sbs_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Buniti, niti, ni wamba kwenu, ka mulile ni kusilisa, kono inkanda ka isange; kono nwe ka mu be ni ku wilwa kukando, kono ku swaba kwenu ka ku sanduke ku ba ni ntabo. ");
INSERT INTO sbs_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Heba mwanakazi u puluha u ba ni kuwilwa chokuti inako ya kwe chi ya sika, kono ha mana kupuluha muchiche, ka chi hupuli kuchiswa kwakwe chebaka lye ntabo chakuti muntu wa pepwa munkanda. ");
INSERT INTO sbs_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Chobulyo mwina kuwilwa hanu, kono ka ni mibone hape, mi nkulo zenu ka zisange, mi ka kwina ya te na wole kuzwisa intabo yinu kwenu. ");
INSERT INTO sbs_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Mwi zuba elyo ke te ne mu ni buze chimwi. Buniti, niti, ni wamba kwenu, haiba ne mukumbila chime kwa Tayo che zina lyangu, ka chi mihe. ");
INSERT INTO sbs_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kuhitila hanu ka mwini ku kumbila chimwi che zina lya ngu. Mukumbile, mi ka muamuhele chokuti kusanga kwenu ne ku izuzilizwe. ");
INSERT INTO sbs_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ni bawambi e zi zintu kwenu cha makabisa puo, kono inako i kezite ye se te ni ni wambe kwenu indaba zi sa zuweki, kono kusi bulyo ka ni miwambile ha jololwe kuamana ni Itayo. ");
INSERT INTO sbs_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Mwizuba lyo ka mukumbile che zina lyangu mi ka ni wambi chobulyo kwenu kuti ka ni lapele kwe Itayo chenu, ");
INSERT INTO sbs_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","chokuti Itayo i ye mwine a mi saka chokuti mu ba ni saki mi mu bazumini kuti ni ka zwilila kwe Itayo. ");
INSERT INTO sbs_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ni zwilila kwe Itayo, mi ni bakezi mwi inkanda. Hape, chi ni siya inkanda mi chi ni kaya kwe Itayo.” ");
INSERT INTO sbs_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Balutwana ba kwe ni chi bati, “Bone, lyahanu cho wamba ha jolola mi ka u li tusisi indaba zi sa zuweki. ");
INSERT INTO sbs_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Lyahanu chi tweziba kuti wizi zintu zonse, mi ko saki zumwi muntu ku kubuza i mpuzo. Chebaka lyo, tuzumina kuti u kazwa kwe Ireeza.” ");
INSERT INTO sbs_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesu ni cha betaba, “Chi mwa zumina cwale? ");
INSERT INTO sbs_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Mubone, inako chi ya sika, eeni, che niti chi yasika, he te ni mu hasanywe, zumwi ni zumwi ku munzi wa kwe, mi ka munisiye ne nke. Kono ka ni bi nenke chokuti Itayo wi na name. ");
INSERT INTO sbs_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ni ba wambi izi zintu kwenu kuti mu be ni nkozo kwangu. Mwinkanda mwina ni masukuluko, kono mu be ni bundume: Ni ba komi inkanda.” ");
INSERT INTO sbs_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesu hamana ku wamba izi zintu, ncha katwila menso akwe kwi wulu mi na ti, “Itayo, inako chi yasika, ulumbeke Mwanako njo kuti Mwana naye aku lumbeke- ");
INSERT INTO sbs_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","sina kamo ba muheli buyendisi he wulu lya zi bumbantu zonse njo kuti awole kuha buhalo busamani kwa zumwi ni zumwi yo ba muhi. ");
INSERT INTO sbs_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ubu buhalo busamani: kuti ba kwizi, Ireeza yenke we niti, mi iye yo ba tumi, Jesu Kerisite. ");
INSERT INTO sbs_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ni baku tembi hansi. Ni ba mani mutendo oba nihi kuti ni tende. ");
INSERT INTO sbs_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Linu, Tayo, ni tembe hamwina nawe cha ku tembwa ku ni bena nawe pili inkanda ni seni ku bumbwa. ");
INSERT INTO sbs_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ni ba sinululi izina lya ko ku bantu bo banihi kuzwilila mwi nkanda. I bali bako, mi ni waba ni ha, mi baba kuteki inzwi lya ko. ");
INSERT INTO sbs_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Hanu chi bezi kuti zintu zonse zo banihi zi zwa kwako, ");
INSERT INTO sbs_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","mukuti ni babahi ma nzwi anse oba nihi. Ba ba atambuli mi cho buniti ba be zibi kuti nibazwi kwako, mi baba zumini kuti ubani tumi. ");
INSERT INTO sbs_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ni ba lapelela. Kani lapeleli inkanda kono ni lapelela abo boba nihi, mukuti nji bako. ");
INSERT INTO sbs_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Chonse chili cha ngu nji chako, mi chako nji changu, mi ni tembetwe mu bali. ");
INSERT INTO sbs_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Kani si mwina mwi inkanda, kono aba bantu bena mwi inkanda, mi ni keza kwako. I tayo yo Jolola, ba bike mwi zina lyako abo boba nihi njikuti babe ba mwina, sina hatuli umwina. ");
INSERT INTO sbs_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Hani ba sina nabo, ni baba bikite mwi zina lyako, lyo banihi. Ni baba silelezi, mi nanta yenke wabo ya ba sinyehi, kwanda ya mwana we nsinyeho, njo kuti mañolo e zuzilizwe. ");
INSERT INTO sbs_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Hanu ni keza kwako, kono ni wamba izi zintu mwi inkanda nji kuti babe ni ku saanga kwangu kwi zuzilizwe mu bali. ");
INSERT INTO sbs_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ni ba bahi inzwi lya ko, mi inkanda ibaba toyi kakuti kahena be nkanda, sina hani sali we nkanda. ");
INSERT INTO sbs_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Kani kukumbili kuti uba zwise mwi inkanda kono uba wungule ku mubilala. ");
INSERT INTO sbs_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Kahena be inkanda, sina hani sali we inkanda. ");
INSERT INTO sbs_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ba kungule kumbali cho buniti. Inzwi lyako buniti. ");
INSERT INTO sbs_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Sina mo bani tumini mwi inkanda, linu nibaba tumi mwi inkanda. ");
INSERT INTO sbs_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Che baka lyabo ni bali kunguli kumbali, mukuti abo beene nabo ba kungwilwe kumbali mubu niti. ");
INSERT INTO sbs_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Kani lapeli bulyo chaba, kono nabo bonse bani zumine kache nzwi lyabo. ");
INSERT INTO sbs_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Njo kuti bonse babe bamwina, sina iwe, Tayo, mwina mwa ngu, mi nina mwenu. Ni lapela kuti nabo babe mwetu njo kuti inkanda mwi zumine kuti ubani tumi. ");
INSERT INTO sbs_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Kutembwa kuna kobanihi, ni ba kubahi, njo kuti babe ba mwina, sina hatuli bamwina. ");
INSERT INTO sbs_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","I me mu baali, mi iwe mwangu. Njo kuti be zuzilizwe mu mwina, njo kuti inkanda izibe kuti uba ni tumi, mi uba ba suni, sina mo ba ni sunini. ");
INSERT INTO sbs_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tayo, Ni saka kuti abo bo banihi nabo babe name kwete nibe njo kuti ba bone ku tembwa kwangu, ko banihi. Mukuti ubani suni kuzwililila ku matangilo a ku bumbwa kwe inkanda. ");
INSERT INTO sbs_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Itayo yo lukiti, inkanda kena iba kwizi, kono ni kwizi: mi aba bezi kuti ubani tumi. ");
INSERT INTO sbs_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ni be zibisi izina lya ko kubali, mi ni sili izibisa njo kuti ke lato lyo bani saki kalyo libe mubali, mi munibe mubali.” ");
INSERT INTO sbs_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesu hamana ku wamba aa manzwi, ni cha yenda ni valutwani mwi shilya lya musindi wa Kedroni, mu vena luwa u mo iye ni valutwani vakwe mu va ve njili. ");
INSERT INTO sbs_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Linu Judasi, ya vati a muveteke, a vezi chi vaka, kakuti Jesu avali ku yanga mwateni inako ni inako ni valutwani vakwe. ");
INSERT INTO sbs_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Linu Judasi, cha ku tambula chi kwata cha valwi ve inkondo ku zwilila ku va ku lwana va mapurisita ni ku Mafarisi, ni va sepahala, chi vakeza ni malambi ni matachi ni zilwiso. ");
INSERT INTO sbs_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Linu Jesu, ya vezi zintu zonse zi vali ku pangahala kwali, cha zwila havusu mi ni ku vavuza, “Njeni imu kaya vugana?” ");
INSERT INTO sbs_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Chiva mwi tava, “Jesu wa Nazareta.” Jesu cha wamba ku vali, “Njeme.” Judasi, ya va muveteki, naye vulyo ava zimene ni valwi ve inkondo. ");
INSERT INTO sbs_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Mi ha wamba ku vali, “Njime,” chi va vola ni ku ka wila hansi. ");
INSERT INTO sbs_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Linu hape cha va vuza, “Njeni imuka vugana?” Hape chi vati,” Jesu wa Nazareta.” ");
INSERT INTO sbs_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesu che tava, “Na mi wambila kuti Njeme. Haiva muka vugana ime, mu va siye ava vayende.” ");
INSERT INTO sbs_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ichi ivali mukulukela kwi zuzilikizwa linzwi lyava wambi: “Kwavo vo va nihi, Ka kwina nanga yenke ini va tondi.” ");
INSERT INTO sbs_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Linu Simoni Pitolosi, ya vena mukwale, chi ku chomona ni kulenga ku kosola kutwi kwa chilyo kwa muhikana wa muprisita yo hanzi. Linu izina lya muhikana ivali nji Malko. ");
INSERT INTO sbs_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesu chati kwa Pitolosi, “Voze mukwale mu chivikilo chawo. Kana kete chi Ni ywa ikomoki iyo Itayo ya vanihi?” ");
INSERT INTO sbs_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Mi chikwata cha valwi ve nkondo ni mu kulwana, ni va sepahali va Majunda, ni chi va kwata Jesu ni ku musumina. ");
INSERT INTO sbs_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Chi va musoteza itanzi kwa Anna, kakuti ivali mukwenyani wa mukwame wa Kayafa, ya vali mupurisita yo hanzi mwe cho chilimo. ");
INSERT INTO sbs_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Linu Kayafa nji yena yava hi inkelezo ku Majuda kuti ku vena nenza kuti muntu yenke a fwile vantu. ");
INSERT INTO sbs_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoni Pitolosi che chilila Jesu, mi mwa va tendele ni zumwi mulutwana. Linu mulutwani uzo ave zivahele ku mupurisita yo hanzi, mi che njila ni Jesu mwi lapa lya mupurisita yo hanzi; ");
INSERT INTO sbs_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","kono Pitolosi ava zimene ha mulyango hanze. Mi zumwi mulutwana, ya ve zivahele ku mupurisita yo hanzi, chi kuya hanze ku ka wamba ni muganteli wa mwanakazana ni ku leta Pitolosi mukati. ");
INSERT INTO sbs_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Linu muhikana wa mwanakazana, muganteli, chati kwa Pitolosi, “Ka njewe zumwi wa valutwani vo zu muntu?” Chati, “Ka njeme.” ");
INSERT INTO sbs_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Linu vahikana ni vasepahali va vazimene aho, mi ni va tenda mulilo wa makala, kakuti ku vali ku tontola, mi avo vene ni vali tukutisa. Pitolosi naye vulyo a vena navo, ava zimene aho na li tukutisa. ");
INSERT INTO sbs_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mu purisita yo hanzi cha vuza Jesu ku amana ni valutwani vakwe ni intuto zakwe. ");
INSERT INTO sbs_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesu cha mwi tava, “Ni va wambi he nkanza ku inkanda. Ni vali ku luta inako yonse mu masinagoge ni mwi tempele umo Majuda vonse va vali kwiza ha mwina. Ka kwina chi Ni wambi mu nkunutu. ");
INSERT INTO sbs_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Chizi ho ni vuza? U vuze avo va va ni zuwi zi ni va wambi. Lole avo vantu vezi zi Ni va wambi.” ");
INSERT INTO sbs_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Linu Jesu ha wamba ichi, zumwi uva sepahala ava zimene aho chi kudama Jesu infaindi ni kuti, “Mu wi tavila mupurisita yo hanzi vulyo? ");
INSERT INTO sbs_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesu cha mwi tava, “Haiva na wamba chi fosahele, he vupaki vu amana ni ku fosahala, kono haiva ku shieme, chizi ho ni kava?” ");
INSERT INTO sbs_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Linu Anna cha mutumina na suminwe kwa Kaefasi mupurisita yo hanzi. ");
INSERT INTO sbs_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Linu Simoni Pitolosi ya va zimene ni ku li tukutisa. Vantu linu chi vati kwali, “Kahena kuti u zumwi wa valutwani vakwe?” Cha kanana ni kuti, “Ka njeme.” ");
INSERT INTO sbs_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Zumwi wa vahikana va mupurisita yo hanzi, ya vali mukwakwe wa mukwame sikutwi Pitolosi kwa va kosoli, chati, “Kana ni va ku voni naye mwiwa?” ");
INSERT INTO sbs_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pitolosi linu cha kanana hape, mi hahovulyo mukombwe chi wa lila. ");
INSERT INTO sbs_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Linu chi va soteza Jesu ku zwa kwa Kaefasi ku ya kwi maofesi makando a muvuso. Ivali ka kakusani ahulu, mi kana va venjili mwi lapa lya muvusisi ili kuti kanzi vali zuzi ikwe kono valye mukiti we Impaseka. ");
INSERT INTO sbs_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Linu Pilato cha zwila hanze ku vali mi chati, “Ku nyasa nzi ku mu leta ku amana no zu muntu?” ");
INSERT INTO sbs_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Chi vetava ni kuti kwali, “Haiva uzu muntu kana mutendi wa chivi, ni tusana tuva muleti kwako.” ");
INSERT INTO sbs_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato linu chati ku vali, “Mu muhinde muvene, mi mu ka muatule cha kuya cha mulao wenu.” Majuda chi va wamba kwali, “Kana ka ku zu mi ninwe kwetu ku vika muntu yense mwifu.” ");
INSERT INTO sbs_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Va va wambi izi ili kuti linzwi lya Jesu li zu zilikizwe lya va wambi ku tondeza mufuta we ifu lyesa nafwe. ");
INSERT INTO sbs_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Linu Pilato che njila mu maofesi makando a muvuso chi ku supa Jesu mi chati kwali, “Kana njewe Simwine wa Majuda?” ");
INSERT INTO sbs_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesu che tava, “U wamba cha ku zwilila mwako, kapa cha vamwi va vaku wambili ku amana name?” ");
INSERT INTO sbs_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato che tava, “Ka hena ni Mujuda, Njime? Vantu vako ni mapurisita va kando va va kuhi kwa ngu. U va chiti nzi?” ");
INSERT INTO sbs_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesu che tava, “Muvuso wangu ka hena weyi inkanda. Kamba muvuso wangu uvali we neku lye inu inkanda, linu vahikana vangu ni valwa ili kuti kanzi ni hewa ku Majuda. Kono hanu muvuso wangu ka wuzwi munu” ");
INSERT INTO sbs_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato linu chati kwali, “Linu njewe simwine?” Jesu che tava, “U wamba kuti Njeme simwine. Lyeli nji ivaka li Ni va pepelwa, mi cheli ivaka li ni vezili mwi inkanda kuti ni vike vupaki cha vuniti. Yese yo wila ku vuniti utekeleza ku linzwi lyangu.” ");
INSERT INTO sbs_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato chati kwali, Vuniti chi? Ha mana ku wamba izi, cha yenda hanze hape ku Majuda mi chati ku vali, kana na wana mulandu mo zu muntu. ");
INSERT INTO sbs_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kono mwina chizo cha kuti ni lukulule muntu yenke kwenu ha mukiti we Impaseka. Linu musaka kuti ni mi lukulwile Simwine wa Majuda?” ");
INSERT INTO sbs_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Linu chiva huweleza hape chi vati, “Isiñi uzu muntu, kono Banabasi.” Linu Banabasi ivali musa mukando.” ");
INSERT INTO sbs_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Linu Pilato ni cha hinda Jesu ni ku mushupa. ");
INSERT INTO sbs_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Masole ni ba luka ihusi ya miya. Ni ba izwatika Jesu ku mutwi ni ku muzwatika muchizabalo cha mubala wabusimwine. ");
INSERT INTO sbs_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ni chi beza kwali ni chi bati, “Yosho, Simwine wa Majuda!” mi ni chi ba mudama. ");
INSERT INTO sbs_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Linu Pilato ni cha zwila hanze hape mi ni chati kubali, “Mubone, Ni muleta hanze kwenu chokuti mwizibe kuti ka na na wana mulandu kwakwe.” ");
INSERT INTO sbs_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Chobulyo Jesu ni chazwila hanze, a ba zwete ihusi ya miya ni chizwato chamubala wa busimwine. Linu Pilato ni chawamba ku bali, “Mubone muntu!” ");
INSERT INTO sbs_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Linu ni hakwinabulyo bapurisita bakulwana ni basepahala chi ba bona Jesu, chi bahuweleza ni kuwamba kuti, “Mu mu kokotele, mu mu kokotele!” Pilato ni cha wamba kubali, “Mu muhinde mubene mi mu mu kokotele, mukuti ka kwina mulandu wa nawana kwali.” ");
INSERT INTO sbs_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Majuda ni chi ba mwitaba, “Twina mulao, mi chakuya cho wo mulao u swanela kufwa chokuti a ba libiki kuti Mwana we Ireeza.” ");
INSERT INTO sbs_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Linu Pilato ha zuwa ao manzwi, ni chaba ni kutiya ahulu, ");
INSERT INTO sbs_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","mi ni chenjila mu maofisi makando a mubuso hape ni chati kwa Jesu, “U zwa kuhi?” Kono Jesu kana a ba mwitabi. ");
INSERT INTO sbs_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Linu Pilato ni chati kwali, “I we ko wambi kwangu? Kana kawizi kuti ni na ziho za ku ku lukulula, ni ziho za ku ku kokotela?” ");
INSERT INTO sbs_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesu ni cha mwitaba, “Kawina ziho heulu lyangu konji zi ba hewa kwako kuzwilila kwiulu. Ni hakwina bulyo, i ye ya ba ni hi kwako wina chibi chikando.” ");
INSERT INTO sbs_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Che yi inkalabo, Pilato ni cha lika ku mulukulula, kono Majuda ni chi ba huweleza ni chi bati, “Heba ne u lukulula u zu muntu, kahena u mulikani wa Sesare: Zumwi ni zumwi u li bika busimwine u wamba cha kulwisa Sesare.” ");
INSERT INTO sbs_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Linu Pilato ha zuwa ao manzwi, ni chaleta Jesu hanze mi ni chekala muchipula cha buatuli muchibaka chi sumpwa, “Chibaka chi Bumwinwe,” Kono mu chi Heberu, “Gabati.” ");
INSERT INTO sbs_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Linu chi bali izuba lye ntukiso ye Impaseka, chi i bakusaka ku ba inako i kwana i yanza ni konke. Pilato ni chati ku Majuda, “Mubone, u zu simwine wenu!” ");
INSERT INTO sbs_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ni chi bahuwa kuti, “Muzwise, muzwise; u mukokotele!” Pilato ni cha ti kubali, “ni kokotele Simwine wenu?” Ba purisita ba kulwana ni chi betaba, “Katwina Simwine esi bulyo Sesare,” ");
INSERT INTO sbs_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Linu Pilato na ba ha Jesu kuti a kokotelwe. ");
INSERT INTO sbs_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Cwale ni bahinda Jesu, mi ni cha ya hanze, kulihindila chifapano i ye mwine, ku chibaka chi sumpwa “Chibaka cha Katendele,” I cho mu chi Heberu chi sumpwa, “Kologota.” ");
INSERT INTO sbs_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ba ba kokoteli Jesu u mo. Mi ne na ni bantu bamwi bo bele, yenke kwi neku ni neku lyakwe, ni Jesu ne na hakati. ");
INSERT INTO sbs_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato hape na ñola chisupo mi na chibika ha chifapano. Haho ha bañoletwe: JESU WA NAZARETA, SIMWINE WA MAJUDA. ");
INSERT INTO sbs_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Bungi bwa Majuda ni chi ba bala i cho chisupo chokuti chibaka cha ba kokotelwa Jesu chi bena hafuhi ni tolopo. Chisupo chi bañoletwe mu chi Heberu, mu chi Latini, ni mu chi Gerike. ");
INSERT INTO sbs_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Linu mupurisita mukulwana wa Majuda ni cha wamba kwa Pilato, “Kanji u ñoli, “Simwine wa Majuda; kono u ti, I ye mwine a ba wambi, “Njime ni Simwine wa Majuda.” ");
INSERT INTO sbs_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato ne taba, “Chi ni ba ñoli ni ba ñoli.” ");
INSERT INTO sbs_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ha bamana masole ku kokotela Jesu, ni chi bahinda zi zwato zakwe ni ku li abela che inkalulo zone; inkabelo ku isole ni isole, ni chizwato cha hewulu. Kono chizwato che hewulu ke na chibena mapeka, chi ba ku lukililwe hamwina ku zwililila kwiwulu. ");
INSERT INTO sbs_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Linu ni chi ba li wambila a bo beene, “Kanji tu chi ñatuli hakati, kono ni hakwina bulyo tulaule che loto i yo italuhanye kuti ka chi be chani,” I chi chiba chitahali chokuti iñolo li zuzilizwe li wamba kuti, “Ba ba lyiabili zizwato zangu mukati kabo; ba ba lauli che loto chizwato changu.” ");
INSERT INTO sbs_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Masole ba ba chiti izi zintu. Banyina wa Jesu, mwanche u banyina, Maria mwihabwe wa Kulopa, ni Maria Magadalena. A ba banakazi ba bazimene ku chifapano cha Jesu. ");
INSERT INTO sbs_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesu ha bona banyina ni mulutwana ya ba kusuna ni bazimine hembali, na ti ku banyina, “Mwanakazi, bone, mwanako!” ");
INSERT INTO sbs_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Linu nchati ku mulutwana, “Bone, banyoko!” Kuzwililila he nako yo mulutwana na muhinda ku mutwala kumunzi wa kwe. ");
INSERT INTO sbs_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ha kumana ichi Jesu, mukuti a bakwizi kuti zintu zonse linu chi zamana, kuti kwi zuzilizwe mañolo, ati, “Ni fwile inyotwa,” ");
INSERT INTO sbs_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Chibikilo chi bezwile i waine i canchumuka chi ba bikitwe aho, linu chi ba bika chiponji chi zwile i waine i chanchumuka ku mutabi we haisopu ni ku inyamwina ku kaholo ka kwe. ");
INSERT INTO sbs_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Mi Jesu a cha nywine ku i waine i chanchumuka, chati, “Çhi kwamana.” Ni cha kotamisa mutwi wa kwe ni kuha luhuho lwakwe. ");
INSERT INTO sbs_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Linu Majuda, chokuti i ba li izuba lya kuli bakanya, ni kuti mibili kanji i shali ha chifapano mu lye Insabata (Mukuti Insabata i bali ya butokwa ahulu), ni chi bakumbila Pilato kucholola matende a bo ni ku bahangula. ");
INSERT INTO sbs_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Lunu masole chibeza ni kucholola matende a mukwame wa matangilo ni a mukwame wa bubeli ya ba kokotelwe ni Jesu. ");
INSERT INTO sbs_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Linu ha be za kwa Jesu, chi ba bona kuti cha bafwile kale, chobulyo ka na ba ba muchololi matende. ");
INSERT INTO sbs_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ni hakubabulyo, zumwi wa masole cha muhweza mumpati yakwe ni mulinga, mi hohwaho malaha ni menzi ni za zwa. ");
INSERT INTO sbs_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","I ye ya ba boni izi nja bapaki, imi bupaki bwakwe bwe niti. Wizi kuti cha ba wambi i niti njo kuti nanwe bulyo chi muzumina. ");
INSERT INTO sbs_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Chokuti izi zintu zi ba chitahali cha kwi zuziliza iñolo, “Kakwina nanta chimwina ku zifuha za kwe chete chi cholwe.” ");
INSERT INTO sbs_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Hape, limwi iñolo liti, “Ka ba lole kwali iye u ba bahwezi.” ");
INSERT INTO sbs_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ha kumana izi zintu Josefa wa Arimatea, sina ha ba li mulutwana wa Jesu (kono cha kuliungula ka lyowa ku Majuda) cha kumbila Pilato heba u wola kuhinda mubili wa Jesu. Pilato cha muha chibaka. Linu Josefa ni cheza ni kuhinda mubili wakwe. ");
INSERT INTO sbs_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nekudema na ye cheza, u zo kumatangilo ya bezite kwa Jesu masiku. A baleti i maire i kopenywe ni incenka, cha buima busika ha mwanda wonke. ");
INSERT INTO sbs_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Linu chi bahinda mubili wa Jesu ni ku u zingelela mu majira a zi zabalo ni mi nunkiso, si na haibali chizo cha Majuda cha kuzika zitupu. ");
INSERT INTO sbs_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Linu muchibaka umo mwa ba kankamizwe, kubena luwa lwa zibyalantu; mi mwelyo iwa lya zi byalantu ku bena ikumbu ihya umo musena mu beni ku ungwa muntu kale. ");
INSERT INTO sbs_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kakuti i ba li izuba lye intukiso za Majuda mi ni kuti ikumbu li bena hafuhi, ni ba lazika Jesu mwa teni. ");
INSERT INTO sbs_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Linu kuseni seni he zuba lya matangilo lye viiki, ha ku ba ku sisiha, Maria Magadalana cheza kwi kuumbu mi cha bona ibbwe ni li pindumunwa kuzwa kwi kuumbu. ");
INSERT INTO sbs_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Mi cha tiiya ni kwiza kwa Simone Pitolosi ni ku ba lutwana bamwi abo Jesu ba ba kusuna, mi nati kubali, “Ba ba hindi Simwine kumu zwisa mwi ikuumbu, mi ka twizi uko ku baba ka mulaziki.” ");
INSERT INTO sbs_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Mi kuzwa aho Pitolosi ni zumwi mulutwana chi ba zwa kuyenda, mi chi ba yenda kwi ikuumbu. ");
INSERT INTO sbs_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bonse chi ba tiya hamwina, mi zumwi mulutwana cha tiyaa ha busu kuhitilila Pitolosi mi ni ku sika wentanzi kwi ikuumbu. ");
INSERT INTO sbs_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Mi cha zunza mo cha bona majila a zi zwato na dansi hateni, kono kana abe njili mukati. ");
INSERT INTO sbs_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simone Pitolosi ya ba shalile kwali cha sika mi cha yenda mwi ikuumbu. Cha bona majira a zizwato na dansi hateni, ");
INSERT INTO sbs_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","mi ni jira li bena ku mutwi wa kwe. ka hena li ba dansi hamwina ni majira a zizwato kono liba bungeletwe ha ngi lyolyona. ");
INSERT INTO sbs_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Linu zumwi mu lutwana, iye ya ba tangi kusika kwi ikuumbu, naye che njila mukati, mi cha bona ni ku zumina. ");
INSERT INTO sbs_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Mi ku sikila ina i nako kana ba beni kwi ziba iñolo kuti mbwabuke ku zwa ku ba fwile. ");
INSERT INTO sbs_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Mi balutwana chi ba boola ku inzubo hape. ");
INSERT INTO sbs_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Kono Maria aba zimene hanze lye ikuumbu na silisa. Ha ba ku silisa bulyo, cha kotama ni ku zunza mwi ikuumbu. ");
INSERT INTO sbs_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Cha bona ma ngeloi obele muzituba ne keele, limwi ku mutwi, limwi ku matende uko mubiliwa Jesu uba lele. ");
INSERT INTO sbs_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Chi bati kwali, “mwanakazi, cinzi ha usilisa?” cha wamba kubali, “Ka kuti ba hinda Simwine wangu, mi kanizi uko kuba mubika.” ");
INSERT INTO sbs_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ha wamba ichi, cha chebuka mi cha bona Jesu na zimene hana, kono kana abezi kuti nji Jesu. ");
INSERT INTO sbs_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesu chati kwali, “Mwanakazi, chinzi ha u silisa? ukwete ku lola ni?” abali ku seza kuti mu loli we iwa, mi nati kwali, “Mutompehi, heba wa mu zwisa kunze, ni wa mbile ku wa mubika, mi munika mu zwise kwateni.” ");
INSERT INTO sbs_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesu nati kwali, “Maria.” Cha che buka, cha wamba kwali mu chi Aramaiki, “Rabboni,” (italusa: “Muluti.”) ");
INSERT INTO sbs_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesu nati kwali, “kanji uni kwati, ka kuti ka nini ku bola kwi wulu kwa Itayo, kono u yende ku ba mwangu mi ukate ku bali kuti muni ye kwi wulu kwa Tayo ni Itayo wako, kwe reeza wangu ni Ireeza wako.” ");
INSERT INTO sbs_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maria Magadalena che za ni ku wambila ba lutwana, “Ni ba boni Simwine” mi ni kuti aba wambi izi ziintu kwali. ");
INSERT INTO sbs_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ha chiibali citengu, ho luna lu zuba, izuba lye ntanzi lwe viiki, mi mi lyango ya mu babena ba lutwana, ibe ya litwe cha ku tiya Majuda, Jesu che za mi cha zimana mukati kabo mi chati ku bali, “i nkozo kwenu.” ");
INSERT INTO sbs_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ha mana ku te chi, cha ba tondeza mayanza akwe ni mpaati yakwe. Mi ba lutwana haba bona Simwine, ba ba sangite. ");
INSERT INTO sbs_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesu kuzwaho cha wamba kubali hape, “i nkozo kwenu. Sina Itayo habani tumi, linu mu ni mi tumina.” ");
INSERT INTO sbs_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Jesu hamana ku ta ichi, na huzikiza ha bali mi nati kubali, “Mu tambule lu Huho lu Jolola. ");
INSERT INTO sbs_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Bonse ba mu wo ndola zibe, ba zi wo ndelwa; bonse ba zibe zi mukwete, zi si kwetwe.” ");
INSERT INTO sbs_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomasi, zumwi wabe kumi ni bobele, ya ba ku sumpwa Didimasi, kana bena nabo Jesu heza. ");
INSERT INTO sbs_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Bamwi ba lutwana ha ku mana chi ba mu cho, “Twa bona Simwine” Cha ba cho, “kwanda chi na bona mu mayanza akwe i bbata lya zi pikili, mi niku bika munwe mwi bbata lya zi pikili, ni ku bika i yanza lyangu mwi mpaati ya kwe, ke te ni zumine.” ");
INSERT INTO sbs_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ha kumana mazuba akwana iyanza ni to tatwe ba lutwana bakwe ba bena mukati hape, Mi Tomasi a bena nabo. Jesu cheza milyango ni basi yalitwe, mi cha ziima mukati ka bo, mi chati, “inkozo kwenu.” ");
INSERT INTO sbs_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Mi cha ti kwa Tomasi, “u chune kunu ni munwe wako, u bone ma yanza angu, u chune kunu ni yanza lya ko, mi uli bike mwi mpaati yangu, kanji ubi yasa zumini, kono u zumine.” ");
INSERT INTO sbs_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasi che taaba mi nati kwali, “Simwine wangu ni Ireeza wangu.” ");
INSERT INTO sbs_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesu na cho kwali, “kakuti wani bona, wa zumina. Ba fuyoletwe nja bo ba seni ku bona, mi ni bazumina.” ");
INSERT INTO sbs_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Linu Jesu cha tenda zi supo zimwi zingi mu ku bako kwa ba lutwana, zi supo zi seni kuñolwa mwe yi imbuka, ");
INSERT INTO sbs_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","kono izi zi ba ñolwa mukuti mu zumine kuti Jesu nji Kerisite, mwana wa Ireeza, mi nji kuti ku zumina, ni mwaba ni buhalo mwi zina lya kwe. ");
INSERT INTO sbs_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Haku mana izi zintu Jesu cha li bonekisa hape ku ba lutwana kwi iwate lya Tiberiasi. Bo buti mwa bali bonekisi: ");
INSERT INTO sbs_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simone Pitolosi abena hamwina ni Tomasi yo sumpwa Didimasi, Nataniele uzwa mwa Kana wa Gagilea, bana ba chi swisu ba Zebedia, mi ni ba mwi ba lutwana bo bele ba Jesu. ");
INSERT INTO sbs_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simone Pitolosi na ti kubali, “Ni kaya kuku yamba.” Ni ba ti kwali, “Iswe, naswe, mutwize na we.” Chi ba yenda ni kwi chila mu chisepe, kono kakwina chi baba kwati mu ma siku onse. ");
INSERT INTO sbs_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Linu, ha chibali kuseni kwa kaku sasana, Jesu cha zimana he lizo, kono ba lutwana kahena ba bezi kuti ibali nji Jesu. ");
INSERT INTO sbs_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Mi Jesu cha ti ku bali, “Ba lombwana, mwina chimwi cha kulya?” chi ba mwi taaba, “Nee.” ");
INSERT INTO sbs_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Cha ti ku bali, “Mu so hele ka nyandi kenu kwi mbali yo bulyo bwa chisepe, mi kamu wane chi mwi.” Mi chi ba sohela kanyandi kabo, kono kena baba ku wola ku ka ya mbula che baka lye inswi zingi. ");
INSERT INTO sbs_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Linu mulutwana ya ba ku sunwa ahulu kwa Jesu nati kwa Pitolosi, “Nji Simwine.” Simone Pitolosi ha zuwa kuti nji Simwine, cha sumina chi zwato cha kwe cha hanze (mukuti kena a ba zwete), mi ni kuli sohela mwi iwate. ");
INSERT INTO sbs_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ba mwi ba lutwana chi beza mu chisepe (mukuti ka hena ba bena kule ni mutunda, iba li zi bima zo bele ku kuzwa aho), mi ba bali ku kwita ka nyandi ke zwile inswi. ");
INSERT INTO sbs_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Linu haba zubuka ku ya ha mutunda, chi ba bona mulilo ho wa makala mi inswi ni ibikitwe hateni, ni chinkwe. ");
INSERT INTO sbs_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesu chata ku bali, “mulete ku zimwi inswi zi chi mwa kwaata.” ");
INSERT INTO sbs_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simone Pitolosi linu cha yenda ko ni ku kwitila kanyandi ha mutunda, ke zwile inswi inkando; 153. Zi bali zingi tota, kono kanyandi kena kaba haluki. ");
INSERT INTO sbs_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jusu nati kubali, mwize mi nje mulisuke,” ka kwina ku ba lutwana bakwe yaba bileli ni kumu buza, “nje weni?” Ba ba kwizi njeye Simwine, ");
INSERT INTO sbs_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesus cheza, cha hinda chinkwe, mi cha chi baha, mi ni nswi bulyo. ");
INSERT INTO sbs_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ulu chi lubali lya bu tatu Jesu nali bonekisa mwine ku ba lutwana kuzwa ha bukila ku zwa ku ba fwile. ");
INSERT INTO sbs_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ha ba mana kuli suka Jesu nati kwa Simone Pitolosi, “Simone mwana wa Johani, u ni suna kuhita aba?” Pitolosi chati kwali, “ee Simwine, wi zi kuti ni ku suna.” Jesu chati kwali, “Lisike i mbelele zangu, ");
INSERT INTO sbs_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Nacho kwali hape lwa bubeli, “Simoni mwana Johani, uni suna?” Pitolosi nati kwali, “ee simwine, wizi kuti niku suna.” Jesu nati kwali, “U ba balele i mbelele za ngu.” ");
INSERT INTO sbs_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Cha wamba kwali lwa butatu, “Simoni mwana wa Johani, uni suna?” Pitolosi aba wililwe ka kuti Jesu aba wambi kwali lwa bu tatu, “uni suna?” cha ti kwali, “Simwine, wizi zintu zonse, wizi kuti ni ku suna.” Jesu na cho kwali, “U lisike imbelele zangu. ");
INSERT INTO sbs_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Cha buniti, niti, nicho kwenu, ha mu ba kusili mu ba hwile, mu bali ku li zwatika mubene mi niku yenda konse ku mu bali kusaka, kono ha mu supala, ka mu na mulule mayanza enu mi zumwi mwa mi zwatike ni kumi twala kwe sete mu sake kuya.” ");
INSERT INTO sbs_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Linu Jesu na wamba ichi mukuti a bonise ka cheyo inzila ye fu iyo Pitolosi yete a tembe Ireeza. Ha mana ku wamba ichi, na cho kwa Pitolosi, “Ni chilile.” ");
INSERT INTO sbs_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pitolosi cha che buka mi cha bona mulutwana uzo Jesu abali ku suna na be chilile; zuna yaba ku ze ndamina ha chizuba cha Jesu mwi nako yaku lalila zilyo mi nati, “Simwine, njeni uzo yete a ku beteke?” ");
INSERT INTO sbs_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pitolosi cha mu bona mi chati kwa Jesu, “Simwine, chinzi chete a chite uzu mukwame?” ");
INSERT INTO sbs_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesu nati kwali, “Heba ni ni saka kuti ekale ku sikila hete ni bolele, chinzi che cho kwako? Ni chilile.” ");
INSERT INTO sbs_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Mi ichi chi wambo chi che zu lankana mu kati ka ba mwakwe, kuti kuti zuna mulutwana keti afwe. Kono Jesu kena ba ti kwa Pitolosi kuti zumwi mu lutwana keti cho fwa, kono, “Heba ni ni wamba kuti ekale ku sikila he te ni bolele, chi nzi icho kwako?” ");
INSERT INTO sbs_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Uzu nji mulutwana yo paka ka che zi zintu, mi ya ba ñoli izi zintu, mi twizi kuti ku paka kwa kwe kwe niti.” ");
INSERT INTO sbs_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Kwina zimwi zintu zingi Jesu za ba tendi. kambe chimwi ni chimwi chiba ñolwa hansi, Ni sepa kuti ni haibile inkanda yine niyesete niya wola kwi zula imbuka zete ni ziba ñolwa. ");
INSERT INTO sbs_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Imbuka inibañoli kale, Tiofiliusi, ibawambi zonse zabatangi kutenda ni kuluta Jesu, ");
INSERT INTO sbs_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","kutwala izuba lyabatambulwa kwiwulu. Ichi chibatendahali hamana kuha itaelo cha Luhuho Lujolola kuba Apositola babaketi. ");
INSERT INTO sbs_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kuzwa hakunyanda kwakwe, abalileti iye mwine nahala kubali ni bupaki buzuweka. Mumazuba achita makumi wone abalibonahazi kubali, mi abawambi ziamana ni mubuso we Ireeza. ");
INSERT INTO sbs_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Habali kulikopanya nabo, ababalaeli kuti kanji bazwi mwa Jerusalema, kono balindile insepiso ye Shetu, cheyo, nati, “Mubazuwi kwangu ");
INSERT INTO sbs_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","kuti initi Johani abali kukolobeza ni menzi, kono inwe kamukolobezwe muLuhuho luJolola mumazubazana akezite.” ");
INSERT INTO sbs_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Munako ibabakungene hamwina babamubuzi, “Simwine, iyi nji nako yeti nolete mubuso kwa Isilaele?” ");
INSERT INTO sbs_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Abawambi kubali, “kahena njikwenu kuti mwizibe inako kapa inkalulo yabatomi Tayo chamaata akwe. ");
INSERT INTO sbs_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kono kamutambule inguzu, munako yaLuhuho Lujolola heti nilwize hehulu lyenu, mi kamube impaki zangu monse mwa Jerusalema ni mwa Judeya ni Samaria, ni kutwala kumamanimani ekanda.” ");
INSERT INTO sbs_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Simwine Jesu hamana kuwamba izi zintu, nibalolete kwilu, abatwalwa kwilu, mi ikope ni lyamuwunguli hamenso abo. ");
INSERT INTO sbs_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Habachitutubalile kwiwulu nakaya, hahobulyo, bakwame bobele babazimene hembali ni bazwete zituba. ");
INSERT INTO sbs_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Nibati, “Inwe mubakwame ba Galileya, chinzi hamuzimene aha ni mulolete kwiwulu? Uzu Jesu wayenda kwiwulu mwakabole munzila iswana sina mumwamubonena nakaya kwiwulu.” ");
INSERT INTO sbs_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kuzwaho nibabola kwa Jerusalema kuzwa kwi Lundu la Olivi, lina hafwihi ni Jerusalema, musipili umana izuba Lesabata. ");
INSERT INTO sbs_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Habasika, nibatanta mumuzako wina kwiwulu, kubabali kwikala. Ibali nji Pitolosi, Johani, Jacobo, Andriasi, Filipi, Tomasi, Bartolome, Mateu, Jacobo mwana wa Alufeya, ni Simoni Zeloti, ni Juda mwana wa Jacobo. ");
INSERT INTO sbs_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bonse babakopene kuba chintu chimwina, kuzwila habusu kulapela katata. Babena nabo ibali banakazi, Maria nyina Jesu, ni bache bakwe. ");
INSERT INTO sbs_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mwawo mazuba Pitolosi abazimi mukati kabanakwabo, balikana bantu basika ha 120, mi nati, ");
INSERT INTO sbs_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Bakwetu, kuyelele kuti chiñoletwe chizuzilizwe, kutalusa kuti Luhuho Lujolola lubawambi itanzi chakaholo ka Davida kuamana ni Judasi, yabaetelele babakasumini Jesu. ");
INSERT INTO sbs_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Mukuti ibali zumwi wetu mi abatambuli inkabelo yakwe yempo yelinu iluko.” ");
INSERT INTO sbs_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Linu uzu mukwame abawuli luwa chentifo zabawani chabubilala bwakwe, mi haho natangisa kuwisa mutwi, mi mumili wakwe niwañatuka kwiyaluka, mi zamwibumo lyakwe zonse nizalongotoka. ");
INSERT INTO sbs_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Bonse babalikuhala mwa Jerusalema babazuwi zateni, chobulyo babasumpi ulo luwa muchishobo chabo “Akeldama,” njikuti, “Luwa lwa Malaha.”) ");
INSERT INTO sbs_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Mukuti kuñoletwe mumbuka ya Lisamu, 'Musiye luwa lwakwe lube lusinyehete, mi kanji musiyi nanga muntu umwina kuhala mo'; 'Muleke zumwi ahinde chitulo chabuyenzi bwakwe.' ");
INSERT INTO sbs_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Chobulyo, kusakahala kuti umwina wa bakwame yabali kuyendanga naswe inako yonse Simwine Jesu habali kuyendanga mukati ketu, ");
INSERT INTO sbs_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","kukatangila hakolobezwa kwa Johani kuya kwizuba lyabazwiswa kwetu, utameha kuba impaki hamwina naswe kuamana nikubuka kwakwe kubafu.” ");
INSERT INTO sbs_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Babaleti habusu bakwame bobele, Josefa yosumpwa Barsabasi, yabali kusumpwa hape kuti nji Justusi, ni Matias. ");
INSERT INTO sbs_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Babalapeli nibati, “Iwe, Simwine, wizi inkulo zabantu bonse, chobulyo wizibahaze kuti njeni mukati kaba bobele yobaketi. ");
INSERT INTO sbs_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","kuhinda chibaka mweli ikolo ni buapositola waba choli Judasi kuya kuchibaka chakwe,” ");
INSERT INTO sbs_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Babalauli; mi idaula zibawili ha Mateu mi ababikwa hepalo yamuapostola wekumi ni wumwina. ");
INSERT INTO sbs_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Cwale izuva lya Pentecositi haliza, vonse vavena muchi baka chiswana. ");
INSERT INTO sbs_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mwinako yonke chikweza mulumo uzwa kwi wulu uvu luhuho lye mbembwe lukando, mi chilweza kwizula inzuvo yonse iyo ivavali kwikere. ");
INSERT INTO sbs_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Chikweza kuvonahala kuvali malimi aswana uvu muliro uvali kukauhanywa, mi chiweza kuzimana hewulu lyo zumwi ni zumwi wavo. ");
INSERT INTO sbs_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Vonso vave zuziwa Luhuho luNjolola mi chivatanga kuwamba mumishovo imwi, sina Luhuho lu Jolola mulubali kuva hera kuti vawambe. ");
INSERT INTO sbs_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Linu kubena Majunda vavali kwikala mwa Jerusalema, vakwame vavalumeri, ku zwirila kwikanda zonse zomwi konde lye wulu, ");
INSERT INTO sbs_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Uwu mulumo hauzuweka, chisi chivakezi hamwina mivavali kulyangene kakuli zumwi ni zumwiavali kuva zuwire chiba wambulula mumushovo wakwe. ");
INSERT INTO sbs_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Vavali ku komokwete ni mbemuka; chiva wamba, “Luli, kena kuti vonse aba bakwete kuwamba Magalireya? ");
INSERT INTO sbs_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Chinzi hakuchita kuti tuva zuwa, zumwi ni zumwi mumishovo yentu ituva zalirwa mwayo? ");
INSERT INTO sbs_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Patiani ni Medesi ni Elamitesi, ni vamwi vavali kuhala mwa Mesopotamiya, mwa Judeya ni Cappadocia, mwa Pontusi ni Asia, ");
INSERT INTO sbs_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","mwa Phygia ni Pamphylia, mwa Egepita ni muzibaka zimwi za Libiya kuama Cyrene, ni vapoti vavali kukazwa kwa Roma, ");
INSERT INTO sbs_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Majunda ni maProselite, Cretanisi ni ma Arambu, tuva zuwa niva wambira mumi shovo yetu kuamana ni misevezi mikando ye Ireeza.” ");
INSERT INTO sbs_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Vavali kukomoketwe vonse ni kuchanama; chavati kuzumwi ni zumwi, “Kanti ichi chitalusa nzi?” ");
INSERT INTO sbs_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kono bamwi chiva sheununa ni kuti, “Vakoletwe i waine ihya,” ");
INSERT INTO sbs_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Kono Pitorosi chazimana nivena ikumi lyamaza overe ni yenke, cha katula linzwi lyakwe ni kuti kuvali, “Vantu vamwa Judeya nanwe mwense mwikala mwa Jerusalema, muzumine ichi chiziveke kwenu; mutekereze hande kumanzwi angu. ");
INSERT INTO sbs_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kakuti ava vantu kava koletwe iwaine sina mumu hupulera, sina haili vulyo inanko ya kakusasani ke zuva. ");
INSERT INTO sbs_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Kono ichi jichona chiva wambitwe nji mupolofita Joele: ");
INSERT INTO sbs_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","'Kaive vulyo muma zuva okumamanikizo; Ireeza uti, 'Kani tire hasi Luhuho lwangu kuvantu vonse. Vaana venu ve chikwame ni ve chanakazi kava porofite, balombwana benu kava vone impono, mi vasupali benu vechi kwame kava lote ziloto. ");
INSERT INTO sbs_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ni hewulu lyaba hikana vangu mwao mazuva kanitire hasi luhuho lwangu, mi kava porofite. ");
INSERT INTO sbs_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Kani vonise imakzo mwi wulu kuhitirila ni zisupo mwi nkanda hansi, malaha, ni muliro, ni vunsi mwibyubyulu. ");
INSERT INTO sbs_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Inzuva kali sandunke ka sikwe mi mwezi kuvoneka uvu malaha, pilio izuva ikando litiza lya Simwine nili seni kusika. ");
INSERT INTO sbs_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Kaive kuti yense yo supa he zina lya Simwine kahanzwe'. ");
INSERT INTO sbs_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Vantu va Isiraele, muzuwe aa manzwi: Jesu wa Nazareta, mukwame wava misepise kwenu Ireeza che zisupo zikando ni makazo ni zikomokisa izo Ireeza ava pangi chali mukati kenu, sina inwe muvene hamwizi- ");
INSERT INTO sbs_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","chevaka lya mulelo u kolete ni kwizibahaza ni iseni kusika inako yakwe Ireeza, a vatambikiwa, mi inwe, cha manza abakwame basezi mulao, chiva mukokotera ni ku mwihaya; ");
INSERT INTO sbs_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","iye Ireeza ava muvusi, hamana ku sumununa ku chinsa kwefu kwali, kakuli kena kuvali kuwoleka kuti a kwatwe kulili ifu. ");
INSERT INTO sbs_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kakuli Davida ava wambi kuyamana naye, 'Ni va voni Simwine havusu bwangu, kakuti wikere kwimbali lye yanza lyangu lyachilinso iri kuti kanji ni nyangayiswa kamba kushimbululwa. ");
INSERT INTO sbs_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Linu hanu inkulo yangu ivali kusangitwe mi lulimilwangu chi lwa yakalala. Hape, muvili wangu kawikale musepo. ");
INSERT INTO sbs_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kakuti kokafwe kusiya luhuho lwangu muvafwire, kamba kuzuminina wako yo Jolola kuti avone kuvola. ");
INSERT INTO sbs_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Uvavonahazi kwangu inzira zovuhalo; koni pange kuti nizule kusangwa che chi fateho chako.' ");
INSERT INTO sbs_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Vanakwetu, Ni wola kumiwambira cho vundume kuamana ni mupatirita Davida: uzo hape ava fwi ni kuzikiwa mi ikumbu lyakwe lisikere naswe ni sunu linu. ");
INSERT INTO sbs_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Cwalehe, avali muporofita mi avezi kuti Ireeza avali nkonki kwali cho kulisumina vuitamo kwali, kuti kazimike zumwi wavane hachi pura chovulena bwakwe. ");
INSERT INTO sbs_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Avatangi kuvona izi ni kutanga kuwamba kuama ni kuvuka kuva fwire kwa Keresite, 'Kena avazibalwa niku kungirwa muviri wakwe kukuvola.' ");
INSERT INTO sbs_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Uzu Jesu- Ireeza ava muvusi, aho twense twipanki. ");
INSERT INTO sbs_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Cwale hacha mana kumuvusa nikuka muvika kwiyanza lyakwe lyo kuchiliso lyaIreeza mi hachitu tambwire isepiso yo Luhuho lu Jolola luzwa kwa Tayo, abe tiri hansi inzi, zimubwene ni kuzuwa. ");
INSERT INTO sbs_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Linu Davinda kena ava kambamini kwi wulu, kono uwamba, 'Simwine ava wambi kwa Simwine wangu, Wikale kwiyanza lyangu lye chiliso, ");
INSERT INTO sbs_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kusikira hasana kani pangire nzira zako kuva malyatiro a mantende ako.”' ");
INSERT INTO sbs_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Hakuva vulyo, musiye inzubo ya Isiraele yonse izive handede kuti Ireeza ava mupangi hape kuva Simwine ni Keresite, uzu Jesu umuva nkankamizi.” ");
INSERT INTO sbs_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Linu hachi vazuwa inzi, vava chisiwa mwi nkulo zavo, ni kuwamba kwa Pitorosi ni kuva lutwana vonse, nikuti, “Bakwetu, mutu pange nzi?” ");
INSERT INTO sbs_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Mi Pitorosi cha nti kuvali, “” Muvakire zivi zenu mi mukolovezwe, zumwi ni zumwi wenu, mwizina lya Jesu Keresite iri kuti zivi zenu ziwonderwe, mi mumu amuhere impo yo Luhuho lu Jolola. ");
INSERT INTO sbs_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ka kuti kwenu nji kuherwe insepiso ni kuvana venu ni kuvantu vonse vana vena kule, sina vantuvangi vonse vasana kasumpe Ireeza.” ");
INSERT INTO sbs_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Nicha ziwambo zingi cha paka nikuva kumbira; na nti, “Muli haze kuzwa kolu lusika luvilala.” ");
INSERT INTO sbs_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Mi chiva tambula manzwi akwe mi chiva kolovezwa, mi kuva yekezwa mwelina inzuva valikana 3000 vantu kuvali. ");
INSERT INTO sbs_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Chi vazwira havunsu ni tunto zavaapositola ni kulapera hamwina, ni muku cholola chikwa ni mwi tapero. ");
INSERT INTO sbs_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Lyowa chilyeza hewulu lya Vantu vonse, mi zisupo zingi ni makazo ziva pangiwa kuva Apositola. ");
INSERT INTO sbs_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Vonse vavazumini vavali kwina hamwina mi vavalikwina zintu ziswana mumi hupulo, ");
INSERT INTO sbs_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","mi vava uzi zibya zabo zi vavali kukwete ni kuyavira ku vonse, kuyenderela ni muvali kusaka halira kuzumwi no zumwi. ");
INSERT INTO sbs_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Cwale izuva ne zuva vavali ku zwira havusu ni muhupulo umwina mwi tempere, mi vavali kuchola chinkwa muma zuvo, mi vavali kuyavira zilyo cho kusangwa ni kukwatisana mwi nkulo; ");
INSERT INTO sbs_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","vava rumbi Ireeza ni kuhewa chisemo kuvantu vonse, Mi Simwine avali kuyekeza kuvali inzuva nezuva avo vavali kusikuluha. ");
INSERT INTO sbs_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Linu Pitrosi ni Joani vavakuya kuyenda kwi Tempele mwinako ya milapelo, mwinako yavutantu. ");
INSERT INTO sbs_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Mukwame zumwi, yavali chihole kumatende, Avaku nyemunwanga nakalalikwa hamu lyango we Tempele, uvakusupwa mulutu. ilikuti akumbile itunso kuvatu vava kuya mwi Tempele, ");
INSERT INTO sbs_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","chinga bona Pitrosi ni Joani chivasaka kwinjira mwi Tempele, chakumbila intuso. ");
INSERT INTO sbs_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pitrosi, nicha muluvukila nimenso akwe, ni Johani, chati, 'Lole kwetu.” ");
INSERT INTO sbs_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Mukwame wechihole chava lola, nalitukiseze kutambula chimwi kuvali. ");
INSERT INTO sbs_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Linu Pitrosi chati, “Isillivera ni gauda kani zikwete, kono chitukwete, mutuchikuhe. Mwizina lya Jesu Kereste, Yende.” ");
INSERT INTO sbs_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pitrosi nicha mukwata kwiyaza lya chilyo, niku munyemuna mwiwulu, inako ininizana matende ningongo chiza tambula ziho, ");
INSERT INTO sbs_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Chatanga kuchukuta mwiwulu, mukwame wachihole nicha zimana nikutanga kuyenda; Linu niche njila ne Pitrosi ne Joani mwi Tempele, naka buyenda, nachukuta, nikutemba Ireeza. ");
INSERT INTO sbs_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bantu vonse nichiva muvona naka vutemba Ireeza. ");
INSERT INTO sbs_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Nicha valemuha kuti njiyena mukwame wilanga natambula itunso ha Vuluntu bwa mulyango we Tempele; bavezwile kumakala ni kukomokwa chizi chiva pangahali kwali. ");
INSERT INTO sbs_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Linu havali kukwatilile kwa Pitrosi ni Joani, Bantu vonse nichi vantilila hamwina kuvali muchivaka chisumpwa Solomoni, niva komoketwe ahulu. ");
INSERT INTO sbs_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pitorosi havona ichi, chave tava vantu, “Nikuti inwe vantu va Isiraele, chinzi hamukomokwa? Chinzi hamu lolelera kwetu bulyo, uvu jenswe twamuleta kuti awole kuyenda cheziho zetu kamba chovu laperi bwetu? ");
INSERT INTO sbs_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ireeza wa Ambrahama, ni wa Isaka, niwa Jakovo, Ireeza uve sukwezwetu, wakuteka muhikana wakwe Jesu. Jiyena yenke umuba tambiki ni kukana havusu bwa Pilato, Hacha vali kusaka kumu lukukulula kuti aliyendeze. ");
INSERT INTO sbs_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mubakani yo Jolola ni Kuluka yenke, imi chimwa kumbira kuhewa mwihayi kuti a lukululwe ni kuhewa kwenu. ");
INSERT INTO sbs_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Muve hayi Mukwaye wo vuhalo, uzo Ireeza ava vusi kuva fwire - imi twi mpanki bechi chivapangahali. ");
INSERT INTO sbs_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Linu, che tumero mwi zina lyakwe - uzu mukwame umubwene ni kwiziba - ili izina liswana lyamu koza. Itumero ina cha Jesu yaha kwali kuhozwa kuyenderele muvusu bwenu mwense. ");
INSERT INTO sbs_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Linu, basakiwa, Nizi kuti muva pangi chokuseziba, uvu muvava pangiri vayendisi venu. ");
INSERT INTO sbs_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kono zintu inzo Ireeza ava wambi kuvusu cha kaholo kava porofita vonse, kuti uzu Keresite uswanera kunyanda, hanumchave zuzirizi. ");
INSERT INTO sbs_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Muvake, cwale he, mi musanduke, iri kuti zivi zenu ziwole kuzwiswa kwenu, iri kuti kuwole kwiza inko zo kuli joloza kuzwamhavusu bwa Ireeza; ");
INSERT INTO sbs_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","mi kuti na tumine Keresite yava keterwa inwe, Jesu. ");
INSERT INTO sbs_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jiyena yenke Iwulu liswanera kutambula kusikira inako yo kuvozekezwa kwezitu zonse, kuamana nezo Ireeza ava wambi kale chatuholo twava porofita bakwe va jolola. ");
INSERT INTO sbs_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mushe chovuniti avati, “' Simwine wetu Ireeza kavuse mukati kenu muporofita yo swana name. Kamu teke zintu zonse zasana kawambe kwenu. ");
INSERT INTO sbs_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kakupangahale kuti muntu yense yasana kakane kuteka uzo muporofita ke hayiwe kuzwiswa kuvantu vakwe.' ");
INSERT INTO sbs_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Eni, mi vonse Vaporofita kuzwa kwa Samuere navo vavakezi muma sule akwe, vavezi kuwamba nikwiza kwi zivahaza aya mazuva. ");
INSERT INTO sbs_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Inwe muvana vamaPorofita mi nive chilikani icho Ireeza avapangi nive sukuzwenu, sina mwavateri kwa Abrahama, 'Mulusika lwako jimona masika onse e ikanda ka afuyaulwe.' ");
INSERT INTO sbs_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Kasamulaho Ireeza hacha zimikite muhikana wakwe, ava mutumini kwenu chetanzi, iri kuti awole kumi fuyola cho sundukira kuzumwi ni zumwi kumuzwisa kuvuvi bwakwe.” ");
INSERT INTO sbs_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ba Pitrosi ni Johani ha va bakwete kuwamba kuvantu, bapurisita ni induna we tempele ni basaduki ni chivasika kuvali. ");
INSERT INTO sbs_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ba va kukatazehete chevaka lya Pitrosi ni Johana va vakuruta bantu mi va bakuwamba za kuvuka kwa Jesu kuzwilila kuvafwile. ");
INSERT INTO sbs_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ba va basumini mi va vavika mwitolongo kuhitila kakusasana lichilila chakuti chivali chitengu. ");
INSERT INTO sbs_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Kono bungi bwa vantu bavazuwi iñusa lyo ba bazumini; mi inombolo za vakwame va babazumini zi va kusika muzikiti zikwanisa iyanza. ");
INSERT INTO sbs_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","I bezi buti mwizuva licilila, chakuti manduna bavo, bakulwana ni bañoli ba va kungene mwa Jerusalema. ");
INSERT INTO sbs_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Annas muprisita mukando, ni Kayafa, ni Johani, ni Alexandere na vo vonse bakwavo va muprisita mukando. ");
INSERT INTO sbs_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ha va kaleta va Pitrosi ni Johana mukati kavo, ni chibaba vuza, “Çha maata ani, kapa chezina lyani, ha muchita ezi?” ");
INSERT INTO sbs_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Linu Pitrosi, ne zwile Luhuho Lujolola, ni chawamba kuvali, “Manduna ba vabantu, ni bakulwana, ");
INSERT INTO sbs_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","haiva iswe sinu mwikalile kutubuza chakuya cha musevezi mulutu wo tuvapangi kumuntu yo lwala -mi chenzila ihi uzu muntu a vaholi? ");
INSERT INTO sbs_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Chinu chiswanela kwizibwa kwenu ni kuvantu vonse va Isilaele, chakuti chezina la Jesu wa Nazareta, uzo ye muvakokoteli, uzo Ireeza a va muvusi kuvafwile - Nji kwakwe u zu mukwame hazimene aha havusu bwenu na liketete. ");
INSERT INTO sbs_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesu Keresite ibwe inwe muvazaki le muvanyansi kono livapangwa mutomo we mota. ");
INSERT INTO sbs_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ka kwina impuluso cha muntu zumwi; chakuti kakwina izina limwi mwikonde lye ulu, li vahewa muntu zumwi, ilyo lituswanelwa kuhazwa.” ");
INSERT INTO sbs_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Linu cwale hachi vabwene vundume bwa Pitorosi ni Johani, ni kulemuha kuti avali vantu vulyo vasana vavalitutite, vava komokwa, cho kwiza kulemuha kuti Pitorosi ni Johani vavena ni Jesu. ");
INSERT INTO sbs_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kakuli vava voni mukwame yava hozwa na zimene navo, kakwina chimwi chivava woli kuwamba kuamana nechi. ");
INSERT INTO sbs_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kono hachi vamana kulaya ba Apositola kuzwa mumu kopano wavo, chiva tanga kuwamba mukati kavo vene. ");
INSERT INTO sbs_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Chivati, “Mutupange vule kwava vakwame? Cho vuniti vokuti imakazo ivoneka yapangahala chavo iziveka kuzumwi ni zumwi wikala mwa Jerusalema; katuwoli kuisampula. ");
INSERT INTO sbs_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kono iri kuti kanji iyambuluki mukati kavantu, twende tuva kalimere kanji vawambi kuzumwi ni zumwi mweli izina.” ");
INSERT INTO sbs_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Chiva sumpa Pitorosi ni Johani kwiza mukati ni vaha itayero kuti kanji bawambi hape kamba kuruta hape che zina lya Jesu. ");
INSERT INTO sbs_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Kono Pitorosi ni Johani chivali tavirila ni kuwamba kuvali, “Kamba kulukite mumenso a Ireeza kuti tuzuwe inwe isiñi iye, mu atule. ");
INSERT INTO sbs_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kakuli katuwoli kulihaza kukuwamba kuyamana nezi zintu zituba voni ni kuzuwa.” ");
INSERT INTO sbs_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kasamulaho o kuva kalimera ahulu Pitorosi ni Johani, chivava siya nivaliyendeza. Kena vava wani ivaka liva wola kuva nyansa chalyo kuti vavahe inkoto, kakuli vantu vonse vavali kulumba Ireeza kwi makazo iva pangahali. ");
INSERT INTO sbs_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mukwame ava tambuli iyi imakazo yo kuzwa chavali we zirimo zilikana makumi one ni kuhitirila kukuzalwa. ");
INSERT INTO sbs_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Hachiva mana kuva lukulula, Pitorosi ni Johani chiveza kuvantu vavo ni kwiza kuva wambira zonse inzo vakulwana vamaPurisita zivaka va wambira ni manduna ve tempere zivava wambi. ");
INSERT INTO sbs_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Hachi va zuwa ichi, chiva katula manzwi avo hamwina kwa Ireeza ni kiuwamba, “” Simwine, iwe uva vumbi mawulu ni kanda ni wate, ne zina zonse zina mwa teni, ");
INSERT INTO sbs_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Inwe cho Luhuho lu Jolola, cho kaholo ka tayo Davida muhikana wako, ava cho, “' Chinzi inkanda za machava hava lwa, ni maswaniso a sena ituso? ");
INSERT INTO sbs_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Basimwine va hansi va balikunganyi hamwina, ni bayendisi ba vakopani hamwina kulwisa Simwine, ni kulwisa Keresite wakwe; ");
INSERT INTO sbs_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Cheniti, bonse Heroda ni Ponse Pilato, hamwina ni va chisi ni vantu va Isilaele, va bakopani hamwina mumuleneñi uwo kulwisa muhikana wako Jesu, iye yo va iketeli. ");
INSERT INTO sbs_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ba vakopani hamwina kuchita zonse izo ni mayanza ako ni maikuto ako zi vahupulwi pili kuti kazichitahale. ");
INSERT INTO sbs_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Linu, Simwine, lole kumifumbo yabo mi uhe mwihikana wako kuwamba inzwi lyako cha kukola. ");
INSERT INTO sbs_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","chakuti ha cha namulula iyanza lyako mukuholisa, iponiso ni imakazo ziva kuchitahala che zina la muhikana wako yo jolola Jesu.” ");
INSERT INTO sbs_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ha chi bamana kulapela, chivaka ha vakopanela hamwina chi va zikinyehi, mi vonse ni chebezuzwa cha Luhuho Lujolola, mmi va bakuwamba inzi la reeza cha kukola. ");
INSERT INTO sbs_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Inombolo inkando ya vo ba bazumini ba vena chenkulo yonke ni luhulo: mi kakwina zumwi wa bo ya vakuwamba chimwi chamunite kuti luli njichakwe; nihakwinavulyo, ba vena zintu zonse chakuswana. ");
INSERT INTO sbs_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Cha maata makando bapositola ba ba kuwamba ze va baboni kuamana ni nzuho ya Simwine Jesu, mi chisemo chikando chivena heulu lyabo. ");
INSERT INTO sbs_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kakwina muntu mukati kavo ya va bulite chimwi chintu, kwavo vavali kuluwite ivu ini kamba mazuvo zana vava a uzi ni kuleta mali e zintu zivava uzi. ");
INSERT INTO sbs_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ni kwiza kuavika ha mantende'. Mi vantu babahewa kwavo vavali kuzumine, cho kuya zumwi ni zumwi mwavali kusakira. ");
INSERT INTO sbs_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Josefa, yavali Mulevi, mukwame yavali kuzwa kwa Cyprusi, ava hewa inzina lya Banabansi kuva Apositola( iri kuti, chikutolokiwa, mwana wu susuweza). ");
INSERT INTO sbs_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Chokuva newa, chali wuza ni kuleta mashereñi niwiza kuavika hamatende ava apostola. ");
INSERT INTO sbs_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Lyahanu mukwame zumwi yo sumpwa Ananiyasi, ni Safira mwihyabwe, babauzi imbali ye zintu zabo, ");
INSERT INTO sbs_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nabika imbali imwi yeshiliñi ibauzwa (mwihyabwe naye avakwizi), ni kuka leta onse avashali kumatende ava Apositola. ");
INSERT INTO sbs_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Linu Pitorosi nati, “Ananiyasi, cinzi Satani hezula munkulo yako ku chenga Luhuho lu Jolola kupata imwi isheleñi ya muulo wa chisi chako? ");
INSERT INTO sbs_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Hachisena chiveni kuwuziwa, kana chivali njichako? Linu hachi mana kuuziwa, kana chivasina muyediso yako? uva zezete vuti chezi zintu munkulo yako?” Kana uva chengi muntu, kono kwa Ireeza. ");
INSERT INTO sbs_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Mu kuzuwa aa maanzwi, Ananiyasi nawa hansi niku huza lwa ma manimani. Kutiya kukando nikwezila vonse vava zuwi izo zintu. ");
INSERT INTO sbs_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Baswisu niveza kumu vungila mwi sila, ni kumu nyamuna ni kukamuunga. ");
INSERT INTO sbs_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Haku hita inhola zotatwe, mwihyabwe cheza kwinjira, nasezivite chiva tendahali. ");
INSERT INTO sbs_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pitolosi nacho kwali, “Uni wambile kuti inkanda yenu mwa iwulisa cheyi inteko? “Nati “ee, cheyi inteko.” ");
INSERT INTO sbs_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Linu Pitolosi nati kwali, “Muva zuminzani vule ku lika luhuho lwa Simwine? Lole, “Matende a vaka unga mwihyenu ena hamulyango, imi njete vakunyamune nawe.” ");
INSERT INTO sbs_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Haho vulyo chawira hansi ha matende akwe, niku huza lwa mamanimani, imi vaswisu havenjira nikumu wana ufwile; chiva munyamuna, nikuka muunga hembali ni mwihyabwe. ");
INSERT INTO sbs_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kutiya kukando nikweza he nkereke yonse, ni heulu lya vonse vava zuwi izi zintu. ");
INSERT INTO sbs_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Imboniso zingi ni makazo zivali ku chitahala mukati ka vantu cha mayanza avapositola. Vavena vonse mu malibera a Salumoni. ");
INSERT INTO sbs_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Imi kakwina niyava ku wola ku lipapata kuli kopanya navo; nikuva vulyo, vava ku tembwa ahulu ku vantu. ");
INSERT INTO sbs_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Nikuva vulyo balumeri vangi vavakusi wera kwa Simwine, ikunga lya bakwame ni vaanakazi, ");
INSERT INTO sbs_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","chovulyo vava ku letanga va lwala mumigwagwa niku va lazika ha mimbeta ni muzipura, kuti Pitolosi cha hita, munzunde wakwe mu uwole ku wila havamwi vavo. ");
INSERT INTO sbs_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nikweza hamwina impalo inkando ya vantu bazwa kumatoropo mwa Jerusalema, kuleta valwala navo vava vulumukiswa inhuho zisa jololi, imi vonse vava hozwa. ");
INSERT INTO sbs_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kono mupurisita yo hanzi na ziimana, nivonse vavena naye (chikwata chava Saduki); imi nive zula muna ");
INSERT INTO sbs_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Niva viika mayanza havapositola, ni ku va vika mu ntorongo ya vantu. ");
INSERT INTO sbs_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Masiku Iñeloi lya Ireeza chilyeza kwi yalula milyango ye njorongo niku vazwisa hanze, ni kuvati. ");
INSERT INTO sbs_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Muyende, muka zime mwi tempere, niku wamba ku bantu vonse manzwi avuhalo.” ");
INSERT INTO sbs_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Hava zuwa izi, nivenjira mwi tempere musihalizana niku ruta. Kono mupurisita yo hanzi cheza, navo vavena naye, niku supa inkuta hamwina, ni vonse bakulwana vavantu va Isiraere, ni kuva tumina kuntorongo kuka leeta vapositola. ");
INSERT INTO sbs_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Kono vakapaso vava yendi kana vavakava wani muntorongo, ni vaka vola ni kwiza ku viha, ");
INSERT INTO sbs_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Twaka wana intorongo iyalitwe siinte ni ba ganteli ba zimene hamulyango, kono hatwa iyalula, kakwina itwa wana mukati.” ");
INSERT INTO sbs_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Linu muyendisi wa mwi tempere ni mupurisita mukulwana hava zuwa aa maanzwi, ciba ziyeleha chavo ni chiwola kuzwa mwateni. ");
INSERT INTO sbs_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Linu zumwi neza kuva wambila, “Vakwame vamu va vikite muntorongo vazimeene mwi tempere niva ruta vaantu.” ");
INSERT INTO sbs_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Linu muyendisi chayenda ni vakapaso, niku kavavoza, kono nikusena vulwisi, mukuti vava tite kuti vaantu pona chivava pwacoola cha mavwe. ");
INSERT INTO sbs_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Hava kava leta, chivava leta havusu vwe nkuta. Mupurisita yo hanzi nava vuzola impuzo, ");
INSERT INTO sbs_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","nacho, “Tumi ha mulandu wa kusa ruta mweli zina, imi, chimwe zuza Jerusalema ni ntuto zenu, niku tavera ku leta malaha ozu mukwame hetu.” ");
INSERT INTO sbs_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Kono Pitolosi ni vapositola nivetaba, “Tulukera ku kuteka Ireeza insinyi vaantu. ");
INSERT INTO sbs_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ireeza uveshetu ava kuzi Jesu, imuve hayi ni kumu hanzika hesamu. ");
INSERT INTO sbs_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ireeza ava mukuzikizi kwi yanza lyakwe lya chilyo kuva mwaana' simwine ni muhazi, kuha kuliwamba zivi kwa Isiraere, niku kwatila zivi. ");
INSERT INTO sbs_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tu mpaki zezi zintu, imi ni luhuho lu Jolola, ulo lwavahi kwavo vamu kuteka.” ");
INSERT INTO sbs_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Lyahanu inkuta hai zuwa izi. Vava vengi nikusaka kwi haya vaapositola. ");
INSERT INTO sbs_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kono mufalisi yava kusupwa Gamaliele, muruti wa mulao, yava kukutekwa ku vantu vonse, chazima niku laera vaapositola ku zwila hanze kaninizana. ");
INSERT INTO sbs_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Linu chati kuvali, “Vakwame vaIsiraele, Mutwalize minahano kuchimusaka kutenda kwava vaantu. ");
INSERT INTO sbs_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Chenako ya kumasule, Teudiyasi avavuki nalibboka kuvaumwi, imi impalo yavakwame, valikana myanda yoone, nivenjila kwali. Nehaiwa, nivonse vavali kumu kuteka vava hasanywa ni kusa vachimwi. ");
INSERT INTO sbs_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Kuzwa kozu mukwame, Judasi wa Galileya navuka mumazuva achipalo nikuhindikisa vamwi vaantu mwisule lyaankwe. Naye chehaililwa, nivonse vakumu kuteka vava hasanywa. ");
INSERT INTO sbs_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Hanu ni mi wambila, muzwe kwava makwame, ni kuva siya vovona, ilikuti uwu muzezo kapa mutendo wa vaantu, muulyatililwe. ");
INSERT INTO sbs_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Kono heba wa Ireeza, kete muwole ku u lyatilila, mu wola kuli wana kuti chi mu kwete mulwisa Ireeza.” Imi chiva susuwezwa. ");
INSERT INTO sbs_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Linu ni va supila vaapositola mukati, nikuva kavoola ni kuva hambiliza kusa kawamba mwi zina lya Jesu, ni vava siya kuti vayende. ");
INSERT INTO sbs_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Chiva siya inkuta niva tabuluhite mukuti vavavalilwe kuku nyandisizwa che Izina. ");
INSERT INTO sbs_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kuzwaho chezuva, mwi tempere ni chenzubo, ninzuvo, vava ku lutirire ni kutaza Jesu kuva Keresite. ");
INSERT INTO sbs_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Lyahanu mwaanu mazuva, linu impalo ya valutwana haiva kukabwinjiha, impiraero ya Magerike va Majuda chiyatanga Kulwisa Maheveru, kakuti imberwa zavo zivali kuketululwa mwizuva ni zuva lya kuholiswa kwa zilyo. ");
INSERT INTO sbs_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Vena ikumi ni vovele chivasupi chinavungi cha varutwana kuvali ni kuti, “kakwina hande kwetu kuti tusiye liinzwi lye Ireeza niku taha he ntafule. ");
INSERT INTO sbs_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Mu swanera lyahanu kuketa, vakwaluzuvo, bakwame vakwana iyanza ni vovere mukatikenu, bakwame vene vuhalo vulotu, ve zwile luhuho ni vutali. Avo vatuwola kuketa mwei impisinisi. ");
INSERT INTO sbs_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Haili iswe, katuzwire havusu mwi intapero ni mukukutaza liinzwi.” ");
INSERT INTO sbs_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Zi wambo zavo ziva tavisi chinavungi chonse. Linu chivaketa Sitefani, mukwame yowizwire intumelo ni Luhuho Lujolola, ni Filipi, ni Porokoras, ni Nikonora, ni Timoni, ni Parmemasi, ni Nikolasi muprositelite yozwa kwa Antiyoke. ");
INSERT INTO sbs_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Varumeri vavaleti ava vakwame havusu vwa vapositola, vava lapeli ni ku tula mayanza avo havali. ");
INSERT INTO sbs_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Chovulyo linzwi lya Ireeza liva weli; imi impalo ya varutwana ivayekezehi mwa Jerusarema nikuhitiliza; mi impalo yingi ya vapurisita ivakezi kukuteka intumelo. ");
INSERT INTO sbs_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Lyahanu Sitefani, avezwile chisemo ni maata, ava kupanga inkezo zikomokisa ni imboniso mukati kavaantu. ");
INSERT INTO sbs_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Kono chikweza kuzimana vantu wa wila kumasinagoge asumpwa masinagoge alukuluhite, va kwa Serina ni Alexandriya, nivamwi vazwa kwa Silicia ni Asia. Ava vaantu vava kukandekisana ni Sitefani. ");
INSERT INTO sbs_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Kono kana vava kuwola kuzimana kulwisanisa vutali ni Luhuho ulo lwa vakuwamba chalo Sitefani. ");
INSERT INTO sbs_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Linu che inkunutu chiva susuweza vamwi vakwame kuwamba, “Twazuwa Sitefani na wamba maanzwi akunyefula Mushe ni Ireeza.” ");
INSERT INTO sbs_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Vava vengisi vaantu, vakulwana, ni vañoli, mi chiva yenda kwa Sitefani, ni kumukaheeka, ni kumuleeta kunkuta. ");
INSERT INTO sbs_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Vava leti impaki zamapa, vava wambi, “Uzu mukwame kaleki kuwamba maanzwi alwisanisa chivaka chichena ni mulao. ");
INSERT INTO sbs_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kakuti tuvamuzuwi nawamba kuti Jesu wa Nazareta usaka kushinya ichi chivaka ni ku chincha milawo yavaleti Mushe hansi kwetu.” ");
INSERT INTO sbs_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Vaantu vonse vavekele munkuta vava twalite menso avo kwali mi chivavona chifateho chakwe ni chikola ili chifateho che Iñeloi. ");
INSERT INTO sbs_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mu prista mukulwana chacho, “izi zintu zeniti?” ");
INSERT INTO sbs_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","sitefana chacho, “va nchizyangu ni ve shangu, muteke kwangu: Ireeza we nkanya ava voneki kwe shetu Abrahama hava kwina mwa mesopotamia, naseni ku kekala kwa haran; ");
INSERT INTO sbs_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","chacho kwali, 'siye inkanda yako ni mahasi yako, mi uyende mu nkanda yete ni kutondeze.' ");
INSERT INTO sbs_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Cha siya inkanda ya makaladani niku ke kala kwa karani; kuzwaho, hava fwili isi, Ireeza cha muleta mweyi inkanda, mumuhala hanu. ");
INSERT INTO sbs_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","kakwina chavahi kwali chokuyola, ne, kena chivali chikando kuti alyate itende hateni. kono ava sepisi- nanga aho Abrahama kena aveni kuva kale mwana-ilikuti ahinde inkanda kuva chiluwo chakwe ni lusika lwakwe kuzwa kwali. ");
INSERT INTO sbs_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ireeza avali kuwamba kwali vuti, ishika lyakwe mulikahale inako zana mwi nkanda isali yayo, mi vene ve nkanda vaka va vike muvuhikana niku va nyandisa ke mianda yone. ");
INSERT INTO sbs_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","imi muni atule inkanda mwete vakave vahikana; chawamba Ireeza; mi chizamanezo kavazwe mwateni nikuni lapela mwechi chivaka; ");
INSERT INTO sbs_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","mi avahi Abrahama chilikani cho mupato, cwale Abrahama cheza kuva isi wa Isaka niku mutwala ku mupato kamazuva amana lyanza ni tunwe to tatwe. Isaka cheza kuva isi wa Jakovo, mi Jacovo isi wa vana ve kumi nivo vele. ");
INSERT INTO sbs_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Vayendi vava susuwezwe cho muuna kwineku lya Josefa mi chiva muwuza kwa Egepita, mi Ireeza ava kwina naye, ");
INSERT INTO sbs_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","mi chamulukulula ku manyando akwe onse, nikumuha chisemo ni butali havusu bwa Pharaoh, mulena wa Egepita. Pharaoh chamupanga ngambela mwa Egepita ni mwinzuvo yakwe yonse. ");
INSERT INTO sbs_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Linu aho chikweza inzala monse mwa Egepita ni kanana, Ni manyando makando mi veshetu kena vavawani zilyo. ");
INSERT INTO sbs_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kono jakovo hazuwa kuti kwina mundale mwa Egepita cha tumina veshetu va veshetu che ntanzi. ");
INSERT INTO sbs_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","cho vuveli Josefa chalivonahaza ku vakwame; mi mahasi a Josefa chiveza kwi ziveka kwa Pharaoh. ");
INSERT INTO sbs_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Josefa cha vona vamukulwe kuti vakasumpe Jamusi isi wakwe kwiza kwa Egepita, ni mahasi akwe onse, makumi amana iyanza ni makumi ovele ni vantu va mana iyanza. ");
INSERT INTO sbs_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Cwale Jakovo chayenda mwa Egepita; cha kafwa, iye ni vasukulu va vasukulu. ");
INSERT INTO sbs_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Vava twalwa kwa shecham nikuka lazikwa mwi vita ilyo Abrahama lyavawuli ke ntenko mwa silivela ni vana va hamor mwa shecham. ");
INSERT INTO sbs_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Sina inako ye nsepiso hachiyina hafuhi, insepiso yava pangi Ireeza kwa Abrahama, vantu vava kuli niku hweza mwa Egepita, ");
INSERT INTO sbs_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","haisi hakuva kezi zumwi Simwine mwa Egepita, uzu murena yasena va kwizi chintu kuamana ni Josefa. ");
INSERT INTO sbs_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Murena yoswana uzu ava chengeleli vantu niku nyandisi va sukulu vave sukulu, vavahi vana vavo kwi nkozi niva hupula kuti kavahale. ");
INSERT INTO sbs_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Keyo inako Mushe ava pepwa, sekeli mulotu havusu bwe ireeza, mi ava kuvikitwe mwi nzuvo ivesi cha mwezi yo tatwe. ");
INSERT INTO sbs_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","hava ku vikitwe hanze, mwana Pharaoh ava muañuli niku mulela sina njiwakwe. ");
INSERT INTO sbs_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mushe ava kwina inzivo mwintuto zonse za Egepita; mi avana ziho mu manzwi ni mumitendo. ");
INSERT INTO sbs_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","kono hachavali kuchutile kuzilimo ze kumi zone, chiya keza munkulo yakwe kuti akapotele va mukulwakwe, vaana va isilaele. ");
INSERT INTO sbs_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","kuvona mu isilaele na sikululwa, Mushe chamu lamulela ni ku vozekeza yava ku lwisa isilaele: ");
INSERT INTO sbs_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ava kutele kuti va mukulwe kava zuwisise kuti Ireeza che yanza lyakwe ava kuva haza, kono kena vava zuwisisi. ");
INSERT INTO sbs_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Izuva lyitatama cheza kuvamwi ma Isilaele vavakwete kupanga inkani; avaliki kuva vika mwinkozo hamwina; chacho; vakwame, muva kwaluzuvo, chinzi hamu lizuwisa kuchisa?' ");
INSERT INTO sbs_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","kono yava fosekezi zumwi chamu timba, nikucho,' yava kupangi muyendisi ni muatuli hewulu lyetu? ");
INSERT INTO sbs_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","kana usaka kunihaya, sina movehaili ma Egepita izona? ");
INSERT INTO sbs_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mushe chatiya hamana kuzuwa izi; cheza kuva muyendi mwinkanda ya midian, uko kwavavi isi wa vaana vo vele. ");
INSERT INTO sbs_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","zilimo ze kumi yone hazihita, iñiloi chilyeza kuli vonahaza mwihalaupa lya mount sinayi, mu mulilo mukando muka zuka. ");
INSERT INTO sbs_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mushe ha vona mulilo, cha komoka ha vona izo; mi hava ku chunine kuka vona izo, chikweza inzwi lye Ireeza, kuwamba, ");
INSERT INTO sbs_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","njime Ireeza wa veshako, Ireeza wa Abrahama, niwa Isaka, niwa Jakovo,' Mushe cha chachalika mi kena va liki ku lola. ");
INSERT INTO sbs_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ireeza cha wamba kwali, 'chupule insangu zako, kaho chivaka cho zimene hachili chivaka chi jolola. ");
INSERT INTO sbs_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Niva voni luli manyando avantu vangu se vena mwa Egepita; niva zuwi intongosi zavo, mi niva kezi kwiza kuva haza; cwale wize, kani ku tume kwa Egepita.' ");
INSERT INTO sbs_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Uzu Mushe uvava kani, havava wambi,' njeni yava kupangi muyendisi ni muatuli?' - njeye Ireeza yava tumi kuva zonse muyendisi ni mulukululi. Ireeza ava mutumi ke yanza lye ñiloyi lyiva voneki kwa Mushe muka zuka. ");
INSERT INTO sbs_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mushe chava zwisa mwa Egepita, hamana kupanga imakazo ni zisupo mwa Egepita mi nikwiwate lyempi, mi nimwihalaupa ke zilimo zimana makumi one. ");
INSERT INTO sbs_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Nji Mushe yoswana yava wambi kuvantu va Isilaele,' Ireeza ka vuse mu polofita wenu mukati kava mukulwenu, mupolofita ya swana neme.' ");
INSERT INTO sbs_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Uzu nji mukwame yava kwina muchikwata mwi halaupa ne ñiloyi lyiva wambi naye kwi rundu lya sinai. Uzu njimukwame yava kwina niva sukulu vava sukulu; uzu njimukwame yava amuheli manzwi ahala zwiza kutuha. ");
INSERT INTO sbs_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Uzu nji mukwame uzo va sukulu vava sukulu vava kani kwichilila; vava mutandili kule navo, mi mwinkulo zavo vava voli kwa Egepita. ");
INSERT INTO sbs_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Keyo inako chiva wamba kwa Aruni,' Tupangile va zimu vete va tuyendise. haili kozu Mushe, yava tuzwisi mwinkanda ya Egepita, katwizi chapangahala kwali.' ");
INSERT INTO sbs_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Cwale chiva panga iñombe mwao mazuva nikuleta chitavelo kwecho chizimu, niku tava cho musevezi wa mayanza yavo. ");
INSERT INTO sbs_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Kono Ireeza cha sanduka niku va siya kuti va lapele inkani mwiwulu, sina mwiñolelwemwi mbuka ya mapolofita,' kana muva nihi iñombe ni chitavelo ke zilimo zimana makumi one mwi halaupa, inzuvo ya Isilaele? ");
INSERT INTO sbs_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","muva zumini i tabernakele ya moleki ni nkani ze zimu rafani, nizi vupiwa zi muvapangi kuti muzilapele: Mikani mihinde kwi mihitiliza kwa babilona.' ");
INSERT INTO sbs_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Va sukulu vava sukulu sevena itabernaka yo vupaki yo mwihalaupa, Sina Ireeza mwava laeli hava kuwamba ni Mushe, kuti aipange sina chivupeho chava voni. ");
INSERT INTO sbs_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ichi njichintu va sukulu va vasukulu, mwinzila yavo, kuleta munkanda ni Joshuwa. Ichi chiva pangahali havavezi kwinjila nikuluwa mwinkanda izo Ireeza zava zwisi havusu bwava sukulu vava sukulu. Ivakwina vulyo mbwita mu mazuva a Davida, ");
INSERT INTO sbs_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","yava wani chisemo mumenso a Ireeza; ava kumbili kuwana chivaka chamekalo cha Ireeza wa Jakovo. ");
INSERT INTO sbs_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Kono Solomoni ava zakili Ireeza izuvo. ");
INSERT INTO sbs_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Nihakuva bulyo, yohanzi kekali mumazuvo okuzaka ni, mayanza; iswana sina mupolofita ha wamba, ");
INSERT INTO sbs_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Iwulu chihuna changu, mi ifasi malyatilo amatende angu. Inzuvonzi yowola kuni zakila? Simwine uwamba: kapa chivaka chamapumulelo angu chinahi? ");
INSERT INTO sbs_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","kena kuti iyanza lyangu lyipangi izi zintu zonse?' ");
INSERT INTO sbs_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Inwe vantu va zuminine insingo nive inkulo zi sena mumupato ni matwi, mukaninanga Luho Lujolola; mupanga sina muvava kupangira va sukulu vava sukulwenu. ");
INSERT INTO sbs_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Njeni kuva porofita va sukulu vava sukulwenu isena uvavanyandisi? vavehayi maporofita vava voneki ku matangiro okukeza kuyo jolola; mi hanu chimweza kuva vaveteki ni vehayi vakwe nemwe, ");
INSERT INTO sbs_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Inwe vantu muva amuheli milao ivatangwa ku mañiloyi, kono kena muva ichilili.” ");
INSERT INTO sbs_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Linu va kwame ve nkuta hava zuwa izi zintu, vava fundwa kwinkulo, chiva suma meeno avo kwa sitefeni. ");
INSERT INTO sbs_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Kono iye, kakwizula luho lu jolala, chalolelela kwi wulu chokutokomela mi chavona inkanya ye Ireeza; mi chavona Jesu na zimene kwiyanza lya chilyiso lye Ireeza. ");
INSERT INTO sbs_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Sitefani chawamba, “lole, nibwene mawulu eyalukite, mi mwana muntu uzimene kwiyanza lye chiliso lye Ireeza.” ");
INSERT INTO sbs_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kono ve nkuta chiva huweleza mwinzwi lyikando, nikwiyala matwi avo niku muhwelela hamwina vonse; ");
INSERT INTO sbs_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","vava muzindiri hanze yo muleneñi nikumu pwachola: mi impaki chiza zala zi zwato zavo za hanze ha matende a muswisu wa muhwile yo supwa Saule. ");
INSERT INTO sbs_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","havavali kupwachola sitefani, avazwili havusu kusumpa kwa Simwine ni kuwamba,” Simwine Jesu, tambule luho lwangu.” ");
INSERT INTO sbs_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Cha kuvama hansi niku huwa ke linzwi ikando, “Simwine, kanji ukwati ichi chivi kuvali.” hacha mana kuwamba izi, chalala. ");
INSERT INTO sbs_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saule avena mukuzuminzana ni ifu lya kwe. Imi kuzwa yelyo izuva chikwazwa kunyandiswa ahulu kwe kerenke ivena mwa Jerusalema; imi vavazumini vose vava hasa neri muzi vaka za Judeya ni Samariya, mbwita vulyo va apositola. ");
INSERT INTO sbs_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Vakwame vavazumini ni kusepahala vava ziki Sitefani ni kumulira ahulu. ");
INSERT INTO sbs_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Kono Saule ava nyandisi ahulu inkerenke; ava kuyenda mwi nzuvo ni nzuvo ni kuzwisa mo vakwame ni vanakazi, ni kuba vika mutorongo. ");
INSERT INTO sbs_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Kono vava zumini vavali kuhasane chiva yenda ni va kutaza linzwi. ");
INSERT INTO sbs_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipi ava yendi kumuleñi wa Samariya ni kuka kutaza kuvali za Keresite. ");
INSERT INTO sbs_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Chinavungi chavantu havazuwa ni kuvona zisupo zava pangi Filipi, vava tekerezi ahulu hamwina kuza vali kuwamba. ");
INSERT INTO sbs_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Imi ku vantu vangi vava zizuwi, ihuho zisa chenete zibazwi hanze cho muhuwo mukando; ni vangi vava zuminine luñañali ni ziyanga vonse vava hozwa. ");
INSERT INTO sbs_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Mi kuvena ahulu kusangwa muwuna muleneñi. ");
INSERT INTO sbs_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kono kuvena mukwame zumwi mowu muleneñi yavali kusupwa Simoni, uzo yavali kupanganga mabivo kumatangiro; avali ku komasanga ahulu vantu va mwa Samariya, lyinu avali kulihinda kuva muntu yo tompeha. ");
INSERT INTO sbs_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Vonse vena Samariya, kuzwa kumunini ni kumukando, vavali kumuteka ahulu; vava wambi, “Uzu mukwame je ziho ze Ireeza zi supwa vukando”. ");
INSERT INTO sbs_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Vava tekereze kwali, kakuti avali kuva komosa ahulu che nako inde ni mavivo a kwe. ");
INSERT INTO sbs_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Kono aho hachi vazumine izo zavava kutazi Filipi kuyamana ni evangeli yo muvuso we Ireeza ni zina lya Jesu keresite, vava kolovezwa, vonse vanakazi ni vakwame. ");
INSERT INTO sbs_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Imi ni Simoni naye vulyo ava zumini: hacha mana ku kolovezwa, cha zwira havusu ni va ni Filipi; hacha vona imakazo ni mitendo ni ipangiwa, ava komokiswa ahulu. ");
INSERT INTO sbs_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Linu haveza kuzuwa va apositola mwa Jerusalema kuti vena Samariya vava tambuli linzwi lye Ireeza, chiva tumina kuvali Pitorosi ni Johani. ");
INSERT INTO sbs_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Hachiva shetumukere kuvali, chiveza kuva laperera, kuti vawole ku tambula Luhuho Lunjolola. ");
INSERT INTO sbs_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kakuti bwita heyo inako, Luhuho Lunjolola kena luveni kukeza hewulu lyavo; vavali kukolovezwe vulyo mwi zina lya Simwine Jesu. ");
INSERT INTO sbs_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Linu Pitorosi ni Johani chiva vavika mayaza avo hewulu lyavo, mi chiva tambula Luhuho Lunjolola. ");
INSERT INTO sbs_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Linu Simoni hacha vona kuti Luhuho Lunjolola luva hewa cho kuvikiwa cho kuvikiwa cha' mayaza, ava apositola chava newira ishereñi. ");
INSERT INTO sbs_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Cha wamba, “Munihe izi ziho, name, iri kuti yense uni kambika manyanza hali a tambule Luhuho lunjolola.” ");
INSERT INTO sbs_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Kono Pitorosi chata kwali, “I silivera yanko i sinyehe nawe, kakuti u hupula kuwana impo ze Ireeza cha mashereñi. ");
INSERT INTO sbs_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","kawina chiyemba chimwi mwezi zintu, kakuti inkulo yanko kayina hande ni Ireeza. ");
INSERT INTO sbs_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Cwale he uvake kovu vuvi bwako, mi ulapere kwa Simwine, iri kuti mwendi mwa wondere kumi nahano ye nkulo yanko. ");
INSERT INTO sbs_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kakuti ni kubwene kuti wina chifanu chovu vengi ni mumawenge e chivi. ");
INSERT INTO sbs_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simoni cha mwitava ni kumuti, “Uni laperere kwa Simwine, iri kuti zonse zintu ziwa wamba kanji zipangahali kwangu.” ");
INSERT INTO sbs_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Aho Pitorosi ni Johani haci vamana kuwamba linzwi lya Simwine, chiva vola kwa Jerusalema; mwinzira, vavali kukutaza evangeri muminzi mingi ya mwa Samariya. ");
INSERT INTO sbs_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Hanu iñiroyi lya Simwine chiya wamba kwa Filipi ni kuti, “Katuke ni kuyenda kwa mbowera kwi nzira iya kuku shetumukera kuzwa kwa Jerusalema kuya kwa Gaza.”( Iyi nzira ina mwi halaupa.) ");
INSERT INTO sbs_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ava katuki ni kuyenda. Muvone, kuvena mukwame youzwa kwa Etopiya, chikombwa cho muyendisi mukando Candesi, mulena wa Etopiya. Avali muvavaleli we chifumu chakwe chose. Avali kwizite kwa Jerusalema kuku lapera. ");
INSERT INTO sbs_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Chavali kuvola mi ave kere mwi kochikara ya kwe, mi avali kuya vuvala mwi vuka yo muporofita Isaya. ");
INSERT INTO sbs_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Luhuho chilwa ti kwa Filipi, “Yende kwali mi wi kale hafuhi ni kochikara yakwe.” ");
INSERT INTO sbs_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Linu Filipi cha tilira kwali, ni kumuzuwa na vala Isaya muporofita, ni kuti, “Mane uzuwisisa cho kwete kuvala?” ");
INSERT INTO sbs_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mu Esopiya chati, “Niwola vule, mwendi zumwi ani tondeze?”Ava kumbiri Filipi kwiza kwi chira naye mwi kochikara ni kwi kala naye. ");
INSERT INTO sbs_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Linu vuvali vwe ñolo lyavali kuya vuvala mu Esopiya avali ili, “Avali twaliwa uvu imberere kukwi hayiwa; mi uvu imbere havusu i totwere havusu bwa fumwayo, ka zasumuni kaholo kakwe: ");
INSERT INTO sbs_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","muma sukuluko a kwe i katulo yakwe iva zwiswa kwali: Jeni yata wambe lusika lwakwe? vuhalo bwakwe vuva hindwa hansi.” ");
INSERT INTO sbs_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Linu mu Enuki cha vuza Filipi, “Ni kukumbira, jini yavali kuwamba muporofita? avali kuwamba iye mwine, kamba avali kuwamba zumwi muntu?” ");
INSERT INTO sbs_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filipi cha tanga kuwamba; ava tangi neli iñolo mwa Isaya kukutaza kuyamana ni Jesu kwa li. ");
INSERT INTO sbs_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Sina ha vavali kuya vuyenda munzira, vava kezi ha menzi; mu Enuki chati, “Vone, hena menzi hanu; chizi chini kanina kuku kolovezwa?” ");
INSERT INTO sbs_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Linu mu Etopiya cha laya i kochikara ku zimana. ");
INSERT INTO sbs_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Chiva yenda hasi mumezi, bonse Filipi ni muenuki, imi Filipi cha mukoloveza. ");
INSERT INTO sbs_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Hava zuvuka hanze ya menzi, Luhuho lwa Simwine chi lwa hinda Filipi; mu enuki kena ava muvoni hape, mi ava yendi mwi nzira yakwe na sangitwe. ");
INSERT INTO sbs_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Kono Filipi ava ka voneki kwa Azotusi. A vakayendi mwe zina zikiriti ni kukutaza Ivangeri kumi leneñi yonse, mbwita hakasika kwa Caseriya. ");
INSERT INTO sbs_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Kono Saule, usiwamba zokutiza ni kwihaya balutwana ba Simwine, cha yenda ku mupurisita mukulwana ");
INSERT INTO sbs_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ni kuka kumbila mañolo ama Sinagoge mwa Damaseka, ili kuti chawana babakuwila mweyo inzila, kapa mukwame kapa mwanakazi, pona chokabaleta niba suminwe kwa Jerusalema. ");
INSERT INTO sbs_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Haba kukabuyenda, kuba tendahali kuti heza kusika hembali ni Damaseka, hahobulyo chikweza kuboneka iseli lingi libakuzwa mwiwulu; ");
INSERT INTO sbs_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","mi chawila hansi ni kuzuwa linzwi liwamba kwali, “Saule, Saule, chinzi ho ni nyandisa? ");
INSERT INTO sbs_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saule chetaba, “njewe ni, Simwine?” Simwine chati, “Njeme Jesu yokwete kunyandisa; ");
INSERT INTO sbs_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","kono zime, winjile mu muleneñi, mi mowambilwe zo swanela kutenda.” ");
INSERT INTO sbs_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Bakwame baba kuyenda ni Saule chiba zima nikubula maanzwi, ni bazuwile linzwi, kono ni basabwene muntu. ");
INSERT INTO sbs_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saule chabuka hansi, mi heyalula menso akwe, kakwina chabakubona; chiba mukwata kwiyanza niku muleta mwa Damaseka. ");
INSERT INTO sbs_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Abahindi mazuba otatwe nasaboni, mi kena aba kulya ni kunywa. ");
INSERT INTO sbs_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Linu Kubena mulutwana mwa Damaseka yaba kusumpwa Aneniyas; mi Simwine aba wambi kwali chempono, “Aneniyasi.” cha wamba, “Bone, ime zunu, Simwine.” ");
INSERT INTO sbs_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Simwine cha wamba kwali, “Zime, uyende mwi kululu lisumpwa Kuotoloka, mi kwi nzubo ya Judasi buze mukwame yozwa kwa Tarese yosumpwa Saule; yokwete kulapela; ");
INSERT INTO sbs_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","mi ababoni impono mukwame yaba ku sumpwa Ananiyasi nakeza kwali kwiza kumubika maanza, ilikuti atambule kubona kwakwe.” ");
INSERT INTO sbs_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Kono Ananiyasi chetaba, “Simwine, ni bazuwi kubangi kuamana nozu mukwame, inkolofalo isika hayi yabatendi kubantu bako bajolola mwa Jerusalema. ");
INSERT INTO sbs_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Wina maata azwa ku mukulwana wa maprisita ku sumina bonse kunu ba sumpa he zina lyako.” ");
INSERT INTO sbs_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Kono Simwine chawamba kwali, “Yende, mi uzu uketetwe kuba chisebeliso changu, kuhinda izina lyangu habusu bwa chisi chingi ni malena ni bana ba Isilaele; ");
INSERT INTO sbs_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","mi kani mutondeze mwete a sukulukile chebaka lye zina lwangu.” ");
INSERT INTO sbs_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Cwale Ananiyasi chayenda, ni kwinjila munzuvo. Kuka muvika maanza hakwe, chati, “Mukwangu Saule, Simwine Jesu, yaba boneki kwako he nzila hamuba kukeza, wakanituma ili kuti zo tambule kubona kwako mi wizule luho lu jolola.” ");
INSERT INTO sbs_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Hahobulyo zintu zikola maamba zibawi mumenso a Saule, mi chatambula kubona kwakwe, aba zimi ni kukolobezwa; ");
INSERT INTO sbs_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","abali nikuwana ziho. Abekali ni balutwana mwa Damaseka chamazuba alikene. ");
INSERT INTO sbs_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Haho chaha bupaki bwa Jesu muma Sinagoge, nata kuti uzo mwana wa Ireeza. ");
INSERT INTO sbs_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Bonse baba zuwi baba komokwa ni kuwamba, “kanjiyena uzu mukwame yaba sinyi abo mwa Jerusalema baba kusumpa heli zina? mi abakezi kunu ili kuti abalete zeba suminwe kumu kulwana wa maprisita.” ");
INSERT INTO sbs_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Kono Saule abezi kwinjihilwa ziho, aba leti filikana mukati ka ma Juda baba kuhala mwa Damaseka chakutondeza kuti Jesu nji Keresite. ");
INSERT INTO sbs_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Hakuhita mazuba mangi, ma Juda chibalela hamwina kuti bamwihaye. ");
INSERT INTO sbs_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Kono mulelo wabo chiwezibeka kwa Saule. Baba kugantela milyango musihali ni masiku ilikuti bamwihaye. ");
INSERT INTO sbs_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kono balutwana bakwe baba muhindi masiku kumushilsa imota, shetumwina muchitanda. ");
INSERT INTO sbs_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Hakeza kusika mwa Jerusalema, Saule abaliki kukopana ni balutwana, kono bonse baba kumutiya, nibasa zumina kuti mulutwana. ");
INSERT INTO sbs_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Kono Barnabasi abamuhindi ni kumutwala ku bapositola. Mi Chaba wambila mwaba boneni Saule Simwine he nzila ni kuti kuti Simwine aba wambi naye, ni kwaDamaseka Saule mwa bakutazi chakusatiya mwizina lya Jesu. ");
INSERT INTO sbs_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Aba kopani nabo hababa kukeza ni kuzwa mwa Jerusalema. Abawambi chakusatiya mwi zina lya Simwine Jesu ");
INSERT INTO sbs_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","aba wambolisani ni ma Gerike bama Juda; kono baba zwili habusu ni kulika kusaka kumwihaya. ");
INSERT INTO sbs_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Linu baakwetu habeziba izi, chiba mulate hansi kwa Sesaria nikumu tumina kwa Tarese. ");
INSERT INTO sbs_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Cwale linu, Inkeleke zonse mwa Judea, Galilea, ni Samaria babena inkozo imi ibazakite; ni, kuyenda niba tiite Simwine ni mukuombwa-ombwa kwa luhuho lu jolola, inkeleke chiza yekezeha chabungi. ");
INSERT INTO sbs_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Linu kubezi tendahali kuti, Pitrosi haba kukabuyenda muchikiliti chonse, aba kezi kuba lumeli baba kuhala mwi tolopo ya Lida. ");
INSERT INTO sbs_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Uko abakawani mukwame zumi wezina lya Enea, yabena kabulo bwakwe chezilimo zilimo zimane iyanza ni zotatwe, aba kuzuminine luñañali. ");
INSERT INTO sbs_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pitrosi chati kwali, “Enea, Jesu Kereste waku hoza. Buke mi uzale bulobwako.” hahobulyo cha zimana. ");
INSERT INTO sbs_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","cwale bonse baba kuhala mwa Lida ni mwa Saroni bababoni mukwame ni ba sandukila kwa Simwine. ");
INSERT INTO sbs_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Linu mwa Jopa kubena mulutwana ya ba kusumpwa Tabita, itoloketwe kuti “Dorkasi.” Uzu mwanakazi abezwile mitendo milotu ni zitendantu zizwile chishemo zaba pangili bahumanehi. ");
INSERT INTO sbs_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","kubezi kauba kuti mwawo mazuba kuti abezi kulwala ni kufwa; hachi babamanite kumushanza, baba mulaziki munzubo yokwiwulu. ");
INSERT INTO sbs_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Sina Lida haiba kwina hembali ni Jopa, mi balutwana babazuwi kuti Pitrosi kwabakwina, chibatumina bakwame bobele kwali, kumu kumbila kuti, “Wize kwetu nikusena kuliyeha.” ");
INSERT INTO sbs_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pitrosi chazimana ni kuyenda nabo. Hakasika, chibamutwala kwi nzubo ya kwiwulu. Mi imbelwa zonse ziba kuzimene kwimbali yakwe ni zilila, niba mutondeza majansi nizi zizwato zababa pangi Dorkasi nasina nebo. ");
INSERT INTO sbs_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pitrosi chaba zwisikiza bonse hanze ye nzubo, cha fukama, ni kulapela; haho, cha sandukila kumubili, chawamba, “Tabita, buke.” Che yalula menso akwe, mi habona Pitrosi che kala. ");
INSERT INTO sbs_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pitrosi linuchamuha iyanza lyakwe ni kumu zimanika; mi hasumpa balumeli ni mbelwa, abamuleti na hala kubali. ");
INSERT INTO sbs_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Iyi indaba chiyezibeka ahulu mwaJopa yonse, imi bantu bangi baba zumini kwa Simwine. ");
INSERT INTO sbs_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Kubazi kuba kuti Pitrosi abekali mazuba mangi mwaJopa ni mukwame yosumpwa Simoni, yaba kusuka madalo. ");
INSERT INTO sbs_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Linu kubena mukwame ya ba kuhala mu muleneñi wa Sesalia, Kornile che zina, mukulwana wa Masole yi ba kusumpwa Italiya. ");
INSERT INTO sbs_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","I bali mukwame, zumwi ya bakulapela Ireeza ni be nzubo yakwe; aba hi masheleñi mangi ku bantu ba Majuda mi inako yonse a bakulapela Ireeza. ");
INSERT INTO sbs_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Chi ku ba kuatumela inako ya bulobañwi ye zuba, a ba boni hande mumpono iñeloi lye Ireeza nilikeza kwali. Iñeloi ni lyati kwali, “Kornele;” ");
INSERT INTO sbs_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kornele ni chadunamena iñeloi imi abatite hahulu ni chati, “Chinzi fumwangu?” Iñeloi ni lyati kwali, “Intapelo zako ni mpo zako kuba saliwaneli ziba yendi kwiwulu sina kuzeza za chitabelo che Ireeza. ");
INSERT INTO sbs_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Linu utume bakwame ku muleneñi wa Jopa kukaleta mukwame we zina lya Simone yo sumpwa Pitrosi. ");
INSERT INTO sbs_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Wikele ni yo suha madalo yo sumpwa Simoni, uzo inzubo yakwe yina hembali yelizo lyewate.” ");
INSERT INTO sbs_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Linu iñeloi liba kuwamba kwali ni chilyayenda, Kornele ni cha sumpa bahikana bobele benzubo yakwe, ne sole liba kulapela Ireeza mukati kamasole nabo babali kumusebeleza. ");
INSERT INTO sbs_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kornele ni cha bawambila zonse zintu ziba chitahali mi ni chabatuma kwa Jopa. ");
INSERT INTO sbs_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Linu mwizuba lichilila chibakuatumela inako ya busilela, sina hababena mumusipili wabo mi babena hafuhi ni muleneñi, Pitrosi ni chayenda kunzubo ya kwiulu kuka lapela. ");
INSERT INTO sbs_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Mi haho ni chafwa inzala mi ni chasaka chimwi chintu cha kulya, kono bantu babakwete kwihika zilyo, ni cha hewa impono, ");
INSERT INTO sbs_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","linu na bona iwulu nili yaluka ni chibya chimi chi bakuswana sina ijira ikando li ba kusuuka hansi, ne liiza cha makona one. ");
INSERT INTO sbs_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mulili kubena mifuta yonse ya zinyolozi zina matende one ni zimwi zintu zi kokoba hansi, ni zizuni za mwiulu. ");
INSERT INTO sbs_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","'Linu Inzwi ni lya wamba kwali. “Buuke, Pitrosi, wi haye mi ulye.” ");
INSERT INTO sbs_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Kono Pitrosi nati, “Kahena njo bulyo; Simwine; Chokuti kena ni bali chimwi chi sajolwele ni china ikwe.” ");
INSERT INTO sbs_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Kono inzwi ni lyeza kwali hape lwa bubeli: “Cha bajolozi Ireeza, kanji uchisumpi kusa jolola.” ");
INSERT INTO sbs_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Izi zibatendahali totatwe; linu chibya hahobulyo ni chabozwa kwiwulu. ");
INSERT INTO sbs_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Linu Pitrosi haba kuchi lyangene kuamana ni impono ya baboni kuti italusanzi, mubone, bakwame babatumwa kwa Kornele ba bazimene kumulyango, habamana kubuza inzila yabo iya kunzubo. mi ni chibasumpa ni kubuza kapa Simoni, Ya ba kusumpwa hape kuti nji Pitrosi ");
INSERT INTO sbs_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Imi ni vahuweleza Simone, yava ku sumpwa Pitrosi, kwa ba kuikala. ");
INSERT INTO sbs_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pitrosi ha ba sikwete kuhupula kuamana ni impono, Luhuho ni lwa wamba kwali, “Bone, bakwame botatwe bakwete bakulola. ");
INSERT INTO sbs_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Uzimane mi uyende hansi mi uyende nabo. Kanji uhakanyehi ku yenda nabo, kakuti naba tuma,” ");
INSERT INTO sbs_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Cwale Pitrosi ni chayenda hansi ku bakwame imi ni chati, “Ime zunu ye mukwete kusaka. Chinzi ha mwakeza?” ");
INSERT INTO sbs_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ni chibati, “Mulauli wa masole wezina lya Kornele, mukwame yo lukite mi yo lapela Ireeza, imi uwambwa kunkanda ya Majuda, aba wambilwa kwi iñeloi lijolola lye Ireeza kutuminwa kwako kuti uyende kunzubo yakwe, ili kuti akateke kumulaezo uzwa kwako.” ");
INSERT INTO sbs_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Linu Pitrosi chabamema kuti benjile mukati ze bekale naye. Izuba lichilila ni chazima ni kuyenda nabo, imi ni bamwi bakwake bazwa mwa Jopa ni chi bamusindikiza. ");
INSERT INTO sbs_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Izuba lichilila ba bakezi kwa Sesarea. Kornile a babalindile, a basumpi hamwina bazalwa ni bo ni balikani bakwe. ");
INSERT INTO sbs_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Kubezi kutendahala kuti linu Pitrosi chengila, Kornele ni cha musanganya imi abafukami hamatende akwe ku mulapela. ");
INSERT INTO sbs_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Kono Pitrosi chamutusa, nawamba, “Zime! name bulyo ni muntu.” ");
INSERT INTO sbs_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Haho Pitrosi aba kuwamba naye, ni chayenda mukati mi ni chawana bantu bangi ne bakungene hamwina. ");
INSERT INTO sbs_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ni chati kubali, “Inwe mubene mwizi kuti kahena mulao kuti muntu wa Majuda a li kopanye kapa apotela zumwi yozwelela kumushobo ungi. Kono Ireeza a banitondezi kuti kanji ni sumpi muntu zuhi no zuhi kuti kajolwele. ");
INSERT INTO sbs_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Nji bakalyo ha na keza kusena kukanana, ha ni batuminwa. Linu ni mibuza chinzi ha mwa ni tumina.” ");
INSERT INTO sbs_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornele ni chati, “Mazuba one abamani chehola iswana na yoyi, Ni bakulapela, chehola yabulobanwi munzubo yangu; mi ni chinabona, mukwame na zimene habusu bwangu muzizwato zibenya. ");
INSERT INTO sbs_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ni chati, 'Kornele, intapelo yako iba zuweki kwe Ireeza, imi impo zako kubabotana zi ba zezisi Ireeza kuamana na we. ");
INSERT INTO sbs_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Linu, utume muntu kwa Jopa, aka kusumpile mukwame we zina lya Simone yo supwa Pitrosi. ");
INSERT INTO sbs_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Wikala munzubo ya yo suha madalo wezina lya Simone, wikala hafuhi ni mbali lyewate. ");
INSERT INTO sbs_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Linu Pitrosi che yalula kaholo kakwe mi ni chati, “Cheniti, ni lemuha kuti Ireeza kahindi zumwi che nketululo. ");
INSERT INTO sbs_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Chobulyo, Mu mushobo ni mushobo ni zumwi ni zumwi yo lumbeka ni kuchita inkezo zilukite u amuhelwa kwali. ");
INSERT INTO sbs_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Mwizi iñusa lya batumine kubantu ba Isilaele, haba lemusa ze iñusa lye inzwi iloto kuamana ni nkozo chakuya cha Jesu Kreste, ili iye Simwine wa bonse - ");
INSERT INTO sbs_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","inwe mubene mwizi ikezo zi bachitahali, ziba tendahali munkanda yonse ya Judeya, kutangila mwa Galileya, kuzwa ku nkolobezo ya balemusi Joani; ");
INSERT INTO sbs_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","inkezo ziamana ni Jesu wa Nazareta, ka mo Ireeza mwaba musingili oli cha Moya ujolola ni cha maata. Aba yendi kuamana ni kuchita bulotu ni kuhoza bonse ba bakakatizwe kwa diabulosi, kokuti Ireeza abena naye. ");
INSERT INTO sbs_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Tumpaki ya zintu zonseza ba tendi munkanda zonse za Majuda ni mwa Jerusalema - uzu Jesu iye ye babehai, kumuhanzika ha chikuni. ");
INSERT INTO sbs_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Uzu mukwame uzo Ireeza a bamubusi mwizuba la butatu ni kumuha kuti ezibekane, ");
INSERT INTO sbs_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","isiñí kubantu bonse, kono ku mpaki ziba ketwa kumatangilo che Ireeza- iswe tubene, babalyi, ni kuñywa naye amana kubuka kubafwile. ");
INSERT INTO sbs_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Aba tulaeli kukutaza ku bantu ni kupaka kuti uzu njiyena ybva ketwa kwe Ireeza ku va muatuli wabahala ni bafwile. ");
INSERT INTO sbs_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Njikwakwe kuti ba polofita bonse babe impaki, kokuti yense yo zumina kwali a tambule inswalelo ya zive che zina lya kwe.” ");
INSERT INTO sbs_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Haho Pitrosi nasikwete kuwamba izi zintu, Luhuho Lujolola ni lwa wila ku zumwi ni zumwi kwabo baba kutekeleze kwi ñusa lyakwe. ");
INSERT INTO sbs_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Bantu baba kuwila ku chikwata chi wila kumupato ilichikwata chizumine- Bonse abo babakezi ni Pitrosi- babakomoketwe, mukuti impo ya Luhuho Lujola lbetilwa vulyo niku chisi chingi. ");
INSERT INTO sbs_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Mukuti, babazuwi aba basiangi, ni bawamba cha mishobo ingi ni kulumbeka Ireeza. ");
INSERT INTO sbs_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Linu Pitrosi ni chetaba, “Kana kwinazumwi uwola kukanisa menzi kwabo bantu kuti kanji ba kolobezwa, aba bantu ba ba amuheli Luhuho Lunjola sina motubatendeli swe?” ");
INSERT INTO sbs_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Linu naba laela kuti ba kolobezwe mwi zina lya Jesu kreste. Ni ba mukumbila kwi kala nabo chamazuba mangizana. ");
INSERT INTO sbs_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Linu bapositola niba mwabo ba bena mwa Judeya chibazuwa kuti ba Sikunze chibatambula inzwi lye Ireeza. ");
INSERT INTO sbs_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Linu Pitrosi hakeza kwa Jerusalema, abo bena muchikwata chamupato chiba munyansa; ");
INSERT INTO sbs_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Chibati. “Ubali kopanyi ni bakwame basena mupato ni kulya nabo!” ");
INSERT INTO sbs_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Kono Pitrosi chatanga kubatolokela chakwizula; 'chati, ");
INSERT INTO sbs_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Nibali kulapela mu muleneñi wa Joppa, imi chinaba ni pono yachintu chikeza hansi, sina isila ikando likeza hansi kuzwa kwiwulu lina tukokolwa tonee. Chichakeza kwangu. ");
INSERT INTO sbs_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","China chilolisisa ni kuchizezisisa. Chinabona zinyolozi za matende onne zamu inkanda, zibatana, ziyendisa mabumo, ni zizuni za mwiwulu. ");
INSERT INTO sbs_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Linu china zuwa inzwi liwamba kwangu, “zimane, Pitrosi; wihaye mi ulye!” ");
INSERT INTO sbs_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Chinati, “nee; Nanta kanjobulyo, Simwine: kakwina chintu chisachenete kapa china chive chisenjili mukaholo kangu.” ");
INSERT INTO sbs_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Kono izwi chilyetaba kuzwilila kwiwulu, “Chalukulula Ireeza chijolola sanzi ucho kuti chinekwe.” ");
INSERT INTO sbs_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Izi zibatendahali totatwe, imi linu zintu zonse chizabozwa kwiwulu hape. ");
INSERT INTO sbs_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Kamulole, hahanu kwina bakwame botatwe bazimene habusu bwe zubo hatwina; ba bakatumitwe kwa Caesarea kwiza kwangu. ");
INSERT INTO sbs_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Luhuho Lujolola lwanilaela kuti ni yende nabo, imi sanzi niloli kutibenabule. Aba bakwame balikana iyanza niyenke babayendi name, imi tubayendi ni kwinjila muzubo yamukwame. ");
INSERT INTO sbs_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Chatuwambila mwababoneni Iñeloyi ha tuwambila mwaba boneni iñiloi ni lizimene munzubo yakwe ni kucho, “Tumine bakwame kwa Joppa imi mukaboze Simone yo supwa Pitrosi. ");
INSERT INTO sbs_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Mwa wambe kwenu lizwi lyete limihaze - Iwe ni bezubo yako bonse. ");
INSERT INTO sbs_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Hani tanga kuwamba kubali, Luhuho Lunjolola chilwasukila kubali, sina njikwetu lwetanzi. ");
INSERT INTO sbs_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nibazezi mazwi a Simwine, mwaba wambili, “Joani chabusakusima abakukolobeza chamenzi; kono inwe muswanela kukolobezwa cho Luhuho Lunjolola.” ");
INSERT INTO sbs_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Linu haiba Ireeza ababahi impo ziswana ni zetu hatuzumina kwa Simwine Jesu Kreste, njemeni, kuti ni kangisane ni Ireeza?” ");
INSERT INTO sbs_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Habamana kuzuwa izi zintu, kakwina chibaba wambi kulitabilila, Kono ba balumbeki Ireeza ni kuchokuti, “Imi Ireeza abahibulyo inswalelo ya buhalo kubalichaba nabo.” ");
INSERT INTO sbs_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Linu babo babahasani bakeñi cha masukuluka abezi chebaka lyefu lya Sitefani, libahasani mane kutwala kwa Fonisiya, Sipera, ni Antioke, kono chibakutaza linzwi lya Jesu feela ku Majuda. ");
INSERT INTO sbs_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Kono bamwi kubali, bakwame bakwa Sipera, ni Sirene, chibeza kwa Antioke, imi chibawamba bulyo ni ku Magerike, ni ku bawambila mazwi malotu kuamna ni Simwine Jesu. ");
INSERT INTO sbs_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Imi iyanza lya Simwine libena nabo; bungi bwabo bubazumini ni kubola kwa Simwine. ");
INSERT INTO sbs_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Iñusa kuamana nabo chilyeza mumatwi ye Kereke ya mwa Jerusalema: imi chibatuma Barnabasi kuyenda kule kwa Antioke. ");
INSERT INTO sbs_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Hakeza ni kwiza kubona impoo ye Ireeza, aba sangi; imi chaba susuweza bonse kwikala ni Simwine chenkulo zabo zonse. ");
INSERT INTO sbs_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Imi abali mukwame yabena sinte wizwile Luhuho Lunjolola ni tumelo, imi bungi bwabantu baba ekezehi kwiza kwa Simwine. ");
INSERT INTO sbs_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Barnabasi linu chayenda kwa Tarese, ku kasaka Saule. ");
INSERT INTO sbs_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Hamuwana, cha muleta kwa Antioke. Chikweza kubakuti, mwaaka onse chibali kunganya hamwina ne Kereke hamwina ni kuluta bungi bwabantu. Balutwana babakusumpwa Makereste lwetazi mwa Antioke. ");
INSERT INTO sbs_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Linu mwa anu mazuva bamwi bapolofita chiba sezumukila kwa Jerusalema kwa Antioke. ");
INSERT INTO sbs_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Umwina kubali, Agabusi, chezina chazima ni kupolofita cha Luhuho kuti inzala inkando mwi ikanda yonse. Izi ziba kutendahala mumazuba a Klaudiya. ");
INSERT INTO sbs_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Njokuti, balutwana, sina zumwi ni zumwi habakuwola, chahupula kutumina intuso kubamwakwe mwa Judeya. ");
INSERT INTO sbs_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Babatendi bulyo, baba tumini mashelenyi kuba kulwana bakeleke chamanza a Barnabasi ni Saule. ");
INSERT INTO sbs_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Linu mwezo inako Simwine Heroda avali kusebelisa inguzu zakwe kusumina vava kuzwila mwikeleke mukuti avasukulule. ");
INSERT INTO sbs_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Abehayi Jakovo mwache wa Joani cha mukwale. ");
INSERT INTO sbs_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Kuzwaho chinga bona kuti zisangisa majuda, nichazwila hansu nikusumina Pitorosi naye. Linu ayo avali mazuva achikwa chisena mulungo. ");
INSERT INTO sbs_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Hmana kumusumina, nicha mubika mwitolongo linu nicha bika zikwata zone za masole kumu mamela; Avali kuzeza kumuleta kubatu kumasule Epaseka haimana. ");
INSERT INTO sbs_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Linu Pitorosi ava bwikitwe mwitolongo, Imi balumeli kana ba bali kusiya kumu kumbilila kwa Ireeza mwikereke. ");
INSERT INTO sbs_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Izuva lichilila Heroda avakuya ku kumuzwisa hanze. Awo masiku aswana Pitrosi avalele hakati kamasole bovere, nasumwinwe ichaini; vaganteli habusu bya chiyazo niba mamele itolongo. ");
INSERT INTO sbs_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Muvone, Iñiloyi lya Simwine inakozana chillya libonahalisa, linu mu moni chiwa munika mwizuvo yetolongo. chilya vakula Pitrosi he mbali niku muvusa,”'buke chakulitahanela' Imi ichaini chizawa kumayaza akwe. ");
INSERT INTO sbs_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Iñiloyi chilyawamba kwali nichinilyati, lizwatike zizwato, Imi zwate nimakatulo” Pitrosi cha chita vulyo. Iñiloyi chi lyati kwali, zwate zizwato za hanze unichilile ");
INSERT INTO sbs_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Linu Pitrosi niche chilila Iñoliyi ni kuzwa haze, kana abezi kuti zipangahala zakusakusima zilipanga Iñiloyi, Abakutele uvwene ipono, ");
INSERT INTO sbs_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Hava hitilila mugateli we intazi ni wa buveli, Nichibakeza kumulyango wesipi ubakuya mwitolopo; nichi we yaluka uwo wine. nichi bazwa haze nikuya mu mungwangwa, Iñiloyi nichi lyamusiya haho. ");
INSERT INTO sbs_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Linu Pitrosi chinga volelwa mano, chawamba kuti,” hanu chabusakusima chine ziva Simwine aba tumini Iñoloyi lyakwe ni kwiza kuni sumununa mu mayaza a Heroda, mane nizintu ziva va livelele vantu va majuda. ");
INSERT INTO sbs_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","“Hamana kuzeza izii, Nicha yenda kuzubo ya Maria inyina wa Joani izina livesi ba vali njiva Mareka; vangi vazumina baba kungene momo nivakwete kurapera. ");
INSERT INTO sbs_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Chinga ngongota ha mulyango werapa, muhikana wamukazana wezina lya Roda hakeza kukwi tava. ");
INSERT INTO sbs_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Halemuha kuti izwi njilya Pitrosi, kuzwililila kuku sanga chakangwa kwiyalula mulyango; kuhita, nicha tilila muzubo; nicha kava wambila kuti Pitrosi uzimene hamulyango; ");
INSERT INTO sbs_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Linu nichi vanta kwali,' umbulumuka,” Nicha tundamena kuti njimona bovulyo. Nichi vata kwali, “Iñiloloyi lyakwe.” ");
INSERT INTO sbs_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Linu Pitrosi nicha zwila havunsu niku ngongota, chinga veyalula mulyango, Nichi vamubona niku komokwa, ");
INSERT INTO sbs_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pitrosi nicha vatondeza kama yaza kuti vantotole. Linu nicha vawambila Simwine mwava muzwisikizi mwitolongo. Ni chati, “mukawambile inzi zintu Jakovo niva mwakwe,” kuzwaho nicha vasiya nikuya kuchimwi chivaka. ");
INSERT INTO sbs_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Linu chinga lyazwa izuva. Nichi kwava nikulyangana kungi mukati kamasole, kuamana nichi vapangahali kwa Pitrosi. ");
INSERT INTO sbs_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Kumasule Heroda chinga mungana linu kana aba muwani, NIchavuza ba ngatela nikuha itaelo kuti vehayiwe. Kuzwa aho ni chazwa mwa Judea nikuya mwa Sesarea niku ke kala mwateni. ");
INSERT INTO sbs_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Linu Heroda nicha vengela vantu va Tire ni Sidoni. Nichi vayenda hamwina kwali. Nichi vaka wola Blasto mutusi wa Simwine, mukuti avatuse. Kuzwaho nichiva kumbila ikozo, Mukuti ikanda yavo ivatambuli zilyo zayo zizwa kwa simwine weyo ikanda. ");
INSERT INTO sbs_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Mwizuva livatomwa Heroda nicha zwata zizwato zakwe zavu simwine nikwikala hachihuna chavu Simwine; Nicha wamba kuvali. ");
INSERT INTO sbs_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","LInu batu chiva ngalumuka, “nikuta kuti ilzwi lya muzimu, isinyi lya muntu;” ");
INSERT INTO sbs_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Pona hahaho Iñiloyi lya Simwine chilya mukava, Mukuti kana avahi Ireeza ikanya; Nicha liwa masene niku nfwa. ");
INSERT INTO sbs_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Imi izwii lye Ireeza chilya kula ni njihekana. ");
INSERT INTO sbs_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Linu Barnabasi ni Saule chinga vamana musevesi mwa Jerusalema, nichi vabolela haho, nivahinda Joani, Izina livesi va vali njiva Mareka. ");
INSERT INTO sbs_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Linu mwi kereke ya Antiyoke, kuvena vaporofita ni maruti. Vavali Barnabasi, Simiyoni (Niga), Lusiyasi wa kwa Sirene ni Manaeni (yavali mulikani wa kuvu hwile wa Heroda we tetarachi) ni Saule. ");
INSERT INTO sbs_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Havavali kukwete ku zimba niku lumbeka Simwine nikuli nyima zilyo, Luho Lujolola chi lwawamba kuti, “Munivikile kumbali Barnabasi ni Saule, vapange musevezi univa vasumpili”. ");
INSERT INTO sbs_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Havamane ku linyima zilyo ni kulapela, chiva vavika mayanza avo hava vakwame, niva va tuma. ");
INSERT INTO sbs_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Mi Barnabasi ni Saule vavali kuteki Luhuho Lujolola chiba yenda kusezumuka kwa Silusiya; kuzwaho chi vayenda cha chisepe mu chiwoli cha Sipurasi. ");
INSERT INTO sbs_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Hava vena mwi toropo ya Salamisi, chiva kutaza linzwi lya Simwine mu masinagoge a Majuda. Vavena ni Joani Mareka avali mutusi wavo. ");
INSERT INTO sbs_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Linu hava valiku yenda muchiwoli choonse cha Pafosi, chi vawana mukwame wa mavivo, muporofita wa mapa wa Mujuda; izina lyakwe avali nji Bar- Jesu. ");
INSERT INTO sbs_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Uzu iñanga yavali kwina chizwale kumuyendisi wa chikiliti Sergiusi Paulusi, mukwame yavali kutalifite. Cha ngongota Barnbasi ni Saule, kakuti avali kusaka kuzuwa inzwi lye Ireeza. ");
INSERT INTO sbs_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Kono Elimasi, “wa mavivo” (bulyo inzina lyakwe mulivali kutolokelwa) chalika kuvakanisa, chalika ku kuzwisa muyendisi mwi ntumelo. ");
INSERT INTO sbs_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Kono Saule yavali kusumpwi Paulusi, yave zwile Luho Lujolola, chamu lola kakumu luvukila. ");
INSERT INTO sbs_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ni chati, “Iwe mwana wa muswisu wa Javulusi, wizwile vuchengi ni muhupulo muvi. U chila chenzila zonse za kuruka. Kete nosiye kutenzeka inzila ziwolokete za Simwine, ko siye? ");
INSERT INTO sbs_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Hanu ulole, iyanza lya Simwine lina hewulu lyako, mi move u chivofu. Kente uvone izuva mwi nakozana”. Hahobulyo cha wilwa kavundu ni kafifi; chakala kuzimbuluka ni kukumpila vantu kuti bamukwate kwiyanza. ");
INSERT INTO sbs_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Linu muyendisi havona bulyo ku chiva tendahali, cha zumina, kakuti ava komokiswa ka mulutilo kaza Simwine. ");
INSERT INTO sbs_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Haho Paulusi ni va valikani vakwe chiva lilonga niku zuha kuzwa mwa Pafosi ni kwiza mwa Perga yamwa Pamfilia. Kono Joani cha vasiya ni kuvola kwa Jerusalema. ");
INSERT INTO sbs_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Paulusi ni valikani chivayenda kwa Perga ni kwiza kwa Antiyoke ya Pisidia. Umo chi vayenda mu masinagoge mwizuva lye Nsavata ni kwi kala hansi. ");
INSERT INTO sbs_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ha kumanwa kuvala za mulawo ni vaporofita, mi vayendi va ma masinagoge chiva tumina iñusa libalikuti, “Mizwale, chikwina liñusa lya kulisusuweza kuamana ni vantu vena hanu, mui wamba.” ");
INSERT INTO sbs_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Mi Paulusi cha zimana ni kunyanganisa iyanza; ni kuti, “Bakwame va Isiraele ni nwe mutompa Ireeza, mutekeleze. ");
INSERT INTO sbs_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ireeza wa vaantu va Isiraele avaketi waveshetu ventanzi mi ava pangi chisi chivekali mwi nkanda ya Egapita, mi cheyanza lyakwe lina mata avava zwisi mwateni. ");
INSERT INTO sbs_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ka zilimo za makumi one nakwate inkulo yakwe chabo mwihalaupa. ");
INSERT INTO sbs_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kuzwaaho ne haya mishobo ivali kukwana iyanza ni yobele mwinkanda ya Kanana, chaha vaantu vetu inkanda yavo kuti ive chiyolo. ");
INSERT INTO sbs_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Zonse zintu ziva pangahali mu zilimo zina myanda yone ni zilimo zichita makumi eyanza. Hakumana zonse izo zintu, Ireeza na vaha vaatuli mane kusika muporofita Samwele. ");
INSERT INTO sbs_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Linu vaantu chi vavuza Simwine, mi Ireeza na vaha Saule mwana wa Kishi, mukwame yavali kuzwa mulusika lwa Benjamine; kuva simwine ka zilimo za makumi one. ");
INSERT INTO sbs_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kuzwa aho Ireeza na muzwisa havu simwine, Na zimika Davida kuti ave simwine wavo. Avali nji Davida wava wambi Ireeza, 'Na wana Davida mwana wa Jese, ave mukwame wina kwinkulo yangu, u tenda zonse zini suni kuti azitende.' ");
INSERT INTO sbs_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kuzwa mulusika lozu mukwame Ireeza na letela Isilaele muhazi, Jesu, sina kamwa vasepisize ku tenda. ");
INSERT INTO sbs_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ichi chivakali kutendahala lili, pili Jesu na seni kusika, Joani sapili avezivahazi ze nkolovezo ya kuvaka ku vantu vonse va Isiraele. ");
INSERT INTO sbs_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Aho Joani avali kumaniniza mutendo wakwe, chata kuti, 'Uzeza kuti njeme ini? Kanjime uzo. Kono mutekeleze, uzo yokezite mumasule angu, makatulo aku matende akwe kani swaneli ku a sumununa.” ");
INSERT INTO sbs_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Vamwangu, vaana vazwa muluzuvo lwa Abrahama, navo mukati kenu valapela Ireeza, nji kwetu uwu mulaezo we mpuluso ku uvatuminwa. ");
INSERT INTO sbs_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Linu avo vahala mwa Jerusalema, niva yendisi vavo, kena vava mulemuhi, mi nive zuzilikiza zivali kuwambiwa kuva porofita kakuti zi valiwa i Nsabata ni NSabata zivali za kumunyasa. ");
INSERT INTO sbs_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Nihakuba vulyo kena vava wani ivaka ilotu liyelele ifu lyakwe, niva kumbila Pilato kuti amwihaya. ");
INSERT INTO sbs_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Havamana ku tenda zintu zonse zi ñoletwe zi amana naye, chiba mususa kwi samu, ni ku mulalika mwi vita. ");
INSERT INTO sbs_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Kono Ireeza na muvusa ku vafwile. ");
INSERT INTO sbs_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ava vonahali kamazuva mangi ku vonse vavali kwiza naye kuzwa kwa Galileya kuya kwa Jerusalema. Avo vaantu nahanu vavavi impaki zakwe ku vaantu. ");
INSERT INTO sbs_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Linu tuka miletete mulayezo mulotu we nsepiso iva tendahali kuva zazi ventazi. ");
INSERT INTO sbs_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ireeza ave zuzilizi insepiso kwetu, vana vavo, mukuti vulyo ava avavusi Jesu kumuvoza kuvuhala. Sina haku ñoletwe mwa Lisamu wa vu veli: 'U mwanangu, sunu nava njime veso. ");
INSERT INTO sbs_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Hape cha vuniti bwakuti avamuvusi ku bafwile ili kuti muvili wakwe kanzi uvoli, cha wamba buti: “Kani kuhe kujolola ni mboyoti zeniti za Davida.' ");
INSERT INTO sbs_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Izi njizi vawambiwa muzumwi Lisamu, 'Kente uzuminine vako va jolola kuvola.' ");
INSERT INTO sbs_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Kuzwa aho Davida hava ni lusika lwakwe ava valekeli intakazo ya Ireeza, cha lala mi na lalikiwa ni vesi, mi ava voni kuvoli, ");
INSERT INTO sbs_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","kono uzo Ireeza ya vuse kente na vone kuvola. ");
INSERT INTO sbs_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Linu musiye izizintu zi zivahale kwenu, vakwangu, mozu mukwame ku kwizibaheze kwenu kuwondelwa kwe zivi. ");
INSERT INTO sbs_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kakwe yense yozumina kwali mwalukululwe muzintu zonse za milawo ya Mushe usena uvali kulukulula. ");
INSERT INTO sbs_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Imi haho mutokomele kuti zintu maporofita zi vavali kuwamba kanzi zitendahali kwenu: ");
INSERT INTO sbs_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","'Muvone, inwe vanyazeleza, mu mukomokwe mane musinyehe; Kakuti ni tenda mutendo mu mazuva anu, mutendo usete ni muzumine, ni haike muntu niha wiziva haza kwenu.” ");
INSERT INTO sbs_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Imi Paulusi ni Barnabasi havakatuka, vaantu chi vava kumbila ahulu kuti ni vawole kuwamba izo ziwambo ziswana mwi Nsabata ikeza. ");
INSERT INTO sbs_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Linu mukopano mu masigoge hau mana, vungi bwa maJuda ni ma Sandika chive chilila Paulusi ni Barnabasi, vava wambi kubali ni kuva susuweza kuti bazwile habusi ni chisemo che Ireeza. ");
INSERT INTO sbs_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Kulye Nsabata lichilila, ha haho itoropo yonse ivakopani hamwina kwiza kuzuwa inzwi lya Simwine. ");
INSERT INTO sbs_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Mi maJuda havavona chisi, chive njililwa muuna ni kuwamba zivilala kwineku lya Paulusi ni kumutuka. ");
INSERT INTO sbs_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Kono Paulusi ni Barnabasi chi wamba ni basatiyi, “Kuwoleka kuti inzwi lye Ireeze liwambwe sapili kwenu. Kulolelela mumu liñahikila kule nanwe ni kulihinda inwe muvene kuti kamuswaneli vuhalo bwakuya kwile, muvone katu vole kuva kuhanze. ");
INSERT INTO sbs_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Linu Simwine avatu leyeli, kakuta kuti, 'Ni vamiviki umo sina kaliseli ku va hanze, kuti mulete impuluso ku zibaka zonse cha hansi.”' ");
INSERT INTO sbs_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Mi bakuhanze hava zuwabulyo, chi vasanga ni kutanga kutemba inzwi lya Simwine. Sina vungi havava ketelwe kuvuhalo vusa mani chiba zumina. ");
INSERT INTO sbs_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Inzwi lye Ireeza chilya hasana mu chisi chonse ");
INSERT INTO sbs_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Kono maJuda chiva susuweza vanakazi ba tompeha ni kukola, mane vulyo ni vakwame vayendisa itoropo. Izo chizi wekeza ku nyandisa Paulusi ni Barnabasi ni vasohela hanze kule kwenyinza ye toropo. ");
INSERT INTO sbs_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Kono Paulusi ni Barnabasi chiba ba kukumwini isuko kumatende avo kuvali. Linu chi vayenda kwi toropo ya Ikone. ");
INSERT INTO sbs_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Mi barutwana vavali kwizwile kusanga ni cha Luho Lujolola. ");
INSERT INTO sbs_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Chikwasika inako mwa Ikone, Paulusi ni Barnabasi chivenjila hamwina muma Sinagoge a Majuda, vava wambi mumukwa uchita kuti ma Juda ni Magerike vangi vava zumini. ");
INSERT INTO sbs_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Kono ma Juda vasena vavali kukuteka, chiva lyanganisa mihupulo ya va chisi niku letisa kuti vavengele va mwavo. ");
INSERT INTO sbs_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Linu chivekala mo mazuva mangi, Nivawamba cha kukola cha ziho za Simwine, mi chaha vushupi cha linzwi lya chisemo. Mi chachita ichi cha kuzuminina zimakaza ni zikomokisa kuti zichitwe cha mayanza a Paulusi ni Barnabasi. ");
INSERT INTO sbs_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kono vungi bwa vantu vamwi toropo vava kauhene hakati: vamwi vantu vavali kuzima kuma ma Juda mi vamwi kuva Apositola. ");
INSERT INTO sbs_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Mi vonse vasikunze ni ma Juda havavali kulika ku susuweza mihupulo yava yendisi vavo kuti va nyandise niku govola Paulusi ni Barnabasi, ");
INSERT INTO sbs_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Chiva lemuha mi chivatilila kumi leneñi ya Laikoniya, Lisitira ni Derbe, ni zikiliti zi zimbulukite, ");
INSERT INTO sbs_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","mi uko vavali kuka luta linzwi. ");
INSERT INTO sbs_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Kwa Listra zuwi mukwame ave kele, kana avali kwina ziho kumatende akwe, avena vuyanga kuzwila mwi vumu liva nyina, asena ava yendi. ");
INSERT INTO sbs_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Uzu mukwame cha zuwa Paulusi na wamba. Paulusi avamulolelele ahulu mi chavona kuti wina itumelo yaku hozwa, ");
INSERT INTO sbs_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Linu chawamba kwali che nzwi ikando, “Zimane chamatende ako.” Mi mukwame cha lotoka mwi wulu niku zimbuluka. ");
INSERT INTO sbs_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Mi chisi hachi vona chava tendi Paulusi, chivanyemuna manzwi avo, chiva wamba muchi Laukosiya, “Vazimu vakeza hansi kwetu muchizimo chavantu.” ");
INSERT INTO sbs_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Chiva sumpa Banabasi “Zeyuisi” ni Paulusi “Hemesi” kakuti ivali nji muwambi. ");
INSERT INTO sbs_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Mu Prisita va Zeyusi, we tempele ivena kunze kwe tolopo, chaka leta mapulu ni zingalangala ze mpalisa kumulyango. Iye ni chisi vavali kusaka kuha zitavelo. ");
INSERT INTO sbs_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Linu va apositola, Barnabasi ni Paulusi, havazi zuwa, chivahalula zizwato zavo mi haho vulyo chiva ya mu chisi, nivakavulila cha kuhuwa, ");
INSERT INTO sbs_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","mi nivawamba, “Vakwame chinzi hamuchita izi zintu? Naswe tuvantu sina njenwe ni maikuto aswana ni enu. Twaka mi letela makande malotu, akuta kuti muzwe kwezi zintu zisena intuso muvole kwe Ireza yo hala, ya va vumbi iwulu, inkanda, ni mawate mane ni zonse zina mwateni. ");
INSERT INTO sbs_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Mwinako zakale avazuminine inkanda zonse kuyenda mwi nzila zavo. ");
INSERT INTO sbs_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Mi nihakuva vulyo, kana avali siyi nikusena vushupi, mwezo avachiti vulotu mi avamihi invula kuzwa kwi wulu niku mi ha inako indotu, kwizuza inkulo zenu cha zilyo ni kusanga. ");
INSERT INTO sbs_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Mane ni cha a manzi Paulusi ni Barnabasi vava woli ku kanisa chisi kuva chitila chitavelo haluzala. ");
INSERT INTO sbs_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Kono ma Juda vavali kuzwa kwa Antioki ni Ikone chivakeza ni kwiza ku susuweza chisi. Vava govoli Paulusi cha mabwe ni kumu kwitila kunze kwe tolopo, cha kuhupula kuti avafwi. ");
INSERT INTO sbs_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Mi va varutwana havavali kuzimene niva muzimbulukite, cha zimana nikwinjila mwi tolopo. Izuva lichilila, chaya kwa Derbe ni Barnabasi. ");
INSERT INTO sbs_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Havamana ku ruta linzwi mwi toropo ni kutenda varutwana vangi, chivavola kwa Lisitira chikuya kwa Ikone. Mi chikuya kwa Antioki. ");
INSERT INTO sbs_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Vava kwete kukoza luhuho lwava zumini ni ku vasusuweza kuzwila havusu mwi tumelo, niva wamba kuti, “Tuswanela kwinjila mwi puso ye Ireza cha manyando mangi.” ");
INSERT INTO sbs_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Hamana kuva ketala vakulwana mwi inkeleke sonze, mi vava lapeli cha kulinyima zilyo, chivava vika muma yanza asimwine uvava zumini kwali. ");
INSERT INTO sbs_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Chiva hita inzila ya Pisidiya kwiza kwa Pampiliya. ");
INSERT INTO sbs_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Hava mana kuwamba linzwi mwa Perga, chiva sezumuka kuya kwa Atilia. ");
INSERT INTO sbs_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Chiva yenda kwa Antioki cha chisepe, kuvavali kususuwezwe ku chisemo che ireza cha musevezi uvava kuzwa kuku mana. ");
INSERT INTO sbs_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Hava kasika mwa Antioki ni ku kopanya inkereke hamwina. Chiva kaviha zintu sonse Ireza zava veleki chavo, ni mwaveyalwiri Ireza mulyango we intumelo kuva sihanze. ");
INSERT INTO sbs_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Chivekala inako inde ni va lutwana. ");
INSERT INTO sbs_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Vamwi vakwame va vali ku zwa mwa Judea ni kuluta vakwavo, chivati, “Kuandakuti upangwe mupato kuzwa ku mulao wa Mushe, ko woli ku hazwa.” ");
INSERT INTO sbs_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Linu Paulusi ni Banabasi ha veza ku va kalimela ni kuli kananisa navo, Vakwavo chi va zumizana kuti Paulusi, Banabasi ni vamwi va yende kwa Jerusalema ku va apositola ni va kulwana che iyi impuzo. ");
INSERT INTO sbs_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ni hakwinavulyo, cha ku tumwa ni inkeleke, chiva hita mwa Phoenicia ni Samaria ni kwi zivisa che iyi indava ya chisi chingi. Chi valeta ku sanga ku vonse vamwavo. ");
INSERT INTO sbs_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Linu ha vakeza mwa Jerusalema, va va tambulwa ni inkeleke ni va apositola ni vakulwana, mi chiva viha zintu zonse Ireeza chiti navo. ");
INSERT INTO sbs_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Kono vakwame vamwi va va zumini, va vali va chikwata cha Mafarisi, chi vazima ni kuti, “Kulukele kuti va chitwe mupato ni ku va laela ku mamela mulao wa Mushe. ");
INSERT INTO sbs_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","“Linu va apositola ni va kulwana chi va kungana ha mwina ku zuminzana he iyi indava. ");
INSERT INTO sbs_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Hakumana wambisana kungi, Pitolosi cha zimana ni ku wamba kuvali, “Vakwetu, mwizi kuti Ireeza ava liketeli mukati kenu, kuti cha mulomo wangu Vasikunze va zuwe linzwi lya makande malotu, ni ku zumina. ");
INSERT INTO sbs_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ireeza, wizi inkulo, upaka ku vali, cha ku vaha Luhuho Lujolola, si na mwa vachitili kwetu; ");
INSERT INTO sbs_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","mi kana ava chiti ku chi nchana mukati ketu navo, ku panga inkulo za vo ku jolola che intumelo. ");
INSERT INTO sbs_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Hanu ni ha kwina vulyo chi nzi hamulika Ireeza, kuti muvike ijokwe he nsingo za valutwani liti nanga veshetu kapa iswe kena tuvali woli kuli kulika? ");
INSERT INTO sbs_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Kono tuzumina kuti katu hazwe ku zwillila ku chisemo cha Simwine Jesu, sina mu va vekalile.” ");
INSERT INTO sbs_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Chisi chose chi chatontola ni va tekeleze kwa Banabasi ni Paulusi kuviha zisupo ni zi komokisa Ireeza za vapangi mukati ka Vasikunze ku zwilila ku vali. ");
INSERT INTO sbs_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ha va siya ku wamba, Jakovo chetava, chati, “Vakwetu mutekeleze kwangu. ");
INSERT INTO sbs_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simoni ava wambi umo Ireeza ku matangisizo mwava heli musa ku tusa Vasikunze cha ku hinda vantu mukati kavo che zina lyakwe. ");
INSERT INTO sbs_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Mi manzwi ava apositola chi a zuminzana nezi, sina mukuñolelwe, ");
INSERT INTO sbs_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Chikwa mana izi zintu ka nivole, Mi kanizake itente lya Davida hape, li va wili hansi; Ka ni li zimike ni ku vozekeza ku shinyeha kwa lyo hape, ");
INSERT INTO sbs_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","cho kuti vantu vasikeza va zimene va sake Simwine, ku kopanya vulyo ni Vasikunze vonse va sumpitwe che zina lyangu.' ");
INSERT INTO sbs_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ichi cha wamba Simwine chiti, ya va pangi zintu zonse zive zi vahele ku zwa kwi nako zakale. ");
INSERT INTO sbs_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Niha ku va vulyo, mu nahano wangu kanzi tukatazi Vasikunze vola kwe Ireeza; ");
INSERT INTO sbs_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","kono cha ku va ñolela kuti vazwe ku ku lisinya ni zibumbantu za manza, kuzwa ku vusangu, ni zonse zisinitwe, ni ku zamalaha. ");
INSERT INTO sbs_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ku zwa kwisika lya kwa kale kwina vantu mwi tolopo ni tolopo va kwete ku kutaza ni ku vala Mushe mu masinagoge lwe Sabata ni Sabata.” ");
INSERT INTO sbs_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Linu chi kwa voneka vulotu ku va apositola ni vakulwana, ni inkeleke yonse, ku keta Judasi yo sumpwa Basabasi ni Silasi, va vali va kulwana ve inkeleke, mi ni kuva tuimina kwa Antioch ni Paulusi ni Banabasi. ");
INSERT INTO sbs_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Chiva ñola izi. “Va apositola, va kulwana ni vakwetu, ku Vasikunze vakwetu mwa Antioke, ni Siria ni Silisia, intumeliso. ");
INSERT INTO sbs_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tu va zuwi kuti vamwi va kwame va tu sana tuvahi mulao, va vazwi kwetu ni ku mi kataza ni intuto zi kataza ihuho zenu. ");
INSERT INTO sbs_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Linu chi kwa woneka vulotu kwetu tu vonse ku keta va kwame ni ku va tumina vasakiwa kwetu Banabasi ni Paulusi, ");
INSERT INTO sbs_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","vantu va va viki vuhalo bwavo muvukavo che zina lya Simwine Jesu Kirisite wetu. ");
INSERT INTO sbs_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Tu va tumini ni ha ku vavulyo Judasi ni Silasi, vese va mi wambile navo zintu ziswana. ");
INSERT INTO sbs_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Mi ni kwavoneki sinte ku Luhuho Lujolola ni kwetu, ku sa vika hewulu lyenu muzio mukando, kwanda zintu zi na intuso: ");
INSERT INTO sbs_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","kuti musiye zintu za zi tavelo za zivumbantu za manza, malaha, zintu zi dinkitwe, mi ni za vusangu. Haiva ni mulizwisa mwezi muvene, mu ku shiame kwenu. Kulaeza.” ");
INSERT INTO sbs_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Linu he, ha chi va lukululwa ni ku sezumukela mwa Antioke; ha vamana ku kunganya china vungi hamwina, ni vatambika iñolo. ");
INSERT INTO sbs_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Linu ha va livala, chi vasanga che ivaka lye nsusuwezo. ");
INSERT INTO sbs_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judasi ni Silasi, mane ni vapolofita, ni va susuweza vana kwavo ni manzwi mangi ni ku va koza. ");
INSERT INTO sbs_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ha va mana kwi kala inako zana aho, va vatuminwa mu inkozo ku vakwavo va va vatumite. ");
INSERT INTO sbs_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Kono ku vavoneki ku va hande kwa Silasi ku shala mwateni. ");
INSERT INTO sbs_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Kono Paulusi ni Banabasi ni vekala mwa Antioke hamwina ni vungi bwa vamwi, umo ni valuti ni ku kutaza linzwi lya Simwine. ");
INSERT INTO sbs_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ha ku hita mazuva Paulusi nati kwa Banabasi. “Tuvole hanu mi tukapotele bakwetu mwi tolopo ni tolopo mutu va ku wambite linzwi lya Simwine, mi tuvone kuti vena vule. ");
INSERT INTO sbs_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabasi avali ku sunite ku yenda ni Joani ya vali ku sumpwa Mareka. ");
INSERT INTO sbs_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Kono Paulusi cha zeza kuti ka kwina hande ku hinda Mareka ya vaka vasiyi mwa Pamfilia mi kena ava zwili havusu navo mu musevezi. ");
INSERT INTO sbs_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Linu chikwa vuka ku sa zuminzana kukando, mi kuti mane chi va kauhana hakati, mi Banabasi cha hinda Mareka ni ku zuha naye ku ya kwa Sipera. ");
INSERT INTO sbs_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Kono Paulusi cha keta Silasi ni ku yenda, ha mana ku mu muhewa ni vakwakwe cha musa wa Simwine. ");
INSERT INTO sbs_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Mi ava yendi ku hita mwa Siria ni Silisia na ka vu koza makeleke. ");
INSERT INTO sbs_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulusi hape ni cheza kwa Derba ni Listra; mi mulole, mulutwana zumwi yo sumpwa Timotea kwabena, mwana wa muswisu wa Mujuda wa mwanakazi ya bazumine; beesi ba bali Magerike. ");
INSERT INTO sbs_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","A ba kuwambwa neenza ku bakwake ba vena kwa Lisitra ni Ikone. ");
INSERT INTO sbs_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulusi a bakusaka kuyenda naye; ni chamuhinda ni ku ku mutwala kumupato chevaka cha majuda ba vena muchibaka echo, chakuti bonse ba vezi kuti beesi ba vali Magirike. ");
INSERT INTO sbs_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","A ba vakuyenda mwinzila zabo kuya mwitolopo ba bali ku ya vuha inkeleke intayelo ye ba vakuswanela kwichilila, intaelo i bañolwa kwa baapositola ni bakulwana venkeleke mwa Jerusalema. ");
INSERT INTO sbs_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Chobulyo inkeleke i va kolete che ntumelo mi i ba li kwinjiha chenamba mwizuva. ");
INSERT INTO sbs_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paulusi ni bachikwata chakwe ba vali kuya muzikiliti za Frigia ni Galatia, chokuti ba vakaniswe cha Luhuho Lujolola kukutaza inzwi muchivaka cha Asia. Havazwa mwa Masia, babaliki ku ya kwa Bitiniya kono Luhuho lwa Jesu ni chi lwabakanisa. ");
INSERT INTO sbs_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Chakuhita kumbali ni Masia, ni chibalika ku ya kwa Betenia, kono Luhuho Lwa Jesu ni chilwavakanisa. ");
INSERT INTO sbs_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Chakuhita kumbali ya Misia, ni chiveza kwitolopo ya Troasi. ");
INSERT INTO sbs_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Impono ivavoneki kwa Paulusi masiku: mukwame wa kwa Masondonia avali kuzimene aho, namu sumpa na wamba, “Wize kunu mwa Masondoniya ni kututusa.” ");
INSERT INTO sbs_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Linu Paulusi haca bweene iyo impono, yahaho chitwa nyemuka kuyenda kwa Mesondoniya, kuzumina kuti Ireeza watusupira kuka kutaza i evangeri ku vali. ");
INSERT INTO sbs_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ni chibahinda lwendo nihakubabulyo kuzwa kwa Troasi, ni chi twakatuka kuyenda feela kwa Samotrasi, mi izuva lichilila ni chitweza kwa Neapolisi; ");
INSERT INTO sbs_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ku zwa ko ni chitwaya kwa Filipi, I bali itolopo ya Masedonia, Itolopo i vali yabutokwa mwi chilalo ni mwikoloni ya Maroma, mi tubekali mwitolopo yo mazuva mangizana. ");
INSERT INTO sbs_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Mwizuva lye Sabata ni chitwayenda hanze ya mulyango cha lwizi, ko tuvahupuli kuti kwina chivaka cha kulapelela. Ni chitwekala ni kuwamba ku banakazi ba bakezite hamwina. ");
INSERT INTO sbs_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Mwanakazi zumwi ya bakusumpwa Lidia, muuzi we pulipela kuzwila kwitolopo ya Tiatira, ya bakulapela Ireeza, ni chatekeleza kwetu. Simwine ni cheyalula inkulo yakwe kutekeleza kuzintu zi ba kuwambwa nji Paulusi. ");
INSERT INTO sbs_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Hamana kukolobezwa ni venzubo yakwe, ni cha tukumbila ni chati, “Chokuti u ba ni atuli ku ba yasepahala ku Simwine, mwize munzubo yangu, ze mwikale mwateni. Mi a ba tuhambilizi. ");
INSERT INTO sbs_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ni chi kwachitahala buti, ha tu bakuya kuchivaka cha kulapelela, mwanakazana zumwi ya vena luhuho lwa bunuhi ni cha tukatana. A ba leteli nfumwe chifumu chingi chakunuhelela za bufumu. ");
INSERT INTO sbs_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Uzu mwanakazi ne chilila Paulusi mwisule naswe na huweleza, na ti, “A ba bakwame ba hikana be Ireeza Yo Hanzi. Ba wamba kwenu inzila ye mpuluso.” ");
INSERT INTO sbs_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","A ba kuchita bulyo mu mazuba mangi. Kono Paulusi, a ba nyezwa ahulu, na chebuka mi na wamba kuluhuho, “Ni kulaela che zina lya Jesu Keriste u zwe mwali.” Mi ni lwa zwa hohwaho. ");
INSERT INTO sbs_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Kono nfumwakwe ha bona kuti insepo ya chifumu cabo chi yamana, ni bakwata Paulusi ni Silasi ni ku bakokolwela muchibaka cha ku uzikiza habusu bwa babusi. ");
INSERT INTO sbs_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ha ba baleta ku baatuli, ni ba cho, “A ba bakwame Majuda mi baleta mifilifili mingi mwi tolopo yetu. ");
INSERT INTO sbs_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Baluta zintu zi sa zumininwe kwetu kuti tu zi tambule kapa ku zi chilila u bu Maroma.” ");
INSERT INTO sbs_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Linu chisi ni cha ziimana hamwina kulwisa Paulusi ni Silasi; ba atuli ni ba ñatula zi zwato zabo ni ku laela kuti ba shupwe ni mbazi. ");
INSERT INTO sbs_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ha bamana ku balindola chamañindi mangi, ni ba va sohela mwi ntolongo ni kulaela muganteli ku ba gantela ahulu. ");
INSERT INTO sbs_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ha mana ku wana i yi intaelo, muganteli na basohela mu intolongo ya mukati ni kusumina matende a bo ha zi sindimwa. ");
INSERT INTO sbs_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Mukati ka masiku Paulusi ni Silasi ba va kulapela ni ku zimba izimbo kwa Ireeza, mi basuminwa bamwi ba va li ku batekeleze. ");
INSERT INTO sbs_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Haho ni kwa ba ni nzikinyeho i nkando, mukuti ni mitomo ye ntolongo ni ya nyanganya, mi hohwaho milyango ye ntolongo ni ye yaluka, mi mawenge a zumwi ni zumwi ni a sumunuka. ");
INSERT INTO sbs_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mulibeleli ha vuka mwi ñonzi na bona milyango ye ntolongo ni iyalukite; na hinda i sabule lya kwe mi cha ba kulihaya, kakuli cha ba kuzezete kuti basuminwa chi ba loboka. ");
INSERT INTO sbs_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Kono paulusi cha huwa chenzwi ikando, na ti; “Konji u lisasamisi, kakuti kutwina twense.” ");
INSERT INTO sbs_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Muganteli a sumpisa mamonyi mi a hwelela mukati mi, a chachalika cha kutiya, na wila habusu bwa Paulusi ni Silasi, ");
INSERT INTO sbs_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","mi na ba zwisikiza hanze mi na cho, “Batompei, chi ni swanela kuchita nje chihi kuti ni hazwe?” ");
INSERT INTO sbs_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ni bati, “Zumine mwa Simwine Jesu, mi ka u hazwe, iwe ni ve nzubo yako.” ");
INSERT INTO sbs_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ni ba wamba inzwi lya Simwine kwali, hamwina ni bonse mu inzubo. ");
INSERT INTO sbs_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","linu muganteli cha bahinda mwi inako iswana ya masiku, mi chasambisa zilabi za bo, mi iye ni bonse be nzubo yakwe ni ba kolobezwa hohwaho. ");
INSERT INTO sbs_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Na leta Paulusi ni Silasi mwi nzubo yakwe ni kubika zilyo habusu bwabo. Chasanga ahulu ni be nzubo yakwe bonse, mukuti bonse ba bazumini kwa Ireeza. ");
INSERT INTO sbs_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Linu ha ku ba musihali, muatuli a tumina iñusa ku muganteli liti, “Siye a bo bakwame bayende.” ");
INSERT INTO sbs_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Muganteli cha biha indaba kwa Paulusi, na ti, “Baatuli ba tumina inzwi kwangu kuti ni misiye muyende: linu he muzwe, mi muliyendele che nkozo.” ");
INSERT INTO sbs_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Kono paulusi ni chati kubali, “Ba batukabi he nkaza, bakwame ba sanyazitwe cha chi Roma, mi ni vatusohela mwi intolongo; mi linu hanu batuzwisa cha kuli wungula? Kamu kwikalile bulyo tota; mu basiye abo bene beze ze batuzwise.” ");
INSERT INTO sbs_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Baganteli ni ba biha aa manzwi ku ba atuli; ba atuli ba ba tiyi ha bazuwa kuti Paulusi ni Silasi Maroma. ");
INSERT INTO sbs_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Baatuli chibeza ni kubakumbila; mi ha ba bazwisa mwintolongo, chi bakumbila Paulusi ni Silasi kuzwa mwitolopo. ");
INSERT INTO sbs_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Linu paulusi ni Silasi chi bazwa mwi ntolongo mi ni baya kunzubo ya Lidia. Linu Paulusi ni Silasi ha ba bona ba mwabo ni ba ba susuweza ni kuzwa mwitolopo. ");
INSERT INTO sbs_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Linu haba hita mwi tolope ya Anfipolisi ni Apolonia, ni beeza kwi tolopo ya Tesalonoka, ku beena i sinagoge ya Majuda. ");
INSERT INTO sbs_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paulusi, ka chizo chakwe, naya kubali, mi mu mazuba o tatwe e nsabata na li kumbulusa nabo ku zwilila muma ñolo. ");
INSERT INTO sbs_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Abali kwi yalula mañolo ni ku toloka kuti kubali kwa bu tokwa kuti Kilisite a nyande ni kubuka hape kuzwa kwaa bana bafwile. Nacho, “Uzu Jesu uni wamba kwenu njeye Kilisite. ");
INSERT INTO sbs_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ba mwi Majuda baba zumini ni kuli kopanya ni Paulusi ni Silasi, mane ni Ma gelike babali tombwele kwali, bungi bwa banakazi baba hitile ni chichaba chikando. ");
INSERT INTO sbs_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Kono Majuda basana bali kuzumina, chaku yendiswa muuna, na hinda ba nakwame ba sena sinde muma uzikizo, na kunganya chicaba hamwina, mi na bika i tolopo mwi laata li lyanganisa. Ni ba ngundunganya i nzubo ya Jasoni. Babali kusaka kuleta Paulusi ni Silasi hanze ku bantu. ");
INSERT INTO sbs_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Kono haba sana baba bawani, ni ba tundanisa Jasoni ni bamwi bakwame habusu bwa ba sepahali be tolopo, kulila, “Aba bakwame ba chiba futumuna inkanda beeza kunu nabo. ");
INSERT INTO sbs_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","A baba kwame Jason baba tambuli ba tenda chaku sandukila intaelo ya Sesare, ba cho kuti kwina zumwi simwine- Jesu.” ");
INSERT INTO sbs_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Linu chichaba ni ba sepahali be tolopo haba zuwa izi zintu, baba katazehete. ");
INSERT INTO sbs_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Haba mana kuhinda intuwelo ye nsilelezo kwa Jasoni ni bamwi, ni baba lekeza kuti baliyendeze. ");
INSERT INTO sbs_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ubo busiku ba mwakwe ni ba tumina Paulusi ni Silasi kwa Beria. Haba sika kwateni, ni be njila mu masinagoge a Majuda. ");
INSERT INTO sbs_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Linu a ba bantu babali ku sepahala kuhita abo bamwa Teselonika, mukuti baba tambuli inzwi ca maano a litukiseze, ku tatuba mañolo mwi zuba kubona kapa izi zintu muzibekalile. ");
INSERT INTO sbs_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Kuzwaho bungi bwabo baba zumini, ku bika ni basusuwezi ba Ma Gelike ba bana kazi mane ni bungi bwa bakwame. ");
INSERT INTO sbs_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Kono ma Juda ba Teselonika habeziba kuti Paulusi naye abali kuwamba inzwi lye Ireeza kwa Berea, ba ba yendi ko ni kubusa musunga ni ku kataza bungi bwa bantu. ");
INSERT INTO sbs_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Linu haho bulyo, ba mwaakwe ni ba tuma Paulusi kuya kwi iwate, kono Silasi ni Timetea abo niba shala kwateni. ");
INSERT INTO sbs_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Abo baba sotweze Paulusi ni bamu twala uko kwi tolopo ya Anseni. Ha basiya Paulusi kwateni, ni ba tambula intaelo yakwe ya Silasi ni Timotea ya kwiza kwali cha kuhwela muku wolekela. ");
INSERT INTO sbs_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Linu mukuti Paulusi haba kuba lindile mwa Anseni, luuho lwakwe ni lwa katazeha mwali ha bona i tolopo i zwiile ziswaniso zi lapelwa. ");
INSERT INTO sbs_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Mi na zeza zeza mwa sinagoge ni Majuda na bo ba bali ku lumbeka Ireeza mi mane na bo ba bali ku likopanya nabo izuba ni zuba mu cibaka ca musika. ");
INSERT INTO sbs_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Kono hape bamwi ba li tutite ba Ma epikulia ni ma Sitoiki ni bali kopanya naye. Mi bamwi nibati, “Uzu yo wamba ahulu u lika ku tii nzi? Bamwi ni bati,” Uboneka kuba muluti wa milimu iseni kubonwa, “kakuti abali kuluta za Jesu ni za ku buuka. ");
INSERT INTO sbs_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ni bahinda Paulusi ni kumu leta kwa Areopagusi, ni bati, Tusaka kwi ziba uwu mulutilo seke wo wamba? ");
INSERT INTO sbs_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ka kuti u leta zintu zi seni kubonwa mu matwi etu. Linu tusaka kwiziba kuti izi zintu zi talusa nzi.” ");
INSERT INTO sbs_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Linu bonse ma Ansenia ni mabuu kwenda babali kuhala mwa teni ni be kaala ni kusena ziba tenda kwanda ku wamba ni ku tekeleza zimwi zihya.) ");
INSERT INTO sbs_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Kuzwa aho Paulusi na zimana mukati ka ma Aeropagusi mi nacho, “Inwe muba kwame ba Anseni, ni bwene kuti mwi zwile ahulu bu mulimu mwi nzila zonse. ");
INSERT INTO sbs_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Sina ha ni bali ku hitite ni ba boni zintu zi mu lumbeka, Ni ba wani kataala kena uwu miñolo, “Kwa Ireeza ya se zibenkene.” Icho linu chimu lapela mu kuseziba, ni chi mi wambila. ");
INSERT INTO sbs_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Ireeza ya ba bumbi i nkanda ni zonse zina mwateni, mukuti njeye simwine we iwulu ni hansi, ka haali mwi i tempele i ba bumbwa ni mayanza. ");
INSERT INTO sbs_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Nandi ku sebelezwa cha mayanza a muntu, mane ubu kwina cha saka, mukuti iye mwine njo ha bantu bu halo ni luhuho ni zintu zonse. ");
INSERT INTO sbs_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Mi kuzwa ku muntu yenke a ba pangi cisi cha bantu ba hala hansi, mi ni ku akaleza ku ketwa kwe nako ni museto wa zibaka mu bahala. ");
INSERT INTO sbs_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Kuzwa aho, ba lukela ku gana Ireeza mukuti pona chiba sika kwali ni ku muwana, mi luli, kena kule ni yense wa kwetu. ");
INSERT INTO sbs_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Mi mwali tuhala ni ku yenda ni kuba ni buntu bwetu, sina mu iti imwi i mpwetele yenu i ba cho, “Cho kuti naswe tu ba luzubo lwakwe. ");
INSERT INTO sbs_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Kuzwa aho, sina hatuli tu ba luzubo lwakwe, katu swaneli ku zeza kuti bulimu bu swana ni gauda, kapa chilivela, kapa mabwe, zi bezetwe ni ka bu ma pangapanga ni kuzeza kwa muntu. ");
INSERT INTO sbs_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Kuzwa ho Ireeza na shila cha menso i nako ya ku li lyanganisa, kono hanu a ba laeli bantu bonse konse konse ku baka. ");
INSERT INTO sbs_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ichi cha kuti aba bakanyi izuba lwete na atule inkanda mu kuluka ca muntu yaba keeti. I reeza aba hi bupaki bozu muntu ku yense cha ku mu busa kwabana ba fwile.” ");
INSERT INTO sbs_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Linu bantu ba Ansena ha bazuwa za ku buka kwa ba fwile, bamwi ni ba sheununa Paulusi; kono bamwi ni bati, “mutu te keeleze kwako hape kwa amana niyi indaba.” ");
INSERT INTO sbs_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Kuzwa aho, Paulusi, na ba siya. ");
INSERT INTO sbs_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Kono bamwi bantu ni ba likopanya naye ni kuzumina, mane bulyo ni Dionisuisi wa kwa Areopagite, mwanakazi ya bali ku sumpwa Damaris, mi ni bamwi ba bena na bo. ");
INSERT INTO sbs_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ha kumana izi Paulusi nazwa mwateni ni kuya kwa Atene kwa Korinte. ");
INSERT INTO sbs_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Na kawana Mujuda we zina lya Akila, ya bali ku pepiwa mwa Pento ka mushobo; Njabali kukazwa kwa Italia ni mwi habwe Pulisila, ni Kilawudiya nalayera ma Juda bonse kuti vazwe mwa Roma; Mi Paulusi ava kezi kubali. ");
INSERT INTO sbs_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Paulusi Abali kuseveza musevezi uswana navo aba kali navo. Vavali bvapangi vama tente. ");
INSERT INTO sbs_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Linu Paulusi lwe sabata ni lwe sabata abali ku yanga mu masinangonge. Avali kuhambirikiza vonse majuda ni Magerike bazumene. ");
INSERT INTO sbs_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","kono Sila ni Timotea habasika kukazwa kwa Macedonia. Paulusi avali kuyendiswe Luhuho kuwambira ma Junda kuti Jesu jiyena Keresite. ");
INSERT INTO sbs_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Aho Majunda hava mulwisa ni kumutuka, Paulusi cha zukutula chizwato chakwe ni kuwamba kuvali, “Malaha enu ave he wulu lye mitwi yenu; Kanina mulandu. kuzwa hanu muniyende ku Bamachava.” ");
INSERT INTO sbs_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Nakatuka aho naya muzumbo ya Tetius Justusi mukwame yavali ku lapela Ireeza. Inzubo yakwe yibene hafwihi ni sinagoge. ");
INSERT INTO sbs_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krisiposi, muyendisi we sinangonge ni vonse vo luhasi lwakwe mwa Simwine. Vungi bwa Makorite vava zuwi Paulusi vava zumini ni kukolovezwa. ");
INSERT INTO sbs_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Simwine na wamba kwa Paulusis masiku mu chiloto, “Kanzi utiyi, kono u wambe kanzi u ntontoli. ");
INSERT INTO sbs_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ka kuti nina nawe, mi ka kwina yete aku holofaze, kakuti nina bantu bangi mowu muleneñi.” ");
INSERT INTO sbs_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Paulusi a ba hali mwa teni chilimo ni myezi imana iyanza ni ka mwina na luta linzwi lya Ireeza mukati kabo. ");
INSERT INTO sbs_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Kono Galio haba mubusi wa Akaiya, Majuda ni ba zimana ku lwisa Paulusi ni ku muleta ha busu bwa chipula cha mu atuli; ");
INSERT INTO sbs_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Nibawamba “Uzu mukwame ukwete kushonga vantu kulapera Ireeza yasa yendereri ni mulao.” ");
INSERT INTO sbs_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Mi Paulusi si hacava kuti awambe, Galio mubusisi nawamba kumajuda nati,”inwe Majunda, haiva initi ivali indava yo mulandu kamba vuvangamwa, nikuva zuweki kumiha mulandu. ");
INSERT INTO sbs_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Kono sina inzi ipuzo ze ziyambo ni mazina ni milao yenu, muzi wambole inwe muvene. kani saki kuva muatuli wezi indava.” ");
INSERT INTO sbs_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Galio chava zwisa hanze ye chipura che inkatulo. ");
INSERT INTO sbs_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Cwale vonse ni chivakwata Sositene, muvusi we sinagoge, ni kumu kabila havusu bwe chipura che nkatulo. Kono Galio kena ava vileli chi va ba pangi. ");
INSERT INTO sbs_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pauluci cinga e kala kwateni mazubazana, cha siya vakwakwe ni kuzuhira kwa Siriya ni Purisila ni Akwila. Naseni kuyenda irizo, Senichiriya, ava ngukisi i sunki zakwe kakuti ava hindite vuitamo bye chi Nazareta. ");
INSERT INTO sbs_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Hachiva sika mwa Maefese, Paulusi cha siya Purisila ni Aquila mwateni, kono iye cha yenda mwi sinangonge ni kuka ambolisana ni Majunda. ");
INSERT INTO sbs_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Hachiva kumbire Paulusi kwi kala navo kavaka zana, chakana. ");
INSERT INTO sbs_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Kono hacha yenda kwi pumulo, ava wambira, “Kanika mi vole hape kwenu haiva itato ye Ireeza.” Linu cha zuha kuzwa kwa Maifese. ");
INSERT INTO sbs_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Paulusi haka sika he rizo lya Caseriya, chayenda ni kuka lumerisa inkereke za mwa Jerusalema mi hape cha kwa Atiyoki. ");
INSERT INTO sbs_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Hache kere inko zana kwateni, Paulusi cha katuka nayenda mukanda muzikiriti za Galatia ni Firigiya ni kususuweza varutiwa vonse. ");
INSERT INTO sbs_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Kubena mujuda ya va pepelwa mu Alexandria we zina lya Apolosi, avakezi kwa Maefese. Mi mukwame ya vali kwamba hande ni kwiziva mañolo. ");
INSERT INTO sbs_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Apolosi avali ku rutitwe mwi tuto za Simwine. Kwi ziva muluhuho, ava wambi ni kuruta hande zintu kuamana Jesu, kono avali kwizi vulyo inkolobezo ya Johani. ");
INSERT INTO sbs_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolosi chatanga kuwamba cho vundume muma sinangonge. Kono Purisila ni Aquila hava muzuwa, chivali panga chilikani naye ni kumutorokera ze zira ye Ireeza cho kumu swanelelela. ");
INSERT INTO sbs_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Linu hali takaleza kuya kwa Akiya, va na kwakwe ni va mususuweza ni ku ñolela valutiwa mwa Akaiya kuti va mu tambule. Hasika, na tusa ahulu vava zumine cha chishemo. ");
INSERT INTO sbs_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Apolosi he nkanza cha komokisa Majunda cha ziho zakwe ni vuchaziva, cha kutondeza cha mañolo kuti Jesu avali nji Keresite. ");
INSERT INTO sbs_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Kubatendahali buti kuti Apolosi nena kwa Korinte, paulusi abahiti kwiulu lyekanda mi abezi kwa Efese, mi nicheza kuwana barutwana bamwi kwateni. ");
INSERT INTO sbs_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Paulusi nichati kubali, “Mubatambuli luhuho lujolola na hamubazumini?” Chibamucho kuti, “Nee, kakwina mane ni chitubazuwi kuamana ni Luhuho Lujolola.” ");
INSERT INTO sbs_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Paulusi abati, “Linu mubakolobezwa muchinzi?” Ni chibati, “Munkolobezo ya Joani, ");
INSERT INTO sbs_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Linu Paulusi netaba, “Joani abakolobezi chenkolobezo yenswalelo. Abawambili bantu kuti bayelele kuzumina kumuntu yokeza mwisule lyakwe, kokuta kuti, nji kwa Jesu.” ");
INSERT INTO sbs_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Bantu habazuwa bulyo, nibakolobezwa mwizina lya Simwine Jesu. ");
INSERT INTO sbs_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Imi linu Paulusi habatula mayanza hewulu, Luhuho Lujolola nichilwabenjila mi nibawamba mundimi zisiyenesiyene mi nibatanikiza zikezite. ");
INSERT INTO sbs_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Kuhindilila bonse ibali bakwame babali kulikana ikumi ni bobele. ");
INSERT INTO sbs_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paulusi nenjila mwisinagoge mi nawamba chabundume munako ikwanisa myezi yotatwe. Abaetelele ziambantu ni ku kutolokla bantu kuti bazuwisise kuamana nimubuso we Ireeza. ");
INSERT INTO sbs_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Nihaike majuda kana babakuzuwisisa nikusatwaliza cibatanga ku wambi zivi ni kulyefula Kreste. Paulusi cabasiya nikuzwila habusu nibabazumini. Catanga kuwamba izuba nizuba munzubo yakulutila ya Tyrannus. ");
INSERT INTO sbs_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Abazwili habusu kuwamba zilimo zobele kuti mane nibantu bekala mwa Asia, Judea ni mwa Greek bazuwe linzwi lye Ireeza. ");
INSERT INTO sbs_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ireeza aba kupanga zimpangaliko zijolola ca mayanza a Paulusi, ");
INSERT INTO sbs_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","mane ni balwala babali kuhola, Niluhuho lubilala luba kuzwa kubali, Habahinda kataulo ni ka apron hamubili wa Paulusi. ");
INSERT INTO sbs_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Kubena Majuda baba likwina mulieto lya kuyabuyenda muzilalo kulola babahindi izina lya Jesu kulisebelisa mubasakila abobene, Baba kukabuiwamba kubantu bana bena luhuho lubilala feela; Cibawamba, “Nimilaela cha Jesu yabali kuwambiwa kwa Paulusi kuti muyende.” ");
INSERT INTO sbs_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Baba tendi izo babali bakwame batenda iyanza ni bobele bana ba mupurita mukulwana wa majuda, wezina lya Sceva. ");
INSERT INTO sbs_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Luhuho lubilala lubabetabi, “Nizi Jesu, ni Paulusi; cwale iwe njewe ni?” ");
INSERT INTO sbs_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Luhuho lubilala lubena kumuntu cilwa mukoma kumubulisa ziho cawila hanzi ni kubakaba. Cibazwa munzubo nibasazabele hamubili ni kuholofala. ");
INSERT INTO sbs_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Iyo indaba ciyezibahala kubantu bonse, nibahala mwa Judea, mwa Greek, nimwa Efese. Imi baba tiyi ahulu, mane nizina lya Simwine Jesu ciba tanga kulikuteka. ");
INSERT INTO sbs_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Imi hape, bantu bonse babazumini kubakela zive nikuzumina kuzintu zibi zibaba pangi. ");
INSERT INTO sbs_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bonse babali kupangite za mabibo cibaleta invuka zabo imi cizahisiwa mumenso abantu bonse. Haba zibala zonse, inteko yateni ibabi makumi amayanza azikiti zaziemba emba ze silivela. ");
INSERT INTO sbs_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Njikuti linzwi lye Ireeza liba ambalakani munzila ikolete. ");
INSERT INTO sbs_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Paulusi hamana musebezi wakwe mwa Efese, cahupula caluhuho lujolola kuti ahite ya Macedonia ni mwa Achaia munzila yakwe yakuya mwa Jelusalema; Cawamba, “Acinazwa munu, niswanela kukabona kwa Roma.” ");
INSERT INTO sbs_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Paulusi catuma batumiwa bakwe bobele baba mutusi, Timothy ni Erastus kwa Macedonia. Kono iye abali kusikala mwa Asia inako. ");
INSERT INTO sbs_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Mweyo inako cikwabuka cifoyoyo mwa Efese kuamana ni Nzila. ");
INSERT INTO sbs_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Demetrius yopanga isilivela ya Diana, Cikwaba ni bisinisi kubantu babeza. ");
INSERT INTO sbs_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Cakopanya babeleki bonse bamusebezi wa kubeza ni kuwamba, “Nfumwangu, wizi kuti mowunu musebezi tupanga masheleni mangi. ");
INSERT INTO sbs_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Mubwene ni kuzuwa kuti, kanji mwa Efese monke kono ni mwa Asia yonse, Paulusi caba kukuweza niku bawambila. kuti kakwina Ireeza yopangiwa ca mayanza. ");
INSERT INTO sbs_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Imi kana bukabo bwabo bonke kono niswe zintu zetu kese zisakahale kubantu, mane ni tempele ya mufumahali Diana Ireeza mukando muibule maata. Imi naye mwamaninwe bukando bwakwe mwa Asia ni mwinkanda yonse.” ");
INSERT INTO sbs_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Habazuwa bulyo, bababengi ni kulila, Cibawamba, “Bukando bwina ha Diana yozwa mwa Efese.” ");
INSERT INTO sbs_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Muleneñi onse babalyangani, cibahwei kucibaka cazizanino. Paulusi ni basindikizi bakwe mumusipili wabo, Gaius ni Aristarchus bazwa kwa Macedonia. ");
INSERT INTO sbs_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulusi abali kusaka kwinjila mukati kenyangela kono batumiwa baba musilelezi. ");
INSERT INTO sbs_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Bonse batompeha ba cilalo ca Asia balikani bakwe cibamutumina liñusa kumukumbila kuti sanzi enjili mucibaka ca zizanino. ");
INSERT INTO sbs_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Bamwi bantu baba kuhuwana cintu conke, mane inyangela ciba lyangene, Bungi bwabo kana baba kwizi kuti cinzi habakeza bonse bonse. ");
INSERT INTO sbs_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Majuda cibaleta Alexander habusu bwe nyangela. Alexander abali kulila mumayanza kutolokela inyangela. ");
INSERT INTO sbs_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","kono habeza kulemuha kuti Mujuda, bonse cibalila ca linzwi nyonke inhola zobele, “Bukando nji bwa Diana yozwa mwa Efese.” ");
INSERT INTO sbs_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Muñoli we tolopo hawamba ni nyangela, Cawamba, “Inwe bantu ba Efese, njeni yasezi kuti muleneñi wa Efese mwasebeleza mukando Diana ni ciswaniso cibawili hansi kuzwa kwiwulu? ");
INSERT INTO sbs_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Hamubona izi zintu zipangahala, muswanela kutontola niku sahwelela zintu. ");
INSERT INTO sbs_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Bantu bamwaleta kumulawo kana basa bamwi tempele kapa kuwamba zibi kuamana ni Ireeza wetu. ");
INSERT INTO sbs_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Heba, Demetriusi ni mubeleki yobeza kabazuwani, mulao kuwina wiyalukite. Mubasiye bazekisane. ");
INSERT INTO sbs_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Kono heba kwina zimwi zilukela kuambolwa, muzilukiswe hande comulao. ");
INSERT INTO sbs_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","kakuti kwina inkozi kuamana nindaba za pangahala sunu, kakwina intatululo iwambiwe kuamana nei indaba, kese tuwole kuitatulusa.” ");
INSERT INTO sbs_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Hamana kuwamba izo calukulula bantu. ");
INSERT INTO sbs_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Kunyungana ha ku mana, Paulusi cha tuma batumiwa vakwe ni ku va susuweza. Mi cha balaeza ni kuba siya kuya kwa Macadonia. ");
INSERT INTO sbs_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Linu hacha yendete chahita mukati ke zilalo ni ku susuweza bazumine ahulu, mi chayenda kwa Greece. ");
INSERT INTO sbs_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ha mana kwi kala mwezi yo tatwe, Majuda chiba hinda mulelo he wulu lyakwe kakuti chaba kuyenda kwa Syria, cha zeza kuti a bole ya mukati ka Macedonia. ");
INSERT INTO sbs_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Baba musindikizi kuya hesi kwa Asia nji Sopater mwana wa muswiswi wa Pyrrhus yo zwa kwa Berea; Aristarchus ni Secundus bose bazumine ba kwa Thessolonica; Gaisus wakwa Berbe; Timothy; Tychicus ni Trophimus ba kwa Asia. ");
INSERT INTO sbs_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Kono aba bakwame baba kali kuyenda kwentu mi baba katulindili kwa Troas. ");
INSERT INTO sbs_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Chitwa zuha kuzwa kwa Philippi haku mana mazuba a chikwa chisena mulungo, mi mumazuba atende iyaza chi twaka sika kubali kwa Troas. Uko chi twa kekala mazuba atenda iyaza ni obele. ");
INSERT INTO sbs_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ke zuba lya makalo mwisunda, ha tuba kungene tubose kuti tu nkomona cikwa, Paulusi cha wamba ku bazumine. Chaba ku lela ku katuka izuba lichilila, aba zwili habusa niku wamba hesi hakati kamasiku. ");
INSERT INTO sbs_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Kubema malambi mangi muzubo ya kwiwulu atuba kezi nawo. ");
INSERT INTO sbs_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Hehahulo kuba kwi kele mulobwana wezina lya Eutychus, yachaba lele iñozi. Sina Paulusi haba wambi inakonde, uzo mulobwana, aba kuchilele, chawa hasi kuzwa habulilo bobutatu mi chiba mutola na fwile. ");
INSERT INTO sbs_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Mihe Paulusi cha suka hasi, cha liwotwelela hali, ni kuzabalana naye. Linu cha wamba,”Kanzi mukomokwa, uchi hala”. ");
INSERT INTO sbs_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Linu chayenda kwiwulu hape ni kukagamona chinkwa ni kulya. Hamana kuwamba nabo inako kutwala chitengu, cha yenda. ");
INSERT INTO sbs_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Chibakaboza muswiswi nahala mi babalizuwi neza. ");
INSERT INTO sbs_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Iswe tubene tubayendi habusu bwa Paulusi ni Chikepe kakuzuha kuya kwa Assos, kutuba kaleleli kukahinda Paulusi. Iye mwabalikusakila bobulyo, kakuti abakulelete kuyenda yahasi. ");
INSERT INTO sbs_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Linu hakatuwana kwa Assos, chitwa mulonga muchikepe ni ku yenda kwa Mitylene. ");
INSERT INTO sbs_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Linu chitwa kazuha kwateni ni kukasika izuba lichilila chibabambene ni chida cha Chios. Izuba lichilila chitwa kakwata chida cha Samos, lichilila izuba chitweza mumuleneñi wa Miletus. ");
INSERT INTO sbs_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Kakuti Paulusi iyemwine chabakuzezete kuzuha kuhitilila Ephesus, kuti kazi akahindi inako mwa Asia; kakuti abakuhwelele kukaba kwa Jerusalema izuba lye Pentakota, heba kuti ni kuwoleka kuti atende bulyo. ");
INSERT INTO sbs_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Kwa Miletus natumina bakwame kwa Efese ni kusupila kwakwe bakulwana bekeleke. ");
INSERT INTO sbs_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Habakeza kwali, chawamba kubali, “inwe mubene mwizi, kuzwa izuba lyamakalo kukulyata itende lyangu mwa Asia, inako iniba hindi ninina nenwa. ");
INSERT INTO sbs_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Niba zwili habusu ninisebeleza Simwine mubufokoli bwaboko ni zisozi, ni mumasukuluko aba tendahali kwangu bakeñi chakulelwa kwa Majuda. ");
INSERT INTO sbs_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mwizi kuti kananibaboleli mumasule kukutumusa kwenu zintu zonse zina ituso, ni muni bakumilutila mwichisi ni kuyenda izubo ni zubo. ");
INSERT INTO sbs_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mwizi muniba kukalimela Majuda ni Magerike kuti babakele kwe Ireeza ni kuzumina kwe Simwina Jesu. ");
INSERT INTO sbs_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Mihanu, mulole, ni yenda nilinyongamine mu Luhuho Lujolola kwa Jerusalema, ninisezi zintu ziwola kukatendahala kwangu kuna, ");
INSERT INTO sbs_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","konzi Luhuho Lujolola nji paki zangu muleneñi uhi no uhi kuwambwa kusuminwa ni manyando anilibelele. ");
INSERT INTO sbs_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Kono kanihupuli kuti buhalo bwangu bwabutokwa kwangu, kuti ni mane isiyano wangu ni misebezi iniba tambuli kuzwa kwa Simwine Jesu, kuba ipaki yeñusa lyabutokwa lyachisemo cha Ireeza. ");
INSERT INTO sbs_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Mihanu, mulole, nizi kuti inwe mubonse, banibayendeli kukaluta za mubuso, kesenimubone ipata yangu hape. ");
INSERT INTO sbs_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Hakwina bulyo ni mipakila mwelinu izuba, kanina mulandu wamalaha a muntu zuhi no zuhi. ");
INSERT INTO sbs_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Kakuti kena nibaboleli mwisule kukutumusa kwenu mulelo wose wetato ye Ireeza. ");
INSERT INTO sbs_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Hakwinabulyo mulitokomele inwe mubene, ni mitapi iyo Luhuho Lujolola luba mitendi baokameli bayo. Mutokomele kuba balisani bekeleke ye Ireeza, yabawuli kamalaha akwe. ");
INSERT INTO sbs_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nizi kuti chinayenda, bantuhu bakali kabeze benjile mukati kenu, mi keti nibeze bafule mitapi inse. ");
INSERT INTO sbs_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Nizi kuti niheba mukati kenu mubene bamwi bakwame kabeze nikwiza kuwamba zintu ziwula bamwi ikweta, kutendela kuti bazwise balutwana kubali. ");
INSERT INTO sbs_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Chobulyo mutokomele. Muhupule muzilimo zotatwe kuti kana ni basiyi kulaela zumwi ni zumwi wenu ni kulila musihali ni masiku. ");
INSERT INTO sbs_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Mi hanu nimiha kwe Ireeza ni kulinzwi lyakwe lya chishemo, ili yowola kumikoza ni kumiha kuyola mukati kabo balukite. ");
INSERT INTO sbs_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Kana nibalakazi isilivera yamuntu, ni ngauda ni zizwato. ");
INSERT INTO sbs_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Inwe mubene mwizi kuti aa mayaza abaniwanisi zinisaka ni zibasaka abo babena name. ");
INSERT INTO sbs_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Muzintu zose nibakumiha mutala mumu wolela kutusuza basaliwoleli kakusebeze, ni mumuwolela kuhupulela manzwi a Simwine Jesu, manzwi oa abawambi: “Kwina imbuyoti zingi mukuha kuzamba kuhewa.” ");
INSERT INTO sbs_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Hamana kuwamba mweyonzila, chakubama ni kulapela nabo bonse. ");
INSERT INTO sbs_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Bonse babalili hahulu ni kuwila Paulusi mwisingo ni kumuchuchuna. ");
INSERT INTO sbs_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Babawililwe hahulu chakuhitliza chebaka lyazabawambi, ziti kete nibabone bulubi bwakwe hape. Linu chibamusindikiza kuchikepe. ");
INSERT INTO sbs_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Hatukahuhana kuvali ni twazuha, tuvahindi inzila iya kumuleñi wa Koso, mi halizwa nitwaya kumuleñi wa Rode, mi hatuzwa aho nitwaya kumuleñi wa Patara. ");
INSERT INTO sbs_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Linu hatuwana chikepe chibali kuya kwa Fenisia nitwechila kuchili ni kuzuha. ");
INSERT INTO sbs_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Linu hatusika muchida cha Sipera, nitwavola kuvumonso, nitwazuha kuya kwa Siria, mi nitwakasikila kumuleñi wa Tire, mukuti njoko chikepe kuchivali kulukela kukalongwela zivya. ");
INSERT INTO sbs_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Hatuwana valutwana, nitwekala mazuva amana iyanza ni obele. Ava valutwana ni vati kwa Paulusi chenzila ya Luhuho Lunjolola kuti senzi akalyatiki itende lyakwe mwa Jerusalema. ");
INSERT INTO sbs_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Linu hatumana mazuba, nitwakatuka ni kuyenda mumusipili wetu. Vonse ni banakazi ni bana vabo, ni vatusindikeza mane ulu hatukazwa mumuleñi. ");
INSERT INTO sbs_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Linu nitwakuvama helizo kulapela ni kulilaeza navo. Nitwakechila muchikepe abo havavola kumunzi. ");
INSERT INTO sbs_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Linu hatumana musipili wetu wa kwa Tire, chitwakasika kwa Ptolemaisi. Uko nitwakalumelisa vaakwakwetu ni kwikala nabo izuva lyonke. ");
INSERT INTO sbs_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Izuba lichilila nitwayenda kwa Sesarea. Mi nitwakenjila munzuvo ya Filipi, yo kutaza iñusa ilotu lya Jesus, yabali zumwi wavantu vamana iyanza ni vuvele, imi nitwekala naye. ");
INSERT INTO sbs_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Linu uzu mukwame avena vana vone vavakazana vaseni kwiziva kale vakwame vavali vatanikizi. ");
INSERT INTO sbs_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Sina hatuvena hateni mazuva alikene, chikwakeza mutanikizi yavali kuzwa kwa Judea yavali kusumpwa Agabusi. ");
INSERT INTO sbs_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Nakeza kwetu mi nahinda lutunga lwa Paulusi. Chalisumina mayanza ni matende akwe, “Vovulyo muluwambila Luhoho Lujolola, “mi vovulyo mweti nivamusuminine vantu vamwa Jerusalem solunu lutunga, mi muva mutamvike mumayaza avantu vamasi angi.”' ");
INSERT INTO sbs_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Linu hatuzuwa izi zintu, tuvonse ni vantu vavakuhala mwe cho chivaka nitwa kumbila Paulusi kuti sanziayendi kwa Jerusalema. ");
INSERT INTO sbs_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Imi Paulusi cheteva, “Mukwete mutenda nzi, kulila ni kuni nicisa kunkulo? Mukuti nilitukiseze, isiñi kusuminwa bulyo, kono ni kufwila izina lya Simwine Jesu mwa Jerusalema.” ");
INSERT INTO sbs_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Sina Paulusi kanaavalikusaka kukukuwezwa, nitwasiya mi nitwati, “Kutendwe chisakwa ni Simwine.” ");
INSERT INTO sbs_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Aa mazuva hamana, nitwahinda zivya zetu ni kuya kwa Jerusalema. ");
INSERT INTO sbs_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Linuhe vamwi valutwana vavali kuzwa kwa Sesara nivayenda naswe. Nivaleta ni mukwame yosumpwa Mnason, mukweme uzwa kwa Sipera, mi nivakeza ni mukwame, mulutwana wamatangilo utuola kwikala naye. ");
INSERT INTO sbs_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ha chitusika mwa Jerusama, vaakwakwe ni vatutamvula chakusanga. ");
INSERT INTO sbs_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Izuva lichilila Paulusi na yenda naswe kwa Jakobo, ni bakulwana bonse babena hateni. ");
INSERT INTO sbs_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ha chivamana kuvalumelisa, navavihela chimwi ni chimwi chintu chava tendendwa ni Ireez muvamasi angi cha mutendo wakwe. ");
INSERT INTO sbs_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Linu hava izuwa, ni vatemba Ireeza, mi nibati kwali, “Ubwene muukwetu, zikiti zongai ziva zumini mukati ka Majuda. Vonse vava kozeze kuvika mulao. ");
INSERT INTO sbs_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Vava wambilwa chako, kuti uluta Majuda vonse vahala mumasi angi kuti va kane Mushe, nikuti uvava wambila kuti kanzi batwali vana vavo kumupato ni kuse chilila chisiyankulu chetu. ");
INSERT INTO sbs_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Tuwola kutendanzi? Mavazuwe chokusima kuti uvakezi. ");
INSERT INTO sbs_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Mukuti utende zitu kuwambila hanu: Twina vakwame vone vava likonki chakuha isepiso. ");
INSERT INTO sbs_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Hinde ava vakwame ni kulijoloza navo vulyo, ni kuva lihila insinyehelo zavo, nikuti vangunke mitwi yavo. Kokuti vezive kuti zintu zivava wambilwa chako kazina vuniti. Muvalitute kuti nawe vulyo mwichilila mulao. ");
INSERT INTO sbs_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Kono kuamana ni vamasi angi vavazumini, tuvañoli ni kuvaha intayelo kuti vali zwise kuzintu zihailwe vazimu, kumalaha, niziva siniwa, niza vuliyendezi.” ");
INSERT INTO sbs_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Linu Paulusi nahinda vakwame, imi izuva lichilila nalijoloza iyemwine ni kujoloza avo vakwame, nikuya mwi templele, kukatumusa mazuva akulijoloza, kukasikila hakuka hewa chitavelo kuzumwi ni zumwi wavo. ");
INSERT INTO sbs_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Linu mazuva akwana iyanza ni obele havena hafihi ni ku hamana, vamwi Majuda vazwa kwa Asia ni vavona Paulusi mwi temple, imi niya sangisa chinavungi chonse, niva vika mayanza avo hali. ");
INSERT INTO sbs_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Vavali kuhuwa, “Vakwame va Isilaele, mutu tuse. Uzu njimukwame yoluta vaantu vonse kumwi ni kumwi zintu zilwisana vaantu, mulao ne chinu chivaka. Kwandahezo, avaleti Magerike mwi Tempele imi vava silafazi ichi chivaka chijolola.” ");
INSERT INTO sbs_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Mukuti chivava vwene kale Trofimosi Mufalisi naye mumuleneñi, imi nivazeza kuti Paulusi waka muleta mwi tempele. ");
INSERT INTO sbs_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Onse muleneñi uba sangite, imi vonse vantu nivatiya hamwina ni kukakwata Paulusi. Chivaka mukwitulwila kunze ye temple, mi ziyazo nize yaliwa haho. ");
INSERT INTO sbs_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Sina havava kulika kumwihaya, iñusa nilyeza ku muyendisi wa vaganteli kuti Jerusalema yonse nyungana. ");
INSERT INTO sbs_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Haho vulyo nahinda masole ni balauli wa masole niku tilila hansi kuchi navungi chonse. ");
INSERT INTO sbs_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Linu vantu hava vona muyendisi wa masole ni masole, niva siya kundama Paulusi. Linu muyendisi wa masole cheza kuwonda Paulusi, imi nalaela kuti a suminiwe ni mawenge obele. Chavuza kuti njini imi chinzi chava tendinzi. ");
INSERT INTO sbs_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Bamwi muchina vungi vava kuhuleza chintu chimwi. Sina muyendisi kana ava kuwola kuwamba chimwi chevaka lyelata, nalaela kuti Paulusi aletwa munzubo ikolete. ");
INSERT INTO sbs_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Linu heza kutantilwa, Masole vava mukatwile kakuti chinavungi chiva kalihite. ");
INSERT INTO sbs_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Mukuti chinavangi cha vantu chiva ve chilile niva kuhuweleza. “Muzwe mumusiye!” ");
INSERT INTO sbs_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Linu Paulusi havena hafwihi ni kwi njizikwa munzubo ikolete, chati ku muyendisi yomanisa, “Ni woli kuwamba chimwi kwako?” Muyendisi chati, “U wamba chigerike? ");
INSERT INTO sbs_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Kena njewe zuna Muegepita, yaba letete inkondo imi uva hindi zikiti kiti zonee zava sandukili kuzitwala munkaanda?” ");
INSERT INTO sbs_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulusi chati, “Ni Mujuda, ni zwa mumuleneñi wa Tarese mwa Silisia. Ni muzaki wa muleneñi u sepahala, niku kumbila, kuti uni zuminine ni wambe ku vantu.” ");
INSERT INTO sbs_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Lina muyendisi hamuha chivaka, Paulusi cha zimana hatantilwa ni kusovola vantu cheyanza, Hakuva tontwile ahulu, nawamba kuvali muchi Heberu, chati, ");
INSERT INTO sbs_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","2","“Baakwetu ni batayo, mutekeleze buikalabelo bwangu bweti nihe hanu kwenu. Linu ikunga halizuwa Paulusi nawamba kubali mumushobo wa Chiheberu, nibatotola zii. Nazwilahabusu nati, ");
INSERT INTO sbs_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","5","“Ime ni Mujuda, yabahwizumukilwa mwa Terese yamwa Silisia, kono nibawani ituto mounu muleneñi hamatandabalilo a Gamaliele. Nibarutwa chamilao ikolete yenzila ibeshetu betanzi. Nitukufalelwe za Ireeza, mane sina njinwe mubonse sunu. Nibasukululi cheyi Nzila (babalikuzumina Linzwi la Ireeza) kutwala ifu; nibasumini bonse bakwame ni banakanzi ni kubenjiza mutolongo. Muprisita mukulwani ni bakulwana bonse bawola kuba ipaki kuti nibaamuheli mañolo abalikuzwa kubali abakwetu ba Damasika, kuti niye kwateni. Nibali kukaleta basuminwe kuzwa kwa Jerusalema abo baseyi Inzila (babalikuzumina Linzwi la Ireeza) kuti njebahewe mulandu. ");
INSERT INTO sbs_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Kubatendahali buti kuti hanibena mulwendo nili hembali ni Damasika, izuba nilina hewulu lamutwi inakozana nikweza mumuni uzwa kwiwulu ubezi kumunika kunizimbuluka. ");
INSERT INTO sbs_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Nibawili hansi ni kuzuwa inzwi liti kwangu, 'Saule, Saule, unisukulwilazi?' ");
INSERT INTO sbs_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nibetabi, 'Njiwe ni, Simwine?' Nati kwangu, 'Njime Jesu wa Nazareta, yokwete kusukulula.' ");
INSERT INTO sbs_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Banibena nabo bababoni mumuni, kono kanababazuwi inzwi liyabali kuwamba kwangu. ");
INSERT INTO sbs_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ninati, 'Niyelele kutenda nzi, Simwine?' Simwine nati kwangu, 'Katuke ni kuyenda kwa Damasika; kwateni uko kokawambilwe zonse zotameha kutenda.' ");
INSERT INTO sbs_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Kana nibali kubona chebaka labukali bwalumonyi luna, chobulyo ninayenda mwa Damasika ninietelelwe chamayanza abana banibena nabo. ");
INSERT INTO sbs_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Kwateni uko ninakasangana ni mukwame yosupwa Ananiasi, mukwame yotokomele chakuya chomulao ni yopakwa ni majuda bonse babali kuhala mwecho chibaka. ");
INSERT INTO sbs_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Abezi kwangu, kwiza kuzima hembali name, mi nati, 'Saule mwinakwetu, amuhele kubona kwako.' Mwihola iswana ninamubona. ");
INSERT INTO sbs_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Kuzwaho nati, Ireeza ubeshetu betanzi abakusangi kuti wizibe itato yakwe, ubone Yonjolwele, ni kuzuwa linzwi lizwa mukaholo kakwe mwine. ");
INSERT INTO sbs_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Mukuti kobe ipaki yakwe kubakwame bonse kuchobaboni ni kusuwa. ");
INSERT INTO sbs_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Imi linu chinzi holindile? Katuke, kakolobezwe, ni kukasamba zive zako, nosupa izina lyakwe.' ");
INSERT INTO sbs_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Kuzwa hanikabola kwa Jerusalema, mi hanibakwete kulapela mwitempele, kubatendahali kuti ni bahewa ipono. ");
INSERT INTO sbs_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nibamuboni naniwambila kuti, 'Hwele ni kusiya Jerusalema kapili, mukuti keti ni bazumine bupaki bwangu kwako.' ");
INSERT INTO sbs_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ninati, 'Simwine, abo bene bezi kuti nibenjizi mutolongo ni kukaba babali kuzumina mwizina lyako mwisinagoge yimwi ni yimwi. ");
INSERT INTO sbs_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Mwizuba hakuitika malaha a Setefani ipaki yako, name bulyo nibazimene habumbali ninizumina, imi nibali kumamela zizabalo zabana babali kumwihaya.' ");
INSERT INTO sbs_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Kono nati kwangu, 'Yende, mukuti kanikutumine kule, kubantu bamasi angi.' ");
INSERT INTO sbs_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","24","Bantu babamuzuminini kuwamba mane kwiza kusika heyo inako. Kono kuzwaho nibahuweleza hakando nibati, “Muntu yoswana nozo azwisiwe mukanda: mukuti kakuyelele kuti ahale.” Hababakwete kuhuweleza, kuzula ni kusohela kuna zizabalo zabo, ni kuganwina ibu muluhuho, muyendisi mukulwana wamasole nichalaela kuti Paulusi aletwe muzubo ikozezwe. Abalaeli kuti abuzwe nasupiwa, kokuti iye mwine alizibile kuti chinzi habahuweleza chakwe bulyo. ");
INSERT INTO sbs_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","26","Linu heti chibamusumina kuti ashupwe, Paulusi nichati kumuyenzi wamasole yabazimene hembali naye, “Kena mulao kwako kushupa mukwame yeli Muroma nosaatulwa?” muyenzi wamasole hazuwa bulyo, abayendi kumuyenzi mukulwana wamasole nakamuwambila nati, “Chosaka kuchita chinzi? Mukuti uzu mukwame muzaki wa Roma.” ");
INSERT INTO sbs_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","29","Muyenzi wamasole mukulwana abezi kwali namucho, “Honiwambile, kana umuzaki wa Roma?” Paulusi nati, “Ii”. Mulauli mukulwana wamasole netaba, “Ibali chakuliha bulyo masheleñi mangimangi chibaleti kuti niwane buzaki bwekanda.” Kono Paulusi nati, “Nibapepwa ninili muzaki wa Roma.” Kuzwaho bakwame babali kuyelele kumubuza nibamusiya chabuhweluhwelu. Muyenzi mukulwana wamasole naye abakutite, hazuwa kuti Paulusi ibali muzaki wa Roma, mukuti abamusumine kale. ");
INSERT INTO sbs_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Mwizuba litatama, muyenzi mukulwana wamasole abali kusaka kwiziba buniti kuamana ni zibanyasa Paulusi Majuda chazo. Chobulyo namusumununa mumawenge mwabasuminwe ni kulaela maprista bakulwana ni manduna kuti bakopane hamwina. Linu naleta Paulusi ni kumuzimika hakati kabo. ");
INSERT INTO sbs_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulusi na lolelela vayendisi benkuta nikucho, “Bakwangu, niva hali havusu bwa Ireeza mu mihupulo yangu milotu, kuleta sunu hanu.” ");
INSERT INTO sbs_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Mupurisita mukulwana cha laera avo vava zimene naye, kumu wopa kumulomo. ");
INSERT INTO sbs_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Imi Paulusi nacho kwali, “Ireeza mwaku wope nawe, iwe limota vasitwe ku tuva. Wikere chakuni watula chomulao, mi hape uni laera kuti vani vakule, ku lwisanisa mulao?” ");
INSERT INTO sbs_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Avo vava zimene hembali nivati, “Njimona mumu tukila muprurisita Mukulwana wa Ireeza vovuti?” ");
INSERT INTO sbs_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paulusi nacho kuti, “Kana niva kwizi, Bakwangu, kana nivesi kuti mupurisita mukulwana. Mukunti kuñoletwa, “Kanji mu wambi vuvi vwa muyendisi wa vaantu venu.” ");
INSERT INTO sbs_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Cwale Paulusi ha vona kuti imwina imbali ye nkuta vavali masaduki ni vamwi vafalisi, cha wamba chaku nyamuna liinzwi munkuta, “Bakwangu, ni mu Falisi, mwana wabafalisi. Ivaka lya kuti nina inseepo yakuti kuti vafu kavavuuke ini atulwa chayo” ");
INSERT INTO sbs_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ha wamba vulyo, inkani chiza tanga mukati kavaFalisi ni MaSaduki, imi vuungi nivwa liyaba. ");
INSERT INTO sbs_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","“Mukuti maSaduki vacho kuti kakwina kuvuka kuva vafwile, kakwina mañiloi, kakwina luhulo, kono baFalisi va zumina muzonse.” ");
INSERT INTO sbs_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Cwale chi kweza ilata ikando, ni vamwi vañoli vawila kuvaFalisi niva ziima kukaanana, nivati, “Katu wani chifosahele kozu mukwame, kwina vule hamwi Luhuho kamba Iñiloi njilya wamba kwali?” ");
INSERT INTO sbs_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Hakuva ni nkani inkando, muyendisi wenkondo, ava tite kuti Paulusi mwa halolwe vusasa ku vali, imi cha laera valwi venkondo kuya hansi ni kumu twala chenkaani ku mu zwisa kuvenkuta, ni kumu leta munzuvo ikolete. ");
INSERT INTO sbs_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Masiku e chilila Ireeza na ziimana hembali naye, nikumuti, “Siye ku tiya, mukuti uva paki vuniti kachangu mwa Jerusalema, imi uka pake vulyo ni mwa Roma.” ");
INSERT INTO sbs_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Haliza ku ñatula, maJuda vamwi chiveza hamwina, niku sumpila chikuto havali veene: chivati, kete valye kamba kunywa chimwi konji chive haya Paulusi. ");
INSERT INTO sbs_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Vavali kuhitilila amakumi one vava tendi uwu mulelo. ");
INSERT INTO sbs_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Nivayenda ku mupurisita mukulwana, ni kuvakulwana niku kawamba, “Chitwalivika tuvene mu chikuto chikando, kusa lya chimwi konji chitwe haya Paulusi. ");
INSERT INTO sbs_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","“Cwale, hanu, mu siye inkuta i wambile muyendisi wenkondo, nikuka muleta kwenu, uvu musaka kusakisisa indava zakwe, imi iswe, mutuve kulitukiseze kumwi haya naseni kusika kunu.” ");
INSERT INTO sbs_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Kono mwana'nchizye wa Paulusi wa chiswisu naa zuwa kuti vava lele chaku lindila, imi ava yendi kukenjila munzuvo isilelezwe nikuta Paulusi, ");
INSERT INTO sbs_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Paulusi cha kumbila zumwi wa vaganteri nikucho, “Mutwale uzu mukwame kuva yendisi ve nkondo mukuti wina chimwi kawola kumu wambila.” ");
INSERT INTO sbs_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Imi niva muhinda mushisu nikumu twala kumuyendisi we nkondo ni kukacho, “Paulusi musuminwa wani sumpila kwali, ni kuni takuti nilete uzu mushisu kwako. Wina cha saka kuwamba kwako.” ");
INSERT INTO sbs_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Mukulwanna we nkondo na muhinda kwiyanza ni kuya kuchivaka chi li ungwile ni kumu vuza, “Chinzi cho swanela kuni wamba kwangu?” ");
INSERT INTO sbs_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Mulombwana chamuwambila, “Majuda bazumizana kuti bakukumbile utwale Paulusi izona kukuta, ubu basaka kukabuza chakuya chenako ye indaba yakwe.” ");
INSERT INTO sbs_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Kono kazi ubahi ye, kakuti kwina bakwame bahitilila makumi one bamubandamine. Ba bika chikuto hewulu lyabo, kense balye kapa kunywa hesi chiba mwihaya. Niheba hanu bali ndukiseze, balindile kuti uba zuminine.” ");
INSERT INTO sbs_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Imi mupurisita mukulwana nasiya mushisu kuliyendela, hamana kumu laera, “Kanji uwambili nangati yeke kuti wa wamba izi zintu kwangu.” ");
INSERT INTO sbs_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Cha sumpila kwali vakwame vovere nikuti, “Uhinde valwi venkondo vachita myanda yovere vali tukiseze kuyenda konji kwa Sizeriya ni vatanti ve mbizi vena makumi achita myanda yovere hape, niva milinga vena myanda yovere. Mumu nyamuke hakati kamasiku.” ");
INSERT INTO sbs_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Naava laera hape ku lukisa imbizi Paulusi yawola kwichila hateni, ni kumu twala siinte kwa Felekisi muvusisi. ");
INSERT INTO sbs_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Imi avañoli iñolo chovuti; ");
INSERT INTO sbs_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Kilaudiyasi Laisiyasi kuyo tompeha muvusisi Felekisi, intumeliso. ");
INSERT INTO sbs_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Uzu mukwame ava suminwa kuma Juda, imi ava kusaka kwi hayiwa kuvali, hani keza havali ni masole venkondo, nikumu haza, kuzwa hani ziva kuti Muroma. ");
INSERT INTO sbs_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nivaku saka kwiziva ivaka hava zekiswa, cwale cina mutwala kunkuta. ");
INSERT INTO sbs_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","China lituta kuti ukwete ku zekiswa kuamana che mpuzo za mulao wavo veene, ni kuti kakwina zimusumina kutwala ku lufu kamba ku pika. ");
INSERT INTO sbs_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Imi ni kwezibahazwa kwangu kuti kuveena vusandukili kozu mukwame. imi namu tumina hahanu kwako, ni ku laera valwisi vakwe ku leta zivamunyaza chazo havusu vwako. Shale sinte!” ");
INSERT INTO sbs_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Cwale valwi venkondo chiva kuteka intaero zavo: niva hinda Paulusi nikumu leta masiku kwa Antiporisi. ");
INSERT INTO sbs_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Izuva lichilila, vuungi vwa valwi benkondo nivasiya vantanti ve mbizi kuti vayende naye imi avo vene niva voola kuchivaka chisilelezwe. ");
INSERT INTO sbs_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Vatanti vembizi hava sika mwa Sizeriya, niva leta iñolo kumuvusisi, niku tambika Paulusi kwali. ");
INSERT INTO sbs_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Muvusisi hamana kuvala iñolo, na vuuza kuti Paulusi uzwa muchikiliti nzi; he ziva kuti uzwa kwa Sisilia, ");
INSERT INTO sbs_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Nati, “Muni zuwe chokwizula vazekisi vako chiveza kunu,” imi cha laera kuti a vikiwe mumuleneñi wa mubuso wa Heroda. ");
INSERT INTO sbs_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Hakumana mazuva akwana iyanza, Ananiyasi mulena wamapulisita, nivamwi vakulwana, ni mutoroki yosumpwa Teretulo, vava yendi ko. Ava vakwame vava leti mulandu kuhambiliza Paulusi kumu vusisi. ");
INSERT INTO sbs_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Linu Paulusi hazimana havusu vwa muvusisi, Teretulo chatanga kumu hambiliza imi chati kwa musisi,” Chevaka lyako twina inkozo inkando; imikuvona kwako kuvaleti kuzakwa chincha mwinkanda yetu; ");
INSERT INTO sbs_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ku litumela kwetu konse tuamuhela zintu zonse zopanga, ukondise Felekisi. ");
INSERT INTO sbs_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ili kuti senzi niku viki mwintolongo hape ni kamuta, ni ku kumbila cha vufuhi uniteke cha kuluka. ");
INSERT INTO sbs_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Kakuti twawana uzo mukwame kuti njo memeza yoletiseze maJuda mwinkanda yonse kusandukila muvuso. Njiyena muyendisi wa Nazarene i keluhite. ");
INSERT INTO sbs_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ava liki kusitatalisa itempele; cwale cha suminwa. Imi tuva kusaka kumu atula che nkatulo yetu. ");
INSERT INTO sbs_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Kono muyendisi chasika chenkaani chivamuhinda munza etu, hamuvuza Paulusi heyi indava, ni nwe kamuwole kulituta ka chituva hambilizi kacho.” ");
INSERT INTO sbs_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Majuda nivakopene vava hambilinzi Paulusi, navo, michivamba kuti izi zintu ivali kusakusimwa. ");
INSERT INTO sbs_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Kono linu muvusisi hasumpa Paulusi kuti zawambe, Paulusi chetava, “Ni zuwisisa kuti kazilimo zingi uvali umuatuli weyi inkanda. imi cwale nilitule kulitoloka kwaako. ");
INSERT INTO sbs_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","U wola kuvonisisa kuti kena kuva hitilili mazuva akwana ikumi ni wovele chinga niva yendi kukalapela mwa Jerusalema; ");
INSERT INTO sbs_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","imi linu havaniwana mwi kereke, kana niva kanani ni muntu, kana niva susuezi chichava, ni haike mumasinagoge, kapa mumuleñi; ");
INSERT INTO sbs_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","imi hape kava woli kuleta vupaki kwenu vwe ndava zivava hambilizi hewulu lyangu hanu. ");
INSERT INTO sbs_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Kono ni litumelele izi kwenu, kakuya che nzila iva sumpa kukeluha, mwinzila iswana ni seveleza Ireeza uva kuku wetu. Ni sepahala ku zonse za mulao ni ziva ñolwa kuvaporofita. ");
INSERT INTO sbs_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ni na insepo iswana kwa Ireeza, ili njava vakwame naavo muvayilindile, kukeza kuvuka kwa vaantu vafwile, kuvalukite ni vasalukite; ");
INSERT INTO sbs_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","imi mweezi, ni tenda kuti nive nizwalo nikusa nyazahala havusu vwa Ireeza ni vaantu muzintu zonse. ");
INSERT INTO sbs_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Linu hakuhita zilimo zingi china leta intuso kwi nkanda yangu ni impo ya masheleñi. ");
INSERT INTO sbs_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Lyahanu ha nitenda izi, vamwi kumaJuda vazwa mwa Asia chivani wana ni joloza mikiti mwi kereke, insiñi cha chichava kapa chakukamba. ");
INSERT INTO sbs_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ava vakwame vaswanela kwiza havusu vwako hahanu mi zeva wambe zivani lwisikiza, heva vena chimwi. ");
INSERT INTO sbs_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Heva njovulyo, ava vakwame vaswanela kuwamba vuvi vuva wana kwangu hana zima havusu vwe nkuta ya majuda; ");
INSERT INTO sbs_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","haisi konji kuti i amana nechi chintu chonke chini vawambi chakutumusa hanivazimene mukati kavo,' kuamana nikubuka kuva fwile kuni kwete kuatwilwa sunu kwenu. ");
INSERT INTO sbs_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Felekisi ava kwizi kuamana ni nzila, imi cha twala havusu intomelo yakwe. Chawamba, “inako ni nako Lysiyasi muyendisi wa masole hakeza hansi kuzwa kwa Jerusalema, kani atule muzeko wako.” ");
INSERT INTO sbs_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Linu mukulwana chalaela mulauli kuti a gantele Paulusi, kono uswanela kumu vavalela, mi kakwina yo swanela kukanisa valikani vakwe kumutusa kapa kumupotela. ");
INSERT INTO sbs_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Hakuhita mazuva, Felexisi chavola ni Durusicila mwihyavwe, wa mujuda, imi chatumika Paulusi imi avazuwi kwa kuamana nintumelo kwa Jesu Keresite. ");
INSERT INTO sbs_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Kono Paulusi havali kulikananisa naye kuamana ni, kuliyendisa umwine, ni inkatulo ikezite, Felekisi chezilwa kutya mi chati, “Muyende uko hanu. Kono chi na wana chivaka chinekalakala, ka nimi sumpe.” ");
INSERT INTO sbs_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Chenako iswana avali kuzeza kuti Paulusi kamuhe masheliñi, inako ni nako ava kutumina kwakwe niku wamba naye. ");
INSERT INTO sbs_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Kono linu zilimo zovele hazihita, Posiyasi Fesitasi cheza kuva muvusisi hakuzwa Felekisi, kono Felikisi ava kusaka kuti asakahale ahulu kumaJuda, cwale chasiya Paulusi kuti azwile havusu mwi ntolongo. ");
INSERT INTO sbs_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Hanu, Fesitasi avengili mu chikiliti, mi hakuhita mazuva otatwe, ava yendi ku kazwa kwa caesariya mbwita kwa Jerusalema. ");
INSERT INTO sbs_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Mu prisita mukulwana ni machaziva va majuda vava leti inyazo zavo kuamana ni Paulusi kwa Fesitasi, mi vava wambi chokukoza kwa Fesitasi. ");
INSERT INTO sbs_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Mi vava kumbili Fesitasi chisemo kuamana ni Paulusi, kuti awole kumusumpila kwa Jerusalema njokuti va mwihaye mukati kenzila. ");
INSERT INTO sbs_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Kono Fesitasi avetavi kuti Paulusi avali musuminwe mwa kaeseria, mi kuti iye mwine chava kwina hafuhi ni kuvola kwateni. ");
INSERT INTO sbs_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","“Cwalehe, avo va wola,' cha wamba,' vaswanela kuyenda kwateni oko naswe. Haiva kwina chi fosahele ni mukwame, muswanela kumunyasa.” ");
INSERT INTO sbs_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Ha mana kwikala mazuva amana iyanza ni minwe yone kapa mazuva e kumi, chayenda kwa kaisera. Mi kwi zuva lyi chilila, chekala mu chipula che nkatulo ni kulaela Paulusi aletwe kwali. ");
INSERT INTO sbs_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Heza kusika, ma Juda vakwa Jerusalema vava kuzimene hembali, mi vavaleti inyazo mikando mingi isena ivava kuwola ku paka. ");
INSERT INTO sbs_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paulusi chalizimanina iye mwine niku wamba,'”kakwina chinapanga chifosahele kuamana ni mulao wa ma Juda, kapa kuamana ni tempele, kapa kuamana ni caesar.” ");
INSERT INTO sbs_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Kono Fesitasi avakusaka ku wana chisemo ku majuda, mi he chetava Paulusi niku wamba,'”Usaka kuyenda kwa Jerusalema mi nikuka atulwa kwangu kuamana nezi zintu kuna?” ");
INSERT INTO sbs_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paulusi chawamba, “ni zimana havusu bwe chipula che nkatulo ya caesar hani swanela kuka atulelwa. Kena niva fosekezi mujuda, sina mo wizivile hande nenwe. ");
INSERT INTO sbs_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Kono haiva niva fosi, mi niva pangi chiswanela ifu, kani kani kufwa, Kono haiva kuhambiliza kwavo kahena, kakwina yata ni tambike kuvali. Nisumpa caesar.” ");
INSERT INTO sbs_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Fesitasi hamana kuwamba ni venkuta, che tava, “wa sumpa caesar,' moyende kwa caesar.” ");
INSERT INTO sbs_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Hanu hakuhita mazuva, Murena Agrripa ni Bernice chiveza kusika kwa caesarea kwiza kumupotela Fesitasi chokusepahala. ");
INSERT INTO sbs_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Hachamana kwikala uko chamazuva mangi, Fesitasi cheza kuzala indava ya Paulusi ku Murena; cha wamba, “mukwame zumwi ava siiwa ku masule kunu nji Felixi sina suminwa. ");
INSERT INTO sbs_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Hani vakwina mwa Jerusalema, mu prista mukulwana ni va kulwana va majuda vavaleti milandu kuamana uzu mukwame kwangu, mi vava kumbili inkatulo hali. ");
INSERT INTO sbs_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Kwezi nivetavi kuti kena mulao ni Maroma kutambika muntu uvu chisemo; kono, muntu yo hambilizwe uswanela kuhewa chivaka chokuvonana navo va muzekisa mi niku lizimanina mu mizeko yakwe. ");
INSERT INTO sbs_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Cwale aho, hava keza hamwina kunu, mi kena niva lindizi, kono izuva lichilila nive kali mu chipula che nkatulo, mi niku laela mukwame aletwe kwangu, ");
INSERT INTO sbs_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Vahambilizi hava zimana niku muhambiliza, seke ni tele kuti kakwina ku milandu iva muhambiliza yo vutokwa. ");
INSERT INTO sbs_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Kono, kuvavi niku salizuwa kuamana ni ntumero zavo ni kuamana ni Jesu yavafwi, uzo Paulusi wata kuti uhala. ");
INSERT INTO sbs_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Niva kuziyelehete kaku sakisisa iyi ndava, mi niva muvuzi heva uwola kuyenda kwa Jerusalema kuka atulelwa kwateni kuamana nezi zintu. ");
INSERT INTO sbs_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Kono Paulusi hava sumpwa kuka vikwa mu mpavalelo ye nkatulo yo Murena, china mulaela kuti akavikwe haisi hasa mutuminwe kwa Caesar.” ");
INSERT INTO sbs_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agrippa cha wamba kwa Fesitasi, “seni saka neme kuteka kozu mukwame.” “Izona,” Fesitasi cha wamba, “ko muzuwe.” ");
INSERT INTO sbs_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Cwale hezuva lyi chilila, Agrippa ni Bernice vavakezi ni mukiti mukando; vavakezi mumakopanelo ni mapokola niva kwame va sepahala vamwi ve ntolopo. Mi Fesitasi ha wamba intaelo, Paulusi avaletwa kuvali. ");
INSERT INTO sbs_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fesitasi cha wamba, “Murena Agrippa, nenwe vakwame vena umu naswe, mubwene uzu mukwame; iveza ku zekisa ma juda vangi kwangu mwa Jerusalema no kunu konse chiva huweleza kwangu kuti kasiswaneli kuhala. ");
INSERT INTO sbs_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Niva lituti kuti kakwina ma fosisa a panga aswanela ifu; kono kakuli ava sumpi ku murena, niva atuli kuti va mutumine. ");
INSERT INTO sbs_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Kono kanina chintu chovuniti cho kuñola ku murena. Kelyi vaka, na muleta kwako, sihulu kwako, Murena Agrippa, njokuti nive ni chimwi chingi chokuñola kuama iyi indava. ");
INSERT INTO sbs_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kaho ku voneka kusava ni vaka kutumina musuminwa mi hape niku sawamba mulandu hakwe.” ");
INSERT INTO sbs_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Linu Agiripa chawamba kwa Paulusi, “Uwola kuli wambilila.” Lyahanu Paulusi cha wotolola iyanza lyakwe nikuli sileleza. ");
INSERT INTO sbs_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Nilizuwa kuti nilukuluhite Mulena Agiripa, kutenda indava yangu havusu vwako sunu hewulu lyazintu zonse zivava nihambilizi ma Juda; ");
INSERT INTO sbs_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","sihulu, kakuli wichaziva wechizo cha ma Juda ni mpuzo. Linu ni kumbila kuti unizuwe chentokomelo. ");
INSERT INTO sbs_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Cheniti, ma Juda vonse vezi muniva halili kuzwa kuvuhwile vwangu mwi nkanda yangu ni mwa Jerusalema. ");
INSERT INTO sbs_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Vavanizi kuzwa kuma tangilo vawola kuzumina kuti nivahali neli ni mu Falisi, yavali wachiyemba ahulu cha chilumeli chetu. ");
INSERT INTO sbs_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Lyahanu nizimana hanu kuti ni atulwe kakuli ni lolete che nsepiso yaba tendi Ireeza ku veshetu. ");
INSERT INTO sbs_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Cheyi insepiso masika etu ekumi ni tobele vava lisepise kutambula niva kwatilile kulumbeka Ireeza masiku ni musihali. Nji cheyi insepo, Simwine mukando Agiripa, Juda chingi ivanihambiliza. ");
INSERT INTO sbs_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Chinzi zumwi kwenu hazeza kuti kulotu kuti Ireeza uvusa vafu. ");
INSERT INTO sbs_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Ka imwi inako nivazezi kuti niswanela kutenda zintu zingi zilwisanisa izina lya Jesu wa Nazareta. ");
INSERT INTO sbs_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Niva tendi izi mwa Jerusalema. Niva sumini valumeli vangi mwi ntolongo cha maata aniva wani ku mupurisita mukulwana, have haiwa, nivali kuvika inketisa zangu h havo. ");
INSERT INTO sbs_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Niva kuvaha inkoto mwi nako zingi mu ma Sinagoge ni kulika kuva hambiliza kuti vanyanse. Nivava vengeli ahulu nikuva nyandisa nanga mu muleneñi muvasazwi. ");
INSERT INTO sbs_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Anivali kupanga ichi, nivayendi kwa Damaseka ni maata ni ntaelo zizwa kumu purisita mukulwana; ");
INSERT INTO sbs_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","linu mwi nzila, musihali, Simwine mukulwana, nivavoni iseli livakuzwa mwiwulu liva kuvenya kuhita izuva imi livatondezi kwetu niva kwame vani va kuyenda navo. ");
INSERT INTO sbs_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Twense hatuwila hansi, niva zuwi inzwi liwamba kwangu mumushovo we chi Heveru, 'Saule, Saule, chinzi honi nyandisa? Ku kukutu kwako ku raha muso. ");
INSERT INTO sbs_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","China wamba kuti njewe ni, Simwine? Simwine chetava, njeme Jesu yo nyandisa. ");
INSERT INTO sbs_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Linu vuke uzimane cha matende ako; nji cheli ivaka haniva voneki kwako, kuketa iwe kuva umuhikana ni mpaki kuamana ni zintu ziwizi zangu hanu nizintu zete ni kutondeze chitwe kalakala; ");
INSERT INTO sbs_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","imi kani kulamulele kuvantu ni ku machava kuni kutuma, ");
INSERT INTO sbs_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","kwiyalula menso avo kuazwisa mwififi ni kuatwala mwi seli ni ku ziho za Satani kwa Ireeza, njikuti vatambule kwa Ireeza maiswalelo ezivi zavo nikuyola zete nivahe ni kuli kauhanya kwangu che ntumelo ina kwangu. ");
INSERT INTO sbs_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Chikwina vulyo, Simwine mukando Agiripa, kena navikila kwimbali chivono chewulu; ");
INSERT INTO sbs_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","kono kwavo vena mwa damaseka che ntanzi, navana vena kwa Jereusalema, ni nkanda yonse ya Judea, ni kumachava, niva kutazi kuti vavakile zivi zavo vavole kwa Ireeza, kuvonisa mitendo ivonisa kuvaka kwavo. ");
INSERT INTO sbs_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Cheli ivaka ma Juda vava nisumini niku lika kuni haya. ");
INSERT INTO sbs_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ireeza avanitusi kusika hanu, cwale niziima nikuha vupaki kuvantu feela niku va tompeha nizimwi zihita zivawambwa kuma porofita ni Mushe kuti muzipangahale; ");
INSERT INTO sbs_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","kuti keresite uswanela kunyanda, ni kuta kuti mwave we ntanzi kukuvuka kuvafu niku zimana kupaka iseli kuma Juda ni machava. ");
INSERT INTO sbs_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Paulusi hamana kuli lamulela, fesitusi chawamba chenzwi li katukite, “Paulusi, uvurumuka; intuto yako inkando iku vulumuna.” ");
INSERT INTO sbs_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Kono Paulusi chati, kani vurumuki, hande ahulu Fesitusi; kono cho vundume niwamba manzwi ovusakusima ninisa nywine. ");
INSERT INTO sbs_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Kakuli Simwine mukando wizi izi zintu; njikuti, niwamba kwali nini lukuluhite, kakuli ni susuweze kuti kakwina zi patitwe kwali; mukuti izi kena ziva pangilwa kuliungwiile. ");
INSERT INTO sbs_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Uzumina kuvaporofita, Mulena Agiripa? Nizi kuti uzumina.” ");
INSERT INTO sbs_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agiripa chawamba kwa Paulusi, “Mu nako infuhi moni susuweze nive ni mulumeli?” ");
INSERT INTO sbs_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paulusi chati, “Ni lapela kwa Ireeza, kuti kapa munfuhi kapa inde inako, insiñi iwe wenke, kono nivonse vanizuwa sunu, muvave uvu njeme, kono nikusena anu mahaka entorongo.” ");
INSERT INTO sbs_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Linu Mulena chazima mwiwulu, ni muyendisi, ni Bernise naye, ni vonse vavekele naavo; ");
INSERT INTO sbs_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","lyahanu hava siya uwo muyaho, vavawambi hamwina nikuti, “Uzu mukwame kakwina zavapangi ziswanela lufu ni ku suminwa.” ");
INSERT INTO sbs_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agiripa cha wambila Fesitusi, “Uzu mukwame ava kuwola kulukululwa kambe kena ava likumbili kwa Sizare.” ");
INSERT INTO sbs_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Hachi kuzumi zenwe kuti tuswanera ku zuhira kwa Itali, chiva vika Paulusi ni vamwi vambatiti mwi kamaiso yo muyendisi yavali kusupwa Juliyasi we chisole cha Agustini. ");
INSERT INTO sbs_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Chitwe chira muchisepe chizwa kwa Adiramatiyaumu, icho chichi vali kukatuka cha marizo a Asiya. Cwale chitwa yenda kwi wate. Arisitichesi wa kwa Mateselonika ava yendi naswe. ");
INSERT INTO sbs_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Izuva lichilira chitwa kafweka hamuleñi wa Sidoni, uko Juliyasi avaka pangi hande Paulusi ke chishemo ni kumu zuminina kuti a yende kuvali kani vakwe kuti aka wane ipavalero yavo. ");
INSERT INTO sbs_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Kuzwa aho, tuva yendi kwi wate ni kuka zuhira kuzimbuka chi oli cha Cypurusi icho civali ku wumbitwe ku luhuho, kakuti luhuho luvali kutu lwisa. ");
INSERT INTO sbs_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Hachitu zuhite kuluta menzi ena hafuhi ni Chilisiya ni Pamiliya, chitweza kwa Myra, muleneñi wa Lyicia. ");
INSERT INTO sbs_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Uko, muyendisi ava wani chisepe chizwa kwa Alexandiria icho chivali kuya kwa Itali. Chatu vika muchili. ");
INSERT INTO sbs_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Hachitu zuhite cho kulyehisa chama zuva mangi mi kumamani chitwa kasika cho vukavo he mbali ni Cnidusi, luhuho kena luva tuzuminini kuyenda mweyina inzira. Chitwa zuha kumbali ni marizo a Crete, kumbali ni Salmone. ");
INSERT INTO sbs_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Chitwa zuha kumbali ni marizo cho vukavo, kusikira hatwiza kusika hachivaka chimwi chi supwa Mawulu Hande, china he mbali ni muleneñi wa Lasea. ");
INSERT INTO sbs_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Chitu vali kuhindite i nako nde, inako yo kulinyima zilyo ya Majuda nayo chiyi va hitilire, mi chikuvali kwi zite vukavo kuku zuha. Cwale Paulusi chava laya, ");
INSERT INTO sbs_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","ni kuti, “Vakwame, Ni vwene kuti chisepe chitu swanera kuhinda muchive ni nkolofalo ni shiyehero ahulu, isiñi vulyo ye zibya ni chisepe, kono mane vulyo ni vuhalo bwetu.” ");
INSERT INTO sbs_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Kono muyendisi ava tekerezi ahulu kumu kulwana ni ku mwine we chisepe kuhita kuzintu inzo zavali ku wamba Paulusi. ");
INSERT INTO sbs_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Kakuti irizo kena livena hande kuti twi kale hateni muma liha, vungi bwa vantu vavena mo chiva yerezwa kuzuha kuzwa ho, mwendi chomukwa wumwi mutu wole kukasika kumuleneñi wa Phoenix, kuti tuke kale kwateni maliha. Phoenix irizo lina mwa Crete, mi lilorere kwa mbowera wiko ni mutulo upa. ");
INSERT INTO sbs_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Ihuho lizwa kumbali yokuchi monso halu tanga kuhunga che konzo, vazuhi chiva nahana kuti chiva wana chivavali kusaka. Cwale chiva tatuva mandinda ni kuzuhira kuya Crete, kumbali ni riso. ");
INSERT INTO sbs_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Kono hakuhita kavaka zana liñungwa lye huho, linsupiwa Ihuho lyo kwiyaza lye Chimonso, chilya tanga ku dama hetu kuzwa mwishirya lye chioli. ");
INSERT INTO sbs_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Aho chisepe hachiza kuwondwa kumutwi mi kena chivali kuwola ku zuhira kulolera ihuho, chitwa siya kululi mi chilwa tu timba. ");
INSERT INTO sbs_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Tuva tiyiri kwi mbali ni minzunde yo kwimbali ye kawoli zana kasupwa Cauda; mi chovukavo tuva woli kuvavalera mato o vuhalo. ");
INSERT INTO sbs_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Hachi va katwire, vava severisi mihara yateni kusumina mutwi we chisepe. Vavali kutiyite kuti mutu tirire mwiseke lya Syrtisi, mi chiva sumununa hihara ye chisepe mi tuva vuviswa vulyo. ");
INSERT INTO sbs_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Tuva chimbolwa ku luhuho, cwale havusa vazuhi chiva tanga kuzindira zibya hanze. ");
INSERT INTO sbs_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Mwizuva lyo vutatu vazuhi chiva zindira hanze zisipi ze chisepe chamanza avo. ");
INSERT INTO sbs_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Cwale izuva ni nkani kana ziva muniki hewulu lyetu cha mazuva mangi, mi i huho ikando livali kusi dama hetu, kena kuvasina i sepo yo kuhazwa kwetu twense iva tumanini. ");
INSERT INTO sbs_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Ha chiva hindite inako inde niva sali zilyo, linu Paulusi ava zimani mukati ka bazuhi ni kuwamba. “Vakwame, saka muswanera kuteka kwa ngu. mi nikusa zuha kuzwa kwa Crete, sina kwiza kuwana iyi kolofalo ni shiyehero. ");
INSERT INTO sbs_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Mi hanu nimi susu weza kuti mukole, kakuti ka kwina zumwi yate a siyeherwe vuhalo mukati kenu, kono mbwita fera i sinyehero ye chisepe. ");
INSERT INTO sbs_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Kakuli masiku a mana Iñiroyi lye Ireeza uko kuni wanika, uzo hape uni lapera - iñiroyi lyakwe lyeza kuzimana hembali name ");
INSERT INTO sbs_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ni kuwamba, “Kanji u tiyi, Paulusi. Uswanera kuka zimana ha vusu bwa Caesar, mi vone, Ireeza mumuvuso wakwe waha kwako vonse vayenda nawe. ");
INSERT INTO sbs_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Cwale he, Vakwame, muve ni vundume, kakuli ni sepa Ireeza, kuti kaipangahale sina muya wambirwa kwangu. ");
INSERT INTO sbs_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Kono tuswanera kuzimana ha tuwoli tumwi.” ");
INSERT INTO sbs_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Hakwiza kusika masiku e kumi ni minwe yone, sina hatuvali kutimbirwe mweyi nzira ni kuti mwi wate lya Adriatic, mwinako yaha kati ka masiku va zuhi chivavali kuhupula kuti chivavali kusika he mbali ne rizo. ");
INSERT INTO sbs_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Chivahinda milumo ni kuwana makumi overe yo kutunga. ");
INSERT INTO sbs_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Vava tiyite kuti muva chaise mumabwe, mi civa susa mabwe one kuchi sepe ni kulapera kuti kakusasani kwize chokuhwera. ");
INSERT INTO sbs_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Vazuhi vavali kusaka inzira yo kutiyira chisepe mi chiva sumunwina kato zana mwi wate, ni kupanga uvu vasaka ku zindira ikora mwi wate kuvusu vwe tusi. ");
INSERT INTO sbs_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Kono Paulusi cha wambira muyendisi wa masole ni masole, “Mbwita ava vakwame chive kala mu chisepe, kase muwole ku hazwa.” ");
INSERT INTO sbs_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Cwale masole chiva kosola mihala ya kasepe zana ni kukasiya ka kuke. ");
INSERT INTO sbs_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Cwale izuva halivali kuñatula, Paulusi chava kumbira vonse kuti valye zilyo, Chati, “Ili izuva de kumi ni minwe yo ne ni mulindire mi kamuli; kakwina chimwi chimwalya. ");
INSERT INTO sbs_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Cwale ni mi kumbira kuti mulye chimwi, kakuti ichi cho kuhala kwenu; imi kakwina nanga lusuki lonke lwe mitwi yenu lwese luzove.” ");
INSERT INTO sbs_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Hacha manite kuwamba izi, cha hinda vuroto ni kulitumera kwe Ireeza havusu bwa vantu vonse. Mi cha chi jamona chikwa ni kutanga kulya. ");
INSERT INTO sbs_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Imi vonse vava susuwezwa mi hape chiva hinda zilyo. ");
INSERT INTO sbs_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Tuvali kwina 276 vantu muchi sepe. ");
INSERT INTO sbs_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Hachi vamanite kulya kwikuta, chiva zwisa zi lema muchisepe cho ku zindira zikwa zavo mumenzi. ");
INSERT INTO sbs_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Hachili ñatwire inzuva, kena vava lemuhi icho chivaka, kono vavoni irizo ni kamba, mi chiva kandekisana kambe vawola kutwala chisepe hateni. ");
INSERT INTO sbs_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Mi civa kosola mihara ikwete akori ni ku zisiya mwi wate. Mwi nako iswana chiva sumununa mihara akwete mapuranga oku sikululisa chisepe ni kuzimika i seiri ikando kuluhuho; mi chiva liva he rizo. ");
INSERT INTO sbs_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Kono chiveza hachi vaka aho mezi u kwimbali zovere avali kukopanera, mi chisepe chicha mina kuya hansi, ni tako lye chisepe chilya kakatira hateni ni kushala kusa woleka kuzwa ho ni kuchoka lyo kuvusu, kono chisepe chicha tanga kuñatoka vakeñi cha mandinda avali kukalihite. ");
INSERT INTO sbs_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Mulero wa masole ubali okwihaya vasuminwa iri kuti kanji kuwaniki yo wola kusamba ni kulovoka. ");
INSERT INTO sbs_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Kono mukulwana wa masole avali kusaka ku haza Paulusi, imi cha kanina muhupulo wavo; mi cha layera avo vavali kuwola kusamba kuti va chirukire mumezi ni kusambira kwi rizo. ");
INSERT INTO sbs_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Cwale vakwame vonse muve chilire, vamwi ha mapuranga, vamwi hanzimwi zintu zi chimboka zina muchisepe. Mweyi inzira chikwa wanika kuti tuvonse tuva kasiki hande herizo. ");
INSERT INTO sbs_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Hatuva letwa siinte vulyo, tuva lituti kuti chiwoli chiva kusupwa Maluta. ");
INSERT INTO sbs_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Vaantu vasecho chilalo nivaha kwetu isi ka chisemo cha vulyo vulyo, kono vava muniki mulilo ni kutu tambula twense, chevaka lya vungi vwe nvula ni mpeho. ");
INSERT INTO sbs_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Kono linu Paulusi ha kunganya zisamu ni kuzi vika ha mulilo, chihiri nica bbuluka kevaka lyakuhisa, ni ku lizingila kwiyanza lyakwe. ");
INSERT INTO sbs_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Vene vecho chilalo hava vona chinyolozi chidenga kwi yanza lyakwe, nivacho ku zumwi ni zumwi, “Uzu mukwame kanti mwihayi yavaka lovoki kwi wate, kono mulao kana uvali kumu zuminina ku hala.” ");
INSERT INTO sbs_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Kono cwale na zukutwila nyolozi mumulilo imi kana ava holofali. ");
INSERT INTO sbs_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Vavamu lindile kuti eezule ifivere kamba kufwa. Kono havamana kumulolelela inako inde ni kuvona kuti kakwina chivonahala vuvi kwali, niva chincha minahano yavo ni kuta kuti nji Ireeza. ");
INSERT INTO sbs_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Haho muchivaka china hafuhi kuveena inkanda zavakulwana vachiwoli, mukwame yava kusumpwa Pabuliyusi. Naatu tambula nikutu lela mazuva otatwe. ");
INSERT INTO sbs_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Iva chitahali kuti isi wa Pabuliyusi ava ku lwazikwa ifivere ni musululo. Paulusi hayenda kwali, avalapeli, kuvika mayanza akwe hali, ni kumu hoza. ");
INSERT INTO sbs_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Hakumana ku chitahala ichi, vaantu voonse vamu chiwoli vava kulwala navo chiveza nikwiza kuhozwa. ");
INSERT INTO sbs_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Vaantu hape nivatu kuteka chamikutekero mingi. Hatuva kulitukiseza ku zuha, niva tuha zituvali saka. ");
INSERT INTO sbs_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Hakuhita myezi yotatwe, nitwa zuhila muchisepe cha Alezandiriya, chivena hamaliha kuchiwoli, chiva kuswana sina mambili. ");
INSERT INTO sbs_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Hatuka siika mumuleneñi Sirasuse, tuve kalimo mazuva otatwe. ");
INSERT INTO sbs_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Kuzwaho chitwa zuha nikuka sika mumuleneñi wa Regiyumu. Hakumana luzuva lonke luhuho luzwa kuvumonso nilwa huunga, mumazuva overe nitweza kusika mumuleneñi wa Putewoli. ");
INSERT INTO sbs_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Umo tuvaka wani baswisu bazalwa hamwina imi vava memetwe kwikala navo mazuva ahinda iyanza niovere. cheyi inzila nitweza kusika kwa Roma. ");
INSERT INTO sbs_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Kuzwaho vantu vazalwa hamwina, hava zuwa zetu, niveza kutu katana kusika KuMusika wa Apiyusi ni Ku Mitaveni yotatwe. Paulusi havona vazalwa hamwina, nalitumera kwa Ireeza ni likoza. ");
INSERT INTO sbs_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Hatwinjila mwa Roma, Paulusi ava zumininwe kuhala kachakwe ni valwi venkondo vavaku mugantela. ");
INSERT INTO sbs_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Imi nikweza hakuti hakumana mazuva otatwe Paulusi nasumpa hamwina avo vakwame vavali vayendisi kuma Juda. Haveza hamwina, nacho kuvali, “Bakwangu, nihanisana niva pangi zisalukite kuvantu kamba kumulao uvesikulwenu, nivaletwa chakuva musuminwa kuzwa kwa Jerusalema mu mayanza avaRoma. ");
INSERT INTO sbs_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Hava mana kuni vuza impuzo, niva tabela kuni lukulula, kakuli kana kuveena livaka mwangu kuatulelwa kwihayiwa. ");
INSERT INTO sbs_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Imi cwale maJuda havatanga kuwamba kusandukila intakazo zavo, china hambilizwa kuka kumbila kwa Sizare, nihaikenge kahena kuti kuvali kunyansa chisi changu. ");
INSERT INTO sbs_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Chakuya che nkupo yangu, linu, nakumbiila kukuvona kuti ni wambe nawe. Ivaka lyakuti Isiraere iina insepo yakuti ni kakatiile mumahaka. ");
INSERT INTO sbs_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Linu nivaacho kwaali, “Kana tuva tambuli mañolo akazwa kwa Judea kuamana nanwe, imi kakwina nanga mukati kenu muzwale yava kezi kuviha kamba kuwamba chintu chivi kuamana nenwe. ");
INSERT INTO sbs_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Kono ni saka kuzuwa kwenu mumu hupulela kwechi chiyemba, kakuli kwi zivehele kwetu kuti chiwambitwe kuhi no kuhi.” ");
INSERT INTO sbs_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Hava mana ku lukisa izuva lyakwe, vaangi vaantu vava kezi ku munzi kwa vali kuhala. Cha tambika indava kuvali, niku wamba za vulotu bwa Muvuso wa Ireeza, nalika susweza kuamana ni Jesu, vonse vaku mulao wa Mushe niku vaporofita, kuzwa kuseni kutwala chitengu. ");
INSERT INTO sbs_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Vamwi baba zuwisisi chazitu ziva wambiwa, imi vamwi kena vava kuzumina. ");
INSERT INTO sbs_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Hava sana vava lizumini mukati kavo, niva yenda Paulusi hamana vulyo kuwamba ili liinzwi lyonke. “Luhuho Lujolola luva wabi initi cha muporofita Isaya kuve sikulwenu. ");
INSERT INTO sbs_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Nacho,”'Uyende kwava vaantu nikukati, chaku zuwa kamuzuwe, konokete muzuwisise; Niku vona kamuvone, imi kete muvoniseze. ");
INSERT INTO sbs_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Mukuti inkulo yava vaantu chiya voola hansi, Matwi avo chi azuwa chavukavo, vava zimi menso avo; nikuzuwa cha matwi avo; kavati chi tambula cha meenso avo, ni kuzuwa cha matwi avo, niku zuwisisa che nkulo zavo, ni ku sanduka hape, nikuti kani va hoze.” ");
INSERT INTO sbs_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Chovulyo, iwe wizive kuti impuluso ya Ireeza chi iva tuminwa ku machava, imi muva zuwe. ");
INSERT INTO sbs_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Hamana kuwamba, maJuda nivaliyendela, nivava ni inkaani mukati kavo vene. ");
INSERT INTO sbs_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Paulusi avahali zilimo zovele munzubo yakwe ya kulihila, nikuti avali ku tambula vonse vavali kwiza kwaali. ");
INSERT INTO sbs_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Avali ku ruta muvuso wa Ireeza ni ku ruta zintu kuamana ni Simwine Jesu Keresite cha kuli tombola konse. Kakwina yava kumuzimika. ");
INSERT INTO sbs_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Paulusi, muhikana wa Jesu Kreste, yava sumpwa kuva mu Apositola, niku kauhanyezwa hembali che ivangeli ye Ireeza. ");
INSERT INTO sbs_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Iyi nje ivangeli yava sepisi inako ni seni kusika ca ma porofita mumanolo a njolola. ");
INSERT INTO sbs_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Ku amana ni mwanakwe, yava zalwa kwi shika lya Davida chokuya ke nyama. ");
INSERT INTO sbs_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Cho kuvuka ku vafwile, ave zibahazwa kuva iye Mwana we Ireeza we ziho cho Luhuho loku jolola- Jesu Kreste Simwine wetu. ");
INSERT INTO sbs_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Chakwe tuva hewa chishemo ni vu apostola cho kusepahala kwe ntumelo mwi fasi lyonse, chevaka lye zina lyakwe. ");
INSERT INTO sbs_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Mukati kezi inkanda, nanwe vulyo muva sumpwa kuti muve kwa Jesu Kreste. ");
INSERT INTO sbs_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ilyi ñolo njilyavo vonse vena mwa Roma, va sakiwa ve Ireeza, va sumpwa kuva vantu va jolola. Chishemo chive kwenu, ni nkozo izwa kwe Ireeza Ishetu ni Jesu Kreste. ");
INSERT INTO sbs_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Chentanzi, ni litumela kwe Ireeza ka Jesu Kreste henu muvonse, kakuti i ntumelo yenu ya wambwa mwi nkanda yonse. ");
INSERT INTO sbs_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Kaho Ireeza impaki yangu, ini seveleza mu Luho lwangu mwi evangeli ya mwana, muni zwile havusu kuwamba zakwe. ");
INSERT INTO sbs_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Inako ni nako ni kumbilanga mwi ntampelo zangu kapa mwinzila yonse kumamani mani nive yo zwila havusu hanu ke ntato ye Ireeza mwikwiza kwenu. ");
INSERT INTO sbs_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Kaho ni tavela kukuvona, kuti ni mihe mupuzo za Luhuho, kuti ni mikolise. ");
INSERT INTO sbs_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","China njichi, ni nungwa kuva yo susuwezwa mu kati kenu, ke ntumelo yetu tu vonse, yenu ni yangu. ");
INSERT INTO sbs_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Hanu kani saki kuti kanzi muvi va sezivite, va kwaangu, kuti niva kusakanga kwiza kwenu, kono niva vinditwe haisi hanu. Niva kusaka izi kuti muve ni miselo mukati kenu sina hamwina mukati ka machava. ");
INSERT INTO sbs_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Ni mukoroti hamwina kuma Greeki mi niku mazwahule, hamwina kuvena vutali niva holo. ");
INSERT INTO sbs_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Cwale kwangu, nilitukise kuwamba evangeli nikwenu mwina mwa Roma. ");
INSERT INTO sbs_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Kaho kani swaveli evangeli, kaho manta a Ireeza ye mpuluso ya vantu vonse va zumina, kaho ma Juda chetanzi ni ma Greeki. ");
INSERT INTO sbs_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Kaho mwateni kujolola kwa Ireeza kuli vonahaza kwi ntumelo ni ntumelo, sina mwiva ñolelwa, “Va jolola kava hale che ntumelo.” ");
INSERT INTO sbs_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Kaho ku venga kwe Ireeza kulivonahaza kuzwa kwi wulu kwavo vasali ve Ireeza niku vantu vasa jololi, avo mukusa jololi va kakatiza vuniti. ");
INSERT INTO sbs_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Ilyo njivaka kuti icho chiziveka kwe Ireeza chivoneka kwavo. Kaho Ireeza avavahi iseli. ");
INSERT INTO sbs_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Kaho zisa voneki zakwe zivoneka hande kuzwa fela hakuvubwa kwe nkanda. Zi zuwahala che zintu ziva vubwa. Izi zintu nji manta akwe okuya kwile ni mukwa wakwe mulotu. Che nkalavo, ava vantu ka vena mavaka. ");
INSERT INTO sbs_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Ili njivaka, nanga havava kwizi ze Ireeza, kena vava munyamuni chokuva Ireeza, kapa kulitumela kwali. Kono, vavavi zihole mu mihupulo yavo, mi inkulo zavo zi sena mano yavo iva vikwa mwi fifi. ");
INSERT INTO sbs_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Vava kulihinda kuti vena vutali, kona vava sanduki kuva zihole. ");
INSERT INTO sbs_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Vava lichinchi inkanya yoku samana Ireeza cho kuswana chiswaniso yo kumana kwa muntu, ya zizuni, ni zivatana za matende yone, nizi kokova. ");
INSERT INTO sbs_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Cwale he Ireeza ava vahi kwavo ve ntakazo mwinkulo zavo chokusa jolola, kuti mivili yavo kanzi ikutekwa mukati kavo. ");
INSERT INTO sbs_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Njivona vava chinchi initi ye Ireeza cha mapa, mi vava lapeli niku seveleza chiva vumbwa kusiya yava zivumbi, ya hewa intumbo kuya kwile. Amen. ");
INSERT INTO sbs_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Ke vaka lyechi, Ireeza avava siyi va yende che ntakazo zi swavisa, kaho vanakazi vava chinchi muvekalile kwecho chisa swaneli. ");
INSERT INTO sbs_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Cho mukwa uwo, va kwame va siya mulawo wavo ku vanakazi nikuhya mwi ntakazo zavo kuhamwina. Ava va kwame vava pangi zintu isali njizona ni vamwi va kwame, mi vava amuheli mupuzo wavo kuzivavapangi. ");
INSERT INTO sbs_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Kakuti kena vava zuminizi kuva ni Ireeza mukapanga kwavo, avavahi ku muhupulo ulyangene, njokuti va pange zintu zisena hande. ");
INSERT INTO sbs_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Vava kwizwile kusa jolola, kuva ni lunya, ni ntakazo, ni vuvi. Vezwile muuna, impulayo, inkani, kuchenga, ni zintu zivi. ");
INSERT INTO sbs_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Vasoha, vanyefuli, niva toyete Ireeza. Zi vangama, vena mwipo, vali nyamona. vatendi va zintu zivi, mi kave chilili va shemi vavo. ");
INSERT INTO sbs_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Kavena inkutwisiso; kena voku sepa, kavena irato, mi kavena chishemo. ");
INSERT INTO sbs_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Va zuwisisa inkatulo ye Ireeza, kuti avo va tenda izo zintu va swanela ifu. Kono kena kuti va panga izi zintu, va zuminiza ni vamwi va panga izi zintu. ");
INSERT INTO sbs_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Cwalehe, kamwina mavaka, iwe muntu, inwe mu atula, kecho chimu atula muzumwi nanwe muchili atula muvene. kaho inwe mu atula mupanga zintu zi swana. ");
INSERT INTO sbs_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Kono twizi kuti inkatulo ye Ireeza iyenda che niti haiwila kwavo va panga izo zintu. ");
INSERT INTO sbs_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Kono umamele ichi, iwe muntu, iwe u atula avo va panga izo zintu nawe nopanga zintu ziswana. Kowole kulovoka inkatulo ye Ireeza? ");
INSERT INTO sbs_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","kapa muhupulela hanini ke chifumu cho vulotu vwakwe, nikuha inkoto kwakwe kuliyehete, ni nkulo yoku lindila? Kamwizi kuti vulotu vwakwe vokuti amitwale mwinila yokuvaka? ");
INSERT INTO sbs_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","kono njikuva wina vukukutu niku savaka kwe nkulo kuti ulivikila iwe mwine kuvenga kwe zuva lyo kuvenga, icho njikuti, izuva lyokwiziveka kwe nkatulo ye Ireeza i jolola. ");
INSERT INTO sbs_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Kahe ku muntu ni muntu chokuya ke inkezo zakwe: ");
INSERT INTO sbs_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","kwavo va tundamina, mitendo milotu ya wana intumbo, ikute, nikusa lyanganiswa, kahe vuhalo vo kuya kwile. ");
INSERT INTO sbs_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Kono kwavo vali ngana avo vene, vase chilili initi kono ve chilila kusa chena, vuvengi vusa mani niku venga kavwize. ");
INSERT INTO sbs_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Ireeza kalete manyando ni kufilikana haluhuho lya muntu ni muntu yava pangi chivi, kuma Juda sapili, niku ma Greeke hape. ");
INSERT INTO sbs_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Kono intumbo, ikute, ni nkozo kazize ku muntu yense ya panga zilotu, kuma Juda sapili, niku ma Greeke. ");
INSERT INTO sbs_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Kaho kakwina kuketela muntu kwe Ireeza. ");
INSERT INTO sbs_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Kaho vangi va panga chivi mi hape kava mane nikusena mulao, mi nikuvangi vava pangi chivi niva kuteka mulao kava atulwe cho mulao. ");
INSERT INTO sbs_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Kakuti kena vateki vo mulao vavikitwe kuluka havunsu bwe Ireeza, kono javo fera vapangi vo mulao vasane kava hewe kuluka. ");
INSERT INTO sbs_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Kakuti vamachava, vasena mulao, vapanga che mukwa wavantu zintu zomulao, avo, vali mulao kuvali vene, nagati kuti kavena mulao ");
INSERT INTO sbs_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Chezi vatodeza kuti zitu zisakiwa kumulao ziñoletwe munkulo zavo. Minahano yavo nayo ipaka vulyo kuvali, mi mihupulo yavo kuiva nyazi kamba kuva zimanina kuvali vene ");
INSERT INTO sbs_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","mi nikwa Ireeza vulyo. Icho kachipanga hale mwelyo izuva aho Ireeza hasane ka atule inkunutu zavantu vonse, chokuya ke evangeli yangu, chukuya ka Jesu Keresite. ");
INSERT INTO sbs_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Mwendi hamwi mulisupa kuti muma Juda, mupumwira hamulao, kusangwa chokuli kumusa mwe Ireeza, ");
INSERT INTO sbs_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","kwiziva chasaka, ni kulika zintu zishutana kuzili, kasamulaho wo kutondeziwa kumulao. ");
INSERT INTO sbs_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Mi mwendi mwina inwe muvene nji muyendisa chivofu, iseli kwavo vena mwififi, ");
INSERT INTO sbs_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","musikululi we zihole, mi nihakuli kuti mwina mumulao mukwa we ngana nivu niti. ");
INSERT INTO sbs_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Inwe, linu, varuta vamwi, kamuli ruti inwe muvene? Inwe mukutaza kuti kanji muyivi, muyiva? ");
INSERT INTO sbs_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Inwe muwamba kanji mupangi vushahi, mupanga vushahi? Inwe muyansa maswaniso, muyivira itempere? ");
INSERT INTO sbs_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Inwe mulikumuseza kunyakalala mumu lao, kana munyasa Ireeza choku chola mulao? ");
INSERT INTO sbs_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Kuti “inzina lye Ireeza linyasahala mukati kava Machava vakeñi chenu,” sina yovulyo mulivañolerwe. ");
INSERT INTO sbs_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Kakuti mupato chovuniti umi wanisa haiva nimwi chilira mulao, kono haiva umucholi wo mulao, mupato wako usanduka kusava mupato. ");
INSERT INTO sbs_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Haiva, lyahanu, muntu yasena mupato ne chilira inswanero zo mulao, kete kuve kuti kusaya mumupato kwakwe kuvoneke uvu yavayi mumupato? ");
INSERT INTO sbs_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Iri ivaka lyokuta mwina mañolo a ñoletwe mi mupato hape jivo vasechilili vo mulao! ");
INSERT INTO sbs_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Kakuli kena Mujuda luli iyemwine hanze vulyo; mi mupato luli konji upangiwa hanze mwinyama. ");
INSERT INTO sbs_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Kono Mujuda njiyena mwine luli mukati, mi mupato jowuna we nkulo, muluhuho, isiñi cho muñolo. Kutembwa kozo uswana muntu kakuzwi kumuntu kono kwe-Ireeza. ");
INSERT INTO sbs_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Vulotu nzi Majuda vuva Kwete? Intuso nzi ina hamupato? ");
INSERT INTO sbs_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Inkando kuhi no kuhi. Chentanzi kuzonse, Majuda vava vikiwa manzwi azwa kwa Ireeza. ");
INSERT INTO sbs_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Cwale kambe Majuda kana vavena Intumelo? Nji kuti kusa zumina kwavo mukufosise ku sepahala kwa Ireeza? ");
INSERT INTO sbs_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Kenzi kuvi vulyo. Kono, musiye Ireeza a wanike kuva wina initi, Niha kuva kuti muntu ni muntu wina mapa. Sina hakuva ñoletwe, ili kuti muvoniswe kuluka mu manzwi enu, ni kukoma chimweza kuatulwa. ");
INSERT INTO sbs_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Kono heva kusa luka kwetu niku tondeza kuluka kwe Ireeza, tuwola kuwamba nzi? Kana Ireeza kalukite hanyandisa cha kuvenga? Niwamba cha kuya ka mano a muntu. ");
INSERT INTO sbs_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Sanzi nikuvi vulyo! Hakuva vulyo Ireeza ka watule vule inkanda? ");
INSERT INTO sbs_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Kono heva vuniti vwe Ireeza cha mapa angu vuleta kulumba Ireeza kusamani, chinzi hanisi atulwa kuva ni muezalivi? ");
INSERT INTO sbs_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Chinzi kusa wamba, sina hatuwambiwa cha mapa kuwamba, mi sina vamwi havazumina kuti tuwamba, “Tupange vuvi, nji kuti vulotu vwize”? Inkatulo havali ilukite. ");
INSERT INTO sbs_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Linu chinzi? Tulizwisa kuvamwi? Nanta. Chituva hambilizi kale ma Juda ni ma Gerike vonse, cha kuva mwi konde lya chivi. ");
INSERT INTO sbs_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Ichi china vuti kamuchi va ñolelwe: “Kakwina yolukite, nanga yenke. ");
INSERT INTO sbs_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Kakwina yo zuwisisa. Kakwina yogana Ireeza. ");
INSERT INTO sbs_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Vonse vava sanduki. Hamwina vava sanduki kusava ni ntuso. Kakwina yopanga vulotu, nanta, nanga yenke. ");
INSERT INTO sbs_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Mimino yavo ivita lyi yalukite. Malimi avo ava chengi. Chifanu che nzoka china kunsi ye milomo. ");
INSERT INTO sbs_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Tuholo twavo twizwile zikuto ni vuvi. ");
INSERT INTO sbs_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Matende avo mahuvilila kukwi tila malaha. ");
INSERT INTO sbs_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Insinyeho ni masukuluka zina mwi nzila zavo. ");
INSERT INTO sbs_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Ava vantu kaveni kwiziva inzila ye nkozo. ");
INSERT INTO sbs_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Kava tiyi Ireeza mumenso avo.” ");
INSERT INTO sbs_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Hanu chitwizi zonse ziuwamba mulawo, uwamba kuvena mwi konde lyamulawo. Ili nji vaka lyo kuta kuti tuholo tonse twi yale, ili kuti inkanda yonse ive ni vuikalavelo kwa Ireeza. ");
INSERT INTO sbs_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Chelyo ivaka kakwina muntu nihaiva yenke yete avikwe yo lukite cha mitendo ya mulawo mu menso akwe. Cha mulawo kwiza mano achivi. ");
INSERT INTO sbs_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Kono kunde ya mulao kulika kwa Ireeza kuve zivahanzwa. Kuva pakwa mulawo ni maporofita, ");
INSERT INTO sbs_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","uko, njikuluka kwe Ireeza che ntumelo kwa Jesu Kelesite ku vonse vazumina. kakuli ka kwina muva fapene. ");
INSERT INTO sbs_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Vonse vava pangi chivi ni kwiza kusa wana hande ikanya ya Ireeza ");
INSERT INTO sbs_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Vavikitwe cha kuluka feela cha chishemo chakwe cha kuhazwa kwina mwa Kelesite Jesu. ");
INSERT INTO sbs_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Ireeza ava leti Keresite Jesu kutiave chitavelo che ntumelo mumalaha akwe. Ava hi Keresite kuti a ve vupaki vo kuluka. kakuli kana va loli zivi ");
INSERT INTO sbs_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","zo kuma sule cha vuiswalo vwakwe. Izi ziva pangahali che mboniso zakuluka kwakwe mweinu inako. Izi zivena vuti ili kuti atondeze kuluka kwakwe, ni kutondeza kuti ushemuva zumwi ni zumwi che ntumelo ya Jesu. ");
INSERT INTO sbs_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Kulitemba kwina kuhi? kuvazwisiwa. Cho wuhi mulawo? Ya mitendo? Nanta, kono cha mulawo we ntumelo. ");
INSERT INTO sbs_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Tu kolwa kuti muntu uvikwa yo lukite che ntumelo nikusena mitendo yo mulawo. ");
INSERT INTO sbs_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Kapa Ireeza nji Ireeza wa ma Juda vulyo? Kapa kana njiyena Ireeza wa machava? Eni, wa machava navo. ");
INSERT INTO sbs_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Heva, initi, Ireeza yenke, vavayi mumupato kavapange valukite che ntumelo, ni vasena vavayi mumupato che ntumelo. ");
INSERT INTO sbs_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Nji kuti tumana mulawo che ntumelo? Kete ni kuve vulyo, Kono, tukoza mulawo. ");
INSERT INTO sbs_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Chizi cwale mutuwambe kuti Aburahama, isukuzwetu chokuya che nyama, avawani? ");
INSERT INTO sbs_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Kakuti haiva Aburahama ava shemuviwa che misevezi, navavi nevaka lyo kuwola kuli temba, kono isiñi havusu bwe Ireeza. ");
INSERT INTO sbs_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Kono awamba nzi mañolo? “Aburahama ava zumini Ireeza, mi ivavalirwa kwali kuva yo lukite.” ");
INSERT INTO sbs_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Lyahanu kwali yoseveza, ituwero zavo kazisupiwa uvu chishemo, kono uvu icho chava wana. ");
INSERT INTO sbs_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Kono kwali uzo yasa sevezi kono iye uzumina muyenke yo shemuva vapanga zivi, itumero yakwe avali uvu ilukite. ");
INSERT INTO sbs_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Davida naye ava wambi imbuyoti ha muntu kozo Ireeza wavala kuluka nikusena misevezi. ");
INSERT INTO sbs_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Ava wambi, “Imbuyoti javo zivi zavo ziva wonderwa, mi zivi zakwe za bwikwa. ");
INSERT INTO sbs_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Imbuyoti njo mukwame uzo Simwine kete avalire chivi.” ");
INSERT INTO sbs_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Linu inzi imbuyoti zivawambwa vulyo havo vavayi mumupato, kamba nikwavo vasana vavayendsi mumupato? Kakuti tuwamba, “Itumero ivava lirwa kwa Aburahama sina yolukite.” ");
INSERT INTO sbs_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Cwale ivavalirwa vule? Aho Aburahama havali mumupato, kamba naseni kuya mumupato? Kena ivali mumupato, kono naseni kuya mumupato. ");
INSERT INTO sbs_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Aburahama ava tambuli chisupo cho mupato. Ichi ivali iswayo lyo kuluka lye tumero iyo yavali kukwete kale aho naseni kupangiwa mupato. Mamanisezo echi chisupo ivali kuti avezi kuva isi wavonse avo vazumina, nangati kuti vena mukusaya mumupato. ");
INSERT INTO sbs_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Ichi kutalusa kuti kuluka muku valilwe ku vali. Iyi italusa kuti Abrahama avezi kuva isi wo mupato kwavo veza isiñi fela kwavo vakwazwa ku mupato, kono nikwavo ve chilila mihato ye shetu Abrahama. Mi iyi nji ntumeloyava kwina nayo kuvava seni va panga mupato. ");
INSERT INTO sbs_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Kaho kena ivali cho mulao kuti insepiso iva hewa kwa Abrahama niku vana vakwe, iyi nsepiso kuti kavave va yoli ve nkanda. Kono, ivali choku kuluka kwe tumero. ");
INSERT INTO sbs_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Lyahanu haiva avo vawira kumulawo vayoli, itumero ipangitwe mukungulu, mi isepiso chiyavuzwa ziho. ");
INSERT INTO sbs_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Kakuti mulawo uleta vukali, kono aho hasena mulao, kamba kuva ho kusechilira. ");
INSERT INTO sbs_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Cheli ivaka ichi chivapangahali che tumero, iri kuti iwole kuva che chishemo. sina mamanikizo, isepiso jovu niti luli ku lusika lonse. Mi ululusika kaluhindilire isiñi vulyo avo vezi mulao, kono vulyo navo vazwa kwi tumero ya Aburahama. Kakuti ji shetu tuvonse, ");
INSERT INTO sbs_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","sina haiñoletwe, “Niva kupangi isi we kanda zingi.”Aburahama avali kwina havusu bwakwe uzo wava sepete, ili uzo, Ireeza, uha vuhalo kuva fwire niku supa zintu zisakwina kuku va kwateni. ");
INSERT INTO sbs_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Nihakuva vulyo onse masukuluko ahanze, Aburahama chovundume ava sepete Ireeza kuzo kuvusu. Cwale cheza kuva isi wekanda zingi, chokuya kwecho chiva wambwa, “Ilyo jeteve ishika lyako.” ");
INSERT INTO sbs_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Kena avali ku fokola mwitumero. Aburahama avazuwisisi kuti muvili wakwe iyemwine kena uvali kuwola kuva ni mwana (kakuti chavali we zirimo zo mwanda zava hali). Hape avazumini kuti ivumo lya Saara kena livali kuwola kuhinda mwana. ");
INSERT INTO sbs_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Kono chevaka lye sepiso ze Ireeza, Aburahama kena ava hakanyehi mukusa zumina. Lyahanu, avali kukozetwe mwi tumero ni kuha milumbeko kwe Ireeza. ");
INSERT INTO sbs_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Avali kuzumine luli kuti icho Ireeza cha va sepisi, naye ava woli kwizuzirikiza. ");
INSERT INTO sbs_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Hakwina vulyo ichi nacho chiva valilwa kwali uvu yo lukite. ");
INSERT INTO sbs_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Lyahanu kena ziva ñolerwe chevaka lyazasa wane, izo zivavalirwa kwali. ");
INSERT INTO sbs_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Ivali kuñolelwe vulyo ni kwetu, kwavo vete ivalilwe, iswe tuzumina mwali uzo yava vusi Jesu Simwine wetu kwavo vafwire. ");
INSERT INTO sbs_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Uzu jiyena avali kuherwe chezivi zetu mi ava vuswa kutu panga vashiyeme. ");
INSERT INTO sbs_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Linu bulyo tutendetwe bashiyeme chetumelo, twina inkozo ni Ireeza ka mfumwetu Jesu Kreste. ");
INSERT INTO sbs_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Chakwe hape tuwola kuwana itumelo mwe chishemo chituzimene kuchili. Tusanga chesepo yatuha Ireeza mukuya kubusu, isepo yete ni tuli yabele mwi kanya ya Ireeza. ");
INSERT INTO sbs_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Nanta kanjezi bulyo, kono tusanga ni mumasukuluko etu. ");
INSERT INTO sbs_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Twizi kuti masukoluko aleta kulikoza. Kulikoza kuleta kusepahala imi kusepahala kuleta isepo yaku busu. ");
INSERT INTO sbs_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Iyi isepo kaileti maswabisisa, mukuti ilato lye Ireeza libe tiwa mwi nkulo zetu che Luhoho Lujolola, luba hewa kwitu. ");
INSERT INTO sbs_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Munako hatusana tubena ziho, chenako iswanela Kreste aba fwile basazuni ze Ireeza. ");
INSERT INTO sbs_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Kokutalusa kuti, kukabo kuti zumwi awole kufwila zumwi muntu yoshiyeme. Njichona ichi, mwendi zumwi mwa sake kufila muntu yoshiyeme. ");
INSERT INTO sbs_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Kono Ireeza a batondezi ilato lyekwe kwetu, mukuti hatubachili batendi chive, Kreste aba tufwili. ");
INSERT INTO sbs_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Kuekeza aho, linu, hahanu kakuli tobajolozwa cha malaha akwe, katuba tupulwiswe chawo kubukali bwe Ireeza. ");
INSERT INTO sbs_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Kakuli heba kuti, atubachili tuzila, tubabozinsani inkulo ni Ireeza chefu lya mwanakwe, kuekeza hezo linu, hatumana kuba babozinsene inkulo, kana katube ba pulwise chebuhalo bwako. ");
INSERT INTO sbs_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Isiñi cho bulyo, kono tusanga hape ni Ireeza cha Simwine wetu Jesu Kreste, chakwe tuba tambuli kubozinsana kwe nkulo. ");
INSERT INTO sbs_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Nihakwina bulyo, chive muchibe njilili muchisi cha mutu yenke, cheyo inzala ifu libenjili che chive. Imi ifu nilya hasana kubantu bonse, mukuti bonse babatendi chive. ");
INSERT INTO sbs_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Kulindila kutwala haisi mulao, chive chibena muchisi, kono kana kubena kuli zuminina chive kokuti kakwina mulao. ");
INSERT INTO sbs_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Nahakuba bulyo, ifu liba kuyendisa kuzwa kwa Adama kuya kwa Mushe, nanga abo basana baba tendi chive ubu nji Adama chokubula ikute kwakwe, yabali mutala wozo lyaba kwiza. ");
INSERT INTO sbs_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Kono ni hakuba bulyo, impo yakuhewa bulyo kaikoli ubu kuluta mulao. Mukuti che mwilandu ya yenke bangi baba fwi, nihakulibulyo zingi zibatendwa kechishimo che Ireeza imi ni mpo ka chishemo cha muntu umwina, Jesu Kreste, chi njihile bangi. ");
INSERT INTO sbs_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Mukuti impo kaikoli ubu chintu chizwa kuchatendwa muntu watenda chive. Munzila imwi, inkutulo yaku nyanswa ibakezi chebaka lya chive cha muntu umwina. Kono munzila imwi, impo itubahewa bulyo ibezi cha kubonisa buniti mumasule ezive zingi. ");
INSERT INTO sbs_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Mukuti haiba, cha chive cha muntu umwina, ifu liba busi cha muntu umwina, kuekeza aho kana bana bete bawane kwinjiha kuamana ni mpo ya chishemo imi impo yakuluka ibusa cha buhalo bwa umwina, Jesu Kreste. ");
INSERT INTO sbs_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Linuhe, cha chive cha umwina bonse bantu baba atulwa, ni hakuba bulyo cha mutendo wonke wa chishemo uba lite intukuluho yabuhalo bwa bantu bonse. ");
INSERT INTO sbs_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Mukuti chokubula inkutwiso kwa muntu umwina bungi bwabo baba babatendwa batendi bazichive, ni hakuba bulyo che nkutwisiso yamuntu umwina bungi bwabo baba tendwe basheyeme. ");
INSERT INTO sbs_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Kono mulao uba kezi bulyo nawo, mukuti chive pona chi wole kwi njiha. Kono hena chive chingi, chishemo chi kanduha ni kuhitiliza. ");
INSERT INTO sbs_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Izi ziba tendahali mukuti, ubu chive hachiba busi mwifu, Nikuba bulyo chishemo pona chiwole kuyendisa cha busakusima mubuhalo bukeza ka Jesu Kreste Simwine wetu. ");
INSERT INTO sbs_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Linu katutende chihi? Kana tuzwile habusu mu chive ili kuti chishemo chitwinjihile? ");
INSERT INTO sbs_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Sanzi kubi bulyo. Iswe tubafwili muchive, chinzi hatusiwola kuhala muchili? ");
INSERT INTO sbs_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Naa kuti katwizi kuti bonse baba kolobezwa mwizina lya Jesu Kreste baba kolobezwa ni mwifu lyakwe? ");
INSERT INTO sbs_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Tuba zikiwa, linu, naye chenkolobezo ye fu. Ichi chibatendahali kebaka lyakuta kuti Kreste aba buki kuba fwile ke kanya ya Tayo, linu naswe tuswanela kuhala buhalo buhya. ");
INSERT INTO sbs_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Mukuti heba chitwakopana naye mukutabela ifu lyakwe, mutu kakopane hamwina nimwi nzuho yakwe. ");
INSERT INTO sbs_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Twizi izi, kuti zive zetu zonse ziba kokotelwa naye, kutendela kuti mubili we chive usinyiwe. Izi zibatendahali ili kuti sanzi tusebeliswa Chive. ");
INSERT INTO sbs_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Iye yabafwi natenda zilukite mukukuteka mu chive. ");
INSERT INTO sbs_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Kono haiba tubafwi ni Kreste, tuzumina kuti naswe mutuhale naye hamwina. ");
INSERT INTO sbs_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Twizi kuti Kreste ababuswa kubafwile, imi kasifwile. Ifu kalisibusi mwali. ");
INSERT INTO sbs_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Chobulyo kuamana nifu lyabafwi chalyo muchive, abafwi kamwina kuhindilila. Nihakuba bulyo, buhalo bwahala, uhala cha Ireeza. ");
INSERT INTO sbs_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","munzila iswana, nanwe mulibike mukufwila muchive, kono muhalile kwa Ireeza mwizina lya Jesu Kreste. ");
INSERT INTO sbs_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Chobulyo sanzi mulekeleli chive kubusa mumibili yenu ifwa ");
INSERT INTO sbs_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Sanzi mutambiki zilama zamibili yenu kuchive, kuti ibe zisebeliso zabana bapanga zisalukite. kono mulitambike kwa Ireeza, sina bafwile ba chibahala hanu. imi mutambike zilama za mibili yenu kwa Ireeza aipange zisebeliso zabana bapanga zishiyeme. ");
INSERT INTO sbs_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Sanzi mulekeleli chive kumiyendisa. kakuli kamuchihali cha mulao, kono chimwina mwikonde lye chishemo. ");
INSERT INTO sbs_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Kuti nzi linu? Naa mutupange chive kakuli twina mwikonde lya mulao, imi mwi konde lye chishemo? Keti kube bulyo. ");
INSERT INTO sbs_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Naa mwizi kuti mulibika mwikonde lya muntu kutenda za laela kakuba bulyo musanduka bahikana bakwe, iye imukuteka? Iyo initi kapa mubahikana ba chivi chimitwala kwifu, kapa bahikana bamamela zibatwala kuzishieme. ");
INSERT INTO sbs_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Imi tulitumela kwa Ireeza! Chobulyo inwe mubali mubahikana ba chive, imi mubazumini chenkulo zenu zonse nikwichilila kwi ntuto zimubalutwa zimubahewa. ");
INSERT INTO sbs_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Imi muba lukululwa kuchive, imi muba tendwa bahikana batenda zishiyeme. ");
INSERT INTO sbs_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Niwamba chamubili wabantu kebaka lya bufokoli bwa mibili yenu. Chamukwa uwo mubaneli zilama za mibili yenu kuba bahikana kuzintu zisashiyeme nimuzintu zibi, kamukwa uswana, Munele zilama za mibili yenu kuba bahikana batenda zishiyeme kutendela kuti mujolozwe. ");
INSERT INTO sbs_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Chobulyo hamubali mubahikana be chive, mubalukuluhite kumbali yazishiyeme. ");
INSERT INTO sbs_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Cheyo inako, miselo imubawani njeihi kuzintu zimubakutenda zichi zimiswabisa hanu? Imi mupuzo wezo zintu zonse ifu. ");
INSERT INTO sbs_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Imi mubalukululwa kuchive linu cheli mubahikana ba Ireeza, imi chimwina muselo wakujolola. Imi mupuzo buhalo busamani. Imi mupuzo we chive ifu, ");
INSERT INTO sbs_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","kono mupuzo wamahala wa Ireeza buhalo busamani mwi zina lya Jesu Kreste Simwine wetu. ");
INSERT INTO sbs_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Kapa kawizi, bakwangu (mukuti, nikwete kuwamba kubantu bezi mulao), mukuti mulao njoyendisa muntu inako yose yahala? ");
INSERT INTO sbs_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Mukuti mwanakazi yosesetwe usuminwa chamulao kwamwihyabwe hebanachihala, kono mukwame hafwa, chazwisiwa kumulao wamasenso. ");
INSERT INTO sbs_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Linuhape, cheyoinako mwihyabwe nachihala, heba nakahala ni wungi mukwame, kasupiwe musangu. Kono heba mwihyabwe ufwa, ulukuluhute kumulao, linu kena musangu, heba nakekala ni wungi mukwame. ");
INSERT INTO sbs_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Chobulyo, bakwangu, mubatendwa bafwile kumulao chamubili wa Kiriste. Ichi chitendahala bulyo kuti mubemubantu bonke, linuhe, kozo yababuswa kubafwile, kuti tubike zichelantu za Ireeza. ");
INSERT INTO sbs_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Mukuti hatubena munyama, itakazo zechive zibabusuluswa kubamwi bentu chamulao kuleta zichelantu kukati ifu. ");
INSERT INTO sbs_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Konohanu tubalukululwa kumulao. Tubafwi kechina chibatusumine. Ichi china bulyo mukuti tusebeze mubuhya bwaluhuho imi isini mukusupala kweñolo. ");
INSERT INTO sbs_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Katuwambe nzi linu? Kana mulao uwo wine chive? Kanzi nikubebulyo hape. Nihakubabulyo, ninisana nibezibi chive, heba nikusana kubabi chamulao. Mukuti ninisana nibezibi kuti kulakaza chive hesi mulao hawuwamba, “kanzi ulakazi.” ");
INSERT INTO sbs_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Kono chive chiba hindi chibaka mumulao imi libaleti ilato lisali lyeniti kwangu. Mukuti hebakakwina mulao, chive chifwile. ");
INSERT INTO sbs_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Mwinako yimwi nibakuhala ni kusena mulao, kono mulao hawiza, chive chichahala, imi ime chinafwa. ");
INSERT INTO sbs_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Mulao ubakuleta kuhala ubaleti kufwa kwangu. ");
INSERT INTO sbs_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Mukuti chive chibawani chibaka mumulao, imi chibanichengeleli. Kakuya chamulao chibanihayi. ");
INSERT INTO sbs_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Chobulyo mulao ujolwele, ni taelo ijolwele, yinahande ni kushiyama. ");
INSERT INTO sbs_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Kana chilotu chibabi ifu kwangu? Kanzi ni kubi bulyo. Kono chive, chibatondezi bubi mukati kabulotu, kubaleti kufwa kwangu. Ichi chibabi bulyo kuya chamulao, chive chiwola kuba chintu chibi chisawolwi kupimwa. ");
INSERT INTO sbs_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Mukuti twizi kuti mulao luhuho, kono ime ninyama. Nibawuzwa kuti nibeni mutanga wechive. ");
INSERT INTO sbs_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Mukuti chonse chinitenda, kanichizuwisisi. Mukuti chonse chinisaka kutenda, kanichitendi, imi chinitoyete, nichitenda. ");
INSERT INTO sbs_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Kono heba nitenda chinisasaki, ni zuminzana ni mulao kuti mulao mulotu. ");
INSERT INTO sbs_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Kono hanu kaichili ime yozitenda, kono chive chihala mukati kangu. ");
INSERT INTO sbs_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Mukuti nizi kuti china kwangu, njichina munyamayangu, kakuhali chituchilotu. Mukuti itakazo yezilotu yina name, kono kaniwoli kuchitenda. ");
INSERT INTO sbs_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Mukuti zilotu zinisaka kutenda kanizitendi, kono zive zinisasaki kutenda, zinitenda. ");
INSERT INTO sbs_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Linuhanu haba nitenda chinisasaki kutenda, linu kayichili ime yochitenda, kono chive china name. ");
INSERT INTO sbs_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Niwana, linu, mazimo enakwangu akuti nisaka kutenda chilotu, kono chive initi china name. ");
INSERT INTO sbs_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Linu nitabela mulao we Ireeza ni muntu wina name. ");
INSERT INTO sbs_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Kono nibona mazimo angi muzilama zenyamayangu. Zilwisana ni mazimo aboko kwangu. Ziletwa kusuminwa kwa mazimo echive ena muzilama zenyamayangu. ");
INSERT INTO sbs_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Nimuntu yasena ituso! Njeni yese anizwise mowu mubili wefu? ");
INSERT INTO sbs_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Kono kulitumela kube kwa Ireeza ka Jesu Krisite Simwine wentu! Linuhanu, ime nimwine nisebeleza mulao wa Ireeza nengana. Nihakubabulyo, mwinyama nisebeleza mazimo echive. ");
INSERT INTO sbs_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Lyahanu kakwina ku atuliwa kwavo vena mwa Kresite Jesu. ");
INSERT INTO sbs_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Kakuti itayero zo Luhuho lo buhalo mwa Kresite Jesu iba ni sanduli yo lukuluhite ku milao ye chivi ni ifuu. ");
INSERT INTO sbs_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Kwecho mulao kena uva woli kuchipanga che vaka lyokuti kena uva kwina manta che nyama, Ireeza avakwina. ava tumini mwanakwe muku saka chivi che nyama kwiza ku munewila kuchivi mi ava atulu chivi mwi nyama. ");
INSERT INTO sbs_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Ava pangi izi kuti zitokwahala zo mulao zi wole kwi zuzilikizwa mwetu, iswe tuyenda isiñi che nyama, kono chokuya cho Luhuho. ");
INSERT INTO sbs_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Avo vahala chokuya che nyama va twaliza muhupulo kuzintu ze nyama, kono avo va hala chokuya ko luhuho va twaliza muhupulo ku zintu zo Luhuho. ");
INSERT INTO sbs_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Kaho muhupulo we nyana ifu, kono muhupulo we Luhuho vuhalo ni nkozo. ");
INSERT INTO sbs_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Iyi njikuti muhupulo we nyama ilwisa Ireeza, kaho kaimwina mumulao wa Ireeza, kapa iwoleka kuva. ");
INSERT INTO sbs_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Avo vena mwi nyama kavawoli kutavisa Ireeza. ");
INSERT INTO sbs_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Nihakuva bulyo, kamwina mwi nyama kono mu Luhuho, haiva initi kuti Luhuho lwe Ireeza luhala mwenu. Kono haiva zumwi kena Luhuho lwa Kreste, kavalilwa kwali. ");
INSERT INTO sbs_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Haiva Kreste wina mwenu, muvili ufwile cho kukuteka chivi, kono Luhuho luhala cho kukuteka kujolola. ");
INSERT INTO sbs_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Haiva Luhuho lwakwe yava vusi Jesu kuvafu lyi hala mwenu iye yava vusi Kreste kuvafu kamihe vuhalo mane ni mu mivili yenu cha Luhuho lwakwe, ya hala mwenu. ");
INSERT INTO sbs_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Cwalehe, vamukulwangu, tu korota, kono isike kwi nyama kahala chokuya ke nyama. ");
INSERT INTO sbs_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Kaho haiva muhala chokuya che nyama, china hafuhi nikufwa, kono haiva cha Luhuho mwihaya mitendo yo mivili yenu, kamuhale. ");
INSERT INTO sbs_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Kaho vangi va yendiswa Luho lwa Ireeza, ava vaana va Ireeza. ");
INSERT INTO sbs_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Kaho kena muva tambili Luho lo kusuminwa hape kuti mu tiiye. Kono, muva tambuli Luho lo kuañulwa, kowo utu lira, “Abba, Father!” ");
INSERT INTO sbs_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Luho ulo lyine luhindite vupaki ni luho lwetu kuti tuvana ve Ireeza. ");
INSERT INTO sbs_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Haiva tu vana, cwale tuvajovoli, va jovoli ve Ireeza. mi tuva jovoli hamwina ni Jesu, haiva luli tu nyanda naye njokuti tuka nyemunwe naswe naye. ");
INSERT INTO sbs_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Kaho ihinda kuti manyando eyinu inako ka swaneli ku vambañwa ni nkaya yete vonahazwe kwetu. ");
INSERT INTO sbs_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Kokusaka luli zintu zi livelelwe zo kuvumbwazilindile kuvonehala kwa vana va Ireeza. ");
INSERT INTO sbs_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Kaho kuvumbwa kuva kuketetwe, isike cho kusaka kwateni, kono kwali yava chiketi. Ina mukukola luli ");
INSERT INTO sbs_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","kuti kuvumbwa uko kwine kakuhewe kuzwa ku vukova ku vola, mi kailetwe mwi ntukuluho ye nkanya ya vaana ve Ireeza. ");
INSERT INTO sbs_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Kaho twizi kuti kuvumbwa konse kwina mukulira ni misevezi ichisa hamwina nanga hanu. ");
INSERT INTO sbs_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Isike fela izo, kono nanga iswe tuvene, vena miselo ye ntanzi yo Luho-nanga iswe tuvene tulivuza kukati ketu, kulindiza kuañulwa kwetu, kuwulwa kwe mivili yetu. ");
INSERT INTO sbs_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Kaho cho vundume vakwe tuva hazwa. Kono icho chituva ni vundume kuchili ka chipangahale ni chiseni kuvoneka, kaho kozo ulindiza kwecho cha vona kale? ");
INSERT INTO sbs_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","kono haiva tuva ni vundume kwecho chitusa voni, cwale tulindza ni nkulo inde kuchili. ");
INSERT INTO sbs_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Mwinzila iswana, Luho lutusa hape mutushekesha. Kaho ka twizi mutu swanela ku lapelera, kono Luho ulo lwine lyitu lapelera. ");
INSERT INTO sbs_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Iye yo saka wizi mihupulo ye Luhuho, kakuti utu lapelera muchivaka cha valumeli chokuya chentanto ye Ireeza. ");
INSERT INTO sbs_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Twizi kuti kwavo va saka Ireeza, useveza zintu zonse hamwina kuva vulotu, kwavo vava sumpwa chokuya kwali. ");
INSERT INTO sbs_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Kakuti kwavo va vezivi kale, avava hupuleli kale kuva chiswaniso cha mwanakwe, kuti avo we ntanzi mukati ka mizwale vakwe. ");
INSERT INTO sbs_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Avo vava hupuleli kale, avo avava sumpi hape. Avo vava sumpi, ava avava pangi ku jolola. Avo vava jolozi, avo hape avava nyemuni. ");
INSERT INTO sbs_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Chinzi hape chese tu wambe kuamana izi zintu? Haiva Ireeza nji wetu, njeni yo wola ku tilwisa? ");
INSERT INTO sbs_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","iye yasena va katwi mwanakwe kono ava muhi muchisa chetu, keta wole vule hape naye kutuha zintu zonse? ");
INSERT INTO sbs_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Yate lete kuhambiliza kwavo va keta Ireeza? Ireeza njiyena ya joloza. ");
INSERT INTO sbs_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","njeni yata watule? Kreste njiyena yava tufwili, mi niku hita izo, ava vuswa hape. Niyendisa ni Ireeza mu chivaka china ikute, mi njiyena yo tulapelera. ");
INSERT INTO sbs_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Njeni yasa tuzwise kwi rato lya Kreste? manyando, kapa inzala, kapa kusa zwata, kapa inkozi, kapa kasho? ");
INSERT INTO sbs_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Sina mwiñolelwe, “chokukoma kwako twihaiwa izuva ni zuva. tuva kuhindwa sina ingu iya kukwihaiwa.” ");
INSERT INTO sbs_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Mwezi zonse zintu tuvakomi mwali utusaka. ");
INSERT INTO sbs_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","kaho niva zumini kuti kapa ifu, kapa vuhalo, kapa ma ñiloyi, kapa mivuso, kapa zintu zina koo, kapa zintu zete zize, kapa manta, kapa vule, kapa vutungi, ");
INSERT INTO sbs_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","kapa chintu chimwi cha vumbwa, chete chi wole kuni zwisa kwi rato lya Ireeza, lyina mwa Kreste Jesu Simwine wetu. ");
INSERT INTO sbs_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Ni wamba vuniti mwa Kreste, kani chengi, mi muhupulo wangu uhindite vupaki name muluho lu Jolola, ");
INSERT INTO sbs_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","kuti kwangu kwina kulira kukando niku chiswa ku nkulo kusa mani. ");
INSERT INTO sbs_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Kaho ni sepa kuti ime ni mwine ni kutiwe nikuvikwa ku mbali kuzwa kwa kreste che vaka lya vamukulwangu, avo va mushovo wangu chokuya ke nyana. ");
INSERT INTO sbs_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Ma isilaele. vena ku añulwa, inkanya, chilikani, impo zo mulao, kulumbeka kwe Ireeza, ni nsepiso. ");
INSERT INTO sbs_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Va sukukulu vava sukulu kwava kazwi Kreste wa keza ni kute kwi nyama- Iye yali Ireeza konse. Alumbekwe kuya kwile. Amen. ");
INSERT INTO sbs_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Kono kena kuti insepiso za Ireeza za kanga. Kaho kena vonse vena mwa Isilaele vazwa mwa Isilaele. ");
INSERT INTO sbs_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","mane ni vaana va Abrahama vaana vakwe ve niti. Kono, “nji ka Isaac kuti vaana venu kava sumpwe.” ");
INSERT INTO sbs_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Icho njikuti, vaana ve nyama kena vaana ve Ireeza. Kono vaana ve nsepiso va vikitwe nji vaana. ");
INSERT INTO sbs_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Kaho ilyi nji linzwi lye nsepiso: “keyi nako munize, mi mwana kahewe kwa Sarah.” ");
INSERT INTO sbs_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Isiñi fela ichi, kono haisi Rebecca naye ava zalwa cha mukwame yenke, Ishetu Isaac- ");
INSERT INTO sbs_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","kaho vaana kena vavali kuzalitwe mi kena vava pangi chintu chilotu kapa chimbi, njokuti intokwahalo za Ireeza chokuya chokuli ketela chiwole kuzimana, isiñi cha mitendo, koho chevaka lyakwe yo sumpa- ");
INSERT INTO sbs_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","iva wambwa kwali, “mukulwana ka seveleze muhwile.” ");
INSERT INTO sbs_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","iswana sina muiva ñolelwa: “Jacovo niva kumusaka, kono Esau niva kumutoyete.” ");
INSERT INTO sbs_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Cwale he katu wambe nzi? kwina kusa jolola ni Ireeza? kanji ipangahali. ");
INSERT INTO sbs_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Kaho uwamba kwa Mushe, “kanive ni chishemo kozo yete ninive ni chishemo, mi kanive ni nkumbo kwali yete ninive ni kumbo.” ");
INSERT INTO sbs_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Cwalehe, kena kuti nji kwakwe we ntato, kapa iye yo mata, kono ivaka lya Ireeza, yo vonisa chishemo. ");
INSERT INTO sbs_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Kaho iñolo lyi wamba kwa Pharoah, “kelyi vaka niva kunyemuni, njokuti ni sondeze manta angu kwako, mi hape kuti izina lyangu lyive kuwambwa mwifasi lyonse.” ");
INSERT INTO sbs_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Cwalehe, Ireeza wina chishemo kwavo va saka, mi avo va saka, uvapanga kusa zuwa. ");
INSERT INTO sbs_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Kamuwambe cwalehe kwangu, “chinzi hasi wana zifoso? kaho yense ya vazimani he ntato yakwe?” ");
INSERT INTO sbs_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","kwimbali imwi, mukwame, njeweni witava havusu vwe Ireeza? kana china chiva vumbwa kachiwole kuwamba kozo yava chivumbi, “Chinzi hova ni pangi mwinzila umu?” ");
INSERT INTO sbs_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","muvumbi kena mulao hewulu lye tope kupanga kwi lambi iswana ni chivikilo cho musevezi wo vutokwa, mi ni chimwi chivikilo chokusevelisa izuva ni zuva? ");
INSERT INTO sbs_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Cwale haiva Ireeza, ya saka ku vonisa vukali niku panga manta akwe aziveke, ava lindizi ninkulo inde yo kuvika vukali vwakwe che nchanganiso? ");
INSERT INTO sbs_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Cwale kape ava pangi izi njokuti ezivahaze chifumu che nkanya yakwe mukati kezi vukilo ze chishemo, yava vikili kumasule inkanya? ");
INSERT INTO sbs_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Cwale kape ava chitupangili naswe, avo vava sumpi hape, isiñi fela mukati ka Majuda, kono hape niku ma Genitiles? ");
INSERT INTO sbs_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Sina ha wamba hape mwa Hosea: “kani sumpe vantu vangu vasena vavali vantu vangu, ni musakiwa wakwe yasena va kusakwa. ");
INSERT INTO sbs_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","mi kaive kuti kuiva ka wambwa kuvali iva wambwa kuvali, 'kena muvantu vangu; aho kavasumpwe' vaana ve Ireeza yo hala.'” ");
INSERT INTO sbs_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Isaya ulila Isilaele, “haiva i nombolo ya vaana va Isilaele iswana sina ivu lye wate, kaive za shala kwezo ziva hazwa. ");
INSERT INTO sbs_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Kaho Simwine mwahinde linzwi lyakwe he fasi, yahanu niku mana. ");
INSERT INTO sbs_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Mi iswana sina Isaya hava wambi, “haiva Simwine kena va siyi vaana ");
INSERT INTO sbs_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Katu wambenzi cwale? kuti ma Genitiles, kena vave chilili kuchena, kuchena kwe ntumero. ");
INSERT INTO sbs_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Kono Isilaele, vave chilili kuchena ko mulao, kena vava siki koo. ");
INSERT INTO sbs_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Ivaka ncinzi? kakuti kena vava ichilili che tumero, kono che misevezi. Vava nkumi hechwe lyokukuma, ");
INSERT INTO sbs_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","sina muivañolelwe, “lole, ni lele mwa Zion ichwe lyokukuma ni hechwe lya mafosisa. iye ya zumina muchili kete aswaviswe.” ");
INSERT INTO sbs_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Bamwangu, intakazo ye inkulo yangu ni inkupo yangu kwa Ireeza, kuhazwa kwabo. ");
INSERT INTO sbs_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Sina haniha bupaki kuamana nabo kuti bena inchiseho kwa Ireeza, kono isiñi chokuya che inzibo. ");
INSERT INTO sbs_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Kakuti kabezi kuluka kwa Ireeza, imi basaka kuzaka kuluka kwabo bene. Kena babali tuli kunsi yo kuluka kwa Ireeza. ");
INSERT INTO sbs_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Kakuti Kirisite nji mwi zuzilikizi wo mulao cho kuluka kwa zumwi ni zumwi yo zumina. ");
INSERT INTO sbs_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Kakuti Mushe uñola kuamana ni kuluka kuzwa ku mulao: “Muntu yo panga kuluka kwa mulao kahale cho ku kuluka.” ");
INSERT INTO sbs_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Kono kuluka kuzwa kwi intumelo kuwamba ichi, “Kanji u wambi mwi inkulo yako, 'Njeni yese akambame mwi wulu?' (cho kuti, kuleta Kirisite hansi); ");
INSERT INTO sbs_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","imi kanji uti, 'Njeni yesa shetumukile mwilindi lisena ma manimani?”' (cho kuti, ku zikula Kirisite kuba fwile). ");
INSERT INTO sbs_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Kono iwamba nzi? “Linzwi lina he mbali nawe, mukaholo kako imi ni mwi inkulo yako.” Ilyo nji linzwi lye intumelo, li tuwamba. ");
INSERT INTO sbs_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Mukuti haiba cha kaholo kako uwamba kuti Jesu nji Simwine, imi ni kuzumina mwi inkulo yako kuti Ireeza aba mubusi kuba fwile, kohazwe. ");
INSERT INTO sbs_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Kakuti che inkulo muntu uzumina cho kuluka, imi cha kaholo u lemuha cha kuhazwa. ");
INSERT INTO sbs_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Kakuti iñolo liwamba, “Yense yo zumina kwali kese na swabiswe.” ");
INSERT INTO sbs_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Kakuti kakwina inshutano mukati ka Mujunda ni Mugerike. Kakuti Simwine uswana nji Simwine wa bonse, imi ufumite kubonse basumpa kwali. ");
INSERT INTO sbs_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Kakuti yense yo sumpa he zina lya Simwine ka hazwe. ");
INSERT INTO sbs_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Cwale linu kaba sumpe bule kwali ubasena ba bazumini? Mu ba zumine bule mwali ibasena ba bazuwi? Mu ba zuwe bule nikusena mukutazi? ");
INSERT INTO sbs_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Cwale kaba kutaze bule, kwanda haba tumwa? Sina mukuñolelwe, “Malotu bule mantende abo bawamba makande a zintu zi lotu!” ");
INSERT INTO sbs_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Kono bonse kena ba tekelezi kwi ivangeli. Mukuti Isaya uwamba, “Simwine, njeni ya ba zumini iñusa lyetu? ");
INSERT INTO sbs_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Linu intumelo iza cha kuzuwa, imi ni kuzuwa cha linzwii lya Kirisite. ");
INSERT INTO sbs_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Kono ni wamba, “Kana baba zuwi?” Eee, cho buniti. “Mulumo wabo ubayendi mwi inkanda zonse, imi manzwi abo ku mamani mani e inkanda.” ");
INSERT INTO sbs_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Nihakubabulyo, ni wamba, “Kana Isiraele kana abezi?” Intanzi Mushe uti, “Kani mitangole cha muna kecho chisali che inkanda. Cha mukwa we inkanda ni kusena kuzuwisisa, kani mi tangole mane mubenge.” ");
INSERT INTO sbs_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Linu Isaya abena bundume ha wamba, “Niba wanwa kwabo basana babali kunigana. Niba libonahazi kwabo basana babani kumbili.” ");
INSERT INTO sbs_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Kono kwa Isiraele uwamba, “Musihali onse ni ba wololi mayanza angu kubasa kuteki ni bantu bamahañi.” ");
INSERT INTO sbs_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Ni wamba linu, kana Ireeza aba kani bantu bakwe? Kanji ibi bulyo. Kakuti name bulyo ni mu Isilaele, ni mwihwa wa Abrahama, wo kulusika lwa Benjamini. ");
INSERT INTO sbs_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Ireeza kena aba kani bantu bankwe, abo baba kwizi. Kamwinzi icho mañolo achi wamba kuyamana ni Eliya, umo mwaba kumbilili ni Ireeza kuamana ni Isilaele? ");
INSERT INTO sbs_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Simwine, babehayi batanikizi bako, baba chololi tutala twako. Njime nenke yo shele, mi bakwete kugana buhalo bwangu.” ");
INSERT INTO sbs_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Kono ikalabo ya Ireeza iba wambanzi kwali? “Ni libikile 7000 bakwame baseni kufukamina Baale.” ");
INSERT INTO sbs_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Nihakwina bulyo cwale, heyinu i nako nayo kusina bamwi bashele che baka lyo buiketelo bwa chishemo. ");
INSERT INTO sbs_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Kono haiba kuti che chishemo, kaisili ke mitendo. Kusi bulyo chishemo ni chi sena chibabi chishemo. ");
INSERT INTO sbs_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Chinzi linu? Chintu chi baba kugana ma Isilaele, kahena baba chiwani, kono baketetwe baba chiwani, mi bungi buba zuminizi inkulo: ");
INSERT INTO sbs_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Kwina bobulyo sina mukuñolelwe: “Ireeza ababahi lihuho lwa kubula inzimbo, menso ili kuti kanji baboni, ni matwi ili kuti kanji bazuwi, kuleta linu izuba.” ");
INSERT INTO sbs_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Linu Dafita ucho, “Musiye itafule yabo isanduke ka nyandi ni kaswa, chisitataliso ni bubengiso kuba lwisa. ");
INSERT INTO sbs_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Musiye menso abo a sihiswe ili kuti kanji ba boni. mi ba ongomane misana inako yonse.” ");
INSERT INTO sbs_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Ni wamba cwale, “Kana baba chunchuli kuti mane bawe?” Kanji kubi bulyo. Nihakuba bulyo, cha kukangwa kwabo bene, kuhazwa ku bezi kube chisi, ili kuti ba bengiswe cha muuna. ");
INSERT INTO sbs_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Linu haiba kuti kukangwa kwabo njo bufumu bwe yinu inkanda, mi haiba kuti kusinyehelwa kwabo njo bufumu bu ba Chisi, kumana kwabo muku kanduhe bule? ");
INSERT INTO sbs_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Kono hanu ni wamba kwenu be Chisi. Kubona fela kuti ni muapositola kube Chinsi, Ni hinda buikumuso mumutendo wangu. ");
INSERT INTO sbs_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Mwendi muni minyenze cho muna abo bakwangu che nyama. Mwendi mane mutu haze bamwi kubali. ");
INSERT INTO sbs_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Kakuti haiba kukaniwa kwabo joku bozekeza inkanda, ikamuhelo yabo kaibe bule kono buhalo kuzwa kwa bana fwile? ");
INSERT INTO sbs_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Haiba zilyatu ze intanzi zibikitwe, kwina bulyo ni kubusu bwa chinkwa, Haiba mihisi i babalelwe, mukube bulyo niku mitai. ");
INSERT INTO sbs_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Kono haiba kuti imwi mitai iba choki kwateni, haiba inwe, mutai we samu lye Olive lya muzuka, uba nungwa mwenu, mi haiba muba liyabili nabo mubufumu bwa mihisi ye chikuni che olivi, ");
INSERT INTO sbs_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Kanji muli tundumuni hewulu ye mitai. Kono haiba nimuli tundumuna, kanjenwe mutusa mihisi, kono mihisi itusa inwe. ");
INSERT INTO sbs_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Kamuwambe linu, “Mitai iba konsolwa ili kuti ni nungwe kwateni.” ");
INSERT INTO sbs_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Iyo nje niti. Chebaka lyo kusa zumina kwabo baba cholwa kwateni, kono inwe muzimene cho kukola chebaka lye tumelo yenu. Kanji muli hupuli cho kuli hanzika, kono cho kutiya. ");
INSERT INTO sbs_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Kakuti haiba Ireeza kena aba bukelezi mitai inswanela, nangati inwe kakwina mwasa bukeleze. ");
INSERT INTO sbs_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Mulole hateni, linu, mihato ya chishemo ni bukando bwa Ireeza. Kulimwi iyanza, bukando bubezi ha Manjunda ba bawi. Kono kulimwi inyanza, chishemo cha Ireeza chiza henu, haiba ni muzwila habusu ni mukuluka kwakwe. Kusi bulyo nanwe kamu kosolwe kwateni. ");
INSERT INTO sbs_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Mi mane nabo, haiba kuti nibasa zwili habusu ni kusa zumina kwabo, kaba nungwe mwateni. ");
INSERT INTO sbs_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Kakuti Ireeza usi wola kuba nunga mwateni hape. Mukuti haiba muba kosolwa bulyo kwi samu lye olive lya muzuka, mi cha kusaba ni ka mukulukelwa bulyo baba nungwa kwi samu ilotu lye olive, muchi samu chilotu che olive, kakube bule kwa ba Majunda ili abo mitai tato, mwete ba nungwe hape mwi simu lyabo lye olive? ");
INSERT INTO sbs_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Mukuti kanisaki kuti mwi kale ni musezi, bamwangu, kweyi inkunutu, ili kuti kanji mubi batalifite mukuzeza yenu. Iyi inkunutu yakuti imbali imwi yaku kuku tuhalisa iba tendahali mwa Isilaele, kusikila kwizuzilizwa ku be Chisi chikweza mukati. ");
INSERT INTO sbs_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Kobulyo Isilaele yonse mui i hazwe, sina mukuñolelwe: “Kuzwilila mwa Zioni kakube ni Mulukululi. Mwa zwise kusaba ni bumulimu kwa Jakobo. ");
INSERT INTO sbs_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Mi ichi kachibe chilikani changu na bo, china zwisa zibi zabo.” ");
INSERT INTO sbs_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Kulimwi iyanza kuamana ni evangeli, abo zila kwi neku lyenu. Kulimwi inyanza chokuya cho buiketelo bwe Ireeza, basakiwa chebaka lya ba zimu babo. ");
INSERT INTO sbs_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Kakuti impo ni kusupiwa kwa Ireeza kaku chichiwa. ");
INSERT INTO sbs_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Sina kumatangilo hamusana muba kuku teka Ireeza, kono hanu chimuba tambuli chishemo chebaka lyo kusazuwa kwabo. ");
INSERT INTO sbs_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Mwi nzila iswana, hanu aba Majunda kana babali kusi zuwa. Mupuzo wakuti kacheshemo chitondezi kwenu nabo hanu kuti niba tambula chishemo. ");
INSERT INTO sbs_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Kakuti Ireeza abe yalili bonse che baka lya kuse chilila, njikuti naba bonise chishemo kubose. ");
INSERT INTO sbs_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Oho, butungi bwe chifumu bonse bwa butali ni bwa maano e Ireeza! Kuwoleka bule kusanganiwa kwe nkatulo zakwe, mi inzila zakwe zina kule ni kwi zabahala! ");
INSERT INTO sbs_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","“Kakuti njeni yabezibi muhupulo wa Simwine? Kamba njeni yaba bi muyelezi wakwe? ");
INSERT INTO sbs_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Kamba njeni chetanzi yabahi chintu kwa Ireeza, ili kuti Ireeza amulihe?” ");
INSERT INTO sbs_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Kono kuzwa kwali, ni chakwe, ni kwali, kwina zintu zonse. Kwali kube inkanya kuya kusa mani. Amen. ");
INSERT INTO sbs_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Ni misusuweza cwale, bakwetu, ke chishemo cha Ireeza, kuti mulete mibili yenu ubu chitabelo chi hala, chi jolola, chi tambulwa kwa Ireeza. Uwu njo mutendo wenu usakahala. ");
INSERT INTO sbs_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Kanji muyendeleli ne inu inkanda, kono mube ba chinchitwe chobuhya bwa mano enu. Mutende ichi kuti mwi zibe zilotu, zitambuleha, ni kusaka kushiyeme kwe Ireeza. ");
INSERT INTO sbs_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Kakuti ni wamba, chebaka lye chishemo icho chiba kuhewa kwangu, kuti yense wina mukati kenu kanji bazezi kuti ba bobutokwa ahulu kuhita mubaswanela kuhupulela. Kusibulyo, baswanela kuhupula che nzila yo butali, ubu sina Ireeza habahi kuzumwi ni zumwi itikanyo ye tumelo. ");
INSERT INTO sbs_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Sina hatwina zilama zingi mu mubili wonke, kono kahena kuti zilama zonse zina musebezi uswana. ");
INSERT INTO sbs_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Mwi nzila iswana, inswe tubangi tumubili umwina mwa Kresite, mi tuchilama chimwina kuzumwi ni zumwi. ");
INSERT INTO sbs_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Twina impo zi chinchana cho kuya ke chishemo chi tu bahewa. Haiba impo yo zumwi yo butanikizi, kutendahale bulyo kuya nche ntikanyezo ye ntumelo yakwe. ");
INSERT INTO sbs_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Haiba impo yonzumwi ku sebeza, mumu siye a sebeze. Haiba zumwi wina impo yo kuluta, mumusiye a lute. ");
INSERT INTO sbs_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Haiba zumwi impo yakwe kususuweza, mumusiye a susuweze. Haiba zumwi impo yakwe kuha, mumusiye atende bulyo chekulo yonke. Haiba zumwi impo yakwe ku yendisa, musiye ayendise che ntokomelo. Haiba zumwi impo yakwe kutondeza chishemo, musiye achite cho kusanga. ");
INSERT INTO sbs_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Musiye ilato libe nikusena kuliha. Mukane cheli chibi; mukwatilile icho chilotu. ");
INSERT INTO sbs_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Kuamana nilato lya bamwetu, mube nilato ku zumwi ni zumwi. Kuamana ni kute, mukute zumwi ku zumwi. ");
INSERT INTO sbs_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Kuamana ni ntundamo hande, kanji muhakanyehi. Kuamana ni luhuho, mu nyolelwe. Kuamana ni Simwe, mumu tendele. ");
INSERT INTO sbs_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Musange mwi nsepo imwina nayo kuamana ni zisikezite. Mulisante muma sikuluko enu. Muzwile habusu ku lapela. ");
INSERT INTO sbs_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Muliyabile mu zisakahala kuba zumine. Musake inzila zingi zo kutondeza ikamuhelo. ");
INSERT INTO sbs_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Mufuyaule abo bami nyandisa; mufuyaule mi kanji mukuti. ");
INSERT INTO sbs_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Musange nabo basangite; mulile nabo balila. ");
INSERT INTO sbs_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Mube bo muhupulo uswana ku zumwi ni zumwi. Kanji muhupuli mwi nzila zo kulikumusa, kono mutambule bantu basali wanini. Kanji mutalifi mumi hupulo yenu mubene. ");
INSERT INTO sbs_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Kanji mubozekezi zumwi bubi cho bubi. Mutende bulotu habusu bwabantu bonse. ");
INSERT INTO sbs_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Haiba kuoleka, sina ha kulitingite henu, muhale mwi nkozo ni bantu bonse. ");
INSERT INTO sbs_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Kanji muli lwisi mubene, basakwa, kono muhe inzila kubu kali bwa Ireeza. Sina hakuñoletwe, “Kubozekeza nji kwangu; kani lihise; kuwamba Simwine.” ");
INSERT INTO sbs_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","“Kono haiba chila chenu chifwile inzala, mu mulisike. Haiba ufwile inyota, mumuhe cho kunwa. haiba ni mutenda inchi, kamu kunganye makala o mulilo hamuntwi wakwe.” ");
INSERT INTO sbs_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Kanji mukomiwa ku bubi, kono mukome bubi cho bulotu. ");
INSERT INTO sbs_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Musiye zumwi ni zumwi akuteke ba yendisi bamazimo makando, kakuti kakwina buyendisi kwanda ha buzwa kwa Ireeza. Imi buyendisi bwina kwateni buba ketiwa kwa Ireeza. ");
INSERT INTO sbs_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Kuzwaho iye yokana ubo bunyendisi u lwisanisa intaelo ya Ireeza; imi abo babulwisa kaba wane inkatulo he wulu lyabo bene. ");
INSERT INTO sbs_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Kakuti bayendisi kaba balwisi batenda zishieme, kono kuzitendantu zibi. Kana mulakaza kusatiya iye yo wina ha buyendisi? Pange chi shieme, imi kotambule ku zumininwa kwali. ");
INSERT INTO sbs_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Kakuti iye muhikana wa Ireeza kwako cha kushiama. Kono haiba upanga zibilala, utiye; kakuti iye kahindi mukwale nikusena ibaka. Kakuti iye muhikana wa Ireeza, mubozekezi wo bukali kozo yo panga bubi. ");
INSERT INTO sbs_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Kuzwaho uswanela ku kuteka, isiñi bulyo che ibaka lya bukali, kono hape che ibaka lye zwalo. ");
INSERT INTO sbs_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Ibaka lye chi muliha mutelo nao. Bayendisi ba hikana ba Ireeza, yo tekeleza kwezi zintu cho ku wondelela. ");
INSERT INTO sbs_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Mulife ku zumwi ni zumwi chi kolotwa kubali: mutelo kozo mutelo ku uswanela; chikoloti kozo kuchi kolotwa; kutiya kozo yo tiza; itompo kozo u swanela itompo. ");
INSERT INTO sbs_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Kanji mukoloti zumwi chimwi, kwanda o kusaka zumwi ni zumwi. Kakuti uzo yo saka mwakwe naye wizuziliza intaelo. ");
INSERT INTO sbs_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Milao: “Kanji u pangi busangu, kanji wi hayi, kanji wibi, kanji ulakazi,” imi haiba kwina imwi intaelo nayo, ukungenywe mowu mubamba: “Sake mwako sina molisakila.” ");
INSERT INTO sbs_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Ilato kali holofazi mwako; kuzwaho, ilato li zuziliza mulawo. ");
INSERT INTO sbs_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Chebaka lyezi, mwizi inako, kakuti cheli inako yenu kuti mubuke kuzwa kuku lala. Lyahanu kuhazwa kwetu chikwina hafuhi kuhita hatutanga kuzumina. ");
INSERT INTO sbs_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Masiku chi azwila habusu, imi izuba chilya chuta hafui. Twende linu tubike hembali mitendo ye fifi, imi twende tuzwate zizwato ze seli. ");
INSERT INTO sbs_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Twende tuyende cha kuboneka, sina musihali, isiñi cha kusanga kweinu inkanda kamba kukolwa ahulu; imi kanji tuyendi mu mitendo ya busangu kamba mwi intakazo zisawoleki kusiwa, imi isiñi mwi inkani kamba cho muna. ");
INSERT INTO sbs_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Kono muzwate Simwine Jesu Kirisite, imi kanji muhi chibaka kwi nyama, kwi zuzilikiza intakazo yayo. ");
INSERT INTO sbs_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Mutambule yense yo fokola mwi intumelo, nikusena kuha inkatulo che inkani. ");
INSERT INTO sbs_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Umwina muntu wina intumelo yo kulya chimwi ni chimwi, zumwi yo fokola ulya vulyo zisihu. ");
INSERT INTO sbs_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Imi uzo yolya zonse kanji a nyansilizi uzo yasalyi; imi uzo yasalyi zonse kanji a atuli uzo yolya zonse. Kakuti Ireeza aba mutambuli. ");
INSERT INTO sbs_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Njewe ni, iwe yo atula muhikana yowila kuzumwi? Njikwali habusu bwa muyendisi wakwe kuti uzimana kamba uwa. Kono ka pangiwe kuti a zime, kakuti Simwine u wola kumu tenda kuti a zime. ");
INSERT INTO sbs_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Umwina muntu ukuteka i zuba limwina hewulu lya limwi. Zumwi ukuteka mazuba onse kulikanyeleza. Musiye muntu yense azuwisise mumuhupulo wakwe. ");
INSERT INTO sbs_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Iye yo kuteka izuba, ulikutekela Simwine. Imi iye yolya, ulyila Simwine, kakuti iye uha buitumelo kwa Ireeza. Iye yasalyi, usiya kulyila Simwine, naye bulyo uha buitumelo kwa Ireeza. ");
INSERT INTO sbs_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Kakuti kakwina kwetu yo lihalila iye mwine, imi kakwina yo lifwila iye mwine. ");
INSERT INTO sbs_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Mukuti haiba tuhala, tuhalila Simwine, imi haiba tufwa, tufwila Simwine. Linu haiba tuhala kapa tufwa, tuba Simwine. ");
INSERT INTO sbs_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Kacheli ibaka Kiresite abafwi ni kuhala hape, ili kuti abe Simwine wa bonse bafwile ni bahala. ");
INSERT INTO sbs_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Kono iwe, chinzi hau atula mwako? Linu iwe, chinzi hau nyansiliza mwako? Kakuti iswe twense katu kazime habusu bwe chipula che inkatulo cha Ireeza. ");
INSERT INTO sbs_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Kakuti kuñoletwe, “Kubona nihala,” kuwamba Simwine, “kwangu lyonse izwi ni izwi ka lisungame, imi indimi ni indimi kaihe intumbo kwa Ireeza.” ");
INSERT INTO sbs_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Chobulyo linu, zumwi ni zumwi kwetu mwahe buikalabelo bwakwe kwa Ireeza. ");
INSERT INTO sbs_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Kuzwaho, sanzi tuboleli kuatula zumwi ni zumwi, kono chebaka lyobulyo tuzeze izi, kuti kakwina zumwi yeta bike chisitataliso kapa kuteela mwako. ");
INSERT INTO sbs_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Nizi imi nina muchilikani ni Simwine Jesu, kuti kakwina chilijoloza icho chine. Kwanda yakwe njowola kuchihinda kuti kachijolwele, kwali kachijolwele. ");
INSERT INTO sbs_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Haiba ibaka lya zilyo mukwako uzuwa kuchisa, aho kosiyendi mwi ilato. Sanzi usinyi cha zilyo zako uzo Kiresite yaba fwili. ");
INSERT INTO sbs_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Chobulyo sanzi uzuminini zohupula kuba zishiyeme kuti ziwambiwe ubu zibi. ");
INSERT INTO sbs_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Kakuti mubuso wa Ireeza kawuami zilyo ni kunywa, kono kuama kushiyama, inkozo, imi ni kusanga Muluhuho Lujolola. ");
INSERT INTO sbs_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Kwali iye yotendela Kirisite cheyi inzila utambulwa kwa Ireeza imi uzuminwa ni bantu. ");
INSERT INTO sbs_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Chobulyo linu, twende tu tundamene zintu ze inkozo ne zina zi tuzaka. ");
INSERT INTO sbs_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Sanzi usinyi mutendo wa Ireeza kebaka lya zilyo. Zintu zonse luli zijolola, kono chibi kozuna muntu yolya imi chimuletela kuwa. ");
INSERT INTO sbs_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Kushiyeme kusalya inyama, kapa kunywa i waine, kapa icho chabona mwako kuti chi fosahele. ");
INSERT INTO sbs_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Intumelo yo kwete, ibike mukati kako ni Ireeza, yo fuyoletwe njozo yasa linyansi iye mwine kucha zuminina. ");
INSERT INTO sbs_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Iye yo akanyeha unyanswa ha lya, kakuli kachi zwi mwi intumelo. Imi zonse zisa zwi mwi intumelo chibi. ");
INSERT INTO sbs_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Linu kwetu tukolete tu swanela ku kutusa bufokoli bu ba fokola, imi ni kusa litabisa tubene. ");
INSERT INTO sbs_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Tusiye zumwi ni zumwi kwetu atabise ya bambene naye kwezina zi lotu, ili kuti a zakwe naye. ");
INSERT INTO sbs_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Mi ni heiba Kirisite kena abali tabisi mwine. Nihakubulyo, ibena bo bulyo sina mukuñolelwe, “Matapa abo ba bamituki aba wili hangu.” ");
INSERT INTO sbs_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Kakuti zonse zi bañoletwe ku masule ziba ñolwa che intaelo zetu, ili kuti che inkulonde ni che insusuwezo ya mañolo tube ni insepo. ");
INSERT INTO sbs_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Linu Ireeza we inkulonde ni insusuwezo a mihe mizezo iswana kuzwilila kwa Jesu Kirisite. ");
INSERT INTO sbs_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","A pange bulyo ili kuti cha muzezo umwina ni mulomo umwina mutembe Ireeza ni Isi wa Simwine wetu Jesu Kirisite. ");
INSERT INTO sbs_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Kuzwaho mutambule zumwi ni zumwi sina Kirisite mwa ba mitambwili, chentumbo ya Ireeza. ");
INSERT INTO sbs_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Chingi ni wamba bulyo Kirisite abapangwa buhikana bwa mupato kwi neku lyo buniti bwa Ireeza, cha kwi zuzikiza insepiso zi bahewa ku bazazi, ");
INSERT INTO sbs_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","mi ku Basikunze ni kuha ikanya kwa Ireeza cha chishemo chakwe. Kwina bulyo sina mu kuñolelwe, “Kuzwaho kanihe ikanya mukati ka Basikunze ni kuzimba intumbo che zina lyako.” ");
INSERT INTO sbs_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Hape iti, “Musange, inwe mu Basikunze, ni bantu bakwe.” ");
INSERT INTO sbs_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Mi hape, “Mutembe Simwine, mubose Basikunze; musiye bantu bonse ba mutembe.” ");
INSERT INTO sbs_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Hape, Isaya uti, “Kakube ni muhisi wa Jese, mi iye yesa buke ku yendisa hewulu li Basikunze. Basikunze ka babe ni insepo mwali.” ");
INSERT INTO sbs_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Linu Ireeza we insepo amizuze kusanga ni inkozo yonse cha ku zumina, ili kuti mube ni ku kwatinsana munsepo, cha ziho zo Luhuho Lujolola. ");
INSERT INTO sbs_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Name ni mwine ni zuwisisa chenu, ba mwangu. Ni zuwisisa kuti nanwe bulyo mwi zwile bulotu, kwizula inzibo yonse. Ni zuwisisa kuti nanwe bulyo muwola kuli nyemuna zumwi ni zumwi. ");
INSERT INTO sbs_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Kono ni miñolela cha bundume bungi kwenu cha zintu zimwi ili ku mihupulisa hape, chebaka lye mpo ibahewa ime cha Ireeza. ");
INSERT INTO sbs_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","Iyi mpo ibali kuti ni swanela ku ba ni muhikana wa Jesu Kirisite yo tumitwe ku Basikunze, kuha sina mupurisita ivangeli ya Ireeza. Ni swanela kutenda bulyo ili kuti inubu i Basikunze pona chi itambulwa, ku jolozwa cha Luhuho Lujolola. ");
INSERT INTO sbs_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Imi kusanga kwangu kwina mwa Jesu Kirisite ni muzintu za Ireeza. ");
INSERT INTO sbs_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Njikuti kese ni wambe chimwi kwande yecho Kirisite cha ba maniselezi kuzwa kwangu cha ku kuteka ku Basikunze. Izi zintu zitendwa cha linzwii ni mutendo, ");
INSERT INTO sbs_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","cha ziho za zisupo ni zikomokisa, ni cha ziho za Luhuho Lujolola. Ichi chi bapangahali bulyo kuti kuzwa mwa Jerusalema, mi ni kuzimbuluka umo mane ku kasika kwa Iliriko, ili kuti niwole kutwala linzwi lya Kirisite cho kwizula. ");
INSERT INTO sbs_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Che iyi nzila, intakazo yangu ibali ya kuwamba ivangeli, kono isiñi kwe zibitwe Kirisite chezina, ili kuti kanzi ni zaki hewulu lya mutomo wa zumwi muntu. ");
INSERT INTO sbs_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Mukwikalile sina mu kuñolwe: “Abo kubali basena ba ba wambilwe zakwe mwize mu mubone, mi nabo basena ba bazuwi kaba zuwe.” ");
INSERT INTO sbs_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Kuzwaho ni ba kaniswa tungi kukwiza kwenu. ");
INSERT INTO sbs_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Kono hanu, ka nisina chibaka mwezi zikiliti, mi ni ba lyolelwe cha zillimo zingi kwiza kwenu. ");
INSERT INTO sbs_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Monse muniyendela kwa Sipeini, ni sepa ku mibona ha nihita, mi ni ku nisindikizwa munzila chenu, hani mana ku likola kuli kopanya nanwe che nako zana. ");
INSERT INTO sbs_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Kono hanu ni kaya kwa Jerusalema kuka tendela ba zumine. ");
INSERT INTO sbs_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Sina hakubali kulotu ku tabisa kwa Masedonia ni Akaya kuha chimwi ku basena mukati ka bazumine mwa Jerusalema. ");
INSERT INTO sbs_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Eee, ku bali kutabiswa kwabo, imi, luli, cho kuti ba bali ku bakolota. Mi heiba Basikunze ba bali abeli muzintu zabo za luhuho, ba bakolota nabo cha ku batenda muzintu zi boneka. ");
INSERT INTO sbs_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Kuzwaho, ha ni mana uwu mutendo ni ku bona kuti batambula zonse zi baletwa, ka ni yende kwa Sipeini ni ku mipotela hani hita. ");
INSERT INTO sbs_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Nizi kuti ha nikeza kwenu kani ni ze mu kwizula che mbuyoti ya Kirisite ");
INSERT INTO sbs_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Hanu ni mi susuweza, ba mwangu, cha Simwine wetu Jesu Kirisite, imi ni chelato lya Luhuho, kuti mulike hahulu mubonse name mwi intampelo kwa Ireeza changu. ");
INSERT INTO sbs_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Mulapele kuti ni bukelezwe kwa bana basa kuteki mwa Judea, ili kuti kutenda kwangu mwa Jerusalema ku tambulwe ku bazumine. ");
INSERT INTO sbs_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Mulapele kuti ni ze kwenu che intabo che intato ya Ireeza, ili kuti Ime, hamwina nanwe, ni wane impumulo. ");
INSERT INTO sbs_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Mi Ireeza we inkozo abe nanwe mubonse. Amen. ");
INSERT INTO sbs_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Nimiha bupaki ka nchizyetu Febe, muhikana we nkeleke ina mwa Senkreya, ");
INSERT INTO sbs_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","kutendela kuti mumu tambule che zina lya Simwine. Muchite bulyo sina mubatendela ba zumine, imi mumuzime hembali mumutuse muzintu zonse mwasaka intuso yenu. Kakuti iye mwine kasibili abatusi bantu bangi, mane name bulyo. ");
INSERT INTO sbs_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Mu lumelise Prisila ni Akila niba hikana bangu mumitendo ya Kirisite Jesu, ");
INSERT INTO sbs_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","abo chabuhalo bwangu babali tombweli buhalo bwabo chebaka lyangu. Nilitumela kubali, isiñi ime nenke, kono ni benkele zaba Sikunze bonse. ");
INSERT INTO sbs_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Mu lumelise inkeleke ina munzubo yabo. Mu lumelise musakiwa wangu Epaeneto, iye chichelantu chentanzi kuzumina kwa Kirisite mwinkanda ya Asia. ");
INSERT INTO sbs_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Mu lumelise Maria, yaba misebelezi ahulu. ");
INSERT INTO sbs_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Mu lumelise Androniko ni Juniasi, nchizyangu niba nibena nabo mwintolongo. Bezibahele ahulu mukati ka baapositola, abo babena mwa Kirisite ime niniseni. ");
INSERT INTO sbs_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Mu lumelise Amplias, musakiwa wangu mwa Simwine. ");
INSERT INTO sbs_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Mu lumelise Urbano, mutendi wetu mwa Kirisite, ni Stakisi ini suna. ");
INSERT INTO sbs_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Mu lumelise Apelles, yozuminwa mwa Kirisite. Mu lumelise bena munzubo ya Aristobulusi. ");
INSERT INTO sbs_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Mu lumelise Herodioni nchinzyangu, mu lumelise abo benzubo ya Narsiso bena mwa Simwine. ");
INSERT INTO sbs_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Mu lumelise Trifena ni Trifosa, basebeza ahulu mwa Simwine, Mu lumelise ni Persida ini suna, yaba sebezi ahulu mwa Simwine. ");
INSERT INTO sbs_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Mu lumelise Rufus, yoketetwe mwa Simwine, niba nyina ni bangu, ");
INSERT INTO sbs_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Mu lumelise Asinkrito, Flegono, Hermesi, Patrobasi, Hermasi ni bamwabo bena nabo. ");
INSERT INTO sbs_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Mu lumelise Philologus, Julia, Nerea ni nchizye, Olimpa ni bazumine bonse babena nabo. ");
INSERT INTO sbs_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Mu lumelisane cha kuli chunchuna kujolola. Inkeleke zonse za Kirisite zimi lumelisa. ");
INSERT INTO sbs_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Linu ni misusuweza, bamwangu, kuti muhupule abo baleta kukauhanya ni kusitatalisa. Chiba hitilila intuto imuba lutwa. Muzwe kubali. ");
INSERT INTO sbs_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Bantu bakola ubu njaba kabasebelezi Simwine Kirisite wetu, kono mabumo abo. Cha buhuba bwabo ni manzwi atu shambwe shambwe bachengelela inkulo ziba sena mulandu. ");
INSERT INTO sbs_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Cha mutala wenu wa kukuteka usika kuzumwi ni zumwi. Nisanga, kuzwaho, henu, kono nisaka inwe kuti mutalife kuzishiyeme, imi ni kusaba ni mulandu kuzi sashiyeme. ");
INSERT INTO sbs_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Ireeza we inkozo mwalyatolele Satani kunsi ya matende enu cha kuhwela. Imi chishemo cha Simwine wetu Jesu Kirisite chibe nanwe. ");
INSERT INTO sbs_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timotea, ini sebeza naye, umi lumelisa, ni Lusiusi, Jasoni, ni Sosipatere, nchizyangu. ");
INSERT INTO sbs_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Ime, Teriusi yoñola ili ñolo hanzi, mulumele mwa Simwine. ");
INSERT INTO sbs_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gayusi, kunikala nibe inkeleke bonse, ba milumelisa. Erasto, mutuli wa masheleni e tolopo, umi lumelisa ni Kwato mwakwe. ");
INSERT INTO sbs_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","“Imi chishemo cha Simwine Jesu Kirisite chibe nanwe mwense. Amen.” ");
INSERT INTO sbs_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Linu intumbo zibe kwali yowola kumizimika kuya che ivangeli ni inkutazo za Jesu Kirisite, ");
INSERT INTO sbs_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","chakuya che insinulo ye inkunutu ibaungwilwe kuzwa ukoo, kono hanu chiya patululwa, kuya cha muñolelo wa chipolofita chize zibahala kwinkanda zonse, kuya che intaelo ya Ireeza wa kuya ku samani, cha kukuteka intumelo. ");
INSERT INTO sbs_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Kwa Ireeza umwina yo talifite, cha Jesu Kirisite, kube ikanya isamani. Amen. ");
INSERT INTO sbs_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Paulusi, ava sumpwa kwa Jesu Kreste ku va muapositola che tanto ya Ireeza, mi ni Sosthene mukwetu, ");
INSERT INTO sbs_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","kwi kereke ye Ireeza ya Makorinte, kwavo va va njolozwa ni Jesu Kreste, va supitwe ku va vantu va njolola. Tu ñolela vulyo vonse avo va supa izina lya Simwine Jesu Kreste mu zivaka zonse, Simwine wavo ni wetu. ");
INSERT INTO sbs_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Chishemo ni konzo zi ve kwenu kuzwilila kwe Reeza Muzazi wetu ni Simwine Jesu Kreste. ");
INSERT INTO sbs_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Inako yonse ni litumela kwe Reeza wangu chenu vakeñi cha chishemo che Reeza chi va hewa kwenu cha Jesu Kreste. ");
INSERT INTO sbs_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","A vami tendi va vahumi mwi nzila zonse, ni mu zi wambo zonse ni nzivo yonse, ");
INSERT INTO sbs_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","sina ha kuva pakiwa za Jesu Kreste zi ve zuzilizwa ku va zeniti mukati kenu. ");
INSERT INTO sbs_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Linu hanu ka mu vulite impo za luhuho sina ha mu lindile zi ungilwe za Simwine Jesu Kreste. ");
INSERT INTO sbs_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Ka wole ku mi koza ku twala ku ma manimani, kutendela kuti mu vule kusa swaviswa mwi zuva lya Simwine wetu Jesu Kreste. ");
INSERT INTO sbs_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Ireeza u sepahala, ya va mi sumpi kuva mu chilikani cha Mwan'a kwe, Jesu Kreste Simwin”e tu. ");
INSERT INTO sbs_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Linu ni mi kumbila, vakwangu, che zina lya Simwine Jesu Kreste, kuti mwese mu zumina, mi kuti sanzi ku vi ni kauhano mukati kenu. Ni mi kumbila kuti mu kopane ha mwina che ngana yonke ni mutendo u swana. ");
INSERT INTO sbs_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Imi iva vikwa munzila yi zuweka kwangu, va kwangu, cha vantu va Kloe kuti mitendo yavo yi tendahale mukati kenu. ");
INSERT INTO sbs_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Chi ni wamba nje chi: zumwi ni zumwi kwenu ati, “ni wa Paulusi,” kapa “wa Apolosi,” kapa wa Kefasi; kapa ni wa Kreste. ");
INSERT INTO sbs_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Nji kuti Kreste u kauhene? Kana Paulusi ava kokotelwa ka chenu? Kana mu va kolovezwa mwi nzina lya Paulusi? ");
INSERT INTO sbs_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Ni litumela kwe Reeza kuti kana ni va kolovezi nangati umwina kwenu, kunde a Krispusi ni Gaius. ");
INSERT INTO sbs_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Ku vavi vulyo ku tendela kuti ka kwina nangati umwina yo wamba kuti ava kolovezwa mwi nzina lwa ngu. ");
INSERT INTO sbs_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","(Ni va kolovezi vulyo ni vezuvo ya Setefanisi. Kuzwaho, kanizi heva ni va kolovezi vamwi.) ");
INSERT INTO sbs_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Imi Kreste kena avani tumi kwiza ku koloveza kono kwiza ku ruta linzwi. Kena avani tumi kwiza ku ku ruta cha manzwi a vutali vwa muntu, kutendela kuti chifapano cha Kreste sanzi chivuli ziho. ");
INSERT INTO sbs_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Imi ituto kuamana ni chifapano ivonisa vuholo kwavo va chi vafwa. Kono mukati kavo avo va kwete kuhaza Ireeza, ziho ze Reeza. ");
INSERT INTO sbs_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Imi ku ñoletwe, “Mu ni sinye vutali bwavo vena vutali. Mu ni filikanye yi kutwisiso ya wina maano.” ");
INSERT INTO sbs_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Winahi muntu muchinu? winahi muñoli? winahi Muwambi we nako zinu za sunu? Kena kuti Ireeza ava sanduli maano e kanda kuva isena intuso? ");
INSERT INTO sbs_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Kuzwila uko inkanda kena ivena maano akwi ziva Ireeza, ku va sangisi Ireeza chavo ziholeluli va sena va vena maano a ku ruta za ku lukulula avo va zumina. ");
INSERT INTO sbs_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Majuda va saka imakazo mi Magerike va saka maano. ");
INSERT INTO sbs_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Iswe tukutaza Kreste ya va kokotelwa, chi sitataliso ku Majuda ni vuholo luli ku Magerike. ");
INSERT INTO sbs_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Kono kwavo vava sumpi Ireeza, vonse Majuda ni Magerike, tu ruta Kreste ziho ni maano a Ireeza. ");
INSERT INTO sbs_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Imi vuholo luli vwe Reeza vwina vutali luli kuhita vwa vantu, mi ku vula ziho luli kwe Reeza ku kolete kuzamba kwa vantu. ");
INSERT INTO sbs_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Mu lole ipinzo zenu, vakwangu, kena vungi vwenu vena maano ena mazimo a vuntu. Kena vungi vwenu va vena ziho. Kena vungi vwenu va pepywa nenza. ");
INSERT INTO sbs_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Kono Ireeza ava keti zintu mwi inkanda zivoneka vuhole ku swavisa vatali. Ireeza ava keti zi sena ziho mwi inkanda ku swavisa vena ziho. ");
INSERT INTO sbs_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Ireeza ava keti zintu ze inkanda hansi ni zikendetwe. Ava keti vulyo ni zintu zi vonahala kuva zi sena tuso, ni zi sa kwina ni zina kwateni ava zitendi ku sa va za vutokwa. ");
INSERT INTO sbs_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Ava tendi vulyo kutendela kuti ka kwina yo swanela kuli katula havusu vwakwe. ");
INSERT INTO sbs_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Vakeñi cha va tendi Ireeza, hanu twina kwa Jesu Kreste, ya va tendwa maano kwetu ke Reeza. Avavi yo shiyeme, yo njolwezwe, ni mu sumununwa. ");
INSERT INTO sbs_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Che kalavo, sina linzwi ha li wamba, “mu siye yo liyemuna, ali nyemune mwi zina ya Simwine.” ");
INSERT INTO sbs_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Linu, hani za kwenu, vakwangu, Kana na keza ni bulotu bukando vwa ziwambo nanta vwa vutali sina ani wamba vuniti vu liungwile vu amana ni Ireeza. ");
INSERT INTO sbs_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Kokuti ni va liketeli kuse ziva chimwi hani vena mukati kenu kunde a Jesu Kreste ya va hanzikwa ha chi fapano. ");
INSERT INTO sbs_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Mini vena nanwe muvu fokoli, ni mulyowa ni ku cha cha ahulu. ");
INSERT INTO sbs_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Imi mwi ñusa lyangu ni muku wamba kwangu vwangu kana kuvena za kumi koza mu manzwi a vutali. ");
INSERT INTO sbs_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","Kokuti itumelo enu kazi ivi ya vutali vwa vantu, kono che ziho ze Ireeza. ");
INSERT INTO sbs_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Hanu, tu wamba cha vutali mukiti kava kulite, kono, isiñi cho vutali vwe kanda, kapa va vusi ve inu' nako, vakwe vafwe. ");
INSERT INTO sbs_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Kono, tuwamba vatali vwa Ireeza mwi niti ili wungwile. Vatali vu unguli Ireeza nako ni seni kuva kwateni kuti iswe tube ni kanya. ");
INSERT INTO sbs_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Ka kwina ku va yendisi ve yi nako vave zi u vu vutali, kambe vava vu zuwisisi ine nako, niva sana vava hanziki Simwine we kanya. ");
INSERT INTO sbs_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Kono kuva ñoletwe, “zintu zisana ziva vav onwa, zi sina zi va zuiwa matwi, ni zi sana zi vezi mu mihupulo. Zintu Ireeza zava lukiseze ava va musaka.” ");
INSERT INTO sbs_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Izi nji zintu za va tutondezi Ireeza cha luhuho. Kokuti luhuho lusa kisisa zintu zonse, nanga nezo zintu zi li ungwile ze Ireeza. ");
INSERT INTO sbs_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Njeni wizi mihupulo ya muntu, kunde ya luhuho lwa muntu lwina mwali? Vulyo hape, kawina wizi zintu ze Ireeza zi li u ngwile kunde a luhuho lwe Ireeza. ");
INSERT INTO sbs_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Kono kana tuva tumbuli luhuho lwe kwanda, kono luhuho luzwa kwa Ireeza. Kokuti twizive zintu ziva hewa fela kwetu cha Ireeza. ");
INSERT INTO sbs_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Tu wamba zhizi zintu mu mazwi a vutali uvo muntu kaoli ku ruta, kono, luhuho lutu ruta. Luhuho lutoloka mazwi a luhuho ni vutali vwa luhuho. ");
INSERT INTO sbs_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Muntu ya sena luhuho lwe Ireeza, kaoli kutambula zintu ze luhuho lwe Ireeza, kokuti kwali za vuholo. Kaoli kwizi ziva kakuli zi patululwa vulyo cha luhuho lujolola lwe Ireeza. ");
INSERT INTO sbs_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Wina luhuho lujolula u atula zintu zonse, kono kena inswanelo yaku atula va mwi. ");
INSERT INTO sbs_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Njeni yo ula kwiza muhupulo we Ireeza, yo wola ku mulaya. Kono, twina muhupulo wa Kreste. ");
INSERT INTO sbs_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Mi ime, vakwanugu, kana ni va kuwola kuwamba kwenu uva vantu vo luhuho, kono uvu vantu ve nyama uvu muchiche mwa Kreste. ");
INSERT INTO sbs_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Niva milele cha muzilili isiñi che nyama, kana muva litukiseze inyama. Mi, ni heva hanu, ka mulitukiseze. ");
INSERT INTO sbs_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Mi musina mwi nyama, mi kwina ifufa niku sazumi nzana ku sina mukati kenu, kamu hali che nyama, mi ka muyendi cha mazimo avuntu. ");
INSERT INTO sbs_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Mi zumwi hawamba, ni chilila Paulusi, zumwi uti ni chilila Apolosi, kamuhali uvu vantu na? ");
INSERT INTO sbs_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Njeni Apolosi linu, mi Paulusi njeni? Vahikana avo vamu va kuzumina, avo vava hewa musevezi kwa Simwine. ");
INSERT INTO sbs_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Niva vwali, Apolosi ave tilele, kono Ireeza ava ku kuzi. ");
INSERT INTO sbs_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Mi linu, yo vwala ni yowi tilele kakwina. Kono nji Ireeza yokuza. ");
INSERT INTO sbs_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Hanu, uvwala ni yowitilela umwina. Mi zumwi ni zumwi kalihiwe cha musevezi wakwe. ");
INSERT INTO sbs_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Tuva veleki ba Ireeza, mwiwa lye Ireeza, muzako wa Ireeza. ");
INSERT INTO sbs_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Kuya ka chishemo che Ireeza chi va hewa kwangu che ntuto ya kwi ziva kuzaka, ni va vatangi intungo mi zumwi u zaka hateni. ");
INSERT INTO sbs_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Linu mutokomele zumwi ni zumwi atokomele mwate azakile hateni. Kokuti kakwina yo ola kutunga intungo kunde yo zuna ya va itangi, nji Jesu Kreste. ");
INSERT INTO sbs_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Ha hanu, haiva zumwi na zaka hentungo che gauda, silivera, cha mavwe a sepahala, zisamu, zilyo ze ñombe, kapa lyani, ");
INSERT INTO sbs_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","musevezi wakwe ka u putululwe, mwete ni kupatulwe mwi nako ya mulilo. Mulilo kaulike musevezi wava tendi zumwi ni zumwi. ");
INSERT INTO sbs_vpl VALUES ("C13_14","076_3_14","1CO","3","14","15","Haiva misevezi ya zumwi ni zumwi ni izi mana, mwa tambule inkavelo; kono haiva musevezi wa zumwi ni zumwi ni uhiswa, mwa nyande, kono iye mwine mwa puluswe, cha ku vanduka ku mulilo. ");
INSERT INTO sbs_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Kana mwizi kuti mwi tempele ya Ireeza ni kuti Luhuho lwe Ireeza luhala mwenu. ");
INSERT INTO sbs_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Haiva zumwi na haya itempele ye Ireeza, Ireeza mwe haye zuna muntu. Imi itempele ye Ireeza i jolola, mumu ikalile nanwe. ");
INSERT INTO sbs_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Kanzi kuvi niyo lichenga mwine. Haiva zumwi mukati kenu uhupula kuti wina vutali mwe inu' nako, mu mu siye ave “cihole” mukuti ave yo talifite. ");
INSERT INTO sbs_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Mokuti vutali vwe inu ikanda kwa Ireeza vuholo. Mi ku ñoletwe, “U wonda vatalifite muvu vilala vwavo.” ");
INSERT INTO sbs_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Mi hape, “Ireeza wizi kuti mi hupulelo ya vatali kakwina.” ");
INSERT INTO sbs_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Linu ka kusina kulitemba cha vantu! Kakuti zintu zonse nji zenu, ");
INSERT INTO sbs_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","kapa Paulusi, kapa Apolosi, Kefesi, kapa inkanda, kapa vuhalo, kapa ifu, kapa zintu zina kwateni, kapa zintu zi sike zite. Zintu zonse nji zenu, ");
INSERT INTO sbs_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","mi muva Kreste mi Kreste we Ireeza. ");
INSERT INTO sbs_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Nji mona vovuti muntu mwa swanela kutu hindila, sina va hikana va Kreste ni va hikana va humbilwe vuniti vwa Ireeza. ");
INSERT INTO sbs_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Mwe chi chilikani, nji zi zumi ninwe ku va kuti mu ve mu va hikana va sepahala. ");
INSERT INTO sbs_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Kono kwangu chintu chinini kuti ni atulwe inwe kapa muntu vulyo wa mulao. Imi kani atuli ime ni mwine. ");
INSERT INTO sbs_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Ka kwina nangati chonke chinizi kuya c